﻿USE sofia;
DROP TABLE IF EXISTS sofia.zypNT_vpl;
CREATE TABLE zypNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zypNT_vpl WRITE;
INSERT INTO zypNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham pathlah, David pathlah a cangpaw Zisu Khri thokehnah cazing leco, ");
INSERT INTO zypNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham cawh Isak a paw cang ka, Isak cawh Jakob a paw a cang. Jakob cawh Judah le a uny sahlo aa paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah cawh Perez le Zera aa paw cang ka, aa no cawh Tama a cang. Perez cawh Hezron a paw cang ka, Hezron cawh Ram a paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram cawh Aminada a paw cang ka, Aminada cawh Nashon a paw a cang. Nashon cawh Salmon a paw a cang, ");
INSERT INTO zypNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon cawh Boaz a paw cang ka, a no cawh Rahab a cang. Boaz cawh Obed a paw cang ka, a no cawh Ruth a cang. Obed cawh Jesi a paw cang ka, ");
INSERT INTO zypNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi cawh siangpahrang David a paw a cang. David cawh Solomon a paw cang ka, Solomon a no cawh Uria a nupui tawpaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon cawh Rehoboam a paw cang ka, Rehoboam cawh Abija a paw a cang. Abija cawh Asa a paw cang ka, ");
INSERT INTO zypNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa cawh Jehoshafat a paw a cang. Jehoshafat cawh Jehoram a paw cang ka, Jehoram cawh Uziah a paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziah cawh Jotham a paw cang ka, Jotham cawh Ahas a paw a cang. Ahas cawh Hezekia a paw cang ka, ");
INSERT INTO zypNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia cawh Manaseh a paw a cang. Manaseh cawh Amon a paw cang ka, Amon cawh Josai a paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josai cawh Jekhonia le a uny sahlo aa paw cang ka, ma cai leco Babilon raang lang khah sae tah seikhui a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon raang lang sae tah seikhui aa cang khy taiteipaw: Jekhonia cawh Shealtia a paw a cang. Shealtia cawh Zerubabel a paw cang ka, ");
INSERT INTO zypNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel cawh Abiud a paw a cang. Abiud cawh Eliakim a paw cang ka, Eliakim cawh Azor a paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor cawh Zadok a paw cang ka, Zadok cawh Akhim a paw a cang. Akhim cawh Eliud a paw cang ka, ");
INSERT INTO zypNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud cawh Eleazar a paw a cang. Eleazar cawh Mathan a paw cang ka, Mathan cawh Jakob a paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob cawh Khri tatei aa tahpaw Zisu a no Mari a pasaepaw Josef a paw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma hrahei Abraham taitah David tai letah chaihraw hluipali, David taitah Babilon raang lang sae tah seikhui aa cangnah tai letah chaihraw hluipali, sae tah seikhui aa cangnah taitah Khri a pinah tai letah chaihraw hluipali a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zisu Khri a pinah konglang cawh ma hrahei a cang. A no Mari cawh Josef khatah a pahlawng pawtah pahapaw a cang. Canghrasala aa pahlawng hlai he tah Mari cawh Thlawpaw Pathai hmingtuakhynah thongtah sawtei a pho. ");
INSERT INTO zypNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A pasae ruapaw Josef cawh mehding mehchaw a cangnah cawtah mingzawpui hme letah Mari a ningzawsah khah du be ca ka, kaa pahlawng peh aa tahpaw khah aparuh teitah bia ka pheh kaw a tatah a pacang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Canghrasala, ma hratei a pacang khy taico, Abuipaw a vaiming pakheh cawh ama khatah a mang letah a za paly ka, a hai letah, “David pathlah a cangpaw Josef, Mari cawh nupui rua tah chui pawtah lung ngerai lytah ung kheh. Zecawtamaw tatah punglong lytah a cangpaw khah Thlawpaw Pathai thongtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sawcapaw sah a ka, a ming tah Zisu na sá a. Zecawtamaw tatah Ama taco a cawngsaw sahlo khah aa suanah taitah a pachá he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma hming vytei a va ungpaw heh Abuipaw tah Khazing khuavang hmang tei a reipaw: ");
INSERT INTO zypNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Laisaw pathai tah sawtei pho ka, sawcapaw a sá a, Ama cawh Immanuel tatah aa y a,” tatah a tah. Immanuel a silang cawh, “Khazing kaaning khatah a ung,” tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josef cawh a ka hraw tihtah Abuipaw a vaiming tei a chingpaw hrakhei tua ka, Mari cawh nupui ruapaw takhei ing lang cawh a chui. ");
INSERT INTO zypNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Canghrasala sawcapaw a sah hlai vytei khah cawh ung hrui be. Taico sawcapaw a sahpaw cawh Zisu tatah ming a sah. ");
INSERT INTO zypNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Zisu cawh Herod siangpahrang a cang chung tah Judia raang, Bethlehem khua letah a pi khy taitah nichualang taikhei mehsing sahlo cawh Jerusalem khuapui lang a vong he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda cawngsaw aa siangpahrang rua pawtah a pipaw cawngsawpaw cawh zeletamaw a ung? Nichualang letah a esi hmuh he peh ka, Ama beh rua pawtah kaa va chua hi,” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma bia cawh Herod tah a thui tihtah a thlawzawng ka, ma hraco Jerusalem khua cawngsaw vytei zong a cang hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mataico, tlangbui macang vytei le phungbia cawngpahtu vytei khah hmingkheh tah y he ka, Khri a pinah cawh zeletamaw a cang a tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Taico aaning taco, “Judia raang, Bethlehem khua letah,” tatah aa palei. “Zecawtamaw tatah Khazing khuavang tah a ciapaw cawh: ");
INSERT INTO zypNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nama, Bethlehem, Judah raang chung letei a ungpaw cawh Judah uhtu sahlo hrong letah chia cai bei ceh, zecawtamaw tatah nama taitah uhtu, ka cawngsaw Israel tuukingtu a cang ruapaw cawh a va chua a,’ a tahpaw heh a cang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mataico, Herod tah mehsing sahlo cawh aparuh teitah y he ka, zetih cai letah maw esi a paly tahpaw khah hae pase he ka, a hni. ");
INSERT INTO zypNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aaning sahlo cawh Bethlehem khua lang khah taw he ka, aa hai letah, “Va sei la, nysai cawh achaw teitah va hui my lo. Naa hmuh cangkawleh va pa thui sá la, kama zong va sei neh ka, ka beh hra a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Abui Herod bia cawh aa nawthlia khy taitah seithlah he ka, nichualang letei aa hmuhpaw esi takhei langhme cawh chui he ka, nysai a ungnah dihdong lalei lekhei esi cawh a cali. ");
INSERT INTO zypNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Esi cawh aa hmuh tihtah aa thaw a chah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ing chunglang cawh a za nae he ka, nysai cawh a no Mari khakhei aa hmuh he. Taico aa khuh panai he ka, nysai cawh aa beh. Mataico aa chosung cawh hong he ka, lahsong takhei sui le sathy ringthopaw le mura ringthopaw sahlo khah aa peh. ");
INSERT INTO zypNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Taico, Herod khatah sei kaw ly rua pawtah aa mang letah ching aa cangnah cawtah aa raang lang cawh lang hringpaw lang khei aa tlung. ");
INSERT INTO zypNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aaning sahlo aa seithlah khy taico Abuipaw a vaiming pakheh cawh Josef khaco a mang letah a za paly ka, “Tho tua, nysai le a no cawh thokhui la, Izipt raang lang saikhui o. Ka ca ching kaw hlai chung cawh ma leco va ung thlang my lo, zecawtamaw tatah Herod tah nysai heh thaw pawtah a hui a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Macawtaco tho ka, nysai le a no cawh zai taco, Izipt raang lang a saikhui he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma leco Herod a thih hlai vytei aa va ung. Ma heh Abuipaw tah Khazing khuavang hmokaw tei, “Ka Sawcapaw cawh Izipt raang taitah ka y chua a,” a tahpaw bia a tlingnah cawtah khei a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod taco mehsing sahlo tah aa pa dungkhei tahpaw khah a hni tihtah a thingae ka, mehsing tei aa chingpaw cai khei tuatang ka, Bethlehem khua le a kaekang khua sahlo letei kung hning taitah a rai lang capaw nyheh vytei khah thaw thlu pawtah khei bia a peh he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma heh Khazing khuavang Jeremai hmokaw tei a reipaw: ");
INSERT INTO zypNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama khua letah o thui neh ka, caw o le ysangnah o a cang. Rachel tah a sawtei leh cawkhui he ka, pangang khypaw cang be, zecawtamaw tatah a tangpaw ung bei he,” tahpaw bia a tlingnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod a thih khy taitah Abuipaw a vaiming cawh Izipt raang leco Josef khatah a mang leco a za paly ka, ");
INSERT INTO zypNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Tho la, nysai le a no khah law la, Israel raang lang sei myca o, zecawtamaw tatah nysai thaw a pachiapaw cawngsaw sahlo khah a thi thah he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Macawtaco tho ka, nysai le a no cawh Israel raang lang cawh a seikhui he. ");
INSERT INTO zypNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Canghrasala Arkelau cawh a paw Herod dawhming letah Judia raang uhtu tah a va cang tahpaw khah a thui tihtah va sei rua pawtah khei a ci. A mang letah raeringnah peh a cangnah cawtah khei Galili raang lang tukhah a paleh ka, ");
INSERT INTO zypNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret aa tahpaw khua lang va sei ka, ma leco a va ung. Ma heh Khazing khuavang sahlo hmokaw tei aa reipaw, “Ama cawh Nazaret cawngsaw tatah y a cang a,” tahpaw bia tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma ningcai leco baptisma peitu Johan va chuh ka, Judia raang, raangcaa letah phung a rei. ");
INSERT INTO zypNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Vaicung painah raang cawh a ne myca cawtah naa suanah a ngepachih myca law,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ama heh Khazing khuavang Isaiah hmokaw hmang tei reipaw, “Raangcaa letei a y leimeipaw o taco, ‘Abuipaw cawtah langpui parai la, a cawtah langpui pading pah my lo,’ a tah,” tahpaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johan a chaichi cawh sahisy hming tah tawpaw cang ka, saving tesong a te letah a song. A batui cawh khybawh le akhui tui a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem cawngsaw sahlo le Judia raang chung vytei taitah cawngsaw sahlo le Jordan tuivaw hrong leteipaw cawngsaw sahlo cawh Johan khaco a vaw he. ");
INSERT INTO zypNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Khazing letah aa suanah phy he ka, Jordan tuivaw letah baptisma a cangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Canghrasala baptisma a cangsahnah pawhe lang khah Farasi le Sadusi cawngsaw sahlo aa va chuapaw khah a hmuh tihtah aa hai leco, “Naaning, pari cangmai pathlah sahlo, Khazing thingaenah a va chuh leimeipaw heh saisai rua pawtah aho tamaw a ca ching he? ");
INSERT INTO zypNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na ngepachihnah he ceh cawh a thuipa tah palang my lo! ");
INSERT INTO zypNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Taico, ‘Abraham pathlah sahlo kaa cang peh,’ tatah tah leimei khe o. Ka ca ching he hi, Khazing taco ma alung sahlo heh Abraham sawtei sahlo tah a tua khy thlang he hi. ");
INSERT INTO zypNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Thingkung hrang maikaw letah ahrui aa chia thlu thah. Thui chaw a thui lypaw thingkung maikaw cawh hyhly tah me lang bo a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kama taco angepachihnah cawtah tui tah baptisma ka ca cangsah he. Canghrasala ka hninglang tei a va chuh lepaw cawh kama navy tah a rungnaw vypaw a cang. Kama cawh a phepakong a tlepah lai tlang hmai cang bei neh. Ama taco Thlawpaw Pathai le me tah baptisma a ca cangsá he a. ");
INSERT INTO zypNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Saze zeinah cawh a kiá tah tle ka, phuhri letah saze cawh a zei a, achang khah apaang letah rai a ka, asi khah a thi thai lypaw me lang a bo a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mataico, Zisu cawh Galili raang taitah Jordan tuivaw lang khah Johan tah baptisma cangsah rua pawtah khei a vong. ");
INSERT INTO zypNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Canghrasala, Johan takhei thly a zawng ka, a hai letah, “Nama tutah baptisma pa cangsá bei ceh maw, kama kha na vong laky thlang!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Zisu taco, “Atoheh cawh ma hrahei cang thlang seh. Dingnah vytei tling sá pawtah ma tua heh kaa cawtah a tlahpaw a cang,” tatah a palei. Mataico Johan zong a naw a tlah. ");
INSERT INTO zypNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zisu cawh baptisma a cang. Tui taitah a ka pia cangkawleh avai a hong ka, Khazing Thlawpaw cawh thury hratah za cung katei a cung letah a cawngpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Taico avai taitah o za ring ka, “Ma heh ka dopaw ka Sawcapaw cawh a cang. Ama letah ka lung a lawng ngetei,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mataico, Zisu cawh Thlawpaw takhei Setan tah tuhso ná seh tah ka, raangcaa lang a seikhui. ");
INSERT INTO zypNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ning songli le zai songli batui cahe tah a ungnah cawtah a ngai a di ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tuhsotu cawh Ama kha a vong ka, a hai letah, “Khazing Sawcapaw na cang caco, ma alung sahlo heh very tah cang law tah ca,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Zisu taco, “Khazing bia letah ma hrahei ciapaw a cang, ‘Cawngsaw heh very suipaw tah a hring tlung be, Khazing hmokaw taitah a chuhpaw bia maikaw tah a hring hri,’ tah a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mataico, Setan taco Zisu cawh khuapui pathai Jerusalem lang khah seikhui ka, behnah ing a sangcainah ing cung lekhei a dawsah ka, ");
INSERT INTO zypNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Khazing Sawcapaw na cang caco, ma taihei a zythlah tua. Zecawtamaw tatah ma hrahei cia a cang, ‘Nama na kong lehei Khazing tah a vaiming sahlo khah naw pei a he ka, na phe cawh alung letah na khawng ly nápawtah aa kiá tah aa ca caling a,’ a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zisu tah, “Ma hrahei ciapaw a cang, ‘Abuipaw na Khazing cawh hnehsah kheh,’ tah a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Setan taco Zisu cawh tlaang saang ngeteipaw lang kekhui ka, khazaw painah raang vytei le aa rungnawnah vytei khah a ming sah. ");
INSERT INTO zypNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Khuh panai tah na pa beh caco, ma vytei heh ka ca pae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zisu taco, “Setan, seihly myca! Zecawtamaw tatah Capathai letah ma hrahei cia a cang, ‘Abuipaw na Khazing khah beh la, Ama a rai suipaw hre my lo,’ tahpaw a cang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mataico Setan taco seisai ka, vaiming sahlo cawh a vong he ka, Ama cawh aa mingkai. ");
INSERT INTO zypNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Johan thong a tlah tahpaw khah Zisu tah a thui tihtah Galili raang lang a paleh kaw. ");
INSERT INTO zypNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret khua khah piasai ka, sei ka, Zebulun le Naftali raang letei a ungpaw Galili rili kae khua a cangpaw Kapernaum lekhei a va ung. ");
INSERT INTO zypNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ma heh Khazing khuavang Isaiah hmokaw tei reipaw, ");
INSERT INTO zypNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun raang le Naftali raang, Jordan tuivaw hrong tei rili lang seinah, Gental cawngsaw sahlo ungnah Galili, ");
INSERT INTO zypNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","a zingnah letei a ungpaw cawngsaw sahlo tah, khainah rungnawpaw aa hmuh myca, thihnah raang ningpahlipaw letah a ungpaw sahlo cung letah, khainah khua a dui myca,” tahpaw a tlingnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ma cai taico Zisu cawh phungrei patho ka, “Vaicung painah raang a ne myca cawtah naa suanah a ngepachih tua o,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zisu cawh Galili rili ngaekang letah a khiakaly ning takhei uny pahning Piter aa tahpaw Simon le a unypaw Andru khah a hmuh he. Aaning cawh ngawtletu cang he ka, tuili letah aso aa va leimei. ");
INSERT INTO zypNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zisu taco, “A vong la, va pa zui o, cawngsaw a tletu tah ka ca tua he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma cangkaw leco, aa so sahlo cawh seisai he ka, Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mataico va sei vy ka, ahringpaw uny pahning Zebedi a sawcapaw Jeims le a unypaw Johan khah a hmuh he. Aaning cawh aa paw Zebedi khakhei tuilawng chung letah ung thlang he ka, aa so sahlo khah aa thei leimei. Zisu taco y he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma cangkaw leco, aa lawng le aa paw cawh seisai he ka, Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zisu cawh Galili raang chung lekhei a khia ka, synagog sahlo lekhei a cawngpah he. Vaicung painah raang kong thawngchawbia khah ching he ka, asawnah maikaw le danglynah maikaw taikhei aa sahpaw sahlo khah a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A thongpang cawh Siria raang pungpaluh lekhei a thang ka, asawnah a phingphing tei aa sahpaw sahlo, hmawchia aa ingpaw sahlo, khachia tei a tlepaw sahlo, hruihri aa hnuipaw sahlo le a songpaw sahlo khah cawngsaw taco Ama khatah va chuakhui he ka, a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galili raang, Dekapoli raang, Jerusalem khuapui le Judia raang le Jordan tuivaw raechai lang raang tahpaw sahlo taikhei cawngsaw rungpui tah Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cawngsaw rungpui cawh a hmuh tih he tah tlaang cung lang cawh ke ka, a ty. A hningzuitu sahlo cawh Ama kha a vong he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","a cawngpah he. A reipaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Thlawpaw letei a sisahpaw sahlo cawh bonghnang aa ting, zecawtamaw tatah vaicung painah raang cawh aaning sahlo aa cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mangchia sá tah a ungpaw sahlo cawh bonghnang aa ting, zecawtamaw tatah pangang a cang tae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A ningnaipaw sahlo cawh bonghnang aa ting, zecawtamaw tatah alui ry aa cy a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dingnah cawpaw tei a ngaidi katei, a tui a hraepaw sahlo cawh bonghnang aa ting, zecawtamaw tatah aa ri a vaw tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Zaangsaw aa thaipaw sahlo cawh bonghnang aa ting, zecawtamaw tatah zaangsaw a cang tae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A lungthing a pathaipaw sahlo cawh bonghnang aa ting, zecawtamaw tatah Khazing khah aa hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Arainah a chuakhuipaw sahlo cawh bonghnang aa ting, zecawtamaw tatah Khazing sawtei sahlo tatah y a cang tae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dingnah rawng tei hrehnah a ingpaw sahlo cawh bonghnang aa ting, zecawtamaw tatah vaicung painah raang cawh aaning sahlo aa cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kama ka rawng tah cawngsaw tah ahmang lypaw tah a phingphing tah aa ca reipachia tih he tah le aa ca hreh tih he tah le zerei lytah aa ca ung tih he tah bonghnang naa ting. ");
INSERT INTO zypNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","A lawng la, naa thaw chah thlang seh, zecawtamaw tatah vaicung letah naa longmai rungnaw ngeteipaw a ung. Ma hrahei naaning hlai tei Khazing khuavang sahlo zong khah aa za hreh hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Naaning cawh alui paci na cang he ceh. Canghrasala paci cawh a aenah khah a ly tei a cang caco, zekhatamaw aesah kaw a cang thai khawh a? Vathlang tei cawngsaw tah tlaichai ruapaw cawtah tah ly co ze cawtah hmai sangtlenah hnui khawh be. ");
INSERT INTO zypNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Naaning cawh khazaw khainah na cang he ceh. Tlaang cung letei tlahpaw khua cawh no khypaw cang be. ");
INSERT INTO zypNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Me-ing cawh vang he ka, tongbai rai letah chia bang bei he. Ing chung vytei khai náseh tatah me-ing tung letah aa chia hri tei. ");
INSERT INTO zypNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma hraco naa khainah cawh cawngsaw hme letah khai seh la, ma pawsui co hmingchaw naa tuapaw khah hmuh a he ka, vaicung letei a ungpaw naa Paw cawh aa reithai a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Phungbia a cang ly leh Khazing khuavang sahlo aa bia khah ro rua pawtah a vong tatah pa rawh khe lo. Ma sahlo ro ruapaw taco a vong bei neh, tlingsah ruapaw tutah ka vong hri hi. ");
INSERT INTO zypNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Biahmuisui ka ca ching he. Alui le avai a ly hlai vytei cawh phungbia cabu chung letei a chia caipaw, casung tei deipaw tei hmai heh zezongpui a changnah aa phah hlai taco ly a be. ");
INSERT INTO zypNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ma biapeh sahlo letei a chia caipaw tei hmai heh rawh katei, ma hraco tua hrá pawtah male a cawngpah laipaw cawngsaw cawh vaicung painah raang letah a chia caipaw a cang a, canghrasala ma biapeh sahlo heh zui katei, male a cawngpah laipaw cawngsaw cawh vaicung painah raang letah mehlai a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Naa dingnah tah Farasi sahlo dingnah le phungbia cawngpahtu sahlo dingnah khah a khung ly tei a cang caco, vaicung painah raang letah a nae khy hrahring bei ceh tah heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Lenong kheh, le a nawngpaw cawngsaw cawh biacenah letah chuakhui a cang a,’ tatah khuahlai cawngsaw tei aa za tah teipaw khah naa thui thlang kho. ");
INSERT INTO zypNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Canghrasala, a uny cung letei a thing a aepaw cawngsaw cawh biacenah letah chuakhui a cang a, taheh ka ca ching he. A uny khah, ‘Zeruarang ly,’ tatah a tahpaw cawngsaw cawh biacetu phu khatah chuakhui a cang a. Taico, a uny khah, ‘Mehruh,’ a tahpaw cawngsaw cawh hraihming me lang thlah a tlahpaw a cang tah heh ka ca ching vy he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Macawtaco dangnah siasang letah na lahsong khah na hlai leimeining tah na unypaw tah na cung letah a lungtling be tah na hni caco, ");
INSERT INTO zypNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na lahsong khah dangnah siasang leco chiasi. Va sei la, na unypaw cawh a va rai taw, mataico a vong la, na lahsong cawh a hlai my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Biacenah zung letah a ca chuakhuipaw na caraepaw khakhei rairang tah arainah tua a va zawng. Langpui letah naa sei chung takhei tua my lo, ma hratei na tua ly caco biacetu kih letah ca hlai sua ka, biacetupaw tah naw hnuitu kih letah ca hlai sua ka, thong letah thlah na cang sua a. ");
INSERT INTO zypNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Biahmuisui ka ca ching he, dangtahnah tangka na lia thlu hlai vytei cawh chuh khy khaw bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Male nupui pasae khatah a phei kheh,’ tatah aa tah teipaw khah naa thui thlang kho. ");
INSERT INTO zypNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Canghrasala, canu pakheh khah mehthi hmo tei a mingpaw cawngsaw taco a lungchung letah a phei thah, tahpaw heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na cacang lang meh tah a ca suasah caco, khyhly la, vathlang. Na pungpaluh tah hraihming lang tlah navy co, na pung cung letei sangkheh tling ly cawh na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Taico na cacang lang kih tah a ca suasah caco taichung la, vathlang. Na pungpaluh tah hraihming lang tlah navy co, na pung cung letei sangkheh tling ly cawh na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘A nupui a mahpaw cawngsaw taco a nupui cawh mahnah ca pei seh,’ tatah aa za tah tei. ");
INSERT INTO zypNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Canghrasala, a nupui tah capaw hringpaw khatah a suasai tah tlung lypaw tei a mahpaw cawngsaw cawh a nupui tah pasae hringpaw a hnui caco a pheisahtu cang ka, ma mah ciapaw canu a chuipaw cawngsaw cawh a pheipaw a cang tah heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Khuahlai cawngsaw taco, ‘Chia na sahpaw cawh rawh kheh. Abuipaw khatei na tuapaw chiasahnah cawh zui my lo,’ tatah aa za tah teipaw khah naa thui thlang kho. ");
INSERT INTO zypNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Canghrasala, vaicung tah chia a sah khe o, zecawtamaw tatah ma cawh Khazing a tynah a cang, tah heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A cang ly leh alui tah chia a sah khe o, zecawtamaw tatah ma cawh Khazing phe chianah a cang, a cang ly leh Jerusalem khuapui ming tah chia a sah khe o, zecawtamaw tatah ma cawh Siangpahrang a khuapui a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Taico na lu tah chia a sah kheh, zecawtamaw tatah na sangbu bukheh hmai khah rang sá tah vongsah khy bei ceh kho. ");
INSERT INTO zypNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","A cang caco, ‘A cang,’ tah la, a cang ly caco, ‘Cang be,’ tah my lo. Ma a khunglang tei hming cawh mehchaw lypaw taitah a va chuhpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Meh cawtah meh, haw cawtah haw,’ aa za tah teipaw khah naa thui thlang kho. ");
INSERT INTO zypNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Canghrasala, mehchawly a cangpaw cawngsaw khah palei hri khe o, tah heh ka ca ching he. Pakheh kheh tah na cacang lang bai letah a ca cabai caco, a rakheh lang zong khah congpah vy. ");
INSERT INTO zypNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Taico pakheh kheh tah na pai lah du tah taza a ca cui caco, na angkilai zong khah pei chi thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pakheh kheh tah hranghrang tah khangkheh a ca seisah caco, ama khaco khang hning va sei my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","A ca haepaw cawngsaw khah va pei la, nama khatah dycui a ca dupaw cawngsaw khah a huisai lai he kheh. ");
INSERT INTO zypNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Na ingpaw va do la, na carae a hua,’ tatei aa za tah teipaw khah naa thui thlang kho. ");
INSERT INTO zypNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Canghrasala, na carae sahlo cawh va do la, a ca hrehpaw cawngsaw sahlo caw takhei thlawchang my lo, tah heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ma pawsui co vaicung letei a ungpaw naa Paw a sawtei sahlo naa cang khy a. Ama taco ning khah mehchaw cung letah kha, mehchawly cung letah kha thasah ka, mehding cung letah kha, mehdingly cung letah kha khua khah a sosah. ");
INSERT INTO zypNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Naaning a ca dopaw suipaw naa do caco he ze longmai maw naa hmuh a? Ngungkhui kheitu sahlo tahmai tah ma cawh tua thlang bei he maw? ");
INSERT INTO zypNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Taico na uny sahlo suipaw bia na ching caco he zemaw ahringpaw sahlo navy tah na tua khy vy hlui? Lawki cawngsaw sahlo zong tah ma cawh tua thlang bei he maw? ");
INSERT INTO zypNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Macawtaco vaicung letei a ungpaw naa paw a tlingpaw hratah tling hrah my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","A dingpaw rai naa hrepaw khah cawngsaw tah ma hmuh naa he seh tatah cawngsaw hme letah tua ly rua pawtah khei a raering my lo. Ma hraco naa tua caco, naa Paw vaicung leteipaw taitah longmai hmuh a bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Macawtaco a phahlahpaw cawngsaw naa pehlai tih he tah cungmai raipha sahlo tei cawngsaw tah ma cizaw naa he seh tatei synagog sahlo le langpui sahlo letah aa tualaipaw hratah naa tuapaw cawh hmoka tung tah y khui lai khe lo. Biahmuisui ka ca ching he, aaning sahlo cawh aa longmai khah a tling teitah aa hmuh thah kho. ");
INSERT INTO zypNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Canghrasala a phahlahpaw cawngsaw cawh naa pehlai tih he tah naa cacang lang kih tei a tuapaw cawh naa cavui lang kih khah hnisah khe la, ");
INSERT INTO zypNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ma pawsui co naa pehlainah cawh aparuh a cang a. Mataico naa Paw, a paruh teitah tuapaw a hmuhpaw taco longmai a ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Taico, thlaw naa chang tihtah cungmai raipha sahlo hratah chang khe lo. Zecawtamaw tatah aaning sahlo cawh cawngsaw tah ma hmuh na he seh tatah synagog le langchai letah a daw lai tei thlawchang khah aa du kho. Biahmuisui ka ca ching he, aaning sahlo cawh aa longmai khah a tling teitah aa hmuh thah. ");
INSERT INTO zypNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Canghrasala, naaning cawh thlaw naa chang tihtah ing chunglang a nae la, ingkaw kha la, naa Paw hmuh khy lypaw khaco chang my lo. Mataico naa Paw, aparuh teitah tuapaw a hmuhpaw taco longmai a ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Taico thlaw naa chang tihtah lawki cawngsaw sahlo hratah naa rei ciapaw duitei rei cakhawng leimei thlang khe lo, zecawtamaw tatah aaning sahlo taco bia hlupui kaa reinah cawtah hei thuipah kaa cang peh tatah aa rawh kho. ");
INSERT INTO zypNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aaning hratah cang khe lo, zecawtamaw tatah naa Paw taco naa hiapaw khah naa hae hlai taitah a hni thlang kho. ");
INSERT INTO zypNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Macawtaco thlaw naa chang tihtah ma hrahei chang my lo, ‘Kaa Paw vaicung leteipaw, Na ming cawh cizaw tah ung ky seh. ");
INSERT INTO zypNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na painah tlung ky seh. Vaicung letah na dupaw aa tuapaw hratah, alui lehei tua hrah he seh. ");
INSERT INTO zypNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ningting kaa hiapaw batui ma pei my lo, ");
INSERT INTO zypNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","kaa cung letei chahlynah a tuapaw cawngsaw sahlo kaa ngethai pawhe hratah, kaa chahlynah ma ngethai hrah my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tuhsonah lang a ma chui kheh la, mehchaw lypaw taitah ma pachah hri my lo.’ ");
INSERT INTO zypNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Naa cung letah chahlynah a tuapaw cawngsaw sahlo khah naa ngethai caco he, naa Paw vaicung leteipaw tah a ca ngethai hra he a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Canghrasala, cawngsaw aa suanah khah naa ngethai ly caco he, naa Paw vaicung leteipaw tah naa suanah khah ca ngethai hrá bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Batui naa cahe tihtah cungmai raipha sahlo tei mehmechiá tah a ung sahpaw he hratah ung khe lo, zecawtamaw tatah aaning sahlo cawh batui kaa cahepaw ma hnih naa he seh tatah aa mehme a chiasahpaw a cang he kho. Biahmuisui ka ca ching he, aaning sahlo cawh aa longmai khah a tling teitah aa hmuh thah kho. ");
INSERT INTO zypNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Canghrasala batui naa cahe tihtah naa lu letah sathy a thu la, naa hme a pahleh my lo, ");
INSERT INTO zypNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","maco cawngsaw tah batui naa cahepaw ca bi be ca he ka, hmuh khy lypaw naa Paw suitei tah a ca bi he a, taico aparuh teitah tuapaw a hmuhpaw naa Paw taco longmai a ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Luichaw le carih tei aa e khynah le mehru tah aparuh teitah a nae tah aa ruh khynah hminghmaw a cangpaw alui lehei naa cho pacung khe o. ");
INSERT INTO zypNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Luichaw le carih tei aa e khy lynah hming le mehru tah hawhthlah tei aa ruh khylynah hming vaicung letah naa chosung cawh pacung hri my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Zecawtamaw tatah naa chosung a ungnah letah naa lungthing a ung hrá a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Meh heh pung cawtah me-ing a cang. Na meh a chah caco, na pungpaluh cawh khainá tah a chih a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Canghrasala na meh a chah ly caco, na pungpaluh cawh muiná tah a chih a. Mataico na chung letei khainah cawh a mui caco, na cawtah zetluh a zingkalupaw maw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Aho tahmai abui pahning aa rai hre khy be. Pakheh a hua a ka, pakheh a do a, a cang ly leh pakheh cung letah zingchui tah ung a ka, pakheh khah zetah rei a be. Khazing rai kha, tangka rai kha, hre pakong khy bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Macawtaco ka ca ching he, naa hringnah cawtah zemaw kaa e kaa ding a, a cang ly leh naa pung cawtah a buh a sai ruapaw kong letah naa lung reithui kheh seh. Hringnah heh e le ba navy tah sungnaw vy ka, pung heh chaichi navy tah sungnaw vy bei maw? ");
INSERT INTO zypNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Avai letei a zythipaw pavaw sahlo kheh mingtua hmai o. Thleci cing bei he, saze hre hrah bei he, apaang letah rai hrah bei he. Ma cawh naa Paw vaicung leteipaw tah a cong thlang he. Naaning cawh pavaw navy tah a sungnaw vypaw cang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Naa hrong letah ahomaw a lung reithuinah rawng tah a hringnah cai suimehlang pakheh chang a chahchi khy? ");
INSERT INTO zypNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Taico zecawtamaw chaichi kong letah naa lung rei a thui? Alui letei a cypaw lili pangpa sahlo kheh mingtua o. Rai hre bei he, chaichi a taw bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Canghrasala ka ca ching he, siangpahrang Solomon hmai ma tluá khei a laisui thlang naná teitah ma pangpa sahlo letei kung kheh tlua khei hmai pasang cang be. ");
INSERT INTO zypNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Vy naaning zingnah a cawngpaw sahlo, atoning ka cy katei, ningthlamong me lang aa bo thlangpaw araang hmai a pasangpaw Khazing taco naaning cawh pasang lytah maw a ca ung he a? ");
INSERT INTO zypNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Macawtaco, ‘Zemaw kaa e a, zemaw kaa ding a, zemaw ka hrei he peh?’ tatah naa lung reithui kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Zecawtamaw tatah ma hapaw hming sahlo cawh lawki cawngsaw sahlo zong tah aa hui teipaw cang hrah ka, naa Paw vaicung leteipaw tah naa hiapaw khah a hni thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma navy co a painah le a dingnah tukhah hui taw la, ma hming vytei zong heh peh na cang thlang a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Macawtaco ningthlamong kong letah naa lung reithui kheh seh, zecawtamaw tatah ningthlamong taco, ama a kong letah ama teitah a lung rei a thui thlang hrá a. Ningkheh cy tahei azaw pawtah lung reithuinah aa chuakhui hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Male bia na cepah caco he nama zong biace pah na cang hrá a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Zecawtamaw tatah male bia na cepah pawtei he hrakhei nama zong biace pah cang a ceh ka, na hmangpaw nehnah pawtei khei aa ca neh pah kaw hrá a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nama na mehkho letei thingphae khah pacang taw lytah na unypaw a mehkho letei thingpatlaw khah zecawtamaw na mingpah? ");
INSERT INTO zypNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nama na mehkho letah thingphae a hmuh tlung lytah zekhatamaw na unypaw cawh, ‘Na mehbang khah ca tho pá neh,’ na tah khy? ");
INSERT INTO zypNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Naaning cungmai raipha sahlo, naaning naa mehkho letei thingphae khah thohly taw la, taico naa unypaw a mehkho letei mehbang cawh tho pá pawtah a sepaw teitah naa hmuh khy a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A pathaipaw hming cawh ui pei khe o. Naa lungva khah voh hmekaw letah va khe o. Ma hratei naa tua caco, aa phe tah tlaichai a he ka, naaning laky khah aa ca ty he a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Hae la, peh na cang a he ceh, hui la, naa hmuh a, khong la, ingkaw hongpah na cang a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Zemaw tahpaw co, ahohmai a haepaw maikaw cawh peh cang a he ka, a huipaw taco hmuh a ka, ingkaw a khawngpaw cawh hongpah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","A sawcapaw tah very hae seh la, alung a peipaw naa ung he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A cang ly leh ngaw hae seh la, pari a peipaw a ung he maw? ");
INSERT INTO zypNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Naaning mehchawly tahmai tah naa sawtei leh khah hmingchaw peh zia naa hni caco, vaicung letei naa Paw tah Ama a haepaw sahlo cawh hming chawpaw khah zetlua tamaw a peh vy chichi he a! ");
INSERT INTO zypNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Macawtaco zezongpui letah ming hringpaw tah na cung letah tua he seh tah na dupaw hrakhei male cung letah va tua my lo, zecawtamaw tatah ma heh phungbia le Khazing khuavang sahlo tei aa rei dupaw cawh a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Hawkaw a bawpaw lang tah a nae my lo. Zecawtamaw tatah a kypaw hawkaw le a kypaw langpui cawh rorangnah lang a chuipaw cang ka, ming hlupui cawh ma lang co a nae tei he. ");
INSERT INTO zypNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Canghrasala, a chiapaw hawkaw le a bawpaw langpui cawh hringnah lang a chuipaw cang ka, cawngsaw a cawngtei suipaw tah ma cawh aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Khuavang pakheipaw sahlo taikhei a raering my lo. Tu pho a buá tah naaning kha a vong he a, canghrasala aa chunglang co chahnia a hrang ngeteipaw a cang he kho. ");
INSERT INTO zypNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aa thuisu khei aaning sahlo cawh naa bi thlang he a. Cawngsaw tah misur thui khah ahling kung taitah le thuiku khah zara kung taitah aa lo tei maw? ");
INSERT INTO zypNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma hraco thingkung a chawpaw maikaw taco thuichaw thui he ka, canghrasala thingkung a chiapaw maikaw taco, thuichia a thui he. ");
INSERT INTO zypNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Achawpaw thingkung taco thuichia thui khy be ca ka, a chiapaw thingkung zong tah thuichaw thui khy hrah be. ");
INSERT INTO zypNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Thui chaw a thui lypaw thingkung maikaw cawh hyhly tah me lang bo a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ma hrahei aa thuisu tah aaning sahlo cawh naa bi thlang he a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Abuipaw, Abuipaw,’ a pa tahpaw maikaw aa zongmingtei tah vaicung painah raang letah a nae a bei he, ka Paw vaicung leteipaw a dunah a tuapaw cawngsaw suipaw a nae a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ma ning leco ming hlupui tah, ‘Abuipaw, Abuipaw, na ming tah biaphy he peh ka, na ming tah khachia papia he peh ka, ningang chuipaw hlupui tua bei peh maw?’ aa pa tah tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma tih taco aaning sahlo cawh, ‘Naaning hming chahly a tuapaw sahlo ca hnih bei he neh, ka kae taitah seihly o!’ tatah a sepaw tah ka tah he a. ");
INSERT INTO zypNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Macawtaco ma ka reipaw bia sahlo heh thui katei, a zuipaw cawngsaw maikaw cawh alung cung letah a cy pui tah a ing a sahpaw mehsing khatah a lo he. ");
INSERT INTO zypNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Khua va so, tui va lai, thli a va hrang ka, ma ing cawh a nang tihtah po khy be, zecawtamaw tatah alung cung letah a cy pui tah sahpaw a cangnah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Canghrasala ma ka reipaw bia sahlo heh thui katei, a zui lypaw cawngsaw maikaw cawh sadi cung letah a ing a sahpaw mehruh khatah a lo he. ");
INSERT INTO zypNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Khua va so, tui va lai, thli a va hrang ka, ma ing cawh a nang tihtah pohly ka, a rawh ceh ceh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zisu tah ma hming sahlo heh a rei thlu tihtah mingzawpui cawh a cawngpahnah cawh aa khuarawh a haa thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Zecawtamaw tatah phungbia cawngpahtu sahlo hratah cang lytah naw a hnuitu hratah a cawngpah caw he tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tlangpa lang khei a za cung tihtah cawngsaw rungpui takhei aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Thinghmuihri a ingpaw cawngsaw pakheh cawh a vong ka, a hme letah a khuh panai ka, “Abuipaw, na du caco na pa dangsah khy thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Zisu taco a kiá tah pazah ka, ma cawngsawpaw cawh va tong ka, “Na dang cawh du neh ka, dang myca,” tatah a tah. Ma cangkaw leco, a thinghmuihri vytei cawh a pathai. ");
INSERT INTO zypNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Taico Zisu tah, “Ahohmai ching khe lo. Ma duitei cawh va sei la, tlangbui a va ming sá la, Moses phungbia hrakhei thuihlainah va tua, ma paw suico dangsah na cangpaw khah ming maikaw tah aa ca hni a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zisu cawh Kapernaum khua a nae tihtah raekeh zakheh buipaw cawh Ama kha a vong ka, bawnah a va hae. ");
INSERT INTO zypNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Abuipaw, ka saecapaw song ka, taithui ngetei tah ing letah a lia thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zisu taco a hai letah, “A vong neh ka, ka dang sá a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Raekeh zakheh buipaw taco, “Abuipaw ka ing heh nama na naenah tlangpaw cang be. Canghrasala bia kawkheh teitah na rei caco, ka saecapaw cawh a dang thlang a. ");
INSERT INTO zypNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kama zong nawhnuinah rai letah a ungpaw cang neh ka, ka rai letah raekeh sahlo a ung hrah he. Pakheh cawh, ‘Sei,’ tah neh ka, sei ka, pakheh cawh, ‘A vong,’ tah neh ka, a vong. Ka saecapaw cawh, ‘Ma heh tua,’ tah neh ka, a tua thlang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zisu tah ma bia cawh a thui tihtah a ningang ka, Ama a zuipaw sahlo aa hai leco, “Biahmuisui ka ca ching he, ma hapaw zingnah alaipaw a hnuipaw cawngsaw heh Israel mingphing chung letah pakheh hmai hmuh bang bei neh. ");
INSERT INTO zypNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ka ca ching he hi, nichua nitlah taitah cawngsaw hlupui a vong a he ka, vaicung painah raang letei lawhdangnah cabuai leco Abraham, Isak le Jakob khatah a ty hrui he a. ");
INSERT INTO zypNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Canghrasala vaicung painah raang letah a ung ruapaw sahlo tukhah alailang muinah chunglang, caw le hawria tah ungnah hminghmaw lekhei vathlang a cang tae he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mataico Zisu tah raekeh zakheh buipaw cawh, “Va sei thlang! A cang a, tatah na zingpaw hratah tua a cang thlang a,” tatah a tah. Taico ma suimehlang cai lalei leco a saecapaw cawh a dang palang. ");
INSERT INTO zypNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Zisu cawh Piter a ing chunglang a za nae tihtah asaw tah nang katei, lakhing letah a lia thlangpaw Piter a nupuino a no khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A kih cawh va hre ka, asawnah taco a thlaw. Mataico ka tho ka, Zisu cawh a tangtui. ");
INSERT INTO zypNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Zailang a va phah tihtah khachia tei a tlepaw he mehlupui cawh Ama khatah va chuakhui he ka, bia tah thlawpaw pialuipaw sahlo cawh tingchua he ka, a sahpaw vytei cawh a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ma heh Khazing khuavang Isaiah hmokaw hmang tei reipaw, “Ama tah kaa danglynah pho ka, ka sawnah he peh khah a seikhui,” tahpaw bia a tlingnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zisu taco a kaekang letei mingzawpui sahlo khah a hmuh tih he tah a hningzuitu sahlo khah, “tuiping raechai lang sei he pei,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mataico, phungbia cawngpahtu pakheh Ama khatah a vong ka, “Cawngpahtu, na seinah maikaw lang ka ca zui a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Zisu taco, “Sihatei sahlo tah kua hnui he ka, pavaw sahlo zong tah bu aa hnui, canghrasala Cawngsaw Sawcapaw tu cawh a lu pahnia nápaw hminghmaw hmai hnui be,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A hningzuitu ahringpaw taco a hai letah, “Abuipaw, va sei neh ka, ka paw ka va phung taw a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Canghrasala Zisu taco a hai letah, “Va pa zui thlang, a thipaw cawh mehthi tah phung thlang he seh,” tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mataico tuilawng chunglang cawh a nae ka, a hningzuitu sahlo cawh a nae hrah he ka, a sei he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Rawh ly pui tah thlichia cawh tuiping leco a hrang caimang ka, macawtaco tuilawng cawh tuileh tah a bakhu thlu. Canghrasala Zisu cawh a ihning thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A hningzuitu sahlo taco Ama cawh va patho he ka, “Abuipaw, ma pachah tua. Tui lang ka tlah thlu he peh hi!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Zisu taco, “Naaning zingnah a cawngpaw sahlo, zecawtamaw ma reiro co naa ci?” tatah a palei he. Mataico katho ka, thli le tuileh cawh a hrangso he ka, tui cawh a cali he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cawngsaw sahlo cawh aa ningang thlang ka, “Ma heh zehapaw cawngsaw maw a cang? Thli le tuileh tahmai a bia aa nge thlangpaw heh!” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Zisu cawh tuiping raechai lang tei Gadarin raang khah a va phah tihtah khachia tei a tlepaw he capaw pahning khah thlaikung lang tah va sei he ka, a va tong he. Ma tlaw pahning cawh cichui ngetei he ka, ahohmai ma lang co sei ngang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","“Khazing Sawcapaw, kaaning khatah zemaw na dupaw a ung? Cai thliapaw a tling hlai tahei kaaning hreh ruapaw tamaw ma lehei na va chua?” tatah aa y so. ");
INSERT INTO zypNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aaning taitah a hlah ky lypaw lekhei lawh a e leimeipaw voh rungpui a ung he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Khachia sahlo taco Zisu cawh, “Na ma papia caco, voh rung aa chunglang a ma naesah ky,” tatah aa naw. ");
INSERT INTO zypNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zisu taco aa hai letah, “Va sei ca o!” tatah a tah he. Macawtaco piathlah he ka, voh sahlo chunglang cawh a nae he. Voh rungpui cawh lungkang cung taitah tuiping lang cawh a zythlah he ka, tui leco a thi thlu he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Voh a mingkaitu sahlo cawh va sai he ka, khuapui chunglang cawh a nae he ka, ma kong vytei cawh le khachia tei a tlepaw he pahning cung letah hming a tlungpaw khah aa va ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mataico aa zongmingtei co, Zisu a tong rua pawtah aa sei. Aa va hmuh tihtah aa raang taitah piathlah pawtah khei aa naw. ");
INSERT INTO zypNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zisu cawh tuilawng cung lang ke ka, tuiping raechai lang cawh sei kaw he ka, Ama a khua lang khah a va sei. ");
INSERT INTO zypNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mehthaikheh sahlo takhei a songbepaw cawngsaw khah iphaw letah a lia thlang hmo khei Ama khatah aa va chuakhui. Zisu tah aa zingnah khah a hmuh tihtah a songbepaw hai leco, “Ka dua, na thlawlung seh, na suanah vytei cawh ngethai a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma tih taco phungbia cawngpahtu thaikhehpaw sahlo tah aaning le aaning cawh, “Mapaw tahei Khazing a reipachia,” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aa rawhnah khah a hni thah cawtah khei Zisu tah, “Zecawtamaw naa lungchung tah rawhnah achaw lypaw cawh naa pacang? ");
INSERT INTO zypNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Na suanah sahlo cawh ngethai a cang,’ tahpaw maw a neh vy? ‘Tho la, sei,’ tahpaw maw a neh vy? ");
INSERT INTO zypNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Canghrasala, Cawngsaw Sawcapaw heh aluicung letah sua ngethainah naw a hnui taheh ka ca hmuh sá he a,” tah ka, taico a songbepaw hai leco, “Tho, na phia a lah la, ing lang a dih,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Taico cawngsawpaw cawh tho ka, ing lang cawh a dih. ");
INSERT INTO zypNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cawngsaw zawpui tah ma cawh aa hmuh tihtah aa ningang ngetei ka, ma hapaw nawhnuinah cawngsaw sahlo khatah a peitu Khazing khah aa reithai. ");
INSERT INTO zypNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Zisu cawh mataico seihly ka, ngungkhui kheinah hming letah a tythlangpaw cawngsaw Mathai aa tahpaw khah hmuh ka, “Va pa zui,” tatah tah ka, Mathai cawh tho ka, Ama cawh a zui. ");
INSERT INTO zypNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Zisu cawh Mathai a ing letei zairia batui a e leimei ning takhei ngungkhui kheitu mehlupui le ahringpaw mehsua sahlo cawh a vong he ka, Ama le a hningzuitu sahlo khakhei aa va e hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasi sahlo tah ma cawh aa hmuh tihtah a hningzuitu sahlo cawh, “Zecawtamaw naa cawngpahtu heh mehsua sahlo le ngungkhui a kheitu sahlo khatah batui a e hrui?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Zisu tah ma bia cawh thui ka, “A dang thlangpaw taco Sibui aa hia tlung be, a dang lypaw tah pui aa hia. ");
INSERT INTO zypNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Va sei la, ‘Kama ka dupaw cawh athuihlainah cang lytah zawngenah a cang,’ tahpaw a silang heh va cawng taw o. Zecawtamaw tatah Kama cawh mehding y rua pawtah ka vong tlung be, mehsua sahlo y rua pawtah ka vong hri hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mataico, baptisma peitu Johan a hningzuitu sahlo cawh a vong he ka, Zisu khah, “Kaaning sahlo le Farasi sahlo tah batui cahe he peh ka, nama na hningzuitu sahlo tahei zecawtamaw a cahe bei he?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Zisu taco, “Sawngpaw sahlo cawh nupui a chuipaw satlepaw khatah aa ung chung taco zecawtamaw ngechia tah aa ung a? Nupui a chuipaw satlepaw cawh aaning sahlo taitah lahnah cai a va phah tae a. Mataico batui a cahe tae thlang he a. ");
INSERT INTO zypNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ahotahmai tah paithang a thapaw tah chaichi a paringpaw khah a beithlah bang bei he, zecawtamaw tatah aa thlahpaw paithang takhei angki khah hruipako a ka, a kychy vy tima a. ");
INSERT INTO zypNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Misurhang a hringtui khah sapho tuithei a paringpaw letah rai bang hrah bei he. Aa rai caco, sapho tuithei khah tingchy a ka, misurhang cawh a zuh thlu a, sapho tuithei zong a rawh thlu a. Misurhang a hringtui cawh sapho tuithei a thapaw letah rai he ka, aa sanghning tah a bing he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ma bia a rei chung taco uhtu bui pakheh a vong ka, a hme letah a khuh panai ka, “Ka sawcanu cawh atotei khah a thi. Canghrasala a vong tei, a cung letah na kih na pahnia caco, a hring kaw thlang a,” tatah a naw. ");
INSERT INTO zypNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zisu cawh a daw ka, Ama khaco sei he ka, a hningzuitu sahlo zong a sei hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma leco canu pakheh kung hrawhluihning chung a thi a chuh no cawh Zisu a hninglang tah a vong ka, a pai dong cawh a va tong. ");
INSERT INTO zypNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ama le ama cawh, “A pai dong tei chang ka tong caco ka dang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zisu cawh a va paleh ka, ma canuno cawh a hmuh. “Ka sawcanu na thlawlung seh. Na zingnah tah a ca dangsah,” tatah a tah. Taico sungkheh teitah ma canuno cawh a dang. ");
INSERT INTO zypNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zisu cawh uhtubui a ing chunglang khah a nae ka, phipahli a tungpaw sahlo le naw a cheh thlangpaw he zawpuipaw khah a hmuh tih he tah, ");
INSERT INTO zypNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Piahly tua o. Nyheh no heh a thih tlung be, a ihning thlang hi!” tatah a tah he. Canghrasala, Ama cawh aa hnuiso. ");
INSERT INTO zypNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Zawpuipaw cawh khunglai lang aa piahly khy taitah inahkhang chunglang cawh a nae ka, nyheh no cawh a kiá tah tle ka, a ka tho. ");
INSERT INTO zypNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma thongpang cawh ma raang chung vytei lekhei a thang thlu. ");
INSERT INTO zypNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Zisu cawh mataico piathlah ka, mehcopaw pahning takhei zuilai he ka, “David Pathlah ning ma do ky law,” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zisu cawh ing chunglang a za nae thlah tihtah mehcopaw pahning cawh Ama khaco a vong he. Zisu taco, “Naa meh khua ka hmuhsah khy kaw a tatah naa zing maw?” tatah a hae he. “Abuipaw, kaa zing,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mataico aa mehkho cawh tongpah he ka, “Naa zingnah hratah naa cung letah tlung ky seh,” tah he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","aa mehcawh khua a hmuh khy kaw. Zisu taco aaning cawh, “Ahohmai hnisah khe lo,” tatah cyky tah bia a patai he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Canghrasala, seihly he ka, Zisu kong thongpang cawh ma raang chung vytei lekhei tlang aa zang lai. ");
INSERT INTO zypNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cawngsaw sahlo aa piahly chung takhei, khachia tah tle katei bia a rei khy lypaw cawngsaw pakheh khah Zisu khaco aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Taico, khachia cawh a papiapah tihtah a rei a thlaw thai lypaw cawngsaw cawh a rei a ka thlaw khy. Cawngsaw zawpui cawh aa ningang ka, “Ma hapaw hming heh Israel mingphing chung letah hmuh bang bei peh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Canghrasala, Farasi sahlo taco, “Khachia sahlo buipaw thongtah khachia sahlo a papiapaw a cang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zisu cawh khuapui vytei le khuatei vytei khah cahrong lai ka, synagog lekhei a cawngpah lai he. Vaicung painah raang kong thawngchawbia khah reilai ka, asawnah le danglynah maikaw khah a dangsah lai he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cawngsaw zawpui khah a hmuh tih he tah ning a do ngetei he, zecawtamaw tatah aaning sahlo cawh lung reithui le vaisang pazá tah kingtu a hnui lypaw tuu hratah aa cangnah cawtah khei a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mataico a hningzuitu sahlo khah, “Saze hre ruapaw hlu ngetei ka, canghrasala, raihretu cawh a cawngtei he. ");
INSERT INTO zypNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Macawtaco, saze lui a hnuitu Abuipaw cawh raihretu sahlo khah saze lui lang taw rua pawtah hae my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zisu tah a hningzuitu pahrawhluihning khah Ama khatah y he ka, thlawpaw pialuipaw papia khynah nawhnuinah le asawnah a phingphing le danglynah dangsah khynah nawhnuinah khah a peh he. ");
INSERT INTO zypNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma sahlo heh apostol pahrawhluihning aa ming cawh a cang. A pakhehnah letah Simon (Piter tatah aa y teipaw) le a unypaw Andru, Zebedi a sawcapaw Jeims le a unypaw Johan, ");
INSERT INTO zypNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip le Barthalomeo, Thomas le ngungkhui kheitu Mathai, Alfas a sawcapaw Jeims le Thadia, ");
INSERT INTO zypNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ci le phing a dawkhuipaw Simon le Zisu a luitupaw Judas Iskariot a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma apostol pahrawhluihning heh Zisu tah bia patai he ka, a taw he. “Gental cawngsaw sahlo hrong letah va sei khe la, Samaria cawngsaw aa khua lang a nae khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A lypaw tuu a cangpaw Israel mingphing khatah va sei hri my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Naa seinah letah ma bia heh va ching my lo, ‘Vaicung painah raang cawh a ne myca,’ tahpaw heh. ");
INSERT INTO zypNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","A sahpaw dang sá la, mehthi va patho la, mehthinghmui va pathai sá la, khachia va papia my lo. Amai lytah naa hmuhpaw heh a mai lytah va pei hrah my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Naa sahre letah sui maw, ngung maw, thihring maw a cakai khe lo, ");
INSERT INTO zypNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","khuatlongnah cawtah sahre, a hluipaw chaichi, phepakong, cungcahrei tahpaw a cakai khe lo, zecawtamaw tatah raihretu cawh a e tlang a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Khuapui maw, khuatei maw na naenah maikaw lehe ceh tah tlung tlang a cangpaw cawngsaw khah pakhia la, a ing leco naa seithlah kawnah tai va tlung my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A ing lang na nae tih he ceh tah naa cung letah denah ung ky seh tatah tah my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ingtlung aa ca pa-awng caco he, naa bonghnang cawh ma ing leco ung my seh lo. Ma hratei a cang ly caco naa bonghnang cawh naaning khatah va kaw kaw my seh lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pakheh kheh tah aa ca cyhlang du ly caco he le, a cang ly leh naa bia aa nge du ly caco, ma ing, a cang ly leh ma khua cawh naa piasai tihtah naa phe letei luipadih khah cathingthlah si my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Biahmuisui ka ca ching he, biacenah ning letah ma khua navy co Sodom le Gomora khuapui tai-ingnah hmai khah a zia a ung vy a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Naaning sahlo cawh chahnia hrong letei tuu sahlo hratah ka ca taw he. Macawtaco pari sahlo hratah singvang la, thury sahlo hratah naa ningnai my seh lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","A ca dypaw cawngsaw sahlo khah a va raering ngetei my lo. Aaning sahlo taco biacetu sahlo khatah ca chuakhui he ka, aa synagog letah aa ca chei he a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kama ka rawng tah naaning sahlo cawh uhtu bui sahlo hme le siangpahrang sahlo hme lekhei chuakhui cang a he ceh ka, aaning sahlo khatah le Gental mingphing sahlo khakhei biahnihtu naa cangnah khah naa rei a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Canghrasala aa ca tle tih he tah zemaw kaa rei a, zekhatamaw kaa rei a tahpaw kong letah naa thlawzawng kheh seh. Ma cai leco rei ruapaw cawh peh na cang thlang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Zecawtamaw tatah a reipaw cawh naaning cang bei ceh. Naa Paw a Thlawpaw tah naaning hmang tah a rei hri a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Uny le uny, paw le saw sahlo cawh thihnah tai a luithae he a. Sawtei leh tah no le paw khah thihnah tai aa dy he a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kama ka rawng tah cawngsaw vytei tah aa ca hua he a, canghrasala zingnah letah a changnah tai cyky tah a dawpaw cawngsaw cawh pachah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hmingkheh letah hreh naa cang caco, ahringpaw hming lang sai my lo. Biahmuisui ka ca ching he, Cawngsaw Sawcapaw a vong hlai tahei Israel raang letei khua vytei naa tlawngpaw heh paling balang bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Singnah a cawngpaw cawh a cawngpahtu navy tah a sang vy be ca ka, sae zong a buipaw cung letah ung hrah be. ");
INSERT INTO zypNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A cawngpaw tah a cawngpahtu hratah a cang le sae tah a buipaw hratah a cang cawh a zaw thlang. Ing letei lu a cangpaw hmai Belzabub tatah y a cang caco, a ingchungkho cawngsaw sahlo cawh zetlua tamaw y aa cang chichi a! ");
INSERT INTO zypNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Macawtaco aaning sahlo cawh ci khe lo. No thlangpaw hming maikaw palang cang a he ka, biaparuh zong phy a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A muinah letah ka ca chingpaw he heh a khainah letah reipaw a cang, naa naw letei biaparuh reipaw khah ing tlungkhu taitah y khuipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Thlawpaw a theh khy lypaw, pung a theh khypaw sahlo khah ci khe lo. Ma navy co hraihming letah pung kha, thlawpaw kha a rawhrang khypaw Khazing tukhah ci hri my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Baibaw pavaw punghning khah tangka phaesai phaekheh tah zua bei he maw? Naa Paw a rei ly co, ma baibaw pavaw sahlo letei pungkheh hmai khah alui letah tlá be. ");
INSERT INTO zypNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Taico naa lu cung letei sangbu sahlo hmai khah reithlu a cang he kho. ");
INSERT INTO zypNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Macawtaco ci khe o, naaning cawh baibaw pavaw sahlo navy tah na sungnaw vy he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Cawngsaw hme letah Kama a pacang khuipaw cawh ka Paw vaicung leteipaw hme letah ka cang khui hrá a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Canghrasala, cawngsaw hme letei Kama a pa paphah saipaw cawngsaw cawh ka Paw vaicung leteipaw hme letah ka paphah sai hrá a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Alui letah denah chuasah rua pawtah a vong tatah parawh khe lo. Denah chuasah rua pawtah a vong bei neh, zyzi chuasah rua pawtah ka vong hri hi. ");
INSERT INTO zypNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ka vong hnohnangpaw cawh sawcapaw tah a paw, sawcanu tah a no, myno tah a pasaepaw a no, a dy sá pawtah cang ka, ");
INSERT INTO zypNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","cawngsaw a carae cawh ama a ingchungkho cawngsaw lilaw khah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kama navy tah a paw maw, a no maw, a do vypaw cawh kama ka cawtah a tlah be, kama navy tah a sawcapaw maw, a sawcanu maw a do vypaw cawngsaw cawh kama ka cawtah a tlah be ca ka, ");
INSERT INTO zypNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","taico ma leh khraws a puá tah a pa zui lypaw cawh kama ka cawtah a tlah be. ");
INSERT INTO zypNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A hringnah pachah a dupaw cawngsaw taco a hringnah sung a ka, Kama ka caw tei a hringnah a sungpaw cawngsaw taco a hringnah a hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Naaning a ca cyhlangpaw he cawh kama a pa cyhlangpaw cang ka, kama a pa cyhlangpaw cawh a pa tawtupaw a cyhlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Khazing khuavang a cang rawng tei Khazing khuavang a cyhlangpaw taco Khazing khuavangpaw a longmai khah cy a ka, mehding a cang rawng tei mehdingpaw a cyhlangpaw cawngsaw taco mehdingpaw a longmai khah a cy a. ");
INSERT INTO zypNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Taico ma nyhehtei sahlo letei pakheh hmai heh Kama ka hningzuitu a cang rawng tei pakheh kheh tah tui cakaw ny kheh tei hmai a peh caco, biahmuisui ka ca ching he, a longmai cawh hmuh lytah ung hrahring a be,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zisu tah a hningzuitu pahrawhluihning bia a chingpaw he khah a pachang tihtah Galili khuapui sahlo lang khah cawngpah pawtah le phungrei laipaw tah a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Khri a tuasenah khah Johan tah thong chung taitah a thui tihtah a hningzuitu sahlo khah taw he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Nama heh a vong lepaw cawh na cang maw, a cang ly leh ahringpaw maw kaa haw a?” tatah a va haesah he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Zisu taco, “Va sei kaw la, naa hmuhpaw le naa thuipaw heh Johan cawh va ching la, ");
INSERT INTO zypNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","mehcopaw tah khua aa hmuh, a songbepaw zong lang a sei he, thinghmuihri a ingpaw sahlo zong dang he ka, a nawpangpaw sahlo tah khua aa thui. A thipaw zong tho kaw he ka, mehsisah zong tah thawngchawbia aa thui myca. ");
INSERT INTO zypNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kama ka kong letah lung langlo tah a ung lypaw cawngsaw cawh bonghnang a ting,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Johan a hningzuitu sahlo cawh aa piahly tihtah Zisu tah zawpui hai leco Johan konglang khah a ching he. “Ze ming ruapaw tamaw raangcaa lang naa sei? Thli tei a taikalypaw tuiphi kung hapaw cawngsaw ming ruapaw tamaw? ");
INSERT INTO zypNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma hratei a cang ly caco ze ming ruapaw tamaw naa sei? Chaichi chaw a tuapaw cawngsaw ming ruapaw tamaw? Chaichi chaw a tuapaw cawngsaw sahlo cawh siangpahrang ing sahlo letah pui aa ung ky caw! ");
INSERT INTO zypNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ze ming ruapaw tamaw naa sei? Khazing khuavang ming ruapaw tamaw? A cang, Khazing khuavang navy tah alai vypaw kong ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ma heh Khazing bia letei ciapaw Ama a kong cawh a cang, ‘Ka tlang ypaw cawh na hmelang ka taw a, na hme letei na langpui a parai ruapaw tah!’ ");
INSERT INTO zypNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Biahmuisui ka ca ching he, canu tei sahpaw saw leco baptisma peitu Johan navy tah alai vypaw ahohmai ung bei he, canghrasala vaicung painah raang letei a chia caipaw hmai heh Johan navy tah a lai vy. ");
INSERT INTO zypNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baptisma peitu Johan taitah ato tai lehei vaicung painah raang cawh thaw tah pakhang paduinah a tong ka, canghrasala a du hmuisuipaw taco a nae rary thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Khazing khuavang sahlo vytei le phungbia takhei baptisma peitu Johan taikhah aa za reihlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Taico ma bia heh cyhlang naa dupaw tei a cang caco, Johan cawh a vong a tatei tahpaw Elija khah a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Thuinah nawkho a hnuipaw maikaw tah ma bia heh thui he seh. ");
INSERT INTO zypNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Atochai cawngsaw heh zekhatamaw ka tawching he a? Aaning sahlo cawh chodo tlang letei a ty thlangpaw nyheh sahlo khatah a lo he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Phipahli ca tungpah he peh ka, naa laang tlung be. Mehthi hlawsah he peh ka, naa caw tlung be,’ tatei aaning leh aaning aa ypaw he nyheh sahlo hratah aa cang. ");
INSERT INTO zypNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Zecawtamaw tatah baptisma peitu Johan cawh e ly ding lytah va chuh ka, ‘Khachia a hrei,’ tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cawngsaw Sawcapaw a vong ka, e ka, ding ka, ‘Ding le e suipaw a pacang, mehsua sahlo le ngungkhui a kheitu sahlo vesaw,’ tatah naa tah. Canghrasala singnah cawh a hming tuapaw sahlo takhei ahmang takhah a palang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mataico, Zisu tah ningang chuipaw hming a hlu cai a tuanahpaw khuapui sahlo khah sua a phosah he, zecawtamaw tatah aa suanah a ngepachih lynah caw he tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Vy Korazin khua, na cing a ping! Vy Bethsaida khua, na cing a ping! Naaning letei tuapaw ningang chuipaw hming khah Tair le Sidon khua letah tuapaw cang he seh la, buri pai a buh a tah mecang letah a ty a he ka, a ngepachih syly tha he a. ");
INSERT INTO zypNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Canghrasala ka ca ching he, biacenah ning leco Tair khua le Sidon khua tei aa ingpaw cawh naaning navy tah a zia a ung vy tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Taico nama Kapernaum khua, avai tai kheh calia na cang maw? Cang bei ceh. Khothuhnah lang na tlahthlah a. Nama na chung letei tuapaw ningang chuipaw hming khah Sodom khua letah tuapaw cang my seh la, atoning tai heh a za bing thlang a. ");
INSERT INTO zypNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Canghrasala ka ca ching he, biacenah ning leco nama navy tah Sodom khua cawh a zia a ung vy tae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma ningcai leco Zisu tah, “Ka Paw, alui le avai Buipaw, ka ca reithai, mehthai mehsing sahlo caw taco ma hming sahlo heh nawh ceh ka, nyheh sahlo hapaw khatah na palang. ");
INSERT INTO zypNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A cang, ka Paw, ma cawh nama na lawngnah cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hming vytei heh ka Paw tah a pa peh thlu thah he. Paw tah ly co Sawcapaw heh ahotahmai hnih bei he. Paw cawh Sawcapaw le Sawcapaw tei hnisah ruapaw tei a thingpaw he tah ly co ahotahmai hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Naaning hmingrih a phopaw le a thaw a bangpaw sahlo, kama kha a vong la, a hianah ka ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ka suihnang heh law la, a phonah dang cawh kama khatah va cawng la, zecawtamaw tatah kama cawh mehningnai le meh lungthing chaw cang neh ka, naa thlawpaw cawtah a hianah naa hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Zecawtamaw tatah ka suihnang cawh a pho neh ka, ka hming cawh a zang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma ningcai leco Zisu cawh Sabat ning tah saze lui cahrong ka a sei. A hningzuitu sahlo cawh aa ngai di ka, saangsu cawh pahrih he ka, aa e lai. ");
INSERT INTO zypNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasi sahlo tah ma cawh aa hmuh tihtah a hai leco, “Mingtua, na hningzuitu sahlo tah Sabat ning tah tua phung a cang lypaw aa tuapaw kheh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Zisu taco, “David tei a vesaw sahlo khatah aa ngai a dining tei a tuapaw khah rei bang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Khazing behnah ing lang a nae ka, a vesaw sahlo khatah aaning aa e phung a cang lypaw Khazing aa dangnah very khah aa e. Ma very cawh tlangbui a cangpaw longtei tah e phung a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","A cang ly leh behnah ing letei a ungpaw tlangbui sahlo tah Sabat ning aa papia aa palui tihtah sua phosah aa cang lypaw khah phungbia chung letah rei bang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Behnah ing navy tah alai vypaw ma lehei a ung thlang hi, tahpaw ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Kama ka dupaw cawh athuihlainah cang lytah zawngenah a cang,’ tahpaw bia a silang heh za hnih thah my la, a sua lypaw khah sua naa phosá lypaw he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Zecawtamaw tatah Cawngsaw Sawcapaw heh Sabat Buipaw a cang,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma hming taico va sei vy ka, aa synagog chunglang a nae ka, ");
INSERT INTO zypNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ma leco a kih rakheh asongpaw cawngsawpaw a ung. Zisu sua pu nápawtah bia hui he ka, a hai letah, “Sabat ning tei dangsah heh a phung a cang maw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aa hai leco, “Naaning lehei pakheh tah tuu hnui seh la, Sabat ning tah khobatlung lang tlah my seh la, la tah chuahly a bei maw? ");
INSERT INTO zypNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Cawngsaw cawh tuu navy tah sungnaw vy syly bei maw! Macawtaco Sabat ning tei hmingchaw tua cawh a phung a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mataico cawngsawpaw cawh, “Na kih pathlang,” tah ka, macawtaco a kih cawh pathlang ka, a rakheh lang tei pawtei hrakhei a chah kaw thah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Canghrasala Farasi sahlo cawh piahly he ka, Zisu cawh zekhatamaw kaa thaw khy a takhah aparuh teitah aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma cawh a hni cawtah Zisu cawh ma hminghmaw taico a zuh thlah. Cawngsaw hlupui tah zui he ka, a sahpaw vytei khah a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Taico ahomaw ka cang tahpaw khah rei ly pawtah bia a patai he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ma heh Khazing khuavang Isaiah hmokaw hmang tei reipaw, ");
INSERT INTO zypNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ma heh ka thingpaw ka sae, ka do ngeteipaw, ka lungtlingnah khah a cang. A cung letah ka Thlawpaw cawh chia neh ka, Ama tahei dingnah cawh mingphing sahlo hai letah a y khui a. ");
INSERT INTO zypNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ama cawh a hrychae be, a cang ly leh ysang be. Langpui sahlo letah a o cawh ahotahmai thui a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dingnah khah tenah tah a cangsah hlai taco, a tleh-pakupaw ngaithli kung khah tlehchung a be ca ka, a kang leimeipaw me thingthu khah chaisé be. ");
INSERT INTO zypNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mingphing vytei cawh a ming letah hnabeisuinah aa hnui a,” tahpaw tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mataico khachia tei a tlepaw cawngsawpaw, a meh co katei, a rei a thlaw thai lypaw khah Zisu khaco va chuakhui he ka, a dangsah cawtah a rei thlaw khy, khua hmuh khy a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Cawngsaw vytei cawh aa ningang thlang ka, “Ma cawngsaw heh David Pathlah a cang khy sua maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Canghrasala, Farasi sahlo tah ma cawh aa thui tihtah, “Khachia sahlo buipaw Belzabub thongtah ma cawngsawpaw tahei khachia sahlo a papia khy he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Zisu tah aa rawhnah khah hnih ka, aa hai letah, “Ze painah raang hmai, aaning le aaning aa dy caco he a rawh thlu he ka, khuapui maikaw, ingchungkho maikaw aaning leh aaning a rai ly tei, a chaichy caco he a daw khy a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Setan tah Setan a papia caco, ama le ama a dy tah a chaichypaw a cang a. Macawtaco a painah raang cawh zekhatamaw a daw khy a? ");
INSERT INTO zypNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taico Belzabub thongtah Setan ka tingchua pawtei a cang caco, naaning naa cawngsaw sahlo takhei saw, aho thong tamaw aa tingchua he? Macawtaco naa cawngsaw sahlo cawh naaning bia a ca cepahtu a cang tae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Canghrasala khachia sahlo khah Khazing Thlawpaw chawngnah thongtah ka papia pawtei he a cang caco, Khazing painah raang cawh naaning khatah a tlung thah tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ma hlui co, mehthawtlungpaw khah tongchai taw lytah a ing chunglang a nae tah a hnuicho cawh ahomaw a lah pah khy a? Aa tongchai khy taitah longlong a lah khy a. ");
INSERT INTO zypNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kama lang a ung lypaw cawh a pa caraepaw cang ka, kama a pa pahmo khui lypaw cawngsaw cawh a thecadapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Macawtaco ka ca ching he, suanah maikaw le Khazing reipachianah a tuapaw cawngsaw sahlo cawh ngethai khy a cang thlang he a, canghrasala Thlawpaw Pathai a reipachiapaw sahlo cawh ngethai cang a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cawngsaw Sawcapaw a reipachiapaw cawh ngethai khy a cang thlang a. Canghrasala Thlawpaw Pathai a reipachiapaw duitei cawh ato cai lehei cang seh, a va chuh lepaw cai letah cang seh ngethai cang a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Thingkungpaw cawh a kung a chah caco, a thui cawh a chah thlang a, a cang ly leh a kung a chah ly caco, a thui cawh a chia thlang a, zecawtamaw tatah thingkungpaw cawh a thui tah hni khy a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Naaning, pari cangmai pathlah sahlo, naaning mehchawly sahlo taco zekhatamaw biachaw cawh naa reithai a? Lungchung letei a chih hluipaw khah kaw tah a reipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mehchaw taco a lung chung letei a pacungpaw a chawpaw taikhei hmingchaw chuasah ka, mehchawly taco a lung chung letei achaw lypaw a pacungpaw taikhei hming chahly a chuasah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Canghrasala ka ca ching he, biacenah ning leco mingting maikaw cawh aa rei suapaw bia maikaw khah aa rei pase kaw a. ");
INSERT INTO zypNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Zecawtamaw tatah naa bia lilaw khei thai cang he ceh ka, naa bia lilaw khei sua phosah na cang tae he ceh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mataico, Farasi thaikhehpaw sahlo le phungbia cawngpahtu thaikhehpaw sahlo tah Zisu cawh, “Cawngpahtu, ningang chuipaw paching pakhanah hmuh kaa du ngetei, ma tuapah tua,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Zisu taco, “Mehchaw ly le a phei a hmangpaw ato chai cawngsaw tahei ningang chuipaw paching pakhanah aa pa hae hi! Canghrasala Khazing khuavang Jonah paching pakhanah tah cy ly co zehmai peh cang a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zecawtamaw tatah, Khazing khuavang Jonah cawh ngapui richung letah ningthung le zaithung chung a ung. Ma hraco Cawngsaw Sawcapaw heh alui chung letah ningthung le zaithung a ung tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineve khua cawngsaw sahlo cawh ma letei pathlah khahei biacenah letah a daw a he ka, sua aa phosá he a. Zecawtamaw tatah Khazing khuavang a phungreinah thong khei, aa suanah a ngepachih thah he, taico atoheh Khazing khuavang Jonah navy tah alai vypaw cawngsaw cawh ma lehei a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Biacenah ning leco thuilang Abuino Shiba cawh a daw a ka, ato chai cawngsaw sahlo heh thaily a cang sá he a. Zecawtamaw tatah ama cawh Solomon a singnah bia nge rua pawtah alui a changnah taitah va sei a ka, canghrasala atoheh Solomon navy tah a lai vypaw ma lehei a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Thlawpaw pialuipaw cawh cawngsawpaw chung taitah a ka piathlah tihtah raangcaa raangro lekhei a hianah hminghmaw hui tah a khiakaly ka, hmuh be. ");
INSERT INTO zypNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mataico, ‘Ka piasaipaw ing lang khah ka pange kaw thlang a,’ tatah a tah. Ing cawh a va phah tihtah longkarong tah ung ka, pathai pahling teitah chiapaw a cangpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mataico sei ka, ama navy tah a sua vypaw he ahringpaw thlawpaw a pialuipaw pasarih khah va chui he ka, ma ing cawh aa pahrang. Taico, ma cawngsawpaw cawh athoning tei navy khei a hning tei a daw hming cawh a pazua vy syly. Ma hraco atochai mehchawly pathlah sahlo heh aa cang tae a,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zisu cawh zawpuipaw khatah bia a rei chung taco, a no le a uny sahlo cawh khunglai lang letah bia a ching du takhei a daw thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cawngsaw pakheh tah, “Na no le na uny sahlo tah bia a ching ca du he ka, khunglai lang letah a daw thlang he,” tatah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zisu tah ma bia a va chingpaw cawh, “Ka no cawh ahomaw? Ka uny cawh aho sahlo he maw?” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A hningzuitu sahlo khah a kihdong tah so he ka, “Ma sahlo heh ka no le ka uny cawh a cang he hi. ");
INSERT INTO zypNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ka Paw vaicung leteipaw a dunah a tuapaw maikaw cawh ka uny, ka satei le ka no a cang he,” tatah aa hai leco a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ma ning leco Zisu cawh ing taitah piathlah ka, tuiping kae letah a va ty. ");
INSERT INTO zypNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Cawngsaw rungpui tah aa cadung thlangnah cawtah tuilawng chunglang a nae ka, cawngsaw vytei cawh tuiping ngaekang letah a daw thlang chung he takhei tuilawng chung leco a ty thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mataico, aaning sahlo cawh tawchingnah bia a hlupui khah ching he ka, a reipaw cawh, “Ly a tuapaw pakheh cawh thleci va pawtah a ly lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Thleci a va leimei ning takhei a chy cawh lang kae letah tlah ka, pavaw sahlo tah a va zy he ka, aa khi thlu thah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A chy cawh alui a pawnah lungda letah tlah he ka, alui apawnah cawtah sungkheh teitah a ka cy. ");
INSERT INTO zypNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Canghrasala, ning va tha ka, a ai tih he tah aa thahrang aa thlah lynah cawtah a ro palang thah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A chy cawh ahling hrong letah tlah he ka, ahling cawh ka chang ka, a diseh thlu thah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A chy cawh alui a chahnah letah tlah he ka, a leh songthung, a leh songruh, a leh zakheh tah a vui he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Thuinah nawkho a hnuipaw taco ma bia heh thui he seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","A hningzuitu sahlo cawh Ama khatah a vong he ka, “Zecawtamaw zawpuipaw cawh tawchingnah bia tah na ching he?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Zisu taco, “Naaning cawh vaicung painah biaparuh hnikhynah khah peh na cang thah he ceh, canghrasala aaning sahlo cawh peh cang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A hnuipaw cawh peh vy a cang a. A hnui lypaw cawh a hnuitlakangpaw hmai khah lah pah kaw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ma heh tawchingnah bia ka chinghnangnah pawhe cawh a cang, ‘Aa ming thlang naná teitah hmuh bei he, aa thui thlang naná teitah hnih thai bei he.’ ");
INSERT INTO zypNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Khazing khuavang Isaiah a za reihlangpaw bia tlingnah cawh aaning sahlo heh a cang he. ‘Naa thui leimei thlang a, canghrasala naa lunghaa be. Naa ming leimei thlang a, canghrasala hnih a bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Zecawtamaw tatah ma cawngsaw sahlo aa lungthing cawh a ku a chaw. Aa naw papang he ka, aa meh a paco he. Ma taco cang lytah ung my he seh la caw, aa me tah hmuh a he ka, aa naw tah thui ka, aa lungthing tah hnih a he ka, kama lang a va paleh he ka, ka dangsah thá he,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Canghrasala naaning naa meh le naa naw cawh bonghnang aa ting, zecawtamaw tatah khua hmuh he ka, khua aa thui. ");
INSERT INTO zypNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Biahmuisui ka ca ching he, Khazing khuavang a hlupui le mehding sahlo tah naa hmuhpaw heh hmuh aa du ngetei tei hrah naná teitah za hmuh be ca he ka, naa thuipaw heh thui aa du ngetei tei hrah naná teitah za thui bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Thleci a vapaw tawchingnah bia a silang heh ngetua o: ");
INSERT INTO zypNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pakheh kheh tah vaicung painah raang kong thawngchaw khah thui ka, canghrasala a lunghaa be, mehchaw lypaw a vong ka, a lungchung letei vapaw thleci cawh a lah pah hly thlu. Ma heh langkae letei a tlahpaw thleci silang cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lungda cung letei a tlahpaw thleci cawh Khazing bia a thui cangkawleh lunglawng teitah a cyhlangpaw cawngsaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Canghrasala thahrang a thlah ly cawtah khua sy parui bei he. Khazing bia rawng taco ruhanah le hrehnah a chua tihtah a pohly palang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ahling hrong letei a tlahpaw thleci cawh Khazing bia cawh thui thlang ka, canghrasala ma khazaw lung reithuinah le hnuirung dunah takhei thawngchawbia khah pazai thah ka, a thui a thuisah khy lypaw cawngsaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Canghrasala alui a chahnah letei a tlahpaw thleci cawh Khazing bia thui katei, a hnih thaipaw cawngsaw khah a cang. Thui hnui ka, a leh songthung, a leh songruh, a leh zakheh tah a vui,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zisu tah aaning sahlo cawh tawchingnah bia ahringpaw a ching vy he. “Vaicung painah raang cawh a ly letei thleci chaw a vapaw cawngsawpaw khatah a lo. ");
INSERT INTO zypNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Canghrasala ming vytei aa ihning kaa letah a caraepaw cawh a vong ka, changvuh hrong leco lybei cawh va ka, a seihly kaw. ");
INSERT INTO zypNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Changvuh cawh ka cy ka, a hmo a pava tihtah lybei zong cawh a ka lang hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ly a hnuipaw a sae sahlo cawh a vong he ka, ‘Abuipaw, na ly lekhei thleci chaw va bei ceh maw? Zelang tamaw lybei aa va ung he?’ tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Caraepaw tah aa tuapaw a cang,’ tatah a palei he. Sae sahlo taco, ‘Va sei he peh ka, kaa phehly thlu he maw?’ tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘A hy be, zecawtamaw tatah lybei naa phepai khei changvuh zong naa phepai sua he a. ");
INSERT INTO zypNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hre a zawnah tai cyhrui thlang he seh. Hre a zaw tihtah a hretu sahlo khah a hmetaw tah lybei khah pahmo la, me letah bo rua takhei tongchai taw o. Mataico, saze khah pahmo la, ka sachai lehei rai my lo, tatah ka ching tae he a,’ tatah a chai he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zisu tah ahringpaw tawchingnah bia a ching vy he, “Vaicung painah raang cawh cawngsawpaw pakheh tah aihrang ci law katei, a ly letah a cingpaw khatah a lo. ");
INSERT INTO zypNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aihrang ci cawh naa thleci letah a chia caipaw a cang thlang naná teitah a ka cy tih taco buichung thleci hrong letah alai caipaw tah ka cang ka, thingkungpaw tah a katua. Macawtaco pavaw sahlo tah a va zy he ka, a cai sahlo letah a cawng tei he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mataico, ahringpaw tawchingnah bia a ching vy hui he, “Vaicung painah raang cawh canuno tah vedi hongkheh lekhei a pahlawhpaw raangri khatah a lo. Ma raangri taco vedi cawh a tho sahpaw a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Zisu tah ma hming vytei heh tawchingnah bia tah zawpuipaw khah a ching he. Aaning sahlo cawh tawchingnah bia hmang lytah zehmai cawngpah bang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ma cawh Khazing khuavang hmokaw hmang tei reipaw, “Tawchingnah bia khei ka kaw ka ang a, khazaw papining taitei nopaw hming khah ka rei a,” tahpaw bia tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mataico zawpuipaw cawh seisai he ka, ing chunglang a nae. A hningzuitu a vong he ka, a hai leco, “Ly leteipaw lybei tawchingnah bia na reipaw khah ma pase tua,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Zisu taco, “Thleci chaw a vapaw cawngsaw cawh Cawngsaw Sawcapaw heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ly cawh khazaw heh cang ka, thleci chaw tahpaw cawh vaicung painah raang sawtei sahlo khah a cang he. Lybei tahpaw cawh mehchaw lypaw sawtei sahlo khah cang he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ma lybei khah ly letei a vatupaw caraepaw cawh Setan khah a cang. Saze hre cai cawh caichangnah khah cang ka, saze hretu sahlo cawh vaiming a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lybei sahlo cawh phehly tei, me letah bo aa cangpaw hratah caichangnah leco a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Cawngsaw Sawcapaw tah a vaiming sahlo khah taw a he ka, aaning sahlo taco suanah a chua sahpaw hming maikaw le chahlynah a tuapaw vytei he khah phehly he ka, a painah cawh aa pathaisah a. ");
INSERT INTO zypNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aaning sahlo cawh caw le haw rianah hminghmaw a cangpaw ase hulupaw mepho lang khah aa thla he a. ");
INSERT INTO zypNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mataico, mehding sahlo cawh aa Paw painah raang chung lekhei ning hratah a khai he a. Nawkho a hnuipaw taco thui seh. ");
INSERT INTO zypNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Vaicung painah raang cawh ly letei nopaw cho khatah a lo. Cawngsawpaw tah ma cawh a hmuh tihtah nawh kaw ka, lunglawng hmotah va sei ka, a hnuipaw vytei va zua ka, ma ly cawh a cawh. ");
INSERT INTO zypNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Taico vaicung painah raang cawh lungnaw achawpaw a huilaipaw chohrawngpaw khatah a lo. ");
INSERT INTO zypNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Amai a ru ngeteipaw sangkheh khah a hmuh tihtah va sei ka, a hnuipaw vytei khah va zua ka, ma cawh a cawh. ");
INSERT INTO zypNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ma hlui co vaicung painah raang cawh tuili letah thlah he katei, ngaw phing zakih khah a tle pahmopaw aso khatah a lo. ");
INSERT INTO zypNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A chi tihtah ngawtletu sahlo takhei ngaekang lang aa hrui hly. Mataico a ty he ka, ngaw achawpaw cawh songpia chunglang sang he ka, achiapaw cawh aa vathlang. ");
INSERT INTO zypNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma hrahei caichangnah letaco a cang a. Vaiming sahlo cawh a vong he ka, mehding taikhei mehchawly khah patlia he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aaning sahlo cawh caw le hawrianah hminghmaw a cangpaw a seh hulupaw mepho chunglang khah aa thla he a. ");
INSERT INTO zypNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma hming vytei heh naa hnithai thah maw?” tatah a hae he. Aaning sahlo taco, “Kaa hnithai thah,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Zisu taco aa hai letah, “Macawtaco vaicung painah raang kong cawngpahtu a cang pawhe phungbia cawngpahtu a cangpaw maikaw cawh aa chochianah ing letei aa cho a thapaw kha, ahlungpaw kha a thothlah leimeipaw ing hnuitu khatah a lo he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zisu tah ma tawchingnah bia a reipaw sahlo heh a pachang tihtah ma hminghmaw cawh a seisai. ");
INSERT INTO zypNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A pinah khua lang khah va sei ka, cawngsaw sahlo khah aa synagog lekhei cawngpah he ka, aa ning a ang ngetei. “Ma cawngsawpaw tahei zeletamaw ma singnah le ningang chuipaw hmingtuakhynah sahlo heh a lah? ");
INSERT INTO zypNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ama heh kih zung thaipaw a sawcapaw khah cang bei maw? A no ming khah Mari cang bei maw? A uny sahlo cawh Jeims, Josef, Simon le Judas cang bei he maw? ");
INSERT INTO zypNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A satei sahlo zong kaaning khatah ma lehei ung thlang hrah bei he maw? Ma cawngsawpaw tahei zeletamaw ma hming vytei heh a lah he?” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Taico a cung letah aa lungtling be. Canghrasala Zisu taco aa hai letah, “Khazing khuavang cawh a pinah khua le ama a ingchungkho letah tah cy ly co kawkih letah pasungpanaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Taico zingnah aa hnui lynah cawtah khei ma leco ningang chuipaw a hlupui tua be. ");
INSERT INTO zypNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma cai leco abui Herod taco Zisu kong khah thui ka, ");
INSERT INTO zypNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a kih rai leteipaw sahlo khah, “Ma cawngsaw heh baptisma peitu Johan khah a cang, thihnah taitah a tho kaw thah hi! Macawtaco, ningang chuipaw hmingtuakhynah a hnuipaw a cang hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod takhei a nyteipaw Filip a nupuino Herodi rawng tah baptisma peitu Johan cawh tlesah he ka, bahrairui a khisah he ka, thong letah a thlah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Zecawtamaw tatah Johan tah Herod khah, “Na nytei a nupui na chupaw heh a phung cang be,” tatah a mochia cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod taco Johan cawh thaw a du naná teitah zawpuipaw khah a ci he, zecawtamaw tatah zawpuipaw taco baptisma peitu Johan cawh Khazing khuavang a cang tatah aa tah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod a chua ning letah Herodi a sawcanu takhei langpah he ka, Herod cawh a lung a lawngsah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Macawtaco Herod takhei Herodi a sawcanu cawh na pa haepaw maikaw cawh ka ca pae a, tatah chia a sah hmo khei bia a kaang. ");
INSERT INTO zypNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A no tei a pasypaw hrakhei, “Baptisma peitu Johan a lu khah daabakho tah va pa pei law,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Abui Herod cawh a lung rei a thui ngetei, canghrasala khuachai sahlo hme letah bia a kang thah cawtah khei nyno tei a haepaw khah pae pawtah naw pei he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","baptisma peitu Johan cawh thong chung lekhei a lu a va taisah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A lu cawh dabakho khei va tle he ka, nyno cawh a peh, nyno taco a no khatah a seikhui. ");
INSERT INTO zypNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Baptisma peitu Johan a hningzuitu sahlo cawh a vong he ka, a rawh cawh law he ka, aa phung. Mataico va sei he ka, Zisu cawh aa va ching. ");
INSERT INTO zypNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zisu tah ma thongpang cawh a thui tihtah Ama longtei khei tuilawng tah seihly ka, a kingdangnah lang khah a sei. Khuapui sahlo taitei ma thongpang a thuipaw zawpuipaw taco aa phe tah sei he ka, Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zisu cawh tuilawng taitah ka piathlah ka, cawngsaw zawpui khah a hmuh tih he tah ningdo he ka, a sahpaw maikaw khah a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Zailang ning a ne tihtah a hningzuitu sahlo cawh Zisu khatah a vong he ka, “Ma heh raang kingdang tah cang ka, ningkhua zong a tle ngetei myca. Zawpui heh thlaw la, khuatei sahlo lang va sei he seh la, aaning teitah e ruapaw batui a va cawh he seh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zisu taco, “Aaning aa seihly a nge be. Naaning tah e ruapaw cawh pei o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A hningzuitu sahlo taco, “Kaaning cawh very tlangpangaw le ngaw sanghning suipui kaa hnui ky caw!” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zisu taco, “Va tle tua o,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mataico zawpui cawh araang cung lekhei a ty law tatah a tah he. Very tlang pangaw le ngaw sanghning cawh law ka, avai lang a y ka, Khazing khatah lawngbia a hlai. Taico very tlang sahlo cawh a kychy. Mataico a hningzuitu sahlo cawh pei he ka, a hningzuitu sahlo taco zawpui cawh aa rai he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aa zongmingtei co e he ka, aa ri a vaw thlu. Taico a hningzuitu sahlo taco aa ebangpaw cawh pakhong he ka, bai hrawhluihning chih ky tah aa dui. ");
INSERT INTO zypNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Very a epaw cawh canu le nyheh rei lytah capaw puitling 5000 a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Zawpui khah a disah chung he takhei Zisu tah a hningzuitu sahlo cawh rairang tah tuilawng chunglang a naesah he ka, raechai lang khah a seisah hlang he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Zawpui khah a disah thlu khy tai he tah tlang cung lang khah thlawchang pawtah Ama teitah a sei. Ning a va zailang tihtah ma leco Ama teitah a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Canghrasala tuilawng cawh tuiping ngaekang taikhei langhlaw nong phah thah ka, tuileh takhei paleh hly neh a tah leimei, zecawtamaw tatah thli tah a rupui tah a nang he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Monglang suimehlang papali hrong lekhei Zisu cawh tui cung co, aaning lang a va sei. ");
INSERT INTO zypNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tui cung tei a seipaw khah a hningzuitu sahlo tah aa hmuh tihtah a pahly ngetei he ka, “Athlaw a cang,” tah he ka, aa ci hmotah a ysang he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Canghrasala ma cangkawleh cawh Zisu tah, “Naa thlawzawng kheh seh. Kama ka cang hi. Ci khe o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piter taco, “Abuipaw, nama na cang caco, tui cung lehei nama kha va pa seisah tua hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Zisu taco, “A vong,” tatah a tah. Mataico, Piter cawh tuilawng chung taico cung thlah ka, tui cung leco sei ka, Zisu khaco a vaw. ");
INSERT INTO zypNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Canghrasala, thli a rupaw a va hrangpaw khah a hmuh tihtah a thlawzawng ka, tui lang tlah a zaa cawtah khei, “Abuipaw, pa pachah tei law!” tatah a ka y. ");
INSERT INTO zypNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma cangkawleh cawh Zisu tah a kiá khei va pazah ka, a va tle. “Nama zingnah a cawngpaw, zecawtamaw zing lynah na hnui?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Taico tuilawng chunglang aa nae cangkaw he leh thli cawh a de. ");
INSERT INTO zypNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mataico, tuilawng chung letei a ungpaw sahlo takhei beh he ka, “Nama cawh Khazing Sawcapaw na cang hrahring thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Raechai lang khah va cakah he ka, Genesaret raang khah aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Taico ma hrawng leteipaw cawngsaw sahlo taco Zisu a cang tahpaw khah aa hni tihtah ma raang kaekang leteipaw vytei khah bia aa caw he. Cawngsaw sahlo taco a sahpaw sahlo khah Ama khaco va chuakhui he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“A sahpaw sahlo heh na pai dong tei chang tongsah ky he law,” tatah naw he ka, Ama a tongpaw vytei cawh a dang he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mataico, Farasi thaikhehpaw le phungbia cawngpahtu thaikhehpaw sahlo khah Jerusalem khuapui taitah Zisu khatah a vong he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Zecawtamaw na hningzuitu sahlo tah pupaw phungbia aa ro zia? Batui aa e hlai tah aa kih a si bei dei he!” tatah Zisu cawh aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Zisu taco, “Zecawtamaw naaning zong tah naa phungbia rawng tah Khazing biapeh cawh naa ro? ");
INSERT INTO zypNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Zecawtamaw tatah Khazing tah, ‘Na no le na paw cizaw my lo,’ taico, ‘A no cang seh, a paw cang seh chia a sahpaw cawh thaw a cang a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Canghrasala, naaning taco, cawngsaw pakheh tah a no a cang ly leh a paw khatah, ‘Kama taitah na hmuh khy a paw bawkhangnah cawh Khazing khatah tholong tah ka peh thah,’ a tah caco, ");
INSERT INTO zypNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‘ma cawngsawpaw cawh ma hming khei a no a cang ly leh a paw cawh a cizaw a hy khawh be,’ naa tah. Ma hraco naaning na cawngpah chawngpaw he ceh phunglang cawtah Khazing bia cawh naa paleh naa pahnaw tei. ");
INSERT INTO zypNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naaning cungmai raipha sahlo! Khazing khuavang Isaiah tei naa kong a reihlangpaw heh ahmang caimang. ");
INSERT INTO zypNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ma cawngsaw sahlo tahei aa hmokaw tah aa pa cizaw, canghrasala aa lungthing cawh kama taitah a hlah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aa pa behpaw zong heh aa cawtah zehmai chahnai be. Aa cawngpahnah zong heh mehnung tah tuachawngpaw phungphe sahlo suipaw a cang he,’ tatah a cia,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zisu tah mingzawpui khah Ama khatah y he ka, “Ka bia heh nawthlia la, thuithai my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kaw lang tei a naepaw taco cawngsaw cawh papia palui bei hi, canghrasala kaw lang tah a ka piapaw tahei cawngsaw cawh a papia palui hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mataico a hningzuitu sahlo cawh a vong he ka, Zisu cawh, “Ma bia na reipaw khah aa thui tihtah Farasi sahlo cawh aa thing a ae tahpaw na hni maw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zisu taco, “Ka Paw vaicung leteipaw tei a lingpaw a cang lypaw thingkungpaw maikaw cawh a hrang tah pheh hly a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aaning sahlo cawh seisai thlang o, langchuitu mehco a cang he khi. Mehco tah mehco cawh langpui a chui caco, aa pahning tah khobatlung lang aa tla a,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piter taco, “Ma tawchingnah bia cawh ma pase tua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Zisu taco, “Ma tlua co maw naa lung a co thlang? ");
INSERT INTO zypNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kaw lang a naepaw cawh ri za phah ka, mataico alailang a piahly kaw tah hnih bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Canghrasala kaw taitei a piapaw bia cawh lungthing taitah a ka chuhpaw cang ka, ma taco cawngsaw khah a papia a palui. ");
INSERT INTO zypNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Zecawtamaw tatah lungthing taihei khuarawnah a chiahrupaw, lenongnah, a pheinah, canu capaw suanah, ruhnah, ahmang lypaw hnikhuitu cangnah le, male thai pachianah sahlo heh a chuh. ");
INSERT INTO zypNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ma sahlo heh cawngsaw a papia a paluipaw cawh a cang he, canghrasala kih si ly tei batui enah taco cawngsaw cawh papiapalui be,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Zisu cawh ma hming taico piathlah ka, Tair le Sidon raang lang khah a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma raang chung letei a ungpaw Kanaan cawngsawno pakheh cawh Zisu khaco a vong ka, “David Pathlah, Abuipaw ning pa do ky law! Ka sawcanu cawh khachia tah a tle cawtah a tai-ing tu thlang,” tatah a ysang. ");
INSERT INTO zypNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Zisu tah kaw kheh hmai chai be. Macawtaco, a hningzuitu sahlo a vong he ka, a hai leco, “Seihly law tah thlang, kaa hninglang tah ma zuilai ka, a y leimei thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zisu taco, “Kama cawh Israel mingphing taitei tuu a lypaw khatah suipui taw ka cang!” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Cawngsawno cawh a vong ka, a hme letah a khuh panai ka, “Abuipaw, pa baw ky law!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zisu taco, “Sawtei leh aa very cawh lá tah ui sahlo peh cawh a phung cang be,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Canuno taco, “A cang thlang, Abuipaw, canghrasala ui sahlo taco aa buipaw a cabuai taitei a tlahpaw didang cawh aa khi thlang hrah!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mataico Zisu tah, “Cawngsawno, nama cawh zingnah a pacypaw a hnuipaw na cang! Na dupaw khah peh na cang a,” tatah a chai. Taico a sawcanu cawh ma suimehlang cai lalei leco a dang kaw. ");
INSERT INTO zypNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zisu cawh mataico piathlah ka, Galili rili ngaekang hrong khei a sei. Mataico tlaang cung lang ke ka, a ty. ");
INSERT INTO zypNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Cawngsaw rungpui cawh Ama khaco a vong he ka, a cabepaw, a mehcopaw, a songbepaw, a rei a thlaw thai lypaw le ahringpaw asawnah a ingpaw sahlo khah va chuakhui he ka, a phehrang leco chia he ka, a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A rei a thlaw thai lypaw tah bia rei, a songbepaw tah langsei, a cabepaw tah langsei, a mehcopaw tah khua hmuh tatei aa tahpaw khah aa hmuh tihtah cawngsaw rungpui cawh aa ning a ang thlang. Taico Israel Khazing khah aa reithai. ");
INSERT INTO zypNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zisu tah a hningzuitu sahlo cawh y he ka, “Ma cawngsaw sahlo heh kama khatah ningthung ung myca he ka, e ruapaw zehmai aa hnui ly cawtah ka ning aa pa do ngetei. Aa ngaidi hmo hei tlungsah my he neh seh la, langpui letah a baw he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A hningzuitu sahlo taco, “Ma raang kingdang lehei ma vytei mehnung dang ruapaw lawh heh zeletamaw kaa la a?” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Zisu taco, “Very tlang khazeh maw naa hnui?” tatah tah he ka, “Tlangsarih le ngadih a cawngpe,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Zisu tah ming zawpui cawh alui letah a tysah he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mataico, very tlangsarih le ngadih cawh law ka, Khazing khatah lawngbia a hlai khy taitah kychy ka, a hningzuitu cawh pei he ka, zawpui khah aa rai he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aa zongmingtei co e he ka, aa ri a vaw ngetei. Taico a hningzuitu sahlo tah e bangpaw cawh pakhong he ka, baisarih chih ky tah aa dui. ");
INSERT INTO zypNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Very aa epaw sahlo cawh canu le nyheh rei lytah capaw puitling 4000 a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mingzawpui cawh a seisah hly khy tai he tah Zisu cawh tuilawng chunglang a nae ka, Magadan raang chung lang khei a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farasi sahlo le Sadusi sahlo cawh a vong he ka, Ama khah pase du takhei vaicung lang tei ningang chuipaw paching pakhanah ma hmuhsah tua tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zisu taco, “Zailang a va chua tihtah, ‘Avai a lei sai ka, ningkhua a chah a,’ tah he ceh ka, ");
INSERT INTO zypNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","mongrang leco, ‘Avai a lei sai ka, khua a paningnah cawtah atoning cawh ningkhua a chia a,’ tatah naa tah. Avai ming he ceh ka, ningkhua zemaw a lo a tah cawh naa hni ngetei, canghrasala cai paching pakhanah cawh hnih khy bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mehchaw ly le a phei a hmangpaw atochai cawngsaw tahei ningang chuipaw paching pakhanah naa hui, canghrasala Khazing khuavang Jonah paching pakhanah tah cy ly co zehmai peh cang bei ceh,” tatah a chai he. Mataico Zisu taco piasai he ka, a seihly. ");
INSERT INTO zypNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tuiping cawh aa cakah tihtah a hningzuitu sahlo taco very a pho aa monghly. ");
INSERT INTO zypNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zisu taco aaning sahlo cawh, “A raering my lo. Farasi sahlo le Sadusi sahlo raangri lekhei a raering my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aaning le aaning cawh a cekanawh he ka, “Very kaa pho ly cawtah a reipaw a cang hi,” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zisu tah aa reipaw bia khah hnih ka, “Naaning, zingnah a cawngpaw sahlo, zecawtamaw very naa hnui lypaw kong cawh naa rei leimei? ");
INSERT INTO zypNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ato tingtai hnih thai ting bei he ceh maw? Very tlang pangaw tah mehnung 5000 ka dangpaw he le a hluipaw bai khazeh maw chih ky tah naa dui tahpaw khah a thui khawh bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A cang ly leh very tlangsarih tei mehnung 4000 ka dangpaw he le a hluipaw khah bai khazeh maw chih ky tah naa dui tahpaw khah saw? ");
INSERT INTO zypNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Naaning khahei very kong rei bei neh tahpaw heh zekhatah zia tamaw naa thui thai be? Canghrasala Farasi sahlo le Sadusi sahlo aa raangri lekhei a raering my lo.” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mataico, very letei hmangpaw raangri letah a raering rua pawtah ma ching be, Farasi sahlo le Sadusi sahlo cawngpahnah letah a singkang rua pawtah a ma chinghripaw a cang hi tahpaw khah aa thuithai. ");
INSERT INTO zypNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zisu cawh Sisaria Filipi pai a va phah tihtah a hningzuitu sahlo khah, “Cawngsaw Sawcapaw heh cawngsaw tah aho a cang aa tah maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aaning sahlo taco, “Thaikhehpaw tah baptisma peitu Johan aa ca tah, thaikhehpaw tah Elija a cang ca tah he ka, ahringpaw taco Jeremai a cang ly leh Khazing khuavang pakheh kheh a cang aa ca tah,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Naaning tah saw aho a cang naa pa tah maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piter taco, “Nama cawh Khazing hring Sawcapaw Khri na cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zisu taco, “Jonah a sawcapaw Simon, nama cawh bonghnang a tingpaw na cang, zecawtamaw tatah ma heh cawngsaw tah nama aa ca hnisahpaw cang be, ka Paw vaicung leteipaw tah a ca hnisahpaw a cang hri hi. ");
INSERT INTO zypNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Taico nama cawh Piter na cang tahpaw ka ca ching, taico ma alung cung lehei ka khrisawbu padaw neh ka, hraihming hawkaw tah te khy be. ");
INSERT INTO zypNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Vaicung painah raang cabi sahlo cawh nama ka ca pae a. Nama tei alui letah na tongchaipaw he cawh avai letah tongchai cang tae hrá he ka, nama tei alui letah na thlangpah pawhe cawh avai letah thlangpah a cang hrá he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mataico, a hningzuitu sahlo cawh Khri a cangpaw khah ahohmai ching khe lo tatah raeringnah a peh he. ");
INSERT INTO zypNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ma cai taico Zisu tah a hningzuitu sahlo khah Jerusalem khuapui lang sei katei, macang sahlo, tlangbui macang sahlo le phungbia cawngpahtu sahlo kia tah taithuinah a hlupui ing a ka, aa thaw a, canghrasala a ningthungnah letah hringnah letah thosah a cang nápaw kong khah a ching pase he. ");
INSERT INTO zypNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piter taco a cakih lang seikhui ka, “Abuipaw, Khazing tah arai tah a be, ma cawh na cung letah tlung by be!” tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zisu taco Piter khah a huihno ka, “Setan, kama taihei seihly. Nama cawh ka cawtah a pachihlynah na cang. Khazing lang hming khah pacang ly ceh tah cawngsaw lang hming na pacang hri hi!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Taico, Zisu tah a hningzuitu sahlo cawh, “Ahohmai zui a pa dupaw cawh ama a dunah khah seisai seh la, a khraws cawh a puh seh la, pa zui seh. ");
INSERT INTO zypNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Zecawtamaw tatah a hringnah pachah a dupaw taco hly a ka, canghrasala Kama ka rawng tah a hringnah a hlypaw taco a hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Cawngsaw pakheh tah khazaw heh a pungpaluh tah hnui seh la, a thlawpaw a sung caco, zemaw a cawtah a chahnai a? Cawngsaw tah a thlary khah hmuh kaw a pawtah zemaw a peh khypaw a ung? ");
INSERT INTO zypNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Zecawtamaw tatah Cawngsaw Sawcapaw cawh a Paw rungnawnah le a vaiming sahlo khatah a vong ka, mataico pakheh cy khah aa tuapaw naning tei hrakhei lahsong a pae he a. ");
INSERT INTO zypNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Biahmuisui ka ca ching he, Cawngsaw Sawcapaw cawh a painah raang letah a va chuapaw aa hmuh hlai taco, ma letei a daw thlangpaw sahlo hrong lehei mehthaikheh cawh thi balang bei he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ningruh khy tah Zisu tah Piter, Jeims le a unypaw Johan khah y he ka, aaning teitah tlaang sangpaw cung lang a kekhui he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma leco aa hmekaw letah a hmuisang cawh a thlai. A hme cawh ning hratah khai ka, a chaichi cawh lailaw hratah a khai. ");
INSERT INTO zypNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma khy cangkaw leco, aa hmekaw letah Moses le Elija a va lang he ka, Zisu khatah bia aa reihrui leimei. ");
INSERT INTO zypNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piter taco Zisu cawh, “Abuipaw, ma lehei ung heh kaa cawtah a chah ngetei. Na du caco, thlangda sangthung tah ka sah a, nama na cawtah sangkheh, Moses cawtah sangkheh, Elija cawtah sangkheh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bia a rei leimei chung taco meding a khaipaw takhei aaning cawh pahlong he ka, meding chung taico, “Ma heh ka dopaw ka Sawcapaw a cang, a cung lehei ka lung a lawng ngetei. A bia nge my lo!” tatah o a za ring. ");
INSERT INTO zypNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A hningzuitu tah ma bia cawh aa thui tihtah ci tu he ka, aa hme cawh alui lang a khuh he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Canghrasala Zisu cawh a vong ka, tong he ka, “Tho tua o, naa thlawzawng kheh seh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aa ka ming tihtah Zisu tah cy lyco ahohmai hmuh bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tlaang cung taitah aa za cungthlah ning takhei Zisu tah, “Cawngsaw Sawcapaw heh thihnah taitah patho kaw a cang hlai vytei cawh naa hmuhpaw khah ahohmai ching khe lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A hningzuitu sahlo taco Zisu cawh, “Zecawtamaw phungbia cawngpahtu sahlo tah Elija a vong taw hrahring a tatah aa tah?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zisu taco, “Ahmangpaw a cang, Elija cawh a vong a ka, zezongpui khah a parai pacia a. ");
INSERT INTO zypNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Canghrasala ka ca ching he, Elija cawh a vong thah ka, hnih bei he. Aa dudú khei ama cawh tua he ka, ma hraco Cawngsaw Sawcapaw zong heh aa kih letah taithuinah a ing hra a,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mataico a hningzuitu sahlo tah baptisma peitu Johan kong a ma ching hi tahpaw khah aa thui thai. ");
INSERT INTO zypNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Zawpuipaw khah aa va chua tihtah pakhehpaw tah Zisu cawh a va ne ka, a hme letah a khuh a panai. ");
INSERT INTO zypNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Abuipaw, ka sawcapaw heh hruihri hnui ka, a taithui tu thlang, ning pa do pah ky. Me lang a bo tei ka, tui lang a tlah tei. ");
INSERT INTO zypNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na hningzuitu sahlo khatah va chuakhui neh ka, canghrasala dangsah khy bei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zisu taco, “Vy zingnah a hnui lypaw le meh paleh meh pathae cawngsaw sahlo, zetih tai maw naaning khatah ka ung a? Ze tih tai maw ka lung ka ca pasua pá he a? Nyhehpaw cawh a vong khui tua o,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Zisu taco khachia cawh a hrangso ka, khachia cawh nyhehpaw chung taico ka pia ka, ma cangkaw leco, nyhehpaw cawh a dang palang. ");
INSERT INTO zypNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mataico, a hningzuitu sahlo cawh aaning teitah Zisu khaco a vong he ka, “Zecawtamaw kaaning tah kaa papia khy be?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Zisu taco, “Naa zingnah a cawng tu cawtah a cang. Biahmuisui ka ca ching he, aihrang hmu tia tei chang zingnah naa hnui caco, ma tlaang heh, ‘Ma taihei pawlang kheh a hnei,’ tah la, a hnei thlang a. Naa cawtah a cang khy lypaw ung be. ");
INSERT INTO zypNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Canghrasala ma hapaw hming heh cawh thlawchangnah le batui cahenah lypaw co papia khy cang bei he,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galili raang lang hmokheh tah aa va sei tihtah aa hai letah, “Cawngsaw Sawcapaw heh cawngsaw sahlo kih letah luithae a cang myca a. ");
INSERT INTO zypNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aaning sahlo taco thaw a he ka, taico ningthung khy letah hringnah letah thosah a cang a,” tatah a tah he. Taico a hningzuitu sahlo cawh aa nge a chia ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Zisu le a hningzuitu sahlo cawh Kapernaum khua aa va phah khy taitah behnah ing ngungkhui a kheipaw sahlo cawh Piter khatah a vong he ka, “Naa cawngpahtu tah behnah ing ngungkhui cawh khei bei maw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piter taco, “A khei thlang,” tatah a palei he. Piter ing chunglang a za nae tihtah Zisu taco bia ka chai ka, “Simon, zekhatamaw na rawh? Alui bui sahlo tah ngungkhui le luimai sahlo khah aho sahlo maw aa khei he? Aaning aa sawtei leh maw a cang ly leh ahringpaw sahlo khah maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piter taco, “A hringpaw sahlo khah,” tatah a chai. Zisu tah, “Ma hratei a cang caco, sawtei sahlo cawh a eisah he a. ");
INSERT INTO zypNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Canghrasala lungchah ly tei tua heh cawh chah be, tuiping lang va sei la, na kuipaw khah va thlah tua. Na tle tawpaw ngaw khah a kaw va ky la, tangka phaesai phaepali na hmuh a. Ma cawh va tle la, nama na caw le kama ka cawtah va khei my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma cai leco a hningzuitu sahlo cawh Zisu khatah a vong he ka, “Vaicung painah raang letah ahomaw a lai caipaw a cang a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zisu taco nyhehpaw khah y ka, aa hrong letah a dawsah. ");
INSERT INTO zypNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Taico, “Biahmuisui ka ca ching he naa lung a thlai tah nyheh sahlo hratah naa cang ly caco, vaicung painah raang letah a nae by bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Macawtaco ma nyhehtei hrahei ama le ama a panypaw cawngsaw cawh vaicung painah raang letah alaicaipaw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Taico ka ming tah ma hrahei nyhehtei a cyhlangpaw cawh kama a pa cyhlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Canghrasala pakheh kheh tah Kama a pa zingpaw nyhehtei pakheh khah a suasah caco, a hirong letah saang rianah lung pathle tah rili a thunah lang thlah he seh la, a cawtah a chah vy a. ");
INSERT INTO zypNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Khazaw letei cawngsaw a sua sahpaw hming sahlo cawh aa cing a ping! Ma hapaw hming sahlo cawh aa ung ruapaw a cang thlang. Canghrasala, ma a ung sahpaw cawngsaw cawh a cing a ping! ");
INSERT INTO zypNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Na kih a cang ly leh na phe tah a ca suasah caco, taichung la vathlang. Kih rahning a cang ly leh phe rahning tei chaizaw me lang vathlang cang navy co, kih cung hmo a cang ly leh a cabe hmo tei chaizaw hringnah lang a nae cawh na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mataico, na meh tah a ca suasah caco, khy hly la, vathlang thlang. Meh rahning chi tah hraihming me chung lang vathlang cang navy co, meh rahkheh khatah chaizaw hringnah letah a nae cawh na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ma nyheh sahlo letei pakheh hmai heh mingchuh ruapaw cang bei he, tah heh hnih my lo. Zecawtamaw tatah vaicung letei a ungpaw aaning aa vaiming sahlo tah ka Paw vaicung leteipaw a hme aa hmuh leimei thlang tah heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma hlui co, Cawngsaw Sawcapaw cawh a lypaw sahlo khah pachah ruapaw tah a vongpaw a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zekhatamaw naa rawh? Cawngsaw pakheh tah a hnuipaw tuu zakheh lekhei sangkheh ly seh la, songkua sangkuapaw cawh tlangpa letah seisai tah a lypaw sangkheh khah hui rua pawtah sei bei maw? ");
INSERT INTO zypNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Taico biahmuisui ka ca ching he, a lypaw cawh a hmuh kaw caco, a ly lypaw songkua sangkuapaw navy co, a hmuh kawpaw sangkheh cung lekhei a lawng vy syly a. ");
INSERT INTO zypNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ma hraco naa Paw vaicung leteipaw taco ma nyheh sahlo letei pakheh heh hmai aa ly rua pawtah sai bei he hi. ");
INSERT INTO zypNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Na unypaw tah na cung letah a sua caco, a vaw la, naa pahning teitah naa ungning tah a panah khah va ching pase. Na rei a ca nge caco, na unypaw khah na pahnei kaw tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Canghrasala na rei a ca nge ly caco, cawngsaw pakheh a cang ly leh pahning tah a chui la, ma hnikhuitu pahning a cang ly leh pathung taco hming a chuacangnah khah aa pacy sá a. ");
INSERT INTO zypNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aaning aa bia cawh a nge du lypaw tei a cang caco, khrisawbu khah ching la, khrisawbu bia hmai a nge du lypaw tei a cang caco, lawki cawngsaw a cang ly leh ngungkhui kheitu hrakhei va rawh thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Biahmuisui ka ca ching he, alui letei naa tongchaipaw cawh vaicung letah tongchai cang hrá ka, alui letei naa thlangpahpaw cawh vaicung letah thlangpah a cang hrá a. ");
INSERT INTO zypNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma hlui co, aluicung letei cawngsaw pahning tah hming sangkheh kheh hae rua pawtah naa naw a tlah caco, ka Paw vaicung leteipaw tah ma cawh a ca tua pah thlang he a. ");
INSERT INTO zypNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Zecawtamaw tatah ka ming tah cawngsaw pahning pathung tah aa pahmonah pawhe leco aaning khatah ka ung hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Taico Piter cawh Zisu khatah a vaw ka, “Abuipaw, ka unypaw tah ka cung letah a sua tihtah uikhazeh maw ka ngethai a? Uisarih tai maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Zisu taco, “Ka ca ching, uisarih cang be. Ui songsarih aleh sarih. ");
INSERT INTO zypNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Macawtaco vaicung painah raang cawh a sae sahlo khatah luibah cazing pase a dupaw siangpahrang hratah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ahrangtho leco tangka a nuai hlupui a bahpaw cawngsawpaw cawh aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ama taco a chang khylynah cawtah chang khy ruapaw tah a siangpahrang tah ama kha, a nupui kha, a sawtei leh kha, a hnuipaw vytei kha va zua o, tatah bia a peh. ");
INSERT INTO zypNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Saecapaw taco a hme leco a khuh panai ka, ‘Pa ngethai cong ky la, a zongming teitah ka ca chang tae thlang a,’ tatah a naw. ");
INSERT INTO zypNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A siangpahrang taco ningdo ngetei ka, a dycui cawh ngethai ka, a thlaw. ");
INSERT INTO zypNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Canghrasala ma saecapaw cawh va sei ka, saecapaw a cang hrahpaw pakheh ama tangka a cawngtei a bahpaw khah a tong. Tle ka, a rong khei dih ka, ‘Dycui pachang myca,’ tatah a haechai. ");
INSERT INTO zypNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Sae a cang hrahpaw a vesawpaw taco a khuh panai ka, ‘Pa ngethai cong la, ka ca peh tae thlang a,’ tatah a naw. ");
INSERT INTO zypNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Canghrasala du be. Va sei ka, cawngsawpaw cawh dycui a chang thlu hlai vytei khah thong letah a va thlah. ");
INSERT INTO zypNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ahringpaw sae sahlo tah ma cawh aa hmuh tihtah aa ngechia ngetei ka, va sei he ka, aa siangpahrang cawh hming a chuacangnah vytei khah aa va ching. ");
INSERT INTO zypNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mataico siangpahrang taco ma saecapaw cawh a ysah he. ‘Nama sae chawly, na pa naw leimeinah cawtah dycui na pa bahpaw vytei khah ka ca ngethai. ");
INSERT INTO zypNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na cung letah ningdonah ka hnuipaw hratah na vesaw a cangpaw saecapaw cung letah ningdonah hnui bei ceh maw?’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A siangpahrang cawh a thingae ngetei ka, a bahpaw a chang thlu hlai vytei khah thong-ing a vaitupaw letah hreh ruapaw tah a peh. ");
INSERT INTO zypNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Naa uny khah naa lungthing tah naa ngethai ly he a cang caco, ka Paw vaicung leteipaw tah ma hrakhei a ca tua hrá he a,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zisu cawh ma bia a reipaw a pachang taico Galili raang taikhei a tho ka, Jordan tuivaw raechai lang tei a ungpaw Judia raang lang khah a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cawngsaw rungpui taco zui he ka, ma leco a dang lypaw khah a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farasi thaikheh sahlo cawh Ama pase rua paw takhei a vong he. “Ze rawng a cang zong tah capaw tah a nupui mah heh a phung a cang maw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Zisu taco, “Zezong a Tuatupaw taco ahrangtho ning taco, ‘Canu le capaw tah a tua he,’ tah ka, ");
INSERT INTO zypNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Ma rawng taco capaw tah a no le a paw khah seisai a he ka, a nupui khatah a pahlawng a ka, ma tlaw pahning cawh ngaisaw pungkheh tah aa cang a,’ tahpaw heh Capathai letah rei bang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Macawtaco aaning cawh pahning cang khawh bei he, pakheh a cang myca he. Macawtaco Khazing tei a patongpaw he cawh cawngsaw tah pachai kheh he seh,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Ma hratei a cang caco, zecawtamaw Moses taco capaw tah a nupui cawh mahnah ca pei seh la, seisah my seh lo tatah naw a peh zia?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zisu taco, “Moses tei naa nupui leh mahnah naw a ca pehpaw he cawh naa lung a khong tunah cawtah a cang. Canghrasala a thoning taco, ma hrahei cang be. ");
INSERT INTO zypNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A nupui tah capaw khatah a suasai tah tlung lypaw tah nupui mah katei, nupui hringpaw a chuipaw cawngsaw cawh a pheipaw a cang. Mah ciapaw canu a chuipaw cawngsaw zong a pheipaw a cang hrah taheh ka ca ching he.” ");
INSERT INTO zypNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A hningzuitu sahlo taco a hai letah, “Nupui pasae kong letah ma hratei a cang caco, nupui pasae hnui lytah ung a chah vy thlang!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Zisu taco, “Ma bia heh ming maikaw tah cyhlang khy bei he. Khazing tah a bongpaw cawngsaw long tah aa cyhlang khy a. ");
INSERT INTO zypNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Zecawtamaw tatah thaikhehpaw sahlo cawh aa pi ná tah aa ku a thi. A hringpaw sahlo cawh cawngsaw tah ma hraco tua he ka, ahringpaw taco vaicung painah raang rawng takhei nupui chui du bei he. Ma heh a tua khypaw tah tua he seh,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nyheh sahlo khah aa cung letah a kih pahnia seh la, thlawchangpah ná he seh tatah Zisu khaco aa va chuakhui he. Canghrasala a hningzuitu sahlo takhei aa va chuakhuipaw sahlo khah aa raw he. ");
INSERT INTO zypNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zisu tah, “Nyheh sahlo cawh Kama khatah a vong he seh, pakhang khe o, zecawtamaw tatah vaicung painah raang cawh ma hapaw sahlo aa tei khah a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aa cung letah a kih a pahnia khy taikhei ma hminghmaw taico a seihly. ");
INSERT INTO zypNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cawngsawpaw pakheh cawh Zisu kha a vong ka, “Cawngpahtu, chaizaw hringnah hmuh rua pawtah zehming chawpaw maw ka tua a?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Zisu taco, “Hming chawpaw kong cawh zecawtamaw na pa hae? Khazing suipaw a chawpaw a cang. Hringnah letah a nae na du caco, biapeh sahlo khah nge thlang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Zehapaw khah maw?” tatah cawngsawpaw taco a hae cakhia. Zisu taco, “Lenong kheh, a phei kheh, ru kheh, a hmang lypaw hnikhuitu cang kheh, ");
INSERT INTO zypNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","na no le na paw cizaw la, nama na dopaw hratah na ingpaw va do my lo,” tahpaw a cang tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Satlepaw taco, “Ma vytei heh cawh ka zui thlu thah, zemaw ka bah vy?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zisu taco, “A tlingpaw cang na du caco, va sei la, na hnuipaw sahlo khah va zua la, mehsisah va pei la, vaicung letah chosung na hnui a. Mataico a vong la, va pa zui,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Satlepaw tah ma bia cawh a thui tihtah a ngechia hmo tah a sei hly. Zecawtamaw tatah ama cawh mehrung a cangnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mataico Zisu tah a hningzuitu sahlo cawh, “Biahmuisui ka ca ching he, mehrung caw taco vaicung painah raang letah a nae heh a ru caimang. ");
INSERT INTO zypNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka ca ching vy he, mehrung tei Khazing painah raang letah a nae navy co, ceiphing kho letah sahisy a nae heh a neh vy a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ma bia cawh a hningzuitu sahlo tah aa thui tihtah aa khuarawha ngetei ka, “A cang caco ahomaw pachah a cang khy a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zisu tah aaning sahlo cawh ming he ka, “Ma heh cawngsaw khaco cang khy be, canghrasala Khazing caw taco a cang khy lypaw zehmai ung be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piter tah Zisu cawh, “Kaaning taco zezongpui seisai tah kaa ca zui hi! Mataico kaa cawtah ze rawhchai ruapaw ung maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zisu taco aa hai letah, “Biahmuisui ka ca ching he, zezongpui patha kaw a cang tih tei, Cawngsaw Sawcapaw a rungnawnah dyching letah a ty tih taco, naaning kama a pa zuipaw sahlo cawh abui dyching sanghrawhluihning letah a ty he ceh ka, Israel phinghraw hluihning khah bia naa ce he a. ");
INSERT INTO zypNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Taico kama ka rawng tah a ing maw, a uny sahlo maw, a satei sahlo maw, no le paw maw, a sawtei sahlo maw, a ly maw a seisaipaw sahlo taco a leh zakheh tah aa hmuh kaw hlui tah chaizaw hringnah ry aa cy a. ");
INSERT INTO zypNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Canghrasala hme a sahpaw mehlupui cawh hningkha he ka, hning a khapaw mehlupui cawh hme aa sah tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zecawtamaw tatah vaicung painah raang cawh a misur buichung letah rai a hre ruapaw kuli pakhia rua pawtah mongdi tei a piathlahpaw ly a hnuitupaw khatah a lo. ");
INSERT INTO zypNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aaning sahlo cawh ningkheh tah ngung tangka phae kheh pae pawtah a nawtlah ka, a misur buichung lang cawh a taw he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Monglang suimehlang pakua hrawng lekhei a khia ka, zehmai tua ly tei chodo tlang letah a daw thlangpaw ahringpaw cawngsaw sahlo khah a hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aaning sahlo cawh, ‘Naaning zong va sei la, ka misur buichung letah rai va hre la, a tlahpaw naning tah nihlo ka ca pae he a,’ tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Macawtaco aaning sahlo cawh aa va sei. Ningching hrawng tah a va khia ka zailang suimehlang pathung hrawng lekhei a va khia vy hui ka, ma hraco a va tah vy he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Zailang suimehlang papangaw hrawng lekhei a va khia ka, a daw pahmo thlang thly pawhe ahringpaw cawngsaw sahlo khah a hmuh he. Aaning sahlo cawh, ‘Zehmai tua lytah zecawtamaw ma lehei chahningtlaw na daw thlang he ceh?’ tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Ahohmai rai a ma peipaw ung be ca he ka,’ tatah aa chai. Aa hai leco, ‘Naaning zong va sei la, ka misur buichung letah rai va hre hra o,’ tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Zailang a va phah tihtah misur buichung a hnuitupaw taco buichung a mingkaitu khah, ‘Raihretu sahlo khah y la, aa hre mai cawh pei o, a hning cai tei siapaw sahlo taikhei patho la, a hmasaw teipaw taikhah pei o,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Zailang suimehlang papangaw hrawng letei hlangpaw raihretu sahlo cawh a vong he ka, ngung tangka cawh a lah cy he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A hmasaw tei hlangpaw sahlo cawh aa va chua tihtah a hlu vy kaa hmuh thly a, tatah a rawhchai he. Canghrasala aaning sahlo zong cawh ngung tangka phaekheh aa hmuh cy hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma tih taco ly a hnuitupaw khah aa phingso. ");
INSERT INTO zypNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ahning cai tei hlangpaw cawngsaw sahlo taco suimehlang pakheh suitei hre he ka, chahningtlaw ningling le raisah kha aa catingpaw kaaning sahlo khahei a khingpaw tah na tua he,’ tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Canghrasala aaning letei pakhehpaw cawh, ‘Ka dua, na cung letah hmingchahly ka tuapaw cang be. Ngung tangka phaekheh tah hre rua pawtah na naw a tlah cang bei maw? ");
INSERT INTO zypNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na nihlo khah law la, sei. Nama ka ca pehpaw hratah a hning tei ka hlangpaw cawngsaw zong peh ka du he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ka tangka cung leco ka dudú tah tuanah naw hnui bei neh maw? A cang ly leh ka he a chah cawtah hei na hei a tlia tah?’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma hraco a hning a khapaw cawh a hmesah tae he ka, a hme a sahpaw cawh a hning aa khapaw a cang tae he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Zisu cawh Jerusalem khuapui lang a seichy ning takhei a hningzuitu pahrawhluihning khah a cakih lang seikhui he ka, aa hai letah, ");
INSERT INTO zypNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Jerusalem lang va sei he peh ka, Cawngsaw Sawcapaw heh tlangbui macang sahlo le phungbia cawngpahtu sahlo khatah luithae a cang tae a. Aaning sahlo taco thaw pawtah thaily cangsah a he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","pasipasa a he ka, chei a he ka, khraws letah khaipai ruapaw tah Gental cawngsaw khatah peh pachaw a cang a. Ningthungnah letah hringnah letah patho kaw a cang a!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mataico, Zebedi a sawcapaw sahlo aa no cawh a sawcapaw sahlo khaco Zisu kha a vong he ka, a khuh panai ka ningdo a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zisu taco, “Zemaw na du?” tatah a hae. Canuno taco, “Na painah letah ka sawcapaw leh pahning heh pakheh na cacang lang, pakheh na cavui lang na tysah ky he tah ka du,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Naa haepaw heh hnih bei he ceh. Ka ding lepaw tai-ingnah ny heh naa ding khy a maw?” tatah a tah he. “Kaa ding khy a,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zisu taco aaning cawh, “Ka ny taihei naa ding ceingei a. Canghrasala ka cacang lang le ka cavui lang tah a tynah naw cawh kama ka rei cang be. Ma hming sahlo heh cawh ka Paw tei a pa chia pahpaw sahlo aa cawtah a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ma bia cawh a hningzuitu ahringpaw pahrawpaw tah aa thui tihtah ma tlaw uny pahning cung leco aa thing a ae. ");
INSERT INTO zypNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zisu tah hmingkheh tah y he ka, “Gental cawngsaw sahlo uhtu bui a cangpaw sahlo he taco aa rai leteipaw sahlo cung letah a bui tah a bui so he ka, bui lai sahlo cawh aa cung letah naw aa hnui ngetei tahpaw khah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Naaning cawh ma hraco naa cang ruapaw cang be. Ma navy co naa hrong lehei mehlai cang a dupaw taco naa raihretu tah a tua seh la, ");
INSERT INTO zypNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","a pakhehnah cang a dupaw taco naa sae tah a tuapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cawngsaw Sawcapaw heh a rai hrepá pawtah cang lytah male rai hre rua pawtah le mehlupui tlang ruapaw cawtah a hringnah peh rua pawtah a vongpaw hrahei,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zisu le a hningzuitu sahlo cawh Jeriko khua taitah aa piathlah taikhei cawngsaw rungpui tah aa zui he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mehcopaw pahning cawh langpui kae lekhei a ty thlang he ka, Zisu a va sei lai tahpaw khah aa thui tihtah, “David Pathlah, Abuipaw, ning ma do ky law!” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Cawngsaw rungpui taco a hrangso he ka, “De teitah ung o,” aa tah he. Canghrasala, “David Pathlah, Abuipaw, ning ma do ky law!” tatah a thang vy tah aa y he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zisu cawh a daw ka, a y he. “Naa cawtah ze tuapah maw naa du?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Abuipaw, khua hmuh khy kaa du,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Zisu taco ningdo he ka, aa meh cawh a tongpah he. Ma cangkaw leco, khua cawh hmuh khy he ka, Ama cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalem lang a va nae myca he ka, Oliv tlaang letah a ungpaw Bethfes khua aa phah tihtah Zisu tah a hningzuitu pahning khah seisah hlang he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aa hai letah, “Naa hme khua lekhei va sei la, a sawtei khatah a cangpaw, la aa hrai thlangpaw naa hmuh palang a. A rui khah thlang he ceh ka, naa va hrui lai a. ");
INSERT INTO zypNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pakheh kheh tah zekhatah aa ca tah zong he tah Abuipaw tah a hia naa tah a, taico ama tah a va thlaw palang thlang a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ma heh Khazing khuavang hmang tei reipaw, ");
INSERT INTO zypNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion sawcanu khah ching my lo, ‘Na siangpahrang cawh nama kha a vongpaw khah mingtua, mehningnai cang ka, la a va ci lai, la teitei ceingei khah a cang,’ ” tahpaw bia a tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A hningzuitu sahlo cawh va sei he ka, Zisu tei a chingpaw he hrakhei aa va tua. ");
INSERT INTO zypNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","La puino le la teitei cawh va chuakhui he ka, aa pai sahlo cawh aa kai leco dae he ka, Zisu taco a ke. ");
INSERT INTO zypNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Cawngsaw rungpui takhei aa pai sahlo cawh langpui letah phaw he ka, ma chung taco, ahringpaw cawh chingbu khah va chaw he ka, langpui leco aa phaw. ");
INSERT INTO zypNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mataico, a hmelang a seipaw le a zuilaipaw cawngsaw rungpui taco, “David pathlah cawh Hosana cang ky seh! Abuipaw ming tei a vongpaw cawh bonghnang song tah ung ky seh! A sangcaipaw vaicung lekhei Khazing cawh reithai tah ung ky seh!” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zisu cawh Jerusalem khuapui a nae tihtah khua pungpui co chuh he ka, “Ahomaw a cang?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Cawngsaw rungpui taco, “Galili raang, Nazaret khuapaw, Khazing khuavang Zisu a cang khi,” tatah aa chai he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zisu cawh behnah ingdung chunglang a nae ka, ma letei hming a zuapaw sahlo le a copaw sahlo khah a tingchua thlu he. Tangka a thlaipaw sahlo aa cabuai le lelai a zuapaw sahlo aa dyching sahlo khah a palehly thlu he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aa hai leco, “Capathai letah ma hrahei cia a cang, ‘Ka ing cawh thlawchangnah ing tah a cang a,’ canghrasala naaning taco, ‘Mehru kua,’ tah naa tua,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Taico a mehcopaw le a songbepaw sahlo cawh Zisu khaco behnah ing letah a vong he ka, a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Canghrasala tlangbui macang sahlo le phungbia cawngpahtu sahlo tah a tuapaw khuarawha hming le behnah ingdung chung letei, “David Pathlah cawh Hosana, cang ky seh,” tatah nyheh sahlo tah aa ypaw khah aa hmuh tihtah ceh bingbi bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aaning taco, “Ma nyheh sahlo tei aa reipaw cawh na thui maw?” tatah Zisu cawh aa hae. Zisu taco, “Ka thui thlang. ‘Nyheh sahlo le hasaitei sahlo hmokaw taitah, Nama reithainah khah palang chua pawtah na cawngpah thah he,’ tahpaw khah rei bang bei he ceh maw,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Taico aaning sahlo cawh piasai he ka, Bethani khua lang khah sei ka, ma leco ma zai cawh a va ria. ");
INSERT INTO zypNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mongdi tei khuapui lang tah a va kaw kaw ning takhei a ngai a di ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Langpui kae lekhei thuiku kung hmuh ka, a va seihno. Canghrasala a hnaw tah cy ly co zehmai hmuh be. Mataico thuiku kung cawh, “Zening tahmai thui khaw bei ceh,” tatah a tah. Ma cangkaw leco, thuiku kung cawh a ro. ");
INSERT INTO zypNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A hningzuitu sahlo tah ma cawh aa hmuh tihtah aa ning a ang. “Zecawtamaw ma thuiku kung heh rairang pui tah a ro thlang,” tatah Zisu cawh aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zisu taco, “Biahmuisui ka ca ching he, lung langlo lytah zingnah naa hnui caco, ma thuiku kung letei tuapaw heh naa tua khy long cang lytah ma tlaang hmai heh, ‘Sei la, rili chunglang va tlah thlah,’ tah khy he ceh ka, a hnei ka, a tlah thlang a. ");
INSERT INTO zypNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Naa zing caco, Khazing letah thlawchang tei naa haepaw maikaw khah naa hmuh thlang a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zisu cawh behnah ingdung chunglang a nae ka, a cawngpah chung he takhei tlangbui macang sahlo le macang sahlo cawh Ama kha a vong he. “Ze nawhnuiná tamaw ma hming sahlo heh na tua? Ma nawhnuinah heh ahomaw a ca pei?” tatah Zisu cawh aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Zisu taco, “Bia sangkheh ka ca hae tua hrá he a. Naa pa palei khy caco, ma hming sahlo heh ze hapaw nawhnuiná tamaw ka tua tahpaw ka ca ching he a. ");
INSERT INTO zypNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Johan tah baptisma pehnah naw a hnuipaw khah ze taitah maw a va chua? Khazing taitah maw, cawngsaw taitah maw?” tatah a tah he. Reisia he ka, “ ‘Khazing taitah,’ tah my peh seh la, ‘A cang caco zecawtamaw Johan cawh naa zing be?’ a ma tah a. ");
INSERT INTO zypNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Canghrasala, ‘Cawngsaw taitah,’ tah my peh seh la, mingzawpui cawh kaa ci tlung he, zecawtamaw tatah aaning vytei taco Johan cawh Khazing khuavang a cang aa tah tlung,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Macawtaco Zisu cawh, “Hnih bei peh,” tatah aa chai. Taico, Zisu tah, “Kama zong tah ma hming sahlo heh ze hapaw nawhnuiná tamaw ka tua tahpaw ca ching hrá bei neh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mataico Zisu tah, “Ma heh zekhatamaw naa rawh? Cawngsawpaw pakheh ung ka, sawcapaw pahning a hnui he. A uthuipaw kha a vaw ka, ‘Ka sawtei, atoning cawh misur buichung lang va sei la, rai va hre,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Sei bei neh,’ tatah a chai, canghrasala a hning taco, sei ly co chah be tah ka, a va sei. ");
INSERT INTO zypNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mataico aa paw cawh a sawcapaw pakhehpaw khaco a vaw ka, ma hraco a va tah. A sawcapaw taco, ‘Apaw, ka sei ly camaw,’ tatah tah ka, canghrasala sei be. ");
INSERT INTO zypNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ma pahning lehei he ahomaw a paw a dunah a tuapaw cawh a cang tatah naa rawh?” a tah he. “A pakhehnah,” tatah aa chai. Zisu taco aa hai letah, “Biahmuisui ka ca ching he, ngungkhui kheitu sahlo le hlohlangno sahlo cawh Khazing painah raang letah naa hmelang tah a ca nae khai leimei he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Baptisma peitu Johan cawh dingnah langpui khah hmuh sá pawtah naaning khatah a vong ka, zing bei he ceh, canghrasala ngungkhui kheitu sahlo le hlohlangno sahlo taco aa zing. Taico ma heh naa hmuh khy taihei hmai a ngepachih tah zing hlui bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tawchingnah bia ahringpaw nge vy tua o. Misur buichung a tuapaw ly a hnuipaw pakheh a ung. A buichung cawh ruahy sah khai ka, misur so nápaw kho zong co ka, a haw nápaw siasang zong a do thah. Mataico misur buichung cawh thaikhehpaw ly a tuapaw sahlo khah hlei he ka, khuatlongnah lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hre cai a ne tihtah a sae sahlo khah ama a ting hangpaw pakhong pawtah khei ly a hlangpaw sahlo khaco a taw he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ly a hlangpaw sahlo taco sae sahlo cawh tle he ka, pakheh cawh dai he ka, pakhehpaw cawh aa thaw. A pathungnahpaw cawh alung tah aa cung. ");
INSERT INTO zypNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mataico, ahringpaw sae sahlo khah a hlu vy tah aaning sahlo khaco taw he ka, ly a hlangpaw sahlo taco ma thlythly hraco aa tua hui he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A changnah leco a sawcapaw khah aaning sahlo khaco a va taw. ‘Ka sawcapaw cawh aa cizaw thlang a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Canghrasala, ly a hlangpaw sahlo taco a sawcapaw cawh aa hmuh tihtah pakheh le pakheh cawh, ‘Ma cawngsaw heh ry cytu a cang. A vong o, thé he peh ka, a ry a lah ná he peh seh,’ aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Macawtaco ama cawh tle he ka, misur buichung alailang khah piakhui he ka, aa thaw. ");
INSERT INTO zypNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Macawtaco misur buichung a hnuitupaw a va chua tihtah ma ly a hlangpaw sahlo cawh zekhatamaw a tua he a?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Taico aaning sahlo taco, “Ma mehchawly sahlo cawh cichui pawtah thé he ka, a misur buichung khah hre a zaw tihtah a tinghangpaw a pei khypaw ly a hlangpaw ahringpaw khah a hlei he a,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Zisu taco, “Capathai letah rei bang bei he ceh maw? ‘Ing a sahtu sahlo tei aa hlawhpaw alung cawh a biapui caipaw alung tah a cang. Abuipaw tah ma heh tua ka, kaa mehmuh letah khuarawha a chuipaw a cang,’ tahpaw heh. ");
INSERT INTO zypNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Macawtaco, Khazing painah raang cawh naaning taitah lahly cang ka, a thui a thui sápaw cawngsaw khah peh a cang he a, tah heh ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma alung cung letei a tlahpaw cawngsaw cawh kuichy thlu he ka, ma alung tei a tlahsopaw cawngsaw he cawh a mang cici he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tlangbui macang sahlo le Farasi sahlo tah Zisu a reipaw tawchingnah bia cawh aa thui tihtah kaaning a ma tahnang tahpaw khah aa hni. ");
INSERT INTO zypNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ama tle nápaw langpui khah aa hui, canghrasala zawpuipaw khah aa ci he, zecawtamaw tatah ma cawngsaw sahlo takhei Zisu cawh Khazing khuavang a cang tatah aa tah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zisu tah aaning sahlo cawh tawchingnah bia a ching vy hui he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Vaicung painah raang cawh a sawcapaw nupui chui kongchuanah a tuatupaw abui khatah a lo. ");
INSERT INTO zypNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ama taco a sae sahlo khah taw he ka, kongchuanah letei aa hruipaw sahlo he khah va chuh myca he seh tatah a va tahsah he. Canghrasala va chuh du tlang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Taico a sae sahlo cawh a hlu vy tah taw he ka, ‘Aa caw tei zaibatui kaa pa chia pahpaw he hruipaw sahlo khah va ching o, ka cotungpaw sahlo le ka sahring a thypaw sahlo cawh theh thah he peh ka, zezongpui a tlang a tling thlu myca. Nupui chui kongchuanah lang cawh va chuh myca law, va tah o,’ tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Canghrasala a bia cawh naw tah sah be ca he ka, pakhehpaw cawh a ly lang, pakhehpaw cawh cho palehnah lang a sei hly thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A hringpaw sahlo taco a sae sahlo khah tle he ka, hrai he ka, aa thaw he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A buipaw cawh a thing a ae. A raekeh sahlo khah taw he ka, ma lenongpaw sahlo cawh va thawsah he ka, aa khuapui cawh me tah a va rosah he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mataico a sae sahlo khah, ‘Nupui chui kongchuanah cawh a tlang a tling thlu myca, canghrasala ka hruipaw cawngsaw sahlo heh va chuh tlang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Langpui a tongnah sahlo lekhei va sei la, cawngsaw naa hmuhpaw maikaw he khah kongchuanah leco va hrui o,’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Macawtaco, sae sahlo cawh langpui sahlo lang khah va sei he ka, cawngsaw aa hmuhpaw maikaw he khah mehchaw kha, mehchia khakhei va pahmo he ka, nupuichuinah ing cawh cawngsaw a chih thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Canghrasala, abuipaw cawh a va chuhpaw cawngsaw ming rua pawtah khei a vong tihtah nupuichuinah chaichi a hrei lytah a vongpaw cawngsawpaw khah a va hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Ka dua, zecawtamaw nupuichuinah chaichi a hrei lytah na va chua lalei?’ tatah abuipaw taco a hae. Cawngsawpaw cawh a rei thlaw be. ");
INSERT INTO zypNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mataico abuipaw taco a raitaw sahlo khah, ‘Ma cawngsawpaw heh a kih le a phe tongchai la, alailang amuinah caw le hawrianah hminghmaw a cangpaw lang khah vathlang o.’ ");
INSERT INTO zypNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Zecawtamaw tatah hruipaw cawh a hlu he, canghrasala thingpaw cawh a cawngtei he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mataico Farasi sahlo cawh piathlah he ka, Zisu cawh Ama a bia khei o khy nápawtah khua aa khang. ");
INSERT INTO zypNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Taico, aa hningzuitu sahlo khah Herod a hningzuitu sahlo khakhei Zisu khatah aa va taw he. Aaning sahlo taco Zisu cawh, “Cawngpahtu, nama cawh mehding cang ceh ka, Khazing langpui kong heh biahmuisui a cang naning teitah na cawngpah he tah cawh kaa hni. Cawngsaw tah miamang khypaw cang bei ceh, zecawtamaw tatah cawngsaw hme ming bei ceh, ");
INSERT INTO zypNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Zekhatamaw na rawh? Siangpahrang Sizar letah ngungkhui peh heh ahmang maw hmang ly? Ma ching tua,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Canghrasala Zisu taco, aa rawhnah a chah lypaw khah hnih ka, “Naaning cungmai raipha sahlo, zecawtamaw o na pa pachia he ceh? ");
INSERT INTO zypNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngungkhui tho rua tei naa hmangpaw tangka phaesai cawh pa hmuhsah tua o,” tatah a tah he. Tangka cawh va tle he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","aa hai leco, “Aho a lingthlaw maw a cawng? Taico aho a cakhai maw a cia?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aaning tah, “Sizar,” tatah aa palei. Mataico aa hai letah, “Sizar a tei cawh Sizar pei la, Khazing tei cawh Khazing pei my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma bia cawh aa thui tihtah aa ning a ang thlang. Macawtaco piasai he ka, a seihly he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma ningcai leco thokawnah ung be a tahpaw Sadusi sahlo cawh Zisu khatah a vong he ka, bia aa hae hri. ");
INSERT INTO zypNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Cawngpahtu, Moses tei a ma chingpaw cawh cawngsawpaw cawh sawteisah lytah a thih caco, a unypaw takhei lahmeno cawh nupui tah chui kaw seh la, a thipaw caw takhei sawtei a sah pápaw a cang a ma tah. ");
INSERT INTO zypNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A cang caco kaa hrong letah uny pasarih a ung he. A uthui caipaw tah nupui chui ka, a thi. Sawtei sah be ca ka, a nupui cawh a nyteipaw khah a ry si. ");
INSERT INTO zypNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma thly hraco a pahningnah le a pathungnah taikhei a pasarihnah tai a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A hning cai taco, ma canuno zong cawh a thi hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Macawtaco thokawnah letah ma no cawh aa pasarih hrong letah aho a nupui maw a cang a? Aa zongmingtei tah ma canuno khah aa chui tlung,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Zisu taco, “Naa rawh sua ngetei, Capathai a cang ly leh Khazing hmingtuakhynah naa hni lynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Thokawnah leco a chuihae cawh ung khawh a be. Vaicung letei vaiming hratah aa cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Canghrasala thihnah taitei thokawnah kong letah Khazing tei naaning kha a reipaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kama cawh Abraham Khazing, Isak Khazing le Jakob Khazing ka cang,’ a tahpaw khah rei bang bei he ceh maw? Ama cawh mehthi aa Khazing cang be, canghrasala mehring aa Khazing a cang hri,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cawngsaw zawpui tah ma bia cawh aa thui tihtah a cawngpahnah khah aa ning a ang ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Zisu tah Sadusi sahlo cawh de ky tah a tua he tahpaw khah Farasi sahlo tah aa thui tihtah hmingkheh tah a pahmo he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aa hrong letei phungbia a thai ngeteipaw pakheh tah Zisu pase du takhei ma bia heh a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Cawngpahtu, biapeh hrong lehei zehapaw maw a biapui cai?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zisu taco, “ ‘Abuipaw na Khazing khah na lungthing vytei, na hringnah vytei, na khuarawnah vytei khakhei do my lo,’ tahpaw heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ma heh a sangkhehnah le alaicaipaw biapeh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Taico a sanghningnah cawh ma khahei a lo thlang, ‘Nama na dopaw hratah na ingpaw khah do my lo,’ tahpaw heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Phungbia vytei le Khazing khuavang sahlo aa bia vytei cawh ma biapeh sanghning lehei a pakhung thlu he,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farasi sahlo cawh hmingkheh tah aa pahmo chung he takhei Zisu tah aaning sahlo cawh, ");
INSERT INTO zypNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Khri kong lehei zekhatamaw naa rawh? Aho pathlah maw a cang?” tatah a hae he. Aaning sahlo taco, “David a pathlah,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zisu taco aa hai letah, “Ma hratei a cang caco, David tah Thlawpaw Pathai tah Khri khah, ‘Abuipaw,’ tatah a ypaw khah zekhatamaw a cang a? Zecawtamaw tatah David tah, ");
INSERT INTO zypNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Abuipaw tah ka Buipaw cawh na carae sahlo khah na pherai letah ka chia hlai vytei he cawh ka cacang lang letah a ty my lo, a tah,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David tah Khri cawh, ‘Abuipaw,’ a tah tlung, zekhatamaw David pathlah cawh a cang thai a?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Palehnah bia kaw kheh hmai a rei khypaw ung be ca he ka, ma ning ri taico ahotahmai bia hae ngang khawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mataico Zisu tah zawpuipaw le a hningzuitu sahlo aa hai leco, ");
INSERT INTO zypNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Phungbia cawngpahtu sahlo le Farasi sahlo cawh Moses a naw hnuinah a tlepaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Macawtaco aa bia nge la, aa ca chingpaw he hming maikaw khah tua my lo. Canghrasala aa tuapaw hratah tua khe lo, zecawtamaw tatah aa ca chingpaw he khah aaning tah zui bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hming a rih pawpui khah tongchai he ka, cawngsaw aa saitlang letah aa khing lai he, canghrasala aaning taco, ma hming sahlo hneihnang nápawtah aa kihdong hmai calia du bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hming aa tuapaw maikaw heh cawngsaw hmuh ruapaw tah aa tuapaw a cang. Capathai khungnah bawng a tongpaipaw he khah a kypui tah tua he ka, aa angki pasuapaw letei aa pathlepaw a cong cawh zetlua tamaw a pasua. ");
INSERT INTO zypNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kongchuanah letah a chawpaw hminghmaw khah du he ka, synagog letah achaw caipaw dyching letah a ty aa du. ");
INSERT INTO zypNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chodo tlang letah cizaw hmo tah bia a ching khah du he ka, cawngsaw tah, ‘Cawngpahtu,’ tatah y khah aa du hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Canghrasala naaning sahlo cawh, ‘Cawngpahtu,’ tatah a ysah khe o, zecawtamaw tatah naaning cawh, Cawngpahtu pakheh suitei hnui he ceh ka, naaning vytei cawh uny na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Taico aluicung lehei ahohmai, ‘Apaw,’ tatah va y khe o, zecawtamaw tatah naaning cawh Paw pakheh suitei hnui he ceh ka, Ama cawh vaicung letei a ungpaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","‘Cawngpahtu,’ tatah pakheh hmai a ysah khe o, zecawtamaw tatah cawngpahtu pakheh hnui he ceh ka, Ama cawh Khri khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Naa hrong letei alaicaipaw cawh naa raihretu a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Taico ama le ama a pasangpaw cawh pany cang tae a ka, ama le ama a panypaw cawh pasang a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Cawngsaw hmekaw letah vaicung painah raang cawh naa kha. Naaning zong a nae bei he ceh, a nae dupaw sahlo zong a naesah hrah bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Lahme ing sahlo khah chu lai he ceh ka, ma hmuh ná he seh tatah thlaw a sypui tah naa chang. Macawtaco a sah pui tah dangtah na cang tae he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Cawngsaw pakheh naa behnah lang a paleh sá pawtah tlang le tui tah khua tlawng he ceh ka, a va paleh tih he tah naaning hratah hraihming sawcapaw sahlo tah a lehning tah naa tua he. ");
INSERT INTO zypNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mehco langchuitu sahlo, naa cing a ping! ‘Pakheh kheh tah behnah ing tah chia a sah caco, ma cawh zehmai pui be. Canghrasala pakheh kheh tah behnah ing sui tah chia a sah caco, ama cawh chia a sahpaw hrakhei a zui a,’ naa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Naaning mehco mehruh sahlo! Zehapaw maw a lai vy? Sui maw, sui a pathai sahpaw behnah ing maw? ");
INSERT INTO zypNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","‘Pakheh kheh tah dangnah siasang tah chia a sah caco, ma cawh zehmai pui be, canghrasala pakheh kheh tah a cung letei a ungpaw lahsong khei chia a sah caco, chia a sahpaw hrakhei a zui a,’ tatah naa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Naaning mehco sahlo! Zehapaw maw a lai vy? Lahsong maw, lahsong a pathaisahpaw dangnah siasang maw? ");
INSERT INTO zypNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Macawtaco dangnah siasang tah chia a sahpaw taco dangnah siasang le a cung letei hming a ungpaw maikaw khatah chia a sahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Taico behnah ing tah chia a sahpaw taco behnah ing le a chung letei a ungpaw Khazing khakhei chia a sahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mataico, vaicung tei chia a sahpaw taco Khazing abui dyching le a cung letei a typaw Khazing khei chia a sahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Ringthopaw hanghui, maho, esing sahlo taikhah chyhraw chykheh naa peh. Canghrasala phungbia letei a biapui caipaw dingnah, zawngenah le zingchuipaw cangnah sahlo lekhei dethlang tah naa ung. A hmetaw teipaw heh dethlang lytah a hning teipaw zong heh naa tua ruapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Naaning langchuitu mehco sahlo! Sisaw dingpai sua le peh tatah tui cawh thlih he ceh ka, canghrasala sahisy cawh naa langpai. ");
INSERT INTO zypNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Ny le pakang sahlo cawh alailang tah pathaisah he ceh ka, canghrasala a chunglang cawh dusawnah le ma zawng long rawhnah chitah a chih thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farasi mehco sahlo! Ny le pakang cawh a chunglang pathaisah taw la, mataico alailang zong khah a pathai a. ");
INSERT INTO zypNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Naaning cawh si araangpaw thupaw thlai, a cung lang tah a nge ngetei tlung katei, a chunglang cawh mehthi ru le a pialuipaw hming maikaw tah a chihpaw hratah na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ma hraco a cung lang co mehding ky lo he ceh ka, canghrasala a chunglang co ziatainah le chiahrunah khatah na chih he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Phungbia cawngpahtu sahlo le Farasi sahlo, naaning cungmai raipha sahlo, naa cing a ping! Khazing khuavang sahlo aa cawtah thlailung bing he ceh ka, mehding sahlo aa thlai cawh naa pasang. ");
INSERT INTO zypNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mataico, ‘Kaa mapaw sahlo aa chai lekhei za ung hrah peh seh la, Khazing khuavang sahlo aa thawnahpaw he letah aaning sahlo khaco a pahlawh bei peh,’ tatah naa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Macawtaco Khazing khuavang sahlo a za theh pawhe pathlah sahlo naa cangpaw khah naaning teitah na phy he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Macawtaco naa mapaw sahlo aa pathopaw suanah cawh patlungpatlia thlang ca o! ");
INSERT INTO zypNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Naaning pari sahlo! Naaning pari a pathlah sahlo! Hraihming lang tlah khah zekhatamaw naa cahri thai a? ");
INSERT INTO zypNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Macawtaco Khazing khuavang sahlo le mehsing sahlo le cawngpahtu sahlo khah naaning kha ka va taw he. Aaning letei thaikhehpaw sahlo cawh theh a he ceh ka, khraws letah naa khaipai he a, ahringpaw sahlo cawh naa synagog sahlo letah saving rui tah chei he ceh ka, khua kheh khy khua khé tah naa cadai lai he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ma hraco mehdingpaw Abel thisai taitah behnah ing le dangnah siasang kaa letei naa thawpaw Berekia a sawcapaw Zakaria thisai tai, aluicung letei lai sahpaw mehding aa thisai vytei cawtah sua phosah tah thaily a cangpaw na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Biahmuisui ka ca ching he, ma sahlo vytei heh atochai saw aa cung lehei a tlung a. ");
INSERT INTO zypNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Vy Jerusalem, Jerusalem, Khazing khuavang sahlo khah za theh he ceh ka, Khazing tah naaning khatah a tawpaw he a cawngsaw sahlo khah alung tah na va seh tei he. Aa puino tah a sawtei sahlo a mathlaw rai letah a bakhupaw he hratah, na cawngsaw sahlo cawh ui khazeh uilui maw pakhong du he neh ka, canghrasala du bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mingtua hmai o, naa ing cawh a ching myca. ");
INSERT INTO zypNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka ca ching he, ‘Abuipaw ming tah a vongpaw cawh bonghnang song cang ky seh,’ tatah naa tah hlai vytei cawh pa hmuh kaw khaw bei ceh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zisu cawh behnah ing taitah piathlah ka, a khiakaly lai tihtah a hningzuitu sahlo tah behnah ingpui cawh hmuhsah ruapaw takhei Ama khatah a vong he. ");
INSERT INTO zypNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Zisu taco, “Ma hming vytei heh naa hmuh maw? Biahmuisui ka ca ching he. Ma letei alung phaekheh hmai heh palehly lypaw ung a be, aa zongmingtei tah palehly thlu a cang tae he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zisu cawh Oliv tlaang letah a ty thlang ning takhei a hningzuitu sahlo cawh aaning teitah Ama khaco a vong he ka, “Ma hming sahlo cawh zening tamaw a cang a? Ma ching tua! Na vong nápaw caichangnah paching pakhanah cawh zemaw a cang tae a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zisu taco, “Ahotahmai aa ca dungkhei ly nápaw he tah a raering my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Zecawtamaw tatah ka ming tah cawngsaw hlupui va chua he ka, ‘Kama heh Khri cawh ka cang,’ tah a he ka, cawngsaw hlupui khah aa dungkhei he a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Rae a dypaw he le rae thongpang khah naa thui a, canghrasala a pahly khe lo. Ma hming sahlo cawh a ung hrahringpaw a cang he, canghrasala a changnah cang balang be. ");
INSERT INTO zypNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Raang kheh le raang kheh a dy a he ka, painah le painah a dy he a. Hming hlupui letah cakaang tlung ka, aling a hrui a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma vytei heh canu ny ung risaw hrang a pathonah hratah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mataico, naaning sahlo cawh hreh ruapaw tah male kih letah peh cang he ceh ka, thaw na cang he ceh, taico kama ka rawng tahei mingphing maikaw tah aa ca hua he a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma cai leco ming hlupui cawh aa zingnah taitah a paleh a he ka, a luithe a he ka, pakheh le pakheh a hua he a, ");
INSERT INTO zypNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","taico khuavang pakheipaw hlupui chuh a he ka, cawngsaw hlupui khah aa dungkhei he a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chahlynah a pungchy navai tah cawngsaw hlupui donah cawh a zochuh longmang a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Canghrasala, a changnah tai cyky tah a dawpaw cawngsaw cawh pachah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Taico, mingphing vytei khatah hnikhuitu cang ruapaw tah painah raang thawngchawbia cawh rei cang tae a ka, mataico caichangnah cawh a va chuh a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Khazing khuavang Daniel tah a reipaw, ‘Rorangnah a chua khuipaw pasih padawh chuipaw,’ cawh hming pathai letah a daw thlangpaw khah naa hmuh tihtah a reitu tah a silang hnih he seh. ");
INSERT INTO zypNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judia raang letei a ungpaw cawngsaw sahlo cawh tlaang cung lang sai he seh. ");
INSERT INTO zypNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A ing cung letei a ungpaw cawngsaw cawh hmingbo lá pawtah ing rai lang cung kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ly letei a ungpaw cawh a angkilai lá pawtah ing lang tlung hrah kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ma ningcai cawh sawtei a phopaw canu sahlo le nysai a tlepaw no sahlo aa caw taco zetlua tamaw ningping a chui a! ");
INSERT INTO zypNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Naa sai nápaw cai heh thlasih le Sabat ning tah a cang ly nápawtah thlawchang my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Zecawtamaw tatah Khazing tah khazaw a tua tho ning taitah ato ning tai lehei a ung bang lypaw ningping vaisangnah alaipaw pui tlung tae a ka, ma tluhpaw cawh ung bang khawh a be. ");
INSERT INTO zypNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma cai cawh pachingsah lypaw takhei cang my seh la, a hringpaw pakheh hmai ung a bei he, canghrasala Khazing tei a thingpaw sahlo rawng takhei pachingsah a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ma tih taco pakheh kheh tah, ‘Mingtua, ma lehei Khri a ung,’ a cang ly leh, ‘ma lekhei a ung,’ tatah a ca tah caco he zing khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Zemaw tahpaw co Khri pakheipaw sahlo le khuavang pakheipaw sahlo chuh a he ka, a cang khy caco Khazing thingpaw cawngsaw sahlo hmai dungkhei pawtah arungnawpaw paching pakhanah sahlo le ningang chuipaw hming sahlo khah aa tua a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","A cai a phah hlai tah ka ca ching pacia he. ");
INSERT INTO zypNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Macawtaco pakheh kheh tah, ‘Ma raangcaa lekhei a ung,’ a ca tah caco he va sei khe lo, a cang ly leh ‘Ing chung letah a ung,’ a ca tah caco he va zing khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Zecawtamaw tatah lailaw cawh nichualang taitah nitlah lang tai a kypaw hratah Cawngsaw Sawcapaw a vongkawnah cawh a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sarawh a ungnah hminghmaw leco langtaw pavaw cawh a pahmo tei he. ");
INSERT INTO zypNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ma ningcai sahlo letei ningping vaisangnah a cang khy cangkaw tei leh, ‘Ning cawh muisah cang a ka, thlawpaw zong khai khawh a be. Esi sahlo cawh avai taitah tlah a he ka, avai letei hmingtuakhynah sahlo zong cahneh a cang he a.’ ");
INSERT INTO zypNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ma cai leco, Cawngsaw Sawcapaw a paching pakhanah cawh avai letah a paly a ka, aluicung letei mingphing vytei sahlo cawh a cah tae he a. Hmingtuakhynah le a rungnawpaw laisuinah khatah avai meding cung letah Cawngsaw Sawcapaw a vongpaw khah aa hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mataico, a vaiming sahlo khah hmoka a thangpui tah tung hmotah taw a he ka, aaning sahlo taco thingpaw sahlo khah alui ki pali taitah avai a changnah a rakheh taikhei a rahkheh a changnah tai aa pahmo he a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Thuiku kung tai hei cawngpahnah bia heh a ngia my lo. Achawng ka chawng katei a hnaw pany a ka chuapaw naa hmuh tihtah nipui ning a ne myca tatah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ma hraco ma hming vytei a cang leimeipaw naa hmuh tihtah a vong kaw nápaw cai a ne myca, ingkaw hrang a va phah myca tahpaw khah hnih my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Biahmuisui ka ca ching he, ma hming vytei heh a tlung hlai vytei cawh atochai cawngsaw sahlo heh thi thlu balang a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Alui le avai cawh a rawh a, canghrasala ka bia cawh a rawh by a be. ");
INSERT INTO zypNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","A ning le a cai cawh Paw tah cy ly co ahotahmai hnih bei he, vaicung leteipaw vaiming sahlo tahmai hnih bei he, Sawcapaw zong tah hnih hrah be. ");
INSERT INTO zypNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noah a chaining leteipaw hrakhei Cawngsaw Sawcapaw a vongnah cawh a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Zecawtamaw tatah tuipa-ia a tlung hlai tai khei Noah tuilawng chunglang a naenah tai lekhei cawngsaw cawh e he ka, ding he ka, a chui a hae he ka, a hnui he. ");
INSERT INTO zypNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Taico tuipa-ia tlung katei, aaning vytei a seikhui thlu hlai tai lekhei co zehming maw a tlung a tahpaw zehmai hnih bei he. Cawngsaw Sawcapaw a vongnah ning leco ma hraco a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ly letah a ungpaw cawngsaw pahning chung taikhei pakheh cawh lah cang ka, pakheh cawh seisai a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Canu pahning tah saangsuh leimei a he ka, pakheh cawh lah cang a ka, pakheh cawh seisai a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Macawtaco a raering my lo, zecawtamaw tatah zening tamaw naa Buipaw cawh a vong a takhah hnih bei he ceh kho. ");
INSERT INTO zypNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Canghrasala, ma heh hnih my lo, ing hnuitu tah mehru cawh zai zetih cai letah maw a va chua a takhah hnih thah my seh la, achaw teitah vai a ka, a ing cawh hrawh sá a be. ");
INSERT INTO zypNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Macawtaco a mai pacia tah ung my lo, zecawtamaw tatah Cawngsaw Sawcapaw cawh naa rawh lypaw cai lekhei a vong a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Aho khah maw zing a chuipaw le a singpaw sae, a buipaw tah a ingchungkho sae sahlo khah a cai naning teitah batui peh rua pawtah rai a pehpaw cawh a cang? ");
INSERT INTO zypNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A buipaw a va tlung kaw tihtah a reipaw hratei a tuapaw a hmuhpaw sae cawh meh vaichaw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Biahmuisui ka ca ching he, mapaw cawh a hnuichia vytei a mingkaitu takhei a tua a. ");
INSERT INTO zypNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Canghrasala, ma saecapaw cawh mehchawly cang tah ama le ama khah, ‘Ka buipaw cawh a ry cong thlang a,’ tah seh la, ");
INSERT INTO zypNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a vesaw sae sahlo khah daiphong he seh la, zu a ruipaw sahlo khatah ding le e tah ung thlang seh la, ");
INSERT INTO zypNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ma saecapaw a buipaw cawh a rawh lypaw ning le pacang lypaw cai letah va tlung seh la, ");
INSERT INTO zypNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","a buipaw tah a saecapaw cawh caiping caimang taichung a ka, caw le hawrianah hminghmaw, cungmai raipha sahlo ungnah lekhei a ungsah hrah a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma cai leco vaicung painah raang cawh aa me-ing a tle he katei, nupui a chuipaw satlepaw va dai rua pawtah a seipaw he laisaw pathai pahraw khatah a lo a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aaning chung taico papangawpaw cawh a hruhpaw cang he ka, a tangpaw papangawpaw cawh a singpaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A hruhpaw papangawpaw taco aa me-ing cawh a tle thlang he ka, canghrasala metui cawh a cakai bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Canghrasala a singpaw papangawpaw cawh me-ing a tle he ka, tuithei khei metui a cakai pai he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nupui chui satlepaw cawh va chuh haa ngetei ka, aa zongmingtei co aa mehku ka, a ihning thlu he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Zaicing taco, ‘Nupui chui satlepaw a va chuh myca khi! Dai tei law!’ tatah a ysang he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mataico laisaw pathai pahraw cawh ka tho he ka, aa me-ing cawh aa vang. ");
INSERT INTO zypNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mehruh sahlo taco mehsing sahlo cawh, ‘Na metui ma rai bang tua law, kaa metui a chang thah,’ tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Cang thai be, a ungpaw heh naaning kha, kaaning khaco a ma zaw a be. Metui a zuapaw khatah va sei la, naaning teitah va co hri thlang o,’ tatah aa palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Canghrasala metui caw pawtah aa va sei chung taco nupui chui satlepaw cawh a va chuh. A mai pacia thah tei a ungpaw laisaw pathai sahlo cawh ama khaco nupui chui kongchuanah lang cawh aa va sei. Taico ingkaw cawh aa kha. ");
INSERT INTO zypNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A hning taco, ahringpaw sahlo cawh va chuh he ka, ‘Abuipaw, abuipaw, ingkaw ma hong tua law,’ tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Canghrasala, ‘Biahmuisui ka ca ching he, ca hnih bei neh,’ tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Macawtaco a raering my lo, zecawtamaw tatah ka vong kaw nápaw a ning le suimehlang a cai naa hni ly cawtah hei. ");
INSERT INTO zypNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Taico, vaicung painah raang cawh a sae sahlo y he katei, a hnuicho a chiaso sipaw he khuatlong a thopaw cawngsawpaw khatah a lo vy hui. ");
INSERT INTO zypNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aaning leh tuakhynah aa hnuipaw naning khei pakhehpaw cawh ngung tangka thong pangaw, pakhehpaw cawh ngung tangka thonghning, pakhehpaw cawh ngung tangka thongkheh a peh he. Mataico khuatlongnah lang cawh a sei. ");
INSERT INTO zypNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ngung tangka thong pangaw a lawpaw cawngsawpaw cawh va sei palang ka, a ngung tangka cawh rai va hre naw ka, thong pangaw a miasah. ");
INSERT INTO zypNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma hraco ngung tangka thonghning a lawpaw taco thonghning a miasah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Canghrasala, ngung tangka thongkheh a lawpaw cawngsawpaw cawh va sei ka, alui letah a kho va co ka, a buipaw a ngung tangka cawh a va no. ");
INSERT INTO zypNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Khua sypui khy takhei ma sae sahlo aa buipaw cawh va tlung ka, aa ngung tangka cawh a mingpah he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ngung tangka thong pangaw a lawpaw taco, ahringpaw thong pangaw khah a va tle lai. ‘Abuipaw, ngung tangka thong pangaw na pa chiasosipaw khah mingtua, thong pangaw ka miasah hi,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Abuipaw taco, ‘Na tua thai caimang, mehchaw le zingchuipaw sae! Nama cawh hming a cawng pawtei letah zingchuipaw na cangnah cawtah hming a hlupaw pui a mingkaitu tah ka ca tua a. A vong la, na buipaw a lunglawngnah heh a va hrong hrah,’ tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ngung tangka thonghning a lawpaw cawngsawpaw zong cawh a vong hrah. ‘Abuipaw, ngung tangka thonghning na pa chiasosipaw khah mingtua, thonghning ka miasah hi,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A buipaw taco, ‘Na tua thai caimang, mehchaw le zingchuipaw sae! Nama cawh hming a chiapaw tei letah zingchuipaw na cang cawtah hming a hlupaw pui a mingkaitu tah ka ca tua a. A vong la, na buipaw a lunglawngnah heh a va hrong hrah,’ tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mataico ngung tangka thongkheh a lawpaw cawngsawpaw cawh a vong ka, ‘Abuipaw, nama cawh mehcicia cang ceh ka, thleci na cing lynah hming letah hre lai ceh ka, na vapaw a cang lypaw saze khah na pahmo lai tahpaw ka hni. ");
INSERT INTO zypNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Macawtaco ka thlawzawng ka, va sei neh ka, na tangka khah alui letah ka va no. Mingtua, ma heh na tei cawh a cang hi,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A buipaw taco, ‘Nama mehchawly, sae thawthi! Thleci ka va lynah hming letah ka hrepaw le ka vapaw a cang lypaw saze ka pahmo laipaw cawh na hni tah law? ");
INSERT INTO zypNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ma hratei na hni thlang tlung pawtah ka tangka khah tangkachianah letah za chia la, ka va tlung tihtah a hrang kha a mia kha hmuh a bei neh maw?’ ");
INSERT INTO zypNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Ma cawngsawpaw letei tangka heh law la, tangka thonghraw a hnuipaw cawngsawpaw khah pei o. ");
INSERT INTO zypNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Zecawtamaw tatah a hnuipaw maikaw cawh peh chi vy cang a ka, a hlupui a hnui a. A hnui lypaw cawngsaw cawh a hnuitlakang pawtei hmai khah lah pah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Taico ma chahnainah a hnui lypaw sae heh alailang muinah chunglang caw le hawrianah hminghmaw lang khah vathlang o,’ tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Cawngsaw Sawcapaw cawh a vaiming vytei khatah a rungnawnah khatah a vong tihtah a rungnawnah abui dyching letah a ty a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mingphing vytei cawh a hme letah a pahmo tae he ka, tuukingpaw tah mei le tuu a chaichy pawhe hratah cawngsaw khah pakheh le pakheh khah a pachai he a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tuu sahlo khah a cacang lang letah chiá he ka, mei sahlo khah a cavui lang letah a chia he a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mataico, Siangpahrang tah a cacang lang letei a ungpaw cawngsaw sahlo cawh, ‘A vong tua o, naaning ka Paw tei bonghnang a songpaw sahlo, naa cy ruapaw a cangpaw vaicung painah raang, khazaw papining taitei naa cawtah pachiapaning ciapaw heh a lah tua o. ");
INSERT INTO zypNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Zecawtamaw tatah ka ngaidi ka, e ruapaw naa pa peh, ka tuihrae ka, ding ruapaw naa pa peh, khuachai cang neh ka, naa ing letah naa pa tlungsah, ");
INSERT INTO zypNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","chaichi a phahlah neh ka, chaichi naa pa tuapah, a sah neh ka, naa pa mingkai, thongtlah neh ka, pa vai he ceh ka, naa pa baw,’ a tah he a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mataico, mehding sahlo taco, ‘Abuipaw, zening tamaw na ngaidipaw ca hmuh peh ka, batui kaa ca peh bang, a cang ly leh na tuihrae ka, ding ruapaw kaa ca peh bang? ");
INSERT INTO zypNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Zening tamaw khuachai na cangpaw ca hmuh peh ka, kaa ing letah kaa ca tlungsah bang, a cang ly leh chaichi a phahlah ceh ka, chaichi kaa ca tua pah bang? ");
INSERT INTO zypNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Zening tamaw na sawpaw kaa ca hmuh bang, a cang ly leh thongtlah ceh ka, kaa ca vai bang?’ tatah aa chai a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Siangpahrang taco, ‘Biahmuisui ka ca ching he, ka uny sahlo letei a chia caipaw cung letah naa tuapaw khah kama letah naa tuapaw a cang,’ tatah a palei he a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mataico a cavui lang teipaw sahlo khah, ‘Naaning chiasahpaw sahlo, Setan le a vaiming sahlo cawtah pachia ciapaw chaizaw me chunglang khah seihly o. ");
INSERT INTO zypNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Zecawtamaw tatah ka ngaidi ka, e ruapaw zehmai pa pei bang bei he ceh, ka tuihrae ka, ding ruapaw zehmai pa pei bang bei he ceh, ");
INSERT INTO zypNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","khuachai cang neh ka, naa ing letah pa tlungsah bang bei he ceh, chaichi a phahlah neh ka, chaichi pa va so bang bei he ceh, ka saw hmotah thongtlah neh ka, pa vai tah pa baw bang bei he ceh,’ a tah he a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aaning sahlo taco, ‘Abuipaw zening tamaw na ngaidipaw ca hmuh peh ka, a cang ly leh na tuihraepaw khah ca hmuh peh ka, a cang ly leh khuachai cang ceh ka, a cang ly leh chaichi a phahlah ceh ka, a cang ly leh a sah ceh ka, a cang ly leh thongtlah ceh ka, ca baw lytah kaa ung?’ tatah aa tah a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ama taco, ‘Biahmuisui ka ca ching he. Ma cawngsaw sahlo letei a chia caipaw cung letei naa tua lypaw cawh kama ka cung letah naa tua lypaw a cang,’ tatah a palei he a. ");
INSERT INTO zypNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mataico aaning sahlo cawh chaizaw dangtahnah lang aa sei a. Canghrasala mehding sahlo cawh chaizaw hringnah lang aa sei a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zisu cawh ma bia sahlo vytei heh a reithlu khy taitah a hningzuitu sahlo khah, ");
INSERT INTO zypNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Naa hni thlangpaw hratah Khungsai Panawnah heh ninghning a du ka, Cawngsaw Sawcapaw cawh khraws letah khaipai rua pawtah male kih letah peh a cang tae a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mataico, tlangbui macang sahlo le macang sahlo cawh tlangbui alaicaipaw a ming Kaiafa a cangpaw a ing lekhei a pahmo he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Zisu cawh aparuh teitah tlé tah thaw ruapaw takhei khua aa khang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Canghrasala Khungsaipanaw chung leco cang kheh seh, cawngsaw hrong letah hnahnawhnah maw chuh sua le,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zisu cawh Bethani khuapaw Simon mehthinghmui ing letei a ung chung takhei, ");
INSERT INTO zypNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","canu pakheh a vong ka, lungrang tuithei khei sathy ringthopaw, a mai a ru ngeteipaw khah va tle lai ka, Zisu cawh cabuai letah a ty thlangning takhei a lu taico a za bia. ");
INSERT INTO zypNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A hningzuitu sahlo tah ma cawh aa hmuh tihtah aa thingae ka, “Zecawtamaw ma tluh amai a rupaw sathy heh a patlawh a papang? ");
INSERT INTO zypNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ma ringthopaw heh a mai sangpui tah zua tah tangka cawh mehsisah peh khypaw pui a cang caw,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zisu tah ma cawh hnih ka, “Zecawtamaw ma cawngsawno heh hna naa hnawh? Ka cung letah a tuapaw heh hmingchaw a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mehsisah cawh naaning khatah a ung paria thlang he, canghrasala kama cawh ung paria bei neh. ");
INSERT INTO zypNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma ringthopaw heh ka pung letah a pa bia tih tahei phung ka cang nápaw cawtah a pachia a paningpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Biahmuisui ka ca ching he, khazaw letah thawngchawbia aa reinah maikaw letah ma cawngsawno tei a tuapaw heh ama monghly lynah tah rei a cang tae hrá a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mataico, a hningzuitu hluihning letei pakheh a cangpaw Judas Iskariot aa tahpaw cawh tlangbui macang sahlo khatah va sei ka, ");
INSERT INTO zypNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Zisu cawh naa kih letah ca pei my he neh seh la, zemaw naa pa pae a?” tatah a va hae he. Ngung tangka songthung khah rei he ka, aa peh. ");
INSERT INTO zypNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ma khy taikhei Judas cawh aaning khatah Zisu a peh khy nápaw he cai chaw khah a bo thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Raangri phi lypaw Very Panawnah ning hmetawpaw lekhei a hningzuitu sahlo cawh Zisu khatah a vong he ka, “Zeletamaw Khungsai Panawnah zairia enah cawh na cawtah pachia he peh seh la, na du?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Zisu taco, “Khuapui chung letei cawngsawpaw pakheh khatah va sei la, ‘Cawngpahtu tah ka ning le ka cai a ne myca. Ka hningzuitu sahlo khahei na ing letah Khungsai Panawnah heh ka tua theh be, a tah,’ tatah va ching my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Macawtaco Zisu tei a chingpaw he hrakhei a hningzuitu sahlo cawh va sei he ka, Khungsai Panawnah zairia cawh aa pachia. ");
INSERT INTO zypNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Zailang leco Zisu cawh a hningzuitu pahrawhluihning khaco cabuai letah a ty thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Taico, very aa e chung taco, “Biahmuisui ka ca ching he, naaning taihei pakheh tah naa pa lui a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ma bia cawh aa thui tihtah aa ngechia ngetei ka, pakheh khy pakheh tah, “Abuipaw, kama cang hrahring bei neh, cang maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Zisu taco, “Kama khatei bakang letah a pohruipaw cawngsawpaw tahei a pa lui a. ");
INSERT INTO zypNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cawngsaw Sawcapaw cawh Capathai tah a kong a ciapaw hratah a cung letah a tlung a. Canghrasala Cawngsaw Sawcapaw a luipaw cawngsaw cawh a cing a ping! Za pi lytah ung seh la, a cawtah a chah vy hripaw,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mataico, Ama a luipaw cawngsawpaw Judas taco, “Cawngpahtu, kama cang hrahring bei neh, cang maw?” tatah a tah. Zisu taco, “Aw, nama na cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aa e chung taco Zisu tah very cawh law ka, lawngbia hlai ka, kychy ka, a hningzuitu sahlo cawh pei he ka, “Law la, e my lo, ma heh ka pungsaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mataico ny cawh law ka, lawngbia a hlai khy taikhei a hlai he. “Naa zongmingtei khei ma ny taihei ding tua hmai o. ");
INSERT INTO zypNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ma heh ming hlupui sua ngethai nápaw cawtah a laipaw ka thisai, biahrai thapaw cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka ca ching he, atoning taihei ka Paw a painah raang letah naaning khatah a thapaw ka ding ning tai ma misur hang heh ding khaw bei neh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Reithainah hlaw sungkheh aa sah khy taitah Oliv tlaang lang cawh aa ke. ");
INSERT INTO zypNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Taico Zisu tah aaning sahlo cawh, “Ato zai lalei lehei na pa paisai thlu he ceh, zecawtamaw tatah ma hrahei Capathai letah, ‘Tuukingtu khah chei a neh ka, tuu vytei cawh a paipatlaw thlu he a.’ tatah cia a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Canghrasala ka tho kaw khy taitah naaning naa hmelang tah Galili raang lang ka seihlang a,” tatah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Canghrasala Piter taco, “Nama na kong lehei aa zongmingtei tah a ca paisai thlu hmai he tah kama cawh ca seisai by bei neh,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Zisu tah, “Biahmuisui ka ca ching, ato zai lalei lehei aa a khawng hlai tah uithung tai na pa paphahsai a,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Canghrasala Piter taco, “Nama khatah thih hrápaw a cang zong tah ca paphah sai by a bei neh,” tatah zawpui thui tah a tah. Taico ahringpaw a hningzuitu vytei zong tah ma hraco aa tah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mataico, Zisu cawh a hningzuitu sahlo khatah Gethsemani aa tahpaw hminghmaw lang khah va sei he ka, aa hai letah, “Va sei vy neh ka, thlaw ka chang chung cawh ma lehei a ty thlang my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Piter le Zebedi a sawcapaw pahning khah Ama khatah a chui he ka, lung reithui le vaisang y tah a ung. ");
INSERT INTO zypNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Taico aa hai letah, “Ka hringnah heh thih khui khypaw ngechianah khatah a chih. Ma lehei kama khatah ung thlang la, a raering my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mataico a cawngpe va sei ka, alui letah a bawh ka, “Ka Paw a cang khy pawtei a cang caco, ma tai-ingnah ny heh pa lah pah hly thlang. Canghrasala kama ka dunah hratah cang lytah nama na dunah hratah cang ky seh,” tatah thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mataico, a hningzuitu sahlo khaco a vong ka, aa ihning thlangpaw khah a hmuh. “Suimehlang pakheh hmai kama khatah a raering teitah ung khy bei he ceh maw?” tatah Piter khah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Tuhsonah chunglang naa tlah ly nápawtah a raering la, thlawchang my lo. Thlawpaw taco a du thlang, canghrasala pungsaw tah ceh be,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A uihningnah va sei kaw ka, “Ka Paw, ma tai-ingnah ny heh ka ding ly nápawtah lahly a cang khy ly pawtei a cang caco, na dunahpaw hratah cang ky seh,” tatah thlaw cawh a va chang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A va kaw kaw tihtah aa ihning thlangpaw khah a hmuh, zecawtamaw tatah aa meh ku tu ka, ceh bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Macawtaco seisai he ka, va sei vy ka, thlaw a chang teipaw hraco a uithungnah a va chang vy. ");
INSERT INTO zypNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mataico, a hningzuitu sahlo khaco a vong kaw ka, aa hai letah, “Ato tingtai heh maw a ih he ceh ka, na hia thlang he ceh? Mingtua o, Cawngsaw Sawcapaw cawh mehsua sahlo kih letah hlai nápaw cai a ne myca hi. ");
INSERT INTO zypNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tho la sei he peh! A pa ruiphiapaw sahlo a va chuh myca he khi!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bia a rei leimei chung taco ahningzuitu hluihning letei pakheh a cangpaw Judas a va chuh. Ama khatah tlangbui macang le macang sahlo tei aa tawpaw he tungby le zyzi a tlepaw cawngsaw rungpui a va chui he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A luitupaw taco aaning cawh, “Ka hnangpaw khah Ama cawh a cang a, tle my lo,” tatah paching pakhanah a peh pacia thah he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zisu khaco a vaw palang ka, Judas tah, “Cawngpahtu,” tatah y ka, a hnang. ");
INSERT INTO zypNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Zisu taco, “Ka dua, na vonghno changpaw cawh tua thlang,” tatah a palei. Mataico cawngsaw sahlo cawh va cakang he ka, Zisu cawh aa tle. ");
INSERT INTO zypNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Zisu khatah ma letei a ungpaw pakhehpaw taco a zyzi cawh pazah ka, a phe ka, tlangbui alaicaipaw a saecapaw a naw khah tuh ka, a pathai thlah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zisu taco, “Na zyzi khah a kong lang tei kaw, zecawtamaw tatah zyzi a lahpaw vytei cawh zyzi tah aa thih a. ");
INSERT INTO zypNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka Paw y neh seh la, sungkheh tah a vaiming raekeh phuhraw hluihning a za pa thlawpah khy thlang he tahpaw hnih bei ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Canghrasala, ma hraco cang tua my seh la, zekhatamaw ma hrahei a cang a tatei aa reipaw Capathai bia cawh a tling khy thai a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ma cai leco Zisu tah ming zawpui hai leco, “Rae a thopaw sahlo hotu ka cangnah caw tamaw tle rua pawtah zyzi le thingtai tah naa pa seihno? Ning tating tah behnah ingdung chung letah a ty neh ka, ka cawngpah he, pa tle tlung bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Canghrasala, Khazing khuavang sahlo ciasipaw a tling nápaw cawtah ma hming sahlo heh a va ungpaw a cang hi,” tatah a tah he. Mataico a hningzuitu vytei taco hningchai he ka, aa saisai thlu. ");
INSERT INTO zypNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zisu a tlepaw cawngsaw sahlo takhei, phungbia cawngpahtu sahlo le macang sahlo a pahmonah pawhe tlangbui alaicaipaw Kaiafa a ungnah lang khah aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Canghrasala Piter tah langhlaw pui khei tlangbui alaicaipaw a ingdung taikhah a zuilai. Zekhatamaw hming a chuacang a, tahpaw hni du takhei a chunglang a nae thlah ka, raevai sahlo khakhei a va ty. ");
INSERT INTO zypNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tlangbui macang sahlo le Sanhedrin khongsil vytei taco Zisu thaw khy nápawtah khei bia hnihtu pakheipaw sahlo khah aa hui he. ");
INSERT INTO zypNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Canghrasala zehmai hmuh bei he. Hnikhuitu pakheipaw hlupui aa va chua thlang naná teitah zehmai hmuh hlui bei he. Ahning cai letah cawngsaw pahning a hmelang va chuh he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ma cawngsawpaw tahei, ‘Ma Khazing behnah ing heh chehthlah a neh ka, ningthung tah ka sah khy kaw thlu a,’ a tah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mataico, tlangbui alaicaipaw cawh a ka daw ka Zisu cawh, “Aa bia heh palei bei he ceh maw? Ma cawngsaw sahlo tei sua aa ca pupaw heh zemaw a cang?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Canghrasala Zisu cawh de teitah a ung thlang. Tlangbui alaicaipaw taco, “Khazing hring ming tah ka ca hae. Khazing Sawcapaw Khri cawh na cang maw, ma ching tua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zisu taco, “Aw, na reipaw hraco a cang. Canghrasala naa zongmingtei hai letah ka rei, hmelang leco Cawngsaw Sawcapaw heh Cungnungcai Khazing cacang lang letah a typaw le avai meding cung letah a vongpaw khah naa hmuh a,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mataico, tlangbui alaicaipaw cawh a chaichi khah hriachy ka, “Khazing pui a reipachia myca he! Hnikhuitu hringpaw kaa hia khawh chang maw? Khazing a reipachianah cawh ato khah naa thui thlang myca kho. ");
INSERT INTO zypNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Zekhatamaw naa rawh?” tatah a tah. “Ama cawh thih tlang a tlahpaw a cang,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mataico, aa ci tah a hme letah chawh he ka, aa kia tah aa cabai. Ahringpaw sahlo takhei cabai he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Khri, ma ching tua, ahomaw a ca cabai?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piter cawh ingdung chung lekhei a ty thlang ka, saecanu pakheh cawh Ama lang khah a vong. Canuno taco, “Nama zong heh Galili Zisu khatei a ung teipaw na cang hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Canghrasala aa zongmingtei hme leco a paphah, “Zemaw na rei tahpaw hnih bei neh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mataico, hawkaw lai lang piathlah ka, ma leco ahringpaw canuno takhei hmuh ka, ma leteipaw cawngsaw sahlo hai leco, “Ma cawngsawpaw heh Nazaret Zisu khatah a ung teipaw a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","“Ma cawngsawpaw cawh hnih bei neh!” tatah chia a sá tah a paphah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma khy taico, a cawngpe lekhei a kae letei a dawpaw cawngsaw sahlo cawh Piter khaco va sei he ka, “Nama heh aa hrong leteipaw na cang hrahring, zemaw tahpaw co na reikaw tah a bi thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mataico Piter tah, “Ma paw cawh hnih hrahring bei neh!” tatah chia a sah ka, bia a kaang. Ma cangkaw leco, aa cawh a khawng. ");
INSERT INTO zypNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Taico Piter cawh Zisu tei a hai letei bia a reipaw, “Aa a khawng hlai tah uithung na pa paphahsai a,” a tahpaw bia khah a ka thui kaw. Taico alailang piahly ka, o tlili tah a cah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mataico mongdi taco tlangbui macang vytei le macang sahlo cawh a tong he ka, Zisu thaw pawtah bia aa pathluh. ");
INSERT INTO zypNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Zisu cawh tongchai he ka, rang uhbui Pilat khatah aa hlai. ");
INSERT INTO zypNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma hratei Zisu aa tuapaw khah a luitupaw Judas takhei a hmuh tihtah a ngepachih caimang tei ka, ngung tangka songthung khah law ka, tlangbui macang sahlo le macang sahlo cawh a pakaw kaw he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Suanah a hnui lypaw cawngsaw ka luinah cawtah hei ka sua tu thlang,” tatah a tah. “Kaa cawtah zemaw a pui? Ma cawh nama na rai a cang,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Macawtaco, Judas tah ngung tangka cawh behnah ing leco vathlang si ka, a sei. Mataico seihly ka, ama teitah thingrui tah a pathleseh. ");
INSERT INTO zypNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tlangbui macang sahlo taco ngung tangka cawh law he ka, “Ma heh tangkabawng letah sang ruapaw taco a phung cang be, lenong mai tah pehpaw tangka cang tlung ka,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Macawtaco, ma tangka cawh raang hringpaw cawngsaw sahlo phung nápawtah bei a tuatupaw alyraang cawhnah tah hmang pawtah bia aa chaw. ");
INSERT INTO zypNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ma rawng taco ma lyraang cawh atoning tai thisai lyraang tatah aa ynahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mataico Khazing khuavang Jeremai tah a reipaw, “Israel cawngsaw sahlo tah ama amai aa thliapaw ngung tangka songthung khah law he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Abuipaw tah naw a pa pehpaw hratah bei tuatupaw alyraang cawhnah lekhei aa hmang,” tahpaw tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Zisu cawh raang uhbui Pilat hme letah a daw thlangning taco, raang uhbui tah, “Juda cawngsaw aa siangpahrang cawh na cang maw?” tatah a hae. “A cang, na reipaw hraco a cang,” tatah Zisu taco a palei. ");
INSERT INTO zypNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tlangbui macang sahlo le macang sahlo tah sua aa pu tihtah zehmai chai bei he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mataico Pilat taco a hai letah, “Sua aa ca punah bia aa reipaw cawh thui bei ceh maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Canghrasala Zisu tah kawkheh hmai a palei lypaw khah raang uhbui cawh a ning a ang ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Khungsai Panawnah lehei mingzawpui tei chuasah aa dupaw thongtlah pakheh cawh raang uhbui tah a thlawpah tei he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma cai leco Baraba aa tahpaw chahlynah lang tei a ming a thang ngeteipaw thongtlahpaw pakheh a ung. ");
INSERT INTO zypNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Macawtaco mingzawpui a pahmoning he takhei Pilat tah, “Baraba le Khri aa tahpaw Zisu lehei aho heh maw ma thlawpah seh tah naa du?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hnachuanah rawng tah tlangbui macang sahlo taco Zisu cawh ama khatah aa va chuakhui tahpaw khah a hni thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilat cawh biacenah dyching letah a ty thlangning takhei, a nupuino tah, “Ma suanah a hnui lypaw cawngsawpaw khah zekhatahmai tua kheh lo. Zecawtamaw tatah ato zamong ka mang letah ama a rawng tah ka taithui ngetei,” tatah bia a caw si. ");
INSERT INTO zypNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Canghrasala tlangbui macang sahlo le macang sahlo takhei zawpuipaw khah Baraba khah thlaw la, Zisu khah theh law naa tah a, tatah aa pasy he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Raang uhbui taco, “Ma tlaw pahning lehei aho heh maw thlaw seh tah naa pa du?” tatah a hae he. “Baraba,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat taco, “Khri aa tahpaw Zisu cawh zekhatamaw ka tua a?” tatah a hae he. “Khraws letah khaipai!” tatah aa zongmingtei co aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat taco, “Zerawng tamaw? Ze hmingsua maw a tua?” tatah a hae he. Canghrasala, “Khraws letah khaipai thlang ky,” tatah a thang vy tah a y tima he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat taco cang thai khaw be, hnahnawhnah laky a chuh sua a takhah a hmuh tihtah tui khah law ka, zawpui hme leco a kih cawh a si. “Kama cawh ma cawngsawpaw a thisai lehei suanah hnui bei neh. Ma heh naaning naa tuapaw naa muaphonah a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cawngsaw vytei taco, “A thisai taco kaaning kaa cung le kaa saw kaa ny cung letah ma zui thlang ky seh!” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mataico Pilat tah Baraba khah a thlawpah he. Canghrasala Zisu cawh cheisah he ka, khraws letah khaipai pawtah aa kih leco a hlai he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mataico, raang uhbui a raekeh sahlo taco Zisu cawh raang uhbui ing lang seikhui he ka, ma letei raekeh sahlo takhei a pahmoso he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A chaichi khah pahlu pah he ka, angki a pasuapaw a saidungpaw a hreisah he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mataico, abui lukhu cawtah ahling tah phiapaw lukhu a khusah he. A cacang lang kih lekhei basung a tlesah he ka, a hme letah aa khuh panai he ka, pasipasa he ka, “Juda cawngsaw aa Siangpahrang cawh khua sy hring ky seh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aa ci tah chawh he ka, sungbasih khah law he ka, a lu letah ato le ato tah aa tuh. ");
INSERT INTO zypNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aa pasipasa khy taitah pai a pasuapaw a saidungpaw cawh pahluhly pah he ka, Ama a chaichi khah a hreisah kaw he. Taico khraws letah khaipai pawtah aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aa seipai khei langpui letah Sairin khuapaw Simon aa tahpaw cawngsawpaw a tong he ka, khraws khah hringhrang tah aa puhsah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Galgotha, (A silang cawh, “Luru hming,” tahnah a cang,) aa tahpaw hminghmaw aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ma leco Zisu cawh si kha pahlawhpaw misur zu khah ding ruapaw tah aa peh, canghrasala pateh ka, ding du be. ");
INSERT INTO zypNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aa khaipai khy taikhei a chaichi cawh basung phe he ka, a chaichy he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Taico a ty he ka, ma taco aa cong thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A lu cung letah sua a phosahnah ca aa ciapaw cawh, “MA HEH ZISU, JUDA CAWNGSAW SAHLO AA SIANGPAHRANG A CANG,” tah heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ama khaco damia pahning a cacang lang letah pakheh, a cavui lang letah pakheh aa khaipai hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A seithipaw sahlo takhei aa lu cathingso he ka, naisui hmo khei, ");
INSERT INTO zypNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Behnah ing chehthlah tei ningthung letah a sah kaw thlu khypaw, nama le nama a pachah tua! Khazing Sawcapaw na cang caco, khraws taikhei za cung thlah tua ca!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma hraco tlangbui macang sahlo le phungbia cawngpahtu sahlo le macang sahlo takhei pasipasa hrah he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Cawngsaw ahringpaw cawh pachah he ka, canghrasala ama le ama cawh a pachah khy be! Israel Siangpahrang a cang caw! Kaa zing khy nápawtah khraws taikhei cungthlah tua! ");
INSERT INTO zypNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ama cawh Khazing a zingpaw pui a cang caw! Khazing tah a du caco atoheh pachah tua seh! Zecawtamaw tatah, ‘Khazing Sawcapaw ka cang,’ tatah a tah kha!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma hraco Ama khatei aa khaipaipaw he damia sahlo zong taco naisuinah bia a hlupui khei aa tah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ningching taitah zailang suimehlang pathung tai raang pungpaluh letah muinah a tlung. ");
INSERT INTO zypNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Zailang suimehlang pathung hrawnghrang leco Zisu cawh, “ Eloi, Eloi, lama sabathani?” tatah a thangpui tah a y. A silang cawh, “Ka Khazing, ka Khazing, zemaw na pa seisai?” tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma letei a daw thlangpaw mehthaikheh tah ma cawh aa thui tihtah, “Elija a y leimei!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma cangkaw leco, aa hrong letei pakhehpaw cawh va sai ka, span khah a va lah. Ma cawh misur zu a thobahlapaw letah nong ka, rahtlong letah patai ka, Zisu cawh ding pawtah a hlai. ");
INSERT INTO zypNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A tangpaw sahlo taco, “Ama teitah ung cong tua seh. Ama lahthlá pawtah Elija cawh a vong maw vong ly, ming tua he peh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Taico Zisu cawh a thangpui tah ysang vy hui ka, a hu a ceh chung. ");
INSERT INTO zypNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma sungkheh kaa leco behnah ing letei pai aa pazypaw cawh a cung taitah a rai tai pehning tah a pakaichy. Aling a hrui ka, alung puino sahlo a kuichy he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Athlai sahlo a hong he ka, mehpathai a thipaw a hlupui cawh hringnah letah patho kaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Athlai taico ka pia he ka, Zisu a tho kaw khy taitah Jerusalem khuapui pathai lang va sei he ka, cawngsaw hlupui khakhei a va paly he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Raekeh zakheh buipaw le Ama khatei a ungpaw Zisu a congpaw sahlo tah aling a hruipaw le hming a chuacangnah vytei khah aa hmuh tihtah aa thlawzawng ka, “Ma cawngsawpaw heh Khazing Sawcapaw a cang hrahring thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma letei a ungpaw canu a hlupui taco langpa tah aa cai thlang. Aaning sahlo cawh a byhia tuapah ruapaw tei Galili taitah a va zuipaw sahlo khah a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aa hrong leco Mari Makdalin, Jeims le Josef aa no Mari le Zebedi a sawcapaw leh le aa no tahpaw a ung he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mataico, zailang rangsang lekhei Arimathea khuapaw Josef aa tahpaw mehrungpaw, Zisu a hning a zui hrahpaw khah a vong. ");
INSERT INTO zypNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilat khaco a vaw ka, Zisu rawh khah va hae ka, Pilat taco raekeh sahlo khah Zisu rawh cawh pei law tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef taco Zisu rawh cawh law ka, paithladih anaipaw a pathaipaw khei pahlong ka, ");
INSERT INTO zypNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ama tei alung kho a ruipaw athlai thapaw lekhei a i sah. Thlaikaw leco alung alaipaw pui khah kha si ka, a seisai. ");
INSERT INTO zypNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Makdalin le ahringpaw Mari sahlo cawh athlai hmelang khei a ty thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ring ning a ningthlamongpaw leco tlangbui macang sahlo le Farasi sahlo cawh Pilat khatah a vaw he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Abuipaw, ma dungkhei a hmangpaw takhei a hring thlangning tah, ‘Ningthung khy tah ka tho kaw a,’ a tahpaw kaa thui. ");
INSERT INTO zypNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Macawtaco, ningthung tai cawh thlai khah achaw teitah vai law, tatah ta la, a cha a. Ma hratei a cang ly caco a hningzuitu sahlo a vong he ka, a rawh khah ru he ka, cawngsaw sahlo khah Zisu cawh thihnah taitah a tho kaw thah tatah aa tah sua he a. A changnah letei dungkheinah heh a hmetaw teipaw navy tah a paru vy sua a,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat taco, “Avaipaw phu khaco va sei o. Thlai cawh naa tuakhynah chung tah a bing khy nápawtah va tua o,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Macawtaco va sei he ka, thlai a bing khy nápawtah alung cung leco a ngianah cawh tua he ka, avaitu sahlo cawh aa chia he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat ning khy taitah zaa kheh letei ning hmetaw caipaw mong khua dui lekhei Mari Makdalin le ahringpaw Mari cawh thlai vai ruapaw takhei a sei he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aling a rupui tah a hrui ka, Abuipaw a vaiming cawh avai taitah a za cung. Taico thlai lang cawh a vaw ka, alung cawh hneihly ka, a cung leco a ty thlang. ");
INSERT INTO zypNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A hmuisang cawh lailaw lo ka, a chaichi cawh huihaw hratah a raang. ");
INSERT INTO zypNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Raevai sahlo cawh aa thlawzawng tu thah ka, a cathing he ka, mehthi hratah aa cang thlu he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vaiming taco canu sahlo cawh, “Naa thlawzawng kheh seh, khraws letei aa khaipaipaw Zisu khah naa hui tahpaw ka hni. ");
INSERT INTO zypNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ama cawh ma lehei ung khawh be, a ca chingsipaw he hrakhei a tho kaw thah. A vong la, aa i sahnahpaw heh va ming hmai o. ");
INSERT INTO zypNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mataico rairang tah sei la, a hningzuitu sahlo khah va ching o, ‘Thihnah taitah tho kaw thah ka, naa hmelang khei Galili raang lang a sei thah. Ma leco naa va hmuh a.’ Atoheh ka ca ching thah he hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Macawtaco canu sahlo cawh thlai taico a piathlah pahraw he. Ci hmotah le thawchah ngetei hmotah a hningzuitu sahlo ching rua pawtah khei a sai he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sungkheh kheh tah Zisu taco a tong he ka, “A dang pawtah,” a tah he. Ama khaco a vong he ka, a phe cawh tle he ka, Ama cawh aa beh. ");
INSERT INTO zypNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mataico Zisu tah aa hai leco, “Naa thlawzawng kheh seh. Va sei la, ka uny sahlo khah Galili raang lang za sei he seh tatah va ching o. Ma leco aa pa hmuh a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Canu sahlo aa seilai leimei chung taco athlai raevai thaikhehpaw sahlo cawh khuapui chunglang va sei he ka, tlangbui macang sahlo khah hming a chuacangnah vytei khah thong aa va thuisah he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tlangbui macang sahlo cawh macang sahlo khatah a tongsia tih he tah khuakhangnah sangkheh aa hnui. Raekeh sahlo khah tangka hlupui pei he ka, ");
INSERT INTO zypNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ ‘A hningzuitu sahlo tah zai tah a vong he ka, kaa ihning kaa letah a rawh cawh law he ka aa seikhui,’ tah my lo. ");
INSERT INTO zypNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma thong thuisahnah heh raang uhbui tah a thui caco, kaaning tah a chah ná tah tua a he peh ka, naaning cawh zehmai hanah ing bei ceh kaa ta he a,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Macawtaco, raekeh sahlo taco tangka cawh law he ka, aa chingpaw he hrakhei aa tua. Taico ma bia heh atoning tai heh Juda cawngsaw sahlo hrong letah aa kaipaza. ");
INSERT INTO zypNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mataico, a hningzuitu hluikheh sahlo cawh Zisu tah na sei he ceh tatah a chingsipaw he tlanglang sei rua pawtah khei Galili raang lang cawh a sei he. ");
INSERT INTO zypNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Zisu cawh aa hmuh tihtah aa beh. Canghrasala thaikhehpaw cawh aa lung a langlo. ");
INSERT INTO zypNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mataico Zisu cawh aaning khaco a vong ka, aa hai letah, “Alui le vaicung letei nawhnuinah vytei cawh peh ka cang thah myca. ");
INSERT INTO zypNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Macawtaco va sei la, mingphing vytei khah ka hningzuitu tah va tua my lo. Paw le Sawcapaw le Thlawpaw Pathai ming tah baptisma a va cang sá la, ");
INSERT INTO zypNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","bia ka ca pehpaw he maikaw aa zui nápawtah va cawngpah my lo. Taico caichangnah tai naaning khatah ka ung paria thlang hi,” tatah a tah he.");
INSERT INTO zypNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Khazing Sawcapaw Zisu Khri a kong thawngchawbia ahrangthonah cawh ma heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Khazing khuavang Isaiah cabu letei ciapaw cawh, “Ka tlang ypaw cawh na hmelang ka taw a, taico Ama taco na langpui a parai a. ");
INSERT INTO zypNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Raangcaa letei a y leimeipaw o taco, ‘Abuipaw cawtah langpui cawh parai la, a cawtah langpui cawh pading pah my lo,’ a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Taico Johan cawh va chuh ka, sua ngethainah cawtah angepachihnah baptisma kong phungrei ka, raangcaa lekhei baptisma a cangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Taico Judia raang letei vytei le, Jerusalem khuapui letei ming vytei cawh piathlah he ka, Ama khatah sei he ka, aa suanah phy he ka, Jordan tuivaw letah baptisma a cangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johan cawh sahisy hming tah tawpaw caise a tua ka, saving tesong a te letah a song ka, khybawh le akhui tui a e. ");
INSERT INTO zypNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Taico Johan taco, “Ka hninglang tah kama navy tah a rungnaw vypaw a va sei a. Kama cawh a bung tah a phepakong rui a thlang tlangpaw hmai cang bei neh. ");
INSERT INTO zypNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kama taco tui tah baptisma ca cangsá he neh ka, canghrasala, Ama duitei taco Thlawpaw Pathai tah baptisma a ca cangsá he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma ningcai leco Zisu cawh Galili raang, Nazaret khua taitah va sei ka, Jordan tuivaw letah Johan tah baptisma a cangsah. ");
INSERT INTO zypNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tui taitah a ka pia cangkawleh avai a hong ka, Thlawpaw cawh za cung ka, thury hratah a cung letah a cawngpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Taico, avai taitah, “Nama cawh ka dopaw ka Sawcapaw na cang. Na cung letah ka lung a lawng ngetei,” tatah o a za ring. ");
INSERT INTO zypNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma khy cangkawleh leco, Thlawpaw tah Ama cawh raangcaapaw lang seisah ka, ");
INSERT INTO zypNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ma raangcaapaw leco ning songli chung ung ka, Setan tah a tuhso. Ama cawh saraang sahlo khatah ung ka, vaiming sahlo tah aa mingkai. ");
INSERT INTO zypNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Johan thong a tlah khy taikhei, Zisu cawh Galili raang lang sei ka, Khazing thawngchawbia cawh a y khui. ");
INSERT INTO zypNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Cai le ning a tling myca, Khazing painah raang cawh a ne myca ka, a ngepachih la, thawngchawbia heh zing myca law,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Zisu cawh Galili rili ngaekang letah a cahrong ning takhei, ngawtletu a cangpaw he Simon le a unypaw Andru cawh aso aa va leimeipaw khah a hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zisu tah aaning cawh, “A vong la, pa zui o, cawngsaw a tletu tah ka ca tua he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma cangkaw leco aa so sahlo cawh seisai he ka, Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A cawngpe va sei he ka, aa so sahlo khah a thei leimeipaw he Zebedi sawcapaw Jeims le a unypaw Johan khah tuilawng chung letah a hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A hmuh cangkaw he leh aaning cawh y he ka, aa paw Zebedi cawh a hlofapaw sahlo khakhei tuilawng letah seisai he ka, Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Zisu le a hningzuitu sahlo cawh Kapernaum khua lang sei he ka, Sabat ning a va phah tihtah Zisu cawh synagog lang a nae ka, a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A cawngpahnah cawh aa ning a ang ngetei, zecawtamaw tatah phungbia cawngpahtu sahlo hratah cang lytah nawhnuitu hratah a cawngpah caw he tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma cai leco, synagog leco thlawpaw pialuipaw tei a tlepaw cawngsaw pakheh ung ka, ");
INSERT INTO zypNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nazaret Zisu, kaaning khahei zemaw na du, kaaning hlyde ruapaw tamaw na vong? Nama cawh ahomaw na cang tahpaw ka hni. Khazing Mehpathai na cang,” tatah a y. ");
INSERT INTO zypNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zisu tah, “De teitah ung! A chung taikhei ka pia!,” tatah a hrangso. ");
INSERT INTO zypNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Thlawpaw pialuipaw tah ma cawngsawpaw cawh a sah pui tah cathing ka, a ysang hmotah a piathlah. ");
INSERT INTO zypNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Cawngsaw vytei cawh aa ningang ngetei ka, “Ma heh zemaw a cang? Nawhnuinah chitah a cangpaw cawngpahnah a thapaw heh! Thlawpaw pialuipaw zong naw pei he ka, a bia aa nge thlang!” tatah pakheh le pakheh aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Galili raang chung a kawkih letah Zisu kong thongpang cawh a thang thlu palang. ");
INSERT INTO zypNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Synagog taitah aa piathlah cangkaw tei leh Jeims le Johan khatah Simon le Andru aa ing lang aa sei. ");
INSERT INTO zypNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon a nupuino a no cawh asaw tah nang ka, lakhing letah a ih thlang ka, a konglang cawh Zisu khah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Macawtaco ama khakhei a vaw ka, a kih khah tle ka, a patho. Taico, a sawnah taco thlaw ka, aaning sahlo cawh a tangtui he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Zailang ning a tlah khy taico a sahpaw vytei le khachia tei a tlepaw sahlo cawh Ama khatah aa va chua khui he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Khua pungpaluh co ingkaw letah a pahmo he ka, ");
INSERT INTO zypNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","taico Zisu tah asawnah a phingphing a hnuipaw mehlupui cawh a dangsah he. Khachia a hlupui zong papia he ka, canghrasala khachia sahlo taco Ama khah ahomaw a cang tahpaw aa hni cawtah khei aa reithlawpaw khah sai bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mongdi khua hme a se hlai letah Zisu cawh tho ka, a kingdangnah lang sei ka, ma leco thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon le a vesaw sahlo taco, Ama cawh hui pawtah sei he ka, ");
INSERT INTO zypNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ama cawh aa va hmuh tihtah, “Cawngsaw maikaw tah aa ca huilai leimei kho,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zisu taco aaning cawh, “Ma kaekang lehei a ungpaw khua hringpaw sahlo letah zong phung ka rei khy nápawtah ma lang cawh sei he peh. Ma rawng taco ka vongpaw a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mataico Galili raang chung vytei cahrong ka, synagog sahlo letah phungrei lai ka, khachia zong a papia lai he. ");
INSERT INTO zypNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Zisu khatah thinghmuihri a ingpaw cawngsaw pakheh cawh a vong ka, a khuh panai ka, “Na du caco na pa dangsah khy se,” tatah ningdo a hae. ");
INSERT INTO zypNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Zisu tah ma cawngsawpaw cawh lung a saw ngetei ka, a kia tah pazah ka, va tong ka, “Nama na dang cawh du neh ka, dang myca,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sung sungkheh tah a thinghmuihri vytei cawh ly ka, a dang. ");
INSERT INTO zypNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Zisu tah a sah pui tah raering pei ka, a seisah tlamang. ");
INSERT INTO zypNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Zisu tah, “Ahohmai ching khe lo, ma duitei cawh tlangbui a va mingsah la, na dang my ca cawtah khei Moses phungbia hrakhei thuihlainah va tua la, ma pawsui co dangsah na cangpaw khah ming maikaw tah aa ca hni a,” tatah bia a patai. ");
INSERT INTO zypNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Canghrasala, ma cawngsaw cawh sei ka, ma thongpang cawh reilai ka, a kaipazasah thlu. Macawtaco a seinah maikaw letah ma kong cawh reilai ka, a kaipazasah cawtah Zisu cawh langhai tah khuachung lang a nae khawh lytah a kingdangnah lekhei a ung hri. Canghrasala, kawting taiteipaw mehlupui khah Ama khatah a vong thly thly he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma khy ning a cawngpe letaco, Zisu cawh Kapernaum khua lang a nae kaw tihtah zawpui takhei ing lang a va tlung kaw tahpaw khah aa thui. ");
INSERT INTO zypNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Maco ingkaw hrang letah hmai ung nápaw a ung lynah tai cawngsaw cawh chuh caimang he ka, aaning sahlo cawh thawngchawbia a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mehthaikheh va chuh he ka, a songbepaw pakheh papali tah aa va puh lai. ");
INSERT INTO zypNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cawngsaw aa hlu tu cawtah Zisu kung phah khui khy lytah Zisu a ungnah dihdong ingcung lang kekhui he ka, ingcung cawh ky thlah he ka, aphia letah a ih thlangpaw meh dang lypaw cawh aa za thlah. ");
INSERT INTO zypNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zisu tah aa zingnah khah a hmuh tihtah a songbepaw cawh, “Ka dua, na suanah vytei cawh ngethai a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma letei a ty thlangpaw he phungbia cawngpahtu thaikheh taco aa lungchung tah, ");
INSERT INTO zypNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ma cawngsaw heh zecawtamaw, ma hraco a tah thlang? Khazing a reipachia! Khazing tah ly co ahomaw suanah a ngethai khy?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma cangkawleh cawh zemaw aa pacang tahpaw khah Zisu tah a lungthing tah hnih ka, “Zecawtamaw ma hming sahlo heh naa pacang? ");
INSERT INTO zypNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma a songbepaw khahei, ‘Na suanah sahlo cawh ngethai a cang,’ tahpaw maw a neh vy maw, ‘Tho la, na iphaw a lah la, sei,’ tahpaw maw a neh vy? ");
INSERT INTO zypNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Canghrasala, Cawngsaw Sawcapaw heh aluicung lehei sua ngethai khynah naw a hnui taheh ka ca hmuh sá he a,” a tah he. Taico, a songbepaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tho la, na iphaw a lah la, ing lang a dih,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma cawngsawpaw cawh tho ka, a iphaw khah a lah ka, aa zongmingtei mehmuh leco piathlah ka a sei. Ma hming taco ming maikaw aa ningangsah he ka, Khazing cawh aa reithai. “Ma hapaw hming heh kaa hmuh bang tlung be!” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zisu cawh Galili tuiping ngaekang lang khah va sei kaw ka, ma leco cawngsaw hlupui tah va pange he ka, a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A seipai tah Alfas a sawcapaw Levi cawh ngungkhui kheinah hming letah a typaw khah hmuh ka, Zisu taco, “Va pa zui,” tatah tah ka, taico Levi cawh tho ka, Ama cawh a zui. ");
INSERT INTO zypNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Zisu cawh Levi ing letah zairia batui a e leimeining takhei, ngungkhui a kheitu mehlupui le ahringpaw mehsua sahlo cawh Ama le a hningzuitu sahlo khatah batui aa e hrui. Ama a zuipaw sahlo cawh a hlu ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Phungbia cawngpahtu Farasi sahlo tah mehsua sahlo le, ngungkhui a kheitu sahlo khatei batui a e hruipaw khah aa hmuh tihtah a hningzuitu sahlo khah, “Zecawtamaw, mehsua sahlo le ngungkhui a kheitu sahlo khatah batui a e hrui?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Zisu tah ma cawh thui ka, “A dang thlangpaw taco sibui aa hia tlung be, a dang lypaw tah pui aa hia. Mehding y rua pawtah ka vong tlung be, mehsua sahlo y rua pawtah ka vong hri hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Baptisma peitu Johan hningzuitu sahlo le Farasi sahlo cawh batui a cahe he. Cawngsaw thaikheh a vong he ka, Zisu cawh, “Zecawtamaw baptisma peitu Johan hningzuitu sahlo le Farasi phunglang a zuipaw sahlo cawh batui cahe he ka, canghrasala nama na hningzuitu sahlo cawh batui cahe lytah aa ung?” tatah bia aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Zisu taco, “Sawngpaw sahlo cawh nupui a chuipaw satlepaw khatah aa ung chung taco batui a cahe tei he maw? Aaning khatah a ung thlang chung cawh batui a cahe tei bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Canghrasala, nupui a chuipaw satlepaw cawh aaning taitah lahnah cai a phah tae a. Ma ning taico batui aa cahe tae thlang a. ");
INSERT INTO zypNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ahotahmai tah paithang a thapaw tah chaichi a paringpaw khah a beithlah bang bei he. Ma hratei aa tua caco, paithang a thapaw khah hruipako a ka, a caipaw paithang khah a dochy tima a. ");
INSERT INTO zypNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ahotahmai tah misurhang a hringtui khah sapho tuithei a paringpaw letah rai bang bei he. Aa rai caco, misurhang ka tho a ka, sapho tuithei khah tingchy a ka, misurhang kha, sapho tuithei zong a rawh thlu he a. Ma co cang lytah misurhang a hringtui cawh sapho tuithei a thapaw letah a rai hri a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat ningkhehpaw letah Zisu cawh a hningzuitu sahlo khatah saze lui chung tah sei he ka, aa seipai khei a hningzuitu sahlo taco saangsu cawh aa pahrih pai lai. ");
INSERT INTO zypNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farasi sahlo tah Zisu cawh, “Mingtua, zecawtamaw Sabat ning letah tua phung a cang lypaw heh aa tua?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zisu taco, “David tei a vesaw sahlo khatah aa ngaidi ngetei ning le epaw aa hia ning tei a tuapaw khah rei bang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatha tlangbui alaicaipaw a hrening cai lekhei Khazing behnah ing lang a nae ka, tlangbui sahlo tah ly co ahotahmai e phung a cang lypaw, Khazing aa dangnah very khah a e. Taico a chy khah a vesaw sahlo zong a peh hrah he kho,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mataico Zisu tah aa hai letah, “Sabat ning cawh cawngsaw chahnah cawtah tuapaw cang ka, cawngsaw heh Sabat ning cawtah tuapaw cang be. ");
INSERT INTO zypNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Macawtaco Cawngsaw Sawcapaw heh Sabat Buipaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ning hringpaw letah Zisu cawh synagog lang khah va sei kaw ka, ma leco a kih a songpaw pakheh a za ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mehthaikheh taco Zisu cawh sua aa pu khy nápawtah a bo he ka, macawtaco Sabat ning tah ma cawngsawpaw cawh a dangsah maw dangsah ly takhah aa ngia thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zisu tah a kih a songpaw cawh, “Ming vytei hme lehei a daw tua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mataico aaning sahlo khah, “Sabat ning tahei chahnah tua maw a phung a cang, chahlynah maw? Hringnah pachah heh maw a phung a cang, thaw heh maw?” tatah a hae hri he. Canghrasala zehmai palei bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Zisu taco a thingae hmotah aaning cawh ming he ka, aa lungku a chaw tu cawtah a ngechia ka, cawngsawpaw cawh, “Na kih pathlang,” a tah. A kih cawh pathlang ka, a dang. ");
INSERT INTO zypNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mataico, Farasi sahlo cawh piahly he ka, Zisu cawh zekhatamaw kaa thaw khy a tahpaw khah Herod a hningzuitu sahlo khakhei aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zisu cawh a hningzuitu sahlo khatah tuiping lang sei kaw he ka, Galili taikhei cawngsaw rungpui tah aa zui. ");
INSERT INTO zypNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Zisu tei a tuapaw vytei khah aa thui tihtah Judia raang, Jerusalem khuapui, Idumia raang, Jordan tuivaw rae lang raang le Tair le Sidon khua kaekang letei a ungpaw khua sahlo taikhei cawngsaw hlupui Ama khatah a vong he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cawngsaw aa hlutunah cawtah aa pa pahlong tu sua a tah ka, a hningzuitu sahlo khah a cawtah tuilawng achiapaw khah ting cia tah pa pachiapah thlang my lo a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Zecawtamaw tatah mehnung hlupui khah dangsah he ka, a sahpaw maikaw tah Ama khah tong pawtah hmelang a nang he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Thlawpaw pialuipaw sahlo tei aa tlepaw sahlo maikaw tah Ama cawh aa hmuh tihtah a hmekaw letah pohly he ka, “Khazing Sawcapaw na cang,” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Canghrasala aaning sahlo cawh Ama khah ahomaw a cang tahpaw khah rei ly pawtah cyky tah bia a patai he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zisu cawh tlaang cung lang ke ka, Ama khatah a y dupaw sahlo khah y he ka, Ama khaco a vong he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aaning chung taico pahrawhluihning khah thing he ka, ma sahlo cawh, “Apostol sahlo,” tatah ming a sah he. Aaning cawh Ama khatah ung a pawtah le, phung rei tah taw a pawtah le, ");
INSERT INTO zypNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","khachia sahlo papianah naw aa hnui a pawtah a thingpaw he a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A thingpaw pahrawhluihning cawh ma sahlo heh a cang he. Piter tatei ming a sahpaw Simon, ");
INSERT INTO zypNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi sawcapaw Jeims le Johan (Boanazi a tah he, a silang cawh khalung sawtei sahlo tahnah a cang), ");
INSERT INTO zypNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Barthalomeo, Mathai, Thomas, Alfas a sawcapaw Jeims, Thadia, ci le phing a dawkhuipaw Simon le, ");
INSERT INTO zypNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ama a luitupaw Judas Iskariot a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mataico, Zisu cawh ing lang a nae ka, cawngsaw tah aa pahlong thlangnah cawtah khei Ama le a hningzuitu sahlo cawh batui hmai e thai bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A sawny tah ma kong cawh aa thui tihtah, “A thinglung a hmang khawh beh,” tah he ka, ama lah a pawtah a sei he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Phungbia cawngpahtu thaikheh, Jerusalem taitah a va chuhpaw sahlo taco, “A chung letah Belzabub a hrei ka, ma khachia sahlo buipaw thongtah khachia sahlo a papia khy he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Maco Zisu tah aaning sahlo cawh y he ka, tawchingnah bia tei a chingpaw he cawh, “Zekhatamaw Setan taco Setan lilaw cawh a papia thai a? ");
INSERT INTO zypNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Painah raang raangkheh cawh ama le ama lilaw a dy caco, ma painah raang cawh zekhatamaw a bing khy a? ");
INSERT INTO zypNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ingchungkho khokheh cawh a rai ly tei a chaichy caco, ma ingchungkho cawh a bing khy a be. ");
INSERT INTO zypNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma hraco Setan zong ama le ama a dy tei a chaichy caco, a daw khy a be, a lydenah cai a chuh hri a. ");
INSERT INTO zypNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hmuisui tei co, meh thawtlungpaw khah tongchai taw lytah a ing chunglang a nae tah a hnuicho cawh ahomaw a lah pah khy a? A tongchai khy taitah longlong a lah khy a. ");
INSERT INTO zypNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cawngsaw heh aa suanah vytei le Khazing aa reipachianah vytei khah cawh ngethai a cang he a tahpaw biahmuisui ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Canghrasala Thlawpaw Pathai a reipachiapaw duitei cawh ahohmai ngethai cang by bei he. Ama cawh chaizaw suanah a tuapaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ma bia heh, “Thlawpaw pialuipaw a chung letah a hrei,” tatei aa tah cawtah a reipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mataico, Zisu a no le a uny sahlo cawh va chuh he ka, khunglai lang letah a daw thlang he ka, cawngsaw taw he ka, Zisu khah aa za ysah. ");
INSERT INTO zypNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Cawngsaw hlupui tah a ty cadung thlang he ka, a hai letah, “Na no le na uny sahlo tah nama ca hui he ka, alailang letah aa ung thlang he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Zisu taco, “Ahomaw ka no le ka uny sahlo cawh a cang he?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mataico a kae letei a ty cadung thlangpaw sahlo cawh ming he ka, “Ma lehei ka no le ka uny sahlo cawh a ung thlang he hi! ");
INSERT INTO zypNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ahohmai Khazing dunah a tuapaw cawh ka uny, ka satei le ka no a cang he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ma khy taico ning hringpaw leco Zisu tah Galili tuiping kae lekhei a cawngpah he. Ama a pahmo sopaw cawngsaw khah aa hlutunah cawtah tuilawng chunglang a nae ka, a ty ka, tuili lang a seisah. Ma chung vytei cawh zawpuipaw khah ngaekang letah a ung thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hming hlupui khah tawchingnah bia tah cawngpah he ka, tawchingnah bia sangkheh a chingpaw he cawh, ");
INSERT INTO zypNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngetua hmai o! Ly a tuapaw pakheh cawh thleci va pawtah ly lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Thleci a va leimeining takhei a chy cawh lang kae letah tlah ka, pavaw sahlo tah a va zy he ka, aa khi thlu thah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A chy cawh alui apawnah lungda letah tlah he ka, alui a pawnah cawtah sungkheh teitah a ka cy he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Canghrasala ning va tha ka, a ai tih he tah thahrang aa thlah lynah cawtah a ro palang thah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A chy cawh ahling hrong letah tlah he ka, ahling cawh ka chang ka, a diseh thlu caw he tah saze vui bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Canghrasala a chy cawh alui a chahnah letah aa tlah. Ka cy he ka, ka chang he ka, a zaw tihtah a saze cawh a leh songthung, a leh songruh, a leh zakhé tahmai a vui,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Taico, Zisu tah aa hai letah, “Thuinah nawkho a hnuipaw taco ma bia heh thui he seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ma khy taico Zisu cawh Ama teitah a ungning takhei apostol pahrawhluihning le a kaekang letei a pahmopaw ahringpaw cawngsaw sahlo takhei tawchingnah bia a silang khah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Zisu tah, “Naaning cawh Khazing painah raang biaparuh hni khynah khah peh na cang thah he ceh. Canghrasala, alailang tei a ungpaw sahlo duitei cawh zezong khah tawchingnah bia tah ching a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Macawtaco, ‘A ming cawh aa ming leimei thlang a, canghrasala hmuh by a bei he. Aa naw tah aa thui leimei thlang a, canghrasala hnih thai hlui a bei he. Ma hratei a cang ly caco Khazing lang a paleh kaw sua he seh la, ngethai tah a ung pang he a,’ tatah Capathai tah a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Taico Zisu tah aa hai letah, “Ma tawchingnah bia heh hnih thai bei he ceh maw? Ma heh hmai naa hni ly caco zekhatamaw tawchingnah ahringpaw sahlo cawh naa hni thai a? ");
INSERT INTO zypNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ly a tuapaw tei a vapaw thleci cawh Khazing bia heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Meh thaikheh cawh lang letei a tlahpaw thleci sahlo khatah a lo he. Bia khah aa thui cangkawleh Setan cawh a vong ka, aa chung letei vapaw bia cawh a lah pah thah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ahringpaw cawh lungda cung letei a tlahpaw thleci sahlo khatah a lo he. Khazing bia aa thui cangkawleh lunglawng teitah aa cyhlang. ");
INSERT INTO zypNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Canghrasala, thahrang aa thlah lynah cawtah khua sy parui bei he. Khazing bia rawng tah ruhanah le hrehnah a chua tihtah a pohly palang he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ahringpaw meh thaikheh cawh ahling hrong letei a tlahpaw thleci khatah a lo he. Khazing bia cawh aa thui thlang, ");
INSERT INTO zypNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","canghrasala, khazaw lung reithuinah le hnuirung dunah le a hringhrepaw dunah vytei tah thawngchawbia khah pazai thah ka, a thui thuisah khy be. ");
INSERT INTO zypNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Canghrasala ahringpaw cawngsaw thaikheh cawh alui a chahnah letei a tlahpaw thleci khatah a lo he. Khazing bia cawh thui he ka, cyhlang he ka, thuisu cawh a leh songthung, a leh songruh a leh zakheh tai hmai a vui he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Zisu taco aa hai letah, “Me-ing cawh tongbai rai letah cang seh, lakhing rai letah cang seh aa chia tei maw? Me-ing tung letah chia bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","No thlangpaw hming vytei cawh palang thlu cang a he ka, bakhupaw hming vytei cawh a langhai tah chuakhui a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Thuinah nawkho a hnuipaw maikaw tah ma bia heh thui he seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A rei vypaw cawh, “Naa thuipaw khah a chaw teitah pacang my lo! Naa hmangpaw neh ná khei neh kaw cang he ceh ka, alai vy tahmai a ca neh he a. ");
INSERT INTO zypNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A hnuipaw cawh peh vy cang a ka, a hnui lypaw cawh a hnuitlakangpaw tei hmai khah lah pah a cang a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zisu tah, “Khazing painah raang cawh cawngsaw pakheh tei a ly letah thleci a vapaw hratah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ching le zai, a i tah cang seh, a hraw tah cang seh, thleci cawh ama teitah ka cy ka, ka chang ka, canghrasala, zekhatamaw a cang tahpaw hnih be. ");
INSERT INTO zypNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Alui tah ama teitah saze a chuasah. A hmetaw tah a kung, a pazui tah a thuisu, taico achang tatah a chuasah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hre a zaw cangkawleh sahaw cawh a lah ka, a aw he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zisu tah a rei vypaw bia cawh, “Khazing painah raang cawh zekhatamaw a lo? Zekhatamaw kaa tawching a? ");
INSERT INTO zypNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Alui letei cingpaw thleci vytei letah a chia caipaw aihrang ci khatah a lopaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Alui letah ling he ka, a ka chang tih taco buichung thleci hrong letah a kung alaicaipaw tah a ka tua. A caibai zong alaipaw pui a cangnah cawtah pavaw zong tah a ningde letah a cawng tei he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma hapaw tawchingnah bia khah Zisu tah hmang ka, aa hnithai khynah zé tah Khazing bia khah a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tawchingnah bia hmang lytah aaning sahlo cawh cawngpah bang bei he. Canghrasala a hningzuitu sahlo khatah aaning teitah aa ungning tah zezong a chingpase kaw tei he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma ning zailang leco, Zisu tah a hningzuitu sahlo cawh, “Raechai lang sei he peh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Zawpui cawh seisai he ka, Ama a ungnah tuilawng khei aa seikhui. Ma leco tuilawng hringpaw zong a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Thlichia cawh a hrang caimang ka, tuileh cawh tuilawng chunglang tai a nae pai leimeinah cawtah tuilawng cawh tui lang a phung daimang. ");
INSERT INTO zypNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zisu cawh tuilawng a lei lang lekhei ung ka, a tynah dyching lekhei a ihning thlang. A hningzuitu sahlo taco va patho he ka, “Cawngpahtu tui lang kaa tlápaw heh na ze a ca pui bei maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zisu cawh ka tho ka, thli cawh a hrangso. Taico, tuileh cawh, “De! A cali!” a tah. Mataico, thli cawh de ka, tuileh cawh a cali he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Taico, Ama taco a hningzuitu sahlo cawh, “Zecawtamaw ma reiro co naa ci? Zingnah hnui ting bei he ceh maw?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A hningzuitu sahlo cawh ci ngetei he ka, “Ma heh zehapaw cawngsaw maw a cang? Thli le tuileh tahmai a bia aa nge thlangpaw heh!” tatah aaning le aaning cawh aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Zisu le a hningzuitu sahlo cawh tuiping cawh cakah he ka, Gerasin raang khah aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zisu cawh tuilawng taitah a cungthlah ning takhei thlawpaw pialuipaw tei a tlepaw cawngsawpaw tah ama khah a tawng pawtah thlaikung taikhei a va sei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma cawngsawpaw cawh thlaikung letei a ung teipaw cang ka, ahotahmai tah hraipaking tah bahrairui tahmai tongchai khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zemaw tah pawco a kih le a phe khah uihlupui tongchai he ka, canghrasala bahrairui khah chehchung thlu ka, a phe letei thawrui sahlo zong khah a phongchung thlu he. Ahotahmai tah ama cawh tle pakhih khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ching le zai, thlaikung letah le a kaekang tlaang vytei leco a khiakaly ka, ysang ka, ama le ama cawh alung tah a aw tei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Langhlaw pui taitah Zisu cawh a va hmuh tihtah va saihno ka, a hmekaw letaco a khuh a panai. ");
INSERT INTO zypNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Cungnungcai Khazing Sawcapaw, Zisu, kama khatah zemaw na dupaw a ung? Pa hreh haitei kheh tatah Khazing ming tah ka ca naw,” tatah a thang khy chung tah a y. ");
INSERT INTO zypNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Zemaw tah pawco Zisu tah ama khah, “Nama thlawpaw pialuipaw, ma cawngsawpaw a chung taikhei piathlah,” tatah a tah thah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mataico Zisu tah, “Na ming ahomaw?” tatah a hae. Ma cawngsawpaw taco, “Kaa hlu ngeteinah cawtah ka ming cawh Thongzakheh a cang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Taico, ma raang chung taico a pialuipaw thlawpaw sahlo cawh papia ly rua pawtah Zisu cawh a naw canei leimei thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aa kae tlaangpa lekhei lawh a e leimeipaw voh rungpui a ung he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Khachia sahlo taco Zisu cawh, “Voh rung lang ma seisah la, aa chunglang a ma naesah thlang,” tatah aa naw. ");
INSERT INTO zypNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aaning cawh seinah naw pei he ka, thlawpaw pialuipaw sahlo cawh piathlah he ka, voh chunglang cawh a nae he. Thonghning hrawng a cangpaw voh rungpui cawh lungkang cung taitah tuiping lang khah a zythlah he ka, a thi thlu he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Voh a mingkaitu sahlo cawh sai tlamang he ka, ma konglang cawh khuapui le khuatei vytei khah va thuisah he ka, ma hratei hming a cangpaw cawh ming rua pawtah ming hlupui khah a va chuh he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zisu kung aa va tlung tihtah thlawpaw a pialuipaw sahlo bupui tei aa tlepaw cawngsawpaw khah chaichi a tua ka, lungsing teitah ama khatah a za tythlangpaw khah aa hmuh tihtah aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Thlawpaw a pialuipaw sahlo tei aa tlepaw cawngsawpaw le voh sahlo cung letei hming a tlungpaw khah a hmuhpaw sahlo taco, a cangnah kong cawh zawpui khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mataico Zisu cawh aa raang taitah piathlah a pawtah aa naw. ");
INSERT INTO zypNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zisu cawh tuilawng chunglang khah a nae ning takhei khachia tei a tlepaw cawngsawpaw taco, “Nama khatah ka seilai hrá a,” tatah a naw. ");
INSERT INTO zypNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Canghrasala Zisu tah sai be. “Ma navy co na ing lang va sei la, Abuipaw tei ningdo a ca tah zia le na cung letei hming rungnawpaw a tuapaw khah na sawny va ching he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Macawtaco ma cawngsawpaw cawh sei ka, Dekapoli raang lekhei Zisu tah zetlua tamaw a cawtah hming a tuapah takhah ching longmang he ka, cawngsaw vytei cawh aa khuarawh a haa ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zisu cawh tuilawng tah raechai lang cawh va sei kaw hui ka, tuili raechai lang letah a ung thlangning taco, cawngsaw hlupui tah aa pahlong thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma ning taco, synagog a uhtu pakheh a cangpaw Jaira cawh a vong ka, Zisu kung a va phah tihtah a phe hrang letah a bawh ka, ");
INSERT INTO zypNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Ka sawcanu a thi daimang. Ningdo pawtei tah a vong la, a cung letah na kih pahnia la, ma tei na tua caco dang kaw a ka, a hring kaw thlang a,” tatah a sah pui tah a naw. ");
INSERT INTO zypNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Macawtaco Zisu cawh Jaira khaco sei ka, cawngsaw hlupui tah zui he ka, Ama cawh aa pahlong thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma leco, canu pakheh kung hrawhluihning chung a thi a chuh no a ung. ");
INSERT INTO zypNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sibui a hlupui tah mingkai he ka, a taithui ngetei. A hnuicho vytei pachang thlu ka, dang vy hlui lytah a pazua vy lo leimei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Zisu thong a thui tihtah zawpui hrong leco a hninglang tah a vong ka, a chaichi dong cawh a va tong, ");
INSERT INTO zypNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","zecawtamaw tatah, “A chaichi chang ka tong khy caco ka dang a,” tahpaw a rawh cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma cangkaw leco a thi cawh kih thah ka, ka sawnah taitah ka dang myca tahpaw khah a hni. ");
INSERT INTO zypNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Cawngsawno tah a va tong cangkawleh cawh Zisu tah a chung taitah hmingtuakhynah a piapaw khah a hni. Zawpui lang cawh a hui ka, “Ahomaw ka chaichi a pa tong?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A hningzuitu sahlo taco Zisu cawh, “Cawngsaw hlupui tah aa ca nuapaw khah na hmuh thlang heh saw, zekhatah zia tamaw, ‘Ahomaw a pa tong?’ na tah thlang!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Canghrasala Zisu cawh a chaichi a tongpaw khah ahomaw a cang takhah zawpui hrong lekhei a ming lai. ");
INSERT INTO zypNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Taico ma cawngsawno taco, a cung letei hming a tlungpaw khah a hninah cawtah ci ka, a cathing hmotah a phehrang letah a va bawh ka, a cangnah vytei cawh a ching thlu. ");
INSERT INTO zypNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zisu taco, “Ka sawcanu, na zingnah tah a ca dangsah. De teitah va seí la, na sawnah taco ca thlaw myca seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zisu tah bia a rei leimeining taco, synagog a uhtu Jaira ing taico meh thaikheh a vong he ka, “Na sawcanu cawh a thih thah, cawngpahtu khah hnahnawh ruapaw cang khawh be,” tatah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Zisu tah aa reipaw cawh a thuisah du lytah ung ka, Jaira hai leco, “Na thlawzawng kheh seh, na zing a hy,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Piter le Jeims le Jeims a unypaw Johan tah cy ly co ahohmai a zuisah bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Synagog a uhtu Jaira ing cawh aa va phah tihtah hnahnawh luri tah le caw le ysang tah a ungpaw sahlo khah a hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ing chunglang a nae ka, aa hai letah, “Zecawtamaw hnahnawh luri tah le cawtah naa ung? Ma nyno heh a thih tlung be, a ihning hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Canghrasala Ama cawh aa hnuiso. Aaning vytei cawh a papia khy tai he tah nyno a no le a paw le a hningzuitu pathung khakhei nyno a ungnah lang khah a nae he. ");
INSERT INTO zypNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nyno cawh a bang tah law ka, “ Talitha Kumi,” tatah a tah. A silang cawh, “Nyheh no, tho ka ca tah,” tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma cangkawleh cawh nyno cawh tho ka, a khiathi. (Ama cawh kung hrawhluihning a cang). Ma cawh aa hmuh tihtah aa ning a ang ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma kong cawh ahohmai thuisah ly pawtah a sah pui tah bia a patai he. Taico, “E ruapaw sangkheh kheh pei my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zisu cawh piathlah ka, a cinglainah khua lang sei ka, a hningzuitu sahlo taco aa zuilai. ");
INSERT INTO zypNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat ning cawh va chuh ka, synagog leco cawngpah he ka, a bia aa thuipaw vytei cawh aa ning a ang ngetei. Aaning taco, “Ma cawngsawpaw heh zehapaw singnah maw aa peh? Zekhatamaw ningang chuipaw hming sahlo heh a tua khy? ");
INSERT INTO zypNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ama heh kih zungthaipaw khah cang bei maw? Mari sawcapaw Jeims, Josef, Judas le Simon sahlo aa unypaw khah cang bei maw? A satei sahlo zong kaaning khatah ma lehei ung thlang hrah bei he maw?” tah he ka, a cung letah aa lung tling be. ");
INSERT INTO zypNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Zisu tah aa hai letah, “Khazing khuavang cawh a pinah khua letah le a ruachai sahlo le a ingchungkho hrong letah tah cy ly co kawkih letah pasungpanaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A dang lypaw meh cawngtei cung letah a kih pahnia ka, a dang sahpaw he tah ly co, ma leco ningang chuipaw hming zehmai tua khy be. ");
INSERT INTO zypNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Zingnah aa hnui lynah kong leco a khuarawh a haa. Mataico, ma kaekang hrawng letei a ungpaw khua sahlo cawh tlawng lai ka, a cawngpah lai he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zisu tah a hningzuitu pahrawhluihning khah y he ka, thlawpaw pialuipaw cung letah nawhnuinah pei he ka, pahning longmang tah a taw he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bia a pataipaw he cawh, “Naa khuatlongnah cawtah cungcahrei cy ly co zehmai a pho khe la, zairia cang seh, sahre cang seh a pho khe lo. Naa angki bawng letah tangka zong a sang khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Phepakong a pakong la, canghrasala angki zing hning tah a pathai khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ing naa tlung tih he tah ma khua naa seisai kaw hlai vytei cawh ahringpaw lang a palong khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Taico zeletahmai tah aa ca cyhlang ly caco he le a cang ly leh naa bia aa nge du ly caco, naa piathlah tihtah aaning khah raering pehnah cawtah naa phe letei luipadih khah cathing thlah si my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Macawtaco aaning sahlo cawh piathlah he ka, cawngsaw vytei cawh aa suanah a ngepachih rua pawtah aa cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Khachia a hlupui papia he ka, mehdang ly a hlupui zong sathy thu he ka, aa dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Zisu ming cawh kawkih letah a thang cawtah Herod siangpahrang tah ma vytei cawh a thui. Thaikhehpaw tah, “Baptisma peitu Johan khah thihnah taitah thosah kaw cang ka, macawtaco ningang chuipaw hmingtuakhynah a hnuipaw a cang hi,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Thaikhehpaw sahlo taco, “Khazing khuavang Elija a cang,” aa tah. Taico thaikhehpaw tah, “Khuahlai tei Khazing khuavang pakheh kheh hapaw, Khazing khuavang a cang,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Canghrasala Herod tah ma bia cawh a thui tihtah, “Kama tei a lu ka taipaw Johan khah thihnah taitah thosah kaw a cang!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Abui Herod ama ceingei tah baptisma peitu Johan khah tlesah he ka, tongchaisah he ka, thong letah a thlah. Zecawtamaw tatah a nyteipaw Filip a nupuino Herodi khah nupui tah chui ka, a lung a lawngsah du cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johan tah Herod khah, “Na nytei nupui na chupaw heh a phung cang be,” tatah a mochia cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ma rawng taco Herodi tah Johan khah a lungchung tah a carae ka, thaw a du. ");
INSERT INTO zypNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Canghrasala, theh khy be zecawtamaw tatah Herod taco Johan cawh mehding le mehpathai a cang tahpaw khah hnih ka, cizaw ngetei ka, a vai lai. Johan bia a reipaw cawh a thui tihtah a chungsi a vang thlang naná teitah a reipaw bia nge cawh a du thlang thly thly. ");
INSERT INTO zypNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A changnah letaco Herodi cawtah a raicangpaw cai cawh a va chuh. Herod tah a pinah ningcai lekhei, uhtu bui a cangpaw sahlo le raekeh bui sahlo le Galili raang chung letei hruitu macang vytei khah kongchuanah a tuapah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodi a sawcanu cawh a za nae ka, a lang tihtah Herod le a khuachai sahlo cawh a lawng ngetei he. Herod taco nyno hai letah, “Zemaw na du? Na dupaw maikaw pa hae la, ka ca pae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Taico, chia a sah hmo tei a reipaw cawh, “Na pa haepaw maikaw cawh ka painah raang a chy hmai ka ca peh a tatah bia ka kaang,” a tah vy. ");
INSERT INTO zypNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nyno cawh piathlah ka a no cawh, “Zemaw ka hae a?” tatah a hae. A no taco, “Baptisma peitu Johan a lu,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma cangkawleh cawh nyno cawh rairang tah siangpahrang Herod khaco a za nae kaw ka, a haepaw cawh, “Baptisma peitu Johan a lu khah ato hrahring heh daabakho tah pa pei la, ka du,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Siangpahrang Herod cawh a lung reithui ngetei ka, canghrasala a khuachai sahlo hme letah bia a kaang thah cawtah khei nyno bia cawh ei du be. ");
INSERT INTO zypNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma cangkawleh cawh raevaitu raekeh pakheh khah rairang tah taw ka, Johan a lu cawh na va tle a tatah a tah. Cawngsawpaw cawh va seí ka, thong-ing leco Johan a lu cawh va tai ka, ");
INSERT INTO zypNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","dabakho tah a lu cawh a va tle. Nyno cawh hlai ka, nyno taco a no cawh a peh pachaw. ");
INSERT INTO zypNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma kong cawh Johan hningzuitu sahlo tah thui he ka, a vong he ka, a rawh cawh law he ka, thlai letah aa phung. ");
INSERT INTO zypNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostol sahlo cawh aa va kaw kaw tihtah Zisu kae leco a pahmo he ka, aa cawngpah pawhe le aa hming tuapaw vytei khah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mataico cawngsaw a sei chuhchypaw aa hlutunah cawtah Zisu le a hningzuitu sahlo cawh batui e nápaw cai hmai hnui be ca he ka, a hningzuitu sahlo khah, “Kama khatah a vong la, a denah lang sei he peh, a hia cawng ná he ceh seh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Macawtaco aaning longtei tah tuilawng tah a kingdangnah lang cawh aa sei. ");
INSERT INTO zypNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Canghrasala, aa seipaw a hmuhpaw mehlupui takhei, aaning aa cangpaw khah aa hninah cawtah khua ting taitah va sai he ka, aaning hlai tahmai aa sei nápaw hminghmaw cawh aa phah taw. ");
INSERT INTO zypNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zisu cawh tuilawng taitah ka piathlah ka, cawngsaw zawpui khah a hmuh tih he tah kingtu a hnui lypaw tuu sahlo hratah aa cangnah cawtah khei ning a do ngetei he. Macawtaco hming hlupui kong cawngpah khah a hrang a patho. ");
INSERT INTO zypNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ning cawh tlah daimang ca ka, a hningzuitu sahlo cawh Zisu khatah a vong he ka, “Ma heh raang kingdang tah cang ka, ningkhua zong a tle ngetei myca. ");
INSERT INTO zypNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kaa kaekang khua sahlo lang sei sá la, ding e ruapaw a va cawh he seh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Canghrasala Zisu taco, “Naaning tah e ruapaw cawh pei o,” a tah he. Aaning taco, “Cawngsaw pakheh thlah reh chung nihlo pui a hia caw! Ma vytei co very cawh co he peh ka maw aa e ruapaw cawh kaa pae he a?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Zisu taco, “Very tlang khazeh maw naa hnui, va seí la, va ming tua o,” a tah he. Aa va ming tihtah, “Very tlangpangaw le ngaw sanghning a ung,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Taico Zisu tah a hningzuitu sahlo cawh cawngsaw vytei khah a phuphu tah araang cung lekhei a ty sá pawtah bia a peh he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma hraco cawngsaw vytei khah zakheh phu, songngaw phu tah a tysah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zisu tah very tlangpangaw le ngaw sanghning cawh law ka, avai lang a y ka, Khazing khatah lawngbia hlai ka, very tlang sahlo cawh a kychy. Mataico, a hningzuitu sahlo khah zawpui cawh rai pawtah a peh he. Mataico ngaw sanghning zong cawh ming vytei hrong leco a rai he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aa zongmingtei co e he ka, aa ri a vaw thlu. ");
INSERT INTO zypNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A hningzuitu sahlo taco very le ngaw a tangpaw cawh pakhong he ka, baihraw hluihning chih ky tah aa dui. ");
INSERT INTO zypNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Very a epaw sahlo cawh capaw puitling 5000 a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Zawpui khah a disah chung he takhei Zisu tah a hningzuitu sahlo cawh rairang tah tuilawng chunglang a naesah he ka, Galili rili raechai Bethsaida khua lang khah a seisah hlang he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aa seisai khy tai he tah Ama cawh thlawchang pawtah tlaang cung lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zailangsang leco tuilawng cawh tuili a lecingcing lekhei ung ka, Zisu cawh Ama longtei tah tlaang lekhei a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Thli tah a rupui tah a nangnah rawng he tah a hningzuitu sahlo cawh aa lawng khah zeh khy khawh bei he tahpaw Zisu tah a hmuh. Monglang suimehlang papali hrong lekhei Zisu cawh tui cung leco aaning lang va sei ka, aaning khah a khungsai daimang he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Canghrasala, tui cung letei a va seipaw khah a hningzuitu sahlo tah aa hmuh tihtah athlaw a cang rua tah he ka, a ysang he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Aa zongmingtei tah Ama cawh hmuh he ka, aa ci ngetei. Ma cangkawleh cawh Zisu tah, “Naa thlawzawng kheh seh, kama ka cang, ci khe o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mataico tuilawng lang cawh aaning khatah a nae ka, thli cawh a de. Mataico, a hningzuitu sahlo cawh aa khuarawh a haa ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aa lungku khah pachawsah aa cangnah cawtah very kong khah aa lunghaa be. ");
INSERT INTO zypNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Raechai lang khah va cakah he ka, Genesaret raang khah va phah he ka, aa lawng cawh ma leco aa hrai. ");
INSERT INTO zypNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tuilawng taitah aa ka pia cangkawleh cawngsaw tah Zisu a cang tahpaw khah aa hni. ");
INSERT INTO zypNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma letei cawngsaw sahlo cawh a kawkih ná tah sai he ka, a ung tatei aa thuinah maikaw leco, a sahpaw sahlo cawh aphia tah aa va song he. ");
INSERT INTO zypNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Taico, khuapui sahlo letah cang seh, khuatei sahlo letah le raang chung letah cang seh a seinah maikaw lekhei, a dang lypaw sahlo khah chodo tlaang lekhei aa chuakhui he. A pai dong tei chang tongsah rua pawtah naw he ka, Ama a tongpaw vytei cawh a dang he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasi sahlo le Jerusalem taitei a vongpaw he phungbia cawngpahtu thaikheh taco Zisu cawh cadung he ka, ");
INSERT INTO zypNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","a hningzuitu thaikheh cawh kih si phung a cangpaw khah zui lytah kih si lytah batui aa epaw khah aa hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farasi sahlo le Juda cawngsaw vytei cawh aa pupaw leh cawngpahnah phungbia hrakhei kih si taw ly co, batui e bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chodo tlaang letah hming aa cawh tih zong tah kih si ly co batui e bei he. Taico ahringpaw pupaw phung sahlo aa zuipaw ung vy ka, ma sahlo cawh ny sahlo, daabei sahlo, ketli sahlo sipathai tah hapaw sahlo khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Macawtaco, Farasi sahlo le phungbia cawngpahtu sahlo tah, “Zecawtamaw, na hningzuitu sahlo heh pupaw phungbia zui lytah a pathai lypaw kih tah batui aa e zia?” tatah Zisu cawh aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Zisu tah aaning cawh, “Khazing khuavang Isaiah tei naaning cungmai raipha sahlo naa kong a reihlangpaw heh a hmang caimang. Isaiah tah, ‘Ma cawngsaw sahlo tahei aa hmokaw co aa pa cizaw, canghrasala aa lungthing cawh kama taitah a hlah ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aa pa behpaw zong heh aa cawtah zehmai chahnai be. Aa cawngpahnah zong heh mehnung tuachawngpaw phungphe sahlo suipaw a cang he,’ tatah a cia. ");
INSERT INTO zypNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Khazing biapeh sahlo laky khah seisai he ceh ka, mehnung tuachawngpaw phungbia cawh na tle hri he ceh,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Taico aa hai letah, “Naaning naa phungbia sahlo zui nápaw cawtah Khazing biapeh sahlo hneihly cawh naa thai ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses tah, ‘Na no na paw cizaw my lo,’ taico, ‘A no cang seh, a paw cang seh chia a sahpaw cawh thaw a cang a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Canghrasala naaning tah naa tahpaw cawh cawngsaw pakheh tah a paw a cang ly leh a no khatah, ‘Kama taitah na hmuh khy a paw bawnah cawh Korban, (A silang cawh Khazing khatah pehlai a cang thah) a cang a,’ a tah caco, ");
INSERT INTO zypNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ma cawngsawpaw cawh a no a cang ly leh a paw cung letah zehmai tuasah sai khawh bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naa hlai pachaw laipaw he ceh phungbia khei Khazing bia khah zelypaw tah naa cangsah. Taico, hming hringpaw sahlo zong ma hraco naa tua,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zisu tah ming zawpui khah Ama khatah y kaw he ka, “Ming vytei, ka bia heh nawthlia la, hnih thai my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kaw taitah chunglang a naepaw taco cawngsaw khah papia palui be. Kaw taitah a ka piapaw duitei taco cawngsaw khah a papia palui. ");
INSERT INTO zypNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Thuinah nawkho a hnuipaw maikaw taco thui he seh,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zawpui cawh seisai he ka, ing chunglang a nae khy taitah a hningzuitu sahlo taco tawchingnah bia a silang khah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Zisu taco, “Naaning zong ma tlua co maw naa lung a co? Kaw taitei chunglang a naepaw taco cawngsaw cawh papia palui khy be tahpaw cawh hnih bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Zecawtamaw tatah a lungthing chunglang a nae lytah a ri lang a nae ka, alailang a pia kaw thlang,” a tah he. Zisu tah ma hratei a reipaw heh zehapaw epaw hmai a pathai a tah dunah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma hrahei rei vy ka, “Thinglung chung taitah a kapiapaw tahei cawngsaw cawh a papia a palui tei. ");
INSERT INTO zypNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Zecawtamaw tatah cawngsaw lungthing chung taihei a chaw lypaw khuarawnah sahlo, canu capaw suanah, ruhnah, lenongnah, a pheinah, ");
INSERT INTO zypNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","duhlui hnuinah, zia hnuinah, hinghenah, hohenah, hnachuanah, male thai pachianah, a palai a patuinah le a ningcang lytah khuasahnah tahpaw sahlo a chuh he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ma hmingchaw ly vytei heh chunglang taitei a ka piapaw cang he ka, cawngsaw a papia a palui sahpaw a cang he,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zisu cawh ma hminghmaw cawh seisai ka, Tair khua kaekang lang a sei. Ingkheh chung letah a nae ka, ahohmai khah hnisah du bei he, canghrasala a nawh khy hlui be. ");
INSERT INTO zypNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A sawcanu thlawpaw pialuipaw tei a tlepaw canu pakheh cawh Zisu kong a thui cangkawleh rairang tah a vong ka, a phehrang lekhei a bawh. ");
INSERT INTO zypNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma canuno cawh Siria pai Fonisia raang letei a pipaw, Grik cawngsaw a cang. A sawcanu chung letei khachia papia pah pawtah Zisu cawh a naw. ");
INSERT INTO zypNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zisu taco, “Sawtei leh taco aa dupaw vytei e taw he seh. Sawtei leh aa very cawh lá tah ui sahlo peh cawh a phung cang be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Canuno taco, “A cang, Abuipaw, canghrasala cabuai rai letei a ungpaw ui sahlo taco sawtei leh didang cawh aa khi thlang hrah,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mataico Zisu tah, “Ma hratei na pachainah cawtah hei, ing lang na dih khy. Khachia tah na sawcanu cawh a piasai thah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cawngsawno cawh ing lang cawh a dih ka, khachia tei a piasai thahpaw a sawcanu cawh lakhing letah a lia thlangpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ma khy taico Zisu cawh Tair khua taikhei piathlah ka, Sidon khua cahrong ka, Galili rili lang cungthlah ka, Dekapoli raang lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma leco cawngsaw pakheh a nawpang katei, a rei a thlaw thai lypaw cawh Ama khatah va chua khui he ka, a cung letah a kih pahnia pawtah Zisu cawh aa naw. ");
INSERT INTO zypNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zisu tah ama cawh zawpui hrong taico piathlah khui ka, a nawkho chunglang cawh a kihdong a cahro. Mataico a ci tah chawh ka, a lui cawh a tong. ");
INSERT INTO zypNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Avai lang a y ka, a sah pui tah a husua ka, cawngsawpaw khaco, “ Effatha,” (A silang cawh a hong tua tahnah a cang) tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma cangkawleh cawh a naw cawh a awng ka, a lui cawh a ka catlai ka, achaw teitah bia a rei. ");
INSERT INTO zypNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zisu tah ahohmai thuisah khe lo tatah bia a patai he. Canghrasala, a hlu vy bia a patai he leh, a hlu vy tah aa reilai tima. ");
INSERT INTO zypNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Cawngsaw sahlo cawh aa khuarawh a haa ngetei. Aaning taco, “A tuapaw hming vytei heh a chah caimang. A nawpangpaw hmai khua thuisah ka, a rei a thlaw thai lypaw zong a rei a thlawsah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma ningcai leco, cawngsaw hringpaw a hlupui a pahmo hui he. Epaw zehmai aa hnuilynah cawtah Zisu tah a hningzuitu sahlo cawh y he ka, ");
INSERT INTO zypNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ma cawngsaw sahlo heh kama khatah ningthung tai ung myca he ka, e ruapaw zehmai aa hnui khawh ly cawtah ka ning aa pa do ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aa ngaidi hmotah tlungsah my he neh seh la, lang letah a baw he a. Zecawtamaw tatah mehthaikheh cawh langhlaw pui taitah a va chuhpaw aa cang cawtah,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A hningzuitu sahlo taco, “Ma raang kingdang lehei ma vytei mehnung dang ruapaw lawh heh ahomaw a hmuh khy a?” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zisu tah, “Very tlang khazeh maw naa hnui?” tatah a hae he. “Tlangsarih,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ming zawpui cawh alui letah a tysah he. Ma khy taico very tlangsarih cawh law ka, Khazing khatah lawngbia a hlai khy taitah ky chy ka, a hningzuitu sahlo cawh zawpui khah rai rua pawtah a peh he. A hningzuitu sahlo tah zawpui cawh aa rai he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ngadih a cawngpe hnui pai he ka, ma caw zong taco alawngnah bia hlai ka, a hningzuitu sahlo khah raipai law a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aa dawngkasawny co e he ka, aa ri a vaw ngetei. Taico, a hningzuitu sahlo tah ebangpaw cawh pakhong he ka, baisarih chih ky tah aa dui. ");
INSERT INTO zypNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma letei very a epaw he cawh patling 4000 hrawng a tah he. Mataico Zisu tah zawpui cawh ing lang a disah he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma khy taico a hningzuitu sahlo khatah tuilawng chunglang a nae he ka, Dalmanutha pai lang aa sei. ");
INSERT INTO zypNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasi sahlo cawh Zisu khatah a vong he ka, bia aa hae. Ama khah pase du tah vaicung langtei ningang chuipaw paching pakhanah tua khah aa sia. ");
INSERT INTO zypNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A hu a sah pui tah sua ka, “Atochai cawngsaw tahei zecawtamaw ningang chuipaw paching pakhanah heh aa du tlong? Biahmuisui ka ca ching he, ma hapaw hming cawh peh cang a bei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Taico, aaning cawh seisai he ka, tuilawng chunglang cawh a nae ka, Galili tuiping raechai lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A hningzuitu sahlo tah very a pho monghly he ka, tuilawng chung leco aaning khatah tlangkheh tei suipaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Taico Zisu tah aaning sahlo cawh, “Farasi sahlo le Herod raangri taikhei a vai la, a raering my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A hningzuitu sahlo tah, “Very kaa hnui ly cawtah a reipaw a cang,” tatah pakheh le pakheh a tah tlungmang he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zisu tah aa reipaw bia khah hnih ka, aaning khah, “Zecawtamaw very naa hnui lypaw kong naa rei leimei? Ato tingtai hnih thai ting bei he ceh maw? Naa lung a ku achaw caw tamaw? ");
INSERT INTO zypNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Meh hnui thlang tlung pawtah hmuh bei he ceh maw? Naw hnui thlang tlung pawtah thui bei he ceh maw? Taico a thui thlang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mehnung 5000 caw tei very tlang pangaw ka chy ning takhei a hluipaw khah bai khazeh maw naa dui kha?” tatah hae he ka, “Baihraw hluihning,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Taico Zisu tah, “Taico mehnung 4000 caw tei very tlang sarih ka chy ning takhei a hluipaw bai khazeh maw naa dui vy kha?” tatah hae he ka, “Bai sarih,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Zisu taco, “Ma naná co hmai hnih thai ting bei he ceh maw?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida khua cawh va phah he ka, mehcopaw pakheh khah cawngsaw thaikheh tah va chua khui he ka, tongpá pawtah Zisu cawh aa naw. ");
INSERT INTO zypNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Taico mehcopaw cawh a kih tah tle ka, khua lailang a piakhui. A mehkho leco a ci tah chawh ka, a cung letah a kih chia ka, “Zehming sangkheh chang na hmuh maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mehcopaw cawh a ka hui ka, “Cawngsaw hmuh he neh ka, thingkungpaw sahlo aa seilaipaw ky aa lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zisu tah a meh cung leco a kih cawh a chia kaw. Taico a meh cawh ka dui ka, khuahmuh kaw ka, zezongpui khah a sepaw teitah a hmuh khy he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Taico Zisu tah a ing lang a disah ka, “Khua chunglang a nae kaw kheh lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zisu le a hningzuitu sahlo cawh Sisaria Filipi a kaekang letei khuatei sahlo lang cawh a sei he. Aa seilaining taco, a hningzuitu sahlo khah, “Cawngsaw tah aho aa pa tah maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A hningzuitu sahlo tah, “Thaikhehpaw tah baptisma peitu Johan a cang aa ca tah, thaikhehpaw tah Elija a cang ca tah he ka, ahringpaw taco Khazing khuavang pakheh kheh cawh a cang aa ca tah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zisu tah, “Naaning tah saw aho a cang naa pa tah maw?” tatah a hae he. Piter tah, “Nama cawh Khri cawh na cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Zisu tah Ama a kong khah ahohmai ching khe lo tatah raeringnah a peh he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Taico, Cawngsaw Sawcapaw tah taithuinah a hlupui ing ka, macang sahlo le tlangbui macang sahlo le phungbia cawngpahtu sahlo tah hlawh a he ka, aa thaw a. Canghrasala ningthung khy tah a tho kaw a, tatah cawngpah hrang a patho he. ");
INSERT INTO zypNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma bia cawh a sepaw teitah Zisu tah a ching he. Taico, Piter taco a cakih lang seikhui ka, a mochia. ");
INSERT INTO zypNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Canghrasala Zisu cawh a paleh ka, a hningzuitu sahlo khah ming he ka, Piter cawh a raw. “Setan, kama tai hei seihly! Khazing lang hming pacang ly ceh tah cawngsaw lang hming na pacang vy hri hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Taico Zisu tah a hningzuitu le zawpui cawh Ama khatah y he ka, “Ahohmai zui a pa dupaw cawh ama a dunah khah seisai seh la, a khraws cawh a puh seh la, pazui seh. ");
INSERT INTO zypNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Zecawtamaw tatah a hringnah pachah a dupaw taco hly a ka, canghrasala, Kama le thawngchawbia rawng tah a hringnah a hlypaw taco a pachah a. ");
INSERT INTO zypNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cawngsaw pakheh tah khazaw heh a pungpaluh tah hnui seh la, a thlawpaw a sung caco zemaw a cawtah a chahnai a? ");
INSERT INTO zypNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Cawngsaw tah a thlawpaw khah hmuh kaw pawtah zemaw a peh khypaw a ung? ");
INSERT INTO zypNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Atochai a pheinah chai le, suanah chai lehei Kama le ka bia a zawkhuipaw maikaw cawh Cawngsaw Sawcapaw tah a Paw rungnawnah le a vaiming pathai sahlo khatah a za cung tihtah a zawkhui hra he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mataico, aaning cawh, “Biahmuisui ka ca ching he, ma lehei a daw thlangpaw sahlo hrong lehei Khazing painah raang cawh hmingtuakhynah khatah a va tlungpaw aa hmuh hlai taco mehthaikheh cawh thi balang bei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Taico, ningruh khy tah Piter le Jeims le Johan cawh Zisu tah tlaang sangpaw lang a kekhui he. Ma leco aaning teitah aa ungning tah Zisu cawh aa hmekaw leco a hmuisang cawh a thlai. ");
INSERT INTO zypNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A chaichi cawh raang ngetei ka, a khaipaleh he. Cawngsaw tei aa rangsah khypaw navy tah a rang vy syly he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aa hmekaw leco Elija le Moses cawh a va lang he ka, Zisu khatah bia aa rei hrui leimei. ");
INSERT INTO zypNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piter taco Zisu cawh, “Cawngpahtu, ma lehei ung heh kaa cawtah a chah ngetei. Thlangda nama na cawtah sangkheh, Moses cawtah sangkheh, Elija cawtah sangkheh tatah sangthung sah a he peh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aa ci tu cawtah zemaw ka rei a tahpaw hmai hnih be. ");
INSERT INTO zypNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Taico aa cung letah meding cawh va thang ka, aaning cawh pahlong he ka, meding chung taico, “Ma heh ka dopaw ka Sawcapaw a cang, a bia nge my lo!” tatah o a za ring. ");
INSERT INTO zypNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aa kaekang cawh a hui tlamang he ka, Zisu tah cy ly co ahohmai hmuh bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tlaang cung taitah aa za cungthlah ning takhei Zisu tah, “Cawngsaw Sawcapaw heh thihnah taitah a tho kaw hlai vytei cawh naa hmuhpaw khah ahohmai ching khe lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma kong khah aa lung chung letah a cingkai thlang he ka, canghrasala aaning le aaning cawh, “Thihnah taitah tho kaw, a tahpaw heh ze silang maw a cang?” takhah aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Taico Zisu cawh, “Zecawtamaw phungbia cawngpahtu sahlo tah Mesiah hlai tah Elija a vong taw hrahring a, aa tah?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zisu tah, “Elija cawh a vong taw hmuisui ka, zezongpui khah a parai pacia thlu. A cang caco, zecawtamaw Cawngsaw Sawcapaw cawh a sah pui tah tai-ing a ka, hlawh a cang a tatah Capathai letah cia a cang? ");
INSERT INTO zypNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Canghrasala, ka ca ching he, Elija cawh a vong thah ka, Capathai letah ciapaw tei hrakhei aa dudú khei ama cawh aa tua thah,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A hningzuitu ahringpaw sahlo aa kung aa va phah tihtah cawngsaw hlupui tah za pahlong thlang he katei, phungbia cawngpahtu thaikhehpaw sahlo khatah bia a za ei leimeipaw he khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zawpui takhei Zisu aa hmuh cangkawleh aa khuarawha ka, va saihno he ka, aa va dai. ");
INSERT INTO zypNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zisu tah, “Aaning sahlo khatah ze kong maw na ei leimei he ceh?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Zawpui hrong taitah pakhehpaw tah, “Cawngpahtu, ka sawcapaw cawh khachia tah a tle cawtah a rei zong thlaw khy be ca ka, nama khatah ka va seikhui. ");
INSERT INTO zypNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Khachia tah a chuahno ning maikaw leh alui letah a va chai. A ci tatabu chuh ka, a haw ria ka, a hruipaking tei. Na hningzuitu sahlo heh khachia papia pá pawtah naw he neh ka, canghrasala papia khy bei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Taico Zisu tah, “Vy zingnah a hnui lypaw cawngsaw sahlo, ze tih tai maw naaning khatah ka ung a? Ze tih tai maw ka lung ka ca pasua pá he a? Nyhehpaw cawh a vong khui tua o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Taico nyhehpaw cawh a vong khui he. Khachia tah Zisu khah a hmuh cangkawleh nyhehpaw cawh alui letah phongchai ka, ama le ama hmai a hni lytah a paleh a pathae ka, a ci tatabu zong a chuh thlu. ");
INSERT INTO zypNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zisu tah, “Ma hratei a ungpaw heh zekhah cai maw a tah?” tatah nyhehpaw a paw khah hae ka, “A nyheh teitah,” tatah a paw taco a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Taico a paw taco, “Me chunglang bo ka, tui chunglang zong thlah ka, uihlupui a thaw daimang tei. Na tua khy caco, ning ma do la, ma baw ky law,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zisu taco, “Na tua khy caco na tah maw? Zingnah a hnuipaw caw taco zezong tua khy a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma cangkaw leco, a paw cawh, “Ka zing hmuisui, ka zing vy nápaw cawtah pa baw ky law,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zawpui tah aaning lang a va ne vy leimeipaw he khah a hmuh tihtah Zisu tah thlawpaw pialuipaw cawh a hrangso ka, “Nama, a naw a pangpaw le a rei a thlaw thai lypaw thlawpaw, nyhehpaw chung taikhei piathlah la, zening tahmai a nae kaw khawh kheh tatah bia ka ca peh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Khachia cawh ka sang ka, nyhehpaw khah a sah pui tah cathing si ka, a chung taico a piathlah. Nyhehpaw cawh mehthi rawh lo ka, macawtaco cawngsaw vytei tah, “A thi thah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Canghrasala, Zisu tah a bang tah tle ka, patho ka, a ka daw. ");
INSERT INTO zypNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Taico Zisu cawh ing chunglang a nae khy taitah a hningzuitu sahlo tah, “Zecawtamaw kaaning tah kaa papia khy be?” tatah aparuh teitah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Zisu taco, “Ma hapaw hming heh cawh thlawchangnah tah cy ly co zetahmai papia khy cang be,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ma hminghmaw taico Zisu le a hningzuitu sahlo cawh piathlah he ka, Galili raang cahrong pai tah aa sei. Zisu tah zeletamaw aa ung tahpaw khah ahohmai hnisah du bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Zecawtamaw tatah a hningzuitu sahlo khah a cawngpah leimei ning he cawtah a cang. Aaning cawh, “Cawngsaw Sawcapaw heh cawngsaw sahlo kih letah luithae a cang myca a. Aaning sahlo taco aa thaw a, taico ning thung khy letah a tho kaw a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Canghrasala a rei dupaw khah aa hni ly naná teitah Ama khah hae hri ngang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapernaum khua khah va phah he ka, ing chunglang a nae ka, a hningzuitu sahlo cawh, “Langpui lekhei zemaw na ei lai leimei he ceh?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Canghrasala palei bei he. Zecawtamaw tatah langpui letei a ei laipaw he cawh kaaning hrong lehei ahomaw alai caipaw a cang a takhah a cangnah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zisu cawh a ty ka, a hningzuitu hluihning khah y he ka, “Ahohmai alaicaipaw cang a dupaw cawh a nytaw caipaw tah a tua seh la, ming maikaw raihretu tah a tua seh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nyhehpaw cawh law ka, aa hrong letah a dawsah. Pawng ka, aa hai letah, ");
INSERT INTO zypNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ahohmai kama ka ming tah ma hapaw nyhehtei heh a cyhlangpaw cawh kama a pa cyhlangpaw a cang. Ahotahmai kama a pa cyhlangpaw cawh a pa tawtupaw a cyhlangpaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johan taco, “Cawngpahtu, cawngsaw pakheh tah na ming tah khachia a papia leimeipaw hmuh he peh ka, kaa bu cawngsaw a cang lynah cawtah tua kheh law tatah kaa thly,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Zisu taco, “Thly khe o, ka ming tah ningang chuipaw hming a tuapaw taco, a tua khy taikhei co a ry hlai leco pa reipachia a beh. ");
INSERT INTO zypNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ahohmai a ma cakhae lypaw maikaw cawh kaa cawngsaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Biahmuisui ka ca ching he, ahohmai, Khri tei naa cangnah cawtah ka ming tah tui cakaw ny kheh tei hmai a ca peipaw he cawh aa longmai cawh hmuh lytah ung hrahring a bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Taico pakheh kheh tah Kama a pa zingpaw nyhehtei pakheh khah a suasah caco a hirong letah sangrianah lung pathle tah rili chunglang thlah he seh la, a cawtah a chah vy a. ");
INSERT INTO zypNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na kih tah a ca suasah caco, taichung la, vathlang. Kih rahning tah a de thai lypaw hraihming me lang tlah navy co, kih hnui ly tei chaizaw hringnah chunglang a nae cawh na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na phe tah a ca suasah caco, taichung la, vathlang. Phe rahning chi tei hraihming chunglang tlah navy co, phe lytah chaizaw hringnah chunglang a nae cawh na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mataico na meh tah a ca suasah caco, khy hly thlang. Meh rahning chitah hraihming lang tlah navy co Khazing painah raang chunglang meh rakheh khatah a nae khah na cawtah a chah vy. ");
INSERT INTO zypNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hraihming chung leco, ‘Salung zong thi be ca he ka, me zong de beh.’ ");
INSERT INTO zypNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Cawngsaw maikaw cawh me khei paci hratah aesah a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Paci cawh a chah, canghrasala a aenah a ly caco, zekhatamaw na aesah khy khaw a? Paci hratah ae la, pakheh le pakheh a dorai teitah ung my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma khy taico Zisu cawh ma hminghmaw taico piathlah ka, Judia raang le Jordan tuivaw rae lang khah a sei. Ma leco cawngsaw hlupui cawh Ama khatah a vong hui he ka, a tua teipaw hratah aaning cawh a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ama khah pase du tah Farasi thaikheh sahlo cawh Ama khatah a vong he. A hai letah, “Capaw tah nupui mah heh a phung a cang maw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ama taco, “Moses tah zekhatamaw phungbia a ca peh he?” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aaning taco, “Moses tei bia a mah pehpaw cawh capaw tah a nupui cawh mahnah ca a ciapah caco, a mah khy thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Taico Zisu tah, “Moses tei ma phungbia a ca cia pahpaw he cawh naa lung a khong tunah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Canghrasala, a hrangthoning taco, ‘Khazing tah canu le capaw tatah a tua he.’ ");
INSERT INTO zypNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ma rawng taco capaw tah a no le a paw khah seisai a he ka, a nupui khatah a pahlawng a ka, ");
INSERT INTO zypNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma tlaw pahning cawh ngaisaw pungkheh tah aa cang a.’ Macawtaco aaning cawh pahning cang khawh bei he, pakheh a cang myca he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Macawtaco, Khazing tei a patongpaw he cawh cawngsaw tah pachai kheh he seh,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ing chunglang a nae kaw khy tai he tah a hningzuitu sahlo tah ma kong khah Zisu aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Zisu tah, “A nupui mah katei, ahringpaw canu a chuipaw cawh a nupui khah a pheisaipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma hraco canu tah a pasae khah kawsai tah capaw ahringpaw khatah a pahlawng caco, a pasae a pheisaipaw a cang hrah,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Taico, Zisu tah tong he seh la, bonghnang song he seh tah du tah nyhehtei sahlo khah va chua khui he ka, canghrasala, a hningzuitu sahlo tah aa raw he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zisu tah ma cawh a hmuh tihtah a thingae ka, aa hai letah, “Nyheh sahlo cawh kama khatah a vong he seh, pakhang khe o. Zecawtamaw tatah Khazing painah raang cawh ma hapaw sahlo aa tei khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Biahmuisui ka ca ching he, Khazing painah raang cawh nyheh hratei a cyhlang lypaw taco a chung lang a nae by a be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Taico nyhehtei sahlo cawh aa bang tah tle he ka, aa cung letah a kih pahnia ka, bonghnang a song he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zisu cawh khuatlong pawtah a tho ning takhei cawngsaw pakheh va sai ka, a hmekung letah a khuh a panai. “Cawngpahtu chaw, chaizaw hringnah ka hmuh khy nápawtah zemaw ka tua a?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Zisu taco, “Zecawtamaw a chawpaw na pa tah? Khazing tah cy ly co ahohmai a chawpaw ung bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Biapeh sahlo cawh na hni thlang. ‘Lenong kheh, a phei kheh, ru kheh, ahmang lypaw bia hnikhuitu cang kheh, dungkhei hmang kheh, na no le na paw cizaw my lo,’ tahpaw sahlo a cang he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma satlepaw taco, “Cawngpahtu, ma hming vytei heh cawh ka nyheh ning taitah ka zui ciapaw longtei a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zisu tah ama cawh ming ka, a cung letah donah a hnui. “Hming sangkheh na by. Va sei la, na hnuipaw vytei va zua la, mehsisah khah tangka va pei la, vaicung letah chosung na hnui a, taico a vong la, pa zui,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma bia cawh a thui tihtah satlepaw cawh a hme a chia. Ama cawh mehrung a cangnah cawtah a ngechia hmotah a sei hly. ");
INSERT INTO zypNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zisu tah a kaekang leco ming ka, a hningzuitu sahlo hai letah, “Mehrung cai taco Khazing painah raang letah a nae heh a ru caimang!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A hningzuitu sahlo tah ma bia cawh aa thui tihtah aa khuarawh a haa ngetei. Canghrasala Zisu tah, “Ka sawtei sahlo, Khazing painah raang letei a nae heh a ru caimang! ");
INSERT INTO zypNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mehrung tei Khazing painah raang letah a nae navy co ceiphing kho letah sahisy a nae heh a neh vy a,” tatah a tah vy he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A hningzuitu sahlo taco, aa ningang hmotah, “A cang caco, ahomaw pachah a cang khy a?” tatah aaning le aaning a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zisu tah aaning cawh ming he ka, “Ma hming heh cawngsaw caw taco cang khy be, canghrasala, Khazing caw taco a cang khy lypaw zehmai ung be,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piter tah Zisu cawh, “Kaaning taco zezongpui seisai tah kaa ca zui hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zisu tah, “Biahmuisui ka ca ching he, kama ka rawng tah le, thawngchawbia rawng tah a ing maw, a uny sahlo maw, a satei sahlo maw, a no maw, a paw maw, a sawtei sahlo maw, a ly sahlo maw, a seisaipaw maikaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ato hringchung cai lehei a leh zakheh tah aa hmuh a. Ing sahlo, uny sahlo, satei sahlo, no sahlo, sawtei sahlo le, ly sahlo khahei hrehnah zong khah aa hmuh a. Mataico a va chuh lepaw cai letah chaizaw hringnah zong aa ting a. ");
INSERT INTO zypNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Canghrasala, a hme a sahpaw mehlupui cawh hningkha he ka, a hningkhapaw cawh hme aa sah tae a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalem khuapui lang cawh seichy he ka, Zisu tah langhme a chuilai he. A hningzuitu pahrawhluihning sahlo cawh aa khuarawha ka, ahringpaw a zuipaw sahlo zong taco aa ci. A hningzuitu pahrawhluihning cawh aaning teitah Zisu tah seihly khui he ka, a cung letei a va tlung lepaw khah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Zisu tah, “Atoheh Jerusalem khuapui lang sei he peh ka, Cawngsaw Sawcapaw heh tlangbui macang sahlo le phungbia cawngpahtu sahlo khatah luithae a cang a. Aaning sahlo taco thaw pawtah thaily cangsah a he ka, Gental cawngsaw sahlo kih letah peh a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma sahlo taco pasipasa he ka, aa ci tah chawh a he ka, basung tah chei a he ka, aa thaw a. Ningthung khy taitah a tho kaw a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Taico, Zebedi sawcapaw leh Jeims le Johan cawh Zisu khatah a vong he. A hai leco, “Cawngpahtu, kaa ca haepaw maikaw ma tuapah law tah kaa du,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zisu taco, “Naa cawtah ze hming maw ma tuapah seh tah naa du?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aaning taco, “Na painah a rungnawpaw letah na cacang lang pakheh, na cavui lang pakheh a ma tysah la, tah kaa du,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zisu taco, “Naa haepaw heh hnih thai bei he ceh. Ka ding lepaw tai-ingnah ny heh naa ding khy a maw? Thihnah baptisma ka ing ruapaw zong naa ing khy a maw?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aaning taco, “Kaa ding khy a,” tatah aa chai. Zisu taco, “Ka ding ruapaw tai-ingnah ny zong ding he ceh ka, ka ing ruapaw thihnah baptisma zong naa ing a. ");
INSERT INTO zypNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Canghrasala, ka cacang lang le ka cavui lang tah a tynah naw cawh kama ka rei cang be. Ma hming sahlo cawh Khazing tei a pachia pahpaw sahlo aa cawtah a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma bia cawh a hningzuitu ahringpaw pahraw tah aa thui tihtah Jeims le Johan aa cung leco aa thing a ae ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Taico, Zisu tah hmingkheh tah y he ka, “Gental cawngsaw sahlo uhtu bui a cangpaw sahlo taco aa rai leteipaw sahlo cung letah abui tah a bui so he ka, builai sahlo cawh aa cung letah naw aa hnui ngetei tahpaw khah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Naaning sahlo cawh ma hraco naa cang ruapaw cang be. Ma navy co, naaning hrong lehei mehlai cang a dupaw taco, naa raihretu tah a tua seh la, ");
INSERT INTO zypNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","a pakhehnah cang a dupaw taco, cawngsaw maikaw sae tah a tuapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cawngsaw Sawcapaw heh a rai hrepá pawtah cang lytah male rai hre rua pawtah le mehlupui tlang ruapaw cawtah a hringnah peh rua pawtah a vongpaw hrahei,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mataico Jeriko khua aa va phah. Zisu le a hningzuitu sahlo le ming rungpui cawh Jeriko khua taitah aa piathlah ning takhei, Timai a sawteipaw Bartimai, mehcopaw cawh kih do pawtah langpui kae letah a ty thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Taico Nazaret Zisu a cang tahpaw a thui cangkawleh, “David Pathlah, Zisu, ning pa do ky law!” tatah a thangpui tah a y. ");
INSERT INTO zypNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cawngsaw hlupui tah raw he ka, de teitah ung thlang aa tah. Canghrasala, “David Pathlah, ning pa do ky law!” tatah a thang vy tah a y. ");
INSERT INTO zypNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zisu cawh a daw ka, “Va y tua o,” tatah a tah he. Taico mehcopaw cawh va y he ka, “Na thawchah seh, a daw! Ama tah a ca y,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A angkilai cawh vathlang ka, a catho ka, Zisu khaco a va sei. ");
INSERT INTO zypNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zisu taco, “Na cawtah ze tuapah maw na du?” tatah a hae. Mehcopaw taco, “Cawngpahtu, khuahmuh khy ka du,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zisu taco, “Sei myca, na zingnah tah a ca dangsah thah,” tatah a tah. Ma cangkaw leco khuahmuh ka, Zisu a seinah lang khah a zui. ");
INSERT INTO zypNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem lang a va nae myca he ka, Oliv tlaang letah a ungpaw Bethfes le Bethani khua aa phah tihtah Zisu tah a hningzuitu pahning khah a seisah hlang he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Aa hai letah, “Naa hme khua lekhei va seí la, khuachung naa nae cangkawleh he ceh ahotahmai aa ke bang lypaw la teitei a hrai thlangpaw khah naa hmuh a. A rui khah thlang he ceh ka, ma lang heh naa va hrui a. ");
INSERT INTO zypNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pakheh kheh tah, ‘Ze rua tamaw ma hrakhei naa tua?’ aa ca tah caco he, ‘Abuipaw tah a hia, ma lehei a va chia kaw palang a,’ tatah tah my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mataico va seí he ka, langpui kae letei ing a hawkaw tung letei aa hrai thlangpaw, la teitei cawh aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","A rui aa thlang ning takhei aa kae letei a dawpaw sahlo tah hmuh he ka, “Zemaw la teitei rui khah naa thlang?” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Zisu tei a chingpaw he hrakhei chai he ka, cawngsaw sahlo taco seikhui thlang o, aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","La teitei cawh Zisu kung va tlung khui he ka, a cung letah aa pai sahlo dae he ka, Zisu tah a ke. ");
INSERT INTO zypNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Taico cawngsaw hlupui tah langpui leco aa pai sahlo phaw he ka, mehthaikheh cawh lyraang letei chingbu khah va chaw he ka, aa phaw pah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mataico, a hmelang tei a seipaw sahlo le, a hninglang tah a zuipaw sahlo taco, “Hosana! Abuipaw ming tei a vongpaw cawh bonghnang song tah ung ky seh. ");
INSERT INTO zypNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kaa mapaw, David painah raang, a va tlung leimeipaw cawh bonghnang song tah ung ky seh. Hosana! A sangcainah vaicung lekhei Khazing cawh reithai tah ung ky seh.” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zisu cawh Jerusalem khuapui lang a nae ka, behnah ing lang khah a va seí. Zezongpui khah ming ka, canghrasala zailang a cang thah cawtah piathlah kaw ka, a hningzuitu pahrawhluihning khakhei Bethani khua lang aa sei kaw. ");
INSERT INTO zypNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A ningthlamongpaw cawh Bethani khua taitah aa piathlah ning takhei Zisu cawh a ngai a di. ");
INSERT INTO zypNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Langpa tah thuiku kung a bu a chaw ngeteipaw khah va hmuh ka, a thui ung maw tahpaw ming pawtah a va seihno. Canghrasala a va phah tih taco, a thui tih cai a cang lynah cawtah a hnaw tah cy ly co zehmai hmuh be. ");
INSERT INTO zypNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mataico thuiku kung khah, “Ahotahmai tah na thui ca e khawh kheh he seh,” tatah a tah. Ma bia a reipaw cawh a hningzuitu sahlo zong tah aa thui. ");
INSERT INTO zypNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Zisu cawh Jerusalem khuapui a va phah tihtah behnah ingdung chunglang khah a va nae. Behnah ing letei hming a zuapaw sahlo le a copaw sahlo khah tingchua thlu he ka, tangka a thlaipaw sahlo aa cabuai le thury a zuapaw sahlo aa dyching sahlo khah a palehly thlu he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Zua ruapaw hming khah behnah ingdung cahrong tah tlelai khah ahohmai sai bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Taico aaning sahlo a cawngpah ning he tah a reipaw cawh, “Capathai letah ma hrahei cia cang bei maw? ‘Ka ing cawh mingphing vytei cawtah thlawchangnah ing tatah aa tah a.’ Canghrasala naaning taco, ‘Mehru kua,’ tah naa tua,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tlangbui macang sahlo le phungbia cawngpahtu sahlo taco ma bia cawh thui he ka, Ama khah thaw khy nápaw langpui hui hrang aa patho. A cawngpahnah takhei ming zawpui aa lung khah tong tu ka, macawtaco Ama khah aa ci. ");
INSERT INTO zypNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zailang a va chua tihtah Zisu le a hningzuitu sahlo cawh khuapui chung taikhei a piathlah he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A ningthlamongpaw mongdi tah aa seipai khei thuiku kung cawh a hrang tai a ro thahpaw khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piter tah a thui thlang cawtah Zisu hai leco, “Cawngpahtu, mingtua, chia na sahpaw thuiku kung kheh a ro thlu thah khi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Zisu tah, “Khazing khah zing my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Biahmuisui ka ca ching he. Pakheh kheh tah ma tlaang heh, ‘Sei la, rili chung lang a va thlah,’ tah seh la, lung langlo tah ung lytah a reipaw khah a zing caco, ma hraco tuapah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Macawtaco ka ca ching he, thlawchang tah naa haepaw khah kaa hmuh thah tatah naa zing caco, ma cawh peh na cang a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mataico, thlawchang tah na daw tihtah na cung letei hmingchahly aa tuapaw maikaw khah ngethai la, ma pawsui co vaicung letei a ungpaw na Paw Khazing tah na suanah vytei khah a ca ngethai hrah a. ");
INSERT INTO zypNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Canghrasala, cawngsaw hringpaw suanah khah na ngethai ly caco, vaicung letei na Paw Khazing tah na suanah khah ca ngethai hrah a be,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalem lang khah va tlung kaw he ka, Zisu cawh behnah ingdung chung letei a khiakaly ning tah tlangbui macang sahlo le phungbia cawngpahtu sahlo le macang sahlo khah Ama khatah a vong he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aaning taco, “Ze nawhnuiná tamaw ma hming sahlo heh na tua? Ahomaw ma hming sahlo heh tua pawtah nawhnuinah a ca pei?” tatah aa hae hri. ");
INSERT INTO zypNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Zisu tah, “Bia sangkheh ka ca hae tua hrá he a. Pa palei la, ma hming sahlo heh zehapaw nawhnuinah tamaw ka tua tahpaw ka ca ching hrá he a. ");
INSERT INTO zypNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johan tah baptisma cangsahnah naw a hnuipaw khah vaicung taitah maw, cawngsaw taitah maw? Pa ching tua o,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Reisia he ka, “Vaicung taitah tah my peh seh la, ‘A cang caco zecawtamaw Johan cawh naa zing be?’ a ma tah a. ");
INSERT INTO zypNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Canghrasala, ‘Cawngsaw taitah,’ kaa tah a maw?” tatah aa reisia. Aaning tah zawpui khah aa ci he, zemaw tah pawco cawngsaw maikaw tah Johan cawh Khazing khuavang hmuisui a cang tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Macawtaco Zisu khatah, “Hnih bei peh,” tatah aa tah. Zisu tah, “Kama zong tah ma hming sahlo heh zehapaw nawhnuiná tamaw ka tua tahpaw ca ching hra bei neh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Taico Zisu tah tawchingnah bia tah a ching he. “Cawngsawpaw pakheh tah misur buichung a tua. A buichung cawh ruahy sahkhai ka, misur so nápaw kho zong co ka, a haw nápaw siasang zong a do thah. Mataico misur buichung cawh male khah hlei he ka, khuatlongnah lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hre cai a cang tih taco a sae pakheh khah ama a tinghangpaw pakhong paw takhei ly a hlangpaw sahlo khaco a taw. ");
INSERT INTO zypNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Canghrasala aaning taco ama cawh tle he ka, dai he ka, kih longpaw tah aa kawsah kaw. ");
INSERT INTO zypNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Taico, a sae hringpaw taw kaw ka, ma cawngsawpaw cawh a lu letah phong he ka, ningzaw chuipaw tah aa tua. ");
INSERT INTO zypNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A sae hringpaw taw kaw hui ka, ama zong cawh aa thaw. Ahringpaw sae sahlo khah a hlu vy tah taw he ka, thaikhehpaw cawh dai he ka, thaikhehpaw cawh aa thaw he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Taw ruapaw pakheh suipaw a hnui myca. Ma cawh a dopaw, a sawcapaw khah a cang. ‘Ka sawcapaw cawh aa cizaw a,’ tah ka, a changnah leco a sawcapaw cawh a taw. ");
INSERT INTO zypNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Canghrasala, ly a hlangpaw sahlo taco, ‘Ma cawngsaw heh ry cytu a cang. A vong la, thae he peh, taico a ry heh kaa cawtah cang ná seh,’ tatah pakheh le pakheh aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Taico, ama cawh tle he ka, aa thaw khy taitah misur buichung alailang khah aa vathlang. ");
INSERT INTO zypNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma tih taco misur buichung a hnuitupaw takhei zemaw a tua a? Va seí ka, ly a hlangpaw sahlo khah thé he ka, misur buichung khah ahringpaw khah a hlei he a. ");
INSERT INTO zypNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Capathai letah rei bang bei he ceh maw? ‘Ing a sahtu sahlo tei aa hlawhpaw alung cawh a biapui caipaw alung tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Abuipaw tah ma heh a tuapaw cang ka, kaa mehmuh letah khuarawha a chuipaw a cang,’ a tahpaw khasaw,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Taico, Juda hotu sahlo taco Ama tle nápaw langpui khah aa hui, zecawtamaw tatah tawchingnah bia a reipaw cawh aaning a rei hnopaw he a cang takhah aa hni. Canghrasala zawpui khah aa cinah caw he tah Ama cawh aa seisai kaw. ");
INSERT INTO zypNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma khy taico, Ama a bia khei Zisu khah tle pawtah Farasi sahlo le Herod a hningzuitu mehthaikheh khah aa taw he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Zisu khaco a vong he ka, “Cawngpahtu, nama cawh zingchuipaw na cangpaw kaa hni. Cawngsaw tah miamang khypaw cang bei ceh, zecawtamaw tatah cawngsaw hme ming bei ceh. Canghrasala Khazing langpui khah biahmuisui a cang naning teitah na cawngpah tei he. Siangpahrang Sizar letah ngungkhui peh heh ahmang maw hmang ly? ");
INSERT INTO zypNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kaa pé maw, pé ly?” tatah aa hae. Canghrasala Zisu tah cungmai raipha aa cangpaw khah a hmuh tihtah, “Zecawtamaw o na pa pachia he ceh? Denari tangka cawh va tle la, pa mingsah tua o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tangka cawh va tle he ka, “Aho lingthlaw maw a cawng? Aho cakhai maw a cia?” tatah aaning sahlo cawh a hae he. Aaning tah, “Sizar,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Taico Zisu tah aa hai letah, “Sizar a tei cawh Sizar khah pei la, Khazing a tei cawh Khazing pei my lo,” tah he ka, aaning sahlo cawh aa ning aa ang ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma khy taico, thokawnah ung be a tahpaw Sadusi sahlo cawh Zisu khatah a vong he ka, bia aa hae hri. ");
INSERT INTO zypNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Cawngpahtu, Moses phungbia letah cawngsawpaw cawh sawtei sah lytah a nupui khah a thih sai caco, a unypaw takhei lahmeno cawh nupui tah chui kaw seh la, a thipaw caw takhei sawtei sahlo a sah pápaw a cang a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uikheh cawh uny pasarih ung he ka, a uthui caipaw tah nupui chui ka, sawtei sah lytah a thi. ");
INSERT INTO zypNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A pahningnahpaw tah ma lahmeno cawh chui kaw ka, canghrasala sawtei sah lytah a thih sai hrah. A pathungnahpaw zong ma hraco a cang hrah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aa pasarih co cawngsawno cawh chui he ka, sawtei sah lytah a thi he. A hning cai tah ma canuno zong cawh a thi hrah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Macawtaco thokawnah letah ma canuno cawh aho a nupui maw a cang a? Aa pasarih tah ma canuno khah aa chui tlung,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zisu taco, “Naa rawh sua ngetei, Capathai a cang ly le Khazing hmingtuakhynah naa hnilynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aa thipaw aa tho kaw tih taco, a chuihae cawh ung khawh a be. Vaicung letei vaiming hratah aa cang tae he a. ");
INSERT INTO zypNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mehthi sahlo thokawnah kong leco Moses cabu letei chingbu me tah a kangpaw kong lekhei Khazing tah, ‘Kama cawh Abraham Khazing, Isak Khazing, Jakob Khazing ka cang,’ tatah a tahpaw khah rei bang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ama cawh mehthi aa Khazing cang be, canghrasala mehring aa Khazing a cang hri. Naa rawh sua caimang!” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Phungbia cawngpahtu pakheh a vong ka, ma hratei bia a ei leimeipaw he khah a thui. Zisu tah achaw teitah a palei he tahpaw khah a hmuh tihtah, “Biapeh vytei hrong lehei zehapaw maw a biapui cai?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zisu tah, “Biapeh a biapui caipaw cawh ma heh a cang, ‘Israel cawngsaw sahlo nawthlia tua o. Abuipaw suipaw heh Khazing cang ka, Khazing ahringpaw ung bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Abuipaw na Khazing khah na lungthing vytei, na hringnah vytei, na khuarawnah vytei, na thawzaang vytei tah do my lo.’ ");
INSERT INTO zypNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Taico a sanghningnah cawh, ‘Nama na dopaw hratah na ingpaw khah do my lo,’ tah a cang. Ma sanghning navy hei alai vypaw biapeh ung be,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Phungbia cawngpahtu tah, “Cawngpahtu, a chah ngetei, Abuipaw suipaw heh Khazing cang ka, Khazing ahringpaw ung bei he na tahpaw heh a hmangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Khazing khah na lungthing vytei, na hnithainah vytei, na thawzaang vytei tah do la, na ingpaw khah nama na dopaw hratah do cawh mero pehlainah vytei le, thuihlainah vytei navy tah biapui vy a cang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zisu tah ma cawngsawpaw tei, singvang ngetei tah bia a paleipaw cawh a hmuh tihtah, “Khazing painah raang khatah a hlah bei ceh,” tatah a tah. Ma khy taico ahotahmai tah bia hae ngang khawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zisu tah behnah ingdung letei a cawngpah ning he takhei, ma bia heh a hae he. “Zecawtamaw phungbia cawngpahtu sahlo tah Khri cawh David pathlah a cang tatah aa tah? ");
INSERT INTO zypNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David tah Thlawpaw Pathai tei a reipaw cawh, ‘Abuipaw tah ka Buipaw cawh, na carae sahlo khah na phe rai letah ka chia hlai vytei he cawh ka cacang lang letah a ty my lo a tah,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David ama ceingei tah, ‘Abuipaw,’ a tah tlung, zekhatamaw Khri cawh David sawcapaw a cang thai a?” tatah a tah he. Ming rungpui taco a bia cawh lungtho teitah aa nge thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma hratei Zisu tah a cawngpah ning he takhei, “Phungbia cawngpahtu sahlo khah a raering my lo. Aaning cawh a ngepaw angki pasuapaw a hrei tah chodo tlaang letah a khia lai le cawngsaw tah cizaw hmotah bia a ching khah aa du. ");
INSERT INTO zypNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Synagog letah achaw caipaw dyching letah a ty du he ka, kawngchuanah letah achaw caipaw hminghmaw khah aa du. ");
INSERT INTO zypNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lahme sahlo ing khah chu he ka, zawpui hmuh rua tah a sypui tah thlaw aa chang. Ma sahlo cawh a sah caipaw dangtahnah aa ing tae a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Zisu cawh behnah ing lekhei tholong thingkawng lang a hui khei a ty ka, zawpui vytei tah tholong aa chia leimeipaw khah a ming thlang. A hnuirungpaw mehlupui tah tangka hlupui khah tholong kawng leco aa thlah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Canghrasala mehsisah lahmeno pakheh cawh a vong ka, tholong kawng leco phaesai phaehning, tangka phaekheh mai tluh a cangpaw tei cawh a thlah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Taico Zisu tah a hningzuitu sahlo khah y he ka, “Biahmuisui ka ca ching he, ma mehsisah lahmeno tahei aho navy zong tah a hlu vy tholong a thlah. ");
INSERT INTO zypNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ahringpaw cawh aa hnuipaw a hluipaipaw chung taikhei aa peh. Canghrasala ma lahmeno heh cawh a dongchia hmotah a hringnah cawtei a hnuipaw vytei a peh thlu hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Taico Zisu cawh behnah ing taitah a piathlah ning takhei, a hningzuitu pakheh tah, “Cawngpahtu, mingtua hmai! Alung sahlo aa lai zia kheh! Ing sahlo aa rungnaw zia kheh!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zisu taco, “Ma ing rungnawpaw vytei heh na hmuh maw? Alung phaekheh hmai heh palehly lypaw ung a be, a zongmingtei tah palehly thlu a cang tae he a,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zisu cawh behnah ing raechai tlaang, Oliv tlaang cung letah a ty thlang ning takhei, Piter le Jeims le Johan le Andru takhei Ama khah, ");
INSERT INTO zypNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ma hming sahlo cawh zening tamaw a cang a? Taico, zehapaw paching pakhanah maw a ung a tahpaw ma ching tua?” tatah a paruh teitah aa hae hri. ");
INSERT INTO zypNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zisu taco aa hai letah, “Ahotahmai aa ca dungkhei ly nápaw he tah a raering my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ka ming tah cawngsaw hlupui va chua he ka, ‘Kama heh Ama cawh ka cang,’ tah a he ka, cawngsaw hlupui khah aa dungkhei he a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Rae a dypaw he le rae thongpang naa thui tihtah a pahly khe lo. Ma hming sahlo cawh a ung hrahringpaw a cang he. Canghrasala, a changnah cang balang be. ");
INSERT INTO zypNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Raang kheh le raang kheh a dy a he ka, painah le painah a dy he a. Hming hlupui letah aling a hrui a ka, cakaang a tlung a. Ma vytei heh canu ny ung risaw hrang a pathonah hratah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Achaw teitah a raering my lo. Ca tle a he ka, biacenah letah aa ca chuakhui tae he a. Synagog letah zong aa ca chei he a. Uhtu bui sahlo le siangpahrang sahlo hme letah bia hnihtu cang pawtah kama ka rawng tah na daw tae a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Canghrasala ma hming sahlo a cang hlai tahei thawngchawbia heh mingphing vytei khatah rei taw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ca tle a he ka, biacenah hme letah aa ca chuakhui tih he tah ze bia maw kaa rei a tahpaw pacang tah naa thlawzawng kheh seh. A cai a phah tihtah rei ruapaw cawh peh cang tae he ceh ka, ma cawh rei thlang my lo. Zecawtamaw tatah ma bia a reipaw cawh naaning cang lytah Thlawpaw Pathai khah a cang hri a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uny le uny, paw le saw sahlo cawh thihnah tai a luithae he a. Sawtei leh tah no le paw khah thihnah tai aa dy he a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kama ka rawng tah ming vytei tah aa ca hua he a, canghrasala, a changnah tai zingnah letah cy ky tah a dawpaw cawngsaw cawh pachah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Rorangnah a chua khuipaw pasih padawh chuipaw,’ cawh hming pathai letah a daw thlangpaw khah naa hmuh tihtah a reitu tah a silang hnih he seh. Judia raang letei a ungpaw cawngsaw sahlo cawh tlaang cung lang sai he seh. ");
INSERT INTO zypNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ing cung letei a ungpaw cawh hmingbo lá pawtah ing chunglang a nae kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ly letei a ungpaw cawh a angkilai lá pawtah a ing lang tlung hrah kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma ningcai cawh sawtei a phopaw canu sahlo le nysai a tlepaw no sahlo aa caw taco zetlua tamaw ningping a chui a! ");
INSERT INTO zypNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ma hming sahlo heh thlasih chung tah a cang ly nápawtah thlawchang my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Zecawtamaw tatah Khazing tah khazaw a tua thoning taitah atoning tai lehei a ung bang lypaw ningping vaisangnah cai cang tae a ka, ma tluh hapaw cawh ung bang khawh a be. ");
INSERT INTO zypNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma ning sahlo cawh Khazing tah pachingsah lytah ung my seh la, ahringpaw pakheh hmai ung a bei he. Canghrasala a thingpaw a cawngsaw sahlo rawng tah ma ning sahlo cawh a pachingsah a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ma tih taco, pakheh kheh tah, ‘Mingtua, ma lehei Khri a ung,’ a cang ly leh, ‘Ming tua, ma lekhei a ung khi!’ aa ca tah caco he zing khe lo. ");
INSERT INTO zypNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Zemaw tahpaw co Khri pakheipaw sahlo le khuavang pakheipaw sahlo chuh a he ka, a cang khy caco Khazing thingpaw cawngsaw sahlo hmai dungkhei pawtah paching pakhanah sahlo le ningang chuipaw hming sahlo khah aa tua a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Macawtaco a raering my lo, a cai a phah hlai tah zezong ka ca ching pacia he. ");
INSERT INTO zypNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Canghrasala, ma hanah le reithuinah cai khy taico, ‘Ning cawh muisah cang a ka, thlawpaw zong khai khawh a be. ");
INSERT INTO zypNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Esi sahlo zong avai taitah tlah a he ka, avai letei hmingtuakhynah sahlo zong cahneh a cang he a.’ ");
INSERT INTO zypNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ma tih taco, Cawngsaw Sawcapaw cawh hmingtuakhynah le rungnawnah khatah meding hrong letah a vongpaw khah cawngsaw tah aa hmuh tae a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A vaiming sahlo cawh taw he ka, a thingpaw sahlo cawh alui ki kipali taitah le, alui a changnah taitah avai sahlo aa changnah tai khah aa pahmo he a. ");
INSERT INTO zypNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Thuiku kung tai hei cawngpahnah bia heh a ngia my lo. A chawng ka chawng katei, a hnaw pany a ka chuapaw naa hmuh tihtah nipui ning a ne myca tah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma hraco, ma hming vytei heh a cang leimeipaw naa hmuh tihtah cai a nae myca, ingkaw hrang a va phah myca tahpaw khah hnih my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Biahmuisui ka ca ching he, ma hming vytei heh a tlung hlai vytei cawh atochai cawngsaw sahlo heh thi thlu balang bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Alui le avai cawh a rawh a, canghrasala, ka bia cawh a rawh by a be,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Taico a rei vypaw cawh, “A ning le a cai cawh Paw tah cy ly co ahotahmai hnih bei he, vaicung letei vaiming sahlo tahmai hnih bei he, Sawcapaw zong tah hnih hrah be. ");
INSERT INTO zypNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A raering my lo. A mai pacia my lo! Ma cai cawh zening tamaw a cang a tahpaw hnih tlung bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cawngsaw khua a tlawngpaw khatah a lo. A ing khah seisai ka, a sae sahlo khah aa hre ruapaw rai cacy khah a ching si he. Ingkaw a congtupaw khah achaw teitah za vai my lo tatah bia a patai si. ");
INSERT INTO zypNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Macawtaco, a raering my lo, zecawtamaw tatah ing a hnuitu cawh zailang letah maw, zaicing letah maw, aakhawng tamaw, mongdi tamaw, zening tamaw a va kawkaw a takhah hnih tlung bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Rawh ly pui tah a va tlung caco na ihning thlangpaw khah ca hmuh pang le. ");
INSERT INTO zypNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Naaning khatei ka reipaw heh ming vytei khatah ka reipaw a cang. A raering my lo!” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Khungsai Panawnah le Raangri phi lypaw Very Panawnah cawh ninghning suipaw a du tihtah tlangbui macang sahlo le phungbia cawngpahtu sahlo taco Zisu cawh aparuh teitah tle tah thaw nápaw khua khah aa khang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Canghrasala, Khungsaipanaw chung leco cang kheh seh, cawngsaw tah hnahnawhnah aa tua sua a,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zisu cawh Bethani khuapaw, Simon mehthinghmui ing letah batui a e leimei ning takhei canu pakheh a vong ka, lungrang tuithei khei, sathy ringthopaw, a mai a ru ngeteipaw a va tle. Ma sathy ringthopaw cawh nard thingkung taitei lahpaw nard a patahpaw taitah tuapaw a cang. Tuithei cawh khuichy ka, Zisu lu leco sathy cawh a bia. ");
INSERT INTO zypNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma letei a ungpaw mehthaikheh cawh aa thingae ngetei ka, “Zecawtamaw ma tluh a mai a rupaw sathy heh a patlawh a papang? ");
INSERT INTO zypNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mehnung pakheh kung kheh hlo navy tah a hlu vy tahmai zua seh la, ma tangka cawh mehsisah pei he seh la, chah vy bei maw?” aa tah. Taico, canuno cawh a sah pui tah aa raw. ");
INSERT INTO zypNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Zisu tah, “Ama tua tah tua thlang seh, zecawtamaw ama cawh hna naa hnawh? Ka cung letah a tuapaw heh hmingchaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mehsisah cawh naaning khatah ung paria thlang he ka, naa du caco zening tahmai naa bong khy thlang he. Canghrasala kama cawh ung paria bei neh. ");
INSERT INTO zypNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ka pung cung letei sathy a pa biapaw heh a tua khy pawtei khah a tuapaw a cang. Phung ka cang nápaw cawtah a pachia hlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Biahmuisui ka ca ching he, khazaw letah thawngchawbia aa reinah maikaw letah ma cawngsawno tei a tuapaw heh ama monghly lynah tah rei a cang tae hrá a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mataico, a hningzuitu hluihning letei pakheh a cang hrahpaw Judas Iskariot cawh tlangbui macang sahlo khatah Zisu cawh luithae pawtah a va sei. ");
INSERT INTO zypNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma kong cawh aa thui tihtah aa thawchah ngetei ka, tangka kaa ca pae a aa tah. Macawtaco, Judas cawh aaning khatah Zisu a peh khy nápaw he cai chaw khah a bo thlang he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Raangri phi lypaw Very Panawnah ning a hmetawpaw, Khungsai Panawnah Tuu teitei thuihlainah ning leco, a hningzuitu sahlo tah Zisu cawh, “Zeletamaw Khungsai Panawnah zairia enah cawh na cawtah pachia he peh seh la, tah na du?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Macawtaco, a hningzuitu pahning cawh taw he ka, “Khuapui chung a va nae la, beirai tah tui a cuilaipaw capaw pakheh langpui letah naa tong he ceh. Ama cawh zui my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma cawngsaw a naenahpaw ing a hnuitupaw khah, ‘Cawngpahtu tah ka hningzuitu sahlo khatah Khungsai Panawnah zairia kaa e nápaw, ka mehlai khang cawh zeletamaw a ung a tah,’ tatah naa hae a. ");
INSERT INTO zypNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ama taco, a cung khang a kypaw pui, achaw teitah tingtua ciapaw a ca hmuh sá he a. Ma leco kaa dawngkasawny cawtah va tingtua my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Taico, a hningzuitu cawh va seí he ka, khuapui chunglang cawh a va nae he ka, Zisu tah a ching pawtei he hrakhei hming sahlo cawh aa va hmuh. Macawtaco Khungsai Panawnah zairia cawh aa pachia. ");
INSERT INTO zypNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Zailang leco Zisu cawh a hningzuitu pahrawhluihning khakhei a vong he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cabuai cawh cadung he ka, batui aa e leimeining takhei Zisu tah, “Biahmuisui ka ca ching he, naa hrong tai hei pakheh, kama khatei batui a e hrahpaw tahei a pa lui a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aa dawngkasawny co aa ngechia ngetei ka, pakheh khy pakheh tah, “Kama cang hrahring bei neh?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Zisu taco aa hai letah, “Naaning hluihning chung lehei pakheh kama khatah pakang kangkheh letah very a e hrahpaw heh a cang a. ");
INSERT INTO zypNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cawngsaw Sawcapaw cawh Capathai tah a kong a ciapaw hratah a cung letah a tlung a. Canghrasala, Cawngsaw Sawcapaw a luipaw cawngsaw cawh a cing a ping! Za pi lytah ung seh la, a cawtah a chah vy hripaw,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aa e chung taco, Zisu tah very khah law ka, lawngbia a hlai khy taitah kychy ka, a hningzuitu sahlo cawh pei he ka, “Law la e my lo, ma heh ka pung a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ma khy taico ny cawh law ka, lawngbia a hlai khy taikhei hlai he ka, aa zongmingtei tah ma ny taico aa ding. ");
INSERT INTO zypNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Taico Zisu tah, “Ma heh ming hlupui cawtah a laipaw ka thisai, biahrai thapaw cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Biahmuisui ka ca ching he, Khazing painah raang letah a thapaw tah ka ding hlai vytei cawh misurhang heh ding khaw bei neh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Reithainah hlaw sungkheh aa sah khy taitah Oliv tlaang lang aa ke. ");
INSERT INTO zypNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zisu tah aa hai letah, “Naa dawngkasawny tah na pa paisai thlu he ceh, zecawtamaw tatah ma hrahei Capathai letah cia a cang. ‘Kama tah tuukingtu khah chei a neh ka, tuu vytei cawh a paipatlaw thlu he a,’ a tahpaw hrakhei. ");
INSERT INTO zypNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Canghrasala, ka thokaw taitah naaning naa hme lang tah Galili raang lang ka seihlang a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piter taco, “Aa zongmingtei tah ca paisai thlu hmai he seh la, kama cawh ca seisai by bei neh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Zisu tah, “Biahmuisui ka ca ching, ato zai lalei lehei aa uihning a khawng hlai letah uithung tai na pa paphahsai a,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Taico Piter taco, “Nama khatah ka thih hrápaw a cang zong tah ca paphah sai by a bei neh,” tatah a tah vy. A hningzuitu vytei zong tah ma hraco aa tah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gethsemani aa tahpaw hminghmaw lang cawh sei he ka, Zisu tah a hningzuitu sahlo hai leco, “Thlaw ka chang kaa letah ma lehei a za ty thlang my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piter le Jeims le Johan cawh Ama khatah a chui he ka, lung reithui le vaisang tah a ung. ");
INSERT INTO zypNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aa hai letah, “Ka hringnah heh thih khui khypaw ngechianah khatah a chih. Ma lehei ung thlang la, a raering my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aa hmelang a cawngpe va sei vy ka, alui letah a bawh ka, a cang khy caco, ma tai-ingnah cai tahei pa khungsai ky seh, tatah thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Zisu tah, “Abba, Apaw, nama na caw taco zezong a cang khy thlang. Ma tai-ingnah ny heh kama taitah lawhly thlang. Canghrasala, kama ka dunah hratah cang lytah nama na dunah hratah cang ky seh,” tatah thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Taico, a hningzuitu sahlo khaco a vong kaw ka, aa za ihning thlangpaw khah a hmuh. Piter hai letaco, “Simon, na ihning maw? Suimehlang pakheh hmai a raering teitah ung khy bei ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tuhsonah chung lang naa tlah ly nápawtah a raering la, thlawchang my lo. Thlawpaw taco ahmangpaw hming tua cawh a du thlang, canghrasala pungsaw duitei cawh a thaw a dia,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Va sei kaw ka, ma thlythly hraco thlaw a chang kaw hui. ");
INSERT INTO zypNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A va kaw kaw tihtah aa ihning thlu thlangpaw khah a hmuh, zecawtamaw tatah aa meh ku tu ka, ceh bei he. Zehratamaw bia kaa chai a tahpaw hmai hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A uithungnah letah a vong kaw hui ka, aa hai leco, “Ato tingtai heh maw a ih he ceh ka, naa hia thlang he ceh? A zaw myca! A cai a phah myca! Mingtua o, Cawngsaw Sawcapaw cawh mehsua sahlo kih letah hlai a cang myca. ");
INSERT INTO zypNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tho tua o! Sei he peh! A pa luitupaw cawh a va chuh myca hi!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ma hratei bia a rei leimei ning taco a hningzuitu hluihning chung letei pakheh a cangpaw Judas cawh a va chuh. Ama khatah tlangbui macang le phungbia cawngpahtu le macang sahlo tei aa tawpaw he cawngsaw rung cawh zyzi le thingtai a tle he ka, a va chuh hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A luitupaw taco aaning cawh, “Ka hnangpaw khah Ama cawh a cang a, tle la, a vaitu sahlo khatah seikhui my lo,” tatah paching pakhanah a peh pacia thah he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zisu khaco a vaw palang ka, Judas tah, “Cawngpahtu,” tatah y ka, a hnang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cawngsaw sahlo taco Zisu cawh aa tle. ");
INSERT INTO zypNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mataico, ma letei a daw thlangpaw pakheh taco a zyzi cawh a chua ka, Tlangbui alaicaipaw a saecapaw a naw khah tuh ka, a pathai thlah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Taico Zisu tah, “Rae a thopaw sahlo hotu ka cangnah caw tamaw tle pawtah zyzi le thingtai tah naa pa seihno? ");
INSERT INTO zypNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ning tating tah naaning khatah ung neh ka, behnah ingdung letah zong cawngpah he neh ka, naa pa tle tlung be. Canghrasala, ma hrahei a cangpaw cawh Capathai bia patling a hy cawtah a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Taico aa dawngkasawny tah Ama cawh hningchai he ka, aa saisai thlu. ");
INSERT INTO zypNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Taico satle pakheh paithladih sui a buhpaw takhei Zisu cawh a zuilai. Ama cawh aa tle tihtah, ");
INSERT INTO zypNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a pai cawh thlethlah si ka, a tahlong teitah a sai. ");
INSERT INTO zypNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Zisu cawh tlangbui alaicaipaw ing lang khah seikhui he ka, ma leco tlangbui macang vytei le macang sahlo le phungbia cawngpahtu sahlo khah a va chuh hrui he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piter tah langhlaw pui tah Ama cawh zuilai ka, tlangbui alaicaipaw ingdung chung taikhah a zuilai. Ma leco raevai sahlo khakhei me a ai ka, a palung. ");
INSERT INTO zypNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tlangbui macang sahlo le Sanhedrin khongsil vytei taco, Zisu aa thaw khy nápawtah a suanah khah hui he ka, canghrasala zehmai hmuh bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cawngsaw hlupui tah hing le he tah Zisu reipachianah khah rei he ka, canghrasala pakheh le pakheh aa reipaw khah a lo tlang be. ");
INSERT INTO zypNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Taico thaikhehpaw cawh a daw he ka, Zisu kong letah ma hingbia heh rei he ka, ");
INSERT INTO zypNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“A reipaw kaa thuipaw cawh, ‘Ma behnah ing cawngsaw tei sahpaw heh chehthlah a neh ka, ningthung chung letah cawngsaw tah sah lypaw ka padaw kaw a,’ a tah,” tatah hing bia cawh aa rei. ");
INSERT INTO zypNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Canghrasala, pakheh le pakheh aa bia cawh a lo tlang hlui be. ");
INSERT INTO zypNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mataico, tlangbui alaicaipaw cawh aa hme letah a daw ka, Zisu hai letah, “Aa bia heh palei bei he ceh maw? Ma cawngsaw sahlo tei sua aa ca pupaw heh zemaw a cang?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Canghrasala Zisu cawh de teitah a ung thlang. Tlangbui alaicaipaw taco, “A laisuipaw Khazing Sawcapaw Khri cawh na cang maw?” tatah a hae vy. ");
INSERT INTO zypNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Zisu taco, “Ka cang, taico Cawngsaw Sawcapaw heh Cungnungcai Khazing cacang lang letah a ty ka, avai meding cung letah a vongpaw khah na hmuh a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tlangbui alaicaipaw cawh a chaichi khah hriachy ka, “Hnikhuitu ahringpaw kaa hia khawh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Khazing a reipachianah cawh naa thui thlang myca kho. Zekhatamaw naa rawh?” a tah he. Aa dawngkasawny co thaw tlang a tlah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma khy taico, mehthaikheh tah Zisu cawh aa ci tah chawh he ka, a meh pamai he ka, aa kia tah aa cabai. “Ahomaw a ca cabai, ma ching tua!” tatah aa tah. Taico raevai sahlo taco Zisu cawh seikhui he ka, aa tuh. ");
INSERT INTO zypNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piter cawh ingdung chung letah a ung thlang ning taco, tlangbui alaicaipaw ing letei rai a hrepaw sae canu cawh a kae lang a vong. ");
INSERT INTO zypNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Piter cawh me a ai thlangpaw khah a hmuh tihtah va mingchai ka, “Nama zong heh Nazaret Zisu khatei a ungteipaw na cang hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Canghrasala Piter tah a paphah ka, “Zemaw na rei tahpaw hnih bei neh, thuithai hrah bei neh,” tatah tah ka, hawkaw lang khah a sei. ");
INSERT INTO zypNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma sae canu taco va hmuh kaw hui ka, a kaekang letei a daw thlangpaw he sahlo aa hai leco, “Ma cawngsawpaw heh aa hrong leteipaw pakheh a cang hrah hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piter cawh a paphah vy hui. A cawngpe khy lekhei ma letei a dawpaw sahlo takhei Piter cawh, “Nama heh aa hrong leteipaw na cang ceingei. Zemaw tah pawco Galili cawngsaw na cangnah cawtah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Taico Piter tah chia a sah ka, “Ma cawngsaw naa reipaw heh ka hnipaw cang hrahring be,” tah ka, bia a kang. ");
INSERT INTO zypNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma cangkawleh leco aa cawh a uihningnah a khawng. Taico Piter cawh Zisu tah a hai letei bia a reipaw, “Aa uihning a khawng hlai tah uithung na pa paphahsai a,” a tahpaw khah a thui kaw. Taico a ngechia ka, otlili tah a cah. ");
INSERT INTO zypNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mongdi taco, tlangbui macang sahlo le, macang sahlo le, phungbia cawngpahtu sahlo le, Sanhedrin khongsil vytei cawh bia cawh aa pathluh. Zisu cawh tongchai he ka, raang uhbui Pilat khatah aa hlai. ");
INSERT INTO zypNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat taco, “Juda cawngsaw aa siangpahrang cawh na cang maw?” tatah a hae. Zisu tah, “A cang, na reipaw hraco a cang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tlangbui macang sahlo taco Zisu cawh a phingphing tah sua aa pu. ");
INSERT INTO zypNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat taco a hai letah, “Aaning khah bia paleh a bei he ceh maw? Aa ca pupaw vytei heh ming tua hmai!” tatah a hae vy. ");
INSERT INTO zypNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Canghrasala Zisu taco kaw kheh hmai palei be. Pilat cawh a khuarawh a haa ngetei. ");
INSERT INTO zypNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Khungsai Panawnah lehei ming zawpui tei chuasah aa dupaw thongtlah pakheh cawh raang uhbui tah a thlaw pah tei he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Cawngsaw pakheh Baraba aa tahpaw, rae a tho ning tah lee a nongpaw sahlo khatah a pahlawh hrahpaw cawh thong-ing chung letah a ung. ");
INSERT INTO zypNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Zawpui sahlo cawh a vong he ka, tuateipaw phung hratah tua pá pawtah Pilat khah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat taco, “Juda cawngsaw aa siangpahrang heh ma thlawpah seh tah naa du maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hnachuanah rawng tah tlangbui macang sahlo taco Zisu cawh ama khatah aa va chuakhui tahpaw khah a hni thlang. ");
INSERT INTO zypNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Canghrasala tlangbui macang sahlo taco zawpui sahlo cawh Baraba ma chuapah hri tatah rei pawtah aa pasy he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Taico Pilat taco, “Juda cawngsaw aa siangpahrang naa tahpaw heh saw zekhatamaw ka tua a?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Zawpui vytei taco, “Khraws letah khaipai thlang!” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat taco, “Ze rawng tamaw? Ze hmingsua maw a tua?” tatah a hae he. Canghrasala zawpui taco, “Khraws letah khaipai thlang ky,” tatah a thang vy tah a y vy he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Zawpuipaw lungtlingsah a dunah cawtah Baraba cawh thlawpah he ka, Zisu cawh chei sah he ka, khraws letah khaipai pawtah Zisu khah raekeh sahlo khatah a hlai he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Zisu cawh raekeh sahlo tah abui ing Praetoriam aa tahpaw ingdung chunglang seikhui he ka, raekeh sahlo cawh aa dawngkasawny tah aa pahmo he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Taico Zisu cawh pai a saidungpaw a buh sah he ka, abui lukhu cawtah ahling tei phiapaw lukhu khah a lu letah a khusah he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Taico, “Juda cawngsaw aa siangpahrang cawh palawngpali tah ung seh,” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A lu letah sungbasih tah ato le ato tah tuh he ka, aa ci tah chawh he ka, aa khuh panai he ka, aa beh pakhei. ");
INSERT INTO zypNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Taico aa pasi aa pasa khy taitah pai a pasuapaw a saidungpaw cawh pahlu pah he ka, Ama a chaichi khah aa hrei sah kaw he. Taico khraws letah khaipai pawtah aa sei khui. ");
INSERT INTO zypNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Taico, khuatei lang tah khua a va tlawngpaw Sairin khuapaw, Alekzandar le Rufa aa paw Simon cawh langpui letah tle he ka, khraws khah hringhrang tah aa puh sah. ");
INSERT INTO zypNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Zisu cawh Galgotha, (A silang cawh luru hming tahnah a cang,) aa tahpaw hminghmaw lang aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Taico, mura sii khatah pahlawhpaw misur zu khah pei he ka, canghrasala Zisu tah ding du be. ");
INSERT INTO zypNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Taico, khraws leco aa khaipai. A chaichi cawh a chaichy he ka, pakheh cy tah ze heh maw kaa ting a tah hni du tah basung aa phe. ");
INSERT INTO zypNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aa khaipainah cai cawh mong suimehlang pakua a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sua aa phosahnah bia, ca tei aa ciapaw cawh, “JUDA CAWNGSAW AA SIANGPAHRANG A CANG,” tah heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ama khatah damia pahning, a cacang lang letah pakheh, a cavui lang letah pakheh aa khaipai hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Capathai tah, “Ama cawh mehsua sahlo khatah reipai a cang hrah,” a tahpaw bia cawh a tling. ");
INSERT INTO zypNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A seithipaw sahlo takhei aa lu cathingso he ka, naisui hmo khei, “Behnah ing chehthlah tah ningthung letah a sah kaw khypaw cang bei ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Khraws taikhei za cung thlah la, nama le nama a pachah ca!” tatah aa pasi aa pasa. ");
INSERT INTO zypNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma hraco tlangbui macang sahlo le phungbia cawngpahtu sahlo taco, pasipasa hrah he ka, “Cawngsaw ahringpaw cawh pachah he ka, canghrasala ama le ama cawh a pachah khy beh! ");
INSERT INTO zypNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel Siangpahrang Khri cawh atoheh kaa mehmuh lehei khraws taikhei cungthlah tua, maco ca hmuh a peh ka, kaa ca zing a,” tatah aa tah. Ama khatei aa khaipai hrahpaw he takhei naisuinah bia a hlupui khei aa tah hrah. ");
INSERT INTO zypNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ningching suimehlang hluihning hrong taitah zailang suimehlang pathung tai raang pungpaluh letah muinah a tlung. ");
INSERT INTO zypNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Zailang suimehlang pathung leco Zisu cawh, “ Eloi, Eloi, lama sabathani?” tatah a thangpui tah a y. A silang cawh, “Ka Khazing, ka Khazing, zecawtamaw na pa seisai?” tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma letei a daw thlangpaw mehthaikheh tah ma cawh aa thui tihtah, “Nawthlia tua, Elija a y!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Taico cawngsaw pakheh va sai ka, span cawh misur zu a thobahlapaw letah nong ka, rahtlong letah patai ka, Zisu cawh ding pawtah a hlai. “Ama teitah ung cong tua seh, Ama lahthlah pawtah Elija cawh a vong maw, vong ly mingtua he peh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Taico Zisu cawh a thangpui tah y ka, a thi. ");
INSERT INTO zypNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Behnah ing letei pai aa pazypaw cawh a dong taitah a hrang tai pehning tah a hriachy. ");
INSERT INTO zypNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A hme letei a daw thlangpaw raekeh zakheh buipaw tah Zisu a ypaw le zekhatamaw a thih tahpaw khah a hmuh tihtah, “Ma cawngsaw heh Khazing Sawcapaw a cang hrahring thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Canu thaikhehpaw tah langpá tah aa cai thlang. Aa hrong leco, Mari Makdalin, a sui vypaw Jeims le Josef aa no Mari le Salomi a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ma canu sahlo cawh Zisu, Galili raang letah a ungning tei a zuilaipaw le, a byhiapaw a tuapahpaw sahlo khah a cang he. Ama khatah Jerusalem lang a vong hrahpaw canu a hlupui zong a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma ning cawh Pachiapaningnah Ning, Sabat ning hlai teipaw ning khah a cang. Zailang a va phah tihtah, ");
INSERT INTO zypNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimathea khuapaw, khongsil chung letah aa cizaw ngeteipaw Josef cawh Khazing painah raang a va tlung lepaw hnabeisuinah a hnui ngeteipaw cang ka, ama cawh Pilat khatah raechah ngetei tah a vaw ka, Zisu rawh cawh a va hae. ");
INSERT INTO zypNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Zisu cawh a thi thah tahpaw Pilat tah a thui tihtah a ning a ang ngetei. Raekeh zakheh buipaw khah y ka, “A thi thah maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Zisu cawh a thi thah,” tatah raekeh buipaw tei a reipaw khah a thui tihtah Zisu rawh cawh Josef khah a peh. ");
INSERT INTO zypNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Taico Josef tah paithladih a naipaw co ka, a rawh cawh lawthlah ka, paithladih co pahlong ka, alung kho aa ruipaw thlai leco a isah. Taico alung a laipaw pui khah thlai kaw lekhei a palia. ");
INSERT INTO zypNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari Makdalin le Josef a no Mari tah Zisu aa phungnahpaw hming cawh aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat ning a chang tihtah Mari Makdalin le, Jeims a no Mari le, Salomi taco Zisu rawh thu ruapaw sathy ringthopaw khah aa cawh. ");
INSERT INTO zypNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Zaa kheh letei ning hmetaw caipaw mong lang ning a chua khy taitah thlai lang cawh a vaw he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Langpui leco, pakheh le pakheh khah, “Ahomaw thlaikha a ma hongpah a?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Canghrasala thlai cawh ming he ka, thlaikha alung alaipaw pui cawh a hneihly thah. ");
INSERT INTO zypNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Thlai chunglang cawh a nae he ka, satlepaw pakheh cawh angkilai arangpaw a hrei ka, cacang lang chang letah a ty thlangpaw khah hmuh he ka, a pahly ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma satlepaw taco, “Naa thlawzawng kheh seh, khraws letei aa khaipaipaw Nazaret Zisu khah naa hui tahpaw ka hni. A tho kaw thah! Ma lehei ung khawh be. Aa i sahnahpaw heh mingtua o. ");
INSERT INTO zypNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Canghrasala va sei la, a hningzuitu sahlo le Piter khah, ‘Ama tah a ca chingpaw he hrakhei naa hme lang khei Galili raang lang sei ka, ma leco naa hmuh tae a,’ a tah tatah va ching o,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Canu sahlo cawh thlawzawng hmotah le ci hmotah thlai taico rairang teitah chuhthlah he ka, a sai he. Aa ci tu rawng tah khei ahohmai bia a ching bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zaa kheh letei ning hmetaw caipaw, a thokaw ning mongdi tah Zisu cawh a chung taitei khachia sangsarih a papiapah no Mari Makdalin khakhei a paly taw. ");
INSERT INTO zypNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari Makdalin taco Zisu khatei a za ungpaw sahlo, mangchia sá tei, a cah leimeipaw sahlo khaco va seí ka, a thuisah he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Zisu cawh hring thlang ka, ka hmuh,” tatah a chingpaw he khah aa thui tihtah zing bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma khy taico Zisu cawh a hningzuitu taitah pahning khatah khuatei lang aa tlawngnah lekhei a hmuisang a macangpaw tah a paly. ");
INSERT INTO zypNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma tlaw cawh va kawkaw he ka, a tangpaw aa vesaw sahlo khah aa ching he, canghrasala zing hlui hrah bei he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ahning cai letah Zisu cawh a hningzuitu hluikheh sahlo batui aa e leimeining takhei a va paly. Zingnah aa hnuilynah cawtah le a tho kaw khy taitei a hmuhpaw sahlo tei aa chingpaw he zing pawtah aa lung a khong tu cawtah khei a chinghring he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aa hai letah, “Khazaw pungpaluh letah sei la, tuapaw hming vytei khatah thawngchawbia heh va rei my lo. ");
INSERT INTO zypNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aho aa cang zong tah zing katei, baptisma a cangpaw maikaw cawh pachah a cang he a. Canghrasala a zing lypaw maikaw cawh sua phosah a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma ningang chuipaw paching pakhanah tahei a zingpaw sahlo cawh a zui longmang he a. Kama ka ming tah khachia aa papia a, reithapaw zong tah aa rei a. ");
INSERT INTO zypNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pari zong aa kia tah tle he ka, thihnah si zong aa ding hrah hmai tah zekhatahmai a tua a bei he. A dang lypaw cung letah aa kih zong pahnia a he ka, a dang he a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Taico Abuipaw Zisu cawh aaning khatah bia a rei khy taitah vaicung lang lahchy cang ka, Khazing cacang lang letah a ty. ");
INSERT INTO zypNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Taico, a hningzuitu sahlo cawh sei he ka, kawkehnah letah thawngchawbia cawh aa reilai. Abuipaw tah aaning cawh hrekhui he ka, aaning a zuilaipaw he ningang chuipaw paching pakhanah takhei aa bia sahlo cawh a pacysah.");
INSERT INTO zypNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mehchaw cai a cangpaw Theofila, mehlupui tah kaa hrawng letei hming a va tlung ciapaw kong khah cia a pachia cy he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","cia a pachiapaw he cawh mehkho ceingei tei a hmuh tawpaw sahlo le phung a reilaipaw sahlo he tei aa ma chingpaw hrakhei a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Macawtaco kama zong tah a hrangthonah taitah zezong a raering teitah ka khiahle khy taitah a pazui naning tei hratah na cawtah ciapah heh a chah thly a tatah ka rawh. ");
INSERT INTO zypNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aa ca cawngpah pawhe vytei khah biahmuisui a cang tahpaw na hni khy nápawtah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod cawh Judia raang letah siangpahrang a cangning takhei Zakaria aa tahpaw tlangbui pakheh ung ka, ama cawh tlangbui Abija phu leteipaw a cang. A nupui Elizabet zong cawh tlangbui Aron hring a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aa pahning tah Khazing hme letah a dingkong teitah khua a sahpaw cang he ka, suise a kawh ly tei Abuipaw biapeh le a phung le lang vytei khah a zuipaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Canghrasala Elizabet cawh cing ka, sawteisah bei he. Aa pahning co, aa kung a macang ngetei myca he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Uikhehpaw cawh Zakaria phu khah aa raihre nápaw cai cawh va chuh ka, Zakaria cawh Khazing hmekaw leco tlangbui rai cawh hre ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tlangbui cangnah rai a rainah phung tei hratah basung phe he ka, ama cawh Abuipaw behnah ing chung letei ringthopaw me tei ropaw rai khah a ting. ");
INSERT INTO zypNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ringthopaw me ronah cai a va chua tihtah Khazing beh rua pawtei a pahmopaw zawpui sahlo cawh khungthing lang lekhei thlaw aa chang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mataico, Abuipaw vaiming cawh ama khatah a va paly ka, ringthopaw ronah siasang cacang lang lekhei a daw thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria tah ama cawh a hmuh tihtah a pahly ka, a ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Canghrasala vaiming taco, “Zakaria ci kheh, Khazing tah na thlawchangnah khah a ca thui pah. Na nupui Elizabet tah sawcapaw a ca sah pah a. A ming cawh Johan na sá a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na thawchahnah le na lung a tlingnah ngetei a cang a. A pinah cawtah ming hlupui khah aa lung a lawng a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Abuipaw mehmuh letah mehlai a cang a. Zu le ahringpaw rui khy a cangpaw zong khah ding hrahring a be. A no chung taitah Thlawpaw Pathai tah a chih ciapaw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel cawngsaw mehlupui khah Abuipaw aa Khazing khatah a va chui kaw he a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Taico, Elija a hmingtuakhynah le a thlawpaw tah Abuipaw hmelang tah a sei a. Paw sahlo lungthing cawh aa sawtei sahlo lang letah le bia a nge lypaw sahlo cawh singnah a cangpaw dingnah lang letah a hui sá he a. Cawngsaw vytei khah Abuipaw cawtah a maipacia rua pawtah a pachia a paning he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria tah vaiming hai letaco, “Ma cawh zehratamaw a cang khy a? Kama zong mehtaa cang myca neh ka, ka nupui zong kung macang pui a cang myca?” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Vaiming taco, “Kama Gabriel cawh, Khazing hmekaw letah a dawpaw ka cang. Ma kong thawngchawbia heh nama ching rua tah tawpaw ka cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mataico nama cawh ma hming vytei heh a va tlung thlu hlai vytei na rei thlaw khy khaw bei ceh. Zecawtamaw tatah ma cai a tling tih tei, a va tlung lepaw ka reipaw bia khah na zing lynah cawtah,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ma chung cawh zawpui vytei tah ama cawh heh thlang he ka, zecawtamaw behnah ing chung letah ma tlua co a ry zia tatah aa khuarawh a haa thlu. ");
INSERT INTO zypNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A ka piathlah tihtah aaning sahlo khah bia a ching khy khawh bei he. Behnah ing chung lekhei apalynah a hmuh tahpaw khah aa hni. Zemaw tahpaw co, a kihtua khei bia khah a ching he ka, a rei cawh thlaw khy hlui be. ");
INSERT INTO zypNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mataico a raihrenah cai cawh a chang tihtah ing lang khah a dih. ");
INSERT INTO zypNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma khy taico a nupui Elizabet cawh sawtei pho ka, thlah pangaw chung a nawh. ");
INSERT INTO zypNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabet taco, “Ma heh Abuipaw tah ka cawtah a tuapaw a cang, atoning cai lehei a dukhuinah cawh palangsah ka, ming vytei hrong letei ka ningzawnah khah a pa lahpah hly myca,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Taico, a thlahruhnah leco, Khazing tah vaiming Gabriel cawh Galili raang Nazaret khua lang khah taw ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","David teisaw a cangpaw Josef tah chui ruapaw tei a pahapaw laisaw pathai khakhei a taw. Ma laisaw pathai a ming cawh Mari a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Vaiming cawh ama khaco va sei ka, “Na kih ka ca tle, nama cawh dukhuinah a sangpui a cypaw na cang. Abuipaw cawh nama khatah a ung,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari cawh ma bia rawng taco a lung hna a hnawh ngetei ka, ma heh zehapaw kihtlenah maw a cang sialia, tatah a khuarawh a haa thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Canghrasala vaiming taco a hai letah, “Mari, ci kheh, Khazing dukhuinah na hmuh myca. ");
INSERT INTO zypNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sawtei pho ceh ka, sawcapaw na sá a. A ming tah Zisu tatah na tah a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ama cawh mehlai cang a ka, Cungnungcai Khazing Sawcapaw tatah y a cang a. Abuipaw Khazing tah a pathlahtu paw David abui dyching khah a pae a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jakob mingphing sahlo cung letah bia a hnui paria a. A painah raang cawh changnah hnui be,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari taco, “Zekhatamaw ma hming heh a cang thai a? Kama cawh laisaw pathai pui ka cang caw!” tah ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","vaiming taco, “Thlawpaw Pathai cawh na cung letah tlung ka, Cungnungcai Khazing hmingtuakhynah tah a ca bakhu a. Macawtaco, mehpathai a va pi lepaw cawh Khazing Sawcapaw tatah y a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na sawny no Elizabet tahmai a tá khy tah sawtei a sá a. A cing tatei aa tah teipaw khah atoheh cawh a thlahruhnah a cang myca. ");
INSERT INTO zypNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Khazing khaco a cang khy lypaw zehmai ung be,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari taco, “Kama cawh Abuipaw a saecanu ka cang, na reipaw hratah ka cung letah tlung ky seh,” tatah a tah. Mataico, vaiming tah ama cawh a seisai. ");
INSERT INTO zypNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma ningcai leco Mari cawh a pachia ka, Judia raang tlaang cung letei a ungpaw khua lang khah rairang tah a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakaria ing leco a nae ka, Elizabet cawh a kih a tle. ");
INSERT INTO zypNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mari tei bia a chingpaw khah Elizabet tah a thui tihtah a chung letei a ungpaw ny cawh a pathlo ka, Elizabet cawh Thlawpaw Pathai tah a chih. ");
INSERT INTO zypNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A thangpui tah y ka, “Canu vytei letah bonghnang a ting cai no cang ceh ka, na sah lepaw ny zong bonghnang a tingpaw a cang! ");
INSERT INTO zypNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Canghrasala zecawtamaw ma tlua hei dukhuinah ka ting tu tlong! Ka Buipaw a no, kama khatah na vong thlangpaw heh! ");
INSERT INTO zypNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na kih tlenah o khah ka naw tah a thui cangkaw tei leh ka chi chung letei a ungpaw ny cawh a lawng ka, a pathlo. ");
INSERT INTO zypNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Abuipaw tah ama khatei bia a reipaw, a va tlung ceingei a, tatei a zing no cawh bonghnang song tah ung ky seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Taico Mari taco, “Ka hringnah tahei Abuipaw cawh reithai ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ka thlawpaw cawh Khazing, a pa Pachahtu cung letah a lawng. ");
INSERT INTO zypNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A saecanu a ny pahnai zia cawh monghly be ca ka, atoning ri taihei co, chai a va chuh lepaw letei cawngsaw vytei tah bonghnang a ting no aa pa tah a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Meh thawtlungpaw taco, ka cawtah hming rungnawpaw a tua myca, a ming cawh a pathai. ");
INSERT INTO zypNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chaikheh hning chaikheh Ama a cizawpaw sahlo he cung letah a ningdonah a palang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A kiá tah hming rungnawpaw sahlo cawh tua ka, aa lungchung tei a palai a patuinah a hnuipaw sahlo khah a papaipatlaw thlu he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Uhtu bui sahlo khah aa buidyching taitah dawh thlah he ka, canghrasala nytawpaw sahlo cawh a cuicaling he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A ngaidipaw sahlo cawh hming chawpaw tah aa rivawsah he ka, canghrasala mehrung sahlo cawh aa kih longpaw tah a kawsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A sae Israel cawh bawkhang ka, Abraham le a pathlah sahlo ");
INSERT INTO zypNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","letei a zaangsawnah cawh chaizaw tah a thui paria thlang ka, kaa mapaw sahlo letei a reipaw zong tai khah,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari cawh Elizabet khaco thlah thung hrawng a ung khy taitah ing lang a tlung kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabet cawh ny a hnuinah ning le thlaw cawh va tling ka, sawcapaw a sah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A ingpaw le a sawny sahlo tah Abuipaw tah a cung letah a zaangsawnah alaipui tah a langsah tahpaw aa thui tihtah a lawng khui ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ningreh ning taco nysai cawh a cingpatai rua pawtah va sei he ka, a ming cawh a paw ming Zakaria sah kaw pawtah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Canghrasala a no tei a tahpaw cawh, “Cang be, Johan tatah ypaw a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aaning sahlo taco, “Naa sawny hrong letah ma hapaw ming a phopaw cawh aa ung tlung be,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Taico a paw cawh kihtua tah nypaw ming heh aho tah paseh la maw na du tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ama taco, “Ca cianah calung pa pei law,” tatah a kih tuapah he ka, “A ming cawh Johan a cang,” tatah cia ka, cawngsaw vytei cawh aa khuarawh a haa thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma khy cangkaw leco, a lui cawh a catlai ka, a hmo a ka caw ka, bia ka reichua ka, Khazing khah a reithai. ");
INSERT INTO zypNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ingpaw sahlo vytei cawh ningang tah ung he ka, tlaang raang a cangpaw Judia raang cawngsaw vytei taco, ma kong longtei khah aa rei. ");
INSERT INTO zypNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma aa thuipaw maikaw cawh aa khuarawh haa ka, “Ma nypaw heh zemaw a ka lo tae tu a?” tatah aa tah tlungmang. Abuipaw hmingtuakhynah kih cawh a cung letah a ungnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A paw Zakaria cawh Thlawpaw Pathai tah chih ka, bia phy ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Abuipaw, Israel Khazing cawh reithai tah ung ky seh. Zemaw tah pawco, Ama cawh a vong ka, a cawngsaw sahlo cawh a tlang myca he. ");
INSERT INTO zypNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A sae David pathlah taikhei pachahnah ki cawh kaa cawtah a patung myca. ");
INSERT INTO zypNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Abuipaw tah khuahlai ning taitei Khazing khuavang mehpathai sahlo hmang tei bia a ma taipaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kaa carae sahlo le a ma huapaw sahlo taitah pachah rua pawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Khazing tah kaa mapaw sahlo cung letah zawnge a neh ka, ka biahrai pathaipaw cawh ka cingkai a, a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kaa mapaw Abraham khatah ma biatainah a tuapaw cawh ");
INSERT INTO zypNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kaaning khah kaa carae kih chung taitah pachah chua pawtah le ciphang lytah le pathainah le ding ná tah, ");
INSERT INTO zypNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kaa hring chung vytei a hmekung letah a rai kaa hre khy nápaw cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka sawtei, nama cawh Cungnungcai Khazing khuavang tatah y na cang a; zecawtamaw tatah Abuipaw langpui parai pawtah a hme letah na sei lai a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A cawngsaw sahlo khah naa suanah ngethai a cangnah thongtah pachahnah naa hmuh a, tatah na ching he a. ");
INSERT INTO zypNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Zecawtamaw tatah kaa Khazing cawh ningdo a thaipaw le a ningnaipaw a cang, pachahnah khainah cawh avai taitah kaa cung letah khaisah ka, ");
INSERT INTO zypNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","thihnah ningpahli le muinah chung letah a ungpaw sahlo cung letah khai sá pawtah le kaaning khah denah langpui lang chuithlah rua pawtah a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Taico nysai cawh ka changchy ka, thlawpaw lang letah thawzaang ka hnui longmang ka, Israel mingphing sahlo letei a va phyhlang hlai vytei cawh raangcaa lekhei khua a sah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma ningcai leco Sizar Augusta tah Rom painah raang chung letei a ungpaw vytei mehlu rei rua pawtah bia a chua. ");
INSERT INTO zypNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma hming heh Kuirinia cawh Siria raang letah raang uhbui a hrening letei mehlu reinah a ung taw caipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cawngsaw vytei cawh aaning aa thokehnah khua cacy lang khah ming cia rua pawtah a sei he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josef zong Galili raang Nazaret khua taitah Judia raang David khua Bethlehem lang cawh sei rua pawtah a tho. Ama cawh David hring le a pathlah taitei a chuhpaw a cangnah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Chui ruapaw tei a pahapaw Mari, ny a chai daimangpaw khaco ming cia rua pawtah a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma letei aa ungning taco ny a hnui nápaw ning le thlaw cawh va tling ka, ");
INSERT INTO zypNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","taico sa-uthui cawh sah ka, sawcapaw a cang. Pai tah pahlong he ka, sahring lawhkong letah aa isah, zecawtamaw tatah khuabuh letah aa tlung nápaw hminghmaw ung khawh be. ");
INSERT INTO zypNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Taico ma kaekang phong leco tuukingtu sahlo ung he ka, zai tah aa tuu sahlo cawh aa mingkai he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Abuipaw a vaiming cawh a za paly ka, Abuipaw rungnawnah taco aa kaekang vytei cawh khaisah thlu ka, tuuking sahlo cawh aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Canghrasala Abuipaw a vaiming taco, “Ci khe o, cawngsaw vytei caw pawtah thawngchawbia a lawng a chuipaw ka va ca tlungkhui pah he hi. ");
INSERT INTO zypNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Atoning heh naa cawtah David khua letah Pachahtu a pi, Ama cawh Khri le Abuipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma heh naa cawtah paching pakhanah a cang a. Nysai pai tei pahlongpaw, sahring lawhkong letei aa isah thlangpaw cawh naa hmuh a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma cangkawleh cawh sung sungkheh tah vaiming rungpui cawh Khazing reithai hmo khei vaiming khaco a za paly he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Cungnungcai Khazing cawh reithai tah ung ky seh, a dukhuinah aa cung letah a ungpaw aluicung cawngsaw sahlo khaco denah ung paria thlang seh,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vaiming sahlo vaicung lang aa sei kaw taico, tuuking sahlo taco, “Atoheh a tho he peh seh la, Bethlehem khua lang cawh sei he peh. Abuipaw tei a ma chingpaw hming a va tlungpaw cawh ming rua pawtah sei he peh,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Taico rairang tah sei he ka, Mari le Josef le sahring lawhkong letei aa isah thlangpaw nysai khah aa va hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aa va hmuh khy taico, ma nysai konglang vytei, vaiming tei a chingpaw he hratah aa va hmuhpaw kong khah aa reilai longmang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A thuipaw vytei sahlo taco, tuukingtu sahlo tei bia aa reipaw khah aa khuarawh a haa ngetei thlu. ");
INSERT INTO zypNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Canghrasala Mari duitei taco ma hming vytei cawh a lungthing tah pacang ka, a cingkai. ");
INSERT INTO zypNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aa thuipaw hming vytei le aa hmuhpaw maikaw cawh aa chingpaw he hratah a cangnah cawtah tuukingtu sahlo tah Khazing cawh rungnawnah le reithainah hlai he ka aa ungnah lang a kaw kaw he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ningreh a va tling ning leco, a cingpa cawh tai he ka, a ming tah Zisu aa sah. Ma ming cawh sawtei a pho hlai tah vaiming tei a peh si ciapaw ming khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses phungbia hratah a pathaisahnah cai cawh a tling tihtah Josef le Mari taco Abuipaw letah hlai rua pawtah Zisu cawh Jerusalem lang aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Abuipaw phungbia letah, “Capaw sa-uthui maikaw cawh Abuipaw cawtah patliapaw a cang he,” tatah ciapaw hratah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Taico Abuipaw phungbia tei a reipaw zui nápaw athuihlainah caw pawtah thury bokheh a cang ly leh lelai a nypaw tei punghning tah aa hlai pawtah aa va seipaw a cang hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma ningcai leco Jerusalem letah cawngsaw pakheh Simeon aa tahpaw, mehding le mehse ngeteipaw a ung. Israel mingphing cung letei thlaw palungtu a va tlung lepaw cawh heh thlang ka, Thlawpaw Pathai cawh a cung letah a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Thlawpaw Pathai tah Abuipaw Khri a hmuh hlai vytei cawh thi balang bei ceh tatah a thuisah ciapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Thlawpaw chuithlah ná tah behnah ingdung chunglang cawh a nae ka. Moses phungbia naning tei hratah a cung letah tua ruapaw cawtah nysai Zisu cawh a no le a paw tah aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon taco nysai cawh pawng ka, Khazing cawh ma hrahei a reithai, ");
INSERT INTO zypNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vy, Cungnungcai Abuipaw nama tei bia na pa pataipaw hrakhei atoheh na sae cawh thlawlung teitah na pa thihsah myca a. ");
INSERT INTO zypNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ka mehkho tah na pachahnah cawh a hmuh myca, ");
INSERT INTO zypNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ming vytei mehmuh letei na pachia ciapaw khah le, ");
INSERT INTO zypNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gental cawngsaw sahlo cawtah khainah cawh palangsah pawtah le na cawngsaw Israel cawngsaw sahlo rungnawnah ruapaw cawtah,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A no le a paw cawh nysai konglang a reipaw bia cawh aa khuarawh a haa ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Taico Simeon taco aaning cawh bonghnang song he ka, a no Mari khah ma hrahei a tah, “Ma nysai heh Israel cawngsaw mehlupui a posahly rua pawtah le mehlupui a padawchy tu cawtah rawhpaw a cang. Ama cawh Khazing taitah a va chuhpaw paching pakhanah cawngsaw hlupui tei aa cakhae lepaw cawh a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ma taikhei cawngsaw hlupui aa khuarawnah khah palang a cang tae a. Taico nama na thinglung zong zyzi tah a ca thipahleh tae a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Khazing khuavangno pakheh, Asher phing leteipaw, Fanuel a sawcanu Ana ung hrah ka, ama cawh a taa ngetei myca. Ama cawh dongcang ka, a pasae khatah kung sarih ung hrui he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma khy taico kung songreh le kung pali tai lahmeno a cang. Behnah ing seisai bang lytah ching le zai batui cahe hmotah thlawchang katei Khazing a beh teipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma ningcing taco aaning lang a vong ka, Khazing khatah alawngnah bia a hlai. Jerusalem pachahnah a heh paw sahlo maikaw hai leco ma nysai kong heh a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josef le Mari tah Abuipaw phungbia tei a hia a tahpaw maikaw aa tua panging thlu khy taikhei Galili raang aa ungnah khua Nazaret lang cawh aa paleh kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Taico nysai cawh ka lai vy longmang, a thaw ka tlung vy longmang ka, singná tah chih ka, Khazing dukhuinah cawh a cung letah a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kung tating tah Zisu a no le a paw cawh Khungsai Panawnah hmang rua pawtah Jerusalem lang a sei tei he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Zisu cawh kung hrawhluihning va tling ka, a phunglang tei hratah Panawnah lang cawh aa sei. ");
INSERT INTO zypNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Panawnah a chang khy taico a no le a paw cawh ing lang aa va kaw kaw ning tah nyhehpaw Zisu cawh Jerusalem lekhei ung patle ka, canghrasala aaning taco hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aa hrong letah a ung thlang rua tah he ka, ning kheh chung a sei he. Mataico a vesaw sahlo le a sawny hrong letah aa huilai. ");
INSERT INTO zypNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ama cawh aa hmuh khawh ly tih taco, Jerusalem khuapui lang khah hui rua pawtah aa paleh kaw he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ningthung a tling khy tah behnah ingdung chung lekhei, aa va hmuh kaw. Cawngpahtu macang sahlo khakhei a za ty thlang ka, aa bia khah nge he, hae hri he, a za tah leimei. ");
INSERT INTO zypNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A chaipaw he bia le a hnithai zia, aa thuipaw maikaw cawh aa ning a ang ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A no le a paw tah Ama cawh aa hmuh tihtah aa khuarawh a haa thlang. A no taco, “Ka sawcapaw, zecawtamaw ma hrahei na ma tua? Na paw khatah thlawzawng hmotah pui kaa ca huilai leimei kata caw!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Zisu taco, “Zecawtamaw naa pa hui? Ka Paw ing letah ka ung ruapaw a cang tahpaw heh hnih bei he ceh maw?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Canghrasala, aa hai letei bia a reipaw cawh a silang hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mataico, aaning khatah Nazaret khua lang cawh sei ka, aa reingé tah a ung. Canghrasala a no taco ma hming vytei heh a lungchung letah a pacung thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Taico Zisu cawh kachang vy lai, ka sing vy lai longmang ka, Khazing le cawngsaw dukhuinah a tong. ");
INSERT INTO zypNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberias Sizar abuinah kung hrawhluipangaw a tling kung, Pontia Pilat cawh Judia raang uhtu a cangning takhei Herod cawh Galili raang uhbui cang ka, a unypaw Filip cawh Ituria le Trakoniti raang uhbui cang ka, Lusinia cawh Abilen raang uhbui cang ka, ");
INSERT INTO zypNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas le Kaiafa tlangbui alaicaipaw aa cangning takhei, raangcaa letei a ungpaw Zakaria a sawcapaw Johan cung lekhei Khazing bia cawh a va tlung. ");
INSERT INTO zypNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jordan tuivaw kaekang raang vytei lang cawh seilai ka, sua ngethainah cawtah angepachihnah baptisma kong phung a rei lai. ");
INSERT INTO zypNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Khazing khuavang Isaiah cabu letei, “Raangcaa letei a y leimeipaw o taco, ‘Abuipaw a cawtah langpui parai la, a cawtah langpui pading pah my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Saiho maikaw cawh nai la, tlaang le tlangby maikaw cawh panai my lo. Lang a kuikalehpaw cawh pading la, a bykhi a bylypaw cawh pamai my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Taico, cawngsaw maikaw tah Khazing a pachahnah cawh aa hmuh a,’ tatah a tah,” tatah ciapaw hrakhei. ");
INSERT INTO zypNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Johan tah ama khatah baptisma cang ruapaw tei a va chuhpaw zawpui sahlo he cawh, “Naaning pari cangmai pathlah sahlo, Khazing thingaenah a va chuh leimeipaw heh saisai rua pawtah aho tamaw a ca ching he? ");
INSERT INTO zypNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na ngepachihnah he ceh cawh a thuipa tah palang my lo. ‘Abraham pathlah sahlo kaa cang peh,’ tatah tah leimei khe o. Ka ca ching he hi, Khazing taco ma alung sahlo heh Abraham sawtei sahlo tah a tua khy thlang he hi. ");
INSERT INTO zypNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Thinghrang maikaw letah ahrui aa chia thlu thah. Thui chaw a thui lypaw thingkung maikaw cawh hyhly tah me lang bo a cang he a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zawpuipaw tah, “A cang caco zemaw kaa tua a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johan taco, “Angki zing hning a hnuipaw tah a hnui lypaw khah chaichy seh la, e ruapaw a hnuipaw tah a hnui lypaw cawh pei hrah seh,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ngungkhui a kheipaw sahlo zong cawh baptisma cang hrá pawtah a vong he ka, “Cawngpahtu, zemaw kaa tua a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Khei ruapaw navy tah a hlu vy tah va khei lai khe o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mataico raekeh thaikhehpaw sahlo tah, “Kaaning saw zemaw kaa tua a?” tatah aa hae. “Male tangka chu lai khe la, ahmang lypaw tah cawngsaw luithae lai khe o, naa hlo letah naa lungtling thlang seh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Zawpui taco a ngete ly ngetei tah heh thlang he ka, aa dawngkasawny co, Johan heh Khri a cang thlang thly a, tatah aa rawh. ");
INSERT INTO zypNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johan tah aa dawngkasawny hai leco, “Kama taco tui tah baptisma ka ca cangsah he. Canghrasala kama navy tah a rungnaw vypaw a va chuh a. Kama cawh a phepakong rui a thlang tlangpaw hmai cang bei neh. Ama taco Thlawpaw Pathai le me tah baptisma a ca cangsá he a. ");
INSERT INTO zypNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Saze zeinah cawh a kiá tah tle ka, phuhri letah saze cawh a zei a, achang khah apaang letah rai a ka, asi khah a thi thai lypaw me lang a bo a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Taico Johan tah zawpui vytei cawh a phingphing tah pasynah bia ching he ka, aaning cawh thawngchawbia a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Canghrasala, Johan tah abui Herod cawh a nytei nupui Herodi a chunah kong letah le ahringpaw chahlynah hming a tuapaw vytei kong letah a mochia tihtah, ");
INSERT INTO zypNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod tah ma vytei cung letah a chahchipaw cawh Johan khah thong-ing chung letah a hrai. ");
INSERT INTO zypNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ming vytei baptisma aa cang tlungmang ning takhei, Zisu zong cawh baptisma a cang hrah. Taico thlaw a chang leimei ning taco avai cawh a hong. ");
INSERT INTO zypNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Thlawpaw Pathai cawh thury hratah a cung letah a za cung. Taico avai taitah o za ring ka, “Nama cawh ka dopaw Ka Sawcapaw na cang, na cung letah ka lung a lawng ngetei,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zisu cawh phungrei a patho ning tahei kung songthung hrawng a tah. Ama cawh Josef sawtei aa tah. Josef cawh Heli a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli cawh Mathat a sawtei, Mathat cawh Levi a sawtei, Levi cawh Melkhi a sawtei, Melkhi cawh Janai a sawtei, Janai cawh Josef a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef cawh Matathia a sawtei, Mathathia cawh Amos a sawtei, Amos cawh Nahum a sawtei, Nahum cawh Esli a sawtei, Esli cawh Nakai a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai cawh Matha a sawtei, Matha cawh Matathia a sawtei, Matathia cawh Semein a sawtei, Semein cawh Josek a sawtei, Josek cawh Joda a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda cawh Joanan a sawtei, Joanan cawh Rhesa a sawtei, Rhesa cawh Zerubabel a sawtei, Zerubabel cawh Shealtia a sawtei, Shealtia cawh Neri a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri cawh Melkhi a sawtei, Melkhi cawh Adi a sawtei, Adi cawh Kosam a sawtei, Kosam cawh Elmadam a sawtei, Elmadam cawh Er a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er cawh Josua a sawtei, Josua cawh Eliezer a sawtei, Eliezer cawh Jorim a sawtei, Jorim cawh Mathat a sawtei, Mathat cawh Levi a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi cawh Simeon a sawtei, Simeon cawh Judah a sawtei, Judah cawh Josef a sawtei, Josef cawh Jonam a sawtei, Jonam cawh Eliakim a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim cawh Melea a sawtei, Melea cawh Mena a sawtei, Mena cawh Matatha a sawtei, Matatha cawh Nathan a sawtei, Nathan cawh David a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David cawh Jesi a sawtei, Jesi cawh Obed a sawtei, Obed cawh Boaz a sawtei, Boaz cawh Salmon a sawtei, Salmon cawh Nashon a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon cawh Aminada a sawtei, Aminada cawh Ram a sawtei, Ram cawh Hezron a sawtei, Hezron cawh Perez a sawtei, Perez cawh Judah a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah cawh Jakob a sawtei, Jakob cawh Isak a sawtei, Isak cawh Abraham a sawtei, Abraham cawh Tera a sawtei, Tera cawh Nahor a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor cawh Seruk a sawtei, Seruk cawh Reu a sawtei, Reu cawh Pelek a sawtei, Pelek cawh Eba a sawtei, Eba cawh Shelah a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah cawh Kainan a sawtei, Kainan cawh Arpaksa a sawtei, Arpaksa cawh Shem a sawtei, Shem cawh Noah a sawtei, Noah cawh Lamek a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek cawh Methusela a sawtei, Methusela cawh Enok a sawtei, Enok cawh Jared a sawtei, Jared cawh Mahalale a sawtei, Mahalale cawh Kenan a sawtei, ");
INSERT INTO zypNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan cawh Eno a sawtei, Eno cawh Seth a sawtei, Seth cawh Adam a sawtei, Adam cawh Khazing a sawtei a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Zisu cawh Thlawpaw Pathai tah chih ka, Jordan tuivaw taitah va kaw kaw ka, Thlawpaw taco raangcaa lang a seikhui. ");
INSERT INTO zypNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma leco Setan tah ning songli chung tuhso ka, ma chung vytei cawh zehmai a e lynah cawtah a hning taco a ngai a di. ");
INSERT INTO zypNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setan taco, “Khazing Sawcapaw na cang caco, ma alung heh very tah cang law tah ca!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zisu taco, “Khazing bia letah ma hrahei ciapaw a cang, ‘Cawngsaw heh very suipaw tah aa hring tlung be!’ ” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Setan taco Zisu cawh tlaang sangpaw lang kekhui ka, khazaw painah raang vytei khah sungkheh tah hmuhsah ka, ");
INSERT INTO zypNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","taico a hai letah, “Ma vytei nawhnuinah le a rungnawnah heh ka ca pae a, zecawtamaw tatah ma heh kama letah pehpaw cang thah he ka, ka dupaw maikaw cawh ka peh khy he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Macawtaco, na pa beh caco, ma vytei heh na tei a cang a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Zisu taco, “Capathai letah ma hrahei cia a cang, ‘Abuipaw na Khazing khah beh la, Ama a rai suipaw hre my lo,’ tah a cang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Setan tah Zisu cawh Jerusalem khuapui lang seikhui ka, behnah ing a sangcainah ing cung lekhei a dawsah ka, “Khazing Sawcapaw na cang caco, ma taihei a zythlah tua. ");
INSERT INTO zypNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Zecawtamaw tatah ma hrahei cia a cang, ‘Nama na kong lehei Khazing tah a vaiming sahlo khah naw pei a he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na phe cawh alung letah na khong ly nápawtah aa kiá tah aa ca caling a,’ a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Zisu tah, “Abuipaw na Khazing cawh hnehsah kheh, tahpaw a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setan tah Zisu cawh ma vytei hrahei a tuhso khy taitah hmelang cai a raicangpaw cawtah a seisai. ");
INSERT INTO zypNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Thlawpaw Pathai thawtlungnah khatah Zisu cawh Galili raang lang a paleh kaw ka, a konglang cawh khuapui kaekang vytei letah a thang. ");
INSERT INTO zypNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aa synagog sahlo letah cawngpah he ka, ming vytei tah Ama cawh aa reithai. ");
INSERT INTO zypNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A changchynah khua Nazaret khua lang cawh sei ka, Sabat ning taco a tua teipaw phung hratah synagog lang kha a nae. Taico capathai rei pawtah a daw. ");
INSERT INTO zypNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Khazing khuavang Isaiah bia, sapho lingpaw cabu cawh a kih letah aa hlai. Ma cabu cawh pathlang ka, ma hratei ciapaw khah a hmuh, ");
INSERT INTO zypNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Abuipaw Thlawpaw cawh ka cung letah a ung, zecawtamaw tatah mehsisah sahlo hai letah thawngchawbia rei rua pawtah kama cawh sathy thu tah a pa thing. Thong letei a tangpaw sahlo he piachuanah ruapaw tlang y pawtah pa taw ka, a mehcopaw sahlo mehvang sápaw le tlaihnawh a cangpaw sahlo thochua rua pawtah le, ");
INSERT INTO zypNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Abuipaw dukhuipaw kung kong y khui rua pawtah,” tahpaw heh. ");
INSERT INTO zypNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mataico sapho lingpaw cabu cawh ling kaw ka, a kaitu khah pei ka, a ty. Synagog chung letei ming vytei taco a cung letah aa meh aa chia thlu thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aa hai leco, “Atoning letah ma Capathai heh naa thuipaw tei hrahei a tling myca,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ming maikaw tah a kong chaw rei he ka, a kaw taitei ningdonah bia a chuhpaw cung leco aa ningang ngetei thlu ka, “Ma heh Josef a sawcapaw khah cang bei maw?” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Zisu tah aa hai leco, “Ma phungthluh bia heh naa pa reiso hrahring tae hi, ‘Sibuipaw, nama le nama a dangsah tua, Kapernaum khua letei na tuapaw kaa thuipaw khah ma na changchynah khua lehei tua hrah!’ tahpaw heh. ");
INSERT INTO zypNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Biahmuisui ka ca ching he, Khazing khuavang cawh ama a pinah khua leco cyhlang bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Khazing khuavang Elija chai lekhei, Israel raang chung letah lahme hlupui a ung he. Kung thung le a chy khua kaang ka, raang pungpaluh letah cakaang a thaw tah a tlung. ");
INSERT INTO zypNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Canghrasala Elija cawh Israel raang lahme maikaw khatah taw cang hlui be. Sidon raang, Zarefat khua letei a ungpaw lahme khatah suipaw taw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mataico, Khazing khuavang Elisha chaining zong takhei, Israel raang chung letah mehthinghmui hlupui a ung he. Canghrasala Siria cawngsaw Naaman tah cy ly co ahohmai a dangsah tlung bei he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Synagog letei a ungpaw ming vytei tah aa thui tihtah aa thing aa ae ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tho he ka, Ama cawh khua lailang papia he ka, aa khuathui tlaang, lungkang lang nang thlah pawtah aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Canghrasala zawpui hrong taikhei a zuh thlah ka, a seihly. ");
INSERT INTO zypNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma khy taico Galili raang, Kapernaum khua lang cawh cungthlah ka, Sabat ning tah zawpui khah a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A bia cawh nawhnuinah chi tah a cangnah cawtah a cawngpahnah cawh aa khuarawh a haa thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Synagog leco, thlawpaw pialuipaw tei a tlepaw cawngsaw pakheh ung ka, a thangpui tah y ka, ");
INSERT INTO zypNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Vy, Nazaret Zisu, kaaning khahei zemaw na du? Kaaning hlyde ruapaw tamaw na vong? Nama cawh ahomaw na cang tahpaw ka hni, Khazing Mehpathai na cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Zisu tah, “De teitah ung! A chung taikhei ka pia,” tatah a hrangso. Ma khy taico thlawpaw pialuipaw tah ma cawngsawpaw cawh ming vytei mehmuh leco phongchai ka, hmaw phosah lytah a piathlah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Cawngsaw vytei cawh aa ningang thlang ka, pakheh le pakheh khah, “Zehapaw cawngpahnah maw a cang he? Naw hnuinah le hmingtuakhynah khatah thlawpaw pialuipaw zong naw pei he katei, aa pia thlangpaw heh!” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Taico Zisu kong thongpang cawh ma raang kaekang vytei cawh a thang thlu. ");
INSERT INTO zypNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zisu cawh synagog taitah piathlah ka, Simon ing lang a nae. Simon a nupuino a no cawh asaw tah a sahpui tah nang ka, Zisu cawh bawnah aa haepah. ");
INSERT INTO zypNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zisu tah a bung hno ka, a sawnah khah raw ka, a sawnah taco a thlaw. Sungkheh tah ka tho ka, aaning sahlo cawh a tangtui he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ning a va tlah lang leco asawnah phingphing a hnuipaw vytei khah Zisu khatah va chua khui he ka, aa cung letah a kih pahnia cy ka, aaning sahlo cawh a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma hlui co, mehlupui chung taitah khachia sahlo khah pia he ka, “Nama cawh Khazing Sawcapaw na cang,” tatah a y he. Canghrasala aaning cawh Zisu tah raw he ka, Khri a cang tahpaw aa hni cawtah khei aa rei thlawpaw khah sai bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mong khua va dui ka, Zisu cawh a kingdangnah lang khah sei ka, zawpui tah Ama khah aa hui. Taico a ungnah aa va phah tihtah aaning khah seisai khawh ly rua pawtah tle a pachia he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Canghrasala Zisu tah, “Khua hring lang zong letah Khazing painah raang thawngchawbia ka rei hrah ruapaw a cang, ma ruapaw taco tawpaw cang tlung neh ka,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Taico Judia raang synagog sahlo letah a cawngpah lai longmang he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ningkhehpaw cawh Zisu cawh Genesaret tuiping ngaekang leco a daw thlang. Cawngsaw zawpui taco a pungso thlang he ka, Khazing bia cawh aa nge. ");
INSERT INTO zypNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ngaw a tlepaw sahlo tei aa so aa suh kaa letei aa seisaipaw tuilawng sanghning khah ngaekang letah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simon a tei a cangpaw tuilawng chunglang cawh a nae ka, “Ngaekang taitah tui le chung vy lang hrui vy bang law,” tatah Simon cawh a tah. Taico a ty ka, zawpui cawh tuilawng taico a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bia a reipaw a pachang taico Simon hai letah, “Tui a thunah vypaw lang pange la, ma leco na so khah va tua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon taco, “Hruitupaw, zaikhuadui reithui ngetei tah va he peh ka, sangkheh hmai tle bei peh. Canghrasala, nama na bia tei hratah ka va thlang tua a,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma hraco tua he ka, ngaw a hlupui a o cawtah aa so sahlo zong a kychy pai thlu. ");
INSERT INTO zypNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mataico, tuilawng ahringpaw letei a ungpaw sahlo khah va ma baw law tatah aa kiá tah aa kui he. Mataico a vong he ka, tuilawng sanghning tah ngaw cawh dui he ka, a chi tu cawtah tuilawng cawh tui lang a phungpai daimang he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Piter tah ma hming vytei cawh a hmuh tihtah Zisu phehrang letah a bawh ka, a hai leco, “Mehsua ka cang, Abuipaw, pa seisai thlang law,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ama le a vesaw sahlo cawh ngaw hlupui aa tlenah cawtah khei aa khuarawh haa ngetei ka, ");
INSERT INTO zypNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon a vesaw sahlo a cangpaw Zebedi sawcapaw leh Jeims le Johan cawh aa khuarawh aa haa ngetei hrah. Mataico Zisu tah Simon hai letah, “Ci kheh, atohei co cawngsaw na tle myca he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Macawtaco tuilawng sahlo khah ngaekang lang piakhui he ka, zezongpui seisai tah Zisu cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Zisu cawh khuapui hrawng letei khua kheh letah a ungning taco, thinghmuihri tei a pahlong thlangpaw cawngsawpaw pakheh Ama khatah a vong ka, Zisu a hmuh cangkawleh alui letah a khuh panai ka, ma hrahei naw ka, “Abuipaw na du caco na pa dangsah khy,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zisu taco a kiá tah va pazah ka, ama cawh va tong ka, “Na dang cawh du neh ka, dang myca,” tatah a tah. Ma cangkaw leco, a thinghmuihri vytei cawh a pathai. ");
INSERT INTO zypNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Taico, Zisu tah ma hrahei bia patai ka, “Ahohmai ching khe lo, ma duitei cawh va sei la, tlangbui a va ming sah la, Moses phungbia hrakhei thuihlainah va tua, mapaw suico dangsah na cangpaw khah ming maikaw tah aa ca hni a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Canghmaisala, Zisu a konglang cawh a thang vy lo leimei ka, mehlupui tah a bia nge pawtah le aa sawnah pawhe dangsah rua pawtah Ama cawh aa va pange. ");
INSERT INTO zypNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Canghrasala Zisu cawh a kingdangnah lang sei tah thlawchang pawtah a piathlah tei. ");
INSERT INTO zypNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ningkheh cawh Zisu tah a cawngpah leimeining he tah Farasi le phungbia cawngpahtu sahlo, Galili raang khua ting taitah le Judia raang khua ting taitah le Jerusalem khuapui taitei a va chuhpaw sahlo cawh a ty thlang hrah he ka, a sahpaw sahlo he dangsah rua pawtah Abuipaw thawtlungnah cawh a cung letah a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mehthaikheh tah a songbepaw pakheh a iphaw khatah a ka song lai he ka, ing chunglang a nae khui tah Zisu kung tlungkhui pawtah a pachia he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cawngsaw aa hlutunah cawtah a kung phahkhuinah lang hmuh be ca he ka, ingcung lang aa kekhui. Ing aa daepaw lungphae khah hneihly he ka, cawngsawpaw cawh iphaw chitah zawpui hrawng lekhei Zisu hme lalei leco aa za thlah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zisu tah aa zingnah khah a hmuh tihtah a songbepaw hai leco, “Ka dua, na suanah vytei cawh ngethai a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Farasi le phungbia cawngpahtu sahlo taco, “Ma cawngsaw heh ahomaw a cang? Khazing reipachianah bia a rei hi! Khazing tah ly co ahomaw suanah a ngethai khy?” tatah aa lungchung tah aa pacang. ");
INSERT INTO zypNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Zisu tah aa lungchung rawhnah cawh hnih ka, “Zecawtamaw ma hrahei naa lungchung tah naa pacang? ");
INSERT INTO zypNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Na suanah sahlo cawh ngethai a cang,’ tahpaw maw a neh vy maw? ‘Tho la, sei,’ tahpaw maw a neh vy? ");
INSERT INTO zypNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Canghrasala, Cawngsaw Sawcapaw heh aluicung lehei sua ngethai khynah naw a hnui taheh ka ca hmuh sá he a,” tah ka, a songbepaw hai letaco, “Tho la, na iphaw a lah la, ing lang a dih,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sung sungkheh tah aa hmekaw leco a daw ka, a iphaw cawh law ka, Khazing reithai hmotah ing lang cawh a dih. ");
INSERT INTO zypNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ming maikaw cawh aa ningang ngetei ka, Khazing khah reithai he ka, “Atoning heh hming khuarawha chuipaw kaa hmuh hi,” aa tah tlungmang. ");
INSERT INTO zypNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma khy taico Zisu cawh piathlah ka, ngungkhui a kheipaw Levi aa tahpaw cawh ngungkhui kheinah hming letah a tythlangpaw khah hmuh ka, “Va pa zui,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Taico Levi cawh tho ka, zezongpui seisai tah Zisu cawh a zui. ");
INSERT INTO zypNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mataico Levi tah Zisu cawtah a ing letah lawhdangnah rungnaw ngeteipaw a tuapah. Ngungkhui a kheipaw mehlupui le ahringpaw mehlupui khah aaning khatah batui aa e hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Canghrasala Farasi le aa phu a cangpaw phungbia cawngpahtu sahlo taco, Zisu hningzuitu sahlo hai leco, “Zecawtamaw ngungkhui a kheitu sahlo le ahringpaw mehsua sahlo khatah naa e naa ding lai?” tatah aa mochia he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Zisu tah aa hai leco, “A dang thlangpaw tah sibui aa hia tlung be, a dang lypaw tah pui aa hia! ");
INSERT INTO zypNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mehding y rua pawtah ka vong tlung be, mehsua sahlo khah aa suanah a ngepachihsah rua pawtah ka vong hri hi,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aaning sahlo taco Zisu hai letah, “Baptisma peitu Johan a hningzuitu sahlo cawh batui cahe tah thlawchang tei he ka, Farasi phunglang aa zuipaw sahlo zong tah ma hraco aa tua tei hrah. Canghrasala nama na hningzuitu sahlo heh e le ding tah aa ung thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Zisu taco, “Songpaw sahlo cawh nupui a chuipaw satlepaw khatah aa ung chung taco batui a cahe tei he maw? ");
INSERT INTO zypNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Canghrasala nupui a chuipaw khah aa hrong taitei aa seikhuinah cai khah a phah tae a. Ma taico aa cahe tae thlang a,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma tawchingnah bia zong heh Zisu taco a ching he, “Ahotahmai paithang a thapaw khah hriachy tah chaichi a paringpaw khah a beithlah bang bei he. Ma hratei aa tua caco a thapaw khah a rawhrang a ka, a paringpaw letei a thapaw aa baipaw zong khah a tlah hrá be. ");
INSERT INTO zypNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mataico ahotahmai misurhang a hringtui khah sapho tuithei a paringpaw letah rai bang bei he. Aa rai caco, misurhang a hring taco sapho tuithei cawh tingchy a ka, taico misurhang khah zuh thlu a ka, sapho tuithei zong a rawh thlu a. ");
INSERT INTO zypNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma navy co, misurhang a hringtui cawh sapho tuithei a thapaw letah rai hripaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Cawngsaw maikaw tah misurhang ahlungpaw aa ding khy taitah a thapaw ding du khawh bei he. ‘A hlungpaw a chah vy,’ aa tah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zisu tah Sabat ningkhehpaw cawh saze lui cahrong ka, a hningzuitu sahlo taco saangsu cawh pahrih he ka, aa kih letah rua he ka, aa e lai. ");
INSERT INTO zypNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farasi cawngsaw thaikheh tah Zisu cawh, “Sabat ning letah tua phung a cang lypaw zecawtamaw naa tua?” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zisu taco, “David tei a vesaw sahlo khatah aa ngaidi ning tei a tuapaw khah rei bang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Khazing behnah ing lang a nae ka, tlangbui sahlo tah ly co ahotahmai e phung a cang lypaw, Khazing aa dangnah very khah a e! Taico a chy khah a vesaw sahlo zong a peh hrah he kho!” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Taico Zisu tah aa hai letah, “Cawngsaw Sawcapaw heh Sabat Buipaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat ning vypaw leco Zisu cawh synagog lang a nae ka, a cawngpah he. Ma leco cawngsawpaw pakheh a cacang lang kih a songpaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farasi le phungbia cawngpahtu sahlo taco Zisu cawh sua aa pu khy nápawtah a bo he ka, Sabat ning tah ma cawngsawpaw cawh a dangsah maw dangsah ly takhah aa ngia thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Canghrasala, Zisu tah aa lungchung tei aa pacangpaw khah hnih thlang ka, a kih a songpaw hai leco, “Ming vytei hme lehei tho la, a daw,” tatah a tah. Taico tho ka, a daw. ");
INSERT INTO zypNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma khy taico Zisu tah aa hai letah, “Sabat ning tahei chahnah tua maw a phung a cang, chahlynah maw? Hringnah pachah heh maw a phung a cang, thaw heh maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A kaekang leteipaw sahlo cawh ming he ka, ma cawngsawpaw hai leco, “Na kih pathlang,” tatah a tah. Taico a kih cawh pathlang ka, a dang. ");
INSERT INTO zypNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Canghrasala, Farasi le phungbia cawngpahtu sahlo cawh aa thingae ngetei ka, Zisu cawh zekhatamaw tua he peh seh la, a cha a, tahpaw khah pakheh le pakheh aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ma cai leco Zisu cawh thlawchang rua pawtah tlaang cung lang ke ka, a zing zaikhuadui Khazing khatah thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mong khua va dui ka, a hningzuitu sahlo cawh y he ka, pahrawhluihning khah thing he ka, aaning sahlo cawh apostol rai a khing he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Piter tatei ming sahpaw) a unypaw Andru, Jeims, Johan, Filip, Barthalomeo, ");
INSERT INTO zypNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathai, Thomas, Alfas sawcapaw Jeims, ci le phing a dawkhuipaw Simon, ");
INSERT INTO zypNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jeims a sawcapaw Juda le Zisu a luitu paw Judas Iskariot a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zisu cawh aaning sahlo khaco seithlah ka, bai arainah letah a ung. Ama a hning a zuipaw he mehlupui le Judia raang le Jerusalem khuapui, Tair le Sidon khua rili ngaekang raang sahlo taitah mehlupui a va chuh he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A bia khah nawthlia rua pawtah le a sawnah pawhe zong dangsah rua pawtah aa va chua. Thlawpaw pialuipaw tei a tlepaw sahlo zong he tah dangnah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mehlupui tah Ama khah tong khy cy a zong he. Zecawtamaw tatah Ama taikhei hmingtuakhynah khah pia ka, aaning vytei cawh a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A hningzuitu sahlo cawh ming he ka, “Naaning sisahpaw sahlo bonghnang naa ting, Khazing painah raang cawh naa cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ato letei a ngai a dipaw sahlo bonghnang naa ting, naa ri a vaw tae a. Ato letei a cah leimeipaw sahlo bonghnang naa ting, na hnui tae he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Cawngsaw sahlo tah aa ca hua tih he tah bonghnang naa ting, Cawngsaw Sawcapaw a cawngsaw naa cangnah rawng tah ca patlia a he ka, naa zy ca lang a he ka, naa ming aa ca pachia tih he tah bonghnang naa ting. ");
INSERT INTO zypNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ma ning taco naa thawchah seh la, lunglawng thawchah tah a pathlo my lo, zecawtamaw tatah vaicung letah naa longmai rungnaw ngeteipaw a ung. Ma hrahei aaning aa pathlahtu sahlo he takhei Khazing khuavang sahlo khah aa za tua tei he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Canghrasala naaning mehrung sahlo naa cing a ping, zecawtamaw tatah a nawngnah cawh naa hmuh thlu thah. ");
INSERT INTO zypNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ato letei naaning a ri a vawpaw sahlo naa cing a ping, zecawtamaw tatah naa ngai a di tae a. Naaning ato letei a hnui leimeipaw sahlo naa cing a ping, naa ngechia a ka, na cah tae he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Cawngsaw maikaw tah aa ca pachaw tih he tah naa cing a ping. Ma hrahei aaning a pathlahtu sahlo tah khuavang pakheipaw sahlo khah aa za tua tei he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Canghrasala, ka bia naw a thliapaw sahlo, ka ca ching he hi, naa carae sahlo cawh va do la, a ca huapaw sahlo cung leco chahnah va tua my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chia a ca reipahpaw he sahlo cawh bonghnang song my lo, a ca zongtepaw sahlo cawh thlawchangpah my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pakheh kheh tah na bai rakheh lang a ca cabai caco, a rakheh lang zong khah cong pah vy thlang. Pakheh kheh tah na pai a ca lah pah caco, na angkilai lah zong ei kheh. ");
INSERT INTO zypNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","A ca haepaw maikaw cawh pei la, na hnuipaw a ca lah pahpaw he cawh hae kaw khawh khe lo. ");
INSERT INTO zypNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na cung letah tua he seh tah na dupaw hrakhei male cung letah va tua my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Naaning a ca dopaw suipaw naa do caco he zemaw amia naa hmuh a? Mehsua zong tah ma hapaw cawh aa tua thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naa cung letah a chahpaw cawngsaw cung letah naa chahpaw takhei zemaw amia naa hmuh? Mehsua zong tah ma hapaw cawh aa tua thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A ca pei kaw khypaw he hming naa hleipaw he takhei zemaw amia naa hmuh? Mehsua sahlo zong tahmai a ialia tah hmuh kaw rua taco aaning le aaning a hlei thlang hrah he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Canghrasala naa carae sahlo khah va do la, aa cung letah chahnah va tua my lo. Hmuh kaw hrah du tah male hming va hlei khe lo. Mataico longmai rungnawpaw hmuh a he ceh ka, Cungnungcai Khazing sawtei sahlo naa cang a he ceh. Zecawtamaw tatah Ama cawh mehsua le mehchawly cung letah a vei a sy. ");
INSERT INTO zypNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Naa Paw vaicung leteipaw tah zaangsawnah a ca hnuipaw he hratah zaang a saw cy my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Male bia cepah khe la, naaning zong biace pah cang hrá bei ceh. Ahohmai thaily va cangsah khe o, naaning zong thaily ca cangsah hrá bei he. Ngethai la, naaning zong ngethai na cang hrá he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pei la, peh na cang hrá he ceh. Achaw teitah neh pá tah, baichai tah, carawh pai tah a chihluinah tai peh naa cang he ceh. Na hmangpaw nehnah pawtei khei aa ca neh pah kaw hrá a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma tawchingnah bia zong heh a chingpai he, “Mehco tah mehco cawh lang a chui khy a maw? Aa pahning tah khobatlung lang tla bei he maw? ");
INSERT INTO zypNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A cawngpaw cawh a cawngpahtu cung letah ung be. Canghrasala, a tlungtlianah tai a cawng khy taitah a cawngpahtu hratah a cang hrah a. ");
INSERT INTO zypNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nama na mehkho letei thingphae khah pacang taw lytah na unypaw mehkho letei thingpatlaw khah zecawtamaw na mingpah? ");
INSERT INTO zypNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nama na mehkho chung letei thingphae khah a hmuh tlung lytah zekhatamaw na unypaw cawh, ‘Na mehbang khah ca tho pá neh,’ na tah khy? Naaning cungmai raipha sahlo naaning naa mehkho letei thingphae khah thohly taw la, taico naa unypaw a mehkho letei mehbang cawh tho pá pawtah a se pawtah na hmuh khy a. ");
INSERT INTO zypNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Thingkung cawh a kung a chah caco, a thui a chah, a kung a chiahru caco thui chia a thui. ");
INSERT INTO zypNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Thingkung maikaw cawh aa thui tah hni a cang he. Thuiku cawh ahling kung taitah lo bang bei he. A cang ly leh misur thui cawh ahling kung taitah lo bang hrah bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mehchaw taco a lungchung letei a pacungpaw a chawpaw taikhei hmingchaw chuasah ka, mehchawly taco a lungchung letei achaw lypaw a pacungpaw taikhei hming chahly a chuasah. A kaw taitei a reichuapaw cawh a lungchung letei a chihluipaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ka reipaw tua tlung lytah zecawtamaw, ‘Abuipaw, Abuipaw,’ tatah naa pa y? ");
INSERT INTO zypNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kama kha a vong katei, ka bia khah thui tah a zuipaw cawh zekhamaw a lo tahpaw ka ca ming sá he a. ");
INSERT INTO zypNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ma hapaw cawngsaw cawh ing a sahpaw, a thuh pui tah atung kho co katei, alung puino cung letei a bingpaw khatah a lo he. Khua a rupui tah va so ka, tuisai tah ing cawh nang ka, canghrasala a calawh be, achaw teitah sahpaw a cangnah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Canghrasala, kama khatah a vong katei, ka bia khah thuí tah a zui tlung lypaw cawh alui cakhawngpaw letei a tung padawpaw a cy lypaw ing khatah a lo. Khua a rupui tah va so ka, ing cawh a nang tihtah pohly palang ka, a dawngkasawny tah a rawh cehceh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Taico Zisu tah ma bia vytei cawh zawpui thuí tah a rei khy taitah Kapernaum khua lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma leco raebuipaw a saecapaw, a buipaw tei a do ngeteipaw cawh a sah ka, a thi daimang tei. ");
INSERT INTO zypNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma raebuipaw taco Zisu kong cawh a thui tihtah Juda macang thaikheh cawh taw he ka, Zisu cawh a vong seh la, a saecapaw heh va dangsah ky seh tatah va naw law a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Zisu kung aa va tlung tihtah hmuisui teitah naw he ka, “Ma cawngsaw heh bong tlang a tlahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kaa mingphing a dopaw cang ka, kaa synagog zong heh Ama tah a sahpaw a cang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Macawtaco Zisu cawh aaning khaco a sei. Ing a va phah daimang letah raebuipaw taco a vesaw sahlo cawh taw he ka, ma hrahei a va chingsah he. “Abuipaw, reithui a lah du kheh, ka ing heh nama na naenah tlangpaw cang be. ");
INSERT INTO zypNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Macawtaco kama zong nama kha a vong tlangpaw tah a rawh hrah bei neh. Canghrasala bia kaw kheh teitah na rei caco, ka saecapaw cawh a dang thlang a. ");
INSERT INTO zypNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kama zong nawhnuinah rai letah a ungpaw cang neh ka, ka rai letah raekeh sahlo a ung hrah he. Pakheh cawh, ‘Sei,’ tah neh ka, sei ka, pakheh cawh, ‘A vong,’ tah neh ka, a vong. Ka saecapaw cawh, ‘Ma heh tua,’ tah neh ka, a tua thlang,” tatah a chingsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Zisu tah ma bia cawh a thui tihtah a ningang ngetei ka, a va zuipaw he zawpui lang cawh a hui ka, “Biahmuisui ka ca ching he, Israel mingphing chung letah hmai ma tluh zingnah heh hmuh bang bei neh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mataico raebuipaw tei a tawpaw sahlo he khah ing aa va phah kaw tihtah a saecapaw khah a dang thahpaw khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma khy cangkaw tei leco, Zisu cawh Nain aa tahpaw khua lang khah a sei. A hningzuitu sahlo le zawpuipaw cawh Ama khatah a sei hrah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Khuapui a naenah hawkaw aa phah daimang ning taco mehthi rawh a ka songlai he ka, mehthi cawh lahmeno a hnuitlakangpaw sawcapaw a cang. Khuachung cawngsaw zawpui zong a no khatah a ka seilai hrah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Abuipaw tah lahmeno cawh a hmuh tihtah ningdo ngetei ka, “Cah kheh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Taico ka ke thlah ka, rawh kong cawh va tong ka, rawh kong a pupaw sahlo cawh a daw thlang he. “Satle, tho law, ka ca tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mehthi cawh a ty ka, bia a ka rei. Taico Zisu tah a no cawh a peh kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aa dawngkasawny tah ci he ka, aa ningang pai tah ka, Khazing khah aa reithai. “Kaa hrawng letah Khazing khuavang rungnawpaw a va paly hi, Khazing cawh a cawngsaw sahlo bong rua pawtah a vong myca hi!” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma Zisu kong heh Judia raang pungpaluh le a kaekang raang lekhei a thang thlu. ");
INSERT INTO zypNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johan hningzuitu sahlo taco ma konglang vytei khah Johan cawh aa ching. Johan tah a hningzuitu pahning khah y he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Abuipaw khatah ma bia heh hae rua pawtah a taw he. “Nama heh a vong lepaw cawh na cang maw? A cang ly leh ahringpaw maw kaa haw a?” tatah a va tahsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma cawngsaw sahlo cawh Zisu kung aa va tlung tihtah a hai leco, “Baptisma peitu Johan tah, ‘Nama heh a vong lepaw cawh na cang maw? A cang ly leh ahringpaw maw kaa haw a?’ tatah nama hae rua pawtah a ma sia,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma ningcai ceingei leco Zisu tah a sahpaw le a dang lypaw mehlupui le thlawpaw pialuipaw tei a tlepaw sahlo he cawh dangsah he ka, a mehcopaw zong khah khua a hmuhsah kaw he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Zisu tah Johan tei a va tawpaw he sahlo hai leco, “Va sei kaw la, naa hmuhpaw le naa thuipaw heh Johan cawh va ching my lo. Mehco sahlo tah khua aa hmuh, a songbepaw zong lang a sei he, thinghmuihri a ingpaw sahlo zong dang he ka, a naw a pangpaw sahlo tah khua aa thui. A thipaw zong tho kaw he ka, mehsisah zong tah thawngchawbia aa thui myca. ");
INSERT INTO zypNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kama ka kong letei lung langlo tah a ung lypaw cawngsaw cawh bonghnang a ting,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Johan tei a tawpaw sahlo aa sei khy taico Zisu tah zawpui sahlo hai leco Johan konglang khah a ching he. “Ze ming ruapaw tamaw raangcaa lang naa sei? Thli tei a taikalypaw tuiphi kung ming ruapaw tamaw? ");
INSERT INTO zypNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma hratei a cang ly caco, ze ming ruapaw tamaw naa sei? Chaichi chaw a tuapaw cawngsaw ming ruapaw tamaw? Cang tlung be, chaichi amai a rupaw a tua katei, hmingchaw sangsaw a hnuipaw he cawh siangpahrang ing letah pui aa ung ky caw! ");
INSERT INTO zypNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A cang caco, ze ming ruapaw tamaw naa sei? Khazing khuavang ming ruapaw tamaw? A cang, Khazing khuavang navy tah a lai vypaw kong ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ma heh Khazing bia letei ciapaw Ama a kong cawh a cang, ‘Ka tlang ypaw cawh na hmelang ka taw a, na hme letei na langpui a parai ruapaw tah!’ ");
INSERT INTO zypNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ka ca ching he hi, canu tei sahpaw saw leco Johan navy tah alai vypaw ahohmai ung bei he, canghrasala Khazing painah raang letei a chia caipaw hmai heh Johan navy tah alai vy,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cawngsaw vytei ngungkhui a kheipaw sahlo takhei hmai, Zisu bia cawh aa thui tihtah Khazing langpui a ding tahpaw khah aa lung a tling. Zemaw tah pawco, aaning sahlo cawh Johan tei baptisma a peh ciapaw sahlo aa cangnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Canghrasala, Farasi le phungbia a thai ngeteipaw sahlo he taco Khazing tei aa cawtah khua a khang pahpaw he khah aa ei. Zecawtamaw tatah aaning sahlo cawh Johan baptisma hmai a cang balang bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zisu tah, “Atochai cawngsaw heh zekhatamaw ka tawching he a? Zekhamaw a lo he? ");
INSERT INTO zypNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Aaning sahlo cawh chodo tlang letei a ty thlangpaw nyheh sahlo khatah a lo he. ‘Phipahli ca tungpah he peh ka, naa lang tlung be. Mehthi hlawsah he peh ka, naa caw tlung be,’ tatah aaning leh aaning a tahpaw nyheh sahlo khatah a lo he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zecawtamaw tatah baptisma peitu Johan cawh va chuh ka, very e lytah le misurhang ding lytah ung ka, ‘Khachia tah a pahrang,’ tatah naa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Cawngsaw Sawcapaw a vong ka, e ka, ding ka, ‘Ding le e suipaw a pacang, mehsua sahlo le ngungkhui a kheitu sahlo vesaw,’ naa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Canghrasala, singnah cawh a hming tuapaw sahlo takhei ahmang takhah a palang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farasipaw a cangpaw pakheh tah Zisu cawh zaibatui e pawtah a hrui. Macawtaco, Farasipaw ing lang cawh a vaw ka, e pawtah a ty. ");
INSERT INTO zypNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Canu pakheh mehsua ngetei no, ma khua letei a ung hrahpaw taco Zisu cawh Farasipaw ing letah zaibatui a e leimei tahpaw khah a thui. Sathy ringthopaw cawh lungrang tuithei khei a va tle. ");
INSERT INTO zypNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Taico a hninglang tah a phe hrang leco a daw ka, cah ka, a phe cawh a mehthli tah pacingsah thlu ka, ma khy taico a sang tah hruh ka, a phepazaw cawh hnang ka, ringthopaw cawh a bia. ");
INSERT INTO zypNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Zisu zaibatui e a hruipaw Farasipaw taco, ma cawh a hmuh tihtah a lungchung tah, “Ma cawngsaw heh Khazing khuavang a cang caco, a phe a hre leimeipaw heh ahomaw a cang, zehapaw canu maw a cang tahpaw heh a hni ruapaw a cang, mehsua no cang tlung ka,” tatah a pacang. ");
INSERT INTO zypNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Zisu taco, “Simon, bia ka ca ching dupaw a ung,” a tah. Farasipaw Simon taco, “Cawngpahtu, pa ching tua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Zisu tah, “Cawngsaw pahning tah khalui hnui he ka, pakhehpaw tah ngung tangka 500, pakhehpaw tah ngung tangka songngaw tatah lui aa bah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aa pahning taco aa khalui cawh chang khy va vei lytah aa ung. Macawtaco tangka a hnuitupaw taco a ngethai va vei he. A cang caco, aaning pahning lekhei aho tamaw a do vy a, tatah na rawh?” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon taco, “A hlu vy a ngethaipaw khah a cang thly a, tatah ka rawh,” tatah a chai. Zisu tah, “Na rawhpaw a hmang ngetei,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mataico Zisu cawh cawngsawno lang cawh a hui ka, Simon hai leco, “Ma no heh na hmuh maw? Na ing chunglang ka za naening tah phe sinah ruapaw tui pa pei bei ceh. Canghrasala ma cawngsawno tahei co ka phe heh a mehthli tah si ka, a sang tah a hru. ");
INSERT INTO zypNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nama taco pa hnang bei ceh, canghrasala ma no tahei co ka za naenah taikhei ka phe hnang khah tai be. ");
INSERT INTO zypNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nama taco ka lu letah zong sathy pa thu bei ceh, canghrasala ma no tahei co ka phe letah ringthopaw a bia. ");
INSERT INTO zypNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ma rawng tahei ka ca ching, a suanah a hlu ngeteipaw cawh ngethai a cang myca, macawtaco cawngsawno takhei a do ngetei. Canghrasala, a cawngtei ngethai a cangpaw taco a cawngtei tah a do hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mataico Zisu tah cawngsawno cawh, “Na suanah cawh ngethai a cang thah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aa hrong letei a ung hrahpaw khuachai sahlo taco, “Suanah hmai a ngethaipaw heh ahomaw a cang?” tatah aaning le aaning khah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Zisu tah cawngsawno cawh, “Na zingnah tah a ca pachah thah, thlawlung teitah va sei my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma khy taico Zisu cawh khuapui le khuatei tlawnglai longmang ka, Khazing painah raang kong thawngchawbia cawh a y khui lai. A hningzuitu pahrawhluihning khah Ama khatah a sei hrah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Canu thaikheh, a sawnah taitah a dangsahpaw sahlo le thlawpaw pialuipaw a papia pahpaw he sahlo zong Ama khatah a ung he. Ma canu sahlo hrong leco thlawpaw pialuipaw sangsarih a papia pahpaw Mari (Makdalin aa tahpaw) le, ");
INSERT INTO zypNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herod cho a mingkaitu Kuza a nupuino Joana le Susana le ahringpaw sahlo a cang he. Ma sahlo cawh aaning aa hnuicho teitah Zisu le a hningzuitu sahlo a bawkhangpaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Khua keh ná tah mehnung hlupui Zisu khatah a vong he ka, a pahmo ning he takhei ma tawchingnah bia heh a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ly a tuapaw pakheh cawh thleci va pawtah ly lang a sei. Thleci a va leimeining takhei a chy cawh lang kae letah tlah ka, cawngsaw tah aa phe tah ci he ka, pavaw sahlo tah aa khi thlu thah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A chy cawh lungda letah tlah he ka, aa ka cy tihtah aa thahrang aa thlah nápaw alui a pacingpaw a ung lynah cawtah a ro kaw palang thah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A chy cawh ahling hrong letah tlah he ka, ahling khaco cyhrui he ka, ahling taco a diseh thah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A chy cawh alui chahnah letah tlah ka, ka cy ka, a thuisu tua ka, a vapaw navy tah a leh zakheh tah a hlu vy a chuh.” Ma bia heh a thangpui tah rei ka, “Thuinah nawkho a hnuipaw taco ma bia heh thui he seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A hningzuitu sahlo taco ma tawchingnah bia silang cawh aa hae hri. ");
INSERT INTO zypNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Zisu tah aa hai leco, “Khazing painah raang biaparuh hni khynah cawh peh na cang thah he ceh. Canghrasala, ming hringpaw hai leco tawchingnah bia tah ka rei. Macawtaco, ‘Ming thlang he ka, hmuh a bei he, thui thlang he ka, hnih thai a bei he.’ ");
INSERT INTO zypNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tawchingnah bia silang cawh ma heh a cang. Thleci cawh Khazing bia heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Langpui letei a tlahpaw sahlo cawh bia cawh thui he ka, Setan khah a vong ka, zing tah pachah aa cang ly nápawtah bia cawh aa lungchung taitah a lah pah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lungda cung letei a tlahpaw sahlo cawh Khazing bia cawh thui he ka, lunglawng teitah aa cyhlang. Canghrasala, thahrang hnui bei he. Aa zingnah cawh sungkheh tei cai caw longlong cang ka, ruhanah a chua tihtah a pohly palang he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ahling hrong letei a tlahpaw thleci sahlo asilang cawh Khazing bia cawh thui he ka, canghrasala tungtuh khuasahnah lungreithuinah le rungnah le anawngnah tah diseh kaw thlu he katei, aa pui a tling thai lypaw cawngsaw sahlo khah a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Canghrasala, alui a chahnah letei a tlahpaw sahlo cawh lung hmuisui teitah Khazing bia cawh thui he ka, a tle he ka, a thuisu a tuanah tai teria teitah aa zuipaw cawngsaw sahlo khah a cang he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zisu taco, “Ahotahmai tah me-ing a vang tihtah lakhing rai letah maw abai rai letah maw chia bang be. Ing chung lang a naepaw maikaw tah a khaipaw aa hmuh khy nápawtah me-ing tung letah aa chia tei. ");
INSERT INTO zypNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Palang ly rua pawtah nopaw hming zehmai ung be. Taico hni ly rua pawtah paphipaw zehmai ung be, palangsah thlu a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Macawtaco naa nawthliapaw khah achaw teitah pacang my lo. A hnuipaw cawh peh vy cang a he ka, a hnui lypaw cawh a hnuitlakangpaw tatei a rawhpaw hmai khah lah pah a cang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Taico, Zisu a no le a uny sahlo cawh Ama khah a tong rua pawtah a vong he. Canghrasala, cawngsaw aa hlutunah cawtah a va nae khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Cawngsaw pakheh tah Zisu cawh, “Na no le na uny sahlo tah a tong ca du he ka, khunglai letah a daw thlang he,” tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Zisu taco, “Khazing bia thui ka, a zuipaw sahlo heh ka no le ka uny sahlo cawh a cang he,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ningkheh cawh Zisu tah a hningzuitu sahlo cawh, “Galili tuiping raechai lang sei he pei,” a tah he. Macawtaco tuilawng chunglang cawh a nae he ka, aa sei. ");
INSERT INTO zypNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tuilawng tah aa seilai leimeining taco Zisu cawh a ihning. Tuiping leco thlichia a va hrang ka, aa lawng cawh tui lang a nong thlu daimangnah cawtah ciphang ngetei tah a ung he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A hningzuitu sahlo tah Ama cawh va patho he ka, “Hruitupaw, Hruitupaw, tui lang kaa tlah thlu he peh hi,” tatah aa tah. Zisu cawh ka tho ka, thli le tuileh cawh a hrangso he ka, thli cawh de ka, tui cawh a cali he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Naa zingnah cawh zeletamaw a ung thlu?” tatah a hningzuitu sahlo cawh a tah he. Ci le ningang hmotah, “Ma heh zehapaw cawngsaw maw a cang? Thli le tuileh zong tah a bia aa nge thlangpaw heh,” tatah pakheh le pakheh a tah tlungmang he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galili tuiping raechai lang letei a ungpaw he Gerasin raang cawngsaw sahlo aa ungnah cawh aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zisu cawh ngaekang lang a cungthlah cangkawleh ma khua letei a ungpaw khachia tei a tlepaw cawngsawpaw taco a va tong. Ma cawngsawpaw heh a thlekalong tei a ungpaw, ing letah zong a ung lypaw, thlaikung letah a ungteipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Zisu a hmuh cangkawleh sang ka, a phehrang leco a bawh ka, a thangpui tah a y. “Cungnungcai Khazing Sawcapaw, Zisu, kama khatah zemaw na dupaw a ung? Pa hreh haitei kheh tatah ka ca naw,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A chung letei thlawpaw pialuipaw khah ka pia tatah Zisu tah bia a peh cawtah khei a cang. Ma paw cawh uihlupui khachia taco, a hraipakingnah cawtah a kih le a phe letah bahrairui tah khi he ka, aa vai. Bahrairui tah aa hrai naná teitah chehchung thlu ka, khachia taco lyraangpaw lang a tingchua tei. ");
INSERT INTO zypNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zisu tah, “Na ming ahomaw?” tatah a hae. “Ka ming cawh Thongzakheh a cang,” tatah a palei. Khachia a hlupui tah aa pahrangnah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Taico khachia sahlo taco, Zisu cawh a ping thai lypaw khobatlung lang ma thlah haitei kheh tatah aa naw canei leimei thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aa kae tlangpa lekhei lawh a e leimeipaw voh rungpui ung he ka, khachia sahlo taco Zisu cawh ma voh rung sahlo aa chunglang kheh a ma naesah thlang, tatah naw he ka, Zisu tah a naesah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Khachia sahlo cawh ma cawngsawpaw chung taico piathlah he ka, voh chunglang cawh a nae he. Voh rungpui sahlo cawh tuiping lang a zythlah he ka, a thi thlu he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Voh rungpui a mingkaitu sahlo taco ma hming vytei cawh aa hmuh tihtah sai tlamang he ka, khuapui chung le khuatei lekhei aa rei lai. ");
INSERT INTO zypNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Taico zawpui sahlo cawh piathlah he ka, zehratamaw a cang tahpaw khah ming rua pawtah a sei he. Zisu kung aa va tlung tihtah khachia sahlo tei, aa piasaipaw cawngsawpaw khah aa va hmuh. Lungsing teitah caise a tua katei, Zisu kae letah a za tythlangpaw khah aa hmuh. Macawtaco aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A hmuhpaw cawngsaw sahlo taco, khachia sahlo tei aa tlepaw cawngsawpaw a dangnah kong khah cawngsaw hringpaw aa ching lai he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mataico Gerasin raang letei a ungpaw cawngsaw vytei taco aa ci tunah cawtah Zisu khah aa raang taitah piathlah a pawtah aa naw. Macawtaco tuilawng chunglang cawh a nae ka, a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Khachia sahlo tei aa piasaipaw cawngsawpaw taco, “Nama khatah ka seilai hrá a,” tatah naw ka, canghrasala, Zisu taco kawsah kaw ka, a hai leco, ");
INSERT INTO zypNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ing lang a dih la, Khazing tah zetlua tamaw na cawtah hming a ca tuapah tahpaw khah va ching hri law,” a tah. Mataico cawngsawpaw cawh piathlah ka, Zisu tah zetlua tamaw a cawtah hming a tuapah tahpaw khah khua cawngsaw vytei cawh a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zisu cawh a va kaw kaw tihtah cawngsaw hlupui tah dai he ka, aaning sahlo cawh a va tlungpaw a heh thlangpaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Taico Jaira aa tahpaw synagog a uhtu cawh a vong. Zisu a phehrang leco a bawh ka, a ing lang a vong rua pawtah a naw. ");
INSERT INTO zypNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","A sawcanu hnuitlakangpaw, kung hrawhluihning a tah no cawh a thih daimangnah cawtah a cang. Zisu a seilai ning taco zawpui tah buh thlang he ka, aa nanghly pai lai leimei he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma leco canu pakheh kung hrawhluihning chung a thi a chuh no ung ka, a hnuicho vytei sibui letah pachang thlu thah ka, ahotahmai dangsah khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Zisu a hninglang tah a vong ka, a pai dong cawh tong ka, ma cangkaw leco, a thi cawh a kih. ");
INSERT INTO zypNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Ahomaw a pa tong?” tatah Zisu tah hae he ka, aa dawngkasawny teitah ca tong bei peh aa tah. Piter taco, “Hruitupaw, zawpui tah ca buh thlang he ka, aa ca nangpaipaw a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Canghrasala, Zisu tah, “Pakheh kheh tah a pa tong, ka chung taitah hmingtuakhynah a pia, ma rawng taco ka hni,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mataico canuno taco Zisu tah a pa hni myca tahpaw a hni tihtah a thlawzawng ka, a phehrang leco a bawh ka, zawpui hme leco a cangnah silang le sung sungkheh tah a dangnah kong khah a ching. ");
INSERT INTO zypNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mataico Zisu tah a hai leco, “Ka sawcanu, na zingnah tah a ca dangsah, de teitah va seí my lo,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zisu tah bia a rei leimei ning taco, synagog a uhtu Jaira ing taico cawngsaw pakheh a vong ka, “Na sawcanu cawh a thi thah, cawngpahtu heh hnahnawh du khawh kheh,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma bia cawh Zisu tah thui ka, Jaira hai letaco, “Na thlawzawng kheh seh, zing la, na sawcanu cawh a dang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jaira ing cawh a va phah tihtah Piter le Johan le Jeims le nyno a no le a paw tah cy ly co ahohmai ing chunglang a naesah bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma chung vytei cawh cawngsaw hringpaw taco nyno cawh ngechia tah aa cawkhui leimei. Zisu tah, “Cah tua khe o, nyno heh a thih tlung be, a ihning hi!” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A thi tahpaw aa hni thlangnah cawtah khei Zisu cawh aa hnuiso. ");
INSERT INTO zypNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Canghrasala, Zisu tah nyno cawh a kiá tah tle ka, “Ka sawcanu, tho law,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A thlawpaw cawh va kaw kaw ka, ma cangkaw leco, nyno cawh a ka dawchua. Taico Zisu tah aaning sahlo cawh nyno heh e ruapaw sangkheh kheh pei my lo, tatah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A no le a paw cawh aa khuarawha thlang ka, canghrasala, Zisu tah aaning cawh hming ungzia khah ahohmai ching khe lo, tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zisu tah apostol hluihning cawh Ama khatah a y he. Khachia vytei papia lai pawtah le asawnah vytei zong dangsah lai pawtah nawhnuinah le hmingtuakhynah pei he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","aaning cawh Khazing painah raang kong reilai rua pawtah le a dang lypaw sahlo zong dangsah lai rua pawtah a taw he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aa hai leco, “Khua tlawngnah caw pawtah cungcahrei, sahre, chingco, tangka le cai le se a hluipaw zehmai a cakai khe o. ");
INSERT INTO zypNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Naa naenah pawhe ceh ing leco ma khua taitei naa seithlah kaw hlai vytei cawh ung thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma khua cawngsaw taco aa ca cyhlang du ly caco he aaning sahlo raering pehnah tah ma khua taico naa piathlah tihtah naa phe letei luipadih khah cathingthlah si my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Taico aaning sahlo cawh piathlah he ka, khua kheh hning khua khé co sei lai he ka, aa seilainah maikaw leco, thawngchawbia rei lai he ka, a dang lypaw sahlo zong aa dangsah lai he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Abui Herod taco hming ungzia vytei cawh a thui tihtah a lung hna a hnawh ngetei. Zecawtamaw tatah baptisma peitu Johan khah thihnah taitah a tho kaw tatah mehthaikheh tah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Thaikhehpaw sahlo taco Elija a paly tatah aa tah. Mehthaikheh huipaw taco khuahlaining tei Khazing khuavang letei pakhehkheh khah a hring kaw aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Canghrasala Herod taco, “Johan cawh a lu ka tai thah tlung, ma hratei a kong ka thuipaw heh ahomaw a cang!” a tah. Ma cawngsaw cawh hmuh a pachia. ");
INSERT INTO zypNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostol sahlo cawh aa va tlung kaw tihtah aa tuapaw hming kong khah Zisu cawh aa ching. Taico aaning sahlo cawh a chui he ka, Bethsaida aa tahpaw khua lang cawh aaning teitah aa sei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Canghrasala zawpui taco ma cawh hnih he ka, Ama cawh aa zuilai. Zisu tah zawpui vytei cawh achaw teitah mingkai he ka, Khazing painah raang kong khah ching he ka, dangnah a hiapaw sahlo khah a dangsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zailang ning a tlah cai letah apostol hluihning cawh Ama khatah a vong he ka, “Ma lehei ung nápaw le e ruapaw zong ung be. Macawtaco zawpui vytei heh na disah pawhe a cang. Kaa kaekang khua le ly sahlo lehei ungnah le e ruapaw a va hui he seh, zecawtamaw tatah kaa ungnah heh raang kingdang cang tlung ka,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Zisu taco, “Naaning tah e ruapaw cawh pei o,” a tah he. Aaning taco, “Ma vytei cawngsaw e ruapaw tahei kaa va cawh seh tah lypaw co, kaaning khaco very tlangpangaw le ngaw sanghning long kaa hnui!” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Capaw puitling longtei tah 5000 hrawng a tah he. Canghrasala Zisu tah a hningzuitu sahlo cawh, “Zawpui khah songngaw phu longmang tah a tysah o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A reipaw hratah hningzuitu sahlo taco tua he ka, ming vytei cawh a ty he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Very tlangpangaw le ngaw sanghning cawh law ka, avai lang a y ka, Khazing khatah lawngbia hlai ka, very tlang sahlo cawh a kychy. Mataico a hningzuitu sahlo cawh zawpui cawh rai pawtah a peh he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aa zongmingtei co e he ka, aa ri a vaw thlu. Taico a hningzuitu sahlo taco aa ebangpaw cawh pakhong he ka, baihraw hluihning chih ky tah aa dui. ");
INSERT INTO zypNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Uikheh cawh Zisu cawh Ama teitah thlaw a chang leimeining takhei a hningzuitu sahlo cawh Ama khatah a ung thlang he. Zisu tah a hningzuitu sahlo cawh, “Zawpuipaw tah aho aa pa tah maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aaning sahlo taco, “Thaikhehpaw tah baptisma peitu Johan aa ca tah, thaikhehpaw tah Elija a cang ca tah he ka, ahringpaw taco khuahlai tei Khazing khuavang sahlo letah pakheh kheh khah a va hring kaw aa ca tah,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Zisu tah, “Naaning tah saw aho a cang naa pa tah maw?” tatah hae he ka, Piter tah, “Nama cawh Khazing taitei a vongpaw Khri na cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Zisu tah aaning sahlo cawh ma kong heh ahohmai ching ly rua pawtah araeringnah a peh he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Taico Zisu tah, “Cawngsaw Sawcapaw heh taithuinah a hlupui ing ka, macang sahlo le tlangbui macang sahlo le phungbia cawngpahtu sahlo tah hlawh a he ka, aa thaw a. Canghrasala, a ningthungnah letah hringnah letah thosah kaw a cang a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mataico aa zongmingtei hai leco, “Ahohmai zui a pa dupaw cawh ama a dunah khah seisai seh la, a khraws cawh ning tating tah a puh seh la, pazui seh. ");
INSERT INTO zypNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","A hringnah pachah a dupaw taco sung a ka, canghrasala Kama ka cawtah a hringnah a sungpaw taco a hringnah a pachah a. ");
INSERT INTO zypNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cawngsaw pakheh tah khazaw heh a pungpaluh tah hnui seh la, a hringnah a hly caco a cawtah zemaw a chahnai a? ");
INSERT INTO zypNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ahohmai Kama le ka cawngpahnah bia a zawkhuipaw maikaw cawh Cawngsaw Sawcapaw heh vaicung letei vaiming pathai sahlo khatah a rungnawnah le Paw rungnawnah kha a za cung tihtah ma cawngsaw cawh a zawkhui hrá a. ");
INSERT INTO zypNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Biahmuisui ka ca ching he, ma lehei a daw thlangpaw sahlo hrong lehei mehthaikheh cawh Khazing painah raang aa hmuh hlai taco thi balang bei he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Zisu tah ma bia a rei khy taitah ningreh hrawng lekhei Piter, Johan le Jeims cawh Ama kha a chui he ka, thlawchang rua pawtah tlaang cung lang a kekhui he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Thlaw a chang leimeining tah a mehme pho zia cawh a thlai ka, a caise sahlo cawh lailaw a ky ning tei, akhaipaw tluá khei a khai. ");
INSERT INTO zypNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Cawngsaw pahning Moses le Elija cawh, ");
INSERT INTO zypNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","vaicung rungnawnah khatah a za lang he ka, Zisu khatah bia aa rei. Jerusalem khuapui letah a thihnah thongtah Khazing a tingaipaw a patling nápaw kong khah aa rei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piter le a vesaw sahlo cawh a ihning he ka, canghrasala a ka hraw tih he tah a rungnawnah le cawngsaw pahning Ama khatah a daw thlangpaw he khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cawngsaw tlaw tah Zisu cawh aa seisai leimeining tah Piter taco a hai letah, “Hruitupaw, ma lehei ung heh kaa cawtah a chah ngetei. Thlangda nama na cawtah sangkheh, Moses a cawtah sangkheh, Elija a cawtah sangkheh tatah sangthung sah a he peh,” a tah. (Piter cawh zemaw ka rei tahpaw hmai hnih be.) ");
INSERT INTO zypNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A rei leimeining taco meding va thang ka, aaning cawh pahlong he ka, meding chung letah aa ungnah cawtah aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Meding chung taico o va ring ka, “Ma heh ka Sawtei, ka thingpaw cawh a cang. Ama a bia cawh nge my lo,” tatah o a za ring. ");
INSERT INTO zypNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","O tah ma hratei a rei khy taico Zisu cawh Ama longtei a cangpaw khah aa hmuh. A hningzuitu sahlo tah ma cawh aa chung letah a cingkai thlang he ka, aa hmuhpaw kong khah ma ning taco ahohmai ching bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A ningthlamongpaw tlaang cung taitah aa za cung chuh ning takhei cawngsaw rungpui taco Zisu cawh a va tong he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Zawpui chung taico pakhehpaw cawh ka ychua ka, “Cawngpahtu, ka sawtei pa mingpah tua tatah ka ca naw, Ama heh ka sawtei hnuitlakangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Thlawpaw pialuipaw tah tua ka, sung sungkheh tah sangsah ka, hruipakingsah ka, a ci tatabu zong a pia thlu tei. Cai cuitei suipaw piasai ka, a hlyde daimang tei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma cawh papia rua pawtah na hningzuitu sahlo naw he neh ka, canghrasala papia khy bei he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Zisu taco, “Vy zingnah a hnui lypaw le meh paleh meh pathae sahlo, zetih tai maw naaning khatah ka ung a? Zetih tai maw ka lung ka ca pasua pá he a? Na sawtei cawh ma lehei a vong khui tua,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nyhehpaw cawh a va sei leimeining takhei hmai khachia taco alui letah paliahly ka, a hruipakingsah. Canghrasala Zisu tah thlawpaw pialuipaw cawh a hrangso ka, nyhehpaw cawh dangsah ka, a paw khakhei a peh kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Taico aaning vytei cawh Khazing a rungnaw zia khah aa khuarawh a haa. Ming vytei cawh Zisu a tuapaw hming kong letah khuarawha tah aa ung thlang ning taco Zisu tah a hningzuitu sahlo cawh, ");
INSERT INTO zypNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Naaning ka ca ching lepaw he bia heh achaw teitah nawthlia tua o. Cawngsaw Sawcapaw heh cawngsaw sahlo kih letah luithae a cang myca a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Canghrasala, a hningzuitu sahlo taco a rei dupaw khah hnih thai bei he. A silang khah nokhai aa cangnah cawtah khei tle khy be ca he ka, hae hri ngang bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A hningzuitu sahlo cawh aa hrong letah ahomaw alai caipaw a cang a tahpaw bia khah a ei hrang aa patho. ");
INSERT INTO zypNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aa rawhnah cawh Zisu tah hnih ka, nyhehpaw tei khah law ka, a kae letah a dawsah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mataico aa hai letah, “Ahohmai Kama ka ming tah ma hapaw nyhehtei heh a cyhlangpaw cawh Kama a pa cyhlangpaw cang ka, Kama a pa cyhlangpaw cawh a pa tawtupaw a cyhlangpaw a cang. Naa hrong letei a chia caipaw heh alaicaipaw cawh a cang a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johan taco, “Hruitupaw, cawngsaw pakheh tah na ming tah khachia a papia leimeipaw hmuh he peh ka, kaa bu cawngsaw a cang lynah cawtah kaa thly,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Zisu tah, “Thly khe o, a ma cakhae lypaw maikaw cawh naa cawngsaw a cang he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Vaicung lang lahchy a cang nápaw cai khah a nenah cawtah khei, Zisu cawh Jerusalem lang sei pawtah a pachia. ");
INSERT INTO zypNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mataico zuaky sahlo khah hmelang a seisah hlang he. Aaning cawh a cawtah hming pachiapaning hlang rua pawtah Samaria cawngsaw aa khua lang khah a nae he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Canghrasala Zisu cawh Jerusalem lang sei a tingnah cawtah khei ma khua letei cawngsaw sahlo taco pasungpanaw bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma cawh a hningzuitu Johan le Jeims tah aa hmuh tihtah a hai letah, “Abuipaw aaning sahlo a kangseh ruapaw he tahei avai taitah me za tlahsah peh seh la, tahpaw na ma dukhui maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Canghrasala Zisu cawh a hui ka, aaning sahlo cawh a raw he. ");
INSERT INTO zypNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Taico aaning sahlo cawh khua hring lang aa sei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Langpui letah aa seilai leimeining taco cawngsaw pakheh tah, “Na seinah maikaw lang ka ca zui a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Zisu tah, “Sihatei sahlo tah kua hnui he ka, pavaw sahlo zong tah bu aa hnui. Canghrasala Cawngsaw Sawcapaw cawh a lu pahnia nápaw hminghmaw hmai hnui be,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Cawngsaw hringpaw pakheh cawh, “Va pa zui law,” a tah. Canghrasala ma cawngsaw taco, “Abuipaw, va seí neh ka, ka paw ka va phung taw a,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Zisu tah a hai letah, “A thipaw cawh mehthi tah phung thlang he seh, nama duitei cawh sei la, Khazing painah raang thawngchawbia va rei my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Cawngsaw pakheh a vong vy hui ka, “Abuipaw, na seinah maikaw letah ka ca zui a. Canghrasala, kaw kaw taw neh ka, ka sawny aa kih ka tlesi taw he a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zisu tah, “Ahohmai alui paleh patho tlung katei, a hninglang a hui kaw leimeipaw cawh Khazing painah raang letah rai a hre tlangpaw cang bei he,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma khy taico Abuipaw tah a hningzuitu ahringpaw songsarih le pahning khah thing he ka, pahning longmang tah Ama a sei nápaw khua maikaw le hminghmaw maikaw lang khah hmelang a thlaw hlang he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aa hai leco, “Saze hre ruapaw hlu ngetei ka, canghrasala a hretu cawh a cawngtei he. Macawtaco saze lui a hnuitu Abuipaw cawh raihretu sahlo khah saze lui lang taw rua pawtah hae my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sei tua o, naaning sahlo cawh chahnia hrong letei tuu teitei sahlo hratah ka ca taw he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tangkabawng cang seh, sahre cang seh, phepakong cang seh a cakai khe la, lang letah ahohmai aa kih tle khe lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ing na nae tih he ceh tah ahmasaw cai tah, ‘Ma ing lehei denah ung ky seh,’ tah my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma cawngsaw cawh denah sawtei a cang caco, naa reipaw denah cawh a cung letah a tlung a, ma hratei a cang ly caco naaning naa cung lang a va kaw kaw a. ");
INSERT INTO zypNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma ing leco ung la, aa ca pehpaw he maikaw khah e la, ding thlang my lo. Raihretu cawh a raihrenah mai hmuh rua tah a tlah. Ingkheh hning ingkheh a palong lai khe lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Khuachung lang a nae he ceh ka, ingtlung aa ca pa-awng tih he tah aa ca pehpaw he maikaw khah e thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A dang lypaw sahlo khah dang sá la, Khazing painah raang tah a ca ne my ca he, tatah ching my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Canghrasala, khuachung a nae he ceh ka, ingtlung aa ca pa-awng ly caco he, langlaipui sahlo lekhei sei la, ma hrahei tah my lo, ");
INSERT INTO zypNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Naa khua luipadih kaa phe letei a kapaw hmai kaa cathingthlah hi, ma duitei cawh ma heh hnih my lo. Khazing painah raang cawh a ne myca,’ tatah tah my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma heh ka ca ching he, biacenah ning taco ma khua navy co Sodom khua tai-ingnah hmai khah a zia a ung vy a. ");
INSERT INTO zypNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Vy Korazin khua na cing a ping! Vy Bethsaida khua na cing a ping! Naaning letei tuapaw ningang chuipaw hming khah Tair le Sidon khua letah tuapaw cang he seh la, buri pai a buh a tah mecang letah a ty a he ka, a ngepachih syly tha he a. ");
INSERT INTO zypNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Canghrasala, biacenah ning leco Tair le Sidon khua tei aa ingpaw cawh naaning navy tah a zia a ung vy tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Taico, nama Kapernaum khua, avai tai kheh calia na cang maw? Cang bei ceh. Hraihming lang na tlahthlah a. ");
INSERT INTO zypNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Naa rei a ca ngepaw maikaw he cawh kama ka rei a pa ngepaw a cang he. Naaning a ca hlawhpaw maikaw he cawh kama a pa hlawh paw a cang he. Canghrasala kama a pa hlawhpaw maikaw he cawh a pa tawtu a hlawhpaw a cang he,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Songsarih le pahning tlaw he khah lunglawng teitah va tlung kaw he ka, “Abuipaw, khachia vanghru sahlo zong tahmai na ming tah kaa rei aa ma nge,” tatah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Zisu tah, “Setan khah lailaw hratah vaicung taitei a za tlahthlahpaw ka hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pari sahlo le tlangcekawng sahlo zong tlaipabainah naw le naa caraepaw te khynah naw ca pei he neh ka, zetahmai a ca sawsah khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma duitei cawh thlawpaw pialuipaw zong tah naa rei aa ca nge caw he tah a lawng khe o. Canghrasala vaicung letah naa ming cia a cangnah cawtah a lawng hri my lo,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma ningcai leco Zisu cawh Thlawpaw Pathai thongtah a lawng ngetei ka, “Ka Paw, alui le avai Buipaw, ka ca reithai, mehthai mehsing sahlo caw taco, ma hming sahlo heh nawh ceh ka, nyheh hapaw sahlo khatah na palang. A cang, ka Paw, ma cawh nama na lawngnah cawh a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Zisu cawh ma hratei thlaw a chang khy taico zawpui sahlo lang cawh ma hrahei bia rei ka, “Hming vytei heh ka Paw tah a pa peh thlu thah he. Paw tah ly co Sawcapaw heh ahomaw a cang tahpaw ahotahmai hnih bei he. Taico, Sawcapaw le Sawcapaw tei hnisah rua pawtah a thingpaw he tah ly co Paw cawh ahomaw a cang tahpaw ahotahmai hnih bei he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mataico, a hningzuitu sahlo lang khah a hui ka, aaning ei teitah ching he ka, “Naa hmuhpaw hming a hmuhpaw mehkho sahlo cawh bonghnang aa ting. ");
INSERT INTO zypNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Biahmuisui ka ca ching he, Khazing khuavang le abui sahlo mehlupui tah naa hmuhpaw heh hmuh aa du ngetei cy hrah naná teitah hmuh bei he. Naa thuipaw heh thui aa du ngetei hrah naná teitah za thui bei he,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Uikheh cawh phungbia a thai ngeteipaw pakheh cawh Zisu pase du tah a daw ka, “Cawngpahtu, chaizaw hringnah ka hmuh khy nápawtah zemaw ka tua a?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Zisu tah, “Khazing phungbia letah zemaw a cia? Zekhatamaw na hni?” tatah a hae hri kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Phungbia a thai ngeteipaw taco, “ ‘Abuipaw na Khazing khah na lungthing vytei, na hringnah vytei, na thawzaang vytei le na khuarawnah vytei tah do my lo.’ Mataico, ‘Nama na dopaw hratah na ingpaw khah do my lo,’ tahpaw he a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zisu tah, “Na pachaipaw ahmang ngetei, ma hraco va tua la, na hring a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Canghrasala, ama teitah thai a cangsah khah a dunah cawtah, “Ka ingpaw cawh ahomaw a cang?” tatah a hae kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zisu tah palei ka, “Cawngsaw pakheh Jerusalem khua taitah Jeriko khua lang a seithlah. Ma langpui leco damia sahlo tah hrawh he ka, a caise vytei pahlu pah thlu he ka, thi daimang tah aa dai khy taitah aa seisai. ");
INSERT INTO zypNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tlangbui pakheh cawh ma lang a za sei hrah ning khatah a tong ka, damia sahlo tah aa daipaw cawngsaw khah a hmuh tihtah khungsai ka, lang kang rakheh lang tah a cahri. ");
INSERT INTO zypNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma paw hraco Levi mingphing pakhehpaw tah ma hminghmaw cawh va phah hrah ka, a hmuh tihtah khungsai ka, langkae lang co a cahri sai thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Canghrasala, Samaria cawngsawpaw pakheh cawh khua tlawng hrah ka, damia sahlo tei aa daipaw cawngsawpaw ungnah khah va phah hrah ka, a hmuh cangkawleh ning a do ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A vawhno ka, a hmaw vytei khah sathy le misurhang thupah ka, a tongchai pah khy taitah ama a kelaipaw, la cung lang cawh khing ka, khuabuh lang seikhui ka, ma leco a mingkai. ");
INSERT INTO zypNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A ningthlamongpaw leco, ngung tangka phaehning cawh chua ka, khuabuh a hnuitupaw cawh pei ka, ‘Ma cawngsaw heh achaw teitah mingkai la, ka va kaw kaw tihtah a hluipaw tei na changpaw maikaw cawh ka ca chang kaw thlu tae a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ma tlaw pathung hrong lehei ahomaw damia sahlo tei aa hrawhpaw cawngsaw a ingpaw cawh a cang tatah na rawh?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Phungbia a thaipaw taco, “A cung letei ningdonah a hnuipaw khah a cang a, tah ka rawh,” tatah a chai. Zisu tah, “Sei la, ma hraco va tua hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Zisu le a hningzuitu sahlo khah khua aa tlawnglai ning tah khua khuakheh va phah he ka, ma leco canuno pakheh Martha aa tahpaw tah a ing letah a tlungsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha cawh Mari aa tahpaw chuahruino pakheh a hnui. Ama cawh Abuipaw phehrang letah a ty ka, a bia reipaw khah a nawthlia. ");
INSERT INTO zypNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Canghrasala, Martha cawh raihrepaw ahlunah cawtah a rai a hnawh ngetei. Zisu khatah a vong ka, “Abuipaw, ka nyteino tei rai kama longtei a pa váso thlangpaw heh a pui tah bei ceh maw? Kama baw rua pawtah pa chingpah law,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Abuipaw taco, “Martha, Martha, hming hlupui cawtah lung reithui tah na ung, ");
INSERT INTO zypNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","canghrasala hming sangkheh suipaw a hia. Mari tah achaw vypaw a thingpaw heh ama taitah lah pápaw cang be,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ningkheh cawh Zisu cawh hminghmaw sangkheh letah thlaw a chang leimei. Thlaw a chang khy taico a hningzuitu pakheh tah a hai letah, “Abuipaw, Johan tah a hningzuitu sahlo a cawngpah pawhe hrakhei thlawchang ma cawngpah hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Zisu tah, “Thlaw naa chang tihtah ma hrahei chang my lo. ‘Vy kaa Paw, na ming cawh cizaw tah ung seh. Na painah tlung ky seh. ");
INSERT INTO zypNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ning ting kaa hiapaw batui ma pei my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kaa cung letei suanah a tuapaw kaa ngethai pawhe hrakhei kaa suanah ma ngethai hrah my lo. Tuhsonah lang a ma chui kheh lo,’ ” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Taico Zisu tah ma hrahei a tah he, “A bianapaw tah naa hrong letah pakheh cawh vesaw pakheh hnui ka, ama khaco zaicing tah a vaw ka, ‘Ka dua, very tlangthung tah pa cui theh, ");
INSERT INTO zypNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","zecawtamaw tatah khua a tlawngpaw ka vesawpaw va tlung ka, zehmai peh ruapaw hnui bei neh,’ tatah a va tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Taico ing chung letei a ungpaw taco, ‘Hna pa hnawh tua kheh, ingkaw zong ka hrai thlu thah, ka sawtei leh zong kama khatah a ih thlu myca he, tho tah zehmai ca pei khy bei neh,’ tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka ca ching he a, vesaw chaw a cangnah cawtah tho lytah le very khah peh lytah ung hmai seh la, a hae lawnglia caco tho ka, a dunah zé tah a peh thlang a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Macawtaco ka ca ching he a, hae la, peh na cang a he ceh, hui la, naa hmuh a, khong la, ingkaw hong pah na cang a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ahohmai a haepaw cawh peh a cang he a, a huipaw taco hmuh a ka, ingkaw a khawngpaw cawh hongpah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Naaning paw a cangpaw sahlo, naa sawtei leh tah ngaw ca hae my he seh la, pari naa pae he maw? ");
INSERT INTO zypNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aatui ca hae he seh la, tlangcekawng naa pae he maw? ");
INSERT INTO zypNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Naaning mehchahly tahmai naa sawtei leh hmingchaw peh zia naa hni caco, vaicung letei naa Paw taco Thlawpaw Pathai a haepaw sahlo khah ze tlua tamaw a peh vy chichi he a!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Zisu tah a rei a thlaw thai lypaw chung taikhei khachia khah a tingchua. Khachia a piathlah tihtah a rei a thlaw thai lypaw cawngsaw cawh a rei ka thlaw ka, mingzawpui khah aa ning a ang thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Canghrasala aaning chung taitah thaikhehpaw taco, “Khachia sahlo buipaw Belzabub thongtah khachia sahlo a papia khy he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ahringpaw sahlo taco, Ama khah pase du tah vaicung lang tei ningang chuipaw paching pakhanah ma tuapah law, tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zisu tah aa rawhnah khah hnih ka, aa hai letah, “Ze painah raang hmai, aaning le aaning aa dy caco he a rawh thlu he a. Taico ingchungkho khokheh zong a rai ly tei a chaichy caco he a rawh hrá he a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Setan zong ama le ama a dy caco, zekhatamaw a painah raang cawh a daw khy a? Ma bia heh Belzabub thongtah khachia sahlo a papia he naa tah cawtah ka reipaw a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Atoheh kama tah Belzabub thongtah khachia khah ka papia pawtei a cang caco, naaning a ca zuipaw sahlo he takhei saw aho thong tamaw aa papia? Macawtaco aaning cawh naaning bia a ca cepahtu a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Canghrasala, khachia sahlo khah Khazing hmingtuakhynah thongtah ka papia pawtei he a cang caco, Khazing painah raang cawh naaning khatah a tlung thah tahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mehthawtlung pakheh tah hrainang a hlupui khatah a ing khah a vai thlang chung taco a hnuichia vytei a bing. ");
INSERT INTO zypNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Canghrasala ama navy tah a thawtlung vypaw tah dy katei, a pahneh tih taco, a paichaipaw hrainang vytei khah lah pah ka, a hringpaw a lahpaw hming vytei khah a rai thlu he. ");
INSERT INTO zypNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ahohmai kama lang a bai lypaw cawh a pa caraepaw a cang, kama a pa pahmo khui lypaw cawh a papaipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Thlawpaw pialuipaw cawh cawngsawpaw chung taitah a ka piathlah tihtah raangcaa raangro lekhei a hianah hminghmaw hui tah a khiakaly ka, hmuh be. Mataico, ‘Ka piasaipaw ing lang khah ka pange kaw thlang a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ing cawh a va phah tihtah longkarong tah ung ka, pathai pahling teitah chiapaw a cangpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Taico sei ka, ama navy tah a sua vypaw he ahringpaw thlawpaw pialuipaw pasarih a va chui he ka, ma ing cawh aa pahrang. Taico ma cawngsawpaw cawh athoning tei navy khei, a hning tei a dawhming cawh a pazua vy syly,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zisu tah ma hming vytei heh a rei leimeining taco, zawpui hrong taikhei canu pakheh cawh ka y chua ka, “Nama a ca sahtu le hnabae tui tei a ca cawngtu cawh bonghnang a ting caimang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Zisu taco, “Canghrasala, Khazing bia khah thui tei, a bia a zuipaw he cawh bonghnang aa ting vypaw a cang he,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cawngsaw rungpui aa va hlu vy leimeining takhei Zisu taco, “Atochai cawngsaw heh a chah ly caimang he. Ningang chuipaw paching pakhanah aa hae, canghrasala Khazing khuavang Jonah paching pakhanah khah tah cy ly co zehmai peh cang a bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nineve khua cawngsaw cawtah Jonah cawh paching pakhanah a cangpaw hrakhei Cawngsaw Sawcapaw zong heh atochai cawngsaw cawtah paching pakhanah a cang hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Biacenah ning leco thuilang Abuino Shiba cawh a daw a ka, ato chai cawngsaw sahlo heh thaily a cang sá he a. Zecawtamaw tatah ama cawh Solomon a singnah bia nge rua pawtah alui a changnah taitah va sei ka, canghrasala atoheh Solomon navy tah a lai vypaw ma lehei a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Biacenah ning leco Nineve khua cawngsaw sahlo cawh atochai cawngsaw khahei a daw hrui he ka, sua aa phosah tae he a, zecawtamaw tatah ma tlaw taco Jonah a bia reipaw rawng tah angepachihnah aa hnui, taico atoheh ma lehei Jonah navy tah a rungnaw vypaw a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ahotahmai me-ing aa vang tihtah a langlynah hminghmaw letah maw, tongbai rai letah maw chia bang bei he. Ing chunglang a naepaw tah a khaipaw aa hmuh khy nápawtah me-ing tung letah me-ing khah a chia tei. ");
INSERT INTO zypNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na meh heh na pung cawtah me-ing a cang. Na meh a chah caco, na pungpaluh zong khah khainá tah a chih. Canghrasala na meh a chah ly caco, na pung zong muiná tah a chih. ");
INSERT INTO zypNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","A raering my lo, naa chung letei a ungpaw khainah cawh muinah cang be kho. ");
INSERT INTO zypNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Macawtaco na pungpaluh cawh khai ná tah a chi tei, na pungsaw a zehapaw letah hmai muinah a ung ly caco, me-ing a khainah tei a ca khaisopaw hrakhei na pung cawh a khai a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bia a rei khy taico Zisu cawh Farasi pakheh tah batui e hrui pawtah a hrui. Macawtaco va sei ka, a ty ka, cabuai khah a hia thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Canghrasala, Zisu cawh Farasi phung a cangpaw e hlai tah kih si khah tua be ca ka, Farasipaw tah a kih a si lypaw khah a hmuh tihtah a khuarawh a haa. ");
INSERT INTO zypNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mataico Abuipaw tah a hai leco, “Naaning Farasi cawngsaw taco ny le pakang sahlo alailang khah pathaisah he ceh ka, canghrasala, naa chunglang cawh chahlynah le dusawnah long teitah a chih. ");
INSERT INTO zypNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Naaning mehruh sahlo, alailang a tuatu Khazing takhei a chunglang zong tua hrah bei maw? ");
INSERT INTO zypNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Canghrasala naa pakang le naa ny chung letei a ungpaw khah mehsisah va pei la, naa cawtah zezongpui a pathai thlang a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Naaning Farasi sahlo, naa cing a ping, zecawtamaw tatah naa buichung taitei a chuhpaw hmekhuh, hanghui le aihnaw sihnaw taikhah chyhraw chykheh khah Khazing naa peh naná teitah dingnah le Khazing do khah naa thlawdaw. A hmetaw teipaw heh dethlang lytah ahning teipaw zong heh naa tua ruapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farasi sahlo, naa cing a ping, zecawtamaw tatah synagog letah achaw caipaw dyching letah a ty du he ceh ka, chodo tlaang letah cizaw hmo tah bia a ching khah naa du. ");
INSERT INTO zypNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Naa cing a ping, zecawtamaw tatah naaning cawh ngianah a ung lypaw athlai, ahotahmai hni ly tei aa tlaichai teipaw hratah na cang he ceh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Phungbia a thai ngeteipaw hrong letei pakheh tah, “Cawngpahtu, ma vytei hming na rei tih lehei kaaning zong na ma zongte hrah,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Zisu tah, “Naaning phungbia a thai ngeteipaw sahlo naa cing a ping, zecawtamaw tatah cawngsaw khah aa pho khy lypaw behnah phung hmingrih khing he ceh ka, naa vuhsah he. Naaning duiteisai cawh aaning baw rua pawtah naa kihdong hmai calia du bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Naa cing a ping, zecawtamaw tatah naa pupaw sahlo tei aa za nongpaw he Khazing khuavang sahlo caw takhei thlailung sahlo naa bing he. ");
INSERT INTO zypNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Macawtaco naa pupaw sahlo aa tuasanah khah naa naw a tlah khui hrah he tahnah a cang, aaning tah Khazing khuavang sahlo khah aa nong he, naaning tah aa thlailung naa bing. ");
INSERT INTO zypNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Macawtaco Khazing singnah tei a reipaw cawh, ‘Khazing khuavang le apostol sahlo khah aaning khatah thlaw he neh ka, thaikheh khah theh a he ka, thaikhehpaw khah aa hrae he a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Macawtaco atochai cawngsaw sahlo cung lehei khazaw hrangthonah taitei aa thawpaw he Khazing khuavang vytei aa thisai rawng tah dangtahnah a tlung tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel thisai taitah dangnah siasang le behnah ing pathai kaa letah aa thawpaw Zakaria thisai tai a cang a. A cang, ka ca ching he, ma vytei cawtah hei atochai cawngsaw sahlo heh dangtah a cang tae he a. ");
INSERT INTO zypNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Naaning phungbia a thai ngeteipaw sahlo, naa cing a ping, zecawtamaw tatah hninah ingkaw cabi khah law he ceh ka, naa seikhui. Naaning duiteisai cawh a nae bei he ceh, taico a nae dupaw khah naa pakhang tlung he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma hminghmaw taico Zisu cawh a piathlah tihtah Farasi le phungbia cawngpahtu sahlo tah thaw tah cakhae he ka, hming a hlupui kong khah hae cakhia he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ma pawsui co a reichiapaw bia khei aa tle khy a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma cai leco cawngsaw thonghlupui a pahmo caw he tah pakheh le pakheh a tlaichai pai leimei he ka, Zisu tah ahmasaw cai tah a hningzuitu sahlo hai letah ma hrahei a rei. “Cungmai raipha a cangpaw Farasi sahlo raangri khah a raering my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","No thlangpaw hming maikaw palang cang a he ka, biaparuh zong phy a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A muinah letah naa reipaw zong a khainah letah thui cang a ka, inah khang letei naa reipaw biaparuh zong khah ing tlungkhu taitah phy a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ka huivesaw sahlo, ka ca ching he, pungsaw a theh khypaw sahlo khah ahohmai ci khe lo. Aa thaw khy taikhei zehmai tua khy khawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Canghrasala ahomaw naa ci ruapaw a cang takhah ka ca hmuh sá he a. Pungsaw zong thaw khy taitei hraihming lang zong thlah khynah naw a hnuipaw Khazing khah ci hri my lo. A cang, ka ca ching he, Ama cawh ci my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Baibaw pavaw sangpangaw khah tangka phaesai phaehning tah zua bei he maw? Canghrasala, sangkheh tei hmai khah Khazing tah monghly be. ");
INSERT INTO zypNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ahmangpaw tei co, naa lu letei sangbu sahlo hmai rei thlu a cang he. Zehmai ci khe o. Naaning cawh baibaw pavaw sahlo navy tah na sungnaw vy he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Cawngsaw hmekung letei Kama a pacang khuipaw cawh Cawngsaw Sawcapaw tah Khazing vaiming sahlo hme letah ka cangkhui hrá a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Canghrasala, ahohmai cawngsaw hrong letah Kama a pa paphahsaipaw cawh Khazing vaiming sahlo hme letah ka paphah sai hrá a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Taico ahohmai Cawngsaw Sawcapaw a reipachiapaw maikaw cawh ngethai khy cang thlang he ka, Thlawpaw Pathai a reipachiapaw maikaw cawh ngethai khy cang a bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Synagog sahlo le uhtu bui sahlo le nawhnuitu sahlo aa hme letah chuakhui naa cang tihtah zekhatamaw a reicakai neh ka, zemaw ka rei a tahpaw khah naa thlawzawng kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Zecawtamaw tatah ma cai letei naa rei ruapaw khah Thlawpaw Pathai tah a ca ching tae he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zawpui hrong taitah cawngsaw pakheh tah Zisu hai letah, “Cawngpahtu, ka unypaw khah ry chaichy pawtah pa chingpah law,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Zisu taco, “Cawngsawpaw, naa pahning kaa letah biacetu le ry chytu tah ahomaw naw hnuinah a pa pei?” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mataico aa zongmingtei hai letah, “A raering teitah ung my lo! Du hlui hnuinah a phingphing khah a raering my lo. Cawngsaw hringnah heh a hnuipaw rungnah letah a pahnia be,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mataico aa hai letah ma tawchingnah bia heh a ching he, “Mehrungpaw pakheh a ly cawh kungvui a chah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ama le ama cawh, ‘Zekhatamaw tua neh seh la, a chah a? Ka saze chia nápaw hminghmaw hmai a ung khawh tlung be,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Taico a reipaw cawh, ‘Ma hrahei ka tua a. Ka sachai heh chehthlah a neh ka, alai vypaw ka sá a, ma leco ka saze vytei le ka hmingbo sahlo ka chia a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Taico kama le kama khah, “Kung hlupui cawtah hmingchaw a hlupui hnui ceh ka, a nawng teitah ung la, e la, ding la, a nawng my lo,” tatah ka tah a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Canghrasala Khazing tah, ‘Mehruhpaw! Ato zai hrahring lehei na thi a. Macawtaco na cawtah na pacungpaw hming vytei cawh aho tamaw a lah a?’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ama a caw suipaw tah hming pacung katei, Khazing letah a rung lypaw cawngsaw maikaw cawh ma hraco a cang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mataico Zisu tah a hningzuitu sahlo hai letah, “Macawtaco ka ca ching he, naa hringnah cawtah zemaw kaa e a, a cang ly leh naa pung cawtah a buh a sai ruapaw kong letah naa lung reithui kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hringnah heh e le ba navy tah sungnaw vy ka, pung heh chaichi navy tah a sungnaw vy. ");
INSERT INTO zypNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ra-aw khah pacang tua hmai, thleci cing be ca he ka saze zong hre bei he, sachai zong hnui bei he, a cang naná teitah Khazing tah a cong thlang he. Naaning cawh pavaw navy tah a sungnaw vypaw cang bei he ceh maw! ");
INSERT INTO zypNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Naa hrong letah ahomaw a lungreithuinah rawng tah a hringnah cai suimehlang pakheh chang a chahchi khy? ");
INSERT INTO zypNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma hratei hming a chia pawtei hmai naa tua khy tlung lypaw tah zecawtamaw a hringpaw hming cawtah lungreithui tah naa ung? ");
INSERT INTO zypNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lili pangpa sahlo khah zekhatamaw aa ka cy tahpaw pacang tua o. Rai hre bei he, chaichi a taw bei he. Canghrasala ma heh ka ca ching he, siangpahrang Solomon hmai khah ma tlua khei a laisui thlang naná teitah ma pangpa sahlo letei kung kheh tlua khei hmai pasang cang be. ");
INSERT INTO zypNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Vy naaning zingnah a cawngpaw sahlo, alui letah atoning ka cy katei, ningthlamong me lang aa bo thlangpaw araang hmai a pasangpaw Khazing taco naaning cawh a ca pasang vy chichi he a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Macawtaco, naa ding naa e ruapaw kong pacang tah lung reithui tah ung khe lo. ");
INSERT INTO zypNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Zecawtamaw tatah ma hapaw hming sahlo cawh lawki cawngsaw sahlo zong tah aa hui teipaw cang hrah ka, naa Paw vaicung leteipaw tah naa hiapaw khah a hni thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Canghrasala a painah raang khah hui la, ma hming vytei zong heh peh na cang thlang a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Phu cawngtei sahlo, ci khe lo. Zecawtamaw tatah naa Paw tah a painah raang a ca pehpaw he khah a lung a lawngpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Naa hnuichia sahlo khah zua la, mehsisah sahlo khah pei my lo. A cai thai lypaw tangkabawng khah a zaa la, mehru tei aa ruh khylynah le luichaw tei aa e khylynah hming, vaicung letah aa chang khaw lypaw chosung sahlo cawh pacung my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Zecawtamaw tatah naa chosung a ungnah letah naa lungthing cawh a ung hrá a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Rai hre pawtah caise a tua pacia tah ung la, me-ing vang cia tah chia my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nupui chui kongchuanah hming taitah a va tlung kawpaw aa buipaw cawh a va chua cangkawleh ingkaw a khong tihtah rairang teitah hongpah rua pawtah a heh thlangpaw a saecapaw sahlo hratah ung my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aa buipaw tah a hraw hmotei a heh thlangpaw he sae sahlo, a va chuahnopaw sahlo he cawh meh vaichaw a cang he. Biahmuisui ka ca ching he, ama cawh raihrenah caise a tua ka, cabuai cadung sá he ka, ama hrahring tah a tuitang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zaicing tamaw a cang ly leh ma navy co a haa vy tah a va tlung tih letah hmai a mai pacia teitah aa za haw thlangpaw khah aa buipaw tah a hmuh caco he, ma sae sahlo cawh meh vaichaw a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Canghrasala ma heh hnih my lo. Ing hnuitu tah mehru cawh ze cai letah maw a va chua a takhah hnih thah my seh la, a ing cawh hrawh sá a be. ");
INSERT INTO zypNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Macawtaco a mai pacia tah ung my lo, zecawtamaw tatah Cawngsaw Sawcapaw cawh naa rawh lypaw cai lekhei a vong a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piter taco, “Abuipaw, ma tawchingnah bia heh kaaning longtei maw na ma ching, a cang ly leh ming vytei caw tamaw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Abuipaw taco, “Aho khah maw zing a chuipaw le a singpaw, a ingchungkho sae sahlo khah a cai naning teitah batui peh rua pawtah a buipaw tah rai a pehpaw mingkaitu cawh a cang? ");
INSERT INTO zypNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aa buipaw a va tlung kaw tihtah ma hratei a tuapaw a hmuhpaw sae cawh meh vaichaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Biahmuisui ka ca ching he, ma paw cawh a hnuichia vytei a mingkaitu takhei a tua a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Canghrasala a bianapaw tah a saecapaw taco ama le ama khah, ‘Ka buipaw cawh a va tlung nápaw a ne be,’ tatah tah ka, zuding saw e tah ung ka, ahringpaw sae canu le sae capaw sahlo khah a dai he. ");
INSERT INTO zypNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ma saecapaw a buipaw cawh a rawh lypaw ning le a pacang lypaw cai letah va tlung a ka, a buipaw tah ma sae capaw cawh caiping caimang tah taichung a ka, a zing lypaw sahlo ungnah lekhei a ungsah hrah a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A buipaw dunah hni thlang tei, rai hre pawtah a mai pacia tei a ung lypaw le a buipaw dupaw a tua lypaw sae cawh ui hlupui tah chei a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Canghrasala, a buipaw dunah hni ly hmotei dangtah tlang a cangpaw suanah a tuapaw cawh a cawng vy tah chei a cang a. A hlupui peh a cangpaw cawh a hlupui hae kaw a cang a. A hlupui kai sahpaw cawh a hlu vy tah hae kaw a cang he a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma hrahei a rei vy, “Alui heh me tah ro rua pawtah pui ka vong. Kang myca seh la, tah ka du caimang! ");
INSERT INTO zypNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Canghrasala baptisma cang nátah tai-ingpaw hnui neh ka, ma ka patlung ka patlia hlai cawh ka lung rei a thui caimang. ");
INSERT INTO zypNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aluicung lehei denah chuasah rua pawtah a vong tatah maw naa parawh? Cang be, pachai pawtah a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Atotei ri hei co ingchungkho ingkheh letah a ungpaw cawngsaw papangaw hrong letah a pachai he ka, pathungpaw tah pahningpaw khah dy he ka, pahningpaw tah pathungpaw khah aa dy tae he a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Paw leh tah aa sawtei leh khah dy a he ka, sawtei leh tah aa paw leh khah aa dy he a. No leh tah aa sawcanu leh khah dy a he ka, sawcanu letah aa no leh khah aa dy he a. Sawcapaw no leh tah myno leh khah dy a he ka, myno leh tah aa pasaepaw no leh khah aa dy tae he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zisu taco mingzawpui hai letah, “Nitlah lang tah meding a ka chuhpaw naa hmuh tihtah sungkheh tah, ‘Khua a so a!’ tah he ceh ka, ma hraco a so tahtah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Thuilang tah thli a hrang tihtah, ‘Ning a paling tae a!’ tah he ceh ka, a paling tahtah. ");
INSERT INTO zypNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cungmai raipha sahlo! Alui le avai ming he ceh ka, ningkhua zemaw a lo a tah cawh naa hni. Zekhatah zia tamaw atochai hming ung zia a silang heh naa ching pase thai be? ");
INSERT INTO zypNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zecawtamaw naaning teitah zemaw ahmang tah cawh naa pacang thai be? ");
INSERT INTO zypNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Naa caraepaw khatah biacetu hme letah chua pawtah naa sei tihtah langpui letah a rai khy nápaw khah a zawng my lo. Ma hratei na tua ly caco biacetu hme letah ca chuakhui ka, biacetu tah nawhnuitu kih letah ca hlai sua a ka, taico thong letah thlah na cang sua a. ");
INSERT INTO zypNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ka ca ching, tangka lia ruapaw na lia thlu hlai vytei cawh thong taitah chuh khy khaw bei ceh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma ningcai taco ma letei a ungpaw cawngsaw thaikheh taco Zisu hai letah raang uhbui Pilat tei Galili cawngsaw thuihlainah aa tua leimei ning tah a thaw sahpaw he kong khah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Zisu tah, “Ma hratei thihnah a ingpaw Galili cawngsaw sahlo he khah ahringpaw Galili cawngsaw sahlo navy tah aa sua vy rawng tah a cang tatah maw naa rawh? ");
INSERT INTO zypNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cang be tah ka ca ching he! Naaning zong na ngepachih ly caco he ceh na lyde hra he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A cang ly leh Siloam ing a sangpaw a cing ning tah a naiseh pawhe cawngsaw pahrawhluireh khah Jerusalem khuapui chung letei a ungpaw a hringpaw cawngsaw sahlo navy tah aa sua vy cawtah a cang naa tah maw? ");
INSERT INTO zypNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cang be tah ka ca ching he! Naaning zong na ngepachih ly caco he ceh na lyde hra he ceh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Taico Zisu tah ma tawchingnah bia heh ching he ka, “Cawngsawpaw tah a buichung letah thuiku kung kung kheh cing ka, a thui maw thui ly tatah a va ming tihtah zehmai hmuh be. ");
INSERT INTO zypNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Macawtaco buichung a mingkaipaw hai letah, ‘Ma thuiku kung heh a thui maw, thui ly tatah kung thung chung mingkai neh ka, zehmai hmuh bei neh. Hyhly! Cholui chang a pahry,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Buichung a mingkaipaw taco, ‘Abuipaw, ato kung kung kheh chung tei heh cawh ming cawng tua, a kaekang heh thlo pá neh ka, alui achawpaw ka bia a. ");
INSERT INTO zypNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hangkung lang a thui caco chah thlang ka, ma hratah cang ly tei a thui ly caco, hyhly thlang lepui ceh,’ a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat ning tah Zisu tah synagog sangkheh letah a cawngpah leimeining he takhei, ");
INSERT INTO zypNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","kung hrawhluireh chung khachia tah a tlepaw canuno a za ung. A kai a king thlu thah ka, a pathlang khy bingbi lytah a ung myca. ");
INSERT INTO zypNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zisu tah ma no cawh a hmuh tihtah a hmelang va chuh law tatah y ka, “Cawngsawno, nama cawh na ciacung lynah taco a ca thlaw myca,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Taico a cung letah a kih pahnia ka, sungkheh teitah canuno cawh a ka pathlang khy ka, Khazing khah a reithai. ");
INSERT INTO zypNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sabat ning tah Zisu tah cawngsaw a dangsah cawtah synagog a uhtu cawh a thingae ka, zawpuipaw khah, “Raihrenah ning ningruh a ung, Sabat ning rei lytah ma ningruh chung leco a vong tah na dangsah bei he ceh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Abuipaw tah a hai letah, “Naaning cungmai raipha sahlo! Ahotahmai Sabat ning tah a co cang seh, a la cang seh, naa ing taitah thlaw he ceh ka, tui ding sá pawtah seikhui thlang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A cang caco Abraham pathlah a cangpaw, Setan tei kung hrawhluireh chung hrai katei a sahpaw heh Sabat ning zong tah dangsah pápaw cang bei maw?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ma hratei bia a palei tih he taco Ama a caraepaw vytei khah aaning a zeh. Canghrasala zawpuipaw taco a tuapaw hming ningang chuipaw vytei cawtah khei aa thaw a chah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zisu tah, “Khazing painah raang cawh zekhatamaw a lo? Zekhatamaw kaa tawching a? ");
INSERT INTO zypNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cawngsawpaw pakheh tah a ly chung letah a lingpaw aihrang ci khatah a lo. Aihrang ci cawh ka chang ka, thingkung tah a ka tua ka, pavaw sahlo tah a cai sahlo letah a cawng tei he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Taico Zisu tah a tah vypaw cawh, “Khazing painah raang cawh zekhatamaw kaa tawching a? ");
INSERT INTO zypNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Canuno tah vedi hongkheh lekhei raangri pahlawh ka, a nong chi. Ma raangri taco vedi cawh a tho sahpaw hratah a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Taico Zisu cawh Jerusalem lang a seinah langpui letah khuapui zong khuatei zong pae pai lai ka, a cawngpah lai he. ");
INSERT INTO zypNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Cawngsaw thaikheh tah, “Abuipaw, meh cawngtei long maw pachah a cang he a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Zisu taco, ma hrahei a tah he, “Ingkaw a bawpaw lang tah a nae pawtah thaw tah a zong my lo, zecawtamaw tatah ka ca ching he, cawngsaw a hlupui tah a nae zaa he ka, a nae khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ing hnuitu khah tho ka, a ingkaw khah a kha tae a. Taico naaning cawh ingkaw khungthing lang tah ingkaw khah khong he ceh ka, ‘Abuipaw ingkaw ma hong ky law,’ tatah naa ta a. Canghrasala ama taco, ‘Ze taitah maw naa va chua? Naaning cawh ca hnih bei he neh,’ tatah a ca tah tae he a. ");
INSERT INTO zypNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mataico naaning tah, ‘Nama khatah kaa e hrui, kaa ding hrui tei kha, kaa khuatlang letah na ma cawngpah tei kha saw,’ naa tah a. ");
INSERT INTO zypNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Canghrasala ama taco, ‘Naaning zong ca hnih bei he neh, zelang tamaw naa va chua tahpaw hnih bei neh. Naaning hming chahly a tuapaw vytei ka kae taitah seihly o!’ a ca tah tae he a. ");
INSERT INTO zypNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Naaning vytei cawh alailang letah vathlang cang he ceh ka, Abraham le Isak le Jakob le Khazing khuavang vytei cawh Khazing painah raang chung lekhei naa hmuh tae he a. Ma tih taco cá he ceh ka, naa haw naa ria tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Cawngsaw cawh nichua, nitlah, thuilang, tlanglang tah a vong a he ka, Khazing painah raang lawhdangnah hming lekhei a ty he a. ");
INSERT INTO zypNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ma tih taco ato letei a hningcaipaw zong heh a hme a sahpaw cang he ka, ato letei a hme a sahpaw zong heh a hningcaipaw a cang tae he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma ning taco Farasi thaikhehpaw tah Zisu kha a vong he ka a hai letah, “Ma hminghmaw taihei piathlah la, hmingkheh kheh lang sei. Herod tah thaw a ca du,” tatah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Zisu tah, “Va sei la, ma sihatei khah va ching o, ‘Atoning zong, ningthlamong zong, khachia sahlo tingchua he neh ka, a dang lypaw ka dang sá he a. A ningthung ning tah ka rai cawh ka paling a.’ ");
INSERT INTO zypNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Zekhatah a cang zong tah atoning, ningthlaw le hazaining tai cawh ka sei longmang thlang a. Zecawtamaw tatah Khazing khuavang cawh Jerusalem khuapui khungthing lang letah thih phung cang be! ");
INSERT INTO zypNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Vy Jerusalem! Jerusalem! Khazing khuavang sahlo khah za theh he ceh ka, Khazing tah naaning khatah a tawpaw he a cawngsaw sahlo khah alung tah naa vaseh tei he. Aa puino tah a sawtei leh a mathlaw rai letah a bakhupaw he hratah naa cawngsaw cawh uikhazeh uilui maw pakhawng du he neh ka, canghrasala du bei he ceh! ");
INSERT INTO zypNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mingtua hmai o, naa ing cawh a ching myca. Ka ca ching he, ‘Abuipaw ming tah a vongpaw cawh bonghnang song cang ky seh,’ tatah naa tah hlai vytei cawh pa hmuh kaw khaw bei ceh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat ning leco Zisu cawh Farasi sahlo letei hruitu pakheh ing lang khah batui hrong pawtah a sei tihtah Ama cawh achaw teitah aa ngia lai. ");
INSERT INTO zypNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma leco a hmekaw letah cawngsawpaw pakheh thlingnah hri a ingpaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zisu tah Farasi sahlo le phungbia a thai ngeteipaw sahlo cawh, “Sabat ning letah dangsah heh a phung a cang maw cang ly?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Canghrasala a cali thlang he. Macawtaco cawngsawpaw cawh va hre ka, dangsah ka, a seisah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mataico aa hai letah, “Naaning hrong letah pakheh tah Sabat ning letah a sawtei pakheh a cang ly leh a co tungpaw sangkheh khobatlung lang tlah my seh la, rairang tah chuahly a bei maw?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Maco, a rei nápaw hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hruipaw cawngsaw sahlo tah cabuai letah a tynah achawpaw a thingpaw he khah Zisu tah a hmuh tihtah aaning cawh ma tawchingnah bia heh a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pakheh kheh tah nupui chuinah letah a ca hrui tih he tah a tynah achawpaw lekhei a ty khe lo. Nama navy tah a puimaw vypaw cawngsaw pakheh zong a hrui mai a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma hratei a cang caco, naa pahning tah a ca hruipaw he kong a chuatupaw a vong ka, ‘Na tynah khah ama heh tlui,’ a ca tah a. Mataico ningzaw tah a chawly caipaw hming lekhei na ty a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Canghrasala aa ca hrui tih he tah a nai caipaw hming lekhei a ty o. Maco a ca hruitupaw he a vong tihtah ama taco, ‘Ka dua, achaw vypaw hming lang a palong,’ a ca tah a. Ma tih taco male hme letah upanah na hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ahohmai ama le ama a pasangpaw cawh nytaw tah ung ka, ama le ama a panaipaw cawh pasang a cang a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mataico, Zisu tah kong a chuatupaw cawh, “Ching batui a cang ly leh zairia na tua tihtah na vesaw sahlo, na uny sahlo, naa sawny sahlo, a cang ly leh naa ingpaw mehrung sahlo khah hrui khe lo. Na hrui caco he aaning tah nama khah ca hrui kaw hrá he ka, chang kaw na cang tha a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Canghrasala lawhdangnah na tua tihtah dawngchiapaw, ciacung lypaw, a phe a cabepaw le a mehcopaw khah hrui hri la, bonghnang song na cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aaning tah aa ca chang khy ly tahmai mehding thokawnah letah chang kaw na cang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aaning hrong letei pakheh ama kha cabuai a cadung hruipaw taco a thui tihtah Zisu cawh, “Khazing painah raang letei lawhdangnah letah batui a epaw cawngsaw cawh meh vaichaw a cang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zisu taco, “Pakhehpaw cawh kongchuanah rungnawpaw pachia ka, cawngsaw hlupui a hrui he. ");
INSERT INTO zypNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kongchuanah cai a zaw tihtah aa hruipaw he khah, ‘A vong myca o, zezong a tlang a tling thlu myca,’ tatah ching pawtah a sae khah a taw. ");
INSERT INTO zypNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Canghrasala aa zongmingtei khei biasi aa phe thlu. A pakhehnahpaw taco, ‘Atotei khah alui co neh ka, va ming pawtah sei ka du. Pa ngethai ky,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ahringpaw taco, ‘Atotei khah co tungpaw ching pangaw co neh ka, aaning khah hnehsá pawtah seipaw ka cang. Pa ngethai ky,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ahringpaw vy taco, ‘Atotei khah nupui chui neh ka, macawtaco a vong thai bei neh,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","A sae cawh a vong kaw ka, ma bia cawh a buipaw khah a ching. Mataico ing a hnuitupaw cawh a thingae ka a sae cawh, ‘Khuapui letei langpui sahlo le ing kaa leh ing kaa letei lang sahlo lang rairang tah va sei la, a dawngchiapaw, a ciacung lypaw, a mehcopaw le a phesongpaw khah va chuakhui o,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A sae taco, ‘Abuipaw, na pa chingpaw hrakhei tua neh ka, canghrasala ing chung letah chih balang bei he,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Taico, a buipaw tah a sae cawh, ‘Langpui sahlo lang le arangchung lang va sei la, ka ing chih ky tah cawngsaw chuasah my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ka ca ching, ka hruipaw sahlo he takhei co, ka lawhdangnah batui heh pateh khy bei he,’ a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zawpuipaw cawh Zisu khatah khua tlawnglai he ka, Zisu tah aaning lang cawh a hui ka, ");
INSERT INTO zypNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ahohmai kama kha a vong katei a no le a paw, a nupui le a saw sahlo, a uny sahlo le a satei sahlo le ama a hringnah hmai khah kama navy tah a do vypaw cawh ka hningzuitu cang khy be. ");
INSERT INTO zypNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Taico, ma leh khraws a puá tah a pa zui lypaw cawh ka hningzuitu cang khy be. ");
INSERT INTO zypNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Naaning hrong letah aho tamaw ingsang sah du seh la, a hnuipaw tangka tah a palingnah tai a zy maw tahpaw hni rua tah patih patong taw a bei maw? ");
INSERT INTO zypNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A hrang patho thah katei, a paling khy lypaw tei a cang caco, aa hmuhpaw maikaw tah ama cawh aa hnuiso a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ma cawngsawpaw tahei ingsah patho ka, paling khy khawh be,’ aa tah a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A cang ly leh abui pakheh cawh abui hringpaw dy rua pawtah sei seh la, ama dy rua pawtah mehnung thongki khatah a va seipaw pakheh khah mehnung thonghraw khatah a te khy a maw tahpaw cawh pacang taw a bei maw? ");
INSERT INTO zypNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te khy bei neh takhah a hni caco, a caraepaw langhlaw letah a ung chung takhei ai-awhtu sahlo thlaw tah arainah a hae a. ");
INSERT INTO zypNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ma hraco naaning zong naa hnuipaw maikaw naa seisai ly caco, ka hningzuitu cang khy bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Paci cawh a chah, canghrasala a aenah a ly caco zekhatamaw aa aesah kaw khy a? ");
INSERT INTO zypNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Alui a chah sápaw cawtah chah be ca ka, ingding tah tua rua tah zong chah be, vathlang ruapaw suipaw a cang thlang a. Thuinah nawkho a hnuipaw maikaw taco, ma bia heh thui he seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Taico ngungkhui kheitu sahlo le ahringpaw mehsua sahlo cawh Zisu a bia nge rua pawtah aa dawngkasawny teitah a pahmo he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Canghrasala Farasi le phungbia cawngpahtu sahlo taco, “Ma cawngsawpaw tahei mehsua sahlo achaw teitah chai he ka, aaning khatah batui a e thlang dei e,” tatah a phing he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mataico Zisu tah aaning cawh ma tawchingnah bia heh a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Naaning hrong letah pakheh tah a hnuipaw tuu zakheh lekhei sangkheh ly seh la, songkua sangkuapaw khah arangchung letah seisai tah a lypaw tuu khah seihno tah a hmuh kaw hlai vytei hui bei maw? ");
INSERT INTO zypNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Taico, a lypaw tuu khah a hmuh kaw tihtah lunglawng teitah a saitlang letah khing ka, ing lang a tlung. ");
INSERT INTO zypNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mataico a vesaw sahlo le a ingpaw sahlo khah y he ka, ‘A pa lawng khui law, ka tuu a lypaw ka hmuh kaw thah e,’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ka ca ching he, ma hraco mehding a ngepachih a hia lypaw songkua pakua navy co, a ngepachihpaw mehsua pakheh cung lekhei vaicung letah alawngnah a hlu vy. ");
INSERT INTO zypNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","A cang ly leh canuno pakheh tah ngung tangka phaehraw hnui seh la, phaekheh hly tua seh. Ma no taco me-ing vang tah ing phih a ka, a hmuh hlai tai achaw teitah hui a bei maw? ");
INSERT INTO zypNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma no taco ma tangka cawh a hmuh tihtah a vesaw sahlo le a ingpaw sahlo khah y pakhong he ka, ‘A pa lawng khui law, a lypaw tangka khah ka hmuh thah e,’ tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma hraco ka ca ching he, angepachihpaw mehsua pakheh cung lehei Khazing a vaiming sahlo hme letah alawngnah a ung,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zisu tah a bia cawh reipazo ka, “Cawngsawpaw pakheh ung ka, sawcapaw pahning a hnui. ");
INSERT INTO zypNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A nyheh vypaw tah a paw cawh, ‘Apaw, ka ting vypaw ry pa pei law,’ tah ka, macawtaco a paw tah a hnuipaw khah aaning cawh a chaichy he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Khua sy a ry hlai tah a sawcapaw a nyheh vypaw taco a hnuipaw vytei cawh pakhong ka, langhlaw pui raang lang seihly ka, ma leco a tangka vytei cawh a nawngnangnah letah a hmang thlu. ");
INSERT INTO zypNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A hnuipaw vytei a hmang thlu khy taikhei ma raang chung vytei leco cakaang a thaw tah tlung ka, ama cawh a phahlah pawngchang tah a ung myca. ");
INSERT INTO zypNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mataico ma raang letei cawngsawpaw pakheh khatah a vaw ka, a hlofa. Ma cawngsawpaw taco voh lawh a pei ruapaw tah ly lang a taw. ");
INSERT INTO zypNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A ngai a di tu cawtah voh lawh khah hmai e du ngetei ka, canghrasala e ruapaw ahohmai a peipaw ung bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A lung ka sing ka, ama tei co, ‘Ka paw ing letei a hlofapaw sahlo tahmai e ruapaw a hlupui hnui he ka, kama cawh ma lehei ngaidi tah ka thi daimang myca! ");
INSERT INTO zypNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tho a neh ka, ka paw kha ka sei a. Taico, “Ka paw, Khazing hme le na hme letah ka sua myca. ");
INSERT INTO zypNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na sawtei tah tlang hmai a tlah khawh bei neh, canghrasala, na raihrepaw sahlo letei pakheh hratah pa tua ky law,” tatah ka tah a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Macawtaco tho ka, a paw khaco a sei. Canghrasala langhlaw pui letah a va sei leimeining takhei a paw taco va hmuh ka, ning a do ngetei. Va saihno ka, a pongchai ka, a hnang. ");
INSERT INTO zypNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A sawcapaw taco, ‘Apaw, Khazing hme le na hme letah ka sua myca. Kama cawh na sawcapaw tah tlang hmai a tlah khawh bei neh,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Canghrasala a paw taco a sae sahlo cawh, ‘Pai achaw caipaw khah rairang tah va tle la, a buh sá o. A kihdong lekhei kihsapadi a hro sá la, a phe lekhei phepakong a pakong sá o. ");
INSERT INTO zypNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A thy caipaw co tungnypaw khah va hrui la, theh my lo. Kongchuanah tuá tah a nawng he peh. ");
INSERT INTO zypNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ma ka sawcapaw heh thi ka, a kahring kaw, ama cawh ly ka, ka hmuh kawpaw a cang,’ tatah a tah. Mataico lawhdangnah cawh aa tua. ");
INSERT INTO zypNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ma chung cawh a sawcapaw uthuipaw cawh ly letah a ung thlang. Ing lang ka tlung ka, ing kae a va phah tihtah hlaw o le aa langpaw py khah a thui. ");
INSERT INTO zypNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Macawtaco sae pakheh khah y ka, ‘Zemaw naa tua?’ tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma saecapaw taco, ‘Na nyteipaw va kaw kaw ka, a bing teitah a va kaw kaw cawtah na paw tah a thy caipaw co tungnypaw khah a thaw,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Uthuipaw cawh a thingae ka, ing chunglang a nae du khawh be. Macawtaco a paw cawh piathlah ka, a va naw. ");
INSERT INTO zypNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Canghrasala a paw hai leco, ‘Rawh tua hmai! Kung ma vytei heh sae hratah ca hrepah neh ka, na reipaw zong nge lytah ung bang bei neh. Ma naná co hmai ka vesaw sahlo kha a nawng nápaw cawtah mei teitei hmai pa pei bang bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Canghrasala ma na sawcapaw tahei na tangka vytei khah hlohlang no khatah hly thlu ka, ing lang a va kaw kaw tihtah a caw taco a thy caipaw co na thawpah!’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A paw taco, ‘Ka sawcapaw, nama cawh kama khatah ung leimei thlang ceh ka, ka hnuipaw vytei heh na tei a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Canghrasala a lawngnah dy tua tah kaa lawngpaw he peh a cang, zemaw tah pawco ma na nyteipaw heh thi ka, a ka hring kaw, ama cawh ly ka, hmuh kawpaw a cang,’ tatah a palei,” tatah Zisu tah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zisu tah a hningzuitu sahlo cawh, “Mehrung pakheh ung ka, hming a mingkaitu pakheh a hnui. Hming a mingkaitu taco mehrungpaw a cho le pe sahlo cawh a longdepaw tah a tua tatah pu a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Macawtaco ama cawh mehrungpaw tah y ka, ‘Na kong ka thuipaw heh zekhatamaw a cang? Rai na hrepaw cazing papei, zecawtamaw tatah ka hming mingkaitu cang khy khawh bei ceh,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hming a mingkaitu taco ama le ama cawh, ‘Zemaw ka tua a? Ka buipaw tah ka rai a pa lah pah thah. Alui che pawtah thawzaang hnui tlung be ca neh ka, kih do pawtah ka ning a zeh tlung. ");
INSERT INTO zypNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A cang caco, zemaw ka tua a tahpaw ka hni myca! Ma hratei ka tua caco, ka rai a chang tihtah cawngsaw tah aa ing letah aa pa tlungsah du a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Maco a buipaw khatei luibah a hnuipaw sahlo khah pakheh cy tah y he ka, a pakhehnah khah, ‘Ka buipaw cawh khazeh maw na bah?’ tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Oliv sathy galon pung zareh,’ tatah a palei. Hming a mingkaitu taco, ‘Na cazing law la, rairang tah a ty la, galon pung zapali tatah cia,’ tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mataico a pahningnah cawh, ‘Nama saw khazeh maw na bah?’ tatah a hae. ‘Changvuh bai thongkheh,’ tatah a palei. Ma cawngsawpaw zong cawh, ‘Na cazing law la, zareh tatah cia,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma hming a mingkaitu mehdih lypaw tei singthai tei hming a tuapaw cawh a buipaw tah a pachaw ngetei. A hmang, khazaw cawngsaw heh aaning aa mehnung hui khatei aa cawtah aa tuanah kong leco Khazing a khainah letei a ungpaw cawngsaw navy tah a sing vy he. ");
INSERT INTO zypNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ka ca ching he, khazaw cho le pe heh vesaw hnui nápawtah hmang o. Ma hratei naa tua caco, naa cho a chang tihtah chaizaw ing letah naa ung he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ahohmai a chia pawtei letah zingchui pawtah a ungpaw cawh alaipaw zong letah zingchuipaw cang tei ka, ahohmai a chia pawtei letah zing a chui lypaw cawh alaipaw zong letah zing chui hrah be. ");
INSERT INTO zypNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Macawtaco, khazaw hnuirungnah letah zingchuipaw naa cang ly caco, rungnah hmuisuipaw letah ahomaw a ca zing he a? ");
INSERT INTO zypNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Taico, cawngsaw hringpaw hnuicho letah zingchuipaw naa cang ly caco ahomaw naa tei rua pawtah hming a ca pei he a? ");
INSERT INTO zypNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Aho sae tahmai abui pahning aa rai hre khy be. Pakheh a hua ka, pakheh a do a, a cang ly leh pakheh cung letah zingchuipaw tah ung a ka, pakheh khah ze tah rei a be. Khazing rai kha, tangka rai kha hre pakong khy bei ceh,” tatah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tangka a dupaw Farasi sahlo tah ma bia cawh thui he ka, Zisu cawh aa hmo aa miaso. ");
INSERT INTO zypNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Zisu tah aaning cawh, “Cawngsaw mehmuh letah thai a cangsah he ceh ka, canghrasala naa lungthing cawh Khazing tah a hni. Cawngsaw tah a sungsah ngeteipaw heh Khazing mehmuh leco pasih a chuipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses phungbia le Khazing khuavang bia sahlo cawh baptisma peitu Johan chai tai khah a cang he. Ma cai ri taico Khazing painah raang thawngchawbia cawh rei leimei tah cang ka, ming hlupui cawh ma langpui chunglang khah a chuchei tah a nae he. ");
INSERT INTO zypNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Khazing phungbia cabu chung letei a chia caipaw, casung tei deipaw tei hmai heh lahly navy co, alui le avai a lypaw hmai heh a neh vy syly a. ");
INSERT INTO zypNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","A nupui mah katei ahringpaw canu a chuipaw cawh a pheipaw a cang. Mah ciapaw canu a chuipaw capaw cawh a pheipaw a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A rei vypaw cawh, “Mehrungpaw pakheh, saidungpaw paithladih anaipaw a tua katei, ning tating tei a nawng teitah khua a sahpaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kih dopaw, a ming Lazaru aa tahpaw, hmawchia tei a pahlong thlangpaw khah a hawkaw letah chia he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mehrungpaw a cabuai taitah didang a tlahpaw khah e rua pawtah a du ngetei. Ui sahlo taco a vong he ka, a hmaw khah aa liapah tei. ");
INSERT INTO zypNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kih dopaw cawh a thihnah cai a va phah tihtah vaiming tah ama cawh Abraham kae letah aa seikhui. Mehrungpaw zong cawh thi hrah ka, aa phung. ");
INSERT INTO zypNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Vaisang ngetei tei a ungnah hraihming taikhei, a cung lang cawh a kahui ka, langhlaw pui lekhei Abraham le a kae letei Lazaru khah a hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Taico Abraham cawh y ka, ‘Ka paw Abraham, ning pa do la, Lazaru khah taw la, a kih dong khah tui letah nong seh la, ka lui a cakaw nápawtah za pa thlah so ky seh, zecawtamaw tatah ma me lehei ka tai tu myca,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Canghrasala Abraham taco, ‘Ka sawtei, na hring chung tei hming chawpaw na cypaw vytei khah a thui thlang bei ceh maw? Ma ning lekhei Lazaru taco hmingchahly a cy kho. Canghrasala, atoheh cawh ama cawh ma lehei a hnaw pangang he ka, nama cawh taisai na tai myca. ");
INSERT INTO zypNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma hlui co, na kaa le kaa kaa lehei khobatlung a thuh ngeteipaw ung ka, macawtaco ma taihei nama kha a va sei dupaw sahlo aa va sei khy lypaw hratah ma taikhei kaaning khatah ahohmai va cakang khy hrá bei he,’ tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mataico mehrungpaw taco, ‘Ka ca naw, ka paw! Lazaru khah ka paw ing lang taw la, ");
INSERT INTO zypNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","uny papangaw hnui he neh ka, aaning cawh a raeringnah va pei he seh la, ma tai-ingnah hming lang heh aa va sei ly nápawtah,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham taco, ‘Moses le Khazing khuavang sahlo hnui thlang he ka, aaning aa bia cawh nge thlang he seh,’ tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mehrungpaw taco, ‘Cang be, ka paw Abraham, a thi ciapaw tah aaning kha aa va sei caco, aa ngepachih thlang he a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Canghrasala Abraham taco, ‘Moses le Khazing khuavang sahlo aa bia aa nge ly caco, thihnah taitah a thokawpaw aa ung tahmai tah aa bia zong nge hlui a bei he,’ tatah a palei,” tatah Zisu tah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zisu tah a hningzuitu sahlo hai leco, “Cawngsaw a suasahpaw hming sahlo a ung paria thlang he a. Canghrasala suanah a chuakhuipaw mehnung cawh a cing a ping. ");
INSERT INTO zypNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma nyhehtei sahlo lehei pakheh hmai heh a suasahpaw cawh a hirong letah saangrianah lung pathle tah rili lang thlah he seh la, a cawtah a chah vy a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Macawtaco a singkang my lo. Na unypaw tah suanah a tua caco, chinghring la, a ngepachih caco ngethai my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ning kheh tah uisarih na cung letah sua katei, uisarih nama kha a vong tah, ‘Ka ngepachih,’ a ca tah caco ngethai my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostol sahlo tah Abuipaw cawh, “Kaa zingnah heh changchysah vy law!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zisu taco, “Aihrang hmu tia tei chang zingnah naa hnui caco, ma siasahming kung heh, ‘A phehly la, rili letah va cy law,’ tah khy he ceh ka, naa bia a ca nge thlang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Naaning hrong letah pakheh tah alui a paleh ruapaw tamaw, tuu a king ruapaw tamaw sae pakheh hnui seh la, arangchung lang tah a va tlung tihtah, ‘A vong la, a ty la batui e,’ naa tah a maw? ");
INSERT INTO zypNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma hraco tah lytah, ‘Batui pa tuapah, a pachia la, ka ding ka e chung vytei heh pa ungpai thlang, ma khy taico na ding na e tae hra a,’ tah hri bei maw? ");
INSERT INTO zypNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma a saecapaw tah a chingpaw hratah a tua cawtah a buipaw tah a cung letah a lawng hlui be. ");
INSERT INTO zypNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma hraco naaning khatah chingpaw vytei heh naa tua thlu khy taitah hmai, ‘A chahnai lypaw sae kaa cang he peh, kaa hre ruapaw rai pui kaa hre hi,’ tah my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zisu cawh Jerusalem lang a seining takhei, Samaria le Galili raangri khei a sei lai. ");
INSERT INTO zypNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Khua khuakheh chunglang a nae ka, thinghmuihri a ingpaw pahraw cawh Ama khatah a tong he. Langhlaw pui khei a daw he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a thangpui tah, “Zisu, Abuipaw, ning ma do ky law!” tatah a y he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aaning cawh a hmuh tih he tah Zisu taco, “Sei la, tlangbui sahlo khah a va hmuhsah my lo,” a tah he. Taico, aa seining tah langpui letah a dang he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aaning chung taitah pakhehpaw cawh ka dang tahpaw khah a hni tihtah Khazing khah a thangpui tah reithai hmo khei a va kaw kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Zisu a phehrang lekhei a bawh ka, alawngnah bia a rei. Ma cawngsaw cawh Samaria mingphing a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Zisu tah, “Dang sahpaw khah pahraw cang bei he maw? Pakuapaw saw zeletamaw aa ung? ");
INSERT INTO zypNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ma mingphing hringpaw rei ly hei a vong tah Khazing reithainah a hlaipaw pakheh chang ung be dei he?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mataico Samaria cawngsawpaw hai leco, “Tho la sei, na zingnah tah a ca dangsah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Uikheh cawh, Farasi sahlo tah zening tamaw Khazing painah raang cawh a va tlung a tatah aa haepaw khah, Zisu tah, “Khazing painah raang cawh naa hmuh khy pawtah va tlung a be. ");
INSERT INTO zypNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Cawngsaw tah, ‘Ma lehei a ung, a cang ly leh ma lekhei a ung,’ tah khy bei he, zecawtamaw tatah Khazing painah raang cawh naa chung letah a ungnah cawtah a cang,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mataico a hningzuitu sahlo hai leco, “Cawngsaw Sawcapaw heh ningkheh tachang hmuh naa du ngetei nápaw ning le cai khah a va tlung tae a, canghrasala hmuh khy a bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Cawngsaw hlupui tah, ‘Ama cawh ma lekhei a ung khi, a cang ly leh ma lehei a ung hi,’ tatah aa ca tah he a. Ama cawh hui pawtah piahly khe lo. ");
INSERT INTO zypNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cawngsaw Sawcapaw a vongnah ning leco lailaw ky katei, avai a ki rakheh taitah a ki rakheh lang a khaipalehpaw hratah a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Canghrasala a hmasaw letaco hming a hlupui khah tai-ing taw a ka, atochai cawngsaw tahei aa hlawh tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noah a chai ning leteipaw hrakhei Cawngsaw Sawcapaw a vongnah cawh a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cawngsaw sahlo cawh Noah tuilawng chunglang a naenah ning tai lekhei e he ka, ding he ka, a chuihae he ka, a hnui he. Mataico tuipa-ia cawh tlung ka, aaning vytei cawh aa dawngkasawny tah a hlyde thlu he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma heh Lot a chai ning teipaw khakhei a lo. Cawngsaw sahlo cawh e he ka, ding he ka, co he ka, zua he ka, cing he ka, ing aa sah. ");
INSERT INTO zypNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Canghrasala Lot tah Sodom khua a piasaining tah me le me a epaw kaa cawh avai taitah za so ka, aaning cawh aa dawngkasawny tah a ro cehceh he. ");
INSERT INTO zypNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma tei hraco Cawngsaw Sawcapaw a vong kaw ning taco a cang hra a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ma ning leco ing cung letei a ungpaw cawh ing chung letei a hmingbo lá pawtah a nae kheh seh. Ma hraco ly letah a ungpaw ahohmai hming sangkheh kheh lá pawtah ing lang kawkaw kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot a nupuino khah a thui thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A hringnah pachah a pachiapaw taco sung a ka, a hringnah a sungpaw taco a pachah a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ka ca ching he, ma zai leco lakhing sangkheh letah a ih hruipaw cawngsaw pahning chung taikhei pakheh cawh lah cang ka, pakheh cawh seisai a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Canu pahning tah saang suh hrui a he ka, pakheh cawh lah cang a ka, pakheh cawh seisai a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cawngsaw pahning ly chung letah ung he ka, pakheh cawh lah cang a ka, pakheh cawh seisai a cang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Abuipaw, zeletamaw ma hming cawh a tlung a?” tatah aa hae. Zisu taco, “Sarawh a ungnah hming leco langtaw pavaw cawh a pahmo tei he,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mataico Zisu tah lungdong lytah thlaw aa chang paria nápawtah cawngpahnah cawtah tawchingnah bia khah a hningzuitu sahlo a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aa hai letaco, “Khuapui khua kheh letah Khazing a ci lypaw le cawngsaw zetah a rei lypaw biacetu pakheh a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Taico ma khuapui letei a ungpaw lahme no pakheh taco ama khatah a vaw ka, ‘Ka caraepaw cung letah a dihpaw teitah bia pa cepah ky law,’ tatah a naw cakhawng leimei thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma biacetupaw taco uihlupui a bia cawh a ei. Canghrasala, a changnah leco ama le ama cawh, ‘Khazing ci ly le cawngsaw zetah rei lytah ung hmai my neh seh la, ");
INSERT INTO zypNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma lahmeno heh cawh hna a pa hnawh leimeinah cawtah a bia cawh ka cepah thlang a. Ma pawsui co, a vong khaw be ca ka, ka rei pa pathui khaw be,’ a tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Taico Abuipaw taco, “Mehding lypaw biacetu tei a reipaw heh nawthlia tua o! ");
INSERT INTO zypNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Khazing tah Ama a thingpaw cawngsaw, ching le zai tei ama khatah a y leimeipaw sahlo aa cai tah a dingpaw biacenah cawh tuapah lytah a ung a maw? Aaning bawkhang paw taco a hongsang a beh. ");
INSERT INTO zypNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ka ca ching he, a dingpaw biacenah cawh rairang tah a tuapah he a. Ma duitei cawh Cawngsaw Sawcapaw a vongkaw tihtah alui lehei zingnah a hnuipaw he hmuh siama he maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Thaikheh aaning le aaning mehding a tah ngetei he katei, cawngsaw maikaw a minghnawh pawhe sahlo khah Zisu tah ma tawchingnah bia heh a ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Cawngsaw pahning cawh behnah ing lang thlawchang rua pawtah sei he ka, pakheh cawh Farasi cang ka, pakhehpaw cawh ngungkhui kheitu a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasipaw cawh a daw ka, ama a kong thlaw a changpaw cawh, ‘Vy Khazing, cawngsaw hringpaw, damia sahlo, chahlynah a tuapaw sahlo, a pheilaipaw sahlo, a cang ly leh ma ngungkhui kheitu hrahei ka cang lynah cawtah ka ca long. ");
INSERT INTO zypNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Zaa kheh letah ning hning batui cahe tei neh ka, ka hmuhpaw vytei taitah chyhraw chykheh ka peh tei,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Canghrasala ngungkhui kheitu cawh langhlaw pui lekhei a daw ka, avai lang hmai a y ngang lytah a cacanghnaw khah a cung ka, ‘Vy Khazing, mehsuapaw kama heh ning pa do ky law,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ka ca ching he, Farasipaw khah cang lytah ma ngungkhui a kheitupaw khah Khazing hme letah thaicangsah cang tah ing lang a dihpaw cawh a cang. Ahohmai ama le ama a pasangpaw cawh panai cang ka, ama le ama a panaipaw cawh pasang a cang a,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Zisu tah tong he seh la, bonghnang song he seh tah du tah hasaitei sahlo khah aa va chua khui he. Ma cawh a hningzuitu sahlo tah hmuh he ka, aa raw he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Canghrasala Zisu tah nyheh sahlo cawh Ama kha y he ka, “Nyheh sahlo cawh Kama khatah a vong he seh, pakhang khe o! Zecawtamaw tatah Khazing painah raang cawh ma hapaw sahlo aa tei khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Biahmuisui ka ca ching he, Khazing painah raang cawh nyheh hratei a cyhlang lypaw taco a chunglang a nae by a bei he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uhtu a cangpaw pakheh tah Zisu cawh, “Cawngpahtu chaw, chaizaw hringnah ka hmuh khy nápawtah zemaw ka tua a?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Zecawtamaw a chawpaw na pa tah? Khazing tah cy ly co ahohmai achawpaw ung bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Biapeh sahlo cawh na hni thlang, ‘A phei kheh, lenong kheh, ru kheh, ahmang lypaw bia hnikhuitu cang kheh, na no le na paw cizaw my lo,’ tahpaw khah,” tatah Zisu tah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Uhtu paw tah, “Ma vytei heh cawh ka nyheh ning taitah ka zui ciapaw long tei a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma cawh Zisu tah a thui tihtah a hai leco, “Hming sangkheh naa by ning thlang. Na hnuipaw vytei zua la, mehsisah khah tangka va pei la, vaicung letah chosung na hnui a. Mataico a vong la, pa zui,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma bia cawh a thui tihtah a nge a chia ngetei, zecawtamaw tatah ama cawh mehrung a cangnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Zisu tah ama cawh ming ka, a hai leco, “Mehrung cai taco Khazing painah raang letah a nae heh cawh a ru caimang! ");
INSERT INTO zypNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hmuisui tei co, mehrungpaw tei Khazing painah raang letah a nae navy co, ceiphing kho letah sahisy a nae heh a neh vy a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ma bia a thuipaw sahlo taco, “Ma hratei a cang caco ahomaw pachah a cang khy a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Zisu tah, “Cawngsaw caw tei a cang khy lypaw heh Khazing caw taco a cang khy,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piter tah a hai leco, “Kaa hnuipaw vytei seisai tah kaa ca zui hi,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zisu tah aa hai leco, “Biahmuisui ka ca ching he, Khazing painah raang cawtah a ing cang seh, a nupui cang seh, a uny sahlo cang he seh, a no le a paw cang he seh, a sawtei leh cang he seh a seisaipaw taco, ");
INSERT INTO zypNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ato cai letei hmuh ruapaw a leh hlupui aa hmuh hlui tah a va chuh lepaw cai letah chaizaw hringnah zong aa hmuh a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zisu tah a hningzuitu hluihning cawh thokhui he ka, ma hrahei a ching he. “Jerusalem khuapui lang seichy he peh ka, Khazing khuavang sahlo tei Cawngsaw Sawcapaw kong aa ciapaw vytei khah a tling a. ");
INSERT INTO zypNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ama cawh Gental cawngsaw sahlo kih letah peh a cang a. Aaning taco hnuiso he ka, pasipasa he ka, aa ci tah chawh he ka, basung tah chei a he ka, aa thaw a. ");
INSERT INTO zypNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ningthung ning letah a thokaw a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A hningzuitu sahlo tah ma bia cawh thuithai bingbi bei he. A silang khah nokhai aa cangnah cawtah a reipaw kong cawh zemaw a cang tah hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Zisu cawh Jeriko khua a nae cai lekhei, mehcopaw pakheh cawh kih do pawtah langpui kae letah a ty thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cawngsaw rungpui aa seipaw khah a thui tihtah zehming maw a tlung, tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Nazaret Zisu a va sei!” tatah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mehcopaw taco, “David Pathlah, Zisu, ning pa do ky law!” tatah a y. ");
INSERT INTO zypNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Langhme a chuipaw sahlo taco raw he ka, de law aa tah. Canghrasala ma cawngsawpaw cawh, “David Pathlah, ning pa do ky law!” tatah a y tima. ");
INSERT INTO zypNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zisu cawh a daw ka, ma cawngsawpaw cawh kama khatah a vong khui law, a tah he. A kae a va phah tihtah Zisu taco ma cawngsawpaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na cawtah ze tuapah maw na du?” tatah a hae. “Abuipaw, khuahmuh khy ka du,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Zisu taco a hai letah, “Khuahmuh myca, na zingnah tah a ca dangsah thah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma cangkaw leco, khuahmuh khy ka, Khazing khah reithai ka, Zisu cawh a zui lai. Ma cawh cawngsaw vytei tah aa hmuh tihtah Khazing khah aa reithai hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zisu cawh Jeriko khua lang a nae ka, khua chung cawh a cahrong. ");
INSERT INTO zypNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma khua leco cawngsaw pakheh a ming Zakia aa tahpaw ung ka, ngungkhui kheitu bui pakheh cang ka, a dong a chah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ama taco Zisu cawh ahomaw a cang tahpaw khah hmuh du ngetei ka, canghrasala a ding a nai tunah cawtah cawngsaw rungpui tah pakhang he ka, hmuh khy be. ");
INSERT INTO zypNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Macawtaco a hmelang va sai ka, Zisu hmuh du taco a va sei nápaw langpui letei saikamur thuiku kung cawh a ke. ");
INSERT INTO zypNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zisu tah ma hminghmaw cawh va phah ka, a kahui ka, a hai leco, “Zakia, rairang tah za cung. Atoning heh na ing letah ka tlung a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mataico rairang tah za cung ka, Zisu cawh a lawng ngetei tah a cyhlang. ");
INSERT INTO zypNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Cawngsaw vytei tah ma cawh hmuh he ka, “Mehsuapaw khuatlung cang rua pawtah a sei thlang,” tatah a phing tlungmang he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Canghrasala, Zakia cawh a daw ka, Abuipaw hai leco, “Mingtua! Abuipaw, ato hrahring heh ka cho a chy cawh mehsisah pei he neh ka, ahohmai ka dungkhei pawhe aa ung caco, a leh pali tah ka chang kaw he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zisu taco a hai letah, “Atoning heh ma ing lehei pachahnah a va tlung myca, zecawtamaw tatah ma cawngsaw zong heh Abraham pathlah a cang hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Cawngsaw Sawcapaw cawh a lydepaw sahlo hui rua pawtah le pachá pawtah a vongpaw a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ma bia aa nge leimeining taco tawchingnah bia sangkheh khah a ching vy he. Zecawtamaw tatah Jerusalem khua khah phah daimang tei ca ka, cawngsaw vytei tah Khazing painah raang cawh a va lang palang a tatah aa rawh. ");
INSERT INTO zypNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Zisu taco, “Abui hring a cangpaw pakheh cawh siangpahrang cangnah lah rua pawtah le va kaw kaw rua pawtah raang langhlaw pui lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A sei hlai tah a sae pahraw khah y he ka, mina tangka phaehraw khah a peh he. ‘Ka va tlung hlai vytei ma tangka hei cho paleh naw my lo,’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Canghrasala, a khuasaw tah aa huanah cawtah a hninglang tah cawngsaw khah taw he ka, ‘Ma cawngsaw heh kaa siangpahrang rua tah du bei peh,’ tatah aa va chingsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Canghrasala ama cawh siangpahrang tah tua thah he ka, ing lang cawh a va tlung kaw. Mataico tangka a peh sipaw a sae sahlo khah khazeh cy maw a miasah he tah hni du takhei a ysah he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A pakhehnah cawh a vong ka a hai leco, ‘Abuipaw, na mina tangka khah phaehraw ka miasah,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A buipaw tah, ‘Na tua thai caimang, ka sae chaw! Hming a chia pawtei letah zingchui pawtah na ungnah cawtah hei khuapui khua hraw a uhtu na cang a,’ tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A pahningnah cawh a vong ka, ‘Abuipaw, mina tangka khah phaepangaw ka miasah,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A buipaw taco, ‘Nama zong khuapui khua pangaw a uhtu na cang a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mataico, a sae hringpaw a vong ka, ‘Abuipaw, na mina tangka phaekheh cawh ma heh a cang, pai tah pahlong neh ka, achaw teitah ka chia thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nama cawh mehcicia cang ceh ka, ka ca ci. Na chiapaw a cang lypaw zong law ceh ka, na cingpaw a cang lypaw zong na hre tei,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A buipaw taco, ‘Sae chah ly, nama na bia tei hratah bia ka ca cepah a. Kama cawh mehcicia, ka chia lypaw zong law neh ka, ka cing lypaw zong ka hrepaw cawh na hni, cang maw? ");
INSERT INTO zypNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A cang caco, zecawtamaw ka tangka cawh amia a ungnah letah na chia be? Chia la caw, ka va tlung tihtah a mia ka hmuh a,’ tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mataico a kae letei a dawpaw sahlo khah, ‘Ma cawngsawpaw a mina tangka heh chu la, mina tangka phaehraw a hnuipaw khah pei o,’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aaning taco, ‘Abuipaw, ama cawh mina tangka phaehraw a hnui thah!’ aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aa hai leco, ‘Ka ca ching he, ahohmai a hnuipaw cawh peh chi vy a cang a. Canghrasala, zehmai a hnui lypaw cawh a hnuitlakangpaw tei hmai khah lah pah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Macawtaco, aa siangpahrang caw tei a pa du lypaw he le ka carae a cangpaw sahlo khah ma lehei va chua khui la, ka hmekaw lehei thae o,’ tatah a palei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zisu cawh ma bia a rei khy taico Jerusalem lang sei pawtah hme lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oliv tlaang aa tahpaw letei a ungpaw Bethfes le Bethani khua khah aa phah daimang ning tah a hningzuitu pahning khah a seisah hlang he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Naa hme khua lekhei va sei la, khuachung naa nae tih he ceh tah ahotahmai aa ke bang lypaw la teitei a hrai thlangpaw naa hmuh a. A rui khah thlang he ceh ka, ma lang heh naa va hrui a. ");
INSERT INTO zypNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pakheh kheh tah, ‘Zecawtamaw ma a rui khah naa thlang?’ tatah ca tah my he seh la, ‘Abuipaw tah a hia,’ tah my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A taw hlangpaw cawngsaw sahlo cawh va sei he ka, Zisu tei a ching pawtei he hrakhei aa va hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","La teitei cawh a rui aa thlang leimeining tah a hnuitupaw sahlo takhei aaning cawh, “Zecawtamaw naa thlang?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aaning taco, “Abuipaw tah a hia,” tatah aa palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","La teitei cawh Zisu khatah va chuakhui he ka, a kai letah aa pai sahlo dae he ka, Zisu cawh aa kesah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A sei nápaw langpui lekhei cawngsaw taco aa pai sahlo cawh aa phaw. ");
INSERT INTO zypNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oliv tlaang lang tah a za cung chuhpaw langpui kae a va phah tihtah a hninglang tah aa zuipaw ming rungpui cawh aa hmuhpaw ningang chuipaw vytei rawng takhei a lawng ngetei he ka, o thangpui khei Khazing cawh aa reithai. ");
INSERT INTO zypNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Abuipaw ming tah a vongpaw siangpahrang cawh bonghnang song tah ung ky seh! Vaicung letah denah ung seh la, Cungnungcai lekhei rungnawnah ung ky seh,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Zawpui hrong letah a ungpaw Farasi thaikheh taco Zisu cawh, “Cawngpahtu, na hningzuitu sahlo heh raw tua o,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Zisu taco, “Ka ca ching he, aaning heh aa de tahmai tah alung sahlo heh a y chua he a,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalem cawh phah daimang myca he ka, khuapui cawh hmuh ka, a cawkhui. ");
INSERT INTO zypNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ze tamaw denah heh nama khatah a chuakhui a taheh atoning heh hnih tua la, taheh ka du caimang, canghrasala atoheh cawh na hmuh ly rua pawtah nokhai na cang myca. ");
INSERT INTO zypNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na carae sahlo tah nama tuh nápawtah raetuhnah ing ca sahso he ka, ca cadung he ka, a kawkih tah a ca dawkhai he ka, khunglai hmai na piathlah khylynah cai a phah tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nama le na hawkaw chung letei a ungpaw sahlo cawh alui letah aa ca nangpabai thlu he a. Khazing nama khatei a vongnah cai khah a hnih lypaw hratah na tuanah cawtah na chung letei alung sangkheh tei hmai palehly lytah aa seisaipaw ung a be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mataico Zisu cawh behnah ingdung chunglang a nae ka, hming a zua leimeipaw sahlo khah a tingchua he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aa hai leco, “Capathai letah ma hrahei cia a cang, ‘Ka ing cawh thlawchangnah ing tah a cang a,’ canghrasala naaning taco, ‘Mehru kua,’ tah naa tua,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ning tating tah behnah ing leco cawngpah he ka, canghrasala tlangbui macang sahlo le phungbia cawngpahtu sahlo le zawpui hrong letei hruitu sahlo taco, Ama cawh thaw pawtah khua aa khang leimei thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Cawngsaw vytei cawh a bia reipaw khah aa lung a cang tu thah cawtah zekhatamaw kaa tua a, tahpaw khah hnih khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ning kheh cawh Zisu tah zawpui khah behnah ingdung chung letah cawngpah he ka, thawngchawbia a ching leimeining he takhei, tlangbui macang sahlo le phungbia cawngpahtu sahlo cawh macang sahlo khakhei Ama khatah a vong he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ze nawhnuinah tamaw ma hming sahlo heh na tua? Ma nawhnuinah heh ahomaw a ca pei? Ma ching tua,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Zisu taco, “Bia sangkheh ka ca hae tua hrá he a. ");
INSERT INTO zypNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Johan tah baptisma pehnah naw a hnuipaw khah vaicung taitah maw, cawngsaw taitah maw?” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Reisia he ka, “ ‘Khazing taitah,’ tah my peh seh la, ‘Zemaw Johan cawh naa zing be?’ a ma tah a. ");
INSERT INTO zypNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Canghrasala, ‘Cawngsaw taitah,’ tah my peh seh la, zawpuipaw tahei alung tah aa ma vaseh a, zecawtamaw tatah aaning tahei Johan cawh Khazing khuavang a cang tah tlung he ka,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Macawtaco, “Ze taitah maw tahpaw hnih bei peh,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Zisu taco, “Kama zong tah ma hming sahlo heh ze hapaw nawhnuiná tamaw ka tua tahpaw ca ching hrá bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Zisu taco ma tawchingnah bia heh zawpuipaw khah a ching he. “Cawngsawpaw tah misur buichung tua ka, male khah hlei he ka, a sypui ry pawtah khua a tlong. ");
INSERT INTO zypNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hre cai a cang tihtah a sae pakheh khah ama a ting hangpaw pakhong pawtah ly a hlangpaw sahlo khaco a taw. Canghrasala ly a hlangpaw sahlo taco a sae cawh dai he ka, kih longpaw tah aa kawsah kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A sae hringpaw khah taw kaw ka, canghrasala ma paw zong cawh dai he ka, ningzaw chuipaw tah tua he ka, zehmai peh lytah aa kawsah hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A pathungnah a va taw vy tihtah ma paw zong cawh hmaw phosah he ka, khungthing lang aa vathlang. ");
INSERT INTO zypNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mataico misur buichung a hnuitupaw taco, ‘Zekhatamaw ka tua a? Ka dopaw ka sawcapaw heh ka taw a. Ama heh cawh aa cizaw phung thlang pui ta,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Canghrasala ly a hlangpaw sahlo taco ama cawh aa hmuh tihtah, ‘Ma cawngsaw heh ry cytu a cang, thé he peh ka, a ry a lah ná peh seh,’ aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Macawtaco ama cawh misur buichung alailang khah piakhui he ka, aa thaw. Ma tih taco misur buichung a hnuitupaw takhei aaning sahlo cawh zekhatamaw a tua he a? ");
INSERT INTO zypNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Va seí ka, ly a hlangpaw sahlo khah thé he ka, misur buichung khah ahringpaw khah a hlei he a,” a tah he. Ma bia cawh zawpui tah aa thui tihtah, “Ma hraco cang thai by be!” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Zisu tah aaning cawh mingpai he ka, “A cang caco, Capathai letei aa ciapaw heh zemaw a silang a cang? ‘Ing a sahtu sahlo tei aa hlawhpaw alung cawh, a biapui caipaw alung tah a cang,’ tahpaw heh. ");
INSERT INTO zypNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ahohmai ma alung cung letei a tlahpaw cawngsaw cawh kuichy thlu he ka, ma alung tei a tlahsopaw cawngsaw heh cawh a mang cici he a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Phungbia cawngpahtu sahlo le tlangbui macang sahlo tah ma tawchingnah bia a reipaw cawh aaning a rei hnopaw he a cang takhah hnih he ka, Ama tle nápaw langpui khah aa hui. Canghrasala zawpui khah aa ci he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Zisu cawh tai lytah ngia thlang he ka, mehding hratah a tua pakheipaw he cawngsaw a ngiatu sahlo khah aa taw he. Rom raang uhtu bui a hmingtuakhynah le a nawhnuinah chung letah Zisu khah aa hlai khy nápaw cawtah a reipaw bia khei Zisu khah tle pawtah a pachia he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Macawtaco male a ngialaipaw sahlo tah Zisu cawh, “Cawngpahtu na reipaw le na cawngpahnah heh ahmangpaw cang ka, aho hme hmai ming lytah Khazing langpui khah biahmuisui a cang naning teitah na cawngpah he tahpaw kaa hni. ");
INSERT INTO zypNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Macawtaco kaa cawtah Sizar letah ngungkhui peh heh ahmang maw hmang ly?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Zisu tah a zia aa thaipaw khah hnih ka, aa hai leco, ");
INSERT INTO zypNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Denari tangka phae pa hmusah tua o. Aho lingthlaw le cakhai maw a cia?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aaning taco, “Sizar a lingthlaw le cakhai,” tatah aa palei. Zisu taco aa hai letah, “Sizar a tei cawh Sizar pei la, Khazing a tei cawh Khazing pei my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma zawpui hme letei a reipaw bia lekhei a suanah cawh tle khy bei he. Taico a biachainah khah aa ningang ka, a de thlang he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mehthi thokawnah ung be a tahpaw Sadusi thaikheh cawh Zisu kha a vong he ka bia aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Cawngpahtu, Moses phungbia letah cawngsawpaw cawh sawtei sah lytah a nupui a thih sai caco, a unypaw takhei lahmeno cawh nupui tah chui kaw seh la, a thipaw caw takhei sawtei sah pápaw a cang, a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Uikheh cawh uny pasarih a ung he. A uthui caipaw tah nupui chui ka, sawtei sah lytah a thi. ");
INSERT INTO zypNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mataico, a pahningnahpaw tah lahmeno cawh chui kaw ka, a thih sai hui. ");
INSERT INTO zypNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A uny a pathungnah a cangpaw taco chui vy ka, a thih sai hrah. Aa pasarih co, ma canuno cawh chui cy he ka, sawteisah lytah a thi thlu he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A hning cai tah ma canuno zong cawh a thi hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Macawtaco thokawnah letah ma canuno cawh aho a nupui maw a cang a? Aa pasarih tah ma canuno khah aa chui tlung,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Zisu taco, “Khazaw cawngsaw heh aa chui aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Canghrasala, mehthi sahlo patho kaw a cang tihtah ma cai letei a ung tlang pawtei rawhpaw cawngsaw sahlo aa cai leco a chuihae cawh ung khaw a be. ");
INSERT INTO zypNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Vaiming hratah cang he ka, thi khy khaw bei he. A thokawpaw sawtei sahlo aa cangnah cawtah aaning cawh Khazing sawtei a cang myca he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Canghrasala chingbu me tei a kangpaw phungpaw lekhei Moses tahmai tah mehthi sahlo aa thokawpaw khah palang ka, Abuipaw cawh ‘Abraham Khazing, Isak Khazing, Jakob Khazing’ a cang a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ama cawh mehthi aa Khazing cang be, canghrasala mehring aa Khazing a cang. Zemaw tah pawco ma cawngsaw vytei cawh Khazing mehmuh letaco a hring he,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Phungbia cawngpahtu thaikheh tah, “Cawngpahtu, bia na paleipaw he a chah caimang,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Taico ahotahmai bia hringpaw hae ngang khawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Taico, Zisu tah aa hai leco, “Ze silang tamaw Khri cawh David pathlah aa tah? ");
INSERT INTO zypNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","David ama ceingei tei a reipaw cawh, ‘Abuipaw tah ka Buipaw cawh, na carae sahlo khah na phe rai letah ka chia hlai vytei he cawh, ka cacang lang letah a ty my lo a tah,’ tatah a tahpaw khah Reithainah Hlaw cabu letah a cia. ");
INSERT INTO zypNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David tah Khri cawh, ‘Abuipaw,’ a tah tlung, zekhatamaw David a sawcapaw cawh a cang thai a?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Zawpuipaw tah aa nge thlang chung takhei Zisu tah a hningzuitu sahlo cawh, ");
INSERT INTO zypNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Phungbia cawngpahtu sahlo khah a raering my lo. Aaning cawh a ngepaw angki a pasuapaw a hrei tah a khia lai du he ka, chodo tlaang lekhei cizaw hmotah bia a ching khah aa du hlui tah synagog letah a chaw caipaw dyching letah a ty du he ka, kawngchuanah letah achaw caipaw hminghmaw khah aa du. ");
INSERT INTO zypNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lahme sahlo aa ing khah chu he ka, male hmuh ruapaw tah thlaw a sypui tah aa chang. Ma hapaw cawngsaw sahlo cawh a sah caipaw dangtahnah aa ing tae a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zisu cawh a kahui ka, mehrung sahlo tei behnah ing tholong thingkawng chunglang aa tholong aa thlah leimeipaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mehsisah lahmeno tei phaesai phaehning a thlah hrahpaw zong khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Biahmuisui ka ca ching he, ma mehsisah lahmeno tahei aho navy zong tah a hlu cai tholong a thlah. ");
INSERT INTO zypNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ma sahlo vytei tahei co aa hnuipaw a hluipaipaw chung taikhei aa peh. Canghrasala ma lahmeno tahei co a dongchia hmo tah a hringnah caw tei a hnuipaw vytei a peh thlu hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A hningzuitu thaikheh taco behnah ing khah a hmui a ngepaw alung sahlo tah le Khazing letei hlaipaw cho le pe sahlo tei aa pasangpaw kong cawh aa rei leimei. Canghrasala Zisu tah, ");
INSERT INTO zypNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ma lehei naa hmuhpaw vytei he alung phaekheh hmai heh palehly lypaw a ung lynah cai a va chuh tae a. Aa zongmingtei hei va hly thlu a cang tae he a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aaning sahlo taco, “Cawngpahtu, ma hming sahlo cawh zening tamaw a cang a? Taico ze hapaw paching pakhanah maw a ung a?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zisu taco, “Aho tahmai aa ca dungkhei ly nápaw he tah a raering my lo. Ka ming tah cawngsaw hlupui va chua he ka, ‘Kama heh Ama cawh ka cang, cai a ne myca,’ aa tah tae a. Ma sahlo cawh zui khe lo. ");
INSERT INTO zypNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Raetuhnah le raang chung letah rae a dynah thongpang naa thui tihtah a pahly khe lo. Ma hming sahlo heh a tlung taw ruapaw a cang, canghrasala a changnah cang balang be,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mataico aa hai letah, “Raang kheh le raang kheh a dy a he ka, painah le painah a dy he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aling a sah pui tah a hrui a, hming hlupui letah cakaang le ngae-y asawnah a tlung a. Mataico, cichuipaw hming sahlo le paching pakhanah a rungnawpaw sahlo avai taitah a lang a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Canghrasala, ma vytei hlai tahei ca tle he ka, aa ca hrai he a. Synagog sahlo lang ca seikhui he ka, thong aa ca thla he a. Siangpahrang sahlo le uhtubui sahlo hme letah ca chuakhui he ka, ma vytei heh naa pa zuinah rawng tah a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma heh naa cawtah ka kong reinah caichaw a cang a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Naaning a rungvai nápaw cawtah zekhatamaw bia kaa rei a tatah lung reithui tah naa ung ly nápawtah naa thinglung a pacy pacia my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naa carae ahohmai tah aa ca te khy ly nápaw he tah le aa ca ei khy ly nápaw he tah bia sahlo le singnah ka ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Naa no sahlo le naa paw sahlo, naa uny sahlo, naa sawny sahlo le naa huivesaw sahlo tahmai tah ca luithae a he ka, meh thaikheh cawh aa ca thaw he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kama ka rawng tah cawngsaw vytei tah aa ca hua he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Canghrasala, naa lu cung letei sangbu bukheh hmai lyde a be. ");
INSERT INTO zypNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Cy ky tah a daw la, hringnah naa cy a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Raekeh sahlo tah Jerusalem khuapui aa cadungpaw naa hmuh tihtah a ry hlai tah a rawh a, tah cawh naa hni a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mataico Judia raang letei a ungpaw cawngsaw sahlo cawh tlaang cung lang sai he seh la, khuapui leteipaw sahlo cawh pia he seh. Taico khuapui alailang leteipaw sahlo cawh khuapui chunglang a nae kheh he seh. ");
INSERT INTO zypNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ma heh cawh dangtah nápaw cai, Khazing bia letei a ciasipaw vytei a tling nápaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ma ning cawh sawtei a phopaw canu sahlo le nysai a tlepaw no sahlo aa caw taco zetlua tamaw ningping a chui a! Raang chung letah rorangnah alaipaw pui tlung ka, Khazing thingaenah tah ma mingphing heh a carae he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aaning cawh zyzi tah thaw cang he ka, thaikheh cawh raang ting letah sae tah seikhui a cang he a. Khazing tah Gental cawngsaw sahlo cawtah a pachiapaw cai a tlingnah tai Jerusalem cawh Gental cawngsaw sahlo taco aa phe tah aa tlaichai a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ning, thlawpaw le esi sahlo letah paching pakhanah a ung he a. Rili tuileh a thopaw le a pyraw rawng tah aluicung raang sahlo cawh thlawzawng le ningping tah a ung he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Khazaw letei hming a va tlung lepaw khah aa hninah cawtah le avai hmingtuakhynah sahlo zong cahneh aa cang a cawtah mehnung cawh ci tu he ka, a cathing he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ma cai leco aaning tah Cawngsaw Sawcapaw khah hmingtuakhynah le rungnawnah khatah meding hrong letah a vongpaw khah aa hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma hming sahlo cang hrang a pathoning tahei a daw la, a huichy my lo, zecawtamaw tatah naaning tlang nápaw cai cawh a ne myca,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma khy taico Zisu tah aaning cawh ma tawchingnah bia heh a ching he. “Ma thuiku kung le thingkung ahringpaw vytei sahlo heh mingtua hmai o! ");
INSERT INTO zypNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A chawng a ka thopaw naa hmuh tihtah nipui ning a ne myca tahpaw naa hni. ");
INSERT INTO zypNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ma hraco ma hming sahlo heh a cang leimeipaw naa hmuh tihtah Khazing painah raang cawh a ne myca tah hnih my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Biahmuisui ka ca ching he, ma hming vytei heh a tlung hlai vytei cawh atochai cawngsaw sahlo heh thi thlu balang bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Alui le avai cawh a rawh a, canghrasala ka bia cawh a rawh by a be. ");
INSERT INTO zypNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","A raering my lo, ma tei a cang ly caco a nawngsenah, zu ruinah le tungtuh khuasahnah lungreithuinah takhei ca nai a he ka, ma ning takhei ahui hratah rawh ly pui tah a ca o pang he a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ma ning cawh aluicung pungpaluh letei a ungpaw cawngsaw vytei cung letah a tlung a. ");
INSERT INTO zypNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","A va chuh lepaw vytei taitah naa lua khy nápawtah le Cawngsaw Sawcapaw hme letah na daw pacy khy nápaw he ceh tah a mai pacia tah ung paria thlang la, thlawchang my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ning tating tah Zisu taco behnah ing letah cawngpah he ka, zailang maikaw cawh Oliv tlaang aa tahpaw letah zai hmang rua pawtah a piathlah tei. ");
INSERT INTO zypNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Taico ming vytei cawh a bia nge rua pawtah mongdi tah behnah ing leco a va chuh tei he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Raangri phi lypaw Very Panawnah le Khungsai Panawnah aa tahpaw a ne myca ka, ");
INSERT INTO zypNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","tlangbui macang sahlo le phungbia cawngpahtu sahlo tah Zisu thaw khy nápaw lang le si khah aparuh teitah aa hui, zecawtamaw tatah zawpuipaw khah aa ci he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mataico, a hningzuitu hluihning letei pakheh a cangpaw Iskariot aa tahpaw Judas chung letah Setan cawh a nae. ");
INSERT INTO zypNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Taico Judas cawh tlangbui macang sahlo le behnah ing a mingkaitu abui sahlo khatah sei ka, zekhatamaw Zisu a luithae a tahpaw kong khah aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aa thawchah ngetei ka, tangka peh rua pawtah aa naw a tlah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas zong cawh a lungtling ka, zawpui aa ung ly kaa tah aa kih letah Zisu hlai khy nápaw caichaw khah a haw thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mataico Khungsai Panawnah cawtah tuu teitei tah thuihlainah ning a cangpaw raangri phi lypaw Very Panawnah ning cawh a va phah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zisu tah Piter le Johan cawh taw he ka, “Sei la, kaa cawtah Khungsai Panawnah zairia enah cawh va pachia tua o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aaning taco, “Zeletamaw va pachia he seh tah na du?” tatah hae he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zisu taco, “Khuapui chung a va nae la, beirai tah tui a cui laipaw capaw pakheh tah a ca tong he a. Ama a naenah ing lang va zui he ceh ka, ");
INSERT INTO zypNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ing a hnuitupaw khah, ‘Cawngpahtu tah ka hningzuitu sahlo khatah Khungsai Panawnah zairia ka e nápaw mehlai khang zeletamaw a ung, a tah,’ tatah naa hae a. ");
INSERT INTO zypNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ama taco a cung khang a kypaw pui, tingtua cia tei a cangpaw khah a ca hmuh sá he a. Ma leco va pachia my lo,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Piter le Johan cawh seithlah he ka, Zisu tah a chingpaw he hrakhei hming sahlo cawh aa va hmuh. Ma leco Khungsai Panawnah zairia cawh aa pachia. ");
INSERT INTO zypNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A cai a va tling tihtah Zisu le Ama apostol sahlo taco cabuai cawh aa cadung. ");
INSERT INTO zypNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Taico Zisu tah aa hai letah, “Kama cawh ruhanah ka ing hlai tahei naaning khatah ma Khungsai Panawnah zairia e hrui heh ka du ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Macawtaco ka ca ching he, Khazing painah raang letah ma Khungsai Panawnah tlingnah cai a tlung hlai vytei ma zaibatui heh e kaw khaw bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Taico ny khah law ka, Khazing letah alawngnah bia hlai ka, “Ma misurhang ny heh law la, a hlai pachaw my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka ca ching he, Khazing painah raang a va chuanah tai ma misurhang heh ding kaw khaw bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Taico very cawh law ka, Khazing khatah lawngbia a hlai khy taitah kychy ka, aaning cawh pei he ka, “Ma heh naa cawtah ka pehpaw ka pung cawh a cang hi. Kama monghly ly nápawtah tua tei my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ma hraco zairia aa e khy taitah ny cawh law ka, “Ma ny heh naa caw tei a laipaw, ka thisai tei tuapaw biahrai thapaw cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kama a pa lui a paw cawngsawpaw cawh ma lehei kama khatah cabuai letah a ung. ");
INSERT INTO zypNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cawngsaw Sawcapaw cawh Khazing bia thlia ciapaw hratah a thi a. Ma duitei cawh Ama a luipaw cawngsaw cawh a cing a ping,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aaning le aaning cawh ahomaw ma hming heh a tua a, tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aaning hrong letah ahomaw alaicai a, tahpaw bia a einah zong khah aa hrong letah a chuh. ");
INSERT INTO zypNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Zisu taco aa hai letah, “Gental cawngsaw sahlo cung letei abui sahlo cawh a buisah ngetei he ka, aa nawhnuinah aa hmangpaw cawh, ‘A ca bawngtu ka cang he peh,’ tatah aaning le aaning a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Canghrasala naaning cawh aaning hratah ung khe lo! Naa hrong letei alaicaipaw cawh a chia caipaw hratah ung hri seh la, uhtu a cangpaw taco sae hratah ung hri seh. ");
INSERT INTO zypNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ahomaw alai vy? Cabuai letei a typaw maw batui a peitu maw? Cabuai letei a typaw cawh lai vy bei maw? Canghrasala kama cawh male rai hrepah tu pakheh hratah naa hrong letah ka ung hi. ");
INSERT INTO zypNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Naaning cawh hanah ka ingpaw vytei letah a pa dawkhuitu na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Taico ka paw tah painah raang a pa pehpaw hratah naaning khah ca pei hrá he neh ka, ");
INSERT INTO zypNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","macawtaco ka painah raang letei ka cabuai letah e he ceh ka, naa ding a. Abui dyching letah a ty he ceh ka, Israel phinghraw hluihning khah bia naa ce he a. ");
INSERT INTO zypNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, lythlopaw tah sacang a vangpaw hratah Setan tah naaning khah hnehsah a pawtah nawhnuinah hmuh a du my ca. ");
INSERT INTO zypNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Canghrasala Simon, na zingnah cawh a po ly nápawtah na cawtah thlaw ka chang thah. Taico kama lang na va hui kaw tihtah na uny sahlo khah thawzaang pei my lo,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Canghrasala Piter taco, “Abuipaw, nama khatah thongtlá tah thihnah tai ka mai thlang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Zisu taco, “Ka ca ching, Piter, atoning aa a khawng hlai tahei na pa hninah lehei uithung tai na pa paphahsai a,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mataico, Zisu tah a hningzuitu sahlo cawh, “Tangka ly, sahre lytah le phepakong lytah ka ca taw tih he tah ze na phahlahnah he ceh a ung maw?” tatah a hae he. Aaning sahlo taco, “Ung be,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Zisu tah aa hai leco, “Canghrasala atoheh cawh tangka naa hnui caco a kai la, sahre zong a kai la, taico zyzi naa hnui ly caco naa angki pasuapaw khah zua la, co my lo. ");
INSERT INTO zypNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ma hrahei Capathai letah ciapaw a cang, ‘Taico ama cawh hmingsua a tuapaw sahlo khatah reipai a cang a.’ Ma heh kama letah a tling ruapaw a cang tah ka ca ching he. A cang, ka kong a ciapaw heh a tlingnah cai a phah leimei myca,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A hningzuitu sahlo taco, “Abuipaw, mingtua, zyzi sanghning a ung thlang hi,” tatah aa tah. Zisu taco, “A zaw seh,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zisu cawh a tua teipaw hrakhei Oliv tlaang lang cawh sei ka, a hningzuitu sahlo tah Ama cawh aa zui. ");
INSERT INTO zypNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","A hminghmaw cawh aa phah tihtah aa hai leco, “Tuhsonah chung lang naa tlah ly nápawtah thlawchang my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ama cawh aaning khah a cawngpe va long he ka, a khuh panai ka, thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Vy Ka paw, na naw a tlah pawtei a cang caco ma tai-ingnah ny heh kama taitah law hly thlang. Canghrasala kama ka dunah hratah cang lytah nama na dunah hratah cang ky seh,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Vaicung taitah vaiming pakheh cawh ama kha a za paly ka, thawzaang a peh. ");
INSERT INTO zypNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Taico a lung rei a thui tunah cawtah khei lungsaw chingching tah thlawchang vy hui ka, a mathlai cawh thi di hratah alui letah a tlah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A thlawchangnah taitah tho ka, a hningzuitu sahlo khakhei a vaw kaw tihtah aa ihningpaw khah hmuh ka, ngechia tah aa ung cawtah aa thaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Zemaw naa ihning thlang? Tho la, tuhsonah chunglang naa tlah ly nápawtah thlawchang my lo,” tatah aaning cawh a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ma hratei a rei leimeining taco cawngsaw rungpui va chuh he ka, aaning sahlo cawh a hningzuitu hluihning letei pakheh a cangpaw Judas aa tahpaw takhei a va seikhui he. Zisu cawh hnang rua pawtah khei a va ne. ");
INSERT INTO zypNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Canghrasala Zisu tah ama cawh, “Judas, Cawngsaw Sawcapaw heh hnang ceh ka maw, na luithae a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zisu a hningzuitu sahlo tah, hming a cang leimeipaw khah aa hmuh tihtah, “Abuipaw, kaa zyzi hei kaa tuh a he maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Taico aa hrong letei pakhehpaw tah tlangbui alaicaipaw a sae capaw khah tuh ka, a cacang lang tei a naw khah a pathai thlah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Canghrasala Zisu tah, “Ma khah a zaw myca,” tatah a tah. Taico cawngsawpaw a naw khah tong ka, a dangsah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mataico Zisu tah Ama a va seihnopaw tlangbui macang sahlo le behnah ing a congpaw sahlo aa bui sahlo le macang sahlo he khah, “Zyzi le thingtai kha naa va seipaw heh kama cawh rae a thopaw he hotu tamaw ka cang? ");
INSERT INTO zypNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ning tating tah naaning kha behnah ing letah ung tei neh ka, ka cung letah naa kih naa thlah tlung be. Canghrasala ato cai heh cawh muinah tei a uhpaw naaning naa cai a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mataico Zisu cawh tle he ka, seikhui longmang he ka, tlangbui alaicaipaw a ing chunglang taikhah a naekhui he. Piter tah langhlaw pui khei a zuilai. ");
INSERT INTO zypNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Canghrasala inghme a le lekhei me tua he ka, me a ai tah a ty cadungnah pawhe lekhei Piter cawh aaning sahlo khakhei hmingkheh tah a ty hrah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Saecanu pakheh tah Piter ma letei a typaw khah a hmuh. Ma no taco ama cawh va mingchai ka, “Ma cawngsawpaw heh Zisu kha a ungpaw a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Canghrasala ma cawh a paphah ka, “Cawngsawno, Ama heh hnih bei neh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A cawngpe ung ka pakhehpaw tah Ama cawh hmuh ka, “Nama zong aa hrong letei pakheh na cang,” a tah. Piter taco, “Cang bei neh,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Suimehlang pakheh tluh lekhei ahringpaw pakheh tah, “Ma cawngsawpaw heh Galili cawngsaw a cangnah cawtah hei Zisu kha a ungpaw a cang hrahring,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piter taco, “Na rei leimeipaw kong heh hnih bei neh,” tatah a palei. Ma hratei a tah leimeining taco aa cawh a khawng. ");
INSERT INTO zypNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Abuipaw cawh Piter lang cawh a hui ka, a va ming. Taico Piter cawh Abuipaw tei a hai letei a reipaw, “Atoning heh aa a khawng hlai tah uithung na pa paphah sai a,” a tahpaw khah a thui kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Taico alailang piathlah ka, o tlili tah a cah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Zisu cawh a congpaw raevai sahlo takhei pasipasa he ka, aa cabai. ");
INSERT INTO zypNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aaning sahlo taco a meh pamai he ka, “Ma ching tua, nama Khazing khuavang! Ahomaw a ca tuh?” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Taico ma sahlo taco Ama cawh aisainah bia a hlupui tah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Khua hme a se cangkawleh biacetu macang a cangpaw sahlo cawh tlangbui macang sahlo le phungbia cawngpahtu sahlo khakhei hmingkheh tah a tong he ka, Zisu cawh aa hme lekhei aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Khri cawh na cang maw? Ma ching tua,” aa tah. Zisu tah, “Ka ca ching zong he tah pa zing bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ka ca hae zong he tah pachai bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Canghrasala ma taihei co, Cawngsaw Sawcapaw heh Cungnungcai Khazing a cacang lang letah a ty myca a,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aa zongmingtei co, “Khazing Sawcapaw cawh na cang maw?” tatah aa hae. Zisu taco, “Khazing Sawcapaw na cang tatei naa reipaw cawh ahmang,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mataico aaning taco, “Ze hringpaw biahninah maw kaa hia khawh? Ama a hmo taitah ma bia kaa thui thah taico,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mataico a pahmopaw vytei cawh tho he ka, Zisu cawh raang uhbui Pilat khatah aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Taico, Ama cawh sua pu he ka, “Ma paw tahei kaa mingphing a pingpaly tah a hruipaw he kaa hmuh. Ama tahei Sizar khatah ngungkhui pei khe law tah ka, Khri a cangpaw siangpahrang ka cang a tah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Macawtaco Pilat tah Zisu cawh, “Juda cawngsaw aa siangpahrang cawh na cang maw?” tatah a hae. “A cang, na reipaw hraco a cang,” tatah Zisu tah a palei. ");
INSERT INTO zypNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mataico, Pilat tah tlangbui macang sahlo le zawpuipaw cawh, “Ma paw sua pho rua pawtah hei a chahlynah zehmai hmuh bei neh,” tatah a thang he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Canghrasala aaning sahlo taco, “Ama tahei Judia raang pungpaluh letei cawngsaw sahlo cawh a cawngpah ná tah hnahnawhnah a chuasah. Galili taitah a patho ka, ma tai heh a va phahpaw a cang,” tatah thaw tah aa rei. ");
INSERT INTO zypNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma cawh a thui tihtah Pilat taco, “Ma paw heh Galili cawngsaw maw a cang?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Zisu cawh Herod a uhnah rai letei a ungpaw Galili raang cawngsaw a cang tahpaw khah Pilat tah a hni tihtah ma ningcai letei Jerusalem letah a ung thlangpaw Herod khakhei a seisah khui he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod tah Zisu a hmuh tihtah a lung a lawng ngetei, zecawtamaw tatah cai sypui hmuh a za du ngetei cawtah a cang. Zisu a thong khah a za thui teinah cawtah ningang chuipaw hming sahlo a tuapaw khah ka hmuh myca a, tatah a hnabei a sui. ");
INSERT INTO zypNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bia a hlupui hae cakhia ka, canghrasala Zisu tah zehmai chai be. ");
INSERT INTO zypNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tlangbui macang le phungbia cawngpahtu sahlo cawh ma leco a daw thlang hrah he ka, Zisu cawh a sah pui tah sua aa pu leimei. ");
INSERT INTO zypNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mataico, Herod le a raekeh sahlo tah Zisu cawh hnuiso he ka, aa pasi aa pasa. Pai achaw ngeteipaw a buhsah he ka, Pilat khatah aa seisah kaw. ");
INSERT INTO zypNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma ning taico Pilat le Herod cawh huivesaw a cang he. Ma hlai taco a za carae tei he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat tah tlangbui macang sahlo le uhtu sahlo le zawpuipaw khah y pahmo he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","aa hai letah, “Ma paw heh zawpui khah carae tah a thosah he tatei kama kha naa va chuakhuipaw khah a cang. Ama heh naa hmekaw letah haecakhia neh ka, reipachia tei sua naa pupaw heh a dongkhang be tatah ka hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod zong tah, a suanah hmuh be ca ka, kaaning kha a va ma kua kawpaw a cang. Naa hmuh thlangpaw hratah thih tlang a tlahpaw hming zehmai tua be. ");
INSERT INTO zypNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Macawtaco chei sá he neh ka, mataico ka thlaw a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Khungsai Panawnah ning maikaw letah Pilat tah thong a tlahpaw chung taitah pakheh khah a thlaw hrahring ruapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Zawpui sahlo cawh hmokheh tah y hrui he ka, “Ama cawh theh thlang la, Baraba khah ma thlawpah hri,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba cawh khuapui chung letah rae a tho sahpaw a cang rawng tah le lee a nongpaw rawng tah thong a tlahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat tah Zisu cawh thlaw a dunah cawtah khei aaning cawh a hae hry he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Canghrasala aaning taco, “Khraws letah khaipai! Khraws letah khaipai!” tatah a y vy tima he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A uithungnah leco aaning cawh, “Ze rawng tamaw? Ma paw tahei ze suanah ky maw a tua? Thihnah tai dangtá pawtah a panah zehmai hmuh bei neh. Macawtaco chei sá he neh ka, ka thlaw a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Canghrasala, Ama cawh khraws letah khaipai tatah tai lytah a thangpui tah y he ka, aa ypaw takhei Pilat khah a pahnei. ");
INSERT INTO zypNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Macawtaco Pilat tah aa haepaw khah peh a pawtah bia a chaw. ");
INSERT INTO zypNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilat taco hnahnawhnah le lenongnah rawng tei thong a tlahpaw, aa haepaw Baraba khah thlaw ka, aa dunah hrakhei tua rua pawtah Zisu cawh a hlai he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Zisu cawh raekeh sahlo tah seikhui he ka, langpui letah khuatei lang tah khua a va tlongpaw Sairin khuapaw Simon khah tle he ka, khraws cawh a cung lekhei khing he ka, Zisu hninglang khei aa puhsah lai. ");
INSERT INTO zypNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Cawngsaw a rungpui takhei pazui he ka, a cawtah a ngechia katei, a cahpaw canu sahlo zong a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zisu tah a paleh ka aa hai leco, “Jerusalem sawcanu sahlo pa cawkhui khe o, naaning naa cawtah le naa sawtei leh cawtah cah hri my lo, ");
INSERT INTO zypNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","zemaw tah pawco, ‘A cingpaw canu sahlo, sawtei a pho bang lypaw chi le meimei zai bang lypaw hnabae sahlo cawh bonghnang a tingpaw a cang he,’ tatah naa tah nápaw cai a va chuh a! ");
INSERT INTO zypNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mataico, ‘aaning sahlo tah tlaang sahlo cawh, “Ma tlahso law,” tah he ka, tlangby sahlo khah, “Ma vuh law,” aa tah he a.’ ");
INSERT INTO zypNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma hming sahlo heh cawngsaw tah thingkung a hring thlang ningtah hmai aa tua caco, thingkung a ro tihtah co zemaw aa tua chichi a?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ahringpaw cawngsaw pahning, mehsua va vei khah Zisu khatah thaw hrui rua pawtah aa seikhui hrah he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Luru hming aa tahpaw hminghmaw aa va phah tih taco, ma leco Ama cawh damia sahlo khakhei pakheh khah a cacang lang letah pakheh khah a cavui lang letah aa khaipai he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Zisu taco, “Apaw, ngethai my lo, aa tua leimeipaw heh aa hnilynah cawtah hei,” tatah a tah. Taico raekeh sahlo taco basung phe he ka, a chaichi cawh a chaichy he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zawpuipaw cawh ma lekhei a daw he ka, ming thlang he ka, uhtu sahlo tahmai tah aa hnuiso. “Cawngsaw ahringpaw cawh pachah he ka, Khazing a thingpaw, Khri a cang hmuisui caco, ato heh ama le ama cawh a pachah seh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Raekeh sahlo zong taco a vong he ka, Ama cawh pasipasa he ka, misur zu a thobahlapaw khah aa hlai. ");
INSERT INTO zypNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Juda cawngsaw aa siangpahrang na cang caco nama le nama a pachah ca,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A lu cung letei ca a ciapaw cawh, “MA HEH JUDA CAWNGSAW AA SIANGPAHRANG A CANG,” tah heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma letei aa pathle hrahpaw suanah a tuapaw pakhehpaw taco Ama cawh naisui hmo khei, “Khri cawh cang bei ceh maw? Nama a pachah la, kaaning zong ma pachah hrah tua!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Canghrasala, mehsua ahringpaw pakheh taco raw ka, “Khazing hmai heh ci bei ceh maw? Ama khatah a lopaw tah hreh na cangpaw heh! ");
INSERT INTO zypNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kaaning cawh hreh tlang ka cang peh, kaa tuasanah khatah a tlahpaw kaa hmuh hi. Canghrasala ma cawngsaw heh cawh suanah zehmai tua be hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mataico ama taco, “Zisu, na painah raang na phah tihtah a pa thui thlang my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Zisu taco ma cawngsawpaw cawh, “Biahmuisui ka ca ching, kama khatah Paradis letah atoning na ung hra a,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ningching suimehlang hluihning hrong taitah zailang suimehlang pathung tai raang pungpaluh letah muinah a tlung, ");
INSERT INTO zypNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","zecawtamaw tatah ning a khainah khah a calinah cawtah a cang. Taico, behnah ing letei pai pazypaw cawh pehning tah a hria chy. ");
INSERT INTO zypNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zisu tah a thangpui tah, “Apaw, nama khatah ka thlawpaw ka chia,” tatah a y. Ma hraco a rei khy cangkawleh cawh a hu a ceh chung. ");
INSERT INTO zypNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma cawh raekeh zakheh buipaw tah a hmuh tihtah Khazing cawh reithai ka, “Ma cawngsaw heh mehding a cang hrahring thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma hming ungzia hnikhui rua pawtei a pahmopaw cawngsaw vytei tah ma hming khah aa hmuh tihtah ngechia tah aa cacanghnaw a cung he ka, a seihly thlu he. ");
INSERT INTO zypNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Canghrasala, Galili raang tai tei a va zuipaw canu sahlo reipai tah Ama a hnihpaw vytei taco a langpa khei a daw he ka, ma hming sahlo cawh aa cai thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ma leco Juda khongsil chung letah a taepaw mehchaw mehding a cangpaw Josef aa tahpaw ung ka, ");
INSERT INTO zypNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","bia aa thliapaw le rai aa hrepaw cung letah a nawtlah beh. Ama cawh Judia raang, Arimathea khua taitah a vongpaw cang ka, Khazing painah raang a va tlungpaw a heh thlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilat khaco va sei ka, Zisu a rawh cawh a va hae. ");
INSERT INTO zypNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mataico a rawh cawh khraws taitah lawthlah ka, paithladih anaipaw tah pahlong ka, alung kho aa ruipaw thlai thapaw ahohmai aa phung bang lynah pawhe lekhei a isah. ");
INSERT INTO zypNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma cawh ningpangaw ning Sabat ning cawtah pachianah ning cang ka, Sabat ning cawh a patho daimang tei. ");
INSERT INTO zypNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili taitah Zisu khatei a va seipaw he canu sahlo takhei Josef cawh zui he ka, athlai le a chung letei rawh cawh zekhatamaw aa isah tahpaw khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mataico aaning cawh ing lang a dih he ka, a rawh cawtah ringthopaw sahlo le zihmui ringthopaw aa pachia. Canghrasala phungbia aa zuinah cawtah khei Sabat ning leco a hia he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Zaa kheh letei ning hmetaw caipaw mongdi letaco canu sahlo cawh aa pachiapaw sathy ringthopaw sahlo khah a tle he ka, thlai lang cawh aa va sei. ");
INSERT INTO zypNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aaning sahlo taco thlai taitah alung a hneihlypaw cawh aa hmuh, ");
INSERT INTO zypNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","canghrasala a chunglang a nae tih he tah Abuipaw Zisu a rawh cawh hmuh bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma leco lunghnahnawh tah aa ung thlang ning takhei, sungkheh teitah cawngsaw pahning, aa caise lailaw hratei a khai thai ngetei pawhe khah aa kae letah a va daw he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Canu sahlo cawh aa ci cawtah khei alui lang a bung he ka, canghrasala capaw pahning taco, “Zecawtamaw mehthi hrong letah mehring cawh naa hui? ");
INSERT INTO zypNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ama cawh ma lehei ung khawh be, a thokaw thah! Galili raang letah naaning khatah a ungning tei a ca chingpaw he khah a thui thlang bei he ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Cawngsaw Sawcapaw cawh mehsua sahlo kih letah peh a cang a, khraws letah khaipai he ka, ningthung ning letah a thokaw a,’ a tahpaw khah,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mataico canu sahlo taco Zisu a bia khah a thui kaw he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Thlai lang tah a va dih kaw he ka, ma hming vytei khah a hningzuitu hluikhehpaw le ahringpaw sahlo cawh aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aaning sahlo cawh Mari Makdalin, Joana, Jeims a no Mari le aaning khatei a ungpaw ahringpaw, ma kong apostol sahlo a chingpaw he khah a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Canghrasala, aaning sahlo taco canu sahlo tei aa reipaw cawh bia tah sah be ca he ka, zing bei he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma duitei cawh Piter suipaw cawh tho ka, thlai lang khah a va sai. A bung ka, ming ka, thlai chung letei Zisu aa pahlongnahpaw paithladih cy khah a hmuh. Taico seithlah ka, hming a cangnah silang kong cawh a khuarawh a haa ngetei. ");
INSERT INTO zypNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma ning lilaw leco Zisu a hningzuitu letah pahning cawh Jerusalem taitah khang sarih tluh a hlahpaw Emau khua lang cawh a sei he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aaning cawh pakheh le pakheh khah a cangpaw hming vytei kong khah aa reihrui lai. ");
INSERT INTO zypNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma hming sahlo kong cawh reilai he katei, bia a rawh laining he takhei, Zisu cawh va chuh ka, aaning khaco a sei hrah, ");
INSERT INTO zypNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","canghrasala aa bi khy nápawtah pakhang a cang he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Zisu taco aa hai letah, “Naa seipai tah ze bia maw na rawh lai he ceh?” tatah a tah he. Aaning cawh a daw he ka, aa hme a chia thlang. ");
INSERT INTO zypNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aa hrong letei pakhehpaw Kleopa aa tahpaw taco Zisu cawh, “Jerusalem khuapui a va tlongpaw letah nama cy heh ato cai letei hming a cangpaw sahlo heh a hnih lypaw cang ceh maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Zisu taco, “Zehming maw?” tatah a hae. “Nazaret Zisu kong samaw,” tatah a palei. “Ama cawh Khazing khuavang pakheh cang ka, ming hme le Khazing hme lekhei bia le tuanah letah hming tuakhynah a hnui. ");
INSERT INTO zypNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tlangbui macang sahlo le a ma uhtu sahlo tah thaw rua pawtah nawhnuitu sahlo khatah bia pei he ka, khraws letah aa khaipai. ");
INSERT INTO zypNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Canghrasala Ama cawh Israel mingphing a tlang ruapaw he pakheh a cang, tatah kaa hnabei a suipaw khah a cang. Ma hlui co ma hratei hming a cangnah heh atoheh a ningthungnah a cang myca. ");
INSERT INTO zypNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma hlui co, kaa phu chung taitah canu thaikheh sahlo tah kaa ning aa ma angsah. Ato zamong mongdi khei thlai lang va sei he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","canghrasala a rawh hmuh bei he. Kaaning khatah a vong he ka, Zisu cawh a hring thlang tatah a reipaw he vaiming sahlo a palypaw he khah kaa hmuh tatah aa ma ching. ");
INSERT INTO zypNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mataico kaa vesaw thaikhehpaw tah thlai lang va sei he ka, canu sahlo tei aa reipaw hrakhei aa va hmuh, canghrasala ama cawh hmuh bei he,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Zisu taco aaning cawh, “Na hruh caimang he ceh, Khazing khuavang sahlo tei aa za rei ciapaw vytei zing nápawtah naa lungthing a ku a chaw caimang! ");
INSERT INTO zypNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Khri tah ma hming sahlo heh a tai-ing ceingeipaw cang ka, taico a rungnawnah lang a naepaw cang bei maw?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aaning cawh Moses le Khazing khuavang sahlo vytei tei Ama a kong Capathai letei aa reipaw naning tei hrakhei a chingpase he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aa va sei nápaw khua khah aa va phah daimang tihtah Zisu cawh langhlaw vy lang a sei ruapaw hrakhei a tua. ");
INSERT INTO zypNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Canghrasala aaning taco, “Kaaning kha a reh thlang. Zailang cang ca ka, ning a tlah daimang myca hi!” tatah hmuisui teitah aa thly. Macawtaco aaning khaco ria rua pawtah a sei. ");
INSERT INTO zypNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aaning sahlo kha cabuai letah a ty thlangning tah very cawh law ka, alawngnah bia a hlai khy taitah kychy ka, aaning cawh a peh he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Taico Zisu hni khynah cawh peh cang he ka, ama cawh aa bi. Taico, ama cawh aa mehmuhnah taitah a ly thah. ");
INSERT INTO zypNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pakheh le pakheh cawh, “Langpui letei kaaning kha bia reilai katei, Capathai a ma ching pase laining takhei kaa chung letah kaa lungthing khah me kangpaw hratah cang bei maw kha?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sungkheh tah tho he ka, Jerusalem lang cawh aa kawkaw. Ma leco a hningzuitu hluikheh le aaning khatah a ungpaw sahlo he a za pahmo thlang he katei, ");
INSERT INTO zypNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Ma heh ahmangpaw a cang! Abuipaw cawh thokaw ka, Simon khatah a paly,” tatah a za rei leimeipaw he khah aa hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mataico, ma tlaw pahning taco langpui letei hming a cangpaw le very a kychy ning tei Zisu aa binah kong khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ma bia aa rei chung vytei cawh Zisu cawh aa hrong letah a daw thlang ka, aaning sahlo cawh, “Naaning khatah thlawlungnah ung ky seh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aaning sahlo cawh a pahly he ka, aa ci ngetei. Athlaw kaa hmuh tatah aa rawh. ");
INSERT INTO zypNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Zisu tah aaning sahlo cawh, “Zecawtamaw naa lung reithui ka, lung langlo tah naa ung? ");
INSERT INTO zypNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ka kih le ka phe heh mingtua hmai o, kama pui ka cang caw! Pa tong la, naa hni thlang a. Athlaw taco ka hnuipaw, naa hmuhpaw hapaw ru le ngaisaw cawh a hnui tlung be!” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ma bia a rei khy taikhei a kih le a phe cawh a hmuhsah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aa khuarawh a haa tu cawtah le aa lung a lawng tu cawtah khei zing khy thly be ca he ka, “Ma lehei epaw naa hnuipaw a ung maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aaning taco ama cawh aa pakang ciapaw ngawsaw vy kheh khah pei he ka, ");
INSERT INTO zypNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma ngaw cawh law ka, aa hmekaw leco a e. ");
INSERT INTO zypNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aa hai leco, “Naaning khatah ka ung ning takhei ma heh ka ca chingpaw he khah a cang. Moses phungbia cabu le Khazing khuavang sahlo aa cabu le Reithainah Hlaw cabu chung letei Kama ka kong ciapaw vytei cawh patling a cang tae he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mataico Khazing Capathai sahlo aa thui khy nápawtah aa thinglung ning a pavang he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aa hai leco, “Ma heh Capathai letah ciapaw cawh a cang. Khri cawh reithui sisaw ing ka, ningthung ning tah thihnah taitah a tho kaw a, ");
INSERT INTO zypNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","taico, Ama a ming tah angepachihnah le sua ngethainah kong cawh Jerusalem taitah patho he ka, mingphing vytei khatah rei a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Naaning sahlo cawh ma hming sahlo heh a hnikhuitu na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ka paw tei bia a kang ciapaw khah naaning khatah ka za taw a, canghrasala hmingtuakhynah vaicung taitah naa hmuh hlai vytei cawh Jerusalem khuapui chung lekhei ung thlang my lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aaning sahlo cawh Zisu tah piathlah khui he ka, Bethani khua kae aa phah tihtah a kih pazy ka, bonghnang a song he. ");
INSERT INTO zypNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bonghnang a song leimei ning he taco, aaning sahlo cawh seisai he ka, vaicung lang lah chy tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mataico aaning sahlo taco Ama cawh beh he ka, a lawng ngetei tah Jerusalem lang cawh aa kawkaw. ");
INSERT INTO zypNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Taico, Khazing reithai hmo khei behnah ing leco aa ung thlang tei.");
INSERT INTO zypNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ahrangthonah letah bia a ung. Ma bia cawh Khazing khatah a ung; Bia cawh Khazing a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ahrangthonah taitah Khazing khatah a ung. ");
INSERT INTO zypNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ama taco zezong vytei heh a tua, tuapaw hming vytei heh Ama tah a tua lypaw zehmai ung be. ");
INSERT INTO zypNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ama letaco hringnah a ung. Ma hringnah cawh cawngsaw vytei khainah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Akhaipaw cawh a muinah hrong letah va khai ka, muinah taco ma cawh pahnei be. ");
INSERT INTO zypNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cawngsaw pakheh Khazing tei a tawpaw ung ka, a ming cawh Johan a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Khainah kong khah hni sá pawtah le reilai rua pawtah a va chua, ming vytei tah Ama a thongtah aa zing khy nápawtah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ama cawh akhaipaw cawh cang be, akhaipaw kong khah a hnikhuitu ruapaw tah a va chuhpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Akhaipaw hmuisuipaw, ming vytei a khai sahpaw cawh a ung, khazaw lehei a vong leimei. ");
INSERT INTO zypNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ama cawh khazaw lehei a ung, khazaw heh Ama tah a tuapaw a cang naná teitah khazaw tah Ama cawh hnih be. ");
INSERT INTO zypNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ama a mehnung a cangpaw sahlo khatah a vong ka, a mehnung sahlo tah Ama cawh cyhlang bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Canghrasala Ama a cyhlangpaw vytei, Ama a ming a zingpaw vytei cawh Khazing sawtei cangnah naw a peh he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ma sahlo cawh cawngsaw phunglang tah sahpaw cang bei he. Taico cawngsaw biachawnah le pasaepaw dunah hratah sahpaw zong cang lytah Khazing taitah sahpaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bia cawh pungsaw tah a va lang ka, kaa hrong letah a cing lai. Paw tei a hnuitlakangpaw Sawcapaw hratah a rungnawnah zia kaa hmuh; ningdonah le biahmuisui tah a chih. ");
INSERT INTO zypNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johan tah a konglang reilai ka, ma hrahei tlang a y, “Ma cawngsaw heh a konglang ka reipaw, ‘ka hninglang tah a va chuh lepaw cawngsawpaw cawh kama navy tah alai vypaw a cang, zecawtamaw tatah kama hlai tah a ung ciapaw a cang,’ tahpaw khah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A ningdonah a tlangtlingnah taitah a bonghnang cawh sangkheh khy sangkheh tah kaa ting cy. ");
INSERT INTO zypNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Phungbia cawh Moses letah peh cang ka, ningdonah le biahmuisui cawh Zisu Khri thongtah a va ung. ");
INSERT INTO zypNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ahotahmai tah Khazing cawh hmuh bang bei he. Canghrasala Sawcapaw hnuitlakangpaw, Paw khatei a ungpaw taco Khazing cawh a palang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem letei a ungpaw Juda cawngsaw sahlo tah tlangbui sahlo le Levi mingphing cawngsaw sahlo cawh Johan khaco taw he ka, “Ahomaw na cang?” tatah aa haesah tih he tah, Johan tah ma hrahei a bia a phy. ");
INSERT INTO zypNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma sahlo hai letaco a paphah ly teitah, “Kama cawh Khri cang bei neh,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aaning sahlo taco, “A cang caco ahomaw na cang? Elija na cang maw?” tatah aa tah. Johan taco, “Cang bei neh,” a tah he. “Khazing khuavang kaa haw thlangpaw cang cei?” tatah aa tah vy. “Cang bei neh,” tatah a palei vy he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","A changnah letaco, “Ahomaw na cang tahpaw achaw teitah ma ching tua. Aa ma siapaw sahlo hai letah zehratamaw kaa ta he a. Na konglang heh achaw teitah ma ching, ahomaw na cang?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mataico Johan taco Khazing khuavang Isaiah a bia khah hmang ka, “Kama cawh, ‘Abuipaw cawtah langpui pading pah my lo,’ tatei raangcaa letei a y leimeipaw o cawh ka cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Taico aa tawpaw he Farasi thaikhehpaw sahlo taco Johan cawh ma hrahei bia aa hae hri, ");
INSERT INTO zypNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Zecawtamaw Khri na cang tlung lypaw le Elija maw, Khazing khuavang maw na cang tlung lypaw tah baptisma na cangsah he?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johan taco, ma hrahei a palei he, “Kama taco tui tah baptisma ka ca cangsah he. Canghrasala naa hrong letei a ung thlangpaw, naa hni lypaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ama cawh ka hninglang tah a va chua a, kama cawh a phepakong rui a thlangpah tlangpaw hmai cang bei neh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma sahlo heh Jordan tuivaw raechai lang letei a ungpaw Bethani khua, Johan tei baptisma a cangsahnah pawhe letah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ningthlamongpaw letaco Johan tah Zisu cawh ama khatah a vong lai leimeipaw khah hmuh ka, “Mingtua o, Khazing tuu teitei, khazaw suanah a photu ruapaw kheh. ");
INSERT INTO zypNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ama heh, ‘Ka hninglang tah a va chuh lepaw cawngsawpaw cawh kama navy tah a lai vypaw a cang zecawtamaw tatah ama cawh kama hlai tah a ung ciapaw a cang,’ tatei a kong ka reipaw cawngsaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kama tah ama a cang tahpaw khah hnih bei neh. Canghrasala Israel cawngsaw sahlo khatah a va paly khy nápawtah tui tah baptisma ka cangsah he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Taico Johan tah ma hrahei a tah, “Thlawpaw Pathai cawh avai taitah thury hratah a cung letah a za cawng thlangpaw khah ka hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Baptisma cangsah lai rua pawtei a pa tawpaw tah, ‘Thlawpaw cawh a cung letah a za cungpaw le, a cung letah a cawng thlangpaw na hmuh caco, ama cawh Thlawpaw Pathai tei baptisma a cang sahtu ruapaw a cang a,’ tatah pa ching lytah ung my seh la, ama cawh hnih a bei neh. ");
INSERT INTO zypNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Atoheh cawh hmuh myca neh ka, ama cawh Khazing Sawcapaw a cang ceingei tahpaw khah ka rei ngang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A monglangpaw letah Johan cawh a hningzuitu pahning khatah ung he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Zisu a khiakaly leimeipaw khah hmuh ka, a hningzuitu sahlo hai letaco, “Mingtua o, Khazing Tuu teitei khi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","A hningzuitu pahning taco ma hratei bia a reipaw khah thui he ka, Zisu khah aa zui. ");
INSERT INTO zypNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Taico a hninglang a hui ka, Zisu tah aa hai leco, “Zemaw naa hui?” tatah a tah he. Aaning taco, “Rabbi, (Cawngpahtu tahnah a cang) zeletamaw na ung?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“A vong la, naa hmuh thlang a,” tatah a palei he. Taico aaning cawh a ungnah lang a vaw he. Chahningtlaw zailang suimehlang papali hrawng tai khah Ama khaco a ung he. ");
INSERT INTO zypNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Simon Piter a unypaw Andru cawh Johan bia a reipaw a thuipaw pahning hrong letei Zisu a zuipaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru taco a hmetawcai letah a unypaw Simon cawh huilai ka, a hai letaco, “Mesiah (ma cawh Khri tahnah a cang) cawh kaa hmuh thah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Taico Simon cawh Zisu khatah a va seikhui. Zisu taco ming ka, a hai letaco, “Johan sawcapaw Simon, nama cawh Sifas (ma cawh Piter tahnah a cang) aa ca tah myca a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A ningthlamongpaw letaco Zisu cawh Galili raang lang sei pawtah a pachia. Taico Filip cawh hmuh ka, “Va pa zui,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip cawh Andru le Piter sahlo khatei khuakheh letah a ung hruipaw a cang. Ma cawh Bethsaida khua a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip tah Nathaniel cawh hmuh ka, a hai letah, “Moses tei phungbia letei a konglang a ciapaw, Khazing khuavang sahlo zong tei a kong aa reipaw, Nazaret Zisu, Josef a sawcapaw cawh kaa hmuh myca,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathaniel taco, “Nazaret taitah hmingchaw a piathai thlang maw?” a tah. Filip taco, “A vong la, mingtua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Zisu tah Nathaniel cawh Ama lang a va pange lai leimeipaw khah hmuh ka, “Mingtua o, Israel cawngsaw hmuisuipaw, Ama letah dinglynah a ung lypaw hi,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathaniel taco, “Zekhatamaw na pa hni?” a tah. Zisu tah a hai letah, “Filip tei a ca y hlai letei thuiku kung rai letah na ung thlangning takhei, ka ca hmuh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathaniel taco, “Rabbi, nama cawh Khazing Sawcapaw, Israel Siangpahrang na cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zisu tah, “Thuiku kung a rai letah ka ca hmuh, ka tah cawtah na zingpaw cang ka, ma navy hei a rungnaw vypaw a hlupui na hmuh tae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","“Biahmuisui ka ca ching, avai ingkaw a hong a ka, Khazing a vaiming sahlo cawh Cawngsaw Sawcapaw cung letah aa cungchuh, aa kechypaw khah na hmuh tae a,” tatah a tah vy hui. ");
INSERT INTO zypNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A ningthungnah letah Galili raang, Kana khua letah nupui chuinah a ung. Zisu a no cawh ma leco ung ka, ");
INSERT INTO zypNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Zisu le a hningzuitu sahlo zong cawh ma nupui chuinah leco aa hrui hrah he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Misurhang a chang tihtah, a no tah Zisu hai letaco, “Misurhang a chang thah,” tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zisu tah a hai letah, “Dopaw canu, nama tah zemaw na pa ching rua a ung? Ka cai phah balang be hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Taico a no taco cungtlahtu sahlo hai letaco, “A ca chingpaw longmang hratah tua my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aa kaepang tei letaco alung beirai sangruh, Juda cawngsaw sahlo tei a sipathainah aa tahpaw cai letei aa hmang teipaw cawh ung ka, ma alung beirai sangkheh cawh tui kalan songthung hrawng a tlungpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Zisu tah cungtlahtu sahlo hai letaco, “Beirai sahlo lekhei tui chi sah my lo,” a tah he. Taico alung beirai cawh a tlang tai long tah tui aa chisah he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Taico Zisu tah aa hai letah, “Atoheh alung beirai letei tui cawh thai la, cung a tlahpaw sahlo hruitupaw khah va pei o,” tatah a tah. Taico thai he ka, aa va peh. ");
INSERT INTO zypNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Cungtlah hruitupaw taco misurhang tah a cang thah ciapaw tui cawh a pateh. Canghrasala zehratamaw ma hraco a cang tahpaw khah hnih be, tui a thaipaw he cungtlahtu long takhei aa hni. Taico nupui a chuipaw khah y ka, a hai letaco, ");
INSERT INTO zypNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Cawngsaw maikaw tah misurhang a hring khah va tle taw he ka, khuachai vytei tah dutaw tah aa ding khy taitah a hning tah a tesi aa va tle tei. Nama duitei cawh athoning tei navy tah achaw vypaw khah ato tingtai na pakhei thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galili raang, Kana khua letei Zisu tah a tuapaw, ma ningang chuipaw heh a tuapaw letah a hmetaw caipaw a cang. A rungnawnah cawh palang lai ka, a hningzuitu sahlo taco Ama letah aa zingnah khah aa pahnia. ");
INSERT INTO zypNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma khy taico a no le a uny sahlo le a hningzuitu sahlo khaco Kapernaum khua lang cawh cungthlah he ka, ma leco ning cuitei a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Taico Juda cawngsaw aa Khungsai Panawnah cai cawh phah daimang ka, Zisu cawh Jerusalem lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jerusalem letei behnah ingdung chung letei a ungpaw sahlo, sahring a zuapaw le tuu le thury sahlo a zualaipaw le cabuai letei tangka a thlaipaw sahlo khah a hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mataico khyhrui cawh thingrui tah tua ka, behnah ingdung chung letei a ungpaw tuu le sahring vytei cawh zeipatlaw he ka, a papia thlu he. Tangka a thlaipaw sahlo aa tangkasaw vytei khah thehly pah thlu he ka, aa cabuai sahlo vytei khah a palehly thlu he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Thury aa zualaipaw sahlo aa hai letaco, “Piathlah thlu tua o, zekhatamaw ka Paw a ing cawh cho donah tlang tah naa tua ngang zia?” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A hningzuitu sahlo cawh, “Na ing caw tei ka chahnai ngenah taco a pa e seh thlu myca,” tatei aa ciapaw bia khah a thui he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Taico Juda cawngsaw sahlo taco, “Ma hming vytei tua rua pawtah hei naw na hnui tahnah tah zehapaw ningang chuipaw paching pakhanah maw na ma pae a?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Zisu taco aa hai letah, “Ma behnah ing heh chehthlah la, ningthung chung tah ka padaw kaw thlu cehceh a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Juda cawngsaw sahlo taco, “Ma behnah ing heh kung songli le kung ruh sahpaw tah cang ka, ma cawh ningthung chung tah na paling khy maw?” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Canghrasala a rei dunah silang cawh Ama a pungsaw kong khah a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Thihnah taitah a tho kaw khy taitah ma hratei bia a reipaw khah a hningzuitu sahlo tah a thui kaw he. Capathai letei a ungpaw le Zisu hmokaw bia sahlo khah aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalem letei Khungsai Panawnah chung letaco, Zisu tah ningang chuipaw paching pakhanah a hlupui a tuapaw sahlo khah ming hlupui tah hmuh he ka, a ming cawh aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Canghrasala Zisu cawh aaning sahlo letaco a ngengang be, zecawtamaw tatah ming vytei khah a hmuh pahleh thlu he. ");
INSERT INTO zypNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Cawngsaw kong cawngsaw tah chingpase khah Zisu cawh hia be, zecawtamaw tatah Ama tah cawngsaw chung letei a ungpaw khah a hni thlu. ");
INSERT INTO zypNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farasi hrong letah pakheh, a ming Nikodema aa tahpaw cawh ung ka, ama cawh Juda cawngsaw sahlo a uhtu khongsil macang hrong leteipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Zaicing tah Zisu khaco a vong ka, a hai leco, “Rabbi, nama cawh Khazing taitei a va chuhpaw cawngpahtu na cang tahpaw kaa hni. Khazing tah a ungkhui ly caco he na tuapaw hming hapaw ningang chuipaw paching pakhanah heh ahotahmai tah tua khy bei he,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Zisu tah ma hrahei a palei, “Biahmuisui ka ca ching, ahohmai aa pitha ly caco, Khazing painah raang hmuh khy bei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodema taco, “Cawngsaw cawh a macang khy taitah zekhatamaw a pitha thai khaw a? A no a chi chunglang a nae kaw tah a pi kaw thai khawh tlung be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zisu tah ma hrahei a chai, “Biahmuisui ka ca ching, ahohmai tui le Thlawpaw tah a pi ly caco, Khazing painah raang a nae bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ngaisaw taco ngaisaw a sah kaw, Thlawpaw taco thlawpaw a sah hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Na pitha ruapaw a cang,’ tatei ka ca tahpaw heh na ningang kheh seh. ");
INSERT INTO zypNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Thli cawh a dudú tah a hrang, a pyraw na thui. Zelang tamaw a va chua, zelang maw a sei a tahpaw na hni tlung be. Thlawpaw tah a pipaw cawh ma hraco aa cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Ma hapaw cawh zekhatamaw a cang thai a?” tatah Nikodema taco a hae hri kaw. ");
INSERT INTO zypNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zisu taco, “Israel cawngsaw sahlo cawngpahtu a cangpaw tah ma hapaw hming sahlo cawh hnih thai bei ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Biahmuisui ka ca ching, hnih peh ka, kaa rei, kaa hmuhpaw kong khah kaa rei lai, canghrasala kaa reipaw khah naaning tah zing tlung bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aluicung hming kong ka reipaw hmai naa zing tlung be, vaicung lang kong sahlo cawh ca ching my he neh seh la, zekhatamaw naa zing khy thai a? ");
INSERT INTO zypNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Cawngsaw Sawcapaw, vaicung taitei a vongpaw cy tah ly co ahohmai tah vaicung lang aa ke bang tlung be. ");
INSERT INTO zypNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses tei raangcaa letah daa pari a caliapaw hratah Cawngsaw Sawcapaw heh calia a cang hrá a. ");
INSERT INTO zypNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Macawtaco Ama a zingpaw maikaw cawh chaizaw tah a hring he a. ");
INSERT INTO zypNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Khazing tah khazaw heh a do ngeteinah cawtah a Sawcapaw hnuitlakangpaw khah a peh. Ahohmai a zingpaw maikaw cawh lyde lytah chaizaw hringnah aa hnui a. ");
INSERT INTO zypNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Khazaw heh thaily cang sá pawtah Khazing tah a Sawcapaw cawh a tawpaw cang be, Ama a thongtah pachah aa cang khy nápawtah a tawpaw khah a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ama a zingpaw maikaw cawh thaily cangsah cang a bei he. Canghrasala a zing lypaw maikaw cawh ato lalei hei thaily a cang thah he, Khazing Sawcapaw hnuitlakangpaw ming aa zing lynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma heh thaily cangnah cawh a cang. Akhaipaw cawh khazaw lehei a vong ka, canghrasala cawngsaw tah a khaipaw navy tah a muipaw aa tlechai vy, zecawtamaw tatah aa hming tuapaw sahlo khah a chahlynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ahohmai hmingchaw ly a tuapaw maikaw taco akhaipaw a hua he, taico akhaipaw lang zong a vong du bei he, hmingchaw ly aa tuapaw khah akhaipaw letah a langpang le tahpaw aa cinah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Canghrasala biahmuisui letei a hringpaw taco akhaipaw lang cawh a vong he. Aa tuapaw hming vytei khah Khazing thongtah aa tuapaw a cang tahpaw khah a lang pase khy nápawtah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma khy taico Zisu cawh a hningzuitu sahlo khatah Judia raang khuatei lang khah sei he ka, ma letaco zemaw cai hrawng ung ka, baptisma zong a cangsah he. ");
INSERT INTO zypNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mataico, Johan zong tah Salim khua kae Ainon aa tahpaw letaco baptisma cangsah he ka, cawngsaw hlupui tah ama khatah baptisma cang rua pawtah aa pange. Zecawtamaw tatah ma leco tui ahlunah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ma heh Johan cawh thong letah a tlah hlai tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Johan hning a zuipaw sahlo thaikhehpaw le Juda cawngsaw pakheh cawh a sipathainah phung le lang kong letah bia a ei he. ");
INSERT INTO zypNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Johan khaco a vong he ka, a hai leco, “Cawngpahtu, Jordan tuivaw rae lang letei nama khatah a ungpaw, a konglang na reilaipaw takhei baptisma cangsah he ka, cawngsaw hlupui tah aa pange,” tatah aa ching. ");
INSERT INTO zypNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johan taco, ma hrahei a palei he, “Vaicung taitah pehpaw suipaw khah cawngsaw taco a hnui khypaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kama cawh, ‘Khri cang bei neh, zua a ky ruapaw tei a hmelang a seilai ruapaw tah tawpaw ka cang,’ ka tahpaw khah naaning sahlo ceingei tah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Myno cawh my a hnuitupaw cawtah a cang. My a hnuitupaw a vesaw a cangpaw taco ama cawh heh thlang ka, a naw thlia paria thlang. My hnuitu o cawh a thui tih letaco a thaw a chah ngetei. Ma a lawngnah cawh kama ka cawtah cang ka, atoheh a va tlung thah hi. ");
INSERT INTO zypNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ama cawh a laisui ruapaw a cang, kama cawh a zochuh ruapaw ka cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Cung lang taitah a va chuhpaw cawh ming vytei cung letei a ungpaw a cang, aluicung taitei a chuhpaw cawh alui cawngsaw cang ka, aluicung kong khah a rei. Avai taitei a va chuhpaw cawh ming vytei cung letei a ungpaw cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A hmuhpaw le a thuipaw khah a thuisah he, canghrasala a thui sahpaw he bia cawh ahotahmai nge bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A bia a ngepaw taco Khazing cawh a ding hmuisui tahpaw khah a pacysah. ");
INSERT INTO zypNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Khazing tawpaw a cangpaw taco Khazing bia khah a rei. Zecawtamaw tatah Khazing taco ama cawh a Thlawpaw khah ri tai ung lytah a peh. ");
INSERT INTO zypNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Paw tah Sawcapaw khah a do, zezong vytei khah a kih letah a chia. ");
INSERT INTO zypNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sawcapaw a zingpaw maikaw taco chaizaw hringnah aa hnui. Sawcapaw a pawng lypaw maikaw taco hringnah hnui bei he, Khazing thingaenah khah aa cung letah a ung hri a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farasi sahlo taco Zisu tah Johan navy tah hningzuitu hlu vy a hnuipaw le ming hlu vy baptisma a cangsah paw he khah aa thui. ");
INSERT INTO zypNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Zisu ceingei tah baptisma cawh a cangsah bei he, a hningzuitu sahlo tah aa cangsah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ma kong cawh Abuipaw tah thui ka, Judia raang cawh piasai ka, Galili raang lang khah a sei kaw. ");
INSERT INTO zypNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria raang cahrong tah sei pawtah cang ka, ");
INSERT INTO zypNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria raang khua, Saikar aa tahpaw cawh va phah ka, ma cawh Jakob tei a sawcapaw Josef a pehpaw hminghmaw kae leteipaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma leco Jakob tei tuikho a copaw cawh a ung. Zisu cawh khuatlongnah langpui letei a va sei lainah letaco a thaw bang ka, ma tuikho kae letaco a ty ka, a hia. Ma cawh ningching hrawng letah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Taico Samaria cawngsawno pakheh cawh ma tuikho letei tui cawh thai rua pawtah va chuh ka, Zisu tah a hai leco, “Tui ding ruapaw pa pei khy ceh maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A hningzuitu sahlo khah khuachung lang e ruapaw cawh tah a sei thah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria cawngsawno taco, “Nama cawh Juda mingphing cang ceh ka, kama cawh Samaria mingphing cang neh ka, zekhatah zia tamaw tui ding ruapaw na pa hae thlang?” a tah. Juda mingphing sahlo cawh Samaria mingphing khatah a pahlawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Zisu taco a hai letah, “Khazing lahsong le nama khatei tui ding ruapaw a ca haepaw heh cawh hnih tua la, nama tah ama khatah tui ding ruapaw na hae hri ruapaw a cang; taico ama tah hringnah tui cawh a ca pae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Canuno taco, “Ka pu, ma tuikho heh a thuh ngeteipaw tah cang ka, tuithai nápaw zehmai na hnui tlung be. Zekhatamaw hringnah tui cawh na hmuh khy thai zia a? ");
INSERT INTO zypNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kaa mapaw Jakob navy tah na rungnaw vy maw? Ama taco ma tuikho heh ama le a sawtei leh vytei le, aa sahring zuapaw vytei, ding ruapaw tah a ma pehpaw a cang hi,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Zisu tah ma hrahei a chai, “Ma tui a dingpaw maikaw heh cawh aa tui a hrae kaw a. ");
INSERT INTO zypNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Canghrasala kama tei ka pehpaw tui a dingpaw maikaw he cawh aa tui hrae khaw be. Ka pehpaw he tui cawh aa chung taitah tuihnaw hratah a laichua a, chaizaw hringnah tai a lai a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Canuno taco, “Ka pu, ma tui cawh pa pei tua, ka tui a hrae khawh ly nápawtah le ma tuikho lehei tui ka va thai khawh ly nápawtah,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Canuno cawh, “Va sei la, na pasae va y la, a vong kaw my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Canuno taco, “Pasae ka hnui tlung be” tatah a palei. Zisu tah a hai letah, “Pasae hnui bei neh, na tahpaw heh biahmuisui a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hmuisui teico, pasae papangaw na hnui thah, atotei na ung hruipaw cawngsaw zong heh na pasae hmuisui cawh cang hlui be, na reipaw heh biadih a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Canuno taco, “Ka pu, nama heh Khazing khuavang na cang tahpaw ka hni, ");
INSERT INTO zypNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","aa ma pathlahtu sahlo tah ma tlaang lehei Khazing aa beh tei. Canghrasala naaning Juda mingphing sahlo taco Jerusalem letah Khazing cawh beh rua a cang tatah naa tah,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Taico Zisu tah a hai letah, “Canuno, ka bia heh zing tua, a cai le ning a va tlung leimei, ma tlaang lehei a cang ly leh Jerusalem letah cang lytah Paw Khazing aa behnah cai khah a tlung a. ");
INSERT INTO zypNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Naaning Samaria mingphing taco naa hni lypaw khah naa beh tei, pachahnah cawh Juda mingphing taitah a va chuhpaw a cangnah cawtah kaaning taco kaa behpaw khah kaa hni. ");
INSERT INTO zypNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Paw cawh a beh hmuisuipaw sahlo tah Thlawpaw le biahmuisui tei aa beh nápaw cai cawh a va chuh myca, atoheh a va phah thah. Ma hapaw cawngsaw cawh Paw tah a huipaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Khazing cawh Thlawpaw cang ka ama a behpaw sahlo taco thlawpaw le biahmuisui tah aa beh hrahring ruapaw a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Canuno taco a hai letah, “Mesiah (ma cawh, ‘Khri,’ tahnah a cang) a va chuh tae a tahpaw ka hni. Ama cawh a va chua tihtah hming silang vytei khah a ma chingpase tae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Zisu tah a hai letaco, “Nama kha bia a rei leimeipaw heh Ama cawh ka cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A hningzuitu sahlo cawh aa va tlung kaw tihtah Zisu cawh canuno khatei bia aa reihrui leimeipaw khah hmuh he ka, aa ning a ang thlang. Canghrasala ahotahmai tah, “Zemaw ma canuno khakhei na hiapaw a ung? Ze kong maw naa reihrui leimei?” tatah hae hri bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Taico canuno cawh a tuibei khah seisai ka, khuachung lang khah va sei ka, khuasaw sahlo hai letaco, ");
INSERT INTO zypNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“A vong la, va ming tua o, ka tuasenah maikaw a pa ching thlu khypaw cawngsaw pakheh a ung, Khri a cang khy mai!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Khuachung letei cawngsaw sahlo cawh ka piathlah he ka, Zisu ungnah lang aa va pange. ");
INSERT INTO zypNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma chung taco a hningzuitu sahlo tah, “Cawngpahtu, sangkheh kheh e taw,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Canghrasala Zisu taco aa hai letah, “A kong naa hni lypaw e ruapaw batui ka hnui,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mataico a hningzuitu sahlo cawh aaning le aaning khah, “Batui a va peipaw ung ta he maw!” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zisu tah aa hai letah, “Ka batui cawh a pa tawtu a dunah tua le a rai patlung patlia khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‘Thlah pali khy taico saze hre a cang a,’ tah tei bei he ceh maw? Ka ca ching he hi, naa meh duichy la, saze ly khah mingtua o! Hre rua pawtah a zaw thlu myca he khi. ");
INSERT INTO zypNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Saze a hrepaw tah a hrenah mai cawh a hmuh tei. Chaizaw hringnah caw pawtah aa hre myca. Ma pawsui co, saze a lingpaw le a hrepaw cawh a lawng hrui khy he a. ");
INSERT INTO zypNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma tih taco, ‘Pakhehpaw tah ling ka, pakhehpaw tah a hre,’ tahpaw cawh ahmang a. ");
INSERT INTO zypNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naa ling lypaw saze hre rua pawtah ka ca taw he hi. Ming hringpaw sahlo tah raisah cawh hre he ka, aa raihrenah a thuipa cawh naaning tah naa hria,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Saikar khuachung letei a ungpaw Samaria cawngsaw a hlupui tah canuno tei, “Ka hming tua ciapaw vytei a pa ching khy thlu,” a tahpaw rawng takhei Ama cawh aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Macawtaco, Samaria cawngsaw sahlo cawh Ama khaco a vong he ka, kaaning kha caang cong thlang tatah thly he ka, ninghning aaning khatah a caang. ");
INSERT INTO zypNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Taico, a cawngpahnah bia thong khei, mehlupui tah Ama cawh aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Canuno hai letaco, “Nama tei na reinah thongtah kaa zingpaw cang lytah kaaning ceingei tah thui peh ka, ma paw cawngsaw heh khazaw Pachahtu hmuisui a cang tahpaw kaa hninah cawtah a cang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ninghning khy tah ma khua taico piathlah ka, Galili raang lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Zisu tah, “Khazing khuavang cawh ama a khua le raang letaco pasung panawnah a tong be,” tahpaw bia khah a rei. ");
INSERT INTO zypNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Canghrasala Galili raang cawh a va phah tihtah Galili cawngsaw sahlo taco Zisu cawh aa cyhlang. Khungsai Panawnah ning tei Jerusalem khua letah a tuapaw vytei khah aa hmuh, zecawtamaw tatah ma lekhei a ung thlang hrah he. ");
INSERT INTO zypNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zisu cawh tui misurhang tei a cangsahnah hminghmaw, Galili raang letei Kana khua lang khah a va sei kaw. Ma leco abui pakheh a cangpaw a sawcapaw, Kapernaum khua letah a ungpaw cawh dang be. ");
INSERT INTO zypNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma cawngsawpaw taco Zisu cawh Judia raang taitah Galili raang a va phah tahpaw khah a thui tihtah ama khaco a vaw ka, a thi daimangpaw a sawcapaw cawh dang sá pawtah a vong theh ky law tatah a va naw. ");
INSERT INTO zypNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Zisu tah ma cawngsawpaw hai letah, “Naaning sahlo taco ningang chuipaw paching pakhanah le khuarawha a chuipaw naa hmuh tah lypaw co zing by bei ceh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma abuipaw taco, “Abuipaw, ka sawcapaw a thih hlai lehei a vong theh ky,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Zisu taco, “Va sei thlang, na sawcapaw cawh a hring a,” tatah a palei. Ma cawngsaw taco Zisu tei a hai letah bia a reipaw cawh zing ka, a sei hly. ");
INSERT INTO zypNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lang letah a seilai leimeining taco, a sae sahlo tah va dai he ka, na sawcapaw a dang thah tahpaw aa thuisah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A sawcapaw cawh zening cai hrawng taikhei maw a chah vy longmang tahpaw khah a hae tih he tah a hai leco, “Ziachaning, zailang suimehlang pakheh hrong taikhei a thlasih taco a thlaw,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mataico a paw taco, ma cawh Zisu tei, “Na sawcapaw cawh a hring a,” tatei a chingpaw cai a cang hrahring takhah a hni. Macawtaco ama le a ingchungkho vytei tah aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma heh Judia raang taitah Galili raang a va phah khy taitei Zisu tah a tuapaw a uihningnah ningang chuipaw paching pakhanah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cai a cawngpe khy tai khei Juda cawngsaw sahlo Panawnah letah a hlo hra pawtah Zisu cawh Jerusalem lang khah a kechy. ");
INSERT INTO zypNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem khuapui letei Tuu Hawkaw aa tahpaw kae letaco, tuiching, Aramaik rei tah Bethesda aa tahpaw ung ka, dungkalung sangpangaw a hnui. ");
INSERT INTO zypNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma letaco mehdang ly hlupui, mehco le a songbepaw, a kih le phe a ngawpaw sahlo vytei taco, tui a calawh lepaw khah aa haw thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ma tuiching cawh vaiming sahlo tah a calawhsah tei he ka, ma tui a calawh ning tei a chunglang a zythlah tawpaw he cawh zehapaw a sawnah a cangpaw hmai tah dangnah aa hmuh tei. ");
INSERT INTO zypNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma leco cawngsaw pakheh a dang lypaw kung songthung leh kung reh a sah ciapaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zisu tah ma cawngsaw cawh hmuh ka, ma leco khua sypui dang lytah a ung myca tahpaw khah hnih ka, a hai letah “Dang na du maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mehdang ly taco, “Abuipaw, ma tui heh a calawh cangkawleh tui chunglang a pa nong ruapaw ahohmai ung bei he. A nawng pawtah ka seining maikaw tah cawngsaw ahringpaw tah aa pa chokhai thah leimei thlang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Zisu taco a hai letah, “Tho la, na iphaw a lah la, sei,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sung sungkheh tah ma cawngsaw cawh dang ka, a iphaw cawh law ka, a sei. Ma ning cawh Sabat ning a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda cawngsaw sahlo taco, “Atoning heh Sabat ning cang ka, na iphaw law khy bei ceh, a phung cang be,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ama taco aa hai letah, “A pa dangsah tupaw tah, ‘Na iphaw law la, sei law,’ a pa tah,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aaning sahlo taco, “Na iphaw law la, sei a ca tahpaw cawh ahomaw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dangsah a cangpaw cawngsawpaw taco a dangsah tupaw khah hnih pase be, zecawtamaw tatah Zisu cawh ma leteipaw zawpui hrong taico a seihly. ");
INSERT INTO zypNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A hning khy tah ma cawngsawpaw khah Zisu tah behnah ing letah hmuh ka, “Na dang myca hi, atohei co suanah va tua khawh kheh, na tua vy caco a sah vy tah maw na cung letah tlung pang le,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Cawngsawpaw cawh seihly ka, a dangsahtu khah Zisu a cang tahpaw cawh Juda cawngsaw sahlo khah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Macawtaco Zisu tah ma hming sahlo cawh Sabat ning tah a tuanah cawtah Juda cawngsaw sahlo taco Ama cawh ruhanah aa peh. ");
INSERT INTO zypNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Zisu tah aa hai letah, “Ka Paw tah atoning tai a rai hre ka, kama zong ka hre hrápaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ma rawng tahei Juda cawngsaw sahlo taco thaw rua pawtah khei a zawng tima he; Sabat ning a ronah caw tahei long cang lytah Khazing khah Ama a Paw tatah a y cawtah le Khazing kha a khing pawtah a tuanah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Taico Zisu tah aa hai letah, “Biahmuisui ka ca ching he, Sawcapaw tahei ama teitah zehmai tua khy be, Paw tei a tuapaw a hmuhpaw longlong khah a tua khy, zecawtamaw tatah Paw tei a tuapaw maikaw khah Sawcapaw zong tah a tua hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Zecawtamaw tatah Paw taco Sawcapaw khah do ka, a tuapaw vytei khah a hmuhsah. Naa ningangnah rua pawtah ma sahlo navy hei a rungnaw vypaw hming sahlo a hmuh sá a. ");
INSERT INTO zypNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Zecawtamaw tatah Paw tah mehthi patho he ka, hringnah a pehpaw he hratah Sawcapaw zong tah peh a dupaw khah hringnah cawh a peh hrah he. ");
INSERT INTO zypNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma hlui co, Paw tah ahohmai biacepah bei he, canghrasala biacenah vytei khah Sawcapaw letah a peh thah, ");
INSERT INTO zypNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ma cawh Paw aa cizawpaw hratah Sawcapaw aa cizaw khy nápaw cawtah a cang. Sawcapaw a cizaw lypaw taco ama a za tawpaw Paw khah cizaw hrah be. ");
INSERT INTO zypNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Biahmuisui ka ca ching he, Ka bia thui katei, a pa tawtupaw a zingpaw cawngsaw cawh chaizaw hringnah hnui ka, sua phosah cang a be. Ama cawh thihnah taitah hringnah lang khah a palang thah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Biahmuisui ka ca ching he, mehthi tah Khazing Sawcapaw a o thui he ka, a thuipaw sahlo taco hringnah aa hmuh nápaw cai cawh va chuh leimei ka, atoheh a va phah myca. ");
INSERT INTO zypNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Zecawtamaw tatah Paw cawh Ama teitah hringnah a hnuipaw hratah, a Sawcapaw khah Ama teitah hringnah hnuinah naw a peh. ");
INSERT INTO zypNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Taico Ama cawh Cawngsaw Sawcapaw a cangnah cawtah biacenah nawhnuinah zong khah a peh. ");
INSERT INTO zypNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma heh naa ningang kheh seh, zecawtamaw tatah athlai letei a ungpaw vytei tah a o thui a he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aa tho nápaw cai cawh a va chuh leimei myca. Chahnah a tuapaw sahlo cawh hringnah letah tho a he ka, chianah a tuapaw sahlo cawh thaily cang rua pawtah a tho he a. ");
INSERT INTO zypNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kama cawh ka naw tah zehmai tua khy bei neh. Ka thuipaw hratah biace neh ka, ka biacepaw cawh a ding, zecawtamaw tatah kama ka dunah zui lytah a pa tawtupaw a dunah ka zuinah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kama ka kong kama tah ka reilai caco, ka reipaw cawh zingchui be. ");
INSERT INTO zypNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kama ka kong a reipaw pakheh ung ka, ama tei ka kong a reipaw cawh zing a chui tah khah ka hni. ");
INSERT INTO zypNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Naaning tah Johan khakhei cawngsaw taw he ceh ka, ama taco biahmuisui khah a rei. ");
INSERT INTO zypNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mehnung tei ka kong aa reipaw cawh zetah sah bei neh. Canghrasala ma bia ka reipaw heh pachah naa cang khy nápawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johan cawh a khai ngeteipaw me-ing cang ka, naaning taco ama a khainah cawh caikheh tei anawngnah takhei naa du. ");
INSERT INTO zypNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Johan a reipaw navy tah a rungnaw vypaw khah kama cawh ka reipaw a cang. Zecawtamaw tatah atotei rai heh paling rua pawtah hei Paw tah pa pei ka, taico ma ka hre leimeipaw rai tahei kama cawh Paw tah a pa taw tahpaw khah a langsah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taico a pa tawtupaw Paw ceingei tah ka cangnah konglang cawh a langsah. Naaning taco a o thui bang be ca he ceh ka, a hmui zong hmuh bang bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A bia zong naaning letah a cingkai bei he ceh, zecawtamaw tatah a tawpaw khah naa zing lynah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Khazing Capathai khah khiahle he ceh ka naa rei, zecawtamaw tatah ma sahlo taikhei chaizaw hringnah kaa hmuh khy a tah naa rawh cawtah a cang. Ma Capathai sahlo heh kama ka kong a langsahpaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Canghrasala hringnah hnui rua pawtah kama kha a vong cawh du hlui bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Cawngsaw tei pachaw palaw cawh du bei neh, ");
INSERT INTO zypNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","canghrasala ka ca hni thlang he. Naa thinglung letah Khazing donah hnui bei he ceh tah cawh ka hni. ");
INSERT INTO zypNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kama cawh ka Paw a ming tah a vong neh ka, naaning tah pa cyhlang bei he ceh, canghrasala pakheh kheh cawh Ama a ming tah a vong tua my seh la, ama cawh naa cyhlang thlang a. ");
INSERT INTO zypNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pakheh le pakheh na reithainah pawhe ceh cawh a cyhlang he ceh ka, Khazing taitei a va chuhpaw reithainah zetah a rei lypaw naaning sahlo tahei zekhatamaw naa zing khy a? ");
INSERT INTO zypNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Canghrasala Paw hmekaw letah sua a ma phosá a tatah parawh khe o, naaning sua a ca pho sápaw he cawh na paichai pawhe ceh Moses khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses naa zing caco, kama naa pa zing rua a cang, zecawtamaw tatah ama taco kama ka kong a ciapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Canghrasala a ciapaw naa zing lynah cawtah khei ka reipaw cawh zekhatamaw naa zing khy thai a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma khy taico, Zisu cawh Galili rili (ma heh Tiberia rili a cang) ngaekang lang khah a vaw ka, ");
INSERT INTO zypNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","cawngsaw rungpui takhei Ama cawh aa zui, zecawtamaw tatah a sahpaw sahlo cung letei a tuapaw ningang chuipaw paching pakhanah khah aa hmuh cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mataico Zisu cawh tlanglang ke ka, a hningzuitu sahlo khakhei a ty. ");
INSERT INTO zypNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juda cawngsaw aa Khungsai Panawnah cawh a ne myca. ");
INSERT INTO zypNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Zisu cawh a hui ka, Ama lang cawngsaw rungpui a vongpaw he khah a hmuh tihtah Filip hai leco, “Ma cawngsaw sahlo aa e rua tahei zeletamaw very kaa va caw a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ama hnehsah nápawtah ma bia heh a haepaw a cang, zecawtamaw tatah zemaw ka tua a tahpaw khah a lung letah a hni pacia thah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip taco a hai letah, “Pakheh tah sangkheh cy ting rua pawtah a zawpaw very cawh thlah reh nihlo tah a cawh khy tlung be!” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ahringpaw a hningzuitu, Simon Piter a unypaw Andru taco, ");
INSERT INTO zypNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ma lehei hrangsang very tlangpangaw le ngadih punghning a hnuipaw nyhehpaw a ung, canghrasala ma reiropaw cawngsaw hrong lehei zetlang maw a cang a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Zisu taco, “Cawngsaw khah a tysah tua o,” tatah a tah he. Ma hminghmaw cawh araang hrong tah cang ka, capaw puitling 5000 hrong a cangpaw he cawh a ty he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mataico Zisu tah very tlang sahlo cawh law ka, Khazing khatah lawngbia a hlai ka, a ty thlangpaw cawngsaw sahlo cawh aa dunah zé khei rai law a tah he. Ngaw zong cawh ma hraco a tua. ");
INSERT INTO zypNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aa rivaw pawtah aa e thlu khy taitah a hningzuitu sahlo cawh, “Ebangpaw very sahlo pahmo la, thlaw thlang khe lo,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma sahlo tei aa ebangpaw very tlang pangaw taitei a hluipaw sahlo cawh pakhong he ka, baihraw hluihning a chih. ");
INSERT INTO zypNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cawngsaw sahlo taco Zisu tei a tuapaw ningang chuipaw paching pakhanah khah aa hmuh tihtah, “Ma paw heh khazaw letah a vongpaw Khazing khuavang a cang hrahring,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ma sahlo tahei a vong he ka, hranghrang tah siangpahrang tah aa pa tua a tahpaw khah a hninah cawtah tlanglang khah aparuh teitah a seihly kaw. ");
INSERT INTO zypNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Zailang a va phah tihtah a hningzuitu sahlo cawh Galili tuiping lang khah cung thlah he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tuilawng chunglang cawh a nae he ka, Kapernaum khua lang sei rua pawtah khei tuiping cawh aa cakah. Khua cawh mui ca ka, Zisu cawh aaning sahlo khah a hlawng balang bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Thli a rupaw pui a hrang ka, tuileh cawh a cahrah ngetei. ");
INSERT INTO zypNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Khangthung a cang ly leh khangpali hrawng tuilawng cawh aa zei taitah tui cung letah Zisu va sei katei, tuilawng a va pangepaw khah hmuh he ka, aa ci a tho. ");
INSERT INTO zypNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Canghrasala Zisu taco aa hai letah, “Kama ka cang hi, ci khe o,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mataico tuilawng chunglang cawh a naesah he ka, ma cangkawleh cawh tuilawng cawh aa tingnahpaw ngaekang khah a va phah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ningthlamongpaw cawh a hningzuitu sahlo aa ungnahpaw dihdong tuiping raechai ngaekang letei a ungpaw zawpui sahlo tah ma lekhei a hningzuitu sahlo aa kepaw tuilawng sangkheh suitei ung ka, Zisu cawh a hningzuitu sahlo khakhei tuilawng chunglang a nae be, aaning teitah aa seihly tahpaw khah aa hni. ");
INSERT INTO zypNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mataico, Tiberia khuapui taitah a va chuhpaw tuilawng sahlo cawh cawngsaw rungpui tah Abuipaw tei lawngbia a hlai khy taitah very aa enah hminghmaw lekhei aa chung he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma hminghmaw leco Zisu le a hningzuitu sahlo ung bei he tahpaw khah zawpuipaw tah aa hni tihtah tuilawng cawh ke he ka, Zisu hui rua pawtah khei Kapernaum khua lang cawh aa sei. ");
INSERT INTO zypNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tuiping raechai lang lekhei aa va hmuh tihtah a hai leco, “Cawngpahtu, zening tamaw ma lang heh na va sei?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zisu taco, “Biahmuisui ka ca ching he, Kama naa pa hui lai leimeipaw heh ningang chuipaw paching pakhanah naa hmuh cawtah cang lytah naa ri vaw ky tah very tlang sahlo khah naa e rawng tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A lyde khypaw ding le e caw suipaw tah rai hre khe o, chaizaw hringnah khatei a peitlepaw batui, Cawngsaw Sawcapaw tei a ca pehpaw he cawtah khei naa hre hri be. Ama cawh Paw Khazing tah a nawtlahnah ca a khai ciapaw a cang!” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mataico Zisu cawh, “Khazing a dupaw rai kaa hre khy nápawtah zemaw kaa tua ruapaw a cang?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Zisu taco, “Khazing rai cawh ma heh a cang hi, Ama tei a za tawpaw zing khah a cang,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Macawtaco Zisu cawh, “Hmuh a tei kaa ca zing nápawtah ze ningang chuipaw paching pakhanah maw na ma pae a? Zemaw na tua a? ");
INSERT INTO zypNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘Aaning sahlo aa e ruapaw takhei very khah avai taitah a thlah he,’ tatah ciapaw hratah kaa mapaw sahlo taco raangcaa lekhei manna very khah aa e tatah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Zisu taco aa hai letah, “Biahmuisui ka ca ching he, vaicung taitei very a thlah pahpaw he khah Moses cang be, vaicung taitah very hmuisuipaw a ca thlah pawhe cawh ka Paw a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Zecawtamaw tatah Khazing very cawh vaicung taitah za cung katei, khazaw caw tei hringnah a peipaw cawngsawpaw heh a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aaning sahlo taco, “Abuipaw, ma very cawh atohei co ma pei tei my lo,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mataico Zisu tah, “Kama heh hringnah very cawh ka cang hi. Kama khatei a vongpaw cawngsaw cawh a ngaidi by be, taico kama a pa zingpaw cawngsaw cawh zening tahmai a tui hrae by be. ");
INSERT INTO zypNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Canghrasala ka rei ciapaw hratah, naa pa hmuh thlang naná teitah pa zing hlui bei he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Paw tei a pa pehpaw vytei sahlo cawh kama khatah a vong he ka, kama khatah a vongpaw maikaw cawh ahohmai daichua bei neh. ");
INSERT INTO zypNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Zecawtamaw tatah kama ka dunah tua rua pawtah vaicung taitah za cung be ca neh ka, a pa tawpaw a dunah tua rua pawtah a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taico a pa tawpaw a dunah cawh kama a pa pehpaw vytei sahlo khah pakheh hmai hly lytah caichangnah ning letah tho sápaw he khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Zecawtamaw tatah ka Paw a dunah cawh Sawcapaw khah hmuh katei, a zingpaw taco chaizaw hringnah hnui ka, caidongnah ning letah kama tah ka patho a,” tahpaw heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Kama heh vaicung taitei a za cungpaw very cawh ka cang,” a tah cawtah Juda cawngsaw sahlo takhei a kong phingze hrang khah patho he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Ma paw heh Zisu, Josef a sawcapaw khah cang bei maw, a no le a paw kaa hni thlangpaw he khah? Zecawtamaw, ‘Vaicung taitah ka za cung tatah a tah lalei?’ ” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zisu taco, “Naaning le naaning teitah phingze leimei khawh khe o. ");
INSERT INTO zypNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","A pa tawpaw Paw tah a va chui he tah ly co kama kha a vong khypaw ahohmai ung bei he, a vongpaw cawh caichangnah ning letah ka patho a. ");
INSERT INTO zypNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Khazing khuavang sahlo cabu letah, ‘Aaning vytei cawh Khazing tah a cawngpah he a,’ tatah ciapaw a cang. Paw bia nge katei a cawngpaw maikaw he cawh kama kha a vong tae he a. ");
INSERT INTO zypNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Khazing taitei a va chuhpaw seh tah ly co Paw a hmuhpaw ung bei he, Ama suitei heh Paw a hmuhpaw cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Biahmuisui ka ca ching he, ahohmai a zingpaw maikaw taco chaizaw hringnah a hnui thah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kama heh hringnah very cawh ka cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Naa mapaw sahlo taco raangcaa letah manna very khah e he ka, a thi thlang he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Canghrasala vaicung taitah a za cungpaw very ung ka, ma a epaw cawngsaw cawh thi a bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kama heh vaicung taitei a za cungpaw hringnah very cawh ka cang. Cawngsaw ahotahmai ma very heh a e caco, ama cawh chaizaw tah a hring a. Ma very cawh khazaw hring ná pawtei ka paepaw ka ngaisaw heh a cang,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mataico, “Ma cawngsaw tahei zekhatamaw kaa e ruapaw tah a ngaisaw cawh a ma peh thai a?” tatah Juda cawngsaw sahlo cawh lesahtei tah a eichae he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Zisu taco aa hai letah, “Biahmuisui ka ca ching he, Cawngsaw Sawcapaw a ngaisaw naa e ly le a thisai naa ding ly caco, hringnah hnui bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ka ngaisaw e katei, ka thisai a dingpaw taco chaizaw hringnah hnui a ka, caichangnah ning letah ka patho a. ");
INSERT INTO zypNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Zecawtamaw tatah ka ngaisaw cawh batui hmuisui cang ka, ka thisai cawh ding hmuisui ruapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ka ngaisaw e katei, ka thisai a dingpaw cawh kama letah ung ka, ama letah kama zong ka ung hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A hring thlangpaw Paw tah pa taw ka, Paw thongtah ka hringpaw hratah Ka ngaisaw e katei ka thisai a dingpaw cawh kama ka thongtah ama zong a hring a. ");
INSERT INTO zypNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma heh vaicung taitei a za cungpaw very cawh a cang. Kaa mapaw sahlo cawh manna very khah e he ka, a thi he, canghrasala ma very a epaw heh cawh chaizaw tah a hring a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ma bia heh Kapernaum khua synagog letah a cawngpah ning he tah a reipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma bia cawh aa thui tihtah a hningzuitu mehlupui takhei, “A cawngpahnah a ru ngetei. Ahomaw a cyhlang khy a?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma kong a reipaw rawng tei a hningzuitu sahlo aa phingzepaw khah Zisu tah hnih ka, aa hai leco, “Ma bia takhei naa lung ca cangsah bei he i? ");
INSERT INTO zypNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Cawngsaw Sawcapaw heh a ungnah tawpaw lang a ke kawpaw khah hmuh my la, zekhatamaw naa ta a! ");
INSERT INTO zypNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hringnah a peipaw cawh Thlawpaw heh a cang, ngaisawpaw cawh zehmai cang be. Naaning khatei ka reipaw bia sahlo heh thlawpaw cawh cang ka, hringnah a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Canghrasala, naaning thaikhehpaw sahlo taco zing bei he ceh,” tatah a tah he. Zecawtamaw tatah ahomaw a zing lypaw tahpaw le ahomaw a pa luithae a tahpaw khah a thoning taitah Zisu tah a hni thah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A bia reipaw cawh pazo ka, “Ma cawtah hei Paw tah a baw ly caco he kama kha a vong khypaw ung bei he tatah ka tahpaw khah a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma khy cangkaw leco, a hningzuitu mehlupui khah a paleh kaw he ka, Ama khah zui khawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Macawtaco Zisu tah a hningzuitu pahrawhluihning sahlo khah, “Naaning saw, seihly cawh naa du hrah maw, du hrah ly?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piter tah, “Abuipaw, aho kha maw kaa sei a? Chaizaw hringnah bia a hnuipaw cawh nama na cang. ");
INSERT INTO zypNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nama cawh Khazing a Mehpathai na cang tahpaw hnih peh ka, kaa zing myca,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mataico Zisu tah, “Naaning hluihningpaw heh kama tah ka ca thingpaw cang bei he ceh maw? Canghrasala naaning hrong lehei pakheh cawh khachia a cang!” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ma cawh hluihning letei reipaipaw, a hning tah Ama a luithepaw Simon Iskariot a sawcapaw Judas Iskariot khah a tah hnangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma khy taico Zisu cawh Galili pai chung khah a tlawng lai, Judia raang taitah a nocareipaw a cang, zecawtamaw tatah Juda cawngsaw sahlo takhei kaa thaw a tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Canghrasala Juda cawngsaw sahlo Thlangda Panaw khah a ne tihtah, ");
INSERT INTO zypNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","a uny sahlo takhei Zisu cawh, “Na hningzuitu sahlo tah ningang chuipaw na tuapaw sahlo khah hmuh na he seh tatah ma taihei piathlah la, Judia raang lang na sei be. ");
INSERT INTO zypNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Cawngsaw tah pa hnih he seh tah a dupaw taco aparuh teitah zehmai tua bang bei he. Ma hming sahlo na tuapaw hei khazaw cawh a hnisah ca,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Zecawtamaw tatah a chuahrui uny sahlo takhei hmai tah Ama cawh zing bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Macawtaco Zisu tah aaning sahlo cawh, “Ka cawtah cai rawhpaw tlung balang be; naaning naa caw taco ze cai hmai heh a rai cang thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Khazaw tahei naaning cawh a ca hua bei he, canghrasala kama cawh a pa hua, zecawtamaw tatah a tuapaw khah hmingchahly a cang tatah ka tah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Panawnah lang cawh va sei la, kama cawh va sei balang bei neh, zecawtamaw tatah ka cawtah cai tlung balang be,” tatah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ma bia a rei khy taico, Galili pai chung lekhei a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Canghrasala a uny sahlo cawh Panawnah zo pawtah aa seithlah khy taikhei Ama zong cawh langhai tah cang lytah aparuh teitah a sei hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Panawnah leco Juda cawngsaw sahlo takhei hui he ka, “Ma cawngsawpaw khah zeletamaw a ung?” tatah aa hae lai he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Zawpuipaw taco a konglang cawh a cekanawh tlungmang he. Thaikhehpaw tah, “Mehchaw a cang,” tatah aa tah. Ahringpaw tah, “Cang be, cawngsaw a dungkhei laipaw a cang,” tatah aa palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Canghrasala Juda cawngsaw khah aa cinah caw he tah ahotahmai a kong khah langhai tah zehmai rei bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Panawnah cawh a cing chy tluh aa pachang hrawnghrang lekhei Zisu cawh behnah ingdung chunglang khah va sei ka, a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda cawngsaw sahlo cawh aa khuarawh haa ka, “Ma cawngsawpaw tahei cawngnah hnui lytah zekhatamaw ma hrahei a hni thlang?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Zisu taco, “Ka cawngpahnah heh kama taiteipaw cang be. A pa taw tupaw taitei a va chuhpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Khazing dunah tua a pachiapaw cawngsaw taco ka cawngpahnah heh Khazing taitei a va chuhpaw maw a cang, a cang ly leh kama taiteipaw maw a cang tah cawh a hni thlang a. ");
INSERT INTO zypNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ama dunah hratah male a cawngpahpaw cawh ama ming chahnah a huipaw a cang. Canghrasala ama a taw tupaw ming chah nápaw caw tei a hrepaw cawngsaw cawh zingchuipaw cawngsaw a cang; a chung letah hinghenah hnui be. ");
INSERT INTO zypNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Phungbia khah Moses tah ca pei bei he maw? Pakheh tahmai tah naa zui tlung be. Zecawtamaw thaw na pa pachia he ceh?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Cawngsaw zawpui taco, “Nama cawh khachia tah a pahrangpaw na cang. Ahomaw thaw a ca pachia?” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zisu taco aa hai letah, “Ningang chuipaw sangkheh ka tuapaw khah naa zongmingtei tah naa khuarawh a haa. ");
INSERT INTO zypNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses tah cingpatainah phung a ca peh caw he tah Sabat ning tahmai nyheh khah aa cingpa naa tai he kho. A ngetei tahpaw co, ma cawh Moses taitah a chuhpaw cang lytah naa pu naa paw sahlo taitah a chuhpaw a cang kho. ");
INSERT INTO zypNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses phungbia khah ro tlung lytah nyheh khah Sabat ning tah aa cingpa naa tai he a cang caco, zecawtamaw Sabat ning tah cawngsaw pakheh ka dangsahnah rawng letah ka cung letah naa thing a ae? ");
INSERT INTO zypNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A cungphai a langná tah biacepah khe la, a dingpaw teitah biace my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma bia rawng taco Jerusalem khuapui letei a ungpaw cawngsaw thaikhehpaw sahlo tah, “Ma paw heh thaw a pachiapaw he khah cang bei maw? ");
INSERT INTO zypNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ma lehei a langhai tah bia rei ka, zekhatahmai aa tah tlung be. Nawhnuitu sahlo tahei Khri cawh ama heh a cang tahpaw hnih pase ta he maw? ");
INSERT INTO zypNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Canghrasala kaaning sahlo taco ma cawngsawpaw heh zelang tah a va chuhpaw maw a cang tah hnih thlang tlung peh ka, canghrasala Khri a va chua tih taco zelang tamaw a va chua a tahpaw ahotahmai aa hni tlung be,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mataico, Zisu cawh behnah ingdung chung letei a cawngpahnah pawhe leco a thangpui tah y ka, “A cang, pa hnih he ceh ka, zelang tah a va chuhpaw maw ka cang tahpaw zong naa hni. Kama ka rei tah ma lehei a vong bei neh, canghrasala a pa tawtupaw cawh ahmangpaw a cang. Naaning taco Ama cawh hnih bei he ceh, ");
INSERT INTO zypNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","canghrasala kama taco Ama cawh ka hni, zecawtamaw tatah Kama cawh Ama taiteipaw cang neh ka, Ama tah a pa taw,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ma leco tle a pachia he, canghrasala ahotahmai a cung letah aa kih thlah bei he, zecawtamaw tatah a cai khah tlung balang be. ");
INSERT INTO zypNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cawngsaw zawpui chung letei mehlupui takhei Ama cawh aa zing. “Khri a va chua tihtah ma cawngsawpaw navy hei ningang chuipaw paching pakhanah a hlu vy a tua hlui maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Cawngsaw zawpui tah ma hratei a kong aa reipatlaw tlungmangpaw khah Farasi sahlo tah aa thui. Mataico, tlangbui macang sahlo le Farasi sahlo takhei Zisu cawh tle pawtah behnah ing raevai sahlo khah aa taw he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Zisu taco, “Naaning khatah cai cuitei ung neh ka, mataico a pa tawtupaw khatah ka sei a. ");
INSERT INTO zypNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pa hui he ceh ka, pa hmuh a bei ceh; ka ungnahpaw lang zong va sei khy bei ceh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda cawngsaw sahlo cawh pakheh le pakheh khah, “Ma cawngsawpaw heh kaa hmuh khy ly nápawtah zelang maw sei a pachia? Grik cawngsaw sahlo hrong letei a kaipaza pawhe Juda cawngsaw aa ungnah lang sei ka maw, Grik cawngsaw sahlo a va cawngpah he a? ");
INSERT INTO zypNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Pa hui he ceh ka pa hmuh a bei ceh, ka ungnah lang zong va sei khy bei ceh,’ a tahpaw heh zemaw a rei du?” tatah aa tah tlungmang. ");
INSERT INTO zypNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Panawnah a changnah le a rungnaw caipaw ning leco Zisu cawh a daw ka, a thangpui tah, “A tui a hraepaw cawngsaw cawh Kama kha a vong seh la, va ding seh. ");
INSERT INTO zypNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","A pa zingpaw cawngsaw cawh Capathai tei a reipaw hratah hringnah tuihnaw a chung taitah a laichua a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A reidupaw cawh Ama a zingpaw sahlo tei aa cy lepaw Thlawpaw khah a cang. Ma cai tai leco Zisu cawh parungnaw a cang balang ly cawtah Thlawpaw khah peh cang balang bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A bia aa thuinah cawtah khei cawngsaw thaikhehpaw sahlo tah, “Ma cawngsaw heh kaa haw thlangpaw Khazing khuavang a cang hrahring thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ahringpaw takhei, “Ama heh Khri cawh a cang,” tatah aa tah. Ahringpaw vy taco, “Zekhatamaw Khri cawh Galili raang taitah a chua thai a? ");
INSERT INTO zypNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Capathai tah Khri cawh David pathlah taitah le David a ungnahpaw khua, Bethlehem taitah a chua a tah bei maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Taico Zisu rawng taco zawpui cawh a chaichy he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Thaikhehpaw tah tle du he ka, canghrasala ahotahmai tah a cung letah aa kih thlah bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A changnah leco behnah ing raevai sahlo cawh tlangbui macang sahlo le Farasi sahlo khakhei a vaw kaw he ka, “Zecawtamaw naa va chuakhui be?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Behnah ing raevai sahlo taco, “Ma cawngsawpaw tei a reipaw hrahei a reipaw ahohmai ung balang bei he,” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farasi sahlo taco, “Naaning zong ca dungkhei thah hrah ta he maw?” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Hruitu sahlo le Farasi sahlo hrong letah ama a zingpaw a ung he maw? ");
INSERT INTO zypNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aa ung tlung be. Canghrasala, ma zawpuipaw tahei co phungbia zehmai aa hni tlung be, macawtaco pui aa cung letah chiasahnah a tlung he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aa hrong letei cawngsaw pakheh Nikodema, zai tah Zisu khah a vawpaw takhei, ");
INSERT INTO zypNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kaa phungbia tahei cawngsawpaw zemaw a tua tahpaw hlehlang taw lytah thaily a cangsah maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aaning sahlo taco, “Nama zong Galili raang taiteipaw cang hrah ta ceh maw? Khazing bia letah mingtua, Khazing khuavang cawh Galili raang taitah chuh a be, tahpaw cawh na hmuh thlang a,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mataico aa ing cacy khei a dih he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Canghrasala Zisu cawh Oliv tlaang lang khah a sei. ");
INSERT INTO zypNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mongdi takhei behnah ingdung chunglang khah a nae kaw ka, zawpui cawh ama khatah a vong he ka, taico a ty ka, aaning cawh a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Phungbia cawngpahtu sahlo le Farasi sahlo takhei capaw kha a phei leimeinah letah aa tlepaw canu pakheh khah aa va chuakhui. A hme leco a dawsah he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Zisu hai leco, “Cawngpahtu, ma canuno heh capaw kha a phei leimeinah letah tlepaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Phungbia leco Moses tah, ‘Ma hapaw canu cawh alung tah naa vaseh he a,’ tatah bia a ma peh. Nama saw zekhatamaw na rawh?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ma biahaenah heh, Ama sua aa pu khy nápawtah ahui hratah aa thlahkhaipaw a cang. Canghrasala, Zisu taco alui lang a bung ka, a kihdong tah alui leco ca a cia. ");
INSERT INTO zypNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bia cawh aa haechai leimei tihtah a ka y ka, aa hai leco, “Naaning hrong lehei a sua bang lypaw takhei ma canuno heh alung co va taw seh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Taico a khuh ka, alui leco ca cawh a cia kaw. ");
INSERT INTO zypNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma bia a thuipaw sahlo cawh a macang caipaw taitah a nyheh caipaw tai pakheh khy pakheh tah seihly thlu he ka, Zisu longtei khah aa patang si, canuno cawh ma leco a daw thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Zisu cawh a ka daw ka, canuno cawh, “Cawngsawno, zelang maw aa ung thlu? Ahotahmai thaily ca cangsah bei he maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Canuno taco, “Cawngpahtu, ahotahmai tah thaily pa cangsah bei he,” tatah a tah. Mataico Zisu tah, “Kama zong tah sua ca phosah hrah bei neh. Va sei la, va sua khawh kheh lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Zisu taco zawpui sahlo khakhei bia cawh a reikaw, “Kama cawh khazaw khainah ka cang. A pa zuipaw cawh a muinah letah sei by be, khainah tei a pehpaw hringnah khah a hnui hri a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farasi sahlo taco, “Nama tah nama na kong lilaw na rei hi. Macawtaco na reipaw heh zehmai cang be,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zisu taco, “Kama teitah ka cangnah ka rei tahmai tah ka reipaw cawh ahmangpaw a cang, zecawtamaw tatah kama taco zelang tamaw va chuh neh ka, zelang maw ka sei a, tahpaw ka hni. Canghrasala naaning taco zelang tamaw va chuh neh ka, zelang maw ka sei a, takhah hnih bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Naaning taco mehnung phung tah bia naa ce tei; Kama cawh ahohmai biacepah bei neh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Canghrasala bia ka cepah he tahmai tah ka cepahnah cawh ahmang a, zecawtamaw tatah Kama teitah cang bei neh. A pa tawtupaw Paw khatah ka daw peh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Naaning naa phungbia letah mehnung pahning tah biaparua tei aa reipaw cawh a hmang tatah a cia hrah bei maw! ");
INSERT INTO zypNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kama cawh Kama teitah ka cangnah a reipaw ka cang; a pa hnikhuitu ahringpaw cawh a pa tawtupaw, Paw khah a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mataico Zisu cawh, “Na paw cawh zeletamaw a ung?” tatah aa hae. Zisu taco, “Naaning cawh kama zong pa hnih bei ceh, ka Paw zong hnih bei ceh. Kama naa pa hni caco, ka Paw zong naa hni thlang hrá a,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ma bia heh behnah ing chung tholong aa chianahpaw kae letei a cawngpah ning he tah a reipaw a cang. Ahotahmai tle hrah bei he, zecawtamaw tatah a cai a tlung balang lynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aa hai letah Zisu tei a rei vypaw cawh, “Kama cawh sei neh ka, pa hui he ceh ka, naa suanah letah na thi he ceh. Ka seinahpaw lang zong a vong khy bei ceh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Macawtaco Juda cawngsaw sahlo tah, “Ka seinahpaw lang va sei khy bei ceh a tahpaw heh, ‘Kama le kama ka thae a,’ a tah dunah maw a cang a?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Canghrasala aa hai leco, “Naaning sahlo cawh a rai lang taiteipaw na cang he ceh. Kama cawh cung lang taiteipaw ka cang. Naaning cawh khazaw leteipaw cang he ceh ka, Kama cawh khazaw leteipaw cang bei neh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Naa suanah letah na thi he ceh tatah ka ca ching thah he; Kama cawh ka reipaw ama khah ka cang ka tahpaw naa zing ly caco, naa suanah letah na thi hrahring thlang he ceh,” tatah a tah vy. ");
INSERT INTO zypNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aaning sahlo taco, “Ahomaw na cang?” tatah aa hae. Zisu taco, “Athoning taitah pui ka ca ching thah he kha,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Naaning naa kong letah bia rei ruapaw a hlupui ka hnui. Canghrasala a pa tawtupaw cawh a paichai tlang cang ka, ama taitei ka thuipaw khah khazaw heh ka chingpaw a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aaning sahlo taco, a Paw kong a ma ching tahpaw khah thui thai bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Macawtaco Zisu tah, “Cawngsaw Sawcapaw naa calia tih taco ahomaw ka cang tahpaw le, kama ka rei tah zehmai ka tua lypaw le, Paw tei a pa cawngpahpaw khah ka rei takhah naa hni tae a. ");
INSERT INTO zypNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A pa tawtupaw cawh Kama khatah a ung. Kama long teitah pa seisai be, zecawtamaw tatah Ama a lung a lawng nápaw khah ka tuateinah cawtah a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A reipaw bia a thuipaw mehlupui tah Ama khah aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zisu tah Ama a zingpaw Juda cawngsaw sahlo hai letah, “Ka cawngpahnah letah naa ung paria thlang caco, ka hningzuitu hmuisui na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mataico biahmuisui hnih a he ceh ka, ma biahmuisui taco a ca lua sá he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aaning sahlo taco, “Kaaning cawh Abraham pathlah cang peh ka, aho sae hmai cang bang bei peh, zecawtamaw luasah na cang he ceh, tatah na ma tah?” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Zisu taco, “Biahmuisui ka ca ching he, a suapaw maikaw cawh suanah sae a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sae cawh ingchungkho letah reipai ruapaw cang be, canghrasala Sawcapaw cawh chaizaw cawtah ingchungkho letah a ungpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Macawtaco Sawcapaw tah a ca luasah caco he, na lua hmuisui he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham pathlah na cang he ceh tah cawh ka hni. Canghrasala Kama cawh thaw na pa pachia he ceh, zecawtamaw tatah ka bia tah naa chung letah hminghmaw hnui be. ");
INSERT INTO zypNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Paw a hmekaw letei ka hmuhpaw khah ca ching he neh ka, canghrasala naa paw taitei naa thuipaw khah naa tua laky thlang,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aaning sahlo taco, “Abraham cawh a ma pathlahtu a cang,” tatah aa chai. Zisu taco, “Abraham pathlah naa cang caco, Abraham a tuapaw khah pui naa tuá caw! ");
INSERT INTO zypNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Khazing taitei ka thuipaw biahmuisui a ca chingpaw he Kama heh thaw na pa pachia he ceh. Abraham taco ma hapaw cawh a tua bang tlung be. ");
INSERT INTO zypNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Naaning sahlo cawh naa paw tei a tuapaw hming sahlo khah naa tua leimei thlang tei,” tatah a tah he. Aaning sahlo taco, “Kaaning cawh zisaw kaa cang tlung be. Paw ka hnuipaw cawh Khazing suipaw a cang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zisu taco aa hai letah, “Khazing khah naa Paw a cang caco, naa pa do ruapaw a cang, zecawtamaw tatah Khazing taitah a vong neh ka, atoheh ma lehei ka ungpaw a cang. Kama ka rei tah a vong bei neh. Ama tah a pa tawpaw a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Zecawtamaw ka biareipaw heh naa hni pase thai be? Zecawtamaw tatah ka reipaw naa thui thaily navai tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Naaning cawh Setan khah naa paw cang ka, naa paw a dupaw khah tua lai naa du. Ama cawh athoning taitah lenongpaw cang ka, biahmuisui khah a tle be, zecawtamaw tatah ama letah biahmuisui a ung lynah cawtah a cang. A hing tihtah ama a chuakhuipaw khah a reipaw a cang thlang, zecawtamaw tatah ama cawh mehing le hingnah paw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Biahmuisui ka rei thlang naná teitah pa zing bei he ceh hi! ");
INSERT INTO zypNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Suanah a tua tatah a pa tah khypaw na ung he ceh maw? Biahmuisui ka ca ching tei he a cang caco, zecawtamaw naa pa zing be? ");
INSERT INTO zypNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Khazing tei a cangpaw cawngsaw taco Khazing rei khah a nge. Khazing a rei naa nge lynah chang cawh Khazing tei naa cang lynah cawtah a cang hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda cawngsaw sahlo taco, “Nama cawh Samaria cawngsaw cang ceh ka, na chung letah khachia a hrei kaa ca tahpaw khah ahmang thlang bei maw?” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zisu taco, “Ka chung letah khachia a hrei be, ka Paw khah cizaw neh ka, canghrasala naaning taco pa cizaw bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kama cawh Kama ka rungnawnah a huipaw cang bei neh; canghrasala a pa huipahtu pakheh ung ka, Ama cawh biacetu a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Biahmuisui ka ca ching he, ka bia a zuipaw cawngsaw cawh thi hrahring a be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda cawngsaw sahlo takhei, “Na chung letah khachia a hrei hrahring thlang tahpaw atoheh a se pawtah kaa hni myca. Abraham cawh thi ka, ma hraco Khazing khuavang sahlo zong a thi hrah he, canghrasala nama taco ka bia a zuipaw cawngsaw cawh thihnah pateh hrahring a be, tatah na tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nama cawh kaa mapaw Abraham navy tah na lai vy maw? Ama cawh thi ka, ma hraco Khazing khuavang sahlo zong a thi hrah he. Aho tamaw na rei?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Zisu taco, “Kama le kama ka parungnaw caco, ka parungnawnah cawh zehmai cang be. Kaa Khazing naa tahpaw ka Paw heh a pa cuicaling tu cawh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ama cawh naa hni ly tahmai tah Kama taco Ama cawh ka hni. Hnih bei neh ka tah caco, naaning hratah mehing ka cang hrá a, canghrasala Ama cawh hnih neh ka, a bia khah ka zui. ");
INSERT INTO zypNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Naa mapaw Abraham cawh ka va chua nápaw ning hmuh ruapaw heh a ngete be ca ka, ka ning cawh hmuh ka, a lawng ngetei,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juda cawngsaw sahlo taco Zisu cawh, “Nama cawh kung songngaw hmai na tah balang tlung be, Abraham cawh na hmuh thah tah law!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zisu taco, “Biahmuisui ka ca ching he, Abraham a pi hlai tah a ung thahpaw ka cang!” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma tih taco Ama va nápawtah alung cawh haw he ka, canghrasala Zisu cawh behnah ingdung chung taikhei piathlah ka, a nawh. ");
INSERT INTO zypNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lang letah a seipai khei a no chungpi taitei a mehcopaw cawngsaw pakheh khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A hningzuitu sahlo taco Zisu cawh, “Cawngpahtu, a no chungpi tei a mehcopaw cawngsawpaw heh ama a suanah rawng tamaw a cang, a cang ly leh a no le paw aa suanah rawng tah?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zisu taco, “Ama a suanah rawng tah cang be, a no le paw aa suanah rawng tah zong cang be, ma hratei a cangpaw heh a hringnah letah Khazing rai a langsah nápaw cawtah a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A pa tawtupaw a rai heh ching cai a cang chung lehei kaa hre a. Ahohmai aa hre khy ly nápaw zai cai a va chuh a. ");
INSERT INTO zypNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kama heh khazaw letah ka ungchung tahei co, khazaw khainah ka cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma bia a rei khy taico alui letah a ci chawh ka, a ci co alui cawh nawng ka, cawngsawpaw a mehkho leco a hne pah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Va sei la, Siloam tuiping letah a va si, (Siloam a silang cawh Taw tahnah a cang),” tatah a tah. Macawtaco cawngsawpaw cawh sei ka, a va si ka, khua cawh hmuh kaw ka, ing lang a dih. ");
INSERT INTO zypNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A ingpaw sahlo le kih dopaw a cangpaw a hmuh teipaw cawngsaw sahlo takhei, “Ma cawngsawpaw heh a ty hmo tei kih a do teipaw khah cang thlang bei maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Thaikhehpaw cawngsaw sahlo taco, “Ama khah a cang thlang,” aa tah. Ahringpaw sahlo taco, “Cang be, ma cawngsawpaw khah a lo bia a cang,” tatah aa tah. Canghrasala ama teitah, “Ma cawngsawpaw khah ka cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","A cang caco, “Zekhatah zia tamaw na meh cawh khua a hmuh khy?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma cawngsawpaw taco, “Zisu aa tahpaw cawngsawpaw takhei alui nawng ka, ka meh letah a pa hne. Taico va sei la Siloam tuiping letah a va si tatah a pa tah. Macawtaco sei neh ka, a va si neh ka, mataico khua ka hmuh khy,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aaning sahlo taco, “Ma cawngsawpaw cawh zeletamaw a ung?” tatah aa hae. “Hnih bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aaning sahlo taco a meh a za copaw cawngsawpaw khah Farasi sahlo khakhei aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Zisu tah alui nawng katei, cawngsawpaw a meh khua a hmuhsah kawnah ning khah Sabat ning a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Macawtaco zekhatah zia tamaw khua a hmuh khy kaw tahpaw khah Farasi sahlo zong taco aa hae. Ma cawngsawpaw taco, “Ka meh letah catlawh pa hne ka, a si neh ka, atoheh khua ka hmuh khypaw a cang,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farasi thaikhehpaw sahlo taco, “Ma cawngsawpaw cawh Khazing taiteipaw cang be, zecawtamaw tatah Sabat ning hmai a zaa lypaw,” tatah aa tah. Canghrasala, ahringpaw sahlo takhei, “Mehsua taco ma hapaw ningang chuipaw paching pakhanah cawh zekhatamaw a tua khy a?” tatah tah he ka, macawtaco a chaichy he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","A hning taco, mehcopaw lang cawh a hui kaw he ka, “Ama a kong rei ruapaw na hnuipaw a ung maw? Na meh cawh ama tah khua ca hmuhsah tlung ka,” tatah aa tah. Ma cawngsawpaw taco, “Khazing khuavang a cang,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma cawngsawpaw cawh athoning tah a meh za co katei, ato letah khua a hmuhpaw khah Juda cawngsaw sahlo taco zing be ca he ka, macawtaco cawngsawpaw a no le a paw cawh aa va ysah he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ma cawngsawpaw heh a no chungpi tah a meh a co naa tahpaw naa sawcapaw cawh a cang maw? Atoheh zekhatah zia tamaw khua a hmuh khy kaw thai?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A no le paw taco, “A hmang, kaa sawcapaw a cang. A no chungpi tah a mehcopaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Canghrasala atoheh zekhatah zia tamaw khua a hmuh khy, aho tamaw a meh cawh khua a hmuhsah tahpaw cawh hnih bei peh. Ama khah hae thlang o. A kungkhua a zawpaw a cang myca; Ama tah ca chai thlang he seh,” tatah aa chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A no le paw tah ma bia aa reipaw heh Juda cawngsaw sahlo khah aa cinah caw he tah a cang, zecawtamaw tatah aaning sahlo takhei Zisu cawh Khri a cang tatah a tahpaw maikaw cawh synagog taitah papia a cang he a tatah bia aa thlia thah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ma rawng tahei, “A kungkhua a zaw capaw a cang, ama khah hae thlang o,” tatah a no le a paw tah aa tahpaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aaning sahlo taco a meh a za copaw cawngsawpaw cawh a uihningnah aa va ysah kaw he. “Khazing tukhah reithai, ma cawngsawpaw heh mehsua a cang tah kaa hni,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A meh a za copaw cawngsawpaw taco, “Mehsua a cang le cang ly kama hnih bei neh. Kama cawh mehco cang neh ka, canghrasala atoheh cawh khua ka hmuh myca tah long heh ka hni,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Taico ma cawngsawpaw cawh, “Nama khatah zehming maw a tua? Zekhatamaw na meh cawh khua a hmuhsah?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma cawngsawpaw taco, “Ka ca ching thah thlang he ceh saw, naa nge du tlung be. Zecawtamaw naa pa hae hry kaw leimei? A hningzuitu cang maw naa du hrah?” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mataico aa sawsaw tah ma cawngsawpaw cawh, “Nama khah ma cawngsawpaw a hningzuitu khah na cang kho! Kaaning cawh Moses hningzuitu ka cang peh hi! ");
INSERT INTO zypNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Khazing cawh Moses kha bia a rei tei tahpaw kaa hni, canghrasala ma cawngsawpaw kong lehei co, zelang tamaw a va chua tahpaw hmai hnih bei peh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Cawngsawpaw taco, “Ka meh cawh khua a pa hmuhsah thlang ceh samaw, zelang tamaw a va chua tah naa hni lypaw cawh khuarawha a chui caimang. ");
INSERT INTO zypNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Khazing taco mehsua sahlo aa bia cawh nge be. Khazing zing ka, a dunah a tuapaw cawngsaw aa bia khah a nge tah cawh kaa hni. ");
INSERT INTO zypNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A no chungpi tah a meh a copaw khua a hmuhsah he aa tahpaw ahohmai thui bang bei peh. ");
INSERT INTO zypNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma cawngsawpaw heh Khazing taiteipaw a cang ly caco, zehming hmai tua khy a be!” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aaning sahlo taco, “Nama na pinah taitei suaná tah a chihpaw tahei maw kaaning cawh cawngpah na ma pachia hrah!” tatah aa palei. Taico aa tingchua. ");
INSERT INTO zypNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aa papia hly tahpaw khah Zisu tah thui ka, a tong tihtah a hai leco, “Cawngsaw Sawcapaw heh na zing maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma cawngsawpaw taco, “Cawngpahtu, ama cawh ahomaw a cang? Ka zing khy nápawtah pa ching theh law,” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Zisu taco, “Ama cawh na hmuh thahpaw; atoheh nama khatei bia a rei leimeipaw cawngsawpaw heh a cang hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mataico cawngsawpaw taco, “Abuipaw ka zing,” tah ka, a beh. ");
INSERT INTO zypNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zisu taco, “Mehco tah khua aa hmuh khy nápawtah le khua a hmuhpaw cawh mehco aa cang nápawtah khazaw lehei biace pawtah ka va chua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ama khatei a ungpaw he Farasi thaikhehpaw sahlo tah ma bia cawh aa thui tihtah, “Kaaning zong aa meh a co na ma tah dunah a cang maw?” tatah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zisu taco, “Naa meh cawh co seh la, thaily na cang lypaw he ceh, canghrasala kaa meh khua a hmuh naa tah caw tahei thaily naa cang ning thlang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Biahmuisui ka ca ching he, tuu a ki chunglang a naenah ingkaw lang tah a nae ly tei ahringpaw lang tah a kepaw cawngsaw cawh mehru le damia a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A naenah ingkaw lang tei a naepaw cawh a tuurung a kingpaw cawngsaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A kingtu cawngsaw takhei a kha cawh hong pah a ka, tuu sahlo taco a o khah aa nge a. A tuu sahlo khah aa ming tah y he ka, khungthing lang a piakhui he a. ");
INSERT INTO zypNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A tuu sahlo khah a papia thlu tih he tah ama tah langhmesah pá he ka, a tuu sahlo taco aa zui a, zecawtamaw tatah a o khah aa binah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Canghrasala ming hringpaw khah cawh zui by bei he, ma cawngsaw khah cawh aa saisai hrahring a, zecawtamaw tatah a o khah aa bi lynah rawng tah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zisu tah a biareinah letah ma tawchingnah bia heh a hmang tihtah aaning sahlo taco zemaw a ma ching tahpaw khah thuithai bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Macawtaco Zisu tah, “Biahmuisui ka ca ching he, Kama heh tuu a naenah ingkaw cawh ka cang. ");
INSERT INTO zypNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kama hlai tei a va chuhpaw vytei cawh mehru le damia a cang he, canghrasala tuu takhei aaning sahlo aa rei cawh nge bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kama heh a naenah ingkaw cawh ka cang. Kama lang tei a naepaw maikaw cawh pachah a cang he a. A nae a, piahly a, tah a ka, lawh zong a hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mehru cawh ruh du tah le thaw du tah le rorang du tah a vongpaw a cang. Kama cawh hringnah aa hnui khy nápawtah le hringnah a hlupui tah aa hnui khy nápawtah ka vong hi. ");
INSERT INTO zypNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kama heh tuukingtu chaw cawh ka cang. Tuukingtu chaw taco a tuu cawtah a hringnah a peh. ");
INSERT INTO zypNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A hlofapaw tuukingtu cawh tuu a hnuitupaw cang be, macawtaco chahnia a va chuapaw khah a hmuh tihtah tuu sahlo khah hningchai si he ka, a sai. Mataico chahnia taco tuurung khah ty he ka, a papaipatlaw he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cawngsawpaw cawh a sai, zecawtamaw tatah ama cawh a hlofapaw hlang chongpaw cang ka, tuu sahlo kong khah a pacangpaw cang be. ");
INSERT INTO zypNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Tuuking chaw cawh kama heh ka cang. Ka tuu khah hnih he neh ka, ka tuu zong tah aa pa hni hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Paw tah pa hnih katei, Kama tah Paw khah ka hnipaw hratah a cang. Taico tuu sahlo caw taco ka hringnah ka peh. ");
INSERT INTO zypNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma tuurung letei a cang lypaw tuu ahringpaw ka hnui vy he. Aaning sahlo zong khah ka va chuakhui he a. Aaning sahlo zong taco ka o nge a he ka, tuurung rungkheh le tuuking pakheh suitei a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ka Paw tei a pa dopaw cawh ka hringnah ka pehnah rawng takhei a cang, ma cawh hmuh kaw taepaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ka hringnah heh ahotahmai pa chu khy bei he, canghrasala kama ka rei tah ka pehpaw a cang. Peh khynah naw hnui neh ka, lah kaw khynah naw zong ka hnui. Ma nawhnuinah heh ka Paw tai tah ka hmuhpaw a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma bia rawng tahei Juda cawngsaw sahlo cawh a chaichy vy hui he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aaning letei mehlupui takhei, “Khachia tah a hrei ka, a hruh myca, zecawtamaw a bia naa nge?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Canghrasala ahringpaw takhei, “Ma bia heh khachia tah a tlepaw cawngsaw bia cang be. Khachia taco mehcopaw khah khua a hmuhsah khy maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mataico behnah ing Pehlainah Panaw khah Jerusalem khuapui letah aa tua. Ma cawh thlasih chung tah cang ka, ");
INSERT INTO zypNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Zisu cawh behnah ingdung chung Solomon dungkalung aa tahpaw lekhei a khiakaly leimei. ");
INSERT INTO zypNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda cawngsaw sahlo taco cadung he ka, “Zetih tai maw lung langlo tah na ma chia a? Khri na cang caco, a se pawtah ma ching thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Zisu taco, “Ca ching thah he neh ka, canghrasala pa zing bei ceh. Ka Paw ming tei ka tuapaw ningang chuipaw sahlo tahei kama rei hy lytah aa rei thlang hi, ");
INSERT INTO zypNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","canghrasala zing bei he ceh, zecawtamaw tatah ka tuu naa cang lynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ka tuu taco ka o aa nge, aaning sahlo cawh hnih he neh ka, aa pazui. ");
INSERT INTO zypNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chaizaw hringnah pei he neh ka, lyde khaw bei he. Ahotahmai ka kih chung taitah pa chu khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aaning a pa peipaw ka Paw cawh zezongpui navy tah alai vy. Aaning sahlo cawh ka Paw kih chung taitah ahotahmai chu khy a bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kama le Paw cawh pungkheh kaa cang peh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Juda cawngsaw sahlo takhei Ama va nápawtah alung a lah kaw hui he, ");
INSERT INTO zypNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","canghrasala Zisu taco aa hai letah, “Paw taiteipaw ningang chuipaw hming rungnawpaw a hlupui khah ka ca hmuhsah thah he. Ma hrong leco zehapaw hming takhei maw alung tah va tah thaw naa pa za?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juda cawngsaw sahlo taco, “Ma sahlo rawng takhei alung tah va kaa ca zapaw cang be, cawngsaw na cang thlang naná teitah Khazing ka cang tatei na tahpaw, Khazing na reipachia navai takhei a cang,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Zisu taco aaning sahlo cawh, “Naa phungbia letah, ‘Naaning cawh khazing sahlo ka ca tah he,’ tatah a cia bei maw? ");
INSERT INTO zypNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Khazing tah a bia a tlungnah cawngsaw sahlo khah hmai, ‘khazing sahlo,’ tatah a y he. Taico Capathai cawh ro khypaw cang be tah cawh naa hni. ");
INSERT INTO zypNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Paw tah a tei rua pawtah patlia ka, khazaw lehei a za tawpaw kama ka kong heh zekhatamaw a cang a? Mataico, zecawtamaw, ‘Khazing Sawcapaw ka cang,’ ka tahpaw heh Khazing a reipachia tatah naa pa tah? ");
INSERT INTO zypNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ka Paw tei a tuapaw khah ka tua ly caco, pa zing khe o. ");
INSERT INTO zypNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Canghrasala ma cawh ka tua caco, naa pa zing ly tahmai tah ningang chuipaw sahlo heh zing o. Ma tih taco kama ka chung letah Paw a ungpaw le Paw a chung letah ka ungpaw khah naa hnithai a,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Aaning sahlo taco tle a pachia kaw hui he ka, canghrasala a lysai he. ");
INSERT INTO zypNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mataico Zisu cawh Jordan tuivaw cakah kaw ka, khuahlai tei Johan tah baptisma a cangsahnah hminghmaw lang khah a sei. Ma leco va ung ka, ");
INSERT INTO zypNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","cawngsaw hlupui Ama khatah a vong he. “Johan tahei ningang chuipaw paching pakhanah a tua bang ly naná teitah ma cawngsawpaw kong a reipaw vytei heh cawh ahmang cehceh,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Taico ma hminghmaw leco mehlupui tah Zisu cawh aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lazaru aa tahpaw cawngsawpaw cawh a sah. Ama cawh Bethani khuapaw cang ka, Bethani cawh Mari le a chuahruino Martha aa khua a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari heh Abuipaw cung letah ringthopaw bia katei, a sang tah a phe a hrupah no khah a cang. A sahpaw Lazaru heh a cawtei a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Macawtaco a satei leh takhei Zisu cawh, “Abuipaw, na dopaw cawngsawpaw khah a sah ngetei,” tatah bia aa caw. ");
INSERT INTO zypNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma bia cawh a thui tihtah Zisu taco, “Ma asawnah heh thih nápaw cang be. Ma asawnah cawh Khazing rungnawnah cawtah cang ka, ma thong khei, Khazing Sawcapaw zong tah rungnawnah a hmuh a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zisu taco Martha le a chuahruino le Lazaru cawh a do ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazaru a sah tahpaw khah a thui naná teitah a ungnah leco ninghning a caang vy. ");
INSERT INTO zypNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mataico a hningzuitu sahlo khah, “Judia raang lang sei kaw he peh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Canghrasala aaning sahlo taco, “Cawngpahtu, kaa hninglang tei lekhei pui Juda cawngsaw sahlo takhei alung tah va aa ca za kha, ma lang cawh sei na pachia kaw thlangpaw cawh?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Zisu taco, “Ching cai letah suimehlang hluihning ung bei maw? Ching tah a khiapaw cawngsaw cawh a pachih a be, zecawtamaw tatah khazaw khainá khei khua a hmuh cawtah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Zai tah a khiapaw cawngsaw cawh a pachih a, zecawtamaw tatah khainah a hnuilynah cawtah,” tatah a palei he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ma bia a rei khy taitah a ching vypaw he cawh, “Kaa vesawpaw Lazaru cawh a ihning thah, canghrasala ama pahrá pawtah ka sei a,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A hningzuitu sahlo taco, “Abuipaw a ihning caco, a dang vy thlang a,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lazaru a thi tahpaw khah Zisu tah a rei leimei naná teitah a hningzuitu sahlo taco ihning cakhawngpaw a rei rua tatah aa rawh. ");
INSERT INTO zypNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Macawtaco Zisu taco a sepaw tah, “Lazaru a thi thah, ");
INSERT INTO zypNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","canghrasala naa zing khy nápawtah naa cawtah ma letei ka ung lypaw cawh ka thaw a chah caimang. Ama khatah va sei tua he peh,” tatah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mataico Thomas (Didama aa tahpaw) takhei a tangpaw a hningzuitu sahlo hai le co, “Ama kha thih hrá pawtah sei hrá he peh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","A va phah ning taco Lazaru cawh athlai letah aa phungnah taitah ningpali a tah thah takhah Zisu tah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethani khua cawh Jerusalem khuapui taitah khanghning tluh a hlah ka, ");
INSERT INTO zypNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","aa cawtei a thih cawtah khei Mari le Martha khah a ty khui pawtah Juda cawngsaw ahlupui a va chuh he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Zisu a va sei leimei tahpaw khah Martha tah a thui tihtah va dai pawtah piathlah ka, Mari tu cawh ing letah a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha taco Zisu hai letah, “Abuipaw, ma lehei ung thlang lacaw, ka cawtei cawh a thih tlung be. ");
INSERT INTO zypNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Canghrasala ato lehei zong na haepaw maikaw cawh Khazing tah a ca peh thlang a tah cawh ka hni,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zisu tah Martha hai leco, “Na cawtei cawh a tho kaw a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha taco, “Caichangnah letei thokawnah leco a tho kaw a tah cawh ka hni thlang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zisu taco a hai letah, “Kama heh thokawnah le hringnah cawh ka cang. A pa zingpaw cawngsaw cawh a thih tahmai tah a hring a, ");
INSERT INTO zypNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","taico kama zing hmotah a hringpaw maikaw cawh thi by bei he. Ma bia cawh na zing maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“A cang, Abuipaw, nama cawh khazaw letah a vong lepaw Khazing Sawcapaw Khri na cang tah ka zing,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Taico Martha cawh ma bia a rei khy taico va sei kaw ka, a chuahruino Mari khah aparuh teitah a va y, “Cawngpahtu ma lehei ung ka, a ca ding leimei kho!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma bia cawh a thui tihtah Mari cawh rairang tah tho ka, Zisu a tong rua pawtah khei a sei. ");
INSERT INTO zypNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Zisu cawh khuachung lang khah a va nae thlah balang be, Martha tei a va dainah hminghmaw lekhei a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mari a tykhuipaw khatah ing letah a ungpaw he Juda cawngsaw sahlo takhei he Mari rairang tah tho katei, a piathlahpaw khah hnih he ka, thlai lang caw rua pawtah a sei rua tah he ka, aa zui. ");
INSERT INTO zypNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari taco Zisu a ungnah hminghmaw khah va phah ka, a hmuh tihtah a phehrang leco a khuh panai ka, “Abuipaw, ma lehei ung thlang la caw, ka cawtei cawh a thi tlung be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zisu cawh Mari a cawpaw le ama khatei aa ka seipaw Juda cawngsaw sahlo zong aa caw hrahpaw khah a hmuh tihtah a hnahru cai ka, a lung a ny. ");
INSERT INTO zypNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Zeletamaw naa phung?” tatah a hae he. “Abuipaw, a vong la, va ming tua,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Zisu cawh a cah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mataico Juda cawngsaw sahlo takhei, “Zetlua tamaw a do tahpaw mingtua hmai o!” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Canghrasala aaning letei thaikhehpaw sahlo takhei, “Mehcopaw a meh khua a hmuhsah khypaw cawngsaw taco ma cawngsawpaw heh thih lytah ungsah khy rua bei maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zisu cawh a ngechia ngetei hmo khei thlai lang khah a vaw. Ma thlai cawh lungkua, a kaw khah alung tah aa khapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Alung heh lawhly tua o,” tatah a tah. Canghrasala a thipaw cawngsaw a sateino Martha takhei, “Abuipaw, kaa phung ná tah ningpali cang myca ka, a hnang ngetei tha a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mataico Zisu tah, “Na zing caco, Khazing rungnawnah na hmuh a takhah ca ching thah bei neh maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Macawtaco alung cawh aa lahly. Mataico Zisu cawh avai lang a y ka, “Ka Paw, na pa thuipah cawtah ka ca lawng. ");
INSERT INTO zypNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ka bia na pa thuipah tei takhah ka hni, canghrasala ma heh cawh ma letei a daw thlangpaw cawngsaw sahlo cawtah ka reipaw a cang, aaning sahlo tahei kama cawh nama tah na tawpaw a cang tahpaw aa zing khy nápawtah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ma bia a rei khy leco, Zisu cawh a thangpui tah, “Lazaru, ka pia!” tatah a y. ");
INSERT INTO zypNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A thipaw cawngsaw cawh pai anaipaw tei a kih le a phe tongchai hmo le a hme pailu bakhu hmo khei a ka pia. Zisu taco aaning sahlo cawh, “Rawh pai sahlo heh pahlu pá la, sei sá law,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Macawtaco Mari a ty khui rua tah va chuh he katei, Zisu a hming tuapaw a hmuhpaw Juda cawngsaw mehlupui taco, Zisu khah aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Canghrasala aaning letei thaikhehpaw sahlo cawh Farasi sahlo khakhei a vaw he ka, Zisu a hming tuapaw khah aa va ching he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mataico, tlangbui macang sahlo le Farasi sahlo taco biacetu Sanhedrin phu khah a pahmosah he ka, “Zekhatamaw kaa tua a? Ma cawngsawpaw tahei ningang chuipaw paching pakhanah a hlupui a tua leimei tlung. ");
INSERT INTO zypNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma hrahei kaa seisah thlang tei a cang caco, ming maikaw tah ama cawh zing a he ka, mataico Rom cawngsaw va chua he ka, kaa behnah ing le kaa raang khah aa ma lah pah a,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mataico aa hrong letei pakhehpaw Kaiafa aa tahpaw ma kung letei tlangbui alaicaipaw a cangpaw taco, “Zehmai hnih bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Raang pungpaluh a ro navy tah cawngsaw zawpui cawtah pakheh thih cawh a chah vy tahpaw heh hnih bei ceh maw?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma bia heh ama lungthó tah a reipaw cang be, ma kung lekhei tlangbui alaicaipaw a cangpaw hrakhei Juda mingphing cawtah Zisu a thi a tah le, ");
INSERT INTO zypNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Juda mingphing caw long tah cang lytah Khazing sawtei a papaipatlawpaw sahlo khah hmingkheh tah va chuakhui tei, sangkheh tah tua ruapaw he tah a thi a tatah bia a phyhlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Macawtaco ma ning taico Zisu cawh thaw rua pawtah khei khua aa khang. ");
INSERT INTO zypNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Macawtaco, Zisu cawh Juda cawngsaw sahlo hrong lekhei langhai tah a khialai khawh be. Ma taikhei piathlah ka, raangcaa kae letei a ungpaw Efraim aa tahpaw khua lang khah sei ka, ma leco a hningzuitu sahlo khatah aa va ung. ");
INSERT INTO zypNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma cai heh Juda cawngsaw sahlo Khungsai Panawnah cai khah a cang daimang tei myca. Ming hlupui cawh aa ungnah khua cacy taikhei Jerusalem khuapui lang khah panawnah cawtah phungbia hratah a pathai a pahling rua pawtah khei a sei tlungmang myca he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Zisu cawh huilai he ka, behnah ingdung chung letah a daw thlang he ka, pakheh le pakheh cawh, “Zekhatamaw na rawh? Panawnah lang heh a va chuh thly a na tah maw?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Canghrasala tlangbui macang sahlo le Farasi sahlo tah Zisu khah tle aa du cawtah a ungnah aa hnihpaw maikaw tah naa ma ching a, tatah naw aa peh he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Khungsai Panawnah hlai ningruh lekhei Zisu cawh thihnah taitei a pathopaw Lazaru a ungnah khua Bethani khah a va phah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ma leco Zisu pasungpanaw nápaw cawtah zairia dung hruinah tuapah he ka, Martha cawh batui peitu cang ka, cabuai cadung tei a ty thlangpaw he hrong lekhei Lazaru cawh Zisu khaco a ty hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mataico Mari tah nard thingkungpaw taitah lahpaw, a patahpaw, a mai a ru ngeteipaw, sathy ringthopaw kia songthung tluh khah law ka, Zisu a phe leco bia ka, a sang tah a hrupah. Taico ing chung cawh ringthopaw a ring takhei a rung thlu. ");
INSERT INTO zypNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Canghrasala a hningzuitu pakheh a cangpaw Judas Iskariot, a hning tah ama a luitupaw takhei, ");
INSERT INTO zypNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ma ringthopaw khah zua tah a mai cawh mehsisah khah peh hri ruapaw he cang bei maw? Ma khah kung kheh nihlo mai pui a cang caw!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma bia a reipaw heh mehsisah kong a pacang cawtah cang lytah mehru cang ka, a kaipaw tangkabawng chung taikhei a za lah leimei tei cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Zisu taco, “Ama khah hna hnawh khe o. Ka rawh phung ning cawtah ma ringthopaw cawh pacung thlang ky seh. ");
INSERT INTO zypNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mehsisah cawh naa hrong letah a ung paria thlang he, canghrasala Kama cawh ung paria bei neh,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ma letei Zisu a ungpaw khah Juda cawngsaw rungpui takhei hnih he ka, a vong he. Ma cawh Zisu a ung caw long takhei cang lytah thihnah taitah a pathopaw Lazaru hmuh du takhei zong a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Macawtaco tlangbui macang sahlo takhei Lazaru khah thaw pai hrápaw tah khua aa khang, ");
INSERT INTO zypNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","zecawtamaw tatah ama a rawng tah Juda cawngsaw ahlupui cawh Zisu khatah a vaw he ka, aa zingnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ningthlamongpaw cawh Khungsai Panawnah a va zopaw cawngsaw rungpui takhei Jerusalem khuapui lang Zisu a va sei a tahpaw khah aa thui. ");
INSERT INTO zypNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Aaning sahlo taco atung kung a cai khah thlia he ka, va dai rua pawtah aa sei. “Hosana! Abuipaw ming tei a vongpaw cawh bonghnang song tah ung ky seh. Israel Siangpahrang cawh bonghnang song tah ung ky seh,” tatah aa y lai. ");
INSERT INTO zypNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zisu tah la teitei khah hmuh ka, a cung leco a ke, Capathai letei ciapaw hratah, ");
INSERT INTO zypNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion sawcanu, na thlawzawng kheh seh. Mingtua, na Siangpahrang cawh la teitei va ke lai ka, a vong leimei.” tah heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Athoning taco a hningzuitu sahlo cawh ma heh thuithai bei he. Zisu parungnaw a cang khy taitah longlong, ma hming sahlo heh ama a kong aa ciapaw hratah a cung letah aa tua ky he, takhah aa hni thai. ");
INSERT INTO zypNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ama khatah a ungpaw cawngsaw rungpui takhei Zisu tah Lazaru khah athlai chung lekhei y ka, thihnah taitah a patho tahpaw bia khah aa reipachaw lai. ");
INSERT INTO zypNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Zisu tah ningang chuipaw paching pakhanah a tua tahpaw cawh aa thuinah cawtah cawngsaw hlupui cawh ama a tong rua paw takhei a sei he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Macawtaco Farasi sahlo cawh pakheh le pakheh khah, “Mingtua hmai la, zekhatah tah khy khawh bei peh hi. Khazaw pungpaluh tah pui aa zui myca he!” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Khungsai Panawnah zo tei a seipaw he sahlo hrong lekhei Grik cawngsaw thaikheh a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aaning sahlo cawh Galili raang, Bethsaida khua letah a ungpaw Filip khakhei a vong he ka, “Abuipaw, Zisu hmuh kaa du,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip taco Andru khah a va ching; aa pahning co va sei he ka, Zisu cawh aa va ching. ");
INSERT INTO zypNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Zisu tah, “Cawngsaw Sawcapaw parungnawnah cai cawh a va chuh myca. ");
INSERT INTO zypNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Biahmuisui ka ca ching he, alui letah a tlahpaw sacaang hmu cawh a thih lypaw co sangkheh teitah a cang paria thlang. Canghrasala, a thih taikhei longlong sacaang hmu a hlupui a chuasah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A hringnah a dopaw cawngsaw taco sung a ka, ma khazaw letei a hringnah a huapaw cawngsaw taco chaizaw hringnah letah a chia a. ");
INSERT INTO zypNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ka rai a hrepaw taco pazui ka, ka ungnah letah ka raihretu cawh a ung hrá a. Ka rai a hrepaw cawngsaw cawh ka Paw tah a cuicaling a. ");
INSERT INTO zypNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Atoheh cawh ka lung reithui ka, zemaw ka rei a? ‘Ka Paw, ma suimehlang cai taihei pa pachah tua,’ ka tah a maw? Cang be, ma cawpaw hrahring tahei ma suimehlang cai lehei ka vongpaw cang tlung ka. ");
INSERT INTO zypNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ka Paw, na ming a rungnawnah palang my lo!” tatah a tah. Mataico avai taitah, “Ka parungnaw thah, taico ka parungnaw vy a,” tatah o a za ring. ");
INSERT INTO zypNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma leco ung katei, ma o a thuipaw cawngsaw rungpui taco khalung a thih tah he ka, ahringpaw sahlo takhei, “Vaiming tah bia a ching,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zisu taco, “Ma o heh Kama ka cawtah cang be, naaning naa chahnah cawtah a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Khazaw biacenah cai cawh atoheh a cang, ato lehei khazaw uhtu bui cawh tingchua a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Canghrasala alui taihei calingchy ka cang tihtah Kama hrahring tah ming vytei khah Kama kha ka kui he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Zekhatamaw a thih a tahpaw hmuhsahnah takhei ma bia heh a reipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Cawngsaw zawpui taco, “Phungbia leco Khri cawh chaizaw tah a hming a tatah kaa thui. Zecawtamaw, ‘Cawngsaw Sawcapaw cawh khraws chung letah caling tah khaipai a cang a,’ tatah na tah? ‘Cawngsaw Sawcapaw,’ cawh ahomaw a cang?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mataico Zisu tah, “Cai a cawngpe chung cy khainah naa hnui a. Khainah naa hnui chung tahei a khia o, muinah tah a ca phah hlai he tahei. A muinah letah a khiapaw cawngsaw taco zelang maw a sei tahpaw hnih be. ");
INSERT INTO zypNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Khainah naa hnui chung tei lehei khainah leco naa zingnah cawh chia my lo, ma pawsui co khainah sawtei tah naa cang khy a,” tatah a ching he. Bia a reipaw a pachang tihtah Zisu cawh piathlah ka, aaning sahlo cawh a nosai he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zisu tah aa hmekaw letei ma vytei ningang chuipaw paching pakhanah sahlo a tua khy taihei hmai aaning sahlo taco zing hlui bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ma heh Khazing khuavang Isaiah tei a reipaw: “Abuipaw, aho tamaw kaa bia zing ka, aho kha tamaw Khazing tah a kih thawtlungnah cawh a langsah?” tahpaw a tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ma rawng tahei zing khy bei he, zecawtamaw tatah Isaiah tei a rei vypaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ama tah aa meh co sah he ka, aa lungthing a mosah he, macawtaco aa me tah hmuh khy be ca he ka, aa lung tah hnih thai bei he, ma hratei a cang ly caco, a paleh kaw he ka, ka dangsah thá he a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah tei ma bia a reipaw heh Zisu rungnawnah khah hmuh ka, a kong khah a reipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma naná co hruitu sahlo letei mehlupui takhei hmai Zisu cawh aa zing thlang. Canghrasala Farasi sahlo rawng takhei kaa zing tah ngang bei he, zecawtamaw tatah synagog taitah aa ma papia sua a, takhah aa phang cawtah a cang; ");
INSERT INTO zypNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","zecawtamaw tatah aaning sahlo cawh Khazing taitei pachawnah navy khei cawngsaw taitei pachawnah khah aa tlechai vy cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mataico Zisu cawh, “Kama a pa zingpaw cawngsaw cawh kama longtei a pa zing cang lytah a pa tawtupaw zong khah a zing hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kama a pa ming tihtah a pa tawtupaw zong khah a hmuh pai. ");
INSERT INTO zypNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kama cawh khazaw lehei khainah hratah a vong neh ka, a pa zingpaw maikaw cawh a muinah letah ung thlang bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ka bia thui thlang katei, a zui lypaw cawngsaw cawh Kama tah biace pá bei neh, zecawtamaw tatah khazaw bia ce pá pawtah a vongpaw cang be ca neh ka, pachah a pawtah a vawngpaw ka cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kama pahlawh katei, ka bia a cyhlang lypaw cawngsaw caw taco biacetupaw a ung thlang. Ka reipaw bia ceingei tahei ama cawh caichangnah letah thaily a cang sá a. ");
INSERT INTO zypNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Zecawtamaw tatah Kama ka tua chawngpaw tah ka reipaw cang lytah Paw, a pa tawtupaw tei zemaw reipaw, zekhatamaw reipaw tah bia a pa pehpaw tukhah ka reipaw a cang hri. ");
INSERT INTO zypNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A biapeh cawh chaizaw hringnah a phahkhuitu a cang takhah Kama cawh ka hni. Macawtaco ka reipaw maikaw cawh Paw tei rei ruapaw a pa tahpaw longtei khah a cang,” tatah o thang puitah a y. ");
INSERT INTO zypNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ma heh Khungsai Panawnah hlai tah a cang. Zisu taco khazaw piasai tei Paw khatah a sei nápaw cai khah a va chuh myca takhah a hni. Khazaw letei a ungpaw, a tei a cangpaw sahlo khah a do tunah caw he tah zetlua tamaw a do he takhah a hmuhsah he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zai batui aa cadung ning takhei Setan tah Simon a sawcapaw Judas Iskariot lungchung leco Zisu lui nápaw rawhnah khah a khung thah. ");
INSERT INTO zypNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zisu taco Paw tah ka hmingtuakhynah rai letah zezongpui a chia tah le kama cawh Khazing taitah a vongpaw cang neh ka, Khazing kha ka sei kaw a tahpaw khah a hni. ");
INSERT INTO zypNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Taico batui cadungnah taico tho ka, a angki a cung lang teipaw khah pahlu ka, a te letah pavuapai a pangia. ");
INSERT INTO zypNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ma khy taico cawtaw letah tui cawh tlai ka, a hningzuitu sahlo cawh aa phe khah si he ka, a te letei a pangiapaw pavuapai co a hrupah he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Piter kha a vaw ka, Piter taco a hai letah, “Abuipaw, nama pui tamaw ka phe na pa si a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zisu taco, “Zemaw ka tua tahpaw hnih bei ceh, canghrasala, a hning tah na hni tae thlang a,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piter taco, “Cang be, ka phe cawh pa si by bei ceh,” tatah a tah. Zisu taco, “Ka ca si ly caco, kama a pa zuitu cang khy khaw bei ceh,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piter taco, “Abuipaw, catei a cang caco, ka phe long cang lytah ka kih le ka lu zong pa si pai thlang,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Zisu taco, “A ngai a si thahpaw cawngsaw cawh a phe suipaw heh si a hia. A pungpaluh cawh a pathai thlang. Taico naaning cawh na pathai thlang he ceh, canghrasala naa zongmingtei co cang bei he ceh,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Zecawtamaw tatah ahomaw a pa lui a takhah a hni cawtah cang ka, macawtaco naa zongmingtei co pathai bei he ceh a tahpaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aa phe a si khy tai he co a angki cawh a hrei kaw ka, a ungnah lang khah a vaw ka, “Naa caw tei ka tuapaw khah naa hnithai maw?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Naaning taco, “ ‘Cawngpahtu,’ le ‘Abuipaw,’ tatah pa y he ceh ka, a hmang ngetei, zecawtamaw tatah ma cawh ka cang hmuisui. ");
INSERT INTO zypNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ato lehei kama, naa Buipaw le cawngpahtu tahei hmai naa phe ka ca si caco he naaning zong pakheh le pakheh naa phe a sipah cy my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kama heh a pa mingpai na he ceh seh tatah naa phe ka ca sipaw he khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Biahmuisui ka ca ching he, sae cawh a buipaw navy tah lai vy be ca ka, siapaw zong a siatu navy tah lai vy hrah be. ");
INSERT INTO zypNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Atoheh cawh ma hming sahlo heh naa hni myca, ma sahlo cawh naa tua caco, bonghnang song na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Naa zongmingtei khei ka ca tahpaw he cang be; ka thingpaw sahlo cawh ka bi thlang he. Canghrasala ma heh Capathai letei, ‘Ka very a e hrahpaw takhei a phengavang hmo a pa paleh so,’ tahpaw tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Hming a va cang tihtah kama cawh ama khah ka cang tahpaw naa zing khy nápawtah ato a cang hlai tahei ka ca chingpaw he a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Biahmuisui ka ca ching he, ka tawpaw cawngsaw a cyhlangpaw he cawh kama a pa cyhlangpaw cang he ka, kama a pa cyhlangpaw he cawh a pa tawtupaw a cyhlangpaw a cang he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ma bia a rei khy taico, Zisu cawh a lung reithui ka, “Biahmuisui ka ca ching he, naaning letah pakheh tah naa pa lui a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A hningzuitu sahlo cawh pakheh le pakheh khah a ming he ka, “Ahomaw a ma tahnang tu he?” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aaning letei pakheh, Zisu tei a dopaw a hningzuitu cawh ama a kae lekhei a ty thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piter takhei ma a hningzuitu cawh a mehnaw tuapah ka, “Ahomaw na tahnang?” tatah hae law a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ma cawngsawpaw taco Zisu khah a va ne ka, “Abuipaw, ma paw cawh ahomaw a cang?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Zisu taco, “Ma cawngsawpaw cawh bakang letah very heh ka nong khy taitah ka pehpaw cawngsaw khah a cang a,” tatah a chai. Mataico very cawh nong ka, Simon a sawcapaw Judas Iskariot khah a peh. ");
INSERT INTO zypNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas tah very khah a hlang cangkaw tei leh a chunglang khah Setan cawh a nae. Zisu taco, “Na tua ruapaw cawh tua tlamang thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Canghrasala Zisu tah ma hratei a tahpaw khah batui a dungpaw ahotahmai tah thuithai bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas cawh tangka a kaipaw a cangnah cawtah, “Zisu tahei Panawnah cawtah a hiapaw cawh rua pawtah a ching rua, a cang ly leh mehsisah khah hming sangkheh kheh pei bang law a tah rua,” tatah cawngsaw thaikhehpaw tah aa rawh. ");
INSERT INTO zypNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas cawh very khah a hlang cangkaw tei leh a piahly. Taico ma cawh zai tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","A sei khy taico Zisu tah, “Atoheh cawh Cawngsaw Sawcapaw heh parungnaw cang myca ka, Ama leco Khazing zong parungnaw a cang myca. ");
INSERT INTO zypNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ama letah Khazing cawh parungnaw a cang caco, Khazing taco Ama ceingei letah Sawcapaw cawh parungnaw a ka, ry lytah a parungnaw palang a. ");
INSERT INTO zypNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ka sawtei sahlo, naaning khatah cai a cuitei suipaw ka ung a. Pa hui he ceh ka, Juda cawngsaw ka chingsipaw he hrakhei atoheh ka ca ching hrah he. Ka seinah lang cawh va sei khy bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Biapeh thapaw ka ca peh he: Pakheh le pakheh a do cy my lo. Ka ca dopaw he hrakhei pakheh le pakheh a do cy my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pakheh le pakheh na do cy caco he ceh ma leco ming vytei tah ka hningzuitu naa cangpaw khah aa ca hni he a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piter taco Zisu cawh, “Abuipaw, zelang maw na sei a?” tatah a hae. Zisu taco, “Ka seinahpaw lang cawh ato lehei co pazui khy bei ceh, canghrasala, a hning tah na pazui tae a,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piter taco, “Abuipaw, zecawtamaw ato lehei ka ca zui khy be? Na caw taco ka hringnah ka pae hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mataico Zisu tah, “Ka cawtah na hringnah na peh hmuisui maw? Biahmuisui ka ca ching, aa a khawng hlai tah uithung tai na pa paphahsai a! ");
INSERT INTO zypNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Naa lung rei a thuisah khe lo. Khazing zing la, kama zong pa zing hrah my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ka Paw a ing letah ungnah a khang hlupui a ung. Ma cawh cang lytah ung my seh la, ka ca ching tha he a. Naa cawtah ungnah hminghmaw tingtua rua pawtah ma lang cawh ka sei a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Taico va sei neh ka, naa cawtah hminghmaw ka va tingtua a, ka ungnah letah naaning zong naa ung khy hrah nápawtah naaning lá pawtah ka vong kaw a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ka sei nápaw langpui cawh naa hni thlang kho,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas taco a hai letah, “Abuipaw, zelang maw na sei a tah hmai kaa hni lypaw tah zekhatamaw langpui cawh kaa hni thai a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Zisu taco, “Kama heh langpui le biahmuisui le hringnah cawh ka cang hi. Kama lang tah aa va sei lypaw co ahohmai Paw kung tlung khy a bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Naa pa hni hmuisui caco ka Paw naa hni hra a. Atoning taihei Ama cawh hnih he ceh ka, naa hmuh thah myca,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip taco, “Abuipaw, Paw cawh ma hmuhsah la, ma cawh kaa cawtah a zaw thlang a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zisu taco, “Filip, ma vytei naaning khatah ka ung khy tai lehei hmai pa hnih ting bei ceh maw? Kama a pa hmuhpaw taco Paw khah a hmuh myca, zecawtamaw, ‘Paw cawh ma hmuhsah tua,’ na tah thlang? ");
INSERT INTO zypNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kama cawh Paw letah ung neh ka, Paw cawh Kama letah a ung tahpaw heh zing bei ceh maw? Naaning khatei bia ka reipaw heh Kama taiteipaw a cang tlung be. Paw, Kama letei a ungpaw tah ma rai heh a hre. ");
INSERT INTO zypNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kama cawh Paw chung letah ung neh ka, Paw cawh ka chung letah a ungpaw khah zing thlang. Ma cawh na zing khy ly tahmai ningang chuipaw ka tuapaw rawng chang tahei zing thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Biahmuisui ka ca ching he, Kama letah zingnah a hnuipaw taco ka tuapaw khah aa tua hrah a. Zecawtamaw tatah Paw kha ka sei a navai tahei, ma sahlo navy tei a rungnaw vypaw hming sahlo hmai khah aa tua a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Taico, ka ming tei naa haepaw maikaw khah ka tua a. Ma cawh Paw rungnawnah khah Sawcapaw letah a lang nápawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ka ming tah zezongpui hae la, ka tua a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Naa pa do caco, ka biapeh heh naa nge a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Taico Paw khah hae a neh ka, Ama taco naaning khatah chaizaw ung a pawtah ahringpaw Singchingtu, biahmuisui a kaitu Thlawpaw khah a ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Khazaw tahei Ama cawh cyhlang khy be, zecawtamaw tatah Ama cawh hmuh be ca ka, hnih hrah be. Canghrasala naaning taco naa hni, zecawtamaw tatah Ama cawh naaning khatah ung ka, naa chung letah a ungparianah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Haraw kingry hratah ca seisai bei neh, naaning kha ka vong kaw a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A cawngpe khy leco khazaw tahei pa hmuh khaw be, canghrasala naning taco naa pa hmuh a. Zecawtamaw tatah ka hringnah cawtah hei na hring hrá he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma ning leco kama cawh ka Paw chung letah ka ungpaw le naaning cawh Kama letah naa ungpaw le Kama cawh naaning letah ka ungpaw khah naa hnithai a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ka biapeh thui katei a ngepaw maikaw cawh a pa dopaw cawngsaw a cang he. Kama a pa dopaw cawngsaw cawh ka Paw tah do he ka, Kama zong tah do he neh ka, ama leco Kama ceingei ka hmuh sá he a,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mataico Judas (Judas Iskariot khah cang be) takhei, “Abuipaw, zecawtamaw kaaning a hmuh sápaw taco a pachia ceh ka, khazaw a hmuh sápaw taco na pachia be?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Zisu taco, “Kama a pa dopaw taco ka cawngpahnah khah a nge a. Ama cawh ka Paw tah do ka, ama khaco, a vong peh ka, ama khatah ka cinglai a peh. ");
INSERT INTO zypNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kama a pa do lypaw cawngsaw taco ka cawngpahnah khah nge be. Ma naa thuipaw bia sahlo heh kama ka bia cang bei he. Kama a pa tawtupaw Paw a bia a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Naaning kha ka ungchung tahei ma vytei heh ka ca ching thah he. ");
INSERT INTO zypNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Canghrasala, Singchingtu a cangpaw Thlawpaw Pathai, Paw tei ka ming tah a za taw lepaw takhei zezongpui ca ching a he ka, ka rei ciapaw bia vytei khah a ca hnisah hry he a. ");
INSERT INTO zypNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Thlawlungnah ka ca chiapah si he, Kama ka thlawlungnah khah ka ca peh he. Khazaw tei a ca pehpaw he hratah ca pei bei neh. Naa lung rei a thuisah khe la, ci khe lo. ");
INSERT INTO zypNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Sei neh ka, naaning kha ka vong kaw a,’ ka tahpaw naa thui thlang kho. Naa pa do caco, Paw kha ka sei a ka tahpaw heh naa thaw a cha a, zecawtamaw tatah, Paw cawh Kama navy tah a rungnaw vy. ");
INSERT INTO zypNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hming a va cang tihtah naa zing khy nápawtah ato a cang hlai lehei ka ca ching pacia thlu thah he hi. ");
INSERT INTO zypNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naaning khatah bia sypui rei hmai khaw bei nei, zecawtamaw tatah khazaw uhtu bui a vong leimei myca. Ama cawh ka cung letah hmingtuakhynah hnui be. ");
INSERT INTO zypNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Canghrasala Paw ka dopaw le ka Paw tei bia a pehpaw khah achaw teitah ka tua tahpaw cawh khazaw tahei a hni hrahring a. A vong la, sei he peh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Kama heh misurzung hmuisui cawh cang neh ka, ka Paw cawh buichung hnuitu a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ama taco kama letei a cai a thui a thui lypaw maikaw cawh chawhly a ka, a cai a thuipaw maikaw khah thui vy lo leimei seh tatah pathai pahling teitah a tua a. ");
INSERT INTO zypNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Naaning cawh ka ca ching thahpaw he bia khei pathaipahlingsah ciapaw na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kama lehei ung la, naaning letah ka ung hrá a. Zehapaw a cai hmai ama tei co thui khy be, a zung letah a pazo ceingeipaw a cang. Ka chung letah naa ung ly caco thui khy bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kama heh a zung cawh ka cang, naaning cawh a cai na cang he ceh. Ahohmai kama letah ung ka, ama letah ka ung hrah caco, thui hlupui a thui a. Kama kha na pazo ly caco he ceh zehmai tua khy a bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kama letei a ung lypaw cawh vathlang he katei, a uipaw cai hratah a cang a. Ma hapaw a cai cawh pakhong he ka, me lang bo he ka, a kang thlu tei. ");
INSERT INTO zypNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kama letah naa ung le naaning letah ka bia a ung caco, naa dupaw maikaw khah hae la, peh na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Thui a hlupui naa thui caco, ma cawh ka Paw rungnawnah cang ka, ka hningzuitu na cang he ceh tah na langsahnah pawhe ceh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Paw tah a pa dopaw hratah ka ca do hrah he. Ka donah chung lehei ung paria thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Paw a biapeh nge neh ka, a donah letah ka ung paria thlangpaw hratah ka biapeh naa nge caco, ka donah letah na ung paria a he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ma bia ka ca chingpaw he heh naa chung letah ka lawngnah a ung tei, na lawngnah pawhe ceh a chihlui khy nápaw cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ka biapeh cawh, ‘Ka ca dopaw he hratah pakheh le pakheh a do cy my lo,’ tahpaw heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Huivesaw cawtah hringnah pehnah tai donah navy tah alai vypaw donah ung be. ");
INSERT INTO zypNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bia ka ca pehpaw he khah naa tua caco, ka vesaw na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sae tatah ca tah khawh bei neh, zecawtamaw tatah sae taco a buipaw a tuapaw khah hnih be. Huivesaw tatah ka ca tah hri myca he, zecawtamaw tatah ka Paw taitei ka thuipaw vytei khah ka ca hnisah thlu thah he. ");
INSERT INTO zypNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Naaning tah pa thing bei ceh, va sei tah a thui thui pawtah le a paruipaw thui thui rua pawtah kama tah ka ca thing he. Mataico ka ming tei naa haepaw maikaw khah Paw tah a ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ka biapeh cawh, ‘Pakheh le pakheh a do cy my lo,’ tahpaw heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Khazaw tah a ca hua caco he kama a pa hua taw thah tahpaw khah naa thinglung letah chia thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Khazaw a tei naa cang caco, a tei hratah a ca do he a. Canghrasala naaning cawh khazaw a tei cang bei ceh, kama tah khazaw taihei ka ca thing thah myca he. Ma rawng tahei khazaw tah a ca hua he hi. ");
INSERT INTO zypNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ka ca chingpaw he bia, ‘Sae cawh a buipaw navy tah lai vy be,’ tahpaw khah a thui paria thlang my lo. Aa pa hreh caco, naaning zong aa ca hreh hrá he a. Ka cawngpahnah aa nge caco, naaning zong aa ca nge hrá he a. ");
INSERT INTO zypNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ka ming navai tah aa ca pasi aa ca pasa he a, zecawtamaw tatah aaning sahlo cawh a pa tawtupaw khah hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","A vong lytah le bia ching lytah ung my he neh seh la, suanah cawh hnui a bei he. Ma duitei cawh atoheh cawh aa suanah khah a paphah khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kama a pa huapaw taco ka Paw zong khah a hua hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ahotahmai tah aa za tua bang lypaw khah aa hrong letah za tua lytah ung my neh seh la, suanah cawh hnui a bei he. Canghrasala ato lehei ma ningang chuipaw sahlo khah hmuh thlang he ka, ka Paw kha, Kama kha, kaa pahning tah aa ma hua he. ");
INSERT INTO zypNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Canghrasala, ma heh aa phungbia letei ciapaw, ‘A silang ly pui tah aa pa hua thlang he,’ tahpaw a tlingnah khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Paw taitah a chuhpaw biahmuisui a kaitu Thlawpaw, ka Paw tei a va taw lepaw Singchingtu a va chua tih taco, kama ka kong khah a ca ching he a. ");
INSERT INTO zypNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Naaning zong tah naa ching lai hra he a, zecawtamaw tatah athoning taitah Kama kha a ungpaw naa cang cawtah. ");
INSERT INTO zypNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Langpui naa pave ly nápawtah ma vytei heh ka ca chingpaw he a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aaning sahlo taco synagog alailang aa ca papia he a. Naaning a ca theh pawhe sahlo tah Khazing rai kaa hrepaw a cang tatah aa rawh nápaw he cai a va chuh leimei myca. ");
INSERT INTO zypNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aaning sahlo taco ma hapaw hming cawh aa tua a, zecawtamaw tatah Paw zong Kama zong ma hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A cai a va chua tihtah a za ma ching thah tatah naa tah rua pawtah ma heh ka ca chingpaw he a cang. Athoning takhei co za ca ching bei neh, zecawtamaw tatah naaning kha ka ung thlang cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Atoheh cawh a pa tawtupaw kha ka sei myca a. Canghrasala, ‘Zelang maw na sei a?’ tatah aho tahmai tah pa hae tua hrah bei ceh, ");
INSERT INTO zypNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","zecawtamaw tatah ma hming sahlo heh ka ca chingnah caw he tahei naa nge a ca chia he. ");
INSERT INTO zypNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Canghrasala biahmuisui ka ca ching he, Ka seipaw heh naa cawtah chah nápaw a cang. Sei lytah ung my neh seh la, Singchingtu cawh naaning kha a vong a be. Canghrasala ka sei caco, Ama cawh naaning kha ka va taw a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A va chua tihtah khazaw cawngsaw sahlo khah suanah kong le dingnah kong le biacenah kong letah biahmuisui khah a hnisah he a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Suanah kong letah thaily a cang he a, zecawtamaw tatah kama aa pa zinglynah cawtah, ");
INSERT INTO zypNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","dingnah kong letah thaily a cang he a, zecawtamaw tatah Paw khatah sei a neh ka pa hmuh khy khaw a bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Taico biacenah kong letah thaily a cang he a, zecawtamaw tatah khazaw uhtu bui cawh thaily cangsah a cang thah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Naaning kha rei ruapaw a hlupui ka hnui thlang naná teitah ato lehei co a cingkai khy bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Canghrasala biahmuisui a kaitu Thlawpaw a va chua tih taco biahmuisui chunglang khah a ca nae khui he a. Ama a lungchuá tah rei a be, a thuipaw khah rei ka, a va chuh lepaw kong khah a ca ching he a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kama ka tei a cangpaw khah law ka, a ca hnisahnahpaw he takhei Kama rungnawnah khah a va chuakhui a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Paw tei a hnuipaw vytei cawh ka tei a cang. Thlawpaw taco ka tei a cangpaw tai khei law a ka, naaning khah a ca hnisá he, tatah ka za ca tahpaw he khah ma cawtah hei a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Cai acawngpe cawh pa hmuh khaw bei he ceh, mataico cai cawngpe letah naa pa hmuh kaw a.” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A hningzuitu thaikhehpaw sahlo cawh pakheh le pakheh khah, “ ‘Cai acawngpe cawh pa hmuh khaw bei he ceh, mataico cai cawngpe letah naa pa hmuh kaw a,’ a tahpaw le, ‘Zecawtamaw tatah Paw kha ka sei a cawtah,’ a tahpaw heh zemaw a rei dupaw a cang?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Cai acawngpe letah a tahpaw heh zemaw a rei du? A reipaw heh kaa thuithai tlung be,” tatah aa tah leimei. ");
INSERT INTO zypNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zisu tah ma kong heh hae aa pa du takhah a hni. Macawtaco aa hai letah, “Cai acawngpe cawh pa hmuh khaw bei he ceh, mataico cai cawngpe letah naa pa hmuh kaw a ka tahpaw ka reidupaw khah maw pakheh le pakheh na hae leimei he ceh? ");
INSERT INTO zypNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Biahmuisui ka ca ching he, khazaw a lawng chung tahei co, naaning cawh caw le sang tah naa ung he ceh, naa lungsi a sá a. Canghrasala naa lungsisawnah cawh lunglawngnah tah a cang tae a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ny a chaipaw canu cawh taithuinah a ing, zecawtamaw tatah ny a chai cai a phah cawtah. Canghrasala ny a chua khy taico a sawtei khazaw letei a za pipaw lunglawngnah thong khei, a taithuinah khah a monghly thlu. ");
INSERT INTO zypNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ma hraco na cang hrá he ceh: Atoheh cawh naa lungsisawnah cai a cang, canghrasala ca hmuh kaw he neh ka, na lawng he ceh, taico na lawngnah pawhe ceh cawh ahotahmai ca chu khy a bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ma ning leco zehmai pa hae khawh bei ceh. Biahmuisui ka ca ching he, ka Paw tah ka ming tah naa haepaw maikaw khah a ca pae he a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ato tingtai lehei co ka ming tah zehmai hae bang bei he ceh. Hae la, hmuh a he ceh ka, na lawngnah pawhe ceh cawh a tling a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tawchingnah bia tah ka za rei tei naná teitah ma hapaw bia cawh ka hmang khawh ly nápaw cai khah a va chuh myca a, ma tih taco ka Paw kong cawh a se pawtah ka ca ching he a. ");
INSERT INTO zypNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ma ning leco ka ming tah naa hae a. Paw khah naa vypaw tah ka hae a ka tahnah cang be. ");
INSERT INTO zypNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Paw Khazing hrahring tahei a ca do he, zecawtamaw tatah pa do he ceh ka, Khazing taitah ka vongpaw khah naa zing cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kama cawh Paw taitah khazaw lehei a vongpaw ka cang. Atoheh cawh khazaw heh piasai neh ka, Paw kha ka sei kaw myca a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mataico a hningzuitu sahlo takhei Zisu hai letah, “Atoheh cawh tawchingnah hmang lytah a sepaw tah na rei myca hi. ");
INSERT INTO zypNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nama tah zezongpui khah hnih ceh ka, haecakhia leimei a hy khawh bei ceh tah cawh atoheh kaa hni myca, ma tahei Khazing taitah na vong tahpaw khah a ma zingsah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Atoheh cawh naa zing myca!” tatah Zisu tah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Canghrasala naa ing lang cacy papaipatlaw naa cang nápaw cai va chuh a ka, a va phah myca. Kama longtei tah naa pa hua si a. Canghrasala kama longtei cang bei neh, zecawtamaw tatah ka Paw cawh kama kha a ung cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kama letah thlawlungnah naa hnui khy nápawtah ma hming sahlo heh ka ca chingpaw he a cang. Ma khazaw lehei co, lung reithuinah naa hnui thlang a. Canghrasala, naa lung pacy my seh lo! Khazaw heh ka te thah hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zisu cawh ma bia a rei khy taico, avai lang a y ka, “Ka Paw, a cai a tling myca. Na Sawcapaw tahei ka ca parungnaw khy nápawtah na Sawcapaw heh parungnaw tua. ");
INSERT INTO zypNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Zecawtamaw tatah kama na pa pehpaw sahlo he khah chaizaw hringnah ka peh khy nápaw he tah ming vytei cung letah nawhnuinah khah na pa peh myca. ");
INSERT INTO zypNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma heh chaizaw hringnah cawh a cang, Khazing hmuisui pakheh, nama hni le nama tei na za tawpaw Zisu Khri hni heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ka tua ruapaw tei na pa pehpaw rai ka palingnah thong khei, aluicung letah na rungnawnah cawh ka langsah myca. ");
INSERT INTO zypNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taico ka Paw, khazaw pi hlai tei nama khatah ka za hnuipaw rungnawnah khakhei na hmekaw letah atoheh pa parungnaw tua. ");
INSERT INTO zypNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Khazaw taihei y he ceh katei, Kama na pa pehpaw sahlo he khakhei Nama cawh kaa ca palang thah. Aaning sahlo cawh na tei a cang he. Kama khah pa pei he ceh ka, na rei khah aa ca nge. ");
INSERT INTO zypNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kama na pa pehpaw hming maikaw heh Nama taiteipaw a cang he takhah atoheh cawh aa hni myca. ");
INSERT INTO zypNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Zecawtamaw tatah na pa pehpaw bia khah pei hrah he neh ka aa cyhlang. Nama taitah ka vong tahpaw khah a cang hrahring tah hnih he ka, na pa taw tahpaw khah aa zing. ");
INSERT INTO zypNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aaning aa cawtah hei thlaw ka chang. Khazaw cawtah chang bei neh, na pa pehpaw sahlo aa caw tutah ka changpaw a cang, zecawtamaw tatah aaning cawh na tei a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ka hnuipaw vytei heh na tei cang he ka, na hnuipaw vytei khah ka tei a cang he. Taico aaning sahlo thong hei, rungnawnah cawh ka hmuh myca. ");
INSERT INTO zypNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Khazaw lehei khua sy ung khaw bei neh, canghrasala aaning sahlo cawh aa ung thlang he a. Kama cawh Nama kha ka vong a. A pathaipaw Paw, Nama le Kama pungkheh kaa cangpaw hratah pungkheh aa cang khy hrah nápawtah na ming, na pa pehpaw ming, hmingtuakhyná khei aaning sahlo heh rungvai my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aaning kha ka ung chung tahei co na pa pehpaw ming khei rungvai he neh ka, a bing teitah ka chia he. Capathai a tling nápawtah a rorang ruapaw sawtei a cangpaw khah tah ly co ahohmai a lydepaw ung bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Atoheh cawh Nama kha ka vong myca a, canghrasala khazaw letah ka ung chung tei ma hming sahlo ka reipaw heh ka lawngnah reite lypaw khah aa chung letah aa hnui khy nápaw cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aaning sahlo cawh na bia khah ching thah he neh ka, khazaw tahei a hua he, zecawtamaw tatah khazaw leteipaw ka cang lypaw hratah khazaw leteipaw aa cang lynah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka thlawchangnah cawh aaning sahlo heh khazaw taihei law thlang he, tahpaw cang lytah mehchaw lypaw taitah vai my lo, tah tu heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kama heh khazaw tei ka cang lypaw hratah aaning sahlo heh khazaw tei cang hrah bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Biahmuisui khei aaning sahlo heh pathaisah my lo: Na bia cawh biahmuisui a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nama tah khazaw lehei na pa tawpaw hratah Kama tah aaning sahlo heh khazaw lehei ka taw hrá he. ");
INSERT INTO zypNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aaning zong hmuisui teitah pathaisah aa cang khy nápawtah aa cawtah Kama teitah ka pathai sahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ka thlawchangnah heh aaning sahlo aa caw duitei tah cang be. Aaning sahlo aa bia thong tei a pa zing lepaw sahlo aa caw zong tah ka chang, ");
INSERT INTO zypNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ka Paw, Nama cawh ka chung letah ung ceh ka, na chung letah ka ungpaw hratah aaning vytei pungkheh aa cang khy hrah nápaw cawtah a cang. Kama cawh Nama tah na pa taw tahpaw heh khazaw tah a zing khy nápaw cawtah le kaa chung letah aa ung khy hrah nápaw zong tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nama le Kama pungkheh kaa cangpaw hratah pungkheh aa cang khy hrah nápaw cawtah na pa pehpaw rungnawnah khah aaning cawh ka peh he. ");
INSERT INTO zypNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aaning aa chung letah ung neh ka, Kama ka chung letah na ung. Nama tah na pa taw tahpaw khah le na pa dopaw hratah aaning sahlo heh na do hrah he takhah khazaw hni sá pawtah aaning sahlo heh a tlangtlingpaw a pungkhehnah letah chuakhui khy hrah ruapaw he tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ka Paw, Nama tei na pa pehpaw sahlo he heh ka ungnah letah Kama kha ung hrah he seh la, ka rungnawnah Nama tei na pa pehpaw khah hmuh he seh tah ka du. Zecawtamaw tatah khazaw na papi hlai taitah Nama tah na pa dopaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","A dingpaw ka Paw, khazaw tah a ca hni ly tahmai Kama taco ca hnih thlang neh ka, Nama tah na pa taw tahpaw khah aaning sahlo taco aa hni thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ka caw tei na hnuipaw donah khah aa chung letah a ung khy nápawtah le kama hrahring tei aa chung letah ka ung khy nápaw tahei na kong khah hnisah he neh ka, ka hnisah vy leimei he a,” tatah thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Thlaw a changpaw a pachang taico, Zisu cawh a hningzuitu sahlo khatah piathlah he ka, Kidron saiho rae lang aa va sei. Ma langchang co, Oliv thingthi buichung ung ka, ma chunglang khah Ama le a hningzuitu sahlo cawh a nae he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma leco Zisu le a hningzuitu sahlo khah a tong pahmo tei caw he tah Ama a luitupaw Judas takhei ma hminghmaw cawh a hni. ");
INSERT INTO zypNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Macawtaco Judas cawh tlangbui macang sahlo le Farasi sahlo tah aa siapaw he raekeh phukheh le abui macang sahlo khah a va chui he ka, buichung lang cawh a vong he. Myrei le me-ing le hrainang sahlo a va tle he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A cung letah hming a tlung lepaw a hnih thlu thahpaw Zisu cawh piathlah ka, aaning sahlo khah, “Naa huipaw cawngsaw cawh ahomaw a cang?” tatah a va hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aaning sahlo taco, “Nazaret Zisu,” tatah aa palei. Zisu taco, “Ama cawh kama heh ka cang hi!” tatah a tah he. Taico aaning sahlo khaco a luitupaw Judas khah a daw thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zisu tah, “Ama cawh kama heh ka cang hi!” tatah a tah tihtah, aa hninglang a thai he ka, alui letah a pohly he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Zisu taco aaning sahlo cawh, “Naa huipaw cawngsaw cawh ahomaw a cang?” tatah a hae vy he. Taico aaning sahlo taco, “Nazaret Zisu,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zisu taco, “Ama cawh Kama heh ka cang hi, tatah ka ca tah thah he. Kama naa pa huipaw tei a cang caco, ma tlaw heh cawh sei sá o,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ma hratei hming a va ungpaw heh, “Na pa pehpaw he sahlo lekhei pakheh hmai hly bei neh,” tatah a za reipaw bia tlingnah cawtah khei a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mataico zyzi a kaipaw Simon Piter takhei zyzi cawh a phe ka, tlangbui alaicaipaw a saecapaw a cacang lang naw khah tuh ka, a pathai thlah. Ma saecapaw a ming cawh Malkhas a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Zisu taco Piter khah, “Na zyzi cawh a kawng lang sang kaw! Paw tah a pa pehpaw ny heh ding lytah maw ka ung a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mataico raekeh phukheh le raekeh hotu le Juda cawngsaw abui macang sahlo taco Zisu cawh tle he ka, tongchai he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ma kung letei tlangbui alaicaipaw Kaiafa a nupuino a paw Anas khakhei aa seikhui taw. ");
INSERT INTO zypNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafa cawh zawpui cawtah pakheh thih cawh a chah vy a, tatei Juda cawngsaw sahlo rawhnah a peitu he khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piter le ahringpaw a hningzuitu takhei Zisu cawh aa zuilai. Zecawtamaw tatah ma letei a hningzuitu heh tlangbui alaicaipaw kha a hnihpaw cang he ka, Zisu khaco tlangbui alaicaipaw a ingdung chunglang cawh a nae hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Canghrasala Piter tu cawh hawkaw khungthing lang lekhei a daw thlang. Tlangbui alaicaipaw khatah a hnih pawhe ahringpaw a hningzuitu cawh a vong kaw ka, ma letei hawkaw a heh no canuno khah ching ka, Piter khah a za naekhui. ");
INSERT INTO zypNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hawkaw a heh no canuno taco Piter cawh, “Ma cawngsawpaw a hningzuitu heh cang thlang hrah bei ceh maw?” tatah a hae. Piter taco, “Cang bei neh,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cakaw ngetei ka, sae sahlo le abui macang sahlo cawh ma lung naa seh tatah me khah a ai thlang he. Piter zong tah palung na seh tah ka, aaning sahlo khaco a daw thlang hrah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ma chung lekhei tlangbui alaicaipaw taco Zisu cawh a hningzuitu sahlo aa kong le a cawngpahnah kong khah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zisu taco, “Langhai tah pui khazaw kha ka rei thlang caw. Juda cawngsaw sahlo a pahmonahpaw he synagog a cang ly leh behnah ing letah ka cawngpah tei he. Aparuh teitah zehmai rei bang bei neh. ");
INSERT INTO zypNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Zecawtamaw kama cawh na pa hae? Ka bia a thuipaw sahlo khah va hae thlang o. Ka reipaw khah aa hni thlu thlang kho,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zisu tah, ma hrakhei a chai tihtah a kae letei a ungpaw abui macang pakheh takhei a hme letah a cabai. “Ma hrakhei tlangbui alaicaipaw chai phung a cang maw?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Zisu taco, “Ka reipaw ahmang ly caco, ahmang lynah cawh palang thlang. Canghrasala ahmangpaw ka rei caco, zecawtamaw na pa cabai?” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mataico, Anas taco tongchai hmo khei tlangbui alaicaipaw Kaiafa khatah a seisah khui he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Piter cawh a daw hmo tei me a ai ning takhei, “Ma cawngsawpaw a hningzuitu heh cang hrahring thlang bei ceh maw?” tatah aa hae. “Cang bei neh,” tatah a paphah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tlangbui alaicaipaw a sae sahlo letei pakheh, Piter tah a naw a pathai thlahpaw khatei sawny a cangpaw cawngsawpaw takhei, “Ama khatah pui Oliv thingthi buichung letah ka ca hmuh thlang kha!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piter taco a paphah vy ka, ma leco aa cawh a khawngpai. ");
INSERT INTO zypNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mataico, Juda cawngsaw sahlo takhei Zisu cawh Kaiafa a ing taikhei Rom cawngsaw uhtubui ing lang khah aa seikhui. Ma cawh mongdi tah cang ka, Juda cawngsaw sahlo cawh uhtubui ing lang khah a nae bei he. Phunglang hratah pathailynah khah cahri tah Khungsai Panawnah zairia khah e aa du cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Macawtaco Pilat khah ka pia ka, aaning sahlo cawh, “Ma cawngsawpaw heh ze suanah maw naa pu?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Ma cawngsawpaw heh suanah a tuapaw a cang ly caco, nama khatah kaa va chuakhui a maw?” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat taco, “Seikhui la, naa phungbia hrakhei naaning tah bia va pace thlang o,” tatah a tah he. Juda cawngsaw sahlo taco, “Kaaning cawh ahohmai thawkhynah naw kaa hnui bei ceh saw,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ma hming a va ungpaw heh a thih nápaw kong letah zekhatah phing tamaw a thih a tahpaw khah Zisu tei a za reipaw a tlingnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mataico Pilat cawh a ing chunglang a nae kaw ka, Zisu cawh ysah he ka, a hai letah, “Juda cawngsaw aa siangpahrang cawh na cang maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Zisu taco Pilat cawh, “Ma bia cawh nama na lungchua maw, a cang ly leh male tah ka kong aa ca chingpaw maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat taco, “Kama heh Juda cawngsaw a cang tatah na parawh maw? Kama khatah a va ca chuakhuipaw he heh na cawngsaw le nama na tlangbui macang sahlo a cang he hi. Zeky maw na tua?” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Zisu taco, “Kama ka painah raang cawh ma khazaw lehei cang be. Ma khazaw heh cang my seh la, Juda cawngsaw sahlo tah aa pa tle ly nápawtah ka raihretu sahlo tah aa dy thlang hrá he a. Canghrasala kama ka painah raang cawh ma khazaw raang lehei cang be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","A cang caco, “Siangpahrang na cang maw?” tatah Pilat taco a tah. Zisu taco, “Na reipaw cawh ahmang, siangpahrang ka cang. A ngetei tahpaw co, ma khazaw letei ka pinah chang le ka va chuanah chang cawh biahmuisui palang rua pawtah a cang. Biahmuisuipaw letei a ungpaw maikaw taco ka rei aa nge,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat taco, “Biahmuisui cawh zemaw?” tatah a hae. Taico Juda cawngsaw sahlo khaco pia kaw ka, “Kama cawh ma cawngsawpaw lehei ze suanah hmai hmuh bei neh. ");
INSERT INTO zypNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Canghrasala Khungsai Panawnah cai lehei thongtlah pakheh thlawpah heh naa phung cang ka, ‘Juda cawngsaw aa siangpahrang,’ heh ma thlawpah seh tah naa du maw?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aaning sahlo taco, “Ama cawh ma thlawpah kheh! Baraba khah ma thlawpah!” tatah aa yso. Baraba cawh damia a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mataico Pilat tah Zisu cawh tlesah he ka, a cheisah he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Raekeh sahlo takhei ahling lukhu khah phia he ka, a lu letah a khusah he. Pai saidungpaw khah a buhsah he ka, ");
INSERT INTO zypNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ato le ato tah a vawhno he ka, “Juda cawngsaw aa siangpahrang cawh a hringkhua sy ky seh,” tatah aa tah. Taico a hme letah aa cabai. ");
INSERT INTO zypNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat cawh ka pia kaw hui ka, Juda cawngsaw sahlo cawh, “Mingtua o, kama cawh a suanah konglang hmuh bei neh tah hnisah du tah ma cawngsawpaw heh kaa ka piakhuipaw a cang hi,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zisu cawh ahling lukhu kha, a pai saidungpaw kha, a ka pia tihtah Pilat taco aa hai letah, “Ma cawngsawpaw heh a cang hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tlangbui macang sahlo le abui macang sahlo takhei aa hmuh cangkawleh, “Khraws letah khaipai! Khraws letah khaipai!” tatah a y he. Canghrasala Pilat taco, “Naaning tah seikhui la, khaipai o. Kama cawh a suanah hmuh bei neh,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juda cawngsaw sahlo taco, “Phungbia hnui peh ka, kaa phungbia naning co ama cawh thih tlang a tlah, zecawtamaw tatah Khazing Sawcapaw ka cang a tah navai tah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ma bia cawh Pilat tah a thui tihtah a thlawzawng lo leimei ka, ");
INSERT INTO zypNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","abui ing chunglang cawh a nae kaw. Zisu cawh, “Zelang tamaw na va chua?” tatah a hae, canghrasala Zisu tah zehmai palei be. ");
INSERT INTO zypNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Bia pa chai du bei ceh maw? Nama thlaw khynah le khaipai khynah hmingtuakhynah ka hnuipaw heh hnih bei ceh maw?” tatah Pilat taco a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zisu taco, “Cung lang Khazing taitah peh na cang ly caco, ka cung letah hmingtuakhynah hnui bei ceh. Macawtaco, nama khatei a pa phah sahpaw cawngsaw heh alai vypaw suanah a tuapaw cawh a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mataico Pilat takhei Zisu lua sápaw khah a zawng, canghrasala Juda cawngsaw sahlo takhei, “Ma cawngsaw khah na thlaw caco, nama cawh Sizar a vesaw cang bei ceh. Siangpahrang ka cang a tahpaw maikaw cawh Sizar a caraepaw a cang he,” tatah a y tima he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ma cawh Pilat tah a thui tihtah Zisu cawh ka piakhui ka, alung dopaw siasang (Ma cawh Aramaik rei co, “Gabatha,” tatah aa tah) letei biacenah dyching lekhei a ty. ");
INSERT INTO zypNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma heh Khungsai Panawnah za, pachiapaningnah ning, ningching hrawng lekhei a cang. Pilat tah Juda cawngsaw sahlo hai letah, “Ma heh naa siangpahrang a cang hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Canghrasala, aaning sahlo taco, “Sei hly khui o! Seihly khui la, khraws letah khaipai thlang ky!” tatah aa y. Pilat taco, “Naa siangpahrang cawh ka khaipai thlang maw?” tatah a hae hri he. “Sizar tah ly co siangpahrang hnui bei peh,” tatah tlangbui macang sahlo tah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","A hning taco, Pilat tah khraws letah khaipai pawtah khei Zisu cawh aa kih letah a hlai he. Macawtaco raekeh sahlo takhei law he ka, aa seikhui. ");
INSERT INTO zypNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A khraws khah pulai ka, Luru hming (ma cawh Aramaik rei tah, “Galgotha,” tatah aa tah) lang khah a sei. ");
INSERT INTO zypNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma leco khaipai he ka, Ama khaco cawngsaw pahning, pakheh khah a rakheh lang, pakhehpaw khah a rakheh lang khei Zisu khah a le letah aa thlah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat takhei ca ciasah he ka, khraws lekhei a ta. Ma ca cawh, “NAZARET ZISU, JUDA CAWNGSAW AA SIANGPAHRANG A CANG,” tah heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Juda cawngsaw mehlupui tah ma ca cawh aa rei, zecawtamaw tatah Zisu aa khaipainah hminghmaw cawh khuapui khatah a ne ka, ca cawh Aramaik, Latin le Grik rei tah aa cianah cawtah khei. ");
INSERT INTO zypNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juda cawngsaw tlangbui macang sahlo taco, Pilat khah, “ ‘Juda cawngsaw aa Siangpahrang,’ tatah cia kheh ma cawngsawpaw tahei, ‘Juda cawngsaw aa Siangpahrang ka cang, a tah,’ tatah cia hri,” tatah aa va tah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat taco, “Ka cia cápaw cawh ka cia cápaw a cang thlang,” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Raekeh sahlo tah Zisu cawh aa khaipai tihtah a chaichi khah pahlu pah he ka, chykheh cy long ting rua pawtah khei chypali tah aa chy. A angki rai tu cawh chy bei he. Angki rai cawh a zung lypaw, a rong taitah a dong tai tawpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Raekeh sahlo taco pakheh le pakheh khah, “Ma heh cawh kychy bei he peh. Ahomaw a ting a tahpaw khah basung kaa phe thlang a,” aa tah. Ma hming a ungpaw heh Capathai tei: “Aaning sahlo taco ka angki khah a chaichy he ka, ka chaichi khah basung tah aa phe,” tahpaw a tling nápawtah khei a cang. Macawtaco raekeh sahlo tah ma heh aa tuapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Zisu a khraws kae leco a no, a no a unyno, Klopa a nupuino Mari le Mari Makdalin khah a daw thlang he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma letei a no a daw thlang katei, a dopaw a hningzuitu tah a kae letah a dawpai thlangpaw khah Zisu tah a hmuh tihtah a no hai leco, “Canuno, na sawcapaw kho,” tatah tah ka, ");
INSERT INTO zypNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","a hningzuitu cawh, “Na no kho,” tatah a tah. Ma khy taco a hningzuitu taco ma cawngsawno cawh a ing lang a chui. ");
INSERT INTO zypNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma khy taico atoheh zezong a tling thlu myca takhah hnih ka, Capathai a tling nápawtah khei, “Ka tui a hrae,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma leco misur zu a thobahlapaw beirai sangkheh a ung. Ma chunglang cawh span khah nong he ka, rahtlong letah tongpai he ka, calia he ka, Zisu a hmo leco aa hne. ");
INSERT INTO zypNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zisu tah misurhang a thobahlapaw cawh a pazo khy taitah, “A tling myca,” tatah a tah khy taitah a lu cawh alui lang a khuh ka, a thi. ");
INSERT INTO zypNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma heh Pachiapaningnah Ning tah cang ka, a ningthlamong cawh Panawnah Sabat ning a cang. Macawtaco Juda cawngsaw sahlo taco Sabat ning tei khraws letah rawh sahlo a pathle thlangpaw khah aa dulynah cawtah aa phe va thlia tah aa rawh lahthlá pawtah khei Pilat khah aa hae. ");
INSERT INTO zypNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Macawtaco raekeh sahlo khah a vaw he ka, Zisu khatei aa khaipai hruipaw he letei pakhehpaw a phe khah thleh he ka, mataico ahringpaw pakhehpaw a phe khah aa thlia vy. ");
INSERT INTO zypNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Canghrasala Zisu kha a vaw tih he tah a thih thahpaw khah hmuh he ka, a phe khah thleh bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Raekeh chung taikhei pakhehpaw tah Zisu a kang lekhei khawsui tah dong ka, thi le tui cawh a ka pia palang he. ");
INSERT INTO zypNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma a hmuhpaw cawngsawpaw taco rei ka, a reipaw cawh biahmuisui a cang. Biahmuisui ka rei takhah hnih ka, a reipaw cawh naaning sahlo zong tah naa zing khy hrah nápaw cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma hming sahlo a va ungpaw heh, “Ama a ru cawh rukheh hmai thlia cang be,” tahpaw Capathai bia le, ");
INSERT INTO zypNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ahringpaw Capathai letei, “Aaning tei aa dongpaw cawngsawpaw khah aa ming a,” tahpaw bia a tlingnápaw cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma khy taico Arimathea khuapaw Josef takhei Zisu rawh cawh Pilat khah a hae. Josef cawh Zisu a hningzuitu pakheh a cang hrah, canghrasala aparuh teitah a cang. Zecawtamaw tatah Juda cawngsaw sahlo khah a ci he. Pilat nawtlah khui ná khei Josef cawh a vaw ka, Zisu rawh cawh a va lah. ");
INSERT INTO zypNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Josef khaco, khahlai tei zai tah Zisu a va vepaw cawngsawpaw Nikodema khah a sei hrah. Nikodema tah ny zakheh le songngaw hrong a rihpaw ringthopaw, mura le aloi pahlawhpaw khah a tle lai. ");
INSERT INTO zypNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ma tlaw pahning taco Zisu rawh cawh law he ka, ringthopaw khakhei paithladih anaipaw tah aa pahlong. Ma heh Juda cawngsaw sahlo a phungnah he aa phunglang a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Zisu aa khaipainah hminghmaw leco, buichung ung ka, ma buichung leco ahohmai a phung naw bang lynah pawhe athlai thapaw sangkheh a ung. ");
INSERT INTO zypNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma ning heh Juda cawngsaw sahlo tah Sabat cawtah pachianah ning a cang hlui tah athlai zong cawh a ne caw takhei, ma leco Zisu cawh aa phungpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Zaa kheh letei ning hmetaw caipaw mongdi khuahme a se hlai takhei, Mari Makdalin cawh thlai lang khah va sei ka, thlaikaw taitah alung a hneihly thahpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Macawtaco Simon Piter le Zisu tei a dopaw ahringpaw a hningzuitu khakhei va sai tlamang ka, “Thlai taikhei Abuipaw khah law he ka, zeletamaw aa chia tahpaw hnih bei neh!” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Macawtaco Piter le ahringpaw a hningzuitu cawh thlai lang khah aa sei. ");
INSERT INTO zypNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aa pahning co sai he ka, canghrasala ahringpaw a hningzuitu takhei Piter cawh cakhai ka, thlai cawh a va phah taw. ");
INSERT INTO zypNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A bung ka, a chunglang cawh va ming ka, ma letei a lia thlangpaw paithladih khah a va hmuh, canghrasala a chunglang cawh a va nae be. ");
INSERT INTO zypNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mataico a hning khapaw Simon Piter khah va phah ka, thlai chunglang cawh a nae. Ma letei a lia thlangpaw paithladih khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Zisu a lu aa pahlongnahpaw paithladih zong khah a hmuh pai. Ma pai cawh a tongkaling ka, paithladih taikhei a macang tah a ung. ");
INSERT INTO zypNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","A hning taco, thlai a va phah tawpaw ahringpaw a hningzuitu zong cawh a chunglang a nae hrah ka, hmuh ka, a zing. ");
INSERT INTO zypNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Zisu cawh thihnah taitah a tho kaw a tahpaw Capathai bia khah thuithai ting bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mataico a hningzuitu sahlo cawh ing lang khah a dih kaw he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Canghrasala, Mari cawh thlai alailang khei a daw thlang ka, a cah leimei. A caw hmo khei a bung ka, thlai chunglang khah za ming ka, ");
INSERT INTO zypNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","pai rang a buhpaw vaiming pahning cawh Zisu rawh aa isahnah lekhei pakheh a lu lang, pakheh a phe lang a ty thlangpaw he khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aaning taco ama cawh, “Cawngsawno, zecawtamaw na caw leimei?” tatah aa hae. Mari taco, “Ka Buipaw a rawh law he ka, zeletamaw aa chia tahpaw hnih bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ma hratei a tah khy taico a paleh ka, Zisu a daw thlangpaw khah a hmuh, canghrasala Zisu a cang tahpaw hnih be. ");
INSERT INTO zypNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma cawngsawpaw taco, “Cawngsawno, zecawtamaw na caw leimei? Na huilaipaw cawngsaw cawh ahomaw a cang?” tatah a tah. Mari taco ama cawh buichung a hnuitupaw a cang rua tah ka, “Ka pu, nama tah na lah caco, zeletamaw na chia tahpaw pa ching theh ky, va law kaw ná neh seh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zisu taco ma cawngsawno cawh, “Mari,” tatah a tah. Ama lang cawh a paleh ka, Aramaik rei tah, “Raboni,” (ma a silang cawh cawngpahtu tahnah a cang) tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zisu taco cawngsawno cawh, “Patle thlang kheh, zecawtamaw tatah Paw khatah kechy balang bei neh; canghrasala ka uny sahlo khatah va sei la, ‘Ka Paw le naa Paw, ka Khazing le naa Khazing khatah ka kechy myca a, a tah,’ tatah va ching hri o,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari Makdalin cawh a hningzuitu sahlo khaco va sei ka, “Abuipaw ka hmuh! Ma sahlo heh a pa ching,” tatah thongpang a va thuisah he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Zaa kheh letei ning hmetaw caipaw a cangpaw, ma ning zailang letei Juda cawngsaw sahlo ci tah ingkaw hraí tei a hningzuitu sahlo a pahmoning he takhei, Zisu cawh a vong ka, aa hrong leco a daw ka, “Naaning khatah thlawlungnah ung ky seh!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma bia a rei khy taikhei a kih le a kang khah a hmuhsah he. Abuipaw cawh aa hmuh tihtah a hningzuitu sahlo cawh a lawng ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zisu taco, “Naaning khatah thlawlungnah ung ky seh! Paw tah a pa tawpaw hratah kama tah ka ca taw hrah he,” tatah a tah vy he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Taico ma bia a rei khy taikhei a hu suaso he ka, “Thlawpaw Pathai hnui o. ");
INSERT INTO zypNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ahohmai aa suanah sahlo khah naa ngethai caco he, ngethai a cang thlang he a. Naa ngethai ly caco he, ngethai cang bei he,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hluihning letah pakheh a cang hrahpaw Thomas (Didama aa tahpaw) cawh Zisu a vongning takhei a hningzuitu sahlo khatah ung be. ");
INSERT INTO zypNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ahringpaw a hningzuitu sahlo takhei Abuipaw kaa hmuh tatah aa ching tihtah Thomas taco, “A kih letei thawkhainah hmaw ka hmuh ly leh ka kihdong tah ka hre ly le a kaang hmaw ka po ly caco, naa reipaw cawh zing bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Zaakheh khy takhei, a hningzuitu sahlo cawh ing letah a pahmo kaw hui he ka, aaning sahlo khaco Thomas cawh a ung hrah. Ingkha aa hrai thlang naná teitah Zisu cawh a za nae ka, aa hrong leco a daw ka, “Naaning khatah thlawlungnah ung ky seh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Zisu tah Thomas cawh, “Ka kih heh ming la, va hre tua. Na kih cawh chua la, ka kaang heh va po tua. Lung langlo tah ung kheh, zing myca,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas taco a hai letah, “Ka Buipaw le ka Khazing!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mataico Zisu taco Thomas cawh, “Nama cawh na pa hmuh cawtah na pa zing; pa hmuh ly tei a pa zingpaw sahlo cawh bonghnang song a cang he a,” tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zisu tah a hningzuitu sahlo hme letah paching pakhanah a hlupui tua ka, ma cabu lehei cia lypaw ningang chuipaw paching pakhanah a hlupui a ung. ");
INSERT INTO zypNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Canghrasala Zisu cawh Khri, Khazing Sawcapaw a cang tah naa zing tei, ma zingnah thong co a ming letah hringnah naa hnui khy nápawtah ma sahlo heh cia a cang he. ");
INSERT INTO zypNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma khy taico Zisu cawh Tiberia rili kae lekhei a hningzuitu sahlo khatah a paly vy. A palynah ningcang cawh ma hrahei a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Piter, Thomas (Didama aa tahpaw), Galili raang Kana khuapaw Nathaniel, Zebedi a sawcapaw leh le ahringpaw hningzuitu pahning sahlo cawh hmokheh letah a ung he. ");
INSERT INTO zypNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piter takhei, “Ngaw tle tah ka sei a,” tatah tah he ka, aaning sahlo taco, “Nama kha ka sei hra peh,” tatah aa tah. Macawtaco tuilawng cawh ke he ka, aa sei, canghrasala ma zai cawh ngaw sangkheh hmai tle bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mongdi taco Zisu cawh ngaekang lekhei a daw thlang, canghrasala a hningzuitu sahlo taco ma kheh Zisu a cang tahpaw bi bei he. ");
INSERT INTO zypNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Zisu taco, “Vesaw sahlo, ngaw naa tle bang maw?” tatah a tah he. Aaning sahlo taco, “Tle bang bei peh,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Zisu taco, “Naa so khah lawng a cacang langchang lekhei va la, naa tle thlang a,” a tah he. Aa va tihtah aa so khah hrui khy bei he, zecawtamaw tatah ngaw a hlupui a o cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mataico Zisu tei a dopaw a hningzuitu takhei Piter cawh, “Abuipaw a cang!” tatah a tah. “Abuipaw a cang,” a tahpaw khah Simon Piter taco a thui cangkawleh a pai khah a pazai (a pai khah a za hlehly thah) ka, tui chunglang cawh a zythlah. ");
INSERT INTO zypNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ahringpaw a hningzuitu sahlo taco tuilawng khei aa zui. Ngaw a chih thlangpaw aso khah aa hrui pai lai, zecawtamaw tatah aa ungnah cawh ngaekang taikhei a hlah be, pei zathung hrawng longlong a hlah. ");
INSERT INTO zypNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ngaekang cawh aa phah tihtah me tua he katei, ngaw pakang thlangpaw le, very a cawngpe khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Zisu taco aa hai letah, “Ngaw naa tlepaw khah a cawngpe tah va tle bang tua o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piter cawh tuilawng cung lang ke ka, aso khah ngaekang lang a hrui. Ngaw alaipaw (153) a awh, canghrasala, ngaw ma tluá co a hlu thlang naná teitah aso cawh a hriachy be. ");
INSERT INTO zypNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zisu taco aa hai letah, “A vong la, batui va e o,” a tah he. A hningzuitu ahotahmai tah, “Ahomaw na cang?” tatah hae ngang bei he. Abuipaw a cang takhah aa hni thlang. ");
INSERT INTO zypNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zisu cawh a vong ka, very cawh law ka, aaning sahlo cawh pei he ka, ma hraco ngaw zong khah a peh hrah he. ");
INSERT INTO zypNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ma heh thihnah taitah a tho kaw khy taitah a hningzuitu sahlo khatah Zisu a uithungnah a palynah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Batui aa e khy taico Zisu tah Simon Piter cawh, “Johan a sawcapaw Simon, ma sahlo navy hei na pa do vy hmuisui maw?” tatah a tah. Simon taco, “A cang, Abuipaw, ka ca dopaw cawh na hni,” tatah a tah. Zisu taco, “Ka tuu teitei sahlo khah aa lawh pei my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zisu taco, “Johan a sawcapaw Simon, Na pa do hmuisui maw?” tatah a tah. Simon taco, “A cang, Abuipaw, ka ca dopaw cawh na hni,” tatah a chai. Zisu taco, “Ka tuu sahlo khah mingkai my lo,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A uithungnah leco, “Johan a sawcapaw Simon, na pa do maw?” tatah a tah. Piter cawh Zisu tah uithung tai, “Na pa do maw?” tatah a haenah cawtah khei a lung a sah ka, “Abuipaw, nama tah zezong vytei na hni; ka ca dopaw zong na hni,” tatah a tah. Zisu taco, “Ka tuu sahlo khah lawh pei my lo. ");
INSERT INTO zypNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Biahmuisui ka ca ching, na nyheh ning taco nama teitah caise a tua ceh ka, na dunah lang khah na sei. Canghrasala na macang tih taco, na kih pazylai a ceh ka, ming hringpaw tah chaichi a ca tua sá he ka, na sei dulynah lang khah aa ca hrui lai a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zisu tah ma bia a reipaw heh Piter cawh ze hra tamaw thi a ka, Khazing khah a rungnaw sá a, takhah a rei hnohnangpaw a cang. Mataico a hai letah, “Va pazui!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piter cawh a paleh ka, Zisu tei a dopaw a hningzuitu tei a va zuilaipaw he khah a hmuh. Ma cawngsawpaw heh zaibatui aa ening tei Zisu khah a va hnia ka, “Abuipaw, ahomaw nama cawh a ca lui a?” tatei a haepaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ma cawngsawpaw cawh Piter tah a hmuh tihtah, “Abuipaw, ma cawngsawpaw kheh zekhatamaw a cang a?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Zisu taco, “Ka vongkawnah tai za hring thlang seh tah du my neh seh la, nama na cawtah apuinah a ung maw? Va pazui thlang leh hi,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ma rawng tahei, ma a hningzuitu heh thi a be, a tah tahpaw a vevungpaw bia cawh a hningzuitu sahlo hrong lekhei a thang. Canghrasala Zisu taco ama cawh thi a be, tah be, “Ka vongkawnah tai za hring thlang seh tah du neh seh la, nama a ca pakhangnah a ung maw?” tah suitei a reipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ma a hningzuitu heh ma hming sahlo heh reilai katei, a ciatupaw heh a cang. Ama a reipaw cawh ahmang tah kaa hni. ");
INSERT INTO zypNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zisu tah ahringpaw hming hlupui zong a tua. Ma vytei cawh cia thlupaw cang my he seh la, cianápaw cabu cawh khazaw lehei a tlung a be, tatah ka rawh.");
INSERT INTO zypNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theofila, ka cabu hmetawpaw letei Zisu tei rai hre le cawngpah a pathonahpaw vytei kong taikhei, ");
INSERT INTO zypNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ama tah a thingpaw apostol sahlo letah Thlawpaw Pathai thongtah chingreinah bia a rei khy taitei vaicung lang lahchy a cangnah taikhah ka cia. ");
INSERT INTO zypNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A taithui khy taitah hningzuitu sahlo hai leco, thihnah taitah a tho kaw tahpaw khah aa hni khy nápawtah uihlupui aaning khatah a paly. Aaning sahlo khahei ning songli chung a paly ka, Khazing painah raang kong khah a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Uikhehpaw cawh aaning khatah batui a e leimeining tah, aaning sahlo cawh ma bia heh a peh he. “Jerusalem khuapui heh piasai khe lo, canghrasala ka Paw tei bia a ca kangpaw he lahsong kong, naa hai letei ka reipaw naa thuipaw khah heh thlang my lo. ");
INSERT INTO zypNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Johan taco tui tah baptisma ca cangsah he ka, canghrasala khua sy ry lytah Thlawpaw Pathai tah baptisma cangsah na cang he ceh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mataico, a pahmo pakhong ning he tah Zisu cawh bia aa hae. “Abuipaw, ato cai lehei Israel painah raang cawh na padaw hry kaw maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aa hai letaco, “Paw tei Ama a nawhnuiná tah a thliapaw a cai le a ning cawh naaning naa hni a hia be. ");
INSERT INTO zypNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Canghrasala, Thlawpaw Pathai naa cung letah a va tlung tih taco hmingtuakhynah hnui he ceh ka, Jerusalem letah le Judia raang vytei letah le Samaria raang letah le, aluicung a cakih a cahnawh tai letah kama a pa hnikhuitu na cang he ceh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma bia heh a rei khy taitah aa ming thlang chung tah vaicung lang lah chy cang ka, mehding tah bakhu ka hmuh khawh bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma hratei a seipaw khah avai lang a y tei aa cai thlangning taco, pai rang a buh paw cawngsaw pahning aa kae letah sung sungkheh tah a va daw he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Taico aaning taco, “Galili cawngsaw sahlo, zecawtamaw a daw he ceh ka, avai lang na y thlang he ceh? Naaning taitah avai lang lahchy tei a ungpaw, ma Zisu ceingei heh avai lang a seipaw naa hmuh pawtei hrahei a vong kaw a,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mataico Oliv tlaang aa tahpaw tlangby taico Jerusalem khuapui lang cawh aa kaw kaw. Ma tlangby cawh khuapui taitah Sabat ning tei sei khynah naw a cangpaw khang chy hrawng a hlahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aa va tlung kaw taico aa ungnah ing a cung khang lang cawh aa ke. Ma letei a ungpaw sahlo cawh Piter, Johan, Jeims le Andru, Filip le Thomas, Barthalomeo le Mathai, Alfas a sawcapaw Jeims le ci le phing a dawkhuipaw Simon le Jeims a sawtei Judas a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aaning vytei cawh canu sahlo le Zisu a no Mari le Zisu a uny sahlo khatah ato le ato a pahmo tei he ka thlaw aa chang tei. ");
INSERT INTO zypNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma ningcai letaco a zingtu sahlo hrong letah Piter cawh a ka daw ka, (ma letei a ungpaw he mehnung cawh 120 hrong a cang he), ");
INSERT INTO zypNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ma hrahei a tah he, “Uny sahlo, Capathai letah David hmokaw hmang tah Thlawpaw Pathai tah Zisu a tlepaw sahlo he hmechuitu Judas kong a za reihlangpaw vytei khah a tling ruapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ma cawngsaw cawh kaaning khatah reipai pawtah ung ka, ma rai kaa hrenah kong lehei zong rai hre hui a cang hrah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(A suanah mai a hmuhpaw tah alui co ka, a bawhtakhuh ning tah tlah ka, a le letah a taichung ka, a ri vytei a chuhly thlu. ");
INSERT INTO zypNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem khuapui letei a ungpaw vytei tah ma kong heh aa thui thlu. Mataico ma alui cawh aaning aa rei tah, “Akeldama,” aa tah. Ma cawh, “Thisai alui,” tahnah a cang.) ");
INSERT INTO zypNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piter tah a rei vypaw cawh, “Ma rawng tahei Reithainah Hlaw cabu letah ma hrahei cia a cang hi, ‘A ungnah hminghmaw cawh ching seh la, a chung letah ahohmai cinglai kheh he seh,’ tahpaw le, ‘Hruitu a cangnah cawh ahringpaw tah ting he seh,’ tatah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Macawtaco Judas zaka lehei cawngsaw pakheh thing a hy a. Ama cawh Abuipaw Zisu kaaning kha a ung chung vytei letei kaaning kha a ung tei hrahpaw, ");
INSERT INTO zypNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","baptisma peitu Johan raihre a pathonah taitah Abuipaw Zisu lahchy a cangnah tai a hnih hrahpaw cang seh. Ma cawngsaw cawh kaaning khatah a thokawnah kong a hnikhuitu pakheh a cang hrá a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Macawtaco cawngsaw pahning khah thing he ka, pakhehpaw cawh Barsaba, aa tahpaw Josef, (Justa tah zong tah aa tahpaw) khah cang ka, pakhehpaw cawh Mathia a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Mataico, “Abuipaw, nama, cawngsaw vytei lungthing a hnihpaw, Judas tah za hre katei ama a tingvy a cangpaw lang sei pawtah a seisaipaw apostol rai a hre ruapaw tah ma tlaw pahning lehei ahomaw na thingpaw a cang tahpaw ma hnisah tua,” tatah thlaw aa chang. ");
INSERT INTO zypNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mataico basung phe he ka, Mathia cung letah tluh ka, macawtaco apostol hluikheh leco chahchi a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos Panawnah ning a va phah tih taco, zingtu vytei cawh hmingkheh letah hmokheh teitah a pahmo he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sung sungkheh tah thli pui a hrangpaw hrakhei a pyraw cawh avai lang khei za ring ka, a tythlangnah pawhe ing cawh a chih thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mataico lui khatah alopaw me khah hmuh he ka, a chaichy patlaw ka, aa cung cacy lekhei a za cawng. ");
INSERT INTO zypNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aa zongmingtei co Thlawpaw Pathai khei chih he ka, Thlawpaw tei a rei sahpaw he hrakhei rei hringpaw tah aa rei aa thlaw. ");
INSERT INTO zypNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ma ningcai cawh raangting letei Khazing a cizawpaw Juda cawngsaw sahlo Jerusalem letah aa ungning cai khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma pyraw cawh aa thui tihtah cawngsaw rungpui cawh va chuh he ka, zingtu sahlo tei aa cuipaw rei khah aaning leh aa rei cacy khei aa thui tihtah a pacang nápaw hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Aa ningang ngetei ka, “Ma aa rei a thlaw leimeipaw sahlo vytei heh Galili cawngsaw cang bei he maw? ");
INSERT INTO zypNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma sahlo tei aa reipaw bia heh zekhatah zia tamaw kaaning leh kaa rei cacy tah kaa thui zia? ");
INSERT INTO zypNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kaaning sahlo heh Parthia raang, Media raang, Elam raang le thaikhehpaw sahlo heh Mesopotamia raang letah a ungpaw le Judia raang le Kapadosia raang, Pontas raang le Asia raang, ");
INSERT INTO zypNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frizia raang le Pamfilia raang, Izipt raang le Sairin khua kae Libia raang chung sahlo taiteipaw le Rom khua taitei khua a va tlongpaw ");
INSERT INTO zypNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Juda cawngsaw sahlo le Juda behnah lang a palehpaw Juda mingphing a cang lypaw sahlo) le Krit tuiraw cawngsaw sahlo le Arabia raang taitei a va chuhpaw sahlo ka cang he peh. Ma sahlo tahei Khazing tei hming rungnawpaw a tuapaw aa phychuapaw heh kaaning kaa rei cacy hratah kaa thui thlang dei e!” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aa ningang ka, a rawhnah hnih bei he. Pakheh le pakheh cawh, “Ma heh zemaw a silang a cang?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Canghrasala thaikhehpaw taco aaning sahlo cawh pasipasa he ka, “Zu aa rui khi,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Macawtaco Piter cawh apostol hluikheh sahlo khakhei a ka daw ka, zawpuipaw cawh o thangpui tah bia ching he ka, “Ka mingphing hui a cangpaw Juda cawngsaw sahlo le Jerusalem letei a ungpaw cawngsaw vytei sahlo, ma kong heh ka ca chingpase tua he a, ka reipaw heh achaw teitah nawthlia tua o. ");
INSERT INTO zypNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Naa pacangpaw hratah ma cawngsaw sahlo heh zu rui bei he. Atoheh mong suimehlang pakua suipui a cangning kata caw! ");
INSERT INTO zypNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Khazing khuavang Joel tei a za reihlangpaw khah a cang hri hi, ");
INSERT INTO zypNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Caichangnah letaco, Khazing tah ming vytei cung letah ka Thlawpaw ka luithlang a. Naa sawcapaw sahlo le naa sawcanu sahlo tah bia phy he ka, naa mehny sahlo tah apalynah aa hmuh a, naa mehtaa sahlo tah mang aa sá a. ");
INSERT INTO zypNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma ning leco ka saecanu le ka saecapaw sahlo cung letah zong Ka Thlawpaw cawh luithlang neh ka, aaning sahlo taco bia aa phy a. ");
INSERT INTO zypNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cung lang avai letah khuarawha a chuipaw hming chuasá neh ka, a rai lang alui lehei paching pakhanah ka tua a, thisai le me le mekhu ka chuasá a. ");
INSERT INTO zypNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Abuipaw rungnawnah le laisuinah ning a phah hlai taco ning cawh a muisah a, thlawpaw cawh thisai hratah a tua a. ");
INSERT INTO zypNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Taico Abuipaw ming a ypaw cawngsaw maikaw cawh pachah a cang he a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel cawngsaw sahlo, ma bia he nawthlia tua o, Nazaret Zisu cawh Khazing tah Ama a thongtah naa hrong letah a tuapaw ningang chuipaw, khuarawha a chuipaw le paching pakhanah khatah a za taw caimangpaw a cang tahpaw cawh naaning ceingei heh a hnihpaw na cang he ceh. ");
INSERT INTO zypNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Khazing tei a pachiapaw le a hnihlang ciapaw hratah ma cawngsaw heh naa kih cung letah peh cang ka, naaning tah mehchawly sahlo bawkhangnah thongtah khraws letah khaipai he ceh ka, naa thaw. ");
INSERT INTO zypNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Canghrasala Khazing taco Ama cawh thihnah taitah patho ka, thihnah tai-ingnah taikhei a thochua, zecawtamaw tatah Ama cawh thihnah tei a tle pakhih khy lypaw a cangnah cawtah. ");
INSERT INTO zypNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ama a kong letah David tei a reipaw cawh, ‘Ka hme letah Abuipaw cawh ka hmuh paria tei. Kama cawh ka thlawzawng be, zecawtamaw tatah Ama cawh ka cacang lang letah a ung cawtah. ");
INSERT INTO zypNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Macawtaco ka lungthing cawh a thaw chah ka, ka hmokaw zong a lawng ngetei ka, ka pungsaw zong heh hnabeisuinah chitah a hring a, ");
INSERT INTO zypNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Zecawtamaw tatah thlaikho leco pa seisai thlang be ca ceh ka, na Mehpathai cawh a thuh a mang thlangpaw zong sai hrah bei ceh. ");
INSERT INTO zypNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hringnah langpui sahlo cawh pa hnisah myca ceh ka, na hmekaw letah alawngnah khatah na pa chisah myca a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Uny sahlo, kaa mapaw David cawh thi ka, phung he ka, a thlai zong atoning tai ma lehei a ung thlang tahpaw heh raechah teitah ka ca ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Canghrasala David cawh Khazing khuavang pakheh cang ka, ama a pathlah taitah pakheh cawh ama hratah siangpahrang a cang tae a tatah Khazing tah chia a sah hmotah bia a kang tahpaw khah a hni. ");
INSERT INTO zypNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hmelang cai letei a cang lepaw khah a hmuh hlang cawtah Khri a tho kaw nápaw kong letah a reipaw cawh, ama cawh thlaikho letah seisai cang be, a pung zong thu hrá be a tahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ma Zisu cawh Khazing tah hringnah letah patho kaw ka, ma kong cawh kaaning vytei heh a hnihtu ka cang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Zisu cawh Khazing cacang lang letah cuicaling tah ung ka, biakang ciapaw Thlawpaw Pathai khah Paw taitah hmuh myca ka, ato letei naa hmuhpaw le naa thuipaw heh a za luithlangpaw cawh a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","David cawh avai lang kae tlung be, a cang naná tah ma hrahei a rei, ‘Abuipaw tah ka Buipaw cawh na carae sahlo khah na pherai letah ka chia hlai vytei he cawh, ka cacang lang letah a ty thlang, a tah,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Macawtaco Israel cawngsaw vytei sahlo hnih pase my lo. Ma Zisu, naaning tei naa khaipaipaw khah Khazing tah Abuipaw le Khri tah a tuapaw cawh a cang hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma bia cawh aa thui tihtah aa lung khah khui ngetei he ka, Piter le ahringpaw apostol sahlo hai leco, “Uny sahlo, zemaw kaa tua a?” tatah aa hae he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piter taco, “Naa dawngkasawny tah a ngepachih la, Zisu Khri ming tah baptisma cang o, ma pawsui co naa suanah vytei cawh ngethai a cang a. Taico Thlawpaw Pathai lahsong khah naa hmuh a. ");
INSERT INTO zypNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ma biakang cawh naaning le naa sawtei sahlo le langhlaw pui letah a ungpaw vytei, Abuipaw kaa Khazing tei a y lepaw vytei he cawtah a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A raeringnah bia khah a hlupui ching he ka, “Atochai mehnung sahlo aa chahlynah taihei naaning teitah a vai my lo,” tatah a pasy he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A reipaw bia a cyhlangpaw sahlo cawh baptisma cang he ka, ma ning leco mehnung 3000 hrawng a chahchi he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aaning cawh apostol sahlo cawngpahnah khah nge he ka, a huikongnah lekhei a pei he ka, very khah e hrui he ka, thlaw aa chang hrui tei. ");
INSERT INTO zypNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aa zongmingtei co, Khazing cizaw ngetei cy he ka, apostol sahlo taco khuarawha hming hlupui le, ningang chuipaw paching pakhanah hlupui khah aa tua. ");
INSERT INTO zypNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A zingtu vytei cawh hmokheh tah ung he ka, hming maikaw khah a hrong he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Aa hnuichia le aa hmingbo khah zua he ka, aa hrong letei a hnui lypaw khah aa peh he. ");
INSERT INTO zypNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","A ning tating teitah behnah ingdung chung leco a pahmo tei he. Aa ing letah Abuipaw zairia tua he ka, a tlechai hmo khei a nawng teitah hmingkheh tah aa e hrui tei. ");
INSERT INTO zypNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Khazing reithai he ka, ming vytei tah aa dukhui ngetei he. Taico Abuipaw tah pachah a cang leimeipaw sahlo he cawh aaning khatah ning tating tah a chahchi leimei thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ningkheh cawh Piter le Johan cawh behnah ing letah thlawchang pawtah thlawchang cai zailang suimehlang pathung leco aa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A no chungpi tah lang a sei khy lypaw, a phesongpaw pakheh khah behnah ing hawkaw, “A ngepaw,” aa tahpaw leco a va song he ka, aa chia. Behnah ingdung chunglang a seipaw sahlo letah kih do na he seh tatah ma leco ning tating tah aa chiapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Piter le Johan khah behnah ingdung chunglang a va naepaw he cawh hmuh ka, aaning cawh tangka a hae he. ");
INSERT INTO zypNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piter tah ma cawngsawpaw cawh taa ky tah mingchai ka, Johan zong tah a mingchai hrah. Taico Piter taco, “Ma mingtua,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ma cawngsawpaw taco sangkheh kheh pui aa pa pae kata tahpaw rawhnah hnui ka, a hnabei a sui. ");
INSERT INTO zypNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mataico Piter taco, “Sui le ngung hnui bei neh, canghrasala ka hnuitlakangpaw tei ka ca peh. Nazaret Zisu Khri ming tah tho la sei,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","A cacang lang kiá tah tlechui ka, a patho. Taico sung sungkheh tah a phe le a phelaby thaw cawh a ka tlung palang. ");
INSERT INTO zypNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A pathlo ka, lang a sei pai. Taico, Khazing reithainah cung tah seipai lai a pathlo pai lai ka, behnah ingdung chunglang cawh Piter le Johan khatah a nae hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A seipai tei Khazing a reithai laipaw khah cawngsaw vytei tah aa hmuh tihtah, ");
INSERT INTO zypNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ma cawngsaw heh behnah ing, “Hawkaw a ngepaw,” aa tahpaw letei a kih a do teipaw khah a cang tahpaw aa hni. A cung letah zehming maw a tlung siama tu, tah he ka, aa ningang ka, aa khuarawh a haa cehceh. ");
INSERT INTO zypNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A phesongpaw tah Piter le Johan cawh a kiá tah a bang thlangning he takhei, cawngsaw vytei cawh aa khuarawha ngetei ka, aaning lang, Solomon dungkalung aa tahpaw lang khah a va sai he. ");
INSERT INTO zypNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piter tah ma cawh a hmuh tihtah aa hai letah, “Israel cawngsaw sahlo, zecawtamaw naa khuarawh a haa? Kaaning kaa hmingtuakhynah le Khazing lung aa tongnah cawtah ma cawngsaw kheh lang aa seisah khi tahpaw phing hratah zecawtamaw naa ningang raruá tah naa ma ming thlang! ");
INSERT INTO zypNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isak le Jakob aa Khazing, kaa mapaw sahlo aa Khazing tah a sae Zisu cawh a rungnaw sahpaw a cang hi. Ama cawh thaw rua pawtah pei he ceh ka, Pilat tah chuasah a du tahmai tah a hme letah naaning tah naa hlawh kho. ");
INSERT INTO zypNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mehpathai le Mehding a cangpaw khah hlawh he ceh ka, mehsua lenongpaw khah, ma chuapah hri law naa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hringnah hrangpui khah theh he ceh ka, canghrasala Khazing tah thihnah taitah a patho kaw. Ma kong cawh kaaning sahlo heh a hnihtu ka cang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Zisu ming zingnah thongtah ma naa hmuhpaw le naa hnipaw cawngsaw heh dangsah a cang myca hi. Zisu ming zingnah takhei ma cawngsaw heh a pungpaluh tah a dangsah myca hi, naaning zong tah naa hmuhpaw hrahei. ");
INSERT INTO zypNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Uny sahlo, ma hming heh naa hruitu sahlo hratah naa hnilynah cawtah naa tuapaw a cang tahpaw ka hni. ");
INSERT INTO zypNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Canghrasala Khazing taco a khuavang vytei hmang tei Khri cawh a taithui a tatah a za reihlang ciapaw bia khah a tlingsah myca. ");
INSERT INTO zypNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Macawtaco naa suanah a ngepachih la, Khazing lang a hui tua o, taico naa suanah pathaisah pah cang he ceh ka, Abuipaw taitah thawzaang tha lahnah cai va chua ka, ");
INSERT INTO zypNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Khri cawh a va cathlaw pá he a, naa caw tei rawhpaw Zisu ceingei khah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Khazing tah a khuavang mehpathai sahlo hmang tah khuahlai ning tah bia a kangpaw hrakhei hming zezong a thapaw tah tua cai a phah hlai vytei cawh Zisu cawh vaicung letah a ung cawngpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses zong tah, ‘Abuipaw naa Khazing tah kama hapaw khuavang heh naaning hrong taitah a chuasah tae a, Ama tei a ca chingpaw he bia maikaw cawh nge my lo. ");
INSERT INTO zypNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ahohmai a biareipaw a nge lypaw maikaw cawh a mingphing taikhei hlyde a cang a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","A cang, Khazing khuavang vytei, Samuel taitah a patho katei, aa dawngkasawny tah aa reipaw cawh atoning tei hming a cangpaw kong heh aa reihlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Naaning cawh Khazing tei naa mapaw sahlo khatah a tuapaw biataipaw ry cytu le Khazing khuavang sahlo pathlah cawh na cang he ceh. Khazing tah Abraham hai letah, ‘Na chungchuh ci le phing thongtah aluicung cawngsaw vytei heh bonghnang song a cang tae he a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Khazing tah a saecapaw cawh patho ka, naaning khatah a va thlaw tawpaw cawh naa suanah taitah a palehsah tah bonghnang song a ca dunah caw he tah a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tlangbui sahlo le behnah ing a vaipaw raekeh sahlo aa buipaw le Sadusi sahlo cawh Piter le Johan tah zawpui sahlo letei bia aa rei leimeining taco aaning khatah a vong he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Aaning sahlo cawh aa thing a ae ngetei, zecawtamaw tatah apostol sahlo tei zawpui aa cawngpahnah rawng he tah le Zisu thihnah taitah a thokawnah kong khah aa y khui rong tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Piter le Johan cawh tle he ka, zailang a cang thah cawtah thong letah a ningthlamongpaw tai aa chia he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Canghrasala aa bia reipaw a thuipaw mehlupui taco zing he ka, zingtu cawngsaw 5000 tai a tah myca he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A ningthlamongpaw leco nawhnuitu sahlo le macang sahlo le phungbia cawngpahtu sahlo cawh Jerusalem leco a pahmo he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tlangbui alaicaipaw Anas zong ung hrah ka, Kaiafa le Johan le Alekzandar le ahringpaw tlangbui alaicaipaw a ingchungkho cawngsaw sahlo zong a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Piter le Johan cawh ma sahlo aa hmekung leco va chuakhui he ka, “Ze hmingtuakhyná tamaw a cang ly leh aho ming tamaw ma hming heh naa tua?” tatah aa hae rahry he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mataico Piter cawh Thlawpaw Pathai tah chih ka, aa hai letaco, “Zawpui cung letah nawhnuitu le macang sahlo! ");
INSERT INTO zypNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","A phesongpaw cung letei ningdonah kaa palangsahnah kong letah atoning heh ma hrahei ma y he ceh ka, zehratamaw dangnah a hmuh tahpaw kong heh naa ma hae. ");
INSERT INTO zypNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Naaning kha Israel cawngsaw vytei khatah ma heh hnih my lo. Naa hme letei a daw thlangpaw cawngsawpaw heh naaning tah khraws letah khaipai he ceh ka tei, Khazing tei thihnah taitah a patho kawpaw Nazaret Zisu Khri ming tah a dangpaw a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ama cawh, ‘ing a sahtu sahlo tah aa hlawhpaw a lung, ingkilung a biapui caipaw khah a cang.’ ");
INSERT INTO zypNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pachahnah cawh aho letah hmai hmuh khy cang be. Aluicung pungpaluh lehei kaaning pachahnah rua pawtah ming hringpaw ung be,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Piter le Johan aa raechah zia cawh hmuh he ka, cawngsaw cakhawngpaw le ca a thai lypaw aa cangpaw khah aa hni tihtah aaning sahlo cawh aa khuarawha ka, Zisu kha a ungteipaw a cang he tahpaw aa hni he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Canghrasala a dangsahpaw cawngsawpaw cawh Piter le Johan kha a daw thlangpaw aa hmuh tihtah zekhatahmai aa rei khy nápaw ung be. ");
INSERT INTO zypNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Macawtaco Piter le Johan cawh Sanhedrin taikhei piakhui law tah he ka, mataico aaning sahlo cawh a pahmo he ka, bia aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Aaning tah, “Ma cawngsaw sahlo heh zekhatamaw kaa tua he a? Jerusalem letei a ungpaw vytei tahei hmingchaw ningang chuipaw aa tua tahpaw aa hni thlu thah myca, cang be tah khy tlung bei he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Canghrasala ma kong heh cawngsaw hrong letah a kaipaza vy ly nápawtah Zisu ming hei bia rei khaw bei ceh tatah raering kaa pae he a,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Macawtaco apostol pahning tlaw cawh y kaw he ka, Zisu ming tah bia reilai tah cawngpah hrahring khaw bei ceh, tatah bia aa patai he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Canghrasala Piter le Johan taco, “Naaning tah pacang tua la, Khazing mehmuh letah naaning naa rei nge maw a chah vy maw? Khazing a rei nge maw a chah vy? ");
INSERT INTO zypNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kaaning cawh kaa hmuhpaw le kaa thuipaw heh rei lytah ung khy bei peh,” tatah aa palei he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lesá tah aa pachih khy tai he tah Piter le Johan cawh aa thlaw he. Zehapaw dangtahnah maw kaa pae he tahpaw khah bia cheh khy bei he. Zecawtamaw tatah cawngsaw vytei tah a phesongpaw cung letei a tlungpaw hming aa hmuhpaw thong tei Khazing aa reithaipaw khah aa hmuh cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A phesongpaw, khuarawha chuipaw tei dangnah a hmuhpaw cawh kung songli hlui a tah ciapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aa thlaw taico he, Piter le Johan cawh zingtu a cangpaw he aa vesaw sahlo khaco a vaw he ka, tlangbui macang sahlo le macang sahlo tei aa tahnahpaw vytei he khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ma bia cawh aa thui tihtah Khazing khaco hmokheh teitah ma hrahei thlaw aa chang. “Vy Abuipaw Cungnungcai, alui le avai le rili le a chung letei a ungpaw maikaw heh nama tah na tua. ");
INSERT INTO zypNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kaa mapaw David, na saecapaw hmang khei Thlawpaw Pathai tah bia na rei, ‘Zecawtamaw ma raang sahlo tahei aa thingae ka, ma cawngsaw sahlo tahei a chahnai lypaw sadu heh aa thaw? ");
INSERT INTO zypNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Alui letei siangpahrang sahlo tahei a pachia a paning he ka, uhtu sahlo khakhei hmingkheh tah a pahmo he ka, Abuipaw le Ama tei sathy a thupaw khah a carae he,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ma hraco Herod le Pontia Pilat tah Gental cawngsaw sahlo le Jerusalem khuapui letei a ungpaw Israel cawngsaw sahlo khakhei hmingkheh tah a pahmo he ka, Mesiah cawtah na thingpaw Zisu, na sae pathaipaw a carae pawtah aa reisia. ");
INSERT INTO zypNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Aa tuapaw heh na thinglung le na hming tua khy ná tei naw na tlah khuipaw he le a cang hlai taitei cang tae seh, na tahpaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Macawtaco Abuipaw, aa ma pachihnah sahlo heh pacang tua la, na sae sahlo heh raechah ngetei tah na bia ma reisah tua. ");
INSERT INTO zypNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na sae a pathaipaw Zisu ming tah dang nápawtah na bang pazy la, ningang chuipaw paching pakhanah le khuarawhanah tuá tua,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Thlaw aa chang khy taico, aa ungnahpaw hminghmaw cawh a calawh. Taico aa zongmingtei co Thlawpaw Pathai tah chih he ka, Khazing bia khah raechah teitah aa rei. ");
INSERT INTO zypNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A zingtu vytei cawh lungthing hmokheh teitah aa ung. Aa hnuicho khah ka tei a cang tatah ahotahmai tah ly he tah aa hnuipaw maikaw khah a hrong he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hmingtuakhynah a rungnawpaw khakhei apostol sahlo taco Abuipaw Zisu a thokawnah kong cawh reilai longmang he ka, Khazing ningdonah cawh aa zongmingtei cung lekhei a ung. ");
INSERT INTO zypNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Aa hrong letah vainge tah ahohmai ung bei he. Aaning chung letei ing maw a cang ly leh ly maw a hnuipaw sahlo takhei ma sahlo cawh ato le ato zua he ka, a mai cawh va chuakhui he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apostol sahlo aa phehrang lekhei chia he ka, a phahlahpaw cawngsaw khah aa rai he. ");
INSERT INTO zypNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Saipras tuiraw letei Levi mingphing a cangpaw Josef, apostol sahlo tei Barnaba aa tahpaw (A silang cawh thawzaang peitu sawcapaw tahnah a cang) takhei, a hnuipaw baily khah zua ka, a mai tangka cawh va chuakhui ka, apostol sahlo aa phehrang leco a chia. ");
INSERT INTO zypNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananias aa tahpaw cawngsawpaw le a nupuino Safira zong taco aa ly sangkheh khah aa zua hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias taco a nupuino a rei tah ly mai tangka a chybang khah law ka a chia, mataico a tangpaw tangka khah va chua khui ka, apostol sahlo aa phehrang leco a chia. ");
INSERT INTO zypNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mataico Piter tah, “Ananias, zekhatah zia tamaw Setan tah na lungthing cawh pahrang ka, Thlawpaw Pathai cawh dungkhei ceh ka, alui mai na hmuhpaw tangka chung taitah a chy cawh na cawtah na chia zia? ");
INSERT INTO zypNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na zua hlai takhei na tei pui a cang caw! Na zua khy tai zong tah tangka cawh na tei cang thlang bei maw? Zemaw, ma hapaw hmingchahly heh na tua lalei? Ma heh cawngsaw na dungkheipaw cang be, Khazing na dungkheipaw a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias tah ma bia cawh a thui tihtah pohly ka, a thi. Macawtaco ma hming a cangnah kong a thuipaw cawngsaw sahlo cawh aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mataico satlepaw sahlo khah va chuh he ka, a rawh cawh pahlong he ka, alailang piakhui he ka, aa phung. ");
INSERT INTO zypNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Suimehlang pathung a ry tih hrawng lekhei a nupuino Safira cawh a za nae ka, hming a cang zia khah hnih be. ");
INSERT INTO zypNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piter taco, “Ma tangka heh nama le Ananias tei alui naa zuanah mai cawh a cang maw, pa ching tua?” a tah. “A cang, ma khah alui mai cawh a cang,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piter taco a hai letah, “Abuipaw Thlawpaw hnehsá pawtah zekhatah zia tamaw na naw a tlah lalei? Mingtua! Na pasae rawh a phungpaw cawngsaw sahlo cawh ingkaw letah ung thlang he ka, nama zong aa ca seikhui hra a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma cangkawleh cawh a phehrang leco pohly ka, a thi. Satlepaw sahlo cawh a za nae he ka, a thihpaw khah aa hmuh tihtah alailang cawh piakhui he ka, a pasaepaw aa phungnah kae leco aa phung hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Khrisawbu vytei le ma konglang a thuipaw vytei cawngsaw sahlo cawh aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostol sahlo taco ningang chuipaw paching pakhanah le khuarawha chuipaw hming a hlupui khah cawngsaw hrong letah aa tua. Taico zingtu vytei cawh Solomon dungkalung leco a tong tei he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ahohmai zingtu sahlo khaco a pakong ngang bei he, caduisai cawh ma sahlo taco zingtu sahlo cawh aa cizaw ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Abuipaw cawh canu kha capaw kha a hlupui tah zing he ka, a ka lo leimei he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Zecawtamaw tatah a danglypaw sahlo khah ikhung le aphia letah isah he ka, Piter a va khia tihtah mehthaikheh cung letah a ningpahlipaw a zeiso phung tah he ka, lang sahlo lekhei aa va chuakhui he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem khuapui kaekang letei khuapui sahlo taikhei cawngsaw hlupui va chuh hrah he ka, a danglypaw le thlawpaw pialuipaw tei a pahrangpaw sahlo khah va chuakhui he ka, aa zongmingtei co dangsah a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mataico tlangbui alaicaipaw le a vesaw vytei le Sadusi phu a cangpaw sahlo cawh aa hei a tlia ngetei. ");
INSERT INTO zypNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Apostol sahlo cawh tle he ka, vaitlang thong letah aa thlah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Canghrasala zai taco Abuipaw a vaiming tah thong-ing ingkaw cawh hong ka, a piakhui he, ");
INSERT INTO zypNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","taico aaning cawh, “Va sei la, behnah ingdung chung lekhei a va daw la, hringnah a thapaw bia a cangpaw heh cawngsaw sahlo kha va ching tua o,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Khua a dui taikhei a chingpaw he hraco behnah ingdung chunglang cawh a nae he ka, cawngsaw khah aa cawngpah he. Tlangbui alaicaipaw le a vesaw sahlo aa va chua tihtah Sanhedrin (Israel nawhnuitu sahlo a pahmonah alaipaw pui a cang) khah y he ka, apostol sahlo cawh thong leco aa va ysah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Canghrasala thong-ing aa va phah tih taco, thong-ing bui sahlo taco ma cawngsaw tlaw cawh hmuh bei he. Macawtaco va sei kaw he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Thong ing ingkaw cawh cabi a hrai thlang ka, a vaipaw sahlo cawh ingkaw letah a daw thlangpaw he kaa hmuh he, canghrasala, ingkaw sahlo cawh hong he peh ka, kaa ming tihtah a chung letah ahohmai hmuh bei peh,” tatah aa thuisah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ma thuisahnah bia cawh aa thui tihtah behnah ing vaitu sahlo aa buipaw le tlangbui macang sahlo cawh aa ningping ka, ma heh zekhatamaw a cang tah he ka, pacangrung tah aa ung. ");
INSERT INTO zypNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mataico thaikhehpaw a vong he ka, “Ngetua o! Cawngsaw pahning thong letah naa thlah pawhe khah behnah ingdung chung letah a daw he ka, cawngsaw sahlo aa cawngpah leimei he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Macawtaco, behnah ing vaitu sahlo aa buipaw cawh a kih rai letei abui sahlo khaco piathlah he ka, apostol pahning cawh aa va chuakhui he. Canghrasala tharung hmang tah zekhatahmai tah bei he, zecawtamaw tatah zawpui takhei alung tah aa ma vaseh sua a tah aa cinah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apostol sahlo cawh aa va chuakhui khy tai he tah, tlangbui alaicaipaw tah bia hae ná he seh tah he ka; Sanhedrin hme leco a dawsah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tlangbui alaicaipaw tah, “Ma Zisu a ming hei cawngpah lai bei he ceh tatah biasah teitah kaa ca tah he, canghrasala Jerusalem khuachung cawh naa cawngpah ná tah chih thlang myca ka, Zisu a thihnah kong lehei sua phosah na ma pachia he ceh hi,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piter le ahringpaw apostol sahlo taco, “Cawngsaw rei navy co Khazing rei kaa nge hri ruapaw a cang! ");
INSERT INTO zypNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Khraws letah khaipai he ceh katei, naa thawpaw Zisu khah kaa mapaw sahlo aa Khazing tah thihnah taitah a patho kaw. ");
INSERT INTO zypNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israel cawngsaw sahlo tah aa suanah a ngepachih tah ngethai aa cang nápaw cawtah Khazing tah Abui le Pachahtu tah a cacang lang a cuicaling myca. ");
INSERT INTO zypNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kaaning sahlo heh ma hming sahlo a hnikhuitu cang he peh ka, Ama a rei a ngepaw sahlo khatah Khazing tah a pehpaw he Thlawpaw Pathai zong a cang hrah,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sanhedrin phu taco ma bia cawh aa thui tihtah aa thingae ngetei ka, thaw aa du he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Canghrasala Gamalia aa tahpaw Farasipaw, phungbia cawngpahtu, cawngsaw vytei tah aa cizawpaw takhei Sanhedrin hme leco a daw ka, ma tlaw heh alailang sungkheh tei piakhui cong law, a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mataico aa hai letah, “Israel cawngsaw sahlo, ma tlaw cung letei tua na pachia pawhe ceh heh achaw teitah pacang tua my lo. ");
INSERT INTO zypNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Khuahlai takhei ama leh ama khah mehlai ka cang a tahpaw Theuda va chuh ka, cawngsaw 400 hrawng tah ama cawh aa zui. Canghrasala ama cawh theh he ka, a hningzuitu vytei cawh a paipatlaw he ka, zehmai cang bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ama khy taico Judas, Galili cawngsawpaw cawh mehlu reining tah va chuh ka, carae tho rua pawtah cawngsaw phukheh khah a hruichua he. Ma cawngsawpaw zong cawh theh hrah he ka, a hningzuitu vytei cawh a paipatlaw thlang hrah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Macawtaco, atoteipaw kong lehei rawhnah peh ka ca dupaw he cawh ma tlaw heh thlaw la, seisah thlang o! Aa pacangpaw le aa hming tuapaw heh mehnung taiteipaw a cang caco, a rawh kaw thlang a. ");
INSERT INTO zypNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Canghrasala, ma heh Khazing taitah a cang caco, ma tlaw heh thly khy bei he ceh; Khazing kaa dy tahpaw naaning teitah naa bi tae a,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A reipaw bia leco aa nawtlah ka, apostol sahlo cawh behnah ing chunglang y he ka, aa cheisah he. Mataico Zisu ming tah phung rei khaw bei ceh tah he ka, aa thlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostol sahlo cawh Sanhedrin taico piathlah he ka, aa thaw a chah ngetei, zecawtamaw tatah Zisu a ming rawng tah tai-ingnah a ing tlangpaw ka cang peh aa tah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ningkheh khy ningkheh behnah ingdung chung le ingkheh khy ingkheh khei Zisu cawh Khri a cang tahpaw thawngchawbia cawngpah le y khui khah tai bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma ningcai taco Zisu hningzuitu sahlo cawh a ka vy lo leimei he ka, aa hrong letei Grik rei a cuipaw Juda cawngsaw sahlo takhei Hebru rei a cuipaw Juda cawngsaw sahlo cung lekhei aa lungtling be, zecawtamaw tatah e le ba ning tating rainah kong letah kaa lahme sahlo heh aa mingpakhung he aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Macawtaco apostol pahrawhluihning takhei hningzuitu vytei khah pahmo he ka, “E le ba khuakhang rawh tah Khazing bia reilai laky khah kaa dethlang caco, kaa cawtah chah a be. ");
INSERT INTO zypNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Macawtaco uny sahlo, naa hrong chung lehei cawngsaw pasarih, Thlawpaw tah a chihpaw le a singpaw thing la, ma rai heh aaning aa cung letah khing he peh ka, ");
INSERT INTO zypNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kaaning cawh thlawchang le Khazing bia reilai rai lehei ka pei hri a he peh,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Apostol sahlo tei ma rawhnah aa chuakhuipaw cawh aa lung a cang ngetei. Macawtaco zingnah le Thlawpaw Pathai tei a chihpaw cawngsaw, Stiven khah aa thing; Mataico Filip, Prokora, Nikanor, Timon, Parmena le Antiok khuapui cawngsawpaw Juda behnah lang a palehpaw Nikola khah aa thing he. ");
INSERT INTO zypNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ma tlaw cawh apostol sahlo khaco va chuakhui he ka, apostol sahlo taco aa cung letah aa kih pahnia he ka, thlaw aa changpah he. ");
INSERT INTO zypNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Macawtaco Khazing bia cawh a ka vy leimei ka, Jerusalem khuachung letah Zisu a zingpaw sahlo cawh a ka ngetei he ka, tlangbui a hlupui tah Zisu cawh aa zing hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Khazing ningdonah le hmingtuakhyná tah a chihpaw Stiven takhei, khuarawha hming le ningang chuipaw paching pakhanah khah cawngsaw hrong letah a tua. ");
INSERT INTO zypNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Caduisai cawh cawngsaw thaikhehpaw cawh Stiven cung letah aa lungtling be. Ma sahlo cawh Sae cangnah taitei luasahpaw sahlo aa Synagog taitei cawngsaw sahlo a cang he. Sairini khua le Alekzandria khua, Silisia le Asia raang letei a ungpaw Juda cawngsaw sahlo khah a cang he. Ma cawngsaw sahlo taco Stiven a bia cawh aa ei, ");
INSERT INTO zypNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","canghrasala a singnah le Thlawpaw tei bia a reipaw khah ei khy bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mataico, “Stiven tah Moses le Khazing khah dy he katei, reipachianah bia a reipaw khah kaa thui,” tatah a tah ruapaw takhei cawngsaw thaikhehpaw khah aparuh teitah aa pasy he. ");
INSERT INTO zypNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Macawtaco, zawpui le macang sahlo le phungbia cawngpahtu sahlo khah aa pasy he. Ma tlaw taco Stiven cawh tle he ka, Sanhedrin hme leco aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Biahnihtu pakheipaw sahlo zong va chuakhui he ka, aa reipaw cawh, “Ma cawngsawpaw tahei phungbia le hming pathai reipachia heh tai khawh beh. ");
INSERT INTO zypNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ma Nazaret Zisu tahei ma behnah ing heh chehthlah a neh ka, Moses tei a ma pehpaw phunglang heh a thlai a, tatei a tahpaw kaa thui,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sanhedrin letei a tythlangpaw cawngsaw vytei taco Stiven cawh taa ky tah mingchai he ka, a mehme cawh vaiming mehme hratah a cangpaw khah aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mataico tlangbui alaicaipaw taco, “Aa ca tahnah bia heh ahmang maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","A paleipaw cawh, “Paw sahlo le uny sahlo, ka bia heh nawthlia tua o! Alaisuipaw Khazing cawh kaa mapaw Abraham khatah Haran khuapui letah a ung hlai Mesopotamia raang letah a ungning takhei a za paly. ");
INSERT INTO zypNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Khazing taco, ‘Na raang le na mingphing seisai la, ka ca hmuh sápaw raang lang sei,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Macawtaco Chaldi cawngsaw sahlo aa raang cawh seisai ka, Haran khuapui letah khua a va sah. A paw a thih khy taitah Khazing tah ama cawh atotei naa ungnahpaw raang lang heh a va sei sahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Khazing tah ama cawh ma lehei cy vy zehmai pei be, a phe a chia nápaw alui achiatei hmai pei be. Canghrasala Abraham cawh ma ningcai leco sawtei hnui lytah ung hrah hmai my seh la, Khazing tah ama cawh ama le ama khy taiteipaw a pathlah sahlo tah ma raang heh naa cy a, tatah bia a kang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ma khy taico Khazing taco Abraham cawh, ‘Na pathlah sahlo tah aa raang a cang lypaw male raang letah khuachai cang tae he ka, kung zapali chung sae cang he ka, tua chahly tah tua a cang he a. ");
INSERT INTO zypNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Canghrasala sae tah a hmangpaw he mingphing khah, kama tah dangtah a he neh ka, ma khy taico ma raang taico chuhthlah a he ka, ma hminghmaw lehei aa pa be a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mataico, Abraham cawh cingpatainah kong biatainah khah a peh. Taico Abraham tah Isak cawh sah ka, a chua khy taitah ningreh lekhei a cingpa cawh a tai. A hning khy taco, Isak tah Jakob cawh sah ka, Jakob taco aa ma pathlahtu mehpuimaw sahlo pahrawhluihning khah a sah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","A utei sahlo taco asuipaw Josef khah aa hnachuanah cawtah Izipt raang lang sae tah aa zua. Canghrasala Khazing tah ungkhui ka, ");
INSERT INTO zypNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ruhanah a tongpaw vytei chung taikhei a pachah lai. Ama tah Josef khah singnah pei ka, ma rawng taco Izipt siangpahrang Faraoh tah mehmechaw a peh. Macawtaco ama cawh Izipt raang le abui ing chung vytei cung letah uhtu tah a tua. ");
INSERT INTO zypNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mataico Izipt raang le Kanaan raang chung vytei cawh cakaang tah dai ka, taithui ngetei he ka, kaa mapaw sahlo cawh e ruapaw zehmai hnui bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakob tah Izipt raang letah saze a ung tahpaw khah a thui tihtah kaa mapaw sahlo khah a uikhehnah kaangsang a zongsah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A uihningnah aa va sei ning taco, Josef tah a uny sahlo khah ahomaw a cang tahpaw ching he ka, Faraoh taco Josef a ingchungkho kong cawh a thui. ");
INSERT INTO zypNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma khy taihei Josef taco a paw Jakob le a ingchungkho pungpaluh, aa zongmingtei tah songsarih le papangaw a cangpaw he khah a va lahsah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Macawtaco, Jakob cawh ama le kaa mapaw sahlo aa thihnah raang a cangpaw Izipt raang lang heh a cung thlah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aa rawh sahlo khah Shekem khua lang kawkhui he ka, Abraham tei Shekem khua cawngsawpaw Hamo a sawtei sahlo taitah tangka tei a cawhpaw thlai lekhei aa phung he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Khazing tei Abraham bia a kangpaw cai cawh tling daimang tei ca ka, Izipt raang letei a ungpaw kaa mingphing sahlo cawh a pungzang ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mataico siangpahrang ahringpaw, Josef kong a hnih khawh lypaw cawh Izipt raang uhtu tah a va cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ama taco kaa mingphing sahlo khah rorang dutah hreh he ka, nysai apithapaw sahlo cawh thi ná he seh tatah alailang aa va sah thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ma ningcai leco Moses cawh pi ka, a chuhthai ngetei. A paw a ing letah thlah thung chung aa cong. ");
INSERT INTO zypNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ama cawh alailang letah aa va chia tihtah, Faraoh a sawcanu takhei law ka, ama a sawtei tah a tua. ");
INSERT INTO zypNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses cawh Izipt cawngsaw tei aa hnipaw vytei khah cawng hrah ka, biarei le tuahre leco hming a tua khy ngeteipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses cawh kung songli a tah tihtah a vesaw Israel cawngsaw sahlo khah ka ve he tah ka, a sei. ");
INSERT INTO zypNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aaning hrong letei pakhehpaw khah, Izipt cawngsawpaw tah tua chahly tei a tua leimeipaw khah a hmuh tihtah a va baw ka, a phulá pawtah Izipt cawngsawpaw cawh a thaw. ");
INSERT INTO zypNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses taco, a mingphing tahei aaning pachá pawtah Khazing tah ama khah ahmang tahpaw heh aa hni thlang thly a tatah a rawh, canghrasala aaning sahlo taco hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A ningthlamongpaw letah Israel cawngsaw a dai leimeipaw he khah Moses taco a hmuh he. Aa kaa letah arainah tua a pachia ka, ‘Vesaw leh, naaning cawh uny pui naa cang caw, zecawtamaw pakheh le pakheh na dai he ceh?’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Canghrasala pakhehpaw tua chahly tei a tua leimeipaw cawngsawpaw takhei Moses cawh nanghly ka, ‘Ahomaw kaa cung letah uhtu le biacetu tah a ca tua? ");
INSERT INTO zypNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Zahai tei Izipt cawngsawpaw na thawpaw hrakhei maw thaw na pa du?’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses tah ma bia cawh a thui tihtah Midian raang lang khah a sai. Ma leco raang hringpaw cawngsaw hratah khuasah ka, sawcapaw pahning a sah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kung songli a tah khy lekhei vaiming pakheh cawh Moses khaco Sinai tlaang kae sadi raang lekhei chingbu me tei a kang leimeipaw tah a za paly. ");
INSERT INTO zypNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ma cawh a hmuh tihtah a hmuhpaw lekhei a ning a ang. Va sei ka, a ne teitah va ming ka, Abuipaw o cawh a thui, ");
INSERT INTO zypNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kama cawh na mapaw sahlo aa Khazing, Abraham, Isak le Jakob aa Khazing ka cang,’ tah ka, Moses cawh a cinah cawtah a cathing ka, ming ngang be. ");
INSERT INTO zypNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mataico Abuipaw taco a hai letah, ‘Na phepakong khah pahlu, na dawnahpaw alui khah hming pathai a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Izipt raang letei ka cawngsaw sahlo aa taithuinah khah ka hmuh pase myca. Vaisang aa ynah thong khah thui myca neh ka, aaning sahlo luasah rua pawtah ka zuh myca. Atoheh a vong la, Izipt raang lang ka ca thlaw kaw a,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ma Moses heh, ‘ahomaw uhtu le biacetu tah a ca tua,’ tah he katei, aa za du lypaw khah a cang. Ama cawh aaning uhtu le lua sápaw tah chingbu letei vaiming ama kha a langnah thongtah Khazing tei a thlawpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ama taco Izipt raang taikhei piakhui he ka, Izipt raang, Rili Sai letah le sadi raang letei kung songli aa vezi chung lekhei khuarawha hming sahlo le ningang chuipaw paching pakhanah sahlo khah a tua. ");
INSERT INTO zypNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Israel cawngsaw sahlo khah, ‘Khazing tah kama hapaw Khazing khuavang heh naaning naa cawngsaw chung lilaw taitah a ca thlawpah he,’ tatei a tahpaw he khah Moses heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ama cawh raangca letei zawpui a pahmopaw khakhei za ung ka, Sinai tlaang cung letah ama khatah bia a reipaw vaiming khakhei ung ka, taico kaa mapaw sahlo khatah a za ungpaw cang ka, ama cawh kaaning khatah pehchingpaw Khazing bia hring a za lawpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Canghrasala, kaa mapaw sahlo taco a rei za nge du bei he. Za dy laky he ka, aa lungthing co Izipt raang khah aa ngechai. ");
INSERT INTO zypNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aron khah, ‘Kaa hme a ma chui rua pawtah khazing sahlo ma tuapah. Izipt raang taitah a ma piakhuipaw Moses zekhatamaw a tua tahpaw hnih khawh bei peh!’ tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ma cawh co teitei nono aa tuanahpaw cai khah a cang. Thuihlainah tua he ka, ma aa kia tei aa tuapaw nono cawh pasungpanawnah pui aa tuapah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Canghrasala Khazing tah hningchai he ka, avai letei a ungpaw ning le thlawpaw le esi sahlo khah a behsah myca he. Ma tahei Khazing khuavang sahlo cabu letei ciapaw khah ahmang tah a langsah he, ‘Israel cawngsaw sahlo, sadi raang lekhei kung songli chung kama khatah athuihlainah le pehlainah naa va tle maw kha? ");
INSERT INTO zypNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Molek khazing ing le naa khazing Refan naa tahpaw esi beh rua tei naa tuapaw nono sahlo cawh na songlai he ceh. Macawtaco Babilon raang a khunglang sae tah ka ca thlawhly he a.’ tatah a cia. ");
INSERT INTO zypNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kaa mapaw sahlo tah Khazing kaa ning kha a ung tah hninah tah sadi raang letah pai thlangda aa hnui. Ma cawh Khazing tah Moses ching katei, a hmuh sahpaw hmuisang tei hratah tuapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A ma pathlahtu sahlo taco ma cawh aa paw sahlo taikhei law he ka, Khazing tei a tingchua hlangpaw he mingphing sahlo taitah rang aa lah ning takhei Josua hruinah rai lekhei pai thlangda cawh aa seikhui lai. Ma cawh David a chai tai lekhei ma raang leco a ung thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David taco Khazing dukhuinah hmuh ka, Jakob a Khazing cawtah a ung nápaw hminghmaw ka sah pá a, tatah Khazing khah a hae. ");
INSERT INTO zypNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Canghrasala Khazing caw tei ing a sahpaw cawh Solomon a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Caduisai cawh Cungnungcai Khazing cawh cawngsaw tei sahpaw ing letah ung be. Khazing khuavang Isaiah tei a reipaw hratah, ");
INSERT INTO zypNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Vaicung cawh ka buidyching cang ka, alui cawh ka phe chianah a cang. Zehapaw ing maw ka cawtah naa sá a? A cang ly leh zeletamaw ka ung nápaw hminghmaw cawh a cang a? ");
INSERT INTO zypNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ma hming vytei heh kama ka kih chuh cang bei he maw?’ tatah Abuipaw tah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Naaning meh lungkhong cawngsaw, lungthing le nawkho cingpa a tai lypaw sahlo, naa mapaw sahlo tei ky naa lo hrah. Thlawpaw Pathai cawh naa pakhang cakhawng leimei thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Naa mapaw sahlo tei aa hreh lypaw Khazing khuavang pakheh chang ung he maw? Mehdingpaw a vong nápaw kong a reihlangpaw sahlo hmai aa thaw he kho. Taico atoheh naaning tah ma cawngsawpaw cawh lui he ceh ka, naa nawng. ");
INSERT INTO zypNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Naaning cawh vaiming sahlo hmang tei kaa mapaw sahlo letah pehpaw phungbia a hnuipaw cang he ceh ka, canghrasala ma phungbia cawh zui bei he ceh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ma bia cawh aa thui tihtah aa thingae ngetei ka, aa haw aa riá so. ");
INSERT INTO zypNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Canghrasala Stiven cawh Thlawpaw Pathai tah chih ka, avai lang a y ka, Khazing rungnawnah le Khazing kih cacang lang letah Zisu a daw thlangpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ama taco, “Mingtua o! Avai a hong ka, Khazing cacang lang letah Cawngsaw Sawcapaw a daw thlangpaw ka hmuh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma tih taco aa nawkho a pamai he ka, athang puitah ysang he ka, va saihno he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","khuapui alailang cawh hrui lai he ka, alung tah aa va. Stiven sua a phosahpaw sahlo cawh aa angkilai sahlo pahlu he ka Saul aa tahpaw satlepaw takhei a tlepah he. ");
INSERT INTO zypNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Alung tei aa va leimeining taco Stiven tah, “Abuipaw Zisu, ka thlawpaw law my lo,” tatah thlaw a chang. ");
INSERT INTO zypNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mataico a khuh panai ka, “Abuipaw, aa suanah heh ngethai my lo,” tatah a y. Ma a rei khy taico a thi. ");
INSERT INTO zypNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mataico, Saul cawh Stiven thawnah leco a naw a tlah hrah. Ma ning leco Jerusalem khuapui letei khrisawbu cung lekhei hrehnah a rupaw pui tlung ka, apostol sahlo rei ly co zingtu vytei cawh Judia raang le Samaria raang tahpaw lekhei a paipatlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Taico, Khazing a zingpaw cawngsaw sahlo takhei Stiven a rawh cawh phung he ka, mangchia aa sah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma duitei cawh Saul taco khrisawbu khah rorang a pachia he. Ingkheh khy ingkheh seilai ka, canu capaw khei hruiphi lai he ka, thong letah a thlah he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A paipatlawpaw cawngsaw sahlo taco aa seinah maikaw lekhei thawngchawbia cawh aa reilai. ");
INSERT INTO zypNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip cawh Samaria raang letei khuapui lang khah sei ka, ma leco Khri kong cawh a y khui. ");
INSERT INTO zypNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Zawpuipaw taco Filip bia a reipaw cawh thui he ka, ningang chuipaw paching pakhanah a tuapaw sahlo khah aa hmuh tihtah a reipaw bia khah achaw teitah aa nge. ");
INSERT INTO zypNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Cawngsaw hlupui chung taikhei thlawpaw pialuipaw sahlo cawh aa ysang hmotah pia he ka, a zung athipaw le a phe a songpaw ahlupui a dang he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Macawtaco, ma khuapui letei a ungpaw cawngsaw sahlo cawh a lawng ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma khuapui leco Simon aa tahpaw cawngsawpaw pakheh a ung. Ama cawh ca-ia a thaipaw cang ka, Samaria cawngsaw vytei khah aa khuarawh a haasah ngetei he. Mehlai ka cang tatah a pachaw ngetei ka, ");
INSERT INTO zypNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","cawngsaw vytei, mehlai mehchia takhei a rei cawh nge he ka, “Hmingtuakhynah a rungnawpaw aa za tahpaw Khazing hmingtuakhynah a hnuipaw cawh ama heh pui a cang ky he,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ama cawh aa zui lai, zecawtamaw tatah a thainah ca-ia khei aaning sahlo khah cai sypui aa ning a za angsah rawng he tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Canghrasala Filip tei Khazing painah raang kong thawngchaw le Zisu Khri ming kong a reipaw khah aa zing tihtah canu kha capaw kha baptisma a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon zong taco zing ka, baptisma cawh a cang hrah. Taico Filip khah a seinah maikaw lang zuilai ka, paching pakhanah rungnawpaw le ningang chuipaw a hmuhpaw sahlo takhei a khuarawh aa haasah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalem khuapui letei a ungpaw apostol sahlo taco Samaria cawngsaw sahlo tah Khazing bia aa cyhlang tahpaw cawh aa thui tihtah aaning sahlo khaco Piter le Johan cawh aa thlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aa va phah tihtah Thlawpaw Pathai aa hmuh nápaw cawtah khei thlaw aa changpah he, ");
INSERT INTO zypNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","zecawtamaw tatah aaning sahlo aa cung lekhei Thlawpaw Pathai cawh za tlung balang be. Abuipaw Zisu ming tah baptisma cy khah aa ing. ");
INSERT INTO zypNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mataico Piter le Johan taco aa cung lekhei aa kih pahnia he ka, Thlawpaw Pathai cawh aa hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aa cung letei apostol sahlo tah aa kih aa pahnianah pawtei Thlawpaw peh aa cangpaw khah Simon taco a hmuh tihtah tangka khah ca pei he neh ka, ");
INSERT INTO zypNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ma rai hrekhynah heh pa pei hra la, aa cung letei ka kih ka pahniapaw cawngsaw maikaw tah Thlawpaw Pathai cawh aa hmuh hrah nápawtah,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piter taco, “Na tangka cawh nama khatah lyde thlang seh, zecawtamaw tatah Khazing lahsong heh tangka tah ka cawh khy a tah na rawh cawtah hei! ");
INSERT INTO zypNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nama cawh Khazing a rai lehei tingvy hnui bei ceh, zecawtamaw tatah Khazing hme letah na lungthing pathai be. ");
INSERT INTO zypNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ma chahlynah heh a ngepachih la, Abuipaw khatah thlawchang. Ama taco na lungthing letei ma rawhnah na hnuipaw khah a ca ngethai mai a. ");
INSERT INTO zypNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nama cawh iavaw ná tah chih ceh ka, suanah sae letah a tangpaw na cang tahpaw ka hni,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon tah, “Na reipaw cawh ka cung letah a tlung ly nápawtah ka cawtah Abuipaw cawh pa naw pah ky law,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piter le Johan taco, Abuipaw bia cawh aa y khui khy taikhei Samaria khuatei a hlupui letah phung reipai lai khei Jerusalem khuapui lang cawh aa va kaw kaw. ");
INSERT INTO zypNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ningkheh cawh Abuipaw a vaiming pakheh tah Filip cawh, “Thuilang sadi raang lang tei langpui Jerusalem taitei Gaza lang seinahpaw lang khah sei,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Macawtaco a tho ka, langpui leco Ethiopia cawngsaw hrilopaw, Ethiopia siangpahrangno Kanda a cho a mingkaitu alaicaipaw khah a tong. Ma cawngsawpaw heh Jerusalem lang khah Khazing beh pawtah sei ka, ");
INSERT INTO zypNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ranglai a va ci ka, Khazing khuavang Isaiah a ciapaw cabu rei hmo khei a va kaw kaw lang a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Thlawpaw taco Filip cawh, “Ranglai lang khah va sei la, a kae lekhei a va daw tua,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Macawtaco Filip cawh ranglai a ungnah lang cawh va sai ka, cawngsawpaw tei Khazing khuavang Isaiah a ciapaw cabu a reipaw khah a va nge. Filip tah, “Na reipaw bia khah na lung a tlai maw?” tatah a hae. ");
INSERT INTO zypNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Meh-laipaw taco, “Pakheh kheh tah chingpase lypaw co zekhatamaw ka lung a tlai thai a?” tatah a tah. Mataico, Filip khah ama kha a va ty hrah law tatah a song. ");
INSERT INTO zypNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Meh-laipaw tei Capathai a reilaipaw cai cawh ma heh a cang, “Ama cawh thaw rua pawtei aa seikhuipaw tuu hratah seikhui he ka, tuu teitei cawh a hming a ngytu hme letah de teitah a ungpaw hratah Ama cawh a kaw hmai ang be. ");
INSERT INTO zypNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ningzaw aa thle tihtah a reikaitu ung bei he. A hringnah cawh lá tah a ung thah cawtah hei aho tamaw a pathlah sahlo aa kong cawh a rei a?” tahpaw heh. ");
INSERT INTO zypNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Meh-laipaw taco Filip cawh, “Ningdonah pawtah pa ching tua, Khazing khuavang tahei aho kong maw a rei, ama a kong maw a rei, ahringpaw kong?” a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Macawtaco Filip taco, meh-laipaw tei a rei leimeipaw Capathai cai ceingei co patho ka Zisu kong thawngchawbia cawh a ching. ");
INSERT INTO zypNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Langpui letah aa va seipai lai co, tui a ungnahpaw hminghmaw va phah he ka, meh-laipaw taco, “Mingtua, ma lehei tui a ung hi! Baptisma a cang pawtah ze tamaw a pa pakhang?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip taco, “Na thinglung vytei tah na zing caco baptisma na cang khy thlang,” a tah. Meh-laipaw taco, “Zisu Khri cawh Khazing Sawcapaw a cang tah ka zing,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Macawtaco, ranglai cawh a dawsah law a tah. Mataico Filip le meh-laipaw cawh aa pahning tah tui lang cawh cungthlah he ka, Filip taco baptisma cawh a cangsah. ");
INSERT INTO zypNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tui taitah aa ka pia tihtah Abuipaw Thlawpaw taco Filip cawh rairang teitah seihly khui ka, meh-laipaw taco, ama cawh hmuh kaw khawh be, canghrasala a nawng teitah lang leco a seilai. ");
INSERT INTO zypNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Canghrasala Filip cawh Azota khua letah a lang ka, Sisaria khua a phahnah tai, a tlonglaipaw khua vytei lekhei thawngchawbia cawh a rei lai. ");
INSERT INTO zypNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma chung vytei leco Saul cawh Abuipaw a hningzuitu sahlo khah thaw thlu thlang pawtah khei, pachih parong leimei thlang he ka, tlangbui alaicaipaw khakhei a vaw ka, ");
INSERT INTO zypNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damaska khuapui chung letei a ungpaw synagog sahlo letei peh ruapaw tlekhynah ca khah a va hae. A dunah cawh ma lekhei Zisu cawngpahnah langpui a zuipaw a hmuh caco he, canu kha capaw kha tle tah, Jerusalem khuapui lang va chuakhui tei thongthlah ruapaw he takhei a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Taico sei ka, Damaska khuapui a tlung cai taco sung sungkheh tah avai taikhei a khaipaw tah a kaekang khah a za khaipaleh. ");
INSERT INTO zypNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Alui leco pohly ka, “Saul, Saul, zecawtamaw na pa hreh?” tatei a tahpaw o khah a thui. ");
INSERT INTO zypNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul taco, “Abuipaw, ahomaw na cang?” tah ka, “Na hreh leimeipaw Zisu ka cang hi. ");
INSERT INTO zypNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tho la, khuapui chunglang a va nae la, ma letei a ungpaw taco na tua ruapaw khah aa ca ching tae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saul khatei khua a tlawng hrah pawhe cawngsaw sahlo cawh ma leco aa khuarawha hmo khei a daw thlang he ka, o cawh thui he ka, canghrasala ahohmai hmuh bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul cawh alui taico tho ka, canghrasala a meh a dui tihtah zehmai hmuh khy be. Macawtaco Damaska khuapui chunglang cawh a kiá khei aa ca awh lai. ");
INSERT INTO zypNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ningthung chung khua hmuh khy lytah ung ka, zehmai ding e be. ");
INSERT INTO zypNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaska khuapui chung leco zingtu Ananias aa tahpaw a ung. Abuipaw taco ama cawh a palyná khei, “Ananias!” tatah y ka, Ananias taco, “Ma lehei ka ung thlang hi, Abuipaw,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Taico Abuipaw taco, “Tho la, Lang Ding aa tahpaw lang letah a ungpaw Judas a ing lang kha va sei la, Tarsas khuapui cawngsawpaw Saul aa tahpaw khah a ung maw, tatah va pakhia tua. Ma cawngsaw cawh thlaw a chang leimei kho. ");
INSERT INTO zypNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Apalynah letah Ananias aa tahpaw cawngsawpaw a vong ka, a meh khua a hmuh khy kaw nápaw takhei a cung letah a kih a pahniapaw khah Saul tah a hmuh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias taco, “Abuipaw, ma cawngsawpaw kong heh a hlupui thui thah neh ka, Jerusalem khuapui chung letei na mehpathai sahlo cung letah chahlynah a hlupui a tuapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Taico, ama cawh nama na ming a zingpaw vytei sahlo khah tle rua pawtah tlangbui macang sahlo taiteipaw nawhnuinah khakhei, ma lang heh a va chuapaw a cang,” a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Canghrasala Abuipaw taco Ananias cawh, “Va sei thlang! Ma cawngsawpaw heh Gental cawngsaw sahlo le aa siangpahrang sahlo le Israel cawngsaw sahlo hme letah ka ming a y khui ruapaw tei ka thingpaw ka hmingbo a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ka ming rawng tahei zetlua tamaw a tai-ing a tahpaw kama tah ka hmuh sah tae a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Macawtaco Ananias cawh Judas a ing lang khah a vaw ka, ing chunglang cawh a nae. Saul a cung leco a kih khah pahnia ka, “Ka unypaw Saul, ma lang heh na va sei laining tei langpui letah nama kha a palypaw Abuipaw Zisu takhei khua na hmuh khy kaw nápaw tah le Thlawpaw Pathai tah na chi nápaw cawtah a pa taw hi!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mataico ma cangkaw leco, Saul a mehkho taico a pahli hapaw tlah thlah ka, khua cawh hmuh khy kaw ka, mataico tho ka, baptisma a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mataico batui a e khy taikhei thawzaang a ka hnui. Mataico Saul cawh Damaska khuapui letei a ungpaw hningzuitu sahlo khakhei ning cawngpe a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Zisu cawh Khazing Sawcapaw a cang tahpaw khah synagog sahlo lekhei a cawngpah palang he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","A biareipaw a thuipaw vytei cawh aa ning ang ka, “Ma cawngsawpaw heh Jerusalem khuapui letei a ungpaw Zisu ming a ypaw sahlo cung letah hmuisui tei hrehronah a tuapaw khah cang bei maw? Taico ma tlaw khah thongthlah a pawtah tlangbui macang sahlo khatah a va chuakhuipaw he cang bei maw?” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saul cawh phungreinah lang lekhei a thaw ka tlung longmang ka, Zisu cawh Khri a cang hrahring tatei a chingpasepaw he bia khei Damaska khuapui letei a ungpaw Juda cawngsaw sahlo cawh reinah hni lytah a tua he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Khua sy a ry khy taikhei, Juda cawngsaw sahlo taco thaw rua pawtah khei khuakhang he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","canghrasala Saul taco aa khuakhangpaw khah a hni. Ama thaw ruapaw taco khuapui hawkaw sahlo lekhei ching kha zai khatah a bo he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Macawtaco a hningzuitu sahlo takhei zai tah ama cawh law he ka, abawng khei lungrua a bangbakho lekhei aa thlah hly. ");
INSERT INTO zypNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jerusalem khuapui cawh a va phah tihtah Zisu a hningzuitu sahlo kha a pakong pawtah a pachia, canghrasala ma tlaw vytei takhei ama cawh a hningzuitu hmuisui a cangpaw khah aa zing lynah cawtah aa ci ngetei. ");
INSERT INTO zypNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Canghrasala Barnaba takhei Saul cawh y ka, apostol sahlo khakhei a va chua khui. Ama taco, Saul tei a khuatlongnah langpui letah Abuipaw a tongnah ningcang le Abuipaw tei a chingpaw le Damaska khuapui letah ci lytah Zisu ming tei phung a reinah kong khah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Macawtaco Saul cawh aaning sahlo khaco ung ka, Jerusalem lekhei a dunah pawtah tlawnglai ka, Abuipaw ming tah raechah teikhei a reilai. ");
INSERT INTO zypNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Grik rei a cuipaw Juda cawngsaw sahlo khakhei bia a pakong he ka, a ei he, canghrasala thaw pawtah a pachia he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Zingtu uny sahlo tah ma cawh aa thui tihtah Sisaria khua lang cungthlah khui he ka, Tarsas khuapui lang khah aa seisah hly. ");
INSERT INTO zypNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mataico Judia raang, Galili raang le Samaria raang hrawnghrang letei a ungpaw khrisawbu sahlo cawh denah cai khah aa hmuh. Khrisawbu cawh aa thawtlung vy ka, Thlawpaw Pathai tah thawzaang pei he ka, pungzang he ka Abuipaw cizaw hmo khei khua aa sah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piter cawh raang chung letah khua a tlawng chung takhei Lida khua letei a ungpaw mehpathai sahlo khatah va sei ka, a va ve he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma leco song katei, a inah letah kung reh chung a lia thlangpaw cawngsawpaw Aenia aa tahpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piter taco a hai letah, “Aenia, Zisu Khri tah a ca dangsah. Tho la, na iphaw khah ling,” tatah a tah. Ma cangkaw leco, Aenia cawh a tho. ");
INSERT INTO zypNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida khua le Sharon letei a ungpaw cawngsaw vytei tah Aenia cawh aa hmuh tihtah Abuipaw cawh zing he ka, ama lang a paleh thlu he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa khua letah Tabitha (ma no a ming cawh Grik rei tah, “Dorka,” tatah a paleh) aa tah no hningzuitu pakheh a ung. Ama cawh hmingchaw a tua teipaw le sisah a bong teipaw he a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma ningcai leco a sah ka, a thi. A rawh cawh si he ka, a cung khang letah aa song. ");
INSERT INTO zypNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida khua cawh Jopa khua kae letah a ung; macawtaco hningzuitu sahlo tah Piter cawh Lida khuapui letah a ung thlang tahpaw aa thui tihtah cawngsaw pahning taw he ka, “Ningdonah pawtah a catleinah pawtah a vong ky law,” tatah aa va naw. ");
INSERT INTO zypNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piter cawh aaning khaco va sei ka, a va phah tihtah a cung khang lang cawh aa kekhui. Lahme vytei taco Piter cawh a daw cahlung he ka, Dorka a hringchung tah a tawpaw angki pasuapaw sahlo le ahringpaw chaichi sahlo khah aa caw hmo khei aa hmuhsah. ");
INSERT INTO zypNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piter taco aaning vytei cawh a khang alailang khah a papia he. Mataico a khuh panai ka, thlaw a chang. A thino lang cawh a hui ka, “Tabitha, tho,” tatah a tah. Ma cangkaw leco, a meh cawh ka dui ka, Piter khah ka ming ka, a ka ty. ");
INSERT INTO zypNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piter taco a kiá tah tle ka, a phe tah a dawsah. Mataico, zingtu sahlo le lahme sahlo khah y he ka, a hring pawtah aaning cawh a peh he. ");
INSERT INTO zypNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ma cawh Jopa khua taco hnih he ka, mehlupui tah Abuipaw cawh aa zing. ");
INSERT INTO zypNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piter cawh Jopa khua letei a ungpaw sapho a tuatupaw Simon aa tahpaw khakhei, ning hlupui a ung tei. ");
INSERT INTO zypNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria khua letah Kornelia aa tahpaw cawngsaw pakheh ung ka, ama cawh Itali raekeh chung letei raekeh zakheh buipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ama le a ingchungkho vytei cawh Khazing a cizawpaw le a pei ngeteipaw a cang he. Ama cawh phahlah pongchang tei a ungpaw sahlo khah sai ngetei tah peihlai he ka, a cai ahmang teitah Khazing kha thlaw a chang tei. ");
INSERT INTO zypNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ningkheh cawh zailang suimehlang pathung hrawng lekhei apalynah hmuh ka, a hmuhpaw leco ama khatah a vong katei, “Kornelia,” tatah a ypaw Khazing a vaiming khah a se ngetei pawtah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelia taco a ci hmo khei mingchai ka, “Abuipaw, zemaw?” tatah a hae. Mataico vaiming taco, “Na thlawchangnah le mehsisah na pehlaipaw he lahsong sahlo khah Khazing tah a thui thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Macawtaco, atoheh Jopa khua lang khah cawngsaw taw la, Piter tatah aa ypaw cawngsaw Simon aa tahpaw khah va lah sá o. ");
INSERT INTO zypNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ama cawh rili kae letei a ing a ungpaw, saving a tuapaw Simon khatah a tlung kho,” tatah a chai. ");
INSERT INTO zypNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ama bia a chingpaw vaiming cawh a seihly, taico Kornelia tah a sae pahning le a raitaw raekeh behnah lang a pei ngeteipaw khah a y he. ");
INSERT INTO zypNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hming a chuacangnah ningcang vytei khah aaning cawh ching he ka, Jopa khua lang cawh a thlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ningthlamongpaw cawh Kornelia tei a tawpaw he tah Jopa khua aa phah cai hrawng lekhei, Piter cawh ningching hrong lekhei thlawchang pawtah ing cung khah a ke. ");
INSERT INTO zypNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A ngaidi ngetei ka, batui e a du. Batui aa tua chung taco, apalynah khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Vaicung a hongpaw le paiphaw alaipaw pui ky a lopaw a ki kipali tah alui lang aa za tlahpaw khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A chung leco phe palipaw saw a phingtling le alui letah a lai thaipaw saraang a phingtling le a zy thaipaw pavaw a phingtling a ung he. ");
INSERT INTO zypNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mataico o tah, “Piter, tho la, ma sahlo khah theh la, e,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Canghrasala Piter taco, “Abuipaw, e bei neh! Apialuipaw le a pathai lypaw cawh zehmai e bang bei neh,” tatah a palei. ");
INSERT INTO zypNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","O taco, a uihningnah letah, “Khazing tei a pathaisah ciapaw cawh pathai be tah kheh,” tatah a tah vy. ");
INSERT INTO zypNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uithung tai, ma hraco tua ka, sungkheh takhei paiphaw cawh vaicung lang khah a lahchy kaw thah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piter cawh a hmuhpaw apalynah a silang rawng tah khuarawha tah a ungchung takhei, Kornelia tei a tawpaw he cawngsaw sahlo taco Simon a ing zeletamaw a ung tahpaw khah va hui lai he ka, ing hawkaw cawh aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Simon cawh y he ka, Piter tatei aa ypaw Simon khah ma lehei a tlung maw tlung ly tahpaw aa hae. ");
INSERT INTO zypNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mataico, Piter cawh apalynah a hmuhpaw a pacang leimeining takhei cang ka, Thlawpaw taco a hai letah, “Simon, cawngsaw pathung tah aa ca huilai leimei. ");
INSERT INTO zypNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Macawtaco tho la, a rai lang cung. Aaning kha sei pawtah lung langlo tah ung kheh, kama ka thlawpaw a cang he kho,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Macawtaco, Piter cawh a va huilaipaw cawngsaw sahlo khatah cung thlah ka, aa hai letah, “Naa huilai leimeipaw cawh kama ka cang. Zecawtamaw naa pa hui?” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma tlaw taco, “Raekeh zakheh buipaw Kornelia a ing lang tah kaa va chuapaw a cang. Ama cawh mehding le Khazing a cizawpaw cawngsaw, Juda cawngsaw vytei tah aa cizawpaw khah a cang. Vaiming pathai tah nama heh, a ing lang va chua tah na reipaw bia thui ná seh, a tah cawtah,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Macawtaco, Piter tah ma cawngsaw sahlo cawh ama a khuachai cang pawtah a ing lang a sawng he. Ningthlamongpaw leco Piter cawh ma tlaw khaco sei he ka, Jopa khua letei zingtu uny thaikhehpaw sahlo zong a sei hrah he. ");
INSERT INTO zypNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A hazainingpaw leco Sisaria khua cawh aa va phah. Kornelia taco aaning cawh mingkhai thlang he ka, a sawny le a vesaw chaw sahlo zong khah hmingkheh tah a y he. ");
INSERT INTO zypNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piter cawh ing a va phah tihtah Kornelia taco va dai ka, a phehrang leco a khuh panai ka, a beh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Canghrasala Piter takhei a patho. “A daw tua, kama heh cawngsaw suipaw ka cang hrah hi!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kornelia khatah bia aa rei leimeining takhei Piter cawh ing chunglang a nae ka, cawngsaw hlupui a za pahmo thlangpaw he khah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Aa hai leco, “Juda cawngsaw tah Gental cawngsaw khatah huikongnah tua a cang ly le a ve ke cawh, kaa phung khatah a cakhaepaw a cang tahpaw cawh achaw teitah naa hnipaw a cang. Canghrasala ahotei hmai pathai be, a pialui tatah ka tah ly na'pawtah Khazing tah a pa hmuhsah myca. ");
INSERT INTO zypNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Macawtaco na va pa lahsah tih he tahei zehmai lung langlo lytah ka vong hi. Zecawtamaw na va pa lahsah he tahpaw pa ching tua?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelia taco, “Ningpali a tah myca, ato tih cai, zailang suimehlang pathung lehei ka ing letah ung thlang neh ka, thlaw ka chang leimei. Sung sungkheh tah chaichi akhaipaw a tuapaw cawngsawpaw cawh ka hme letah a va daw ka, ");
INSERT INTO zypNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma cawngsawpaw taco, ‘Kornelia, Khazing tah na thlawchangnah khah thui myca ka, mehsisah lahsong na pehlai pawhe khah monghly be. ");
INSERT INTO zypNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Piter tatei aa ypaw Simon khah va lá pawtah Jopa khua lang cawngsaw taw he. Ama cawh rili kae letei a ungpaw, saving a tuapaw Simon a ing letah a tlung kho,’ tatah a pa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Macawtaco rairang tah va taw he neh ka, na va chuapaw cawh a chah ngetei. Abuipaw tei kaaning sahlo na ching he tatah a ca tahpaw maikaw khah nge rua tah ma lehei Khazing hme letah kaaning vytei atoheh kaa ungpaw a cang hi,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Macawtaco Piter tah aa hai leco, “Khazing cawh hmeming zawng be tahpaw heh zetlua tamaw ahmang tahpaw le, ");
INSERT INTO zypNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","mingphing maikaw taitah Ama a cizaw paw le dingnah a tuapaw cawngsaw cawh a cyhlang he tahpaw cawh atoheh ka hni myca. ");
INSERT INTO zypNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Cawngsaw vytei aa Buipaw a cangpaw Zisu Khri thongtah Khazing tah arainah thawngchawbia Israel cawngsaw a pehpaw he khah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Baptisma peitu Johan tei baptisma phung kong a rei khy tai khei, Galili raang taitah a patho ka, Judia raang chung lekhei zemaw a tlung tahpaw khah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Khazing tah Nazaret Zisu cawh Thlawpaw Pathai le hmingtuakhynah pei ka, khua kih lekhei sei ka, hmingchaw tua ka, Setan chawngnah rai letei a ungpaw vytei khah a dangsah lai he, zecawtamaw tatah Khazing cawh Ama khatah a ung. ");
INSERT INTO zypNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kaaning sahlo heh Judia raang le Jerusalem khuapui letei a tuapaw hming maikaw a hnihtu cawh ka cang he peh. Aaning sahlo taco Ama cawh khraws letah pathle he ka, aa thaw, ");
INSERT INTO zypNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","canghrasala, Khazing tah Ama cawh thihnah taitah ningthungnah lekhei hringsah kaw ka, hmuh khy pawtah a tua. ");
INSERT INTO zypNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ama cawh cawngsaw vytei tah hmuh bei he, canghrasala Khazing tah Ama a tehte tah cangruapaw tah a thingpaw kaaning sahlo tah kaa hmuh. Thihnah taitah a tho khy taitah Ama khatah aa e, aa dingpaw ka cang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ama taco kaaning heh cawngsaw vytei khatah thawngchaw rei rua pawtah le Ama cawh mehthi le mehring biacetu tah Khazing tah a thingpaw a cangnah zia chingpaw he tah bia a ma peh. ");
INSERT INTO zypNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Khazing khuavang vytei tei Ama a kong aa reipaw cawh Ama a zingpaw maikaw taco a ming thongtah sua ngethainah aa hmuh a,” aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piter tei ma bia a rei leimeining taco Thlawpaw Pathai cawh ma bia a thuipaw vytei aa cung leco a za tlung. ");
INSERT INTO zypNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Piter khatei a va sei hrah pawhe Juda cawngsaw cingpa a taipaw zingtu sahlo cawh Gental cawngsaw sahlo cung letah hmai lahsong a cangpaw Thlawpaw Pathai cawh peh a cang cawtah khei aa ning a ang. ");
INSERT INTO zypNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Zecawtamaw tatah rei thuilypaw aa cuipaw le Khazing aa reithaipaw khah aa thui caw takhei a cang. Taico Piter tah, ");
INSERT INTO zypNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kaaning kaa hmuhpaw Thlawpaw Pathai a hmuh hrahpaw sahlo heh, tui tah baptisma cang rua pawtah ahomaw a pakhang khy he?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mataico, aaning sahlo khah Zisu Khri ming tah baptisma cang law a tah he. Baptisma a cangsah khy tai he tah, kaaning khatah caang cong thlang law tatah Piter cawh aa thly. ");
INSERT INTO zypNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostol sahlo le Judia raang letei a ungpaw zingtu uny sahlo takhei Gental cawngsaw sahlo zong tah Khazing bia aa cyhlang hrah myca tahpaw khah aa thui. ");
INSERT INTO zypNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Macawtaco Piter khah Jerusalem lang a sei tihtah cingpa a taipaw zingtu sahlo taco ama cawh aa mochia. ");
INSERT INTO zypNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Cingpa a tai lypaw cawngsaw sahlo aa ing lang sei ceh ka, aaning khatah batui na e,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Macawtaco Piter tah hming khah a cang naningpaw hrakhei zezongpui khah a chingpase he: ");
INSERT INTO zypNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jopa khua letah ka ungning tah thlawchang leimei neh ka, apalynah ka hmuh. Paiphaw alaipaw pui, a ki kipali tah vaicung taikhei ka ungnahpaw letah a za tlah leimeipaw ka hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A chung leco ming neh ka, alui letei a ungpaw saraang phe palipaw, raang saw sahlo, a lai thaipaw sahlo le, avai letei a zy laipaw pavaw sahlo khah ka hmuh he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mataico o thui neh ka, ‘Piter, tho tua, theh la e,’ tatah a pa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Abuipaw, e bei neh! A pathai lypaw cawh zehmai e bang bei neh,’ tatah ka palei. ");
INSERT INTO zypNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","O taco vaicung taitah a uihningnah leco, ‘Khazing tei a pathaisah ciapaw cawh pathai be tah kheh,’ tatah a pa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ma hraco uithung tai cang ka, mataico paiphaw cawh vaicung lang lahchy kaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma cai ceingei leco Sisaria khua taitah aa va tawpaw he cawngsaw pathung ka tlungnah ing hawkaw aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Aaning kha sei pawtah lung langlo tah ung kheh tatah Thlawpaw taco a pa tah. Ma uny paruh zong heh kama kha sei hrah he ka, Kornelia a ing cawh ka va nae he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kornelia taco vaiming a ing letah apalynah kong cawh ma ching ka, ‘Piter tatah aa ypaw Simon cawh va lá pawtah Jopa khua lang cawngsaw taw he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ama taco nama le na ingchungkho vytei pachah naa cang nápaw bia khah a ca ching he a,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mataico bia rei ka pachia cangkaw leco, Thlawpaw Pathai cawh a hrangthonah letei kaa cung letah a za tlungpaw hrakhei aa cung leco a za tlung. ");
INSERT INTO zypNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mataico Abuipaw tei, ‘Johan taco tui tah baptisma a cangsah he, canghrasala Thlawpaw Pathai tah baptisma cangsah na cang he ceh,’ tatah a reipaw bia khah ka thui. ");
INSERT INTO zypNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Macawtaco, Abuipaw Zisu Khri a zingpaw kaaning khatah pehpaw Thlawpaw Pathai lahsong khah Khazing tah a peh hrah pawhe tei a cang caco, kama taco zekhatamaw Khazing cawh ka ei khy a?” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ma bia cawh aa thui tihtah aa zongmingtei co Piter cawh mochia khawh lytah Khazing khah aa reithai, “Khazing tah Gental cawngsaw hmai angepachihnah le hringnah naw a peh thlang he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiven kha a peitlenah rawng tei hrehnah a ingpaw sahlo he khah a paipatlaw he ka, Fonisia raang, Saipras tuiraw le Antiok khuapui tai khah phah he ka, Juda cawngsaw a cangpaw cy khah thawngchaw bia khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma duitei cawh aaning letei thaikhehpaw, Saipras tuiraw le Sairin khua taiteipaw cawngsaw sahlo cawh Antiok khuapui lang khah sei he ka, Grik cawngsaw sahlo zong khah Abuipaw Zisu kong thawngchawbia cawh aa va ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Abuipaw hmingtuakhynah cawh aaning khaco ung ka, cawngsaw hlupui tah zing he ka, Abuipaw lang a paleh he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ma thongpang cawh Jerusalem khuapui letei khrisawbu taco thui he ka, Barnaba khah Antiok khuapui lang cawh aa thlaw. ");
INSERT INTO zypNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Antiok khuapui va phah ka Khazing ningdonah aa cung letah a lang zia khah a hmuh tihtah, a lawng ngetei ka, aa lungthing vytei tah Abuipaw letah a pahnia rua pawtah khei thawzaang a peh he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba cawh mehchaw, Thlawpaw Pathai le zingná tah a chihpaw cang ka, cawngsaw hlupui khah Abuipaw khatah a va chuakhui he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mataico, Barnaba cawh Saul hui rua pawtah Tarsas khuapui lang khah sei ka, ");
INSERT INTO zypNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","a hmuh tihtah Antiok khuapui lang cawh a va chui. Macawtaco Barnaba le Saul cawh kung chuh ky khrisawbu khakhei ung he ka, cawngsaw hlupui aa cawngpah he. Hningzuitu sahlo cawh Antiok khuapui lekhei, “Khrisaw,” tatah aa za tah tawsia he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ma ning taco Jerusalem khuapui taitah Antiok khuapui lang khah Khazing khuavang thaikhehpaw sahlo a zuh he. ");
INSERT INTO zypNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Aa hrong letei Akaba aa tahpaw cawh a daw ka, Rom painah raang ting lekhei cakaang a tlung a, tatah Thlawpaw tah a pa hnisah, tatah a tah. (Ma heh Klaudia siangpahrang a cangning tei a tlungpaw khah a cang.) ");
INSERT INTO zypNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hningzuitu sahlo takhei aaning leh aa tua khynah zaé tah Judia raang letei a ungpaw uny sahlo khah cakaang bawnah pae pawtah bia aa chaw. ");
INSERT INTO zypNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ma hrahei aa tua, aa tholong khah khrisaw macang sahlo pae pawtah Barnaba le Saul cawh aa phosah he. ");
INSERT INTO zypNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ma cai hrawnghrang lehei siangpahrang Herod tah khrisawbu chung taitei zingtu thaikhehpaw sahlo khah hreh rua pawtah a tlesah he. ");
INSERT INTO zypNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ama taco Johan a uteipaw Jeims khah zyzi tah a thawsah he. ");
INSERT INTO zypNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma taco Juda cawngsaw sahlo khah a lawngsah he tahpaw a hmuh tihtah Piter zong khah a tlesah pai he. Ma heh Thino pahlawh lypaw Very Panaw chung tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Aa tle khy taico, thong letah thlahsah he ka, raekeh papali longmang khei phupali tah cong pawtah khei a chia he. Herod taco Khungsai Panawnah khy taitah mehpui hme leco chuakhui tah a biace pá pawtah khei a pachia. ");
INSERT INTO zypNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Macawtaco Piter cawh thong letah thlah he ka, canghrasala khrisawbu taco a cawtah Khazing khatah hmuisui teitah thlaw aa chang. ");
INSERT INTO zypNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod tei a biace pápaw a tah ning hlai zai leco, Piter cawh bahrairui sanghning khei tongchai he ka, raekeh pahning aa kaa lekhei isah he ka, ingkaw cawh raevai pahning takhei aa cong. ");
INSERT INTO zypNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sung sungkheh tah Abuipaw a vaiming cawh a za paly ka, a ungnahpaw chung cawh a khai thlu. Vaiming taco Piter cawh a kang lekhei pheh ka, a pahrah. “Tho pahraw!” tah ka, bahrairui cawh Piter a kihkong kongnah taico a tlahthlah thlu. ");
INSERT INTO zypNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mataico vaiming taco, “Na chaichi khah a tua la, na phepakong khah a pakong,” tatah a tah. Mataico, ma hraco Piter tah a tua. “Na angki a pasuapaw khah a pazai la, pazui,” tatah vaiming taco a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piter taco thong-ing alailang cawh a zui, canghrasala vaiming tei a tuapaw khah a hmuisuipaw a cang tahpaw hnih be; apalynah ka hmuh rua tatah a rawh. ");
INSERT INTO zypNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A pakhehnah le a pahningnah raevaitu khah khungsai he ka, khuapui chunglang seinah thawrui hawkaw aa va phah. Ma ingkaw cawh ama hawng tah ahawng thah ka, ma lang co aa piathlah. Langpui cawh aa va tlung tihtah sung sungkheh tah vaiming taco a seisai. ");
INSERT INTO zypNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mataico Piter cawh a lung ka sing ka, “Atoheh cawh Abuipaw tah a vaiming za thlaw ka, Herod kih chung taitah le Juda cawngsaw sahlo a pachianah pawhe vytei chung taikhei a pa pachah tahpaw heh lung langlo lytah ka hni myca,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","A cung letei hming ungzia khah a hnipase tihtah Marka tah zong tah aa ypaw Johan a no Mari a ing, cawngsaw hlupui a pahmo he katei, thlaw aa chang leimeinah pawlang khah a vaw. ");
INSERT INTO zypNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piter taco ingkaw cawh khong ka, ingkaw hong ruapaw taco Roda aa tahpaw sae canu khah a va sei. ");
INSERT INTO zypNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Piter a cang tahpaw khah a o tah a bi tihtah a thawchah ngetei ka, ingkaw cawh hong lytah sai kaw ka, “Piter ingkaw letah a daw thlang,” tatah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Na lung sing ná maw?” tah he ka, ahmangpaw ka rei, a tah tihtah, “A vaiming a cang a,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Canghrasala Piter taco ingkaw cawh khong vy ka, ingkaw cawh ka hong he ka, aa hmuh tihtah aa ning a ang thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piter taco de law tákhei, a kiá tah tuapah he ka, Abuipaw tah thong chung taitei a piakhuinah kong khah a ching he. Taico, “Jeims le uny ahringpaw sahlo zong khah ma kong heh thuisah my lo,” tatah tah ka, mataico piathlah ka, ahringpaw hminghmaw lang a sei. ");
INSERT INTO zypNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mongrang taco raekeh hrong chung lekhei, Piter heh zekhatah a tua ka maw a pia zia, tah he ka, aa buaiba ngetei he. ");
INSERT INTO zypNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod taco huisah caimang tei he ka, aa hmuh ly tih taco, a vaipaw sahlo khah bia hae he ka, aa palei khylynah caw takhei naa thaw he a, a tah he. Mataico, Herod cawh Judia raang taikhei Sisaria khua lang khah sei ka, ma leco a va ung cong. ");
INSERT INTO zypNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod cawh Tair le Sidon khua sahlo letei a ungpaw he cawngsaw aa cung lekhei a thing a ae ngetei. Ma khua cawngsaw thaikheh cawh a pahmo he ka, ama a tongpaw takhei a pachia he. Siangpahrang tei a paichai ngeteipaw a sae Blasta khah aa laipasong khy taitah arainah khah aa va hae, zecawtamaw tatah lawh aa hmuh nápaw cawtah khei siangpahrang a raang khah aa tythlangnah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A tongnah ning leco Herod cawh a buichaichi khah a tua ka, a buidyching leco a ty ka, zawpui khaco biareinah cawh a hnui. ");
INSERT INTO zypNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Zawpui taco, “Ma heh cawngsaw o le rei cang be, khazing o le rei a cang,” tatah aa y. ");
INSERT INTO zypNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herod takhei Khazing khah reithainah a peh lynah cawtah Abuipaw a vaiming takhei sung sungkheh tah tuh ka, salung takhei e ka, a thi. ");
INSERT INTO zypNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Canghrasala Khazing bia cawh a kaipaza lo leimei. ");
INSERT INTO zypNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba le Saul cawh aa raihrenah khah aa pachang tihtah Jerusalem khuapui lang khah va kaw kaw he ka, Marka tah zong tah aa ypaw Johan khah a va chui he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok khuapui khrisawbu leco Khazing khuavang sahlo le cawngpahtu sahlo a ung he: Barnaba, Niga aa tahpaw Simeon, Sairin khuapaw Lusia, Manian (Raang uhbui Herod khatah a chang hruipaw) le Saul a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Abuipaw cawh beh he ka, batui aa cahe chung taco Thlawpaw Pathai tah, “Ka y hno changpaw he rai hre rua pawtah Barnaba le Saul khah aa ningcang teitah pachia pá law,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Macawtaco, batui aa cahe khy le thlaw aa chang khy taico, aa cung leco aa kih pahnia he ka, mataico raihre ruapaw taco aa thlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnaba le Saul cawh Thlawpaw Pathai taco aa sei nápaw lang cawh seisah he ka, tuilawng a hianah Seleukia khua lang cawh cungthlah he ka, mataico Saipras tuiraw lang cawh tuilawng co aa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salami khuapui aa phah tihtah synagog sahlo leco Khazing bia cawh aa y khui. Johan (Marka) zong aaning a baw ruapaw he takhei aaning khaco a sei hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tuiraw pungpaluh cahrong khei tlawnglai he ka, Pafos khuapui cawh aa va phah. Ma leco Juda cawngsaw ca-ia a thaipaw le khuavang pakheipaw Bar-Zisu aa tahpaw, ");
INSERT INTO zypNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","raang uhbui Serzia Pawla a mehchui a cangpaw khah a tong he. A singvang ngeteipaw raang uhbui taco Barnaba le Saul cawh a va ysah he, zecawtamaw tatah Khazing bia khah thui a dunah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma duitei cawh ca-ia a thaipaw Elimo (Grik ming cang ka, ca-ia thaipaw tahnah a cang) takhei aaning cawh dy he ka, raang uhbui khah a zingnah taikhei a palehsah kaw pawtah a zawng. ");
INSERT INTO zypNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mataico Saul, Paul tatah zong aa ypaw cawh Thlawpaw Pathai tah chih ka, Elimo cawh a mingchai, ");
INSERT INTO zypNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nama cawh Setan sawtei le a chawpaw vytei aa carae na cang! Nama cawh aphingphing tah dungkhei a hmangpaw le hinghe tah a chihpaw na cang. Abuipaw a lang ding na rorangnah heh tai myca bei ceh maw? ");
INSERT INTO zypNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Abuipaw kiá tah dangtah na cang myca. Na meh co a ka, cai cawngpe chung cawh zehmai hmuh khy a bei ceh,” tatah a tah. Ma cangkaw leco, memarang le a zingpaw taco tlahso ka, pazu pathang lai ka, a kiá tah a hrui lai ruapaw cawngsaw khah a huilai he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Raang uhbui taco ma hming cawh a hmuh tihtah Abuipaw kong cawngpahnah takhei a khuarawhasah ka, a zing. ");
INSERT INTO zypNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul le a vesaw sahlo cawh Pamfilia raang tuilawng ahianah khua Perga lang khah Pafos taikhei tuilawng tah aa sei. Ma khua leco Johan (Marka) tah Jerusalem khuapui lang kaw kaw pawtah a seisai he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga khua taico Pisidia Antiok khuapui lang khah aa sei. Sabat ning taco synagog lang khah a nae he ka, a ty he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses phungbia le Khazing khuavang sahlo cabu khah aa rei khy taitah synagog a uhpaw sahlo taco, bia caw he ka, aa reipaw cawh, “Uny sahlo, zawpuipaw heh thawzaang pehnah bia patai naa du caco he, atoheh rei o,” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul cawh a ka daw ka a kih pazy ka, “Israel cawngsaw sahlo le naaning Gental cawngsaw Khazing a behpaw sahlo, ka bia heh pa ngepah tua o! ");
INSERT INTO zypNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel cawngsaw sahlo aa Khazing tah kaa mapaw sahlo cawh thing he ka, Izipt raang letah aa ungchung tah cawngsaw khah a pungzangsah he. Ma raang taico a thawtlungnah hmingtuakhynah khatah piakhui he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","sadi raang lekhei kung songli chung aa ziaza khah a ing khy he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaan raang letei a ungpaw mingphing phingsarih khah tingchua he ka, ma raang cawh a cawngsaw sahlo khah aa ry ruapaw tah a peh he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ma vytei tai heh kung zapali le songngaw hrawng a ry. Ma khy taihei Khazing tah Khazing khuavang Samuel a chai tai khah biacetu sahlo cawh a rawh pah he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mataico aaning sahlo taco siangpahrang ma pei law tatah hae he ka, Khazing taco Benjamin hring a cangpaw Kish a sawcapaw Saul khah pei he ka, ama taco kung songli a uh he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saul khah a hneihly khy taitah David khah siangpahrang tah a tua. Ama a kong letei Khazing tah a reipaw cawh, ‘Jesi a sawcapaw David, ka lungthing a phopaw cawngsaw khah ka hmuh myca; ama taco tuasah ka dupaw hming maikaw khah a tua a,’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ma David pathlah sahlo taihei Khazing tei bia a kangpaw hratah Pachahtu Zisu khah Israel mingphing khatah a va chuasah. ");
INSERT INTO zypNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Zisu a vong hlai tah, Johan taco Israel cawngsaw vytei khah angepachihnah le baptismanah phung a rei. ");
INSERT INTO zypNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Johan taco a rai cawh a paling daimang tihtah, ‘Kama heh aho a cang tatah maw naa parawh? Kama cawh Mesiah cang bei neh. Canghrasala Ama cawh ka hninglang tah a vong lai leimei ka, a phepakong rui a thlangpah rua pawtah hei hmai kama cawh a tlah bei neh,’ tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abraham pathlah a cangpaw uny sahlo le Khazing a cizawpaw naaning Gental cawngsaw sahlo, ma pachahnah bia heh kaaning letah pehpaw a cang hi. ");
INSERT INTO zypNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem khuapui letei a ungpaw cawngsaw sahlo le aaning a uhtu sahlo he taco Zisu khah bi be ca he ka, Ama cawh sua aa phosah. Sabat ning maikaw tei aa rei teipaw Khazing khuavang sahlo tei a konglang aa ciapaw bia zong khah aa tlingsah. ");
INSERT INTO zypNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ama cawh thaw phupaw a cangnahpaw a suanah aa tle khy ly naná teitah Pilat khah theh thlang ky tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ama a kong Capathai letei ciapaw vytei khah aa tua thlu taitah khraws cung taikhei lawthlah he ka, thlai letah aa phung. ");
INSERT INTO zypNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Canghrasala Khazing tah Ama cawh thihnah taitah patho ka, ");
INSERT INTO zypNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galili raang taitah Jerusalem khuapui tai Ama khatei khua a tlawng lai hrah pawhe sahlo takhei ning hlupui chung cawh aa hmuh. Atoheh aaning sahlo cawh kaa mingphing sahlo letah Ama a hnikhuipaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Atoheh ma thawngchawbia cawh kaa ca ching he. Khazing tei kaa mapaw sahlo bia a kangpaw he khah, ");
INSERT INTO zypNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","aa sawtei leh a cangpaw kaaning khahei Zisu a pathonah thong khei, a tlingsah myca. Reithainah Hlaw cabu bihningnah letei a ciapaw hrakhei, ‘Nama cawh ka sawcapaw na cang; atoning heh na Paw ka cang my ca.’ ");
INSERT INTO zypNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Khazing tah Zisu cawh thihnah taitah patho kaw ka, thu by a be tahpaw cawh ma hrahei a reihlangpaw a cang: ‘David letei bia ka kangpaw a pathaipaw le bonghnang a cangpaw cawh nama ka ca pae a,’ tah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ma hraco kaw hringpaw letah a rei vypaw cawh, ‘Nama taco na Mehpathai heh thuh sá bei ceh,’ a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David taco Khazing rai khah a chaitlung tai hre ka, thi ka, a mapaw sahlo khakhei phung he ka, a rawh cawh a thu. ");
INSERT INTO zypNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Canghrasala Khazing tei thihnah taitah a pathopaw taco thuhnah khah phah be. ");
INSERT INTO zypNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Macawtaco ka uny sahlo, Zisu a thongtah sua ngethainah kong heh naaning kha ka reipaw a cang tahpaw heh naa hni rua pawtah ka du. ");
INSERT INTO zypNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ama a thongtah, a zingpaw maikaw cawh thaicangsah he ka, Moses phungbia tei a luasah khy ly pawhe suanah taikhei aa lua khy thlu. ");
INSERT INTO zypNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Araering my lo, Khazing khuavang sahlo tei aa za reipaw khah naa cung letah tlungsah khe lo. ");
INSERT INTO zypNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Khazing khuavang sahlo tah, ‘Mingtua o, naaning pasipasa a thaipaw sahlo, naa khuarawha seh la, thi thlang my lo, naaning naa chai lehei hming sangkheh kheh tua a neh ka pakheh kheh tah ma kong cawh aa ca ching tahmai he tah zing by a bei ceh,’ tatah aa za rei,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mataico Paul le Barnaba cawh synagog taikhei aa piathlah tihtah cawngsaw taco hme zaa Sabat ning letah ma hming sahlo kong heh naa ma ching vy taw a, tatah aa hrui he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","A pungnah taitah zawpuipaw a di tai he tah, Juda cawngsaw ming hlupui le Juda behnah phunglang a palehpaw ming hlupui tah Paul le Barnaba cawh aa zui he. Aaning khaco bia reihrui he ka, Khazing ningdonah letah ungparia thlang pawtah aa pasy he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hme zaapaw Sabat ning leco khua pungpaluh daimang teikhei Abuipaw bia nge ruapaw taco a pahmo he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Canghrasala Juda cawngsaw sahlo tah zawpui cawh aa hmuh tih he tah aa hei tlia ka, Paul a biareipaw khah aa reipachia. ");
INSERT INTO zypNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mataico Paul le Barnaba tah aaning sahlo cawh raechah ngetei tah aa chai he, “Kaaning cawh Khazing bia heh naaning kaa ca ching tawsia he. Canghrasala, nge du be ca he ceh ka, chaizaw hringnah a cyhlang tlangtlá tah naa ung du lynah cawtah Gental cawngsaw lang ka hui myca peh. ");
INSERT INTO zypNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ma heh Abuipaw tei bia a ma pehpaw cawh a cang, ‘Naaning sahlo cawh Gental cawngsaw sahlo cawtah khainah cangpaw tah ca tua he neh ka, aluicung pungpaluh letah pachahnah naa tlungsahpaw a cang,’ a tah,” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Taico Gental cawngsaw tah ma bia heh aa thui tihtah a lawng he ka, Abuipaw bia cawh upanah pei he ka, chaizaw hringnah cy ruapaw tei thingpaw vytei taco aa zing. ");
INSERT INTO zypNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Abuipaw bia cawh pai le raang pungpaluh lekhei a kaipaza lo leimei. ");
INSERT INTO zypNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Canghrasala Juda cawngsaw sahlo takhei Khazing a cizawpaw, hmezawpaw canu sahlo le khuapui chung letei hruitu sahlo khah aa pasy he. Aaning sahlo taco Paul le Barnaba hreh khah patho he ka, aa pai le aa raang taico aa tingchua he. ");
INSERT INTO zypNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Macawtaco Paul le Barnaba takhei aa cung letei aa lungtling lynah a langsahnah caw pawtah aa pherai letei luipadih khah cathingthlah he ka, Ikoniam khuapui lang khah aa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antiok khuapui letei hningzuitu sahlo cawh alawngnah le Thlawpaw Pathai khei a chih he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mataico, Ikoniam khuapui letah Paul le Barnaba cawh aa tua teipaw hrakhei synagog lang khah aa sei. Ma leco thahpui phe tah Zisu kong khah aa rei cawtah Juda cawngsaw a hlupui le Gental cawngsaw a hlupui takhei aa zing. ");
INSERT INTO zypNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Canghrasala a zing du lypaw Juda cawngsaw sahlo takhei Gental cawngsaw sahlo khah pasy he ka, zingtu sahlo kha acaraesah he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Macawtaco Paul le Barnaba cawh ma lekhei ning hlupui cang he ka, Abuipaw a cawtah raechah ngetei khei biarei he ka, ningang chuipaw paching pakhanah le khuarawha chuipaw hmingtuakhynah naw a pehpaw he khei Abuipaw tah a ningdonah bia cawh a pacysah. ");
INSERT INTO zypNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Khuapui letei a ungpaw cawngsaw cawh a chaichy he; thaikhehpaw khah Juda cawngsaw sahlo lang a bai he ka, ahringpaw khah apostol sahlo lang a bai he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Aa hrong letei Gental cawngsaw le Juda cawngsaw sahlo takhei aa hruitu sahlo kha hmingkheh tah apostol sahlo cawh hreh rua pawtah le alung tah vaseh he pawtah a pachia he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Canghrasala Paul le Barnaba tah ma cawh aa thui tihtah Likonia raang khuapui a cangpaw Listra le Derbe le aa kaekang raang lang khah sai he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ma leco thawngchawbia cawh aa rei lai. ");
INSERT INTO zypNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra khua leco a phesongpaw cawngsaw, a chuanah taitah lang a seithai lypaw a ung. ");
INSERT INTO zypNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ma paw taco Paul tei a reipaw bia khah a nge thlang. Paul taco va ming ka, ma paw tei ka dang a tahpaw zingnah a hnuipaw khah hnih ka, ");
INSERT INTO zypNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“Na phe tah a daw!” tatah a y so. Ma leco cawngsawpaw cawh a catho ka, mataico a sei pai. ");
INSERT INTO zypNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Paul tah a tuapaw cawh zawpui taco aa hmuh tihtah Likonia rei co, “Khazing sahlo cawh cawngsaw hmuisang tah kaaning kha a za cung myca he!” tatah aa y. ");
INSERT INTO zypNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Aaning sahlo taco Barnaba khah Zeus tatah y he ka, Paul khah Hermi tatah aa y, zecawtamaw tatah ama cawh bia a thaw tah a reipaw khah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Khuapui khungthing behnah ing letei a ungpaw, Zeus khazing tlangbui takhei, co tungpaw sahlo le pangpa kua sahlo khah khuapui hawkaw letah a va chuasah khui he, zecawtamaw tatah ama le zawpui taco aaning kha thuihlainah tua aa dunah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Canghrasala apostol a cangpaw he Barnaba le Paul tah ma cawh aa thui tihtah aa du ly zia a langsahnah tah aa chaichi khah hriachy he ka, zawpui hrong chunglang cawh va sai he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Vesaw sahlo, zecawtamaw ma heh naa tua? Kaaning heh naaning hapaw cawngsaw cakhawngpaw ka cang peh hi. Thawngchawbia va ca pho he peh ka, ma chahnainah a hnui lypaw hming sahlo taihei Khazing hring, alui le avai le rili le a chung leteipaw vytei a tuapaw khatah na paleh nápaw he ceh tah kaa ca ching he hi. ");
INSERT INTO zypNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","A khung ciapaw cai lekhei co, Khazing taco mingphing vytei khah aaning leh aa dunah cacy khei a seisah thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Canghrasala Ama cawh aphy lytah ung bang beh. Naa cawtah avai taitei khua a so sahpaw le aaning leh aa cai naning tah saze a ca pehnah pawhe hei a chahnah khah a langsah ka, e le ba a hlupui ca pei he ka, naa lung khah a lawngná tah a chisah kho,” tatah aa y. ");
INSERT INTO zypNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mataico ma bia sahlo khy hlui hei, aaning khatei a thuihlainah tua a pachiapaw he zawpuipaw cawh ruha ngetei tah aa thly he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ma duitei cawh Antiok khuapui le Ikoniam khuapui taikhei Juda cawngsaw thaikheh va chuh he ka, Listra khua cawngsaw cawh aa te pahnei he. Paul khah alung tah va he ka, a thi thah tah he ka, khuapui khungthing lang cawh aa hruipahrih. ");
INSERT INTO zypNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Canghrasala hningzuitu sahlo khah a vong he ka, aa cadung thlangning takhei, a lung ka sing ka, mataico tho ka, khuapui chunglang cawh a nae. Aningthlamongpaw cawh Paul le Barnaba cawh Derbe khua lang aa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mataico ma khuapui leco thawngchawbia khah rei he ka, cawngsaw a hlupui khah hningzuitu tah aa tua he. Mataico Listra, Ikoniam le Antiok khuapui sahlo lang khah va kaw kaw he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","hningzuitu sahlo khah thawzaang pei he ka, naa zingnah letah cyky tah ahming thlang mylo tatah aa pasy he. “Khazing painah raang a nae rua pawtah ruhanah a hlupui kaa ing a,” tatah aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul le Barnaba takhei khrisawbu ting maikaw lekhei khrisaw macang sahlo khah thing lai he ka, batui cahe hmotah le thlawchang hmotah aa paichaipaw he Abuipaw khakhei aaning sahlo cawh a vosah lai he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia raang aa cahrong khy taikhei, Pamfilia raang va phah he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perga khuapui letah Khazing bia aa rei khy taitah Atalia khuapui lang aa cungthlah. ");
INSERT INTO zypNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia khuapui taico Antiok khuapui lang tuilawng tah aa seikaw. Antiok khuapui cawh atotei aa paling ciapaw rai caw takhei Khazing ningdonah letah hlai aa cangnahpaw khua a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ma khua cawh aa va phah tihtah khrisawbu khah pahmo he ka, aaning hmang tei Khazing tah a tuapaw vytei le Gental cawngsaw cawtah zehratamaw zingnah ingkaw a hong tahpaw khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Taico Paul le Barnaba cawh ma letei hningzuitu sahlo khaco lesahtei a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Cawngsaw thaikhehpaw khah Judia raang taitah Antiok khuapui lang a zuh he ka, zingtu uny sahlo khah, “Moses tei phung a ma cawngpahpaw hratah cingpa naa tai ly caco he ceh, pachah cang khy bei ceh,” tatah aa cawngpah lai he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul le Barnaba cawh ma cawngpahnah khah aa lungcang bingbi tei be ca ka, aa ei he. Macawtaco ma kong lehei apostol sahlo le khrisaw macang sahlo khah a ka hmuh a paw he tah ahringpaw a zingtu sahlo khakhei Jerusalem lang a khong pawtah Paul le Barnaba cawh Antiok khuapui letei khrisawbu takhei aa thing he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Macawtaco khrisawbu taco aaning sahlo cawh taw he ka, Fonisia raang le Samaria raang cahrong tei aa khuatlong lainah leco khrisawbu lang Gental cawngsaw sahlo a naenah pawhe kong khah aa rei lai. Ma thongpang cawh aa thui tihtah uny vytei cawh aa lung a lawng nge tei. ");
INSERT INTO zypNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem khuapui cawh aa va phah tihtah khrisawbu le apostol sahlo le khrisaw macang sahlo taco dai he ka, aaning sahlo hmang tah Khazing tei hming a tuapaw maikaw khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Canghrasala Farasi phu a cangpaw he zingtu thaikhehpaw sahlo takhei a daw he ka, “Gental cawngsaw sahlo cawh cingpa tai hrahringpaw cang he ka, Moses phungbia aa zui a hypaw a cang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mataico apostol sahlo le khrisaw macang sahlo cawh ma kong cawh reisia rua pawtah khei a tong he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mataico a hlupui aa reisia khy tah Piter cawh a daw ka, aa hai leco, “Uny sahlo, cai a sei ciapaw lekhei Gental cawngsaw sahlo tah thawngchawbia cawh ka kaw taihei thui tah aa zing nápaw cawtah naa hrong taitah Khazing tah a pa thingpaw khah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Taico lungthing a hnihtu Khazing taco, kaaning letei a tuapaw hratah Thlawpaw Pathai a pehpaw he khei aaning sahlo khah a cyhlang he tahpaw cawh a langsah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kaaning le aaning kaa letah patlianah hnui be, zecawtamaw tatah zingná tah aa lungthing khah a pathaisah thah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Taico, atoheh zecawtamaw kaaning le kaa mapaw sahlo tei kaa pho khy lypaw Moses phungbia suihnang khah hningzuitu sahlo aa hirong letah khing tah Khazing khah hnehsah na pachia he ceh? ");
INSERT INTO zypNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kaa Buipaw Zisu a ningdonah thongtah kaaning pachah kaa cangpaw hratah aaning zong pachah a cang he tah heh kaa zing!” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","A pahmopaw vytei cawh de teitah ung he ka, Khazing tah aaning khah hmang he katei Gental cawngsaw hrong letah ningang chuipaw paching pakhanah le khuarawha hming aa tuapaw sahlo kong Barnaba le Paul tah aa chingpaw he khah aa nge thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aa reipaw bia aa pachang taico, Jeims tah ma hrahei a tah he, “Uny sahlo, ka bia heh pa ngepah tua o. ");
INSERT INTO zypNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Khazing tei Ama a cawtah Gental cawngsaw sahlo hrong taitah mingphing a thingpaw he thong hei, zetlua tamaw aa zawng a rawh he tahpaw a langsah hmasawnah kong khah Simon tah a ma ching thah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ma bia tahei Khazing khuavang sahlo tei aa za reipaw bia khah akhai ngetei. Aa ciapaw cawh, ");
INSERT INTO zypNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ma khy taihei a vong kaw neh ka, David thlangda a rawh ciapaw khah ka padaw kaw a. A ronahpaw khah parai neh ka, ka sah hry a. ");
INSERT INTO zypNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ma tih taco a tangpaw mingphing sahlo le ka ming a tlepaw Gental cawngsaw vytei tah Abuipaw cawh aa pa hui a, tatah ma hming sahlo a tuatupaw Abuipaw tahei a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ma hming sahlo heh Khazing tah a cawngsaw sahlo khakhei khuahlai taitah a za palang tei,’ a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Macawtaco kama tei ka rawhpaw cawh Khazing lang a huipaw he Gental cawngsaw sahlo khah hna hnawh pei kheh he peh seh, ");
INSERT INTO zypNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ma navy co aaning khatah ca kua he peh ka, nono khatah pehlaipaw batui naa zaa a, canu capaw suanah tua bei ceh, a rong dipaw saw le sathi e bei he ceh tah heh kaa ching he a. ");
INSERT INTO zypNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Zecawtamaw tatah khuahlai ning taikhei Moses phungbia sahlo cawh khuapui maikaw lekhei rei tah cang ka ato zong heh Sabat ning maikaw tah synagog sahlo letah rei a cang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mataico, apostol sahlo le khrisaw macang sahlo le khrisawbu pui khei aa cawngsaw thaikhehpaw khah thing he tah Paul le Barnaba khakhei Antiok khuapui lang thlawpaw he tah bia cawh aa chaw. Uny sahlo hrong letei hotu a cangpaw he cawngsaw pahning, Barsaba aa tahpaw Judas le Sailas khah aa thing he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ma ca heh aa phosah lai he, “Naa uny sahlo a cangpaw apostol sahlo le khrisaw macang sahlo tah Antiok khuapui, Siria le Silisia raang sahlo letei a ungpaw Gental cawngsaw zingtu sahlo khah naa kih kaa ca tle he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kaaning sahlo kaa rei lytah kaa hrong letei thaikhehpaw sahlo cawh naaning kha va sei tah hna ca hnawh he ka, aa reipaw bia khei lung langlo tah aa ca chia he tahpaw kaa thui. ");
INSERT INTO zypNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Macawtaco meh thaikheh khah thing tah kaa vesaw chaw a cangpaw Barnaba le Paul khatah naaning khatah va thlaw cawh kaa naw aa tlah thlu. ");
INSERT INTO zypNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Barnaba le Paul cawh kaa Buipaw Zisu Khri cawtah aa hringnah hmai a hly ngangpaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Macawtaco ca tei kaa ciapaw heh a ca ching pase ruapaw he tah Judas le Sailas kaa va taw he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Arai lang letei ciapaw a hiapaw sahlo hluitah naa cung letah hmingrih zehmai khing lypaw tah Thlawpaw Pathai le kaaning kaa nawtlahnah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nono aa dangnah batui, sathisai le a rong dipaw saw tahpaw sahlo heh naa zaa a, canu capaw suanah tua bei he ceh. Ma hming sahlo heh naa cahri caco, naa cawtah a chah a. A dang pawtah,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aa tawpaw cawngsaw cawh sei he ka, Antiok khuapui lang cawh a zuh he. Khrisawbu cawh hmingkheh tah papung he ka, ca cawh aa peh he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Cakua cawh rei he ka, aa thawzaang pehnah bia taco aa lung cawh a lawngsah he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Khazing khuavang a cangpaw he Judas le Sailas takhei pasynah bia a hlupui rei he ka, uny sahlo cawh thawzaang aa peh he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ma leco ning cawngpe aa ung khy taitah aaning a thlawpaw he khatah kaw kaw pawtah uny sahlo taco adang pawtah tah he ka, aa seisah kaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Canghrasala, Sailas cawh Antiok khuapui lekhei ka ung cong thlang a, a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Canghrasala Paul le Barnaba cawh Antiok khuapui lekhei cang he ka aaning le cawngsaw hringpaw a hlupui takhei Abuipaw bia cawh cawngpah he ka, phung aa rei. ");
INSERT INTO zypNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Cai cawngpe khy lekhei Paul tah Barnaba khah, “Abuipaw thawngchaw bia kaa reinahpaw khua maikaw letei a ungpaw zingtu sahlo tlawng laipaw tah va sei kaw peh ka, zekhatamaw aa ung tahpaw va ming lai tua he peh,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba taco Marka aa tahpaw Johan khah aaning khatah sei hrah seh takhah du ka, ");
INSERT INTO zypNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","canghrasala Paul taco ama cawh a chui rua pawtah khei a rai tah be, zecawtamaw tatah Pamfilia raang lekhei aaning khah seisai he ka, thawngchawbia rai khah tlungtlia tah a hre ly rawng takhei a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ma kong leco pakheh le pakheh cawh aa lung a tlah khy be ca ka, a chaichy he. Barnaba taco Marka cawh a chui ka, Saipras tuiraw lang khah tuilawng tah aa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Canghrasala Paul taco Sailas khah a chui ka, uny sahlo takhei Abuipaw tah ning ca do ky he seh tah he ka, aa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria le Silisia raang sahlo cahrong khei sei he ka, khrisawbu sahlo khah thawzaang aa peh lai he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Mataico Paul le Sailas cawh Derbe khua lang va tlong he ka, Timote aa tahpaw zingtupaw a ungnah khua a cangpaw Listra khua lang aa sei pai. Timote a no cawh hningzuitu cang ka Juda cawngsaw a cang. Canghrasala a paw cawh Grik cawngsaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timote cawh Listra khua le Ikoniam khua letei a ungpaw zingtu uny sahlo tei mehchaw a cang aa tahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul tah ama cawh a khuatlongnah letah a chui du ka, ma hrawnghrang letei a ungpaw Juda cawngsaw sahlo takhei Timote a paw cawh Grik cawngsaw a cang tahpaw aa hninah cawtah khei Paul taco a cingpa cawh a tai. ");
INSERT INTO zypNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Khua kheh khy khua khé khei tlawng lai he ka, Jerusalem letei a ungpaw apostol sahlo le khrisaw macang sahlo tei Juda cawngsaw a cang lypaw zingtu sahlo zui ruapaw tei aa chawpaw bia khah aa thang lai he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Macawtaco khrisawbu sahlo cawh zingnah letah thawzaang hnui ngetei he ka, ning tating tah a ka vy leimei thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Asia raang chung letah phung reilai khah Thlawpaw Pathai tah a thlynah thong he tah Paul le a vesaw sahlo cawh Frizia le Kalati raang cahrong khei tlawng lai he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia raangri aa va phah tihtah Bithinia pai lang khah a nae a pachia he, canghrasala a nae rua pawtah khei Zisu Thlawpaw tah sai bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Macawtaco Misia raang chung khei sei he ka, Troas khua lang aa cung thlah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ma zai leco Paul cawh Masidonia cawngsawpaw tah a daw katei, “Masidonia raang lang a vong la, va ma baw law,” tatah a naw leimeipaw apalynah a hmuh. ");
INSERT INTO zypNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul tah apalynah a hmuh khy taico, aaning sahlo khatah thawngchawbia rei rua pawtah Khazing tah a ma ynah a cang tah he peh ka, Masidonia lang sei ruapaw taco ka pachia tlamang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Macawtaco Troas khua taico tuilawng ke he peh ka, a ding teitah Samothra tuiraw lang kaa sei. A ningthlamongpaw cawh a tho kaw he peh ka, Nepolis khuapui cawh kaa va phah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mataico, Filipi khuapui lang kaa sei. Filipi khua cawh Masidonia raang khua puimawpaw cang ka, Rom coza uhpaw khua a cang. Ma leco ning hlupui ka cang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mataico, Sabat ning leco thlawchangnah hminghmaw a rai thly a tahpaw rawhchainá khei khuapui a naenah hawkaw láng tah pia he peh ka, tuivaw lang khah kaa sei. Kaa va phah taico a ty he peh ka, ma letei a za pahmo thlangpaw he canu sahlo khah bia kaa ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Bia a ngepaw hrong leco Thiatira khuapui taitah pai saipaw a va zuapaw canu pakheh ung ka, a ming Lidia a cang. Ama cawh Khazing a behpaw cang ka Paul tei a reipaw bia khah nge pawtah Khazing tah a lungthing khah a hongpah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mataico ama le a ingchungkho cawngsaw sahlo cawh baptisma aa cang khy taikhei, a ing lang khah a ma y. “Abuipaw a zingtu tah naa parawh caco, a vong la, ka ing letah va tlung law,” tatah a ma siachai. ");
INSERT INTO zypNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Taico ningkhehpaw cawh thlawchangnah hminghmaw lang kaa va seining tah saecanu pakheh a tong he peh ka, ama cawh khachia tah a pahrangnah thongtah hming a va chuh lepaw khah a hni khy. Hmelang hming chuacangnah kong a reinahpaw khei a bui sahlo khah tangka a hlupui a hmuh pah he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ma canuno tahei Paul le kaaning sahlo cawh ma zui lai ka, “Ma cawngsaw sahlo heh naaning sahlo pachahnah langpui a ca chingpaw he Cungnungcai Khazing a sae sahlo a cang he,” tatah a y lai. ");
INSERT INTO zypNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Mataico ning hlupui ma hraco a tua tei. Ahning taco Paul cawh a si a vangtúnah cawtah a paleh hno ka, khachia cawh, “Zisu Khri ming tah ma cawngsawno chung taikhei ka pia law ka ca tah!” tah ka, ma cangkawleh cawh khachia taco a piasai. ");
INSERT INTO zypNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Canghrasala abui sahlo taco, saecanu tah tangka ma chuapah khui khawh be takhah aa hni tihtah Paul le Sailas cawh tle he ka, chodo tlang lekhei nawhnuitu sahlo hme letah aa va chua khui he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Biacetu sahlo hme lekhei va chua khui he ka, “Ma tlaw heh Juda cawngsaw cang he ka, kaa khuachung lehei hnahnawhnah aa chuasah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Rom cawngsaw kaa phungbia le kaa lang khatei a tlah lypaw phung khah tua rua pawtah aa cawngpah lai he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mataico aa bia a ngepaw zawpuipaw taco Paul le Sailas cawh a zyhno he ka, aa dai he, mataico biacetu sahlo taco raekeh sahlo khah, “Aa angki pahlu pá la, sungbasih tah chei law,” aa tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ma hratei a sah pui tah aa chei khy tai he tah, thong letah thlah he ka, thong-ing a uhtupaw khah achaw teitah vai my lo aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ma hratei bia aa patai si caw takhei thong-ing chung a chungching khang lekhei chia he ka, aa phe lekhei hraih a khai he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Zaicing hrawng lekhei Paul le Sailas cawh Khazing khatah thlawchang le hlawsah tah ung he ka, ahringpaw thongtlahpaw sahlo takhei aa nge thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sung sungkheh tah aling cawh a rupui tah a hrui ka, thong-ing khah a hrang tai a carih thlu. Ma cangkaw leco, thong-ing ingkaw sahlo cawh a honghly thlu he ka, thongtlahpaw aa bahrairui sahlo cawh a thlangthlah thlu. ");
INSERT INTO zypNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mataico thong-ing a uhtu cawh a ka chang ka, thong-ing ingkaw sahlo a honghly thlupaw khah a hmuh tihtah thongtlahpaw sahlo a sai thlu thah rua he a tah caw takhei a zyzi cawh a phe ka, ama le ama a thaw a pachia. ");
INSERT INTO zypNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Canghrasala Paul tah, “Zemaw a thaw na pachia? Ka tling thlang peh hi!” tatah a yso. ");
INSERT INTO zypNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Thonging uhtu taco me-ing va tle law tah he ka, thong chunglang cawh a za nae pahraw ka, Paul le Sailas aa hmekaw leco a cathing hmo khei a bawh. ");
INSERT INTO zypNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mataico alailang cawh ka piakhui he ka, “Ka buipaw leh, pachah ka cang nápawtah zemaw ka tua a?” tatah a hae he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paul le Sailas taco, “Abuipaw Zisu khah zing la, nama le na ingchungkho cawh pachah na cang he ceh,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mataico ama le a ingchungkho cawngsaw vytei cawh Abuipaw bia khah aa ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ma zai lilaw cai leco thong uhtu taco seikhui he ka, aa hmaw cawh a sipah he. Mataico ry lytah ama le a ingchungkho vytei cawh baptisma khah a cang palang he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Thong uhtu taco a ing lang seikhui he ka, batui khah a hung he. Ama le a ingchungkho cawngsaw cawh a lawng ngetei he, zecawtamaw tatah Khazing aa zing myca cawtah khei a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Khua cawh va dui ka, biacetu sahlo takhei paleh bui sahlo khah thong uhtu khaco taw he ka, “Ma tlaw khah va thlaw myca he seh,” tatah aa va tahsah. ");
INSERT INTO zypNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Thong uhtu taco Paul cawh, “Biacetu sahlo tah nama le Sailas khah va thlaw law, tatah aa pa tah. Atoheh cawh na pia khy myca he ceh. De teitah sei my lo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Canghrasala Paul taco paleh bui sahlo cawh, “Rom cawngsaw kaa cang naná teitah biacenah ung lytah zawpui hme letah ma tuh he ka thong aa ma thlah. Taico atoheh a paruh teitah pia he seh tamaw naa du? Cang thai a be! Canghrasala aaning hrahring a vong he seh la, va ma chua he seh,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Paleh bui sahlo taco ma bia cawh biacetu sahlo khah ching he ka, Paul le Sailas cawh Rom cawngsaw a cang he tahpaw aa thui tihtah a pahly he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nawpaw ruapaw taco a vong he ka, thong chung taico papia he ka, khuapui tai hei piathlah the law tatah aa naw he. ");
INSERT INTO zypNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mataico Paul le Sailas cawh thong taico ka pia he ka, uny sahlo a tong rua pawtah khei Lidia a ing lang cawh sei he ka, thawthonah bia aa ching he. Mataico khua taico aa piathlah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Amfipoli khuapui le Apolonia khuapui khah aa cahrong khy taitah synagog a ungnah khua Thesalonika khua khah aa va phah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","A tua teipaw hrakhei Paul cawh synagog lang khah a vaw ka, Juda cawngsaw sahlo khah Sabat ningthung chung Capathai bia taikhei cawngpah he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Khri cawh a tai-ing hrahring paw cang ka taico thihnah taitah a thokawpaw a cang takhah a chingpase he. “Ma Zisu cawh naa hrong letei ka ca chingpaw he Khri cawh a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Juda cawngsaw thaikhehpaw sahlo cawh Paul tei a reipaw bia khah zing he ka, Paul le Sailas khakhei a pakongpai he. Khazing a cizawpaw Grik cawngsaw ahlupui le hmezaw a chuipaw canu ahlupui zong takhei aa zing hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Canghrasala Juda cawngsaw sahlo takhei aa heitlia he ka, macawtaco chodo tlang letei mehchawly thaikhehpaw khah a rui he ka, papung he ka, khuapui chung lekhei hnahnawhnah aa chuasah khui he. Paul le Sailas khah tlé tah, zawpui hrong letah chuakhuipaw takhei Jason a ing lang cawh aa va hui tlamang he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Canghrasala aa hmuh ly tih he tah Jason le ahringpaw uny thaikhehpaw sahlo khah nawhnuitu sahlo hme lekhei ka hruipahrih lai he ka, “Khazaw hmingting letei hnahnawhnah a tualaipaw cawngsaw sahlo cawh atoheh ma lehei va phah he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason tahei a ing letah a tlungsah he. Aa zongmingtei tah siangpahrang Sizar tei a reipaw bia khah zetahmai sah be ca he ka, ahringpaw siangpahrang, Zisu aa tahpaw a ung aa tah,” tatah aa y. ");
INSERT INTO zypNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ma bia cawh aa thui tihtah zawpuipaw le khuapui letei nawhnuitu sahlo cawh aa lu a ri thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mataico Jason le ahringpaw zingtu sahlo cawh a tlangnah tah tangka liasah he ka, aa thlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zai a va phah cangkawleh uny sahlo takhei Paul le Sailas cawh Beria khua lang khah aa seisah he. Ma khua cawh aa va phah tihtah synagog lang cawh aa va sei. ");
INSERT INTO zypNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria khua cawngsaw sahlo cawh Thesalonika khua cawngsaw sahlo navy tah aa hringzia chah vy ka, bia cawh lungtho teitah nge he ka, Paul tei a reipaw khah ahmang maw hmang ly tah khah hni du tah Khazing Capathai khah a ning tating tah aa mingpase. ");
INSERT INTO zypNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Juda cawngsaw a hlupui tah Abuipaw cawh aa zing. Hmezaw chuipaw Grik canu ahlupui tah le Grik capaw ahlupui tah aa zing hrah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Canghrasala Thesalonika khua letei a ungpaw Juda cawngsaw sahlo tah Paul cawh Beria khua letah Khazing bia a rei tahpaw khah aa thui tihtah ma khua lang cawh va sei he ka, zawpuipaw khah va tuhso he ka, aa va pasy he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mataico uny sahlo takhei ma cangkawleh cawh Paul khah rili ngaekang lang khah va thlaw he ka, canghrasala Sailas le Timote cawh Beria khua leco a caang thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul taco, Athen khuapui lang tai a va chuithlah pawhe cawngsaw sahlo khakhei Sailas le Timote khah a catleinah khy chung tah ama khatah va sei pawtah bia a caw he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Taico, Paul cawh Athen khuapui letei ma tlaw pahning a haw chung vytei he lekhei khuachung cawh nono tah a chi thlangpaw khah hmuh ka, a lung rei a thui ngetei. ");
INSERT INTO zypNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Macawtaco, ningtating tah synagog letah Juda cawngsaw le Khazing a cizawpaw Grik cawngsaw sahlo khatah le chodo tlang letah aa ungpaw cawngsaw sahlo khatah reipasenah a hnui tei. ");
INSERT INTO zypNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikuria phu le Stoik mehsing sahlo takhei Paul cawh bia aa ei. Aaning chung taikhei thaikhehpaw tah, “Ma zehmai a cang lypaw tahei, ze bia maw rei a pachia?” tatah aaning le aaning cawh aa tah he. Ahringpaw sahlo takhei, “Mingphing hringpaw khazing sahlo kong a cawngpah laipaw he cang seh la khatah a nge,” aa tah. Ma hrahei aa tahpaw heh Paul takhei Zisu le a thokawnah kong thawngchawbia khah a reilainah cawtah a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mataico ama cawh tle he ka, Areopaka aa tahpaw khongsil a pahmonah lekhei aa chuakhui. Ma leco, “Na reilai leimeipaw cawngpahnah a thapaw heh na ma ching tua be? ");
INSERT INTO zypNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kaa thui bang lypaw bia va chuakhui ceh ka, ma chingpase tua la kaa du,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Athen cawngsaw vytei le ma letei a ungpaw khuachai sahlo cawh zehmai tua lytah rawhnah a thapaw bia rei le nge co aa cai aa pachang thlang. ");
INSERT INTO zypNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Taico, Paul cawh khuapui khongsil a pahmonah leco a daw ka, “Athen khuapui letei a ungpaw cawngsaw sahlo! Zelang tahmai behnah letah a peipaw cawngsaw na cang he ceh tah ka hni. ");
INSERT INTO zypNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Zecawtamaw tahpaw co, naa khuachung letah a khia lai neh ka, naa behnah hminghmaw sahlo khah, achaw teitah ka ming tihtah, ‘HNI LYPAW KHAZING CAWTAH,’ tatei a ciapaw dangnah siasang sangkheh ka hmuh. Macawtaco naaning tei hni lytah naa behpaw khazing kong cawh atoheh naa hai letah ka rei leimeipaw cawh a cang! ");
INSERT INTO zypNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ma Khazing heh khazaw le a chung letei a ungpaw hming maikaw a tuatupaw alui le avai Buipaw cawh cang ka, kiá tei tuapaw behnah ing letah ung be. ");
INSERT INTO zypNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Taico Ama cawh a hiapaw khah a hnui thah cawtah cawngsaw tah a rai hrepah thaipaw cang be, zecawtamaw tatah cawngsaw khah hringnah le hu le zezongpui a peitu cawh Ama heh a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Cawngsaw pakheh taikhei mingphing maikaw khah aluicung pungpaluh letah ung rua pawtah khei Khazing tah tua he ka, aa ungnahpaw hminghmaw le kung khazeh tai maw aa ung a tahpaw cai taikhah a thliapah thah he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Khazing tah ma hrahei a tuapaw cawh cawngsaw tah pa hui he seh la, ka kung phah mai a he ka, aa pa hmuh mai a, a tah cawtah a cang. A cang naná tah Khazing cawh aho khatah hmai a hlah be. ");
INSERT INTO zypNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Zecawtamaw tatah, ‘Ama letah hring he peh ka, a cawcang peh ka, ma hrahei kaa ung.’ Naa phungthluh tei, ‘Kaaning sahlo heh a pathlah cawh ka cang he peh,’ a tahpaw hrakhei. ");
INSERT INTO zypNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Macawtaco Khazing a pathlah kaa cangnah cawtah Khazing cawh cawngsaw singnah le zungthainah tah tuapaw sui nono le ngung nono le lung nono hratah kaa pacang a paw cang be. ");
INSERT INTO zypNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Hninglang cai leco cawngsaw tah aa za hni lypaw khah Khazing tah a ngethai thlang he, canghrasala atoheh cawh hmingting letei a ungpaw cawngsaw vytei khah a ngepachih rua pawtah bia a peh myca he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Khazing taco Ama tei a thingpaw cawngsaw tah dingná tah khazaw biace nápaw ning khah a thlia. Ama cawh thihnah taitah patho kaw a cangnahpaw takhei ahmang tahpaw khah ming vytei khatah a langsah,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mehthi thokawnah kong cawh aa thui tihtah thaikhehpaw tah hnuiso he ka, canghrasala ahringpaw taco, “Ma na reipaw kong heh nge vy tima kaa du thlang,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Macawtaco Paul taco a pahmopaw khongsil cawh a piasai he. ");
INSERT INTO zypNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Canghrasala cawngsaw chykheh cawh ama cawh zui he ka, a reipaw cawh zing he ka, aaning hrong chung leco Areopaka khongsil phu a cang hrahpaw Dionisia le Damari aa tah no le ahringpaw sahlo zong a ung hrah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ma khy taico Paul cawh Athen khuapui taico piathlah ka, Korin khuapui lang khah a sei. ");
INSERT INTO zypNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ma leco Pontas raang taitei a chuhpaw, Juda cawngsawpaw Akuila aa tahpaw khah a tong. Ama cawh zahaine tei a nupuino Prisila khatah Itali raang taitah a va chuhpaw a cang, zecawtamaw tatah Rom siangpahrang Klaudia tah Juda cawngsaw vytei khah Rom khuapui taitah na pia cehceh he ceh tatah bia a papia cawtah a cang. Paul cawh aaning ve pawtah sei ka, ");
INSERT INTO zypNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","zecawtamaw tatah ama cawh aaning hratah pai thlangda a tuapaw a cang. Aaning khaco ung ka, rai khah aa hrehrui tei. ");
INSERT INTO zypNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paul cawh Sabat ning maikaw lekhei synagog letah Juda cawngsaw le Grik cawngsaw sahlo khah laipasong rua pawtah khei Khazing bia cawh a rei tei. ");
INSERT INTO zypNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas le Timote cawh Masidonia raang taitah aa va tlung tihtah Paul cawh ze hringpaw pacang ly khei phung rei leco a pei ka, Juda cawngsaw sahlo cawh Zisu cawh Khri a cangnah kong khah a ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Canghrasala Juda cawngsaw sahlo takhei Paul khah dy he ka, a thai aa pachia tihtah cang be tahnah takhei a chaichi khah cathingso he ka, aa hai letah, “Naa suanah mai cawh naaning tah naa ing tae a. Kama cawh ka rai hrepaw letah ka pathai. Atoning taihei co, Gental cawngsaw sahlo khatah ka sei myca a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Macawtaco Paul cawh synagog taikhei piathlah ka, Khazing a behpaw Titias Justa a ing lang khah a sei. Ma cawngsawpaw a ing cawh synagog a va changpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Synagog a uhpaw Khripa le a ing letei a ungpaw vytei taco Abuipaw cawh zing he ka, Paul a reipaw bia a thuipaw Korin khua cawngsaw a hlupui zong tah zing he ka, Baptisma a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Zaikheh cawh Abuipaw cawh Paul khatah a paly ka, a hai letah, “Ci kheh, rei lo leimei thlang, de teitah ung kheh lo. ");
INSERT INTO zypNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nama khatah ung neh ka, ahotahmai ca dy bei he, hanah zong ca pei bei he, zecawtamaw tatah ma khuapui lehei mehnung a hlupui ka hnui he hi,” tatah a ching. ");
INSERT INTO zypNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Macawtaco Paul cawh Korin khuapui leco kung kheh le a chy ung ka, khua cawngsaw sahlo khah Khazing bia cawh a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio cawh Akhaia raang uhtubui tei a cang chung takhei Juda cawngsaw sahlo cawh a pahmo he ka, Paul khah tle he ka, biacenah ing letah aa va chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Aaning taco, “Ma cawngsawpaw tahei kaa phungbia lypaw hratah cawngsaw khah Khazing beh rua pawtah a reipasawh lai he,” tatah aa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul tah bia ka rei a a tah tihtah Galio taco Juda cawngsaw sahlo khah, “Ma cawngsawpaw tei hmingchahly a tuapaw kong rei naa du tei a cang caco, naa bia heh nge rua pawtah hei a tlahpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Canghrasala bia le ming le naa phungbia naa ei pawhe ceh a cang. Macawtaco, naaning teitah va cepah thlang o. Ma hapaw bia cawh ce du bei neh,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Macawtaco aaning sahlo khah biacenah ing taico a papia he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mataico, synagog a uhtu a cangpaw Sosthen khah pazah he ka, biacenah ing hme leco aa tuh. Canghrasala, Galio taco zetahmai rei be. ");
INSERT INTO zypNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul cawh Korin khuapui leco khua synong a caang. Mataico uny sahlo khah seisai he ka, Akuila le Prisila takhei zui he ka, Siria raang lang tuilawng tah a sei. A seithlah hlai takhei biakangnah a za tuapaw rawng takhei Kenkhria letah a sang a ngysah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efesa khuapui aa va phah tihtah ma leco Akuila le Prisila khah a seisai he. Ama longtei tah synagog lang va sei ka, Juda cawngsaw sahlo cawh phung khah a va ching he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aaning kha cang cong thlang pawtah thly he ka, cang thai be tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Canghrasala a sei tihtah, “Khazing tah a rai a tah caco, ka va ca tlong kaw tae he a,” tatah bia a kang he. Mataico Efesa khuapui taico tuilawng tah a sei. ");
INSERT INTO zypNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sisaria khua cawh a phah tihtah cung ka, Jerusalem lang a khong ka, khrisawbu cawh bia a ching he ka, mataico Antiok khuapui lang cawh a zuh. ");
INSERT INTO zypNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antiok khuapui leco ning cawngpe a caang khy taitah seithlah ka, Kalati le Frizia raang sahlo cahrong lai khei khuakheh khy khuakheh tlawnglai ka, hningzuitu vytei khah thawzaang a peh lai he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ma chung taco Alekzandria khuakeh a cangpaw Juda cawngsaw Apolo aa tahpaw khah Efesa khuapui lang cawh a va tlong. Ama cawh bia rei a thai ngeteipaw le Capathai a hnih ngeteipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Abuipaw langpui kong khah cawngpah ciapaw cang ka, Johan baptisma kong suipaw a hnihpaw a cang naná teitah, Zisu kong khah lungtho ngetei tah le ahmang teitah a cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Synagog letah raechah ngetei tah Khazing bia cawh a rei. A reipaw bia cawh Akuila le Prisila tah aa thui tihtah ma ve law tatah tah he ka, Khazing langpui kong khah a se vy tah aa ching pase. ");
INSERT INTO zypNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo cawh Akhaia raang lang khah sei a pachia tihtah uny sahlo takhei thawthonah bia ching he ka, ma letei a ungpaw hningzuitu sahlo khah achaw teitah za hluihlang my lo tatah ca aa kua he. A va phah tihtah Khazing ningdonah thong tei, zingtu a cangpaw sahlo khah ahlupui a bawkhang he. ");
INSERT INTO zypNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Zecawtamaw tatah zawpui hme letei bia a einah letah Juda cawngsaw sahlo cawh naa reipaw ahmang be tatah biatah teitah a ei he. Zisu heh Khri cawh a cang tatah Capathai bia hmang tah a sopah he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo cawh Korin khuapui letah a ung thlang chung takhei Paul cawh ma raang chung sahlo khah tlawnglai ka, Efesa khuapui khah a va phah. Ma leco hningzuitu thaikhehpaw sahlo khah hmuh he ka, ");
INSERT INTO zypNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“Naa zing ning tai khei Thlawpaw Pathai naa ting thah maw?” tatah a hae he. Aaning sahlo taco, “Ting bei peh. Thlawpaw Pathai a ung tahpaw kaa thui bang tlung be,” tatah aa chai. ");
INSERT INTO zypNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Macawtaco Paul tah, “A cang caco, zehapaw baptisma maw naa cang?” tatah tah he ka, “Johan baptisma,” tatah aa palei. ");
INSERT INTO zypNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul taco, “Johan baptisma cawh angepachihnah baptisma a cang. Johan taco zawpuipaw khah ama a hninglang tei a vong leimeipaw cawh zing rua pawtah khei a ching he, ma paw cawh Zisu a cang,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mataico, aaning sahlo cawh ma bia khah aa thui tihtah Abuipaw Zisu ming tah baptisma cawh a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paul taco aa cung letah a kih cawh a pahnia tihtah aa cung lekhei Thlawpaw Pathai cawh za tlung ka, rei thuilypaw sahlo khei aa rei thlaw he ka, bia cawh aa phy. ");
INSERT INTO zypNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ma cawngsaw sahlo cawh aa dawngkasawny tah pahrawhluihning hrong a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mataico, Paul cawh synagog lang a nae ka, thlah thung chung Khazing painah raang kong cawh aa thuithai nápawtah raechah ngetei tah a rei. ");
INSERT INTO zypNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Canghrasala, aaning sahlo chung letei chykheh cawh aa lung lai ngetei ka, zing du bei he. Khazing Langpui chah be tatah zawpui thuí khei aa tah. Macawtaco Paul takhei aaning sahlo cawh a seisai he. Hningzuitu sahlo khah a chui he ka, Tiranas cawngpahnah ing lekhei a ning tating tah bia a reihrui tei he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ma hraco kung hning chung a tua cawtah Asia raang chung letei a ungpaw Juda cawngsaw vytei le Grik cawngsaw vytei taco Abuipaw bia cawh aa thui. ");
INSERT INTO zypNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Khazing tah Paul hmang khei ningang chuipaw hming a tua. ");
INSERT INTO zypNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ama a pavua le pai sahlo khah a dang lypaw tongsah rua pawtah tle lai he ka, a tongpaw cawh aa danglynah taco thlaw he ka, thlawpaw pialuipaw tah a piasai he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Thlawpaw pialuipaw papia lai rua pawtei a khia laipaw Juda cawngsaw thaikhehpaw sahlo tah khachia papianah lekhei Abuipaw Zisu ming khah hmang a pachia he. Aaning sahlo taco, “Paul tei a reipaw Zisu ming tah ka pia law kaa ca tah,” tatah aa tah lai. ");
INSERT INTO zypNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ma hratei a tah laipaw he cawh Juda tlangbui macang, Skeva a sawcapaw pasarih tlaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ning kheh cawh thlawpaw pialuipaw tah aaning tlaw cawh, “Zisu cawh hnih neh ka, Paul zong ka hni, canghrasala naaning heh aho sahlo maw naa cang?” tatah a chai he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mataico, thlawpaw pialuipaw tei a pahrangpaw cawngsawpaw taco a zyhno he ka, a dunahpaw khei a tua he. Ma hratei a sah pui tah a tuanah caw he taco aa thlekalong tah aa thi cho khei ma ing taico a sai he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ma hratei a cangpaw khah Efesa khuapui letei a ungpaw Juda cawngsaw le Grik cawngsaw sahlo tah aa thui tihtah aa zongmingtei co aa ci tho ka, Abuipaw Zisu ming cawh aa pasang lo leimei. ");
INSERT INTO zypNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Taico, zingtu sahlo mehlupui zong cawh a vong he ka, aa tuapaw hmingchahly khah ming hringpaw hai letah aa phy. ");
INSERT INTO zypNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ca-ia a thaipaw cawngsaw sahlo zong tah aa cabu sahlo khah va tle he ka, zawpui hme lekhei me tah aa ro. Aa cabu sahlo mai cawh aa patong tihtah a pahlawng tah ngung tangka 50,000 mai a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ma hraco Abuipaw bia cawh a ka lo leimei ka, hmingtuakhynah khatah a chang lo leimei. ");
INSERT INTO zypNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ma vytei hming a tlung khy taihei, Paul cawh Masidonia le Akhaia raang sahlo cahrong khei Jerusalem lang khah sei pawtah a pachia. “Ma leco ka phah khy taitah Rom zong ka va tlongpai a,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Asia raang chung letah a cawngpe a ung kaa lekhei ama a bawtu cawngsaw pahning a cangpaw he Timote le Erasta cawh Masidonia lang khah a thlaw he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ma cai hrawnghrang leco Abuipaw langpui kong letah hnahnawhnah biatah teitah a chuh. ");
INSERT INTO zypNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Artimi khazingno lingthlaw khah ngung tei a tuapaw Demitria aa tahpaw ngung sysahpaw takhei lingthlaw a tua thaipaw sahlo cawtah tangka hmuhnah rai a hlupui a chuakhui. ");
INSERT INTO zypNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Aaning sahlo le ma rai khatei a peitle tah rai a hrepaw sahlo khah hmingkheh tah y he ka, “Vesaw sahlo, ma rai taihei tangka ahlupui kaa hmuh tah cawh naa hnipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Taico ma Paul aa tahpaw cawngsawpaw tahei Efesa khuapui letah mehnung hlupui le Asia raang letei cawngsaw ahlupui khah aa lungsingsah he ka, lang a pavesah he tah cawh thui he ceh ka, naa hmuh. Ama taco cawngsaw tei tuapaw khazing sahlo cawh khazing hmuisui cang bei he tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ma hratei a cang caco, kaa rai heh hmezawnah hnui khawhly tah a ungpaw long cang lytah a laisuipaw Artimi khazingno behnah ing zong silang hnui be ca ka, Asia raang le khazawpui tei aa behpaw khazingno a rungnawnah zerei lytah a ung a,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ma bia cawh aa thui tihtah aa thingae ngetei ka, “Efesa cawngsaw aa Artimi khazingno cawh laisui ky seh!” tatah aa y. ");
INSERT INTO zypNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","A ry hlai tah khuapui pungpaluh letah buainah a chuh. Paul tei Masidonia taitah khua a va tlong hruipaw he Kaia le Aristarka khah tle he ka, vaitlang a pungnah ing lang khah aa seikhui he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul cawh zawpui hme lekhei chua a du naná teitah hningzuitu sahlo takhei aa thly. ");
INSERT INTO zypNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ma raang chung letei abui macang a cangpaw he a vesaw sahlo takhei hmai vaitlang a pungnah ing lang chua ly ruapaw tah bia aa caw. ");
INSERT INTO zypNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Macawtaco thaikhehpaw takhei sangkheh kong khei y he ka, thaikhehpaw tah ahringpaw kong khei y he ka, a pahmonah pawhe cawh lu a ri thlang. Cawngsaw a hlu cai taco zecawtamaw ma lekhei aa chua tahpaw hmai khah hnih bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juda cawngsaw sahlo takhei Alekzandar cawh a hmelang va nang he ka, zawpui thaikhehpaw takhei a reipaw bia khah aa yso. Alekzandar taco zawpui hme letah a reikainah bia rei rua pawtah khei zawpui cawh de law tatah a kiá khei a tuapah he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Canghrasala Juda cawngsaw a cang tahpaw khah aa hni tihtah aa zongmingtei co hmokheh teitah, “Efesa cawngsaw sahlo aa Artimi khazingno cawh rungnaw ky seh,” tatah suimehlang pahning chung a y he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Khuapui cazi a cangpaw taco zawpuipaw cawh de law, tah he ka, “Efesa cawngsaw sahlo, Efesa khuapui cawh a rungnawpaw Artimi khazingno behnah ing le avai lang tah a tlahpaw a lingthlaw a mingkaitu a cang tahpaw alui cung pungpaluh tah hnih thlang bei he maw? ");
INSERT INTO zypNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Macawtaco ahotahmai ma bia heh eikhypaw a cangly cawtah naa de a hy thlang, pacang huaha lytah zehming hmai tuapaw cang be. ");
INSERT INTO zypNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ma cawngsaw sahlo naa va chuakhuipaw he tahei kaa behnah ing zong rawh be ca he ka, kaa khazingno zong reipachia hrah bei he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mataico, Demitria le a vesaw raihretu sahlo tah taza aa cui du he a cang caco, biacenah ing zong hong thlang he ka, biacetu sahlo zong a ung thlang he. Aa cui khy thlang he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Hming sangkheh va chuakhui naa du vy a cang caco, khuapui khongsil letah biachawnah tuapaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ma hratei a cang ly caco, atoning letei hming a cangpaw rawng tahei kaaning cawh hnahnawhnah naa chuasah tatah bia hnui khy peh ka, ma hratei a cang caco aaning bia kaa palei khy nápaw he ung be, taico zecawtamaw tatah ma heh a hrang a hnui lypaw a cang,” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ma hratei bia a rei khy taico a pahmopaw mehnung vytei khah a disah he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Khuachung letei hnahnawhnah cawh a de taitah, hningzuitu sahlo khah Paul tah bia caw he ka, thawzaang a peh khy tai he tah a dang pawtah ung my lo tah he ka, Masidonia raang lang sei pawtah a tho. ");
INSERT INTO zypNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ma pai chung leco tlawnglai ka, zingtu sahlo khah pasynah bia a hlupui ching he ka, a hning tah Grik raang cawh a va phah. ");
INSERT INTO zypNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ma leco thlah thung caang ka, Siria raang lang khah tuilawng tah sei pawtah a pachia ning tah Juda cawngsaw thaikhehpaw tah thaw aa pa za tahpaw khah a thuinah cawtah Masidonia raang chung khei sei kaw a pachia. ");
INSERT INTO zypNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Paul cawh Beria khua cawngsawpaw Pirha a sawcapaw Sopater le Thesalonika khua taitah Aristarka le Seikanda, Derbe khuapui taitah Kaia le Timote, Asia raang taitah Taikhika le Trofima tahpaw sahlo takhei aa zui lai. ");
INSERT INTO zypNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Aaning sahlo heh hmelang seihlang he ka, Troas khua letah aa ma haw. ");
INSERT INTO zypNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Mataico, kaaning cawh Thino pahlawh lypaw Very Panaw khy taikhei Filipi khua taitah tuilawng tah sei he peh ka, ningpangaw khy tah Troas khua leco a sei hlangpaw sahlo cawh va pange he peh ka, ma leco ning sarih ka caang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Zaa kheh letei hmetaw caipaw a cangpaw ning letah Abuipaw zairia a hrong pawtah kaaning cawh kaa va chua. Paul tah zawpuipaw khatah bia rei ka, aningthlamongpaw letah sei a pachia cawtah zaicing tai bia a rei. ");
INSERT INTO zypNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ka pahmonah pawhe peh a cungkhang leco me-ing ahlupui khah aa vang. ");
INSERT INTO zypNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Thlalang ingkaw leco Zutikha aa tahpaw satlepaw cawh a ty thlang ka, Paul tei bia a reipaw khah a sy tunah cawtah a meh ku ngetei ka, a hning taco a ihning pai ka, ing dawh thungpaw thlalang ingkaw taico alui lang cawh tlahthlah ka, aa lah ning tah a thi thah. ");
INSERT INTO zypNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul cawh cungthlah ka, satlepaw cawh va pazah ka, a va pongchai. Taico zawpui khah, “Naa thlawzawng kheh seh, a hring thlang hi!” a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mataico Paul cawh ka ke kaw ka, Abuipaw zairia cawh tingtua he ka, aa e. Khua dui ky tai bia cawh rei ka, a rei khy taico a piathlah. ");
INSERT INTO zypNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Zawpui taco satlepaw cawh ing lang khah hring dang pawtah seikhui he ka, thlawlung teitah aa ung. ");
INSERT INTO zypNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paul cawh tlanglang tah Asos khua lang sei a pachia. Kaaning cawh tuilawng tah Asos khua lang seihlang peh ka ma khua leco a ma phah. ");
INSERT INTO zypNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mataico, Asos khua leco a va ma tong khy taitah tuilawng cung lang cawh ke he peh ka, Mitilin khuapui lang cawh kaa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Aningthlamongpaw cawh ma khua taico tuilawng tah sei he peh ka, Khio tuiraw raechai khah kaa va phah. A ningthlamongpaw leco Samos tuiraw lang cawh sei he peh ka, a hazainingpaw leco Mileta khuapui cawh kaa va phah. ");
INSERT INTO zypNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pentikos Panawnah ning khah a ne cawtah khei Paul cawh Jerusalem khuapui khah phah tlamang du ka, Asia raang chung letah cai pachang ly rua pawtah khei Efesa khuapui cawh tuilawng tah khungsai pawtah a pachia. ");
INSERT INTO zypNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileta taico Paul takhei Efesa khuapui letei khrisawbu macang sahlo khah bia a caw he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mataico aa va phah tihtah aa hai leco, “Asia raang chung ka va phah taw ning taitah naaning kha ka ung chung vytei khah zemaw ka tua tahpaw cawh naa hni thlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Juda cawngsaw sahlo tah thaw pawtah aa pa ruiphiapaw tahei ruhanah a pa peh naná teitah Abuipaw rai cawh a pany ngetei tah le mehthli cho tah ka hre. ");
INSERT INTO zypNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Naaning naa cawtah a chahnaipaw a cangpaw Khazing bia vytei naaning ching rua pawtah dethlang lytah ka ungpaw khah hnih he ceh ka, zawpui thuí tah cawngpah he neh ka, ingkheh khy ingkheh ka cawngpah laipaw he zong khah naa hni. ");
INSERT INTO zypNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Juda cawngsaw sahlo kha Grik cawngsaw sahlo kha, a ngepachih hmotah Khazing pange la, kaa Buipaw Zisu cawh zing my lo, tatah ka cawngpah he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Taico, atoheh cawh Thlawpaw Pathai langhruinah zui tah Jerusalem lang sei a neh ka, ma lekhei ka cung letah zehming maw a tlung a tahpaw cawh hnih bei neh. ");
INSERT INTO zypNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Khua ting maikaw letah thongtlahnah le ruhanah ka tong a tahpaw suipaw heh Thlawpaw Pathai hnisahnah thongtah ka hnipaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Canghrasala, Abuipaw Zisu tah a pakhingpaw rai Khazing ningdonah thawngchawbia y khui rai heh ka paling tei, a saipasinah heh ka patlung khy pawtei a cang caco, ka cung letah zehming a tlung zong tah ka ze a pui beh. ");
INSERT INTO zypNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Khazing painah raang kong phung ka reipaw a thuipaw naaning vytei tahei pa hmuh khaw bei ceh taheh atoheh ka hni myca. ");
INSERT INTO zypNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Macawtaco, naa hrong letah pakhehkheh a thlary a thih caco, kama cawh mochiapaw cang bei neh taheh naa hai letah atoning lehei ka rei. ");
INSERT INTO zypNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Zecawtamaw tatah Khazing dunah khah achangdiná tah ka ca ching thlu thah he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Naaning teitah a vai la, naa mingkai ruapaw tei Thlawpaw Pathai tah a ca pehpaw he tuurung sahlo khah achaw teitah mingkai my lo. Khazing tah Ama a thisai tei a cawhpaw a khrisawbu a kingtu tuuking cang my lo. ");
INSERT INTO zypNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ka sei hning tah a hrangpaw chahnia hratah a cangpaw cawngsaw naa hrong letah va chua he ka, tuurung khah hua bei he tahpaw ka hni. ");
INSERT INTO zypNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Naaning chung lilaw tai tahmai tah hningzuitu sahlo khah kaaning lang a bai na he seh tatah biahmuisui khah aa pachia a. ");
INSERT INTO zypNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Macawtaco a vai my lo! Kung thung chung ching kha zai kha tai lytah ka mehthli khatei zekhah tamaw raering ka ca peh he tah khah monghly khe lo. ");
INSERT INTO zypNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Atoheh naaning a ca tua hry khypaw he le mehpathai vytei hrong letah bonghnang ry a ca pei khypaw he Khazing le a ningdonah bia letah ka ca vosah myca he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kama cawh aho aa sui, aa ngung, aa chaichi zong khah iavawnah hnui bei neh. ");
INSERT INTO zypNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kama leh ka kih tei hei ka hiapaw le ka vesaw sahlo aa hiapaw cawh ka chuakhui thlang tahpaw cawh naaning tah naa hni thlangpaw a cang. ");
INSERT INTO zypNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Thawzaang a diapaw sahlo khah bawkhang pawtah a thaw tah rai naa hrepaw a cang tah cawh ka rai hrepaw vytei khei ka ca hmuhsah he. Abuipaw Zisu hrahring tah, ‘Hmuhnah navy co pehnah letah bonghnang a ung vy,’ tatah a tahpaw khah a thui thlang mylo,” tatah a tah he. ");
INSERT INTO zypNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ma bia a rei khy taihei aaning sahlo khaco a khuh panai he ka, thlaw aa chang. ");
INSERT INTO zypNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Aa caw hmo khei Paul cawh a pawngchai he ka, ama cawh aa hnang. ");
INSERT INTO zypNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pa hmuh khy khaw bei ceh, tatei a tahpaw he bia takhei aa nge a chiasah ngetei he. Mataico tuilawng tai khah aa va chuithlah. ");
INSERT INTO zypNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","A dangpaw tah ung my lo tatah kaa tah khy tai tah tuilawng cawh ke peh ka, Kos tuiraw lang cawh kaa pange. A ningthlamongpaw cawh Rhoda tuiraw lang sei peh ka, mataico Patara khuapui lang kaa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Fonisia raang lang a seipaw tuilawng hui peh ka, ke peh ka, kaa sei. ");
INSERT INTO zypNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mataico, Saipras tuiraw a lang tai khei a khunglang tai thuilang tah sei peh ka, Siria raang lang cawh kaa palang. Tair khua letah cung peh ka, ma leco kaa lawng khah a hming aa chungthlah. ");
INSERT INTO zypNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ma letei a ungpaw hningzuitu sahlo cawh hui he peh ka, aaning khaco ningsarih ka caang he peh. Thlawpaw hnisahnah thong khei, Paul cawh Jerusalem khuapui lang sei haitei bei ceh tatah aa thly. ");
INSERT INTO zypNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Canghrasala kaa cai cawh chang ka, a tho peh ka, kaa sei. Zingtu a cangpaw vytei sahlo le aa nupui leh le aa sawtei leh tah khua khung tai ma thlaw he ka, rili ngaekang leco kaa khuh panai he peh ka, thlaw kaa chang. ");
INSERT INTO zypNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pakheh le pakheh khah a dang pawtah ka tah khy tai he peh tah tuilawng cung lang cawh ke peh ka, aaning zong ing lang aa kawkaw hrah he. ");
INSERT INTO zypNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tuilawng co Tair khua taitah sei peh ka, Ptolemai khuapui letah kaa cung. Ma leco zingtu uny sahlo khah bia a ching he peh ka, aaning khaco ning kheh ka caang he peh. ");
INSERT INTO zypNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ningthlamongpaw cawh a tho kaw peh ka, Sisaria khua cawh phah peh ka, evangelist cang katei apostol sahlo bawkhangnah raihretu pasarih chung letei pakheh a cangpaw Filip a ing letah kaa tlung. ");
INSERT INTO zypNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ama cawh pasae a hnui lypaw sawcanu papali hnui he ka aa zong ming teico bia a phypaw a cang he. ");
INSERT INTO zypNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ma leco ning a sy nong kaa cang khy letah, Akaba aa tahpaw Khazing khuavang pakheh cawh Judia raang lang khei a va chuh. ");
INSERT INTO zypNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kaaning lang cawh a vong ka, Paul a tesong cawh law ka, a kih le a phe letah a pazai ka, “ ‘Ma hrahei Jerusalem letei a ungpaw Juda cawngsaw sahlo tah ma tesong a hnuitupaw heh tongchai he ka, Gental cawngsaw sahlo kih letah aa pae a,’ tatah Thlawpaw Pathai tah a rei,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ma bia cawh kaa thui tihtah kaaning sahlo le ma letei a ungpaw cawngsaw sahlo taco Paul cawh Jerusalem khuapui lang cawh sei haitei bei ceh tatah kaa nawpaw. ");
INSERT INTO zypNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Canghrasala Paul taco, “Zecawtamaw naa caw? Ka lung naa panysah. Abuipaw Zisu ming rawng taco tongchaipaw long hmai cang be, Jerusalem khuapui letah thih rua pawtah hei ka mai paria thlang,” tatah a tah. ");
INSERT INTO zypNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Thly khypaw a cang ly taitah tai peh ka, “Abuipaw dunah cawh tua cang ky seh,” kaa tah. ");
INSERT INTO zypNT_vpl VALUES ("AC21_15","074_2