﻿USE sofia;
DROP TABLE IF EXISTS sofia.ztyNTps_vpl;
CREATE TABLE ztyNTps_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ztyNTps_vpl WRITE;
INSERT INTO ztyNTps_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ba nez ẕen naken che bennen' bi ẕzi'e da' ẕzejní'igekle benne' wen da' ẕinnj ka' ḻe', na' bi nake' toze ḻen benne' doḻa' ka', na' bi žónḻene' tẕen benne' ka' ẕzóagake' Dios cheḻa'ale, ");
INSERT INTO ztyNTps_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","san žebele' dan' žone' kan ẕchi'le X̱anžo Dios, na' kan nak dan' wnnakze' Ḻe', dot ža dot yel ẕlab ḻaže'en. ");
INSERT INTO ztyNTps_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Benne' ni nake' ka to yag da' zoan žoa'a yegw, da' ẕbian da' ẕix̱ chen ḻo byo' chekzen, na' x̱lagen bi žasen. Yógo'te da' žon benne' ni, želžój chawen', ");
INSERT INTO ztyNTps_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","san benne' wen da' ẕinnj ka' kege ki zej nake'. Zej nake' ka to laga' biž dan' žoa be'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Bi yežojgak chawe' benne' wen da' ẕinnj ka' kate' wchi'a ḻaže' Dios ḻégake', na' bi chó'ogak benne' doḻa' ka' gan zej ndobe benne' chawe' ka' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Žaz ḻaže' Dios da' žongak benne' chawe' ka', san da' žongak benne' wen da' ẕinnj ka' chen' ḻégake' gan kwia yí'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","¿Biẕ chen' ẕži'igak benne' yógo'te yež ka' che Dios? ¿Biẕ chen' ẕlab ḻáže'gak benne' ka' da' ẕzoan Ḻe' cheḻa'ale? ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Ẕži'igak benne' wnná bia' ka' chie' Ḻe', na' benne' yolawe' ka' žóngake' toze diža' nich wží'igake' che Dios, X̱ángake', na' che Bennen' wžé Dios chekze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Ẕnnágake': “Yebéj kwinžo ḻo ná'gake', na' wzoažo cheḻa'ale da' bchí'igekle' žo'o.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Gan že' X̱anžon' ya'abá chie' žẕiže'. Žon ditjle' da' žek ḻáže'gake' góngake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","na' ḻo yeḻa' ẕža'a chie' ẕdiḻe' ḻégake', na' ḻo yeḻa' yichj ža'a chie' ẕchebe' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Ẕnne': “Ḻo ya'a la'y chia', Ya'a Sión ba bzoa' Bennen' nna bi'e ḻo wlaza' neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Ẕnna Bennen': “Wzenla' ḻe'e da' gož X̱anžon' neda'. Gože' neda': Le' nako' Ẕi'na'. Na'a ža naka' x̱o'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Wnnable neda', na' gonna' Le' yógo'te yež ka', na' gak chio' dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Wchinnjo' yež ka' ḻen to bar ya, na' ka to že'e yo wzoẕjo' ḻégaken.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Na'a, ḻe'e, Benne' wnná bia' ka', le yenle da' ni da' ẕzejni'ila' ḻe'e. Le wsedle da' ni da' ẕzenla' ḻe'e, ḻe'e na' ẕnna bia'le ḻo yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Le gon da' ẕnna X̱anžo Dios, ḻo yeḻa' ẕžebe chele, na' ḻo yeḻa' žeẕize chele, le yebele ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Le gape ba la'ne Ẕi'ne' nich bi že'e, na' bi kwia yi'le ḻo nez chele, dan' ḻa' žá'atie' Ḻe'. Ba nez ẕen naken chegak yógo'te benne' ka' žx̱en ḻáže'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","X̱ana' Dios, ba nyanḻe'e benne' ka' ẕžá'agake' neda'. Benne' zante ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Benne' zante ẕnnégake' chia', na' ẕnnágake': “Bi yeslá Dios ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","San Le', X̱ana' Dios, žape chi'o neda'. Nako' yeḻa' baní' chia', na' ẕzo' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Wžéžyi'a, na' bḻiža' X̱ana' Dios, na' Ḻe' bechebe' chia' gan zoe' ḻaw ya'a la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Gota'a, na' wtasa', na' bebana' dan' ben choch X̱ana' Dios neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Bi žeba' chi mil benne' ka' ẕdíḻ-ḻengake' neda', benne' ka' zej nyechjle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Wyás, X̱ana' Dios. Beslá neda', Dios chia', na' wdáp x̱ága'gak benne' ka' ẕdíḻ-ḻengake' neda', na' bdichj láye'gak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yeḻa' weslá za' ḻo no'o, X̱ana' Dios. Ben chawe' benne' chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Bechebe chia' kate' žḻiža' Le', Dios. Le' ẕchi'a ḻáže'kzo' da' žona'. Kate' wzóa' ḻo da' zede, Le' ben chocho' neda'. Beyache' ḻaže'l neda', na' benle da' ẕcháḻjḻena' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ẕnna Dios: “Ḻe'e, benne' ka', ¿to chi'ize wzoale neda' cheḻa'ale? ¿To chi'ize ží'ilele da' bi be zaka', na' chejḻe'le da' wen ḻaže'?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Žaḻa' nnézlele ba wžé X̱anžo Dios bennen' žape' Ḻe' ba la'ne. X̱anžo Dios yenle' chia' kate' wḻiža' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Le žebe ḻaw Dios, na' bi gonle doḻa'. Le wláb ḻaže' chie' kate' dele gan ẕtasle, na' le soa žize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Le got biado' ka' ḻawe' Ḻe' ḻo da' nak chawe', na' le wx̱én ḻaže' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Benne' zante ẕnnágake': “¿Noẕ benne' gon chawe'e neto'?” Ḻo yeḻa' ži'i ḻaže' chio' bwia neto', X̱anto' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Le' bzo' yeḻa' žebele ḻo yichj ḻáẕda'wa', dan' nakžen ẕen ka da' zej nape benne' ka' zej nápḻi'e ẕoa', na' x̱is uba waḻ. ");
INSERT INTO ztyNTps_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ḻo yeḻa' ẕga'n chawe' gata'a, na' tasa', dan' ẕnno' Le', X̱ana' Dios, naka' chawe' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Bze nag da' ẕnnia', X̱ana' Dios. Be' ḻaže' kan ẕbeže ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Le' nako' X̱ana', na' nako' Dios chia'. Benle da' žḻiža' Le', dan' ẕcháḻjḻenteza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","X̱ana' Dios, chbal-le yenlo' chi'a. Zildo' ḻa'kza' ḻawo' Le', na' kweza' da' yi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Nako' Dios bi žaz ḻažo'o da' bi nak chawe'. No benne' žone' da' ẕia bi soakze' gan zo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Bi žo'o latje ḻa'gak benne' wen da' ẕinnj ka' ḻawo'. Bi ẕḻe'elo' chawe' yógo'te benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ẕchinnjo' ližgak benne' ka' žon ḻáže'gake'. Ẕzo' cheḻa'ale benne' wetw benách ka', na' no benne' žon ḻaže'e, ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","san neda' wak choa'a ližo' dan' nží'iḻe'elo' neda'. Wká'n ẕena' Le' ḻo yodo' la'y chio' ḻo yeḻa' ẕžebe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Bsedle neda' gona' da' chawe' ḻawo' Le', X̱ana' Dios, dan' ẕžá'aḻe'egak benne' ka' neda', benne' ka' bi ẕḻé'egekle' neda' chawe'. Bche' neda' nez chawe' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Benne' ki bi ẕnnágake' da' naken da' li. Nža' yichj ḻáẕdo'gake' da' kegle. Lbá'gake' zej naken ka yežw ba ka' chegak benne' gat ka' da' nyáljwgaken. Ẕnnágake' diža' chawe' ka', san žon ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Ben zi' benne' ka', Dios. Ben ga chejchégwgake' ni'a che x̱tíža'gakkze'. Dan' nyanḻe'e da' bi nak chawe' da' žóngake', na' dan' bží'igake' chio' Le', bnnita' ḻégake' cheḻa'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","San yebéḻe'egekle benne' ka' žx̱en ḻáže'gake' Le'. Kwežeyá'gake' ḻo yeḻa' žebele dan' žákḻeno' ḻégake'. Benne' ka' zej nži'ile' Le' yebéḻe'egekle' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Gon cháwe'kzo' benne' chawe', X̱ana' Dios. Dan' žaz ḻažo'o bennen', gape chi'o ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","X̱ana' Dios, bi tiḻo' neda' ḻo yeḻa' ẕža'a chio', na' bi gono' neda' zi' ḻo yeḻa' yichj ža'a chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Beyache' ḻaže'l neda', X̱ana' Dios, dan' bi zoa' chawe'. Beyón neda', X̱ana' Dios, dan' ẕzáka'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Že' zede yichj ḻáẕda'wa', na' Le', X̱ana' Dios, ¿batx̱ gákḻeno' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Da, X̱ana' Dios, beslá be' da' nakkza'. Ḻo yeḻa' ži'i ḻaže' chio' beslá neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Gan zej nnita' benne' gat ka', bi žejsá' ḻaže' no benne' Le'. Ḻo latje chegak benne' gat ka', ¿noẕ benne' wká'n ẕene' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ba žedó ḻaža'a dan' ẕbeže ḻaža'a. Yógo'te yel ẕbise gan dia' ḻen nis ẕbeža'. Žesbisan' ḻen nis ẕbeža'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ba nyejw yej ḻawa' dan' ẕbéžeḻi'a. Ba bebižkze nis dan' yožen yej ḻawa' dan' ẕžá'aḻe'egak benne' ka' žsáka'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Le kwas ga zoa' ni, yógo'tele žonle da' ẕinnj, dan' ženle Dios ẕbéžeḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","X̱ana' Dios ba ženle' da' žáta'yoela' Ḻe'. Ẕzi' X̱ana' Dios da' ẕcháḻjḻena' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Žedoé'egekle, na' zej že' zedḻe'e yógo'te benne' ka' bi ẕḻé'egekle' neda' chawe'. De chgi' kwásgake' gan zoa', na' yedoé'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","X̱ana' Dios, žx̱en ḻaža'a Le'. Beslá neda' ḻo na'gak benne' ka' žsáka'gake' neda', na' gokḻen neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","nich bi séngake' neda' ka žon bež yix̱e', na' bi wchéza'gake' neda' gan bi zoa no benne' gákḻene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","X̱ana' Dios, cha' bena' neda' ki; cha' zoa bi da' ẕinnj da' ben ni'a na'a; ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","cha' zoa bi da' bi nak chawe' da' bena' che no benne', bennen' ẕgá'nḻene' neda' chawe', (san neda' gókḻena' bennen' bi ẕḻe'ele' neda' chawe' ḻa'kze bi be bena' chie') ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","cha' ki bena', be' latje bennen' bi ẕḻe'ele' neda' chawe' kwia ḻaže'e neda', na' sene' neda'. Be' latje bennen' wleje' neda' ḻo yo, na' wca'ne' ca'ze yeḻa' ẕen chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","X̱ana' Dios, ḻo yeḻa' ẕža'a chio', wzó ža'. Bdiḻ-ḻen benne' ka' žsáka'gake' neda' ḻo yeḻa' ẕža'a chégake'. Bseḻa' da' gakḻen neda' kate' žin ža wchi'a ḻažo'o da' žak cheto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Benne' yógo'te yež ka' ḻá'gake' ḻawo' Le'. Wnná bia' benne' ka' ḻo yeḻa' ẕen chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Le', X̱ana' Dios, wchi'a ḻažo'o benne' yógo'te yež. Bchi'a ḻaže' neda' ka nak da' chawe' dan' bena', dan' bena' ḻo da' nak ḻi ḻaže' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Bchinnj da' žongak benne' wen da' ẕinnj ka', san ben chawe' benne' chawe' ka', dan' nako' chawe', Dios, na' ẕwio' da' yo'o ḻo yichj ḻáẕdo'gak yógo'te benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Dios na'kze žape chi'e neda'. Žeslé' benne' ka' zej nake' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Nak chawe' ka ẕchi'a ḻaže' Dios da' žongak benne' ka'. Yógo'te ža ẕža'a Dios che da' žongak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Cha' bi yeyát ḻáže'gake' Dios kweje' ya ntoche' chie' ka'. Za' wsíe' yag ntóche'do' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Za' wkonle' žin ya chie' ka' che wdiḻe. Za' wsíe' yag ntóche'do' ka' zoa yi' ḻáwe'gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Benne' wen da' ẕinnj ẕkweze' da' ẕia da' gone'. Yo'o yichj ḻáẕda'we' da' ẕinnj da' gone', na' gone' da' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ba bche'ne' to yežw gže' nich yéx̱jwgak benne' ka' ga na', san bex̱jwe' ḻekze' ḻo yežwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Da' ẕinnj da' bene' žesbaga'n ḻekze' ẕia, na' da' bsake'e benne' ka' yebí'i Dios chekze' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Wká'n ẕena' X̱ana' Dios ni'a che da' chawe' da' žone' na' góḻteza' che La la'y che X̱ana' Dios, Benne' ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","X̱anto' Dios, ẕente nak La la'y chio' Le' do ẕente yežlyó. Nakže ẕen yeḻa' ẕen chio' ka ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Žoḻgak x̱kwide' ka', na' bi'do' že'n ka', ka naken. Yo'o chawo'o gan bi gak ḻa'gak benne' ka' bi ẕḻé'egekle' Le' chawe'. Ẕzoa žio' benne' ka' bi ẕḻé'egekle' Le' chawe', na' benne' ka' ẕzóagake' Le' cheḻa'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Kate' ẕwia' ya'abá dan' beno' Le', na' byo', na' belj ka', da' ka' bzo' to ton, ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","na' ẕnnaba': ¿biẕkze zej nak benne' ka', dan' že' ḻažo'o ḻégake'? ¿Biẕkze zej nak benne' ka', dan' ži'o wnné yoe chégake'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Beno' ḻégake' yeláte'ze gax̱jw ka nako' Le', na' bzo' chégake' yeḻa' ẕen, na' yeḻa' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Wnnakzo' nna biá'gake' yógo'te da' ka' beno'. Yógo'ten bdio' ḻo ná'gake': ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","ẕila' ka', na' bež ka', na' yógo'te bia yix̱e' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","bia zej nnita' x̱ílgakba', na' bel ka', na' yógo'te bia ka' zej nníta'ba' ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","X̱anto' Dios, ẕente nak La la'y chio' Le' do ẕente yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","X̱ana' Dios, dot ḻaža'a wká'n ẕena' Le'. Wzenla' benne' ka' ka nak da' ẕente da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Yebekzla', na' goḻkza' ka nak chio'. Goḻa' che La la'y chio' Le', nako' Dios ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Bẕonnjgak benne' ka' bi ẕḻé'egekle' neda' chawe'. Bejchégwgake', na' wnítgekle' ḻawo' Le', ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","dan' ẕzoa chawo'o da' chawe' da' žona'. Ži'o latje blo chio', na' cháwe'do' ẕchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Bdiḻo' benne' yež ka', na' bchinnjo' yo'o chegak benne' wen da' ẕinnj ka'. Bsoḻo' lagak benne' ka' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Wžía yi'gak benne' ka' bi ẕḻé'egekle' neda' chawe'. To chi'ize zej nbia yi' latje chegak benne' ka', na' yež chégake' ka', da' ka' bchinnjo' Le'. Nitó benne' chejsá' ḻaže'e benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","X̱anžo Dios zoakze' to chi'ize. Bkweze' latje blo chie' gan wchi'a ḻaže'e benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ḻo da' chawe' wchi'a ḻaže'e benne' ka' dot yežlyó, na' benne' yógo'te yež ka' ḻo da' nak ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","X̱anžo Dios nake' ka to gan chejnníta'gak chawe' benne' yache' ka', kate' žin ža che da' wžía yin' benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Benne' ka' zej nónbi'e Le', X̱anto' Dios, wx̱én ḻáže'gake' Le', dan' bi wléj yichjo' benne' ka' žíljgake' Le', X̱anto' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Le goḻ che X̱anžon', Bennen' zoe' yež Sión. Le wzenle benne' yež ka' ka nak da' bene', ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","dan' žejsá' ḻaže'e chegak benne' ka' ẕzáka'gake', na' yezi'e wzón che benne' wetw benách ka'. Bi gaḻ ḻaže'e da' žḻižgak benne' yache' ka' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Beyache' ḻaže'l neda', X̱ana' Dios. Bwia da' ẕzaka'a ḻo na'gak benne' ka' bi ẕḻé'egekle' neda' chawe'. Le' bekó'o neda' ḻo na' yeḻa' got ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","nich wzenla' benne' ka' da' ẕka'n ẕena' Le' gan ẕdóbgake' ḻo yež Sión, na' yebéḻe'ela' dan' besló' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Chejchazgak benne' yež ka' ḻo yežw da' bché'ngake'. Chejcházgake' ḻo do yeḻj da' bdíx̱jgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","X̱anžo Dios bḻoe'ele' kan ẕchi'a ḻaže'e, dan' wbága'gak ẕia benne' ka' bi zej nake' chawe' ni'a che da' béngakkze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Benne' bi zej nake' chawe' ka' cházgake' ḻo yi' gabíl, yógo'te benne' ka' žaḻ ḻáže'gake' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Kege to chi'ize gaḻ ḻaže' Dios benne' yache' ka', na' kege to chi'ize nitle da' žx̱en ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Wzó ža', X̱ana' Dios. Bi go'o latje benne' ka' wká'n ẕen kwíngake'. Ḻa'gak benne' yež ka' ḻawo' Le' nich wchi'a ḻažo'o ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","X̱ana' Dios, ben ga žébegak benne' ka' Le'. Yeyónbia'gak benne' yež ka' zej nake' benachze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","X̱ana' Dios, ¿biẕ chen' zo' zi'to'? ¿Biẕ chen' ẕkache' kwino' kate' ẕzáka'gak benách chio' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ḻo yeḻa' ẕka'n ẕen kwin benne' bi nake' chawe' ẕbia ḻaže'e benne' yache', san chejchaze' ḻo da' bdix̱jwe' nich wžía yi'e bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ẕka'n ẕen kwine' ni'a che da' ẕze ḻaže'e. Ẕnne zi'e bennen' ẕdan ḻaže'e yeḻa' gape, na' ẕka'ne' ka'ze Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ḻo yeḻa' ẕka'n ẕen kwin benne' bi nake' chawe' bi žape' Dios ba la'ne, na' ẕnne' bi zoa Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Žónteze' da' ẕinnj, na' ẕnne' bi wchi'a ḻaže' Dios ḻe' ni'a che da' žone'. Ẕzoe' cheḻa'ale benne' ka' ẕží'igake' chie' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Ḻo yichj ḻáẕda'we' ẕnne': “Bi be gak wsejw x̱neza'. Batkle bi gak chia' da' bi naken chawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ẕnnáteze' da' kegle, na' da' wen ḻaže', na' ẕkache'lanteze'. Diža' ka'ze, na' diža' yaḻze ẕžójgaken žoe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Ẕkache' kwine' žoa'a yež nich sene' benne' ka'. Bagáche'ze žote' benne' ka' ẕdégakze' ga na'. Ẕwíalanze' nich gak bi gone' chegak benne' yache' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Bagáche'ze ẕbeze' ka žon bež yix̱e'. Ẕbeze' nich gak sene' benne' yache' ka'. Kate' ẕzene' benne' yache' ḻo do yeḻj chie', na' ẕchi'e ḻe' chekze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Kan žon bež yix̱e' zóateze' x̱íti'e ḻáwlegak benách ka', na' ẕzene' benne' zan ḻen ne'e waḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Ḻo yichj ḻáẕda'we' ẕnne': “Naḻ ḻaže' Dios benne' ki. Bkache' ḻawe', na' bi ḻe'ele' da' žona'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Wzó ža', X̱ana' Dios, na' bze no'o. Bi gaḻ ḻažo'o benne' yache' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","¿Biẕ chen' ẕzoagak benne' wen da' ẕinnj ka' Dios cheḻa'ale? Ḻo yichj ḻáẕdo'gake' ẕnnágake': “Bi yezí' wzón Dios neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","San Le' bḻe'ekzlo' da' ni, dan' ẕwio' no benne' žone' da' ẕinnj, na' da' bi nak chawe', nich yezi'kzo' wzón benne' ka'. Benne' yache' ka' ẕde kwíngake' ḻo no'o. Le' žákḻenkzo' bi' wzebe ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ẕkwaso' yeḻa' waḻe che benne' wen da' ẕinnj. Wléj ḻawle da' bi nak chawe' da' bene', dan' bene' bagáche'ze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","To chi'ize nak X̱anžon' Benne' ẕnna bi'e žo'o. Ḻo yežlyó chie' ba wžía yi'gak benne' ka' bi ẕḻé'egekle' Ḻe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Benno' chegak benne' gax̱jw ḻaže' ka' da' wnnábgekle' Le', X̱ana' Dios. Le' ẕkwezo' yichj ḻáẕdo'gak bénne'do' ka' nich wzé nággake' x̱tižo'o, ");
INSERT INTO ztyNTps_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","nich wchi'a ḻažo'o bi' wzebe ka', na' benne' ka' ẕzáka'gake', nich biž bi da' ẕinnj gongak benne' ka' bi zej nake' chawe' chegak bénne'do' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Žx̱en ḻaža'a X̱ana' Dios. ¿Biẕ chen' že'gak benách ka' neda': “Bẕonnj, wyéj ḻaw ya'a ka to byinne”? ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Bwia nga, ẕkwezgak benne' ka' bi zej nake' chawe' yag ntóche'do' ka' chégake'. Ba bx̱óagake' yag ntóche'do' ka' chégake' ḻo do chen, nich gótgake' bagáche'ze benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Chela' kwasgak da' ka' ẕzoagak chochen da' chawe', ¿biẕkze gongak benne' chawe' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","X̱anžo Dios zoakze' latje la'y chie'. Ya'abá na'kze zoa latje blo gan že' Dios. Ẕwíagak yej ḻawe', na' ẕḻe'ele' da' žongak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","X̱anžo Dios ẕbeje' benne' chawe' ka' ḻo da' zede, san bi ẕḻe'ele' chawe' benne' ka' bi zej nake' chawe' na' benne' ka' žóngake' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Wdíe' benne' ka' bi zej nake' chawe' ḻo da' ka' wžía yí'gaken ḻégake', da' ka' zej naken yi', na' sufr da' žeyen ka yeže, na' to be' da' ḻaḻe'e, da' ka' seḻe'e ḻawgak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Ki gone' dan' nak chawe' X̱anžo Dios, na' nži'ile' da' naken chawe'. Ḻé'egekle benne' ḻi ḻaže' ka' ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","X̱ana' Dios, beslá benne' chio' ka' dan' biž zoa no benne' žape' Le' ba la'ne, na' bi zoa no benne' ḻi ḻaže' ládjwgak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Yógo'te benne' ka' žon ḻáže'gekle' ljéžgake' ka'. Ḻo da' wen ḻaže' ẕnnágake' diža' chawe' da' ẕnnágake' nich gon ḻáže'gekle' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","X̱anžo Dios wžía yi'e benne' ka' ẕcháḻjgake' ki, na' benne' ka' ẕcháḻjgake' da' ẕka'n ẕen kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Benne' ka' ẕnnágake': “Da' ẕchaḻjžo gákḻenen žo'o. Wchaḻjžo kan žénelžo. ¿Noẕkze benne' wchi'le' žo'o?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","San ẕnna X̱anžo Dios: “Na'a ḻa'kza' neda' dan' žsáka'gake' benne' yache' ka', benne' ka' ẕbeže ḻáže'gake', na' yeslá' benne' ka' žénegekle' bi da' gona'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","X̱tiža' X̱anžo Dios naken dot da' li. Naken ka ya plat da' wdén ḻo yi', da' ba wdén ḻo yi' gaže chi'i ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Le', X̱ana' Dios, ẕwíakzo' benne' chio' ka'. To chi'ize gape chi'o ḻégake' ḻo na'gak benne' ka' zej nnita' ḻo ža na'a ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Kate' ẕka'n ẕengak benách ka' da' ẕinnj, zej nnita' benne' bi zej nake' chawe' ka' gáte'teze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","¿To chi'ize gaḻ ḻažo'o neda', X̱ana' Dios? ¿Gaḻ ḻáže'tezo' neda'? ¿To chi'ize biž ḻe'elo' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","¿To chi'ize gon byene soela' da' ẕzaka'a? ¿To chi'ize gak nyache' ḻaža'a dot ža dot yel? ¿To chi'ize nna bia'gak benne' yichj ža'a ka' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Bwia neda', X̱ana' Dios, na' bechebe chia'. Ben choch neda' nich bi gata', ");
INSERT INTO ztyNTps_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","na' nich bi nna bennen' bi ẕḻe'ele' neda' chawe', bi nne': “Ba bzex̱jwa' ḻe'.” Benne' ka' bi ẕḻé'egekle' neda' chawe' yebégekle' cha' chejchaza' ḻo da' bi nak chawe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","san neda' žx̱en ḻaža'a Le' yeyache' ḻáže'lo' neda'. Dot ḻáẕda'wa' žebela' dan' žákḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Goḻkza' che X̱ana' Dios dan' žon chawe'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Benne' ḻaẕdo' zide ka' ẕza' ḻáže'gake', na' ẕnnágake': “Bi zoa Dios.” Benne' ki zej nchix̱le yichj ḻáẕdo'gake', na' žóngake' da' bi naken chawe'. Bi zoa no benne' žone' da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","X̱anžo Dios, Bennen' zoe' ya'abá, ẕwie' benne' ka' nich ḻe'ele' cha' zoa no benne' žejni'ile', bennen' žape' Dios ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Yógo'tie' bejchíx̱gekle'. Yógo'tie' zej nchix̱le yichj ḻáẕdo'gake'. Bi zoa no benne' žone' da' naken chawe', nitóe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","¿Bi žejní'igekle benne' ka' žóngake' da' ẕinnj? Ẕzóẕjgake' benne' chia' ka' ka ẕzoẕj to benne' yet da' žawe', na' bi žákbe'egekle' zoa X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Ḻo yeḻa' ẕžebe chégake' žẕízegak benne' ka', dan' žakḻen Dios benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ẕcá'ngake' ca'ze da' wnnagak benne' yache' ka', san benne' ki žx̱én ḻáže'gake' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Ḻa'kze Bennen' yeslé' benne' Israel ka'. Kate' gon X̱anžon' ga yežingak benne' chie' ka', benne' ka' zej ndo'e zíto'le, na' yebégekle ẕa'só Jakob, na' yebéḻe'egekle benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","X̱ana' Dios, ¿noẕkze benne' gak soe' gan zo' Le'? ¿Noẕkze benne' gak soe' latje la'y chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Wak gon ki benne' nake' ḻi ḻaže', bennen' žone' da' naken chawe', bennen' zoa da' nak dot da' li ḻo yichj ḻáẕda'we', ");
INSERT INTO ztyNTps_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","bennen' bi ẕnnie' che lježe' ka', na' bi be da' ẕia žone' chegak lježe' ka', na' bi žwe'e latje no benne' kwej bi'e lježe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Wak soa bennen' ga na', bennen' bi žape' ba la'ne no benne' žone' da' ẕinnj, san žape' ba la'ne benne' ka' žápegake' X̱anžo Dios ba la'ne bennen' bi ẕche'e x̱tiže'e ḻa'kze gonen ga bi wnite'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Wak soa bennen' ga na', bennen' žsane' mežw chie', na' bi žennabe' yichjen, na' bi žezi'e mežw nich wzóa lie' da' wen ḻaže' che benne' bi be ẕia nbage'e. No benne' žone' ki batkle chejchaze' ḻo da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Bwia neda', Dios, dan' žx̱en ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ḻo yichj ḻáẕda'wa' žapa' Le', X̱ana' Dios: “Le' nako' X̱ana'. Bi be da' chawe' žata' chia' da' bi zan' ḻo no'o.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Žaz ḻáže'za' benne' ka' zej nake' che Dios ḻo yežlyó nga, na' ḻezka' benne' ka' zej nake' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Zan da' sáka'gak benne' ka' ẕka'n ẕéngake' lo'a ka'. Bi gona' ḻégake' tẕen kate' ẕḻáljgake' žen ḻáwgaken, na' bi wkonla' žin lágaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","X̱anžo Dios ẕwawe' neda' na' nake' da' chawe' chia'. Le', Dios, žape chi'o yeḻa' nban chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Da' žonno' chia' naken da' ba nez ẕen da' ẕzi'a, na' x̱tanḻe'e nak latje gan bzo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Wká'n ẕénteza' X̱anžo Dios, Bennen' žsedle' neda'. Kate' ne ẕtasa' ẕzejni'ile' neda' ḻo yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Žx̱en ḻaža'a X̱anžo Dios yezi'e neda'. Dan' zoe' kwita', bi be gak wcheben neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Che ḻen zoa ḻáẕda'wa' yeḻa' žebél, na' žebéḻe'etezla', na' kate' gacha'a ḻo yežw ba wx̱én ḻaža'a Le' ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","dan' bi wka'no' be' da' nakkza' ḻo latje choḻ chegak benne' gat ka', na' bi go'o latje nitla' dan' nakkza' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Wḻoe'elo' neda' da' žaḻa' gona' nich gata' chia' yeḻa' nban. Gan zo' Le' yebéḻe'etezla', na' kwito' Le' sóateze yeḻa' ba nez ẕen chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Bze nag da' ẕnnia', X̱ana' Dios. Benle da' žḻiža' Le'. Wẕí' da' ẕnnabla' Le' ḻo yeḻa' ḻi ḻaže' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Benn latje ḻa'a ḻawo' Le' nich wchi'a ḻažo'o neda', dan' ẕḻe'elo' yógo'te ka zej nakkzen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Le' ẕwíakzo' yichj ḻáẕda'wa', na' ẕḻe'elo' neda' žel. Bwíakzo' da' žona', na' bi be da' ẕinnj bḻe'elo'. Wdape chi'a loža'a nich bi be diža' ka'ze nnia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Žona' ka nak da' ẕnna x̱tižo'o, na' bi žona' kan žongak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Wdape chi'i neda' ḻo nez chawe' chio', nich bi chejchaza' ḻo da' bi nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Žḻiža' Le', Dios, dan' ženlo' chi'a. Bze nag chi'a, na' benle da' ẕnnia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Bḻoe'el neda' kan žeyache' ḻáže'ḻe'elo' benách ka'. Beslá benne' ka' žx̱en ḻáže'gake' Le' ḻo na'gak benne' ka' bi ẕḻé'egekle' ḻégake' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Bwia neda' ka žon no benne' ẕwíakze' yej ḻawe'. Wdape chi'i neda' ka žon ẕkoko', bian' žape chi'iba' bríse'do' ka' ẕan x̱ilba' ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","nich bi be gongak chia' benne' wen da' ẕinnj ka', benne' ka' bi ẕḻé'egekle' neda' chawe', na' žénegekle' gótgake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Bi žeyache' ḻáže'gekle' ljéžgake' ka', na' ḻo yeḻa' ẕka'n ẕen kwíngake' ẕcháḻjgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Gáte'teze gan ẕda' ẕwíagake' neda'. Žénegekle' wžía yí'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Zej nake' ka to bež yíx̱e'do' žénelba' bi da' gawba'. Zej nake' ka to bež yix̱e', bia ẕkache' kwinba' nich senba' biado' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Da, X̱ana' Dios, bdiḻ-ḻen benne' ka' bi zej nake' chawe', na' bžia yi' ḻégake'. Beslá neda' ḻo na'gak benne' ka' bi zej nake' chawe', wkonlo' žin ya ntoche' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Beslá neda' ḻo na'gak benne' ka' ḻen no'o waḻe, X̱ana' Dios. Beslá neda' ḻo na'gak benne' ka', benne' zej ze'e nich yekwásgake' yežlyó cheto' nga, benne' ka' žáwgake' da' záka'ḻe'e chio' na' ẕwáwgaken' ẕí'ngake' ka', na' ẕga'nkze da' gawgak ẕa'sógake' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","san neda', ḻe'ela' ḻawo' Le' dan' naka' chawe'. Chaz ḻaža'a gaka' ka nakkzo' Le' kate' yebana'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Nži'ila' Le', X̱ana' Dios. Le' ẕzoa chocho' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Le', X̱ana' Dios, nako' ka to yej gan zoa' choch, na' nako' ka to yo'o ẕen gan yo'o chawa'a. Nako' Benne' weslá chia', na' Dios chia'. Le' ẕzoa chocho' neda', na' wx̱én ḻaža'a Le'. Žape chi'o neda', na' žesló' neda', na' ẕkache' chawo'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Ẕnnia': X̱anžo Dios žaḻa' wká'n ẕenžo-ne'. Beslé' neda' ḻo na'gak benne' ka' ẕžá'agake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Wzóa' ḻo da' zede che yeḻa' got, na' gok da' ẕinnj ka to yegw nis da' bcheben neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Gota' ẕož chia' choa'a ḻo yi' gabíl dan' wzóa' ḻo da' zede che yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Ḻo da' ẕžia yin' benách ka' bḻiža' X̱ana' Dios na' bcháḻjḻenkza' Dios chia'. Ḻe' benle' chi'a gan zoe' latje la'y chie', na' bze nage' da' bchaḻja' ḻawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Naž wẕó' yežlyó nga. Wẕízegak ya'a ka' gže'. Wẕízeḻe'egaken dan' bže'e Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Bžoj žen che yi' ḻo ẕine'e, na' bžoj yi' ḻo žoe'e da' bzeyen da' zej že' ḻawe', na' yi' na' bẕenen bzio' yi' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Bsaljwe' ya'abá, na' betje', na' wzóa da' choḻ ẕan ni'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Wdíe' ḻo be', ne ži'e to da' nzin' kerubín. Ka' gaze wdíe' ḻo be' bdone'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Gokwe' da' choḻ, dan' bkachen' Ḻe', dan' naken bejw gasj da' yožen nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Ḻo da' žákti'teḻe'e chie' bžojgak bejw gasj ka'. Bžojgak wzió' yi', na' yej nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Ẕan ya'abá wnné wzió' che chi'i X̱anžo Dios, na' benle chi'i Dios ẕente ládjwgak wzió' yi' ka', na' yej nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Bsie' yag ntóche'do' chie' ka', na' besḻase' benne' ka' bi ẕḻé'egekle' neda' chawe'. Bsane' yes wzió' ka', na' bžia yi'e benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Naž bḻa' ḻawgak da' ka' zej že' gže' ẕan nisdo', na' bḻa' ḻaw x̱ni'a yežlyó dan' žen' ẕan nisdon'. Bdiḻo' benne' ka' ẕžá'agake' neda', X̱ana' Dios, na' ḻo yeḻa' ẕža'a chio' bsejo' x̱nézgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Betj Dios ḻo da' sibe, na' bex̱we' neda', na' ḻen ne'e waḻe bebeje' neda' ḻo da' zede da' goken ka nis zil. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Beslé' neda' ḻo na'gak benne' waḻe ka', benne' bi ẕḻé'egekle' neda' chawe', na' ḻo na'gak benne' ka' ẕží'igake' chia' neda', benne' ka' zej nakže' waḻe ka neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Bdíḻ-ḻengake' neda' katen' wzóa' ḻo da' zedḻe'e, san X̱ana' Dios gókḻene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Bebeje' neda' gan wyoá'a, na' bzoe' neda' to latje ẕen. Beslé' neda' dan' wyáz ḻaže'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","X̱anžo Dios bebi'e chia' dan' bena' da' naken chawe', na' ka nakkze da' chawen' bebi'e chia', ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","dan' žona' ka žsedle X̱ana' neda', na' bi wléj yichja' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Žona' ka nak da' bchi'le' žo'o, na' bi bsana' diža' ka' da' bdix̱jwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Goka' ḻi ḻaže' ḻawe' Ḻe', na' wdape chi'i kwina' nich bi gona' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Bebí'i X̱anžo Dios chia' ka nak da' chawe' da' bena', ka nakkze da' chawen' dan' bena' ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Žeyache' ḻáže'lo' no benne' žeyache' ḻáže'le' lježe', na' nako' ḻi ḻaže' ḻen bennen' nake' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ẕcháḻjḻeno' benne' chawen' da' naken dot chawe', na' gako' snia ḻen benne' wen da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Yesló' benne' chawen' ḻo da' wžía yin' benách ka', san wzex̱jo' benne' ka' ẕka'n ẕen kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Le' wzaljo' yi' chia'. Le', X̱ana' Dios, wza'ni'o chia' gan zoa' ḻo da' choḻ. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Yeḻa' wak chio' wžía yin' benne' zanḻe'e, benne' ka' žjake' ḻo wdiḻe. Cha' Le', Dios, sóaḻeno' neda', wak wchinnja' ze'e ka' žape chí'igaken yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Da' ka' žon Dios zej naken ḻi ḻaže', na' x̱tiže'e naken dot da' li. Žape chi'e yógo'te benne' ka' žx̱en ḻáže'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Toze X̱anžon' nake' Dios. Toze Dios chežo nake' Benne' žape chi'e žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Dios nake' Bennen' žone' neda' benne' waḻe, na' Benne' žeyone' ḻi ḻaže' da' žona' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Žone' ni'a ka zej nak ni'a bžina' yix̱e' na' ẕzoa choche' neda' ḻaw Ya'a Sión chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Žsedle' neda' nich gak cha'a ḻo wdiḻe, na' nich gak wlewa' da' žsi yag ntóche'do' ka', dan' naken ya bronse. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ḻo yeḻa' žeslá chio' wdape chi'o neda', na' ḻen no'o ḻi ža gókḻeno' neda'. Ḻo yeḻa' ži'i ḻaže' chio' bka'n chawo'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ben chawo'o nez gan tia', na' bi kwila' ḻo nezen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Bsejwa' x̱nezgak benne' ka' ẕžá'agake' neda', na' bena' ga bẕónnjgake', na' bi beyá'a liža' ga bžinte beta' benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Bena' benne' ka' we', na' bi gok yeyásgake'. Bejbíx̱gake' ẕan ni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ben chocho' neda' nich gok cha'a ḻo wdiḻen'. Bzex̱jo' benne' ka' ẕžá'agake' neda' ẕan ni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Beno' bẕonnjgak ḻawa' neda' benne' waḻe ka', na' bžia yi'a benne' ka' bi ẕḻé'egekle' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Wnnábgekle' no benne' gákḻene' ḻégake' san bi wzóa no benne'. Wnnábgekle' X̱anžo Dios, san bi wzé nage' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Bžia yi'a benne' ka', na' gókgake' ka bix̱te yo dan' ẕzen ḻo be'. Bleja' ḻégake' ka ẕleja' gona' ḻo nez ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Besló' neda' ḻo na'gak benne' ka' ẕží'igake' chia', na' beno' neda' benne' blo ḻo yež ka', na' ḻáwe'lgak benne' zi'to' ka'. Benne' ka' bi nónbi'a, žóngake' žin chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Kate' béngekle' chia', na' béngake' kan wnnía'. Benne' yež ka' béngake' kan bchi'la' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Benne' zi'to' ka' gotgak ni'a ná'gake'. Ḻo yeḻa' ẕžebe bžójgake' ḻo yež ẕen ka' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","¡Ga'n ẕen X̱anžo Dios! ¡Ga'n ẕene' dan' žákḻene' neda'! ¡Ga'n ẕen Dios, Bennen' žeslé' neda'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Dios žebéj yichje' benne' ka' ẕžá'agake' neda', na' ẕdie' benne' yež ka' ḻo na'a neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Žeslé' neda' ḻo na'gak benne' ka' ẕžá'agake' neda'. Žone' ga ẕnna bi'a benne' ka' bží'igake' chia' neda'. Beslé' neda' ḻo na'gak benne' yichj ža'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Wká'n ẕena' Le', X̱ana' Dios, ḻawgak benne' yež ka', na' goḻkza' che La la'y chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Žono' ga žon to benne' da' ẕen ka', bennen' ẕnna bi'e ḻo wlazo' Le', na' žeyache' ḻáže'lo' bennen' wžío' Le', bennen' nake' Dabí, na' ẕa'sóe' ka', to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Nḻa' ḻaw ẕan ya'abá yeḻa' ẕen che Dios. Ẕcháḻjgakkze yógo'te da' ka' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","To ža ẕzenlen ža yoble da' ni, na' to yel žen' yel yoble da' na'kzen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Bi ẕkóngeklen žin x̱tíža'gak benne' ka', na' bi zoa no benne' ženle' chí'igaken, ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","san ẕžin da' ẕnnágaken do ẕente yežlyó, na' ẕžingak x̱tíža'gaken dot yežlyó. Dios bene' ya'abá ka to yo'o gan zoa wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Zildo' ẕḻan' ka to benne' byo ẕchag ne'e. Žebelen ka to benne' ẕzá'ḻi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Ẕžojen cheḻa'ale gan ẕḻan', na' ẕžinen cheḻa'ale gan ženen. Ẕcha'an yógo'te da' zej den. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Dot ḻi ḻaže' nak da' žsedle X̱anžo Dios, na' ẕzoa chochen be' da' nakkzžo. Ḻi ḻaže' nak da' bchi'le X̱anžon' žo'o. Ẕneẕjwn yeḻa' žejní'il chegak benne' ka' bi zej napen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Da' likze nak da' wnná X̱anžon', na' žebéḻe'egekle benne' ka' žóngake' kan ẕnnan. Ḻi ḻaže' nak da' ẕzejní'il X̱anžon' žo'o, dan' ẕzoan žo'o ḻo yeḻa' baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Nak chawe' ẕžébežo X̱anžon', dan' gonen ga soažo nbanžo to chi'ize. Da' likze nak kan ẕchi'a ḻaže' X̱anžon' žo'o, na' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Naken da' ẕdan ḻáže'žežo ka ya oro, na' ka ya oro ẕente dan' záka'ḻe'en. Nakžen ẕix̱ ka bžina' che bez, dan' nakḻe'en ẕix̱. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Žsedlen neda', wen žin chio', dan' žona' kan ẕnnan, na' da' ẕenḻe'e žezi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Nitó benne' bi gak gónbi'e da' ẕinnj da' žone'. Beslá neda', X̱ana' Dios, ḻo da' ẕinnj dan' bi žákbe'ela' žonan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Bkache' chawe' neda', wen žin chio', nich bi be doḻa' gona' dot ḻaža'a. Bi go'o latje nna bia' doḻa' neda'. Naž gaka' ḻi ḻaže', na' bi baga'a ẕia che doḻan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Žénela' gak da' ẕchaḻja', na' da' zḻab ḻaža'a da' žaz ḻažo'o Le'. X̱ana' Dios, Le' žon chochkzo' neda', na' beya'wo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Ẕnnabla' X̱anžo Dios yenle' chi'o kate' bi žak chio', na' gape chi'i Dios na'kze che Jakob le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Ẕnnabla' Ḻe' ḻo latje la'y chie' gákḻene' le', na' gan zoe' ḻaw Ya'a Sión yedjwíe' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ẕnnabla' Ḻe' chejsá' ḻaže'e yógo'te da' bneẕjo' chie', na' si' ḻo ne'e biado' ka' ẕzeyo' ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ẕnnabla' Ḻe' gonne' chio' yógo'te da' ẕdan ḻažo'o, na' gone' yógo'te da' žak ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Yebéḻe'elto' kate' yeslé' le'. Wchisto' to da' wḻoé'e ḻawn La la'y che Dios chežo. Ẕnnabla' X̱anžon' gone' yógo'te da' ẕnnablo' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Na'a nnezla' žeslá X̱anžon' bennen' wžekze' Ḻe'. Gan zoe' ya'abá la'y chie' yenle' chi'i bennen'. Ḻen yeḻa' wak ẕente chie' yeslé' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Baḻ benne' ka' žx̱en ḻáže'gake' karro ka' che wdiḻe, na' yezíka'že' žx̱en ḻáže'gake' bia waḻe ka', san žo'o žx̱en ḻáže'žo La X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Benne' ka' gotgak ni'a ná'gake', na' bejchégwgake', san žo'o, beyasžo, na' zežo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Beslá neto', X̱anto' Dios. Le'kze ẕnna bi'o neto'. Benle chi'ito' kate' žḻižto' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Benne' ẕnna bi'e ẕžebe' yeḻa' wak chio', X̱anto' Dios, na' ni'a che yeḻa' weslá chio' žebéḻe'ele'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Benno' chie' da' wdán ḻaže'e na' bi bžono' da' wnnable' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Wẕí' ḻo no'o ḻe', na' ben chawo'o ḻe'. Bžio' yichje' to da' naken oro. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Wnnable' Le' gonno' chie' yeḻa' nban, na' bennon' chie' nich soakze' yiz zan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ẕenḻe'e nak yeḻa' ẕen chie' dan' besló' ḻe'. Benno' chie' yeḻa' ba la'ne, na' yeḻa' ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Dan' ben chawo'o ḻe' to chi'ize, žono' ga žebéḻe'ele' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Dan' bennen' ẕnna bi'e žx̱en ḻaže'e X̱anžon', yeyache' ḻaže'l Dios ẕente ḻe', na' bi kwe' zedle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Wzetjo' yógo'te benne' ka' bi ẕḻé'egekle' Le' chawe'. Ḻen yeḻa' wak chio' wzex̱jo' benne' ka' ẕží'igake' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Gak chegak benne' ka' ka wnnito'o ḻégake' ḻo yi' katen' yido' nich wchi'a ḻažo'o ḻégake'. X̱anžon' wžía yi'e benne' ka' ḻo yeḻa' ẕža'a chie', na' yi' na' wzeyen ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Yógo'te da' béngake' ḻo yežlyó nga wchinnjo', na' wkwaso' ẕa'sógake' ka' ladjw benách ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","dan' wyáz ḻáže'gake' góngake' da' bi naken chawe' ḻawo' Le'. Sa' ḻáže'gake' da' góngake' san bi be sáke'gekle' dan' wlago' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Bkwezo' yag ntóche'do' chio' ka' nich goto' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","¡Ga'n ẕen Le', X̱anto' Dios, ḻo yeḻa' waḻe chio'! Góḻtezeto', na' wká'n ẕéntezeto' Le' ni'a che yeḻa' wak chion'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Dios chia', Dios chia', ¿biẕ chen' wléj yichjo' neda'? ¿Biẕ chen' bi ženlo' kate' ẕnnabla' Le' yesló' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Dios chia', žḻiža' Le' tža tža, san bi žechebo' chia'. Žḻiža' Le' žel, na' bi žezí' ḻaža'a, ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","san Le' nako' la'y. Ẕbezkzo' gan ẕka'n ẕengak benne' Israel ka' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","X̱a x̱na' wdé cheto' ka' bx̱en ḻáže'gake' Le'. Bx̱en ḻáže'gake', na' besló' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Bḻížgake' Le', na' gókḻeno' ḻégake'. Bx̱en ḻáže'gake' Le', na' bi bedoé'egekle', ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","san neda' naka' ka to bel góna'do', na' kege benne'. Ẕža'agak benne' ka' neda' na' žon dítjgekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Yógo'te benne' ka', kate' ẕḻé'egekle' neda', ẕká'ngake' neda' ka'ze. Žsáljwgake' žóa'agake' nich nnégake' chia', na' ẕta yíchjgake', na' ẕnnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Bx̱en ḻaže'e X̱anžon' nich yeslé' ḻe'. Yeslé' ḻe' cha' žaz ḻaže'e ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","San Le', X̱ana', bex̱o' neda' kate' golja'. Beno' ga bx̱en ḻaža'a Le' kate' ne žaẕa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Wyoá'a ḻo no'o kate' bi na' galja'. Kate' ne yoa'a ḻe'e x̱na'a, báchekze nako' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Bi yebigo'o gan zoa' dan' zoa gawze da' wsakan' neda', na' bi zoa no benne' gákḻene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Benne' ka' bi ẕḻé'egekle' neda' chawe' zej nyechjle' neda', benne' ka' zej nake' ka bež ka'. Zej nyechjle benne' ka' neda', benne' ka' zej nake' ka bež waḻe ka' che yežlyó Basán. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Gónegekle' wžía yí'gake' neda' ka žon to bež yix̱e', bia ẕdonba', na' ẕbéžeya'aba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Bedó ḻaža'a, na' gok ḻáẕda'wa' ka nis da' nlaljen, na' yógo'te žit yoa'a bsángaken ljéžgaken ka'. Ḻáẕda'wa' goken ka china' bez, da' beyonan ḻi'a ka nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Beyák yeḻa' waḻe chia' ka to že'n yo dan' nla'an, na' loža'a wdán' chichjla'. Bletjo' neda' ḻo bix̱te yo che yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Zej nyechjle benne' wen da' ẕinnj ka' neda'. Zej nyechjle' neda' ka beko' ka'. Wdídjwgake' ni'a na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Wak wlaba' yógo'te žit yoa'a, na' benne' ka' ẕḻé'egeklen', ẕwíazegake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Bdísgake' ẕa' che chégake', na' ḻawle ẕan' wléjgake' da' gak bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","San Le', X̱ana' Dios, bi bkwaso' gan zoa'. Nakkzo' Le' yeḻa' waḻe chia', na' gákḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Beslá be' da' nakkza' ḻo na' benne' wdíe' neda' ya ntoche'. Bennen' žénele' wžía yi'e neda' žone' ka žon to beko'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Beslá neda' ḻo žoa'a bež yix̱e'. Beslá neda' ḻo lozgak bež waḻe ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Wzenla' bi' ljéža'do' ka' kan nako' Le'. Wká'n ẕenkza' Le' gachje ḻawle benne' ka' zej ndobe' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Ḻe'e, benne' ka' ẕžébele X̱anžon': ¡Le wká'n ẕene' Ḻe'! ¡Le wká'n ẕene', ḻe'e, ẕa'só Jakob! ¡Le žebe Ḻe', ḻe'e, ẕa'só Israel ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Bi ẕnnita' Dios benne' yache' ka' cheḻa'ale, na' bi ẕdeze' da' ẕzáka'gake', na' bi ẕkache' ḻawe' ḻawgak benne' ka', san kate' žḻížgake' Ḻe', ženle' chí'igake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Gachje ḻawle benne' zan ka', benne' zej ndobe' chio' wká'n ẕenkza' La la'y chio' Le', dan' bchebe ḻaža'a gonan' ḻawgak benne' ka' ẕžébegake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Gawgak benne' gax̱jw ka', na' yéljgekle'. Bíga'gake' ḻaw X̱anžon', na' wká'n ẕéngake' Ḻe'. Gákteze yeḻa' ba nez ẕen chegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Benne' ka' nníta'gake' dot yežlyó chejsá' ḻáže'gake' X̱anžon', na' yežíngake' ḻawe' Ḻe'. Yógo'te kwe' benách ka' wká'n ẕéngake' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","dan' napkze X̱anžon' yeḻa' wnná bia', na' nna bi'e yógo'te yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Gawgak yógo'te benne' ẕen ka' che yežlyó nga, na' wká'n ẕéngake' Dios. Wzóa ẕibgak yógo'te benne' ka' ḻawe' Ḻe'. Benne' ka' bi gak yeslá kwíngake' nich bi gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Ẕa'sógak benne' ka' góngakbe' žin che X̱anžon'. Wzéngekle' ẕí'ngake' ka' ka nak chie' na' zejte chejsete chegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yežíngake', na' wzéngekle' benne' ka' ka nak da' chawe' da' žon Dios. Wzéngekle' benne' ka' bi na' gáljgake' ben Dios da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","X̱anžo Dios žape chi'e neda' ka žon to benne' žape chi'e ẕila' chie' ka', na' bi be yážjela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ka žon bennen' ga ẕzi' ḻáže'gak ẕila' ka' gan bdáwgakba' yix̱e' ya'ado', ki žon Dios chia' neda'. Gone' chia' kan žon bennen' chegak ẕila' ka' ẕchi'e-ba' žoa'a yegw nis da' že' žize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Žon choche' yichj ḻáẕda'wa'. Žon chawe'e neda' nich gak da' bchebe ḻaže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ḻa'kze tia' gan de ẕož gata', bi be da' ẕinnj wcheben neda', dan' zóaḻenkzo' Le' neda', X̱ana' Dios. Bar chio', na' breke' chio' gape chí'igaken neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Wsí'ni'o da' ye'j gawa' ḻa'kze benne' ka', benne' ẕdíḻ-ḻengake' neda' zej nyechjle' neda'. Ẕgo'o set yichja' da' žeyonen neda' chawe', na' žeschá'ḻi'o da' žé'jḻena'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Da' likze da' chawe', na' yeḻa' ži'i ḻaže' chio' sóaḻengaken neda' yógo'te ža soa' nbana', na' ližo', Dios, gaken liža' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Che Dios nak yežlyó nga, na' yógo'te da' že' ḻawen'. Nak chie' yežlyón', na' benne' ka' nníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Bzoen' ḻawle nisdo', na' bzaḻe'e x̱ni'an že'lte ẕan nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","¿Noẕkze benne' gak kwene' ya'a che X̱anžon'? ¿Noẕkze benne' gak choe'e yodo' la'y chie'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Wak benne' ka' zej nak chawe' da' žóngake', na' da' ẕza' ḻáže'gake', benne' ka' bi na' wchís ná'gake' ḻawgak lo'a ka', na' bi na' wchebe ḻáže'gake' ni'a che da' bi naken ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","X̱anžon' gon chawe'e benne' ki. Dios wchi'a ḻaže'e benne' ki, na' yeslé' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Ki zej nak benne' ka' ẕbíga'gake' ḻaw Dios, benne' ka' žó'ogake' gan zoa Dios che Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Le wsaljw gan žo'ogak benne' ka' yodo'. Le wsaljw gan žo'ogak benne' ka' gan naken la'y, na' cho'o Benne' Wnná Bia' Ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","¿Noẕkzen' Benne' Wnná Bia' Ẕente ni? Nake' X̱anžon', Benne' waḻe, na' nape' dot yeḻa' wak. Nake' X̱anžon', Bennen' ẕzoele' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Le wsaljw gan žo'ogak benne' ka' yodo'. Le wsaljw gan žo'ogak benne' ka' gan naken la'y, na' cho'o Benne' Wnná Bia' Ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","¿Noẕkzen' Benne' Wnná Bia' Ẕente ni? Nake' X̱anžon', Bennen' ẕnna bi'e gáte'teze. Ḻe' nake' Benne' Wnná Bia' Ẕente na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","X̱ana' Dios, ẕcháḻjḻena' Le' dot ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Žx̱en ḻaža'a Le', Dios chia'. Bi go'o latje yedoe'ela'. Bi go'o latje benne' ka' bi ẕḻé'egekle' neda' chawe' wžía yí'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Bi chíx̱gekle benne' ka' žx̱en ḻáže'gake' Le', san yedoé'egekle benne' ka' ẕží'igake' che x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","X̱ana' Dios, bḻoe'el neda' da' žak ḻažo'o gona'. Bche' neda' gan žénelo' cha'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Bsedle neda' gona' da' naken dot da' li chio'. Dan' nako' Dios, na' žesló' neda', wx̱én ḻáže'teza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Bejsá' ḻaže', X̱ana' Dios, gako' ži'i ḻaže', na' yeyache' ḻáže'lo' neda', kan žónteze žono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Bi chejsá' ḻažo'o doḻa' da' bena' kate' ne naka' benne' kwide', na' kan bži'a che x̱tižo'o. Ḻo yeḻa' žeyache' ḻaže' chio', na' yeḻa' ži'i ḻaže' bejsá' ḻaže' neda', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Chawe', na' ḻi ḻaže' nak X̱anžo Dios. Che ḻen wsedle' benne' doḻa' ka' da' žaḻa' góngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Wḻoe'ele' benne' gax̱jw ḻaže' ka' da' naken chawe' na' wsedle' benne' ẕen ḻaže' ka' da' góngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Ḻo yeḻa' žeyache' ḻaže', na' ḻo da' li, ẕche' X̱anžon' benne' ka' žóngake' kan ẕnna x̱tiže'e dan' bénḻene' žo'o, na' ka nak da' žsedle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Dan' žono' ka nak da' ba wnnó', X̱ana' Dios, yenít ḻawo' chia' doḻa' da' bena', da' naken ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","¿Zoa no benne' ẕžebe' Le', X̱anto' Dios? Le' wsedlo' bennen' da' žaḻa' gone'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Gak chie' to yeḻa' ba nez ẕen, na' ẕa'sóe' ka' gata' chégakbe' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","X̱anžo Dios nake' toze ḻen benne' ka' ẕžébegake' Ḻe', na' gone' ga gónbia'gake' x̱tiže'e dan' bénḻene' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Wx̱én ḻáže'teza' X̱anžo Dios dan' beslé' neda' ḻo na'gak benne' ka' žénegekle' wžía yí'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Bwia neda', na' beyache' ḻaže'l neda' dan' zoa' toza', na' ẕzáka'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Nyanḻe'e da' zede da' zej yo'on yichj ḻáẕda'wa'. Beslá neda' ḻo da' zede da' ẕzaka'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Bwia ka ẕzáka'ḻi'a, na' ka žónḻi'a žin, na' benít ḻaw che yógo'te doḻa' da' nbaga'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Bwia ka nyanḻe'e benne' ka' ẕžá'agake' neda', na' kan ẕbia ḻáže'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Bwia be' da' nakkza', na' beslá neda'. Bi go'o latje yedoe'ela' dan' žx̱en ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Da' chawe', na' yeḻa' ḻi ḻaže', žon chóchgaken neda' dan' žx̱en ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","X̱ana' Dios, beslá benne' Israel ka' ḻo yógo'te da' ẕzáka'ḻe'egake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Bchi'a ḻaže' neda', X̱ana' Dios, dan' bena' da' naken chawe'. Bx̱en ḻaža'a Le', X̱ana' Dios, na' bi gok chop ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Bwíakze ḻáẕda'wa', X̱ana' Dios, na' bwia dan' bena'. Bwíakze da' yo'on yichj ḻáẕda'wa' ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","dan' žákbe'ela' žeyache' ḻáže'lo' neda', na' žona' ka nak da' naken dot da' li chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Bi na' gona' tẕen benne' ka' žóngake' da' chawe' ḻáwzele. Bi na' gona' toze benne' ka' ẕḻoé'ezele chawe' kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Bi ẕḻe'ela' chawe' latje gan ẕdobgak benne' ka' bi zej nake' chawe', na' bi žoa'a tẕen ḻen benne' ka' žóngake' da' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Ẕḻe'elo' bi be ẕia nbaga'a, na' wak biga'a ḻo bkog la'y chio', X̱ana' Dios, ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","gan goḻa' da' ka' we ḻawa'a Le', na' wzenla' benách ka' ka nak da' ẕen da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","X̱ana' Dios, nži'ila' ližo' gan zo', na' latje la'y gan nḻa' ḻaw yeḻa' ẕen chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Bi wžía yi'o neda' tẕen ḻen benne' doḻa' ka', na' bi wdío' neda' tẕen ḻen benne' wetw benách ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","benne' ka' žóngake' da' bi naken chawe', na' ẕnéẕjwtezegake' mežw nich bi wchi'a ḻaže' no benne' da' ẕinnj da' béngake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","san neda' gónteza' da' nak ḻi ḻaže'. Beslá neda', na' beyache' ḻaže'l neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Dan' bénteza' da' nak chawe', na' wká'n ẕenkza' Le', X̱ana' Dios, ḻawgak benne' ka' zej ndobe' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","X̱anžo Dios nake' yeḻa' baní' chia', na' Benne' žeslé' neda'. Bi gak no benne' wchebe' neda'. X̱anžo Dios nake' Benne' žape chi'e neda'. Bi gak no benne' wzóe' neda' ḻo da' zedḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Kate' benne' ka' bi zej nake' chawe' byéchjgekle' neda', ḻen benne' ka' žsáka'gake' neda', na' bi ẕḻé'egekle' neda' chawe', nich wžía yí'gake' neda', na' bejchégwgake', na' bedoé'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ḻa'kze chéchjgekle benne' zan, benne' žjake' ḻo wdiḻe neda', benne' ka' bi ẕḻé'egekle' neda' chawe', bi žébekza'. Ḻa'kze žon byéngake' tíḻ-ḻena' ḻégake', neda' wx̱én ḻáže'kza' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","To da' ẕnnabla' X̱anžo Dios. Toze da' ẕdan ḻaža'a, dan' naken soa' liž X̱anžon' yógo'te ža soa' nbana', nich wláb ḻaža'a ka nak yeḻa' ẕen che X̱anžon', na' wcháḻjḻena' Ḻe' ḻo yodo' la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Ḻe' wkache' chawe'e neda' ḻo latje la'y chie' kate' žin ža gak da' bi nak chawe'. Wkache' chawe'e neda' ḻo latjen' gan zoakze' Ḻe'. Wzóe' neda' to gan soa' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Naž gone' ga wzex̱jwa' benne' ka' bi ẕḻé'egekle' neda' chawe', benne' ka' zej nyechjle' neda'. Ḻo yeḻa' žebele gota' biado' ka' ḻo bkog la'y chie'. Goḻkza', na' wká'n ẕenkza' X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","X̱ana' Dios, benle chi'a kate' žḻiža' Le'. Beyache' ḻaže'l neda', na' bechebe chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Ḻo yichj ḻáẕda'wa' benla' chi'o, na' wnnó': “Da ga zoa' ni.” Yida' gan zo' Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Bi wkache' ḻawo' Le' ḻawa' neda'. Ḻo yeḻa' ẕža'a chio' bi yebigo'o gan zoa' neda', wen žin chio'. Toze Le' žákḻeno' neda'. Bi wsano' neda', na' bi kwej yichjo' neda', Dios, weslá chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ḻa'kze wsangak x̱a x̱na'a neda', yeka'akze X̱anžo Dios neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Bsedle neda' da' žak ḻažo'o gona', X̱ana' Dios, na' bḻoe'el neda' da' naken ḻi ḻaže' da' žaḻa' gona', dan' zej nyan benne' ka' bi ẕḻé'egekle' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Bi go'o latje benne' ka' wžía yí'gake' neda'. Zej nyechjle benne' wen ḻaže' ka' neda', na' žesbága'gake' neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","X̱anžo Dios bchebe ḻaže'e ḻe'ela' da' chawe' chie' gan sóateza' nbana'. Chela' bi žejḻi'a da' ni, na' gat ni'a na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Le kwez ža yeḻá' X̱anžon'. Le gon choch ḻáže'le, na' Ḻe' wzé choche' ḻe'e. O', le kwez ža yeḻá' X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","X̱ana' Dios, žḻiža' Le'. Le' žape chi'ikzo' neda'. Bze nag chi'a dan' cha' bi yenlo' chia' gaka' ka to benne' žoe'e ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Benle chi'a dan' žḻiža' Le', na' ẕchis na'a ḻawo' Le' gan zo' latje la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Bi wžía yi'o neda' tẕen ḻen benne' wen ḻaže' ka', na' kege tẕen ḻen benne' ka' žóngake' da' ẕinnj. Ẕnnágake' da' cháwe'do' ḻawgak ljéžgake' ka', san da' bi nak chawe' yo'on yichj ḻáẕdo'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Bde benne' ka' ḻo da' sáka'ḻe'egake' tḻebe kan nak da' béngake', ka nakkze da' bi nak chawe' da' béngake'. Bneẕjw benne' ka' tḻebe kan nak da' béngake', dan' yeyáḻa'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Dan' bi wdápegake' ba la'ne da' ben X̱anžon', na' kege dan' bene' ḻen na'kze', Ḻe' wžía yi'e benne' ka', na' wdíe' ḻégake' ḻo da' sáka'ḻe'egake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","¡Ga'n ẕen X̱anžo Dios, Bennen' benle' chi'a katen' bḻiža'-ne'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","X̱anžo na'kze ẕze choche' neda', na' žape chi'e neda'. Bx̱en ḻaža'a Ḻe', na' gókḻene' neda'. Che ḻen yebéḻe'ela', na' goḻkza', na' wká'n ẕenkza' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","X̱anžon' ẕze chochkze' benne' chie' ka', na' žape chi'ikze', na' žeslé' bennen' wžíe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Beslá benne' chio' ka'. Ben chawe' da' nak chégake'. Wdáp chi'i benne' ka', na' bze choch ḻégake' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Le wká'n ẕen X̱anžon', ḻe'e, zoale ya'abá. Le wká'n ẕen yeḻa' ẕen chie', na' yeḻa' wak chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Ẕenḻe'e nak La X̱anžon'. Le wká'n ẕenen. Le wzóa ẕible ḻaw X̱anžon' ḻo latje la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Chi'i X̱anžon' ženlen ḻaw nisdo'. Ženle chi'i Dios ya'abá ka wzió' da' ẕnnen. Ẕda chi'e ḻaw nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Ženle chi'i X̱anžon' da' naken waḻe. Ženle chi'i X̱anžon' da' napen yeḻa' wak. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Chi'i X̱anžon' žichjwn yag sedro ka'. Žichjwn yag sedro ka' da' zej žen' ḻaw Ya'a Líbano. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Žx̱ite' Ya'a Líbano ka žx̱íte'gak beždo' ka', na' žx̱ite' Ya'a Hermón ka to beždo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Chi'i X̱anžon' žonen ga žas yes wzió'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Chi'i X̱anžon' žx̱izen latje dach. Žx̱izen latje dach che yežlyó Kades. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Chi'i X̱anžon' žx̱izen yag waḻe ka'. Ẕchiben x̱laggak yag ka', na' ḻo yodo' chie' ẕnnagak yógo'te benne' ka': “¡Ga'n ẕen Dios!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Ẕnna bia' X̱anžon' nisdo' ka'. To chi'ize ẕnna bia' Benne' Wnná Bia' Ẕen na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","X̱anžo Dios ẕzoa choche' benne' chie' ka'. Žon chawe'e ḻégake' ḻo yeḻa' ẕga'n chawe' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","X̱ana' Dios, bechiso' neda', na' ẕka'n ẕena' Le'. Bi bi'o latje benne' ka' bi ẕḻé'egekle' neda' chawe' gon dítjgekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","X̱ana' Dios, bḻiža' Le', na' beyono' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","X̱ana' Dios, besló' neda' ḻo yi' gabíl. Beyono' neda' nich bi choa'a yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Le goḻ che X̱anžon', ḻe'e nakle benne' chekze' Ḻe'. Le ye' Ḻe' “žóx̱keno'”, na' bejsá' ḻaže' nake' la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","To chí'ido'ze ẕže'e, san to chi'ize zoa yeḻa' ži'i ḻaže' chie'. Kwéžežo to yelze, san zildo' yebéḻe'elžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Kate' wzóa' chawe' wnnía': bi be gak chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ki wnnía' dan' bzoa chocho' neda', X̱ana' Dios, ka to ḻaw ya'a ẕen, na' ben chawo'o neda', san kate' bkache' ḻawo' Le', na' wžé' zedla'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","X̱ana' Dios, wḻiža' Le', na' gáta'yoela' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","¿Biẕkze yeḻa' ba nez gaken chio' cha' gata' neda', na' choa'a yežw ba? ¿Wká'n ẕena' Le' kate' ba naka' bix̱te yo? ¿Wak wzenla' no benne' da' naken dot da' li chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Bze nag chia', X̱ana' Dios, na' beyache' ḻaže'l neda'. X̱ana' Dios, gokḻen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Beno' ga beyák yeḻa' ẕbeže chia' yeḻa' žia'a. Bkwaso' yeḻa' nyache' ḻaže' chia', na' beno' ga bebéḻe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Che ḻen goḻkza' chio'. Nakkzo' Le' yeḻa' ba nez chia', na' bi soakza' žize. X̱ana' Dios, wká'n ẕenkza' Le' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Žx̱en ḻaža'a Le', X̱ana' Dios. Bi gono' ga yedoe'ela'. Ni'a che da' chawe' da' nako' Le', beslá neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Bze nag chi'a, na' gokḻen neda'. Bze choch neda', na' wdape chi'i neda' nich yelá'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Le' ẕzoa chochkzo' neda', na' žape chi'o neda'. Dan' nako' ḻi ḻaže' wḻoe'elo' neda' nez, na' wgó'o neda' nezen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Bebéj neda' ḻo do yeḻj dan' bkwézgake' nich séngake' neda'. Le', X̱an, ẕwíakzo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ẕdia' be' da' nakkza' ḻo no'o Le', X̱ana' Dios. Le' beya'wo' neda', Dios ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Bi de chawa'a benne' ka' ẕka'n ẕéngake' lo'a ka', san neda' žx̱en ḻaža'a Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Yebéḻe'ela', na' soa' chawe' dan' nži'ilo' neda' na' ẕḻe'ekzlo' ẕzáka'ḻi'a. Nnezlo' ka ẕdia' ḻo da' žsáka'ḻe'egake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Bi bdio' neda' ḻo na'gak benne' ka' ẕžá'agake' neda'. Bzoa chocho' neda' to latje chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Beyache' ḻaže'l neda', X̱ana' Dios, dan' ẕzáka'ḻi'a. Ba bebíž nis da' yožen yej ḻawa', na' žak nyache' ḻaža'a ḻo be' da' nakkza', na' ḻo beḻa' žen chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Dan' ẕde yeḻa' nban chia' ḻo da' ẕzáka'ḻi'a, ẕdia' yiz chia' ka' ẕbeže ḻaža'a, na' žedó ḻaža'a dan' nbaga'a ẕia, na' ẕlagak žit yoa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Benne' ka' ẕžá'agake' neda' gon dítjgekle' neda', na' benne' ẕjo'o ḻi'a chia' ka' žon dítjgekle' neda'. Benne' ka' zej nónbi'e neda' ẕkwásgake' gan zoa', na' benne' ka' ẕḻé'egekle' neda' ḻo nez žẕónnjgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Goḻ ḻáže'gake' neda' ka žóngake' che to benne' gat. Naka' neda' ka to ye'n yo da' nla'an. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Ženla' da' ẕnnegak benne' zante chia', na' gáte'teze zoa da' ẕcheben neda' dan' žóngake' toze diža' bi da' góngake' chia', na' žak ḻáže'gake' gótgake' neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","san neda' žx̱en ḻaža'a Le', X̱ana' Dios. Ẕnnia' nako' Le' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Ḻo no'o Le' žape chi'o ža chia' ka'. Beslá neda' ḻo na'gak benne' ka' ẕžá'agake' neda', na' ḻo na'gak benne' ka' ẕbia ḻáže'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Ḻo yeḻa' ẕen chio' bwia neda', wen žin chio'. Ḻo yeḻa' žeyache' ḻaže' chio' beslá neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Bi go'o latje yedoe'ela', X̱ana' Dios, dan' žḻiža' Le'. Ben ga yedoé'egekle benne' ka' ẕbej yíchjgake' Le'. Ben ga soa žígake' ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Bnnita' ži benne' ka' žon ḻáže'gake', benne' ka' ẕnnégake' chegak benne' chawe' ka', dan' ẕnnágake' ḻo yeḻa' ẕka'n ẕen kwin, na' ḻo yeḻa' žon ditjle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ẕente nak yeḻa' ži'i ḻaže' chio' dan' napo' nich bi da' gono' chegak benne' ka' žápegake' Le' ba la'ne, dan' žonno' chegak benne' ka' žx̱en ḻáže'gake' Le' ḻawgak yógo'te benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ḻo da' bagáche'ze gan zo' Le' ẕkache' chawo'o benne' chio' ka' nich bi be gongak benne' ka' chégake'. Ẕnnito' benne' ka' to ḻo yo'o ngache' nich bi be gongak chégake' benne' ka' ẕdiḻ diže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","¡Ga'n ẕen X̱anžo Dios! Ḻo yeḻa' žeyache' ḻaže' chie' bene' da' ẕen nich gókḻene' neda' to ḻo yež gan gok wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Kate' gok da' bcheben neda' wnnía': “Zoa' gan bi ẕḻe'ele X̱ana' neda'”, san Le' benlo' chi'a katen' góta'yoela' Le', na' bḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Le ži'il X̱anžon', ḻe'e nakle benne' chekze' Ḻe'. X̱anžon' žape chi'e benne' ka' bi ẕbej yíchjgake' Ḻe', na' žebí'iḻi'e da' ẕia dan' žaḻa' yezí'gak benne' ka' ẕka'n ẕen kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Le gon choch ḻáže'le, ḻe'e žx̱en ḻáže'le X̱anžo Dios, na' Ḻe' wzé choche' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Ba nez ẕen naken che bennen' Dios ba benít ḻawe' x̱toḻe'e, na' ba beké'e da' ẕinnj da' wbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Ba nez ẕen naken che bennen' Dios bi žesbage'e ḻe' ẕia, bennen' bi ẕcache'e x̱toḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Kate' bi na' yex̱óalapa' doḻa' da' wbaga'a, bedó ḻaža'a dan' wžeža' dot ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Ḻawe' ža, na' yele bsako'o neda', X̱ana' Dios. Bedó ḻaža'a ka žebiže bej nis byo' wbá ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Naž bex̱óalapa' doḻa' chia', na' bi bkacha'a da' ẕinnj dan' bena'. Bechóg ḻaža'a bex̱óalapan' ḻawo' Le', X̱ana' Dios, na' benít ḻawo'o Le' che x̱toḻa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Che ḻen yógo'te benne' chio' ka' žaḻa' wḻížgake' Le' kate' ne zo' yenlo' chégake', na' kate' žin da' wžía yin' benách ka', dan' gaken ka to yegw nis ẕen da' bgóleḻe'en, bi be gonen chegak benne' chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Le' nako' ka to latje gan gak wkache' kwina', na' wkache' chawo'o neda' gan bi be wsakan' benách chio' ka'. Goḻkza' zižje ka besló' neda' dan' žox̱o' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Ẕnna X̱anžon': “Wḻoe'ela' le' nez gan žaḻa' tio'. Wsedla' le', na' wzejni'ila' le' da' žaḻa' gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Bi gako' ka to bžina' o to burrw, bia ka' bi žejní'igeklba', bia ka' žon byenen nna biá'gako'-ba', na' ko'o ya žoá'agakba' nich góngakba' ka žénelo' le'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Benne' ka' bi zej nake' chawe' žon byenen tégake' ḻo da' sáka'gake', san benne' ka' žx̱en ḻáže'gake' X̱anžon', Ḻe' žape chi'e ḻégake' ḻo yeḻa' ži'i ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Ḻe'e, benne' chawe' ka', le yebele na' le soa ḻo yeḻa' ba nez, dan' gokḻen X̱anžon' ḻe'e. Ḻo yeḻa' žebele le goḻ, dan' nakle ḻi ḻaže' ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","¡Le yebele ḻe'e, benne' chawe' ka', ḻaw X̱anžo Dios! Yeḻa' ẕka'n ẕen Dios chegak benne' chawe' ka' nakḻe'en x̱tan ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","¡Le wká'n ẕen Dios ḻen da' žinnle! ¡Le goḻ chie' ḻen da' žóḻ-ḻento' da' ze chi do chen! ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","¡Le goḻ chie' Ḻe' to da' kob! ¡Le goḻ chawe', na' chinnle ḻen yeḻa' žebele! ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Ḻi ḻaže' nak x̱tiža' X̱anžo Dios, na' dot da' bene' benen' ḻo yeḻa' ḻi ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Ḻe' nži'ile' da' nak chawe', na' da' nak dot da' li. Benne' ka' do ẕente yežlyó nga zej nónbi'e yeḻa' žeyache' ḻaže' che X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","X̱anžo Dios bene' ya'abá ḻen x̱tiže'e, na' yógo'te belj ka' da' zej nla' ẕan ya'abá bene' ḻen be' da' ẕžojen žoe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ḻe' ẕtobe' nisdo', na' yeyonen' ka to ya'a nis. Ẕga'n chawe' nisen' gže' gan bkweze' latje chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Le žebe X̱anžo Dios, yógo'tele zoale yežlyó nga. Le žebe ḻawe' Ḻe', yógo'tele ḻe'e zoale ḻo yežlyó, ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","dan' bchaḻjze', na' gok yežlyón'. Wnnakze', na' wzoakzen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","X̱anžo Dios žone' ga žeyák dáche'ze diža' da' žongak benne' zi'to' ka', na' žone' ga žak dáche'ze da' žénegekle' góngake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","san x̱tiža' X̱anžo Dios sóatezen. Da' ẕza' ḻaže'e ẕžinkzen gan zej nnita' yógo'te kwe' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Ba nez ẕen naken chegak benne' yežen' X̱anžon' nake' Dios chégake'. Wžé Dios benne' yežen' nich gákgake' benne' chekze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Gan zoe' ya'abá chie' bwia X̱anžo Dios, na' bḻe'ele' yógo'te kwe' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Gan zoe' latje la'y chie' bwie', na' bḻe'ele' yógo'te benne' ka' nníta'gake' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Ḻe' bene' yichj ḻáẕdo'gak yógo'te benách ka', na' ẕḻe'ele' yógo'te da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Bi yelá no benne' wnná bia' ni'a che benne' zante chie', benne' ka' žjake' ḻo wdiḻe, na' bi yelá no benne' waḻe ni'a che yeḻa' waḻe chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Bi zoa no benne' yelé' ni'a che bžina' chie' ka', na' bi yelá no benne' ni'a che yeḻa' waḻe ẕen chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","X̱anžo Dios ẕwíakze' benne' ka' žébegake' Ḻe'. Ẕape chi'e benne' ka' žx̱en ḻáže'gake' yeyache' ḻáže'le' Ḻe' ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","nich yeslé' ḻégake' ḻo yeḻa' got, na' nich wawe' ḻégake' kate' žak wbín. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Žx̱en ḻáže'žo X̱anžo Dios. Ḻe' žákḻene' žo'o, na' žape chi'e žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Che ḻen dot ḻáže'žo yebéḻe'elžo ḻawe' Ḻe', dan' žx̱en ḻáže'žo La la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Beyache' ḻaže'l neto', X̱anto' Dios, dan' žx̱en ḻáže'to' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Wká'n ẕénteza' X̱anžo Dios dot ža, na' yele. Góḻteza' da' we ḻawa' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Chaz ḻaža'a X̱anžo Dios. Yéngekle benne' gax̱jw ḻaže' ka' da' ki, na' yebéḻe'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Le wká'n ẕen X̱anžo Dios tẕen ḻen neda', na' tẕen we ḻawžo La la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Bḻiža' X̱anžo Dios, na' Ḻe' benle' chia', na' beslé' neda' ḻo yógo'te da' bchébegaken neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Benne' ka' bx̱en ḻáže'gake' Ḻe' bḻé'egekle' yeḻa' ẕen chie', na' bi bedoé'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Neda', benne' yache', bḻiža', na' benle X̱anžo, Dios chian', na' beslé' neda' ḻo yógo'te da' wẕáka'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Wbás ka' che ya'abá che X̱anžon' zej zoe' kwit benne' ka' ẕžébegake' Ḻe', na' žape chí'igake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Le wia nga, na' ḻé'elele nak chawe' X̱anžo Dios. Yeḻa' ba nez ẕen naken che bennen' žx̱en ḻaže'e Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Le žebe X̱anžo Dios, ḻe'e, nakle benne' chie' ka', dan' bi be žiážjegekle benne' ka' ẕžébegake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Bež yíx̱e'do' ka' žiážjegeklba', na' ẕdóngakba', san benne' ka' žx̱en ḻáže'gake' X̱anžo Dios bi be da' chawe' yážjegekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Le da, x̱kwide' ka', na' le yenle chia'. Wsedla' ḻe'e nich žébele X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","¿Noẕ benne' ládjwle ḻe'e žénele' soakze' nbane', bennen' žénele' soe' yiz zan nich ḻe'ele' da' chawe'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Bwíakze da' ẕchaḻjo' nich bi nnio' da' ẕinnj, na' nich bi wchaḻjo' da' wen laže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Bzoa cheḻa'ale da' bi nak chawe' da' ẕchaḻjo', na' ben da' nak chawe'. Ben byene so' ḻo yeḻa' ẕga'n chawe', na' ben ka nak chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Ẕwíakze X̱anžo Dios benne' ka' zej nake' chawe', na' ẕze nage' da' ẕnnábgekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Ẕža'a X̱anžo Dios benne' wen da' ẕinnj ka', na' bi soa no benne' chejsá' ḻaže'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Benne' chawe' ka' žḻížgake' X̱anžo Dios, na' Ḻe' ženle' chégake', na' žeslé' ḻégake' ḻo yógo'te da' ẕzáka'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Gawze zoa X̱anžo Dios gan zej nnita' benne' ka', benne' žak nyache' ḻáže'gake', na' žeslé' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Da' zanḻe'e da' ẕzaka' benne' chawe', san žeslá X̱anžo Dios ḻe' ḻo yógo'te da' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Ḻe' žape chi'ikze' yógo'te žit yo'o bennen', na' nitó žit chie' bi gachjwn. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Da' ẕinnj da' žon benne' bi nake' chawe' goten ḻe', na' kwia yi'gak benne' ka' ẕží'igake' chegak benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","X̱anžo Dios ẕzoa chawe'e be' da' nákgakkze benne' wen žin chie' ka', na' yógo'te benne' ka' žx̱en ḻáže'gake' Ḻe' batkle kwia yí'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","X̱ana' Dios, bsejw x̱nezgak benne' ka' ẕnnégake' chia'. Bdiḻ-ḻen benne' ka' ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Da, gape chi'o neda' ḻo wdiḻe, na' gokḻen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Bex̱w ya ntoche' tonn che wdiḻe nich wsejo' x̱nezgak benne' ka' ẕbia ḻáže'gake' neda'. Bḻoe'el neda' nako' Benne' Weslá chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Ben ga yedoé'egekle, na' chíx̱gekle benne' ka' žénegekle' gótgake' neda'. Ben ga wẕonnjgak, na' yedoé'egekle benne' ka' žénegekle' góngake' neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Ben ga gákgake' ka to laga' biž da' žwa' be', na' bseḻa' wbás la'y chio' nich wlage' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Ben choḻ x̱nézgake' nich kwílgake', na' bseḻa' wbás la'y chion' nich kwia ḻaže'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Bkáche'gake' to do yeḻj nich senen neda', na' bi be bena' chégake'. Bché'ngake' to yežw gan chejbix̱a' neda', na' bi be da' ẕia nbaga'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Bseḻa' da' wžía yin' ḻégake', da' bi gákbe'egeklen'. Ben ga sen do yeḻj chégaken' ḻa' légakkze', na' ga chejchégwgake' gan kwia yí'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Naž yebéḻe'ekzla' ni'a che da' ben X̱anžo Dios. Gak yeḻa' ba nez ẕen chia' dan' beslé' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Yógo'te žit yoa'a nnágaken: “X̱anto' Dios, ¿noẕkze benne' nake' ẕen ka nako' Le'? Žesló' benne' yache' ḻo na' benne' nakže' waḻe ka ḻe', na' benne' žiážjele' ḻo na' benne' ẕbane' da' do' da' den chie'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Bḻa'gak benne' ka' žechébegake' da' wen ḻaže'. Wnnábgekle' neda' ka nak che to da' bi nnezla'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Bebí'igake' chia' da' ẕinnj ni'a che to da' chawe' da' bena' neda', nich wsáka'gake' neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","san neda', kate' bi wnníta'gake' chawe', gok nyache' ḻaža'a, na' bena' wbás, na' bsaka' kwina'. Dot ḻaža'a bḻiža' Le', Dios, nich yeyono' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Gok nyache' ḻaža'a ni'a chegak benne' ka' kan žona' ni'a che bi' lježa', o ni'a che bi' bíche'kza'. Gok nyache' ḻaža'a ka žon no benne' ni'a che x̱ne'e kate' ne žate', ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","san bebégekle benne' ka' kate' wzóa da' bsakan' neda', na' bedjwíagake' neda'. Bdíḻ-ḻengak benne' wen da' ẕinnj ka' neda', na' choḻze bzétjgake' neda'. Bwíatezegake' neda', na' bi bsángake' da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Bsáka'gake' neda', na' ben dítjgekle' neda', na' wžía ḻáže'gake' neda' ḻo yeḻa' ẕža'a chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","X̱ana' Dios, ¿to chi'ize wíazo' da' žóngake'? Beslá neda' ḻo na'gak benne' ka' ẕžia yí'gake' neda', benne' ka' zej nake' ka bež yix̱e' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Yapa' Le' “Žóx̱keno'” gan zej ndobe benne' chio' ka'. Wká'n ẕénteza' Le' ladjw benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Bi go'o latje yebégekle benne' ka' bi ẕḻé'egekle' neda' chawe', na' bi be bena' chégake'. Bi go'o latje benne' ka' gon dítjgekle neda', benne' ka' ẕžá'agake' neda', na' bi be ẕia nbaga'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Benne' ki bi žénegekle' sóagake' ḻo yeḻa' ẕga'n chawe', na' ḻo yeḻa' wen ḻaže' chégake' ẕnnégake' chegak benne' ka' ẕbézgake' ži ḻaže' ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Ben dítjgekle' neda', na' wnnágake': “Ba bḻe'elto' da' bene'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","X̱ana' Dios, bḻe'ekzlo' da' žóngake'. Bi so' žize. X̱ana' Dios, bi kwej yichjo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Wzó ža'. Wzóa wchi'a ḻažo'o neda'. Da, X̱ana' Dios, nich gákḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Bchi'a ḻaže' neda' ḻo da' chawe' chio', X̱ana' Dios. Bi go'o benne' ka' latje wẕížegake' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Bi go'o latje nnágake': “Ba gok da' wzé ḻáže'žo”, na' bi nnágake': “Ba bzéx̱jwžo ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Ben ga yedoé'egekle, na' chíx̱gekle yógo'te benne' ka' žebégekle' kate' bi žak chia'. Ben ga yedoé'egekle, na' ga'ngak ka'ze benne' ka' ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Ben ga goḻgak, na' yebégekle benne' ka' ẕḻé'egekle' neda' chawe', nich nnágakkze': “¡Ga'n ẕen X̱anžon'!” Bennen' žak ḻaže'e ga'n chawe' benne' wen žin chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Wcháḻjteza' che da' chawe' da' nako' Le', na' wká'n ẕénteza' Le' dot ža, na' yele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Da' ẕinnj da' žon bennen' ẕzoe' Dios cheḻa'ale ẕcháḻjḻenen ḻe' ḻo yichj ḻáẕda'we'. Bi ẕdan ḻáže'kze' gape' Dios ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Che ḻen ẕḻoe'el kwine' ka to benne' ẕente. Žekle' bi ẕḻe'el Dios da' ẕinnj da' žone', na' bi ẕže'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Da' ẕchaḻjze' naken da' ẕinnj, na' da' wen ḻaže'. Biž žejni'ile' binlo, na' biž žone' da' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ẕlab ḻaže'e da' bi nak chawe' katen' die' gan ẕtase'. Yoe'e nez da' bi naken chawe'. Bi žénele' wsane' žone' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","X̱ana' Dios, ẕente nak yeḻa' žeyache' ḻaže' chio' dan' ẕžinten ẕan ya'abá. Yeḻa' ḻi ḻaže' chio' ẕžinten ḻo bejw. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Da' chawe' da' nako' naken ka to ya'a ẕen chio', na' ka ẕchi'a ḻažo'o naken ka to nisdo' zil-ḻe'e. X̱ana' Dios, ẕwíakzo' benách ka', na' bia yix̱e' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Ẕenḻe'e nak yeḻa' žeyache' ḻaže' chio', Dios. Che ḻen žx̱en ḻáže'gak benne' ka' Le' ka žongak bríse'do' ka' ẕkache' kwíngakba' ẕan x̱il ẕkoko'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Yéljgekle' ḻen da' deḻe'e ližo' na' Le' wye'jo' ḻégake' da' naken ka to yegw da' yožen nis dẕi'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Gan zo' Le' zoa gan žaḻ nis dan' žonnen yeḻa' nban. Ḻo yeḻa' baní' chio' ẕḻe'elto' da' nak baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Beyache' ḻaže'l benne' ka' zej nónbi'e Le', na' bzoa chegak benne' ḻi ḻaže' ka' da' nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Bi go'o latje benne' ẕka'n ẕen kwine' tíḻ-ḻene' neda', na' bi wchíx̱ benne' wen da' ẕinnj neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Chejchégwgak benne' ka' žóngake' da' ẕinnj. Le' beno' ga bejchégwgak benne' ka', na' bi gak yeyásgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Bi kwe' zedlo' ni'a che da' žongak benne' ka' bi zej nake' chawe', na' bi ge'elo' ni'a che da' zej nape benne' wen da' ẕinnj ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","dan' te chegak benne' ka' ka žak che yix̱e' biž, na' gak chégake' ka žak che yix̱e' da' nžogen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Bx̱en ḻaže' X̱anžo Dios, na' ben da' chawe', na' soakzo' nbano', na' si'kzo' yeḻa' ba nez. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Wyáz ḻaže' X̱anžon', na' Ḻe' gonnkze' chio' da' ẕdan ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Bzoa kwino' ḻo na' X̱anžon', na' bx̱en ḻaže'e Ḻe', na' Ḻe' gone' da' ẕnnablo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Wḻoe'ele' da' chawe' da' nako' ka to da' žsa'ní', na' da' ḻi ḻaže' chio' ka ḻawe' ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Wzóa žize ḻaw X̱anžon', na' bẕen ḻaže'e Ḻe'. Bi kwe' zedlo' ni'a che no benne' ẕzi'e yeḻa' ba nez, bennen' žonkze' da' bi nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Bzoa cheḻa'ale yeḻa' yichj ža'a, na' bi žo'o. Bi gak ḻažo'o yebi'o che bennen' bi nake' chawe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","dan' wžía yi' Dios benne' wen da' ẕinnj ka', san benne' ka' žx̱en ḻáže'gake' X̱anžon', gata' chégake' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Yextído'ze biž soa bennen' bi nake' chawe'. Ḻe'elo' liže latje bennen' san biž soe' ga na', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","san benne' gax̱jw ḻaže' ka' gata' chégake' yežlyó, na' sí'gake' yeḻa' ba nez che yeḻa' ẕga'n chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Benne' wen da' ẕinnj žénele' bi da' gone' che benne' chawe'. Ḻo yeḻa' ẕža'a chie' bi ẕḻe'ele' ḻe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","X̱anžo Dios wẕížekze' chegak benne' wen da' ẕinnj ka' dan' ẕḻe'ele' za' gawze ža kwia yí'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Benne' wen da' ẕinnj ka' ẕbéjgake' ya ntoche' ka', na' ba nzégake' yag ntóche'do' chégake' ka' nich wžía yí'gake' benne' yache' ka', na' benne' ka' žiážjegekle', nich gótgake' benne' ka' žóngake' da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Ya ntoche' chégake' chazen ḻaẕdo' kwíngakkze', na' gáchjwgak yag ntóche'do' chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Záka'že da' do' da' nape benne' chawe' ka yeḻa' wnni'a ẕen da' zej nape benne' wen da' ẕinnj ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","dan' gátgakkze ni'a na'gak benne' wen da' ẕinnj ka', san X̱anžo na'kze ẕwíakze' benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Nonbia' X̱anžon' baḻ ža sóagake' nbángake'. Da' zej nape benne' chawe' ka' soan to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Bi yedoé'egekle benne' ka' kate' bi žak chégake', na' ḻo ža kate' žak wbín gata' da' gáwgake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","san kwia yi'gak benne' wen da' ẕinnj ka', na' benne' ka' ẕží'igake' che X̱anžon', gak chégake' ka žak chegak yeje yix̱e' ka'. Te chégake', na' nítgekle' ka ẕnit žen che yi'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Benne' ka' bi zej nake' chawe' to da' ẕnnábgake' to chí'ido'ze, san bi ženéẕjwgaken', san benne' chawe' žeyache' ḻáže'le' lježe' ka', na' ẕneẕjwe' bi da' žiážjele'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Benne' ka' ẕḻe'el X̱anžon' ḻégake' chawe', gata' chégake' yežlyó, san benne' ka' bi ẕḻe'ele' chawe', kwia yí'gakkze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Da' žongak benne' chawe' ka' naken da' bḻoe'el X̱anžon' ḻégake', na' ẕḻe'ele' chawe' yógo'te da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Kate' chejchégwgak benne' chawe' ka', bi chejchégwgake' to chi'ize dan' nox̱w X̱anžon' ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Goka' x̱kwide', na' na'a naka' benne' gole, na' batkle bḻe'ela' to benne' chawe' wsán Dios ḻe', na' bi ẕdagak ẕa'sógake' ka' ẕnnábgakbe' bi da' gonn no benne' chégakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Benne' chawe' ki žeyache' ḻáže'tezle', na' ẕneẕjwe' bi da' žiážjele no benne', na' ẕa'sóe' ka' žak yeḻa' ba nez chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Biž gono' da' bi nak chawe', san ben da' chawe', na' so' nbankzo' to chi'ize, ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","dan' nži'il X̱anžon' da' nak ḻi ḻaže', na' bi žsane' benne' chie' ka'. To chi'ize gape chi'ikze' ḻégake', san wžía yi'e lježgak benne' ka' bi zej nake' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Benne' chawe' ka' gata' chégake' yežlyó nga, na' nníta'gake' to chi'ize ḻo yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Benne' chawe' ẕchaḻjze' da' žejni'ile', na' ka ẕchi'a ḻaže'e naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Da' bchi'le Dios ḻe' yo'on yichj ḻáẕda'we'. Che ḻen bi chejchegwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Benne' wen da' ẕinnj ẕḻe'ele' benne' chawen', na' žon byene' gote' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Bi wsán X̱anžon' ḻe' ḻo na' bennen' bi nake' chawe', na' bi wžía yi'e ḻe' kate' wchi'a ḻaže'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Bx̱en ḻaže' X̱anžon', na' ben ka ẕnna x̱tiže'e, na' Ḻe' wchiskze' le' nich gata' chio' yežlyó nga. Kate' kwia yi'gak benne' doḻa' ka', na' ḻe'elon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Bḻe'ela' to benne' wen da' ẕinnj, benne' ẕente, na' góta'ḻe'e da' nape' ka da' ẕneẕjw to yag ẕente, ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","san wdé chie', na' biž zoe' na'a. Bejdilja' ḻe', san bi bežeḻ-la'-ne'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Blab ḻaže' ka nak che benne' ḻi ḻaže', na' bwia bennen' nake' chawe', dan' ga ze ḻawte gak to yeḻa' ba nez ẕen che bennen' zoe' ḻo yeḻa' ẕga'n chawe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","san benne' wen da' ẕinnj ka' kwia yí'gakkze'. Bi soa no lježgak benne' wen da' ẕinnj ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","san X̱anžo Dios yeslé' benne' chawe' ka', na' Ḻe' gon choche' benne' ka' kate' bi gak chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","X̱anžo Dios gákḻene' ḻégake', na' yeslé' ḻégake' ḻo na'gak benne' ka' bi zej nake' chawe', na' gon chawe'e ḻégake', dan' žx̱en ḻáže'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","X̱ana' Dios, bi tiḻo' neda' ḻo yeḻa' ẕža'a chio'. Bi wsako'o neda' ḻo yeḻa' snia chio', ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","dan' yag ntóche'do' chio' ka' wyázgaken neda', na' ḻen no'o bsaka' zi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Bi zoa chawe' beḻa' žen chia' dan' ẕžo'o neda', na' žit yoa'a bi zej zoan chawe' dan' bena' doḻa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Da' ẕinnj ka' da' bena' ẕbága'gaken yichj ḻáẕda'wa'. Zej naken chia' ka to ywa' zí'iḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Žia we' dot da' naka', na' ẕlaḻe'en, na' nóžwgak we' chia' ka'. Žaken chia' ki dan' bena' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ẕda' ẕwia' ḻo yole, dan' žedoe'ela', na' ẕbeže nyacha'a dot ža, na' yele, ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","dan' dot da' naka' ẕláḻe'en, na' bi zoa chawe' beḻa' žen chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Nat ni'a na'a, na' žekla' zej nžoẕjen žit yoa'a. Ẕbeže ḻaža'a dan' že' zedle yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","X̱ana' Dios, da' ẕdan ḻaža'a zóaḻenen Le', na' da' ẕbeže ḻaža'a ẕḻé'ekzlo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Žat ḻáẕda'wa', na' ba bedó ḻaža'a, na' biž ẕḻe'ela' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Žebíga'gak lježa' ka' zíto'le ni'a che yižwé' chia', na' benne' ẕjo'o ḻi'a chia' ka' ba bkwásgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Benne' ka' žénegekle' gótgake' neda' ẕzáḻa'gake' do yeḻj nich senen neda', na' benne' ka' žénegekle' góngake' neda' ẕia ẕnnégake' chia', na' ẕnnágake' kwia yi'a, na' zóatezegake' wsáka'gake' neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","san neda' bi ženla', kan žak che to benne' kwežw, na' naka' ka to benne' bi žak nne', benne' bi žsaljwe' žoe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Naka' ka to benne' bi be ženle', bennen' bi žechebe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","dan' žx̱en ḻaža'a Le', X̱ana' Dios. Le' yechebo' ḻo wlaza' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Bi go'o latje yebégekle' ni'a che da' žaken chia'. Kate' chejchegwa', bi go'o ḻégake' latje wká'n ẕen kwíngake' dan' žak nyache' ḻaža'a, ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","san za' chejchegwa', na' ẕláteze dot da' naka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Che ḻen yex̱óalapa' da' bi nak chawe' da' bena', na' gak nyache' ḻaža'a ni'a che doḻa' da' nbaga'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Benne' ka' bi ẕḻé'egekle' neda' chawe' zej zoakze' chawe', na' zej nake' waḻe. Zej nyanḻe'e benne' ka' bi ẕḻé'egekle' neda' chawe', na' bi be ẕia bena' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Benne' ka' žóngake' benne' chawe' ka' ẕia. Zej nake' benne' ka' bi ẕḻé'egekle' neda' chawe' dan' žónteza' da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Bi kwej yichjo' neda', X̱ana' Dios. Dios chia', bi so' zi'to' gan zoa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Ben byene gákḻeno' neda', X̱ana' Dios. Nakkzo' Le' Benne' Weslá chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Neda' wnnía': “Gon chi'a binlo kwina' nich bi gona' doḻa' ḻo da' wchaḻja'. Gon chi'a binlo da' wchaḻja', x̱ak zoa benne' wen da' ẕinnj gan zoa' neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Wzóa' žize ka to benne' bi žak nnie' na' bi be wnnía', na' bi bchaḻja' da' naken chawe' da' žaḻa' nnia', na' bgolže da' ẕzaka'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Gok ḻáẕda'wa' ka to da' žeyen, na' x̱ak blab ḻaža'a chen, goken ka to yi', na' wnnabla' X̱anžon', wnnía': ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“X̱ana' Dios, bḻoe'el neda' da' gak chia', na' baḻ ža soa' nbana'. Bzejní'il neda' bayén batx̱ gata'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Beno' chia' soa' nbabze ža, na' yiz chia' bi be zej naken ḻawo' Le'. Da' likze bi be zej nak ža chegak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","“Da' li zej nak benne' ka' ka to ẕóḻdo'ze. Da' likze dáche'ze zej že' benne' ka' wnné yoe ni'a che yeḻa' nban chégake'. Ẕdan ḻáže'gake' yeḻa' wnni'a, na' bi zej nnezle' no benne' gaken chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Na'a, X̱ana' Dios, ¿biẕkze wx̱én ḻaža'a? Toze Le' žaḻa' wx̱én ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Beslá neda' ḻo yógo'te da' ẕinnj da' bena'. Bi go'o latje benne' yaḻ ḻaže' ka' gon dítjgekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Wzóa' žize, na' bi be wnnía' dan' beno' Le' goken ki chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Beká'a yižwé' da' bzo' ḻo beḻa' žen chia'. Za' gata' ḻo da' žsako'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Žsako'o no benne' doḻa' nich wzejni'ilo'-ne', na' ka žon beldon' ẕteba' laže', Le' ẕchinnjo' da' nží'ižele bennen'. Da' likze bi be zej nak ža chegak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“Benle da' ẕnnabla' Le', X̱ana' Dios, na' bze nag da' žḻiža' Le'. Bi so' žize kate' zoa' ẕbeža' ḻawo' Le' dan' naka' neda' ḻawo' Le' ka to benne' ẕdaze' yežlyó. Naka' ka to byinne ẕdezba' kan gokgak x̱a x̱na' wdé chia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Bi be gono' chia' to chi'ize nich gata' latje yezí' ḻaža'a, dan' ḻa' yeza'tia' yežlyó nga, na' biž soa'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Ḻo yeḻa' ẕen ḻaže' chia' wleza' X̱ana' Dios, na' bze nage' chia', na' benle' da' wnnabla' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Bebeje' neda' ka to ḻo yežw gže', na' ḻo da' nak ka gona'. Bzoe' ni'a to ḻo yej x̱e, na' begoé'e neda' nez chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Bene' ga žoḻa' to da' kob da' ẕka'n ẕenen X̱anžon'. Benne' zante ḻé'egekle' da' ni da' bene' Ḻe', na' žébegake' Ḻe', na' wx̱én ḻáže'gake' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Ba nez ẕen naken che bennen' žx̱en ḻaže'e X̱anžo Dios, na' bi žónḻene' tẕen benne' ka' ẕží'igake' che Dios, na' kege ḻen benne' ka' ẕka'n ẕéngake' lo'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Da' ẕenḻe'e beno', X̱ana' Dios, na' žebanlto', na' ka zej nak da' žak ḻažo'o Le' gono' cheto', bi gak wlabto' ḻawo' Le'. Cha' wzenla' no benne' ka zej naken, na' cha' wchaḻja' chégaken, bi gak wlaba' ḻégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Bi chaz ḻažo'o biado' ka' gota' ḻawo' Le', cha' to da' gonna' chio'. Bi ẕnnabo' biado' ka' wzeya' ḻawo' Le', na' žen chegak biado' ka' da' ko'an ḻawo' Le' ni'a che doḻa' chia', san bsaljo' naga' nich yenla' chi'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Naž wnnía': “Bwia nga, za'a neda'. Nyejw ḻe'e yiche la'y ka nak chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Žaz ḻaža'a gona' da' žak ḻažo'o Le', Dios chia', na' da' wnnakzo' Le' yo'on ḻo yichj ḻáẕda'wa'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ba bzenla' benne' ka' da' chawe' da' nako' gan zej ndobe benne' zante ka' ḻawo' Le'. Bwia nga, bi wzóa' žize, na' nnézkzelon' Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Bi bkáche'za' da' chawe' da' nako' ḻo ḻáẕda'wa', san bchaḻjkza' ka nak yeḻa' ḻi ḻaže' chio', na' kan žesló' benne' ka'. Bi wzóa' žize ka nak yeḻa' žeyache' ḻaže' chio', na' ka nak da' naken dot da' li chio' ladjw benne' zante zej ndobe' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","X̱ana' Dios, bi želo' yeyache' ḻáže'lo' neda'. Yeḻa' žeyache' ḻaže' chio', na' da' likze chio' žákḻentezegaken neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Nyéchjgekle da' bi nak chawe' ka' neda', na' da' bi nak chawe' ka' da' bena' zej žian neda'. Che ḻen bi gak chis ḻawa' ḻawo' Le'. Zej nyanžen ka zej nak yicha' yichja' na' žedó ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Ẕnnabla' Le', X̱ana' Dios, yesló' neda'. X̱ana' Dios, ben byene gákḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Ben ga yedoé'egekle, na' chíx̱gekle benne' ka' žénegekle' gótgake' neda'. Ben ga wẕonnjgak, na' yedoé'egekle benne' ka' žak ḻáže'gake' góngake' neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Ben ga chíx̱gekle, na' wẕonnjgak benne' ka' ben dítjgekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Ben ga yebégekle, na' soagak ḻo yeḻa' ba nez benne' ka' žx̱en ḻáže'gake' Le', na' nnégakkze benne' ka' zej nži'ile' Le', Benne' Weslá chégake'. Nnágake': “¡Ga'n ẕen X̱anžon'!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ḻa'kze wsáka'gake' neda', na' gak nyache' ḻaža'a, bi gaḻ ḻažo'o Le' neda', X̱ana' Dios. Le' žákḻeno' neda', na' žesló' neda'. X̱ana' Dios. Bi želo' gákḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Ba nez ẕen naken che bennen' že' ḻaže'e benne' yache' ka'. Bi ža zoe' ḻo da' zede, yeslá X̱anžon' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","X̱anžon' gape chi'ikze' ḻe', na' wneẕjwe' ḻe' yeḻa' nban. Gak to yeḻa' ba nez ẕen che bennen' ḻo yežlyó nga, na' bi wdé X̱anžon' ḻe' ḻo na'gak benne' ka' bi ẕḻé'egekle' ḻe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","X̱anžo Dios góx̱wkze' ḻe' kate' die' gan ẕzáka'ḻi'e. Yeyón chawe'e dot da' nake' katen' bi zoe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Wnnía': “X̱ana' Dios, beyache' ḻaže'l neda'. Beyón be' da' nakkza' dan' bena' doḻa' kate' bži'a chio' Le'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Benne' ka' bi ẕḻé'egekle' neda' chawe' ẕnnégake' chia', na' ẕnnábgake': “¿Batx̱ gat benne' ni, na' gak gaḻ ḻáže'to' ḻe'?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Žedjwíagake' neda', san kege nich gak chia' da' chawe'. Ẕbéjgake' neda' diža' nich gak nnégake' chia', na' kate' žežójgake', na' ẕzégake' dižan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Kate' ẕdobgak benne' ka' bi ẕḻé'egekle' neda' chawe', na' ẕnnétezegake' chia'. Ẕcháḻjḻentezegake' ljéžgake' ka' chia' neda', na' ẕnnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Ba de'e to yižwé' da' goten ḻe', na' biž yeyase' gan die'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ḻeska' bennen' bga'n chawe'e ḻen neda', bennen' bx̱en ḻaža'a, na' bdáwḻenkze' neda', benne' ni wnnekze' chia' neda' ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","san Le', X̱ana' Dios, beyache' ḻaže'l neda', na' ben ga yeyasa', na' yebi'a chegak benne' ka' da' yeyáḻa'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Kikze nnezla' žona' da' žaz ḻažo'o Le', na' bennen' bi ẕḻe'ele' neda' chawe' bi be gak gone' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Le' nóx̱wkzo' neda' dan' naka' gaẕjw ḻaže', na' bzo' neda' ḻawo' Le' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","¡Ga'n ẕen X̱anžon'! Nake' Dios chegak benne' Israel ka' yógo'te yiz nníta'gake', na' to chi'ize. Ka'kze naken, na' ka'kze gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ka žon bžina' yix̱e' ẕbéžeya'aba' dan' ẕbiḻba', ka' ẕnnab be' da' nakkza' da' nak chio', Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ẕbiḻe be' da' nakkza' dan' naken chio', Dios ban. ¿Batx̱ gak yida' nich ḻa'a ḻawo' Le', Dios? ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Nis da' ẕbeža' goken ka yet žawa' dot ža, na' yel, na' ẕnnábgekle' neda' yógo'te ža, na' ẕnnágake': “¿Ganẕkze Dios chio'?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Žezá' ḻaža'a da' ki, na' ẕbeže ḻaža'a. Žezá' ḻaža'a kan wyá'aḻena' benne' zan ka', na' wneẕwa' ḻáwgake' ḻo liž Dios, Beḻžo ḻo yeḻa' žebele, na' bka'n ẕenžo Dios ḻo lni. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","¿Biẕ chen' žat ni'a no'o, be' da' nakkza'? ¿Biẕ chen' že' zedlo' ḻo yichj ḻáẕda'wa'? Bx̱en ḻaže' Dios dan' wká'n ẕenkza' Ḻe' da' yoble. Nake' Benne' Weslá chia', na' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","X̱ana' Dios, ba nat ni'a na' be' da' nakkza' ḻo yichj ḻáẕda'wa'. Che ḻen žezá' ḻaža'a chio' kate' ne zoa' ḻo yežlyó yecheḻa'ale yegw Jordán nga, ḻo ya'a Hermón gan že' Ya'a Misar. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ka nak žax̱to' da' žon nisdo', ka' žon to nis wbá'a chio', Dios. Ẕzaka' be' da' nakkza' dan' nis wbá'a dan' bselo'o ẕchen' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Tža tža žeyache' ḻaže'l X̱anžon' neda', na' žel goḻkza' da' we ḻawa' Ḻe', na' wcháḻjḻena' Dios, Bennen' žonne' yeḻa' nban chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Yapa' Dios: “Le' žape chi'o neda'. ¿Biẕ chen' naḻ ḻažo'o neda'? ¿Biẕ chen' žak nyache' ḻaža'a dan' benne' bi ẕḻe'ele' neda' chawe' žsake'e neda'?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Žlagak žit yoa'a dan' benne' ka' bi ẕḻé'egekle' neda' chawe' žon dítjgekle' neda'. Tža tža ẕnnábgekle' neda', na' ẕnnagake': “¿Ganẕkze Dios chio'?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","¿Biẕ chen' žat ni'a no'o, be' da' nakkza'? ¿Biẕ chen' že' zedlo' ḻo yichj ḻáẕda'wa'? Bx̱en ḻaže' Dios dan' wká'n ẕenkza' Le' da' yoble. Nake' Benne' žeslé' neda', na' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Bchi'a ḻaže' neda', X̱ana' Dios, na' bḻoe'e ḻaw naka' chawe'. Beslá neda' ḻo na'gak benne' ka' ẕzóagake' Le' cheḻa'ale, na' ḻo na'gak benne' wen ḻaže' ka', benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Nako' Le' Dios chia', na' ẕzoa chocho' neda'. ¿Biẕ chen' bsan ḻažo'o neda'? ¿Biẕ chen' žak nyache' ḻaža'a dan' benne' bi ẕḻe'ele' neda' chawe' žsaka' zi'e neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Bseḻa' yeḻa' baní' chio', na' da' likze chio' ga zoa' ni. Da' ki yegó'ogaken neda' nez. Wché'gaken neda' ḻaw ya'a la'y chio', na' gan zoakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Choa'a gan zoa bkog la'y che Dios. Choa'a ḻaw Dios, Bennen' žone' ga žebela', na' gan soa' ḻo yeḻa' ba nez. Wká'n ẕena' Le' ḻen da' žinna'. Le' nako' Dios chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","¿Biẕ chen' žat ni'a no'o, be' da' nakkza'? ¿Biẕ chen' že' zedlo' ḻo yichj ḻáẕda'wa'? Bx̱en ḻaže' Dios dan' wká'n ẕenkza' Le' da' yoble. Nake' Benne' žeslé' neda', na' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Dios, x̱a x̱na' gole cheto' ka' bzéngekle' neto' da' beno' ḻo ža chégake', dan' beno' yiz wdé ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Bchinnjo' yezika' yež ka' ḻawgak x̱a x̱na' gole cheto' ka', na' bnnito'o ḻégake' ḻo latje chegak benách ca'. Bsáka'ḻi'o benne' yež ka', san bzoa chocho' benne' chio' ka' ḻo yežlyó gan zoato' neto' na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","X̱a x̱na' gole cheto' ka' bi wẕí'gake' yežlyó nga ḻen ya ntoche' chégakkze' ka'. Bi beslá kwíngake' ḻen yeḻa' waḻe da' zej nape', san Le' besló' ḻégake' ḻen yeḻa' wak chio', na' ḻen yeḻa' waḻe chio', na' ḻen yeḻa' ẕen chio', dan' wyáz ḻažo'o ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Le', Dios, nako' Benne' Wnná Bia' chia'. Beslá neto', ẕa'só Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ḻen yeḻa' wak chio' Le' wzéx̱jwto' benne' ka' ẕdíḻ-ḻengake' neto'. Ni'a chio' Le' ẕzéx̱jwto' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Bi wx̱én ḻaža'a yag ntoche' chia', dan' bi yeslán neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Le' wdape chi'o neto' nich bi be gok gongak cheto' benne' ka' bi ẕḻé'egekle' neto' chawe'. Beno' ga bedoé'egekle benne' ka' ẕžá'agake' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Ni'a chio' Le', Dios, sóatezto' ḻo yeḻa' ba nez, na' to chi'ize wx̱én ḻáže'to' Le', ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","san wléj yichjo' neto', na' beno' ga žedoe'elto', na' bi žéjḻeno' benne' cheto' ka', benne' žjake' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Beno' ga bẕonnjto' ḻawgak benne' ka' ẕdíḻ-ḻengake' neto', na' benne' ka' ẕží'igake' cheto' beká'agake' yógo'te da' wdapto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Bdio' neto' ka ẕila' ka' ḻo na'gak benne' ka' žótgake' neto', na' besḻaso' neto' ladjw benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Bdezo' neto', benne' chio' ka', ḻo ná'gake', na' bi be bezi'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Beno' ga benne' yež gawze ka' ẕnnégake' cheto'. Benne' zej nyechjle' neto' ẕká'ngake' neto' ka'ze, na' žẕížegake' cheto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Bzo' neto' ka to da' ẕnnagak benne' wláž cheto' ka' naken to da' nyáche'ḻe'e. Kate' ẕḻé'egekle benne' ka' neto', ẕta yíchjgake', na' žebángekle' ka žak nyache' ḻáže'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Tža tža žedoé'etezla', na' žé'teza' ḻo da' zedḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Ẕnnégake' chia', na' ẕzóagake' neda' cheḻa'ale. Benne' ka' bi ẕḻé'egekle' neda' chawe' ẕži'igake' chia', na' žóngake' neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Yógo'te da' ki žákgaken cheto', san bi na' gaḻ ḻáže'to' Le'. Bi na' wzoato' cheḻa'ale x̱tižo'o dan' bénḻeno' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Bi na' wsán ḻáže'to' Le', na' bi na' wzoato' cheḻa'ale da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","¿Biẕ chen' bzo' neto' cheḻa'ale lo latj chegak bia snia ka', na' bzo' neto' gan za' gatto'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Chela' goḻ ḻáže'to' Dios cheto', o chela' bka'n ẕento' lo'a ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","¿bi žaḻa' ža'a Dios neto' ni'a che da' ki? Ḻe' nnézkzele' da' yo'o ḻo yichj ḻáẕdo'gak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Dan' nakto' chio', tža tža zóagake' gótgake' neto'. Béngake' neto' ka ẕila' za' gótgake'-ba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","¡Bebán, X̱anto' Dios! ¿Biẕ chen' ẕtaso'? ¡Bebán! ¡Bi so' zi'to' to chi'ize! ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","¿Biẕ chen' bkache' kwino', na' bi žákbe'elo' kan ẕzáka'ḻe'eto', na' kan ẕkóngekle benne' ka' neto' žin? ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Ba nat ni'a na' be' da' nakkzto', dan' bzéx̱jwgake' neto', na' žx̱óbgake' neto' ḻo yo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","¡Wzó ža'! ¡Gokḻen neto'! ¡Ḻo yeḻa' žeyache' ḻaže' chio', beslá neto'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Yo'o yichj ḻáẕda'wa' diža' x̱tanḻe'e ka', na' goḻkza' ka nak che benne' wnná bia'. Goḻkza' da' bzoj to benne' ẕcháḻjḻi'e chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Nako' le' x̱tánle'eže ka yógo'te benne' ka'. Nak cheto' yeḻa' ba nez ni'a che da' ẕchaḻjo', dan' Dios ben cháwe'kze' le' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Bda' ya ntoche' chio' žoa'a ḻi'o, le', benne' waḻe, ḻo yeḻa' ẕen chio', na' ḻo yeḻa' wnná bia' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ḻo yeḻa' ẕen chio' zo' nbankzo'. Bkonle žin diža' li, na' yeḻa' gax̱jw ḻaže', na' da' chawe', na' wzejní'il kwino' da' ẕenḻe'e ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Zej nḻáḻe'egak yag ntóche'do' chio' ka', da' ka' gótgaken benne' yež ka' ḻawo' le', na' cházgaken ḻáẕdo'gak benne' ka' ẕžá'agake' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Gan ži'o, Dios, žen' to chi'ize, na' sóatezen. Chawe' nak ka ẕnna bi'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Nži'ilo' da' nak chawe', na' bi ẕḻe'elo' chawe' da' bi nak chawe'. Che ḻen Dios chio' bzoe' le' latje chio', gan žebéḻe'eželo' ka lježo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ẕḻa' ẕix̱ ẕa lano' ḻen da' ka' zej naken mirra, na' áloe, na' kasia, da' ka' ẕḻá'gaken ẕix̱. Ḻo ližo' da' záka'ḻe'en ẕzóagake' le' ḻo yeḻa' ba nez. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bi' no'le chegak benne' wnná bia' ka' zej zoabe' ladjw ẕo'lo' ka', no'le ka' zej nakže' blo. Kwito' ḻi ža že' bi' no'len' gakbe' ẕo'lo', bi' no'len' si'be' oro da' zan' zaka' yež Ofir. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Bze nag, nó'ledo', na' bwia nga, na' benle da' nnia'. Žaḻa' gaḻ ḻažo'o lažo', na' liž x̱o', ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","na' benne' wnná bian' dan ḻaže'e yeḻa' x̱tan chio'. Gok gax̱jw ḻaže' ḻawe' ḻe' dan' nake' ḻe' x̱ano', ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","na' ḻa'gak no'le yež Tiro ka' ḻawo' le', zej noe'e da' gónngake' chio'. Nnabgak benne' wnni'a ka' to da' gono' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","X̱tanle'e nak bi' no'le che benne' wnná bian' ḻo yo'o gan zoe'. Ẕa lánabe' nzin' da' x̱tan ka' da' zej naken oro. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Wché'gake'-be' ḻaw benne' wnná bian', nákwbe' ẕa lánabe' dan' nwa'ḻe'en da' x̱tan ka'. X̱kwide' nó'ledo' ka' chjakbe' x̱kóže'lbe'. Nó'ledo' ki, no'le lježbe' ka', wché'gakbe' ḻebe' ḻaw benne' wnná bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Ḻo yeḻa' žebele, na' ḻo yeḻa' ba nez wché'gakbe' ḻebe', na' chó'ogakbe' ližo', benne' wnná bia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Ḻo latje chegak x̱a x̱to'o ka' soagak ẕi'no' ka'. Gono' ga nna bia'gak x̱kwide' chio' ka' do ẕente yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Gona' ga chejsá' ḻáže'gak yógo'te benne' ka' lo'. Che ḻen wká'n ẕengak benne' ka' le' yógo'te yiz so', na' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Dios ẕḻe'ekzle' žo'o, na' žone' žo'o benne' waḻe ka'. Zóateze' gákḻene' žo'o kate' ẕzáka'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Che ḻen, bi žébežo ḻa'kze x̱o' yežlyó nga, na' chejchazgak ya'a ka' ḻo nisdo', ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","na' ḻa'kze chasḻe'e nisdon', na' gonḻe'en žax̱to', na' ẕízegak ya'a ka' ni'a che da' žẕo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","De to yegw da' ẕnnen ḻo yeḻa' žebele ḻo yež che Dios, na' ḻo liž Dios, Bennen' nape' dot yeḻa' ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Dios zoe' yežen', na' batkle kwia yin'. Yide' zildo' na' gákḻene' benne' wláž ka' che yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ẕbéžeya'agak benne' yežlyó nga, na' ẕžébegake' Dios, Benne' Wnná Bia' Ẕen. Ẕnne Dios kan ẕnne wzió', na' ẕbia yi' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Dios, Bennen' nape' dot yeḻa' wak, zóaḻene' žo'o. Dios na' che Jakob ẕkache' chawe'e žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Le da ḻé'elele da' ka' ben X̱anžon'. Le wia dan' bene' ḻo yežlyó dan' žonen ga žebanlžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Ẕzoa žie' wdiḻe ka' žákgaken do ẕente yežlyó. Žichje' da' ka' ẕsegak yag ntóche'do' ka', na' ẕzoẕjwe' yag ntoche' ka' che wdiḻe, na' ẕzeye' karro ka' che wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ẕnna Dios: “Le soa žize, na' le nnezle naka' Dios. Napža' yeḻa' wak ka da' zej nape yógo'te yež ka'. Napža' yeḻa' wak ka da' zej nape benne' dot yežlyó.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Dios, Bennen' nape' dot yeḻa' wak, zóaḻene' žo'o. Dios na' che Jakob ẕkache' chawe'e žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","¡Le kapa' na'le, ḻe'e, yógo'te benne' ka'! ¡Le wká'n ẕen Dios ḻen yeḻa' žebele! ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Žaḻa' žébežo X̱anžon', Bennen' nape' dot yeḻa' wak. Nake' Benne' Wnná Bia' Ẕen, na' ẕnna bi'e dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Bdie' benne' zi'to' ka' ḻo na'žo. Bnnite'e žo'o nich nna bia'žo yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Beké'e yežlyó nga ḻo ná'gake', na' bennen' chežo, na' naken to yežlyó x̱tanḻe'e che ẕa'só Jakob ka', benne' ka' nži'ile'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ẕben Dios gan ži'e ẕnna bi'e. Ẕbéžegak lozgak bia ka' kate' ẕben X̱anžon' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","¡Le goḻ da' wká'n ẕenle Dios! ¡Le goḻ! ¡Le goḻ da' wká'n ẕenle Bennen' ẕnna bi'e žo'o! ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Dios nake' Benne' Wnná Bia' Ẕen dot ḻo yežlyó nga. ¡Le goḻ chie' ḻen dot yeḻa' žejní'il chele! ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Že' Dios gan ẕnna bi'e, ḻo latje la'y na'. Ẕnna bi'e yógo'te yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Ẕdobgak benne' ka' ẕnna biá'gake' yógo'te yež ka' tẕen ḻen benne' ka' che Dios che Bran. ");
INSERT INTO ztyNTps_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Benne' ka' ẕnna biá'gake' do ẕente yežlyó nga bdégake' yeḻa' wnná bia' chégake' ḻo na' Dios. Ḻe' ẕnna bi'e yógo'te benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Ẕenḻe'e nak X̱anžon', na' žaḻa' wká'n ẕénḻe'ežo Ḻe' ḻo yež che Dios chežo, dan' žen' ḻaw ya'a la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Sión, ya'a ẕen che Dios, naken sibe, na' x̱tanḻe'e. Naken yež che Benne' Wnná Bia' Ẕen, da' žonnen yeḻa' žebele chegak benách dot yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Dios bḻoe'ele' ḻaw ẕkache' chawe'e žo'o. Zoe' ḻo yo'o zaka' ka' che yež chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Bdobgak benne' wnná bia' ka', na' bḻá'gake' nich tíḻ-ḻengake' benne' yežen' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","san kate' bḻé'egeklen', na' bebángekle'. Bžébegake', na' bẕónnjgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Wžé' zédḻe'egekle', na' wẕáka'ḻe'egake' ka žak che to no'le za' gaḻj bi' že'n chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Gókgake' ka barkw ka' žx̱íte'gaken kate' žakḻe'e be' ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Benlžo che da' ben Dios, na' na'a ba bḻe'elžon ḻo yež che X̱anžon', Bennen' nape' dot yeḻa' wak. Ḻe' wzóa chawe'e yež nga to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Ga nak ḻo yodo' chio' Le', Dios, žezá' ḻáže'to' ka nak yeḻa' ži'i ḻaže' ẕen chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Gáte'teze ẕka'n ẕengak benách ka' Le', na' yeḻa' ẕen chio' ẕžinen do ẕente yežlyó. Ka ẕnna bi'o naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Yebéḻe'egekle benne' ka' nníta'gake' yež Sión. Yebégekle benne' ka' nníta'gake' yež ka' che Judá dan' ẕchi'a ḻáže'kzo' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Ḻe'e, benne' ka' che Dios, le chechjle žoa'a yežen'. Le wláb yo'o sibe ka', da' ka' žape chí'igaken yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Le wia nga ka nak ze'e ẕen da' nyechjlen yežen'. Le wia binlo ka zej nak yo'o waḻe ka' chen, nich wzénlele x̱kwide' chele ka' ka zej naken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Dios ni nakkze' Dios chežo to chi'ize. Ḻe' wḻoé'ekzle' žo'o nez chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Le yenle da' ni, ḻe'e, benne' yógo'te yež ka'. Le wzé nag, ḻe'e, benne' dot yežlyó nga, ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","ḻe'e, benne' blo ka', na' ḻe'e, benne' gax̱jw ka', ḻe'e, benne' wnni'a ka', na' ḻe'e, benne' yache' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Wchaḻjkza' da' naken che yeḻa' žejní'il, na' wzejni'ila' ḻe'e da' yo'on yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Bze nag diža' ki che yeḻa' žejní'il. Goḻkza' che to da' ngache', na' chinna' da' žóḻ-ḻena'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","¿Biẕ chen' žon byenen žeba' ḻo ža che da' zede, kate' nyechjlen neda' da' ẕinnj da' žongak benne' ka' bi ẕḻé'egekle' neda' chawe'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Benne' ka' žx̱en ḻáže'gake' da' zej nake', na' ẕka'n ẕen kwíngake' dan' zej nape' yeḻa' wnni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Bi be gak góngake' da' yebéj chawen' ljéžgake' ka', na' bi gak wnéẕjwgake' to da' yeslán ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","nich sóatezegake' nbángake' nich batkle nnitle beḻa' žen chégake' dan' ẕenḻe'e nak da' yeya'wn yeḻa' nban chegak benách, na' batkle gak no benne' chiẕjwen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Ḻé'egekle' žatgak benne' žejní'igekle', na' žak chégake' tḻebe kan žak chegak benne' yaḻ ḻaže' ka', na' chegak benne' ḻaẕdo' zide ka', na' wká'ngake' yeḻa' wnni'a chégake' ḻo na'gak benne' yoble ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Ẕnna ḻáže'gake' sóatezegak ẕa'sógake' ka', na' ga'ngak lížgake' nich gákgaken chegak yógo'te kwe' ẕa'sógake' ka', na' ẕzóagake' la yežlyó chégake' kan légake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","san bi gá'nteze benne' ka' ḻo yeḻa' ba nez. Zej nake' ka bia yix̱e' ka', bia ka' žátgakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Yógo'te da' žóngake' naken dáche'ze, na' wká'ngake' da' bx̱en ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Zej nake' ka to kwe' ẕila' ka' žjakba' ḻo yi' gabíl, gan gape chi'i yeḻa' got ḻégakba', na' benne' chawe' ka' nna biá'gake' benne' wnni'a ka' kate' za' cha'ní', na' kwia yi'gak da' ka' wdápgake', na' yi' gabíl naken gan nníta'tezegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Dios yeya'we' yeḻa' nban chia' ḻo yi' gabíl na' yechi'e neda' gan zoakze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Bi kwe' zedlo' kate' no benne' ẕzí'ḻi'e yeḻa' wnni'a, na' kate' žone' liže' da' záka'ḻe'en. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Kate' gate' bi be yechi'e, na' bi chejḻen yeḻa' wnni'a chien' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Ḻa'kze x̱ak wzóe' nbane' gok chie' yeḻa' ba nez ẕen, na' bka'n ẕengak benne' ka' ḻe' katen' wzóe' nbane', ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","san choe'e gan zej nnita' x̱a x̱ta'we' ka', na' batkle ḻe'ele' yeḻa' baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Žápegak benne' ka' ḻe' ba la'ne san bi žákbe'ele' nake' ka bia yix̱e' ka', bia ka' žátgakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Ẕnne X̱anžo Dios, na' ẕtobe' benne' dot yežlyó, benne' ka' žé'gake' gan ẕla' wbíž, na' gan ženen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Ḻo Ya'a Sión, da' naken x̱tanḻe'e ba bza'ní' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Yeḻá' Dios chežo, na' bi soe' žize. Ẕenkze yi' ḻawe' Ḻe', na' gakḻe'e be' bdone' dan' chechjlen Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Wtobe' benne' ka' nníta'gake' ya'abá na'le, na' benne' ka' nníta'gake' yežlyó nga, nich wchi'a ḻaže'e benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Ẕnne': “Le wtób benne' chia' ka', benne' ka' bénḻengake' neda' to diža', dan' bzoa chóchgake' ḻen žen chegak biado' ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Da' zoan ya'abá ẕḻoe'e ḻawn nak Dios chawe', dan' nake' Benne' wchi'a ḻaže'e benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Ẕnne': “Le yenle, benne' chia' ka', na' wchaḻja'. Le wzé nag, benne' Israel ka', na' nnia' da' yesbaga'a ḻe'e ẕia. Neda', Dios, naka' Dios chele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Bi tiḻa' ḻe'e ni'a chegak biado' ka' betle ḻawa', na' ni'a chegak biado' ka' bzeyle, da' ka' ẕgó'otezele ḻawa' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Bi si'a beždo ka' ḻo na'le ḻe'e, na' chibo byo ka', bia chele ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Yógo'te bia yix̱e' ka' zej nakba' chia', na' yógo'te bia beždo' ka', bia zej zoaba' ḻo ya'ado' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Yógo'te bia ka' zoa x̱ílgakba' yó'ogakba' ḻo na'a, na' ḻezka' yógo'te bia ka' zej zoaba' nbángakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Cha' tona' neda', bi yapa' ḻe'e bi da' gonnle chia' dan' yežlyó, na' yógo'te da' zej den ḻawlen zej naken chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","¿Žon byenen gawa' x̱péḻa'gak bež ka', cha' ye'ja' žen chegak chibo byo ka'?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Le ko'o ḻaw Dios da' wká'n ẕenle Ḻe', na' le wneẕjw da' wchebe ḻáže'le ḻaw Dios ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ḻezka' ẕnne': “Bḻiž neda' ḻo ža katen' gak da' wžía yin' benách ka', na' yeslá' le', na' le' gapo' neda' ba la'ne.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Dios ži'e no benne' wen da' ẕinnj: “¿Žeklo' ẕchaḻjo' le' kan nak da' wnnakza' neda', na' ẕnnio' che x̱tiža'a dan' bénḻena' benách chia' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Le' bi ẕḻe'elo' neda' chawe' kate' ẕḻoe'ela' le' da' bi nak chawe' da' žono', na' ẕzo' cheḻa'ale diža' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Kate' ẕḻe'elo' to benne' wbán, na' žono' ḻe' tẕen, na' nako' toze ḻen benne' ka', benne' ẕbej yíchjgake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Žónteze žono' da' ẕia, na' ẕcháḻjtezo' da' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ẕnnétezo' che lježkzo', na' žesbago'o ẕia x̱kwide' che x̱na'kzo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Beno' da' ki, san neda' wzóa' žize. Goklo' naka' neda' to benne' ka nako' le', san tiḻkza' le', na' wḻoe'ela' le' ka nak da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Le chejní'il da' ni na'a, ḻe'e žaḻ ḻáže'le Dios, nich bi wzóẕj Dios ḻe'e, na' biž soa no benne' yeslé' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Bennen' ko'e ḻawa' da' wká'n ẕene' neda' gape' neda' ba la'ne, na' bennen' ẕzoa choch kwine' nich gone' da' chawe', wḻoe'ela' ḻe' zoa' yeslá' ḻe', na' naka' Dios chie'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Gokḻen neda', Dios, ḻo yeḻa' ži'i ḻaže' chio'. Ḻo yeḻa' žeyache' ḻaže' chio' beká'a ẕia da' nbaga'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Wdíb neda' che da' bi nak chawe' da' bena'. Bka'n chawe' neda' che doḻa' da' nbaga'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Žeyónbi'a bži'a chio' Le' ḻen dan' bena'. Doḻa' ka' bena' žesbága'gaken neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ḻawo' Le' bena' doḻan'. O', ḻawo' Le'. Bena' da' bi naken chawe' ḻawo' Le'. Ki ẕnno' naken chia' nich gak bia' nako' chawe' ni'a che da' ẕnno'. Naken ḻi ḻaže' kan ẕchi'a ḻažo'o benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Bwia nga, bache nbága'kza' doḻa' katen' golja'. Ḻo doḻa' wzoakza' katen' bsan x̱na'a neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Žak ḻažo'o Le' soa da' likze ḻo yichj ḻáẕda'wa', na' ḻo yichj ḻáẕda'wa' bzo' yeḻa' žejní'il. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Bka'n chawe' neda' ḻen da' ẕkonlo' žin, na' yega'na' chawe'. Wdíb neda', na' gakža' chiche ka nak bejw. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Bzoa chia' yeḻa' žebele, na' yeḻa' ba nez, na' žit ka' da' yoa'a gá'ngaken choch, žit ka' bdichjo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Bi chejsá' ḻažo'o doḻa' ka' nbaga'a, na' beká'a yógo'te da' bi nak chawe' da' bena'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Dios, beyón chawe' yichj ḻáẕda'wa', na' bzoa to be' ḻi ḻaže' ḻo yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Bi wkwaso' neda' ḻawo' Le', na' bi yekó'o be' la'y chio' ḻo yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Bebí'i chia' yeḻa' žebele che yeḻa' weslá chio', na' bzoa choch be' chawe' dan' yoa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Naž wsedla' benne' wen da' ẕinnj ka' da' žaz ḻažo'o góngake', na' benne' doḻa' ka' yeyákgake' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Beslá neda' ḻo ẕia da' nbaga'a, beta' to benne'. Dios, nako' Benne' Weslá chia', na' goḻkza' che da' chawe' da' nako' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","X̱ana' Dios, bsaljw žoa'a, na' wzenla' benách ka' da' we ḻawa' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Bi žaz ḻažo'o biado' ka' gota'-ba' ḻawo' Le', na' bi žaz ḻažo'o biado' ka' wzeya' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Da' žaḻa' ko'ožo ḻaw Dios da' žaz ḻaže'e naken to ḻaẕdo' gax̱jw ḻaže'. To ḻaẕdo' gax̱jw ḻaže', na' da' žeyát ḻažen' bi wzó' cheḻa'ale, Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ḻo yeḻa' ži'i ḻaže' chio', ben chawe' yež Sión. Beyón ze'e da' žape chi'in yež Jerusalén'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Naž chaz ḻažo'o biado' ka' gotto' ḻawo' Le' ḻo da' nak chawe', na' biado' ka' wzeyto' ḻawo' Le'. Naž gótgake' biado' ka' ḻo bkog la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","¿Ẕka'n ẕen kwino', benne' waḻe, ni'a che da' ẕinnj da' beno' dan' zóateze yeḻa' žeyache' ḻaže' che Dios? ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ẕcháḻjtezo' che da' ẕia da' gono' che lježo'. Da' ẕnno' naken ka to ya ntoche' dan' žon ḻáže'len lježon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Nží'iželo' da' bi nak chawe' ka nži'ilo' da' naken chawe' na' ẕdan ḻáže'žo' da' wen ḻaže' ka ẕdan ḻažo'o da' li. ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Nži'ilo' diža' ka' žon dítjgeklen benne' ka', le', benne' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Ni'a che da' ki wžía yi' Dios le' to chi'ize. Gox̱e' le', na' yeké'e le' gan zoakzo', na' wkwase' le' gan zej nnita' benne' ban ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ḻé'egekle benne' chawe' ka' da' ni, na' žébegake'. Wẕížegake' chio' le', na' nnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Le wia nga, benne' ni bi bx̱en ḻaže'e Dios nich gape chi'e ḻe'. Bx̱en ḻáže'kze' yeḻa' wnni'a ẕenḻe'e chie', na' nga'nze' ḻo da' bi nak chawe' da' žone'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","San neda' naka' ka to yag olibo dan' žen' ḻi'a liž Dios. Žx̱en ḻáže'teza' yeḻa' žeyache' ḻaže' che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Wká'n ẕenkza' Ḻe' to chi'ize dan' bene' da' ki. Wx̱én ḻaža'a La la'y chie' ḻawgak benne' chie' ka' dan' naken chawe' gonan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Benne' yaḻ ḻaže' ka' ḻo ḻáẕdo'gake' ẕnnágake': “Bi zoa Dios.” Yógo'tie' zej nbage'e ẕia, dan' béngake' da' ẕinnj. Bi zoa no benne' žone' da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Zoa Dios ya'abá, na' ẕwie' benne' ka', nich ḻe'ele' cha' zoa no benne' žejni'ile', bennen' žape' Dios ba la'ne, ");
INSERT INTO ztyNTps_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","san yógo'te benne' ka' zej nbej yíchjgake' Dios. Yógo'tie' zej nbage'e ẕia. Bi zoa no benne' žone' da' naken chawe', nitóe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Ẕnna Dios: “¿Bi žejní'igekle benne' wen da' ẕinnj ka'? Že'j žáwgake' da' ẕbángake' chegak benách chia' ka', na' bi žénegekle' gónbia'gake' neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","San žin ža žébegake' da' sáka'gake'. Gosḻas Dios žit chegak benne' ka' ẕdíḻ-ḻengake' benách chie' ka'. Dios wzóe' ḻégake' cheḻa'ale, na' wžía yi'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Ẕnnabla' Dios gone' ga žoj ḻo yež Sión da' gákḻenen benne' Israel ka'. Kate' gon Dios ga yeḻa'gak benne' chie' ka' lážgake', yebégekle ẕa'só Jakob ka', na' gak yeḻa' ba nez ẕen chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Beslá neda', Dios, ḻen yeḻa' wak chio'. Gokḻen neda', Dios, ḻen yeḻa' waḻe chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Benle da' ẕnnabla' Le', Dios, na' bechebe chia'. Bze nag da' wcháḻjḻena' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Za'gak benne' snia ka' nich tíḻ-ḻengake' neda'. Benne' yichj ža'a ka' žénegekle' gótgake' neda', benne' ka' bi žápegake' Le' ba la'ne, Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","X̱anžo Dios nake' Bennen' žákḻene' neda'. Dios zóaḻene' benne' ka' žape chí'igake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Dios yebi'e chegak benne' ka' bi ẕḻé'egekle' neda' chawe' ka nak da' bi nak chawe' da' žóngake'. Wžía yi'e benne' ka' dan' nake' Ḻe' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Dot ḻaža'a wneẕjwa' da' ko'a ḻawo' Le', X̱ana' Dios. Wká'n ẕenkza' La la'y chio' dan' nakḻe'en chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Besló' neda' ḻo yógo'te da' goken chia'. Bḻe'ela' wžía yi'gak benne' ka' bžá'agake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Bze nag, X̱ana' Dios, da' žḻiža' Le', na' bi wzó' cheḻa'ale da' ẕnnabla' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Bebán ḻaže', na' bechebe chia'. Žḻiža' Le' ḻo da' ẕnnia', na' že' zedla'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Benne' bi ẕḻe'ele' neda' chawe' ẕnnie' chia', na' bennen' bi nake' chawe' žon ditjle' neda'. Žesbága'gake' neda' ẕia, na' ḻo yeḻa' ẕža'a chégake' ẕbia ḻáže'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Že' zedle ḻáẕda'wa' ḻo beḻa' žen chia', na' ẕchebe yeḻa' got neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Ẕžébeḻi'a, na' žẕízeḻi'a, na' žak chia' da' ẕcheben neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Wnnía': “Chela' gonno' chia' x̱il ka' ka zej nak x̱il bsia, tia' ḻo be'ze gan yezí' ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Da' ḻi wẕonnja' zíto'le, na' soakza' ḻe'e latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Gon byena' bi be gon chia' be' bdone', na' be' waḻe.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Bžia yi' benne' ka' bi zej nake' chawe', X̱ana' Dios. Bchix̱ da' ẕnnágake', dan' ẕḻe'ela' da' ẕinnj, na' da' ẕia da' žóngake' ḻo yež nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Dot ža, na' yele žéchjgekle' yež. Žóngake' da' ẕinnj, na' da' bi nak chawe' ḻo yež nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Nža' yež nga da' bi nak chawe' da' žóngake'. Žóntezgake' da' wen ḻaže', na' da' ẕinnj ḻo nez chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Chela' gok no benne' bi ẕḻe'ele' neda' chawe', bennen' bene' neda' ẕia, na' bzoelan'. Chela' gok benne' ẕže'e neda', bennen' bdíḻ-ḻene' neda' na' bkache' kwina' ḻawe' ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","san le' benkzon', na' goko' ka to bi' lježa'. Wẕí' ḻo no'o neda', na' goko' toze ḻen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Tẕen bchaḻjžo dot ḻáže'žo, na' ḻo yeḻa' ži'i ḻaže' wdažo ḻo liž Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Dios, ben ga sen yeḻa' got benne' ka' choḻze, benne' ka' bi zej nake' chawe'. Ben ga chó'ogake' ḻo yi' gabíl kate' ne zóagake' nbángake'. Nža'gak lížgake' da' bi nak chawe' da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","San ka nak chia' neda', bḻiža' Dios, na' X̱ana' Dios beslé' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Zildo', na' wawbíž, na' kate' žen wbíž ẕcháḻjḻena' Dios. Žḻiža' Ḻe', na' Ḻe' ženle' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Yeya'we' be' da' nakkza' ḻo na'gak benne' ka' ẕdíḻ-lengake' neda', na' gone' ga kweza' chawe', ḻa'kze zej nnita' benne' zante, benne' bi ẕḻé'egekle' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Dios nake' Bennen' zóateze', na' ẕnna biá'teze'. Nake' chawe', na' wžía yi'e benne' ka'. Ki gone' chégake' dan' bi žsángake' da' žóngake', na' bi ẕžébegake' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Benne' wen da' ẕinnj ka' ẕdíḻ-ḻengake' benne' ka' ẕgá'nḻengake' ḻégake' chawe'. Ẕží'igake' che diža' da' bénḻengake' benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Da' ẕcháḻjgake' naken diža' cháwe'do', san yo'o yichj ḻáẕdo'gake' yeḻa' ẕža'a. Žóngake' x̱tanḻe'e diža' da' ẕcháḻjgake', san naken ka to ya ntoche'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Bde ywa' chio' x̱kože' X̱anžon' na' Ḻe' gon choche' le'. Batkle we'e latje chejchegw benne' chawen' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","San Le', Dios, gono' ga cho'ogak benne' wen da' ẕinnj ka', na' benne' wet benách ka', na' benne' wen ḻaže' ka', ḻo yi' gabíl, kate' bi na' góngake' gachj yiz ka' da' yéla'gake', san neda' wx̱én ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Beyache' ḻaže'l neda', Dios, nich bi wžía yí'gak benne' ka' neda'. Tža tža žsáka'gake' neda', na' ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Dot ža, na' yele benne' ka' bi ẕḻé'egekle' neda' chawe' ẕbia ḻáže'gake' neda', dan' nníta'gak benne' zante, benne' ẕdíḻ-ḻengake' neda' ḻo yeḻa' ẕka'n ẕen kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Kate' ẕžin ža ẕžeba', žx̱en ḻaža'a Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Žx̱en ḻaža'a Ḻe', na' ẕka'n ẕena' x̱tiže'e. Žx̱en ḻaža'a Ḻe', na' biž ẕžeba'. ¿Biẕkze gak gongak benne' ka' chia' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Yógo'te ža ẕží'igake' che x̱tiža'a. Ḻen yógo'te da' ẕnnágake' žóngake' neda' žia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Ẕdóbgake', na' ẕkache' kwíngake'. Ẕwíagake' binlo da' žona'. Žénegekle' gótgake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","X̱ana' Dios, bwia da' žóngake', na' ḻo yeḻa' ẕža'a chio' bžia yi' benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Nnézkzelo' Le' ka žẕonnja' ḻawgak benne' ka'. Bejsá' ḻaže' nis da' ba wžeža'. ¿Bi zej nyejwn ḻe'e yiche chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Kate' žḻiža' Dios, ḻo ža na'kze žẕonnjgak benne' ka' bi ẕḻé'egekle' neda' chawe'. Nnezkzla' zoaḻen Dios neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Žx̱en ḻaža'a Dios, na' ẕka'n ẕena' x̱tiže'e. Žx̱en ḻaža'a X̱anžon', na' ẕka'n ẕena' x̱tiže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Žx̱en ḻaža'a Dios, na' biž ẕžeba'. ¿Biẕkze gak gongak benne' ka' chia' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Nbaga'a da' bchebe ḻaža'a gona' chio', Dios. Goḻkza' da' we ḻawa' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Besló' be' da' nakkza' ḻo yeḻa' got, na' bekó'o ni'a gan wzóa chejchégwgaken. Gak choa'a ḻawo' Le', Dios, ḻo yeḻa' baní' da' žonno' chegak benne' ka' zóagake' nbángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Beyache' ḻaže'l neda', Dios. Beyache' ḻaže'l neda', dan' žx̱en ḻaža'a Le' ḻen dot yichj ḻáẕda'wa'. Gape chi'o neda' ka žon ẕkoko' žape chi'iba' bríse'do' ka' ẕan x̱ilba', na' zejte te che da' žaken chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Wḻiža' Dios, Benne' ẕente. Wḻiža' Ḻe' nich gákḻene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Gan zoe' ya'abá chie' seḻe'e no benne' yeslé' neda' ḻo na' bennen' žénele' wžía yi'e neda'. Dios beyache' ḻáže'le' neda', na' benne' chia' da' li chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Že' zedla' ka to benne' ži'e ladjw bež yix̱e' ka'. Zoa' ladjw benne' ka' zej nake' ka bež yix̱e' ka', bia ka' žáwgakba' benách ka'. Da' ẕnnégake' chia' naken ka yag ntóche'do' ka', na' x̱tíža'gake' zej naken ka ya ntoche' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","¡Ga'n ẕen Le' ya'abá, Dios! ¡Yeḻa' ẕen chio' ẕžinen dot yežlyó! ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ba bdix̱jgak benne' ka' do yeḻj nich séngake' neda', na' žedó ḻaža'a ḻo da' žaken chia'. Bché'ngake' to yežw nich chejchazan', san ḻégake' ba bejcházgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Zoakze ḻáẕda'wa', Dios. Zoakze ḻáẕda'wa' nich goḻkza' da' wká'n ẕenen Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Bebán, be' da' nakkza', na' le yebán, ḻe'e žinnle da' ka' žóḻ-ḻenle. Zildo' yebankza'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","X̱ana' Dios, wká'n ẕen Le' ladjw benne' chio' ka'. Goḻkza' chio' ḻawgak benne' yógo'te yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Nak yeḻa' žeyache' ḻaže' chio' ẕenže ka ya'abá, na' da' li chio' nakže ẕen ka bejw gasj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","¡Ga'n ẕenkzo' ya'abá, Dios! Yeḻa' ẕen chio' ẕžinen dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","¿Ẕchaḻjle da' nak chawe', ḻe'e, benne' wnná bia' ka'? ¿Ẕchi'a ḻáže'le benne' chia' ka' ka nakkzen? ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","O'o, san žezá' ḻáže'le da' ẕinnj da' gonle. Žonle ga že' zédḻe'egekle benne' ka' ḻo yežlyó chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Zej nchix̱e ḻáẕdo'gak benne' ka' nbej yíchjgake' neda' kate' bi na' gáḻjgake'. Bchíx̱gekle' kate' bi na' wsangak x̱ná'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Da' ẕnnágake' žoten benne' ka' ka žon da' žia ẕan laye' beḻe snia. Zej nake' ka beḻe snia ka', bia kwežw ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Bi žéngeklba' chi'i benne' žone' yeḻa' wžá' nich kwé'gakba' žize ḻa'kze žoḻ-ḻi'e x̱tando'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Dios, wdíchj láye'gak benne' ka'. X̱ana' Dios, wdíchj láye'gak benne' ka' zej nake' ka bež yix̱e' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Ben ga nnítgekle' ka nis da' ẕḻaljen ḻo yo. Ben ga bížgake' kan žak che yix̱e' da' nžogen ḻo nez, ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","na' te chégake' kan žak che bia zag, bian' yeyóna'ba'. Ben ga biž ḻé'egekle' wbíž ka žak che to x̱kwide' žaljbe' ba natbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Néžwte kate' bi na' ḻa to yeso' ḻo yi' ẕen, yeká'a Dios benne' ka' to ḻo be' bdone', benne' ban ka', na' benne' gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Yebele benne' chawe' kate' ḻe'ele' yezí' wzón Dios benne' wen da' ẕinnj ka'. Wleje' žen chegak benne' ka' bebéj yíchjgake' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Naž nna bennen': “Dekze laẕjw benne' chawe'. Dios ẕchi'a ḻáže'kze' benne' yežlyó ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","X̱ana' Dios, beslá neda' ḻo na'gak benne' ka' bi ẕḻé'egekle' neda' chawe'. Beslá neda' ḻo na'gak benne' ka' ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Beslá neda' ḻo na'gak benne' ka' žóngake' da' ẕinnj. Beslá neda' ḻo na'gak benne' wet benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Žénegekle' gótgake' neda'. Zej ndobe benne' waḻe ka' nich tíḻ-ḻengake' neda', kege dan' nbaga'a ẕia, na' kege ni'a che da' ẕinnj da' bena' neda', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Ḻa'kze bi be bena' chegak benne' ka', žon byéngake' góngake' neda' ẕia. Bebán, na' da ga zoa' ni, na' ḻe'elo' da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Le', X̱ana', Dios chegak benne' zan ka' žjake' ḻo wdiḻe, na' Dios chegak benne' Israel ka', bebán nich wsaka' zi'o benne' yógo'te yež ka'. Bi yeyache' ḻáže'lo' yógo'te benne' ka' ẕží'igake' chio' Le', na' žóngake' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ẕḻá'gake' kate' žen wbíž, na ẕbéžeya'agake' ka žongak beko' ka', na' žéchjgekle' yež. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Bwia nga, da' ẕcháḻjgake' naken ka da' žeyébgake'. Diža' ẕnnágake' zej naken ka ya ntoche' ka'. Ẕẕnnágake': “Bi zoa no benne' yenle' chežo.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","San Le', X̱ana' Dios, wẕiẕo' chegak benne' ka'. Gon ditjlo' Le' benne' yógo'te yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Benne' ka' bi ẕḻé'egekle' neda' chawe' zej nake' waḻe. Neda' wx̱én ḻaža'a Le', dan' žape chi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Dios, Bennen' žeyache' ḻáže'le' neda', yide', na' gákḻene' neda'. Dios gone' ga ḻe'ela' da' gak chegak benne' ka' bi ẕḻé'egekle' neda' chawe' kan žak ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Bi goto' benne' ka', nich bi gaḻ ḻáže'gak benne' chia' ka' da' ka' žono'. Besḻás benne' ka' ḻen yeḻa' wak chio', na' ben ga chejchégwgake'. X̱anto' Dios, Le' žape chi'ikzo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Ben ga chíx̱gekle' ḻo yeḻa' ẕka'n ẕen kwíngake', ni'a che doḻa' da' žóngake' ḻo da' ẕcháḻjgake', na' ni'a che diža' x̱iwe' ka', na' da' wen ḻaže' da' ẕnnágake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Bžia yi' ḻégake' ḻo yeḻa' ẕža'a chio'. Bžia yi' ḻégake' nich biž nníta'gake'. Ben ga gákbe'egekle' Le' ẕnna bi'o ẕa'só Jakob ka'. Ẕnna bi'o dot yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Ẕḻá'gake' kate' žen wbíž, na' ẕbéžeya'agake' ka žongak beko' ka', na' žéchjgekle' yež. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Ẕdágake' ka benne' ka' ẕdágakze', žíljgake' da' gáwgake'. Cha' bi žéljgeklen', dot yel žesbága'gake' ẕia toe' yetóe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","san neda' goḻkza' che yeḻa' wak chio', na' zildo' wká'n ẕena' yeḻa' žeyache' ḻaže' chio', dan' gókḻeno' Le' neda', na' wdape chi'o neda' kate' wžé' zédḻe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Le' žon chocho' neda', na' goḻkza' chio', Dios. Žape chi'o neda', na' žeyache' ḻáže'lo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Dios, Le' bzo' neto' cheḻa'ale. Beno' ga bejchégwto', dan' bžá'aḻi'o neto'. Na'a, da gákḻeno' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Beno' ga wẕó' yežlyó, na' beno' ga byaljwn. Da yeyonon' gan byaljwn, dan' ẕbia yin'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Beno' ga neto', benách chio' ka', wžé' zedlto'. Beno' ga gok cheto' ka we'jto' to da' benen ga bejchégwto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Benn chegak benne' ka' ẕžébegake' Le' to da' gak bian', dan' wḻoé'e ḻawn da' nak dot da' li. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Bze nag chia'. Beslá ḻégake' ḻen yeḻa' wak chio', nich lagak benne' ka' nži'ikzlo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Ḻo latje la'y chie' wnná Dios: “Yebekzla' neda'. Chisa' chele yežlyó chegak benne' Sikem ka'. Wžix̱a' chele yežlyó dan' žen' kwit yegw Sukot. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Yežlyó Galaad naken chia', na' ḻezka' yežlyó chegak ẕa'só Manasés ka'. Yežlyó chegak ẕa'só Efraín ka' naken ka to x̱ḻapa' da' žape chi'in yichja'. Yežlyó chegak ẕa'só Judá ka' naken gan ẕnna bi'a, ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","san yežlyó chegak benne' Moab ka' naken ka to ẕiga' ya da' yožen nis wná'a. Ḻo yežlyó chegak benne' Edom ka' cho'na' ẕela' gole ka'. Si'a ba nez yežlyó chegak benne' Filistea ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","¿Noẕkze wchi'e neda' nich tíḻ-ḻena' yež zoa to ze'e sibe dan' žape chi'in yežen'? ¿Noẕkze wchi'e neda' nich tíḻ-ḻena' benne' Edom ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","¿Kege Le' wchi'o neda', Dios? Le' wléj yichjo' neto', na' bi wyéjḻeno' benne' cheto' ka' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Gokḻen neto' nich gak tíḻ-ḻento' benne' ka' ẕdíḻ-ḻengake' neto', dan' gak dáche'ze gákḻengak benne' ka' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","To ẕen ḻen Dios gonžo to da' ẕenḻe'e, na' Ḻe' wlage' benne' ka' ẕdíḻ-ḻengake' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","X̱ana' Dios, benle da' žḻiža' Le'. Bze nag da' ẕcháḻjḻena' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Zi'to' gan zoa laža' žḻiža' Le', dan' žedó ḻaža'a. Bche' neda' gan zoa Bennen' nake' ka to ya'a yej, Bennen' nakže' waḻe ka neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Nako' Le' Benne' nox̱e' neda', na' nako' ka to ze'e yej da' žape chi'in neda' ḻawgak benne' ka' bi ẕḻé'egekle' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Sóateza' ḻo yo'o la'y chio'. Kwe' chawa'a kwito' Le' kan zej že' chawe' bríse'do' ka' ẕan x̱il ẕkoko'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Dan' benlo' Le', Dios, da' wchebe ḻaža'a ḻawo', beno' ga napa' da' žápegak benne' ka' ẕžébegake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Gono' ga soa' nbana', na' ga nna bi'a ža zante. Yiz chia' ka' gákgaken ka da' zej naken chegak chope kwe' benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Sóateza' ḻawo' Le', Dios. Bkwez yeḻa' žeyache' ḻaže' chio', na' da' li nich wká'n cháwe'gaken neda', benne' wnná bia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Goḻkza' che La la'y chio' Le' to chi'ize, na' gonkza' tža tža da' bchebe ḻaža'a gona'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Toze ḻen Dios ẕga'n chawe' be' da' nakkza'. Ḻekze' žeslé' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Toze' Ḻe' žape chi'e neda', na' žeslé' neda'. Nake' Bennen' žox̱e' neda', na' bi chejchegwa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","¿To chi'ize wkwezle da' gonle chia' neda', yógo'tele žon byenle wžía yi'le neda'? Žonle ka žon to benne' ẕchinnje' to ze'e da' zoa bix̱en, o to ḻe'je da' nožon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Žonle toze diža' kan yebejle neda' ḻo yeḻa' ẕen chia'. Nží'ilele da' wen ḻaže'. Ḻen žoá'ale ẕchaḻjle cháwe'do' san yo'o yichj ḻáẕdo'le da' ẕinnj da' gonle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Le', be' da' nakkza', wléz ḻaže' toze Dios. Nake' Ḻe' Bennen' žx̱en ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Toze' Ḻe' žape chi'e neda', na' žeslé' neda'. Nake' Bennen' žox̱e' neda', na' bi yedó ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Nak Dios Bennen' žeslé' neda', na' nake' yeḻa' ba nez chia'. Nak Dios Bennen' žape chi'e neda', na' Benne' žon choche' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Le kwez ḻaže' Ḻe' to chi'ize, ḻe'e, benne' ka'. Bḻoe'el Ḻe' da' ẕdan ḻáže'le. Nak Dios Bennen' žon choche' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Da' ḻi, da' dáche'ze zej nak benne' ka', na' ka to da' wen ḻaže' zej nak benne' ẕen ka'. Bi náḻe'tekgekle' to ḻo ẕgons. Zej nakže' ža'ze ka to be' da' žeká'a ḻáže'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Bi wx̱én ḻáže'le da' gak gonle žakze chele. Bi wká'n ẕen kwinle ni'a che da' ka' ẕbanle. Cha' chan yeḻa' wnni'a chele, bi kwe'le wnné yoe chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","To chi'i wnné Dios, na' chope chi'i benla' da' ni. “Che Dios nak dot yeḻa' wak.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","X̱ana' Dios, ḻo no'o za' yeḻa' žeyache' ḻaže' dan' žebi'o che to to benne' ka nakkze da' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","2","Dios, nako' Dios chia'. Ẕbiḻe be' da' nakkza' da' nak chio'. Beḻa' žen chia' ẕdan ḻaže' dan' naken chio'. Žak chia' ka zoakza' to yežlyó biž gan bi be nis den. Žak ḻaža'a yida' ḻawo' Le' nich ḻe'ela' yeḻa' wak chio', na' yeḻa' ẕen chio', káteze bḻe'ela' da' nak chio' ḻo latje la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Nakže chawe' yeḻa' žeyache' ḻaže' chio' ka yeḻa' nban. Che ḻen wká'n ẕenkza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Wchaḻja' che da' chawe' da' nako' Le' x̱ak zoa' nbana'. Nich wká'n ẕena' La la'y chio' Le' wchiskza' na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Yelje be' da' nakkza' da' naken ka to yeḻa' waw dẕi'. Ḻen yeḻa' žebele wká'n ẕenkza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Žezá' ḻaža'a chio' Le' kate' dia' gan ẕtasa', na' ẕlab ḻaža'a ka nak chio' kate' bi na' tasa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Dan' žákḻeno' neda', yebéḻe'ela' kwito' Le' kan žongak bríse'do' ka' ẕan x̱il ẕkoko'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Be' da' nakkza' naken toze ḻen Le', na' ḻen no'o waḻe nox̱o' neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","san benne' ka' gok ḻáže'gake' wžía yí'gake' neda' chejchó'ogake' ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Kwia yí'gake' ḻo ya ntoche'. Gákgake' da' gawgak beko' chjew ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Neda', benne' wnná bia', yebela' ḻo da' nak che Dios. No benne' ẕkonle' žin La Dios gape' Ḻe' ba la'ne, san benne' wen ḻaže' ka' gá'ngake' žize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","X̱ana' Dios, bze nag chi'a. Že' zedla' žḻiža' Le'. Wdape chi'i yeḻa' nban chia' dan' ẕžeba' da' gongak benne' ka' ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Bkache' chawe' neda' nich benne' ka' bi zej nake' chawe' bi góngake' chia' kan žénegekle', na' nich benne' ka' žóngake' da' ẕinnj bi góngake' chia' kan ẕza' ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Diža' ka' ẕcháḻjgake' zej naken ka ya ntoche' ka', na' ẕnnégake' chegak ljéžgake' ka' ka žon to benne' žsie' yag ntóche'do' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Ki ẕnnágake' bagáche'ze nich góngake' ga chejchégwgak benne' ḻi ḻaže' ka'. Choḻze žóngaken', na' bi be ẕžébegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Žon byéngake' góngake' da' ẕinnj da' žénegekle', na' ẕbékgake' do yeḻj ka' nich séngake' benne' ka'. Ẕnnágake': “¿Noẕ benne' ḻe'ele' da' žonžo?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Žíljgake' da' ẕinnj da' góngake', na' ẕwíagaken' binlo. Da' yo'o yichj ḻáẕdo'gake' naken da' kegle kan zej nak ḻáẕdo'gakkze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","San Dios gon zi'e benne' ka' ḻen yag ntóche'do' chie' ka'. Choḻze chó'ogake' yižwé' ẕen ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Da' bchaḻjgak benne' ka' gonen ga chejchégwgake'. Chébegak yógo'te benách kate' ḻé'egekle' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Naž chébegake', na' wcháḻjgake' che da' ben Dios, na' yeyónbia'gake' naken da' bene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Yebele benne' chawe' ḻaw X̱anžon', na' wx̱én ḻaže'e Ḻe'. Gak yeḻa' ba nez ẕen chegak benne' ka' zej nake' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","X̱ana' Dios, žaḻa' wx̱én ḻáže'to' Le' ḻo yež Sión, na' gonto' da' wchebe ḻáže'to' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Le' ženkzlo' da' ẕcháḻjḻento' Le', na' ḻa'gak yógo'te benne' ka' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Nbága'ḻi'a da' ẕinnj da' bena', san ženít ḻawo' Le' da' bži'ito' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Ba nez ẕen naken che bennen' ẕbio' Le', na' ẕnno' nake' chio', nich soakze' latje la'y chio'. Yeljkzto' da' chawe' da' de ližo', dan' den ḻo yodo' la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Ḻo da' chawe' da' nako' gono' da' ẕenḻe'e kate' gono' da' ẕnnablto' Le', Dios, Benne' Weslá cheto'. Yógo'te benne' nníta'gake' yežlyó žx̱en ḻáže'gake' Le'. Ḻezka' žx̱en ḻáže'gak benne' ka' Le', benne' ka' ẕdégake' zíto'le ḻaw nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Le' ẕzoa chocho' ya'a ẕen ka' ḻen yeḻa' wak chio'. Nakkzo' Benne' waḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ẕbek žio' nisdo' kate' ẕgo'nen, na' žaẕto' da' žonen. Ẕbek žio' benne' yež ka' kate' žóngake' žo'osbé. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Che ḻen benne' ka' nníta'gake' dot yežlyó ẕžébegake' da' ẕenḻe'e da' žono'. Ẕnnito'o benne' ka' ḻo yeḻa' ba nez, benne' ka' nníta'gake' do ẕente yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ẕwio' yežlyó, na' žseḻo'o nis yejw. Žono' ga žonnḻe'en linne chen. Bnnito'o yegw ka' ḻo yežlyó da' zej nža'ḻe'en nis. Ẕkwezo' ẕoa' za da' gawgak benne' ka', kan wnnakzo' gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Žseḻo'o nis yejw gan de na, na' žeyonon' yo ya'a. Žesbison' ḻen nis yejw na', na' žono' ga ẕgól-ḻe'egak da' zej nazen ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Žono' ga gak chegak benne' ka' yeḻa' ba nez to yiz to yiz ni'a che da' ẕneẕjo', na' bejw gasj chio' ka' žónngaken yejw da' žonen ga ẕgolgak da' zej nazen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Žon yejw chio' ga žak ya'a gan ẕdagak bia yíx̱e' ka' na' žebégekle benne' ka' ẕḻé'egekle' žeyák ya'ado' ka' ya'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Ḻo lache' ka' zej nnita' ẕila' ka', na' žoa'agak yégodo' ka' naz ẕoa' stribe. Ẕbéžya'agak benne' chio' ka' ḻo yeḻa' žebele, na' žóḻgakkze' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","¡Le wká'n ẕen Dios ḻo yeḻa' žebele, ḻe'e zoale dot yežlyó! ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","¡Le goḻ ka nak yeḻa' ẕen chie' Ḻe'! ¡Le wká'n ẕene' kate' we ḻawle Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Le ye' Dios: “¡Žebáneḻe'elto' che da' beno' ḻe'!” Ni'a che yeḻa' ẕen che yeḻa' wak chio' benne' ka' bi ẕḻé'egekle' Le' chawe' žóngake' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Benne' ka' nníta'gake' dot yežlyó we ḻáwgake' Le', na' góḻgake' chio' Le', na' che La la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Le da, ḻé'elele da' ẕen ka' da' ben Dios, da' ẕenḻe'e da' bene' ni'a chegak benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Bene' ga beyák nisdo' yo biž, na' wdegak benne' chie' ka' ḻen ní'agakze' gan wzóa to yegw zil. Žoa'a nisdon' bebéḻe'egekle' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Ḻen yeḻa' wak chie' nna bi'e to chi'ize. Ẕwíakze' da' žongak benne' ka' yógo'te yež ka'. Benne' ka' ẕží'igake' chie' Ḻe' bi gata' yeḻa' ẕen chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Ḻe'e, benne' ka', le wká'n ẕen Dios chežo. Le wzenle benne' ka' da' žoe ḻawle Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Ḻekze' žape chi'e žo'o nich soažo nbanžo, na' bi bi'e latje chejchégwžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Le', Dios, bwio' neto' ḻo da' ka' bento'. Bdio' neto' ḻo da' wẕáka'to' kan žongak benne' ka' ẕdégake' ya plat ḻo yi' nich ga'nen chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Beno' ga bejchazto' to ḻo do yeḻj. Bdo'o x̱kóže'to' to ywa' zí'iḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Beno' ga wdegak benne' zej žie' bžina' chie' ka' ḻo yichjto'. Wdeto' da' naken ka to ḻo yi', na' to ḻo nis zil, na' bebejo' neto', na' bzo' neto' to latje gan zoato' ḻo yeḻa' ba nez. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Cho'okza' ližo' nich wzeya' biado' ka' ḻawo' Le'. Gonna' chio' da' wchebe ḻaža'a gona'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Bchebe ḻaža'a gonan', dan' wnnía' katen' wžé' zédḻe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Wzeya' biado' ka', bia ženne' ka', ḻawo' Le', na' kwen žen chegak ẕíla'do' ka' wzeya'-ba' gan zo', na' gota' beždo' ka', na' chibo byo ka' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Le da, yénlele, yógo'tele ḻe'e ẕžébele Dios. Wzenla' ḻe'e da' bene', gókḻene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Dot ḻaža'a bḻiža' Ḻe', na' bka'n ẕenkza' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Chela' wzé ḻaža'a to da' ẕinnj bi benle X̱anžon' chia', ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","san da' likze benle Dios chi'a, na' bze nage' da' wnnabla' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Bi bzoe' cheḻa'ale da' bcháḻjḻena' Ḻe', san beyache' ḻáže'le' neda'. ¡Ga'n ẕen Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Dios, beyache' ḻaže'l neto', na' ben chawe' neto'. Ḻo yeḻa' ži'i ḻaže' chio' wzoaḻen neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Naž gónbia'gak benách dot yežlyó da' žaz ḻažo'o Le', na' nnézgekle benne' yógo'te yež žesló' benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Yógo'te benne' ka' we ḻáwgake' Le', Dios. Yógo'tegake' wká'n ẕéngake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Le yebele, na' le soa ḻo yeḻa' ba nez, ḻe'e, benne' yógo'te yež ka'. Wchi'a ḻaže' Dios ḻe'e ḻo da' naken chawe'. Gape chi'ikze' yógo'te benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Yógo'te benne' ka' we ḻáwgake' Le', Dios. Yógo'tegake' wká'n ẕéngake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Yežlyó nga žen' x̱ni'a chen. Dan' ben chawe' Dios žo'o, nake' Dios chežo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Dios ben cháwe'kze' žo'o. Gáte'teze žaḻa' gápegak benne' ka' Ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Wzó ža', Dios. Besḻás benne' ka' bi ẕḻé'egekle' Le' chawe', na' wẕonnjgak benne' ka' ẕží'igake' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Ka žon to be', ẕlagen žen che yi', ka' wlago' Le' benne' ka'. Kan želane china' bez ḻo yi', nítgekle benne' ka' bi zej nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Yebégekle benne' chawe' ka', na' sóagake' ḻo yeḻa' ba nez ḻawe' Ḻe'. X̱íte'gake' ḻo yeḻa' žebele chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","¡Le goḻ che Dios! ¡Le goḻ salmo ka' che La la'y chie'! ¡Le wká'n ẕen Bennen' ži'e ya'abá! Nzi' ḻe' Jah. ¡Le yebele ḻawe' Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Žape chi'e bi' wzébedo' ka', na' ẕwíakze' no'le wzebe ka'. Zoakze Dios ḻo latje la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Dios ẕnnite'e lježe benne' ka' bi zoa no ljéžgake'. Žebeje' benne' ka' zej yoe'e ḻo na'gak benne' zi'to' ka', nich sóagake' ḻo yeḻa' ba nez, san benne' ka' ẕží'igake' che Dios chejnníta'gake' to ḻo yežlyó biž. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Dios, kate' wnežo' ḻawgak benne' chio' ka', na' wdío' ḻo yežlyó bižen', ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","na' wẕó' yežlyón', na' gokḻe'e yejw ḻaw Dios. Ya'a Sinaí wẕizen ḻaw Dios chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Bseḻo'o to nis yejw wáḻeḻe'e, Dios. Kate' bedó ḻáže'gak benne' chio' ka', na' Le' ben chocho' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Benne' ka' zej nake' chio' chejnníta'gake' yežlyó chio' to chi'ize. Ḻo da' nak chawe', Dios, žox̱o' benne' yache' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","X̱anžo Dios bseḻe'e to diža' chawe', na' bseḻe'e benne' zante, benne' bzéngekle' benách ka' diža' chawen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","¡Bẕónnjgake'! Bẕonnjgak benne' wnná bia' ka' ḻen benne' chégake' ka', benne' žjake' ḻo wdiḻe. No'le ka' bené'egekle' da' gota' chegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Ḻa'kze bkache' kwinle gan žape chi'ile ẕila' ka', gákwle da' naken ka x̱il plomdo' ka' da' zej naken x̱tan, na' ya plat, na' doba' ka' chegak x̱ilba' ka' zej naken ya oro. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Kate' Dios, Benne' ẕente, besḻase' benne' wnná bia' ka' ga na', na' bex̱jw bege' da' bgakwn Ya'a Salmón. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","To ya'a ẕen nak Ya'a Basán. To ya'a ẕenḻe'e nak Ya'a Basán na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","¿Biẕ chen' ẕwíale, ḻe'e, ya'a ẕen ka'? Ẕwíale ya'a na' gan žénele Dios soakze'. Da' likze soakze X̱anžon' ḻaw ya'a na' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Karro ka' che wdiḻe da' nape Dios zej nyanḻe'en. X̱anžo Dios zezé'e gan že' Ya'a Sinaí nich soe' latje la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Beyepo' ya'abá, bechi'o benne' ka' bebejo' ḻo na' yeḻa' got. Wẕi'o da' chawe' ka' da' bnéẕjwgak benne' ka' chio' Le'. Ḻezka' benne' ka' bží'igake' chio' Le', gota' da' bénngake' chio' Le', Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","¡Ga'n ẕen X̱anžon'! Tža tža žónnḻi'e da' chawe' chie' chežo. Nake' Dios, na' žeslé' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Dios, Bennen' nake' Dios chežo, beslé' žo'o. X̱anžo Dios na'kze beslé' žo'o ḻo na' yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Da' likze Dios gone' we' yichjgak benne' ka' ẕží'igake' chie' Ḻe'. Gone' we' yichjgak benne' ka' žónteze žóngake' doḻa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Wnná X̱anžon': “Gona' ga yežinle lažle, yeza'le ḻaw Ya'a Basán. Gona' ga yeza'le že'l ḻo nisdo', na' yežinle lažle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Wlejle žen chegak benne' ka' ẕdíḻ-ḻengake' ḻe'e, na' beko' chele ka' ḻé'jgakban'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Za'gak benne' chio' ka', na' žoe ḻáwgake' Le', Dios. Ḻo yeḻa' žebele chégake' žó'ogake' latje la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Zejnéžwgak ḻawle benne' ka' žóḻgake'. Benne' ka' ẕkwéẕgake' da' ẕgóḻgake' zjake' ẕántele. Gachj ḻawle zjak x̱kwide' nó'ledo' ka' zej nóx̱o'be' da' ka' ẕgóḻgakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","¡Le wká'n ẕen Dios gan zej ndobe benách chie'! ¡Le wká'n ẕen X̱anžon', ḻe'e nakle ẕa'só Israel! ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Ḻezka' zjak ẕa'só Benjamín ka'. Zej nake' bábzegake' san ẕnna biá'gake'. Ḻezka' zjak benne' zan ẕa'só Judá, na' benne' zan ẕa'só Sabulón, na' benne' zan ẕa'só Neftalí. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Dios, bḻoe'e ḻaw yeḻa' waḻe chio'. Ben choch, Dios, dan' beno' ni'a cheto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Dan' nak ẕen yodo' chio' da' zoan ḻo yež Jerusalén, benne' blo ka' kó'ogake' da' zej nape' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Bdiḻ-ḻen benne' ka' chegak yež zi'to' ka', benne' ka' ẕdíḻ-ḻengake' benne' chio' ka'. Zej nake' ka bež zan ka', ḻen ẕí'ngakba' ka', dan' ẕdíḻ-ḻengake' yež zan ka' nich kwéjgake' yeḻa' wnni'a chégake'. Besḻás benne' ka' žaz ḻáže'gake' chjake' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Ḻa'gak benne' wnná bia' ka' che yežlyó Egipto. Benne' ka' che yežlyó Etiopía gon byéngake' wká'n ẕéngake' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","¡Le goḻ che Dios, ḻe'e zoale dot yežlyó! ¡Le goḻ che X̱anžon'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","¡Le goḻ che Bennen' ži'e ya'abá na'le, dan' wzóan zga'ale! Le wia nga, nnie' kan ẕnne wzió'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Le wia nga, nape Dios dot yeḻa' wak. Ḻo yeḻa' ẕen chie' ẕwíakze' benne' Israel ka', na' ẕan ya'abá nla' ḻaw yeḻa' waḻe chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Ẕžébeto' Le', Dios, gan zo' latje la'y chio'. Dios chegak benne' Israel ka', žon chochkzo' benne' chio' ka'. ¡Ga'n ẕen Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Dios chia', beslá neda'. Naka' ka to benne' žiepe' nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Naka' ka to benne' yoe'e ḻo gona', na' bi žak se'e. Naken ka yoa'a ḻo nis zil-ḻe'e, na' nisen' za' wkachen' yichja'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Žejx̱áke'la' dan' scha wnnéḻi'a, na' da' lba'a. Žatgak yej ḻawa' x̱ak ẕbeza' nich gakḻen Dios neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Zej nyanže benne' ka' bi ẕḻé'egekle' neda' chawe' ka zej nyan yicha' yichja', na' bi be ẕia nbaga'a. Benne' ka' ẕžá'agake' neda' zej nákḻi'e waḻe. Benne' ka' žóngake' neda' ẕia, na' bi zoa biẕ chen'. Žon byéngake' yeyiẕjwa' da' bi wlana'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Dios, nnézkzelo' Le' bena' da' yaḻze, na' ẕḻe'ekzlo' doḻa' da' bena'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","X̱ana' Dios ẕente, bi go'o latje benne' ka' žx̱en ḻáže'gake' Le' yedoé'egekle' ni'a che da' bena'. Bi go'o latje benne' ka' zá'gake' chio' chíx̱gekle' ni'a chia' neda', Dios chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Dan' nži'ila' Le' ẕchíx̱gake' neda', na' ḻo yeḻa' sto' zoakza'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Naka' ka to benne' zi'to' ḻawgak benne' ljéža'do' ka', na' bi zej nónbi'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Žeye ẕla ḻáẕda'wa' dan' žé'ḻi'a wnné yoe che ližo'. Da' ẕnnégak benne' ka' chio' Le', Dios, naken ka ẕnnégaken' chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Wžeža', na' bena' wbás, na' ben dítjgekle' neda', na' che ḻen ẕchix̱la'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ḻezka' bwakw kwina' ḻaže' zeche'. Bḻé'egekle' neda' ka to da' ben dítjgekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Benne' yolawe' ka' wnnégake' chia'. Benne' we'j ka' ben dítjgekle' neda' ḻo da' béḻgake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","san neda' bḻiža' Le', X̱ana' Dios, kan žaz ḻažo'o Le'. Dios, ḻo yeḻa' žeyache' ḻaže' ẕen chio', na' dan' nakkzo' Benne' weslá cheto', benle chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Bebéj neda' ḻo da' zede gan zoa'. Naken ka yoa'a ḻo gona' gže'. Bi go'o latje chazžan'. Beslá neda' ḻo na'gak benne' ka' bi ẕḻé'egekle' neda' chawe'. Naken ka yoa'a ḻo nis zil. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Bi go'o latje gata' neda' ka to benne' ẕgache'e ḻo nis zil na', nich bi gaka' ka to benne' chejchaze' to ḻo yežw gže', gan choa'a, na' wkachen' neda' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Bechebe chia', X̱ana' Dios, dan' cháwe'ḻe'e nak yeḻa' žeyache' ḻaže' chio'. Da, gokḻen neda', dan' ẕente nak yeḻa' žeyache' ḻaže' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Bwia kan nak da' žaken chia' neda', wen žin chio'. Dan' že' zédḻe'ela', ben byene yenlo' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Da ka' gaze ga zoa' ni, na' beslá neda'. Beslá neda' dan' zej nyanḻe'e benne' ka' bi ẕḻé'egekle' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Le' nnézkzelo' kan ẕchíx̱gake' neda', na' kan že' zédḻe'ela', na' kan žon dítjgekle' neda'. Ẕḻe'ekzlo' yógo'te benne' ka' ẕžá'agake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Dan' ẕká'ngake' neda' ka'ze žedó ḻaža'a, na' že' zédḻe'ela'. Wleza' no benne' yeyache' ḻáže'le' neda', san bi wzóa no benne'. Wleza' no benne' gon choche' neda', san bi wzóa no benne'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Bwáwgake' neda' da' sḻa', na' kate' wbiḻa', byé'jgake' neda' da' zichj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Ben ga gak lni ka' chegak benne' ka' ka to do yeḻj gan chéjgake', na' ben ga yeyák yeḻa' ba nez chégake' to gan chejchégwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ben ga choḻgak yej ḻáwgake' nich biž ḻé'egekle', na' ben ga ẕízetezegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Ḻo yeḻa' ẕža'a chio' bžia yi' benne' ka'. Ḻo yeḻa' yichj ža'a chio' ben ḻégake' zi'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Ben ga bi soa no benne' ḻo ližgak benne' ka', na' bi soa no benne' ḻo yežlyó chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Wžía ḻáže'gake' bennen' bsaka' zi'o, na' žẕížegake' dan' ẕzaka' bennen' beno' ḻe' we'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Bḻoe'e ḻaw doḻa' da' zej nbaga' benne' ka', na' bi go'o ḻégake' latje gákgake' toze ḻen benne' chawe' chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Bsoḻe lagak benne' ka' ḻe'e yiche chegak benne' ka' zej nape' yeḻa' nban da' naken li ḻaže', na' bi wzojo' lágake' gan zej nyejw lagak benne' chawe' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","san neda' zoa' ḻo da' ẕzáka'ḻi'a, na' že' zédḻe'ela'. Beslá neda', Dios, na' bechís neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Goḻkza' da' wká'n ẕenen La la'y che Dios chia'. Wká'n ẕena' Ḻe' ḻen da' žoe ḻawa' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Da' ni žaz ḻáže'že Dios ka to bež gota' ḻawe', o ka to biado' zej žia lozba', na' sógo'ba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Ḻé'ekzegekle benne' gax̱jw ḻaže' ka' da' ni, na' yebégekle'. Le biga' ḻaw Dios, na' Ḻe' gon choche' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Ženle X̱anžon' chegak benne' ka' žiážjegekle', na' bi ẕzoe' cheḻa'ale benne' chie' ka', benne' zej nyejwe' liž ya. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","¡Le wká'n ẕene' Ḻe', ḻe'e zoale ya'abá, na' ḻe'e zoale yežlyó nga, na' ḻe'e zoale ḻawe' nisdo', na' yógo'te da' nníta'gaken yógo'te latje ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Dios beslé' benne' ka' nníta'gake' yež Sión, na' yeyone' yež ka' zej žen' ḻo yežlyó Judá, na' chejnníta'gake' ga na', na' gata' chégake' yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Ḻezka' žingak ẕa'só benne' chawe' chio' ka', na' gata' chégake' yežlyón', na' benne' ka' nží'igekle' La la'y chio' chejnníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Beslá neda', Dios. Da ka' gaze nich gákḻeno' neda', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Ben ga yedoé'egekle, na' kwe' zédgekle benne' ka' žénegekle' gótgake' neda'. Ben ga yebíga'gak, na' chíx̱gekle benne' ka' žebégekle' dan' že' zedla'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ben ga ga'ngak yaḻ ḻaže' ḻo da' žongak benne' ka' žon dítjgekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Benne' ka' žíngake' ḻawo' Le' yebégekle', na' sóagake' ḻo yeḻa' ba nez. Benne' ka' žé'gake' Le' “Žóx̱keno'” dan' besló' ḻégake'. Ẕnnágake': “¡Ga'n ẕen Dios!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Ze' zedla', na' nat ni'a na'a. Da ka' gaze gákḻeno' neda', Dios. Le' nako' Benne' weslá chia', X̱ana'. Bi želo', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Za'a ḻawo' Le', X̱ana' Dios, nich gape chi'o neda'. Ben ga biž yedoe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Gokḻen neda', na' beslá neda' dan' nako' chawe'. Bze nag chi'a, na' beslá neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Nako' ka to yej x̱e gan soa' chawe', na' wak yida' gan zo' Le' dot ža, na' yele. Bseḻa' no benne' yeslé' neda', dan' nako' Le' ka to yej x̱e gan zoa' choch. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","X̱ana' Dios, beslá neda' ḻo na'gak benne' ka' bebéj yíchjgake' Le', na' ḻo na'gak benne' ka' žóngake' da' ẕinnj, na' zej nake' yichj ža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Žx̱en ḻaža'a Le', X̱ana' Dios. Le' ẕwíakzo' neda' kate' ne naktia' bí'do'te. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Le' ba nox̱kzo' neda' katen' za' golja'. Le' beno' ga bžoja' ḻo ḻe'e x̱na'a. Wká'n ẕénteza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Bebángekle benne' zanḻe'e kan gok chia', san Le' ẕwíakzo' binlo neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Ben ga góḻteza' da' we ḻawa' Le', na' wká'n ẕena' Le' dot ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Bi wzó' neda' cheḻa'ale kate' ba ngola'. Kate' yedó ḻaža'a, bi kwej yichjo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Benne' ka' ẕžá'agake' neda' ẕnnégake' chia', na' benne' ka' žak ḻáže'gake' gótgake' neda' ba béngake' toze diža'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Ẕnnágake': “Bzoa Dios ḻe' cheḻa'ale. Le cho'o chejx̱enžo-ne' dan' bi zoa no benne' yeslé' ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Dios, bi so' zi'to' ga zoa' ni. Dios chia', da ka' gaze gákḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Ben ga yedoé'egekle, na' nítgekle benne' ka' ẕdíḻ-ḻengake' neda'. Ben ga soagak ḻo yeḻa' sto', na' chíx̱gekle benne' ka' žak ḻáže'gake' góngake' chia' da' ẕinnj, ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","san neda' wx̱én ḻáže'teza' Le', na' we ḻáwteza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Wzenla' benne' ka' nako' chawe', na' wzéntezela' ḻégake' kan besló' neda', ḻa'kze bi nnezla' baḻ chi'i besló' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Wchaḻjkza' che da' ẕenḻe'e da' beno' Le', X̱ana' Dios, na' wsá'a ḻáže'gak benne' ka' kan nakkzo' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Dios, Le' bsedlo' neda' kate' ne naktia' bí'do'te. Ẕḻoe'ela' benne' ka' ka nak da' ẕenḻe'e da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Bi kwej yichjo' neda' kate' ba ngola', na' ba bgocha', san be' neda' latje wzenla' ẕa'sóa' ka' ka nak yeḻa' wak chio', na' wzenla' bi'do' ka' bi na' gáljgakbe' ka nak chio', ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","na' da' chawe' da' nako', da' naken ẕenḻe'e, Dios. Le' beno' da' ka' zej nakḻe'en ẕen. Dios, ¿noẕkze benne' nake' ka nako' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Le' beno' ga wdía' ḻo da' zan da' zede, na' ḻo da' ka' bi žakgak chawe', na' gono' ga yebana' neda', na' yechiso' neda' ḻo yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Gono' ga gakža' ẕen, na' yeyón ẕeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Neda' we ḻawkza' Le', na' chinna' da' žóḻ-ḻento'. X̱ana' Dios, goḻkza' che da' likze chio' na' chinna' da' ka'. Nako' Benne' La'y chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Soa' ḻo yeḻa' ba nez kate' goḻkza' chio' Le', na' yebekzle be' da' nakkza' dan' beya'wo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Wcháḻjteza' che da' chawe' da' nako' dot ža, na' yele, dan' beno' ga bedoé'egekle, na' bchíx̱gekle benne' ka' ben byéngake' góngake' neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Dios, ben ga wchi'a ḻaže' benne' wnná bia' da' žak cheto' kan ẕchi'a ḻáže'kzo' Le', na' ben chawe' x̱kwide' ka' che benne' wnná bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Naž ḻe' wchi'a ḻaže'e cháwe'do' benne' chio' ka'. Ka nak da' naken dot da' li wchi'a ḻaže'e benne' chio' ka' ẕzáka'ḻe'egake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Ḻaw ya'a ka' chejga'ngak chawe' benne' chio' ka', na' ḻaw ya'ado' ka' kwézgake' ḻo da' nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Wchi'a ḻaže'e benne' wláž ka' ẕzáka'ḻe'egake'. Yeslé' x̱kwide' ka' chegak benne' ka' žiážjegekle'. Wžía yi'e benne' ka' žsáka'gake' benách chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Chébeteze benne' wnná bian' Le', x̱ak zoa wbíž, na' byo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Gak benne' wnná bian' ka nis yejw da' žaken ga naz, na' ka ẕlelj da' žeẕjwn ḻo yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Ḻo ža ka' che benne' wnná bian' gak da' chawe', na' ga'ngak cháwe'do' benne' ka' x̱ak zoa byo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Nna bi'e dot yežlyó nga, žoa'a Yegw Éufrates, na' do ẕente yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Wzóa ẕibgak benne' dot yežlyó ḻawe' ḻe', na' wzex̱jwe' ḻáže'gak benne' ka' ẕžá'agake' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Benne' ẕnna bi'e yež Tarsis, na' benne' ẕnna bi'e yež zi'to' ka' zedjnoé'e da' wnéẕjwgake' chie', na' benne' ẕnna bi'e yež Sabá, na' benne' ẕnna bi'e yežlyó Seba wnéẕjwgake' chie' yeḻa' wnni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Yógo'te benne' wnná bia' ka' wzóa ẕíbgake' ḻawe' ḻe, na' benne' yógo'te yež góngake' žin chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Ḻe' yeslé' benne' ka' žiážjegekle', benne' ka' žḻížgake' ḻe', na' yeslé' benne' ka' ẕzáka'gake', na' bi zoa no benne' gákḻene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Yeyache' ḻáže'le' benne' yache' ka', na' benne' ka' žiážjegekle'. Yeslé' benne' yache' ka' nich sóagake' nbángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Yeya'we' benne' yache' ka' ḻo na'gak benne' wen ḻaže' ka', benne' yichj ža'a ka', na' gon byene' yeslé' benne' ka' ḻo na'gak benne' wet benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Soa nban benne' wnná bian', na' wnéẕjwgake' chie' ya oro che yež Sabá, na' nnábtezgekle benne' ka' gakḻen Dios ḻe', na' dot ža, na' yele nnábgekle' Dios gon chawe'e benne' wnná bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Gázgake' to ẕíga'do'ze ẕoa' stribe ḻo yežlyó, na' ḻaw ya'ado' chégake' ka', na' kwíaḻe'e linne chen kan ẕbian ḻaw Ya'a Líbano, na' benne' ka' nníta'gake' ḻo yež ka' yángake' kan žon yix̱e' da' žen' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Sóateze la benne' wnná bian'. Wcháḻjtezgake' che le' x̱ak zoa wbíž. Ni'a chie' ḻe' gak yeḻa' ba nez chegak benách ka', na' nnágake' nak chie' yeḻa' ba nez ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Cháwe'ḻe'e nak X̱anžo Dios. Nake' Dios chegak benne' Israel ka', na' toze' Ḻe' žone' da' ka' žóngaken ga žebánležo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Cháwe'ḻe'e nak La la'y chie' dan' náktezen ẕen, na' dot yežlyó nga ḻé'egekle' yeḻa' ẕen chie'. Ka'kze naken, na' ka'kze gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Ga ni ze ḻaw da' wnná Dabí, ẕi'n Isaí, dan' bcháḻjḻene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Da' likze Dios ben chawe'e benne' Israel ka', benne' ka' zej nake' dot ḻi ḻaže' ḻawe' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","san neda' wzóa' chejchegwa', na' wzóa' gona' to da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Bge'ela' benne' wnni'a ka', kate' bḻe'ela' kan žak chawe' chegak benne' ka' nbej yíchjgake' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Benne' ki bi zej že' zedle che yeḻa' got, dan' zej zóaḻi'e chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Bi ẕzáka'gake' kan ẕzáka'gak yezika' benne' ka', na' bi zoa da žak chégake' kan žak chegak yezíka'že'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Che ḻen ẕka'n ẕen kwíngake'. Žónteze žóngake' da' bi nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Ẕgól-ḻe'egake' dan' žáwḻe'egake' da' cháwe'ḻe'e. Ẕzí'ḻe'egake' da' ẕdan ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Žon dítjgekle' Dios, na' ẕnnégake' chie', na' žóngake' da' ẕinnj. Ḻo yeḻa' ẕka'n ẕen kwíngake' ẕcháḻjgake' da' ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Ẕnnégake' che da' ka' zej zoan ya'abá, na' ẕcháḻjgake' ka benne' ka' zej nape' dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Che ḻen yezika' benách ka' želyenle' x̱tíža'gake', na' ẕzi' ḻo ná'gake' da' ẕnnágake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Ẕnnagak benne' wnni'a ka': “¿Biẕkze nnezle Dios? ¿Ẕḻé'ekzle Bennen' zoe' ža'le da' žonžo?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Benne' ki zej nbej yíchjgake' Dios, na' zej zoe' binlo, na' ẕzí'gakže' yeḻa' wnni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Da' likze, dáche'ze goka' dot ḻi ḻaže', na' bi be bena' da' bi nak chawe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","san tža tža wẕáka'ḻi'a, na' žsaka' zí'gake' neda' yógo'te ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Chela' nnia' neda': wchaḻja' kan ẕchaḻjgak benne' ka', na' wka'na' bénne'do' chio' ka' ka'ze, Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Kate' blab ḻaža'a nich chejni'ila' da' ni, wžé' zédḻe'ela', ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","san kate' wyoá'a ḻo latje la'y che Dios, na' gókbe'ela' da' gak chegak benne' ka' ga ze ḻawte. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Da' likze beno' chegak benne' ka' chejchégwgake', na' gono' ga kwia yí'gakkze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Ḻa' kwia yí'tegake'. Yeḻa' ẕžebe senen ḻégake', na' goten ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Zej nake' ka to da' bḻe'elto' to ḻo bichgale dan' ẕnniten kate' žebanžo. Ka'kze gaken, X̱anto' Dios. Kate' so žo'o, wka'no' ka'ze da' bḻoe'el kwingak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Kate' bge'ela' benne' ka', wžé' zédḻe'ele ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Goka' ka to bia yix̱e' ḻawo' Le', dan' gok zide yichja', na' bi bejni'ila', ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","san wzóaḻenteza' Le', na' nóx̱wkzo' na'a ḻi ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Bsedlo' neda' nich gona' da' ẕḻoe'elo' neda', na' te na'a yezí' ḻo no'o neda' ḻo ya'abá chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Bi zoa no benne' yoble chia' ya'abá san tozo' Le', na' bi be zoa da' ẕdan ḻaža'a yežlyó nga san tozo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Žedó ḻaže' beḻa' žen chia', na' ḻáẕda'wa', san Dios nake' Benne' žon choche' neda', na' nake' yeḻa' ba nez ẕen chia' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Benne' ka' žekwásgake' gan zo' nítgekle'. Wžía yi'o yógo'te benne' ka' kwej yíchjgake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","San neda', žak chawe' chia' dan' wbiga' ḻaw Dios. Wx̱én ḻáže'teza' X̱anžo Dios, na' wchaḻjkza' che da' ẕente da' bene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","X̱anto' Dios, ¿wléj yichjo' neto' to chi'ize? ¿Ẕžo'o neto', ẕila' chio' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Bsa' ḻaže' benne' chio' ka', benne' ka' wẕi'o ža ni'te, benne' ka' beya'wo' nich gono' ḻégake' benne' chekzo' ka', benne' ka' zej zoe' ḻaw Ya'a Sión nga, ga ni zoakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Da ka' gaze yedjḻe'elo' ka nbia yi' yež nga, na' ka nak da' ẕinnj da' bengak benne' ka' che latje la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Ẕbéžeya'agak benne' ka' bi ẕḻé'egekle' Le' chawe' gachje ḻawle gan zej ndobe benne' chio' ka'. Bdá'gake' nga da' ẕḻoe'elen yo'oto' ḻo ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Bchínnjgake' yež ni, ka žon to benne' ẕchoge' yógo'te yag ka' zej zen to ḻaw ya'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Ḻen ya wag chégake' ka', na' ḻen yag chégake' ka', bchínnjgake' yógo'te da' x̱tan ka' che yodo' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Bzéygake' latje la'y chio'. Bká'ngake' ka'ze ližkzo' Le'. Bchínnjgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Wnnágake': “¡Wžía yi'žo ḻégake' to chi'ize!” Bzéygake' yógo'te yo'o gan bká'n ẕento' Le' dot ḻo yežlyó chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Biž bi ẕḻe'elto' da' nak la'y, dan' bchisto' ḻo yežlyó cheto'. Biž zoa no benne' wchaḻje' ḻo wlazo' Le', na' bi zoa no benne' ladjw neto', benne' nnezle' batx̱ yelato'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","X̱anto' Dios, ¿to chi'ize wchix̱gak benne' ka' neto', benne' ka' žsaka' zí'gake' neto'? ¿To chi'ize nnegak benne' ka' bi ẕḻé'egekle' Le' chawe' che La la'y chio' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","¿Biẕ chen' bi be žono' chegak benne' ka'? ¿Biẕ chen' bi ẕžia yi'o benne' wen da' ẕinnj ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","San Le', Dios, nako' Benne' Wnná Bia' chia' ža ni'te. Le' bžia yi'o benne' ka' dot ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Ḻen yeḻa' wak ẕen chio' beno' nisdo' chope ḻa'a. Wló'o yichj bia ẕenḻe'e ka' ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Bzoẕjo' yichj bia ẕenḻe'e, bian' leba' lebiatán, na' beno' ga bdawgak bia yix̱e' ka' ḻeba', bia ka' zej zoaba' ḻo yo biž. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Beno' ga golj nis bej ka', na' nis yegw ka'. Besbižo' yegw ẕen ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Chio' Le' nak ḻawe' ža, na' ḻezka' chio' nak yele. Le' bnnito'o byo', na' wbíž gan zej zoan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Bnnitkzo' to chi'ize yógo'te da' zej že' yežlyó nga. Le' beno' byo' wbá ka', na' byo' zag ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Bejsá' ḻaže' da' ni: benne' ka' bi ẕḻé'egekle' Le' chawe' ben dítjgekle' Le', X̱anto' Dios, na' benne' yaḻ ḻaže' ka' wnnégake' che La la'y chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Bi gaḻ ḻažo'o neto', benne' chio' ka', to chi'ize. Bi wká'n neto', benne' ka' nži'ikzlo', ḻo na'gak benne' ka' zej nake' ka bia snia ka'. Zoato' ḻáwgake' ka zej nak gogoldo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Bejsá' ḻaže' diža' da' bénḻeno' neto', dan' gáte'teze nníta'gak benne' wen da' ẕinnj ka'. Ẕdágake' do ẕente yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Bi go'o latje yedoé'egekle benne' gax̱jw ḻaže' ka'. Benne' ka' ẕzáka'ḻe'egake', na' benne' ka' žiážjegekle' we ḻáwgake' La la'y chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Wzó ža', Dios. Ben kan wnnakzo' gono'. Bejsá' ḻaže' kan žongak benne' yaḻ ḻaže' ka', benne' ka' ẕká'ngake' ka'ze La la'y chio' tža tža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Bi gaḻ ḻažo'o da' wnné zi'gak benne' wen da' ẕinnj ka' chio' Le'. Néntezle žo'osbé da' žongak benne' ka' ẕží'igake' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","“Žóx̱keno'”, že'to' Le', Dios: “žóx̱keno'.” Ẕzenlto' benách ka' zóaḻeno' Le' neto', na' beno' da' ka' žóngaken ga žebanlto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ẕnna Dios: “Bzoa' ža wchi'a ḻaža'a benne' ka'. Wchi'a ḻaža'a ḻo da' nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Ḻa'kze x̱o' dot yežlyó, na' x̱ize yógo'te da' de, gona' ga ga'n choch x̱ni'a yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Žapa' benne' yaḻ ḻaže' ka': Bi sa' ḻáže'le da' ẕen. Žapa' benne' wen da' ẕinnj ka': Bi wká'n ẕen kwinle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Bi wx̱én ḻáže'le yeḻa' waḻe chele. Bi gakle benne' ḻaẕdo' zide ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Bi za' yeḻa' ẕen gan ẕḻa' wbíž, na' gan ženen, na' bi zan' ḻo latje dache. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Dios nake' Benne' wchi'a ḻaže'e benne' ka'. Ẕka'ne' ka'ze to benne', na' ẕka'n ẕene' yetóe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Dios nox̱e' to ẕiga', da' nžan' x̱is uba waḻ, dan' zejḻasen yeḻa' ẕža'a chie'. Wlaljen', na' benne' wen da' ẕinnj ka' yé'jgaken'. Yé'jgaken' na' zejte yebižten, ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","san neda' wzenkzla' benne' ka', na' goḻa' da' we ḻawa' Dios che Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Wchinnje' yeḻa' wak chegak benne' wen da' ẕinnj ka', san yesgóleže' yeḻa' wak chegak benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Zej nonbia' benne' Judá ka' Dios, na' La la'y chie' nga'nen ẕen ladjw benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Ḻo yež Salem zoa latje la'y chie'. Ḻo yež Sión zoa gan zoakze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ḻo latjen' wdíchj Dios yag ntoche' ka' che wdiḻe, na' yag ntóche'do' ka', na' ya da' žape chi'in benne' ka' ḻo wdiḻe, na' ya ntoche' ka', da' ka' ẕkóngekle' žin ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","¡Benne' ẕenḻe'e nako' Le'! ¡Nako' waḻže ka ya'a ẕen ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Chejchégwgak benne' waḻe ka', na' gásḻasgake'. Nitó benne' waḻe bi yechís ne'e nich tíḻ-ḻene' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Dios chegak benne' Israel ka', kate' wtiḻo' benne' ka' besḻaso' ḻégake', na' bia ka' žíagake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Le' nako' Bennen' žaḻa' žébežo. ¿Noẕ benne' gak sie' ḻawo' Le' kate' ẕžo'o? ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Wnnó' wchi'a ḻažo'o benne' ka' ne zo' ya'abá. Ẕžébegak benne' ka' ḻo yežlyó, dan' ẕbézgake' ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","ža so žo'o Le', Dios, nich wchi'a ḻažo'o benách ka', na' nich yesló' yógo'te benne' gax̱jw ḻaže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Da' likze yeḻa' ẕža'a chegak benne' ka' gaken to da' gon ga ga'n ẕeno' Le'. Wlék žio' yeḻa' ẕža'a chegak benne' ka' zej nga'ne'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Le wchebe ḻaže' da' gonnle che Dios, na' le wneẕjwn' che X̱anžon', Dios chele. Benne' ka' nníta'gake' do ẕente ḻá'gake' zej noe'e da' wnéẕjwgake' che Dios, Bennen' ẕžébežo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Ẕži'i Dios che da' yo'o ḻo yichj ḻáẕdo'gak benne' blo ka'. Ḻe' ẕchebe' benne' wnná bia' ka' nníta'gake' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Ḻen chi'a bḻiža' Dios. Bḻiža' Dios, na' Ḻe' bze nage' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Žoa'a ḻaw X̱anžon' kate' ẕzáka'ḻi'a. Žel ẕchis na'a ḻawe' Ḻe', na' bi zoa' žize. Bi bi'a latje no benne' yeyón ẕene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Bsa' ḻaža'a che Dios, na' wžé' zedla'. Bsa' ḻaža'a che da' bena', na' bedó ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Dios, bi bi'o latje tasa'. Wžé' zédḻe'ela', na' bi be gok nnia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Blab ḻaža'a ka zej nak ža ka' wdégaken, na' ka zej nak yiz ka' ba wdégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Bsa' ḻaža'a ka nak da' beḻkza' yele ka', na' blab ḻáže'kza' kan zej naken, na' wnnabla' ḻo be' da' nakkza': ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","¿Bzoa X̱anžon' žo'o cheḻa'ale to chi'ize, na' biž gákḻene' žo'o? ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","¿Batkle yeyache' ḻáže'le' žo'o? ¿Batkle gone' da' wchebe ḻaže'e gone'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","¿Goḻ ḻáže'kze Dios yeyache' ḻáže'le' žo'o? ¿Ẕže'e žo'o nich biž yeyache' ḻáže'le' žo'o? ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Naž wnnía': ki žona' dan' yoa'a yižwé'. Che ḻen chejsá' ḻaža'a yógo'te da' ẕente da' ben Dios ẕente ḻo yiz ka' ba wdégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Chejsá' ḻaža'a da' ẕente ka' da' beno' Le', Jah. O', chejsá' ḻaža'a da' beno' ža ni'te, da' ka' žóngaken ga žebanlto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Wláb ḻaža'a ka nak yógo'te da' beno', na' wchaḻja' ka zej nak da' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Dios, la'y nak da' ẕchi'lo' neto' gonto'. ¿Zoa yetó Dios nake' benne' ẕen ka nako' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Le' nako' Dios, ẕnno' da' žonen ga žebanlto'. Bḻoe'elo' yógo'te benne' yežlyó nakḻe'e ẕen yeḻa' wak chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Ḻen yeḻa' wak chio' beya'wo' benne' chio' ka', ẕa'só Jakob ka', na' ẕa'só José ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Yegw nis ka' bḻé'egeklen Le', Dios. Bḻé'egekle yegw nis ka' Le', na' bžébeḻe'egaken. Ḻezka' wžé' zédgekle nisdo' gže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Nis yejw zil bžojen ḻo bejw gasj ka', na' wnneḻe'e wzió', na' wyasḻe'e yes wzión'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Ḻo be' bdone' wnneḻe'e wzió' chion'. Bza'ní' yes wzión' do ẕente yežlyó. Wẕo'ḻe'e, na' wẕize yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Bsaljo' nez gachj ḻawle nisdo', na' ḻawe' nis zil ka' wdekzo' Le', san bi nak bia' gan blejo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Bchi'o benne' chio' ka' ka ẕila' ka' ḻo na' Moisés, na' ḻo na' Aarón. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Le yenle, ḻe'e, benne' chia' ka', da' žsedla'. Le wzé nag binlo da' ẕchaḻja'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Wkonla' žin diža' ka' kan ẕchaḻjgak benne' žejní'il ka', na' wsá' ḻáža'a ḻe'e da' goken bagáche'ze ža ni'te, ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","da' ka' benlžo, na' da' nnezlžo, da' ka' bzéngekle x̱a x̱to'žo ka' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Bi wkáche'žo da' ka' ḻawgak ẕi'nžo ka'. Wzénkzelžo ẕi'nžo ka' ka nak yeḻa' ẕen che X̱anžon', yeḻa' wak chien', na' da' ẕen ka' da' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Bchi'le' benne' Israel ka' da' žon byenen góngake', na' naken da' žaḻa' gongak ẕa'só Jakob ka'. Bchi'le' x̱a x̱to'žo wdé ka', wzéngekle' ẕí'ngake' ka' ka nak da' wnnakze' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","nich nnézgekle x̱kwide' ka' za' gáljgakbe' kan naken, na' wzéngeklbe' ẕí'ngakbe' ka' da' ẕchi'le' ḻégakbe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","nich wx̱én ḻáže'gakbe' Dios, na' bi gaḻ ḻáže'gakbe' da' ka' ben Dios, na' nich góngakbe' da' ka' bchi'le' ḻégakbe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","na' bi gákgakbe' kan gokgak x̱a x̱tó'gakbe' ka', benne' ka' bi béngake' da' bchi'le' ḻégake', na' bží'igake' chie' Ḻe', na' bi bx̱en ḻáže'gake' Dios dot ḻáže'gake'. Ḻo be' da' zej nakkze' bi gókgake' ḻi ḻaže' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Benne' ẕa'só Efraín ka', benne' zej noe'e da' ẕkóngekle' žin ḻo wdiḻe bẕónnjgake' gan žak wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Bi béngake' kan ẕnna diža' da' benḻen Dios ḻégake', na' bi béngake' dan' bchi'le' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Goḻ ḻáže'gake' da' ka' ben Dios, na' yeḻa' ẕen da' bḻoe'ele' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Bene' yeḻa' wak ẕen ka' ḻawgak x̱a x̱tó'gake' ka' ḻo yežlyó Egipto, na' ḻo yežlyó Soán. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Bsaljwe' nez ḻo nisdo' gan wdegak benne' ka'. Bene' nisdon' ka ya'ado' ka' cheḻa'a weje. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Te ža bḻoe'ele' benne' ka' nez ḻen to bejw gasj da' bnáwgake', na' žel ḻen to bejw da' bsa'nín'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Wḻé'e yej ka' gan nak yo biž, na' bye'je' benne' ka' nis da' bžojen ḻe'egak yej ka' ka to yegw nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Bene' ga bžoj to yegw nis ḻe'e yej na', na' goken to yegw ẕen, ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","san béngakže' doḻa' ḻaw Dios ḻo latje dach, na' bží'igake' che Dios, Bennen' nape' dot yeḻa' wak. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Ni'a che da' wdán ḻáže'gake' béngake' ga bža'a Dios. Wnnábgekle' Ḻe' da' gáwgake' ka wdán ḻáže'zegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Wnnégake' che Dios, na' wnnágake': “¿Wak gonn Dios da' gawžo ladjw yix̱e' nga? ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Da' likze wlé'e yej na', na' bžoj nisen', dan' goken ka to yegw ẕen, san, ¿wak gonne' chežo yet, na' gonne' beḻa' da' gawžo?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Che ḻen bža'a X̱anžon' kate' benle' da' ni, na' bseḻe'e to yi' da' bzeyen baḻ benne' chie' ka', na' bgole yeḻa' ẕža'a chie' ḻen benne' Israel ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","dan' bi bejḻé'gake' che Dios, na' bi bx̱en ḻáže'gake' Ḻe' yeslé' ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","san Dios bseḻe'e bejw ẕan ya'abá, na' bsaljwe' gan ẕžoj da' žseḻe'e zaka' ya'abá, ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","na' bene' ga bex̱jw yet maná kan žak yejw, dan' bdawgak benne' chie' ka'. Bneẕjwe' ḻégake' da' naken ka ẕoa' che ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Bdáwgake' da' žawgak wbás che ya'abá ka'. Bséḻa'ḻi'e da' bdáwgake', na' béljgekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Bene' ga gok to be' da' zan' cheḻa'ale gan ẕḻa' wbíž, na' ḻen yeḻa' wak chie' bene' ga gok be' dan' zan' cheḻa'ale gan ẕde wbíž byo' zag ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","na' ka bix̱te yo bseḻe'e beḻa' da' gáwgake', biado' ka' zej zoa x̱ílgakba', da' zanže ka yož da' žen' žoa'a to yegw ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Bene' ga béx̱jwgakba' gan zej nnita' benne' ka', na' do ẕente gan zej da' yo'o yid chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Bdáwgake'-ba', na' béljgekle'. Dios benne' chégake' da' wdán ḻáže'gake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","san kate' bi na' yéljgekle', na' ne žáwgake'-ba', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","na' bža'a Dios benne' ka' na' bete' benne' Israel ka' zej nakže' benne' waḻe, na' benne' ka' zej nakže' benne' wak. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Ḻa'kze bene' ki, na' béngakže' doḻa', na' ḻa'kze bḻé'egekle' yeḻa' wak ka' da' bene', bi bx̱en ḻáže'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Che ḻen bene' nbabze ža chegak benne' ka', na' gókgaken ka to be' da' žeka'ažo, na' ka zej nak yiz da' wnníta'gake' bdie' ḻégake' ḻo da' wẕáka'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Kate' bete' baḻ benne' ka', na' yezíka'že' beyákgake' che Dios. Beyát ḻáže'gake', na' dot ḻáže'gake' bḻížgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Bejsá' ḻáže'gake' nak Dios Benne' žape chi'e ḻégake' na' nape Dios dot yeḻa' ẕen. Ḻekze' beya'we' ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","san bi gok ḻi ḻaže' da' wnnábgekle', dan' ben ḻáže'gake' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Bi gok ḻi ḻáže'gake' ḻen Ḻe', na' bi béngake' dot ḻáže'gake' ka nak x̱tiže'e dan' bénḻene' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","San Dios beyache' ḻáže'le' chegak benne' ka', na' benít ḻawe' x̱tóḻa'gake', na' bi bžia yi'e ḻégake'. Zan chi'i beké'e yeḻa' ẕža'a chie', na' bi bže'e ḻégake' dot kan bsa' ḻaže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Bejsá' ḻaže'e zej nakze' beḻa' žen. Zej nake' ka to be' da' ẕden, na' bi yežinen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Zan chi'i bží'igake' chie' Ḻe' ḻo latje dachen', na' zan chi'i béngake' ga gok nyache' ḻaže'e Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Zan chi'i béngake' da' bi de chawe' Dios, na' béngake' ga bža'a Dios la'y chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Goḻ ḻáže'gake' ka nak yeḻa' wak ẕen chie', na' ka bene' ḻo ža ka' kate' beya'we' ḻégake' ḻo da' wẕáka'gake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","kate' bene' yeḻa' wak ẕen ka' ḻo yežlyó Egipto, na' bḻoe'ele' da' ka' da' žóngaken ga žebanlžo, da' ka' bene' ḻo yežlyó Soán. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Bene' ga beyák yegw chegak benne' Egipto ka' žen, na' biž gok yé'jgake' nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Bseḻe'e bi'a ka' ladjw benne' ka', bia ka' bsáka'gakba' ḻégake'. Bseḻe'e blož ka' nich bchínnjgakba' yežlyó chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Bseḻe'e biche' zo ka' nich bdáwgakba' linne chégake', na' bžia yí'gakba' da' zej den ḻo yežlyó chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Bseḻe'e yej nis ẕen da' bchinnjen lba uba chégake' ka', na' bseḻe'e da' zag dan' besbižen yag higo chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Bseḻe'e yej nis ẕen da' beten bia yix̱e' chégake' ka', na' bseḻe'e yes wzió' da' beten ẕila' chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Bene' ga wẕáka'ḻe'egak benne' Egipto ka', dan' bžá'aḻi'e ḻégake', na' bseḻe'e da' ka' gókgaken ka wbás zan che ya'abá nich wsaka' zí'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Bi bsane' yeḻa' ẕža'a chie', na' bi benít ḻawe' chégake' nich bi gátgake', san bete' zángake' ḻen to yižwé' ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Bete' bi' byo nežw ka' chegak benne' ka', bi' byo nežw ka' chegak benne' Egipto ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Naž bchi'e benne' chie' ka' ka to benne' ẕchi'e ẕila' ka', na' bchi'e ḻégake' ḻe'e latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Bchi'e ḻégake' dot chawe', na' bi be bžébegake', san benne' Egipto ka', benne' bi bḻé'egekle' ḻégake' chawe', bete' ḻégake' ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Bchi'e benách chie' ka' ḻo yežlyó la'y chie', gan zej nnita' ya'a ka' wleje' Ḻekze' ḻo na'gak benne' ka' wnníta'gake' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Blage' ḻégake' ḻo yežlyón' ḻawgak benách chie' ka'. Bdise' yežlyó chégaken' ládjwgak benne' Israel ka'. Bnnite'e ḻégake' ližgak benne' ka' bebeje' ga na', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","san da' yoble béngake' da' bi de chawe' Dios, na' bža'a Dios, Bennen' nape' dot yeḻa' ẕen. Bi béngake' da' bchi'le' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Da yoble bží'igake' che Dios kan bengak x̱a x̱tó'gake' ka'. Gókgake' ka to yag ntóche'do' dan' bi zejen to wḻize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Béngake' ga bže'e Ḻe' ḻen bkog ka' gan bka'n ẕéngake' lo'a ka', na' ni'a che lo'a chégake' ka' bžá'aḻe'e Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Bža'a Dios kate' bḻe'ele' da' ki, na' bi bḻe'ele' benne' chie' ka' chawe', benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Bsan ḻaže'e yo'o yid la'y chie' dan' wzóan yež Silo, yo'o yiden' gan wzoakze' Ḻe' ladjw benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Bi'e latje bkwasgak benne' ka' bi bḻé'egekle' žo'o chawe' kaj la'y chien', dan' ẕḻoe'e ḻawn yeḻa' wak, na' yeḻa' ẕen chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Bže'e benne' chie' ka', na' bdie' ḻégake' ḻo na'gak benne' ka' bétgake' zángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","X̱kwide' byo ka' chégake' gótgakbe' ḻo wdiḻe, na' bi bga'n no benne' byo kwide', benne' wchág ná'ḻenbe' no'le kwide' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Ḻezka' gotgak bx̱oz ka' chégake' ḻo wdiḻen', na' no'le wzebe ka' chegak bx̱oz ka' bi wžeže nyáche'gake' ni'a chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Naž gok X̱anžon' ka to benne' žebane' ḻo bichgale. Goke' ka to benne' waḻe ẕbéžeyi'e kate' ba ne'je' x̱is uba waḻ. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Blage' benne' ka' bi bḻé'egekle' ḻégake' chawe', na' bka'ne' ḻégake' ka'ze to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Bzoe' cheḻa'ale ẕa'só José ka', na' bi wžíe' ẕa'só Efraín ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","san wžíe' ẕa'só Judá ka', na' Ya'a Sión, dan' nží'iḻe'ele'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Ḻaw ya'a na' bene' yodo' la'y chie', dan' goken ka nak yodo' dan' zoan ya'abá. Bzoa chochen' to chi'ize, ka nakkze yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Wžíe' Dabí, benne' wen žin chie'. Bebeje' ḻe' gan zej nnita' ẕila' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Bkwase' ḻe' gan zoe' žape chi'e ẕila' ka', nich gake' benne' wnná bia', benne' gape chi'e benách chie' ka', ẕa'só Jakob ka', benne' ka' zej nake' benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dabín' ḻo yeḻa' gax̱jw ḻaže' chie' wdape chi'e benne' ka' zej nake' benne' ka' che Dios. Wdape chi'e ḻégake' ḻen yeḻa' wak chie' ḻo yeḻa' dot ḻi ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","X̱anto' Dios, yo'ogak benne' zi'to' ka' ḻo yežlyó chegak benne' chio' ka'. Bcá'ngake' ca'ze yodo' la'y chio'. Bchínnjgake' yež Jerusalén. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Bká'ngake' beḻa' žen gat chegak benne' wen žin chio' ka' gan bdawgak lab ka' ḻégake'. Bdawgak bia yix̱e' ka' benne' chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Bláljgake' žen chegak benne' ka' ka nis ḻo nez ka' che yež Jerusalén, na' bi wzóa no benne' wkache'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Benne' yež gawze ka' ẕchíx̱gake' neto'. Yógo'te benne' ka' žon dítjgekle' neto', na' ẕká'ngake' neto' ka'ze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","¿To chi'ize gak ki cheto', X̱anto' Dios? ¿To chi'ize ẕžo'o neto'? ¿To chi'ize gak yeḻa' ẕža'a chio' ka to yi'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Bža'agak benne' yež ka', benne' bi zej nónbi'e Le', na' benne' zi'to' ka', benne' bi žḻížgake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Bžia yí'gake' ẕa'só Jakob ka', na' bchínnjgake' lížgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Bi yesbago'o neto' da' ẕia da' wbága'gak x̱a x̱na' gole cheto' ka'. Da ka' gaze yeyache' ḻáže'lo' neto', dan' bedó ḻáže'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Gokḻen neto', Dios, Benne' Weslá cheto', nich ga'n ẕen La la'y chio'. Beslá neto', na' bsoḻe doḻa' cheto' nich ga'n ẕen La la'y chio', ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","dan' nnagak benne' ka': “¿Ganẕkze Dios chegak benne' ka'?” Bezí' wzón benne' ka' bétgake' benne' wen žin chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Ben ki nich yógo'te benne' chio' ka', benne' ka' zej yoe'e ḻo na'gak benne' ka' bi ẕḻé'egekle' neto' chawe', ḻé'egekle' da' gono'. Ḻen yeḻa' wak ẕen chio' beslá benne' ka' nžog chégake' gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Bneẕjw chegak benne' yež gawze ka' yegaže kwe' da' ẕinnj ka da' béngake', dan' ben dítjgekle' Le', X̱anto' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Neto', benne' chio' ka', na' ẕila' chio' ka', we ḻawto' Le' to chi'ize. Góḻtezeto' da' wká'n ẕento' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Benle cheto', Dios. Le' žape chi'o benne' Israel ka'. Le' žape chi'o ẕa'só Jwsé ka' ka ẕila' ka'. Ži'o latje blo chio' dan' zoan ḻáwlegak wbás chio' ka' nzi' lágake' kerubín. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Bḻoe'e ḻaw yeḻa' ẕen chio' ḻawgak ẕa'só Efraín, na' Benjamín, na' Manasés. Bḻoe'e ḻaw yeḻa' wak chio', na' da, yesló' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Bezí' neto', Dios. Beyache' ḻaže'l neto', na' yelato'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","X̱anto' Dios, napo' dot yeḻa' wak. ¿To chi'ize žo'o neto' na' bi yenlo' da' nnablto' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Beno' Le' ga žak nyache' ḻáže'to', na' nis ẕbežto' naken da' že'j žawto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Bi'o latje benne' gawze ka' bká'ngake' neto' ka'ze. Benne' ka' ẕžá'agake' neto' ben dítjgekle' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Bezí' neto', Dios. Napkzo' Le' dot yeḻa' wak. Beyache' ḻaže'l neto', na' yelato'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Bebejo' neto' ka to lba uba ḻo yežlyó Egipto. Blago' benne' ka' wnníta'gake' nga, na' gozo' lba uba na' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Wdape chi'o lba uba na' nich golen. Ben lba uba na' lwen, na' bgakwn yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Wló'on ẕoḻ yógo'te ya'a ka', na' ni'a ne'n ka' wló'ogaken ẕoḻ yag sedro ẕen ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Bzáḻa'gaken ni'a ne'n, da' ka' bžíngaken žoa'a nisdo', na' bžíngaken žoa'a yegw Eufrates. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","¿Biẕ chen' bkwaso' le'je da' wdáp chi'in lban'? Na'a benne' ka' ẕdégake' ga na' ẕbángake' uba chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Ẕlejgak koch yix̱e' ka' lba uba na', na' bia yix̱e' ka' žáwgakban'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Bedá cheto', Dios, napkzo' Le' dot yeḻa' wak. Bwia neto' zaka' ya'abá, gan zoakzo', na' da yedjḻe'elo' da' žaken che lba uba chion'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Da, yesló' lba uba ni, dan' gozkzo' Le'. Ẕiže lba uba na', dan' bzoa chochon' naken chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Benne' ka' bi ẕḻé'egekle' neto' chawe' bchóggake' lba na', na' bẕéngaken' yi'. Bwia benne' ka' ḻo yeḻa' ẕža'a chio', na' bžia yi' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Bzoa choch, na' wdáp chi'i benne' ka' ba wžío', na' ẕi'ngak benne' ka' bzoa chocho' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Batkle yebéj yichjto' Le' nitó chi'i. Bkache' chawe' neto', na' wx̱én ḻáže'to' La la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","X̱anto' Dios, napkzo' Le' dot yeḻa' wak, bezí' neto'. Beyache' ḻaže'l neto', na' yelato'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Ḻen yeḻa' žebele le goḻ che Dios, Bennen' žon choche' žo'o. Ḻo yeḻa' ba nez chele le kwéžeya'a ḻaw Dios chegak ẕa'só Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Le goḻ, na' le kapa' yiddo' ka'. Le chinn x̱tan da' ka' žóḻ-ḻenle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Le wkweže lozgak bia ka' kate' nak byo' že'n, dan' naken ža žónteze žonžo lni la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Naken to da' žon byene gongak benne' Israel ka', dan' bchi'le Dios gongak ẕa'só Jakob ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Bzoen' ka to da' wḻoé'elen ẕa'só Jwsé ka' da' ben Dios katen' bžójgake' ḻo yežlyó Egipto, gan benla' to x̱tíža'gak benne' ka' da' bi bejni'ila'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Ẕnna Dios: “Beká'a ywa' da' bdá'gake' x̱kóže'lgak benne' chia' ka'. Beslá' benne' chia' ka' ḻo na'gak benne' ka' bkóngekle' ḻégake' žin. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Ḻo da' wẕáka'le, bḻižle neda', na' gókḻena' ḻe'e. Becheba' chele gan wzóa' to ḻo bejw gasj katen' wnnéḻe'e wzió', na' wẕí' bi'a ḻe'e gan de bej nis da' nzin' Meriba. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Le yenle, benne' chia' ka', na' wzejni'ila' ḻe'e, benne' Israel ka', cha' žaz ḻáže'le si'le da' ẕnnia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Bi si' ḻo na'le dios ka' chegak benne' yež yobl ka'. Bi wzó ẕible ḻawgak dios ka' chegak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Neda', Dios chele, naka' X̱anle. Bebeja' ḻe'e ḻo yežlyó Egipto. Le wsaljw žoa'ale, na' gonna' da' gawle, ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","san benne' chia' ka' bi béngake' da' wnnía'. Benne' Israel ka' bi wyáz ḻáže'gake' si' ḻo ná'gake' x̱tiža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Che ḻen wléj yichja' benne' ka' dan' gókgake' ḻaẕdo' zide. Béngake' da' wdán ḻáže'gakze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Chela' wzé naggak benne' chia' ka' da' wnnía', na' chela' bengak benne' Israel ka' da' bchaḻja', ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","na' ka' gaze wžía yi'a benne' ka' bi ẕḻé'egekle' ḻégake' chawe', na' tíḻ-ḻena' benne' ka' ẕdíḻ-ḻengake' ḻégake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Chela' bengak benne' Israel ki, na' benne' ka' ẕžá'agake' X̱anžo Dios góngake' kan ẕnna x̱tíže'e, (san zej nbage'e ẕia to chi'ize), ");
INSERT INTO ztyNTps_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","na' Dios gone' ga gawgak benne' chie' ka' ẕoa' stribe cháwe'ḻe'e, na' gone' ga yéljgekle' da' ẕix̱ che bez. ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Zoa Dios gan zej ndobe benne' ka' ẕchi'a ḻáže'gake' benne' chie' ka'. Dios ẕchi'a ḻaže'e benne' ka' ẕchi'a ḻáže'gake' benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Ẕnna Dios: “¿Wchi'a ḻáže'tezle benne' chia' ka' ḻo da' bi nak chawe', na' gaple ba la'ne benne' ka' bebéj yíchjgake' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Le gakḻen benne' yache' ka', na' bi' wzebe ka'. Le yeyón ẕen benne' gax̱jw ḻaže' ka', na' benne' ka' žiážjegekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Le gon choch benne' ka' žedó ḻáže'gake', na' benne' yache' ka'. Le yeslá ḻégake' ḻo na'gak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Bi be nnézlele, na' bi žejní'ilele, na' ẕdale ḻo da' choḻ. Žẕizgak yógo'te da' zej de yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Neda' wnnía': nakkzle ḻe'e ka dios ka', na' nakle yógo'tele ka ẕi'nkze Dios ẕente, ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","san gatle ka žatgak yógo'te benne' ka', na' chejchégwle kan žon nóte'teze benne' wnná bia'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Wzó ža', Dios, na' bchi'a ḻaže' benne' yežlyó ka', dan' yógo'te yež ka' yó'ogaken ḻo no'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Dios, bi so' žize. Bi so' žize, Dios, na' bi wsejw žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Ẕbéžeya'agak benne' ka' bi ẕḻé'egekle' Le' chawe', na' ẕka'n ẕen kwingak benne' ka' ẕží'igake' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Bagáche'ze ba béngake' toze diža' bi da' góngake' chegak benne' chio' ka', na' da' góngake' chegak benne' ka' žape chi'ikzo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Wnnágake': “Le cho'o, wžía yi'žo benne' ka' nich biž soa yež chégake', na' biž soa no benne' chejsá' ḻaže'e che yež Israel.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Ba béngake' toze diža' bi da' góngake' chio' Le'. Nákgake' toze ḻo da' žénegekle' góngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Ki žongak benne' Edom ka', na' benne' Ismael ka', na' benne' Moab ka', na' ẕa'só Agar ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","na' benne' Jebal ka', na' benne' Amón ka', na' benne' Amalek ka', na' benne' Filistea ka', na' benne' yež Tiro ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Ḻezka' benne' Asiria ka' zej nake' toze ḻen ḻégake'. Yógo'te benne' ki žónḻengake' tẕen ẕa'só Lot ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Ben chegak benne' ki kan beno' chegak benne' Madián, na' kan beno' che Sísara, na' kan beno' che Jabín žoa'a yegw Sisón, ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","benne' ka' beto' Le' ḻo yežlyó Endor, na' beyákgake' ka x̱che'e beže dan' žonen beb ḻo yo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Ben ga gak chegak benne' blo ka' chegak benne' ki kan gok che Oreb, na' che Seb, na' ben ga gak chegak benne' ka' ẕnna biá'gake' benne' ki kan gok che Seba, na' che Salmuna, ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","dan' wnnagak benne' ki: “Gak chežo yežlyó gan zej nnita' benne' ka' che Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Dios chia', ben ga gákgake' ka laga' biž da' ẕche' to be' da' žechjlen. Ben ga gákgake' ka beb da' ẕche' be' bdone'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Ka žon to yi' da' ẕzeyen to ya'a ẕen, na' ka žon yi' da' ẕzeyen to ḻo win biž, ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","ka'kze wẕía ḻaže' benne' ki to ḻo be' bdone', na' bchebe ḻégake' ḻen to da' ẕen da' gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Ben ga yedoé'eḻe'egekle', nich gápegake' Le' ba la'ne, X̱anto' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ben ga chíx̱gekle', na' kwe' zédgekle' to chi'ize. Ben ga gá'ngake' ka'ze, na' gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Ben ga yeyónbia'gake' nako' Le' X̱anto' Dios. Tozo' Le' nako' Dios ẕente ḻawle dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Nží'iḻe'ela' yodo' chio' Le', Dios. Le' napkzo' dot yeḻa' wak. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ẕdan ḻaža'a soa' ḻo yodo' chio', X̱ana' Dios, na' žak ḻáže'ḻi'a soa' ga na'. Ḻen dot da' naka', na' dot ḻaža'a žoḻa' chio' Le', Dios ban. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Ba bengak byinne ka' x̱ó'ngakba', na' gogoldo' ka' zej de latje gan žẕíagakba' bia že'ndo' chégakba' ka', dan' naken gan zoa žoa'a bkog la'y chio' Le', Dios. Le' napkzo' dot yeḻa' wak. Ẕnna bia'kzo' Le' neda', na' nako' Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Ba nez ẕen naken chegak benne' ka' nníta'gake' ḻo yodo' chio'. To chi'ize wká'n ẕéngake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Ba nez ẕen naken chegak benne' ka', Le' ẕzoa chocho' ḻégake', benne' ka' ẕdan ḻáže'gake' chjake' ḻo ya'a la'y chio', Ya'a Sión. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Kate' ẕdágake' lache' biž dan' nzin' Lache' Nis Ẕbéžežo, žóngake' ga žeyaken to latje gan žaḻ nis zil, na' yeschá' nis yejw latje nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Žákgakže' benne' waḻe x̱ak zej yoe'e nez ga na' dan' ḻé'egekle' Dios ḻaw ya'a la'y chie', Ya'a Sión. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Benle, X̱ana' Dios, da' ẕnnabla' ḻawo' Le'. Le' napkzo' dot yeḻa' wak. Benle cheto', Dios. Nako' Dios che Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Ben chawe' benne' wnná bia' cheto', Dios, benne' wnná bian' wžío' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Gakže chawe' soa' to žaze ḻo yodo' chio' ka soa' to mil yiz ga yoble. Žak ḻáže'ža' soa' gan žó'ogake' yodo' che Dios chia' ka to benne' ndo'w, ka soakza' to liža' da' zaka' gan bi zoa Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","X̱anžo Dios žape chi'ikze' žo'o, na' žon choche' žo'o. Nži'ile' žo'o, na' žon chawe'e žo'o. Žape' benne' ka' ba la'ne, na' nži'ile' ḻégake', benne' ka' zej nake' dot ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Dios, napo' dot yeḻa' wak. Ba nez ẕen naken chegak benne' ka' žx̱en ḻáže'gake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Ben chawo'o benne' chio' ka', X̱ana' Dios. Besló' ẕa'só Jakob ka' ḻo na'gak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Benít ḻawo'o da' ẕinnj da' bengak benne' chio' ka'. Bdio' cheḻa'ale doḻa' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Bzoa žio' yeḻa' ẕža'a chio', na' bsano' yeḻa' yichj ža'a chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ben ga yeyák cheto' yeḻa' ba nez che yeḻa' weslá chio' na' biž žo'o neto', Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","¿To chi'ize žo'o neto'? ¿Žá'akzo' to kwe' to kwe' ẕa'sóto' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","¿Biž gono' ga yebelto' da' yoble, nich gaken cheto' yeḻa' ba nez ḻawo' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","X̱anto' Dios, beyache' ḻaže'l neto', na' beslá neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Wzé naga' da' nna X̱ana' Dios. Nne' da' gonen ga ga'ngak chawe' benách chie' ka' nich biž gongak benne' la'y chie' ka' da' yaḻze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Da' likze Dios zóateze' yeslé' benne' ka' žápegake' Ḻe' ba la'ne, na' ḻa' ḻaw yeḻa' ẕen chie' ḻo yežlyó chežo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Zej nžag yeḻa' žeyache' ḻaže', na' da' li che Dios. Nakgak toze da' chawe', na' yeḻa' ẕga'n chawe' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Da' nak dot da' li chie' yeschán' yežlyó nga, na' seḻe'e da' chawe' chie' da' zan' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","X̱anžo Dios žseḻe'e nis yejw chežo, na' yežlyó chežo gonnḻe'en linne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Da' naken chawe' žejlen Dios, na' wḻoe'elen nez da' chéjḻenžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","X̱ana' Dios, bze nag, na' benle chia', dan' ẕzaka'a neda', na' žiážjela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Bwia neda' dan' naka' chio'. Dios chia', beslá neda', wen žin chio', dan' žx̱en ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","X̱ana' Dios, beyache' ḻaže'l neda', dan' žḻiža' Le' dot ža, dot yele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Ben ga yebéḻe'ela' neda', wen žin chio', dan' ẕzoa kwina' ḻo no'o Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Nako' Le' chawe', X̱ana' Dios, na' ženít ḻawo'o neto', na' žeyache' ḻáže'tezlo' benne' ka' žḻížgake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","X̱ana' Dios, benle da' ẕcháḻjḻena' Le', na' bze nag da' ẕnnabla' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Ḻo ža kwe' zedḻa' wḻižkza' Le', dan' žechébekzo' Le' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","X̱anto' Dios, bi zoa no benne' nake' dios ka nako' Le' na' bi zoa no benne' gak gone' ka nak da' žono' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Beno' Le' benne' ka' nníta'gake' yógo'te yež ka'. Ḻá'gake', na' wká'n ẕéngake' Le', X̱anto' Dios, na' wká'n ẕéngake' La la'y chio', ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","dan' nako' ẕen, na' žono' da' žonen ga žebanlto'. Tozo' Le' nako' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Bsedle neda' da' žak ḻažo'o gona', X̱ana' Dios, na' gona' da' naken dot da' li chio'. Bchi'le ḻáẕda'wa' nich žeba' La la'y chekzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Dot ḻaža'a wká'n ẕenkza' Le', X̱ana' Dios, na' wká'n ẕenkza' La la'y chekzo' Le' to chi'ize, ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","dan' žeyache' ḻáže'tezlo' neda', na' besló' be' da' nakkza' ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","X̱ana' Dios, benne' ka' ẕka'n ẕen kwíngake' ẕdíḻ-ḻengake' neda'. Zej nake' benne' yichj ža'a ka', na' žénegekle' gótgake' neda', na' bi ẕžébegake' Le', ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","san Le', X̱ana' Dios, žeyache' ḻáže'lo' neto'. Nako' ẕen ḻaže', na' bi ẕžo'o to chi'ize, san žeyache' ḻáže'tezlo' neto', na' nako' dot ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Bwia kan žak chia', na' beyache' ḻaže'l neda'. Benn neda' yeḻa' wak chio', neda' wen žin chio', na' wdape chi'i neda', ẕi'n no'le wen žin chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Bḻoe'el neda' to da' gak bian' gak chawe' chia', na' ben ga benne' ka' bi ẕḻé'egekle' neda' chawe' ḻé'egeklen', na' yedoé'egekle', dan' Le', X̱ana' Dios, gókḻenkzo' neda', na' beyón ẕeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Len yež Sión žian ḻaw ya'a la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Nží'ižele X̱anžo Dios latje gan ẕchi'a ḻáže'gak benne' ka' nníta'gake' yež Sión, ka nži'ile' yógo'te liž ẕa'só Jakob ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","X̱tanḻe'e nak da' ẕnna Dios kan nak yež chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Ẕnne': “Chejsá' ḻaža'a zej nnita' benne' ka' zej nónbi'e neda' ḻo yežlyó Egipto, na' ḻo yež Babilonia. Le wia nga, ḻo yežlyó Filistea, na' ḻo yež Tiro, na' ḻo yežlyó Etiopía, goljgak benne' ki zej nake' chia' neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Ka nak che yež Sión ẕnne': “Benne' ni, na' bennen' góljgake' ga na', na' neda', Dios ẕente, wzóa chocha' yežen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Kate' wláb X̱anžo Dios benne' ka' zej nake' chie', nnakze' Ḻe': “Benne' ni golje' ḻo yežen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Benne' ka' žóḻgake', na' benne' ka' ẕyá'agake', nnágake': “Dot da' napa' zan' ḻo yežen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","X̱ana' Dios, Le' žeslakzo' neda'. Dot ža dot yel žḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Benle da' ẕchaḻja' ḻawo' Le', na' bze nag da' žḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Žedó ḻaža'a ḻo da' bi nak chawe' da' žaken chia', na' ba zoa' gata'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Ẕḻé'egekle benne' ka' neda' ka to benne' gat, dan' žatḻe'e ni'a na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Nga'na' ka'ze ladjw benne' gat ka'. Naka' ka benne' ka' gótgake' ḻo wdiḻe, na' zej die' ḻo yežw ba ka', benne' ka' biž žezá' ḻažo'o, Dios, chégake', na' biž zej yoe'e ḻo no'o Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Žak chia' ka bzoakzo' neda' to ḻo yežw gže', gan nak choḻ, na' nakḻe'en gže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Žekla' ẕžá'aḻi'o neda'. Da' žak chia' naken kan žetja' ẕan nisdo' dan' ẕgo'nḻe'en. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Beno' ga bebíga'gak lježa' ka' gan zoa'. Beno' neda' ka to da' žesgotlen benne' ka'. Naken chia' ka nyejwa' liž ya, na' bi gak yežoja'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Ẕchoḻ yej ḻawa' ni'a che da' ẕzáka'ḻi'a. Yógo'te ža žḻiža' Le', X̱ana' Dios. Ẕchis na'a ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","¿Ḻen yeḻa' wak che ya'abá gákḻeno' benne' gat ka'? ¿Že'gak benne' gat ka' Le': “Žóx̱keno'”? ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","¿Ẕchaḻjgak benne' ka' zej ngache'e yežw ba che yeḻa' ži'i ḻaže' chio'? ¿Ẕchaḻjgak benne' ka' zej yoe'e latje choḻ chegak benne' gat ka' che da' ḻi ḻaže' chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","¿Yeyónbia'gak benne' ka' zej yoe'e latje choḻen' ka nak da' ẕente da' žono'? ¿Yeyónbia'gak benne' zej yoe'e gan bi zoa no benne' žesá' ḻaže'e nakkzo' chawe'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","San neda' žḻiža' Le', X̱ana' Dios. Yógo'te zile da' ẕnnabla' Le' ženlen ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","¿Biẕ chen' žebéj yichjo' neda', X̱ana' Dios? ¿Biẕ chen' bi ẕwio' neda' nich gákḻeno' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ẕzáka'ḻi'a, na' ba zoa' gata'. Kate' ne naktia' bi' kwide' ẕzáka'ḻi'a dan' bsako'o Le' neda', na' žedó ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Žekla' ẕžá'aḻi'o neda'. Da' ẕchebo' neda' benen ga bedó ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Zej nyechjle da' ki neda' dot ža. Žsáka'gaken neda' gáte'teze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Beno' ga bebíga'gak lježa' ka' gan zoa', na' toze da' nak choḻ zóaḻenen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","X̱ana' Dios, góḻteza' che yeḻa' ži'i ḻaže' chio'. Wzenla' to kwe' to kwe' ẕa'sóto' ka' nako' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nnezla' sóateze yeḻa' ži'i ḻaže' chio', na' to chi'ize zoa yeḻa' ḻi ḻaže' chio', kan zoakze ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Le' wnnó': “Bena' to diža' ḻen bennen' wžía'. Bchebe ḻaža'a da' gona' che Dabí, wen žin chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Goža'-ne': gona' ga sóatezegak ẕa'só' ka', na' gona' ga nna biá'tezgakbe' ḻo wlazo' le'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Benne' ka' nníta'gake' ya'abá žoe ḻáwgake' Le' ni'a che da' ẕente da' žono', na' ni'a che yeḻa' ḻi ḻaže' chio', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Bi zoa no benne' ya'abá, bennen' nake' ka nakkzo' Le', X̱ana' Dios. Bi zoa no benne' nake' benne' ẕente ka nako' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Benne' ka' zej nnite'e ya'abá žápegake' Dios ba la'ne na' yógo'te benne' chie' ka' ẕžébegake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","X̱anto' Dios, ẕnna bi'o benne' zante, benne' žjake' ḻo wdiḻe, nníta'gake' ya'abá. Bi zoa no benne' nake' ka nako' Le', X̱ana' Dios. Nako' Benne' wáḻeḻe'e, na' nakkzo' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Ẕnna bi'o nisdo' dan' ẕgo'nen. Kate' ẕgo'nḻe'en Le' ẕbek žion'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Blej bchochjo' benne' Egipto ka', na' bgá'ngake' ka to da' gat. Besḻaso' benne' ka' bi ẕḻé'egekle' Le' chawe' ḻen no'o wáḻeḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Chio' Le' nak ya'abá, na' chio' Le' nak yežlyó. Beno' yežlyó nga, na' da' ka' nníta'gaken ḻawlen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Beno' da' de cheḻá'a gan za' be' zag, na' da' de cheḻá'a gan ẕde wbíž byo' zag ka'. Ḻo yeḻa' žebele žoḻgak Ya'a Tabor, na' Ya'a Hermón chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Benne' wáḻeḻe'e nako' Le', na' ẕenḻe'e nak yeḻa' wak chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Ḻo da' chawe', na' ḻo da' ḻi ḻaže' ẕnna bi'o. Ḻo yeḻa' ži'i ḻaže' na' ḻo da' ḻi ḻaže' žono' yógo'te. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Ba nez ẕen naken chegak benne' ka' žóḻgake' da' žoe ḻáwgake' Le', na' zej zoe' ḻo yeḻa' baní' chio', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Ni'a chio' Le' žebéḻe'egekle' dot ža, na' želyenle' x̱tižo'o Le' dan' nako' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Nakkzo' Le' yeḻa' waḻe chegak benne' ka', na' ḻezka' yeḻa' x̱tan chégake'. Žono' neto' wáḻeže dan' naken da' žénekzlo' gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","X̱anžo Dios žape chi'e žo'o, na' Dios la'y chegak benne' Israel ka' ẕchi'le' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Ža ni'te bchaḻjo' da' bḻoe'elo' benne' chawe' ka', benne' wen žin chio' ka', na' wnnó': “Ba wžía' to benne' waḻe ladjw benne' chia' ka'. Bena' ga ẕnna bi'e, na' žákḻena' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Wžía' Dabí, benne' wen žin chia'. Bzoakza' ḻe' nich gake' benne' wnná bia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Neda' gákḻenteza' ḻe'. Ḻen yeḻa' wak chia' gon chocha' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Benne' ka' bi ẕḻé'egekle' ḻe' chawe' bi gak bi da' góngake' chie', na' benne' wen da' ẕinnj ka' bi gak góngake' ḻe' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Wléj wchochjkza' benne' ka' bi ẕḻé'egekle' ḻe' chawe', na' wkwasa' benne' ka' ḻawe' ḻe'. Wžía yi'a benne' ka' ẕží'igake' chie' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Ží'itezla' ḻe', na' gaka' ḻi ḻaže' ḻen ḻe', na' ni'a chia' neda' golže yeḻa' wnná bia' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Gona' ga nna bi'e do ẕente žoa'a nisdo', na' do ẕente žoa'a yegw Éufrates. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ḻe' yi'e neda': Le' nako' X̱a'. Nako' Dios chia'. Žape chi'o neda', na' žesló' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Neda' wzóa' ḻe' ka ẕi'na' blo, na' nna bi'e yógo'te benne' wnná bia' ka' dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Ží'itezla' ḻe', na' sóateze diža' da' bénḻena' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Gona' ga sóatezegak ẕa'sóe' ka', na' nna biá'gake' ḻo wlaze' ḻe' x̱ak zoa ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Cha' wsangak ẕa'só Dabí ka' da' bchi'la' ḻe'e, na' cha' bi góngake' ka nak da' goža' ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","na' cha' wzóagake' cheḻa'ale da' bsedla' ḻégake', na' cha' bi góngake' kan ẕnnakza' neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","na' wsaka' zi'a ḻégake' dan' ẕží'igake' chia' neda', na' chinnja' ḻégake' yid dan' žóngake' da' ẕinnj, ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","san bi wsana' kan nži'ila' Dabí, na' bi wsana' gak ḻi ḻaža'a ḻen ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","na' bi gaḻ ḻaža'a diža' da' bénḻena' ḻe', na' bi wchá'a da' ba wnnía'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","To chi'ize bzetj kwina', bchebe ḻaža'a bi da' gona', na' batkle gon ḻaža'a che Dabí. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Wnnía': Sóatezegak ẕa'sóe' ka', na' nna biá'gake' ḻo wlaze' ḻe' ḻawa' neda' x̱ak zoa wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Yeḻa' wnná bia' chie' sóatezen choch x̱ak zoa byo' ya'abá. Sóatezen choch x̱ak zoa ya'abá.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Le', Dios, wléj yichjo', na' bzo' cheḻa'ale bennen' wžío', na' ẕžá'aḻi'o ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Bzo' cheḻa'ale diža' dan' bénḻeno' Dabí, benne' wen žin chion', na' bka'no' ka'ze yeḻa' wnná bia' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Bchinnjo' ze'e da' wdape chi'in yež ẕen chien', na' bchinnjo' yógo'te yo'o waḻe, da' ka' wdape chí'igaken yežen' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Yógo'te benne' ka' ẕdégakze' ga na' ẕbángake' da' ka' gota' chie', na' benne' yež gawze ka' žon dítjgekle' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Beno' ga bzéx̱jwgak benne' ka' ḻe', benne' ka' bi ẕḻé'egekle' ḻe' chawe', na' žebéḻe'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Bchinnjo' da' ka' ẕkonle' žin ḻo wdiḻe, na' bi gókḻeno' ḻe' ḻo wdiḻen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Bekó'o yeḻa' ẕen chie', na' bka'no' ka'ze yeḻa' wnná bia' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Beno' ga nake' ka to benne' gole kate' ne zoe' yiz kwide' chie', na' beno' ga žedoe'ele'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","X̱anto' Dios, ¿to chi'ize bi yenlo' cheto'? ¿To chi'ize ẕža'akzo' neto'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Bejsá' ḻaže' soa' yežlyó nga to chí'ido'ze. Beno' ga zoagak nbangak yógo'te benne' to chí'ido'ze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Nitó benne' bi soe' nbane' to chi'ize. Yógo'tie' gátgake'. Nitó benne' bi yelé' ḻo na' yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","X̱anto' Dios, ¿biž nži'ilo' Dabí kan bchebe ḻažo'o, na' wnnakzo' gono'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Bwia nga, X̱anto' Dios, ka yógo'te benách ẕka'ngak benne' wen žin chion' ka'ze, na' nbaga'a neda' da' žon dítjgekle benne' wláž chia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Benne' ka' bi ẕḻé'egekle' Le' chawe' žon dítjgekle' bennen' wžío' Le', X̱anto' Dios. Žon dítjgekle' ḻe' gáte'teze zeje'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","¡Ga'n ẕen X̱anžo Dios to chi'ize! Ka' naken, na' ka' gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","X̱anto' Dios, to chi'ize nakkzo' Le' to gan že' cháwe'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Ža ni'te kate' bi na' gono' ya'a ẕen ka', na' bi na' soa yežlyó nga, ža ni'te, na' zejte ža se ḻawte ža nakkzo' Le' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Žono' ga žeyakgak benne' ka' da' gókgake', kate' ži'o ḻégake': “Le yeyák bix̱te yo.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Chio' Le' to mil yiz zej naken ka neje, žan' da' ba wdén, na' ka to chí'ido'ze gachje yele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Ka' gaze ẕkwaso' benne' ka' ka žon to nis wbá'a. Zej nake' ka to bichgale dan' ẕnnitlen kate' žebanžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Zej nake' ka to yeje yix̱e' da' žaljen zildo', na' kate' ẕḻa' wbíž, na' ẕbižen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Ẕbia yi'to' dan' ẕžo'o neto'. Že' zedlto' dan' ẕžá'ḻi'o neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ẕḻe'elo' yógo'te da' bi nak chawe' da' žonto'. Ẕḻoe'elo' ḻaw ẕia da' nbága'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Ẕzacho'o yiz cheto' dan' ẕžo'o neto'. Žeyožgak yiz cheto' ka to be' da' ẕka'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Ka zej nak ža zoato' nbanto', zej nakzen chonnlalj chi yiz, na' cha' nakto' benne' waḻe, wak soato' nbanto' taplalj yiz, san ka zej nak yiz ka', ẕzáka'to', na' že' zedlto'. Ka' gaze ẕdegak yiz ka', na' ẕnitlto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","¿Noẕ benne' nnezle' binlo ka nak yeḻa' ẕža'a chio'? ¿Noẕ benne' nnezle' ka nak yeḻa' yichj ža'a chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Bsedle neto' wkonlto' binlo žin ža cheto' ka', nich gak chejni'ilto' cháwe'do'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","X̱anto' Dios, beyón neto' toze ḻen Le'. ¿To chi'ize želo'? Beyache' ḻaže'l neto', benne' wen žin chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","To to zil bzoa yichj ḻáẕdo'to' yeḻa' ži'i ḻaže' chio', na' ḻo yeḻa' žebele góḻtezto' chio' yógo'te ža soato' nbanto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Benn cheto' yiz zan nich yebelto' ka zej nak yiz bsáka'ḻi'o neto', na' ka zej nak yiz wžé' zedlto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Be' neto', benne' wen žin chio' ka', latje ḻe'elto' da' ẕen da' žono', na' ḻé'egekle ẕa'sóto' ka' yeḻa' ẕen chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","X̱anto' Dios, ben chawe' neto'. Ben chawe' žin da' žonto'. ¡O', X̱anto' Dios, ben chawe' žin da' žonto'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Bennen' žx̱en ḻaže'e X̱anžo Dios nich gape chi'e ḻe', na' ẕzi'e Dios, Bennen' nape' dot yeḻa' wak, nich gákḻene' ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","wak yi'e Dios: “Le'kze žx̱en ḻaža'a, na' Le' ẕkache' chawo'o neda'. Nako' Dios chia', na' žx̱en ḻaža'a Le'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Ḻe' wkache' chawe'e le' ḻo da' ẕia da' bi nḻa' ḻawn, na' ḻo yižwé' da' žoten benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Wkache' chawe'e le' ka žon to ẕkoko', bian' žape chi'iba' bríse'do' ka' ẕan x̱ilba', na' cho'o chawo'o ḻo ne'e Ḻe'. Yeḻa' ḻi ḻaže' chie' gon chi'in le', na' wkache' chawen' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Bi be gak wchebe le' žel, na' bi be gon le' da' ẕia te ža, ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","na' to yižwé' che da' choḻ bi be gonen chio' le', na' to da' ẕinnj da' žoten benne' ka' te ža, bi be gonen chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Wak gatgak to mil benne' ka' kwito' le', na' chi mil benne' ka' gawze gan zo', san bi be sako'o le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Wio', na' ḻe'elo' da' ẕia da' gaken chegak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Wẕi'o X̱anžo Dios, na' žx̱en ḻažo'o Ḻe', na' Dios, Bennen' nape' dot yeḻa' wak, wkache' chawe'e le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Che ḻen bi be da' ẕia gak bi da' gonen chio', na' bi cho'o nitó yižwé' ližo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Dios seḻe'e wbás che ya'abá chie' ka' nich gákḻengake' le', na' gape chí'igake' le' gáte'teze gan chejo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Góx̱wgake' le' ḻo ná'gake' nich bi gon to yej ni'o we'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Wlejkzo' bež yix̱e' ka', na' beḻe ka', bež yix̱e' sníaḻe'e ka', na' bia snia ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Ẕnna Dios: “Yeslá' yógo'te benne' ka' zej nži'ile' neda', na' wkache' chawa'a benne' ka' žechébgake' naka' X̱ángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Kate' wḻížgake' neda', na' yecheba' chégake'. Kate' že' zédgekle', sóaḻenkza' ḻégake'. Yeslá' ḻégake', na' gapa' ḻégake' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Gona' ga sóagake' nbángake' yiz zante, na' yeslá' ḻégake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","X̱anto' Dios, da' x̱tanḻe'e žoe ḻawto' Le', na' žoḻto' da' ẕka'n ẕenen Le', Dios ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Nakḻe'e x̱tan ẕzenlto' benne' ka' zil-le kan žeyache' ḻáže'lo' neto', na' žel ẕḻoe'elto' nako' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Žoḻto' chegak da' ki, na' ẕchinnto' da' žóḻ-ḻento' dan' nwan' chi do, na' ẕgoḻto' da' ẕnneḻe'en x̱tando'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","X̱ana' Dios, ni'a che da' žono' Le' žebéḻe'ela'. Ni'a che da' ben no'o nak chia' yeḻa' ba nez. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Ẕenḻe'e nak da' beno', X̱ana' Dios, na' ẕenḻe'e nak da' ẕgo'o ḻo yichj ḻáẕda'wa' gona'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Batkle chejní'igekle benne' ḻaẕdo' zide ka', na' bi gak nnézgekle benne' nat ḻaže' ka' da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Kate' ẕgólegak benne' ka' ẕbej yíchjgake' Dios kan ẕgole yix̱e', na' žežój chawe' da' žongak benne' wen da' ẕinnj ka', naken nich kwia yí'gake' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Le', X̱ana' Dios, nakkzo' Dios ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Nak bia' da' gak chegak benne' ka' ẕží'igake' chio' Ḻe', X̱ana' Dios. Nak bia' kwia yi'gak benne' ka' bi ẕḻé'egekle' Le' chawe'. Wẕonnjgak yógo'te benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Le' žono' ga nakža' neda' waḻe kan nak to beže. Ẕgo'o set yichja' da' žon chochen yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Da' likze ḻe'ela' benne' ka' bi ẕḻé'egekle' neda' chawe' wzóa ẕíbgake' ḻawa' neda', na' yenla' kwež nyáche'gak benne' ka' bdíḻ-ḻengake' neda', benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Changak benne' chawe' ka' ka žongak yag zina' ka'. Gólegake' kan ẕgólegak yag sedro ka' ḻaw Ya'a Líbano. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Zej nake' ka to yag da' zen ḻo ḻi'a yodo' che X̱anžo Dios, dan' ẕgóleḻe'en ḻo ḻi'a liž Dios chežo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Zej nake' ka yag ka' ẕbíagaken kate' ngóleḻe'egaken na' ne zej naken yag ya'a waḻe ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Benne' ki wzéngekle' benách ka' nak X̱ana' Dios ḻi ḻaže', na' Bennen' žon choche' neda', na' bi be zoaḻen Le' da' bi naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","X̱anžo Dios nake' Benne' Wnná Bia' Ẕen, na' nakwe' da' záka'ḻe'en. Da' nžejw ḻi'e naken yeḻa' wak ẕen. Bzoa choche' yežlyó nga, na' bi gak no benne' wtén'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Gan ži'o ẕnna bi'o, X̱anto' Dios, wzóa chochen ža ni'te na' Le' zoakzo' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Žónḻe'egak yegw ka' žax̱to', X̱anto' Dios. Žónḻe'egaken žax̱to', na' ẕnnégaken zižje. ");
INSERT INTO ztyNTps_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","X̱anžon', Bennen' zoe' ya'abá, napže' yeḻa' wak ka nak da' zej nape yegw ka' žónḻe'egaken žax̱to', na' ka nak da' nape nis ẕgo'nen che nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Chochḻe'e zej nak da' ka' wnnakzo', X̱anto' Dios. La'y nakkze yodo' chio' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","X̱ana' Dios, Le' žezi'kzo' wzón benne' ka'. Le' žebéj yichjo' benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Ẕchi'a ḻažo'o Le' da' žongak yógo'te benne' ka'. Wzó ža', bsaka' benne' ka' kan žaḻa' gak chégake', benne' ka' ẕka'n ẕen kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","X̱ana' Dios, ¿to chi'ize gongak benne' wen da' ẕinnj ka' ki? ¿To chi'ize yebégekle benne' ẕbej yíchjgake' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","¿To chi'ize wká'n ẕen kwíngake', na' nne zí'gake'? ¿To chi'ize wká'n ẕen kwingak benne' ka' žebéj yíchjgake' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Benne' ki ẕžia yí'gake' benne' chio' ka', X̱ana' Dios na' žsaka' zí'gake' benne' ka' wžekzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Žótgake' no'le wzebe ka', na' benne' zi'to' ka', na' žóngake' ga gatgak bi' wzebe ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Ẕnnágake': “Bi be ẕḻe'el Dios, X̱angak benne' ka', dan' Dios chegak benne' Israel ka' bi ži'e wnné yoe chégake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Le chejní'il, ḻe'e, benne' ḻaẕdo' zide ka', ḻe'e, benne' nat ḻaže' ka'. ¿To chi'ize bi chejní'ilele? ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Dios bene' nagžo. ¿Bi ženle' da' ẕnnale? Dios bene' yej ḻawžo. ¿Bi ẕḻe'ele' da' žonle? ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Dios žsaka' zi'kze' benne' yež ka'. ¿Bi tiḻe' ḻe'e? Dios nake' Bennen' ẕzejni'ile' benách ka'. ¿Bi gákbe'ele' da' yo'o yichj ḻáẕdo'le? ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","X̱anžo Dios nnezkzle' da' yo'o yichj ḻáẕdo'gak yógo'te benách. Nnezle' zej naken da' yaḻze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","X̱ana' Dios, ba nez ẕen naken che bennen' ẕzejni'ilo' Le', na' žsedlo' ḻe' ka nak da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Ga'n bennen' chawe' kate' za' ža gak bi da' sake'e, na' ža na' gáche'gak benne' wen da' ẕinnj ka' yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Batkle kwej yichj X̱anžo Dios benne' chie' ka', na' bi wsán ḻaže'e benne' ka' ba wžekze' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","san gone' ga wchi'a ḻáže'gak benne' ka' ḻo da' naken chawe', na' yógo'te benne' ḻi ḻaže' ka' si' ḻo ná'gaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","¿Noẕkze benne' gákḻene' neda' nich tíḻ-ḻenžo benne' wen da' ẕinnj ka'? ¿Noẕkze benne' gónḻene' neda' tẕen nich wžía yi'žo benne' wen da' ẕinnj ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Chela' bi gokḻen X̱anžon' neda', ba bejgacha'a yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Kate' wnnía': zoa' chejchégoa'a, na' Le', X̱ana' Dios, ḻo yeḻa' ži'i ḻaže' chio' gókḻeno' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Kate' ži'a wnné yoe, na' že' zedla', žeyón ẕenkzo' neda', na' žono' ga žebéḻe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Batkle gako' toze ḻen benne' ka' ẕchi'a ḻáže'gake' benách ka' ḻo da' bi nak chawe', benne' ka' ẕzóagake' cheḻa'ale da' naken chawe', na' da' bchi'lo' Le' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Benne' ki žóngake' toze diža' bi da' góngake' che no benne' nake' chawe', na' ẕchóggake' chie' gate', na' bi be ẕia nbage'e, ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","san X̱anžo Dios nake' ka to yo'o gan zoa chawa'a. Dios chia' nake' ka to yej x̱e da' žon chochen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Ḻe' yebi'e chegak benne' wen da' ẕinnj ka' ka nakkze da' ẕinnj da' béngake'. Wžía yi'e benne' ka' ni'a che da' bi nak chawe' da' žóngake'. X̱anžo Dios wžía yi'e benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Le da ḻe'e, wká'n ẕenžo X̱anžo Dios. Ḻen yeḻa' žebele goḻžo che Bennen' ẕzoa choche' žo'o nich yelažo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Chejžo ḻawe' Ḻe', na' ye'žo-ne': “Žóx̱keno'.” Ḻen yeḻa' žebele goḻžo da' we ḻawžo Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","X̱anžon' nake' Dios ẕente, na' nake' Benne' wnná bia' ẕénḻe'eže ka dios ka' chegak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Ẕnna bi'e dot yežlyó nga, gan nak gže', na' gan nak sibe ḻaw ya'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Ẕnna bi'e nisdo', da' benkze' Ḻe', na' ḻezka' yežlyó nga da' bene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Le da, wká'n ẕenžo-ne', na' wzóa ẕibžo ḻawe'. Wzóa ẕibžo ḻaw X̱anžon', Bennen' bene' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Ḻe' nake' Dios chežo, na' nakžo chie' Ḻe'. Nakžo benne' ka' žape chi'ikze', na' nakžo ka ẕíla'do' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Ẕnna X̱anžon': “Cha' žénlele chi'a na'a ža, bi gonle zide ḻáẕdo'le kan bengak x̱a x̱to'le ka' gan nzin' Meriba, na' kan béngake' ḻo ža na' ḻe'e latje dach gan nzin' Masah, ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","gan bcha'agak x̱a x̱to'le ka' neda', na' béngake' ga bža'a neda' ḻa'kze bḻé'egekle' yógo'te da' ẕen ka' da' bena'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Choplalj yiz bzoela' benne' ka', na' wnnía': zej nake' benne' žebéj yíchjgake' neda', na' bi žóngake' kan bchi'la' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Che ḻen, ḻo yeḻa' ẕža'a chia' ben chocha' x̱tiža'a, na' wnnía': bi chó'ogake' gan yezí' ḻáže'gake' tẕen ḻen neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Le goḻ che X̱anžo to da' kob. Le goḻ che X̱anžon', ḻe'e zoale do ẕente yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Le goḻ che X̱anžon', na' le wká'n ẕen La la'y chie'. Tža tža le wzenle benách ka' kan žeslé' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Le wzenle benne' zi'to' ka' ka nak yeḻa' ẕen chie', na' benne' yógo'te yež ka' kan nak da' ẕen da' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Ẕente nak X̱anžon', na' žaḻa' wká'n ẕénḻe'ežo-ne'. Žaḻa' gapžo Ḻe' ba la'ne, na' kege dios ka' chegak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Zej nakze yógo'te dios ka' lo'a ka', san X̱anžo Dios bene' ya'abá na'le. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Nape' Ḻe' yeḻa' wak, na' yeḻa' wnná bia'. Nža' yodo' chie' yeḻa' ẕen, na' yeḻa' x̱tan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Le wká'n ẕen X̱anžon', ḻe'e zoale dot yežlyó nga. Le wká'n ẕen yeḻa' ẕen chien', na' yeḻa' wak chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Le gape ba la'ne X̱anžon' kan žaḻa' gonžo. Le yedjwá' da' wnéẕjwle na' le cho'o yodo' x̱tan chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Le wká'n ẕen X̱anžon' dan' nake' la'y, na' x̱tanḻe'e. Le žebe ḻawe' Ḻe', ḻe'e zoale dot yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Le ye' yež ka': “Nak X̱anžon' Benne' Wnná Bia' Ẕen. Bzoa choche' yežlyó nga, na' bi gak no benne' wtén'. Wchi'a ḻaže'e benne' ka' ḻo da' naken chawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Le yebele, ḻe'e, zoale ya'abá, na' yežlyó nga. Le nne, ḻe'e, nisdo', na' bia ka' zoale ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Le yebele, ḻe'e, yix̱e', na' bia ka' zoale ga na', na' ḻe'e, yag ka' zej zen ḻo ya'a ka'. Le nne zižje ḻo yeḻa' žebele chele, ");
INSERT INTO ztyNTps_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","ḻaw X̱anžon' kate' yide'. Yide' nich wchi'a ḻaže'e benách ka' ḻo yežlyó nga. Nna bi'e benne' ka' do ẕente yežlyó. Nna bi'e ḻégake' ḻo da' naken chawe', na' ḻo da' naken dot da' li. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Nak X̱anžon' Benne' Wnná Bia' Ẕen. ¡Le yebele, ḻe'e zoale yežlyó! ¡Le yebele, ḻe'e zoale žoa'a nisdo'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Zej nyechjle bejw, na' da' choḻ Ḻe'. Ḻo da' naken dot da' li, na' da' chawe' ẕnna bi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Ẕnežw yi' gan žeje' Ḻe', da' wzeyen benne' ka' bi ẕḻé'egekle' Ḻe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Yes wzió' chie' ka' žsa'ní'gaken yežlyó. Yežlyó nga ẕḻe'elen, na' žẕon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Želángak ya'a ka' ka china' bez ḻaw X̱anžon', ḻaw X̱angak benne' ka' nníta'gake' dot yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Ẕḻoe'e ḻaw ya'abá da' chawe' chie', na' benne' yógo'te yež ẕḻé'egekle' yeḻa' ẕen chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Yedoé'egekle benne' ka' ẕka'n ẕéngake' lo'a ka', benne' ka' ẕka'n ẕen kwíngake' ni'a chegak lo'a ka' chégake'. Yógo'te dios chegak benne' ka' wzóa ẕíbgaken ḻaw X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Béngekle benne' ka' nníta'gake' yež Sión, na' bebégekle'. Bebégekle benne' ka' nníta'gake' yežlyó Judá, ni'a che da' bchi'a ḻažo'o Le', X̱anto' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Ẕente nako' Le', X̱anto' Dios, ḻawle dot yežlyó. Ẕenže nako' Le' ka yógo'te dios chegak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Nol-le ḻe'e nží'ilele X̱anžon', le ža'a da' ẕinnj. Ḻe' žape chi'e yeḻa' nban chegak benne' chie' ka'. Žeslé' ḻégake' ḻo na'gak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Yeḻa' baní' chie' zóaḻenen benne' chawe' ka', na' yeḻa' žebele chie' zóaḻenen benne' ḻi ḻaže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Le yebele ḻe'e, benne' chawe' ka', ḻaw X̱anžon'. Le wsá' ḻaže' da' ẕen da' ben Dios, na' le wká'n ẕen La la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Le goḻ che X̱anžon' to da' kob dan' bene' da' žonen ga žebanlžo. Ḻen yeḻa' waḻe chie', na' yeḻa' wak la'y chie' bzex̱jwe' benne' ka' ẕží'igake' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","X̱anžon' bzenle' benách ka' kan žeslé' ḻégake'. Bzenle' benne' yež ka' ka nak da' chawe' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Bene' da' bchebe ḻaže'e gone' chegak benne' Israel ka' ni'a che yeḻa' ḻi ḻaže', na' yeḻa' nži'il chie'. Yógo'te benách bḻé'egekle' da' ben Dios ni'a chežo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Le goḻ ḻen yeḻa' žebele ḻaw X̱anžon', ḻe'e zoale dot yežlyó nga. Le wká'n ẕene' Ḻe' ḻen da' goḻ-le. Ḻo yeḻa' žebele chele, le kwéžeya'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Le goḻ da' we ḻawle X̱anžon'. Le goḻ ḻen da' ka' žóḻ-ḻenle, da' ka' chinnle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Le wkwéž lozgak bia ka', na' yezika' da' ka' ẕgol-le, na' le kwéžeya'a ḻo yeḻa' žebele chele ḻaw X̱anžon', Bennen' ẕnna bi'e žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Le nne, nisdo', na' bia ka' zoale ga na'. Le goḻ, ḻe'e, yežlyó, na' ḻe'e zoale ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Le kapa' na'le, ḻe'e, yegw ka'. Le goḻ ḻo yeḻa' žebele, ḻe'e, ya'a ka', ḻaw X̱anžon', ");
INSERT INTO ztyNTps_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","dan' yide' yedjnná bi'e yežlyó nga. Nna bi'e benne' ka' nníta'gake' do ẕente yežlyó ḻen da' nak chawe', na' benách yógo'te yež ka' ḻen da' naken dot da' li. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Nak X̱anžo Dios Benne' Wnná Bia' Ẕen, na' žẕízegak yógo'te benne' ka' ni'a chie' Ḻe'. Ži'e latje blo chie' dan' zoan ḻáwlegak kerubín ka', na' žẕo' yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Ẕente nak X̱anžon' ḻaw Ya'a Sión. Nake' ẕen ḻáwlegak yógo'te yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Le wká'n ẕen La la'y che X̱anžon' da' naken ẕen, na' da' žaḻa' žébežo. La'y nake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Le', Benne' Wnná Bia' Ẕente, nži'ilo' da' nak chawe'. Bzoa chocho' da' naken dot da' li. Beno' da' naken chawe', na' da' naken dot da' li ni'a chegak ẕa'só Jakob ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","¡Le wká'n ẕen X̱anžo Dios! ¡Le wzóa ẕible ḻawe' Ḻe' gan ži'e ẕnna bi'e dan' nake' la'y! ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moisés, na' Aarón gókgake' bx̱oz chie' ka'. Samwel goke' to benne' bcháḻjḻene' Ḻe'. Wnnábgekle' X̱anžo Dios to, na' Ḻe' bechebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Bcháḻjḻene' benne' ka' to ḻo bejw gasj. Béngake' da' wnnakze' Ḻe', na' da' bchi'le' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Le', X̱anto' Dios, bechebo' chegak benne' ka'. Bḻoe'elo' ḻégake' nako' Dios, na' ženít ḻawo'o Le' chegak benne' ka', ḻa'kze žono' ga ẕzáka'gake' ni'a che doḻa' da' nbága'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","¡Le wká'n ẕen X̱anžo Dios! ¡Le wzóa ẕible ḻawe' Ḻe' ḻaw ya'a la'y chie', dan' la'y nak X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Le goḻ ḻaw X̱anžo Dios, ḻe'e zoale dot yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Le wká'n ẕen Ḻe' ḻen yeḻa' žebele chele. Le da ḻawe' Ḻe', žoḻ-le ḻen yeḻa' žebele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Batkle gaḻ ḻáže'le X̱anžon' nakkze' Dios. Ḻe' bene' žo'o, na' nakžo chekze' Ḻe'. Nakžo benách chie' ka', na' ẕíla'do' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Le cho'o yodo' chie', na' ye'le-ne': “Žóx̱keno'”, na' ḻo ẕchil chen, we ḻawle Ḻe'. Le yi'e: “Žóx̱keno'”, na' le wká'n ẕen La la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Chawe' nak X̱anžon' na' sóateze yeḻa' ži'i ḻaže' chie'. Yeḻa' ḻi ḻaže' chie' soan to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Góḻteza' kan zej nak yeḻa' ži'i ḻaže', na' yeḻa' ḻi ḻaže' chio'. Góḻteza' chio' Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Žak ḻaža'a gona' da' naken ḻi ḻaže'. ¿Batx̱ yido' gákḻeno' neda'? Dot ḻaža'a goḻkza' ḻo ližkza' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Batkle ko'o ḻaža'a gona' to da' ẕinnj. Bi ẕḻe'ela' chawe' da' žongak benne' ka' ẕbej yíchjgake' Dios. Batkle wa'a latje bíga'gake' gan zoa' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Wkwasa' ḻo yichj ḻáẕda'wa' da' ẕinnj, na' bi ko'o ḻaža'a gona' da' bi nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Wnnita'a cheḻa'ale benne' ka' ẕnnégake' chegak benne' yoble ka' bagáche'ze. Bi wa'a latje soaḻen neda' to benne' ẕka'n ẕen kwine', bennen' ẕži'e che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Ḻe'ela' chawe' benne' ka' zej nake' ḻi ḻaže' ḻaw Dios, nich gónḻengake' neda' tẕen. Benne' ka' zej nake' dot ḻaže' góngake' žin chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Bi wa'a latje no benne' žon ḻáže'le' choe'e liža'. Bi wa'a latje to benne' wen ḻaže' soe' gan zoa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Tža tža wnnita'a žize benne' wen da' ẕinnj ka', benne' ka' nníta'gake' ḻo yežlyó chia'. Wkwasa' yógo'te benne' wen da' ẕinnj ka' ḻo yež che X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","X̱ana' Dios, benle da' ẕnnabla' Le', na' bze nag da' žḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Bi wkache' ḻawo' Le' ḻawa' neda', dan' že' zedla'. Bze nag chia', na' bechebe chia' kate' žḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Nak yeḻa' nban chia' ka žen che yi' da' ẕnitlen. Yo'o da' ḻa ḻo žit chia' ka to yi' da' žáḻa'ḻe'en. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Žedó ḻaža'a, na' nak ḻáẕda'wa' ka to yix̱e' nkwaden, na' biž ẕnnan gawa' yet. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Dan' ẕbeže wé'ḻi'a ba nžítḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Naka' ka to lab ẕlaba' to ḻo yežlyó biž, na' ka to bedkoke žíaba' ḻawle to yo'o nyinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Žata'a yele, san bi ẕtasa'. Naka' ka to byinne žíaba' tozba' yichjo'o sibe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Tža tža ẕnne zí'tezgak benne' ka' bi ẕḻé'egekle' neda' chawe'. Benne' ka' ẕžá'agake' neda' ẕkóngekle' žin la' kate' ẕnne zí'gake' che no benne'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Kate' žawa' yet, naken ka žawa' de, na' nis ẕbeža' nchix̱en da' že'ja'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Ki žaken dan' ẕžo'o neda', na' žsaka' zi'o neda'. Bkwaso' neda', na' bžo'no' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Nak yeḻa' nban chia' ka to ẕoḻ da' ẕdezen, na' naka' ka to yix̱e' da' ba nbižen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Le', X̱ana' Dios, to chi'ize zo'. Chejsá' ḻáže'gak yógo'te benách ka' La la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Bezó ža', na' beyache' ḻaže'l benne' yež Sión ka', dan' ba bžin ža yenít ḻawo'o chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Neto', wen žin chio', nži'ilto' yej ka' che yežen'. Žékelto' zi' dan' nbia yin'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Benne' yógo'te yež ka' gápegake' La la'y chio' ba la'ne, X̱anto' Dios. Žébegak yógo'te benne' wnná bia' ka' yeḻa' ẕen chio', ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","kate' yechiso' yež Sión, X̱anto' Dios, na' ḻé'egekle' yeḻa' ẕen chen, ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","dan' wzé nago' da' ẕnnábgekle benne' ka' wléj yichjo' na' biž wzó' cheḻa'ale da' žáta'yoegekle' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Bzoj da' ni nich góḻgaken benne' ka' za' ḻá'gake', na' benne' ka' za' gáljgake' we ḻáwgake' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Gan zoa X̱anžon' ya'abá bwie'. Gan zoe' ya'abá bḻe'ele' yežlyó nga, ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","nich yenle' chegak benne' ka' ẕbeže nyáche'gake', benne' ka' zej nyejwe' liž ya, na' yeslé' benne' ka' ba nžog chégake' gátgake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","nich wzéngekle' benne' yež Sión ka' kan nak ẕen La la'y che X̱anžo Dios, nich we ḻáwgake' Ḻe' ḻo yež Jerusalén, ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","kate' ḻa'gak benách yógo'te yež ka', nich wká'n ẕéngake' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","X̱anžo Dios bzex̱jwe' yeḻa' waḻe chia', na' yeláte'ze ka bete' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Naž wnnía': “Dios chia', bi goto' neda', kate' bi na' gola'. Le' to chi'ize zo'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Ža ni'te bzo' yežlyó nga, na' ḻen no'o beno' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Kwia yi'gak da' ka', san sóatezo' Le'. Te chegak yógo'te da' ka' kan žeywé to laže'. Kan ẕcha'to' ẕato' žeza', wchó'o da' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","san bi ẕcha' kwino', na' batkle te chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Gape chi'o ẕi'nto' neto', benne' wen žin chio' ka', na' wzóa chochkzo' ẕa'sóto' ka' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","We ḻawa' X̱anžo Dios ḻen dot yichj ḻáẕda'wa'. We ḻawa' La la'y chie' ḻen dot da' naka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","We ḻawa' X̱anžon' ḻen dot yichj ḻáẕda'wa', na' bi gaḻ ḻaža'a da' chawe' da' bene' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ženít ḻawe' yógo'te doḻa' da' nbaga'a. Žeyone' neda' chegak yógo'te yižwé' ka' da' yoa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Žape chi'e neda' nich bi gata'. Ḻo yeḻa' ži'i ḻaže' chie', na' yeḻa' žeyache' ḻaže' chie' ẕka'n chawe'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Ẕzanḻi'e da' chawe' ka' da' žákgaken chia' nich yeyaka' ka to benne' yiz kwide', na' benne' waḻe kan žak che to bsia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","X̱anžo Dios ẕchi'a ḻaže'e da' žak chegak benne' ka' ẕzáka'ḻe'egake', na' ẕka'n chawe'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Bḻoe'ele' Moisés da' ka' wló'o ḻaže'e gone', na' bi'e latje benne' Israel ka' bḻé'egekle' da' ẕen ka' da' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","X̱anžon' žeyache' ḻáže'le', na' nži'ile' benách ka'. Nake' ẕen ḻaze', na' nží'iḻe'ele' benách chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Bi ẕtiḻkze' žo'o, na' kegé to chi'ize ẕže'e žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Bi žebi'e chežo ka nak ẕia da' nbága'žo, na' bi na' wžía yi'e žo'o ni'a che x̱tóḻa'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Ka nak sibe ya'abá ḻawle yežlyó, kikze nak yeḻa' ži'i ḻaže' ẕen chie' ḻen benne' ka' žápegake' Ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Ka nak zi'to' gan ẕḻa' wbíž, na' gan ženen, kikze ẕkwase' zíto'le doḻa' da' nbága'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Kan nak x̱a x̱kwide' ka' ži'i ḻaže' ḻen ẕi'nkze' ka', kikze nak X̱anžon' ži'i ḻaže' ḻen benne' ka' žápegake' Le' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Ḻe' nnézkzele' kan nakžo ḻo beḻa' žen chežo. Žejsá' ḻaže'e nakžo bix̱te yo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Ka nak yeḻa' nban chežo, nakžo ka to yix̱e'. Ẕgolžo ka žak che to yeje yix̱e'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Kate' ẕde be' ga na', na' ẕnitlen, na' biž zoa no benne' žejsá' ḻaže'e chen, ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","san ka nak chegak benne' ka' žx̱en ḻáže'gake' X̱anžon', yeḻa' ži'i ḻaže' chie' zóaḻenen ḻégake' to chi'ize, na' da' chawe' chie' zóaḻenkzen yógo'te ẕa'sógake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","benne' ka' žóntezgake' kan ẕnna diža' dan' bénḻene' ḻégake', na' benne' ka' žóngake' kan wnnakze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Bzoa X̱anžon' latje chie' ya'abá gan ži'e ẕnna bi'e. Nakkze' Benne' Wnná Bia' Ẕen ḻáwlegak da' zej den. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Le wká'n ẕen X̱anžon', ḻe'e, wbás che ya'abá ka'. Nakle wbás waḻe, na' chochḻe'e, na' žonle kan ẕnne', na' ẕze nagle da' ži'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Le wká'n ẕen X̱anžon', ḻe'e, wbás che ya'abá ka' žejle ḻo wdiḻe. Nakle wbás wen žin chie' ka', na' žonle kan žénele' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Le wká'n ẕen X̱anžon', yógo'tele ḻe'e, ben Dios ḻe'e, na' zoale yógo'te latje gan ẕnna bi'e Ḻe'. We ḻawa' X̱anžon' ḻen dot yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","We ḻawa' X̱anžo Dios ḻen dot yichj ḻáẕda'wa'. Ẕente nako' Le', X̱ana' Dios. Laže' da' nako' naken yeḻa' x̱tan, na' yeḻa' ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ẕwakw kwino' yeḻa' baní' ka ẕa lano'. Bzaḻo'o ya'abá ka to yo'o laže' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Beno' ližo' ḻawle nis da' žen' ža'le. Ẕkonlo' žin bejw ka' ka to karreta gan ži'o Le', dan' ẕden ḻo be'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Ẕkonlo' žin be' žaken ka wbás chio', na' yes wzió' ka' ka wen žin chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Bzoa chocho' yežlyó nga ḻo lenen, na' bi be gak wkwasen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Bwako' yežlyó nga ḻen nisdo' ka žon to benne' žakwe' ẕa lane', na' nisen' bwakwn ya'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Kate' btiḻo' nisen', na' beẕonnjen. Bebigan' kate' benlen wnnó' zižje. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Nisen' dan' bwakwn ya'a ka' bejsóan ḻo yegw ka', na' bžinen latjen' da' beno' Le' che nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Bzo' gan ze ḻaw chejsóan, na' gan biž gak ten, nich biž yewakwn yežlyó bižen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Beno' bej ka', da' ka' žáljgaken žoa'a yégodo' ka', na' yegw ka' ẕdégaken ládjwgak ya'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Ḻo yegw ka' že'jgak bia yix̱e' ka' nis, na' ẕdoan yeḻa' ẕbiḻe nis chegak burro yix̱e' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Byínnedo' ka' žóngakba' x̱ó'ngakba' ka' ḻo yag ka' zégaken žoa'a yegw ka', na' žóḻgakba' ládjwgak ni'a ná'gaken ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Žseḻo'o yejw ẕan ya'abá dan' žaken ḻaw ya'a ka', na' želje yežlyón' ḻen da' chawe' da' žono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Žesgolo' yix̱e' da' žawgak bia yix̱e' ka', na' kwando' ka', da' ka' žawgak benách ka', na' da' ka' ẕkóngekle benne' ka' žin nich góngake' yeḻa' waw, ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","na' uba ka', da' ka' žóngake' x̱is uba waḻ dan' žonen ga žebégekle benne' ka', na' olibo ka', da' ka' žóngake' set dan' ẕgó'ogake' yíchjgake', na' ẕoa' da' žóngake' yet nich sóagake' nbángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Yag sedro ka' da' zej zen ḻaw Ya'a Líbano ẕzí'gaken nis yejw. Zej naken chio', X̱anto' Dios, dan' gozo' ḻégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Ḻo yag ka' žẕíagak byínnedo' ka' x̱ó'ngakba' ka', na' ḻo ni'a ná'gaken že'gak liž byinne sigwenya ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Zej zoa chibo yix̱e' ka' ḻaw ya'a ẕen ka', na' ḻo bloj ka' ẕangak ya'a ka' zej zoa bẕižo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Beno' byo' dan' ẕḻoe'elen to byo' to byo' che yiz, na' wbíž nnezlen kate' žaḻa' yenen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Beno' yel, na' kate' ba goḻen, na' ẕžojgak bia yix̱e' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Ẕbéžeya'agak bež yix̱e' ka', žíljgakba' da' gáwgakba'. Žíljgakba' bia ka' wnnakzo' gáwgakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Kate' ẕḻa' wbíž, na' žeyéjgakba' ḻo bloj chégakba', gan ẕtásgakba' te ža. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Naž ẕžojgak benne' ka', na' žjake' wen žin, na' žóngake' žin na' zejte žen wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","X̱anto' Dios, da' zante zej nak da' beno'. Ḻen yeḻa' žejní'il ẕente chio' beno' da' ka'. Nža' yežlyó nga da' ka' beno' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Zoa nisdo' ga na', dan' naken ẕen, na' zil-ḻe'e, gan zej yo'o bia zante ka', biado' ka', na' bia ẕen ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Ḻo nisdon' zej nnita' barkw ẕen ka', na' zoa bia ẕen ḻo nisdon', bian' beno' Le', nzi' laba' lebiatán. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Yógo'te bia ka' žx̱en ḻáže'gakba' Le', nich gonno' da' gáwgakba' kate' gaḻa' chégakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Ẕneẕjon' chégakba', na' ẕzí'gakban'. Žónnḻi'o da' žáwgakba', na' žéljgeklba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Kate' bi žape chi'o ḻégakba', na' ẕžébegakba'. Kate' žekwaso' be' žeká'gakba', na' žátgakba', na' žeyákgakba' bix̱te yo, ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","san kate' žeseḻo'o be' chio', na' žebángakba'. Ẕneẕjo' yeḻa' nban kob chegak da' ka' zej zoan ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","To chi'ize ga'n ẕen X̱anžo Dios. Žaz ḻaže' X̱anžon' da' ka' benkze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ẕwie' yežlyó nga, na' žẕon'. Ẕgane' ya'a ka', na' ẕžoj žen che yi' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Goḻkza' che X̱anžon' x̱ak zoa' nbana'. Yógo'te ža zoa' nbana' goḻa' da' we ḻawa'a Dios chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Žak ḻaža'a chaz ḻaže' X̱anžon' da' ka' ẕlab ḻaža'a, na' žebézela' ni'a che X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Kwia yi'gak benne' doḻa' ka' nníta'gake' yežlyó nga, na' biž soagak benne' ka' ẕbej yíchjgake' Dios. We ḻawa' X̱anžo Dios ḻen dot da' naka'. ¡Ga'n ẕen X̱anžon'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","¡Le wká'n ẕen X̱anžo Dios! ¡Le wká'n ẕen La la'y chie'! Le wzenle benne' yógo'te yež ka nak da' ẕen da' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","¡Le goḻ chie'! ¡Le goḻ da' wká'n ẕenle Ḻe'! ¡Le wcháḻj chegak da' ẕente ka' da' bene'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","¡Le yebele ḻo da' nak chie' Ḻe'! Yógo'te benne' ka', benne' žápegak X̱anžon' ba la'ne, žaḻa' yebéḻe'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Le nnable X̱anžon' gákḻene' ḻe'e. Tža tža le wx̱én ḻaže' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Ḻe'e, ẕa'só Bran, wen žin che X̱anžon', na' ḻe'e, ẕa'só Jakob, bennen' wžíe', le wsá' ḻaže' chegak yeḻa' wak ka', na' da' ẕente ka' da' bene' Ḻe', na' kan bchi'a ḻaže'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Ḻe' nake' X̱anžon', na' Dios chežo. Ḻe' ẕnna bi'e benne' ka' nníta'gake' dot yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Ḻa'kze te chegak to mil kwe' benne' ka', batkle gaḻ ḻaže'e da' wchebe ḻaže'e gone' ḻo diža' da' bene', ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","dižan' da' bénlene' Bran, dan' bzetj kwine' katen' bi da' bchebe ḻaže'e gone' che Isaak, ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","na' bzoa chochen' ka to da' wnnakze' gon Jakob, dižan' da' žaḻa' góntezegak benne' Israel ka' ka ẕnnan, ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","dan' bene' katen' wnné': “Chele ḻe'e gonna' yežlyó chegak benne' Kanaán ka', dan' gaken to da' wdele ḻo na'gak ẕa'sóle ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Katen' wnníta'gake' nbabze benne' ka', na' wdágake' ḻo yežlyó nga ka benne' zi'to' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","na' wdégake' to yež yetó yež, na' to yežlyó yetó yežlyó, ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","bi be' Dios latje no benne' bi da' gone' chegak benách chie' ka', na' ni'a chégake' btiḻe' benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Gože' ḻégake': “Bi be gonle chegak benne' ka' wžía', na' bi gonle ẕia benne' ka' ẕcháḻjgake' ḻo wlaza' neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Bene' ga gota' to wbín ḻo yežlyón', na' beké'e yógo'te da' gáwgake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","san bseḻe'e to benne' wnežwe' ḻáwgake', bennen' nake' Jwsé, bi' na' béte'gake'-be' nich gakbe' bi' ndo'w che to benne' zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Bséjwgake' ní'abe' ḻo yežw ka' ladjw blag ka', katen' bséjwgake'-be' liž ya ḻo yežlyó Egipto, ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","na' zejte goḻa' gok li da' wnná Jwsé žaḻa' gaken. Ki goken, bḻoe'el x̱tiža' X̱anžon' wnnabe' da' li. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Naž benne' wnná bia' che yežlyó Egipton' bseḻe'e to benne' bsane' Jwsé na'. Bennen' ẕnna bi'e yež zan bsane'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Bzoe'-be' nich gakbe' x̱angak benne' ka' nníta'gake' liže', na' nich nna bia'be' yógo'te da' nape' ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","na' nich tiḻbe' benne' ẕen ka' che benne' wnná bian' ka žaz ḻáže'kzbe', na' nich wzejni'ilbe' benne' gole ka' che yežlyó Egipton' nich gákgake' benne' sina' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Wdé na' bžingak benne' Israel ka' ḻo yežlyó Egipton', na' wzóa Jakob ḻo yežlyó chegak ẕa'só Kam ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Wyánḻe'egak benne' ka' che X̱anžon' ḻo yežlyón', na' bene' ga gókgakže' waḻe ka zej nak benne' ka' bi bḻé'egekle' ḻégake' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Ben Dios ga bža'agak benne' Egipto benne' chie' ka', na' béngake' benne' wen žin chie' ka' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Bseḻe'e Moisés, wen žin chie', ḻawgak benách chie' ka' tẕen ḻen Aarón, bennen' wžíe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Dios bi'e benne' chope' ki latje béngake' yeḻa' wak ka' che ya'abá, na' yeḻa' wak ẕen ka' ḻo yežlyó chegak ẕa'só Kam ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Bseḻa' Dios to da' choḻ dan' bwakwn dot yežlyón', san benne' Egipto ka' bi béngake' da' wnnakze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Naž bene' ga beyák nis yegw chegak benne' ka' žen, na' bete' yógo'te bel ka' zej zoaba' ḻo yegw ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Besché'e yežlyó chégake' blož ka' ga bžinte wnníta'gakba' ḻo liž benne' wnná bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Wnnaze Dios, na' bḻa'gak zante bi'a che bež ka', na' bi'a las ka' dot ḻo yežlyó chegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Ḻo wláz nis yejw bseḻe'e yej nis ḻo yežlyón', na' ḻezka' yi' da' bzeyen dot yežlyó chégaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Bchinnje' yógo'te lba uba, na' yag higo chégake' ka', na' bdichje' yógo'te yag ka' zej zen ḻo yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Wnnaze', na' bḻa'gak biche' zo ka', bia ka' bi gak no benne' wlabe' ḻégakba', ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","na' bdáwgakba' dot yix̱e' ya'a ḻo yežlyó chégaken', na' bdáwgakba' dot linne da' žonn yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Naž bete' bi' byo nežw ka' chegak benne' Egipto ka', x̱kwide' ka' zej nakbe' bi' wak ka' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Bebeje' benne' chie' ka' ga na' zej noe'e mežw plat, na' mežw oro zan. Bi wzóa no benne' ládjwgake', benne' bi zoe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Bebégekle benne' Egipto ka' katen' bžójgake' ga na', dan' bžébeḻe'egake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Bzaḻa' Dios to bejw da' wló'on benne' chie' ka' ẕoḻ, na' to yi' da' bsa'nín' ḻégake' žel. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Wnnábgekle' Dios, na' bseḻe'e bežjw yix̱e' ka' nich gáwgake'-ba', na' bene' ga béljegekle' yet da' bžojen ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Bsaljwe' to yej x̱e, na' bžoj nis da' wdén ḻo yežlyó bižen' ka to yegw nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Ki ben Dios dan' bejsá' ḻaže'e diža' la'y chie' da' bchebe ḻaže'e gone' che Bran, wen žin chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Bebeje' benne' ka' wžíe' ḻo yežlyó Egipton', na' bebégekle' dan' gok yeḻa' ba nez ẕen chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Bneẕjwe' benne' chie' ka' yežlyó chegak benne' yezika' yež ka', na' da' wdápegak benne' yež ka' beyaken chegak benne' chie' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","nich gápegake' x̱tiže'e ba la'ne, na' góngake' ka nak da' wnnakze' Ḻe'. ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","¡Ga'n ẕen X̱anžo Dios! Le ye' X̱anžo Dios: “Žóx̱keno'”, dan' nake' chawe', na' dan' žeyache' ḻáže'tezle' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","¿Noẕkze benne' gak wḻoe'ele' kan zej nak yeḻa' wak ẕente ka' da' ben X̱anžon'? ¿Noẕkze benne' gak wká'n ẕene' Ḻe' kan žaḻa' gonžo? ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Ba nez ẕen naken chegak benne' ka' žóngake' da' chawe', benne' ka' žóntezgake' da' žénele' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Bejsá' ḻaže' chia', X̱ana' Dios, kate' žon chawo'o benne' chio' ka'. Da yesló' neda', nich gak ḻe'ela' ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","da' chawe' da' gono' ni'a chegak benne' ka' wžío' Le', na' nich yebela' kate' gak chegak benne' chio' ka' yeḻa' ba nez, na' nich yebéḻenla' benách chio' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Bento' doḻa' tḻebe kan bengak x̱a x̱na' wdé cheto' ka'. Bento' da' ẕinnj, na' bento' da' bi naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Kate' wnníta'gak x̱a x̱na' wdé cheto' ka' ḻo yežlyó Egipton', bi blab ḻáže'gake' chegak yeḻa' wak che ya'abá ka' da' beno' Le'. Bi bejsá' ḻáže'gake' ka beyache' ḻáže'ḻe'elo' ḻégake', san bží'igake' chio' žoa'a nisdon' nzin' Nisdo' X̱na. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","San Dios beslé' benách chie' ka' nich ga'n ẕen La la'y chie', na' nich wḻoe'ele' ḻaw ka nak yeḻa' wak chie' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Btiḻe' Nisdo' X̱na na', na' bebižen. Wdegak benách chie' ka' gachje ḻawle nisdon' ḻo yo biž. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Beslé' benách chie' ka' ḻo na'gak benne' ka' bi bḻé'egekle' ḻégake' chawe', na' bebeje' ḻégake' ḻo na'gak benne' ka' bsaka' zí'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Naž nisdon' bwakwn benne' ka' bi bḻé'egekle' ḻégake' chawe'. Bi bga'n nitó benne' chegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Naž benne' chie' ka' bejḻé'gake' x̱tiža' Dios, na' béḻgake' da' be ḻáwgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Ka' gaze goḻ ḻáže'gake' da' ka' bene'. Bi wlézgake' nich ḻé'egekle' da' gon Dios, ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","san wzé ḻáže'gake' to da' ẕinnj ḻo latje dachen', na' béngake' ga bža'a Dios ḻe'e yix̱en'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Wdé na' bneẕjw Dios da' wnnábgekle' Ḻe', san bseḻe'e ládjwgake' to da' beten zángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Bgé'egekle' Moisés gan wnníta'gake', na' ḻezka' Aarón, Bennen' wžé X̱anžo Dios na'kze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Naž wyaljw yežlyón', na' bwakwn Datán, na' ḻezka' benne' ka' bénḻengake' Abiram tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Naž wẕén yi' gan zej ndobe benách chie' ka', dan' bzeyen benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Béngake' to lo'a ẕan Ya'a Horeb da' goken to bež da' naken ya oro, na' bzoa ẕíbgake' ḻaw lo'a oro na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Ki bebéj yíchjgake' Dios, Bennen' zoe' ya'abá, nich wká'n ẕéngake' to lo'a oro, da' naken ka to bež žawba' yix̱e'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Goḻ ḻáže'gake' Dios, Bennen' beslé' ḻégake', Bennen' bene' yeḻa' wak ẕente ka' ḻo yežlyó Egipton', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","na' bene' yeḻa' wak ka' che ya'abá ḻo yežlyó chegak ẕa'só Kam ka', na' da' ka' ẕchébegaken žo'o žoa'a Nisdo' X̱na. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Naž gok ḻaže' Dios wžía yi'e benne' chie' ka', san Moisés, bennen' wžé Dios, bzoa kwine' ḻaw Dios nich wzóa žie' yeḻa' ẕža'a che Dios, na' bene' ga bi wžía yi' Dios benne' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","san bzóagake' cheḻa'ale yežlyó x̱tanḻe'e dan' gónele Dios wneẕjwe' ḻégake', na' bi bejḻé'gake' x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Wnnétezgake' che Dios ḻo yo'o laže' chégake' ka', na' bi bze nággake' da' wnná X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Che ḻen bzetj kwine' gone' benne' ka' ẕia, gone' ga gatgak benne' ka' ḻo latje dachen', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","na' gone' ga yedoé'egekle benách chie' ka' ḻawgak benne' ka' wnníta'gake' yežlyón', na' yeslase' ḻégake' ladjw benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Naž béngake' toze diža' ḻen benne' ka' ẕka'n ẕéngake' lo'a dan' nzin' Baal-peor. Bdáwgake' biado' ka' bétgake' ḻawgak dios gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Béngake' ga bža'a Dios ni'a che da' béngake', na' bḻa' to yižwé' ẕen da' beten zangak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Naž wzó ža' Finées, to bx̱oz, na' bete' to benne' ne žone' doḻa', na' wžé' ži yižwé' ẕen na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Dan' ben Finées wẕí' Dios ka to da' žeyón chawen' benne' ka', dan' wḻoé'e ḻawn ḻawgak yógo'te kwe' benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Ḻezka' béngake' ga bža'a Dios žoa'a bej nis da' nzin' Meribá, na' bi gok chawe' che Moisés ni'a che dan' béngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Ni'a che dan' béngake' gok Moisés yichj ža'a, na' wdetle ben Moisés da' kegle. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Kate' wyó'ogake' ḻo yežlyó nga bi bchínnjgake' yež ka', kan bchi'le Dios ḻégake' góngake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","san bénḻengake' benne' yež ka' tẕen, na' bsédgekle' góngake' ka žongak benne' yež ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","na' bka'n ẕéngake' lo'a ka' chegak benne' ka', dan' benen ga bžia yi' Dios benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Bétgake' bi' byodo' ka', na' bi' no'le chégake' ka' ḻawgak lo'a chegak be' x̱iwe' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","na' bláljgake' žen chegak bi' že'ndo' ka', bi' ka' bi na' góngakbe' doḻa', bi' ka' bétgake' ḻawgak lo'a ka' chegak benne' Kanaán ka', na' gok sban yežlyón' ni'a che žen chegak x̱kwide' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Da' ka' béngake' bka'ngaken ḻégake' sban, na' wléj yíchjgake' Dios ḻen da' béngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Che ḻen bžá'aḻe'e Dios benách chie' ka', na' bi bḻe'ele' chawe' benne' ka' zej nake' chekze'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Naž bdie' benne' chie' ka' ḻo na'gak benne' yež ka', na' benne' ka' ẕžá'agake' benách ka' che Dios wnná biá'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Benne' ka' bi ẕḻé'egekle' ḻégake' chawe' bsaka' zí'gake' benách ka' che Dios. Bzéx̱jwgake' ḻégake' ḻo yeḻa' wnná bia' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Zante chi'i Dios beslé' benách chie' ka' san bží'igake' che da' ka' gože' ḻégake', na' wbága'gake' doḻa' dan' béngake' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Ḻa'kze ki béngake', kate' wžé' zédgekle', Dios bwie' da' wẕáka'gake', na' benle' che da' bḻížgake' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","na' bejsá' ḻaže'e dižan' da' bénlene' benne' ka', na' beyát ḻaže'e che yeḻa' ẕža'a chie' dan' ẕente nak yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Ḻezka' bene' ga beyache' ḻáže'gekle benne' ka' benách chie' ka', benne' ka' bché'gake' ḻégake' zej nžeje'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Beslá neto', X̱anto' Dios. Bebéj neto' ladjw benne' zi'to' ka', nich wká'n ẕento' La la'y chio' Le', na' nich yebéḻe'elto' ḻo da' žoḻto' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","¡Ga'n ẕen X̱anžon', Bennen' nake' Dios chegak benne' Israel ka', ža ni'te, na' to chi'ize! Yógo'te benne' ka' žaḻa' nnágake': “Ka'kze gaken.” ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","¡Le wká'n ẕen X̱anžon', dan' nake' Benne' chawe'! ¡To chi'ize nake' Benne' ži'i ḻaže'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Da' ni žaḻa' nnagak benne' ka' ba beya'w X̱anžon', benne' ka' beslé' ḻo na'gak benne' ka' bi ẕḻé'egekle' ḻégake' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Bebeje' ḻégake' ládjwgak benne' yež zi'to' ka', yež ka' zej žen' gan ẕḻa' wbíž, na' gan ženen, na' gan za' be' zag, na' gan ẕde wbíž byo' zag ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Baḻ benne' ka' wdágake' ḻe'e yix̱e' gan bi zoa nez, na' bi bžéḻgekle' yež gan sóagake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Wdóngake', na' wbíḻgake', na' biž wzóa da' wx̱én ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Naž ḻo da' wẕáka'gake' bḻížgake' X̱anžon', na' beslé' ḻégake' ḻo da' wẕáka'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Bnnite'e ḻégake' to nez ḻi, nich chjake' to yež gan sóagake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Žaḻa' we ḻáwgake' X̱anžon' dan' beyache' ḻáže'le' ḻégake'. Bene' chégake' da' ka' žóngaken ga žebánležo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Ẕwe'je' benne' ka' ẕbíḻgake', na' ẕwawe' benne' ka' ẕdóngake' nich sí'gake' da' chawe' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Baḻ benne' ka' wnníta'gake' ḻo da' choḻ, na' gan gok ẕož gátgake'. Gókgake' ka benne' zej nyejwe' liž ya gan zej nžeje' do ya, na' ẕzáka'ḻe'egake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","dan' bží'igake' che x̱tiža' X̱anžon', na' bzóagake' cheḻa'ale da' bzejní'il Dios ẕente ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Bedó ḻáže'gake' ḻo žin zi'iḻe'e da' béngake'. Bchégwgake' ẕan ywa' da' zej noe'e, na' bi wzóa no benne' gákḻene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Naž ḻo da' wẕáka'gake' bḻížgake' X̱anžon', na' beslé' ḻégake' ḻo da' wẕáka'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Naž bebeje' benne' ka' ḻo da' choḻ, na' gan gok ẕož gátgake, na' bzoẕje' do ya ka' da' zej nžeje'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Žaḻa' we ḻáwgake' X̱anžon' dan' beyache' ḻáže'le' ḻégake'. Bene' chégake' da' ka' žóngaken ga žebánležo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Bchinnje' dan' bséjwgaken benne' ka' da' zej naken ya bronse, na' bzoẕje' bar ya ka' da' byéchjgeklen ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Baḻ benne' ka' wdá'gake' yižwé' ka', na' wẕáka'gake' ni'a che doḻa' wbága'gake', na' ni'a che da' ẕinnj ka' da' béngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Bgótgekle' da' že'j žáwgake', na' wzóagake' gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Naž ḻo da' wẕáka'gake' bḻížgake' X̱anžon', na' beslé' ḻégake' ḻo da' wẕáka'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Ḻe' bseḻe'e x̱tiže'e chegak benne' ka', na' beyone' ḻégake', na' beslé' ḻégake' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Žaḻa' we ḻáwgake' X̱anžon' dan' beyache' ḻáže'le' ḻégake'. Bene' chégake' da' ka' žóngaken ga žebánležo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Žaḻa' yé'gake' Ḻe': “Žóx̱keno'”, na' gótgake' bia beždo' ka' ḻawe' Ḻe', na' ḻo yeḻa' žebele chégake' žaḻa' góḻgake', na' wzéngekle' benách ka' kan nak da' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Baḻ benne' ka' wdégake' ḻo nisdo' ḻo barkw ẕen ka', benne' ka' žóngake' žin ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Bḻé'egekle' da' ẕen ka' da' žon X̱anžon', da' ka' žone' ḻo nisdo', da' žóngaken ga žebánležo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Wnnaze X̱anžon', na' wzó ḻaw žak be' bdone', na' wyás nis ẕgó'nḻe'en ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Wžengak barkw ka' ka ḻaw ya'a ẕen da' naken nisdo', na' bedínngaken ḻo da' naken gže'l ḻaw nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Bejchégwgake' na' bejlétgake' nile bejlétgake' na'le kan žongak benne' ka' želzožle', na' da' zej nsedle' bi gókḻenen ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Naž ḻo da' wẕáka'gake' bḻížgake' X̱anžon', na' beslé' ḻégake' ḻo da' wẕáka'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Ḻe' bzoa žie' be' bdone' dan' žaken, na' wžé' ži nis da' ẕgo'nen che nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Bebéḻe'egekle' dan' bga'n ži nis ẕgo'nen, na' Dios bchi'e ḻégake' dot chawe' gan zjake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Žaḻa' we ḻáwgake' X̱anžon' dan' beyache' ḻáže'le' ḻégake'. Bene' chégake' da' ka' žóngaken ga žebánležo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Žaḻa' wzéngekle' benne' ka' zej ndobe' chie' Ḻe' ka nak yeḻa' ẕen chie', na' we ḻáwgake' Ḻe' gan zej ndobe benne' gole ka', benne' ẕnna biá'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Ben X̱anžon' ga wbižgak yegw nis ka', na' bsejwe' bej nis ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Gan goc yo ya'a beyonen' yo biž, ni'a che da' bi nak chawe' da' bengak benne' ka' wnníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Gan nak yo biž beyonen' yo nis, na' yo yej beyonen' gan žaḻ nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Bnnite'e benne' ka' ga na', benne' wdóngake', na' béngake' to yež gan sóagake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Gózgake' yežlyón' na' bedá'gake' lba uba ka' ga na', na' bezí'ḻe'egake' linne chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Dios ben chawe'e benne' ka', na' wyánḻe'egak x̱kwide' chégake' ka', na' bene' ga bgóleḻe'egak bia yix̱e' chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Kate' benne' wnná bia' ka' bsaka' zí'gake' benne' ka', na' wdetlen wnná biá'gake' ḻégake', na' béngake' ḻégake' da' ẕia, ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","bka'n Dios benne' wnná bia' ka' ka'ze, na' bene' ga wdágake' ḻe'e latje dach gan bi zoa nez. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Beslé' benne' yache' ka' ḻo yeḻa' yache' chégake', na' bzánḻi'e ẕi'ngak benne' ka' ka žangak ẕila' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Kate' bḻé'egekle benne' chawe' ka' da' ki, na' bebéḻe'egekle', san benne' wen da' ẕinnj ka' bi be gok nnágake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Benne' sina' ka' žaḻa' wláb ḻáže'gake' che da' ki, na' žaḻa' yeyónbia'gake' ka nak yeḻa' ži'i ḻaže' ẕen che X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Zoakze ḻáẕda'wa', Dios. Zoakze ḻáẕda'wa' nich goḻkza' da' we ḻawa' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Bebán, be' da' nakkza', na' le yebán, ḻe'e ẕgoḻ-le da' žóḻ-ḻento' ka', na' arpa ka'. Zildo' yebankza'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Wká'n ẕenkza' Le' ladjw benne' chio' ka', X̱ana' Dios. Goḻkza' chio' ḻawgak benne' yógo'te yež ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","dan' yeḻa' žeyache' ḻaže' chio' nakžen ẕen ka ya'abá, na' da' li chio' nakžen ẕen ka bejw gasj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","¡Ga'n ẕenkzo' ya'abá, Dios! ¡Yeḻa' ẕen chio' ẕḻa' ḻawn dot yežlyó nga ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","nich lagak benne' ka' nži'ikzlo' Le'! Beslá ḻégake' ḻen yeḻa' wak chio', na' bechebe chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Ḻo latje la'y chie' wnná Dios: “Yebekzla' neda'. Chisa' chele yežlyó chegak benne' Sikem ka', na' wžix̱a' chele yežlyó da' žen' kwit yegw Sukot. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Yežlyó Galaad naken chia', na' yežlyó chegak ẕa'só Manasés. Yežlyó chegak ẕa'só Efraín naken ka to ḻapa' da' žape chi'in yichja'. Yežlyó chegak ẕa'só Judá naken gan ẕnna bi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Yežlyó chegak benne' Moab ka' naken ka to ẕiga' ya da' nžan' nis wná'a. Ḻo yežlyó chegak benne' Edom ka' cho'na' ẕela' gol. Si'a ba nez yežlyó chegak benne' Filistea ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","¿Noẕ benne' wchi'e neda' nich tíḻ-ḻena' yež zoa to ze'e sibe da' žape chi'in? ¿Noẕ benne' wchi'e neda' nich tíḻ-ḻena' benne' Edom ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","¿Kege Le' wchi'o neda', Dios? Le' bzoakzo' neto' cheḻa'ale, na' bi wyéjḻeno' benne' cheto' ka', benne' ka' žjake' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Gokḻen neto' nich gak tíḻ-ḻento' benne' ka' ẕdíḻ-ḻengake' neto', dan' dáche'ze gak gákḻengak benne' ka' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","To ẕen ḻen Dios gonžo to da' ẕenḻe'e, na' Ḻe' wlage' benne' ka' ẕdíḻ-ḻengake' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","X̱ana' Dios, ẕka'n ẕena' Le'. Bi ga'no' žize, ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","dan' benne' ka' bi zej nake' chawe', na' benne' wen ḻaže' ka', ẕnnégake' chia' neda'. Ẕnnégake' chia' da' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Ḻo yeḻa' ẕža'a chégake' zej nyechjle' neda', na' ẕnnégake' chia'. Ẕdíḻ-ḻengake' neda', na' bi be bena' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ḻa'kze bži'ila' benne' ka', na'a žéchjgekle' neda', na' ẕdíḻ-ḻengake' neda', san neda' ẕnnabla' Le' gon chawo'o benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Ḻa'kze bena' neda' da' chawe' chegak benne' ka', žóngake' neda' ẕia. Ḻa'kze bži'ila' ḻégake' bi ẕḻé'egekle' neda' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Bzoa to benne' wen da' ẕinnj nich wchi'a ḻaže'e benne' ka' bi zej nake' chawe', na' ben ga soa to benne' wži'e chégake', bennen' wḻoe'ele' ḻaw ẕia da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Katen' wchi'a ḻaže'e ḻégake', ben ga gak bia' ẕia da' zej nbage'e. Bḻoe'el naken doḻa' da' ẕnnábgake' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ben ga gakgak nbabze ža sóagake' nbángake', na' benn che benne' yoble da' wdápegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Bka'n ẕí'ngake' ka' bi' wzebe ka', na' ga'ngak ẕó'legake' no'le wzebe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Ben ga gakgak ẕí'ngake' ka' benne' ẕdágakze' nich nnábgekle' no benne' bi da' gonne' chégake', na' ben ga žéḻgake' yet da' gáwgake' zíto'le gan zoa lížgake' da' nbia yin'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ben ga cho'o da' nápegake' ḻo na' bennen' bsane' ḻégake' mežw. Ben ga yeka'gak benne' zi'to' ka' da' ka' béngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Ben ga bi soa no benne' yeyache' ḻáže'le' ḻégake', na' bi soa no benne' yeyache' ḻáže'le' bi' wzebe chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Ben ga kwia yi'gak ẕa'sógake' ka', na' biž soa no ẕa'sógake', bin' labe' kan légake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Bejsá' ḻaže' che da' ẕinnj da' bengak x̱a x̱tó'gake', X̱ana' Dios, na' bi wsoḻo' doḻa' da' wbága'gak x̱ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Bejsá' ḻáže'teze da' ẕinnj da' béngake', san biž chejsá' ḻažo'o benne' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","dan' bi bejsá' ḻáže'gake' yeyache' ḻáže'gekle' ljéžgake' ka'. Bsáka'gake' benne' yache' ka', na' benne' gax̱jw ka', na' benne' ka' wẕáka'gake', na' bétgake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Wyáz ḻáže'gake' wnnégake' chegak benách ka'. Ben ga nnégak benách ka' chégake'. Bi gok ḻáže'gake' nnábgake' gak chawe' chégake'. Ben ga bi soa no benne' nnable' gak chawe' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Da' ẕia da' žóngake' naken ka to da' žákwgake', dan' wyó'on ḻé'egake' ka nis da' wé'jgake', na' wyó'on žit chégake' ka set da' bdáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Ben ga tá'tezen ḻégake' ka to laže' yicha' da' nákwgake', na' ka to x̱páygake' da' nžejen ḻí'agake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Da' ni gaken chégake' to da' yebí'i X̱anžo Dios chegak benne' ka' ẕdíḻ-ḻengake' neda', na' da' chiẕjwe' benne' ka' ẕnnégake' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","X̱ana' Dios, gokḻen neda' nich gak chia' da' chawe'. Beslá neda' dan' žeyache' ḻáže'ḻe'e'lo' benách ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","na' dan' ẕzáka'ḻi'a, na' žiážjela', na' žak zi' ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Ẕde chia' kan ẕde che to ẕoḻ kate' žen wbíž. Žak chia' kan žak che to biche' zo katen' ẕche' to be' ḻeba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Žat ẕiba' dan' žona' wbás, na' nžítḻi'a dan' bi be žawa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Naka' ka to da' žon dítjgekle'. Ẕwíagake' neda', na' ẕta yíchjgake' nich gon dítjgekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Gokḻen neda', X̱ana' Dios. Beslá neda' dan' žeyache' ḻáže'lo' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ben ga gákbe'egekle' Le' žákḻeno' neda', na' Le', X̱ana' Dios, benkzo' da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Bi be žéke'la' cha' ẕnnégake' chia', cha' Le' žon chawo'o neda'. Wzó ža', na' ben ga yedoé'egekle benne' ka' bi ẕḻé'egekle' neda' chawe', san ben ga yebela' neda', benne' wen žin chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Ben ga yedoé'egekle benne' ka' ẕdíḻ-ḻengake' neda', na' ben ga chíx̱gekle' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Dot ḻaža'a goḻkza' da' we ḻáwḻi'a X̱anžo Dios. Wká'n ẕena' Ḻe' ládjwgak benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Ḻe' zoe' kwit ḻi ža chegak benne' yache' ka', nich yeslé' be' da' zej nakkze' ḻo na'gak benne' ka' ẕchóggake' chégake' gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","X̱anžo Dios gože' X̱ana': “Wžé' kwita' ḻi ža gan ži'a neda', na' zejte ža gona' ga benne' ka' bi ẕḻé'egekle' Le' chawe' wzóa ẕíbgake' x̱ni'o.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Gan zo' yež Sión, gonn X̱anžon' yeḻa' wnná bia' chio'. Ẕnne': “Wnná bia' benne' ka' ẕdíḻ-ḻengake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ḻo ža kate' wzetjo' benne' ka' bi ẕḻé'egekle' ḻe' chawe', dot ḻáže'gak benne' chio' ka' wdé kwíngake' ḻo no'o, ka žon x̱le'l zílele, da' žakwn ya'a la'y chia' ka'. Kikze yeyák yiz kwide' chio' tža tža.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Bchebe ḻaže' X̱anžon', na' bi wché'e x̱tiže'e, wnné': “To chi'ize nako' bx̱oz kan gok bx̱oz Melkisedek.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Zoa X̱anžon' kwito' ḻi ža gan zo'. Kate' že'e, na' wžía yi'e benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Choge' chegak benne' yógo'te yež ka' gátgake', na' gote' benne' zante yež ka'. Wžía yi'e benne' ka' ẕnna biá'gake' do ẕente yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ye'je' nis yégodo' da' zoan žoa'a nez, na' yeyák yeḻa' waḻe chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Dot ḻaža'a wká'n ẕena' X̱anžo Dios tẕen ḻen benne' chawe' ka', benne' zej ndobe' chie' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Da' ẕenḻe'e zej nak da' ka' ben X̱anžo Dios, na' yógo'te benne' ka', benne' žaz ḻáže'gake' da' ka' žone' ẕlab ḻáže'gake' da' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Yeḻa' baní', na' yeḻa' ẕen zej nžagen da' žone' Ḻe', na' to chi'ize zoa da' chawe' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Žone' ga žejsá' ḻáže'žo yeḻa' wak ẕente da' žone'. X̱anžo Dios nake' ẕen ḻaže', na' žeyache' ḻáže'le' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Ẕwawe' benne' ka' ẕžébegake' Ḻe', na' to chi'ize žejsá' ḻaže'e diža' da' bénḻene' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Bḻoe'ele' benne' chie' ka' yeḻa' ẕen che da' bene'. Ẕneẕjwe' benne' chie' ka' da' zej nape benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Ḻi ḻaže', na' chawe' zej nak da' ka' žone'. Ḻi ḻaže' zej nak yógo'te da' ka' wnnakze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","To chi'ize zóatezgak da' ka' bchi'le' žo'o. Ḻo da' li, na' ḻo da' ḻi ḻaže' bene' yógo'tegaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Bsele'e to benne' weslá nich beslé' benne' chie' ka'. To chi'ize bzoa choche' x̱tiže'e da' bénḻene' žo'o. Da' ẕen, na' da' ẕžébežo nak La la'y chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Nich so ḻawžo gápežo yeḻa' žejni'ile, žon byene žébežo X̱anžo Dios. Žejní'igekle binlo yógo'te benne' ka' žóngake' ka nak da' wnnakze' Ḻe'. To chi'ize žaḻa' wká'n ẕenžo Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","¡Ga'n ẕen X̱anžo Dios! Ba nez ẕen naken che bennen' ẕžebe' X̱anžo Dios, na' žaz ḻaže'e gone' da' bchi'le' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Ẕa'só bennen' nna biá'gake' yežlyó nga, na' gak chawe' chegak benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Da' zan da' de, na' yeḻa' wnni'a zej yo'on liž bennen' na' to chi'ize zoa da' chawe' da' žone'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Žsa'ní' to yi' ḻo da' choḻ gan zej nnita' benne' ḻi ḻaže' ka', benne' ka' zej nake' ẕen ḻaže', na' chawe', na' žeyache' ḻáže'gekle' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","To benne' chawe' žeyache' ḻáže'le' benách ka', na' žsane' ḻégake' mežw. Ḻo da' chawe' ẕkonle' žin da' yo'o ḻo ne'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Che ḻen bi be wkwás ḻe' ḻo latje gan zoe', na' to chi'ize chejsá' ḻáže'gak benách ka' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Bi žebe' kate' yenle' žak da' bi nak chawe' che da' yo'on ḻo ne'e. Ẕga'n choch ḻáẕda'we' dan' žx̱en ḻaže'e X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Zoa chawe' ḻáẕda'we', na' bi be ẕžebe' na' zejte ža ḻe'ele' gak kan žak ḻaže'e chegak benne' ka' bi ẕḻé'egekle' ḻe' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Ẕchise' da' nape', na' ẕneẕjwe' da' gákḻenen benne' yache' ka', na' to chi'ize zoa da' chawe' da' žone'. Ga'n ẕen yeḻa' wnná bia' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Ḻe'el benne' wen da' ẕinnj da' ni na' ge'ele ḻe'. Gáwya'ate laye'e, na' kwe' zedle'. Nitle da' ẕze ḻáže'gak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","¡Ga'n ẕen X̱anžo Dios! Ḻe'e, wen žin chie', ¡le wká'n ẕen La la'y chie'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","¡Ga'n ẕen La la'y che X̱anžo Dios, na'a ža, na' to chi'ize! ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","¡Ga'n ẕen La la'y che X̱anžo Dios, gan ẕḻa' wbíž ga žinte gan ženen! ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","¡Ga'n ẕen X̱anžo Dios ḻawle yógo'te yež ka', na' ḻawle ya'abá že' yeḻa' ẕen chie'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","¿Noẕkze benne' nake' ẕen ka nak X̱anžo Dios, Bennen' ẕnna bi'e ya'abá na'le? ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Dios žon kwine' gax̱jw ḻaže' nich gak ḻe'ele' da' de ẕan ya'abá, na' ḻo yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Dios žechise' benne' yache' ḻo bix̱te yo, na' žebeje' benne' nyache' ḻaže' ḻo da' ẕzáka'ḻi'e, ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","na' žone' ga že'gak benne' ki ladjw benne' blo ka', benne' ka' ẕnna biá'gake' benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Žone' ga zoa no'le wbíž ládjwgak x̱kwide' chekze' ka'. Žebele no'len' dan' nake' x̱na'gak x̱kwide' chie' ka'. ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Kate' bžojgak benne' Israel ka' ḻo yežlyó Egipto, bžojgak ẕa'só Jakob ḻo yežlyó chegak benne' zi'to' ka' ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","na' gokgak ẕa'só Judá ka to yo'o gan ẕbez Dios, na' gokgak benne' Israel ka' gan ẕnna bi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Bḻe'el Nisdo' X̱na da' ni, na' bẕonnjen, na' wdé x̱kože'l yegw Jordán. ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Wx̱íte'gak ya'a ẕen ka' kan žx̱íte'gak chib ka', na' wx̱íte'gak ya'ado' ka' kan žx̱íte'gak chibdo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","¿Biẕ gok chio', nisdon', dan' bẕonnjo'? ¿Biẕ gok chio', yegw Jordán, dan' wdío' x̱kože'l? ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ḻe'e, ya'a ẕen ka', ¿biẕ chen' wx̱íte'le ka žx̱íte'gak chib ka'? Ḻe'e, ya'ado' ka', ¿biẕ chen' wx̱íte'le kan žx̱íte'gak chibdo' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Žẕo' yežlyó ḻaw X̱anžo Dios, ḻaw Dios na' che Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Dios na'kze bene' ga beyák yej x̱en' to bej nis, na' bene' ga beyák yej to gan žaḻ nis. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Kege kwinto', X̱anto' Dios, kege kwinto', san Le' žaḻa' wká'n ẕento' ni'a che yeḻa' ži'i ḻaže' chio', na' yeḻa' ḻi ḻaže' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","¿Biẕ chen' ẕnnábgekle benne' zi'to' ka' neto'? Ẕnnágake': “¿Gaẕ zoa Dios chele?” ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Dios chežo zoe' ya'abá. Žone' da' žaz ḻáže'kze' gone'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Dios ka' chegak benne' zi'to' ka' zej naken lo'a ka' da' zej naken plat, na' oro, da' ka' nongak ḻo na'gak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Zoa žoá'agaken, san bi ẕnnégaken. Zoa yej ḻáwgaken, san bi ẕḻé'egeklen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Zoa nággaken, san bi žéngeklen. Zoa ẕína'gaken, san bi ẕḻé'egeklen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Zoa ná'gaken, san bi be ẕtágaken. Zoa ní'agaken, san bi ẕdágaken. Bi ẕžoj chí'igaken lbá'gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Kan zej naken, nakgak benne' ka' béngake' lo'a ka', na' ḻezka' benne' ka' žx̱en ḻáže'gake' ḻégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Le wx̱én ḻaže' X̱anžon', ḻe'e, benne' Israel ka'. Ḻe' žákḻene' ḻe'e, na' žape chi'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Le wx̱én ḻaže' X̱anžon', ḻe'e, bx̱oz ka' che Dios, ḻe'e nakle ẕa'só Aarón. Ḻe' žákḻene' ḻe'e, na' žape chi'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Le wx̱én ḻaže' X̱anžon', nole ḻe'e ẕka'n ẕenle Ḻe'. Ḻe' žákḻene' ḻe'e, na' žape chi'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","X̱anžon' žejsá' ḻaže'e žo'o, na' gon chawe'e žo'o. Gon chawe'e benne' Israel ka'. Gon chawe'e bx̱oz chie' ka' zej nake' ẕa'só Aarón. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Gon chawe'e benne' ka' žápegake' Ḻe' ba la'ne, benne' blo ka', na' benne' gax̱jw ḻaže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Gon X̱anžon' ga changak ẕi'nle ka', na' changak ẕi'ngak x̱kwide' byo chele ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","X̱anžon' gon chawe'e ḻe'e. Benkze' Ḻe' ya'abá, na' yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Che toze X̱anžon' nak ya'abá, san bneẕjwe' benne' ka' yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Benne' gat ka' bi gak we ḻáwgake' X̱anžon', na' bi gak benne' ka' zej die' yežw ba, ");
INSERT INTO ztyNTps_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","san žo'o, benne' ban ka', wká'n ẕenžo X̱anžon', na'a ža, na' to chi'ize. ¡Le wká'n ẕen X̱anžon'! ¡Ga'n ẕen Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Nži'ila' X̱anžo Dios dan' benle' chi'a, na' dan' wnnabla' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Dan' bze nage' chia', che ḻen wḻiža' Ḻe' x̱ak zoa' nbana'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Wžé' zedla' ni'a che yeḻa' got, na' wžeba' zoa' choa'a ḻo yi' gabíl. Wžé' zedla', na' wẕáka'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Naž bḻiža' X̱anžo Dios, na' wnnía': “X̱ana' Dios, beslá be' da' nakkza'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","X̱anžo Dios nake' chawe', na' ži'i ḻaže'. O', Dios chežo žeyache' ḻáže'le' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Žape chi'ikze X̱anžon' benne' gax̱jw ḻaže' ka'. Katen' wžé' zedla' beslé' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Ḻe' ben choche' neda', na' na'a zoa' chawe', dan' X̱anžon' žon chawe'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Le', X̱ana' Dios, besló' neda' ḻo na' yeḻa' got, nich biž kweže we'a, na' nich bi chejchégoa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Gona' da' ye' X̱anžo Dios neda' gan zej nnita' benne' ka' zej zoe' nbángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Bejḻi'a chie', na' bchaḻja' chie' ḻa'kze wẕáka'ḻi'a, ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","na' ḻo yeḻa' ẕžebe chia', wnnía': “Zej nak yógo'te benne' ka' benne' wen ḻaže' ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","¿Biẕkze gak yebi'ikza' che X̱anžo Dios ni'a che yógo'te da' chawe' da' bene' chia'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Si'a ḻo ne'e Ḻe' yeḻa' weslá, na' wḻiža' La la'y che X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Na'a gona' da' ka' wchebe ḻaža'a ḻaw X̱anžon'. Gonan' ḻawgak yógo'te benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","X̱anžo Dios ži'e wnné yoe ni'a chegak benne' chie' ka' dan' žátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","X̱ana' Dios, da' li naka' wen žin chio'. Naka' wen žin chio', na' ẕi'n no'le wen žin chio'. Le' bzoẕjo' da' bžejen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Da' wká'n ẕena' Le' gaken ka to biado' da' gota' ḻawo' Le', na' wká'n ẕena' La la'y chio' Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ḻaw X̱anžo Dios gona' da' ka' bchebe ḻaža'a chie'. Gonan' ḻawgak yógo'te benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Gonan' ḻa' ḻi'a liž X̱anžo Dios dan' žen' ḻo yež Jerusalén. ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","¡Le wká'n ẕen X̱anžo Dios, ḻe'e, benách yež ka'! ¡Le wká'n ẕene' Ḻe', ḻe'e, yógo'te benách ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Ẕente nak yeḻa' ži'i ḻaže' chie', na' kan nži'ile' žo'o, na' to chi'ize zoa yeḻa' ḻi ḻaže' chie'. ¡Le wká'n ẕen X̱anžon'! ¡Ga'n ẕen Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","¡Le wká'n ẕen X̱anžo Dios dan' nake' chawe', na' dan' to chi'ize žeyache' ḻáže'le' žo'o! ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Žaḻa' nnagak benne' Israel ka': “¡To chi'ize žeyache' ḻáže'le' žo'o!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Žaḻa' nnagak ẕa'só Aarón ka': “¡To chi'ize žeyache' ḻáže'le' žo'o!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Žaḻa' nnagak benne' ka' ẕžébegake' X̱anžo Dios: “¡To chi'ize žeyache' ḻáže'le' žo'o!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Katen' wžé' zedla' bḻiža' X̱anžo Dios. Bechebe X̱anžon', na' beslé' neda' ḻo dan' bex̱wn neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Zoaḻen X̱anžon' neda', na' batkle žeba' bi da' gongak benne' ka' chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Zoaḻen X̱anžon' neda', na' Ḻekze' žákḻene' neda'. Che ḻen ḻe'ela' chejchégwgak benne' ka' ẕdíḻ-ḻengake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Chawe' nak wx̱én ḻáže'žo X̱anžo Dios, na' kege wx̱én ḻáže'žo benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Chawe' nak wx̱én ḻáže'žo X̱anžo Dios, na' kege wx̱én ḻáže'žo benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Byéchjgekle benne' yógo'te yež ka' neda', san ḻo La la'y che X̱anžo Dios bžia yi'a benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Byéchjgekle' neda', na' bséjwgake' neda' le'jle, san ḻo La la'y che X̱anžo Dios bžia yi'a benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Byéchjgekle' neda' ka žongak bzoje ka', na' gok yeḻa' ẕža'a chégake' ka to yi' da' ẕzeyen yix̱e' yeche' biž, san ḻo La la'y che X̱anžo Dios bžia yi'a benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Bžíga'gake' neda' nich chejchégoa'a san gokḻen X̱anžo Dios neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Nak X̱anžo Dios ka to yo'o gan zoa chawa'a, na' góḻteza' chie' Ḻe', dan' Ḻekze' žeslé' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Žoḻgak benne' chawe' ka' ḻo yeḻa' žebele chégake' dan' žeslá X̱anžon' ḻégake'. Ḻen yeḻa' wak ẕen žon X̱anžo Dios da' ẕente ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Ẕente nak yeḻa' wak che X̱anžo Dios. Da' ẕente ka' žon yeḻa' wak ẕen che X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Bi gata', san soa' nbana', na' wzenla' benne' ka' ka zej nak da' ka' ben X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Bsaka' zi'ḻe'e X̱anžon' neda', san bi bdie' neda' ḻo na' yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Bsaljw gan cho'ogak benách ka' yodo' che X̱anžo Dios, na' choa'a ga na', na' wká'n ẕena' X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Zoa nga gan žo'ožo ḻaw X̱anžo Dios, na' žo'ogak benne' chawe' ka' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Wká'n ẕena' Le', X̱ana' Dios, dan' benlo' chia', na' besló' neda' ḻo dan' goken chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Yej na' da' bzoagak benne' wen yo'o ka' cheḻa'ale, beno' Le' ga naken yej blo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Da' ni benkze X̱anžon', na' žonen ga žebanlžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Ža ni naken ža da' ben X̱anžon'. Yebéḻe'elžo, na' soažo ḻo yeḻa' ba nez ḻo ža ni. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","X̱anto' Dios, žáta'yoela' Le' yesló' neto' na'a. Žáta'yoela' Le', X̱anto', gon chawo'o neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","¡Ga'n ẕen bennen' ze'e ḻo wláz X̱anžo Dios! Ḻo liž X̱anžo Dios ẕnnablto' Ḻe' gon chawe'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","X̱anžon' nakkze' Dios, na' ba bsa'ni'e žo'o. Le wchéj biado' ka' gótele ḻawe' Ḻe' ḻawgak loz bkog la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Nako' Le' Dios chia', na' wká'n ẕena' Le'. X̱ana' Dios, žoe ḻawa' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","¡Le wká'n ẕen X̱anžo Dios dan' nake' chawe', na' dan' to chi'ize žeyache' ḻáže'le' žo'o! ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Ba nez ẕen naken chegak benne' ka' žóntezgake' da' naken dot da' li, benne' ka' žóntezgake' ka ẕnna da' wnná X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Ba nez ẕen naken chegak benne' ka' žóntezgake' ka žsedle diža' chie' žo'o, na' dot yichj ḻáẕdo'gake' žóngake' kan ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Benne' ki batkle žóngake' da' ẕinnj, benne' ka' žóntezgake' ka ẕnna Dios žaḻa' góngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Le', X̱anto' Dios, bzejni'ilo' neto', nich bento' dot kan zej nak da' ka' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Žak ḻáže'ḻi'a gónteza' kakze ẕnna x̱tižo'o, ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","na' batkle yedoe'ela', cha' kwi'a wnné yoe gona' ka nak da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ḻo yeḻa' ḻi ḻaže' chia' wká'n ẕena' Le' kate' ba bsedla' da' bchi'a ḻažo'o, da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Gónteza' ka nak da' ka' ẕchi'lo' neto', na' batkle kwej yichjo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","¿Nakx̱ gak gon to benne' kwide' da' naken chawe'? Žaḻa' góntezbe' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Dot ḻaža'a žon byena' gona' da' ẕnnakzo' Le'. Bi go'o latje wzóa' cheḻa'ale dan' wnnó'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ḻo yichj ḻáẕda'wa' žónteza' ka nak da' ẕnno' Le' nich bi gona' doḻa', na' bi wži'a chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","La'y nako' Le', X̱ana' Dios. Bsedle neda' da' ẕchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ḻen žoá'akza' bzenla' benne' ka' ka nak da' bchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Žebéḻe'ežela' žónteza' ka žsedle diža' chio' neto', ka ẕbégekle benne' ka' zej nápḻi'e yeḻa' wnni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Wláb ḻaža'a ka nak da' wnnakzo' Le', na' wsedla' binlo da' ẕnno' žaḻa' gonto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Yebéḻe'ela' gona' ka nak da' ži'o neto', na' bi gaḻ ḻaža'a kan ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Ben chawe' neda', wen žin chio', na' soa' nbana', na' gónteza' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Bsaljw yej ḻawa' nich ḻe'ela' da' ẕente da' nyejwn ḻo da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Naka' ka to benne' ẕdaze' ḻo yežlyó nga. Bzejní'il neda' da' ẕchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Žedó ḻaža'a dan' dot ḻaža'a žak ḻaža'a gónteza' da' ẕchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ẕdiḻo' benne' ka' ẕka'n ẕen kwíngake', benne' wen da' ẕinnj ka', benne' ka' ẕzóagake' cheḻa'ale da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Bi go'o latje no benne' nne zi'e chia', na' wka'ne' neda' ka'ze, dan' žónteza' ka žsedlo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Ḻezka' benne' wnná bia' ka' wnnégake' chia', san neda', wen žin chio', ẕlab ḻaža'a ka nak x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Da' žaz ḻaža'a naken da' žsedle diža' chio' neto', na' ẕzejni'ilen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Že' be' da' nakkza' zedle dan' zoa' gata'. Bzoa choch yichj ḻáẕda'wa' ḻen x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Bḻoe'ela' Le' da' žona', na' bezi'o neda'. Bsedle neda' da' ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Bzejní'il neda' nich gak gona' da' ẕchi'lo' neto', nich wláb ḻaža'a ka zej nak da' ẕente ka' da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Žedó ḻaža'a dan' žak nyache' ḻaža'a. Ben choch neda' ḻen x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Bi go'o latje gaka' benne' wen ḻaže', na' ḻo yeḻa' žeyache' ḻaže' chio' bsedle neda' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ben byena' gona' da' naken dot da' li, na' ži'a wnné yoe gona' da' bchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Žónteza' ka žsedle diža' chio' neto'. X̱ana' Dios, bi go'o latje yedoe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Gónteza' ka zej nak da' ka' wnnakzo' Le', kate' wzejní'iželo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","X̱ana' Dios, bsedle neda' nich gona' ka ẕnna x̱tižo'o, na' gónteza' ka naken na' zejte ža gata'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Bzejní'il neda', na' gónteza' da' bchi'lo' neto', na' dot ḻaža'a gona' ka ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Bḻoe'el neda' nich gona' da' wnnakzo' Le', dan' žak ḻáže'kza' gona' ka naken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Ben ga chaz ḻaža'a gona' ka žsedle diža' chio' neto', nich bi dan ḻaža'a yeḻa' gape. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Bi go'o latje wká'n ẕena' lo'a ka'. Ben choch yichj ḻáẕda'wa' nich gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Ben ka ẕnna x̱tižo'o da' bchebe ḻažo'o chia' neda', wen žin chio', nich žeba' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Bde cheḻa'ale da' ẕnnégake' chia', dan' ẕžeba', dan' chawe' zej nak x̱tižo'o ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Žak ḻaža'a gona' da' bchi'lo' Le' neto'. Ben choch yichj ḻáẕda'wa' ḻen da' chawe' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Da, yeyache' ḻáže'lo' neda', X̱ana' Dios. Da, yesló' neda', ka bchebe ḻažo'o gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Žecheba' ḻaw bennen' ẕka'ne' neda' ka'ze, ẕnnia': “Žx̱en ḻaža'a x̱tižo'o, X̱ana' Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Ben ga sóateza' wchaḻja' diža' da' li chio', dan' žx̱en ḻaža'a da' ẕchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Gónteza' kan ẕnna da' wnnakzo' Le'. To chi'ize góntezan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Lakza' neda' dan' ži'a wnné yoe gónteza' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Wchaḻjkza' diža' chio' ḻawgak benne' wnná bia' ka', na' batkle yedoe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Yebéḻe'ekzla' gona' da' wnnakzo' Le', dan' nží'iḻe'elan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Žechebe ḻaža'a gona' da' bchi'lo' neto', dan' nži'ila', na' wláb ḻaža'a ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Bejsá' ḻaže' da' wchebe ḻažo'o chia' neda', wen žin chio', dan' žx̱en ḻaža'an. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Katen' wẕáka'ḻi'a, wzóa to da' beyón ẕenen neda', dan' ben choch x̱tižo'o yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Benne' ka' ẕka'n ẕen kwíngake' ẕnnégake' chia', san batkle wsana' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Chejsá' ḻaža'a ka nak da' bchi'a ḻažo'o ža ni'te, dan' žeyón ẕenen neda', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Ẕža'a neda', na že' zedla' ni'a chegak benne' ka' žóngake' da' ẕinnj, benne' ka' ẕzóagake' cheḻa'ale da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","X̱tižo'o naken to da' žoḻa' kate' ne zoa' to yežlyó da' žen' zi'to' ga zoa laža'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Žel chejsá' ḻaža'a La la'y chio', X̱ana' Dios, na' gónteza' ka ẕnna da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Gaken yeḻa' ba nez ẕen chia' dan' gónteza' da' bchi'lo' Le' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Da' ẕdan ḻaža'a nakkzo' Le', X̱ana' Dios. Wnnakza' gónteza' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Dot ḻaža'a ẕnnabla' Le' yido' gákḻeno' neda'. Beyache' ḻaže'l neda' kan wnnakzo' gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Bwia' binlo ka zej nak da' ka' bena', na' da' yoble žona' ka žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ben byena', na' bi wžeḻ-la' gónteza' ka nak da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Do yeḻj chegak benne' wen da' ẕinnj ka' nžejen neda', san bi na' gaḻ ḻaža'a ka ẕnna da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Žel žeyasa' na' ẕka'n ẕena' Le' dan' chawe' nak da' ẕchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Naka' toze ḻen yógo'te benne' ka' ẕžébegake' Le', benne' ka' žóntezgake' ka nak da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","X̱ana' Dios, nža' yežlyó yeḻa' žeyache' ḻaže' chio'. Bsedle neda' gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Žon chawo'o neda', wen žin chio'. X̱ana' Dios, žonon' ka ẕnnakze x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Bsedle neda' da' nak chawe' nich chejni'ilan', dan' žejḻi'a da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Néžwte ka bzex̱jo' neda' wdía' cheḻa'ale, san na'a žónteza' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Nako' chawe', na' ẕnno' gon chawo'o neto'. Bsedle neda' nich gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Benne' ka' ẕka'n ẕen kwíngake' wnnégake' chia' da' wen ḻaže', san dot ḻaža'a gónteza' da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Bi yo'o yeḻa' žejní'il ḻo ḻáẕdo'gak benne' ka' san neda' žaz ḻaža'a gona' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Chawe' nak bzex̱jo' neda', nich wsedla' gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Nákḻe'eže chawe' da' bchi'lo' neda', ka zante mil mežw oro, na' plat. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Ḻen na'kzo' beno' neda' káteze naka'. Bzejní'il neda' nich wsedla' gona' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Benne' ka' ẕžébegake' Le' ḻé'egekle' neda', na' yebégekle' dan' žx̱en ḻaža'a gak kan ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","X̱ana' Dios, nnezla' nak chawe' kan ẕchi'a ḻažo'o, na' ḻo yeḻa' ḻi ḻaže' chio' bsaka' zi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Na'a ḻo yeḻa' žeyache' ḻaže' chio' beyón ẕen neda' káteze nak da' bchebe ḻažo'o gono' chia' neda', wen žin chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Beyache' ḻaže'l neda' nich soa' nbana' dan' žaz ḻaža'a gona' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Ben ga yedoé'egekle benne' ka' ẕka'n ẕen kwíngake', dan' ẕnnégake' chia', na' bi be bena' chégake', san neda' wláb ḻaža'a ka nak da' bchi'lo' Le' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Ben ga ḻa'gak benne' ka' ẕžébegake' Le', nich yéngekle' chia', na' wsédgekle' da' žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Ben ga gona' dot ḻaža'a ka ẕnna x̱tižo'o, nich batkle yedoe'ela'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Že' zedle be' da' nakkza' dan' ẕbeza' ža yido' yesló' neda'. Žx̱en ḻaža'a gaken kan ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Že' bxin yej ḻawa' dan' žénela' yenla' da' nno', na' ẕnnia': ¿Batx̱kze yeyón ẕeno' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Ẕbiža' ka to že'e yid dan' naḻan' ḻaw yi', san bi na' gaḻ ḻaža'a gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","¿Balx̱ ža soa' nbana' neda', wen žin chio'? ¿Batx̱kze gono' zi' benne' ka' ẕbia ḻáže'gake' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Benne' ka' ẕka'n ẕen kwíngake' bché'ngake' to yežw gan chejbix̱a' neda'. Batkle žóngake' ka ẕnna dan' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Yógo'te da' bchi'lo' Le' neto' naken dot da' li. Gokḻen neda' dan' ẕbia ḻáže'gake' neda', na' bi be bena' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Yeláte'ze bétgake' neda', san bi na' wsana' gona' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Ḻo yeḻa' žeyache' ḻaže' chio' ben choch yichj ḻáẕda'wa', nich gónteza' ka žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","X̱ana' Dios, to chi'ize zoa x̱tižo'o ya'abá na'le. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Yeḻa' ḻi ḻaže' chio' žinen chegak yógo'te kwe' benách ka'. Le' bzoa chochkzo' yežlyó, na' zoakzen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Ni'a che da' wnnakzo' zej nnita' yógo'te da' zej de, na' yógo'ten žóngaken žin chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Chela' bi wyáz ḻaža'a da' wnnakzo' Le' bache wnitla' ni'a che da' wẕáka'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Batkle gaḻ ḻaža'a da' bchi'lo' neto', dan' ni'a chen ba ben chocho' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Beslá neda' dan' naka' neda' chio' Le' na' žon byena' gona' kan ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Benne' wen da' ẕinnj ka' bwíagake' neda' nich gak wžía yí'gake' neda', san neda' ẕlab ḻaža'a da' žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Ba bḻe'ekzla' ẕde chegak yógo'te da' zej de yežlyó, san da' ka' wnnakzo' Le' batkle te chégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Dios, nží'iḻe'ela' da' žsedlo' neto'. Dot ža ẕlab ḻaža'a ka ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Ni'a che da' bchi'lo' neto', beno' ga žejní'ižela' ka benne' ka' ẕžá'agake' neda' dan' zóaḻenteze da' wnnakzo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Žejní'ižela' ka benne' ka' žsédgekle' neda' dan' ẕlab ḻaža'a da' žsedle diža' chio' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Ba žejní'ižela' ka benne' gole ka' dan' žónteza' ka ẕnna da' bchi'lo' Le' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ben byena' bi be gona' da' bi nak chawe', nich gónteza' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Bi bsana' žona' kan bchi'a ḻažo'o dan' bsedlo' Le' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","X̱tižo'o naken ka to da' ẕix̱ḻe'e ḻo žoa'a. Nakžen ẕix̱ ka nak da' ẕix̱ che bez ḻo žoa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Ni'a che da' wnnakzo' Le' naka' benne' sina'. Che ḻen bi ẕḻe'ela' chawe' yógo'te da' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Ka to yi' nak x̱tižo'o gan ẕda', dan' žsa'nín' nez da' ẕzá'ḻena'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Bzetja' La la'y chio', Dios, na' bchebe ḻaža'a gónteza' ka bchi'a ḻažo'o da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","X̱ana' Dios, ẕzáka'ḻi'a. Ben choch neda' káteze bchebe ḻažo'o gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","X̱ana' Dios, žáta'yoela' Le' si'o da' žoe ḻawa' Le'. Bsedle neda' gona' ka bchi'a ḻažo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Že' zédtezla' dan' zoa' gata', na' bi na' gaḻ ḻaža'a gona' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Benne' wen da' ẕinnj ka' bzáljgake' do yeḻj nich senen neda', san neda' bi bsana' žona' da' bchi'lo' Le' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Ba wžía' da' žsedle x̱tižo'o neda' nich gaken da' gápekza' to chi'ize, dan' nak x̱tižo'o da' ẕdan ḻáže'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Zoakze ḻáẕda'wa' gónteza' ka ẕnna x̱tižo'o na' zejte ža gata'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Bi ẕḻe'ela' chawe' benne' ka' ẕḻoé'ezele kwíngake' chawe', san nži'ila' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nako' Le' ka to yo'o gan ẕga'na' chawe', na' ka to da' žape chi'in neda', dan' žx̱en ḻaža'a gaken ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Le kwas gan zoa', ḻe'e, benne' wen da' ẕinnj ka', dan' gónteza' ka bchi'le Dios chia' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Ben choch neda' káteze ẕnna x̱tižo'o, na' soa' nbana', na' bi yedoe'ela' ni'a che dan' žx̱en ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Ben choch neda', na' la', na' chaz ḻáže'teza' x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Blej bchochj yógo'te benne' ka' bi žóngake' kan ẕnna x̱tižo'o dan' nak yeḻa' žejní'il chégake' da' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Yógo'te benne' wen da' ẕinnj ka' zej nake' ka bebe ḻo yežlyó nga. Che ḻen nži'ila' da' žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Žẕize beḻa' žen chia' dan' ẕžeba' Le', san žapa' ba la'ne da' ẕchi'a ḻažo'o, da' naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Žona' ka nak da' bchi'a ḻažo'o, da' naken chawe'. Bi wdío' neda' ḻo na'gak benne' ka' žsaka' zí'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Bchebe ḻažo'o chia' gon chawo'o neda'. Bi go'o latje benne' ka' ẕka'n ẕen kwíngake' wsaka' zí'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Gok yej ḻawa' dan' ẕbeza' yido' yesló' neda', na' wchi'a ḻažo'o neto' kan ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Ḻo yeḻa' žeyache' ḻaže' chio' ben chawe' neda', wen žin chio', na' bsedle neda' gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Bzejní'il neda', wen žin chio', nich gónbi'a da' žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","X̱ana' Dios, ba bžin ža bi da' gono', dan' bzóagake' cheḻa'ale da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Che ḻen neda' nží'ižela' da' bchi'lo' neto', ka ya oro, na' ka da' záka'že ka ya oron'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Che ḻen žekla' záka'že da' wnnó' ka yógo'te da' de, na' bi ẕḻe'ela' chawe' yógo'te da' zej naken da' wen laže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Žebanlto' ka žsedle diža' chio' neto'. Che ḻen dot ḻaža'a žónteza' ka ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Kate' no benne' bi gak chejni'ile' x̱tižo'o, x̱tižo'o na'kze žsa'nín' ḻe'. Ẕzejni'ilen benne' gax̱jw ḻaže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Wsalja' žoa'a, na' kwez ḻaža'a dan' žak ḻaža'a gónbi'a da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Bwia neda', na' beyache' ḻaže'l neda', kan žóntezo' chegak benne' ka' zej nži'ile' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Ben ga gónteza' ka ẕnna x̱tižo'o, na' bi go'o latje da' ẕinnj nna bian' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Beslá neda' ḻo na'gak benne' yichj ža'a ka', na' gónteza' ka nak da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Ben chawe' neda', wen žin chio', na' bsedle neda' gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Nis wžeža' goken ka to yegw nis dan' bi žongak benne' ka' da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","X̱ana' Dios, chawe' nako' Le', na' ḻi ḻaže' nak ka ẕchi'a ḻažo'o neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Da' žsedle diža' chio' neto', dan' bdion' ḻo na'to', naken da' li, na' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Žedó ḻaža'a dan' žé'ḻi'a wnné yoe dan' goḻ ḻáže'gak benne' ka' bi ẕḻé'egekle' neda' chawe' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Dot da' li nak x̱tižo'o, na' neda', wen žin chio', nži'ilan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Naka' gax̱jw ḻaže', na' ẕzóagake' neda' cheḻa'ale, san bi na' gaḻ ḻaža'a da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","To chi'ize zoa da' ẕchi'a ḻažo'o, na' da' li nak da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Da' ẕzáka'ḻi'a, na' da' zede zej nox̱en neda', san žaz ḻaža'a da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","To chi'ize nak ḻi ḻaže' da' žsedle diža' chio' neto'. Bzejní'il neda', na' soa' nbana'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Dot ḻaža'a žḻiža' Le', X̱ana' Dios. Ben chawe' neda', na' gónteza' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Žḻiža' Le'. Gokḻen neda', na' gónteza' ka žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Žasa' néžwte ka ža'ní', na' žḻiža' Le'. Žx̱en ḻaža'a gak kan ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Kate' ba goḻe, ẕbeja' yele yej ḻawa', nich wláb ḻaža'a ka nak da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Ḻo yeḻa' žeyache' ḻaže' chio' benle chi'a. X̱ana' Dios, ka nak da' bchi'a ḻažo'o ben choch neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Benne' ka' ẕbia ḻáže'gake' neda' zej nnita' góngake' chia' da' ẕinnj. Bsángake' da' ka' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","X̱ana' Dios, zo' Le' gawze gan zoa'. Yógo'te da' wnnakzo' naken dot da' li. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ža ni'te ba nónbi'a da' žsedle diža' chio' neto', dan' bzo' cheto' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Bwia binlo ka ẕzáka'ḻi'a, na' beslá neda', dan' bi na' gaḻ ḻaža'a da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Bechebe ḻo wlaza' neda', na' beya'w neda'. Ben choch neda' ḻen x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Zedḻe'e gak lagak benne' ka' žebéj yíchjgake' Le', dan' bi ẕbé'gake' wnné yoe góngake' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","X̱ana' Dios, žeyache' ḻáže'ḻe'elo' benách chio' ka'. Ben choch neda' ka ẕnnakze x̱tižo'o gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Zanḻe'e zej nak benne' ka' ẕbia ḻáže'gake' neda', na' benne' ka' bi ẕḻé'egekle' neda' chawe', san bi na' wsana' žona' ka žsedle diža' chio' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Bi ẕḻe'ela' chawe' benne' ka' žebéj yíchjgake' Le', benne' ka' bi žóngake' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Bwia nga, X̱ana' Dios, ka nži'ila' da' bchi'lo' neto'. Ḻo yeḻa' žeyache' ḻaže' chio', ben choch neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Dot da' li nak x̱tižo'o, na' to chi'ize zoa da' ẕchi'a ḻažo'o Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Benne' wnná bia' ka' ẕbia ḻáže'gake' neda', na' bi be bena' chégake', san dot ḻaža'a žapa' x̱tižo'o ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Žebéḻe'ežela' ḻo da' ẕnna x̱tižo'o ka žebele bennen' žežeḻ-le' to yeḻa' wnni'a ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Bi ẕḻe'ela' chawe', na' bi ẕzi'a da' wen ḻaže', san nži'ila' da' bsedlo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Tža tža žoe ḻawa' Le' dan' nak chawe' ka ẕchi'a ḻažo'o neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Ẕga'n cháwe'gac benne' ka' zej nži'ile' da' žsedlo', na' bi be de da' gonen ga chejchégwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","X̱ana' Dios, ẕbeza' Le' yido' yesló' neda', na' žónteza' ka nak da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Dot ḻaža'a žónteza' da' žsedle diža' chio' neto', na' nží'iḻe'ela' da' ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Žónteza' ka ẕnna da' bchi'lo' neto', na' ka žsedle diža' chio' neto', na' ẕḻé'ekzlo' yógo'te da' žona'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","X̱ana' Dios, benle da' žḻiža' Le'. Bzejní'il neda' ka ẕnna x̱tižo'o gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Benle da' ẕnnaba' ḻawo' Le'. Beslá neda' ka bchebe ḻažo'o gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","We ḻáwteza' Le', X̱ana' Dios, dan' bsedlo' neda' gona' ka ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Wcháḻjteza' ka nak x̱tižo'o dan' chawe' nak da' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Wzóateze gákḻeno' neda' dan' žon byena' gona' ka ẕnna da' wnnakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Žak ḻaža'a yesló' neda', X̱ana' Dios. Žaz ḻaža'a da' bsedlo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Ben ga soa' nbana', na' wká'n ẕena' Le', na' da' ẕchi'a ḻažo'o gákḻenen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ẕdía' cheḻa'ale kan ẕda to ẕila' nnitlba'. Beyílj neda', wen žin chio', dan' bi na' gaḻ ḻaža'a da' ka' bchi'lo' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Kate' wžé' zedla' bḻiža' X̱anžo Dios, na' Ḻe' gókḻene' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","X̱ana' Dios, beslá neda' ḻo na'gak benne' wen ḻaže' ka' na' ḻo na'gak benne' ka' bi zej nake' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","¿Biẕ gonn Dios ḻe'e, benne' wen laže' ka'? ¿Biẕ yeḻa' ba nez gaken chele kate' wdíe' ḻe'e ḻo da' wžía yin' benách ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Wsaka' zi'gak yag ntóche'do' chie' ka' ḻe'e, na' yag ka' zoa yi' ḻáwe'lgaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Da' nyáche'ḻe'e žaken chia' neda'. Zoakza' ladjw benne' Mesek ka', na' zoa' to yo'o laže' chegak benne' Sedar ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Schaḻe'e ba wzóa' ladjw benne' ki, benne' ka' ẕzóagake' cheḻa'ale yeḻa' ẕga'n chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Neda' žak ḻaža'a gata' yeḻa' ẕga'n chawe', san kate' ẕchaḻja' chen, ẕdíḻ-ḻengak benne' ka' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Ẕchis ḻawa', na' ẕwia' da' žak ḻawgak ya'a sibe ka'. ¿Gaẕ za' da' gákḻenen neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Da' gákḻenen neda' za' ḻo na' X̱anžo Dios, Bennen' bene' ya'abá, na' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Bi go'e latje chejchego'o, na' bi tas Bennen' žape chi'ikze' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Bwia nga, batkle ẕnnan tas Bennen'. Batkle tas Bennen' žape chi'ikze' benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","X̱anžo Dios žape chi'e le'. X̱anžo Dios zoe' kwito' ḻi ža gan gake' ẕoḻ chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Bi wzéy wbíž le' te ža, na' bi be gon byo' chio' žel. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","X̱anžo Dios gape chi'ikze' le' nich bi be da' ẕia gaken chio'. Gape chi'ikze' yeḻa' nban chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","X̱anžo Dios gape chi'ikze' le' kate' žežojo', na' kate' žeyó'o, na'a ža, na' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Bebéḻenla' tẕen benne' ka' góžgake' neda': “Le cho'o ḻo yodo' che X̱anžo Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Na'a zoažo nga. Zežo lo'ole ze'e da' nyechjlen yež Jerusalén. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalén naken to yež da' béngake', na' naken x̱tanḻe'e, na' že'ḻe'en chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Ḻo yežen' za'gak yógo'te kwe' benne' ka', benne' zej nake' che X̱anžo Dios. We ḻáwgake' La la'y che X̱anžo Dios, kan wnnakze' Ḻe' gongak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ẕdobgak benne' ka' ḻo yežen' nich wchi'a ḻáže'gake' benách Israel ka' benne' ka' zej nbabe' ẕa'só Dabí, bennen' wnná bi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Le nnable Dios wka'ne' chawe' benne' Jerusalén ka'. Ḻe' gon chawe'e benne' ka' zej nži'ile' yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Ẕnnablto'-ne' gone' ga soa yeḻa' ẕga'n chawe' lo'ole ze'e dan' nyechjlen yež Jerusalén. Gon chawe'e benne' ka' zej yoe'e yo'o ẕen ka' chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Na'a, dan' nži'ila' bi' ljéža'do' ka', na' lježa' ka', ẕnnia': “Gata' yeḻa' ẕga'n chawe' chele ḻo yež Jerusalén.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Dan' nži'ila' yodo' che X̱anžo Dios žon byena' gak chawe' chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Chis ḻawa', na' wia' gan zo', X̱ana' Dios, gan zo' Le' ya'abá na'le. ");
INSERT INTO ztyNTps_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Ka žon to bi' byo wen žin ẕwíabe' bi da' nna x̱anbe', na' ka žon to no'le wen žin ẕwíabe' bi da' nna no'le x̱anbe', ki ẕwíažo bi da' nna X̱anžo Dios na' zejte yeyache' ḻáže'le' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Beyache' ḻaže'l neto', X̱anto' Dios. Beyache' ḻaže'l neto' dan' žedó ḻáže'to' dan' ẕbia ḻáže'gak benne' ka' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Žedó ḻáže'to' dan' žon dítjgekle benne' wnni'a ka' neto'. Benne' ka' ẕka'n ẕen kwíngake' ẕbia ḻáže'gake' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","“Chela' bi gokḻen X̱anžo Dios žo'o”, žaḻa' nnagak benne' Israel ka' na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","“Chela' bi gokḻen X̱anžo Dios žo'o kate' bdíḻ-ḻengak benne' ka' žo'o, ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","na' bžia yí'gake' žo'o to chi'ize ḻo yeḻa' ẕža'a ẕen chégake', ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","na' gok chežo ka žak che to benne' ẕkache' nisdo' ḻe', na' žoten ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Chela' gok ki chežo, na' la' betten žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Žaḻa' ye'žo X̱anžo Dios “žóx̱keno'”, dan' bi bi'e latje benne' ka' wžía yí'gake' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Belažo kan želá to byinne ḻo yix̱jw che to benne' wezén byinne ka'. Beká'a X̱anžon' yeḻa' wnná bia' chegak benne' ka', na' belažo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Nak X̱anžo Dios Bennen' benkze' ya'abá, na' yežlyó. Ḻekze' žákḻene' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Benne' ka' žx̱en ḻáže'gake' X̱anžo Dios zej nake' ka Ya'a Sión. Bi gak no benne' wtén', san to chi'ize zoa chochen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Kan zej že' ya'a ka' da' nyéchjgeklen yež Jerusalén, ki žon X̱anžo Dios, žape chi'ikze' benne' chie' ka', na'a ža, na' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Kege to chi'ize nna bia'gak benne' wen da' ẕinnj ka' ḻo yežlyó chegak benne' chawe' ka', nich bi gakgak benne' chawe' ka' toze ḻen benne' wen da' ẕinnj ka', na' bi góngake' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","X̱ana' Dios, ben chawe' benne' chawe' ka', na' benne' ka' zej nake' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","San benne' ka' žebéj yíchjgake' Dios nich góngake' da' ẕinnj, X̱anžo Dios wkwase' benne' ka' tẕen ḻen benne' wen da' ẕinnj ka'. Ẕnnabla' Dios gata' yeḻa' ẕga'n chawe' chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Kate' X̱anžo Dios beslé' žo'o ḻo na'gak benne' zi'to' ka', na' begoé'e žo'o ḻo yež Sión, gókežo zoažo bichgale. ");
INSERT INTO ztyNTps_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Naž bẕížežo, na' be ḻawžo X̱anžo Dios. Naž wnnagak benne' zi'to' ka': “Da' ẕente ben Dios, X̱angak benne' ka', chégake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Da' likze, ẕenḻe'e nak da' ben X̱anžo Dios chežo žo'o. Žak chežo yeḻa' ba nez ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Beslá X̱anžon' žo'o ḻo na'gak benne' zi'to' ka'. Naž bežinžo ḻo yežlyó chežo, kan žežín nis wba'w ḻo yegw biž ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Benne' ka' ẕbéžegake' kate' žázgake', ḻo yeḻa' žebele chégake' yezí'gake' linne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Bennen' ẕbeže' kate' zeje' zjeze' binne cháwe'do' ka', ḻo yeḻa' žebele yežine' zedjnoé'e linne chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Cha' bi zoaḻen X̱anžo Dios benne' ka' žóngake' to yo'o dáche'ze gak žin da' góngake'. Cha' bi žape chi'ikze X̱anžo Dios to yež, dáche'ze gak da' gongak benne' ka' žape chí'igaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Dáche'ze nak žasle zildo', na' žonle žin kate' ne ẕḻa' wbíž na' zejte ženen, na' ḻo da' ẕzáka'le žezi'le da' gawle. Žonn Dios da' gawgak benne' ka' nži'ile' x̱ak ẕtásgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Bwia nga, benn X̱anžon' chežo ẕi'nžo ka'. Zej nakbe' to yeḻa' wnni'a ẕente. ");
INSERT INTO ztyNTps_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Ẕi'nžo ka', bi' žáljgakbe' kate' ne žonžo yiz kwide' chežo zej nakbe' ka yag ntóche'do' ka' da' nox̱w to benne' žeje' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Ba nez ẕen naken che bennen' nox̱we' zante yag ntóche'do' ki. Batkle yedoe'ele' ḻawgak benne' ka' ẕdíḻ-ḻengake' ḻe' kate' yechebe' chekze' ḻaw bennen' ẕchi'a ḻaže'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Ba nez ẕen naken chegak yógo'te benne' ka' žápegake' X̱anžo Dios ba' la'ne, benne' ka' žóntezgake' kan ẕnnakze Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Kate' žawo' da' žezi'o che žin da' beno', gak chio' yeḻa' ba nez ẕen, na' gak chawe' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Gak ẕo'lo' ka to lba uba da' ẕbian da' ẕix̱ kwit ližo', na' ẕi'no' ka' gákgakbe' ka yag olibo ka' zej zen žoa'a gan žawo'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Ki gon chawe' X̱anžon' bennen' žape' Ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Ẕnnabla' X̱anžon', Bennen' zoe' Ya'a Sión, gon chawe'e le', nich ḻe'elo' gak chawe' che yež Jerusalén yógo'te ža so' nbano', ");
INSERT INTO ztyNTps_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","na' nich ḻe'elo' ẕa'só' ka'. Ẕnnabla' Dios gone' ga gata' yeḻa' ẕga'n chawe' chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","“Ben zí'gake' žo'o katen' wzoažo yiz kwide' chežo”, wak nnagak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Ben zí'gake' žo'o katen' wzoažo yiz kwide' chežo, san bi bžia yí'gake' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Béngake' we' x̱kóže'žo katen' bdínngake' žo'o yid, na' gokgak x̱kóže'žo ka yežlyó da' ẕde ya.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Chawe' nak X̱anžo Dios. Beslé' žo'o ḻo na'gak benne' ka' bsaka' zí'gake' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","X̱ana' Dios, ben ga chejchégwgak, na' wẕonnjgak yógo'te benne' ka' ẕdíḻ-ḻengake' benne' Sión ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Ben ga gákgake' ka yíx̱e'do' ka' žíagaken yichjo'o, da' ka' ẕbížgaken kate' ne zej nže'nen, ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","na' bi soa no benne' yeké'en, na' bi gak no benne' gonen' to chejx̱ónnj. ");
INSERT INTO ztyNTps_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Bi nnagak benne' ka' ẕdégake' gan zej žian: “Ẕnnablto' X̱anto' Dios gon chawe'e ḻe'e. Ḻo La la'y che X̱anto' Dios ẕnnablto' gak chawe' chele.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Ga že' zedla' ni žḻiža' Le', X̱ana' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","X̱ana' Dios, benle chia'. Bze nag da' ẕnnabla' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","X̱ana' Dios, cha' ẕwio' binlo doḻa' da' nbága'to', ¿noẕkze benne' ga'ne' chawe' ḻawo' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","San Le' ženít ḻawo'o cheto', nich gapto' Le' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Dot ḻaža'a žx̱en ḻaža'a X̱anžo Dios, na' žx̱en ḻaža'a x̱tiže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Ẕbez ḻáže'ža' X̱anžo Dios, ka žongak benne' ka' žape chí'igake' to yež, ẕbez ḻáže'gake' cha'ní', na' ka žongak benne' wape chi'i ka' ẕbez ḻáže'gake' cha'ní'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Benne' Israel ka' žaḻa' wx̱én ḻáže'gake' X̱anžo Dios dan' žeyache' ḻaže'l X̱anžon' benne' chie' ka'. Žape chi'e benne' ka' ḻo da' žongak benne' ka' bi ẕḻé'egekle' ḻégake' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Ḻe' yeya'we' benne' Israel ka' ḻo na' yógo'te doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","X̱ana' Dios, ba bsana' yeḻa' ẕka'n ẕen kwin chia', na' ba bkwasa' yeḻa' žon ẕen kwin chia'. Bi žilja' da' zej nak ẕen, da' ka' bi nak chia' wḻapa' na'a, ");
INSERT INTO ztyNTps_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","san neda' bi be wnnía', na' wzoaza' žize, kan žon to bi' že'n za' góẕe'be', na' ẕtasbe' ḻo na' x̱na'be'. Nak be' nakkza' ka to bi' že'n za' góẕe'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Le wx̱én ḻaže' X̱anžo Dios, ḻe'e, benne' Israel ka', na'a ža, na' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","X̱ana' Dios, bejsá' ḻaže' kan gok che Dabí, na' kan wẕáka'ḻi'e, ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","na' kan nak da' bchebe ḻaže'e gone' chio', dan' bchebe ḻaže'e ḻawo' Le', Dios waḻe che Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Wnné': “Batkle choa'a liža', na' batkle gata'a ḻo da' žáte'la', ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","na' batkle wsejwa' yej ḻawa', na' batkle tasa', ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","na' zejte ba bena' to latje gan ga'n X̱ana' Dios, gan soakze Dios waḻe che Jakob.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Benlto' kak la'y gan yo'o diža' da' bénḻeno' x̱a gole wdé cheto' ka' wzóa ḻo yežlyó Efrata, na' bežéḻ-lton' ḻo yežlyó che bennen' le' Jaar. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Wnnato': “Le cho'o gan zoa Dios chežo, na' wzóa ẕibžo ḻawe' Ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Wzó ža', X̱anto' Dios, ḻen kak la'y che yeḻa' wak chio', na' da ḻaw ya'a gan soakzo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Ben ga gongak bx̱oz chio' ka' da' naken chawe', na' kwéžeya'a yógo'te benách chio' ka' ḻo yeḻa' žebele chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Dan' nži'ilo' Dabí, wen žin chio', bi wzó' cheḻa'ale benne' wnná bian' wžío' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Da' likze bzetj kwin X̱anžo Dios, na' bchebe ḻaže'e bi da' gone' che Dabí, na' bi wnite' dan' wnné' gone'. Wnné': “Gona' ga nna bia'gak ẕa'só' ka' gan ẕnna bia'kzo' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Cha' góntezegak ẕi'no' ka' ka nak x̱tiža'a dan' bénḻena' le', na' ka nak x̱tiža'a dan' wsedla' le', na' ẕi'no' ka' nna biá'tezegake' gan ẕnna bi'o le'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Dan' wžé X̱anžo Dios yež Sión gok ḻaže'e soa ližkze' ga na', ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","na' wnné': “Gákteze latje nga gan soakza' neda'. Sóateza' nga dan' ki žaz ḻaža'a gona'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Gona' gáta'ḻe'e linne chegak benne' ka'. Gona' ga yéljgekle benne' yache' ka' yet. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Gona' ga gongak bx̱oz chia' ka' da' naken chawe'. Kwéžeya'a yógo'te benách chia' ka' ḻo yeḻa' žebele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Ḻo latjen' gona' ga yeyák yeḻa' wnná bia' che Dabí. Gona' ga soagak nbangak ẕa'só benne' wnná bian' ga na', bennen' wžía' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Gona' ga chíx̱gekle benne' ka' bi ẕḻé'egekle' ḻégake' chawe', san gona' ga diá'teze yeḻa' wnná bia' che Dabín'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Le wia nga, x̱tanḻe'e nak, na' cháwe'ḻe'e nak, kate' zej ndobe benne' ka' che Dios, zej nake' toze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Naken ka to set da' ẕzoagak bx̱oz ka' yíchjgake', da' ẕdinnen žoa'a ḻáwgake', kan wdinnen ḻo loẕe Aarón, na' wdinnen gan bžinen ni'i ẕe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Ẕdinnen kan ẕdinne x̱le'l ḻaw Ya'a Hermón, na' ḻaw Ya'a Sión. X̱anžo Dios gon chawe'e benne' ka' nníta'gake' ga na', na' gonne' chegak benne' ka' yeḻa' nban da' zejlí kanne. ");
INSERT INTO ztyNTps_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Le wia nga, le wká'n ẕen X̱anžo Dios, ḻe'e, benne' wen žin ka' che X̱anžon', zoale ḻo yodo' che X̱anžon' žel. ");
INSERT INTO ztyNTps_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Le wchís na'le ḻaw latje la'y, na' le wká'n ẕen X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Ẕnnabla' X̱anžon', Bennen' zoe' Sión, gon chawe'e ḻe'e. Ḻekze' bene' ya'abá, na' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","¡Le wká'n ẕen La la'y che X̱anžo Dios! ¡Le wká'n ẕene' Ḻe', ḻe'e, wen žin ka' che X̱anžon', ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","ḻe'e zoale ḻo yodo' che X̱anžo Dios, ḻo ḻi'a yodon' gan zoakze Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","¡Le wká'n ẕen X̱anžon' dan' nake' chawe'! ¡Le goḻ da' wká'n ẕenle La la'y chie', dan' nake' ži'i ḻaže'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","X̱anžo Dios wžíe' ẕa'só Jakob ka'. Wžíe' ẕa'só Israel ka' nich gákgake' benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nnézkzelžo ẕente nak X̱anžo Dios. Nakže' ẕen ka yógo'te dios chegak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Žon X̱anžon' yógo'te da' žénele' gone' ẕan ya'abá, na' ḻo yežlyó, na' ḻo nisdo', na' ḻo da' zoan gže' ẕan nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Žone' ga že' bejw do ẕente yežlyó. Žone' ga žasgak yes wzió' kate' žak yejw. Žone' ga žak be' gáte'teze. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Ḻe' betkze' bi' byo nežw ka' chegak benne' Egipto ka'. Gotgak bi' byo nežw ka' chegak benne' ka', na' bia néžwdo' ka' chegak bia yix̱e' chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Bene' yeḻa' wak ka' che ya'abá, na' da' ẕente ka' kate' bchinnje' yežlyó Egipton', da' ka' ben Dios che benne' Faraón, na' chegak yógo'te benne' wen žin ka' che Faraón na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Bžia yi'e benne' ka' chegak zante yež ka', na' bete' benne' wnná bia' ka', benne' ẕenḻe'e ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Bete' Sehón, bennen' wnná bi'e benne' amorreo ka', na' Og, bennen' wnná bi'e benne' Basán ka', na' yógo'te benne' wnná bia'gake' benne' Kanaán ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Beké'e yežlyó nga ḻo na'gak benne' wnná bia' ka'. Bneẕjwen' chegak benne' chie' ka', benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","X̱anto' Dios, to chi'ize zoa La la'y chio'. Chejsá' ḻáže'tezgak benách ka' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","X̱anžo Dios ẕchi'a ḻaže'e benne' chie' ka'. Žeyache' ḻáže'le' žo'o, wen žin chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Lo'a ka' chegak benne' zi'to' ka' zej naken ya oro, na' ya plat. Zej naken da' ka' bengak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Zej de žoá'agaken san bi ẕnnégaken. Zej de yej ḻáwgaken san bi ẕḻé'egeklen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Zej de nággaken san bi žéngeklen, na' bi zóagaken nbángaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Benne' ka' žóngake' lo'a ka' zej nake' kan nákgaken. Ḻezka' zej nak benne' ka' žx̱en ḻáže'gake' ḻégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Ḻe'e, benne' ẕa'só Israel, ¡le wká'n ẕen X̱anžo Dios! Ḻe'e, benne' ẕa'só Aarón, ¡le wká'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Ḻe'e, benne' ẕa'só Lebí, ¡le wká'n ẕen X̱anžo Dios! Ḻe'e, nol-le ẕžébele X̱anžo Dios, ¡le wká'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Ḻe'e zoale yež Sión, ¡le we ḻaw X̱anžo Dios, Bennen' zoakze' yež Jerusalén! ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","¡Le wká'n ẕen X̱anžo Dios, Benne' chawen'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","¡Le wká'n ẕen Dios, Bennen' nákḻe'eže' ẕen ka zej nak dios chegak benne' zi'to' ka'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","¡Le wká'n ẕen X̱anžon', dan' nákḻe'eže' ẕen ka zej nak x̱angak benne' zi'to' ka'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","¡Le wká'n ẕen toze' Ḻe' dan' žone' yeḻa' wak ẕen ka'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","¡Le wká'n ẕen Ḻe', dan' benkze' ya'abá ḻen yeḻa' žejní'il chie'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","¡Le wká'n ẕen Dios, Bennen' bzoe' yežlyó ḻawle nisdo'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","¡Le wká'n ẕen Dios, Bennen' bene' wbíž, na' byo'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Bene' Ḻe' wbíž nich wsa'nín' te ža. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Bene' byo', na' belj ka' nich wsa'ní'gaken žel. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","¡Le wká'n ẕen Dios, Bennen' bete' bi' byo nežw ka' chegak benne' Egipto ka'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","¡Le wká'n ẕen Dios, Bennen' bebeje' benne' Israel ka' ḻo yežlyó Egipton'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Bchi'e ḻégake' ḻen yeḻa' wak ẕen chie'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","¡Le wká'n ẕen Dios, Bennen' ben chople' Nisdo' X̱na! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Bene' ga bdegak benne' Israel ka' gachj ḻawle nisdon'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","San bene' ga bkache' nisdon' Faraón, benne' wnná bi'e benne' Egipto ka', benne' ka' žjake' ḻo wdiḻe. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","¡Le wká'n ẕen Dios, Bennen' bchi'e benne' chie' ka' ladjw latje dach! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","¡Le wká'n ẕen Dios, Bennen' bete' benne' wnná bia' ka'! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Bete' benne' wnná bia' waḻe ka'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Bete' Sehón, bennen' wnná bi'e benne' amorreo ka'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Bete' Og, bennen' wnná bi'e benne' yež Basán ka'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Bdie' yežlyó chegak benne' ka' ḻo na'gak benne' chie' ka'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Bneẕjwen' chegak benne' Israel ka', benne' wen žin chie' ka'. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Žejsá' ḻaže'e žo'o kate' ẕdíḻ-ḻengak benne' ka' žo'o. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Beslé' žo'o ḻo na'gak benne' ka' bzéx̱jwgake' žo'o. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Ẕwawe' yógo'te da' zej zoan nbángaken. Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","¡Le wká'n ẕen Dios che ya'abá! Zóateze yeḻa' žeyache' ḻaže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Žoa'a yegw da' ẕden ḻo yežlyó Babilonia, wže'žo ga na', na' wžeẕžo katen' bejsá' ḻáže'žo che yež Sión. ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Ḻo ni'a na' yag labada' žoa'a yegon' bgáḻa'žo da' ka' ẕgoḻžo. ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Benne' ka' bché'gake' žo'o ka benne' zej ndo'w ka' wnnábgekle' žo'o goḻžo. Benne' ka' bchínnjgake' yež chežo góžgake' žo'o yebelžo, na' wnnágake': “Le goḻ cheto' da' ka' beḻ-le ḻo yež Sión.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","¿Nakx̱kze gak goḻžo da' wká'n ẕenžo X̱anžo Dios, ga zoato' ḻo yežlyó ni chegak benne' zi'to' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Cha' gaḻ ḻaža'a yež Jerusalén, ẕnnabla' Dios gone' ga wnít na'a ḻi ža yeḻa' waḻ chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Ẕnnabla'-ne' gone' ga ta' loža'a chichjla' cha' bi chejsá' ḻaža'a che yež Jerusalén, na' cha' bi wká'n ẕenan'. Yežen' naken da' žaz ḻáže'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","X̱ana' Dios, bejsá' ḻaže' da' ẕinnj da' bengak benne' Edom ka' ḻo ža katen' bchínnjgake' yež Jerusalén, na' wnnágake': “¡Le wchinnjen! ¡Le wchinnjen, na' zejte ḻo lenen!” ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Ḻe'e, benne' Babilonia ka', kwia yi'le. Ba nez ẕen gaken che bennen' gone' chele kan benle ḻe'e cheto' neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Ba nez ẕen gaken che bennen' ke'e x̱kwide' chele ka' na' wzoẕje' ḻégakbe' ḻo yej x̱e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","X̱ana' Dios, dot ḻaža'a we ḻawa' Le'. Žóḻteza' da' žoe ḻawa' Le' ḻawgak dios ka' chegak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ẕzoa ẕiba' ḻo yodo' la'y chio', na' ẕka'n ẕena' La la'y chio' dan' nako' ḻi ḻaže', na' žeyache' ḻáže'lo' benne' chio' ka', na' dan' bḻoe'elo' ḻaw nako' Benne' ẕente, na' ẕente nak x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Kate' bḻiža' Le', na' gókḻeno' neda'. Ḻen yeḻa' wak chio' ben chocho' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Yógo'te benne' wnná bia' ka' nníta'gake' yežlyó nga we ḻáwgake' Le', X̱ana' Dios, dan' ba béngekle' da' ẕnna x̱tižo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Góḻgake' che da' ben X̱anžo Dios, dan' ẕente nak yeḻa' ẕen che X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Ẕente nak X̱anžo Dios, na' žákḻene' benne' gax̱jw ḻaže' ka', san bi žwi'e latje benne' ẕka'n ẕen kwine' žine' ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Kate' že' zedla', Le' žon chocho' neda'. Ẕlago' benne' ka' bi ẕḻé'egekle' neda' chawe', na' ḻen yeḻa' wak chio' žesló' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Gon X̱anžo Dios da' wchebe ḻaže'e chia'. X̱ana' Dios, žeyache' ḻáže'tezlo' benne' chio' ka'. Bi wsano' žono' žin da' wzó ḻawo' žonon'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","X̱ana' Dios, ba bwíakzo' neda' na' binlo nónbi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Nnézkzelo' kate' ži'a, na' kate' ẕzo ža'a. Zíto'le nnézkzelo' da' yo'o yichj ḻáẕda'wa'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ẕwíakzo' da' žona', na' da' žezá' ḻaža'a. Nnézkzelo' yógo'te da' žona'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Kate' bi na' wchaḻja', ba nnézkzelo' Le', X̱ana' Dios, yógo'te da' nnia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Gáte'tezle kwita' neda' zoakzo' Le', X̱ana' Dios, na' no'o žon chochen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Dan' ẕente nak da' nnezlo' Le' žonen ga žebanla'. Nakḻe'en sina', na' bi gak chejni'ilan'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","¿Gaẕ gak cha'a zi'to' gan bi zoakze Be' La'y chio'? ¿Gaẕ gak wẕonnja' gan bi zoakzo' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Cha' kwena' sibe ẕan ya'abá, zoakzo' Le' ga na'. Cha' yetja' ḻo da' gže' che yežlyó, zo' Le' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Chela' sáke'la' tia' ḻo be', na' cha'a zi'to' gan ẕḻa' wbíž, o tia' yecheḻa'ale nisdo' gan žen wbíž, ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ḻezka' sóaḻeno' neda' ga na', na' no'o ḻi ža gon chochen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Chela' gak gona' ga wkache' da' choḻ neda', o gona' ga yeyák choḻ baní' da' nyechjlen neda', ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","da' choḻ na' bi gak wkachen' neda' ḻawo' Le', na' yel yeyaken ka te ža ḻawo' Le'. Lébeze ka zej nak da' choḻ, na' yeḻa' baní' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Le' beno' da' ka' zej yo'on ḻo beḻa' žen chia'. Le' bzo'o neda' ḻo ḻe'e x̱na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Wká'n ẕenkza' Le' dan' ẕente nak da' žono', na' žebanla' ka naken. Dot ḻaža'a nnézkzela' naken ki. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Bḻe'ekzlo' neda' kate' wyá'a žit yoa'a, katen' wzóa' ḻo ḻe'e x̱na'a, katen' bgola' ḻo da' bagáche'ze ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Bḻe'elo' beḻa' žen chia' kate' wyá'n. Yógo'te da' ki bzojon' ḻe'e yiche chio', na' wdé na' wyá'n, na' yógo'ten gókgaken kan zej nyejwn. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","X̱ana' Dios, ẕente zej nak da' žezá' ḻažo'o gono'. Da' zante zej naken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Cha' gak ḻaža'a wlaba' ka zej naken, zej nyanen ka yož dan' žen' žoa'a yegw ẕen. Kate' žebana', na' zóaḻenkza' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","X̱ana' Dios, da' likze goto' benne' wen da' ẕinnj ka'. Che ḻen le kwas gan zoa', ḻe'e, benne' wet benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Ẕnnégake' chio' Le', Dios. Benne' ka' bi ẕḻé'egekle' Le' chawe' ẕzétjgake' dáche'ze La la'y chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","X̱ana' Dios, bi ẕḻe'ela' chawe' benne' ka' ẕzóagake' Le' cheḻa'ale, na' ẕžá'aḻi'a benne' ka' ẕží'igake' chio' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Dot ḻaža'a bi ẕḻe'ela' chawe' benne' ka'. Žekla' ẕži'igak benne' ka' chekza' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Bwíakze neda', X̱ana' Dios, na' bwia da' yo'on yichj ḻáẕda'wa'. Bwia neda' nich nnezlo' da' ẕza' ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Bwia cha' zoaḻen to da' ẕinnj neda'. Bzoa neda' ḻo nez chawe' chio' dan' zoan to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","X̱ana' Dios, beslá neda' ḻo na'gak benne' wen da' ẕinnj ka' nich bi gongak benne' yichj ža'a ka' neda' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Benne' ki žíljgake' da' ẕinnj da' góngake'. Tža tža ẕdíḻ-ḻengake' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Da' ẕnnágake' naken ka laye' bele da' zej ntochen'. X̱tíža'gak benne' ka' zej naken ka nis snia che bele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","X̱ana' Dios, bi go'o latje benne' wen da' ẕinnj ka' góngake' chia' da' ẕinnj. Beslá neda' ḻo na'gak benne' yichj ža'a ka', benne' ka' žon byéngake' chejchégoa'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Benne' ka' ẕka'n ẕen kwíngake' wlékgake' to da' senen neda'. Bzáḻjgake' do yeḻj žoa'a nez. Wlékgake' da' ka' séngaken neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Goža' X̱ana' Dios: “Le' nako' Dios chia'. X̱ana' Dios, benle chi'a kate' žḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","X̱ana' Dios, nakkzo' Benne' weslá chia'. Le' wdape chi'o yichja' ḻo ža gok wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","X̱ana' Dios, bi go'o latje gak kan žak ḻáže'gak benne' wen da' ẕinnj ka'. Bi go'o ḻégake' latje góngake' da' ẕza' ḻáže'gake' nich bi wká'n ẕen kwíngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Zej nyechjle benne' wen da' ẕinnj ka' neda'. Ben ga gak chegak benne' ka' kan žénegekle' góngake' chegak benne' yoble ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Ben ga yex̱jw yi' ḻo yichjgak benne' ka'. Ben ga chejchazgak benne' ka' ḻo yin'. Ben ga chejchazgake' ḻo da' gže'ḻe'e gan batkle yežójgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Bi go'o latje bennen' ẕnne zi'e ga'ne' ḻo yežlyó. Ben zi' benne' yichj ža'a, dan' wžía yin' ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Nnezla' yechebe X̱anžo Dios che no benne' gax̱jw ḻaže', na' wzóa choche' da' ka' zej yo'on ḻo na'gak benne' yache' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Da' likze benne' chawe' ka' we ḻáwgake' La la'y chio', na' benne' ḻi ḻaže' ka' sóagake' gan zo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","X̱ana' Dios, žḻiža' Le'. Da ka' gaze gákḻeno' neda'. Benle chi'a kate' wḻiža' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Ben ga kwen da' ẕnnabla' ḻawo' Le' ka to žen ẕix̱. Wẕí' da' ẕchisa' ḻawo' Le' ka to biado' žota'-ba' ḻawo' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","X̱ana' Dios, wdape chi'i žoa'a nich bi nnia' to da' bi nak chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Bi go'o latje se ḻaža'a gona' to da' ẕinnj nich bi gona' to da' bi nak chawe', na' nich bi gáwḻena' benne' wen da' ẕinnj ka' tẕen che lni chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Cha' to benne' chawe' wsake'e neda', gaken chia' to da' chawe', na' cha' tiḻe' neda', gaken chia' ka to da' ẕlaḻe'e ẕix̱ dan' ẕgo'e yichja', na' nnábtezla' Dios gon chawe'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Kate' bíx̱jegak benne' blo ka' chegak benne' wen da' ẕinnj ka' ḻe'e ya'a yej ka', na' gákbe'egekle benách ka' nak chawe' da' ẕnnia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Gáslasgak žit chegak benne' ka' žoa'a yežw ba chégake'. Gá'ngaken ka bcheko yo ka' gan ža'n beže. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Che ḻen ẕwia' gan zo' Le', X̱ana' Dios. Žx̱en ḻaža'a Le'. Bi kwej yichjo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Bwia neda' nich bi sen do yeḻj chegak benne' wen da' ẕinnj ka' neda', na' nich bi chejchaza' ḻo da' wlékgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Ben ga chejchazgak benne' wen da' ẕinnj ka' ḻo do yeḻj da' wlékgake', x̱ak tia' neda' ga na' dot cháwe'do'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Neda' ẕnnia' zižje, žḻiža' X̱anžo Dios. Dot ḻaža'a ẕnnabla' X̱anžon' yeyache' ḻáže'le' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Ḻawo' Le' žawa' ẕia che da' žak chia'. Ḻawo' Le' ẕḻoe'ela' že' zedla' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Kate' že' ḻáẕda'wa' zedḻe'e, Le', X̱ana' Dios, nnezlo' da' žaken chia'. Wlékgake' to do yeḻj ḻo x̱neza', nich senen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Ẕwia' kwitla', san bi zoa no benne' gákḻene' neda'. Bi zoa no benne' gape chi'ikze' neda'. Bi zoa no benne' kwi'e wnné yoe chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Žḻiža' Le', X̱ana' Dios, ẕnnia': “Žx̱en ḻaža'a tozo' Le'. Tozo' Le' žaz ḻaža'a ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Benle da' žḻiža' Le', dan' ẕzáka'ḻi'a. Beslá neda' ḻo na'gak benne' ka' ẕbia ḻáže'gake' neda', na' zej nakže' waḻe ka neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Bebéj neda' ḻo da' žaken chia' nich gak we ḻawa' Le'. Benne' chawe' ka' chéchjgeke' neda' kate' gon chawo'o neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","X̱ana' Dios, benle da' ẕnnia' ḻawo' Le'. Bze nag da' ẕnnabla' Le'. Da gákḻeno' neda' dan' nako' ḻi ḻaže', na' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Bi wchi'a ḻažo'o neda', wen žin chio', ka nak da' nbaga'a, dan' ḻawo' Le' bi zoa no benne' nake' dot ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Gokḻen neda' dan' benne' ka' ẕžá'agake' neda' ẕbia ḻáže'gake' neda'. Yeláte'ze ka bétgake' neda'. Béngake' ga naka' ka to benne' ẕde' ḻo da' choḻ kan žak chegak benne' gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Že' ḻáẕda'wa' zedḻe'e, na' žak nyache' ḻáže'ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Žejsá' ḻaža'a kan gok ža ni'te. Ẕlab ḻaža'a ka nak yógo'te da' beno'. Žejsá' ḻaža'a ka nak da' ẕente da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Ẕchis na'a ḻawo' Le'. Naka' ka to yežlyó biž, ẕbiḻa' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Da ka' gaze gákḻeno' neda', X̱ana' Dios. Dan' žedó ḻaža'a bi žel-lo' gákḻeno' neda' nich bi gaka' ka to benne' yoe'e yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Zildo' ben ga chejsá' ḻaža'a žeyache' ḻáže'lo' benách chio' ka' dan' žx̱en ḻáže'kza' Le'. Bzejní'il neda' ka žaḻa' gona' dan' žak ḻaža'a gona' da' žaz ḻažo'o Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","X̱ana' Dios, beslá neda' ḻo na'gak benne' ka' ẕžá'agake' neda'. Ẕzoa kwina' ḻo no'o nich gape chi'ikzo' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Bsedle neda' nich gona' da' žaz ḻažo'o Le', dan' nako' Le' Dios chia'. Bseḻa' Be' La'y chawe' chio' nich chi'e neda' ḻo nez chawe' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Nich gak bian' nako' chawe', X̱ana' Dios, ben choch neda'. Dan' nako' chawe', yesló' neda' ḻo da' žak chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Dan' nako' ḻi ḻaže', wžía yi'o benne' ka' ẕžá'agake' neda'. Wžía yi'o benne' ka' žénegekle' wžía yí'gake' neda' dan' naka' neda' wen žin chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","¡Ga'n ẕen X̱anžo Dios, Bennen' ẕzoa choche' neda'! Ḻekze' žon choche' na'a nich gak cha'a ḻo wdiḻe. Žon choche' x̱ben na'a nich tíḻ-ḻena' benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Ḻekze' žeyache' ḻáže'le' neda', na' nake' ka to yo'o gan že' chawa'a. Žon choche' neda', na' žeslé' neda'. Žape chi'e neda', na' žx̱en ḻaža'a Ḻe'. Žone' ga žongak benne' chia' ka' da' žapa' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","X̱ana' Dios, ¿biẕkze zej nak benne' ka', dan' žejsá' ḻažo'o chégake'? ¿Biẕ zej nak benne' ka' dan' ži'o wnné yoe chégake'? ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Zej nak benne' ka' ka to da' ẕnitlen. Zej nak ža chégake' ka to ẕoḻ dan' ẕdezen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","X̱ana' Dios, bsaljw ẕan ya'abá. Betj gákḻeno' neda'. Bta ya'a ẕen ka', na' žoj žen che yi'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Bzaḻa' yes wzió' ka', na' bsejw x̱nezgak benne' wen da' ẕinnj ka'. Bse yag ntóche'do' chio' ka', na' bžia yi'-gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Gan zo' na'le, bze no'o, na' beslá neda' ḻo da' zedḻe'e gan ži'a. Beslá neda' ḻo na'gak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Benne' ka' ẕnnátezegake' da' wen ḻaže', na' ẕzétjgake' Dios katen' žon ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","X̱ana' Dios, goḻkza' chio' to da' kob, na' wgoḻa' da' žóḻ-ḻento'. Ḻen da' žóḻ-ḻento' da' nwan' chi do goḻkza' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Žonkzo' Le' ga žežojgak chawe' benne' wnná bia' ka'. Besló' Dabí, benne' wen žin chio', ḻo ya ntoche' ka' chegak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Beslá neda' ḻo na'gak benne' zi'to' ka'. Benne' ka' ẕnnátezegake' da' wen ḻaže', na' ẕzétjgake' Dios katen' žon ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Ben ga gólegak bi' byo cheto' ka' kan ẕgólegak yag ka' ḻo yo bebe. Ben ga gakgak bi' no'le cheto' ka' ka zej nak yag x̱tanḻe'e ka' nníta'gaken ḻi'a che to yo'o ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Ben ga cha'gak ližto' ka' yógo'te kwe' linne cheto'. Ben ga chanḻe'e bia yix̱e' cheto' ka', nich gakgak bia yíx̱e'do' zanḻe'e ḻo yežlyó cheto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Ben ga gakgak beže cheto' ka' bia waḻe ka' nich gónḻe'egakba' žin. Ben ga bi wsángakba' bia že'ndo' ka' kate' bi na' žin byo' chégakba'. Ben ga bi soa no benne' kweže nyache'e ḻo yež cheto'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Ba nez ẕen naken chegak benne' ka' žaken ki chégake'. Ba nez ẕen naken chegak benne' ka' X̱anžon' nake' Dios chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Wká'n ẕena' Le', Dios chia'. Nako' Le' Benne' Wnná Bia' Ẕen chia'. Wká'n ẕénteza' La la'y chio' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Tža tža wká'n ẕena' Le'. Wká'n ẕénteza' La la'y chio' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Ẕente nak X̱anžo Dios, na' nak chie' we ḻáwtezežo Ḻe'. Batkle gak gónbia'žo ka ẕente nake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Yógo'te kwe' benne' chio' ka' yéngekle' da' beno' Le' na' wzéngekle' yezika' benách ka nak da' ẕente na'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Wláb ḻaža'a ka nak yeḻa' ẕen che yeḻa' wak chio', na' ka nak da' ẕente ka' da' beno'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Yógo'te benne' ka' wcháljgake' ka nak yeḻa' wak che da' ẕente da' beno', na' neda' wzenla' ḻégake' ka nak yeḻa' ẕen chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Wzéngekle' ljéžgake' ka' ka nak yeḻa' ži'i ḻaže' ẕen chio', na' góḻtezegake' kan nako' Le' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","X̱anžo Dios nake' ži'i ḻaže', na' žeyache' ḻáže'le' benne' chie' ka'. Nake' ẕen ḻaže', na' žeyache' ḻáže'ḻe'ele' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","X̱anžo Dios žon chawe'e yógo'te benne' ka', na' žeyache' ḻáže'le' yógo'te da' zóagaken nbángaken, da' ka' bene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Yógo'te da' ka' beno' wká'n ẕéngaken Le', X̱anto' Dios na' benne' chio' ka' we ḻáwgake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Ẕcháḻjgake' ka ẕente nak yeḻa' wnná bia' chio'. Ẕcháḻjgake' ka nak yeḻa' wak ẕente chio' ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","nich wzéngekle' yógo'te benne' ka' ka zej nak da' ẕente ka' da' beno', na' ka nak yeḻa' ẕen che yeḻa' wnná bia' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Yeḻa' wnná bia' chion' sóatezen, na' nna bi'o yógo'te kwe' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Nox̱w X̱anžo Dios yógo'te benne' ka' žejchégwgake'. Žechise' yógo'te benne' ka' zej ndo'e ḻo žin waḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Yógo'te benne' ka' ẕbézgake' Le' gákḻeno' ḻégake', na' Le' wneẕjo' da' gáwgake' kate' gaḻa' chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ḻo yeḻa' ži'i ḻaže' chio' ẕze no'o. Ẕneẕjo' da' žiážjegekle yógo'te da' zóagaken nbángaken. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Chawe' nak X̱anžo Dios ḻo yógo'te da' žone', na' ḻi ḻaže' zej nak yógo'te da' žone' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","X̱anžo Dios zóateze' gákḻene' yógo'te benne' ka' žḻížgake' Ḻe', yógo'te benne' gax̱jw ḻaže' ka' žḻížgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Gone' da' žak ḻáže'gak benne' ka' ẕžébegake' Ḻe'. Ḻezka' yenle' chégake' kate' wḻížgake' Ḻe', na' yeslé' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","X̱anžo Dios žape chi'ikze' yógo'te benne' ka' zej nži'ile' Ḻe', san wžía yi'e yógo'te benne' ka' ẕbej yíchjgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Dot ḻaža'a wká'n ẕena' X̱anžo Dios. Yógo'te benne' ka' žaḻa' we ḻáwgake' La la'y chie' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","¡Ga'n ẕen X̱anžo Dios! Dot ḻaža'a žoe ḻawa' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","X̱ak zoa' nbana' wká'n ẕena' X̱anžo Dios. Góḻteza' da' we ḻawa' X̱anžo Dios x̱ak zoa' nbana'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Bi wx̱én ḻáže'le benne' wnná bia' ka', na' bi wx̱én ḻáže'le benne' waḻe ka', dan' bi gak yeslágake' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Žežój be' zej yoe'e, na' yeyákgake' bix̱te yo. Ḻo ža na'kze nitle da' gok ḻáže'gake' góngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Ba nez ẕen naken che bennen', žakḻen Dios che Jakob ḻe', bennen' žx̱en ḻaže'e X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Dios na'kze bene' ya'abá, na' yežlyó, na' nisdo', na' yógo'te da' ka' zej nnitan' latje ka'. Nake' Bennen' žónteze' da' ḻi ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Ẕchi'a ḻaže'e benne' nyache' ḻaže' ka', na' ẕwawe' benne' ka' ẕdóngake'. X̱anžo Dios žeslé' benne' ndo'w ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","X̱anžo Dios žeyone' yej ḻawgak benne' ḻo choḻ ka'. X̱anžo Dios žechise' benne' ka' žejchégwgake'. X̱anžo Dios nži'ile' benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","X̱anžo Dios žape chi'e benne' zi'to' ka'. Žákḻene' bi' wzebe ka', na' no'le wzebe ka', san ẕchinnje' da' žongak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Ḻe'e, benne' yež Sión, ẕnna bia'kze X̱anžo Dios. Ẕnna biá'teze Dios to chi'ize. ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","¡Le wká'n ẕen X̱anžo Dios! Nak chawe' goḻžo da' we ḻawžo Dios chežo. Dot ḻáže'žo žaḻa' wká'n ẕenžo-ne'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","X̱anžo Dios yeyone' yež Jerusalén. Yechi'e benne' Israel ka' zej zoe' yež zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Žeyone' benne' ka' nyache' ḻáže'gake', na' ẕde'e ḻégake' laže' gan zej žia we' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Nnézkzele' baḻ belj ka' nníta'gaken. To to belj ka' žwe'e lan. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Ẕente nak X̱anžo Dios, na' nape' dot yeḻa' wak. Bi be de da' bi žejni'ile' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","X̱anžo Dios žákḻene' benne' gax̱jw ḻaže' ka', san ẕzex̱jwe' benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","¡Le goḻ da' wká'n ẕenle X̱anžo Dios! ¡Le goḻ, na' le wchínnj da' ka' ẕgoḻ-le ḻaw Dios chežo! ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Ḻe' ẕnnite'e bejw ka' ẕan ya'abá. Ḻe' žseḻe'e nis yejw ḻo yežlyó. Ḻe' žone' ga žiagak yíx̱e'do' ka' ḻaw ya'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Ḻe' ẕneẕjwe' da' žawgak bia yix̱e' ka'. Ẕneẕjwe' da' žawgak sechjdo' ka', bia ka' ẕbéžeya'agakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Da' žaz ḻaže'e bi naken yeḻa' waḻe chegak bžina' ka', na' kege yeḻa' waḻe chegak benne' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","san žaz ḻaže'e benne' ka' ẕžébegake' Ḻe', na' benne' ka' žx̱en ḻáže'gake' Ḻe' nich yeyache' ḻáže'le' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","¡Le wká'n ẕen X̱anžo Dios, ḻe'e zoale yež Jerusalén! ¡Le wká'n ẕen Dios chele, ḻe'e zoale yež Sión! ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Ḻe' ẕzoa choche' ze'e da' žape chi'in yež chele. Žon chawe'e benne' ka' nníta'gake' yež chele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ẕzoe' yeḻa' ẕga'n chawe' ḻo yežlyó chele. Gónnḻi'e chele ẕoa' cháwe'ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Žseḻe'e x̱tiže'e chegak benách yežlyó ka', na' ka' gaze žak da' ẕnne'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Ẕwakwe' yežlyó ḻen bege' da' naken ka ẕila'. Ẕzex̱jwe' x̱le'l yel ka de. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Žone' ga žex̱jw yej nis ka yejdo' ka'. ¿Noẕ benne' gak soele' da' zag chen? ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Ẕnnie', na' žeyaken nis. Žone' ga žak be', na' žeyák begen' nis wbá'a. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Bzejni'ile' Jakob ka nak x̱tiže'e, na' bdie' da' bsedle', na' da' ka' wnnakze' Ḻe' ḻo na'gak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Bi na' gone' ki che nitó yež yezika', na' benne' yež ka' bi žeyónbia'gake' x̱tiže'e. ¡Ga'n ẕen X̱anžo Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","¡Le wká'n ẕen X̱anžo Dios! ¡Le wká'n ẕen X̱anžon', ḻe'e, zoale ya'abá! ¡Le wká'n ẕene' Ḻe', ḻe'e, zoale ža'le! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","¡Le wká'n ẕene' Ḻe', ḻe'e, wbás che ya'abá chie' ka'! ¡Le wká'n ẕene' Ḻe', ḻe'e, benne' zante chie'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","¡Le wká'n ẕene' Ḻe', ḻe'e, wbíž, na' byo'! ¡Le wká'n ẕene' Ḻe', ḻe'e, belj žsa'ni'le! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","¡Le wká'n ẕene' Ḻe', le', ya'abá na'le, na' ḻe'e, nis ka' zoale ḻawle ya'abá! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","¡Le wká'n ẕen La la'y che X̱anžon', dan' wnnekze' Ḻe', na' wzoale! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Bene' ga zoale na'a, na' to chi'ize. Wnnakze' chele ḻe'e to da' bi te chen. ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","¡Le wká'n ẕen X̱anžon' ḻo yežlyó, ḻe'e, bia ẕen ka' zoale ḻo nisdo', na' ḻo nis zil, ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","na' ḻe'e, yes wzió', na' yej nis, na' bege', na' bejw ka', na' ḻe'e, be' bdone' ka', žonle ka ẕnnakze' Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","¡Le wká'n ẕene' Ḻe', ḻe'e, ya'ado' ka', na' ya'a ẕen ka', na' ḻe'e, yag ẕix̱ ka', na' yag sedro ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","na' ḻe'e, bia yix̱e' ka', na' bia ka' napgak benne' ka', na' ḻe'e, bia snia ka', na' bia zej zoa x̱ílgakba'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","¡Le wká'n ẕene' Ḻe', ḻe'e, benne' wnná bia' ka', na' yógo'te benne' gax̱jw ḻaže' ka', na' ḻe'e, benne' blo ka', na' benne' wchi'a ḻaže' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","na' ḻe'e, benne' byo wego' ka', na' no'le wego' ka', na' ḻe'e, benne' gole ka', na' x̱kwide' ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","¡Le wká'n ẕen La la'y che X̱anžon'! Ẕénḻe'eže nak La la'y chie' Ḻe' ka yógo'te lagak benne' ka'. Yeḻa' ẕen chie' ẕḻa' ḻawn ḻo yežlyó, na' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Ḻe' benne' yela' wak ẕen chegak benne' chie' ka'. ¡Le wká'n ẕene' Ḻe', ḻe'e, benne' chie' ka', nakle ẕa'só Israel ka', na' nakle benne' ka' nži'ile' Ḻe'! ¡Ga'n ẕen X̱anžon'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","¡Le wká'n ẕen X̱anžo Dios! ¡Le goḻ che X̱anžon' to da' kobe! ¡Le wká'n ẕene' Ḻe' gan zej ndobe benne' chie' ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","¡Le yebele, ḻe'e, benne' Israel ka', ḻaw Dios, Bennen' bene' ḻe'e! ¡Le yebele, ḻe'e, zoale yež Sión, ḻaw Dios, Bennen' nake' Benne' Wnná Bia' Ẕen chele! ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","¡Le wká'n ẕen La la'y che X̱anžon', na' wya'ale! ¡Le wchoncho yid ka', na' le wchínnj da' ka' ẕgoḻ-le, nich we ḻawle Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","X̱anžo Dios žaz ḻaže'e benne' chie' ka'. Žape' ba la'ne benne' gax̱jw ḻaže' ka', na' žeslé' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Žaḻa' yebégekle benne' chie' ka' ḻo yeḻa' ẕen chie', na' góḻgake' ḻo yeḻa' žebele chégake' dot yele. ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Žaḻa' kwéžeya'agake', nich we ḻáwgake' Dios, zej noe'e ya ntoche' ka' da' zej nla žop ḻa'aten, ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","nich yezí'gake' wzón benne' zi'to' ka', na' góngake' benách yež ka' ẕia, ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","na' nich wchéjgake' benne' wnná bia' ka' do ya, na' ḻezka' benne' waḻe ka', ");
INSERT INTO ztyNTps_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","na' nich wžía yí'gake' benne' ka' ka wnnakze Dios gaken chégake'. Da' ni gaken yeḻa' ba nez ẕen chegak benne' ka' che Dios. ¡Ga'n ẕen X̱anžon'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","¡Le wká'n ẕen X̱anžo Dios! ¡Le wká'n ẕen X̱anžon' ḻo yodo' la'y chie'! ¡Le wká'n ẕen yeḻa' wak chie' ḻo ya'abá chie'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","¡Le wká'n ẕene' Ḻe' ni'a che da' ẕen da' bene'! ¡Le wká'n ẕene' Ḻe' ni'a che yeḻa' ẕen chie'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","¡Le wká'n ẕene' Ḻe', wkwéẕele lozgak bia ka'! ¡Le wká'n ẕene' Ḻe', chínnele da' žóḻ-ḻento' ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","¡Le wká'n ẕene' Ḻe', wchónchwle yid, na' wya'ale! ¡Le wká'n ẕene' Ḻe', chínnele da' ka', na' wkwéẕele bžéjwdo' ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","¡Le wká'n ẕene' Ḻe', wtiḻ-le yado' ka'! ¡Le wká'n ẕene' Ḻe', wtiḻ-le ya ẕen ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","¡Le wká'n ẕen X̱anžon', yógo'tele zoale nbanle! ¡Le wká'n ẕen X̱anžo Dios!");
INSERT INTO ztyNTps_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ẕzoja' ḻe'e yiche ni lagak x̱a x̱na' gole wdé ka' che Jesús, Benne' Criston', Bennen' nake' ẕa'só Dabí, na' ḻezka' ẕa'só Bran, benne' ka' wnnníta'gake' ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bran na' goke' x̱a Isak. Isak na' goke' x̱a Jakob. Jakob na' goke' x̱agak Judá ḻen benne' biche'e ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá na' goke' x̱agak Fares ḻen Sara. Tamar goke' x̱na'gak chope' ki. Fares na' goke' x̱a Esrom. Esrom na' goke' x̱a Aram. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram na' goke' x̱a Aminadab. Aminadab na' goke' x̱a Nasón. Nasón na' goke' x̱a Salmón. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón na' goke' x̱a Bos, na' Rahab goke' x̱ne'e. Bos na' goke' x̱a Obed, na' Rut goke' x̱ne'e. Obed na' goke' x̱a Isaí. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí na' goke' x̱a Dabí. Dabín' wnná bi'e benách Israel ka', na' bchag ná'ḻene' no'len' zga'ale goke' ẕo'le Urías. Dabín' ḻen no'len' gókgake' x̱a x̱na' Salomón. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón na' goke' x̱a Roboam. Roboam na' goke' x̱a Abías. Abías na' goke' x̱a Asa. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa na' goke' x̱a Josafat. Josafat na' goke' x̱a Joram. Joram na' goke' x̱a Usías. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usías na' goke' x̱a Jotam. Jotam na' goke' x̱a Akás. Akás na' goke' x̱a Esekías. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekías na' goke' x̱a Manasés. Manasés na' goke' x̱a Amón. Amón na' goke' x̱a Josías. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías na' goke' x̱agak Jekonías ḻen benne' biche'e ka'. Benne' ki wnníta'gake' ža na' katen' benne' Babilonia ka' bché'gake' benne' Israel ka' zej nžeje' gan nbab Babilonia na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jekonías na' goke' x̱a Salatiel. Salatiel na' goke' x̱a Sorobabel. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel na' goke' x̱a Abiud. Abiud na' goke' x̱a Eliakim. Eliakim na' goke' x̱a Asor. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor na' goke' x̱a Sadok. Sadok na' goke' x̱a Akim. Akim na' goke' x̱a Eliud. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud na' goke' x̱a Eleasar. Eleasar na' goke' x̱a Matán. Matán na' goke' x̱a Jakob. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob na' goke' x̱a Jwsé. Jwsén' goke' benne' byo che Lia. Lian' goke' x̱na' Jesús, Benne' Criston', Bennen' žx̱en ḻáže'gak benne' judío ka' ḻe'e nich nna bi'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ki goken, gokgak x̱da' kwe' ẕi'n sógake' kate' wzó ḻaw wzóa Bran, na' zejte wzóa Dabí. Ḻezka' gokgak yex̱dá' kwe' ẕi'n sógake' kate' wzó ḻaw wzóa Dabín', na' zejte bche'gak benne' Babilonia ka' benne' Israel ka' zej nžeje'. Ḻezka' gokgak yex̱dá' kwe' ẕi'n sógake' kate' wzó ḻaw bché'gake' ḻégake', na' zejte ža bḻa' Benne' Criston'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ki goken kate' bḻa' Jesús, Benne' Criston'. Katen' ba bchebe ḻaže' Lia, x̱na' Jesús, Benne' Criston', wchág ná'ḻenbe' Jwsé, na' kate' bi na' wchág ná'ḻene'-be', wyó'o to bi'do' ḻe'be'. Ki goken ni'a che yeḻa' wak che Dios Be' La'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nak Jwsén', benne' byo che Lian', benne' chawe', san bi gónele' yesbage'e-be' ẕia ḻawgak benách ka'. Gónele' wsane'-be' ži žize. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kate' ne ẕza' ḻaže' Jwsén' kan gone', bḻa' ḻaw to wbás che ya'abá ḻo bichgale gan de Jwsén', na' gože' ḻe': —Jwsé, ẕa'só Dabí. Bi žebo' si'o Lian', nich gakbe' ẕo'lo', dan' bi' byodon' za' galjbe', yo'obe' ḻe'be' ni'a che yeḻa' wak che Dios Be' La'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Galj to bi' byodo' chebe', na' go'o labe' Jesús, dan' yeslabe' benách chebe' ka' ḻo doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ki goken, bžin dan' wnná X̱anžo Dios ḻo na' benne' bchaḻje' ḻo wlaze' Ḻe', katen' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Le wia nga, to x̱kwide' no'le, wa'be' bi'do' ḻe'be', na' galj to bi' byodo', na' wé'gake' labe' Emanuel. Emanuel naken to diža' hebreo dan' ẕnnan: “Zoaḻen Dios žo'o.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kate' bebán Jwsé ḻo bichgalen', bene' kan gož wbás che ya'abán' ḻe', na' wẕi'e Lian', na' gokbe' ẕo'le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bi wzóaḻene'-be' na' zejte golj bi' byodo' chebe', bi' nežw chebe', na' bzóagake' labe' Jesús. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kate' golj Jesusen' ḻo yež Belén, yežen' nbaben Judea, ẕnna bia' Herodes ga na'. Kate' ža na' bžingak benne' žejní'il ka' ḻo yež Jerusalén, benne' ka' zej nžoje' to yež zi'to' da' žen' zaka' gan ẕḻa' wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wnnabgak benne' ka', na' wnnágake': —¿Gaẕen' zoa x̱kwiden' žaḻa' nna bia'be' benne' judío ka', x̱kwiden' za' goljbe'? Katen' wzoato' gan ẕḻa' wbíž bḻe'elto' belj baní' da' nak bian' ba goljbe'. Za'to' nga nich wká'n ẕento'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kate' Herodes, bennen' ẕnna bi'e, benle' da' ni, gok zedle'. Ḻezca' gok zédgekle yógo'te benne' ka' wnníta'gake' yež Jerusalén. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Naž Herodes na' bḻiže' yógo'te bx̱oz wnná bia' ka' ḻen benne' yodo' wsedle ka', na' wnnable' ḻégake' gaẕe žaḻa' galj Benne' Criston', Bennen' žx̱en ḻáže'gak benne' judío ka' ḻe'e nich nna bi'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Góžgake' ḻe': —Ḻo yež Belén, da' nbaben Judea. Ki naken dan' bzoj to benne' bchaḻje' ḻo wláz Dios da' ẕnnan ki: ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yež Belén, da' nbaben Judá, bi nakžen ka'ze ḻaw Dios, ka zej nak yež blo ka' zej nnitan' yežlyó nga, dan' ḻo yež Belén na' galj to Benne' gake' blo, Bennen' gape chi'e benách chia' ka', benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Naž Herodes na' bḻiže' benne' žejní'il ka' ži žize, na' wnnable' ḻégake' nich nnezle' binlo gáka'te ba gok katen' bḻa' ḻaw beljen' da' bḻé'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naž bseḻe'e ḻégake' chjake' ḻo yež Belén. Gože' ḻégake': —Le chej ga na', na' le chejnnáb binlo kan nak che x̱kwiden'. Kate' ba bežéḻ-lele-be', le da nich wḻoé'elele neda', nich ḻezka' cha'a neda', chejká'n ẕena'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wdé béngekle benne' žejní'il ka' dan' wnná Herodes na', jake' ga na', na' beljen' da' bḻé'egekle' katen' wnníta'gake' lážgake', wyejen ḻáwlegake', na' bejsóan ža'le gan de x̱kwiden'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kate' bḻé'egekle' beljen', bebéḻe'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kate' wyó'ogake' ḻo yo'on', bḻé'egekle' bi' byodon', zóaḻenbe' Lia, x̱na'be'. Naž bzoa ẕíbgake' ḻawle gan debe', na' bka'n ẕéngake'-be'. Wdé na' bsáljwgake' kakdo' ka' chégake', na' bnéẕjwgake'-be' oro, na' yale, na' neždo' da' ẕḻa' ẕix̱ che yag mirra. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dan' ba bzejní'il Dios ḻégake' ḻo bichgale nich bi yeyéjgake' gan zoa Herodes na', che ḻen beyéjgake' lážgake' nez yoble. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wdé beza'gak benne' žejní'il ka' ga na', naž bḻa' ḻaw to wbás che ya'abá ḻo bichgale gan ẕtas Jwsé, na' gože' ḻe': —Wyase. Bche' x̱kwiden' ḻen x̱na'be', na' bẕonnj nga. Wyéj ḻo yežlyó Egipto. Ga'no' ga na' kate' yapža' neda' le' yetó. Ki gono' dan' yeyílj Herodes x̱kwide' ni nich gote'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Naž wyase Jwsén', kate' ne nak žel, na' bchi'e x̱kwiden' ḻen x̱na'be', na' jake' ḻo yežlyó Egipto. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bgá'ngake' ga na' na' zejte got Herodes na'. Ka' goken, bžin da' wnná X̱anžo Dios ḻo na' benne' bchaḻje' ḻo wlaze' Ḻe', katen' wnné': “Ḻo yežlyó Egipto bḻiža' Ẕi'na'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kate' gókbe'ele Herodes bi bengak benne' žejní'il ka' kan gože' ḻégake', naž bže'e, na' bseḻe'e benne' ka' chjake' ga na' nich gótgake' yógo'te bi' byodo' ka' nníta'gakbe' ḻo yež Belén, na' do ẕente gan že' Belén na', x̱kwide' ka' ba žóngakbe' chopiz, ḻen bi'do' ka' zej nžé'nžebe'. Ki ben Herodes na' kan bsaka' yenne'e, kan gok ža katen' bḻa' ḻaw beljen', ža na' bzejní'igekle benne' žejní'il ka' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ka' goken, bžin da' wnná Jeremías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, katen' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ḻo yež Ramá žéngekle chi'igak benne' ka' ẕbéžegake', na' ẕbeže nyáche'gake'. Rakel ẕbeže' ni'a chegak ẕa'sóe' ka'. Bi gak no benne' gon ẕene' ḻe', dan' zej natbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wdé got Herodes na', naž bḻa' ḻaw wbás che ya'abán' ḻo bichgale gan zoa Jwsén' ḻo yežlyó Egipto, ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na' gože' ḻe': —Wyase. Beché' bi' byodon' ḻen x̱na'be', na' beyéj gan nbab Israel, dan' ba gotgak benne' ka' gónegekle' gótgake' bi' byodo' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naž wyase Jwsén', na' bechi'e bi' byodon' ḻen x̱na'be', na' beyéjgake' gan nbab Israel. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Benle Jwsén' ẕnna bia' Arkelao gan nbab Judea dan' ba got Herodes na', x̱a Arkelaon'. Che ḻen bžebe Jwsén' yeyeje' ga na'. Kate' bzejní'il Dios ḻe' ḻo bichgale, wyeje' gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kate' bžine' ga na', bejsóe' ḻo yež Nasaret. Ki goken, bžin da' bzojgak benne' ka' bcháḻjgake' ḻo wláz Dios ža ni'te kan žaḻa' gak che Jesusen', nnagak benách ka' nake' Benne' Nasaret. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kate' ža ka' bḻa' ḻaw Ẕwa, bennen' bezóe' benách ka' nis, na' bchaḻje' ḻo latje dach gan nbab Judea. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ẕwan' wnné': —Le yeyát ḻaže', dan' za' žin ža kate' Dios, Bennen' zoe' ya'abá chie', yedjnná bi'e ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kan nak che Ẕwan', bzoj Isaías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, da' ẕnnan ki: Ženl chi'i to benne' ẕbéžeyi'e zižje ḻo latje dach, ẕnne': “Le gon chawe' nez nich ḻa' X̱anžon' gan zoale. Le yebéj ḻi nez ḻas gan tie'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Gokw Ẕwan' laže' da' nžaben ḻen yicha' bia ka', na' nžeje ḻi'e to bayw yid. Žawe' biche' zo ka', na' že'je' china' bezdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Benne' Jerusalén ka' ḻen benne' ka' zej nžoje' dot gan nbab Judea, na' dot kwit gan ẕde yego Jordán, bḻá'gake' gan zoa Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kate' bex̱óalapagake' doḻa' da' zej nbage'e, Ẕwan' bezóe' ḻégake' nis ḻo yego Jordán na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kate' Ẕwan' bḻe'ele' benne' zan ka', benne' yodo' fariseo ka' ḻen benne' yodo' saduseo ka', želžine' gan zoe' nich yezóagake' nis, gože' ḻégake': —Ḻe'e, lježgak bele snia ka'. ¿Zoa no benne' bzejni'ile' ḻe'e wẕonnjle dan' za' chog Dios chegak benách ka' gátgake'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Le gon da' gak bia' ba beyát ḻáže'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bi kwek yichjle, bi nnale nakle chawe' dan' nakle ẕa'só Bran, dan' žapa' ḻe'e, wak gon Dios ga yeyakgak yej ki ẕa'só Bran na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ba ẕbez ya wage nich chogen yag ka', dan' ẕḻoe'elen kan gak chele. Yógo'te yag ka' da' bi želbían da' zej naken ẕix̱, chóggaken, na' chéygaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Da' li neda' žezóa' ḻe'e nis ḻo nis, nólele ba beyát ḻáže'le, san Bennen' za' ze'e kate' te chia' neda', Ḻe' gone' da' ẕḻoé'ezele yeḻa' žezóa nis ni, dan' wchize' ḻe'e Dios Be' La'y, ḻen yi' chie'. Bennen' nakže' blo ka neda', na' neda' bi naka' zi kweja' ẕele'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nox̱e' da' žẕenle' yi', na' wlobe' ẕoa' stribe chie'. Yezi'e ẕoa' stribe chien' ḻo yo'o gan gape chi'en, san wzeye' beb chen ḻo yi', na' yin' bi yeyoḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naž bezá' Jesusen' gan nbab Galilea, na' bžine' žoa'a yego Jordán gan zoa Ẕwa, nich yezóe' nis ḻo na' Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ẕwan' gónele' wsejwe' x̱neze', na' gože' Jesusen': —Neda' žaḻa' yezóa' nis ḻo no'o Le'. ¿Ẕnnabkzlo' neda' yezóa' Le' nis? ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bechebe Jesusen', na' gože' ḻe': —Be' latje na'a, dan' ki žaḻa' gonžo dot da' naken chawe' ḻaw Dios. Naž Ẕwan' bene' kan wnná Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kate' ba bezóa Jesusen' nis, ḻa' bežojtie' ḻo nis. Naž wyaljw ya'abá ḻáwe'le gan zoe', na' bḻa' ḻaw žetj Dios Be' La'y. Bžine' gan zoe', ẕnne'e ka to plomdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naž benle chi'i Benne' ẕchaḻje' ya'abá che Dios, na' wnné': —Benne' ni nake' Ẕi'na'. Nži'ila' Ḻe', na' žaz ḻaža'a Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naž Dios Be' La'y ḻa' bche'tie' Jesusen' ḻo latje dach nich gata' latje si' bia' da' x̱iwe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chopḻalj ža chopḻalj yele bi be bdaw Jesusen'. Wdé na' ẕdone'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Naž bḻa' da' x̱iwen' gan zoa Jesusen', dan' žonen ga bága'gak benách ka' doḻa', na' gožen Jesusen': —Cha' nako' Le' Ẕi'n Dios, gož yej ki yeyákgaken yet x̱til. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bechebe Jesusen', na' gožen': —Nyejw ḻe'e yiche la'y da' ẕnnan: “Kégeze yet x̱til ẕbánḻengak benách ka', san ḻezka' ḻen yógo'te x̱tiža' Dios žak bángake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naž bche' da' x̱iwen' Jesusen' ḻo yež la'y Jerusalén, gan bžian Ḻe' yichjo'o yodo' gan nak sibe. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Naž da' x̱iwen' gožen Ḻe', na' wnnán: —Cha' nako' Le' Ẕi'n Dios, bex̱ite' žé'lele, dan' nyejw ḻe'e yiche la'y da' ẕnnan: Dios seḻe'e wbás che ya'abá ka' nich gape chí'igake' Le', na' góx̱wgake' Le' ḻen ná'gake', nich bi chejchego' yej, na' bi gono' zi' ni'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bechebe Jesusen', na' gožen': —Yetó da' nyejw ḻe'e yiche la'y žen' benách ka', dan' ẕnnan: “Bi nna bi'o X̱ano' Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Naž da' x̱iwen' bchen' Jesusen' gan nak to ḻaw ya'a sibe, gan bḻoe'elen Ḻe' yógo'te yež ka' zej nnitan' yežlyó nga ḻen yógo'te yeḻa' wnni'a chégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Naž gožen Ḻe': —Yógo'te da' ki gonna' chio' cha' wzóa ẕibo' x̱ni'a, na' gapo' neda' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesusen' gožen': —Beyéj, da' x̱iwe', dan' nyejw ḻe'e yiche la'y da' žen' neto', dan' ẕnnan: “X̱ano' Dios wká'n ẕeno', na' toze x̱chine' Ḻe' gono'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Naž bezá' da' x̱iwen' gan zoa Jesusen'. Naž bḻa'gak wbás che ya'abá ka' gan zoe' nich gákḻengake' Ḻe', na' bnéẕjwgake' da' bdawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kate' benle Jesusen' nyejw Ẕwan' liž ya, wyeje' gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bezé'e ḻo yež Nasaret, na' bejsóe' ḻo yež Kapernaum gan naken žoa'a nisdo', ḻo bza' gan nbab Sabulón, na' gan nbab Neftalí. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ki goken, bžin da' wnná Isaías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, katen' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Gan nbab Sabulón, na' gan nbab Neftalí, ḻo nez žoa'a nisdo' gan zoa yecheḻá'a yego Jordán zaka' gan ẕḻa' wbíž, gan nbab Galilea, gan zej nnita' benách ka' bi zej nake' benne' judío ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Benách ka' zej nchoḻ yichj ḻáẕdo'gake', benne' nníta'gake' ga na', bḻé'egekle' baní', na' benne' ka' zej nake' ka benne' gat ka', bḻa' baní' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Katen' wzó ḻaw Jesusen' ẕzie' x̱tiže'e, gože' benne' ka': —Le yeyát ḻaže', dan' za' ḻa' Dios, Bennen' ze'e ya'abá chie', na' nna bi'e ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kate' wdé Jesusen' žoa'a nisdo' che gan nbab Galilea, bḻe'ele' chope benne'. Toen' lie' Smon, bennen' ḻezka' lie' Bedw. Ndres, benne' biche' Bedon', žónḻene' ḻe' tẕen. Žoptie' ẕzáḻa'gake' yix̱jw bel chégake' ḻo nisdon', dan' zej nake' benne' wẕén bel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesusen' gože' ḻégake': —Le gonḻen neda' tẕen, na' gona' ga yedjwa'le benách ka' nich gákgake' chia' neda', gonle kan žonle kate' ẕzenle bel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Žoptie' ḻa' bká'ntegake' yix̱jw bel ka' chégake', na' jákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kate' Jesusen' wdíe' yelate' na'le, bḻe'ele' yechope benne' ka'. Toen' lie' Jakob, na' Ẕwa, benne' biche'e žónḻene' ḻe' tẕen. Zej nake' ẕi'n Sebedeo. Yó'ogake' ḻo barkw, gan žónḻengake' Sebedeo, x̱ágake', tẕen, na' žeyágake' yix̱jw bel chégake' ka'. Naž Jesusen' bḻiže' žoptie' nich gónḻengake' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ḻa' belka'ntie' barkwn', ḻen x̱ágaken', na' jákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Wdé Jesusen' dot gan nbab Galilea, gan bsedle' benách ka' gan nak ḻo yo'o ka' gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios. Bchaḻje' diža' chawen' ga na' kan za' yedjnná bia' Dios ḻo yežlyó nga, na' beyone' yógo'te benne' yižwé' ka' kan zej nak yižwé' ka' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wzé diža' che yeḻa' wak che Jesusen', na' béngekle benách ka' dot gan nbab Siria. Bedjwá'gake' yógo'te benne' ka' zej de'e da' zan yižwé' ka', na' želzáka'ḻi'e, nich wnníta'gake' benne' we' ka' x̱ni'a Jesusen'. Zá'gake' zej noe'e benne' ka' ga na', benne' ka' yó'ogake' be' x̱iwe' ka', ḻen benne' ka' zej de'e chon, na' benne' ka' bi žak sá'gake'. Jesusen' beyone' yógo'te benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Benne' zan žjákḻene' Jesusen', benne' ka' zej nžoje' gan nbab Galilea, ḻen benne' ka' zej nbabe' yež Dekápolis ka', na' benne' ka' zej nbabe' yež Jerusalén, na' gan nbab Judea, na' benne' yež ka' zej nnitan' yecheḻá'a yego Jordán zaka' gan ẕḻa' wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kate' bḻe'el Jesusen' benne' zan zá'ḻengake' Ḻe', wžene' to ḻaw ya'ado' gan nak sibe, na' ḻaw ya'adon' wži'e. Naž bdobgak benne' wsedle chie' ka' gan zoe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wzó ḻawe' žsedle' ḻégake', na' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ba nez ẕen naken chegak benne' ka' žákbe'egekle' želyážjele' da' zej naken che Dios, dan' de latje chégake' gan ẕnna bia' Dios, Bennen' zoe' ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ba nez ẕen naken chegak benne' ka' žak nyache' ḻáže'gake' dan' zej nbage'e doḻa', dan' Dios na'kze gon ẕene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ba nez ẕen naken chegak benne' ka' zej nake' gax̱jw ḻaže' ḻaw Dios, dan' gata' yežlyó nga chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ba nez ẕen naken chegak benne' ka' ẕdan ḻáže'gake' da' naken chawe' ḻaw Dios, na' žékgekle' ni'a chen kan žékgekle benne' ka' želdone', na' želbile' nis, dan' gon Dios ga sí'gake' dan' ẕdan ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ba nez ẕen naken chegak benne' ka' žeyache' ḻáže'gekle' ljéžgake' ka', dan' Dios yeyache' ḻáže'le' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ba nez ẕen naken chegak benne' ka' nak chawe' yichj ḻáẕdo'gake', na' bi be da' ẕia zej nbage'e, dan' ḻé'egekle' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ba nez ẕen naken chegak benne' ka' ẕzoa žígake' diža' biẕjw, dan' si' lágake' ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ba nez ẕen naken chegak benne' ka' žsaka' zi'gak benách ka' ḻégake' dan' žóngake' da' nak chawe', dan' de latje chégake' gan ẕnna bia' Dios, Bennen' zoe' ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ba nez ẕen gaken chele ḻe'e kate' wḻíž zi'gak benách ka' ḻe'e, na' kwia ḻáže'gake' ḻe'e, na' ḻo yeḻa' wen ḻaže' chégake' nnégake' chele dan' žónḻenle neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Le yebél, na' le chaž ḻaže', dan' gak da' cháwe'ḻe'e chele kate' žinle ya'abá che Dios. Kan žaken chele, ḻezka' goken chegak benne' ka' bcháḻjgake' ḻo wláz Dios, benne' ka' wnníta'gake' zgá'alegake' ka ḻe'e, dan' ḻezka' wžía ḻáže'gak benách ka' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ḻezka' wnná Jesusen': —Ḻe'e nakle ka zede' ḻo yežlyó nga, san cha' wnít zeden' yeḻa' sna'a chen, bi gak yeyonžon sna'a. Biž bi zakan', san ba naken da' cho'nžon, na' benách ka' wléjgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ḻe'e nakle ka baní' ḻo yežlyó nga nich wḻoé'elele ḻaw da' nakle che Dios. Gakle ka to yež da' žen' to ḻaw ya'a, dan' bi gak gache' yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kate' wzaḻjžo yi', bi ẕkáche'žon ẕan kak, san ẕzoažon sibe nich wza'nín' yógo'te benne' ka' nníta'gake' ḻo yo'on'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kan nak baní', ḻezka' gakle ḻe'e, dan' gonle ga gak bia' da' nakle ḻáwlegak yógo'te benách ka', nich kate' ḻé'egekle' da' nak chawe' da' žonle, naž wká'n ẕéngake' X̱ale Dios, Bennen' zoe' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ḻezka' wnná Jesusen': —Bi géklele bḻa'a neda' nich yeká'a da' ka' wnná Moisés o da' ka' bsédgekle benne' ka' bcháḻjgake' ḻo wláz Dios. Bḻa'a neda', kege nich yeká'a da' ka', san bḻa'a nich gona' dot da' zejlasgak da' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da' li žapa' ḻe'e. Kate' ne de ya'abá, na' yežlyó nga, bi te ka'ze nitó díža'do', na' nitó da' wnná Dios kate' gakže yógo'te da' wnné' žaḻa' gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Che ḻen, nóte'teze benne' wka'ne' ca'ze to da' do'ze da' ẕnna dižan', na' cha' wsedle' benne' ka' góngake' ki, benne' ni ga'nže' ka'ze ka yógo'te benne' ka' nníta'gake' gan ẕnna bia' Dios, Bennen' zoe' ya'abá chie', san bennen' gone' kan nak da' ẕnna dižan', na' cha' wsedle' benne' ka' góngake' ki, benne' ni gakže' benne' blo gan ẕnna bia' Dios, Bennen' zoe' ya'abá chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ḻezka' žapa' ḻe'e: cha' bi gonle da' nakže chawe' ka da' žongak benne' yodo' wsedle ka', ḻen ka žongak benne' yodo' fariseo ka', batkle cho'ole gan ẕnna bia' Dios ya'abá chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ḻezka' wnná Jesusen': —Ba bénlele kan wnnagak benne' wnná bia' ka' katen' góžgake' x̱a x̱to'le ka', na' wnnágake': “Bi gotle benách ka'. No benne' nake' wet benne' ka', nbage'e ẕia, na' chog Dios chie' gate'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na'a, neda' žapa' ḻe'e: no benne' ẕže'e lježe' nbage'e ẕia, na' chog Dios chie' gate'. Ḻezka' no benne' ẕnnie' che lježe' nbage'e ẕia, na' chog benne' yolawe' chie' sake'e. Ḻezka' no benne' nnie' che lježe', na' nne': “Bia bi be nnezlba'” nbage'e ẕia, na' wak chog Dios chie' chejchoé'e ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ki naken, cha' le' zoa ko'o ḻo bkog la'y bi da' wneẕjo' ḻaw Dios nich yenít ḻawe' le', na' cha' chejsá' ḻažo'o ga na' zoa biẕ chen ẕža'a lježo' le', ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bka'n dan' no'o na'ze, na' beyéj ližo'. Zga'ale bejká'n chawe' da' beno' che lježo' nich yenít ḻawe' le'. Naž da, wneẕjo' dan' no'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Cha' zoa no benne' yennable' le' bi da' ẕbago'o chie', na' chi'e le' gan wchi'a ḻaže' no benne' ḻe'e, begá'n chawe' ḻen bennen' kate' ne yo'ole nez, nich bi wdíe' le' ḻo na' bennen' wchi'a ḻaže'e le', na' bennen' wdíe' le' ḻo na' benne' žsejwe' liž ya, na' ḻe' wsejwe' le' liž yan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Da' li žapa' le', bi yežojo' ga na' na' zejte chiẕjo' dot da' nbago'o chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ḻezka' wnná Jesusen': —Ba bénlele kan wnnágake': “Bi gono' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na'a, neda' žapa' ḻe'e: nóte'teze benne' ẕwie' to no'le ḻo yeḻa' ẕdan ḻaže' da' sban, ba benḻene' ḻe' doḻa' ḻo yichj ḻáẕda'we'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Che ḻen, cha' yej ḻawo' ḻi ža gonen ga gono' doḻa', wlejen, na' wžo'nen. Gakže chawe' chio' wnito' to yej ḻawo', na' kege dotio' chazen ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Cha' no'o ḻi ža gonen ga gono' doḻa', bchogen, na' wžo'nen. Gakže chawe' chio' wnito' to no'o, na' kege dotio' chazen ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ḻezka' wnná Jesusen': —Ḻezka' wnnágake': “Nóte'teze benne' žénele' yežo'ne' ẕo'le', žaḻa' wneẕjwe' to yiche chie' da' ẕnnan žežo'ne' ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na'a, neda' žapa' ḻe'e, cha' zoa no benne' žežo'ne' ẕo'le', na' bi ẕnna' bi da' žon no'len', naž gon bennen' ga gon ẕo'len' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na' cha' wchág ná'ḻene' benne' byo yoble, na' benne' byon', bennen' si'e no'len', ḻezka' gone' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ḻezka' wnná Jesusen': —Ḻezka' bénlele kan wnnagak benne' wnná bia' ka' katen' góžgake' x̱a x̱to'le ka', na' wnnágake': “Bi gon ḻažo'o kate' gon chocho' x̱tižo'o ni'a che Dios, san žaḻa' gono' ni'a che X̱anžo Dios dot dan' ẕnno' gono' katen' gon chocho' x̱tižo'o ni'a chie' Ḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na'a, neda' žapa' ḻe'e, bi gon chochle x̱tíža'le. Cha' gon chochle x̱tíža'le, bi gonlen ni'a che ya'abá che Dios, dan' naken gan že' ẕnna bia' Diosen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Cha' gon chochle x̱tíža'le, bi gonlen ni'a che yežlyó nga, dan' nak yežlyó nga gan Dios ẕzoe' ni'e, na' bi gonlen ni'a che yež Jerusalén, dan' naken laž Dios, Benne' ẕente, Bennen' ẕnna bi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bi gon chocho' x̱tižo'o ni'a che yichjo', dan' bi gak gono' ga yeyák chich o gasj nitó yicha' yichjo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Žaḻa' nnázele: “o'” o nnázele: “o'o” dan' nak che da' x̱iwe' da' ẕdetlen kan nak diža' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ḻezka' wnná Jesusen': —Ba bénlele kan nak da' wnná Moisés, katen' wnné': “No benne' bi da' žone' che yej ḻaw lježe', ḻezka' le yebí'i chie', na' no benne' bi da' žone' che laye' lježe', ḻezka' le yebí'i chie'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na'a, neda' žapa' ḻe'e: bi wži'ile che no benne' gone' ḻe'e da' ẕia, na' cha' no benne' kape'e x̱ago' ḻi ža, be' latje kape'e yetó x̱ago' yegle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Cha' zoa no benne' gone' ga wchi'a ḻaže' to benne' le', na' kweje' ẕo', ḻezka' bneẕjw chie' laže' da' žx̱oa x̱kožo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cha' no benne' nzi' ḻo ne'e gon byene' go'o ywa' chie' gachje hora, wyejḻen bennen' dot to hora. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No benne' bi da' nnable' le', bneẕjwn chie', na' no benne' bi da' nnable' le' xtido', bi yi'o-ne' bi be de. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ḻezka' wnná Jesusen': —Ḻezka' bénlele dan' wnnágake': “Žaḻa' ži'ilo' no benne' nži'ile' le', na' žaḻa' žo'o no benne' bi de le' chawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Neda' žapa' ḻe'e, le ži'il benne' ka' bi zej de ḻe'e chawe'. Le nnable Dios gon chawe'e benne' ka' žḻiž zí'gake' ḻe'e. Le gon da' naken chawe' chegak benne' ka' ẕbia ḻáže'gake' ḻe'e, na' le wchaḻjḻen Dios, nnáblele-ne' gon chawe'e benne' ka' ẕnnégake' chele, na' žóngake' ḻe'e ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Cha' gonle ki, gakle ḻe'e ẕi'n X̱ažo Dios, Bennen' zoe' ya'abá, dan' žone' Ḻe' ga ẕza'ní' wbíž chie' gan zej nnita' benne' wen da' ẕinnj ka', na' gan zej nnita' benne' chawe' ka'. Žseḻe'e nis yejw chegak benne' chawe' ka', na' chegak benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cha' nží'izelele benne' ka' nží'igekle' ḻe'e, ¿žon byenen no benne' wká'n ẕene' ḻe'e? Ḻezka' žongak benne' ka' bi zej nake' chawe', benne' ka' ẕchíẕjwgake' benách ka' ḻo wláz yež zi'to', dan' nží'igekle' ljéžgake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Cha' žaple ba la'ne ljéžzele ka', ¿biẕe žonle da' nakže chawe'? Ḻezka' žongak benne' ka', benne' bi zej nónbi'e Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","San ḻe'e, le gak dot chawe', kan nak X̱ažo Dios, Bennen' zoe' ya'abá, nake' dot chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ḻezka' wnná Jesusen': —Le we' ḻaže' gak dot ḻi ḻaže' kan ẕka'n ẕenle Dios. Bi gónzele ki nich ḻé'egekle benách ka' kan žonle. Cha' ki gónzele, X̱ažo Dios, Bennen' zoe' ya'abá, bi be da' chawe' yebi'e chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kate' bi da' wneẕjo' che no benne' zoa bi da' žiážjele', bi wḻoe'elo' ḻaw dan' žono' kan žongak benne' ka', benne' ẕḻoé'ezele chawe' kwíngake' gan nak ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' gan nak ḻawe' ya'a. Ki žóngake' nich gapgak benách ka' ḻégake' ba la'ne. Da' li žapa' ḻe'e, ka'ze nak yeḻa' ba la'ne da' gatan' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","San le', kate' bi da' wneẕjo' che no benne' zoa bi da' žiážjele', bi go'o nitó benne' latje nnezlen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na'a, dan' wneẕjo', ngáche'ze žaḻa' wneẕjon', na' X̱ažo Dios, Bennen' ẕḻe'ele' dan' žono' ngáche'ze, yebi'e chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ḻezka' wnná Jesusen': —Kate' wcháḻjḻenle Dios, bi gonle kan žongak benne' ka', benne' ẕḻoé'ezele chawe' kwíngake', dan' kate' žḻižgake' Dios ẕdan ḻáže'gake' ẕzégake' gan nak ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' gan nak ḻawe' ya'a, nich ḻé'egekle benách ka' ḻégake'. Da' li žapa' ḻe'e, ka'ze nak yeḻa' ba la'ne da' gatan' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","San ḻe'e, kate' wcháḻjḻenle Dios, le cho'o ližle, na' le wsejw yo'o chele. Le wḻíž Dios, na' le wchaḻjḻen X̱ažo Dios, Bennen' zóaḻene' ḻe'e gan zoale chézele, na' X̱ažo Dios, Bennen' ẕḻe'ele' da' žonle ngáche'ze, Ḻe' yebi'e chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Katen' wcháḻjḻenle Dios bi yeži'ile žop yonnze kan žongak benne' ka', benne' bi zej nónbi'e Dios, dan' žékgekle' wzé nag Dios chégake' dan' žeží'igake' žop yonnze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bi gonle kan žóngake' ḻégake'. X̱ažo Dios, zga'ale kate' bi da' nnáblele-ne', ba nnézkzele' da' ka' žiážjelele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Che ḻen, žaḻa' wcháḻjḻenle Dios, na' nnale ki: X̱ato' Dios, zo' ya'abá, ga'n ẕen Lo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Da, nna bi'o yežlyó nga. Žénelto' gaken yežlyó nga kan žaz ḻažo'o Le' kan žaken ya'abá chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Benn da' gawto' na'a ža. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Benít ḻaw cheto' da' ẕinnj da' žonto', kan ženít ḻawto' che no benne' žone' cheto' da' ẕinnj. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bi go'o latje gon da' x̱iwe' ga bága'to' doḻa', san beslá neto' ḻo na' da' žonen, dan' zej nak chio' dot yeḻa' wnná bia', na' dot yeḻa' wak, na' dot yeḻa' ẕen, da' ka' náptezo'. Ka'kze gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Cha' yenít ḻawle chegak lježle ka', benne' žóngake' ḻe'e da' ẕinnj, ḻezka' X̱ažo Dios, Bennen' zoe' ya'abá, yenít ḻawe' chele ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cha' bi yenít ḻawle chegak lježle ka', bi yenít ḻaw X̱ažo Dios chele ḻe'e doḻa' da' nbága'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ḻezka' wnná Jesusen': —Kate' gonle wbás, bi gonle nyache' ḻawle kan žongak benne' ka', benne' ẕḻoé'ezele chawe' kwíngake', dan' žóngake' nyache' ḻáwgake' nich ḻé'egekle benách ka' žóngake' wbás. Da' li žapa' ḻe'e, ka'ze nak yeḻa' ba la'ne da' gatan' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","San ḻe'e, kate' gonle wbás, le wpá' yichjle, na' le chib ḻawle, ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nich bi ḻé'egekle benách ka' žonle wbás. Ngáche'ze žaḻa' gonle wbás, na' X̱ažo Dios, Bennen' zóaḻene' ḻe'e gan zoale chézele, yebi'e chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ḻezka' wnná Jesusen': —Bi wtoble da' zaka' ḻo yežlyó nga, gan beldo' chen wtébgakban', na' ẕbia yin', na' gan cho'ogak benne' wbán ka', nich kwángaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","San le wtób da' zaka' chele ya'abá che Dios, gan bi galj beldo' chen, bia wtébgakban', na' bi cwia yin', na' gan bi gak cho'ogak benne' wbán ka', nich bi gak kwángaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gan de da' zaka' chele, we' ḻáže'le žinle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ḻezka' wnná Jesusen': —Yej ḻawžo zej naken ka to da' ẕza'ní' ḻo yichj ḻáẕdo'žo. Che ḻen, cha' yej ḻawle zej naken chawe', cho'o yichj ḻáẕdo'le da' naken baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Cha' yej ḻawle bi zej naken chawe', yichj ḻáẕdo'le gaken choḻ. Che ḻen, cha' baní' da' zóaḻenen ḻe'e ba beyaken da' naken choḻ, ba nakḻe'e choḻ yichj ḻáẕdo'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ḻezka' wnná Jesusen': —Bi gak no benne' gone' x̱chingak chope x̱ane', dan' wzóe' cheḻa'ale toen', na' yetóen' ži'ile' ḻe', o gá'nḻene' toen', na' yetóen' kwej yichje' ḻe'. Bi gak wká'n ẕenle Dios, na' mežw. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ḻezka' wnná Jesusen': —Ḻezka' žapa' ḻe'e: bi kwe' zédlele ni'a che da' gawle o ni'a che da' ye'jle, da' ka' nbánḻenle, o ni'a che laže' da' gákwle. Záka'ḻe'eže yeḻa' nban chele ka da' ye'j gawle, na' záka'že beḻa' žen chele ka laže' da' gákwle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Le wia kan žak chegak byínnedo' ka', bia ẕlágakba' ya'abá. Bi žázgakba', na' bi žel-ḻapba', na' bi ẕtóbgakba' da' gape chí'igakba', san X̱ažo Dios, Bennen' zoe' ya'abá, ẕwawkze' ḻégakba'. Záka'žele ḻe'e ka byínnedo' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Noẕ benne' ládjwle ḻe'e gak gone' ga soe' nbane' yetó chí'ido'ze dan' že' zedle' nich gak ki chie'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Biẕ chen' že' zédlele ni'a che da' gákwle? Le wia nga kan želgole yéjedo' ka' žé'gaken ladjw yix̱e'. Bi žóngaken žin, na' bi žóngaken do x̱laže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Neda' žapa' ḻe'e, Salomón, bennen' wnná bi'e, ḻa'kze góta'ḻe'e yeḻa' wnni'a chie', laže' da' gokwe' bi gokžen x̱tan ka žnna'gak yéjedo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dios na'kze žone' x̱tan yeje yíx̱e'do' ka', da' žé'gaken ladjw yix̱e', na' zej žian na'a ža, na' wx̱é wižj chéygaken ḻo yi'. Žone' ḻégaken x̱tanḻe'e. Cha' ki že' ḻaže'e yeje yíx̱e'do' ka', ḻezka' da' ẕenḻe'e gone' chele ḻe'e, ḻa'kze bi žejḻe'le chie' dot ḻáže'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Che ḻen, bi kwe' zédlele, na' bi nnale: “¿Biẕkze gawto'?” o “¿Biẕkze ye'jto'?” o “¿Biẕkze gákwto'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Benne' ka' nníta'gake' yežlyó nga že' ḻáže'gake' chegak yógo'te da' ki, san zoa X̱ažo Dios ya'abá, na' Ḻe' nnézkzele' cha' žiážjelele bíte'teze da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na'a, le we' ḻaže' nna bia' Dios ḻe'e, na' le gon da' nak chawe' ḻawe' Ḻe', na' Ḻe' ko'e x̱nezle yógo'te da' ki da' žiážjelele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Che ḻen, bi kwe' ḻáže'le che da' gak wx̱é wižj, dan' gak kwe' ḻáže'le wx̱é wižj che da' gaken chele ža na'. Tža tža žak da' ka' žaḻa' kwe' ḻáže'le chen ža na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ḻezka' wnná Jesusen': —Bi chog bia'le chegak lježle ka', nich bi chog bia' Dios chele ḻe'e, ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","dan' chog bi'e chele ḻe'e tḻébeze kan ẕchog bia'le chegak lježle ka', na' kan ẕžix̱le che lježle ka' ḻezkan' gonkze Dios chele ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Biẕ chen' ẕwio' bebdo' da' yo'on yej ḻaw lježo', na' bi žákbe'lo' to da' ẕenḻe'e yo'on yej ḻawo' le'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Yi'o lježon': “Wleze, nich kweja' bebdon' da' yo'on yej ḻawo'” na' le', da' ẕenḻe'e yo'on yej ḻawo' le'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Le', benne' žḻoé'ezele chawe' kwino'. Zga'ale wléj da' yo'on yej ḻawo' le', nich gak ḻe'elo' binlo nich kwejo' bebdon' da' yo'on yej ḻaw lježon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Bi cho'nle da' zej naken la'y nich gaw beko' ka' ḻen, ka chéchjgakba', na' gáwya'agakba' ḻe'e. Bi cho'nle da' záka'ḻe'en chele nich gaw koch ka' ḻen, ka wléj chóchjgakban'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ḻezka' wnná Jesusen': —Le nnab, na' Dios gonnen' chele. Le chilj, na' gonne' latje žéḻ-lelen. Le wḻíž ža yo'o, na' Ḻe' wsaljwe' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","No benne' bi da' ẕnnabe', gatan' chie', na' benne' bi da' žilje', žeḻ-len', na' benne' žḻiže' ža yo'o, yaljwn chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Cha' zoa no benne' ládjwle ḻe'e, zoa x̱kwide' chie', cha' nnablbe'-ne' yet x̱til, ¿wneẕjwe' yej chebe'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Cha' nnablbe'-ne' to bel, ¿wneẕjwe' bele snia chebe'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ḻe'e bi nakle chawe', san nnézlele wnéẕjwle da' naken chawe' chegak ẕi'nle ka'. Wak wx̱én ḻáže'le X̱ale Dios, Bennen' zoe' ya'abá, gonne' da' naken chawe' chegak benne' ka' bi da' nnábgekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Che ḻen, kan žénelele ḻe'e gongak benne' ka' chele, ḻezka' le gonte chégake'. Ki ẕnna da' bchi'le Moisés žo'o, na' da' wnnagak benne' ka' bcháḻjgake' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ḻezka' wnná Jesusen': —Le cho'o gan žo'ogak benách ka' ga nak to lyido'. Laga' nak gan žo'ogak, na' nez ẕen naken da' žjakḻen benne' ka' gan kwia yí'gake'. Žo'ogak benne' zan ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lyido' nak gan žo'ogak, na' nez ḻas naken da' žjakḻen benne' ka' gan gata' yeḻa' nban da' zejlí kanne chégake', na' babze benne' ka' žežéḻgeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ḻezka' wnná Jesusen': —Le gape chi'i kwinle nich bi gon ḻáže'gekle benne' wen ḻaže' ka' ḻe'e, benne' ka' ẕnnágake' ẕcháḻjgake' ḻo wláz Dios. Ḻa'gak benne' ka' gan zoale, benne' ca' wḻoé'el kwíngake' gax̱jw ḻáže'do' kan zej nak ẕíla'do' ka', san ḻo yichj ḻáẕdo'gake' zej nake' ka beko' yix̱e' snia ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Da' ka' žóngake' zej nak bian' kan zej nake'. Bi ẕchibžo da' ẕbia lba uba ḻo yag yeche', na' bi ẕchibžo da' ẕbia yag higo ḻo yix̱e' laye'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ki naken, yógo'te yag ẕix̱ želbían da' zej naken ẕix̱, na' to yag yix̱e' ẕbian da' bi zej naken ẕix̱. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yag ẕix̱ na' bi gak kwian da' zej naken ka'ze, na' yag yix̱en' bi gak kwian da' zej naken ẕix̱. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bíte'teze yag da' bi ẕbian da' naken ẕix̱, chóggaken', na' wzéygaken' ḻo yi'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ki naken, da' ka' žongak benne' ka' zej nak bian' kan zej nake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ḻezka' wnná Jesusen': —Benne' zan yé'gake' neda': “X̱an, X̱an” san kege yógo'tegake' cházgake' gan ẕnna bia' Dios ya'abá. Ḻégakze benne' ka' žóngake' da' žénele X̱ažo Dios, Bennen' zoe' ya'abá, chejnníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kate' žin ža ze ḻawte ža ka' che yežlyó nga, benne' zan yé'gake' neda', na' nnágake': “X̱an, X̱an, bchaḻjto' x̱tiža' Dios ni'a che lo' Le'. Bkonlto' žin lo' nich bebejto' be' x̱iwe' ka', na' bkonlto' žin lo' nich bento' da' zan yeḻa' wak ẕen ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Naž neda' yapa' ḻégake': “Bi nónbi'a ḻe'e. Le kwas ga zoa' ni, ḻe'e, benne' wen da' ẕinnj ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ḻezka' wnná Jesusen': —Ḻezka', no benne' ženle' x̱tiža'a ni, na' žone' kan ẕnnan, nake' ka to benne' žejni'ile', benne' bene' liže' gan že' ḻo yej x̱e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kate' gok yéjwsio', bedób nis wbá'a, na' gok be', na' wdíb nisen' kwit yo'on', san bi wbix̱en, dan' žen' ḻo yej x̱e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na'a, no benne' ženle' x̱tiža'a ni, na' bi žone' kan ẕnnan, benne' ni nake' ka to benne' bi žejni'ile', benne' bene' liže' ḻo yo yach. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kate' gok yéjwsio', bedób nis wbá'a, na' gok be', na' wdíb nisen' kwit yo'on', na' wbix̱en, na' ḻa' wbía yi'ten. ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kate' beyóž Jesusen' bcháḻjḻene' ḻégake' da' ni, bebán ḻáže'gak benne' zan ka' kan nak da' žsedle', ");
INSERT INTO ztyNTps_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dan' žsedle' ḻégake' kan žon to benne' nzi' ḻo ne'e yeḻa' wnná bia', kege kan žongak benne' yodo' wsedle chégake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kate' betj Jesusen' ḻaw ya'a na', benne' zan zjákḻene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","To benne' de'e yižwé' leže bžine' gan zoa Jesusen'. Bzoa ẕibe' x̱ni'e, na' gože' Ḻe': —X̱an, cha' žénelo', wak yeyono' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Naž Jesusen' ḻa' bḻite ne'e, na' wdane' ḻe'. Gože' ḻe': —Žénela'. Yeyako' chawe'. Ḻa' benitte yižwé' che bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Naž Jesusen' gože' ḻe': —Bwia nga, bi yi'o nitó benne' da' ni, san beyéj, bejḻoé'el kwino' ḻaw bx̱oz, na' bejneẕjw dan' bchi'le Moisés ḻe'e, dan' wḻoé'elen benách ka' ba beyako'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wyáz Jesusen' ḻo yež Kapernaum, na' bḻa' to benne' ga na', benne' ẕchi'e to gaywá' benne' ka' žjake' ḻo wdiḻe. Bžine' gan zoa Jesusen', na' góta'yoele' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","na' wnné': —X̱an, zoa to bi' wen žin chia', debe' ḻo yo'o. Bi žak sa'be', na' ẕzáka'ḻe'ebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesusen' gože' ḻe': —Sa'a neda', yeyona'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bechebe benne' wnná bian', na' gože' Jesusen': —X̱an, bi naka' neda' zi cho'o liža', san cha' nnazo', yeyák bi' wen žin chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ḻezka' neda', zoa to benne' ẕnna bi'e neda', na' zej nnita' benne' ka' žjake' ḻo wdiḻe, benne' ka' ẕnna biá'gaka'-ne'. Kate' žapa'-ne' toe': “Wyéj ga na'” žeje'. Kate' žapa'-ne' yetóe': “Da ni” žide'. Kate' žapa' benne' wen žin chia': “Ben žin ni” ḻa' žontie' žin na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kate' benle Jesusen' da' ni, bebanle', na' gože' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —Da' li žapa' ḻe'e, gan zej nnita' benne' Israel ka', bi na' chejx̱aka'a nitó benne' žejḻi'e chia' neda' kan žon benne' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ḻezka' žapa' ḻe'e: žojgak benne' zan zaka' gan ẕḻa' wbíž, na' zaka' gan ženen, na' kwé'ḻengake' tẕen Bran, na' Isaak, na' Jakob, gan ẕnna bia' Dios ya'abá chie', ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","san benne' ka' ba wžekze Dios nich chejnníta'gake' gan ẕnna bi'e Ḻe', wsejwe' ḻégake' na'le gan nak choḻ, gan kwéžegake', na' wx̱éj láye'gake' ḻo yeḻa' nyache' ḻaže' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naž Jesusen' gože' bennen' ẕchi'e benne' ka' žjake' ḻo wdiḻe, na' wnné': —Beyéj ližo'. Kan žejḻi'o chia', ka' gaken chio'. Ḻa' na'ze beyakte bi' wen žin chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bžin Jesusen' liž Bedw, gan bḻe'ele' x̱na' ẕo'le Bedon' die' ḻo da'a, na' yoe'e da' ḻa. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesusen' wdane' na' no'len', na' ḻa' bežojte da' ḻa dan' yoe'e. Naž beyás no'len', na' bsí'ni'e da' bdáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kate' za' žaḻe ža na', za'gak benne' ka' zej noe'e benne' zan gan zoa Jesusen', benne' yó'ogake' be' x̱iwe' ka', na' ḻen yeḻa' ẕnneze chie' bebeje' be' x̱iwe' ka', na' beyone' yógo'te benne' yižwé' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ki goken, bžin dan' wnná Isaías, benne' bchaḻje' ḻo wláz Dios ža ni'te, katen' wnné': “Ḻe' beyone' da' ka' wẕáka'žo, na' beké'e yižwé' ka' chežo.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kate' bḻe'el Jesusen' zej nnita' benne' zan ka' dot kwite', gože' benne' wsedle chie' ka' tégake' yecheḻa'ale nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","To benne' yodo' wsedle bžine' gan zoa Jesusen', na' gože' Ḻe': —Benne' wsedle, gónḻena' Le' tẕen gáte'teze gan chejo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesusen' gože' ḻe': —Beza' ka' zej de ẕan yej chégakba', na' byínnedo' ka', zej žia x̱ó'ngakba', san neda', Benne' Golje' Benách, bi de gan chix̱jw yichja'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yetó benne' wsedle che Jesusen' gože' Ḻe': —X̱an, benn latje yeyá'a liža' na' zejte wkacha'a x̱a'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesusen' gože' ḻe': —Da ḻen neda'. Be' latje benne' žátgake' wkáche'gake' ljéžgake' ka', benne' žátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wžén Jesusen' ḻo barkw, na' benne' wsedle chie' ka' žónḻengake' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Naž gok to be' waḻe ḻo nisdo', na' žasḻe'e nisdon', na' zejte žaz nis ḻo barkwn'. Jesusen' die' ẕtase' ḻo barkwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Naž benne' wsedle chie' ka' wbíga'gake' gan die', na' besbángake' Ḻe', na' góžgake' Ḻe': —X̱an, beslá neto'. Za' gatžo ḻo nis. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bechebe Jesusen', na' gože' ḻégake': —¿Biẕ chen' ẕžébele? Láte'ze žejḻe'le che Dios. Naž wyase Jesusen', na' bḻiže' ben' da' žaken, na' nisdon', na' ḻa' wžé'tegaken ži. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bebán ḻáže'gak benne' ka', na' wnnágake': —¿Biẕ napkze benne' ni? Ẕnneze', na' be' žaken, na' nisdo' žóngaken kan ẕnne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kate' bžin Jesusen' yecheḻá'a nisdo' gan nbab yež Gadara, bžojgak chope benne' ka' ḻo bloj ka' gan zej že' ba chegak benne' gat ka', na' bžíngake' gan zoa Jesusen'. Sníaḻe'e zej nake', na' bi gok nitó benne' tie' ḻo nezen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ḻa' wžéžeya'agak žoptie' zižje, na' wnnágake': —¿Biẕ nbága'to' chio', Jesús, Ẕi'n Dios? ¿Zo'o nga nich wsaka' zi'o neto' kate' bi na' žin ža? ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gan nníta'gake' zej nnita' koch zan, bia želdaba' žáwgakba', na' zej že'ba' late' gan nak zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wnné nyáche'gak be' x̱iwe' ka', na' góžgaken Jesusen': —Cha' yebejo' neto', be' latje chejžo'oto' yichj ḻáẕdo'gak koch zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naž Jesusen' gože' ḻégaken: —Le chej. Ḻa' bežójtegak be' x̱iwe' ka', na' bejžó'ogaken yichj ḻáẕdo'gak koch zan ka'. Naž ka' gaze jak yógo'te koch zan ka', na' bejbíx̱jgakba' gan nak to ḻe'e ya'a yej, na' bejcházgakba' ḻo nisdo', gan wyépgakba' nis, na' gótgakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bžébegak benne' ka', benne' wdape chí'igake' koch ka', na' bẕónnjgake'. Kate' bžíngake' ḻo yež, bzéngekle' benách ka' yógo'te da' gókgaken chegak benne' ka' wyó'ogake' be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naž bžojgak benne' ḻo yež ka', nich bejchággake' Jesusen'. Kate' bḻé'egekle' Ḻe', góta'yoegekle' Ḻe' yezé'e ḻo yežlyó chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Naž bebén Jesusen' ḻo barkw, na' wdíe' yecheḻá'a nisdon', na' bežine' gan nak laže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bžingak benne' ka' ga na' zej noe'e to benne' bi žak se'e, na' bdíx̱jwgake' ḻe' x̱ni'a Jesusen', ẕoe' ḻo yag gant. Kate' bḻe'el Jesusen' kan žejḻe'gak benne' ka' chie' Ḻe', gože' bennen' bi žak se'e, na' wnné': —Ben choch ḻažo'o, ẕí'na'do'. Ba benít ḻawa' chio' doḻa' da' nbago'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ḻezka' zej nnita' benne' yodo' wsedle ka' ga na'. Wzá' ḻáže'gake', na' wnnágake': —Da' ẕchaḻj benne' ni ẕzoan Dios cheḻa'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kate' gókbe'ele Jesusen' da' ẕza' ḻáže'gake', gože' ḻégake': —¿Biẕ chen' ẕza' ḻáže'le da' kegle? ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bi nak zede cha' no benne' yí'aze' benne' ni: “Doḻa' da' nbago'o ba benít ḻawa'” san nak zede gone' ga yeyase', na' yezé'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na'a, neda', Benne' Golje' Benách, wḻoe'ela' ḻe'e nzi' ḻo na'a yeḻa' wnná bia' ḻo yežlyó nga yenít ḻawa' doḻa'. Naž Jesusen' gože' bennen' bi žak se'e, na' wnné': —Beyás. Bchis yag gant chion', na' beyéj ližo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Naž ḻa' wyaste bennen' bi gok se'e, na' beyeje' liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kate' benne' ka' nníta'gake' ga na' bḻé'egekle' da' ni, bebángekle', na' bka'n ẕéngake' Dios dan' bneẕjwe' yeḻa' wak ki chegak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kate' bezá' Jesusen' ga na', bḻe'ele' to benne' lie' Matío, ži'e gan ẕchiẕjwe' benách ka' ḻo wláz yež zi'to', na' Jesusen' gože' ḻe': —Benḻen neda' tẕen. Naž ḻa' wzó ža'te Matíon', na' bénḻene' Jesusen' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yetó da' goken, kate' ne že' Jesusen' žawe' to ḻo yo'o, benne' zan, benne' wechiẕjw ka' na' benne' gax̱jw ka', bžíngake' gan zoe', na' wžé'ḻengake' Jesusen' na' benne' wsedle chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kate' benne' yodo' fariseo ka' bḻé'egekle' da' ni, wnnábgekle' benne' wsedle ka' che Jesusen', na' wnnágake': —¿Biẕ chen' bennen' žsedle' ḻe'e žáwḻene' benne' wechiẕjw ka', na' ḻen yezika' benne' doḻa' ka' tẕen? ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kate' benle Jesusen' da' ni, gože' ḻégake': —Benne' ka' nníta'gake' chawe', bi žon byenen chjake' gan zoa benne' žeyone' benách ka', san benne' ka' bi nníta'gake' chawe' žon byenen chjake' gan zoa bennen' žeyone' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Le chej, na' le wsedle da' nyejw ḻe'e yiche la'y, da' ẕnnan ki: “Žénela' yeyache' ḻáže'gekle benne' ka' ljéžgake' ka', kege gótgake' bia beže ka' ḻo bkog la'y chia'.” Bḻa'a neda' nga, kege nich wḻiža' benne' chawe' ka', san nich wḻiža' benne' doḻa' ka' nich yeyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naž benne' ka' žónḻengake' Ẕwa tẕen, bennen' bezóe' benách ka' nis, bḻá'gake' gan zoa Jesusen', na' wnnábgekle' Ḻe', na' wnnágake': —Neto' žonto' wbás zan chi'i, na' ḻezka' žongak benne' yodo' fariseo ka'. ¿Biẕ chen' benne' wsedle chio' ka' bi žóngake' wbás? ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bechebe Jesusen', na' gože' ḻégake': —¿Wak benne' ka' nníta'gake' lni che yeḻa' ẕchag na' gak nyache' ḻáže'gake' kate' benne' ẕchag ne'e ne zóaḻene' ḻégake'? Za' ža kate' kwas bennen' ẕchag ne'e gan nníta'gake'. Ža na' góngake' wbás. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bsaka' ḻebe Jesusen', na' wnné': —Bi yeyón nitó benne' to laže' gole ḻen laže' kobe, dan' wx̱ónnj laže' koben' da' ngo'e lo ḻaže' golen', na' chéza'že laže' golen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ḻezka' bi ka'a nitó benne' x̱is uba kobe to ḻo že'e gole da' naken yid, dan' gak bžina' x̱is uba koben', na' wlá'n že'e golen' da' naken yid, na' cwia yi' x̱is uba na', na' ḻezka' kwia yi' že'e na' da' naken yid. Ẕga'ažo x̱is uba kobe to ḻo že'e kobe da' naken yid, na' da' chopten žak chí'igaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kate' Jesusen' ne ẕcháḻjḻene' ḻégake', to benne' ẕnna bi'e benne' judío ka' bḻe'e gan zoe', na' bzoa ẕibe' x̱ni'e, na' gože' Ḻe': —X̱kwide' no'le chia' za' gotbe'. Da, x̱oa no'o ḻebe', nich yebanbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ḻa' wzó ža'te Jesusen', na' wyéjḻene' ḻe', tẕen ḻen benne' wsedle chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naž bžin to no'le ba gok chežinno yiz de'e yižwé'. Bi ẕbez žen chie' da' žaken chégakkze no'le ka'. Wbige'e zaka' x̱kože'l Jesusen', na' wdane' laže' da' nakwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ki bene' dan' wzá' ḻaže'e, na' wnné': “Cha' kanza' ẕe', yeyaka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Naž byechj Jesusen', na' bwie' ḻe', na' gože' ḻe': —Ben choch ḻažo'o, ẕí'na'do'. Ba beyaktio' dan' žejḻi'o chia' neda'. Ḻa' na'ze beyaktie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kate' bžin Jesusen' liž benne' wnná bian', bḻe'ele' zej nnita' benne' zan ga na', benne' ka' ẕkwéžegake' bžejw, na' benne' ka' želbeže nyache'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesusen' gože' ḻégake': —Le kwas ga ni, dan' bi nat x̱kwide' no'le ni. Ẕtászebe'. Naž benne' ka' nníta'gake' ga na' bka'n dítjgekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kate' Jesusen' ba bebeje' benne' ka' na'le, wyoé'e ḻo yo'o, na' bex̱we' na' x̱kwide' no'len', na' ḻa' wyástebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wzé diža' kan gok da' ni, na' benách ka' nníta'gake' dot yežlyón' béngeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kate' bžoj Jesusen' ga na', chope benne' ḻo choḻe ka' wnáwgake' Ḻe'. Wžéžeya'agake' zižje, na' wnnágake': —Beyache' ḻaže'l neto', Le', ẕa'só Dabí. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kate' wyó'o Jesusen' ḻo yo'o, žopte benne' ḻo choḻe ka' bžíngake' gan zoe'. Naž Jesusen' wnnable' ḻégake', na' wnné': —¿Žejḻe'le chia' neda', gak yeyona' ḻe'e? Ḻégake' wnnágake': —O', X̱an. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Naž Jesusen' wdane' yej ḻáwgake', na' wnné': —Kan žejḻe'le, ka' gaken chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ḻa' beyáljwte yej ḻáwgake'. Naž Jesusen' bchi'le' ḻégake', na' wnné': —Le wia bi we'le latje no benne' nnezle' da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kate' bežójgake', ḻa' bzétegake' diža' dot yežlyón' kan nak da' ben Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kate' Jesusen' bežójḻene' benne' wsedle chie' ka' tẕen ḻo yo'on', bžingak benne' ka' gan zoa Jesusen', benne' ka' zedjwá'gake' to benne' gan zoe' Ḻe', benne' bi žak nnie' dan' yoe'e be' x̱iwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kate' bebéj Jesusen' be' x̱iwen', ḻa' wnnete bennen' bi gok nnie'. Bebán ḻáže'gak benne' ka' nníta'gake' ga na', na' wnnágake': —Bi na' ḻe'elto' da' ki gan nníta'gak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Naž benne' yodo' fariseo ka' wnnégake' chie', na' wnnágake': —Benne' ni žebeje' be' x̱iwe' ka' ḻen yeḻa' wak che x̱angak be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Wdá Jesusen' dot kwit gan zej že' yež ẕen ka', na' yeždo' ka', na' gan nak ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' bsedle' benách ka' nníta'gake' ga na', na' bchaḻje' diža' chawen' kan ẕnna bia' Dios. Beyone' yógo'te benne' ka' zoa bi da' želzake'e, benne' ka' nníta'gake' ḻo yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kate' bḻe'el Jesusen' benne' zan ka', beyache' ḻáže'le' ḻégake', dan' želzake'e, na' žedó ḻáže'gake' kan žak chegak ẕila' ka' bi zoa benne' gape chí'igake'-ba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Naž Jesusen' gože' benne' wsedle chie' ka', na' wnné': —Da' li, ẕen nak yel, san babze benne' ka' nníta'gake' nich ḻápgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Che ḻen, le gáta'yoel Dios, Bennen' nake' X̱an yelen', na' nnáblele-ne' seḻe'e benne' wen žin ka', nich ḻápgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Naž bḻiž Jesusen' chežínnote benne' wsedle chie' ka', na' bdie' ḻo ná'gake' yeḻa' wnná bia' nich yebéjgake' be' x̱iwe' ka' yo'ogak benách ka', na' nich yeyóngake' yógo'te benne' yižwé' ka', na' yógo'te benne' ka' zoa bi da' želzake'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ki legak chežínnote wbás ka' wžé Jesusen': Smon, (ḻezka' lie' Bedw). Ndres, (biche' Smon na'). Jakob, (ẕi'n Sebedeo). Ẕwa, (biche' Jakob na'). ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Lip. Bartol. Mas. Matío, (benne' wechiẕjw). Jakob, (ẕi'n Alfeo). Lebeo, (ḻezka' lie' Tadeo). ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Smon, (benne' že' ḻaže'e yež Israel). Judas Iskariote, (bennen' wdíe' Jesusen' ḻo na'gak benne' ka' gótgake' Ḻe'). ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Naž Jesusen' bseḻe'e chežínnote benne' wsedle chie' ka' nich chejzégake' x̱tiže'e, na' bchi'le' ḻégake', na' wnné': —Bi chejle gan zej nnita' benách ka' bi zej nake' judío, na' bi chazle lažgak benách ka' nníta'gake' gan nbab Samaria. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Le chej gan zej nnita' benách Israel ka', benne' zej nake' ka ẕíla'do' ka', bia ka' zej nnitlba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Le wcháḻj diža' chawen', na' nnale: “Za' žin ža ḻa' Bennen' zoe' ya'abá che Dios nich nna bi'e ḻo yežlyó nga.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Le yeyón benne' yižwé' ka'. Le yeyón benne' ka' zej de'e yižwé' leže. Le yesbán benne' gat ka'. Le yebéj be' x̱iwe' ka' yo'ogak benách ka'. Bennza' yeḻa' wnná bia' ni chele. Le wkonlen žin, na' bi be wchíẕjwle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Bi be wa'le ḻo bzod chele, cha' mežw oro, o mežw plat, o mežw lasdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Bi wa'le yix̱jw yet chele da' gawle ḻo nez. Toze laže' da' x̱oa yenle wa'le, na' bi wa'le ẕeḻ-le, o bar chele, dan' wžeḻkzle benne' wen žin da' gawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Gáte'teze yež ẕen, o yeždo' gan žinle, le nnab cha' zoa no benne' ga na' nake' ḻi ḻaže', na' ga'nle liž bennen' na' zejte yežojle ḻo yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kate' cho'le to yo'o, le gape “Padiox̱” benne' ka' nníta'gake' yo'on', na' nnáblele Dios wneẕjwe' chégake' da' wzóa žin yichj ḻáẕdo'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Cha' zej nak zi benne' ka' nníta'gake' yo'on', na' da' ẕzoa žin yichj ḻáẕdo'žo gá'nḻenen ḻégake', san cha' bi zej nak zi benne' ka', nnable bi ga'nḻen ḻégake' dan' ẕzoa žin yichj ḻáẕdo'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gáte'teze gan žinle gan bi gápegak benách ka' ḻe'e ba la'ne, na' bi wzé nággake' x̱tíža'le, le yežój ḻo yo'on', o ḻo yežen', na' le kwib bix̱te yo da' dan' lable, da' wḻoe'elen ḻégake' zej nbage'e ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Da' li žapa' ḻe'e, kate' žin ža chog Dios chegak benách ka' sáka'gake', sáka'žegak benách ka' nníta'gake' ḻo yežen' ka sáka'gak benách ka' wnníta'gake' ḻo yež Sodoma, na' ḻo yež Gomorra, yež ka' bchinnj Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ḻezka' wnná Jesusen': —Le wia nga, neda' žseḻa'a ḻe'e, na' gakle ka ẕíla'do' ka' želdaba' gan zej nnita' beko' yix̱e' snia ka'. Le gak ban ḻaže' kan zej nak bele snia ka', san ḻezka' le gak gax̱jw ḻaže' kan zej nak plomdo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Le gape chi'i kwinle chegak benách ka', dan' wdégake' ḻe'e ḻo na'gak benne' yolawe' ka', na' chíngake' ḻe'e gan nak ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ḻezka' wché'gake' ḻe'e gan že'gak benne' blo ka', na' gan že'gak benne' wnná bia' ka', dan' žónḻenle neda' tẕen. Ki gaken nich gak wchaḻjle x̱tiža'a gan že'gak benne' ka', na' gan že'gak benne' ka' bi zej nake' judío. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Naž kate' wdégake' ḻe'e ḻo na'gak benne' wnná bia' ka', bi gek zédlele biẕ nnale, dan' wchíz Dios yichj ḻáẕdo'le ḻa' ža na'ze da' nnale, o kan wchaḻjle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kege ḻé'ezele wchaḻjle, san Dios Be' La'y, Bennen' seḻa' X̱ažo Dios chele, Ḻekze' sóaḻene' ḻe'e, na' wchaḻje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Zej nnita' benách ka' wdégake' bíche'gake' ka' ḻo na'gak benne' ka' gótgake' ḻégake', na' ḻezka' benne' ka' zej nake' x̱agak x̱kwide' ka' wdégake' ẕí'ngake' ka', na' zej nnita' benne' ka' kwej yíchjgake' x̱ágake' ka', na' góngake' ga gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yógo'te benách wzóagake' ḻe'e cheḻa'ale dan' žónḻenle neda' tẕen, san yelá no benne' ga'ne' choch na' zejte ža ze ḻawte ža ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kate' wsaka' zi'gak benách ka' ḻe'e to ḻo yež, le wẕónnj ga na', na' le chej yetó yež, dan' žapa' ḻe'e, yeḻá'a neda', Benne' Golje' Benách, zga'ale kate' yeyóž wzele x̱tiža'a gan zej nnita' yógo'te yež ka' chegak benách Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nóte'teze benne' nake' benne' wsedle bi nakže' blo ka bennen' žsedle' ḻe', na' ḻezka' no benne' nake' wen žin bi nakže' blo ka x̱ane'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bennen' nake' benne' wsedle žaḻa' yebele' cha' sáke'le' gake' kan nak bennen' žsedle' ḻe', na' benne' wen žin na' žaḻa' yebele' cha' gake' kan nak x̱ane'. Cha' neda' naka' ka benne' x̱an yo'o, na' ẕnnégake' chia', ẕnnágake' naka' Belzebú da' x̱iwe', ḻezka' da' zí'teže nnégake' chegak benách ka' žónḻengake' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ḻezka' wnná Jesusen': —Che ḻen, bi žébele benách ka'. Ḻa' ḻaw yógo'te da' ka' žaken ži žize, na' gak bia' yógo'te da' zej ngache'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Da' ẕcháḻjḻena' ḻe'e gan nak choḻ, le wchaḻjen gan nak ḻo baní', na' da' žapa' ḻe'e gan ngache', le nne zižje gan nak kwáselo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bi žébele benne' ka', benne' žótgake' beḻa' žen chegak benách ka', san bi gak wchínnjgake' be' nákkzežo. Le žebe Dios, Bennen' gak gote' beḻa' žen chele, na' ḻezka' gak cho'ne' be' nákkzele ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Želdó'o chope byínnedo' ḻen to mežw lasdo', san bi bix̱e nitoba' ḻo yo cha' bi žonn X̱ažo Dios latje gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ḻezka' yógo'te yicha' yichjle ba blab Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Che ḻen, bi žébele. Záka'žele ḻe'e ḻaw Dios ka záka'gak bia zan byínnedo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ḻezka' wnná Jesusen': —No benne' nne' žónḻene' neda' tẕen ḻawgak benách ka', ḻezka' neda' nnia' žonḻen bennen' neda' tẕen ḻaw X̱a', Bennen' zoe' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Benne' ka', benne' ẕbej yíchjgake' neda' ḻawgak benách ka', na' ẕnnágake' bi žónḻengake' neda' tẕen, ḻezka' neda' kwej yichja' ḻégake' ḻaw X̱a', Bennen' zoe' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ḻezka' wnná Jesusen': —Bi gekle za'a neda' nich ko'a yežlyó nga da' gonen ga gakgak benách ka' toze. Bi za'a nich gona' ga gakgak benách ka' toze, san za'a nich ko'a da' gonen ga ḻa'a lazgak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Za'a nga, na' gona' ga kwej yichjgak benách ka' x̱ágake', na' ḻezka' no'le ka' kwej yíchjgake' x̱ná'gake'. Ḻezka' no'le ẕoa' ližgak ka' kwej yíchjgake' x̱to' ẕí'ngake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ki gaken, ḻa' lježgak benách ka' wsaka' zí'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’No benne' nží'ižele' x̱a x̱ne'e ka nži'ile' neda', bi nake' zi gónḻene' neda' tẕen, na' no benne' nží'ižele' x̱kwide' byo chie' o x̱kwide' no'le chie' ka nži'ile' neda', bi nake' zi gónḻene' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","No benne' bi si' ḻo ne'e gake' ka to benne' zejté'e ḻe'e yag kroze, na' gónḻene' neda' tẕen, bi nake' zi gake' chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","No benne' že' ḻaže'e gape chi'e yeḻa' nban chie', wniten', san no benne' wnite' yeḻa' nban chie' dan' žónḻene' neda' tẕen, yelá bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ḻezka' wnná Jesusen': —No benne' gape' ḻe'e ba la'ne, ḻezka' gape' neda' ba la'ne, na' bennen' gape' neda' ba la'ne, ḻezka' gape' ba la'ne X̱ažo Dios, Bennen' bseḻe'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","No benne' gape' ba la'ne to benne' ẕchaḻje' ḻo wláz Dios dan' ẕchaḻje' ḻo wlaze' Ḻe', si' bennen' ḻa' ḻébeze kan nak da' wneẕjw Dios che bennen' ẕchaḻje' ḻo wlaze' Ḻe'. Ḻezka' no benne' gape' ba la'ne to benne' chawe' dan' nake' benne' chawe', si' bennen' ḻa' ḻébeze kan nak da' wneẕjw Dios che benne' chawen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nóte'teze benne' wneẕjwe' to ẕbíndo'ze nis che to bénne'do' ki dan' nake' benne' wsedle chia' neda', da' li žapa' ḻe'e, si'kze bennen' da' wneẕjw Dios chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kate' beyóž Jesusen' bzejni'ile' benne' wsedle chie' ka', bezé'e ga na', na' wyeje' žejsedle' benách ka', na' žejchaḻje' x̱tiže'e ḻo yež ka' chegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kate' ža ka' Ẕwa, bennen' bezóe' benách ka' nis, nyejwe' liž ya, na' benle' kan nak da' žon Jesusen'. Naž Ẕwan' bseḻe'e chope benne' ka' žónḻengake' ḻe' tẕen, na' bžíngake' gan zoa Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Žoptie' wnnábgekle' Jesusen', na' wnnágake': —¿Nako' Le' Benne' Criston', Bennen' žaḻa' ḻe'e yežlyó nga, o žaḻa' kwezto' na' zejte ḻa' yetó benne'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bechebe Jesusen', na' gože' ḻégake': —Le chej chejzenle Ẕwan' dan' žénlele, na' dan' ẕḻé'elele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Le yi'e kan žaken, žeḻé'egekle benne' ka' gókgake' ḻo choḻe, na' žeza'gak benne' ka' bi gok sá'gake'. Ba beyakgak chawe' benne' ka' wdá'gake' yižwé' leže, na' žeyéngekle benne' kweẕw ka'. Ba bebangak benne' ka' gótgake', na' nníta'gak benne' ka' ẕzéngekle' benne' yache' ka' diža' chawen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ba nez ẕen gaken che bennen' bi gak chope ḻaže'e, na' bi kwej yichje' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kate' ba beza'gak benne' ka' žónḻengake' Ẕwan' tẕen, naž wzó ḻaw Jesusen' ẕcháḻjḻene' benách ka' nníta'gake' ga na' kan nak che Ẕwan', na' gože' ḻégake': —¿Biẕ gónelele ḻé'elele katen' wyejle ḻo latje dachen'? ¿Gónelele ḻé'elele to benne' nake' ka to ya x̱tildo' da' ẕzechj be'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cha' kege, ¿biẕ gónelele ḻé'elele? ¿Gónelele ḻé'elele to benne' nakwe' laže' da' záka'ḻe'en? Nnézkzelele benne' ka' zej nakwe' laže' da' záka'ḻe'en nníta'gake' ližgak benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yetó na', ¿biẕ gónelele ḻé'elele? ¿Gónelele ḻé'elele to benne' ẕchaḻje' ḻo wláz Dios? Ka' naken, žekla' neda'. Žapa' ḻe'e, bḻé'elele to benne' nákḻe'eže' blo ka yezika' benne' ka' bcháḻjgake' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ki naken dan' nak Ẕwan' bennen' nyejw kan nak chie' ḻe'e yiche la'y, da' ẕnnan: Bwia nga, žseḻa'a benne' wbás chia', bennen' cheje' zga'ale' ka Le'. Ḻe' gon chawe'e nez gan tio'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Da' li žapa' ḻe'e. Dot yežlyó nga, bi zoa nitó benne' nakže' blo ka Ẕwan', bennen' bezóe' benách ka' nis, san no benne' nakže' gax̱jw ḻaže' gan ẕnna bia' Dios, Bennen' zoe' ya'abá, nakže' blo ka Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Katen' wzó ḻaw bezóa Ẕwan' benách ka' nis, na' zejte na'a ža, de chgi' želžó'o benách ka' gan ẕnna bia' Dios, Bennen' zoe' ya'abá, na' benne' wechóg ḻaže' ka' žon byéngake' chó'ogake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kate' bḻa'te ža na' wzóa Ẕwan', da' bchi'le Moisés ḻe'e, na' da' bzojgak yógo'te benne' ka' bcháḻjgake' ḻo wláz Dios bḻoé'egeklen kan ẕnna bia' Dios, Bennen' zoe' ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Cha' žénelele si' ḻo na'le da' ki, žaḻa' nnézlele Ẕwan' nake' Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, na' nake' bennen' wnná Dios žaḻa' yeḻé'e da' yoble ža ni zoažo na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","No benne' zoa nage', na' ženle', žaḻa' wzé nage'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Biẕ wsaka' ḻeba' kan zej nak benne' ka' nníta'gake' ža ni zoažo na'a? Zej nake' ka x̱kwide' ka' želbe'be' ḻawe' ya'a. Ẕbéžeya'agakbe', na' žḻižgakbe' ljéžgakbe' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","na' želnnabe': “Ẕkwéžeto' chele bžejw. ¿Biẕ chen' bi ẕa'ale? Žoḻ nyáche'to' chele. ¿Biẕ chen' bi ẕbeže nyáche'le?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ki nakle, dan' bḻa' Ẕwan', na' dan' bi bdawe' kan žawle ḻe'e, wnnele chie', wnnale: “Da' x̱iwe' žónḻenen ḻe' tẕen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Naž bḻa'a neda', Benne' Golje' Benách, na' že'j žawa', na' ẕnnele chia', ẕnnale: “Nake' benne' wawḻe'e, na' benne' že'je'. Nake' lježgak benne' wechiẕjw ka', na' yezika' benne' wen doḻa' ka'.” Yeḻa' žejní'il che Dios nak bian' ni'a che da' žongak benne' ka' nzi' ḻo ná'gaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Naž wzó ḻaw Jesusen' ẕdiḻe' benne' ka' nníta'gake' ḻo yež ka' gan bene' da' zan yeḻa' wak ẕen ka', dan' bi beyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gože' ḻégake': —Da' nyáche'ḻe'e gaken chele ḻe'e, benách ka' che yež Korazín. Da' nyáche'ḻe'e gaken chele ḻe'e, benách ka' che yež Betsaida. Chela' gokgak yeḻa' wak ẕen ka' ḻo yež Tiro, na' ḻo yež Sidón ka da' ka' bena' gan zoale, ža ni'tel yeyát ḻáže'gak benne' ka' che yež Tiro na', na' che yež Sidón na', na' gákwgake' laže' zeche', na' wžíagake' de yíchjgake', da' wḻoe'elen žeyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na'a, neda' žapa' ḻe'e, kate' žin ža chog Dios chegak benách ka' sáka'ḻe'egake', sáka'žele ḻe'e kan sáka'gak benne' ka' che yež Tiro na', na' che yež Sidón na', yež ka' bchinnj Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ḻe'e, benne' ka' che yež Kapernaum, ¿žékelele ḻe'e cho'ole ya'abá che Dios dan' bḻé'elele da' ka' bena' neda'? Yetjle ḻo yi' gabíl. Chela' gokgak yeḻa' wak ẕen ka' ḻo yež Sodoma, ka da' ka' bena' gan zoale, ga'ngak benne' yežen', na' zejte na'a ža. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na'a, neda' žapa' ḻe'e, kate' žin ža chog Dios chegak benách ka' sáka'ḻe'egake', sáka'žele ḻe'e kan sáka'gak benne' ka' che yež Sodoma na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kate' ža na' bchaḻj Jesusen', na' wnné': —Ẕka'n ẕena' Le', X̱e, nako' X̱an ya'abá, na' X̱an yežlyó nga, dan' bkacho'o da' ki, nich bi ḻé'egeklen benne' ka' žejní'igekle', san bḻoe'elo' benne' ka' zej nake' ka x̱kwide' ka' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ka'kze gaken, X̱e, dan' ki wyáz ḻažo'o Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ba bde X̱an' yógo'te ḻo na'a neda'. Bi nonbia' no benne' neda', Ẕi'n Dios, san toze X̱ažo Dios, na' bi nonbia' no benne' X̱ažo Dios, san toza' neda', Ẕi'n Dios, na' ḻezka' benne' ka' žénela' wḻoe'ela' ḻégake' X̱ažo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Le gonḻen neda' tẕen yógo'tele žejx̱áke'le dan' žóntezle žin che yodo', na' nwa'le ywa' zi'i che da' ẕchi'le yodo', na' neda' gona' ga yezí' ḻáže'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ḻo yeḻa' gax̱jw ḻaže' chele le gon x̱china', gakle ka go'n ka', bia ka' želzi'ba' yogo' chégakba'. Le wsedle da' nnia' neda', dan' naka' gax̱jw ḻaže', na' kwide' ḻaže', na' žéḻ-lele yeḻa' žezí' ḻaže', na' ga'n ži yichj ḻáẕdo'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yogon' dan' x̱oa' ḻe'e, dan' naken da' wchi'la' ḻe'e, bi naken zede, na' ywa' wa'a ḻe'e da' naken da' žsedla', žá'ado'ze naken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kate' ža na', da' naken ža la'y chegak benne' judío ka', wdé Jesusen' gan de yele ẕoa' stribe. Želdón benne' wsedle chie' ka', na' wzó ḻáwgake' želké'e bisto gan žia ẕoa' striben', na' žáwgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kate' benne' yodo' fariseo ka' bḻé'egekle' da' ni, góžgake' Jesusen': —Bwia nga, žongak benne' wsedle chio' ka' da' bi žaḻa' gonžo ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Naž Jesusen' gože' ḻégake': —¿Bi beḻ-le ḻe'e yiche la'y kan nak da' ben Dabí katen' wdone', na' ḻezka' wdongak benne' ka' wnníta'ḻengake' ḻe'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wyoé'e ḻo yo'o che Dios, na' bdawe' yet x̱til ka' zej nkwe'e ḻo bkog la'y, dan' bi žaḻa' gawe' ḻe', na' bi žaḻa' gawgak benne' ka' wnníta'ḻengake' ḻe', san toze bx̱oz ka' de latje gáwgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Bi beḻ-le da' wnná Moisés wak gongak bx̱oz ka' ža la'y ka'? Žóngake' žin ḻi'a yodo' ža la'y ka', na' bi želbage'e doḻa'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na'a, neda' žapa' ḻe'e, zoa' neda' nga, na' naka' benne' nakže' blo ka yodo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bi žejní'ilele dan' nyejw ḻe'e yiche la'y, da' ẕnnan: “Žénela' yeyache' ḻáže'lele lježle ka', na' kégeze gotle bia beždo' ka', bia ka' ẕzeyle ḻo bkog la'y chia'.” Chela' žejní'ilele da' ki, bi besbága'le benne' ka' ẕia, benne' ka' bi želbage'e ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ka' naken, dan' naka' neda', Benne' Golje' Benách, X̱an ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naž bezá' Jesusen' ga na', na' wyoé'e ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ḻo yo'on' wzóa to benne' nžeke' ne'e, na' dan' žénegekle benne' judío wnná bia' ka' žéḻgekle' to da' gak yesbága'gake' Jesusen' ẕia, che ḻen wnnábgekle' Ḻe', na' wnnágake': —¿De latje yeyonžo no benne' yižwé' kate' nak ža la'y? ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bechebe Jesusen', na' gože' ḻégake': —No benne' ládjwle ḻe'e, cha' zoa to ẕila' chie', na' cha' bix̱ba' toba' ḻo yežw kate' nak ža la'y, ¿bi chejleje'-ba'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Záka'že to benne' ka to ẕila'. Che ḻen, de latje gonžo da' nak chawe' chegak benách ka' kate' nak ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naž Jesusen' gože' benne' yižwén': —Bḻi no'o. Kate' bḻi ne'e, ḻa' beyakten chawe' kan nak yecheḻá'a ne'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naž bežachjgak benne' yodo' fariseo ka', na' béngake' x̱tíža'gake' nich gótgake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kate' gókbe'ele Jesusen' da' ni, bezé'e ga na', na' benne' zan jákḻene' Ḻe' tẕen. Naž Jesusen' beyone' yógo'te benne' yižwé' ka', benne' nníta'gake' ládjwgak benách ka', ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na' bchi'le' ḻégake' bi wzéngekle' benách ka' no nake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kate' bcháḻjḻene' ḻégake' gok da' wnná Isaías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, katen' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Le wia nga, Bennen' nake' wen žin chia', Bennen' wžekza' neda'. Nži'ila' Ḻe', na' žaz ḻaža'a Ḻe'. Wchiza' Ḻe' Be' La'y. Ḻe' wzenle' yógo'te benách kan gona', wchi'a ḻaža'a ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bi tiḻ diže'e ḻen no benne', na' bi nnie' zižje, na' bi yenle no benne' chi'e gan nak zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","To ya x̱tildo' da' zoa be bi chichjwen', na' to yi' da' za' yoḻen, bi wsoḻen', kate' wzoaže' da' nak chawe' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yógo'te benách ka' wẕén ḻáže'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naž bḻa'gak benne' ka' zej noe'e to benne' ḻo choḻe gan zoa Jesusen', bennen' bi žak nnie', dan' yoe'e be' x̱iwe', na' Jesusen' beyone' ḻe'. Ki goken, bennen' goke' ḻo choḻe, na' bi gok nnie', na'a ẕḻe'ele', na' ẕchaḻje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Che ḻen bebán ḻáže'gak yógo'te benne' ka' nníta'gake' ga na', na' wnnágake': —¿Nak benne' ni ẕa'só Dabí, bennen' žaḻa' ḻe'e? ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kate' béngekle benne' yodo' fariseo ka' da' ni, wnnágake': —Benne' ni žebeje' be' x̱iwe' ka', dan' Belzebú, da' x̱iwe', dan' naken x̱angak be' x̱iwe' ka', žónḻenen Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Žákbe'ele Jesusen' dan' ẕza' ḻáže'gake', na' gože' ḻégake': —Gáte'teze gan ẕnna bia'gak benách ka', cha' žoj chóplegak benne' ka', na' cha' tíḻ-ḻengake' ljéžgake' ka', kwia yi' yeḻa' wnná bia' chégake'. Ḻezka', cha' žoj chóplegak benách ka' nníta'gake' to yež o to yo'o, na' cha' tíḻ-ḻengake' ljéžgake' ka', bi gak dia'gak benne' ka' nníta'gake' ḻo yežen' o ḻo yo'on'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ḻezka', cha' kwej da' x̱iwe' ḻa' ljéžekzen, na' cha' tíḻ-ḻengak be' x̱iwe' ka' ḻa' ḻégakkzen, ¿nakx̱kze gak dia' yeḻa' wnná bia' che da' x̱iwen'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ẕnnele chia', na' ẕnnale žebeja' be' x̱iwe' ka' dan' Belzebú da' x̱iwe' žónḻenen neda' tẕen. Cha' neda' žona' ki, ¿noẕ benne' žónḻene' tẕen benne' ka' žónḻengake' ḻe'e tẕen kate' žebéjgake' be' x̱iwe' ka'? Che ḻen, da' žóngakkze' nak bian' nchíx̱elele ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na'a, cha' neda' žebeja' be' x̱iwe' ka' dan' zoaḻen yeḻa' wak che Dios Be' La'y neda', da' li yeḻa' wnná bia' che Dios ba bḻan' ga zoale ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Gak no benne' choe'e liž to benne' waḻe, na' kweje' yeḻa' wnni'a da' žen' liže', cha' zga'ale bi wcheje' benne' waḻen'? Naž gak choe'e nich wtache' liž benne' waḻen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’No benne' bi žónḻene' neda' tẕen, ẕbej yichje' neda', na' ḻezka' no benne' bi ẕtóbḻene' neda' tẕen, žóslase'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Che ḻen žapa' ḻe'e, yógo'te doḻa' da' žongak benách ka', na' diža' zi' ka' da' ẕnnégake' che Dios, yenít ḻaw Dios chégake', san no benne' nne zi'e che Dios Be' La'y, batkle yenít ḻaw Dios chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ḻezka', cha' no benne' nnie' chia' neda', Benne' Golje' Benách, Dios yenít ḻawe' chie', san no benne' nnie' che Dios Be' La'y, batkle yenít ḻaw Dios chie'. Bi yenít ḻawe' chie' ža ni zoažo na'a, na' bi yenít ḻawe' chie' ža zezán'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ḻezka' wnná Jesusen': —Cha' nak ẕix̱ to yag, kwian da' ẕix̱, san cha' bi nak ẕix̱ bi kwian da' ẕix̱. Ki naken, da' ẕbia to yag nak bian' kan naken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ḻe'e, lježgak bele snia nakle. ¿Nakx̱ gak wchaḻjle da' naken chawe', cha' bi nakle chawe'? Kan nak da' ẕza' ḻáže'gak benách ka', ḻezka' ẕcháḻjgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ẕchaḻj to benne' chawe' da' nak chawe' dan' yo'o da' naken chawe' ḻo yichj ḻáẕda'we', san ẕchaḻj no benne' bi nake' chawe' da' bi nak chawe', dan' yo'o da' bi naken chawe' ḻo yichj ḻáẕda'we'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Che ḻen žapa' ḻe'e, kate' žin ža chog Dios chegak benách ka' sáka'gake', wchi'a ḻaže'e benách ka' ni'a chegak yógo'te diža' da' wnnágakkze' ka'ze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kan nak da' ẕnno', wchi'a ḻaže'e le', na' yežojo' chawe' o bago'o ẕia ni'a che dižan' da' wnnó'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naž beži'igak benne' yodo' fariseo ka' ḻen benne' yodo' wsedle ka', na' góžgake' Jesusen': —Benne' wsedle, žénelto' ḻe'elto' to da' gono' da' gak bian' gan za' yeḻa' wnná bian' da' napo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bechebe Jesusen', na' gože' ḻégake': —Benne' ki, benne' wen da' ẕinnj ka', na' bi zej nake' dot ḻi ḻaže', ẕnnábgekle' neda' gona' to da' gak bian' no naka'. Bi be da' gak bian' ḻé'egekle', san toze da' nak bia' kan gok che Jonás, bennen' bchaḻje' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kan gok che Jonasen', bga'ne' ḻe'e bel ẕen chonne ža chonne yele, ḻezka' gaken chia' neda', Benne' Golje' Benách, dan' chonne ža chonne yele ga'na' ẕan yo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Benne' ka' wnníta'gake' ḻo yež Nínibe chásgake' ža na' kate' chog Dios chegak benách ka' da' gone' chégake', katen' wchi'a ḻaže'e benách ka' nníta'gake' ža ni zoažo na'a, na' da' bengak benne' ka' che yež Nínibe na' yesbagan' benách ki ẕia dan' beyát ḻáže'gak benne' ka' che yež Nínibe na' katen' Jonasen' bzenle' ḻégake' x̱tiža' Dios, na' na'a zoa' neda' nga, na' nákḻe'eža' ẕen ka Jonasen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ḻezka' no'len' wnná bi'e yežen' da' žen' zaka' gan ẕde wbíž byo' zag ka' chase' ža na' kate' chog Dios chegak benách ka' da' gone' chégake' kate' wchi'a ḻaže'e benách ka' nníta'gake' ža ni zoažo na'a, na' da' ben no'len' yesbagan' ḻégake' ẕia, dan' bžoj no'len' gan nakḻe'e zi'to' nich yenle' diža' sina' da' bchaḻj Salomón, na' na'a zoa' neda' nga, na' nákḻe'eža' ẕen ka Salomón na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ḻezka' wnná Jesusen': —Kate' žežój be' x̱iwe' yo'o to benne', ẕdan gan nbiž, na' žiljen gan yezí' ḻažen'. Cha' bi wžeḻ-len gan yezí' ḻažen', ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","naž nnan: “Yeyá'a latje chia' gan bžoja'.” Kate' yežinen gan bžojen, chejx̱akan' bennen', nake' ka to yo'o ndachen, na' nloan, na' ba nba'an nich chejsóa no benne' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naž chej be' x̱iwen', na' chejx̱ín' yegaže be' x̱iwe' ka', be' zej nakžen x̱iwe' ka ḻen, na' chó'ogaken yógo'ten, na' chejnníta'gaken ḻo yichj ḻáẕdo'w bennen', na' ga ze ḻaw gakže nyache' che bennen' kan goken chie' zga'ale. Ḻezka' gaken chegak benách ki, benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kate' Jesusen' ne ẕcháḻjḻene' benách ka' da' ni, bžin x̱ne'e ḻen benne' biche'e ka' ga na'. Wnníta'gake' ḻa' ḻí'ale, na' gónegekle' wcháḻjḻengake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Naž to benne' bzenlen' Jesusen', na' wnné': —Bwia nga, zoa x̱no'o ḻen benne' bicho'o ka' ḻa' ḻí'ale, na' žénegekle' wcháḻjḻengake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Bechebe Jesusen', na' gože' bennen' bzenle' Ḻe' da' ni, na' wnné': —¿Nnézlele no benne' nake' x̱na'a, na' no benne' ka' zej nake' benne' bícha'ado' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Naž bḻi ne'e, na' bḻoe'ele' benne' wsedle chie' ka', na' wnné': —Bwia nga, benne' ki zej nake' ka x̱na'kza', na' benne' bíche'kza' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nóte'teze benne' žone' kan žénele X̱a', Bennen' zoe' ya'abá, benne' ni nake' bi' bíche'kza', na' bi' zankza', na' x̱na'kza'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ḻa' ža na'ze bžoj Jesusen' ḻo yo'o, na' bejsóe' žoa'a nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dan' bdobgak benne' zan gan zoa Jesusen', wžene' to ḻo barkw, na' wži'e ga na', na' benne' zan ka' wnníta'gake' ḻo yo biž žoa'a nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Naž Jesusen' bcháḻjḻene' ḻégake', na' da' zan da' bsedle' ḻégake', da' ka' bsaka' ḻebe', na' wnné': —Le wia nga, bžoj to benne' žaz, yjeze' bínnedo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kate' ne zjeze', béx̱jwgak baḻe bínnedo' ka' žoa'a nez, na' bžingak byínnedo' ka', na' bdáwgakban'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Béx̱jwgak yebaḻe bínnedo' ka' ḻo yo gan že' yej, gan de láte'ze yo, na' ḻa' bḻá'tegaken, dan' de láte'ze yo ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Naž kate' bḻa' wbíž, ḻa' wbižte dan' goze', dan' bi zoa gan gon lwen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Béx̱jwgak yebaḻe bínnedo' ka' gan beḻa'gak lba yeche' ka'. Belgóleḻe'e lba yeche' ka', na' bdóbgaken dan' goze', na' bžia yí'gaken ḻégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Béx̱jwgak yebaḻe bínnedo' ka' gan nak ḻo yo beb, na' bnéẕjwgaken. Bnéẕjwgak baḻe dan' goze' yetó gaywá' ka'. Bnéẕjwgaken yebaḻen yechonnḻalj ka', na' bnéẕjwgaken yebaḻen yechí žoa ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","No benne' zoa nage', na' ženle', žaḻa' wzé nage'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naž bžingak benne' wsedle ka' che Jesusen' gan zoe', na' wnnábgekle' Ḻe', na' wnnágake': —¿Biẕ chen' ẕcháḻjḻeno' benách ka' da' ka' žsaka' ḻebo'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bechebe Jesusen', na' gože' ḻégake': —Dios žonne' ḻe'e latje chejní'ilele da' ngache' kan ẕnna bi'e Ḻe' ya'abá chie', san benne' ki bi žénegekle' chejní'igekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","No benne' ẕzi'e x̱tiža' Dios, Dios wneẕjwe' chie' yelate', na' gáta'ḻe'en chie', san no benne' bi ẕzi'en, da' do'ze dan' ba nzi'e yegá'n. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Che ḻen ẕcháḻjḻena' ḻégake' da' ka' žsaka' ḻeba', dan' ẕwíagake' san bi ẕḻé'egekle'. Želyenle' san bi ẕze nággake', na' bi žejní'igekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ki žaken, ẕžin da' wnná Isaías, bennen' bchaḻje' ḻo wláz Dios, katen' wnné': Da' li yénlele san bi chejní'ilele. Wíaḻe'ele san bi ḻé'elele da' nakkzen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ki naken dan' nak zide yichj ḻáẕdo'gak benne' ki, na' bi be žaz ḻo yichj nággake'. Nyejw yej ḻáwgake', na' bi ẕḻé'egekle' ḻen yej ḻáwgake' ka'. Bi ẕze nággake' na' bi ẕzejní'igekle' yichj ḻáẕdo'gake', na' bi žeyákgake' chia' neda', nich gak yeyona' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Na'a, ba nez ẕen naken chele ḻe'e, dan' ẕḻé'egekle yej ḻawle ka', na' žéngekle nagle ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Da' li žapa' ḻe'e, benne' zan, benne' bcháḻjgake' ḻo wláz Dios, na' benne' chawe' ka', gónegekle' ḻé'egekle' da' ẕḻé'elele ḻe'e, san bi bḻé'egeklen'. Gónegekle' yéngekle' da' žénlele ḻe'e, san bi béngeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ḻezka' wnná Jesusen': —Le wzé nag da' žsedle da' bsaka' ḻeba' che benne' žaz. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nóte'teze benne' ženle' diža' kan ẕnna bia' Dios ya'abá, na' bi žejni'ilen', žak che diža' da' benlen' kan gok che bínnedo' ka' béx̱jwgaken žoa'a nez. Ḻa' za'te da' x̱iwe', na' žeká'n dižan' da' wyazen ḻo yichj ḻáẕdo'w bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bínnedo' ka' béx̱jwgaken ḻo yežlyón' gan že' yej žsédgeklen kan žak che no benne' ženle' dižan', na' ḻa' ẕze nagtien' ḻo yeḻa' žebél chie', ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","san kan bi wdia'gak bínnedo' ka' dan' bi gota' gan góngaken lwen, ḻezka' žaken che bennen'. Kate' žin to da' žsaka' zin' ḻe', na' kate' ẕbia ḻáže'gak benách ka' ḻe' dan' nzi' ḻo ne'e dižan', ḻa' gakte chope ḻaže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bínnedo' ka' béx̱jwgaken gan bególegak lba yeche' ka' žsédgeklen kan žak che bennen' ženle' dižan', san ẕdan ḻaže'e da' ka' zej nnitan' yežlyó nga, na' da' ka' žon ḻáže'geklen bennen' dan' ẕdan ḻaže'e yeḻa' wnni'a che yežlyó nga. Da' ki žóngaken ga kwia yi' dižan', na' bi gak gonen žin ḻo yichj ḻáẕda'we'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bínnedo' ka' béx̱jwgaken ḻo yo beb žsédgeklen kan žak che bennen' ženle' dižan', na' žejni'ilen', na' žon žin dižan' ḻo yichj ḻáẕda'we'. Zej nak baḻe benách ka' ka bínnedo' ka' bnéẕjwgaken yetó gaywá' ka'. Zej nak yebaḻe benách ka' ka bínnedo' ka' bnéẕjwgaken yechonnḻalj ka', na' zej nak yebaḻe benách ka' ka bínnedo' ka' bnéẕjwgaken yechí žoa ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Naž bsaka' ḻebe Jesusen' yetó, na' gože' ḻégake': —Kan gak gan žin da' ẕnna bia' Dios ya'abá naken kan gok che bínnedo' chawe' ka' da' goz to benne' gan nak ḻo yežlyó chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kate' ne ẕtasgak benne' ka' nníta'gake' liže', bḻa' to benne' ga na', benne' bi ẕḻe'ele' ḻe' chawe', na' yjeze' ḻo yežlyó chien' bínnedo' ka' che yix̱e' ka'ze dan' ẕnnan' kan ẕnna' yele ẕoa' stribe, na' beyeje' latje chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kate' bḻa' ẕoa' striben', na' wžé' bisto chen gan žia ẕoa' striben', naž gok bia'gak yíx̱e'do' ka'ze ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Naž bžingak benne' wen žin ka' gan zoa benne' x̱an yežlyón', na' góžgake' ḻe': “X̱an, cha' gozo' bínnedo' chawe' ka' ḻo yežlyó chion', ¿nakx̱ goken bḻa'gak yíx̱e'do' ka'ze ka'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","X̱an yežlyón' gože' ḻégake', na' wnné': “To benne' bi ẕḻe'ele' neda' chawe' bene' ki.” Naž benne' wen žin ka' wnnábgekle' ḻe', na' wnnágake': “¿Žénelo' chejto' chejḻážo'to' yíx̱e'do' ka'ze ka'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naž x̱ángake' gože' ḻégake': “O'o. Kate' wlážo'le yíx̱e'do' ka'ze ka', ḻezka' wlážo'ḻentele yele ẕoa' stribe ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gakže chawe' gonnle latje gólegaken tẕen na' zejte chejtobžon, na' naž yapa' benne' ka' wtóbgaken': le wtób zga'ale yíx̱e'do' ka'ze ka', na' le wchejen chejx̱ónn weje nich wzeyžon, na' naž wtoble ẕoa' striben' ḻo yo'o chia'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yetó da' bsaka' ḻebe Jesusen', na' gože' ḻégake': —Kan gak gan žin da' ẕnna bia' Dios ya'abá, gaken kan gok che to bínnedo' mostasa, dan' goz to benne' gan nak ḻo yežlyó chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Da' li bínnedo' mostasa na' nakžen da' do'ze ka zej nak yógo'te bínnedo' yezika' ka', san kate' ba nazen, ẕgóležen ka yógo'te yix̱e' kwan ka', na' žaken ẕen kan nak to yag, na' želžín byínnedo' ka', na' žóngakba' x̱ó'ngakba' ka' ḻo ni'a nen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yetó da' bsaka' ḻebe Jesusen', na' gože' ḻégake': —Kan gak gan žin da' ẕnna bia' Dios ya'abá gaken ka ben kwa zichj che yet x̱til, dan' bchix̱e to no'le ḻen chonne lbix̱ yezje ẕoa' stribe, na' wyache' dot kwa na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yógo'te da' ki bsaka' ḻebe Jesusen', da' ka' bcháḻjḻene' benách ka' nníta'gake' ga na', na' bi bcháḻjḻene' ḻégake' da' bi bsaka' ḻeben'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ki bene', na' bžin dan' bzoj to benne' bchaḻje' ḻo wláz Dios ža ni'te, katen' wnné': Wchaḻja' da' ka' wsaka' ḻeba'. Nnia' da' bgache' katen' wzó ḻaw žata' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Naž Jesusen' bzele diže'e benách ka' nníta'gake' ga na', na' beseḻe'e ḻégake', na' Ḻe' beyoé'e yo'o. Naž bžingak benne' wsedle chie' ka' gan zoe', na' góžgake' Ḻe': —Bḻoe'el neto' da' žsedle dan' bsaka' ḻebo' che yíx̱e'do' ka'ze dan' ẕnnan' kan ẕnna' yele ẕoa' stribe. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bechebe Jesusen', na' gože' ḻégake': —Benne' žaze' bínnedo' chawe' naka' neda', Benne' Golje' Benách. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ga na' goze' bínnedo' ka' naken yežlyó nga, na' bínnedo' chawe' ka' zej naken benne' ka' zej nbabe' gan ẕnna bia' Dios. Yíx̱e'do' ka'ze ka' dan' ẕnnan' kan ẕnna' yele ẕoa' stribe zej naken benne' ka' zej nake' che da' x̱iwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bennen' bi ẕḻe'ele' chawe' x̱an yežlyón', na' goze' yíx̱e'do' ka'ze ka', da' x̱íwe'kze naken. Ža na' katen' wtóbgaken' naken ža ze ḻawte ža ka' che yežlyó nga, na' benne' ka' ẕtóbgaken' zej nake' wbás che ya'abá ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kan goken, btóbgake' yíx̱e'do' ka'ze ka', na' bzéygaken' ḻo yi', ḻezka' gaken kate' yeyóž che yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neda', Benne' Golje' Benách, seḻa'a wbás la'y chia' ka', na' kwéjgake' yógo'te benne' ka' gan ẕnna bia' Dios, benne' ka' žóngake' ga žongak ljéžgake' ka' doḻa', na' ḻezka' benne' ka' žóngake' da' kegle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wbás che ya'abá ka' chó'ngake' benne' ka' ḻo yi' gabíl, benne' wen da' ẕinnj ka', na' kwéžegake', na' wx̱éj láye'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Naž benách chawe' ka' chépgake' yes baní', na' gákgake' kan nak wbíž gan ẕnna bia' Dios ya'abá chie'. No benne' zoa nage', na' ženle', žaḻa' wzé nage'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ḻezka' bsaka' ḻebe Jesusen', na' wnné': —Da' ẕnna bia' Dios ya'abá chie' naken ka to yeḻa' wnni'a, da' ngache' to ḻo yežlyó. Katen' to benne' bžeḻ-len', bekache'en gan bgachen', na' ḻo yeḻa' žebél chie' wyeje', na' bete'e yógo'te da' nape', na' go'we' yežlyón' nich gata' yeḻa' wnni'a na' chie' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ḻezka' wnná Jesusen': —Kan žaḻa' dan ḻáže'le da' ẕnna bia' Dios ya'abá chie' naken kan ben to benne' ža'we', na' žote'e, na' žilje' bga zaka' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kate' bžeḻ-le' to bga da' záka'ḻe'en, wyeje', na' bete'e dot da' nape', na' go'we' bgan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ḻezka' wnná Jesusen': —Kan gak gan žin da' ẕnna bia' Dios ya'abá chie', gaken kan žon to yix̱jw bel da' bzáḻa'gak benne' ka' ḻo nisdo', dan' bejx̱enen bel zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Katen' ba bežá' yix̱jwn', na' bebéjgaken' ḻo yo biž žoa'a nisdon', gan wžé'gake', na' bnníta'gake' bel chawe' ka' ḻo x̱kwite ka', na' bel ka'ze ka' wžó'ngake' ḻégakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ḻezka' gaken kate' yeyóž che yežlyó nga. Žojgak wbás che ya'abá ka', na' kwéjgake' cheze benne' chawe' ka', na' yekwásgake' ḻégake' ladjw benne' wen da' ẕinnj ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","’Naž chó'ngake' benne' wen da' ẕinnj ka' ḻo yi' gabíl, gan kwéžegake', na' wx̱éj láye'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Naž Jesusen' wnnable' benne' wsedle chie' ka', na' wnné': —¿Žejní'ilele yógo'te da' ki? Bechébegake', na' góžgake' Ḻe': —O', X̱an. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesusen' gože' ḻégake': —Katen' to benne' yodo' wsedle ba nzi' ḻo ne'e da' ẕnna bia' Dios ya'abá chie', nake' ka to benne' x̱an yo'o, benne' žebeje' ladjw yeḻa' wnni'a chie' da' kobe, na' da' gole, da' ka' zej naken chawe', da' ka' žebéḻenlen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kate' beyóž bsaka' ḻebe Jesusen' da' ki, bezé'e ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kate' bežine' gan nak laže', bsedle' benne' ka' nníta'gake' ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' bebángekle', na' wnnágake': —¿Gaẕ bsedle benne' ni yeḻa' žejní'il ni? ¿Nakx̱ naken, žone' da' zan yeḻa' wak ki? ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Benne' ni nake' ẕi'n benne' ẕkonle' žin blag ka', na' x̱ne'e lie' Lia. Nake' bíche'gak Jakob, na' Jwsé, na' Smon, na' Judas. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ḻezka' no'le zane' ka' nníta'ḻengake' žo'o nga. ¿Gaẕ bsedle' yógo'te da' ki? ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Che ḻen gok chope ḻáže'gake', na' bebéj yíchjgake' Ḻe'. Naž Jesusen' gože' ḻégake': —Yógo'te benách ka' žápegake' ba la'ne no benne' ẕchaḻje' ḻo wláz Dios, san benách wláž chie' ka', na' benne' ka' nníta'gake' liže' bi žápegake' ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Che ḻen bi ben Jesusen' da' zan yeḻa' wak ka' ga na', dan' bi žejḻé'gake' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kate' ža ka', benle Herodes, bennen' ẕnna bi'e gan nbab Galilea, kan zej nak yeḻa' wak ka' da' žon Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes na' gože' ni'a ne'e ka', na' wnné': —Bennen' nake' Ẕwa, bennen' bezóe' benách ka' nis. Ba bebane' ḻo yeḻa' got. Che ḻen nzi' ḻo ne'e yeḻa' wak ẕen na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ki wnná Herodes na' dan' bséḻa'kze' benne' ka' béx̱wgake' Ẕwan'. Bchéjgake' ḻe' do ya, na' bséjwgake' ḻe' liž ya dan' gónele Herodías gaken ki. Herodías na' goke' ẕo'le Lip, benne' biche' Herodes na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ki ben Herodes na', dan' Ẕwan' gože' ḻe': “Bi žaḻa' sóaḻeno' ẕo'le benne' bicho'o.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Che ḻen gónele Herodes na' gote' Ẕwan', san bžebe' wži'igak benne' wláž ka' chie', dan' žékgekle' nak Ẕwan' benne' ẕchaḻje' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naž kate' gok lni che ža wyé'el yiz Herodes na', bžoj x̱kwide' no'le che Herodías na', na' bya'abe' gan že'gak benne' ka' nníta'gake' lni na', na' wyáz ḻaže' Herodes na' da' benbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bchebe ḻaže' Herodes na', na' ben choche' x̱tiže'e wneẕjwe' chebe' bíte'teze da' nnablbe' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dan' ba bsedle x̱na'be' ḻebe' zga'ale, gožbe' ḻe': —Benn chia' na'a to ḻo ẕiga' ẕen yichj Ẕwa, bennen' bezóe' benách ka' nis. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Naž gok nyache' ḻaže' Herodes na', san dan' ba ben choche' x̱tiže'e, na' dan' béngekle benne' ka' chie' ḻe', benne' ka' že'j žáwḻengake' ḻe' tẕen, che ḻen gože' to benne' chejneẕjwe'-be' yichj Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ki goken, bseḻe'e to benne' chejchoge' yen Ẕwan' gan nyejwe' liž ya. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bennen' bseḻe'e beyoé'e yichj Ẕwan' to ḻo ẕiga' ẕen, na' bneẕjwen' che x̱kwide' no'len', na' ḻebe' bnéẕjwben' che x̱na'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Naž benne' ka' bénḻengake' Ẕwan' tẕen bžíngake' ga na', na' beché'gake' ḻe', na' bejkáche'gake' ḻe'. Wdé na', bejzéngekle' Jesusen' kan gok da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kate' benle Jesusen' da' goken che Ẕwan', bezé'e ga na', na' wžene' to ḻo barkw, na' wyeje' toze' to latje dach. Katen' béngekle benách ka' zeje' ga na', bžójgake' ḻo yež ka', na' belzé'e ḻo ní'agake', na' jake' gan žaḻa' žin Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kate' bežój Jesusen' ḻo barkw, bḻe'ele' zej nnita' benách zan ka' ga na', na' beyache' ḻáže'le' ḻégake', na' beyone' benne' yižwé' ka', benne' nníta'gake' ládjwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kate' ba za' žaḻe ža na', wbíga'gak benne' wsedle chie' ka' gan zoe', na' góžgake' Ḻe': —Ba za' žaḻe na'a, na' dache nak latje ni. Beseḻa' benách ki nich chjake' gan že'gak yeždo' ka' nich gá'wgake' da' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Naž Jesusen' gože' ḻégake': —Bi žon byenen chjake'. Le wneẕjw ḻe'e dan' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naž góžgake' Ḻe': —Gáyo'ze yet x̱til den, na' chopze bel ka', bia deba' cheto' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusen' gože' ḻégake': —Le yedjwán' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naž Jesusen' wnné' kwe'gak benne' ka' gan yo'o daka'. Wdé na' bex̱we' da' gayo' yet x̱til ka', na' chop bel ka', na' bchis ḻawe', bwie' zaka' ya'abá. Gože' Dios: “Žóx̱keno'.” Naž bzoẕje' yet x̱til ka', na' bdie' da' ka' ḻo na'gak benne' wsedle chie' ka', na' ḻégake' wdísgake' da' ka' gan že'gak benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bdáwgake' yógo'tegake', na' béljegekle'. Naž betóbgake' da' biẕjw ka' da' begá'ngaken, na' beschá'gake' chežinno x̱kwit ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Benne' byo ka', benne' bdáwgaken', gókgake' gayo' mílgake', san bi blab no benne' no'le ka', na' x̱kwide' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Naž ḻa' bente Jesusen' ga bebengak benne' wsedle chie' ka' ḻo barkw nich chjake' zgá'alegake' ka Ḻe', na' tégake' yecheḻá'a nisdon', katen' yeseḻe'e Ḻe' benne' zan ka', benne' nníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Katen' Jesusen' ba beseḻe'e benne' ka', wžene' to ḻaw ya'ado' gan bejsóe' toze'. Naž bcháḻjḻene' Dios. Katen' ba goḻe, toze' zoe' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Barkwn' gan zej nnita' benne' wsedle chie' ka' ẕden gachje ḻáwe'le nisdon', na' žx̱ite' barkwn' dan' žas nisdon', na' ben' žaken ẕzagan' barkwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wdé gachje yelen', wbiga' Jesusen' žoa'a gan nníta'gake', ẕde' ḻawe'l nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kate' bḻé'egekle benne' wsedle chie' ka' Ḻe', ẕde' ḻawe'l nisdon', gok zédgekle' dan' ẕžébegake'. Wžéžeya'agake', na' wnnágake': —To be' bxin'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Naž Jesusen' ḻa' bḻižtie' ḻégake', na' wnné': —Le gon choch ḻáže'le. Nedan'. Bi žébele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Naž bechebe Bedw, na' gože' Jesusen': —X̱an, cha' nako' Le', wnné neda' sa'a gan zo' ḻawe'l nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusen' gože' ḻe': —Da. Naž betj Bedon' ḻo barkwn', na' wzé'e ḻawe'l nisdon', zeje' gan zoa Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Naž kate' bḻe'el Bedon' kan ẕta be' nisdon', bžebe'. Wzó ḻawe' žetje' ḻo nisen', na' wžéžeyi'e. Bḻiže' Jesusen', na' wnné': —X̱an, beslá neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesusen' ḻa' bḻite ne'e. Bex̱we' ḻe', na' gože' ḻe': —Láte'ze žejḻi'o chia'. ¿Biẕ chen' gok chope ḻažo'o? ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kate' wžén Jesusen' ḻo barkwn', wžé' ži ben' žaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Naž benne' ka' nníta'gake' ḻo barkwn' bka'n ẕéngake' Jesusen', na' wnnágake': —Da' li, Ẕi'n Dios nako'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kate' ba wdégake' yecheḻá'a nisdon', ḻa' bžíntegake' gan nbab yež Jenesaret. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kate' benne' yežen' ka' beyónbia'gake' Jesusen', bséḻa'gake' diža' dot ḻo yežlyón', na' bžingak benách ka' zej noe'e yógo'te benne' yižwé' ka' gan zoa Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Góta'yoegekle' Jesusen' we'e ḻégake' latje kángakze' laže' da' nakwe', na' ḻa' beyáktegak yógo'te benne' ka', benne' wdángake' ẕe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Naž benne' yodo' fariseo ka' len benne' yodo' wsedle ka', benne' ka' zej nžoje' ḻo yež Jerusalén, bžíngake' gan zoa Jesusen', na' góžgake' Ḻe': ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Biẕ chen' žongak benne' wsedle chio' ka' da' ẕdetlen kan zej nak da' žónteze žonžo kan bengak x̱a x̱to'žo ka'? Bi želyíb ná'gake' kan nak che yodo' kate' za' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bechebe Jesusen', na' wnnable' ḻégake', na' wnné': —¿Biẕ chen' ḻezka' ḻe'e ẕzoale cheḻa'ale da' bchi'le Dios ḻe'e, nich gonle da' žónteze žonle? ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nak bia' žonle ki dan' gož Dios ḻe'e, na' wnné': “Wdape ba la'ne x̱a x̱no'o” na' ḻezka' wnné': “No benne' nne zi'e che x̱a x̱ne'e, le got bennen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","San ḻe'e ẕnnale: “Cha' no benne' yi'e x̱a x̱ne'e: Bi be gak wneẕjwa' chele dan' ba bchebe ḻaža'a wneẕjwa' che Dios yógo'ten'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Naž ẕnnale biž žon byenen bi da' gon bennen' che x̱a x̱ne'e. Ki žonle, ẕzoale cheḻa'ale dan' bchi'le Dios ḻe'e, nich gonle da' žónteze žonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ḻe'e, benne' ẕḻoé'ezele chawe' kwinle, nak dot da' li da' wnná Isaías, bennen' bchaḻje' ḻo wláz Dios, kan nakle, katen' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Benne' ki, žoá'agakze' žápegake' neda' ba la'ne, kege dot ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dáche'ze nak kan ẕka'n ẕéngake' neda' dan' žsédgekle' da ka' ẕchí'igekle benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Naž Jesusen' bḻiže' benne' ka' nníta'gake' ga na', na' gože' ḻégake': —Le wzé nag da' yapa' ḻe'e, na' le chejni'ilen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kege da' žaz žoa'a to benne' žonen ga bi nake' chawe' ḻaw Dios, san da' ẕžojen žoe'e žonen ga bi nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Naž benne' wsedle ka' che Jesusen' wbíga'gake' gan zoe'. Wnnábgekle' Ḻe', na' wnnágake': —¿Nnezlo' bža'agak benne' yodo' fariseo ka' katen' béngekle' dan' bchaḻjo'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naž bechebe Jesusen', na' gože' ḻégake': —Yógo'te da' zej nazen, da' bi goz X̱a', Bennen' zoe' ya'abá, yelážo'gaken dot lwen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Le wká'n-gake'. Zej nake' ḻo choḻe, na' želchi'e benne' ḻo choḻe ka'. Cha' to benne' ḻo choḻe chi'e yetó benne' ḻo choḻe, žoptie' bíx̱gake' to ḻo bloj. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Naž bechebe Bedw, na' gože' Jesusen': —Bzejní'il neto' da' ni žsaka' ḻebo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesusen' gože' ḻégake': —¿Ḻezka' ḻe'e bi žejní'ilele? ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nnézlele žaz ḻe'žo yógo'te da' žazen žoá'ažo, na' žežojen ḻe'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Na'a, da' žežojen žoá'ale, ḻo yichj ḻáẕdo'le zan', na' da' ki žóngaken ga bi nakle chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ki žaken dan' ẕḻa'gak ḻo yichj ḻáẕdo'le da' kegle ka' da' ẕza' ḻáže'le, da' gonen ga gotle benách ka', na' da' gonen ga wká'n ditjle yeḻa' ẕchag na', na' da' gonen ga gonle da' ẕinnj, na' da' gonen ga se ḻáže'le bi da' kwanle, na' da' gonen ga nnele che lježle da' bi zej naken da' li, na' da' gonen ga nne yáḻele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da' ki žóngaken ga bi nak chawe' to benne' ḻaw Dios, san cha' bi chibe' ne'e kan nak che yodo' kate' bi da' gawe', da' ni bi gonen ga bi nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naž bezá' Jesusen' ga na', na' wyeje' gan zej nbab yež Tiro, na' yež Sidón. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","To no'le nbabe' to yež da' nbaben Kanaán bžoje' ḻo yežen'. Wnníe' zižje, na' gože' Jesusen': —X̱an, ẕa'só Dabí, beyache' ḻaže'l neda'. X̱kwide' no'le chia' ẕzáka'ḻe'ebe' dan' yo'obe' be' x̱iwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bi be bechebe Jesusen'. Naž wbíga'gak benne' wsedle chie' ka' gan zoe'. Góžgake' Ḻe', na' wnnágake': —Beseḻe' ḻe', dan' ze'e x̱kóže'lžo na' ẕbéžeyi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Naž bechebe Jesusen', na' gože' no'len': —Dios bseḻe'e neda' nich gákḻena' benne' Israel ka', benne' zej nake' ka ẕíla'do' ka' zej nnitlba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naž wbiga' no'len' gan zoa Jesusen'. Bzoa ẕibe' x̱ni'e, na' gože' Ḻe': —X̱an, gokḻen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bechebe Jesusen', na' wnné': —Bi nak chawe' yeka'ažo yet chegak x̱kwide' ka', na' cho'nžon nich gawgak bé'ko'do' ka' ḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Naž no'len' gože' Jesusen', na' wnné': —O', X̱an, san žawgak bé'ko'do' ka' da' biẕjw ka', da' žéx̱jwgaken ẕanle gan žawgak x̱ángakba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Naž bechebe Jesusen', na' wnné': —Nó'ledo'. Dot ḻi ḻaže' nak kan žejḻi'o chia'. Gak chio' kan žénelo'. Ḻa' na'ze beyakte x̱kwide' no'le chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Naž bezá' Jesusen' ga na', na' wdíe' gan nak žoa'a nisdo' che gan nbab Galilea. Wžene' gan nak to ḻaw ya'ado', gan wži'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Benne' zan bžíngake' gan zoa Jesusen', benne' ka' zá'gake' zej noe'e benne' ka' bi žak sá'gake', na' benne' ḻo choḻe ka', na' benne' ka' bi žak nnégake', na' benne' ka' zej nžog ni'a ná'gake', na' benne' zanže, benne' yižwé' ka', na' wdíx̱jwgake' ḻégake' x̱ni'a Jesusen', na' Ḻe' beyone' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bebán ḻáže'gak benne' ka' kan nak da' ben Jesusen', dan' bḻé'egekle' ẕnnagak benne' ka' bi gok nnégake', na' beyakgak benne' ka' bžoggak ni'a ná'gake', na' ẕza'gak benne' ka' bi gok sá'gake', na' ẕḻé'egekle benne' ka' gókgake' ḻo choḻe. Che ḻen bka'n ẕéngake' Dios chegak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Naž Jesusen' bḻiže' benne' wsedle chie' ka', na' gože' ḻégake': —Žeyache' ḻáže'la' chegak benne' zan ki, dan' ba zej chonne ža zá'ḻengake' neda', na' bi be de da' gáwgake'. Bi žénela' yeseḻa' ḻégake' lížgake' želdonze' ka', dan' yedó ḻáže'gake' ḻo nez. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naž benne' wsedle chie' ka' góžgake' Ḻe', na' wnnágake': —¿Gaẕ žéḻ-leto' yet x̱til zan ḻo latje dach nga, nich wawto' benne' zan ki? ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesusen' wnnable' ḻégake', na' wnné': —¿Baḻx̱ yet x̱til de chele? Bechébegake', na' wnnágake': —Gaže, na' ḻezka' babze bel deba' cheto' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naž Jesusen' gože' benne' zan ka' kwé'gake' ḻo yo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bex̱we' gaže yet x̱til ka' ḻen bel ka', na' gože' Dios: “Žóx̱keno'.” Naž bzoẕjen', na' bneẕjwen' chegak benne' wsedle chie' ka', na' ḻégake' wdísgaken' gan že'gak benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bdáwgake' yógo'tegake', na' béljegekle'. Wdé na' betóbgake' da' biẕjw ka' da' begá'ngaken, na' beschá'gake' gaže x̱kwit ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Zej nnita' tap mil benne' byo ka', benne' ka' bdáwgake', san bi blábgake' no'le ka', na' x̱kwide' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Naž Jesusen' beseḻe'e benne' ka' lížgake', na' wžene' ḻo barkwn', na' jake' gan nbab yež Magdala. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Naž benne' yodo' fariseo ka' ḻen benne' yodo' saduseo ka' bžíngake' gan zoa Jesusen' nich si' biá'gake' Ḻe', na' wnnábgekle' Ḻe' gone' to da' gak bian' gan za' yeḻa' wnná bia' chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Bechebe Jesusen', na' gože' ḻégake': —Nnézkzele dan' ẕnnagak benách, ẕnnágake': “Kate' že' bejw kwele, wak yejw.” Ḻezka' ẕnnagake': “Kate' žechj be' bi gak yejw.” ¡Benne' bi nnezle ka'! ¡Žak nneya'ale da' gon ḻawe' ža, san bi žákbe'elele nbága'le ẕia ni'a che da' žónkzelele! ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Benne' ka', benne' žóngake' da' kegle, na' bi zoa dot ḻi ḻáže'gake', želnnable' neda' gona' to da' gak bian' no naka', san bi be da' gak bian' ḻé'egekle'. Toze dan' gok bian' kan gok che Jonás, bennen' bchaḻje' ḻo wláz Dios, ḻé'egeklen'. Naž Jesusen' bkwase' gan nníta'gake', na' beyeje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kate' bžíngake' yecheḻá'a nisdon', gókbe'egekle benne' wsedle ka' che Jesusen' goḻ ḻáže'gake' wá'gake' da' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Naž Jesusen' gože' ḻégake': —Le wia nga. Le gape chi'i kwinle che da' naken ka kwa zichj che yet x̱til chegak benne' yodo' fariseo ka', na' chegak benne' yodo' saduseo ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Naž benne' wsedle chie' ka' bcháḻjḻengake' ljéžgake' ka', na' wnnágake': —Ẕnne' ki dan' bi nwa'žo yet x̱til. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Žákbe'ele Jesusen' da' ni, na' gože' ḻégake': —¿Biẕ chen' žon x̱tíža'le dan' bi nwa'le yet x̱til? Láte'ze žejḻe'le chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Bi žejní'ilele, na' bi žezá' ḻáže'le kan gok chegak gayo' yet x̱til ka', dan' bdawgak gayo' mil benne' ka', na' kan x̱kwit zan ka' betoble? ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ḻezka' bi žejsá' ḻáže'le kan gok chegak gaže yet x̱til ka', dan' bdawgak tap mil benne' ka', na' kan x̱kwit zan ka' betoble? ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bi žejní'ilele? Bi bchaḻja' che yet x̱til katen' goža' ḻe'e gape chi'i kwinle che da' naken ka kwa zichj che yet x̱til chegak benne' yodo' fariseo ka', na' chegak benne' yodo' saduseo ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naž bejní'igekle' Jesusen' bi gože' ḻégake' gape chi'i kwíngake' che kwa zichj che yet x̱til, san žaḻa' gape chi'i kwíngake' che da' žsédgekle benne' yodo' fariseo ka', na' benne' yodo' saduseo ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kate' bžin Jesusen' gan nbab yež Sesarea, gan ẕnna bia' Filipo, wnnable' benne' wsedle chie' ka', na' wnné': —¿Noẕ ẕnnagak benne' ka' naka' neda', Benne' Golje' Benách? ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bechébegake', na' wnnágake': —Baḻe' ẕnnágake': “Ẕwa nako', bennen' bezóe' benách ka' nis.” Yebaḻe' ẕnnágake': “Lías nako', bennen' bchaḻje' ḻo wláz Dios ža ni'te.” Yebaḻe' ẕnnágake': “Jeremías nako', o to benne' yoble, benne' bchaḻje' ḻo wláz Dios ža ni'te.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naž Jesusen' gože' ḻégake': —Cheẕe ḻe'e, ¿noẕ ẕnnale naka' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bechebe Smon Bedw, na' gože' Ḻe': —Le' nako' Benne' Criston', Ẕi'n Dios ban. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bechebe Jesusen', na' gože' ḻe': —Ba nez ẕen naken chio', Smon, ẕi'n Jonás, dan' bi bḻoe'el no benne' le' da' ni, san X̱a', Bennen' zoe' ya'abá, bḻoe'ele' le' da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neda' žapa' le', le' nako' Bedw, na' ḻo yej ni chix̱jwa' benne' ka' zej nake' chia', na' yeḻa' wnná bia' che da' x̱iwe' bi gak wzagan' x̱nézgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wdía' ḻo no'o ẕi'n ya ka' che latje gan ẕnna bia' Dios, Bennen' zoe' ya'abá chie'. Da' wžono' ḻo yežlyó nga, ḻezka' ba bžon Dios, Bennen' zoe' ya'abá chie', na' da' go'o latje gaken ḻo yežlyó nga, ba be' latje gaken Dios, Bennen' zoe' ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naž Jesusen' bchi'le' benne' wsedle chie' ka' bi wzéngekle' nitó benne' nake' Ḻe' Benne' Criston'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ḻa' ža na'ze wzó ḻaw Jesusen' ẕḻoe'ele' benne' wsedle chie' ka' žon byenen cheje' Jerusalén, gan bx̱oz wnná bia' ka' ḻen benne' gole ka', na' benne' yodo' wsedle ka', wsaka' zí'gake' Ḻe', na' naž gótgake' Ḻe', san kate' gak chonne ža, yebane' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naž Bedw bchi'e Jesusen' cheḻa'ale, na' wzó ḻawe' ẕdiḻe' Ḻe', na' wnné': —X̱an, bi gonn Dios latje. Bi gak chio' kan ẕnno'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naž beyéchj Jesusen', na' gože' Bedon': —Bkwas na'le. Žono' le' kan žon da' x̱iwe'. Žono' ga gak chope ḻaža'a dan' kan ẕza' ḻažo'o le' bi naken kan ẕza' ḻaže' Dios, san kan ẕza' ḻáže'gak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Naž Jesusen' gože' benne' wsedle chie' ka', na' wnné': —Cha' zoa no benne' žénele' gónḻene' neda' tẕen, žaḻa' wzóe' cheḻa'ale da' ka' ẕdan ḻaže'e, na' gake' ka to benne' noe'e yag kroze, na' zeje' zejté'e ḻe'e yag krozen'. Naž gak gónḻene' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","No benne' žénele' gape chi'e yeḻa' nban chie', wniten', san benne' wnite' yeḻa' nban chie' dan' žónḻene' neda' tẕen, gata' yeḻa' nban da' zejlí kanne chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bi be da' chawe' gaken che to benne' cha' wtobe' yógo'te da' den yežlyó nga san wnite' yeḻa' nban chie'. Bi be gak wneẕjw bennen' nich gata' yeḻa' nban da' zejlí kanne chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ki ẕnnia', dan' yeḻá'a neda', Benne' Golje' Benách, tẕen ḻen yeḻa' baní' che Dios, X̱a', na' che wbás che ya'abá chia' ka'. Naž yebi'a che to to benne' kan zej nak da' ka' bene'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Da' li žapa' ḻe'e: bi gatgak baḻe benne' ka', benne' nníta'gake' nga, na' zejte ḻé'egekle' yedjnná bi'a neda', Benne' Golje' Benách. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wdé x̱ope ža, Jesusen' bchi'e Bedw na' Jakob, na' Ẕwa, benne' biche' Jakoben', na' jake' cheze gan nak to ḻaw ya'a sibe. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kate' ne nníta'gake' ga na' bža' kan ẕnna' ḻaw Jesusen' ḻáwgake'. Wyép yes baní' ḻaw Jesusen' kan ža'ní' wbíž, na' beyák ẕíla'do'ze laže' nakwe', na' wnnán' ka baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naž bḻé'egekle benne' wsedle chie' ka' kate' bḻa' ḻawgak Moisés na' Lías, ẕcháḻjḻengake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naž Bedon' gože' Jesusen': —X̱an, ba nez ẕen naken chežo zoažo nga. Cha' žénelo', gona' chonne yo'o laga' ka' nga, to chio', na' yetó che Moisés, na' yetó che Lías. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kate' ne ẕchaḻj Bedon' da' ni, ḻa' wže'te to bejw baní' ga na', da' bkachen' ḻégake', na' ḻo bejwn' benle chi'i to benne' wnné': —Benne' ni nake' Ẕi'nkza'. Nži'ila'-ne', na' žaz ḻaža'a Ḻe'. Le wzé nag da' wchaḻje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kate' béngekle benne' wsedle ka' che Jesusen' chi'i na', belyechwe' ḻo yole, na' bžébegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Naž wbiga' Jesusen' gan nníta'gake', na' wdane' ḻégake', na' wnné': —Le chas. Bi žébele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kate' bchis ḻáwgake', na' bwíagake', nitože no benne' bḻé'egekle', san toze Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kate' ne žétjgake' ḻaw ya'a na', Jesusen' bchi'le' ḻégake', na' wnné': —Bi ye'le nitó benne' kan gok dan' bḻé'elele kate' yebanža' ḻo yeḻa' got neda', Benne' Golje' Benách. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Naž wnnábgekle benne' wsedle chie' ka' Ḻe', na' wnnágake': —¿Biẕ chen' ẕnnagak benne' yodo' wsedle ka' žon byene ḻa' ḻaw Lías zga'ale' kate' ḻa' ḻaw Benne' Criston'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bechebe Jesusen', na' gože' ḻégake': —Da' li ḻa' ḻaw zga'ale Líasen', na' wká'n chawe'e yógo'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na'a neda' žapa' ḻe'e: ba bḻa' ḻaw Líasen', san bi beyónbia'gake' ḻe', na' yógo'te da' ẕnnaze chégake' ḻe'e yiche la'y béngake' chie'. Ḻezka' góngake' chia' neda', Benne' Golje' Benách, dan' wsaka' zí'gake' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naž bejní'igekle benne' wsedle chie' ka', ẕcháḻjḻene' ḻégake' kan gok che Ẕwa, bennen' bezóe' benách ka' nis. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kate' bežíngake' gan zej nnita' benne' zan ka', wbiga' to benne' gan zoa Jesusen'. Bzoa ẕibe' x̱ni'e, ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na' gože' Ḻe': —X̱an, beyache' ḻaže'l x̱kwide' byo chia', dan' da'be' chon, na' ẕzáka'ḻe'ebe', na' zan chi'i ẕže'be' ḻo yi', na' ḻo nis. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bedjwá'a-be' gan nníta'gak benne' wsedle chio' ka', san bi gok yeyóngake'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bechebe Jesusen', na' wnné': —Ḻe'e, benne' ka' bi žejḻe'le che Dios, na' bi nakle ḻi ḻaže'. ¿Gáka'tega žaḻa' sóaḻena' ḻe'e nich chejḻe'le che Dios? ¿Gáka'tega žaḻa' gaka' ẕen ḻaže' chele ḻe'e? Le yedjwá'-be' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naž Jesusen' bdiḻe' be' x̱iwen' yo'obe', na' ḻa' bežojten ḻebe', na' ḻa' na'ze beyakte x̱kwide' byodon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Naž wbíga'gak benne' wsedle ka' che Jesusen' gan zoe' cheze. Wnnábgekle' Ḻe', na' wnnágake': —¿Biẕ chen' bi gok yebejto' neto' be' x̱iwen'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesusen' gože' ḻégake': —Bi gokle dan' bi žejḻe'le che Dios dot ḻáže'le. Da' li žapa' ḻe'e, ḻa'kze láte'ze nak kan žejḻe'le che Dios, cha' nakzen ka to bínnedo' mostasa, wak ye'le ya'ado' nga: “Bkwas nga, na' bejsóa na'le” na' ḻa' wkwasten. Bi be zoa da' bi gak gonle cha' chejḻe'le che Dios dot ḻáže'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Na'a, to be' x̱iwe' ki gak yebejlen toze cha' wcháḻjḻenle Dios, na' gonle wbás. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kate' ne ẕda Jesusen' gan nbab Galilea, gože' benne' wsedle chie' ka', na' wnné': —Zoa no benne' wdíe' neda', Benne' Golje' Benách, ḻo na'gak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Gótgake' neda', san kate' gak chonne ža Dios yesbane' neda'. Naž benne' wsedle chie' ka' gok nyache' ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kate' bžin Jesusen' ḻen benne' wsedle chie' ka' ḻo yež Kapernaum, benne' ka', benne' ẕchíẕjwgake' benách ka' lázgake' che yodo', bžíngake' gan zoa Bedw, na' wnnábgekle' ḻe', na' wnnágake': —¿Bi žiẕjw bennen' žsedle' ḻe'e laze' che yodo'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bechebe Bedon', na' wnné': —O', žiẕjwe'. Kate' beyó'o Bedon' ḻo yo'o, naž Jesusen' ḻa' bḻižtie' ḻe', na' wnné': —¿Biẕ ẕnno' le', Smon? Benne' ka' ẕnna biá'gake' yežlyó nga, ¿noẕ benne' ka' ẕchíẕjwgake' da' žíẕjwgak benách ka'? ¿Ẕchíẕjwgake' benne' wláž chégake' ka' o benne' zi'to' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bechebe Bedon', na' gože' Ḻe': —Benne' zi'to' ka ẕchíẕjwgake'. Naž Jesusen' gože' ḻe': —Che ḻen, bi žon byenen chiẕjwa' laza' che yodo' dan' naka' Ẕi'n Dios, kan bi be žíẕjwgak benne' ka' zej nake' benne' wláž che bennen' ẕchiẕjwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na'a, nich bi gonžo ga ža'a nitó benne', wyéj žoa'a nisdo', na' bejzale ḻo nisen' dan' ẕzenlo' bel ka', na' bel nežw da' seno', wẕí'-ban'. Kate' wsaljo' žoá'aba', žeḻ-lo' to mežw lasdo'. Wẕín', na' bdiẕjw laza', na' lazo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ḻa' ža na'ze benne' wsedle ka' che Jesusen' wbíga'gake' gan zoe'. Wnnábgekle' Ḻe', na' wnnágake': —¿Noẕ benne' ládjwto' gake' benne' blo gan ẕnna bia' Dios ya'abá chie'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naž bḻiž Jesusen' to x̱kwide' byodo', na' bzoe'-be' gachje ḻáwe'le gan nníta'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Naž gože' ḻégake': —Da' li žapa' ḻe'e, cha' bi yeyakle kan zej nak x̱kwide' ki, bi gak cho'ole gan ẕnna bia' Dios ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Che ḻen, no benne' gake' gax̱jw ḻaže', na' yeyake' kan nak x̱kwide' ni, bennen' gake' blo gan ẕnna bia' Dios ya'abá chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","No benne' gape' ba la'ne to x̱kwide' ki dan' nakbe' chia', gape' nedkza' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ḻezka' wnná Jesusen': —No benne' gone' ga gon to x̱kwide' ki doḻa', x̱kwiden' žejḻe'be' chia' neda', gakže chawe' che bennen' cha' wcheje' to yej wetw yene', na' chejžix̱je kwine' ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Da' nyáche'ḻe'e gaken chegak benne' ka' nníta'gake' yežlyó nga, benne' ka' žóngake' ga bága'gak ljéžgake' ka' doḻa'. Nníta'tezgak da' ka' žóngaken ga bága'gak benách ka' doḻa', san da' nyáche'ḻe'e gaken che bennen' žone' da' gonen ga no benne' bage'e doḻa'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Che ḻen, cha' no'o, o ni'o gonen ga bago'o doḻa', bchogen', na' wžo'nen'. Gakže chawe' chio' žino' gan so' nbano' ḻa'kze bi gak so'o, cha' nžog ni'a no'o, na' kege zoa chope no'o, na' chope ni'o, na' chejchó'o ḻo yi' gabíl da' batkle yoḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Cha' yej ḻawo' gonen ga bago'o doḻa', wlejen', na' wžo'nen'. Gakže chawe' chio' žino' gan so' nbano', ḻa'kze zoa toze yej ḻawo', na' kege zoa chope yej ḻawo', na' chejchó'o ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ḻezka' wnná Jesusen': —Le gape chi'i kwinle nich bi wzoale cheḻa'ale nitó x̱kwide' ki. Neda' žapa' ḻe'e, nníta'tezgak wbás che ya'abá ka' gan že' X̱a', Bennen' zoe' ya'abá chie', na' žape chí'igake' ḻégakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Neda', Benne' Golje' Benách, bḻa'a nga nich yeslá' no benne' nnitle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Biẕ ẕnnale ḻe'e? No benne', zej nnita' to gaywá' ẕila' chie' ka', na' cha' nitle toba', ¿bi wka'ne' tapḻalj to galjba' ka', na' cheje' gan nak ḻaw ya'a, chejdilje' ẕíla'don', bian' wnitlba'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cha' wežeḻ-le'-ba', da' li žapa' ḻe'e, yebéžele' che ẕíla'don' kan gone' chegak yetapḻalj to galjba' ka', bia ka' bi wnítgeklba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ḻezka' X̱ažo Dios, Bennen' zoe' ya'abá chie', bi žénele' nitle nitó x̱kwide' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ḻezka' wnná Jesusen': —Cha' lježo' gone' le' ẕia, beyéj, bejgá'nḻene' chawe' ḻa' ḻé'ezele. Cha' wzé nage' chio', ba beyono' bennen' lježo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cha' bi wzé nage' chio', bche' yetó benne', o yechope' nich yežój ḻi x̱tižo'o gan že'gak chope chonne benne', benne' ka' gak wzóa ḻígake' x̱tíža'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cha' bi wzé nage' chégake', gož benne' ka' ẕdóbgake' che Dios, na' cha' bi wzé nage' chegak benne' ka', naž gak bennen' ḻo' le' ka to benne' bi žejḻi'e che Dios, na' ka to benne' ẕchiẕjwe' ḻo wláz yež zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Da' li žapa' ḻe'e, yógo'te da' wží'ilele gan nak ḻo yežlyó nga, naken da' ba bchi'le Dios ya'abá chie', na' yógo'te da' gonnle latje ḻo yežlyó nga, naken da' ba benn Dios latje ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ḻezka' žapa' ḻe'e, cha' chópzele gonle toze x̱tíža'le ḻo yežlyó nga kan nak to da' nnáblele Dios, X̱akza' Dios, Bennen' zoe' ya'abá chie', gonen' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gan zej nnita' chope chonne benne', benne' ka' zej ndobe' chia' neda', zoakza' neda' gachje ḻáwe'le gan nníta'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Naž wbiga' Bedw gan zoa Jesusen'. Wnnable' Ḻe', na' wnné': —X̱an, ¿baḻ chi'i žaḻa' yenít ḻawa' che lježa', bennen' žone' chia' da' ẕia? ¿Gaže chi'i ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusen' gože' ḻe': —Neda' žapa' le', kege gážeze chi'i ka', san chonnḻalj chi kwe' da' zej naken gaže chi'i ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ḻezka' wnná Jesusen': —Ka gon Bennen' ẕnna bi'e ya'abá che Dios naken kan ben to benne' wnná bia', benne' gónele' wká'nḻene' chawe' benne' wen žin chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kate' wzó ḻawe' ẕká'nḻene' ḻégake' chawe', bžingak benne' wen žin chie' ka', na' bedjwá'gake' to benne' gan zoe', benne' nbage'e chie' da' zan gaywá' mežw ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dan' bi gok chiẕjwe', wnná x̱ane' to'e ḻe' ḻen no'le chie', na' x̱kwide' chie' ka', na' ḻezka' yógo'te da' nape', na' ki gaẕjw dan' nbage'e che x̱anen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Naž benne' wen žin na' bzoa ẕibe' x̱ni'a x̱ane', na' wnnáb nyache'e ḻe', na' wnné': “X̱an, ben ẕen ḻažo'o neda'. Chíẕjwkza' le' yógo'ten.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naž x̱anen' beyache' ḻáže'le' benne' wen žin chien', na' benít ḻawe' chie' dan' nbage'e chie', na' bsane' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kate' bežój benne' wen žin na' ga na', ḻa' bejchagtie' to benne' žónḻene' ḻe' tẕen žin, na' bennen' nbage'e chie' láte'ze mežw. Naž bex̱we' ḻe', na' wženje' yene', na' gože' ḻe': “Wdíẕjwte dan' ẕbago'o chia'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Naž bennen' bzoa ẕibe' x̱ni'a lježen', na' wnnáb nyache'e ḻe', na' wnné': “Ben ẕen ḻažo'o neda'. Chíẕjwkza' le' yógo'ten.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bi gónele benne' wen žin na', na' bsejwe' ḻe' liž ya na' zejte chiẕjwe' dan' ẕbage'e chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kate' yezika' benne' wen žin ka' béngekle' da' ni, gok nyache' ḻáže'gake' ni'a chie', na' bejzéngekle' x̱ángake' yógo'te dan' goken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naž x̱ángake' bḻiže' benne' wen žin na', na' gože' ḻe': “Le', wen žin bi nako' chawe'. Yógo'te mežwn' dan' wbago'o chia' benít ḻawa' chio'. Bsoḻa' dan' wbago'o chia' dan' wnnáb nyacho'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Bi žaḻa' yeyache' ḻáže'lo' lježo' kan bena' neda' chio', beyache' ḻáže'la' le'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naž x̱ane' bžá'aḻi'e, na' bdie' ḻe' ḻo na'gak benne' ka' wsaka' zí'gake' ḻe' kate' chíẕjwže' dot dan' ẕbage'e chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Naž wnná Jesusen': —Ḻezka' X̱a', Bennen' zoe' ya'abá chie', gone' chele ḻe'e cha' bi yenít ḻawle dot ḻáže'le da' žongak lježle ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kate' beyóž bchaḻj Jesusen' da' ni, bezé'e gan nbab Galilea, na' bžine' gan nbab Judea gan de yecheḻá'a yego Jordán zaka' gan ẕḻa' wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Benne' zan zjákḻene' Jesusen', na' beyone' ḻégake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Naž baḻe benne' yodo' fariseo ka' bḻá'gake' gan zoa Jesusen' nich si' biá'gake' Ḻe'. Wnnábgekle' Ḻe', na' wnnágake': —¿De latje to benne' byo nžag ne'e wsane' ẕo'le' ni'a che bíte'teze da' žaken? ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bechebe Jesusen', na' gože' ḻégake': —¿Bi beḻ-le da' nyejw ḻe'e yiche la'y kan ben Dios benách ka' katen' bene' yežlyó? Benne' byo, na' no'le bene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ki wnná Dios: “Che ḻen, benne' byon' žaḻa' kwásḻene' x̱a x̱ne'e, na' chejgá'nḻene' ẕo'le', na' žoptie' yeyákgake' ka toze benne'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ki naken, biž zej nake' chópgake' san toze benne' ba beyákgake'. Che ḻen, bi žaḻa' yeḻa'agak benách ka' ḻégake', benne' ka' Dios bene' ḻégake' toze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Naž benne' yodo' ka' wnnábgekle' Jesusen', na' wnnágake': —¿Biẕ chen' Moisés gože' ḻégake' da' žonnen to benne' byo latje wneẕjwe' ẕo'le' to yiche da' ẕnnan žeḻá'aḻene' ḻe', na' naž gak wsane' ẕo'len'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusen' gože' ḻégake': —Ki ben Moisés dan' nak zižje yichj ḻáẕdo'le, bi'e ḻe'e latje wsanle no'le chele ka', san kate' wzó ḻaw žata' yežlyó nga, bi goken ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neda' žapa' ḻe'e, cha' no benne' byo wsane' ẕo'le', na' bi wdáḻene' benne' byo yoble, na' cha' wchág ná'ḻene' no'le yoble, bage'e doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. Ḻezka', cha' no benne' byo yoble wchág ná'ḻene' no'len' bsan benne' byo chie' ḻe', bage'e doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naž benne' wsedle chie' ka' góžgake' Jesusen', na' wnnágake': —Cha' ki naken che no benne' byo, benne' nžag ná'ḻene' to no'le, gakže chawe' chie' chela' bi wchág ne'e, na' ga'ne' toze'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bechebe Jesusen', na' gože' ḻégake': —Bi gak si' ḻo na'gak yógo'te benách diža' ni, san toze no benne' byo Dios ẕzejni'ile' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Zej nnita' benne' byo ka' bi ẕchag ná'ḻengake' to no'le dan' bi zej nake' dot benne' byo, dan' ki góljgake', na' yebaḻe benne' byo ka' bi ẕchag ná'ḻengake' to no'le dan' bséjwgak benne' ka' x̱nézgake', na' yebaḻe benne' byo ka' bi ẕchag ná'ḻengake' to no'le nich gak góngake' x̱chin Dios, Bennen' ẕnna bi'e ya'abá chie'. No benne' gak si' ḻo ne'e diža' ni žaḻa' si' ḻo ne'en. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naž benne' ka' zej nake' x̱a x̱na'gak x̱kwide' ka', bedjwá'gake' ḻégakbe' gan zoa Jesusen' nich x̱oa ne'e ḻégakbe', na' nnable' Dios gon chawe'e ḻégakbe', san bséjwgak benne' wsedle chie' ka' x̱nézgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Naž Jesusen' gože' ḻégake', na' wnné': —Le we' x̱kwide' ki latje bíga'gakbe' gan zoa', na' bi wséjwle x̱nézgakbe', dan' benne' ka' zej nake' ka x̱kwide' ki nzí'gake' latje gan ẕnna bia' Dios ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naž Jesusen' bx̱oa ne'e ḻégakbe', na' bezé'e ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","To benne' byo, benne' zeje' babze yiz, bedjwíe' Jesusen', na' gože' Ḻe': —Benne' wsedle dot chawe'. ¿Biẕ da' naken chawe' žaḻa' gona' nich gata' yeḻa' nban da' zejlí kanne chia'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bechebe Jesusen', na' gože' ḻe': —¿Nnezlo' dan' ẕnno' chia' kate' ẕnno' naka' dot chawe'? Bi zoa no benne' nake' dot chawe'. Toze Dios nake' dot chawe'. Cha' žénelo' gata' yeḻa' nban da' zejlí kanne chio', ben kan wnnakze Dios gonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naž bennen' gože' Jesusen', na' wnné': —¿Biẕle da' ka' wnné'? Jesusen' gože' ḻe': —Da' wnnakze Moisés katen' wnné': Bi goto' benách ka'. Bi gono' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. Bi kwano'. Bi nnio' che lježo' da' wen ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wdape ba la'ne x̱a x̱no'o. Bži'il lježo' ka' kan nži'il kwino'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naž bennen' zeje' babze yiz gože' Jesusen', na' wnné': —Yógo'te da' ki žona' kate' wzó ḻaw naka' x̱kwide'. ¿Zoa yetó da' žaḻa' gona'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesusen' gože' ḻe': —Cha' žénelo' gako' chawe' ḻaw Dios, wyéj, yjete' da' napo', na' mežwn' da' si'o, bneẕjwn chegak benne' yache' ka'. Ki gata' yeḻa' wnni'a chio' ya'abá che Dios. Naž da, benḻen neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kate' bennen' zeje' babze yiz benle' da' ni, beyeje', na' žak nyache' ḻaže'e dan' nápḻi'e yeḻa' wnni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naž Jesusen' gože' benne' wsedle chie' ka', na' wnné': —Da' li žapa' ḻe'e, gak zede cho'o to benne' nape' yeḻa' wnni'a gan ẕnna bia' Dios ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yetó žapa' ḻe'e, nakže zede che bennen' nape' yeḻa' wnni'a choe'e gan ẕnna bia' Dios ka te to bia nwa'ba' ywa' ḻo nag yeche'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kate' béngekle benne' wsedle chie' ka' da' ni, bebángekle', na' wnnágake': —¿Noẕkze benne' gak yelé', cha'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bwia Jesusen' ḻégake', na' wnné': —Bi gak gongak benách ka' ki, san Dios gak gone' yógo'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Naž bechebe Bedw, na' gože' Jesusen': —Bwia nga, neto' ba bka'nto' yógo'te, na' zá'ḻento' Le'. ¿Biẕže gata' cheto'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusen' gože' ḻégake': —Da' li žapa' ḻe'e, ža na' katen' wkób yežlyó nga, na' kwi'a gan nna bi'a neda', Benne' Golje' Benách, gan gaka' Benne' Blo, ḻe'e na' žónḻenle neda' tẕen na'a, kwe'le chežinno latje ka' gan nna bia'le, na' wchi'a ḻáže'le chežinno kwe'te yež ka' chegak ẕa'só Israel. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No benne' ẕka'ne' liže', o biche'e ka', o zane' ka', o x̱e', o x̱ne'e, o ẕo'le', o ẕi'ne' ka', o yežlyó chie' ka', nich gone' x̱china', si' bennen' yetó gaywá'teže ka', na' ḻezka' gata' yeḻa' nban da' zejlí kanne chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Benne' zan, benne' zej nake' benne' blo na'a, gá'ngake' ka'ze, na' benne' ka' zej nga'ne' ka'ze na'a, gákgake' benne' blo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ḻezka' wnná Jesusen': —Kan gon Dios, Bennen' ẕnna bi'e ya'abá chie', naken ka ben to benne' x̱an yo'o. Bžoje' zildo', na' bejtilje' benne' wen žin ka' nich góngake' žin ḻo yežlyó chie' gan naze' lba uba ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kate' ba bgá'nḻene' benne' wen žin ka' chawe', chiẕjwe' ḻégake' to mežw da' naken laẕjw to benne' che to ža, bseḻe'e ḻégake' chjéngake' žin ḻo yežlyó chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kate' bežoje' x̱sile, bḻe'ele' yebaḻe benne' ka' nníta'gake' ka'ze ḻawe' ya'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gože' ḻégake': “Ḻezka' ḻe'e, le chej ḻo yežlyó chian', na' chiẕjwa' ḻe'e da' naken chawe'.” Ḻa' jaktie' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bežój benne' x̱an yo'on' da' yoble wawbíž, na' ḻezka' kate' žedá chonne, na' tḻebe ka bene', bseḻe'e benne' ka' ḻo yežlyó chien', benne' ka' bejx̱ake'e ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ḻezka' bežoje' katen' yelate' zoa wbíž, na' bejx̱ake'e yebaḻe benne' ka' nníta'gake' ka'ze ga na', na' gože' ḻégake': “¿Biẕ chen' zoale nga ka'ze dot ža, na' bi be žin žonle?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Benne' ka' góžgake' ḻe', na' wnnágake': “Nitó benne' bi benne' x̱chinto'.” Naž gože' ḻégake': “Ḻezka' ḻe'e, le chej ḻo yežlyó chian', na' chiẕjwa' ḻe'e da' naken chawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kate' za' žaḻe, benne' x̱an yo'on' gože' bennen' yo'ogak ḻo ne'e benne' wen žin ka', na' wnné': “Bḻiž benne' wen žin ka' nich wneẕjo' láẕjwgake', na' chiẕjo' zga'ale benne' ka' bžíngake' ze ḻawte. Te na' chiẕjo' benne' ka' bžíngake' zgá'alegake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Naž bžingak benne' ka' yjéngake' žin katen' yelate' zoa wbíž, na' wẕí'gake' to weje' to mežw da' naken laẕjw to benne' che to ža. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kate' bžingak benne' ka' yjéngake' žin zgá'alegake', gókgekle' sí'gake' da' ẕenže, san ḻezka' wẕí'gake' to weje' to mežw da' naken laẕjw to benne' che to ža. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kate' wẕí'gaken', wnnégake' che benne' x̱an yo'on', ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","na' wnnágake': “Benne' ka' bžíngake' kate' ze ḻawte, to chí'ido'ze béngake' žin, na' toze ka wdiẕjo' ḻégake' ka neto', na' neto' bento' žin dot ža, na' wyéyeḻe'eto' ḻo wbá.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bechebe x̱an yo'on', na' gože' toe': “Bicha'a, bi be žona' chio' da' bi naken chawe'. ¿Bi bga'n cháwe'žo si'o to mežw da' naken laẕjw to benne' che to ža? ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wẕí' laẕjo', na' beyéj ližo'. Neda' žénela' chiẕjwa' benne' ki, benne' yjéngake' žin kate' ze ḻawte toze kan žiẕjwa' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Bi nzi' ḻo na'a wconla' žin da' naken chia' ka žénela'? ¿Ẕge'elo' lježo' dan' žónnḻi'a chie'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ki naken, baḻe benne', benne' ka' ẕka'ngak benách ka' ḻégake' ka'ze, gákgake' blo, na' baḻe benne', benne' ka' zej nake' blo na'a, gá'ngake' ka'ze. Benne' zan žḻiža' san babze benne' ka' nbégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kate' Jesusen' ne yoe'e nez, zeje' ḻo yež Jerusalén, bchi'e cheze chežínnote benne' wsedle chie' ka', na' gože' ḻégake': ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Le wia nga, yo'ožo nez zejžo yež Jerusalén, gan soa to benne' wdíe' neda', Benne' Golje' Benách, ḻo na'gak bx̱oz wnná bia' ka', na' ḻo na'gak benne' yodo' wsedle ka', na' chóggake' chia' gata'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wdégake' neda' ḻo na'gak benne' zi'to' ka', benne' ka' gon dítjgekle' neda'. Chíngake' neda', na' wdá'gake' neda' ḻe'e yag kroze, san kate' gak chonne ža, Dios yesbane' neda' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naž x̱na'gak Jakob, na' Ẕwa, ẕi'n Sebedeo ka', bžínḻene' chope' ka' ḻaw Jesusen', na' bzoa ẕibe' x̱ni'e Ḻe', na' wnnable' Ḻe' to da' gonze' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesusen' wnnable' ḻe', na' wnné': —¿Biẕ žénelo'? Gože' Ḻe': —Wnná kwe' to ẕi'na' ni kwito' ḻi ža, na' yetobe' kwe'be' kwito' yegle gan nna bi'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bechebe Jesusen', na' gože' ḻégake': —Bi nnézlele da' ẕnnable. ¿Wak sóelele da' saka'a neda', na' yezoale nis kan yezóa' neda' nis ḻo yeḻa' got? Góžgake' Ḻe': —Gakto'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naž Jesusen' gože' ḻégake': —Da' li da' žaḻa' saka'a neda', ḻezka' gaken chele, na' da' žaḻa' yezóa' neda' nis, ḻezka' yezoale ḻe'e nis, san nich kwe'le kwita' ḻi ža, o kwita' yegle, bi nzi' ḻo na'a kwia' no benne' gonnan' chie', san gata' chegak benne' ka' X̱a' ba bkwezen' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kate' béngekle yechí benne' wsedle ka' che Jesusen' da' ni, bžá'agake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Naž Jesusen' bḻiže' ḻégake', na' wnné': —Nnézkzelele kan žongak benne' ka', benne' ẕnna biá'gake' benne' zi'to' ka', kan ẕdétleche ẕnna biá'gake' ḻégake', na' benne' ka' zej nakže' blo ẕkóngekle' ḻa' ljéžgakkze' ka' žin. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bi gaken ki chele. Nóte'tezle ḻe'e, benne' žénele' gake' ẕen gan zoale, žaḻa' gone' žin che yezíka'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ḻezka', nóte'tezle ḻe'e, benne' yénele' gake' blo, žaḻa' gake' ka to benne' ndo'w che yezíka'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ḻezka' neda', Benne' Golje' Benách, bḻa'a nga, kege nich gon no benne' x̱china', san nich gákḻena' benách ka', na' wdía' yeḻa' nban chia', da' chiẕjwa' ḻo wlazgak benne' zan nich yelágake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kate' ne zežójgake' ḻo yež Jerikó, benne' zan zjákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Zej nnita' chope benne' ḻo choḻe ga na', benne' ka' žé'gake' žoa'a nez. Kate' béngekle' ẕde Jesusen' ga na', wnnégake' zižje, na' wnnágake': —X̱an, ẕa'só Dabí, beyache' ḻaže'l neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Benne' zan ka' bchí'igekle' ḻégake' gá'ngake' žize, san wnnégake' zížježe, na' wnnágake': —X̱an, ẕa'só Dabí, beyache' ḻaže'l neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Naž wléz Jesusen', na' bḻiže' ḻégake'. Wnnable' ḻégake', na' wnné': —¿Biẕ žénelele gona' chele? ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Góžgake' Jesusen': —X̱an, žénelto' gono' ga yeyaljw yej ḻawto'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naž beyache' ḻaže'l Jesusen' ḻégake', na' wdane' yej ḻáwgake'. Ḻa' beyáljwtegak yej ḻáwgake', na' jákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kate' bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen gawze gan že' yež Jerusalén, na' nníta'gake' gan že' yež Betfagé ẕan Ya'a Yag Olibo, bseḻe'e Ḻe' chope benne' wsedle chie' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na' gože' ḻégake': —Le chej ḻo yeždon' da' žen' ḻawle ga zoažo ni, na' chejx̱áka'le to burro wná' da'ba' ga na', ḻen to burro byodo' cheba'. Le chejseže-ba', na' le yedjwá'-ba' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Cha' no benne' bi da' yi'e ḻe'e, le ye'e: “X̱anžon' žénele'-ba'.” Naž seḻe'e-ba' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ki goken, bžin da' bzoj bennen' bchaḻje' ḻo wláz Dios, katen' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Le ye' benne' ka' nníta'gake' yež Sión: “Le wia nga, Benne' nna bi'e ḻe'e ze'e chele. Ḻo yeḻa' gax̱jw ḻaže' chie' ži'e x̱kože' to burro. Ži'e x̱kože' to búrrodo' che to bia žwa'ba' ywa'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naž jak benne' wsedle chie' ka' ga na', na' béngake' kan gož Jesusen' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Beché'gake' burro wná' na' ḻen burro byodon', na' bx̱óagake' laže' yicha' chégake' ka' x̱kóže'ba', na' wžé' Jesusen' ḻaw laže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ḻezka' wnníta'gak benne' zan ga na', na' bchíljgake' laže' ka' žx̱oa yéngake' ḻo nez. Yebaḻe' bchíbgake' zin da' bx̱óagake' ḻo nez. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zižje wnnegak benne' ka' zjake' ḻawle, na' benne' ka' zjákḻene' Jesusen', na' wnnágake': —¡Ga'n ẕen Ḻe', ẕa'só Dabí! ¡Ba nez ẕen naken che benne' ni ze'e ni'a che La X̱anžo! ¡Ga'n ẕen Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kate' wyáz Jesusen' ḻo yež Jerusalén, yógo'te benne' che yežen' béngake' žo'osbé. Benne' zan góžgake' ljéžgake' ka', na' wnnágake': —¿Noẕ bennen'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yezika' benne' ka' wnnágake': —Benne' ni Jesús, bennen' ẕchaḻje' ḻo wláz Dios. Nak laže' Nasaret gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kate' wyáz Jesusen' ḻo ḻi'a yodo' che Dios, blage' na'le yógo'te benne' ka' žóte'gake' na' benne' ka' žá'wgake' ḻo ḻi'a yodon'. Ḻezka' bžix̱e' blag ka' chegak benne' ka' ẕchá'gake' mežw che yež zi'to' ka', na' da' ka' želbe'le benne' ka' žóte'gake' plomdo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naž gože' ḻégake': —Nyejw ḻe'e yiche la'y da' ẕnnan: “Liža' sin' yo'o gan wcháḻjḻengak benách ka' Dios” san ḻe'e ba benlen kan nak to yo'o chegak benne' wbán ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kate' ne zoa Jesusen' ḻo ẕchil yodo', baḻe benne' ḻo choḻe ka' ḻen benne' ka' bi žak sá'gake', wbíga'gake' gan zoe', na' Ḻe' beyone' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kate' bx̱oz wnná bia' ka' ḻen benne' yodo' wsedle ka', bḻé'egekle' yeḻa' wak ka' da' žon Jesusen', na' ḻezka' béngekle' ẕnnegak zižje x̱kwide' ka' ḻo ẕchil yodo', na' ẕnnágakbe': “¡Ga'n ẕen ẕa'só Dabí!” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","naž bžá'agake', na' góžgake' Jesusen': —¿Bi ženlo' da' želnná x̱kwide' ki? Bechebe Jesusen', na' wnné': —O', ženlan'. ¿Batkle beḻ-le da' nyejw ḻe'e yiche la'y da' ẕnnan kikze žaḻa' gaken? Ki ẕnnan: “Beno' Le' ga žoḻgak x̱kwide' ka', na' bi' že'n ka', bi' ka' ne žáẕe'gakbe', da' žoe ḻáwgakbe' neda' da' naken dot ḻi ḻaže'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naž Jesusen' bezé'e gan nníta'gake', na' bežoje' ḻo yež Jerusalén. Wyeje' ḻo yež Betania gan bga'ne' dot yele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kate' za' ža'ní', na' zeyéj Jesusen' ḻo yež Jerusalén, ẕdone'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bḻe'ele' to yag higo da' žen' kwit nez, na' wbige'e gan žen', san bi be bžeḻ-le' da' ẕbian. X̱láge'ze žian. Naž Jesusen' gožen': —Biž kwia da' ẕix̱ chio'. Naž ḻa' wbižte yag higon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kate' bḻé'egekle benne' wsedle chie' ka' da' ni, bebángekle'. Wnnábgekle' Jesusen', na' wnnágake': —¿Nakx̱ goken, ḻa' wbižte yagen'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bechebe Jesusen', na' gože' ḻégake': —Da' li žapa' ḻe'e, cha' chejḻe'le che Dios, na' bi gak chope ḻáže'le, kégeze wak gonle kan bena' che yagen', san cha' ye'le ya'a nga: “Bkwas na'le, na' bejsóa ḻo nisdo'” gaken kan nnale. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ḻezka', yógo'te da' nnable kate' wcháḻjḻenle Dios, cha' chejḻe'le che Dios gonen' chele, si'le dan' nnable. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wyáz Jesusen' ḻo ẕchil yodo', na' kate' ne žsedle' benách ka' nníta'gake' ga na', bx̱oz wnná bia' ka' ḻen benne' gole ka', wbíga'gake' gan zoe'. Wnnábgekle' Ḻe', na' wnnágake': —¿Biẕ yeḻa' wnná bia' nzi' ḻo no'o, žono' da' ki? ¿Noẕ benne' bdie' ḻo no'o yeḻa' wnná bian'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bechebe Jesusen', na' gože' ḻégake': —Ḻezka' neda' nnabla' ḻe'e to. Cha' ye'le neda' kan naken, neda' yapa' ḻe'e bi yeḻa' wnná bia' nzi' ḻo na'a žona' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Noẕ benne' bseḻe'e Ẕwan' nich bezóe' benách ka' nis? ¿Dios bseḻe'e ḻe', o bséḻa'gak benne' ka' ḻe'? Naž wzó ḻawgak benne' yodo' ka' ẕnnágake' ḻa' ḻégakze': —Cha' nnažo: Dios bseḻe'e ḻe', ḻa' ye'tie' žo'o: “¿Biẕ chen' bi bejḻe'le chie'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","San cha' nnažo: bséḻa'gak benne' ka' ḻe', žébežo da' gongak benne' wláž ka', dan' žejḻé'gake' yógo'tegake' bchaḻj Ẕwan' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Che ḻen beží'igake', na' góžgake' Jesusen': —Bi nnezlto'. Jesusen' gože' ḻégake': —Ḻezka' neda' bi yapa' ḻe'e bi yeḻa' wnná bia' nzi' ḻo na'a žona' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Naž Jesusen' gože' benne' yodo' ka': —¿Biẕ nnale ḻe'e? Wzóa to benne' wnníta'gak chope x̱kwide' byo chie'. Gože' to x̱kwide' chien', na' wnné': “Ẕi'na', wyéj na'a chjeno' žin ḻo yežlyó chia' gan naza' lba uba ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Beží'i x̱kwiden', na' gožbe'-ne': “Bi žénela' cha'a.” Wdé na' beyát ḻáže'be', na' yjenbe' žin na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Naž bennen' gože' yetó x̱kwide' chien', na' toze kan wnné'. Beží'i x̱kwiden', na' gožbe'-ne': “O', x̱e. Cha'a.” San bi wyéj x̱kwiden'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nole x̱kwide' chope ka' benbe' da' žaz ḻaže' x̱abe'? Beží'igake', na' góžgake' Jesusen': —Bi' nežw. Naž Jesusen' gože' ḻégake': —Da' li žapa' ḻe'e: benne' wechiẕjw ka', benne' žóngake' da' kegle, na' no'le ḻe'e ka', chjake' zgá'alegake' ka ḻe'e, na' chó'ogake' gan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ki gaken dan' Ẕwa, bennen' bezóe' benách ka' nis, bḻe'e gan zoale, na' bsedle' ḻe'e da' naken chawe' kan žaḻa' gonle, na' ḻe'e bi bejḻe'le chie', san benne' wechiẕjw ka' na' no'le ḻe'e ka', bejḻé'gake' chie'. Ḻa'kze bḻé'elele da' ni, bi beyát ḻáže'le nich chejḻe'le chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ḻezka' wnná Jesusen': —Le wzé nag yetó da' wsaka' ḻeba'. Wzóa to benne' x̱an yo'o, na' beyaze' lba uba ka' ḻo yežlyó chie'. Wbeke' to le'je chen, na' bche'ne' to bloj ḻo yej gan wsíe' x̱is uba ka'. Ḻezka' bene' to yo'o ža'le gan gak to benne' wie' dot yežlyó chien'. Naž bdie' yežlyón' ḻo na'gak benne' wen žin ka', nich sí'gake' late' weje, na' wyeje' to yež zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Kate' bžin ža wchíbgake' uba ka', x̱an yežlyón' bseḻe'e baḻe ni'a ne'e gan zej nnita' benne' wen žin ka' nich sí'gake' da' žeyaḻa' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Naž benne' wen žin ka' béx̱wgake' ni'a ne'e ka'. Béngake' toe' we', na' yetóe' bétgake' ḻe', na' yetóe' bžé'egake' ḻe' yej. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Da' yoble x̱an yežlyón' bseḻe'e yebaḻe ni'a ne'e ka', na' gókgake' benne' zanže ka benne' ka' bseḻe'e zga'ale, na' tḻebe bengak benne' wen žin ka' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Kate' ze ḻawte, bseḻe'e ẕi'ne' gan nníta'gake'. Wzá' ḻaže'e, na' wnné': “Gápegake' x̱kwide' chia' ba la'ne.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kate' benne' wen žin ka' bḻé'egekle' ẕi'ne' na', ḻa' wnnátegake' ḻa' ḻégakze': “X̱kwide' ni gak chebe' yežlyó nga. Le cho'o, gotžo-be', na' da' žaḻa' gak chebe' gaken chežo.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naž béx̱wgake'-be'. Bebéjgake'-be' na'le ḻo yežlyón' gan zej naz lba uba ka', na' bétgake'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naž Jesusen' wnnable' benne' yodo' ka', na' wnné': —Kate' yeḻá' benne' x̱an yežlyón', ¿nakx̱ gone' chegak benne' wen žin ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Beži'igak benne' yodo' ka', na' góžgake' Jesusen': —Wžía yi'e benne' wen da' ẕinnj ka', na' yežlyó chien' wdíe' ḻo na'gak yebaḻe benne' wen žin ka', benne' wnéẕjwgake' da' žeyaḻa' chie' kate' žin ža chíbgake' uba ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naž Jesusen' gože' ḻégake': —¿Batkle beḻ-le dan' nyejw ḻe'e yiche la'y kan nak da' ni? Ki ẕnnan: Yej na' da' bzoa cheḻa'ale benne' wen yo'o ka', na'a naken yej ḻen yo'o blo che ze'e. X̱anžo na'kze bene' ga naken ki, na' naken to da' žonen ga žebanlžo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Che ḻen žapa' ḻe'e, latje chele gan ẕnna bia' Dios yeké'n chele, na' gatan' chegak benne' ka' góngake' kan žaḻa' gon no benne' nzi'e latjen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","No benne' wtope' ḻo yej na', ḻa' kwinze' wžía yi'e, na' cha' yej na' chejbagan' no benne', wzoẕjen ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kate' bx̱oz wnná bia' ka' ḻen benne' yodo' fariseo ka' béngekle' dan' bsaka' ḻebe Jesusen', gókbe'egekle' bchaḻje' kan nak chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gónegekle' góx̱wgake' Ḻe', san bžébegake' benne' zan nníta'gake' ga na', dan' žejḻé'gake' nak Jesusen' to benne' ẕchaḻje' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Da' yoble Jesusen' bcháḻjḻene' benne' ka' žónḻengake' Ḻe' tẕen. Bsaka' ḻebe', na' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Kan gak chegak benne' ka', benne' chó'ogake' gan ẕnna bia' Dios ya'abá chie', naken kan gok chegak benne' ka', bḻiž to benne' wnná bia' ḻégake' kate' bene' lni che ža ẕchag na' x̱kwide' byo chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bseḻe'e ni'a ne'e ka' nich chejx̱í'gake' benne' ka' ba bḻiže' nich yídgake' lni chebe', san bi gónegekle' yídgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naž bseḻe'e yebaḻe ni'a ne'e ka', na' gože' ḻégake': “Le chejzenle benne' ka' ba bḻiža', na' ye'le ḻégake': Le wia nga, ba nzí'ni'a da' gawžo. Ba betto' x̱peža' ka', na' ḻezka' bia beže ženne' chia' ka'. Yógo'te ba wẕí'ni'a. Le da, soažo lni che x̱kwide' chia', bin' ẕchag na'be'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Benne' ka' bejḻížgake' bi wdápegake' ḻégake' ba la'ne, na' jake' che chégake'. Toe' yjene' žin, na' yetóe' wyeje' chje'w chjete'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yebaḻe' béx̱wgake' ni'a ne'e ka', na' ben zí'gake' ḻégake', na' bétgake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kate' benne' wnná bian' benle' da' ni, bže'e, na' bseḻe'e benne' chie' ka', benne' žjake' ḻo wdiḻe, na' bétgake' benne' wet benách ka', na' bzéygake' lážgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Naž benne' wnná bian' gože' ni'a ne'e ka', na' wnné': “Da' li ba wẕí'ni'a che lni na', san benne' ka' bḻiža' bi gókgake' zi yedjénḻengake' neda' tẕen lni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Le chej na'a gan nak ḻo nez ka', na' le wḻíž yógo'te benne' ka' chejx̱áka'le ga na' nich yídgake' lni che x̱kwide' chia', bin' ẕchag na'be'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naž bžojgak ni'a ne'e ka', na' jake' gan nak ḻo nez ka', na' btóbgake' yógo'te benne' ka' bejx̱áka'gake' ga na', benne' chawe' ka' na' benne' wen da' kegle ka', na' gan žak lni wža'ten benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Kate' wyó'o benne' wnná bian' ga na' nich wie' benne' ka' zej ndobe' ga na', bḻe'ele' to benne' bi nakwe' laže' zaka' dan' bneẕjwe' chegak benne' ka' nníta'gake' lni na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naž gože' bennen': “Bicha'a, ¿zo' nga, na' bi nako' laže' zaka' dan' bneẕjwa' chegak benne' ka' nníta'gake' lni?” Bennen' wzóa žize'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Naž benne' wnná bian' gože' ni'a ne'e ka', na' wnné': “Le wchéj ni'a na' bennen', na' le chejžó'n-ne' na'le gan že' choḻ, gan kweže', na' wx̱éj laye'e ḻo yeḻa' nyache' ḻaže' chie'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Naž Jesusen' gože' benne' yodo' ka': —Benne' zan bḻiža', san babze benne' ka' nbégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naž beza'gak benne' yodo' fariseo ka' ga na', na' béngake' x̱tíža'gake' nich góngake' ga nna Jesusen' to nich gak yesbága'gake' Ḻe' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nich góngake' ki bséḻa'gake' baḻe benne' ka' žónḻengake' ḻégake' tẕen gan zoa Jesusen', ḻen benne' ka' žónḻengake' Herodes tẕen. Benne' ka' góžgake' Jesusen': —Benne' wsedle, nnezlto' ẕchaḻjo' Le' káteze naken, na' nak dot da' li da' žsedlo' kan naken che Dios, na' bi ẕzi'o da' ẕnnázegak benách kan nak chio', dan' bi ẕchi'a ḻažo'o benách ka' kan nak da' želnnaze'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bzenle neto'. ¿Biẕ ẕnno' le'? ¿Žon byenen o bi žon byenen chíẕjwto' lazto' che benne' Sésar, bennen' yež zi'to', bennen' ẕnna bi'e žo'o? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Žákbe'ele Jesusen' žénegekle' kwéjgake' Ḻe' diža', nich gak yesbága'gake' Ḻe' ẕia, na' gože' ḻégake': —Ḻe'e, benne' ka' ẕḻoé'ezele chawe' kwinle, ¿biẕ chen' ẕnnale da' wzóan neda' žoa'a ya'a? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Le wḻoé'el neda' to mežw da' žíẕjwle lazle. Naž bḻoé'egekle' Ḻe' to mežw che yež Roma. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesusen' wnnable' ḻégake', na' wnné': —¿Noẕ benne' da' ni ḻawe', na' noẕ benne' nyejw le' ḻe'e mežw ni? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Góžgake' Ḻe': —Che benne' Sésar da' ka'. Naž Jesusen' gože' ḻégake': —Le chiẕjw benne' Sésar da' zej naken che benne' Sésar, na' Dios da' zej naken che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kate' béngekle' da' ni, bebángekle' kan nak diža' chawen' da' bchaḻj Jesusen'. Belka'ne' Ḻe', na' ḻa' bezá'tegake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ḻa' ža na'ze benne' yodo' saduseo ka', benne' ka' ẕnnágake' bi yebangak benne' gat ka', wbíga'gake' gan zoa Jesusen'. Wnnábgekle' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","na' wnnágake': —Benne' wsedle, Moisés wnné': “Cha' gat to benne' zoa ẕo'le, na' bi zoa no x̱kwide' chie', bi' biche' bennen' žaḻa' wchág ná'ḻenbe' ẕo'le', nich soa ẕa'só benne' bíche'ben', bennen' gote'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wnníta'gak gaže bi' byo ka' zej nak bíche'gakbe' gan zoato'. Bi' byo nežw bchag ná'ḻenbe' to no'le, na' gotbe'. Dan' bi wzóa no x̱kwide' chebe', x̱kwide' bežopen' bchag ná'ḻenbe' no'le wzeben' che bi' bíche'ben'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ḻezka' goken che x̱kwide' bežopen', na' ḻezka' che x̱kwide' beyonnen', na' toze kan goken chegak gážtebe', dan' gótgakbe' yógo'tebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kate' ze ḻawte ḻezka' got no'len'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na'a, kate' žin ža yebangak benne' gat ka', ¿nole bi' gaže ka' gak no'len' chebe', dan' yógo'tebe' bchag ná'ḻengakbe' no'len'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Naž bechebe Jesusen', na' gože' ḻégake': —Nchíx̱ele ḻe'e dan' bi žejní'ilele da' nyejw ḻe'e yiche la'y, na' dan' bi nónbia'le yeḻa' wak che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kate' žin ža yebangak benne' gat ka', biž gak yeḻa' ẕzoaḻen no'le, na' bi wchág ná'gake', san gákgake' kan zej nak wbás la'y ka' che Dios, wbás ka' nníta'gake' ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Cha' yebangak benne' gat ka', ¿bi na' goḻ-le dan' gožkze Dios ḻe'e? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ki wnné': “Neda' naka' Dios che Bran, na' Dios che Isaak, na' Dios che Jakob.” Dios bi nake' Dios chegak benne' gat ka', benne' nátgake' to chi'ize, san nake' Dios chegak benne' ban ka', benne' nníta'gake' nbángake' ḻa'kze gótgake' ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kate' béngekle benne' ka' nníta'gake' ga na' da' ni, bebángekle' ni'a che dan' žsedle Jesusen' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kate' gókbe'egekle benne' yodo' fariseo ka' da' ben Jesusen', kan bnnita' žie' benne' yodo' saduseo ka', naž bdóbgake' yógo'tegake' gan zoe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zoa to benne' ládjwgake' ga na', benne' nsedle' da' bsedle Moisés, na' gónele' si' bi'e Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Che ḻen wnnable' Jesusen', na' wnné': —Benne' wsedle, ¿biẕle dan' bchi'le Dios gonžo naken blo? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusen' gože' ḻe': —Bži'il X̱ano' Dios dot ḻažo'o, na' ḻo dot yichj ḻaẕdo'o, na' ḻo dot yeḻa' žejní'il chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Da' ni naken da' bchi'le Dios da' naken blo, na' nakžen ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Da' bchi'le Dios da' naken da' bežope, naken tḻebe, na' ki ẕnnan: “Bži'il lježo' kan nži'il kwino'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Da' chopen ki, da' ka' bchi'le Dios, zej naken gan zegak yógo'te da' bchi'le Dios, na' yógo'te da' bsédgekle benne' ka' bcháḻjgake' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Katen' zej nnita' tẕen benne' yodo' fariseo ka', Jesusen' wnnable' ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","na' wnné': —¿Biẕ ẕnnale ḻe'e che Benne' Criston'? ¿Noẕ benne' nak Benne' Criston' ẕi'ne'? Beží'igake', na' wnnágake': —Ẕa'só Dabí nake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Naž Jesusen' gože' ḻégake': —¿Biẕ chen' Dabí na'kze bchaḻje' kan nak chie', na' wnné': “X̱ana'?” Ki wnné' katen' bchaḻje' ḻo wláz Dios Be' La'y, na' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","X̱anžo Dios gože' X̱ana': “Wžé' kwita' ḻi ža, na zejte gona' ga wzóa ẕibgak benne' ka' x̱ni'o, benne' bi ẕḻé'egekle' Le' chawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Cha' Dabín' wnné' nake' X̱ane', ¿nakx̱kze naken, ẕnnale ḻe'e nake' ẕa'só Dabín'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bi gok no benne' yeži'e, na' kate' wzó ḻaw ža na', bi bežogle no benne' bi da' nnable' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Naž Jesusen' bcháḻjḻene' benne' wsedle chie' ka', ḻen benne' ka' nníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Na' gože' ḻégake': —Benne' yodo' fariseo ka' na' benne' yodo' wsedle ka' zej ži'e latje che Moisés, nich wsédgekle' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Che ḻen, le gon yógo'te da' yé'gake' ḻe'e, san bi gonle ḻe'e kan žóngake', dan' to da' ẕnnágake', na' yetó da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Da' ẕchí'igekle' benách ka' naken ka to ywa' zí'iḻe'e da' bi gak no benne' we'e, na' ẕgó'ogaken' ža' yengak benách ka', san ḻégake' bi žénegekle' wchá'gaken', kege ḻen toze x̱ben ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Žóngake' yógo'te da' žóngake' nich ḻé'egekle benách ka' ḻégake'. Žẕéngake' da' ẕchéjgake' yen ná'gake', na' žoa'a x̱gágake' gan nyejw to da' nyejwn ḻe'e yiche la'y, na' ẕtónngake' lože laže' da' zej nakwe', da' ẕḻoe'elen žápgake' Dios ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Žénegekle' kwé'gake' gan nak latje blo gan ẕdóbgake' žáwgake' tẕen, na' gan nak latje blo ḻo yo'o gan ẕdóbgake' nich yéngekle' x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ḻezka', žénegekle' gápegak benách ka' ḻégake' ba la'ne kate' žápegake' ḻégake' “Padiox̱” gan nníta'gak benách ka', na' žénegekle' ye'gak benách ka' ḻégake': “Padiox̱, benne' wsedle.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’San ḻe'e, bi žaḻa' gonle ga no benne' yi'e ḻe'e: “Benne' wsedle” dan' zoa toze Benne' nake' Benne' wsedle chele, neda', Benne' Cristo, na' yógo'tele nakle lježle tole yetole. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bi ye'le nitó benne' yežlyó nga, bi nnale: “X̱e” dan' zoa toze Benne' nake' X̱ale, Bennen' zoe' ya'abá chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bi gonle ga no benne' yi'e ḻe'e: “X̱an” dan' zoa toze Benne' nake' X̱anle, neda', Benne' Cristo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","No benne' zoe' ládjwle, benne' žone' x̱chinle yezíka'le, benne' ni gake' blo gan zoale. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cha' no benne' gon kwine' benne' blo, ka'ze ga'ne', san no benne' nake' gax̱jw ḻaže', gake' benne' blo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Žséjwle x̱nezgak benách ka' žénegekle' žíngake' gan ẕnna bia' Dios ya'abá chien'. Ḻe'ekzle bi žo'ole ga na', na' bi žonnle latje cho'ogak benne' ka' žénegekle' chó'ogake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Ẕka'le ližgak no'le wzebdo' ka', na' nich wḻoé'ezele chawe' kwinle, scha žḻižle Dios. Che ḻen, ẕenḻe'e gak da' choge' chele da' sáka'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' ḻezka' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Ẕdele dot ḻo nisdo', na' dot ḻo yežlyó nga nich gonle ga wká'n ẕen Dios to benne' ka žonle ḻe'e, na' katen' ba bžéḻ-lele-ne', žonle ga nbága'že' ẕia ka dan' nbága'le ḻe'e, dan' gonen ga chejchazle ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Da' nyáche'ḻe'e naken chele. Nakle ḻo choḻe, na' žénelele wḻoé'elele benách ka' nez. Ki naken chele dan' ẕnnale: “Kate' bi da' ẕchebe ḻaže' no benne', cha' gon choche' x̱tiže'e ni'a che yodo', bi žon byenen, san cha' gon choche' x̱tiže'e ni'a che ya oro da' žen' ḻo yodo', na' gon byenen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ḻe'e, benne' ḻo choḻe ka', na' bi žejní'ilele. ¿Biẕle nakže blo? ¿Oron' o yodon' da' žon la'yen oron'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ḻezka' ẕnnale: “Cha' no benne' gon choche' x̱tiže'e ni'a che bkog la'y, bi gon byenen, san cha' gon choche' x̱tiže'e ni'a che mežw da' ẕoan ḻawle bkogen', na' gon byenen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ḻe'e, benne' nzide yichj ḻáẕdo'le, na' nakle ḻo choḻe. ¿Biẕle nakžen blo? ¿Mežw da' ẕoan ḻawlen, o bkog ḻa'yen' da' žon la'yen mežwn'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Che ḻen, cha' no benne' gon choche' x̱tiže'e ni'a che bkog la'y, žonen' ni'a che bkog la'yen', na' ḻezka' ni'a che yógo'te da' žen' ḻawlen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ḻezka', cha' no benne' gon choche' x̱tiže'e ni'a che yodo', žonen' ni'a che yodon', na' ḻezka' ni'a che Dios, Bennen' žonkze' latje chie' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ḻezka', cha' no benne' gon choche' x̱tiže'e ni'a che ya'abá che Dios, žonen' ni'a che latje gan že' ẕnna bia' Dios, na' ḻezka' ni'a che Dios na'kze, Bennen' ži'e ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Ki naken chele dan' žíẕjwle che yodo' to kwe' che to chi kwe' da' ẕzi'le che yix̱e' weje, na' che yix̱e' anís, na' che komino yeḻa' waw, san ẕka'nle da' nakže blo da' bchi'le Dios, dan' bi žonle da' naken chawe', na' bi žeyache' ḻáže'lele lježle ka', na' bi žejḻe'le che Dios. Da' ki žon byenen gonle, na' ḻezka' bi žaḻa' wka'nle yezika' da' ka' žonle, da' ka' žíẕjwle che yodo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ḻe'e, benne' ḻo choḻe ka', na' žénelele wḻoé'elele benách ka' nez. Dan' žonle naken ka ẕdele da' že'jle to yeso' da' ẕde ya, nich kwejle bi'a lasdo' ka', san že'jle to bia ẕen dan' želbía benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Nakle ka to ẕíga'do' da' žé'jḻenle, na' ka to ye'n da' žáwḻenle. Žible da' sban da' nwa' kwitle, san yichj ḻáẕdo'le nžan' da' ẕbanle, na' da' kegle ka' da' žonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ḻe'e, benne' yodo' fariseo ka', benne' ḻo choḻe ka'. Zga'ale le gon chawe' da' yo'on yichj ḻáẕdo'le, na' ḻezka' gakle chawe' kwitle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Ki naken chele dan' nakle ka yežw ba ka' chegak benne' gat ka', da' ka' zej naken ẕíla'do'ze kwitle, na' da' li x̱tan ẕnná'gaken, san nžá'gaken žit chegak benne' gat ka', na' yógo'te da' zgot. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ḻezka' nakle ḻe'e. Da' li ḻáwzele ẕḻoe'el kwinle chawe' ḻawgak benách ka', san yichj ḻáẕdo'le nža'ten da' ẕḻoé'ezele chawe' kwinle, na' da' kegle ka' da' žonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' chele ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle. Ẕzoale yo'o x̱tando' ka' ḻo ba ka' gan zej ngache' benne' ka' bcháḻjgake' ḻo wláz Dios, na' ḻezka' žonle x̱tan gan zej ngache' benne' chawe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ḻezka' ẕnnale: “Chela' wzoato' ža ni'te katen' wnníta'gak x̱a x̱to'to' ka', bi gónḻento' ḻégake' tẕen katen' bétgake' benne' ka' bcháḻjgake' ḻo wláz Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dan' ẕnnale ki, ḻe'ekzle ẕzoa lile nakle ẕa'sógak benne' ka' bétgake' benne' ka' bcháḻjgake' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ki naken, žesbaga' kwinle ẕia dan' wbága'gak x̱a x̱to'le ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ḻe'e nakle ka bele snia ka', na' ḻezka' ka lježgak bele snia ka'. Da' likze bi yelale ḻo da' wsaka' zin' ḻe'e ḻo yi' gabíl. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Che ḻen, neda' seḻa'a chele benne' ka' wcháḻjgake' ḻo wláz Dios, na' benne' ka' žejní'igekle', na' benne' wsedle ka'. Benne' ki, gotle baḻe', na' wda'le yebaḻe' ḻe'egak yag kroze ka', na' chinle yebaḻe' gan nak ḻo yo'o gan ẕdoble nich yenle x̱tiža' Dios, na' wlagle ḻégake' to yetó yež. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ki gaken, bága'le ḻe'e ẕia che yógo'te žen chegak benne' chawe' ka', da' wḻaljen ḻo yo, kate' wzó ḻaw wzóa bennen' bete' Abel, ẕi'n Adán, benne' chawen', na' na' zejte bétgake' Secría, ẕi'n Berekías, bennen' bétgake' gachje ḻáwe'le gan že' yodo', na' gan že' bkog la'y, gan ẕzéygake' bia beždo' ka' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Da' li žapa' ḻe'e, yógo'te da' ki bága'gak benne' ki, benne' nníta'gake' ža ni zoažo na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ḻezka' wnná Jesusen': —Benne' Jerusalén ka', ḻe'e na' žotle benne' ka' ẕcháḻjgake' ḻo wláz Dios, na' ẕže'ele yej benne' ka' bseḻa' Dios gan zoale. Zan chi'i gónela' wtoba' ḻe'e chia', kan žon ẕkoko', bia ẕtobba' bríse'do' ka' ẕan x̱ilba', san bi gónelele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Le wia nga, ka'ze ga'n ližle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ki gaken, dan' žapa' ḻe'e, na'a so ḻaw biž ḻé'elele neda' kate' nnážele: “La'y nak Bennen' ze'e ḻo wláz X̱anžo Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bžoj Jesusen' ḻo ẕchil yodo', na' kate' ne ẕze'e ga na' wbíga'gak benne' wsedle chie' ka' gan zoe', na' bḻoé'egekle' Ḻe' kan nak ze'e na', da' nyechjen yodon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bechebe Jesusen', na' gože' ḻégake': —¿Ẕḻé'elele yógo'te da' ki? Da' li žapa' ḻe'e, bi ga'n to yej da' nbagan' lježen nga, dan' bix̱ doten. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kate' ne že' Jesusen' gan nak ḻaw Ya'a Yag Olibo, wbíga'gak benne' wsedle chie' ka' gan zoe' cheze', na' góžgake' Ḻe': —Bḻoe'el neto', ¿Batx̱ gakgak da' ki, na' biẕ gak bia' ža yeḻó'o, na' za' žin ža ze ḻawte ža ka' che yežlyó nga? ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Bechebe Jesusen', na' gože' ḻégake': —Le wia kwinle nich bi gon ḻáže'le no benne' ḻe'e, ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","dan' ḻa'gak benne' zan, benne' ka' si' lágake' kan lia' neda'. Nnágake' zej nake' Benne' Criston', na' gon ḻáže'gekle' benne' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yénlele žak wediḻe, na' da' ẕchaḻjgak benne' ka' che wediḻe, san bi kwe' zédlele, dan' žon byenen gakgak yógo'te da' ki zga'ale kate' žin ža ze ḻawte ža ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Benne' ka' nníta'gake' to yež tíḻ-ḻengake' benne' ka' nníta'gake' yetó yež, na' benne' ka' zoa to benne' ẕnna bi'e ḻégake' tíḻ-ḻengake' benne' ka' zoa yetó benne' ẕnna bi'e ḻégake'. Galj yižwé' ẕen ka', na' gak wbín, na' latje zan x̱o' yežlyó. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yógo'te da' ki zej naken da' so ḻáwgaken, da' ka' sáka'gak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Naž wdegak benách ka' ḻe'e ḻo na'gak benne' ka' wsaka' zí'gake' ḻe'e. Yógo'te benách ka' wzóagake' ḻe'e cheḻa'ale, dan' žónḻenle neda' tẕen, na' gótgake' báḻele ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kate' gak da' ki, benne' zan gak chope ḻáže'gake', na' yebéj yíchjgake' neda', na' toe' yetóe' wdíe' lježe', na' toe' yetóe' wzóe' lježe' cheḻa'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Naž ḻa' ḻawgak benne' zan, benne' gon ḻáže'gake', na' wḻoé'el kwíngake' ka benne' ka' ẕcháḻjgake' ḻo wláz Dios, na' gon ḻáže'gekle' benne' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gónḻe'egake' da' kegle, na' che ḻen biž ží'igekle' ljéžgake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","No benne' gake' Dios toze na' zejte ža ze ḻawte ža ka', yelá bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Se diža' chawen' kan ẕnna bia' Dios dot yežlyó nga nich yéngekle yógo'te benách zi'to' ka', na' naž žin ža ze ḻawte ža ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","’No benne' goḻe' da' ki žaḻa' wzejní'i ḻaže'e. Wnná Daniel, bennen' bchaḻje' ḻo wláz Dios ža ni'te, na' wnné': “Da' bi ẕḻe'el Dios chawe', dan' ẕchinnjen, cho'on latje la'y che Dios.” Kate' ḻé'elele gak da' ni, naž benne' ka' nníta'gake' gan nbab Judea žaḻa' wẕónnjgake' zaka' ḻaw ya'ado' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","No benne' žone' žin yíchjo'ole bi žaḻa' yetje' nich bi da' chejx̱i'e da' nape' ḻo yo'o, san žaḻa' wẕonnjtie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","No benne' zoe' žin yix̱e', bi žaḻa' yeyeje' liže' nich chejx̱i'e laže' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Da' nyáche'ḻe'e gaken chegak no'le ka', no'le zej noe'e bi'do' ka' chégake', na' ḻezka' no'le ka' ẕgáẕe'gake' bi' že'ndo' ka' chégake' kate' žin ža na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Le wchaḻjḻen Dios, na' le nnable' nich bi žin ža na' žaḻa' wẕonnjle kate' žak byo' zag o kate' nak ža la'y, ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","dan' sáka'žegak benne' ka' ža ka', ka wẕáka'gak benách ka' ža ni'te kate' za' gota' yežlyó nga, na' zejte na'a ža, na' kege ža zezá' bi sáka'gake' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kate' žin ža na', cha' Dios bi gone' babze ža ka', bi yelá nitó benne', san ni'a chegak benne' ka' wžekze' Ḻe' gone' babze ža ka', nich gákḻene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Che ḻen bi chejḻe'le cha' no benne' ḻe'e gan zoale, na' yi'e ḻe'e: “Le wia nga, zoa Benne' Criston' nga”, o nne': “Zoe' ga na'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ḻa' ḻawgak benne' zan, benne' wen ḻaže' ka', na' nnágake' zej nake' Benne' Criston', o nnágake' ẕcháḻjgake' ḻo wláz Dios. Góngake' da' ka' gak biá'gaken, na' da' ka' góngaken ga yebángekle benách ka', na' gon ḻáže'gekle' benne' ka' wžekze Dios cha' sáke'gekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Le wia nga, ba gožkza' ḻe'e yógo'te da' ki zga'ale kate' gákgaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Che ḻen, bi chejḻe'le cha' ḻa'gak benne' ka' gan zoale, benne' yé'gake' ḻe'e: “Le wia nga, zoa Benne' Criston' ḻo latje dach.” Ḻezka', bi chejḻe'le cha' nnágake': “Le wia nga, zoe' ḻo yo'o.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kan žak kate' žep yes gan ẕḻa' wbíž, na' ẕza'ní' gan ženen, ḻezka' gaken kate' yeḻá'a neda', Benne' Golje' Benách. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gakte ki, kan ẕnnagak benách ka': “Gáte'teze gan de to da' nat, dóbgakkze lab ka' ga na'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ḻezka' wnná Jesusen': —Kate' te ža na' katen' sáka'gak benách ka' ki, wchóḻ wbíž, na' byo' bi gonnen baní' chen. Yindjgak belj ka', na' ẕizgak da' ka' zej nḻa' ya'abá, da' ka' zej napen yeḻa' ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Naž ḻa' dan' gak bia' ya'abá yeḻá'a neda', Benne' Golje' Benách, na' kweže nyáche'gak yógo'te benách ka' nníta'gake' yežlyó nga, katen' ḻé'egekle' neda', Benne' Golje' Benách, zezá'a ḻo bejw ya'abá, na' nzi' ḻo na'a yeḻa' wnná bia' ẕen, na' yeḻa' baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naž seḻa'a wbás che ya'abá chia' ka'. Wkwéžegake' zižje lozgak bia ka', na' wtóbgake' benne' ka' ba wžekza' chia', benne' ka' nníta'gake' dap la'ate yežlyó nga, na' yógo'te latje ẕan ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Le chejní'il da' žsedle da' žak che yag higo. Katen' žeḻa'gak ni'a nen' že'ndo' ka', na' ba žebía x̱lagen že'n ka', nnézlele za' žin byo' wbá. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ḻezka', kate' ḻé'elele žakgak yógo'te da' ki, nnézlele za' žin ža ze ḻawte ža, na' ba ẕḻa' ḻawn. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Da' li žapa' ḻe'e, yógo'te da' ki gákgaken zga'ale kate' gatgak benách ka' nníta'gake' ža na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Te che ya'abá, na' che yežlyó nga, san x̱tiža'a ka' bi tégaken ka'ze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Kate' žin ža na' bi nnezle nitó benne'. Bi nnézgekle wbás che ya'abá ka' che Dios, na' bi nnezla' neda', Ẕi'n Dios, san toze X̱ažo Dios nnezlen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Kan gok ža na' katen' wzóa Noé, ḻezka' gaken kate' yeḻá'a neda', Benne' Golje' Benách. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kate' ža ka' zga'ale kate' bžin nis yejw da' bchinnjen yežlyó nga, we'j bdáwgake', na' bchag ná'gake', na' bdégake' ẕí'ngake' ka' ḻo yeḻa' ẕchag na' na' zejte ža wyó'o Noén' ḻe'e barkw ẕen na', dan' bene', ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","na' bi gókbe'egekle' kate' bžinte nis yejw dan' bchinnjen yežlyó nga, na' bžia yí'gake' yógo'tegake'. Ḻezka' gaken katen' yeḻá'a neda', Benne' Golje' Benách, dan' bi gákbe'le nitó benne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kate' ža na' kate' yeḻá'a, cha' žongak chope benne' ka' žin yix̱e', toe' yedjži'a-ne' chia', na' yetóen' wka'na'-ne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cha' chope no'le ka' nníta'gake' wetw, toe' yedjži'a-ne' chia', na' yetóen' wka'na'-ne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Le soa ban ḻaže' dan' bi nnézlele biẕ ža yeḻá'a neda', X̱anle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na'a, le chejní'il da' ni. Chela' nnezle x̱an yo'o bi ža yid benne' wbán, na' nná'zele' dot yele, na' bi we'e latje no benne' chidjwe' ze'e nich kwane' da' de liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Che ḻen, le soa ban ḻaže' ḻe'e, dan' yeḻá'a neda', Benne' Golje' Benách, to ža bi ẕbezle neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ḻezka' wnná Jesusen': —¿Noẕ benne' wen žin, benne' nake' chawe', na' žejni'ile', wdé x̱ane' ḻo ne'e benne' ka' nníta'gake' liže' nich wneẕjwe' da' gáwgake' kate' gale'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ba nez ẕen gaken che benne' wen žin na' nake' chawe', cha' kate' yeḻé'e x̱ane', yedjx̱ake'e ḻe' žone' dot da' bde x̱ane' ḻo ne'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da' li žapa' ḻe'e, yógo'te da' nap x̱ane', wdíe' ḻo na' benne' wen žin žone' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Cha' to benne' wen žin ki yeyake' benne' wen da' ẕinnj, na' sa' ḻaže'e, na' nne': “Wžél x̱ana', na' bi yeḻá' zie'”, ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na' cha' so ḻawe' wsaka' zi'e benne' ka' žónḻengake' ḻe' tẕen žin, na' so ḻawe' ye'j gáwḻene' benne' ka' želzožle', ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","naž yeḻá' x̱an benne' wen žin na' to ža kate' bi zoe' ẕbeze', o to yele žekle' bi ḻa'te x̱anen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naž x̱anen' wsaka' zi'e benne' wen žin na', na' gone' ga gak chie' kan žaḻa' gak chegak benne' ka' ẕḻoé'ezele chawe' kwíngake'. Naž kweže nyache'e, na' wx̱éj laye'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ḻezka' wnná Jesusen': —Kan gak chegak benne' ka' chó'ogake' gan ẕnna bia' Dios ya'abá, naken kan gok chegak chi x̱kwide' no'le ka'. Wẕí'gakbe' broke ka' chégakbe', na' bžójgakbe' nich chejchággakbe' benne' ẕchag ne'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gáyo'be' zej nakbe' ban ḻaže', san yegáyo'be' zej nakbe' nat ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","X̱kwide' no'le nat ḻaže' ka' wẕí'gakbe' broke chégakbe' ka', san bi biá'gakbe' yelate' set da' žeyen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","X̱kwide' no'le ban ḻaže' ka' biá'gakbe' set da' žeyen ḻo béga'do' chégakbe' ka' ḻen broke chégakbe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Dan' wžél benne' ẕchag ne'e, wdé yele ḻáwgakbe', na' wtásgakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kate' bžin gachje yele, benle chi'i to benne' wnníe' zižje, na' wnné': “Za' benne' ẕchag ne'e. Le žoj chejchagle-ne'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Naž wyasgak yógo'te x̱kwide' no'le ka', na' bkwézgakbe' broke chégakbe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","X̱kwide' no'le nat ḻaže' ka' góžgakbe' x̱kwide' no'le ban ḻaže' ka', na' wnnágakbe': “Le gonn láte'do' set cheto' che set da' žeyen chele, dan' ẕgoḻgak broke cheto' ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bechébegak x̱kwide' no'le ban ḻaže' ka', na' wnnágakbe': “Bi gaken dan' bi be ga'n cheto', na' chele. Le chej gan ẕdo'w set da' žeyen na' chjé'wle chele.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kate' ne zjakbe' zejx̱í'gakben', bžin benne' ẕchag ne'e. X̱kwide' no'le ban ḻaže' ka', x̱kwide' ka' želbezbe' ḻe', wyó'oḻengakbe' ḻe' tẕen gan žak lni che yeḻa' ẕchag na', na' ḻa' bséjwte yo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wdé na' bžingak yezika' x̱kwide' no'le ka' ga na'. Bḻížgakbe'-ne', na' wnnágakbe': “X̱an, X̱an, bsaljw cho'oto'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ḻe' beži'e, na' wnné': “Da' li žapa' ḻe'e, bi nónbi'a ḻe'e.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Naž Jesusen' gože' benne' ka': —Le gak ban ḻaže', dan' bi nnézlele bi ža, o bi yele yeḻá'a neda', Benne' Golje' Benách. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ḻezka' wnná Jesusen': —Kan gon Bennen' ẕnna bi'e ya'abá che Dios naken kan ben to benne' za' cheje' zi'to'. Bḻiže' benne' wen žin chie' ka', na' bdie' ḻo ná'gake' da' nape'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’To benne' wen žin na', bdie' gayo' kwe' mežw ẕen ka' ḻo ne'e, na' yetóen' bdie' chope kwe' mežw ẕen ka' ḻo ne'e. Yetóen' bdie' to kwe' mežw ẕen ḻo ne'e. To toen' bdie' ḻo ná'gake' ka da' žákgekle'. Naž ḻa' wzá'tie' gan nak zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wyéj benne' wen žin na', bennen' wẕi'e gayo' kwe' mežw ẕen ka', na' bejtíljḻene' da' ka' yegayo' kwe' mežw ẕen ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ḻezka', bennen' wẕi'e chope kwe' mežw ka', bejtíljḻenen' yechope ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bennen' wẕi'e to kwe' mežwn' wyeje', na' bejche'ne' ḻo yo, na' bkache'e mežwn' che x̱ane' ḻo yon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Kate' ba gok scha, x̱angak benne' wen žin ka' beḻé'e, na' bgá'nḻene' ḻégake' chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kate' wzó ḻaw bžinte bennen' wẕi'e gayo' kwe' mežw ẕen ka', noe'e yegayo' kwe' mežw ka', na' gože' x̱ane': “X̱an, gayo' kwe' mežw ka' bdio' ḻo na'a. Nga de yegayo' kwe' mežw ka' dan' bejtíljḻenan'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","X̱anen' gože' ḻe': “Nak chawe'. Nako' benne' wen žin dot ḻi ḻaže'. Cháwe'do' beno' katen' wyó'o láte'do'ze ḻo no'o. Na'a da' ẕénḻe'eže wdía' ḻo no'o. Wyó'o ga zoa' ni, na' yebéḻenlo' neda' tẕen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Wdé na' bžin benne' wen žin na', bennen' wẕi'e chope kwe' mežw ẕen ka', na' wnné': “X̱an, chope kwe' mežw bdio' ḻo na'a. Nga de yechóp kwe' mežw ka' da' bejtíljḻenan'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naž x̱anen' gože' ḻe': “Nak chawe'. Nako' benne' wen žin dot ḻi ḻaže'. Cháwe'do' beno' katen' wyó'o ḻo no'o láte'do'ze. Na'a, da' ẕenḻe'e wdía' ḻo no'o. Wyó'o ga zoa' ni, na' yebéḻenlo' neda' tẕen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Naž kate' bžin benne' wen žin na', bennen' wẕi'e to kwe' mežw ẕen na', wnné': “X̱an, nnezla' nako' benne' biẕjw, dan' ẕḻapo' gan bi gozo', na' ẕtobo' gan bi bchiljo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Che ḻen bžeba' le', na' wyá'a, na' bejkacha'a mežw chion' ḻo yo. Nga de dan' naken chio'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Naž beží'i x̱ane', na' gože' ḻe': “Nako' benne' wen žin bi nake' chawe', na' ẕa'wede. Nnézkzelo' ẕḻapa' gan bi goza', na' ẕtoba' gan bi bchilja'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Che ḻen, gakže chawe' ḻa' bneẕjo' mežw chian' ḻo na'gak benne' ka' wkóngeklen' žin, nich chíljḻengaken' yelate', nich kate' yeḻá'a neda', yezi'a dan' naken chia' ḻen yichjen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Naž x̱anen' gože' benne' ka' nníta'gake' ga na', na' wnné': “Le yeká'a mežwn' ḻo na' benne' ni, na' le wneẕjwn ḻo na' bennen' nape' chi kwe' mežw ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nóte'teze benne' ẕkonle' chawe' žin da' nzi' ḻo ne'e, wdégake' ḻo ne'e yelate', na' gata' da' ẕenže chie', san bennen' bi ẕkonle' chawe' žin da' nzi' ḻo ne'e, da' do'ze da' nape' yeké'n. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na'a, benne' wen žin ni, benne' bi nake' chawe', le chejžo'ne' na'le gan nak choḻ, gan kweže nyache'e, na' wx̱éj laye'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ḻezka' wnná Jesusen': —Katen' yeḻá'a neda', Benne' Golje' Benách, tẕen ḻen yógo'te wbás che ya'abá chia' ka', nich nna bi'a, kwi'a ḻo latje chawe' chia', gan wchi'a ḻaža'a benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yógo'te benne' ka' nníta'gake' yežlyó nga dóbgake' gan kwi'a neda', na' wnníta'gaka'-ne' cheḻá'a weje kan žon to benne' wape ẕila' ka', benne' ẕnnite'e cheḻá'a weje chibo ka', na' ẕila' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wnnite'e ẕila' ka' kwite' ḻi ža, na' wnnite'e chibo ka' kwite' yegle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Naž, neda', benne' wnná bian', yapa' benne' ka' nníta'gake' kwita' ḻi ža, na' nnia': “Le da ga zoa' ni, ḻe'e wléj X̱a' ḻe'e cheze'. Gata' latje chele gan ẕnna bi'e, dan' bkweze' chele ža ni'te katen' bdix̱jwe' yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ki žaken chele dan' wdona', na' bennle da' bdawa'. Wbiḻa', na' bennle da' we'ja'. Goka' ka to benne' ẕde' zi'to', na' wlo'le neda' ližle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Byažje da' gakwa', na' bwákwle neda' da' ka' žákwle. Bi wzóa' chawe', na' bedjwíale neda'. Byejwa' liž ya, na' bedjwíale neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Naž yechébegak benne' chawe' ka', na' yé'gake' neda': “X̱an, ¿batx̱ bḻe'elto' Le' wdono', na' bwawto' Le'? ¿Batx̱ wbiḻo', na' bennto' da' we'jo'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Batx̱ bḻe'elto' Le' bejdío' zi'to', na' wlo'to' Le' ližto'? ¿Batx̱ byažje laže' gako', na' bwákwto' Le' da' ka' žákwto'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Batx̱ bḻe'elto' Le' bi wzó' chawe', o wyejo' liž ya, na' bedjwíato' Le'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yecheba' neda', benne' wnná bian', na' yapa' ḻégake': “Da' li žapa' ḻe'e, dan' benle ki che to benne' ljéža'do' ki, ḻa'kze nake' benne' ka'ze, ḻezka' chia' nedkza' benlen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Naž yapa' benne' ka' nníta'gake' kwita' yegle, na' nnia': “Le kwas ga zoa' ni, ḻe'e na' nbága'le ẕia, na' chejchazle ḻo yi', da' bi yeyoḻen, dan' bkwez Dios che da' x̱iwe', na' chegak wbás ka' žónḻengaken ḻen tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ki gaken chele dan' wdona', na' bi bennle da' gawa'. Wbiḻa', na' bi bennle da' ye'ja'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Goka' ka benne' ẕde' zi'to', na' bi wlo'le neda' ližle. Byažje da' gakwa', na' bi bwákwle neda' da' ka' žákwle. Bi wzóa' chawe', na' ḻezka' byejwa' liž ya, na' bi bedjwíale neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Naž nnagak benne' ka', na' yé'gake' neda': “X̱an, ¿batx̱ bḻe'elto' Le' wdono', o wbiḻo', o goko' ka to benne' ẕde' zi'to', o byažje da' gako', o bi wzó' chawe', o wyejo' liž ya, na' bi gókḻento' Le'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naž yecheba' neda', benne' wnná bian', na' yapa' ḻégake': “Da' li žapa' ḻe'e, dan' bi be benle che to benne' zoe' ladjw benne' ka' nníta'gake' nga, ḻa'kze nake' benne' ka'ze, bi be benle chia' neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Naž benne' wen da' ẕinnj ka' ḻa' chejcháztegake' gan sáka'ḻe'egake', san benne' chawe' ka' gata' yeḻa' nban da' zejlí kanne chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kate' beyóž bchaḻj Jesusen' da' ni, gože' benne' wsedle chie' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","na' wnné': —Nnézkzelele žin Lni Pasko' yechóp ža ka', na' kate' ža na' wdégake' neda', Benne' Golje' Benách, ḻo na'gak benne' ka' wdá'gake' neda' ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ḻa' na'ze bx̱oz wnná bia' ka' na' benne' yodo' wsedle ka', na' benne' gole ka', bdóbgake' gan nak ḻi'a liž bx̱oz blo, bennen' lie' Kaifás. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Béngake' toze diža' séngake' Jesusen' ḻo yeḻa' wen ḻaže' chégake', nich gótgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wnnágake': —Bi gak gonžon ža lni, nich bi gongak benách ka' žo'osbé. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Katen' wzóa Jesusen' ḻo yež Betania ḻo liž Smon, bennen' wdé'e yižwé' leže, ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wbiga' to no'le x̱kóže'le Jesusen', noe'e to béga'do' da' naken yej zaka', na' nžan' to da' ẕḻa' ẕix̱ da' záka'ḻe'en. Wloé'en yichj Jesusen' kate' ne ži'e žawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kate' bḻé'egekle benne' wsedle ka' che Jesusen' da' ni, bžá'agake', na' wnnágake': —¿Biẕ chen' wnitle da' ni? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gok no benne' gote'en, na' si'e mežw zan nich gákḻenžo benne' yache' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kate' benle Jesusen' da' ni, gože' ḻégake': —¿Biẕ chen' ẕnnele che no'le ni? Nak chawe' da' bene' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Benne' yache' ka' nníta'ḻentezgake' ḻe'e, san neda' bi gá'nteza' gan zoale ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Da' ben no'le ni katen' wloé'e neda' da' ẕḻa' ẕix̱en', naken to da' ẕpa'an neda' che ža gacha'a ḻo yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Da' li žapa' ḻe'e, gáte'teze ḻo yežlyó nga gan wcháḻjgake' diža' chawe' ni, ḻezka' wzéngekle' benách ka' da' ben no'le ni chia' neda' nich chejsá' ḻáže'gake' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Naž Judas Iskariote, to benne' žónḻene' tẕen yechinéj benne' wbás ka' che Jesusen', wyeje' gan zej nnita' bx̱oz wnná bia' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na' gože' ḻégake': —¿Biẕ gonnle chia' neda' cha' wdía' Jesusen' ḻo na'le? Bgá'nḻene' ḻe' chawe' chíẕjwgake' ḻe' chi žoa mežw plat. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naž wzó ḻaw Judas na' žilj loj ḻaže'e wdíe' Jesusen' ḻo ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kate' nak ža ẕzo ḻaw lni chegak benne' judío ka' katen' žáwgake' yet x̱til da' bi nzi' kwa zichj, wbíga'gak benne' wsedle ka' che Jesusen' gan zoe', na' góžgake' Ḻe': —¿Gaẕ žénelo' chejsí'ni'ato' ẕíla'do' chežo, bian' gawžo že' Lni Pasko'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesusen' gože' ḻégake': —Le chej ḻo yežen' gan zoa to benne', bennen' nónbia'žo, na' le yi'e: “Benne' žsedle' neto' ẕnne': Za' žin ža chia' gata'. Ḻo ližo' gáwḻena' benne' wsedle chia' ka' tẕen ẕíla'do' že' Lni Pasko'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Naž bengak benne' wsedle chie' ka' kan gože' ḻégake', na' bsí'ni'gake' da' gáwgake' že' Lni Pasko'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kate' ba goḻe ža na', Jesusen' wžé'ḻene' chežínnote benne' wsedle chie' ka', na' wzó ḻáwgake' žáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kate' ne žáwgake', Jesusen' gože' ḻégake': —Da' li žapa' ḻe'e, to benne' ládjwle ḻe'e wdíe' neda' ḻo na'gak benne' yodo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Naž gok nyache' ḻáže'gake', na' wnnábgekle' Jesusen' to toze', na' wnnágake': —X̱an, ¿neda' gonan'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bechebe Jesusen', na' wnné': —Bennen' ẕžínḻene' neda' tẕen ḻo ye'n, bennen' wdíe' neda' ḻo na'gak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Da' li neda', Benne' Golje' Benách, cha'a gan gak kan nyejw ḻe'e yiche la'y kan žaḻa' gaken chia', san da' nyáche'ḻe'e gaken che bennen' wdíe' neda' nich gótgake' neda'. Gakže chawe' che bennen' chela' bi golje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Naž beží'i Judas, bennen' wdíe' Jesusen', na' wnné': —Benne' wsedle, ¿neda' gonan'? Jesusen' gože' ḻe': —O', le' na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kate' ne žáwgake', Jesusen' bex̱we' to yet x̱til, na' gože' Dios: “Žóx̱keno'.” Naž bzoẕjen', na' bneẕjwen' chegak benne' wsedle chie' ka', na' wnné': —Le sin', le gawn. Da' ni naken beḻa' žen chia'. Kan bena' che yet x̱til ni ẕḻoe'elen kan gak che beḻa' žen chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ḻezka' bex̱we' to ẕíga'do', na' gože' Dios: “Žóx̱keno'.” Naž bneẕjwen' chégake', na' wnné': —Le ye'jen yógo'tele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Da' ni naken x̱chena' da' žon chochen diža' kobe da' ẕka'n chawen'. X̱chenan' ḻaljen ni'a chegak benne' zan nich gak yenít ḻaw Dios doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ḻezka' žapa' ḻe'e, biž ye'ja' x̱is da' ẕbia lba uba ki kate' žinže ža na' yé'jḻena' ḻe'e to da' kobe gan ẕnna bia' X̱ažo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kate' beyóž béḻgake' da' ẕka'n ẕenen Dios, jake' zaka' Ya'a Yag Olibo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Naž Jesusen' gože' ḻégake': —Yógo'tele gak chope ḻáže'le, na' wka'nle neda' na'a že' ni, dan' nyejw ḻe'e yiche la'y kan gak chia', da' ẕnnan: “Gona' ga gat Benne' Wape Ẕila' Ka', na' gáslasgak ẕila' ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Katen' yebana' ḻo yeḻa' got, naž cha'a zga'ala' ka ḻe'e zaka' gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naž bechebe Bedw, na' gože' Jesusen': —Ḻa'kze yógo'tegake' gak chope ḻáže'gake', na' wká'ngake' Le', neda' bi gak chope ḻaža'a, bi wka'na' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesusen' gože' ḻe': —Da' li žapa' le', na'a že' ni, zga'ale kate' kweže leko', le' nnio' chonne chi'i bi nónbi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naž Bedon' gože' Jesusen': —Ḻa'kze gátḻena' Le' tẕen, bi nnia' bi nónbi'a Le'. Ḻezka' wnnagak yógo'te benne' wsedle chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Naž Jesusen' bžínḻene' benne' wsedle chie' ka' tẕen yežlyón' nzin' Jetsemaní. Gože' ḻégake', na' wnné': —Le kwe' nga kate' cha'a yelate' na'le, gan chejcháḻjḻena' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesusen' bchi'e Bedw ḻen chope ẕi'n Sebedeo, na' wzó ḻawe' žak nyache' ḻaže'e, na' žek ḻáẕda'we'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Naž Jesusen' gože' ḻégake': —Žak nyache' ḻaža'a, na' žatkza' ḻo yeḻa' žek ḻáẕda'wa'. Le ga'n nga, na' le nna'ze dot yele tẕen ḻen neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wdé Jesusen' yeláte'do' na'le, gan byechwe'. Bzechw ḻawe' ḻo yo, na' bcháḻjḻene' Dios, na' wnné': —X̱e, cha' wak, ben ga bi gon byenen saka'a ki, san kege kan žénela' neda', san kan žénelo' Le' gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kate' bežín Jesusen' gan zej nnita' benne' wsedle chie' ka', bejx̱ake'e ḻégake' ẕtásgake', na' gože' Bedon': —¿Bi gok nná'ḻeno' neda' tẕen yele to chí'ido'ze? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Le nna'ze dot yele, na' le wchaḻjḻen Dios, na' le nnable-ne' gákḻene' ḻe'e, nich bi gata' latje gon da' x̱iwe' ga gonle doḻa'. Zóateze be' nákkzele ban ḻaže', san ḻo beḻa' žen chele žedó ḻáže'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naž wyéj Jesusen' da' bežope chi'i, na' bcháḻjḻene' Dios. Wnné': —X̱e, cha' bi gak gono' ga bi saka'a da' ki, ben kan žak ḻažo'o Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kate' beyeje', da' yoble bedjx̱ake'e ḻégake' ẕtásgake' dan' ndeḻe'e yele yej ḻáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naž bekwás Jesusen' gan žé'gake'. Wyeje' da' yoble, na' bcháḻjḻene' Dios da' beyonne chi'i, na' tḻebe kan wnné' zga'ale wnné'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Da' yoble beyeje' gan zej nnita' benne' wsedle chie' ka', na' gože' ḻégake': —¿Ẕtasle na'a, na' žezí' ḻáže'le? Le wia nga, ba golen. Neda', Benne' Golje' Benách, ba ndia' ḻo na'gak benne' doḻa' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Le chas, le cho'o. Le wia nga, bennen' ẕdie' neda' ba ze'e nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kate' ne ẕchaḻj Jesusen' da' ni, Judas, bennen' nbábḻene' benne' chežinnoe' ka', ḻa' bžintie' ga na', na' žónḻengak benne' zan ḻe' tẕen, benne' ka' zej noe'e ya ntoche' ka', na' yag ka'. Bx̱oz wnná bia' ka' na' benne' gole ka', bséḻa'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas na', bennen' ẕdie' Jesusen', ba bḻoe'ele' ḻégake' to da' gone' da' gak bian' no benne' nake' Jesusen'. Wnné': —Bennen' wchág ḻawa'-ne', Ḻen' Jesusen'. Le sene'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Naž wbiga' Judas na' gan zoa Jesusen', na' wnné': —Padiox̱, Benne' Wsedle. Naž ḻa' bchag ḻawtie' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesusen' gože' ḻe': —Bicha'a, ¿biẕ žono' nga? Naž wbíga'gak benne' ka', na' béx̱wgake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","To benne' zóaḻene' Jesusen' wlechje' ya ntoche' chie', na' bene' we', bchoge' yid nag to benne' wen žin che bx̱oz blo. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesusen' gože' ḻe': —Begó'o ya ntoche' chion' ližen. Yógo'te benne' ka' ẕkóngekle' žin ya ntoche' nich gótgake' benách, ḻo ya ntoche' gátgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Bi nnezlo' gak nnabla' X̱a', na' Ḻe' ḻa' séḻa'tie' chia' da' zánḻe'eže ka chežinno kwe' wbás che ya'abá ka', da' zej naken da' zan gaywé'e to to kwen'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","San cha' gona' ki, ¿nakx̱ gak žin da' nyejw ḻe'e yiche la'y, da' ẕnnan žaḻa' gaken chia' ki? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naž Jesusen' gože' benne' ka': —Za'le nwa'le ya ntoche' ka', na' yag ka', nich senle neda' kan žonle katen' ẕzenle benne' wbán ka'. Yógo'te ža wži'a ḻawle gan nak ḻo ẕchil yodo', gan bsedla' benách ka', san bi wẕenle neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na'a žaken ki nich žin da' nyejw ḻe'e yiche la'y, dan' wnnagak benne' ka' bcháḻjgake' ḻo wláz Dios. Naž yógo'te benne' wsedle ka' che Jesusen' bsángake' Ḻe', na' beẕónnjgake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Naž benne' ka', benne' zej nzene' Jesusen', bché'gake' Ḻe', na' bejzégake' Ḻe' ḻaw Kaifás, bx̱oz blo, gan zej ndobe benne' yodo' wsedle ka' ḻen benne' gole ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bedw bejnawe' Jesusen' zi'to' zi'to', na' wyoé'e gan nak ḻi'a liž bx̱oz blon', nich ḻe'ele' nakx̱ gak che Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bx̱oz wnná bia' ka' ḻen benne' gole ka', na' benne' yodo' wchi'a ḻaže' ka', wdíljgake' no benne' yesbage'e Jesusen' ẕia ḻa'kze gon ḻaže'e, nich gak chóggake' chie' gate'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","No no bžéḻgekle' ḻa'kze bžingak benne' zan, benne' wnnégake' chie' da' wen ḻaže'. Kate' ze ḻawte bžingak chope benne', na' ḻo yeḻa' wen ḻaže' chégake' wnnégake' chie', ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na' wnnágake': —Benne' ni wnné': “Gak wchinnja' yodo' che Dios, na' yechonne žaze ka' yechisan'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Naž wzó ža' bx̱oz blon', na' gože' Jesusen': —¿Bi be žechebo'? ¿Biẕ da' ni da' ẕnnegak benne' ki chio' Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesusen' bi be wnné'. Naž bx̱oz blon' gože' Ḻe': —Ni'a che X̱anžo Dios ban ẕnnabla' Le' nnio' da' li. Bḻoe'el neto' cha' nako' Le' Benne' Criston', Ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusen' gože' ḻe': —Kan ẕnno' naka'. Da' li žapa' ḻe'e, ḻé'elele neda', Benne' Golje' Benách, ži'a kwit ḻi ža che Dios, gan nzi' ḻo na'a yeḻa' wnná bia'. Yida' ḻo bejw ya'abá, na' ḻa'a gan soale. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Naž bx̱oz blon', ḻo yeḻa' ẕža'a chie' wcheze' laže' da' nakwe', na' wnné': —Benne' ni ẕnnie' da' ẕka'n ka'ze Dios. ¿Noẕže benne' žiážjelžo nich nnie' che benne' ni? Ba bénkzelele kan wnníe' che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Biẕe ẕnnale ḻe'e? Beží'igake', na' wnnágake': —Nbage'e ẕia, na' žaḻa' gate'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naž bžé'egake' ẕene' ḻaw Jesusen', na' ben zí'gake' Ḻe'. Baḻe' wdápegake' x̱age'e, ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na' góžgake' Ḻe': —¿Nakkzo' Le' Benne' Criston'? Wnnéya'a na'a. ¿Noẕ bennen' wdape'e Le'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kate' ne žakgak da' ki, že' Bedw ḻa' ḻí'ale. Wbiga' to no'le wen žin gan zoe', na' wnnabe': —Ḻezka' le' wdáḻeno' Jesusen', benne' Galilean'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Beží'i Bedon' chebe' gan nníta'gak benne' ka', na' wnné': —Bi nnezla' no bennen' ẕchaḻjo' chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Katen' bžoj Bedon' gan žó'ogake' ḻi'a na', yetó no'le bḻe'ele' ḻe'. Gože' benne' ka' nníta'gake' ga na', na' wnné': —Ḻezka' benne' ni bénḻene' Jesusen', benne' Nasaret na' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Da' yoble beží'i Bedon' chen. Ben choche' x̱tiže'e ni'a che Dios, na' wnné': —Bi nónbi'a Bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yeláte'do'ze wžé, wbíga'gak benne' ka' nníta'gake' ga na' gan zoa Bedon', na' góžgake' ḻe': —Da' li le' žónḻeno' ḻégake' tẕen dan' yeḻa' ẕnneze chio' nak bian' ga benne' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Naž wzó ḻaw Bedon' žesbaga' kwine' ẕia. Ben choche' x̱tiže'e ni'a che Dios, na' wnné': —Bi nónbi'a Bennen'. Ḻa' na'ze wžéžete leko'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Naž bejsá' ḻaže' Bedon' dan' gož Jesusen' ḻe', katen' wnné': “Zga'ale kate' kweže leko', chonne chi'i nnio' bi nónbi'o neda'.” Bžoj Bedon' ga na', na' wžeže nyache'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kate' za' ža'ní' ža na', yógo'te bx̱oz wnná bia' ka' ḻen benne' gole ka', béngake' toze diža' nich gótgake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bché'gake' Jesusen' nžeje', na' bdégake' Ḻe' ḻo na' Ponsio Pilato, bennen' ẕnna bi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kate' wnnezle Judas, bennen' bdie' Jesusen' ḻo na'gak benne' yodo' ka', ba nžog che Jesusen' gate', gok nyache' ḻaže'e, na' bejwé'e chi žoa mežw plat ka' ḻo na'gak bx̱oz wnná bia' ka', na' benne' gole ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas na' gože' ḻégake': —Nbaga'a doḻa' dan' bdia' to benne' chawe' nich gate'. Naž góžgake' Ḻe': —Bi žonen ga gek zédleto' neto'. Da' benkzo' le' naken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naž wžó'n Judas na' mežw plat ka' gan nak ḻo ẕchil yodo'. Bezé'e ga na', na' bejsí yene' ḻo yag. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bezi'gak bx̱oz wnná bia' ka' mežw plat ka', na' wnnágake': —Bi gonn ko'žo mežw ki gan ẕko'žo mežw che yodo', dan' naken laẕjw to benne' wet benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Naž béngake' toze diža', na' ḻen mežwn' gó'wgake' to yežlyó che to benne' wen ye'n nich gaken gan gáche'gak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Che ḻen, ḻo ža na' belzóe' la latjen', Yo Žen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ki goken, bžin dan' wnná Jeremías, bennen' bchaḻje' ḻo wláz Dios, katen' wnné': “Beká'agake' chi žoa mežw plat ka', kan nak dan' bzoagak benne' Israel ka' da' zaka' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na' ḻen mežw ka' gó'wgake' to yežlyó che to benne' wen ye'n. Da' ni bḻoe'el X̱ana' Dios neda'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kate' bejzégake' Jesusen' gan že' Pilato, bennen' ẕnna bi'e, ḻe' wnnable' Jesusen', na' gože' Ḻe': —¿Nako' Le' Benne' Nna Bi'e Benne' Judío Ka'? Jesusen' gože' ḻe': —Da' li ẕnno'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kate' bx̱oz wnná bia' ka', na' benne' gole ka' besbága'gake' Jesusen' ẕia, Ḻe' bi be beži'e chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Naž Pilaton' gože' Jesusen': —¿Bi ženlo' da' zan ka' da' ẕnnégake' chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesusen' bi be bechebe'. Ka' goken, bebanle benne' wnná bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kate' žak Lni Paskon', de to da' žónteze žon Pilato, benne' wnná bian', žsane' no benne' želnnáb benne' ka', to benne' nyejwe' liž ya, nóte'teze benne' žénegekle' wsane' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kate' ža ka' nyejw to benne' liž yan', benne' wen da' ẕinnj, bennen' lie' Barrabás. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kate' bdobgak benne' zan ga na', Pilaton' wnnable' ḻégake', na' wnné': —¿Nole' žénelele wsana' chele? ¿Barrabás o Jesús, Benne' Criston'? ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ki wnná Pilaton' dan' žákbe'le' bdegak benne' yodo' ka' Jesusen' ḻo ne'e dan' ẕgé'egekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kate' ne že' Pilaton' gan ẕchi'a ḻaže'e, ẕo'le' bseḻe'e to benne' chjape' ḻe', na' wnné': —Bi be gono' che benne' chawen', dan' bžébeḻi'a wdé yele to ḻo bichgale ni'a chie' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","San bx̱oz wnná bia' ka' ḻen benne' gole ka', belsedle' benne' zan ka' nich nnábgekle' Pilaton' wsane' Barrabasen', na' gote' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Da' yoble bchaḻj benne' wnná bian', na' gože' ḻégake': —¿Nole' benne' chope ki žénelele wsana'-ne' chele? Wnnágake': —Barrabasen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Naž Pilaton' wnnable' ḻégake', na' wnné': —¿Biẕ gona' che Jesusen', Benne' Criston'? Yógo'tegake' wnnágake': —Bde'e ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naž benne' wnná bian' gože' ḻégake': —¿Biẕ da' ẕia nbage'e? Zížježe belbéžyi'e, na' wnnágake': —Bde'e ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kate' žákbe'ele Pilaton' bi ẕzoele x̱tiže'e, san béngakže benách ka' žo'osbé, naž wẕi'e nis, na' wdíb ne'e ḻáwgake', na' wnné': —Bi be ẕia nbaga'a neda' ni'a che yeḻa' got che benne' chawe' ni. Da' žónkzele ḻe'e da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Beži'igak yógo'te benne' ka', na' wnnágake': —Yeḻa' got che bennen' bága'to' neto' na' bága'gak ẕi'nto' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ka' goken, Pilaton' bsane' Barrabasen' ḻo ná'gake'. Naž gože' benne' ka', benne' žjake' ḻo wdiḻe, chíngake' Jesusen', na' wdé na' bdie' Ḻe' ḻo ná'gake' nich wdá'gake' Ḻe' ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naž benne' ka' žjake' ḻo wdiḻe, benne' ka' nníta'gake' ḻo na' benne' wnná bian', bché'gake' Jesusen' ḻo yolawen' nzin' pretorio, gan btóbgake' yógo'te ljéžgake' ka' gan zoa Jesusen', na' nníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naž bká'agake' laže' da' nakw Jesusen', na' bwákwgake' Ḻe' to laže' x̱na, kan žákwgak benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Béngake' to da' naken ni'a na' yag yeche' dan' bx̱óagake' yichj Jesusen', na' bzóagake' to ya x̱tildo' ḻo ne'e ḻi ža dan' ẕḻoe'elen kan nak to bar che benne' yolawe'. Naž bzoa ẕíbgake' x̱ni'e, na' ben dítjgekle' Ḻe', na' wnnágake': —¡Ga'n ẕen Le', benne' ẕnna bi'o benne' judío ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Naž belžé'e Ḻe' ẕene', na' beká'agake' ya x̱tilen', na' bdíngaken' yichje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wdé ben dítjgekle' Jesusen', beká'agake' laže' x̱na dan' nakwe', na' begákwgake' Ḻe' laže' chekze'. Naž bché'gake' Ḻe' nich chejdá'gake' Ḻe' ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Katen' bžojgak benne' ka' žjake' ḻo wdiḻe, na' bejx̱áka'gake' Smon, to benne' yež Sirene, na' béngake' ga bi'e yag kroze che Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kate' bžíngake' latjen' nzin' Gólgota, da' ẕnnan ḻen diža' x̱iža', Ya'a Žit Yichjžo, ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","byé'jgake' Jesusen' nop zichj da' nchix̱en da' sḻa' che bia yix̱e'. Kate' Jesusen' bnix̱en', bi gónele' ye'jen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kate' ba bdá'gake' Ḻe' ḻe'e yag kroze, wdísgake' laže' da' gokwe', na' btítjgake' ḻawlen nich gak bia' nole' gaken chie'. Ki goken, bžin dan' wnná benne' bchaḻje' ḻo wláz Dios ža ni'te, katen' wnné': “Wdísgake' laže' da' gokwe', na' btítjgake' ḻawlen da' gak bian'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Naž wžé'gake' ga na', na' bwíagake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ḻezka' bdá'gake' ḻe'e yag krozen' gan nak yichjle Jesusen' to diža' da' ẕḻoe'elen ẕia da' nbage'e, da' ẕnnan ki: “Jesús, Bennen' Ẕnna Bi'e Benne' Judío Ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Gan da' Jesusen', ḻezka' bdá'gake' chope benne' wbán ka' ḻe'egak yag kroze ka'. Toe' bdá'gake' kwite' ḻi ža, na' yetóen' kwite' yegle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wdegak benne' ka' ga na', na' bḻiž zí'gake' Jesusen'. Bta yíchjgake', na' ben dítjgekle' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na' wnnágake': —O', Le' wchinnjo' yodon', na' chonne žaze ka' yechison'. Beslá kwino' na'a cha' nako' Le' Ẕi'n Dios. Betj na'a ḻe'e yag krozen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ḻezka' bx̱oz wnná bia' ka' ḻen benne' yodo' fariseo ka', na' benne' gole ka', ben dítjgekle' Ḻe', na' wnnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Bennen' beslé' benne' yoble ka', san bi gak yeslá kwine'. Cha' nake' Benne' Nna Bi'e Benne' Israel Ka', žaḻa' yetje' na'a ḻe'e yag krozen', na' chejḻe'to' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ḻe' bx̱en ḻaže'e Dios. Na'a Dios yeslakze' Ḻe' cha' nak da' žaz ḻaže'e, dan' wnné': “Ẕi'n Dios naka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ḻezka' benne' wbán ka', benne' ka' dá'gake' ḻe'egak yag kroze ka' gan da' Jesusen', bḻiž x̱íwe'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kate' bžin wawbíž, bechóḻ dot yežlyó, na' zejte žedá chonne. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Žedá chonnen', wnné zižje Jesusen', na' wnné': —Elí, Elí, ¿lama sabaktani? Da' ni ẕnnan ḻen diža' x̱iža': “Dios chia', Dios chia', ¿biẕ chen' bebéj yichjo' neda'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kate' béngekle benne' ka' nníta'gake' ga na' da' ni, wnnágake': —Bennen' žḻiže' Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Naž ḻa' wx̱íte'te to benne' zoe' ládjwgake', na' bex̱we' to da' naken bḻol da' žẕopen nis. Bx̱open' nop zichj, na' bzoen' to ḻawle ya x̱til, na' bchagen' žoa'a Jesusen' nich x̱open'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Naž yebaḻe benne' ka' wnnágake': —Wléz na'a. Wíažo cha' yid Líasen' nich wzetje' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Da' yoble wžéžeya'a zižje Jesusen'. Bžojte be' nakkze', na' ḻa' gottie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ḻa' na'ze bžéza'te laže' da' naḻan' ḻo yodo'. Bžojen chople, da' wzó ḻawn yichjlen, na' bžinten x̱ní'alen. Naž wẕó' yežlyó, na' wḻa'gak yej ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wyáljwgak yežw ba ka' chegak benne' gat ka', benne' ka' bejḻé'gake' che Dios, na' bebángake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wdé bebán Jesusen', naž benne' ka', benne' bežójgake' ḻo yežw ba ka' chégake', wyázgake' ḻo yež la'y, yež Jerusalén, gan bḻé'egekle benne' zan ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Naž bennen' ẕchi'e benne' ka' žjake' ḻo wdiḻe, benne' ka' ẕwíagake' Jesusen', kate' bḻe'ele' wẕó' yežlyó, na' da' ka' gókgaken, bžebe', na' wnné': —Da' li benne' ni goke' Ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wnníta'gak no'le zan zí'to'ze ga na', no'le ka' wdáḻengake' Jesusen' katen' bezé'e gan nbab Galilea, na' béngake' x̱chine', na' bnéẕjwgake' da' bdawgak Jesusen' na' benne' ka' žónḻengake' Ḻe' tẕen. Wnníta'gake' ga na', ẕwíagake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lia Madlen na' Lia, x̱na'gak Jakob na' Jwsé, wnníta'gake' ládjwgake'. Ḻezka' wzóa x̱na'gak ẕi'n Sebedeo ka' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kate' za' žaḻe ža na', bḻa' Jwsé ga na'. Nake' benne' yež Arimatea, benne' wnni'a, na' ḻezka' bénḻene' Jesusen' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Benne' ni bejwíe' Pilato, na' wnnabe' latje we'e Jesusen'. Pilaton' wnné' wdégake' Jesusen' ḻo na' Jwsén'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Bzetj Jwsén' Ḻe', na' bcheḻe' Ḻe' laže' da' zaka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Naž bkáche'gake' Ḻe' to ḻo yežw ba kobe da' bchach Jwsén' ḻe'e ya'a yej. Bde'e to yej blag ẕen da' wbagan' gan žó'ogake' ḻo yežw ba na', na' beyeje' liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wzóa Lia Madlen ḻen yetó Lia ga na', na' wžé'gake' žoa'a yežw ban'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kate' za' ža'ní' yetó ža, wdé bpá'gake' che ža la'y chegak benne' judío ka', bx̱oz wnná bia' ka' ḻen benne' yodo' fariseo ka' bḻá'gake' gan že' Pilato. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Naž góžgake' Pilaton': —Benne', žejsá' ḻáže'to' dan' wnná benne' wen ḻažen', dan' wnné' katen' wzóe' nbane'. Wnné': “Kate' gak chonne ža, yebana' ḻo yeḻa' got.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Che ḻen bseḻa' benne' ka' gape chí'igake' yežw ban', na' zejte ža chonne ža, nich bi yidgak benne' ka' žele, benne' ka' bénḻengake' Ḻe' tẕen, na' bi yebéjgake' Ḻe'. Naž bi gak yé'gake' benách ka': “Bebán Jesusen' ḻo yeḻa' got.” Cha' ki gaken, diža' wen ḻaze' ni gonžen da' ẕinnj ka ben diža' wen ḻažen' dan' bcháḻjgake' zga'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naž Pilaton' gože' ḻégake': —Zej nnita' benne' ka' žjake' ḻo wdiḻe nga. Le ché'-gake' ḻen ḻe'e. Le chej, na' le gape chi'i yežw ban' kan sáke'le gonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naž jake' ga na', na' bséjwgake' binlo yežw ban', na' bzóagake' to yej da' ẕbagan' gan žó'ogake' lo yežo ban'. Bdá'gake' ḻe'e yej na' to da' gak bian' cha' saljwn, na' bnníta'gake' benne' ka' žjake' ḻo wdiḻe ga na' nich gape chí'igaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kate' ba wdé ža la'y na' chegak benne' judío ka', na' za' ža'ní' ža nežw, Lia Madlen na' yetó Lia bejwíagake' yežw ba che Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ḻa' na'ze wẕó' yežlyó. Ki goken dan' betj to wbás che ya'abá ga na'. Bḻe'e žoa'a yežw ban', na' bkwase' yej blag ẕen na', na' wži'e ḻo yej na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ẕnna' ḻaw wbás che ya'abán' ka yes baní', na' ẕíla'do'ze nak laže' da' nakwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kate' benne' ka' žjake' ḻo wdiḻe, benne' ka' žape chí'igake' yežw ban', bḻé'egekle' ḻe', bžébegake', na' wẕízgake'. Belbíx̱jgake' ḻo yo, na' gókgake' ka benne' gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naž wbás che ya'abán' gože' no'le ka', na' wnné': —Bi žébele. Nnezla' žeyiljle Jesús, bennen' bdá'gake' ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bi zoe' nga dan' ba bebane' kan ba wnnakze' Ḻe'. Le da, wíale gan gota' X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Le chej na'a, na' le chjap benne' wsedle chie' ka' ba bebán Jesusen' ḻo yeḻa' got, na' Ḻekze' cheje' zga'ale' ka ḻe'e zaka' gan nbab Galilea. Yeḻé'elele-ne' ga na'. Ba goža' ḻe'e dan' bde Dios ḻo na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naž ḻa' bezá'tegake' žoa'a yežw ban'. Ẕžébegake', na' žebégekle', na' taría taríagake' zjake' nich chejzéngekle' benne' wsedle chie' ka' da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kate' ne zjake', bejx̱aka' Jesusen' ḻégake', na' gože' ḻégake': —Padiox̱. Naž wbíga'gake' gan zoa Jesusen'. Byéḻa'gake' ni'e, na' bka'n ẕéngake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Naž Jesusen' gože' ḻégake': —Bi žébele. Le chej, na' le chjap ljéža'do' ka' nich chjake' zaka' gan nbab Galilea, gan yeḻé'egekle' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kate' ne zjak no'le ka', benne' ka' žjake' ḻo wdiḻe, benne' ka' wdape chí'igake' yežw ban', bežíngake' ḻo yežen', na' bzéngekle' bx̱oz wnná bia' ka' yógo'te dan' goken. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kate' ba bdobgak benne' gole ka', béngake' chawe' diža'. Naž bnéẕjwgake' mežw zan chegak benne' ka' žjake' ḻo wdiḻe. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Góžgake' ḻégake': —Ki nnale: “Benne' ka' bénlengake' ḻe' tẕen bžíngake' žele, na' bebéjgake' Ḻe' kate' ne ẕtasto'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Cha' yenle benne' wnná bian' da' ni, neto' wzejni'ilto' ḻe', na' gonto' ga bi be gone' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naž benne' ka' žjake' ḻo wdiḻe wẕí'gake' mežwn', na' yjéngake' kan ba nsédgekle'. Ki goken, ẕnnagak benne' judío ka' ki na' zejte na'a ža. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Naž chinejte benne' ka', benne' bénḻengake' Jesusen' tẕen, jake' gan nbab Galilea, na' bžíngake' ḻaw ya'adon', dan' ba bḻoe'el Jesusen' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kate' beḻé'egekle' Jesusen', bka'n ẕéngake' Ḻe', san baḻe' gok chope ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naž wbiga' Jesusen' gan nníta'gake', na' gože' ḻégake': —Dios ba bdie' ḻo na'a yógo'te yeḻa' wnná bia' ḻo ya'abá chie', na' ḻo yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Che ḻen le chej, na' le chejsedle yógo'te benách zi'to' ka', benne' ka' nníta'gake' dot yežlyó nga. Le yezóa ḻégake' nis, wkónlele žin La X̱ažo Dios, na' La Dios Ẕi'n, na' La Dios Be' La'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Le wsedle ḻégake' góngake' yógo'te dan' goža' ḻe'e gonle. Le wia nga, nedkza' zóaḻena' ḻe'e yógo'te ža na' zejte ža ze ḻawte ža ka' che yežlyó nga. Ka'kze gaken.");
INSERT INTO ztyNTps_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ki wzó ḻaw diža' chawen' kan nak che Jesús, Benne' Criston', Ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Goken kan bzoj Isaías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, da' wnná Dios nich yeyón chawen' yichj ḻáẕdo'gak benách ka' nich si' ḻo ná'gake' Benne' Criston'. Ki wnné': Bwia nga. Žseḻa'a benne' wbás chia', benne' nežwe' ka Le'. Ḻe' wpé'e nez gan tio'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yenle chi'i to benne' nnie' zižje latje dach, na' nne': “Le soa ban ḻaže' dan' za' X̱anžon' gan nníta'le. Le yebéj ḻi nez las gan tie'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ki goken dan' bḻa' Ẕwa latje dach, na' bchaḻje' nich yezoagak benách ka' nis, benne' ka' yeyát ḻáže'gake' nich yenít ḻaw Dios ḻégake' che doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bžojgak benne' zan yógo'te yež ka' gan nbab Judea, na' ḻezka' ḻo yež Jerusalén, na' jake' gan zoa Ẕwan', na' Ẕwan' bezóe' ḻégake' nis ḻo yego Jordán, benne' ka' bex̱óalapgake' doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Gokw Ẕwan' laže' dan' nžaben yicha' ẕa bia yix̱e', na' to bayw yid nžejen ḻi'e. Bdawe' biche' zo ka', na' we'je' bžina' che bezdo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Bchaḻj Ẕwan', na' wnné': —Za' to benne' te na'a, bennen' napže' yeḻa' wnná bia' ka neda'. Bi naka' neda' zi yechwa', nich kweja' ẕele'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neda' žezóa' ḻe'e nis, dan' ẕḻoe'elen nzi' ḻo na'le x̱tiža' Dios, san Ḻe' gone' da' ẕḻoé'ezele yeḻa' žezóa nis ni, dan' wchize' ḻe'e Dios Be' La'y, dan' wḻoe'elen nzi' ḻo na' Dios ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kate' ža na' bžoj Jesusen' yež Nasaret gan nbab Galilea, na' Ẕwan' bezóe' Ḻe' nis ḻo yego Jordán. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kate' bežój Jesusen' ḻo nisen', ḻa' na'ze bḻe'ele' beyaljw ya'abá, na' žetj Dios Be' La'y. Ẕnne'e ka to plomdo', na' bedjsóaḻene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Benle chi'i Benne' ẕchaḻje' ya'abá, na' wnné': —Le' nako' Ẕi'na'. Nži'ila' Le', na' žaz ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Naž Dios Be' La'y bchi'e Jesusen' de chgi' ḻo latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wzóa Jesusen' latje dachen' chopḻalj ža, na' gónele da' x̱iwe' gonen ga baga' Jesusen' doḻa'. Wzóa Jesusen' gan zej nnita' bia yix̱e' ka', bia želdaba' ya'ado'. Wbás che ya'abá ka' gókḻengake' Jesusen', na' bwáwgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wdé bséjwgake' Ẕwa liž ya, wyéj Jesusen' gan nbab Galilea. Bchaḻje' diža' chawen' dan' zan' ḻo na' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ki wnné': —Ba bžin ža. Za' yedjnná bia' Dios nga. Le yeyát ḻaže', na' le chejḻé' diža' chawe' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kate' ne ẕde Jesusen' žoa'a nisdo' che gan nbab Galilea, bḻe'ele' Smon, na' Ndres, benne' biche' Smon na'. Zej nake' benne' wẕén bel ka', na' želzaḻe' yix̱jw bel chégake' ḻaw nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesusen' bḻiže' ḻégake', na' wnné': —Le gonḻen neda' tẕen, na' gona' ga yedjwa'le benách ka' chia', gonle kan žonle kate' ẕzenle bel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ḻa' bká'ntegake' yix̱jw ka' chégake', na' jákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wdé Jesusen' yeláte'do' na'le, gan bḻe'ele' Jakob ḻen Ẕwa, benne' ka' zej nake' ẕi'n Sebedeo, na' nníta'gake' ḻo barkw chégake' gan žeyágake' yix̱jw bel ka' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesusen' ḻa' bḻižtie' ḻégake', na' bká'ngake' Sebedeon', x̱ágake', gan zóaḻene' benne' wen žin chie' ka' ḻo barkwn', na' jákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen yež Kapernaum. Kate' gok ža la'y chegak benne' judío ka', wyó'o Jesusen' yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' wzó ḻawe' žsedle' benne' ka' zej ndobe' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bebángekle' kan žsedle Jesusen', dan' žsedle' kan žon to benne' nzi' ḻo ne'e yeḻa' wnná bia', na' kege kan žongak benne' yodo' wsedle ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ḻezka' wzóa to benne' yoe'e be' x̱iwe' ḻo yo'o gan zej ndobe', na' wžéžeyi'e, ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","na' wnné': —¿Biẕ nbága'to' chio', Jesús, benne' Nasaret? ¿Zo'o nich wžía yi'o neto'? Nónbi'a Le'. Nako' Benne' La'y che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Naž Jesusen' wdiḻen', na' wnné': —Wzóa žize, na' bežój ḻo bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Naž be' x̱iwen' wžibe sisen bennen', na' wžéžeya'an zižje, na' ḻa' bežojten. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bebán ḻáže'gak yógo'te benne' ka' nníta'gake' ga na', na' wnnábgekle' ljéžgake' toe' yetóe', na' wnnágake': —¿Biẕkze da' ni? ¿Žsedle' to da' kobe? Ḻen yeḻa' wnná bia' ẕchi'le' be' x̱iwe' ka', na' žóngaken kan ẕnne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ḻa' wzete diža' che yeḻa' wak che Jesusen', na' béngekle benách ka' dot gan nbab Galilean' kan nak chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Naž bežój Jesusen' ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' ḻa' wyéjḻentie' Jakob, na' Ẕwa, na' bžíngake' ližgak Smon, na' Ndres. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","De x̱na' ẕo'le Bedw, bennen' lie' Smon, ḻo yo'on', na' yoe'e da' ḻa. Ḻa' belzéntele' Jesusen' kan žak che no'len'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Naž wbiga' Jesusen', na' bex̱we' ne'e, na' bechise' ḻe'. Ḻa' bežojte da' ḻa da' yoe'en, na' bsí'ni'e da' bdáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kate' za' žaḻe, kate' za' wžén wbíž, ḻa' bžíntegak benne' ka' zej noe'e benne' yižwé' ka' gan zoa Jesusen', na' ḻezka' benne' ka' zej yoe'e be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yógo'te benne' yež ka' bdóbdi'igake' kwit yo'o gan yo'o Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ḻe' beyone' benne' yižwé' zan, benne' ka' zej de'e yižwé' zan che chégake'. Ḻezka' bebeje' be' x̱iwe' zan, be' ka' zej yo'o benne' ka'. Bi bi'e latje nnegak be' x̱iwe' ka' dan' zej nonbian' Ḻe' No nake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zildo' wyase Jesusen', kate' ne nak choḻ. Bežoje' ḻo yežen', na' wyeje' to latje dach, gan bcháḻjḻene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Smon ḻen benne' ka' nníta'ḻengake' ḻe' bejdíljgake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kate' bejx̱áka'gake' Ḻe', belyi'e Ḻe': —Yógo'te benách žeyíljgake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naž Jesusen' gože' ḻégake', na' wnné': —Le cho'o yež gawze ka', nich wchaḻja' x̱tiža' Dios ga na'. Che ḻen bežoja'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ka' goken, wdé Jesusen' dot gan nbab Galilea, na' bchaḻje' ḻo yo'o ka' gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' bebeje' be' x̱iwe' ka' yo'ogak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To benne' da' beḻa' žen chie' yižwé' leže bžine' gan zoa Jesusen'. Bzoa ẕibe' ḻawe', na' góta'yoele' Ḻe', na' wnné': —Cha' žénelo', wak yeyono' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesusen' beyache' ḻáže'le' bennen'. Bḻi ne'e, na' wdane' ḻe', na' gože' ḻe': —Žénela'. Ba beyako'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Katen' wnné' da' ni, ḻa' benitte yižwén' dan' de'e, na' beyake' cháwe'do'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Naž Jesusen' bchi'le' bennen', na' ḻa' beséḻa'tie' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ki gože' ḻe': —Bi wzenlo' no benne' kan bena' chio', san wyéj, bejḻoé'el kwino' ḻaw bx̱oz, na' bejneẕjw che da' beyako' le' che yodo' kan wnná Moisés, dan' wḻoe'elen benách ka' ba beyako'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bežój bennen', na' wzó ḻawe' ẕzenle' benne' zan dan' goken chie'. Dan' bzie' diža' ni, biž gok chaz Jesusen' kwáselo ḻo yež, san wzoaze' na'le gan nak latje dach. Benách yógo'te yež bžíngake' gan zoe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wdé chope chonne ža, beyáz Jesusen' ḻo yež Kapernaum, na' wzé diža' zoe' ḻo yo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ḻa' bdóbtegak benne' zan gan zoa Jesusen', na' zejte biž gok chejnníta'gake' ga na', na' kege ža yo'o, na' Jesusen' bcháḻjḻene' ḻégake' x̱tiže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Naž bžingak tape benne' ka' gan zoa Jesusen', zej noe'e to benne' yižwé', benne' bi žak se'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bi gok žíngake' ḻaw Jesusen' dan' zej nnita' benne' zan ka' ga na'. Che ḻen bsáljwgake' yichjo'o gan nak ḻaw Jesusen'. Katen' beyóž bsáljwgaken', blétjgake' da' dele benne' yižwén' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kate' gókbe'ele Jesusen' kan žejḻé'gake' chie', gože' benne' yižwén': —Ẕi'na', ba benít ḻawa' le' che doḻa' da' nbago'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Že'gak baḻe benne' yodo' wsedle ka' ga na'. Wzá' ḻáže'gake', na' wnnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Biẕ chen' ẕchaḻj bennen' ki? Ẕzoe' Dios cheḻa'ale. Bi gak no benne' yenít ḻawe' che doḻa'. Toze Dios gak gonen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesusen' ḻa' gókbe'etele' da' ẕza' ḻáže'gake', na' gože' ḻégake': —¿Biẕ chen' ẕza' ḻáže'le ki? ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bi nak zede cha' no benne' ye'ze' benne' yižwé' ni ba benít ḻawe' che doḻa' da' nbage'e, san nak zede gone' ga yeyase', na' we'e da' dele', na' se'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na'a gona' da' gak bia' neda', Benne' Golje' Benách, nzi' ḻo na'a yežlyó nga yenít ḻawa' che doḻa' da' zej nbaga' benách ka'. Naž Jesusen' gože' benne' yižwén': ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Žapa' le': Wyase. Beká'a da' delo', na' beyéj ližo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ḻa' wyaste benne' yižwén', na' beké'e da' góte'le', na' bežoje' ḻawgak yógo'te benne' ka' nníta'gake' ga na'. Bebángekle' yógo'tegake', na' bka'n ẕéngake' Dios, na' wnnágake': —Batkle na' ḻe'elto' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bežój Jesusen' ḻo yež Kapernaum, na' wdíe' da' yoble žoa'a nisdon'. Bedobgak benne' zan gan zoe', na' Ḻe' bsedle' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kate' ne ẕde Jesusen' ga na', bḻe'ele' Lebí, ẕi'n Alfeo, ži'e gan ẕchiẕjwe' ḻo wláz yež zi'to'. Jesusen' gože' ḻe': —Benḻen neda' tẕen. Ḻa' wzó ža'te Lebín', na' wyéjḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wdé gok da' ni, benne' zan, benne' wechiẕjw ka' ḻen yebaḻe benne' gax̱jw ka' žé'gake' tẕen ḻen Jesusen', na' ḻen benne' wsedle chie' ka' gan žáwgake' ḻo liž Lebín'. Ki goken dan' benne' zan žjákḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kate' benne' yodo' ka', benne' wsedle ka' ḻen benne' fariseo ka', bḻé'egekle' Ḻe' ži'e žawe' tẕen ḻen benne' wechiẕjw ka', na' ḻen yebaḻe benne' gax̱jw ka', naž belyi'e benne' wsedle ka' che Jesusen', na' wnnágake': —¿Bižen' žone'? Že'j žáwḻene' tẕen benne' wechiẕjw ka', na' benne' doḻa' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Benle Jesusen' da' ni, na' gože' ḻégake': —Benne' ka' nníta'gake' chawe' bi žon byenen chjake' ḻaw benne' žeyone' benách ka', san benne' yižwé' ka' žon byenen chjake' ḻaw benne' žeyone' benách ka'. Za'a neda', kege nich wḻiža' benne' chawe' ka', san nich wḻiža' benne' doḻa' ka', nich yeyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kate' ža na' benne' ka' žónḻengake' Ẕwa tẕen, na' benne' ka' žónḻengake' benne' yodo' fariseo ka' tẕen, žóngake' wbás, na' bḻa'gak baḻe benne' ka' gan zoa Jesusen', na' wnnábgekle' Ḻe', na' wnnágake': —Benne' ka' žónḻengake' Ẕwan' tẕen, na' benne' ka' ẕónḻengake' benne' yodo' fariseo ka' tẕen, žóngake' wbás. ¿Biẕ chen' benne' ka' žónḻengake' Le' tẕen bi žóngake' wbás? ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Naž bechebe Jesusen', na' gože' ḻégake': —¿Wak gonle ga gongak wbás benne' ka' nníta'gake' lni che benne' ẕchag ne'e kate' ḻe' ne zóaḻene' ḻégake'? Kate' bennen' ẕchag ne'e ne zóaḻene' ḻégake', bi góngake' wbás. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Žin ža kate' kwas bennen' ẕchag ne'e, na' biž sóaḻene' ḻégake'. Ža na' góngake' wbás. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Bi wdá' nitó benne' to laže' kobdo' ḻo laže' gole nich yeyonen', dan' yedobe laže' koben', na' wžezan' laže' golen', na' chéza'že laže' golen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ḻezka', nitó benne' bi ke'e x̱is uba kobe ḻo že'e biž da' naken yid, dan' gak bḻa'a x̱is uba koben', na' wḻá'a že'e bižen' da' naken yid, na' ḻalje x̱is uban', na' gak ditje že'e na' da' naken yid. Žaḻa' ka'žo x̱is uba kobe ḻo že'e da' naken yid kobe. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","To ža la'y chegak benne' judío ka', wdé Jesusen' gan de yele ẕoa' stribe, na' benne' wsedle chie' ka' wzó ḻáwgake' ẕká'gake' bisto gan žia ẕoa' striben', na' žáwgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naž benne' yodo' fariseo ka' belyi'e Jesusen', na' wnnágake': —Bwia nga. Benne' ka' žónḻengake' Le' tẕen žóngake' da' bi žaḻa' gonžo ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesusen' gože' ḻégake': —¿Bi beḻ-le kan ben Dabí katen' wdone', na' byažje da' gawe' ḻe' ḻen benne' ka' wnníta'ḻengake' ḻe'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wyoé'e ḻo yo'o che Dios katen' gok Abiatar bx̱oz blo, na' bdawe' yet x̱til da' ẕkó'ogake' ḻaw Dios, dan' bi nzi' ḻo na' no benne' gawen', san toze bx̱oz ka' nzi' ḻo ná'gake' gáwgaken'. Ḻezka' bneẕjwe' da' bdawgak benne' ka' wnníta'ḻengake' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naž Jesusen' gože' ḻégake': —Dios bene' ža la'y nich yebéḻengeklen benách ka', kege bene' benách ka' nich góngake' x̱chin ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Che ḻen, neda', Benne' Golje' Benách, naka' x̱ane ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Da' yoble wyó'o Jesusen' to yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' ḻezka' zoa to benne' nžeke' ne'e ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Benne' yodo' ka' bwíagake' Jesusen' cha' yeyone' bennen' ža la'y, dan' žénegekle' yesbága'gake' Ḻe' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naž Jesusen' gože' bennen' nžeke' ne'e, na' wnné': —Wzó ža', na' wzé ḻawgak benne' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesusen' wnnable' benne' ka', na' wnné': —¿De latje gonžo da' nak chawe' kate' nak ža la'y, o gonžo da' ẕinnj? ¿De latje gape chi'ižo yeḻa' nban chegak benách ka', o wžía yi'žon? Wnníta'gak žize benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naž Jesusen', ḻo yeḻa' ẕža'a chie', bwie' benne' ka', benne' nníta'gake' dot kwite', na' gok nyache' ḻaže'e dan' nak zide yichj ḻáẕdo'gake'. Naž gože' bennen' nžeke' ne'e, na' wnné': —Bḻi no'o. Bennen' bḻi ne'e, na' ḻa' beyakten cháwe'do'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Naž bežojgak benne' yodo' fariseo ka', na' ḻa' béntegake' tẕen diža' ḻen benne' ka' žónḻengake' Herodes tẕen nich gak yesbága'gake' Jesusen' ẕia, na' gótgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Bezá' Jesusen' ga na' tẕen ḻen benne' ka' žónḻengake' Ḻe' tẕen, na' bžine' žoa'a nisdo', na' benne' zan jákḻene' Ḻe', benne' ka' zej nžoje' gan nbab Galilea, na' gan nbab Judea. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ḻezka' bžingak benne' zan gan zoa Jesusen', benne' ka' zej nžoje' Jerusalén, na' gan nbab Idumea, na' gan nbab yecheḻá'al yego Jordán, na' yež ka' zej nnitan' dot kwit gan zej nnita' yež Tiro, na' yež Sidón. Ki béngake' dan' béngekle' kan zej nak da' ẕen ka' da' žon Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Che ḻen Jesusen' gože' benne' ka' žónḻengake' Ḻe' tẕen wkwéztezegake' to barkw gan gak kwene', nich bi wchigak benne' zan ka' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ka' goken dan' ba beyone' benne' zan, benne' yižwé' ka', na' wbíga'gak benne' zan ka' gan zoe' nich kángake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kate' be' x̱iwe' ka' yo'ogak benách ka' bḻé'egeklen Jesusen', btínnegaken benne' ka' x̱ni'a Jesusen', na' wžéžeya'agaken, na' wnnágaken: —Nako' Le' Ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesusen' bchi'le' be' x̱iwe' ka', nich bi wzéngeklen benách ka' No nake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Naž wžén Jesusen' to ḻaw ya'ado', gan bḻiže' benne' ka' žénele'. Wbíga'gak benne' ka' dot kwite'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wžé Jesusen' chežinno benne' ki, nich gónḻengake' Ḻe' tẕen, na' nich seḻe'e ḻégake' chejzéngekle' benách ka' x̱tiže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bdie' ḻo ná'gake' yeḻa' wnná bia' nich yeyóngake' benne' yižwé' ka', na' nich yebéjgake' be' x̱iwe' ka' yo'ogak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ki lágake': Smon, (bzoa Jesusen' yetó le', Bedw), ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakob, Ẕwa, (benne' biche' Jakob, na' zej nake' ẕi'n Sebedeo. Chope' ki, Jesusen' bezóe' yetó lágake', Boanerjes, da' zejḻasen ḻen diža' x̱iža': Benne' waḻe ka' ka wzió'), ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ndres, Lip, Bartol, Matío, Mas, Jakob, (ẕi'n Alfeo), Tadeo, Smon, (benne' že' ḻaže'e yež chie'), ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariote, (benne' wdíe' Jesusen' ḻo na'gak benne' ka' gótgake' Ḻe'). Wdé na' bežín Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen to yo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Da' yoble bdobgak benne' zan gan zoa Jesusen', na' biž gota' latje bi da' gaw Jesusen' ḻen benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kate' béngekle benne' bíche'kze Jesusen' ka' kan žak chie', bžíngake' ga na' nich yeché'gake' Ḻe', na' wnnágake': “Žak yaḻ yichje'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ḻezka' benne' yodo' wsedle ka', benne' zej nžoje' yež Jerusalén, wnnégake' chie', na' wnnágake': —Belzebú, x̱angak be' x̱iwe' ka', žónḻenen Ḻe' tẕen, na' ḻen yeḻa' wnná bia' chen žebeje' be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naž Jesusen' bḻiže' benne' yodo' wsedle ka', na' bsaka' ḻebe', na' wnné': —¿Yebéj da' x̱iwe' ḻa' kwinzen? ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Cha' benne' ka' nníta'gake' to yež ḻa'a lázgake', na' cha' tíḻ-ḻengake' ljéžgake' ka', bi gak dia' yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ḻezka' cha' benne' ka' nníta'gake' to yo'o ḻa'a lázgake', na' cha' tíḻ-ḻengake' ljéžgake' ka', bi gak diá'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Che ḻen, cha' da' x̱iwe' tíḻ-ḻenen lježen ka', na' cha' ḻa'a lázgaken, bi gak dia' yeḻa' wnná bia' chen, san za' yeyóž chen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Bi gak nitó benne' choe'e liž to benne' waḻe, nich kweje' yeḻa' wnni'a chie' cha' bi wcheje' benne' waḻen' zga'ale, na' naž sake'e kweje' da' de liž bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Da' li žapa' ḻe'e: gak yenít ḻaw Dios benách ka' che yógo'te doḻa' da' zej nbage'e, na' che yógo'te diža' x̱iwe' da' ẕnnágake', ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","san cha' no benne' nnie' che Dios Be' La'y, batkle yenít ḻaw Dios bennen'. To chi'ize nbage'e ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ki wnná Jesusen' dan' benne' yodo' wsedle ka' wnnégake' chie', na' wnnágake': “Da' x̱iwe' žónḻenen Ḻe' tẕen.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naž benne' biche' Jesusen' ka' ḻen x̱ne'e bžíngake' gan zoe'. Wnníta'gake' ḻa' ḻí'ale, na' bséḻa'gake' to benne' chejḻiže' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","To benne' ladjw benne' zan, benne' ka' žé'gake' dot kwit Jesusen' gože' Ḻe', na' wnné': —Benne' bicho'o ka' ḻen x̱no'o, nníta'gake' ḻa' ḻí'ale, na' žḻižgake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bechebe Jesusen', na' gože' ḻégake': —¿Nnézlele no benne' nake' x̱na'a, na' no benne' ka' zej nake' bicha'a ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naž bwie' benne' ka' žé'gake' dot kwite', na' wnné': —Le wia nga. Benne' ki zej nake' ka x̱na'a, na' benne' bicha'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","No benne' žone' kan žénele Dios, benne' ni nake' ka benne' bicha'a, na' ka no'le zana', na' ḻezka' ka x̱na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Da' yoble wzó ḻaw Jesusen' žsedle' benne' ka' gan nak žoa'a nisdo'. Bdobgak benne' zan gan zoe', na' wžén Jesusen' to ḻo barkw da' žen' ḻo nisen', na' wži'e ga na', na' yógo'te benne' ka' wnníta'gake' ḻo yo žoa'a nisen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesusen' bsedle' ḻégake' da' zan, da' bsaka' ḻebe'. Kate' ne žsedle' ḻégake', wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Le wzé nag da' ni. Bžoj to benne' žaz, zjeze' bínnedo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kate' ne zjeze', béx̱jwgak baḻe bínnedo' ka' to ḻo nez las. Bžingak byínnedo' ka', na' bdáwgakban'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yebaḻe bínnedo' ka' béx̱jwgaken gan že' yej, gan de láte'ze yo. Bayenze bḻa'gak bínnedo' ka' dan' de láte'ze yo ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Naž kate' bḻa' wbíž, ḻa' wbížtegaken dan' bi nóngaken lwen gže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yebaḻe bínnedo' ka' béx̱jwgaken gan begolgak lba yeche' ka'. Kate' bḻa'gak bínnedo' ka', ḻezka' beḻa'gak lba yeche' ka', na' bdóbgaken da' ka' goze', na' da' ka' bi be bnéẕjwgaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yebaḻe bínnedo' ka' béx̱jwgaken gan nak yo bebe, na' bḻá'gaken, na' gól-ḻe'egaken. Bnéẕjwḻe'egak da' ka' goze'. To yag da' goze' bneẕjwn yechí žoa bínnedo' ka'. Yetón bneẕjwn yechonnḻalj bínnedo' ka', na' yetón bneẕjwn yetó gaywá' bínnedo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naž Jesusen' gože' ḻégake', na' wnné': —No benne' zoa nage', na' ženle', žaḻa' wzé nage'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kate' Jesusen' ba bga'ne' toze', benne' zan, benne' ka' nníta'gake' ga na' bžíngake' gan zoe', tẕen ḻen chežinno benne' wsedle chie' ka', na' wnnábgekle' Ḻe' biẕ žsedle dan' bsaka' ḻebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesusen' gože' ḻégake', na' wnné': —Dios žonne' ḻe'e latje chejní'ilele da' ngache' kan ẕnna bi'e, san benne' ka', benne' bi žónḻengake' žo'o tẕen, yógo'te ẕcháḻjḻengaka'-ne' da' žsaka' ḻeba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ki žona' dan' žak kan nyejw ḻe'e yiche la'y, da' ẕnnan: Wíagake', san bi ḻé'egekle'. Wzé nággake', san bi chejní'igekle', na' bi yeyát ḻáže'gake' nich gak yenít ḻawa' chégake' doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ḻezka' Jesusen' gože' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —¿Bi žejní'ilele dan' bsaka' ḻeba'? ¿Nakx̱ gak chejní'ilele yezika' da' wsaka' ḻeba'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Benne' žazen' nake' benne' ẕzie' diža'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Zej nak baḻe benne' ka' ka bínnedo' ka' béx̱jwgaken to ḻo nez. Želyenle' x̱tiža' Dios, san kate' želyenlen', ḻa' za'te da' x̱iwe', na' ẕka'n dižan' da' béngekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Zej nak yebaḻe benne' ka' ka bínnedo' ka' béx̱jwgaken gan že' yej. Želyenle' dižan', na' ḻen yeḻa' žebél chégake' želzi'en. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","San bi žazen ḻo yichj ḻáẕdo'gake', na' to chí'ido'ze ẕzí'gaken'. Kate' bi da' žak chégake' o cha' zoa benne' ẕbia ḻaže'e ḻégake' dan' ẕze nággaken', ḻa' žsan ḻáže'tegaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Zej nak yebaḻe benne' ka' ka bínnedo' ka' béx̱jwgaken gan žegolgak lba yeche' ka'. Želyenle' dižan', ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","san že' ḻáže'gake' da' naken che yežlyó nga. Žon ḻáže'len ḻégake' dan' zej nži'ile' yeḻa' wnni'a, na' ẕdan ḻáže'gake' yeḻa' gape. Yógo'te da' ki želyazen ḻo yichj ḻáẕdo'gake', na' ẕnitle dižan', na' bi žonen žin ḻo yichj ḻáẕdo'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Zej nak yebaḻe benne' ka' ka bínnedo' ka' béx̱jwgaken ḻo yo bebe. Želyenle' dižan', na' ẕzi' ḻo ná'gaken', na' žonen žin ḻo yichj ḻáẕdo'gake'. Zej nak baḻe benne' ki ka bínnedo' ka' bnéẕjwgaken yechí žoan. Zej nake' yebaḻe' ka bínnedo' ka' bnéẕjwgaken yechónnḻaljen, na' zej nak yebaḻe' ka bínnedo' ka' bnéẕjwgaken yetó gaywán'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ḻezka' Jesusen' gože' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —Kate' ẕwáḻa'žo yi', ¿ẕdóse'žon to kak, o ẕgo'ožon ẕane gan žáta'žo? Bi žonžo ki, san ẕzoažon ža'le gan ko'on baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yógo'te da' zej ngachen' yeḻá' ḻáwgaken, na' yógo'te da' žákgaken gan nak choḻ žójgaken ḻo baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","No benne' zoa nage', na' ženle', žaḻa' wzé nage'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ḻezka' gože' ḻégake': —Le we' ḻaže' che da' žénlele. Kan nak da' ẕžíx̱ele, tḻebe wžíx̱ Dios chele, na' wneẕjwe' yelate' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","No benne' nzi'e x̱tiže'e, we'e yelate' chie', san no benne' bi nzi'e x̱tiže'e, da' láte'do'ze da' benle', yegá'n. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ḻezka' wnná Jesusen': —Kan žak yeḻa' wnná bia' che Dios yežlyó nga naken kan žak kate' to benne' žaze' ẕoa' stribe ḻo yežlyó chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yele ẕtase', na' žeyase' kate' za' ža'ní'. Ẕḻa' yag ẕoa' striben', na' ẕgolen, san ḻe' bi nnezle' nakx̱ žak ẕgolen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ḻa' yežlyón' žẕenen da' nazen ḻo yežlyón'. Zga'ale za' x̱yazen, naž za' bisto chen, na' te na' kwia ẕoa' stribe waḻe ḻo bisto chen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kate' ba naḻe ẕoa' striben', ḻa' chejtie' chejchoge' bizton' dan' ba bžin ža si'e ẕoa' striben'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ḻezka' wnná Jesusen': —¿Biẕ nnia' kan žak yeḻa' wnná bia' che Dios yežlyó nga? ¿Biẕ wsaka' ḻeba' kan žaken? ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Žaken kan žak che to bínnedo' mostasa. Kate' žazen ḻo yo naken to bínnedo' da' nakžen kwíde'do' ka yógo'te bínnedo' ka' žé'gaken ḻo yo, ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","san kate' ba nazen, ẕḻan', na' žẕéntežen ka yógo'te yix̱e' kwan da' žé'gaken yežlyó. Kan žon yana' ni'a nen', gak žingak byínnedo' ka', na' wžíagakba' x̱ó'ngakba' ḻo ẕoḻ chen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ka' goken, Jesusen' bsedle' ḻégake', na' da' zanže da' bsaka' ḻebe' kan gok chejní'igekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yógo'te da' bcháḻjḻene' benne' ka', bzaka' ḻeben', na' yógo'te da' ki bzejni'ile' ḻégakze benne' wsedle chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ḻa' ža na'ze, kate' za' žaḻe, Jesusen' gože' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —Le cho'o, težo yecheḻá'a nisdo' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Naž bkwásgake' gan nníta'gak benne' zan ka', na' bsá'gake' barkwn' gan ba že' Jesusen'. Ḻezka' wnníta'gak yebaḻe barkw ka' ga na', da' ka' zjákḻenen ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wzó ḻaw žak to be' waḻe ḻo nisen', na' wdá'a nis ḻo barkwn'. Ka' goken, zej ẕcha' nis ḻo barkwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusen' die' ẕtase' ḻo x̱kogwe' gan nak ža'le ḻo barkwn', na' besbángake' Ḻe', na' belyi'e Ḻe': —Benne' wsedle. ¿Bi žeklo' cheto'? Gatkzto' ẕan nis nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Naž wyase Jesusen', na' bḻiže' ben' žaken, na' wnné': —Wzóa ži. Ḻezka' gože' nisen', na' wnné': —Žize wzóa. Wzóa ži ben' goken, na' wžé' ži nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Naž Jesusen' gože' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —¿Biẕ chen' ẕžébele ki? ¿Bi na' chejḻe'le che Dios? ");
INSERT INTO ztyNTps_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ne ẕžébegake', belyi'e ljéžgake' toe' yetóe': —¿Biẕkze nak benne' ni? Be' žaken, na' nisdo' žóngaken kan ẕnna x̱tiže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Naž bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen yecheḻá'a nisdo' gan nbab che yež Gadara. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kate' bežój Jesusen' ḻo barkwn', ḻa' bžinte to benne' ḻawe' Ḻe', benne' bžoje' to ḻo bloj gan zej ngache' benne' gat ka', na' yoe'e be' x̱iwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Benne' ni ẕzoe' gan zej ngache' benne' gat ka'. Bi gok nitó benne' wcheje' ḻe', kege ḻen do ya. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zan chi'i bzóagake' bayw ya yen ne'e, na' ni'e, na' bchéjgake' ḻe' do ya ka'. Ble'e do ya ka', na' bzoẕje' bayw ya ka'. Bi gok no benne' nna bi'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ẕdáteze' ẕbéžeyi'e dot ža dot yele gan zej ngache' benne' gat ka', na' gan nak ḻaw ya'ado' ka', na' žon we' kwine' ḻo yej ka' zej žen' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kate' bḻe'ele' za' Jesusen' zí'to'le, taría taría wyeje' gan ze'e, na' bzoa ẕibe' ḻawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wnníe' zižje, na' gože' Jesusen': —¿Biẕ nbaga'a chio', Jesús, Ẕi'n Dios, Benne' ẕente? Ni'a che X̱anžo Dios žáta'yoela' le', bi wsaka' zi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ki wnné' dan' Jesusen' ba gože' be' x̱iwen': —Le', be' x̱iwe', bežój ḻo bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesusen' wnnablen', na' wnné': —¿Bi lio'? Beží'i be' x̱iwen', na' gožen Ḻe': —Da' Zan lia' dan' nakto' be' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wnné yachen' ḻaw Jesusen' nich bi seḻe'e be' x̱iwe' ka' zi'to' ḻo yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Zej nnita' koch zan ḻaw ya'ado' na'ze, želdaba' žáwgakba' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Be' x̱iwe' ka' wnné yáche'gaken ḻaw Jesusen', na' wnnágaken: —Bseḻa' neto' gan zej nnita' koch zan ka'. Benn neto' latje chejžó'ogakto'-ba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesusen' ḻa' be'tie' ḻégaken latje, na' bežojgak be' x̱iwe' ka', na' bejžó'ogaken koch zan ka', na' bx̱íte'gak koch ka', na' bejbíx̱jgakba' gan nak žoa'a ya'a, na' bejcházgakba' ḻo nisdo', gan wyépegakba' nis, na' gótgakba'. Gókgakba' ka chop milba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Naž bẕonnjgak benne' ka' žape chí'igake' koch ka', na' bejzéngekle' benne' yež ka', na' ḻezka' benách ka' nníta'gake' yix̱en'. Bžojgak benne' yež ka', nich chejwíagake' biẕen' goken ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kate' bžíngake' gan zoa Jesusen', bḻé'egekle' bennen' zga'ale yoe'e be' x̱iwe' ka'. Že' bennen' ga na', na' nakwe' laže', na' zoe' cháwe'do', na' bžébegak benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ki goken dan' benne' ka', benne' bḻé'egekle' da' ben Jesusen' bzéngekle' benne' ka' bžójgake' ḻo yež kan goken che bennen' zga'ale yoe'e be' x̱iwe' ka', na' ḻezka' kan gok chegak koch ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Naž wzó ḻawgak benne' ka' žáta'yoegekle' Jesusen' yežoje' ḻo yežlyó chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kate' bebén Jesusen' ḻo barkw, bennen' zga'ale yoe'e be' x̱iwe' ka', góta'yoele' Jesusen' we'e ḻe' latje chéjḻene' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusen' bi bi'e ḻe' latje, san gože' ḻe': —Beyéj ližo'. Bejzenle lježo' ka' da' ẕen da' bena' chio' neda', naka' X̱ano', na' ka beyache' ḻáže'la' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Beyéj bennen', na' wzíe' diža' ḻo yež Dekápolis ka' kan nak da' ẕen da' ben Jesusen' chie', na' bebán ḻáže'gak yógo'te benne' ka' nníta'gake' yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kate' bežín Jesusen' yecheḻá'a nisdon', naž bedobgak benne' zan gan zoe' žoa'a nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ḻezka' to benne' lie' Jairo, benne' blo che yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, bḻe'e gan zoa Jesusen'. Katen' bḻe'ele' Ḻe', bzoa ẕibe' ḻawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Góta'yoele' Ḻe', na' wnné': —Za' gat x̱kwide' no'le chia'. Da, x̱oa no'o ḻebe' nich yeyakbe', na' bi gatbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesusen' wyéjḻene' ḻe', na' benne' zan zjákḻene' Jesusen', na' ẕchígake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ḻezka' zoa to no'le ga na', ba zej chežinno yiz de'e yižwé'. Bi žebíž žen chie' che we' chégakkze no'le ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ba wẕáka'ḻi'e ḻo na'gak benne' zan, benne' ka' žeyóngake' benách ka'. Dáche'ze ba btie' dot da' wdape', na' bi be gókḻenen ḻe', san žyáḻa'žen chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kate' benle' ẕchaḻjgak benách ka' kan nak che Jesusen', wdíe' ládjwle benne' zan ka', na' bžine' zaka' x̱kože'l Jesusen', na' wdane' laže' da' nakwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ki bene' dan' wnné': “Cha' kanza' ẕe', yeyaka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ḻa' bebižte žen chie', na' gókbe'ele' ba beyake' che da' goken chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ḻa' gókbe'etel Jesusen' ben žin yeḻa' wak chie', na' beyechje'. Bwie' benne' zan ka', na' wnné': —¿Noẕ benne' wdane' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Naž benne' ka' zej nake' toze ḻen Ḻe' góžgake' Ḻe', na' wnnágake': —Ẕḻé'ekzelo' benne' zan ki ẕchígake' Le', na' ẕnno': “¿Noẕ benne' wdane' neda'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naž bwia Jesusen' dot kwite' nich ḻe'ele' bennen' wdane' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naž no'len' wbige'e ḻawe'. Ẕžebe', na' žẕize', dan' nnezle' dan' goken chie'. Bzoa ẕibe' ḻaw Jesusen', na' gože' Ḻe' dot dan' goken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Naž Jesusen' gože' ḻe': —Nó'ledo'. Ba beyako' dan' žejḻi'o chia'. Binlo beyéj ližo'. To chi'ize beyako' che dan' goken chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kate' ne ẕchaḻj Jesusen' da' ki, benne' ka' zej nžoje' liž benne' blon' che yo'o gan želyenle' x̱tiža' Dios, bžíngake' ga na', na' belyi'e bennen': —Ba got x̱kwide' no'le chio'. Biž wpižjo' benne' wsedle. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bi be' ḻaže' Jesusen' dan' wnnágake', san gože' benne' blon', na' wnné': —Bi žebo'. Bejḻe'ze che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesusen' bi bneẕjwe' yezika' benne' ka' latje chjákḻene' Ḻe', san ḻégakze Bedw, na' Jakob, na' Ẕwa, benne' biche' Jakoben'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Katen' bžine' liž benne' blon' che yo'o gan želyenle' x̱tiža' Dios, bḻe'ele' žak žax̱to', na' zej nnita' benne' ka' ẕbéžegake' ga na', na' ḻezka' benne' ka' ẕbeže nyáche'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wyó'o Jesusen' ga na', na' gože' ḻégake': —¿Biẕ chen' žonle žax̱to', na' ẕbéžele ki? Bi nat x̱kwide' no'len'. Ẕtászebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Naž ben dítjgekle' Jesusen', san Ḻe' bebeje' yógo'te benne' ka' na'le. Bchi'e x̱a x̱na' x̱kwide' no'len', na' ḻezka' benne' ka' žónḻengake' Ḻe' tẕen, na' wyoé'e gan debe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bex̱we' na' x̱kwide' no'len', na' gože'-be': —Talita, kumi. Diža' hebreo ni ẕnnan ḻen diža' x̱iža': “X̱kwide' no'le, wyase.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ḻa' wyaste x̱kwide' no'len', na' beza'be'. Ba zejbe' chežinno yiz. Bebán ḻáže'gak benne' ka' nníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Naž Jesusen' bchi'le' ḻégake' bi wzéngekle' nitó benne' dan' goken. Na' gože' ḻégake': —Le gonn da' gaw x̱kwide' no'le ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Naž bezá' Jesusen' ga na', na' bežine' laže', na' benne' ka' žónḻengake' Ḻe' tẕen wzá'ḻengake' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kate' bžin ža la'y chegak benne' judío ka', wzó ḻaw Jesusen' žsedle' benne' ka' gan ẕdóbgake' nich yéngekle' x̱tiža' Dios. Wnníta'gak benne' zan ga na', benne' ka' želyenle' chie'. Bebángekle', na' wnnágake': —¿Gaẕ bsedle bennen' da' ki? ¿Biẕ yeḻa' žejní'il na' da' nape'? ¿Nakx̱ žone' da' ka' zej nak bian', da' ka' zá'gaken zaka' ya'abá che Dios? ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Benne' ni nake' benne' ẕkonle' žin blag ka', ẕi'n Lia. Nake' bíche'gak Jakob, na' Jwsé, na' Judas, na' Smon. Ḻezka' no'le zane' ka' nníta'ḻengake' žo'o nga. Che ḻen bzóagake' Ḻe' cheḻa'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Naž Jesusen' gože' ḻégake', na' wnné': —Gáte'teze žápegake' ba la'ne to benne' ẕchaḻje' ḻo wláz Dios, san benne' wláž chie' ka', na' lježe' ka', na' benne' ka' nníta'gake' liže' bi žápegake' ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Che ḻen Jesusen' bi gok gone' nitó yeḻa' wak ẕen ga na'. Toze beyone' babze benne' yižwé' ka', kate' bx̱oa ne'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bebán ḻaže'l Jesusen' dan' bi žejḻé'gake' chie'. Wdé na' wdíe' yeždo' ka' zej žen' dot kwit ga na', na' bsedle' benne' ka' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naž Jesusen' bḻiže' benne' chežinno ka', benne' žónḻengake' Ḻe' tẕen, na' wzó ḻawe' žseḻe'e ḻégake' chope chópegake'. Bdie' ḻo ná'gake' yeḻa' wnná bia' kwéjgake' be' x̱iwe' ka' yo'ogak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bchi'le' ḻégake' bi be wá'gake' ḻo nez, kege yix̱jw, na' kege yet, na' kege mežw bi kó'ogake' ḻo bzode chégake', san toze yagdo' chjwá'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Žaḻa' chjwá'gake' ẕélgake', san kege yetó laže' da' x̱oan yéngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ḻezka' gože' ḻégake': —Gáte'teze gan cho'ole to yo'o, le soa yo'on' kate' yezá'žele yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cha' chazle to yež gan benne' ka' bi gápegake' ḻe'e ba la'ne, na' bi wzé nággake' x̱tíža'le, le yežój ga na', na' le wchínnj bix̱te yo da' dan' lable. Da' ni gak bian' zej nbage'e ẕia. Da' li žapa' ḻe'e, kate' žin ža chog Dios chegak benách ka', naž sáka'žegak benne' ka' che yežen' ka sáka'gak benne' ka' che yež Sodoma, na' benne' ka' che yež Gomorra, yež ka' bchinnj Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Naž bžojgak benne' ka' žónḻengake' Ḻe' tẕen, na' bejzéngekle' benách ka' žaḻa' yeyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ḻezka' bebéjgake' be' x̱iwe' zan yo'ogak benách ka'. Wló'ogake' set ḻawgak benne' zan, benne' yižwé' ka', na' beyákgake' cháwe'do'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Benle Herodes, benne' ẕnna bi'e, kan nak da' žon Jesusen', dan' ẕze diža' gáte'teze che yeḻa' wak chie'. Baḻe benne' ka' ẕnnágake': —Nake' Ẕwa, bennen' bezóe' benách ka' nis. Ba bebane' ḻo yeḻa' got. Che ḻen nape' yeḻa' wak žone' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yebaḻe benne' ka' ẕnnágake': —Nake' Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te. Yebaḻe' ẕnnágake': —Nake' to benne' ẕchaḻje' ḻo wláz Dios kan gokgak benne' ka' wnníta'gake' ža ni'te, benne' ka' bcháḻjgake' ḻo wlaze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kate' benle Herodes da' ki, wnné': —Nake' Ẕwa, bennen' bžix̱a' yene'. Ba bebane' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ki wnná Herodes na' dan' ḻekze' bseḻe'e benne' ka' yjéx̱jwgake' Ẕwan', na' bchéjgake' ḻe' ḻen do ya ḻo yo'o liž ya. Ki ben Herodes na' dan' ẕža' Herodías Ẕwan'. Herodías na' nake' no'len' goke' ẕo'le Lip, benne' biche' Herodes na'. Herodes na' bekwase' Herodías na', na' bchag ná'ḻene' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ẕwan' gože' Herodes na': —Bi žaḻa' sóaḻeno' ẕo'le benne' bicho'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Dan' gónele Herodías na' bi da' gone' che Ẕwan' nich gote' ḻe', che ḻen gónele' gata' latje chie', san bi be wẕáka'le', ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","dan' Herodes na' ẕžebe' Ẕwan', dan' nnézkzele' nak Ẕwan' chawe', na' la'y. Che ḻen wdape chi'e ḻe', na' bze nage' chie' dot ḻaže'e ḻa'kze dan' wnná Ẕwan' benen ga wžé' zedle Herodes na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Naž bžin to ža wẕáka'le Herodías na', da' naken ža žon lni Herodes na' che ža wye'ele' yiz. Bsí'ni'e da' ye'j gawgak benne' ka' nzi' ḻo ná'gake' ḻo wlaze' ḻe', na' benne' ka' ẕché'gake' benne' ka' žjake' ḻo wdiḻe, na' ḻezka' benne' ka' zej nake' blo gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wyáz x̱kwide' no'le che Herodías na' gan že'j žáwgake', na' bya'abe' ḻáwgake'. Wyáz ḻaže' Herodes na' kan žonbe', na' ḻezka' wyáz ḻáže'gak benne' ka' že'j žáwḻengake' ḻe' tẕen. Naž Herodes na' gože' x̱kwide' no'len', na' wnné': —Wnnáb bi da' žénelo' wneẕjwa' chio', na' gonan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ben choche' x̱tiže'e, na' gože'-be': —Ni'a che X̱anžo Dios wneẕjwa' chio' bíte'teze da' nnablo' neda', na' zejte gachje gan ẕnna bi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naž bežojbe', na' gožbe' x̱na'be': —¿Biẕ nnaba'? Ḻe' gože'-be': —Yichj Ẕwa, bennen' bezóe' benách ka' nis, nnabo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ḻa' beyáztebe' gan zoa Herodes na', na' gožbe'-ne': —Žénela' wx̱ó' chia' na'a ḻo ye'n ẕen yichj Ẕwa, bennen' bezóe' benách ka' nis. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Gok nyache' ḻaže' Herodes na', san dan' ben choche' x̱tiže'e ni'a che Dios, na' dan' béngekle benne' ka' žáwḻengake' ḻe' tẕen dan' wnné', na' bi gónele' yinnj x̱tiže'e da' bchebe ḻaže'e chebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Naž Herodes na' ḻa' bséḻa'tie' to benne' žeje' ḻo wdiḻe, benne' zoe' žape chi'e ga na', na' gože' ḻe' chejx̱i'e yichj Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bennen' žeje' ḻo wdiḻe wyeje' liž ya, na' bejžix̱e' yen Ẕwan', na' bechi'e yichje', dan' bx̱oe' to ḻo ye'n ẕen. Wdíen' ḻo na' x̱kwide' no'len', na' ḻebe' bnéẕjwben' che x̱na'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kate' benne' ka' zej nake' Ẕwan' toze béngekle' dan' goken, bžíngake' ga na', na' beché'gake' ḻe', na' bejkáche'gake' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wdé na' beḻa'gak benne' wbás ka' che Jesusen' gan zoe', na' bzéngekle' Ḻe' yógo'te da' béngake', na' da' ka' bsédgekle' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Benne' zan, benne' ka' zá'gake', na' benne' ka' zjake', wnníta'gake' ga na'. Ka' goken na' zejte biž de latje bi da' gaw Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen. Che ḻen Jesusen' gože' ḻégake', na' wnné': —Le cho'o. Chejžo žo'oze gan nak latje dach, na' yezí' ḻáže'žo to chi'i. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Naž jake' ḻégakze' to ḻo barkw, na' bžíngake' to latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bḻé'egekle benne' zan ka' zjake' ga na', na' gókbe'egekle' žezá'a Jesusen'. Che ḻen benne' yógo'te yež ka' wzá' ní'agake', na' taríaze jake' ga na'. Bžíngake' ga na' zgá'alegake' ka Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kate' bežój Jesusen' ḻo barkwn', bḻe'ele' benne' zan ka', na' beyache' ḻáže'le' ḻégake' dan' zej nake' ka ẕíla'do' ka' bi zoa benne' žape chi'e ḻégakba'. Wzó ḻawe' žsedle' ḻégake' da' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kate' za' žaḻe ža na', benne' ka' žónḻengake' Jesusen' tẕen bžíngake' gan zoe', na' belyi'e Ḻe': —Za' žaḻe, na' latje dach naken nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Beseḻa' benne' zan ki, nich chjake' yo'odo' ka', na' yeždo' ka' zej žen' gawze nga, nich chjé'wgake' yet, dan' bi be de nga da' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bechebe Jesusen', na' gože' ḻégake': —Le wneẕjw ḻe'ekze da' gáwgake'. Naž belyi'e Ḻe': —Chela' napto' láẕjwto' che x̱ono' byo' wen žin, wak chjé'wto' yet x̱til, na' wnéẕjwto' dan' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naž Jesusen' gože' ḻégake': —¿Baḻ yet x̱til de chele? Le chejwía. Kate' ba nnézgekle', belyi'e Ḻe': —Gáyo'ze yet x̱til den, na' chopze bel deba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Naž wnná Jesusen' góngake' ga kwe'gak benne' zan ka' to kwe' to kwé'gake' gan nak lache' ḻo daka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wžé'gake' to kwe' to kwé'gake', to gaywá' to gaywá'gake', na' chiyón chiyóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Naž bex̱w Jesusen' da' gáyo'te yet x̱til ka', na' da' chope bel ka'. Bwie' ya'abale, na' gože' Dios: “Žóx̱keno'.” Naž bzoẕje' yet x̱til ka', na' bneẕjwen' chegak benne' wsedle chie' ka' nich chísgaken' chegak benne' zan ka'. Ḻezka' wdise' da' chope bel ka' chegak yógo'te benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bdáwgake' yógo'tegake', na' béljegekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naž betóbgake' da' bižjw ka' chegak yet x̱til ka', na' chegak bel ka', na' beschá'gake' chežinno x̱kwite ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Benne' ka' bdáwgake' ga na' gókgake' ka gayo' mil benne' byo ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ḻa' bente Jesusen' ga wžengak benne' ka' žónḻengake' Ḻe' tẕen ḻaw barkw, nich wnéžwgake' Ḻe', na' chejtégake' ḻo nisdon', nich žíngake' ḻo yež Betsaida, katen' Ḻe' yeseḻe'e benne' zan ka' lížgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kate' beyóž beseḻe'e ḻégake', wyeje' to ḻaw ya'ado', gan bcháḻjḻene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Katen' ba goḻen, zej barkwn' gachje ḻáwe'le nisdon', na' zoa Jesusen' toze' ḻo yo bižen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesusen' bḻe'ele' ḻégake', na' žejx̱áke'gekle' žsá'gake' barkwn' dan' žak be' da' za' gan želdíe'. Wdé gachje yele bžin Jesusen' gan nníta'gake', ẕde' ḻáwe'le nisdon', na' gónele' teze' gan nníta'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kate' bḻé'egekle' Ḻe' ẕde' ḻáwe'le nisdon', gókgekle' to bxin nake', na' wžéžeya'agake', ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","dan' yógo'tegake' bḻé'egekle' Ḻe', na' bžébegake'. Naž Jesusen' ḻa' bḻižtie' ḻégake', na' wnné': —Le gon choch ḻáže'le. Nedkzan'. Bi žébele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wžén Jesusen' ḻo barkwn' gan nníta'gake', na' wžé' ži ben' žaken, na' ḻégake' bebánḻe'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bi žejní'igekle' da' ẕḻoe'el dan' ben Jesusen' che yet xtilen'. Ne nak zide yichj ḻáẕdo'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wdé Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen yecheḻá'a nisdo', na' bžíngake' gan nbab yež Jenesaret. Bžíga'gake' barkwn' ḻo yo bižen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kate' bežójgake' ḻo barkwn', benne' ka' nníta'gake' ga na' ḻa' beyónbia'tegake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Taríaze jak benne' ka' yógo'te yeždo' ka' žé'gaken gawze ga na', na' wzó ḻáwgake' žedjwá'gake' yógo'te benne' yižwé' ka' gan zoa Jesusen', benne' dégake' da' žáta'gekle', na' bžíngake' gáte'teze želyenle' zoa Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gáte'teze gan ẕde Jesusen', ḻo yeždo' ka', na' yež ẕen ka', na' yo'odo' ka', bedjwá'gake' benne' yižwé' ka' chégake' gan nak ḻo nez, na' gan nak ḻawe' ya'a. Góta'yoegekle' Ḻe' wneẕjwe' ḻégake' latje kángakze' laže' da' nakwe'. Yógo'te benne' ka' wdángaken' ḻa' beyáktegake' cháwe'do'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Naž baḻe benne' yodo' fariseo ka' ḻen baḻe benne' yodo' wsedle ka', benne' ka' zej nžoje' yež Jerusalén, bdóbgake' gan zoa Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Benne' yodo' ki bḻé'egekle' benne' wsedle ka' che Jesusen' žáwgake' yet, na' bi zej nak chawe' ná'gake', dan' ẕnnan: bi zej nyiben kan žónteze žongak benne' yodo' ka'. Che ḻen wnnégake' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Benne' yodo' fariseo ka', na' yezika' benne' judío ka', žóngake' kan bénteze bengak x̱a x̱tó'gake' ka', na' cha' bi želyibe' ná'gake' zan chi'i kan žónteze žóngake', bi be žáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kate' bi da' žjé'wgake' ḻawe' ya'a, na' žežíngake' lížgake', cha' bi želyibe' da' ka' kan žónteze žóngake', bi be žáwgake'. Da' zanže da' ka' žóngake', da' žónteze žóngake', kan želyibe' ẕiga' ye'n ka', na' ẕiga' ya ka', na' da' ka' žáta'gekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Che ḻen benne' yodo' fariseo ka' ḻen benne' yodo' wsedle ka' wnnábgekle' Jesusen', na' wnnágake': —¿Bi žongak benne' wsedle chio' ka' kan bénteze bengak x̱a x̱to'žo ka', san žáwgake' yet, bi zej nak chawe' ná'gake'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bechebe Jesusen', na' gože' ḻégake': —Ḻe'e, benne' ẕḻoé'ezele chawe' kwinle. Nak da' li dan' bzoj Isaías, bennen' bchaḻje' ḻo wláz Dios, kan nak chele. Bzoje' da' ẕnnan: Benách ki, ḻen žoá'agakze' žápegake' x̱tiža'a ba la'ne, kege dot ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dáche'ze nak kan ẕka'n ẕéngake' neda' dan' žsédgekle' da' ẕnnázegak benách ka', kege da' wnnikza' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ki naken, dan' ẕzoale cheḻa'ale da' wnná Dios, na' žonle da' ka' nzi'le ḻo na'gak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ḻezka' gože' ḻégake': —Da' li ẕka'nle ka'ze dan' wnnakze Dios nich gonle kan zej nak da' ka' žónteze žonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ki wnná Dios ḻo na' Moisés: “Wdape ba la'ne x̱a x̱no'o.” Ḻezka' wnné': “Nóte'teze benne' nne zi'e che x̱a x̱ne'e, le got bennen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","San ḻe'e ẕnnale ki: “Cha' no benne' yi'e x̱e' o x̱ne'e: bi gak bi da' wneẕjwa' chele, dan' naken Korbán” (dan' ẕnnan ḻen diža' x̱iža': dan' ba bchebe laza'a wneẕjwan' che Dios), ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","naž ẕnnale: “Bi žon byenen bi da' gon bennen' chegak x̱a x̱ne'e.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ki naken, ẕzoale cheḻa'ale x̱tiža' Dios nich gonle dan' žónteze žonle, da' ka' ẕdele ḻo na'gak ẕi'n ẕa'sóle ka'. Zanže da' ki žonle. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naž Jesusen' bḻiže' benne' zan ka' nníta'gake' ga na', na' gože' ḻégake': —Le wzé nag da' nnia', yógo'tele, na' le chejni'ilen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bi be de da' žazen ḻo benne' da' gak gonen ga bi nake' chawe' ḻaw Dios, san da' žežojen ḻe', da' ni gak gonen ga bi nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cha' zoa nagle, na' cha' žénlele, le wzé nag. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kate' Jesusen' beḻá'aḻene' benne' zan ka', wyoé'e to yo'o, na' benne' wsedle chie' ka' wnnábgekle' Ḻe' kan nak dan' bsaka' ḻebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Naž Jesusen' gože' ḻégake': —¿Ḻezka' žiažje yeḻa' žejní'il cheḻe? ¿Bi žejní'ilele? Yógo'te da' žazen ḻo benne', bi gak gonen ga bi nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ki naken dan' bi žazen ḻo yichj ḻáẕda'we', san ḻe'ze' žazen, na' žežojen ḻi'e. Kate' wnná Jesusen' da' ni, bḻoe'ele' žo'o zej nak chawe' yógo'te da' že'j žawžo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ḻezka' wnná Jesusen': —Da' žežojen ḻo benne' žonen ga bi nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ki naken, dan' ḻo yichj ḻáẕdo'gak benne' ka' želžój da' kegle ka' da' ẕza' ḻáže'gake'. Che ḻen: Žóngake' doḻa' ka' da' zej naken sban. Ẕbángake', na' žótgake' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Žóngake' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. Ẕze ḻáže'gake' da' de che ljéžgake' ka'. Žóngake' da' kegle ka', na' žon ḻáže'gake'. Ẕgé'egekle' ljéžgake' ka', na' ẕnnégake' chégake'. Ẕka'n ẕen kwíngake', na' žon yáḻzegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yógo'te da' kegle ki želžojen ḻo yichj ḻáẕdo'w no benne', na' žóngaken ga bi nake' chawe' ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Naž Jesusen' bezé'e ga na', na' bžine' gawze gan zej že' yež Tiro, na' yež Sidón. Wyoé'e to yo'o ga na', na' gónele' bi nnezlen nitó benne', san bi gok wkache' kwine'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","To no'le, zoa to x̱kwide' no'le chie', na' yo'obe' be' x̱iwe', benle' ba bḻa' Jesusen' ga na', na' ḻa' wyejtie' gan zoe', na' bzoa ẕibe' ḻawe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","No'len' bi nake' benne' judío, san nbabe' benách Sirofenisia ka'. Góta'yoele' Jesusen' yebeje' be' x̱iwen' yo'o x̱kwide' no'le chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Naž Jesusen' gože' ḻe', na' wnné': —Benn latje yéḻjegekle zgá'alegak benne' ka' zej nake' ka ẕi'n x̱an yo'o, dan' bi naken chawe' yeka'žo yet chegak x̱kwide' ka', na' cho'nžon ḻawgak béko'do' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bechebe no'len', na' gože' Jesusen': —O', X̱an, san béko'do' ka', bia nníta'gakba' ẕanle gan žáwgakbe', žáwgakba' da' bižjw ka' da' žéx̱jwgaken ẕanle gan žáwgakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naž Jesusen' gože' ḻe', na' wnné': —Dan' wnnó' ki, gak yeyejo'. Ba bežój be' x̱iwen' wyó'o x̱kwide' no'le chion'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kate' no'len' bežine' liže', bḻe'ele' x̱kwide' no'le chien', debe' ḻo da'a, na' ba bežój be' x̱iwen' wyo'obe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bežój Jesusen' latjen' da' nbaben yež Tiro, na' wdíe' gan nbab yež Sidón, na' yež Dekápolis ka', na' bžine' žoa'a nisdo' che gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Benne' ka' nníta'gake' ga na' bedjwá'gake' to benne' kwežw gan zoa Jesusen', benne' bi žak nnie', na' góta'yoegekle' Ḻe' x̱oa ne'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Naž Jesusen' bebeje' bennen' cheḻa'ale ladjw benne' zan ka', na' bni'e x̱ben ne'e yežw nag bennen'. Bže'e ẕéne'do', na' wdane' lože'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naž bwie' ya'abale, na' bka'ḻe'e chi'e, na' wnné': —Efata. Diža' hebreo ni ẕnnan ḻen diža' x̱iža': “Beyaljw.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ḻa' beyáljwte nage', na' ḻa' beyitjte lože'e, na' wnnetie' binlo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Naž Jesusen' gože' ḻégake' bi wzéngeklen' nitó benne', san kan bchí'ižele' ḻégake', bzéžegake' diža' che dan' žone'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bebán ḻáže'gake', na' wnnágake': —Cháwe'do' žone' yógo'te. Žone' ga žeyéngekle benne' ka' gókgake' kwežw, na' žechaḻjgak benne' ka' bi gok nnégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kate' ža na' bedobgak benne' zan gan zoa Jesusen'. Dan' bi be de da' gáwgake', Jesusen' bḻiže' benne' wsedle chie' ka', na' bcháḻjḻene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Gože' ḻégake': —Žeyache' ḻáže'la' benne' zan ki dan' ba zej chonne ža nníta'ḻengake' neda' nga, na' bi be de da' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cha' yeseḻa'a ḻégake' lížgake' želdonze' ka', yedó ḻáže'gake' ḻo nez, dan' za'gak baḻe' zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Beži'igak benne' wsedle chie' ka', na' belyi'e Ḻe': —¿Biẕ wawžo benne' zanḻe'e ki ga ni nak latje dach? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naž Jesusen' wnnable' ḻégake', na' wnné': —¿Baḻ yet x̱til de chele? Belyi'e Ḻe': —Gážeze. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Naž Jesusen' gože' benne' zan ka' kwé'gake' ḻo yo. Bex̱we' gaže yet x̱til ka', na' gože' Dios: “Žóx̱keno'”. Naž bzoẕjen', na' bi'en chegak benne' wsedle chie' ka' nich chísgaken' ḻawgak benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ḻezka' gota' chégake' chope chonne bel ka'. Naž Jesusen' gože' Dios: “Žóx̱keno'” na' gože' ḻégake' chísgake'-ba' ḻawgak benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bdawgak yógo'te benne' ka', na' béljegekle'. Naž betóbgake' da' bižjw ka' da' begá'ngaken, na' beschá'gake' gaže x̱kwite ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Benne' ka' bdáwgake' zej nyángake' ka tape mile'. Wdé na' Jesusen' beseḻe'e ḻégake' lížgake', ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na' bejžene' ḻo barkw tẕen ḻen benne' wsedle chie' ka', na' bžíngake' gan nbab yež Dalmanuta. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Naž benne' yodo' fariseo ka' wbíga'gake' gan zoa Jesusen', na' wzó ḻáwgake' ẕdiḻ díža'gake' ḻen Ḻe'. Gónegekle' wžíx̱gake' Jesusen'. Che ḻen wnnábgekle' Ḻe' gone' to da' gak bian' da' zan' ya'abá che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bka'ḻe'e chi'i Jesusen', na' wnné': —Želnnable benne' ki neda' gona' to da' gak bian' da' zan' ya'abá che Dios. Da' li žapa' ḻe'e, bi ḻé'elele nitó da' gak bian' da' zan' ya'abá che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Naž bezé'e gan zej nnita' benne' ka', na' bejžene' ḻaw barkw, na' wyeje' yecheḻá'a nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Goḻ ḻáže'gak benne' wsedle ka' che Jesusen' wá'gake' da' gáwgake', na' toze yet x̱til den ḻo barkwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Naž bchi'le Jesusen' ḻégake', na' wnné': —Le wia binlo. Le gape chi'i kwinle nich bi si'le da' naken ka kwa zichj che yet x̱til chegak benne' yodo' fariseo ka', na' che Herodes. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wzó ḻawgak benne' wsedle chie' ka' ẕcháḻjḻengake' ljéžgake' ka', na' wnnágake': —Ẕnne' ki dan' bi de yet x̱til da' gawžo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Žákbe'ele Jesusen' dan' ẕnnágake', na' gože' ḻégake': —¿Biẕ chen' ẕnnale naken dan' bi de yet x̱til da' gawžo? ¿Bi žejní'ilele, na' bi žákbe'elele? ¿Nak zide yichj ḻáẕdo'le? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Žia yej ḻawle san bi ẕḻé'elele, na' žia yid nagle san bi žénlele? ¿Bi žejsá' ḻáže'le? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Katen' bzoẕja' gayo' yet x̱til ka', da' ka' bdawgak gayo' mil benne' ka', ¿baḻ x̱kwite ka' bescha'le da' bižjw ka', da' ka' betoble? Wnnágake': —Chežinno. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ḻezka' wnná Jesusen': —Katen' bzoẕja' gaže yet x̱til ka', da' ka' bdawgak tape mil benne' ka', ¿baḻ x̱kwite ka' bescha'le da' bižjw ka', da' ka' betoble? Wnnágake': —Gaže. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Naž Jesusen' gože' ḻégake': —¿Bi žejní'ilele na'a, bchaḻja' che da' žsédgekle benne' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kate' bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻo yež Betsaida, bḻa'gak baḻe benne' gan zoe', nwá'gake' to benne' ḻo choḻe ga na', na' góta'yoegekle' Ḻe' kane' bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesusen' bex̱we' na' benne' ḻo choḻen', na' bchi'e ḻe' na'le žoa'a yežen'. Naž bžie' ẕene' yej ḻawe', na' bx̱oa ne'e ḻe'. Naž wnnable' ḻe', na' wnné': —¿Ẕḻe'elo' late'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bennen' goke' ḻo choḻe bwie', na' wnné': —Ẕḻe'ela' benách ka', na' ẕnná'gake' ka yag ka', san želdá benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Da' yoble Jesusen' bx̱oa ne'e yej ḻawe', na' bwia bennen' goke' ḻo choḻe, na' ba beyakte cháwe'do' yej ḻawe'. Na'a ẕḻe'ele' binlo yógo'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Naž Jesusen' beseḻe'e ḻe' liže', na' wnné': —Bi chejo' ḻawe' yež, na' bi wzenlo' no benne' ḻo yežen' dan' bena'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wdé na' bezá' Jesusen' ḻen benne' wsedle chie' ka' ga na', na' wdégake' yeždo' ka' zej nbaben yež Sesarea, gan ẕnna bia' Filipo. Kate' ne yó'ogake' nez, Jesusen' wnnable' benne' wsedle chie' ka', na' wnné': —¿No benne' ẕnnagak benách ka' naka' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bechébegake', na' wnnágake': —Ẕnnagak baḻe benne' nako' Ẕwa, bennen' bezóe' benách ka' nis. Ẕnnágake' yebaḻe' nako' Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te. Ẕnnágake' yebaḻe' nako' yetó benne' bchaḻje' ḻo wláz Dios ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naž Jesusen' wnnable' ḻégake', na' wnné': —¿Chiẕe ḻe'e, no benne' ẕnnale naka' neda'? Bechebe Bedw, na' wnné': —Le' nako' Benne' Criston', bennen' bchebe ḻaže' Dios seḻe'e nga. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Naž Jesusen' bchi'le ḻégake' bi wzéngekle' nitó benne' no nake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Naž wzó ḻaw Jesusen' ẕzejni'ile' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —Žon byenen sáka'ḻi'a neda', Benne' Golje' Benách. Benne' gole ka', na' bx̱oz wnná bia' ka' ḻen benne' yodo' wsedle ka' wzóagake' neda' cheḻa'ale. Gótgake' neda', san kate' gak chonne ža yebana'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kwáselo bcháḻjḻene' ḻégake'. Naž Bedw bchi'e Jesusen' cheḻa'ale, na' wzó ḻawe' ẕdiḻe' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Byechj Jesusen', na' bwie' yezika' benne' wsedle chie' ka', na' bdiḻe' Bedon', na' wnné': —Bkwas kwita' nga. Nako' ka da' x̱iwe'. Da' ẕza' ḻažo'o bi naken che Dios, san kan ẕza' ḻáže'gak benách ka' naken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naž Jesusen' bḻiže' benne' wsedle chie' ka' ḻen benne' ka' nníta'gake' ga na', na' gože' ḻégake': —Cha' žénele no benne' gónḻene' neda' tẕen, žaḻa' wzóe' cheḻa'ale da' žénekzele', na' gake' ka to benne' noe'e yag kroze chie' nich chejté'e ḻe'e yag krozen', na' naž gak gónḻene' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","No benne' že' ḻaže'e yeḻa' nban chie', wniten', san bennen' wnite' yeḻa' nban chie' dan' žónḻene' neda' tẕen, o dan' nzi' ḻo ne'e diža' chawe' chian', gata' yeḻa' nban da' zejlí kanne chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Biẕ da' chawe' gata' che to benne' cha' wtobe' yógo'te da' že' yežlyó nga, san wnít kwine'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bi be gak wneẕjw to benne' nich yeslá kwine'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cha' no benne' žedoe'ele' chia' neda', na' che x̱tiža'a ḻawgak benách ki, benne' ka' ẕbej yíchjgake' Dios, na' žóngake' doḻa', ḻezka' neda', Benne' Golje' Benách, yedoe'ela' che bennen' kate' yeḻá'a ḻen yeḻa' baní' che X̱a', na' gónḻengak wbás che ya'abá ka' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesusen' bcháḻjḻene' benne' ka' žónḻengake' Ḻe' tẕen, na' wnné': —Da' li žapa' ḻe'e, zej nnita' benne' ka' nga, benne' bi gátgake' kate' ḻé'ežegekle' ža yedjnná bia' Dios yežlyó nga, na' ḻa' ḻaw yeḻa' wnná bia' ẕen chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kate' ba wdé x̱ope ža, Jesusen' bchi'e Bedw ḻen Jakob, na' Ẕwa, na' ḻégakze' jake' to ḻaw ya'a sibe, gan bcha' kan ẕnna' ḻaw Jesusen' ḻawgak yonne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wyép yes baní' laže' da' nakw Jesusen', na' goken chícheḻe'e. Ẕíla'do'ze goken, na' no benne' žibe' laže' yežlyó nga, bi gak gone' laže' ẕíla'do'ze kan gok ẕen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bḻa' ḻawgak Lías, na' Moisés gan nníta'gake', ẕcháḻjḻengake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Naž Bedon' gože' Jesusen': —Benne' wsedle, ba nez ẕen naken chežo zoažo nga. Gona' chonne yo'o laga' nga, to chio', na' yetó che Moisés, na' yetó che Lías. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ki wnná Bedon' dan' bi nnezle' dan' ẕnne'. Ka' goken dan' ẕžébegak benne' wsedle ka' che Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naž wžé' to bejw da' wló'on ẕoḻ ḻégake', na' benle chi'i to benne' ẕchaḻje' ḻo bejw na', na' wnné': —Benne' ni nake' Ẕi'na'. Nži'ila' Ḻe'. Le wzé nag chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ḻa' bwíategake' san biž no benne' bḻé'egekle'. Toze Jesusen' zóaḻene' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kate' ne yó'ogake' nez, žétjgake' ḻaw ya'a siben', Jesusen' bchi'le' ḻégake' bi wzéngekle' no benne' kan gok dan' bḻé'egeklen', kate' yebanže' Ḻe', Benne' Golje' Benách, ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Che ḻen bzoa chóchzegake' dan' wnné' ḻo yichj ḻáẕdo'gake', na' ḻa' ḻégakze' belnnable' ljéžgake' biẕ zejḻás dan' wnné' kate' wnné' yebane' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wnnábgekle' Jesusen', na' wnnágake': —¿Biẕ chen' ẕnnagak benne' yodo' wsedle ka' žon byenen ḻa' Lías zga'ale' kate' ḻa' Benne' Criston'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bechebe Jesusen', na' wnné': —Da' li ḻa' Líasen' zga'ale', na' yecá'n chawe'e yógo'te kan žaḻa' gákgaken. Na'a, ¿biẕ chen' nyejw ḻe'e yiche la'y da' ẕnna žon byenen Benne' Golje' Benách sáka'ḻi'e, na' wzoagak benách ka' Ḻe' cheḻa'ale? ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Žapa' ḻe'e: ba bḻa' Líasen', na' béngake' chie' kan gónegekle', kan nyejw ḻe'e yiche la'y kan žaḻa' gaken chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kate' bežín Jesusen' ḻen benne' ka' nníta'ḻengake' Ḻe' tẕen gan zej nnita' yezíka'gak benne' wsedle chie' ka', bḻé'egekle' zej nnita' benne' zan ga na', na' benne' yodo' wsedle ka' želdíḻ diže'e ḻen benne' wsedle chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kate' benne' zan ka' bḻé'egekle' Jesusen', bebángekle', na' taríaze wzá'gake' gan zi'e, na' wdápegake' Ḻe': “Padiox̱.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Naž Jesusen' wnnable' benne' wsedle chie' ka', na' wnné': —¿Biẕ dan' ẕdíḻ-ḻenle ḻégake'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bechebe to benne' zoe' ladjw benne' zan ka', na' wnné': —Benne' wsedle, bedjwá'a x̱kwide' byodo' chia' chio' Le', dan' yo'obe' be' x̱iwe' da' žonen ga bi ẕnnabe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kate' žo'o be' x̱iwen' ḻebe', ẕžix̱ ẕḻolen ḻebe' ḻo yo, na' ẕbia bžina' zide' žoa'abe', na' žẕej láye'be'. Che ḻen zej ẕžitbe'. Wnnabla' benne' wsedle chio' ka' yebéjgake' be' x̱iwen', san bi wẕáke'gekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bechebe Jesusen', na' wnné': —Ḻe'e, benne' bi žejḻe'le che Dios. ¿Gáka'x̱tekze gon byenen sóaḻena' ḻe'e? ¿Gáka'x̱tekze gon byenen gaka' ẕen ḻaže' ḻen ḻe'e? Le yedjwá'-be' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Zá'gake' zej noe'e-be' gan zoa Jesusen'. Kate' be' x̱iwen' bḻe'elen Ḻe', ḻa' bx̱izten ḻebe'. Wže'be' ḻo yo, na' bžix̱ bḻolen ḻebe', na' wžía bžina' zide' žoa'abe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Naž Jesusen' wnnable' x̱a x̱kwiden', na' wnné': —¿Gáka'x̱te ba goken žaken ki chebe'? Wnná x̱aben': —Na' náktebe' x̱kwíde'do' žak ki chebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zan chi'i ẕžen' ḻebe' ḻo yi', na' ẕan nis nich goten ḻebe'. Che ḻen, cha' žako' late', beyache' ḻaže'l neto', na' gokḻen neto'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesusen' gože' ḻe': —Cha' gak chejḻi'o che Dios, yógo'te waken cha' chejḻi'o chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ḻa' wnnete zižje x̱a x̱kwiden', na' wnné': —Žejḻi'a chie'. Gokḻen neda' nich chejḻe'ža' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kate' bḻe'el Jesusen' za'gak benne' zan ka', ẕchígake' Ḻe', gože' be' x̱iwen', na' wnné': —Le', be' x̱iwe', be' žonen ga bi ẕnnagak, na' bi žéngekle benách ka', na'a ẕchi'la' le' yežojo' ḻo x̱kwiden', na' biž chazo' ḻebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wžéžeya'a be' x̱iwen', na' bžix̱ bḻol-ḻe'en ḻebe'. Naž ḻa' bežojten, na' bka'nen ḻebe' ka to x̱kwide' gat. Ka' goken, bchaḻjgak benne' zan ka', na' wnnágake': —Ba natbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naž Jesusen' bex̱we' na'be', na' bechise'-be', na' beyás x̱kwiden'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Naž wyó'o Jesusen' to yo'o, na' ḻa' ḻégakze benne' wsedle chie' ka' wnnábgekle' Ḻe', na' wnnágake': —¿Biẕ chen' bi gok yebejto' neto' be' x̱iwen'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesusen' gože' ḻégake': —Bi gak yebejle ka'ze be' x̱iwe' ki, san toze cha' wcháḻjḻenle Dios, na' gonle wbás. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kate' bezá' Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ga na', wdégake' gan nbab Galilea. Gónele Jesusen' bi nnezle no benne' gan zoe', ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dan' žsedle' benne' wsedle chie' ka'. Gože' ḻégake': —Wdégake' neda', Benne' Golje' Benách, ḻo na'gak benne' ka' gótgake' neda', san te gata', kate' tegak chonne ža, yebana'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bi bejní'igekle' da' ni da' gože' ḻégake', na' dan' ẕžébegake', bi be wnnábgekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Naž bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻo yež Kapernaum, na' kate' ne nníta'gake' to yo'o, Jesusen' wnnable' ḻégake', na' wnné': —¿Biẕ dan' wdíḻ-ḻenle lježle kate' ne yo'ole nez? ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Naž ḻégake' wnníta'gake' žize dan' wdíḻ-ḻengake' ljéžgake' ḻo nezen' cha' nólgake' gake' benne' blo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Naž wžé' Jesusen', na' bḻiže' chežínnote benne' wsedle chie' ka', na' gože' ḻégake': —No benne' žénele' gake' benne' blo ládjwle ḻe'e žaḻa' gake' ka to benne' kwíde'ze, na' ḻezka' žaḻa' gake' ka ni'a na'le yógo'tele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naž Jesusen' bex̱we' to x̱kwide', na' bzoe'-be' gachje ḻáwe'le gan nníta'gake'. Wdeḻe'e-be', na' gože' ḻégake': ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—No benne' si' ḻo ne'e to x̱kwide' ki dan' nakbe' chia', ḻezka' si' ḻo ne'e neda', na' no benne' si' ḻo ne'e neda', kege nedza' si' ḻo ne'e, san ḻezka' si' ḻo ne'e X̱a', Bennen' bseḻe'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Naž Ẕwa gože' Jesusen': —Benne' wsedle, bḻe'elto' to benne' žebeje' be' x̱iwe' ka' yo'ogak benne' ka', na' ẕkonle' žin lo'. Bchi'leto'-ne' biž gonen', dan' bi žónḻene' žo'o tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Naž Jesusen' gože' ḻe': —Bi wchí'lele-ne', dan' cha' zoa no benne' žone' to yeḻa' wak da' zan' ya'abá che Dios, na' ẕkonle' žin la', bi gak nne zi'e chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ki naken, no benne' bi ẕži'e chežo, žakḻen bennen' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No benne' wneẕjwe' chele to ẕíga'do' nis da' ye'jle dan' žónḻenle neda', Benne' Criston', tẕen, si'kze' da' žeyaḻa' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ḻezka' wnná Jesusen': —No benne' gone' ga gon to x̱kwide' ki doḻa', x̱kwiden' žejḻe'be' chia', gakže chawe' che bennen' cha' wcheje' to yiche žotw yene', na' chejžó'n kwine' ḻo nisdo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Cha' to no'o gonen ga gono' doḻa', bchogen'. Gakže chawe' chio' chejo' gan so' nbano' zoa toze no'o, kege zoa chope no'o, na' chejchó'o ḻo yi' gabíl, gan bi yoḻe yi' chen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ḻo latjen' bi gatgak bzoga' ka' yo'ogak benne' gat ka', benne' ka' chejnníta'gake' ga na', na' yin' bi yoḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ḻezka', cha' to ni'o gonen ga gono' doḻa', bchogen'. Gakže chawe' chio', chejo' gan so' nbano' zoa toze ni'o, kege zoa chope ni'o, na' chejchó'o ḻo yi' gabilen', gan bi yoḻe yi' chen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ḻo latjen' bi gatgak bzoga' ka' yo'ogak benne' gat ka', benne' ka' chejnníta'gake' ga na', na' yin' bi yoḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ḻezka' cha' to yej ḻawo' gonen ga gono' doḻa', wlejen. Gakže chawe' chio' chejo' gan ẕnna bia' Dios zoa toze yej ḻawo', kege zoa chope yej ḻawo', na' chejchó'o ḻo yi' gabilen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ḻo latjen' bi gatgak bzoga' ka' yo'ogak benne' gat ka', benne' ka' chejnníta'gake' ga na', na' yin' bi yoḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Nich gape chi'ižo beḻa' ẕwázježon zede', na' ẕgála'žon žoa'a yi', nich bi kwia yin', na' ẕwázjegake' zede' yógo'te biado' ka' ẕzéygake'-ba' ḻo bkog la'y che Dios. Da' ni žsedlen žo'o kan ga'ngak chawe' yógo'te benách chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nak chawe' zede', san cha' yenít yeḻa' sna'a chen, ¿nakx̱ gak yeyonžon sna'a? Le gak ḻa' ḻé'ezele ka zede' chawe', na' bga'n cháwe'do' tole ḻen yetole. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bezá' Jesusen' ḻo yež Kapernaum, na' wyeje' gan nbab Judea, na' wdíe' yecheḻá'a yego Jordán zaka' gan ẕḻa' wbíž, ga na' bedobgak benne' zan gan zoe' da' yoble, na' bsedle' ḻégake' da' yoble kan žónteze žone'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Naž bžingak benne' yodo' fariseo ka' gan zoa Jesusen', na' gónegekle' góngake' ga bi da' nna Jesusen' nich gak yesbága'gake' Ḻe' ẕia. Wnnábgekle' Ḻe', na' wnnágake': —¿De latje no benne' byo, benne' nžag ne'e, wsane' ẕo'le'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bechebe Jesusen', na' wnné': —¿Biẕ bchi'le Moisés ḻe'e? ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wnnágake': —Moisés bneẕjwe' latje no benne' byo wzoje' to yiche da' ẕnnan ẕḻá'aḻene' ẕo'le', na' naž gak wsane' ẕo'ḻen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bechebe Jesusen', na' wnné': —Moisés bchi'le' ḻe'e da' ni dan' nak zide yichj ḻáẕdo'le, ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","san kate' wzó ḻaw žata' yežlyó nga, Dios bene' ḻégake' benne' byo, na' no'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wnné': “Che ḻen wká'n benne' byo x̱a x̱ne'e, na' chejgá'nḻene' ẕo'le', ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na' chope' yeyákgake' ka toze benne'.” Che ḻen biž zej nake' chope' san toze' ba zej nake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ḻezka', no benne' nake' benachze bi žaḻa' wḻé'e benne' ka' ba ben Dios ḻégake' toze. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kate' Jesusen' beyoé'e yo'o, benne' wsedle chie' ka' wnnábgekle' Ḻe' kwáselo kan nak dan' bchaḻje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesusen' gože' ḻégake': —Cha' to benne' byo ẕḻá'aḻene' ẕo'le', na' ẕchag ná'ḻene' to no'le yoble, žone' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na', na' žesbage'e ẕo'le' doḻa', no'len' zóaḻene' na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ḻezka' cha' to no'le wsane' benne' byo chie', na' si'e to benne' byo yoble, ḻezka' gone' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Naž bžingak benne' ka' zej noe'e x̱kwide' ka' chégake' gan zoa Jesusen', na' žénegekle' x̱oa ne'e ḻégakbe', san wzó ḻawgak benne' wsedle chie' ka' ẕdíḻgake' benne' ka' zej noe'e ḻégakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kate' Jesusen' bḻe'ele' da' ni, bže'e, na' gože' ḻégake': —Le we' latje x̱kwide' ki yídgakbe' chia'. Bi wséjwle x̱nézgakbe', dan' gata' chegak benne' ka' zej nake' ka x̱kwide' ki latje gan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da' li žapa' ḻe'e: no benne' bi si' ḻo ne'e da' ẕnna bia' Dios kan žon to x̱kwide' ki, bi cho'o bennen' gan ẕnna bi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naž Jesusen' wdeḻe'e x̱kwide' ka', na' bx̱oa ne'e ḻégakbe', na' bḻiž chawe'e ḻégakbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kate' Jesusen' beyoé'e nez, taríaze bžin to benne' ga na'. Bzoa ẕibe' ḻawe', na' wnnable' Ḻe', na' wnné': —Benne' wsedle, dot chawe', ¿biẕ žaḻa' gona' nich gata' yeḻa' nban da' zejlí kanne chia'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusen' wnnable' ḻe', na' wnné': —¿Biẕ chen' ži'o neda', ẕnno': dot chawe'? Bi zoa nitó benne' nake' dot chawe'. Toze Dios nake' dot chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ba nnézkzelo' da' ka' bchi'le Dios. Wnné': Bi gono' doḻa' da' ẕka'n ditjen yeḻa' ẕchag na'. Bi goto' benách ka'. Bi kwano'. Bi nnio' che lježo' da' wen ḻaže'. Bi be kwéjlano'. Wdape ba la'ne x̱a x̱no'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bechebe bennen', na' gože' Jesusen': —Benne' wsedle, yógo'te da' ki žónteza' kate' naktia' x̱kwide'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesusen' bwie' ḻe' ḻen yeḻa' nži'il chie', na' wnné': —To da' žiažjen chio'. Wyéj, yjete' yógo'te da' de chio', na' bneẕjw da' yezi'o chegak benne' yache' ka', na' gata' yeḻa' wnni'a chio' ya'abá che Dios. Naž wak yežino' chia', na' gako' ka to benne' noe'e yag kroze chie', na' zejté'e ḻe'e yag krozen', na' ki gónḻeno' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kate' benle' diža' ni, gokle', na' zeyeje'. Gok nyache' ḻaže'e dan' deḻe'e yeḻa' wnni'a chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Naž bwia Jesusen' dot kwite', na' gože' benne' wsedle chie' ka': —Zedḻe'e gaken cho'ogak benne' ka' de yeḻa' wnni'a chégake' gan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bebán ḻáže'gak benne' wsedle chie' ka' kan nak x̱tiže'e, na' da' yoble Jesusen' gože' ḻégake': —Ḻe'e, ẕí'na'do' ka', zedḻe'e gaken chegak benne' ka' že' ḻáže'gake' yeḻa' wnni'a chégake' chó'ogake' gan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gakže zede cho'o no benne' de yeḻa' wnni'a chie' gan ẕnna bia' Dios, ka te to bia nwa'ba' ywa' ḻo nag yeche'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kate' béngekle' da' ni, bebánḻe'egekle', na' wnnágake' ḻa' ḻégakze': —¿Noẕkze benne' gak yelé', cha'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bwia Jesusen' ḻégake', na' wnné': —Bi gak gon no benne' da' ni, san gak Dios, dan' ẕzáka'le Dios yógo'te. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naž Bedw gože' Ḻe': —X̱an, neto' ba bka'nto' yógo'te, na' žónḻento' Le' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Bechebe Jesusen', na' wnné': —Da' li žapa' ḻe'e, no benne' wka'ne' liže', o biche'e ka', o zane' ka', o x̱e', o x̱ne'e, o ẕo'le', o ẕi'ne' ka', o yežlyó chie', dan' žone' x̱china', o dan' ẕzenle' benách ka' diža' chawe' chian', ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bennen' yezi'e yetó gaywá'teže ka' ža ni zoažo na'a, liže' ka', na' biche'e ka', na' zane' ka', na' x̱ne'e ka', na' ẕi'ne' ka', na' yežlyó chie' ka', tẕen ḻen da' kwia ḻáže'gak benách ka' ḻe', na' ḻo yežlyó da' za' gata' yeḻa' nban da' zejlí kanne chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Benne' zan, benne' zej nake' blo na'a, wéx̱jwgake' ga na', san benne' ka' zej nake' gax̱jw na'a, gákgake' benne' blo ka' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kate' ne yó'ogake' nez, želbene' zjake' ḻo yež Jerusalén, zej Jesusen' ḻawgak benne' wsedle chie' ka'. Nítgekle', na' ḻo yeḻa' žẕize zjákḻene' Ḻe'. Da' yoble Jesusen' bchi'e benne' chežinno ka' cheze. Wzó ḻawe' ẕchájḻene' ḻégake' ka nak da' žaḻa' gaken chie', ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","na' wnné': —Ẕḻé'ekzelele ẕbenžo, zejžo ḻo yež Jerusalén gan soa to benne' wdíe' neda', Benne' Golje' Benách, ḻo na'gak bx̱oz wnná bia' ka', na' ḻo na'gak benne' yodo' wsedle ka'. Chóggake' chia' gata', na' wdégake' neda' ḻo na'gak benne' zi'to' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gon dítjgekle benne' ka' neda', na' gónḻe'egake' neda' zi'. Wžé'egake' neda' ẕene'. Naž gótgake' neda', san kate' gak chonne ža, yebana' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naž Jakob ḻen Ẕwa, benne' ka' zej nake' ẕi'n Sebedeo, wbíga'gake' ḻaw Jesusen', na' belyi'e Ḻe': —Benne' wsedle, žénelto' gono' cheto' da' nnablto' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesusen' gože' ḻégake': —¿Biẕ žénelele gona' chele? ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Naž belyi'e Ḻe': —Kate' žin ža kwi'o gan nna bi'o, ben ga kwe'to' toto' kwito' ḻi ža, na' yetoto' kwito' yegle. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naž Jesusen' gože' ḻégake': —Bi nnézlele da' ẕnnable. ¿Gak si'le' da' žaḻa' si'a neda', da' naken da' sáka'ḻi'a? ¿Gak yezoale nis kan yezóa' neda' nis ḻo yeḻa' got? ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bechébegake', na' wnnágake': —Gakto'. Jesusen' gože' ḻégake': —Da' li, da' saka'a neda', ḻezka' gaken chele, na' kan yezóa' neda' nis, ḻezka' yezoale ḻe'e nis, ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","san bi nzi' ḻo na'a kwia' no benne' kwi'e kwita' ḻi ža, na' no benne' kwi'e kwita' yegle. Dios wneẕjwe' chegak benne' ka' ba bkweze' chégake' latje ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kate' yechí benne' wsedle chie' ka' béngekle' da' ni, bžá'agake' Jakob na', na' Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Naž Jesusen' bḻiže' ḻégake', na' wnné': —Nnézkzelele kan žongak benne' ka' ẕnna biá'gake' yež ka', kan ẕkóngekle' benne' ka' žin, na' benne' ka' zej nake' blo ládjwgake' ẕnna biá'gake' ljéžgake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bi gak chele ki, san no benne' yénele' gake' ẕen gan zoale, žaḻa' gone' x̱chinle yezíka'le, ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na' no benne' ládjwle, benne' yénele' gake' benne' blo, žaḻa' gake' ka to benne' ndo'w chele yógo'tele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ki žaḻa' gonle dan' bḻa'a neda', Benne' Golje' Benách, kege nich gon no benne' x̱china', san nich gona' x̱chingak benách ka', na' nich wdía' yeḻa' nban chia', nich yeya'wa' benne' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naž bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻo yež Jerikó. Kate' ne žežój Jesusen' ḻo yežen', benne' wsedle chie' ka' zjákḻene' Ḻe', tẕen ḻen benne' zanže ka'. Žoa'a nezen' že' to benne' ḻo choḻe, bennen' lie' Bartimeo, ẕi'n Timeo. Ẕnnable' no benne' bi da' gonnze' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kate' benle Bartimeon' ẕde Jesús, benne' Nasaret, ga na', wzó ḻawe' ẕnnie' zižje, na' wnné': —Jesús, Ẕa'só Dabí. Beyache' ḻaže'l neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Benne' ka' želdíe' ga na' bdíḻgake' ḻe', na' belyi'e ḻe': —Wzóa ži. Naž zižjže wnníe', na' wnné': —Ẕa'só Dabí. Beyache' ḻaže'l neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Naž wzé žize Jesusen', ẕbeze', na' gože' benne' ka': —Le wḻiže'. Bḻížgake' benne' ḻo choḻen', na' belyi'e ḻe': —Ben choch ḻažo'o. Wyase. Ẕnnie' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Naž bsie' cheḻa'ale laže' nx̱oa yene'. Ḻa' wzó ẕá'tie', na' wbige'e ḻaw Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesusen' wnnable' ḻe', na' wnné': —¿Biẕ žénelo' gona' chio'? Bechebe benne' ḻo choḻen', na' wnné': —Benne' wsedle, žénela' gono' ga yeyák yej ḻawa'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusen' gože' ḻe': —Beyéj ližo'. Ba beyako' dan' žejḻi'o chia'. Ḻa' beyáljwte yej ḻawe', na' wyéjḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen, gawze gan že' yež Jerusalén, gan zej nnita' yež Betfagé, na' yež Betania, gan že' Ya'a Yag Olibo. Naž Jesusen' bseḻe'e chope benne' wsedle chie' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na' gože' ḻégake': —Le chej yeždo' da' žen' ḻawžo, na' kate' cho'ole ḻo yežen', chejx̱áka'le to burrodo' nžejba' ga na', na' bi na' kwia-ba' no benne'. Le sež-ba', na' le yedjwá'-ba' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Cha' no benne' bi da' yi'e ḻe'e dan' žonle ki, le yi'e: “X̱anžon' žénele'-ba', na' ḻa' yeséḻa'tie'-ba' chio'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naž jake', na' bejx̱áka'gake' búrrodon', nžejba' gan žo'ogak benách ka' ḻi'a to yo'o da' žen' žoa'a nez, na' bséžgake'-ba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Benne' ka' nníta'gake' ga na' belyi'e ḻégake': —¿Biẕ da' žonle? ¿Biẕ chen' ẕsežle búrrodon'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bechébegak benne' wsedle ka' che Jesusen', na' belyi'e ḻégake' kan ba gožkze Jesusen' ḻégake', na' benne' ka' bnéẕjwgake' ḻégake' latje. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Naž bché'gake' búrrodon' gan zoa Jesusen'. Bx̱óagake' laže' chégake' x̱kóže'ba', na' Jesusen' wžíe'-ba'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wnníta'gak benne' zan ga na', na' bchíljgake' laže' chégake' gan nak ḻo nez. Yebaḻe benne' ka' bdíchjgake' zin da' bx̱óagake' ḻo nezen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wzó ḻawgak ẕnnegak zižje benne' ka' zjake' ḻaw Jesusen', na' benne' ka' zá'gake' x̱kóže'le', na' wnnágake': —¡Ga'n ẕen Dios! ¡Dios gon chawe'e Benne' ze'e nga, Bennen' bseḻa' X̱anžo Dios Ḻe'! ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dios gon chawe'e Bennen' za' nna bi'e kan wnná bia' x̱a x̱to'žo Dabí! ¡Ga'n ẕen Dios! ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ka' goken, bžin Jesusen' ḻo yež Jerusalén, na' wyoé'e ḻa' ḻi'a yodo'. Kate' beyóž bwie' yógo'te da' zej den dot kwitle, bežoje' zaka' yež Betania dan' za' žaḻe, na' zjakḻen benne' wsedle chie' ka' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kate' za' ža'ní' yetó ža, na' zežój Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen, ḻo yež Betania, ẕdone'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Zí'to'le bḻe'ele' to yag higo da' žian x̱lage'. Wbige'e gan zoa yagen' cha' chejx̱ake'e late' da' ẕbian. Kate' bžine' ga na', bi be bejx̱ake'e da' ẕbian. X̱láge'ze žian dan' bi na' žin ža kwian. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naž bdiḻe Jesusen' yagen', na' wnné': —Biž gaw no benne' da' ẕbia chio'. Béngekle benne' wsedle chie' ka' da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kate' bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻo yež Jerusalén, wyoé'e ḻa' ḻi'a yodo', na' wzó ḻawe' ẕbeje' na'le benne' žote' ža'w ka' ḻa' ḻi'a yodo'. Bžix̱e' blag ka' chegak benne' ka' ẕchá'gake' mežw che yež zi'to' ka', na' ḻezka' da' ka' žé'gekle benne' ka' žóte'gake' plomdo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ḻezka' bi bi'e latje no benne' bi da' we'e, na' kege no benne' wzóe' nez ḻa' ḻi'a yodo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesusen' bsedle' benne' ka' nníta'gake' ga na', na' wnné': —Nyejw ḻe'e yiche la'y da' ẕnnan: “Liža' sin', yo'o gan benne' zá'gake' dot yežlyó nga wcháḻjḻengake' Dios.” Ḻe'e ba benlen kan nak ližgak benne' wbán ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kate' bx̱oz wnná bia' ka', na' benne' yodo' wsedle ka' béngekle' da' ni, naž wzó ḻáwgake' žíljgake' nakx̱ gótgake' Jesusen', san dan' ẕžébegake' benne' yež ka', bi be béngake' chie', dan' žebángekle yógo'te benne' ka' kan nak da' žsedle Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kate' za' žaḻe ža na', bežoje' ḻo yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kate' za' ža'ní' yetó ža, wdé Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen, gan že' yag higo dan' bdiḻe' Ḻe', na' bḻé'egeklen', ba nbižen dot lwen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naž bezá' ḻaže' Bedw dan' goken, na' gože' Jesusen': —Benne' wsedle, bwia nga. Yag higon' da' bdiḻon' neje, ba nbižen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bechebe Jesusen', na' gože' ḻégake': —Le chejḻé' che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Da' li žapa' ḻe'e, cha' no benne' yi'e ya'ado' ni: “Bkwas nga, na' bejsóa ḻo nisdo'” na' cha' bi gak chope ḻaže'e, san dot ḻaže'e chejḻi'e che Dios gone' kan wnné', na' gaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Che ḻen žapa' ḻe'e: yógo'te da' nnable kate' wcháḻjḻenle Dios, le chejḻé' che Dios ba benne' chele dan' ẕnnable, na' gonnen' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Katen' ẕcháḻjḻenle Dios, cha' zoa no benne' ẕža'le, bennen' zoa bi da' bene' chele, le yenít ḻaw che bennen', nich ḻezka' X̱ale, Bennen' zoe' ya'abá chie', yenít ḻawe' chele ḻe'e doḻa' da' nbága'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Cha' bi yenít ḻawle chegak benách ka', X̱ale, Bennen' zoe' ya'abá chie', bi yenít ḻawe' chele ḻe'e doḻa' da' nbága'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Naž beyéj Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻo yež Jerusalén. Kate' ne ẕda Jesusen' gan nak ḻo ẕchil yodo', bx̱oz wnná bia' ka' ḻen benne' yodo' wsedle ka', na' benne' gole ka', bžíngake' gan zoe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wnnábgekle' Jesusen', na' wnnágake': —¿Biẕ yeḻa' wnná bia' nzi' ḻo no'o žono' da' ki? ¿Noẕ benne' bdie' ḻo no'o yeḻa' wnná bian'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bechebe Jesusen', na' gože' ḻégake': —Ḻezka' neda' nnabla' ḻe'e to. Cha' yechébele chia', yapa' ḻe'e bi yeḻa' wnná bia' napa' žona' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Noẕ benne' bdie' ḻo na' Ẕwa bezóe' benách ka' nis? ¿Dios o to benne'? Le nne na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wzó ḻáwgake' žóngake' x̱tíža'gake' ḻa' ḻégakze', na' wnnágake': —Cha' nnažo Dios bseḻe'e ḻe', yi'e žo'o: “¿Biẕ chen' bi bejḻe'le chie'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Yé'ažo-ne', bséḻa'gak benne' ka' ḻe'? Ki bezá' ḻáže'gake' dan' ẕžébegake' benne' yež ka' nníta'gake' ga na', dan' žékgekle yógo'te benne' ka' bchaḻj Ẕwan' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Che ḻen belyi'e Jesusen': —Bi nnezlto'. Naž Jesusen' gože' ḻégake': —Ḻezka' neda' bi yapa' ḻe'e bi yeḻa' wnná bia' napa' žona' da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Naž wzó ḻaw Jesusen' ẕcháḻjḻene' benne' ka' žónḻengake' Ḻe' tẕen da' žsaka' ḻebe', na' wnné': —Wzóa to benne' beyaze' lba uba ka' gan nak ḻo yežlyó chie'. Bzoe' to le'je chen, na' bche'ne' to yežw yej gan wsíe' x̱is uba ka'. Bene' to yo'o gope gan nak ža'le gan wak to benne' wie' da' ka'. ’Naž bdie' yežlyó chien' ḻo na'gak benne' wen žin ka', nich sí'gake' gachje da' wneẕjwen, na' wyeje' yež zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kate' bžin ža wchíbgake' da' ẕbian, bseḻe'e to bi' wen žin chie' chejx̱i'be' ḻo na'gak benne' wen žin ka' dan' žeyaḻa' che x̱anbe' che da' wbíagak lba uba ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Naž benne' wen žin ka' béx̱wgake' x̱kwiden', na' béngake'-be' zi'. Beséḻa'gake'-be' ká'zebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naž x̱an yežlyón' bseḻe'e yetó bi' wen žin chie', na' x̱kwide' ni bžé'egake'-be' yej, na' bḻá'gake' yichjbe'. Béngake'-be' zi'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Naž x̱an yežlyón' bseḻe'e yetó bi' wen žin chie', na' x̱kwide' ni bétgake'-be'. Ḻezka' bseḻe'e x̱kwide' zanže bi' wen žin chie' ka', na' bénḻe'egake' baḻbe' zi', na' bétgake' yebaḻbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Biž wzóa no benne' nga'ne' che x̱an yežlyón'. Nga'nze to x̱kwide' byo chie', na' nží'iḻe'ele'-be'. Kate' wzé ḻawte bseḻe'e ẕi'ne', na' wnné': “Gápegake' ẕi'na' ba la'ne.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Naž benne' wen žin ka', ḻa' ḻégakze' wnnágake': “X̱kwide' ni žeyaḻa' chebe' yežlyó nga. Le cho'o, gotžo-be', na' ga'n yežlyó nga chežo.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Che ḻen béx̱wgake'-be', na' bétgake'-be'. Bžó'ngake'-be' na'le ḻo yežlyón' gan degak lba uba ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Naž Jesusen' wnnable' benne' ka', benne' nníta'gake' dot kwite', na' wnné': —¿Nakx̱ gon benne' x̱an yežlyón'? Yide', na' gote' benne' wen žin ka', na' wdíe' yežlyón' ḻo na'gak benne' yoble. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Bi beḻ-le da' nyejw ḻe'e yiche la'y? Ki ẕnnan: Yej na' da' bzoagak benne' wen ze'e ka' cheḻa'ale, na'a naken yej ḻen blo che ze'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","X̱anžo Dios bene' ga naken ki, na' žebán ḻáže'žo kan nak da' ẕḻe'elžo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naž gónegekle' séngake' Jesusen' dan' nnézgekle' bsaka' ḻebe' ki kan nak chégake', san ẕžébegake' benne' yež ka', benne' nníta'gake' ga na', na' che ḻen belka'ne' Ḻe', na' beyéjgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wdé na' benne' yodo' wnná bia' ka' bséḻa'gake' gan zoa Jesusen' baḻe benne' yodo' fariseo ka' ḻen benne' ka' žónḻengake' Herodes tẕen, nich góngake' ga bi da' nna Jesusen' nich gak yesbága'gake' Ḻe' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Benne' ka' bžíngake' gan zoa Jesusen', na' belyi'e Ḻe': —Benne' wsedle, nnezlto' ẕchaḻjo' da' naken dot da' li. Bi žeklo' da' želnnaze benách ka', dan' bi ẕwíazo' da' ẕḻoé'ezele kwingak benách ka', na' ḻo da' naken da' li žsedlo' da' žénele Dios gongak benách ka'. ¿Žonn da' bchi'le Moisés neto' latje chiẕjw lazto' da' ẕchíẕjwgake' ḻo wláz Benne' Sésar, benne' zi'to', bennen' ẕnná bi'e? ¿Wyíẕjwton' o bi chíẕjwton'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Žákbe'ele Jesusen' ẕnnábgekle' Ḻe' ki dan' žénegekle' yesbága'gake' Ḻe' ẕia, na' gože' ḻégake': —¿Biẕ chen' ẕžix̱le neda'? Le wḻoé'el neda' to mežw da' ẕkónlele žin nich ḻe'elan'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bḻoé'egekle' Ḻe' ton, na' Jesusen' wnnable' ḻégake', na' wnné': —¿Noẕ benne' da' ni ḻawe', na' le'? Beží'igake', na' wnnágake': —Che benne' Sésar da' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Naž Jesusen' gože' ḻégake', na' wnné': —Le wneẕjw che benne' Sésar da' naken che benne' Sésar, na' che Dios da' naken che Dios. Bebán ḻáže'gekle' che dan' bechebe Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Naž bḻa'gak baḻe benne' yodo' saduseo ka' gan zoa Jesusen'. Benne' ki ẕnnágake' bi yebangak benne' gat ka'. Che ḻen belyi'e Jesusen', ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","na' wnnágake': —Benne' wsedle, Moisés bzoje' cheto' cha' gat to benne' byo, bi zoa x̱kwide' chie', na' cha' ga'n no'le chie', bi' biche' bennen' žaḻa' wchág ná'ḻenbe' no'le wzeben', nich wzoabe' to x̱kwide' gakbe' x̱kwide' che bíche'ben'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wnníta'gak gaže bi' bíche'gakbe'. X̱kwide' byo nežw bchag ná'ḻenbe' to no'le, san gotbe', bi wzóa x̱kwide' chebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","X̱kwide' byo bežope bchag ná'ḻenbe' no'le wzeben', san ḻezka' gotbe', bi wzóa x̱kwide' chebe'. Ḻezka' goken che x̱kwide' byo beyonne. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ka' goken, yógo'tebe' bchag ná'ḻenbe' no'len', na' bi wzóa no x̱kwide' chégakbe'. Kate' ze ḻawte, ḻezka' got no'len'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na'a, kate' yebangak benne' gat ka', ¿Nóẕlgakbe' gak no'len' chebe', dan' gážetebe' bchag ná'ḻengakbe' ḻe'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bechebe Jesusen', na' gože' ḻégake': —Ẕchíx̱lele dan' bi nónbia'le da' nyejw ḻe'e yiche la'y, na' bi nnézlele kan nak yeḻa' wak che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kate' yebangak benne' gat ka', bi wchág ná'gake', na' benne' byo ka' bi sóaḻengake' no'le ka', san gákgake' kan zej nak wbás la'y ka' che Dios, wbás ka' nníta'gake' ya'abá chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na'a, kan nak chegak benne' gat ka' cha' yebángake', ¿bi na' goḻ-le dan' bzoj Moisés? Ẕchaḻjen kan Dios bḻiže' ḻe' ḻo yag yéche'do' da' žeyen, na' gože' ḻe': “Neda' naka' Dios che Bran, na' Dios che Isaak, na' Dios che Jakob.” Dan' wnné' ki chégake', nak bia' zej nbane' ḻa'kze gótgake' zga'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios nake' Dios chegak benne' ban ka', kege chegak benne' gat ka', benne' ka' nátgake' to chi'ize. Ẕchíxḻe'elele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ḻezka' bžin to benne' yodo' wsedle gan zoa Jesusen'. Benle' che Jesusen' dan' bcháḻjḻene' ḻégake', na' nnezle' cháwe'do' bechebe'. Che ḻen wnnable' Jesusen', na' wnné': —¿Biẕ da' bchi'le Dios žo'o nakžen blo ka yógo'te da' ka' bchi'le' žo'o gonžo? ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Bechebe Jesusen', na' gože' ḻe': —Da' bchi'le Dios ḻe'e da' nakžen blo ka yógo'te naken da' ẕnnan: Le yenle, benne' Israel ka'. X̱anžo Dios, toze' Ḻe' nake' X̱anžo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Žaḻa' ži'ilo' X̱ano' Dios dot ḻažo'o, na' ḻen dot yichj ḻaẕdo'o, na' ḻen dot yeḻa' žejní'il chio', na' ḻen dot yeḻa' wak chio'. Da' ni naken da' bchi'le Dios ḻe'e da' naken blo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Da' bchi'le Dios ḻe'e da' naken bežope, toze kan naken. Ki ẕnnan: Žaḻa' ži'ilo' lježo' kan nži'il kwino'. Bi zoa yetó da' bchi'le Dios ḻe'e da' nakžen blo ka da' chope ki da' wnnakze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naž benne' yodo' wsedlen' gože' Jesusen', na' wnné': —Cháwe'do' wnnó', benne' wsedle. Da' nak dot da' li ẕnno'. Toze nak Dios, na' bi zoa nitože no nak Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na' cha' nži'ilžo Dios dot ḻáže'žo, na' ḻen dot yeḻa' žejní'il chežo, na' ḻen dot yichj ḻáẕdo'žo, na' ḻen dot yeḻa' wak chežo, na' cha' nži'ilžo lježžo kan nži'il kwinžo, da' ki záka'žegaken ka yógo'te biado' ka' žotžo-ba' ḻo bkog la'y che Dios, na' ḻezka' ka yógo'te biado' ka' ẕzeyžo-ba' ḻo bkogen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kate' benle Jesusen' ka cháwe'do' bechebe bennen', gože' ḻe', na' wnné': —Yeláte'ze žiažje chio' nich si'o da' ẕnna bia' Dios. Bi bežogle nitože benne' bi da' nnable' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kate' ne žsedle Jesusen' benách ka' gan nak ḻo ẕchil yodo', wnné': —¿Biẕ chen' ẕnnagak benne' yodo' wsedle ka' Benne' Criston' nake' ẕa'só Dabí? ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ḻekze Dabín' bchaḻje', zoaḻen Dios Be' La'y ḻe', na' wnné': X̱anžo Dios gože' X̱ana': “Wžé' kwita' ḻi ža kate' gonža' ga wzóa ẕibgak ḻawo' benne' ka' bi ẕḻé'egekle' Le' chawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nak Benne' Criston' ẕa'só Dabí cha' ḻekze Dabín' wnné' nake' X̱ane'? Benne' zan, benne' ka' nníta'gake' ga na' wyáz ḻáže'gake' da' ni, na' bze nággake' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kate' ne žsedle Jesusen' benne' ka' žónḻengake' Ḻe' tẕen, gože' ḻégake': —Le gape chi'i kwinle chegak benne' yodo' wsedle ka'. Ẕdan ḻáže'gake' ẕdágake' nile na'le, zej nakwe' laže' tonn ka'. Ḻezka' ẕdan ḻáže'gake' wḻižgak benách ka' ḻégake' cháwe'do' gan nak ḻawe' ya'a. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ẕbé'gake' latje blo ka' ḻo yo'o gan ẕdobgak benách ka' nich yéngekle' x̱tiža' Dios, na' gan že'j žawgake' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ẕká'agake' ližgak no'le wzebe ka', na' nich wḻoé'ezele chawe' kwíngake', scha ẕcháḻjgake' ḻaw Dios. Benne' ki, wsaka' zi'že Dios ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kate' ne že' Jesusen' ḻo ẕchil yodo' gan zoa kak gan ẕgo'ogak benách ka' mežw che yodo', ẕwie' kan žongak benne' ka' ẕgó'ogake' mežw ḻo kaken'. Benne' ka' deḻe'e yeḻa' wnni'a chégake' ẕgó'ogake' mežw zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Naž bžin to no'le wzebe yache' ga na', na' wloé'e chope mežw lasdo' ḻo kaken', da' ka' záka'gaken láte'do'ze. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Naž Jesusen' bḻiže' benne' wsedle chie' ka', na' gože' ḻégake': —Da' li žapa' ḻe'e, no'le wzebe yache' ni wlo'ože' ka dan' wlo'ogak yógo'te benne' ka' wló'ogake' mežw ḻo kak che yodo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yógo'te benne' ka' ẕgó'ogake' che da' nga'nze chégake', san no'le ni, ḻo yeḻa' yache' chie' wloé'e dot da' do' deze chie', dan' žaḻa' gáwḻene'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kate' bežój Jesusen' ḻo ẕchil yodo', to benne' wsedle chie' gože' Ḻe', na' wnné': —Benne' wsedle, bwia nga ka ẕen gole zej nak yo'o ki, na' ka ẕen gole zej nak yej ka' zej žian ḻe'e ze'e chégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bechebe Jesusen', na' gože' ḻe': —Ẕḻe'elo' yo'o ẕen ki, san bi ga'n to yej ḻaw lježen nga, dan' wchinnjgak benách ka' ḻégaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Naž wyéj Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻaw Ya'a Yag Olibo, da' žen' ḻawle gan de yodo'. Kate' Jesusen' ba ži'e ga na', naž ḻa' ḻégakze Bedw ḻen Jakob, na' Ẕwa, na' Ndres, góžgake' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","na' wnnágake': —Wnná neto' batx̱ gak da' ki. ¿Biẕ gak bian' za' gakgak yógo'te da' ki? ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bechebe Jesusen', na' bsedle' ḻégake', na' wnné': —Le gape chi'i kwinle nich bi gon ḻáže'gekle' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ḻa'gak benne' zan, benne' légake' kan lia' neda', na' nnágake' zej nake' Benne' Criston'. Ki gon ḻáže'gekle' benne' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Kate' yénlele žak wdiḻe nile na'le, bi žébele. Yógo'te da' ki žaḻa' gákgaken, san bi na' žin ža ze ḻawte ža ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","To yež tiḻ-ḻen yetó yež, na' benách ka' to gan ẕnna bia' to benne' chejtíḻ-ḻengake' benách ka' yetó gan ẕnna bia' yetó benne'. Da' zan latje x̱o' ḻo yo, na' gak wbín. Gongak benách ka' žo'osbé. Da' ki gákgaken da' so ḻaw sáka'gak benách ka' nníta'gake' ža ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Naž le gape chi'i kwinle, dan' wdégake' ḻe'e ḻo na'gak benne' yolawe' ka'. Chíngake' ḻe'e gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios. Wzégake' ḻe'e ḻawgak benne' ka' ẕnna biá'gake' lažle, na' ḻawgak benne' ka' ẕnna biá'gake' yež zi'to' ka'. Góngake' ki chele dan' žónḻenle neda' tẕen, san ki gata' latje wzóa lile chia' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Zga'ale kate' žin ža ze ḻawte ža ka' žon byenen chejzéngekle' benách ka' dot yežlyó nga diža' chawe' chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Katen' wché'gake' ḻe'e, na' wdégake' ḻe'e ḻo na'gak benne' yolawe' ka', bi gek zédlele ni'a che da' žaḻa' nnale. Ḻa' ža na'ze Dios wneẕjwe' chele da' wchaḻjle, na' dan' nnale. Katen' wchaḻjle, kege ḻé'ezele na' nnale, san Dios Be' La'y nne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wdegak benách ka' ḻa' bíche'gakkze' ka' ḻo na'gak benne' ka' gótgake' ḻégake'. Benne' ka' zej nnita' x̱kwide' ka' chégake' wdégake' ḻa' ẕí'ngakkze', na' ẕí'ngake' ka' wdégakbe' ḻa' x̱a x̱ná'gakkzbe' ka' ḻo na'gak benne' ka' gótgake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yógo'te benách ka' wzóagake' ḻe'e cheḻa'ale dan' žónḻenle neda' tẕen, san nólele sóelele da' gaken na' zejte ža ze ḻawte ža, yelale. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Benne' ka' žóḻgake' da' ni žaḻa' chejní'igeklen'. Bzoj Daniel, bennen' bchaḻje' ḻo wláz Dios ža ni'te, da' ẕnnan ki: “Cho'o to da' naken x̱iwe' da' yesniten gan bi žaḻa' cho'on.” Kate' žin ža na', benne' ka' nníta'gake' gan nbab Judea žaḻa' wẕónnjgake', na' chjake' gan nak ḻaw ya'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","No benne' zoe' yichjo'o ža na' žaḻa' wẕónnjtie', na' bi yetje' ẕan yo'o nich chejx̱i'e bi da' de chie' ḻo yo'on'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","No benne' zoe' yix̱e' žaḻa' wẕónnjtie', na' bi yeyeje' liže' nich chejx̱i'e laže' da' x̱oa yene'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Da' nyáche'ḻe'e gaken chegak no'le ka' ža na', no'le ka' zej noe'e x̱kwide' ka', na' ḻezka' no'le ka' ẕgáẕe'gekle' bi' že'n ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Le wḻíž Dios, na' nnáblele-ne' bi gon byenen wẕonnjle kate' nak byo' zag. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kate' ža ka' sáka'žegak benách ka' ka da' gok zga'ale katen' bi na' gata' yežlyó nga, da' ben Dios na' zejte na'a ža, na' ža ka' da' zá'gaken bi gaken ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chela' bi gon Dios ga gakgak babze ža ka', bi yelá no benne', san dan' nži'ile' benne' ka' ba wžekze', ba bene' chie' gone' ga gakgak babze ža ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Na'a, cha' no benne' yi'e ḻe'e: “Le wia nga, zoa Benne' Criston' nga” o nnie': “Le wia nga zoe' ga na'” bi chejḻe'le che bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ḻa'gak benne' zan, benne' ka' gon ḻáže'gekle' benách ka', na' nnágake' zej nake' Benne' Criston', na' nnágake' zej nake' benne' ka' ẕcháḻjgake' ḻo wláz Dios. Wḻoé'egekle' da' ka' gak biá'gaken, na' góngake' yeḻa' wak ẕen ka'. Ḻezka' gon ḻáže'gekle' benne' ka' wžekze Dios cha' sáke'gekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Na'a ḻe'e, le soa ban ḻaže'. Yógo'te da' ki ba goža' ḻe'e zga'ale ka gákgaken. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ḻezka' wnná Jesusen': —Kate' ža ka', te gak da' ki, kate' sáka'gak benách ka' ki, choḻ wbíž, na' bi cha'ní' byo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yinnjgak belj ya'abá ka', na' x̱izgak da' ka' zej nḻan', da' ka' zej naken ẕen ya'abán'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naž ḻé'egekle' neda', Benne' Golje' Benách, za'a ḻo bejw ya'abá, napa' yeḻa' wak ẕen, na' yeḻa' baní' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Seḻa'a wbás chia' ka' che ya'abá, na' wtóbgake' benách ka' wžía' nedkza', benne' ka' nníta'gake' dap ḻa'ate yežlyó nga, gan so ḻawte yo biž, na' zejte gan so ḻawte ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Le chejní'il da' žsedle yag higo ḻe'e. Kate' so ḻaw gonen ni'a ne'ndo' ka', na' žebían x̱lage' že'ndo' ka', nnézlele za' žin byo' wbá ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ḻezka', kate' ḻé'elele žakgak da' ki, nnézlele za' žin ža ze ḻawte ža na', na' za' ḻa' ḻawn. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Da' li žapa' ḻe'e, yógo'te da' ki gákgaken zga'ale kate' gatgak benne' ka', benne' sóagake' nbángake' ža na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Te che ya'abá, na' che yežlyó nga, san x̱tiža'a batkle te chen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Kate' žin ža na' o yel na', bi nnezle nitó benne'. Bi nnézgekle wbás che ya'abá ka', na' bi nnezla' neda', Ẕi'n Dios. Toze Dios X̱a' nnezlen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Che ḻen, le soa lez, na' le soa ban ḻaže', na' le wchaḻjḻen Dios dan' bi nnézlele bi ža gakgak da' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gaken kan žak kate' chej to benne' zi'to'. Kate' za' wzé'e liže', wdíe' ḻo na'gak benne' wen žin chie' ka' da' de chie'. Che chégake' we'e x̱chíngake', na' nne' soa lez benne' zoe' žape chi'e ža yo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Le soa lez dan' bi nnézlele batx̱ yeḻá' x̱an yo'o, cha' kate' za' žaḻe, o gachje yele, o kate' ẕbeže leko', o zildo'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Le gon ki, nich bi yedjx̱ake'e ḻe'e ẕtasle cha' kon yeḻa'kze'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Da' ni da' žapa' ḻe'e, ḻezka' žapa' yógo'te benách: le soa ban ḻaže'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yechóp ža ka', gak Lni Pasko' kate' žejsá' ḻáže'gak benne' judío ka' kan ben Dios kate' beslé' x̱a x̱tó'gake' ka' ḻo yežlyó Egipto, da' naken lni kate' žáwgake' yet x̱til da' bi nzin' kwa zichj chen. Bx̱oz wnná bia' ka' ḻen benne' yodo' wsedle ka', wdíljgake' kan séngake' Jesusen' ži žize nich gótgake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wnnágake': —Bi žaḻa' senžo-ne' ža lni dan' gongak benách ka' žo'osbé. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kate' ža na' wzóa Jesusen' ḻo yež Betania, ḻo liž Smon, to benne' wdé'e yižwé' leže. Kate' ne že'j žaw Jesusen', wyáz to no'le, noe'e to béga'do' da' naken yej zaka', na' nža' da' ẕḻa' ẕix̱ che yeje susén las da' naken dot ḻi ḻaže', na' záka'ḻe'en. Bḻe'e béga'don', na' wloé'e da' ẕḻa' ẕix̱ yichj Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bža'agak baḻe benne' ka' nníta'gake' ga na', na' wnnágake' ḻa' ḻégakze': —¿Biẕ chen' gok ditje da' ẕix̱en'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chela' no benne' gote'en, si'že' ka láẕjwžo che to yiz, na' gak chise' mežwn' chegak benách yache' ka'. Wnnéḻe'egake' che no'len'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naž bchaḻj Jesusen', na' wnné': —Le we'e latje. ¿Biẕ chen' ẕnnele chie'? Nak chawe' dan' bene' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Benách yache' ka' nníta'ḻentezgake' ḻe'e, na' bátte'teze yénelele, gak gonle chégake' da' chawe', san neda' bi sóateza' gan zoale. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ben no'le ni ka da' wẕake'e. Bḻalje' da' ẕḻa' ẕix̱ ni neda', na' ki bpe'e neda' zga'ale kate' gacha'a ḻo yežw ba. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da' li žapa' ḻe'e, gáte'teze gan wcháḻjgake' diža' chawe' chian' dot yežlyó nga, ḻezka' soa no benne' wzóa lie' da' ben no'le ni chia'. Ki gaken nich chejsá' ḻáže'gak benách ka' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Naž bžoj Judas Iskariote, bennen' nbábḻene' benne' chežinno, benne' ka' žónḻengake' Jesusen' tẕen, na' wyeje' gan zej nnita' bx̱oz wnná bia' ka' nich wdíe' Jesusen' ḻo ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kate' béngekle' x̱tiža' Júdas na', bebégekle', na' bchebe ḻáže'gake' chíẕjwgake' ḻe' mežw. Naž wzó ḻaw Judas na' žilje' kan wdíe' Jesusen' ḻo ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nak ža ẕzo ḻaw žak lni kate' žáwgake' yet x̱til da' bi nzin' kwa zichj chen, ža na' žótgake' ẕíla'do', bian' žáwgake' Lni Paskon', kate' žejsá' ḻáže'gake' kan ben Dios katen' beslé' benne' judío ka' ḻo yežlyó Egipto. Naž benne' wsedle ka' che Jesusen' wnnábgekle' Ḻe', na' wnnágake': —¿Gaẕ žénelo' chejto' chejsí'ni'ato' da' gawžo x̱che' che Lni Pasko'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naž Jesusen' bseḻe'e chope benne' wsedle chie' ka', na' gože' ḻégake': —Le chej ḻo yež, gan chejx̱áka'le to benne' noe'e to že'e nis. Le chéjḻene'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gan choe'e, le ye' x̱an yo'on': “Ẕnna Benne' wsedle: ¿Gaẕ zoa yo'o gan gáwḻena' benne' wsedle chia' ka' x̱che' che Lni Pasko'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naž wḻoe'ele' ḻe'e to yo'o ẕen gan nak da' chope kwia gan ba nba'a. Le wsí'ni'a da' gawžo ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bžojgak benne' wsedle chie' ka', na' bžíngake' ḻo yež, na' bejx̱áka'gake' yógo'te kan ba gož Jesusen' ḻégake'. Bsí'ni'agake' da' gáwgake' ga na' che Lni Paskon'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kate' ba goḻen, bžin Jesusen' ga na', na' benne' chežinno, benne' wsedle chie' ka', zá'ḻengake' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kate' ne že'j žáwgake', bchaḻj Jesusen', na' wnné': —Da' li žapa' ḻe'e, zoa to benne' ládjwle ḻe'e, benne' že'j žáwḻene' neda' tẕen. Ḻe' wdíe' neda' ḻo na'gak benne' yodo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Naž gok nyache' ḻáže'gake', na' wzó ḻáwgake' žé'gake' Ḻe' to toe': —¿Naken neda'? Ḻezka' yetóe' wnné': —¿Nedan'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bechebe Jesusen', na' gože' ḻégake': —Nake' to benne' ladjw chežínnole ki, bennen' ẕžínḻene' neda' tẕen ḻo ye'n. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cha'a gan gótgake' neda', Benne' Golje' Benách, kan nyejw ḻe'e yiche la'y kan gaken chia', san da' nyáche'ḻe'e gaken che bennen' wdíe' neda' ḻo na'gak benne' ka' gótgake' neda'. Gakže chawe' che bennen' chéla'kze bi golje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kate' ne že'j žáwgake', Jesusen' bex̱we' yet x̱til. Gože' Dios: “Žóx̱keno'.” Bzožjen', na' bi'en chégake', na' wnné': —Le gawn. Da' ni naken beḻa' žen chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ḻezka' bex̱we' to ẕíga'do', na' gože' Dios: “Žóx̱keno'.” Naž bi'en chégake', na' yógo'tegake' wé'jgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesusen' gože' ḻégake': —Da' ni naken x̱chena' da' žon chochen diža' kobe da' ẕka'nen chawe', dan' žon Dios ḻen benách ka'. X̱chena' na' ḻaljen ni'a chegak benne' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Da' li žapa' ḻe'e, biž ye'ja' x̱is uba ki na' zejte ye'ja' da' kobe gan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wdé béḻgake' da' belwé ḻáwgake' Dios, bžójgake', na' jake' ḻaw Ya'a Yag Olibo. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naž Jesusen' gože' ḻégake', na' wnné': —Yógo'tele gak chope ḻáže'le, na' yebéj yichjle neda' na'a že', dan' nyejw ḻe'e yiche la'y da' ẕnnan: “Gota' benne' žape chi'e ẕila' ka', na' gásḻasgakba'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Te yebana' ḻo yeḻa' got, cha'a gan nbab Galilea zga'ala' ka ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naž Bedw gože' Jesusen', na' wnné': —Ḻa'kze yógo'tegake' gak chope ḻáže'gake', na' yebéj yíchjgake' Le', bi gak chope ḻaža'a neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesusen' gože' ḻe', na' wnné': —Da' li žapa' le', ḻa' yel nize, zga'ale kate' kweže leko' chope chi'i, chonne chi'i nnio' bi nónbi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naž Bedon' ben choche' x̱tiže'e ni'a che Dios, na' wnné': —Ḻa'kze gátḻentia' Le' tẕen, bi nnia' bi nónbi'a Le'. Ḻezka' wnnágake' yógo'tegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Naž bžin Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ḻo yežlyón' nzin' Jetsemaní, na' gože' ḻégake', na' wnné': —Le kwe' nga, kate' cha'a neda', chejcháḻjḻena' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bchi'e Bedw ḻen Jakob, na' Ẕwa, na' wzó ḻawe' žekle', na' žak nyache' ḻaže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jesusen' gože' ḻégake', na' wnné': —Gatkza' ḻo yeḻa' žak nyache' ḻaže' chia'. Le kwez nga, na' le nna'ze dot yele. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naž Jesusen' wzé'e yeláte'do' na'le, na' bzechw ḻawe' ḻo yo, na' bcháḻjḻene' Dios. Wnnable' Ḻe', cha' wak, kwase' chie' da' žaḻa' sáka'ḻi'e ža na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kate' ne ẕcháḻjḻene' Dios, wnné': —X̱e, yógo'te gak gono' Le'. Bekwás da' žaḻa' sáka'ḻi'a, san kege kan žénela' neda', san kan žénelo' Le', gono'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naž Jesusen' beyeje' gan zej nnita' benne' wsedle chie' ka', na' bejx̱ake'e ḻégake' ẕtásgake'. Gože' Bedon': —Smon, ¿ẕtaso' na'a? ¿Bi ẕbejo' bichgale yej ḻawo' to chí'ido'ze? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Le nna'ze dot yele, na' le wchaḻjḻen Dios, na' le nnable' bi si' latje da' x̱iwe' chen' ḻe'e cheḻa'ale. Da' li be' nákkzele zoakzen ban ḻaže', san ḻo yeḻa' benách chele žedó ḻáže'le. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naž da' yoble wyéj Jesusen', na' bcháḻjḻene' Dios, na' ḻa' tḻebe kan wnné'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kate' beyeje' da' yoble gan nníta'gake', bejx̱ake'e ḻégake' ẕtásgake' dan' yo'o bichgale yej ḻáwgake'. Bi wnnézgekle' bi da' yé'gake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kate' beyeje' da' chonne chi'i gan nníta'gake', gože' ḻégake': —¿Ẕtasle? ¿Žezí' ḻáže'le? ¡Ká'teze! ¡Ba bžin ža! Le wia nga, neda', Benne' Golje' Benách, ba ndia' ḻo na'gak benne' doḻa' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Le chas! ¡Le cho'o! Le wia nga, za' bennen' wdíe' neda' ḻo na'gak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kate' ne ẕchaḻj Jesusen' da' ni, bḻa' Judas, bennen' nbábḻene' yechinéj benne' ka' žónḻengake' Ḻe' tẕen, na' zá'ḻengak benne' zan ḻe' tẕen, benne' ka' zej noe'e ya ntoche' ka', na' yag ka'. Bx̱oz wnná bia' ka' ḻen benne' yodo' wsedle ka', na' benne' gole ka', bséḻa'gake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas na', bennen' ẕdie' Jesusen' ḻo ná'gake' ba bḻoe'ele' ḻégake' to da' gone' da' gak bian' no benne' nake' Jesusen', na' wnné': —Bennen' wchág ḻawa'-ne', Ḻekze' Jesusen'. Le sene', na' le chi'e. Le wia binlo nich bi yelé'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kate' bžin Judas na' ga na', ḻa' wbíga'tie' gan zoa Jesusen', na' gože' Ḻe': —Benne' wsedle, Benne' wsedle. Naž bchag ḻawe' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Naž béx̱wgake' Jesusen', na' bché'gake' Ḻe' nžeje'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naž to benne' žónḻene' Jesusen' tẕen wleje' ya ntoche', na' bene' we' bi' wen žin che bx̱oz blo, na' bchoge' yid nagbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesusen' gože' benne' ka', na' wnné': —¿Bžojle nwa'le ya ntoche' ka', na' yag ka' nich senle neda', kan žonle kate' ẕzenle to benne' wbán? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kate' ža ka' wzóaḻena' ḻe'e, na' bsedla' benne' ka' gan nak ḻo ẕchil yodo', bi wẕenle neda', san žaken ki nich gak da' nyejw ḻe'e yiche la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Naž yógo'te benne' wsedle ka' che Jesusen' bebéj yíchjgake' Ḻe', na' bẕónnjgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ḻezka' wzóa to x̱kwide' byo ga na', nawbe' Jesusen', na' nx̱oaze kwinbe' to laže' laga'. Benne' ka' zej nchi'e Jesusen' béx̱wgake'-be', ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","san bsanbe' lažen', na' gaḻ yídzebe' bẕonnjbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bché'gake' Jesusen' ḻaw bx̱oz blo, gan zej ndobe yógo'te bx̱oz wnná bia' ka' ḻen benne' gole ka', na' benne' yodo' wsedle ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bedw bejnawe' Jesusen' zí'to'le. Wyoé'e ḻa' ḻi'a liž bx̱oz blon', na' wžé'ḻene' tẕen benne' ni'a na' ka' bx̱oz blon', na' bche'l kwine' gan nak žoa'a yi'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bx̱oz wnná bia' ka' ḻen yógo'te benne' yolawe' blo ka' gónegekle' žéḻgekle' to da' gak yesbága'gake' Jesusen' ẕia nich gak chóggake' chie' gate', san bi be bžéḻgekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Benne' zan wnnégake' che Jesusen' da' wen ḻaže', san bi gok tḻebe dan' wnnégake' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Naž wzegak benne' ka' wnnégake' che Jesusen' da' wen ḻaze', na' wnnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Neto' benlto' da' bchaḻj bennen', na' wnné': “Wchinnja' yodo' nga, da' benen ḻen ni'a na'gak benne' ka', na' yechonne žaze yechisa' yetó da' bi gonen ḻen ni'a na'gak benne' ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ḻezka' bi gok tḻebe x̱tíža'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naž wzó ža' bx̱oz blon' gachje ḻáwe'le benne' ka' nníta'gake' ga na'. Wnnable' Jesusen', na' wnné': —¿Bi be žechebo'? ¿Biẕen' da' ẕnnagak benne' ki kan naken chio'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wzóa žize Jesusen', na' bi be bechebe'. Da' yoble bx̱oz blon' wnnable' Ḻe', na' wnné': —¿Nako' Le' Benne' Criston', Ẕi'n Dios la'y? ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bechebe Jesusen', na' wnné': —Naka'. Ḻezka' ḻé'elele neda', Benne' Golje' Benách, soa' kwi'a kwit ḻi ža che Dios, Bennen' napkze' dot yeḻa' wnná bia', katen' yeḻá'a ḻo bejw ya'abá. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naž bx̱oz blon', ḻo yeḻa' ẕža'a chie' bcheze' laže' da' nakwe', na' wnné': —Bi žiážjelžo no benne' wḻoe'ele' ẕia da' nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bénkzelele wnníe' che Dios ḻen da' wnné'. ¿Biẕ ẕnnale ḻe'e? Yógo'tegake' bchóggake' che Jesusen' gate'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Naž baḻe' wzó ḻáwgake' ẕžé'egake' Jesusen' ẕene'. Bkáche'gake' yej ḻawe', na' béngake' Ḻe' zi', na' wnnágake': —Wnné ya'a na'a nolto' bwáwža'ato' Le'. Benne' ka', benne' ni'a na' bx̱oz blon', wdápa'gake' žoa'a ḻaw Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kate' ne zoa Bedw ḻi'a ẕan yo'o, to x̱kwide' no'le, bi' wen žin che bx̱oz blon', wbíga'be' gan zoe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kate' bḻe'elbe' Bedon' gan ži'e ẕche'l kwine' žoa'a yi', bwíabe' ḻe', na' wnnabe': —Ḻezka' le' žónḻeno' Jesús, benne' Nasaret na', tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Beží'i Bedon', na' wnné': —Bi nónbi'a-ne', na' bi nnezla' bi dan' ẕnno'. Bežój Bedon', na' bejsóe' gan žázgake' ḻi'a na'. Naž wžeže leko'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Da' yoble to x̱kwide' no'le wen žin bwíabe' ḻe', na' wzó ḻawbe' že'be' benne' ka' nníta'gake' ga na', na' wnnabe': —Benne' ni žónḻene' ḻégake' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Da' yoble bžon Bedon'. Yextido', benne' ka' nníta'gake' ga na' góžgake' Bedon', na' wnnágake': —Da' li žónḻeno' ḻégake' tẕen, dan' nako' benne' Galilea. Ḻa' díža'ze ẕchaḻjo' zej nak bi'o, dan' toze kan ẕchaḻjle. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wzó ḻaw Bedon' žẕia kwine' ẕia, ẕzetje' Dios, na' wnné': —Bi nónbi'a bennen' ẕchaḻjle chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ḻa' wžéžete leko' da' chope chi'i. Naž bejsá' ḻaže' Bedon' dan' wnná Jesusen', katen' gože' ḻe': “Zga'ale kate' kweže leko' chope chi'i, chonne chi'i nnio' bi nónbi'o neda'.” Kate' bejsá' ḻaže'e diža' ni, wzó ḻawe' ẕbéžeḻi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kate' ne nak zildo', bx̱oz wnná bia' ka' ḻen benne' gole ka', na' benne' yodo' wsedle ka', na' yógo'te benne' yolawe' blo che yodo', béngake' toze diža'. Naž bché'gake' Jesusen' nžeje', na' bdégake' Ḻe' ḻo na' Pilato, bennen' wnná bian', nich choge' chie' gate'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaton' wnnable' Jesusen', na' wnné': —¿Nako' le' benne' nna bi'e benne' judío ka'? Bechebe Jesusen', na' wnné': —Da' li ẕnno'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bx̱oz wnná bia' ka' besbága'gake' Jesusen' da' zan da' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Naž Pilaton' wnnable' Ḻe' da' yoble, na' wnné': —¿Bi be žechebo'? Bze nag da' zan da' žesbága'gake' le'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bi be bechebe Jesusen'. Ka' goken, bebán ḻaže'l Pilaton'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","De to da' žónteze žon Pilaton' kate' žak lni na', žsane' to benne' nyejwe' liž ya, nóte'teze benne' želnnáb benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kate' ža ka' to benne' lie' Barrabás nyejwe' liž ya, tẕen ḻen yebaḻe lježe' ka', benne' ka' bdíḻ-ḻengake' benne' Roma ka', na' bétgake' baḻe benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kate' bžingak benne' zan ka' gan zoa Pilaton', wzó ḻáwgake' ẕnnábgekle' ḻe' gone' chégake' ka žónteze žone'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Beží'i Pilaton', na' wnné': —¿Žénelele wsana' bennen' chele, bennen' nna bi'e benne' judío ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ki wnná Pilaton' dan' žákbe'ele' bx̱oz wnná bia' ka' bdégake' Jesusen' ḻo ne'e dan' ẕgé'egekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bx̱oz wnná bia' ka' bzejní'igekle' benne' zan ka' nich nnábgekle' Pilaton' wsane' Barrabasen' ḻo ná'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Naž Pilaton' wnnable' ḻégake' da' yoble, na' wnné': —¿Biẕ žénelele gona' che bennen' ẕnnale lie' benne' nna bi'e benne' judío ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wžéžeya'agake' zižje, na' wnnágake': —¡Bde'e ḻe'e yag kroze! ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaton' wnnable' ḻégake', na' wnné': —¿Biẕ da' ẕia nbage'e? Da' yoble wžéžeya'agake' zižje, na' wnnágake': —¡Bde'e ḻe'e yag kroze! ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dan' gónele Pilaton' gone' dan' chaž ḻáže'gak benne' zan ka', bsane' Barrabasen' ḻo ná'gake'. Naž gože' benne' ka' žjake' ḻo wdiḻe, chíngake' Jesusen', na' bdie' Ḻe' ḻo na'gak benne' ka' nich chejdá'gake' Ḻe' ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naž benne' ka' žjake' ḻo wdiḻe, bché'gake' Jesusen' ḻi'a yolawe', gan btóbgake' ljéžgake' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bwákwgake' Jesusen' to laže' x̱na, na' béngake' to da' bžíagake' yichj Jesusen', dan' naken ḻen ni'a ne'e yag yeche'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Naž wzó ḻáwgake' žon dítjgekle' Jesusen', na' wnnágake': —¡Ga'n ẕen le', benne' ẕnna bi'e benne' judío ka'! ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bdíngake' ya x̱til yichje', na' bžé'egake' Ḻe' ẕene'. Bzoa ẕíbgake' ḻawe', na' ḻo yeḻa' žon ditjle bka'n ẕéngake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kate' beyóž ben dítjgekle' Ḻe', beká'agake' laže' x̱nan' da' nakwe', na' begákwgake' Ḻe' laže' chekze'. Naž bebéjgake' Ḻe' ḻa' ḻí'ale yolawen' nich chejdá'gake' Ḻe' ḻe'e yag kroze. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Béx̱wgake' to benne' yež Sirene, benne' ẕdeze' ga na', na' zezé'e yix̱e'. Lie' Smon, na' nake' x̱agak Kantr, na' Rufo. Béngake' ga bi'e yag kroze che Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bché'gake' Jesusen' latjen' nzin' Gólgota, to diža' hebreo da' ẕnnan ḻen diža' x̱iža', Ya'a Žit Yichj Benne'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bé'gake' da' ye'j Jesusen' x̱is uba da' nžix̱en než sḻa' che mirra, san Ḻe' bi we'jen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Naž bdá'gake' Ḻe' ḻe'e yag kroze, na' wdísgake' laže' da' gokw Jesusen' ḻo na' to to benne' ka', benne' žjake' ḻo wdiḻe. Bebéjgake' da' gak bian' nich nnézgekle' dan' yeyaḻa' to toe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ne nak x̱sile katen' bdá'gake' Ḻe' ḻe'e yag krozen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dižan' da' bdá'gake' ḻe'e yag kroze yichjle Jesusen' kan nak da' žesbága'gake' Ḻe' ẕia ẕnnan ki: “Benne' ẕnna bi'e benne' judío ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bdá'gake' chope benne' wbán ka' ḻe'egak yag kroze ka' tẕen ḻen Jesusen', na' de'e toe' kwite' ḻi ža, na' yetóe' kwite' yegle. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ka' goken, gok kan nyejw ḻe'e yiche la'y, da' ẕnnan: “Wbábḻene' benne' wen da' ẕinnj ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Benne' ka' želdíe' ga na' bḻiž zí'gake' Jesusen'. Bta yíchjgake', na' wnnágake': —¡O'! ¿Wchinnjo' yodo' che Dios, na' yechonne žaze yechison'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Beslá kwino' na'a, na' betj ḻe'e yag krozen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ḻezka' bx̱oz wnná bia' ka', na' benne' yodo' wsedle ka', ben dítjgekle' Ḻe'. Belyi'e ljéžgake' toe' yetóe', na' wnnágake': —Beslé' benne' yoble ka', san bi gak yeslá kwine'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ḻezka' wnnágake': —¡O'! ¿Nako' Benne' Criston', benne' nna bi'e benne' judío ka'? Betj na'a ḻe'e yag krozen' nich ḻe'elton', na' chejḻe'to' chio'. Ḻezka' benne' ka' zej de'e ḻe'egak yag kroze ka' tẕen ḻen Ḻe', bḻiž dítjgekle' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kate' bžin wawbíž, bchoḻ dot yežlyó nga, na' goken ki na' zejte žedá chonne. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kate' ne žedá chonne, wžéžeya'a Jesusen', na' wnné': —Eloi, Eloi, ¿lama sabaktani? Diža' hebreo ni ẕnnan ḻen diža' x̱iža': “Dios chia', Dios chia', ¿biẕ chen' bsan ḻažo'o neda'?” ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Benne' ka' nníta'gake' ga na' béngekle' diža' ni, na' wnnágake': —Le wzé nag. Žḻiže' Lías. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Naž bx̱ite' to benne' zoe' ládjwgake', na' besbise' to da' bḻole da' že'jen nis ḻo nop zichj. Bde'en to ḻaw ya x̱tildo', na' bi'en nich x̱op Jesusen', na' wnné': —Kwezžo, na' wíažo cha' yid Líasen' nich yetinne' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wžéžeya'a Jesusen', na' ḻa' gottie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wžeza' laže' žeje da' naḻan' gachje ḻáwe'le ḻo yodo', na' bžojen chople, da' wzó ḻawn yichjlen, na' bžinten x̱ní'alen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bennen' ẕchi'e benne' ka' žjake' ḻo wdiḻe, na' zie' ḻaw Jesusen', bḻe'ele' kan goken, kan wžéžeya'a Jesusen', na' ḻa' gottie', na' wnné': —Da' li benne' ni goke' Ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ḻezka' wnníta'gak no'le ka' ga na', na' zí'to'le ẕwíagake'. Wnníta'gak Lia Madlen, na' Salomé, na' Lia, x̱na'gak Jakob kwide', na' Jwsé ládjwgak no'le ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","No'le ki jákḻene' Jesusen' katen' wdé' gan nbab Galilea, na' gókḻengake' Ḻe', na' bnéẕjwgake' da' bdawe' Ḻe' ḻen benne' ka' žónḻengake' Ḻe' tẕen. Ḻezka' wnníta'gak yebaḻe no'le zan ga na', no'le ka' bžínḻengake' Ḻe' ḻo yež Jerusalén. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Za' žaḻe ža ẕpá'gake', ža na' za' žin ža la'y chegak benne' judío ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Che ḻen bḻa' Jwsé, benne' yež Arimatea, ga na'. Nake' benne' blo ládjwgak benne' yolawe' blo che yodo', na' ḻezka' ẕbeze' ža nna bia' Dios. Dot ḻaže'e wyoé'e gan zoa Pilato, na' wnnable' ḻe' wneẕjwe' ḻe' latje yeywé'e Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bebán ḻáže'le Pilaton' kate' wnné' ba got Jesusen', na' bḻiže' bennen' ẕchi'e benne' ka' žjake' ḻo wdiḻe, na' wnnable' ḻe' cha' ba nat Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kate' benle' da' wnná bennen' ẕchi'e benne' ka' žjake' ḻo wdiḻe, bneẕjwe' Jwsén' latje yeywé'e Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Naž Jwsén' go'we' to laže' da' záka'ḻe'en, na' betinne' Jesusen' ḻe'e yag kroze, na' bcheḻ-le' Ḻe' lažen' da' záka'ḻe'en. Naž wló'ogake' Ḻe' ḻo yežw ba da' nadjen to ḻo bloj ḻe'e ya'a yej. Bde'e to yej blag ẕen da' besbagan' gan žó'ogake' ḻo yežw ba na'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Lia Madlen, na' Lia, x̱na' Jwsé, bwíagake' gan bdégake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kate' ba wdé ža la'y chegak benne' judío ka', da' naken ža gaže ža, naž Lia Madlen, na' Salomé, na' Lia, x̱na' Jakob, wẕí'gake' da' ẕḻa' ẕix̱ nich chejló'ogake' Jesusen' da' ẕix̱en'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kate' ne nak zildo' ža nežw, jake' žoa'a yežw ba che Jesusen', na' bžíngake' ga na' kate' za' ḻa' wbíž. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Belyi'e ljéžgake' ka', na' wnnágake': —¿Noẕ benne' yeké'e yej na' nich gak cho'ožo ḻo yežw ba chien'? ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kate' bžíngake' ga na', bwíagake', na' bḻé'egekle' ba nkwas yej na', na' naken to yej ẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wyázgake' ḻo yežw ba ḻe'e ya'a yej na', na' bḻé'egekle' to x̱kwide' byo, wbás che ya'abá ga na'. Že'be' cheḻá'a ḻi ža ḻo yežw ban', na' nákwbe' to laže' tonn, laže' ẕíla'do'ze, na' bžébeḻe'egake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naž x̱kwiden' gožbe' ḻégake', na' wnnabe': —Biž žébele. Žeyiljle Jesusen', Benne' Nasaret, Bennen' wdé'e ḻe'e yag kroze. Ba bebane'. Biž zoe' nga. Le wia ga ni bx̱óagake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Le chej na'a, le chejzenle benne' wsedle chie' ka' da' ni, na' ḻezka' Bedw, na' ye'le ḻégake': “Chej Jesusen' zga'ale' ka ḻe'e gan nbab Galilea. Yeḻé'elele-ne' ga na' kan ba gožkze' ḻe'e.” ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naž bežójgake' ga na', na' bẕónnjgake' žoa'a yežw ban' dan' želẕize' ḻo yeḻa' ẕžebe chégake'. Bi belyi'e no benne' da' ni dan' ẕžébeḻe'egake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kate' bebán Jesusen' zildo' ža nežwn', bḻoe'e ḻawe' zga'ale ḻaw Lia Madlen, no'len' bebéj Jesusen' gaže be' x̱iwe' ka' wyoé'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wyéj Lian', na' bejzenlen' benne' ka' wdáḻengake' Jesusen'. Benne' ki zej nak nyache' ḻaže'e, na' ẕbéžegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kate' béngekle' kan nak da' bchaḻje', na' wnné' zoa nban Jesusen', na' bḻé'ekzele' Ḻe', bi bejḻé'gake' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wdé na', nža'le bḻoe'e ḻaw Jesusen' ḻawgak chope benne' wsedle chie' ka', benne' yó'ogake' nez, na' zjake' gan nak nez yix̱e'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naž beyéjgake', na' bejzéngeklen' yezíka'gake', san bi bejḻé'gake' x̱tíža'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kate' ze ḻawte, bḻoe'e ḻaw Jesusen' ḻawgak benne' chinéj, benne' wbás chie' ka', kate' ne že'j žáwgake'. Bdiḻe' ḻégake' dan' bi žejḻé'gake' chie', na' dan' nak zide yichj ḻáẕdo'gake', na' dan' bi bejḻé'gake' x̱tíža'gak benne' ka' bḻé'egekle' Ḻe' wdé bebane'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naž gože' ḻégake', na' wnné': —Le chej dot yežlyó nga, chejzénlele yógo'te benách diža' chawe' chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nóte'teze benne' chejḻi'e chia' neda', na' yezóe' nis, yelá bennen', san no benne' bi chejḻi'e chia', ga'n doḻa' da' nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Benne' ka' chejḻé'gake' chia' neda' góngake' da' gak biá'gaken. Wkóngekle' žin la', na' yebéjgake' be' x̱iwe' ka' yo'ogak benách ka', na' wcháḻjgake' diža' yoble ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cha' góx̱wgake' bele snia ka' ḻen ná'gake', o cha' yé'jgake' da' žoten benách, bi be gonen chégake'. X̱oa ná'gake' benne' yižwé' ka', na' yeyáktegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kate' X̱anžon' beyóž bcháḻjḻene' ḻégake' da' ki, Dios bechise' Ḻe' ya'abá chie', gan wži'e kwit ḻi ža che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bžójgake' ḻégake', na' bejzéngekle' benách yógo'te yež. X̱anžon' gókḻenkze' ḻégake', na' bi'e ḻégake' latje béngake' da' zej nak bian' nak dot da' li da' ẕcháḻjgake'. Ka'kze naken.");
INSERT INTO ztyNTps_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Benne' zan ba ben byéngake' bzójgake' gaze ḻo den da' naken dot da' li, dan' goken gan zoažo, ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","káteze bḻé'egeklen' ža ni'te, na' bzéngeklen' žo'o, na' bzégake' diža' kan goken. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Žekla' neda' gaken chawe' wzoja' da' ki gaze ḻo den chio', Teófilo, benne' cháwe'do', dan' ba wdilja' binlo kan nak yógo'te dan' goken ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ẕzoja' da' ni chio' nich nnezlo' nak dot da' li da' ba nsedlo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ža ni'te katen' wnná bia' Herodes gan nbab Judea, wzóa to bx̱oz lie' Secría. Nbábḻene' to kwe' bx̱oz, da' naken kwe' dan' ẕnna bia' Abías. Ḻezka' X̱bel, ẕo'le Secrían', nake' ẕa'só Aarón, bennen' goke' bx̱oz blo nežw, na' benne' biche' Moisés. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Secrían' ḻen X̱belen', zej nake' chawe' ḻaw Dios, na' dot ḻáže'gake' žóngake' kan ẕnna x̱tiža' Dios, na' ḻezka' da' bchi'le' Ḻe'. Ki goken, bi gok nitó benne' nnie' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bi wzóa no x̱kwide' chégake', dan' nak X̱belen' no'le wbíž, na' žoptie' ba ngólgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bžin byo' beyaḻa' che kwe' bx̱oz ka' gan nbab Secrían' góngake' žin ḻaw Dios, ḻo yeḻa' bx̱oz chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kan žónteze žongak bx̱oz ka', beyaḻa' ḻo wláz Secrían' wyoé'e latje la'y che yodo' nich wzeye' yale ẕix̱ ḻaw X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kate' Secrían' ne ẕzeye' yalen', yógo'te benách ka' wnníta'gake' ḻa' ḻí'ale, na' ẕcháḻjḻengake' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ḻa' na'ze bḻa' ḻaw to wbás che X̱anžon' gan zoa Secrían', zie' cheḻá'a ḻi ža che bkog la'y gan žey yalen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Katen' Secrían' bḻe'ele' wbás che ya'abán', gok zedle', na' bžebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naž wbasen' gože' Secrían', na' wnné': —Secría, bi žebo'. Dios ba benle' da' ẕnnablo'-ne', na' X̱bel, no'le chion', soa to bi' byodo' chie', na' go'o labe' Ẕwa. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gak yeḻa' ba nez ẕen chio', na' yebéḻe'elo'. Benne' zan yebégekle' ni'a che x̱kwiden'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gakbe' ẕenḻe'e ḻaw Dios. Bi ye'jbe' x̱is uba, na' kege to da' žsožlen benách ka'. Dios Be' La'y yedjsóaḻene'-be' kate' ne yo'obe' ḻo ḻe'e x̱na'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ẕwa ni gonbe' ga yeyakgak benne' zan, benne' Israel ka', che X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ḻezka' cheje' zga'ale' ka X̱anžon', na' Be' ḻa'yen', na' yeḻa' waken', da' ka' wnníta'ḻengaken Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, sóaḻengaken ḻe'. Ki gaken che Ẕwan' nich yeyone' toze benne' zej nake' x̱a ḻen ẕí'ngake' ka'. Wzejni'ile' benne' ka' ẕží'igake' che Dios, nich yeyákgake' benne' chawe' ka', na' yesnisle' ḻégake' nich gak ban ḻáže'gake', na' gápegake' X̱anžon' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Naž Secrían' wnnable' wbás che ya'abán', na' wnné': —¿Biẕe gak bian' gakgak da' ki? Ba ngola' neda', na' ḻezka' ba ngol no'le chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bechebe wbasen', na' wnné': —Neda' lia' Gabriel. Žona' žin ḻaw Dios. Ḻekze' bseḻe'e neda' nich wcháḻjḻena' le', na' wzenla' le' diža' chawe' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na'a, dan' bi bejḻi'o da' goža' le', wkwežo', na' biž gak nnio' kate' gákžegak yógo'te da' ki, kate' žin ža. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","X̱ak gokgak da' ki, wnníta'gak benne' ka' ḻa' ḻí'ale, želbeze' Secrían', na' žebángekle' dan' ẕžél-ḻe'ele' ḻo latje ḻa'yen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kate' bežój Secrían', bi gok wcháḻjḻene' ḻégake', na' gókbe'egekle' bḻe'e dáwe'le' to da' bḻoe'el Dios ḻe' ḻo latje ḻa'yen'. Dan' bi gok nne Secrían', bḻoé'ezele' nich bzejni'ile' ḻégake' dan' goken. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kate' bza'a ža ka' žaḻa' gon Secrían' žin ḻaw Dios, naž beyeje' liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wdé ža ka' wyó'o bi'do' ḻo ḻe'e X̱bel, ẕo'le Secrían', na' bga'ne' yo'oze gayo' byo'. Bsa' ḻaže'e, ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","na' wnné': —X̱anžon' žone' chia' ki. Žonne' to x̱kwide' chia', na' žone' ga biž yedoe'ela' ḻawgak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wdé x̱op byo', bḻa' ḻaw wbasen' che ya'abá, dan' bseḻa' Dios wbás na'kze', Gabriel, nich cheje' ḻo yež Nasaret, dan' nbaben Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios bseḻe'e ḻe' ga na', nich chejcháḻjḻene' to x̱kwide' no'le lebe' Lia. Ḻebe' ba bchebe ḻáže'be' wchág ná'ḻenbe' to benne' byo lie' Jwsé. Ḻe' nbabe' ẕa'só Dabí, bennen' wnná bi'e benách Israel ka' ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kate' wyó'o Gabrielen' gan zoa Lian', gože'-be': —Padiox̱. Dios že' ḻaže'e le'. X̱anžo Dios zóaḻene' le'. Ḻekze' žone' ga gakže chawe' chio' ka gak chegak yógo'te no'le ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kate' Lian' bḻe'elbe' wbás che ya'abán', wžé' zedlbe' ni'a che dan' bchaḻjen', na' bebanlbe' kan gože'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Naž wbasen' gože'-be', na' wnné': —Lia, bi žebo', dan' Dios žon chawe'e le'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na'a, cho'o to bi'do' ḻi'o, na' galj to x̱kwide' byodo' chio', na' go'o labe' Jesús. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jesús ni golbe', na' gake' benne' blo, na' si' le' Ẕi'n Dios, Benne' ẕente. X̱anžo Dios gone' ga nna bi'e kan ben Dabí, x̱a gole wdé che Jesusen', bennen' wnná bi'e ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jesusen' nna biá'teze' benne' Israel ka', na' yeḻa' wnná bia' chien' batkle te chen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Naž Lian' wnnablbe' wbás che ya'abán', na' wnnabe': —¿Nakx̱kze gak da' ki, dan' bi zóaḻena' benne' byo? ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Naž wbasen' gože'-be': —Dios Be' La'y ḻe'e gan zo', na' gone' ga yeḻa' wak che Dios, Benne' ẕente, sóaḻenen le', na' gaken gan zo' ka to ẕoḻ da' ẕgo'o bejw. Che ḻen bi' byodo' na', bi'don' žaḻa' galjbe', cho'obe' ḻo na' Dios, na' si' labe' Ẕi'n Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ḻezka' X̱bel, ẕi'n x̱a x̱to'o wdé, ba yo'o to bi' byodo' ḻi'e ḻa'kze ba ngole'. Wnnégake' chie', na' wnnágake': “Nake' no'le wbíž” san ba zej x̱op byo' yo'o bi'don' ḻi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bi be zoa da' bi gak gon Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Naž Lian' wnnabe': —Nakkza' chie'. To chi'ize naka' wen žin che X̱anžon'. Gak chia' kan bach wnnó' gon Dios chia' neda'. Naž ḻa' beza'te wbás che ya'abán' gan zoa Lian'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ḻa' ža na'ze wyó'o Lia nez, na' taría taría wyejbe' gan nak ḻaw ya'ado' ka', na' bžinbe' to yež da' nbaben Judea. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kate' bžinbe' ga na' wyo'obe' liž Secrían', na' gožbe' X̱belen': “Padiox̱.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kate' benle X̱belen' dan' wnná Lian', ḻa' btate kwin bi'don' yo'obe' ḻi'e, na' Dios Be' La'y bedjsóaḻene' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naž X̱belen' wnníe' zižje, na' wnné': —Dios ba ben cháwe'že' le' ka yógo'te no'le ka', na' ḻezka' ben chawe'e bi'don' yo'obe' ḻi'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Noẕkze neda', dan' bḻa' x̱na' X̱ana' ga zoa' ni? ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Katen' benla' dan' gožo' neda', ḻo yeḻa' žebél chebe' ḻa' btate kwin bi'don' yo'obe' ḻi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ba nez ẕen naken chio' dan' bejḻi'o x̱tiža' wbás che ya'abán', na' gakkze kan gože' le' ḻo wláz X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Naž Lian' wnnabe': Dot ḻaža'a ẕka'n ẕena' X̱anžon', ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na' žebéḻenla' Dios, Benne' Weslá chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios na'kze be' ḻaže'e neda'. Yoa'a ḻo ne'e Ḻe', na' to chi'ize naka' wen žin chie'. Na'a so ḻaw, nnágake' chia': “Ba nez ẕen naken che no'len'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ẕenḻe'e nak da' ben Dios, Benne' ẕente, chia' neda'. ¡Ga'n ẕen La la'y chie'! ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ḻe' žeyache' ḻáže'tezle' benne' ka' ẕžébegake' Ḻe', na'a ža, na' to chi'ize. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Da' zan yeḻa' wak ẕen ka' ba bene' Ḻe'. Bzex̱jwe' benne' ka' bka'n ẕéngake' yeḻa' žejní'il chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Beké'e yeḻa' wnná bia' chegak benne' blo ka', na' bene' ga zej nak blo benne' gax̱jw ḻaže' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bwawe' benne' ka' beldone', na' bka'ne' ka'ze benne' wnni'a ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gókḻene' benne' Israel ka', benne' wen žin chie' ka', dan' be' ḻaže'e ḻégake', na' beyache' ḻáže'le' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bene' da' bchebe ḻaže'e chegak x̱a x̱to'žo ka', dan' gone' chežo, dan' bchebe ḻaže'e che Bran, na' chegak ẕa'sóe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Lian' bgá'nḻenbe' X̱belen' chonne byo', na' wdé na' beyejbe' ližbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kate' bžin ža žaḻa' soa x̱kwide' che X̱belen', golj to bi' byodo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Benne' ẕjo'o ḻi'a chie' ka' ḻen lježe' ka', béngekle' kan Dios beyache' ḻáže'le' ḻe', na' bebéḻengekle' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kate' ba gok x̱ono' ža zoa x̱kwiden', bḻa'gak ljéžgake' ka' ga na' nich chóggake' ḻo beḻa' che bi' byodon' da' nak bian' nbabbe' che Dios, na' gónegekle' wzóagake' labe' Secría kan zoa la x̱abe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Naž beží'i X̱bel, x̱na'be', na' wnné': —O'o. Ẕwa si' labe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wnnábgekle' ḻe', na' wnnágake': —¿Biẕ chen'? Bi zoa nitó lježle, benne' lie' Ẕwa. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naž benne' ka' bḻoé'ezegekle' nich nnábgekle' x̱abe' biẕe žénele' si' labe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Secrían' wnnabe' to blagdo', na' bzoje' ḻawn da' ẕnnan: “Ẕwa si' labe'.” Bebángekle' yógo'tegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka' gaze ḻa' beyáljwte žoa'a Secrían', na' gok bechaḻje', na' bka'n ẕene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Naž bebángekle yógo'te benne' ẕjo'o ḻi'a chégake', na' wzé diža' kan gok da' ki yógo'te yeždo' zej nnitan' ḻawgak ya'ado' ka' gan nbab Judea. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bza' ḻáže'gak yógo'te benne' ka' katen' béngekle' kan goken, na' wnnágake': —¿Biẕkzen' gon bi' byodon'? Da' likze X̱anžon' zóaḻene'-be'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naž Dios Be' La'y bedjsóaḻene' Secrían', x̱a Ẕwan', na' bchaḻje' ḻo wláz Dios, na' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Ga'n ẕen Dios, X̱angak benne' Israel ka', dan' bedjwíe' žo'o, benách chie', na' beya'we' žo'o! ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bseḻe'e Benne' Weslá chežo ga zoažo ni, ḻen yeḻa' wak ẕen chie'. Nake' X̱kwiden' za' goljbe' ládjwgak ẕa'só Dabí, bennen' goke' wen žin che Dios ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ža ni'te bchebe ḻaže'e gone' da' ki, dan' wnné' ḻo na'gak benne' ka' bcháḻjgake' ḻo wlaze' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bchebe ḻaže'e yeslé' žo'o ḻo na'gak benne' ka' ẕžá'agake' žo'o, na' ḻo na'gak benne' ka' bi ẕḻé'egekle' žo'o chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bchebe ḻaže'e yeyache' ḻáže'le' Dabín', x̱a gole wdé chežon', na' chejsá' ḻaže'e da' bchebe ḻaže'e, dan' naken la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ben choche' x̱tiže'e, dan' bchebe ḻaže'e gonen', dan' gože' Bran, x̱a gole wdé chežon', dan' naken to da' žaḻa' gone' chežo žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bchebe ḻaže'e yeslé' žo'o ḻo na'gak benne' ka' bi ẕḻé'egekle' žo'o chawe' nich biž žébežo gonžo x̱chine' Ḻe', ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na' nich gakžo gax̱jw ḻaže', na' dot chawe' ḻawe' Ḻe' yógo'te ža soažo nbanžo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Le', ẕí'na'do', si' lo' benne' ẕchaḻje' ḻo wláz Dios, Benne' ẕente, dan' chejo' le' zga'alo' ka X̱anžon', na' gon chawo'o nez gan tie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wzejni'ilo' benách chie' ka' kan wak yelágake' na' kan yenít ḻaw Dios doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ki naken, Dios žeyache' ḻáže'le' žo'o, na' gone' ga ḻa' ḻaw Bennen' nakkze' baní' chežo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ḻekze' wza'ni'e chegak benne' ka' nak choḻ yichj ḻáẕdo'gake', na' za' gátgake', nich yegoé'e žo'o to nez gan ga'n cháwe'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bgole x̱kwide' byodon', na' gokbe' waḻe. Wzóazebe' gan nak latje dach kate' bžinže ža bḻa' ḻawbe' ḻawgak benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ḻa' ža na'ze Augusto, benne' Sésar, bchi'le' yógo'te benách nníta'gake' yežlyó nga yéla'gake' ḻe'e yich. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kate' da' nežw byéla'gake' ḻe'e yichen', wnná bia' to benne' lie' Sirenio gan nbab Siria. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yógo'te benách ka' beyéjgake' yež che chégake' gan zej nbabe' nich yéla'gake' ḻe'e yichen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wzá' Jwsé ḻo yež Nasaret gan nbab Galilea, nich cheje' gan nbab Judea, na' bžine' ḻo yež Belén, gan golj Dabí ža ni'te. Ki bene' dan' nbabḻen Jwsén' benne' ka' zej nake' ẕa'só Dabín'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jwsén' wyeje' ga na' nich yéle'e ḻe'e yichen', tẕen ḻen Lia. Lian' nakbe' x̱kwide' no'len' ba bchebe ḻáže'be' wchág ná'ḻenbe' Jwsén', na' za' galj bi'do' chebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kate' ne nníta'gake' ḻo yež Belén, bžin ža žaḻa' galj bi'do' cheben'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Golj to bi' byodo', x̱kwide' nežw chie'. Bcheḻe'-be' to láže'do', na' bdix̱jwe'-be' to ḻo yo'odo' gan žape chí'igake' da' žawgak bia ka' chegak benne' ka' yó'ogake' nez. Ki goken dan' bi bžeḻ latje gan gá'ngake' ḻo yo'o gan želžín benne' ka' yó'ogake' nez. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gawze gan že' yež Belén nníta'gak benne' ka' yix̱e', benne' žape chí'igake' ẕila' ka' žel. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ḻa' bḻa' ḻawte to wbás che X̱anžon' gan nníta'gake'. Wyó'o yeḻa' baní' che X̱anžon' gan nníta'gake', na' bžébegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Naž wbás che ya'abán' gože' ḻégake', na' wnné': —Bi žébele. Na'a ẕzenla' ḻe'e to da' gonen ga yebélele, na' yebéḻengeklen yógo'te benách. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na'a ba golj to bi' byodo' ḻo yež gan golj Dabí, na' gakbe' Benne' Weslá chele. Nake' benne' bseḻa' Dios, na' nake' X̱anžon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Da' ni gak bia'be' nich gónbia'le-be'. Yežeḻ-lele-be', nžeḻbe' láže'do', na' debe' to ḻo yo'odo' gan žape chí'igake' da' žawgak bia ka' chegak benne' ka' yó'ogake' nez. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gan wzóa wbás che ya'abán', ka' gaze bḻa' ḻawgak wbás zante che ya'abá che Dios, na' ẕka'n ẕéngake' Dios, na' wnnágake': ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Ga'n ẕen Dios, Bennen' zoe' ža'te! Gak da' wká'n chawen' benách yežlyó nga, benne' ka' Dios žaz ḻaže'e ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kate' beza'gak wbás che ya'abá ka' ga na', zeyéjgake' ya'abá, benne' ka' žape chí'igake' ẕila' ka' gož ljéžgake' toe' yetóe', na' wnnágake': —Le cho'o ḻo yež Belén nich ḻe'elžo cha' ba goken kan bzejní'il X̱anžon' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Taría taría ḻa' jaktie' ga na', na' bejx̱áka'gake' Lian' ḻen Jwsén', na' x̱kwiden', bi'don' debe' to ḻo yo'odo' gan žape chí'igake' da' žawgak bia ka' chegak benne' ka' yó'ogake' nez. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kate' bḻé'egekle'-be', bzéngekle' ḻégake' dan' wnná wbás che ya'abán', kan nak che x̱kwiden'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bebángekle yógo'te benne' béngekle' dan' wnnagak benne' ka' žape chí'igake' ẕila' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lian' wlo'oze' da' ki ḻo yichj ḻáẕda'we', na' blab ḻaže'e kan zej naken. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Beyejgak benne' ka' žape chí'igake' ẕila' ka', ẕka'n ẕéngake', na' žoe ḻáwgake' Dios ni'a che yógo'te dan' béngeklen', na' bḻé'egeklen', da' ka' gókgaken kan gož wbás che ya'abán' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kate' ba gok x̱ono' ža wzóa x̱kwide' Jesusen', belchoge' ḻo beḻa' chebe' da' nak bian' nbabbe' che Dios, na' bzóagake' labe' Jesús kan ba bzoakze wbás che ya'abán' labe' zga'ale kate' za' cho'obe' ḻe'e x̱na'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kate' bza'a ža che da' ẕpa' kwingak no'le ka' za' bzóategake' bi'do' chégake' kan ẕnna da' bchi'le Moisés, belchi'e x̱kwide' Jesusen' ḻo yež Jerusalén nich kó'ogake'-be' ḻo na' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ki béngake', dan' nyejw ḻo da' bchi'le X̱anžo Dios, dan' ẕnnan: “Yógo'te bi' byodo', bi' nežw che x̱na'be', žaḻa' kwéjgake'-be' cheze che X̱anžo Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Che ḻen jake' ga na' nich gótgake' chope sintr gog, o chope plomdo' ka', na' kó'ogake'-ba' ḻaw Dios, kan ẕnna x̱tiža' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ža na'ze zoa to benne' lie' Smon ḻo yež Jerusalén, bennen' nake' chawe', na' žejḻi'e che Dios. Ẕbeze' Bennen' seḻa' Dios, Bennen' gon chawe'e benách Israel ka'. Dios Be' La'y zóaḻene' Smon na', ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","na' ba bḻoe'ele' ḻe' bi gatzie' kate' ḻé'ežele' Benne' Criston', Bennen' seḻa' X̱anžo Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bžin Smon na' ḻo ẕchil yodo' dan' bche' Dios Be' La'y ḻe' ga na'. Katen' x̱a x̱na' x̱kwide' Jesusen' belchi'e-be' ḻo ẕchil yodo' nich góngake' chebe' kan ẕnna x̱tiža' Dios, ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Smon na' wdele'-be', na' bka'n ẕene' Dios, na' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","X̱an, na'a wak gonno' neda' latje gata', na' ga'n ži yichj ḻáẕda'wa', dan' ba gok dan' gožo' neda', wen žin chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ba bḻe'ela' bi'don' bzoakzo' Le', bi'don' gakbe' Bennen' yeslé' benách ka', ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bennen' wḻoe'elo' ḻaw ḻawgak yógo'te benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nakbe' baní' dan' wza'nín' chegak benne' zi'to' ka', na' ḻezka' baní' chegak benách chio', benne' Israel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bebanle Jwsén' ḻen Lian', x̱na' x̱kwide' Jesusen', kan nak dan' wnná Smon na' kan nak chebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Smon na' wnnable' Dios gon chawe'e ḻégake', na' gože' Lian', x̱na' Jesusen', na' wnné': —Bwia nga. Dios bzoe' X̱kwide' ni nich gakbe' da' gonen ga chix̱ ḻáže'gekle benne' zan, na' gonbe' ga yeyakgak chawe' benne' zan ládjwgak benách Israel. Gakbe' to da' gak bian', na' benách ka' nnégake' chebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gaken ki nich ḻa' ḻaw dan' ẕza' ḻáže'gak benne' zan. Da' ki gaken chio' ka to ya ntoche' da' chazen ḻaẕdo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ḻezka' Ana, to no'le ẕchaḻje' ḻo wláz Dios, wzóe' ga na'. Nake' ẕi'n Fanuel, to benne' nbabe' ẕa'só bennen' lie' Aser, ẕi'n Israel. Ana na' wzóaḻene' benne' byo chie' gaže yiz wdé goke' x̱kwide' no'le, na' ba ngól-ḻi'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Got benne' byo che Anan', na' bga'ne' wzebe na' zejte ba zeje' tapḻalj tapiz. Bi žežoje' gan nak ẕchil yodon'. Dot ža dot yele, ẕka'n ẕene' Dios, na' žone' wbás, na' ẕcháḻjḻene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ḻa' na'ze bḻe'e ga na', na' gože' Dios: “Žóx̱keno'.” Bzejni'ile' yógo'te benách kan nak che x̱kwide' Jesusen', benne' ka' nníta'gake' ḻo yež Jerusalén, na' želbeze' ža ḻa' Bennen' seḻa' Dios nich gon chawe'e benách chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wdé ben Jwsén' ḻen Lian' yógo'te dan' ẕnna x̱tiža' X̱anžo Dios, beyéjgake' lážgake', yež Nasaret gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bgole x̱kwide' Jesusen', na' gokbe' choch. Góta'že yeḻa' žejní'il chebe', na' ẕen nak da' wló'o Dios ḻo yichj ḻáẕdo'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Twiz twiz žjak x̱a x̱na' Jesusen' ḻo yež Jerusalén katen' žak Lni Pasko', kate' žejsá' ḻáže'gak benne' judío ka' kan ben Dios, katen' beslé' x̱a wdé chégake' ḻo yežlyó Egipto. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kate' x̱kwide' Jesusen' ba zejbe' chežinno yiz, jake' ḻo yež Jerusalén kan žónteze žóngake' kate' žak lni na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kate' wdé lnin', zezá'gake', na' x̱kwide' Jesusen' nga'nbe' ḻo yež Jerusalén, san Jwsén' ḻen Lian', x̱na' Jesusen', bi gókbe'egeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Žékgekle' zeyo'obe' ladjw benne' zan ka', benne' zesá'kḻene' ḻégake', na' che ḻen to ža besa'ke'. Naž beyíljgake'-be' gan zej nnita' ljéžgake', na' gan zej nnita' benne' ka' zej nónbi'e, ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","na' bi bežéḻgekle'-be'. Che ḻen beyéjgake' ḻo yež Jerusalén, na' beyíljgake'-be' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ža chonne ža, bežéḻgekle'-be' gan nak to ḻo ẕchil yodo', že'be' ládjwgak benne' yodo' wsedle ka', na' ẕze nagbe' dan' žsédgekle', na' ẕnnablbe' ḻégake' da' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bebángekle yógo'te benne' béngekle' dan' bchaḻjbe' ḻen yeḻa' žejní'il chebe', na' kan nak dan' bechebbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kate' x̱a x̱na'be' bḻé'egekle'-be', bebángekle'. X̱na'be' gože'-be', na' wnné': —Ẕi'na', ¿biẕ chen' beno' ki ḻen neto'? Wžé' zedlto', na' beyiljto' le', neda' ḻen x̱on'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naž Jesusen' gožbe' ḻégake', na' wnnabe': —¿Biẕ chen' beyiljle neda'? ¿Bi nnézlele žon byenen we' ḻaža'a da' naken che X̱a'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bi bejní'igekle x̱a x̱na'be' dan' gožbe' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesusen' beyéjḻenbe' ḻégake', na' bežinbe' ḻo yež Nasaret. Benbe' kan ẕnna x̱tíža'gak x̱a x̱na'be'. Lia, x̱na' Jesusen', wló' cháwe'ze' yógo'te da' ki ḻo yichj ḻáẕda'we'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Góta'že yeḻa' žejní'il che x̱kwide' Jesusen', na' bgolbe'. Bežojbe' chawe' ḻaw Dios, na' ḻawgak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kate' ba zej chi yiz ẕnna bia' Tiberio, benne' Sésar, dot yežlyó nga, ẕnna bia' Ponsio Pilato gan nbab Judea, na' Herodes ẕnna bi'e gan nbab Galilea, na' Lip, biche' Herodes na', ẕnna bi'e gan nbab Iturea, na' gan nbab Trakonite, na' bennen' lie' Lisanias ẕnna bi'e gan nbab Abilinia. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kate' ža ka' Anás ḻen Kaifás, zej nake' bx̱oz blo ka', na' ḻa' na'ze Dios bcháḻjḻene' Ẕwa, ẕi'n Secría, kate' ne zoa Ẕwan' ḻo latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wdá Ẕwan' do ẕente žoa'a yego Jordán, na' bchaḻje' kan žaḻa' yezoagak benách ka' nis, benne' ka' žeyát ḻáže'gake' nich yenít ḻaw Dios doḻa' da' zej nbage'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gok da' ki kan nyejw ḻe'e yich la'y, dan' wnná Isaías, benne' bchaḻje' ḻo wláz Dios ža ni'te, dan' ẕnnan: Benle chi'i to benne' wnníe' zižje ḻo latje dach, wnné': “Le wpá' nez nich žin X̱anžo Dios gan zoale. Le yebéj li nez las ka' gan tie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Le yeschá' yógo'te gan zej že' bloj ka'. Le gon lache' yógo'te ya'a sibe ka', na' ya'ado' ka'. Le yebéj ḻi nez legw ka', na' le gon chawe' nez yej ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yógo'te benách ḻé'egekle' bennen' seḻa' Dios, bennen' yeslé' ḻégake'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kate' bžojgak benne' zan ḻo yež ka' nich yezóagake' nis ḻo na' Ẕwan', ḻe' gože' ḻégake', na' wnné': —Ḻe'e, lježgak bele snia ka'. ¿Biẕ chen' žénelele yezoale nis? ¿Zoa no benne' gože' ḻe'e bi chog Dios chele gatle cha' yezoale nis? ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na'a, le gon da' gak bian' ba beyát ḻáže'le, na' bi sa' ḻáže'le, bi nnale: “Dios bi choge' cheto' gatto' dan' nakto' ẕa'só Bran” dan' žapa' ḻe'e, gak Dios ke'e yej ki, na' gone' ga yeyákgaken ẕa'só Bran na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nakle ka yag ka'. Ba ẕbez ya wage nich chogen yag ka'. Bíte'teze yag da' bi ẕbian da' ẕix̱ chen, chóggaken', na' wzéygaken' ḻo yi'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Naž benách ka' nníta'gake' ga na' wnnábgekle' ḻe', na' wnnágake': —¿Nakx̱kze gonto'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bechebe Ẕwan', na' gože' ḻégake': —No benne' de chope ẕe' žaḻa' wneẕjwe' ton che no benne' bi de chie'. No benne' de da' žawe', ḻezka' žaḻa' chisen' chegak benne' ka' bi de da' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ḻezka' baḻe benne' wechiẕjw ka', benne' ẕchíẕjwgake' benách ka' ḻo wláz yež zi'to', bžíngake' ga na' nich yezóagake' nis. Wnnábgekle' ḻe', na' wnnágake': —Benne' wsedle, ¿biẕ žaḻa' gonto' neto'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ẕwan' gože' ḻégake': —Bi wchíẕjwžele kan wnná benne' ẕnna bi'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ḻezka' baḻe benne' žjake' ḻo wdiḻe wnnábgekle' ḻe', na' wnnágake': —¿Cheẕe neto', biẕ žaḻa' gonto'? Ẕwan' gože' ḻégake': —Biž wcheble nitó benne' nich ka'le bi da' de chie'. Biž nnale chegak benách ka' da' wen ḻaže' nich gonle ga chíẕjwgake' ḻe'e, san le chaz ḻaže' ka da' náẕjwle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ḻezka' benne' ka' želbeze' Bennen' seḻa' Dios, wnníta'gake' ga na', na' žsa' ḻáže'gake' cha' nak Ẕwan' Benne' Criston'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bechebe Ẕwan', na' gože' yógo'tegake', na' wnné': —Da' li neda' žezóa' ḻe'e nis, da' ẕḻoe'elen nakle ka benne' ka' ba gótgake', na' zej nzi'e yeḻa' nban da' yoble, san za' Bennen' wchize' ḻe'e Dios Be' La'y, na' da' naken yi' chie', na' Dios Be' La'y na' gonne' ḻe'e yeḻa' nban da' zejlí kanne. Bennen' ze'e napže' yeḻa' wnná bia' ka neda', na' neda' bi naka' zi kweja' ẕele'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nox̱e' da' žẕen yi' chie', na' wlobe' ẕoa' stribe chie', dan' ẕḻoe'elen kan gaken chegak benách ka'. Wtobe' ẕoa' striben', na' ko'o chawen', san bebe chen wzeyen' ḻo yi' da' batkle yoḻen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kan zej nak diža' ki, na' yebaḻe diža' zan bzejni'ile' benách ka', na' bzenle' ḻégake' diža' chawen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ẕwan' bdiḻ diže'e Herodes, benne' wnná bia', dan' zóaḻene' Herodías, ẕo'le Lip, benne' biche'e, na' dan' žone' da' zan da' kegle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naž ben Herodes na' to da' kegle da' ẕenže, bsejwe' Ẕwan' liž ya. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kate' ža ka' kate' bi na' nyejw Ẕwan' liž ya, na' žezóe' benách ka' nis, ḻezka' bezóe' Jesusen' nis. Kate' Jesusen' ne ẕcháḻjḻene' Dios, wyaljw ya'abá, ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na' bḻa' ḻaw Dios Be' La'y. Ẕnne'e ka to plomdo', bian' betjba', na' bžinba' gan zoa Jesusen'. Benle' chi'i to Benne' ẕchaḻje' ya'abá che Dios, na' wnné': —Le' nako' Ẕi'na'. Nži'ila' Le', na' žaz ḻaža'a Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Katen' Jesusen' wzó ḻawe' žone' x̱chin Dios, zeje' Ḻe' ka chi žoa yiz. Žékgekle benách nake' ẕi'n Jwsé. Jesusen' nake' ẕa'só Elí. Bennen' nake' x̱a Lia, x̱na' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí na' goke' ẕi'n Matat. Bennen' goke' ẕi'n Lebí. Bennen' goke' ẕi'n Melki. Bennen' goke' ẕi'n Jana. Bennen' goke' ẕi'n yetó Jwsé. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jwsé ni goke' ẕi'n Matatías. Bennen' goke' ẕi'n Amós. Bennen' goke' ẕi'n Nahum. Bennen' goke' ẕi'n Esli. Bennen' goke' ẕi'n Nagai. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai na' goke' ẕi'n Maat. Bennen' goke' ẕi'n yetó Matatías. Bennen' goke' ẕi'n Semei. Bennen' goke' ẕi'n yetó Jwsé. Bennen' goke' ẕi'n Judá. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá na' goke' ẕi'n Joana. Bennen' goke' ẕi'n Resa. Bennen' goke' ẕi'n Sorobabel. Bennen' goke' ẕi'n Salatiel. Bennen' goke' ẕi'n Neri. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri na' goke' ẕi'n yetó Melki. Bennen' goke' ẕi'n Adi. Bennen' goke' ẕi'n Kosam. Bennen' goke' ẕi'n Elmodam. Bennen' goke' ẕi'n Er. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er na' goke' ẕi'n Josué. Bennen' goke' ẕi'n Elieser. Bennen' goke' ẕi'n Jorim. Bennen' goke' ẕi'n yetó Matat. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat na' goke' ẕi'n Lebí. Bennen' goke' ẕi'n Smon. Bennen' goke' ẕi'n Judá. Bennen' goke' ẕi'n yetó Jwsé. Bennen' goke' ẕi'n Jonán. Bennen' goke' ẕi'n Eliakim. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim na' goke' ẕi'n Melea. Bennen' goke' ẕi'n Mainán. Bennen' goke' ẕi'n Matata. Bennen' goke' ẕi'n Natán. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán na' goke' ẕi'n Dabí. Bennen' goke' ẕi'n Isaí. Bennen' goke' ẕi'n Obed. Bennen' goke' ẕi'n Boos. Bennen' goke' ẕi'n Salmón. Bennen' goke' ẕi'n Naasón. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón na' goke' ẕi'n Aminadab. Bennen' goke' ẕi'n Aram. Bennen' goke' ẕi'n Esrom. Bennen' goke' ẕi'n Fares. Bennen' goke' ẕi'n yetó Judá. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá na' goke' ẕi'n Jakob. Bennen' goke' ẕi'n Isaak. Bennen' goke' ẕi'n Bran. Bennen' goke' ẕi'n Taré. Bennen' goke' ẕi'n Nakor. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor na' goke' ẕi'n Serug. Bennen' goke' ẕi'n Ragau. Bennen' goke' ẕi'n Peleg. Bennen' goke' ẕi'n Heber. Bennen' goke' ẕi'n Sala. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala na' goke' ẕi'n Kainán. Bennen' goke' ẕi'n Arfaxad. Bennen' goke' ẕi'n Sem. Bennen' goke' ẕi'n Noé. Bennen' goke' ẕi'n Lamek. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek na' goke' ẕi'n Matusalén. Bennen' goke' ẕi'n Enok. Bennen' goke' ẕi'n Jared. Bennen' goke' ẕi'n Mahalalel. Bennen' goke' ẕi'n yetó Kainán. ");
INSERT INTO ztyNTps_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainán na' goke' ẕi'n Enós. Bennen' goke' ẕi'n Set. Bennen' goke' ẕi'n Adán. Bennen' goke' ka ẕi'nkze Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bezá' Jesusen' žoa'a yego Jordán, zoaḻen Dios Be' La'y Ḻe', na' de chgi' bchi'e Jesusen' ḻo latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wzóe' ga na' chopḻalj ža, na' gónele da' x̱iwe' gonen ga baga' Jesusen' doḻa'. Bi be bdaw Jesusen' ža ka', na' wdé na' wdone'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Naž da' x̱iwen' gožen Jesusen', na' wnnán: —Cha' nakkzo' Le' Ẕi'n Dios, wnná yeyák yej ni yet x̱til. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bechebe Jesusen', na' gožen': —Nyejw ḻe'e yich da' ẕnnan: “Kégeze ḻen yet x̱til zej nban benách ka', san ḻezka' zej nbánḻene' yógo'te x̱tiža' Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Naž da' x̱iwen' bchen' Jesusen' gan nak to ḻaw ya'a sibe. To chí'ido'ze bḻoe'elen Ḻe' yógo'te latje gan ẕnna bia'gak benne' ka' dot yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Naž da' x̱iwen' gožen Jesusen', na' wnnán: —Yógo'te latje chegak benne' wnná bia' ka', na' yeḻa' wnni'a chégake', gonnan' chio', dan' yo'o ḻo na'a yógo'te da' ki, na' no benne' žénela' wneẕjwa' da' ka' chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Cha' Le' wzóa ẕibo' ḻawa', na' wká'n ẕeno' neda', yógo'te da' ki gaken chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naž Jesusen' gožen': —Kwas na'le, da' x̱iwe', dan' nyejw ḻe'e yich la'y dan' žen' neto', dan' ẕnnan: “X̱ano' Dios wká'n ẕeno', na' toze Ḻe' gono' x̱chine'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Naž da' x̱iwen' bchen' Jesusen' ḻo yež Jerusalén, na' bžian Ḻe' yichjo'o yodo', na' gožen Ḻe': —Cha' nakkzo' Le' Ẕi'n Dios, bex̱ite' ga ni ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","dan' nyejw ḻe'e yich la'y da' ẕnnan: Dios seḻe'e wbás che ya'abá ka', na' gákḻengake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ḻen ná'gake' góx̱wgake' Le' nich bi chejchego'o yej, na' bi gak zi' ni'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Naž Jesusen' gožen': —Nyejw ḻe'e yich la'y da' žen' neto': “Bi wkonlo' žin X̱ano' Dios.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kate' da' x̱iwen' bi bžeḻ-len yetó da' gonen ga baga' Jesusen' doḻa', na' bebigan' gan zoe' to chi'ido'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Beyéj Jesusen' gan nbab Galilea, na' nzi' ḻo ne'e yeḻa' wak che Dios Be' La'y. Wzé diža' kan nak chie', na' benách ka' nníta'gake' yógo'te yež dot gawze ga na' béngeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesusen' bsedle' benách ka' gan nak ḻo yo'o ka' gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' yógo'te benách ka' wdápegake' Ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Naž bežín Jesusen' ḻo yež Nasaret gan bgole'. Kate' bžin ža la'y chegak benne' judío ka', na' kan žónteze žon Jesusen', wyoé'e ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' wzíe' nich goḻe' to da' nyejw ḻe'e yich la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bdégake' yichen' ḻo na' Jesusen' gan nyejw da' wnná Isaías, bennen' bchaḻje' ḻo wláz Dios ža ni'te. Kate' bsaljwe' yichen', bežeḻ-le' gan nyejw da' ẕnnan: ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Zoaḻen Be' La'y che X̱anžon' neda' dan' wleje' neda' cheze' nich wzenla' benách yache' ka' diža' chawe'. Bseḻe'e neda' nich yeyona' benne' ka' žak zi' ḻáẕdo'gake', na' nich wzenla' benne' ka' zej nake' ka benne' zej nžeje' ni'a che doḻa' da' nbága'gake', kan gak yelágake', na' nich yeyona' benne' ḻo choḻe ka', na' nich yeslá' benne' ka' žsaka' zi'gak benách ka' ḻégake', ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na' nich wzía' diža' che ža gakḻen X̱anžo Dios benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Naž Jesusen' betobe' yichen', na' bedíen' ḻo na' bennen' žape chi'e yiche la'y ka', na' bebi'e. Naž yógo'te benne' zej ndobe' ḻo yo'on', belwíe' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wzó ḻaw Jesusen' ẕchaḻje', na' gože' ḻégake': —Na'a ža ni zoale ḻe'e, ba bžinkze dan' nyejw ḻe'e yichen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yógo'tegake' wnné cháwe'gake' chie', na' bebángekle' kan nak diža' chawen' da' ẕchaḻje', na' wnnágake': —¿Kege benne' ni ẕi'n Jwsé? ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naž Jesusen' gože' ḻégake', na' wnné': —Ye'le neda' da' ẕnnan: “Le', benne' žeyón benách ka', beyón kwino'.” Ḻezka' ye'le neda': “Da' ka' benlto' beno' Le' ḻo yež Kapernaum, ḻezka' ben ga ni naken lažo'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ḻezka' wnná Jesusen': —Da' li žapa' ḻe'e, cha' zoa no benne' ẕchaḻje' ḻo wláz Dios, benne' wláž chie' ka' bi žápegake' ḻe' ba la'ne. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Da' li žapa' ḻe'e, wnníta'gak no'le wzebe zan ža ni'te gan nbab Israel, ža ka' wzóa Lías, bennen' bchaḻje' ḻo wláz Dios. Kate' ža ka' bi gok yejw chonn yiz yo'o gachje, na' gok wbín ḻo yežlyón'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dios bi bseḻe'e Líasen' gan zej nnita' no'le wzebe ka' wnníta'gake' gan nbab Israel, san bseḻe'e ḻe' gan zoa to no'le wzebe ḻo yež Sarepta, da' nbaben yež Sidón, to yež zi'to'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ḻezka', wnníta'gak benne' zan ža ni'te gan nbab Israel, benne' ka' wdá'gake' yižwé' leže ža ka' wzóa Eliseo, bennen' bchaḻje' ḻo wláz Dios. Bi beyák nitó benne' ki ladjw benách Israel ka', san beyák toze Naamán, benne' zi'to' wbabe' ḻo yežlyó Siria. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kate' béngekle benne' ka' da' ni, benne' wnníta'gake' ḻo yo'o gan ẕdóbgake' nich yéngekle' x̱tiža' Dios, na' bžá'agake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naž ḻa' wzó žá'tegake', na' bebéjgake' Jesusen' žoa'a yež na'le. Belchi'e Ḻe' gan nak ḻe'e ya'a yej gan že' lážgake' nich wžíx̱jgake' Ḻe' gan nak ḻe'e ya'a yej na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wdé Jesusen' gachje ḻáwe'le gan nníta'gake', na' ḻa' beyejtie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Naž wyéj Jesusen' ḻo yež Kapernaum gan nbab Galilea, gan bsedle' benách ka' kate' nak ža la'y ka' chegak benne' judío ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bebángekle' kan nak dan' žsedle Jesusen' ḻégake', dan' ẕchaḻje' ka to benne' de ḻo ne'e yeḻa' wnná bia'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ḻezka' zoa to benne' yoe'e be' x̱iwe' ḻo yo'o gan ẕdóbgake' nich yéngekle' x̱tiža' Dios, na' wnníe' zižje, ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","na' wnné': —Bsan neto'. ¿Biẕ nbága'to' chio', Jesús, benne' Nasaret? ¿Zo'o nga nich wžía yi'o neto'? Nónbia'to' Le' No nako'. Benne' la'y che Dios nako'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Naž Jesusen' bdiḻe' be' x̱iwen', na' gožen': —Žize wzóa, na' bežój ḻo bennen'. Naž be' x̱iwen' wžo'nen bennen' ḻo yo ḻawgak benne' ka' nníta'gake' ga na', na' ḻa' bežojten ḻo bennen', san biž bi benen ḻen ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bebángekle' yógo'tegake', na' bchaḻjḻen ljéžgake', na' wnnágake': —¿Biẕ diža' ni dan' ẕchaḻjen'? Ḻen yeḻa' wnná bia', na' yeḻa' wak ẕen ẕdiḻe' be' x̱iwe' ka', na' ḻa' žežójtegaken. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wzé diža' che da' žon Jesusen', na' béngekle benách nníta'gake' yógo'te yež zej žen' dot gawze. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Naž Jesusen' ḻa' wzó ža'tie', na' bežoje' ḻo yo'o gan ẕdóbgake' nich yéngekle' x̱tiža' Dios, na' wyoé'e liž Smon. Zoa x̱na' ẕo'le Smon ga na', na' yoe'e da' ḻa. Góta'yoegekle' Jesusen' yeyone' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wbiga' Jesusen' gan die', na' bḻiže' da' ḻa da' yoe'e. Ḻa' bežojten. No'len' ḻa' wyastie', na' bsí'ni'e da' bdáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kate' ba ben wbíž ža la'y na', bžingak yógo'te benne' zóaḻengak benne' yižwé' ka' ḻégake', benne' ka' zej de'e yižwé' ka' che chégake'. Bedjwá'gake' benne' yižwé' ka' gan zoa Jesusen', na' Ḻe' bx̱oa ne'e ḻégake', na' beyone' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ḻezka' bežojgak be' zan, be' x̱iwe' ka' yo'ogak benách yižwé' ka'. Belbéžeya'a be' x̱iwe' ka', na' wnnágaken: —Le' nako' Ẕi'n Dios. Naž Jesusen' bdiḻe' be' x̱iwe' ka', na' bi bi'e latje nnégaken, dan' nnézgeklen nake' Ḻe' Benne' Criston'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kate' za' ža'ní' yetó ža, bžoj Jesusen' ḻo yež Kapernaum, na' wyeje' to latje dach. Benne' zan beyíljgake' Ḻe'. Kate' bžíngake' gan zoe', gónegekle' wséjwgake' x̱neze', nich bi yezé'e gan nníta'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naž Jesusen' gože' ḻégake', na' wnné': —Žon byenen cha'a gan zej nnita' yezika' yež ka', nich wchaḻja' diža' chawe' ga na' kan gak chó'ogake' gan ẕnna bia' Dios. Che ḻen bseḻe'e neda' nga. ");
INSERT INTO ztyNTps_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ki goken, bchaḻje' diža' chawen' ḻo yež ka' gan nbab Galilea, na' gan nak ḻo yo'o ka' gan želyenle benne' judío ka' x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kate' ne zoa Jesusen' žoa'a nisdo', dan' nzin' Jenesaret, bdobgak benne' zan dot kwite', nich yéngekle' x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naž Jesusen' bḻe'ele' chope barkw ẕóagaken ḻawe' nisdon' gan nak gawze gan de yo biž, na' benne' wẕén bel ka' zej nžoje' ḻo barkw ka', na' žeyíbgake' yix̱jw bel chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wžén Jesusen' to ḻo barkwn', dan' naken che Smon Bedw, na' wnnable' ḻe' kweken' yeláte'do' zí'to'le gan de yo bižen'. Naž Jesusen' wži'e ḻo barkwn', na' že'ze' ka', bsedle' benne' zan ka' nníta'gake' ḻo yo bižen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kate' beyóž bchaḻj Jesusen', naž gože' Smon, na' wnné': —Bsa' barkw ni ḻo nisdo' gan že' zilen, na' le wzala' yix̱jw bel chele, na' senle bel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Beží'i Smon na', na' gože' Jesusen': —Benne' wsedle, dot yele ba bento' žin, na' nitó bel bi na' sento', san ḻen diža' chio' wzála'to' yix̱jwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kate' bzála'gake' yix̱jwn', wẕéngake' bel zan, na' ba žekte žeza' yix̱jwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Naž bḻížgake' ljéžgake' ka', benne' ka' nníta'gake' yetó ḻo barkwn' nich yídgake', na' gákḻengake' ḻégake'. Katen' bžíngake' ga na', beschá'gake' žopte barkw ka' ḻen bel ka', na' ba žek lo'jgak barkw ka' ḻo nisle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kate' Smon Bedw bḻe'elen', naž bzoa ẕibe' ḻaw Jesusen', na' wnné': —Kwas ḻen neda', X̱an, dan' naka' benne' doḻa'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ki wnné' dan' ẕžebe Bedon' ni'a chegak bel zan ka', na' ḻezka' goken chegak benne' ka' žónḻengake' ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ḻezka' bžébegak Jakob ḻen Ẕwa, benne' ka' zej nake' ẕi'n Sebedeo, na' zej nake' ljež Smon Bedon'. Naž Jesusen' gože' Smon na', na' wnné': —Bi žebo'. Na'a so ḻawo' yedjó'o benách ka' nich gákgake' chia', gono' kan žono' ẕzeno' bel ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kate' ba besá'gake' barkw ka' gan nak yo bižen', belka'ne' yógo'ten ga na', na' jákḻengake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kate' wzóa Jesusen' to yež, bžin to benne' de'e yižwé' leže gan zoe'. Katen' bḻe'ele' Jesusen', byechwe' ḻo yote, na' góta'yoele' Ḻe', na' wnné': —X̱an, cha' žénelo', wak yeyono' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Naž Jesusen' bḻi ne'e, na' wdane' ḻe'. Gože' ḻe': —Žénela'. Yeyako' chawe'. Ḻa' bebižte yižwé' leže da' wdá' bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Naž Jesusen' gože' ḻe' bi wzenle' nitó benne' kan bene'. Gože' ḻe': —Wyéj, bejḻoé'el kwino' ḻaw bx̱oz, na' bejneẕjw che da' žeyón le' chawe' che yodo' kan ẕnna x̱tiža' Moisés, dan' wḻoe'elen ḻégake' ba beyako'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wzéḻe'e diža' che yeḻa' wak che Jesusen', na' bdobgak benne' zan gan zoe' Ḻe' nich yéngekle' x̱tiže'e, na' nich yeyone' ḻégake', na' yeké'e yižwé' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Naž Jesusen' bezé'e ga na', na' wyeje' to latje dach, gan bcháḻjḻene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yetó ža, kate' ne žsedle Jesusen' benách ka', že'gak benne' yodo' fariseo ka' ḻen benne' yodo' wsedle ka', ga na'. Zej nnita' benne' ka' ga na', benne' zej nžoje' yógo'te yež gan nbab Galilea, na' gan nbab Judea, na' ḻo yež Jerusalén. Nak bia' de ḻo na' Jesusen' yeḻa' wak che X̱anžo Dios dan' žeyone' benne' yižwé' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naž benne' ka' zej noe'e to da' del to benne' bi žak se'e bžíngake' ga na', na' wdíljgake' nakẕe góngake' nich kó'ogake' ḻe' ḻo yo'o, na' chíx̱jwgake' ḻe' ḻaw Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kate' bi bžéḻgekle' nakẕe góngaken' dan' zej nnita' benách zan ga na', naž wžéngake' yichjo'o yo'on', na' bsáljwgake' yichjo'on'. Btínnegake' dan' del benne' yižwén', na' belyíxjwe' ḻe' gachje ḻáwe'lgak benách ka', gan nak ḻaw Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kate' gókbe'ele Jesusen' kan žejḻé'gake' chie', gože' benne' yižwén': —Benne', ba benít ḻawa' doḻa' da' nbago'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Naž wzó ḻaw ẕza' ḻáže'gak benne' yodo' wsedle ka' ḻen benne' yodo' fariseo ka', na' wnnágake': —Benne' ni ẕnne' da' ẕzoan Dios cheḻa'ale. ¿Noẕkze benne' gak yenít ḻawe' doḻa'? Toze Dios gak yenít ḻawe' doḻa'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Žákbe'ele Jesusen' dan' ẕza' ḻáže'gake', na' gože' ḻégake': —¿Biẕ chen' ẕza' ḻáže'le da' ki? ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bi nak zede cha' no benne' ye'ze' benne' ni: “Ba benít ḻawa' doḻa' da' nbago'o” san nak zede gone' ga yeyase', na' se'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wḻoe'ela' ḻe'e nzi' ḻo na'a neda', Benne' Golje' Benách, yeḻa' wnná bia' yenít ḻawa' doḻa' yežlyó nga. Naž Jesusen' gože' bennen' bi žak se'e, na' wnné': —Žapa' le', wyase. Beywá' dan' delon', na' beyéj ližo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ḻa' wyaste benne' yižwén' ḻáwgake', na' beké'e dan' góta'len', na' zeyeje' liže', ẕka'n ẕene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bebángekle' yógo'tegake', na' bka'n ẕéngake' Dios. Ḻezka' ẕžébegake', na' wnnágake': —Na'a bḻe'elžo to da' žonen ga žebanlžo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wdé gok da' ni, Jesusen' bžoje' ga na', na' bḻe'ele' to benne' lie' Lebí, ži'e gan ẕchiẕjwe' lazgak benách, na' Jesusen' gože' ḻe': —Benḻen neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ḻa' wzó ža'te Lebín', na' bka'ne' yógo'te, na' wyéjḻene' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wdé na', ben Lebín' to yeḻa' waw che Jesusen' gan nak ḻo liže', na' wnníta'gak benne' zan ga na', benne' wechiẕjw ka' ḻen yebaḻe benne' ka' želbé'ḻene' ḻégake' gan žáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Naž benne' yodo' wsedle ka' ḻen benne' yodo' fariseo ka' wnnégake' chegak benne' wsedle ka' che Jesusen', na' wnnágake': —¿Biẕ chen' že'j žáwḻenle tẕen benne' wechiẕjw ka', na' yezika' benne' doḻa' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bechebe Jesusen', na' gože' ḻégake': —Benne' ka' nníta'gake' chawe' bi žon byenen chjake' ḻaw benne' žeyone' benách ka', san benne' yižwé' ka' žon byenen chjake' ḻaw bennen' žeyone' benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bḻa'a neda', kege nich wḻiža' benne' chawe' ka', san nich wḻiža' benne' doḻa' ka' nich yeyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naž benne' yodo' ka' wnnábgekle' Jesusen', na' wnnágake': —Benne' ka' žónḻengake' Ẕwa tẕen, na' benne' ka' žónḻengake' benne' yodo' fariseo ka' tẕen, žónteze žóngake' wbás, na' ẕcháḻjḻengake' Dios. ¿Biẕ chen' benne' ka' žónḻengake' Le' tẕen že'j žáwgake'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesusen' gože' ḻégake': —¿Wak gonle ga gongak benne' ka' wbás, benne' nníta'gake' lni che yeḻa' ẕchag na', kate' benne' ẕchag ne'e ne zóaḻene' ḻégake'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Žin ža kate' kwas benne' ẕchag ne'e gan nníta'gake'. Ža na' góngake' wbás. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Naž Jesusen' bsaka' ḻebe' kan nak da' ki, na' gože' ḻégake': —Bi chog nitó benne' to laže' kobe dan' ba ndian, nich kweje' x̱taka' dan' yedé'e ḻe'e to laže' gole. Cha' gone' ki, kégeze gak ditj laže' koben', san láže'don' dan' bžojen ḻe'e laže' koben' bi gon ḻeben laže' golen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ḻezka', bi ẕga'a nitó benne' x̱is uba kobe ḻo že'e yid gole. Cha' no benne' gone' ki, x̱is uba koben' wḻá'an že'e golen' da' naken yid, na' ḻalj x̱is uban', na' cwia yi' že'e yid golen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Che ḻen žaḻa' ka'ažo x̱is uba kobe to ḻo že'e yid kobe, na' žopten gak chí'igaken. ");
INSERT INTO ztyNTps_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Cha' zoa no benne' že'je' x̱is uba gole, bi yénetele' ye'je' x̱is uba kobe, dan' nne': “Nakže dẕi' x̱is uba golen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kate' nak to ža la'y chegak benne' judío ka', wdá Jesusen' gan de yel ẕoa' stribe, na' benne' wsedle chie' ka' ẕká'agake' bisto gan žia ẕoa' striben'. Belẕoben' ḻo ná'gake', na' bdáwgaken'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Naž benne' yodo' fariseo ka' wnnábgekle' ḻégake', na' wnnágake': —¿Biẕ chen' žonle da' bi žaḻa' gonžo ža la'y? ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bechebe Jesusen', na' gože' ḻégake': —¿Bi beḻ-le kan ben Dabí katen' wdone', na' ḻezka' beldón benne' ka' wnníta'ḻengake' ḻe'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wyoé'e ḻo yodo' che Dios, na' wẕi'e yet x̱til dan' ẕgó'ogake' ḻaw Dios, dan' bi žaḻa' gawžon, san de latje chégakze bx̱oz ka' gáwgaken', na' Dabín' bdawen', na' ḻezka' bneẕjwen' chegak benne' ka' bénḻengake' ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naž Jesusen' gože' ḻégake', na' wnné': —Neda', Benne' Golje' Benách, naka' X̱ane ža la'y. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yetó ža la'y chegak benne' judío ka', wyó'o Jesusen' ḻo yo'o gan ẕdóbgake' nich yéngekle' x̱tiža' Dios, na' bsedle' benne' ka' nníta'gake' ga na'. Ḻezka' zoa to benne' ga na', benne' nžeke' ne'e ḻi ža. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Benne' yodo' wsedle ka' ḻen benne' yodo' fariseo ka' ẕwíagake' Jesusen', nich ḻé'egekle' cha' yeyone' bennen' kate' nak ža la'y chégake', nich žéḻgekle' nakle gak yesbága'gake' Ḻe' ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Žákbe'ele Jesusen' dan' ẕza' ḻáže'gake', na' gože' bennen' nžeke' ne'e, na' wnné': —Wzó ža'. Wzé gachje ḻáwe'le nga. Ḻa' wzó ža'te bennen', na' wzíe' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Naž Jesusen' gože' benne' yodo' ka', na' wnné': —Nnabla' ḻe'e to diža'. ¿De latje kate' nak ža la'y gonžo da' naken chawe', cha' gonžo da' ẕinnj? ¿De latje yeslažo yeḻa' nban chegak benách ka', cha' yeka'ažon? ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Naž Jesusen' bwie' benne' ka' nníta'gake' dot kwite', na' gože' bennen' nžeke' ne'e: —Bḻi no'o. Naž bennen' bḻi ne'e, na' ḻa' beyakten. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Naž bža'agak benne' yodo' ka', na' béngake' toze diža' ḻa' ḻégakze' nich žéḻgekle' bi da' góngake' che Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kate' ža ka' wyéj Jesusen' gan nak to ḻaw ya'ado'. Katen' bžine' ga na', bḻiže' Dios, na' dot yele bcháḻjḻene' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kate' za' ža'ní', bḻiže' benne' ka' žónḻengake' Ḻe' tẕen, na' wžíe' chežinnoe' nich gákgake' wbás chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bḻiže': Smon, (bennen' ḻezka' lie' Bedw), Ndres, (benne' biche' Bedon'), Jakob, Ẕwa, Lip, Bartol, ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matío, Mas, Jakob, (ẕi'n Alfeo), Smon, (benne' že' ḻaže'e yež chie'), ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, (ẕi'n to benne' lie' Jakob), Judas Iskariote, (benne' wdíe' Jesusen' ḻo na'gak benne' ka' gótgake' Ḻe'). ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Naž Jesusen' bdínneḻene' benne' wbás chie' ka' tẕen ḻaw ya'adon', na' bžíngake' to gan nak lache', gan zej nnita' benne' zanže, benne' wsedle chie' ka'. Ḻezka' zej nnita' benne' zan ga na', benne' zej nžoje' yógo'te yež gan nbab Judea, na' ḻo yež Jerusalén, na' ḻo yeždo' ka' zej nnitan' žoa'a nisdo' gan zej nnita' yež Tiro, na' yež Sidón. Benne' ki bžíngake' ga na' nich wzé nággake' x̱tiža' Jesusen', na' nich yeyákgake' ḻo yižwé' che chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ḻezka' beyakgak benne' ka' ẕzáka'gake' dan' yó'ogake' be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Gónegekle yógo'te benne' zan ka' kángake' Jesusen' dan' žeyone' yógo'tegake' ḻen yeḻa' wak chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Naž bwia Jesusen' benne' wsedle chie' ka', benne' ka' nníta'gake' ga na', na' gože' ḻégake': —Ba nez ẕen naken chele ḻe'e, nak nyache' ḻáže'le na'a, dan' gata' latje chele gan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ba nez ẕen naken chele ḻe'e ẕdonle na'a, dan' weljle da' naken che Dios. ’Ba nez ẕen naken chele ḻe'e ẕbéžele na'a, dan' wẕížḻenle neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ba nez ẕen naken chele ḻe'e, dan' za' ža katen' benách ka' bi ḻé'egekle' ḻe'e chawe', yebéjgake' ḻe'e gan nníta'gake', na' nnégake' chele, na' gon dítjgekle' lale, na' nnágake' naken to da' dáche'ze dan' žónḻenle neda', Benne' Golje' Benách, tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Le soa ḻo yeḻa' ba nez ža na', na' le yebél, dan' nak ẕen da' gata' chele ya'abá che Dios. Ḻezka' x̱a x̱na' golte chégake' ka' béngake' da' ẕinnj chegak benne' ka' bcháḻjgake' ḻo wláz Dios ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Da' nyáche'ḻe'e gaken chele ḻe'e, benne' wnni'a ka', dan' ba de da' yebéḻenlele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Da' nyáche'ḻe'e gaken chele ḻe'e, žéljelele na'a, dan' tonle. ’Da' nyáche'ḻe'e gaken chele ḻe'e, žẕížele na'a, dan' gak nyache' ḻáže'le, na' kwež nyáche'le. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Da' nyáche'ḻe'e gaken chele ḻe'e, ẕnnagak yógo'te benách ka' chawe' chele. Ḻezka' bengak x̱a x̱na' golte chele ka', dan' wnnágake' chawe' chegak benne' wen ḻaže' ka', benne' wnnázegake' bcháḻjgake' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ḻezka' wnná Jesusen': —Žapa' ḻe'e, zoale nga, na' žénlele chia' neda', ẕnnia': Le ži'il benne' ka' bi ẕḻé'egekle' ḻe'e chawe'. Le nnab da' chawe' chegak benne' ka' ẕžá'agake' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Le nnable Dios gon chawe'e benne' ka' žóngake' ḻe'e ẕia. Le nnable' Ḻe' gákḻene' benne' ka' ẕnnégake' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cha' no benne' kape' cheḻá'a x̱ago', bze yecheḻá'a x̱agon'. Cha' no benne' ke'e laže' da' ẕoan x̱kožo'o, ḻezka' be' latje ke'e ẕon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cha' no benne' nnable' le' da' de chio', bneẕjwn chie'. Cha' ke'e da' naken chio', bi yennabon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ka žénelele gongak benách ka' chele, ḻezka' le gon chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Cha' nží'izelele benne' ka' zej nži'ile' ḻe'e, ¿biẕe da' nakže chawe' žonlen? Ḻezka' žongak benne' doḻa' ka', zej nži'ile' benne' ka' zej nži'ile' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Cha' žonle da' naken chawe' chégakze benne' ka' žóngake' chawe' chele, ¿biẕe da' nakže chawe' žonlen? Ḻezka' žongak benne' doḻa' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Cha' ẕnéẕjwzele chegak benne' ka' žéklele yebí'igake' chele, ¿biẕe da' nakže chawe' žonlen? Ḻezka' žongak benne' doḻa' ka', zoa bi da' ẕnéẕjwgake' chegak benne' ka' žóngake' doḻa', dan' zej nnezle' yebí'igake' dan' bnéẕjwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Neda' žapa' ḻe'e: le ži'il benne' ka' bi ẕḻé'egekle' ḻe'e chawe', na' le gon da' naken chawe' chégake'. Le wneẕjw chegak benách ka' ḻa'kze bi žéklele yebí'igake' chele. Cha' ki gonle, ẕen nak da' yebéḻenlen, na' gakle ẕi'nkze Dios, Benne' ẕente, dan' žone' da' naken chawe' chegak benách ka', benne' bi žaz ḻáže'gake', na' benne' ka' žóngake' da' kegle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Žaḻa' yeyache' ḻáže'lele benách ka', kan žon X̱ale Dios, žeyache' ḻáže'le' yógo'te benách. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ḻezka' wnná Jesusen': Bi nnele che lježle, na' bi nne no benne' chele. Bi yesbága'le lježle ẕia, na' bi yesbaga' no benne' ḻe'e ẕia. Le yenít ḻaw che lježle, na' Dios yenít ḻawe' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Le wneẕjw che lježle, na' Dios gonne' chele. Gónngake' chele da' wžíx̱gake' ḻen to kak da' ẕžix̱en, dan' nak bia' li, dan' nyižen, na' nyiten že'lte, na' zo dí'aten. Kan nak da' ẕžix̱le ḻe'e, ka'kze wžíx̱ Dios chele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Bzaka' ḻebe Jesusen', na' gože' ḻégake': —¿Wak to benne' ḻo choḻe chi'e yetó benne' ḻo choḻe? Bi gake', dan' žoptie' bíx̱gake' to ḻo bloj. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ḻezka', bi gakže blo to benne' wsedle, ka benne' žsedle' ḻe', san kate' yeyóž wsedle bennen', na' gake' kan nak bennen' žsedle' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Biẕ chen' ẕwio' bébedon' dan' yo'on yej ḻaw lježo', na' bi ẕḻe'elo' da' ẕen dan' yo'on yej ḻawo' le'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Wak yi'o lježon': “Bicha'a, benn latje yebeja' bébedon' dan' yo'on yej ḻawo'” na' bi ẕḻe'elo' da' ẕen dan' yo'on yej ḻawo' le'? Le', benne' ẕḻoé'ezele chawe' kwino'. Zga'ale bebéj da' ẕen dan' yo'on yej ḻawo' le'. Naž ḻe'elo' binlo nich gak yebejo' bébedon' dan' yo'on yej ḻaw lježon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ḻezka' wnná Jesusen': —To yag zaka' bi ẕbian da' bi nak ẕix̱, na' to yag ka'ze bi gak kwian da' nak ẕix̱. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ki naken, da' ẕbia to yag nak bian' kan nak yagen'. Bi ẕchibžo da' ẕbia yag higo ḻo yag yeche', na' ḻo yag yeche' bi ẕchibžo da' ẕbia lba uba. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Benne' chawe' ẕchaḻje' diža' chawe' dan' yo'o da' chawe' ḻo yichj ḻáẕda'we', na' benne' bi nake' chawe' ẕchaḻje' da' bi nak chawe' dan' yo'o da' bi nak chawe' ḻo yichj ḻáẕda'we'. Žoa'ažo ẕnnen kan nak da' yo'on ḻo yichj ḻáẕdo'žo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ḻezka' wnná Jesusen': —¿Biẕ chen' žḻižle neda', ẕnnale: “X̱anto', X̱anto'” na' bi žonle kan žapa' ḻe'e? ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wḻoe'ela' ḻe'e kan nak bennen' ze'e gan zoa', na' ženle' x̱tiža'a, na' žone' kan ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Benne' ni nake' ka to benne', kate' bene' liže', gže' bche'ne', na' bdix̱jwe' ḻen yo'o gan nak ḻo yej x̱e. Kate' wdé nis wbá'a zil, na' bche'nen kwit yo'on', bi gok wchinnjen yo'on', dan' žian ḻo yej x̱e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na'a, no benne' ženle' x̱tiža'a, na' bi žone' kan ẕnnan, benne' ni nake' ka to benne' bene' liže' gan nak doze yo, na' bi bdix̱jwe' ḻenen. Kate' bche'n nis wbá'a kwit yo'on', ḻa' wžía yi'ten belate ža. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kate' Jesusen' beyóž bcháḻjḻene' benne' ka' ki, wyeje' ḻo yež Kapernaum. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ḻo yežen' zoa to benne' yež Roma, benne' ẕchi'e benne' ka' žjake' ḻo wdiḻe, na' zoa to bi' wen žin chie' nží'iḻe'ele'-be'. Yo'o yižwé' x̱kwiden', na' ba žekte gatbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kate' benle bennen' da' ẕchaḻjgak benne' ka' kan nak che Jesusen', ḻa' bséḻa'tie' baḻe benne' gole, benne' judío ka', gan zoa Jesusen', nich chjéta'yoegekle' Ḻe' yide' yedjyene' bi' wen žin chien', x̱kwiden' yo'obe' yižwé'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bžingak benne' gole ka' gan zoa Jesusen', na' dot ḻáže'gake' góta'yoegekle' Ḻe', na' wnnágake': —Nak zi bennen' gono' da' ni chie', ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","dan' žape' ba la'ne benne' wláž chežo ka', na' bene' to yo'o chežo gan ženlžo x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naž Jesusen' wyéjḻene' ḻégake'. Kate' za' žíntegake' liž bennen', ḻe' bseḻe'e baḻe lježe' gan za' Jesusen', na' góžgake' Ḻe': —X̱an, wnná bennen': “Bi gek zedlo', dan' bi naka' zi cho'o liža'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ḻezka' bi naka' zi biga'a gan zo'. Che ḻen bi bežogla' ḻa'a gan zo'. To wnnaze, na' yeyakte bi' wen žin chian'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ḻezka' neda', zoa benne' ẕnna bi'e neda', na' ḻezka' zej nnita' benne' ka' žjake' ḻo wdiḻe, benne' ka' ẕchi'a neda' ḻégake'. Kate' žapa' toe': Wyéj ga na', žeje'. Kate' žapa' yetóe': Da ko' ni, ze'e. Ḻezka' kate' žapa' benne' wen žin chia': Ben žin ni, žonen'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kate' Jesusen' benle' da' ni, bebán ḻáže'le' che bennen', na' byechje', na' gože' benne' ka' zá'gake' x̱kóže'le', na' wnné': —Da' li žapa' ḻe'e, bi na' chejx̱aka'a nitó benne' Israel, benne' žejḻi'e chia' neda' kan žejḻé' benne' ni chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kate' bežingak benne' ka' gan zoa bennen' bseḻe'e ḻégake', bennen' ẕchi'e benne' ka' žjake' ḻo wdiḻe, na' belyoé'e liže', na' bḻé'egekle' ba beyák bi' wen žin na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wdé gok da' ni, zej Jesusen' ḻo yež Naín ḻen benne' wsedle chie' ka', na' benne' zan zjákḻene' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kate' bžine' žoa'a yežen', bḻe'ele' benne' ka' zej noe'e to x̱kwide' byo, bi' gat, nich chejkáche'gake'-be'. Bi'do' gaten' nakbe' x̱kwide' tlicha' che to no'le wzebe. Benne' zan, benne' wláž che no'len', nníta'ḻengake' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kate' X̱anžon' bḻe'ele' no'len', beyache' ḻáže'le' ḻe', na' gože' ḻe': —Biž kwežo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naž Jesusen' wbige'e ga na', na' wdane' dan' del bi'do' gaten'. Wlezgak benne' ka' zej noe'e-be', na' Jesusen' wnné': —X̱kwide' byo, žapa' le', beyase. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Naž bi'do' gaten' bebanbe', na' wže'be', na' wzó ḻawbe' ẕchaḻjbe'. Jesusen' beneẕjwe'-be' ḻo na' x̱na'be'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kate' bḻé'egekle benne' ka' da' ni, bžébegake', na' bka'n ẕéngake' Dios, na' wnnágake': —Bḻa' to benne' zaka' ga zoažo ni, benne' ẕchaḻje' ḻo wláz Dios. Dios na'kze žezá' ḻaže'e chežo, benne' chie' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wzé diža' che yeḻa' wak che Jesusen', na' béngekle benách ka' nníta'gake' yógo'te yež gan nbab Judea, na' yógo'te yež zej žen' gawze ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Benne' ka' žónḻengake' Ẕwa tẕen bzéngekle' ḻe' yógo'te da' ki, da' ka' žon Jesusen'. Ẕwan' bliže' chope benne' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na' bseḻe'e ḻégake' gan zoa Jesusen' nich nnábgekle' Ḻe', na' nnágake': ¿Nako' le' Benne' Criston', bennen' seḻa' Dios, o žaḻa' kwezto' benne' yoble? ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kate' benne' ka' bseḻa' Ẕwan' bžíngake' gan zoa Jesusen', góžgake' Ḻe': —Ẕwa, bennen' bezóe' benách ka' nis bseḻe'e neto', nich nnablto' Le', na' nnato': ¿Nako' le' Benne' Criston', bennen' seḻa' Dios, o žaḻa' kwezto' benne' yoble? ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ḻa' na'ze žeyón Jesusen' benne' zan, benne' yižwé' ka', ḻen benne' yó'ogake' be' x̱iwe' ka', na' ḻezka' benne' zan, benne' ḻo choḻe ka', bsaljwe' yej ḻáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bechebe Jesusen', na' gože' chope benne' ka' bseḻa' Ẕwan', na' wnné': —Le chej, chejzénlele Ẕwan' kan nak da' bḻé'elele, na' da' bénlele. Žeḻé'egekle benne' ka' gókgake' ḻo choḻe. Žeza'gak benne' ka' bi gok sá'gake'. Beyakgak benne' ka' wdá'gake' yižwé' leže. Žeyéngekle benne' ka' bkwéžjwgake'. Bebangak benne' gat ka'. Benne' yache' ka' žéngekle' diža' chawen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ba nez ẕen gaken che bennen' bi gak chope ḻaže'e, na' gónḻene' neda' tẕen ḻa'kze bi žona' kan žekle' žaḻa' gona'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kate' benne' ka' bseḻa' Ẕwan' bezá'gake' ga na', wzó ḻaw Jesusen' ẕzejni'ile' benne' ka' kan nak che Ẕwan', na' wnné': —¿No benne' bejwíale ḻo latje dachen'? ¿Bejwíale to benne' nake' ka to ya x̱til dan' ẕta be'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Noẕkze benne' bejwíale? ¿Bejwíale to benne' nakwe' laže' da' záka'ḻe'en? Nnézkzelele benne' ka' zej nakwe' laže' da' záka'ḻe'en, na' de yeḻa' wnni'a chégake' nníta'gake' ližgak benne' wnná bia' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Noẕkze benne' bejwíale? ¿Bejwíale to benne' ẕchaḻje' ḻo wláz Dios? O', žapa' ḻe'e. Ẕwan' nakže' blo ka to benne' ẕchaḻje' ḻo wláz Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nak Ẕwan' bennen' nyejw ḻe'e yich la'y kan nak chie' da' ẕnnan: Bwia nga, žseḻa'a benne' wbás chia'. Cheje' zga'ale' ka Le' nich wpé'e nez gan tio'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Neda' žapa' ḻe'e: gan zej nnita' benách ka', cha' zoa no benne' ẕchaḻje' ḻo wláz Dios, bi nakže' blo ka Ẕwan', bennen' bezóe' benách ka' nis, san no benne' nakže' nex̱jw gan ẕnna bia' Dios, bennen' nakže' blo ka Ẕwan'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kate' benne' gax̱jw ka' ḻen benne' wechiẕjw ka', béngekle' da' bchaḻj Ẕwan', gókbe'egekle' da' naken chawe' ḻaw Dios, na' bezóagake' nis ḻo na' Ẕwan', ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","san benne' yodo' fariseo ka' ḻen benne' yodo' wsedle ka', benne' ka' nzi' ḻo ná'gake' da' bchi'le Moisés, bi bezóagake' nis ḻo na' Ẕwan', na' ki goken, belka'ne' ka'ze da' chawe' da' gónele Dios gone' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ḻezka' wnná X̱anžon': —¿Nakx̱ wsaka' ḻeba' kan zej nak benne' ka' nníta'gake' ža ni zoažo na'a? ¿Nakx̱kze zej nake'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zej nake' ka x̱kwide' ka' želyitjbe'. Želbe'be' ḻawe' ya'a, na' želbéžeya'abe'. Želye'be' ljéžgakbe': “Ẕkwežto' bžejw ḻawle, na' bi žia'le. Žoḻ nyáche'to', na' bi ẕbéžele.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ki nakle dan' bḻa' Ẕwan', bennen' bezóe' benách ka' nis, na' bi bdawe' yet x̱til, na' bi we'je' x̱is uba, na' wnnele chie', na' wnnale: “Da' x̱iwe' žónḻenen ḻe' tẕen.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kate' bḻa'a neda', Benne' Golje' Benách, na' že'j žawa', ẕnnele chia': “Bennen' nake' benne' wawḻe'e, na' benne' že'je'. Nake' lježgak benne' wechiẕjw ka' ḻen yezika' benne' doḻa' ka'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Neda' žapa' ḻe'e: zej nak bia' benne' ka' zej nape' yeḻa' žejní'il che Dios ni'a che da' žóngake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","To benne' yodo' fariseo bḻiže' Jesusen' nich gáwḻene' ḻe' tẕen. Wyó'o Jesusen' liž bennen', na' wži'e, na' wzó ḻawe' žawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Zoa to no'le ḻe'e ḻo yežen', na' katen' benle' že'j žaw Jesusen' liž benne' yodo' fariseon', naž bḻe'e ga na', noe'e to béga'do' da' naken yej zaka', na' yožen to da' ẕḻa' ẕix̱. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Katen' bžine' zaka' x̱kóže'le Jesusen', wži'e x̱ni'e Ḻe', ẕbeže'. Naž wzó ḻawe' žesbise' ni'a Jesusen' ḻen nis ẕbeže', na' beẕíe' ni'e ḻen yicha' yichje'. Bnope'e ni'e, na' wloé'e dan' ẕḻa' ẕix̱ ḻo ni'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kate' benne' yodo' fariseon', bennen' bḻiže' Jesusen', bḻe'ele' da' ni, wzá' ḻaže'e, na' wnné': “Chela' nak benne' ni benne' ẕchaḻje' ḻo wláz Dios, gákbe'ele' da' nak no'le ni ẕgane' Ḻe', na' da' žone', dan' nake' no'le ḻe'e.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Naž Jesusen' gože' benne' fariseon', na' wnné': —Smon, de to da' žénela' yapa' le'. Beží'i bennen', na' wnné': —Wnná, benne' wsedle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesusen' gože' ḻe': —Wzóa to benne' wnni'a, na' wnníta'gak chope benne' zej nbage'e mežw chie'. To bennen' nbage'e chie' laẕjwe' che chopiz, na' yetóen' nbage'e chie' laẕjwe' che chop byo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dan' bi de mežw chégake' nich chíẕjwgake' dan' zej nbage'e chie', che ḻen benít ḻawe' che žoptie' dan' zej nbage'e chie'. Wnná na'a. ¿Noẕle benne' chope' ki ží'ižele' bennen' benít ḻawe' chégake'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Beží'i Smon na', na' wnné': —Žekla' neda', bennen' wbága'že' mežw chie', dan' benít ḻawe'. Jesusen' gože' ḻe': —Da' likze ẕnno'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Naž beyéchj Jesusen', na' bwie' no'len', na' gože' Smon na': —¿Ẕḻe'elo' no'le ni? Wyoá'a ližo', na' bi benno' nis da' chibla' ni'a, san no'le ni besbise' ni'a ḻen nis ẕbeže', na' beẕíe' ni'a ḻen yicha' yichje'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bi bzechw ḻawo' neda', san kate' za' bžintia' ližo', bi wzóa ži no'le ni, ẕnope'e ni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bi wló'o set yichja', san no'le ni wloé'e dan' ẕḻa' ẕix̱ ni'a. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Che ḻen žapa' le', doḻa' ẕen dan' wbaga' no'le ni, ba benít ḻawa' chie', na' nží'iḻe'ele' neda'. No benne' ženít ḻaw Dios chie' láte'do'ze, láte'do'ze nži'ile' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Naž Jesusen' gože' no'len', na' wnné': —Doḻa' wbago'o ba benít ḻawa' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Naž benne' ka' želbé'ḻene' Jesusen' tẕen gan žáwgake' wzó ḻáwgake' želyi'e ljéžgake', na' wnnágake': —¿Noẕkze benne' ni, ženít ḻawe' doḻa'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naž Jesusen' gože' no'len', na' wnné': —Dan' žejḻi'o chia' neda', ba beló'. Binlo beyéj ližo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wdé gokgak da' ki, wdé Jesusen' gan zej že' yež zan, yež ẕen ka', na' yeždo' ka', gan bchaḻje' diža' chawen' kan ẕnna bia' Dios, na' benne' chežínnote benne' wsedle chie' ka' zjákḻene' Ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ḻezka' baḻe no'le ka' zjákḻene' Ḻe', no'le ka' beyón Jesusen' ḻégake' kate' bebeje' be' x̱iwe' ka' yó'ogake', na' beké'e yižwé' ka' zej de'e. Lia, no'len' ḻezka' lie' Madlen, zoe' ládjwgake', no'len' bebéj Jesusen' gaže be' x̱iwe' wyoé'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ḻezka' Ẕwan, ẕo'le Chosa, benne' žape chi'e da' de liž Herodes, benne' ẕnna bi'e, zoe' ládjwgake', na' ḻezka' zoaḻen Susana ḻégake'. No'le ki želsí'ni'e da' žaw Jesusen' ḻen benne' wsedle chie' ka'. Ki žongak no'le ka' tẕen ḻen yezika' no'le ka', na' ẕnéẕjwgake' da' de chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ḻezka' benne' zan bžójgake' ḻo yež ka', na' bžíngake' gan zoa Jesusen'. Katen' bdóbgake' gan zoe', Ḻe' bsaka' ḻebe', na' gože' ḻégake': ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Bžoj to benne' žaz ža'ne' zjeze' bínnedo' ka'. Kate' ne zjeze', béx̱jwgak baḻe bínnedo' ka' gan nak nez las, na' wdegak benách ka' ga na', na' bléjgaken'. Ḻezka' bžingak byínnedo' ka', na' bdáwgakban'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Béx̱jwgak yebaḻe bínnedo' ka' ḻo yo gan že' yej. Kate' bḻa'gak bínnedo' ka', ḻa' belbižten dan' bi ngopa' yon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Béx̱jwgak yebaḻe bínnedo' ka' gan beḻa'gak lba yeche' ka'. Tẕen belgole lba yeche' ka' ḻen yagdo' ka'. Lba yeche' ka' beldóbgaken yagdo' ka' kate' bḻá'gaken, na' bžia yí'gaken yagdo' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Béx̱jwgak yebaḻe bínnedo' ka' gan nak ḻo yo beb. Katen' ba bgólgaken, bnéẕjwgaken. To ton bneẕjwn yetó gaywá' bínnedo' ka'. Kate' Jesusen' beyóž wnné' ki, zižje wnníe': —No benne' zoa nage', na' ženle', žaḻa' wzé nage'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Naž benne' wsedle ka' che Jesusen' wnnábgekle' Ḻe', na' wnnágake': —¿Biẕ žsedle dan' bsaka' ḻebo'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesusen' gože' ḻégake': —Dios ẕzejni'ile' ḻe'e da' ngache' kan ẕnna bi'e Ḻe', san yezika' benách ki, ẕcháḻjḻena' ḻégake' da' žsaka' ḻeba' nich kate' wíagake', bi ḻé'egekle', na' kate' yéngekle', bi chejní'igekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ḻezka' wnná Jesusen': —Ki nak da' žsedle dan' bsaka' ḻeba': Bínnedo' ka' zej naken x̱tiža' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bínnedo' ka' béx̱jwgaken ḻo nez las ẕḻoé'egeklen kan žak chegak benne' ka' želyenle' dižan', na' ḻa' za'te da' x̱iwe', na' žeká'n dižan' da' wyó'on ḻo yichj ḻáẕdo'gak benne' ka', nich bi chejḻé'gaken', na' nich bi yelágake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bínnedo' ka' béx̱jwgaken ḻo yo gan že' yej ẕḻoé'egeklen kan žak chegak benne' ka' želyenle' dižan', na' ḻen yeḻa' žebél želzi'en, san zej nake' ka bínnedo' ka' bi béngaken lwen. To chí'ido'ze žejḻé'gaken', dan' nža' ḻáẕdogake' da' žak chégake', na' ḻa' žsántegake' dižan'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bínnedo' ka' béx̱jwgaken gan beḻa'gak lba yeche' ka' ẕḻoé'egeklen kan žak chegak benne' ka' želyenle' dižan', na' kate' ba béngeklen', na' da' ka' žákgaken chégake' yežlyó nga žóngaken ḻégake' ḻo'e, da' ka' zej naken yeḻa' wnni'a chen, na' da' ka' ẕdan ḻáže'gake' da' žákgaken ga ni, na' dižan' bi žonen žin ḻo yichj ḻáẕdo'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bínnedo' ka' béx̱jwgaken gan nak ḻo yo beb ẕḻoé'egeklen kan žak chegak benne' ka' dot ḻáže'gake' žéngekle' dižan', na' ẕgo'o chóchgaken' ḻo yichj ḻáẕdo'gake', na' ḻo yeḻa' ẕbez ẕen ḻaže' chégake' žóngake' kan ẕnna dižan'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ḻezka' wnná Jesusen': —X̱tiža' Dios naken ka to yi'. Kate' to benne' ẕgale' yi', bi ẕdosen' kak, na' bi ẕgo'en ẕanle gan žate'e, san ẕzoen' sibe ḻo yo'o, na' yin' žsa'nín' benne' ka' žó'ogake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ḻa' ḻaw yógo'te da' ngache', na' gak bian', na' žoj ḻawle yógo'te da' žaken ži žize. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Che ḻen, le wzé nag, dan' gata' yelate' che benne' ẕzoa choche' da' ženle' ḻo yichj ḻáẕda'we', na' si'že' x̱tiža' Dios, san benne' bi ẕzoa choche' da' ženle' ḻo yichj ḻáẕda'we', na' yegá'a dižan' dan' benle'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naž bžin x̱na' Jesusen' tẕen ḻen benne' biche'e ka', gan zoe', san bi gok žíngake' ḻawe' Ḻe' dan' zej nnita' benne' zan ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","To benne' zoe' ga na' bḻiže' Jesusen', na' wnné': —X̱no'o ḻen benne' bicho'o ka' nníta'gake' ḻí'ale, na' žénegekle' wcháḻjḻengake' Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bechebe Jesusen', na' gože' ḻégake': —Benne' ki, benne' želyenle' x̱tiža' Dios, na' žóngake' kan ẕnnan zej nake' ka x̱na'kza', na' benne' bíche'kza' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","To ža wžén Jesusen' to ḻo barkw tẕen ḻen benne' wsedle chie' ka', na' Ḻe' gože' ḻégake': —Le cho'o yecheḻá'a nisdo' nga. Naž ḻa' zjaktie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kate' ne želdíe' ḻo nisdon', ẕtas Jesusen'. Naž wzó ḻaw žak to be' waḻe ḻo nisdon', na' ba žek yetj barkwn' ẕan nisle, na' de ẕož chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Naž wbíga'gake' gan de Jesusen', na' besbángake' Ḻe', na' wnnágake': —¡Benne' wsedle! ¡Benne' wsedle! Ba žek ḻo'ojžo ẕan nisle. Kate' bebán Jesusen', bḻiže' ben' žaken, na' nisen' da' ẕgo'nen, na' wzóa ži ben' goken, na' wžé' ži nisdon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Naž Jesusen' gože' benne' wsedle chie' ka', na' wnné': —¿Bi na' chejḻe'le che Dios? Bžébegake' ḻégake', na' bebángekle'. Gož ljéžgake' toe' yetóe': —¿Noẕkze benne' ni? Ẕdiḻe' be' dan' žaken, na' nisdo', na' žóngaken dan' ẕnne'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Naž bžin Jesusen' tẕen ḻen benne' wsedle chie' ka', gan nbab yež Gadara, da' žen' yecheḻa'ale nisdo' gan nbab Galilea. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kate' Jesusen' bežoje' ḻo barkwn' gan nak ḻo yon', bedjchág to benne' yežen' Ḻe'. Ba gok schaḻe'e yoe'e be' x̱iwe', na' biž žakwe' laže', na' biž ẕzoe' ḻo yo'o, san zoaze' ḻo bloj gan ẕkáche'gake' benne' gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kate' bennen' yoe'e be' x̱iwe' bḻe'ele' Jesusen', wnníe' zižje. Bzoa ẕibe' ḻaw Jesusen', na' wnné': —¿Biẕ nbaga'a chio', Jesús, Ẕi'n Dios, Benne' ẕente? Žáta'yoela' Le' bi wsaka' zi'o neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ki wnné' dan' Jesusen' ba gože' be' x̱iwen' yežojen ḻo bennen'. Zan chi'i be' x̱iwen' ba bchix̱ bḻol-ḻe'en bennen'. Benne' ka' che yežen' bchéjgake' ḻe' do ya, na' bzóagake' bayw ya ni'a ne'e, san bchoge' do ya ka', na' be' x̱iwen' da' yoe'e bchen' ḻe' ḻo latje dach. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naž Jesusen' wnnable' be' x̱iwen', na' wnné': —¿Bi lio'? Be' x̱iwen' gožen Ḻe': —Be' Zan lia'. Ki wnnán dan' yoe'e be' x̱iwe' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Naž be' x̱iwe' ka' góta'yoegeklen Jesusen' bi seḻe'e ḻégaken latje choḻ chegak benne' gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ḻezka' wzóa to kwe' koch zan ga na', želdaba' žáwgakba' ḻaw ya'adon', na' be' x̱iwe' ka' belnnáb nyachen' Jesusen' we'e ḻégaken latje chejžó'ogaken ḻo koch zan ka'. Jesusen' bi'e ḻégaken latje. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bežojgak be' x̱iwe' ka' ḻo bennen', na' bejžó'ogaken ḻo koch zan ka', na' jak koch ka' gan nak to ḻe'e ya'a yej ẕen. Bejbíx̱jgakba' ḻo nisdo', gan belyepba' nis. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kate' benne' ka' žape chí'igake' koch ka', bḻé'egekle' kan gok chégakba', bžébegake', na' bebángekle'. Beẕónnjgake' ga na', zeyéjgake' lážgake', na' bejzéngekle' benne' ka' nníta'gake' yežen', na' ḻezka' benne' nníta'gake' yix̱en'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Naž bžojgak benne' ka' nníta'gake' yežen', na' bejwíagake' dan' goken. Katen' bžíngake' gan zoa Jesusen', bḻé'egekle' bennen' wyoé'e be' x̱iwe' ka', ži'e x̱ni'a Jesusen'. Nakwe' laže', na' ba bezóe' cháwe'do', na' bžébegake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Benne' ka' nníta'gake' ga na' belzenle' ḻégake' kan goken, na' bḻé'egekle' ba beyák bennen' wyoé'e be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Naž yógo'te benne' zan ka', benne' wláž che yež ka' zej nbaben yež Gadara na', góta'yoegekle' Jesusen' yežoje' ḻo yežlyó chégake'. Ki béngake' dan' ẕžébegake'. Bebén Jesusen' ḻo barkwn', na' bezé'e ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bennen' bežojgak be' x̱iwe' ka' ḻe' góta'yoele' Jesusen' we'e ḻe' latje chéjḻene' Ḻe' tẕen. Jesusen' gože' ḻe' ga'ne' ga na', na' wnné': ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Beyéj ližo'. Bejzenle benách wláž chio' ka' ka nak da' ẕen da' ben Dios ḻen le'. Beyéj bennen' liže', na' bzie' diža' dot ḻo yež ka' kan nak da' ẕen da' ben Jesusen' ḻen ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kate' bežín Jesusen' yecheḻá'a nisdon', benne' zan, benne' nníta'gake' ga na', bebégekle' ni'a chie' Ḻe' dan' želbeze' yógo'tegake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naž bžin to benne' lie' Jairo gan zoa Jesusen'. Nake' benne' blo che to yo'o gan žéngekle benne' judío ka' x̱tiža' Dios. Bzoa ẕibe' ḻaw Jesusen', na' góta'yoele' Ḻe' cheje' liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ki bene' dan' zoa to x̱kwide' no'le chie', na' ba žek gatbe'. Nakbe' bi' tlícha'kze chie', na' zejbe' ka chežinno yiz. Kate' ne zej Jesusen' tẕen ḻen benne' zan ka', ẕchígake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Zej to no'le ladjw benne' zan ka', na' ba gok chežinno yiz ẕzáka'ḻi'e, dan' bi ẕbez žen chie', da' žaken chégakkze no'le ka', na' ba bdie' bika' da' de chie', dan' wdiẕjwe' benne' ka' žeyóngake' benách ka', san nitó benne' bi gok yeyone' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wbige'e zaka' x̱kože'l Jesusen', na' wdane' laže' da' nakwe', na' ḻa' wbižte yižwé' žen chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Naž Jesusen' wnnable' benne' zan ka', benne' nníta'gake' ga na', na' wnné': —¿Noẕ benne' wdane' neda'? Nitóe' bi bechebe'. Naž Bedw ḻen benne' ka' nníta'ḻengake' ḻe', góžgake' Jesusen', na' wnnágake': —Benne' wsedle, zej nnita' benne' zan ga ni, benne' ẕchígake' Le', na' ẕžíga'gake' Le', na' ẕnno': “¿Noẕ benne' wdane' neda'?” ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naž Jesusen' wnné': —Zoa no benne' wdane' neda', dan' gókbe'ela' bžoj yeḻa' wak neda', dan' žeyonen benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kate' gokbe'el no'len' nnezle Jesusen' dan' bene', ḻo yeḻa' ẕžebe wẕize'. Bzoa ẕibe' ḻaw Jesusen', na' gože' Ḻe' ḻawgak benne' zan ka' biẕ chen' wdane' laže' da' nakwe' Ḻe', na' kan goken, ḻa' beyaktie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Naž Jesusen' gože' ḻe': —Ẕí'na'do', dan' žejḻi'o chia' ba beyako'. Binlo beyéj ližo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kate' ne ẕnna Jesusen' da' ni, bžin to benne' wzé'e liž benne' blon', na' gože' bennen': —Ba got x̱kwide' no'le chio'. Biž gon ḻelo' benne' wsedle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kate' Jesusen' benle' da' ni, bechebe', na' gože' benne' blon': —Bi žebo'. Bejḻe'ze che Dios, na' yeyák x̱kwide' no'le chion'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kate' Jesusen' wyoé'e yo'on', bi bi'e latje no benne' chó'oḻene' Ḻe' san ḻégakze Bedw ḻen Jakob, na' Ẕwa, na' ḻezka' x̱a x̱na' x̱kwide' no'len'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Želbeže benne' ka' nníta'gake' ga na'. Želbeže nyache'e ni'a che x̱kwide' no'len', na' Jesusen' gože' ḻégake', na' wnné': —Biž kwéžele. Bi nat x̱kwide' no'len'. Ẕtászebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ben dítjgekle' Ḻe' dan' nnézgekle' ba natbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naž Jesusen' bex̱we' na'be', na' wnníe' zižje, na' wnné': —X̱kwide' no'le, beyase. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naž be' nakkzbe' beyó'on ḻebe', na' bebanbe', na' ḻa' wyástebe'. Jesusen' gože' ḻégake' wnéẕjwgake' da' gawbe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bebángekle x̱a x̱na'be', san Jesusen' bchi'le' ḻégake' bi wzéngekle' nitó benne' kan goken. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naž Jesusen' betobe' benne' chežinno, benne' wsedle chie' ka', na' bdie' ḻo ná'gake' yeḻa' wak, na' yeḻa' wnná bia', nich yebéjgake' be' x̱iwe' ka' yo'ogak benách ka', na' nich yeyóngake' benne' yižwé' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bseḻe'e ḻégake' nich chejzéngekle' benách ka' kan ẕnna bia' Dios, na' nich yeyóngake' benne' yižwé' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesusen' gože' ḻégake': —Bi be wa'le che ḻo nez, kege bardo', na' kege yix̱jw, na' kege yet, na' kege mežw, na' bi x̱oa yenle chope laže'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bíte'teze yo'o gan cho'ole, le soa ga na' kate' yezá'žele ḻo yežen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gáte'teze gan bi gápegak benách ka' ḻe'e ba la'ne, le yežój ḻo yežen', na' le kwib bix̱te da' dan' lable, dan' wḻoe'elen ḻégake' zej nbage'e ẕia. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Naž zjak benne' wsedle chie' ka'. Wdégake' yógo'te yeždo' ka', na' bcháḻjgake' diža' chawen', na' beyóngake' benne' yižwé' ka' nníta'gake' yógo'te yež ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Benle Herodes, bennen' ẕnna bi'e, kan nak yógo'te da' žon Jesusen', na' wžé' zedle', dan' ẕnnagak benách ka': —Bebán Ẕwa ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yebaḻe' ẕnnágake': —Beḻá' Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te. Yebaḻe' ẕnnágake': —Ba bebán to benne' wbabe' benne' ka' bcháḻjgake' ḻo wláz Dios ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes na' wnné': —Ẕwan' bchoga' yene'. ¿Noẕkze bennen', ženla' da' zan ki da' žone'? Herodes na' žak ḻáže'ḻi'e ḻe'ele' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kate' bežingak benne' wbás ka' che Jesusen', benne' ka' bseḻe'e chejségake' x̱tiže'e, na' bzéngekle' Ḻe' yógo'te da' béngake'. Naž Jesusen' bchi'e ḻégake' cheze. Jake' to latje dach gan nbab yež Betsaida. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kate' wnnézgekle benách ka' da' ni, wnáwgake' Jesusen', na' Ḻe' wdape' ḻégake' ba la'ne, na' bcháḻjḻene' ḻégake' kan ẕnna bia' Dios, na' beyone' benne' yižwé' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kate' za' žaḻe ža na', wbíga'gak benne' chežinno, benne' wbás ka' che Jesusen', gan zoe', na' góžgake' Ḻe': —Beseḻa' benách ki nich chjake' gan zej že' yeždo' ka', na' gan zej že' yo'odo' ka' dot gawze, nich chejtíḻjgake' gan gá'ngake', na' da' gáwgake', dan' nak latje dach ga zoažo ni. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naž Jesusen' gože' ḻégake': —Le waw-gake' ḻe'e. Góžgake' Ḻe': —Gáyo'ze yet x̱tildo' de, na' chopze bel cheton' de. ¿Chejto' chjé'wto' da' gawgak benne' zan ki? ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Zej nnita' ka gayo' mil benne' ka' ga na'. Naž Jesusen' gože' benne' wsedle chie' ka', na' wnné': —Le kwek chi-yóngake' to kwe' to kwe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ki béngake', na' wže'gak yógo'te benne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naž Jesusen' bex̱we' gayo' yet x̱til ka', na' chope bel ka'. Bchis ḻawe', ẕwie' ya'abale, na' gože' Dios: “Žóx̱keno'.” Naž bzoẕje' yet x̱til ka', na' bi'en che cheze benne' wsedle chie' ka' nich chísgaken' ḻawgak benne' zan ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bdáwgake' yógo'tegake', na' béljgekle'. Wdé na' betóbgake' da' biẕjw ka', na' beschá'gake' chežinno x̱kwit ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","To ža kate' ne zoa Jesusen' cheze gan ẕcháḻjḻene' Dios, na' žónḻengak benne' wsedle chie' ka' Ḻe' tẕen, wnnable' ḻégake', na' wnné': —¿Noẕen' ẕnnagak benách ka' naka' neda'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bechébegake', na' wnnágake': —Baḻe' ẕnnágake' nako' Ẕwa, bennen' bezóe' benách ka' nis. Yebaḻe' ẕnnágake' nako' Lías, bennen' bchaḻje' ḻo wláz Dios ža ni'te, na' yebaḻe' ẕnnágake' nako' to benne' wbabe' benne' ka' bcháḻjgake' ḻo wláz Dios ža ni'te, na' ba bebane' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naž Jesusen' wnnable' ḻégake', na' wnné': —Cheẕe ḻe'e, ¿noẕkze ẕnnale naka'? Bechebe Bedw, na' wnné': —Nako' Benne' Criston', bennen' bseḻa' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Naž Jesusen' besnisle' ḻégake', na' bchi'le' ḻégake' bi wzéngekle' nitó benne' No nake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naž gože' ḻégake': —Žon byenen sáka'ḻi'a neda', Benne' Golje' Benách, na' da' zan da' gaken chia'. Benne' gole ka' ḻen bx̱oz wnná bia' ka', na' benne' yodo' wsedle ka', wká'ngake' neda' ka'ze. Gótgake' neda', san kate' te chonne ža, Dios yesbane' neda' ḻo yeḻa' got. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ḻezka' gože' yógo'tegake': —Cha' no benne' žénele' gónḻena' neda' tẕen, žon byenen wzóe' cheḻa'ale da' naken chie', na' gake' ka to benne' noe'e yag kroze nich chejté'e ḻe'en. Naž gak gónḻene' neda' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","No benne' ži'e wnné yoe che yeḻa' nban chie', wniten', san benne' wnite' yeḻa' nban chie' dan' žónḻene' neda' tẕen, gata' yeḻa' nban da' zejlí kanne chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bi be da' chawe' gata' che to benne' cha' gape' yógo'te da' den yežlyó nga, san wnite' to chi'ize yeḻa' nban chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","No benne' žedoe'ele' neda', na' žedoe'ele' x̱tiža'a, ḻezka' neda', Benne' Golje' Benách, yedoe'ela' bennen' kate' yeḻá'a ḻen yeḻa' baní' che X̱a', na' ḻen yeḻa' baní' chegak wbás ka' che ya'abá che Dios nich nna bi'a. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Da' li žapa' ḻe'e, zej nnita' baḻe benne' nga, benne' bi na' gátgake' kate' ḻé'egekle' ža yedjnná bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kate' ba wdegak x̱ono' ža wdé bchaḻj Jesusen' da' ki, bchi'e Bedw ḻen Ẕwa, na' Jakob, na' wžene' to ḻaw ya'ado', gan bcháḻjḻene' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kate' ne ẕcháḻjḻene' Dios, bža' kan ẕnna' ḻawe', na' laže' da' nakwe' beyaken ẕíla'do'ze, na' wyepen yes baní'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Naž bḻa' ḻawgak chope benne' ka' gan zoa Jesusen', na' ẕcháḻjḻengake' Le'. Zej nake' Moisés ḻen Lías, benne' ka' wnníta'gake' ža ni'te. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Žoptie' belyepe' yes baní', na' ẕcháḻjḻengake' Jesusen' kan za' gate' ḻo yež Jerusalén, na' yezé'e yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ḻa'kze ẕnnaḻe'en tas Bedon', ḻen benne' ka' nníta'ḻengake' ḻe', na' ben byéngake' ḻé'egekle' yeḻa' baní' che Jesusen', na' chegak benne' chope' ka' nníta'ḻengake' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kate' žopte benne' ka' bezá'gake' gan zoa Jesusen', naž Bedon' gože' Ḻe': —Benne' wsedle, gak chawe' ga'nžo nga. Gonto' chonne yo'o laga', to chio', na' yetó che Moisés, na' yetó che Lías. Bi nnezle Bedon' dan' ẕnne'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kate' ne ẕchaḻje' da' ni, ḻa' wže'te to bejw ga na', dan' bkachen' ḻégake', na' bžébegake' dan' nníta'gake' ḻo bejwn'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Naž benle chi'i benne' ẕchaḻje' ḻo bejwn', na' wnné': —Benne' ni nake' Ẕi'na'. Nži'ila' Ḻe'. Le wzé nag da' yi'e ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kate' beyóž benle chi'i na', toze Jesusen' ngá'nḻene' ḻégake'. Benne' wsedle chie' ka' wnníta'gake' žize, na' ža na' bi góžgake' nitó benne' kan nak da' bḻé'egekle'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kate' za' ža'ní' yetó ža, Jesusen' ḻen benne' ka' nníta'ḻengake' Ḻe', bedínnegake' ḻaw ya'adon', na' za'gak benne' zan ga na', benne' ka' zedjchággake' Jesusen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","To benne' ladjw benne' zan ka' wnníe' zižje. Bḻiže' Jesusen', na' wnné': —Benne' wsedle, žáta'yoela' Le' yedjwío' x̱kwide' byo chia', dan' nakbe' tlícha'tekze bi' chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yo'obe' be' x̱iwe' da' ẕkwéžeya'an ḻebe', na' žẕizḻe'en ḻebe', na' ẕbia ẕene' zide' žoa'abe'. Ẕchix̱ ẕḻol-ḻe'en ḻebe', na' batkle žsanen ḻebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Góta'yoela' benne' wsedle chio' ka' yebéjgaken', san bi gókgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bechebe Jesusen', na' wnné': —Ḻe'e, benne' bi žejḻe'le chia', na' nyaḻ yichjle. ¿Gáka'tega žaḻa' sóaḻena' ḻe'e, na' gaka' ẕen ḻaže' ḻen ḻe'e? Le yedjwá' x̱kwide' byo chion' ga ni. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kate' ne za'be' ẕbíga'be' gan zoa Jesusen', be' x̱iwen' bchix̱ bḻol-ḻe'en ḻebe'. Jesusen' bdiḻe' be' x̱iwen', na' beyone' x̱kwide' byon'. Naž beneẕjwe'-be' ḻo na' x̱abe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bebángekle yógo'te benne' ka' ni'a che yeḻa' wak ẕen che Dios. Kate' ne žebángekle yógo'te benne' ka' kan nak da' ẕen da' žon Jesusen', Ḻe' gože' benne' wsedle chie' ka', ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","na' wnné': —Le kwek yichjle da' ni, dan' za' wdégake' neda', Benne' Golje' Benách, ḻo na'gak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bi bejní'igekle benne' wsedle chie' ka' da' ni, dan' bi na' wneẕjw Dios ḻégake' latje chejní'igeklen', san bi bežóggekle' nnábgekle' Jesusen' kan nak da' ni. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Naž wzó ḻawgak benne' wsedle ka' che Jesusen' ẕdiḻ díža'gake'. Želnnable ljéžgake' toe' yetóe' nole' gake' benne' blo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Žákbe'ele Jesusen' da' ẕza' ḻáže'gake', na' wdele' to x̱kwíde'do', na' bzoe'-be' kwite'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Naž gože' ḻégake': —No benne' gape' to x̱kwíde'do' ki ba la'ne dan' nakbe' chia', nedkzan' gape' ba la'ne, na' no benne' gape' neda' ba la'ne, ḻezka' gape' ba la'ne X̱a', Bennen' bseḻe'e neda'. Che ḻen, bennen' zoe' ládjwle, na' nakže' gax̱jw ḻaže', benne' ni nake' blo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Naž Ẕwa bḻiže' Jesusen', na' wnné': —Benne' wsedle, bḻe'elto' to benne' ẕkonle' žin lo' žebeje' be' x̱iwe' ka', na' bžonto' biž gonen' dan' bi žónḻene' žo'o tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesusen' gože' ḻe': —Bi wžonle gonen', dan' no benne' bi ẕži'e chežo, žákḻene' žo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kate' za' bawze ža žaḻa' gat Jesusen', na' yeyepe' ya'abá che Dios, ben byene' cheje' ḻo yež Jerusalén. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bseḻe'e benne' wbás chie' ka' nich chjake' zgá'alegake' ka Ḻe', na' jake' to yeždo' gan nbab Samaria, nich chejtíḻjgake' gan ga'ne' dot yele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Benne' ka' che yežen' bi wdápegake' Jesusen' ba la'ne dan' zeje' ḻo yež Jerusalén. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kate' Jakob ḻen Ẕwa, benne' wsedle ka' che Jesusen', bḻé'egekle' da' ni, góžgake' Ḻe': —X̱an, ¿nnablto' dinne yi' da' zan' ya'abá che Dios nich wžía yin' ḻégake', gonto' kan ben Lías? ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Byechj Jesusen', na' bdiḻe' ḻégake', na' wnné': —Bi nnézlele biẕ be' yo'ole. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Neda', Benne' Golje' Benách, bḻa'a nga, kege nich wžía yi'a yeḻa' nban chegak benách ka', san nich yeslá' ḻégake'. Naž jake' yež yoble. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kate' Jesusen' ḻen benne' ka' žónḻengake' Ḻe' tẕen ne yó'ogake' nez, bžin to benne' ga na', na' gože' Jesusen': —X̱an, žénela' sá'ḻena' Le' gáte'teze gan chejo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesusen' gože' ḻe': —Beza' ka', zej že' bloj chégakba', na' byínnedo' ka', žiagak x̱ó'ngakba' ka', san neda', Benne' Golje' Benách, bi de chia' gan gata'a nich yezí' ḻaža'a. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naž Jesusen' gože' benne' yoble, na' wnné': —Benḻen neda' tẕen. Bennen' gože' Ḻe': —X̱an, benn latje yeyá'a zga'ale liža', kate' wkáche'ža' x̱a'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesusen' gože' ḻe': —Be' latje benne' ka' za' gátgake' wkáche'gake' benne' gat ka' chégake', san le', wyéj, bejzenle benách kan ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Naž bžin yetó benne', na' gože' Jesusen': —X̱an, žénela' sá'ḻena' Le', san benn latje cha'a zga'ale nich chejzela' diža' lježa' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesusen' gože' ḻe': —No benne' že' ḻaže'e da' de yežlyó nga, nake' ka to benne' ẕga'ne' beže, na' ẕwie' x̱kóže'le'. Cha' no benne' žone' ki, bi nake' zi gone' žin che da' ẕnna bia' Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wdé gok da' ki, X̱anžon' wžíe' yechonnḻalj chi benne' wsedle chie' ka', na' bseḻe'e chope wéjgake' nich chjake' zgá'alegake' ka Ḻe' yógo'te yež ẕen ka', na' yeždo' ka', gan za' tie' Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gože' ḻégake': —Da' li, deḻe'e žin chia', da' naken ka to yežlyó ẕen gan žon byenen ḻapa', san babze benne' wen žin chia' nníta'gake'. Che ḻen, le gáta'yoele Dios, Bennen' nake' X̱an yežlyón', seḻe'e benne' wen žin ka' gan nak yežlyó chien'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Le chej na'a. Le wia, neda' žseḻa'a ḻe'e, na' nakle ka ẕila' ka' zjakba' ládjwgak beko' yix̱e' snia ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bi wa'le bzod mežw, na' kege yix̱jw yet, na' bi wa'le yetó kwe' ẕélele, na' bi žélele ḻo nez nich wcháḻjḻenle benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gáte'teze yo'o gan cho'ole, zga'ale nnale: “Da' ẕka'n chawe' yichj ḻáẕdo'žo gaken chegak benách nníta'gake' yo'o ni.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cha' zoa no benne' ga na', benne' ẕga'n chawe'e, da' ẕka'n chawe' yichj ḻáẕdo'žo da' nnablen gá'nḻenen ḻe', san cha' bi zoa no benne' ki ga na', da' ẕka'n chawen' da' nnablen gá'nḻenen ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Le ga'n ḻo yo'o gan cho'ole, na' le ye'j le gaw bi da' gónngake' ḻe'e, dan' žéḻkzele benne' wen žin da' gawe'. Bi tele to to yo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gáte'teze yež gan žinle, gan gápegake' ḻe'e ba la'ne, le ye'j le gaw bíte'teze da' gónngake' ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Le yeyón benne' yižwé' ka', benne' nníta'gake' ḻo yežen', na' le ye'-gake': “Ba bḻa' da' ẕnna bia' Dios gan zoale.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gáte'teze yež gan žinle, cha' bi gápegake' ḻe'e ba la'ne, le yežój ga na', na' le chejzé ḻo nez che yežen', na' nnale: ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bix̱te yo che lažle, da' dan' labto' ẕchinnjton', na' naken da' ẕḻoe'elen nbága'le ẕia, san žaḻa' nnézlele da' ni. Ba bḻa' da' ẕnna bia' Dios ga zoale ni.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neda' žapa' ḻe'e, kate' žin ža chog Dios chegak benách ka', sáka'žegak benách ka' che yežen' ka sáka'gak benách ka' wnníta'gake' ḻo yež Sodoma, yežen' bchinnj Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ḻezka' wnná Jesusen': —Da' nyáche'ḻe'e gaken chele ḻe'e, benách yež Korazín. Da' nyáche'ḻe'e gaken chele ḻe'e, benách yež Betsaida. Chela' gok ḻo yež Tiro, na' ḻo yež Sidón yeḻa' wak ẕen ka' ka da' ka' bena' gan zoale ḻe'e, ža ni'te yeyát ḻáže'gak benne' yež ka', na' wakw kwíngake' laže' ka'ze, na' kó'ogake' de yíchjgake', da' wḻoe'elen ba beyát ḻáže'gake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Che ḻen, kate' žin ža chog Dios chegak benách ka', sáka'žele ḻe'e ka sáka'gak benne' yež Tiro ka', na' benne' yež Sidón ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ḻe'e, benách ka' zoale ḻo yež Kapernaum. Gok chele kan wyeple gan cho'ogak benách ka' ya'abá che Dios. Na'a yetjle gan chejžo'ole latje choḻ chegak benne' gat ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Naž Jesusen' gože' benne' wsedle chie' ka', na' wnné': —No benne' ẕze nage' chele ḻe'e, ḻezka' ẕze nage' chia' neda', na' bennen' ẕka'ne' ḻe'e ka'ze, ḻezka' ẕka'ne' neda' ka'ze, na' bennen' ẕka'ne' neda' ka'ze, ḻezka' ẕka'ne' ka'ze X̱a', Bennen' bseḻe'e neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kate' chonnḻalj chi benne' ka' bseḻa' Jesusen' nich chejzéngekle' benách diža' chawen' bežíngake' gan zoe', na' wnnágake': —X̱an, be' x̱iwe' ka' žóngaken kan ẕnnato' kate' ẕkonlto' žin lo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesusen' gože' ḻégake': —Neda' bḻe'ela' da' x̱iwe', na' wbix̱en ẕan ya'abá kan žon yi' wzió', dan' žazen ḻo yo. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Le wia nga, neda' bdia' ḻo na'le yeḻa' wnná bia' nich gak góxwle bele snia ka', na' gox̱jní' ka', ḻen na'le, na' bi be gaken chele, na' nich wchinnjle yeḻa' wnná bia' che da' x̱iwe', dan' bi ẕḻe'elen žo'o chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na'a, le yebél, kégeze dan' žongak be' x̱iwe' ka' kan ẕnnale, san dan' zej nyejw lale ya'abá che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ḻa' na'ze bebél Jesusen', zoaḻen Dios Be' La'y Ḻe', na' wnné': —Ẕka'n ẕena' Le', X̱e, nako' X̱an ya'abá, na' X̱an yežlyó nga. Ki žona' dan' bkacho'o da' ki ḻawgak benne' ka' žákgake' da' ẕenḻe'e, na' ḻawgak benne' sina' ka', san bḻoe'elo' x̱kwide' ka' kan zej naken. Ka'kze gaken, X̱e, dan' ki žaz ḻažo'o Le'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Naž wnné': —Ba bde X̱a' yógo'te ḻo na'a. Bi zoa no benne' nnezle' no benne' nake' Ẕi'n Dios, san toze X̱ažo Dios nnezlen', na' bi zoa no benne' nnezle' no benne' nake' X̱ažo Dios, san toza' neda', Ẕi'ne', nnezlan', na' ḻezka' nnézgekle benne' ka' žénela' neda', Ẕi'ne', wḻoe'ela' ḻégake' X̱a'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Naž Jesusen' bwie' benne' wsedle chie' ka', na' gože' ḻégake': —Ba nez ẕen naken chegak benne' ka' ẕḻé'egekle' da' ẕḻé'elele ḻe'e, ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","dan' žapa' ḻe'e: benne' zan, benne' ka' bcháḻjgake' ḻo wláz Dios ḻen benne' wnná bia' ka', gónegekle' ḻé'egekle' da' ẕḻé'elele ḻe'e san bi bḻé'egeklen'. Gónegekle' yéngekle' da' žénlele ḻe'e, san bi béngeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Naž ḻa' wzó ža'te to benne' yodo' wsedle, na' nich si' bi'e Jesusen', wnnable' Ḻe', na' wnné': —Benne' wsedle, ¿biẕe žaḻa' gona' nich gata' yeḻa' nban da' zejlí kanne chia'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesusen' gože' ḻe': —¿Žejni'ilo' da' nyejw ḻe'e yich, dan' bchi'le Moisés? ¿Nakx̱ x̱bab žono' le' dan' žoḻo'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Beží'i bennen', na' wnné': —Ki ẕnnan: “Bži'il X̱ano' Dios dot ḻažo'o, na' ḻen dot yichj ḻaẕdo'o, na' ḻen dot yeḻa' žon chio', na' ḻen dot yeḻa' žejní'il chio', na' ḻezka' žaḻa' ži'ilo' lježo' kan nži'il kwino'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesusen' gože' ḻe': —Da' likze kan wnnó'. Ben ki, na' gata' yeḻa' nban na' chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dan' gónele bennen' yebéj chawe' kwine', gože' Jesusen': —¿Noẕ benne' nake' lježa'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bechebe Jesusen', na' gože' ḻe': —To benne' wzé'e ḻo yež Jerusalén, na' bdinne', zeje' yež Jerikó. Ḻo nezen' béx̱wgak benne' wbán ka' ḻe'. Btínnegake' ẕe', na' béngake' ḻe' we'. Naž bezá'gake' ga na', na' bká'ngake' ḻe' ba žatkze'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naž wdé to bx̱oz ḻo nezen'. Kate' bḻe'ele' bennen' žie' we', cheḻa'ale wdíe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ḻezka' to benne' nbabe' ẕa'só Lebí, benne' ka' žóngake' žin che yodo', wdíe' ga na'. Kate' bḻe'ele' ḻe', ḻezka' wdíe' cheḻa'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ḻezka' to benne' nbabe' Samaria yoe'e nezen', na' bžine' gawze gan de bennen' žie' we'. Kate' bḻe'ele' ḻe', beyache' ḻáže'le' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wbige'e gan die', na' bdebe' set, na' x̱is uba waḻ ḻo we' chie', na' bcheḻen' laže'. Naž bžie' ḻe' x̱kože' bia chie', na' bchi'e ḻe' ḻo yo'o gan želžín benne' ka' yó'ogake' nez, gan wdape chi'e ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yetó ža kate' ba ža'ní', katen' za' yezá' benne' Samaria na' ga na', wleje' laẕjwe' che chope ža, na' bka'nen' ḻo na' benne' x̱an yo'on', na' gože' ḻe': “Wdape chi'i benne' ni, na' cha' senžo' mežw, neda' yeyiẕjwan' le' kate' yeḻá'a.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na'a, ¿nakx̱ x̱bab žono' le'? ¿Nole benne' chonne ki goke' ljež bennen' bengak benne' wbán ka' ḻe' ẕia? ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bechebe benne' yodo' wsedlen', na' gože' Jesusen': —Bennen' beyache' ḻáže'le' ḻe'. Naž Jesusen' gože' ḻe': —Wyéj na'a, na' ben ki. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naž Jesusen' beyoé'e nez, na' bžine' to yeždo' gan zoa to no'le lie' Marta, na' no'len' bchi'e Ḻe' liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martan' zoa no'le bile' lie' Lia, na' Lian' wži'e x̱ni'a Jesusen', na' bze nage' x̱tiže'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martan' wžé' zedle' dan' žónḻi'e žin. Wbige'e gan zoa Jesusen', na' gože' Ḻe': —X̱an, ¿bi žeyache' ḻáže'lo' neda' dan' bka'n bi' bila' ni neda', na' toza' žona' žin? Gož-be' gákḻenbe' neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bechebe Jesusen', na' gože' ḻe': —Marta, Marta, že' zedlo', na' da' zan da' že' ḻažo'o žonon'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Toze da' žon byenen gonžon, na' Lia ni wžebe' dan' nakže chawe', na' dan' wžebe' bi yegá'n. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","To ža na' Jesusen' ẕcháḻjḻene' Dios. Katen' beyóž bcháḻjḻene' Ḻe', to benne' wsedle chie' gože' Ḻe', na' wnné': —X̱an, bsedle neto' wcháḻjḻento' Dios, kan ben Ẕwa, bsedle' benne' ka' žónḻengake' ḻe' tẕen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naž Jesusen' gože' ḻégake': —Kate' wcháḻjḻenle Dios, žaḻa' nnale ki: X̱ato', zo' ya'abá, ga'n ẕen lo'. Da, nna bi'o nga. Žénelto' gak yežlyó nga kan žaz ḻažo'o Le', kan žaken ya'abá chio'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Benn da' gawto' na'a ža. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Benít ḻaw cheto' doḻan' nbága'to' kan neto' ženít ḻawto' che no benne' bi da' žone' cheto'. Bi go'o latje gon da' x̱iwe' ga bága'to' doḻa', san beslá neto' ḻo da' žonen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ḻezka' Jesusen' gože' ḻégake': —Cha' zoa no benne' ládjwle, benne' zoa lježe', na' cha' žin to benne' liže' gachje yele, naž cheje' gan zoa lježen', na' wḻiže' ḻe', na' nne': “Bicha'a, benngaž neda' chonne yet x̱til, ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","dan' to benne' ze'e zi'to' ba bḻe'e liža', na' bi be de da' wa'a-ne' gawe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Yechebe bennen' yoe'e ḻo yo'on', na' yi'e ḻe' ki? “Bi gon ḻelo' neda'. Ba nyejw yo'o, na' bi' chia' ka' ba déḻengakbe' neda'. Bi gak chasa' nich bi da' gonna' chio'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Neda' žapa' ḻe'e: ḻa'kze bi chase' nich bi da' wneẕjwe' chie' dan' nake' lježe', san chase', na' wneẕjwe' chie' ka da' žiážjele' nich bi gon ḻelže' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Che ḻen žapa' ḻe'e: Le nnab, na' Dios gonne' chele. Le chilj, na' žeḻ chele. Le wḻíž ža yo'o, na' yaḻjwn chele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","No benne' bi da' ẕnnabe', ẕzi'en, na' bennen' bi da' žilje', ẕžeḻ-len', na' bennen' žḻiže' ža yo'o, žaljwn chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Cha' zoa no benne' ládjwle, benne' nake' x̱a x̱kwide', na' cha' nnablbe' ḻe' yet x̱til, ¿wneẕjwe' chebe' yej? Cha' nnablbe' ḻe' to bel, ¿wneẕjwe'-be' bele? ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Cha' nnablbe' ḻe' to x̱chit bežjw, ¿wneẕjwe'-be' gox̱jní'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ki naken, cha' ḻe'e bi nakle chawe', san nnézlele wnéẕjwle chegak ẕi'nle ka' da' naken chawe', wak wx̱én ḻáže'žele X̱ale zoe' ya'abá gonne' Dios Be' La'y chele, nol-le nnáblele Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","To ža Jesusen' bebeje' be' x̱iwe' da' yo'o to benne', dan' žonen ga bi žak nnie'. Kate' bežój be' x̱iwen', bchaḻj bennen' bi gok nnie', na' bebángekle benách ka' wnníta'gake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Baḻe benne' ka' wnnágake': —Žebeje' be' x̱iwe' ka' ḻen yeḻa' wak che Belzebú da' x̱iwe', x̱angak be' x̱iwe' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gónegekle yebaḻe benne' ka' si' biá'gake' Jesusen', na' belnnable' Ḻe' gone' to da' gak bian' da' zan' ya'abá che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gókbe'ele Jesusen' da' žénegekle' góngake', na' gože' ḻégake': —Gáte'teze gan zej nnita' benne' wnná bia' ka', cha' žoj chóplegak benne' ka', kwia yí'gake'. Cha' žoj chóplegak benách ka' nníta'gake' to yo'o, yeyóž chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ḻezka' žak che da' x̱iwe', dan' nzin' Belzebú. Cha' žoj chóplegak benne' ka' yó'ogake' ḻo nan', ¿nakx̱ gak dia' yeḻa' wnná bia' chen? ¿Na'a nnale žebeja' be' x̱iwe' ka' ḻen yeḻa' wak che Belzebú? ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cha' neda' žebeja' be' x̱iwe' ka' ḻen yeḻa' wak che Belzebú, ¿noẕkze benne' žonne' yeḻa' wak chegak benne' ka' žónḻengake' ḻe'e tẕen, nich žebéjgake' be' x̱iwe' ka'? Che ḻen, da' žongak benne' ka' nak bian' nchíx̱ele ḻe'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cha' neda' žebeja' be' x̱iwe' ka' ḻen yeḻa' wak che Dios, da' li ba bḻa' da' ẕnna bia' Dios gan zoale. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Kate' to benne' waḻe nzi' ḻo ne'e da' ẕdíḻ-ḻene', na' žape chi'e liže', da' ka' nape' zej nga'nen chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Na'a, cha' za' yetó benne', bennen' nakže' waḻe ka ḻe', wléj wchochje' ḻe', na' yeké'e yógo'te da' ẕdíḻ-ḻene', dan' žx̱en ḻaže'en, na' chise' da' gota' che bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Cha' zoa no benne' bi žónḻene' neda' tẕen, nake' benne' ẕži'e chia' neda'. Cha' zoa no benne' bi ẕtóbḻene' neda', žóslase'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ḻezka' wnná Jesusen': —Kate' žežój to be' x̱iwe' ḻo benne', ẕdan gan nbiže, žiljen gan yezí' ḻažen'. Cha' bi žeḻ chen, naž nnan: “Yeyá'a gan bžoja'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kate' žežinen ga na', žejx̱akan' bennen', nake' ka to yo'o da' ba nloan, na' ba nba'an nich no benne' chejsóe' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naž chejen, na' chejx̱ín' yegáž be' x̱iwe' ka', da' ka' zej nakžen x̱iwe', na' chó'ogaken bennen'. Na'a, da' gaken che bennen' gakžen zi' ka dan' goken chie' zga'ale. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kate' ne ẕchaḻj Jesusen' da' ni, to no'le zoe' ladjw benne' zan ka' wnníe' zižje, na' wnné': —Ba nez ẕen naken che no'len' bi'e Le' ḻo ḻi'e, na' ḻezka' naken che lcho' no'len' gan gožo'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bechebe Jesusen', na' wnné': —Ba nez ẕenže naken chegak benne' ka' želyenle' x̱tiža' Dios, na' žóngake' kan ẕnnan. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kate' ne želžingak benne' zan gan zoa Jesusen', wzó ḻawe' ẕchaḻje', na' wnné': —Benne' wen da kegle ki želnnable' neda' gona' to da' gak bian' gan za' yeḻa' wak chia'. San bi be da' gak bian' ḻé'egekle'. Toze da' gak bian' kan gok che Jonás ḻé'egeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dan' goken che Jonasen' gok to da' nak bian' ḻawgak benne' ka' wnníta'gake' ḻo yež Nínibe. Ḻezka' gaken chia' neda', Benne' Golje' Benách. Gaka' to da' nak bian' ḻawgak benne' ka' nníta'gake' ža ni zoažo na'a. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kate' žin ža chog Dios chegak benách ka' da' sáka'gake', katen' wchi'a ḻaže'e benne' ka' nníta'gake' ža ni zoažo na'a, Dios yechise' no'len' wzóe' ža ni'te, no'len' wnná bi'e benách ka' che yežlyón' da' žen' cheḻá'a gan ẕde wbíž byo' zag ka'. Da' ben no'len' wḻoe'elen zej nbaga' benne' ki ẕia. Ki gaken dan' bžoj no'len' gan nak zi'to' nich wzé nage' diža' che yeḻa' žejní'il da' bchaḻj Salomón, benne' wnná bi'e benne' Israel ka'. Na'a, zoa' neda' nga, na' nakža' blo ka gok Salomón na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ḻezka', Dios yechise' benne' ka' wnníta'gake' ḻo yež Nínibe kate' žin ža choge' chegak benách ka', katen' wchi'a ḻaže'e benne' ka' nníta'gake' ža ni zoažo na'a. Da' bengak benne' Nínibe ka' wḻoe'elen zej nbaga' benne' ki ẕia. Ki gaken dan' beyát ḻáže'gak benne' ka' wnníta'gake' ḻo yež Nínibe katen' béngekle' da' bchaḻj Jonasen'. Na'a zoa' neda' nga, na' nakža' blo ka gok Jonasen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ḻezka' wnná Jesusen': —Kate' no benne' ẕzalje' yi', bi ẕgo'en gan ngache', na' bi ẕdosen' ẕan kak, san ẕzoen' sibe gan ḻa'ten, nich wza'nín' chegak benne' ka' želyoé'e ḻo yo'on'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Zej nak yej ḻawžo ka to da' ẕgo'on baní' ḻo yichj ḻáẕdo'žo. Cha' yej ḻawo' zej naken chawe', dotio' nžan' da' naken baní'. San cha' yej ḻawo' bi zej naken chawe', dotio' nžan' da' naken choḻ. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wdape chi'i kwino' cha', nich dan' ẕgo'on baní' ḻo yichj ḻaẕdo'o bi yeyaken choḻ. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ki naken, cha' dotio' nžan' da' naken baní', bi be da' naken choḻ zóaḻenen le', na' ḻe'elo' binlo yógo'te, kan žak kate' ẕza'ní' yi' gan zo'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kate' beyóž bchaḻj Jesusen' da' ni, to benne' yodo' fariseo bḻiže' Ḻe' nich chejtáwḻene' ḻe'. Kate' Jesusen' wyoé'e liž benne' yodon', wži'e, na' wzó ḻawe' že'j žawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kate' benne' yodo' fariseon' bḻe'ele' Ḻe', bebanle' dan' bi wdíb Jesusen' ne'e kate' za' gawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naž X̱anžon' gože' ḻe': —Ḻe'e, benne' yodo' fariseo ka', žib kwinle kan žible ḻawle da' že'j žáwḻenle, san ḻo yichj ḻáẕdo'le nža'le da' kegle ka', na' ẕza' ḻáže'le da' bi naken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ḻe'e bi žejní'ilele. ¿Bi nnézlele, Dios, Bennen' ẕḻe'ele' da' zoa ḻawle ḻezka' ẕḻe'ele' da' yo'o ḻo yichj ḻáẕdo'le? ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Na'a, le wneẕjw benne' yache' ka' che da' naple. Naž yógo'te da' naple yeyaken chawe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' fariseo ka'. Žíẕjwle che yodo' to kwe' che to chi kwe' da' ẕzi'le che yix̱e' weje, na' che yix̱e' rod, na' chegak yix̱e' kwando', san to ẕdézele da' naken chawe', na' yeḻa' nži'il chele Dios. Da' ki žon byenen gonle, na' bi wka'nle yezika' da ka' žonle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' fariseo ka'. Žénelele kwe'le gan nak blo ḻo yo'o gan žoḻ-le x̱tiža' Dios. Ḻezka' žénelele gápegak benne' ka' ḻe'e ba la'ne ḻawgak benách ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', na' ḻe'e, benne' yodo' fariseo ka', benne' ẕḻoé'ezele chawe' kwinle, dan' nakle kan zej nak yežw ba ka' chegak benne' gat ka', da' ka' bi zej nḻa' ḻawn, na' želdá benách ka' ḻáwlegaken, na' bi žákbe'egeklen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naž beží'i to benne' yodo' wsedle, benne' žake' da' bchi'le Moisés, na' gože' Jesusen': —Benne' wsedle, kate' ẕnno' ki, ḻezka' neto' žon zi'o. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesusen' gože' ḻe': —Ḻezka' da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', žakle da' bchi'le Moisés. Ki naken dan' žesbága'le benách ka' to ywa' zi'i da' bi gak no benne' we'en, san ḻe'e ni láte'ze bi ẕdalen' ḻen ni'a na'le. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Da' nyáche'ḻe'e naken chele ḻe'e, dan' ẕzoale da' x̱tan ka' ḻawgak yežw ba ka' gan zej ngache' benne' ka' bcháḻjgake' ḻo wláz Dios, na' betgak x̱a wdé chele ka' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ki naken, ẕzoa lile žónḻenle tẕen da' bengak x̱a wdé chele ka', dan' betgak x̱a wdé chele ka' ḻégake', na' ḻe'e ẕzoale da' x̱tan ka' ḻawgak yežw ba ka' gan zej ngache'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Che ḻen, ḻo yeḻa' žejní'il chie', Dios wnné' ki: “Seḻa'a benne' ka' wcháḻjgake' ḻo wlaza' neda', na' benne' wbás chia' ka', gan zoale, na' benne' ki, gotle baḻe', na' kwia ḻáže'le yebaḻe'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ki gon Dios dan' choge' chegak benách ka' nníta'gake' ža ni zoažo na'a gátgake' ni'a che žen chegak yógo'te benne' ka' bcháḻjgake' ḻo wlaze' Ḻe'. X̱a wdé chele ka' bétgake' benne' ka' kate' wzó ḻaw žata' yežlyó nga, ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kate' wzó ḻaw wzóa bennen' bete' Abel, ẕi'n Adán, na' zejte bétgake' Secría. Bétgake' ḻe' gachje ḻáwe'le gan de bkog la'y gan ẕzéygake' bia beždo' ka' ḻaw Dios, na' gan zoa latje la'y. Che ḻen, žapa' ḻe'e, Dios choge' chegak benne' ka' nníta'gake' ža ni zoažo na'a gátgake' ni'a che žen chegak yógo'te benne' ka', dan' x̱a wdé chele ka' bétgake' ḻégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Da' nyáche'ḻe'e naken chele ḻe'e, benne' yodo' wsedle ka', žakle da' bchi'le Moisés. Ḻa' ḻé'ezele nzi' ḻo na'le ẕi'n ya che latje gan ẕžeḻ-lžo yeḻa' žejní'il. Ḻe'e bi žo'ole, na' žséjwle x̱nezgak benne' ka' žénegekle' chó'ogake' ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kate' beyóž bchaḻjḻen Jesusen' ḻégake' da' ni, benne' yodo' wsedle ka' ḻen benne' yodo' fariseo ka' bžá'aḻe'egake' Ḻe', na' wzó ḻáwgake' želnnable' Ḻe' kan nak da' zan da' žákgaken, ");
INSERT INTO ztyNTps_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nich kwéjgake' Ḻe' diža' nich gak yesbága'gake' Ḻe' ẕia ni'a che da' yechebe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ḻa' ža na'ze bdobgak zan gaywá' benách gan zoa Jesusen', na' zejte wléj ljéžgake'. Naž wzó ḻaw Jesusen' ẕcháḻjḻene' benne' wsedle chie' ka', na' wnné': —Le gape chi'i kwinle che da' naken ka kwa zichj che yet x̱til chegak benne' yodo' fariseo ka', dan' naken yeḻa' ẕḻoé'ezele chawe' kwin chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bi be de da' žaken ži žize dan' bi ḻa' ḻawlen, na' bi be de da' ngachen' dan' bi gak bian'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Che ḻen, yógo'te da' ba wnnale gan nak choḻ, yéngekle benách ka' gan nak ḻo baní', na' da' bchaḻjle ngáche'ze gan wzóa ḻo yo'o nyejwn, gaken da' wchaḻjgak benách ka' ḻawgak yógo'te benách. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ḻezka' wnná Jesusen': —Žapa' ḻe'e, ẕí'na'do' ka': bi žébele benne' ka' žótgake' benách ka', san te na' biž bi gak góngake' chégake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wḻoe'ela' ḻe'e no benne' žaḻa' žébele. Le žebe Bennen' gak ke'e yeḻa' nban chele, na' te na' nape' yeḻa' wnná bia' cho'ne' ḻe'e ḻo yi' gabíl. O', žapa' ḻe'e, le žebe Bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Žóte'gake' gayo' byínnedo' ka' ḻen chope mežw lasdo', san Dios bi žaḻ ḻaže'e nitoba'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ḻézka'kzen, yógo'te yicha' yichjle zej nbaben ḻaw Dios. Che ḻen, bi žébele. Záka'žele ḻe'e ka byínnedo' zan. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ḻezka' wnná Jesusen': —Žapa' ḻe'e: yógo'te benne' ka' ẕnnágake' zej nake' chia' neda' ḻawgak benách, ḻezka' neda', Benne' Golje' Benách, nnia' zej nake' chia' ḻawgak wbás che ya'abá ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Benne' ka' ẕnnágake' bi zej nake' chia' neda' ḻawgak benách, ḻezka' neda' nnia' bi zej nake' chia' ḻawgak wbás che ya'abá ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Yógo'te benne' ka', benne' nnégake' chia' neda', Benne' Golje' Benách, wak yenít ḻaw Dios chégake', san cha' no benne' nnie' che Dios Be' La'y, bi yenít ḻaw Dios che bennen'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Kate' wché'gake' ḻe'e gan nak ḻo yo'o gan ẕdobgak benne' judío ka' nich yéngekle' x̱tiža' Dios, na' ḻawgak benne' ka' wchi'a ḻáže'gake' ḻe'e, na' ḻawgak benne' wnná bia' ka', bi kwe' zédlele ni'a che da' gonle, o da' yecheble, o da' žaḻa' nnale. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ḻa' ža na'ze wḻoé'el Dios Be' La'y ḻe'e da' žaḻa' nnale. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","To benne' ladjw benne' zan ka' gože' Jesusen', na' wnné': —Benne' wsedle, gož benne' bicha'a gonne' da' žeyaḻa' chia' che da' gota' che x̱ato'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesusen' gože' ḻe': —Benne'. ¿Zoa no benne' bzoe' neda' nich wchi'a ḻaža'a ḻe'e, o wzoẕja' da' de chele? ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naž Jesusen' gože' benne' ka' nníta'gake' ga na', na' wnné': —Le wia nga. Le gape chi'i kwinle nich bi tonle yeḻa' gape. Kégeze da' nápḻe'ele wzóan ḻe'e ḻo yeḻa' žebele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naž Jesusen' bcháḻjḻene' ḻégake' da' bsaka' ḻebe', na' wnné': —Wzóa to benne' wdápeḻi'e yeḻa' wnni'a, na' bnéẕjwḻe'e yežlyó chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Naž wzá' ḻaže'e, na' wnné': “¿Nakx̱kze gona'? Bi nžo'o ga gape chi'a da' žonn yežlyó chia'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naž wnné': “Ki gona'. Wchinnja' yo'o ka' gan žape chi'a da' žata' chia', na' gona' yo'o ẕenže ka', gan gape chi'a da' žata' chia', na' dan' ba de chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Naž yapa' kwina': ba nápeḻi'a da' ba btoba', da' ye'j gawa' zante yiz. Yezí' ḻaža'a. Ye'j gawa', na' yebela'.” ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Naž Dios gože' ḻe': “Le' bi be nnezlo'. Na'a yele gato'. Na'a, ¿noẕe benne' gak chie' dan' ba btobon'?” ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ki žaken che bennen' ẕtobe' chekze' yeḻa' wnni'a, na' bi žone' da' zej naken ka yeḻa' wnni'a ḻaw Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wdé na' Jesusen' gože' benne' wsedle chie' ka', na' wnné': —Che ḻen žapa' ḻe'e: bi kwe' zédlele ni'a che da' ye'j gawle, dan' nbánḻenle, o ni'a che laže' da' gákwle. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Záka'že yeḻa' nban chele ka da' žawlen, na' záka'že beḻa' žen chele ka laže' da' žákwlen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Le wia kan žak chegak sechj ka'. Bi žázgakba', na' bi žel-ḻapba', na' bi zej nnita' yo'o ka' chégakba' gan gape chí'igakba' da' žata' chégakba', san Dios ẕwawe' ḻégakba'. ¿Bi záka'žele ḻe'e ka byínnedo' ka'? ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Noẕ benne' ládjwle ḻe'e gak gone' ga soe' nbane' yetó chí'ido'ze dan' že' zedle' chen? ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Che ḻen, cha' bi gak gonle da' naken láte'do'ze, ¿biẕ chen' že' zédlele ni'a che da' naken da' ẕenḻe'e? ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Le wia kan ẕgólegak yéjedo' ka'. Bi žóngaken do laže', na' bi žábgaken laže', san žapa' ḻe'e, ḻa'kze góta'ḻe'e yeḻa' wnni'a che Salomón, bennen' wnná bi'e, lažen' da' gokwe' bi gokžen x̱tan ka zej nak yéjedo' ki. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cha' Dios žone' x̱tan yeje yíx̱e'do' ka' da' žé'gaken na'a ḻe'e yix̱e', na' wx̱é wižj chéygaken ḻo yi', ¿bi gone' da' ẕenže chele ḻe'e, ḻe'e na' bi žejḻe'le che Dios dot ḻáže'le? ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Che ḻen, bi we' ḻáže'le da' ye'j gawle, na' bi kwe' zédlele chen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yógo'te da' ki žiljgak benách ka' nníta'gake' yežlyó nga, san ba nnézkzele X̱ale Dios da' ka' žiážjele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Le we' ḻaže' gonle kan ẕnna x̱tiža' Dios, na' yógo'te da' ki gonne' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ḻezka' wnná Jesusen': —Bi žébele ḻe'e, nakle ẕíla'do' chia' ka'. Bi nakle benne' zan, san X̱ale Dios žaz ḻaže'e gonne' ḻe'e latje chejsoale gan ẕnna bi'e Ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Le gote' da' naple, na' le wneẕjw da' si'le chegak benách yache' ka'. Ki gaken, gonle bzod mežw chele da' bi kwia yin', na' wtoble yeḻa' wnni'a da' bi te chen ya'abá che Dios, gan bi gak žin benne' wbán, na' bi galj béledo' chen. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gan že' yeḻa' wnni'a chele, we' ḻáže'le žinle ga na'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ḻezka' wnná Jesusen': —Le gak ban ḻaže', na' le wzálj yi' da' wza'nín' chele. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Le gak ka benne' wen žin ka', benne' želbeze' ža yeḻá' x̱ángake', bennen' wyeje' lni che yeḻa' ẕchag na', nich kate' yežine', wḻiže', na' ḻa' wsáljwtegake' nich yeyoé'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ba nez ẕen gaken chegak benne' wen žin ka', benne' gak ban ḻáže'gake' kwézgake' kate' yeḻa'že x̱ángake'. Da' li žapa' ḻe'e, x̱ángaken' wpá' kwine', na' kweke' ḻégake' gan ye'j gáwgake', na' wsí'ni'e dan' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ḻa'kze yeḻé'e kate' ba žak choḻ o gachje yele, cha' yedjx̱ake'e ḻégake' nníta'gake' želbeze' ḻe', ba nez ẕen gaken chegak benne' wen žin ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Žaḻa' nnézlele da' ni. Chela' nnezle x̱an yo'o biẕ ža žin benne' wbán, gak ban ḻaže'e, na' bi we'e latje bennen' wžíe' yežw liže', nich bi kwane' da' de liže'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Che ḻen, le gak ban ḻaže' ḻe'e, dan' yeḻá'a neda', Benne' Golje' Benách, to ža katen' bi kwezle neda'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Naž Bedw wnnable' Jesusen', na' wnné': —X̱an, ¿ži'o néto'ze da' ni da' žsaka' ḻebo', o ži'o yógo'te benách da' ni? ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","X̱anžon' gože' ḻe', na' wnné': —¿Noẕkzen' benne' wen žin chawe', benne' žejni'ile', na' nzi' ḻo ne'e ḻo wláz x̱ane'? Benne' ni, x̱ane' wdíe' ḻo ne'e liže', nich kate' gaḻa' gawgak benne' ka' nníta'gake' liže', na' wneẕjwe' ḻégake' da' gáwgake'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ba nez ẕen gaken che benne' wen žin na' kate' yeḻá' x̱ane', cha' yedjx̱ake'e ḻe' žone' žin na' da' bdien' ḻo ne'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da' li žapa' ḻe'e, x̱ane' wdíe' ḻo na' benne' wen žin chawen' yógo'te da' de chie'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Cha' no benne' wen žin gekle' bi yeḻá' ze x̱ane', na' so ḻawe' wsaka' zi'e yezika' wen žin ka', benne' byo ka', na' no'le ka', na' so ḻawe' ye'j gawe', na' sožle', ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","naž yeḻá' x̱an benne' wen žin na' kate' bi kweze' ḻe', o kate' bi gákbe'ele', na' wsaka' zi'e benne' wen žin na', benne' bi nake' chawe', na' choge' chie' kwia yi'e kan nžog chegak benne' ka' bi žejḻé'gake' che Dios. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Benne' wen žin na', benne' nnezle' da' žénele x̱ane', na' bi zoe' ẕbeze', na' bi žone' kan wnná x̱ane', benne' ni, wsaka' zi'ḻe'e x̱ane' ḻe'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Cha' to benne' wen žin bi nnezle' da' žénele x̱ane', na' cha' gone' da' gonen ga bage'e da' gonen ga wsaka' zi' x̱ane' ḻe', wsaka' zi'e benne' wen žin ni láte'do'ze. No benne' nzi' ḻo ne'e da' ẕenḻe'e, da' ẕenḻe'e yennáb x̱ane' ḻo ne'e, na' bennen' x̱ane' bx̱en ḻaže'e ḻe' da' ẕenže, ḻezka' da' ẕenže yennáb x̱anen' ḻo ne'e. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ḻezka' wnná Jesusen': —Bḻa'a neda' nich wẕena' yi' yežlyó nga, na' že' zedla' nich ẕen yin'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na'a, de to da' žaḻa' saka'a neda' da' naken ka to da' yezóa' nis, na' že' zedla' kate' gakžen chia'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Žéklele ḻe'e bḻa'a neda' nich wzóa' žize da' žaken yežlyó nga? Žapa' ḻe'e: O'o. Bḻa'a nich ko'a da' gon chople benách ka' nníta'gake' yežlyó nga. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na'a so ḻaw gayo' benne' ka', benne' nníta'gake' to yo'o gákgake' chope ḻa'a. Chonne' tíḻ-ḻengake' chope benne' ka', benne' zej nzi'e x̱tiža'a, na' chope' ka' tíḻ-ḻengake' chonne' ka'. ");
INSERT INTO ztyNTps_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","No benne' zoa x̱kwide' byo chie' tíḻ-ḻene' ẕi'nen', na' x̱kwide' byon' tíḻ-ḻenbe' x̱aben'. To no'le zoa x̱kwide' no'le chie' tíḻ-ḻene' ẕi'nen', na' x̱kwid