﻿USE sofia;
DROP TABLE IF EXISTS sofia.ztqNT_vpl;
CREATE TABLE ztqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ztqNT_vpl WRITE;
INSERT INTO ztqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitsy re xseety pxusykoltoo Jesucrist. Lo xtiiy David ni lo xtiiy Abraham sëëd Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham kok pxosy Isaac, lëë Isaac na kok pxosy Jacob, lëë Jacob na kok pxosy Judá ni betsy Judá. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Chop Judá Tamar kop Fares ni Zara. Lëë Fares kok pxosy Esrom, lëë Esrom na kok pxosy Aram. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lëë Aram kok pxosy Aminadab, lëë Aminadab na kok pxosy Naasón, lëë Naasón na kok pxosy Salmón. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Chop Salmón Rahab kop Booz. Chop Booz Rut kop Obed. Lëë Obed kok pxosy Isaí. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Lëë Isaí kok pxosy rey David aan chop rey David kwnaa nii kok tsiil Urías kop Salomón. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Lëë Salomón kok pxosy Roboam, lëë Roboam na kok pxosy Abías, lëë Abías na kok pxosy Asa. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Lëë Asa kok pxosy Josafat, lëë Josafat na kok pxosy Joram, lëë Joram na kok pxosy Uzías. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Lëë Uzías kok pxosy Jotam, lëë Jotam na kok pxosy Acaz, lëë Acaz na kok pxosy Ezequías. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Lëë Ezequías kok pxosy Manasés, lëë Manasés na kok pxosy Amón, lëë Amón na kok pxosy Josías. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Lëë Josías kok pxosy Jeconías ni betsy Jeconías. Mer tiemp ko lëë xaa Babilonia sikni xoo xaa Israel nëz Babilonia. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aan loxsye ptsiñ xaa Babilonia, lëë Jeconías kop Salatiel. Lëë Salatiel kok pxosy Zorobabel. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Lëë Zorobabel kok pxosy Abiud, lëë Abiud na kok pxosy Eliaquim, lëë Eliaquim na kok pxosy Azor. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Lëë Azor kok pxosy Sadoc, lëë Sadoc na kok pxosy Aquim, lëë Aquim na kok pxosy Eliud. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Lëë Eliud kok pxosy Eleazar, lëë Eleazar na kok pxosy Matán, lëë Matán na kok pxosy Jacob. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Lëë Jacob kok pxosy José, lëë José kok tsiil Mariy, lëë Mariy na kok xñaa Jesús, xaa nii kwloolë no Crist. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tsida pxusykoltoo meñ Israel kwtedy lo kislyu re destye Abraham axte David. Stsida xaa kwtedy destye David axte tse nii lëë meñ Israel sey nëz Babilonia. Stsida xaa kwtedy destye worñee lëë meñ Israel sey nëz Babilonia axte worñee lëë Crist koly. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sinrii mod koly Jesucrist. Lëë xñaa xaa Mariy no nii ktsiilña chop José. Per antes nii ktsiilña xaa, lëë Mariy kok xiñ por Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Per como tu xaa buen nak José, koklasty xaa nii nyeñ meñ nii lëë xaa blaa Mariy. Por ngo lëë xaa kwlokyeñ klaa tsilaan xaa me. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lëë xaa lox kwlokyeñ nii singo kuuñtsyey xaa, tsiñee lëë tu xangly Dios kunee lo xaa lo mgaal chëb: —José, lo xtiiy David sëëdoo. Ptsiilña Mariy, por xiñ Kyalbini Ntson kap me. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lëë Mariy kap tu mëëdpkiy aan no nii kolël xaa Jesús. Singo kcholë xaa por lëë xaa kteelaa meñ xkyedzy xaa lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kchësyo kok parñee kak cumplir tiits nii pxaal Dios lo profet tsiñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Lëë tu kwnaa yeeñ kakxiñ aan lëë me kap tu mëëdpkiy, aan lëë mëëd ko kcholë Emanuel. (Tiits ko nak sinak xñee ñe: Lëë Dios nakni lëë no.) ");
INSERT INTO ztqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tsiñee lëë José bna, lëë xaa beeñtsyey nii kwnabey xangly Dios. Lëë xaa ptsiilña Mariy. ");
INSERT INTO ztqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per kwyonidy xaa Mariy, sink lëë xaa kwlës axte nii lëë Mariy kop mëëd. Aan lëë xaa kwloolë mëëd ko Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tsiñee lëë Jesús lox koly leñ kyedzy Belén nii ngab Judea, lëë bla xaa chak nii sëëd nëz laa xlyañ ngbidz ptsiñ Jerusalén. Lëë Herodes nak rey tiemp ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Lëë xaa chak ko kwnabtiits chëb: —¿Ko xrey meñ Israel nii koly? Por lëë noo syoopnaal tu mëly nii kwlañ nëz laa xlyañ ngbidz. Mëly go bluuy loo noo nii lëë xaa koly aan lëë noo syoop ksoxib lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tsiñee lëë rey Herodes biñ nii chëb xaa chak ko, lëë xaa kwyo kyalnë kchë xaa meñ Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tsigo lëë rey Herodes kwnabey koktsyetsy kchësy xaa nii xñabey lo pxosy ni kchësy maestre ley, aan lëë xaa kwnabtiits chëb xaa: —Pa no nii kaly Crist. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lëë xaa go chëb: —Tu kyedzy nii lë Belén nii ngab Judeaw, por lëë profet pkëë sinrii: ");
INSERT INTO ztqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lëë lëë do meñ Belén, nikxe nii wiñ xkyedzy to, mastre nono lo kchë kyedzy nii ngab Judá, por leñ xkyedzy to kchoo tu xaa nii kñabey, aan lëë xaa kantsi meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Loxsye ngo lëë Herodes kwtsyetsy tsilaan ksa xaa chak ko, aan lëë xaa kwnabtiits pa woortyee kon xaa mëly go. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tsigo lëë xaa pxaal xaa Belén, aan lëë xaa chëb lo xaa: —Kol tsi siko, aan kol kyub mëëd ko. Aan tsiñee ktsil do xaa, kol kluuy tiits lon parñee kaksoxibaa lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Loxsye kwnee rey lo xaa, lëë xaa si. Aan lëë mëly nii kon xaa kwlañ tugak sinech lo xaa, aan lëë ma kwsobtse axte laañee nix Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tsiñee lëë ksa xaa chak ko kon nii lëë mëly kwsobtse, per nli busy ble xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lëë xaa kwsëëb leñ yu, aan tsiñee lëë xaa kon mëëd chop xñaa mëëd Mariy, lëë xaa pkady or, yaal ni ngwaan xlyaa nex nii lë mirra. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Per lëë Dios kwnee lo xaa lo mgaal. Chëb Dios nii nody nii tsiktedy xaa lo Herodes. Por ngo lëë xaa kwseñ stu nëz par kyey xaa xkyedzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tsiñee lëë ksa xaa chak ko bi, lëë tu xangly Dios kunee lo José lo mgaal chëb: —Kuxche, biy mëëd ni biy xñaa mëëd aan pxooñ kwey nëz Egipto. Por lëë Herodes kyub mëëd par kuty xaa mëëd. Kwyo siko axte nii kñen lool stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lëë José kuxche aan kyool sini xaa mëëd chop xñaa nëz Egipto. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Siko kwyo xaa axte nii lëë Herodes kuty. Kchësy nrii ptsyool xaa parñee kak cumplir xtiits Dios nii kwnee profet tsiñee chëb xaa: “Egipto byakxin xiñaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tsiñee lëë Herodes byeñ nii lëë ksa xaa chak ko pkëëti xaa, per nli busy blëë xaa. Aan lëë xaa kwlii cuent pa wortyee kon xaa chak ko mëly, aan lëë xaa kwnabey kuty kchësy mëëdpkiy nii chap chop iz par kyety nii no leñ kyedzy Belén ni leñ kyedzy nii nche kexka siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Singo mod lëë tiits nii kwnee profet Jeremías kok cumplir tsiñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Leñ kyedzy Ramá biiñ Raquel, porñee lëë kchë xiñ me kuty, aan nikxe xñee meñ lo me, per xekwty me, lëë me choon. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per loxsye kuty Herodes, lëë tu xangly Dios kunee lo José lo mgaal xtañ meñ Egipto chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Kuxche, aan byey Israel ksal mëëd ni xñaa mëëd, por lëë kchësy xaa nii kokladzy nyuty mëëd kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tsigo lëë José kuxche aan lëë xaa sikni mëëd chop xñaa nëz Israel. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per tsiñee biñ xaa nii lëë xiñ Herodes nii lë Arquelao sob xñabey Judea, lëë xaa ptsyeb nyey xaa siko. Aan como lëë Dios kaa kwneel lo xaa lo mgaal, lëë xaa sey nëz Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tsiñee lëë xaa ptsiñ Galilea, lëë xaa kwtedyso tu kyedzy nii lë Nazaret. Singo mod lëë xtiits profet kok cumplir tsiñee chëb xaa nii xaa Nazaret kak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Leñ tse go lëë Juan Bautist bislo xluuy xtiits Dios tañ pidzy nii nche Judea, ");
INSERT INTO ztqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","xñee xaa: —Kol ktikche styoo do lo Dios, porque lëë wor kutsiñ nii lëë Dios kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lëë Juan nak xaa nii pseety profet Isaías tsiñee chëb xaa: Son meñ tsiy xaa tsiñee lëë xaa kñee lo meñ tu tañ pidzy këb xaa: “Kol kxixkwaa nëz nii tedy xaa nii xñabey. Kol kwii tu nëz tubli.” ");
INSERT INTO ztqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kits lady camey kwyaa xab Juan, lëë xcinturón xaa kwyaa con kidy. Nkwxandx ni tsiñ tañ taw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tsigo lëë meñ Jerusalén, ni meñ nii no nëz Judea ni kchësy meñ nii ncheno kex chu kiigwpee Jordán kwey laañee so Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aan tsiñee lëë meñ lox xobtol xtol lo Dios, lëë Juan xchoobnis meñ chu kiigwpee Jordán. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Per tsiñee kon Juan nii ndaly xaa fariseo ni xaa saduceo ptsiñ chakladzy chobnis, lëë Juan chëb: —¡Nak to sinak mëël! ¿Cho në nii lëë do telaa lo kyalntseeb nii kxaal Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kol kpañ sinak xñabey Dios parñee kak nyoo nii nli lëë do ptikche styoo do lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kak nyaady to nii Abraham nak pxosy to. Por nli xñen nii schilo kyuñ Dios kyo re xiñ Abraham. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lëë kiibyag kaa tse so mbës parñee chug silu yag nii xkyëdy nex aan tsow lo ki. Singo ktsyool meñ nii xtikchedy styoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nli naa xchoobnis lëë do con nis parñee kpikche styoo do lo Dios. Per lëë xaa nii kiid tsiñee lëën kpi kchoobnis meñ nii kniladzy xtiits Dios con Kyalbini Ntson, ni lëë xaa ksaksi meñ nii knilasty con ki. Porque mastre non xaa lon, ni lab xaa xyaldy koyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","No xpal xaa ña xaa par kuuñnyë xaa xobxtily ni kwii xaa tixob tublad. Lëë xaa kotsey xobxtily leñ ngoch, per lëë xaa ksaay tixob lo tu ki nii kyuuydy. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Galilea pchoo Jesús, lëë xaa kwey lo Juan chu kiigwpee Jordán parñee kchoobnis Juan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Klo kwnëdy Juan nchoobnis Juan xaa, chëb Juan: —Naa no nii nyely lool par kchoobnisoo naa. ¿Penak nii lii sëëd lon? ");
INSERT INTO ztqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsigo lëë Jesús chëb: —Pchoobnis naa, por no nii kuuñ no cumplir nii xñabey Dios. Lëë Juan ptee tiits. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aan siikñee lëë Jesús lox kwchobnis, lëë kpaa byaly, aan lëë Jesús kon nii lëë xKyalbini Ntson Dios sëëd sëëb sinak tu palom byab lady xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ni lëë xaa biñ tsiy tu xaa nii xñee: —Lëë xiñaa nii xkëstyoon so ske. Xlen lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Loxsye kwchobnis Jesús, lëë Kyalbini Ntson kuni xaa tañ pidzy par kuñ xaatox xaa preb. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ni tu pe tawdy Jesús lo choow kpidz ni choow kyool nii kwyo xaa tañ pidzy ko. Por ngo, tsiñee lëë xaa kwlaañ, ");
INSERT INTO ztqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","lëë xaatox kwey lo xaa chëb: —Deelñee nli Xiñ Dios nakoo, kwnabey nii kyak kyo nii nche ske kyaxtily. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Per lëë Jesús chëb: —Leñ kitsy nii kë xtiits Dios xñee: “Lëdy nonsy kyaxtily kaw meñ parñee kpañ meñ, sink no nii kuuñtsyey meñ kchë nii xñabey Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Loxsye ngo lëë xaatox kuni xaa leñ kyedzy Jerusalén, aan lëë xaatox blëëp xaa kik lidzy Dios laañee mastre klaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ni lëë xaatox chëb lo xaa: —Deel nli Xiñ Dios nakoo, kwyas nu aan byab lyu, por leñ xkitsy Dios xñee: Lëë Dios kxaal xangly kakni lii. Lëë angly kñaasy lii con ña xaa, parñee lasty kyo niyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tsigo lëë Jesús chëb: —Leñ xkitsyak Dios xñee: “Kuñdyoo Dios nii xñabey lii preb.” ");
INSERT INTO ztqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lëë lultime lëë xaatox kuni Jesús tu kik kiy nii per nli busy klaa, aan lëë xaatox bluuy kchësy kyedzy nii nche lo kislyu ni kchësy cos non nii no low, ");
INSERT INTO ztqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","aan lëë xaatox chëb lo Jesús: —Snetsyaa kchësyo lool deelñee soxiboo lon. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Lëë Jesús chëb: —Bichee nu, xaatox, por leñ kitsy nii kë xtiits Dios xñee: “Psoxib lo Dios nii xñabey lii ni xtiits sye xaa psoob.” ");
INSERT INTO ztqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tsigo lëë xaatox psaan Jesús aan lëë xangly Dios kuni nii taw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tsiñee biñ Jesús nii lëë Juan no skiib, lëë xaa kwseñ nëz, lëë xaa si nëz Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Per byodre xaa leñ kyedzy Nazaret, sink lëë xaa kwtedyso tu kyedzy nii lë Capernaum nii nche chu nistoo Galilea. Kexka siko nak xtañ meñ Zabulón ni xtañ meñ Neftalí. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kchësy nrii kok parñee kak cumplir nii kwnee profet Isaías tsiñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Xtañ meñ Zabulón ni xtañ meñ Neftalí, kyedzy nii nche stublad chu kiigwpee Jordán, kexka chu nistoo Galilea, laañee no meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lo nguey mbañ meñ go, per lëë meñ go kon tu bini ngol. Lëë nguialkuty xñabey lo meñ go, per lëë bini go psaani lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Destye wor go lëë Jesús bislo xñee lo meñ: —Kol ktikche styoo do lo Dios, por lëë wor kutsiñ nii lëë xaa kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tu tse lëë Jesús sitedy chu nistoo Galilea, tsiñee lëë xaa kon chop ngoosy mël nii nche kchon xkyex lo nis. Chop betsy nak xaa. Tu xaa lë Simoñ Pedre, lëë stu xaa lë Ndresy. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aan lëë Jesús chëb lo xaa: —Kol tënal naa parñee jkoostre to mël, sink lëën kluy lo do xa kluuy do xtitsaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wor go kazh nche gak xkyex xaa, lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sijtyak kwsë Jesús, lëë xaa kon schop ngoosy mël. Tu xaa lë Jacob, lëë stu xaa lë Juan. Xiñ Zebedeo nak xaa chop xaa. Lëë xaa no jkëtë xkyex xaa leñ tu barkw ksa xaa pxosy xaa. Lëë Jesús kwtsyetsy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aan wor go kazh lëë xaa psaan pxosy xaa leñ barkw. Lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kunsë Jesús tyub xtañ meñ Galilea, aan kchë leñ ktoo nii kwey xaa bluuy xaa xa nak xkyalwnabey Dios lo meñ, ni beeñ kyak xaa meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tyub nëz Siria biñ meñ nii chuuñtsyey Jesús. Por ngo nii kchëlo meñ xsyaknë kwey lo Jesús. Kwey meñ nii no kyalbini mal leñ styoo, ni meñ nii chak wety, ni meñ nii kutoo lady, aan kchësy meñ xsyaknë go beeñ kyak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ndaly meñ Galilea, ni meñ Decápolis, ni ndaly meñ Jerusalén, ni meñ Judea, ni meñ nii ncheno stublad chu kiigwpee Jordán kunal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tsiñee Lëë Jesús kon kchësy meñ go, lëë xaa kwsob tu chex kiy. Lëë meñ big lo xaa ");
INSERT INTO ztqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aan lëë xaa bislo beeñ kseedy xaa meñ chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Dichos meñ nii xyeñ no xtol, por lëë meñ go kyey laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Dichos meñ nii no kyalnë, por lëë Dios kchoobladzy styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Dichos meñ ndoladzy, por lo meñ go ktee Dios kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dichos meñ nii choxko kuuñtsyey nii chakladzy Dios por stee Dios kchësy nii kñab meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Dichos meñ nii xkëstyoo xcombañer, por skëstyoo Dios meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dichos meñ nii tubli no styoo, por lëë meñ go kan Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Dichos meñ nii xkwëës tily, porque lëë meñ go kak xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dichos meñ nii xtyedy kyalnë por xtiits Dios, por lëë meñ go kyey laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Dichos to, tsiñee kutsyetsy meñ do ni ksaksi meñ do ni tsiñee por xtitsaa jkots tiitskizh meñ do. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kol kle ni kol ko nguiool styoo do, por lëë Dios kizh lëë do tsiñee ktsiñ do kpaa. Siñee xsaksi gak meñ lëë do psaksi meñ kchë profet nii biid penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Lëë do nak sinak sedy lo kislyu re. Per deelñee ksaan sedy xinxiyo, ¿xa kyak nxiyo stub? Lëëw ksyëëb porñee pa xkiiñtrew aan lëëw subniy kchë meñ nii xtyedy nëz. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Lëë do nak sinak bini nii xsaani lo kislyu. Nak to sinak tu kyedzy nii nche tu kik kiy. Chilody tsolano. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni nan gaa to nii xkëëdy meñ tu bini parñee kolan meño leñ tu cajón, sink lëë meñ xsoob bini go tu laañee ksaaniw lo kchë meñ nii sëëb leñ yu. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Singo gak kaa lëë do kol ktee nii ksaani xbini do lo meñ, parñee tsiñee kan meñ kchësy cos buen nii chuuñtsyey do, stee meñ skizh lo Tat Tios nii sob kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Chëb Jesús lo meñ: —Këbty to tsaaplaa lëën syely parñee knilastre to xley Moisés ni kchë nii bluuy profet nii pxaal Dios penaadle. Lëdyo gon, sink lëën syely parñee kuñno cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ni lëën xñe kaazhkaa lo do nii mentre bii no kpaa ni bii nche kislyu, kyaaldy ni tu letre ni ni tu punt nii kë lo xley Moisés. Kchësyo kak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por ngo, kchë meñ nii xsaldy tu cos nii xñabey Dios, nikxe tu cos wiñsyew, ni deelñee xluuydy meñ lo xcombañer ksoob xtiits Dios, tsiñee lëë meñ go ktsiñ laañee xñabey Dios, lëë Dios ksyablyu meñ go. Per lëë meñ nii ksal kchë kchësy nii xñabey Dios ni kluuyo lo xcombañer, lëë Dios klisklaa meñ go laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Por ngo, deelñee tsoxkody to nii kuñ do gan lo maestre ley ni lo meñ fariseo nii kuuñtsyey do nii xñabey Dios, tsitsiñdy tse nii sëëb to laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Pe lëdy kayonle gaa to nii chëb Dios lo pxusykoltoo do: “Kujtyoo, por lëë meñ nii kuty saa bñech tsi lo xtisy.” ");
INSERT INTO ztqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per naa nii xcuentaa, lëën xñe nii kchë meñ nii klëë lo xcombañer, lëë Dios ksaksi meñ go. Lëë kchë gaa meñ nii kxiñ tiits lo xcombañer, lëë xaa nii xñabey ksaksi meñ go. Per lëë meñ nii këb lo xcombañer: “Pa xkiiñdyoo”, lëë Dios kxaal meñ go lo ki nii chek linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Por ngo, deelñee sol lo pkoog aan ksaladzyoo nii ngol falt lo xcombañeeroo, ");
INSERT INTO ztqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","psaan nii sijkadyoo lo Dios lo pkoog aan kuknab perdón lo xcombañeeroo. Tsigolye schilo kpikcheel lo pkoog aan kokonoo nii sijkadyoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Deelñee xkëëkiy tu xaa lii aan chakladzy xaa tsikso xaa lii lo xtisy, kunee lo xaa lëë ka bii xteedyo tiits, porque deelñee kyaaboo ña xtisy, lëë xtisy këb lo mayor: “Kol ko xaa gue skiib”, aan lëë xaa ko lii skiib. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aan xsobaa nii kchoodyoo skiib axte nii kizhoo lal nii kñab xaa lool. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Pe lëdy kayonle gaa to nii chëb Dios: “Tsonidyoo tsiil stu meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per naa nii xcuentaa lëën xñe nii cualquiersye tu xaa nii kan tu kwnaa aan ksya styoo xaa tsoni xaa me, nikxe nii beeñtsyeydy xaaw, tu tol le ngo beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Singo tsigo busy, deelñee mëlool nii sob nëzli chuñ xtoloo, kwliiw aan psëëbo. Porque penakty nii kindy tu mëlool, lëjty nii chop mëlool sob aan kyeyoo linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O deelñee gaa ñalil chuñ xtoloo, pchugo aan psëëbo, porque penakty nii sobty tu ñal, lëjty nii chop ñal sob aan kyeyoo linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ni kayonle gaa to nii chëb Dios: “Cualquiersye xaa nii ksëëb tsiil no nii ktee xaa tublë kitsy lo me nii lëë xaa blaa me.” ");
INSERT INTO ztqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per naa nii xcuentaa lëën xñe nii deelñee klaa tu xaa tsiil aan pkaady me chop me stu mguiy lo xaa, lëë xaa xyub nii tsoni me stu mguiy. Aan cualquiersye xaa nii ktsiilña tu kwnaa nii psëëb tsiil le, lëë xaa chuuñtsyey tol. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ni kayonle gaa to nii chëb Dios lo pxusykoltoo do: “Tu cos nii pkonoo beeñtsyeyo.” ");
INSERT INTO ztqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per naa nii xcuentaa lëën xñe nii por ni tu cos jkondy to Dios. Jkondy to por kpaa, porque siko sob Dios, ");
INSERT INTO ztqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni jkondy to por kislyu, por lo kislyu xsyo niy Dios, ni jkondy to por kyedzy Jerusalén, porque Dios nak rey siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni jkondy to Dios por kik to, porque ni tu kits kik to chilody kuuñ jkiitsy to o kuuñnyeesy kaa to. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tsiñee xñee do nii nli tu cos, ktsëëdy to lo xtiits to, tugak kol nee nliw. O deelñee gaa xñee do nlidyo, tugak kol nee nii nlidyo, ktsëëdy to lo xtiits to, por ndox nii ktsëë do lo xtiits to. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Kayonle gaa to nii chëb Dios: “Deelñee kwii tu meñ mëlool, kwlii gak mëlo meñ go, o deelñee kwii tu meñ tu laayoo, kwlii gak tu lay meñ go.” ");
INSERT INTO ztqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per naa nii xcuentaa lëën xñe nii deelñee no cho chakladzy ksaksi lii, psaan, o deelñee gaa kyaasy tu xaa kwesyoo, ptee wi stublad kwesyoo kyaasy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Deelñee tsikso tu xaa lii lo xtisy parñee kla xaa xmaankwoo, blaa kla xaa wi xchakeetoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Deelñee jkoy xoo tu xaa lii xyow xaa tu mily metre, biyo chop mily metre. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Deelñee kñab meñ nii kteedyoo tu cos lo meñ singosy, pteedyo, ni jkaadyoo cos lo meñ nii xñabtiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ni kayonle gaa to nii lëë pxusykoltoo do kwnee: “Pkëstyoo meñ nii ngui xñee lool, per ptilyni meñ nii xtilyni lii.” ");
INSERT INTO ztqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per naa nii xcuentaa lëën xñe: Kol jkëstyoo meñ nii xtilyni lëë do ni kol nab nii kakni Dios meñ nii kënlaag lëë do, ");
INSERT INTO ztqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tsiin kak to xiñ Tat Tios nii sob kpaa. Por lëë xingbidz xaa xsaani lo meñ ngoptol ni lo meñ buen, ni lëë xaa xsyaab kyo par meñ nii chuñ kyalbuen ni meñ nii chuñ kyalmal. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni tu pe kneesty Dios lo do deelñee xaktyee meñ nii ngui xñee lo do xkëstyoo do. Por singo gak chuuñtsyey kchë xaa yoox nii xtop tumi par kyeyo lo xtisy nii sob Roma. ");
INSERT INTO ztqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Deelñee xaktyee meñ nii xyuumbey do xkëëptyux to, pe nano. ¿Pe lëdy singo nayak chuuñtsyey meñ nii xnilasty Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kol ksaan xtol do, porque nody xtol pxosy to nii sob kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Kuñdy to kyalbuen laañee nche meñ parñee kanpee meño. Por ni tu pe kneesty Dios lo do singo mod. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Por ngo, tsiñee jkadyoo tu cos lo meñ nii no lyaadzy, jkëëdyoo tsyetsy nii lëëw pkadyoo, sinak chuuñtsyey grol meñ leñ ktoo ni pal nëz parñee kakyetypee lë xaa nii lëë lëësy xaa buen. Por lëën xñe kazh nii ni tu pe kteejtre Dios lo xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Singo tsigo busy tsiñee jkadyoo tu cos lo meñ nii no lyaadzy, per ni tu lo xamiigwoo kutiistylo. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tsilaan pkadyoo tsiin lëë Tat Tios nii chan kchë cos nii chuuñtsyeyoo tsilaan ktikche kyalnsaak ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Tsiñee kutiitsni do Dios, kaktyoo sinak kchë meñ nii xsyoli leñ ktoo toon pere xñee, ni kakty to sinak meñ nii xsyo pal nëz parñee kanpee meñ meñ go. Por lëën xñe kazh nii ni tu pe kteejtre Dios lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per lëë lii tsiñee kutiitsnil Tat Tios, byo leñ liidzyoo aan psuugw chu puert aan bitiits chopsyoo Tat Tios. Aan lëë Tat Tios nii chan kchë cos nii chuuñtsyey tsilaanoo ktikche xkyalnsaakoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Tsiñee kutiitsnil Dios, kseejtyoo tiits nii pa xkiiñdy. Kuuñtsyeydyoo sinak chuuñtsyey meñ nii xnilasty xtiits Dios. Xsyak meñ go nii por kchë nii xñee meñ go lëë Dios ksal meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kutiitsnidy to Dios sinak chuñ meñ go, por nanle Tat Tios pe cos xkiiñ do nikxe karty kñab tow. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sinrii no nii kutiitsni do Dios: Tat Tios, lii nii soboo kpaa, xñab noo nii kchë meñ kuuñ ksak lii. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ni xñab noo nii ktsiñ tse nii kñabeyoo lo kislyu sinak nii xñabeyoo kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bneetsy nii tyaaw noo natse. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Beeñ noo perdón sinak nii chuuñ noo perdón meñ nii xko falt loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Klaadyoo jkaal xaatox lëë noo parñee kyaabty noo lo tol. Pteelaa lëë noo lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Deelñee xnityladzy to falt nii xko xcombañer do lo do, snityladzy Dios xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Per deelñee knitylasty to xfalt xcombañer do, per ni Tat Tios nii sob kpaa knitylasty xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Tsiñee kawdy to par kuuñ ksak to Dios, ksaa mbandy to lo do parñee kanpee meñ nii noyawdy to par kuuñ ksak to Dios. Por singo chuuñtsyey grol meñ ni lëën xñe kaazhkaa nii ni tu pe kteejty Dios lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per tsiñee kawdy to par kuuñ ksak to Dios, kol kiib lo do ni kol kooñ kik to ");
INSERT INTO ztqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","parñee kyeñdy meñ nii karty kaw do porñee lëë do noyuuñ ksak Dios. Kol ktee nii Tat Tios sye kyeñ pe cos noyuuñtsyey do tsiin ktikche xaa xkyalnsaak to. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ktobty to tub yox cos lo kislyu, por lëëw kyëmëël ni lëë ngbaan gaa no. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sink kol tsoxko kuuñtsyey do nii jkiiñ lo do kpaa, por siko kindy nkwxog nii jkëëma cos ni kindy meñ nii xkwan. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Parñee laañee tso gak nii chap to tso xkyalmbañ do. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Nak mëlo do sinak tu bini nii xsaani leñ styoo do. Deelñee nxiñdy mëlo do tyub leñ styoo do nyaani. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per deelñee nxiñ mëlo do, tyub leñ styoo do nguey. Aan deelñee xsaanidy bini nii no leñ styoo do, ¿pe toodyxe nguey poo yeesy nak tyub leñ styoo do? ");
INSERT INTO ztqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni tu cho chilody kyë tsiiñ chop lo patrón. Por neñdy sle xaa lo tu xpatrón xaa, lëë stu lo xaa klëë xaa, o neñdy kaa ngui kuñ xaa xtsiiñ tu lo xpatrón xaa, aan ksaldy xaa stu xaa. Por ngo chilody ksoob to xtiits Dios tyub styoo do deelñee tumi tugak sini kik to. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ni lëën xñe gaa nii tsoxkody to nii dyon pe cos kaw do o ki gaa to parñee kpañ do o pe cos kakw kaa to. ¿Pe lëdy nayak mastre non kyalmbañ que nii xtyaaw, ni pe lëdy kaa nayaknan do nii mastre non xcuerp to que ladx nii chakw to? ");
INSERT INTO ztqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kol kan kchë mguiñ gaanoo. Chandy ma ni xkyëdy ma kwlaap, ni xkotseydy ma nii ktyaaw. Lëë Tat Tios nii sob kpaa xyaan ma. ¡Aan mastre non do lo kchë mguiñ! ");
INSERT INTO ztqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nikxe gaa nii tsoxko do, per ni tu wor chilody kiskool do lo tse nii kpañ do. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Penak nii choxko do por ladx nii kakw to? Kol kuy gaanoo xa xroob kyoo tañ aan xkyëdyo tsiiñ ni xkibtyo ladx. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per sootaa ni rey Salomón kokwty tu ladx ngui sinak nii ngui tu kyoo, nikxe nii ndaly cos ngui kop xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Deelñee Dios tsigo busy xkakw xab kchë kizhyë nii no tañ aan xlyëëdyak lëëw chek lo ki, ¿penak tsigo nii xnilasty to nii lëë Dios jkakw xab to? ");
INSERT INTO ztqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pe tsinidy kik to nii dyon pe cos kaw do o pe cos ki gaa to ni pe kakw to. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kchësy cos re no meñ nii xnilasty Dios kyalnë, per lëë lëë do nanle Tat Tios nii sob kpaa pe cos chak falt lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Por ngo, klo kol kuuñtsyey nii xñabey Dios tsiin kxaal xaa nii kak falt lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsody to kyalnë nii dyon pe cos kak kxe, porque xaal xaal nak kyalnë tu tse. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Jkëëkiydy to xcombañer do tsiin jkëëkiydy Dios to. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Por sinak nii xkëëkiyak to xcombañer do jkëëkiy Dios to, ni sinak nii chuuñtsyeyak to kuuñtsyey Dios to. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Penak nii xseel chanoo kizh wiñ nii no lo xcombañeeroo aan xyeñdyoo nii mastre ngol tublë yag nii no lool? ");
INSERT INTO ztqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Xa nanoo këëboo lo xcombañeeroo: “Kwlës dyon kwin kizh wiñ nii no lool”, aan xkwiidyoo yag ngol nii no lool? ");
INSERT INTO ztqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Maaloo! Klo kwlii yag ngol nii no lool tsiin kchilo kanoo par kwiil kizh wiñ nii no lo xcombañeeroo. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Kluuydy to xtiits Dios lo meñ nii chaklasty kono, por toontlaa klëë meñ go aan kxiix meñ go lëë do sinak chuuñtsyey mëkw. Ni jkaydy to kyalnsaak nii xneetsy Dios lo do cholsye lo meñ, por toontlaa subniy meño sinak xsyubniy ngutsy nii xyaan meñ ma. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Kol nab nii jkiiñ do lo Dios tsiin kneetsy xaaw, kol kyub cos tsiin ktsyool dow, ni kol jkëëptyux chu yu tsiin kyalyo. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Por kchë meñ nii kñab tu cos lo Dios jkaaw, ni kchë meñ nii kyub cos ktsyolo, ni kchë meñ nii jkëëptyux chu yu lëëw kyaly. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Pe no tu do dyon kyax ktee tu kyo lo xiñ tsiñee kñab xiñ do tu kyaxtily? ");
INSERT INTO ztqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Pe no gaa tu do kyax ktee tu mëël lo xiñ do tsiñee kñab xiñ do tu mël lo do? ");
INSERT INTO ztqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kol kyeñ gaanoo nii nikxe mal do, per xtee do cos buen lo xiñ do. ¿Pe lëëdyxe Tat Tios nii sob kpaa tsigo kteejty cos buen lo meñ nii kñabo? ");
INSERT INTO ztqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Kol kan meñ sinak nii chakladzy to kan meñ do. Por singo kë leñ kitsy nii pkëë Moisés ni kchësy profet. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Kol sëëb nëz laa kë puert nii nxeñdy. Por nxeñ puert ni nxeñ nëz nii xkëëtañ meñ, aan ndaly meñ xsyëëb nëz chu puert ko ni xsyeñ nëz ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per xisy meñ xsyëëb chu puert nii nxeñdy, ni xisy meñ xtsiil nëz nii xtsiñ laañee jkaa meñ kyalmbañ nii nitylody, porñee tir ngan nëz ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Kol kap cuent kchë lo xaa wnee xuuy nii chakladzy kluuy xtiits Dios. Porque xpig xaa lo do sinak tu mëkwxiily, per lëë leñ styoo xaa go nak xaa sinak tu mëëtsy. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Schilo kyeñ do pe cos no styoo xaa deelñee kan do kchë cos nii chuuñtsyey xaa, por xkyëdy uv lo yakitsy ni yegw lo yakitsy looñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ni nan gaa to nii deelñee buen tu yag nonsyke nex buen xkyë low, per deelñee buendyo nonsyke nex byodz xkyë low. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xkyëdy nex byodz lo yag buen, ni xkyëdy nex buen lo yag nii buendy. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kchësy yag nii xkyëdy nex buen lo lëëw chug aan lëëw tsek. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Singo gak kchë xaa wnee xuuy schilo kyeñ do pe cos no styoo xaa deelñee kan do kchë nii chuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Lëdy kchë meñ nii xñee lon nii naa nak xaa nii xñabey sëëb laañee xñabey Tat Tios, sink xaktyee meñ nii nli xsoob xtiits Tat Tios sëëb. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tse nii lëë Dios kuñ kyalxtisy ndaly meñ kñë lon: “Xsoob noo xtiitsoo. Con xtiitspeyoo blii noo kyalbini mal, ni con xtiitspeyoo beeñtsyeey noo kyalntson.” ");
INSERT INTO ztqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Per lëën këp lo meñ go: “Nandyaa cho do. Kol kpichee nu, por ngoptol do.” ");
INSERT INTO ztqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Kchë meñ nii xkëëtyag xtitsaa ni chuuñtsyeyo nak sinak tu xaa nyaani nii psaa lidzy lady kyo. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tsiñee lëë kyo bislo ni lëë nis kok naal kiigwpee ni lëë me bi, pe kokty lidzy xaa porñee lady kyo sobo. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per lëë kchë meñ nii xkëëtyag xtitsaa aan chuuñtsyeydyo nak sinak tu xaa nguey nii psaa lidzy lo yuzh. ");
INSERT INTO ztqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsiñee lëë kyo bislo ni lëë nis kok naal kiigwpee ni lëë me bi, lëë lidzy xaa byablyu, ¡aan kaazhkaa kwnitylow! ");
INSERT INTO ztqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tsiñee lëë Jesús lox kwnee, psee meñ biñ kchë nii bluuy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","porñee kwnee xaa sinak tu xaa xñabey, kwneedy xaa sinak xñee chol mastre ley. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tsiñee lëë Jesús bikche kiy, ndaly meñ kunal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kok xtsedyak byety Jesús kiy tsiñee lëë tu xaa xsyaknë nii xyodz lady biid ksoxib lo xaa chëb: —Xey, pe nëëdyoo beeñ kyak naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsigo lëë Jesús pxob ña kik xaa chëb: —Chakladzyaa nii kyakoo. Byak. Aan wor go kazh lëë xaa nii xyodz lady ko byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Per lëë Jesús chëb lo xaa: —Ni tu cho lo këëbtyoo xa byakoo, sink byey aan kwey lo pxosy. Kuksakon nii xñabey xley Moisés parñee kan kchë meñ nii lëël byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lëë Jesús kwsëëb lik leñ kyedzy Capernaum tsiñee lëë tu xaa nii xñabey lo tubtsoon soldad Roma kunee lo xaa ");
INSERT INTO ztqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","chëb: —Xey, lëë xmosaa xsyaknë. Lëë xaa nix chu yu, kutoo xaa ni mban xkyë xaa yoob. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Lëë Jesús kwëb chëb: —Naa kuuñ kyakaa xmoosoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsigo lëë xaa xñabey go chëb: —Xey, cho nakaa nii tsil lidzyaa. Destye nu pxaal tiits nii kyak xmosaa aan lëë xaa kyak. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porque deel naa, no xaa nii mastre xñabey lon, lëë naa lo soldad xñabeyaa. Tsiñee xalaa tu xaa mandad, chi xaa. Tsiñee xkwetsy kaan tu xaa, chiid xaa. Singo gak xmosaa tsiñee xñabeyaa nii kuuñtsyey xaa tu cos, chuuñtsyey xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Axte psee Jesús biñ xaa nii kwnee xaa xñabey go, aan lëë xaa chëb lo meñ nii sinal: —Nli gaa na karty kanaa tu meñ Israel nii kniladzy Dios tyub styoo sinak xniladzy xaa xñabey re. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni lëën kñeli gaa lo do nii ndaly meñ nii nche tyub lo kislyu kawni pxusykoltoo no Abraham, Isaac ni Jacob tse nii lëë Dios kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Per ndaly meñ nii wi xyal sob siko kwe lo nguey ley koon ni kaw lay. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Loxsye ngo lëë Jesús chëb lo xaa nii xñabey lo soldad: —Byey liidzyoo. Lëë nii bniladzyoo tyub styool kak. Aan wor go kazh lëë xmos xaa xñabey go byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsiñee lëë Jesús ptsiñ lidzy Pedre lëë xñaatsaap Pedre nix xlyañ xlyëë. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Lëë Jesús kwseñ ña me, aan lëë xlyëë pchoo. Tsigo lëë me kuxche beeñlo me nii taw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tsiñee lëë lyu pkyey, lëë meñ kuni ndaly xaa nii no kyalbini mal leñ styoo lo Jesús. Aan con tublanak tiits nii kwnee Jesús lëë kchë kyalbini mal go pchoo ni lëë kchë meñ xsyaknë byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Lëë Jesús beeñtsyey ngo parñee kuñ xaa cumplir tiits nii kwnee profet Isaías tsiñee chëb xaa: “Lëë xaa biy kchë xkyalkits no.” ");
INSERT INTO ztqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tsiñee kon Jesús nii singootyee ndaly meñ ptyop, lëë xaa chëb lo xpëëdscuel xaa: —Kol tsoo stublad chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aan lëë tu maestre ley big chëb lo xaa: —Maestre, chakladzyaa sënalaa lii laañee tsityoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tsigo lëë Jesús kwëb chëb: —Chap mëz kyoplyoo ni chap mguiñ pchoos, per lëë naa nii nakaa mguiy nii pxaal Dios ni laañee kxiladzyaa xisy wiñ chaaptyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Loxsye ngo lëë tu xpëëdscuel xaa chëb: —Xey, blaa kajkeetsy kaazhaa pxosyaa, tsigo kyely nalaa lii laañee tsityoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lëë Jesús chëb: —Tënal naa. Lëë meñ nii nak sinak meñ kuty jkeetsy meñ kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lëë Jesús kwyo barkw ksa xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lëë xaa si lo nis ksa xaa, tsiñee lëë tu me dox bislo xchoo aan lëë barkw byaktsë nis. Per lëë Jesús nixyesy. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lëë xpëëdscuel xaa beeñ kna xaa chëb: —¡Pteelaa lëë noo, por lëë barkw nonity leñ nis! ");
INSERT INTO ztqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tsigo lëë Jesús kwëb chëb: —¿Penak nii xtsyeb to? ¿Penak nii kopty to Dios confians? Aan loxsye chëb xaa singo lëë xaa kwnabey nii kwës me ni kwe tse nistoo, aan nli gaa tsesy byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kchësy xpëëdscuel xaa psee xñee: —¿Cho nak xaa re nii axte wi me ni nistoo xsoob xtiits xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tsiñee lëë Jesús ptsiñ xtañ meñ Gadara nii nche stublad chu nistoo, lëë chop xaa nii no kyalbini mal leñ styoo pchoo leñ paa aan lëë xaa big lo Jesús. Ntseeb chak xaa. Por ngo ni tu cho xtyejty nëz ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aan lëë xaa kwchuptsyë chëb xaa lo Jesús: —Jkaaldyoo lëë noo, Jesús. Ndon noo nii Xiñ Dios nakoo. ¿Penak sëëd ksaksil lëë noo? Karty ktsiñ xtsee noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aan kex siko ncheyaw tubtsoon ngutsy. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lëë kyalbini mal go chëb lo Jesús: —Deelñee kwiil lëë noo, bneetsy tiitspey syëëb noo leñ ngutsy nii nche ske. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lëë Jesús chëb: —Kol sëëb. Tsigo lëë kyalbini mal go pchoo chop leñ styoo xaa go, aan lëëw kwsëëb leñ ngutsy. Aan kchë ngutsy ko kwloo corr kukyab lo nis aan lëë ma kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lëë xaa nii nche nap ngutsy ko kuknitiits kyedzy, aan tsiñee ptsiñ xaa, lëë xaa bitiits lo meñ xa ptsyool xaa nii no kyalbini mal leñ styoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aan lëë meñ kyedzy kwey laañee so Jesús, chëb meñ lo xaa: “Beeñ favor, bi nu.” ");
INSERT INTO ztqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Loxsye ngo lëë Jesús kwyo barkw aan lëë xaa ptsiñ laañee nche xkyedzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Siko lëë meñ ptsiñni tu xaa xsyaknë nii kë yag. Tyub lady xaa kutoo. Tsiñee kon Jesús nii xniladzy xaa nii ptsiñni xaa nii lëësy Jesús chuuñ kyak meñ xsyaknë, lëë Jesús chëb lo xaa xsyaknë: —Ndaan kwloo styool. Lëë kchë xtoloo bily. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsigo nladzy bla maestre ley nii nche siko: “Falt no ko xaa gue lo Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per como xyeñ Jesús pe cos xsya styoo xaa, lëë Jesús chëb: —¿Penak nii singueetyee xsya tol do? ");
INSERT INTO ztqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Schilo këpaa lo meñ xsyaknë: “Lëë kchësy xtoloo bily”, ni schilo këpaa: “Kuxche aan kwsë”, per ¿chow dyon mastre ngan? ");
INSERT INTO ztqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lëën kluy lo do gaanoo nii lëë mguiy nii pxaal Dios lo kislyu kwaa tiitspey parñee ktsily xaa xtol meñ. Loxsye ngo lëë Jesús chëb lo xaa nii nëtoo go: —Kuxche, blis xtal aan byey liidzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsigo lëë xaa nëtoo go kuxche aan lëë xaa sey lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tsiñee lox kon meñ nii beeñtsyey Jesús, lëë meñ psee, ni lëë meñ ptee skizh porñee kon meñ nii lëë Dios ptee kyalwnabey lo tu xaa lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsiñee lëë Jesús bi siko, lëë xaa kon nii lëë tu xaa nii lë Mateo sob laañee chikni meñ tumi nii kyey lo xtisy nii sob Roma. Lëë xaa chëb lo Mateo: —Tënal naa. Lëë Mateo kuso aan lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aan lëëtyee lëë Jesús sobyaw lidzy Mateo, lëë bla xaa nii xtop tumi par kyeyo Roma ni lëë bla xaa ngoptol ptsiñ, aan lëë xaa kwsob kwi Jesús ni kwi xpëëdscuel Jesús lo mezh. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tsiñee lëë xaa fariseo kono, lëë xaa kwnabtiits lo xpëëdscuel Jesús, chëb xaa: —¿Pe mod nak nii chawni xmaestre to xaa nii xtop tumi par kyeyo Roma ni penak nii chawni xaa kchë meñ ngoptol gue? ");
INSERT INTO ztqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lëë Jesús biño aan lëë xaa chëb: —Xkiiñdy meñ nii ndaan xaa nii chuñ rmedy, sink meñ xsyaknë xkiiñ xaa nii chuñ rmedy. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kol kyey aan kol kseedy xtiits Dios nii xñee: “Chakladzyaa nii jkëstyoo meñ xcombañer, chaklastyaa nii kiidlookon meñ cos lon.” Syely kyubtyaa meñ buen, sink lëën syely kyub meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lëë xpëëdscuel Juan Bautist big lo Jesús, aan lëë xaa chëb: —Kety kety xtyaawdy noo par kuuñ ksak noo Dios ksa noo xaa fariseo. Lëë xpëëdscueeloo, ¿penak nii xsaandy xaa wagw par kuuñ ksak xaa Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tsigo lëë Jesús chëb: —¿Pe lika nayak tso kyalnë meñ nii chi tu kyalwtsiilña deelñee bii nche meñ nii ptsiilña? Per sitsiñ wor gon nii lëë meñ nii ptsiilña kchoo, tsigolye nagon schilo tso kyalnë meñ ni ksaan meñ wagw. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ni tu cho xkëëtëdy tu ladx yoox con tublë ladx kub, porque tsi lëëw tsadx, lëë ladx kub kpe aan lëëw lox kchos ladx yoox, aan lëë laa nchos ko kak nroobre. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni ni tu cho xkyëdy kaa nip kub leñ tu kyeg kidy nii kwyoxle, porque ntseeb kchoso, aan xiñ nip ni nitylo kyeg. Por ngo no nii ktyëë nip kub leñ kyeg kub, parñee nikle nipo nikle gaa kyego pe kaktyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lëë Jesús nonee lo meñ, tsiñee lëë tu xaa xñabey ptsiñ. Lëë xaa psoxib lo Jesús aan lëë xaa chëb: —Lëë xiñtsyaapaa kuty, per deel sëël kyo no lidzyaa kxoboo ñal lady me, spañ me. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lëë Jesús kunal ksa xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aan lady kchë meñ nii nche siko no tu kwnaa xsyaknë. Kokle tsiipchop iz nii xchoo me cheñ. Lëë me big nëz xitsy Jesús aan lëë me kwseñ skiñ xab xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nladzy me: “Comñee jkaa seeñaa xab Jesús lëën kyak.” ");
INSERT INTO ztqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Per lëë Jesús byoogw buy lo kwnaa go aan lëë xaa chëb: —Ndaan, xiñ, kwloo styool. Por lëël byak porñee bniladzyoo nii schilo kuuñ kyakaa lii. Aan wor go kazh lëë me byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tsiñee lëë Jesús ptsiñ lidzy xaa xñabey go, kon xaa nii lëë musyk tse nche mbës par ktsiñ wkeetsy, ni lëë meñ no wiiñ ni ncheyuptsyë. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lëë xaa chëb: —Kol kchoo nu. Por kujty me, sink lëë me nixyesy. Pxidzy meñ biñ xtiits Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","per loxsye kwlii xaa meñ yu, lëë xaa kwseñ ña mëëd kwnaa go, aan lëë gaa me kuxche. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aan tyub nëz tañ go koknan meñ nii beeñtsyey Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsiñee lëë Jesús bi siko, lëë chop xaa nii xñady lo sinal xitsy xaa, xñee: —¡Lii nii sëëdoo lo xtiiy rey David, pkëstyoo lëë noo! ");
INSERT INTO ztqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tsiñee lëë Jesús ptsiñ lidzy, lëë chop xaa nii xñady lo big lo Jesús aan lëë Jesús chëb lo xaa: —¿Pe xniladzy to nii suuñ kyakaa to? Lëë chop xaa nii xñady lo chëb: —Xniladzy noo nii suuñ kyakoo lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsigo lëë Jesús kwseñ lo chop xaa nii chandy ko aan lëë xaa chëb: —Lëë do kyak porñee bniladzy to nii suuñ kyakaa to. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lëë chop lo xaa go byak. Per lëë Jesús chëb lo xaa: —Ni tu cho lo këbty to xa byak to. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per xaktyee kwlëb xaa pchoo xaa siko. Lëë xaa bislo bitiits xaa nii beeñtsyey Jesús tyub tañ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lëë chop xaa nii byak nonsy lik sey, tsiñee lëë meñ ptsiñni tu ngop nii no kyalbini mal leñ styoo lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lëë Jesús kwlii kyalbini mal go, aan lëë ngop ko bislo kwnee. Kchësy meñ psee kono aan lëë meñ bislo xñee: —Karty kaa nagon tyon no nii kuuñtsyey tu meñ ngue leñ kyedzy Israel. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per lëë xaa fariseo bislo kwnee nii misme xaatox nii xñabey lo kyalbini mal ptee tiitspey lo Jesús parñee kwii xaa kyalbini mal leñ styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kchë kyedzy nii kutedy Jesús bluuy xaa xa nak xkyalwnabey Dios lo meñ leñ ktoo, ni beeñ kyak xaa meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pkëstyoo xaa meñ porñee kon xaa nii mban nche kteenë meñ sinak nii xkwë mëkwxiily tsiñee kindy cho tsikap ma. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aan lëë xaa chëb lo xpëëdscuel xaa: —Nak kchë meñ re sinak tsiñee lëë kwlaap mer kislo aan kindy ndaly mos. ");
INSERT INTO ztqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kol nab lo Dios nii kxaal xaa xaa nii kiid kluuy xtiits xaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lëë Jesús kwtsyetsy ksa tsiipchop xpëëdscuel, aan lëë xaa ptee tiitspey lo xaa parñee kwii xaa kyalbini mal leñ styoo meñ, ni kuuñ kyak xaa meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lëë ksa lë xapostle xaa nche kë nu: Simoñ, xaa nii kwloolë gak xaa Pedre, ni Ndresy betsy Pedre, ni Jacob ni betsy xaa nii lë Juan (Xiñ Zebedeo nak xaa chop xaa), ");
INSERT INTO ztqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ni Felip ni Bartolomé, ni Max ni Mateo (Lëë Mateo kok xaa nii ptop tumi kyedzy par kyeyo Roma), ni xiñ Alfeo nii lë Jacob ni Tadeo, ");
INSERT INTO ztqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ni Simoñ nii kwyo lady tub tiiy xaa nii pcholë Cananista ni Judas Iscariote (Lëë Judas pko Jesús ña xaa xñabey). ");
INSERT INTO ztqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Lëë Jesús pxaal ksa tsiipchop xpëëdscuel, per lëë xaa chëb kazh lo xaa: —Tsidy to tañ nii no meñ sit, ni sëëbty to leñ xkyedzy meñ Samaria. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sink kol tsi lo meñ Israel nii nak sinak mëkwxiily nii ncheno tañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kol tsi aan kol këb nii lëë wor kutsiñ nii lëë Dios kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kol kuñ kyak meñ xsyaknë, ni kol kuñ kpañ meñ kuty, ni kol kuñ kyak kchë meñ nii xyodz lady, ni kol kwii kyalbini mal leñ styoo meñ. Singosy kwaa do kyalwnabey parñee kuuñtsyey do kchë cos re. Por ngo, kñabty to tumi lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Koydy to tumi, ");
INSERT INTO ztqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni koydy to bols nii jkiiñ lo do nëz. Ni koydy to ladx par ktsyëë xab to ni koydy to kyalkidy par ktsyëë lab to, ni koydy to yag nii ksoxka do. Pe tsinidy kik to nii dyon pe kaw do, por kchë xaa nii xkyë tsiiñ nonguial nii kyaan meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Tsiñee ktsiñ do tu kyedzy wiñ o tu kyedzy ngol gaa, kol kyub tu xaa nii knee lidzy kwës to aan siko kol kwës axte nii kpi do kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni tsiñee gaa sëëb to tu leñ yu, kol jkëëptyux kchësy meñ nii no leñ yu go. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Deelñee skëëtyag meñ nii no leñ yu go nii kluuy do, kol nab nii kakni Dios meñ go, per deelñee jkëëtyagty meñ gow kaknidy Dios meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Per deelñee kneesty meñ lidzy kwës to ni kaklasty meñ kon nii xluuy do, kol kchoo yu go o kyedzy go gaa, aan kol kwib yuti nii xña niy do. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Por nli xñen nii tse nii lëë Dios kuñ kyalxtisy, ntseebre kyalnë nii tedy meñ go que kyalnë nii tedy meñ Sodoma ni meñ Gomorra. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Lëën kxal lëë do laañee no meñ ntseeb nii ntseeb si ntseeb kchë ma tox nii chuty mëkwxiily. Per nsiñ kol kak sinak nsiñ mëël, ni kol kak ndoo sinak tu palom. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ligier kol kak, por lëë meñ tsikso lëë do lo xaa xñabey ni lëë meñ kiñ lëë do leñ ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ni axte lo xtisy ni lo rey tsikso meñ do por naa. Siko lëë do kñee xtitsaa lo meñ xñabey ni lo meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per tsiñee lëë do ktsiñ lo xaa xñabey pe tsinidy kik to nii dyon xa kñee do o pe këëb kaa to, por tsiñee tsitsib kñee do, lëë Dios ksyaab leñ kik to pe cos kñee do. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ni kchëë gaa tiits nii kchoo chuw do, lëdy xtiits tow, sink xtiits xkyalbini Tat Tioso. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ni so gaa tse nii lëë meñ kñabey kety betsy ni so tse nii misme pxosy meñ kñabey kety meñ, ni so tse nii lëë xaa wiñ kakniladzy pxosy aan lëë xaa kñabey kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kchësy meñ klëë lo do, porñee xsoob to xtitsaa. Per deelñee xekw to te do kchë lo kyalnë go stelaa do. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tsiñee ktilyni meñ do tu kyedzy, kol kxooñ, kol tsi stu kyedzy. Porque xsobaa nii karty ksa kyedzy nii nche Israel no tedy to tsi lëë mguiy nii pxaal Dios kiid stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Mastre non maestre lo mëëdscuel ni mastre non patrón lo mos. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","No nii tsoxko mëëdscuel kak sinak maestre, ni no nii tsoxko mos kak sinak xpatrón. Deelñee xñee meñ nii xaatox nakni xpixwan yu, ¿pe toodyxe ntseebre nii kñee meñ lo meñ lidzy xpixwan yu? ");
INSERT INTO ztqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ktsyebty to meñ, por nody tu cos ngueetsy nii kchukëdy, ni nody tu cos tsilaan nii kak ndoondy. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kchësy nii chutiitsaa lo do lo nguey kol kutiitso xña lo ngbidz. Ni kchësy kaa nii xñe tsilaanaa lo do kol tsëp kik yu aan nguiedzy kol neew. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ktsyebty to meñ nii chuty, por chilody kuty meñ go xkyalmbañ do. Kol ktsyeb xaa nii schilo kuty xkyalmbañ do ni schilo kxaal lëë do linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Pe karty kaa nayak kan do nii xtyo chop mguiñ wiñ con bla pes? Per ni tu ma chejty deelñee xteejty Tat Tios tiits. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aan lëë lëë do axte kits kik to ngab lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ktsyebty to, por mastre non do lo mguiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Kchësy meñ nii xchoo xfavoraa lo kislyu re, schon xfavor meñ go tsiñee lëë meñ go klyañ lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per lëë meñ nii kchoody xfavoraa lo kislyu re, ni naa kchoody xfavor meñ go lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Këbty to tsaaplaa syelyaa lo kislyu re parñee tsodre tily. Lëdyo gon, sink lëën syelyni tily. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lëën syely parñee ktilyni mëëdpkiy pxosy, ni ktilyni mëëd kwnaa xñaa, ni ktilyni nkwxizh xñaatsaap. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Misme kchë meñ lidzy meñ ktily. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Kchë meñ nii xkëstyoo pxosy ni xñaa aan xkëstyoody naa nonguialdy kak meñ go xpëëdscuelaa, ni meñ nii xkëstyoo xiñgan o xiñtsyaap kaa aan xkëstyoody naa nonguialdy kak xpëëdscuelaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ni deelñee chaklasty meñ te kyalnë ni kiidnaldy meñ naa, nonguialdy kak meñ xpëëdscuelaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kchë xaa nii choxko kteelaa xkyalmbañ kety. Per lëë xaa nii pe sinidy kik, nikxe kety xaa, lëë xaa kpañ porñee xniladzy xaa xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Kchë meñ nii chantsi lëë do, chantsi naa. Ni kchësy meñ nii chantsi naa, chantsi Tat Tios nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kchë meñ nii chantsi tu profet nii pxaal Dios jkaa nii ktee Dios lo profet ko. Ni kchë meñ nii chantsi tu xaa buen jkaa nii ktee Dios lo xaa buen go. ");
INSERT INTO ztqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kchë meñ nii ktee tub xig nis yag ki xaa nii no xladaa, lëë Dios ktikche xkyalnsaak meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tsiñee lëë Jesús lox beeñ kseedy xpëëdscuel, lëë xaa sikluuy xtiits Dios lo meñ nii no tañ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lëëtyee gaa leñ tse go lëë Juan Bautist no skiib tsiñee biñ xaa kchë nii noyuuñtsyey Jesús. Lëë xaa pxaal bla xpëëdscuel xaa ");
INSERT INTO ztqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kunabtiits dyon pe lëë Jesús nak xaa nii kxaal Dios ote no nii yak bii kyëmbës xaa xaa nii kxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lëë Jesús chëb lo xpëëdscuel Juan: —Kol kyey aan kol kutiits lo Juan kchësy nii chan do ni chon do. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kol këb nii lëë meñ nii xñady lo chan, ni lëë meñ nii xsyëdy xsyë, ni lëë meñ nii xyodz lady xyak, ni lëë meñ nii xkwaat chon, ni lëë meñ kuty xpañ, ni lëë kchë meñ mban nii ni tu pe chapty xkëëtyag xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ni kol këb nii dichos meñ nii jkandy kik kan naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tsiñee lëë xpëëdscuel Juan Bautist bi, lëë Jesús bitiits lo meñ cho nak Juan, chëb xaa: —¿Pe cos kukuy do dyon worñee kwey do tañ? ¿Pe kukuy do tublë kizh nii nëz re nëz rek xni me? ");
INSERT INTO ztqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Deelñee kukuydy to kizh nii xni me, ¿pe cos kukuy do? Ote ¿kukuy do tu xaa nii nakw ladx non yak? Por nan do gon nii lidzy rey ncheno kchë xaa nii nakw ladx non. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kol në dyon pe cos kukuy do. Deelñee tu profet gon kukuy do, nli nii profet nak xaa nii kukuy do, per mastre non xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lëë Juan xseety kitsy nii kë xtiits Dios laañee xñeew: Lëën kxal tu xaa nii tenech lool, parñee kwii xaa tu nëz tedyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Lo kchë meñ nii noyaly lo kislyu re xsobaa nii ni tu meñ karty tsitsib sinak Juan Bautist, per lëë laa xñabey Dios kchë xaa nii xisy non chuñ gan lo Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Destye nii biid Juan Bautist axte nina, lëë laa xñabey Dios chak tily, aan lëë meñ ntseeb chakladzy knitylow. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lëë kchë profet ni lëë xley Moisés bluuy xtiits Dios lo meñ worñee karty kiid Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni toon pe sniladzy kaa to nii lëë Juan nak profet Elías nii no kiid. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kchësy to siñee chakladzy to kyeñ do, kol jkëëtyag. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Cho nak sinak meñ nii no natiemp? Nak meñ nii no natiemp gon sinak chol xaa wiñ nii xkwe laañee chak kiy aan xñee xaa lo xcombañer xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ptsyool noo flaut aan byëëdy to, ni ptsyool noo ti nii së mban aan biiñdyak to.” ");
INSERT INTO ztqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Na nii lëë Juan biid, xñee do nii kyalbini mal no leñ styoo xaa, porñee tawdy xaa ni kowdy xaa viñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lëë na nii lëë mguiy nii pxaal Dios chaw ni chi viñ, xñee do nii lyaadzy wagwsye no xaa ni ngonip xaa, ni xñee do nii lëë xaa chi lidzy meñ ngoptol ni lidzy meñ nii xtop tumi par kyey Roma. Per por kchë nii chuuñtsyeyaa xluuy nii Dios nakni naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lëë Jesús bislo kwëntseeb lo meñ nii no kchë kyedzy laañee beeñtsyey xaa kyalntson, porñee ptikchedy meñ go styoo lo Dios. Chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Chooksye lëë doy meñ Corazín ni chooksye lëë do meñ Betsaida! Por deelñee nyan meñ Tiro ni meñ Sidón kchë kyalntson nii kon do, tselye kokw meñ go ladx nchog ni tselye pchoop meñ go xkiti lo kik parñee kluuy meñ go nii ptikche meñ go styoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Por ngo, tse nii lëë Dios kuñ kyalxtisy ntseebre kyalnë nii tedy to que nii tedy meñ Tiro ni meñ Sidón. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lëë lii nii nol leñ kyedzy Capernaum, ¿pe nladzyoo nayak nii sle Dios lool? Kledy xaa gon, sink lëë xaa kxaal lii linfiern. Porque deelñee nyak kchë kyalntson nii konoo leñ kyedzy Sodoma, bii ndyon no kyedzy ko natiemp. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Por ngo, tse nii lëë Dios kuñ kyalxtisy ntseebre kyalnë nii tedy to que nii tedy meñ nii no kyedzy Sodoma. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tsigo lëë Jesús chëb: —Tat Tios, lii xñabey kpaa ni lii xñabey kislyu. Skizhoo porñee kwloolanoo xtiitsoo lo meñ nyaani ni lo meñ chak parñee kluuylo lo meñ ndoladzy nii nak sinak mëëd wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Styool, Tat Tios, kwlañ nii singo kuuñtsyeyoo ni lëëw beeñtsyey gaal. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ni lëë Jesús chëb lo meñ: —Lëë Tat Tios bneetsy kchë nii chap xaa lon ni ni tu cho xyuumbeydy kaa xiñ Tat Tios, xaktyee Tat Tios sye xyuumbey xaa. Singo gak kaa Tat Tios, xaktyee xiñ xaa ni meñ nii kwe xiñ xaa schilo kyuumbey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kol të lon kchësy to siñee xtsag to kë do tsiiñ ni kchësy to siñee noy do yow. Naa knetsy laañee kxiladzy to. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kol ksoob xtitsaa. Kol kuy gaanoo nii chaapaa paciensy ni nguudzy styoon tsiin ktsyol laa kxiladzy to. ");
INSERT INTO ztqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Por ngandy ksoob to xtitsaa ni ndalydy nii kuuñtsyey do. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lëë Jesús sitedy lo tu kwaakon tu tse nii xiladzy meñ Israel lo tsiiñ, tsiñee lëë xpëëdscuel xaa kwlaañ aan lëë xaa bislo xchoow xaa xobxtily parñee kaw xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lëë meñ fariseo kon nii noyuuñtsyey xpëëdscuel Jesús, aan lëë xaa chëb lo Jesús: —Buy gaanoo, lëë xpëëdscueeloo noyuuñtsyey nii nonguialdy kak tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsigo lëë Jesús chëb: —¿Pe karty klab to laañee xñee xa beeñtsyey rey David worñee kwlaañ xaa ksa xcombañer xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kwsëëb xaa leñ lidzy Dios aan taw xaa kyaxtily nii xaktyee pxosy nonguial kaw ni ptee xaa nii taw xaa nii ksa xaa si. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ni pe karty kaa klab to xley Moisés laañee xñee nii lëdy tol chuñ pxosy nii no leñ lidzy Dios nikxe xilasty xaa tse nii xiladzy meñ lo tsiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Per lëën xñe lo do nore nii mastre non lo lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Por xyeñaa nii karty kyeñ do xtiits Dios nii xñee: “Chakladzyaa nii jkëstyoo do xcombañer do, chaklastyaa nii ksakon do ma.” Deelñee nyeñ do tiits ko, nguëëkiydy to meñ nii nody xtol. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Per kol kaknan nii lëë mguiy nii pxaal Dios xñabey lo tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lëë Jesús bi siko aan lëë xaa kwsëëb leñ ktoo nii sob leñ kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lëë tu xaa xsyaknë nii mbañdy tu ña no leñ ktoo go, aan como wi bla meñ nii chakladzy jkëëkiy Jesús nche siko, lëë xaa chëb lo Jesús: —¿Pe nonguial dyon kak meñ xsyaknë rmedy tse nii xiladzy no lo tsiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tsigo lëë Jesús chëb: —Deelñee chap to tu mëkwxiily aan xyab ma leñ tu kyeech nxity tse nii xiladzy meñ lo tsiiñ, ¿pe xkwiidy to ma nayak? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ni mastre gaa non tu meñ lo mëkwxiily! Por ngo lëën xñe nii schilo kuñ ñe kyalbuen tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Loxsye ngo lëë Jesús chëb lo xaa xsyaknë go: —Biskaa ñal. Lëë xaa go biskaa ña, aan lëëw byaktsey. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tsiñee lëë xaa fariseo pchoo ktoo, lëë xaa bislo bitiits xaa dyon xa kuty xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsiñee lëë Jesús byeño, lëë xaa bi siko. Aan ndaly meñ sinal xaa ni ndaly gaa meñ xsyaknë beeñ kyak xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ni chëb xaa lo kchë meñ nii beeñ kyak xaa nii kutiisty meñ cho nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Singo beeñtsyey Jesús parñee kak cumplir nii kwnee profet Isaías tsiñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Lëë xaa re kwlen parñee kuñ xaa xtsiñaa. Xkëstyoon xaa ni xlen lo xaa. Lëën kte xkyalbinin lo xaa, parñee tsikëb xaa lo meñ sit nii lëën kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ktilynidy xaa meñ, ni kuptsyëdy xaa, parñee kondy meñ nii xtyenëz tsiy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni ksaksidy xaa meñ mban nii nak sinak yag nii merle ketsy ni këntseebty xaa lo meñ nii nak sinak bini ntsool nii no nëz kyuuy, sink lëë xaa kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ni lëësy xaa ksaladzy meñ nii ncheno lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lëë meñ kuni tu xaa nii no kyalbini mal leñ styoo lo Jesús. Xñady lo xaa ni ngop xaa, per lëë Jesús beeñ kyak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kchësy meñ nii kon nii beeñtsyey Jesús psee chëb: —¿Pe lëdy kaa lo xtiiy rey David sëëd xaa gue? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsiñee lëë xaa fariseo biñ nii nchenee meñ, lëë xaa chëb: —Beelzebú, xaa nii xñabey lo kyalbini mal ptee tiitspey lo xaa gue parñee kwii xaa kyalbini mal leñ styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per como nan Jesús pe cos xsya styoo xaa fariseo, lëë xaa chëb: —Ni tu kyedzy nii nak chop tiiy gon chilody ktiiy. Lëëw xnitylo. Singo gak kaa meñ wlidzy nii nak chop tiiy chilody ktiiy meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nikle gaa kchë kyalbini mal nii xsoob xtiits xaatox, deelñee ktilyo kchë xcombañero, sikootyee lëë xkyalwnabey xaatox kyal. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Deelñee lëë Beelzebú, xaa nii xñabey lo kchë kyalbini mal, xneetsy tiitspey lon parñee kwin kyalbini mal leñ styoo meñ, ¿cho xtee tiitspey lo xaa nii nak ksa do tsigo parñee kwii xaa kyalbini mal leñ styoo meñ? Sikokesy nagon xluuy nii nandy to pe xñee do. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lëë xKyalbini Dios xnee tiitspey lon parñee kwin kyalbini mal, ni lëë wor gaa kutsiñ nii lëë Dios kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Xa lë nii kwan meñ cos nii no lidzy tu xaa ntseeb na dyon deelñee kxituu kazhty meñ xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Kchë xaa nii nody xfavoraa chiidnidy xaa meñ lon, sink lëë xaa xsëëbtañ meñ porñee xlëë xaa lon. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Nli xñen nii stsily Dios xtol meñ ni kchë tiits yox nii kñee meñ, per ktsildy xaa xtol meñ nii ko falt lo Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni stsily Dios xtol meñ nii ko falt lo mguiy nii pxaal xaa, per lëë meñ nii ko falt lo Kyalbini Ntson, tsitsiñdy tse nii ktsily Dios xtol meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Deelñee xtyoontsi yag, buen nex nii xkyë low. Deelñee xtyoontsidyo, buendy nex nii xkyë low. Singo gak kaa lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Nak to sinak mëël! Chilody kñee do tiits buen por mal do. Ni nan gaa to nii tiits nii no leñ styoo meñ xchoo chuw meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Buen së lo xtiits meñ nii buen no styoo. Buendy së lo xtiits meñ nii no cos mal leñ styoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ni lëën xñe kaazhkaa nii lëë do ktee cuent lo Dios por kchë tiits yox nii kchoo chuw do tse nii lëë xaa kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porque misme tiits nii kchoo chuw do ksoli lëë do o kchon gaa lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Loxsye ngo lëë bla xaa fariseo ni lëë bla maestre ley chëb lo Jesús: —Maestre, beeñtsyey tu kyalntson nii karty kuuñtsyeyoo parñee kniladzy noo nii Dios nakni lii. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tsigo lëë Jesús chëb: —Lëë meñ mal re me chakladzy kan tu kyalntson, aan xsoobty meñ re xtiits Dios, per ni stu kyalntson kantre meñ re. No nii ksaladzy meñ nii ptsyool profet Jonás. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Porque sinak nii kwyo gak Jonás leñ mël lo nistoo tson kpidz tson kyool, singo gak tso mguiy nii pxaal Dios leñ lyu tson kpidz ni tson kyool. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tse nii lëë Dios kuñ kyalxtisy lëë meñ Nínive jkëëkiy meñ nii no natiemp, por ptikche meñ Nínive styoo lo Dios worñee biñ meñ Nínive nii kwnee Jonás, porque mastre precisy nii xluyaa lo do que nii kwnee Jonás. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ni skëëkiy kwnaa nii kok rey kyedzy Sabá meñ nii no natiemp tse nii lëë Dios kuñ kyalxtisy, por sit pchoo me par jkëëtyag me xtiits rey Salomón, ni mastre gaa precisy nii xñen lo do lo kchë xkyalchak Salomón. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Tsiñee lëë tu kyalbini mal xchoo leñ styoo tu meñ, lëëw xkyënsë tañ xyubo dyon pa kwëso. Aan deelñee xtsyoldy pa kwëso, lëëw xñee: ");
INSERT INTO ztqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Lëën kpikche kyan laañee pchon.” Tsiñee lëë kyalbini mal go xtsiñ, chano nii lëë leñ styoo meñ nii pchow tse nak sinak tu yu nii kal lik blyoob ni kwxixkwaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsigo lëëw chikyub skadzy kyalbini nii mastre mal, aan lëëw xsyëëb leñ kik meñ go ksaw, aan mastre mban xtye meñ go. Singo gak nagon ktsyool kchësy meñ mal nii no natiemp. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lëë Jesús bii nonee lo meñ, tsiñee lëë xñaa xaa ni betsy xaa ptsiñ parñee kñee xaa lo Jesús. Aan como kwsëëbty xaa leñ yu, ");
INSERT INTO ztqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","lëë meñ kuni tiits lo Jesús chëb: —Lëë xñaal ni betsyoo nche ley chakladzy kñee lool. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per lëë Jesús chëb lo meñ nii kuni tiits: —¿Cho nak kaa tnan ni cho nak betsyaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Loxsye ngo lëë Jesús bluuy xpëëdscuel aan lëë xaa chëb: —Lëë xaa gue nak tnan ni nak betsyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porque kchësy meñ nii xsoob xtiits Tat Tios nii sob kpaa nak betsyaa, psyañaa ni tnan. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Loxsye kwnee Jesús lo meñ, lëë xaa pchoo leñ yu aan lëë xaa kusob chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsiñee kon xaa nii singootyee ndaly meñ ptyop, lëë xaa kwsob tu leñ barkw aan lëë meñ kwche chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsigo lëë xaa bislo beeñ kseedy xaa meñ nonsyke con cuent, xñee xaa: —Tu ngon name pchoo si kon. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aan tsiñee lëë xaa bislo kon, no xipni xaa byab lo nëz, aan lëëw kutaw mguiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","No gaa laañee byabo lady kyo laañee neeldy lyu, aan blyëëdy lëëw pchukë lyu, porñee nxijty kwyow. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per tsiñee lëë ngbidz kwlañ lëë ngbidz psaayo, aan como kindy luw lëëw pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Lëë stub lugar lëë xipni xaa byab lady yakitsy, aan tsiñee lëë yakitsy kwroob lëë yakitsy kwtiño. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per lëë stub lugar lëë pni byab laañee neely lyu, aan ngui kok xkwaa xaa siko. No laañee ptop xaa tu kyoow lmud xob, no gaa laañee ptop xaa tsongalyo ni no laañee ptop xaa kalyptsii lmudo. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Deelñee chakladzy to kyeñ do, ¡kol jkëëtyag! ");
INSERT INTO ztqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Loxsye ngo lëë xpëëdscuel Jesús big, aan lëë xaa kwnabtiits lo Jesús, chëb xaa: —¿Penak nii nonsyke con cuent chuuñ kseedyoo meñ? ");
INSERT INTO ztqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tsigo lëë Jesús chëb: —Lëë Dios gon xluuy xa nak xkyalwnabey xaa lo do, per xluuydy xaaw lo meñ nii nche tublad. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Por lëë Dios kuuñ kseedy meñ nii chak parñee mastre kak meñ go, per lëë meñ nii chakty, lëë Dios kuñ nii knityladzy meñ go axte kchë nii no kseedy meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nonsyke con cuent chuuñ ksedyaa meñ, porñee xña lo meñ aan chandy meñ, ni chon meñ per xyeñdy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lëë meñ chuñ cumplir nii kwnee profet Isaías tsiñee chëb xaa: Nikxe mastre kon do, per kyeñdy to, nikxe mastre kuy do, per kandy to. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Por lëë styoo meñ lox pkyedzy. Ntse tyag meñ, ni ndiib lo meñ. Kchë nrii ptsyool meñ parñee kchilody kan meñ, ni kon meñ ni kyeñ meñ. Ni lëë meñ ptsyool kchë nrii parñee ktikchedy meñ styoo lon tsiin ktsilyaa xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per dichos to, porñee xña lo do ni chon do. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Por nli xñen nii ndaly profet ni ndaly xaa buen kokladzy nyan nii chan do, per kondy xaaw, ni ndaly xaa kokladzy nguëëtyag nii xkëëtyag to, per pkëëtyagty xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Lëë Jesús chëb: —Lëën kniy lo do xa nak xcuent ngon. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lëë meñ nii xkëëtyag xtiits Dios nii xñee xa nak xkyalwnabey xaa aan xyeñdy xaaw nak sinak pni nii byab lo nëz. Xlyëëdy lëë xaatox chiklaats nii bñaa leñ styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lëë meñ nii gaa xle xkëëtyag xtiits Dios nak sinak pni nii byab lady kyo. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Por sinusy xniladzy meñ go xtiits Dios, per tsiñee chan meñ go nii lëë kyalnë sëëd, lëë styoo meñ go xchoso. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lëë pni nii byab lady yakitsy nak sinak meñ nii xkëëtyag xtiits Dios, per como xsyak meñ go nii mastre precisy toon pere kap meñ go lo kislyu, kchësy ngo nagon xkiñ xtiits Dios nii no leñ styoo meñ go aan xlaadyoo ksoob meñ go xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lëë pni nii byab laañee neely lyu nak sinak meñ nii xkëëtyag xtiits Dios, ni xyeño, ni chuuñtsyeyo. No meñ go nak sinak laañee ptyop tu kyoow lmud xob, no gaa meñ nii nak sinak laañee ptyop tsongaly lmud xob, ni kalyptsii lmudo. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Lëë Jesús pso stu cuent lo meñ, chëb xaa: —Nak laañee xñabey Dios sinak tu xaa nii kon xobxtily lo xkwaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aan mentre lëë xaa nixyesy, lëë tu xaa nii xlëë lo xaa kukan stub clasy pni lo xkwaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Per tsiñee lëë xobxtily kwroob, ni lëëw pchukë to, lëë pni nii kondy xaa kok nyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsigo lëë mos kukëb lo xpixwan kwaa: “Xey, con nonsy xobxtily konoo, ¿pa pchoo kizh nii kwlañ lady xobxtily?” ");
INSERT INTO ztqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lëë xpixwan kwaa chëb: “No cho tu xaa nii xlëë lon kukan kizh ko lady tu xobxtiilyaa.” Lëë mos chëb: “¿Pe syo klaats noo kizh ko?” ");
INSERT INTO ztqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per lëë xpixwan kwaa chëb: “Tsidy to, por toontlaa tsiñee klaats to kizh ko, klaats to wi xobxtily. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Masy kol ksaan kroobo ksaw axte kal lo kwlaap. Tsigolye kxalaa mos tsiktop klo kizh ko ni këpaa kxituu xaaw por manoj parñee tseko. Loxsye ngo lëë xaa kotsey tu xobxtiilyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Lëë Jesús pso stu cuent re lo meñ, chëb xaa: —Nak laañee xñabey Dios sinak tu medzy martas nii xlyañ lo kwaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lëë medzy martas nak tu medzy nii mastre wiich. Per tsiñee lëë yag ko xroob, axte mguiñ chiksaa xipchoos loo go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pso gak xaa stu cuent re, chëb xaa: —Nak xkyalwnabey Dios sinak levadur nii xkots tu kwnaa tson lmud riñ tsiñee xkweek me kobyi. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nonsyke con cuent beeñ kseedy Jesús meñ ");
INSERT INTO ztqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","parñee kak cumplir nii kwnee tu profet tsiñee chëb xaa: Nonsyke con cuent kuuñ ksedyaa meñ. Lëën kluy cos nii karty kon meñ destye nii kwleek Dios kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsiñee lëë meñ lox bi, lëë Jesús byo leñ yu, aan lëë xpëëdscuel xaa chëb lo xaa: —Bluuy loo noo dyon xa nak xcuent kizh nii kwlañ lady xobxtily. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tsigo lëë Jesús chëb: —Lëë mguiy nii pxaal Dios nak xaa nii chan xobxtily. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lo kislyu nak laañee chak kon. Lëë meñ nii xsoob xtiits Dios nak sinak xobxtily. Lëë meñ nii xsoob xtiits xaatox nak sinak pni nii kondy xpixwan kwaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Lëë xaatox kon stub clasy pni. Lëë kwlaap nak si kak tse nii lëë Dios kuñ kyalxtisy. Lëë angly kyë si xkyë xaa nii xkyë kwlaap tse go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sinak nii xkyëktop meñ kizh nii pa xkiiñdy par tseko, singo ktop angly meñ nii ngab lo xaatox tse nii lëë Dios kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lëë xangly mguiy nii pxaal Dios tsiktop kchë meñ nii chuñ xtol xcombañer, ni meñ nii xsaandy xtol. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Lëë angly ko kchësy meñ go leñ worne nii noyek. Siko koon meñ go ni kawlay meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Loxsye ngo lëë kchësy meñ nii xsoob xtiits Dios ksaani laañee xñabey Dios sinak nii xsaani ngbidz. Deelñee chakladzy to kyeñ do, ¡kol jkëëtyag! ");
INSERT INTO ztqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Nak laañee xñabey Dios sinak tu xaa nii xtsyol tu cos non nii no lyu. Aan xle xaa, lëëw xkolyu xaa stub, ni lëë xaa xto kchësy nii chap xaa parñee si xaa lyu go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Nak laañee xñabey Dios sinak tu xaa nii xkyëkyub kyo non nii lë perle. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aan tsiñee xtsyol xaa tu kyo nii nyazh non, lëë xaa chikto kchësy nii chap xaa aan lëëw xsi xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Nikle laañee xñabey Dios nako sinak tu kyex nii xyab lo nistoo aan xtopo kchë clasy mël. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tsiñee lëë kyex lox xyaktsë, lëë ngoosy mël xkwiiw tublad chu nis, aan lëë xaa xsyob xkwe xaa mël. Leñ tskwidy xko xaa ma nii xtyaaw. Lëë ma nii xtyaawdy xsëëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Singo gak kak tse nii lëë Dios kuñ kyalxtisy. Lëë angly kwii meñ nii xsoobty xtiits Dios lady meñ nii xsoobo, ");
INSERT INTO ztqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aan lëë xaa ko meñ nii psoobty xtiits Dios lo ki nii noyek leñ worne. Siko koon meñ go ni kawlay meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lëë Jesús kwnabtiits lo xpëëdscuel chëb: —¿Pe xyeñ do kchë nii xñen lo do? —Xyeeñ noow —kwëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsigo lëë Jesús chëb: —Tsiñee xseedy maestre ley xa nak xkyalwnabey Dios, nak xaa sinak tu xaa nii xkwii cos kub ni cos yoox nii no leñ lidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tsiñee lëë Jesús lox pso kchë cuent ko, lëë xaa bi siko, ");
INSERT INTO ztqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aan lëë xaa kwey xkyedzy xaa. Beeñ kseedy xaa meñ leñ ktoo aan psee meñ biñ xiwseedy xaa, xñee meñ: —¿Pa pseedy xaa kchë cos ke ni pa pseedy xaa kuuñtsyey xaa kchë kyalntson gue? ");
INSERT INTO ztqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Pe lëdy lëë xiñ carpinter ngue nayak? ¿Ni pe lëdy xñaa xaa nayak nak Mariy, ni betsy xaa nak Jacob, José, Simoñ ni Judas? ");
INSERT INTO ztqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ni pe lëdy kaa nayak lady no no psyañ xaa? ¿Pa pseedy xaa kchë cos nii chuuñtsyey xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Por ngo koklasty meñ nsal meñ xaa. Per lëë Jesús chëb: —Laañee xkaatyee xsal meñ tu profet, per deelñee meñ xkyedzy meñ nak profet, xsaldy meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Beeñtsyeydy xaa ndaly kyalntson leñ xkyedzy xaa, porñee bnilasty meñ xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lëë Herodes nii xñabey tyub Galilea tiemp ko biñ kchë nii chuuñtsyey Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","aan lëë xaa chëb lo meñ nii xkyë tsiiñ lo xaa: —Lëë Juan Bautist ngue pañ. Por ngo nii chuñ xaa kchë kyalntson gue. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Singo chëb Herodes porñee lëë xaa kwnabey kwyo Juan skiib ni lëë xaa kwnabey pxituu Juan con caden leñ skiib porsye Herodías, tsiil betsy xaa Felip. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Porñee chëb Juan lo xaa: —Buendy nii tsol chopoo me. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tsigo kokladzy Herodes nyuty Juan, per ptsyeb xaa meñ kyedzy porñee kchësy meñ bniladzy nii xtiits Dios bluuy Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per tsiñee lëë Herodes ptsiil iz, lëë xiñtsyaap Herodías kukyëë laañee nche sob xaa ksa xaa meñ nii kwtsyetsy xaa, aan ptsiladzy Herodes xa byëë me. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Por ngo lëë Herodes pkon Dios lo me nii stee xaa nii kñabtyee me. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lëë me kunabtiits lo xñaa me. Tsi lëë me bikche, chëb me lo Herodes: —Pxob kik Juan Bautist leñ tu plat aan bneetsyo lon. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mban ptee styoo rey Herodes, per como lëëw pchool chuw xaa ni lëëw biñ gaa kchësy meñ nii nche sob siko, ");
INSERT INTO ztqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","lëë xaa kwnabey chug kik Juan leñ skiib. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tsiñee lëë kik Juan lox kwchug, lëëw pxob xaa tu leñ plat, aan lëëw ptee xaa lo xiñtsyaap Herodías, aan lëë me pteedyo lo xñaa me. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lëë xpëëdscuel Juan kuklis Juan aan loxsye pkeetsy xaa Juan, lëë xaa kunitiits lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsiñee lëë Jesús biño, lëë xaa kwyo tu leñ barkw, aan lëë xaa si laañee kindy meñ. Per lëë meñ byeño aan lëë meñ siniy tub lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tsiñee lëë Jesús byety barkw, lëë xaa kon nii singootyee ndaly meñ nche, aan lëë xaa pkëstyoo kchë meñ go ni lëë xaa beeñ kyak meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsiñee lëë tse ptsye lëë xpëëdscuel Jesús big aan lëë xaa chëb lo Jesús: —Lëë tse gon ptsye, aan ni tu kyedzy nchedy nu. Psonëz meñ parñee tsikyub meñ nii kaw. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lëë Jesús chëb: —Xkiiñdy nii kyey meñ. Lëë do kol ktee nii kaw meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lëë xpëëdscuel xaa chëb: —¿Per pe cos kyaan noo kchësy meñ gue? Xaktyee kaayak kyaxtily ni chopak mël nooy noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Lëë Jesús chëb: —Kol të niw nu dyon. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tsigo lëë xaa kwnabey kwsob meñ lo kizhyë. Loxsye ngo lëë xaa kwseñ ksa kaay kyaxtily go ni chop mël go, aan lëë xaa blëp lo kpaa par ktee xaa skizh lo Dios. Loxsye ptee xaa skizh lëë xaa beeñ grol kyaxtily go aan lëëw pteedy xaa lo xpëëdscuel xaa parñee kiisy xpëëdscuel xaaw lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kchësy meñ byëly taw, aan tsiñee lëë wagw kwlox, ptyop tsiipchop tskwidy kyaxtily byuy. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Xkaa meñ nii taw siik kaay mily xaapkiy aan pkabty kwnaa ni pkabty xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Loxsye ngo lëë Jesús blëp xpëëdscuel barkw parñee ktsiñ xaa stublad chu nistoo klo xaa mentre lëë Jesús bii no ksonëz meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tsiñee lëë Jesús lox psonëz meñ, lëë xaa kwyëp kiy par kutiitsni xaa Dios. Lëë lyu lox pkyey aan lëë xaa bii so siko nonsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lëë barkw nii no xpëëdscuel xaa tse si groltyee nistoo, aan lëë nis xchëëp barkw, porñee lëë me bislo xpi. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lëë wor tempran lëë Jesús ptsiñ laañee si barkw xsyë xaa lo nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tsiñee lëë xpëëdscuel Jesús kon nii lëë tu meñ xsyë lo nis, lëë xaa ptsyeb aan lëë xaa kwchuptsyë nladzy xaa neñdy tu pesy chan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per lëë Jesús kwnee chëb: —¡Ktsyebty to. Naaw! ");
INSERT INTO ztqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsigo lëë Pedre chëb: —Deel lii busy nak Jesús, blaa nii sën lo nis parñee kyelyaa axte laañee sol. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lëë Jesús chëb: —Të. Lëë Pedre byety barkw aan lëë xaa bislo xsyë xaa lo nis par ktsiñ xaa laañee so Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per tsiñee byeñ xaa nii lëë me xchëëp xaa, lëë xaa ptsyeb. Ni tsi lëë nis bislo xpix kik xaa, lëë xaa kwchuptsyë chëb xaa: —¡Pteelaa naa! ");
INSERT INTO ztqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lëë Jesús kuseñ ña xaa aan lëë Jesús chëb lo xaa: —¿Penak nii bnilastyoo nii schilo sëël lo nis? ");
INSERT INTO ztqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tsiñee lëë xaa byo leñ barkw, lëë me kwlës. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aan lëë ksa xpëëdscuel xaa nii no leñ barkw psoxib lo xaa chëb: —Nli nii Xiñ Dios nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lëë xaa kwtekë nistoo aan lëë xaa ptsiñ xtañ meñ Genesaret. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tsiñee lëë meñ kyedzy ko byuumbey Jesús, lëë xaa kunitiits kchë kyedzy nii nche kex siko, aan lëë meñ kuni xaa xsyaknë lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ni lëë meñ chëb lo Jesús nii klaa xaa señ meñ xsyaknë siquier skiñ xab xaa, aan kchë meñ xsyaknë nii kwseño byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lëë bla xaa fariseo ni lëë bla maestre ley nii no Jerusalén kwey lo Jesús, aan lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Penak chuuñtsyeydy xpëëdscueeloo nii beeñtsyey pxusykoltoo no nii kawdy xaa deelñee tsadxty ña xaa sinak xñabey xley no? ");
INSERT INTO ztqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Per lëë Jesús chëb: —Kol në dyon nii xsaan do nii xñabey Dios tublad par kuuñtsyey do nii no kik to. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque lëë Dios gon xñee: “Psal pxoosyoo ni xñaal.” Ni lëë gaa Dios xñee nii nonguial kety kchë xaa nii ktsiibtee pxosy o ktsiibtee gaa xñaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per lëë do xñee nii schilo këb tu xaa lo pxosy o lo xñaa gaa: “Chilody kuñaa to yudar, por lëën kwlookon kchësy nii chaapaa lo Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ni lëë do xñee nii këbsye meñ tiits ko nodre nii kuñ meñ pxosy o xñaa gaa yudar. Aan singo mod lëë do xsaan nii xñabey Dios par kuuñtsyey do nii no kik to. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nli gak xtiits Dios nii kwnee profet Isaías worñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tsiñee xñeesy meñ sootee nli nii xsal meñ naa, per sinidy kik meñ nii ksoob meñ xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pe nandy chool meñ lay lon, porque xluuydy meñ xtitsaa, sink nii no kik meñ xluuy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Loxsye ngo lëë Jesús kwtsyetsy meñ aan lëë xaa chëb: —Kol jkëëtyag nii kñen lo do ni kol kyeño: ");
INSERT INTO ztqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni tu cos nii xtyaaw gon chuñdy xtol meñ, sink kchë tiits yox nii xchoo chuw meñ chuñ xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lëë xpëëdscuel Jesús big aan lëë xaa chëb lo Jesús: —¿Pe byeñoo gaa nii blëë xaa fariseo biñ nii kwneel? ");
INSERT INTO ztqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lëë Jesús chëb: —Nak xaa fariseo sinak yag nii beeñ pnidy Tat Tios nii sob kpaa, lëëw klaats xaa si luw. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kol ksaan xaa fariseo, por xñady lo xaa aan chakladzy xaa kluuy xaa nëz lo stu xaa nii xñadyak lo. Aan deelñee kob tu xaa nii xñady lo ña stu xaa nii xñadyak lo chop xaa tsikyab leñ tu kyeech. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsigo lëë Pedre chëb lo Jesús: —Kwnë loo noo dyon xa nak tiits nii chëëboo lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tsigo lëë Jesús chëb: —¿Pe ni lëë do nayak xyeñdy nii kwnen? ");
INSERT INTO ztqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Nandy to nayak nii kchë nii chaw meñ, leñsye meñ chitedyo aan xlyëëdyak lëëw xchoo? ");
INSERT INTO ztqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per lëë kchë tiits yox nii xchoo chuw meñ gon, leñ styoo meñ xlyaño, aan chuño xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque leñ styoo meñ xlyañ nii lëë meñ kuuñtsyey cos mal, leñ styoo meñ xlyañ nii lëë meñ kuty, leñ styoo meñ xlyañ nii lëë meñ tsoni tsiil xcombañer, ni leñ styoo meñ xlyañ nii lëë meñ kwan, ni leñ styoo meñ xlyañ nii lëë meñ jkëëti, ni leñ styoo meñ xlyañ nii lëë meñ kotsyetsy. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kchësy cos re chuñ xtol meñ. Lëdy tol chuñ meñ tsiñee chaw meñ aan xkiibty meñ ña sinak xñabey xley pxusykoltoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Siko pchoo Jesús, lëë xaa si nëz Tiro ni Sidón. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aan lëë tu kwnaa Canaán nii no nëz tañ go big lo Jesús aan lëë me chëb: —¡Xey, lii nii sëëdoo lo xtiiy rey David, pkëstyoo naa! Lëë xiñtsyaapaa xsyaknë. No tu kyalbini mal leñ styoo me. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per psaldy Jesús me. Por ngo lëë xpëëdscuel xaa chëb lo xaa: —Kwnabtiits dyon pe cos chakladzy me, por xaktyee chuptsyë me nal me xitsy no. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsigo lëë Jesús chëb: —Lo meñ Israelsye nii këtañ si xkyëtañ mëkwxiily pxaal Dioosaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per lëë kwnaa go big lo Jesús aan lëë me psoxib chëb me: —¡Xey, pkëstyoo naa! ");
INSERT INTO ztqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Lëë Jesús chëb lo me: —Buendyo nii klan kyaxtily lo mëëd par kteedy noo lo mëkw. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tsigo lëë me chëb: —Tiitsli, xey, xñeel, per xtop mëkw axte kchë plë nii xlaal xpixwan ma leñ mezh. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsigo lëë Jesús chëb lo me: —Lëë xiñtsyaapoo kyak, por bniladzyoo nii syak me. Aan wor go kazh lëë xiñtsyaap me byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsiñee lëë Jesús bi siko lëë xaa ptsiñ chu nistoo Galilea aan lëë xaa kusob tu kik kiy. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ndaly meñ kwey laañee sob xaa. Kuni meñ xaa nii xsyëdy ni xaa nii xñady lo, ni kuni meñ xaa nii mank niy, ni kuni meñ ngop, ni kuni meñ kchëlo xaa xsyaknë lo Jesús aan lëë Jesús beeñ kyak kchë xaa xsyaknë go. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Psee meñ kon meñ nii lëë ngop xñee, ni lëë xaa nii xñady lo chan, ni lëë xaa nii chilody së xsyë. Aan kchësy meñ ptee skizh lo xDios meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lëë Jesús kwtsyetsy xpëëdscuel aan lëë xaa chëb: —Xkëstyoon kchë meñ gue, por natse chak tson kpidz nii nche meñ lon aan kindy pe kaw meñ. Aan deelñee ksonëzaa meñ singosy, ntseeb jkyey meñ nëz. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lëë xpëëdscuel Jesús chëb: —Per ¿pa kyoxii no nii kaw kchë meñ gue, con ni tu cho nody nu par ksyuuyo? ");
INSERT INTO ztqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsigo lëë Jesús chëb: —¿Blak kyaxtily noy do? Aan lëë xaa chëb: —Kadzyo, ni tubtsoon mël wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsigo lëë xaa kwnabey kwsob meñ lo lyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aan lëë xaa kwseñ ksa kadzy kyaxtily go ni mël go. Loxsye ptee xaa skizh lo Dios, lëëw beeñ grol xaa, aan lëë xpëëdscuel xaa kwtiisyo lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kchësy meñ byëly taw aan tsiñee lëë wagw kwlox ptyop kadzy tskwidy kyaxtily byuy. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Siik tap mily xaapkiy taw aan pkabty kwnaa ni pkabty xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Loxsye psonëz Jesús meñ, lëë xaa byëp barkw aan lëë xaa si nëz Magadán. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kwey xaa fariseo ni xaa saduceo lo Jesús nladzy xaa nguëëti xaa Jesús. Por ngo lëë xaa chëb: —Beeñtsyey tu kyalntson nii karty kuuñtsyeyoo dyon tsiin kniladzy noo nii Dios nakni lii. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per lëë Jesús chëb: —Tsiñee xtsye tse name xñee do: “Kyabty kyo kxe, por nixñë leñ kpaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lëë tsi xyaani lyu xñee do: “Lëë kyo kyab natse, por tir nixñë leñ kpaa ni no xkey.” Deelñee nan do xa chak leñ kpaa worñee kyabty kyo o worñee gaa kyabo, penak nii xyeñdy to xa nak kchë cos nii noyak natiemp. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Lëë meñ mal re chakladzy kan tu kyalntson aan xsoobty meñ re xtiits Dios, per kandy meñ re ni stu kyalntson. No nii ksaladzy meñ nii ptsyool Jonás. Loxsye ngo nche gak meñ, lëë Jesús bi. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tsiñee lëë xpëëdscuel xaa si stublad chu nistoo, bnityladzy xaa nyoy xaa kyaxtily. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tsigo lëë Jesús chëb: —Kol kono gaa. Kol kap cuent lo xlevadur xaa fariseo gon ni lo xlevadur xaa saduceo. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsigo lëë xpëëdscuel xaa bislo xñee: —Neñdy porñee nooydy no kyaxtily, ngo nii kwnee xaa singo. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Per lëë Jesús byeñ pe cos ncheyutiits xaa aan lëë Jesús chëb: —¿Penak nii xñee do nii noydy to kyaxtily ni penak nii xnilasty to nii naa kyan lëë do? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pe byeñdy to nawen ni pe xsalasty to worñee kwtiisyaa kaay kyaxtily lo kaay mily meñ, aan blak tskwidy nii byuy dyon ptop to? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ni pe xsalasty to worñee kwtiisyaa kadzy kyaxtily lo tap mily meñ aan blak tskwidy nii byuy dyon ptop to? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Penak nii byeñdy to nii lëdy kyaxtily nii xtyaaw psetyaa lo do worñee niyaa: “Kol kap cuent lo xlevadur xaa fariseo gon ni lo xlevadur xaa saduceo”? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tsigore lëë xpëëdscuel xaa byeñ nii lëdy levadur nii xkyë kyaxtily pseety xaa tsiñee chëb xaa: “Kol kap cuent lo levadur gon”, sink lo kchë nii xluuy xaa fariseo ni xaa saduceo no nii kap xaa cuent. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tsiñee lëë Jesús ptsiñ kyedzy nii lë Cesarea de Filipo, lëë xaa kwnabtiits lo xpëëdscuel xaa, chëb xaa: —¿Pe nan do dyon cho xñee meñ nii nakaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsigo lëë xpëëdscuel xaa kwëb chëb: —No meñ xñee nii lii nak Juan Bautist. No gaa meñ xñee nii lii nak Elías. Ni no stubla meñ nii xñee nii lii nak Jeremías o stu profet. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsigo lëë xaa chëb: —Lëë dook, ¿pe nan do cho nakaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lëë Simoñ, xaa nii xñee gak xaa Pedre chëb: —Lii nak Crist, ni lii nak xiñ Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsigo lëë Jesús chëb: —Simoñ, lii nii nakoo xiñ Jonás, dichoosoo por lëdy chol meñ lo kislyu re nëw lool, sink Tat Tios nii sob kpaa nëw. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Per Pedre xñen lool por lii ladzy kchë meñ nii xniladzy xtitsaa sinak nii xlyadzy kyo yu aan ni kyalkuty kuñdy gan lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Lëën knetsy kyalwnabey lool parñee kchësy meñ nii kuñoo perdón ktsily Dios xtol, per ktsildy xaa xtol meñ nii kuñdyoo perdón. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Loxsye ngo lëë Jesús chëb lo xpëëdscuel nii ni tu cho lo këbty xaa nii lëë Jesús nak Crist. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Destye tse go lëë Jesús bislo xñee lo xpëëdscuel nii lëë xaa tsi Jerusalén, aan lëë xaa kol nii xñabey ni lëë xaa nii xñabey lo pxosy ni lëë maestre ley ksaksi xaa. Chëb xaa nii lëë meñ kuty xaa. Per tse nii loxo tson kpidz lëë xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsigo lëë Pedre kuni Jesús tublad aan lëë xaa kwëntseeb lo Jesús, chëb xaa: —¡Nëdy Dios nii ktsyooloo ngo! ");
INSERT INTO ztqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per lëë Jesús byoogw aan lëë xaa chëb lo Pedre: —¡Bichee nu, xaatox! Toontlaa kuñoo xtolaa. Por nody kikoo sinak no kik Dios, sink sinak no kik meñ lo kislyu re no kikoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Loxsye ngo lëë Jesús chëb lo xpëëdscuel: —Deelñee chakladzy to kak to xpëëdscuelaa, no nii ksaan do kchë nii xyostyoo do ni no nii tedy to kyalnë parñee kchilo kiidnal do naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Por lëë kchë xaa nii choxko kteelaa xkyalmbañ, lo kyalkuty kety. Per lëë xaa nii pe sinidy kik, nikxe kety xaa, lëë xaa kpañ, porñee xniladzy xaa xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Pe nan nii kuuñ xcheñ meñ tyub kislyu, lëëtyak lëë meñ kety? ¿O palal gaa kizh meñ parñee kejty meñ? ");
INSERT INTO ztqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porque lëë mguiy nii pxaal Dios kiid con xkyalwnabey Dios ksa angly aan lëë xaa kizh meñ según nii beeñtsyey meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nli xñen nii no meñ nii nche nu kejty axte nii kan meñ kiid kñabey mguiy ni pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tse nii kwloxo xoop kpidz, lëë Jesús kwey tu kiy nii per nli busy klaa, aan xaktyee Pedre, ni Jacob, ni betsy Jacob nii lë Juan kuni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Siko xña lo xaa lëë Jesús ptsyëëlo. Bibëly lo Jesús sinak xpibëly lo ngbidz ni byak nguitsy xab xaa sinak nguitsy bini. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ni lëë xaa kon nii lëë Moisés ni lëë profet Elías ncheyutiits ksa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsigo lëë Pedre chëb lo Jesús: —¡Xaatee mbëë nche no nu! Pe chakladzyoo nii ksan tson yu yagxiidy, tuwo par lii, stuwo par Moisés, stuwo par profet Elías. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lëë Pedre bii nonee, tsiñee lëë tu xkey nii xpibëly ptyaagw laañee nche xaa aan lëë xaa kwnity lo xkey go ni lëë xaa biñ nii lo xkey go pchootsiy tu xaa nii chëb: —Lëë xiñaa nrii. Naa kwle xaa ni xkëstyoon xaa. Kol jkëëtyag xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsiñee lëë xpëëdscuel Jesús biñ ngo, lëë xaa byab ndooslo lo lyu porñee ptsyeb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Per lëë Jesús big kwtap xitsy xaa chëb: —Kol tsische. Ktsyebty to. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aan tsiñee lëë xaa blis lo xaa, ni tu cho kontre xaa, xaktyee Jesús so siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tsi lëë xaa siksëëb chex kiy go, lëë Jesús chëb lo xpëëdscuel: —Ni tu cho lo kutiisty to nii kon do. Kol kwës axte tse nii kpañ mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsigo lëë xpëëdscuel Jesús kwnabtiits: —¿Penak nii xñee maestre ley nii klo profet Elías kiid? ");
INSERT INTO ztqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Lëë Jesús chëb: —Nli nii klo Elías kiid kweekli kchë cos. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per lëë Elías biidle, aan byuumbeydy meñ xaa, sink lëë meñ psaksi xaa sinak nii ksaksi meñ mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tsigore lëë xpëëdscuel Jesús byeñ nii lëë Juan Bautist biid xlugar profet Elías. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tsiñee lëë xaa ptsiñ laañee nche meñ, lëë tu xaa psoxib lo Jesús aan lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pkëstyoo xiñganaa, por chetyë xaa aan tir xsaksi kyalkits re xaa. No wor xchono xaa lo ki o lo nis kaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Lëë xaa byelynin lo xpëëdscueeloo, per pchilody xpëëdscueeloo nyuñ kyak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lëë Jesús chëb: —¡Natsypee nguiedzy styoo do ni xnilasty to Dios! ¿Axte pa wor këb ñe nii lëën ksaladzy lëë do? ¿Pa slal tiemp no nii kxekwaa lo do? Kol tëni xaa wiñ go nu dyon. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lëë Jesús kwëntseeb lo kyalbini mal go aan lëëw kwlii xaa leñ styoo xaa wiñ go aan wor go kazh lëë xaa byak. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Loxsye byaan Jesús nonsy, lëë xpëëdscuel xaa chëb: —¿Penak nii pchiloody noo ngwii noo kyalbini mal go? ");
INSERT INTO ztqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Tsigo lëë Jesús chëb: —Porñee bnilasty to nii lëë Dios kuuñ kyak xaa wiñ go. Nli xñen nii nikxe palalsye xniladzy to Dios schilo këb to lo kiy re: “Bichee nu, kusob stu lugar”, aan lëë kiy kpichee. Por kchë nii no styoo meñ nii xniladzy Dios chak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nëz Galilea kënsë Jesús tsiñee lëë xaa chëb lo xpëëdscuel xaa: —Lëë mguiy nii pxaal Dios jkaa ña meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aan lëë meñ kuty xaa, per tse nii loxo tson kpidz, lëë xaa kpañ. Mban ptee styoo xpëëdscuel xaa biñ nii chëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tsiñee lëë Jesús ptsiñ leñ kyedzy Capernaum ksa xpëëdscuel, lëë xaa nii xtop tumi nii xkiiñ leñ yu nii lë lidzy Dios kunabtiits lo Pedre chëb: —¿Pe xsoob xmaestroo tumi nii xtop noo? ");
INSERT INTO ztqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Xsoob xaaw —chëb Pedre. Tsiñee lëë Pedre byo leñ yu, klo Jesús kwnee chëb: —¿Pe nëël dyon, Simoñ? ¿Cho lo xtop rey tumi: pe lo xaa xkyedzy xaaw, ote lo xaa sito yak? ");
INSERT INTO ztqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tsigo lëë Pedre chëb: —Lo xaa sito. Chëb kaa Jesús: —Nody tsigo busy nii ksoob xaa xkyedzy tumi. ");
INSERT INTO ztqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per parñee kody no falt lo meñ, kwey chu nistoo aan kwlii tu mël. Leñ chuw ma no tumi. Skaa tumi go tsitixoo nii nsëbaa ni nii nsëëboo lo xaa nii xtop tumi. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Misme tse go lëë xpëëdscuel Jesús big aan lëë xaa kwnabtiits: —¿Cho mastre non laañee xñabey Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lëë Jesús kwtsyetsy tu xaa wiñ, aan lëë xaa pso xaa groltyee. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Loxsye ngo lëë xaa chëb: —Nli xñen nii deelñee ktsëëdy to xmod to ni kak ndolasty to sinak ndoladzy tu xaa wiñ, chilody sëëb to laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kchë xaa nii chakladzy kak tu xaa nii mastre non laañee xñabey Dios no nii kak ndoladzy xaa sinak ndoladzy tu xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ni kchësy kaa meñ nii kantsi tu xaa wiñ porñee xniladzy meñ xtitsaa, naa chantsi meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Kchësy xaa nii kuñ xtol meñ nii xniladzy xtitsaa sinak xniladzy tu xaa wiño nonguial kxituu meñ tu kyomoliñ yañ xaa aan tsikchon meñ xaa lo nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Brob meñ nii nche lo kislyu, por tir xtee tiits nii kuñ meñ tol! Ni tugak kaa kteedyo tiits, per ¡brobsye xaa nii kuñ xtol meñ! ");
INSERT INTO ztqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Por ngo, deelñee ñal o niy gaal chuñ xtoloo, pchugo aan psëëbo. Mbëëre ktsiiñoo lo Dios con tugak niyoo ni tugak ñal, lëjty nii chop ñal ni chop niyoo sob aan kyeyoo lo ki nii chek linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Deelñee mëloo gaal na chuñ xtoloo, kuliiw aan psëëbo. Mbëëre ktsiiñoo lo Dios con tugak mëlool, lëjty nii chop mëlool sob aan kyeyoo lo ki nii chek linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","’Ksyablyudy to meñ ni xniladzy xtitsaa sinak xniladzy tu xaa wiño, por tugak nche angly nii nakni meñ go lo Tat Tios nii sob kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Deelñee nyap to tu kyoow mëkwxiily aan nguëtañ do tu ma, ¿pe nsaandy to stapkalyptsiipkee xcombañer ma nayak aan lëë do nyikyub ma? ");
INSERT INTO ztqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aan deelñee ntsil do ma, nli xñen nii mastre nleni do ma nii kwnity que kchë ma nii kwnijty. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Singo gak Tat Tios nii sob kpaa chaklasty xaa nii kyëtañ meñ nii xniladzy xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Deelñee ko tu xcombañeeroo falt lool, kunee lo xaa aan kudzy xtol xaa. Deelñee son xaa xtiitsoo lëël beeñle gan nii ktiilydre to. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Deelñee ksaldy xaa lii, kunee lo xaa stub, per tsidyoo nonsyoo, sink kuni tu meñ o chop kaa meñ parñee kñee meñ lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Deelñee psaldyak xaa meñ nii kunil, kudzyo lo meñ nii xniladzy xtiits Dios, aan deelñee ksaldyak xaa meñ go, psaan xaa, por nak xaa sinak meñ sit nii xnilasty xtiits Dios, ni nak xaa sinak tu xaa yox nii xtop tumi kyedzy par kyeyo Roma. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Nli xñen nii lëë Dios ktsily xtol kchë meñ nii kuñ do perdón, per ktsildy xaa xtol meñ nii kuñdy to perdón. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ni deelñee gaa nche do chop to tub lugar aan kñab to tugak cos lo Tat Tios, lëëw kneetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porque laañee nche choptson meñ nii xniladzy xtitsaa, lëën so siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Loxsye ngo lëë Pedre chëb lo Jesús: —¿Blak vuelt no nii kuñaa perdón xcombañeraa deelñee ko xaa falt lon? ¿Pe axte kadzy vuelto? ");
INSERT INTO ztqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tsigo lëë Jesús chëb: —Kniydyaa nii no nii kuñoo xcombañeeroo perdón kadzy vuelt, por no nii kuñoo perdón kchë falt nii ko xaa lool. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Nak laañee xñabey Dios sinak tu rey nii kokladzy ndop kchë tumi nii nsëëb mos lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lëë xaa bislo xkwetsy xaa mos nii nsëëb lo xaa aan lëë tu mos nii singootyee nroob tumi nsëëb lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Como nseñdy mos ko tumi par kizh xaa tiñ go, lëë rey kwnabey nii to xaa ksa xiñ xaa ni tsiil xaa ni kchësy nii chap xaa, parñee kazh tiñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lëë mos ko psoxib lo rey aan lëë xaa chëb: “Kop paciensy, skizhaa kchë nii nsëbaa lool.” ");
INSERT INTO ztqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lëë rey pkëstyoo xaa nii nsëëb ko aan lëë rey blaa xaa. Kwtiixty xaa xtiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per tsiñee lëë mos ko pchoo, lëë xaa ptsyool tu xcombañer xaa nii nsëëb toon palalsye tumi lo xaa. Lëë xaa kwseñ yañ xcombañer xaa aan lëë xaa bislo xiyañ xaa xaa, xñee xaa: “¿Pe skizhoo nii nsëëboo lon busy ote kizhtylo yak?” ");
INSERT INTO ztqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsigo lëë xcombañer xaa psoxib lo xaa chëb: “Kop paciensy, skizhaa kchë nii nsëbaa lool.” ");
INSERT INTO ztqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per kwnëdy xaa, sink lëë xaa kulo xcombañer xaa skiib axte nii nguizh xcombañer xaa xtiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tsiñee lëë stubla xmos rey kon nii beeñtsyey xaa go, pteenë xaa aan lëë xaa kukëbo lo rey. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lëë rey kwnabey koktsyetsy mos ko aan lëë rey chëb lo xaa: “¡Natsypee maaloo! Beñaa lii perdón ni beeñ jkizhtyaa lii porñee psoxiboo lon. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Singo gak no nii nyuñoo perdón xcombañeeroo sinak nii beñaa lii perdón.” ");
INSERT INTO ztqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aan lo nii singootyee blëë rey, lëë xaa kwnabey nii te mos ko castigw axte nii kizh xaa kchë nii nsëëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Singo gak nagon ksaksi Tat Tios nii sob kpaa lëë do, deelñee kuñdy to perdón xcombañer do —chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Loxsye kwnee Jesús lo meñ, lëë xaa bi Galilea, aan lëë xaa si nëz Judea. Nëz tañ go xtye kiigwpee Jordán. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndaly meñ kunal aan ndaly meñ xsyaknë beeñ kyak xaa siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lëë bla xaa fariseo big lo Jesús aan parñee kuñ xaa Jesús preb, lëë xaa chëb: —¿Pe schilo dyon klaa mguiy tsiil por cualquier falt nii ko me? ");
INSERT INTO ztqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tsigo lëë Jesús chëb: —¿Pe karty nayak klab to leñ kitsy nii kë xtiits Dios laañee xñee nii worñee lëë Dios psaa kislyu, tugak mguiy ni tugak kwnaa psaa Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Por ngo chëb Dios: “No nii klaa mguiy pxosy ni xñaa parñee kpañ xaa chop tsiil xaa, aan singo mod lëë xaa kyak sinak tugak meñ chop tsiil xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Deelñee tugak meñ tsigo busy nak xaa nii xtsiilña chop tsiil xaa, nody nii klaa xaa me, por lëë Dios pteedy me lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsigo lëë xaa fariseo chëb: —¿Penak tsigo nii kwnabey Moisés nii ktee xaapkiy tublë kitsy lo kwnaa, deelñee klaa xaa me? ");
INSERT INTO ztqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tsigo lëë Jesús chëb: —Porñee koklasty meñ nsoob xtiits Dios, ngo nii lëë Moisés ptee tiits nii klaa tsiil meñ, per lëë mastre klo psëëbtsiildy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ni nli gaa xñen nii deelñee klaa tu mguiy tsiil, aan pkaady me lo xaa chop me stu mguiy, aan ktsiilña xaa stu kwnaa, tol chuñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tsigo lëë xpëëdscuel Jesús chëb: —Deelñee singo xtsyool xaa nii xtsiilña, masy ktsiilñady meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lëë Jesús chëb: —Lëdy kchë mguiy xsyak nii masy buen tsiilñady xaa, xaktyee blasy xaa xsyak nii bueno. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","No xaapkiy nii destye nii koly xaa, chilody kap xaa mëëd. No gaa xaapkiy nii chilody kap xaa mëëd porñee lëë meñ pchug xaa parñee kapty xaa mëëd. Ni no xaapkiy nii schilo ktsiilña ni kap xaa mëëd, per xtsiilñady xaa porñee chakladzy xaa kuñ xaa xtsiiñ Dios. Deel no cho chaklasty ktsiilña, schilo ktsiilñady xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lëë meñ kuni bla xaa wiñ lo Jesús parñee kxob Jesús ña kik xaa wiñ ni kñab xaa lo Dios por kchë xaa wiñ go, per lëë xpëëdscuel Jesús kwëntseeb lo meñ nii kuni xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Per lëë Jesús chëb: —Kol klaa kiid xaa wiñ lon, jkady tow. Por kchë meñ nii nak sinak xaa wiñ kyey laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lëë Jesús pxob ña kik kchë xaa wiñ go, aan lëë xaa bi siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lëë Jesús nol nëz nii kpi xaa tsiñee lëë tu xaa kwey lo Jesús chëb: —Maestre, kwnë kchë cos buen nii no kuuñtsyeyaa parñee jkan kyalmbañ nii xnitylody. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Lëë Jesús chëb: —¿Penak nii xñabtiitsoo pe cos buen? Tugak xaa nii chuuñtsyey cos buen no. Per deelñee chakladzyoo jkaal kyalmbañ nii xnitylody, beeñtsyey nii xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tsigo lëë xaa go chëb: —¿Cho xley Moisés no nii kuuñtsyeyaa? Lëë Jesús chëb: —Kujtyoo, kyubtyoo stu kwnaa deelñee no tsiiloo, kwandyoo, ni jkots tiitskizhtyoo meñ, ");
INSERT INTO ztqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","psoob xtiits pxoosyoo ni xtiits xñaal, ni pkëstyoo xcombañeeroo sinak xkëstyool lii. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lëë xaa go chëb: —Kchësy ngo noyuuñtsyeyaa. Kwnë dyon pe cos chak falt kuuñtsyeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tsigo lëë Jesús chëb: —Deelñee chakladzyoo jkaal kyalmbañ nii xnitylody, byey aan pto kchësy nii chapoo aan pkady tumi go lo meñ prob tsiin kchilo sëëboo laañee xñabey Dios. Loxsye ktol kchë nii chapoo, tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsiñee lëë xaa go biñ nii chëb Jesús, mban ptee styoo xaa porñee tir rikw xaa, aan lëë xaa sey. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsigo lëë Jesús chëb lo xpëëdscuel: —Nli xñen nii neñ sëëb tu rikw laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Masy sinusy te tu camey xan tu kyeech kuzh que nii sëëb tu rikw laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsiñee biñ xpëëdscuel xaa ngo, ntseeb psee xaa aan lëë xaa chëb lo Jesús: —¿Cho lë nii telaa lo tol tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Lëë Jesús buy lo xpëëdscuel aan lëë xaa chëb: —Chilody telaa meñ nonsy, per lëë Dios kteelaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsigo lëë Pedre chëb: —Lëë noo psaan kchësy nii chaap noo aan lëë noo syoop naal lii. Kwnë dyon pe cos jkaa noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Lëë Jesús chëb: —Nli xñen nii tsiñee lëë Dios kuuñ jkub kchë cos nii no lo kislyu, lëë xaa kxaal naa kakaa rey, aan lëën kso lëë do kñabey do ksa tsiipchop tiiy nii no Israel. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kchë meñ nii xsaan lidzy, ni xsaan betsy ni psyañ ni xñaa ni pxosy ni xiñ, ni xsaan xilyu parñee kiidnal naa, siik tu kyoow nii psaan meñ go jkaa meñ go ni lëë meñ go jkaa kyalmbañ nii xnitylody. ");
INSERT INTO ztqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per ndaly xaa nii nyats chak nina kyablyu, parñee ktaan xaa nii mban nina. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Nak laañee xñabey Dios sinak tu xaa nii silyga sikyub mos parñee kyë mos tsiiñ lo xkwaa xaa nii no nonsyke yag uv. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Loxsye byaan xaa tiits nii lal nii xkaa meñ tu kpidz kizh xaa mos, lëë xaa pxaal mos lo xkwaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsi kol las nueve lëë xaa kwey leñ kyedzy stub, aan lëë xaa kon nii lëë stubla xaa nii xkyë tsiiñ nche nlety. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aan lëë xaa chëb: “Kol tsoo kyë do tsiiñ lo xkwaan, na kizhaa lëë do.” Lëë xaa go si. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsi kol xwe ngbidz lëë xaa kwey stub, singo gak tsi lëë las tres kok. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lëë las cinco merle kak tsiñee lëë xaa kwey leñ kyedzy stub, aan lëë xaa kon nii lëë stubla xaa nii xkyë tsiiñ nche nlety. Lëë xaa chëb lo xaa go: “¿Penak nii kwëdy to tsiiñ natse?” ");
INSERT INTO ztqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tsigo lëë xaa go chëb: “Porñee ni tu cho pcheedy lëë noo.” Lëë xaa chëb: “Kol tsoo kyë do tsiiñ lo xkwaan.” ");
INSERT INTO ztqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tsiñee lëë tse ptsye, lëë xpixwan kwaa chëb lo xaa nii xñabey lo mos: “Kwtsyetsy xaa nii kwë tsiiñ, aan kwtiix klo xaa nii kwsëëb lultime. Axte lultime kizhoo xaa nii kwsëëb silyga.” ");
INSERT INTO ztqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Klo xaa nii kwsëëb las cinco kozh aan lal nii xkaa meñ nii xkyë tsiiñ nder tse kwaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsiñee lëë kchësy xaa nii kwsëëb lo tsiiñ silyga kozh nladzy xaa tu masy tu kpidz nguizh xpixwan kwaa xaa, per lalak nii xkaa meñ nii xkyë tsiiñ tu kpidz kwaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tsiñee lëë kchësy xaa go lox kwnaasy tumi go, lëë xaa kwneenë xpixwan kwaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","chëb xaa lo xpixwan kwaa: “Lalak nii kwtiizhoo xaa nii kwë tsiiñ tugak wor name kwtiizhoo lëë noo, aan tyub tse pkyëë noo tsiiñ lo naay.” ");
INSERT INTO ztqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tsigo lëë xpixwan kwaa chëb lo tu xaa nii kwsëëb lo tsiiñ silyga: “Beetsy, xsaksidyaa lii gon. ¿Pe lëdy nayak kazh bñee no nii lal nii xkaa meñ tu kpidz kizhaa lii? ");
INSERT INTO ztqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pseñ xtumil aan byey, por styoon kwlañ nii kizhaa xaa nii kwsëëb lultime lalak nii kwtizhaa lii ");
INSERT INTO ztqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","aan kindy cho pe kñë lon. Por schilo kuuñtsyeyaa nii klyañ styoon con tu tumin. ¿Ote xlëël yak porñee bueenaa?” ");
INSERT INTO ztqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Loxsye ngo lëë Jesús chëb: —No meñ nii nyats chak nina, per sitsiñ tse nii lëë meñ go kyablyu parñee ktaan kchë meñ nii mban nina. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lëë Jesús si Jerusalén, aan nëz no xaa tsiñee lëë xaa kwtsyetsy ksa tsiipchop xpëëdscuel xaa, aan lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Chan do gon, lëë no syo Jerusalén. Siko lëë xaa nii xñabey lo pxosy ni lëë maestre ley kñaasy naa, aan lëë xaa kñab ketyaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ni lëë xaa jko naa ña meñ sit parñee kidyni xaa naa, ni kiñ xaa naa ni lëë xaa jkëë naa lo crusy parñee ketyaa, per tse nii loxo tson kpidz lëën kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Lëë tsiil Zebedeo kunab tu favor lo Jesús ksa xiñ me, aan lëë me psoxib lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsigo lëë Jesús chëb lo me: —¿Pe cos chakladzyoo? Lëë me chëb: —Chakladzyaa nii tsiñee lëël sob kñabeyoo sob tuga xiñaa tyuxlad kwil, tu me nëzli stu me nëzpeg. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lëë Jesús chëb: —Nandy to pe cos xñab to. ¿Pe nyakxe na xekw to tedy to kchë kyalnë nii teedyaa? Tsigo lëë xiñ me chëb: —Xekw noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tsigo lëë Jesús chëb: —Xekw to tedy to kchë kyalnë nii teedyaa. Per lëdy naa kwe xaa nii sob kwin nëzli o nëzpeg kaa. Lëë Tat Tios xyal kwe meñ nii sob siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tsiñee lëë stsii xpëëdscuel Jesús biñ ngo, lëë xaa blëë lo chop xiñ kwnaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Per lëë Jesús kwtsyetsy ksa xpëëdscuel aan lëë xaa chëb: —Nan do gon xa chuuñtsyey xaa nii xñabey lo kislyu. Chuuñ xcheñ xaa laañee xñabey xaa, ni xsoob meñ xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nody nii kuuñtsyey do singo, sink kchë xaa nii kakladzy kñabey lo do no nii ksoob xaa xtiits to. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Singo gak kchë xaa nii kakladzy kak klaa lo do no nii kyë xaa tsiiñ lo do sinak nii xkyë moso. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Singo gak naa syeldyaa parñee kantsi meñaa, sink parñee kantsin meñ, ni ketyaa parñee telaa meñ lo tol syelyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tsiñee lëë Jesús bi Jericó, ndaly meñ sinal xitsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aan lëë chop xaa nii xñady lo nii nche sob chu nëz biñ nii lëë Jesús sitedy siko, aan nguiedzy kwnee xaa lo Jesús chëb xaa: —¡Xey, lii nii sëëdoo lo xtiiy rey David, pkëstyoo lëë noo! ");
INSERT INTO ztqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kwëntseeb meñ lo chop xaa nii xñady lo parñee nyoogw chuw xaa, per mastre nguiedzy kwnee xaa: —¡Xey, lii nii sëëdoo lo xtiiy rey David, pkëstyoo lëë noo! ");
INSERT INTO ztqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lëë Jesús kwso tse, aan lëë xaa kwtsyetsy chop xaa nii xñady lo aan lëë xaa chëb: —¿Pe cos chakladzy to? ");
INSERT INTO ztqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tsigo lëë chop xaa nii xñady lo chëb: —Xey, chakladzy noo nii kña loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Lëë Jesús pkëstyoo chop xaa nii xñady lo aan lëë Jesús kwseñ lo chop xaa go, aan nli gaa wor go kazh lëë lo xaa byak aan lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lëë Jesús mer ktsiñ Jerusalén tsiñee lëë xaa pxaal chop xpëëdscuel xaa kyedzy nii lë Betfagé nii nche chex kiy nii lë Olivos. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Chëb xaa: —Kol tsi kyedzy nii nche kexka ske aan tsiñee ktsiñ do, lëë do kan nii lëë tu burr kusy këtuu chop xiñ. Kol klaa ma aan kol tëni ma lon. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Deelñee cho kñabtiits lo do penak nii xlaa do ma, kol këb nii naa xkiiñ ma ni kol këb na kiid kni gak xaa ma. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Singo beeñtsyey Jesús par kak cumplir xtiits Dios nii kwnee profet tsiñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kol këb lo meñ Jerusalén: “Buy gaanoo ndoladzy xreeyoo, lëë xaa sëëd soobsye xaa lady tu burr wiñ.” ");
INSERT INTO ztqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lëë xpëëdscuel Jesús kwey mandad nii pxaal Jesús xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kuxi xaa burr kusy chop xiñ ma aan loxsye pxoob xaa xab xaa lady ma, lëë Jesús kwsob. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Aan ndaly meñ ptañ xab lo nëz. No gaa meñ pchug xikw yag aan kwleek meño laañee tedy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aan lëë meñ nii nal xitsy xaa ni nech lo xaa bislo kwchuptsyë xñee: —¡Skizh Dios nii pxaal xaa tu xaa nii sëëd lo xtiiy rey David kak xrey no! ¡Lëë Dios nakni xaa! ¡Kol ktee skizh lo Dios! ");
INSERT INTO ztqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tsiñee lëë Jesús kwsëëb leñ kyedzy Jerusalén, kchësy meñ xñabtiits lo xcombañer: —¿Cho nak xaa gue? ");
INSERT INTO ztqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aan lëë meñ nii si ksa Jesús xñee: —Lëë xaa gue nak Jesús. Profet xaa, Nazaret nak xkyedzy xaa. Galilea ngabo. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lëë Jesús kwsëëb leñ lidzy Dios, aan lëë xaa kwlii kchësy meñ nii nche kto ni nche si. Ptische xaa xmezh xaa nii xtsëë tumi lo meñ ni ptsily xaa laañee xsyob xaa nii xto palom. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aan lëë xaa chëb: —Leñ kitsy nii kë xtiits Dios xñee nii lidzy Dios kak tu laañee kiidnee meñ lo Dios. Per lëë do byuño lidzy ngbaan. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aan lëë xaa beeñ kyak meñ nii xñady lo ni meñ nii chilody së nii big lo xaa leñ lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Per tsiñee lëë xaa nii xñabey lo pxosy ni maestre ley kon kchë kyalntson nii beeñtsyey Jesús, ni lëë xaa biñ nii lëë kchë xaa wiñ nii no leñ lidzy Dios bislo chuptsyë xñee: “¡Skizh Dios nii pxaal xaa tu xaa nii sëëd lo xtiiy David!”, lëë xaa blëë ");
INSERT INTO ztqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","aan lëë xaa chëb lo Jesús: —¿Pe chonoo nii xñee xaa wiñ gue? —Chonno —chëb Jesús— ¿ni pe karty kaa nayak klab to leñ kitsy laañee xñee nii lëë Dios kwle mëëd nii bii chadzy par kool mëëd lay lo Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Loxsye ngo nche gak meñ, lëë Jesús si Betania. Siko ptseñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lëë byaani lyu lëë Jesús si Jerusalén stub, aan lëë xaa kwlaañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aan lëë xaa kwey xan tu yag yegw nii sob kex chu nëz, per këdy nex loo go. Xaktyee xikwo singootyee xña. Tsigo lëë xaa chëb lo yag yegw: —¡Kpikchedre kyë nex lool! Aan wor go kazh lëë yag yegw ko pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tsiñee lëë xpëëdscuel xaa kono, kchësy xaa psee, aan lëë xaa kwnabtiits lo Jesús chëb xaa: —¿Xa nak nii blyëëdy pidzy yag yegw? ");
INSERT INTO ztqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Lëë Jesús chëb: —Nli xñen nii deelñee kniladzy to nii schilo kuuñtsyey do tu cos ni jkandy kik to, lëjty xaktyee yag yegw kchilo jkwiitsy to, sink schilo këb to lo kiy re: “Bichee nu aan kukyab lo nistoo”, aan lëë kiy tsikyab. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ni lëë Dios knee kchë nii kñab to deelñee kniladzy to. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lëë Jesús kwsëëb leñ lidzy Dios aan lëë xaa noyuuñ kseedy meñ tsiñee lëë xaa nii xñabey lo pxosy ni bla xaa kol nii xñabey kukëb lo xaa: —¿Cho bneetsy tiitspey lool par kuuñtsyeyoo kchë nii chuuñtsyeyoo? ");
INSERT INTO ztqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Lëë Jesús chëb: —Wi gak gaan dyon kñabtiits tu cos lo do. Deelñee snë dow na tsigo sniyaa cho xnee tiitspey lon par kuuñtsyeyaa kchë cos re. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kol në dyon cho pxaal Juan biid kchobnis xaa. ¿Pe Dioso ote cholsye meño yak? Tsigo lëë xaa bislo xtilytiits lsa xaa, xñee xaa: —Deelñee tyeesy no nii Dios pxaal xaa, kñë xaa lo no: “¿Penak tsigo nii bnilasty to nii bluuy xaa?” ");
INSERT INTO ztqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aan chilodyak tyeesy no nii chol meñ lo kislyu re pxaal Juan, por xtsyeb no meñ. Por kchësy meñ xniladzy nii xtiits Dios bluuy Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Por ngo lëë xaa chëb lo Jesús: —Ndondy noow. Tsigo lëë Jesús chëb: —Per ni naa ngo busy kniydy dyon cho bnee tiitspey lon. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Loxsye ngo lëë Jesús chëb lo xaa: —Tu xaa name chap xaa chop xiñgan xaa aan lëë xaa chëb lo tu xaa: “Xiñ, kwey tsiiñ lo xkwaan natse.” ");
INSERT INTO ztqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lëë xiñ xaa kwëb chëb: “¡Chaklastyaa kan!” Per kok xtsedyako lëë styoo xaa bikche aan lëë xaa kwey. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tsigo lëë xaa go kunee lo stu xiñ aan lëë xiñ xaa chëb: “Na kan.” Aan kweydy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kol në na dyon cho xaa go beeñtsyey nii chakladzy pxosy xaa. Lëë xaa chëb: —Xiñ xaa nii kwey tsiiñ lo xkwaa xaa. Tsigo lëë Jesús chëb: —Nli xñen nii klo xaa nii xtop tumi par kyeyo Roma ni klo kwnaa nii chap ndaly mguiy sëëb laañee xñabey Dios lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Por lëë Juan Bautist biid kluuyle xa kpañ meñ, aan bnilasty to xtiits xaa sinak nii bniladzy xaa nii xtop tumi par kyeyo Roma ni sinak bniladzy kwnaa nii chap ndaly mguiy. Per lëë do, nikxe kon do nii lëë xaa go ptsëë xmod, bnilasty to xtiits Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Kol kon stu cuent re. Tu xaa name beeñ pni xaa yag uv lo xkwaa ni psuugw kwraly xaaw ni psaa xaa tu laañee kxii uv ni psaa xaa tu laañee sob meñ nii kyënapo. ’Loxsye ngo lëëw ptee xaa companiy lo xaa nii kuuñ tsiiño, aan lëë xaa si viaj. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aan tsiñee lëë xtiemp uv kol, lëë xaa pxaal xmos xaa siknab nii xyal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per lëë xaa nii beeñ tsiiñ ptee cheñ xmos xaa, ni no xmos xaa beety xaa go, no gaa xmos xaa pkaa lo kyo. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsigo lëë xpixwan uv pxaal stubtsoon mos. Per singo gak beeñtsyey xaa nii beeñ tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Lultime lëë xpixwan uv pxaal xiñgan nladzy xaa: “Stsyeb xaa go xiñganaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per tsiñee kon xaa go nii lëë xiñgan xpixwan uv ptsiñ, lëë xaa chëb lo xcombañer xaa: “Lëë xaa gue kyaani xkwaa pxosy. Kol tsoo kuuty no xaa tsiin kyaani now.” ");
INSERT INTO ztqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lëë xaa kwnaasy xiñgan xpixwan uv aan lëë xaa kukyeety xaa tublad chu kwaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’¿Pe në do dyon pe cos kuñ xpixwan uv xaa nii beeñ tsiiñ xkwaa xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tsigo lëë meñ kwëb chëb: —Jkëstyoody xaa xaa yox ko, lëë xaa kuty xaa, aan lëë xaa kutiñ xkwaa xaa lo xaa nii kxaal nii ktyop lo xkwaa xaa tsiñee kal xtiemp kwlaap. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lëë Jesús chëb: —¿Pe karty klab to leñ kitsy nii kë xtiits Dios laañee xñee nii lëë kyo nii kwxaak xaa nii xsaa yu xkiiñdy? Byak tu kyo nii mastre xkiiñ. Lëë Dios byuñ kyo go kyo nii xkiiñ, aan xsee no xtyon now. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Por ngo lëë Dios ksaan lëë do aan lëë xaa tsikyub meñ nii ksoob xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Deel kyab meñ lady kyo nii psetyaa lo do, lëë meñ kak byuy. Per deelñee kyab kyo go lady meñ, ni kak nyoody pa kuty meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsiñee lëë Jesús lox pso cuent ko, lëë bla xaa nii xñabey lo pxosy ni lëë xaa fariseo byeñ nii contre lëë xaa kwnee Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kokladzy xaa nyaasy xaa Jesús wor go kazh, per ptsyeb xaa meñ, porñee kchë meñ bniladzy nii xtiits Dios xluuy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Lëë Jesús bislo xso cuent stub, xñee xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Nak laañee xñabey Dios sinak tu rey nii beeñ tu lni worñee ptsiilña xiñgan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aan lëë xaa pxaal xmos xaa sitsyetsy meñ nii tsi lo lni, per kwnëdy meñ go nyi. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lëë rey go pxaal xmos stub, chëb xaa: “Kol këb lo meñ nii lëën tse beeñlo xixkwanaa, ni kol këb nii lëën tse lox bety xyosyaa nii xro. Kol këb lo meñ kiid meñ lo lni.” ");
INSERT INTO ztqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per psaldy meñ nii koktsyetsy xmos rey. No meñ nii koktsyetsy si tañ, no gaa meñ go si lo xtsiiñ, ");
INSERT INTO ztqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ni no meñ nii ptee xcheñ xmos rey, axte nii beety xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Por ngo nii blëë rey, aan lëë xaa pxaal xsoldad xaa kukyeety kchë meñ nii psaksi xmos xaa ni psaay soldad xkyedzy meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Loxsye ngo lëë rey chëb lo xmos: “Lëë nii ktyaaw lo lni nagon lox koklo, per kwnëdy meñ nii koktsyetsy nyiid. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na kol tsi nëz aan kol këb kchë lo meñ nii ktsyool do nii kiid meñ lo xkyalwtsiilña xiñaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Lëë xmos rey pchoo kwey nëz, aan lëë xaa ptop meñ. Nikxe meñ bueno, nikxe gaa malo, kchëlo meñ kuni xaa aan lëë lidzy rey byaktsë. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tsiñee lëë rey kwsëëb leñ yu laañee nche sob meñ nii ptsiñni xmos xaa, lëë xaa kon tu xaa nii nakwty ladx nii chakw meñ nii chi lo tu kyalwtsiilña. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lëë rey chëb lo xaa: “¿Penak nii sëëdoo aan nakwtyoo ladx nii chakw meñ nii chi kyalwtsiilña?” Per ni tu pe chëbty xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsigo lëë rey chëb lo xaa nii xkiisy niskwaan: “Kol kxituu niy xaa re ni ña xaa, aan kol tsikchon xaa lo nguey. Siko koon xaa ni kaw lay xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Loxsye bitiits Jesús ngo, lëë xaa chëb: —Ndaly meñ xkwetsy Dios, per xisy meñ sëëb laañee xñabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lëë xaa fariseo xyub dyon pe cos jkëëkiy xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Por ngo lëë xaa pxaal bla xaa nii no xlad xaa ksa bla xaa nii nak ksa Herodes kukëb lo Jesús: —Maestre, ndon noo nii nonsyke tiitsli xñeel. Xsaldyoo nii xñee meñ ni xseedyoo xa chak meñ. Liisy xluuyoo xa kpañ meñ sinak xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwnë dyon pe nonguial tizh noo tumi nii xtop xtisy Roma ote nonguialdyo yak. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per como nan Jesús pe cos tsiiñ si xaa, lëë Jesús chëb: —¿Penak nii chakladzy to kuñ do naa preb? ");
INSERT INTO ztqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kol kluuy tu pes lon dyon. Tsigo lëë xaa go kuni tu pes lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aan lëë Jesús kwnabtiits: —¿Cho nak xaa nii kë loo go? ");
INSERT INTO ztqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tsigo lëë xaa go chëb: —Lëë xaa nak xtisy Roma. Lëë Jesús chëb: —Kol kizh nii nsëëb to lo xtisy Roma tsigo busy, ni kol kizh nii nsëëb to lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsiñee biñ xaa go nii chëb Jesús, ntseeb psee xaa, aan so gak Jesús, lëë xaa sey. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Misme tse go lëë bla xaa saduceo kwey lo Jesús. Lëë xaa saduceo xñee nii kpañdy meñ kuty. Por ngo lëë xaa kukëb lo Jesús: ");
INSERT INTO ztqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestre, lëë Moisés gon chëb nii deelñee ktsiilña tu xaapkiy aan klyëëdy kety xaa, no nii ktsiilña betsy xaa kwnaa viud nii psaan xaa deelñee chapty me mëëd, parñee kap tsiil betsy xaa nii kuty mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lady noo kwyo tu xaa nii kop xoop betsy, aan lëë xaa ptsiilña. Per blyëëdy lëë xaa kuty, aan como kopty tsiil xaa mëëd, lëë tu betsy xaa byaani tsiil xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","aan lëë xaa kutyak. Singo gak ptsyool stu betsy xaa. Ksa kadzy xaa ptsiilña me, per ni tu xaa psaandy mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lëë byalo wi kwnaa go kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kwnë na dyon cho xaa kyaani kwnaa go tsiñee lëë xaa kpañ, deelñee ksa kadzy xaa ptsiilña me. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tsigo lëë Jesús chëb: —Nandy to pe xñee do, porñee xyeñdy to xtiits Dios ni xnilasty to nii lëë Dios kuuñ kpañ meñ kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Per nli xñen nii tsiñee lëë meñ kuty kpañ, ni mguiy ni kwnaa gaa ktsiilñadre, sink lëë kchë meñ nii kpañ kak sinak angly nii ncheno leñ kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chakladzy to lë kaknan do dyon pe nli spañ meñ kuty. ¿Pe karty nayak klab to laañee xñee nii yuub Dios chëb nii lëë xaa ");
INSERT INTO ztqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","nak xDios pxusykoltoo no Abraham, ni pxusykoltoo no Isaac ni pxusykoltoo no Jacob? Aan Dios gon nakty xaa xDios meñ kuty, sink xDios meñ nii mbañ nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tsiñee biñ meñ kchë nii kwnee Jesús, ntseeb psee meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lëë xaa fariseo ptyop tsiñee biñ xaa nii lëë Jesús psuugw chuw xaa saduceo. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aan lëë tu xaa fariseo nii nak maestre ley kokladzy nyuñ Jesús preb. Por ngo lëë xaa chëb lo Jesús: ");
INSERT INTO ztqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestre, ¿cho nii xñabey Dios dyon kuuñtsyey meñ mastre non? ");
INSERT INTO ztqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tsigo lëë Jesús chëb: —“Bniladzy Tat Tios tyub styool ni psoob xtiits xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ngo mastre precisy kuuñtsyeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ni precisy nii jkëstyool xcombañeeroo sinak nii xkëstyool lii. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nrii xñabey xley Moisés ni nrii biid kluuy kchë profet. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lëë xaa fariseo bii nche siko ");
INSERT INTO ztqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tsi lëë Jesús kwnabtiits chëb: —¿Pe në do dyon cho lo xtiiy sëëd Crist? Tsigo lëë xaa fariseo chëb: —Lo xtiiy rey Davito. ");
INSERT INTO ztqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsigo lëë Jesús chëb: —¿Penak tsigo nii worñee kwnee David xtiits Kyalbini Ntson, chëb David: ");
INSERT INTO ztqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Lëë Dios chëb lo xaa nii xñabey naa: “Kwsob kwin nëzli, axte nii tsitsiñ tse nii kñabeyoo lo kchë meñ nii xlëë lool”? ");
INSERT INTO ztqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xa kchoo Crist lo xtiiy rey David deelñee misme rey David xñee nii lëë Crist xñabey lo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Per ni tu cho kwëbty lo xtiits Jesús, aan destye tse go ni tu cho byaxtre nyabtiits lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Loxsye ngo lëë Jesús chëb lo meñ ni lo xpëëdscuel: ");
INSERT INTO ztqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Lëë maestre ley ni lëë xaa fariseo xyal kluuy xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kol jkëëtyag xtiits xaa. Per kuuñtsyeydy to nii chuuñtsyey xaa, por ngui së lo xtiits xaa, per xaa nii chuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lëë xaa xñee pe cos kuuñtsyey meñ, per chilody kuuñtsyey meño, por nako sinak tu yow në, aan ni lëë xaa chuuñtsyeydyo. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tsiñee chuuñtsyey xaa tu cos xteepee xaa nii kan meñ xaa, ni tsiinpee xkëë xaa xtiits Dios lo kitsy aan xkëë xaaw kë xaa ni chu xikw xaa nii chakw xaa ladx nii xluuy nii nli xaa non nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tsiñee chi xaa laañee chak tu lni, laañee xsyob xaa non xsyob xaa tsi lëë wagw chak, ni xkwe xaa skan nii xsyob xaa leñ ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Stsiladzy xaa nii jkëëptyux meñ xaa pal nëz ni këb meñ lo xaa maestre. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Per lëë do tsookidy to nii kñë meñ lo do maestre, porque tugak nak to, ni tugak maestre no. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni kñeedy to pxosy lo chol meñ, porque tugak pxosy no aan lëë xaa go sob kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni tsookidy to kak to xaa xñabey, por lëësy Crist nak xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kchë xaa nii kakladzy kak nyaa no nii kyë xaa tsiiñ lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Por lëë kchë xaa nii chak nyaa kyablyu. Per lëë Dios klisklaa kchë xaa nii ndoladzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","’¡Chooksye lëë doy maestre ley ni chooksye lëë do nii nak to xaa fariseo!, por xsyonlë do laañee xñabey Dios parñee sëëbty meñ aan xsyëëbty to, ni xlaady kaa to sëëb meñ nii chakladzy sëëb. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Chooksye lëë doy maestre ley ni chooksye lëë do nii nak to xaa fariseo!, por xkyënsë do lo kislyu ni xtyeekë do nistoo xyub to meñ nii sëëb xlad to, aan tsiñee chuñ do gan xsyëëb tu meñ xlad to, mastre chuuñ ktyaly do xtol meñ go que lo xtol do, parñee kyey meñ go linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Chooksye lëëdoy nii xñady lo do! Xñee do nii ndoxty nii kseety meñ lidzy Dios tsiñee xyaan meñ tiits nii lëë meñ kuuñtsyey tu cos nikxe kuuñtsyeydy meño, per deelñee kseety meñ xor lidzy Dios tsiñee xyaan meñ tiits no nii kuñ meño cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tont to ni xñady lo do! ¿Pe nandy to nayak nii deelñee kindy lidzy Dios, kindy pa kak lay or? ");
INSERT INTO ztqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni xñee do nii ndoxty kseety meñ xipkoog lidzy Dios tsiñee xyaan meñ tiits nii lëë meñ kuuñtsyey tu cos, nikxe kuuñtsyeydy meño. Per deelñee kseety meñ kchë nii no lo pkoog tsiñee xyaan meñ tiits, no nii kuñ meño cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Xñady lo do! ¿Pe nandy to nayak nii deelñee kindy pkoog, pa nondy kchë nii chiksakon meñ? ");
INSERT INTO ztqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tsiñee xyaan meñ tiits aan xseety pkoog, lëdy nonsy pkoog xseety meñ, sink wi kchë nii no lo pkoog. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Singo gak kchë meñ nii xseety lidzy Dios tsiñee xyaan meñ tiits, Dios xkon meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kchësy meñ nii xseety kpaa tsiñee xyaan meñ tiits xkon Dios nii sob leñ kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Chooksye lëë doy mastre ley ni chooksye lëë do nii nak to xaa fariseo!, por xtiix to pixtily, ni xtiix to nizh ni comiñ nii xsaakon do lo Dios, per chuñdy to kyalbuen, ni xkëstyoody to meñ ni xsoobty to xtiits Dios. Ngo mastre precisy ni ngo xñabey ley kuuñtsyey do, per ksaandy to nii kokon do cos lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Chakladzy to kuuñtsyey do kchë cos wiñ nii xñabey ley aan xsaan do nii mastre precisy tublad. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Chooksye lëë doy maestre ley ni chooksye lëë do nii nak to xaa fariseo!, por nyë xkiib to vas nii xtyëë nii chi do ni xkiib to kyon nii xtyëë nii chaw do, per xyeñdy to nii nonsyke cos nii kwlan do xkyë do leeñgo. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kol ksaan kyëdre to cos kpaan leñ xvas to, tsiin singo mod lëëw kak nyë. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Chooksye lëë doy maestre ley ni chooksye lëë do nii nak to xaa fariseo!, por nak to sinak paa nii xkoyoo meñ con color nguitsy par kak nguiw nëz fuer, per lëë leeñgo nonsyke xtsit meñ kuty ni cos peedy no. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Singo gak lëë do tsiñee xuy meñ lo do, sootee nli buen do, per lëë leñ styoo do nonsyke kyalmbixladzy ni tol no. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Chooksye lëë doy maestre ley ni chooksye lëë do nii nak to xaa fariseo!, por lëë do xsaa chu xpaa kchë profet ni chu xpaa kchë xaa buen nii biid penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aan loxsye ngo lëë do xñee: “Deelñee ngwe noo xtiemp pxusykoltoo noo, nyuuñdy noo xaa yudar nyuty xaa kchë profet nii biid.” ");
INSERT INTO ztqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Siko nagon xluuy nii xyeñ do nii lo xtiiy xaa nii beety kchë profet nii biid penaadle sëëd to. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Kol kisyaal xtsiiñ pxusykoltoo do! ");
INSERT INTO ztqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Nak to sinak mëël! ¿Cho në nii lëë do telaa lo ki nii chek linfiern? ");
INSERT INTO ztqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lëën kxal profet, ni lëën kxal xaa chak, ni lëën kxal maestre kiidnee lo do, per no xaa nii kxalaa kuty to, ni no xaa jkëë do lo crusy, ni no xcheñ xaa ktee do leñ ktoo ni lëë do kyënlaag xaa kyedzy por kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lëë do kyëkiy kchësy meñ buen nii kuty. Destye xkyalkuty Abel kyëkiy do axte xkyalkuty xiñ Berequias nii lë Zacarías xaa nii beety to kexka lo pkoog leñ lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ni nli xñen nii lëë Dios ksaksi meñ nii nche natiemp por xkyalkuty kchë xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Loxsye ngo lëë Jesús chëb: —¡Chooksye lëë doy nii no do Jerusalén! ¿Penak nii chuty to profet ni penak nii xlaal kyo do xaa nii xaal Dios lo do? ¡Ndaly vuelt gon kokladzyaa ndopaa to sinak nii xtop nguidy xoob xiñ leñ xikw, per kwnëdy to! ");
INSERT INTO ztqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lëë na lëë xkyedzy to kyaanladzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ni kpikchedre gaa kan do naa, axte tse nii lëë do këb: “Skizh Dios, xaatke buen xaa nii pxaal xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tsiñee lëë Jesús pchoo leñ lidzy Dios, lëë xpëëdscuel xaa chëb nii kuy xaa xa nyaa lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lëë Jesús chëb: —Xsee do lë chan do lidzy Dios, per lëëw nitylo. Kchësy kyo nii nyaaw kyablyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Loxsye ngo lëë Jesús kusob chex kiy nii lë Olivos, aan lëë xpëëdscuel xaa chëb lo xaa: —Chakladzy noo nii kñëël loo noo pa wor kak kchë nii kwneel ni xa mod kyeeñ noo nii lëël mer kiid stub ni xa mod kyeeñ noo nii lëë kislyu mer nitylo. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tsigo lëë Jesús chëb: —Kol kap cuent tsiin ni tu cho jkëëtidy lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porque ndaly xaa nii kakladzy kak sinakaa kiid aan lëë xaa kñë nii lëë xaa nak Crist, aan ndaly meñ kyëti. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tsiñee kon do nii lëë guerr chak, ktsyebty to, porque singo no nii kako, per nitylody kaa kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Por no nii kchë kyedzy nii nche lo kislyu ktily lsa, ni lëë kpiñ kiid, ni ndaly laañee kni xu. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lëë kyalnë nii kak tsigo kal bislo. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Lëë meñ ksaksi lëë do, ni lëë meñ kuty lëë do, ni tyub lo kislyu ktilyni meñ do, porñee xsoob to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Leñ tse go ndaly meñ nii xniladzy xtitsaa kchoso styoo, aan lëë meñ go kakniladzy xcombañer. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ni ndaly profet wnee xuuy kiid aan lëë xaa jkëëti meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aan tsiñee lëë xtol meñ lox ktyaly, per ni jkëstyoodre meñ xcombañer. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per stelaa kchë meñ nii ksaandy xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ni axte gaa lox ksa meñ nii nche lo kislyu jkëëtyag xtiits Dios, tsigolye lëë Dios knitylo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Lëë profet Daniel pkëë cos ntseeb nii kak. Tsiñee kan do nii lëë cos ntseeb ko noyak leñ lidzy Dios, ");
INSERT INTO ztqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tsigo kchësy to siñee nche do Judea kol kxooñ, kol tsëp kiy. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Deelñee nche do kik lidzy to, kyejty to par pe kwii do. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Deelñee nche gaa to tañ, per ni par tsikxi do xab to kyeydy to. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Brob kchë kwnaa nii lëëtyee tse go nak xiñ o xkadzy kaa mëëd! ");
INSERT INTO ztqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kol nab lo Dios nii kxooñdy to mëë nii chak nal o tse nii gaa xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque tse go lëë meñ tedy kyalnë dox nii karty te meñ destye nii kwleek Dios kislyu, ni kpikchedre gaa kan meñ kyalnë dox ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aan deelñee jkwëësty Dios kyalnë go, kchësy meñ kety. Per lëëw jkwëës xaa porñee xkëstyoo xaa kchë meñ nii xniladzy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Deelñee cho kñë lo do tse go: “Kol kuy gaanoo, lëë Crist so ske”, o “lëë gaa xaa so nek”, knilasty tow. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque ndaly kchë xaa wnee xuuy kiid aan lëë xaa kñë nii lëë xaa nak Crist, ni ndaly profet wnee xuuy kiid, aan lëë xaa kuuñtsyey kchë clasy kyalntson ni milagre parñee jkëëti xaa meñ. Deelñee steedyo tiits axte wi meñ nii xniladzy Dios kyëti. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lëën kwnel kchë nii kak lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Por ngo, deelñee cho kñë lo do: “Kol kuy gaanoo, lëë Crist so tañ”, tsidy to. O deelñee gaa cho kñë lo do: “Kol kuy gaanoo, lëë Crist nolan nu”, knilasty tow. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porque sinak tsiñee nyoo xbëly yë nkwsiy tyub leñ kpaa, singo kak tse nii lëë Crist kiid stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sinak nii xtyop pech laañee nix ma kuty, singo ktyop meñ tse go. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Tsi lëë kyalnë dox ko lox tedy, lëë lo ngbidz jkyey, ni lëë mëë kyuuy, ni lëë mëly kchingaa leñ kpaa, ni lëë kchë cos nii no leñ kpaa kxisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Loxsye ngo lëë Crist kchoo ktsiib leñ kpaa, aan lëë kchë meñ nii nche lo kislyu ktsyeb ni koon tsiñee kan meñ nii lëë xaa kyety kpaa par kuñ xaa kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lëë xaa kxaal xangly xaa tsijkwets trompet parñee ktop angly kchë meñ nii xniladzy xtiits xaa nii nche tyub lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Tsiñee lëë yag yegw xkëpeñ xyeñ do nii lëë xtiemp kyo sëëd yob. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Singo gak tsiñee kan do nii lëë cos ntseeb ko noyak, kol kyeñ nii lëë Crist mer kiid. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Por nli xñen nii antes nii kety meñ nii no natiemp lëë kchë cos re kak. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Stedy kpaa ni stedy kislyu, per lëë xtitsaa tejtyo. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Per ni tu cho nandy pa tse o pa woor gaa kako, per ni angly nii ncheno kpaa, per ni xiñ Tat Tios. Xaktyee Tat Tios nano. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Sinak kok xtiemp Noé, singo gak kak tsiñee lëë Crist kiid stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Xtiemp Noé worñee karty kislo kyo, lyaadzy wagwsye, ni lyaadzy nii kisy meñ, ni kyalwtsiilñasy kuni kik meñ, axte tse nii lëë Noé byo leñ barkw. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Per mer worñee bii pe sinidy kik meñ, lëë kyo bislo aan lëë meñ kwloow. Singo kak tsiñee lëë Crist kiid stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tse nii lëë Crist kiid, deelñee kë chop xaa tsiiñ lo kwaa, lëë xaa koy tu xaa aan lëë xaa ksaan stu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Singo gak deelñee kë chop kwnaa wëët, lëë xaa koy tu me aan lëë xaa ksaan stu me. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ligier kol kak, por nandy to pa wor kiid Crist stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nako sinak xpixwan tu yu, deelñee kaknan xaa nii lëë ngbaan sëëb lidzy xaa, kaakesty xaa parñee klaady xaa sëëb ngbaan lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ligier kol kak, por lëë Crist kiid mer worñee pe sinidy kik to. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Cho xsaan patrón lidzy dyon tsiñee lëë xaa xchoo? ¿Pe lëdy nayak xsaan xaa tu mos nii xsoob tiits, parñee kyaan mos ko kchë meñ nii xkyë tsiiñ lo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dichos mos nii xyaani lidzy xpatrón deelñee tsiñee kpikche patrón kan xaa nii lëë mos ko beeñtsyey kchë nii kwnabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xsobaa nii lëë patrón këb lo xaa: “Kop cuidad kchësy nii chaapaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per deelñee mal mos ko ni nan xaa nii xtse si xpatrón xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","lëë xaa xsaksi kchë meñ nii xkyë tsiiñ lo xpatrón xaa ni lëë xaa xsyudzy ksa xaa ngonip, ni chawni xaa ngonip. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Per mer tse nii pe sidy kik xaa, lëë xpatrón xaa ktsiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aan lëë patrón ksaksi mos ko sinak nii xsaksi xaa mos nii xsoobty tiits. Tsigo lëë mos ko koon ni lëë mos ko kawlay. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Lëë gak Jesús chëb: —Nak laañee xñabey Dios sinak nii ptsyool tsii kwnaa yeeñ nii kwëmbës ktsiñ tu xaa nii ktsiilña, parñee tsiktsiil nëz me xaa con bini nii xkyë con aceit. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Per kaayak me nyaani, lëë skaay me koñee pe sinidy kik. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lëë ksa kaay kwnaa yeeñ nii koñee pe sinidy kik kwseñ xbini, aan biydy me naal aceit. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per lëë kwnaa yeeñ nii nyaani biy me xbini me ni biy me naal aceit. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aan como xtsiñdy kaa xaa nii ktsiilña, lëë me kuutkesy ksa me. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Per mer wrol kyool, lëë meñ bislo chuptsyë, xñee: “¡Lëë xaa nii ktsiilña sëëd. Kol tsiktsiil nëz xaa!” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lëë ksa kwnaa yeeñ go kuxche, aan lëë me bislo xkëë ki me xbini me. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tsigo lëë ksa kaay kwnaa yeeñ nii koñee pe sinidy kik chëb lo ksa kwnaa yeeñ nii nyaani: “Kol jkady xisy xaceit to loo noo, porque lëë xbinii noo no kyuuy.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per lëë kwnaa yeeñ go chëb: “Jkaajty noow, por jkaadyo jkiiñ noo. Masy kol tsisiw laañee xto meño.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per mentre lëë kwnaa yeeñ nii noydy naal aceit sisiw, lëë xaa nii ktsiilña ptsiñ. Aan lëë ksa kwnaa yeeñ nii noy naal aceit kwsëëb leñ yu ksa xaa nii ktsiilña, aan lëë chu yu byoogw. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsigore lëë ksa kwnaa yeeñ nii kukyub aceit ptsiñ aan lëë me chëb: “¡Xey, pxaly chu yu syëëb noo!” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per lëë xaa nii ktsiilña chëb: “Nandyaa cho do, xyuumbeydyaa lëë do.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Loxsye bitiits Jesús ngo, lëë xaa chëb: —Ligier kol kwe, por nandy to pa tse o pa woor gaa kiid Crist. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Nak laañee xñabey Dios sinak tu xaa nii no nëz tsi stu tañ. Lëë xaa kwtsyetsy xmos xaa aan lëë xaa chëb: “Kol kap cuidad tumi nii ksanaa lo do.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tu lo xaa pteedy xaa kaay bols or, lëë stu lo xaa pteedy xaa chopo, lëë stu lo xaa pteedy xaa tuwo. Loxsye pteedy xaa tumi nii byeñ xaa nii schilo kuuñ tsiiñ catu xmos xaa, lëë xaa si viaj. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Lëë mos nii byaani kaay bols or kwë dilgensy aan lëë xaa ptsiñaa skaay bolso. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Singo gak beeñtsyey mos nii kwaa chop bols or, aan lëë xaa ptsiñaa schop bolso. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per lëë mos nii byaani tu bols or kwteeñ tu kyeech, aan lëëw kwlolyu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Xtse kwey xpatrón mos ko aan tsi lëë xaa bikche, lëë xaa kwlii xcuent xmos xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Klo mos nii byaani kaay bols or ptsiñ, aan lëë xaa chëb lo xpatrón xaa: “Xey, kaay bols or psaanoo lon. Per lëën ptsiñaa skaay bolso.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tsigo lëë xpatrón xaa chëb: “Nyoo nii beeñ tsiiñoo tumi wiñ nii psanaa lool, ni chanaa nii bueenoo. Lëën knetsy tumi roob kuuñ tsiiñoo. Kwyo leñ yu, por xlen lool.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Loxsye ngo lëë mos nii byaani chop bols or ptsiñ aan lëë xaa chëb lo xpatrón xaa: “Xey, chop bols or bneetsyoo lon, per lëën ptsiñaa schop bolso.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsigo lëë xpatrón xaa chëb: “Nyoo nii beeñ tsiiñoo tumi wiñ nii psanaa lool, ni chanaa nii bueenoo. Lëën knetsy tumi roob kuuñ tsiiñoo. Kwyo leñ yu por xlen lool.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per tsiñee lëë mos nii byaani tu bols or ptsiñ, lëë xaa chëb lo xpatrón xaa: “Xey, nanaa nii tir ntseeboo, ni nanaa nii xkyëël kwlaap laañee kondyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Por ngo ptsyeebaa, aan lëën kwya lo lyu xtumil. Per lëëw syelynin.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tsigo lëë xpatrón xaa chëb: “Floojoo ni maaloo, por deelñee nanoo nii ntseebaa ni nanoo nii xkyën kwlaap laañee kondyaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿penak nii kwlootiñdyoo tumi nii psanaa lool parñee nyixiw xiño?” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsigo lëë patrón chëb lo xaa nii nche siko: “Kol kla or nii noy xaa, aan kol kteedyo lo xaa nii noy tsii bols or. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque lëë xaa nii chuuñ tsiiñ nii ptedyaa jkaarew, per lëë xaa nii chuuñ tsiiñdyo, axte nii wiñ ptedyaa lo xaa go klan. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kol tsikchon mos nii pa xkiiñdyke lo nguey. Siko koon xaa ni kaw lay xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Tsiñee lëë Crist kiid kchë xangly, lëë xaa sob par kuñ xaa kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aan lëë kchë meñ nii nche lo kislyu kpig lo xaa, aan lëë xaa kwiixso meñ sinak nii kwiixso meñ mëkwxiily lady chiv. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kwi xaa nëzli kwe meñ buen, lëë meñ mal kwe nëzpeg. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsigo lëë xaa këb lo meñ nii nche nëzli: “Kol të tsiin sëëb to laañee xñabey Dios, por destye worñee kwche kislyu psaa xaaw par lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Por kwyo tse nii kwlaañaa, aan bneetsy to nii tawaa, ni kwyo tse nii kwlaan nis, aan bneetsy to nii kowaa, ni kwëkyubaa posad, aan lëë do bneetsy laa kwlësaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kwyo tse nii bneetsy to ladx kookwaa porñee kindy xabaa, ni kon do naa worñee kwxaaknën, ni biid tedy to lon worñee kwyon skiib.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tsigo lëë meñ buen këb: “¿Pa wor ptyon noo nii xlyaañoo, aan bneetsy noo nii taawoo? ¿Ni pa wor ptyon noo nii xlyaal nis, aan bneetsy noo nii kowoo? ");
INSERT INTO ztqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O pa woor gaa ptyon noo nii këkyuboo posad aan bneetsy noo laañee kwlësoo, ni pa woor gaa ptyon noo nii kindy xaboo aan bneetsy noow? ");
INSERT INTO ztqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ni pa wor kwxaaknël aan ptyon noo lii, o pa woor gaa kwyol skiib aan byoteedy noo lool?” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tsigo lëë Crist këb: “Nli xñen nii kchësy kyalbuen nii beeñtsyey do lo chol meñ, lon beeñtsyey dow.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Loxsye ngo lëë xaa këb lo meñ nii nche nëzpeg: “Kol kpichee nu, kol kyey lo ki nii chek linfiern, por siko kyey xaatox ni siko kyey kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwyo tse nii kwlaañaa, aan bneesty to nii nyawaa, ni kwlaan nis, aan bneesty to nii nyin. ");
INSERT INTO ztqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni kwëkyubaa posad aan bneesty to laañee ngwësaa, ni kon do nii kindy xabaa aan bneesty tow. Kwxaaknën ni kwyon skiib aan biid teejty to lon.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tsigo lëë meñ mal go këb: “¿Pa wor kwlaañoo, ni pa wor kwlaal nis, ni pa wor kwëkyuboo posad, ni pa wor ptyon noo nii kindy xaboo, ni pa wor kwxaaknël, ni pa wor kwyol skiib, aan beeñdy noo lii yudar?” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tsigo lëë Crist këb: “Nli xñen nii tsiñee beeñdy to tu meñ mban yudar, naa ngo beeñdy to yudar.” ");
INSERT INTO ztqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kchësy meñ mal kyey lo ki nii chek linfiern, aan lëë meñ buen jkaa kyalmbañ nii xnitylody. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Loxsye ngo lëë Jesús chëb lo xpëëdscuel: ");
INSERT INTO ztqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Nan do gon nii schopak kpidz chak falt parñee kak paskw, aan lëë meñ jkëë mguiy nii pxaal Dios lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Leñ tse go gak lëë xaa nii xñabey lo pxosy ni lëë xaa kol nii xñabey lo meñ Israel ptyop chilidzy Caifás. Lëë Caifás nak xaa nii mastre non lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Lëë xaa bitiits dyon xa kñaasy xaa Jesús tsiin kuty xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per lëë gak xaa chëb: —Kñaasty no xaa na lni parñee kak nxoldy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lëë Jesús so Betania, aan lëë xaa kwey lidzy Simoñ nii byodz lady. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lëë Jesús sobyaw tsiñee lëë tu kwnaa ptsiñ noy tu bot aceit nyazh nii xlyaa nex, aan lëë me pchoob aceit xlyaa nex ko lo kik Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Per lëë xpëëdscuel Jesús blëë, aan lëë xaa chëb: —¿Penak nii lika kwxiñ aceit ke? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nchilo ndyow par kak meñ prob yudar. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lëë Jesús biñ nii nchenee xaa, aan lëë Jesús chëb: —Klëëdy to lo kwnaa re, por tu buen beeñ me. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ni tugak kaa kan do meñ prob, per naa lëdy tugak kan do naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lëë kwnaa re kwtëëb aceit nii xlyaa nex ladyaa parñee tsel xixkwaa xcuerpaa tse nii lëën jkyeetsy. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nli xñen nii kchë laañee kluuy meñ xtiits Dios, lëë meñ kseety nii beeñtsyey kwnaa re, aan singo mod lëë meñ ksaladzy me. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lëë tu xpëëdscuel Jesús nii pcholë Judas Iscariote kukëb lo xaa nii xñabey lo pxosy: ");
INSERT INTO ztqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—¿Pa lal kizh to naa deelñee jkon Jesús ña do? Lëë xaa xñabey go ptee kalyptsii pes plat. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aan destye wor go lëë Judas kwëkyub dyon xa jko xaa Jesús ña xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tse nii chislo lni nii xtyaaw kyaxtily nii xkyëdy levadur, lëë xpëëdscuel Jesús big aan lëë xaa chëb lo Jesús: —¿Pa kyokuuñloo noo nii tyaaw xtsee no na paskw? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lëë Jesús chëb: —Kol tsi lidzy tu xaa nii kxalaa lëë do aan kol këb: “Lëë maestre në nii lëë xwor xaa kutsiñ, aan lëë xaa kiid ksa xpëëdscuel xaa parñee tedy xaa paskw liidzyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lëë xpëëdscuel Jesús kwey, aan lëë xaa beeñlo nii ktyaaw paskw. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tsiñee lëë lyu pkyey, lëë Jesús kwsob lo mezh ksa xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aan mentre ncheyaw xaa, lëë Jesús chëb: —Nli xñen nii misme tu do kakniladzy naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kchësy xpëëdscuel xaa pteenë, aan lëë xaa bislo tuga xaa xñabtiits, xñee xaa: —¿Pe lëdy naaw? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsigo lëë Jesús chëb: —Xaa nii noyaw leñ tu kyonaa, xaa go kakniladzy naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lëë mguiy nii pxaal Dios te kchë kyalnë nii kë leñ kitsy nii kë xtiits Dios. Per ¡brobsye xaa nii kakniladzy xaa! Masy buen nyi xaa go nyaldy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsigo lëë Judas, xaa nii kukëb lo xaa xñabey xa jkaa Jesús chëb: —Maestre, ¿pe lëdy naaw? —Misme chuwoo pchoow —chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lëë Jesús kwxeñ tu kyaxtily, aan loxsye pteedy xaa skizh lo Dios, lëëw kwtiisy xaa lo xpëëdscuel xaa, chëb xaa: —Kol kaawoo, xcuerpno. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ni lëë xaa kwseñ tu vas nii no viñ, aan loxsye pteedy xaa skizh lo Dios, lëëw pteeso xaa lo xpëëdscuel xaa, chëb xaa: —Kchësy to, kol ki viñ re, ");
INSERT INTO ztqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","por tu cheñno. Lëëw kxee parñee ktsily Dios xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ni kidre gaan viñ, sink lëën kwës axte nii klyañ do laañee xñabey Tat Tios tsiin tyow no viñ kub nii no siko. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Loxsye biily Jesús ksa xpëëdscuel, lëë xaa si kiy nii lë Olivos. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Siko lëë Jesús chëb: —Kchësy to ksaan naa na kyool. Por leñ kitsy nii kë xtiits Dios xñee nii lëë xaa kuty xaa nii xkyë lo mëkwxiily aan lëë mëkwxiily kchoots klyaal. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per tsiñee lëën kpañ, kloon ka Galilea lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tsigo lëë Pedre chëb: —Nikxe kchësy xcombañeraa ksaan lii, per naa ksandyaa lii. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lëë Jesús chëb: —Na kyool kazh tson vuelt këëboo nii xyuumbeydyoo naa antes nii jkwetsy nguidy kol. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lëë Pedre chëb: —Nikxe kety no tusyke, këbtyaa nii xyuumbeydyaa lii. Aan kchësy xpëëdscuel xaa chëb singo. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsiñee lëë Jesús ptsiñ tu laañee lë Getsemaní, lëë xaa chëb lo xpëëdscuel xaa: —Kol sob nu, mentre lëën kakutiitsni Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lëë xaa sini Pedre ni chop xiñ Zebedeo, aan lëë xaa pteenë, ");
INSERT INTO ztqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ni lëë xaa chëb: —Mban xtee styoon. Kol kwës nu dyon, aan kol kwena. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lëë Jesús si par kaan, aan loxsye psoxib xaa ni pkiitsy kë xaa lyu lëë xaa chëb: —Tat Tios, pteelaa naa lo kyalnë re, per kuuñtsyeydyoo nii chakladzyaa, sink beeñtsyey nii chakladzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsi lëë xaa ptsiñ laañee psaan xaa ksa tson xpëëdscuel xaa nii kuni xaa, lëë xaa nche nixyesy. Por ngo lëë xaa chëb lo Pedre: —¿Pe ni tu wor nawen pchilody ngwena do? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kol kwena ni kol kutiitsni Dios parñee jkaaldy xaatox to, por ndaan no styoo do, per lëë lady to mban now. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lëë xaa kwey stub, aan lëë xaa chëb: —Tat Tios, deelñee no nii teedyaa lo kyalnë re, beeñtsyey nii klyañ styool. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsiñee lëë xaa bikche, lëë xpëëdscuel xaa nche nixyesyak, porñee xekwtre xaa mgaal aan lika xtiib lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lëë xaa si stub. Lëë gaaw byon vuelt, aan misme tiits nii chëbak xaa klo chëb xaa lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsi lëë xaa bikche, lëë xaa chëb lo xpëëdscuel xaa: —¿Pe bii nche nixyesy to nawen ni nche kxiladzy to? Lëëw na, lëë wor kutsiñ nii lëë mguiy nii pxaal Dios jkaa ña meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kol tsische tsiin kyoo no, por lëë xaa nii jko naa ña xaa xñabey sëëd kexle. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lëë Jesús bii nonee tsiñee lëë tu xpëëdscuel xaa nii pcholë Judas ptsiñ ksa tubtsoon meñ nii noy spad ni yag. Lëë xaa nii xñabey lo pxosy ni lëë xaa kol nii xñabey pxaal kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lëë Judas chëb kazh lo meñ go: —Xaa nii nagon kawaa tu pxit kwesy, xaa gow. Kol naasy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lëë Judas pkëëptyux Jesús, ni lëë xaa ptee tu pxit kwesy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Loxsye ngo lëë Jesús chëb lo Judas: —Deelñee pe cos tsiiñ sëëdoo, klyëëdyoo beeñtsyeyo. Tsigo lëë meñ kwnaasy Jesús aan lëë meñ biy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tsiñee kon tu xaa nii no xlad Jesús ngo, lëë xaa kwlii xispad xaa aan lëë xaa pchug tu tyag xmos xaa nii xñabey lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Per lëë Jesús chëb: —Psoob xispaadoo xlugaro. Porque kchësy meñ nii xtily con spad, kety con spad. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Pe nandyoo nawen nii deelñee kakladzyaa schilo kñen lo Tat Tios parñee kxaal xaa tub yox xangly xaa kla naa? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per deelñee kñen lo Tat Tios parñee kteelaa xaa naa, ¿xa kak cumplir xtiits xaa tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Loxsye ngo lëë Jesús chëb lo meñ: —¿Penak nii con spad ni con yag sëëdnaasy to naa nyak xaa ngbaan? Ksatyee tse kwson leñ lidzy Dios beeñ ksedyaa meñ aan penak nii kwnaasty to naa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per lëë do chuuñtsyey nrii parñee kuñ do cumplir nii kwnee kchë profet nii biid penaadle. Loxsye ngo so gak Jesús lëë xpëëdscuel xaa pxooñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lëë meñ kuni Jesús lidzy pxosy nii mastre non nii lë Caifás. Siko nche mbës maestre ley ni kchë xaa kol nii xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lëë Pedre kunal sit sit, per lëë xaa ptsiñ axte lo xley Caifás aan lëë xaa kwsob lady xaa nii xkyënap lidzy Dios parñee kan xaa dyon pe cos kuñ meñ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lëë kchë xaa nii xñabey lo pxosy ni lëë xaa non kwëkyub dyon pe cos jkëëkiy xaa Jesús parñee kchilo kñab xaa kety Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ndaly meñ kwnee contre Jesús, per ptsyoldy xaa xñabey pe cos nguëëkiy xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Singo nche xaa tsi lëë schop xaa chëb: —Ptsyon noo kwnee xaa gue nii lëë xaa knitylo lidzy Dios, aan tsonak kpidz me lëëw ksaa xaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsigo lëë xaa nii mastre non lo pxosy kuso, aan lëë xaa chëb lo Jesús: —¿Penak nii xñeedyoo? ¿Pe nli kchë nii xkëëkiy meñ re lii? ");
INSERT INTO ztqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per koñee kwneedy Jesús. Por ngo lëë xaa nii mastre non lo pxosy chëb: —Pkon Dios loo noo dyon, nii nli lii nak Crist nii no kxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tsigo lëë Jesús chëb: —Nliw, naa nak Crist, ni san gaa to naa tsi lëën soob kwi Dios nëzli, ni san do tsi lëën kchukë lo xkey parñee kyelyaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsiñee lëë xaa nii mastre non lo pxosy biñ ngo, lëë xaa pchos xab xaa, porñee singootyee blëë xaa, aan lëë xaa chëb: —Tiits ntseeb kwnee xaa re lo Dios, ni ¿pa jkiiñre gaa no meñ nii jkëëkiy xaa? Misme lëë do biñ kchë tiits ntseeb nii kwnee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Pe në do dyon xa kak xaa? Tsigo lëë meñ chëb: —No nii kety xaa, por no xtol xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wor go kazh lëë meñ pchoo mxeñ lo xaa ni lëë meñ ptee xcheñ xaa. Aan tsi lox ptee meñ xcheñ xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","xñee meñ lo xaa: —Deelñee nli lii nak Crist, ¡kwnë dyon cho kwtiñ lii! ");
INSERT INTO ztqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lëë Pedre sob lo ley, tsiñee lëë tu kwnaa nii xkyë tsiiñ siko chëb lo xaa: —Wil lë no xlad Jesús Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per lëë Pedre chëb: —Nandyaa pe xñeel. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Loxsye ngo lëë Pedre kwey chu puert nii kë chu nëz, aan lëë stu kwnaa kon xaa aan lëë me chëb lo meñ: —Wi meñ gue no xlad Jesús Nazaret. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Per lëë Pedre pkon Dios chëb: —Xyuumbeydyaa xaa gue. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kok xtsedyako, lëë xaa nii nche siko big lo Pedre aan lëë xaa chëb: —Nli gaa na wil lë no xlad Jesús, por si xñeepee xaa xñeel. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsigo lëë Pedre pkon Dios stub chëb: —Xyuumbeydyaa xaa gue. Aan wor go kazh lëë tu nguidy kol pkwetsy. ");
INSERT INTO ztqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lëë Pedre gaa psaladzy nii lëë Jesús chëb: “Tson vuelt këëboo nii xyuumbeydyoo naa antes nii jkwetsy nguidy kol.” Lëë Pedre pchoo siko aan lëë xaa biiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsiñee lëë tañ byeñ, lëë kchësy xaa nii xñabey lo pxosy ni lëë xaa kol nii xñabey bitiits dyon xa kuty xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Loxsye ngo lëë xaa pxituu Jesús aan lëë xaa kuni xaa lo xtisy nii lë Pilat. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tsiñee lëë Judas biñ nii lëë meñ kuty Jesús, lëë xaa pteenë, aan lëë xaa ptikche ksa kalyptsii pes plat nii kozh xaa lo xaa nii xñabey lo pxosy ni lo xaa kol nii xñabey, ");
INSERT INTO ztqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","chëb xaa: —Nody xtol xaa nii pkon ña do. Deelñee kety xaa xfaltno. Per lëë xaa go chëb lo Judas: —¿Pe xcueent noo ngo? ¡Lii kon! ");
INSERT INTO ztqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lëë Judas kuklaal tumi go leñ lidzy Dios. Loxsye ngo lëë xaa sey aan lëë xaa pxiiyañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lëë xaa nii xñabey lo pxosy kuktop tumi go aan lëë xaa chëb: —Chilody jkots no tumi re xtumi lidzy Dios, por con tumi re kozh xaa nii kwnaasy tu xaa nii kety. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aan lëë xaa kwxii tublë lyu con tumi go parñee jkeetsy xaa meñ sit loo go. Xkwaa xaa nii xsaa kis lë kwaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Per destye tse go lëë kwaa go pcholë “Laañee pxee cheñ.” ");
INSERT INTO ztqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Singo mod lëë nii kwnee profet Jeremías kok cumplir tsiñee chëb xaa: “Kalyptsii pes plat kwaa xaa Israel, ");
INSERT INTO ztqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aan con tumi go kwxii xaa lyu nii lë xkwaa xaa nii xsaa kis. Lëë Dios kwnabey nii singo kuuñtsyey xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tsi lëë Jesús ptsiñ lo xtisy lëë xtisy chëb lo xaa: —¿Pe lii nak xrey meñ Israel? —Misme chuwoo pchoo nii naaw —chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lëë xaa nii xñabey lo pxosy ni lëë xaa kol bislo pkëëkiy Jesús, per koñee kwneedy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Por ngo lëë Pilat chëb lo xaa: —¿Penak nii xñeedyoo? ¿Pe chondyoo nayak blaktre nii xkëëkiy xaa gue lii? ");
INSERT INTO ztqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per ni tublan tiits kwneedy Jesús. Por ngo psee xtisy kon xtisy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nak xcostumbre xtisy nii mer lo lni xlaa xaa tu xaa nii no skiib nii kñab meñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aan lëëtyee leñ tse go lëë tu xaa ntseeb nii lë Barrabás no skiib. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsi lëë meñ lox ptyop, lëë Pilat chëb: —¿Pe chakladzy to nii klaan Barrabás, ote chakladzy to yak nii klaan Jesús nii xñee do Crist? ");
INSERT INTO ztqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Singo chëb xaa porñee byeñ xaa nii por kyalmbidy kwnaasy meñ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lëë Pilat sob leñ yulyey tsi lëë tsiil xaa pxaal tu meñ nii kukëb lo xaa: “Byeñ gon pe cos kuñoo, por nody xtol meñ gue, ni tir nguidy kwnee xkaalaa tsi kyool por meñ gue.” ");
INSERT INTO ztqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per lëë xaa nii xñabey lo pxosy ni lëë xaa kol nii xñabey pkiily meñ parñee kñab meñ laa Barrabás ni kñab meñ kety Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lëë xtisy chëb stub: —Kol në dyon cho xaa re klaan. Kchësy meñ chëb: —Blaa Barrabás. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsigo lëë Pilat chëb lo meñ: —¿Xa kuñaa xaa nii xñee do Crist tsigo? Kchësy meñ chëb: —¡Pkëë xaa lo crusy! ");
INSERT INTO ztqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lëë Pilat chëb: —Per kindy xtol xaa. Per lëë meñ chëb stub: —¡Pkëë xaa lo crusy! ");
INSERT INTO ztqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tsiñee lëë Pilat kon nii chondy meñ tiits, sink lëë meñ chak nxolyre, lëë Pilat kwnab nis aan xña lo meñ lëë xaa kwtiib ña xaa, chëb xaa: —Lëë xaa gue kety, per lëdy xfaltno, xfalt tow. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsigo lëë meñ chëb: —¡Nikxe kety xaa, lëë noo ni lëë xiñ noo kizh tol go! ");
INSERT INTO ztqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Por ngo loxsye blaa Pilat Barrabás lëë xaa kwnabey ptee soldad xcheñ Jesús ni lëë xaa kwnabey nii kwë Jesús lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsi lëë bla soldad ptsiñni Jesús chu yulyey lëë los demasy soldad ptyop kyako kwi Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lëë soldad kwlii ladx nii nakw Jesús, aan lëë xaa pkakw xaa tu ladx nixñë, ");
INSERT INTO ztqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ni lëë xaa psoob tu coron yakitsy kik xaa, ni lëë xaa kwloo tu var ñali xaa. Loxsye ngo lëë xaa psoxib lo xaa ni lëë xaa kwtsityni xaa, xñee xaa: —¡Byinayk xrey meñ Israel! ");
INSERT INTO ztqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ni pchoo mxeñ soldad lo Jesús, aan misme var nii no ña Jesús psob xaa kik Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Loxsye kwtsityni xaa Jesús, lëë xaa kwlii ladx nixñë go lady xaa aan lëë xaa pkakw xaa mer xab xaa. Tsigo lëë xaa sini xaa par jkëë xaa xaa lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tsiñee lëë xaa pchoo chu yulyey lëë xaa ptsyool tu xaa Cirene nii lë Simoñ. Aan lëë soldad pkoy xaa xicrusy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lëë soldad kuni Jesús tu laañee lë Gólgota. (Lëë tiits ko nak sinak nii xñee ñe: Laañee nche tsit kik.) ");
INSERT INTO ztqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Siko lëë xaa ptee viñ nii nla lo Jesús. Per loxsye pkëë chuw xaaw, kwnëdy xaa nyi xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tsiñee lëë soldad lox pkëë Jesús lo crusy, lëë xaa kwloo rif xab Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Loxsye ngo lëë xaa kwsob par kyënap xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ni pkëë xaa blalan tiits kik xicrusy Jesús parñee kaknan meñ penak kë xaa lo crusy. Sinrii xñee tiits ko: “Lëë Jesús nrii. Lëë xaa nak xrey meñ Israel.” ");
INSERT INTO ztqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wi chop ngbaan kwë kwi xaa lo crusy, tu xaa nëzli, stu xaa nëzpeg. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aan kchësy meñ nii kwtedy siko kwlootsyetsy xaa ni ptsiiy kik ");
INSERT INTO ztqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","chëb: —¿Pe chanlo na?, lii nii xtischeel lidzy Dios aan tsonak kpidz lëëw tse xsooblil stub. Pteelaa lii ni byety lo crusy deelñee nli Xiñ Dios nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Singo gak kwtsityni xaa nii xñabey lo pxosy xaa, ni maestre ley, ni xaa kol nii xñabey, xñee xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Pteelaa xaa meñ, per chilody kteelaa xaa lëë xaa. Kyety xaa lo crusy dyon deelñee nli lëë xaa nak xrey meñ Israel, parñee kniladzy no xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dios sye psaladzy xaa, na klity Dios xaa lo crusy na deelñee nli xkëstyoo Dios xaa. ¿Pe lëdy në xaa lo no nayak nii Xiñ Dios xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aan axte wi chop ngbaan nii kwë kwi xaa kwlootsyetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tsi lëë xwe ngbidz kol lëë kislyu pkyey aan lëëw byaani axte las tres. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aan wor go nguiedzy kwchuptsyë Jesús, chëb xaa: —Elí, Elí, ¿lema sabactani? (Lëë tiits ko nak sinak xñee ñe: Tat Tios, Tat Tios, ¿penak psaanoo naa?) ");
INSERT INTO ztqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lëëw biñ bla xaa nii nche siko aan lëë xaa chëb lo xcombañer xaa: —Profet Elías xkwetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Per lëë tu xaa nii so siko lëënlëdy kujkadz tublë sponj lo viñ nyi. Lëëw pxituu xaa lo tublë yag, aan lëëw ptsig xaa parñee nsyup Jesúso. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per lëë xcombañer xaa chëb: —Psaan xaa parñee tyon no dyon pe siid klity Elías xaa lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lëë Jesús kwchuptsyë stub, aan lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ni misme wor go lëë ladx nii kë leñ lidzy Dios pchos nsoli, ni lëë kislyu pxisy, ni lëë kchë kyo kwlë, ");
INSERT INTO ztqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ni lëë paa byaly. Aan ndaly meñ nii psoob xtiits Dios nii kutyle bikche pañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aan loxsye pañ Jesús, lëë kchë xaa go pchoo leñ paa, aan ndaly meñ kon nii lëë xaa psëëb leñ kyedzy Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tsiñee lëë xaa nii xñabey lo soldad ni lëë kchë soldad nii nche nap Jesús kon nii lëë xu xni, lëë xaa ptsyeb aan lëë xaa chëb lo xcombañer xa: —Nli nii Xiñ Dios nak xaa re. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wi tubtsoon kwnaa Galilea nche sit xuy. Lëë kwnaa go beeñ Jesús yudar. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lady kchë kwnaa go no María Magdalena, ni tsiil Zebedeo, ni Mariy. Xiñ Mariy nak José ni Jacob. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tsiñee lëë lyu mer jkyey, lëë tu xaa Arimatea nii lë José ptsiñ. Rikw xaa aan wi xaa kwyo xlad Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Lëë xaa kunee lo Pilat aan lëë xaa bnab xcuerp Jesús. Lëë Pilat kwnabey nii ktee soldado. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Lëë José blis xcuerp Jesús, aan lëëw pchal xaa xaa tu ladx rusy, ");
INSERT INTO ztqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aan lëë xaa pkeetsy Jesús leñ tu xpaa kub xaa nii ndeeñ lo kyo. Loxsye ptse xaa chu paa con tu kyo ngol, lëë xaa sey. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Per lëë María Magdalena ni lëë stu Mariy byaan chu paa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tsi lëë lyu byaani lëë xaa nii xñabey lo pxosy ni xaa fariseo kwey lo Pilat ");
INSERT INTO ztqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","aan lëë xaa chëb: —Worñee bii mbañ xaa wnee xuuy go, chëb xaa nii tse nii loxo tson kpidz lëë xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por ngo, lëë noo syoopnee lool parñee kxaaloo xaa nii kyënap chu paa axte ksa tson kpidz. Por toontlaa tsilii xpëëdscuel xaa xcuerp xaa leñ paa wor kyool aan loxsye ngo këb xaa lo meñ nii lëë Jesús pañ. Aan ndalyre meñ nii jkëëti xaa que meñ nii pkëëti xaa klo. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsigo lëë Pilat chëb: —Lëë soldad nche ske. Kol tsini xaa parñee kyënap xaa chu paa. ");
INSERT INTO ztqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lëë xaa kwey, aan lëë xaa kwloo tu señ lady kyo nii xoob chu paa, ni lëë xaa psaan soldad parñee kyënap soldad. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tsiñee lëë tse nii xiladzy meñ lo tsiiñ kwtedy, lëë María Magdalena ni lëë stu Mariy kwey chu paa wor silytoo. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aan kolpsye lëë tu xu dox bni, porñee lëë tu xangly Dios byety kpaa, aan lëë xaa kwtob kyo nii xoob chu paa. Loxsye ngo lëë xaa kwsob lady ko. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Xpibëly angly ko sinak tu xbëly yë nkwsiy ni nguitsy xab xaa sinak nguitsy kyeg. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tsiñee lëë soldad kon angly ko, lëë xaa ptsyeb aan lëë xaa pkyey. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lëë angly chëb lo kwnaa go: —Ktsyebty to, por nanaa nii Jesús nii kwë lo crusy xyub to. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Per kindy me nu. Lëë me pañle. Kol kuy gaanoo nu pxoob me. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sinusy kol kyey aan kol këb lo xpëëdscuel me nii lëë me pañ, ni kol këb nii klo me ktsiñ Galilea. Siko ktsiil me xpëëdscuel me. Tiits re syelynin lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lëënlëdy lëë kwnaa go bi chu paa. Lal xtsyeb me, lal xle me, per lëë me sikni tiits lo xpëëdscuel Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aan lëë Jesús byaklo lo me ni lëë xaa pkëëptyux me. Lëë me big lo Jesús aan lëë me psoxib lo xaa ni lëë me kwteetsy niy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lëë xaa chëb: —Ktsyebty to. Kol tsikni tiits lo xpëëdscuelaa parñee tsi me Galilea, aan siko ktsiil noo. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mentre lëë kwnaa go sikni tiits, lëë bla soldad nii kwënap chu paa kwey leñ kyedzy, aan lëë xaa bitiits lo xaa nii xñabey lo pxosy kchësy nii kon xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsigo lëë xaa nii xñabey lo pxosy kunee lo xaa kol nii xñabey parñee kutiits xaa dyon xa kuuñtsyey xaa. Aan nroob tumi pteedy xaa lo soldad, ");
INSERT INTO ztqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","per lëë xaa chëb kazh lo soldad: —Deelñee kñabtiits meñ lo do kol këb nii kyool, mentre nche nixyesy to, lëë xpëëdscuel Jesús biidxi xcuerp xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aan deelñee kon xtisyo, lëë noo kñee lo xaa parñee pe kuñdy xaa lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Lëë soldad kwnaasy tumi go, aan lëë xaa bitiits nii chëb xaa xñabey go. Por ngo, axte natiemp xniladzy meñ Israel nii bitiits soldad. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lëë ksa tsiiptub xpëëdscuel Jesús kwey tu kiy nii sob Galilea, por siko chëb Jesús nii kwës Jesús xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aan tsiñee lëë xaa kon Jesús, lëë xaa psoxib, per no xaa pkan kik. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lëë Jesús chëb lo xaa: —Lëë Dios pso naa parñee kñabeyaa kpaa ni kñabeyaa lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kol tsi tyub lo kislyu aan kol kluuy xtitsaa lo meñ. Ni kol kchoobnis meñ nii kniladzy xtitsaa con xtiitspey Tat Tios, ni xtiitspey xiñ xaa, ni xtiitspey Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ni kol këb lo meñ kuuñtsyey meñ kchë nii bluyaa lo do. Pe tsinidy kik to, por tugak kaknin lëë do axte tse nii lëë kislyu nitylo.");
INSERT INTO ztqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sinrii nak nii bislo xkaasy xtiits Dios nii xñee cho nak Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lëë profet Isaías pkëë leñ xkitsy Dios sinrii: Lëgaanoo lëën kxal gaa tu xaa nii tenech lool parñee kwii xaa tu nëz tedyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Son meñ tsiy xaa tsiñee lëë xaa kñee tu tañ pidzy këb xaa: “Kol kxixkwaa nëz nii tedy meñ nii xñabey. Kol kwii tu nëz tubli.” ");
INSERT INTO ztqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Singo mod biid Juan xchoobnis xaa meñ tañ ni xñee xaa lo meñ: —Kol ktikche styoo do lo Dios ni kol chobnis, parñee ktsily Dios kchë xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsigo lëë meñ nii ncheno tyub tañ nii lë Judea ni meñ kyedzy Jerusalén kwey laañee so Juan. Aan tsiñee lox xobtol meñ kchësy xtol lo Dios lëë Juan xchoobnis meñ chu kiigwpee Jordán. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kits lady camey kwyaa xab Juan, lëë xcinturón xaa kwyaa con kidy. Nkwxandx ni tsiñ tañ taw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Lo xiwseedy xaa xñee xaa lo meñ: —Skere sëëd tu xaa nii mastre non lon, por naa ni parñee sinchuñaa kxakaa tuu kidy lab xaa xkiiñdyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naa pchoobnis lëë do con nis. Per lëë xaa kchoobnis lëë do con Kyalbini Ntson cheñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Leñ tse go lëë Jesús pchoo Nazaret, tu kyedzy nii nche nëz tañ nii lë Galilea, lëë xaa si chu kiigwpee Jordán aan siko lëë Juan pchoobnis xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aan siikñee lëë Jesús pchoo lo nis, lëë xaa kon nii lëë kpaa byaly aan lëë Kyalbini Ntson cheñ Dios sëëd sëëb byab lady xaa sinak tu palom. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni lëë xaa biñ tsiy Dios nii sëëd sëëb kpaa xñee lo xaa: —Lii nak xiñaa nii xkëstyoon. Xlen lool. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Loxsye ngo lëë Kyalbini Ntson kuni Jesús tañ pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Choow kpidz kwyo xaa tañ. Beeñ xaatox xaa preb ni kwyo xaa lady kchëlo ma tox, per lëë xangly Dios kokni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Loxsye kwloo meñ Juan skiib, lëë Jesús si nëz xtañ meñ Galilea xluuy xtiits Dios nii xteelaa ");
INSERT INTO ztqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","xñee xaa: —Lëë wor kutsiñ nii lëë Dios kñabey. Kol ktikche styoo do ni kol kniladzy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tu tse lëë Jesús sitedy chu nistoo Galilea tsiñee lëë xaa kon chop ngoosy mël nii nche kchon xkyex lo nis. Chop betsy nak xaa. Tu xaa lë Simoñ, lëë stu xaa lë Ndresy. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aan lëë Jesús chëb: —Kol tënal naa parñee jkoostre to mël, sink lëën kluy lo do xa kluuy do xtitsaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wor go kazh nche gak xkyex xaa, lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sijtyak kwsë Jesús lëë xaa kon Jacob ni Juan. Xiñ Zebedeo nak xaa chop xaa. Lëë xaa ncheno tu leñ barkw xkëtë xaa xkyex xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsigo lëë Jesús kwtsyetsy xaa, aan lëë xaa psaan pxosy xaa Zebedeo leñ barkw ksa xmos xaa aan lëë xaa sinal. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lëë Jesús ptsiñ kyedzy Capernaum ksa xpëëdscuel. Aan tsiñee lëë tse nii xiladzy meñ Israel lo tsiiñ kol, lëë Jesús kwsëëb ktoo aan lëë xaa bislo beeñ kseedy xaa meñ xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tsigo ndaly meñ psee biñ xiwseedy xaa porñee lëdy wi xaa chuuñ kseedy sinak kchë maestre ley, sink tsi lëë xaa xñee sootee tu xaa nii per nli busy xñabey nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lady kchësy meñ nii ncheno leñ ktoo no tu mguiy nii no tu kyalbini mal leñ styoo aan lëë xaa bislo chuptsyë xaa xñee xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Penak sëëd sëëboo lady noo Jesús Nazaret? ¿Buty sëëd knitylool lëë noo lë? Xyuumbeyaa lii. Lii nak Xiñ Ntson Dios nii sëëd lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsigo lëë Jesús kwëntseeb lo kyalbini mal go chëb xaa: —¡Psuugw chuwoo aan psaan mguiy gue! ");
INSERT INTO ztqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsigo lëë kyalbini mal go beeñ nii lëë mguiy go kutyë aan lëëw pchoo chuptsyë taño. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tsiñee lëë meñ kon kchësy ngo, ntseeb ptsyeb meñ, aan xñabtiits lsa meñ lo xcombañer xñee meñ: —¿Pe cos re? ¿Xa nak xiwseedy xaa re nii axte wi kyalbini mal xsoob xtiits xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aan blyëëdyak masyke lë Jesús xseety kchësy meñ nii ncheno tyub nëz Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsiñee lëë xaa pchoo ktoo, lëë Jesús kwey lidzy Simoñ ni Ndresy ksa xaa Jacob ni Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aan tsiñee lëë xaa ptsiñ, lëë xñaatsaap Simoñ nix xlyañ xlyëë, aan lëëw chëb xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tsigo lëë Jesús big kwseñ ña me blische xaa me. Aan wor go kazh lëë xlyëë pchoo, aan lëë me bislo beeñlo me nii taw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tsiñee lëë tse ptsye, lëë ngbidz kwyaasyle, lëë lyu no jketsyle, lëë meñ kuni kchëlo meñ xsyaknë ni meñ nii no kyalbini mal styoo lo Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","aan casy kchësy meñ kyedzy ptyop chu puert. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kchëlo kyalkits beeñ kyak Jesús meñ ni kwlii xaa kchësy kyalbini mal. Per blaady xaa nyeew porñee nano cho nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wor silytoo bii nguey lëë Jesús kuxche aan lëë xaa pchoo tublad chu kyedzy tu laañee tusy xaa par kutiitsni xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aan lëë Simoñ ksa xcombañer kukyub Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tsiñee lëë xaa ptsil xaa chëb xaa lo xaa: —Kchësy meñ këkyub lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Per lëë Jesús kwëb chëb: —Tsoo kchësy kyedzy nii nche kex nu parñee wi siko kluyaa xtiits Dios porque par ngo pchon. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Singo kunsë Jesús tyub xtañ meñ Galilea xluuy xaa xtiits Dios kchë leñ ktoo nii kwtedy xaa ni xkwii xaa kchësy kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lëë tu xaa nii xyodz lady big lo Jesús aan lëë xaa go psoxib chëb: —¿Pe nëëdyoo beeñ kyak naa? ");
INSERT INTO ztqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsigo lëë Jesús pkëstyoo xaa xsyaknë go, aan lëë xaa pxob ña xaa kik xaa xñee xaa: —Chakladzyaa nii kyaan nyëël lo xkyalkiitsoo. Nina kazh byaktsey. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aan nli gaa wor go kazh lëë xaa nii xyodz lady ko byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tsigo lëë Jesús kwëntseeb lo xaa nii byak ko aan lëë xaa psonëz xaa chëb xaa lo xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Byey aan ni tu cho lo këëbtyoo dyon xa byakoo. Kwey lo pxosy aan psakon nii xñabey xley Moisés, parñee kaknan meñ nii lëël byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per siñee lëë xaa go pchoo lëë xaa go bislo bitiits dyon xa byak xaa. Por ngo pchilodre nsyëëb Jesús ni stu kyedzy nii neñlo, sink lëë xaa kunsë laañee kindy meñ. Per nikxe singow ndaly meñ kwey lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsiñee kwloxo bla tse lëë Jesús bikche ptsiñ kyedzy nii lë Capernaum stub. Aan lëë meñ biñ nii lëë xaa nyoogw yu. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lëë meñ ptyopbe, per ni chu puert yu xkaadre kwe meñ. Aan lëë xaa bislo xluuy xaa xtiits Dios ");
INSERT INTO ztqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tsi lëë tap xaa ptsiñni tu xaa nii nëtoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Per konsye ksa tap xaa go nii chilody ktsiñ xaa axte laañee sopee Jesús porñee singootyee ndaly meñ nche, lëë xaa pxaly kik yu nii no Jesús, aan nëz laa nyaly go ptee xaa xaa xsyaknë go pxobsye xaa xaa lo tu ta. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tsiñee lëë Jesús kon nii nli xniladzy ksa xaa go, lëë xaa chëb lo xaa xsyaknë go: —Xiñ, nodre xtoloo. Kchësyo bily. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per lëë bla maestre ley nii nche sob siko psya styoo nladzy xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Penak xñee xaa gue singue? No ko xaa falt lo Dios por ni tu cho chilody ktsily tol, xaktyee Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per sinusy byeñ Jesús kchësy nii no ksya styoo xaa. Tsigo lëë xaa chëb: —¿Penak xsya tol do? ");
INSERT INTO ztqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Schilo këpaa lo meñ xsyaknë: “Lëë kchësy xtoloo bily”, ni schilo këpaa: “Kuxche, blis xtal aan byey”, per ¿chow dyon mastre ngan? ");
INSERT INTO ztqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Per na gaanoo lëën kluy lo do nii wi mguiy nii pxaal Dios schilo ktsily tol lo kislyu. Tsigo lëë xaa chëb lo xaa xsyaknë go: ");
INSERT INTO ztqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Lool xñen, kuxche, blis xtal aan byey liidzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsigo lëë xaa xsyaknë go kuxche wor go kazh, aan lëë xaa blis xta xaa. Tsigo lëë xaa pchoo kwtedy xaa kchësy lady meñ. Por ngo, kchësy meñ psee aan kchësy meñ biily lay lo Dios xñee: —Loñee mbañ no karty tyon no kchësy nrii. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Loxsye ngo lëë xaa kwey chu nistoo stub, aan tsiñee lëë meñ lox ptyopbe lo xaa, lëë xaa bislo beeñ kseedy xaa meñ xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lëë tsi lëë Jesús bikche sey leñ kyedzy stub, lëë xaa kon tu xaa nii pcholë Leví. Alfeo nak pxosy xaa. Lëë xaa sob laañee chitizh meñ par kchilo kto meñ xcheñ aan lëë Jesús chëb lo xaa: —Tënal naa. Tsigo lëë Leví kuso aan lëë xaa sinal. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aan lëëtyee lëë Jesús noyaw lidzy Leví. Ndaly xaa nii chuuñ jkizh meñ ni ndaly meñ ngoptol kunal. Lëë xaa kwsob lo mezh ksa xaa Jesús ni ksa xaa xpëëdscuel Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Per tsiñee lëë xaa fariseo ni maestre ley kon nii lëë Jesús kayawni kchësy meñ go, lëë xaa chëb lo xpëëdscuel Jesús: —¿Xa mod nak nii chaw xmaestre to ksa xaa nii chuuñ jkizh ni kchësy meñ ngoptol gue? ");
INSERT INTO ztqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsiñee lëë Jesús biñ kchësy nii kwnee xaa go, lëë xaa chëb: —Xkiiñdy meñ buen ni meñ ndaan xaa nii chuñ rmedy, sink meñ xsyaknë xkiiñ xaa nii chuñ rmedy. Per syely kyubtyaa meñ buen, sink lëën syely kyub meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tu tse tawdy xpëëdscuel Juan ni xaa fariseo parñee kuuñ ksak xaa Dios. Tsigo lëë bla meñ kunabtiits lo Jesús chëb: —¿Penak nii chawdy xaa nii no xlad Juan ni xaa nii no xlad xaa fariseo parñee kuuñ ksak Dios, per lëë xpëëdscueeloo pe xseedy xaa masyke lëë xaa ncheno wagw? ");
INSERT INTO ztqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tsigo lëë Jesús kwëb chëb: —¿Pe mod lika nayak ksaan meñ nii chi lo tu kyalwtsiilña wagw par tso kyalnë meñ? Deelñee bii so xaa nii ptsiilña gon, ni tu cho chilody tso kyalnë. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per sitsiñ tse nii lëë xaa nii ptsiilña kyas. Tsigosy nagon schilo ksaan meñ wagw par tso kyalnë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ni tu cho xkëtëdy tu ladx yoox con tublë ladx kub. Por tsi lëëw tsadx, lëë ladx kub kpe aan lëëw kchos ladx yoox, aan lëë laa nchos ko kak nroobre. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni nody nii ktyëë nip kub leñ kyeg kidy nii kwyoxle. Porque schilo kchos nip kub kyeg kidy, aan ntseeb xiñ nip, nikxe gaa kyeg kidyo. Por ngo no nii ktyëë nip kub leñ kyeg kub. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lëë tu tse nii xiladzy meñ Israel lo tsiiñ lëë Jesús sitedy tu lo kwaa nii no nonsyke xobxtily, aan lëë xpëëdscuel xaa bislo xchoow xobxtily. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsigo lëë xaa fariseo chëb lo Jesús: —Buy gaanoo, ¿penak nii chuñ xpëëdscueeloo nii nonguialdy kak tse nii xiladzy meñ lo tsiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Per lëë Jesús chëb: —¿Pe karty nayak klab to laañee xñee xa beeñtsyey rey David worñee kwlaañ xaa ksa xcombañer xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iz nii lëë Abiatar nak pxosy nii mastre non, lëë David kwsëëb leñ lidzy Dios aan lëë xaa taw kyaxtily nii nak lay nii xaktyee pxosy chaw, aan wi kchë meñ nii ksa xaa si byaan xaa kyaxtily go. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Chëbak Jesús lo kchësy meñ go: —Lëë tse nii chak wxiladzy byaan par meñ, per byaandy meñ par tse go. ");
INSERT INTO ztqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Por ngo, axte lo tse nii xiladzy meñ lo tsiiñ xñabey mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lëë Jesús kwsëëb ktoo stub. Aan lëëtyee lëë tu xaa nii mbañdy tu ña no leñ ktoo go. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ni lëë meñ nche kuy dyon pe syuuñ kyak Jesús xaa xsyaknë go tse nii xiladzy meñ lo tsiiñ parñee tso pe cos jkëëkiy meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsigo lëë Jesús chëb lo xaa nii mbañdy ña: —Kuso aan kwso groltyee nu. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tsigo lëë xaa kwnabtiits lo meñ chëb xaa: —¿Pe cos nonguial kak tse nii xiladzy meñ lo tsiiñ? ¿Pe nonguial kantsi ñe ote ksaksi ñe saa bñech ñe yak? Per ni tu cho kwëbty. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tsigo lëë Jesús buy lo kchësy meñ nii nche siko aan lika blëë xaa, ni pteenë xaa porñee kon xaa nii singootyee nguiedzy styoo kchësy meñ go. Loxsye ngo lëë xaa chëb lo xaa xsyaknë go: —Biskaa ñal. Aan lëëw biskaa xaa. Lëë gaaw byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Per siñee lëë xaa fariseo pchoo siko lëë xaa bitiits ksa xaa meñ nii nak ksa rey Herodes dyon xa kuty xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lëë Jesús si chu nistoo ksa xpëëdscuel aan ndaly meñ Galilea kunal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tsiñee lëë meñ nii no nëz Judea ni meñ nii no kyedzy Jerusalén ni meñ nii no nëz Idumea ni meñ nii ncheno stublad chu kiigwpee Jordán ni meñ nii no tyub kyedzy Tiro ni meñ nii no tyub kyedzy Sidón koknan kchësy nii chuuñtsyey Jesús, ndaly kchë meñ go kukuy. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Por ngo lëë xaa chëb lo xpëëdscuel xaa nii nyub xaa tu barkw parñee ndaagwty meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Porñee beeñ kyak xaa ndaly meñ xsyaknë, aan kchësy meñ chas xkyë lady xaa par señ meñ xab xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aan tsiñee lëë kyalbini mal chan Jesús, xsoxibo chuptsyëw xñeew: —¡Lii nak Xiñ Dios! ");
INSERT INTO ztqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per lëë Jesús kwnabey nii nyeedyo cho nak xaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Loxsye ngo lëë Jesús si tu kiy. Siko lëë xaa kwtsyetsy meñ nii kwlaañtyee styoo xaa aan lëë meñ go big lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aan lady kchësy meñ go kwle xaa tsiipchop xaa go tsikluuy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ni lëë xaa ptee kyalxñabey lo xaa par kwii xaa kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lëë ksa lë xaa nii kwle xaa nrii: Simoñ, xaa nii kwloolë xaa Pedre, ");
INSERT INTO ztqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacob ni betsy wiñ xaa Juan. Xiñ Zebedeo nak xaa chop xaa. Boanerges kwloolë Jesús xaa. (Tiits ko nak sinak nii xñee ñe Xiñ Nkwsiy.) ");
INSERT INTO ztqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ni kwle xaa Ndresy ni Felip ni Bartolomé ni Mateo ni Max ni Jacob xiñ Alfeo, ni Tadeo ni Simoñ, xaa nii kwyo lady tub tiiy meñ nii pcholë Cananista, ");
INSERT INTO ztqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Judas Iscariote, xaa nii byub mod pkaa Jesús lo xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Loxsye ngo lëë Jesús byo leñ yu nii xkwës xaa ksa xpëëdscuel xaa aan lëë meñ ptyopbe stub. Por ngo nii byobty nyaw xaa ksa xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tsiñee lëë meñ lidzy Jesús biñ nii lëë Jesús so siko, lëë me kwey par kyoy me xaa, porñee ndaly meñ xñee nii lëë Jesús chak wety. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wi maestre ley nii nak xaa Jerusalén ptsiñ xñee: —Beelzebú, xaa nii xñabey lo kyalbini mal, nakni xaa ni xtee tiitspey lo xaa par kwii xaa kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsigo lëë Jesús kwtsyetsy kchësy meñ go aan lëë xaa pso tu cuent par kuuñ kseedy xaa chëb xaa: —¿Xa kchilo xaatox kwii saa xaatox? ");
INSERT INTO ztqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tu kyedzy nii nak chop tiiy chilody ktiiyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ni tu meñ wlidzy nii nak chop tiiy chilody ktiiy me. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Singo gak nak xaatox deel kak xaa chop tiiy ni ktily lsa xaa. Chilody ktiiy xaa, sink sikootyee lëë xcuent xaa kyal. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ni tu cho chilody sëëb leñ lidzy tu meñ nii ntseeb par koy xaa xcheñ xaa, sink klo no nii kxituu kazh xaa xaa. Xakxe singo schilo koy xaa nii klyaañtyee styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Lëën xñeli kazh lo do nii stsily Dios kchë xtol meñ ni kchë cos yox nii kñee meñ lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per lëë meñ nii kñeenë Kyalbini Ntson cheñ Dios kpildy xtol meñ go. Tugak tso xtol meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kchësy nrii kwnee Jesús porñee kwnee meñ nii kyalbini mal nakni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsiñee lëë xñaa Jesús ni betsy xaa ptsiñ, lëë xaa kwche ley aan lëë xaa pxaal mandad sitsyetsy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsigo lëë meñ nii nche sob kyako kwi Jesús chëb: —Lëë xñaal ni betsyoo nche ley xyub lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Per lëë xaa kwëb chëb xaa: —¿Cho nak kaa tnan ni betsyaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loxsye ngo lëë xaa buy lo kchësy meñ nii nche sob kyako kwi xaa aan lëë xaa chëb: —Meñ re nak tnan ni betsyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque kchësy meñ nii chuuñtsyey nii chakladzy Dios, meñ go nak betsyaa, psyañaa ni tnan. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Lëë Jesús bislo bluuy xtiits Dios chu nistoo stub. Aan como lëë meñ ptyopbe, lëë Jesús kwyo tu leñ barkw nii so siko aan lëë xaa kwsob leeñgo. Lëë meñ kwche chu nis. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsigo lëë xaa bislo beeñ kseedy xaa meñ nonsyke con cuent. Aan lo xiwseedy xaa xñee xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kol kon tu xcuent ngon nii pchoo kwey kon. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aan tsiñee lëë xaa bislo lo wlaal xob, grol xoob xaa byab kexka chu nëz aan kuktop kaa mguiño. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Lëë stub lugar lëë xob byab lady kyo laañee nchedy ndaly yu. Blyëëdy pchukë xob ko lyu porñee nxijty kwyow. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per tsiñee lëë ngbidz kwlañ, lëë ngbidz psaayo, aan como kindy luw lëëw pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lëë stub lugar lëë xob byab lady yakitsy aan lëë yakitsy kwroob aan lëëw kwtiño koktyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per lëë stub lugar lëë xob byab laañee neely lyu aan lëëw kwroob. No ladyo kwsob tsongalyo ni tu kyoowo. Buen koko. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aan loxsye ngo lëë Jesús chëb: —Kchësy to siñee chakladzy to kyeñ do, kol jkëëtyag. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tsiñee lëë Jesús byaan nonsy, lëë kchësy meñ nii nak ksa xaa ni ksa tsiipchop xpëëdscuel xaa kwnabtiits chëb: —¿Xa nak cuent nii lox psool? ");
INSERT INTO ztqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tsigo lëë xaa kwëb chëb xaa: —Kchë lo meñ tiemp gon kwyolan xa nak xkyalwnabey Dios. Lëë na lëëw xluuy xaa lo do. Per lëë meñ nii nche tublad nonsyke con cuent no nii kseedy meñ go ");
INSERT INTO ztqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","parñee nikxe xaapee kuy meñ go, per kandy me, ni nikxe mastre kon meñ go, per kyeñdy me, ni parñee kpikchedy styoo meñ go lo Dios tsiin ktsily Dios xtol meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lëë Jesús chëb: —¿Xyeñdy to cuent re lë? ¿Xa kyeñ do nii sëëdre tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lëë meñ nii chan xob nak sinak meñ nii xluuy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","No meñ nii nak sinak xob nii byab lo nëz, nii chon xtiits Dios, aan xlyëëdyak lëë xaatox chiklaats nii bñaa leñ styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","No gaa meñ nii nak sinak xob nii blyaal lady kyo, nii xle chon xtiits Dios, ");
INSERT INTO ztqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per como kindy luw xsyob lidyo. Singo nak meñ go tsiñee chan meñ go nii lëë kyalnë sëëd por xtiits Dios. Xchoso gaa styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","No gaa stubla meñ nii nak sinak xob nii blyaal lady yakitsy, nii chon xtiits Dios, ");
INSERT INTO ztqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per mastre sini kchë cos lo kislyu re kik meñ go. Choki meñ go kap kchëlo cos, per xaktyee xkëëtiw. Kchë ngo xsyëëb leñ styoo meñ go aan xkiño xtiits Dios, ni xkaw jkiiñ meñ go lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per no gaa meñ nii chon xtiits Dios aan xniladzyo. Aan chak meñ go sinak kok xob nii blyaal laañee neely lyu. No meñ go nak sinak xob nii kwsob kalyptsii xob lady, ni tsongaly xob, ni tu kyoow xob. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ni chëbak xaa: —¿Pe mod xyooy tu bini nayak parñee tsow leñ tu cajón o leñ lon gaa? Lëdyo gon. Klaa xsyob tu bini parñee ksaaniw. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Por nody ni tu cos nii chak tsilaan nii kchukëdy, ni nody ni tu cos ngueetsy nii kak ndoondy. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kchësy to siñee chakladzy to kyeñ do, kol jkëëtyag. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ni chëbak xaa: —Kol ksal nii xkëëtyag to, porque sinak nii xsee gak to chan do xcombañer do, singo gak ksee Dios kan xaa lëë do, ni stsiibre xaa stublaw loo go. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Por meñ nii chap palalo, lëë Dios kteerew. Per lëë meñ nii pe chapty, lëë Dios kla axte nii wiñ nii chapsye meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ni chëbak Jesús: —Nak laañee xñabey Dios sinak tu xaa nii xlaal xob. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Loxsye ngo lëë xaa xyey kuutkesy aan tsi lëë lyu xyaani lëë xaa chische, xtye kyool ni xtye tse, per nandy xaa dyon xa kwlañ xoob xaa ni xa kwroobo. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Aan xaly lyu xroobo xob. Klo xlyañ xikwo. Loxsye ngo lëëw xchukë to aan xlyëëdyak lëëw xsyo xob. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aan tsiñee lëëw lox chal, lëë xaa chiktopo, porñee lëë xtiemp kwlaap kol. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ni chëb Jesús: —¿Pe cos nak sinak laañee xñabey Dios dyon, ni pe cos chak si chako? ");
INSERT INTO ztqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nako sinak tu medzy martas nii xñaa lo kislyu. Lëë medzy ko nak tu medzy nii mastre wiich lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per tsiñee lëëw lox xñaa, xroobo aan mastre chak ngolo lo kchësy kizh. Chak nxii xikwo ni axte mguiñ schilo ko xipchoos lo xingalo. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nonsyke con cuent beeñ kseedy Jesús meñ, axte laañee byeñ xaa nii schilo kyeñ meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Per ni tu pe bluuydy xaa singosy, sink nonsyke con cuent, nikxe tseyladzy xñee xaa xa nak cuent ko lo xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsiñee lëë lyu pkyey misme tse go, lëë Jesús chëb lo xpëëdscuel: —Kol tsoo stublad chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsigo lëë xpëëdscuel Jesús psaan meñ, aan lëë xaa sini Jesús leñ tu barkw nii nol Jesús. Aan wi stubla barkw si ksa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Per lëë tu me dox bislo xpi xchëëp barkw, aan lëë nis bislo chisoli xchoon leñ barkw. Singo lëë barkw no kyatsë nis. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aan lëë Jesús nixyesy xan barkw ngookwsye xaa tublë yag. Lëë xpëëdscuel xaa beeñ kna xaa chëb xaa lo xaa: —¡Maestre! ¿Pe xyeñdyoo nii lëë no kety lo nis re? ");
INSERT INTO ztqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsigo lëë Jesús kuxche aan lëë xaa kwëntseeb lo me ni lëë xaa chëb lo nistoo: —¡Kwlës! ¡Tsesy! Lëë me kwlës aan tsesy byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Loxsye ngo lëë Jesús chëb lo xpëëdscuel: —¿Penak xtsyeb to? ¿Pe karty kap to Dios confians? ");
INSERT INTO ztqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Per loñee singootyee bii xtsyeb xpëëdscuel Jesús, lëë xaa xñabtiits lsa xaa lo xcombañer xaa xñee xaa: —¿Cho nak xaa re nii axte me ni nistoo xsoob xtiits xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lëë xaa ptsiñ stublad chu nistoo laañee nak xtañ meñ Gerasa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aan siikñee lëë Jesús byedy leñ barkw, lëë tu xaa nii no tu kyalbini mal leñ styoo big lo xaa. Leñ paa pchoo xaa go ");
INSERT INTO ztqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","porñee leeñgo no xaa. Ni tu cho chilody kxituu xaa nikxe con caden. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ndaly vuelt pxituu meñ niy xaa ni ña xaa con caden, per pchug xaaw. Ni tu cho chuñdy gan lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Xkyënsë xaa kyool yutsye tyub kiy ni leñ paa chuptsyë xaa ni chiswee xaa xaa con kyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Per tsiñee lëë xaa kon Jesús, sitre bii sëëd Jesús, lëë xaa kwloo corr aan lëë xaa psoxib lo Jesús ");
INSERT INTO ztqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","aan chuptsyë xaa xñee xaa: —¿Penak xkaaloo naa, Jesús Xiñ Dios nii sob kpaa? Ni nlipee gaa nawo xñabaa lool nii ksaksidyoo naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Singo xñee xaa porñee lëë Jesús chëble: —¡Kyalbini mal, psaan mguiy gue! ");
INSERT INTO ztqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsigo lëë Jesús kwnabtiits lo xaa chëb: —¿Cho lël busy? Lëë xaa kwëb chëb xaa: —Ndaly lën porñee ndaly nak noo. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aan mban xñee kyalbini mal go lo Jesús nii kwiidy Jesúso tañ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aan como kex xan kiy go ncheyaw tubtsoon ngutsy, ");
INSERT INTO ztqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","lëë kyalbini mal go kwnab lo Jesús chëb: —Pxaal noo lo ngutsy nii nche ske ni blaa syëëb noo leñ ma. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Lëë Jesús ptee tiitspey, aan lëë kyalbini mal go pchoo leñ styoo mguiy go aan lëëw kwsëëb leñ kchë ngutsy ko. Xkaa ngutsy ko siik chop mily. Kchësy ma kwloo corr kwsëëb ma lo nistoo aan lëë ma kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tsigo lëë meñ nii nche nap ngutsy ko pchoo wxooñ kukni tiits kyedzy dyon xa kok tañ. Aan lëë meñ kukuy dyon pe cos kok. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aan tsiñee lëë meñ ptsiñ laañee so Jesús, lëë meñ kon xaa nii kwyo kyalbini mal styoo. Lëë xaa sob, nakw xab xaa ni mbëë nyaani chak xaa. Lëë meñ ptsyeb, ");
INSERT INTO ztqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ni lëë meñ nii kon xa kok xaa nii kwyo kyalbini mal go leñ styoo ni xa kok ngutsy, bitiitso lo kchësy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsigo lëë meñ bislo kwnab nii kpi Jesús xtañ meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tsiñee lëë Jesús ptsiñ laañee so barkw, lëë xaa nii kwyo kyalbini mal styoo go kokladzy nyinal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per kwnëdy Jesús, sink lëë xaa chëb lo xaa: —Byey, kujkan meñ liidzyoo, aan bitiits xa beeñ kyak Dioosoo, ni xa pkëstyoo xaa lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lëë mguiy go sey, aan lëë xaa bislo bitiits xaa tyub nëz Decápolis xa beeñ kyak Jesús xaa. Aan kchësy meñ psee. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsiñee lëë Jesús ptsiñ stublad chu nistoo con barkw, lëë meñ ptyopbe aan lëë xaa kwso chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lëëtyee lëë xaa so siko tsiñee lëë tu xaa nii xñabey leñ ktoo nii lë Jairo ptsiñ. Tsi lëë xaa kon Jesús, lëë xaa psoxib ");
INSERT INTO ztqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aan mban kwnee xaa lo Jesús chëb xaa: —Lëë xiñaa noyety. Të kxoboo ñal lady me tsiin kyaktsey me ni kpañ me. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Lëë Jesús sinal xaa ni ndaly meñ kunal, aan lika xtaagw meñ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lady kchësy bñechtoo go no tu kwnaa nii kokle tsiipchop iz xsyaknë me, xchoo me cheñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mban kwtedy me. Ndaly lo meñ nii chuñ rmedy kwey me. Xaktyee kukxiñ me kchë xtumi me aan kokty me rmedy. Lëël mastre kok xkyalkits me. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tsiñee lëë me biñ nii lëë meñ xseety Jesús, lëë me big nëz xitsy Jesús lady meñ aan lëë me kwseñ xab xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Porñee nladzy me: “Comñee jkaa seeñaa xab Jesús lëën kyak.” ");
INSERT INTO ztqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aan wor go kazh lëë xcheñ me byag. Aan axte mbëë byaan lady me byeñ me nii lëë me byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lëë Jesús byeñ nii lëë xaa beeñ tu kyalntson, aan lëë xaa byoogw xuy xaa lo meñ xñee xaa: —¿Cho kwseñ xabaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tsigo lëë xpëëdscuel xaa chëb: —Chanoo name nii lëë meñ xtaagwoo aan xñabtiitsoo, xñeel: “¿Cho kwseñ xabaa?” ");
INSERT INTO ztqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per lëë Jesús bii buy tyuxlad kwi parñee kan xaa dyon cho kwseñ xab xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsigo lëë kwnaa go xisy me ni xtsyeb me porñee nan me lëë me kwseñ xab Jesús. Lëë me kuksoxib lo xaa aan lëë me bitiits penak nii beeñ me singo. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tsigo lëë Jesús chëb: —Xiñ, porñee bniladzyoo naa ngo nii lëël byak. Byey. Pe tsinidre kikoo. Lëël byakle. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lëë Jesús bii nonee tsiñee lëë bla meñ nii pchoo lidzy xaa nii xñabey ktoo ptsiñ chëb lo pxosy mëëd kwnaa go: —Lëë xiñoo tse lox kuty. ¿Penak nii xko tsiiñoo lo maestre? ");
INSERT INTO ztqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per lëë Jesús koñee psaldy xaa meñ go lëë xaa chëb lo xaa nii xñabey ktoo: —Ktsyeebtyoo. Bniladzy sye naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aan blaady xaa nyinal meñ. Xaktyee Pedre, Jacob ni Juan, betsy Jacob kunal. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsiñee lëë xaa ptsiñ lidzy xaa nii xñabey ktoo, lëë xaa kon xa nche kxoly meñ ni xa ncheyoon meñ ni nche kteenë gaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lëë xaa kwyo yu aan lëë xaa chëb: —¿Penak singueetyee noyak nxoly do ni choon do singueetyee? Kujty mëëd kwnaa gue, sink lëë me nixyesy. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pxidzyni meñ Jesús, per lëë xaa kwlii kchësy meñ yu. Aan lëë xaa byaan ksa xaa pxosy me ni xñaa me ni xaa nii ksa xaa si. Aan lëë xaa kwsëëb laañee nix mëëd kwnaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Lëë xaa kwseñ ña me aan lëë xaa chëb: —Talita, cum. (Tiits ko nak sinak nii xñee ñe: Mëëd wiñ, lool xñen, kuxche.) ");
INSERT INTO ztqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wor go kazh lëë mëëd kwnaa nii chap tsiipchop iz kuxche aan lëë me bislo kwsë me. Aan kchësy meñ nii nche siko psee. ");
INSERT INTO ztqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Per lëë Jesús chëb kazh nii ni tu cho lo nyëbty meñ gow. Loxsye ngo lëë xaa chëb: —Kol ktee nii kaw me. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lëë Jesús bi siko aan lëë xaa kwey mer xkyedzy xaa ksa xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tsi lëë tse nii xiladzy meñ lo tsiiñ kol, lëë Jesús bislo beeñ kseedy xaa meñ leñ ktoo. Tsiñee lëë kchësy meñ biñ xiwseedy Jesús, ntseeb psee meñ. Aan xñabtiits lsa meñ lo xcombañer xñee meñ: —¿Pa pseedy xaa kchësy cos re? ¿Pa xkwii xaa kchë wseedy ke ni kchë kyalntson nii chuñ xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Pe lëdy lëë carpinter ngue nayak? ¿Ni pe lëdy xiñ Mariy nayak nak xaa ni betsy xaa nak Jacob, José, Judas ni Simoñ? ¿Ni pe lëdy nayak wi kchë psyañ xaa ncheno lady no nu? Por ngo koklasty meñ nsal meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Per lëë Jesús chëb: —Laañee xkaatyee xsal meñ tu profet, per xsaldy meñ tu profet nii nak xaa xkyedzy meñ ni meñ lidzy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ni tu kyalntson pchilody nyuuñtsyey xaa siko, xaktyee bla lady meñ xsyaknë pxob xaa ña xaa ni beeñ kyak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aan ntseeb psee xaa porñee bnilasty meñ xaa. Kunsë Jesús kchë kyedzy nii nche kex siko xluuy xaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsigo lëë xaa kwtsyetsy ksa tsiipchop xpëëdscuel xaa aan lëë xaa pxaal xaa chop kaa chop kaa xaa loxsye ptee xaa tiitspey lo xaa par kwii xaa kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni chëb kazh xaa nii ni tu pe koydy xaa par nëz, xaktyee tublë yag nii ksoxka xaa. Ni chëb xaa nii nody koy xaa bols ni kyaxtily ni tumi. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ptee xaa tiitspey kwë lab xaa, per pteejty xaa tiits nii nyoy xaa ladx parñee ntsyëë xab xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni chëb xaa: —Tsiñee ktsiñ do tu yu, kol kwës siko axte nii kpi do kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aan deelñee ktsiñ do tu laañee kneesty meñ laa kwës to ni kaklasty meñ kon xiwseedy to, kol kchoo siko aan kol kwib yu nii xña niy do parñee kyeñ meñ nii no xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsigo lëë xpëëdscuel xaa pchoo xñee lo meñ: Kol ktikche styoo do lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ni kwlii xaa ndaly kyalbini mal ni kwtëëb xaa meñ xsyaknë aceit aan lëë meñ xsyaknë byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lëë rey Herodes biñ kchë kyalntson nii chuuñtsyey Jesús, porñee nonsyke lë Jesús xseety meñ tyub tañ go. Aan xñee rey Herodes: —Lëë Juan, xaa nii pchoobnis meñ pañ. Por ngo nii chuñ xaa kchë kyalntson gue. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lëë stubla meñ xñee: —Lëë profet Elías ngue. Lëë stubla meñ xñee: —Tu profeto sinak kchësy profet nii biid tiemp. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Per tsiñee lëë rey Herodes biñ kchësy ngo, lëë xaa chëb: —Lëë Juan ngue. Naa kwnabey kwchug kik Juan aan na lëë xaa pañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porsye Herodías lëë rey Herodes kwnabey pkaa Juan ni lëë xaa kwnabey pxituu Juan con caden leñ skiib. Herodías kok tsiil Felip, betsy Herodes, per lëë Herodes ptsiilña me. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aan lëë Juan tugak xñee lo Herodes: —Nody nii tsonil tsiil betsyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tsigo lëë Herodías bislo blëëni Juan aan kokladzy me nyuty me Juan. Per pchilody me ");
INSERT INTO ztqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","porñee ptsyeb Herodes Juan, porñee koknan xaa nii tu meñ buen Juan ni tu xaa nii chuuñ ksak Dios nak Juan. Ngo nii kokni xaa Juan. Nikxe gaa nii tsiñee biñ xaa xtiits Juan byeñdy xaa pe nyuñ xaa, per tyub styoo xaa pkëëtyag xaa xtiits Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per lëëw ptee tiits lo Herodías tse nii lëë Herodes ptsiil iz. Lëë xaa beeñlo tu niskwaan par kchë xmeñ xñabey xaa ni par meñ nii xñabey lo xsoldad xaa ni par kchësy meñ non nii kwyo Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lëë xaa no wagw tsi lëë xiñtsyaap Herodías kwsëëb, aan lëë me bislo byëë me. Tirak ptsiladzy Herodes xiwyëë me ni wi kchë xaa nii ksa xaa ncheyaw ptsiladzyo. Loxsye ngo lëë Herodes chëb lo me: —Kwnab nii klyaañtyee styool lon aan na knetsyno. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aan lëë xaa pkon Dios chëb xaa: —Snetsyaa nii kñabtyoo, nikxe kñaboo grol tañ nii xñabeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lëë me pchoo aan lëë me kwnabtiits lo xñaa me chëb me: —¿Pe cos kñabaa? Aan lëë xñaa me kwëb chëb: —Kwnab kik Juan, xaa nii xchoobnis meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsigo lëënlëdy kwsëëb me laañee sob rey aan lëë me chëb: —Chakladzyaa nii nina kazh kneetsyoo kik Juan, xaa nii xchoobnis meñ. Kxoobo tu leñ plat. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tsigo mban kok rey. Per xaw lëë xaa pkonle Dios xña lo kchësy meñ, koklasty xaa nga xaa nii kwnab me. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Loxsye ngo lëë xaa pxaal tu soldad kuxi kik Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aan lëë soldad kwey leñ skiib, pchug kik Juan aan lëëw kuni xaa xoobo leñ tu plat. Lëëw ptee xaa lo xiñtsyaap Herodías aan lëë me pteedyo lo xñaa me. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsiñee lëë xaa nii nak ksa Juan koknano, lëë xaa kuklis xcuerp Juan aan lëëw pkeetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Loxsye ngo lëë ksa xaa nii pxaal Jesús ptsiñ aan lëë xaa bitiits kchësy nii beeñtsyey xaa ni bluuy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tsigo lëë Jesús chëb: —Kol të tsiin kyo no nonsy no kxiladzy no xisy tu laañee cho kindy. Porñee si siid meñ nii xyobty kaw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsigo lëë xaa kwyo barkw ksa xpëëdscuel xaa aan lëë xaa si tu laañee cho kindy. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per ndaly meñ kon si xaa aan lëë meñ byuumbey Jesús. Tsigo kchësy meñ nii no kchë kyedzy nii nche tañ go kwey siko, aan klo meñ ptsiñ lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tsiñee lëë Jesús byety leñ barkw, lëë xaa kon kchë bñechtoo nii nche, aan lëë xaa pkëstyoo kchësy meñ go porñee nche kchë meñ go sinak xkwe mëkwxiily nii kindy cho kyënap. Aan lëë xaa bislo bluuy xaa ndaly cos lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lëë tse ptsyel tsi lëë xpëëdscuel xaa big lo xaa chëb: —Lëë tse ptsye aan ni tu cho kindy nu. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Psonëz meñ parñee tsi meñ tañ ni kchë kyedzy nii nche kexka tsiin si meñ nii kaw. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Per lëë Jesús kwëb chëb: —Kol ktee nii kaw meñ wo. Tsigo lëë xaa chëb: —¿Pe chakladzyoo nii kyosyuuy noo chop kyoow denario kyaxtily par kaw meñ re? ");
INSERT INTO ztqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tsigo lëë Jesús chëb: —¿Blak kyaxtily noy do? Kol tsikuy dyon. Tsiñee lëë xaa bikche chëb xaa: —Kaay kyaxtily schop mël. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsigo lëë xaa kwnabey kwsob meñ tubtsoon gaa meñ lo kixkiy. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aan lëë meñ kwsob. Tubtsoon gaa meñ no laa kwsob tu kyoow meñ, no gaa laa kwsob choowptsii meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Loxsye ngo lëë Jesús kwseñ ksa kaay kyaxtily go ni chop mël go, aan lëë xaa blëp lo kpaa. Lëë xaa ptee skizh lo Dios. Tsigo lëë xaa beeñ grol kyaxtily go aan lëëw pteedy xaa lo xpëëdscuel xaa parñee kiisy xaaw lo meñ. Wi chop mël go kwtiisy xaa kchë lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kchësy meñ taw axte laañee byëly meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aan tsiñee lëë wagw kwlox, bii ptyop tsiipchop tskwidy kyaxtily nii byaan ni mël. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aan lëë meñ nii pchilosy pkab lady kchë meñ nii taw, pkab kaay mily xaapkiy. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Loxsye ngo lëë Jesús blëp xpëëdscuel barkw parñee tekë xaa nistoo klo xaa, ktsiñ xaa Betsaida mentre lëë Jesús bii no ksonëz meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aan tsiñee lëë xaa lox psonëz meñ, lëë xaa si tu kiy par kutiitsni xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsiñee lëë lyu lox pkyey lëë barkw tse si groltyee nistoo. Aan lëë Jesús bii so chu nis nonsy. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Lëë xaa kon nii në si barkw porñee singootyee xchëëp mew. Lëë wor silytoo lëë xaa sisë lo nis nëz laañee si barkw, aan kokladzy xaa ndyenech xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Per tsiñee lëë xpëëdscuel xaa kon nii lëë xaa xsyë lo nis, nladzy xaa tu pesyo. Aan kchësy xaa kwchuptsyë ");
INSERT INTO ztqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","porñee kchësy xaa kon Jesús aan ptsyeb xaa. Per lëë Jesús kwnee chëb xaa: —¡Kol kak ndaan; naaw, ktsyebty to! ");
INSERT INTO ztqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsigo lëë xaa byëp barkw aan lëë me kwlës. Ni lëë xpëëdscuel xaa psee ");
INSERT INTO ztqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porñee byeñdy xaa kyalntson nii beeñtsyey Jesús worñee kwtiisy Jesús kaay kyaxtily lo meñ, porñee bii nguiedzy styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lëë xaa kwtekë nistoo aan lëë xaa ptsiñ xtañ meñ Genesaret. Siko lëë xaa pxituu barkw chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Siikñee lëë xaa byety barkw, lëë meñ byuumbey Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aan pchoo wxooñ kchësy meñ kyedzy nii nche nëz tañ go ptsiñni meñ xsyaknë kë yag laañee biñ meñ so Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aan laañee xtsiiñtyee Jesús, nikxe kyedzy ngolo, kyedzy wiñ gaaw, o tañ gaaw, xkweek meñ meñ xsyaknë nëz aan xñab meñ nii klaa Jesús señ meñ xsyaknë xab xaa. Aan kchësy meñ xsyaknë nii pkaa kwseño byak. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lëë xaa fariseo big lo Jesús ksa xaa tubtsoon maestre ley nii sëëd Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsiñee lëë xaa kon nii lëë bla xpëëdscuel Jesús ncheyaw aan kwtiibty xaa ña xaa sinak chuuñtsyey xaa fariseo, lëë xaa kwneenë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Porñee lëë xaa fariseo ni kchë meñ Israel sinal kchë xmod pxusykoltoo nii kawdy xaa deelñee kiib nyë kazhty xaa ña xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ni tsiñee chi xaa wsi lo kiy, tsi lëë xaa xpikche, chawdy xaa deelñee tsadx kazhty ña xaa. Ni ndalyre gaa costumbre nii byaani xaa sinak nii tsadx vas, kandy ni ntsyëë kiib nii xkiiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Por ngo lëë xaa fariseo ni maestre ley kwnabtiits chëb: —¿Penak nii sinaldy xpëëdscueeloo xcostumbre pxusykoltoo no, sink koñee chaw xaa con ña peedy xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tsigo lëë Jesús kwëb chëb: —Nli gak xtiits Dios nii kwnee profet Isaías worñee pkëë xaa xa nak to. Chëb xaa: Tsiñee xñeesy meñ, sootee nii nli xsal meñ naa, per sinidy kik meñ ksoob xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pe nandy chool meñ lay lon, por xluuy meñ xiwseedy meñ sinak nii nyako xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ni lëë do xsaan nii xñabey Dios par tsinal do xcostumbre saa bñech to. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Chëbak xaa: —¿Penak nii xsaan do nii xñabey Dios tublad par tsinal do xcostumbre to? ");
INSERT INTO ztqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lëë pxusykoltoo no Moisés gon chëb: “Psal pxoosyoo ni xñaal”, aan “Meñ nii ktsiibtee pxosy o xñaa gaa iipñee sety meñ go.” ");
INSERT INTO ztqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per lëë do xñee nii schilo këb meñ lo pxosy o lo xñaa gaa: “Chilody kuñaa to yudar porque lëën ko kon kchësy nii chaapaa lo Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ni xñee gak to nii meñ nii këbsye sinrii, nodre ni kuñ meñ go xyudar pxosy o xyudaar gaa xñaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Singo mod lëë do xsaanlyu xtiits Dios nii xñabey par tsinal do kchë costumbre nii byaani do ni nii ksaan do. Ni ndalyre gaa stubla cos nii singo nak chuuñtsyey do. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lëë Jesús kwtsyetsy meñ stub aan lëë xaa chëb: —Kol kon nii kñen kchësy lo do ni kol kyeño: ");
INSERT INTO ztqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni tu cos nii xtyaaw chuñdy xtol meñ. Sink kchë cos mal nii xsya leñ styoo meñ chuñ xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kchësy to siñee chakladzy to kyeñ do, kol jkëëtyag. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsiñee lëë Jesús lox psonëz meñ, lëë xaa byo leñ yu nii xkwës xaa aan lëë xpëëdscuel xaa kwnabtiits xa nak cuent nii lox pso xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tsigo lëë xaa chëb: —¿Pe ni lëë do nayak xyeñdy? ¿Chondy to nawen nii ni tu nii chaw meñ chuñdy xtol meñ ");
INSERT INTO ztqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","por xsyëëbtyo xkyalmbañ meñ, sink leñsye meñ chitedyo, xlyëëdyak lëëw xchoo? Sinrii mod lëë xaa bluuy nii schilo kaw meñ kchëlo nii xtyaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ni chëb xaa: —Kchë cos mal nii xsya styoo meñ chuñ xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque leñ styoo meñ xsya cos yox, ni leñ styoo mguiy xlyañ nii lëë xaa kityni tu kwnaa aan karty ktsiilña xaa chop xaa me, ni leñ styoo meñ xlyañ nii lëë meñ kwan, ni leñ styoo meñ xlyañ nii lëë meñ kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Leñ styoo meñ nii nol tsiil xlyañ kyub stu kwnaa o stu mguiy gaa, ni leñ styoo meñ xlyañ nii lëë meñ tsoki, ni nii lëë meñ kuuñtsyey cos yox, ni kyalwkëti, ni kchë cos mal, ni kyalmbidy, ni tiits kizh, ni kyalnyats, ni leñ styoo meñ xsya tol. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kchësy cos re xchoo leñ styoo meñ aan chuño xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsi lëë Jesús bi siko, lëë xaa si kyedzy nii lë Tiro aan lëë xaa kwsëëb tu leñ yu. Koklasty xaa nii cho nyaknano, per pchilody nyolan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aan blyëëdy lëë xñaa tu mëëd kwnaa nii no tu kyalbini mal styoo koknan nii lëë xaa ptsiñ kyedzy ko. Lëë me kwey aan lëë me psoxib lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Meñ Sirofenicia nak me, xñee me tiits griego. Lëë me kwey lo Jesús aan lëë me kwnab nii kwii xaa kyalbini mal leñ styoo xiñtsyaap me. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per lëë Jesús chëb: —Blaa kaw klo mëëd porque buendyo nii kla ñe kyaxtily lo mëëd aan ktee ñew lo mëkw. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tsigo lëë me kwëb chëb me: —Nli, xey, xñeel, per axte wi mëkw chaw nii byuy nii xlaal mëëd leñ mezh. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tsigo lëë Jesús chëb: —Buen kwneel. Schilo kyeyoo. Lëë kyalbini mal go tse pchoo leñ styoo xiñtsyaapoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsiñee lëë kwnaa go ptsiñ lidzy, lëë xiñtsyaap me nixsye lo lon, per lëë kyalbini mal go tse pchoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lëë Jesús bi gak nëz Tiro aan lëë xaa kwtedy nëz kyedzy Sidón ni bla kyedzy nii nche nëz Decápolis. Lëë xaa ptsiñ chu nistoo Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Siko lëë meñ ptsiñni tu xaa nii chondy ni xñeedy aan lëë meñ kwnab nii kxob Jesús ña lady xaa xsyaknë go. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lëë Jesús kuni xaa xsyaknë go tublad laañee kindy meñ, aan lëë xaa kwloo xkweñ leñ tyag xaa xsyaknë go ni lëë xaa kwtëëb mxeñ lo ludzy xaa xsyaknë go. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Loxsye ngo lëë xaa blëp lo leñ kpaa, lëë styoo xaa ptyoob aan lëë xaa chëb: —¡Efata! (Tiits ko nak sinak nii xñee ñe: ¡Byaly!) ");
INSERT INTO ztqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wor go kazh lëë tyag xaa nii chondy ko byaly, ni lëë ludzy xaa go byaktsey aan lëë xaa kwnee nyë. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tsigo lëë Jesús chëb kazh lo kchë meñ, nii ni tu cho lo këbty meño. Per sootee tsiñee sopee tiits, mastre bitiits meño. ");
INSERT INTO ztqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ntseeb psee meñ xñee meñ: —Kchësyo chak xaa chuñ xaa. Axte ngop ni meñ nii chondy chuuñ kyak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lëë stu tse lëë meñ ptyopbe stub aan kindy pe kaw meñ. Ngo nii lëë Jesús kwtsyetsy xpëëdscuel aan lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Xkëstyoon meñ re por natse chak tson kpidz nii nche kchë meñ re lon aan kindy pe kaw meñ re. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aan deelñee ksonëëzaa kchë meñ re kyey lidzy singosy, ntseeb pa jkyey meñ re nëz, por no meñ nii sit sëëd. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tsigo lëë xpëëdscuel xaa kwëb chëb: —¿Per xa ktee no nii kaw kchë meñ re laañee ni tu cho nody? ");
INSERT INTO ztqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tsigo lëë Jesús kwnabtiits chëb: —¿Blak kyaxtily noy do? —Kadzyo —kwëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsigo lëë xaa kwnabey kwsob meñ lo lyu. Aan lëë xaa kwseñ ksa kadzy kyaxtily go. Loxsye ptee xaa skizh lo Dios, lëëw beeñ grol xaa aan lëëw ptee xaa lo xpëëdscuel xaa, aan lëë xpëëdscuel xaa kwtiisyo lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ni noy xaa bla mël wiñ, aan loxsye ptee Jesús skizh lo Dios, lëë xpëëdscuel xaa kwtiisy ma lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kchësy meñ taw axte laañee byëly, aan tsiñee lëë wagw kwlox, byaktsë kadzy tskwidy kyaxtily nii byaan. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aan xkaa meñ nii taw siik tap mily. Loxsye psonëz Jesús kchë meñ go, ");
INSERT INTO ztqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","lëë xaa byëp barkw ksa xpëëdscuel xaa aan lëë xaa kwey xtañ meñ Dalmanuta. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lëë xaa fariseo ptsiñ aan lëë xaa bislo ptilytiitsni xaa Jesús. Lëë xaa kwnab nii nyuñ Jesús tu kyalntson nii sëëd kpaa par kuñ xaa Jesús preb. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lëë styoo Jesús ptyoob aan lëë xaa chëb: —¿Penak xñab meñ mal re kyalntson? Nli xñen lo do nii kakty ni tu kyalntson. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tsigo nche gak xaa go, lëë xaa byëp barkw stub aan lëë xaa si stublad chu nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aan lëë xpëëdscuel xaa bnityladzy nyoy nii kaw xaa leñ barkw. Xaktyee tu kyaxtily sinoy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tsigo lëë Jesús chëb: —Kol kono gaa, kol kap cuent lo xlevadur xaa fariseo gon ni lo xlevadur Herodes. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aan lëë xpëëdscuel Jesús bislo xñee lo xcombañer: —Porñee nooydy no kyaxtily ngo nii kwnee xaa singo. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Lëë Jesús byeño aan lëë xaa chëb: —¿Penak nii xñee do nii noydy to kyaxtily? ¿Pe karty nawen kan do ni kyeñ do? ¿Pe tir nayak nguiedzy styoo do? ");
INSERT INTO ztqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Pe sob lo do yak aan chandy to, ni pe sob tyag to yak aan chondy to? ¿Xsalasty to nayak ");
INSERT INTO ztqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tsiñee kwtiisyaa kaay kyaxtily nii byaan dyon ptop to? Tsigo lëë xaa kwëb chëb xaa: —Tsiipchopo. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ni tsiñee kwtiisyaa kadzy kyaxtily lo tap mily meñ, ¿blak tskwidyo dyon ptop to? Tsigo lëë xaa kwëb, chëb xaa: —Kadzyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsigo lëë Jesús chëb: —Karty kyeñ do. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Loxsye ngo lëë xaa ptsiñ kyedzy Betsaida, aan lëë meñ kuni tu xaa nii chandy lo Jesús, ni lëë meñ kwnab nii nxob xaa ña xaa lady xaa nii chandy ko. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Lëë Jesús kwseñ ña xaa nii chandy ko aan lëë xaa kwlii xaa tublad chu kyedzy. Siko lëë xaa kwtëëb mxeñ lo xaa nii chandy ko, ni lëë xaa pxob ña xaa lady xaa. Loxsye ngo lëë xaa kwnabtiits dyon pe chan xaa go palalsye. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lëë xaa nii chandy ko bislo kon aan lëë xaa chëb: —Chanaa nii lëë meñ xsyë, per chak meñ si chak yag. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsigo lëë Jesús kwseñ lo xaa nii chandy ko stub aan lëëw byaktsey. Lëë xaa kon nyë kchë cos. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsigo lëë Jesús psonëz xaa lidzy xaa ni lëë xaa chëb lo xaa: —Ksëëbtyoo leñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Loxsye ngo lëë Jesús si nëz Cesarea kyedzy Cesarea de Filipo ksa xpëëdscuel. Aan nëz si xaa tsiñee lëë Jesús kwnabtiits lo xpëëdscuel chëb: —¿Cho xñee meñ dyon nii nakaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tsigo lëë xaa kwëb chëb xaa: —No meñ xñee nii Juan nii pchoobnis nakoo, no gaa meñ xñee nii lii nak Elías, no gaa meñ xñee nii no cho tu profet nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tsigo lëë Jesús chëb: —Lëë dook, ¿cho xñee do nii nakaa? Lëë Pedre kwëb chëb: —Lii nak Crist. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per lëë Jesús chëb kazh nii ni tu cho lo nyëbty xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lëë Jesús, mguiy nii pxaal Dios, bislo chuuñ kseedy xpëëdscuel xñee: —No nii teedyaa kchëlo kyalnë, ni ksaldy xaa kol naa, ni xaa nii xñabey lo pxosy, ni maestre ley. Lëë meñ kuty naa, per tse nii loxo tson kpidz lëën kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nyë nyë chëb xaa kchë nii ktsyool xaa. Tsigo lëë Pedre kuni Jesús tublad aan lëë xaa bislo kwëntseeb xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per lëë Jesús byoogw buy lo xpëëdscuel aan lëë xaa kwëntseeb lo Pedre chëb xaa: —¡Bichee nu, xaatox! Por nody kikoo sinak no kik Dios, sink sinak no kik meñ lo kislyu re no kikoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Loxsye ngo lëë Jesús kwtsyetsy kchësy meñ ni xpëëdscuel xaa aan lëë xaa chëb: —Deel no cho do chakladzy kak xpëëdscuelaa, kol knityladzy kuuñtsyey do nii xyo styoo do, ni kol kxob yañ xicrusy to aan kol tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Porque kchë meñ nii chakladzy kteelaa xkyalmbañ lo kyalkuty, lëë meñ go kety. Per lëë meñ nii kety por naa ni por xtiits Dios, lëë meñ go telaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Pe nan nii kuuñ xcheñ meñ tyub kislyu deelñee jkëëtañ meñ xkyalmbañ? ");
INSERT INTO ztqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿O palal gaa kchilo kizh meñ por xkyalmbañ meñ? ");
INSERT INTO ztqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Deelñee no cho xteladzy chan naa ni xteladzy chon nii xluyaa lo meñ mal ni ngoptol nii nche natiemp, singo gak kteladzy mguiy nii pxaal Dios kan kchë meñ go tsiñee lëë xaa kiid con xkyalxtisy Tat Tios kchë xaa angly. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ni chëbak Jesús: —Nli xñen lo do nii no bla meñ nii nche nu kejty axte nii kan kñabey Dios con kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tse nii kwloxo xoop kpidz lëë Jesús kwey tu kiy nii per nli busy klaa. Kuni xaa xaktyee Pedre, Jacob ni Juan. Siko xña lo xaa lëë Jesús ptsyëëlo. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bibëly xab xaa, byak nguitsy pu rusyo ni ni tu cho chilody ksaan nguitsy ladx singo nikxe nii xare kiibo. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ni lëë xaa kon nii lëë Elías ni Moisés ncheyutiits ksa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsigo lëë Pedre chëb lo Jesús: —Maestre, ¡xaatee mbëë nche no nu! Lëë noo ksaa tson yu yagxiidy nu: tuwo par lii, stuwo par Moisés, stuwo par Elías. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ksa xpëëdscuel Jesús ptsyeb. Ngo nii nandy Pedre pe xñee. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsigo lëë tu xkey ptaagw aan lëë xaa kwnity lo xkey. Aan lo xkey go pchoo tsiy Dios chëb: —Lëë xiñaa nii xkëstyoon nrii. Kol jkëëtyag xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aan tsiñee lëë xaa buy, ni stu cho kontre xaa, xaktyee Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsiñee lëë xaa siksëëb chex kiy go, lëë Jesús chëb kazh nii kwtiisty xaa nii kon xaa axte nii kpañ mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Por ngo kwlootseysye xaa leñ styoo xaa nii kon xaa, nikxe nii kwnabtiits lsa xaa lo xcombañer xaa xa nak nii kpañ meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsigo lëë xaa kwnabtiits lo Jesús chëb xaa: —¿Penak nii xñee maestre ley nii klo Elías no nii kiid? ");
INSERT INTO ztqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tsigo lëë xaa kwëb chëb xaa: —Nliw, no nii klo Elías kiid par kxixkwaa xaa kchësy cos. ¿Per penak tsigo nii xñee leñ kitsy nii kë xtiits Dios nii lëë mguiy nii pxaal Dios te kchëlo kyalnë ni ksaldy meñ xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per naa nii xcuentaa xñen nii lëë Elías biidle ni lëë meñ beeñtsyey xaa sinak nii kwlaañtyee styoo meñ, sinak nii xñee leñ kitsy nii kë xtiits Dios nii no nii tedy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tsi lëë xaa ptsiñ laañee nche stubla xpëëdscuel Jesús, lëë xaa kon nii per nli busy ndaly meñ nche kyako kwi xaa, ni lëë maestre ley nche ktilytiitsni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Siikñee lëë meñ kon Jesús, lëë meñ psee aan lëënlëdy lëë meñ kujkëëptyux xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Loxsye ngo lëë Jesús kwnabtiits lo xpëëdscuel chëb: —¿Pe cos nche ktilytiits to ksa do xaa gue? ");
INSERT INTO ztqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lëë tu xaa nii so siko kwëb chëb: —Maestre, lëën syely ni xiñganaa lool nu por lëë tu kyalbini mal no leñ styoo xaa aan lëëw beeñ ngop xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Laañee sotyee xaa lëë kyalbini mal xsyeñ xaa aan lëëw xchon xaa lyu. Aan xchoo ptsiñ chuw xaa, chaw lay xaa ni xkyedzy xaa. Lëën tse kwnab lo xpëëdscueeloo nii ngwii xaa kyalbini mal go, per pchilody xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tsigo lëë Jesús kwëb chëb: —¡Natsypee nguiedzy styoo do! ¿Axte pa wor këb ñe nii lëën ksaladzy lëë do? ¿Pa slal tiemp kxekwaa lo do? Kol tëni xaa wiñ go nu dyon. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsigo lëë xaa kuni xaa wiñ go lo Jesús. Per tsiñee lëë kyalbini mal go kon Jesús, lëëw beeñ nii lëë xaa wiñ go kutyë, aan lëë xaa byab lyu xtuupxto xaa ni xchoo ptsiiñ chuw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tsigo lëë Jesús kwnabtiits lo pxosy xaa chëb: —¿Destye pa wor chak xaa sinrii? Tsigo lëë pxosy xaa kwëb chëb: —Destye nii nak xaa xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aan ndaly vuelt no kchon kyalbini mal gue xaa lo ki ni lo nis par kutyo xaa. Singo nako deelñee schilo kuuñ kyakoo xaa, pkëstyoo lëë noo ni beeñ noo yudar. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tsigo lëë Jesús chëb: —¿Xa nak nii deelñee schilool? Kchësyo schilo lo meñ nii xniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsigo lëë pxosy xaa wiñ go kwchuptsyë chëb: —¡Xniladzyaa; beeñ naa yudar kniladzyraa! ");
INSERT INTO ztqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsiñee lëë Jesús kon nii lëë meñ xtyopre, lëë xaa kwëntseeb lo kyalbini mal go chëb xaa: —Kyalbini ngop ni ngwaat, naa xñabey nii kchool leñ styoo xaa wiñ re aan kpikchedroo sëëboo. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lëë kyalbini mal go kwchuptsyë, aan lëëw beetyë xaa wiñ go stub. Loxsye ngo lëëw pchoo leñ styoo xaa, psaano xaa sootee meñ nii lox kuty. Por ngo ndaly meñ kwnee nii lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per lëë Jesús kwseñ ña xaa, lëë xaa blische xaa, aan lëë xaa wiñ go kusoli. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Loxsye ngo lëë Jesús kwsëëb tu leñ yu, aan lëë xpëëdscuel xaa kwnabtiits chëb: —¿Penak nii pchiloody noo ngwii noo kyalbini mal go? ");
INSERT INTO ztqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lëë Jesús kwëb chëb: —Por parñee kwii ñe clasy kyalbini mal go no nii kutiitsni kazh ñe Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsiñee lëë xaa bi siko, lëë xaa kwte nëz Galilea. Per koklasty Jesús nii cho nyaknano ");
INSERT INTO ztqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porñee lëë xaa noyuuñ kseedy xpëëdscuel xaa xñee xaa lo xaa: —Lëë mguiy nii pxaal Dios jkaa ña meñ, aan lëë meñ kuty xaa. Per tse nii loxo tson kpidz lëë xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per byeñdy xaa nii kwnee Jesús aan ptsyeb xaa nyabtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lëë xaa ptsiñ leñ kyedzy Capernaum, aan lëë xaa nchenol leñ yu tsi lëë Jesús kwnabtiits chëb: —¿Pe cos no ktilytiits to nii syoop no nëz? ");
INSERT INTO ztqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per tsesy kwche xaa, porñee nan xaa nii worñee siid xaa nëz lëë xaa no ktilytiits xaa dyon cho xaa mastre non. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsigo lëë Jesús kwsob aan lëë xaa kwtsyetsy ksa tsiipchop xpëëdscuel xaa aan lëë xaa chëb: —Deel no cho chakladzy kak tu xaa nii mastre non, no nii kyaanlyu xaa ni jkiiñ xaa kchë lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Loxsye ngo lëë xaa pso tu xaa wiñ groltyee, lëë xaa kwteetsy xaa wiñ go aan lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Kchësy meñ nii kantsi tu xaa wiñ re porñee xniladzy meñ xtitsaa, naa chantsi meñ go. Ni kchësy meñ nii chantsi naa, lëdy nonsyaa chantsi meñ go, sink wi xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tsigo lëë Juan chëb: —Maestre, ptyon noo tu xaa nii nonsyke lël xseety xaa tsi lëë xaa kwii kyalbini mal, per como nody xaa lady no lëë noo pkaw. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsigo lëë Jesús kwëb chëb: —Jkady tow, porque ni tu xaa nii xseety lën par kuñ tu kyalntson kyaxty kñeenë naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Por meñ nii xtilynidy lëë no, no xlad no. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ni cholsye meñ nii kneetsy nikxe tub xigak nis ki do porñee nak ksa do Crist, nli xñen nii stikche Dios kyalnsaak ko lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Cualquier xaa nii kuñ xtol meñ nii xniladzy xtitsaa, masy buen kyëtuu tu kyomoliñ yañ xaa go aan tsikchon meñ xaa lo nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Deelñee ñal chuñ xtoloo, pchugo. Mbëëre sëëboo kpaa tunkoo, lëjty nii chop ñal sob aan kyeyoo laañee mban xtye meñ, laañee chilody kyuuy ki. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Deelñee niy gaal chuñ xtoloo, kwliiw. Mbëëre koxoo sëëboo kpaa, lëjty nii chop niyoo sob aan kyeyoo laañee mban xtye meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Deelñee loo gaal na chuñ xtoloo, kwliiw. Mbëë sëëboo kpaa con tugak lool, lëjty nii chop lool sob aan kyeyoo laañee mban xtye meñ, ");
INSERT INTO ztqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","laañee chejty msyog ni xyuuydy ki. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porque kchësy lady cos kwib ki sinak xkwib sedy lady pëël parñee xiñdyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Xkiiñ sedy. Per deelñee ksaano nii kak nxiyo, ¿xa kuñ do nii kyak nxiyo stub? Kol kak sinak sedy nii nxiy aan ngui kol kpañ ksa xcombañer do. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tsi lëë Jesús bi Capernaum, lëë xaa si nëz Judea ni tañ nii nche stublad chu kiigwpee Jordán. Siko lëë meñ ptyopbe lo xaa stub, aan lëë xaa bislo beeñ kseedy xaa meñ stub porñee singo nak xmod xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsigo lëë bla xaa fariseo big lo Jesús, aan parñee kuñ xaa Jesús preb lëë xaa kwnabtiits chëb xaa dyon pe schilo klaa tu mguiy tsiil. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsigo lëë Jesús kwëb chëb: —¿Pe cos kwnabey Moisés lo do? ");
INSERT INTO ztqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tsigo lëë xaa chëb: —Ptee Moisés tiits nii klaa tsiil meñ, per no nii ktee xaapkiy tublë kitsy lo kwnaa. No nii kñee lo kitsy ko nii lëë xaa blaa me. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsigo lëë Jesús chëb: —Ptee Moisés tiits porñee singueetyee nguiedzy styoo do, ");
INSERT INTO ztqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","per worñee lëë Dios gon psaa kchësy cos, “tu mguiy ni tu kwnaa psaa Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Por ngo no nii klaa mguiy pxosy ni xñaa parñee kpañ xaa chop tsiil xaa ");
INSERT INTO ztqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","aan chop xaa kak sinak tugak meñ. Singo naktre xaa chop, sink tugak nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por ngo nody nii klaa mguiy kwnaa nii pteedy Dios lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lëë tsi lëë xaa ptsiñ chu yu, lëë xpëëdscuel xaa kwnabtiits stub xa nak cos ko. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tsigo lëë Jesús chëb: —Xaa nii xlaa tsiil aan xtsiilña xaa stu kwnaa, tol chuñ xaa lo meñ klo. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O deelñee gaa lëë kwnaa xlaa tsiil par ktsiilña me stu mguiy, wi me chuñ tol. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lëë meñ kuni bla xaa wiñ lo Jesús parñee kxob xaa ña xaa kik xaa wiñ go, per lëë xpëëdscuel Jesús bislo kwëntseeb lo meñ nii xtsiñni xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tsiñee lëë Jesús kono, lëë xaa blëë aan lëë xaa chëb: —Kol klaa kiid xaa wiñ lon. Jkady tow, por xcheñ meñ nii nak sinak xaa wiñ nak laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nli xñen lo do nii deelñee knilasty meñ xtiits Dios sinak xniladzy tu xaa wiño, sëëbty meñ laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aan lëë xaa kwteetsy kchësy xaa wiñ go, ni lëë xaa pxob ña xaa kik kchë xaa wiñ go. Singo lëë xaa beeñlay xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lëë Jesús nol nëz nii kpi, tsiñee lëë tu mguiy ptsiñ wxooñ psoxib kwnabtiits chëb: —Maestre buen, kwnë dyon pe cos no nii kuñaa parñee jkan tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tsigo lëë Jesús kwëb chëb: —¿Penak nii xñeel nii bueenaa? Tugak meñ buen no. Lëë meñ go nak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nanloo kchë nii kwnabey Dios: “Kujtyoo, kaptyoo stu kwnaa deelñee no tsiiloo, kwandyoo, jkots tiits kizhtyoo meñ, jkëëtiidyoo, psoob xtiits pxoosyoo ni xtiits xñaal.” ");
INSERT INTO ztqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Lëë mguiy go kwëb chëb: —Maestre, kchësy ngo noyuuñtsyeyaa destye nii nakaa xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Lëë Jesús buy lo xaa aan pkëstyoo xaa xaa. Loxsye ngo lëë Jesús chëb: —Tu cos chakoo falt: Byey, pto kchësy nii chapoo aan pkady tumi go lo meñ prob tsiin kchilo ndalyre nii kapoo kpaa. Tsigo të aan tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lëë styoo mguiy go bikche tsiñee lëë xaa biñ ngo. Mbansye ptee styoo xaa, lëë xaa bi, porñee tir rikw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsigo lëë Jesús buy kyako kwi, aan lëë xaa chëb lo xpëëdscuel xaa: —¡Xaatee ngan sëëb tu rikw laañee xñabey Dios! ");
INSERT INTO ztqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ntseeb psee xpëëdscuel xaa biñ nii kwnee xaa, per lëë Jesús bikche chëb: —Xiñ, ¡xaatee ngan sëëb meñ laañee xñabey Dios! ");
INSERT INTO ztqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Masy ngandy xsyak tu camey te ma xan tu kyeech kuzh. Mastre ngan xsyak tu rikw sëëb xaa laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsiñee biñ xaa ngo, mastre psee xaa, aan kwnabtiits lsa xaa lo xcombañer xaa xñee xaa: —Aan ¿cho telaa lo tol tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tsigo lëë Jesús buy lo xaa aan lëë Jesús kwëb chëb: —Chilody telaa meñ nonsy, per lëë Dios kteelaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsigo lëë Pedre bislo kwnee chëb: —Lëë noo psaan noo kchësy nii chaap noo, aan lëë noo syoop naal lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tsigo lëë Jesús chëb: —Nli xñen nii kchësy meñ nii xsaan lidzy, betsy, psyañ, xñaa, pxosy, o xilyu gaa por naa ni por xtiits Dios nii xteelaa, ");
INSERT INTO ztqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","misme lo kislyu re skaa meñ go siik tu kyoow nii psaan meñ go sinak yu, betsy, psyañ, xñaa, xiñ ni xilyu, nikxe con kyalnë. Aan lëë lo stu kislyu lëë meñ go jkaa tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Per kchësy meñ nii nak meñ klo nina, kyak meñ lultime. Ni ndaly meñ nii nak meñ lultime nina, kyak meñ klo. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lëë xaa no nëz si xaa Jerusalén, aan lëë Jesús nechsye lo xpëëdscuel. Ksa xpëëdscuel xaa psee, per lëë meñ nii nal xtsyeb. Tsigo lëë Jesús, mguiy nii pxaal Dios, kwtsyetsy ksa tsiipchop xpëëdscuel tublad aan lëë xaa bislo bitiits xaa kchë nii ktsyool xaa, chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Chan do gon lëë no syo Jerusalén laañee lëën jkaa ña maestre ley. Lëë xaa kñab ketyaa ni lëë xaa jko naa ña meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lëë xaa kityni naa, lëë xaa kchoo mxeñ naa, lëë xaa kiñ naa ni lëë xaa kuty naa. Per tse nii loxo tson kpidz lëën kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Lëë chop xiñ Zebedeo nii lë Jacob ni Juan big lo Jesús aan lëë xaa chëb: —Maestre, chakladzy noo nii kuñoo tu favor nii kñab noo lool. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lëë Jesús kwnabtiits chëb: —¿Pe cos chakladzy to nii kuñaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lëë xaa chëb: —Bneetsy tiits nii tsiñee lëël sob kñabeyoo, syoob tuu gaa noo tyuxlad kwil, tuu noo nëzli, tuu noo nëzpeg. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsigo lëë Jesús kwëb chëb: —Nandy to pe xñab to. ¿Pe mod stedy to kyalnë nii teedyaa nayak, ni pe schobnis to nayak sinak chobnisaa lo xkyalnën ni xkyalkutyaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsigo lëë xaa kwëb chëb xaa: —Schiloo noo. Tsigo lëë Jesús chëb: —Nli ste do kchë kyalnë nii teedyaa ni schobnis to con kyalnë nii chobnisaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Per nii sob to kwin nëzli o nëzpeg kaa, lëdy naa xyal knetsyo, sink lëëw jkaa meñ nii xyal jkaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tsiñee lëë stsii xpëëdscuel xaa biñ ngo, lëë xaa bislo blëë xaa lo Jacob ni lo Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Per lëë Jesús kwtsyetsy xaa aan lëë xaa chëb: —Nan do gon xa chuñ meñ xñabey lo kislyu re. Xsyak xaa nii tir non xaa aan chuuñ xcheñ xaa laañee xñabey xaa. Singo gak xtisy, tir nroob xkyalwnabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per lëë lady to gon lëdy singow. Deel no tu xaa nii chakladzy kak non lo do, no nii jkiiñ xaa kchësy lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ni deel no tu do nii chakladzy kak tu xaa nii mastre non, no nii jkiiñ xaa kchë lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porque biijty mguiy nii pxaal Dios parñee kantsi meñ xaa, sink parñee kantsi xaa meñ ni kety xaa parñee telaa ndaly meñ lo xtol. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lëë xaa ptsiñ kyedzy Jericó. Aan tsiñee lëë Jesús no nëz nii kchoo chu kyedzy ko ksa xpëëdscuel ni tub yox meñ, lëë xiñ Timeo nii lë Bartimeo sob kex chu nëz nii xtyedy siko xñab tumi lo meñ porñee chandy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tsiñee lëë xaa biñ nii lëë Jesús xaa Nazaret sitedy siko, lëë xaa bislo chuptsyë xaa xñee xaa: —¡Jesús, lii nii sëëdoo lo xtiiy rey David, pkëstyoo naa! ");
INSERT INTO ztqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ndaly meñ kwëntseeb lo xaa parñee nyoogw chuw xaa, per mastre kwchuptsyë xaa xñee xaa: —¡Jesús, lii nii sëëdoo lo xtiiy rey David, pkëstyoo naa! ");
INSERT INTO ztqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsigo lëë Jesús kwso tse aan lëë xaa chëb: —Kol kwetsy xaa dyon. Tsigo lëë meñ kwtsyetsy xaa nii chandy ko, chëb meñ lo xaa: —Nguiool kwloo styool aan kuso, por lëë xaa xkwetsy lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lëë xaa nii chandy ko pchon xkaxkem tublad aan lëë xaa kwyas big xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tsigo lëë Jesús kwnabtiits chëb: —¿Pe cos chakladzyoo nii kuñaa? Tsigo lëë xaa nii chandy ko chëb: —Maestre, chakladzyaa kanaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tsigo lëë Jesús chëb: —Schilo kyeyoo. Porñee bniladzyoo ngo nii lëël byak. Wor go kazh lëë xaa nii chandy ko kon, aan lëë xaa kunal Jesús tyub nëz. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tsiñee lëë xaa ptsiñ kex Jerusalén laañee nche kyedzy Betfagé ni kyedzy Betania laañee nyoo sob kiy nii lë Olivos, lëë Jesús pxaal chop xpëëdscuel ");
INSERT INTO ztqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","chëb xaa lo xaa: —Kol tsi kyedzy nii nche kexka ske aan tsiñee ktsiñ do, lëë do kan tu burr nii këtuu. Ni tu cho karty sob lady ma. Kol klaa ma aan kol tëni ma. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aan deelñee cho kñabtiits lo do penak xlaa do ma, kol këb nii naa jkiiñ ma. Na kakni gakaa ma. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lëë xpëëdscuel xaa si, aan tsiñee lëë xaa ptsiñ kyedzy ko, lëë xaa kon nii lëë burr këtuu kex tu chu yu laañee xtye nëz aan lëë xaa blaa ma. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Aan lëë bla meñ nii nche siko chëb lo xaa: —¿Pe cos chuñ do? ¿Penak nii xlaa do burr gue? ");
INSERT INTO ztqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsigo lëë xaa chëb si chëb Jesús lo xaa. Aan lëë meñ blaa biy xaa ma. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tsi lëë xaa ptsiñni ma laañee so Jesús, lëë xaa pxob xab xaa lady ma aan lëë Jesús kwsob lady ma. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aan ndaly meñ ptañ xab lo nëz. No gaa meñ pchug xikw yag aan kwleek meño lo nëz. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tsigo lëë kchësy meñ nii nech ni meñ nii nal bislo kwchuptsyë xñee: —¡Skizh Dios! ¡Xaatee buen xaa nii pxaal xaa lo no! ");
INSERT INTO ztqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Skizh Dios nii lëë xaa pxaal tu xaa nii kñabey lëë no sinak kwnabey rey David! ¡Kol ktee skizh lo Dios! ");
INSERT INTO ztqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Singo kwsëëb Jesús leñ kyedzy Jerusalén ni leñ lidzy Dios. Aan loxsye buy xaa kchësy cos nëz re nëz rek, lëë xaa si Betania ksa xaa ksa tsiipchop xpëëdscuel xaa porñee lëë tse ptsyel. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lëë byaani lyu lëë xaa bi Betania, aan lëë Jesús kwlaañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aan sitre so xaa kon xaa tub xan yag yegw nii singootyee no xikw. Aan lëë xaa kukuy dyon pe kë yegw, per këdyo. Xaktyee xiplago singootyee xña porñee lëdy xtiemp yegw. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsigo lëë Jesús kwnee lo yag yegw, chëb xaa: —Ni tu cho kpikchedre kaw xnexoo. Aan biñ xpëëdscuel xaa nii kwnee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Loxsye ngo lëë xaa ptsiñ leñ kyedzy Jerusalén. Aan tsiñee lëë Jesús kwsëëb leñ lidzy Dios, lëë xaa bislo kwlii xaa kchësy meñ nii nche kto ni nche si siko. Ptische xaa xmezh meñ nii no ktsëë tumi lo xcombañer, ni ptische xaa xyagxily meñ nii xto palom, ");
INSERT INTO ztqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ni blaady xaa nsyëëb meñ nii noy pe cos leñ lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aan lëë xaa bislo beeñ kseedy xaa meñ xñee xaa: —Leñ kitsy nii kë xtiits Dios gon xñee: “Lidzyaa kak tu laañee kiidnee kchësy meñ lo Dios”, per lëë do byuño lidzy ngbaan. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lëë xaa nii xñabey lo pxosy ni maestre ley biñ nii kwnee Jesús. Ngo nii lëë xaa bislo byub xaa mod par kuty xaa xaa. Nli gaa nii ptsyeb xaa Jesús porñee kon xaa kchësy meñ psee biñ xiwseedy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Per tsiñee lëë lyu pkyey lëë Jesús pchoo kyedzy ksa xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lëë byaani stu lyu silyga, lëë xaa kwte kexka xan yag yegw aan kon xaa nii axte luw pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsigo lëë Pedre psaladzy nii chëb Jesús lo yag yegw ko aan lëë xaa chëb: —Maestre, buy gaanoo lëë yag yegw nii ptsiibteel pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tsigo lëë Jesús kwëb chëb: —Kol kniladzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Por nli xñen deelñee cho këb lo kiy re: “Bichee nu aan kukyab lo nistoo”, aan xkandy kik xaa, sink xniladzy tyub styoo xaa nii lëë nii xñee xaa kak, tsigo sako. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por ngo lëën xñe lo do nii kchësy nii kñab to lo Dios, deelñee xniladzy to nii lëëw chaple to, lëëw kap to. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Aan tsiñee lëë do noyutiitsni Dios, kol knityladzy tol nii ngo xcombañer do lo do parñee ktsily pxosy to nii sob kpaa xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsiñee lëë xaa ptsiñ Jerusalén stub, lëë Jesús kwsëëb leñ lidzy Dios, aan lëë xaa nii xñabey lo pxosy, ni maestre ley, ni bla xaa kol big lo xaa ");
INSERT INTO ztqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","aan lëë xaa kwnabtiits chëb xaa: —¿Cho bneetsy tiitspey lool par kuuñtsyeyoo kchë nii chuuñtsyeyoo? ");
INSERT INTO ztqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tsigo lëë Jesús kwëb chëb: —Wi gak gaan dyon kñabtiits tu cos lo do. Deelñee snë dow na, tsigo sniyaa cho xtiitspey chuuñtsyeyaa kchë cos re. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Cho pxaal Juan dyon biid kchoobnis xaa? ¿Pe Dioso ote no chol meñ lo kislyu rew yak? Kol nëw dyon. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsigo lëë xaa go bislo ptilytiits lsa xñee xaa: —Deelñee tyeesy no nii Dios pxaal xaa, kñë xaa lo no: “¿Penak tsigo bnilasty to nii bluuy xaa?” ");
INSERT INTO ztqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lëë deelñee tyeesy no nii chol meñ lo kislyu re pxaal xaa, no nii ktsyeb no meñ, por kchësy meñ xniladzy nii nli xtiits Dios bluuy Juan. ");
INSERT INTO ztqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Por ngo lëë xaa chëb lo Jesús: —Ndondy noow. Tsigo lëë Jesús kwëb chëb: —Per ni naa ngo busy kniydy dyon cho xtiitspey chuuñtsyeyaa kchësy cos re. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lëë Jesús bislo beeñ kseedy meñ nonsyke con cuent xñee xaa: —Tu xaa name beeñ pni xaa yag uv aan lëëw psuugw kwraly xaa, ni lëë xaa kwteeñ tu kyeech par kxii xaa uv tsiin kchoo viñ ni psaa xaa tu laañee klaa sob xaa par kyënap xaaw. ’Loxsye ngo lëë xaa kwlootiñ lyu go lo bla xaa nii kuuñ xtsiiño aan lëë xaa si sit. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsiñee lëë xtiemp uv kol, lëë xpixwano pxaal tu xmos siknab nii xyal xaa lo xaa nii beeñ tsiiño. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per lëë xaa tsiiñ psaksi xmos xaa, ptee xaa xcheñ xaa aan lëë xaa psonëz xaa singosy. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tsigo lëë xpixwano pxaal stu mos, per xaa gosy kwlë xaa kik xaa ni kwlootsyetsy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pxaalak xaa stu xaa, lëël beetyak xaa xaa. Loxsye ngo lëë xaa pxaal stubla xaa. No cheñ xaa ptee xaa tsiiñ go, no gaa xaa beety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Lëë lultime lëë xaa pxaal yuub xiñ xaa nii mastre xleni xaa nladzy xaa: “Sak mbeñ xaa tsiiñ xiñganaa.” ");
INSERT INTO ztqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per lëë xaa tsiiñ go chëb lo xcombañer: “Lëë xaa re nak nii kyaani kchësy nii chap pxosy. Kol tsoo kuuty no xaa tsiin kako xcheñ no.” ");
INSERT INTO ztqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lëë xaa kwnaasy xaa, aan lëë xaa beety xaa. Loxsye ngo lëë xaa kukchon xaa tublad chu kwaa nii no yag uv. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsigo lëë Jesús kwnabtiits chëb: —¿Pe në do dyon pe kuñ xpixwan uv? Tsi xaa wo aan kuty xaa xaa tsiiñ go ktee gaa xaa kwaa go lo stu meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Pe karty nayak klab to xkitsy Dios laañee xñee: Lëë kyo nii psëëb meñ nii xsaa yu byak tu kyo nii mastre xkiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lëë Dios beeñtsyey nrii aan xsee no xtyon now? ");
INSERT INTO ztqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsigo lëë xaa kokladzy nyoy xoo xaa Jesús porñee byeñ xaa nii contre lëë xaa pso Jesús cuent ko. Per como ptsyeb xaa meñ, lëë xaa psaan Jesús aan lëë xaa bi. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Loxsye ngo lëë xaa pxaal bla xaa fariseo ni bla xaa nii nak ksa Herodes lo Jesús parñee dyon tsaap nyë Jesús tublan tiits nii nchilo nguëëkiy xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lëë xaa kwey chëb xaa: —Maestre, ndon noo nii nonsyke tiitsli xñeel, xsaldyoo nii xñee meñ porque xseedyoo xa chak meñ. Liisy nli gaa na xluuyoo xa kpañ ñe sinak xñabey Dios. ¿Pe nonguial dyon tizh noo lo xtisy Roma ote nonguialdyo yak? ¿Pe stizh noo ote tizhty noo yak? ");
INSERT INTO ztqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per lëë Jesús byeñ pe cos tsiiñ si xaa aan lëë xaa chëb lo xaa: —¿Penak nii chakladzy to kuñ do naa preb? Kol tëni tu pes lon dyon parñee kanno. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lëëw kuni xaa aan lëë Jesús chëb: —¿Cho nrii kë loo go ni cho lë kë nu? Tsigo lëë xaa kwëb chëb xaa: —Lëë xtisy Roma nii lë César kë low. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsigo lëë Jesús chëb: —Kol ktee nii nak xcheñ César lo César ni kol ktee gaa nii nak xcheñ Dios lo Dios. Aan ntseeb psee meñ go biñ nii chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsigo lëë bla xaa saduceo kwey lo Jesús. Lëë xaa saduceo xñee nii nlidy xpañ meñ kuty. Por ngo kunabtiits xaa lo Jesús chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestre, Moisés gon pkëë nii deelñee ktsiilña tu xaapkiy aan klyëëdy kety xaa aan ksaandy xaa mëëd lo tsiil xaa, no nii ktsiilña betsy xaa kwnaa viud nii psaan xaa parñee kap tsiil betsy xaa nii kuty mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Per tu vuelt name tu xaa kadzy betsy nak xaa aan lëë xaa nii nak xaa kol lo xaa ptsiilña, per lëë xaa kuty aan kopty tsiil xaa mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tsigo lëë xaa nii so xitsy xaa ptsiilña kwnaa viud ko, per lëë xaa kutyak aan kopty kwnaa go mëëd. Singo gak ptsyool stu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ksa kadzy xaa ptsiilña, per ni tu xaa psaandy mëëd. Lëë byalo wi kwnaa go kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Per lëë nana busy tsiñee lëë xaa kpañ, ¿cho tsiil xaa kak kwnaa go deel ksa kadzy xaa ptsiilña me? ");
INSERT INTO ztqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tsigo lëë Jesús kwëb chëb: —Nandy to pe xñee do, porñee xyuumbeydy to kitsy nii kë xtiits Dios ni xyuumbeydy to xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tsiñee lëë meñ kuty kpañ, ni mguiy ni kwnaa gaa ktsiilñady, sink lëë meñ nii kpañ kak sinak angly nii ncheno kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Xñee do lë nii nlidy xpañ meñ kuty. ¿Pe karty nayak klab to xcuent yakitsy nii noyek leñ libre nii pkëë Moisés laañee chëb Dios: “Naa nak xDios pxusykoltoo do Abraham, ni pxusykoltoo do Isaac ni pxusykoltoo do Jacob”? ");
INSERT INTO ztqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aan Dios gon nakty xaa xDios meñ kuty, sink xDios meñ nii mbañ nak xaa. Ngo nii xñen nandy to pe xñee do. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wi tu maestre ley nii no lady meñ biñ wtilytiits ko, ni biñ xaa nii ngui kwëb Jesús lo xaa saduceo. Ngo nii lëë xaa kwnabtiits chëb xaa: —¿Cho nii xñabey Dios dyon kuuñtsyeey no mastre non? ");
INSERT INTO ztqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tsigo lëë Jesús kwëb chëb: —Lëë nii xñabey Dios nii mastre non lo kchësyo nak nrii: “Biño meñ Israel, tugak Dios gon nak xDios no, kintre stu Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pkëstyoo xDioosoo tyub styool, tyub xkyalbiniil, ni tyub xkyalcheeñoo ni tyubñaa fuersy nii nol.” ");
INSERT INTO ztqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ni xñabey Dios nii jkëstyool xcombañeeroo sinak nii xkëstyool lii. Porque jkëstyoo no Dios ni jkëstyoo no xcombañer no, nrii mastre non lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsigo lëë maestre ley chëb lo xaa: —Singow, maestre. Nli xñeel nii tugak Dios no ni kintre stu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ni nii jkëstyoo ñe Dios tyub styoo ñe, ni tyub xkyalcheñ ñe, ni tyub fuersy nii no ñe, ni nii jkëstyoo ñe xcombañer ñe sinak lëë ñe, mastre nono que kchë ma nii chek lo pkoog ni kchë nii chiksakon meñ lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tsiñee kon Jesús nii ngui no kik maestre ley go, lëë xaa chëb lo xaa: —Xlyëëdre lëë klaa kñabey Dios lii. Aan ni tu cho byaxtre tsigo nyabtiits pe stu cos lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lëë Jesús noyuuñ kseedy meñ leñ lidzy Dios aan lëë xaa kwnabtiits chëb xaa: —¿Penak dyon nii xñee maestre ley nii lo xtiiy rey David sëëd Crist? ");
INSERT INTO ztqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Per con lëë Kyalbini Ntson cheñ Dios na beeñ knee rey David chëb xaa: Chëb Dios lo xaa nii xñabey naa: “Kwsob kwin nëzli axte nii tsitsiñ tse nii lëël kñabey kchë lo meñ nii xlëë lool.” ");
INSERT INTO ztqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Xa kñabey Crist rey David deelñee lo xtiiy rey David pchoo Crist? Aan tyub styoo kchësy meñ go pkëëtyag xiwseedy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lo xiwseedy Jesús xñee xaa: —Kol kap cuent lo maestre ley, por xtsiladzy xaa kakw xaa kchë ladx non ni xtsiladzy xaa jkëëptyux meñ xaa laañee ktsyooltyee meñ xaa lo kiy. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Xyub xaa skan leñ ktoo laañee xsyob meñ non ni tsiñee chi xaa tu wagw xyubpee xaa sob xaa laañee kan meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ni xla xaa lidzy kwnaa viud, aan parñee këb meñ nii tir buen xaa xsyo xaa chool xaa tu lay nii xyaldy kaa. Por ngo mastre ksaksi Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Lëë Jesús kwsob laañee sob alcansiy xuy xaa xko meñ tumi leñ alcansiy ni chan xaa xtsiñ meñ rikw nii xko tub yox tumi leñ alcansiy. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsiñee lëë tu kwnaa viud nii tir prob ptsiñ, lëë me kwloo chop centab cobre nii xisy non leñ tu alcansiy. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tsigo lëë Jesús kwtsyetsy xpëëdscuel aan lëë xaa chëb lo xaa: —Nli xñen lo do nii nroobre tumi nii kwloo kwnaa viud re alcansiy que kchë nii kwloo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porque kchësy meñ xtee tumi nii xkiiñtre lo meñ, per lëë me lo xkyalprob me, lëë me ptee kchësy tumi nii nseñ me. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tsiñee lëë Jesús pchoo lidzy Dios, lëë tu xpëëdscuel xaa chëb: —¡Maestre, buy gaanoo xaatke ngol kchë kyo gue ni xaatke ngui kchë yu gue! ");
INSERT INTO ztqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tsigo lëë Jesús kwëb chëb: —¿Chanoo kchë yu ngol re lë? Per ni tu kyo kyaandy lady xcombañero. Kchësyo nitylo. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Loxsye ngo lëë Jesús si kiy nii lë Olivos aan lëë xaa kwsob chex kiy laañee nyoo lidzy Dios. Siko sob xaa tsi lëë Pedre, Jacob, Juan ni Ndresy kwnabtiits tsilaan lo xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Chakladzy noo nii kñëël loo noo pa wor kak kchë nii kwneel. ¿Ni xa mod kyeeñ noo nii lëëw mer kak? ");
INSERT INTO ztqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tsigo lëë Jesús kwëb chëb: —Kol kap cuent parñee ni tu cho jkëëtidy lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Por ndaly xaa nii jkiiñ lën kiid aan kñë xaa nii lëë xaa nak Crist, ni skëëti xaa ndaly meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Tsiñee kon do nii lëë tily chak nëz re nëz rek, ktsyebty to, porque singo no nii kako. Per nitylody kaa kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porque lëë kyedzy ktily lsa ni lëë xaa xñabey ktily lsa. Ni ndaly laañee kni xu ni lëë kpiñ tso. Lëë kchë kyalnë go tsigo kal bislo. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ligier kol kak. Por lëë meñ tsikso lëë do lo xaa xñabey ni lëë meñ kiñ lëë do leñ ktoo. Ni lëë do tsinee lo xtisy ni lo rey por naa. Siko lëë do kñee xtitsaa lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Por antes nii nitylo kislyu, lëë kchë meñ nii nche lo kislyu kon xtiits Dios nii xteelaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ni pe tsinidy kik to nii dyon pe kñee do tsiñee lëë meñ tsini lëë do lo xaa xñabey, sink kol nee nii kñë Dios lo do wor go, porque lëdy to kñee, sink Kyalbini Ntson cheñ Dios kñee. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","So tse nii lëë meñ kñabey kety betsy ni so tse nii misme pxosy meñ kñabey kety meñ. Ni so gaa tse nii lëë xaa wiñ kak niladzy pxosy aan lëë xaa kñabey kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kchësy meñ klëë lo do porñee xsoob to xtitsaa. Per deelñee kxekw to te do kchë lo kyalnë go, stelaa do. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tsiñee kan do nii lëë nii ntseeb nii xnitylo noyak laañee nody nii kako, tsigo kchësy to nii no do Judea no nii kxooñ do tsëp to kiy. (Deel xlab to nrii, kol ktee nii kyeñ dow.) ");
INSERT INTO ztqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ni deelñee so do kik lidzy to tse go, kyejty to par pe kwii do. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ni deelñee nche do tañ, kpikchedy to par tsikxi do xab to. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Brob kchë kwnaa nii nak xiñ tse go o kwnaa nii xkadzy kaa xiñ! ");
INSERT INTO ztqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kol nab lo Dios nii kakty kchësy nrii mëë nii chak nal. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porque tse go lëë meñ tedy kyalnë dox nii karty te meñ destye nii kwleek Dios kislyu, ni kpikchedre gaa kan meñ kyalnë dox ko loxsye tedyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aan deelñee kuuñ ktopty Dios tiemp ko, ni tu cho telaady. Per lëëw kuuñ ktop xaa porñee xkëstyoo xaa meñ nii kwle xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Deelñee cho kñë lo do tse go: “Kol kuy gaanoo, lëë Crist so nu”, o “Lëë gaa xaa so ske”, knilasty tow. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Por ndaly kchë xaa wnee xuuy nii kiid kñë lo do nii lëë xaa nak Crist, ni kñë xaa nii lëë xaa sëëdni xtiits Dios, ni suuñtsyey xaa milagre ni kyalntson parñee jkëëti xaa meñ nii kwlel Dios deelñee steedyo tiits. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Per lëë do ligier kol kak, por lëën niyle lo do kchë nii kak. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Tsi lëë kchë kyalnë dox ko lox tedy, lëë lo ngbidz jkyey, ni lëë mëë kyuuy, ");
INSERT INTO ztqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ni lëë mëly kchingaa leñ kpaa ni lëë kchë nii no leñ kpaa kni. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chëbak Jesús: —Naa nii nakaa mguiy nii pxaal Dios, lëë meñ kan kchukën lo xkey con tu kyalwnabeyaa ni tu kyalntsonaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lëën kxal xanglyaa tsiktop kchësy meñ nii kwlelaa tyubñaa lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Kol kseedy xcuent yag yegw: Tsiñee lëë xikwo xkë peñ, aan lëë xiplago xchukë, xyeñ do nii lëë xtiemp kyo sëëd yob. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Singo gak tsiñee kan do nii lëë kchë cos re noyak, syeñ do nii lëën mer kyely. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ni xñen lo do nii antes nii tedy kchë meñ nii no natiemp lëë kchë cos re kak. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Stedy kpaa ni stedy kislyu, per lëë xtitsaa tejtyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Per lëë tse nii kako ni wor ni tu cho nandyo, ni angly nii ncheno kpaa. Ni naa nii nakaa mguiy nii pxaal Dios nandyno. Xaktyee Tat Tios nano. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ligier kol kwe ni kol kwena por nandy to pa wor tsitsib tse go. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nak kchë nrii sinak tu xaa nii no nëz tsi tu tañ sit, aan antes nii kchoo xaa lëë xaa xsaan tsiiñ nii kuñ catu xmos xaa, ni lëë xaa xso tu xaa nii kyënap chu puert. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Singo tsigo busy, kol kwena, porque nandy to pa wor klañ xpixwan yu, deelñee xkyeysye lyuw, o wrol gaa kyoolo, o worñee gaa xpetsy nguidy kolo o xyeñsye kaa taño. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Toontlaa kolpsye klañ xaa aan jkaa do lo mgaal. ");
INSERT INTO ztqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nii xñe gakaa lo do xñen lo kchësy meñ: Kol kwena. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Schop kpidz chak falt kak paskw. Lo lni go chaw meñ Israel kyaxtily nii xkyëdy levadur. Lëë xaa nii xñabey lo pxosy ni lëë maestre ley bislo xyub mod dyon xa kñaasy xaa Jesús par kuty xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per lëë gak xaa xñee: —Kñaasty no xaa na lni parñee kak nxoldy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lëë Jesús kwey Betania lidzy Simoñ nii kwlañ kyalkits nii lë lepra. Lëë xaa sob lo mezh noyaw xaa tsiñee lëë tu kwnaa ptsiñ noy tu bot. Kaktsësyo tub clasy aceit nii xlyaa nex. Tir nyazh non clasy aceit ko. Lëë me pxaly bot ko aan lëë me kwtëëb aceit nii xlyaa nex ko lo kik Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Per no bla xaa nii nche siko blëë aan xñee xaa lo xcombañer xaa: —¿Penak lika kwxiñ aceit nii xlyaa nex re? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nchilopee ndyow mansye tson kyoow denario par kak meñ prob yudar. Aan blëë xaa lo kwnaa go. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per lëë Jesús chëb: —Kol ksaan me. ¿Penak chisyeedy to me? Buen beeñ me. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Por tugak gon kan do meñ prob, aan schiloo gaa kuñ do meñ prob yudar tsiñee klyaño styoo do, per naa gon lëdy tugak tson lady to. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lëë kwnaa re beeñtsyey nii pchilootyee lo me. Lëë me kwtëëb aceit nii xlyaa nex re ladyaa parñee tsel xixkwaa xcuerpaa tse nii lëën jkyeetsy. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nli xñen lo do nii kchë laañee kluuy meñ xtiits Dios nii xteelaa tyub lo kislyu, lëë meñ kutiits nii beeñtsyey kwnaa re parñee ksaladzy meñ me. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lëë tu xpëëdscuel Jesús nii pcholë Judas Iscariote kunee lo xaa nii xñabey lo pxosy parñee këb xaa dyon xa jkaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tsiñee lëëw biñ xaa xñabey, per nli busy ble xaa, aan lëë xaa chëb nii stee xaa tumi lo Judas. Tsigo lëë Judas bislo byub dyon xa jkaa Jesús lo xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tse nii chislo lni nii chaw meñ Israel kyaxtily nii xkyëdy levadur, ni tse nii chuty meñ mëkwxiily nii ktyaaw paskw, lëë xpëëdscuel Jesús kwnabtiits chëb: —¿Pa chakladzyoo nii kyokuuñloo noo nii tyaaw xtsee no na paskw? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsigo lëë Jesús pxaal chop xpëëdscuel chëb xaa: —Kol tsi leñ kyedzy. Siko lëë do kan tu xaa nii noy tub che nis. Kol tsinal xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","aan laañee sëëb xaa, kol këb lo xpixwan yu: “Lëë maestre xñabtiits: ¿Pa sob yu laañee kaw xtseen na paskw ksa xpëëdscuelaa?” ");
INSERT INTO ztqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Lëë xaa kluuy tu yu ngol nii sob kik lidzy xaa, xixkwaalew. Siko kol kuuñlo nii tyaaw xtsee no. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lëë xpëëdscuel xaa si. Tsiñee lëë xaa ptsiñ leñ kyedzy, lëë xaa kon xaa go sinak nii chëëbpee Jesús, aan lëë xaa bislo beeñlo xaa nii kaw xtsee xaa paskw. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tsiñee lëë lyu pkyey lëë Jesús ptsiñ leñ yu go ksa xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lëë xaa nche sob lo mezh kayaw xaa, tsiñee lëë Jesús chëb: —Xyeñpaa nii misme tu do jko naa ña xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tsigo mban ptee styoo ksa xpëëdscuel Jesús aan lëë xaa bislo tuga xaa xñabtiits xñee xaa: —¿Pe lëdy naaw? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tsigo lëë Jesús kwëb chëb: —Tu xaa nii no lady ksa tsiipchop tow. Lëë xaa noyaw leñ tu kyonaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naa nii nakaa mguiy nii pxaal Dios, lëë meñ kuty naa ni lëën teedy kaa kchë nii no teedyaa sinak nii këpeew leñ kitsy nii kë xtiits Dios. Per ¡brob xaa nii jko naa ña xaa xñabey! Masy buen nyi xaa nyaldy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aan mentre lëë xaa ncheyaw, lëë Jesús kwseñ kyaxtily, aan loxsye pteedy xaa skizh lo Dios, lëëw beeñ grol xaa aan lëëw pteedy xaa lo xpëëdscuel xaa chëb xaa: —Kol kawo, xcuerpno. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ni lëë xaa kwseñ tu vas nii no viñ, aan loxsye ptee xaa skizh lo Dios, lëëw ptee xaa kow xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tsigo lëë xaa chëb: —Tu cheñaa nrii kow do. Lëëw kxee parñee kak nyoo nii xkëstyoon lëë do ni xkëstyoon kchësy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nli xñen lo do nii kidraa viñ axte ktsiñ tse nii kin viñ kub kpaa laañee sob Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Loxsye biily xaa lëë xaa si kiy nii lë Olivos. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Siko lëë Jesús chëb: —Kchësy to ksaan naa. Sinrii xñee leñ kitsy nii kë xtiits Dios: “Lëën kuty meñ nii xkyënap mëkwxiily, aan lëë ma kchoots klyaal.” ");
INSERT INTO ztqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per tsiñee lëën kpañ, kloon ka Galilea lo do. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tsigo lëë Pedre chëb: —Nikxe kchësy xcombañeraa ksaan lii, per naa ksandyaa lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Per lëë Jesús kwëb chëb: —Nli xñen lool nii na kyool kazh, antes nii jkwetsy nguidy kol chop vuelt, lëël këb nii xyuumbeydyoo naa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per lëë Pedre tugak kwnee: —Nikxe ketynin lii, këbtyaa nii xyuumbeydyaa lii. Aan ksa xpëëdscuel xaa kwnee singo. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Loxsye ngo lëë xaa ptsiñ tu laañee lë Getsemaní, aan lëë Jesús chëb lo xpëëdscuel: —Kol sob nu mentre lëën kakutiitsni Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Lëë xaa sini Pedre, Jacob ni Juan, aan lëë xaa bislo pteenë xaa ni mban kok xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ni lëë xaa chëb: —Mban xtee kyalkuty styoon. Kol kwës nu dyon aan kol kwena. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tsigo lëë Jesús si par kaan xisy wiñ, lëë xaa kot ndooslo lo lyu, aan lëë xaa kwnab lo Dios nii xaatsye ntsiñdy kyalnë go, ");
INSERT INTO ztqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","xñee xaa: —Tat Tios, par lool kchësyo xchilo. Pteelaa naa lo kyalnë re. Per kuuñtsyeydyoo nii chakladzyaa, sink nii chakladzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsi lëë xaa bikche lëë ksa tson xpëëdscuel xaa nii kuni xaa nche nixyesy. Ngo nii lëë xaa chëb lo Pedre: —Simoñ, ¿nixyesyoo lë? ¿Pchilody nawen siquier xisy wiñ nsyob naal? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kol kaa na ni kol kutiitsni Dios parñee jkaaldy xaatox to. Ndaan no styoo do, per lëë lady to mban now. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lëë xaa si stub, aan lëë xaa bitiitsni Dios. Misme tiits nii kwnee gak xaa klo kwnee xaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tsiñee lëë xaa bikche, lëë xpëëdscuel xaa nche nixyesyak, porñee lika xtiib lo xaa lo mgaal. Aan nandy xaa pe këb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lëë xaa kwey stub. Lëëw byoon gaa vuelt. Lëë xaa chëb: —¿Pe bii nche nixyesy to nawen ni nche kxiladzy to? Lëëw na, lëë wor kutsiñ nii lëë mguiy nii pxaal Dios jkaa ña meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kol tsische, kol tsoo, por lëë xaa nii jko naa ña xaa xñabey sëëd kexle. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lëë Jesús bii nonee tsiñee lëë Judas, tu xaa nii wi kwyo lady xpëëdscuel xaa, ptsiñni tubtsoon meñ nii noy spad ni yag. Lëë meñ nii xñabey lo pxosy, ni maestre ley, ni meñ kol pxaal kchësy meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lëë Judas chëb kazh lo meñ go: —Xaa nii nagon kawaa tu pxit kwesy, xaa gow. Kol naasy xaa aan kol koy xaa. Klaady to xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Singo big xaa lo Jesús chëb xaa: —Maestre. Ptee gaa xaa tu pxit kwesy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsigo lëë meñ kwnaasy Jesús aan lëë meñ biy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per lëë tu xaa nii so siko kwlii xispad aan lëë xaa pchug tyag tu xmos xaa nii xñabey lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tsigo lëë Jesús kwnabtiits lo meñ chëb: —¿Penak nii sëëdnaasy to naa con spad ni con yag, sinak nawen nyakaa tu ngbaan? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ksatyee tse kwson lady to leñ lidzy Dios beeñ ksedyaa meñ, aan kwnaasty to naa. Per lëë kchësy nrii chak parñee teedyaa nii kë leñ xkitsy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tsigo so gak Jesús. Lëë xpëëdscuel xaa pxooñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per lëë tu xaa yeeñ sinal, mbixsye xaa tublë ladx, aan lëë meñ kokladzy nyaasy meñ xaa, ");
INSERT INTO ztqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","per lëë xaa blaa ladx ko aan lëë xaa pxooñ nëb kidy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsiñee lëë meñ ptsiñni Jesús lo xaa nii mastre non lo pxosy, lëë kchë xaa nii xñabey lo pxosy, ni xaa kol ni maestre ley ptyop. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ni nikxe gaa sit sit kunal Pedre, per lëë xaa ptsiñ axte lo xley xaa nii mastre non lo pxosy, aan lëë xaa kwsob xtsëë xaa chu ki ksa xaa xaa nii xkyënap lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lëë xaa nii xñabey lo pxosy ni kchë xaa non xyub dyon pe jkëëkiy xaa Jesús parñee kñab xaa kety Jesús. Per ptsyoldy xaa pe nguëëkiy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Porque nikxe ndaly meñ pkots tiits kizh xaa, per xaal xaal kwnee cad meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","No meñ kuso pkëëkiy xaa cos nii nlidy kwnee xaa, xñee meñ: ");
INSERT INTO ztqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ptsyon noo kwnee xaa nii lëë xaa knitylo lidzy Dios nii psaa meñ lo kislyu re aan tsonak kpidz me lëë xaa ksaalo stu nii ksaady meñ lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per ni tu meñ nii kwnee së lidy xtiits. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsigo lëë xaa nii mastre non lo pxosy kwso groltyee lady meñ aan lëë xaa kwnabtiits lo Jesús chëb xaa: —¿Penak nii xñeedyoo? ¿Pe nli kchë nii xkëëkiy meñ re lii? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per kwneedy Jesús. Tsesy kwso xaa. Ni tu pe chëbty xaa. Tsigo lëë xaa nii mastre non lo pxosy bikche kwnabtiits stub chëb: —¿Pe nli nii lii nak Crist, mguiy nii no kxaal Dios? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tsigo lëë Jesús chëb: —Nliw, naa nak mguiy nii pxaal Dios. Ni sanak to lëën sob kwi Dios nëzli, ni tsiñee lëën kchukë lo xkey kyelyaa lo kislyu re stub. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tsiñee lëë xaa nii mastre non lo pxosy biñ ngo, lëë xaa pchos xab xaa porñee singootyee blëë xaa aan lëë xaa chëb: —¿Pa jkiiñre gaa no meñ nii jkëëkiy xaa? ");
INSERT INTO ztqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Lëë do gon biñ xaatee ntseeb kchë tiits nii kwnee xaa. ¿Pe në do dyon xa kak xaa? Tsigo kchësy meñ chëb no nii kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wor go kazh lëë meñ bislo pchoo mxeñ xaa, ni lëë meñ ptse lo xaa, aan loxsye xtee meñ cheñ xaa, xñee meñ: —¡Kwnë dyon cho kwtiñ lii! Ni lëë xaa nii xkyënap leñ lidzy Dios byaasy lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lëë Pedre so lo ley tsiñee lëë tu kwnaa nii xkyë xtsiiñ xaa nii mastre non lo pxosy kwtedy. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aan tsi lëë me kon nii lëë Pedre no ktsëë chu ki, lëë me buy lo xaa aan lëë me chëb: —Wil lë kwënal Jesús meñ Nazaret. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tsigo lëë Pedre chëb: —Lëdyo, xyuumbeydyaa meñ go ni nandyaa pe cos xñeel. Aan lëë xaa pchoo ley laañee xsyëëb meñ. Tsigo lëë tu nguidy kol pkwetsy. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lëë kwnaa go buy lo Pedre stub aan lëë me bislo bitiits mew lo meñ xñee me: —Wi meñ gue nak ksa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per lëë xaa bikche gak chëb xaa lëdyo. Kok xtsedyako lëë meñ nii nche siko chëb lo Pedre stub: —Nli gaa na wil lë nak ksa Jesús, porque xaa Galilea nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tsigo lëë Pedre bislo xkon Dios xñee: —Xyuumbeydyaa xaa gue. Nandyaa cho xñee do. ");
INSERT INTO ztqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aan wor go kazh lëëw pchop vuelt nii lëë nguidy kol no jkwetsy, lëë Pedre gaa psaladzy nii chëb Jesús lo xaa: “Antes nii jkwetsy nguidy kol chop vuelt, lëël këb nii xyuumbeydyoo naa tson vuelt.” Ngo nii lëë xaa bislo biiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsiñee lëë lyu byaani lëë xaa nii xñabey lo pxosy, ni xaa kol, ni maestre ley ni kchësy xaa non ptyop. Lëë xaa pxituu Jesús aan lëë xaa kuni xaa lo Pilat. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lëë Pilat kwnabtiits lo Jesús chëb: —¿Pe lii nak xrey meñ Israel? —Lii në nii naaw —chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ndaly nii pkëëkiy xaa nii xñabey lo pxosy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Lëë Pilat bikche kwnabtiits lo xaa chëb: —¿Penak nii xñeedyoo? Buy gaanoo blaktre nii xkëëkiy kchë xaa gue lii. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per ni tu pe kwneedy Jesús. Tsi kon Pilat ngo, ntseeb psee styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mer lni xlaa Pilat tu xaa nii no skiib, tu xaa nii kñab meñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lëëtyee leñ tse go lëë tu xaa nii lë Barrabás no skiib ksa stubla xaa ntseeb porñee kukyeety xaa meñ worñee ptilyni xaa xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lëë meñ kunab lo Pilat nii klaa xaa tu xaa nii no skiib sinak nii chuuñtsyey xaa cad iz. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tsigo lëë Pilat kwëb chëb: —¿Pe chakladzy to nii klaan xrey meñ Israel? ");
INSERT INTO ztqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Porñee byeñ xaa nii por kyalmbidy kwnaasy xaa nii xñabey lo pxosy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per lëë xaa nii xñabey lo pxosy pkiily meñ parñee kñab meñ laa Barrabás. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Lëë Pilat kwnabtiits chëb: —¿Xa kuñaa xaa nii xñee do xrey meñ Israel tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsigo kchësy meñ kwchuptsyë xñee: —¡Pkëë xaa lo crusy! ");
INSERT INTO ztqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tsigo lëë Pilat chëb: —¿Per pe cos nak xtol xaa? Per lëë meñ bikche kwchuptsyë stub xñee: —¡Pkëë xaa lo crusy! ");
INSERT INTO ztqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsigo lëë Pilat, como kokladzy xaa nyaan buen xaa lo meñ, lëë xaa blaa Barrabás. Aan loxsye kwnabey xaa ptee meñ cheñ Jesús, lëë xaa kwloo xaa ña meñ nii jkëë xaa lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lëë bla soldad kuni Jesús chu yulyey aan siko lëë kchë soldad ptyop. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lëë xaa pkakw Jesús tu ladx nixñë yë ni lëë xaa psoob tu coron kitsy kik xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Loxsye ngo lëë xaa bislo kwchuptsyë xaa xñee xaa: —¡Byinayk xrey meñ Israel! ");
INSERT INTO ztqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ni pxob soldad yag kik Jesús, ni pchoo mxeñ soldad xaa, ni psoxib xaa lo Jesús sinak nii xsoxib meñ lo tu xaa non. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Loxsye kwtsityni xaa Jesús, lëë xaa kwlii ladx nixñë yë go lady xaa aan lëë xaa pkakw xaa mer xab xaa. Tsigo lëë xaa sini xaa par jkëë xaa xaa lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lëë tu xaa kyedzy Cirene nii lë Simoñ bikche tañ. Alejandro ni Rufo nak xiñ xaa. Aan tsiñee lëë xaa kwtedy kexka laañee nche meñ, lëë soldad pkoy xoo xaa xicrusy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lëë xaa kuni Jesús tu laañee lë Gólgota. (Lëë tiits ko nak sinak nii xñee ñe: Laañee no tsit kik meñ kuty.) ");
INSERT INTO ztqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Siko lëë xaa pteedy viñ nii nots tub clasy kizh nii lë mirra lo Jesús, per kowdy Jesúso. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Loxsye ngo lëë xaa pkëë xaa lo crusy. Ni lëë soldad kwloo xab Jesús rif parñee dyon pe cos kchal catu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve nak sily nii pkëë xaa Jesús lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pkëë xaa blalan tiits kik xicrusy Jesús laañee xñee penak kë xaa lo crusy, xñeew sinrii: “Xrey meñ Israel.” ");
INSERT INTO ztqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wi chop ngbaan kwë ksa xaa lo crusy, tu xaa nëzli, stu xaa nëzpeg. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pkab Jesús lady meñ mal sinak nii këpeew leñ kitsy nii kë xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kchësy meñ nii xtyedy laañee kë Jesús lo crusy xkotsyetsy ni xtsiiy kik xñee: —¿Pe chanlo na?, lii nii xchonoo lidzy Dios aan tsonak kpidz lëëw tse xsoblil stub. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pteelaa lii ni byety lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Singo gak kwtsityni xaa nii xñabey lo pxosy xaa ni maestre ley xñee xaa: —Pteelaa xaa stu meñ, per chilody kteelaa xaa lëë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","No nii kyety xaly Crist ke lo crusy nina kazh parñee kniladzy no nii nli lëë xaa nak xrey meñ Israel. Aan axte wi chop ngbaan nii kwë kwi xaa lo crusy kwlootsyetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tsiñee lëë xwe ngbidz kol lëë kislyu pkyey aan lëëw byaani axte las tres wor wtse. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aan misme wor go lëë Jesús kwchuptsyë xñee xaa: —Eloi, Eloi, ¿lema sabactani? (Tiits ko nak sinak nii xñee ñe: Tat Tios, Tat Tios, ¿penak nii psaanoo naa?) ");
INSERT INTO ztqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lëë bla xaa nii nche siko biñ nii kwnee Jesús aan lëë xaa chëb: —Kol kon gaa, profet Elías xkwetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tsigo lëë tu xaa nii so siko lëënlëdy kujkadz tublë sponj lo viñ la. Lëëw psoob xaa lo tublë punt yag aan lëëw ptsig xaa lo Jesús parñee nyi Jesúso, xñee xaa: —Kol ksaan xaa dyon pe siid klity Elías xaa lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per lëë Jesús kwchuptsyë nguiedzy aan lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ni lëë ladx nii kë leñ lidzy Dios pchos nsoli. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tsiñee lëë xaa nii xñabey lo kchë soldad nii nche siko kon xa kuty Jesús, lëë xaa chëb: —Nli nii Xiñ Dios nak mguiy re. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wi bla kwnaa nche sit xuy. Lady kchë kwnaa go no María Magdalena, ni Salomé, ni Mariy. Xiñ Mariy nak Jacob xaa nii nak xaa nyab ni José. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lëë ksa kwnaa re beeñ xyudar Jesús worñee kwyo xaa nëz Galilea. Ni ndaly re kchë kwnaa nii ptsiñ Jerusalén ksa Jesús nche siko. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsiñee lëë tse go ptsye lëë meñ no wxixkwaa par tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Lëë José xaa kyedzy Arimatea kwloo valor lo aan lëë xaa kunab xcuerp Jesús lo Pilat. Wi xaa nak tu xaa non Israel, ni wi gaa xaa këmbës nii lëë Dios kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ntseeb psee Pilat biñ xaa nii lëë Jesús tse lox kuty. Lëë xaa kwtsyetsy xaa nii xñabey lo soldad parñee kñabtiits xaa dyon pe nliw. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tsiñee lëë xaa nii xñabey lo soldad chëb nii nliw, lëë Pilat ptee tiitspey tsiklity José xcuerp Jesús lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tsigo lëë José kusi tublë ladx rusy, lëë xaa blity xcuerp Jesús lo crusy aan lëëw pchal xaa ladx ko. Loxsye ngo lëë xaa kujkeetsy Jesús leñ tu paa nii ndeeñ lo kyo. Ptse gaa xaa chu paa con tu kyo. ");
INSERT INTO ztqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aan lëë María Magdalena ni Mariy xñaa José kon pa pkyeetsy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tsiñee lëë tse nii chak wxiladzy kwtedy, lëë María Magdalena, ni Mariy xñaa Jacob, ni Salomé kwxii aceit nii xlyaa nex par tsilo mew lady Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lëë byaani lyu silyga, xlyañ lik ngbidz, lëë me tse ptsiñ chu paa. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Xñeesy me lo xcombañer me: —¿Cho lë nii kob kyo nii xoob chu paa na? ");
INSERT INTO ztqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per tsi lëë me buy, kon me nii xoobtre kyo nii ntse chu paa xlugaro. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tsiñee lëë me kwsëëb leñ paa, lëë me kon tu xaa xab rusy nii sob nëzli, aan lëë me ptsyeb ksa me. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per lëë xaa xab rusy ko chëb lo me: —Ktsyebty to. Nanaa nii lëë do xyub Jesús Nazaret, xaa nii kwë lo crusy. Per lëë xaa pañ, kindy xaa. Kol kuy gaanoo nu pxoob xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kol kyey aan kol këb lo xpëëdscuel me, per yuub lo Pedre kol këb nii lëë Jesús tse si Galilea. Siko lëë xpëëdscuel me kan me sinak nii chëëbpee me. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tsigo lëë kwnaa go bi wxooñ chu paa xisy me lo tseb. Aan ni tu pe chëbty me, porñee tir ptsyeb me. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Loxsye pañ Jesús tse tminkw sily, lëë xaa byaklo klo lo María Magdalena. Leñ styoo kwnaa go kwlii xaa kadzy kyalbini mal penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lëë me kuni tiits lo kchë meñ nii kwënal Jesús. Mbansye ncheyoon kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tsiñee lëë meñ go biñ nii lëë Jesús mbañ, ni biñ meñ go nii lëë Mariy kon xaa, bnilasty meñ gow. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Loxsye ngo lëë Jesús byaklo lo stu mod lo chop xpëëdscuel xaa nii no nëz si tañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lëë chop xaa go kukni tiits lo stubla xpëëdscuel xaa, per bnilastyak xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Loxsye ngo lëë Jesús byaklo lo ksa tsiiptub xpëëdscuel. Lëëtyee lëë xpëëdscuel xaa nche sob lo mezh kayaw. Kwëntseeb Jesús lo xaa porñee singootyee nguiedzy styoo xaa ni porñee bnilasty xaa xtiits meñ nii chëb nii lëë Jesús pañ. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni chëb xaa: —Kol tsi tyub lo kislyu aan kol kluuy xtiits Dios nii xteelaa kchësy lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kchë meñ nii kniladzy xtiits Dios ni chobnis telaa lo xtol, per lëë meñ nii knilasty xtiits Dios, lëë meñ go nitylo lo xtol. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kyalntson re kuuñtsyey meñ nii xniladzy xtiits Dios: Con xtitsaa kwii meñ kyalbini mal ni kñee meñ stu tiits kub, ");
INSERT INTO ztqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ni nikxe gaa señ meñ go mëël ni ki meñ go ngwaan, pe kakty meñ go. Ni tsi lëë meñ go kxob ña lady meñ xsyaknë, lëë meñ xsyaknë kyak. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Loxsye kwnee Jesús lëë xaa byëp kpaa aan lëë xaa kwsob kwi Dios nëzli par kñabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tsigo lëë xpëëdscuel xaa pchoo xluuy xaa xtiits Dios laañee xtsiiñtyee xaa. Lëë Jesús beeñ xaa yudar. Ptee Jesús tiitspey beeñtsyey xaa kyalntson parñee kak nyoo nii nli xtiits Dios xluuy xaa.");
INSERT INTO ztqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Tyux Teófilo. Lëën xal kitsy re lool nii nakoo tu xaa non parñee ksocueentaa kchë nii kal kwtedy. Ndaly xaa nojkëë kchë nii beeñtsyey Jesucrist. Lëë meñ nii kono ni xluuyo chutiits xa nako. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lëë na win byub xa nak kchë cos ko destye worñee bislow, aan kwxaakaa nii precisy kso xnëëz noo parñee kxalno lool ");
INSERT INTO ztqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","parñee kaknan nyëël xa nak kchë nii no kluuy meñ lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lëë Herodes nak rey xtañ meñ Judea tiemp nii kwyo tu pxosy nii pcholë Zacarías. Lady tub tiiy pxosy nii pcholë Abías kwyo Zacarías. Sabely pcholë tsiil xaa, lo xtiiy Aarón sëëd me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Psoob Zacarías xtiits Dios chop tsiil. Por ngo ni tu cho pchilody nlis kiy pe cos lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per lëë xaa kol le chop xaa aan pchilody nyap tsiil xaa mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lëë tu tse lëë xtiiy Zacarías pchal sëëb leñ lidzy Dios, ");
INSERT INTO ztqNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","aan nak xcostumbre pxosy nii klo xko xaa rif parñee kan xaa dyon cho sëëb lo pkoog, aan lëëtyee Zacarías pchal sëëb lo pkoog tsiko kox yaal lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kchë meñ kwche ley chool lay mentre lëë yaal noyek. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aan lëë tu xangly Dios byaklo lo Zacarías lo pkoog. Nëzli laañee noyek yaal byaklo angly. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tsiñee lëë Zacarías kon angly, byeñdy xaa pe nyuñ xaa aan tir ptsyeb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Per lëë angly chëb: —Zacarías, ktsyeebtyoo, por lëë Dios biñ nii xñaboo, aan lëë tsiiloo Sabely kap tu mëëd nii kcholë Juan. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aan lëël kle ni ndaly gaa meñ kle tsi lëë mëëd ko kaly. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Por tu xaa non kak xiñoo lo Dios. Kidy xaa viñ ni kidy xaa cos nii chuuñ ksudzy, ni lëë Kyalbini Ntson sëëb leñ styoo xaa antes nii kaly xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Lëë xaa ktikche styoo meñ Israel lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Lëë xiñoo Juan tenech lo Dios, ni siñee kwyo kyalbini leñ styoo Elías, tsow leñ styoo xaa, ni sinak nii kwnabey Elías kñabey xaa, parñee kisyaal xaa xtily meñ nii xtilyni xiñ, ni parñee ksoob meñ ntseeb tiits. Singo mod lëë xaa kluuy xa kyëmbës meñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tsigo lëë Zacarías kwnabtiits lo angly chëb: —¿Xa mod kniladzyaa nii sak nrii cumplir? Por kwyoxaa ni kwyox tsiilaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tsigo lëë angly kwëb chëb: —Naa nak Gabriel. Lo Dios tugak son, aan lëë xaa pxaal naa syelynin tiits re lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per lëë na como bnilastyoo tiits nii byelynin, lëël kyaan ngop, aan chilody kñeel axte tse lëë kchë nrii kak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mentre lëë kchë ngo kayak leñ lidzy Dios, lëë kchë meñ nii nche ley xñee penak nii no klyëë Zacarías lo pkoog. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tsiñee lëë xaa pchoo, pchilody nyee xaa, aan axte tsigolye lëë meñ byeñ nii no pe cos kon xaa lo pkoog, xaktyee señ xko xaa aan singo byaan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsi lëë nii no kuuñtsyey Zacarías leñ lidzy Dios byal, lëë xaa sey lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Loxsye ngo lëë tsiil xaa kok xiñ, aan kaay mëë pchoody me lidzy me porñee nladzy me: ");
INSERT INTO ztqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Lëë Dios bnee kyalnsaak re lon parñee ktelastraa tsiñee kan meñaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tsiñee kok xoop mëë nii nak xiñ Sabely, lëë Dios pxaal angly Gabriel tu kyedzy nii lë Nazaret. Galilea ngab kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Leñ kyedzy ko kwyo tu kwnaa yeeñ nii pcholë Mariy, aan lëë me pchootiñle par ktsiilña me tu xaa nii lë José. Lo xtiiy David sëëd José. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lëë angly kwsëëb leñ lidzy me aan lëë angly pkëëptyux me chëb: —¡Xle Dios lool ni lëë Dios nakni lii! ");
INSERT INTO ztqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsiñee lëë me kon angly, ptsyeb me biñ me xtiits angly, aan nladzy me penak nii pkëëptyux angly me singo. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Per lëë angly chëb: —Mariy, ktsyeebtyoo, por xle Dios lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lëël kak xiñ aan lëël kap tu mëëd nii kcholë Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tu meñ xñabey kak mëëd ko aan Xiñ Dios nii sob kpaa kolë meñ me, ni lëë Dios kaa kso me kak me rey sinak pxusykoltoo me David, ");
INSERT INTO ztqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","parñee kñabey me lo meñ Israel aan iip kyaldy xkyalwnabey me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsigo lëë Mariy chëb lo angly: —¿Xa kaapaa mëëd con bii tusyaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lëë angly chëb: —Lëë Kyalbini Ntson kiid lool, ni lëë xkyalntson Dios nii sob kpaa kyab ladyoo sinak nii nyako tu xkey. Por ngo Xiñ Dios kak mëëd nii kaly. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ni wi gaa meñ liidzyoo Sabely kap tu mëëd, nikxe nii meñ kol me ni xñee meñ nii chilody kap mëëd. Per lëëw kok xoop mëë nii noy xiñ me, ");
INSERT INTO ztqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","por par Dios nody tu cos nii kchilody kak. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsigo lëë Mariy chëb: —Ña Dios non. Na kuuñtsyeyaa nii kaklastyee Dios. Loxsye ngo lëë angly bi. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Leñ tse go lëënlëdy lëë Mariy si tu kyedzy nii nche nëz kiy Judea. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aan tsiñee lëë me ptsiñ lidzy Zacarías, lëë me pkëëptyux Sabely. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tsi lëë Sabely biñ nii lëë Mariy xkëëptyux, lëë mëëd nii so noy me bni leñ styoo me, aan wor go kazh lëë Kyalbini Ntson kwsëëb leñ styoo me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tsigo nguiedzy kwnee me chëb me: —Ni tu kwnaa karty kuuñlay Dios sinak beeñlay Dioosoo, ni sinak beeñlay Dios xiñoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cho nakaa parñee kiid kan xñaa Xiñ Dios naa? ");
INSERT INTO ztqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Por siikñee biñaa nii lëël xkëëptyux, lëë xiñaa ble aan lëë me bni leñ styoon. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dichoosoo nii bniladzyoo nii sak cumplir kchë nii në Dios lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsigo lëë Mariy chëb: Tyub styoon xlen lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ni xle xkyalmbañaa lo Dios nii pteelaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Por lëë Dios psooblo naa nii nakaa tu kwnaa ndoladzy, aan destye natse lëë meñ kñë lon dichoosoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Por ndaly kyalnsaak nii no kneetsy Tat Tios lon. Ntson Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ni tugak kaa xkëstyoo Dios meñ nii xsoob xtiits me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Con xkyalwnabey Dios bnitylo me kchë nii nyuuñtsyey meñ nyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Lëë me kwlii kchë meñ xñabey, ni lëë me blisklaa kchë meñ ndoladzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Lëë me ptee nii pkiiñ lo meñ nii no lyaadzy, aan psonëz me meñ rikw singosy. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Beeñ me meñ Israel nii ngab lo me yudar, ni psaanlasty me meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Por singo byaan me tiits chop me pxusykoltoo no Abraham ni xtiiy Abraham nii nare kiid. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tson mëë kwlës Mariy lo Sabely. Loxsye ngo lëë me sey lidzy me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsi lëë tse kutsiñ nii lëë xiñ Sabely kaly, lëë me kop tu mëëdpkiy. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aan kchësy meñ nii no kex chilidzy me ni meñ lidzy me kutedy lo me porñee xle meñ nii lëë Dios psaladzy me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lëë kwloxo xon kpidz, lëë me kuni mëëd tsobey mëëd, aan kokladzy meñ nii ncholë mëëd Zacarías sinak lë pxosy mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per lëë xñaa mëëd chëb: —Juan no nii kcholë mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tsigo lëë meñ chëb: —Per ni tu meñ liidzyoo lëdy singo. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lëë meñ kwnabtiits lo pxosy mëëd con señ, parñee këb xaa dyon xa kcholë mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Lëë pxosy mëëd kwnab tublë table aan lëë xaa pkëë lo table ko: “Juan kcholë mëëd.” Aan kchësy meñ psee. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ni wor go kaazhkaa lëë Zacarías pchilo kwnee stub, aan lëë xaa bislo pteedy xaa skizh lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kchësy meñ nii no kex chilidzy xaa ptsyeb, ni kchë kyedzy nii nche nëz kiy Judea pso cuent meñ nii kok. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aan kchësy meñ nii biñ ngo xñee: —¿Cho lë nii kak mëëd re tsi lëë me kroob? Por nyoo nii lëë Dios nakni me. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lëë Kyalbini Ntson kwsëëb leñ styoo Zacarías aan lëë xaa kwnee nii psyaab Dios styoo xaa, chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Skizh xDios meñ Israel, por lëë xaa sëëd kteelaa xkyedzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lo xtiiy David pchoo tu xaa ndaan nii pxaal xaa kteelaa lëë no. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Penaadle pxaal xaa tiits lo xiprofet xaa chëb xaa ");
INSERT INTO ztqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","nii lëë xaa kla lëë no lo xaa nii xtilyni lëë no ni lo kchë xaa nii chaklasty kan lëë no. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ni nyoo nii pkëstyoo xaa pxusykoltoo no. Por ngo beeñ xaa cumplir kchë tiits ntson nii kwnee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Lo pxusykoltoo no Abraham chëb xaa ");
INSERT INTO ztqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nii lëë xaa kla lëë no lo xaa nii xtilyni lëë no, parñee ktsyebty no ksoob no xtiits xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ni ksaan no xtol no ni kpañ no sinak xñabey xaa parñee kchilo kpig no lo xaa tyub nii kpañ no. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lëë lii, xiñ xiprofet Dios nii sob kpaa kakoo, por lii nech lo Dios parñee kwiil nëz nii tedy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ni parñee këëboo lo meñ Israel nii lëë Dios ktsily xtol meñ go, ni lëë xaa kteelaa meñ go lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Porñee tir buen xDios no, por ngo lëë xaa kxaal tu xaa nii klyañ kpaa sinak xlyañ ngbidz, ");
INSERT INTO ztqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","parñee ksaani xaa lo meñ nii ncheno lo nguey, ni kluuy xaa xa kpig no lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Lëë xaa wiñ go kwroob aan nonsyke xtiits Dios kuni kik xaa, ni tañ gaa kwyo xaa axte tse nii lëë xaa kwnee lo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Leñ tse go lëë xtisy Roma nii pcholë César Augusto kwnabey ktyop lë meñ nii no kchë kyedzy nii ngab lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lëë Cirenio xñabey xtañ meñ Siria worñee kwyaa cens re. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aan no nii kchësy meñ kyey xkyedzy parñee mer xkyedzy meñ jkab meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Por ngo lëë José pchoo kyedzy Nazaret nii ngab Galilea par tsi xaa tu kyedzy nii lë Belén nii ngab Judea. Kyedzy ko koly rey David ni lo xtiiy gaa rey David sëëd José. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lëë xaa kwey kyedzy ko parñee siko jkab xaa chop xaa Mariy, por lëë xaa merle ktsiilña me ni lëë gaa me nak xiñle. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aan lëëtyee Belén nche xaa tsiñee lëë tse kutsiñ nii lëë xiñ Mariy kaly. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Siko koly xiñ klo Mariy, aan loxsye pchal me mëëd ladx, lëë me kwtiix mëëd laañee xkyëtuu ma, porñee ptsyoldy me posad. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kexka chu kyedzy Belén ptseñ bla xaa nii nche nap xpëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aan kolpsye lëë tu xangly Dios ptsiñ lo xaa ni lëë xbini Dios bibëly lo xaa aan tir ptsyeb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Per lëë angly chëb: —Ktsyebty to, por tiits nii kuuñ kle styoo do ni styoo kchësy meñ syelynin. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lëë xaa nii këmbës to kiid kteelaa lëë do koly leñ xkyedzy David natse. Lëë xaa nak Crist nii xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tsiñee kan do tu mëëd yeeñ nii nchal ladx nix laañee xkyëtuu ma, lëë do kyeñ nii nli tiits nii niyaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aan misme wor go lëë tub yox angly byety kpaa par ktee angly skizh lo Dios xñee angly: ");
INSERT INTO ztqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Skizh Dios nii sob kpaa! ¡Xtee xaa xkyalnsaak xaa lo kchë meñ nii xleni xaa lo kislyu! ");
INSERT INTO ztqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Loxsye byëp angly kpaa, lëë xaa nii xkyënap mëkwxiily chëb lo xcombañer: —Kol tsoo leñ kyedzy Belén tsiin tyon noo nii biidnë Dios lo no. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lëënlëdy lëë xaa si aan tsiñee ptsiñ xaa, lëë xaa kon Mariy ni José ni lëë xaa kon mëëd yeeñ nii nix laañee xkyëtuu ma. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lëë xaa bitiits nii lëë angly kukëb lo xaa cho nak mëëd nii koly. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aan kchësy meñ psee biñ nii bitiits xaa nii xkyënap mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per lëë Mariy iip bnitylasty Mariy kchë ngo, tugak kwyow styoo me. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lëë xaa nii xkyënap mëkwxiily bi aan lëë xaa ptee skizh lo Dios porñee kon xaa ni biñ xaa kchë nii chëb angly lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tse nii ptsiil mëëd xmal, lëë mëëd kwyobey, aan lëë mëëd pcholë Jesús, por destye worñee karty kak xiñ Mariy, lëë angly chëb xa kcholë mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tsiñee lëë Mariy kwte lo kyalsyañ sinak xñabey xley Moisés, lëë me kwey Jerusalén par tsini me Jesús leñ lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Por leñ kitsy nii kë xley Dios xñee nii kchësy mëëdpkiy klo jkab lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lëë me kuksakon nii xñabey xley Dios. Lëë ley xñee nii schilo kokon meñ chop ngog o chop kaa palom lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tiemp ko kwyo tu xaa nii pcholë Simeón leñ kyedzy Jerusalén. Buen xaa ni psoob xaa xtiits Dios ni kwëmbës kaa xaa nii lëë Dios kteelaa meñ Israel. Kokni Kyalbini Ntson xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lëë Kyalbini Ntson chëb nii kejty xaa deelñee kandy xaa kiid Crist. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lëë Kyalbini Ntson pxaal Simeón lidzy Dios, aan tsiñee lëë José ni Mariy ptsiñni Jesús par kuuñtsyey xaa nii xñabey ley, ");
INSERT INTO ztqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","lëë Simeón kwteetsy Jesús aan lëë xaa ptee skizh lo Dios chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Blaa na, Tat Tios, ketyaa, por lëën kon nii lëël beeñ cumplir xtiitsoo, ");
INSERT INTO ztqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ni lëën kon gaa xaa nii kteelaa meñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ni kchësy kaa meñ nii nche lo kislyu kan nii lëë xaa pxaaloo. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lëë xaa ksaani lo meñ sit, ni lëë xaa ksoli meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Lëë pxosy Jesús ni lëë xñaa Jesús psee biñ kchë nii kwnee Simeón. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aan loxsye beeñlay Simeón xaa, lëë Simeón chëb lo Mariy, xñaa Jesús: —Tsiñee lëë mëëd re kñee lo meñ Israel no meñ kpig lo Dios, no gaa meñ ksaan Dios, ni ndaly meñ klëë lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Singo mod lëë kchë nii xsya styoo meñ kak nyoo. Kchë ngo ktsiñ leñ styool sinak nii nyak tu cuchiy nii kchug xkyalmbañoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Kwyo tu kwnaa nii kwnee xtiits Dios. Ñan pcholë me. Xiñ Fanuel nii sëëd lo xtiiy Aser kok me. Tap kaly ptsiiptap iz chap me. Ptsiilña me, per xaktyee kadzy iz pañ tsiil me, aan destye nii kuty tsiil me, ksatyee tse chi me lidzy Dios par kutiitsni me Dios ni no tse chawdy me par kuuñ ksak me Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lëë Ñan ptsiñ mer worñee lëë Simeón nonee aan lëë me pteedy skizh lo Dios ni lëë me chëb lo meñ nii lëë mëëd ko kteelaa meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Loxsye beeñtsyey pxosy Jesús nii xñabey xley Dios, lëë xaa sey par xkyedzy xaa. Nazaret nii ngab Galilea nak xkyedzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aan siko kwroob Jesús ni siko ptee Dios kyalchak lo xaa ni lëë Dios kokni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ksatyee iz chi pxosy Jesús paskw Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Por ngo, worñee lëë Jesús kop tsiipchop iz, lëë xaa kwey ksa xaa, por singo nak xcostumbre meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tsiñee lëë lni kwtedy, lëë Mariy ni lëë José bi aan byeñdy xaa nii lëë Jesús byaan Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nladzy xaa tse sey Jesús lady meñ. Tu kpidz nder kwsë xaa, per tsiñee konsye xaa nii seydy Jesús lady meñ nii xyuumbey xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","lëë xaa bikche sey xaa Jerusalén sikyub xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Axte kwloxo tson kpidz, lëë xaa ptsil Jesús leñ lidzy Dios. Lëë Jesús noyutiitsni maestre. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aan kchësy meñ psee biñ kchë nii kwnee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tsiñee lëë Jesús ptsil, psee pxosy xaa, aan lëë xñaa xaa chëb: —Xiñ, ¿penak nii psaksil lëë noo? Mban pkyëkyuub noo lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tsigo lëë Jesús chëb: —¿Penak kwëkyub to naa? ¿Pe nandy to nii mastre precisy kyën tsiiñ leñ lidzy Dios? ");
INSERT INTO ztqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per byeñdy pxosy Jesús penak kwnee xaa singo. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lëë xaa sey Nazaret ksa xaa, ni lëë Jesús kaa psoob xtiits pxosy, aan bnitylasty xñaa xaa kchë ngo. Tugak kwyow styoo me. ");
INSERT INTO ztqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Siko kwroob Jesús ni siko kwyo xkyalcheñ xaa aan ble Dios ni ble meñ lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tsiiñle iz kok nii nak Tiberio xtisy Roma worñee lëë xiñ Zacarías nii pcholë Juan bislo xluuy xtiits Dios. Lëë Poncio Pilato xñabey xtañ meñ Judea tiemp ko. Lëë Herodes xñabey Galilea, lëë betsy Herodes nii lë Felip xñabey Iturea ni Traconite, lëë Lisanias xñabey xtañ meñ Abilinia, ni lëë Anás ni Caifás nak pxosy nii mastre non. Tiemp ko lëë Dios kwnee lo Juan tañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aan lëë Juan kukëb lo kchë meñ nii no kexka chu kiigwpee Jordán nii no nii ktikche meñ styoo lo Dios ni chobnis meñ, parñee ktsily Dios xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lëë Juan nak xaa nii xseety profet Isaías worñee pkëë xaa leñ xlibre xaa: Son meñ tsiy xaa tsiñee lëë xaa kñee lo meñ tañ, këb xaa: “Kol kxixkwaa nëz nii tedy xaa nii xñabey. Kol kwii tu nëz tubli. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kchësy laañee kë yoo kyaktsë, ni kchësy laañee sob kiy kyak tubli, kchësy nëz nii xtee vuelt kchooli, ni kchë kyeech nii no lo nëz kyaktsë. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ni kchësy meñ kan kiid xaa nii kteelaa meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tsiñee lëë meñ xtsiñ par kchoobnis Juan meñ, lëë xaa xñee lo meñ: —¡Nak to sinak mëël! ¿Cho në nii lëë do telaa lo kyalntseeb nii kxaal Dios? ");
INSERT INTO ztqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kol kpañ sinak xñabey Dios parñee kak nyoo nii nli lëë do ptikche styoo do lo Dios. Kak nyaady to nii Abraham nak pxosy to. Por nli xñen schilo kuñ Dios kyo re xiñ Abraham. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ni lëë kiib yag kaa tse so mbës parñee chug silu yag nii xkyëdy nex, aan lëëw tso lo ki. Singo ktsyool meñ nii xtikchedy styoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tsigo lëë meñ chëb: —Kwnë pe cos kuuñtsyeey noo. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Lëë Juan chëb: —Deelñee chap to chop nëz ladx, kol ktee tub nëzo lo meñ nii kindy xab. Ni deelñee chap to nii ktyaaw, kol ktee nii kaw meñ nii kindy pe kaw. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wi bla xaa nii xtop tumi nii xyey Roma big chobnis, aan lëë xaa chëb lo Juan: —Maestre, lëë nook, ¿pe cos kuuñtsyeey noo? ");
INSERT INTO ztqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lëë Juan chëb: —Kol nab tumi nii nonguial kñab to. Ksaksidy to meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wi bla soldad kwnabtiits lo Juan chëb: —Aan lëë nook, ¿pe cos kuuñtsyeey noo? Lëë Juan chëb: —Klady to xcheñ meñ, ni ktsebty to meñ, ni jkëëkiydy to meñ deelñee karty pe kuñ meñ. Kol tso conforme nii chazh to. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kchësy meñ psee biñ nii kwnee Juan, aan nladzy meñ neñdy lëë Juan nak Crist nii no kxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Per lëë Juan chëb lo meñ: —Nli naa xchoobnis lëë do con nis, per lëë xaa nii kiid tsiñee lëën kpi kchoobnis meñ nii kniladzy xtiits Dios con Kyalbini Ntson, ni lëë xaa ksaksi meñ nii knilasty con ki. Por mastre non xaa lon, ni parñee sinchuñaa kxakaa tuukidy lab xaa xkiiñdyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","No xpal xaa ña xaa par kuñ nyë xaa xobxtily ni kwii xaa tixob tublad. Lëë xaa kotsey xobxtily leñ ngoch, per lëë xaa ksaay tixob lo tu ki nii kyuuydy. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndaly mod kwnee Juan lo meñ worñee bluuy xaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Axte lo rey Herodes kwëntseeb Juan, chëb xaa: “Nody nii tsonil Herodías, por tsiil betsyoo Felip nak me.” Ni lëdy kaa por ngosy kwëntseeb xaa lo Herodes, sink wi por kchë cos mal nii beeñtsyey Herodeso. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Per psaandy Herodes xtol, sink lëëw beeñ ktyalyre xaa worñee lëë xaa kwloo Juan skiib. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wi Jesús kwchobnis worñee no kchoobnis Juan kchësy meñ. Aan mentre noyutiitsni Jesús Dios, lëë kpaa byaly ");
INSERT INTO ztqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aan lëë xKyalbini Ntson Dios sëëd sëëb sinak tu palom byab lady xaa. Ni lëë xaa biñ tsiy tu xaa nii xñee: —Lii nak xiñaa. Xkëstyoon lii. Naa kwlel. ");
INSERT INTO ztqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kalyptsii iz Jesús worñee lëë xaa bislo xluuy xaa xtiits Dios. Nladzy meñ nii xiñ José kok Jesús. Lëë José nak xiñ Elí, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","lëë Elí nak xiñ Matat, lëë Matat nak xiñ Leví, lëë Leví nak xiñ Melqui, lëë Melqui nak xiñ Jana, lëë Jana nak xiñ José, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","lëë José nak xiñ Matatías, lëë Matatías nak xiñ Amós, lëë Amós nak xiñ Nahúm, lëë Nahúm nak xiñ Esli, lëë Esli nak xiñ Nagai, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","lëë Nagai nak xiñ Maat, lëë Maat nak xiñ Matatías, lëë Matatías nak xiñ Semei, lëë Semei nak xiñ Josec, lëë Josec nak xiñ Judá, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","lëë Judá nak xiñ Joanán, lëë Joanán nak xiñ Resa, lëë Resa nak xiñ Zorobabel, lëë Zorobabel nak xiñ Salatiel, lëë Salatiel nak xiñ Neri, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","lëë Neri nak xiñ Melqui, lëë Melqui nak xiñ Adi, lëë Adi nak xiñ Cosam, lëë Cosam nak xiñ Elmadam, lëë Elmadam nak xiñ Er, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","lëë Er nak xiñ Jesús, lëë Jesús nak xiñ Eliezer, lëë Eliezer nak xiñ Jorim, lëë Jorim nak xiñ Matat, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","lëë Matat nak xiñ Leví, lëë Leví nak xiñ Simeón, lëë Simeón nak xiñ Judá, lëë Judá nak xiñ José, lëë José nak xiñ Jonam, lëë Jonam nak xiñ Eliaquim, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","lëë Eliaquim nak xiñ Melea, lëë Melea nak xiñ Mena, lëë Mena nak xiñ Matata, lëë Matata nak xiñ Natán, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","lëë Natán nak xiñ David, lëë David nak xiñ Isaí, lëë Isaí nak xiñ Obed, lëë Obed nak xiñ Booz, lëë Booz nak xiñ Sala, lëë Sala nak xiñ Naasón, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","lëë Naasón nak xiñ Aminadab, lëë Aminadab nak xiñ Admin, lëë Admin nak xiñ Arni, lëë Arni nak xiñ Esrom, lëë Esrom nak xiñ Fares, lëë Fares nak xiñ Judá, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","lëë Judá nak xiñ Jacob, lëë Jacob nak xiñ Isaac, lëë Isaac nak xiñ Abraham, lëë Abraham nak xiñ Taré, lëë Taré nak xiñ Nacor, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","lëë Nacor nak xiñ Serug, lëë Serug nak xiñ Ragau, lëë Ragau nak xiñ Peleg, lëë Peleg nak xiñ Heber, lëë Heber nak xiñ Sala, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","lëë Sala nak xiñ Cainán, lëë Cainán nak xiñ Arfaxad, lëë Arfaxad nak xiñ Sem, lëë Sem nak xiñ Noé, lëë Noé nak xiñ Lamec, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lëë Lamec nak xiñ Matusalén, lëë Matusalén nak xiñ Enoc, lëë Enoc nak xiñ Jared, lëë Jared nak xiñ Mahalaleel, lëë Mahalaleel nak xiñ Cainán, ");
INSERT INTO ztqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","lëë Cainán nak xiñ Enós, lëë Enós nak xiñ Set, lëë Set nak xiñ Adán, aan lëë Adán nak xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Loxsye kwsëëb Kyalbini Ntson leñ styoo Jesús, lëë xaa bi chu kiigwpee Jordán, aan lëë Kyalbini kuni xaa tañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aan ksa choow kpidz nii kwyo xaa tañ go pkaal xaatox xaa. Ni tu pe tawdy xaa. Por ngo, tsiñee lëë xaa kwlaañ, ");
INSERT INTO ztqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","lëë xaatox chëb lo xaa: —Deelñee nli Xiñ Dios nakoo, kwnabey nii kyak kyo nii nche ske kyaxtily. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Per lëë Jesús chëb: —Leñ kitsy nii kë xtiits Dios xñee: “Lëdy nonsy kyaxtily kaw meñ parñee kpañ meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Loxsye ngo lëë xaatox kuni Jesús tu kik kiy aan ketyle bluuy xaa kchë kyedzy nii nche lo kislyu lo Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","aan lëë xaa chëb: —Snetsyaa kchë kyedzy ni cos non nii no lo kislyu lool, por lëë Dios bneetsyo lon aan lëëw ktedyaa lo xaa nii klyañ styoon. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Deelñee soxiboo lon, lëëw knetsyaa lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tsigo lëë Jesús chëb: —Leñ kitsy nii kë xtiits Dios xñee: “Psoxib lo Dios nii xñabey lii ni xtiits sye xaa psoob.” ");
INSERT INTO ztqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lëë xaatox kuni xaa leñ kyedzy Jerusalén, aan lëë xaatox blëp xaa kik lidzy Dios laañee mastre klaa, ni lëë xaatox chëb lo xaa: —Deelñee Xiñ Dios nakoo, kwyas nu, ");
INSERT INTO ztqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","por leñ xkitsy Dios xñee: “Lëë Dios kxaal xangly kakni lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lëë angly kñaasy lii con ña, parñee lasty kyo niyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tsigo lëë Jesús chëb: —Leñ xkitsyak Dios xñee: “Kuñdyoo Dios nii xñabey lii preb.” ");
INSERT INTO ztqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tsiñee konsye xaatox nii chilodre kuñ xaa Jesús preb, lëë xaa psaan Jesús tu tiemp. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","No Kyalbini Ntson leñ styoo Jesús, lëë xaa ptsiñ Galilea, aan tyub tañ go xseety meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kchë ktoo nii kwtedy xaa bluuy xaa xtiits Dios, ni kchë gaa meñ kwyo xfavor xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lëë Jesús kwey Nazaret. Kyedzy ko kwroob xaa. Aan lëë xaa kwey ktoo tse nii xiladzy meñ Israel, por wal nii singo nak xcostumbre xaa, ni lëë xaa kwsoli par klab xaa kitsy nii kë xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lëë xaa kwnaasy kitsy nii pkëë profet Isaías aan lëë xaa byub laañee xñee: ");
INSERT INTO ztqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Lëë xKyalbini Ntson Dios nakni naa, por lëë xaa kwle naa par kanin xtiits xaa lo meñ mban. Lëë xaa pxaal naa kaklaan xaa nii no skiib, ni kxalyaa lo meñ nii chandy, ni kchoobladzyaa styoo meñ nii no kyalnë. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ni lëën syely këp lo meñ nii lëë wor kutsiñ nii lëë Dios kteelaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Loxsye ptse Jesús libre, lëëw pko xaa ña xaa nii xkyë tsiiñ leñ ktoo aan lëë xaa kwsob. Kchë meñ nii nche siko buy lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsigo lëë xaa chëb lo meñ: —Misme natse lëë kchë nii blabaa lo do kok cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kchë meñ kwyo xfavor Jesús ni kchë meñ psee biñ kchë tiits ngui nii kwnee Jesús. Aan xñee meñ: —¿Pe lëdy lëë xiñ José ngue nayak? ");
INSERT INTO ztqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsigo lëë Jesús chëb: —Neñdy snë do tiits re lon: “Doctor, beeñ lii rmedy.” Ni snë do lon: “Kchësy nii ptsyon noo beeñtsyeyoo leñ kyedzy Capernaum, beeñtsyeyo xkyedzyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ni lëë gak xaa chëb: —Laañee xkaatyee xsal meñ tu profet, per deelñee meñ xkyedzy meñ nak profet, xsaldy meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nli xñen nii ndaly kwnaa viud kwyo Israel xtiemp profet Elías worñee byabty kyo tson iz grol, aan tyub tañ go kwyo kpiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per ni tu lo kwnaa viud nii no Israel pxaaldy Dios Elías, sink lëë xaa pxaal Dios lo tu kwnaa Sarepta nii ngab Sidón. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Singo gak xtiemp profet Eliseo ndaly xaa nii byodz lady kwyo Israel, per ni tu xaa byakty. Xaktyee tu xaa Siria nii pcholë Naamán byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tsiñee lëë kchësy meñ nii no leñ ktoo biñ ngo, per nli busy blëë meñ lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aan lëë meñ kwlii xaa kyedzy. Kuni meñ xaa tu kik kiy klaa parñee kchon meñ xaa siko. Chex kiy go nche kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per lëë Jesús kwtedy lady meñ aan lëë xaa si. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lëë Jesús kwey Capernaum nii ngab Galilea, aan tsi lëë tse nii xiladzy meñ lo tsiiñ kol, lëë xaa bluuy xtiits Dios lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Psee meñ biñ kchë nii bluuy xaa, porñee si xñee xaa xñabey xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aan lëë tu mguiy nii no tu kyalbini mal leñ styoo no leñ ktoo. Lëë xaa kwchuptsyë chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Psaan noo. ¿Penak xkaaloo lëë noo, Jesús Nazaret? ¿Pe sëëd knitylool lëë noo yak? Xyuumbeyaa lii ni nanaa nii lii nak Xiñ Ntson Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsigo lëë Jesús kwëntseeb lo kyalbini mal go, chëb xaa: —¡Psuugw chuwoo aan psaan mguiy gue! Lëë kyalbini mal go pchon mguiy go lyu, aan lëëw pchoo. Ni tu pe beeñdyo mguiy go. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kchësy meñ ptsyeb aan xñee meñ: —¿Xa nak kchë cos re? ¡Axte lo kyalbini mal xñabey xaa re aan lëëw xchoo! ");
INSERT INTO ztqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aan tyub tañ go masyke lë Jesús xseety meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsi lëë Jesús pchoo ktoo, lëë xaa kwey lidzy Simoñ, aan lëë xñaatsaap Simoñ xsyaknë, no me xlyëë. Aan lëë xaa chëbo lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lëë Jesús kwxinchuñ buy lo me aan loxsye kwëntseeb xaa lo xlyëë, lëëw pchoo ni lëë gaa me kuxche beeñlo me nii taw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsiñee lëë ngbidz kwyaasy, lëë meñ kuni kchëlo xaa xsyaknë lo Jesús, aan lëë xaa pxob ña xaa kik kchë meñ go, ni kchë gaa meñ go byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ni ndaly leñ styoo meñ nii nche siko pchoo kyalbini mal nii chuptsyë, xñee: —Lii nak Xiñ Dios. Per lëë Jesús kwëntseeb lo kyalbini mal go. Blaady xaa nyeew, porñee nan kchë kyalbini mal go nii lëë Jesús nak Crist nii no kiid. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsiñee lëë lyu byaani, lëë Jesús kwey tublad chu kyedzy laañee ni tu cho kindy. Per lëë meñ kukyub xaa, aan lëë xaa ptsil lo meñ. Kokladzy meñ ngwëës meñ xaa parñee mbidy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","per lëë xaa chëb: —No nii kateedyaa stubla kyedzy par kluyaa xa nak xkyalwnabey Dios, por par ngo syelyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Singo kwtedy Jesús xtañ meñ Judea xluuy xaa xtiits Dios kchë leñ ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tu vuelt lëë Jesús so chu nistoo nii lë Genesaret, aan singootyee xtaagw kchësy meñ nii chakladzy kon xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lëë Jesús kon nii lëë chop barkw nche nlety chu nis, porñee lëë xpixwano no kiib kyex nii xkaa mël. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lëë Jesús kwyëp leñ tu barkw nii nak xcheñ Simoñ, aan lëë xaa kwnabey kwsosit barkw chu nis. Loxsye ngo lëë xaa kwsob leñ barkw aan lëë xaa bluuy xtiits Dios lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tsiñee lëë xaa lox kwnee lo meñ, lëë xaa chëb lo Simoñ: —Kuni barkw laañee nxity, aan kol kchon xkyex to par kñaasy to mël. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tsigo lëë Simoñ chëb: —Maestre, tyub kyool pkyëë noo tsiiñ, aan bñaasty noo mël. Per ya ke nii lii dyon xñeew, lëën kchon kyex lo nis. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tsiñee lëë xaa pchon kyex, per nii ndaly mël busy pkaa, axte pchos xkyex xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Por ngo lëë xaa kwloo señ lo xcombañer xaa nii no stu leñ barkw parñee kuñ xaa go xaa yudar. Lëë xaa go kwey aan chop xbarkw xaa byaktsë axte xkiitsyo lo nis. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tsiñee lëë Simoñ Pedre kon kchë ngo, lëë xaa psoxib lo Jesús aan lëë xaa chëb: —Psaan naa, xey, por tu ngoptol nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Singo chëb Simoñ porñee ptsyeb xaa ksa xaa meñ nii kon kchë mël nii kwnaasy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ni wi gaa Santiagw ni Juan ptsyeb. Xiñ Zebedeo nak xaa chop xaa. Ksa xaa Simoñ xkyë tsiiñ. Per lëë Jesús chëb lo Simoñ: —Ktsyeebtyoo. Por destye natse kñaastroo mël, sink lëël kluuy xtitsaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Loxsye psotsey xaa barkw chu nis, nche gak kchë xtsiiñ xaa, lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tu tse lëë Jesús so tu leñ kyedzy, tsiñee lëë tu xaa xsyaknë nii xyodz lady ptsiñ. Lëë xaa psoxib ni lëë xaa pkiitsy kë lyu kon xaa Jesús, aan lëë xaa chëb: —Xey, pe nëëdyoo beeñ kyak naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lëë Jesús pxob ña kik xaa chëb: —Chakladzyaa nii kyakoo. Byak. Wor go kazh lëë xaa nii xyodz lady ko byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aan lëë Jesús chëb kazh lo xaa: —Ni tu cho lo këëbtylo, sink byey aan kwey lo pxosy. Kuksakon nii xñabey xley Moisés parñee kaknan kchësy meñ nii lëël byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sisi gaa tse lëë meñ nii chon nii chuuñtsyey Jesús xtyaly, ni lëë meñ chijkëëtyag xtiits xaa, ni lëë meñ chi par kuuñ kyak xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per ndaly vuelt xchooxso Jesús par kutiitsni xaa Dios laañee kindy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lëë stu tse lëë bla xaa fariseo ni bla maestre ley nii sëëd nëz xtañ meñ Galilea, ni Judea ni Jerusalén kusob laañee no kluuy Jesús xtiits Dios. Lëë Dios nakni Jesús. Por ngo chuuñ kyak xaa xaa xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Siko kuni meñ tu xaa xsyaknë nii kë yag lo xaa. Tyub lady xaa xsyaknë go kutoo. Kokladzy meñ nsyëëbni meñ xaa leñ yu par kix meñ xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per pchilody ndyedyni meñ xaa, porñee singootyee ndaly meñ nche. Por ngo lëë xaa kwyëp kik yu, aan lëë xaa kwtob bla tej, aan nëz laa nyaly go blity xaa xaa xsyaknë go par ktsiñ xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tsiñee lëë Jesús kon nii xniladzy meñ nii ptsiñni xaa xsyaknë go nii lëësy Jesús chuuñ kyak meñ xsyaknë, lëë Jesús chëb lo xaa xsyaknë: —Xiñ, lëë kchë xtoloo bily. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsigo nladzy maestre ley ni xaa fariseo: “¿Cho nak xaa gue nii xko xaa falt lo Dios? Dios sye xtsily xtol meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per lëë Jesús byeñ kchë nii no ksya styoo xaa go aan lëë xaa chëb: —¿Penak nii xsya tol do? ");
INSERT INTO ztqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Schilo këpaa lo meñ xsyaknë: “Lëë kchë xtoloo bily”, ni schilo këpaa: “Kuxche aan kwsë”, per ¿chow dyon mastre ngan? ");
INSERT INTO ztqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Per lëën kluy lo do gaanoo nii lëë mguiy nii pxaal Dios lo kislyu kwaa tiitspey parñee ktsily xaa xtol meñ. Loxsye ngo lëë xaa chëb lo xaa nii kutoo go: —Lool xñen, kuxche, blis xtal aan byey liidzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wor go kazh xña lo meñ lëë xaa nii kutoo go kuxche, lëë xaa blis xta xaa, aan lëë xaa sey lidzy xaa, xtee xaa skizh lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kchësy meñ nii nche siko psee kon nii beeñtsyey Jesús, aan lëë meñ ptee skizh lo Dios xñee meñ: —Tu kyalntson nrii ptyon no natse. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Loxsye ngo lëë Jesús bi siko, aan lëë xaa kon tu xaa nii xtop tumi nii xyey Roma. Leví pcholë xaa go. Lëë xaa sob laañee chikni meñ tumi. Lëë Jesús chëb lo xaa: —Tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lëë Leví kuso, aan nche gak kchë xtsiiñ xaa, lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lëë Leví beeñlo tu niskwaan par Jesús. Aan ndaly xaa nii xtop tumi nii xyey Roma ni stubla meñ kwsob kwi Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Por ngo lëë xaa fariseo ni lëë maestre ley bislo kwneenë xpëëdscuel Jesús, chëb xaa: —¿Penak nii chawni do ni chini do ksa do xaa nii xtop tumi nii xyey Roma ni meñ ngoptol? ");
INSERT INTO ztqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tsigo lëë Jesús kwëb chëb: —Xkiiñdy meñ nii ndaan xaa nii chuñ rmedy, sink meñ xsyaknë xkiiñ xaa nii chuñ rmedy. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Syely kyubtyaa meñ buen, sink lëën syely kyub meñ nii no xtol parñee kpikche styoo meñ go lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tsigo lëë meñ chëb lo Jesús: —Kchësy xaa nii no xlad Juan gon ni xaa nii no xlad xaa fariseo chawdy xaa par kuuñ ksak xaa Dios, per lëë xpëëdscueeloo masyke wagw no xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lëë Jesús chëb: —¿Pe mod lika nayak ksaan xaa nii chi tu kyalwtsiilña xkyon par kteenë xaa deelñee bii nche xaa nii ptsiilña? ");
INSERT INTO ztqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per sitsiñ tse nii lëë xaa ptsiilña kpi. Tsigolye nagon schilo ksaan meñ wagw par tso kyalnë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lëë gak Jesús bitiits nrii lo meñ, chëb xaa: —Ni tu cho xchugty tublë xab kub par kyëtë tu ladx yoox, por deelñee kchug meñ xab kub, lëëw xiñ, ni xtsiildy kaa ladx yoox nii kyëtëw ladx kub. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni xtyëëdy kaa nip kub leñ tu kyeg kidy nii kwyoxle, por lëë nip kub xchos kyeg yoox, aan lëëw xiñ chopo. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Por ngo no nii ktyëë nip kub leñ kyeg kub. ");
INSERT INTO ztqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ni ni tu cho chidy nip kub loxsye xtyoow nip nii pyexle, por kchë meñ xñee nii mastre nizh nip nii pyexle. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lëë Jesús sitedy tu lo kwaakon tse nii xiladzy meñ lo tsiiñ. Aan lëë xpëëdscuel xaa pchoow xobxtily parñee kwii xaa xobxtily kaw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Per lëë bla xaa fariseo chëb lo xaa: —¿Penak nii chuuñtsyey do tu cos nii nonguialdy kak tse nii xiladzy meñ lo tsiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tsigo lëë Jesús kwëb chëb: —¿Pe karty klab to kitsy nii xñee xa beeñtsyey rey David ksa xcombañer xaa worñee kwlaañ xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lëë xaa gon kwsëëb leñ lidzy Dios, aan lëë xaa taw kyaxtily nii nak lay ksa xcombañer xaa, nikxe nii nonsy pxosy nonguial kaw kyaxtily go. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ni lëë gak Jesús chëb: —Lëë mguiy nii pxaal Dios xñabey lo tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lëë stu tse nii xiladzy meñ lo tsiiñ, lëë Jesús kukluuy xtiits Dios lo meñ leñ ktoo, aan lëëtyee lëë tu xaa xsyaknë nii mbañdy ñali no leñ ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ni lëë maestre ley gaa ni lëë xaa fariseo nche kleetsy dyon pe syuuñ kyak Jesús xaa tse nii xiladzy meñ lo tsiiñ, parñee tso pe cos jkëëkiy xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per como nan Jesús pe cos no kik xaa go, lëë xaa chëb lo xaa nii mbañdy ña: —Kuso aan kwso groltyee nu. Lëë xaa xsyaknë go kwsoli. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Loxsye ngo lëë Jesús chëb lo meñ: —Kol në dyon pe nonguial kak buen tse nii xiladzy meñ lo tsiiñ, ote nonguial yak kak mal. ¿Pe nonguial dyon klaa no kety tu meñ, ote nonguial yak kteelaa no meñ? ");
INSERT INTO ztqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Lëë xaa buy lo kchë meñ nii nche siko, aan lëë xaa chëb lo xaa xsyaknë go: —Ptsiily ñal. Lëë xaa xsyaknë go psoob xtiits xaa, aan lëë ña xaa byaktsey. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Per no xaa nii tir blëë, aan lëë xaa bislo bitiits xaa dyon xa ksaksi xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Misme gak leñ tse go lëë Jesús kwey tu kiy, aan tyub kyool bitiitsni xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsiñee lëë lyu byaani, lëë xaa kwtsyetsy kchë xpëëdscuel xaa, aan lëë xaa kwle tsiipchop xaa nii kak apostle. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lëë lë ksa xaa nii kwle xaa nrii: Simoñ, xaa nii kwloolë xaa Pedre, ni Ndresy betsy Simoñ, ni Santiagw, ni Juan, ni Felip, ni Bartolomé, ");
INSERT INTO ztqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Mateo, ni Max, ni Santiagw xiñ Alfeo, ni Simoñ nii kwyo lady tub tiiy xaa nii pcholë Cananista, ");
INSERT INTO ztqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Judas betsy Santiagw, ni Judas Iscariote, xaa nii pko Jesús ña xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Lëë Jesús byety kiy ksa apostle, aan lëë xaa kwlës tu lo letsy. Ndaly meñ nii no xlad xaa ptsiñ siko ni ndaly meñ Judea, ni meñ Jerusalén ni ndaly meñ nii no tyub chu nistoo nii lë Tiro ni Sidón ptsiñ. Kchësy meñ go kwey par jkëëtyag meñ go nii xluuy Jesús ni parñee kuñ xaa meñ go rmedy. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Beeñ kyak xaa kchë meñ nii no ksaksi kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kchë meñ kokladzy nsyeñ Jesús, porñee byeñ meñ nii lëë Dios ptee kyalwnabey lo xaa par kuuñ kyak xaa kchë meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Lëë Jesús buy lo xpëëdscuel aan lëë xaa chëb: —Dichos to nii prob to, por lëë do sëëb laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dichos to nii kindy pe kaw do nina, porque sitsiñ tse nii lëë do kyëly. ’Dichos to nii choon do nina, porque sitsiñ tse nii lëë do kxidzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Dichos to tsiñee kaklasty meñ kan meñ do, ni tsiñee kwii meñ do kyedzy, ni tsiñee kotsyetsy meñ do, ni tsiñee kpixladzy meñ kan do sinak nii nyak to tu xaa mal porñee xsoob to xtiits mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kol kle ni kol ko nguiool styoo do tse nii ktsyool do kchë ngo, por lëë Dios kizh lëë do tsiñee ktsiñ do kpaa. Ni siñee xsaksi gak meñ lëë do psaksi pxosy meñ kchë profet nii biid penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Chooksye lëë doy nii nak to rikw, por lëë do kwaal nii no jkaa do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Chooksye lëë doy nii xlyaañdy to nina, por so tse nii lëë do tedy kpiñ. ’Chooksye lëë doy nii xidzy to nina, por so tse nii lëë do koon por kyalnë. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Chooksye lëë doy tsiñee xlisklaa meñ do, por singo gak blisklaa pxusykoltoo meñ kchë profet wnee xuuy nii biid penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Per lëën xñe lo do, kchësy to siñee xkëëtyag to xtitsaa, nii jkëstyoo do meñ nii xlëë lo do, ni kuñ do kyalbuen lo meñ nii chaklasty kan lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kol ktikche tiits buen lo meñ nii xkyë lo do, ni kol nab nii kakni Dios meñ nii xkotsyetsy lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Deelñee kiswee meñ tublad kwesyoo, wi stublado ptee kiswee meñ. Ni deelñee no cho chakladzy kla xchakeetoo, blaa koy xaa wi xmaankwoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ni deelñee kñab meñ tu cos lool, ptedyo. Ni deelñee kla meñ tu cos lool, kuuñkiydylo. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kol kan meñ sinak chakladzy to kan meñ do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Deelñee xaktyee meñ nii xkëstyoo gak lëë do xkëstyoo do, pa nondyo. Por singo gak chuuñtsyey kchë meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni deelñee xaktyee gak lo meñ nii buen lo do chuñ do kyalbuen, pa nondyo. Por singo gak chuuñtsyey meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Deelñee xaktyee lo meñ nii xyeñ do schilo kizh xkutiñ do, pa nondyo. Por singo chuuñtsyey meñ ngoptol. Tsiñee xkutiñ xaa tu cos, xkyëmbës xaa ktikche meñ favor go. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","No nii jkëstyoo do meñ nii xlëë lo do, ni no nii kuñ do buen. Ni no nii kutiñ do cos, per kyëmbësty to nii ktikche meñ favor go lo do, tsiin nroobre nii jkaa do lo Dios nii sob kpaa ni lëë gaa to kak xiñ xaa. Buen xaa, lëë xaa chakni meñ nii xsakty styoo ni meñ mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kol jkëstyoo meñ sinak nii xkëstyoo Tat Tios lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Kseejty to meñ tsiin kseejty Dios lëë do, ni jkëëkiydy to parñee jkëëkiydy Dios to. Kol knityladzy falt nii xko meñ lo do tsiin ktsily Dios xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kol kteedy nii jkiiñ meñ tsiin knee Dios nii jkiiñ do. Lëë xaa ktiix nii kneetsy xaa lo do aan axte kpixo chu medid. Sinak nii xtiixak to nii xtee do lo xcombañer do ktiix Dios nii kneetsy xaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aan lëë gak Jesús bitiits nrii chëb: —¿Pe schilo nawen kluuy xaa ni xñady lo nëz lo stu xaa nii chandy? ¿Pe lëdy nayak sikyab xaa leñ tu kyeech chop xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mastre chak maestre lo mëëdscuel, per tsi lëë mëëdscuel lox xseedy, lëë xaa chak sinak chak xmaestre xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Penak xseel chanoo tublë kizh wiñ nii no lo betsyoo, aan xyeñdyoo nii mastre ngol tublë yag nii no lool? ");
INSERT INTO ztqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Xa kchilo këëboo lo betsyoo: “Kwlës dyon, beetsy, kwin kizh wiñ nii no lool”, deelñee xyeñdyoo nii mastre ngol yag nii no lool? Kseedyoo meñ, sink klo kwlii yag ngol nii no lool, tsiin kchilo kanoo par kwiil kizh wiñ nii no lo betsyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Xkyëdy nex byodz lo yag buen, ni kyëdy nex buen lo yag nii buendy. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Por xnex yag xyuumbey meñ yag. Xkyëdy yegw lo yakitsy, ni xkyëdy uv lo sars. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tiits buen xñee xaa nii buen no styoo xaa, per lëë xaa mal, tiits mal xñee xaa, porñee mal no styoo xaa. Ni kchë gaa nii no leñ styoo meñ xchoo chuw meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Penak xñee do nii naa nak xaa nii xñabey lo do, aan chuuñtsyeydy to nii xñen? ");
INSERT INTO ztqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Lëën kniy cho nak sinak meñ nii xkëëtyag xtitsaa ni chuuñtsyey nii xñen. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nak meñ go sinak tu xaa nii kwteeñ nxity lo kyo par tsaa lidzy. Aan tsiñee lëë nis kok naal kiigwpee, lëë nis kutsib axte chilidzy xaa, per beeñ kxisty niso, porñee tsiitsy sobo. ");
INSERT INTO ztqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per lëë meñ nii xkëëtyag xtitsaa aan chuuñtsyeydyo nak meñ go sinak tu xaa nii psaa lidzy nëb lo lyu aan kwteeñdy xaa. Aan tsiñee lëë nis kok naal kiigwpee, lëë nis kutsib axte chilidzy xaa, lëë nis pchon lidzy xaa aan kazhka kwnitylow. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Loxsye kwnee Jesús lo meñ, lëë xaa sey Capernaum. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Siko kwyo tu xaa nii xñabey lo tubtsoon soldad Roma, aan lëë tu xmos xaa kwxaaknë. Tir xkëstyoo xaa mos ko, per lëë mos no nëz kyalkuty. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tsiñee lëë xaa biñ nii lëë meñ xsocuent nii chuuñtsyey Jesús, lëë xaa pxaal bla xaa kol nii xñabey lo meñ Israel sinab nii tsikuuñ kyak Jesús xmos xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lëë xaa kol go kwey aan lëë xaa kwnab nii tsi Jesús, chëb xaa: —Chigal nii kuñoo soldad xñabey re yudar, ");
INSERT INTO ztqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","por xkëstyoo xaa meñ xkyedzy noo. Lëë xaa psaa xiktoo noo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lëë Jesús sinal, per tsiñee lëë xaa ptsiñ kex chilidzy soldad nii xñabey, lëë soldad pxaal bla xamigw kukëb lo xaa: —Ko tsiiñdyaa lool, por cho naktyaa parñee sëëboo leñ lidzyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Por ngo nii byaxtyaa nyelyaa yuubaa lool. Pxaal tiits parñee kyak xmosaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Por deel naa no xaa nii mastre xñabey lon, lëë naa lo soldad xñabeyaa. Tsiñee xalaa tu xaa mandad chi xaa. Tsiñee xkwetsy kaan tu xaa chiid xaa. Singo gak xmosaa tsiñee xñabeyaa nii kuuñtsyey xaa tu cos, chuuñtsyey xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Psee Jesús biñ ngo, aan lëë xaa chëb lo meñ nii nal xitsy xaa: —Nli xñen nii karty kanaa tu meñ Israel nii kniladzy Dios tyub styoo sinak xniladzy xaa re. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tsiñee lëë xaa nii kunee lo Jesús ptsiñ chu yu, lëë mos nii xsyaknë tselye byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Loxsye ngo lëë Jesús si tu kyedzy nii lë Naín ksa xpëëdscuel aan ndaly meñ kunal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tsiñee lëë xaa ptsiñ kex chu kyedzy, lëë xaa kon nii lëë meñ sijkeetsy tu xiñgan tu kwnaa viud. Mëëd tusy kok xaa wiñ go lo xñaa, aan singootyee ndaly meñ sinal me wkeetsy. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lëë Jesús pkëstyoo kwnaa go aan lëë xaa chëb lo me: —Koondyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lëë xaa big kwseñ xaa chu yaglan, aan lëë xaa nii nxob yaño kwche tse. Loxsye ngo lëë xaa chëb lo mëëd kuty ko: —Xaa wiñ, lool xñen, ¡kuxche! ");
INSERT INTO ztqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lëë xaa wiñ nii kuty ko kwsobli ni lëë xaa kwnee, aan lëë Jesús psaan xaa lo xñaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kchësy meñ nii kon ngo psee ni ptee skizh lo Dios, xñee: —Lëë tu profet kwlañche lo no, ni lëë Dios sëëd kuñ meñ yudar. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aan tyub Judea ni kchë kyedzy nii nche nëz tañ go bitiits meñ nii beeñtsyey Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lëë xpëëdscuel Juan bitiits kchë ngo lo Juan. Por ngo lëë Juan kwtsyetsy chop xpëëdscuel, ");
INSERT INTO ztqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aan lëë Juan pxaal xaa lo Jesús par kñabtiits xaa dyon pe lëë Jesús nak xaa nii kxaal Dios, ote no nii yak bii kyëmbës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lëë xaa nii pxaal Juan chëb lo Jesús: —Lëë Juan Bautist pxaal lëë noo par kñabtiits noo dyon pe lii nak xaa nii kxaal Dios, ote no nii yak bii kyëmbëës noo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wor go kazh lëë Jesús beeñ kyak ndaly meñ xsyaknë ni lëë xaa beeñ kyak meñ nii no kyalbini mal leñ styoo ni meñ nii xñady lo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsigo lëë xaa chëb lo xpëëdscuel Juan: —Kol kyey, aan kol kutiits kchë nii kon do ni biñ do lo Juan. Kol këb nii lëë meñ nii xñady lo chan, ni lëë meñ nii në niy xsyë, ni lëë meñ nii xyodz lady xyak, ni lëë meñ nii xkwaat chon, ni lëë meñ kuty xpañ, ni lëë kchë meñ nii ni tu pe chapty xkëëtyag xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ni kol këb: Dichos meñ nii jkandy kik kan naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tsiñee lëë xpëëdscuel Juan bi, lëë Jesús bitiits lo meñ cho nak Juan, chëb xaa: —¿Pe cos kukuy do dyon worñee kwey do tañ? ¿Pe kukuy do tublë kizh nii nëz re nëz rek xni me? ");
INSERT INTO ztqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aan deelñee kukuydy to ngo, ¿pe cos kukuy do? ¿Pe kukuy do tu xaa nii nakw ladx non yak? Por nan do gon nii lidzy sye rey no xaa nii nakw ladx non ni xaa nii mbëë mbañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kol në dyon pe cos kukuy do. ¿Pe kukuy do tu profet yak? Deelñee tu profet gon kukuy do, nli nii profet nak xaa nii kukuy do, per mastre non xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Lëë Juan xseety kitsy nii kë xtiits Dios laañee xñeew: Lëën kxal tu xaa nii tenech lool, parñee kwii xaa tu nëz tedyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Lo kchë meñ nii noyaly lo kislyu re xsobaa nii ni tu meñ karty tsitsib sinak Juan. Per lëë laa xñabey Dios kchë xaa nii xisy non chuñ gan lo Juan. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kchësy meñ pkëëtyag nii kwnee Juan aan axte wi xaa nii xtop tumi nii xyey Roma byeñ xa nak xkyalwnabey Dios. Por ngo lëë xaa kwchobnis lo Juan. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per lëë xaa fariseo ni maestre ley kwchobnisty xaa lo Juan. Kwxaakty xaa kyalnsaak nii pxaal Dios. Chëb kaa Jesús: ");
INSERT INTO ztqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—¿Cho nak sinak meñ nii no natiemp dyon? ");
INSERT INTO ztqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nak meñ nii no natiemp gon sinak chol xaa wiñ nii xkwe kity laañee chak kiy aan xñee xaa lo xcombañer xaa: “Biily noo flaut aan byëëdy to, ni biily noo ti nii së mban aan biiñdyak to.” ");
INSERT INTO ztqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Por na nii biid Juan xñee do nii kyalbini mal no leñ styoo xaa, porñee tawdy xaa kyaxtily ni kowdy xaa viñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lëë na nii lëë mguiy nii pxaal Dios chaw ni chi viñ, xñee do nii lyaadzy wagwsye no xaa gue ni ngonip xaa, ni xñee do nii lëë xaa xtsiil lsa meñ ngoptol ni meñ nii xtop tumi nii xyey Roma. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per por kchë nii chuuñtsyeyaa xluuy nii Dios nakni naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lëë tu xaa fariseo kuni Jesús lidzy xaa par kaw Jesús, aan lëë Jesús sob lo mezh. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tsiñee lëë tu kwnaa ngoptol nii no leñ kyedzy ko biñ nii lëë Jesús ptsiñ lidzy xaa fariseo go, lëë me kwey noy me tu bot aceit nii xlyaa nex. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Lëë me big nëz xitsy Jesús choon me aan lëë me pkadz niy xaa con nis lo me. Loxsye ngo lëëw pkwiitsy me con kits kik me, ni lëë me ptsiil chuwo, ni lëë me kwtëëbo aceit xlyaa nex. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tsigo nladzy xaa fariseo nii kwtsyetsy Jesús kaw Jesús: “Deelñee nyak xaa gue profet, nyeñ xaa nii no xtol kwnaa nii so lo xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Per lëë Jesús chëb lo xaa fariseo: —Simoñ, chakladzyaa kniyaa tu cos lool. Aan lëë xaa chëb: —Kwnëw maestre. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lëë Jesús chëb: —Chop xaa name nsëëb lo tu xaa nii xkutiñ tumi. Tu xaa nsëëb kaay kyoow denario. Lëë stu xaa nsëëb choowptsiiw. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aan como pchilody nguizh xaaw, lëë xaa nii xkutiñ tumi ptsily chop lë xaa parñee kak nsëëbtre xaa. Kwnë dyon lo chop xaa go cho xaa mastre ksak styoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Lëë Simoñ chëb: —Buty xaa nii mastre nroob tumi nsëëbo. Tsigo lëë Jesús chëb: —Nli xtiitsoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lëë Jesús byoogw buy lo kwnaa go, aan lëë xaa chëb lo Simoñ: —¿Pe chanoo kwnaa re? Kwsëbaa liidzyoo, aan bneestyoo nis nyadx niyaa. Per lëë kwnaa re kwtiib niyaa con nis lo me, ni lëëw pkwiitsy me con kits kik me. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ptsiilchuwdyoo naa, per lëë me, destye kwlaañaa, tugak no ktsiil chuw me niyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni kwtëëbtyoo aceit lo kikaa, per lëë me kwtëëb me aceit xlyaa nex niyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por ngo xñen nii lëë kchë xtol me bily, porñee tir pkëstyoo me. Per lëë meñ nii ndalydy xtol xpily, xisy xkëstyoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Loxsye ngo lëë xaa chëb lo kwnaa go: —Lëë kchë xtoloo bily. ");
INSERT INTO ztqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tsigo nladzy stubla xaa nii ksa xaa nche sob lo mezh: —¿Cho nak xaa gue nii axte tol xtsily xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Per lëë Jesús chëb lo kwnaa go: —Porñee bniladzyoo, ngo nii lëël kwtelaa. Byey, pe tsinidre kikoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Loxsye ngo lëë Jesús kwey ndaly kyedzy nii nche tañ go, kukluuy xaa xa nak xkyalwnabey Dios lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wi bla kwnaa nii kwlii xaa kyalbini mal leñ styoo ni beeñ kyak xaa kunal. Lady kwnaa go si María Magdalena. Leñ styoo me pchoo kadzy kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ni lady kwnaa go si Xwan, tsiil Cuza. Lo Herodes kwë Cuza tsiiñ. Ni lady kwnaa go si Susan, ni wi kchë kwnaa nii ptee kchë nii pkiiñ xaa kunal. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ndaly meñ pchoo xkyedzy par kan meñ Jesús. Por ngo singootyee ndaly meñ ptyop, aan lëë Jesús pso cuent re lo meñ, chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tu ngon name pchoo si kon. Aan tsi lëë xaa bislo xnee xaa pni, no xipni xaa byab lo nëz, aan lëëw ksubniy meñ ni lëëw ptop mguiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","No gaa laañee byabo lady kyo, aan tsi lëë pni go kwlañ, lëëw pidzy, porñee ngopty lyu. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ni no laañee byabo lady yakitsy, aan tsi lëëw kwlañ, lëë yakitsy kwtiño. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per lëë stub lugar lëë xipni xaa byab laañee neely lyu, aan lëëw kwroob ni ngui koko. No lady pni go kwsob axte tu kyoow xob. Loxsye bitiits Jesús ngo, nguiedzy chëb xaa: —Deelñee chakladzy to kyeñ do, kol jkëëtyag. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tsigo lëë xpëëdscuel Jesús kwnabtiits xa nak cuent ko, ");
INSERT INTO ztqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","aan lëë xaa chëb: —Lëë Dios gon xluuy xa nak xkyalwnabey xaa lo do, per lëë lo meñ nii nche tublad nonsyke con cuent xluyno, parñee nikxe kuy meñ, per kandy meñ, ni nikxe kon meñ, per kyeñdy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Lëë pni nak sinak xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lëë pni nii byab lo nëz nak sinak meñ nii xkëëtyag xtiits Dios, per xlyëëdy lëë xaatox chikwii tiits ko styoo meñ, parñee knilasty meñ ni telaady meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lëë pni nii byab lady kyo nak sinak meñ nii xle xkëëtyag xtiits Dios, per como kindy luw, xtsedy xniladzy meñ go, por tsi lëë kyalnë sëëd lëë meñ go xchooxso. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Lëë pni nii byab lady yakitsy nak sinak meñ nii xkëëtyag xtiits Dios, per tseyga tseyga lëë kchë cos nii chak lo kislyu re, ni kchë cos non ni cos ngui xluuylo lo meñ go aan xsoobty meñ go xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lëë pni nii byaab kaa laañee neely lyu nak sinak meñ nii xkëëtyag xtiits Dios ni xniladzyo ni chuuñtsyey nii xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ni tu cho xkëëdy tu bini par kaaw leñ lon o tsolan gaaw, sink lëëw xkyë par sobo tu laañee ksaaniw lo meñ nii xsyëëb yu. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Singo gak nody tu cos ngueetsy nii kchukëdy, ni nody kaa tu cos nii chak tsilaan nii kak ndoondy. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Kol kap cuent, por lëë meñ nii chaple cos jkaarew. Per lëë meñ nii ni tu pe chapty, axte nii wiñ nii chap meñ go kpichee. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lëë xñaa Jesús ni betsy xaa kwey laañee so xaa, per pchilody mbig me lo xaa, porñee singootyee ndaly meñ nche. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lëë meñ kunitiits lo xaa chëb: —Lëë xñaal ni lëë betsyoo nche ley, chakladzy kan lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lëë Jesús kwëb chëb: —Kchësy meñ nii xkëëtyag xtiits Dios ni chuuñtsyeyo nak tnan ni nak betsyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tu tse lëë Jesús kwyo tu leñ barkw ksa xpëëdscuel, aan lëë xaa chëb: —Kol tsoo stublad chu nistoo. Lëë xaa si, ");
INSERT INTO ztqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","aan lëë Jesús kuutkesy leñ barkw. Lëë me gaa bislo xpi ni lëë nis noyaktsë leñ barkw. Tsiñee kon xpëëdscuel Jesús nii lëë barkw nonity lo nis, ");
INSERT INTO ztqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","lëë xaa kukuuñ kna Jesús, chëb xaa: —¡Maestre! ¡Maestre! ¡Lëë barkw nonity lo nis! Lëë Jesús kuxche, aan lëë xaa kwëntseeb lo me ni lo nis, ni lëë gaaw byaktse. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tsigo lëë xaa chëb lo xpëëdscuel xaa: —¿Penak nii kopty to Dios confians? Aan lo xtseeb ko xñee xpëëdscuel xaa lo xcombañer: —¿Cho nak xaa re nii xsoob me ni xsoob nis xtiits xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Lëë xaa ptsiñ xtañ meñ Gerasa nii nche stublad chu nistoo Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aan tsiñee lëë xaa byety barkw, lëë tu xaa nii no kyalbini mal leñ styoo big lo Jesús. Kok xtsele nii chakwty xaa ladx ni nody xaa leñ tu yu, sink lady paa no xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lëë xaa psoxib lo Jesús, aan lëë xaa kwchuptsyë, chëb xaa: —Jkaaldyoo naa, Jesús, Xiñ Dios nii sob kpaa. Xñabaa nii ksaksidyoo naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Singo chëb xaa porñee lëë Jesús kwnabey nii kchoo kyalbini mal go leñ styoo xaa. Ndaly vuelt psaksi kyalbini mal xaa, aan nikxe pxituu meñ niy xaa ni ña xaa con caden parñee kchoody xaa, lëëw pchug xaa, aan lëë kyalbini mal go kuni xaa tañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Lëë Jesús kwnabtiits lo xaa chëb: —¿Cho lël? Aan lëë xaa chëb: —Ndaly lën. Singo chëb xaa porñee ndaly kyalbini mal kwsëëb leñ styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lëë kyalbini mal go kwnab nii kxaaldy Jesúso linfiern. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aan como lëë tub tsoon ngutsy ncheno wagw chex kiy go, lëë kyalbini mal kwnab tiitspey lo Jesús par sëëbo leñ ngutsy ko. Aan lëë xaa pteedy tiitspey. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lëë kchë kyalbini mal go pchoo leñ styoo mguiy go, lëëw kwsëëb leñ ngutsy nii nche siko, aan lëë kchë ngutsy ko kukyab lo nis, aan lëë ma kuty. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lëë xaa nii xkyënap ngutsy pxooñ, kukni tiits kyedzy ni lëë xaa bitiits kchë nii kon xaa lo meñ nii ptsyool xaa nëz. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lëë meñ kukuy aan tsiñee lëë meñ ptsiñ laañee so Jesús, lëë xaa nii pchoo kyalbini mal leñ styoo sob lo Jesús. Nyaani chak xaa ni lëë xaa tse nakw xab xaa. Lëë meñ ptsyeb. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aan lëë xaa nii kon kchë ngo bitiits xa byak xaa nii kwyo kyalbini mal leñ styoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsigo lëë kchë meñ Gerasa kwnab nii kpi Jesús tañ go, porñee tir ptsyeb me. Lëë Jesús byo barkw aan lëë xaa bi. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kokladzy xaa nii pchoo kyalbini mal leñ styoo nyinal xaa Jesús, per lëë Jesús psonëz xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Byey liidzyoo, aan bitiits xa beeñ kyak Dioosoo. Lëë xaa go sey aan tyub leñ kyedzy bitiits xaa xa beeñ kyak Jesús xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tsiñee lëë Jesús ptsiñ stublad chu nistoo stub, xle meñ kuktsiilnëz meñ xaa, porñee kchësy meñ nche mbës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lëë tu xaa nii lë Jairo nii xñabey leñ ktoo ptsiñ, aan lëë xaa psoxib lo Jesús parñee tsi Jesús lidzy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porñee lëë xiñtsyaap xaa nii chap masy tu tsiipchop iz no nëz kyalkuty. Mëëd tusy nak me lo xaa. Lëë Jesús si aan xtaagw kchë meñ nii sinal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lady kchë meñ go si tu kwnaa nii kokle tsiipchop iz xsyaknë me, xchoo me cheñ. Ndaly lo meñ nii chuñ rmedy kukxiñ me xtumi me aan byagty me. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lëë kwnaa go big nëz xitsy Jesús aan lëë me kwseñ skiñ xab xaa, aan wor go kazh lëë me byag cheñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lëë Jesús chëb: —¿Cho kwseñ xabaa? Aan como kchësy meñ chëb: “Lëdy lëë noow”, lëë Pedre chëb: —Maestre, kchësy meñ xtaagw lii ni xchëëp lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Per lëë Jesús chëb: —No cho kwseñ naa, por byeñaa nii lëën beñ tu kyalntson. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsiñee lëë kwnaa go kon nii chilody tsolan me, xisy me aan lëë me kuksoxib lo Jesús. Aan xña lo meñ lëë me pxobtol penak kwseñ me xaa ni lëë me chëb nii wor go kazh lëë me byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lëë Jesús chëb lo me: —Xiñ, porñee bniladzyoo nii suuñ kyakaa lii, ngo nii lëël byak. Byey, pe tsinidre kikoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lëë Jesús bii nonee tsiñee lëë tu xaa nii pchoo lidzy xaa nii xñabey leñ ktoo ptsiñ, aan lëë xaa chëb lo xaa xñabey go: —Lëë xiñtsyaapoo tse lox kuty. Kotsiiñtroo lo maestre. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lëë Jesús biño, aan lëë xaa chëb: —Ktsyeebtyoo. Bniladzy nii lëë Dios kuuñ kyak xiñoo aan lëë me kyak. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tsi lëë Jesús ptsiñ lidzy xaa go, xaktyee Pedre, ni Santiagw, ni Juan, ni xñaa mëëd kwnaa go ni pxosy me blaa xaa kwsëëb leñ yu. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kchësy meñ nchenoyoon ni no kteenë por mëëd kwnaa go, per lëë Jesús chëb: —Koondy to. Kujty me, sink lëë me nixyesy. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kchësy meñ pxidzyni Jesús, porñee nan meñ nii kuty me. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lëë Jesús kwseñ ña me aan lëë xaa chëb: —Mëëd wiñ, lool xñen, kuxche. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lëë me pañ aan wor go kazh lëë me kuxche, aan lëë Jesús chëb: —Kol ktee nii kaw me. ");
INSERT INTO ztqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tir psee pxosy me, per lëë Jesús chëb nii ni tu cho lo kutiisty xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lëë Jesús kwtsyetsy ksa tsiipchop xpëëdscuel, aan lëë xaa ptee tiitspey lo xaa parñee kwii xaa kyalbini mal leñ styoo meñ ni kuuñ kyak xaa meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lëë xaa pxaal xpëëdscuel xaa parñee kluuy xaa xa nak xkyalwnabey Dios lo meñ ni kuuñ kyak xaa meñ xsyaknë, ");
INSERT INTO ztqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","chëb xaa: —Koydy to nii jkiiñ do nëz, ni yag nii ksoxka do, ni bols, ni kyaxtily, ni tumi, ni koydy to ladx par ktsyëë xab to. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tsiñee ktsiñ do cualquier lidzy meñ, kol kwës siko axte nii kpi do kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Deelñee no tu kyedzy nii kaklasty meñ knee meñ laañee kwës to, kol kchoo kyedzy ko, aan kol kwib yu nii xña niy do, parñee kyeñ meñ nii no xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lëë xpëëdscuel xaa kwey kchë kyedzy nii nche tañ go, bluuy xaa xa kteelaa Dios meñ ni beeñ kyak xaa meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lëë rey Herodes biñ nii lëë meñ xseety Jesús ni kchësy nii chuuñtsyey Jesús, aan nandy Herodes pe kwxaak, porñee no meñ kwnee nii lëë Juan pañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","No gaa meñ kwnee nii lëë profet Elías kwlañche, ni no meñ kwxaak nii tu profet nii biid penaadle pañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per lëë Herodes chëb: —Yuub naa kwnabey kwchug kik Juan. ¿Cho ngue tsigo tant xseety meñ? Por ngo nii kokladzy Herodes nyan Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tsiñee lëë xapostle Jesús bikche, lëë xaa bitiits kchë nii beeñtsyey xaa, aan lëë Jesús sini xaa tu kyedzy nii lë Betsaida. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per lëë meñ byeño, aan lëë meñ kunal. Lëë Jesús kaa kwnee lo meñ xa nak xkyalwnabey Dios ni lëë xaa beeñ kyak meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lëë tse no ktsye tsi lëë ksa tsiipchop xpëëdscuel xaa big lo xaa chëb: —Psonëz meñ parñee kyey meñ wxiladzy ni tsikyub meñ nii ktyaaw kyedzy ni kchë laañee sob yu, por ni tu cho kindy nu. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lëë Jesús chëb: —Lëë do wo, kol ktee nii kaw meñ. Lëë xpëëdscuel xaa kwëb chëb: —Kaayak kyaxtily ni chopak mël nooy noo, xakxe deelñee kyosyuuy noo nii kaw kchësy meñ re. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Siik kaay mily meñ, per lëë Jesús chëb lo xpëëdscuel: —Kol këb lo meñ nii sob meñ choowptsii gaa meñ tub lugar. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lëë xpëëdscuel xaa psoob tiits aan loxsye kwsob meñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","lëë Jesús kwseñ ksa kaay kyaxtily go ni chop mël go, aan lëë xaa blëp lo kpaa par ktee xaa skizh lo Dios. Loxsye beeñ grol xaaw, lëëw pteedy xaa lo xpëëdscuel xaa par kiisy xaaw lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kchësy meñ byëly, aan tsiñee lëë wagw kwlox ptyop tsiipchop tskwidy kyaxtily byuy. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tu tse lëë Jesús noyutiitsni Dios nonsy, aan lëë xpëëdscuel xaa nche lo xaa. Lëë xaa kwnabtiits, chëb xaa: —¿Cho xñee meñ dyon nii nakaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lëë xpëëdscuel xaa kwëb chëb: —No meñ xñee nii lii nak Juan Bautist, no gaa meñ xñee nii lii nak profet Elías, ni no stubla meñ xñee nii no cho tu profet nii pañ nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tsigo lëë Jesús chëb: —Lëë dook, ¿pe nan do cho nakaa? Aan lëë Pedre kwëb chëb: —Lii nak Crist, Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Per lëë Jesús psaan kazh tiits nii ni tu cho lo këbty xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ni lëë xaa chëb nii tir mban tedy mguiy nii pxaal Dios, ni ksaldy xaa kol xaa, ni xaa nii xñabey lo pxosy, ni maestre ley. Lëë meñ kuty xaa, per tse nii loxo tson kpidz lëë xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ni lëë gak Jesús chëb lo kchësy meñ: —Deelñee no tu do chakladzy tso xladaa, no nii ksaan do kchë nii xyostyoo do, ni no nii tse con tse tedy to kyalnë parñee kchilo kiidnal do naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Por lëë kchë xaa nii choxko kteelaa xkyalmbañ lo kyalkuty kety. Per lëë xaa nii pe sinidy kik, nikxe kety xaa, lëë xaa kpañ, porñee xniladzy xaa xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Pe nan nii kuuñ xcheñ meñ tyub kislyu, lëëtyak lëë meñ kety? ");
INSERT INTO ztqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Deelñee no cho xteladzy chan naa ni xteladzy chon xtitsaa, lëë mguiy nii pxaal Dios kteladzy kan kchë meñ go tsiñee lëë xaa kiid con xkyalwnabey Dios ksa xaa angly. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xsobaa nii no meñ nii nche nu kejty axte nii kan meñ xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tse nii kwlox xon kpidz nii bitiits Jesús kchë ngo, lëë xaa kwey tu kik kiy kukutiitsni xaa Dios ksa xaa Pedre, Santiagw ni Juan. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mentre lëë Jesús noyutiitsni Dios, lëë lo xaa ptsyëë ni lëë xab xaa byak nguitsy ni lëëw bibëly. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aan lëë chop xaa ptsiñ chutiitsni xaa. Moisés ni Elías nak chop xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Xpibëly xaa. Lëë xaa bitiits nii lëë Jesús kety Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nikxe kwyo mgaal lo Pedre ksa xcombañer, lëë xaa kwchena, aan lëë xaa kon nii xpibëly Jesús ni xpibëly xaa nii bitiitsni Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tsiñee lëë chop xaa go no kpi lo Jesús, lëë Pedre chëb: —Maestre, ¡xaatke mbëë nche no nu! Lëë noo ksaa tson yu yagxiidy: tuwo par lii, stuwo par Moisés, stuwo par Elías. Per nandy Pedre penak kwnee xaa singo. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lëë Pedre bii nonee tsiñee lëë tu xkey ptaagw laañee nche xaa. Lëë xaa kwnity lo xkey go, aan lëë xaa ptsyeb. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lo xkey go pchoo tsiy tu xaa nii chëb: —Lëë xiñaa nrii. Naa kwle xaa. Kol jkëëtyag xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Loxsye biñ xaa tsiy xaa nii kwnee, lëë xaa kon nii xaktyee Jesús so. Koñee kwneedy xaa, ni tu cho lo bitiisty xaa kchë nii kon xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tsiñee lëë lyu byaani, lëë Jesús byety kiy ksa xpëëdscuel aan lëë tubtsoon meñ kuktsiilnëz xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lady kchë meñ go no tu xaa nii nguiedzy kwnee chëb: —Maestre, të kanoo xiñganaa. Mëëd tusy nak xaa lon. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Per lëë tu kyalbini mal xsaksi xaa, xkuptsyëw xaa, ni xchono xaa lyu, ni xkwiiw ptsiiñ chuw xaa, aan xlaadyo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lëën tse kwnab lo xpëëdscueeloo nii ngwii xaa kyalbini mal go, per pchilody xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tsigo lëë Jesús chëb: —¡Natsypee nguiedzy styoo do ni xnilasty to Dios! ¿Axte pa wor këb ñe nii lëën ksaladzy lëë do? ¿Pa slal tiemp no nii kxekwaa lo do? Tëni xiñoo nu dyon. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tsiñee lëë xaa wiñ go big lo Jesús, lëë kyalbini mal pchon xaa lyu, aan lëë xaa kutyë stub. Per lëë Jesús kwëntseeb lo kyalbini mal go, ni lëë xaa beeñ kyak xaa wiñ go, aan ndaan xaa sikni pxosy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kchësy meñ psee kon xkyalntson Dios. Mentre lëë meñ nche ksee kon kchë nii beeñtsyey Jesús, lëë Jesús chëb lo xpëëdscuel: ");
INSERT INTO ztqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kol jkëëtyag nii kniyaa lo do, aan knitylasty to nii lëë mguiy nii pxaal Dios jkaa ña meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per byeñdy xaa nii chëb Jesús, porñee blaady Dios nyeñ xaaw, aan ptsyeb xaa nyabtiits xaa lo Jesús xa nak tiits ko. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lëë xpëëdscuel Jesús bislo ptilytiits dyon cho xaa nak xaa nii mastre non. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tsi lëë Jesús byeñ xa no kik xaa, lëë Jesús kwtsyetsy tu xaa wiñ, aan lëë xaa pso xaa wiñ go kwi xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ni lëë xaa chëb: —Kchë meñ nii kantsi xaa wiñ re porñee xniladzy meñ xtitsaa, chantsi meñ go naa, ni chantsi meñ go xaa nii pxaal naa. Por ngo, tu xaa nii pa nondy lady to nak xaa nii mastre non. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Lëë Juan chëb: —Maestre, lëë noo ptyon tu xaa nii xkwii kyalbini mal aan xseety xaa lël, per lëë noo pkaw, porñee nody xaa lady no. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lëë Jesús chëb: —Jkady tow, por kchë xaa nii xlëëdy lo do no xfavor do. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Worñee lëë Jesús mer kyëp kpaa, lëë xaa kwloo valor lo xaa, aan lëë xaa si Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lëë xaa pxaal xaa nii kwtenech lo xaa par kyub xaa go laañee kwës xaa xtañ meñ Samaria. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per kwnëdy meñ Samaria ndee laañee ngwës xaa, porñee byeñ meñ nii Jerusalén si xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tsiñee lëë xpëëdscuel Jesús nii lë Juan ni Santiagw kon ngo, lëë xaa chëb: —Jesús, ¿pe chakladzyoo nii kñab noo kxaal Dios ki par knitylo kchësy meñ re? ");
INSERT INTO ztqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lëë Jesús byoogw, aan lëë xaa kwëntseeb lo xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Loxsye ngo lëë xaa si stu kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nëz no xaa, lëë tu xaa chëb lo Jesús: —Xey, chakladzyaa sënalaa lii laañee tsityoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tsigo lëë Jesús kwëb chëb: —Chap mëz kyoplyoo ni chap mguiñ pchoos, per lëë mguiy nii pxaal Dios ni laañee kxiladzy xaa xisy wiñ chapty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lëë Jesús chëb lo stu xaa nii so siko: —Tënal naa. Per lëë xaa go kwëb chëb: —Xey, blaa kajkeetsy kaazhaa pxosyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lëë Jesús chëb: —Blaa jkeetsy meñ kutysaa meñ meñ kuty. Lii nii xcueentoo kukluuy xtiits Dios lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lëë stu xaa chëb: —Xey, chakladzyaa sënalaa lii, per blaa kaknin tiits lidzyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lëë Jesús chëb: —Kchë xaa nii xsyeñ ña rad aan xuy xaa tublad, xkiiñdy xaa par kyë xaa tsiiñ laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lëë Jesús kwle stsongaly ptsiipchop meñ, aan chop kaa chop kaa meñ pxaal xaa nech tsi kchë kyedzy nii no tsi xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lëë xaa chëb lo meñ go: —Nak meñ nii no laañee tsi do sinak tsiñee lëë kwlaap mer kislo aan kindy ndaly xaa nii kyë tsiiñ. Por ngo no nii kñab to lo Dios nii kxaal xaa xaa nii kluuy xtiits xaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lëën xal lëë do laañee no meñ ntseeb nii ntseeb si ntseeb kchë ma tox nii chuty mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Koydy to bols ni tumi ni kyalkidy, ni jkëëptyuxty to meñ nëz parñee klyëëdy to. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tsiñee sëëb to tu leñ yu, kol nab nii kakni Dios meñ nii no leñ yu go. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aan deelñee jkëëtyag meñ nii no yu go nii kñee do, lëë nii kwnab to kak cumplir, per deelñee jkëëtyagty meñ gow, kakty nii kwnab to cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kol kwës tugak yu, ni kol kaw ni kol ki nii kneestyee meñ, por nonguial kazh xaa nii xkyë tsiiñ. Ktsëëlejty to laañee kwës to. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tsiñee ktsiñ do tu kyedzy nii ksal meñ do, kol kaw nii kneetsy meñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ni kol kuuñ kyak kchë meñ xsyaknë nii no siko, ni kol këb nii lëë wor kutsiñ nii lëë Dios kñabey meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per deelñee ktsiñ do tu kyedzy nii ksaldy meñ do, kol kchoo aan kol këb lo meñ: ");
INSERT INTO ztqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Axte xkiti nii pkaay niy noo xkwib noo parñee kyeñ do nii no xtol do. Per kol kaknan nii lëë xkyalwnabey Dios merle klyañche lo do.” ");
INSERT INTO ztqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nli xñen nii tse nii lëë Dios kuñ kyalxtisy ntseebre castigw nii tedy meñ go que nii tedy meñ Sodoma. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Chooksye lëë doy meñ Corazín ni chooksye lëë do meñ Betsaida! Por deelñee nyan meñ Tiro ni meñ Sidón kchë kyalntson nii kon do, tselye kokw meñ go ladx nchog ni tselye kwsob meñ go nëb lo xkiti parñee kluuy meñ go nii ptikche meñ go styoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Por ngo, tse nii lëë Dios kuñ kyalxtisy ntseebre castigw nii tedy to que nii tedy meñ Tiro ni meñ Sidón. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lëë lii nii nol Capernaum, ¿pe nladzyoo nayak tir klaa soboo? Klaadyoo gon, por lëël kyab laañee mastre nxity. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Kchë meñ nii xkëëtyag nii xñee do xkëëtyag xtitsaa, per lëë meñ nii xsaldy lëë do, ni naa xsaldy meñ go. Aan deelñee xsaldy meñ naa, xsaldyak meñ xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Lëë ksa tsongaly ptsiipchop xaa nii kukluuy xtiits Dios bikche aan xle xaa chëb xaa: —Jesús, axte kyalbini mal psoob xtiits noo tsiñee pseety noo lël. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tsigo lëë Jesús chëb: —Nli xñee do, por konaa xa pchingaa xaatox leñ kpaa sinak tsiñee xyab tu nkwsiy. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Por lëën bnetsy tiitspey lo do parñee subniy do mëël ni subniy do mëkwkyoow, ni parñee kuñ do gan lo xaatox, aan ni tu pe kakty to. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per kledy to porñee xsoob kyalbini mal xtiits to, sink kol kle porñee lëë lë do kë lo kitsy nii ngotsey Dios kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lëë Jesús ble, aan por Kyalbini Ntson nii no leñ styoo xaa lëë xaa chëb: —Xnetsyaa skizh lool, Tat Tios, por lii xñabey kpaa ni lii xñabey kislyu, ni kwloolanoo xtiitsoo lo meñ nyaani ni lo meñ chak parñee kluuylo lo meñ ndoladzy. Singo Tat Tios beeñtsyeyoo, porñee singo kwlaño styool. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Lëë Tat Tios bneetsy kchë nii chap xaa lon. Ni ni tu cho xyuumbeydy kaa xiñ Tat Tios. Xaktyee Tat Tios sye xyuumbey xaa. Singo gak kaa Tat Tios, xaktyee xiñ xaa ni meñ nii kwe xiñ xaa schilo kyuumbey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lëë Jesús byoogw aan nonstyee lo xpëëdscuel xaa chëb xaa: —Dichos meñ nii chan kchë nii chan do. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Por nli xñen nii ndaly profet ni ndaly rey kokladzy nyan nii chan do, per kondy xaaw. Ni ndaly xaa kokladzy nguëëtyag nii xkëëtyag to, per pkëëtyagty xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lëë tu maestre ley kunee lo Jesús, aan parñee kuñ xaa Jesús preb, lëë xaa chëb: —¿Pe cos kuuñtsyeyaa parñee jkan kyalmbañ nii xnitylody? ");
INSERT INTO ztqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tsigo lëë Jesús chëb: —¿Pe cos xñabey xley Moisés? ");
INSERT INTO ztqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lëë maestre ley chëb: —Lo ley xñee: “Pkëstyoo xDioosoo tyub styool, ni tyub xkyalmbañoo, ni tyubñaa fuersy nii nol, ni tyub xkyalcheeñoo. Ni pkëstyoo meñ sinak xkëstyool lii.” ");
INSERT INTO ztqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Lëë Jesús chëb: —Nli singo xñeew. Deelñee suuñtsyeyoo kchë ngo, skaal kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per parñee këb meñ nii buen xaa, lëë xaa chëb: —Kwnë dyon cho jkëstyoon. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tsigo lëë Jesús bitiits nrii lo xaa, chëb Jesús: —Tu xaa name pchoo xaa Jerusalén, si xaa Jericó. Aan lëë ngbaan pchoo lo xaa nëz, aan axte ladx nii no lady xaa kwlan ngbaan ni ptee ngbaan xcheñ xaa. Casy beety ngbaan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Siko nix xaa tsiñee lëë tu pxosy kwtedy nëz ko. Per tsi lëë pxosy kon xaa, lëë pxosy kwte tublad. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Singo gak beeñtsyey tu xaa nii chuñ yudar pxosy tsiñee kon xaa xaa nii psaksi ngbaan. Lëë xaa kwte tublad. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per tsi lëë tu xaa Samaria nii kwtedy nëz ko kon xaa nii psaksi ngbaan, lëë xaa pkëstyoo xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ni lëë xaa big beeñ xaa xaa go rmedy con aceit ni viñ, ni lëë xaa pchal ladx laañee bnek. Loxsye ngo lëë xaa psoob xaa go lady xkway xaa, aan lëë xaa kuni xaa tu posad par kan xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lëë byaani lyu lëë xaa Samaria kwlii tumi aan lëëw pteedy xaa lo xaa nii xtee posad, chëb xaa: “Kon xaa re, aan deelñee jkaady tumi re, na tsiñee kpikchen kizhaa nii kak falt.” ");
INSERT INTO ztqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tsigo lëë Jesús chëb lo maestre ley: —Lo ksa tson xaa nii kwtedy dyon, ¿cho xaa pkëstyoo xaa nii psaksi ngbaan? ");
INSERT INTO ztqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lëë maestre ley chëb: —Xaa nii blis xaa. Lëë Jesús chëb: —Singo no nii kuuñtsyeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lëë Jesús pkaa nëz, aan lëë xaa ptsiñ tu kyedzy nii no tu kwnaa nii lë Marty. Lëë me ptee lidzy me kwlës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aan lëë pël Marty nii lë Mariy kwsob lo Jesús par jkëëtyag me nii xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per lëë Marty singootyee no xmandad me, lëë me big lo Jesús, chëb me: —Xey, ¿pe ni tu pe sinidy kikoo nii lëë pëlaa psaan kchë mandad lon? Kudzy lo me kuñ me naa yudar. ");
INSERT INTO ztqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Per lëë Jesús chëb: —Marty, por ndaly cos nol kyalnë, ");
INSERT INTO ztqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","per tugak cos precisy. Lëë Mariy kwle cos ko, aan ni tu cho kladyo lo me. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tu vuelt lëë Jesús noyutiitsni Dios. Tsi lëë xaa byal, lëë tu xpëëdscuel xaa chëb: —Jesús, beeñ kseedy lëë noo kutiitsni noo Dios sinak beeñ kseedy Juan xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsigo lëë Jesús chëb: —Tsiñee kutiitsni do Dios, kol këb: Tat Tios, lii nii soboo kpaa, xñab noo nii kchë meñ kuuñ ksak lii, ni xñab noo nii ktsiñ tse nii kñabeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bneetsy nii tyaaw noo natse. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Beeñ noo perdón sinak chuuñ noo perdón meñ nii xko falt loo noo. Klaadyoo jkaal xaatox lëë noo parñee kyaabty noo lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lëë gak Jesús chëb: —Kol tsoo ksoob no nii chap to tu amigw, aan tsi do lidzy xaa wrol kyool, këb to: “Kwlootiñ tson kyaxtily lon, ");
INSERT INTO ztqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","por lëë tu xamigwaa kwlañche lidzyaa, aan kindy pe ktedyaa kaw xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kñëdy xamigw to gon: “Kuuñ klëëdyoo naa. Lëën tse psugw chilidzyaa ni lëën nix ksa xiñaa. Chilody kaschen par pe knetsyaa nii jkiiñoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nli xñen nii nikxe nii nyakty to xamigw xaa, lëë xaa tsische, por lëë do kulii xkaal xaa aan lëë xaa kneetsy kchë nii jkiiñ do. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kol nab nii jkiiñ do lo Dios tsiin kneetsy xaaw, kol kyub cos tsiin ktsyol dow, ni kol jkëëptyux chu yu tsiin kyalyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Por kchë meñ nii xñab cos xkaaw, ni kchë meñ nii xyub cos xtsyolo, ni kchë meñ nii xkëëptyux chu yu lëëw xyaly. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Pe no tu do dyon xyax xtee tu mëël lo xiñ do tsiñee xñab xaa tu mël? ");
INSERT INTO ztqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ni pe no do xtee tu mëkwkyoow tsiñee xñab xiñ do tu tsit? ");
INSERT INTO ztqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kol kyeñ gaanoo nii nikxe mal do, per xtee do cos buen lo xiñ do. ¿Pe lëëdyxe Tat Tios nii sob kpaa tsigo kteejty Kyalbini Ntson lo meñ nii kñabo? ");
INSERT INTO ztqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lëë Jesús kwlii kyalbini mal leñ styoo tu ngop, aan lëë ngop bislo kwnee. Kchësy meñ psee kon ngo, ");
INSERT INTO ztqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","per no meñ kwnee: —Beelzebú, xaa nii xñabey lo kchësy kyalbini mal, ptee tiitspey lo xaa gue par kwii xaa kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","No gaa meñ kokladzy nii nyuuñtsyey xaa tu kyalntson leñ kpaa parñee kuñ meñ xaa preb. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per como nan xaa pe xsya styoo meñ go, lëë xaa chëb: —Ni tu kyedzy nii nak chop tiiy gon xtiiydy. Lëëw xnitylo, aan kchë yu nii no leñ kyedzy ko xyab lady xcombañer. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Singo gak xaatox deelñee kak xaa chop tiiy, ¿xa kchilo kñabey xaa? Lëën xñe kchë nrii porñee xñee do nii lëë Beelzebú bneetsy tiitspey lon par kwin kyalbini mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Deelñee singo xsyak to, ¿cho xtee tiitspey lo xaa nii nak ksa do tsigo par kwii xaa kyalbini mal? Sikokesy nagon xluuy nii nandy to pe xñee do. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per deelñee por xkyalwnabey Dios xkwin kyalbini mal, lëë wor kutsiñ nii lëë Dios kñabey lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tsiñee lëë tu xaa ndaan chap kiib ni xkyënap lidzy, segur nak kchë nii no leñ lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per deelñee tsi stu xaa nii mastre ndaan lo xaa, aan kla xaa kiib nii xtaan xaa, lëë xaa kiisy kchë nii chap xaa go lo xcombañer xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Kchë xaa nii nody xfavoraa, chiidnidy xaa meñ lon, sink lëë xaa xsëëbtañ meñ, porñee xlëë xaa lon. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Tsiñee lëë tu kyalbini mal xchoo leñ styoo meñ, lëëw xkyënsë tañ xyubo dyon pa kwëso. Per deelñee xtsyoldy laañee kwëso, lëëw xñee: “Lëën kpikche lidzyaa laañee pchon.” ");
INSERT INTO ztqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tsiñee lëë kyalbini mal go xtsiñ, chano nii lëë leñ styoo meñ nii pchoow tse nak sinak tu yu nii kal lik blyoob ni kwxixkwaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsigo lëëw chikyub skadzy kyalbini nii mastre mal, aan lëëw xsyëëb leñ styoo meñ go ksaw, aan mastre mban xtyedy meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mentre lëë Jesús nonee kchësy ngo, lëë tu kwnaa nii no lady meñ chëb: —¡Dichos kwnaa nii kop lii ni pkadzy lii! ");
INSERT INTO ztqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lëë Jesús chëb: —¡Mastre dichos meñ nii xkëëtyag xtiits Dios, ni xsoob xtiits xaa! ");
INSERT INTO ztqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lëë meñ ptyopre, aan lëë Jesús chëb: —Lëë meñ mal nii no natiemp chakladzy kan tu kyalntson, per ni stu kyalntson kantre meñ re. No nii ksaladzy meñ nii beeñtsyey Jonás. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Por sinak nii kunee gak Jonás lo meñ Nínive, sëëdnee mguiy nii pxaal Dios lo meñ natiemp. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tse nii lëë Dios kuñ kyalxtisy lëë kwnaa nii kok rey xtañ meñ Sabá jkëëkiy meñ nii no natiemp, por sit pchoo me par jkëëtyag me xtiits rey Salomón, aan mastre precisy nii xñen que kchë xkyalchak rey Salomón. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wi meñ Nínive jkëëkiy meñ nii no natiemp tse nii lëë Dios kuñ kyalxtisy, por ptikche meñ Nínive styoo lo Dios worñee biñ meñ Nínive nii kwnee Jonás, aan mastre precisy nii xñen que nii kwnee Jonás. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ni tu meñ xkëëdy bini par kolan meño leñ tu cajón, sink lëë meñ xsoobo tu laañee ksaaniw lo kchë meñ nii sëëb leñ yu. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nak mëlo do sinak tu bini nii xsaani leñ styoo do. Deelñee nxiñdy mëlo do, tyub leñ styoo do nyaani. Per deelñee nxiñ mëlo do, tyub leñ styoo do nguey. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kol kap cuent nii kyuuydy bini nii no leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Por deelñee tyub leñ styoo do no bini, kindy nguey leñ styoo do, aan singo mod lëë do kan nyë kchë cos, sinak tsiñee xsaani tu bini lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tsiñee lëë Jesús lox kwnee, lëë tu xaa fariseo kuni Jesús lidzy par kaw Jesús. Lëë Jesús kwsëëb leñ yu aan lëë xaa kwsob lo mezh. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aan psee xaa fariseo kon xaa nii kwtiibty Jesús ña antes nii kaw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Per lëë Jesús chëb: —Kchësy to siñee nak to meñ fariseo nyë xkiib to vas nii xtyëë nii chi do, ni xkiib to kyon nii xtyëë nii chaw do, per lëë leñ styoo do kaktsë kchë clasy cos mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nguey do! ¿Pe nandy to nayak nii xaa nii psaa gak lëë do psaa xkyalmbañ do? ");
INSERT INTO ztqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kol ktee nii chap to lo meñ nii no lyaadzy tsiin kyak nyë do. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Chooksye lëë doy, meñ fariseo nii xtiix to pixtily ni xtiix to rud ni kchë clasy kizh nii xsaakon do lo Dios, per xsaldy to xkyalxtisy Dios ni xkyalwkëstyoo xaa! Ngo mastre precisy, per ksaandy to nii kokon do cos lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Chooksye lëë doy, meñ fariseo nii chakladzy to sob to laañee xsyob meñ non leñ ktoo, ni choki do jkëëptyux meñ do pal nëz! ");
INSERT INTO ztqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Chooksye lëë doy!, porñee nak to sinak paa nii nyoody, aan xyeñdy meñ xsyub niy meño. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tsigo lëë tu maestre ley kwëb chëb: —Maestre, wi loo noo gon pxiñoo tiits por kchë nii kwneel. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Per lëë Jesús chëb: —¡Chooksye lëë doy, maestre ley nii chakladzy to kuuñtsyey meñ cos nii ni tu cho chilody kuuñtsyey, aan lëë lëë do xteejty to nii kuuñtsyey dow! ");
INSERT INTO ztqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Chooksye lëë doy nii xsaa do chu xpaa kchë profet nii beety pxusykoltoo do! ");
INSERT INTO ztqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Por singo mod lëë do xluuy nii byo ni beeñtsyey pxusykoltoo do styoo do, por lëë xaa beety, aan lëë do xsaa chu paa. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Por ngo nladzy Dios: “Lëën kxal profet ni apostle, aan lëë meñ kuty xaa, ni lëë meñ kyënlaag xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lo meñ nii nche natiemp kuuñkiy Dios kchë profet nii noyuty meñ destye nii kwche kislyu, ");
INSERT INTO ztqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","destye Abel axte Zacarías, xaa nii beety meñ kexka lo pkoog leñ lidzy Dios. Kyëkiy meñ nii nche natiemp. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Chooksye lëë doy, maestre ley nii chuuñ xcheñ do xtiits Dios, aan xyeñdy tow, ni xlaady kaa to kyeñ meño! ");
INSERT INTO ztqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tsiñee lëë Jesús lox kwnee kchë ngo, lëë maestre ley ni lëë xaa fariseo blëë. Aan ndaly nii kwnabtiits xaa lo Jesús par kisyeedy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nladzy xaa nyuuñ knee xaa Jesús tu tiits nii nchilo nguëëkiy xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mentre gaa lëë meñ ptyopbe, lika xtyaagw meñ. Tsigo lëë Jesús kwnee klo lo xpëëdscuel, chëb xaa: —Kol kap cuent nii kakty to sinak xaa fariseo, por chuuñtsyeydy xaa nii xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Por nody ni tu cos ngueetsy nii kchukëdy, ni nody ni tu cos nii chak tsilaan nii kak ndoondy. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Singo gak kchë nii kwnee do lo nguey, lëëw kñee meñ xña lo xbini ngbidz. Nikle gaa kchë nii kwnee tsilaan do worñee nyoogw yu, lëë meñ tsëp kik lidzy aan lëëw kuptsyë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ktsyebty to xaa nii chuty, por tsiñee lox kuty xaa lëë do chilodre pe kuñ xaa lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sink kol ktsyeb xaa nii schilo kuty lëë do ni schilo kxaal lëë do linfiern. Xaa go kol ktsyeb. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Pe lëdy xaktyee chop centab nayak non kaay mguiñ wiñ?, aan ni tu ma xnitylasty Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lëë lëë do axte kits kik to ngab lo Dios. Por ngo, ktsyebty to, por mastre non do lo mguiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Nli xñen nii kchë meñ nii kchoo xfavoraa lo kislyu re schon xfavor meñ go tsi lëë meñ go klyañche lo xangly Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per lëë meñ nii kchoody xfavoraa lo kislyu re, ni naa kchoody xfavor meñ go lo xangly Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Axte meñ nii ko falt lo mguiy nii pxaal Dios kuñ Dios perdón, per kuñdy xaa perdón meñ nii ko falt lo Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Tsiñee lëë meñ tsini lëë do leñ ktoo ni tsikso lëë do lo xaa xñabey par jkëëkiy meñ do, pe tsinidy kik to nii dyon xa kñee do o pe këëb kaa to. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Por tsiñee tsitsib kñee do, lëë Kyalbini Ntson kñë pe cos këb to. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tsigo lëë tu xaa nii no lady meñ chëb lo Jesús: —Maestre, kudzy lo betsyaa nii kuuñ grol xaa nii psaan pxosyaa loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Lëë Jesús kwëb chëb: —¿Cho në lool nii xtisyaa o xaa nii gaa chuuñ grol cos nakaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lëë gak Jesús chëb: —Kol kap cuent. Kak kpiñdy to, por syoobty no kislyu re parñee tsyaap no tubtsoon cos. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Loxsye ngo lëë xaa pso cuent re, chëb xaa: —Kwyo tu rikw nii singootyee kok xkwaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","aan nladzy rikw: “¿Xa kuñaa? Kindy pa kotseyaa nii ptyop lo xkwaan.” ");
INSERT INTO ztqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aan lëë gak rikw chëb: “Nanaa xa kuñaa. Lëën ktsily yu nii chotsey nii xtyop lo xkwaan, aan lëën ksa stu nii mastre ngol, parñee kotseyaa kchë nii ptyop lo xkwaan ni kchë nii chaapaa leeñgo. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Loxsye ngo misme naa këp lon: Biño gaanoo. Pxiladzy ni ble, por skaa kchë nii chapoo par kaawoo ni kil ndaly iz.” ");
INSERT INTO ztqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per lëë Dios chëb: “Natsypee ngueyoo. Na kyool kazh lëël kety. Aan ¿cho kyaani kchë nii ngotseyoo?” ");
INSERT INTO ztqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Singo xtsyool meñ nii xtop cos lo kislyu re, per lëë lo Dios, ni tu pe chapty meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Loxsye ngo lëë Jesús chëb lo xpëëdscuel: —Lëën xñe kchë nrii lo do parñee tsody to kyalnë nii dyon pe kaw do par kpañ do, ni tsody to kyalnë nii dyon pe kakw to. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Por mastre non kyalmbañ lo nii ktyaaw, ni mastre non xcuerp no lo ladx. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kol kan myak gaanoo. Chandy ma, ni xlaapty ma, ni xkotseydy ma nii ktyaaw, per lëë Dios xyaan ma. Aan ¡mastre non do lo ma! ");
INSERT INTO ztqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nikxe xaapre gaa tsoxko do, per ni tu wor chilody kiskool do lo tse nii no kpañ do. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Deel ni ngo chilody to kuuñtsyey do, ¿penak nii choxko do por cos nii jkiiñ do? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Kol kuy gaanoo xa xroob kyoo aan xkyëdyo tsiiñ ni xkibtyo ladx. Aan ni rey Salomón kokwty tu ladx ntson nii ntson si ntsono. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Deelñee Dios tsigo busy xkakw xab kchë kizhyë nii no tañ aan xlyëdyak lëëw chek lo ki, ¿penak nii xnilasty to nii lëë Dios jkakw xab to? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Por ngo, kteenëdy to nii dyon pe kaw do o ki gaa to. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kchësy cos re no meñ nii xnilasty Dios kyalnë, per lëë lëë do nanle Tat Tios nii sob kpaa pe cos chak falt lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kol kuuñtsyey nii xñabey Dios tsiin kxaal xaa kchë nii jkiiñ do. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ktsyebty to, por nikxe ndalydy to, lëë Tat Tios bneetsy tiits nii wi do kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kol kto kchësy nii chap to, ni kol kteedyo lo meñ nii no lyaadzy, aan kol kweek mbës ngoch nii koxty, por ndaly nii jkaa do kpaa, aan kindy nkwxog siko ni kindy ngbaan. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Por laañee no nii chap to siko xyo styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’List kol kwe, kol kakw xab to, ni kol jkëë xbini do. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kol kwe si xkwe mos nii këmbës patrón nii si lo tu kyalwtsiilña, parñee siikñee kseetsy patrón chu yu, lëë mos kxalyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dichos mos nii nixna tsiñee lëë patrón kpikche, por nli xñen nii lëë patrón këb lo xaa: “Kwsob lo mezh”, aan lëë patrón kyë nii kaw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dichos mos nii nixna nikxe ktsiñ patrón wrol kyool o wor tempran gaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ni nli gaa xñen nii deelñee kyeñ tu xpixwan yu pa wor tsi ngbaan lidzy xaa, klaady xaa sëëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Singo gak, lëë do, ligier kol kak, por lëë mguiy nii pxaal Dios kiid mer worñee pe sidy kik to. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsigo lëë Pedre kwnabtiits lo Jesús chëb: —¿Pe nonsy loo noo psool cuent re ote wi lo kchësy meño yak? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lëë Jesús chëb: —¿Cho xsaan patrón lidzy dyon tsiñee lëë xaa xchoo? ¿Pe lëdy nayak xsaan xaa tu mos nii xsoob tiits parñee kyaan mos ko kchë meñ nii xkyë tsiiñ lo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dichos mos nii xyaani lidzy xpatrón deelñee tsiñee kpikche patrón, kan xaa nii lëë mos ko beeñtsyey kchë nii kwnabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nli xñen, nii lëë patrón këb lo xaa: “Kop cuidad kchësy nii chaapaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per deelñee mal mos ko ni nan xaa nii xtse si xpatrón xaa, lëë xaa ksaksi kchë meñ nii xkyë tsiiñ lo xpatrón xaa, ni lëë xaa tso wagw ni lëë xaa kyë kunip. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Per mer tse nii pe sinidy kik xaa, lëë xpatrón xaa ktsiñ, aan lëë patrón ksaksi xaa sinak xsaksi patrón kchë mos nii xsoobty tiits. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Deelñee nan mos pe cos chakladzy patrón, aan xsoobty mos tiits, ndaly golp jkaa mos. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per deelñee nandy mos pe cos chakladzy patrón aan ko mos falt, xisy golp jkaa mos. Por deelñee ndaly nii byaani meñ, ndaly nii kak wnab lo meñ. Deelñee ndaly gaa cos nan meñ, ndaly nii no kuuñtsyey meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Lëën syely kuñ kyalxtisy lo kislyu. Nak nii kuuñtsyeyaa sinak tsiñee chek ki, ni ¡xsyaak gaan naaty tsek kaa kislyu! ");
INSERT INTO ztqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","No nii teedyaa lo tu kyalnë dox, aan ¡mban xtee styoon nii lëën ktsyool kyalnë go! ");
INSERT INTO ztqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Këbty to tsaaplaa syelyaa lo kislyu re parñee tsodre tily. Lëdyo gon, sink lëën syelyni tily. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Por destye natse, deelñee no kaay meñ tu yu, lëë meñ kak chop tiiy. Tublad tso tson meñ, lëë stublad tso chop meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lëë mëëdpkiy ktilyni pxosy, ni lëë mëëd kwnaa ktilyni xñaa, ni lëë nkwxizh ktilyni xñaatsaap. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Loxsye ngo lëë Jesús chëb lo meñ: —Tsiñee chan do nii lëë xkey no nëz laa chaasy ngbidz, xñee do lëë kyo kyab, aan nli gaa xyabo. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Singo gak tsiñee xpi me nëz kyety xñee do lëë naay kak, aan nli gaa chako. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Nguey do! Deelñee xyeñ do xa chak leñ kpaa tsiñee lëë kyo kyab, ni xyeñ do xa chak lo kislyu tsiñee lëë naay kak, ¿penak nii xyeñdy to xa nak kchë cos nii noyak natiemp? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Penak nii xyeñdy to pe cos nonguial kuuñtsyey do? ");
INSERT INTO ztqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Deelñee xkëëkiy tu xaa lëë do aan chakladzy xaa tsikso xaa lëë do lo xtisy, kol nee lo xaa lëë ka bii xteedyo tiits. Por deelñee kyab to ña xtisy, lëë xtisy këb lo mayor: “Kol ko xaa gue skiib”, aan lëë xaa ko lëë do skiib. ");
INSERT INTO ztqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aan xsobaa nii kchoodyoo skiib axte nii kizhoo lal nii kñab xaa lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Misme tse go lëë bla xaa kukan Jesús aan lëë xaa bitiits nii lëë Pilat beety bla meñ Galilea aan lëë xaa pkots xcheñ meñ go xcheñ ma nii kwlokon xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tsigo lëë Jesús chëb: —Nladzy to nayak nii ptsyool xaa go ngo porñee mastre no xtol xaa que xtol xaa xtañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lëdyo gon. Ni lëën xñe kaazhkaa lo do nii deelñee kpikchedy styoo do lo Dios, wi do kety. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Ni pe nladzy to nii mastre no xtol ksa tsiimtson xaa nii byab yu ngol nii lë Siloé lady que xtol kchësy meñ nii no Jerusalén? ");
INSERT INTO ztqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lëdyo gon. Ni lëën xñe kaazhkaa lo do nii deelñee kpikchedy styoo do lo Dios, wi do kety. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lëë Jesús bitiits nrii lo meñ, chëb xaa: —Tu xaa name sob tub xan yag yegw lady xyag uv xaa, aan lëë xaa kukuy dyon pe kë yegw low, aan ni tu yegw ptsyoldy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsigo lëë xaa chëb lo xaa nii xkyënap kchë xyag uv xaa: “Buy gaanoo, lëëw kak tson iz nii xyely kyubaa yegw lo yag re, per lo ksa iz ko ni tu xnexo karty kawaa. Pchugo masy, por xaktyee xlyëw lo kwaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Per lëë xaa nii xkyënap kwaa kwëb chëb: “Xey, psaansyew na iz. Lëën ksoly xano ni lëën ko pyëëb xano, ");
INSERT INTO ztqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tsiin tsaaplaa skyë nex low singo. Aan deelñee kyëdyo, mansye kchugloo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tu tse nii xiladzy meñ Israel lo tsiiñ lëë Jesús beeñ kseedy meñ leñ ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aan lady kchësy meñ no tu kwnaa nii kwlox tsiimtson iz xsyaknë. Tu kyalbini mal beeñ me chop xkwaa, aan pchilodre nyak tubli me. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tsiñee lëë Jesús kon me, lëë xaa kwtsyetsy me aan lëë xaa chëb: —Kwnaa, lëël byak, xsyaknëdroo. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tsigo lëë xaa pxob ña xaa lady me, aan wor go kazh lëë me byak tubli, aan lëë me bislo biily me lay lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per lëë xaa nii xñabey leñ ktoo blëë, porñee beeñ kyak Jesús me tse nii xiladzy meñ Israel lo tsiiñ, aan lëë xaa chëb lo meñ: —Xoop kpidz nonguial kak tsiiñ. Kol të leñ tse go par kak to rmedy, kiijty to tse nii chakty tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsigo lëë Jesús kwëb chëb: —Mal do. ¿Pe chinidy to xyosy to kunis nayak o xburr gaa to nikxe chakty tsiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lëë kwnaa re gon lo xtiiy Abraham sëëd me, aan kok tsiimtson iz nii nguëëtuu xaatox me lo kyalkits re. ¿Pe nonguialdy nayak laa me nikxe tse nii chakty tsiiñ nak? ");
INSERT INTO ztqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tsiñee lëë Jesús chëb ngo, lëë xaa nii xlëë lo xaa pteladzy, per kchësy meñ ble kon kyalntson nii beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lëë gak Jesús chëb: —¿Pe cos nak sinak laañee xñabey Dios dyon, ni pe cos chak si chako? ");
INSERT INTO ztqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nako gon sinak tu medzy martas nii chan meñ lo kwaa aan tsiñee lëëw chak lal tu yag, lëë mguiñ xko xipchoos loo go. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Lëë gak Jesús chëb: —¿Pe cos nak sinak laañee xñabey Dios dyon? ");
INSERT INTO ztqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nako gon sinak levadur nii xkëë kwnaa tson lmud riñ par tsobe kchësy kobyi. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Worñee lëë Jesús no nëz si xaa Jerusalén, beeñ kseedy xaa meñ kyedzy ni tañ nii kwtedy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aan lëë tu xaa kwnabtiits lo xaa chëb: —Xey, ¿ndalydy meñ lë xtyelaa lo tol? Lëë Jesús chëb: ");
INSERT INTO ztqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Kol ktee nii sëëb to laañee xñabey Dios, por nako sinak tu puert nya aan ndaly meñ kakladzy sëëb, per kchilodyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Loxsye ksuugw xpixwan yu puert, deelñee kyaan do ley lëë do këb: “Xey, pxaly chu yu syëëb noo.” Per lëë xaa kñë lo do: “Nandyaa cho xaa do.” ");
INSERT INTO ztqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsigo lëë do këb: “Ptyaawni noo ni ptyowni noo lii, ni beeñ kseedyoo meñ nëz laa no noo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per lëë xaa kyëb kñë xaa: “Lëën niyle nii nandyaa cho xaa do. Kol kyey por ngoptol do.” ");
INSERT INTO ztqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tsigo lëë do koon ni lëë do kaw lay do tsiñee kan do nii lëë Abraham ni lëë Isaac ni lëë Jacob ni lëë kchësy profet ncheno laañee xñabey Dios, aan lëë do byaan ley. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Por ndaly meñ nii nche tyub lo kislyu sob kaw laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tsiñee lëë tse go tsitsib ndaly xaa nii nyats chak nina kyablyu parñee ktaan xaa nii mban nina. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Loxsye ngo lëë bla xaa fariseo ptsiñ, aan lëë xaa chëb lo Jesús: —Bi nu, porque lëë Herodes chakladzy kuty lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tsigo lëë Jesús chëb: —Kol tsi aan kol këb lo mëz wnee xuuy go: “Natsesy ni kxesy kwin kyalbini mal ni kuuñ kyakaa meñ xsyaknë, widzy lëën kyal.” ");
INSERT INTO ztqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per no nii ktsiñaa laañee san natse, kxe ni widzy. Por ni tu profet chilody kety deelñee sody xaa Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Chooksye lëë doy nii no do Jerusalén! ¿Penak nii chuty to profet ni penak nii xlaal kyo do xaa nii xaal Dios lo do? ¡Ndaly vuelt kokladzyaa ndopaa to sinak xtop nguidy xoob xiñ leñ xikw, per kwnëdy to! ");
INSERT INTO ztqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lëë na lëë xkyedzy to kyaanladzy. Ni kpikchedre kan do naa axte tse nii lëë do këb: “Skizh Dios, xaatke buen xaa nii pxaal xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tu tse nii xiladzy meñ Israel lo tsiiñ lëë Jesús kwey wagw lidzy tu xaa nii xñabey lo meñ fariseo, aan lëë stubla xaa fariseo bleetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Siko lëë Jesús kon tu xaa xsyaknë nii xchooki. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lëë Jesús kwnabtiits lo maestre ley ni lo xaa fariseo chëb: —¿Pe nonguial dyon kak tu xaa xsyaknë rmedy tse nii chakty tsiiñ ote nonguialdyo yak? ");
INSERT INTO ztqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per ni tu xaa kwneedy. Tsigo lëë Jesús kwseñ xaa xsyaknë go aan loxsye beeñ kyak xaa xaa, lëë xaa chëb: “Byey.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ni lëë xaa chëb lo meñ fariseo: —Deelñee kyab tu xiñ do o tu xyosy kaa to leñ tu kyeech nxity, ¿pe kwiidy to xaa nayak ni pe kwiidy to ma nikxe chakty tsiiñ tse go? ");
INSERT INTO ztqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aan ni tu xaa pchilody pe nyëb. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tsiñee kon Jesús nii kchësy xaa nii koktsyetsy xkwe yagxily nii xsyob xaa non, lëë xaa ptee tu consef lo meñ chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Tsiñee tsi do laañee chak tu kyalwtsiilña, sobty to laañee xsyob xaa non, por toontlaa tsi stu xaa nii mastre non lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aan kñë xaa nii kwtsyetsy lëë do: “Pte xlugaaroo lo xaa re.” Tsigo lëë xkyalto do kchoo por lëë do tsisob axte lultime bankw. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Masy tsiñee tsi do lo tu lni, kol sob axte lultime bankw parñee tsiñee kan xaa nii kwtsyetsy lëë do to, kñë xaa: “Penak nii soboo ske. Tësoboo axte klaa.” Singo mod xña lo kchësy meñ lëë do klisklaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porque kchësy xaa nii xalyga chak nyaa kyablyu aan lëë xaa mban kyak klaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lëë gak Jesús chëb lo xaa nii kwtsyetsy xaa: —Tsiñee kuuñlool tu siily o tu xtsee gaa, kwëstyoo xamiigwoo, ni betsyoo, ni meñ liidzyoo, ni meñ rikw nii no kex chiliidzyoo, por toontlaa kwetsyak xaa lii aan singo mod lëë xaa ktikche favor nii beeñtsyeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Masy tsiñee kuñoo tu lni, kwtsyetsy kchë meñ prob, ni meñ nii chilody së, ni meñ nii chandy. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Por chilody ktikche meñ go kyalnsaak ko lool, per lëë Dios kuuñ kle lii ni lëë xaa ktikche favor go lool tse nii lëë xaa kuuñ kpañ meñ kuty nii beeñtsyey kyalbuen. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Loxsye biñ meñ ngo, lëë tu xaa nii wi sob lo mezh chëb lo Jesús: —Dichos meñ nii chaw laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tsigo lëë Jesús chëb: —Tu xaa name beeñlo xaa tu niskwaan aan ndaly lo meñ chëb xaa nii tsi meñ wagw. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tsiñee lëë xwor wagw kol, lëë xaa pxaal xmos xaa kukëb lo meñ nii koktsyetsy: “Kol të por lëë niskwaan lox koklo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per xaal xaal nii chëb meñ parñee tsidy meñ. Klosy lo tu xaa nii kwey mos chëb: “Lëën kal lox kwxi tublë lyu, aan no nii kakuyaa loo go. Chilody kan.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Lëë stu xaa chëb: “Lëën kwxi kaay nëz yosy aan lëën kakuñ ma preb. Chilody kan.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Lëë stu xaa chëb: “Lëën kal ptsiilña. Chilody kan.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tsiñee lëë mos bikche, lëë xaa chëb kchë nii chëb meñ, aan lëë xaa nii pxaal xaa blëë. Tsigo lëë xaa chëb lo xmos xaa: “Sinusy kwey kchë nëz yu ni nëzniy nii no leñ kyedzy, aan tëni kchë meñ prob, kchë meñ nii chilody së, ni meñ ciegw.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Blyëëdyako, lëë mos chëb: “Xey, lëën beeñtsyey nii kwnabeyoo naa, aan lëë lugar bii no.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tsigo lëë xaa chëb lo mos: “Kwey nëz nii xchoo chu kyedzy ni kwey kchë skiñ kwraly, aan tëni xoo stubla meñ parñee kyaktsë lidzyaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Por ni tu meñ nii kwtsyetsyaa klo kawdy niskwaan nii beeñloon.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndaly meñ kunal Jesús aan lëë xaa byoogw chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Deelñee no tu xaa nii sëëdnal naa aan mastre xkëstyoo xaa pxosy xaa que naa o mastre gaa xkëstyoo xaa xñaa xaa, tsiil xaa, xiñ xaa, betsy xaa ni psyañ xaa, o xkëstyoo gaa xaa lëë xaa, chilody kak xaa xpëëdscuelaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ni chiloody kaa kak meñ xpëëdscuelaa deelñee tejty meñ lo kyalnë ni deelñee kiidnaldy meñ naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Deelñee no tu do chakladzy ksaa tu yu ngol, ¿pe xsyobty to nayak kwii do cuent parñee kan do dyon pe slëb to ksaalo dow? ");
INSERT INTO ztqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Por deelñee xaktyee kyeeñ do cimient, aan lëbty to ksaalo dow, kchësy meñ nii kano kxidzyni lëë do, ");
INSERT INTO ztqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","këb meñ: “Lëë xaa re bislo nsaa lidzy, per kwlëbty xaa nsaalo xaaw.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O deelñee gaa no tu rey nii tsiktily contre stu rey, ¿pe xsyobty xaa nayak kwii xaa cuent parñee kan xaa dyon pe slëb tsii mily soldad nii chap xaa ktily contre kaly mily xsoldad stu rey? ");
INSERT INTO ztqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aan deelñee kyeñ xaa nii lëbty xsoldad xaa, bii sitre sëëd stu rey, lëë xaa kxaal xaa nii tsikëb: “Masy kwës tily.” ");
INSERT INTO ztqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Singo tsigo busy, deelñee ksaandy to kchë nii chap to, chilody kak to xpëëdscuelaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Buen sedy. Per deelñee ksaan sedy xinxiyo, ¿xa kyak nxiyo stub? ");
INSERT INTO ztqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lëëw ksyëëb porñee ni par lyu ni par pyëëb xkiiñdyo. Deelñee chakladzy to kyeñ do, kol jkëëtyag. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lëë xaa nii xtop tumi nii xyey Roma ni lëë stubla xaa ngoptol big par jkëëtyag xaa xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Por ngo lëë xaa fariseo ni lëë maestre ley kwneenë Jesús, chëb xaa: —Xtsiil lsa xaa gue meñ ngoptol ni chaw xaa ksa xaa meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsigo lëë Jesús pso tu cuent lo meñ chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Deelñee chap to tu kyoow mëkwxiily dyon, aan xnity to tu ma, ¿pe xsaandy to stap kalyptsiipkee ma nii kwnijty tañ nayak, aan chikyub to ma nii kwnity, axte nii xtsil do ma? ");
INSERT INTO ztqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aan tsiñee lëë ma xtsil do, xle do xob to ma chu yañ do, ");
INSERT INTO ztqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aan tsiñee lëë do xtsiñ lidzy to, xtop to kchë xamigw to ni kchë meñ nii no kexka chilidzy to, aan xñee do: “Kol kle lon, por lëën ptsil mëkwxiily nii kwnity.” ");
INSERT INTO ztqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nli xñen nii mastre kak wle kpaa por tu meñ ngoptol nii ktikche styoo lo Dios que por tapkalyptsiipkee meñ buen nii xkiiñdy ktikche styoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Kol tsoo kso no xcuent tu kwnaa nii chap tsii pes plat, aan xnity me tuwo. ¿Pe xkëëdy me bini nayak ni pe xloobty me yu ni pe xkyëkyubty mew axte nii xtsil mew? ");
INSERT INTO ztqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aan tsiñee lëëw xtsil me, xtop me kchë xamigw me ni meñ nii no kexka chilidzy me, aan xñee me: “Kol kle lon, porque lëën ptsil pes plat nii bnityaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nli xñen nii singo gak xle kchë angly nii no kpaa tsiñee xtikche tu xaa ngoptol styoo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Lëë gak Jesús bitiits nrii lo meñ, chëb xaa: —Tu xaa name chap xaa chop xaa wiñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","aan lëë xaa nii mastre nyab chëb lo pxosy: “Pa, neetsy kchë nii xyalaa.” Tsigo lëë pxosy xaa kwtiisy kchë nii chap. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kok xtsedyako lëë xaa nii mastre nyab pto kchësy nii pchal, aan con tumi go lëë xaa si stu tañ nii sit. Siko pxiñ xaa kchë xtumi xaa laañee xkaatyee. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Per tsiñee lëë xaa lox pxiñ xtumi xaa, lëë kpiñ kwyo tañ go, aan lëë xaa kwte kpiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tsigo lëë xaa kunab tsiiñ lo tu xaa nii no tañ go, aan lëë xaa go pxaal xaa lo kwaa kukap xaa ngutsy. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ptee gan xaa nyaw xaa nii chaw ngutsy, per ni tu cho pteejtyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Lëë lultime nladzy xaa: “¡Blaktre gaa meñ nii kë xtsiiñ pxosyaa na axte xyely chaw, lëë naa na noteedy kpiñ nu! ");
INSERT INTO ztqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lëën kya lidzy pxosyaa, aan këpaa: Papá, kwlon falt lool ni lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nonguialtre kakaa xiñoo. Beeñ cuent nii sinak tu xmoosoo nakaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Loxsye ngo lëë xaa pkaa nëz, lëë xaa sey lidzy pxosy xaa. ’Bii sitre siid xaa tsiñee lëë pxosy xaa kon xaa, aan lëë pxosy xaa pkëstyoo xaa. Lëë xaa kwloo corr kuktsiil nëz xaa xiñ xaa, aan lëë xaa kwteetsy xaa, ni lëë xaa taw pxit kwesy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tsigo lëë xiñ xaa chëb: “Papá, kwlon falt lo Dios ni lool. Nonguialtre kakaa xiñoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per lëë pxosy xaa chëb lo xmos: “Sinusy kol kwii ladx buen jkakw to xaa, kol ko tu nily ña xaa, ni kol jkëë lab xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kol tëni tu becerr nii xro aan kol kuty ma, por ¡lëë no tyaaw ni lëë no kuuñ lni! ");
INSERT INTO ztqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Por nladzyaa te kuty xiñaa, per kujty xaa. Kwnity xaa, per lëë xaa ptsil.” Aan lëë lni bislo. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Mentre lëë stu xiñgan xaa nii nak xaa kol këno tañ. Tsiñee lëë xaa bikche, lëë xaa biñ ti ni lëë xaa kon nii lëë wyëë kayak. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lëë xaa kwtsyetsy tu mos, aan lëë xaa kwnabtiits pe cos chak. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tsigo lëë mos chëb: “Lëë betsyoo blañ, aan lëë pxoosyoo kwnabey kuty becerr xro, porñee mbëë blañ xaa ni ndaan xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per lëë betsy kol xaa blëë, aan kwnëdy xaa nyo xaa yu. Por ngo lëë pxosy xaa pchoo kwnee lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tsigo lëë xaa chëb lo pxosy xaa: “Nanoo gon blaktre iz nojkiiñaa lool ni nanoo nii tugak xsobaa xtiitsoo, aan ni tu chiv wiñ karty kneetsyoo par kawnin xamigwaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lëë nana nii blañ xiñoo nii kukxiñ xtumil lo kwnaa nii xkwe pal nëz, lëël chuty becerr xro par lëë xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tsigo lëë pxosy xaa kwëb chëb: “Xiñ, lii tugak so lon, ni kchësy kaa nii chaapaa xcheñoo nako. ");
INSERT INTO ztqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per no nii kuuñ no lni ni kle no, por lëë betsyoo nii kwxaak no kuty bikche. Kwnity xaa, per lëë xaa ptsil lo no.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Lëë Jesús bitiits nrii lo xpëëdscuel, chëb xaa: —Tu xaa rikw name kop xaa tu mos, aan lëë meñ kuni tiits lo xaa nii lëë mos ko no kxiñ xtumi xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsigo lëë patrón kwtsyetsy mos ko, aan lëë xaa chëb lo xaa: “¿Pe nli kchë nii këjkëëkiy meñoo dyon? Bneetsy cuent dyon xa si lo xtsiiñoo, porque chilodre kyëël tsiiñ lon.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tsigo nladzy mos ko: “¿Pe kuñaa na busy na nii lëë xpatrónaa kwii naa lo tsiiñ? Nodyaa fuersy par kyën tsiiñ tañ, aan xteladzyaa kñabaa limosn. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nanaa xa kuñaa parñee tso cho lidzy ktsiiñaa tsiñee lëë xpatrónaa kwii naa lo tsiiñ.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tsigo lëë xaa kwtsyetsy tuga tuga meñ nii nsëëb lo xpatrón xaa. Klosy lo tu xaa nii ptsiñ chëb xaa: “¿Palal nsëëboo lo xpatrónaa?” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lëë xaa go kwëb chëb: “Nsëbaa tu kyoow barrily aceit.” Tsigo lëë mos nii sinoy cuent chëb: “Naa xpagareel aan pkëë stuwo nii xaktyee choowptsii barrily aceit nsëëboo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Loxsye ngo lëë xaa kwnabtiits lo stu xaa, chëb xaa: “Liik, ¿palal nsëëboo?” Lëë xaa go kwëb: “Nsëbaa tu kyoow lmud xobxtily.” Tsigo lëë mos chëb: “Naa xpagareel aan pkëë stuwo nii xaktyee tapkaly lmud xobxtily nsëëboo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Psee patrón kon nii singootyee nyaani mos mal go. Nli xñen nii mastre nan meñ nii xyuumbeydy Dios xa nak cos nii chak lo kislyu re que meñ nii xyuumbey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Kol kiisy kchë nii chap to lo kislyu re parñee kap to amigw, parñee tso cho kneetsy laañee kwës to kpaa tsiñee lëë kchë nii chap to lox. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Kchë xaa nii chap cuidad cos nikxe ndalydyo, sap cuidad xaa cos ndaly, per lëë xaa ni chap cuidajty cos xisy, xa kap cuidad xaa cos ndaly. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Deelñee chap cuidajty to cos nii no lo kislyu re, ¿cho lë nii knee cos nii nli non lo do? ");
INSERT INTO ztqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aan deelñee chap cuidajty to xcheñ meñ, ¿cho lë nii kneetsy nii jkaa do? ");
INSERT INTO ztqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni tu cho chilody kyë tsiiñ chop lo patrón. Por neñdy slëë xaa lo tu xaa, lëë lo stu xaa kle xaa. O neñdy kaa ngui kuñ xaa xtsiiñ tu xpatrón xaa, aan ksaldy xaa stu xaa. Por ngo chilody ksoob to xtiits Dios deelñee tumi tugak sini kik to. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pxidzy xaa fariseo nii tir xyo tumi styoo biñ nii kwnee Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tsigo lëë Jesús chëb: —Chakladzy to nii këb meñ nii buen do, per nan Dios pe cos xsya styoo do. Por kchësy nii xsyak meñ non pa nondyo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Lëë xley Moisés ni lëë kchë profet bluuy xtiits Dios axte tse nii lëë Juan biid. Destye tse go lëë meñ xkëëtyag xa nak laañee xñabey Dios aan xoo xsyëëb meñ siko. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ni tu letre nii kë lo ley kyaanlasty. Kchësyo kak cumplir. Por nli xñen nii masy ngandy nitylo kislyu ni nitylo kpaa que nii kyaanladzy ley. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Deelñee klaa tu xaapkiy tsiil, aan ktsiilña xaa stu kwnaa, tol chuñ xaa. Singo gak xaa nii ktsiilña tu kwnaa nii psëëb tsiil le, tol chuñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Tu rikw name nonsyke ladx non ni ladx ngui chakw xaa, aan ksatyee tse chuñ xaa lni. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kwyo gak tu prob nii pcholë Lázaro. Xyodz lady xaa aan chisob xaa nëb lo lyu chilidzy rikw. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kokladzy prob re nyëly con cos nii xlyaal leñ xmezh rikw. Aan axte mëkw big kwlee lady xaa laañee xyodz. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lëë tu tse lëë prob kuty, aan lëë angly kukni xaa laañee no Abraham kpaa. Lëë rikw kutyak, aan lëë xaa pkyeetsy. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aan mentre lëë rikw no te mban laañee xyey meñ nii chety, lëë xaa blis lo xaa aan lëë xaa kon nii lëë Lázaro so lo Abraham. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsigo lëë xaa kwchuptsyë, chëb xaa: “Tat Abraham, pkëstyoo naa. Pxaal Lázaro tsijkadz xaa punt xkweñ lo nis aan kiid ksalyu xaa lo ludzyaa, porque tir mban no teedyaa lo ki re.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Per lëë Abraham kwëb chëb: “Xiñ, psaladzy gaanoo nii mbëë kwtedyoo lo kislyu, lëë Lázaro mban kwtedy xaa. Lëë na mbëë notedy xaa nu, lëë lii mban notedyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ni chilody gaaw, por tir ngol yoo nii kë groltyee, aan chilody kiid meñ nii no nu ske, ni meñ nii no gaa ske chilody kiid nu.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tsigo lëë rikw chëb: “Xñabaa lool tsigo busy, Tat Abraham, nii kxaaloo Lázaro lidzy pxosyaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","parñee kñee xaa lo kaay betsyaa nii byaan tsiin kiijty xaa laañee sinriityee mban noteedyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tsigo lëë Abraham chëb: “Lëë nii pkëë Moisés ni pkëë kchë profet byaanle. ¡Ksal xaa kchë ngo!” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ksaldy xaaw”, chëb rikw, “per deelñee kyaklo tu xaa nii kutyle lo xaa, spikche styoo xaa lo Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lëë Abraham chëb: “Deelñee chaklasty xaa ksal xaa xley Moisés ni kchë nii pkëë profet, nikxe kpañ tu meñ kuty, kpikchedy styoo xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Lëë Jesús chëb lo xpëëdscuel: —Tugak ktee tiits nii kyab meñ lo tol, per ¡brobsye xaa nii ksyaab meñ lo tol! ");
INSERT INTO ztqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Masy buen kxituu tu kyomoliñ yañ xaa aan tsikchon meñ xaa lo nistoo que nii kuñ xaa xtol meñ nii xniladzy xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kol kap cuent. ’Deelñee ko betsy to falt lo do, kol nee lo xaa, aan deelñee kpikche styoo xaa, kol kuñ xaa perdón. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nikxe ko xaa falt lo do kadzy vuelt tu kpidz, deelñee ksa kadzy vuelt ko kiid në xaa lo do: “Kpikchedraa kon falt lool”, no nii kuñ do xaa perdón. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Lëë apostle chëb lo Jesús: —Chakladzy noo nii mastre kniladzy noo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tsigo lëë Jesús kwëb chëb: —Deelñee niladzy to Dios, xisy wiñak, nikxe nyak xkyalwniladzy to lalak tu medzy martas, nchilo nyëb to lo yag re: “Bichee nu aan kusob lo nistoo”, aan lëë yag nsoob xtiits to. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Deelñee chap to tu mos nii chikon o chikap kaa ma, ¿pe xñee do lo xaa nayak tsiñee xpikche xaa: “Kwte të soboo kaawoo”? ");
INSERT INTO ztqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lëdyo gon, sink xñee do lo xaa: “Beeñlo tu xtseen ni kwtëë nii kawaa ni kin. Loxsye kawaa schilo soboo kaawoo ni kil.” ");
INSERT INTO ztqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aan ni skizh xteejty to lo mos nii beeñtsyey kchë nii kwnabey do. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Singo gak lëë do, tsiñee lox kuuñtsyey do kchë nii xñabey Dios to, no nii këb to: “Mos nii pa xkiiñdy nak no, por xaktyee nii pchilo lo no beeñtsyeey no. Beeñtsyeeytre no pe stu cos.” ");
INSERT INTO ztqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lëë Jesús kwte laañee ntsiil meñ Samaria ni meñ Galilea worñee lëë xaa si Jerusalén, ");
INSERT INTO ztqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","aan lëë tsii xaa xsyaknë nii xyodz lady kuktsiilnëz Jesús kyedzy nii ptsiñ Jesús, per big kexty xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sink lëë xaa kwchuptsyë, chëb xaa: —¡Jesús, lii nii nakoo maestre, pkëstyoo lëë noo! ");
INSERT INTO ztqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tsiñee lëë Jesús kon ksa xaa go, lëë Jesús chëb: —Kol tsi lo pxosy. Aan nëz si xaa lëë xaa byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tsiñee kon tu xaa xsyaknë go nii lë xaa byak, lëë xaa bikche xtee xaa skizh lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aan lëë xaa psoxib lo Jesús, axte pkiitsy kë xaa lyu par ktee xaa skizh ni lëëw na xaa Samaria nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsigo lëë Jesús chëb: —¿Pe lëdy tsii xaa xsyaknë nawen byak? ¿Ko skee xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Nonsy xaa sit re nawen bikche ktee skizh lo Dios? ");
INSERT INTO ztqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lëë Jesús chëb lo xaa nii byak ko: —Kuso aan byey. Por porñee bniladzyoo ngo nii lëël byak. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lëë xaa fariseo kwnabtiits lo Jesús pa wor klyañche xkyalwnabey Dios aan lëë Jesús chëb: —Kiijty xkyalwnabey Dios parñee kan dow. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni tu cho kñëdy lo do: “Lëëw nrii”, o “Lëëw nrek kaa.” Por lëë xkyalwnabey Dios kwlañchel lo do. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Loxsye ngo lëë Jesús chëb lo xpëëdscuel: —Sitsib tse nii lëë do kakladzy kan do mguiy nii pxaal Dios lo kislyu, aan kandy to xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","No meñ kñë lo do: “Lëë xaa so nu”, o “lëë gaa xaa so nek.” Per tsidy to ni tsinaldy to meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porque sinak tsiñee nyoo xbëly yë nkwsiy tyub leñ kpaa, singo kak mguiy nii pxaal Dios tsiñee lëë xaa kiid stub. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per no nii te kazh xaa kyalnë ni ksaldy meñ nii no natiemp xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sinak kok xtiemp Noé, singo gak kak tsiñee lëë mguiy nii pxaal Dios kiid stub. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tiemp ko lyaadzy wagwsye ni lyaadzy nii kisy meñ kwyo meñ, ni kyalwtsiilñasy kuni kik meñ, axte tse nii lëë Noé byo leñ barkw, aan lëë kchësy meñ go kuty lo kyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Singo gak kok xtiemp Lot: lyaadzy wagwsye ni lyaadzy nii kisy meñ kwyo meñ, ni wtosy ni wsisy kuni kik meñ. Lyaadzy konsye ni lyaadzy yusy kwyo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per tsiñee lëë Lot pchoo leñ kyedzy Sodoma, lëë ki ni kyo lëë nii xsaay byab kpaa, aan kchësy meñ go kuty. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Singo kak tsiñee lëë mguiy nii pxaal Dios kpikche. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tse go deelñee no cho do so kik yu aan no xcheñ do leñ yu, kyejty to par kwii dow. Deelñee no gaa to so tañ, kpikchedy to kyey do lidzy to. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kol ksaladzy nii ptsyool tsiil Lot. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kchë xaa nii kakladzy kteelaa xkyalmbañ kety. Per lëë xaa nii pe sinidy kik, nikxe kety xaa, lëë xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Kyool go deelñee nix chop xaa lo tugak lon, lëë Dios koy tu xaa, per lëë xaa ksaan stu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O deelñee gaa kë chop kwnaa wëët, lëë xaa koy tu me aan lëë xaa ksaan stu me. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Singo gak deelñee kë chop xaa tsiiñ tañ, lëë tu xaa kyooy, aan lëë stu kyaan. ");
INSERT INTO ztqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsigo lëë meñ chëb: —¿Pa kak kchësy nrii? Tsigo lëë Jesús chëb: —Laañee kaa ma kuty ktyop pech. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Loxsye ngo lëë Jesús pso tu cuent lo xpëëdscuel parñee këb xaa nii ktsagty xpëëdscuel xaa, sink tugak kutiitsni xaa Dios axte nii ktikche Dios lo xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sinrii së lo cuent ko: —Tu kyedzy name kwyo tu xtisy nii ptsyebty Dios ni psaldy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Leñ kyedzy ko gak kwyo tu kwnaa viud nii kunab kyalxtisy lo xtisy parñee ksaksi xaa meñ nii xlëë lo me. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xtse kwë me, per psaldy xtisy me. Lëë lultime nladzy xaa: “Nikxe nii xtsyeebtyaa Dios ni xsaldyaa meñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per como kety kety chiid kisyeedy me naa, lëën kcho xfavor me parñee kiijtre me, por toontlaa kloox me xpaciensyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Lëë Jesús chëb: —Singo gon chëb xtisy mal. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Lëë Dios dyon pe kchoody xaa xfavor meñ nii xniladzy xtiits xaa nayak deelñee tsel kyool xñab meñ kyalxtisy lo xaa? ¿Slaa xaa nawen kyëmbës meñ go xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Klyëëdy xaa gon, lëë xaa kchoo xfavor meñ go. Per tsiñee lëë mguiy nii pxaal Dios dyon kiid, ¿pe bii sanre xaa meñ nii xniladzy xtiits Dios lo kislyu re? ");
INSERT INTO ztqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lëë Jesús pso cuent re par xaa nii xsyak nii tir buen aan xsyablyu los demasy meñ, chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Tu vuelt kwey tu xaa fariseo ni tu xaa nii xtop tumi nii xyey Roma lidzy Dios par kutiitsni xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Lëë xaa fariseo kwsoli aan lëë xaa chëb lo Dios: “Tat Tios, xnetsyaa skizh lool, porñee naktyaa sinak xaa nii nak ngbaan, ni xaa mal, ni naktyaa sinak xaa nii no tsiil aan choni stu kwnaa, ni porñee naktyaa sinak xaa nii xtop tumi nii so ske. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naa chawdyaa chop vuelt tu leñ xmal par kuuñ ksakaa lii ni chuñaa kchë nii xtsiñaan tsii tant aan xtedyaa tu tanto jkiiñ liidzyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lëë xaa nii xtop tumi nii xyey Roma kwsosit aan byaxty xaa nlis xaa lo xaa kpaa, sink lëë xaa xtee golp styoo xaa xñee xaa lo Dios: “¡Tat Tios, pkëstyoo naa, por tu ngoptol nakaa!” ");
INSERT INTO ztqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nli xñen nii tsi lëë xaa nii xtop tumi nii xyey Roma bikche sey lidzy, lëë Dios beeñ xaa perdón, per lëë xaa fariseo kokty xaa perdón. Por lëë kchë xaa nii xaly chak nyaa kyablyu aan lëë xaa nii mban chak kyak klaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wi xaa wiñ kuni meñ lo Jesús parñee kxob Jesús ña kik xaa wiñ. Per lëë xpëëdscuel Jesús kwëntseeb lo meñ nii kuni xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Per lëë Jesús chëb lo xpëëdscuel: —Kol klaa kiid xaa wiñ lon. Jkady tow, por kchë meñ nii nak sinak xaa wiñ kyey laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nli xñen nii deelñee knilasty meñ xtiits Dios sinak xniladzy tu xaa wiño, sëëbty meñ laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Lëë tu xaa xñabey chëb lo Jesús: —Maestre buen, ¿pe cos kuuñtsyeyaa parñee jkan tu kyalmbañ nii nitylody? ");
INSERT INTO ztqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tsigo lëë Jesús chëb: —¿Penak nii xñeel nii bueenaa? Tugak xaa buen no. Lëë xaa go nak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nanloo nii xñabey xley Dios: “Kyubtyoo stu kwnaa deelñee no tsiiloo, kujtyoo, kwandyoo, kñeedyoo tiits kizh par ksaksil meñ, ni psal pxoosyoo ni xñaal.” ");
INSERT INTO ztqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lëë xaa go chëb: —Kchësy ngo noyuuñtsyeyaa destye nii nakaa xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tsiñee biñ Jesús nrii, lëë xaa chëb: —Tu cos bii chakoo falt: pto kchësy nii chapoo aan pkadyo lo meñ prob tsiin kchilo kapoo cos kpaa. Loxsye ngo të aan tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Per tsiñee lëë xaa go biñ ngo, mban ptee styoo xaa, porñee tir rikw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tsiñee kon Jesús nii mban kok xaa, lëë Jesús chëb: —¡Xaatee ngan sëëb rikw laañee xñabey Dios! ");
INSERT INTO ztqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Masy ngandy sëëb tu camey xan tu kyeech kuzh que nii sëëb tu rikw laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kchësy meñ nii biñ ngo chëb: —¿Cho lë nii telaa lo tol tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Lëë Jesús chëb: —Chilody telaa meñ nonsy, per lëë Dios kteelaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsigo lëë Pedre chëb: —Lëë noo psaan kchësy nii koop noo aan lëë noo syoopnaal lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tsigo lëë Jesús chëb: —Nli xñen nii kchë xaa nii psaan lidzy, tsiil, o betsy, o pxosy, o xiñ gaa par sëëb xaa laañee xñabey Dios, ");
INSERT INTO ztqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ndaly re nii jkaa xaa lo kislyu re aan lëë lo stu kislyu nii nare sëëd lëë xaa jkaa tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Lëë Jesús kwtsyetsy ksa tsiipchop xpëëdscuel tublad, aan lëë xaa chëb lo xaa: —Chan do gon nii lëë no syo Jerusalén, aan siko lëë kchësy nii pkëë profet nii ktsyoolaa nii nakaa mguiy nii pxaal Dios kak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lëë meñ jko naa ña meñ sit, ni lëë meñ kityni naa, lëë meñ kotsyetsy naa, ni lëë meñ kchoo mxeñ lon. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Lëë meñ kiñ naa ni lëë meñ kuty naa, per tse nii loxo tson kpidz lëën kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per byeñdy xpëëdscuel Jesús ngo, por nonsyke cos ngano. Nandy xaa penak chëb Jesúso. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lëë Jesús mer ktsiñ Jericó, aan lëë tu ciegw sob kex chu nëz xñab limosn, ");
INSERT INTO ztqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","tsiñee lëë ciegw biñ nii singootyee ndaly meñ xtyedy, lëë xaa kwnabtiits penak nii singootyee xtye meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Lëë meñ chëb lo xaa nii lëë xaa Nazaret nii lë Jesús sitedy siko. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aan lëë xaa kwchuptsyë chëb xaa: —¡Jesús, lii nii nakoo xiñ David, pkëstyoo naa! ");
INSERT INTO ztqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kchësy meñ nii sinech kwëntseeb lo xaa parñee nyoogw chuw xaa, per lëël mastre kwchuptsyë xaa xñee xaa: —¡Lii nii nakoo xiñ David, pkëstyoo naa! ");
INSERT INTO ztqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Lëë Jesús kwsotse, aan lëë Jesús chëb: —Kol tëni xaa nu dyon. Tsiñee lëë ciegw ko ptsiñ kex, lëë Jesús chëb lo xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Pe cos chakladzyoo? Lëë ciegw ko chëb: —Xey, chakladzyaa nii kña lon stub. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lëë Jesús chëb: —¡Lëë lool kña! Lëël byak, por bniladzyoo nii suuñ kyakaa lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wor go kazh lëë lo ciegw ko byak, aan lëë xaa sinal Jesús xtee xaa skizh lo Dios. Wi kchësy meñ nii kon ngo ptee skizh lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Lëë Jesús ptsiñ Jericó aan lëë xaa kwte leñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Leñ kyedzy ko kwyo tu xaa rikw nii pcholë Zaqueo. Lëë xaa kwnabey lo xaa nii xtop tumi nii xyey Roma. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kokladzy xaa nyuumbey xaa Jesús, per pchilodyo porñee tir ndaly meñ aan tir wiich Zaqueo. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Por ngo lëë xaa kwloo corr kwnech xaa, aan parñee kchilo kan xaa Jesús, lëë xaa kwyëp tu lo yag nii sob laañee notedy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tsiñee lëë Jesús sitedy xan yag ko, lëë xaa blëp lo lo yag, aan lëë xaa chëb: —Zaqueo, sinusy byety ske, por no nii kwësaa liidzyoo natse. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lëë Zaqueo byety wxooñ, aan xle xaa lëë xaa kuni Jesús lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tsiñee kon meñ ngo, lëë meñ kwneenë Jesús, xñee meñ nii lëë xaa kwlës lidzy tu ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lëë Zaqueo kuso, aan lëë xaa chëb lo Jesús: —Xey, lëën jkady grol kchë nii chaapaa lo meñ prob. Ni deelñee no cho lo kwlaanaa pe tu cos, lëën ktikche tap lal nii kwlaanaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lëë Jesús chëb: —Lëë Dios pteelaa kchë meñ nii no lidzy xaa re natse, por wi xaa ngab lo xtiiy Abraham. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Por lëë mguiy nii pxaal Dios sëëd kyub ni sëëd kteelaa kchë meñ nii no xtol. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lëë meñ pkëëtyag kchë nii kwnee Jesús, aan lëë xaa pso tu cuent, porñee lëë xaa mer ktsiñ Jerusalén, aan nladzy meñ nii lëë wor kutsiñ nii lëë Dios kñabey, ");
INSERT INTO ztqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","chëb xaa: —Tu vuelt name kwyo tu xaa non nii no kak rey, per no nii tsi xaa tu kyedzy sit parñee kak xaa rey. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Per antes nii kchoo xaa, lëë xaa kwtsyetsy tsii xaa nii xkyë tsiiñ lo xaa, aan lëë xaa ptee deel palal gaa tumi lo xaa go, chëb xaa: “Kol kyë dilgensy con tumi re axte nii kpikchen.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per como xtilyni meñ kyedzy xaa, lëë meñ kyedzy pxaal bla xaa nii kukëb: “Chaklasty noo nii kak xaa gue xrey noo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per lëë xaa kok rey, aan tsiñee lëë xaa bikche xkyedzy xaa, lëë xaa kwnabey kok tsyetsy ksa xaa nii ptee xaa tumi lo parñee kaknan xaa palal beeñ catu xaa go gan. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lëë tu xaa nii ptsiñ klo chëb: “Xey, lëë tumi nii bneetsyoo lon broob, lëëw byak tsii.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tsigo lëë rey chëb: “Buen ngo. Tir xaa tsiiñ nakoo. Ngui beeñ tsiiñoo tumi wiñ nii kwaal. Por ngo lëël kak xtisy. Tsii kyedzy kñabeyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lëë stu mos ptsiñ chëb: “Xey, lëë tumi nii bneetsyoo lon broob, lëëw byak kaay.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Lëë rey chëb lo xaa: “Lëël kak xtisy. Kaay kyedzy kñabeyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lëë stu mos ptsiñ aan lëë xaa chëb: “Xey, lëë xtumil nrii. Lëëw pkën lo tu bayjan. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Porñee ptsyeebaa lii, ni nanaa nii tir ntseeboo, por xtopoo nii kwleektyoo ni xlaapoo laañee kondyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tsigo lëë rey chëb: “Maaloo, misme xtiitsoo pteekyo lii. Deelñee nanoo nii tir ntseebaa, ni nanoo nii xtopaa nii kwlektyaa nii xlaapaa laañee kondyaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿penak kulodyoo xtumin bankw parñee neetsylo tyub xiño na nii lëën bikche?” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aan lëë rey chëb lo xaa nii nche siko: “Kol kla tumi lo xaa gue, aan kol kteedyo lo xaa nii nroob tumi ptsiñaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tsigo lëë meñ chëb: “Xey, per con nrooble tumi kwaa xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Lëë rey kwëb chëb: “Lëë meñ nii chaple cos jkaarew, per lëë meñ nii ni tu pe chapty, axte nii wiñ nii chapsye meñ go kpichee.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Loxsye ngo lëë xaa chëb: “Kol tëni kchë xaa nii koklasty nyakaa rey, aan xña lon kol kuty xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Loxsye bitiits Jesús kchë ngo, lëë xaa pkaa nëz par ktsiñ xaa Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tsiñee lëë xaa ptsiñ kex laañee ntsiil meñ Betfagé ni meñ Betania xan kiy nii lë Olivos, lëë xaa pxaal chop xpëëdscuel xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","chëb xaa: —Kol tsi kyedzy nii nyoo nu, aan tsiñee ktsiñ do, lëë do kan nii lëë tu burr këtuu. Ni tu cho karty sob lady ma. Kol klaa ma aan kol tëni ma. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aan deelñee kñabtiits meñ lo do penak nii xlaa do ma, kol këb nii naa jkiiñ ma. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lëë xpëëdscuel Jesús kwey, aan lëë xaa ptsyol burr nii chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lëë xaa no klaa burr tsiñee lëë xpixwan ma chëb: —¿Penak xlaa do ma? ");
INSERT INTO ztqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tsigo chëb xaa: —Lëë xmaestre noo jkiiñ ma. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lëë xaa biy burr aan tsiñee ptsiñ xaa lëë xaa pxob xab xaa lady ma parñee sob Jesús ma. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aan tyub nëz nii notedy Jesús ptañ meñ xab. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aan tsiñee lëë xaa sisëëb chex kiy nii lë Olivos, lëë meñ nii ksa xaa si bislo xle ni xtee skizh lo Dios por kchë kyalntson nii beeñtsyey Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nguieex kwnee meñ: —¡Lëë Dios pxaal tu xaa nii kak xrey no! ¡Byinayk rey! ¡Skizh Dios nii sob kpaa! ");
INSERT INTO ztqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsigo lëë bla xaa fariseo nii no lady meñ chëb lo Jesús: —Maestre, kwëntseeb lo xaa nii sëëdnal lii parñee kñeedre xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Per lëë Jesús chëb: —Deelñee kyoogw chuw kchë meñ re, lëë kyo kñee xcuent meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tsiñee lëë Jesús ptsiñ kexka Jerusalén, lëë xaa biiñ por kchë meñ nii no leñ kyedzy ko, ");
INSERT INTO ztqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","chëb xaa: —¡Chooksye lëë doy, naaty xaatsye nyeñ do xa nak xkyalwtelaa Dios siquier natse! Per lëë na chilody kyeñ dow ni chilody kan dow. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Por sitsiñ tse nii lëë xaa nii xlëë lo do ksuugw kwraly lëë do, aan klaady xaa kchoo meñ ni klaady xaa sëëb meñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ni lëë xaa knitylo xkyedzy to. Ni tu kyo kyaandy lady xcombañero, kchësyo nitylo. Ni lëë xaa kuty meñ, por byeñdy to nii kokladzy Dios ndeelaa lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Loxsye ngo lëë Jesús kwsëëb leñ lidzy Dios aan lëë xaa kwlii kchësy meñ nii no wto siko, ");
INSERT INTO ztqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","chëb xaa: —Leñ kitsy nii kë xtiits Dios gon xñee nii laañee kiid kutiitsni meñ Dios nak lidzy Dios, per lëë do byuño lidzy ngbaan. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ksatyee tse beeñ kseedy Jesús meñ leñ lidzy Dios. Aan lëë xaa nii xñabey lo pxosy, ni maestre ley ni xaa xñabey nii no kyedzy kwëkyub dyon xa kuty xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per pchilodyo, porñee kchësy meñ pkëëtyag nii bluuy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tu tse mentre lëë Jesús noyuuñ kseedy meñ leñ lidzy Dios, lëë xaa nii xñabey lo pxosy ni maestre ley ni lëë bla xaa kol ptsiñ, ");
INSERT INTO ztqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aan lëë xaa chëb lo Jesús: —¿Cho bnee tiitspey lool par kuuñtsyeyoo kchë nii chuuñtsyeyoo? ");
INSERT INTO ztqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Lëë Jesús chëb: —Wi gak gaan dyon kñabtiits tu cos lo do. Kol në dyon: ");
INSERT INTO ztqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿cho pxaal Juan dyon biid kchoobnis xaa? ¿Pe Dioso, ote cholsye meño yak? ");
INSERT INTO ztqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lëë xaa bislo xtilytiits lsa xaa, xñee xaa: —Deelñee tyeesy no nii Dios pxaal xaa, kñë xaa lo no: “¿Penak tsigo nii bnilasty to nii bluuy xaa?” ");
INSERT INTO ztqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aan chilody tyeesy no nii meñ lo kislyu re pxaal Juan, por suty meñ no lo kyo. Por kchësy meñ xniladzy nii xtiits Dios bluuy Juan. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Por ngo lëë xaa chëb lo Jesús nii nandy xaa cho pxaal Juan biid kchoobnis Juan. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tsigo lëë Jesús chëb: —Per ni naa tsigo busy kniydy dyon cho bneetsy tiitspey lon. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Loxsye ngo lëë Jesús pso stu cuent lo meñ, chëb xaa: —Tu xaa name beeñ pni xaa yag uv, aan lëëw ptee xaa companiy lo xaa nii kuuñ tsiiñoo, aan lëë xaa si laa sit. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tsi lëë xtiemp uv kol, lëë xaa pxaal tu xmos xaa siknab nii xyal xaa lo xaa nii beeñ tsiiñ, per lëë xaa go ptee xcheñ xmos xaa, aan lëë xaa psonëz xaa singosy. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsigo lëë xpixwan yag uv pxaal stu mos, per singo gak kwlootsyetsy xaa nii beeñ tsiiñ mos ko aan loxsye ptee xaa xcheñ xaa, lëë xaa psonëz xaa singosy. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lëë xpixwan yag uv bikche pxaal stu mos, per lëë xaa nii beeñ tsiiñ ptee xcheñ xaa, aan lëë xaa psonëz xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tsigo nladzy xpixwan uv: “Lëë nana ¿pe kuñaa?” Lëë lultime, lëë xaa pxaal xiñgan xaa nii xkëstyoo xaa. Nladzy xaa stsyeb xaa tsiiñ xiñgan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per tsiñee lëë xaa tsiiñ kon xiñgan xaa, lëë xaa tsiiñ chëb lo xcombañer: “Lëë xaa gue kyaani xkwaa pxosy. Kol tsoo kuuty no xaa tsiin kyaani now.” ");
INSERT INTO ztqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lëë xaa kwlii xiñgan xpixwan uv lo kwaa, aan lëë xaa beety xaa. ’¿Pe në do dyon pe cos kuuñtsyey xpixwan uv xaa nii beeñ tsiiñ xkwaa xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Lëë xaa gon kuty ksa xaa tsiiñ go, aan lëë xaa ktee xkwaa xaa lo stu xaa tsiiñ. Tsiñee biñ meñ ngo, lëë meñ chëb: —¡Nëdy Dios ngo! ");
INSERT INTO ztqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lëë Jesús buy lo meñ aan lëë xaa chëb: —¿Penak tsigo nii xñee leñ kitsy nii kë xtiits Dios nii lëë kyo nii psëëb xaa nii xsaa yu byak tu kyo nii mastre xkiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","’Deelñee kyab meñ lady kyo go, lëë meñ go kak byuy. Per deelñee kyab kyo go lady meñ, ni kak nyoody pa kuty meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wor go kazh kokladzy xaa nii xñabey lo pxosy ni maestre ley nyaasy xaa Jesús, porñee byeñ xaa nii contre lëë xaa pso Jesús cuent ko. Per byaxty xaa, porñee ptsyeb xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Por ngo lëë xaa pxaal bla xaa nii chak si chak xaa buen kukleetsy Jesús, parñee kyub xaa dyon pe cos jkëëkiy Jesús tsiin jko xaa xaa ña xtisy. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Lëë xaa chëb lo Jesús: —Maestre, ndon noo nii nonsyke tiitsli xñeel. Xsaldyoo nii xñee meñ ni xseedyoo xa chak meñ. Liisy xluuyoo xa kpañ meñ sinak xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwnë dyon pe nonguial tizh no tumi nii xtop xtisy Roma, ote nonguialdyo yak. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lëë Jesús byeñ pe cos no styoo xaa, por ngo lëë Jesús chëb: ");
INSERT INTO ztqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Kol kluuy tu pes lon dyon. Loxsye buy Jesúso, lëë xaa chëb: —¿Chonre dyon kë loo go, ni cho lë kë nu? Lëë xaa chëb: —Lëë xtisy Roma ni lë xaa kë loo go. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tsigo lëë Jesús chëb: —Kol kizh nii nsëëb to lo xtisy Roma tsigo busy, ni kol kizh kaa nii nsëëb to lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aan pchilody nyuuñ knee xaa tu cos nii nchilo nguëëkiy xaa Jesús. Lëël lëë xaa psee biñ xaa nii kwnee Jesús, aan kwneedre xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lëë bla xaa saduceo kwey lo Jesús. Lëë xaa saduceo xñee nii kpañdy meñ kuty, por ngo lëë xaa kukëb lo Jesús: ");
INSERT INTO ztqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestre, lëë Moisés chëb nii deelñee ktsiilña tu xaapkiy aan klyëëdy kety xaa, no nii ktsiilña betsy xaa kwnaa nii psaan xaa deelñee chapty me mëëd, parñee kap tsiil betsy xaa nii kuty mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tu vuelt name kwyo tu xaa nii kop xoop betsy aan lëë xaa ptsiilña. Per blyëëdy lëë xaa kuty, aan como kopty tsiil xaa mëëd, ");
INSERT INTO ztqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","lëë tu betsy xaa ptsiilña tsiil xaa aan lëë xaa kutyak. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Singo gak ptsyool stu betsy xaa. Ksa kadzy xaa ptsiilña me, per ni tu xaa psaandy mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lëë byalo wi kwnaa go kuty. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kwnë na dyon cho xaa kyaani kwnaa go tsiñee lëë meñ kuty kpañ, deelñee ksa kadzy xaa ptsiilña me. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tsigo lëë Jesús chëb: —Lo kislyu re busy xtsiilña mguiy ni xtsiilña kwnaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","per lëë meñ nii kchal kpañ kpaa, ni mguiy ni kwnaa gaa ktsiilñadre. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Por kejtre meñ go, sink lëë meñ go kak sinak angly ni lëë meñ go kak xiñ Dios porñee lëë Dios kuuñ kpañ meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ni axte Moisés kaa xluuy lo no nii nli xpañ meñ kuty por worñee kon xaa yakitsy nii noyek xñee xaa nii lëë Dios nak xDios Abraham, xDios Isaac ni xDios Jacob. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aan Dios gon nakty xaa xDios meñ kuty, sink xDios meñ mbañ nak xaa, porque par Dios kchë meñ nii kuty mbañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tsigo lëë bla maestre ley chëb: —Maestre, buen ptikcheel lo xtiits xaa nii kwnabtiits lool. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aan byaxtre meñ nyabtiits pe stu cos lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Loxsye ngo lëë Jesús chëb lo meñ: —¿Penak dyon xñee do nii lo xtiiy rey David sëëd Crist?, ");
INSERT INTO ztqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","con misme David na pkëë leñ kitsy nii kë salmos sinrii: Chëb Dios lo xaa nii xñabey naa: “Kwsob kwin nëzli, ");
INSERT INTO ztqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","axte nii tsitsiñ tse nii kñabeyoo lo kchë meñ nii xlëë lool.” ");
INSERT INTO ztqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Xa kchoo Crist lo xtiiy rey David, deelñee misme rey David xñee nii lëë Crist xñabey lo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kchësy meñ nche jkëëtyag nii nonee Jesús aan lëë xaa chëb lo xpëëdscuel xaa: ");
INSERT INTO ztqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Kol kap cuent lo maestre ley, por xtsiladzy xaa kakw xaa ladx non, ni chakladzy xaa nii jkëëptyux meñ xaa laañee ktsyooltyee meñ xaa lo kiy. Tsiimpee xsyob xaa laañee xsyob xaa non leñ ktoo, ni tsiñee chi xaa tu wagw, laañee xsyob xaa non xsyob xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ni xla xaa lidzy kwnaa viud, aan parñee këb meñ nii tir buen xaa, xsyo xaa chool xaa tu lay nii xyaldy kaa. Por ngo mastre ksaksi Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lëë Jesús no kuy xa xko meñ rikw tumi alcansiy ");
INSERT INTO ztqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","tsiñee lëë tu kwnaa viud nii tir prob ptsiñ, aan lëë me kwloo chop centab cobre nii xisy non leñ alcansiy. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tsigo lëë xaa chëb lo xpëëdscuel xaa: —Nli xñen lo do nii mastre nroob tumi nii kwloo kwnaa viud re alcansiy que kchë nii kwloo meñ rikw. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Por kchësy meñ xko tumi nii chuñ sobre alcansiy, per lëë me, lo xkyalprob me, lëë me kwloo kchësy tumi nii nseñ me alcansiy. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lëë meñ ncheyutiits nii tir ngui kchë kyo nii nyaa lidzy Dios ni tir ngui xixkwaaw, tsiñee lëë Jesús chëb: ");
INSERT INTO ztqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Sitsiñ tse nii lëë kchë nii nche kuy do nitylo. Ni tu kyo kyaandy lady xcombañero. Kchësyo nitylo. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Loxsye ngo lëë xpëëdscuel Jesús chëb: —Maestre, ¿pa wor kak kchë nii kwneel? ¿Xa mod kyeeñ noo nii lëëw mer kak? ");
INSERT INTO ztqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tsigo lëë Jesús chëb: —Kol kap cuent parñee jkëëtidy meñ do. Por ndaly xaa nii kakladzy kak sinakaa kiid, aan lëë xaa kñë nii lëë xaa nak Crist ni lëë xaa kñë nii lëë wor kutsiñ, per tsinaldy to xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tsiñee kon do nii lëë guerr ni tily noyak, ktsyebty to. Por singo no nii kako, per nitylody kaa kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tsigo lëë xaa kwnee re chëb xaa: —Lëë kchë kyedzy nii nche lo kislyu ktily lsa ni lëë kchë xaa xñabey ktily. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ndaly laañee kni xu dox, ni lëë kpiñ kiid ni lëë kyalkits kiid, ni lëë meñ kan cos ntseeb leñ kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Per antes nii kak kchësy cos re, lëë meñ kñaasy lëë do. Aan lëë meñ tsini lëë do lo xaa nii xñabey leñ ktoo, ni lëë meñ ko lëë do skiib, axte lo rey ni lo xtisy tsikso meñ do por naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Siko stedyo tiits kñee do lo meñ cho nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kol ktee nii pe tsinidy kik to nii dyon pe këb to o xa ksoli gaa to, ");
INSERT INTO ztqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porque naa ksyab leñ kik to pe cos këb to lo xaa nii xlëë lo do. Aan kxekwty xaa con xaaw ni chilody kaa kñë xaa nii buendyo por nonsyke tiitsliw. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Misme pxosy to, betsy to, xaa lidzy to ni xamigw to kak niladzy lëë do. No do axte kuty xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ni kchësy kaa meñ klëë lo do porñee xsoob to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per ni tu pe kakty to por ni tu kits kik to knekty. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kol kxekw tsiin telaa do. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Tsiñee kan do nii lëë xaa nii noy kiib nche kyako Jerusalén, klyëëdy lëëw nitylo. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tse go deelñee nche do Judea, kol kxooñ, kol tsëp kiy. O deelñee gaa nche do Jerusalén, kol kchoo kyedzy, ni deelñee nche do tañ, kyeydy to kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porque ntseeb kak tse go, por lëë kchë nii kë leñ xkitsy Dios kak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Brob kchë kwnaa nii nak xiñ tse go o xkadzy kaa mëëd! Por tir mban tedy meñ tse go ni lëë meñ ktsyool tu kyalnë dox. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","No meñ kety con spad, no gaa meñ kyooy xoo tyub lo kislyu. Aan lëë meñ sit kyëpkyety leñ kyedzy Jerusalén axte ksa tse nii ktee Dios tiitspey. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Kchë meñ ni nche lo kislyu jkan kik ni ktsyeb por kchë señ nii ko ngbidz, mëë, mëly ni por kchë xbi nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lëë meñ jkyey tseb por nandy meñ pere kak lo kislyu. Por axte wi kpaa kni. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Axte tsigolye lëën kchukë lo xkey con tu kyalwnabeyaa ni tu kyalntsonaa, por naa nak mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tsiñee lëë kchë cos re kislo, kol ko nguiool styoo do ni kol klis kik to, porque klyëëdy lëë do telaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","’Kol ksaladzy gaanoo nii tsiñee lëë yag yegw o stu gaa yag xkë peñ, xyeñ do nii lëë xtiemp kyo sëëd yob. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Singo gak tsiñee kan do nii lëë kchë cos nii psetyaa noyak, kol kaknan nii lëë xkyalwnabey Dios mer klyañche. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Por nli xñen nii antes nii kety kchë meñ nii no natiemp lëë kchë cos re kak. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Stedy kpaa ni stedy kislyu, per lëë xtitsaa tejtyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Kol kap cuent klaady to jkyedzy styoo do lo nip o lo kchë gaa cos nii no lo kislyu re, por toontlaa kyeñdy to tsitsib tse go. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Por nako sinak tu tramp. Por kchë meñ nii nche lo kislyu kan nii kak tse go. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kol kyëmbës tse go ni tugak kol nab lo Dios nii kteelaa xaa lëë do lo kchë cos ntseeb nii kiid ni parñee kchilo kpig to lon. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yutsye beeñ kseedy Jesús meñ leñ lidzy Dios, lëë kyool lëë xaa kuktseñ kiy nii lë Olivos. ");
INSERT INTO ztqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aan silyga xtsiñ meñ leñ lidzy Dios parñee jkëëtyag meñ xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lëë paskw sëëd yob. Lo lni go xtyaaw kyaxtily nii xkyëdy levadur. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aan lëë xaa nii xñabey lo pxosy ni lëë maestre ley byub dyon xa kuty Jesús, per pchilodyo porñee ptsyeb xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lëë xaatox kwsëëb leñ styoo Judas. Xpëëdscuel Jesús nak Judas. Iscariote kwnee meñ lo Judas. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aan lëë Judas kwey lo xaa nii xñabey pxosy ni lo xaa nii xkyënap lidzy Dios parñee këb xaa dyon xa jkaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ble xaa go lo Judas, aan lëë xaa chëb nii stee xaa tumi. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Byo xtiits xaa go styoo Judas. Por ngo lëë xaa bislo byub xaa xa jkaa Jesús tu laañee kindy meñ parñee jko xaa Jesús ña xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lëë paskw kol. Lo lni go xtyaaw kyaxtily nii xkyëdy levadur, ni chuty meñ mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Por ngo lëë Jesús chëb lo Pedre ni lo Juan: —Kol tsikuuñlo nii tyaaw xtsee no na paskw. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lëë xaa kwnabtiits chëb xaa lo Jesús: —¿Pa kyokuuñloo noow? ");
INSERT INTO ztqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tsigo lëë Jesús chëb: —Tsiñee ktsiñ do leñ kyedzy, lëë do kan tu xaa nii nsob yañ tub che nis. Kol tsinal xaa axte laañee ktsiñ xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aan kol këb lo xpixwan yu: “Lëë maestre pxaal lëë noo parñee kñabtiits noo pa sob yu laañee kawxtsee xaa ksa xpëëdscuel xaa na paskw.” ");
INSERT INTO ztqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lëë xaa kluuy tu cuart ngol nii sob kik lidzy xaa, xixkwaalew. Siko kol kuuñlo nii tyaaw xtsee no. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lëë xpëëdscuel xaa si aan lëë xaa ptsil yu nii chëëbpee Jesús, aan lëë xaa beeñlo nii kak xtsee paskw. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tsiñee lëë xwor xtsee kol, lëë Jesús kwsob lo mezh ksa xaa apostle. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aan lëë Jesús chëb: —¡Penaadle non gan kawnin lëë do na paskw antes nii ketyaa! ");
INSERT INTO ztqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Por axte nii klañche xkyalwnabey Dios kuñaa paskw stub. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Loxsye ngo lëë xaa kwseñ tu vas viñ, aan loxsye ptee xaa skizh lo Dios, lëë xaa chëb: —Kol ki nrii ni kol kiisyo lo xcombañer do. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Por nli xñen nii kidraa viñ sink lëën kwës axte klyañche xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lëë Jesús kwseñ tu kyaxtily, aan loxsye pteedy xaa skizh lo Dios, lëëw beeñ grol xaa, aan lëëw pteedy xaa lo xpëëdscuel xaa chëb xaa: —Lëë xcuerpaa nrii. Kol kawo parñee ksaladzy to naa, por lëën kety parñee telaa do. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Singo gak tsiñee lëë xtsee kwlox, lëë xaa kwseñ tu vas viñ aan lëë xaa chëb: —Tu cheñaa nrii. Lëëw kxee parñee kpily xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Lëë na lëë xaa nii kakniladzy naa sob lo mezh nu. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Per no nii ktsiiñaa laañee pxaal Dios naa. Per ¡brobsye xaa nii kakniladzy naa! ");
INSERT INTO ztqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tsigo lëë xpëëdscuel xaa bislo xñabtiits lo xcombañer dyon cho xaa kokniladzy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lëë xpëëdscuel Jesús ptilytiits parñee kaknan dyon cho xaa mastre non. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tsigo lëë Jesús chëb: —Nan do gon xa chuuñtsyey xaa nii xñabey lo kislyu ni nan do nii chakladzy xaa nii këb meñ nii tir buen xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per lëë lëë do nody nii kak to singo, sink deelñee no tu do chakladzy kñabey no nii kak to sinak tu xaa nii xsoob tiits ni sinak tu xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kol në dyon cho mastre non, ¿pe xaa nii xsyob lo mezh chawo ote xaa nii xkyë niskwaano yak? ¿Pe lëdy xaa nii xsyob lo mezh nak xaa non? Per lëë naa, lëën no lady to sinak tu xaa nii chuñ mandad. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ni kon gaa to kchë kyalnë ptsyoolaa aan psaandy to naa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Por ngo lëën knetsy kyalwnabey lo do sinak nii bneetsy Tat Tioso lon, ");
INSERT INTO ztqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","aan lëë do kaw ni lëë do ki laañee xñabeyaa ni lëë do sob parñee kñabey do lo ksa tsiipchop tiiy meñ nii no tañ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Loxsye ngo lëë Jesús chëb: —Simoñ, lëë xaatox gon kwnab lëë do parñee kuxso xaa to sinak xchooxso xobxtily. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per lëën kwnab lo Dios nii kakni xaa lii, parñee kchosody styool kaazhkaa, aan tsiñee lëë styool kpikche, pchoobladzy styoo xcombañeeroo parñee kchosody styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tsigo lëë Simoñ Pedre chëb: —Nikle win tso skiib, ni nikxe kety no tusyke, per ksandyaa lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Per lëë Jesús chëb: —Pedre, na kyool kazh tson vuelt këëboo nii xyuumbeydyoo naa antes nii jkwetsy nguidy kol. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsigo lëë Jesús chëb: —Tsiñee pxalaa lëë do sin bols, ni sin tumi, ni sin kyalkidy, ¿pe no dyon pe cos kok falt lo do? Tsigo lëë xpëëdscuel xaa chëb: —Ni tu pe kokty falt. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lëë Jesús chëb: —Lëë na, deelñee no cho do chap bols, kol koyo, ni kol koy tumi. Aan deelñee chapty to spad, kol kto xchaket to aan kol si tuwo. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Por no nii kak cumplir xkitsy Dios nii xñee nii win pkab lady xaa mal. Kchë laañee chakyety nii ktsyoolaa kak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lëë xpëëdscuel xaa chëb: —Maestre, lëë chop spad xoob nu. Tsigo lëë Jesús chëb: —Kol ksaano. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Loxsye ngo lëë Jesús si kiy nii lë Olivos aan lëë xpëëdscuel xaa sinal. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tsiñee lëë xaa ptsiñ siko, lëë xaa chëb: —Kol kutiitsni Dios parñee kyabty to lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aan lëë xaa kwsë lal laañee xyab tu kyo tsiñee xkëë meño, aan lëë xaa psoxib par kutiitsni xaa Dios, ");
INSERT INTO ztqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","chëb xaa: —Tat Tios, pteelaa naa lo kyalnë re, per kuuñtsyeydyoo nii chakladzyaa, sink beeñtsyey nii chakladzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ngo nonee xaa tsiñee lëë tu angly byety kpaa par ktee xfuersy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lo xkyalnë Jesús mastre chutiitsni xaa Dios, aan axte lo lyu byab nis nii psinis xaa, xñaw si xña cheñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tsiñee lëë xaa lox bitiitsni Dios, lëë xaa sey laañee nche xpëëdscuel xaa. Per ksasy xpëëdscuel nche nixyesy, porñee tir xteenë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsigo lëë xaa chëb: —¿Penak nche nixyesy to? Kol tsische aan kol kutiitsni Dios, parñee kyabty to lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lëë Jesús bii nonee, tsiñee lëë tubtsoon meñ ptsiñ. Lëë xpëëdscuel xaa nii pcholë Judas nech lo meñ, aan lëë xaa ptee tu pxit kwesy Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","per lëë Jesús chëb: —Judas, ¿con tu pxit nawen jkol naa ña meñ re? ");
INSERT INTO ztqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tsiñee lëë xaa nii nak ksa Jesús kon nii ktsyool Jesús, lëë xaa chëb: —¿Pe stiily noo con spad? ");
INSERT INTO ztqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aan lëë tu xaa nii nak ksa Jesús biswee tu xmos xaa nii mastre non lo pxosy, pchug xaa tyag xaa nii sob nëzli. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tsigo lëë Jesús chëb: —Kol ksaan. Lëë xaa kwseñ tyag mos ko, aan lëëw beeñ kyak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Loxsye ngo lëë xaa chëb lo xaa nii xñabey lo pxosy, ni lo xaa nii xkyënap lidzy Dios, ni lo xaa kol nii sinaasy xaa: —¿Penak nii sëëdxi do naa con spad ni yag nyak xaa ngbaan? ");
INSERT INTO ztqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ksatyee tse kwyon lady to leñ lidzy Dios, aan kwnaasty to naa. Per nyoo nii lëë xaatox xchëëp lëë do nina. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lëë meñ kwnaasy Jesús, aan lëë meñ kuni xaa lidzy xaa nii mastre non lo pxosy. Lëë Pedre kunal sit sit. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Lëë meñ psaay ki groltyee lo ley. Aan wi Pedre kwsob lady meñ go chu ki. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Siko sob Pedre tsiñee lëë tu kwnaa nii xkyë tsiiñ siko kon xaa aan lëë me chëb: —Wi meñ gue nak ksa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per lëë Pedre chëb: —Xyuumbeydyaa xaa gue. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kok xtsedyako, lëë stu xaa nii so siko kon Pedre, aan lëë xaa chëb: —Wil lë no xlad Jesús. Per lëë Pedre chëb: —Lëdyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nonsyak koko tu wor, lëë stu xaa chëb: —Soot paa gon nii wi xaa gue no xlad Jesús, por xaa Galilea xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Per lëë Pedre chëb: —Nandyaa pe cos xñeel. Aan wor go kazh, mentre lëë Pedre bii nonee, lëë tu nguidy kol pkwetsy. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tsigo lëë Jesús psuugw lo buy lo Pedre. Lëë Pedre gaa psaladzy nii chëb Jesús: “Na kyool kazh tson vuelt këëboo nii xyuumbeydyoo naa antes nii jkwetsy nguidy kol.” ");
INSERT INTO ztqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lëë Pedre pchoo siko aan lëë xaa biiñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lëë xaa nii kwënap Jesús ptee xcheñ xaa ni kwtsityni xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ni ptse xaa lo Jesús, aan xñee xaa: —¡Kwnë dyon cho kwtiñ lii! ");
INSERT INTO ztqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ni kwlootsyetsy xaa Jesús. Ndaly nii chëb xaa lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tsiñee lëë lyu byaani lëë xaa kol ni lëë xaa nii xñabey lo pxosy ni lëë maestre ley ptyop, aan lëë xaa kuni Jesús lo stu xaa nii mastre non, aan siko lëë xaa chëb lo Jesús: ");
INSERT INTO ztqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Kwnë dyon pe lii nak Crist. Tsigo lëë Jesús chëb: —Deelñee kniyaa na nii naaw, knilasty to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Deelñee gaa kñabtiitsaa tu pe cos lo do, kñëdy tow. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per destye nina lëën soob kwi Dios nëzli. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Loxsye ngo lëë xaa xñabey chëb: —¿Lii tsigo busy nak Xiñ Dios? Tsigo lëë Jesús chëb: —Misme lëë do xñee nii naaw. ");
INSERT INTO ztqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tsigo lëë kchë xaa go chëb: —¿Pa jkiiñre gaa no testigw? Misme lëë no ptyon pchoo kchë tiits re chuw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lëë xaa pchoo siko aan lëë xaa kuni Jesús lo Pilat, ");
INSERT INTO ztqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","chëb xaa: —Lëë xaa re pkaa loo noo. Lëë xaa noyuñ xkyedzy noo chop tiiy, xñee xaa nii nody nii tizh noo tumi nii xtop xtisy Roma, ni xñee xaa nii lëë xaa nak Crist nii kak rey. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Lëë Pilat chëb lo Jesús: —¿Pe nli lii nak xrey meñ Israel? —Misme chuwoo pchoo nii naaw —chëb Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsigo lëë Pilat chëb lo xaa nii xñabey lo pxosy ni lo meñ kyedzy: —Nody xfalt xaa re. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per nguiedzy chëb xaa xñabey: —Con kchë xiwseedy xaa lëë xaa noyuñ meñ chop tiiy. Galilea bislo xaa, lëë na lëë xaa kwlañche Judea. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tsiñee biñ Pilat ngo, lëë Pilat kwnabtiits dyon pe xaa Galilea nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lëë xaa xñabey chëb nii lëëw, aan lëë Pilat pxaal Jesús lo Herodes porñee lëë Herodes xñabey Galilea aan lëë xaa so Jerusalén leñ tse go. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tsiñee lëë Herodes kon Jesús, lëë xaa ble porñee penaadle kokladzy xaa nyan xaa Jesús, porñee biñ xaa kchë nii beeñtsyey Jesús aan kokladzy xaa nyan xaa tu kyalntson. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ndaly nii kwnabtiits Herodes, per koñee kwëbty Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aan wi xaa nii xñabey lo pxosy ni maestre ley nii tugak xkëëkiy Jesús nche siko. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lëë Herodes kwtsityni Jesús ksa xsoldad ni lëë xaa pkakw Jesús ladx nii chakw rey. Loxsye ngo lëë Herodes pxaal xaa lo Pilat stub. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tse go lëë Herodes ni lëë Pilat bnee buen, por klo xñee lsady xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Loxsye ngo lëë Pilat ptop kchë xaa nii xñabey lo pxosy, ni kchë xaa nii nak xtisy ni kchësy meñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aan lëë xaa chëb: —Lëë do gon biidni xaa re lon, në do nii lëë xaa noyuñ meñ chop tiiy. Aan xña lo do gon lëë xaa beeñ kñelin, per nlidy ngo xaa kchë falt nii xkëëkiy do xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nikle gaa Herodes, byeñ xaa nii nody xfalt xaa re. Por ngo lëë xaa ptikche xaa nu stub. Kol kan gaanoo nii ngody xaa falt nii tsigal kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Lëën ksaksi xaa, aan loxsye ngo lëë xaa klaan. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Porñee tsiñee chak paskw, nak xmod Pilat klaa xaa tu xaa nii no skiib par kuuñ ksak xaa styoo meñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per nguiedzy chëb meñ: —¡Beety xaa gue, aan blaa Barrabás! ");
INSERT INTO ztqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Lëë Barrabás no skiib por tu tily nii kok leñ kyedzy, ni porñee beety Barrabás tu meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kokladzy Pilat nlaa xaa Jesús. Por ngo kwnee xaa lo meñ stub. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Per mastre nguieex chëb meñ: —¡Pkëë xaa lo crusy! ¡Pkëë xaa lo crusy! ");
INSERT INTO ztqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Lëëw byon vuelt nii xñee Pilat lo meñ: —¿Per pe cos nak xfalt xaa? Karty ko xaa tu falt nii tsigal kety xaa. Lëë xaa ksaksin, aan loxsye ngo lëë xaa klaan. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per loñee singootyee nguiedzy kwnee meñ nii no nii kyë Jesús lo crusy, lëë nii kokladzy meñ kok. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lëë Pilat beeñtsyey nii kokladzy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aan loxsye blaa xaa xaa nweety bñech nii no skiib, lëë xaa pko Jesús ña meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tsiñee lëë soldad sijkëë Jesús lo crusy, lëë xaa kwnaasy tu xaa Cirene nii lë Simoñ, nii bikche tañ, aan lëë xaa pkoy xaa xicrusy Jesús. Loxsye ngo lëë xaa bneechlo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndaly meñ ni ndaly kwnaa choon ni chuptsyë sinal xitsy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per lëë Jesús byoogw, aan lëë xaa chëb: —Kchësy to siñee nak to kwnaa Jerusalén, koondy to por naa, sink kol koon por lëë do ni por xiñ do. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque sitsiñ tse nii lëë meñ këb: “Dichos kwnaa nii chilody kap mëëd ni dichos kwnaa nii pkasty mëëd.” ");
INSERT INTO ztqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ni lëë meñ këb lo kiy: “Kol kyab lady noo.” Ni lëë meñ këb lo tañ: “Kwloolan lëë noo.” ");
INSERT INTO ztqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Por deelñee ptsyoolaa kchë kyalnë re nii nakaa sinak tu yag mbañ, ¿xa lë nii xña kyalnë ktsyool do nii nak to sinak tu yag pidzy? ");
INSERT INTO ztqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wi chop xaa mal kuni xaa kyë lo crusy ksa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tsiñee lëë xaa ptsiñ laañee lë Calavera, lëë xaa pkëë Jesús lo crusy, ni lëë xaa pkëë chop xaa mal go kwi Jesús, tu xaa nëzli, stu xaa nëzpeg. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aan lëë Jesús chëb: —Tat Tios, beeñ kchë xaa re perdón, porque nandy xaa pe cos chuuñtsyey xaa. Aan lëë soldad kwloo xab Jesús rif parñee dyon cho xaa kchalo. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lëë meñ kukuy aan axte wi kchë xaa xñabey kwtsityni xaa xñee: —Pteelaa xaa meñ. Kyety xaa lo crusy na dyon deelñee nli nii lëë xaa nak Crist nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wi soldad kwtsityni Jesús. Ptee xaa viñ nyi lo Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ni chëb xaa lo xaa: —Deelñee nli lii nak xrey meñ Israel, pteelaa lii. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ni kwë blalan tiits kik xicrusy Jesús nii xñee: “Lëë xaa re nak xrey meñ Israel.” ");
INSERT INTO ztqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wi tu xaa mal nii kwë kwi xaa kwlootsyetsy xaa chëb: —Deelñee nli nii lii nak Crist, pteelaa lii ni pteelaa lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per lëë stu xaa mal nii wi kë lo crusy kwëntseeb lo xcombañer chëb: —¿Pe xtsyeebtyoo Dios nawen? ¿Pe xyeñdyoo nayak nii lo crusyak kël? ");
INSERT INTO ztqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lëë no busy porñee beeñ no mal ngo no tizh no xfalt no lo crusy. Per lëë xaa re, ni tu pe karty kuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tsigo lëë xaa chëb lo Jesús: —Psaladzy naa tsiñee lëël sob kñabeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Lëë Jesús chëb: —Nli xñen nii natse kazh lëël së kyo no kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tsiñee kol xwe ngbidz lëë lo kislyu pkyey, aan lëëw byaani axte las tres. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ni lëë lo ngbidz pkyey ni lëë ladx nii kë leñ lidzy Dios pchos nsoli. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Loxsye ngo lëë Jesús kwchuptsyë ni lëë xaa chëb: —Tat Tios, kokni xkyalbinin. Aan lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tsiñee lëë xaa nii xñabey lo soldad kon kchë nii kok, lëë xaa biily lay lo Dios, chëb xaa: —Nli nii kwyody xtol xaa re. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kchësy meñ nii kwey ni kon kchë nii kok xyaasy styoo bi. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Per lëë kchësy xaa nii byuumbey Jesús ni kchë kwnaa nii pchoonal xaa destye Galilea kwche sit buy. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kwyo tu xaa buen nii pcholë José. Xaa Arimatea xaa. Judea ngab xkyedzy xaa. Wi xaa kwyo lady xaa xñabey nii no Israel. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kwëmbës xaa nii klyañche xkyalwnabey Dios. Por ngo nii byody kchë nii beeñtsyey xaa xñabey styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Lëë xaa kwey lo Pilat, aan lëë xaa bnab xcuerp Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Loxsye blity xaa xcuerp Jesús lo crusy, lëëw pchal xaa tu sábana, aan lëë xaa kujkeetsy Jesús tu leñ paa nii ndeeñ lo kyo. Ni tu cho karty jkyeetsy leñ paa go. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mer tse nii kxe kxiladzy meñ lo tsiiñ nak tse go, por ngo lëë meñ nowxixkwaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lëë kwnaa nii pchoonal Jesús destye Galilea kukuy pa pkyeetsy Jesús, ni lëë me kon xa kwyo xcuerp Jesús paa. ");
INSERT INTO ztqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsiñee lëë me ptsiñ chu yu, lëë me pxixkwaa ngwaan nii xlyaa nex, aan lëë me pxiladzy tse nii chakty tsiiñ, por singo xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Per tsi lëë tse nii xiladzy meñ lo tsiiñ kwtedy, lëë kwnaa go si chu paa silyga. Noy me ngwaan xlyaa nex nii pxixkwaa me. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tsiñee lëë me ptsiñ, kon me nii xoobtre kyo nii ntse chu paa xlugaro. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lëë me kwsëëb leñ paa, per kondy me xcuerp Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Por ngo, tir ptsyeb me, nandy me pe kwxaak me, tsiñee kolpsye lëë me kon nii lëë chop mguiy so lo me nonsyke ladx xpibëly nakw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lo xtseeb ko lëë me pkiits kë lyu, per lëë chop xaa go chëb lo me: —¿Penak nii sëëd kyub to tu meñ nii mbañ lady meñ kuty? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kindy meñ nii xyub to nu, lëë me pañ. Kol ksaladzy nii kwnee me lo do worñee bii no me Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kwnee me nii no nii kyab me ña meñ ngoptol, ni lëë meñ jkëë me lo crusy, per tse nii loxo tson kpidz lëë me kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsigo lëë kwnaa go psaladzy xtiits Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","aan tsi lëë me bikche chu paa, lëë me kukso cuento lo ksa tsiiptub apostle ni lo meñ nii nak ksa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lëë María Magdalena, ni Xwan, ni Mariy xñaa Jacob, ni stubla kwnaa kunitiits lo apostle. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per kwxaak apostle nii chak wety me aan bnilasty xaa xtiits me. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Per lëënlëdy lëë Pedre kwey chu paa, aan tsiñee lëë xaa buy leñ paa, xaktyee ladx nii pchal Jesús kon xaa. Loxsye ngo lëë xaa sey chu yu aan psee xaa kon xaa kchë nii kok. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Misme gak tse go lëë chop xpëëdscuel Jesús no nëz si Emaús. Tsiiptub mily metre nak nëz tsiñee xchoo meñ Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chutiits xaa kchë nii kok Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lëë xaa pkaa lo Jesús aan lëë xaa si ksa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Per nikxe kon xaa Jesús, pchilody nyeñ xaa nii Jesúso. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Lëë Jesús chëb lo xaa: —¿Pe cos chutiits to dyon na nii sëëd to nëz? ¿Penak nii mban chak to? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsigo lëë tu xaa nii lë Cleofas chëb: —¿Nandyoo nawen pe cos kok Jerusalén leñ tse re, aan kwlësoo Jerusalén? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Lëë Jesús chëb: —¿Pe cos kok? Aan lëë xaa chëb: —Nii ptsyool Jesús Nazaret wo. Tu profet nii kwnee xtiits Dios kok xaa ni kon gaa meñ nii nakni Dios xaa, por kchë nii beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Per lëë xaa nii xñabey lo pxosy ni lëë xaa xñabey kwnab nii kyë xaa lo crusy par kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nladzy noo nii lëë xaa ndeelaa xkyedzy noo. Per natse chak tson kpidz nii ptsyool xaa singo. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Per lëë bla kwnaa nii no lady noo ptseb lëë noo, por lëë me kwey chu paa nasilytoo, ");
INSERT INTO ztqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","aan como kintre xcuerp Jesús leñ paa, lëë me byood chu yu. Aan lëë me bitiits nii lëë chop angly byaklo lo me aan lëë angly chëb nii mbañ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Loxsye ngo lëë bla xcombañer noo kwey chu paa, aan kon xaa nii nli xtiits kwnaa go, per kondy xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tsigo lëë Jesús chëb: —¡Natsypee nguey do ni natsypee neñ do par kniladzy to kchë nii kwnee profet! ");
INSERT INTO ztqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Pe nody nayak nii tedy Crist kchë kyalnë re antes nii kyëp xaa kpaa? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Loxsye ngo lëë Jesús beeñ kseedy chop xaa go, bluuy xaa xlibre Moisés laañee xñee kchë nii ktsyool Crist ni bluuy xaa kchë libre nii pkëë profet. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tsiñee lëë xaa ptsiñ kyedzy nii si xaa, lëë Jesús beeñ nii koñee lëë xaa ndyedy. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Per lëë xaa pkwëës Jesús, chëb xaa: —Kwlës, porque lëë tse ptsye, aan lëë lyu mer jkyey. Lëë Jesús kwsëëb par kwës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aan tsiñee lëë xaa nche sob lo mezh, lëë Jesús kwseñ kyaxtily, aan loxsye ptee xaa skizh lo Dios, lëë xaa beeñ grol kyaxtily aan lëëw pteedy xaa chop lo xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wor go lëë lo xaa byaly, aan lëë xaa byeñ nii Jesúso. Per pchilodre nyan xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsigo xñeesy xaa: —¿Pe lëdy gaanoo lika xyan leñ styoo no worñee bluuy xaa xkitsy Dios lo no nëz? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lëënlëdy lëë xaa pkaa nëz, sey xaa Jerusalén. Tsiñee ptsiñ xaa, lëë ksa tsiiptub apostle ni lëë meñ nii nak ksa xaa tse pkaal lsa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lëë meñ go chëb lo xaa: —Nli nii lëë Jesús pañ, por lëë Simoñ kon xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tsigo lëë chop xaa go bitiits xa ptsyool xaa nëz, ni lëë xaa bitiits xa byakpey xaa Jesús worñee beeñ grol Jesús kyaxtily. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lëë chop xaa go bii noyutiits ngo tsiñee lëë Jesús kwso groltyee lady xaa chëb: —Kakni Dios to dyon. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kchësy xaa ptsyeb porñee nladzy xaa te pesyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Per lëë Jesús chëb: —¿Penak nii singueetyee xtsyeb to, ni penak nii xkan kik to? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kol kuy ñan gaanoo ni kol kuy niyaa. Naaw. Kol seeñ naa. Non tsit ni kë pëëlaa, aan lëë pesy gon nodyo tsit ni kë pëëldyo. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Loxsye chëb xaa ngo, lëë xaa bluuy ña xaa ni lëë xaa bluuy niy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per como singootyee xle xpëëdscuel xaa, lika bnilasty xaaw, por ngo lëë Jesús chëb: —¿Pe cos chap to tyaaw no? ");
INSERT INTO ztqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tsigo lëë xaa ptee tublë mël pkyee lo Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","aan xña lo xaa lëë Jesús taw ma. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Loxsye ngo lëë Jesús chëb: —Worñee bii non lady to niyaa nii kchësy nii xseety xley Moisés, ni profet, ni kchë nii kë leñ kitsy nii kë salmos ktsyoolaa. Lëë na lëëw kok cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsigo lëë Jesús bluuy xa nak kitsy nii kë xtiits Dios aan lëë xaa byeño, ");
INSERT INTO ztqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","chëb Jesús: —Kël nii lëë Crist kety, ni kël nii tse nii loxo tson kpidz lëë xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ni kël nii lëë meñ Jerusalén ni lëë meñ nii nche tyub lo kislyu jkëëtyag xtiits Dios tsiin ktikche meñ styoo lo Dios parñee kpily xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aan lëë do kñee kchë nii kon do. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Por lëë do jkaa nii kneetsy Tat Tios. Naa kxalo. Per kchoody to leñ kyedzy Jerusalén. Kol kwës axte nii jkaa do Kyalbini Ntson nii sëëd kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lëë Jesús kuni kchë xpëëdscuel axte Betania, aan lëë xaa blis ña xaa par kuuñlay xaa xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aan mentre noyuuñlay xaa xaa, lëë xaa byëp kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Loxsye biily mëëdscuel lay lo Jesús, lëë xaa sey leñ kyedzy Jerusalén xle xaa, ");
INSERT INTO ztqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","aan sob sobsye tse kwey xaa lidzy Dios par ktee xaa skizh.");
INSERT INTO ztqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Klo worñee karty kwe kislyu kwyo tublan tiits kexka lo Dios aan lëë tiits ko nak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lo Dios kwyo tiits ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lëë tiits ko psaa kchë kchësy cos. Ni tu cos nii no kwyaady sin tiits ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lëë tiits ko nak kyalmbañ aan lëë kyalmbañ go nak bini nii xsaani lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lëë bini go xsaani lo nguey aan kchilody nguey ksuuyo. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Lëë Dios pxaal tu xaa nii pcholë Juan ");
INSERT INTO ztqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","biid këb lo meñ nii lëë xaa nii nak bini kiid parñee tsiñee kiid xaa kniladzy meñ xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Lëdy Juan nak bini, sink lëë xaa biid këb lo meñ nii lëë bini kiid. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tsigore biid bini nii nli xsaani lo meñ lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lëë xaa nii nak bini go biid lo kislyu, aan nikxe nii lëë xaa psaa kislyu, byuumbeydy meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Biid xaa lo meñ xkyedzy xaa, per psaldy meñ xkyedzy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lëë xaa ptee tiits nii kchë meñ nii bniladzy xtiits xaa kak xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ni nli gaa nii xiñ Dios nak meñ go, per nakty meñ go xiñ Dios porñee koly meñ go sinak chaly xiñ chol meñ, sink lëë meñ go nak xiñ Dios porñee singo kwlaño styoo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lëë xaa nii nak tiits ko biid lo kislyu aan lëë xaa kwyo lady no. Pkëstyoo xaa kchësy meñ ni bluuy xaa tiitsli, ni ptyon gaa noo kyalwnabey nii ptee Tat Tios lo xaa. Mëëd tusy nak xaa lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Lëë xaa nii nak tiits ko pseety Juan tsiñee chëb Juan: —Mastre non tu xaa nii kiid tsiñee lëën kpi, por nol xaa worñee lëën koly. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kchësy lo no xneetsy xaa kchë nii chap xaa ni xitsy xkwaa gaa kyalnsaak nii xneetsy xaa lo no. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lëë Moisés biidni xley Dios, per lëë Jesucrist biidni kyalwkëstyoo ni tiitsli. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni tu cho karty kan Dios, xaktyee xiñ xaa nii tugak no lo xaa. Lëë xaa bluuy Dios lo no. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lëë meñ Israel nii no Jerusalén pxaal pxosy ni meñ levita nii chuñ yudar pxosy kunabtiits cho nak Juan. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aan lëë Juan chëb: —Kaazhkaa lëdy naa nak Crist. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsigo lëë xaa go kwnabtiits stub chëb: —¿Cho nakoo tsigo busy? ¿Pe lii nak profet Elías? Lëë Juan chëb: —Lëdyo, lëdy naaw. Loxsye ngo lëë xaa kwnabtiits stub chëb xaa: —¿Lii tsigo busy nak profet nii no kiid? Lëë Juan kwëb chëb: —Lëdyo. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsigo lëë xaa go chëb stub: —¿Cho nakoo busy? Por no nii kyo knii noo tiits lo xaa nii pxaal lëë noo. Kwnë dyon cho nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Lëë Juan chëb: —Naa nak tsiy xaa nii xñee lo meñ tañ: “Kol kwii tu nëz tubli tedy xaa nii xñabey.” Singo kwnee profet Isaías. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tsigo lëë bla xaa nii pxaal meñ fariseo chëb lo Juan: ");
INSERT INTO ztqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Deelñee lëdy lii tsigo busy nak Crist ni lëdy lii nak Elías ni lëdy lii nak profet, ¿penak nii xchoobnisoo? ");
INSERT INTO ztqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tsigo lëë Juan chëb: —Nli naa xchoobnis con nis, per lady to no tu xaa nii xyuumbeydy to. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Lëë xaa kiid tsiñee lëën kpi. Xaa non xaa ni parñee kxakaa tuu kidy lab xaa xkiiñdyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betania nii nche kexka chu kiigwpee Jordán no kchoobnis Juan worñee kunee kchë xaa go lo Juan. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lëë byaani lyu lëë Jesús kwey lo Juan aan tsiñee lëë Juan kon xaa, lëë Juan chëb: —Kol kuy gaanoo, lëë xpëkwxiily Dios nii ktsily kchë xtol meñ sëëd ske. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lëë xaa psetyaa worñee niyaa nii nare kiid tu xaa nii mastre non lon, por nol xaa worñee kolyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nikle nandyaa cho nak xaa, per lëën syely kchoobnis parñee kyuumbey meñ Israel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Lëë gak Juan chëb: —Konaa byety Kyalbini Ntson kpaa sinak tu palom aan lëë Kyalbini Ntson byab lady xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nandyaa cho nak xaa, per lëë xaa nii pxaal naa syely kchoobnisaa con nis në lon: “Xaa nii kanoo kyab Kyalbini Ntson lady, xaa go kchoobnis meñ con Kyalbini Ntson.” ");
INSERT INTO ztqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Lëë xaa konlaa ni lëën xñeli gaa nii lëë xaa nak Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lëë byaani stu lyu lëë Juan nche misme gak lugar go ksa chop xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tsiñee lëë Juan kon nii lëë Jesús sitedy siko, lëë Juan chëb: —Kol kuy gaanoo, lëë xpëkwxiily Dios si ske. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tsiñee lëë chop xpëëdscuel Juan biñ ngo, lëë xaa sinal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tsi lëë Jesús kon nii lëë xaa sinal, lëë Jesús chëb: —¿Pe cos chakladzy to? Tsigo lëë xaa chëb: —Maestre, ¿pa nak liidzyoo? ");
INSERT INTO ztqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Lëë Jesús kwëb chëb: —Kol të gaanoo kuy do paw. Tsigo lëë xaa kwey laañee no Jesús aan lëë xaa ptseñ lo Jesús porñee tsel siik las cuatro nak worñee pchoonal xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Betsy Simoñ Pedre nii lë Ndresy nak xpëëdscuel Juan nii pchoonal Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lëë Ndresy kukyub Simoñ aan lëë xaa chëb lo xaa: —Lëë noo ptyon Mesías, xaa nii këmbëës no kiid. Lëë xaa nak Crist. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Loxsye ngo lëë Ndresy kuni Simoñ lo Jesús aan tsiñee lëë Jesús kon xaa, lëë Jesús chëb: —Lii nak Simoñ. Xiñ Jonás nakoo, per lëël kcholë Cefas. (Tiits ko nak sinak nii xñee no Pedre.) ");
INSERT INTO ztqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lëë byaani stu lyu lëë Jesús kwlokyeñ tsi xtañ meñ Galilea. Lëë xaa ptsyool Felip aan lëë xaa chëb: —Tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida lë xkyedzy Felip. Xaa kyedzy ko gak nak Ndresy ni Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Loxsye ngo lëë Felip kukyub Natanael aan lëë xaa chëb: —Lëë noo ptyon xaa nii tant xseety Moisés leñ libre nii kë ley ni lëë gaa xaa nak xaa nii tant pseety kchë profet. Lëë xaa nak Jesús Nazaret. José nak pxosy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lëë Natanael chëb: —¿Schilo nawen kchoo tu xaa buen leñ kyedzy Nazaret? Tsigo lëë Felip chëb: —Të gaanoo kuyoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tsiñee lëë Jesús kon nii lëë Natanael mer ktsiñ lo xaa lëë xaa chëb: —Lëë tu xaa nii nli nak xaa Israel sëëd ske. Ni tu kyalwkëti nody leñ styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Lëë Natanael kwnabtiits chëb: —¿Xa xyuumbeyoo naa? Lëë Jesús chëb: —Antes nii ngwetsy Felip lii, konaa soboo xan yag yegw. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsigo lëë Natanael chëb: —Maestre, lii nak Xiñ Dios. Lii nak xrey meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Lëë Jesús chëb: —¿Pe xniladzyoo xtitsaa nayak xaktyee porñee niyaa nii lëën kon lii xan yag yegw? Nare kanoo cos nii mastre kuuñ ksee styool. ");
INSERT INTO ztqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ni chëb Jesús: —Nli xñen nii lëë do kan kyaly kpaa ni lëë do kan nii lëë xangly Dios kyëp kyety lady mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tse nii kwloxo tson kpidz lëë tu kyalwtsiilña kok Caná, tu kyedzy nii nche nëz Galilea. Lëë xñaa Jesús kwey, ");
INSERT INTO ztqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","aan wi Jesús kwey ksa xpëëdscuel. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mer wroltyee lo lni lëë viñ pidzy, aan lëë xñaa Jesús chëb: —Lëë xviñ meñ re kwlox. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Per lëë Jesús chëb lo xñaa: —¿Penak nii xñeelo lon? Karty tsitsib xworaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Per lëë me chëb lo meñ nii xkiisy viñ: —Kol kuuñtsyey kchë nii kñë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lëëtyee gaa lëë xoop tiñ nii nyaa con kyo nche siko. Leñ tiñ go chadx ña meñ Israel. Masy tap kaly gaa o tu kyoow gaa litre nis xtyëë tu leñ tiñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tsigo lëë Jesús chëb lo xaa nii xkiisy viñ: —Kol jkatsë ksa tiñ gue nis. Lëëw pkatsë xaa axte pixo chu tiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Loxsye ngo lëë Jesús chëb: —Kol kwii xisyo aan kol tsiniw lo xaa nii chuñ lni. Aan lëëw kuni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tsiñee lëë xaa nii chuuñtsyey lni pkëë chuw nis nii byak viñ, nandy xaa dyon pa pchoow. Xaktyee xaa nii xkiisyo nano, porñee lëë xaa go kwlii nis. Por ngo lëë xaa kwtsyetsy xaa nii ptsiilña ");
INSERT INTO ztqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aan lëë xaa chëb: —Kchësy meñ gon xkiisy viñ buen tsiñee lëë lni chislo, aan axte lultime xkiisy meñ viñ mban, per lëë lii, lëël kwlootsey viñ buen par kiisylo lultime. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Caná nii ngab Galilea klootyee beeñtsyey Jesús kyalntson. Siko bluuy xaa xkyalwnabey xaa, aan lëë xpëëdscuel xaa bniladzy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Loxsye ngo lëë xaa si Capernaum ksa xñaa xaa ni betsy xaa ni xpëëdscuel xaa, aan lëë xaa kwlës siko bla kpidz. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aan como lëë paskw nii chuuñtsyey meñ Israel sëëd yob, lëë Jesús kwey Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tsiñee lëë xaa kwsëëb leñ lidzy Dios, lëë xaa kon kchë meñ nii xto yosy, ni meñ nii xto mëkwxiily ni palom, ni meñ nii nche sob laañee xtsyëë tumi. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsigo lëë xaa psaa tu soty aan lëë xaa kwlii kchë meñ go leñ lidzy Dios ksa meñ go mëkwxiily ni yosy. Kchësy xtumi meñ nii xtsëë centab pchoots xaa lo lyu ni ptische xaa xmezh meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Chëb xaa lo xaa nii xto palom: —¡Kol kwii kchë ngue nu! ¡Kyuñdy to lidzy pxosyaa tu mesón! ");
INSERT INTO ztqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tsigo lëë xpëëdscuel xaa psaladzy tiits nii kë leñ kitsy nii kë xtiits Dios. Sinrii xñeew: “Tirak xkëstyoon lidzy pxosyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tsigo lëë meñ Israel chëb: —Beeñtsyey tu kyalntson parñee kniladzy noo nii xaa xñabey nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tsigo lëë Jesús kwëb chëb: —Kol knitylo ktoo re aan tsonak kpidz lëëw ksoblin stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsigo lëë meñ Israel chëb: —Choowpxoop iz kwë meñ kwyaa ktoo re. ¿Xa ksaaloolo tsonak kpidz? ");
INSERT INTO ztqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per byeñdy xaa nii misme xcuerp Jesús nak ktoo nii pseety Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Por ngo, tsiñee lëë Jesús pañ, lëë xpëëdscuel xaa psaladzy kchë nii kwnee xaa, aan lëë xaa bniladzy kitsy nii kë xtiits Dios ni lëë xaa bniladzy xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Worñee lëë Jesús kwey paskw Jerusalén, ndaly meñ bniladzy xtiits xaa tsiñee kon meñ kchë kyalntson nii beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per kopty Jesús kchë meñ go confians, porñee xyuumbey xaa kchë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Xkiiñdy xaa nii dyon cho këb xa nak meñ lo xaa, por misme lëë xaa nan pe cos xsya leñ styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lëë tu xaa fariseo nii pcholë Nicodemo kwey lo Jesús. Tu xaa non nak xaa lo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kyool kwey Nicodemo lo Jesús aan lëë xaa chëb: —Maestre, ndon noo nii lëë Dios pxaal lii par kuuñ kseedyoo lëë noo, por ni tu cho chilody kuuñtsyey kyalntson nii chuuñtsyeyoo deelñee naknidy Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tsigo lëë Jesús chëb: —Nli xñen nii sëëbty kchë meñ nii kaldy stub laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tsigo lëë Nicodemo kwnabtiits chëb: —¿Per xa mod na dyon kpikche kaly tu xaa nii kwyoxle stub? ¿Pe schilo nayak kyo xaa leñ xñaa xaa stub par kpikche kaly xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aan lëë Jesús kwëb chëb: —Nli xñen nii deelñee sëëbty Kyalbini Ntson leñ styoo meñ nii chaly, chilody kyey meñ go laañee xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kchë meñ nii chaly no pxosy, per deelñee sëëbty Kyalbini Ntson leñ styoo meñ, chilody kak meñ xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kseety styool nii xñen lool nii kchësy meñ no nii kaly stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Laañee xkaatyee xpi me ni chonoo xbi me, per nandyoo pa sëëd me ni nandyoo pa tsi me. Singo gak nak Kyalbini Ntson nii xsyëëb leñ styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsigo lëë Nicodemo kwnabtiits stub chëb: —¿Pe nli lëësy kchë cos re? ");
INSERT INTO ztqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tsigo lëë Jesús kwëb chëb: —¿Maestre nakoo Israel aan nandyoo xa nak kchë cos re? ");
INSERT INTO ztqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nli xñen nii nonsyke nii ndon noo ni ptyon noo xñee noo. Per xnilasty to kchë nii xñee noo. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Deelñee xnilasty to xtitsaa tsiñee xsetyaa cos lo kislyu re lo do, ¿xa kniladzy to xtitsaa tsiñee lëën kseety cos nii sëëd kpaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni tu cho karty tsëp kpaa, xaktyee xaa nii byety kpaa. Lëë xaa go nak mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aan sinak nii psaa gak Moisés tu mëël aan psoob klaa xaa ma tu kik yag, singo gak no nii kyënal mguiy nii pxaal Dios lo crusy, ");
INSERT INTO ztqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","parñee kchësy meñ nii kniladzy xtiits xaa nii pxaal Dios, kejty meñ go, sink lëë meñ go jkaa tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Tir pkëstyoo Dios meñ nii nche lo kislyu re. Por ngo lëë xaa pxaal xiñ xaa nii nak mëëd tusy lo xaa, parñee kejty kchësy meñ nii kniladzy xtiits xiñ xaa, sink lëë meñ go jkaa tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pxaaldy Dios xiñ lo kislyu par jkëëkiy xaa meñ, sink lëë xaa pxaal xiñ xaa par kteelaa xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Kchë meñ nii xniladzy xtiits Xiñ Dios chilody kyëkiy meñ go, per lëë meñ nii xnilasty, lëë meñ go kyëkiy porñee xnilasty meñ go xtiits xaa nii nak mëëd tusy lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kchësy meñ nii xnilasty kyëkiy, por psaldy meñ go xaa nii nak bini worñee biid xaa lo kislyu, sink lëë meñ go byaan lo nguey porñee xtsiladzy meñ go xtol. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kchësy meñ nii chuñ cos mal xtilyni bini, aan xpigty meñ go lo bini parñee kak ndoondy kchë cos mal nii chuñ meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kchë meñ nii xniladzy tiitsli xpig lo bini parñee kak nyoo nii lëë meñ go chuuñtsyey nii xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Loxsye ngo lëë Jesús kwey xtañ meñ Judea ksa xpëëdscuel, aan lëë xaa pchoobnis meñ siko. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lëëtyee gaa wi Juan no kchoobnis meñ tu laañee lë Enón nii nche kexka Salim. Naal nis no siko, aan ndaly meñ kuchobnis. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Karty tso Juan skiib wor go. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per lëë bla xaa nii nak ksa Juan ptilytiitsni tu xaa Israel. Ptilytiits xaa xa kak nyë meñ parñee kuuñ ksak meñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aan lëë xaa kukëb lo Juan: —Maestre, biño gaanoo, lëë xaa nii biid lool stublad chu kiigwpee Jordán, xaa nii tant pseetyoo loo noo, lëë xaa no kchoobnis aan lëë meñ sinal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tsigo lëë Juan chëb: —Ni tu meñ chilody kap pe tu cos deelñee kteejty Dioso. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Misme lëë do biñ kwnen nii lëdy naa nak Crist, sink tu xaa nii kwtenechsye lo xaa nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lo tu kyalwtsiilña tsesy xsyo xamigw xaa nii ptsiilña. Lëë xaa nii ptsiilña xsyob kwi tsiil, aan tsi lëë xaa nii ptsiilña xñee, xle xamigw xaa. Singo gak naa xlen chonaa kchë nii chuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","No nii kak xaa tu xaa non, lëë naa no nii tseyga tseyga kyablyun. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Lëë xaa nii sëëd kpaa xñabey kchë meñ. Kchë meñ nii no lo kislyu xñee nonsyke cos nii no lo kislyu. Per lëë xaa nii sëëd kpaa xñabey lo kchë meñ, ");
INSERT INTO ztqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ni nonsyke nii konle xaa ni biñle xaa xñee xaa. Per ni tu cho xnilasty nii xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per kchë meñ nii xniladzy xtiits xaa xyeñ nii nli tiitsli xñee Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Porque xtiits Dios xñee xaa nii pxaal Dios, ni lëë gaa Dios xtee xKyalbini lo xaa, xkady Dios xKyalbini. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xkëstyoo Tat Tios xiñ, por ngo lëë xaa ptee kchëlo kyalwnabey lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kchësy meñ nii kniladzy xtiits Xiñ Dios jkaa tu kyalmbañ nii nitylody. Per lëë meñ nii knilasty xtiits Xiñ Dios, jkaady meñ go kyalmbañ nii nitylody, sink lëë meñ go jkaa castigw nii kxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Lëë meñ fariseo biñ nii ndaly meñ kwsëëb xlad Jesús ni ndalyre meñ xchobnis lo xaa que lo Juan. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Per lëdy lëë Jesús xchoobnis, sink xpëëdscuel xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tsiñee lëë Jesús biñ ngo, lëë xaa bi xtañ meñ Judea aan lëë xaa sey xtañ meñ Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Per no nii tedy xaa nëz xtañ meñ Samaria. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Por ngo lëë xaa kutedy tu kyedzy nii nche xtañ meñ Samaria. Sicar lë kyedzy ko. Kexka siko nix lyu nii pkady Jacob lo xiñ xaa José. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Siko kë tu kiigw nii xñee meñ go xkiigw Jacob, aan como xtsag Jesús, lëë xaa kwsob chu kiigw ko. Lëë ngbidz mer xwe. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Lëë xpëëdscuel gaa xaa si leñ kyedzy sisi nii ktyaaw. Siko sob Jesús tsiñee lëë tu kwnaa Samaria ptsiñ chu kiigw sixi nis, aan lëë Jesús chëb lo me: —Pkady xisy xisoo kin. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tsigo lëë me chëb: —¿Xa mod nii meñ Israel nakoo aan xñaboo nis lon nii nakaa meñ Samaria? (Singo chëb me porñee xñeenguidy meñ Israel lo meñ Samaria.) ");
INSERT INTO ztqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tsigo lëë Jesús chëb: —Deelñee nyanoo kchë nii xnee Dios, ni nyanoo cho xñab nis lool, xsobaa nii lii nyab nis lo xaa, aan lëë xaa neetsy tu nis nii xnee kyalmbañ lool. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Loxsye ngo lëë kwnaa go chëb: —Ni tu pe noydyoo, xey, par kwiil nis aan nxity kiigw. ¿Pa kwiil nis mbañ nii kneetsyoo kin? ");
INSERT INTO ztqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lëë pxusykoltoo noo Jacob psaan kiigw re. Nu kow me nis kchë xiñ me ni xma me. ¿Pe mastre nayak nonoo lo me? ");
INSERT INTO ztqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tsigo lëë Jesús chëb: —Kchësy meñ nii chi nis re xlyaa nis stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Per lëë meñ nii ki nis nii ktedyaa, kpikchedre klyaa meñ go nis. Porque lëë nis nii ktedyaa kak sinak tu xlyañ leñ styoo meñ go aan lëëw ktee tu kyalmbañ nii nitylody lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tsigo lëë kwnaa go chëb: —Xey, nee nis ko kin parñee klyaadraa nis, ni parñee kyelyxidraa nis chu kiigw re. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Lëë Jesús chëb: —Kutsyetsy tsiiloo aan tëni me nu. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tsigo lëë kwnaa go kwëb chëb: —Kindy tsiilaa. Tsigo lëë Jesús chëb: —Nli xñeel nii kindy tsiiloo, ");
INSERT INTO ztqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","por kaay mguiy kwyonil aan lëdy tsiiloo nak meñ nii nonil nina. Nli xñeel, xkëëtiidyoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsiñee lëë kwnaa go biñ ngo, lëë me chëb: —Xey, chanaa gon nii nli tu profet nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chu kiy re biid pxusykoltoo noo lo Dios, per lëë lëë do nii nak to meñ Israel xñee do nii Jerusalén nak laañee kyo noo lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tsigo lëë Jesús kwëb chëb: —Bniladzy nii kniyaa. Lëë wor kutsiñ nii kiijtre to chu kiy re ni tsidy to Jerusalén par ksoxib to lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kchësy to siñee nak to meñ Samaria nandy to cho lo xsoxib to, per lëë noo ndon noo cho lo xsoxib noo, por xlad meñ Israel sëëd xaa nii xteelaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per sitsiñ tse, ni lëëw kutsiñle gaa nina kazh, nii lëë meñ nii nli chool lay lo Tat Tios koolo sinak xñabey Kyalbini Ntson. Por singo chakladzy Tat Tios nii kool meño. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kyalbini nak Dios. Por ngo no nii kool meñ lay lo xaa sinak xñabey Kyalbini Ntson ni no nii kool meño tyub styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tsigo lëë kwnaa go chëb: —Nanaa nii lëë Mesías kiid (Crist nak Mesías), aan tsiñee lëë me kiid, lëë me kluuy loo noo xa nak kchë cos. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Lëë Jesús chëb: —Naa nak Mesías, lëë meeraa xñe lool. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ngo nonee Jesús tsiñee lëë xpëëdscuel xaa ptsiñ, aan ntseeb psee xpëëdscuel xaa nii lëë xaa noyutiitsni tu kwnaa. Per ni tu xaa byaxty nyëb: “Pe cos chuñoo”, o “penak kaa noyutiitsnil kwnaa gue.” ");
INSERT INTO ztqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tsigo lëë kwnaa go psaan xche chu kiigw aan lëë me sey leñ kyedzy. Tsiñee ptsiñ me lëë me chëb lo meñ: ");
INSERT INTO ztqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Kol të gaanoo kan do tu meñ nii në kchë cos nii kayuuñtsyeyaa. ¿Toon pe lëdy lëë me nak Crist? ");
INSERT INTO ztqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tsigo lëë meñ kyedzy kwey laañee so Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mentre gaa lëë xpëëdscuel Jesús xñee: —Maestre, të kaawoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per lëë Jesús chëb: —Lëën kaw tu cos nii xyuumbeydy to. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tsigo lëë xpëëdscuel xaa bislo xñabtiits lo xcombañer xñee: —¿Pe no yak cho biidni nii taw xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Per lëë Jesús chëb: —Xwagwaa nak kuuñtsyeyaa xtsiiñ xaa nii pxaal naa, ni xwagwaa nak kisyaalaa xtsiiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Xñee do: “Bii chak falt stap mëë par kislo kwlaap”, per kol kuy buen lo kwaa gaanoo, kchësyo no jketsy. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kchësy meñ nii xkyë kwlaap chazh, aan kchë nii xlaap meñ go chotsey par tu kyalmbañ nii nitylody, parñee kle kchë meñ nii xkyë kon ni meñ nii xkyë kwlaap. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nli gak tiits nii së sinrii: “Xaa meñ nii chan, xaa meñ nii xkyë kwlaap.” ");
INSERT INTO ztqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lëën pxal lëë do kwlaap laañee kwëdy to tsiiñ. Xaa cho kwë tsiiñ, aan lëë do bley xtsiiñ meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndaly meñ Samaria nii no kyedzy ko bniladzy xtiits Jesús por kchë nii kwnee kwnaa go worñee chëb me: “Në me kchë cos nii kayuuñtsyeyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aan tsiñee lëë meñ Samaria ptsiñ, lëë meñ go chëb lo Jesús: “Kwlës loo noo.” Aan lëë Jesús kwlës lo meñ go chop kpidz. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ndalyre meñ bniladzy tsiñee biñ meñ kchë nii kwnee mer xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tsigo lëë meñ chëb lo kwnaa go: —Na si nagon, xniladzy noo, lëdy xaktyee nii nëël loo noo, sink wi por kchë nii ptsyon noo kwnee me. Ndon noo nii nli lëë me kteelaa meñ lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tse nii kwloxo chop kpidz, lëë Jesús bi Samaria aan lëë xaa si nëz xtañ meñ Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Misme Jesús chëb: “Xsaldy meñ tu profet deelñee tsi xaa xkyedzy xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tsiñee lëë Jesús ptsiñ Galilea, ngui kwnee meñ go lo xaa, porñee wi kchë meñ go kwey paskw Jerusalén aan kon meñ go kchë nii beeñtsyey xaa lo lni go. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tsigo lëë Jesús kwey Caná stub. Galilea ngab Caná. Leñ kyedzy ko byuñ xaa nis viñ. Lëëtyee gaa leñ tse go lëë xiñ tu xaa nii xkyë xtsiiñ rey nii no Capernaum xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tsiñee lëë xaa nii xkyë xtsiiñ rey biñ nii lëë Jesús bi Judea aan lëë xaa tsi Galilea, lëë xaa kwey lo Jesús aan lëë xaa kwnab nii tsi Jesús lidzy xaa par kuuñ kyak Jesús xiñ xaa nii no xnëz kyalkuty. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tsigo lëë Jesús chëb: —Deelñee kandy to milagre ni kyalntson, knilasty to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tsigo lëë xaa nii xkyë xtsiiñ rey chëb: —Xey, ligier tsoo, por toon kety xiñaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Lëë Jesús chëb: —Byey, kejty xiñoo. Lëë xaa go bniladzy xtiits Jesús aan lëë xaa sey. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tsiñee lëë xaa sey, lëë xmos xaa kuktsiil nëz xaa chëb: —Lëë xiñoo byak. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tsigo lëë xaa kwnabtiits, chëb xaa: —¿Pa wor bislo byak buen xiñaa? Lëë mos chëb: —Neeg a la una pchoo xaa xlyëë. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsigo lëë xaa nii byak xiñ psaladzy nii mer wor go chëb Jesús: “Kejty xiñoo”, aan lëë xaa bniladzy xtiits Jesús kchë meñ lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chople kyalntson noyuuñtsyey Jesús tsiñee lëë xaa bi Judea ptsiñ xaa Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kok xtsedyako lëë meñ Israel beeñtsyey tu lni aan lëë Jesús kwey Jerusalén stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aan leñ kyedzy Jerusalén laañee lë puert mëkwxiily kë tu pily nii lë Betesda. Singo lëw con tiitsë hebreo. Kaay lo ley chap pily go. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ndaly meñ xsyaknë nche nix lo ley go, kchë meñ nii chandy, ni meñ nii chilody së ni meñ nii kutoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lady kchë meñ xsyaknë go no tu xaa nii kok kalyptsiipxon iz xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tsiñee lëë Jesús kon xaa, byeñ Jesús nii kok xtsele nix mbës xaa siko. Lëë Jesús chëb lo xaa: —¿Pe chakladzyoo kyakoo? ");
INSERT INTO ztqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tsigo lëë xaa xsyaknë go chëb lo Jesús: —Xey, kindy cho ko naa leñ pily tsiñee lëë nis xni. Cad nii chakladzyaa sëëbaa, klol stu meñ xsyëëb. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tsigo lëë Jesús chëb lo xaa: —Kuxche, blis xtal aan kwsë. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wor go kazh lëë xaa go byak. Lëë xaa blis xta xaa aan lëë xaa bislo kwsë xaa. Per como mer tse nii xiladzy meñ Israel lo tsiiñ byak xaa, ");
INSERT INTO ztqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","lëë bla meñ Israel chëb lo xaa: —Chakty tsiiñ natse. Chilody kyoyoo xtal. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tsigo lëë xaa nii byak ko kwëb chëb: —Lëë xaa nii beeñ kyak naa në lon: “Blis xtal aan kwsë.” ");
INSERT INTO ztqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsigo lëë meñ Israel kwnabtiits chëb: —¿Cho në lool: “Blis xtal aan kwsë”? ");
INSERT INTO ztqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per nandy xaa cho beeñ kyak xaa, porñee lëë Jesús kwnity lady meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsi lëë Jesús kon xaa leñ lidzy Dios, lëë Jesús chëb lo xaa: —Kon gaanoo lëël byak. Na kpikchedroo kuñoo tol tsiin ktsyooldyoo tu kyalnë nii mastre ntseeb. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tsigo lëë xaa nii byak ko kunitiits lo meñ Israel go nii lëë Jesús beeñ kyak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por ngo lëë meñ Israel go kwënal kuty Jesús porñee chuuñtsyey Jesús ngo tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Per lëë Jesús chëb: —Tugak xkyë Tat Tios tsiiñ, nikle gaa naa tugak xkyën tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por ngo nii mastre kwyoki meñ Israel go kuty Jesús, porñee lëdy xaktyee tse nii xiladzy meñ lo tsiiñ xsaldy xaa, sink wi penak nii chakladzy xaa kak xaa sinak Dios tsiñee xñee xaa nii pxosy xaa nak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tsigo lëë Jesús chëb: —Nli xñen nii chilody kuuñtsyey Xiñ Dios nii klyaañtyee styoo xaa. Xaktyee nii chan xaa chuuñtsyey Tat Tios chuuñtsyey xaa. Kchësy nii chuuñtsyey Tat Tios chuuñtsyey Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Xkëstyoo Tat Tios xiñ. Por ngo nii xluuy xaa kchë nii chuuñtsyey xaa lo xiñ xaa, ni nare kluuy xaa cos nii kuuñ ksee lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sinak nii chuuñ kpañ Tat Tios meñ kuty nii xtee xaa kyalmbañ, singo gak xtee xiñ xaa kyalmbañ lo meñ nii klyaañtyee styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chuñdy Tat Tios kyalxtisy, sink lëë xaa ptee kyalwnabey lo xiñ xaa parñee kuñ xiñ xaa kyalxtisy, ");
INSERT INTO ztqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ni parñee ksal meñ Xiñ Dios sinak nii xsal meñ Tat Tios. Deelñee xsaldy meñ Xiñ Dios, chilody ksal meñ xaa nii pxaal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Nli xñen nii kchësy meñ nii kniladzy tiits nii xñen ni kniladzy xaa xaa nii pxaal naa, ksaksidy xaa nii pxaal naa meñ go, sink lëë meñ go jkaa tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ni nli xñen nii sitsiñ wor ni lëë gaaw kutsiñ nina kazh nii lëë meñ kuty kon tsiy Xiñ Dios, aan kchë meñ kuty nii ksal xtiits xaa kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Porque lëë Tat Tios nak kyalmbañ, aan lëë xaa ptee tiits nii wi xiñ xaa kak kyalmbañ parñee ktee xaaw lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aan lëë Dios ptee kyalwnabey lo xaa par kuñ xaa kyalxtisy, por lëë xaa nak mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kseety to, por sitsiñ worñee kchë meñ kuty kon tsiy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aan lëë meñ kuty ko kchoo leñ paa. Kchësy meñ kuty nii beeñ buen jkaa kyalmbañ, per lëë kchësy meñ kuty nii beeñ mal tedy castigw. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Chilody kuuñtsyeyaa nii klyañ styoon, sink lëën chuñ kyalxtisy sinak nii xñabey xaa nii pxaal naa. Ni ngui chuñaa kyalxtisy, por syeldyaa par kuuñtsyeyaa nii chakladzyaa, sink lëën syely par kuuñtsyeyaa nii chakladzy pxosyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Deelñee misme naa xñe cho nakaa, chilody kniladzy meñ nii nli kchë nii xñen. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per no tu xaa nii xñee cho nakaa, ni nanaa nii nli kchë nii xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lëë do pxaal meñ nii kunabtiits lo Juan, aan kchësy nii chëb Juan nliw. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per xkiiñdyaa nii cho kñee cho nakaa. Singo niyaa parñee chilo telaa do lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kok Juan sinak tu bëly nii xsaani, aan mbëë bleni do xbini xaa xisy wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per kchësy nii chuuñtsyeyaa xluuy nii nli lëë Tat Tios pxaal naa, por nii xñabey xaa chuuñtsyeyaa, ni mastre gaa nono lo xtiits Juan. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni wi gaa Tat Tios nii pxaal naa xñee cho nakaa, nikxe nii karty kon do tsiy xaa ni karty kan do xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Xnilasty to nii xñen porñee nody xtiits xaa nii pxaal naa leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Xseedy to kitsy nii kë xtiits Dios porñee nladzy to leñ kitsy ko ktsil do kyalmbañ nii nitylody, aan leñ kitsy ko xñee cho nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Per chaklasty to kiid to lon parñee jkaa do kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Chaklastyaa nii kuuñ ksak meñ naa, ");
INSERT INTO ztqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","por xyuumbey bueenaa lëë do ni nanaa nii xkëstyoody to Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Lëë Tat Tios pxaal naa, aan xsaldy to naa, per deelñee nyiid tu xaa nii pxaaldy pxosyaa, xaa gol nsal do. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xa kchilo na dyon kniladzy to xtitsaa deelñee misme lëë do chuuñ ksak xcombañer do, aan xkwësty to nii kuuñ ksak Dios to? ");
INSERT INTO ztqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Këbty to tsaaplaa naa jkëëkiy lëë do lo Tat Tios. Misme Moisés xkëëkiy lëë do, ni lëëw na Moisés sye xsaladzy to. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Deelñee niladzy to nii kwnee Moisés, niladzy to nii xñen, por lëë Moisés pkëë leñ kitsy nii kë xtiits Dios cho nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per deelñee xnilasty to nii pkëë xaa, ¿xa mod kniladzy to nii xñen? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Loxsye ngo, lëë Jesús si stublad chu nis Galilea. No meñ xñeew Tiberias. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aan singootyee ndaly meñ kunal porñee chan meñ kchë kyalntson nii chuuñtsyey xaa tsiñee chuuñ kyak xaa meñ xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lëë Jesús kwyëp tu kik kiy aan lëë xaa kwsob siko ksa xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lëë paskw nii chuuñtsyey gaa meñ Israel sëëd yob. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tsiñee lëë Jesús buy, kon xaa nii singootyee ndaly meñ sinal. Lëë xaa chëb lo Felip: —¿Pa lë nii syuuy no nii kyaan no kchësy meñ gue? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Singo chëb xaa par kuñ xaa Felip preb, por nanle xaa xa kuñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tsigo lëë Felip chëb: —Per ni chop kyoow denario kyaxtily jkaady parñee jkaa meñ re tublë gaaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsigo lëë betsy Simoñ Pedre nii lë Ndresy nii wi nak xpëëdscuel xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Lëë tu xaa wiñ nii so nu noy kaay kyaxtily ni chop mël, per ¿pe lë nrii lo tant meñ? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tsigo lëë Jesús chëb: —Kol këb lo meñ sob meñ. Aan singootyee no kizh siko. Masy kaay mily xaapkiy pkab. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Lëë Jesús kwseñ ksa kyaxtily go, aan loxsye ptee xaa skizh lo Dios, lëëw beeñ grol xaa aan lëëw kwtiisy xaa lo meñ nii nche sob. Singo gak kwtiisy xaa mël aan kchë meñ byëly. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tsiñee lëë meñ lox taw, lëë Jesús chëb lo xpëëdscuel: —Kol ktop kchë nii byuy nii byaan parñee ni tublëw xiñdy. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lëëw ptop xaa, aan lo kaay kyaxtily go byaktsë tsiipchop tskwidy nii byuy. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tsiñee kon meñ kyalntson nii beeñtsyey Jesús, xñee meñ: —Nli nii lëë xaa re nak profet nii no kiid lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per como lëë Jesús byeñ nii lëë meñ chakladzy koy xoo meñ xaa parñee kak xaa rey, lëë xaa pxooñ, lëë xaa si kiy tusy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tsiñee lëë lyu pkyey, lëë xpëëdscuel Jesús biidso chu nis. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Lëë xaa byo barkw par tekë xaa nis ktsiñ xaa Capernaum. Lëë lyu gaa lox pkyey, aan karty kpikche Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lëë nis bislo chisoli por tu me dox nii bislo xpi. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tsiñee kok masy tu kaay o xoop kaa mily metre si xaa lo nis, lëë xaa ptsyeb porñee kon xaa nii lëë Jesús xsyë lo nis aan lëë Jesús xpig chu barkw. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Per lëë Jesús chëb: —¡Naaw, ktsyebty to! ");
INSERT INTO ztqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsigo lëë xaa blaa kwyëp Jesús leñ barkw aan blyëëdy lëë xaa ptsiñ laañee si xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsi lëë lyu byaani, lëë meñ nii byaan stublad chu nis byeñ nii lëë xpëëdscuel Jesús bii byo leñ tu barkw nii so siko, per byody Jesús leñ barkw ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mentre gaa lëë stubla barkw Tiberias ptsiñ kex laañee taw meñ kyaxtily tsi lox ptee Jesús skizh lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aan tsiñee konsye meñ nii kindy Jesús siko ni kindy xpëëdscuel xaa, lëë meñ byo barkw, lëë meñ sikyub xaa kyedzy Capernaum. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tsiñee lëë meñ ptsiñ stublad chu nis, lëë meñ ptsil Jesús aan lëë meñ kwnabtiits chëb: —Maestre, ¿pa wor kwlaañoo nu? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Lëë Jesús chëb: —Nli xñen nii porñee taw do axte laañee byëly do, ngo nii xyub to naa. Xyubty to naa porñee byeñ do xa nak kyalntson nii beeñtsyeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kyëdy to tsiiñ par ktsiñaa do nii ktyaawsye, por xlyoxo, sink kol kyë tsiiñ par ktsiñaa do tu kyalmbañ nii nitylody. Lëë mguiy nii pxaal Dios kneetsy kyalmbañ go lo do, por lëë Tat Tios bluuyle nii lëë xaa nak Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tsigo lëë meñ kwnabtiits chëb: —¿Xa kuuñ noo par kuuñtsyeey noo kchë nii chakladzy Dios? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Lëë Jesús kwëb chëb: —Chakladzy Dios nii kniladzy to xtiits xaa nii pxaal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tsigo lëë meñ chëb: —¿Pe cos kluuyoo tyon noo parñee kniladzy noo xtiitsoo? ¿Pe cos kuuñtsyeyoo? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lëë pxusykoltoo noo taw kyaxtily nii lë maná tañ. Sinrii xñee leñ kitsy nii kë xtiits Dios: “Lëë Dios ptee kyaxtily nii blyaal kpaa taw xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tsigo lëë Jesús chëb: —Lëdy Moisés bneetsy kyaxtily nii byety kpaa lo do. Lëësy Tat Tios xnee kyaxtily nii nli xyety kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lëë xaa nii byety kpaa nak kyaxtily nii xteedy pxosyaa lo meñ parñee kpañ meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lëë meñ chëb: —Xey, bneetsy kyaxtily go tyaaw noo. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Lëë Jesús chëb: —Naa nak kyaxtily nii xnee kyalmbañ. Kchësy meñ nii kiid lon, kpikchedre klyaañ meñ go, ni kchësy meñ nii kniladzy xtitsaa, kpikchedre klyaa meñ go nis. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sinak nii niylaa lo do, nikxe chan do naa, per xnilasty to. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kchësy meñ nii xnee Tat Tios lon chiid lon. Aan ni tu meñ nii chiid lon xsonëëztyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porque pchodyaa kpaa parñee kuuñtsyeyaa nii klyañ styoon, sink lëën syely par kuuñtsyeyaa nii chakladzy xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Chaklasty xaa nii pxaal naa nii jkëëtañaa meñ nii bneetsy xaa lon, sink chakladzy xaa nii kchë meñ go kuuñ kpaañaa tsi lëë tse go tsigal. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Por chakladzy xaa nii pxaal naa nii kchësy meñ nii kuy lo Xiñ Dios ni kniladzy xtiits xaa jkaa tu kyalmbañ nii nitylody. Aan naa kuuñ kpañ meñ go tsi lëë tse go tsigal. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tsiñee biñ meñ Israel ngo, lëë xaa bislo kwneenë xaa Jesús, porñee chëb Jesús: “Naa nak kyaxtily nii byety kpaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tsigo lëë meñ go bislo xñee: —¿Pe lëdy lëë Jesús nayak nak xiñ José? Xyuumbey no pxosy xaa ni xñaa xaa. ¿Penak nii xñee xaa nii lëë xaa byety kpaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lëë Jesús kwëb chëb: —Kol ksaan, kñeenëdre to. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Por ni tu cho chilody kiid lon deelñee kiidnidy Tat Tios nii pxaal naa xaa. Aan naa kuuñ kpañ kchë meñ nii kiid lon tsi lëë tse go tsigal. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Leñ kchë libre nii pkëë profet xñee sinrii: “Lëë Tat Tios kuuñ kseedy kchësy meñ.” Por ngo nii kchësy meñ nii xkëëtyag xtiits Tat Tios, ni xseedy nii xñee xaa, chiid lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Xñedyaa nii nol tu xaa nii kayan Tat Tios. Xaktyee xaa nii pchoo lo Dios kayanle Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nli xñen nii kchësy meñ nii kniladzy xtitsaa jkaa kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naa nak kyaxtily nii xnee kyalmbañ. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nikxe taw pxusykoltoo do kyaxtily nii lë maná tañ, lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per lëë naa kyaxtily nii byety kpaa xnen. Chejty kchë meñ nii chaw kyaxtily go. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naa nak kyaxtily nii byety kpaa par ktedyaa kyalmbañ lo meñ, aan kejty kchësy meñ nii chaw kyaxtily re. Misme xcuerpaa nak kyaxtily nii ktedyaa. Lëëw ktedyaa parñee kpañ kchë meñ nii nche lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tsigo lëë meñ Israel bislo ptilytiits ksa xcombañer, xñee: —¿Xa kchilo dyon kneetsy xaa re xcuerp tyaaw no? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Lëë Jesús chëb: —Nli xñen nii deelñee kawdy to xcuerp mguiy nii pxaal Dios ni kidy to xcheñ xaa, kpañdy to. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kchësy meñ nii chaw xcuerpaa ni chi tu cheñaa, xkaa kyalmbañ nii xnitylody, aan naa kuuñ kpañ meñ go tsi lëë tse go tsigal. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Por nii xtyaaw nak xcuerpaa, ni nii xtyoow nak tu cheñaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kchësy meñ nii chaw xcuerpaa ni chi tu cheñaa nakni naa, ni nakni gaan meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Lëë Tat Tios nii pxaal naa xnee kyalmbañ, aan por kyalmbañ go lëë meñ mbañ. Singo gak kchë meñ nii kaw naa jkaa kyalmbañ. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kyaxtily nii byety kpaa xnen. Naktyo sinak maná nii taw pxusykoltoo do ni nikxe gaa taw xaaw, lëë xaa kuty. Per lëë meñ nii kaw kyaxtily nii byety kpaa kejty meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Leñ ktoo nii sob leñ kyedzy Capernaum bluuy Jesús kchë nrii. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tsiñee lëë kchë meñ nii nak xpëëdscuel xaa biñ ngo, ndaly xaa bislo xñee: —Tir ngan kchë nii xñee xaa. ¿Cho lë nii kuuñtsyeyo? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tsi lëë Jesús byeñ kchë nii nonee tsilaan meñ go, lëë xaa chëb: —¿Pe xyeedy kik to biñ do kchë nii kwnen? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Pe nyuñ do deelñee nyan do nii lëë mguiy nii pxaal Dios xyëp kpaa par kyey xaa laañee sob xaa klo? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lëë Kyalbini xnee kyalmbañ. Pa xkiiñdy cuerp. Kchë tiits nii xñen lo do xñee xa nak kyalmbañ nii xnee kyalbini. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per no do nii xnilasty nii xñen. Singo chëb Jesús porñee nanle xaa cho xnilasty ni nanle xaa cho kak niladzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ni chëb xaa: —Por ngo nii lëën niyle lo do nii ni tu cho chilody kiid lon deelñee kiidnidy Tat Tios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Destye tse go ndaly xpëëdscuel Jesús pchooxso kwënaltre xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tsigo lëë Jesús chëb lo ksa tsiipchop xpëëdscuel: —¿Pe wi do chakladzy kchooxso? ");
INSERT INTO ztqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Lëë Simoñ Pedre kwëb chëb: —Xey, ¿cho lo kyo noo? Lii nak xaa nii xñee tiits nii xnee kyalmbañ nii xnitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ni ndonle noo ni xniladzy noo nii lii nak Xiñ Ntson Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tsigo lëë Jesús chëb: —¿Pe lëdy tsiipchop to nawen kwlen? Per lëë tu do byaklo xaatox. ");
INSERT INTO ztqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Xiñ Simoñ Iscariote nii lë Judas pseety Jesús worñee lëë xaa kwnee singo, por lëë Judas kok niladzy xaa nikxe nii wi Judas pkab lady ksa tsiipchop xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Loxsye ngo, lëë Jesús kunsë nëz xtañ meñ Galilea. Koklasty xaa nyi xaa nëz Judea, por lëë meñ Israel nii xñabey tañ go kënal kuty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Per como lëë lni nii xsaa meñ Israel yu yag xiidy sëëd yob, ");
INSERT INTO ztqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","lëë betsy Jesús chëb: —Pchoo nu, kwey Judea parñee wi meñ nii nak ksal nii no siko kan kchë nii chuuñtsyeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Por ni tu cho chuuñtsyeydy tsilaan tu cos deelñee chakladzy xaa kyuumbey meño. Deelñee chuuñtsyeyoo kchë cos re, pchoo parñee kyuumbey meño. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Singo chëb betsy xaa, porñee ni betsy xaa xnilasty xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsigo lëë Jesús chëb: —Karty tsitsib xworaa, per lëë lëë do kindy xwor do. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xtilynidy meñ nii nche lo kislyu lëë do. Per lëë naa, xtilyni kchë meñ go naa porñee xñen nii mal kchë cos nii chuuñtsyey meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kol tsi lni. Naa kadyaa, por karty tsitsiñ xworaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aan loxsye chëb xaa ngo, lëë xaa byaan Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Per loxsye si betsy Jesús, lëë xaa sinal. Tsilaan kwey xaa, kwey neñlody xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kwëkyub xaa Israel nii xñabey xaa lo lni, xñee xaa: —¿Ko xaa go? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndaly meñ bislo xseety Jesús. No meñ xñee: “Buen xaa.” No gaa meñ xñee: “Buendy xaa por xkëëti xaa meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per ni tu meñ kwneedy nder confians, porñee ptsyeb meñ xaa Israel nii xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mer wroltyee lo lni lëë Jesús kwteyo lidzy Dios aan lëë xaa bislo beeñ kseedy xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kchësy meñ Israel nii xñabey psee xñee: —¿Pa pseedy xaa gue kchë nii xñee xaa con kweydy xaa scuel? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tsigo lëë Jesús kwëb chëb: —Lëdy nii chakaa xluyaa, sink nii xñabey xaa nii pxaalno. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Deelñee no cho chakladzy kuuñtsyey nii chakladzy Dios, syeñ meñ go deelñee nii xñabey Dios xluyaa o deelñee gaa nii xlyañsye styoono. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kchësy xaa nii xñee nii xlyañ leñ styoo chakladzy xaa nii ksal meñ xaa, per lëë xaa nii chakladzy nii ksal meñ xaa nii pxaal xaa, lëë xaa go xñee tiitsli aan ni tu tiits xuuy xñeedy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Pe lëdy nawen bneetsy Moisés ley lo do? Per ni tu do chuuñtsyeydy nii xñabey ley go. ¿Penak nii chakladzy to kuty to naa? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tsigo lëë meñ kwëb chëb: —Kyalbini mal no leñ styool. ¿Cho chakladzy kuty lii? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lëë Jesús chëb: —Por tugak kyalntson nii beeñtsyeyaa tse nii xiladzy to lo tsiiñ, kchësy to xsee. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Lëë Moisés psaan nii tsobey mëëd. Por ngo nii xkobey do mëëd tse nii xiladzy to lo tsiiñ, per lëdy kik Moisés kwlaño, por destye pxusykoltoo do beeñtsyeyo. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lëë nana, lëë do xkobey mëëd tse nii chakty tsiiñ porñee chaklasty to ksaan do xley Moisés. ¿Penak tsigo nii xlëë do lon porñee beeñ kyakaa tu meñ tse nii chakty tsiiñ? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kuñdy to kyalxtisy si no kik to, sink kol kuñ kyalxtisy sinak xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tsigo lëë bla meñ Jerusalén bislo xñabtiits lsa, xñee: —¿Pe lëdy lëë xaa gue nawen kënal meñ xñabey kety? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lëë na lëë xaa so ske xñee xaa aan ni tu cho pe xñeedy lo xaa. ¿Pe wi xaa nii xñabey yak xniladzy nii nli lëë xaa nak Crist? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ndon no pa sëëd xaa, per tsiñee lëë Crist kiid, ni tu cho kaknandy pa kchoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Lëë Jesús noyuuñ kseedy meñ leñ lidzy Dios tsiñee lëë xaa biñ ngo, aan lëë xaa chëb: —¡Xsyak to nii xyuumbey do naa ni nan do pa pchon! Per syeldyaa porñee chakladzyaa, sink lëën syely porñee pxaal tu xaa nii xyuumbeydy to naa. Lëë xaa go xñee tiitsli. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Xyuumbeyaa xaa porñee lo xaa pchon, ni lëë xaa pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tsigo lëë meñ kokladzy nyaasy xaa, per ni tu cho byaxty, porñee karty tsitsiñ xwor xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Per ndaly meñ nii bniladzy xtiits xaa, xñee: —Tsiñee kiid Crist na dyon, ¿pe suuñtsyey xaa kchë kyalntson nii chuuñtsyey xaa re? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tsi lëë meñ fariseo biñ nii lëë meñ chutiits cho nak Jesús, lëë xaa kok ksa xaa nii xñabey lo pxosy par kxaal xaa mayor tsinaasy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tsigo lëë Jesús chëb: —Xtsedre tson lady to, por lëën kya lo xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aan nikxe kyub to naa, ktsildyaa lo do, por chilody kiid to laañee tson. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tsigo lëë meñ Israel nii xñabey bislo xñabtiits lo xcombañer xñee: —¿Pa lë nii tsi xaa nii chilody ktsil no xaa? ¿Pe si xaa lo meñ Israel nii ncheno tañ yak parñee wi lo meñ sit kluuy xaa xtiits xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Penak nii në xaa lo no: “Nikxe kyub to naa, per ktsildyaa lo do, por chilody kiid to laañee tson”? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ntson chak tse nii lëë lni xyal, aan tse go lëë Jesús kuso chëb lo meñ: —Deelñee no cho do xlyaa nis, kol të lon aan kol ki. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kchësy leñ styoo meñ nii xniladzy xtitsaa klyañ nis mbañ, por singo kë leñ xkitsy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tsiñee lëë Jesús kwnee singo, lëë xaa chëb nii kchësy meñ nii xniladzy xtiits xaa sëëb Kyalbini Ntson leñ styoo. Karty kiid Kyalbini Ntson wor go, porñee karty kyey xaa kpaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","No meñ nii biñ kchë nii kwnee xaa bislo xñee: —Lëë xaa gue nak profet nii no kiid. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","No gaa meñ kwnee: —Lëë xaa gue nak Crist. Per no meñ kwnee: —Lëdyo. ¿Pe Galilea nawen kchoo Crist? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Leñ xkitsy Dios kë nii lo xtiiy rey David kchoo Crist, ni Belén kchoo xaa, por kyedzy ko pchoo David. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Por Jesús lëë meñ kok chop tiiy. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","No meñ kokladzy nyilo Jesús skiib, per ni tu meñ byaxty. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsiñee lëë mayor ptsiñ laañee nche sob xaa fariseo ni xaa nii xñabey lo pxosy, lëë xaa chëb lo mayor: —¿Penak nii sëëdnidy to xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tsigo lëë mayor kwëb chëb: —¡Ni tu cho karty tsyon noo kñee sinak nii xñee xaa go! ");
INSERT INTO ztqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Lëë xaa fariseo chëb: —¿Pe wi do nawen tse kwëti? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Pe tse nayak bniladzy tu xaa nii xñabey xtiits xaa, ni pe tse bniladzy meñ fariseo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Per nguialsi meñ nii xyuumbeydy xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tsigo lëë tu xaa fariseo nii lë Nicodemo nii kwey lo Jesús tu vuelt chëb: ");
INSERT INTO ztqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Lo xley no gon xñee nii chilody jkëëkiy no tu xaa deelñee karty tsyon no xtiits xaa parñee kak ndon no pe cos beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tsigo lëë xcombañer xaa kwëb chëb: —¿Pe wil nayak nak xaa Galilea? Pseedy kitsy nii kë xtiits Dios kaa tsiin kanoo nii ni tu profet karty kchoo Galilea. ");
INSERT INTO ztqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Loxsye ngo lëë meñ sey lidzy. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Per lëë Jesús si kiy nii lë Olivos. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lëë byaani lyu lëë xaa ptsiñ leñ lidzy Dios stub. Lëë meñ gaa ptyop aan lëë xaa kwsob beeñ kseedy xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lëë maestre ley ni xaa fariseo ptsiñni tu kwnaa nii pkaa lo xaa chop stu mguiy. Lëë me pso xaa groltyee lady meñ, ");
INSERT INTO ztqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aan lëë xaa chëb lo Jesús: —Maestre, lëë kwnaa re pkaa loo noo chop stu mguiy. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo ley nii psaan Moisés loo noo gon xñee nii no nii kety clasy kwnaa re lo kyo. ¿Lii, dyon pe nëël? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kchësy ngo chëb xaa parñee kuñ xaa Jesús preb tsiin tso pe cos jkëëkiy xaa Jesús. Per lëë Jesús pkiitsy kë lyu aan lëë xaa bislo xkëë xaa lo lyu con xkweñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aan como xyaldy kñabtiits xaa, lëë Jesús blis kik aan lëë Jesús chëb: —Deelñee no tu xaa nii nody xtol lady to, klo xaa go jkëë kyo me. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Lëë xaa pkiitsy kë lyu stub, xkëë xaa lo lyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tsiñee biñ xaa go ngo, lëë xaa pkaa nëz tuga xaa, klosy xaa nii mastre kol. Lëë kwnaa go so gak lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lëë Jesús blis kik aan lëë xaa chëb lo kwnaa go: —¿Ko meñ nii xkëëkiy lii? ¿Pe ni tu me kwtiñdy lii? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lëë me chëb: —Ni tu me, xey. Tsigo lëë Jesús chëb: —Nikle naa kiñdyaa lii. Na byey aan kpikchedroo kuñoo tol go. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Lëë Jesús kwnee lo meñ stub aan lëë xaa chëb: —Naa nak bini nii xsaani lo meñ, aan kchësy meñ nii kiidnal naa jkaa bini nii kluuy xa kpañ meñ tsiin kyënsëdy meñ lo nguey. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tsigo lëë xaa fariseo chëb: —Misme lii xñee cho nakoo. Nlidy kchë nii xñeel. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Lëë Jesús chëb: —Nikxe nii misme naa xñe cho nakaa, nli kchë nii xñen. Por nanaa pa pchon ni nanaa pa kan, per lëë lëë do nandy to pa pchon ni nandy to pa kan. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lëë do chuñ kyalxtisy sinak nii no kik meñ lo kislyu re. Naa, ni tu cho xkëëkiydyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Per deelñee kuñaa kyalxtisy, sinak nii xñabey Dios kuuñtsyeyno. Lëdy nonsyaa chuñ kyalxtisy, sink chopaa pxosyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo xley do kë nii deelñee tugak së lo xtiits chop meñ, nliw. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chopaa pxosyaa nii pxaal naa xñe cho nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lëë xaa fariseo kwnabtiits chëb: —¿Ko pxoosyoo? Lëë Jesús chëb: —Xyuumbeydy to naa, ni xyuumbeydy to pxosyaa. Deelñee nyuumbey do naa, nyuumbeyak to pxosyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kchësy ngo chëb Jesús mentre lëë xaa noyuuñ kseedy meñ leñ lidzy Dios laañee nche sob alcansiy. Per ni tu cho kwnaasty xaa, porñee karty tsitsiñ xwor xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Lëë Jesús chëb stub: —Lëën kya aan lëë do kyub naa, per lëë do kety lo xtol do, por chilody së do laañee kan. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tsigo lëë meñ Israel nii xñabey bislo xñee lo xcombañer: —¿Penak nii xñee xaa nii chilody kyo no laañee tsi xaa? ¿Pe sety xaly xaa yak? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Lëë Jesús chëb: —Meñ leñ kyety re nak to, per naa meñ leñ klaa rek nakaa. Lo kislyu ngab to, per naa kpaa ngabaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lëën niy nii lëë do kety lo xtol do, por deelñee knilasty to nii naa nak xaa nii nakaa, lëë do kety lo xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsigo lëë xaa go chëb: —¿Cho nakoo? Lëë Jesús chëb: —Destye klo lëën niy lo do cho nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndaly nii no kniyaa ni kuuñkiyaa, per tiitslisy xñee xaa nii pxaal naa, aan kchësy nii xñen lo meñ biñ tyagaa pchoow chuw xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per byeñdy meñ nii Tat Tios xaa nii sob kpaa pseety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Por ngo nii chëb xaa: —Tsiñee lëë do jkëënal mguiy nii pxaal Dios lo crusy, lëë do kyeñ nii naaw. Xñedyaa nii xlyañsye styoon, sink nii bluuysye Tat Tios lon xñen. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Lëë xaa nii pxaal naa nakni naa. Karty ksaan xaa naa nonsyaa, por tugak chuuñtsyeyaa nii xyostyoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tsiñee lëë meñ biñ nii kwnee Jesús, ndaly meñ bniladzy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lëë Jesús chëb lo meñ Israel nii bniladzy xtiits xaa: —Deelñee ksaandy to xtitsaa, nli nii xpëëdscuelaa nak to. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Lëën kluy tiitsli lo do, aan lëë tiitsli klaa lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tsigo lëë meñ chëb: —Lo xtiiy Abraham xsyoop noo. Ni tu cho karty ksiniy lëë noo. ¿Xa mod nii xñeel lëë noo laa? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Lëë Jesús chëb: —Nli xñen nii kchësy meñ nii chuñ tol këtuu lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tu xaa nii no xpixwan lëdy meñ wlidzy nak xaa, por chilody tso xaa lidzy xpixwan xaa tyub nii kpañ xaa. Per lëë xaa nii chaly lidzy pxosy schilo tso xaa lidzy pxosy xaa tyub nii kpañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Por ngo, deelñee klaa Xiñ Dios to lo tol, lëë do kyënlaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nanaa nii lo xtiiy Abraham sëëd to, per lëë do chakladzy kuty to naa, porñee chaklasty to ksoob to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nii konaa chuuñtsyey Tat Tios xñen lo do, nikle gaa lëë do nii në pxosy to lo do chuuñtsyey do. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tsigo lëë meñ chëb: —Abraham nak pxoosy noo. Per lëë Jesús chëb: —Deelñee nyak to xiñ Abraham nyuuñtsyey do nii beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per nikxe bluyaa kchë tiitsli nii bluuy Dios lon, lëë do chakladzy kuty to naa. ¡Ni tu vuelt beeñtsyeydy Abraham nii chakladzy to kuuñtsyey do! ");
INSERT INTO ztqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nii chuuñtsyey pxosy to chuuñtsyey do. Tsigo lëë meñ chëb: —Lëdy mëëd xaly nak noo. Tugak pxoosy noo no. Lëë Dios nak pxoosy noo. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tsigo lëë Jesús chëb: —Deelñee nyak Dios pxosy to nguëstyoo do naa, por lo Dios pchon aan lëën so nu. Syeldyaa porñee chakladzyaa, sink lëë Dios pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Penak nii xyeñdy to nii xñen? Xyeñdy to porñee chaklasty to jkëëtyag to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xaa tox nak pxosy to, xlad xaa no do aan nii xyostyoo xaa chuuñtsyey do. Destye klo nweety bñech nak xaatox ni iip xñeedy xaa tiitsli. Tsiñee lëë xaa xñee, nonsyke tiits xuuy xñee xaa, por lëë xaa nak pxosy wnee xuuy. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Per lëë naa nii xñen nonsyke tiitsli, xnilasty to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cho do dyon kyax kñë nii no xtolaa? Aan deelñee tiitsli na xñen, ¿penak nii xnilasty to xtitsaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kchësy meñ nii ngab lo Dios xkëëtyag xtiits Dios, per lëë lëë do ngabty to lo Dios, ngo nii chaklasty to jkëëtyag to xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tsigo lëë meñ chëb: —Nli gak xtiits noo tsiñee xñee noo nii meñ Samaria nakoo ni tsiñee xñee noo nii kyalbini mal no leñ styool. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tsigo lëë Jesús chëb: —Ni tu kyalbini mal nody leñ styoon. Tat Tios chuuñ ksakaa ni xlisklaan, per lëë do xsyablyu naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Chaklastyaa nii klisklaa do naa, nikxe nii no tu xaa nii chakladzy klisklaa meñaa. Lëë xaa go chuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nli xñen nii kejty kchë meñ nii xsoob xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lëë meñ chëb: —Na si nagon, ndon noo nii no kyalbini mal leñ styool, por kuty Abraham ni kuty kchësy profet. Lëë lii name xñeel: “Kejty kchësy meñ nii xsoob xtitsaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Pe mastre nayak nakoo lo pxoosy noo Abraham nii kuty ksa profet? ¿Cho xsyakoo nii nakoo? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Lëë Jesús chëb: —Deelñee misme naa klisklaa naa, pa nondyo. Per lëë pxosyaa nii xñee do nak xDios to xlisklaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Xyuumbeydy to Dios. Naa si xyuumbeyaa xaa. Deelñee kniyaa nii xyuumbeydyaa xaa, tu wnee xuuy nii nak sinak to nakaa. Per xyuumbeyaa xaa ni xsobaa xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ble pxusykoltoo do Abraham tsiñee byeñ xaa nii lëën kyely, aan tsiñee lëë xaa kon naa, lëë xaa ble. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tsigo lëë meñ chëb lo Jesús: —Ni choowptsii iz name chaptyoo, ¿aan xñeel nii lëël kon Abraham? ");
INSERT INTO ztqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Lëë Jesús chëb: —Nli xñen nii nolaa worñee lëë Abraham koly. ");
INSERT INTO ztqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Por ngo lëë meñ kwseñ kyo par klaal kyo meñ Jesús, per lëë Jesús kwyolan aan lëë xaa pchoo lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lëë Jesús sitedy tub lugar, tsiñee lëë xaa kon tu xaa nii koly ciegw. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aan lëë xpëëdscuel xaa kwnabtiits chëb: —Maestre, ¿penak nii koly xaa re ciegw xaa? ¿Pe por xtol pxosy xaaw ote por misme xtol xaaw yak? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Lëë Jesús chëb: —Lëdy por xtol xaaw, ni lëdy por xtol pxosy xaaw, sink lëëw ptsyool xaa parñee kuuñtsyey Dios tu kyalntson por lëë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","No nii kyëë no xtsiiñ xaa nii pxaal naa lëë ka bii nyaani. Por tsi lëë lyu jkyey, ni tu cho chilody kyë tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Naa xsaani lo meñ mentre lëën bii so lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Loxsye chëb Jesús ngo, lëë xaa pchoo mxeñ lo lyu, aan lëë xaa kwtëëb peñ go lo xaa nii chandy, ");
INSERT INTO ztqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ni lëë xaa chëb: —Kutiib lool chu pily nii lë Siloé. (Tiits ko nak sinak nii xñee ñe: Pxaal.) Lëë xaa nii chandy ko kutiib lo aan tsi lëë xaa bikche, lëë lo xaa tse byaly. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tsi lëë meñ nii xyuumbey xaa kon nii lëë xaa byak, lëë meñ bislo xñee: —¿Pe lëdy lëë xaa gue nayak xsyob pal nëz xñab tumi? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","No meñ xñee: —Lëëw, lëë xaaw. No gaa meñ xñee: —Lëdy xaaw, per si chakpee xaa go chak xaa. Per lëë xaa nii byak xñee: —Lëëw, naaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsigo lëë meñ xñabtiits xñee: —¿Xa mod nak tsigo nii lëël chan? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tsigo lëë xaa nii byak xñee: —Lëë xaa nii lë Jesús pkadz peñ kwtëëb lon. Loxsye ngo lëë xaa në lon: “Kwey chu pily Siloé aan kwtiib lool.” Lëën kwya, aan tsiñee lëën lox kwtiib lon, lëëw byaly. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Lëë meñ chëb: —¿Ko xaa go tsigo? Lëë xaa nii byak chëb: —Nandyno. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lëë meñ kuni xaa nii byak lo xaa fariseo. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tse nii xiladzy meñ Israel lo tsiiñ pkadz Jesús peñ nii kwtëëb Jesús lo xaa nii byak. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Por ngo, wi xaa fariseo kwnabtiits chëb: —¿Xa mod nak nii lëë lool byak? Lëë xaa nii byak chëb: —Peñ ptyëëb lon, aan tsi lëëw lox kwtiibaa, lëëw byaktsey. Lëë na lëën chan. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tsigo no xaa fariseo chëb: —Lëdy xlad Dios no xaa nii beeñ kyak lii, por xsaldy xaa tse nii xiladzy meñ Israel lo tsiiñ. No gaa xaa chëb: —Deelñee ngoptol xaa, ¿xa kchilo kuuñtsyey xaa kyalntson re? Por ngo lëë xaa kok chop tiiy. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lëë xaa fariseo kwnabtiits lo xaa nii byak ko stub chëb: —Ndon noo nii lëë xaa beeñ kyak lii. ¿Pe nëël dyon cho nak xaa? Lëë xaa nii byak ko chëb: —Naay xñen nii tu profet nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per bnilasty xaa Israel nii xñady lo xaa nii byak. Por ngo lëë xaa kwtsyetsy pxosy xaa ");
INSERT INTO ztqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aan lëë xaa chëb: —¿Pe lëë xiñ do nrii? ¿Pe nli nii destye nii koly xaa chandy xaa? ¿Xa mod nii lëë xaa chan nina? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lëë pxosy xaa nii byak ko chëb: —Ndon noo nii xiñ noow, ni nli nii destye nii koly xaa chandy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per ndondy noo xa byak xaa, ni ndondy kaa noo cho beeñ kyak lo xaa. Kwrooble xaa, kol nabtiits lo xaa. Misme lëë xaa kñë dyon xa byak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ptsyeb pxosy xaa, por lëë xaa Israel nii xñabey byaanle tiits nii klaady xaa sëëb meñ nii kniladzy nii lëë Jesús nak Crist ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por ngo lëë pxosy xaa chëb: “Kol nabtiits lo xaa. Bay kwrooble xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lëë xaa Israel kwnabtiits lo xaa nii byak ko stub chëb: —Pkon Dios nii nli nii xñeel, por ndon noo nii no xtol xaa nii beeñ kyak lii. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tsigo lëë xaa nii byak ko chëb: —Nandyaa deelñee no xtol xaa o nody kaaw, per nan nyëën nii klo xñady lon, lëë na lëën chan. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Lëë xaa nii xñabey kwnabtiits stub chëb: —¿Pe cos beeñ xaa lii? ¿Xa beeñ kyak xaa lool? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lëë xaa nii byak ko chëb: —Lëëw niylaa, per psaldy to xtitsaa. ¿Penak nii chakladzy to kniyno stub? ¿Pe wi do yak chakladzy sëëb to xlad xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsigo lëë xaa xñabey kwlootsyetsy xaa, ni lëë xaa chëb lo xaa: —Kwsëëb xlad xaa go, lëë gaa noo kyonaal Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ndon noo nii kwnee Dios lo Moisés. Per lëë xaa gue, ni ndondy noo pa pchoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tsigo lëë xaa nii byak ko chëb: —Nii ksee gaa ñe gon kan ñe nii nandy to pa pchoo xaa, aan lëë xaa beeñ kyak lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ndon no gon nii chondy Dios xtiits ngoptol. Xaktyee xtiits meñ nii xsoob xtiits xaa nii chuuñtsyey nii xyostyoo xaa chon xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lo nii kwche kislyu karty tso tu xaa nii kuuñ kyak lo tu meñ nii chaly ciegw. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Deelñee nyody xaa go xlad Dios, ni tu pe nchilody nyuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tsigo lëë xaa fariseo chëb: —Lo tol name kolyoo aan ¿chakladzyoo ksaabiniil lëë noo? Aan lëë xaa kwlii xaa ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Blyëëdyak lëë Jesús biñ nii lëë xaa fariseo kwlii xaa nii byak ko ktoo. Tsiñee lëë Jesús ptsyool xaa, lëë Jesús chëb: —¿Pe xniladzyoo xtiits mguiy nii pxaal Dios? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lëë xaa nii byak ko chëb: —Xey, kwnë dyon chow, parñee kniladzyaa xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tsigo lëë Jesús chëb: —Kayanloo xaa. Lëë mer xaa noyutiitsnil. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Lëë xaa nii byak ko psoxib lo Jesús chëb: —Xniladzyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Loxsye ngo lëë Jesús chëb: —Lëën syely lo kislyu re parñee kuñaa kyalxtisy tsiin kan kchë meñ nii xñady lo ni parñee kandy meñ nii xña lo. ");
INSERT INTO ztqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lëë bla xaa fariseo nii nche siko biñ nii kwnee Jesús aan lëë xaa kwnabtiits, chëb xaa: —¿Pe wi loo noo nawen xñady? ");
INSERT INTO ztqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Lëë Jesús kwëb chëb: —Deelñee nyak to ciegw, nyody xtol do. Per como xñee do nii chan do, no xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Lëë Jesús chëb: —Nli xñen nii kchësy xaa nii xsyëëbty nëz chu xikwraly mëkwxiily nak ngbaan. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per lëë xaa nii xkyënap mëkwxiily nëz chu kwraly xsyëëb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lëë xaa nii xkyënap kwraly xlaa xsyëëb xaa nii chikap mëkwxiily aan xñee lë xaa kchë mëkwxiily ni xyuumbey gaa ma tsiy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tsiñee lëë xaa lox xkwii ma kwraly, lëë xaa xñech lo ma aan lëë ma chinal xitsy xaa porñee xyuumbey ma tsiy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per chinaldy ma meñ nii xkaatyee, porñee xyuumbeydy ma tsiy chol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Lëë Jesús bitiits ngo, per byeñdy meñ xa nako. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lëë Jesús chëb stub: —Nli xñen nii naa nak sinak chu kwraly laañee xtyedy mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngbaan kchë xaa nii biid worñee karty kyelyaa, per psaldy mëkwxiily xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naa nak sinak chu kwraly laañee xtyedy mëkwxiily. Pe kakty meñ nii sëëb nëz chu kwraly, sink lëë meñ go kak sinak mëkwxiily nii xtsyol kizh tsiñee xchoo ma kwraly. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Kchë xaa nii nak ngbaan xkwan, chuty ni xnitylo, per naa, lëën syely parñee mbëë kpañ meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naa nak xaa nii ngui chan mëkwxiily. Kchë xaa nii xkëstyoo mëkwxiily xtee xaa xkyalmbañ xaa por lëë ma, ");
INSERT INTO ztqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","per lëë xaa nii xkyë lo mëkwxiily par ktsiñaa tumi, tsiñee chan xaa lëë pëw sëëd, nche gak mëkwxiily lëë xaa xooñ, porñee lëdy xma xaaw. Por ngo lëë pëw xñaasy mëkwxiily ni lëë pëw xsëëb tañ ma. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Xooñ xaa porñee par ktsiñaa xaa tumi xkyë xaa tsiiñ, xcuenjty xaa mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Naa nak xaa nii ngui chan mëkwxiily. Xyuumbeyaa xpëkwxiilyaa ni xyuumbey gaa ma naa ");
INSERT INTO ztqNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","sinak nii xyuumbey Tat Tios naa ni xyuumbeyaa xaa. Xtedyaa xkyalmbañaa por mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chaapaa stubla mëkwxiily nii nody kwraly re, per no nii kakxin ma parñee kyak ma tugak kwraly ni tso tugak xaa nii kyënap ma. Son ma xtitsaa tsi lëën kñe. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Xkëstyoo Tat Tios naa porñee xtedyaa xkyalmbañaa parñee kpikche jkano stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni tu cho xlady xkyalmbañaa, sink xaalyaa xtedyo. Chaapaa nii ktedyno ni chaap kaan nii kpikche jkano. Nrii nak nii në Tat Tios lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tsiñee lëë meñ biñ kchë tiits re, lëë meñ kok chop tiiy stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","No meñ chëb: —Chak wety xaa gue, tu kyalbini mal no leñ styoo xaa. ¿Penak nii xsal do xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","No gaa meñ chëb: —Ni tu xaa nii no kyalbini mal leñ styoo xñeedy singo. ¿Pe schilo kyalbini mal nawen kuuñ kyak lo meñ nii chandy? ");
INSERT INTO ztqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mer mëë nii chak nal, lëë meñ Jerusalén noyuñ xilni lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Lëë Jesús kaa këno nëz laa lë xcorredor Salomón. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Lëë meñ ptyop lo xaa aan lëë meñ kwnabtiits chëb: —¿Axte pa wor na busy kyal lox jkanoo kik noo? Deelñee lii nak Crist, kwnë gaaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tsigo lëë Jesús chëb: —Lëëw niylaa aan bnilasty to xtitsaa. Kchësy cos nii chuuñtsyeyaa con xtiitspey Tat Tios xluuy cho nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Per xnilasty to xtitsaa porñee lëdy xpëkwxiilyaa nak to. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Xyuumbey xpëkwxiilyaa tsiyaa, nikle gaa naa xyuumbeyaa ma ni chiidnal ma naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naa xtedy kyalmbañ nii xnitylody lo meñ nii nak xpëkwxiilyaa, aan tsitsiñdy tse nii kety meñ go, ni ni tu cho klady meñ go lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mastre non Tat Tios nii bneetsy kchë meñ go lon, aan ni tu cho chilody kwii meñ go ña xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tugak nakaa chopaa Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tsigo lëë meñ kwseñ kyo stub par klaal kyo meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Per lëë Jesús chëb: —Ndaly cos buen beeñtsyeyaa por xkyalwnabey Tat Tios. Kol në dyon ¿pe por ngo chakladzy to jkëë kyo do naa? ");
INSERT INTO ztqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lëë meñ chëb: —Klaal kyody noo lii por cos buen nii beeñtsyeyoo, sink lëë noo klaal kyo lii porñee pxiñoo tiits lo Dios. Sinak chol meñ nakoo aan lëël chakladzy kakoo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Lëë Jesús chëb: —¿Pe lëdy lo xley do nawen kë nii lëë Dios chëb: “Kchësy to nak dios”? ");
INSERT INTO ztqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ndon no nii leñ kitsy nii kë xtiits Dios xñee nii lëë xaa kwloolë dios kchë meñ nii psal xtiits xaa, aan ni tu cho chilody gon ktsëë xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aan deelñee Tat Tios kwle naa ni pxaal naa lo kislyu, ¿xa mod tsigo xyax to xñee do nii lëën pxiñ tiits lo Dios porñee kwnen nii naa nak Xiñ Dios? ");
INSERT INTO ztqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Deelñee chan do nii chuuñtsyeydyaa nii xñabey Tat Tios, knilasty to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per deelñee chuuñtsyeyaa nii xñabey Tat Tios, nikxe knilasty to xtitsaa, kol kniladzy kchë cos nii chuuñtsyeyaa, parñee kyeñ do nii tugak nakaa chopaa Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Por ngo lëë meñ kwloo kyeñ nyaasy Jesús stub, per lëë Jesús pxooñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Lëë Jesús si stublad chu kiigwpee Jordán, aan tsi lëë xaa ptsiñ laañee pchoobnis Juan meñ, lëë xaa kwlës. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndaly meñ kutedy lo xaa siko xñee: —Nikxe nii beeñtsyeydy Juan ni tu kyalntson, per nli kchë nii kwnee xaa worñee bitiits xaa cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ndaly meñ bniladzy xtiits Jesús siko. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kwyo tu xaa xsyaknë nii pcholë Lázaro. Betania lë xkyedzy xaa. Siko kwyo xaa ksa psyañ xaa Mariy ni Marty. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lëë Mariy re nak kwnaa nii kwtiib niy Jesús con aceit nii xlyaa nex aan beeñ jkwiitsy mew con kits kik me. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chop pël kwnaa go pxaal tiits lo Jesús chëb: —Lëë xamiigwoo xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tsiñee lëëw biñ Jesús, lëë xaa chëb: —Kujty kyalkits ko xaa, sink lëë kyalkits ko jkiiñ parñee kluuy Dios xkyalwnabey ni parñee kak nyoo xkyalwnabey Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Xkëstyoo Jesús Mariy, ni Marty ni Lázaro, ");
INSERT INTO ztqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","per tsiñee lëë xaa biñ nii lëë Lázaro xsyaknë, lëë xaa kwlës schop kpidz laañee kwey tiits lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Loxsye ngo lëë xaa chëb lo xpëëdscuel xaa: —Kol tsoo Judea stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tsigo lëë xpëëdscuel xaa chëb: —Maestre, kal pa tse go kesy kokladzy meñ Israel nii no nëz tañ go nyuty lii lo kyo, ¿aan chakladzyoo tsil siko stub? ");
INSERT INTO ztqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Per lëë Jesús chëb: —¿Pe nlidy nayak nii tsiipchop wor nak tu kpidz? Por ngo xlyasty niy xaa nii xkyënsë yutsye, porñee xsaani bini nii xsaani lo kislyu re lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Per lëë xaa nii xkyënsë kyool xlyadzy niy xaa porñee kindy bini. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lëë xamigw no Lázaro kuutkesy, per lëën kakuuñ kna xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lëë xpëëdscuel xaa chëb: —Deelñee kuutkesy xaa, klyëëdy lëë xaa kyak. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Per byeñdy xpëëdscuel Jesús nii lëë Lázaro kuty. Nladzy xaa te nli nii kuutkesy Lázaro sinak nii chakesy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Por ngo lëë Jesús chëb: —Lëë Lázaro kuty. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Xlen nii sodyaa siko wor go, por lal tu bueno par lëë do parñee kniladzy to xtitsaa. Per kol tso ton no xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tsigo lëë Max nii kwloolë xaa Kwach chëb lo xcombañer: —Kol tsoo wi no parñee kety no ksa no xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tsiñee lëë Jesús ptsiñ, taple kpidz kok nii pkyeetsy Lázaro. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tsonak mily metre xsyë meñ par tsi meñ Betania tsiñee xchoo meñ Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Por ngo ndaly meñ Jerusalén kutedy lo Marty ni lo Mariy par kchoobladzy meñ styoo me por xkyalkuty psyañ me. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tsiñee lëë Marty biñ nii lëë Jesús no nëz ktsiñ, lëë me kuktsiil nëz xaa, per lëë Mariy byaan chu yu. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lëë Marty chëb lo Jesús: —Deelñee nsyool nu, nyejty psyañaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per nanaa nii sneetsy Dios kchë nii kñaboo. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Lëë Jesús chëb: —Lëë psyañoo kpañ stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tsigo lëë Marty chëb: —Nanaa nii lëë me kpañ ksa me meñ nii kutyle tse nii lëë Dios kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Lëë Jesús chëb: —Naa chuuñ kpañ meñ ni naa xnee kyalmbañ. Nikxe kety meñ nii xniladzy xtitsaa, lëë me kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kejty meñ nii bii mbañ deelñee kniladzy meñ xtitsaa. ¿Pe xniladzyoo tiits re dyon? ");
INSERT INTO ztqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Lëë me chëb: —Xniladzyaa nii lii nak Crist, meñ nii nak Xiñ Dios, ni xniladzyaa nii lii nak meñ nii no kiid lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Loxsye chëb Marty ngo, lëë me kutsyetsy pël me Mariy, aan tsilaan chëb me lo Mariy: —Lëë maestre kwlañche aan lëë me xkwetsy lii. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Siikñee biñ Mariy ngo, lëë me kuso aan lëë me si laañee so Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kwsëëbty kaa Jesús leñ kyedzy, sink lëë xaa kwlës laañee kuktsiil nëz Marty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tsiñee kon meñ Israel nii nche kchoobladzy styoo Mariy nii lëë Mariy pchoo wxooñ, lëë meñ go sinal xitsy me nladzy meñ go te chu paa sikoon me. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tsiñee lëë Mariy ptsiñ laañee so Jesús, lëë me psoxib lo Jesús, chëb me: —Deelñee nsyool nu, nyejty psyañaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mban ptee styoo Jesús kon xaa choon Mariy ni choon meñ nii ksa me ptsiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Lëë xaa kwnabtiits, chëb xaa: —¿Pa pkeetsy to xaa? Lëë meñ go chëb: —Të gaanoo kuyoo paw. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aan lëë Jesús biiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Por ngo no meñ chëb lo xcombañer: —Kol kuy gaanoo xaatke xkëstyoo xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","No gaa meñ chëb: —Lëë xaa gue psaabini lo meñ nii xñady lo. ¿Pe nody tu mod nii ndeelaa xaa Lázaro lo kyalkuty? ");
INSERT INTO ztqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lëë Jesús pteenë stub, aan lëë xaa big chu paa. Tu kyo pxoob chu paa nii pkyeetsy Lázaro. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lëë Jesús chëb: —Kol ktichee kyo gue. Per lëë psyañ Lázaro nii lë Marty chëb: —Neñdy tse xlyaa nigw me, por natse chak tap kpidz nii kuty me. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Per lëë Jesús chëb: —¿Pe lëdy nayak lëën niy lool nii deelñee xniladzyoo xtitsaa, lëël kan xkyalwnabey Dios? ");
INSERT INTO ztqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tsiñee lëë meñ ptichee kyo nii ntse chu paa, lëë Jesús blëp lo leñ kpaa chëb: —Tat Tios, xnetsyaa skizh lool porñee chonoo xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nanaa nii tugak chonoo xtitsaa, per lëën xñe sinrii parñee kniladzy kchë meñ re nii lii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Loxsye ngo lëë xaa kwchuptsyë, chëb xaa: —¡Lázaro, pchoo ske! ");
INSERT INTO ztqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lëë xaa nii kuty ko pchoo, nxituusy ña xaa ni niy xaa con ladx ni ntse lo xaa con stublë ladx. Tsigo lëë Jesús chëb: —Kol kxaak xaa, aan kol klaa kyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndaly meñ Israel nii kutedy lo Mariy bniladzy xtiits Jesús porñee kon meñ nii beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per no meñ kukutiits kchë nii beeñtsyey Jesús lo xaa fariseo. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tsigo lëë xaa fariseo ni xaa nii xñabey lo pxosy beeñ tu junt. Lëë xaa chëb: —¿Xa kuuñ no? Ndaly kchë kyalntson nii chuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Deelñee ksaan no, kchësy meñ kniladzy xtiits xaa, aan lëë xtisy Roma kiid kla kyalwnabey lo no aan lëë xaa knitylo xkyedzy no. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Per lëë tu xaa nii lë Caifás nii mastre non lo pxosy iz ko chëb: —Ni tu pe nandy to, ");
INSERT INTO ztqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni xyeñdy to nii buen kety tugak xaa por xkyedzy no, lëjty nii nitylo kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per chëbty Caifás ngo porñee kwlaño styoo xaa, sink lëëw chëb xaa porñee lëë Dios psyaab leñ kik xaa nii lëë Jesús kety por meñ Israel. Lëë Dios psyaab tiits ko styoo xaa porñee lëë xaa nak xaa nii mastre non lo pxosy iz ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lëjty nonsy por meñ Israel kuty Jesús, sink wi por kchë xiñ Dios nii nche tyub lo kislyu kuty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Destye tse go lëë meñ Israel nii xñabey byaan tiits nii lëë xaa kuty Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por ngo nii pchoo neñlody re Jesús, sink lëë xaa kwey tu kyedzy nii lë Efraín nii nche kexka tu tañ pidzy. Aan lëë xaa kwlës siko ksa xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lëë xilni gaa meñ Israel nii lë paskw sëëd yob, aan ndaly meñ no nëz si Jerusalén parñee kak nyë meñ sinak xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kwëkyub meñ Jesús leñ lidzy Dios, xñeesy meñ lo xcombañer: —¿Pe në do dyon? ¿Pe siid xaa lni ote kiijty xaa yak? ");
INSERT INTO ztqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lëë xaa fariseo gaa ni xaa nii xñabey lo pxosy chëb nii deelñee no cho nan pa no Jesús, këb xaaw parñee kchilo jkaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xoop kpidz chak falt kak paskw, lëë Jesús kwey Betania. Siko no xaa nii beeñ kpañ xaa nii lë Lázaro. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tsi lëë Jesús ptsiñ, lëë meñ beeñlo tu xtsee par Jesús. Lëë Marty kwtëë niskwaan. Wi Lázaro kwsob lo mezh chaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Lëë Mariy kuxi siik grol litre aceit nardo nii xlyaa nex. Aan nikxe nii nyazh nono, lëëw kwtëëb me niy Jesús. Loxsye ngo lëëw pkwiitsy me con kits kik me. Tyub leñ yu kwlaa aceit ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tsigo lëë Judas Iscariote nii pko Jesús ña meñ xñabey chëb: ");
INSERT INTO ztqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Penak nii kwtody aceit nii xlyaa nex re tson kyoow denario par kak meñ prob yudar? ");
INSERT INTO ztqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per chëbty Judas ngo porñee xkëstyoo xaa meñ prob, sink lëëw chëb xaa porñee ngbaan xaa, aan como lëë xaa kënoy bols tumi, xkwan xaa tumi nii no leeñgo. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lëë Jesús chëb: —Psaan me, por pena ngotsey mew par tse nii jkyeetsyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tugak kan do meñ prob, per lëë naa, lëdy tugak son lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ndaly meñ Israel kwey Betania tsiñee biñ meñ nii lëë Jesús ptsiñ siko. Kweydy meñ par kan meñ nonsy Jesús, sink lëë meñ kwey par kan meñ Lázaro nii beeñ kpañ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Per lëë xaa nii xñabey lo pxosy byaan tiits nii wi Lázaro kuty xaa, ");
INSERT INTO ztqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","porñee por Lázaro ndaly meñ Israel bniladzy xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tsi lëë lyu byaani ndaly meñ nii sitedy paskw Jerusalén biñ nii lëë Jesús ktsiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Lëë meñ pchug siñ par tsiktsiilnëz meñ xaa. Kchësy meñ xñee: —¡Skizh Dios! ¡Xaatke buen xaa nii pxaal xaa, xaa nii kak xrey meñ Israel! ");
INSERT INTO ztqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lady tu burr kwsob Jesús, por singo kë leñ kitsy nii kë xtiits Dios: ");
INSERT INTO ztqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kchësy to sinak to meñ Sión ktsyebty to. Kol kuy gaanoo lëë xrey do sëëd sobsye xaa lady tu burr wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Klo byeñdy xpëëdscuel Jesús nii beeñtsyey Jesús, per tsi lëë Jesús lox byëp kpaa, lëë xpëëdscuel xaa psaladzy nii kël nii sinrii ktsyool xaa aan nli gaa singo ptsyool xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kchësy meñ nii kon xa kwlii Jesús Lázaro leñ paa ni xa beeñ kpañ xaa xaa bitiitso. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kuktsiil nëz meñ Jesús porñee biñ meñ nii lëë xaa beeñtsyey kyalntson go. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Per lëë xaa fariseo bislo xñee lo xcombañer: —¿Pe chan dow na? Ni tu pe chilody kuuñtsyeey no. Kchësy meñ no xlad xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lady kchësy meñ nii kukiily lay lo Dios paskw no bla xaa sit. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lëë xaa sit ko big lo tu xaa Betsaida nii lë Felip aan lëë xaa chëb: —Xey, chakladzy noo tyon noo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Lëë Felip kukëbo lo Ndresy, aan chop xaa kukëbo lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Lëë Jesús nii nak mguiy nii pxaal Dios chëb: —Lëë wor kutsiñ nii lëë Dios klisklaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nli xñen nii deelñee kñaady xobxtily lo lyu, ktyaldyo, per deelñee kñaaw, lëëw ktyaly. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kchësy meñ nii xkëstyoo xkyalmbañ lo kislyu re kety, per kejty meñ nii xkëstyoody xkyalmbañ, sink lëë meñ go jkaa kyalmbañ nii xnitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kchësy xaa nii chakladzy kuñ xtsiñaa no nii kiidnal xaa naa parñee laañee tson siko tso xaa. Xle Tat Tios lo meñ nii chuñ xtsiñaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Mban xteedy styoon nina, per ¿pe sëpaa lo Tat Tios nayak nii kteelaa xaa naa lo kyalnë re con par ngo syelyaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tat Tios, bluuy xkyalwnabeyoo. Tsigo lëë meñ biñ tsiy tu xaa nii pchoo kpaa chëb: —Lëëw bluylaa, per lëëw kluyaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kchësy meñ biñ tsiy xaa go aan no meñ kwnee: —Tu nkwsiyo. No gaa meñ kwnee: —Lëdyo, tu angly kwnee lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lëë Jesús chëb: —Lëdy por naa biñ do tsiy xaa go, sink por lëë dow. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lëë wor kutsiñ nii lëë kyalxtisy kak lo kislyu re, ni lëë wor kutsiñ nii lëë Dios ksonëz xaa nii xñabey lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tsiñee lëën kyë lo crusy, lëën kuñ nii kchësy meñ kpig lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Singo mod lëë xaa chëb xa kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tsigo lëë meñ chëb: —Lo xleey noo xñee nii tsiñee lëë Crist kiid kpidy xaa. ¿Penak tsigo xñeel no nii kety mguiy nii pxaal Dios? Cho nak kaa mguiy nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Lëë Jesús chëb: —Xtsedre kan do bini. Kol kyënsë lëë ka lëë bini bii no parñee jkaady to nguey, por nandy kchë meñ nii xkyënsë lo nguey pa si. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lëë ka bii chan do bini, kol jkaaxcuento parñee tugak tsow lo do. Loxsye chëb Jesús ngo lëë xaa bi aan lëë xaa kwyolan lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nikxe nii kon meñ kchë kyalntson nii beeñtsyey Jesús, bnilasty meñ xtiits xaa, ");
INSERT INTO ztqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","sink lëë meñ beeñ cumplir nii pkëë profet Isaías tsiñee chëb xaa: Tat Tios, ¿cho bniladzy xtiitsoo na dyon? ¿Cho lo bluuy gaal xkyalwnabeyoo? ");
INSERT INTO ztqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pchilody niladzy meñ xtiits Dios, porñee lë gak profet Isaías pkëë sinrii: ");
INSERT INTO ztqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Lëë Dios ptse lo meñ ni lëë xaa beeñ jkyedzy styoo meñ, parñee kandy meñ ni kyeñdy meñ. Kchë nrii ptsyool meñ parñee ktikchedy meñ styoo lon, tsiin ktsilyaa xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kchë nrii kwnee Isaías porñee kon xaa xkyalwnabey Jesús aan lëë xaa bitiits xa nak kyalwnabey go. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nikxe nii singo chëb Isaías, ndaly meñ Israel nii xñabey bniladzy xtiits Jesús, per kwneedy xaaw porñee ptsyeb xaa ngwii xaa fariseo xaa ktoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Singo beeñtsyey xaa go porñee xyore xkyalnsaak meñ lo kislyu re styoo xaa que xkyalnsaak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Lëë Jesús chëb: —Kchësy meñ nii xniladzy xtitsaa lëdy nonsy xtitsaa xniladzy meñ go, sink wi xtiits xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ni wi gaa lo xaa nii pxaal naa xuy meñ nii xuy lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naa nak bini nii biid lo kislyu parñee kyënsëdy kchë meñ nii kniladzy xtitsaa lo nguey. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Deel no meñ nii chon xtitsaa aan xsaldyo, lëdre naa jkëëkiy meñ go, por xsyeldyaa par jkëëkiyaa meñ, sink lëën syely par kteelaan meñ lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kchësy meñ nii xtilyni naa ni xsaldy xtitsaa nol cho jkëëkiy meñ go. Kchësy tiits nii kwnën jkëëkiy meñ nii xsaldy naa tse nii lëë Dios kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porque xñedyaa nii xlyañ styoon, sink lëë Tat Tios nii pxaal naa xñee kchë nii kluyaa ni kñen lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ni nanaa nii kchë nii xñee Tat Tios xnee kyalmbañ nii xnitylody. Por ngo, kchë nii xñee Tat Tios xñen lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tse nii kxe kak paskw, nanle Jesús nii lëë wor kutsiñ nii lëë xaa kpi lo kislyu re par kyey xaa lo Tat Tios. Tugak pkëstyoo xaa kchë meñ nii bniladzy xtiits xaa axte tse nii lëë xtse xaa psa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lëë Jesús ncheyaw xtsee ksa xpëëdscuel tsiñee lëë xaatox kwloo kik xiñ Simoñ Iscariote nii lë Judas nii lëë xaa kak niladzy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nan Jesús nii lëë Tat Tios ptee kyalwnabey lo xaa ni nan Jesús nii lo Dios pchoo Jesús ni lo Dios kaa kyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Per mer worñee noyak xtsee lëë Jesús kuso, lëë xaa kwlii xmankw xaa ni lëë xaa pxituu tu tway xpans xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Loxsye ngo lëë xaa kwtëë nis leñ tu tiñ aan lëë xaa bislo xkiib xaa niy xpëëdscuel xaa ni lëëw pkwiitsy xaa con tway nii nxituu xpans xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tsiñee kol nii lëë xaa kiib niy Simoñ Pedre, lëë Simoñ Pedre chëb: —¿Penak nii lii kiib niyaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tsigo lëë Jesús chëb: —Xyeeñdyoo penak nii chuuñtsyeyaa nrii nina, per tsiñee tedsyo, lëëw kyeeñoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Per lëë Pedre chëb: —Nikxe pere kladyaa kiiboo niyaa. Lëë Jesús chëb: —Deelñee kiibtyaa niyoo chilody tsol xladaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tsigo lëë Simoñ Pedre chëb: —Deelñee singo busy nako, kiibtyoo nonsy niyaa, sink wi ñan ni kikaa kwtiib. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Per lëë Jesús chëb: —Nonstyee niy xaa nii kal lox kosy precisy tsadx, por nder lady xaa nyë. Nyë do nii lëë do, nikxe nii lëdy kchësy to nyë. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chëb xaa nii lëdy kchë xpëëdscuel xaa nyë, porñee nanle xaa cho kak niladzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Loxsye kwtiib Jesús niy xpëëdscuel, lëë xaa kokw xmankw xaa stub, aan lëë xaa psob lo mezh aan lëë xaa chëb: —¿Pe byeñ do kchë nii beeñtsyeyaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Maestre ni xey xñee do lon. Tiitsli xñee do, porque nli maestraa ni nli xey nakaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Per deel maestraa ni xeyaa aan kwtiibaa niy do, singo gak lëë do no nii kiib to niy xcombañer do. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Lëën bluy nrii lo do parñee wi do kuuñtsyey nii beeñtsyeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nli xñen nii mastre non tu xaa nii xchee que xaa nii xkyë tsiiñ, ni mastre non xaa nii xñabey que xaa nii chi mandad. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Deelñee kyeñ do kchë cos re ni kuuñtsyey dow, mbëë kpañ do. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Lëdy kchë lo do xñen. Nanaa cho kwlen. Per no nii kak cumplir xtiits Dios nii xñee sinrii: “Lëë xaa nii chaw xkuñaa ktilyni naa.” ");
INSERT INTO ztqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Lëën xñe kazh nrii lo do parñee tsiñee lëëw kak, kniladzy to nii naa nak Crist. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nli xñen nii kchësy meñ nii xleni xaa nii xalaa xluuy xtitsaa, xleni naa. Aan kchësy meñ nii xleni naa, xleni xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Loxsye chëb Jesús ngo, mban ptee styoo xaa, aan lëë xaa chëb: —Nli xñen nii misme tu do jko naa ña xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tsigo lëë xpëëdscuel Jesús xuy lsasy lo xcombañer, porñee nandy xaa cho xñee Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Lëë tu mëëdscuel nii mastre xkëstyoo Jesús sobyaw xtsee kwi Jesús, ");
INSERT INTO ztqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","aan lëë Simoñ Pedre kwloo señ lo xaa parñee kñabtiits xaa cho pseety Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tsigo lëë xaa big kexre kwi Jesús aan lëë xaa kwnabtiits, chëb xaa: —Xey, kwnë dyon chow. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tsigo lëë Jesús chëb: —Lëën jkadz tublë kyaxtily, aan lo xaa nii kteno, xaa gow. Lëë xaa pkadz tublë kyaxtily aan lëëw pteedy xaa lo xiñ Simoñ Iscariote nii lë Judas. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aan tsi lëë Judas lox taw kyaxtily go, lëë xaatox kwsëëb leñ styoo xaa. Tsigo lëë Jesús chëb: —Nii no kikoo kuuñtsyeyoo, beeñtsyey gaaw klyëëdyoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per ni tu xaa nii nche sob lo mezh byeñdy penak chëb Jesús singo. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aan como lëë Judas nak cuent tumi, no xaa nladzy tsaaplaa chëb Jesús nii no nii tsisi Judas tu cos nii jkiiñ paskw, o no gaa nii kteedy Judas pe tu cos lo meñ prob. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Loxsye taw Judas kyaxtily go, lëë Judas pchoo. Lëë lyu gaa pkyeyle. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Loxsye pchoo Judas, lëë Jesús chëb: —Na si lëë do kan xkyalwnabey mguiy nii pxaal Dios, aan por mguiy go lëë do kan xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aan deelñee xluuy mguiy nii pxaal Dios xa nak xkyalwnabey Dios, klyëëdy lëë Dios kluuy nii wi mguiy go xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xiñ, xtsedre son lo do. Nikxe kyub to naa, per nii chëpaa gaa lo meñ Israel nii xñabey, xñen lo do: Chilody së do laañee kan. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lëën xñabey nii kuuñtsyey do tu cos ngub nii kniyaa: Kol jkëstyoo xcombañer do. Sinak nii xkëstyoon lëë do, no nii jkëstyoo do xcombañer do. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Deelñee jkëstyoo do xcombañer do, kchësy meñ kyeñ nii xpëëdscuelaa nak to. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Lëë Simoñ Pedre kwnabtiits lo Jesús chëb: —¿Pa tsil? Lëë Jesús kwëb chëb: —Chilody sënaloo naa nina, per tseyladzy lëël kiidnal. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tsigo lëë Pedre chëb: —¿Penak nii chilody sënalaa lii nina? Axte xkyalmbañaa schilo ktedyaa por lii. ");
INSERT INTO ztqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lëë Jesús chëb: —¿Pe nli nii steedyoo xkyalmbañoo por naa? Por antes nii jkwetsy nguidy kol tson vuelt, lëël këb nii xyuumbeydyoo naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Kteenëdy to. Tugak kol ksaladzy Dios ni kol ksaladzy naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nroob lugar no lidzy pxosyaa. Deelñee nyody lugar, niyaa lo do. Lëën kakxixkwaa laañee tso do. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aan loxsye kxixkwaan laañee tso do, lëën kyely kxi lëë do, parñee tso do laañee tson. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nanle to nëz nii xlyañ laañee tson. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tsigo lëë Max chëb: —Ndondy noo pa tsil. ¿Xa mod kaknan noo nëz? ");
INSERT INTO ztqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tsigo lëë Jesús chëb: —Naa xtsiñni meñ lo Dios ni naa xñe tiitsli ni naa xtedy kyalmbañ nii xnitylody lo meñ. Chilody ktsiñ meñ lo Tat Tios deelñee kanidyaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Deelñee nyuumbey do naa, nyuumbey do pxosyaa. Per destye nina lëë xaa kyuumbey do, por tugak kwso xaa lo do ni tugak kon do xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tsigo lëë Felip chëb: —Blaa tyon noo Tat Tios tsiin kniladzy styoo noo. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tsigo lëë Jesús chëb lo Felip: —¿Blaktre tiemp kok nii non lady to, aan xyuumbeydyoo naa? Kchë meñ nii chan naa chan Tat Tios. ¿Penak nii chakladzyoo klaan kan do Tat Tios? ");
INSERT INTO ztqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Pe xnilastyoo nayak nii non leñ styoo Dios ni no Dios leñ styoon? Kchë nii xñen lo do xñedyno porñee xlyañsyew styoon. Lëë Tat Tios nii no leñ styoon chuuñtsyey nii chakladzy. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kol kniladzy nii non leñ styoo Tat Tios ni kol kniladzy nii no Tat Tios leñ styoon. Deelñee gaa xnilasty to nii xñen, kol kniladzy kchë nii chan do chuuñtsyeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nli xñen nii schilo kuuñtsyey meñ nii xniladzy xtitsaa kchë nii chuuñtsyeyaa ni ndalyre gaa nii kchilo kuuñtsyey meñ go, por lëën kya lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aan kchësy nii kñab to lo Tat Tios porñee xniladzy to xtitsaa, lëëw kuuñtsyeyaa parñee kluyaa xkyalwnabey Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kchë cos nii kñab to porñee xniladzy to xtitsaa, lëëw kuuñtsyeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Deelñee xkëstyoo do naa, suuñtsyey do nii xñabeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lëën kñab nii kxaal Tat Tios stu xaa nii tugak kuñ lëë do yudar. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Lëë xaa nii kiid nak Kyalbini Ntson nii xñee cho nak Dios aan chilody sëëb xaa leñ styoo meñ nii xnilasty xtitsaa, porñee xyuumbeydy meñ xaa ni chandy meñ xaa. Per lëë lëë do xyuumbey do xaa, porñee lëë xaa no leñ styoo do aan iip kchoody xaa leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ksandyaa to nonsy to, lëën kpikche par kaknin lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xtsedre kan meñaa, per lëë do san do naa aan lëë do kpañ porñee mbañaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tsi lëë tse go tsitsib lëë do kyeñ nii nli non leñ styoo Tat Tios, ni nli no do leñ styoon, ni nli non leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kchë meñ nii chuuñtsyey nii xñabeyaa, nyoo nii xkëstyoo meñ go naa. Aan lëë pxosyaa jkëstyoo meñ nii xkëstyoo naa, nikle gaa naa lëën jkëstyoo meñ go ni lëën kluylo lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tsigo lëë stu xaa nii lë si lë Judas chëb: —¿Penak nii xaktyee loosy noo kluuylool? ¿Penak nii kluuyloodyoo cholsye lo meñ nii nche lo kislyu? ");
INSERT INTO ztqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tsigo lëë Jesús chëb: —Kchë xaa nii xkëstyoo naa xsal xtitsaa, aan lëë Tat Tios jkëstyoo kchë xaa go, ni lëën kyely chopaa Tat Tios par tsyo noo leñ styoo xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kchë xaa nii xkëstyoody naa xsaldy xaa xtitsaa. Kchë nii xñen lo do lëdy xtitsno, xtiits Tat Tios nii pxaal naaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Kchë nrii niyaa tyub nii kwyon lady to. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Per lëë Kyalbini Ntson nii kxaal Tat Tios xcuentaa kluuy kchë kchësy cos lo do ni kuñ lëë do yudar parñee ksaladzy to kchë nii bluylaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Lëën kya, per lëën ksan xkyalnsaakaa lo do. Lëën knetsy xkyalnsaakaa, per knestyno sinak xneetsy chol meñ nii nche lo kislyu rew. Kteenëdy to ni ktsyebty to, ");
INSERT INTO ztqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","por nanle to nii lëën kya, ni nanle to nii lëën kpikche kyely kanaa lëë do. Deelñee nli nguëstyoo do naa, nle do nyon do nii lëën kya lo Tat Tios, por mastre non Tat Tios que naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lëën xñe kazh nrii lo do parñee tsiñee lëëw kak, kniladzy to kchë nii niyaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Nroobdre kñen lo do, por lëë xaa nii xñabey lo kislyu re sëëd. Nikxe nii xñabeydy xaa naa, ");
INSERT INTO ztqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","per singo no nii kako parñee kaknan meñ nii nche lo kislyu nii xkëstyoon Tat Tios ni chuuñtsyeyaa nii xñabey xaa. Kol tsiso tsiin kpii no nu. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Naa nak sinak tu yag uv aan ni stu yag chakty si chakaa. Lëë pxosyaa nak sinak xaa nii chantsi yag uv. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Deelñee no tu xikwaa nii xkyëdy nex, lëëw xchug xaa. Per chantsi xaa kchë xikwaa nii xkyë nex ni chuuñ nyë xaaw parñee kyëre nex low. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nyë do nii lëë do, porñee bniladzy to kchë nii bluyaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kol kyënaady chexaa sinak kënaadyaa chex to. Por chilody kyë nex lo tu xikw yag deelñee kënaajtyoo chex tronk. Singo gak lëë do, ni tu pe chilody kuuñtsyey do deelñee kyënaajty to chexaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Naa nak sinak tu yag uv. Lëë do nak sinak xikwo. Deelñee kyënaady meñ chexaa ni kyënaadyaa chex meñ, ndaly nii kchilo kuuñtsyey meñ, por ni tu pe chilody kuuñtsyey meñ deelñee kuñdyaa meñ yudar. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kchë meñ nii xkyënaajty chexaa ksyëëb aan lëë meñ go kpidzy sinak xpidzy kchë xikw yag nii xtop meñ par tsek ki. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Deelñee tugak kyënaady to chexaa ni ksaandy to xtitsaa, schilo kñab to kchë nii kakladzy to aan lëëw knetsyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chuuñ ksak to Tat Tios tsiñee chuuñtsyey do xtsiñaa. Aan kchë nii chuuñtsyey do xluuy nii nli xpëëdscuelaa nak to. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Xkëstyoon lëë do sinak nii xkëstyoo Tat Tios naa. Singo gak lëë do kchoxsody to tsiin tugak jkëstyoon lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Deelñee ksoob to xtitsaa, tugak jkëstyoon lëë do, sinak nii xsobaa xtiits Tat Tios ni tugak kaa xkëstyoo xaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Lëën niy kchë nrii lo do parñee kle do sinak nii xlen ni parñee tugak kle do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lëën xñabey nii jkëstyoo do xcombañer do sinak nii xkëstyoon lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tsiñee chety tu xaa par kteelaa xaa xcombañer xaa nyoo nii tir xkëstyoo xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Xamigwaa nak to deelñee chuuñtsyey do nii xñabeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Xñedraa lo do mos, por nandy mos pe cos chuuñtsyey xaa nii xñabey mos. Xamigwaa nak to. Ngo nii lëën bluy kchë nii në pxosyaa lon lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kwledy to naa, sink naa kwle lëë do parñee tugak kuuñtsyey do nii xñabey Tat Tios. Aan kchë nii kñab to porñee xniladzy to xtitsaa kneetsy Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nrii nak nii xñabeyaa: Kol jkëstyoo xcombañer do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Deelñee xlëë meñ nii nche lo kislyu re chan lëë do, kol kaknan nii klo lon blëë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Deelñee nyak to sinak meñ nii nche lo kislyu re, nguëstyoo meñ lëë do. Per lëën kwle lëë do lady meñ nii nche lo kislyu re, aan por ngo xlëë meñ lo do, porñee naktre to sinak meñ nii nche lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tugak kol ksaladzy nii mastre non xaa nii xchee que xaa nii xkyë tsiiñ. Deelñee kwënlaag meñaa, wi do kyënlaag meñ. Ni deelñee psal meñ nii kwnen, salak meñ nii kñee do. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lëë meñ kyënlaag lëë do, porñee xsoob to xtitsaa ni porñee xyuumbeydy meñ xaa nii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Nyody xtol meñ deelñee nyely kluuydyaa xtitsaa lo meñ. Per na chilody këb meñ nii nandy pe beeñ. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wi lo pxosyaa xlëë meñ nii xlëë lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nyody xtol meñ deelñee nyandy meñ kchë kyalntson nii beeñtsyeyaa. Ni tu cho karty kuuñtsyey clasy kyalntson re. Per nikxe kon meñ kchë kyalntson go, lëë meñ xlëë lon ni xlëë meñ lo pxosyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per no nii kak cumplir tiits nii kë lo xley xaa nii xñee sinrii: “Pe beñdyaa aan blëë meñ lon.” ");
INSERT INTO ztqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Per tsiñee lëë xaa nii chuñ yudar kiid, lëë xaa kñee xcuentaa. Lëë xaa nak Kyalbini Ntson nii kxaal Tat Tios aan nonsyke tiitsli kñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ni wi do kñee xcuentaa, por tugak kwënal do naa destye nii bislon xluyaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Lëën chutiits kazh kchë cos re lo do parñee ksaandy to xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lëë meñ kwii lëë do ktoo ni sitsiñ tse nii këb meñ tu favor chuñ meñ lo Dios tsiñee chuty meñ do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kchë nrii kuuñtsyey meñ porñee karty kyuumbey meñ naa ni karty kyuumbey meñ Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lëën xñe kazh nrii lo do parñee ksaladzy to nii lëëw niylaa tsiñee lëë tse go tsitsib. ’Niydyaa nrii lo do worñee kal bniladzy to xtitsaa, por naa tugak kokni lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Per lëë na nii lëën kya lo xaa nii pxaal naa, ni tu do xñabtiisty dyon pa kan. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Lëël mban chak to porñee niyaa kchë cos re lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nli xñen nii buen kyan. Por deelñee kyadyaa, kiijty xaa nii chuñ yudar. Per deelñee kyan, naa kxal xaa go lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tsiñee lëë xaa kiid, lëë xaa kluuy lo meñ nii no xtol meñ, ni lëë xaa kluuy nii no tu nëz tubli, ni lëë xaa kluuy nii no xkyalxtisy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Lëë xaa kluuy nii no xtol meñ, porñee xnilasty meñ xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ni lëë xaa kluuy nëz tubli, por lëën kya lo Tat Tios, aan kantre to naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ni lëë xaa kluuy nii chuñ Dios kyalxtisy. Por ngo lëë xaatox nii xñabey lo kislyu re pkaal. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ndalyre nii no kniyaa lo do, per chilody kyeñ dow nina. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Per tsiñee lëë xaa nii nak Kyalbini Ntson kiid, lëë xaa kluuy nonsyke tiitsli lo do, por kñeedy xaa nii klyañ styoo xaa, sink lëë xaa kñee kchë nii kon xaa, ni lëë xaa kluuy cos nii nare kak. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lëë xaa kuuñ ksak naa, por lëë xaa kiidni xtitsaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kchë nii chap Tat Tios nak xcheñaa. Por ngo nii niyaa nii lëë Kyalbini Ntson kiidni xtitsaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Xtsedre kan do naa, per kak xtsedyak lëë do kan naa stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tsigo lëë bla xpëëdscuel xaa bislo xñabtiits lsa lo xcombañer xñee: —¿Penak nii xñee xaa nii xtsedre tyon no xaa, aan kak xtsedyak lëë xaa tyon no stub? ¿Ni penak nii xñee xaa nii lëë xaa kyey lo Tat Tios? ");
INSERT INTO ztqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Penak nii xñee xaa “xtsedre”? Xyeñdy no xa nak tiits ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lëë Jesús byeñ nii lëë xpëëdscuel xaa chakladzy kñabtiits lo xaa. Por ngo lëë xaa chëb: —Lëën niy lo do nii xtsedre kan do naa, aan kak xtsedyak lëë do kan naa stub. ¿Pe nrii nonabtiits lsa do lo xcombañer do? ");
INSERT INTO ztqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nli xñen nii lëë do koon ni lëë do kteenë tsiñee lëë kchë meñ nii nche lo kislyu kle. Per nikxe kteenë do, lëë xkyalnë do kyak kyalwle. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tsiñee lëë tu kwnaa kaly xiñ, mban chak me porñee lëë xwor yoob kol. Per tsi lëë mëëd lox chaly, ni xsalastre me yoob nii kwë me lo kyalwle nii lëë xiñ me kwlañche lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Singo gak lëë do xteenë do nina. Per tsi lëën kyely kan lëë do stub, lëë styoo do kyo nguiool, aan ni tu cho chilody kwii kyalwle go leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Tsi lëë tse go tsitsiñ, ni tu pe kñabtiistre to lon. Nli xñen nii kchë nii kñab to lo Tat Tios porñee xniladzy to xtitsaa, lëëw kneetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Axte nina ni tu pe karty kñab to porñee xniladzy to xtitsaa. Kol nab nii chakladzy to, parñee tsi lëëw kneetsy Dios, mastre kle do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nonsyke con cuent kwnen kchë nrii lo do. Per sitsiñ tse nii ksodraa cuent par kuuñ ksedyaa to, sink nëz nii xa nak Tat Tios kñen lo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tse go yuub to kñab nii kakladzy to lo Tat Tios porñee xniladzy to xtitsaa. Xkiiñdy nii naapee kñe lo Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Por xkëstyoo Tat Tios lëë do, porñee xkëstyoo do naa, ni porñee bniladzy to nii lëë Tat Tios pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lo Tat Tios pchon byelyaa lo kislyu. Per lëë na lëën kpi lo kislyu par kyan lo Tat Tios stub. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tsigo lëë xpëëdscuel xaa chëb: —Na si nagon, xyeeñ noo nii xñeel, aan xsodroo cuent par kñeel. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na si nagon, xtyon noo nii xaa chak nakoo. Xkiiñdy nii cho kñabtiits lool. Por ngo xniladzy noo nii lëë Dios pxaal lii. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tsigo lëë Jesús chëb: —Xniladzy to nina, ");
INSERT INTO ztqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","per sitsiñ wor ni lëëw kutsiñle gaa nina nii lëë do kchoots klyaal, aan lëë do ksaan naa nonsyaa. Per sodyaa nonsyaa, lëë Tat Tios nakni naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lëën bitiits kchë nrii lo do parñee pe tsinidy kik to, por naa nakni lëë do. Mban tedy to lo kislyu re, per ktsyebty to, por naa xñabey lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Loxsye kwnee Jesús kchë ngo, lëë xaa blëp lo leñ kpaa aan lëë xaa chëb: —Tat Tios, lëë wor kutsiñ nii lëël klisklaa xiñoo parñee klisklaa xiñoo lii. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Por lii pteedy tiits nii kñabey xaa kchësy lo meñ nii nche lo kislyu re, ni lii pteedy tiits nii kteedy xaa kyalmbañ nii xnitylody lo kchësy meñ nii pxaaloo lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kchësy meñ nii kwaal kyalmbañ nii xnitylody xniladzy nii liisy nak Dios ni xniladzy xtiits Jesucrist nii pxaaloo. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Beeñ ksakaa lii lo kislyu re, por lëën byal tsiiñ nii bneetsyoo lon. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lëë nana, Tat Tios, xñabaa nii klisklaal naa ni ksooboo naa kwil laañee sobaa worñee karty kwe kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Lo kislyu kwlel kchësy meñ nii pxaaloo lon, aan lëën bluy cho nakoo lo meñ go. Lool ngab kchë meñ go, aan lëël pxaal kchë meñ go lon, aan lëë meñ go psal xtiitsoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lëë na kchë meñ go nan nii kchë nii bneetsyoo lon xcheñoo nako. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Por lëën bluy tiits nii pxaaloo, aan lëëw psal meñ. Lëë meñ byeñ nii nli lool pchon, ni lëë meñ bniladzy nii lii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Xñabaa nii kaknil kchë meñ go. Xñabtyaa nii kaknil chol meñ, sink lëën xñab por kchë meñ nii pxaaloo lon, por lool ngab kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kchësy nii chaapaa nak xcheñoo, ni kchësy kaa nii chapoo nak xcheñaa, aan lëë kchë meñ nii pxaaloo lon xluuy tu kyalwnabeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Sodraa lo kislyu re, per lëë kchë meñ nii pxaaloo lon bii kyaan, por lëën kyely parñee tson lool. Tat Tios, kon kchë meñ go con kyalwnabey nii bneetsyoo lon, parñee kyak tusy meñ go sinak nii nak tusy no chop no. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Worñee kwyon lady meñ nii pxaaloo lon, konaa meñ go con kyalwnabey nii bneetsyoo lon. Ni tu meñ go kujty. Xaktyee meñ nii nolak kety kuty, parñee kak cumplir xtiitsoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Lëë nana lëën kyely laañee soboo. Per lëë ka lëën bii so lo kislyu lëën xñe kchë cos re, parñee kle kchë meñ go sinak nii xlen. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Lëën bluy xtiitsoo lo meñ nii pxaaloo lon, per lëë meñ nii nche lo kislyu xlëë porñee nodre kik meñ go sinak nii no kik meñ nii nche lo kislyu, nikle gaa naa nody kikaa sinak nii no kik meñ lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Xñabtyaa nii kwiil meñ go lo kislyu, sink lëën xñab nii klaadyoo jkaal xaatox meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nody kikaa si no kik meñ lo kislyu re. Singo gak kaa kchë meñ nii pxaaloo lon, nodre kik meñ go si no kik meñ lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Beeñlay kchë meñ go con xtiitsoo, por xtiitsoo nak tiitsli. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Lëën kxal kchë meñ go sinak nii pxaaloo naa lady meñ nii nche lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aan por kchë meñ go lëën xsob xtiitsoo, parñee wi meñ go ksoob xtiitsoo. Por tiitsli nak xtiitsoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Xñabtyaa nii kaknil nonstyee meñ nii xniladzyle, sink lëën xñab por wi meñ nii nare kniladzy xtiitsoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tat Tios, xñabaa nii kyak tusy kchësy meñ go sinak nii non leñ styool ni nol leñ styoon. No nii kyak tusy kchësy meñ go parñee kniladzy meñ nii nche lo kislyu nii lii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Misme kyalwnabey nii bneetsyoo lon ptedyaa lo meñ nii xniladzy parñee kyak tusy meñ go sinak nii nak no. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naa no leñ styoo meñ nii xniladzy lii, lëë lii no leñ styoon parñee kyak tusy meñ go, tsiin kyeñ meñ nii nche lo kislyu nii lii pxaal naa ni kyeñ meñ nii xkëstyool meñ nii xniladzy lii sinak nii xkëstyool naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tat Tios, lii pxaal kchë meñ go lon, aan lëë nana lëën chakladzy nii laañee tson siko tso meñ go, parñee kan meñ go kyalwnabey nii bneetsyoo lon. Lëël bneetsy kyalwnabey go lon porñee xkëstyool naa destye worñee karty kwe kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xyuumbeydy chol meñ nii nche lo kislyu lii, Tat Tios, per naa xyuumbeyaa lii, ni kchësy kaa meñ nii pxaaloo lon nan nii lii pxaal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lëën bluyle cho nakoo lo meñ nii pxaaloo lon, per lëëw kluyraa, parñee jkëstyoo meñ go xcombañer sinak nii xkëstyool naa, ni parñee tson leñ styoo kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Loxsye chëb Jesús kchë ngo, lëë xaa si stublad chu psë nii lë Cedrón ksa xpëëdscuel xaa aan lëë xaa kwsëëb tu lo kwaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wi Judas nii pko Jesús ña xaa xñabey nan pa kë kwaa go porñee ndaly vuelt kuni Jesús xpëëdscuel siko. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Siko ptsiñni Judas tubtsoon soldad ni tubtsoon mayor nii pxaal xaa nii xñabey lo pxosy ni xaa fariseo. Kchë xaa go noy kiib ni noy bini. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per como nanle Jesús nii singo ktsyool xaa, lëë xaa kwnabtiits lo xaa go, chëb xaa: —¿Cho xyub to? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lëë xaa go chëb: —Lëë noo xyuub Jesús Nazaret. Tsigo lëë Jesús chëb: —Naa nak Jesús. Lëë Judas nii kok niladzy kaa xaa no lady kchë xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tsiñee lëë Jesús chëb: “Naa nak Jesús”, kchësy xaa bikche nde xitsy byab lyu. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tsigo lëë Jesús chëb stub: —¿Cho xyub to? Aan lëë xaa go chëb stub: —Lëë noo xyuub Jesús Nazaret. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tsigo lëë Jesús chëb: —Lëën niyle nii naa nak Jesús Nazaret. Deelñee naa xyub to, kol klaa xpëëdscuelaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kchë nrii kok parñee kak cumplir nii chëb Jesús tsiñee kwnee xaa: “Tat Tios, pe kokty ni tu xaa nii pxaaloo lon.” ");
INSERT INTO ztqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tsigo lëë Simoñ Pedre kwlii xispad aan lëë xaa pchug tyag tu xaa nii lë Malco. Xmos xaa nii xñabey lo pxosy nak Malco. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Per lëë Jesús chëb lo Pedre: —Psoob xispaadoo xlugaro. ¿Pe nladzyoo nayak nii teejtyaa lo kyalnë nii pxaal Tat Tios? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tsigo lëë soldad ni lëë xaa nii xñabey lo soldad ni lëë xmayor xaa Israel kwnaasy Jesús aan lëë xaa pxituu xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Klo lidzy Anás kuni xaa Jesús porñee lëë Anás nak pxosytsaap Caifás. Lëë Caifás nak xaa nii mastre non lo pxosy iz ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Lëë gak Caifás chëb nii masy buen kety tugak xaa, lëjty nii kety kchë meñ kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Chop Simoñ Pedre stu xpëëdscuel Jesús kunal. Xyuumbey xaa xaa nii mastre non lo pxosy. Por ngo lëë xaa kwsëëb axte lo xley xaa nii mastre non lo pxosy ksa xaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Per lëë Pedre byaan ley. Por ngo lëë xpëëdscuel Jesús nii xyuumbey pxosy nii mastre non pchoo, aan lëë xaa kwnee lo kwnaa nii xkyënap chu puert parñee klaa me tedy Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tsigo lëë kwnaa nii xkyënap chu puert chëb lo Pedre: —¿Pe lëdy kaa wil no xlad Jesús? Lëë Pedre chëb: —Lëdyo, lëdy win. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Lëë mos ni lëë mayor psaay ki aan lëë xaa nche soli chu ki xtsëë xaa porñee singootyee chak nal. Aan wi Pedre kuso lady xaa xtsëë. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lëë xaa nii mastre non lo pxosy kwnabtiits lo Jesús chëb: —¿Cho nak xpëëdscueeloo ni pe cos xluuyoo lo meñ? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Lëë Jesús chëb: —Xña lo ngbidz kwnen lo meñ. Leñ ktoo ni leñ liidzy kaa Dios tugak beeñ ksedyaa meñ. Siko xkaalsa kchë meñ Israel. Ni tu pe karty kñe tsilaanaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Penak nii xñabtiitsoo lon? Kwnabtiits lo meñ nii pkëëtyag xtitsaa, aan lëë meñ go kñë pe cos kwnen. Kchë meñ go nan pe cos kwnen. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tsiñee lëë Jesús chëb ngo, lëë tu mayor byaasy lo Jesús chëb: —¿Singue nawen xkyëboo lo xaa nii mastre non lo pxosy? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tsigo lëë Jesús chëb: —Deelñee nonguialdy nii kwnen, kwnë dyon penak nii nonguialdyo. Per deelñee nonguial nii kwnen, ¿penak nii kwtiñoo naa? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Loxsye ngo nxituu xaa pxaal Anás xaa lo Caifás. Lëë Caifás nak xaa nii mastre non lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lëë Pedre gaa bii so ktsëë chu ki aan lëë meñ nii nche siko chëb lo Pedre: —Nli gaa na ¿pe lëdy wil no xlad Jesús? Aan lëë Pedre chëb: —Lëdyo, lëdy win. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kok xtsedyako lëë tu xmos xaa nii mastre non lo pxosy chëb: —¿Kondyaa nawen nii wil so laañee pkaa Jesús? Tyag xaa lidzy xaa go pchug Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Lëë Pedre chëb: —Lëdyo, lëdy win. Aan wor go kazh lëë nguidy kol pkwetsy. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Silyga kwlii xaa Jesús lidzy Caifás aan lëë xaa kuni Jesús chu yulyey. Per kwsëëbty xaa leñ yulyey, por deelñee sëëb xaa Israel leñ lidzy xaa sit, chilody kaw xtsee xaa paskw, porñee singo xñabey xley xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por ngo lëë Pilat pchoo leñ yulyey, aan lëë Pilat chëb: —¿Pe cos xkëëkiy do xaa re? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tsigo kchësy xaa chëb: —Deelñee nyody xfalt xaa re, nyoopniidy noo xaa lool. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Lëë Pilat chëb: —Kol tsini xaa aan kol kuñ kyalxtisy sinak xñabey xley do. Per lëë xaa Israel go chëb: —Chilody kuuty noo meñ, por xlaady xleey noo. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Singo chëb xaa go parñee kuñ xaa cumplir nii kwnee Jesús tsiñee chëb Jesús xa kety Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Lëë Pilat byo leñ yulyey stub, lëë xaa kwtsyetsy Jesús, aan lëë xaa kwnabtiits lo Jesús chëb xaa: —¿Pe nli lii nak xrey meñ Israel? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Lëë Jesús chëb: —¿Pe kikoo kwlañ nii kñabtiitsoo nrii lon, ote no yak cho nëw lool? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tsigo lëë Pilat chëb: —¿Pe meñ Israelaa nayak? Lëë meñ xkyedzyoo ni lëë xaa nii xñabey lo pxosy biidni lii lon. ¿Pe cos beeñ gaal? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Lëë Jesús chëb: —Naktyaa sinak rey nii xñabey lo kislyu re. Deelñee nyakaa sinak rey lo kislyu re, ndily kchë meñ nii no xladaa parñee nyaabtyaa ña xaa Israel nii xñabey. Per naktyaa sinak rey lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tsigo lëë Pilat chëb: —¿Nli tsigo busy nii reeyoo? Lëë Jesús chëb: —Lii xñee nii reeyaa, per lëën koly ni lëën byely lo kislyu re parñee kñen tiitsli. Aan kchësy meñ nii xsal tiitsli xkëëtyag xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Lëë Pilat chëb: —¿Pe cos nak kaa tiitsli? Loxsye kwnabtiits Pilat lo Jesús, lëë Pilat pchoo ley stub aan lëë xaa chëb lo meñ Israel: —Kindy xfalt xaa re. ");
INSERT INTO ztqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per nak xcostumbre to nii no klaan tu xaa nii no skiib na paskw. ¿Pe chakladzy to nii klaan xrey do? ");
INSERT INTO ztqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kchësy meñ kwchuptsyë chëb: —¡Klaadyoo xaa gue! ¡Blaa Barrabás! Aan tu ngbaan nak Barrabás. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tsigo lëë Pilat kwnabey ptee soldad cheñ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lëë soldad psaa tu coron yakitsy aan lëëw psoob xaa kik Jesús ni lëë xaa pkakw Jesús tu ladx nixñë yë. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Loxsye ngo lëë soldad big lo Jesús xñee: —¡Byinayk xrey meñ Israel! Aan byaasy xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lëë Pilat pchoo leñ yulyey stub aan lëë xaa chëb: —Kol kuy gaanoo, lëë xaa kwlin parñee kan do nii nody xfalt xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sob coron yakitsy kik Jesús ni nakw xaa ladx nixñë yë go pchoo xaa ley. Lëë Pilat chëb: —¡Lëë xaa nii kwnaasy to so nu! ");
INSERT INTO ztqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tsiñee lëë xaa nii xñabey lo pxosy ni lëë mayor kon Jesús, lëë xaa bislo kwchuptsyë xaa, xñee xaa: —¡Pkëë xaa lo crusy! ¡Pkëë xaa lo crusy! Lëë Pilat chëb: —Kol tsini xaa aan lëë do kol jkëë xaa lo crusy por xyeñdyaa pe cos nak xfalt xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Per lëë meñ Israel chëb: —Chaap noo tu ley aan lo xleey noo xñee nii no nii kety xaa nii kñee nak Xiñ Dios. Aan lëë xaa gue xñee nii lëë xaa nak Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tsiñee lëë Pilat biñ ngo, mastre ptsyeb xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Lëë xaa kwsëëb leñ yulyey stub, aan lëë xaa kwnabtiits lo Jesús chëb xaa: —¿Cho xaal? Per kwëbty Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Lëë Pilat chëb: —¿Xkyëbtyoo nawen? ¿Nandyoo nayak nii ñan no kyalxtisy? Schilo kñabeyaa kyëël lo crusy ni schiloo gaa kñabeyaa laal. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tsigo lëë Jesús chëb: —Nchilody nyabeyoo lon deelñee neesty Dios tiits. Por ngo nii mastre no xtol meñ nii biidni naa lool que xtoloo. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Destye wor go lëë Pilat byub mod nii nlaa xaa Jesús, per lëë meñ Israel kwchuptsyë chëb: —¡Deelñee klaal xaa gue, lëdy xamigw xtisy Roma nakoo! ¡Por falt xko xaa nii chakladzy kak rey lo xtisy Roma! ");
INSERT INTO ztqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tsiñee lëë Pilat biñ ngo, lëë xaa kwlii Jesús ley aan lëë xaa kwsob lo ley nii xñee meñ Letsy Kyo. Siko xsyob xaa tsiñee chuñ xaa kyalxtisy. Gabatá lë lo ley go con tiitsë hebreo. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mer xwe ngbidz tse nii kxe kak paskw, lëë Pilat chëb lo meñ Israel: —¡Lëë xrey do nrii! ");
INSERT INTO ztqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Per lëë meñ Israel chëb: —¡No nii kety xaa! ¡No nii kety xaa! ¡Pkëë xaa lo crusy! Lëë Pilat chëb: —¿Pe mod skën xrey do lo crusy nawen? Lëë xaa nii xñabey lo pxosy kwëb chëb: —Lëdy rey xaa, por xaktyee xtisy Roma xñabey lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Loxsye ngo lëë Pilat kwnabey nii koy soldad Jesús parñee kyë Jesús lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tsi lëë soldad kwlii Jesús, lëë Jesús noy xicrusy par tsi Jesús laañee xñee meñ Israel Gólgota. (Tiits ko nak sinak nii xñee ñe: Laañee nche tsit kik meñ kuty.) ");
INSERT INTO ztqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Siko pkëë xaa Jesús lo crusy, aan tyuxlad kwi Jesús pkëë xaa tuga xaa. Groltyee lady chop xaa go kwë Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kwnabey Pilat nii kwë blalan tiits kik xicrusy Jesús. Sinrii xñee tiits ko: “Jesús Nazaret, xaa nii nak xrey meñ Israel.” ");
INSERT INTO ztqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ndaly meñ Israel blab tiits ko, por kexka leñ kyedzy pkëë xaa Jesús lo crusy. Con tiitsë hebreo ni latiñ ni griego kwë tiits ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Por ngo lëë xaa nii xñabey lo pxosy chëb lo Pilat: —Jkëëdyoo: “Xrey meñ Israel”, sink pkëë: “Xaa re chëb nii lëë xaa nak xrey meñ Israel.” ");
INSERT INTO ztqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Per lëë Pilat kwëb chëb: —Chilody kpily nii kwnabeyaa kwë. Singootyee no nii kyaano. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Loxsye pkëë soldad Jesús lo crusy, lëë xaa ptop xab Jesús aan lëëw beeñ xaa tap lë, tublë gaaw kwaa tu soldad. Per tsiñee lëë xaa blis tu ladx nool nii chakw Jesús, kon xaa nii tub ñasyako ndiib. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lëë xaa chëb lo xcombañer xaa: —Kchosty now. Masy kol tsoo ko now rif dyon cho kchalo. Singo mod lëë soldad beeñ cumplir xtiits Dios nii xñee: “Kwtiisy xaa xabaa ni kwloo xaaw rif.” Kchë ngo beeñtsyey soldad ko. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kex laañee kwë Jesús lo crusy kwche xñaa xaa chop pël, ni Mariy nii nak tsiil Cleofas, ni María Magdalena. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tsiñee lëë Jesús kon nii lëë xñaa xaa so kwi tu mëëdscuel nii mastre xkëstyoo xaa, lëë xaa chëb lo xñaa xaa: —Lëë xiñoo so ske. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Loxsye ngo lëë xaa chëb lo xpëëdscuel xaa: —Lëë xñaal so ske. Aan destye wor go lëë xñaa Jesús kwyo lidzy xpëëdscuel xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nan Jesús nii lëë xaa beeñtsyey kchë nii no kak, per parñee kuñ xaa cumplir kitsy nii kë xtiits Dios, lëë xaa chëb: —Xlyaan nis. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lëë tu canty nii kaktsë viñ nyi sob siko. Lëë soldad pkadz tublë ladx lo viñ go, lëëw psoob xaa lo tu punt yag nii lë hisopo, aan lëëw ptsig xaa lo Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lëë Jesús kwsup ladx nii kodz lo viñ go aan lëë xaa chëb: —Lëëw nagon, lëë kchë nii no kak kok. Loxsye chëb xaa ngo, lëë xaa pkëënal kik xaa aan lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mer tse nii kxe kak paskw pkëë xaa Jesús lo crusy, aan kwnëdy meñ Israel nii nyaan meñ kuty ko lo crusy tse nii xiladzy meñ Israel lo tsiiñ, porñee tir nda nak tse go. Por ngo lëë xaa kunee lo Pilat parñee kñabey Pilat ketsy ksa niy xaa nii kwë lo crusy ni kñabey Pilat nii kyety ksa xaa go lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lëë soldad kwey aan lëë xaa kwtiitsy niy chop xaa nii kwë kwi Jesús lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Per tsiñee lëë xaa big kex lo Jesús, kwtiisty xaa niy Jesús, porñee kon xaa nii lëë Jesús tse lox kuty. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per lëë tu soldad pxaly kwi Jesús con lans, aan nonsyke cheñ ni nis pchoo. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lëë xaa nii kono chutiitso. Nli xtiits xaa, ni nan gaa xaa nii tiitsli xñee xaa parñee wi do kniladzyo. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lëë kchë cos re kok parñee kak cumplir xkitsy Dios laañee xñee: “Ni tublë xtsit xaa kiisty meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Leñ xkitsyak Dios xñee: “San meñ xaa nii kyaly kwi con lans.” ");
INSERT INTO ztqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lëë tu xaa Arimatea nii lë José kunee lo Pilat parñee klis xaa xcuerp Jesús. Wi José kwyo xlad Jesús, per ni tu cho lo chëbty xaaw, porñee ptsyeb xaa meñ Israel nii xñabey. Lëë Pilat pteedy tiits, aan lëë José blis xcuerp Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Wi tu xaa nii lë Nicodemo, nii kunee lo Jesús tu kyool, ptsiñ. Noy xaa masy tu kalyptsii kil ngwaan xlyaa nex nii nyaa con kizh nii lë mirra ni áloe. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chop José Nicodemo pchal xcuerp Jesús ladx nii kodz lo ngwaan xlyaa nex, por singo xkeetsy meñ Israel meñ kuty. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kex tu lo kwaa kwë Jesús lo crusy, aan lo kwaa go ndeeñ tu paa kub. Ni tu cho karty jkyeetsy leeñgo. ");
INSERT INTO ztqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tse nii kxe kxiladzy meñ Israel lo tsiiñ nak tse go. Por ngo lëë xaa pkeetsy Jesús leñ paa go, porñee kexka siko ndeeño. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lëë tse tminkw bii nguey lëë María Magdalena kwey chu paa, aan lëë me kon nii xoobtre kyo nii ntse chu paa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsigo lëë me kwloo corr ptsiñ me laañee no Pedre chop tu mëëdscuel nii mastre xkëstyoo Jesús, aan lëë me chëb: —Lëë meñ kwlii xcuerp Jesús leñ paa aan ndoondy pa kulo meño. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wor go kazh lëë Pedre si chu paa chop mëëdscuel go. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chop xaa kwloo corr, per klo mëëdscuel nii mastre xkëstyoo Jesús ptsiñ chu paa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lëë xaa kwsinchuñ par kuy xaa leñ paa, per xaktyee ladx nii pchal Jesús kon xaa, aan kwsëëbty xaa leñ paa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Xitsyak xaa nal Pedre. Lëë Pedre kwsëëb leñ paa, aan xaktyee gak kchë ladx nii pchal Jesús kon Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Per lëë xaa kon nii nixty ladx nii pxituu kik Jesús laañee nche ladx pchal xcuerp Jesús, sink lëëw nix tublad nyeecho. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsigo lëë mëëdscuel nii klo ptsiñ chu paa kwsëëb, aan loxsye kon xaa kchë ngo, lëë xaa bniladzy nii pañ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Karty kyeñ xaa xkitsy Dios nii xñee nii no nii kpañ Jesús wor go. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Loxsye ngo lëë chop xpëëdscuel Jesús sey laañee xkwës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Per lëë Mariy byaan chu paa choon. Lëë me kwsinchuñ par kuy me leñ paa, ");
INSERT INTO ztqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","aan lëë me kon nii lëë chop angly nii nakw ladx rusy nche sob laañee pxoob xcuerp Jesús. Tu angly sob nëz laañee kwyo kik Jesús, lëë stu angly sob nëz laa kwyo niy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lëë angly kwnabtiits lo me chëb: —¿Penak nii choonoo? Lëë me kwëb, chëb me: —Porñee lëë meñ biy xcuerp Jesús, aan nandyaa pa kulo meño. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nonsyak chëb me ngo, tsiñee lëë me psuugw lo me, aan lëë me kon nii lëë Jesús so siko, per byeñdy me nii Jesúso. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Lëë Jesús chëb lo me: —¿Penak nii choonoo? ¿Cho xyuboo? Nladzy me te xaa nii xkyënap kwaa gow. Por ngo lëë me chëb: —Xey, deelñee lii biy xcuerp Jesús, kwnë pa kulolo parñee kyoyno. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tsigo lëë Jesús chëb: —¡Mariy! Lëë me byoogw wxooñ, aan lëë me chëb con tiitsë hebreo: —¡Rabuni! (Tiits ko nak sinak nii xñee ñe Maestre.) ");
INSERT INTO ztqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lëë Jesús chëb: —Blaan, por karty kyan lo Tat Tios. Per byey aan kudzy lo xpëëdscuelaa nii lëën kya lo xDios no. Lëë xaa nak pxosyaa ni lëë gak kaa xaa nak pxosy to. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Lëë María Magdalena kunitiits lo xpëëdscuel Jesús. Chëb me nii lëë me kon Jesús ni chëb me kchë nii chëb Jesús lo me. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Misme tse tminkw ko lëë xpëëdscuel Jesús pkaal lsa, aan lëë xaa byoogw yu, porñee xtsyeb xaa meñ Israel nii xñabey. Tsiñee lëë lyu pkyey lëë Jesús kwsëëb leñ yu aan lëë xaa kwso groltyee lady xpëëdscuel xaa, chëb xaa: —Kakni Dios to dyon. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Loxsye chëb xaa ngo, lëë xaa bluuy ña xaa ni kwi xaa laañee kwsëëb lans, aan kchësy xpëëdscuel xaa ble. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Lëë Jesús chëb stub: —Dios kakni do. Lëën kxal lëë do sinak nii pxaal Tat Tios naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Lëë Jesús blub lo xpëëdscuel aan lëë xaa chëb: —Kol klaa sëëb Kyalbini Ntson leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kchësy meñ nii kuñ do perdón kpily xtol, per kpildy xtol kchësy meñ nii kuñdy to perdón. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Worñee kwey Jesús, kindy tu xpëëdscuel xaa nii lë Max. (Kwach kwloolë xaa Max.) ");
INSERT INTO ztqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lëë xcombañer Max chëb lo Max: —Lëë noo ptyon Jesús. Per lëë Max chëb: —Deelñee kandyaa ña xaa laañee kwsëëb clav, ni ksëëbtyaa xkweñaa laañee kwsëëb clav ni laañee kwsëëb lans, knilastyaa nii kon do xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Lëë kwloxo xon kpidz, lëë xpëëdscuel Jesús pkaal lsa stub, aan wi Max no lady xaa tse go. Per nikxe tsiitsy ntse xaa chu puert, lëë Jesús kwsëëb. Aan lëë Jesús kwso groltyee lady xaa chëb: —Kakni Dios to dyon. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tsigo lëë xaa chëb lo Max: —Psëëb xkweeñoo lo pat ñan, ni bneetsy ñal nu parñee ksëëblo kwin. Jkandy kikoo, sink bniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lëë Max chëb: —¡Lii xñabey ni lii nak Dios! ");
INSERT INTO ztqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Lëë Jesús chëb: —Porñee konoo naa, ngo nii xniladzyoo nii naa nak Dios. Dichos kchë meñ nii kondy naa aan xniladzy xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Këdy kchë kyalntson nii beeñtsyey Jesús worñee kwyo xaa lady xpëëdscuel xaa leñ kitsy re. ");
INSERT INTO ztqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per lëë kchë nrii kwë parñee kniladzy to nii lëë Jesús nak Crist, ni kniladzy to nii lëë xaa nak Xiñ Dios. Deelñee kniladzy to xtiits xaa, lëë do jkaa tu kyalmbañ nii nitylody. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Loxsye ngo, lëë Jesús byaklo lo xpëëdscuel chu nistoo nii lë Tiberias. Sinrii mod byaklo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Lëë Simoñ Pedre nche ksa Max nii kwloolë meñ Kwach, ni tu xaa Caná nii pcholë Natanael, ni xiñ Zebedeo, ni schop xpëëdscuel Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Lëë Simoñ Pedre chëb lo xaa: —Lëën kënasy mël. Tsigo lëë xcombañer xaa chëb: —Wi noo syënaal lii. Lëë xaa kwyo barkw, lëë xaa si. Per ni tu mël kwnaasty xaa kyool go. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tsiñee lëë lyu mer kyaani, lëë Jesús ptsiñ chu nistoo go, per byeñdy xpëëdscuel xaa nii lëë xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lëë Jesús chëb: —¿Pe ni tu mël karty kñaasy to? Lëë xpëëdscuel xaa chëb: —Ni tu ma. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tsigo lëë Jesús chëb: —Kol kchon xkyex to kwi barkw nëzli tsiin kñaasy to mël. Lëë xaa psoob tiits, aan loxsye ngo xlyëbty xaa kwii xaa kyex lo nis, porñee singootyee ndaly mël kwnaasy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tsigo lëë mëëdscuel nii mastre xkëstyoo Jesús chëb lo Pedre: —¡Lëë Jesús ngue! Siikñee biñ Simoñ Pedre nii Jesúso, lëë xaa kokw xab xaa, porñee nakwty xaa xab xaa, aan lëë xaa kwsëëb lo nis. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lëë stubla xpëëdscuel Jesús ptsiñni barkw chu nis, porñee kiin tu kyoow metre nak laañee so barkw par chu nis. Ngopxax xaa kyex nii kaktsë mël. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tsiñee lëë xaa byety leñ barkw, kon xaa nii lëë ki tse noyek, ni lëë tu mël tse xoob lo ki, ni lëë xaa kon nii lëë kyaxtily ntsiib. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lëë Jesús chëb: —Kol tëni bla mël nii kal lox kwnaasy to. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Lëë Simoñ Pedre kwyëp leñ barkw aan lëë xaa kwtopxax kyex nii kaktsë kchë mël ngol axte chu nis. Aan nikxe nii no tu kyoow choowptsiiptson mël leñ kyex ko, per pchostyo. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lëë Jesús chëb: —Kol të kxiincheñ do. Aan ni tu xpëëdscuel xaa byaxty nyabtiits cho nak xaa, porñee kchë xaa nan nii Jesúso. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Lëë Jesús kwseñ kyaxtily aan lëëw kwtiisy xaa. Singo gak kwtiisy xaa mël. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lëëw byon vuelt nii xyaklo Jesús lo xpëëdscuel loxsye pañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tsiñee lëë wxiincheñ kwlox, lëë Jesús chëb lo xiñ Juan nii lë Simoñ Pedre: —Simoñ, ¿pe xkëstyool naa sinak nii xkëstyoo xaa re naa? Lëë Pedre chëb: —Nanoo nii xkëstyoon lii. Lëë Jesús chëb: —Deelñee xkëstyool naa busy, kon meñ nii xniladzy xtitsaa sinak nii xtyoon mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Lëë Jesús kwnabtiits lo xiñ Juan nii lë Simoñ Pedre stub, chëb xaa: —Simoñ, ¿pe xkëstyool naa? Lëë Pedre chëb: —Nanoo nii xkëstyoon lii. Lëë Jesús chëb: —Deelñee xkëstyool naa busy, kon meñ nii xniladzy xtitsaa sinak nii xtyoon mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Lëëw byon vuelt nii lëë Jesús xñabtiits lo xiñ Juan nii lë Simoñ Pedre xñee xaa: —Simoñ, ¿pe xkëstyool naa? Tsigo lëë Pedre pteenë, porñee lëëw byon vuelt nii xñabtiits xaa dyon pe xkëstyoo Pedre xaa, aan lëë Pedre chëb: —Nody tu cos nii nandyoo. Nanoo nii xkëstyoon lii. Lëë Jesús chëb: —Deelñee xkëstyool naa busy, kon meñ nii xniladzy xtitsaa sinak nii xtyoon mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nli xñen nii worñee kokoo xaa yeeñ, yuuboo pxituu leñoo par tsil laañee kokladzyoo. Per tsiñee lëël kox, lëël klis ñal parñee kxituu meñoo, ni lëë meñ tsini lii laañee chaklastyoo tsil. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tsiñee lëë Jesús chëb ngo, lëë xaa kwnee xa no nii kety Pedre parñee kuuñ ksak xaa Dios. Loxsye ngo lëë xaa chëb lo Pedre: —¡Tënal naa! ");
INSERT INTO ztqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tsiñee lëë Pedre psuugw lo, kon xaa nii lëë mëëdscuel nii mastre xkëstyoo Jesús nal xitsy xaa. Lëë xaa go sob kwi Jesús wtse nii kok xtsee, ni lëë xaa go kwnabtiits chëb: “Jesús, ¿cho kakniladzy lii?” ");
INSERT INTO ztqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tsigo lëë Pedre chëb lo Jesús: —Lëë xaa rek, ¿xa kak xaa? ");
INSERT INTO ztqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Lëë Jesús chëb: —Deelñee klyañ styoon nii kpañ xaa axte nii kpikchen, ¿pe xcueentoo ngo? Tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Por ngo lëë tiits pchoots klyaal lady xaa nii kejty mëëdscuel go. Per chëbty Jesús nii kejty xaa, sink lëë xaa chëb: “Deelñee klyañ styoon nii kpañ xaa axte nii kpikchen, ¿pe xcueentoo ngo?” ");
INSERT INTO ztqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Lëë mer xpëëdscuel Jesús ngo xñee kchë nrii, ni lëë xaa pkëëw. Ni ndon gaa noo nii tiitsli xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tir ndaly nii beeñtsyey Jesús. Deelñee nguiëw lo kitsy kchë kchësyo, buty ngaady lo kislyu nyotsey kchësy libre nii nguië.");
INSERT INTO ztqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, leñ libre nii klootyee gon pkën, lëën pkë kchë nii beeñtsyey Jesús ni kchë nii bluuy xaa destye worñee bislo xaa, ");
INSERT INTO ztqNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","axte tse nii lëë xaa byëp kpaa. Antes nii kyey xaa kpaa, lëë xaa kwle xaa nii kak xapostle xaa ni lëë xaa beeñ kseedy xapostle xaa por Kyalbini Ntson parñee kyeñ xaa pe cos kuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aan loxsye kuty Jesús, choow kpidz byaklo xaa lo meñ, xluuy xaa nii nli mbañ xaa ni xñee xaa xa nak xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Worñee lëë Jesús bii no lady apostle, lëë xaa chëb lo apostle: —Kchoody to leñ kyedzy Jerusalén. Kol kwës axte nii kak cumplir xtiits Dios nii bluyaa tsiñee niyaa ");
INSERT INTO ztqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","nii lëë Juan pchoobnis con nis sye, per xlyëëdre lëë do chobnis con Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lëë Jesús nche ksa apostle tsi lëë xaa kwnabtiits lo Jesús chëb xaa: —¿Pe lëë wor kutsiñ nii lëël ktee kyalwnabey lo meñ Israel stub? ");
INSERT INTO ztqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Lëë Jesús kwëb chëb: —Xyaldy to nii kaknan do pa wor o pa tsee gaa kuuñtsyey Dios nii no kuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per tsiñee lëë Kyalbini Ntson sëëb leñ styoo do, lëë Dios kneetsy kyalwnabey lo do parñee kñee do cho nakaa lo meñ Jerusalén, ni lo meñ Judea, ni lo meñ Samaria, ni axte kchë lo meñ nii mastre sit nche lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Loxsye chëb Jesús ngo, nche kuyak meñ, lëë xaa byëp kpaa. Lëë xaa kwnity tu leñ xkey aan bikchedre nyan meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lëë meñ nche klëp lo leñ kpaa mentre lëë Jesús sijkë, tsiñee lëë chop xaa xab rusy byaklo lo meñ, ");
INSERT INTO ztqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","chëb: —Meñ Galilea, ¿penak nii singueetyee nche klëp lo do leñ kpaa? Sinak nii konak to sey Jesús kpaa, kan do kpikche xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Loxsye ngo lëë meñ bi kiy nii lë Olivos, lëë meñ sey Jerusalén. Kiin tu mily metre kwsë meñ porñee kexka Jerusalén sob kiy Olivos. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tsiñee lëë meñ ptsiñ leñ kyedzy, lëë meñ kwey laañee xkwës Pedre, ni Jacob, ni Juan, ni Ndresy, ni Felip, ni Max, ni Bartolomé, ni Mateo, ni Jacob xiñ Alfeo, ni Simoñ xaa nii kwyo lady tub tiiy xaa nii pcholë Cananista, ni Judas betsy Jacob. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tugak pkaal lsa meñ ksa meñ betsy Jesús, ni Mariy xñaa Jesús, ni stubla kwnaa par kutiitsni meñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Leñ tse go lëë siik tu kyoow kaly meñ nii xniladzy xtiits Jesús pkaal lsa aan lëë Pedre chëb lo meñ go: ");
INSERT INTO ztqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Beetsy, lëë Kyalbini Ntson gon psaani leñ kik David tsiñee kwnee xaa leñ kitsy nii kë xtiits Dios xa kuuñtsyey Judas, ni nol gaa nii lëëw kak cumplir. Lëë Judas nak xaa nii kwnech lo meñ nii kwnaasy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wi Judas kwyo lady no, ni wi xaa kwë lo tsiiñ re. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Per lëë xaa kwxii tublë lyu con tumi nii kozh xaa por xtol xaa. Loxsye ngo lëë xaa kukyab nxixto lo lyu go aan lëë xaa kotsy xkyee. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tsiñee lëë meñ nii no Jerusalén biño, lëë meñ go kwloolë lyu go Acéldama. (Tiits ko nak sinak nii xñee ñe: Laañee pxee cheñ.) ");
INSERT INTO ztqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Leñ libre nii kë salmos xñee sinrii: No nii kyaanladzy lidzy xaa, ni ni tu cho tsody leeñgo. Ni xñee gako: No nii so stu xaa nii so xlugar xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Lëë bla xaa nii tugak kwënal lëë noo destye tse nii pchoobnis Juan Jesús axte tse nii lëë Jesús byëp kpaa ncheno nu. Nonguial tsigo busy nii kpee tu xaa go sëëb lady noo parñee ksa noo xaa kñee nii nli pañ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tsigo lëë xaa pso tu xaa nii lë Matías, ni stu xaa nii lë José. (No schop lë José: Tuwo nak Barsabás, lëë stuwo nak Justo.) ");
INSERT INTO ztqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Loxsye ngo lëë xaa biily lay lo Dios chëb xaa: —Tat Tios, lii nii nanoo pe xsya leñ styoo catuu noo, bluuy dyon cho xaa re kwlel ");
INSERT INTO ztqNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","parñee kuñ xaa tsiiñ nii psaan Judas tsiñee lëë Judas sey laañee xyal kyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lëë xaa kwloo suert, aan lëëtyee lëë Matías pchalo. Destye wor go lëë Matías kwsëëb lady ksa tsiiptub apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lëë tsiñee lëë lni Pentecostés kol, lëë kchësy meñ nii xniladzy xtiits Jesús ptyop tub lugarak. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kolpsye lëë meñ biñ tu bi nii sëëdsëëb kpaa, sinak tsiñee xpi tu medox, aan tyub leñ yu nii nche sob meñ kwyo bi go. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsigo lëë kchëlo tiits byaklo sinak bëly, lëëw pkaasy kchë lo meñ nii ncheno leñ yu go. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aan kchësy leñ styoo meñ go kwsëëb Kyalbini Ntson, ni lëë meñ go bislo kwnee stu clasy tiits, sinak nii psyaab Kyalbini leñ styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lëëtyee gaa leñ tse go ndaly meñ Israel nii chuuñtsyey nii xñabey xtiits Dios ptsiñ Jerusalén, kok xtsele ncheno tañ meñ go tyub lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tsiñee lëë bi go kwyo, lëë meñ ptyopbe, aan nandy meñ pe cos kwxaak meñ, porñee biñ meñ xñee xpëëdscuel Jesús xtiitsë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ntseeb psee meñ, xñee meñ lo xcombañer: —¿Pe lëdy nonsyke meñ Galilea nayak nak kchë meñ nii nchenee? ");
INSERT INTO ztqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xa mod nak busy, nii xtsyon no xñee kchë meñ gue xtiitsë no? ");
INSERT INTO ztqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nche meñ Partia nu, ni meñ Media, ni meñ Elam, ni meñ Mesopotamia, ni meñ Judea, ni meñ Capodocia, ni meñ Ponto, ni meñ nii sëëd nëz Asia, ");
INSERT INTO ztqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ni meñ Frigia, ni meñ Panfilia, ni meñ Egipto, ni meñ Libia nii ncheno kexka Cirene, ni meñ Roma. No pxosy meñ go nak xaa Israel, no gaa meñ go kwsëëb xlad meñ Israel xmod. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ni nche meñ Creta ni Arabia nu. Per kchësy no xtsyon xñee meñ re xkyalntson Dios con mer xtiitsë no. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kchësy meñ go psee aan nandy meñ go pe cos kwxaak. Ngo nii lika lo xcombañer meñ go xñee meñ go: —Nli gaa na ¿xa nak kchë cos re? ");
INSERT INTO ztqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lëë stubla gaa meñ lika kwtsityni, xñee: —¿Pe ksal do xaa gue?, xsyudzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tsigo lëë ksa tsiipchop apostle kusoli aan lëë Pedre chëb: —Meñ Judea ni kchësy to siñee ncheno do Jerusalén, kol kaknan nrii, ni kol kon nii kñen lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Xsyusty meñ re gon sinak nladzy to, por bii sily, lëë las nueve kal nak. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lëë nii kwnee profet Joel noyak cumplir. Lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tsi lëë tse go tsitsib, xñee Dios, lëën kxal xKyalbini Ntsonaa lo kchë meñ nii nche lo kislyu. Lëë xiñgan do ni xiñtsyaap to kñee xtitsaa, lëën kñe lo xaa yeeñ lo mgaal, ni lëë xaa kol kñee xkaal. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lëën kxal xKyaalbiniin lo mguiy ni lo kwnaa nii xsoob xtitsaa, tsiin kñee meñ go xtitsaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lëën kuuñtsyey kyalntson leñ kpaa, lëë lo kislyu lëë styoo meñ ksee kan meñ cheñ ni ki ni koxtoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lëë lo ngbidz jkyey, lëë mëë kyak cheñ, antes nii lëë Dios nii xñabey lëë no kiid. Ntseeb kak tse go. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Per stelaa kchë meñ nii kuptsyë kwetsy Dios parñee kakni Dios meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tsigo lëë Pedre chëb: —Kchësy to siñee nak to meñ Israel, kol jkëëtyag nii kñen. Nan do gon nii lëë Dios kwle Jesús Nazaret lady to, ni nan do nii por lëë xaa beeñtsyey Dios ndaly kyalntson. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Per tsi lëë xaa pkaa ña do, lëë xaa beety to, pkëë do xaa lo crusy. Kchë do meñ ngoptol, beeñtsyey do sinak nii nol kik Dios kak. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per lëë Dios beeñ kpañ xaa, pteelaa Dios xaa lo xyoob kyalkuty, kwlëbty kyalkuty lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sinrii xñee rey David tsi lëë xaa xseety Jesús: Tugak xñech Dios nii xñabey lon, tugak nakni xaa naa, ngo nii pe kaktyaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por ngo xle styoon, ni nguiool cholaa. Mbëë kpañaa, pe tsinidy kikaa, ");
INSERT INTO ztqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","por nanaa nii klaadyoo kyaanaa laañee xyaan meñ kuty, ni nanaa nii klaadyoo kyodz xcuerpaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Lii bluuy nëz nii xnee kyalmbañ lon, ni slen tsiñee lëën kan lii. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Loxsye ngo lëë Pedre chëb: —Beetsy, kol kwës gaanoo, lëën kniy lo do nii lëë pxusykoltoo no David kuty, ni lëë xaa pkyeetsy, lëë xpaa gaa xaa bii xtyon no. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tu xaa nii xyeñ xtiits Dios kok David. Ngo nii nan xaa nii lo xtiiy xaa kwe Dios tu xaa nii kñabey. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sotak David nii lëëw tse chan xaa tsiñee kwnee xaa nii lëë Crist kpañ, ni tsi lëë xaa kwnee nii kyaandy xcuerp Crist laañee xyaan meñ kuty ni kyosty xcuerp xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ni nan gaa to nii lëë Dios beeñ kpañ Jesús, ni kchëë noo xñee nii ptyon noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Lëë Jesús pañ parñee sob xaa kwi Dios nëzli, kñabey xaa. Ni lëë Dios kaa ptee xKyalbini Ntson lo xaa, aan lëë xaa pxaal Kyalbini Ntson go lo kislyu. Lëë ngo nak nii chan do ni biñ do natse. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Lëdy David byëp kpaa, por misme David chëb: Chëb Dios lo xaa nii xñabey naa: “Kwsob kwin nëzli kñabeyoo, ");
INSERT INTO ztqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mentre lëën kuñ nii ksoob meñ nii xlëë lool xtiitsoo.” ");
INSERT INTO ztqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Kol kaknano kchësy to siñee nak to meñ Israel nii misme Jesús nii pkëë do lo crusy nak xaa nii kwle Dios, ni lëë Dios pso xaa xñabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tsiñee lëë meñ nii nche siko biñ xtiits Pedre, mban pteestyoo kchë meñ go, aan lëë meñ go kwnabtiits lo Pedre ni lo apostle chëb: —Beetsy, kol në pe cos kuuñ noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tsigo lëë Pedre kwëb chëb: —Kol ktsëë xmod to, kol ktikche styoo do lo Dios, ni kol chobnis kchësy to siñee xniladzy to xtiits Dios parñee kak perdón xtol do, tsiin singo mod lëë Dios kneetsy Kyalbini Ntson lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lo do ni lo xiñ do ni lo meñ sit pxaal Dios tiits re. Lëë tiits re sëëd lo kchë meñ nii klyañ styoo Dios kwetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Lëdy nriisy kwnee Pedre, ndalyre nii kwnee xaa lo meñ, chëb xaa: —Kol ksaan kchë tol nii chuuñtsyey meñ nii xnilasty xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tsigo lëë meñ nii psal xtiits xaa kwchobnis, aan tse go kwsëëb siik tson mily meñ nii kal bniladzy lady meñ nii xniladzyle. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Aan iip psaandy meñ go kchë nii bluuy apostle, mbëë pañ meñ go kchë xcombañer, chutiitsni meñ go Dios ni xkaal lsa meñ go par kaw meñ go kyaxtily tusyke. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kchë meñ psee kon kchë kyalntson nii blaa Dios beeñtsyey apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kchësy meñ nii bniladzy tugak kok meñ go ni pkady meñ go kchë nii chap meñ go lo xcombañer. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pto meñ go kchë nii chap meñ go, aan kchë tumi go pkaasy según lyaadzy nii ncheno tub tub meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ksatyee tse xkaal lsa meñ go leñ lidzy Dios. Lëë tsi lëë meñ xtsiñ lidzy tu xcombañer, lëë kyaxtily xkaasy aan mbëë con kyalwle chaw meñ gow tusyke. ");
INSERT INTO ztqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ni tugak pseety meñ go Dios aan kchë meñ Jerusalén bleni meñ nii xniladzy xtiits Dios ni ksatyee gaa tse lëë Dios xtsiñnire meñ xtyelaa lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tu tse lëë Pedre ni Juan si lidzy Dios tusyke. Siik las tres nak, por wor go xkaal lsa meñ par kutiitsni meñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Aan ksatyee tse xsyob tu xaa nii xsyëdy chilidzy Dios. Destye nii koly xaa xsyëdy xaa. Ksatyee tse chiksoob meñ xaa chu puert lidzy Dios nii lë Puert Ntson par kñab xaa tumi lo meñ nii xsyëëb nëz chu puert ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tsiñee lëë xaa kon nii lëë Pedre ni Juan si nëz nii sëëb leñ lidzy Dios, lëë xaa kwnab tumi. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsigo lëë Pedre ni Juan buy lo xaa. Loxsye ngo lëë Pedre chëb: —Buy loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lëë xaa nii xsyëdy ko psoob xtiits Pedre, nladzy xaa tsaaplaa no pe ndeedy Juan ni Pedre lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Per lëë Pedre chëb: —Chaaptyaa tumi, per lëën kne kchë nii chaapsyaa. Con kyalwnabey nii bnee Jesús lon lëën xñe lool: Kusoli aan kwsë. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tsigo lëë Pedre kwseñ ñali xaa aan lëë xaa blis so xaa, aan wor go kazh lëë niy xaa pkyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsigo lëë xaa kwyasklaa, lëë xaa kwsoli, aan lëë xaa pchilo kwsë. Loxsye ngo lëë xaa kwsëëb lidzy Dios ksa xaa, chasklaa xaa ni xñee xaa xaatke ntson Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kchësy meñ nii kon nii lëë xaa go xsyë ni lëë xaa xñee xaatke ntson Dios ");
INSERT INTO ztqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","psee ni ptsyeb meñ, porñee xyuumbey meñ xaa, ni nan meñ nii lëë xaa xsyob chu puert lidzy Dios nii lë Puert Ntson xñab xaa tumi. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lëë xaa nii byak ko xlaady xaa Pedre ni Juan, aan kchësy meñ ptyopbe laañee xñee meñ lo xley Salomón, porñee siko so Pedre ni Juan ni xaa nii byak ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tsi lëë Pedre kon nii lëë meñ xtyopre, lëë xaa chëb: —Meñ Israel, ¿penak nii singueetyee xsee do? ¿Penak nii xuy do loo noo? ¿Pe xsyak to nawen nii lëë noo beeñ kyak xaa re con xkyalchak no o porñee gaa tir tir bueen noo? ");
INSERT INTO ztqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Lëdyo gon, lëë xDios pxusykoltoo no Abraham, Isaac ni Jacob blisklaa xiñ xaa Jesús, xaa nii pko do ña meñ xñabey. Aan tsi lëë Pilat kokladzy nlaa xaa, kwnëdy to. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ni nyab to nlyaa Xiñ Ntson Dios, lëël lëë do kwnab kwlaa tu nweety bñech. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Singo mod lëë do beety xaa nii xnee kyalmbañ. Per lëë Dios beeñ kpañ xaa, aan nriisy lëë noo xñee nii nli ptyon noow. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Por xkyalwnabey Jesús lëë xaa re byak ni xyuumbey gaa to xaa. Lëë xaa pkaa fuersy porñee bniladzy xaa xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Beetsy, nanaa nii tsi lëë do beety Jesús kchë xmeñ xñabey do, nandy to pe cos beeñtsyey do wor go. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per singo mod lëë Dios beeñ cumplir kchë nii kwnee profet tsiñee chëb xaa nii no mban tedy Crist. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por ngo, kol ktsëë xmod to ni kol ktikche styoo do lo Dios, parñee singo mod lëë xtol do kpily ni parñee knee Dios tu kyalwxiladzy lo do ");
INSERT INTO ztqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","tsi lëë xaa kxaal Jesucrist, xaa nii nol kiid lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Per no nii kwës Jesucrist kpaa axte nii kweekli Dios kchë cos. Por singo chëb Dios lo kchë profet nii biid penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lëë Moisés chëb lo pxusykoltoo no: “Lëë Dios kxaal tu xaa nii kñee xtiits Dios. Sinak nii pxaal xaa naa, lady to kchoo xaa go. Kol ksal kchëëtyee nii kñë xaa, ");
INSERT INTO ztqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","por kchësy meñ nii ksaldy profet ko, lëë meñ go nitylo. Singo mod lëë meñ go kchoo kyedzy Israel.” ");
INSERT INTO ztqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ni kchësy kaa profet kwnee kchë nii noyak leñ tse re. Klo Samuel kwnee nii sinrii kak, loxsye ngo kchë profet nii biid. ");
INSERT INTO ztqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Par lëë do nak kchë tiits nii pxaal Dios lo profet ni par lëë do nak tiits nii psaan Dios lo pxusykoltoo no tsiñee chëb xaa lo Abraham: “Lo xtiiyoo kchoo meñ nii kuuñlay kchë meñ nii nche lo kislyu.” ");
INSERT INTO ztqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tsi lëë Dios kaa beeñ kpañ xiñ, klo lo do pxaal Dios xaa par kuuñlay xaa lëë do, parñee ksaan do xtol do. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lëë Pedre ni Juan bii nonee lo meñ, tsiñee lëë pxosy ptsiñ ksa xaa nii xkyënap lidzy Dios ni xaa saduceo. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Xlëë xaa porñee lëë Pedre ni Juan nonee lo meñ nii nli spañ meñ kuty, por lëë Jesús pañ. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lëë xaa xñabey kwnaasy xaa aan leñ skiib ptseñ xaa kyool go, porñee tsel ptsye tse kwnaasy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per ndaly meñ nii pkëëtyag kchë nii kwnee xaa bniladzy, aan lëë meñ nii xniladzy xtiits Dios ptyalyre. Pkab siik kaay mily nonstyee xaapkiy. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lëë byaani lyu lëë xaa nii xñabey lo meñ Israel, ni xaa kol, ni maestre ley pkaal lsa Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Wi Anás, xaa nii xñabey lo pxosy so siko, ni Caifás, ni Juan, ni Alejandro ni kchësy meñ lidzy xaa nii xñabey lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Lëë xaa kwnabey koktsyetsy Pedre ni Juan, aan loxsye pso xaa xaa groltyee, lëë xaa kwnabtiits lo xaa, chëb xaa: —¿Cho bnee tiitspey lo do nii chuuñtsyey do kchë cos re? ");
INSERT INTO ztqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tsigo lëë Pedre, xaa nii nyoo no Kyalbini Ntson leñ styoo kwëb chëb: —Kchësy to nii nak to xaa xñabey ni kchësy to xaa kol, ");
INSERT INTO ztqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lëë do xñabtiits loo noo dyon xa byak tu xaa xsyaknë. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lëë noo kñeeli lo do parñee kaknan do ni kaknan kchë meñ nii no Israel nii lëë xaa re byak por xkyalwnabey Jesucrist Nazaret. Lëë do pkëë xaa lo crusy, per lëë Dios beeñ kpañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Lëë Jesús nak sinak kyo nii psëëb to kchë do siñee xsaa do yu, per lëë na lëë xaa nak sinak tu kyo nii mastre xkiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ni tu cho chilody kteelaa lëë no lo tol lo kislyu re, xaktyee Jesús, xaa nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tsiñee lëë xaa xñabey kon nii nder confians xñee Pedre ni Juan, aan lëdy xaa chak nak xaa, psee xaa xñabey aan lëë xaa byeñ nii xpëëdscuel Jesús nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pchilody pe cos nguëëkiy xaa xñabey xaa, porñee lëë xaa nii byak so siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Per lëë xaa kwnabey pchoo Pedre ni Juan lo junt aan lëë xaa byaan kchë xaa siñee xñabey xaa, xtilytiits lsa xaa, ");
INSERT INTO ztqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","xñee xaa: —¿Xa kuuñ no xaa re? Por kchësy meñ nii no Jerusalén nan nii lëë xaa beeñtsyey kyalntson re, aan chilody tyeesy no nii nlidyo. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per parñee kxooñtre tiits lady meñ, kol tsoo ktseb no xaa, parñee destye natse kseejtre xaa lë Jesús ni stu lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsigo lëë xaa kwtsyetsy xaa, aan lëë xaa kwnabey nii kseejtre xaa ni kluuytre xaa xtiits Jesús lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Per lëë Pedre ni Juan kwëb chëb: —Misme lëë do na dyon kol kyeñ deelñee buen sak Dios nii ksoob noo xtiits to, lëël nii ksoob noo xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kñabty to nii ksaan noo kñee noo kchë nii ptyon noo ni ptsyon noo, por chilodyo. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tsigo lëë xaa xñabey kwëntseeb lo xaa, per lëë xaa blaa xaa. Ptsyoldy xaa xa nsaksi xaa xaa, porñee kchësy meñ xtee skizh lo Dios por kchë nii kon meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Masy choow iz chap xaa nii byak por kyalntson go. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tsi lëë Pedre ni Juan kwlaa, lëë xaa sey laañee nche xcombañer xaa aan lëë xaa bitiits kchë nii chëb pxosy ni xaa kol lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tsiñee lëë xcombañer xaa lox pkëëtyag kchë nii bitiits xaa, lëë xaa bitiitsni Dios tusyke kchë xaa, chëb xaa: —Tat Tios, lii nii psaal kpaa ni kislyu ni nistoo ni kchë lo cos, ");
INSERT INTO ztqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","lii beeñ knee pxusykoltoo noo David, tsiñee por Kyalbini Ntson chëb xaa: ¿Penak nii xlëë meñ nii nche lo kislyu, ni penak nii cho cos nii pa xkiiñdy leñ kik meñ? ");
INSERT INTO ztqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Lëë kchë rey ni lëë xtisy nii xñabey lo kislyu ptyop parñee ktilyni xaa Dios ni parñee ktilyni xaa xaa nii kwle Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Nli nii lëë Herodes ni Poncio Pilato pkaal lsa leñ kyedzy re kchë xaa meñ sit ni meñ Israel par ktilyni xaa xiñoo Jesús nii pxaaloo lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Singo mod lëë xaa beeñtsyey kchë nii nol kikoo kak destye penaadle. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lëë nana, Tat Tios, buy kchë xkyalntseeb xaa, aan beeñ yudar xaa nii xsoob xtiitsoo parñee ktsyebty xaa kluuy xaa xtiitsoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bluuy xkyalwnabeyoo tsiin kuuñ kyak xaa meñ xsyaknë ni kuuñtsyey xaa kyalntson por xtiits xiñ ntsonoo Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tsiñee lëë xaa lox bitiitsni Dios, lëë laañee nche xaa pxisy, aan lëë Kyalbini Ntson kwsëëb kchë leñ styoo xaa, ni lëë xtseeb pchoo lo xaa parñee kñee xaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tugak kwyo kik kchë meñ nii bniladzy xtiits Dios. Ni tu cho chëbty: “Xcheñsyaa nak cos re”, sink kchësy xcheñ meñ kok kchë cos, kwyody xpixwano. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Con kyalwnabey gaa tugak lëë apostle kwnee nii nli pañ Jesús aan mbëë beeñlay Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kwyody ni tu meñ nii nyo lyaadzy lady xaa, por lëë meñ nii chap lyu o yu gaa ptow aan lëë meñ kuni tumi go lo apostle ");
INSERT INTO ztqNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","par kiisy apostlo lo meñ nii no lyaadzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Singo beeñtsyey tu xaa nii pcholë José. Lo xtiiy Leví pkab xaa, chu nis nii lë Chipre koly xaa. Aan lëë apostle kwnee lo xaa Bernabé. (Tiits ko nak sinak nii xñee ñe: Xaa nii xchoobladzy.) ");
INSERT INTO ztqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Lëë xaa pto tublë lyu nii kop xaa aan lëë xaa kuni tumi go lo apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Singo gak beeñtsyey tu xaa nii pcholë Ananías chop tsiil xaa Safira. Lëë xaa pto tublë lyu, ");
INSERT INTO ztqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","aan pteejty xaa kchë tumi nii kwtow lo apostle, xaktyee groltyeew ptee xaa. Lëë xaa byaani stu grolo, aan chop tsiilsye xaa koknano. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lëë Pedre chëb lo xaa: —Ananías, ¿penak nii kwsëëb xaatox leñ styool par jkëëtiil Kyalbini Ntson aan kyaanil grol tumi nii kwto lyu? ");
INSERT INTO ztqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Pe lëdy xcheñoo nayak nak lyu? Ni tsi lëëw lox ptoo gaal, ¿pe lëdy xcheñoo nayak nak tumi go? ¿Penak nii beeñtsyeyoo sinrii? Dios gon pkëëtiil, pkëëtiidyoo cholsye meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tsiñee biñ Ananías ngo, lëë Ananías byab lyu aan lëë xaa kuty. Ntseeb ptsyeb kchë meñ nii koknano. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsigo lëë bla xaa yeeñ nii nche siko pchal Ananías tublë ladx aan lëë xaa kujkeetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lëë kwloxo siik tson wor, lëë tsiil Ananías ptsiñ. Ni tu pe nandy me. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Lëë Pedre kwnabtiits lo me chëb: —Kwneeli dyon, ¿pe lal nii pto do lyu në do lon? Lëë me chëb: —Nliw, lal ngo pto noow. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tsigo lëë Pedre chëb: —¿Penak nii kwyotiits to par jkaal do xKyalbini Ntson Dios? Lëë meñ nii kujkeetsy tsiiloo siid ske. Lëë na lëël jkyeetsyak wil. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aan wor go kazh lëë me byab kexka lo Pedre. Tsi lëë xaa yeeñ go bikche kon xaa lëë me tse lox kuty, lëë me blis xaa aan lëë me kujkeetsy xaa kwi tsiil me. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Aan kchësy meñ nii xniladzy xtiits Dios nii xkaal lsa siko ni kchësy meñ nii koknano ptsyeb. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ndaly kyalntson beeñtsyey apostle lady meñ nii tugak xkaal lsa laañee lë lo xley Salomón. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Aan nikxe nii ni stu meñ byaxty nsyëëb lady meñ nii xniladzy xtiits Dios, bleni meñ kyedzy meñ nii xniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ni lëë meñ nii xniladzy kaa ptyalyre, nikxe mguiyo nikxe gaa kwnaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kwlii meñ kchë meñ xsyaknë nëz aan xkix meñ meñ xsyaknë go lo ta parñee tsiñee te Pedre siquier xmalë xaa kyab lady bla meñ xsyaknë go. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wi meñ kyedzy nii nche kexka Jerusalén biidni meñ xsyaknë ni meñ nii no kyalbini mal leñ styoo aan kchë meñ go byak. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lëë xaa nii xñabey lo pxosy ni xaa saduceo xtilyni apostle porñee kchë meñ xleni apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Lëë xaa kwnaasy apostle aan lëë xaa kwloo xaa xiskiib kyedzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per lëë tu xangly Dios kukxaly chu skiib wor kyool aan lëë angly kwlii xaa skiib chëb: ");
INSERT INTO ztqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Kol tsi lidzy Dios aan kol kutiits lo meñ xa nak kyalmbañ nii xneetsy Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lëë byaani kazh lyu silyga, lëë xaa kwsëëb leñ lidzy Dios aan lëë xaa bislo xluuy xaa xtiits Dios lo meñ sinak chëb angly lo xaa. Mentre gaa lëë xaa nii xñabey lo pxosy ni lëë xaa nii nak ksa pxosy ptop kchë xaa kol nii xñabey nii no Israel. Loxsye ngo lëë xaa kwnabey kchoo apostle skiib. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Per tsi lëë mayor ptsiñ chu skiib, cho sëre gaa, aan lëë mayor kuknitiits, ");
INSERT INTO ztqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","chëb: —Tsiitsy nyoogw chu skiib ptsiiñ noo, lëë soldaad kaa nche nap chu puert. Per tsiñee lëë noo pxaly chu puert, ni stu cho kintre leeñgo. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tsiñee lëë xaa nii xñabey lo pxosy ni lëë xaa nii xkyënap lidzy Dios biño, lëë xaa kwnabtiits lsa lo xcombañer xaa, xñee xaa: Nli gaa axte pa lo kyal kchë cos re. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ngo nchenee xaa tsi lëë tu meñ ptsiñ chëb: —Lëë xaa nii gon kwloo do skiib no kluuy xtiits Dios lo meñ leñ lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsigo lëë xaa nii xñabey lo mayor ni lëë mayor kukxi xaa, per psaksidre xaa xaa, porñee ptsyeb xaa ndeekyo meñ kyedzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tsiñee lëë xaa ptsiñni xaa, lëë xaa pso xaa groltyee lady kchë xaa kol nii xñabey, aan lëë xaa nii xñabey lo pxosy chëb lo xaa: ");
INSERT INTO ztqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Lëë noo bñeel lo do gon nii nodre nii kseety to lë Jesús. Aan biñdy to tiits, sink lëë do no kiisy xiwseedy to tyub Jerusalén, aan chakladzy to jkëëkiy do lëë noo xkyalkuty Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tsigo lëë Pedre ni lëë stubla apostle kwëb chëb: —No nii klo xtiits Dios ksoob noo que xtiits chol meñ lo kislyu re. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lëë xDios pxusykoltoo no beeñ kpañ Jesús, xaa nii pkëë do lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Lëë Dios psoob Jesús nëzli parñee kñabey Jesús ni parñee kteelaa Jesús meñ Israel nii ktikche styoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ksa noo Kyalbini Ntson nii xtee Dios lo meñ nii xsoob xtiits xaa xñee nii nli beeñtsyey Dios nrii. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tsiñee lëë xaa xñabey biñ ngo, per nli busy blëë xaa aan wor go kazh kokladzy xaa nyuty xaa apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per lady kchë xaa xñabey go no tu xaa fariseo nii pcholë Gamaliel. Maestre ley xaa ni xsal gaa meñ xaa. Lëë xaa kwsoli aan lëë xaa kwnabey pchoo apostle ley xisy wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Loxsye ngo lëë xaa chëb lo xaa xñabey: —Kchësy to xaa Israel, siñee nche do nu, kol kyeñ gon pe kuñ do xaa gue. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kol ksaladzy gaanoo nii penaadle pchoo tu xaa nii pcholë Teudas, xñee xaa nii tu xaa non nak xaa, aan kwsëëb siik tap kyoow meñ xlad xaa. Per blyëëdy lëë xaa beety meñ, aan kchësy meñ nii kwsëëb xlad xaa pchoots klyaal, aan lëë xcuent xaa byal sikootyee. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kok xtsedyako, leñ tse nii chaa cens, lëë tu xaa Galilea nii pcholë Judas pchoo, aan singo gak ndaly meñ kwsëëb xlad xaa, per lëë meñ beety xaa, aan lëë kchësy meñ nii kwsëëb xlad xaa pchoots klyaal. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Por ngo lëën xñe lo do: Kol ksaan xaa gue, jkaaldy to xaa. Por deelñee kiksye chol meñ xlyañ nii chuuñtsyey xaa sitsiñ tse nii lëëw kyal. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per deelñee xtsiiñ Dios kayuuñtsyey xaa, chilody jkwëës to low. Kol kap cuent, toontlaa Dios no ktilyni do. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kchësy xaa xñabey go psal xtiits Gamaliel. Loxsye ngo lëë xaa kwtsyetsy apostle. Lëë xaa ptee xcheñ xaa ni lëë xaa chëb nii nodre nii kseety xaa lë Jesús, per lëë xaa blaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lëë apostle pchoo lady xaa xñabey go xle xaa porñee lëë Dios ptee tiitspey psaksi meñ go xaa por xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aan psaandy xaa, sink ksatyee tse kwnee xaa lo meñ nii lëë Jesús xaa nii pxaal Dios biid kteelaa meñ lo tol. Kchë ngo kwnee xaa lo meñ leñ lidzy Dios ni kchë ngo kwnee xaa tsiñee kwey xaa lidzy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Leñ tse go, como lëë meñ nii xniladzy xtiits Dios ptyalyre, lëë xaa Israel nii xñee tiitsë griego chëb lo xaa Israel nii xñee tiitsë hebreo nii xtyoontsidy kwnaa viud nii xñee tiitsë griego tsi lëë nii xtyaaw xkaasy. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tsigo lëë ksa tsiipchop apostle ptop kchësy meñ nii xniladzy xtiits Dios aan lëë xaa chëb: —Buendyo nii ksaan noo kluuy noo xtiits Dios par kiisy noo nii ktyaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Por ngo, beetsy, kol kyub kadzy xaa nii chap to confians, xaa nii xyeñ, ni xaa nii nyoo no Kyalbini Ntson leñ styoo, aan kol ktee tsiiñ re lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lëë noo tugak kutiitsni Dios ni lëë noo kluuy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Byo nii kwnee apostle styoo xaa nii xniladzy xtiits Dios, aan lëë xaa kwle tu xaa nii pcholë Xteb. Tyub styoo Xteb xniladzy Xteb Dios ni nyoo gaa nii no Kyalbini Ntson leñ styoo Xteb. Ni lëë xaa kwle Felip, ni Prócoro, ni Nicanor, ni Timón, ni Parmenas, ni Nicolás, tu xaa Antioquía nii penaadle bniladzy xlay meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Loxsye ngo lëë xaa kuni xaa nii kwle xaa lo apostle, aan lëë apostle kwnab lo Dios por kchë xaa go ni lëë apostle pxob ña xaa kik xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lëë xtiits Dios pkaasyre, ni lëë meñ nii xniladzy ptyalyre Jerusalén, aan axte wi bla xipxosy meñ Israel bniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kokni Dios Xteb. Ngo nii ptee xaa tiitspey beeñtsyey Xteb kyalntson lady meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lëë bla xaa Cirene, ni xaa Alejandría, ni xaa Cilicia, ni bla xaa kyedzy Asia, nii chi ktoo nii lë Libertados, bislo ptilytiitsni Xteb. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per xlyëbty xaa lo Xteb, porñee nonsyke Kyalbini Ntson xsyaab leñ kik Xteb pe cos ktikche Xteb lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsigo lëë xaa kwtiix bla xaa nii këb nii biñ kwneenë Xteb Moisés ni Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Lëë xaa pkiily meñ kyedzy ni xaa kol ni maestre ley. Singo mod lëë xaa kwnaasy Xteb aan lëë xaa kukso xaa lo xaa xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Byubak xaa meñ nii kwnee xuuy chëb: —Lëë xaa gue tugak nonee në lidzy Dios ni xley Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ptsyon noo kwnee xaa nii lëë Jesús Nazaret knitylo lidzy Dios ni lëë xaa me ktsëë kchë costumbre nii psaan Moisés lo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tsigo lëë xaa xñabey ni lëë kchë meñ nii nche sob siko buy lo Xteb, aan lëë xaa kon nii chak lo Xteb si chak lo tu angly. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tsigo lëë xaa nii xñabey lo pxosy kwnabtiits lo Xteb chëb: —¿Pe nli nii kwneel kchë nii xkëëkiy meñoo? ");
INSERT INTO ztqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Lëë Xteb kwëb chëb: —Beetsy, kchësy to siñee nak to xaa kyedzy re, xñabaa lo do nii jkëëtyag to choplan xtitsaa. Worñee gon lëë pxusykoltoo no Abraham bii no nëz Mesopotamia, lëë Dios ntson byaklo lo xaa, antes nii kyey xaa nëz xtañ meñ Harán, ");
INSERT INTO ztqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","lëë Dios chëb lo xaa: “Psaan xtañoo ni kchësy meñ liidzyoo, aan kwey tañ nii kluyaa lool.” ");
INSERT INTO ztqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tsigo lëë Abraham pchoo xtañ meñ Caldea aan lëë xaa kutso nëz Harán. Lëë loxsye kuty pxosy xaa, lëë Dios biidni xaa tañ re, laañee no do nina. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per ni tublë lyu pteejty Dios lo xaa tañ re, per ni tu laa nsyo tu niy xaa pteejty Dios. Aan nikxe nii chapty xaa mëëd tiemp ko, lëë Dios chëb nii lëëw ktee xaa lo xiñ xaa tsi lëë xaa lox kety. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ni lëë Dios chëb kazh nii lëë kchë meñ nii sëëd lo xtiiy xaa tsitso xtañ meñ sit, ni lëë meñ sit jkuñ xaa tsiiñ, ni lëë meñ sit ksaksi xaa tap kyoow iz. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Per lëë Dios chëbak nii lëë xaa ksaksi kchë meñ sit nii jkuñ meñ Israel tsiiñ, aan loxsye ngo lëë meñ Israel kchoo siko, aan lëë meñ Israel kiid kutiitsni Dios nu. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lëë Dios kwnee lo Abraham, aan lëë Dios kwnabey nii tsobey xaa, sinak tu señ nii lëë Dios tugak kakni xaa. Por ngo, tsi lëë xiñ xaa Isaac koly, tse nii ptsiil xaa xmal, lëë Abraham kwlobey xaa, aan singo gak beeñtsyey Isaac xiñ xaa Jacob, aan singo gak kwlobey Jacob ksa tsiipchop xiñ xaa. Lëë xiñ Jacob nak pxusykoltoo ksa tsiipchop xtiiy meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Betsy xiñ Jacob nak José, aan por kyalmbidy lëë xaa pto xaa par kyey xaa Egipto. Per lëë Dios kokni José, ");
INSERT INTO ztqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ni lëë Dios pteelaa xaa kchëlo kyalnë, ni Dios kaa ptee kyalchak lo xaa. Lëë Dios beeñ nii byo xmod José styoo Faraón rey Egipto. Ngo nii lëë xaa pso José kok José xtisy Egipto aan axte wi lidzy rey kwnabey José. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tsi lëë kpiñ biid, mban kwte meñ tyub Egipto ni Canaán, aan ptsyoldy pe nyaw pxusykoltoo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Per tsi lëë Jacob biñ nii lëë xobxtily no Egipto, lëë xaa pxaal xiñ xaa siko, xaa nii kok pxusykoltoo no. Lëë xaa kwey primer viaj. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lëë pchopo viaj lëë José pchoo neñlo lo betsy, aan lëë gaa xaa byuumbey xaa. Singo lëë rey Egipto koknan pa lo tiiy sëëd José. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Loxsye ngo lëë José chëb lo betsy: “Kol tsikxi pxosy no ni meñ lidzy no.” Tsongalyptsiipkyay meñ lidzy xaa ptsiñ Egipto. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Singo nak nii lëë Jacob kutso Egipto, siko kuty xaa, ni siko kuty pxusykoltoo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lëë kwloxo bla iz lëë kchë xtsit xaa byey Siquem, aan lëëw pkyeetsy leñ paa nii kwxii Abraham con tumi lo xiñ Hamor. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Lëë tsi lëë tiits nii chëb Dios lo Abraham mer kak cumplir, lëë meñ Israel ptyaly Egipto. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Aan lëëtyee gaa tiemp ko lëë tu rey nii byuumbeydy José kwsob kwnabey Egipto. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Lëë rey go pkëëti xtiiy no ni lëë xaa psaksi pxusykoltoo no, xoo kwnabey xaa psëëb pxusykoltoo no xiñ xaa nii lox chaly parñee kety mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tiemp ko koly Moisés. Tu mëëd nii byo styoo Dios kok xaa, aan lëë pxosy xaa kwloolan xaa tson mëë. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Per tsiñee pchilodre ngolan xaa xaa, lëë xaa psëëb xaa, aan misme xiñtsyaap rey Egipto blis xaa, aan lëë me kon xaa sinak nii nyak xaa xiñ me. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ngo nii pseedy Moisés kchë nii xseedy meñ Egipto, ni kok ndaan xaa por kchë nii kwnee xaa ni beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Choow iz Moisés tsi lëë xaa kwlokyeñ tsitedy xaa lo meñ xkyedzy xaa, meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Siko kon xaa nii lëë tu xaa Egipto no ktee xcheñ tu xaa xkyedzy xaa. Aan parñee kla xaa xaa xkyedzy xaa, lëë xaa beety xaa Egipto go. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nladzy xaa tsaaplaa nyeñ meñ xkyedzy xaa nii lëë Dios kteelaa meñ xkyedzy xaa por lëë xaa, per byeñdy meñ xkyedzy xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lëë byaani lyu, lëë Moisés kon nii lëë chop xaa Israel nche ktily aan como lëë xaa kokladzy ntsily xaa xaa lëë xaa chëb: “Betsy to. ¿Penak nii singue nche ktily do?” ");
INSERT INTO ztqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tsigo lëë xaa nii no ktee cheñ xcombañer pchëëp Moisés, aan lëë xaa chëb: “¿Cho psoo gaal nii kñabeyoo loo noo, ni cho në lool nii kakoo xixtisy noo? ");
INSERT INTO ztqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ote chakladzyoo yak kutyoo naa sinak beetyoo xaa Egipto neeg?” ");
INSERT INTO ztqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tsi lëë Moisés biñ ngo, lëë xaa pxooñ aan lëë xaa si nëz xtañ meñ Madián. Siko kwyo xaa ni siko koly chop xiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Lëë kwloxo choow iz, lëë tu angly byaklo lo xaa lo tu yakitsy nii noyek kexka xan kiy nii lë Sinaí. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ntseeb psee Moisés kon ngo. Tsi lëë xaa big par kan ngui xaaw, lëë xaa biñ tsiy Dios nii xñee: ");
INSERT INTO ztqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Naa nak xDios pxusykoltool, naa nak xDios Abraham, xDios Isaac ni xDios Jacob.” Tsigo lëë Moisés bislo xisy porñee tir xtsyeb xaa, aan byaxty xaa nyuy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Per lëë Dios chëb lo xaa: “Blity laboo, por ntson laañee nosubniyoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Chanaa xa këksaksi meñ Egipto meñ nii ngab lon. Por ngo lëën byety par kteelaan meñ nii ngab lon. Na të tsiin kxalaa lii Egipto.” ");
INSERT INTO ztqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Klo chëb meñ kyedzy lo Moisés: “¿Cho psool nii kñabeyoo loo noo ni cho në lool nii kakoo xixtisy noo?” Per lëë Dios pxaal xaa sinak tu xaa xñabey ni sinak tu xaa nii xteelaa. Lëë angly nii byaklo lo xaa lo yakitsy nii noyek kokni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Lëë Moisés kwlii pxusykoltoo no Egipto, ni beeñtsyey gaa xaa kyalntson Egipto, ni chu Nistoo Nixñë, ni tyub tañ pidzy nii kwtedy xaa choow iz ksa xaa pxusykoltoo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ni misme gaa Moisés chëb lo meñ Israel: “Lëë Dios kxaal tu profet nii kchoo lady to, sinak nii pxaal xaa naa.” ");
INSERT INTO ztqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lëë gak Moisés pkaal lsa ksa pxusykoltoo no tañ pidzy. Lëë angly nii kwnee lo xaa kiy nii lë Sinaí kokni xaa. Lëë xaa pkaaxcuent xtiits ntson Dios nii xnee kyalmbañ par kteso xaaw lo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per koklasty pxusykoltoo no nsoob xtiits xaa, sink lëë pxusykoltoo no kokladzy mbikche nyey Egipto. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Lëë pxusykoltoo no chëb lo Aarón: “Chakladzy noo nii ksaal tu mdyo nii nech loo noo, por toon pe cos kok Moisés nii kwlii lëë noo xtañ meñ Egipto.” ");
INSERT INTO ztqNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsigo lëë xaa psaa tu mdyo nii chak si chak tu becerr, ni lëë xaa beety ma mbañ par kokon xaa ma lo mdyo go. Loxsye ngo lëë xaa beeñtsyey tu lni par kleni xaa mdyo nii kwyaa con ña xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ngo nii lëë Dios psaan pxusykoltoo no par kleni xaa kchë mëly nii xsaani leñ kpaa. Sinrii kë leñ xkitsy Dios nii pkëë kchë profet: Lo choow iz nii kunsë do tañ pidzy, ¿pe beety to ma dyon, par kokon do ma lon? ");
INSERT INTO ztqNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Psoobty to tiits gon, sink lëë do kwënoy lidzy mdyo nii lë Moloc, ni lëë do kwënoy xmëly ximdyo do Renfán, mdyo nii psaa do par kleni do. Por ngo lëën kwi lëë do xtañ do, aan lëë do kxalaa tu laañee mastre sit lo Babilonia. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Tyub nii kwyo pxusykoltoo no tañ kwënoy xaa lidzy Dios nii kwyaa con ladx. Leeñgo kwyotsey table nii kë ley. Lëë yu go kwyaa sinak nii kwnabey Dios lo Moisés, tsiñee chëb xaa nii ksaa xaaw sinak nii kon xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lëë pxusykoltoo no byaani yu go aan tsi lëë meñ xkyedzy no ptsiñ xtañ meñ sit ksa Josué, wiw ptsiñni xaa. Siko kwlii Dios kchë meñ nii nol kyedzy ko par ktee Dios kyedzy ko lo pxusykoltoo no. Aan singo kwëngob xaa yu go axte xtiemp David. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Lëë rey David bleni Dios, aan kokladzy xaa nsaa xaa tu laañee nyo xDios meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per lëël Salomón nak nii psaa lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nikxe nii nody Dios nii sob kpaa leñ yu nii chaa con ña meñ. Sinak chëb Dios lo profet: ");
INSERT INTO ztqNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kpaa nak laañee sobaa xñabeyaa, lo kislyu xson niyaa. ¿Xa xña yu nii ksaa do par naa? xñee Dios, ¿o xa xñaa gaa laañee kxiladzyaa? ");
INSERT INTO ztqNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Pe lëdy con ñan nayak psan kchë cos? ");
INSERT INTO ztqNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Per lëë do, chëb Xteb, tugak nguiedzy nak styoo do. Chaklasty to jkëëtyag to xtiits Dios. Nak to sinak meñ nii xyuumbeydy Dios. Tugak xtilyni do Kyalbini Ntson. Lëësyak pxusykoltoo do nak to. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Pe kwyo tu profet dyon nii psaksidy pxusykoltoo do? Lëë pxusykoltoo do beety kchë xaa nii kwnee nii lëë Crist kiid, aan lëë na nii lëë Crist biid, lëë do kokniladzy xaa ni lëë do beety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lëë angly biidni xley Dios lo do, per xsaldy tow. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tsiñee lëë xaa xñabey lox biñ kchë nii kwnee Xteb, per nli busy blëë xaa lo Xteb axte chawlay xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tsigo lëë Xteb nii nyoo no Kyalbini Ntson leñ styoo blëp lo leñ kpaa aan lëë xaa kon xkyalntson Dios, ni lëë xaa kon nii lëë Jesús kusoli kwi Dios nëzli. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Aan lëë xaa chëb lo xaa xñabey: —¡Kol kuy leñ kpaa gaanoo! Lëën chan nii lëë Xiñ Dios nii pxaal xaa so kwi xaa nëzli. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Per lëë xaa xñabey koñee ptsetyag, aan lëë xaa bislo chuptsyë yë xaa, lëë xaa kwseñ Xteb. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Lëë xaa kwlii Xteb leñ kyedzy aan lëë xaa pteekyo Xteb. Lëë tu xaa nii pcholë Saulo byaani xab kchë meñ nii kukteekyo Xteb. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aan mentre lëë xaa no kteekyo Xteb, lëë Xteb chëb lo Jesús: —Jesús, pkaaxcuent xkyalbiniin. ");
INSERT INTO ztqNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Loxsye ngo lëë xaa psoxib aan lëë xaa kwchuptsyë nguiedzy xñee xaa: —Tat Tios, ksaldyoo xtol meñ re. Aan loxsye kwnee xaa singo, lëë xaa kuty. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Aan kwyo Saulo conforme nii kuty Xteb. Misme tse go lëë meñ bislo xsaksi meñ nii xniladzy xtiits Dios nii no Jerusalén aan kchësy meñ nii xniladzy pchoots klyaal tyub xtañ meñ Judea ni Samaria. Xaktyee apostle byaan Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lëë bla xaa nii buen styoo kujkeetsy Xteb ni mban biiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mentre gaa lëë Saulo kënlaag meñ nii xniladzy xtiits Dios, xsyëëb xaa yu por yu xkwii xoo xaa kwnaa ni mguiy chilo xaa skiib. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Per lëë kchë meñ nii pchoo Jerusalén xluuy xtiits Dios nii xteelaa laañee xtsiiñtyee meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Wi Felip pchoo Jerusalén, aan lëë xaa kwey leñ kyedzy Samaria aan lëë xaa bislo xñee xaa lo meñ nii lëë Jesús nak xaa nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tsiñee lëë meñ kon kchë kyalntson nii chuuñtsyey Felip, lëë meñ pkaal lsa par jkëëtyag meñ nii xñee Felip. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ndaly meñ nii no kyalbini mal leñ styoo byak, aan chuptsyë kyalbini mal xchoo leñ styoo meñ go, ni ndaly meñ nii kutoo ni meñ nii xsyëdy byak. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Por ngo ble meñ kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per leñ kyedzy ko kwyo tu xaa nii pcholë Simoñ. Chuuñtsyey xaa kyalbruj aan chuuñ ksee xaa meñ Samaria, xñee xaa nii tu xaa non nak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kchësy xaa wiñ ni xaa kol xkëëtyag xtiits xaa aan xñee meñ: —Lëë xaa gue noy xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kchësy meñ psal xaa, porñee con xkyalbruj xaa xtse beeñ ksee xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per tsiñee lëë meñ bniladzy xtiits Jesús nii ptsiñni Felip, lëë meñ byeñ xa nak xkyalwnabey Dios, ni lëë meñ kwchobnis, nikxe mguiyo nikxe gaa kwnaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aan axte wi Simoñ bniladzy ni kwchobnis, aan lëë xaa bislo kwënal xaa Felip, xsee xaa chan xaa kchë kyalntson nii chuuñtsyey Felip. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tsiñee lëë apostle nii ncheno Jerusalén biñ nii lëë meñ Samaria bniladzy xtiits Dios, lëë xaa pxaal Pedre ni Juan siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tsiñee lëë xaa ptsiñ, lëë xaa kwnab lo Dios por kchë meñ Samaria nii bniladzy parñee sëëb Kyalbini Ntson leñ styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porñee lëë meñ go kwchobnis worñee bniladzy meñ go xtiits Dios nii xñee cho nak Jesús, per ni tu leñ styoo meñ go karty sëëb Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lëë Pedre ni Juan pxob ña kik meñ go, aan lëë Kyalbini Ntson kwsëëb leñ styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tsi lëë Simoñ kon nii lëë Kyalbini Ntson xsyëëb leñ styoo meñ tsi lëë apostle xob ña kik meñ, lëë xaa kwlii tumi, ");
INSERT INTO ztqNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","aan lëë xaa chëb: —Kol kneetsy kyalwnabey gue lon parñee kchë kik meñ nii kxobaa ñan sëëb Kyalbini Ntson leñ styoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tsigo lëë Pedre chëb: —Deelba nitylool kchë xtumil. ¿Xa nanoo nii sil nii xkady Dios? ");
INSERT INTO ztqNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nonguialdy nii kuuñtsyeyoo tsiiñ nii chuuñtsyeey noo, por chan Dios nii nguidy no styool. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Psaan xtoloo, aan kwnab lo Dios nii ktsily xaa tol nii psya leñ styool. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Por chanaa nii tir chak mbiidyoo, ni chanaa nii xlaady tol lii. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tsigo lëë Simoñ kwëb chëb: —Kol nab lo Dios por naa, parñee ktsyooldyaa kchë nii në do lon. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Loxsye bitiits apostle cho nak Jesús, ni loxsye bluuy xaa xtiits Dios, lëë xaa bikche sey xaa Jerusalén, aan ndaly kyedzy Samaria nii ptedy xaa bluuy xaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Loxsye ngo, lëë tu xangly Dios chëb lo Felip: —Ligier kwey nëz kyety, nëz nii xchoo Jerusalén xtsiñ Gaza. Lëë nëz ko xtyedy nëz tañ pidzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lëë Felip si aan lëë tu xaa Etiopía pkaa lo xaa nëz. Tu xaa non nak xaa go, lëë xaa xkotsey kchë xtumi kwnaa nii nak rey Etiopía nii lë Candace. Lëë xaa kukiily lay lo Dios Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Lëë xaa sey xtañ xaa, sobsye xaa leñ tu carret, xlab xaa libre nii pkëë profet Isaías. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tsigo lëë Kyalbini Ntson chëb lo Felip: —Big kex xan carret ke. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tsi lëë Felip big, lëë xaa biñ nii lëë xaa Etiopía go no klab libre nii pkëë profet Isaías. Tsigo lëë xaa kwnabtiits, chëb xaa: —¿Pe xyeeñoo libre nii no klaboo? ");
INSERT INTO ztqNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lëë xaa Etiopía chëb: —¿Xa kyeeñ no deelñee kindy cho kñë lon xa nako? Tsigo lëë xaa chëb lo Felip: —Kwyëp aan kwsob kwin. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sinrii xñee laañee no klab xaa Etiopía go: Sinak nii chixi meñ mëkwxiily nii kety, kuxi meñ xaa, ni nak xaa sinak tu mëkwxiily nii chuptsyëdy tsi xtsiib meñ ma, por kwchuptsyëdy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Psaksi meñ xaa, aan ni tu cho beeñdy xkyalxtisy xaa. ¿Cho lë nii kñë xa kok kchë meñ nii kwyo xtiemp xaa? Por lëë xaa seyle, sodre xaa lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tsigo lëë xaa Etiopía chëb lo Felip: —Beeñ favor kwnë lon dyon cho por lëë xñee profet nrii, ¿pe por lëë xaaw, ote por stu meño yak? ");
INSERT INTO ztqNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lëë Felip bislo chëb xa nak laañee no klab xaa, aan singo mod lëë Felip chëb lo xaa cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Lëë tsi lëë xaa sitedy tu laañee no nis, lëë xaa Etiopía chëb lo Felip: —Xaatee mbëë no nis nu. ¿Pe chiloody kaa dyon chobnisaa? ");
INSERT INTO ztqNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Lëë Felip chëb: —Deelñee xniladzyoo tyub styool, schilow. Lëë xaa Etiopía kwëb chëb: —Xniladzyaa nii Jesucrist nak Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsigo lëë xaa kwnabey kwsotse carret, aan lëë xaa kwsëëb lo nis chop xaa Felip, aan lëë Felip pchoobnis xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tsi lëë xaa pchoo lo nis, lëë xKyalbini Ntson Dios biy Felip. Aan bikchedre nyan xaa Felip, per xle xaa lëë xaa byo nëz. ");
INSERT INTO ztqNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tsi lëë Felip byeñ lëë xaa tse so tu kyedzy nii lë Azoto, siko pchoo xaa lëë xaa si Cesarea. Aan kchë kyedzy nii kwtedy xaa bluuy xaa xtiits Dios nii xñee cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mentre gaa lëë Saulo tugak nonee nii lëë xaa kuty xpëëdscuel Jesús. Por ngo, lëë xaa kunee lo xaa nii xñabey lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Aan lëë xaa kwnab tublë kitsy parñee con xtiitspey xaa nii xñabey lo pxosy lëë xaa tsinaasy kchë meñ nii no xlad Jesús nii chi kchë ktoo nii sob Damasco. Nol kik xaa nii lëë xaa tsikni kchë meñ nii kñaasy xaa Jerusalén, nikxe kwnaaw nikxe gaa mguiyo. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Per lëë xaa merle ktsiñ Damasco, tsi lëë tu bini nii sëëd sëëb kpaa bibëly kyako kwi xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Lëë xaa byab lyu, aan lëë xaa biñ tsiy tu xaa nii xñee: —Saulo, Saulo, ¿penak nii xsaksil naa? ");
INSERT INTO ztqNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tsigo lëë Saulo kwnabtiits chëb: —¿Chool? Aan lëë tsiy xaa go kwëb chëb: —Naa nak Jesús, xaa nii xsaksil. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tsigo lëë Saulo bislo xisy lo kyalxtseeb chëb: —¿Pe cos chakladzyoo nii kuuñtsyeyaa? Aan lëë Jesús chëb: —Kuxche aan kwey leñ kyedzy. Siko no tu xaa nii kñë pe cos kuñoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kchë xaa nii ksa Saulo si ptsyeb, porñee biñ xaa tsiy xaa nii kwnee, per ni tu cho kondy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Loxsye ngo lëë Saulo kuxche lo lyu, per tsi lëë xaa pxaly lo xaa pchilodre nyan xaa. Nak nii lëë xaa nii ksa xaa si kwseñ ña xaa par ktsiñ xaa Damasco. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Siko kwlës xaa tson kpidz. Pchilody nyan xaa, aan ni tu pe tawdy xaa ni ni tu pe kowdy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Leñ kyedzy Damasco kwyo tu xaa nii xniladzy xtiits Dios nii pcholë Ananías. Lëë Dios byaklo lo xaa lo tu mgaal chëb: —¡Ananías! Aan lëë Ananías kwëb chëb: —Lëën nrii, Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tsigo lëë Dios chëb: —Kuxche aan kwseñ nëz nii xñee meñ Tubli, aan tsiñee ktsiiñoo laañee sob lidzy Judas kwnabtiits por tu xaa Tarso nii lë Saulo. Lëë xaa noyutiitsni naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lëë xaa kon tu xaa nii lë Ananías lo mgaal nii xsyëëb laañee nix xaa, xob ña lady xaa parñee kpikche kan xaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tsiñee lëë Ananías biñ ngo, lëë Ananías chëb: —Tat Tios, ndaly meñ noyutiits lon xa nak xaa go ni kchë kyalnë nii no kteedy xaa kchë meñ nii xniladzy lii nii no leñ kyedzy Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Lëë na lëë xaa sëëdak nu con xtiitspey xaa nii xñabey lo pxosy par koy xoo xaa kchë meñ nii xniladzy lii. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Per lëë Dios chëb: —Kwey, por lëë xaa kwlen parñee kluuy xaa xtitsaa lo meñ sit ni lo xrey meñ sit ni lo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Lëën kluy kchë kyalmban nii tedy xaa por naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsigo lëë Ananías kwey laañee kwlës Saulo. Tsiñee lëë xaa kwyo leñ yu, lëë xaa pxob ña xaa lady Saulo aan lëë xaa chëb: —Saulo, lëë Jesús, xaa nii byaklo lool nëz nii sëëdoo, pxaal naa parñee kpikche kanoo stub ni sëëb Kyalbini Ntson leñ styool. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wor go kazh lëë tublë cos nii nyaa si nyaa lbey pchoo lo xaa aan lëë xaa kon stub. Tsigo lëë xaa kuxche aan lëë xaa kwchobnis. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Loxsye ngo lëë xaa taw par jkaa xaa fuersy stub. Lëë Saulo kwlës bla kpidz lo meñ nii xniladzy xtiits Dios nii no Damasco, ");
INSERT INTO ztqNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","aan lëë xaa bislo xluuy xaa xtiits Dios lo meñ leñ ktoo, xñee xaa nii lëë Jesús nak Xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kchësy meñ nii pkëëtyag nii kwnee xaa xsee, xñee: —¿Pe lëdy lëë xaa gue nayak kënlaag kchë meñ Jerusalén nii no xlad Jesús? ¿Ni pe lëdy kaa par tsikni xaa kchë meñ nii kñaasy xaa lo xaa xñabey lo pxosy sëëd xaa nu? ");
INSERT INTO ztqNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per lëë Saulo pkaare fuersy, aan axte beeñ kchop xaa kik kchë meñ Israel nii no Damasco, tsiñee xñee xaa lo meñ nii nli lëë Jesús nak xaa nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lëë kwloxo bla kpidz, lëë meñ Israel kwnee lsa dyon xa kuty xaa Saulo, ");
INSERT INTO ztqNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","per blyëëdy lëë Saulo koknano. Aan tsel kyool ni yutsye kwche mbës xaa chu puert nii kë chu kyedzy par kuty xaa Saulo. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Per lëë meñ nii no xlad Saulo kwloo Saulo leñ tu tskwidy ngol aan lëë xaa blity meñ tub chex pyedzy nii ntse kyako kyedzy wor kyool, aan singo lëë Saulo kwtelaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tsiñee lëë Saulo ptsiñ Jerusalén, lëë xaa kokladzy nsyëëb xaa lady meñ nii nakle xpëëdscuel Jesús, per kchësy meñ ptsyeb kon xaa porñee bnilasty meñ nii wi xaa tse nak xpëëdscuel Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Per lëë Bernabé kuni xaa lo apostle. Aan lëë Bernabé bitiits nii lëë Saulo kon Jesús nëz, ni lëë xaa bitiits xa mod kwnee Jesús lo Saulo, ni lëë xaa bitiits nii ptsyebty Saulo kwnee Saulo lo meñ Damasco cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Loxsye ngo lëë Saulo kwsëëb lady xpëëdscuel Jesús leñ kyedzy Jerusalén aan lëë xaa bislo xñee xaa cho nak Jesús lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Bitiitsni xaa ni ptilytiitsni xaa meñ Israel nii xñee tiits griego, per lëë meñ go kwyoxko kuty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tsiñee lëë meñ nii nak xpëëdscuel Jesús byeño, lëë xaa kuni Saulo kyedzy Cesarea, aan siko lëë xaa pxaal xaa nëz Tarso. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Leñ tse go mbëë pañ kchë meñ nii bniladzy xtiits Dios nii kwyo Judea, ni Galilea, ni Samaria ni ptsyeb meñ go Dios. Lëë Kyalbini Ntson beeñ meñ go yudar, por ngo lëë meñ nii xniladzy xtiits Dios ptyalyre. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Leñ tse go lëë Pedre kutedy lo kchë meñ nii xniladzy xtiits Dios, aan lëë xaa kutedy lo meñ nii xniladzy xtiits Dios nii no leñ kyedzy nii lë Lida. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Leñ kyedzy ko lëë xaa kutedy lo tu xaa nii pcholë Eneas. Kok xon iz nii chilody tsische Eneas, porñee tyub xaa kutoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Lëë Pedre chëb lo xaa: —Eneas, lëë Jesucrist kuuñ kyak lii. Kuxche aan ptuub xtal. Wor go kazh lëë Eneas kuxche, ");
INSERT INTO ztqNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","aan kchësy meñ Lida ni meñ Sarón nii kon kuxche Eneas bniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tiemp ko kwyo tu kwnaa nii xniladzy xtiits Dios leñ kyedzy Jope nii pcholë Tabita. (Lëë con tiits griego xñee meñ me Dorcas.) Tugak chuñ me yudar meñ nii no lyaadzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lëë Dorcas kwxaaknë aan lëë me kuty. Loxsye pkasy meñ me, lëë me pxob meñ tu leñ yu nii sob klaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kexka Lida nche Jope. Por ngo, tsiñee lëë meñ Jope nii xniladzy xtiits Dios biñ nii lëë Pedre so leñ kyedzy Lida, lëë meñ go pxaal chop xaa nii kunitiits lo Pedre chëb: —Klyëëdyoo, sinusy kol tsoo Jope. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Lëë Pedre sinal aan tsiñee lëë xaa ptsiñ, lëë meñ kuni xaa laañee xoob tuukwnaa go, aan lëë kchësy kwnaa viud ptyop kyako kwi xaa choon xluuy kchë vestid ni mankw nii psaa Dorcas worñee bii mbañ me. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tsigo lëë Pedre kwlii kchësy meñ ley, lëë xaa psoxib, aan lëë xaa kwnee lo Dios. Loxsye ngo lëë xaa buy lo kwnaa kuty ko, aan lëë xaa chëb: —Tabita, kuxche. Tsigo lëë me pxaly lo me. Tsi lëë me kon Pedre, lëë me kwsobli. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Lëë xaa kwseñ ña me aan lëë me psoli xaa. Loxsye ngo lëë xaa kwtsyetsy meñ nii xniladzy xtiits Dios ni lëë xaa kwtsyetsy kchë kwnaa viud nii nche worñee lëë xaa ptsiñ parñee kan meñ nii lëë me pañ. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lëëw koknan kchësy meñ nii no leñ kyedzy Jope, aan ndaly meñ bniladzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ndaly kpidz kwlës Pedre lidzy tu xaa nii xkuutsy kidy nii pcholë Simoñ nii no leñ kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Leñ kyedzy Cesarea kwyo tu xaa nii pcholë Cornelio. Xñabey xaa lo tu kyoow soldad nii sëëd nëz Italia. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Buen xaa ni xtsyeb xaa Dios kchë meñ lidzy xaa. Nroob tumi xtee xaa par kuñ xaa meñ Israel yudar, ni tugak chutiitsni xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lëë tu wtse, siik las tres, lëë tu xangly Dios byaklo lo xaa aan nyë kon xaa nii lëë angly ko kwsëëb laañee sob xaa chëb: —¡Cornelio! ");
INSERT INTO ztqNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ptsyeb Cornelio buy lo angly, per lëë xaa kwnabtiits, chëb xaa: —¿Pe nëël? Tsigo lëë angly chëb: —Lëë Dios biñ xtiitsoo ni lëë xaa kon kchë nii no kteedyoo par kuñoo yudar meñ nii no lyaadzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kon cho pxaal leñ kyedzy Jope tsitsyetsy Simoñ, xaa nii xñee gak meñ Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Lidzy stu Simoñ nii xkuutsy kidy nii sob lidzy kexka chu nistoo xkwës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tsiñee lëë angly nii kwnee lo Cornelio bi, lëë Cornelio kwtsyetsy chop xaa nii xkyë tsiiñ lo xaa ni lëë xaa kwtsyetsy tu xsoldad xaa nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Loxsye bitiits Cornelio kchë nii ptsyool xaa, lëë xaa pxaal xmos xaa Jope. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lëë byaani lyu, tsel xwe ngbidz lëë Pedre kwyëp kik yu par kutiitsni xaa Dios. Lëë gaa xaa nii pxaal Cornelio mer ktsiñ Jope. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kwlaañ Pedre aan kokladzy xaa nyaw xaa, per mentre lëë siily noyaklo, lëë xaa kwneexkaal ");
INSERT INTO ztqNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","nii lëë kpaa byaly, aan lëë tublë sinak ladx mant ngol sëëd sëëb nxituusy ksa tap skiñ ladx ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lo ladx ko kë kchëlo ma nii no lo kislyu, sinak ma nii sob tap niy, ni mëël, ni kchë ma nii sob xikw. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tsigo lëë Pedre biñ tsiy tu xaa nii chëb: —Pedre, kuso, beety kchë ma gue aan taw ma. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Per lëë Pedre kwëb chëb: —Chilodyo, por wi ma nii xtyaawdy kë lo ladx ke, aan lo nii mbañaa karty kawaa ma nii nonguialdy ktyaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lëë tsiy xaa go kwnee stub chëb: —Kñeedyoo nii chilody kaawoo nii xñee Dios nii schilo ktyaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tson vuelt biñ xaa tsiy xaa go, axte tsigolye lëë ladx ko byëp kpaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lëë Pedre no kyalnë dyon xa kyeñ xaa kchë nii kwnee Dios lo xaa lo mgaal go, tsi lëë xaa nii pxaal Cornelio ptsiñ chu puert xñabtiits dyon pa nak lidzy Simoñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nguiedzy kwnabtiits xaa dyon pe siko xkwës tu xaa nii lë Simoñ nii xñee meñ Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Aan como lëë Pedre bii no kyalnë nii dyon xa kyeñ xaa kchë nii chëb Dios lo xaa lo mgaal go, lëë Kyalbini Ntson chëb lo xaa: —Buy gaanoo, tson meñ xyub lii. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kuso, byety aan kunal meñ gue. Jkañdy kikoo, por naa pxal meñ gue. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tsigo lëë Pedre byety aan lëë xaa chëb lo xaa nii pxaal Cornelio: —Naa nak xaa nii xyub to. ¿Pe cos tsiiñ sëëd to? ");
INSERT INTO ztqNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Lëë xaa nii pxaal Cornelio kwëb chëb: —Xmandad Cornelio syoop noo. Tu xaa nii xñabey lo tu kyoow soldad nak xaa. Buen xaa, xtsyeb xaa Dios, ni kchë meñ Israel xle lo xaa. Lëë tu xangly Dios chëb nii no kwetsy xaa lii par tsil lidzy xaa tsiin jkëëtyag xaa kchë nii këëboo. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsigo lëë Pedre pteedy xaa nëz leñ yu, aan lëë xaa ptseñ ksa xaa kyool go. Lëë byaani lyu, lëë Pedre sinal ksa bla xaa nii xniladzy xtiits Dios nii no leñ kyedzy Jope. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lëë byaani stu lyu lëë xaa ptsiñ Cesarea. Lëë gaa Cornelio tse nche mbës ksa meñ lidzy ni xamigw xaa nii kwtsyetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tsi lëë Pedre ptsiñ chu yu, lëë Cornelio pchoo kuktsiilnëz xaa aan lëë Cornelio psoxib lo xaa sinak nii nyak xaa tu xaa non. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per lëë Pedre bliso xaa chëb: —Kusoli, por sinakakaa nakoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Aan mentre lëë xaa bii sinee, lëë Pedre kwsëëb leñ yu aan lëë xaa kon nii singootyee ndaly meñ tse nche mbës. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tsigo lëë Pedre chëb: —Nan buen do gon nii chilody ktsiil lsa tu meñ Israel meñ sit o sëëb kaa xaa leñ lidzy tu meñ sit. Per lëë Dios bluuy lon lo tu mgaal nii nody nii kpixladzyaa meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por ngo, siñee kwtsyetsy to naa, lëën syely. Blyëëdyaa. Ni tu pe chëptyaa. Lëë nina na busy, chakladzyaa kaknanaa penak kwtsyetsy to naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tsigo lëë Cornelio kwëb chëb: —Natse chako tap kpidz, misme wor re gak lëën so leñ lidzyaa nu, cholaa lay nii chak lo Dios wor wtse aan lëëtyee gaa tse go tawdyaa par kuuñ ksakaa Dios, tsiñee lëë tu xaa nii nakw tu ladx nii xpibëly byaklo lon. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aan lëë xaa në lon: Cornelio, lëë Dios gon biñ xlayoo ni lëë xaa kon kchë nii no kteedyoo par kuñoo yudar meñ nii no lyaadzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lëë nana busy kwnabey nii kaktsyetsy Simoñ, xaa nii xñee gak meñ Pedre. Lëë xaa so leñ kyedzy Jope. Lidzy stu Simoñ nii xkuutsy kidy nii sob lidzy kexka chu nistoo xkwës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Por ngo nii blyëëdyaa lëën pxal xaa nii biid kyub lii, aan buen nii sëëdoo. Lëë na chan Dios nii lëë noo nche nu par jkëëtyag noo kchë nii pxaal Dioosoo sëëdneel loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsigo lëë Pedre bislo kwnee chëb: —Na si nagon, lëën xyeñ nii nli lëdy wi Dios xsee chan meñ, ");
INSERT INTO ztqNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sink kchë meñ nii xsal xaa ni chuuñtsyey nii xñabey xaa, kchë meñ go xyo styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Lëë Dios kwnee lo meñ Israel nii lëë Jesucrist kiidni tiits nii kchoobladzy styoo meñ. Lëë Jesucrist nak xaa nii xñabey kchë lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nan do gon pe cos kok tyub xtañ meñ Israel. Galilea bislow, loxsye kwnee Juan nii no nii chobnis meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ni nan gaa to xa kwle Dios Jesús Nazaret ni xa kwsëëb Kyalbini Ntson leñ styoo xaa. Aan lëë Dios ptee kyalwnabey lo xaa parñee kuñ xaa kyalbuen ni kuuñ kyak xaa kchë meñ nii no ksaksi xaatox lo kyalkits. Kchë ngo beeñtsyey xaa porñee chop xaa Dios nak. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Lëë noo chutiits kchë nii ptyon noo beeñtsyey Jesús leñ kyedzy Jerusalén ni tyub xtañ meñ Israel. Loxsye ngo lëë meñ beety xaa, pkëë meñ xaa lo crusy. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per tse nii kwloxo tson kpidz lëë Dios beeñ kpañ xaa, aan lëë xaa byaklo loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Byaklody xaa kchë lo meñ, sink xaktyee kchëë noo siñee kwlel Dioos noo, ptyon noo xaa par kutiits noo nii nli pañ xaa. Ptyaaw noo ni ptyow noo ksa noo xaa loxsye pañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aan lëë xaa pxaal lëë noo kñee noo lo meñ nii lëë Dios pso xaa par kñabey xaa lo meñ kuty ni lo meñ mbañ. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ni kwneel gaa kchësy profet cho nak Jesús, ni kwneel gaa xaa nii kchësy meñ nii kniladzy xtiits Jesús kpily xtol. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lëë Pedre bii nonee, tsiñee lëë Kyalbini Ntson kwsëëb leñ styoo kchësy meñ nii nche jkëëtyag nii xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aan lëë meñ Israel nii xniladzy nii kwey ksa Pedre psee kon nii wi leñ styoo meñ sit blaa Dios kwsëëb Kyalbini Ntson, ");
INSERT INTO ztqNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","porñee biñ xaa nii lëë kchë meñ go xñee xaatke ntson Dios con stu clasy tiitsë. ");
INSERT INTO ztqNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tsigo lëë Pedre chëb: —¿Pe no gaa dyon cho jka nis par chobnis kchë meñ re, por misme Kyalbini Ntson nii kwsëëb leñ styoo no kwsëëb leñ styoo kchë meñ re? ");
INSERT INTO ztqNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aan lëë xaa kwnabey kwchobnis meñ go con xtiitspey Jesucrist. Loxsye ngo lëë kchë meñ go kwnab nii kwës Pedre bla kpidz. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lëë apostle ni kchë meñ nii xniladzy nii no tyub xtañ meñ Israel biñ nii lëë bla meñ sit bniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Per tsiñee lëë Pedre ptsiñ Jerusalén, lëë bla meñ Israel kwneenë Pedre, ");
INSERT INTO ztqNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","chëb xaa: —¿Penak nii kusëëboo lidzy meñ sit, ni tawnil kchë meñ go? ");
INSERT INTO ztqNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tsigo lëë Pedre bislo bitiits xa kwey xaa lidzy Cornelio, lëë xaa chëb: ");
INSERT INTO ztqNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Leñ kyedzy Jope son, aan tsiñee lëën noyutiitsni Dios, lëë tu mgaal kwtedy lon, aan lëën kon tublë ladx mant ngol nii sëëdsëëb kpaa nxituusy ksa tap skiño aan lëëw byab axte laañee son. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tsiñee lëën big kex par kuy nyëën dyon pe cos kë lo ladx ko, lëën kon kchëlo ma nii sob tap niy, kchëlo ma tox, ni kchëlo mëël, ni kchëlo ma nii sob xikw. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aan lëën biñ tsiy tu xaa nii në lon: “Pedre, kuso, beety ma gue aan taw ma.” ");
INSERT INTO ztqNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Per lëën chëp: “Chilodyo, por wi ma nii xtyaawdy kë lo ladx ke, aan lo nii mbañaa karty kawaa ma nii nonguialdy ktyaaw.” ");
INSERT INTO ztqNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tsigo lëë tsiy xaa nii sëëd kpaa në lon stub: “Kñeedyoo nii chilody kaawoo nii xñee Dios nii schilo ktyaaw.” ");
INSERT INTO ztqNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tson vuelt biñaa tsiy xaa go. Loxsye ngo lëë ladx ko byëp kpaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wor go kazh lëë tson xaa kwlañ lidzy xaa nii kwlësaa. Cesarea pchoo xaa biid kyub xaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Aan lëë Kyalbini Ntson në lon: “Kunal, jkañdy kikoo.” Wi ksa xoop xaa re kwsënal naa, ksa noo psyëëb leñ lidzy tu xaa ");
INSERT INTO ztqNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","nii bitiits loo noo xa byaklo tu angly chilidzy xaa chëb: “Pxaal meñ leñ kyedzy Jope tsitsyetsy Simoñ, xaa nii xñee gak meñ Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aan lëë Pedre kñë xa telaal ni xa telaa meñ liidzyoo lo tol.” ");
INSERT INTO ztqNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tsiñee lëën bislo xñen, lëë Kyalbini Ntson nii klootyee kwsëëb leñ styoo no kwsëëbak leñ styoo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsigo lëën psaladzy xtiits Jesús tsiñee chëb xaa: “Nli nii lëë Juan pchoobnis con nis sye, per lëë do chobnis con Kyalbini Ntson.” ");
INSERT INTO ztqNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Por ngo, deelñee wi lo meñ sit ko pteedy Dios xKyalbini Ntson, ¿cho nakaa parñee jkaan Dios? Por singo gak bneetsy xaa Kyalbini Ntson lo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tsiñee lëë meñ nii xniladzy xtiits Dios nii no Jerusalén lox biñ ngo, kwneedre xaa, sink lëë xaa ptee skizh lo Dios chëb xaa: —¡Wi meñ sit tsigo busy kteelaa Dios lo tol ni wi meñ sit jkaa kyalmbañ nii xnitylody! ");
INSERT INTO ztqNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Loxsye kuty Xteb, ndaly kyalnë nii kwtedy kchë meñ nii xniladzy xtiits Dios, aan no meñ go pxooñ ptsiñ axte Fenicia, Chipre ni Antioquía. Nonstyee lo meñ Israel kwnee meñ go cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per lëë bla xaa Chipre ni xaa Cirene nii xniladzy xtiits Dios ptsiñ leñ kyedzy Antioquía aan wi lo meñ sit kwnee xaa cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Lëë Dios kokni xaa, aan ndaly meñ go ptikche styoo lo Dios aan lëë meñ go bniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tsiñee lëëw biñ meñ nii xniladzy nii no Jerusalén, lëë xaa pxaal Bernabé kyedzy Antioquía. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tsiñee lëë Bernabé ptsiñ, ble xaa kon xaa xkyalnsaak Dios aan lëë xaa kwnab nii ksaandy meñ go xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tu xaa buen nak Bernabé. Nyoo no Kyalbini Ntson leñ styoo xaa ni nyoo nii tyub styoo xaa xniladzy xaa xtiits Dios. Aan ndaly meñ go big lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Loxsye ngo lëë Bernabé si Tarso sikyub Saulo. Aan tsi lëë xaa ptsil xaa, lëë xaa kuni xaa Antioquía. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nder tu iz kwlës xaa lo meñ Antioquía nii xniladzy xtiits Dios aan ndaly meñ beeñ kseedy xaa. Lëë meñ Antioquía klootyee kwnee lo meñ nii no xlad Jesús Cristiañ. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Leñ tse go lëë bla profet pchoo Jerusalén kwey Antioquía. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Lëë tu profet nii pcholë Agabo kusoli lady meñ nii xniladzy xtiits Dios, aan por Kyalbini Ntson lëë xaa kwnee nii lëë kpiñ kiid tyub lo kislyu, aan nli gaa lëë kpiñ go biid iz nii kwnabey Claudio. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tsigo lëë meñ Antioquía nii xniladzy xtiits Dios kwnee dyon xa kuñ xaa yudar meñ nii xniladzy nii no Judea. ");
INSERT INTO ztqNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Aan lëë xaa ptop nii pchilootyee lo xaa par kxaal xaaw lo kchë xaa kol nii xñabey lo meñ nii xniladzy xtiits Dios nii no tyub Judea. Lëë Saulo ni Bernabé kuni kchë nii ptop meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Leñ tse go lëë rey Herodes bislo psaksi bla meñ nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Lëë xaa pxaal soldad kukyeety betsy Juan nii pcholë Jacob con spad, ");
INSERT INTO ztqNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","aan como kon xaa nii byo kchë ngo styoo meñ Israel, lëë xaa kwnabey pkaa wi Pedre. Kchë ngo beeñtsyey xaa leñ tse nii chak lni nii xtyaaw kyaxtily nii xkyëdy levadur. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Loxsye pkaa Pedre, lëë Herodes kwloo xaa skiib, aan tap tiiy soldad kwënap xaa, tap kaa soldad tu tiiy. Nladzy Herodes kwii xaa Pedre loxsye te paskw parñee kñab meñ kyedzy kety Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Per nikxe nii tsiitsy kwyo Pedre skiib, tugak kwnab meñ nii nak ksa xaa nii kakni Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kyool nii kxe kwii Herodes Pedre par kñab meñ kyedzy kety Pedre. Lëë Pedre nixyesy leñ skiib nxituusy ña xaa con chop lë caden. Nix kaa tuga soldad kwi xaa, ni lëë stubla gaa soldad nche nap chu skiib, ");
INSERT INTO ztqNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","tsiñee lëë tu xangly Dios ptsiñ, aan lëë tu bini ngol kwë leñ skiib. Lëë angly pteexug kwi Pedre par kna Pedre, aan lëë angly chëb: —Sinusy kuxche. Tsigo lëë caden nii nxituu ña Pedre byak, ");
INSERT INTO ztqNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","aan lëë angly chëb: —Kokw xaboo ni pkëëniy laboo. Loxsye beeñtsyey Pedre nii kwnabey angly, lëë angly chëb: —Pix xkaxkeemoo aan tënal naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Lëë Pedre sinal xitsy angly, nandy xaa dyon pe nli nii chop xaa angly si ote nlidyo yak. Soot xaa nii lo mgaal chan xaa kchë ngo. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Per klo lo tub tiiy soldad nii nche nap kwtedy xaa. Loxsye ngo lëë xaa kwtedy lo stub tiiy soldad nii nche nap stub lugar. Aan tsiñee lëë xaa ptsiñ chu puert kiib ngol nii kë chu nëz, lëë puert ko byaly xaly aan lëë xaa pchoo. Loxsye kwsë xaa xisy wiñ, lëë angly psaan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Axte tsigolye lëë Pedre byaabini aan lëë xaa chëb: —Na si nagon, chanaa nii nli lëë Dios pxaal xangly biidlii naa ña Herodes ni biid kteelaa naa lo kchë nii kokladzy meñ Israel nyuñ xaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ngo nladzy Pedre lëë xaa si lidzy Mariy, xñaa Juan, xaa nii kwnee gak meñ Marcos. Ndaly meñ pkaal lsa siko par kutiitsni meñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tsiñee lëë xaa pseetsy chu puert nii kë nëz chu nëz, lëë tu kwnaa nii tugak xkyë tsiiñ nii pcholë Rode kukuy dyon chow. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tsiñee lëë me byuumbey tsiy Pedre, pxaldy me chu puert, sink lo kyalwle go lëë me bikche sey me leñ yu stub, sikni me tiits nii lëë Pedre so chu puert. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Per lëë meñ nii ncheno leñ yu chëb lo me: —¡Chak wetyoo! Per tugak ndip xtiits me nii nli lëë xaaw. Lëë kchë meñ go chëb: —Lëdy xaaw, buty xangly xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lëë Pedre gaa tugak no kseetsy chu puert. Aan tsiñee lëë meñ pxaly chu puert, psee meñ kon meñ nii nli lëë xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Per lëë xaa kwloo señ con ña xaa parñee kwetse meñ, aan lëë xaa bitiits xa kulii Dios xaa skiib, ni lëë xaa chëb: —Kol kutiits nrii lo Jacob ni lo kchë meñ nii xniladzy xtiits Dios. Loxsye ngo lëë xaa pchoo, lëë xaa si stub lugar. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tsiñee lëë lyu byaani, xyeñdy soldad dyon xa kuñ xaa, porñee nandy xaa pe kok Pedre. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Lëë Herodes kwnabey kok wyub Pedre, aan como ptsildy xaa xaa, lëë xaa kwtsyetsy xaa nii kwënap chu skiib aan lëë xaa kwnabey kuty xaa. Loxsye ngo lëë Herodes pchoo Judea, lëë xaa si Cesarea. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Leñ tse go lëë Herodes xlëë lo meñ Tiro ni Sidón, per lëë chop kyedzy ko kwnee dyon xa tsinee xaa lo Herodes. Tsigo lëë xaa byub mod kwnee xaa lo Blasto, tu xaa nii tugak so kex lo rey Herodes. Lëë Blasto kwnee lo Herodes parñee klëëdre xaa lo chop kyedzy ko, porñee tañ nii xñabey Herodes xchoo nii xtyaaw xtañ meñ Tiro ni meñ Sidón. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lëë Herodes kwle tu tse nii tsinee chop kyedzy ko lo xaa. Aan tsi lëë tse go kol, lëë Herodes kokw xab lni ni lëë xaa kwsob lo xyakxily xaa leñ yulyey aan lëë xaa bislo kwnee xaa lo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tsi lëë meñ go biñ tsiy xaa, lëë meñ go bislo kwchuptsyë xñee: —¡Lëdre xaa lo kislyu ngue nonee, sink tu dioslew! ");
INSERT INTO ztqNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wor go kazh lëë tu xangly Dios beeñ ksaknë Herodes aan lëë msyog beety xaa porñee beeñ ksakty xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lëë meñ nii pkëëtyag ni bniladzy xtiits Dios ptyalyre. ");
INSERT INTO ztqNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tsiñee lëë Bernabé ni Saulo byal xtsiiñ, lëë xaa bi Jerusalén, aan lëë xaa biy Juan, xaa nii xñee gak meñ Marcos. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kwyo profet ni maestre lady meñ Antioquía nii bniladzy xtiits Dios. Lëë lë xaa nrii: Bernabé, Simoñ (Yeesy kwnee meñ lo Simoñ), Lucio xaa Cirene, Manaén (xaa nii kwroob tusyke chop Herodes, xaa nii kwnabey Galilea) ni Saulo. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lëë tu tse, lëë meñ ncheyutiitsni Dios ni tawdy meñ go par kuuñ ksak meñ go Dios. Lëë Kyalbini Ntson chëb: —Kol kwixaa Bernabé ni Saulo par kuuñtsyey xaa tu tsiiñ nii ktedyaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Loxsye bitiitsni xaa Dios ni tawdy xaa par kuuñ ksak xaa Dios, lëë xaa pxob ña xaa kik Saulo ni Bernabé aan lëë xaa psonëz xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Lëë Kyalbini Ntson pxaal Bernabé ni Saulo kyedzy nii lë Seleucia aan siko lëë xaa kwyo barkw par tsi xaa Chipre. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tsiñee lëë xaa ptsiñ kyedzy nii lë Salamina nii nche Chipre, lëë xaa bislo xluuy xaa xtiits Dios leñ xiktoo meñ Israel. Wi Juan kunal kuñ xaa yudar. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aan lëë xaa kwte tyub lo kislyu wiñ go ptsiñ xaa axte Pafos. Siko lëë xaa kuktsiil tu xaa Israel nii pcholë Barjesús nii nak bruj. Tu wnee xuuy nak xaa, xñee xaa nii xtiits Dios xñee xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Lëë bruj ko kok xamigw xtisy Chipre nii pcholë Sergio Paulo. Tu xaa nyaani kok xtisy ko, lëë xaa kwnabey koktsyetsy Bernabé ni Saulo, parñee jkëëtyag xaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Per lëë bruj Barjesús, xaa nii pcholë gak Elimas, kokladzy nsyonlë parñee nilasty xtisy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tsigo lëë Saulo, xaa nii pcholë gak Pable, buy lo bruj ko, nyoo nii no Kyalbini Ntson leñ styoo Saulo, ");
INSERT INTO ztqNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aan lëë xaa chëb: —¡Sinak xaatox nakoo! ¡Ngo nii xñee xuuyoo ni ngo nii xyody cos buen styool! ¿Penak nii tugak sonlël lo xnëz tubli Dios? ");
INSERT INTO ztqNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lëë na lëë Dios ksaksi lii. Lëël kyaan ciegw aan ndaly kpidz kchilody kanoo lo xbini ngbidz. Wor go kazh lëë bruj ko byaan ciegw, aan lëë xaa byub dyon cho señ ña xaa porñee chandy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tsiñee lëë xtisy kon kchë ngo, lëë xaa bniladzy xtiits Dios, aan psee xaa biñ xaa xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Lëë Pable byo barkw chu nis Pafos ksa xcombañer par tsi xaa Perge, tu kyedzy nii nche nëz tañ nii lë Panfilia. Per lëë Juan pchoxso lo xaa, aan lëë Juan sey Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Loxsye kwte xaa Perge, lëë xaa ptsiñ Antioquía, tu kyedzy nii nche nëz tañ nii lë Pisidia. Lëë tsi lëë tse nii xiladzy meñ Israel lo tsiiñ kol, lëë xaa kwsëëb ktoo aan lëë xaa kwsob. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Loxsye pkab libre ley ni libre nii pkëë profet, lëë xaa nii xñabey leñ ktoo chëb lo xaa: —Beetsy, deelñee chakladzy to kñee do choplan xtiits to lo meñ, schilo kñee dow nina. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsigo lëë Pable kuso, aan lëë xaa kwloo señ con ña xaa parñee kwetse meñ, chëb xaa: —Kol kono, meñ Israel, ni kchësy to siñee xtsyeb to Dios: ");
INSERT INTO ztqNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lëë xDios meñ Israel kwle pxusykoltoo no ni lëë Dios beeñ ktyaly xaa axte kok xaa tu kyedzy ngol worñee bii ncheno xaa Egipto. Siko kok xaa meñ sit. Loxsye ngo por xkyalwnabey Dios lëë xaa pchoo tañ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Choow iz pxekw Dios lo pxusykoltoo no tañ pidzy nii kwtedy xaa, ");
INSERT INTO ztqNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ni lëë xaa bnitylo kadzy kyedzy ngol nii nche nëz tañ nii lë Canaán par ktee xaa xilyu meñ go lo pxusykoltoo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tap kyoow grol iz kwë pxusykoltoo no singo. Loxsye ngo lëë Dios pso juesy kwnabey lo pxusykoltoo no. Lëë profet Samuel kok lultime juesy. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","’Loxsye ngo lëë pxusykoltoo no kwnab tu rey lo profet Samuel, aan lëë Dios pso Saúl xiñ Cis nii sëëd lo xtiiy Benjamín kok rey. Choow iz kwnabey Saúl lo pxusykoltoo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lëë Dios kwlii Saúl, aan lëë xaa pso David kok David rey, chëb xaa: “Lëë David xiñ Isaí nak tu xaa nii xyo styoon ni suuñtsyey xaa kchë nii chakladzyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Lo xtiiy David sëëd Jesús, xaa nii pxaal Dios biid kteelaa meñ Israel, sinak nii psaanle Dios tiits. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Klo Juan biid lo xaa. Lëë Juan bluuy xtiits Dios kchë lo meñ Israel, xñee Juan nii no nii ktikche meñ styoo lo Dios ni chobnis meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aan tsiñee lëë xtse Juan mer ksa, lëë Juan chëb: “Lëdy naa nak xaa nii nladzy to nii nakaa. Per skere sëëd tu xaa nii mastre non lon, por naa ni parñee kliityaa lab xaa xkiiñdyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Kol kono gaanoo, beetsy, kchësy to siñee sëëd to lo xtiiy Abraham ni kchësy to siñee xtsyeb to Dios. Lëë Dios pxaal tiits re lo no parñee kñë xaa xa telaa no. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Koknandy meñ nii no Jerusalén ni koknandy xaa xñabey cho kok Jesús. Ni byeñdy xaa kchë kitsy nii pkëë profet nii xkab leñ ktoo ksatyee tse nii xiladzy meñ lo tsiiñ. Por ngo lëë xaa beeñ cumplir nii pkëë profet tsi lëë xaa beety Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aan nikxe gaa ni tu pe beeñtsyeydy Jesús par kety xaa, lëë meñ kwnab lo Pilat kuty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tsiñee lëë Jesús lox kwtedy kchë nii kë leñ xkitsy Dios nii no tedy xaa, lëë meñ blity xaa lo crusy aan lëë meñ pkeetsy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per lëë Dios beeñ kpañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aan ndaly kpidz byaklo Jesús lo kchë meñ nii kwënsë ksa xaa tyub Galilea ni Jerusalén, aan lëë kchë meñ go chutiitso lo meñ nina. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Por ngo nii lëë noo xñee tiits ntson nii psaan Dios lo pxusykoltoo no lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lëë noo syoopnii xtiits Dios lo do. Kchë nii byaan Dios tiits ksa pxusykoltoo no, lëëw beeñ xaa cumplir lo no nii nak no xiñ pxusykoltoo no. Lëë xaa beeñ kpañ Jesús sinak nii kë leñ salmo dos nii xñee sinrii: “Lii nak xiñaa. Naa bnetsy kyalmbañ lool natse.” ");
INSERT INTO ztqNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kwneel Dios nii lëë xaa kuuñ kpañ Jesús parñee kpikchedre kety Jesús. Leñ kitsy nii kë xtiits xaa chëb xaa sinrii: “Lëën kne kchë kyalnsaak nii chëpaa lo David lool.” ");
INSERT INTO ztqNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Por ngo leñ kitsyak nii kë salmos xñee: “Klaadyoo kyodz xcuerp xaa nii xsoob xtiitsoo.” ");
INSERT INTO ztqNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ni nan gaa to xa beeñtsyey David kchë nii kwnabey Dios xtiemp xaa. Loxsye ngo lëë xaa kuty sinak nii kuty kchë pxusykoltoo xaa aan lëë xcuerp xaa byodz. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per byosty xcuerp Jesús, xaa nii beeñ kpañ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Por ngo, beetsy, lëë noo syoopnee lo do nii lëë Jesús nak xaa nii xteelaa meñ lo tol. Por kchë tol nii pchilody xley Moisés ntsily, lëë Jesús xtsilyo, deelñee kniladzy to xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kol kap cuent, toontlaa ktsyool do nii pkëë profet leñ xkitsy Dios tsiñee chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kol kono gaanoo kchësy to siñee xidzyni do xtiits Dios, kol ktsyeb aan kol kety, porque naa nii nakaa Dios, lëën kuuñtsyey tu cos nii iip knilasty to, nikxe cho kutiitso lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tsiñee lëë Pable ni Bernabé pchoo ktoo, lëë meñ chëb nii kpikche xaa stub par kñeere xaa kchë ngo stu tse nii xiladzy meñ lo tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ndaly meñ Israel ni ndaly meñ sit nii kwsëëb xlad meñ Israel kunal Pable ni Bernabé tsi lëë ktoo kwlox. Aan lëë Pable ni Bernabé kwnab nii ksaandy kchë meñ go xtiitsli Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lëë ptsiilo xmal, tse nii xiladzy meñ Israel lo tsiiñ, ndaly meñ kyedzy ptyop par jkëëtyag meñ xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per tsiñee lëë meñ Israel kon nii singootyee ndaly meñ ptyop, lëë xaa blëë aan lëë xaa kwlootsyetsy Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Per ptsyebty Pable ni Bernabé. Lëë xaa kwnee, chëb xaa: —No nii klo lo do kluuy noo xtiits Dios nii nak to meñ Israel, per como xsaldy tow, ni soot to nii chigaldy jkaa do tu kyalmbañ nii nitylody, lëë noo kyoneew lo meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Por singo kwnabey Dios lëë noo, në xaa: Lëën pso lii sinak tu bini, parñee ksaaniil kchë lo meñ nii nche lo kislyu, ni lëën pso lii parñee tsineel xa telaa meñ nii nche tyub lo kislyu lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tsiñee lëë meñ sit biñ ngo, ble xaa, xñee xaa xaatke ntson Dios, aan lëë xaa nii nonguial le jkaa kyalmbañ nii nitylody bniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Por ngo ndaly meñ pkëëtyag xtiits Dios tyub tañ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Per lëë meñ Israel kwlootiits bla kwnaa rikw nii tugak chi ktoo ni bla xaa non nii no kyedzy ko parñee ktilyni xaa Pable ni Bernabé tsiin kchoo xaa tañ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsigo lëë Pable ni Bernabé kwtsib yuti nii xña niy xaa parñee kyeñ meñ nii no xtol meñ, aan loxsye ngo lëë xaa si stu kyedzy nii lë Iconio. ");
INSERT INTO ztqNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Per pe pseedy kchë meñ nii bniladzy xtiits Dios. Tugak ble meñ go ni nyoo gaa nii no Kyalbini Ntson leñ styoo kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tsiñee lëë Pable ni Bernabé ptsiñ leñ kyedzy Iconio lëë xaa kwsëëb leñ xiktoo meñ Israel chop xaa, aan lëë xaa bislo kwnee xaa xtiits Dios, aan ndaly meñ Israel ni meñ sit bniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per lëë meñ Israel nii koklasty niladzy xtiits Dios pkiily meñ sit parñee ktilyni xaa kchë meñ nii bniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Por ngo mastre xtse kwlës apostle leñ kyedzy ko. Nder confians bluuy xaa xtiits Dios, ni lëë Dios kaa bluuy lo meñ nii nli xtiits Dios xñee xaa, porñee ptee Dios tiits beeñtsyey xaa kyalntson. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Per lëë meñ kyedzy ko kok chop tiiy. Grol meñ pchoo xfavor meñ Israel, lëë stu grol meñ pchoo xfavor apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tsigo lëë meñ Israel ni meñ sit bitiits ksa xaa xñabey parñee ksaksi xaa ni kuty xaa apostle lo kyo. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Per tsiñee lëë Pable ni Bernabé byeño, lëë xaa pxooñ, lëë xaa si nëz Listra ni Derbe. Chop kyedzy ko ngab Licaonia. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wi tañ go bluuy xaa xtiits Dios nii xñee cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Leñ kyedzy Listra kwyo tu xaa nii chilody së. Destye nii koly xaa ndaandy niy xaa, aan lo nii mbañ xaa karty së xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Lëë xaa sob jkëëtyag nii xñee Pable aan tsi lëë Pable buy lo xaa byeñ Pable nii xniladzy xaa nii schilo kuuñ kyak Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tsigo nguiedzy kwnee Pable, chëb Pable lo xaa: —Kuso, beeñ tubli niyoo. Aan lëë xaa nii xsyëdy ko kwyasklaa, lëë xaa kwsoli aan lëë xaa bislo kwsë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tsiñee lëë meñ kon nii beeñtsyey Pable, lëë meñ bislo chuptsyë xñee con tiitsë Licaonia: —¡Lëë dios byety kpaa sëëd kan lëë no! ¡Nyaa xaa si nyaa meñ! ");
INSERT INTO ztqNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Xñee meñ nii lëë Bernabé nak dios nii lë Zeus aan lëë Pable kwnee meñ dios Hermes, porñee lëë Pable nak xaa nii xñee. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ni lëë pxosy nii xkyënap xiktoo dios Zeus nii sob chu kyedzy biidni yosy ni tukyoo chu puert ktoo par kokon xaa ma lo Pable ni lo Bernabé kchë xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Per tsiñee lëë Bernabé ni Pable byeñ kchë nii noyuuñtsyey meñ, lëë xaa pchos xab xaa parñee kyeñ meñ nii xyody nii noyuuñtsyey meñ styoo xaa, aan lëë xaa kwsëëb lady meñ xñee xaa: ");
INSERT INTO ztqNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Kol kono! ¿Penak nii chuuñtsyey do singue? Sinakak to nak noo, lëdy dioos noo. Lëë noo syoop kluuy xtiits Dios nii xñee cho nak Jesús lo do. Kol ksaan kchë ximdyo do par kniladzy to Dios mbañ nii psaa kpaa ni kislyu ni nistoo ni kchësy cos nii no lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kwyo tu tiemp nii lëë Dios blaa beeñtsyey meñ nii kwlaañtyee styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Per psaandy xaa meñ, sink tugak kokni xaa meñ, aan por kchë xkyalnsaak xaa lëë xaa bluuy nii buen xaa. Por lëë xaa xaal kyo parñee kak xkwaa do ni lëë xaa xnee nii kaw do parñee kle do. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aan nikxe chëb xaa kchë ngo, neñ beeñ xaa gan nii beejty meñ yosy par kokon meñ ma lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lëëtyee gaa leñ tse go lëë bla xaa Israel nii no Antioquía ni Iconio ptsiñ, aan lëë xaa pkiily meñ Listra par kteekyo xaa Pable. Lëë xaa pteekyo Pable ni lëë xaa kwtopxax Pable, kukchon xaa Pable tublad chu kyedzy, nladzy xaa nii kuty Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Per tsiñee lëë meñ nii xniladzy xtiits Dios ptyop kyako Pable, lëë xaa kuxche aan lëë xaa byo leñ kyedzy stub. Lëë byaani lyu, lëë xaa si kyedzy nii lë Derbe chop xaa Bernabé. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Lëë xaa bluuy xtiits Dios nii xñee cho nak Jesús lo meñ Derbe, aan ndaly meñ kyedzy ko bniladzy. Loxsye ngo lëë xaa bikche sey xaa nëz Listra ni Iconio ni Antioquía stub. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kchë kyedzy nii ptedy xaa pchoobladzy xaa styoo kchë meñ nii xniladzy xtiits Dios, xñee xaa nii no nii tugak kniladzy meñ, ni xñee xaa nii parñee syëëb no laañee xñabey Dios no nii tyeedy no ndaly lo kyalnë. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ksa kyedzy nii ptedy xaa pso xaa xaa kol nii kñabey lo meñ nii xniladzy xtiits Dios. Aan loxsye bitiitsni xaa Dios ni tawdy xaa par kuuñ ksak xaa Dios, lëë xaa kwnab nii kakni Dios ksa xaa kol nii pso xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kwte xaa nëz Pisidia par ktsiñ xaa xtañ meñ Panfilia. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Loxsye bluuy xaa xtiits Dios nii xñee cho nak Jesús leñ kyedzy Perge, lëë xaa ptsiñ Atalia. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Siko lëë xaa byo barkw, lëë xaa sey kyedzy Antioquía, sikni xaa tiits lo meñ nii xniladzy nii lëë xaa byal tsiiñ nii pxaal Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tsiñee lëë xaa ptsiñ Antioquía, lëë xaa ptop kchë meñ nii xniladzy xtiits Dios aan lëë xaa bitiits kchë cos nii beeñtsyey Dios, ni lëë xaa bitiits xa ptee Dios tiits nii wi meñ sit kniladzy xtiits Dios nii xñee cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Xtse kwlës Pable ni Bernabé lo meñ nii xniladzy xtiits Dios nii no leñ kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lëëtyee gaa leñ tse go, lëë bla xaa Judea ptsiñ Antioquía, aan lëë xaa bislo xñee xaa lo meñ nii xniladzyle xtiits Dios: Chilody telaa do deelñee tsobeydy to sinak nii xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Por ngo lëë Pable ni Bernabé ptilytiitsni xaa go. Nroob kok xtily xaa, lëë byalo lëë meñ nii xniladzy xtiits Dios pxaal Pable ni Bernabé ni stubla xaa nii xniladzy Jerusalén par tsinabtiits xaa lo apostle ni lo kchë xaa kol dyon xa kak tily go. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Lëë meñ Antioquía nii xniladzy xtiits Dios kwloonëz xaa, aan tsi lëë xaa kwtedy xtañ meñ Fenicia ni Samaria, lëë xaa bitiits nii wi meñ sit bniladzy xtiits Dios. Aan kchësy meñ nii biñ ngo ble. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tsiñee lëë Pable ni Bernabé ptsiñ Jerusalén, lëë meñ nii xniladzy xtiits Dios, ni apostle, ni kchësy xaa kol kuktsiil nëz xaa, aan lëë xaa bitiits kchë nii beeñtsyey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per lëë bla xaa fariseo nii xniladzy xtiits Dios chëb: —No nii tsobey kchë meñ sit nii xniladzy xtiits Dios, ni no nii kuuñtsyey meñ sit kchë nii xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tsigo lëë apostle ni lëë xaa kol ptyop par kutiits xaa dyon xa kak tily go. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Loxsye kok xtse nche ktilytiits xaa, lëë Pedre kuso chëb: —Beetsy, nan do gon nii penaadle lëë Dios kwle naa lady to par kluyaa xtiits xaa nii xñee cho nak Jesús lo meñ sit parñee wi kchë meñ go kniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Lëë Dios nii nan kchë nii xsya styoo no, bluuy nii wi meñ sit schilo telaa lo xtol. Lëë xaa pteedy xKyalbini Ntson xaa lo meñ sit sinak nii bneetsyak xaa Kyalbini Ntson lo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Lëdy wi Dios xkwe meñ. Tugak nak no lo Dios, ni wi gaa xtol kchë meñ sit ptsily xaa porñee bniladzy meñ sit xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Lëë na, lëë do noyuuñ klëë Dios, porñee chakladzy to jkoy do meñ sit tu yow ni nii pxusykoltoo no ni lëë no chilody kooy. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Buendy gon no kik to, por nan buen do nii por xkyalnsaak Jesús xtyelaa no lo tol. Singo gak kaa xtyelaa kchë meñ sit nii xniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tsigo tsesy kwche xaa go, mentre lëë Pable ni Bernabé bitiits kchë kyalntson nii blaa Dios beeñtsyey xaa lady meñ sit laañee kwey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tsiñee lëë Pable ni Bernabé lox kwnee, lëë Jacob chëb: —Beetsy, kol kon choplan xtitsaa gaanoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Lëë Pedre gon bitiits lo no nii wi meñ sit xkëstyoo Dios. Por ngo, wi meñ sit kwle xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ni leñ xkitsy kaa Dios pkëë profet sinrii: ");
INSERT INTO ztqNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Sitsiñ tse nii lëën ktop kchë meñ Israel nii ngab lo xtiiy David stub, ni sitsiñ tse nii lëën kwek meñ go laañee kwche meñ go klo, ");
INSERT INTO ztqNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","parñee kchësy meñ ktikche styoo lon, ni parñee kchësy meñ sit nii kwlen kpig lon. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Lëë Dios kwnee kchë tiits re, destye tiemp pxaal xaa xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Sootaa gon nii nonguialdy jkaal no meñ sit nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lëëw comñee kxaal no tublë kitsy lo meñ sit parñee kawtre meñ sit kchë cos nii chokon lo mdyo, ni tsonidy meñ sit stu meñ deel no tsiil meñ sit, ni kawdy meñ sit ma nii xiyañ, ni kawdy meñ sit cheñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ni ksatyee gaa tse nii xiladzy meñ Israel lo tsiiñ xkab xley Moisés leñ kchë ktoo destye tyub tiemp. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tsigo lëë apostle, ni lëë xaa kol ni lëë kchë meñ nii xniladzy xtiits Dios byaan tiits nii lëë xaa kwe bla xaa nii no lady xaa tsinal Pable ni Bernabé Antioquía. Lëë xaa pso Judas, xaa nii pcholë gak Barsabás, ni lëë xaa pso Silas. Xaa non nak chop xaa go lady meñ nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Loxsye ngo lëë xaa pkëë tublë kitsy nii koy xaa nii tsi. Sinrii xñee leñ kitsy ko: “Lëë noo nak apostle. Lëë noo xkëëptyux lëë do nii nak to meñ sit ksa noo xaa kol. Kchë do siñee ncheno do Antioquía, ni Siria ni Cilicia xkëëptyuux noo lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ptsyon noo nii lëë bla xaa nii pchoo nu biid kteenë lëë do ni biid jkan kik to. Lëdy lëë noo pxaal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Por ngo lëë noo byaantiits kchëë noo, aan lëë noo pso bla xaa nii kiid tedy lo do ksa xaa betsy no Bernabé ni Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ndalyle vuelt notelaa Bernabé ni Pable kety xaa porñee xsoob xaa xtiits Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Lëë noo xaal Judas ni Silas tsiin yuub xaa kñë lo do xa nak kchë cos nii kë leñ kitsy nii xaal noo lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Porque buen kwxaak Kyalbini Ntson ni buen kwxaak noo, nii ktsiibtre noo pe stu cos lady to, xaktyee nii precisy sye ");
INSERT INTO ztqNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nii kawdy to xpëël kchë ma nii chokon lo mdyo, ni kawdy to cheñ, ni kawdy to xpëël ma nii xiyañ, ni tsonidy to stu meñ deelñee no tsiil do. Deelñee kuuñtsyeydy to kchë cos re, buen tsi do. Kakni Dios to dyon.” ");
INSERT INTO ztqNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Loxsye kwloonëz apostle xaa, lëë xaa sinal Bernabé ni Saulo Antioquía. Tsiñee ptsiñ xaa, lëë xaa ptop kchë meñ nii xniladzy xtiits Dios aan lëë xaa ptee kitsy nii sinoy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Aan tsiñee lëë kitsy ko lox pkab lo meñ nii xniladzy xtiits Dios, kchë meñ go ble porñee pchoobladzy tiits ko styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Aan como wi Judas ni Silas xñee tiits nii xaal Dios, lëë xaa pchoobladzy kchë styoo meñ nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Lëë kwloxo bla kpidz ngui psonëz meñ nii xniladzy xtiits Dios xaa parñee kyey xaa lo meñ nii pxaal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Per lëë Pable ni Bernabé byaan Antioquía aan lëë xaa bluuy xtiits Dios nii xñee cho nak Jesús ksa xaa stubla meñ nii xniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lëë kok xtsew, lëë Pable chëb lo Bernabé: —Kol tsoo kchë kyedzy laañee bluuy no xtiits Dios parñee tyon no dyon xa no kchë meñ nii bniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Lëë Bernabé kokladzy nii wi Juan, xaa nii xñee gak meñ Marcos nyinal. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Per kwnëdy Pable porñee nche gak Pable ni Bernabé leñ kyedzy Panfilia, lëë xaa bikche, kunaldy xaa axte nyal tsiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lëë xaa ptilytiits chop xaa, lëë byalo lëë xaa blë lsa. Lëë Bernabé kwyo tu barkw nii si nëz Chipre chop Marcos. ");
INSERT INTO ztqNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Lëë Pable gaa kwle Silas. Loxsye kwnab meñ nii xniladzy xtiits Dios por lëë xaa lo Dios, lëë xaa pchoo, ");
INSERT INTO ztqNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","aan lëë xaa kwtedy nëz Siria ni nëz Cilicia xchoobladzy xaa styoo kchë meñ nii xniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Lëë Pable ni Silas ptsiñ kyedzy nii lë Derbe. Loxsye ngo lëë xaa ptsiñ stu kyedzy nii lë Listra. Siko lëë xaa kuktsiil tu xaa nii xniladzy xtiits Dios nii lë Timoteo. Xiñ tu kwnaa Israel nii xniladzy nak xaa, per xaa griego nak pxosy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kchësy meñ nii xniladzy xtiits Dios nii no nëz Listra ni Iconio kwnee nii buen Timoteo. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Por ngo lëë Pable kokladzy nii wi Timoteo tsinal, aan parñee kody xaa falt lo kchë meñ Israel nii no tañ go, lëë xaa kwlobey Timoteo. Por kchë meñ go nan nii xaa griego nak pxosy Timoteo. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aan kchë kyedzy nii kwtedy xaa, lëë xaa kwnee kchë nii xñabey apostle ni xaa kol nii ncheno Jerusalén nii no kuuñtsyey meñ nii xniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Singo mod ni tu meñ nii xniladzy pchosody styoo, sink tse con tse lëë meñ nii xniladzy ptyalyre. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Blaady Kyalbini Ntson nyee xaa xtiits Dios xtañ meñ Asia. Por ngo lëë xaa kwte nëz xtañ meñ Frigia ni Galacia, ");
INSERT INTO ztqNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","aan lëë xaa ptsiñ axte laañee chislo xtañ meñ Misia. Siko lëë xaa kokladzy nyi xaa nëz Bitinia, per blaady xKyalbini Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Por ngo lëë xaa koñee kwtedy Misia, lëë xaa ptsiñ Troas. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Siko lëë Pable kon tu xaa Macedonia lo mgaal nii soli xñee: “Beeñ favor kwte Macedonia par kuñoo lëë noo yudar.” ");
INSERT INTO ztqNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Siikñee lëë Pable lox kon xaa go lo mgaal, lëë noo pxixkwaa par kyo noo Macedonia, porñee byeeñ noo nii lëë Dios xkwetsy lëë noo parñee kluuy noo xtiits xaa nii xñee cho nak Jesús siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Lëë noo ptsyo barkw Troas, aan lëë noo syo tubli lo kislyu wiñ nii lë Samotracia. Lëë byaani lyu lëë noo ptsiñ kyedzy nii lë Neápolis. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Siko pchoo noo, lëë noo syo Filipos. Lëë meñ Roma xñabey kyedzy ko. Tu kyedzy non nii ngab Macedonia nak Filipos. Ndaly kpidz blyëës noo kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lëë tsi lëë tse nii xiladzy meñ Israel lo tsiiñ kol, lëë noo pchoo leñ kyedzy, lëë noo syo tu chu kiigwpee laañee chikutiitsni meñ Israel Dios. Lëë noo psyoob siko, aan lëë noo bitiitsni kchë kwnaa nii ptyop. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lidia lë tu kwnaa nii pkëëtyag nii kwnee Pable. Tiatira lë xkyedzy me aan nonsyke ladx non xto me. Lëë Dios beeñ nii bniladzy me nii kwnee Pable porñee xtsyeb me Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lëë me kwchobnis kchë meñ lidzy me. Loxsye ngo lëë me në loo noo: —Nan do gon nii xniladzyaa Dios, na kol të kwës to lidzyaa. Aan lëë me beeñ gan, blyëës no lidzy me. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lëë tu vuelt, lëë noo syo laañee chutiitsni meñ Israel Dios, tsi lëë noo ptsiil tu kwnaa nii no tu kyalbini mal nii chuñ kyalnsiñ leñ styoo. Nroob tumi xtsiñaa me par xpixwan me porñee chuñ me kyalnsiñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Lëë me pchoonal lëë noo, chuptsyë me xñee me: —Xtsiiñ Dios nii sob kpaa chuuñtsyey meñ gue, ni lëë meñ gue xluuy xa telaa do lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ndaly kpidz kwë me singo, axte nii lëë me lox beeñ kyeedy Pable. Tsigo lëë xaa bikche aan lëë xaa chëb lo kyalbini mal nii no leñ styoo me: —Con xtiitspey Jesucrist xñen lool nii kchool leñ styoo kwnaa gue. Aan wor go kazh lëë kyalbini mal go pchoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Per tsiñee lëë xpixwan kwnaa go byeñ nii chilodre ktsiñaa me tumi par lëë xaa, lëë xaa kwnaasy Pable ni Silas aan lëë xaa kukso xaa lo xaa xñabey chu yulyey. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Lëë xaa ptsiñni Pable ni Silas lo xtisy aan lëë xaa chëb: —Lëë xaa Israel re noyuuñ chop kik meñ xkyedzy no, ");
INSERT INTO ztqNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ni lëë xaa re no kluuy cos nii nonguialdy kuuñtsyeey no, porñee nak no xaa Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tsigo lëë meñ blëë. Por ngo lëë xtisy kwnabey pchoo xab Pable ni xab Silas aan lëë soldad ptee xcheñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Loxsye ptee xaa xcheñ xaa, lëë xaa kwloo xaa skiib, aan lëë xaa chëb lo xaa nii xkyënap skiib nii buen buen kyënap xaa Pable ni Silas. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tsiñee lëë xaa nii xkyënap skiib biñ ngo, lëë xaa kulo xaa axte xan skiib ni lëë xaa pxituu niy xaa lady chop lë yag. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Per lëë koko wrol kyool, lëë Pable ni Silas noyutiitsni Dios, ni lëë xaa noyool lo Dios, ni lëë stubla gaa xaa nii no skiib nojkëëtyag, ");
INSERT INTO ztqNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tsiñee kolpsye lëë tu xu bni aan lëëw beeñ kxisy kchë xcimient skiib. Aan wor go kazh lëë kchë puert skiib byaly, ni lëë caden nii nxituu kchë meñ nii no skiib byak. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tsi lëë xaa nii xkyënap skiib bna, kon xaa nii lëë kchë puert sinyaly. Lëë xaa kwlii xispad xaa par kuty xaly xaa xaa, porñee nladzy xaa nii kchë meñ nii no skiib pxooñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Per lëë Pable kwchuptsyë chëb: —Ksaksidyoo lii, por kchësy noo ncheno nu. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tsigo lëë xaa nii xkyënap skiib kwnab bini, aan lëë xaa kwsëëb wxooñ leñ skiib. Xisy xaa, lëë xaa psoxib lo Pable ni lo Silas. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Loxsye kwlii xaa Pable ni Silas skiib, lëë xaa kwnabtiits, chëb xaa: —Kol në dyon pe cos kuuñtsyeyaa parñee telaan lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Lëë Pable ni Silas kwëb chëb: —Bniladzy xtiits Jesucrist tyub styool aan lëël telaa lo tol kchëël meñ liidzyoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lëë Pable ni Silas bluuy xtiits Dios nii xñee cho nak Jesús lo xaa ni lo kchë meñ nii ncheno lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Aan wor kyool go, lëë xaa nii xkyënap skiib kwtiib lady Pable ni lady Silas laañee bnek ni lëë xaa kwchobnis kchë meñ lidzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Loxsye ngo lëë xaa kuni Pable ni Silas lidzy xaa, aan lëë xaa ptee nii taw xaa, ni lëë xaa ble porñee kchë meñ lidzy xaa bniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lëë byaani lyu, lëë xtisy pxaal soldad lo xaa nii xkyënap skiib chëb: Blaa xaa nii kwyo skiib neeg. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tsigo lëë xaa nii xkyënap skiib chëb lo Pable: —Lëë xtisy pxaal tiits nii klaan lëë do. Lëë na, schilo kchoo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per lëë Pable chëb lo soldad: —Ni byeñdy xixtisy to pe cos nak xfaalt noo, per lëë xaa kwtiñ lëë noo xña lo meñ kyedzy ni lëë xaa kwloo lëë noo skiib. Nandy xaa nii wi noo ngab Roma. ¿Lëë nana chakladzy xaa klaa tsilaan xaa lëë noo? Yuub xaawo kiidlii lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Lëë soldad kuknitiits lo xtisy, aan tsi lëë xtisy biñ nii Roma ngab Pable ni Silas, lëë xtisy ptsyeb. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Lëë xtisy kuknab perdón lo Pable ni lo Silas, ni lëë xaa kwlii xaa skiib chëb xaa: —Kol kuñ favor, kol kchoo kyedzy re. ");
INSERT INTO ztqNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Siikñee lëë Pable ni Silas pchoo skiib, lëë xaa kwey tubli lidzy Lidia, aan loxsye pchoobladzy xaa styoo meñ nii xniladzy xtiits Dios, lëë xaa bi. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lo xiviaj Pable ni Silas, lëë xaa kwte nëz Anfípolis ni Apolonia. Loxsye ngo lëë xaa ptsiñ leñ kyedzy Tesalónica laañee sob tu xiktoo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Psaandy Pable xcostumbre, lëë xaa kwey xiktoo meñ Israel, aan tson sabt nii xiladzy meñ lo tsiiñ kukutiitsni xaa meñ Israel kitsy nii kë xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Lëë xaa bluuy laañee xñee nii no kety xaa nii pxaal Dios, ni no nii kpañ xaa, ni chëb Pable: —Lëë Jesús nii xsetyaa lo do nak xaa nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tsigo lëë bla meñ Israel ni ndaly meñ griego ni kwnaa non kok ksa Pable ni Silas. Kchë meñ go bniladzy nii kwnee Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Per lëë meñ Israel nii bnilasty blëë aan lëë xaa ptop bla xaa yox nii kënsë pal nëz parñee kuuñ jkyey xaa kik meñ kyedzy tsiin klëë meñ kyedzy. Ni lëë xaa kusëëb xoo lidzy Jasón par kñaasy xaa Pable ni Silas tsiin jko xaa xaa ña meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Aan como ptsildy xaa Pable ni Silas siko, lëë xaa biy Jasón ni bla meñ nii xniladzy xtiits Dios. Lëë xaa kukso xaa lo xtisy nii xñabey leñ kyedzy ko, aan lëë xaa chëb: —Lëë xaa nii noyuuñ jkyey kik kchë meñ nii nche tyub lo kislyu kwlañche nu, ");
INSERT INTO ztqNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aan lëë Jasón ptee lidzy kwlës xaa. Xsaldy xaa nii xñabey xtisy Roma, sink xñee xaa nii no stu rey nii lë Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tsiñee lëë meñ kyedzy ni meñ xtisy biñ ngo, lëë xaa kok ntseeb. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Per lëë Jasón ni lëë xaa nii ksa xaa kwyo skiib kwtiix multy aan lëë xtisy blaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tsiñee lëë lyu pkyey, lëë meñ nii xniladzy xtiits Dios pxaal Pable ni Silas nëz kyedzy nii lë Berea. Tsiñee lëë xaa ptsiñ kyedzy ko, lëë xaa kwey leñ xiktoo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ndoladzy kchë meñ Israel nii no kyedzy ko. Nakty xaa sinak meñ Israel nii no leñ kyedzy Tesalónica, por mbëë pkëëtyag xaa xtiits Dios nii bluuy Pable ni ksatyee gaa tse xyub xaa leñ kitsy nii kë xtiits Dios par kaknan xaa dyon pe nli kchë nii xñee Pable lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Singo mod ndaly meñ Israel bniladzy xtiits Dios, ni ndaly gaa meñ griego bniladzy. Nikxe kwnaa nono, nikxe gaa xaapkiyo, kchë nak xaa bniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Per tsiñee lëë meñ Israel nii no Tesalónica biñ nii wi leñ kyedzy Berea no kluuy Pable xtiits Dios, lëë xaa kwey siko par jkiily xaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Per blyëëdy lëë meñ nii xniladzy xtiits Dios pxaal Pable nëz chu nis, mentre lëë Timoteo ni Silas bii byaan leñ kyedzy Berea. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Axte Atenas bikche ksa xaa nii kunal Pable. Lo xaa go pxaal Pable tiits nii kyob tsiktsiil Silas ni Timoteo xaa leñ kyedzy Atenas. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mentre lëë Pable këmbës ktsiñ Silas ni Timoteo Atenas, iip kwyonguiooldy styoo xaa kon xaa nii singootyee ndaly mdyo no leñ kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Por ngo bitiitsni xaa meñ Israel leñ ktoo ni bitiitsni xaa meñ sit nii xtsyeb Dios, ni ksatyee gaa tse bitiitsni xaa meñ nii xtsyooltyee xaa lo kiy. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wi bla xaa chak nii xñee meñ Epicúreos ni bla xaa chak nii xñee meñ Estoicos bislo bitiitsni Pable. No xaa go chëb lo xcombañer: —Nandy xaa gue pe xñee xaa. No gaa xaa chëb: —Sootee na xñee xaa nii no stu mdyo kub. Singo kwnee xaa porñee biñ xaa nii xluuy Pable xtiits Dios nii xñee cho nak Jesús ni biñ xaa nii xñee Pable nii xpañ meñ kuty. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Por ngo lëë xaa kuni Pable tu laañee nii lë Areópago. Siko xkaal lsa nonsyke xaa chak. Lëë xaa kwnabtiits lo Pable chëb xaa: —¿Pe schilo dyon kñëël loo noo xa nak wseedy kub nii sëëdnil? ");
INSERT INTO ztqNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Porque ndaly kchë cos ngub nii xñeel xyeeñdy noo. Chakladzy noo kaknan noo dyon xa nako. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Singo chëb xaa porñee kchësy meñ Atenas ni meñ sit nii no siko iip choxkody xaa nii kuuñtsyey xaa stu cos, sink tugak xkyëmbës xaa jkëëtyag xaa ni kñee xaa tu cos ngub. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lëë Pable kusoli groltyee lady xaa chak ko, aan lëë xaa chëb: —Kol kono kchësy to nii nak to xaa Atenas, chanaa gon nii ndaly mdyo xleni do. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Por worñee kwteedyaa laañee sob ximdyo do, konaa tu lo pkoog nii kë sinrii: “Lëë pkoog re kwyaa par tu Dios nii ni tu cho xyuumbeydy.” Lëë Dios nii nagon xleni do aan xyuumbeydy to nak Dios nii xsetyaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Lëë Dios nii xsetyaa lo do psaa kislyu ni kchë cos nii no lo kislyu. Lëë xaa xñabey kpaa ni lëë xaa xñabey kislyu. Nody xaa leñ ktoo nii xsaa chol meñ lo kislyu re, ");
INSERT INTO ztqNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ni nody xaa lyaadzy nii dyon pe ktee meñ lo xaa, por lëë xaa xnee kyalmbañ kchë lo no, ni kchë cos nii xkiiñ no. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Klo tugak mguiy ni tugak kwnaa psaa Dios parñee ktyaly meñ lo kislyu. Ni lëë Dios psaanle pa tiemp ni pa tañ kpañ catu meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Singo beeñtsyey Dios parñee kyub meñ Dios, tsiin tsaaplaa gaa stsil meñ xaa, nikxe nii sijty so Dios catu lo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Lëë Dios xnee kyalmbañ lo no, ni lëë xaa chuuñ kni lëë no, ni por lëë xaa mbañ no, sinak nii kwnee bla xaa chak nii no lady to, tsiñee chëb xaa: “Xtiiy Dios nak no.” ");
INSERT INTO ztqNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Deelñee lo xtiiy Dios tsigo busy syoop no, nody nii kniladzy no nii chol mdyo or ni mdyo plat o mdyo kyo gaa nii xsaa chol meñ nak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tyub tsigo pxekw Dios kon kchë xkyalnguey meñ, per lëë na tyub lo kislyu xñabey xaa nii ktsëë meñ xmod. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Por lëë Dios psol tu tse nii lëë tu xaa nii kwlel xaa kiid kuñ kyalxtisy lo kislyu, ni lëë Dios kaa bluuyle chow lo meñ tsiñee lëë xaa beeñ kpañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tsiñee lëë xaa chak ko biñ nii xpañ meñ kuty, no xaa pxidzyni Pable, no gaa xaa chëb: —Na lëëty dyon pa stu tse jkëëtyag noo nii xñeel. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tsigo lëë Pable pchoo lady xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per lëë bla meñ nii bniladzy sinal Pable. Lady meñ go si Dionisio, tu xaa nii wi xkaal lsa lady meñ nii xtyop laañee lë Areópago. Ni wi tu kwnaa nii pcholë Dámaris bniladzy ni stubla meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Loxsye ngo lëë Pable pchoo Atenas, lëë xaa si leñ kyedzy nii lë Corinto. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Siko lëë Pable kuktsiil tu xaa Israel nii pcholë Aquila. Kyedzy nii lë Ponto koly xaa. Kal lik ptsiñ xaa Corinto chop tsiil xaa Priscila. Nëz Italia siid xaa, porñee lëë xtisy Claudio kwnabey pchoo kchësy meñ Israel Roma. Lëë Pable kutedy lo xaa ");
INSERT INTO ztqNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","aan, como misme tsiiñ nii chuñak xaa chuñ Pable, xsaa xaa yu kidy, lëë Pable kwlës lo xaa par kyë xaa tsiiñ chop xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Aan ksatyee tse nii xiladzy meñ Israel lo tsiiñ kwey Pable ktoo par kutiitsni xaa meñ Israel ni meñ sit xa nak xtiits Dios nii xñee cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lëë Silas ni Timoteo pchoo Macedonia aan tsiñee lëë xaa ptsiñ Corinto, lëë Pable bislo xluuy xtiits Dios nii xñee cho nak Jesús ksatyee tse. Bluuy xaa lo meñ Israel nii lëë Jesús nak Crist, xaa nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per lëë meñ bislo ptilyni Pable ni lëë meñ go pxiñ tiits lo xaa. Por ngo lëë xaa kwtsib yuti nii xña xab xaa parñee kyeñ meñ nii no xtol meñ, ni lëë xaa chëb: —Xcuent to deelñee telaady to lo tol, lëdy xcuentno. Por destye natse lëën kluy xtiits Dios lo meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tsiñee lëë Pable pchoo ktoo, lëë xaa si lidzy tu xaa nii pcholë Justo. Tu xaa nii xniladzy xtiits Dios nak Justo. Kexka chu ktoo no xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Wi tu xaa nii pcholë Crispo nii xñabey leñ ktoo bniladzy xtiits Dios kchë meñ lidzy. Ni ndaly gaa meñ Corinto nii pkëëtyag xtiits Dios ni bniladzy kwchobnis. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lëë tu kyool lëë Dios chëb lo Pable lo mgaal: —Ktsyeebtyoo. Tugak kwnee, ksuugwtyoo chuwoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Naa nakni lii. Ni tu cho chilody ksaksi lii, por ndaly meñ nii ngab lon no leñ kyedzy re. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tu iz grol kwlës Pable leñ kyedzy Corinto, bluuy xaa xtiits Dios lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per tsi lëë Galión pkaa kok xtisy Acaya, lëë meñ Israel kwnaasy Pable aan lëë meñ kukso xaa lo xtisy, ");
INSERT INTO ztqNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","aan lëë meñ chëb lo xtisy: —Lëë xaa re no kluuy lo meñ kyedzy nii no nii kniladzy meñ xtiits Dios tu mod nii xñabeydy xley meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Lëë Pable si nii nyee, tsi lëë Galión chëb lo meñ Israel: —Deelñee ngo xaa tu falt nroob o nyuty kaa xaa tu meñ, nyonaa xtiits to. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per como tiits sye nak kchë nii xñee do ni nonsyke lë meñ xseety to ni kchë cos nii dyon xa xñee xley do, kol kan dyon xa kuuñtsyey do, por chaklastyaa sëëbaa lo xcuent to. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aan lëë Galión kwnabey pchoo meñ leñ yulyey. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tsigo lëë meñ kwnaasy tu xaa nii pcholë Sóstenes nii xñabey leñ ktoo, aan kexka chu yulyey ptee meñ xcheñ xaa, per pe beeñdy xtisy Galión. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bii ndaly kpidz kwlës Pable leñ kyedzy Corinto. Loxsye ngo lëë xaa blë ksa xaa meñ nii xniladzy xtiits Dios, aan lëë xaa kwyo barkw par tsi xaa nëz Siria ksa xaa Priscila ni Aquila. Aan antes nii lëë barkw kchoo chu nis nii lë Cencrea, lëë Pable pka kik par kuñ xaa cumplir nii byaan xaa tiits chop xaa Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tsiñee lëë xaa ptsiñ leñ kyedzy Efeso, lëë xaa psaan Priscila ni Aquila, aan lëë xaa kwey ktoo par kñee xaa lo meñ Israel nii xkaal lsa siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Lëë meñ Israel go kwnab nii ngwësre Pable, per kwnëdy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lëë xaa bi, chëb xaa: —Deelñee snë Dios, lëën kyely teedy lo do stub. Aan lëë Pable byo barkw par kpi xaa Efeso. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tsiñee lëë Pable ptsiñ Cesarea, lëë xaa kwey Jerusalén kujkëëptyux xaa meñ nii xniladzy xtiits Dios. Loxsye ngo lëë xaa si Antioquía. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kok xtsedyako lëë xaa pchoo stub, kutedy xaa kchë kyedzy nii nche nëz Galacia ni nëz Frigia par kchoobladzy xaa styoo meñ nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Leñ tse go lëë tu xaa Israel nii pcholë Apolos ptsiñ leñ kyedzy Efeso. Xaa Alejandría nak xaa. So xnëz nak xtiits xaa ni buen buen xyuumbey xaa kitsy nii kë xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Por ngo nii xyuumbey xaa xtiits Dios nii xñee cho nak Jesús ni tyub styoo xaa xñee xaa lo meñ cho nak Jesús, nikxe nii por Juansye kwchobnis xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Iip ptsyebty Apolos, lëë xaa bluuy xtiits Dios lo meñ Israel leñ ktoo. Per tsiñee lëë Priscila ni Aquila biñ nii xñee Apolos, lëë xaa kuni Apolos lidzy xaa parñee kluuyre xaa xa nak xtiits Dios lo Apolos. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tsi lëë Apolos kwlokyeñ tsi nëz Acaya, lëë meñ nii xniladzy xtiits Dios pkëë tublë kitsy kwseñ xaa si lo meñ nii xniladzy nii no siko, parñee ngui kñee meñ go lo xaa. Tsiñee lëë xaa ptsiñ Acaya, mbëë beeñ xaa meñ nii xniladzy xtiits Dios yudar. ");
INSERT INTO ztqNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Xña lo meñ ptilytiitsni xaa xaa Israel, per beeñ xaa gan porñee bluuy xaa nii leñ xkitsy Dios kë nii lëë Jesús nak Crist, xaa nii pxaal Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mentre lëë Apolos këno Corinto, lëë Pable kutedy kchë kyedzy nii nche kexka chu nëz nii si Efeso, aan leñ kyedzy Efeso lëë xaa kuktsiil bla meñ nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Lëë Pable kwnabtiits chëb: —¿Pe kwsëëb Kyalbini Ntson leñ styoo do worñee bniladzy to xtiits Dios? Lëë meñ go kwëb chëb: —Per ni ndondy noo nii no Kyalbini Ntson. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tsigo lëë Pable chëb: —¿Xa kwchobnis to tsigo? Lëë meñ go kwëb chëb: —Si bluuy Juan, singo kwchobnis noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Loxsye ngo lëë Pable chëb: —Lëë Juan pchoobnis meñ Israel nii ptsëë xmod, per lëë gak Juan chëb nii no nii kniladzy meñ xaa nii kiid loxsye kpi Juan. Lëë xaa go nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tsiñee lëë meñ go biñ ngo, lëë meñ go kwchobnis sinak nii xñabey Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Aan tsiñee lëë Pable pxob ña kik meñ go, lëë Kyalbini Ntson kwsëëb leñ styoo kchësy meñ go, ni lëë meñ go bislo xñee stub clasy tiits ni nii tu cho karty kon ni lëë meñ go kwnee nii psyaab Dios leñ kik meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tsiipchop nak meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tson mëë tugak kwey Pable leñ ktoo siko, xluuy xaa xtiits Dios ni xñee xaa xa nak xkyalwnabey Dios. Iip ptsyebty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per lëë bla meñ nii koñee koklasty niladzy kwneenë xtiits Dios nii xñee cho nak Jesús. Por ngo lëë Pable pchoo lady meñ go aan lëë xaa kuni kchë meñ nii xniladzy laañee sob xyuscuel tu xaa nii pcholë Tirano. Siko bluuy xaa xtiits Dios lo meñ ksatyee tse. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Chop iz kwëkluuy xaa xtiits Dios. Por ngo nii kchë meñ nii no nëz Asia pkëëtyag xtiits Dios, nikxe meñ Israelo, nikxe gaa meñ sito. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ni ndaly kchë kyalntson nii beeñtsyey Pable porñee kokni Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Axte wi xbayjan Pable ni xab xaa nii biy meñ psë meñ lady meñ xsyaknë aan lëë meñ xsyaknë byak ni lëë kyalbini mal pchoo leñ styoo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wi bla xaa Israel nii xkwii kyalbini mal leñ styoo meñ pal nëz kokladzy nseety lë Jesús par kwii kyalbini mal, chëb xaa lo kyalbini mal: —Con xtiitspey Jesús nii xseety Pable xñen lo do: Kol kchoo leñ styoo meñ gue. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ksa kadzy xiñ Esceva, xaa nii xñabey lo pxosy, beeñtsyey ngo. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per lëë kyalbini mal chëb lo xaa: —Xyuumbeyaa Jesús, ni nanaa cho nak Pable. Per lëë do, ¿cho nak to? ");
INSERT INTO ztqNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wor go kazh lëë xaa nii no kyalbini mal go leñ styoo kwyas kwseñ ksa xaa go. Per nli busy ptee xaa go xcheñ xaa. Koksye gan pchoo xaa ña xaa nii no kyalbini mal leñ styoo. Xña xaa cheñ lëë xaa pxooñ nëb kidy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Aan kchësy meñ Israel ni meñ sit nii no Efeso nii koknano ptsyeb. Por ngo ndaly meñ blisklaa lë Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ndaly meñ nii bniladzy kwey wxobtol, aan bitiits meñ go kchë cos mal nii beeñtsyey meñ go worñee karty kniladzy meñ go Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ni ndaly meñ nii pseedy kyalbruj biidni kchë xlibre, aan xña lo meñ lëëw kwyek. Kwloolbey meñ nii masy tu choowptsii mily pes plat nono. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Singo mod ndaly meñ nii pkëëtyag xtiits Dios nii xñee cho nak Jesús bniladzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Loxsye kwte kchë cos ko, lëë Pable kwlokyeñ tsitedy kyedzy nii nche nëz Macedonia ni Acaya, axte ktsiñ xaa Jerusalén. Ni chëb xaa nii loxsye kpikche xaa Jerusalén, no nii tsi xaa Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Lëë xaa pxaal Timoteo ni Erasto nëz Macedonia mentre lëë xaa bii byaan Asia pa slal tiemp. Chop xaa go chuñ xaa yudar. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Leñ tse go lëë tu tily bislo por xtiits Dios nii xñee cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Lëë tu xaa nii pcholë Demetrio bislo tily go. Nonsyke mdyo plat ni xiktoo wiñ naybaa nii lë Diana xsaa xaa, aan nroob tumi xsaan tsiiñ go lo xaa ni lo xaa nii xkyë tsiiñ lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Lëë xaa kwnee lo xaa nii xkyë tsiiñ lo xaa, ni lo kchë xaa nii xkyë misme tsiiñ go, chëb xaa: —Nan do gon nii nroob tumi xsaan tsiiñ re lo no. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ni nan do gon ni chon do nii lëë Pable no kluuy lo meñ nii lëdy Dios nak kchë mdyo nii xsaa chol meñ, aan ndaly gaa styoo meñ nojko xaa. Lëdy nonsy leñ kyedzy Efeso nu no kluuy xaa kchë ngo, sink wi tyub nëz Asia. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ntseebo gon, por neñdy tsodre xtsiiñ no, ni neñdy axte wi xiktoo naybaa Diana kyaanladzy aan kiijtre meñ Asia ni meñ sit nii nche tyub lo kislyu lo naybaa Diana. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tsiñee lëë meñ biñ ngo, per nli busy blëë meñ aan lëë meñ bislo kwchuptsyë, xñee: —¡Byinayk Diana xnaybaa meñ Efeso! ");
INSERT INTO ztqNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kchë meñ kyedzy pkyey kik. Lëë meñ kwnaasy Gayo ni Aristarco. Chop xaa Macedonia go nak ksa Pable. Lëë meñ kuni xaa axte tu laañee xkaal lsa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Lëë Pable kokladzy nyinee xaa lo meñ, per blaady meñ nii xniladzy xtiits Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wi bla xamigw Pable nii xñabey Asia pxaal tiits nii nody nii tsisëëb Pable lady meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Xaal xaal nii kwchuptsyë meñ nii kwey junt. Pkyey kik meñ go. Ndaly meñ go ni nandy dyon pe cos tsiiñ kwey. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Per lëë bla meñ Israel chëb lo Alejandro xa nak cuent ko. Loxsye ngo lëë meñ Israel pchëëp xaa lady meñ. Loxsye kwso Alejandro groltyee lady meñ, lëë xaa kwloo señ con ña xaa parñee kwetse meñ. Kokladzy xaa nchoo xaa xfavor meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per tsiñee lëë meñ byeñ nii xaa Israel xaa, lëë meñ bislo kwchuptsyë. Siik chop wor kwchuptsyë meñ, xñee meñ: —¡Byinayk Diana, xnaybaa meñ Efeso! ");
INSERT INTO ztqNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tsiñee lëë xsecretario xtisy beeñ gan kwleektse meñ, lëë xaa chëb: —Kol kono gaa meñ Efeso, kchësy meñ nii nche lo kislyu gon nan nii lëë meñ Efeso xyal kantsi xiktoo naybaa Diana ni kchësy meñ nan nii kpaa byab xnaybaa no Diana. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nan do nii ni tu cho chilody kñë nii nlidy kchë nrii. Por ngo, kol kwetse. Kuuñtsyeydy to cos nii nonguialdy. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Karty gon kwan chop xaa nii biidni do nu ktoo ni karty kñeenë xaa xnaybaa no. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Deelñee Demetrio ni xaa nii ksa xaa xkyë tsiiñ xñab kyalxtisy, par ngo no xtisy ni no yulyey. Schilo tsinab Demetrio kyalxtisy lo xaa xñabey parñee siko catu xaa kñee dyon xa nak xcuent xaa ni parñee kak ndoon gaa cho xaa nli xñee. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aan deelñee gaa chakladzy to kñab to pe stu cos, no nii kñab tow tu lo junt, per con ngui mod. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ntseeb gon tsijkëëkiy meñ no këb meñ nii lëë no noyuuñ tily por kchë nii beeñtsyeey no natse, ni kindy kaa pe tyeesy no deelñee cho kñabtiits lo no penak kok tily re. ");
INSERT INTO ztqNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Loxsye chëb secretario ngo, lëë xaa psonëz meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tsiñee lëë tily go byal, lëë Pable kwtsyetsy kchë meñ nii xniladzy xtiits Dios par kchoobladzy xaa styoo kchë meñ go. Loxsye ngo lëë xaa si nëz Macedonia. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kchë kyedzy nii kutedy xaa pchoobladzy xaa styoo meñ nii xniladzy xtiits Dios. Loxsye ngo lëë xaa ptsiñ Grecia. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tson mëë kwlës xaa Grecia. Lëë xaa no nëz nii tso xaa barkw par tsi nëz Siria, tsiñee lëë xaa biñ nii lëë meñ Israel kënal kuty xaa. Por ngo lëë xaa sey nëz Macedonia stub. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Lëë xiñ Pirro nii pcholë Sópater kunal Pable. Xaa Berea nak Sópater. Ni wi gaa chop xaa Tesalónica nii pcholë Aristarco ni Segundo, ni tu xaa Derbe nii pcholë Gayo, ni Timoteo, ni chop xaa Asia nii pcholë Tíquico ni Trófimo kunal. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Lëë xaa kwtenech loo noo aan lëë xaa kwlës lëë noo leñ kyedzy Troas. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Loxsye kwte lni nii xtyaaw kyaxtily nii xkyëdy levadur, lëë noo pchoo leñ kyedzy Filipos. Lëë tse nii kwloxo kaay kpidz lëë xaa nii kwtenech pkaa loo noo leñ kyedzy Troas. Kadzy kpidz blyëës noo leñ kyedzy ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tsi lëë tse tminkw kol lëë noo pkaal lsa par tyaaw noo kyaxtily. Lëë Pable beeñ kseedy meñ nii xniladzy xtiits Dios, aan como no nii kchoo xaa kyaani lyu, lëë xaa biskool xiwseedy xaa axte wrol kyool. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Leñ tu yu klaa pkaal lsa noo. Ndaly pis nak yu go. Aan tyub leeñgo kwë bini petroly. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Lëë tu xaa wiñ nii pcholë Eutico kwsob kexka chu ventan. Aan como lëë Pable biskool xiwseedy, lëë xaa kwë mgaal aan lëë xaa pchingaa chu ventan axte lyu. Kuty xaa blis meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lëë Pable byety kwteetsy xaa wiñ go. Aan lëë xaa chëb lo meñ nii xniladzy xtiits Dios: —Ktsyebty to, mbañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lëë Pable byo leñ yu aan lëë xaa taw kyaxtily ksa xaa meñ nii xniladzy xtiits Dios. Loxsye ngo lëë xaa kwnee lo meñ tyub kyool. Lëë byaani lyu lëë xaa bi. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Psak styoo meñ porñee mbañ xaa wiñ nii pchingaa chu ventan sikni meñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Lëë noo bñeech syo noo kyedzy nii lë Asón con barkw par kwëës noo Pable siko, por singo byaan noo tiits por lëë Pable si tub lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Tsiñee lëë noo ptsiil Pable leñ kyedzy Asón, lëë noo ptsyo barkw ksa noo xaa, aan lëë noo syo nëz Mitilene. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lëë byaani lyu lëë noo ptyee mer laañee nyoo Quío. Lëë byaani stu lyu lëë noo ptsiñ chu nis nii lë Samos. Siko pchoo noo lëë noo ptsiñ Mileto. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Byody noo Efeso porñee koklasty Pable nii nlyëë noo xtañ meñ Asia. Lëë xaa kwlokyeñ ktsiiñ noo Jerusalén tse nii chak lni Pentecostés, deelñee ndeedyo tiits. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tsiñee lëë noo ptsiñ leñ kyedzy Mileto, lëë Pable kwnabey koktsyetsy xaa kol nii xñabey lo meñ Efeso nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Tsi lëë kchë xaa kol go kwlañche, lëë Pable chëb: —Nan do gon xa nak xmodaa destye primer tse nii kwlañcheen Asia. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ni nan gaa to nii tyub nii kwyon lady to con kyalndoladzy ni wiiñ psobaa xtiits Dios, ni ndaly gaa kyalnë pteedy meñ Israelaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per psaandyaa tugak bluyaa xtiits Dios lo do. Kwnen lo do leñ kyedzy ni kwnen lo do lidzy to. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ni chëpaa lo meñ Israel ni lo meñ sit nii no nii ktikche meñ styoo lo Dios ni kniladzy meñ xtiits Dios nii xñee cho nak Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Lëë na lëën ka Jerusalén, porñee lëë Kyalbini Ntson xaal naa. Nandyaa pe ktsyoolaa siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ni nansyaa ksatyee kyedzy nii kan xñee Kyalbini Ntson nii lëë skiib ni lëë kyalnë këmbës naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per ni tu pe sinidy kikaa, ni xkyalmbañaa nondy lon. Lëëw comñee mbëë kyaalaa tsiiñ nii bneetsy Dios lon. Lëë tsiiñ go nak nii kluyaa xtiits Dios nii xñee cho nak Jesús lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Bluyaa lo do xa nak xkyalwnabey Dios. Lëë na xyeñpaa nii kpikchedre kan do naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Por ngo chakladzyaa kniyaa lo do natse nii chaaptyaa tol deelñee no tu do nii telaady. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Por nanaa nii kchë nii kwnabey Dios bluyaa lo do. Ni tu pe kwloolandyaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Por ngo, kol kap cuidad lëë do ni kchë meñ nii xniladzy xtiits Dios. Porque por kchë do kuty Jesús lo crusy ni lëë gaa Kyalbini Ntson pso lëë do parñee kap cuidad to meñ nii xniladzy xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nanaa nii tsiñee lëën kpi, lëë meñ nii ko kyalnë kchë meñ nii xniladzy xtiits Dios kiid. Nak meñ go sinak chol ma tox nii chuty mëkwxiily. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ni misme lady kaa to kchoo xaa nii kluuy tiits xuuy parñee tsinal meñ nii xniladzy xtiits Dios xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kol kap cuent, kol ksaladzy gaanoo nii tson iz nder tyub styoon bluyaa xtiits Dios lo do tsel kyool. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Lëë nana, beetsy, xñabaa nii kakni Dios to ni xñabaa nii ksaanlasty to xtiits Dios nii xniladzy to. Lëë xtiits Dios kchoobladzy styoo do ni lëë xtiits Dios knee kchë kyalnsaak nii xtee Dios lo kchë meñ nii xniladzy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tyub nii kwyon lady to kwyokidyaa xab meñ ni karty kaa tsokin xtumi meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nan buen do nii kwën tsiiñ par ktsiñaan nii jkiiñaa ni nii jkiiñ meñ nii biidnal naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tugak bluyaa nii singo kak tsiiñ tsiin kchilo kuñ ñe meñ nii no lyaadzy yudar, ni ksaladzy ñe xtiits Jesús tsiñee chëb xaa: “Mastre xle meñ nii xkady que meñ nii xñaasy.” ");
INSERT INTO ztqNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Loxsye kwnee Pable lëë xaa psoxib aan lëë xaa bitiitsni Dios ksa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kchësy xaa kol go biiñ, ni lëë xaa kwteetsy Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Mban ptee styoo xaa porñee biñ xaa nii kpikchedre kan xaa Pable. Loxsye ngo lëë xaa kuksonëz Pable axte chu barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Loxsye psaan xaa go lëë noo, lëë noo ptsyo barkw aan lëë noo syo tubli lo kislyu wiñ nii lë Cos. Lëë byaani lyu lëë noo ptsiñ lo stu kislyu wiñ nii lë Rodas. Siko pchoo noo, lëë noo ptsiñ kyedzy nii lë Pátara. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Chu nis Pátara psyeeñ noo tu barkw nii tsi nëz Fenicia. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tsiñee lëë noo syo lo nis, lëë noo ptyon kislyu wiñ nii lë Chipre. Lëëw byaan nëz ñapeg noo, lëë noo syo axte Siria. Aan como no nii ksaan barkw yow chu nis nii lë Tiro, lëë noo blyëës siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Loxsye ptsiil noo meñ nii xniladzy xtiits Dios, lëë noo blyëës kadzy kpidz lo meñ go. Aan lëë Kyalbini Ntson kwnee kchë nii ktsyool Pable Jerusalén lo meñ go, aan lëë meñ go chëb lo Pable: —Nody nii tsil Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per tsi lëë ksa kadzy kpidz ko psa, lëë noo bii. Kchë tsiil ni xiñ meñ nii xniladzy xtiits Dios kuksonëz lëë noo axte chu nistoo, aan lëë noo psoxib chu nis ko par kutiitsni noo Dios kchësy noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Loxsye ngo lëë noo blë lsa. Lëë noo ptsyëëp barkw, lëë gaa meñ kyedzy ko bikche sey lidzy. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro pchoo noo lëë noo ptsiñ kyedzy nii lë Tolemaida. Siko lëë noo byo jkëëptyux meñ nii xniladzy xtiits Dios aan lëë noo blyëës siko tu kpidz. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lëë byaani lyu lëë noo ptsiñ kyedzy nii lë Cesarea. Siko lëë noo byo lidzy Felip nii xluuy xtiits Dios. Wi Felip ngab lady ksa kadzy xaa nii kwle meñ leñ kyedzy Jerusalén par kuñ xaa xyudar apostle. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ksa tap xiñtsyaap Felip nii karty ktsiilña xñee tiits nii xsyaab Dios leñ styoo me. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ndaly kpidz kok nii nche noo siko, tsiñee lëë tu profet nii sëëd nëz Judea nii pcholë Agabo kwlañche. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Lëë xaa biid tedy loo noo. Lëë xaa kwseñ xcinturón Pable aan lëë xaa pxituu niy xaa ni ña xaa con xcinturón Pable, xñee xaa: —Lëë Kyalbini Ntson xñee nii sinrii kxituu meñ Israel xpixwan cinturón re leñ kyedzy Jerusalén, ni lëë meñ jko xaa ña meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tsiñee lëë noo ptsyon xtiits xaa go, lëë noo kok ksa meñ Cesarea bñee noo lo Pable parñee tsidy xaa Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Per lëë Pable kwëb, në: —¿Penak choon do ni xko kyalnë do naa? Snëën kxituu meñaa, ni snëën ketyaa Jerusalén par kuuñ ksakaa Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Aan como pchiloody noo ngwiisoo noo styoo xaa, lëë noo psaan xaa, ptyeesy noo: —Lëë Dios dyon kaknil. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Loxsye ngo, lëë noo pxixkwaa aan lëë noo syo Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wi bla xaa Cesarea nii xniladzy xtiits Dios biidnal lëë noo. Lëë xaa go kuni lëë noo lidzy tu xaa Chipre nii pcholë Mnasón. Kok xtsele nii xniladzy xaa xtiits Dios. Lidzy Mnasón blyëës noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Tsiñee lëë noo ptsiñ Jerusalén, con kyalwle biid ktsiilnëz meñ nii xniladzy xtiits Dios lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lëë byaani lyu lëë noo byoteedy lo Jacob ksa noo Pable, aan lëëtyee gaa wi kchë xaa kol nii xñabey lo meñ nii xniladzy xtiits Dios nche siko. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Lëë Pable pkëëptyux kchë xaa go. Loxsye ngo lëë Pable bislo bitiits kchë kchësy cos nii pteedy Dios tiitspey beeñtsyey xaa lady meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tsiñee lëë kchë xaa go lox biñ nii bitiits Pable, lëë xaa ptee skizh lo Dios. Tsigo lëë xaa chëb lo Pable: —Bueno, beetsy, per nan nyëël gon nii ndaly meñ Israel xniladzy xtiits Dios nii xñee cho nak Jesús. Aan kchësy meñ Israel go chuuñ ndip xtiits nii no nii kyonaal no xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ni lëë meñ Israel go biñ nii xluuyoo lo meñ Israel nii no tañ nii ksaldy xaa kchë nii psaan Moisés. Ni lëë xaa biñ nii xñeel lo meñ Israel nii no tañ nii kobeydy xaa xiñ xaa ni tsinaldy xaa xcostumbre no. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Xa kuuñ no? Por lëë meñ gon ktyop tsiñee lëë meñ kon nii lëël blañ. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lëëw nii nako no nii kuuñtsyeyoo nii kniiy noo: Lëë tap xaa nii chakladzy kuuñ ksak Dios nche nu. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kuni xaa, kol kuuñ nyë lëë do sinak nii xñabey xley Moisés, ni kwtiix parñee jka kik xaa tsiin kyeñ meñ nii nlidy nii chuuñtsyeyoo kchë nii noyon meñ, sink lëë meñ kyeñ nii wil chuuñtsyey nii xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lëë noo pxaal le tublë kitsy lo meñ sit nii xniladzy xtiits Dios parñee kawdy meñ sit xpëël kchë ma nii chokon lo mdyo, ni kawdy meñ sit cheñ, ni kawdy meñ sit xpëël chol ma nii xiyañ, ni nody nii tsoni meñ sit stu meñ deelñee no tsiil meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Lëë Pable sini ksa tap xaa go. Lëë byaani lyu lëë xaa kok nyë ksa xaa sinak nii xñabey xley Moisés. Loxsye ngo lëë Pable kwteyo leñ lidzy Dios par këb xaa pa tse kyal kak nyë ksa tap xaa go ni parñee këb xaa pa tse kokon xaa go nii sini xaa go lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Per lëë ksa kadzy kpidz ko merle ksa, tsiñee lëë bla xaa Israel nii no nëz Asia kon nii lëë Pable no leñ lidzy Dios aan lëë xaa go pkiily meñ par kñaasy xaa Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Lëë xaa kwchuptsyë, chëb xaa: —¡Kol kono meñ kyedzy, kol kuñ lëë noo yudar kñaasy no xaa re! Por nody xaa xlad meñ xkyedzy no, sink lëë xaa xluuy nii ksaldy meñ xley Moisés ni ksaldy meñ lidzy Dios. Tyub lo kislyu xluuy xaa nrii. Lëë na axte wi bla meñ sit psëëb xaa leñ lidzy Dios. Sinrii mod lëë xaa beeñ tu cos nii nonguialdy kak. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Singo chëb xaa Israel go porñee kon xaa Pable leñ kyedzy chop Pable tu xaa Efeso nii pcholë Trófimo. Nladzy xaa te wi Trófimo kuni Pable leñ lidzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kchësy meñ kyedzy blëë aan lëë meñ ptyop tub lugarak. Lëë meñ kwtopxax Pable, kwlii meñ xaa leñ lidzy Dios. Loxsye ngo lëë meñ psuugw puert. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kwxaak xaa wor go kazh nyuty xaa Pable, per tsiñee lëë tiits ptsiñ lo xaa nii xñabey lo soldad nii lëë kchë meñ Jerusalén noyuñ tily, ");
INSERT INTO ztqNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","lëë xaa go ptop kchë xsoldad ni kchë xaa nii xñabey lo xsoldad xaa aan lëë xaa ptsiñ wxooñ laañee nche meñ. Tsiñee lëë meñ kon xaa nii xñabey lo soldad ni kon soldad, lëë meñ psaan Pable, pteejtre meñ xcheñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tsigo lëë xaa nii xñabey lo soldad big, aan lëë xaa kwseñ Pable, ni lëë xaa kwnabey pxituu Pable con chop lë caden. Loxsye ngo lëë xaa kwnabtiits cho nak Pable ni pe cos beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per xaal xaal nii kwnee meñ. Pchilody nyon xaa nii xñabey lo soldad pe xñee meñ porñee kchë meñ chuptsyë. Por ngo lëë xaa kwnabey kuni soldad Pable laañee sob yu nii no soldad. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Tsiñee lëë soldad ptsiñni Pable laañee chislo scaler nii xyakxoob axte chu yu go, lëë soldad kwlañ Pable, porñee tir ntseeb chak meñ nii nal, ");
INSERT INTO ztqNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","xñee meñ: —¡No nii kety kazh xaa! ");
INSERT INTO ztqNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Lëë soldad si nii jko Pable leñ yu, tsi lëë Pable chëb lo xaa nii xñabey lo soldad: —¿Pe schilo kñen choplan xtitsaa lool? Tsigo lëë xaa nii xñabey lo soldad kwëb chëb: —¿Pe chakoo nayak xñeel griego? ");
INSERT INTO ztqNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Pe mod lëdy lii tsigo nayak nak xaa Egipto nii penaadle beeñtsyey tu tily ni kuni tap mily nweety bñech tu tañ pidzy? ");
INSERT INTO ztqNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tsigo lëë Pable chëb: —Lëdyo. Xaa Israelaa. Tarso kolyaa. Tu kyedzy non nii nche Cilicia nak Tarso. Beeñ favor blaa kñen choplan xtitsaa lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lëë xaa nii xñabey lo soldad ptee tiitspey, aan lëë Pable kusoli lo scaler. Lëë xaa kwloo señ con ña xaa par kwetse meñ. Tsi lëë meñ lox kwchetse, lëë xaa kwnee con xtiitsë meñ Israel chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Kol kono, beetsy, ni kol kono xaa kol. Lëën kñe choplan xtitsaa lo do parñee kyeñ do nii nody xfaltaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tsiñee lëë meñ biñ nii con xtiitsë meñ kwnee xaa, mastre tse kwche meñ. Tsigo lëë Pable chëb: ");
INSERT INTO ztqNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Xaa Israelaa. Tu kyedzy nii lë Tarso nii nche nëz Cilicia kolyaa, per leñ kyedzy Jerusalén nu kwroobaa. Lëë Gamaliel beeñ kseedy naa xley pxusykoltoo no, ni tugak kaa choxkoon kuuñ ksakaa Dios tyub styoon sinak nii noyuuñ ksak to Dios natse. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Penaadle kwënalaa nyutyaa meñ nii xniladzy xtiits Dios nii xñee cho nak Jesús. Nikxe kwnaaw, nikxe gaa xaapkiyo, kchë nak xaa kwyalon skiib. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Lëë xaa nii xñabey lo pxosy ni kchë xaa kol nan kchë nii beeñtsyeyaa, por lëë xaa bneetsy kitsy nii kwseeñaa si lo xaa Israel nii no leñ kyedzy Damasco, aan lëën kwya kyedzy ko sakyubaa meñ nii xniladzy par kyely knin kchë meñ go nu ni par ksaksin kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per tu tse mer xwe ngbidz, lëën no nëz nii ktsiiñaa leñ kyedzy Damasco, tsiñee lëë tu bini ngol nii sëëdsëëb kpaa bibëly kyako kwin. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Lëën byab lyu, aan lëën biñ tsiy tu xaa nii xñee: “Saulo, Saulo, ¿penak nii xsaksil naa?” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tsigo lëën kwnabtiits chëpaa: “¿Chool?” Aan lëë tsiy xaa go në lon: “Naa nak Jesús Nazaret, xaa nii xsaksil.” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Kchë xaa nii ksan sa ptsyeb kon bini go, per biñdy xaa tsiy xaa nii kwnee lon. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tsigo lëën chëp: “Kwnë na busy pe cos kuuñtsyeyaa.” Aan lëë xaa në: “Kuxche, ptsiñ Damasco. Siko no tu xaa nii kñë pe cos kuñoo.” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Aan como lëë bini go bnek lon, pchilody nyanaa. Lëë xaa nii ksan sa kwtob ñan, ptsiiñaa leñ kyedzy Damasco. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Leñ kyedzy ko kwyo tu xaa nii pcholë Ananías. Tu xaa nii nli xniladzy Dios nak xaa ni chuuñtsyey xaa nii xñabey xley Moisés. Kchësy kaa meñ Israel nii no Damasco xñee nii buen xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Lëë Ananías biid tedy lon. Tsi lëë xaa kwlañ, lëë xaa në: “Beetsy Saulo, pxaly lool ni kon stub.” Aan wor go kazh lëë lon byaabini aan lëën kon Ananías. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Loxsye ngo lëë xaa në lon: “Lëë xDios pxusykoltoo no kwle lii penaadle parñee kaknanoo pe cos chakladzy xaa ni parñee kanoo xiñ ntson xaa ni parñee konoo tiits nii xchoo chuw xiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Por lii kutiits cho nak xiñ xaa lo meñ nii nche lo kislyu. No nii kutiitsoo kchë nii konoo ni biiñoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lëë nana ¿pe xlyëël nii chischeedyoo tsiin chobnisoo? Kwnab lo Dios nii koy xaa kchë xtoloo.” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Tsiñee lëën blañ Jerusalén nu, lëën kwya lidzy Dios, kwyakutiitsnin Dios, aan lëë tu mgaal kwtedy lon. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Lo mgaal go lëën kon Jesús, aan lëë xaa në lon: “Sinusy byobladzy pchoo Jerusalén, porque ksaldy meñoo tsiñee lëël kutiits cho nakaa.” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Tsigo lëën chëp: “Kchë meñ re nan nii naa kwyanasy meñ nii xniladzy xtiitsoo leñ kchë ktoo, ni nan meñ nii naa kwyalo kchë meñ nii xniladzy xtiitsoo skiib ni naa gaa ptedy xcheñ kchë meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ni byo gaa styoon nii kuty Xteb, xaa nii bluuy xtiitsoo. Naa byaani xab xaa nii kukyeety xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Per lëë Jesús në lon: “Pchoo leñ kyedzy Jerusalén, por lëën kxal lii xtañ meñ sit.” ");
INSERT INTO ztqNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tse kwche meñ biñ nii kwnee Pable, per tsiñee lëë meñ biñ nii lëë xaa pseety meñ sit, lëë meñ bislo kwchuptsyë xñee: —¡No nii kety xaa gue! ¡Nonguialtre nii kpañ xaa! ");
INSERT INTO ztqNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Aan como byoogwty chuw meñ, sink lëë meñ bislo xkwii xab ni xlëp yu kpaa parñee kaknyoo nii xlëë meñ, ");
INSERT INTO ztqNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","por ngo lëë xaa nii xñabey lo soldad kwnabey nii jko soldad Pable leñ yu, ni lëë xaa kwnabey ktee soldad cheñ Pable parñee kñeeli Pable dyon penak nii singootyee xlëë meñ lo Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Per tsiñee lëë soldad lox pxituu Pable, lëë Pable chëb lo tu soldad nii so siko: —¿Pe nonguial dyon nii kteedy to cheñ tu xaa Roma, deelñee karty kaknan do pe cos beeñ xaa? ");
INSERT INTO ztqNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tsiñee lëë soldad ko biñ ngo, lëë xaa kuni tiits lo xaa nii xñabey lo kchë soldad, chëb xaa: —Byeñ gon pe cos kuuñtsyeyoo, por Roma ngab xaa gue. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tsigo lëë xaa nii xñabey lo kchë soldad big lo Pable, aan lëë xaa kwnabtiits, chëb xaa: —¿Pe nli nii Roma ngaboo? Lëë Pable kwëb chëb: —Nliw. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Loxsye ngo lëë xaa nii xñabey lo soldad chëb: —Deel naa nyazh kwtizhaa par jkabaa Roma. Lëë Pable chëb: —Per lëë naa destye nii kolyaa ngabaa Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tsiñee lëë soldad nii nche mbës ktee cheñ Pable biñ ngo, lëë xaa bichee tublad. Aan axte wi xaa nii xñabey lo kchë soldad ptsyeb, porñee kwnaasy xaa Pable ni pxituu xaa Pable con caden aan nandy xaa nii Roma ngab Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lëë byaani lyu lëë xaa nii xñabey lo kchë soldad kokladzy nyaknan dyon pe cos xkëëkiy meñ Israel Pable. Lëë xaa kwlii Pable skiib, ni lëë xaa kwnabey koktsyetsy kchë xaa nii xñabey lo pxosy ni kchësy xaa non nii no Jerusalén. Loxsye ngo lëë xaa pso Pable groltyee lady kchë xaa xñabey go. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Lëë Pable buy kchë lo xaa xñabey go aan lëë xaa chëb: —Beetsy, axte natse gon mbëë mbañaa. Pe sidy kikaa porñee chuuñtsyeyaa nii chakladzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tsigo lëë xaa nii xñabey lo pxosy nii pcholë Ananías kwnabey nii kyaasy meñ nii nche kexka lo Pable chuw Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Per lëë Pable kwëb chëb: —¡Lëë Dios kiñ lii, xaa yox! Deelñee soboo ske par kuñoo kyalxtisy sinak nii xñabey xley Moisés, ¿penak tsigo nii xsaldyoo ley, sink lëël xñabey kiñ meñaa? ");
INSERT INTO ztqNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Loxsye ngo lëë meñ nii nche siko chëb: —¿Singuee gaa nawen xiñoo tiits lo xaa nii pso Dios kñabey lo pxosy? ");
INSERT INTO ztqNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tsigo lëë Pable chëb: —Beetsy, nandyaa nii lëë xaa nak xaa nii xñabey lo pxosy, por leñ kitsy nii kë xtiits Dios gon xñee: “Ktsiibteedyoo xaa nii xñabey xkyedzyoo.” ");
INSERT INTO ztqNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tsi lëë Pable byeñ nii grol meñ nii ncheno lo junt no xlad xaa fariseo, lëë stu grol meñ no xlad xaa saduceo, nguiedzy kwnee xaa, chëb xaa: —Beetsy, xaa fariseo nakaa ni xaa fariseo nak pxosyaa, per lëë meñ biid kso naa nu porñee xniladzyaa nii spañ meñ kuty. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tsiñee lëë Pable lox chëb ngo, lëë meñ fariseo ni meñ saduceo bislo ptilytiits lsa, aan lëë kchë meñ go kok chop tiiy. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porñee kchësy meñ saduceo xñee nii nlidy kpañ meñ kuty, ni xnilasty meñ go nii no angly ni no kyalbini. Per lëë meñ fariseo xniladzy kchësy ngo. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kchësy meñ bislo chuptsyë aan lëë bla maestre ley nii no xlad xaa fariseo kuso chëb: —Ni tu cos mal karty kuuñtsyey xaa re. Neñdy tu angly o tu kyalbinii gaa kwnee lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Aan como xyaldy kuptsyë meñ, lëë xaa nii xñabey lo soldad ptsyeb, nladzy xaa neñdy kuty meñ Pable tsi lëë meñ lox klëë. Por ngo lëë xaa kwtsyetsy bla soldad kulii Pable siko par tsikni xaa Pable laañee sob yu nii no xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tsi lëë kyool kol lëë Jesús byaklo lo Pable aan lëë xaa chëb: —Ndaan kok, por siñee bitiitsoo gon cho nakaa lo meñ leñ kyedzy Jerusalén, singo gak no nii kutiitslo Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lëë byaani lyu lëë bla xaa Israel bitiits dyon xa kuty xaa Pable, aan lëë xaa pkon Dios nii kawdy xaa ni kidy xaa axte nii kuty xaa Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Masy choow xaa Israel pkon Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Lëë xaa go kwey lo xaa nii xñabey lo pxosy ni lo kchë xaa kol nii xñabey lo meñ Israel aan lëë xaa chëb: —Lëë noo pkon Dios nii tyaawdy noo ni tyowdy noo axte nii kuuty noo Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lëë na nagon, no nii kñee do lo xaa nii xñabey lo soldad parñee kiidni xaa Pable lo do kxe. Kol këb nii lëë do kan dyon xa kak xcuent xaa, aan lëë noo lyëës xaa nëz par kuuty noo xaa antes nii klyañche xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per lëë xiñgan psyañ Pable koknano aan lëë xaa kuni tiits lo Pable laañee no soldad. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Lëë Pable kwtsyetsy tu soldad aan lëë xaa chëb lo xaa: —Kuni xaa wiñ re lo xaa nii xñabey lo do, parñee këb xaa tiits nii sëëdni xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lëë soldad kuni xaa wiñ go lo xaa nii xñabey aan lëë xaa chëb: —Lëë Pable, xaa nii no skiib kwtsyetsy naa aan lëë xaa në lon: Kuni xaa wiñ re lo xaa nii xñabey lo do. Toon pe cos tiits sëëdni xaa lool. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tsigo lëë xaa nii xñabey lo soldad kwseñ ña xaa wiñ go, lëë xaa kuni xaa tublad, aan lëë xaa kwnabtiits, chëb xaa: —¿Pe cos tiits sëëdnil lon? ");
INSERT INTO ztqNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tsigo lëë xaa wiñ go chëb: —Lëë xaa Israel byaan nii lëë xaa kñee lool parñee tsinil Pable lo xaa nii xñabey lo meñ Israel kxe, porñee lëë lëësy xaa me kan dyon xa kak xcuent Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per knilastyoo xtiits xaa, por masy choow xaa nii no xlad xaa tse nchenolan, aan pkon xaa Dios nii kawdy xaa ni kidy xaa axte nii kuty xaa Pable. Lëë na xaktyee xtiitsoo nche mbës xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tsigo lëë xaa nii xñabey lo soldad psonëz xaa wiñ go, per lëë xaa chëb kazh nii ni tu cho lo këbty xaa nii lox bitiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Lëë xaa nii xñabey lo kchësy soldad kwtsyetsy chop soldad nii xñabey lo xcombañer, aan lëë xaa chëb: —Kol kweektsey chop kyoow soldad nii së niy, ni kol kweek mbës tsongaltsii xaa nii xsyob cabay, ni chop kyoow xaa nii koy spad, par tsi xaa Cesarea nawtse a las nueve. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ni lëë xaa kwnabey kwyo xab cabay nii sob Pable, ni lëë xaa kwnabey nii ndaan Pable ni mbañ Pable ktsiñni xaa Pable lo xtisy nii pcholë Felsy. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Lo soldad pxaal xaa tublë kitsy nii si lo xtisy Felsy. Sinrii xñee lo kitsy ko: ");
INSERT INTO ztqNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Naa nak Claudio Lisias. Lëën xal tublë kitsy re lool nii nakoo xtisy. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Lëë meñ Israel kwnaasy xaa nii xalaa lool, mer nyuty meñ xaa, per tsiñee biñaa nii Roma ngab xaa, lëën kwya ksan xsoldadaa, byaklan xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aan como kokladzypaa nyaknanaa pe cos xkëëkiy meñ xaa, lëë xaa kwyaanin lo xaa Israel nii xñabey. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Siko biñaa nii lëdy cos nii xkëëkiy meñ xaa, sink pel cos cheñ xley meñ xkëëkiy meñ xaa. Per xyaldy nii kety xaa, ni skiib xyaldy tso xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Per como lëën biñ nii lëë meñ Israel chakladzy kuty xaa, lëë xaa xalaa lool ni lëën kwne gaa lo meñ nii xkëëkiy xaa nii kiidnee xaa lool deelñee pe cos xkëëkiy xaa Pable.” ");
INSERT INTO ztqNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Lëë soldad beeñtsyey nii kwnabey xaa nii xñabey lo soldad. Lëë xaa sini Pable nëz Antípatris wor kyool go. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lëë byaani lyu lëë kchë soldad nii si niy bikche ptsiñ laañee sob xaa nii xñabey lo soldad. Lëë kchë gaa xaa nii sob cabay sini Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tsiñee lëë soldad nii sini Pable ptsiñ Cesarea, lëë xaa ptee kitsy nii pxaal xaa nii xñabey lo soldad lo xtisy ni lëë xaa ptee xcuent Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Loxsye blab xtisy kitsy ko, lëë xaa kwnabtiits cho xaa Pable. Tsiñee biñ xaa nii xaa Cilicia nak Pable, ");
INSERT INTO ztqNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","lëë xaa chëb: —Na tsiñee kiidsye xaa nii xkëëkiy lii konaa dyon xa nak xcueentoo. Loxsye ngo lëë xaa kwnabey nii kyënap soldad Pable leñ yulyey nii psaa Herodes. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tse nii kwloxo kaay kpidz, lëë Ananías, xaa nii xñabey lo pxosy ptsiñ Cesarea ksa xaa bla xaa kol ni tu xaa chak nii pcholë Tértulo. Lëë xaa ptsiñ tubli lo xtisy par jkëëkiy xaa Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tsiñee lëë Pable koktsyetsy, lëë Tértulo bislo xkëëkiy xaa, xñee Tértulo lo xtisy Felsy: —Skizhoo xtisy, mbëë nche noo ni kindy tily leñ xkyedzy noo por xkyalchakoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tyub laañee xñabeyoo xsako styoo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Per parñee kislëëdre noo lii, xñabaa nii jkëëtyagoo choplan xtiits noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Lëë noo gon bñaasy xaa re porñee nak xaa sinak tu kyalkits. Laañee xkaatyee noyuñ xaa meñ Israel chop tiiy ni lëë xaa xñabey lo tub tiiy meñ nii lë Nazareno. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kokladzy xaa nguidyni xaa lidzy Dios nii sob Jerusalén. Por ngo nii lëë xaa bñaasy noo aan lëë noo nyuuñ kyalxtisy sinak xñabey xleey noo, ");
INSERT INTO ztqNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","per lëë xaa nii lë Lisias nii xñabey lo soldad biid kla xaa loo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Lëë na misme lii gaanoo, kwnabtiits lo xaa parñee kyeñoo nii nli kchë nii xkëëkiy noo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wi kchë meñ Israel nii nche siko chëb nii nli beeñtsyey Pable kchë nii xkyëëkiy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Tsigo lëë xtisy kwloo señ lo Pable parñee kñee Pable, aan lëë Pable chëb: —Xlen nii lii kon xa nak xcuentaa por nanaa nii kokle bla iz nii soboo xñabeyoo tañ re. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Natse gon chak tsiipchop kpidz nii ptsiiñaa Jerusalén par kolaa lay lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ni tu cho kondy nii lëën no ktilytiits pal nëz, nikle leñ lidzy Dioso, nikle gaa leñ ktoow. Ni tu cho pkaldyaa leñ kyedzy Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Chilody kluuy meñ Israel nii nche nu nii nli beeñtsyeyaa kchë nii xkëëkiy xaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Lëën kñëëli lool nii nikxe nii xñee xaa re nii nlidy kchë nii bluuy Jesús Nazaret, xsobaa xtiits xDios pxosyaa sinak xñabey xaa. Ni xniladzy kaan kchë nii kë leñ xley Moisés ni kchë nii pkëë profet. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ni wi gaan xniladzy nii xniladzy xaa re. Xniladzyaa nii lëë Dios kuuñ kpañ meñ kuty. Nikxe meñ malo, nikxe gaa meñ bueno, kchëlo meñ kuuñ kpañ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Por ngo, tugak choxkoon kuuñtsyeyaa nii chakladzy Dios ni chuuñtsyeyaa kyalbuen lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Kok xtsele nii kënsën xtañ meñ sit. Lëë na lëën bikche tu kyedzyaa par kyelynin palal tumi jkiiñ meñ nii no lyaadzy ni parñee kokonaa nii xñabey xley Moisés lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kchë ngo noyuuñtsyeyaa tsiñee lëë bla meñ Israel nii no nëz Asia kon naa leñ lidzy Dios. Kok nyë kaazhaa sinak nii xñabey xleey noo antes nii sëbaa leñ lidzy Dios, ni kwyaanidy kaan tub yox meñ, ni byubtyaa tily. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lëë xaa nii kon naa leñ lidzy Dios kiid jkëëkiy naa deelñee beeñtsyeyaa tu cos nii nonguialdy. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O deelñee gaa kchilody kiid xaa go, kñë xaa nii nche nu dyon pe cos falt kwlon worñee kukso xaa naa lo xaa nii xñabey lo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Xakxe worñee nguiedzy kwnen chëpaa: “Lëë do biid kso naa nu natse porñee xniladzyaa nii spañ meñ kuty”, neñdy wor go kwlon falt. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Tsiñee lëë xtisy Felsy biñ xa së lo xtiits Pable, aan como nanle gaa xaa xa nak xiwseedy meñ nii no xlad Crist, lëë xaa pkwëës lo cuent ko, aan lëë xaa chëb: —Na tsiñee kiidsye Lisias, xaa nii xñabey lo soldad, kaknanraa xa nak xcueentoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Loxsye ngo lëë xtisy Felsy kwnabey nii bii kyaan Pable leñ skiib, per lëë xaa chëb lo soldad nii klaa xaa Pable xisy wiñ ni klaa xaa tsitedy xamigw Pable lo Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lëë koko bla kpidz lëë xtisy Felsy ptsiñ chop tsiil xaa Drusila. Meñ Israel nak tsiil xaa. Aan lëë xaa kwnabey koktsyetsy Pable par kñee Pable dyon xa nak nii kniladzy meñ Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per tsiñee lëë Pable pseedy nii no nii tsoxko meñ kpañ meñ sinak nii xñabey Dios, ni no nii kxekw meñ kuuñtsyeydy meñ nii klyaañtyee styoo meñ por sitsiñ tse nii lëë Dios kwetsy catu meñ, lëë xtisy Felsy ptsyeb aan lëë xaa chëb lo Pable: —Kwey. Na tsiñee kteedyoo tiits lon, kwetsyaa lii stub. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ni lëëw na kwëmbës xtisy Felsy nii ndee Pable tumi parñee nlaa xaa Pable. Por ngo kety kety kwtsyetsy xaa Pable parñee kñee xaa lo Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Lëë kwloxo chop iz, lëë gaa xiz xtisy Felsy psa, aan lëë Porcio Festo pkaa kwsob xlugar xaa kok xtisy. Aan lëë Felsy psaan Pable skiib parñee buen kyaan xaa lo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tse nii kwloxo tson kpidz nii pkaa xcuent Festo kyalxtisy, lëë xaa pchoo Cesarea, lëë xaa si Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tsiñee lëë xaa ptsiñ Jerusalén, lëë xaa nii xñabey lo pxosy ni kchë xaa Israel nii mastre non kujkëëkiy Pable lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Lëë xaa go kwnab tu kyalnsaak lo Festo chëb xaa nii kñabey Festo kyey Pable Jerusalén. Ni lëëw na nol kik xaa nii deelñee ndee Festo tiits, lëë xaa nyikuty Pable nëz. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per lëë Festo chëb: —Cesarea no Pable skiib ni klyëëdy kaan lëën kya Cesarea. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Por ngo no nii kiid xaa nii xñabey lo do Cesarea parñee jkëëkiy xaa Pable siko deelñee pe cos falt kwloo Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Xonak o tsii gak kpidz kwlës Festo Jerusalén, lëë xaa bikche sey xaa Cesarea. Lëë byaani lyu nii ptsiñ xaa, lëë xaa kwsob leñ yulyey, aan lëë xaa kwnabey koktsyetsy Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Tsiñee lëë Pable kwsëëb yulyey, lëë xaa Jerusalén big kex, aan lëë xaa bislo pkëëkiy xaa Pable tub yox cos ntseeb, per ni tu cos nii pkëëkiy xaa Pable pchilody nyuñ xaa preb nii nli beeñtsyey Pablo. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Per lëë Pable gaa tugak kwnee xaa, chëb xaa: —Karty kuuñtsyeyaa kchë nii xkëëkiy xaa gue naa. Nlidy nii xsaldyaa xley meñ Israel, ni nlidy nii xsaldyaa lidzy Dios, ni nlidy nii xsaldyaa xtisy Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Per como lëë Festo kokladzy kyaan buen xaa lo meñ Israel, lëë xaa chëb lo Pable: —¿Pe snëël tsil Jerusalén parñee siko kanaa dyon xa kak xcueentoo? ");
INSERT INTO ztqNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Tsigo lëë Pable kwëb chëb: —Leñ yulyey nii ngab lo xtisy Roma son. Penak nii toon pare kan par kak xkyalxtisyaa. Ni nan bueen gaal nii karty kon falt lo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Deelñee kwlo gaan tu falt nii xyal ketyaa, penaktyo na ketyaa. Per como nlidy kchë nii xkëëkiy xaa gue naa, ni tu cho xyaldy jko naa ña xaa Israel. Xñabaa nii yuub xtisy Roma kan dyon xa kak xcuentaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tsigo, lëë Festo kwnabtiits lo xaa nii ksa xaa xñabey. Loxsye ngo lëë xaa chëb lo Pable: —Lëël kwnab nii yuub lo xtisy Roma tsil. Na tsil lo xaa na parñee kan xaa xa kak xcueentoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Blyëëdyako lëë rey Agripa ni Berenice kwey Cesarea kujkëëptyux Festo. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Aan como ndaly kpidz kwlës xaa, lëë Festo bitiits lo xaa xa nak xcuent Pable, chëb Festo: —Lëë tu xaa nii psaan Felsy skiib bii no nu. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aan tsi lëën kwya Jerusalén, lëë xaa nii xñabey lo pxosy ni kchë xaa kol nii xñabey lady meñ Israel biid jkëëkiy xaa. Kchë xaa go kwnab nii kñabeyaa kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per lëën chëp nii xñabeydy xtisy Roma kety tu meñ deelñee karty kan xaa ktilytiitsni meñ go kchë xaa nii xkëëkiy xaa parñee kak ndoon dyon cho xaa nli xñee. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Por ngo, tsiñee lëë xaa Israel go kwlañche nu, blyëëdyaa. Siñee byaani lyu lëën kwsoob leñ yulyey aan lëën kwtsyetsy xaa nii xkëëkiy xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Per tsiñee lëë xaa lox ptilytiits, ni tu cos ntseeb nii nladzyaa pkëëkiydy xaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nii biñsyaa nonsyke kchë deel xa nak xlay xaa pkëëkiy xaa xaa ni por tu xaa nii lë Jesús nii kuty, per lëë Pable xñee nii mbañ Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aan como byeñdyaa pe nyuuñtsyeyaa, lëën kwnabtiits dyon pe nyë Pable nyi xaa Jerusalén parñee siko nyanaa dyon xa nyak xcuent xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per como lëë xaa kwnab nii yuub lo xtisy nii sob Roma tsi xaa, lëën kwnabey nii laady xaa axte nii kteedyo tiits lon kxalaa xaa lo xtisy Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tsigo lëë Agripa chëb lo Festo: —Wi gaan gon no gan konaa xa së lo xtiits xaa go. Lëë Festo kwëb chëb: —Kxe kazh kaanoo, lëël kon xa së lo xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lëë byaani lyu, lëë Agripa ni Berenice kwsëëb yulyey ksa bla xaa nii xñabey lo soldad ni xaa non nii no leñ kyedzy Cesarea. Nonsyke ladx non nche nakw xaa. Loxsye ngo lëë Festo kwnabey koktsyetsy Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tsigo lëë Festo chëb: —Rey Agripa ni kchësy to siñee nche do nu, lëë xaa re so lo do nu. Ndalyle meñ Israel nii no Jerusalén ni meñ Israel nii no leñ kyedzy Cesarea nu nonab lon nii kñabeyaa kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per naa nii xcuentaa sootaa nii karty ko xaa tu falt nii tsigal kety xaa, per como lëë xaa kwnab nii kak kiy kchë nii xkëëkiy meñ go xaa axte lo xtisy Roma, lëën kwlokyeñ kxalaa xaa lo xtisy Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aan como xyeñdyaa gaa dyon pe cos beeñtsyey xaa, lëë xaa syelynin lo do, ni loopoo rey Agripa syelynin xaa parñee kñabtiitsoo lo xaa parñee tsaap singo mod kyeñaa pe cos jkën lo kitsy nii kxalaa lo xtisy Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Porque lika sëlidyo nii kxalaa tu xaa nii no skiib, deelñee këptyaa pe cos beeñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tsigo lëë rey Agripa chëb lo Pable: —Schilo kñeel xfavooroo. Tsigo lëë Pable blis ña aan lëë xaa bislo kwnee xaa, chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Nli gaa na, rey Agripa, xlen ni xsak styoon kñen lool xa nak kchë nii xkëëkiy meñ Israel naa parñee singo mod misme naa ksoli naa lool. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ni xlen porñee nanaa nii xyeñoo xa nak xcostumbre noo kchësy noo siñee nak noo meñ Israel ni nanoo pe cos nak xiwtilytiits noo. Por ngo xñabaa nii kapoo paciensy konoo kchë nii kniyaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Kchësy meñ Israel nan xa kwyon lady meñ tu kyedzyaa ni xa kwyon Jerusalén destye nii nakaa xaa wiñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Xyuumbey nyë xaa Israel naa. Schilo kñë xaa nii xtse kwyon xlad tub tiiy xaa nii lë fariseo deelñee chakladzy xaa. Lëë xaa fariseo nak tub tiiy xaa nii mastre choxko kuñ cumplir xleey noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aan lëë na lëë meñ Israel xkëëkiy naa porñee tyub styoon xniladzyaa nii lëë Dios kuuñ kpañ kchë meñ kuty sinak nii kwneel xaa lo pxusykoltoo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ni ksa tsiipchop kaa xtiiy noo nii no Israel këmbës nii kak cumplir nii kwneel Dios. Por ngo, tsel kyool choxko kchë meñ go kleni Dios ni kuuñtsyey nii xñabey Dios. Aan porñee win xniladzy nii kwneel Dios, lëë meñ Israel biid kso naa nu. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Lëë dook, penak nii xnilasty to nii chuuñ kpañ Dios meñ kuty? ");
INSERT INTO ztqNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Klo nladzyaa nii no nii ktilynin meñ nii no xlad Jesús Nazaret ");
INSERT INTO ztqNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ni beeñtsyey gaan nii no kikaa leñ kyedzy Jerusalén. Con xtiitspey xaa nii xñabey lo pxosy ndaly kchë meñ nii no xlad Jesús kwlon skiib. Aan tsiñee lëë xaa xñabey chakladzy kuty tu xaa go, win kwne nonguial kety xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ndaly vuelt psaksin xaa nii no xlad Jesús parñee nsaan xaa nyilastre xaa Jesús. Laañee sobtyee ktoo kwyan, aan por xkyalwlëën axte xtañ meñ sit kwyanlagaa meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Kchë ngo no kikaa lëën sa kyedzy Damasco con xtiitspey xaa nii xñabey lo pxosy. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per mer xwe ngbidz gon, rey, lëën no nëz ksa xcombañeraa tsiñee lëën kon tu bini nii sëëdsëëb kpaa. Mastre xpibëlyo que lo xbini ngbidz. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tsigo kchëësy noo byab lyu. Loxsye ngo lëën biñ tsiy tu xaa nii në lon con xtiitsë meñ hebreo: “Saulo, Saulo, ¿penak nii xsaksil naa? Misme lii gon no ksaksi lii, sinak nii chuuñtsyey yosy tsiñee xkëëniy ma punt yag nii xkwib meñ ma.” ");
INSERT INTO ztqNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Tsigo lëën chëp: “¿Chool?” Aan lëë tsiy xaa go në lon: “Lëë meeraa nak Jesús, xaa nii xsaksil. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Per kuxche, por lëën byaklo lool parñee kuuñtsyeyoo nii chakladzyaa ni parñee kutiitsoo kchë nii konoo natse ni kchë nii kluuyre gaan lool. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Naa kteelaa lii lo meñ Israel ni naa kteelaa lii lo meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Lëën kxal lii lo meñ sit parñee ksaabiniil kchë lo meñ go, parñee sëdre meñ go lo nguey, sink lo bini, ni parñee ksoobtre meñ go xtiits xaatox, sink ksoob meñ go xtiits Dios, ni kniladzy meñ go xtitsaa tsiin telaa meñ go lo xtol ni jkaa meñ go nii ktee Dios lo meñ nii xniladzy.” ");
INSERT INTO ztqNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Por ngo, rey Agripa, lëën psob xtiits tsiy xaa nii kwnee lon. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Klootyee lo meñ Damasco bluyaa xtiits Dios. Loxsye ngo lëëw bluyaa lo meñ Jerusalén ni tyub xtañ meñ Judea ni lo meñ sit. Chëpaa nii ktsëë meñ xmod, ni ktikche meñ styoo lo Dios, ni kuuñtsyey meñ cos nii kluuy nii nli xniladzy meñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Por ngo lëë xaa Israel kwnaasy naa leñ ktoo aan kokladzy xaa nyuty xaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per por xkyalnsaak Dios lëën bii so nu, xluyaa xtiits Dios lo kchësy meñ. Karty kñen ni tu cos nii kwneedy profet ni kwneedy Moisés nii kak, sink nonsyke ngo xñen. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Lëë xaa go kwnee nii lëë Crist kety, ni lëë xaa go kwnee nii klootyee Crist kpañ parñee kiidni Crist tiits nii xteelaa lo meñ xkyedzy noo ni lo meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ngo nonee Pable tsiñee lëë Festo kwchuptsyë chëb: —¡Chak wetyoo, Pable! Kchë xiwseedyoo noyuuñ wety lii. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Per lëë Pable kwëb chëb: —Chakwejtyaa, Festo, sink sëli xtitsaa ni nli gaa kchë nii xñen. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Lëë rey Agripa so nu. Nan buen xaa xa nak kchë cos re. Por ngo nder confians xñen lo xaa. Nan bueenaa nii wi xaa nan xa nak kchë cos re, por lëdy tu cos nii koktsilaano. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nli gaa na, rey Agripa, ¿pe xniladzyoo kchë nii pkëë profet dyon? Nanaa nii xniladzylo. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Loxsye ngo lëë rey Agripa chëb: —Slalak nu lëël lox ngo styoon parñee kniladzyaa xtiits Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Tsigo lëë Pable chëb: —Nikxe nii slalak nu o xlyëëre gaa lox ngon styool, tsaap në Dios que nii lëdy nonsy lii, sink wi kchë meñ nii nche jkëëtyag nii xñen natse kak sinakaa, nikxe nii lëdy kchë meñ kxituu con caden. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Loxsye chëb Pable kchë ngo, lëë rey ni xtisy ni Berenice ni kchë xaa nii nche sob siko kuso. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Lëë xaa si tublad parñee kutiits xaa dyon xa kak cuent ko, xñee xaa lo xcombañer xaa: —Karty ko xaa re tu tol nii tsigal kety xaa, per ni skiib nonguialdy tso xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ni lëë Agripa chëb lo Festo: —Nchilo nlyaa xaa re deelñee nyabty xaa nii yuub xtisy Roma kan xa kak xcuent xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tsiñee lëë xaa nii xñabey kwlokyeñ kxaal lëë noo Italia, lëë Pable ni stubla xaa nii no skiib kok entregar lo tu xaa nii xñabey lo soldad nii pcholë Julio. Xsoldad xtisy Roma nak kchë soldad ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Lëë noo ptsyo tu leñ xbarkw meñ Adramitio. Lëë barkw ko no nëz nii kchoo tsi tyub nëz Asia. Wi Aristarco, xaa Tesalónica nii ngab Macedonia, kwsënal lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lëë byaani lyu lëë noo ptsiñ chu nis nii nche Sidón. Siko lëë Julio pkëstyoo Pable, lëë xaa blaa kutedy Pable kchë lo xamigw ni lëë xaa blaa ptee meñ go nii pkiiñ Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tsiñee lëë noo pchoo Sidón, lëë noo byoteedy chu kislyu wiñ nii lë Chipre, porñee tir xpi me. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lëë noo ptyeelaag nistoo mer laañee nyoo Cilicia ni Panfilia, aan lëë noo ptsiñ tu kyedzy nii ngab Licia nii lë Mira. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Siko lëë xaa nii xñabey lo soldad kon tu xbarkw meñ Alejandría nii no nëz tsi nëz Italia, aan lëë xaa blëp lëë noo barkw par kyo noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ndaly kpidz tseyga kwyo barkw nëz, aan tsiñee lëë noo ptsiñ laañee nyoo Gnido, blaadre me nyo noo par delanty. Por ngo lëë noo ptyee mer laañee nyoo kyedzy nii lë Salmón nii nche lo kislyu wiñ nii lë Creta. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Në syo noo tub chu nis, per lëë noo ptsiñ tu lugar nii lë Buenos Puertos. Kexka siko nche kyedzy nii lë Lasea. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kok xtsele ncheno noo lo nis, ni ntseeble gaa së barkw lo nistoo, porñee lëë mëë nii chaknal sëëd yob. Por ngo lëë Pable kwnee chëb: ");
INSERT INTO ztqNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Kol kono gaanoo, chanaa gon nii ntseeb ktsyool no tu kyalnë deelñee kyore no tub lo nis. Neñdy kloow no barkw tyub xyowo, ni ntseeb kety no. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per psaldy xaa nii xñabey lo soldad Pable, sink lëë xaa psoob xtiits xpixwan barkw ni xtiits xaa nii chuuñ ksëë barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Aan como nguidy nak chu nis ko par kwës meño mëë nii chaknal, kchësy xaa kwlokyeñ nii masy buen kchoo noo siko, parñee tsaap schilo ktsiiñ noo Fenice aan tyeedy noo mëë nal siko. Fenice nak tu kyedzy nii ngab Creta. Siko xtsiñ barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Aan como lëë tu me wiñ nii sëëd nëz kyety bislo xpi, nladzy xaa nii sini lëë noo nii schilo kchoo noo siko. Lëë xaa pchooni barkw tub chu nis Creta. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per kok xtsedyak pchoo barkw tsiñee lëë tu medox nii lë Nordeste ");
INSERT INTO ztqNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","bislo kwtopxax barkw. Aan como blaady me nyo noo par delanty, lëë noo blaa biy me lëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Byoteedy noo tublad chu kislyu wiñ nii lë Clauda. Xisy xpi me siko. Por ngo nikxe në pkyëë noo, per lëë noo bliis canow wiñ nii sëëdngopxax barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Loxsye byëp canow wiñ go, lëë xaa nii sini barkw pxituu tsiitsy barkw con tuu. Ptsyeb xaa nyisobnag barkw lo yuzh nii lë Sirte. Por ngo lëë xaa blity ladx nii kë kik barkw, ni lëë xaa blaa sini me barkw laañee xkaatyee. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Lëë byaani lyu lëë xaa bislo blaal xaa xyow barkw lo nis porñee lëë medox ko bii xpi. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lëë tse nii kwloxo tson kpidz lëë xaa go blaal kchë xtsiiñ barkw lo nistoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ndaly kpidz ptyoondy noo lo ngbidz ni ptyoondy noo mëly. Tir ntseeb bi medox ko. Por ngo nii nladzy noo nii sikootyee nyaan noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Aan como kokle ndaly kpidz nii karty tyaaw noo, lëë Pable kusoli groltyee lady kchë xaa nii sini lëë noo aan lëë xaa chëb: —Deelñee nyon do xtitsaa nii nchoody no Creta, ntsyooldy no kchë kyalnë re ni nsëëbty no xyow barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per na xa kuuñre no. Lëëw ptsyool le no. Per pe tsinidy kik to. Nikxe nitylo barkw re lo nis, per ni tu do kejty. Ktsyebty to. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Porque tsikyool lëë tu angly byaklo lon. Lëë Dios nii xñabey naa pxaal angly ko biidnë lon sinrii: ");
INSERT INTO ztqNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","“Ktsyeebtyoo, Pable, porque no nii ktsiiñoo lo xtisy Roma, aan por lii lëë Dios kteelaa kchë xaa nii ksal no leñ barkw.” ");
INSERT INTO ztqNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Por ngo, kol ko nguiool styoo do, ktsyebty to, por xniladzyaa xtiits Dios ni xniladzyaa nii lëë kchë nii në angly lon kak cumplir. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per tesody nii lëë me tsikchon lëë no tu chu kislyu wiñ nii nche lo nis re. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Lëë kyool nii kwloxo chop xmal nii kënsëë noo lo nistoo nii lë Adria, lëë xaa nii chuuñ ksëë barkw byeñ nii lëë noo mer ktsiñ chu kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lëë xaa ptiix dyon pe nxityre jkaa lo kislyu. Tsigo lëë xaa kon nii xaktyee skalyptsiipxoopak metre nxity laañee si barkw. Kok xtsedyako lëë xaa ptiix stub aan lëë xaa kon nii xaktyee skalypkyadzyak metre nxity laañee si barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Aan como ptsyeb xaa nyijkaan barkw lo kyo, lëë xaa pchon tap lë kiib nëz xan barkw parñee sëdy barkw. Loxsye ngo lëë xaa kwnab lo Dios nii kyob kyaani lyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mentre gaa lëë kchë xaa nii xkyë tsiiñ leñ barkw kwlokyeñ kxooñ, lëë xaa blity tu canow wiñ nii noy barkw, xkëëlo xaa nii lëë xaa kchon kiib nii kë nëz kë barkw lo nis. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Per lëë Pable kuni tiits lo xaa nii xñabey lo soldad chëb: —Deelñee kwësty ni tu xaa gue leñ barkw, ni tu do telaady. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tsigo lëë soldad koñee pchug tuu nii nxituu canow wiñ go aan lëëw byab lo nis. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Bii nguey, lëë Pable kwnee lo kchësy xaa nii si leñ barkw, chëb xaa: —Natse gon chak chop xmal nii karty kaw do por kyalnë nii nandy to pe cos ktsyool no. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Xñabaa nii kaw do parñee jkaa do fuersy telaa do, por ni tu kits kik to kloowdy to. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Loxsye chëb Pable ngo, lëë xaa kwseñ tu kyaxtily aan xña lo kchësy xaa go lëë xaa ptee skizh lo Dios. Tsigo lëë xaa bislo wagw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Lëë styoo kchë xaa go byonguiool aan lëë xaa taw kchë xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Choop kyoow tsongaly ptsiipxoop noo syo leñ barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Tsi lëë wagw kwlox lëë xaa blaal xobxtily nii noy barkw lo nis parñee knitynë barkw. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Tsiñee lëë lyu byaani, byuumbeydy xaa nii chuuñ ksëë barkw dyon xa lë tañ nii nche noo. Per lëë xaa kon tu kislyu wiñ nii nche kexka tu chu play, aan lëë xaa kwlokyeñ ktsig xaa barkw siko deelñee ndeedyo tiits. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Lëë xaa pchug tuu nii këtuu kiib nii kë xan barkw aan lëëw byab lo nistoo. Ni lëë xaa bislëë yag nii xchug nis parñee së barkw nëz nii chakladzy xaa. Loxsye ngo lëë xaa blis ladx nii kë kë barkw lo me, aan lëë barkw bislo xpig chu play. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Per lëë kë barkw kwsobtip lo yuzh, pchilodre niw, aan lëë xfuersy nis bislo chuuñ pyuy nëz xano. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tsigo lëë soldad kokladzy nyuty kchë xaa nii sikni xaa tso skiib Roma parñee kxoobnisty xaa aan kxooñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Per como koklasty xaa nii xñabey lo soldad nii nyety Pable, blaady xaa nyuuñtsyey soldad ngo, sink lëë xaa kwnabey nii klo kchë xaa nii chak xoobnis ktsiñ xaa chu kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Lëë kchë xaa nii kokty na nxoobnis ptsiñ lo kislyu con table nii nyaa barkw. Singo mod kchësy noo ptsiñ chu kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tsiñee lëë noo lox ptsiñ chu kislyu go kchësy noo, lëë noo kok ndon nii Malta lë kislyu wiñ go. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mbëë kon meñ nii ncheno siko lëë noo, aan como singootyee chak nal ni so kyo, lëë meñ go psaay ki parñee ktsëë noo. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Lëë Pable kuktop chop lë yag, aan lëëw no ktsiib xaa lo ki, tsiñee lëë tu mëël nii no lady yag pchoo por xinlëë ki, aan lëë ma pchal ña Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tsiñee lëë meñ nii no lo kislyu wiñ go kon nii lëë mëël go kënyoogw ña Pable, lëë meñ go bislo xñee lo xcombañer: —Neñdy tu nweety bñech nak xaa gue. Ngo nii nikxe lëë xaa kwtelaa lo nistoo, per xlaady xkyalxtisy Dios kpañ xaa axte nii kizh xaa xtol xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Per lëë Pable kwtsib ña aan lëë mëël go byab lo ki, per lëë lëë xaa, ni tu pe kokty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Kchësy meñ kwche mbës nii nsyëki ña xaa o kolpsye gaa nyety xaa. Per kok xtsesy nche mbës meñ kon meñ nii ni tu pe chakty xaa. Lëë meñ bislo ptsëë xtiits, xñee meñ nii tu dios nak Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kexka siko kë xkwaa xaa nii xñabey lo kislyu wiñ go. Publio pcholë xaa. Lëë noo byolëës lidzy xaa aan mbëë kon xaa lëë noo tson kpidz nder. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aan lëëtyee gaa leñ tse go lëë pxosy Publio nix no xlyëë ni kë yoobcheñ. Lëë Pable kutedy lo xaa, aan loxsye kwnab Pable lo Dios por lëë xaa, lëë Pable pxob ña lady xaa aan lëë gaa xaa byak. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tsiñee kon meñ ngo, wi kchë meñ xsyaknë nii no lo kislyu wiñ go biid, aan kchë meñ xsyaknë byak. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Aan mbëëre kontsi kchë meñ lëë noo, aan tsiñee lëë wor kol nii ktsëëp noo barkw stub, bnee meñ go kchë nii jkiiñ loo noo nëz. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tse nii kwloxo tson mëë nii nche noo lo kislyu wiñ go, lëë noo ptsyëëp tu xbarkw xaa Alejandría nii kwlës chu kislyu wiñ go tyub mëë nal. Kë chop mdyo nii xñee xaa Cástor ni Pólux kë barkw ko. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tsiñee lëë noo ptsiñ chu nis nii lë Siracusa, lëë noo blyëës tson kpidz. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Siko pchoo noo lëë noo syo tub chu nis axte ptsiiñ noo laañee lë Regio. Lëë byaani lyu lëë tu me nii xchoo nëz kyety bislo xpi. Lëë tse nii pchopo kpidz lëë noo ptsiñ kyedzy nii lë Puteoli. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Leñ kyedzy ko lëë noo byo ktsiil bla xaa nii xniladzy xtiits Jesús. Lëë xaa kwnee loo noo parñee kwëës noo lo xaa tu xmal. Lëë tsi lëë xmal go kwyaa lëë noo pchoo siko par ktsiiñ noo Roma. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Lëë gaa meñ nii xniladzy xtiits Jesús nii no Roma tse koknan nii lëë noo no nëz ktsiiñ noo Roma. Ngo nii lëë meñ biid ktsiilnëz lëë noo axte laañee lë Foro de Apio ni laañee lë Las Tres Tabernas. Tsiñee lëë Pable kon kchësy meñ go, lëë xaa ptee skizh lo Dios ni lëë xaa pkaa fuersy. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tsiñee lëë noo ptsiñ Roma, lëë xaa nii xñabey lo soldad ptee tiits nii tso Pable tublad chop tu soldad parñee kap cuidad soldad Pable. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tse nii kwloxo tson kpidz ptsiiñ noo, lëë Pable kwnabey koktsyetsy kchë xaa Israel non nii no Roma. Tsiñee lëë kchë xaa go lox pkaal lsa, lëë Pable chëb: —Beetsy, nikxe gon ni pe beñdyaa lo meñ Israel ni nikxe nii kwneedyaa contre xcostumbre pxusykoltoo no, lëë meñ kwnaasy naa aan lëë meñ pko naa ña xaa Roma leñ kyedzy Jerusalén. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Tsiñee lëë xaa Roma nii xñabey lox kwnabtiits dyon pe nli beeñtsyeyaa kchë nii xkëëkiy meñaa, lëë xaa byeñ nii nody xtolaa ni chigaldy ketyaa. Lëë xaa kokladzy nlaa xaa naa. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per kwxikyaldy xaa Israel. Por ngo lëën kwnab nii yuub xtisy nii sob Roma nu kan dyon xa kak xcuentaa, per kwnabtyaa kyelyaa nu par jkëëkiyaa xaa tu kyedzyaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Por ngo nagon kwtsyetsyaa lëë do parñee kñen choplan xtitsaa lo do. Porque win xniladzy kchë nii xniladzy meñ Israel aan por ngo këtuun nu. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Tsigo lëë kchë xaa nii koktsyetsy ko chëb: —Ni tu xcart xaa Judea karty klyañ loo noo nii kseety lii, ni ni tu xaa betsy no nii chiid nu karty kñee contre lii. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lëë na chakladzy noo tsyon noo dyon xa no kikoo, por ndon noo nii laañee xkaatyee xñee meñ contre lay kub nii xluuyoo. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Lëë xaa pso tu tse nii jkaal lsa xaa, aan singootyee ndaly meñ kwey laañee xkwës Pable. Aan destye wor silytoo axte ptsye tse bluuy Pable xa nak xkyalwnabey Dios. Pseety xaa xley Moisés ni kchë nii pkëë profet parñee jko xaa styoo meñ kniladzy meñ xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Grol meñ bniladzy nii kwnee Pable, lëë stu grol meñ koñee bnilastyo. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Aan como lëdy kchë meñ bniladzy, lëë meñ bislo bi. Tsigo lëë Pable chëb: —Nli gak nii kwnee profet Isaías tsiñee por xKyalbini Ntson Dios chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Na kwey aan kudzy lo meñ gue: Nlipee nikxe xaapre kon do, per kyeñdy to, ni nikle gaa kuy do, per kandy to. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Por lëë kchë styoo meñ lox pkyedzy, ntse tyag meñ, ni ndiib lo meñ. Kchë nrii ptsyool meñ parñee kchilody kan meñ, ni kon meñ, ni kyeñ meñ. Ni lëë meñ ptsyool kchë nrii parñee ktikchedy meñ styoo lon tsiin ktsilyaa xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kol kaknan nii destye natse lëë xkyalwtelaa Dios tsi lo meñ sit. Meñ gosy skëëtyag xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Tsiñee lëë Pable lox chëb ngo, lëë xaa Israel bi, per tir ptilytiits lsa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Chop iz nder kwtiñ Pable tu yu leñ kyedzy Roma, aan leñ yu go kutedy meñ lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Mbëë bluuy xaa xa nak xkyalwnabey Dios lo meñ ni bluuy xaa xtiits Dios nii xñee cho nak Jesús. Ni tu cho pe chëbty lo xaa.");
INSERT INTO ztqNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paablaa. Xtsiiñ Jesucrist xkyën. Lëë Dios kwtsyetsy naa parñee kakaa xapostle xaa parñee kluyaa tiits nii xteelaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Penaadle bluuy Dios tiits re. Ndaly profet pkëëw leñ kitsy nii kë xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Lëë tiits re xñee cho nak Jesucrist, Xiñ Dios. Lo xtiiy rey David sëëd xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Per por xkyalwnabey Kyalbini Ntson lëë xaa kok Xiñ Dios, porñee pañ xaa lo kyalkuty. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Por Jesucrist lëë Dios bnee tiits nii kakaa apostle parñee tyub lo kislyu tso meñ nii kniladzy xtiits xaa ni ksoob xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Lady meñ nii kwtsyetsy Dios jkab lo Jesucrist ngab to. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Lëë Dios xkëstyoo lëë do kchë do siñee no do leñ kyedzy Roma, ni lëë xaa kwle lëë do parñee jkab to xkyedzy xaa. Lëë lëësy Tat Tios dyon ni lëë lëësy Jesucrist kakni lëë do ni knee tiits nii mbëë kpañ do. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Xtedyaa skizh lo Jesucrist ni lo Tat Tios por lëë do, por laañee xkaatyee chakyety to porñee xniladzy to xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Aan lëë Dios chan nii tugak xsaladzyaa lëë do tsiñee chutiitsnin xaa. Xtsiiñ Dios xkyën. Tyub styoon xluyaa xtiits xiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Tugak xñabaa lo Dios nii knee xaa tiits kyely teedyaa lo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Por chakladzyaa kanaa to parñee jkaa do xkyalnsaak Dios tsiin kchosody styoo do, ");
INSERT INTO ztqNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","sinak nii xñee ñe, parñee kchoobladzy lsa no styoo no porñee xniladzy no xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Beetsy, kol kaknan gaanoo nii ndaly vuelt kwlokyeeñaa kyelyaa lo do, per xtejtyo tiits. Chakladzyaa kyelyaa parñee ktopaa kyalnsaak sinak nii xtopno stub lugar. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","No nii kluyaa xtiits Dios lo kchë meñ, nikxe lo meñ nii no kyedzyo, nikxe gaa lo meñ nii no taño, nikxe lo meñ nyaaniw, nikxe gaa lo meñ ngueyo. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Por ngo nii xtee gaanaa kyely kluyaa xtiits Dios wi lo do nii no do leñ kyedzy Roma. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Xtelastyaa xtiits Dios nii xteelaa, por xkyalwnabey Dios nako parñee kteelaaw kchë meñ nii xniladzyo. Klo meñ Israel telaa. Tsigore telaa meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Lëë tiits re xñee nii lëë Dios xteelaa lëë no lo tol porñee xniladzy sye no xtiits xaa. Ni leñ kitsy kaa nii kë xtiits Dios xñee: “Por kyalwniladzy lëë xaa nii buen kpañ.” ");
INSERT INTO ztqNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Xtyon no nii lëë xcastigw ntseeb Dios sëëd kpaa parñee ksaksi xaa kchë meñ yox ni meñ mal, por xlaady xtol kchë meñ go jkaasy xtiitsli Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Aan nan meñ go cho nak Dios, por misme Dios bluuyo. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Schilo kak nyoo nii nyoody por kchë cos nii psaa Dios. Destye nii kwche kislyu kok nyoo nii lëë xaa nak Dios ni kyaaldy kaa xkyalwnabey xaa. Por ngo nii kindy pe jkëëlo meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Per nikxe xyuumbey meñ go Dios singo mod, chuuñ ksakty meñ go Dios ni xteejty meñ go skizh lo xaa. Al contrario cos nii pa xkiiñdysye sini kik meñ go, ni lëë xkyalcheñ meñ go pkyey. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Nikxe nii xñee meñ go nii nyaani meñ go, per nguey meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Por lëë meñ go psaan xkyalntson Dios nii xnitylody por mdyo nii chak si chak chol meñ, ni por mdyo nii nyaa si nyaa mguiñ, ni por mdyo nii chak si chak ma nii sob tap niy, ni ma nii xtyoopxax. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Por ngo lëë Dios psaanladzy meñ go parñee kuuñtsyey meñ go kchë cos mal nii no styoo meñ go. Aan chuuñtsyey meñ go cos nii xkwii kyalto kchë xcombañer, ");
INSERT INTO ztqNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","porñee xnilasty meñ go xtiitsli Dios, sink tiits xuuy xniladzy meñ go. Xsoxib meñ go lo kchë cos nii psaa Dios. Xsoxibty meñ go lo Dios nii psaaw. Por lëë Dios xyal jkaa skizh tugak. Singo no nii kako. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Por ngo lëë Dios psaanladzy meñ go parñee kuuñtsyey meñ go cos nii xkwii kyalto. Por axte wi kwnaa ptsëë xmod. Choni me saa kwnaa me. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Singo gak xaapkiy, chokidre xaa kwnaa, sink saapkiy xaa choki xaa. Chuuñtsyey xaa cos nii xkwii kyalto ksa saapkiy xaa, aan mban xtye xcuerp xaa castigw por cos mal nii chuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Chaklastre xaa ksal xaa Dios, aan lëë Dios kaa psaanladzy xaa parñee kuuñtsyey xaa nii chigaldy kak. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Kchëlo cos mal no kik xaa, mal xaa, ngbiñ xaa, mbidy xaa, nweety bñech xaa, xtilyni xaa meñ, wnee xuuy xaa, ni wagw tiits kizh xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Xñeenë xaa meñ, xtilyni xaa Dios, xekwty xaa lo meñ, nyaa xaa, chuuñtsyey xaa cos mal, ni xsoobty xaa xtiits pxosy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Chondy xaa tiits, chuñdy xaa cumplir xtiits xaa, xkëstyoody xaa meñ, xkombedy xaa styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Nan xaa nii lëë Dios xñabey kety kchë meñ nii chuuñtsyey ngo, per lëëw chuuñtsyey xaa, aan axte xle xaa chan xaa meñ nii chuuñtsyeyo. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Por ngo kindy pe jkëlool, lii nii xseel meñ, deelñee chootyee nakoo. Misme lii xtee kyo lii tsiñee xseel meñ, por chuuñtsyeyoo nii chuuñtsyey meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Por ndon no nii tsiñee lëë Dios chuñ kyalxtisy, xsaksi xaa meñ nii chuuñtsyey kchë ngo. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Aan lii nii xseel chanoo nii chuuñtsyey meñ aan chuuñtsyeylo, ¿pe xsyakoo nayak nii stelaal lo xkyalwsaksi Dios? ");
INSERT INTO ztqNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","¿Pe xsyablyul xkyalndoladzy Dios nayak ni xpaciency xaa? ¿Xyeñdyoo nayak nii lëë xkyalndoladzy Dios xtsig lii lo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Per nguiedzy styool ni chaklastyoo ktikcheel styool lo Dios. Por ngo lëël xyuubre kyalnë par tse nii lëë Dios kiid kuñ kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Lëë xaa kizh meñ según kchë nii beeñtsyey meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lëë Dios ktee kyalmbañ nii nitylody lo meñ nii tugak beeñtsyey kyalbuen ni tugak beeñ ksak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Per lëë xaa ksaksi meñ nyaa nii xsaldy tiitsli ni meñ ngoptol. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","So kyalwsaksi ni kyalnë par kchë meñ nii chuuñtsyey kyalmal, klo par meñ Israel, tsigore par meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Per lo meñ nii chuuñtsyey kyalbuen lëë Dios ktee kyalnsaak parñee mbëë kpañ meñ go. Klo gak lo meñ Israel ktee xaaw, tsigore lo meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Por lëdy wi Dios xkwe meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Por kchë meñ sit nii beeñ tol aan nandy meñ go nii no xley Moisés, tsody ley tsiñee lëë meñ go kety. Per lëë xkyalxtisy meñ Israel nii beeñ tol kak sinak xñabey xley Moisés. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Por xtyelaady meñ nii xkëëtyag nii xñabey ley, sink meñ nii chuuñtsyey nii xñabey ley xtyelaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Per tsiñee lëë meñ nii nandy nii no ley chuuñtsyey nii xñabey ley, misme meñ go xsaa ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Por kchë nii chuuñtsyey meñ go nyoo nii leñ styoo meñ go no ley. Ni misme gaa xkyalcheñ meñ go ksoli meñ go o ksyablyu gaa meñ go ");
INSERT INTO ztqNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","tse nii lëë Dios ni lëë Jesucrist kuñ xkyalxtisy meñ según kchë nii no kik meñ. Lëë xtiits Dios nii xluyaa xñee nii singo kako. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Per lii nii xñeel nii meñ Israeloo, ni xsyeeñoo xley Moisés ni xtaanoo Dios, ");
INSERT INTO ztqNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","nanoo pe cos chakladzy Dios. Ni xluuy ley lool nii no nii kwel cos mbëë. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Xsyakoo nii lii kob ña meñ nii xñady lo ni ksaabini lo meñ nii so lo nguey. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Xsyakoo nii schilool kuuñ kseedyoo meñ nguey ni kñeel lo meñ mban, por nanoo nii lo xley Moisés kë kyalchak ni tiitsli. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Deelñee chuuñ kseedyoo meñ, ¿penak nii chuuñ kseejtyoo lii? Deelñee xluuyoo nii ndox kwan meñ, ¿penak nii xkwanoo? ");
INSERT INTO ztqNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Deelñee xñeel nii ndox tsoni meñ stu kwnaa o stu mguiy deelñee no tsiil meñ, ¿penak nii chuuñtsyeyoo singo? Deelñee xlëël chanoo mdyo, ¿penak nii xkwanoo nii no xiktoo mdyo? ");
INSERT INTO ztqNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Xtaanoo xley Moisés, per xsyablyul Dios tsiñee xsaldyoo ley go. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nli gak nii xñee kitsy nii kë xtiits Dios: “Por lëë do, xñeenë meñ sit Dios.” ");
INSERT INTO ztqNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Xkiiñ kyalwyobey palalsye deelñee xsaloo xley Moisés, per deelñee chuuñtsyeydyoo nii xñabey ley, pe nandy nii kwyobeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Per deelñee no xaa nii nobeydy aan chuuñtsyey xaa nii xñabey ley, sak cuent nii nobey xaa, nikxe nii nobeydy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Kchë xaa nii nobeydy xcuerp, per chuuñtsyey xaa nii xñabey ley, ksee kan lii. Por chuuñtsyeydyoo nii xñabey ley, nikxe nii xyeeñlo ni nobeyoo. ");
INSERT INTO ztqNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Por lëdy laa klaasy kak no meñ Israel, ni lëdy xaktyee porñee nobey xcuerp now, ");
INSERT INTO ztqNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","sink tyub styoo no no nii kak no meñ Israel, ni no nii tsobey styoo no. Këdy kchë ngo lo kitsy, sink styoo no now. Kchë xaa nii nak singo xsolidy chol meñ xaa, sink Dios xsoli xaa go. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","¿Pe non dyon nii kak no meñ Israel, ni pe non nii tsobey no? ");
INSERT INTO ztqNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nono gon. Por lo meñ Israel psaan Dios xtiits. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","¿Pe kok tsigo worñee pchooxso meñ Israel? ¿Pe ptsëë Dios lo xtiits nayak? ");
INSERT INTO ztqNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Lëdyo gon! Tugak xñee Dios tiitsli nikxe kchë meñ xñee xuuy, por leñ kitsy nii kë xtiits xaa xñee: Sak meñ nii bueenoo por kchë nii xñeel, ni mbëë kchukëël tsiñee kak kyalxtisy. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Per deelñee por xtol no chak nyoo xkyalbuen Dios, ¿pe mal Dios porñee xsaksi xaa lëë no? No meñ xñee nii nliw. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Per ¡lëdyo gon! Por deelñee nyak mal Dios, ¿xa kuñ xaa kyalxtisy lo kislyu? ");
INSERT INTO ztqNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Per deelñee xkiiñ xtiits xuuyaa parñee kak nyoore xtiitsli Dios, ¿penak tsigo xsyak xaa nii no xtolaa? ");
INSERT INTO ztqNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Deelñee nyako singo, ¿penak nii chuuñtsyeydy no cos mal parñee kiid cos buen? No meñ xñee nii ngo xluyaa par ksyablyu meñaa, per nonguial ksaksi Dios meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Pe tyeesy no dyon? ¿Pe mastre nayak buen no que meñ sit? ¡Lëdyo gon! Por ndon no nii nikxe meñ Israel no, nikxe gaa meñ sit no, ña tol no no. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Leñ kitsy nii kë xtiits Dios xñee: Kindy meñ buen, ni tu meñ buen nody. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kindy meñ nii xyeñ, kindy cho kyub Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kchësy meñ këtañ, kchësy meñ byab lo tol. Kindy cho kuñ kyalbuen, ni tu cho kindy. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Nak yañ meñ sinak tu paa nii nyaly, con ludzy meñ xñee xuuy meñ, xvenen mëël xchoo chuw meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Nonsyke cos mal ni tiits në xchoo chuw meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ligier xsyë meñ par kuty meñ, ");
INSERT INTO ztqNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kchë nii chuuñtsyey meñ xnitylo ni xsaksi, ");
INSERT INTO ztqNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","nandy meñ xa tso mbëë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Sinidy xkyalntseeb Dios kik meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ndon gaa no nii kchë nii xñee xley Moisés, lo meñ nii sinalo xñeew, parñee kyoogw chuw kchësy meñ ni parñee kchësy meñ kyab lo xkyalxtisy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Por ni tu tol ktsildy Dios porñee sinal meñ ley, por xaktyee parñee kñë ley nii no xtol no xkiiñ ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lëdy por ley telaa no, por lëë Dios bluuy nii no stu mod nii telaa no, aan kchë ngo xtyoon tsiñee xkab xley Moisés ni xlibre profet. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Lëë Dios xteelaa lëë no porñee xniladzy no xtiits Jesucrist. Xkwedy xaa meñ, sink kchë meñ nii xniladzy xtiits Jesucrist xteelaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Por kchësy meñ no xtol ni kchësy meñ nche sit lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Per por xkyalnsaak Dios lëë xaa xteelaa meñ singosy, porñee xniladzy meñ xtiits Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Lëë Dios pso Crist parñee por xkyalkuty Crist kpily xtol no deelñee kniladzy no xtiits xaa. Aan lëëw kok singo parñee kak nyoo nii buen Dios. Psaldy Dios tol nii beeñtsyey meñ tiemp ");
INSERT INTO ztqNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","porñee kop xaa paciensy, nikle gaa nina nyoo nii buen Dios, por lëë xaa xteelaa kchë meñ nii xniladzy xtiits Jesús. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","¿Pa byaan xkyalnyaa no tsigo? Lëëw bichee gon. ¿Penak dyon bicheew? ¿Pe porñee chuuñtsyeey no nii xñabey xley Moiséso? Lëdyo, sink porñee xniladzy no xtiits Jesucristo. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Xtyon no tsigo busy nii lëë Dios xteelaa meñ porñee xniladzy meñ xtiits Jesucrist. Xteelaady xaa meñ porñee chuuñtsyey meñ nii xñabey ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Pe xaktyee meñ Israel nayak xteelaa Dios? ¿Pe lëdy wi meñ sit nayak xteelaa xaa? Wi meñ sit gon xteelaa Dios, ");
INSERT INTO ztqNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","por tugak Dios no. Lëë Dios xteelaa meñ nii xniladzy xtiits Jesucrist. Xkwenjty xaa deelñee nobey meñ o nobeydy kaa meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","¿Pe porñee xniladzy no xtiits Jesucrist tsigo, lëë no ksyablyu xley Moisés? ¡Lëdyo gon!, sink lëë no xlisklaa ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","¿Pe styeesy no tsiñee kseety no pxusykoltoo no Abraham? ");
INSERT INTO ztqNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Deelñee nyak Abraham tu xaa buen por xtsiiñ xaa, nyo pe ndaan xaa, nikxe nii ndaandy xaa lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","¿Pe lëdy nayak xñee kitsy nii kë xtiits Dios: “Bniladzy Abraham xtiits Dios, por ngo lëë Dios beeñ cuent nii buen xaa”? ");
INSERT INTO ztqNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Lëë nana, deelñee xkyë tu xaa tsiiñ, chayjty xaa nii chazh xaa, sink nii nsëëb meñ lo xaa xkaa xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Per deelñee no tu xaa nii xniladzy xtiits Dios nii xteelaa meñ lo tol, lëë Dios chuñ cuent nii buen xaa porñee bniladzy xaa, nikxe nii beeñtsyeydy xaa ni tu cos par tsigal xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Lëë rey David xñee xa xle xaa nii xsaldy Dios xtol, sink chuñ Dios cuent nii buen xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Chëb rey David: Dichos meñ nii ptsily Dios xtol aan psaldy Dioso. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Dichos meñ nii chuñdy cuent Dios xtol. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿Pe par meñ nii nobeysye dyon nak kyalwle re, ote wi par meñ nii nobeydyo yak? Lëë noo bñeel gon nii lëë Dios beeñ cuent nii buen Abraham porñee bniladzy Abraham. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Per ¿pa wor dyon beeñ Dios cuent nii buen Abraham? ¿Pe loxsye kwyobey xaaw, ote klow yak? Klow. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Aan tsigore kwyobey Abraham parñee kak nyoo nii lëë Dios beeñ cuent nii buen xaa porñee bniladzy xaa xtiits Dios. Por ngo lëë Abraham byak pxosy kchësy meñ nii nobeydy nii xniladzy xtiits Dios, ni por ngo lëë Dios chuñ cuent nii wi meñ go buen. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ni lëë Abraham nak pxosy meñ nii nobey nii xniladzy xtiits Dios sinak nii bniladzy Abrahamo worñee karty tsobey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Lëë Dios chëb lo Abraham nii lëë xaa kyaani kislyu kchë meñ lidzy xaa. Per chëbty Dios ngo porñee beeñtsyey Abraham nii xñabey xley Moisés, sink porñee bniladzy Abraham xtiits Dioso ni porñee beeñ Dios cuent nii buen xaaw. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Por deelñee xaktyee meñ nii chuuñtsyey nii xñabey xley Moisés jkaa nii ksaan Dios, pa xkiiñdy tsigo nii kniladzy meñ xtiits Dios, ni lëë tiits kaa nii psaan Dios kyablyu. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Por xsaksi ley, per laañee kindy ley, kindyak cho ko falt. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Lëë Dios beeñlay Abraham porñee bniladzy Abraham xtiits xaa, aan kchë meñ nii xniladzy xtiits Dios xkaa kyalnsaak ko singosy. Lëdy xaktyee par meñ nii chuuñtsyey nii xñabey xley Moisés nak kyalnsaak ko, sink wi par kchë meñ nii xniladzy xtiits Dios sinak bniladzy Abrahamo. Lëë Abraham nak pxosy kchësy meñ nii xniladzy xtiits Dios, ");
INSERT INTO ztqNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","sinak nii xñee leñ kitsy nii kë xtiits Dios: “Lëën byuñ lii pxosy ndaly meñ nii nche tyub lo kislyu.” Dios nii chuuñ kpañ meñ kuty ni xko cos nii nody bniladzy Abraham. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nikxe kwyody pe nsaladzy Abraham, lëë xaa bniladzy xtiits Dios, aan singo mod lëë xaa byak pxosy ndaly meñ nii nche tyub lo kislyu. Por lëë Dios chëb lo xaa: “Lëë kchë meñ nii jkab lo xtiiyoo ktyaly.” ");
INSERT INTO ztqNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Pchosody styoo Abraham, nikxe nii tsel tu kyoow iz xaa, ni nikle nan xaa ni nii lëë xaa ni nii tsiil gaa xaa Sara chilody kap mëëd. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Pkandy kik xaa ni psaanlasty xaa tiits nii psaan Dios lo xaa, sink tyub styoo xaa bniladzy xaaw ni ptee xaa skizh lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Tyub styoo xaa bniladzy xaa nii chuñ Dios cumplir xtiits. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Por ngo nii lëë Dios beeñ cuent nii buen xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Lëdy por Abrahamsye xñee leñ kitsy nii kë xtiits Dios nii lëë Dios beeñ cuent nii buen xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Wi por lëë now. Por lëë Dios chuñ cuent nii buen no kchë no siñee xniladzy no xtiits xaa nii beeñ kpañ Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Lëë Jesucrist kuty lo crusy por kchë xtol no, ni lëë xaa pañ parñee kteelaa xaa lëë no lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Na nii lëë no kwtelaa lo tol porñee bniladzy no xtiits Dios, mbëë nche no lo Dios por Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Por Jesucrist kwaa no xkyalnsaak Dios porñee bniladzy no xtiits xaa. Tsiitsy nche no lo xtiits xaa ni xle no nii lëë no jkaa xkyalwnabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ni lëdy kaa por ngosy xle no, sink xle no lo kyalnë, por ndon no nii lëë kyalnë xnee kyalndaan lo no parñee kaap no paciensy. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Aan lëë paciensy chakni lëë no parñee buen kchukë no lo Dios, aan loxsye kchukë buen no, mastre kniladzy no xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Aan kyaan maldy tiits ko lo no, por lëë Dios bnee xKyalbini Ntson lo no porñee xkëstyoo xaa lëë no. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Por worñee karty kchilo telaa no, lëë Crist kuty por kchë meñ ngoptol worñee lëë tse kutsiñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Lëdy likasy kety meñ xcuent stu meñ, nikxe nii neñdy so tu xaa nii kety xcuent tu meñ buen. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Per nyoo nii xkëstyoo Dios no, por lëë Crist kuty por lëë no worñee bii ngoptol no. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Lëë nana nii lëë no kwtelaa lo tol por xkyalkuty Jesucrist, lëë no telaa lo kyalnë dox nii kiid. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Por deelñee big no lo Dios por xkyalkuty xiñ xaa worñee bii xtilyni no xaa, pe lëëdyxe nina tsigo nii lëë xiñ xaa mbañ. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ni xle gaa no lo Dios por Jesucrist, porque por Jesucrist big no lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Por tugak xaa kwyo tol lo kislyu aan lëë tol biidni kyalkuty. Singo mod kchë meñ pchal kyalkuty, por kchë meñ kwloo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Antes nii nyo ley, lëë tol tse no lo kislyu, nikxe nii chakty cuent nii no tol tsiñee kindy ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Per destye xtiemp Adán axte xtiemp Moisés lëë kyalkuty ptaan lo xaa nii kwloo tol, nikxe nii beeñtsyeydy xaa si beeñtsyey Adán worñee psoobty Adán xtiits Dios. Lëë Adán kok sinak xaa nii tsigore biid. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Per nakty tol nii beeñtsyey Adán sinak nii xneetsy Dios lo no. Por xtol tugak xaa ndaly meñ kuty. Per lëë kyalwtelaa nii xkady Dios, por tugak xaa biido, aan mastre ntsono, por ndaly meñ xteelaaw. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nakty xtol Adán sinak xkyalnsaak Dios. Por tugak tol biid castigw, per lëë xkyalnsaak Dios xtsily kchë kchësy xtol meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Per deelñee xaktyee por xtol tu xaa ptaan tol, mastre no nii ktaan meñ nii ptsily Dios xtol singosy. Xtaan meñ go, por lëë meñ go mbañ sinak xñabey Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Deelñee xaktyee por xtol Adán lëë xtol kchësy meñ kwyo, singo gak xaktyee por xkyalbuen Jesucrist pteelaa xaa kchësy meñ lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Porñee psoobty tugak xaa tiits, lëë xtol kchësy meñ kwyo, per singo gak porñee psoob tugak xaa tiits, lëë meñ telaa lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Lëë ley biid parñee ktyaly tol, per tsiñee lëë tol lox ptyaly, mastre ptyaly xkyalnsaak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Lëë tol biidni kyalkuty. Lëë gaa xkyalnsaak Dios pteelaa lëë no lo tol ni bneetsy tu kyalmbañ nii tsitsiñdy tse nitylo lo no porñee bniladzy no xtiits Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Pe tyeesy no? ¿Pe slyore no tol nayak parñee kak nyoore xkyalnsaak Dios? ");
INSERT INTO ztqNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","¡Lëdyo gon! Lëë no kutyle lo tol. ¿Xa tsyore no lo tol na dyon? ");
INSERT INTO ztqNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","¿Pe nandy to nayak nii lëë no byak tusy ksa no Crist por kyalwchobnis, ni lëë no byak ksa xaa lo xkyalkuty xaa? ");
INSERT INTO ztqNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Por kyalwchobnis lëë no pkyeetsy ksa no Jesucrist ni lëë no kuty parñee kpañ no ni jkaa no tu kyalmbañ kub, sinak nii pañ Jesucrist por xkyalwnabey Tat Tios. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Por deelñee byak tusy no Crist worñee kuty xaa, lëë no kyak tusy xaa tsi lëë no kpañ si pañ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ndon no nii lëë kchë nii xsya styoo no kwë lo crusy ksa Crist parñee nitylow tsiin kñabeytre tol lo no. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Por chilody kñabey tol lo meñ nii chety. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Deelñee ksa no Crist kuty, ndon no nii lëë no tsyo lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Por ndon no nii lëë Crist pañ lo kyalkuty aan kpikchedre kety xaa. Pe kuñtre kyalkuty xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Tsiñee lëë Crist kuty, kaazhkaa kuty xaa lo tol, per lëë xaa pañ parñee tso xaa lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Singo gak lëë do, kol kuñ cuent nii lëë do kuty lo tol, per mbañ do lo Dios, porñee nak ksa do Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Por ngo, klaady to nii kñabey tol lo do, parñee kuuñtsyeydy to nii klyaañtyee styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kteejty to nii kyab to lo tol par kuuñtsyey do cos mal, sink kol tso ña Dios sinak meñ nii kuty ni bikche pañ stub. Kol tso ña Dios par kuuñtsyey do cos buen. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Por kñabeytre tol lëë do, por nodre to ña ley, sink lëë do no lo xkyalnsaak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","¿Pew tsigo? ¿Pe slyo no tol nayak por xñabeytre ley lëë no, sink lo xkyalnsaak Dios no no? ¡Lëdyo gon! ");
INSERT INTO ztqNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Nan nyë do nii deelñee to do lo tu xaa par ksoob to xtiits xaa, xpixwan do nak xaa aan no nii ksoob to xtiits xaa. Singo tsigo busy deelñee ksoob to xtiits tol, lëë do kety, o deelñee ksoob kaa to xtiits Dios, lëë do kyak tubli. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Per skizh Dios nii kchësy to siñee kwyo do lo tol, lëë do psoob xtiits Dios tyub styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Lëë na nii lëë do kwtelaa lo tol, lëë do mbañ sinak xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Xñen si xñee chol meñ, por chilody kyeñ do kchë cos re. Sinak nii ptee do tiits beeñtsyey do kchë cos mal, kol ktee nii kuuñtsyey do cos buen nii xyo styoo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Worñee lëë do bii no lo tol, beeñtsyeydy to nii xñabey Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","¿Per pe cos dyon beeñ do gan? Xaktyee xkyalto do xkwii kchë cos ko nina. Por xaktyee kyalkuty xneetsyo. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Per lëë na nii lëë do kwtelaa lo tol ni lëë do xkiiñ lo Dios, lëë do jkab lo Dios ni lëë do jkaa tu kyalmbañ nii xnitylody. ");
INSERT INTO ztqNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kyalkuty sye xneetsy tol, per lëë xkyalnsaak Dios xneetsy kyalmbañ nii xnitylody, porñee byak ksa no Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Beetsy, xyuumbey do ley ni nan do nii xaktyee tsiñee mbañ meñ xñabeyo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Sinak tu kwnaa nii xtsiilña, no nii tsoni me tsiil me mentre mbañ xaa, per deelñee kety tsiil me, lëë me xlyaa lo xley kyalwtsiilña. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Por ngo, deelñee tsoni me stu mguiy mentre bii mbañ tsiil me, tol chuñ me. Per deelñee kety tsiil me, schilo ktsiilña me stu mguiy aan chuñdy me tol, por nonidre me tsiil me. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Singo gak lëë do, beetsy, nii ngab to lo Crist, lëë do kuty lo xley Moisés parñee ktsiilña do stu xaa. Lo Jesucrist nii pañ lo kyalkuty ngab to nina. Singo mod lëë no jkiiñ lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Worñee pañ no sinak cho xaa ngoptol, lëë ley psoob ki kyalmal nii no leñ styoo no aan lëë kyalmal go beety lëë no. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Per lëë na nii lëë no kuty lo ley nii pkëëtuu lëë no, lëë no kwlaa parñee jkiiñ no lo Dios sinak xñabey Kyalbini Ntson, lëdy sinak xñabey ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","¿Pe styeesy no tsigo nayak, nii tol xley Moisés? ¡Lëdyo gon! Per deelñee nyody ley, nyaknandyaa nii no tol. Nyaknandyaa nii ndox tsokin xcheñ meñ deelñee nyeedy ley: “Tso kidyoo xcheñ meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Per lëë tol kwseñ ley parñee ksoobkiw kchë cos mal nii no leñ styoon. Por deelñee kindy ley, pa nondy tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Worñee byuumbeydyaa ley, pañaa. Per tsiñee lëën byuumbey ley, lëë tol nii no leñ styoon pkaa fuersy aan lëën kuty. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Singo lëë ley nii bneetsy kyalmbañ lon beety naa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Por lëë tol kwseñ ley aan lëëw pkëëti naa aan misme con ley beetyo naa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ntson xley Moisés, ni buen nii xñabey ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","¿Per pe buen ley tsigo aan beetyo naa? ¡Lëdyo gon! Lëë tol beety naa aan singo kok nyoo nii tolo. Kwseñ tol cos buen par kutyo, aan singo mod kok nyoo nii tir mal tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ndon no gon nii lëë Dios pxaal ley, per xaa lo kislyun aan lëë tol xñabey naa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Xyeñdyaa penak xtsyolaa nrii. Por chuuñtsyeydyaa nii chakladzyaa, sink nii xyody styoon chuuñtsyeyaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Per deelñee chuuñtsyeyaa nii chaklastyaa kuuñtsyeyaa, xyeñaa nii buen ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Por ngo lëdre naa chuuñtsyey kchë cos ko, sink tol nii no leñ styoono. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Por nanaa nii xaa lo kislyun aan nody cos buen leñ styoon. Chakladzyaa kuuñtsyeyaa cos buen, per chilody kuuñtsyeyno. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Chuuñtsyeydyaa cos buen nii chakladzyaa, sink lëën chuuñtsyey cos mal nii chaklastyaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Deelñee chuuñtsyeyaa nii chaklastyaa kuuñtsyeyaa, lëdre naa chuuñtsyeyo, sink tol nii no leñ styoon chuuñtsyeyo. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Singo tsiñee chakladzyaa kuuñtsyeyaa cos buen, klol cos mal xchoo leñ styoon. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Xyo xley Dios styoon, ");
INSERT INTO ztqNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","per no tu cos leñ styoon nii xsyonlë lo xkyalcheñaa. Lëë tol nii no leñ styoono aan nguëtuuw naa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","¡Broobaa! ¿Cho kteelaa naa lo tol re? Por lëëw chuty naa. ");
INSERT INTO ztqNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","¡Dios syew gon! Xtedyaa skizh lo Dios, por lëë Jesucrist pteelaa naa. Xyeñaa nii no nii kuuñtsyeyaa nii xñabey Dios, per como xaa lo kislyun, lëën këtuu lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Kintre pe cos kyëkiy xaa nii nak ksa Crist. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Lëë kyalbini mbañ nii xnee Jesucrist pteelaa lëë no lo xley tol ni lo kyalkuty. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Por lëë Dios beeñtsyey nii pchilody xley Moisés. Lëë ley go byab lyu por xtol meñ. Lëë Dios pxaal xiñ sinak tu xaa nii no tol, aan biid xiñ xaa sinak chol meñ lo kislyu, parñee kuñ xaa gan lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Singo biid xaa parñee kchilo kuuñtsyeey no nii xñabey ley, por mbañtre no sinak no chol xaa lo kislyu, sink lëë no mbañ sinak xñabey xKyalbini Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Kchë xaa nii mbañ sinak mbañ chol meñ, nii nosy lo kislyu sini kik xaa. Per lëë xaa nii mbañ sinak xñabey Kyalbini Ntson, ngosy sini kik xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Aan kyalkuty xtsyool meñ nii sini kik cos nii chak lo kislyu re, per mbëë kpañ meñ nii chuuñtsyey nii xñabey xKyalbini Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kchësy meñ nii xaktyee cos lo kislyu re sini kik xtilyni Dios, por chaklasty meñ go ni chilody meñ go ksal xley Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Por ngo chuuñ ksakty meñ go Dios, por nii xlyaañtyee styoo meñ go chuuñtsyey meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Per lëë do chuuñtsyeytre to nii chuuñtsyey kchë meñ nii no lo kislyu, sink sinak xñabey Kyalbini Ntson mbañ do, deelñee busy no Kyalbini Ntson leñ styoo do. Kchë meñ nii nody xkyalbini Crist leñ styoo, ngabty meñ go lo Crist. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Per deelñee no Crist leñ styoo do, mbañ xkyalbini do, por lëë Dios pteelaa lëë do, nikxe nii lëë xcuerp to kety por tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Aan deelñee no xkyalbini xaa nii beeñ kpañ Crist lo kyalkuty leñ styoo do, yuub xaa knee kyalmbañ lo do por Kyalbini Ntson nii no leñ styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Singo tsigo busy, beetsy, nsëëb no tu cos, per nsëëbty now lo tol, parñee tsyo no si cho chol meñ lo kislyu. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Por deelñee kpañ do si klaañtyee styoo do, lëë do kety. Per deelñee kuñ Kyalbini Ntson lëë do yudar parñee ksaan do xtol do, lëë do kpañ. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kchësy meñ nii chuuñtsyey nii xñabey Kyalbini Ntson nak xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Por lëdy kyalbini nii jkëëtuu lëë do nak Kyalbini Ntson nii kwaa do, parñee ktsyeb to stub, sink lëë kyalbini go xyuñ lëë do xiñ Dios parñee këb to nii lëë Dios nak pxosy to. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Lëë Kyalbini Ntson xyak tusy xkyalbini no parñee tyeesy no nii xiñ Dios nak no. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Aan como xiñ Dios nak no, wi no jkaa nii ksaan Dios lo Crist. Deelñee xtyee no kyalnë ksa no xaa, lëë no kyo laañee xñabey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Pa lëdy kyalnë nii xtyeedy no natiemp lo kyalnsaak nii nare tyon no. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Xekwtre kchë nii psaa Dios këmbëso tse nii lëë meñ nii nak xiñ Dios kakyety. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kchë nii psaa Dios byablyu, per lëdy porñee kokladzyo, sink styoo Dios kwlañ nii singo kak. Per kwyo tiits ");
INSERT INTO ztqNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","nii nitylodyo, parñee jkaaw kyalntson nii jkaa meñ nii nak xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ndon no nii mban xtyedy kchë nii psaa Dios. Xkyëw yoob sinak xkyë tu kwnaa nii kap mëëd yoob. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ni lëdy kaa xaktyee kchë nii kwyaa xtye kyalnë, sink wi no, nikxe nii lëë no kwaal Kyalbini Ntson, parñee kak nyoo nii lëë no jkaa nii kneetsy Dios. Xkyëë no tu yoob në, këmbëës no tse nii lëë no kyak xiñ Dios, parñee jkub xcuerp no. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Por porñee pkyëmbëës no, lëë no kwtelaa. Per deelñee nyoo nii këmbëës no, pe nandyo, por lëëw nyool. Deelñee xtyonle no tu cos, penak kyëmbëës now. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Per deelñee këmbëës no tu cos nii xtyondy no, no nii kaap no paciensy kyëmbëës now. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ni lëë gaa Kyalbini Ntson chuñ lëë no yudar lo xkyalmban no. Por nandy no xa kñee no lo Dios, per yuub Kyalbini Ntson xñab por lëë no lo Dios. Tsiitsyweew aan chilody kñee no xa nak nii xñeew con tiits. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Per como nan Dios pe xsya styoo no, nan xaa pe xñee Kyalbini, por lëë Kyalbini xñab nii xyo styoo Dios par meñ nii ngab lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ndon no nii kchë cos no xfavor meñ nii xkëstyoo Dios. Kchë meñ go kwtsyetsy Dios porñee singo kwlaño styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Por kchë meñ nii klo byuumbey Dios, psaanle Dios nii lëë meñ go kak sinak xiñ xaa, parñee kak xiñ xaa xaa non lo kchë meñ nii ngab lo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Aan lëë Dios kwtsyetsy kchë meñ nii psaanle xaa destye klo, ni lëë xaa ptsily xtol meñ nii kwtsyetsy xaa, ni kchë gaa meñ nii ptsily xaa xtol kwaa xkyalnsaak xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","¿Pe tyeesy no tsigo? Deelñee no Dios xfavor no, ¿cho lë nii jkaal lëë no? ");
INSERT INTO ztqNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Per ni Xiñ Dios pkady Dios lo no, sink lëë xaa blaa kuty xiñ xaa por kchësy no. ¿Xa kneesty xaa kchë cos nii jkaa xiñ xaa wi lo no tsigo? ");
INSERT INTO ztqNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","¿Cho jkëëkiy kchë meñ nii kwle Dios na dyon?, con lëë Dios xñee nii nody xtol meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","¿Cho ktee kyo na dyon?, con lëë Jesucrist kuty ni lëë gaa xaa pañ, aan lëë xaa sob kwi Dios nëzli, xñab xaa por lëë no. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","¿Cho lë nii na dyon kuso lëë no lo xkyalwkëstyoo Crist? ¿Pe skwiso kyalnë no, o nii kyënlaag kaa meñ no, o kpiñ gaa, o kyalproob kaa, o kyalntseeb kaa, o kyalkuty kaa? ");
INSERT INTO ztqNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Leñ kitsy nii kë xtiits Dios gon xñee: Por lii ksatyee tse kënal kyalkuty noo. Xsyak meñ noo sinak mëkwxiily nii kety. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Per chuuñ no gan por xaa nii xkëstyoo lëë no. ");
INSERT INTO ztqNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Xyeñpaa nii per ni kyalkuty, ni kyalmbañ, ni angly, ni kyalbini mal, ni nii no natiemp, ni nii nare gaa kiid, ");
INSERT INTO ztqNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ni nii no kpaa, ni nii no gaa leñ kislyu, ni tu cos nii no chilody kuso lëë no lo kyalwkëstyoo nii bneetsy Dios lo no por Jesucrist. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Tiitsli xñen, por xniladzyaa xtiits Crist. Xkëëtiidyaa, por lëë Kyalbini Ntson xñee nii tiitsli xñen. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Xteenën ni tugak xkyë yoob styoon. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Axte xtegaanaa kyaabaa lo kyalsi, ni so sitaa lo Crist, deelñee nchilo nyuñaa meñ tu kyedzyaa yudar. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Meñ Israel nak meñ tu kyedzyaa, aan lëë Dios beeñ cuent nii xiñ Dios nak meñ go. Kwyo Dios lady meñ go ni psaan xaa xley Moisés lo meñ go, ni chëb xaa nii lëë xaa kteelaa meñ go, ni lëë xaa chëb xa kool meñ go lay. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Xaa xñabey nak pxusykoltoo meñ go ni lo xtiiy gaa meñ go pchoo Crist worñee koly xaa. Lëë Crist nak Dios. Kol tsoo ktee no skizh lo xaa tugak. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Per lëdy nii kokty cumplir tiits nii psaan Dios lo meñ Israel, sink koktyo par meñ Israel nii ngabty lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Lëdy kchë meñ nii sëëd lo xtiiy Abraham nak xiñ Dios, por lëë Dios chëb lo xaa: “Lëë Isaac kuuñ ktyaly xiñoo.” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nrii gon xluuy nii nakty meñ xiñ Dios por lo tiiy nii chaly meñ, sink xaktyee meñ nii koly sinak psaan Dios tiits nak xiñ Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Por lëë Dios chëb lo Abraham: “Tsiñee lëë tiemp tsitsiñ, lëën kyely, aan lëë Sara kap tu mëëd.” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ni lëdy sikosy byalo. Tugak pxosy chop xiñ Rebeca, Isaac pxusykoltoo no. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","13","Por ni karty kaly mëëd kwach ko, ni tu kyalbuen o kyalmaal gaa beeñtsyeydy xaa, lëë Dios chëb lo Rebeca: “Lëë mëëd kol ksoob xtiits mëëd wiich.” Ni leñ kitsy nii kë gaa xtiits Dios xñee: “Pkëstyoon Jacob, per blëën lo Esaú.” Nu nyoo nii lëë Dios xkwe meñ nii xlyañ styoo xaa, meñ nii chakladzy xaa xkwetsy xaa. Xkwenjty xaa nii chuuñtsyey meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","¿Pe styeesy no tsigo nii mal Dios? ¡Lëdyo gon! ");
INSERT INTO ztqNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Por lëë xaa chëb lo Moisés: “Skëstyoon xaa nii kakladzyaa.” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Singo tsigo busy, pe nandy nii kakladzy no o ktee gaa no fuersy, deelñee xkëstyoody Dios no. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Por leñ kitsyak nii kë xtiits Dios xñee nii chëb Dios lo rey Egipto: “Pson lii kakoo rey parñee kluyaa xkyalwnabeyaa, ni parñee kaknan meñ cho nakaa lo kislyu.” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Skëstyoo Dios meñ nii kakladzy xaa, ni suuñ jkyedzy kaa xaa styoo meñ nii kakladzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Per neñdy snëël lon: “Deelñee singo mod nako, ¿pe jkëëkiy Dios meñ con ni tu cho chilody sonlë lo xaa?” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Per ¿chool na dyon parñee ktilytiitsnil Dios? ¿Pe xñee kis peñ lo xaa nii psaaw nayak: “¿Penak nii psaal naa sinrii?” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Schilo xaa nii chuuñ tsiiñ peñ kuuñtsyey nii klyaañtyee styoo xaa. Schilo ksaa xaa tu kis peñ ngui, ni schilo ksaa xaa tu kis nii palsye jkiiñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","¿Aan pe tyeesy no deelñee kokladzy Dios nluuy xcastigw ni xkyalwnabey, pxekw xaa lo meñ nii xyal tedy castigw ni xyal nitylo? ");
INSERT INTO ztqNT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Lëëw gon beeñtsyey xaa parñee kluuy xaa xkyalntson xaa lo no. Pkëstyoo xaa lëë no ni pxixkwaa xaa lëë no parñee tyon no xkyalntson xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Por lëë Dios kwtsyetsy lëë no. No no nak meñ Israel. No gaa no nak meñ sit. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Leñ libre nii pkëë profet Oseas chëb Dios: Meñ sit kak meñ tu kyedzyaa, ni meñ nii xkëstyoodyaa jkëstyoon. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ni misme laañee chëb Dios: “Lëdy meñ tu kyedzyaa nak to”, siko lëë xaa këb: Lëë do nak xiñ Dios mbañ. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Per tsi lëë meñ Israel kokyety, lëë profet Isaías chëb: “Nikxe ndaly meñ Israel sinak ndaly yuzh nii nche chu nistoo, ndalydy meñ go telaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Por klyëëdy lëë Dios kuñ cumplir xtiits tyub lo kislyu.” ");
INSERT INTO ztqNT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Misme profet Isaías chëb: Deelñee ngwiladzy Dios meñ nii sëëd lo xtiiy no, lëë no nyak sinak meñ Sodoma ni Gomorra. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","¿Pe styeesy no tsigo? Kwëkyubty xaa sit nii mbig kex xaa lo Dios, sink lëë xaa big kex lo Dios porñee bniladzy xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Per lëë meñ Israel nii kwyoxko beeñtsyey nii xñabey ley, beeñdy meñ go gan mbig kex lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","¿Penak dyon beeñdy meñ go gan? Porñee gon big kexty meñ go lo Dios por kyalwniladzy, sink lëë meñ go big kex lo Dios por nii beeñtsyey meñ go. Por ngo lëë niy meñ go kwladzy kyo nii xlyadzy niy meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kyo re xseety kitsy nii kë xtiits Dios: Lëën kso tu xaa leñ kyedzy Jerusalén. Lëë xaa kchal niy meñ, per kchosody styoo meñ nii kniladzy xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Beetsy, tyub styoon xñabaa lo Dios nii telaa meñ Israel lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nli xñen nii tir choxko meñ Israel jkiiñ lo Dios, per nandy meñ Israel xa kuuñtsyey nii chakladzy Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Por xyeñdy meñ Israel nii lëë Dios xtsily xtol meñ, sink xaa mod chakladzy meñ Israel telaa lo tol. Xsaldy meñ Israel nii psaan Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Lëë Crist bisyaal xley Moisés tsiin kchë meñ nii kniladzy xtiits xaa telaa lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Lëë Moisés xñee nii kchë meñ nii kuuñtsyey nii xñabey ley telaa lo tol. Per par ley sye kpañ meñ go. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Per lëë meñ nii telaa lo tol por kyalwniladzy, xñee kitsy nii kë xtiits Dios: “Këëbtyoo leñ styool: ¿Cho tsëp kpaa? (Nak nrii sinak nii nyëboo parñee kyety Crist.) ");
INSERT INTO ztqNT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ni këëbtyoo: ¿Cho kyety leñ kislyu?” (Por nak nrii sinak nii nyëboo parñee kchoo Crist lady meñ kuty.) ");
INSERT INTO ztqNT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Xñee kitsy nii kë xtiits Dios: “Kexka lool so xtiits Dios, ni kexka chuwoo, ni kexka styool.” Lëë tiits ko nak xtiits Crist nii xluuy noo. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Deelñee con chuwoo xñeel nii lëë Jesús xñabey lo no, ni tyub styool xniladzyoo nii beeñ kpañ Dios xaa lo kyalkuty, lëël telaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","No nii kniladzy no leñ styoo no parñee kpily xtol no, ni no nii con chuw no kñee no cho nak Jesucrist parñee telaa no. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Xñee kitsy nii kë xtiits Dios: “Ni tu meñ nii kniladzy xtiits Crist kchosody styoo.” ");
INSERT INTO ztqNT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nak xaady meñ Israel ni meñ sit. Por misme xDiosak meñ Israel nak xDios meñ sit, ni kchë gaa lo meñ xteedy xaa nii xñab meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Por xñee kitsy nii kë xtiits Dios: “Kchësy meñ nii kseety lë Dios telaa lo tol.” ");
INSERT INTO ztqNT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","¿Per xa kseety meñ lë Dios na dyon, deelñee karty kniladzy meñ xtiits Dios? ¿Ni xa kniladzy meñ Dios na dyon, deelñee karty jkëëtyag meñ xtiits Dios? ¿Ni xa jkëëtyag kaa meñ xtiits Dios na dyon, deelñee kindy cho kluuyo lo meñ? ");
INSERT INTO ztqNT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","¿Ni xa tso xaa nii tsikluuy xtiits Dios na dyon, deelñee kindy cho kxaal xaa? Sinak xñee kitsy nii kë xtiits Dios: “¡Xaatke ntson chak tsiñee xlyañche xaa nii xluuy xtiits Dios!” ");
INSERT INTO ztqNT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Per lëdy kchë meñ xsal xtiits Dios. Sinak xñee profet Isaías: “Tat Tios, ¿cho xniladzy kaa xtiits no na dyon?” ");
INSERT INTO ztqNT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Singo tsigo busy, lëë meñ xniladzy porñee xkëëtyag meñ xtiits Crist. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Per xñe gakaa: ¿Pe pkëëtyag meñ xtiits Dios yak? ¡Pkëëtyag meño gon! Por xñee leñ kitsy nii kë xtiits Dios: Tyub lo kislyu biñ meñ tsiy xaa nii bluuy xtiits Dios, ni tyubñaa lo kislyu ptsiño. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Per xñe gakaa stub: ¿Pe karty yak kyeñ meñ Israelo? Destye klo gon kwnee Moisés: Lëën kuñ nii ksiniy do tu kyedzy nii lëdy kyedzy, ni lëën kuñ nii klëë do lo tu kyedzy nii chaklasty kon tiits. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Lëë gak profet Isaías byax chëb: Meñ nii kwëkyubty naa ptsil naa, ni lëën bluylo lo meñ nii kwnabtiisty por naa. ");
INSERT INTO ztqNT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Aan tsi lëë profet Isaías xseety meñ Israel, xñee xaa: “Tyub tse kwtsyetsyaa meñ ntseeb nii xsoobty tiits.” ");
INSERT INTO ztqNT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Lëë nana xñen: ¿Pe psaan Dios meñ Israel tublad yak? ¡Lëdyo gon! Misme naa, xaa Israelaa. Abraham nak pxusykoltoon. Lo xtiiy Benjamín syelyaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Destye klo kwle Dios meñ Israel parñee jkab meñ Israel xkyedzy Dios. Lëë na xsaandy Dios meñ Israel tublad. ¿Pe nandy kaa to nayak nii leñ kitsy nii kë xtiits Dios xñee nii tsiñee biily profet Elías lay, pkëëkiy xaa meñ Israel lo Dios? Chëb xaa: ");
INSERT INTO ztqNT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Tat Tios, lëë meñ beety xiprofetoo ni lëë meñ bnitylo xipkoogoo. Xaktyee naa mbañ aan win chakladzy meñ kety.” ");
INSERT INTO ztqNT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Per lëë Dios kwëb: “Lëën kwle kadzy mily xaa nii karty ksoxib lo mdyo nii lë Baal parñee jkiiñ xaa lon.” ");
INSERT INTO ztqNT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Singo gak natiemp bii no chop tson xaa nii kwle Dios por xkyalnsaak Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Aan por xkyalnsaak Dioso, lëdy por kyalbuen nii chuuñtsyey meño. Por deelñee nyako por nii chuuñtsyey meñ, lëdre por xkyalnsaak Dioso. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Kwaady xaa Israel nii kwëkyub xaa, per lëë xaa nii kwle Dios sye kwaaw. Lëë los demasy meñ pkyedzy styoo, ");
INSERT INTO ztqNT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","sinak xñee kitsy nii kë xtiits Dios: “Lëë Dios beeñ jkyedzy styoo xaa go, aan axte natse singo nak xaa. Sob mëlo xaa, per xñady lo xaa, ni sob tyag xaa, per chondy xaa.” ");
INSERT INTO ztqNT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Wi gak rey David chëb: Deelba kyak xilni xaa tramp ni kyako kyex, parñee ladzy niy xaa tsiin te xaa castigw. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Deelba jkyey lo xaa parñee kandy xaa, ni deelba kyeech xitsy xaa kaazhkaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Lëë nana xñe gaakaa: ¿Pe kaazhkaa nayak byab meñ Israel lyu? ¡Lëdyo gon!, sink worñee nii lëë meñ Israel pchooxso lo Dios, lëë meñ sit pchilo kwtelaa parñee tsoki styoo meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Deelñee por xtol meñ Israel lëë meñ sit kwaa xkyalnsaak Dios, ¿pe toodyxe tso kyalwle tsiñee lëë meñ Israel ktikche styoo lo Dios? ");
INSERT INTO ztqNT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Per lëën kniy tu cos lo do nii nak to meñ sit. Lëë Dios pxaal naa lo meñ sit. Por ngo ngui chuuñtsyeyaa xtsiñaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Por chakladzyaa nii tsoki styoo meñ tu kyedzyaa kan lëë do parñee ktee xaa nii telaa xaa lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Por deelñee byaan meñ Israel tublad parñee kpig meñ sit lo Dios, ¿pe lë nii kak tsigo tsiñee lëë meñ Israel kpig lo Dios stub? Lëë meñ Israel gon jkaa kyalmbañ. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Por deelñee nak lay kyaxtily, tyub kobyi nak lay, aan deelñee nak lay lu tu yag, wi xikwo nak lay lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Nak meñ Israel sinak xikw yag oliv nii kwchug, aan xlugaro kwsëëb to nii nak to sinak tu yag oliv tañ. Singo mod lëë do pkab lo lu yag ko. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Per ktaandy to lo xikw kol yag ko. Deelñee xtaan do, kol ksaladzy nii lëdy lu yag ko nak to, sink lu yag ko nseñ lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Neñdy snë do: “Per lëë xikw yag ko kwchug parñee kyënaady no chex yag ko.” ");
INSERT INTO ztqNT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Nliw, per lëë meñ Israel kwchug porñee bnilasty meñ Israel xtiits Dios, aan lëë do sob chex yag ko porñee bniladzy to. Ktaandy to, sink masy kol ktsyeb. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Por deelñee beeñdy Dios perdón xaa nii penaadle kok xikw yag, ni lëë do kuñdy xaa perdón. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kol kuy gaanoo xaatke buen Dios, nikxe nii ntseeb xaa. Ntseeb xaa lo meñ Israel nii pchooxso, per buen xaa lo do. Per no nii kpañ do sinak xñabey xaa, por deelñee kpañdy to singo, lëë do chug. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Deelñee kniladzy xaa Israel xtiits Dios, lëë xaa kpig lo Dios stub, por schilo ktsig kex Dios xaa stub. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Deelñee lëdy xaa Israel do, tu xikw yag oliv tañ do, aan lëë do kwënaady chex yag buen. ¿Pe lëëdyxe xaa Israel tsigo nii destye chex yag buen kwsob xaa, lëë xaa gon kyënaady chex xyag xaa stub? ");
INSERT INTO ztqNT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Lëën kniy nii ngolan Dios, parñee sakty to nii xaa chak to. Lëë styoo meñ Israel pkyedzy parñee kpig kex meñ sit lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Aan tsiñee lëë ngo kyal, kchë meñ Israel telaa lo tol, por xñee xkitsy Dios: Lëë xaa nii kteelaa kiid Jerusalén, aan lëë xaa kwii xtiiy Jacob lo tol. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Aan tiits re xsanaa, nii lëën ktsily kchë xtol meñ Israel. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Nak xaa Israel sinak meñ nii xlëë lo xtiits Dios, parñee knee Dios tiits telaa do. Per bii xkëstyoo Dios xaa Israel, por lëë Dios kwle pxusykoltoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Por xlady Dios nii xneetsy xaa, ni xtsëëdy Dios lo xtiits. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Tiemp psoobty to xtiits Dios, per lëë na nii xsoobty meñ Israel tiits, lëë Dios xkëstyoo lëë do. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Xsoobty xaa Israel tiits nina, parñee jkëstyoo Dios lëë do ni parñee jkëstyoo Dios xaa nina. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Lëë Dios blaa nii kchësy no ksoobty tiits, parñee jkëstyoo xaa lëë no, kchësy no. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","¡Natsypee ngol xkyalnsaak Dios, ni xkyalnyaani xaa, ni xkyalchak xaa! Ni tu cho chilody kyeñ nii no kik xaa ni kchë nii chuuñtsyey xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Por ¿cho nan na dyon pe cos no kik Dios? ¿Ni cholë nii gaa kteedy consef lo xaa? ");
INSERT INTO ztqNT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","¿Pe no gaa cho pteedy pe tu cos lo xaa parñee ktikche xaaw? ");
INSERT INTO ztqNT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Por kchë cos sëëd lo Dios. Por lëë xaa ni par lëë gaa xaa no kchësy cos. ¡Tugak kol tsoo ktee no skizh lo Dios! Amén. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Xñabaa lo do, beetsy, nii por xkyalnsaak Dios kokon do xcuerp to lo xaa. Por xyo styoo Dios nii kteedy to skizh lo xaa singo mod. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Kpañdy to si mbañ meñ natiemp, sink kol ktsëë xmod to parñee ngui kpañ do ni kyeñ do nii chakladzy Dios, tsiin kyeñ do pe cos buen, ni pe cos mbëë, ni pe cos tubli. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Por kyalnsaak nii bneetsy Dios lon, lëën xñe kchë lo do nii sakty to nii tir non do, sink ngui kol ko kik to aan ndoladzy kol kak, según kyalnsaak nii bneetsy Dios lo do porñee xniladzy to xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ndaly nii sob lady no, per xaal xaal laa xkiiño. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Singo gak lëë no, nikxe ndaly no, lo Crist ngab no kchësy no. Tusyke nak no ksa no xaa, sinak nii nyak no tugak cuerp. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Xaal xaal nak kyalnsaak nii bneetsy Dios lo no, según kwlaño styoo xaa. Por ngo, deelñee kwaa no kyalnsaak nii kñee no xtiits Dios, no nii kñee now tyub styoo no. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Deelñee kwaa gaa no kyalnsaak nii jkiiñ no lo meñ, no nii jkiiñ no ngui mod. Xaa nii kwaa kyalnsaak nii kluuy xtiits Dios, no nii kluuy xaaw lo meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Lëë xaa nii gaa kwaa kyalnsaak nii kchoobladzy styoo meñ, no nii kchoobladzy xaa styoo meñ. Lëë xaa nii gaa xkady, no nii ngui mod jkady xaa. Singo gak xaa nii kwaa tu tsiiñ, no nii kuuñtsyey ngui xaaw. Singo gak xaa nii chuñ yudar, no nii nguiool tso styoo xaa tsiñee chuñ xaa yudar. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Kol jkëstyoo lsa lëë do tyub styoo do. Kol kpixladzy kan do cos mal aan kol kuuñtsyey cos buen. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Kol jkëstyoo xcombañer do sinak nii nyak xaa betsy to. Kol ktee xlugar xaa ni kol ksal xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Kol kyë tsiiñ, ktsyaabty to. Kol jkiiñ lo Dios tyub styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Nguiool kol kpañ por kchë nii xniladzy to. Kol kxekw kyalnë. Ksaandy to tugak kol kool lay lo Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Kol sak nii xlyaadzy to nak xlyaadzy meñ nii xniladzy xtiits Dios. Ngui kol kan meñ nii chiid tedy lo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Kol nab lo Dios nii kuuñlay xaa xaa nii xkyënlaag lëë do. Ktsiibtedy to xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Kol kle ksa do xaa nii xle, ni kol koon ksa do xaa nii choon. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ngui kol kpañ kchë xcombañer do. Kak nyaady to, sink kol kak ndoladzy. Sakty to nii tir chak to. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ktikchedy to mal por mal. Kol ktee nii tugak kuuñtsyey do cos nii buen lo kchë meñ. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Axte laañee kteedyo tiits, ngui kol kpañ kchë xcombañer do. ");
INSERT INTO ztqNT_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Beetsy, kuñdy to kyalxtisy yuub to, sink kol klaa nii lëë Dios ksaksi, sinak nii xñee xtiits xaa: “Naa kuñ kyalxtisy ni naa kizh meñ.” ");
INSERT INTO ztqNT_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ni xñeew: “Deelñee xlyaañ xaa nii xlëë lool, ptee nii kaw xaa. Ni deelñee xlyaa xaa nis, ptee nii ki xaa, tsiin kyan lo xaa lo kyalto.” ");
INSERT INTO ztqNT_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Klaady to nii kuñ kyalmal gan lo do, sink kol kuñ gan lo kyalmal con kyalbuen. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","No nii kchë do ksoob xtiits xaa xñabey. Por nody ni tu xaa xñabey nii psoobty Dios, aan kchë xaa xñabey nii no, Dios pso xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Por ngo kchë xaa nii xsoobty xtiits xaa xñabey, xtiits Dios xsoobty xaa. Aan lëë kchë xaa go tedy castigw. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Por nody xaa xñabey parñee ktseb xaa xaa nii chuñ kyalbuen, sink lëë xaa no par xaa nii chuñ kyalmal. Deelñee chaklastyoo ktsyeeboo xaa xñabey, ngui kok tsiin kakni xaa xñabey lii. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Por Dios kë xaa xñabey tsiiñ parñee kuñ xaa lii yudar. Per deelñee chuñoo kyalmal, ptsyeb. Por lëdy lika noy xaa spad, por xtsiiñ Dios kë xaa par ksaksi xaa xaa nii chuñ kyalmal. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Por ngo no nii ksoob no xtiits xaa xñabey, lëjty xaktyee parñee ksaksidy xaa lëë no, sink porñee no xkyalcheñ no. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Wi por ngo xkizh to contribucioñ, por xtsiiñ Dios kë xaa xñabey aan ngo nak xtsiiñ xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Kol ktee nii chigal catu xaa. Kol kizh kchë contribucioñ lo xaa nii xtopo. Deel no gaa xaa nii ksal do, kol ksal xaa, ni deel no gaa xaa nii xyal ksoob to xtiits, kol ksoob xtiits xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ni tu cho lo kyëtiñdy to, sink kol jkëstyoo lsa xcombañer do. Por deelñee jkëstyoo do, lëë do beeñle cumplir nii xñabey ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Lëë ley gon xñee: “Tsonidyoo stu meñ deelñee no tsiiloo, kujtyoo, kwandyoo, tsookidyoo.” Per schilo kak cumplir kchë ngo con ley nii xñee: “Pkëstyoo xcombañeeroo sinak xkëstyool lii.” ");
INSERT INTO ztqNT_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Xsaksidy xaa nii xkëstyoo xcombañer. Singo mod lëë kyalwkëstyoo chuuñtsyey nii xñabey ley. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Kol kyeñ xa nak tiemp nii no no, ni kol kaknan nii lëë wor kutsiñ nii kte xkaal no. Por xtsedre lëë no telaa. Naktyo sinak worñee kal bniladzy no xtiits Dios. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Lëë kyool mer tedy aan lëë yutsye sëëd. Por ngo kol tsoo ksaan no cos nii chak lo nguey, aan kol tsoo kwe no lo bini sinak tsiñee xkwetsey soldad. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ngui kol tso tsyo no sinak cho meñ yutsye. Kyëëdy no kunip ni kuuñdy no lni yox, ni tsyonidy no stu mguiy o stu gaa kwnaa, ni ktildy no ni kak mbijty no. ");
INSERT INTO ztqNT_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Sink kol sak Jesucrist sinak tu ladx kiib nii kakw to, aan kuuñtsyeydy to cos mal nii no styoo do. ");
INSERT INTO ztqNT_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ngui kol nee lo xaa mban nii xyuumbey nizhty xtiits Dios. Ktilytiitsnidy to xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","No xaa nii chaw kchëlo cos. No gaa xaa mban nii kizh yësy chaw. ");
INSERT INTO ztqNT_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Per nody nii ksee xaa nii chaw kchëlo cos xaa nii chawdy cualquier cos. Singo gak xaa nii chawdy kchëlo cos nody nii ksee xaa nii chaw kchëlo cos, por lëë Dios pkaaña xaa tub tub xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","¿Cho nakoo parñee kñeenël xmos stu xaa? Deelñee buen so xaa o maal gaaw, lëë xpatrón xaa kan. Per buen kyaan xaa lo xpatrón xaa, por lëë Dios ksoli xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","No xaa nii xsyak nii no tse nda, ni no xaa nii xsyak nii tublosy nak tse. Catu xaa no nii kniladzy xaa nii no styoo xaa. ");
INSERT INTO ztqNT_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kchë xaa nii xsyak nii nda nak tu tse, par Dios xsyak xaa ndaw. Lëë xaa nii gaa chaw kchëlo cos, par Dios chaw xaaw aan xtee xaa skizh lo Dios. Singo gak xaa nii chawdy kchëlo cos, par kuuñ ksak xaa Dios chawdy xaa kchëlo cos ni xtee gaa 