﻿USE sofia;
DROP TABLE IF EXISTS sofia.ztp_vpl;
CREATE TABLE ztp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ztp_vpl WRITE;
INSERT INTO ztp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeꞌs nge le re xaꞌ tenꞌ mbroꞌ bin Jesucrist, Jesucrist nde lo bin David nde David nde lo bin Abraham ");
INSERT INTO ztp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ngok xud Isaac, Isaac ngok xud Jakob nde Jakob ngok xud Judá kon re wes Judá. ");
INSERT INTO ztp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ngok xud Fares kon Zara, leꞌ xnaꞌ rop xaꞌ ngok Tamar. Fares ngok xud Esrom nde Esrom ngok xud Aram. ");
INSERT INTO ztp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ngok xud Aminadab, Aminadab ngok xud Naasón, nde Naasón ngok xud Salmón. ");
INSERT INTO ztp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ngok xud Booz, leꞌ xnaꞌ Booz ngok Rahab. Booz ngok xud Obed, leꞌ xnaꞌ Obed ngok Rut, nde Obed ngok xud Isaí. ");
INSERT INTO ztp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ngok xud rey David, nde rey David ngok xud Salomón, leꞌ xnaꞌ Salomón ngok ngol ta ngok salꞌ Urías. ");
INSERT INTO ztp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ngok xud Roboam, Roboam ngok xud Abías, nde Abías ngok xud Asa. ");
INSERT INTO ztp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngok xud Josafat, Josafat ngok xud Joram, Joram ngok xud Uzías. ");
INSERT INTO ztp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ngok xud Jotam, Jotam ngok xud Acaz, Acaz ngok xud Ezequías. ");
INSERT INTO ztp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ngok xud Manasés, Manasés ngok xud Amón, nde Amón ngok xud Josías. ");
INSERT INTO ztp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ngok xud Jeconías nde kon re wes Jeconías. Tyemp ya, re xaꞌ Babilonia mbloꞌte xaꞌ re xaꞌ Judá nde mbeꞌ xaꞌ xaꞌ las xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Xista mbeꞌ xaꞌ re men Judá a lad Babilonia, Jeconías ngok xud Salatiel, nde Salatiel ngok xud Zorobabel, ");
INSERT INTO ztp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ngok xud Abiud, Abiud ngok xud Eliaquim, nde Eliaquim ngok xud Azor. ");
INSERT INTO ztp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ngok xud Sadoc, Sadoc ngok xud Aquim, nde Aquim ngok xud Eliud. ");
INSERT INTO ztp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ngok xud Eleazar, Eleazar ngok xud Matán, Matán ngok xud Jakob. ");
INSERT INTO ztp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nde Jakob ngok xud Jose, salꞌ Mari. Nde Mari ngok xnaꞌ Jesús, Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tamod sa siꞌda ned xaꞌ ngo xata Abraham axta David, xata David axta senꞌ mbeꞌ xaꞌ Babilonia xaꞌ Judá, ngo ta siꞌda ned xaꞌ, nde xata senꞌ mbeꞌ xaꞌ Babilonia xaꞌ Judá axta ngol Crist ngo ta siꞌda ned xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cheꞌ mod ngol Jesucrist: Mari xnaꞌ Jesús nakdiꞌsla selyaꞌno xaꞌ Jose, nde benꞌ tera tyobno xaꞌ ta xaꞌ, Mari mkelo xinꞌ naꞌ por yalne chanꞌ Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mbay leꞌ Jose sal' Mari nak ti xaꞌ galꞌ nde mbli xaꞌ xgab nagaꞌsta laꞌ xaꞌ Mari sa naꞌryoꞌyanthod Mari lo re xaꞌ yez. ");
INSERT INTO ztp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Xgab ya nzo yek Jose, nde cho leꞌ thi anj chanꞌ Dios mni lo xaꞌ lenꞌ xkalꞌ xaꞌ nde nchab anj lo xaꞌ: —Jose, nde lo bin David, naꞌsyepta la kaa Mari, tak yalne chanꞌ Mbi Nayon mbli sa mkelo xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nde ka xaꞌ ti mbed biꞌ nde kolea mbed Jesús, tak leꞌr tolaꞌ re men yez or lo re xken men. ");
INSERT INTO ztp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Reta jwanꞌ reꞌ ngote, sa ngok jwanꞌ mni Dios lo profet lo nchab Dios: ");
INSERT INTO ztp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Bwiꞌ goꞌ, ti mzaꞌ yenꞌ tera gaxno mbiꞌ, kelo xinꞌ naꞌ, nde tyan mzaꞌ thi mbed biꞌ, mbed ya kole xaꞌ Emanuel, Emanuel nak: Dios ndo xij naꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Senꞌ mbroꞌ xkalꞌ Jose, mbli xaꞌ xata mnibeꞌ anj chanꞌ Dios lo xaꞌ, nde mka xaꞌ Mari ngok salꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per naꞌngaxnod xaꞌ Mari, axta kebeꞌ ngol mbed xin' ner Mari nde mblole xaꞌ mbed Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Senꞌ lo ta ngola Jesús yez Belén, jwanꞌ nzi lo xyon Judea, mzin pla xaꞌ jwanꞌ nted re mbel lo beꞌ. Leꞌ xaꞌ ya mbroꞌ lad ned nche'dke wiz, nde mzin xaꞌ yez Jerusalén, lenꞌ linꞌ rey Herodes ");
INSERT INTO ztp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nde mnab diꞌs xaꞌ: —¿Ma rey lo re xaꞌ judío jwanꞌ ta ngolaꞌ? Tak náꞌ mbwiꞌ mbel chanꞌ xaꞌ lo beꞌ lad ned nche'dke wiz, nde náꞌ nde toxub lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Senꞌ mbin rey Herodes jwanꞌ na, mdaꞌ toza xgab yek xaꞌ, nde taga mxak re xaꞌ yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Zyasa mtop rey Herodes re nglweyꞌ jwanꞌ nyebeꞌ, nde re maestr nchak ley sa mnab diꞌs rey lo re xaꞌ ya, ploga ndablo gal Xaꞌ telꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Re xaꞌ ya nchab: —Leꞌ xaꞌ gal yez Belén, lo xyon Judea, tak ta nchab lo yeꞌs mkeꞌ profet: ");
INSERT INTO ztp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nde lu, yez Belén, nax lo xyon Judá, nanaktala thi yez mas lud xij re yez ntak lo xyon Judá, tak xij la gal ti xaꞌ kob ned lo yez na, xaꞌ ya kenap re men Israel, men yez na, xaja xaꞌ nkenap mbaxilꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Zyasa nagasta mbrez rey Herodes re xaꞌ jwanꞌ nted re mbel lo beꞌ ya, nde mnabdiꞌs xaꞌ nenꞌ polpa mbroꞌto mbel ya lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Seraꞌ mtelꞌ xaꞌ xaꞌ yez Belén nde nchab xaꞌ lo xaꞌ: —Wa goꞌ nde jwin kwanꞌ goꞌ mbed, nde senꞌ zyal goꞌ or yeꞌd tej goꞌy lon, sa non ya toxub lor. ");
INSERT INTO ztp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Senꞌ ngolo mbin xaꞌ reta jwanꞌ nchab rey lo xaꞌ, mxen xaꞌ ned nda xaꞌ, nde leꞌ mbel ta mbwiꞌ xaꞌ lad ned nched ke wiza, nda sibloy lo xaꞌ axta kebeꞌ mzina tenꞌ nax mbed, tya ngotoba. ");
INSERT INTO ztp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nde senꞌ mbwiꞌ xaꞌ mbel nale toz tir ngo lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nde lo ngote xaꞌ lenꞌ yo, mbwiꞌ xaꞌ mbed kon Mari xnaꞌ mbed. Zyasa mdoxub xaꞌ nde mbilꞌ xaꞌ lo mbed nde mxalꞌ xaꞌ jwanꞌ nzo re jwanꞌ ndak ndeno xaꞌ nde mdalaꞌs xay lo mbed, mdaꞌ xaꞌ oro, xtarak nde duꞌr naxeꞌ ndyeꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Xisa mni Dios lenꞌ xkalꞌ xaꞌ, sa naꞌbered xaꞌ lo Herodes, tamod sa xaꞌga ned mbere xaꞌ las xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Senꞌ ngola re xaꞌ ta ndli beꞌ mbel lo beꞌ ya ned, zya ti anj chanꞌ Dios mbroꞌto lenꞌ xkalꞌ Jose nde nchab xaꞌ: —Goche nde bxen mbed nde xnaꞌ mbed, nde bxonꞌ wa Egipto, nde tya yanꞌ la yoa axta kebeꞌ na ni loa, tak Herodes kwanꞌ mbed sa kuj xaꞌ mbed. ");
INSERT INTO ztp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zyasa ngoche Jose nde mxen xaꞌ mbed kon xnaꞌ mbed nde yalꞌ mxonꞌ xaꞌ nda xaꞌ Egipto. ");
INSERT INTO ztp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tya ngo xaꞌ axta kebeꞌ nguj Herodes. Tamod sa ngok xkiꞌs Dios, jwanꞌ nchab Dios lo xaꞌ mbrid xkiꞌs Dios pola: —Egipto nzo xinꞌ na sa mbrez na or. ");
INSERT INTO ztp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lo senꞌ mne Herodes mkwinꞌno re xaꞌ ta ndli beꞌ mbel lo beꞌ ya Herodes, mxi toz tir lazoꞌ xaꞌ. Tamod sa mnabeꞌ xaꞌ gaj reta mbed jwanꞌ nzo chop linꞌ par la, re or jwanꞌ nzo yez Belén nde re yez nzi dib tya, xata tyemp jwanꞌ mdej re xaꞌ ta ndli beꞌ mbel lo beꞌ ya lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tamod sa ngok diꞌs jwanꞌ nchab xaꞌ mbrid xkiꞌs Dios pola, ndole Jeremías: ");
INSERT INTO ztp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mke bi lenꞌ yez Ramá, nchonꞌ xaꞌ nde nabil toz mbez yaj xaꞌ, Raquel nak xaꞌ ta nchonꞌno re xinꞌ naꞌ ya, nde naꞌteyalta xaꞌ ko nale men lazoꞌ xaꞌ, tak ngujla reta xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Senꞌ lo ngujla Herodes, ti anj chanꞌ Dios, mbroꞌto lenꞌ xkalꞌ Jose senꞌ nzo xaꞌ Egipto, nde nchab anj lo Jose: ");
INSERT INTO ztp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Bxen mbed kon xnaꞌ mbed nde bere lo xyon Israel, tak ya ngujla re xaꞌ ta ndonke kuj mbeda. ");
INSERT INTO ztp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zyasa ngoche Jose mxen xaꞌ mbed kon xnaꞌ mbed, nde mbere xaꞌ lo xyon Israel. ");
INSERT INTO ztp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lo senꞌ mbin Jose, xaꞌ ndole Arquelao xinꞌ Herodes nyebeꞌ xyon Judea lugar chanꞌ Herodes, mzyeb Jose ya Jose tya. Per Dios mdej lo Jose lenꞌ xkalꞌ Jose tamod sa nda xaꞌ lo xyonꞌ Galilea. ");
INSERT INTO ztp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Senꞌ mzin xaꞌ tya nda xaꞌ ngo xaꞌ yez ndole Nazaret. Tamod sa ngok jwanꞌ mdej re xaꞌ mbrid xkiꞌs Dios pola, nchab xaꞌ: leꞌ Jesús ryoꞌle, Xaꞌ Nazaret. ");
INSERT INTO ztp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lo ta benꞌ nzo Jesús tya, Juan ta ngole mena, ngwa taꞌ xkiꞌs Dios lad izyo nagan lo xyon Judea, ");
INSERT INTO ztp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","nde nchab xaꞌ: —Blaꞌ goꞌ re jwanꞌ narax nak goꞌ nde bere goꞌ lo Dios, tak yalnyebeꞌ lo beꞌ nde sin gaxla. ");
INSERT INTO ztp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan reꞌ ta mdej xaꞌ mbrid xkiꞌs Dios pola ndole Isaías senꞌ nchab xaꞌ: Nchen mbez thi xaꞌ lad izyo biz: \"Ptoxkwaꞌ goꞌ xned Xaꞌ Nyebeꞌ nali bdix goꞌ xned xaꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Xab Juan naksaꞌ yis lad kamey, nde lenꞌ Juan nachal sinch yid, nde jwanꞌ ncha Juan nak mbesto nde mzin nzo wan nguꞌ Juan. ");
INSERT INTO ztp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Zyasa xaꞌ nzo yez Jerusalén, nde re xaꞌ nzo temas yez nzi dib lo xyon Judea nde xaꞌ nzo gax dib ro yoꞌ Jordán nda wiꞌ xaꞌ lo Juan. ");
INSERT INTO ztp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nde senꞌ nxobdol xaꞌ re xken xaꞌ, ngole Juan xaꞌ lenꞌ yoꞌ Jordán. ");
INSERT INTO ztp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lo mne Juan bro toz re xaꞌ fariseo nde re xaꞌ saduceo, nde xaꞌ plo ngegole Juan re men, zyasa nchab Juan lo re xaꞌ ya: —¡Go' ba nya lo bin mzib ba nak goꞌ! ¿Cho ne lo goꞌ xyonꞌ goꞌ lo yalnayi' chanꞌ Dios ta nde gaxa? ");
INSERT INTO ztp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bloꞌ goꞌ ke lipa mblaꞌ goꞌ re mod narax nak goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nde nalid goꞌ xgab lenꞌ lazoꞌ goꞌ: \"Náꞌ nde lo bin Abraham\"; tak na ni lo goꞌ, axta re ke reꞌ toyal liche Dios men nde lo bin Abraham. ");
INSERT INTO ztp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Leꞌ yibya ndabsaꞌla xis lox re ya, nde reta ya jwanꞌ naꞌtada ngud wen, xchoꞌy nde yoy lo ki sa yola. ");
INSERT INTO ztp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na, galꞌ diꞌs ngolen men lenꞌ nit, sa loꞌ ke lipa mblaꞌla xaꞌ mod narax nak xaꞌ. Per Xaꞌ jwanꞌ ndenke xis na Xaꞌ ya ngeno mas yalnyebeꞌ ke na, nde nekla yalyid Xaꞌ nanzalꞌta na wen, Xaꞌ ya kole men kon Mbi Nayon nde kon bel. ");
INSERT INTO ztp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nde nzola pal yaꞌ Xaꞌ sa to Xaꞌ trig nde kosaꞌ Xaꞌy tenꞌ nchotsaꞌ mbis, leꞌ yix trig tolꞌ Xaꞌy lo bel jwanꞌ nanchuꞌtirta. ");
INSERT INTO ztp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Zyasa, Jesús mbroꞌ Galilea nda Xaꞌ yoꞌ Jordán, plo ndo Juan sa kole Juan Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Per leꞌ Juan nandeyalta, nde nchab Juan lo Jesús: —Lu ndablo kolea na, ¿Kwan liy sa lu cheꞌ nde lon? ");
INSERT INTO ztp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Leꞌ Jesús mkab: —Taꞌ diꞌs cheꞌ mod aka naya, tak nakinꞌ linꞌ re jwanꞌ ncholaꞌs Dios. Zyara mxeyal Juan. ");
INSERT INTO ztp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nde senꞌ ngolo mbroꞌle Jesús, leja mbroꞌte Xaꞌ lenꞌ nit, zyasa cho leꞌ lo beꞌ mxyalꞌ nde mbwiꞌ Jesús Xbin Dios ndala xaja paloma nde mblatoba yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nde mbyen mni thi Xaꞌ lo beꞌ nchab: —Xaꞌ reꞌ nak Xinꞌ na jwanꞌ nkeꞌ toz lazoꞌn, nde nale toz nzo nale lazoꞌn win' Xa'. ");
INSERT INTO ztp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Zyasa Mbi Nayon mbeꞌ Jesús izyo nagan, sa tya tokilꞌ Maxuꞌ Jesús li Jesús jwanꞌ ncholaꞌs Maxuꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nde senꞌ ngolo mke Jesús yalse choꞌ wiz nde choꞌ yalꞌ, mzib mdyanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Zyasa ngwa Maxuꞌ lo Jesús nde nchab Maxuꞌ: —Tez nak la Xinꞌ Dios, mnibeꞌ sa yalal re ke reꞌ pan. ");
INSERT INTO ztp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Leꞌ Jesús mkab lo Maxuꞌ: —Lo xkiꞌs Dios nchab: \"Nanakta benꞌta pan ban men, noga reta diꞌs ndryoꞌ ro Dios ndaꞌ yalnaban lo men\". ");
INSERT INTO ztp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Xisa mbe' Maxuꞌ Jesús Jerusalén yez nayon, nde mbeꞌ Maxuꞌ Jesús tenꞌ mas gap ndab yek yodoꞌ ");
INSERT INTO ztp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nde nchab Maxuꞌ lo Jesús: —Tez Xinꞌ Dios nak la, gobi axta la ba, tak lo xkiꞌs Dios nchab: \"Dios nyebe' lo re anj chanꞌ Dios sa kenap xaꞌ la, lo yaꞌ xaꞌ tyenkeꞌ xaꞌ lu, sa na'chepta nia ke.\" ");
INSERT INTO ztp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zyasa Jesús mkab lo Maxuꞌ: —Noga nchab lo xkiꞌs Dios: Naꞌtokilꞌta la Xaꞌ Nyebeꞌ jwan' nak Dios la. ");
INSERT INTO ztp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nde tedib gob mbeꞌ Maxuꞌ Jesús ti yek yiꞌ gap toz ndab, tya mbloꞌ Maxuꞌ reta yalnyebeꞌ nzo lo izyo nde re yalxna chanꞌ neꞌy lo Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","sa nchab Maxuꞌ: —Reta jwanꞌ reꞌ tan loa, tez tyoxub la nde li naroa na. ");
INSERT INTO ztp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zyasa Jesús nchab lo Maxuꞌ: —Baxa wa Maxuꞌ, tak lo xkiꞌs Dios nchab: \"Lo Dios la Xa' Nyebe' loa tyoxub la, nde benꞌta lo Xaꞌ lia sinꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Zyasa mblaꞌ Maxuꞌ Jesús, nde mbye'd pla anj mblaꞌsto Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Senꞌ mbin Jesús leꞌ Juan nge lizyiꞌb, mbere Jesús lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Per naꞌngyanꞌta Xaꞌ Nazaret, leꞌ Xaꞌ nda ngo yez Capernaum, jwanꞌ nax gax ro nittoꞌ, lo xyon Zabulón nde Neftalí. ");
INSERT INTO ztp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tamod sa ngok jwanꞌ mkeꞌ xaꞌ mbrid xkiꞌs Dios pola, ndole Isaías: ");
INSERT INTO ztp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Izyon Zabulón nde izyon Neftalí, ned nda thita ro nittoꞌ tedib lad ro yoꞌ Jordán, xyon Galilea tenꞌ nzo re xaꞌ jwanꞌ nanakta xaꞌ judío. ");
INSERT INTO ztp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Re xaꞌ ya nzi lo yalꞌkow nde mbwiꞌ xaꞌ ti xni toz, nde re xaꞌ jwanꞌ nzola ro yalguj, ti xni toz mtoxni lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Xata zya ndobte Jesús, mdaꞌ Jesús xkiꞌs Dios lo men, nde nchab Xaꞌ: —Blaꞌ goꞌ re jwanꞌ narax nak goꞌ nde bere goꞌ lo Dios, tak yalnyebeꞌ lo beꞌ ndo gaxla. ");
INSERT INTO ztp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Senꞌ nda Jesús tita ro nittoꞌ Galilea, tya mbwiꞌ Jesús chop xaꞌ rop wes; tib xaꞌ ndole Simón jwanꞌ ndolegaꞌ Pedr, nde tedib xaꞌ ndole Ndres. Nde nge gobi rop xaꞌ yex lo nittoꞌ, tak xaꞌ god mbel nak xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zyasa nchab Jesús lo xaꞌ: —Deꞌ goꞌ btonke goꞌ xis na, sa lilal na goꞌ men god, sa li goꞌ gan men par Dios ");
INSERT INTO ztp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nde rop xaꞌ ya, zyaga mblaꞌ xaꞌ yex xaꞌ nde mdonke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zyasa Jesús mde ti tud, mbwiꞌ Xaꞌ ti chop xaꞌ rop wes: Jakobo kon Juan xinꞌ Zebedeo. Rop xaꞌ ya kon xud xaꞌ nzo lo bark nge keꞌbde xaꞌ yex xaꞌ. Nde Jesús mbrez rop wes xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nde zyaga mblaꞌ rop xaꞌ bark nde mblaꞌ xaꞌ xud xaꞌ nde mdonke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nde Jesús mkete dib Galilea, mkete loꞌ xaꞌ xkiꞌs Dios lo men lenꞌ yo tenꞌ ndyop xaꞌ Israel. Mkete taꞌ Xaꞌ re diꞌs wen chanꞌ yalnyebeꞌ chanꞌ Dios nde mtodanꞌ Xaꞌ men, lo re nak yis ndyak men nde reta nchow ndyak men. ");
INSERT INTO ztp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tamod sa jwanꞌ toz mxyob xkiꞌs Jesús dib xyon Siria, nde mbyedno xaꞌ re men jwanꞌ ndyak xaꞌxaꞌ yis lo Jesús; re xaꞌ ne ndyak lo re yis, re xaꞌ ndob mbi, re xaꞌ nzo mbi narax lazonꞌ, re xaꞌ nkeꞌ mbiy yek naꞌ nde re xaꞌ nguj ninꞌ. Nde Jesús mtodanꞌ reta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zyasa bro toz xaꞌ Galilea nde re siꞌ yez nale Decápolis, xaꞌ Jerusalen nde temas xaꞌ nzo lo xyon Judea nde re xaꞌ nzo tedib lad ro yoꞌ Jordán mdonke xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lo senꞌ mbwiꞌ Jesús men toz tir mdyop, Jesús mdonke nda yek yiꞌ nde mdob xaꞌ tya. Zyasa re xin'te'd Jesús mbike gax lo Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nde mdobte Jesús mbloꞌ Xaꞌ xkiꞌs Dios, nchab Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Nabeꞌz toz nda re men mne xaꞌ nakinꞌ xaꞌ Dios, tak re xaꞌ ya yote tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nabeꞌz toz nda re men jwanꞌ nchonꞌ, tak re xaꞌ ya ko nale Dios lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nabeꞌz toz nda re men nadoꞌ nak, tak re xaꞌ ya kayaꞌ izyo ak chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nabeꞌz toz nda re men jwanꞌ dib nzo lazonꞌ nchalas wiꞌ xaꞌ jwanꞌ galꞌ li Dios, tak re xaꞌ ya nix yo lazonꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nabeꞌz toz nda re men jwanꞌ nzo yalndlyat lazonꞌ, tak re xaꞌ ya lyat lazoꞌ Dios xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nabeꞌz toz nda re men ngenta jwanꞌ narax lazonꞌ, tak re xaꞌ ya twiꞌpa xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nabeꞌz toz nda re men jwanꞌ ndli sa nabeꞌz kwe re men, xaꞌ ya kole Dios xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nabeꞌz toz nda re men senꞌ ne ndyak xaꞌ, lo nchuꞌbla men xkap xaꞌ kwent ndli xaꞌ jwanꞌ galꞌ lo Dios, xaꞌ ya yote tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nabeꞌz toz nda re goꞌ senꞌ, ni xin men xis goꞌ, nchuꞌbla men goꞌ nde nkeꞌ xaꞌ yalke yek goꞌ re jwanꞌ naꞌnakta goꞌ kwent ndli lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Blyen goꞌ nde nale blo lazoꞌ goꞌ, tak naro toz jwanꞌ li goꞌ gan lo beꞌ. Tak taga mchuꞌbla xaꞌ re xaꞌ mbrid xkiꞌs Dios pola. ");
INSERT INTO ztp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Goꞌ nak xaja ted lo izyo. Per tez leꞌ ted nanasigtay, ¿xamod ak nasiga tib gob sa li rsin men na? Ya naꞌlitraꞌ sinꞌ na, kobiy xaꞌy nde tya tob ni men xis ney. ");
INSERT INTO ztp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","´Goꞌ nak xaja xni lo izyo. Ti yez jwanꞌ nzi yek yiꞌ naꞌnyed kas loy. ");
INSERT INTO ztp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nek thib men nantobta xaꞌ ti ki kandil nde tow xaꞌ xibeꞌ yek ney, cheꞌla gap ntob xaꞌy sa toxniy lo re men nzo yo. ");
INSERT INTO ztp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tagaꞌ goꞌ, bli goꞌ jwanꞌ wen sa wiꞌ re men jwanꞌ ndli goꞌ, tamod ak goꞌ xni lo xaꞌ, sa wen ni xaꞌ xis Xud goꞌ ndob lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","´Naꞌlid goꞌ xgab ke leꞌ na ndal sa kib na re ley mkeꞌ Moisés nde re jwanꞌ mbloꞌ re xaꞌ mdaꞌ xkiꞌs Dios pola. Naꞌndalta na sa kib nay, leꞌn ndal sa lin reta jwanꞌ nchaba. ");
INSERT INTO ztp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nde galꞌ diꞌs nin lo goꞌ, laja benꞌ nzi izyo nde beꞌ, nek tib punt nde nek thib letr lo ley naꞌrita axta kebeꞌ ak reta jwanꞌ ndablo ak. ");
INSERT INTO ztp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jwanꞌ nasa xanya ti men naꞌxobyekta ti yalnyebeꞌ lud nge ni lo ley, nde tagaꞌ mod ndloꞌ xay lo xagaꞌ men li mena, xaꞌ ya lud tak lo yalnyebeꞌ lo beꞌ. Leꞌ xaꞌ jwanꞌ nxobyeka nde taga ndloꞌ xaꞌy lo men, xaꞌ ya ak xaꞌ ndak toz tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Naya na ni lo goꞌ, tez nalid goꞌ mas jwanꞌ galꞌ ke lo re maestr nchak ley nde lo re xaꞌ fariseo, naꞌlid goꞌ gan yote goꞌ lo yalnyebeꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","´Goꞌ mne, Moisés nchab lo re xaꞌ gox: \"Nakujta goꞌ men, tez cho xaꞌ kuj ta men xaꞌ, nchap xaꞌ yalke, nde ya xaꞌ liz yiꞌb.\" ");
INSERT INTO ztp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Leꞌ na ni lo goꞌ tez cho xaꞌ nayiꞌ lo ta men xaꞌ, xaꞌ ya nchap yalke nde ya xaꞌ liz yiꞌb. Leꞌ xaꞌ jwanꞌ nixin lo ta men xaꞌ, xaꞌ ya yo xkena yolow. Nde xaꞌ jwanꞌ mbez lo ta men xaꞌ: ne yek la, xaꞌ ya ya lo bel lenꞌ yeꞌr abil. ");
INSERT INTO ztp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jwanꞌ nasa tez ndenoa jwanꞌ yon taꞌa lo Dios, nde tenꞌ nkayaꞌ xaꞌ yon tya nteꞌlas la, nchap la yalke lo ta men la, ");
INSERT INTO ztp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","blaꞌ jwanꞌ yon ta ndenoa ya lo tenꞌ nkayaꞌ xaꞌ yon nde nerla wa tsalꞌ diꞌs lo ta men la, seraꞌ yed la nde taꞌa chanꞌ la lo Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tez leꞌ xaꞌ ndebeyonoa mbeꞌ xaꞌ la yolow, laja ndo rop goꞌ ned pken ptoyal diꞌs kon xaꞌ, sa naꞌtaꞌyad xaꞌ la lo Juez. Nde tez naꞌtad lia, leꞌ Juez taꞌyaꞌa lo xa' nak sin' nde xa' nak sin' na' keꞌ xaꞌ la lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nde nipaꞌ na loa naryoꞌted la tya axta kebeꞌ kix la re nak jwanꞌ ndab la. ");
INSERT INTO ztp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","´Goꞌ mne Moisés nchab lo re xaꞌ gox: \"Naꞌgaxnod goꞌ xaꞌ jwanꞌ nanakta salꞌ goꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per na ni lo goꞌ tez xanya ti xaꞌ ngwiꞌ lo ti ngol nanakta salꞌ xaꞌ nde ndyablaꞌs xaꞌ gaxno xaꞌ ngol, xaꞌ ya ngoxnola xaꞌ ngol lenꞌ lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","´Tez ngudlo ban la ndli nchab la lo jwanꞌ narax, blotey nde blobiy, tak mas wen tyaꞌb ti ngudloa ke dib la ya yeꞌr abil. ");
INSERT INTO ztp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nde tez yaꞌ ban la ndli nchab la lo jwanꞌ narax, bchoy nde blobiy, tak mas wen tyaꞌb ti yaꞌa ke dib la ya yeꞌr abil. ");
INSERT INTO ztp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","´Taga nchab Moisés pola: \"Tez cho xaꞌ ndlaꞌ ngolꞌ naꞌ, ndablo toxkwaꞌ xaꞌ ti yes jwanꞌ ndej mblaꞌ xaꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per na ni lo goꞌ, xaꞌ jwanꞌ ndlaꞌ ngol naꞌ, tez nakte lo ngoxno ngol xaga mbiꞌ, cheꞌ ngechep xaꞌ ngol li ngol yalke gaxno ngol xaꞌga mbiꞌ. Nde xaꞌ jwanꞌ nselyaꞌ kon ngol ta mblaꞌ la mbiꞌ ya, yalkegaꞌ naka lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","´Nde taga mne goꞌ xa nchab Moisés lo re xaꞌ gox pola: \"Naꞌlat la lia re jwanꞌ mkeꞌyek la, cheꞌla bli reta jwanꞌ mkeꞌyek la lo Dios.\" ");
INSERT INTO ztp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per na ni lo goꞌ, naꞌtobrod goꞌ nek tib jwanꞌ senꞌ nkeꞌyek goꞌ li goꞌ ti jwanꞌ. Naꞌtobrod goꞌ beꞌ, tak tya ndob Dios. ");
INSERT INTO ztp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nek tobro goꞌ izyo, tak tya ndob ni Dios, nek tobro goꞌ Jerusalén, tak leꞌy nak yez chanꞌ Rey ro. ");
INSERT INTO ztp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neka yek la natobrot la, tak naꞌakta li nagat la o li nakis la nek tib yisyek la. ");
INSERT INTO ztp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Senꞌ gab goꞌ ti jwanꞌ, tez tli goꞌy, gab goꞌ \"liney\" nde tez mne goꞌ nalid goꞌy, gab goꞌ \"naꞌlitney\", tak tez tobro goꞌ masra jwanꞌ, jwanꞌ re' nde lo jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","´Goꞌ mnela nchab Moisés pola: \"Tez cho ti xaꞌ koꞌ ngudlo ti men, noga xaꞌ ya ryoꞌ ti ngudlonꞌ, nde tez cho ti xaꞌ gab ti kele men, noga xaꞌ ya gab ti kelenꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per na ni lo goꞌ: Naꞌaknayid goꞌ lo xaꞌ jwanꞌ nayiꞌ lo goꞌ, cheꞌla tez cho keꞌy kwat ban la, pta' tedib kwat la. ");
INSERT INTO ztp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nde tez cho xaꞌ nchalas yano xaꞌ la yolow, sa kib xaꞌ camis la, noga chamar la pta' lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tez cho xaꞌ ndo nyebeꞌ loa wea chanꞌ xaꞌ ti mil metr, beꞌy chop mil metr. ");
INSERT INTO ztp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nde cho xaꞌ nyab jwanꞌ loa, btaꞌy. Tez cho xaꞌ nyaꞌb prest loa, bkwanꞌ na ka xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","´Taga mbin goꞌ mbez men: \"Bkeꞌ lazoꞌa ta men la nde byiꞌno re xaꞌ nayiꞌ loa.\" ");
INSERT INTO ztp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per na ni lo goꞌ: bkeꞌ lazoꞌ goꞌ re xaꞌ jwanꞌ nakap nak lo goꞌ, blileyꞌ goꞌ re xaꞌ nixin xis goꞌ, naxut gok goꞌ lo xaꞌ nakap nak lo goꞌ nde mnaꞌb goꞌ lo Dios por re xaꞌ xkap ngetenke xis goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tamod sa ak goꞌ xinꞌ Xud goꞌ ndob lo beꞌ, tak Xaꞌ ndaꞌ xni lo men wen nde lo men xkap, nde ntelꞌ Xaꞌ yi lo men galꞌ ngete nde men narax ngete. ");
INSERT INTO ztp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Per tez goꞌ nkeꞌ lazoꞌ goꞌ benꞌta re xaꞌ jwanꞌ nkeꞌ lazonꞌ goꞌ, ¿cho kwan li goꞌ gan? Wiꞌ goꞌ nea, taga ndli re xaꞌ jwanꞌ nya'b tmi low. ");
INSERT INTO ztp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nde tez benꞌta lo wes goꞌ ni goꞌ dyux lonꞌ, ngen kwan jwanꞌ ro toz ngeli goꞌ, axta re xaꞌ nanzolod Dios ndli jwanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jwanꞌ nasa galꞌ gok goꞌ, xa galꞌ nak Xud goꞌ ndob lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nda wiꞌ goꞌ, senꞌ ndli goꞌ jwanꞌ wen, naꞌlid goꞌy senꞌ nzi wiꞌ men, benꞌta sa wiꞌ xaꞌ jwanꞌ ndli goꞌ. Tak tez ta li goꞌ, Xud goꞌ jwanꞌ ndob lo beꞌ naꞌtad Xaꞌ lo goꞌ jwanꞌ mbli goꞌ gan. ");
INSERT INTO ztp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nde senꞌ ndaꞌ goꞌ jwanꞌ gon lo men prob, naꞌxopta goꞌ diꞌs lo re men jwanꞌ mbli goꞌ, xa ndli re xaꞌ bxalꞌ nde xaꞌ kwinꞌ lenꞌ yo tenꞌ ndyop xaꞌ Israel nde re tenꞌ ngete xaꞌ. Tamod ndli xaꞌ sa wen ni men xis xaꞌ, per na galꞌ diꞌs nin, ngenoa xaꞌ gan jwan mbli xaꞌ gan. ");
INSERT INTO ztp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Leꞌ lu senꞌ taꞌa gon, nda wiꞌa sa naꞌnyed nek tib men jwanꞌ ndlia. ");
INSERT INTO ztp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nagasta pta' jwanꞌ gon, sa Xud la Dios ngwiꞌ gon ta nagasta ndaꞌa yaꞌ, sa nzi wi' re men ta Xaꞌ jwanꞌ mblia gan. ");
INSERT INTO ztp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nde senꞌ ndodiꞌsnoa Dios, naꞌlid la xa ndli re xaꞌ kwinꞌ nde xaꞌ bxalꞌ, tak xaꞌ ya ndyen toz xaꞌ tyoli xaꞌ todiꞌsno xaꞌ Dios lenꞌ re yo tenꞌ ndyop xaꞌ Israel nde re ned ro tenꞌ mas ndye men, sa wiꞌ men xa ndodiꞌsno xaꞌ Dios. Na, galꞌ diꞌs nin lo goꞌ, ya mblia xaꞌ gan jwanꞌ nzalꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per lu, senꞌ ndodiꞌsnoa Dios, gote lenꞌ yo nde btowꞌ ro yo nde nagasta ptodi'sno Xud la Dios, nde Xaꞌ ngwiꞌ lu tenꞌ nagas ndoa, sa Xaꞌ taꞌ jwanꞌ mblya gan nzi wiꞌ re men. ");
INSERT INTO ztp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nde senꞌ ndodiꞌsnoa Dios naꞌnid la thipka diꞌs lo Dios, xa ndli re xaꞌ naꞌnzolod Dios, tak xaꞌ ya ndli xgab lo ta disyatka ndo bez xaꞌ lo Dios tonza Dios xkiꞌs xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nalid goꞌ xa ndli re xaꞌ ya, tak benꞌ tera nyab goꞌ re jwanꞌ nakinꞌ goꞌ, Xud goꞌ Dios mnela cho kwan nakinꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jwanꞌ nasa cheꞌmod todiꞌsno goꞌ Dios: Xud náꞌ Dios jwanꞌ ndob lo beꞌ, Nayon toz lea. ");
INSERT INTO ztp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yeꞌd yalnibeꞌ chanꞌ la. Nde bli xa ncholaꞌs la, ta xa ndlia lo beꞌ taga bli lo izyo reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Jwanꞌ nak la' náꞌ re wiz, bta'y na wiz. ");
INSERT INTO ztp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nde ptonꞌ re xken náꞌ, xa ntorid náꞌ yek náꞌ re jwanꞌ narax ndli men lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Naꞌtat la diꞌs gab náꞌ lo re jwanꞌ narax, cheꞌla ptolaꞌ náꞌ lo re jwanꞌ narax, tak chanꞌ la nak yalnyebeꞌ, yalne nde yalnaro, dib adiꞌ. Ta naka. ");
INSERT INTO ztp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tak tez torid goꞌ yek goꞌ re jwanꞌ narax ndli men lo goꞌ, taga Xud goꞌ ndob lo beꞌ tonꞌ Xaꞌ re jwanꞌ narax ndli goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nde tez naꞌtoridta goꞌ yek goꞌ re jwanꞌ ndlino men goꞌ, taga Xud goꞌ naꞌtonꞌta Xaꞌ xken goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Senꞌ ndli goꞌ yalse, naꞌlinabilta goꞌ lo goꞌ xa ndli re xaꞌ kwinꞌ, tak re xaꞌ ya tamod ndli xaꞌ sa wiꞌ re men nge xaꞌ yalse. Galꞌ diꞌs nin lo goꞌ, ya mbli la xaꞌ gan jwanꞌ nzalꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nde lu, senꞌ ngea yalse, btach loa nde bkuꞌ yek la, ");
INSERT INTO ztp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sa ngen cho men nye ngea yalse. Benꞌta Xud la jwanꞌ ngwiꞌ ta nagasta ngea yalse, sa Xaꞌ taꞌ jwanꞌ mblya gan nzi wiꞌ re men. ");
INSERT INTO ztp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nde naꞌthopta goꞌ jwanꞌ ntak toz lo izyo reꞌ, tak lo izyo reꞌ ncha mbedxoy nde nchas yotoy, nde re xaꞌ wanꞌ li wanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas jwin blotsaꞌ goꞌy lo beꞌ, tya natatid mbedxoy nde neka gas yotoy nde tya nawewanꞌta wanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tak plo tenꞌ ngosaꞌ goꞌ jwanꞌ ntak toz lo goꞌ, tya ndob lazo' goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ngud lo men nak xaja ti xni toxni lo men, nde tez wen ngudloa, nawe nani dib ben la, ");
INSERT INTO ztp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","per tez ngudloa ngosaꞌy dib ben la nzo lo yalkow. Tez ndlyabe nakow nya naꞌnchonid ngudloa, ¡marka yalꞌkow mas anaꞌyoni ngudloa! ");
INSERT INTO ztp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nek tib mos naꞌlid gan ke sinꞌ lo chop xa' nak xwan' sin', tak wen nchanꞌ mos lo tib xaꞌ nde narax nchanꞌ mos lo tedib xaꞌ, o keꞌ lazoꞌ mos ti xa' nde kotal mos tedib xa'. Naꞌlid goꞌ gan li goꞌ sinꞌ lo Dios nde nyalo goꞌ yalrik. ");
INSERT INTO ztp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jwanꞌ nasa nin lo goꞌ: Naꞌlid goꞌ xgab xa ban goꞌ, nek kwan wa goꞌ o neka kwanꞌ gu goꞌ. Nek lar gok goꞌ lid goꞌ xgab. Mas ntak yalnaban lo yalwa nde mas ntak dib ben goꞌ lo lar. ");
INSERT INTO ztp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wiꞌ goꞌ nea, re mbin ta ngete xobi ba, nangod maꞌ bin, neka nthop maꞌ kosech, nde nangosaꞌd maꞌ jwanꞌ ncha maꞌ, nde Xud goꞌ jwanꞌ ndob lo beꞌ ndaꞌ jwanꞌ ncha maꞌ. ¡Mbay na, goꞌ mas ntak ke lo re mbin na! ");
INSERT INTO ztp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nde cho ti goꞌ ba li gan xyen tud, lo ndli toz goꞌ xgab? ");
INSERT INTO ztp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Kwan liy sa ndli goꞌ xgab lar gok goꞌ? Wiꞌ goꞌ nea, re yeꞌ nzo wan na, xa nxyen na, nde nankedey sinꞌ neꞌka ndoxkwaꞌy xab ney. ");
INSERT INTO ztp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per na ni lo goꞌ nek rey Salomón naꞌmblid xaꞌ gan ndokwaꞌ xaꞌ xaja ti yeꞌ ba, tenye plopa re jwanꞌ ntak mkeno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tez Dios ndli ta nawe toz nya re yeꞌ nzo wan na, naya nawe nyay nde yeꞌ yoy lo ki yola, ¡cho letla goꞌ masra jwanꞌ taꞌ Dios gok goꞌ, per goꞌ naꞌndlid lazoꞌ goꞌ Dios dib nzo lazoꞌ goꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jwanꞌ nasa nalid goꞌ xgab nde naꞌgabta goꞌ: \"¿Cho kwan wanꞌ? o ¿Cho kwan gunꞌ? o ¿Ma lar gok naꞌ?\" ");
INSERT INTO ztp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tak re xaꞌ jwanꞌ naꞌnzolod Dios ngetenke xaꞌ xis re jwanꞌ na, per Xud goꞌ Dios ndob lo beꞌ mnea Xaꞌ ta nakinꞌ goꞌ reta jwanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Per nerla pkwanꞌ goꞌ yalnyebeꞌ chanꞌ Dios nde xamod gal' ak goꞌ lo Dios, zyasa Dios taꞌ reta jwanꞌ na lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jwanꞌ nasa naꞌlid goꞌ xgab jwanꞌ nakinꞌ goꞌ yeꞌ, tak wiz yeꞌ nzola re jwanꞌ li men xgab. Reta wiz nzo toz jwanꞌ li men xgab. ");
INSERT INTO ztp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Naꞌkoxyod goꞌ men, sa naꞌnyabta Dios kwent lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tak xa ngoxyo goꞌ men, mod yaga nyab Dios kwent lo goꞌ, nde xa ndlino goꞌ men, taga yate goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Kwan liy sa ngwiꞌa yix lud nzo ngudlo ta men la, nde nangwiꞌd la ya ro nzo ngudloa? ");
INSERT INTO ztp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Nde xamod gab la lo ta men la: \"Pta' diꞌs goꞌten yix lud ta nzo ngudloa ba\", nde leꞌ ngudloa nzo ti ya ro? ");
INSERT INTO ztp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Men kwinꞌ! nerla blote ya ro nzo ngudloa, sa nawe wiꞌa, sera toyal koꞌa yix nzo ngudlo ta men la. ");
INSERT INTO ztp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nataꞌd goꞌ re jwanꞌ nayon lo mbak, tak yoloba naxgoꞌ mbak lad goꞌ, nekla re jwanꞌ ntak toz, naꞌkobid goꞌy lo nguch, tak tyob ni maꞌ xis neꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mnab goꞌy nde Dios taꞌy, pkwanꞌ goꞌy nde tsal goꞌy, mni goꞌ sa xalꞌ xaꞌ ro yo. ");
INSERT INTO ztp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tak reta men jwanꞌ nyaba, ndaꞌ Xaꞌy, nde cho ndryal tsal la, xaꞌ ni txalꞌ ro yo lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Cho ti goꞌ ba, tez nyab thi xinꞌ goꞌ thi pan lo goꞌ, cho ti ke taꞌ goꞌ lo or? ");
INSERT INTO ztp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O tez nyaꞌb or ti mbel lo xaꞌ, cho ti mbelꞌ taꞌ xaꞌ lo or? ");
INSERT INTO ztp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Teꞌnye men narax nak goꞌ, nchak ndaꞌ goꞌ jwanꞌ wen lo xinꞌ goꞌ, ¡choleꞌta Xud goꞌ jwanꞌ ndob lo beꞌ, Xaꞌ taꞌ re jwanꞌ wen, lo re goꞌ jwanꞌ nyaꞌba lo Xaꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tamod sa, reta jwanꞌ ncholaꞌs goꞌ li men lo goꞌ, taga mod bli goꞌy lo re men, tak jwanꞌ reꞌ nchab lo ley Moisés nde lo yes mkeꞌ re xaꞌ mbrid xkiꞌs Dios pola. ");
INSERT INTO ztp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gote goꞌ tenꞌ ndo yala naya. Tak naxen yala nde naro ned nda tenꞌ nzo yalguj, nde men toz nchote ned ya. ");
INSERT INTO ztp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per naya yala nde ne rid men ned jwanꞌ ncheꞌ men lo yalnaban, nde lud men nchasala. ");
INSERT INTO ztp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Pkenap lazoꞌ goꞌ lo re xaꞌ kwinꞌ, jwanꞌ mbez ndaꞌ xkiꞌs Dios, nde senꞌ nde xaꞌ lo goꞌ, nadoꞌ nya xaꞌ, xaja mbakxilꞌ la, per lenꞌ lazoꞌ xaꞌ nak xaꞌ xaja lob lusle ba. ");
INSERT INTO ztp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tak lo re jwanꞌ ndli xaꞌ, yolo goꞌ xaꞌ. Wiꞌ goꞌ nea, nanthopta men uv lo re lus yist, neka nthop men hig lo ya yis. ");
INSERT INTO ztp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nde reta ya wen, ngud wen ndaꞌy, per leꞌ re ya jwanꞌ ndaꞌ ngud mbyeꞌd, benꞌta ngud mbyeꞌd ndaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Re ya jwanꞌ ndaꞌ ngud wen naꞌndaꞌde ngud mbyeꞌd, neka re ya jwanꞌ ndaꞌ ngud mbyed naꞌndade ngud wen. ");
INSERT INTO ztp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Leꞌ reta ya jwanꞌ nandad ngud wen, xchoy nde yoy lo ki. ");
INSERT INTO ztp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jwanꞌ nasa, bwiꞌ goꞌ re jwanꞌ ndli xaꞌ, tamod sa nye goꞌ, cho men xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nakta re men, jwanꞌ mbez lon, Xaꞌ Nyebeꞌ, yote tenꞌ nyebeꞌ Dios lo beꞌ, benꞌta re men jwanꞌ ndli re jwanꞌ ncholas Xud na ndob lo beꞌ, men ya yote tya. ");
INSERT INTO ztp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Senꞌ sin wiz ya, bro toz men nye lon: Xaꞌ Nyebeꞌ, Xaꞌ Nyebeꞌ, kon lea mdaꞌ náꞌ xkiꞌs la, nde por lea mblote náꞌ re mbi narax, nde por lea mbli náꞌ bro toz re yalnaro. ");
INSERT INTO ztp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Zyasa gab na lo re xaꞌ ya: \"Nambyolotirta na goꞌ, baxa wa re goꞌ ta ndli jwanꞌ naraxa.\" ");
INSERT INTO ztp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tamod sa, tez cho xaꞌ nchon re diꞌs reꞌ nde ndli xaꞌy, lilal na xaꞌ, xaja ti mbiꞌ nzo xgab yek naꞌ, jwanꞌ mtaꞌ liz naꞌ xis ke. ");
INSERT INTO ztp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tak senꞌ mbla yi toz, mxyen re yoꞌ, mxyob mbi toz nde mbrid reta jwanꞌ na xis yo ya. Per naꞌngyubtey tak xis ke nzo xanꞌ ney. ");
INSERT INTO ztp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mbay re men nchon xkiꞌs na, nde nandlid xaꞌy, xaꞌ ya lilal na xaja ti mbiꞌ ngenta xgab yek naꞌ, jwanꞌ mtaꞌ liz naꞌ lo yux. ");
INSERT INTO ztp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tak senꞌ mbla yi toz, mxyen re yoꞌ, mxyob mbi toz nde mbrid reta jwanꞌ na xis yo ya. ¡Mbyuba, nde jwanꞌ toz ngotey! ");
INSERT INTO ztp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Senꞌ ngolo mdaꞌ Jesús re diꞌs ya, reta men nzoyen xaꞌ re jwanꞌ mbloꞌ Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tak ndloꞌ Xaꞌy xaja men ngeno yalnyebeꞌ, nandloꞌd Xaꞌy xaja ndloꞌ re maestr nchak ley. ");
INSERT INTO ztp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Senꞌ mbere Jesús lo ta ngwa Jesús yek yiꞌ ya, men toz tir ndenke xis Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Zyasa mbike thi mbiꞌ ndyak ye'sya's, nde mdoxub xaꞌ lo Jesús nchab xa: —Xa' Nyebe', Nya'b na loa todan' na, lu toyal liy tez ncholaꞌs la li ley. ");
INSERT INTO ztp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús mtogaꞌ yanꞌ mbwal xaꞌ men yisa, nde nchab Jesús lo xaꞌ: —Ncholas na dyanꞌ la. Gok nadanꞌ. Nde zyaga, mdyanꞌ xaꞌ lo yis ya. ");
INSERT INTO ztp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nde nchab Jesús lo xaꞌ: —Wiꞌ nea, ngen cho lo gab la jwanꞌ reꞌ, benꞌta wa lo xaꞌ nak nglweyꞌ sa wiꞌ xaꞌ lu, nde wano gon jwanꞌ mnibeꞌ Moisés, sa nye re nglweyꞌ mdyanꞌ la lu lo yis ndyak la. ");
INSERT INTO ztp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Senꞌ ngote Jesús lenꞌ yez Capernaum, mbike ti xaꞌ nyebeꞌ lo tib ayoꞌ sondad Roman nde mnaꞌb xaꞌ lo Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nchab xaꞌ: —Xa' nybe', ti mos na nax lo yis liz na, nguj ti ble xaꞌ nde jwanꞌ toz tir nchow xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nde Jesús mkab lo xaꞌ: —Ndan liz la, sa todanꞌ na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Leꞌ xaꞌ nyebeꞌ lo sondad nchab lo Jesús: —Señor, nansalꞌta na yotea lenꞌ liz na, benꞌta mnibeꞌ lo yis, sa dyanꞌ mos na. ");
INSERT INTO ztp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tak noga na, nzo xaꞌ nyebeꞌ lon, nde ngenon re sondad jwanꞌ nyebeꞌn lonꞌ. Senꞌ gab na lo thi xaꞌ, wa, xaꞌ ya nda; nde lo tib xaꞌ gab na, deꞌ, xaꞌ ya nde; nde lo mos na nyebeꞌn bli jwanꞌ reꞌ, nde ndli xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Senꞌ mbin Jesús jwanꞌ na, nzoyen toz Xaꞌ nde nchab Xaꞌ lo re men ta ndenke xis Xaꞌ: —Lipa nin lo goꞌ, tera zyal na nek tib xaꞌ Israel, ndli lazonꞌ xaja ndli lazoꞌ mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nde na ni lo goꞌ, men toz ryoꞌ ned ncheꞌdke wiz nde ned nchaꞌd wiz, yo xaꞌ lo yalwa xij Abraham, xij Isaac nde xij Jakob lo yalnyebeꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Leꞌ re xaꞌ jwanꞌ mkweꞌz ta ndablo yote lo yalnyebeꞌ, re xaꞌ ya kobi Xaꞌ le lo yalꞌkow, nde tya gon xaꞌ nde tyez le xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zyasa nchab Jesús lo xaꞌ nyebeꞌ lo sondad: —Bya liz la, nde ak jwanꞌ mnaꞌb la xata mbli lazoꞌa. Nde hor yaga mdyanꞌ mos xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Senꞌ ngote Jesús liz Pedr, nde tya mbwi Jesús, leꞌ xnaꞌsap Pedr nax nzo xlye. ");
INSERT INTO ztp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zyasa mbwal Jesús yaꞌ xaꞌ, nde mbroꞌ xlye xaꞌ, ngocheꞌ xaꞌ nde mbli xaꞌ sinꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lo senꞌ mbla yalꞌ, mbyeꞌdno re men naꞌr toz re xaꞌ nzo mbi narax; zyasa mnibeꞌ Jesús lo reta mbi narax nde mbroꞌtey, taga mtodanꞌ Jesús reta xaꞌ nayiz. ");
INSERT INTO ztp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tamod sa ngok jwanꞌ mkeꞌ xaꞌ mbrid xkiꞌs Dios pola ndole Isaías: \"Leꞌ xaꞌ mkib re nchow lad naꞌ nde mbeꞌ xaꞌ reta yis ndyak naꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lo senꞌ mne Jesús men toz mdyop tenꞌ ndo Jesús, mnibeꞌ Jesús lo re xin'te'd Xaꞌ, sa ya xaꞌ tedib lad ro nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Zyasa mbyed thi maestr lo ley xkiꞌs Dios, nde nchab xaꞌ lo Jesús: —Maestr, ncholas na tyonkeꞌn xis la one ploja ndaa. ");
INSERT INTO ztp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nde Jesús mkab lo xaꞌ: —Re mbeꞌd ngeno yeꞌr plo ncho maꞌ, nde re mbin ngeno maꞌ lyeꞌd maꞌ, leꞌ Xinꞌ Mbiꞌ nankenod Xaꞌ lizpa Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Leꞌ tedib xaꞌ, xaꞌ jwanꞌ nak xin'te'd Jesús nchab lo Jesús: —Xaꞌ Nyebeꞌ, taꞌ diꞌs, nerla kaꞌs na xud na. ");
INSERT INTO ztp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Leꞌ Jesús mkab lo xaꞌ: —Ptonke xis na, nde blaꞌ re xaꞌ nguja kaꞌs xaꞌ ta nguj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nde ngwap Jesús lo bark, nde reta xin'te'd Xaꞌ mdonke xis Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Zyasa mbroꞌ thi mbi toz mxyob lo nittoꞌ, nde re bde lo nittoꞌ mdoliy axta nkoꞌta dib bark, laja leꞌ Jesús naxyat. ");
INSERT INTO ztp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zyasa ngwa re xin'te'd Jesús ngoloꞌ xkalꞌ xaꞌ Jesús nde nchab xaꞌ: —¡Señor, tolaꞌ naꞌ! ¡Tak leꞌ naꞌ lux! ");
INSERT INTO ztp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Leꞌ Jesús mkab lo re xaꞌ: — ¿Cho kwan liy nzyeb goꞌ? ¡Lud toz ndli lazoꞌ goꞌ Dios! Ngolo nchab Xaꞌ jwanꞌ na, ngoche Xaꞌ nde mnibeꞌ Xaꞌ lo mbi nde lo nittoꞌ sa kwexey, nde xej mbrexe rey. ");
INSERT INTO ztp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nde re mbiꞌ ya nzoyen xaꞌ nde nchab xaꞌ: —¿Cho mbiꞌ reꞌ, sa axta re mbi nde nittoꞌ nxobyeka Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Senꞌ lo mzin Jesús tedib lad ro nittoꞌ, lo xyon xaꞌ Gadara, tya xij re baꞌ mbroꞌ chop mbiꞌ nzo mbi narax, nde mbike xaꞌ gax lo Jesús. Rop xaꞌ ya nayiꞌ toz xaꞌ, jwan nasa ngencho li gan ridndab ned ya. ");
INSERT INTO ztp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nde tolo mbrezyaj xaꞌ nchab xaꞌ: — ¿Cho kwan ndyak noa náꞌ, Jesús Xinꞌ Dios? ¿Cho se nde totia náꞌ nde tera gal beꞌy? ");
INSERT INTO ztp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nde tij tya nzi bro toz nguch jwanꞌ nzi kenap xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nde leꞌ re mbi naraxa, mnaba lo Jesús, nchaba: — Tez kotea náꞌ, taꞌ diꞌs lya náꞌ lenꞌ re nguch ta nzi ba. ");
INSERT INTO ztp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús mkab: —Wa goꞌ. Leꞌ re mbi narax mbroꞌte lenꞌ rop mbiꞌ ya nde mblay lenꞌ re nguch, zyasa re nguch zyaga mbixndab re maꞌ yek ble, ngob maꞌ lenꞌ nittoꞌ nde nguj re maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Leꞌ re men ngenap nguch mxonꞌ xaꞌ, ndya xaꞌ yez, lo senꞌ mzin xaꞌ yez mdej xaꞌ reta jwanꞌ ngote re nguch, nde re jwanꞌ ngote rop mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Zyasa reta men yez ya, ngwa xaꞌ plo ndo Jesús, lo mbwiꞌ xaꞌ Jesús, mnab xaꞌ lo Jesús, sa ryoꞌte Jesús lo xyon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zyasa, Jesús ngwap lo bark nde mbere Xaꞌ tedib lad ro nittoꞌ tenꞌ nzo Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tya ngwano men thi xaꞌ nguj tible xa' lo Jesús nzo'b xaꞌ thi lo lonꞌ. Lo senꞌ mne Jesús plopa ndli lazoꞌ re xaꞌ ya Dios, Jesús nchab lo xaꞌ bde ya: —Blo ne lazoꞌa, xinꞌ na, leꞌ re xken la mdyonꞌla. ");
INSERT INTO ztp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Zyasa pla maestr nchak ley mbli xaꞌ xgab: “Nixin mbiꞌ reꞌ xis Dios”. ");
INSERT INTO ztp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Leꞌ Jesús mnela cho xgab mbli re maestr ya, nde nchab Jesús: ¿Kwan liy ndli goꞌ xgab narax lenꞌ lazoꞌ goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Btej goꞌ lon: ¿kwanꞌ mas nambi gab na lo xaꞌ? ¿Leꞌ re xken la mdyonꞌ la o mas nambi gab men mdyanꞌ la lu? ");
INSERT INTO ztp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naya, loꞌn lo goꞌ, leꞌ Xinꞌ Mbiꞌ nkeno yalnyebeꞌ sa tonꞌ Xaꞌ re xken men lo izyo reꞌ, bwiꞌ goꞌ nea. Zyasa nchab Jesús lo xaꞌ bde ya: —Goche, bxen lonꞌ la, nde bya liz la. ");
INSERT INTO ztp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zyasa xaꞌ bde ya mdoli xaꞌ nde ndya xaꞌ liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lo mbwiꞌ re men jwanꞌ na, jwanꞌ toz nzoyen xaꞌ, nde mni xaꞌ diꞌs wen lo Dios, tak mdaꞌ Dios yalne ro lo ti mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tya mbroꞌ Jesús, nde senꞌ ndo Xaꞌ ned, mbwiꞌ Xaꞌ ndob thi mbiꞌ ndole Mateo tenꞌ nthop xaꞌ tmi low. Mbiꞌ ya nthop tmi low nchax lo Rom nde nchab Xaꞌ lo mbiꞌ: —Ptonke xis na. Zyasa Mateo mdoli nde mdonke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nde senꞌ ndobya Jesús kon re xin'te'd Xaꞌ liz Mateo, tya mzin nar xaꞌ nthop tmi low nchax lo Rom nde nar xaꞌ nzo'b xken naꞌ, mdob ro mes kon Jesus. ");
INSERT INTO ztp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nde lo mbwiꞌ re xaꞌ fariseo jwanꞌ na, mnabdiꞌs xaꞌ lo re xin'te'd Jesús: —¿Cho kwan liy nchano maestr goꞌ re xaꞌ nthop tmi nde re xaꞌ nzo'b xken naꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lo mbin Jesús jwanꞌ na, nchab Jesús lo re xaꞌ ya: — Re xaꞌ nadanꞌ nanakinꞌta xaꞌ doktor, benꞌta re xaꞌ nayiz nakinꞌ doktor. ");
INSERT INTO ztp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bya goꞌ nde byen goꞌ cho kwan nak diꞌs reꞌ: “Yalndlat lazoꞌ ncholas na, nancholasta na kuj goꞌ maꞌ taꞌ go' lon” Tak nandalta na sa bez na re xaꞌ galꞌ ndo, leꞌn ndal sa bez na re xaꞌ nzoꞌb xken naꞌ, sa laꞌ xaꞌ re jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Zyasa re xin'te'd Juan mbike lo Jesús, nde mnabdiꞌs xaꞌ: —¿Cho kwan liy sa re xin'te'd la nandlid xaꞌ yalse? nde re náꞌ nde re xaꞌ fariseo jwanꞌ toz ndli náꞌy, ");
INSERT INTO ztp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús mkab lo xaꞌ: —¿Cho toyal yo nabil lazoꞌ re men jwanꞌ nzi lo yalselyaꞌ, laja mbyo ndoselyaꞌ ndo xij xaꞌ? Per sin thi wiz we xaꞌ mbyo ta mselyaꞌ ya, zyasa li re xaꞌ yalse. ");
INSERT INTO ztp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ngen cho nkebde thi ble lar kub, lad thi lar gox, tak leꞌ lar kub ndyopa nde ncheda lar gox, zyasa cheꞌ masra nched tenꞌ mkebde lar kuba. ");
INSERT INTO ztp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Neka ngo men bin kub lenꞌ yid gox, tak tez ko mena lenꞌ yid gox, ncheda yid nde nxyo bin kub, nde leꞌ yid ndyroꞌtal. Jwanꞌ nasa ndablo ko men bin kub lenꞌ yid kub tamod sa ropa bro xeka. ");
INSERT INTO ztp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Laja Jesús ndotej jwanꞌ na lo re men, thi xaꞌ nyebeꞌ lenꞌ yo tenꞌ ndyop men Judío, mzin xaꞌ nde mdoxub xaꞌ axta mdinꞌ lo xaꞌ izyo lo Jesús, nde nchab xaꞌ: — Xinꞌ got na ngolo nguj, per tez lu yeꞌd la nde xob la yaꞌa xis or, troꞌxban or. ");
INSERT INTO ztp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Leꞌ Jesús mdoli nde ngwanke Jesús xis mbiꞌ ya kon re xin'te'd Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Zyasa thi ngol ndyak yis ndlyaj ren, ndatea tib sen linꞌ naꞌyatabta yis ren lo xaꞌ, mbike gax xaꞌ xis Jesús nde mbwal xaꞌ ro xab Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tak mbli ngol xgab: “Benꞌta gal na ro xab Xaꞌ, leꞌ na dyanꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nde Jesús mbyek, mbwiꞌ Xaꞌ lo ngol, nde nchab Xaꞌ: —Blo ne lazoꞌa, xinꞌ got na, kwent ndli lazoꞌa, jwanꞌ na mdyanꞌ la. Nde zyaga mdyanꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Senꞌ mzin Jesús liz mbiꞌ ya, nde mbwiꞌ Jesús nzi re xaꞌ nkeꞌ di yek men nguj, nde re xaꞌ jwanꞌ nzi yonꞌ yek or nguja, ");
INSERT INTO ztp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","zyasa nchab Jesús lo re xaꞌ ya: —Broꞌte go, tak nangujta mzaꞌ, leꞌ mzaꞌ naxyat. Zyasa mxino re men Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Per senꞌ ngolo mbroꞌte re men ya, Jesús ngote lenꞌ yo, nde mxen Jesús yaꞌ mzaꞌ, nde ngoche mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nde jwanꞌ na mxyobdiꞌs dib izyo ya. ");
INSERT INTO ztp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Senꞌ lo mbroꞌte Jesús tya, chop xaꞌ syeg mdonke xis Jesús, nde mbrez yaj xaꞌ nchab xaꞌ: —¡Blat lazoꞌa náꞌ, Xaꞌ nde lo bin David! ");
INSERT INTO ztp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Senꞌ ngote Jesús lenꞌ yo, rop xaꞌ nkow lonꞌ ya mbike gax lo Jesús, nde mnabdiꞌs Jesús lo xaꞌ: —¿Cho tlin gan lin jwanꞌ reꞌ ndyak goꞌ? Leꞌ rop xaꞌ ya mkab: —Tlia gan Señor. ");
INSERT INTO ztp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Zyasa Jesús mbwal ngudlo rop xaꞌ nde nchab Jesús: — Xa ndli lazoꞌ goꞌ ta ak jwanꞌ mnab goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nde mxyalꞌ ngudlo rop xaꞌ ya. Zyasa Jesús mnaꞌb toz lo rop xaꞌ ya nchab Jesús: —Nda wiꞌ toz goꞌ sa ngen cho nye jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per benꞌta ngolo mbroꞌ rop xaꞌ tya, tolo mdej xaꞌy lo re men nzo dib izyo ya jwanꞌ mbli Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Laja ndoyo rop xaꞌ ta mxyalꞌ lonꞌ ya ned, mzin tib pla men ndeno thi xaꞌ ngup nzo mbi narax lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nde senꞌ mbloꞌte Jesús mbi narax leꞌn lazoꞌ xaꞌ ngupa, leꞌ xaꞌ mdobte mdodiꞌs. Nde re men nzoyen xaꞌ nde nchab xaꞌ: —Tera wiꞌ tir men thi jwanꞌ taba dib Israel. ");
INSERT INTO ztp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mbay re xaꞌ fariseo nchab: —Mbiꞌ reꞌ ngote re mbi narax, tak xaꞌ jwanꞌ nyebeꞌ lo re mbi narax, ndaꞌ yalne lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús mkete re yez ro nde re ranch. Mketeloꞌ Xaꞌ xkiꞌs Dios lenꞌ re yo tenꞌ ndyop xaꞌ Israel nde mdaꞌ Xaꞌ diꞌs wen chanꞌ yalnyebeꞌ chanꞌ Dios lo re men. Nde mtodanꞌ Xaꞌ men lo re nak yis nde re nak yis nchow jwanꞌ ndyak men. ");
INSERT INTO ztp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lo senꞌ mbwiꞌ Jesús men toz tira, mblat lazoꞌ Jesús xaꞌ tak nzi xaꞌ xaja nzi mbakxilꞌ ptyab nde nalat ndyak naꞌngen cho ngenap. ");
INSERT INTO ztp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Zyasa nchab Jesús lo re xin'te'd Jesús: —Galꞌ diꞌs, bro toz kosech, per lud xaꞌ jwanꞌ nge sinꞌ lo neꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jwanꞌ nasa mna'b goꞌ lo Xaꞌ nak xwanꞌ kosech sa telꞌ Xaꞌ men ke sinꞌ lo kosech Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zyasa mbrez Jesús re thib sen xin'te'd Xaꞌ, nde mdaꞌ Jesús yalnyebeꞌ lo re xaꞌ, sa koꞌte xaꞌ re mbi narax nde todanꞌ xaꞌ re ned yis nde re ned nchow jwanꞌ ndyak men. ");
INSERT INTO ztp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nde chemod ndole re thib sen apost: nerla, Simón, jwanꞌ ndolega Pedr, nde wes xaꞌ ndole Ndres, nde Santyag kon Juan xinꞌ Zebedeo, ");
INSERT INTO ztp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Blib, Bartolomé, Max, Mateo xaꞌ ndli kobral tmi low, Jakob xinꞌ Alfeo, Lebeo ndolega Tadeo, ");
INSERT INTO ztp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón xaꞌ nzo xij partid kananist, nde kon Judas Iscariote, xaꞌ ta mdayaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Re tib sen xaꞌ reꞌ mtelꞌ Jesús nde mnibeꞌ Jesús lo xaꞌ: —Naꞌyad goꞌ re tenꞌ nzo re xaꞌ nanakta xaꞌ judio, nde naꞌyoted goꞌ re yez xaꞌ Samaria. ");
INSERT INTO ztp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cheꞌla, nerla wa goꞌ lo xaꞌ Israel jwanꞌ nak xaja re mbakxilꞌ ngetetab, ");
INSERT INTO ztp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","wa goꞌ nde pta' goꞌ kwent, leꞌ yalnyebeꞌ lo beꞌ ndo sin gaxla. ");
INSERT INTO ztp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ptodanꞌ goꞌ re xaꞌ nayiz, ptoban goꞌ re xaꞌ nguj, ptodanꞌ goꞌ re xaꞌ ndyak ye'sya's, bloꞌte goꞌ re mbi narax jwanꞌ nzo lazoꞌ men. Tata mkayaꞌ goꞌ jwanꞌ reꞌ, nde tata abli goꞌy lo re men. ");
INSERT INTO ztp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Naꞌwed goꞌ tmi senꞌ nda goꞌ, nek tmi or, nek tmi plat, neka tmi cobr, ");
INSERT INTO ztp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nde naꞌwed goꞌ jwanꞌ wa goꞌ ned, naꞌwed goꞌ chop ned lar, nek chop ned yalyid, neka yaga, tak xaꞌ nge sinꞌ nzalꞌ xaꞌ taꞌ men re jwanꞌ nakinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nde senꞌ sin goꞌ thi yez o thi ranch, kwanꞌ goꞌ thib liz men nabeꞌz nak nde liz xaꞌ ya yo goꞌ dibta kwed goꞌ, axta kebeꞌ yo goꞌ ned. ");
INSERT INTO ztp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lo senꞌ sin goꞌ liz xaꞌ, mni goꞌ dyux lo re xaꞌ nzo yo. ");
INSERT INTO ztp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nde tez xaꞌ nzo yo ya nzalꞌ xaꞌ yalnabeꞌz, yanꞌ na lo xaꞌ nde tez nanzalꞌta xay, nayantey lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nde tez cho xaꞌ naꞌtad yo kwed goꞌ nde nagonta xaꞌ xkiꞌs goꞌ, broꞌte goꞌ yez ya o yo ya, nde bzib goꞌ yothiꞌ ni goꞌ, sa loꞌ naꞌngonta xaꞌ xkiꞌs goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nipa na lo goꞌ, senꞌ sin wiz nyab Dios kwent lo re men, ludxa pen ya re men yez Sodoma nde yez Gomorra, ke yez ta naꞌngonta xkiꞌs goꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wiꞌ goꞌ nea, na telꞌ goꞌ, xaja mbakxilꞌ xij re lob. Jwanꞌ nasa, nalas pkete goꞌ xaja mbelꞌ la, nde nadoꞌ gok goꞌ xaja palom ma. ");
INSERT INTO ztp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nda wiꞌ toz goꞌ tak re men tayaꞌ xaꞌ goꞌ lo re xaꞌ nak sinꞌ, nde kin xaꞌ goꞌ lenꞌ re yo tenꞌ ndyop xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nde we xaꞌ goꞌ lo gobernador nde lo re xaꞌ nak rey kwent chanꞌ na, tamod sa tej goꞌ xkiꞌs na lo re xaꞌ ya nde lo re xaꞌ jwanꞌ nanakta xaꞌ judio. ");
INSERT INTO ztp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per senꞌ tayaꞌ xaꞌ goꞌ lo re xaꞌ nak sinꞌ, nalid goꞌ xgab cho kwan gab goꞌ nde xamod gab goꞌy, tak senꞌ sin hor ya, Dios taꞌ re diꞌs jwanꞌ ndablo gab goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tak nanakta goꞌ jwanꞌ ni, Xbin Xud goꞌ Dios ni, Xaꞌ lirsinꞌ ro goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Re men tayaꞌ xaꞌ leꞌga leꞌ wes xaꞌ lo yalguj, nde leꞌga leꞌ re xud re mdyenꞌ tayaꞌ xaꞌ mdyenꞌ, nde re mdyenꞌ tayaꞌ mdyenꞌ xud mdyenꞌ nde xnaꞌ mdyenꞌ sa kuj xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nde re men giꞌno xaꞌ goꞌ kwent chanꞌ na, per xaꞌ tibla ne ndo axta lulka, xaꞌ ya lyaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Senꞌ chobla xaꞌ goꞌ yez reꞌ, bxonꞌ goꞌ wa goꞌ tedib yez. Nipa na lo goꞌ tera yolo ketexonꞌ goꞌ reta yez nzi Israel senꞌ yeꞌd Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nek thib xin'te'd maestr mas ntak lo maestr, nde nek thib mos mas ntak lo xwanꞌ mos. ");
INSERT INTO ztp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Xinꞌ teꞌd maestr leꞌja ak xaꞌ xaja maestr, nde leꞌ mos leja ak xaꞌ xaja xwanꞌ xaꞌ. Tez xud mdyenꞌ mblole xaꞌ, Beelzebú, ¿cho leta mdyenꞌ, plopa kole xaꞌ re mdyenꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jwanꞌ nasa, nazyebta goꞌ re xaꞌ ya. Tak reta jwanꞌ nagaꞌs nzo, leꞌy trotega lo xni, nde re jwanꞌ nkas men ley troxobka. ");
INSERT INTO ztp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jwanꞌ nin lo goꞌ tenꞌ nakow, ptej goy lo xni, nde re jwanꞌ nagaꞌsta ngetej na lo goꞌ, wap goꞌ re yek yo nde ne ptej goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Naꞌzyebta goꞌ re xaꞌ nguj men, tak benꞌta belꞌ nguj xaꞌ, naꞌakta lux xaꞌ xbin men, mas bzeb lazoꞌ goꞌ Xaꞌ jwanꞌ tak lux belꞌ men nde xbin men lenꞌ yeꞌr abil. ");
INSERT INTO ztp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Plopa ndak chop mbyin bix? benta ti tmi lud ndak maꞌ Per nek thib mbyin bixa nachajta tez Xud goꞌ Dios nataꞌd diꞌs gaj maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Taga axta re yis yek goꞌ nagaba lad yek goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jwanꞌ nasa naꞌzyebta goꞌ, tak mas ndak goꞌ ke tib byox mbin bixa. ");
INSERT INTO ztp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Reta men jwanꞌ gab, nzolo xaꞌ na lo re men, noga na gab nzolon xaꞌ lo Xud na ndob lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per men jwanꞌ gab na nanzolod xaꞌ na lo re men, noga na gab nanzolod na xaꞌ lo xud na ndob lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nalid goꞌ xgab ke leꞌ na ndalno yalnabeꞌz lo izyo, nandalnot na yalnabeꞌz leꞌn ndal sa ak rol men. ");
INSERT INTO ztp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Leꞌ mbiꞌ yo kon xud mbiꞌ, nde mdyenꞌ got yo kon xnaꞌ mdyenꞌ, nde ngol yo kon xnayiꞌ ngol, ");
INSERT INTO ztp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nde leꞌga leꞌ re xaꞌ lenꞌ lis xaꞌ ak xaꞌ ke byo kon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Men jwanꞌ mas nkeꞌ lazonꞌ xud naꞌ o xnanꞌ ke na, nanzalꞌta xaꞌ ak xaꞌ men na, nde men jwanꞌ mas nkeꞌ lazonꞌ xinꞌ biꞌ naꞌ o xinꞌ got naꞌ ke na, nanzalꞌta xaꞌ ak xaꞌ men na. ");
INSERT INTO ztp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tez cho xaꞌ ndyonke xis na, nde nancholasta xaꞌ rid xaꞌ yalti, nanzalꞌta xaꞌ ak xaꞌ men na. ");
INSERT INTO ztp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xaꞌ jwanꞌ nancholaꞌsta gaj lo izyo reꞌ xaꞌ ya gaj, leꞌ xaꞌ jwanꞌ nanzyebta gaj por kwent chanꞌ na, xaꞌ ya tibtane ban. ");
INSERT INTO ztp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Xaꞌ jwanꞌ ndaꞌ liz naꞌ kwed goꞌ, lon ndaꞌ xaꞌ yo kwed na, nde xaꞌ jwanꞌ ndaꞌ liz naꞌ mbed na, xaꞌ ya ndaꞌ liz naꞌ mbed Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xaꞌ jwanꞌ ndaꞌ yo mbed ti profet, kwent nak xaꞌ profet, xapa jwanꞌ ka profet ya, yapa jwanꞌ kayaꞌ xaꞌ ya, nde xaꞌ jwan ndaꞌ yo kwed ti xaꞌ galꞌ ndo, kwent galꞌ ndo xaꞌ, xapa jwanꞌ ka xaꞌ galꞌ ndo ya, yapa jwanꞌ kayaꞌ xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nde xa nya ti men taꞌ ti bas nit nal gu xaꞌ jwanꞌ mas lud ntak, por lo nak xaꞌ xin'te'd na, nipa na lo goꞌ ya ngenoa xaꞌ jwanꞌ li xaꞌ gan. ");
INSERT INTO ztp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Senꞌ mne mdej Jesús lo re thib sen xin'te'd Jesús re jwanꞌ ndablo xaꞌ li xaꞌ, mbroꞌ Xaꞌ nda Xaꞌ tedib lad, nda loꞌ Xaꞌ nde nda tej Xaꞌ xkiꞌs Dios lo re yez nzi dib tya. ");
INSERT INTO ztp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nde senꞌ nge Juan ngole men na, liz yiꞌb, mbin Juan reta jwanꞌ ndli Crist. Zyasa mtelꞌ Juan chop xin'te'd Juan lo Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","sa nyab diꞌs xaꞌ: —¿Cha lu nakꞌ xaꞌ jwanꞌ ndablo yed o kwed náꞌ tedib xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Leꞌ Jesús mkab lo xaꞌ: —Bya goꞌ nde ptej goꞌ lo Juan reta jwanꞌ ndowiꞌ goꞌ nde reta jwanꞌ ta ndoyon goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Re xaꞌ nkow lon', re xaꞌ ngob ninꞌ galꞌ ndye xaꞌ, re xaꞌ ndyak ye'sya's mdyanꞌ xaꞌ, re xaꞌ nkweꞌ mxyalꞌ nza xaꞌ, re xaꞌ nguj nryoꞌxban, nde re xaꞌ prob nchaj xkiꞌs Dios lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nde nabeꞌz toz nda re xaꞌ jwanꞌ nandyolaꞌsta nde nandlad xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Laja ngo re xaꞌ ya ned, Jesús tolo mdaꞌ kwent chanꞌ Juan lo re men nchab Jesús: —Senꞌ ngwa goꞌ izyo nagan ¿Cho kwan ngwa wiꞌ goꞌ? ¿Cho benꞌta thi yi jwanꞌ lada lada ntek mbi? ");
INSERT INTO ztp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿O cho ngwa wiꞌ goꞌ? ¿Cho thi xaꞌ nok lar wena? Mne goꞌ ke, re xaꞌ nchok lar wen, nzo re lis re rey. ");
INSERT INTO ztp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Per, ¿cho ngwa wiꞌ go? ¿Cho thi profet ngwa wiꞌ goꞌ? Lipa nin lo goꞌ, thi profet ngwa wiꞌ goꞌ, nde xaꞌ nak mas ke thi profet. ");
INSERT INTO ztp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tak Juan reꞌ ngetej xkiꞌs Dios ta nchab: \"Na, telꞌ thi xaꞌ taꞌ xkiꞌs na kwiblo loa, sa leꞌ xaꞌ toxkwaꞌ xned la.\" ");
INSERT INTO ztp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na ni lo goꞌ, xij reta mbi' ngol xis izyo re', tera' yo thi profet mas ntak lo Juan, per xaꞌ jwanꞌ mas lud ntak ten' nyebe' Dios, xaꞌ ya mas ntak lo Juan. ");
INSERT INTO ztp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xata wiz ngo Juan ngole men axta naya, men toz nchal yote lo yalnyebeꞌ lo beꞌ nde re xaꞌ jwanꞌ lipa nchala re xa ya li gan yotey. ");
INSERT INTO ztp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tak reta profet nde ley, benta mdeja axta senꞌ sin Juan. ");
INSERT INTO ztp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nde tez goꞌ tli lazoꞌ goꞌy, Juan nak profet Elías ta nak diꞌs yeꞌda. ");
INSERT INTO ztp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tez cho ncholꞌas gon jwanꞌ reꞌ bin goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Cheꞌmod nak re men tyemp reꞌ. Nak xaꞌ xa nak re or bix ndyob lo xbiꞌ ngij nde mbez or lo tar: ");
INSERT INTO ztp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mtes náꞌ flaut nde naꞌnkanid goꞌ mbilꞌ náꞌ re di nabil ndye nde naꞌngonꞌta goꞌ” ");
INSERT INTO ztp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tak mbyed Juan, xaꞌ nanchad nde nachud xaꞌ bin, nde mbez goꞌ thi mbi narax ndono xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nde mbyed Xinꞌ Mbiꞌ, Xaꞌ ncha nde xaꞌ nchuꞌ xaꞌ, nde mbez goꞌ ncheꞌ ndob thi xaꞌ ncha ncho nde nchuꞌ bin, nde nzalꞌta xaꞌ re xaꞌ nthop tmi par Rom nde re xaꞌ nzo'b xken naꞌ. Per yalnchak chanꞌ Dios ndloꞌ por re jwanꞌ ndli men. ");
INSERT INTO ztp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zyasa mdobte Jesús mbrez Xaꞌ yek re men yez tenꞌ mas bro yalnaro mbli Xaꞌ, tak nandlad re xaꞌ ya re jwanꞌ narax nak xaꞌ, nde nambered xaꞌ lo Dios. Nde nchab Jesús: ");
INSERT INTO ztp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Nalat nya goꞌ, men yez Corazín! ¡Nalat nya goꞌ, men yez Betsaida! Tak tez yez Tiro nde yez Sidón ngak re yalnaro ta ngok yez goꞌ, ya ne' pola mseꞌ xaꞌ xgab xaꞌ, mblaꞌ xaꞌ re jwanꞌ narax nak xaꞌ, ngok xaꞌ lar nabaꞌd nde mchub xaꞌ diloki yek xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jwanꞌ nasa nin lo goꞌ, wis tayaꞌ re men kwent lo Dios, mas naleꞌ pen ya re xaꞌ Tiro nde re xa ꞌSidón, ke pen ya goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nde lu, xaꞌ yez Capernaum, ¿Ndyak goꞌ axta lo beꞌ sin goꞌ? Naꞌsinta goꞌ lo beꞌ leꞌ goꞌ sin axta lenꞌ yeꞌr abil. Tak tez lenꞌ yez Sodoma ngak re yalnaro ta ngok lenꞌ yez goꞌ, tata nzi yez Sodoma axta naya. ");
INSERT INTO ztp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jwanꞌ nasa nin lo goꞌ wis tayaꞌ re men kwent lo Dios, mas naleꞌ pen rid re xaꞌ yez Sodoma ke pen rid re goꞌ men yez Capernaum. ");
INSERT INTO ztp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tyemp ya Jesús nchab: —Nin diꞌs wen loa, Xud na, Xaꞌ nyebeꞌ lo beꞌ nde lo izyo, tak mkaꞌs la re jwanꞌ reꞌ lo re xaꞌ nchak nde lo re men nchen, nde mbloꞌ ley lo re xaꞌ nak xaja nak or bixa. ");
INSERT INTO ztp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ta ngoka xud na, tak tamod mbroꞌ lazoꞌa mblia. ");
INSERT INTO ztp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Xud na mdayaꞌ reta jwanꞌ lon. Nde ngen cho nzolopa na, benꞌta Xud na nzolo na, nde ngen cho nzolo Xud na, benꞌta na nzolo Xaꞌ, nde na loꞌ Xaꞌ lo re men jwanꞌ ncholas na lonꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Deꞌ goꞌ lon, reta goꞌ jwanꞌ mzan lo re jwanꞌ ndli goꞌ nde re goꞌ jwanꞌ mzan neꞌ re xken na, na li ryoxkwen goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Beꞌ goꞌ yug na nde pteꞌd goꞌ lon, tak na nabeꞌz nak na nde nadoꞌ lazonꞌ, tamod sa ryoxkwen goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tak naleꞌ rsin na nde naxax yoꞌ jwanꞌ tan we goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tyemp ya, Jesús ndarid ndab xij tenꞌ nzobin trig, kon re xin'te'd Xaꞌ, lenꞌ wiz ndryoxkwen men. Zyasa re xin'te'd Jesús mziꞌb ndlyanꞌ xaꞌ nde mdobte xaꞌ mthop xaꞌ trig mda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Senꞌ lo mbwiꞌ re xaꞌ fariseo jwanꞌ na, nchab xaꞌ lo Jesús: —Wiꞌ nea, re xin'te'd la ngeli jwanꞌ nandablod xaꞌ li xaꞌ wiz jwanꞌ ndryoxkwen men. ");
INSERT INTO ztp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Per Jesús mkab: —¿Cho teraꞌ lab goꞌ jwanꞌ mbli David, senꞌ lo ndyanꞌ xaꞌ kon re men nda no xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ngote xaꞌ lenꞌ liz Dios nde mda xaꞌ re pan nayon jwanꞌ nandabloda wa xaꞌ, nek xaꞌ nde nek re men jwanꞌ ndano xaꞌ, benꞌta re xaꞌ nak nglweyꞌ ndablo way. ");
INSERT INTO ztp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O teraꞌ lab goꞌ ley chanꞌ Moisés, ke re xaꞌ nak nglweyꞌ ndli xaꞌ sinꞌ lo yodoꞌ wiz ndryoxkwen men nde nanakte yalke? ");
INSERT INTO ztp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nde naya nin lo goꞌ ncheꞌya ndo thi Xaꞌ mas ndak ke yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nde tez ngaka yen goꞌ kwan liy ta nchab xkiꞌs Dios: “Yalndlat lazoꞌ ncholas na li goꞌ, nancholasta na kuj goꞌ maꞌ taꞌ goꞌ lon”, nde tez yen goꞌy pa keꞌ goꞌ yalke xis men jwanꞌ ngen cho yalke nchap. ");
INSERT INTO ztp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tak Xinꞌ Mbiꞌ, nak xwanꞌ wiz ta ndryoxkwen mena. ");
INSERT INTO ztp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zyasa mbroꞌ Jesús nda Xaꞌ nde ngote Xaꞌ lenꞌ yo tenꞌ ndyop xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nde tya ndo thi mbiꞌ mbis thi yaꞌ xaꞌ, zyasa re xaꞌ fariseo nkwanꞌ xaꞌ xa keꞌ xaꞌ yalke yek Jesús, jwanꞌ na mnab diꞌs xaꞌ lo Jesús, nchab xaꞌ: —¿Cho tayal todanꞌ men ti xaꞌ yis lenꞌ wiz ta ndryoxkwen men? ");
INSERT INTO ztp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Leꞌ Jesús mkab: —Tez xanya thi goꞌ ba, ngeno thi mbakxilꞌ nde gab maꞌ lenꞌ thi yeꞌr lenꞌ wis jwanꞌ ndryoxkwen men, ¿cho naꞌkoted goꞌ maꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Choleta ti men plopa mas ntak ti men lo thi mbakxilꞌ! Jwanꞌ nasa, toyal li men jwanꞌ wen lenꞌ wis ndryoxkwen men. ");
INSERT INTO ztp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zyasa nchab Jesús lo mbiꞌ ta mbis yanꞌ ya: —Ptagaꞌ yaꞌa. Nde senꞌ mtagaꞌ xaꞌ yaꞌ xaꞌ, mdyanꞌ yaꞌ xaꞌ, mbyanꞌna xaja nak tadiba. ");
INSERT INTO ztp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nde senꞌ mbrote re xaꞌ fariseo tya, mdobte xaꞌ mdodiꞌs xaꞌ xamod kuj xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Senꞌ mne Jesús jwanꞌ na, mxen Xaꞌ ned nda Xaꞌ tedib lad, nde men toz mdonke xis Xaꞌ. Nde ntodanꞌ Xaꞌ reta men yis, ");
INSERT INTO ztp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nde mnabeꞌ Jesús lo re men sa naꞌtejta xaꞌ cho nak Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tamod sa ngok jwanꞌ mdej profet Isaías, senꞌ nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Wiꞌ goꞌ nea xaꞌ reꞌ mblín sa li xaꞌ sinꞌ lon, xaꞌ reꞌ nkeꞌ toz lazonꞌ, nde xaꞌ ngo nale lazoꞌn. Nde tan Mbi Nayon chanꞌ na tyono xaꞌ, nde xaꞌ tej yalnyebeꞌ chanꞌ na lo reta yez nzi xis izyo. ");
INSERT INTO ztp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naꞌyod xaꞌ men, nde naꞌkwesned Xaꞌ, neꞌka kwes Xaꞌ re ned. ");
INSERT INTO ztp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Naꞌnge kwan lino xaꞌ re men jwanꞌ nak xaja nak yi jwanꞌ mer gas, nde taga nge kwan lino xaꞌ men jwanꞌ nak xaja mech jwanꞌ benꞌta sen ndob, axta kebeꞌ yanꞌ jwanꞌ galꞌ lo izyo. ");
INSERT INTO ztp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nde reta men xis izyo kembed men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Zyasa ngwano xaꞌ lo Jesús, thi xaꞌ biꞌ nkow lon' nde ngup, nzo mbi narax lenꞌ lazoꞌn. Nde Jesús mtodanꞌ mbiꞌ ya, mbwiꞌ mbiꞌ nde mni mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Zyasa reta men nzoyen toz xaꞌ, nde nchab xaꞌ: —¿Cho Xaꞌ reꞌ nak Xaꞌ nde lo bin David? ");
INSERT INTO ztp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lo senꞌ re xaꞌ fariseo senꞌ lo mbin xaꞌ jwanꞌ na nchab xaꞌ: —Mbiꞌ reꞌ ngote mbi narax, tak Beelzebú xaꞌ nyebeꞌ lo reta mbi narax, mdaꞌ yalne lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Leꞌ Jesús mnela cho xgab ndli re xaꞌ ya, nchab Jesús lo xaꞌ: —Reta xaꞌ nyebeꞌ jwanꞌ ngeno byo tenꞌ nyebeꞌ xaꞌ, leꞌga leꞌ xaꞌ nchak rol xaꞌ, nde ti yez o ti lis men jwanꞌ leꞌga leꞌ xaꞌ ngyo xaꞌ nchak rol xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nde tez Maxuꞌ leꞌga leꞌ Maxuꞌ ngote xaꞌ xaꞌ, leꞌ ngeli rol xaꞌ yalnyebeꞌ chanꞌ xaꞌ, ¿Xomod kwebe yalnyebeꞌ chanꞌ xaꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tez na ngoten re mbi narax kon yalne ndaꞌ Beelzebú, ¿Cho ndaꞌ yalnyebeꞌ lo re men goꞌ sa ngote xaꞌ mbi narax? Jwanꞌ nasa leꞌga leꞌ men goꞌ loꞌ lo goꞌ ke ngan goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per na kon Mbi Nayon chanꞌ Dios ngoten re mbi narax, jwanꞌ reꞌ ndloꞌ liga leꞌ yalnyebeꞌ chanꞌ Dios ndo la lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tak ¿Xamod li men gan yote men lis thi xaꞌ mas ne nde we wanꞌ men re chanꞌ xaꞌ, tez ner naꞌtobod men xaꞌ? Zyara teyal we men re chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Xaꞌ jwanꞌ nandod kon na, xaꞌ ya narax nye na, nde xaꞌ jwanꞌ naꞌnthopta jwanꞌ kon na, xaꞌ ya nchaꞌs jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jwanꞌ nasa nin lo goꞌ, reta yalke nde reta yalnixin toyal dyonꞌ na lo re mbiꞌ, per re xaꞌ nixin xis Mbi Nayon naꞌdyonꞌta xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nde choja men nixin xis Xinꞌ Mbiꞌ, tayal ndyonꞌ xken xaꞌ, per xaꞌ jwanꞌ nixin xis Mbi Nayon nadyonꞌta xken xaꞌ nek lo izyo reꞌ nde neka lo izyo nara yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Goꞌ mne xa nak ti ya ba, ya wen ndaꞌy ngud wen, nde ya bsin nandade ngud wen. Tak re ya ncholo mena por ngud nke lo ney. ");
INSERT INTO ztp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Go' ba nya lo bin mzib ba nak goꞌ! ¿Xamod ryoꞌ diꞌs wen ro goꞌ, tak men xkap goꞌ? Tak re jwanꞌ nzo lenꞌ lazoꞌ men jwanꞌ na ndryoꞌ ro men. ");
INSERT INTO ztp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Xaꞌ wen, diꞌs wen ndodiꞌs xaꞌ tak jwanꞌ na nzo lazoꞌ xaꞌ, nde xaꞌ xkap diꞌs xkap ndodiꞌs xaꞌ tak jwanꞌ na nzo lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Leꞌ na nin lo goꞌ reta diꞌs jwanꞌ andoja ndye ndryoꞌ ro re men, reta diꞌs ya nyab Dios kwen lo men senꞌ sin wiz jwanꞌ tayaꞌ re men kwent lo Dios. ");
INSERT INTO ztp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tak leꞌga leꞌ re diꞌs mnia koxoba nenꞌ cho nambi ndoa o nzo'b xken la. ");
INSERT INTO ztp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Zyasa nchab pla maestr nchak ley nde pla xaꞌ fariseo lo Jesús, nchab xaꞌ: —Maestr, ncholas náꞌ wiꞌ náꞌ lia thi yalnaro. ");
INSERT INTO ztp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Leꞌ Jesús mkab: —Re goꞌ men xkap nde men nkwinꞌ, nyab goꞌ wiꞌ goꞌ thi yalnaro, per naloꞌd nay lo goꞌ, benꞌta xa ngote profet Jonás wi goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tak xa ngo Jonás lenꞌ mbel ro son wiz nde son yalꞌ, taga yo Xinꞌ Mbiꞌ lenꞌ izyo son wiz nde son yalꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nde wiz senꞌ koꞌxban Dios re men sa nyaꞌb Dios kwent, wiz ya re men yez Nínive gab liga nchap re xaꞌ nzi naya yalke, tak xaꞌ Nínive mblaꞌ xaꞌ re jwanꞌ narax mbli xaꞌ lo senꞌ mni Jonás lo xaꞌ. Nde naya ncheꞌ ndo thi Xaꞌ mas ndak ke Jonás. ");
INSERT INTO ztp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nde noga ngol ta ngok rey lo yez Saba, ryo'to wiz senꞌ nyab Dios kwent lo re men, nde gab ngol nchap re xaꞌ tyemp reꞌ yalke, tak ngol ya mbroꞌ axta plo mdib ro izyo, mbyed yon xaꞌ yalnchak chanꞌ Salomón, nde naya ncheꞌ ndo thi xaꞌ mas ndak lo Salomón. ");
INSERT INTO ztp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Senꞌ ndryote thi mbi narax lenꞌ lazoꞌ thi men, nketey re izyo biz ngete kwanꞌ na plo ryoxkwen na, per lo nazyaltay plo ryoxkwen na, zyasa ndliy xgab: ");
INSERT INTO ztp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Beren tenꞌ mbroꞌteꞌn.” Lo senꞌ mbere mbi narax tenꞌ mbroꞌy nchosiba men ya, xaja thi yo mblyoba nde nzi re jwanꞌ nawe nyay nde ngen cho nzoy. ");
INSERT INTO ztp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Zyasa mbi narax ya nda thop thi gas mbi narax mas nakap nak ke lo mbi narax ya, nde ndyenta reta mbi narax nde ndlyay lenꞌ lazoꞌ men ya nde nchanꞌna nchoy tya, zyasa mas ndryo jwanꞌ ndyak men ya ke lo jwanꞌ mxak ner xaꞌ. Taga yate re xaꞌ xkap nzo nal tyemp reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Laja benꞌ ndo ni Jesús lo re men, mzin xnaꞌ Jesús nde kon re wes Xaꞌ nzi mbed re xaꞌ le, tak ncholas xaꞌ todiꞌsno xaꞌ Jesús ");
INSERT INTO ztp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nde ngwa thi xaꞌ ngwayab lo Jesús: —Leꞌ xnaꞌa nde kon re wes la nzi le ba, ncholas xaꞌ todiꞌsno xaꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per leꞌ Jesús mkab lo xaꞌ ta ngwayaba lo Jesús: —¿Cho nak xnaꞌn, nde cho nak re wes na? ");
INSERT INTO ztp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Zyasa mbloꞌ yaꞌ Jesús re xin'te'd xaꞌ nde nchab xaꞌ: —Re xaꞌ reꞌ nak xnaꞌn, nak re wes na nde re btan na. ");
INSERT INTO ztp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tak reta xaꞌ ndli jwanꞌ ncholas Xud na jwanꞌ ndob lo beꞌ, xaꞌ ya nak wes na, btanꞌ na nde xnaꞌn. ");
INSERT INTO ztp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wiz ya mbroꞌ Jesús yo nde ngwa Xaꞌ mdob Xaꞌ gax ro nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nde men toz mdyop lo Jesús, nde Jesús ngwap lo bark, tya mdob Xaꞌ, laja re men nzi ro yux. ");
INSERT INTO ztp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zyasa mtoteꞌd Jesús re men kon naꞌr toz re diꞌs nagan yen men, nde nchab Xaꞌ: —Ngo thi mbiꞌ mbroꞌ nda chas mbis trig. ");
INSERT INTO ztp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nde senꞌ nge chaꞌs xaꞌ trig, pla mbis ngob lo ned, nde mbyed mbyin nde mda maꞌ re mbis. ");
INSERT INTO ztp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pla mbis ngob xij re ke, plo nangenta bro yo, nde nayen mblyen na tak lud yo nzoy. ");
INSERT INTO ztp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per senꞌ lo mbla be, mtolꞌ bey, tak nangenta lox ney mbiza. ");
INSERT INTO ztp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nde thi play ngob xij yis, nde senꞌ mxyen yis mtoꞌwa lo jwanꞌ bin. ");
INSERT INTO ztp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per thi play ngob izyo wen, nde jwin ngoka, choy mdaꞌ thib ayoꞌ mbis, choy mdaꞌ son gal mbis, nde choy mdaꞌ galpsiꞌ mbis. ");
INSERT INTO ztp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tez cho goꞌ ndob nzanꞌ, bin goꞌ jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zyasa re xin'te'd Jesús mbike gax xaꞌ lo Jesús nde mnaꞌd di's xaꞌ: —¿Kwan liy sa diꞌs nagan nia lo re men? ");
INSERT INTO ztp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Leꞌ Jesús mkab: —Lo re goꞌ ndaꞌ Dios yen goꞌ re jwanꞌ nzonagaꞌs, chanꞌ yalnyebeꞌ lo beꞌ, per lo re xaꞌ ba namdad Dios sa. ");
INSERT INTO ztp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tak xaꞌ jwanꞌ nchenla, masray yen xaꞌ, bro jwanꞌ yen xaꞌ, per xaꞌ jwanꞌ lud nchen, xaꞌ ya axta jwanꞌ lud nchen xaꞌ yiꞌb lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jwanꞌ nasa kon diꞌs nagan ndej na re jwanꞌ lo re men, tak teꞌnye ngwiꞌ xaꞌ na nanchonid lo xaꞌ, nde teꞌnye ndo yon xaꞌy, nayenta xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tamod lo re xaꞌ reꞌ ndoyak re jwanꞌ mni profet Isaías senꞌ lo nchab xaꞌ: Teꞌnye mas kenza goꞌ, per nayenta goꞌ, tenye mas ngwiꞌ goꞌ, per nayoxnid lo goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tak ngok ne lazoꞌ yez reꞌ, nde nanchonta xaꞌ diꞌs, nde mbyowꞌ ngudlo xaꞌ, sa nayonid lo xaꞌ, nek gon xaꞌ diꞌs nde neꞌka lazoꞌ xaꞌ naꞌyenta, neka bere xaꞌ lon sa todanꞌ na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Per nabe'z toz nda re goꞌ tak ndoyal ngwiꞌ goꞌ nde ndoyal nchon goꞌ jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lipa nin lo goꞌ ke naꞌr toz re profet nde re xaꞌ galꞌ ndo, mdablaꞌs ngwiꞌ jwanꞌ ta ngwiꞌ goꞌ reꞌ, per naꞌngwiꞌd xaꞌy, ncholaꞌs xaꞌ ngon xaꞌ reta jwanꞌ nchon goꞌ per naꞌngonta xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Naya na bin goꞌ, nyenꞌ, xomod nak diꞌs nagan chanꞌ xaꞌ ngo bin. ");
INSERT INTO ztp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nde nzo xaꞌ nchon xkiꞌs Dios nde naꞌyenta xaꞌy, zyasa nde Maxuꞌ nde nkib Maxuꞌ diꞌs ta ngobin lenꞌ lazoꞌ xaꞌ ya. Xaꞌ ya nak xa nak mbis ta ngob lo neda. ");
INSERT INTO ztp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Leꞌ mbis ta ngob xij re ke ya, nak xa nak re xaꞌ nchon xkiꞌs Dios nde nale ncho lazo xaꞌ, nchon xaꞌy ");
INSERT INTO ztp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ta xa nak jwanꞌ bin ngentosta lox ney nde naxektay, ta nak xaꞌ senꞌ lo nde re yalti o nchobla men xaꞌ tak ndli lazoꞌ xaꞌ xkiꞌs Dios, zyasa ndlaꞌ xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Leꞌ mbis ta ngob xij yis, nak xa nak re xaꞌ nchon xkiꞌs Dios, per lo ndli xaꞌ xgab re jwanꞌ lo izyo reꞌ, nkwinꞌno lazoꞌ xaꞌ ndyablaꞌs xaꞌ keno xaꞌ jwanꞌ lo izyo reꞌ nde ndlaꞌ xaꞌ xkiꞌs Dios, naꞌtadey diꞌs xyen xaꞌ lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbay leꞌ mbis ta ngob izyo wen, nak xa nak re xaꞌ nchon xkiꞌs Dios nde nchen xaꞌy, ndli xaꞌ jwanꞌ nchalaꞌs Dios xaja ti mbisa, nzoy mdaꞌ thib ayoꞌy, nzoy mdaꞌ son gala, nde nzoy mdaꞌ gal bsiꞌ mbis. ");
INSERT INTO ztp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús mdej tedib kwent nzo jwanꞌ nagan yen men lo re xaꞌ nchab: —Leꞌ yalnyebeꞌ lo beꞌ nak, xa nak thi mbiꞌ mbli bin trig, ");
INSERT INTO ztp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","per laja nziyat re xaꞌ, mbyed xaꞌ ngiꞌno xaꞌ ya, nde mbli bin xaꞌ xij mbis trig tib ned mbis wan nde ndya xa'. ");
INSERT INTO ztp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Laja ndoxen trig nde senꞌ mbroꞌ go'b lo ney, zyasa noga re wan yis nzo xijaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Zyasa re xaꞌ nge sinꞌ nchab xaꞌ lo xaꞌ nak chanꞌ bin: Xaꞌ nyebeꞌ, “¿Cho nanakta mbis wen mblo bin goꞌ lenꞌ chanꞌ goꞌ? ¿Plo mbroꞌ re wan na?” ");
INSERT INTO ztp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Leꞌ xaꞌ nak chanꞌ jwanꞌ bin nchab: “Thi xaꞌ ngiꞌno na mbli jwanꞌ reꞌ.” Nde leꞌ re xaꞌ nge sinꞌ nchab lo xaꞌ: “¿Cho ncholas la ya kib náꞌy?” ");
INSERT INTO ztp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Leꞌ xaꞌ nak chanꞌ bin mkab: “Blaꞌ goꞌ nakibta goꞌy tak ndaga no trig naxkib goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pta' goꞌ diꞌs sa tita xyen ropa axta kebeꞌ ngok trig, zyasa gab na lo re xaꞌ nge sinꞌ, sa nerla re wan yis thop xaꞌ, nde tobo xaꞌy por manoj sa yola, seraꞌ thop xaꞌ trig sa kotsaꞌ xaꞌy tenꞌ nchotsaꞌ re mbis. ");
INSERT INTO ztp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús mdej tedib diꞌs nagan, nde nchab Xaꞌ: —Leꞌ yalnyebeꞌ lo beꞌ nak xa nak thi mbis mostaz, jwanꞌ nxenꞌ thi mbiꞌ lenꞌ izyon xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","leꞌ mbis mostaz nak mbis mas mbis bix lo reta mbis, per senꞌ lo nxyen na, leꞌy mas naro nxyen lo re jwanꞌ bin, nde axta re mbin ncheꞌdtoxkwaꞌ lyeꞌd naꞌ lo re xod ya. ");
INSERT INTO ztp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nde noga mdej Jesús tedib diꞌs nagan: —Leꞌ yalnyebeꞌ lo beꞌ nak xaja nak levadur, jwanꞌ mkos ti ngol tson medid arin nde teꞌnye luda mblas mbiy dib koꞌb. ");
INSERT INTO ztp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Reta jwanꞌ mbloꞌ Jesús, kon Diꞌs nagan mbloꞌ Jesusa lo reta men, nde nek tib jwanꞌ nambloꞌd Xaꞌ tez namblirxsinꞌta Xaꞌ ti diꞌs nagan. ");
INSERT INTO ztp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tamod ngok jwanꞌ mdej profet senꞌ lo nchab xaꞌ: —Kon kwent nin re jwanꞌ lo men, lo senꞌ tej na reta jwanꞌ nzo nagaꞌs, desde senꞌ mdoxkwaꞌ Dios izyo. ");
INSERT INTO ztp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Senꞌ, mne mdodiꞌsno Jesús re men, ngote Xaꞌ lenꞌ yo, zyasa mbike re xin'te'd Xaꞌ nde nchab xaꞌ lo Jesús: —Bloꞌxkan lo náꞌ xamod nak kwent chanꞌ wan xkap kon trig. ");
INSERT INTO ztp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Zyasa Jesús nchab: —Xaꞌ ngobin mbis wen nak Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Leꞌ tenꞌ ncho bin nak dib izyo, nde mbis wen nak re xinꞌ Dios, leꞌ wan xkap nak re xinꞌ Maxuꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Leꞌ xaꞌ nayiꞌ mblo bin mbis xkapa nak Maxuꞌ. Lo dyop jwanꞌ ngok nak lo senꞌ lux izyo; nde re xaꞌ thop jwanꞌ ngok nak re anj. ");
INSERT INTO ztp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nde ta xa nthop men re wan xkap, sa yol la, taxa mod aka lo senꞌ lux izyo. ");
INSERT INTO ztp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Leꞌ Xinꞌ Mbiꞌ telꞌ re anj chanꞌ Xaꞌ, sa kote anj reta xaꞌ jwanꞌ ndli nchab men lo jwanꞌ narax nde reta xaꞌ jwanꞌ ndli re jwanꞌ xkap tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nde kobi anj xaꞌ lenꞌ or ndob bel nde tya gon xaꞌ nde teꞌs kele xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Zyasa re xaꞌ galꞌ ndo anta ndlya bel nya xaꞌ tyob xni xaꞌ xaja nya wisa tenꞌ nyebeꞌ Xud xaꞌ. Tez cho goꞌ ndob nzan bin goꞌ jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tagaꞌ yalnyebeꞌ lo beꞌ nak xa nak thi jwanꞌ ndak toz nzo nagaꞌs lenꞌ wan, nde ti mbiꞌ ngosal la, nde bere mkaꞌs xaꞌy tya; nde nale toz nzo lazoꞌ xaꞌ ta mzyal xaꞌ jwanꞌ na nde ngwa xaꞌ mtho xaꞌ reta jwanꞌ ngeno xaꞌ, nde mxiꞌ xaꞌ wan ya. ");
INSERT INTO ztp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Noga yalnyebeꞌ lo beꞌ nak xa nak thi xaꞌ ndli niꞌ, kwanꞌ xaꞌ perla wen, ");
INSERT INTO ztp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","nde senꞌ lo mzyal xaꞌ thi perla jwanꞌ ndak toz tir, ngwa xaꞌ mtho xaꞌ reta jwanꞌ ngeno xaꞌ, nde mxiꞌ xaꞌ perla ya. ");
INSERT INTO ztp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Taga nak yalnyebeꞌ lo beꞌ, xa nak thi yeꞌd ngobi xaꞌ lo nittoꞌ, nde nchaga re ned mbel. ");
INSERT INTO ztp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lo senꞌ mzey, ngote xaꞌy ro yux, nde tya ndyob xaꞌ mbi xaꞌ re maꞌ wen nde ngotsaꞌ xaꞌ maꞌ lenꞌ chokwid, nde re maꞌ xkap ngobi xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Taga ak lo senꞌ lux izyo, yeꞌd re anj nde koxaꞌ xaꞌ re xaꞌ xkap xij re xaꞌ galꞌ ndo, ");
INSERT INTO ztp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nde ko anj re xaꞌ xkap lenꞌ or ndob bel, tya gon xaꞌ nde tyes kele xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nde mnaꞌb diꞌs Jesus lo re xin'te'd xaꞌ nchab xaꞌ: —¿Cho nchen goꞌ re jwanꞌ reꞌ? Re xin'te'd Jesús mkab: —Nchen naꞌy Señor. ");
INSERT INTO ztp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Zyasa nchab Jesús lo xaꞌ: —Reta maestr nchak xkiꞌs Dios, jwanꞌ mteꞌd xamod nak yalnyebeꞌ lo beꞌ, nak xajaꞌ thi xud mdyenꞌ, nchak ngote xaꞌ tenꞌ nzo tzaꞌ re jwanꞌ ntak toz ngeno xaꞌ, jwanꞌ gox nde jwanꞌ kub. ");
INSERT INTO ztp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Senꞌ lo mne mdej Jesús reta diꞌs nagan reꞌ, mbroꞌ Xaꞌ nda Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nde senꞌ mzin Xaꞌ yez Nazaret las Xaꞌ, mdobte Xaꞌ mbloꞌ Xaꞌ xkiꞌs Dios lo re men, lenꞌ yo tenꞌ ndyop xaꞌ Israel, nde re men nzo yen xaꞌ nchab xaꞌ: —¿Plo ngwa teꞌd mbiꞌ reꞌ reta yalnchak reꞌ? ¿Xomod nchak ndli Xaꞌ re yalnaro reꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Cho nanakta xud Xaꞌ ba ndoxkwaꞌ ya ya? ¿Cho na Marida nak xnaꞌ Xaꞌ nde re wes Xaꞌ nak Jakob, Jose, Simón nde Judas? ");
INSERT INTO ztp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Cho naxijta naꞌ reꞌ nzo re btanꞌ Xaꞌ? ¿Ploga ngwa ted Xaꞌ reta jwanꞌ nchak Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nde narax mbli xaꞌ xgab xis Jesús. Per Jesús nchab lo re men: —Reta yez nxoꞌbyek xaꞌ thi profet, benꞌta re xaꞌ yez Xaꞌ nde xaꞌ liz Xaꞌ nanxobyekta men xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nde naꞌndlid Jesus naꞌr yalnaro tya tak nandlid lazoꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiemp ya Herodes xaꞌ nyebeꞌ Galilea mbin xaꞌ, jwanꞌ nketeli Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nde nchab xaꞌ lo re men nge sinꞌ lo xaꞌ: —Juan ngole men nak xaꞌ ba, mbroxban xij re xaꞌ nguj, jwanꞌ nasa ngeno xaꞌ yalne ta ndli xaꞌ reta yalnaro ba. ");
INSERT INTO ztp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tak Herodes mnabeꞌ mxen xaꞌ Juan nde mtobo xaꞌ Juan kon kaden nde mkeꞌ lizyiꞌb xaꞌ Juan, xken Herodías ngol Blib wes Herodes. ");
INSERT INTO ztp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tak Juan nchab lo Herodes: —Nandabloda tyobnoa ngol wes la ");
INSERT INTO ztp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Zyasa Herodes ndonke kuj Juan, per nzyeb Herodes dib yez; tak dib yez nxoꞌbyek xaꞌ Juan xaja thi profet. ");
INSERT INTO ztp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per senꞌ lo ngoxoꞌb linꞌ Herodes, zyasa mzaꞌ xinꞌ Herodías ngwa mkani lo reta xaꞌ nzi tya, nde mbroꞌ toz lazoꞌ Herodes xamod mkani mza, ");
INSERT INTO ztp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tamod mdaꞌ Herodes xkiꞌs Herodes lo mzaꞌ, taꞌ Herodes one kwan nyab mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nde xnaꞌ mzaꞌ nchab lo mzaꞌ kwan nyaꞌb mzaꞌ, zyasa nchab mzaꞌ lo Herodes: —Ncholas na taꞌa ngudyek Juan ngole men lenꞌ thi yen lon. ");
INSERT INTO ztp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jwanꞌ na mblo nabil lazoꞌ rey Herodes, per lo mdaꞌa xaꞌ xkiꞌs xaꞌ lo nzi wiꞌ re men ta nzino xaꞌ, mnibeꞌ xaꞌ sa taꞌ xaꞌ jwanꞌ mnab mzaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","nde mnabeꞌ Herodes mchoꞌ yek Juan tenꞌ nge Juan lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nde ngwano xaꞌ yek Juan lo thi lenꞌ yen nde mda xaꞌy lo mzaꞌ nde mzaꞌ mdaꞌy lo xnaꞌ mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zyasa mzin re xin'te'd Juan, nde mbeꞌ xaꞌ thabol nde mkaꞌs xaꞌ nde ngwa tej xaꞌy lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Senꞌ mbin Jesús jwanꞌ na, ngwap xaꞌ lo bark nda xaꞌ lad izyo nagan sa yanꞌ tib xaꞌ, nde senꞌ lo mne re mena, mde ni re men mbroꞌ men re yez, nda xaꞌ tenꞌ sin Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nde senꞌ mbla Jesús lo bark, mbwiꞌ Xaꞌ men toz tir nzi tya, nde mblat lazoꞌ Jesús reta men, nde mtodanꞌ Jesus re xaꞌ nayiz. ");
INSERT INTO ztp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Senꞌ ndosea izyo, mbike re xinꞌ ted Jesús lo Xaꞌ, nde nchab xaꞌ: —Mzye toz la izyo, nde nagan ncheꞌ ya. Gus lo re men sa ya re men re rach sa ya tiꞌ xaꞌ jwanꞌ wa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Leꞌ Jesús nchab: —Nanakinꞌta xaꞌ ya xaꞌ, goꞌ pta' jwanꞌ wa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Re xin'te'd Jesús mkab: —Ngen kwan nak, benꞌta gayꞌ pan nde chop mbel ngeno náꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nde Jesús nchab: —Deꞌ no goꞌy ncheꞌya ");
INSERT INTO ztp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Zyasa mnibeꞌ Jesus lo re men tyob xaꞌ lo wan bix. Nde Jesús mxen xaꞌ re gayꞌ pan kon rop mbel, nde mbwiꞌ Xaꞌ lo beꞌ, nde mdaꞌ Xaꞌ dyux lo Dios nde mbli rol Xaꞌ pan mdaꞌ Xaꞌy lo re xin'te'd Xaꞌ nde re xin'te'd Xaꞌ mdida lo re men. ");
INSERT INTO ztp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Reta men mda xaꞌ axta kebeꞌ mze lenꞌ xaꞌ, nde tata mthop re xin'te'd Jesús tib sen chokwid jwanꞌ mbroꞌxob. ");
INSERT INTO ztp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lo reta xaꞌ jwanꞌ mda nak mer ti gayꞌ mil xaꞌ biꞌ, nde namblabta xaꞌ re ngol nde reta or bix. ");
INSERT INTO ztp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Xisa Jesús mbli ngwap re xinꞌ ted Jesús lo bark sa yate xaꞌ tedib lad ro nittoꞌ, laja ngoned Jesús re men. ");
INSERT INTO ztp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Senꞌ mne ndodiꞌsno Jesús re men toza ngwa Jesús yek yiꞌ sa tya todiꞌsno thib Xaꞌ Dios, nde senꞌ mbla yalꞌ thib Xaꞌ ndo tya. ");
INSERT INTO ztp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nde leꞌ bark ndola rol nittoꞌ, nde re bde ngin na bark tak leꞌ mbi cheꞌ nde ned nda bark. ");
INSERT INTO ztp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nde nakalraꞌ Jesús nda ni lo nittoꞌ lad lo bark tenꞌ nda re xin'te'd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lo senꞌ mbwiꞌ re xinꞌ ted Jesús, leꞌ Jesús ndyeni lo nittoꞌ, mzyeb toz xaꞌ nde mbrezyaj xaꞌ: — ¡Thi jwanꞌ bet ndeba! ");
INSERT INTO ztp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per Jesús mni lo xaꞌ nde nchab Jesús: —¡Naꞌzyebta goꞌ, nay, blo ne lazoꞌ goꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Zyasa mkab Pedr: —Señor, tez luy, bli teꞌn lo nit sa sin na loa ba ");
INSERT INTO ztp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Leꞌ Jesús nchab: —Deꞌ. Nde Pedr mbroꞌ lenꞌ bark tolo mde lo nit nda lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per senꞌ mbwiꞌ Pedr ne toz nde mbi mzyeb Pedr, nde tolo ndola Pedr lenꞌ nit, zyasa mbrezyaj Pedr: —¡Señor Btolaꞌn! ");
INSERT INTO ztp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nde Jesús zyaga mxen yaꞌ Pedr nde nchab: —¡Lud ndli lazoꞌa Dios! ¿Kwan liy ngok rop xgab la? ");
INSERT INTO ztp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nde senꞌ ngwap xaꞌ lo bark, ngotab mbi. ");
INSERT INTO ztp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Zyasa re xaꞌ nzo lenꞌ bark mdoxub xaꞌ lo Jesús nde nchab xaꞌ: —Li tirpa lu nak Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Senꞌ mne mbrid xaꞌ lo nit, mzin xaꞌ lo xyon xaꞌ Genesaret. ");
INSERT INTO ztp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nde senꞌ mbyolo re men izyo ya Jesús, mchaꞌs xaꞌ diꞌs lo re men lo dib izyo ya nde re men ngwano xaꞌ reta men nayiz lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nde mnab toz xaꞌ lo Jesús taꞌ Jesús diꞌs gal re xaꞌ yisa masa ro xab Jesus, nde reta xaꞌ jwanꞌ mbwal ro xab Jesús mdyanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Zyasa mbike pla xaꞌ fariseo nde kon pla maestr nchak ley mbroꞌ Jerusalen nchab lo Jesús: ");
INSERT INTO ztp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Kwan liy sa re xin'te'd la nanxobyekta xaꞌ mod gox, jwanꞌ ndli re xaꞌ gox pola? Nanad xaꞌ xa ndabloy, senꞌ ncha xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nde Jesús mkab lo re xaꞌ ya: —¿Mbay kwan ndliy noga goꞌ naꞌnxobyekta ley chanꞌ Dios, lo ndli goꞌ re mod gox jwanꞌ ndono goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tak Dios mnabeꞌ: \"Bxobyek xud la nde xnaꞌa, nde xanya men jwanꞌ nixinꞌ xis xud naꞌ o xis xnaꞌn, xaꞌ ya gaj.\" ");
INSERT INTO ztp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per goꞌ mbez, tez xanya men gab lo xud naꞌ o lo xnanꞌ: \"Nalid na gan laston la, tak reta jwanꞌ ngenon mdayalanay lo Dios.\" ");
INSERT INTO ztp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nde xaꞌ ta gaba, nandabloda laꞌsto xaꞌ xud xaꞌ o xnaꞌ xaꞌ. Tamod ngotal goꞌ yalnyebeꞌ chanꞌ Dios, sa li goꞌ mod gox ta ndono goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Goꞌ ba sa li nak men bxalꞌ nde men kwinꞌ! Galꞌka mni profet Isaías lo mdej goꞌ, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Re yez reꞌ, benꞌta ro xaꞌ mbez xaꞌ nxobyek xaꞌ na, per lazoꞌ xaꞌ tij ndoy lon. ");
INSERT INTO ztp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ngen cho sinꞌ li diꞌs wen ni go lon, tak re jwanꞌ ndloꞌ xaꞌ, benꞌta yalnyebe chanꞌ mena. ");
INSERT INTO ztp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zyasa mbrez Jesús re men toz nde nchab Xaꞌ: —Bin goꞌ nde byen goꞌ jwanꞌ reꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nanakta re jwanꞌ ncha men ndli nchak bew men, cheꞌla re diꞌs jwan ndryoꞌ ro men jwanꞌ na ndli nchak bew men. ");
INSERT INTO ztp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zyasa re xin'te'd Jesús mbike xaꞌ lo Jesús nde nchab xaꞌ: —¿Cho mnea ke re xaꞌ fariseo ngwad xaꞌ diꞌs senꞌ mbin xaꞌ jwanꞌ mnia yaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Leꞌ Jesús mkab nchab: —Reta ya jwanꞌ namblobinta Xud na ndob lo beꞌ, ndablo yiꞌb dib loxa. ");
INSERT INTO ztp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Blaꞌ goꞌ xaꞌ, tak xaja xaꞌ nkow lon' xaꞌ nde ngoꞌb kow xaꞌ ned lo tedib ned xaꞌ nkow lon'. Nde tez ti nkow lon' koꞌb xa' ned lo tedib xa' nkow lon', rop xaꞌ gab lenꞌ yeꞌr. ");
INSERT INTO ztp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Zyasa Pedr nchab lo Jesús: —Mbloxkan diꞌs nagan reꞌ lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nde Jesús mkab: —¿Cho noga goꞌ naꞌyenta diꞌs ya? ");
INSERT INTO ztp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Cho naꞌnchenta goꞌ, reta jwanꞌ ncha men, nday lenꞌ men, nde tya nryoꞌtey lo nda men wan? ");
INSERT INTO ztp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per re jwanꞌ ndryoꞌ ro men, lenꞌ lazoꞌ men ndryoꞌy nde jwanꞌ na ndli sa nchalal men, men beow. ");
INSERT INTO ztp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tak lenꞌ lazoꞌ men ndryoꞌ re xgab narax, re yalguj men, re xaꞌ jwanꞌ ngetano xaꞌ jwanꞌ nanakta salꞌ xaꞌ, re xaꞌ ndli re ned jwanꞌ xkap senꞌ nchaxno xaꞌ ta xaꞌ, re yalwanꞌ, re yalkeꞌjwals nde re yalnixin. ");
INSERT INTO ztp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Reta jwanꞌ reꞌ nchak beow men, per ta nanad men xa ndabloy lo wa men nandlibeowte men. ");
INSERT INTO ztp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nde tya mbroꞌ Jesús nda Xaꞌ lo xyon Tiro nde lo xyon Sidón. ");
INSERT INTO ztp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nde tya mbroꞌ ti ngol jwanꞌ nde lo xyon Canaan mbesyaj nde lo Jesús nchab: —¡Señor, Xaꞌ nde lo bin David, blat lazoꞌa na! Xinꞌ got na jwanꞌ toz nalat ndyak, tak jwanꞌ toz ngetati ti mbi narax or. ");
INSERT INTO ztp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per Jesús naꞌnkapta lo ngol. Zyasa re xin'te'd Jesús mbike gax nde mnab xaꞌ lo Jesús nchab xaꞌ: —Bloned xaꞌ ya xaꞌ, taja mbesyaj xaꞌ nde xaꞌ xis naꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zyasa mkab Jesús: —Dios mtelꞌ na benta lo re xaꞌ Israel jwanꞌ ngetetab xaja mbakxilꞌla. ");
INSERT INTO ztp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per leꞌ ngol mbike gax lo Jesús nde mdoxub ngol nchab ngol: —¡Blaston Señor! ");
INSERT INTO ztp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Leꞌ Jesús nchab: Nawenta naka kib men jwanꞌ ncha mdyenꞌ nde taꞌ mena lo re mbak. ");
INSERT INTO ztp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nde ngol nchab: —Taga naka, Señor, per axta re mbak ncha re kos nchab ro mes xwanꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Zyasa leꞌ Jesús nchab lo ngol: —¡Ngot, lu sa liga ndli toz lazoꞌa! Re jwanꞌ ncholaꞌs la aka xa ncholaꞌs la. Nde hor yaga mdyanꞌ mzaꞌ xinꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús mbroꞌ tya nde nda Xaꞌ nde mzi xaꞌ ro nittoꞌ Galilea, nde mdoke Xaꞌ axta yek yiꞌ nde mdob Xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nde men toz tolo mzin lo Xaꞌ, nde ndeno men re xaꞌ ngob nin, re xaꞌ syeg, re xaꞌ ngup, re xaꞌ nayiz yanꞌ, nde re men jwanꞌ xaxaꞌ yis ndyak. Mblek xaꞌ re xaꞌ ya lo Jesús nde Jesús mtodanꞌ re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nde nzoyen re men, senꞌ mbwiꞌ xaꞌ re xaꞌ ngup ndodiꞌs, re xaꞌ nayiz yanꞌ mdyanꞌ, re xaꞌ renk ndye, nde re xaꞌ nglwe ngwiꞌ. Zyasa ndobte xaꞌ mbli naro xaꞌ Dios chanꞌ xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zyasa Jesús mbrez re xin'te'd naꞌ, nde nchab Jesús lo xaꞌ: —Ndlat lazoꞌn re men, tak ndala son wiz ta nzi xaꞌ lon reꞌ, nde nangenod xaꞌ jwanꞌ wa xaꞌ. Nancholasta na goned na re xaꞌ tata win xaꞌ, ndaga nax keꞌ mbiy yek xaꞌ ned. ");
INSERT INTO ztp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nde re xin'te'd Jesús nchab: —Per ¿plo ya xiꞌ náꞌ jwanꞌ wa reta men toz reꞌ nde nagan cheꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Leꞌ Jesús mnab diꞌs: —¿Pla pan ngeno goꞌ? Leꞌ re xaꞌ mkab: —Gas pan nde chopson mbel bix. ");
INSERT INTO ztp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Zyasa Jesús mnibeꞌ mdob reta men izyo, ");
INSERT INTO ztp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","nde mxen Jesús re gas pan nde re mbel nde mdaꞌ Xaꞌ dyux lo Dios. Xisa mblirol Xaꞌ pan kon mbel nde mdaꞌ Xaꞌy lo re xin'te'd Xaꞌ, nde re xin'te'd Xaꞌ mdiꞌda lo reta men. ");
INSERT INTO ztp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nde mda re men axta kebeꞌ mze lenꞌ xaꞌ. Nde tata mthop xaꞌ gas chokwid re jwanꞌ mbroꞌxob. ");
INSERT INTO ztp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lo reta xaꞌ jwanꞌ mda nak, thap mil xaꞌ biꞌ, nde namblabta xaꞌ re ngol nde reta or bix. ");
INSERT INTO ztp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngolo mni Jesus lo re men, leꞌ Jesús ndya, ngwap Jesús lo bark nda xaꞌ lo xyon xaꞌ Magdala. ");
INSERT INTO ztp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Re xaꞌ fariseo nde re xaꞌ saduceo ngwa lo Jesús, sa mnab xaꞌ li Jesús ti yalnaro, nenꞌ cho liga lo beꞌ nde Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per Jesús mkab lo re xaꞌ ya: —Senꞌ ndala yalꞌ, mbez goꞌ: \"Nabeꞌz ak wiz yeꞌ, tak nane nya lo beꞌ\". ");
INSERT INTO ztp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Leꞌ tilꞌ mbez goꞌ: \"Narax ak wiz naya, tak nane nya beꞌ nde nzo xkowa.\" ¡Makwinꞌ! nchak takbeꞌ goꞌ lo beꞌ, per naꞌyenta goꞌ re yalnaro jwanꞌ ndoyak na tyemp reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xaꞌ xkap re goꞌ nde ndli goꞌ jwanꞌ nchalaꞌs goꞌ tyemp reꞌ, nyab goꞌ yalnaro, per naꞌwiꞌd goꞌ tedib yalnaro, benꞌta jwanꞌ ngok lo profet Jonás wiꞌ goꞌ. Nde mblaꞌ Jesús re xaꞌ ya nde nda Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Senꞌ mzin xin'te'd Jesús tedib lad ro nit, mbyaj yek xaꞌ ngweꞌ xaꞌ pan. ");
INSERT INTO ztp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zyasa nchab Jesus lo xaꞌ: —Nda wiꞌ toz goꞌ kon levadur chanꞌ re xaꞌ fariseo nde xaꞌ saduseo. ");
INSERT INTO ztp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Zyasa re xin'te'd Jesús nchab xaꞌ lo ta xaꞌ: —Kwent nandenod naꞌ pan jwanꞌna ta mbez Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús mnela jwanꞌ ndo diꞌs xaꞌ nde nchab Jesús lo xaꞌ: —¿Kwan liy mbez goꞌ nangenod goꞌ pan? ¡Lud toz ndli lazoꞌ goꞌ Dios! ");
INSERT INTO ztp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cho tata tera yen goꞌ, neꞌka nteꞌlaꞌs goꞌ re gayꞌ pan ta mblirol na mda re gayꞌ mil men nde pla chokwid jwanꞌ mbroꞌxob mtop goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nde cho na ntelaꞌsta goꞌ re gas pan ta mblirol na mda re thap mil men, nde pla chokwida mthop goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Kwan liy sa naꞌyenta goꞌ, leꞌ na nandotejta pan, senꞌ nin lo goꞌ ndawiꞌ goꞌ kon levadur chanꞌ xaꞌ fariseo nde xaꞌ saduseo? ");
INSERT INTO ztp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Zyara sa mbyen xaꞌ, leꞌ Jesús nandotejta levadur jwanꞌ ncho pan, leꞌ Xaꞌ ndej re jwanꞌ ndloꞌ re xaꞌ fariseo nde re xaꞌ saduseo. ");
INSERT INTO ztp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Senꞌ mzin Jesús lo xyon Cesarea Filipo, mnab diꞌs Xaꞌ lo re xin'te'd Xaꞌ: —¿Cho mbez men nak Xinꞌ Mbiꞌ jwanꞌ nak na reꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Leꞌ re xaꞌ mkab: —Cho xaꞌ mbez na, Juan Ngole mena, cho xaꞌ mbez Elias sa, nde pla xaꞌ mbez Jeremias sa, o nzo cho ti profeta. ");
INSERT INTO ztp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nde Jesús nchab lo xaꞌ: —Mbay goꞌ, ¿cho nak na ndyak goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Leꞌ Simón Pedr mkab: —Lu nak Crist, Xinꞌ Dios naban. ");
INSERT INTO ztp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zyasa nchab Jesús: —Nabeꞌz toz ndaa, Simón, xinꞌ Jonás, tak nek tib men nambloꞌd jwanꞌ reꞌ loa, jwanꞌ reꞌ mbloꞌ Xud na ndob lo beꞌ loa. ");
INSERT INTO ztp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nde nogaꞌ na ni loa, lu nak Pedr, nde xis ke reꞌ toxkwan yodoꞌn na, nde neka yalne chanꞌ yalguj naꞌlid gan lo ney. ");
INSERT INTO ztp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nde loa tan re yab chanꞌ yalnyebeꞌ lo beꞌ; reta jwanꞌ toboa lo izyo reꞌ, tyobo'y lo beꞌ, nde reta jwanꞌ koxak la lo izyo reꞌ, taga' yoxaka lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Zyasa Jesús mnibeꞌ lo re xin'te'd Xaꞌ sa ngen cho lo tej xaꞌ leꞌ Jesús nak Crist. ");
INSERT INTO ztp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Xata zya ndobte Jesús ndej Xaꞌ lo re xin'te'd Xaꞌ, ndablo ya Xaꞌ Jerusalén nde re xaꞌ gox jwanꞌ nyebeꞌ lo re xaꞌ Israel, re nglweyꞌ jwanꞌ nyebeꞌ, nde maestr nchak ley, toti xaꞌ Xaꞌ nde kuj xaꞌ Xaꞌ, nde yoxob byon wiz ryoꞌxban Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Zyasa xaꞌta mbeꞌ Pedr Xaꞌ nde tolo mbrez Pedr lo Xaꞌ nchab Pedr: —¡Señor blat lazoꞌa la, nandabloda tyak la jwanꞌ reꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per Jesús mbyek nde nchab Jesús lo Pedr. —¡Bike tib blad, Maxuꞌ!, naꞌtowꞌta la lon. Tak nantobta la xgab la lo chan' Dios, leꞌa ndob xgab la jwan' lo izyo re'. ");
INSERT INTO ztp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Zyasa nchab Jesús lo re xin'te'd Xaꞌ: —Tez cho goꞌ, nchola's tyonke xis na, bkalo go' lo re jwan' ndyen goꞌ li goꞌ, bta'ya' lazo' go' rid go' pen reta wiz xaja men ne' kruza nde ptonke goꞌ xis na. . ");
INSERT INTO ztp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tak men jwanꞌ ncholas tolaꞌ yalnaban chanꞌ naꞌ, xaꞌ ya taꞌb yalnaban chanꞌ xaꞌ, per men jwanꞌ gaj por kwent chanꞌ na men ya li gan yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tak ¿cho sinꞌ li lo men tez li men gan reta jwanꞌ lo izyo reꞌ nde taꞌb men xbin men? ¿O plopa kix men sa lyaꞌ xbin men? ");
INSERT INTO ztp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tak leꞌ Xinꞌ Mbiꞌ yed Xaꞌ kon reta yalnaro chanꞌ Xud Xaꞌ nde kon re anj chanꞌ Xaꞌ, zyasa kix Xaꞌ lo kad tib men por jwanꞌ mbli men. ");
INSERT INTO ztp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lipa nin lo goꞌ, nzo pla goꞌ jwanꞌ nzi treꞌ naya, naꞌgajta goꞌ axta kebeꞌ wiꞌ goꞌ nde Xinꞌ Mbiꞌ yeꞌd nyebeꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mbrid xop wiz, xaꞌta mbeꞌ Jesús Pedr, Jakobo kon Juan wes Jakobo, nda xaꞌ thi yek yiꞌ ro; ");
INSERT INTO ztp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","nde tya mzyeꞌ nya Jesús lo re xaꞌ. Lo Jesús anta ndlyabel nya xaja wisa, xab Xaꞌ ngok nakis anta ndlyabel nya. ");
INSERT INTO ztp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nde ta nzi wiꞌ xaꞌ xaj mbroꞌto Moisés kon Elías, ndotadiꞌsno xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Zyasa Pedr nchab lo Jesús: —Señor, ¡lejka nzi náꞌ ncheꞌ ya! Tez cholaꞌs la toxkwaꞌ náꞌ son ramad: tiba kaa, tiba ka Moisés nde tediba ka Elías. ");
INSERT INTO ztp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Laja benꞌ ndotodiꞌs Pedr, ti xkow anta ndlyabel nya mkota re xaꞌ nde xij xkowa mbyen ti bi nchab: —Xaꞌ re nak Xinꞌ na jwanꞌ nkeꞌ toz lazoꞌn, nde nale toz nzo lazoꞌn ngwiꞌn Xaꞌ. Bin goꞌ diꞌs ro Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lo mbin xin'te'd Jesús jwanꞌ na, mdoxub xaꞌ axta mdinꞌ lo xaꞌ izyo nde mzyeb toz xaꞌ ");
INSERT INTO ztp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Zyasa Jesús mbike lo xaꞌ nde mbwal Jesús xaꞌ nde nchab Jesús lo xaꞌ: —Ptoli goꞌ, naꞌzyebta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nde senꞌ mblit xaꞌ lo xaꞌ, ngen cho nak benꞌta tib Jesús ndo. ");
INSERT INTO ztp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lo senꞌ ndela re xaꞌ mbroꞌ xaꞌ yiꞌ ya, Jesús mnibeꞌ lo re xaꞌ, nchab Jesús: —Naꞌngecho lo tej goꞌ jwanꞌ ta mbwiꞌ goꞌ, axta kebeꞌ ryoxban Xinꞌ Mbiꞌ xij re xaꞌ nguj. ");
INSERT INTO ztp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zyasa re xin'te'd Jesús mnabdiꞌs xaꞌ lo Jesús: —¿Kwan li sa, mbez re maestr nchak ley, ndablo Elías ner yeꞌd? ");
INSERT INTO ztp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús mkab: —Ligay, Elías ner yeꞌd, nde xaꞌ naxut tanꞌ re jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per na nin lo goꞌ, Elías ya mbyed la nde re xaꞌ naꞌndlid lazoꞌ xaꞌ Elías, cheꞌla mblino xaꞌ xaꞌ xa nchalas xaꞌ, nde taga' Xinꞌ Mbiꞌ ndoja li no Xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zyara sa mbyen re xin'te'd Jesús, leꞌ Xaꞌ ndotej Juan Bautist. ");
INSERT INTO ztp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Senꞌ mzin xaꞌ tenꞌ nzi re men, mbike ti xaꞌ biꞌ gax lo Jesús, nde mdoxub xaꞌ nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, blat lazoꞌa xinꞌ na, tak leꞌr nkeꞌ mbiy chonꞌ, nde senꞌ nkeꞌ mbiy chor ne toz tir ndyak or, tak nar toz gob nchab or lo ki nde nar toz gob nchab or lo nit. ");
INSERT INTO ztp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mben or lo xin'te'd la per nandlid xaꞌ gan ntodanꞌ xaꞌ or. ");
INSERT INTO ztp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús mkab: —¡Men naꞌndlid lazonꞌ Dios nde men xkap! ¿Axta polpa tonoraꞌ na goꞌ? ¿Axta polpa xek na goꞌ? Deꞌno goꞌ or ncheꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Zyasa Jesús mbrezno xaꞌ mbiꞌ narax, sa mbrotey lazoꞌ mbyo, nde hor yaga mdyanꞌ mbyo. ");
INSERT INTO ztp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Xisa re xin'te'd Jesús xaꞌta ndodiꞌsno xaꞌ Jesús nde mnabdiꞌs xaꞌ: —¿Kwan liy sa naꞌndlit náꞌ gan ngote náꞌ mbi naraxa? ");
INSERT INTO ztp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Leꞌ Jesús nchab lo xaꞌ: —Tak lud toz ndli lazoꞌ goꞌ Dios. Lipa nin lo goꞌ, tez liga ndli lazoꞌ goꞌ Dios masa lud xapa ti mbis mostaza, gab goꞌ lo ti yiꞌba bike gwa tiblad, nde yiꞌ ya bikey nday tiblad. Nde nek tib jwanꞌ nagan ngenta par goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Per par ryoꞌte mbi narax reꞌ, ndablo nya'b men na lo Dios nde li men yalse sa ryoꞌ tey. ");
INSERT INTO ztp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Laja naxte re xaꞌ lo xyon xaꞌ Galilea, Jesús nchab: Leꞌ Xinꞌ Mbiꞌ tayaꞌ xaꞌ lo yaꞌ re men, ");
INSERT INTO ztp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nde kuj men Xaꞌ, nde lenꞌ mbyon wiz ryoxban Xaꞌ. Senꞌ lo mbin re xin'te'd Jesús jwanꞌ na, nabil toz ngo lazoꞌ re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Senꞌ mzin Jesús kon re xin'te'd Xaꞌ yez Capernaum, zyasa ngwa xaꞌ jwanꞌ nyaꞌb tmi chanꞌ yodoꞌ lo Pedr nde nchab xaꞌ: —¿Cho nangixta Xaꞌ nak maestr la tmi chanꞌ yodoꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Leꞌ Pedr mkab: —Ngix Xaꞌy. Nde senꞌ ngote Pedr lenꞌ yo, ner Jesús mni nchab: —¿Xa ngwiꞌa Simón? ¿Cho lo nyab re xaꞌ jwanꞌ nak sinꞌ lo izyo re tmi low, cho lo ta las xaꞌy o lo re xaꞌ tiblada? ");
INSERT INTO ztp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedr mkab: —Lo re xaꞌ tiblada. Jesús nchab: —Nde re tablas xaꞌ nanakinꞌta kix xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per sa nanid xaꞌ xis naꞌ, wa god mbel ro nit, nde blobi yis bow lo nit nde mbel ner jwanꞌ yoga, mxen maꞌ nde senꞌ xalꞌ la ro maꞌ tya zyal ti tmi, mxen tmi ya kix la chanꞌ na nde chanꞌ la. ");
INSERT INTO ztp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nde lenꞌ wiz ya, re xin'te'd Jesús mbike xaꞌ lo Jesús nde mnabdiꞌs xaꞌ: —¿Cho mas ndak lo yalnyebeꞌ lo beꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zyasa mbrez Jesús ti or lud nde mto Xaꞌ or xtowꞌ re xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nde nchab Xaꞌ: —Galpa diꞌs nin lo goꞌ, tez goꞌ naꞌzyed ak goꞌ nde naꞌakta goꞌ xaja ti or bix, naꞌyoted goꞌ lo yalnyebeꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jwanꞌ nasa, men nchak nadoꞌ xaja or lud reꞌ, xaꞌ ya ak xaꞌ mas ntak lo yalnyebeꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nde ti men nkayaꞌ ti or lud xa or reꞌ por len, xaꞌ ya nkaꞌ yaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nde tez cho thi xaꞌ li sa naꞌlitraꞌ lazoꞌ ti or bix reꞌ na, mas jwin nda xaꞌ, tobo men ti ke ntoꞌ jwanꞌ yen xaꞌ nde kobi men xaꞌ rolja nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Nakap toz nak par re men lo izyo reꞌ, nzo toz jwanꞌ ndli sa naꞌlitraꞌ lazoꞌ men Dios! Thitka yoy, per ¡nathoz toz yate re men jwanꞌ ndli sa naꞌlitra lazoꞌ ta xaꞌ Dios! ");
INSERT INTO ztp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jwanꞌ nasa, tez yaꞌa o nia ndli nchab la lo jwanꞌ narax, bchoy nde blobiy, tak mas jwin yotea lo yalnaban adiꞌ lo ngenta ti nia o ti yaꞌa, ke ndob rob nia o rop yaa yobia lo bel adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nde tez ngudloa ndli nchab la lo jwanꞌ narax, blotey nde blobiy, mas jwin yotea lo yalnaban adiꞌ kon thipta ngudloa, ke kon rop ngudloa yaa lo ki yer abil. ");
INSERT INTO ztp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nda wi goꞌ, nakotalta goꞌ ti or bix. Tak na ni lo goꞌ, re anj or nzi lo beꞌ, tibla nzi anj lo Xud na ndob lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tak Xinꞌ Mbiꞌ nde tolaꞌ re men ngetetab lo re jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Xa ngwiꞌ goꞌ? Tez ti mbiꞌ ngeno tibayoꞌ mbakxilꞌ, nde mdyab ti maꞌ, ¿cho nye nalad xaꞌ re tapwal nzo sinꞌtap maꞌ nde nda xaꞌ re wana nda kwanꞌ xaꞌ maꞌ ta mdyaba? ");
INSERT INTO ztp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nde tez zyal xaꞌ maꞌ, nipa na lo goꞌ mas nale yo lazoꞌ xaꞌ por maꞌ ya ke re tapwal nzo sinꞌ tap maꞌ ta naꞌndabta. ");
INSERT INTO ztp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tagaꞌ nak Xud goꞌ ndob lo beꞌ, naꞌncholasta Xaꞌ tyaꞌb nek tib or bix reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tez cho thi ta men la, li thi yalke loa, leꞌta goꞌ btodiꞌs nde gus lo xaꞌ jwanꞌ mblino xaꞌ lu. Tez mbin xaꞌ xkiꞌs la mblia gan xaꞌ tedib gob. ");
INSERT INTO ztp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tez naꞌgonta xaꞌ xkiꞌs la, beꞌ tedib xaꞌ o ti chop xaꞌ, sa ptodi'sno goꞌ xaꞌ ya, sa diꞌs ro chop men o son men jwanꞌ mbwiꞌy, aka jwanꞌ li. ");
INSERT INTO ztp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tez naꞌgonta xaꞌ diꞌs ro re xaꞌ ya, gusa lo re xaꞌ yodoꞌ, nde tez nagonta xaꞌ diꞌs ro re xaꞌyodoꞌ, zyasa bwiꞌ goꞌ xaꞌ xajka ti xaꞌ nandlid lazonꞌ Dios nde xaja thi xaꞌ ndli kobral tmi par Rom. ");
INSERT INTO ztp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nipaꞌ na lo goꞌ, reta jwanꞌ tobo go' lo izyo reꞌ, tyobo'y lo beꞌ, nde reta jwanꞌ koxak go' lo izyo reꞌ, taga' yoxaka lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tagaꞌ nin lo goꞌ: Tez chop goꞌ lo izyo reꞌ thita ak diꞌs goꞌ sa nyaꞌb goꞌ one choja jwanꞌ lo Xud na ndob lo beꞌ, Xaꞌ tay. ");
INSERT INTO ztp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tak plo ndyop chop men o tson men por len, tya ndon xij re xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Zyasa mbike gax Pedr nde nabdiꞌs Pedr lo Jesús: —Señor, ¿Pla gob ndablo ridndab na yek na re jwanꞌ ndlino wes na, na? ¿Cho gaz goba? ");
INSERT INTO ztp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Leꞌ Jesús mkab lo Pedr: —Nanaktey benꞌta gaz gob. Na ni, dib tiemp ndablo li ley. ");
INSERT INTO ztp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jwanꞌ nasa leꞌ yalnyebeꞌ lo beꞌ nak, xa nak thi rey jwanꞌ tolo tyopte nyaꞌb kwent lo re xaꞌ nge sinꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lo mdobte rey mbloꞌ rey kwent, zyasa ngwano men tib xaꞌ ndaꞌb por millon tmi lo rey. ");
INSERT INTO ztp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nde xaꞌ ya naꞌngenoda xaꞌ jwanꞌ kix xaꞌ jwanꞌ ndab xaꞌ, zyasa leꞌ rey xwanꞌ xaꞌ yaꞌ mnebeꞌ sa dyo xaꞌ kon ngol xaꞌ, kon re xinꞌ xaꞌ nde reta jwanꞌ ngeno xaꞌ, sa yax reta jwanꞌ ndaꞌb xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Zyasa leꞌ xaꞌ ya mdoxub lo rey nde mnab toz xaꞌ lo rey nchab xaꞌ: “Xwanꞌ na kwed goꞌ lud, leꞌn yixka re jwanꞌ ndaꞌb na lo goꞌ” ");
INSERT INTO ztp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nde rey ya mblat lazoꞌ xaꞌ mos xaꞌ, nde mtonꞌ xaꞌ reta jwanꞌ ndaꞌb mos lo xaꞌ nde mblaꞌ xaꞌ mos. ");
INSERT INTO ztp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Beꞌnta ngolo mbroꞌ mos tya, mzyalꞌ xaꞌ thi ta mos xaꞌ, jwanꞌ ndab ti tmi lud lo xaꞌ. Nde mxen xaꞌ yen mos ya nde mde xaꞌ yen mos, nde nchab xaꞌ: “¡Bdix jwanꞌ ndab la lon!” ");
INSERT INTO ztp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Leꞌ ta mos xaꞌ ya, mdo xub lo xaꞌ nde mnab toz xaꞌ nchab xaꞌ: “kwed la lud, leꞌn yixka re jwanꞌ ndaꞌb na loa”. ");
INSERT INTO ztp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per xaꞌ ya naꞌndoyalta, cheꞌla mkeꞌ lizyiꞌb xaꞌ ta mos xaꞌ, axta kebeꞌ kix xaꞌ jwanꞌ ndab xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lo senꞌ mbwiꞌ tedib ned ta mos xaꞌ jwanꞌ na, jwanꞌ toz ngo nabil lazoꞌ xaꞌ, nde ngwa xaꞌ nchab xaꞌy lo rey reta jwanꞌ ngotey. ");
INSERT INTO ztp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Zyasa xaꞌ nak rey mbrez xaꞌ mos ya nde nchab xaꞌ lo mos: \"¡Lu nak ti mos xkap! Na mton reta jwanꞌ ndab la lon, tak nalat mbrez la mnab lay lon. ");
INSERT INTO ztp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Noga lu ndablo ndlat lazoꞌa ta mos la xa mblat lazoꞌn lu.\" ");
INSERT INTO ztp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Zyasa jwanꞌ toz mxi lazoꞌ rey nde mnebeꞌ rey mtoti xaꞌ mos axta kebeꞌ yax reta jwanꞌ ndab xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ngolo nchab Jesús jwanꞌ na, nchaba Jesús: —Taga lino Xud na ndob lo beꞌ re goꞌ, tez goꞌ naꞌtonꞌta goꞌ xken ta men goꞌ dib nzo lazoꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lo senꞌ mne nchab Jesús re jwanꞌ na, mbroꞌ xaꞌ xyon Galilea nda Xaꞌ lo xyon Judea tedib lad ro yoꞌ Jordán. ");
INSERT INTO ztp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nde men toz tir mdonke xis Jesús nde tya mtodanꞌ Jesus re xaꞌ nayiz. ");
INSERT INTO ztp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Zyasa mbike re xaꞌ fariseo lo Jesus mnabdiꞌs xaꞌ lo Jesús, sa nenꞌ cho kwanꞌ kab Jesús: —¿Cho toyal laꞌ men ngol men por kwalker jwanꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Leꞌ Jesús mkab: —¿Cho teraꞌ lab goꞌ tenꞌ nchab, Dios mdoxkwaꞌ men senꞌ mdobte nera “xaꞌ biꞌ nde ngol mdoxkwaꞌ Xaꞌ”? ");
INSERT INTO ztp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nde nchab Dios: “Jwanꞌ nasa laꞌ mbiꞌ xud mbiꞌ nde xnaꞌ mbiꞌ nde tyobno xaꞌ salꞌ xaꞌ, nde thita ak rop xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tamod sa nanaktraꞌ chop xaꞌ, thita nak xaꞌ. Jwanꞌ nasa men jwanꞌ mtenta Dios nandablod li men laꞌta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nde re xaꞌ fariseo mnabdiꞌs: —¿Kwanka liy sa mnibeꞌ Moisés toyal laꞌ xaꞌ biꞌ ngol xaꞌ, benꞌta thi yeꞌs toxkwaꞌ xaꞌ, sa laꞌ xaꞌ ngol? ");
INSERT INTO ztp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Leꞌ Jesús mkab: —Kwent ne toz yek goꞌ, jwanꞌ nasa mdaꞌ Moisés diꞌs laꞌ goꞌ ngol goꞌ, per sen mdobte nera, natada naka. ");
INSERT INTO ztp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nde na ni lo goꞌ, tez cho xaꞌ laꞌ ngol xaꞌ nde nakte lo ngoxno ngol xaꞌgaꞌ mbiꞌ, nde kaꞌ xaꞌ tedib ngolꞌ, yalke ro nak jwanꞌ na lo xaꞌ, nde xaꞌ ta ka ngol ta mblaꞌ xaꞌ ya, yalke roga naka lo xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Zyasa re xin'te'd Jesús nchab lo Jesús: —Tez ta naka ta ka mbiꞌ ngol, maska jwin nakad mbiꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Leꞌ Jesús nchab: —Nared xaꞌ tak yen jwanꞌ re, benꞌta lo re xaꞌ jwanꞌ mdaꞌ Dios diꞌs xaꞌ ya yena. ");
INSERT INTO ztp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nzo xaꞌ biꞌ naꞌnkad xaꞌ ngol tak ta ngól xaꞌ, nzo xaꞌ biꞌ naꞌnkad ngol tak mbloꞌ men ngudkwe xaꞌ, nde nzo xaꞌ biꞌ nankad ngol tak sinꞌ tamod mbli xaꞌ, sa ke xaꞌ sinꞌ lo Dios. Tez cho xaꞌ tli gan li jwanꞌ reꞌ toyal li xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Zyasa ngwano xaꞌ pla or bix lo Jesús, sa xob Jesús yaꞌ Jesús yek or nde nyab Jesus lo Dios por re or; nde leꞌ re xin'te'd Jesús mbreno xa' re xaꞌ ta ndano or bixa. ");
INSERT INTO ztp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zyasa nchab Jesús lo xin'te'd Xaꞌ: —Btaꞌ goꞌ diꞌs yeꞌd re or bix lon, nde nakad goꞌ diꞌs, tak lo yalnyebeꞌ lo beꞌ nak chanꞌ re xaꞌ, nak xa nak re or bix reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nde senꞌ ngolo mxoꞌb Jesús yaꞌ Jesús yek re or bixa, ngo Xaꞌ ned nda Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Zyasa ngwa wiꞌ thi xaꞌ lo Jesús nde mnab diꞌs xaꞌ: —Maestr wen, ¿Cho jwanꞌ wen ndablo lin sa gal na yalnaban adiꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Leꞌ Jesús mkab: —¿Cho kwan ndliy ngolea na Xaꞌ wen? Ngenta cho nak men wen, benꞌta thita Xaꞌ wen nzo, Xaꞌ ya nak Dios. Per tez ncholaꞌs la kayaꞌa yalnaban adiꞌ, bli reta jwanꞌ nak yalnyebeꞌ chanꞌ Dios ");
INSERT INTO ztp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Leꞌ mbyo nchab: —¿Xa nyay? Leꞌ Jesús mkab: —“Nakujta la men, nagaxnot la ngol jwanꞌ nanakta ngol la, nalit la yalwanꞌ, naꞌket la yalkwinꞌ xis men, ");
INSERT INTO ztp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bxob yek xud la nde xnaꞌa, nde pkeꞌ lazoꞌa ta men la xajka nke lazoꞌa leꞌga lu.” ");
INSERT INTO ztp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Leꞌ mbyo mkab lo Jesús —Xata lud na nxobyek na reta jwanꞌ reꞌ, ¿Cho kwanraꞌ nchak jwad lin? ");
INSERT INTO ztp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús mkab: —Tez ncholaꞌs la galꞌpa ak la, wa nde pto reta jwanꞌ ngenoa nde ptaꞌy lo reta xaꞌ prob, sa kenoa brotos jwanꞌ ntak lo beꞌ, seraꞌ deꞌ nde ptonke xis na. ");
INSERT INTO ztp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lo senꞌ mbin mbyo jwanꞌ na, nabil toz ngo lazoꞌ mbyo ndya mbyo tak bro toz jwanꞌ ngeno mbyo. ");
INSERT INTO ztp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zyasa Jesús nchab lo re xin'te'd Xaꞌ: —Nipa na lo goꞌ, ne toz yote thi xaꞌ rik, lo yalnyebeꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bere nin lo goꞌ, mas naleꞌtraꞌ ridndaꞌb thi kamey yeꞌr xanꞌ yagux, ke yote thi xaꞌ rik lo yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Senꞌ mbin re xin'te'd Jesús jwanꞌ na, nzoyen xaꞌ nde nchab xaꞌ lo ta xaꞌ: —¿Cho li gan tolaꞌ lazoꞌn sa? ");
INSERT INTO ztp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Leꞌ Jesús mbwiꞌ lo xin'te'd Xaꞌ nde nchab Xaꞌ: —Par lo re men naꞌakta ak jwanꞌ reꞌ, per par lo Dios reta jwanꞌ teyal ak. ");
INSERT INTO ztp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Zyasa nchab Pedr lo Jesús: —Náꞌ mblaꞌ reta jwanꞌ ngeno náꞌ nde mdonke náꞌ xis la, ¿Cho kwan gal náꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Leꞌ Jesús mkab: —Nipana lo goꞌ, lo senꞌ sin wiz senꞌ ak nakub reta jwanꞌ nde tyobsaꞌ Xinꞌ Mbiꞌ plo nyebeꞌ Xaꞌ, zyasa re goꞌ ta ndenke xis na, re tib sen goꞌ tyobsaꞌ, tiba goꞌ lo thi yasil sa nyab goꞌ kwent lo re tib sen bin xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nde reta xaꞌ jwanꞌ mblaꞌ liz naꞌ, o wes naꞌ, o ptanꞌ naꞌ, o xud naꞌ, o xnanꞌ naꞌ, o xinꞌ naꞌ o xyon naꞌ, por kwent chanꞌ na, xaꞌ ya kayaꞌ tib ayoꞌ gob masra re jwanꞌ mblaꞌ xaꞌ, nde no kayaꞌ xaꞌ yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nde nar toz re xaꞌ ndo ner, xa' ya yanꞌ axta xis, nde nar toz re xaꞌ ndo xis, xa' ya tyo ner. ");
INSERT INTO ztp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nde nogaꞌ nchab Jesús: —Leꞌ yalnyebeꞌ lo beꞌ lal naka xaja nak xwanꞌ lus ub, mbroꞌ xaꞌ tilꞌ nda kwanꞌ xaꞌ mos ke sinꞌ lo ub xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nde ngolo mbyanꞌ diꞌs xaꞌ kix xaꞌ ka mos xapka nka re mos, thi sinꞌ wiza, zyasa mtelꞌ xaꞌ re mos lo rsinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nde mer hor ye' tilꞌ bere mbroꞌ xaꞌ tedib gob, nde mbwiꞌ xaꞌ ti pla xaꞌ nalaj nzi lo xbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nde nchab xaꞌ lo re xaꞌ ya: —“Wa goꞌ sinꞌ lo ub na sa kix na ka goꞌ jwanꞌ ndablo li goꞌ gan”. Nde nda re xaꞌ ya lo sinꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nde xaꞌ nak xwanꞌ ub mbroꞌ tedib gob a wizta ba, nde bere mbroꞌ xaꞌ tedib gob rolja bzye, nde tagaꞌ nchab xaꞌ lo re men nalaj nzi tya. ");
INSERT INTO ztp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nde bzye mer debixka' wiz bere mbroꞌ xaꞌ tedib gob ngwa xaꞌ lo xbiꞌ, nde mbwiꞌ xaꞌ nzi ta pla xaꞌ nalaj tya, nde mnab diꞌs xaꞌ lo re xaꞌ ya: “¿Kwan liy sa xe nzi goꞌ dib wiz nanked goꞌ sinꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Leꞌ re xaꞌ ya mkab: “Tak ngen cho tera taꞌ sinꞌ ke náꞌ.” Zyasa nchab xaꞌ nak xwanꞌ ub: Wa goꞌ sinꞌ lo ub na, sa kix na ka goꞌ jwanꞌ ndab lo li goꞌ gan”. ");
INSERT INTO ztp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lo senꞌ mbla yalꞌ, leꞌ xaꞌ nak xwanꞌ ub nchab lo xaꞌ nyebeꞌ lo re mos xaꞌ: “Brez re mos nde bdix ka xaꞌ, btopte bdix ka re xaꞌ mzin xiska zyara kix la ka re xaꞌ mzin ner” ");
INSERT INTO ztp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lo ngwa re xaꞌ ta mbla lo sinꞌ debixka' wiz sa', nde mdix xaꞌ dib wiz lo kad tib xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Xisa mbriꞌd re xaꞌ jwanꞌ mbla ner lo sinꞌ, nde mbli xaꞌ xgab broxa yax ka xaꞌ, per taga jwanꞌ ntak ti wiz, mkayaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Senꞌ ndoyax nka re xaꞌ ya, tolo mbrez xaꞌ lo xaꞌ nak xwanꞌ sinꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Na nchab xa: “Reta xaꞌ ta mzin nda wiz benꞌta thib hor mke xaꞌ sinꞌ, nde lal mdix la mka xaꞌ xapa mdix la lo náꞌ, nde náꞌ mxek mke sinꞌ lo be dib wiz.” ");
INSERT INTO ztp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Leꞌ xaꞌ nak xwanꞌ lus ub mkab lo thi xaꞌ ya nchab: “Mbiꞌ, nangetotid na lu. ¿Cho nambyandiꞌsta naꞌ jwan ntak ti sinꞌ wiz kix na kaa?” ");
INSERT INTO ztp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bxen tmin la nde bya. Na ncholas kix ka re xaꞌ ta mzin nda wiza xapa mdix na mkaa ba. ");
INSERT INTO ztp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Cho naꞌnyed linon tmin na jwanꞌ nda lazoꞌn? ¿O ta nxi lazoꞌa tak nabeꞌz nak na? ");
INSERT INTO ztp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jwanꞌ nasa, re xaꞌ ndo xiska, xaꞌ ya tyo ner, nde re xaꞌ ndo nerka xaꞌ ya tyo xiska. Tak xaꞌ toz kweꞌs nde lud xaꞌ li gan yote. ");
INSERT INTO ztp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Senꞌ ndo Jesús ned nda Xaꞌ yez Jerusalén, xaꞌta mbrez Xaꞌ re tib sen xin'te'd Xaꞌ nde nchab Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Naya ndanꞌ Jerusalén, nde leꞌ Xinꞌ Mbiꞌ tayaꞌ xaꞌ lo yaꞌ re nglweyꞌ jwanꞌ nyebeꞌ nde lo re maestr nchak ley, nde re xaꞌ ya nyebeꞌ sa gaj Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nde tayaꞌ xaꞌ Xinꞌ Mbiꞌ lo yaꞌ re men nanakta men Israel, sa xino men Xaꞌ, kin men Xaꞌ nde keꞌ men xaꞌ lo kruz; per yoxob byon wiz ryoꞌxban Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zyasa mbike xaꞌ got Zebedeo kon rop or xinꞌ xaꞌ lo Jesús, nde mdoxub xaꞌ sa nyaꞌb xaꞌ jwanꞌ nchalaꞌs xaꞌ lo Jesús: ");
INSERT INTO ztp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nde Jesús mnab diꞌs lo ngol: —¿Cho kwan ncholaꞌs la? Leꞌ ngol mkab: —Cholaꞌs na senꞌ tyob la nyebeꞌa, taꞌa diꞌs sa rop xinꞌ na reꞌ tyob choa, tib or tyob lad ban la nde tedib or tyo lad beg la. ");
INSERT INTO ztp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Leꞌ Jesús mkab lo re yon xaꞌ: —¡Naꞌnyed goꞌ cho kwan ta nyab goꞌ! ¿Cho tli goꞌ gan rid ndab goꞌ reta yalti rid na? Nde xaꞌ nchab: —Tli náꞌ gan. ");
INSERT INTO ztp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús nchab: —Liga trid goꞌ re yalti rid na, per ta tyob goꞌ lad ban na nde lad beg na, nanada ndablo tay, tak Xud na Dios mblia cho lo taꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lo senꞌ mbin ti tsiꞌ xin'te'd Jesús jwanꞌ na, mbiꞌno xaꞌ rop wes xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Per Jesús mbrez re xin'te'd Xaꞌ nde nchab Jesús lo re xaꞌ: —Mne goꞌ, reta xaꞌ jwanꞌ nyebeꞌ xis izyo reꞌ, nyebeꞌ xaꞌ xa nda lazoꞌ nde re xaꞌ nchap sinꞌ ro, ndli xaꞌ jwanꞌ nda lazoꞌ xaꞌ kon yalnyebe jwanꞌ ngeno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nde xij re goꞌ natada ndablo aka. Tez cho ncholaꞌs ak xaꞌ mas ntak xij goꞌ, xaꞌ ya ndablo li sinꞌ lo re goꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nde tez cho ncholaꞌs tyo ner lo re goꞌ, xaꞌ ya ndablo li sinꞌ lo re goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta xa Xinꞌ Mbiꞌ nambyeta Xaꞌ sa li men sinꞌ lo Xaꞌ, leꞌ Xaꞌ mbyed sa li Xaꞌ sinꞌ lo re men, nde taꞌ Xaꞌ yalnaban chanꞌ Xaꞌ sa yax lyaꞌ bro toz men. ");
INSERT INTO ztp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Senꞌ ndaroꞌ Jesús kon re xin'te'd Xaꞌ yez Jericó, men toz tir mdonke xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Zyasa chop mbiꞌ nkow lonꞌ ndob ro ned nde senꞌ mbin xaꞌ, leꞌ Jesús ndarid tya mbrez yaj rop xaꞌ nchab xaꞌ: —¡Señor, Xaꞌ nde lo bin David, blat lazoꞌa náꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nde re men ngok nayiꞌ lo rop xaꞌ ya sa naꞌkwesta xaꞌ, nde rop xaꞌ cheꞌla masraꞌ ne mbrez: —¡Señor, Xaꞌ nde lo bin David, blat lazoꞌa náꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zyasa ngoto Jesús, nde mbrez Jesús rop xaꞌ ya nde mnabdiꞌs Jesús lo xaꞌ: —¿Cho kwan ncholaꞌs goꞌ lin lo goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Leꞌ rop xaꞌ ya nchab: —Señor, náꞌ cholaꞌs wiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nde Jesús mblat lazoꞌn rop xaꞌ ya, mbwal Jesús ngudlo rop xaꞌ, nde zyaga ngoni ngudlo xaꞌ mbwiꞌ xaꞌ nde mdonke rop xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Senꞌ ndasin re xaꞌ gax yez Jerusalén, mzin xaꞌ yez Betfagé, xanꞌ yiꞌ Olib, tya Jesús mbloned chop xin'te'd Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nde nchab Jesús lo rop xaꞌ: —Wa goꞌ yez lud ta nax lad tso ba. Tya zyal goꞌ thi bur gol ngedoꞌ kon bur lud xinꞌ maꞌ, xak goꞌ rop maꞌ nde yedno goꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tez cho xaꞌ kwan nye lo goꞌ, gab goꞌ lo xaꞌ, Señor nakinꞌ maꞌ, nde mas naba seꞌre Xaꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jwanꞌ reꞌ ngote sa ngok jwanꞌ mni profet, senꞌ nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gus goꞌ lo re xaꞌ yez Sion: “Bwiꞌ, leꞌ Rey la nde loa, nadoꞌ Xaꞌ, ndob Xaꞌ xis bur, ti xis bur yenꞌ, xinꞌ maꞌ ncheꞌ yoꞌ” ");
INSERT INTO ztp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nde xin'te'd Jesús ngwa nde mbli xaꞌ xata mnabeꞌ Jesús lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nde mbeꞌ xaꞌ bur gol kon xinꞌ maꞌ nde mxob xaꞌ xab xaꞌ xis maꞌ, nde mdob Jesús xis maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nde re men toz tira, rol xaꞌ mtogaꞌ xaꞌ lar nzoꞌb xis xaꞌ lo ned, nde rol xaꞌ mchoꞌ xod ya nde mdiꞌx xaꞌ lo ned tenꞌ ndorid Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nde reta men ndasiblo nde reta men ndenke xis, tolo ne mbrez xaꞌ nchab xa: —¡Naro nak Xaꞌ nde lo bin rey David! ¡Nabeꞌz nda Xaꞌ jwanꞌ nde kon le Dios! ¡Naro toz nak Dios ndob lo beꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lo senꞌ ngote Jesús lenꞌ yez Jerusalén, reta men yez ya ncheꞌpa nchak xaꞌ nyab diꞌs xaꞌ lo ta xaꞌ: —¿Cho xaꞌ ba? ");
INSERT INTO ztp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Re men mkab: —Xaꞌ reꞌ nak profet ndole Jesús, xaꞌ yez Nazaret xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Xisa Jesús ngote tenꞌ ndob yodoꞌ chanꞌ Dios, nde mbloꞌte Jesús reta xaꞌ nzi tho nde reta xaꞌ nzi tiꞌ tya. Mchixkwe Jesús re mes xaꞌ nsilꞌ tmin re men, nde re yasil chanꞌ re xaꞌ ntho palom; ");
INSERT INTO ztp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","nde nchab Jesús lo xaꞌ: —Lo xkiꞌs Dios nchab: “Leꞌ liz na ryole, yo todiꞌsno men Dios”, per liz xaꞌ wanꞌ mblilal goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tya lenꞌ yodoꞌ mbike gax pla xaꞌ nkow lon' nde pla xaꞌ ngoꞌb ninꞌ lo Jesús, nde Jesús mtodanꞌ re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lo senꞌ mbwiꞌ re nglweyꞌ jwanꞌ nyebeꞌ lo re nglweyꞌ nde re maestr nchak ley, reta yalnaro jwanꞌ ndli Jesús, nde mbin xaꞌ xa mbez ne re or yenꞌ lenꞌ yodoꞌ: “Naro nak Xaꞌ nde lo bin David”, ngo naxi lazoꞌ re xaꞌ ya ");
INSERT INTO ztp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","nde nchab xaꞌ lo Jesús: —¿Cho nchon la re jwanꞌ mbez re or ba? Leꞌ Jesús mkab: —Aaꞌ nchon nay. ¿Cho teraꞌ lab goꞌ tenꞌ nchab: \"Lu mbli sa ro re or bix nde ro re mbed nchuꞌ nis gol or re di li naro or lea?”. ");
INSERT INTO ztp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nde mblaꞌ Jesús re xaꞌ ya, mbrote Jesús nda Xaꞌ yez Betania, tya mbled Xaꞌ yalꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nde tilꞌ, lo mbere Jesús nda xaꞌ yez Jerusalén, mzib ndyanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nde mbwiꞌ Jesús thi ya hig ndob gax ro ned, nde ngwa twiꞌ Xaꞌ lo ya nde naꞌngenta ngud loneꞌy, benꞌta la ndoy. Zyasa nchab Xaꞌ lo ya: —¡Nekthib ngud naketra loa! Nde zyaga mbis ya hig. ");
INSERT INTO ztp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lo senꞌ mbwiꞌ re xin'te'd Jesús jwanꞌ ta ngoka, nzoyen re xaꞌ nde mnabdiꞌs xaꞌ lo Jesús: —¿Xamod sa atil tir mbis ya hig reꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Leꞌ Jesús mkab: —Nipana lo goꞌ, tez ndlipa lazoꞌ goꞌ nde nanchakropta xgab goꞌ, nanakta benꞌta jwanꞌ ta mblinon ya hig toyal li goꞌ, cheꞌla toyal gab goꞌ lo yiꞌ reꞌ: “Bike nde gobi lenꞌ nittoꞌ”, nde taka. ");
INSERT INTO ztp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nde reta jwanꞌ nyab goꞌ lo Dios senꞌ ndodi'sno go' Dios, tez ndlipa lazoꞌ goꞌy, Xaꞌ taꞌy lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Senꞌ lo ngote Jesús lenꞌ yodoꞌ, laja nge loꞌ Jesús xkiꞌs Dios lo men, zyasa mbike re nglweyꞌ jwanꞌ nyebeꞌ nde re xaꞌ gox jwanꞌ nyebeꞌ, mnabdiꞌs xaꞌ lo Jesús: —¿Cho mdaꞌ yalne loa ta ndlia re jwanꞌ reꞌ? ¿Cho mdaꞌy loa? ");
INSERT INTO ztp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nde Jesús mkab: —Noga na nyabdiꞌs ti jwanꞌ lo goꞌ, tez tkab goꞌy, seraꞌ sa non tej lo goꞌ cho mdaꞌ yalne ndlin reta jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Cho mtelꞌ Juan sa mbloꞌle Juan men? ¿Cho Dios mtelꞌ xaꞌ o men na? Zyasa re xaꞌ ya mdodiꞌs xaꞌ nenꞌ xomod kab xaꞌ nde nchab xaꞌ lo ta xaꞌ: —Tez gab naꞌ Dios mtelꞌ Juan, zyasa nye xaꞌ lonꞌ, ¿Kwanka liy sa naꞌndlid lazoꞌ goꞌ Juan? ");
INSERT INTO ztp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nde tez gab naꞌ na mena, nzyeb naꞌ men yez, tak reta xaꞌ ndli lazonꞌ Juan ngok tib profet. ");
INSERT INTO ztp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zyasa mkab re xaꞌ lo Jesús: —Naꞌnyed náꞌy. Nde Jesús nchab lo xaꞌ: —Noga na naꞌtejta na lo goꞌ kon cho yalne ndlin re jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús nchab lo xaꞌ —¿Xa ngwiꞌ goꞌ jwanꞌ reꞌ? Thi mbiꞌ ngeno chop xinꞌ naꞌ or biꞌ, nde nchab xaꞌ lo or ner: “xinꞌ na, wa sinꞌ lo ub na wiz reꞌ” ");
INSERT INTO ztp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Leꞌ xinꞌ xaꞌ mkab: “¡Naꞌyatna!” Per xiska mzyeꞌ xgab or ngwar sinꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Xisa tagaꞌ nchab xaꞌ lo tedib or nde or ya mkab: “Mbay, xud na, nasa ndan”. Nde naꞌngad or. ");
INSERT INTO ztp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lo rop or ¿xa nyar mbli jwanꞌ mnabeꞌ xud or? Leꞌ re xaꞌ mkab: —Or nera mbliy. Zyasa nchab Jesús lo re xaꞌ: —Nipa na lo goꞌ, re xaꞌ nthop tmi par Rom nde re ngol ntho lad naꞌ ner re xaꞌ ya yote tenꞌ nyebeꞌ Dios ke goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tak mbyed Juan, mbyeꞌd loꞌ mod galꞌ jwanꞌ ban goꞌ, nde naꞌndlid lazoꞌ goꞌ xaꞌ; nde re xaꞌ nthop tmi par yez Rom nde re ngol ntho lad naꞌ mbli lazoꞌ xaꞌ Juan. Nde leꞌ re goꞌ teꞌnye mbwiꞌ goꞌ re jwanꞌ mbli Juan, naꞌndlad goꞌ re jwanꞌ narax nak goꞌ, sa ndli lazoꞌ goꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Bin goꞌ tedib kwent: Ngo ti mbiꞌ ngeno izyo, nde mblobin xaꞌ lus ub lo ney, nde mtowꞌ xaꞌ diba, mdenꞌ xaꞌ lenꞌ ney tenꞌ mdoxkwaꞌ xaꞌ tiꞌ xaꞌ ub, nde mtaꞌ xaꞌ thi yo gap ndab li sinꞌ kenap xaꞌ diba. Nde mdaꞌ xaꞌy kwent rol lo pla xaꞌ nchak ndli sinꞌ lo ub, nde ngo xaꞌ ned nda xaꞌ tij. ");
INSERT INTO ztp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nde senꞌ mzin beꞌ dyop ub, mtelꞌ xwanꞌ lus ubꞌ, pla mos xaꞌ, sa yakayaꞌ mos jwanꞌ ndaꞌ lus ub jwanꞌ nak chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per re xaꞌ ta ngeno lus ub kwent rola, mxen xaꞌ re mos ya, ti mos mdin xaꞌ, ti mos mbij xaꞌ nde ti mos mbwadke xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bere mtelꞌ xaꞌ nak xwanꞌ lus ub masra mos, nde taga mbli no xaꞌ re mos ya. ");
INSERT INTO ztp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lulka mtelꞌ xaꞌ xinꞌ xaꞌ tak mbli xaꞌ xgab: “Txobyek xaꞌ xinꞌ na”. ");
INSERT INTO ztp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per re xaꞌ ta ngeno lus ub kwent rola, senꞌ mbwiꞌ xaꞌ xinꞌ xaꞌ nak xwanꞌ lus ub, nchab xaꞌ lo ta xaꞌ: Xa reꞌ yanꞌno izyo nzo lus ub, kuj naꞌ xaꞌ, sa naꞌ yanꞌnoy. ");
INSERT INTO ztp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Zyasa mxen xaꞌ xinꞌ xaꞌ nak xwanꞌ lus ub, nde mblote xaꞌ xaꞌ lad le nde tya mbij xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mbay lo senꞌ yeꞌd xaꞌ nak xwanꞌ lus ub, ¿Cho kwan lino xaꞌ re xaꞌ ta ngeno lus ub kwent ro la? ");
INSERT INTO ztp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Leꞌ re xaꞌ ya nchab: —Naꞌlyata lazoꞌ xaꞌ, kuj xaꞌ re xaꞌ ta nakap naka, nde tayaꞌ xaꞌ lus ub kwent rol lo xaga men jwanꞌ liga tayaꞌ ub senꞌ ngol beꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nde Jesús nchab lo re xaꞌ: —¿Cho tera lab goꞌ lo xkiꞌs Dios tenꞌ nchab: Leꞌ ke jwanꞌ mbloꞌtal xaꞌ ntaꞌ yo, ke ya ngolal ke ntak toz lo dib yo. Leꞌ jwanꞌ reꞌ mbli Dios, nde nzoyen na' ngwiꞌ naꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jwanꞌ nasa nin lo goꞌ, yiꞌb yalnyebeꞌ chanꞌ Dios lo yaꞌ goꞌ, nde taꞌ Xaꞌy lo re men jwanꞌ liga li jwanꞌ ncholaꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nde tez cho xaꞌ gab xis ke reꞌ tiptane ga's xaꞌ, nde tez cho gab ke re xis naꞌ thiptane ga'ski' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nde senꞌ mbin re nglweyꞌ jwanꞌ nyebeꞌ nde re xaꞌ fariseo kwent ya, mbyen xaꞌ ke xis xaꞌ ndo ni Jesús re jwanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Zyasa re xaꞌ yaꞌ mkwanꞌ mod nenꞌ xa yoga Jesús, per nzyeb xaꞌ re men yez, tak re men yez ndli lazonꞌ, Jesús nak profet chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús mdobte tedib gob mdej Xaꞌ tedib kwent nde nchab Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Leꞌ yalnyebeꞌ lo beꞌ nak xaja nak thi rey mbli ti yaltselyaꞌ par xinꞌ biꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nde mtelꞌ rey re mos rey sa yaches mos re men nakdiꞌsla ya lo yaltselyaꞌ, per re xaꞌ ya naꞌndeyalta xaꞌ, naꞌngad lo yalselyaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nde bere mtelꞌ xaꞌ tedib ned mos nde nchab xaꞌ lo mos: “Gus goꞌ lo re xaꞌ nak diꞌs yeꞌd, mdoxkwaa na jwanꞌ ya yalway. Ngujla re ngon nde re maꞌ nchalꞌ, naksaꞌla re jwanꞌ, deꞌ goꞌ lo yaltselyaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nde re xaꞌ ya naꞌndyod xaꞌ nga xaꞌ lo yalselyaꞌ, tib xaꞌ nda sinꞌ wan nde tedib xaꞌ nda lo xaꞌgaꞌ rsinꞌ xaꞌ ");
INSERT INTO ztp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nde tedib ned xaꞌ mxen xaꞌ re mos rey nde mkeꞌ xaꞌy cho mos nde mbij xaꞌ re mos. ");
INSERT INTO ztp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lo senꞌ mbin rey jwanꞌ na, ngok nayiꞌ toz xaꞌ nde mtelꞌ xaꞌ re sondad kuj re men ta mbij re mos xaꞌ, nde mtolꞌ xaꞌ yez men ya. ");
INSERT INTO ztp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Zyara sa nchab rey lo re mos rey: “Naksaꞌla reta jwanꞌ sa yo yaltselyaꞌ per reta xaꞌ nakdiꞌs la yeꞌd lo yaltselyaꞌ naꞌnsalꞌta xaꞌ yeꞌd xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naya wa goꞌ re ned ro nde brez goꞌ a choja re xaꞌ zyalꞌ goꞌ sa yeꞌd xaꞌ lo yalselyaꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nde ngwa re mos re ned ro, nde mthop xaꞌ reta men mzyalꞌ xaꞌ, men wen nde re men narax, nde mze tenꞌ ngo yalselyaꞌ mbre re men. ");
INSERT INTO ztp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lo senꞌ ngote rey plo nzo yalselyaꞌ, sa wiꞌ xaꞌ re men nzi lo yalselyaꞌ, nde mbwiꞌ rey thi mbiꞌ nanokxabta xa nchok xab re xaꞌ nda lo yaltselyaꞌba. ");
INSERT INTO ztp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nde nchab rey lo mbiꞌ ya: “Amig, ¿Xamod ngotea ncheꞌya nde nanokxabta la xa nokxab re xaꞌ ta nda lo yalselyaꞌ? Nde mbiꞌ ya naꞌnkapta. ");
INSERT INTO ztp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Zyasa nchab rey lo re xaꞌ nsili sinꞌ tya: “Btobo goꞌ ni xaꞌ nde yaꞌ xaꞌ nde blobi goꞌ xaꞌ le lo yalꞌkow, tya gon xaꞌ nde tyes kele xaꞌ”. ");
INSERT INTO ztp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tak bro toz xaꞌ kweꞌs, nde lud xaꞌ kwi Dios. ");
INSERT INTO ztp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Zyasa ngo re xaꞌ fariseo ned nde ngok diꞌs xaꞌ nenꞌ kwan gab xaꞌ lo Jesús, sa jwanꞌ kab Jesús, keꞌ xaꞌ yalke yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nde mtelꞌ xaꞌ pla xin'te'd xaꞌ kon pla men Herodes, nde nchab xaꞌ lo Jesús: —Maestr, mne náꞌ ke li tir kwent ndaꞌa nde ndloꞌa xkiꞌs Dios xata naka, nde nambit la men tak lal ndak reta men loa. ");
INSERT INTO ztp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mbay mne lo náꞌ, xa ngwiꞌa: ¿Cho galꞌ naka kix men tmi jwanꞌ nyaꞌb rey César o nagalꞌtey? ");
INSERT INTO ztp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per Jesús nzolola jwanꞌ narax nzo lazoꞌ re xaꞌ ya, nchab Jesús lo re xaꞌ: —¡Men rop ro! ¿Cho kwan liy nkwanꞌ goꞌ xa keꞌ goꞌ yalke yek na? ");
INSERT INTO ztp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bloꞌ goꞌ tmi jwanꞌ ngix goꞌ lo Rom. Nde mbloꞌ xaꞌ thi tmi denario lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Zyasa nchab Jesús lo re xaꞌ: ¿Cho xaꞌ ta nge lo tmi reꞌ, nde cho le ta nge lo ney? ");
INSERT INTO ztp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Leꞌ re xaꞌ ya mkab: —Chanꞌ rey César. Zyasa nchab Jesús lo re xaꞌ ya: —Ptaꞌ goꞌ lo César jwanꞌ nak chanꞌ César nde ptaꞌ goꞌ lo Dios jwanꞌ nak chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Senꞌ lo mbin re xaꞌ jwanꞌ na, nzo yen re xaꞌ nde mblaꞌ xaꞌ Jesús ngo xaꞌ ned nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Leꞌga wiz ya, ngwa pla xaꞌ saduceos lo Jesús. Re xaꞌ ya nandlid lazonꞌ ndryoꞌxban re men nde mnabdiꞌs xaꞌ lo Jesús: ");
INSERT INTO ztp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestr, Moisés nchab: Tez thi xaꞌ biꞌ gaj nde naꞌngenta xinꞌ xaꞌ, wes xaꞌ ndablo tselyaꞌno ngol xaꞌ sa koꞌxban wes xaꞌ bin xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Xij náꞌ re ngo ti liz xaꞌ tenꞌ ngo gaz xaꞌ lo re wes xaꞌ. Xaꞌ ner lo re xaꞌ mselyaꞌ nde nguj xaꞌ, nde naꞌngalta xinꞌ xaꞌ, nde wes xaꞌ, xaꞌ ndanke xis xaꞌ ya mselyaꞌno ngol. ");
INSERT INTO ztp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tagaꞌ nguj xaꞌ ya, nde tagaꞌ ngote xaꞌ mbyon, axta kebeꞌ re gaz xaꞌ mselyaꞌno ngol nde tagaꞌ nguj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Xisa, noga ngol nguj. ");
INSERT INTO ztp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Senꞌ ryoꞌxban re men, ¿Lo ta re gaz xaꞌ mdobno ngol, xanya xaꞌ ak salꞌ ngol? ");
INSERT INTO ztp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Zyasa mkab Jesús lo re xaꞌ: —Mbwan goꞌ, tak nanchenta goꞌ xkiꞌs Dios neka yalne chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tak senꞌ lo ryoꞌxban re xaꞌ nguj, naꞌselyaꞌd xaꞌ nde nataꞌd xaꞌ xinꞌ got xaꞌ selyaꞌ, tak re xaꞌ ak xa nak re anj chanꞌ Dios nzi lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Leꞌ lo ta ryoꞌxban re xaꞌ nguj, ¿cho tera lab goꞌ tenꞌ nchab? jwanꞌ yub Dios mni: ");
INSERT INTO ztp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Na nak Dios chanꞌ Abraham, Dios chanꞌ Isaac nde Dios chanꞌ Jakob\". Dios, nanakta Dios chanꞌ re xaꞌ nguj, leꞌ Dios nak Dios re xaꞌ naban. ");
INSERT INTO ztp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lo mbin re men jwanꞌ na, nzoyen xaꞌ re jwanꞌ ndloꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lo senꞌ mne re xaꞌ fariseo xa mtowꞌ Jesús ro re xaꞌ saduceo, zyasa mdyoꞌp re fariceo ");
INSERT INTO ztp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","nde thib xaꞌ ya nak maestr lo ley, mnabdiꞌs xaꞌ lo Jesús nyenꞌ kwan kab Jesús, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestr, ¿Xa nya yalnyebeꞌ mas ntak nge lo ley chanꞌ Moisés lo re naka? ");
INSERT INTO ztp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Leꞌ Jesús mkab: —“Pkeꞌ lazoꞌa Señor nak Dios la dib nzo lazoꞌa, dib xbin la nde dib xgab la”. ");
INSERT INTO ztp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jwanꞌ reꞌ nak yalnyebeꞌ ner nde yalnyebeꞌ mas ntak. ");
INSERT INTO ztp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nde leꞌ jwanꞌ brop mer lal naka: \"Pkeꞌ lazoꞌa ta men la xa nkeꞌ lazoꞌa lega lu.\" ");
INSERT INTO ztp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nde lo rop yalnyebeꞌ reꞌ ngenden reta yalnyebeꞌ nge ni lo ley nde reta jwanꞌ mkeꞌ re profet. ");
INSERT INTO ztp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Laja thita nzi re xaꞌ fariseo tya, Jesús mnab diꞌs lo re xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nchab Jesus: —¿Cho xgab ndli goꞌ ngwiꞌ goꞌ Crist? ¿Cho lo bin nde Xaꞌ ndyak goꞌ? Leꞌ re xaꞌ fariseo mkab: —Lo bin chanꞌ David nde Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zyasa nchab Jesús lo re xaꞌ: —¿Xomodka naka sa nchab David, Xaꞌ Nyebeꞌ lo Xaꞌ? senꞌ por Mbi Nayon mni David: ");
INSERT INTO ztp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Leꞌ Dios nchab lo Xaꞌ Nyebeꞌ lon: “Ptob lad ban na, axta kebeꞌ ton re xaꞌ ngiꞌnoa lo nia” ");
INSERT INTO ztp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xomod yeꞌd Crist lo bin David tez lega leꞌ David ni lo xaꞌ, Xaꞌ Nyebeꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nde nekthib xaꞌ naꞌndlid gan nkab neꞌ thiblan diꞌs lo Jesús, nde axta wiz ya ngetra cho nabdiꞌs lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Xisa, nchab Jesús lo re men nde lo re xin'te'd xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Re maestr lo ley nde re xaꞌ fariseo, nak xaꞌ nzi sa loꞌ xaꞌ ley chanꞌ Moisés ");
INSERT INTO ztp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jwanꞌ nasa re jwanꞌ nye xaꞌ lo goꞌ li goꞌ, bxobyek goꞌy nde bli goꞌy, per naꞌlid goꞌ xa ndli xaꞌ, tak xaꞌga jwanꞌ mbez xaꞌ nde xaꞌga jwanꞌ ndli xaꞌ ");
INSERT INTO ztp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tak ndlino xaꞌ re men xaja ndli ti men ntob yoꞌ ne toz nga ngen cho li gan we, nxoꞌb xaꞌy yen re men, nde leꞌ xaꞌ nek lud nandaꞌyaꞌd xaꞌ laꞌsto xaꞌ men sa we mena. ");
INSERT INTO ztp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nde reta jwanꞌ ndli xaꞌ, ndli xaꞌy sa yoyen men jwanꞌ ndli xaꞌ. Ndyen xaꞌ tobo xaꞌ yen yaꞌ xaꞌ nde keꞌ xaꞌ cholo xaꞌ yid nolꞌ jwanꞌ nge xkiꞌs Dios lonꞌ, nde nakij xaꞌ nchok xaꞌ lar nolꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nde ndyen xaꞌ tyob xaꞌ tenꞌ ndyob re xaꞌ ntak ten nzo yalwa, nde taga' ndli xaꞌ lenꞌ re yo tenꞌ ndyop xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nde ndyen xaꞌ ni men dyux lo xaꞌ lo xbiꞌ, nde gab men lo xaꞌ: maestr. ");
INSERT INTO ztp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Per goꞌ, naꞌtaꞌd goꞌ diꞌs koꞌle men goꞌ maestr, tak thita Xaꞌ nak Maestr goꞌ, Xaꞌ ya nak Crist, nde reta goꞌ thita wes goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nde naꞌkoled goꞌ xud goꞌ nek tib xaꞌ lo izyo reꞌ, tak thita Xaꞌ nak Xud goꞌ, leꞌ Xaꞌ ndob lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Neꞌka ryoꞌle goꞌ maestr, tak thipta xaꞌ nak maestr goꞌ, Xaꞌ ya nak Crist. ");
INSERT INTO ztp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xaꞌ jwanꞌ mas ntak xij goꞌ, xaꞌ ya ndablo li sinꞌ lo re goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tak xaꞌ nchak naro, xaꞌ ya ryoꞌyantho nde xaꞌ ndla yek naꞌ, xaꞌ ya ak naro. ");
INSERT INTO ztp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Per, ¡nalat nya goꞌ, maestr nchak ley nde re goꞌ xaꞌ fariseo, makwinꞌ!, tak ntowꞌ goꞌ lo re men sa naꞌyoted men lo yalnyebeꞌ lo beꞌ. Tak neka goꞌ yote nde neꞌka taꞌ goꞌ diꞌs yote re men nchal yote. ");
INSERT INTO ztp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Nalat nya goꞌ maestr nchak ley nde goꞌ fariseo, makwinꞌ!, tak nkib goꞌ liz re ngol nguj salꞌ naꞌ, nde sa naꞌloꞌd jwanꞌ ndli goꞌ, nolꞌ toz ndodiꞌs goꞌ senꞌ ndyodiꞌsno goꞌ Dios. Lo ta ndli goꞌ, mas naro yalke nxoꞌb goꞌ xis goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Nalat nya goꞌ, maestr nchak ley nde re goꞌ fariseo, makwinꞌ!, izyo nde nittoꞌ ndye goꞌ nkwanꞌ goꞌ men li lazonꞌ jwanꞌ ndli lazoꞌ goꞌ, nde lo ndli goꞌ gan ndli lazoꞌ xaꞌy, mblilal goꞌ xaꞌ ya, thi xaꞌ mas nzalꞌ ya yeꞌr abil ke goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Nalat nya goꞌ, ngoꞌb kow goꞌ ned lo men! Mbez goꞌ: \"Ngen kwan liy tez cho xaꞌ ntobro yodoꞌ chanꞌ Dios, lo senꞌ ndaꞌ xaꞌ xkiꞌs xaꞌ li xaꞌ thi jwanꞌ, per tez ntobro xaꞌ jwanꞌ or nzo lenꞌ yodoꞌ, xaꞌ ya ndablo li jwanꞌ mkeꞌ yek xaꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ngenta xgab yek goꞌ nde men nglwe goꞌ! Tak ¿Cho kwanꞌ mas ntak, cho re jwanꞌ or nzo lenꞌ yodoꞌy o yodoꞌ jwanꞌ ndli yon re jwanꞌ ora? ");
INSERT INTO ztp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Noga mbez goꞌ: “Ngen kwan liy tez cho thi xaꞌ ndaꞌ xkiꞌs naꞌ li thi jwanꞌ nde ntobro xaꞌ plo ntolꞌ xaꞌ re jwanꞌ yon, per tez ntobro xaꞌ jwanꞌ yon ta nzi lo ya, xaꞌ ya ndabloga li jwanꞌ mkeꞌ yek xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ngenta xgab yek goꞌ nde men nglwe goꞌ! ¿Cho kwan mas ntak, cho jwanꞌ yona o tenꞌ ntolꞌ xaꞌ re jwanꞌ yon sa nchak nayon na? ");
INSERT INTO ztp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tak xaꞌ ta ndaꞌ xkiꞌs naꞌ nde ntobro xaꞌ tenꞌ ntolꞌ xaꞌ re jwanꞌ yon, nanaktey benꞌta jwanꞌ na ntobro xaꞌ, noga re jwanꞌ nziꞌb lo neꞌy nge tobro xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nde xaꞌ jwanꞌ ntobro yodoꞌ, nanaktey benꞌta yodoꞌ nge tobro xaꞌ, noga Dios nge tobro xaꞌ, tak tya nzo Dios. ");
INSERT INTO ztp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nde xaꞌ jwanꞌ ntobro beꞌ, nogaꞌ nge tobro xaꞌ tenꞌ ndyob Dios nyebeꞌ Dios nde nogaꞌ yub Dios ta ndyob tya nge tobro xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Nalat nya goꞌ, maestr nchak ley nde re goꞌ fariseo, makwinꞌ! Tak ndaꞌ goꞌ dyezmo chanꞌ pthyon, chanꞌ kolantr, chanꞌ re la ncho komid nde ndlaꞌ goꞌ re jwanꞌ mas ntak lo ley, xa nak: Re jwanꞌ galꞌ, yalndlat lazoꞌ nde bli lazoꞌ goꞌ Dios. Re jwanꞌ reꞌ ndablo goꞌ li goꞌ nde nalad goꞌ li goꞌ temasa. ");
INSERT INTO ztp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ngoꞌb kow goꞌ ned lo men, tak ndli goꞌ xa ndli xaꞌ ngote mchuꞌs lo nit nchuꞌ, per ngab xaꞌ ti kamey! ");
INSERT INTO ztp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Nalat nya goꞌ, maestr nchak ley nde re goꞌ fariseo, makwinꞌ! Goꞌ nak xaja bas nde yen, ntach goꞌ xis neꞌy, per yek goꞌ sey nzo re yalwanꞌ nde re yaltablasꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo xa' nkow lon'! Nerla ptombi goꞌ jwanꞌ nzo lenꞌ bas nde jwanꞌ nzo lenꞌ yen, sa taga mbi xis neꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Nalat nya goꞌ, maestr nchak ley, nde re goꞌ fariseo, makwinꞌ! Nak goꞌ xaja baꞌ nawe nakits nya xis naꞌ nde lenꞌ neꞌy se nzo re sij xaꞌ nguj nde reta jwanꞌ bew. ");
INSERT INTO ztp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taga nak goꞌ, benꞌ xis ndloꞌ goꞌ nabeꞌz toz nak goꞌ lo re men, per yek goꞌ sey nzo reta yalkwinꞌ nde reta yalxkap. ");
INSERT INTO ztp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Nalat nya goꞌ, maestr nchak ley, nde re goꞌ fariseo, makwinꞌ! Tak ntoxkwaꞌ goꞌ banꞌ re profet nde nawe nya re jwanꞌ ndob goꞌ yek banꞌ re xaꞌ galꞌ mdo lo Dios, ");
INSERT INTO ztp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nde mbez goꞌ: “Tez naꞌ ngo tyemp ngo re xaꞌ gox lonꞌ pola, naꞌngod naꞌ xij re xaꞌ mbij re profet”. ");
INSERT INTO ztp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Leꞌga leꞌ goꞌ ndej goꞌ jwanꞌ nak goꞌ, ke lo bin re xaꞌ mbij profet nde goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Noga goꞌ, ptolo goꞌ jwanꞌ mtobte re xaꞌ gox lo goꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Xaja nak mziꞌb ba nak goꞌ! ¡Go' ba nya lo bin mzib ba nak goꞌ! ¿Xa lyaꞌ goꞌ lo yalnathoz chanꞌ yeꞌr abil? ");
INSERT INTO ztp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jwanꞌ nasa, telꞌ na lo goꞌ re profet, re xaꞌ nchak nde re maestr nchak ley. Per pla xaꞌ kuj goꞌ nde pla xaꞌ keꞌ goꞌ lo kruz, nde pla xaꞌ kin goꞌ lenꞌ re yo tenꞌ ndyop xaꞌ Israel, nde choꞌbla goꞌ xaꞌ yez kon yez. ");
INSERT INTO ztp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sa yek goꞌ ya reta yalke ta mbij xaꞌ re men galꞌ mdo lo Dios xis izyo reꞌ, xata Abel axta Zacarías xinꞌ Berequías jwanꞌ mbij goꞌ xlaj tenꞌ ntolꞌ xaꞌ jwanꞌ yon nde tenꞌ nayon lenꞌ yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nipa na lo goꞌ, leꞌ reta yalke ta nguj re xaꞌ ya, yeꞌd xis re men nzo na tyemp reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Men yez Jerusalén, men yez Jerusalén, goꞌ ta nguj re profet nde ngadke go' re xaꞌ ntelꞌ Dios lo goꞌ! ¡Pla gob ncholas na nthop na re xinꞌ la xa nthop ngidtan re chuy xanꞌ xilꞌ maꞌ nde naꞌndoyalta la! ");
INSERT INTO ztp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Naya, bwiꞌ goꞌ nea, leꞌ liz goꞌ baꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","tak nin lo goꞌ, naꞌwiꞌtra goꞌ na naya, axta kebeꞌ sin wiz gab goꞌ: “¡Nayon nak xaꞌ nde lo le Xaꞌ Nyebeꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Senꞌ mbroꞌte Jesús lenꞌ yodoꞌ nde ndoyo Xaꞌ ned, zya mbike re xin'te'd Xaꞌ lo Xaꞌ sa loꞌ xin'te'd Xaꞌ xa nawe natoxkwaꞌ yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Leꞌ Jesús nchab lo re xaꞌ: —¿Bwiꞌ goꞌ re jwanꞌ reꞌ nea? Nipa na lo goꞌ, nek thib ke naꞌkwekwaꞌda xis ta ke. Dib tira bil. ");
INSERT INTO ztp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lo senꞌ ndob Jesús yiꞌ Olib, zyasa xaꞌta mbike gax re xin'te'd Jesús, nde mnabdiꞌs xaꞌ lo Jesús nchab xaꞌ: —Ptej lo náꞌ, ¿pol ak reta jwanꞌ reꞌ, nde xa nya re jwanꞌ ak beꞌ senꞌ lo yeꞌd la, nde senꞌ ndoyolo tyemp? ");
INSERT INTO ztp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zyasa mkab Jesús nde nchab Xaꞌ: —Nda wiꞌ goꞌ, sa nek tib men nakwinꞌnod xaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tak bro toz xaꞌ yeꞌd nde li rsinꞌ xaꞌ len, gab xaꞌ: “Na nak Crist”, nde men toz kwinꞌno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nde gon goꞌ nzo byo, nde gon goꞌ xyoꞌbdiꞌs yo byo, per naꞌzyebta goꞌ, tak nakinꞌ ak reta jwanꞌ reꞌ, per nanakta zya yolo tyemp. ");
INSERT INTO ztp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tak ti yez keꞌ byo kon tib yez, nde ti rey keꞌ byo kon tib rey, yo win, yo yis nde nar tenꞌ win xo toz. ");
INSERT INTO ztp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nde reta jwanꞌ reꞌ ak xanꞌ reta yalnathoz yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Zyasa tayaꞌ re men goꞌ sa toti xaꞌ goꞌ, kuj xaꞌ goꞌ, nde giꞌno reta men goꞌ kwent ndli lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Zya nar toz xaꞌ tyaꞌb, laꞌ xaꞌ xkiꞌs Dios, nde tayaꞌ xaꞌ ta xaꞌ sa toti men xaꞌ nde giꞌno xaꞌ ta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nde yo naꞌr toz re profet kwinꞌ nde men toz kwinꞌno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lo jwanꞌ toz ryo re yalnarax, men toz laꞌ xaꞌ yalkeꞌ lazoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per xaꞌ tiblaꞌ ne tyo axta lulka, xaꞌ ya lyaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nde xkiꞌs Dios, yaja lo re men dib nax izyo, sa reta men yolo xkiꞌs Dios, axta zyara sa yaloy. ");
INSERT INTO ztp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jwanꞌ nasa, senꞌ wiꞌ goꞌ tenꞌ nayon nzo jwanꞌ xkap toz tir li bew reta jwanꞌ, ta mdej profet Daniel —Xaꞌ ndlab jwanꞌ reꞌ ndablo yen xaꞌy—, ");
INSERT INTO ztp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","zyasa re xaꞌ nzo xyon Judea, xyonꞌ xaꞌ ya xaꞌ re yiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nde cho xaꞌ ndo yek yo liz xaꞌ, naꞌlyad xaꞌ yalote xaꞌ nek tib chanꞌ xaꞌ we xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","nde cho xaꞌ ndo lenꞌ wan, naꞌbered xaꞌ ya xiꞌ xaꞌ lar nxyoꞌb xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Per nalat toz tyak re ngol jwanꞌ ndo yis tan, nde re ngol nka mbed benꞌ nchuꞌ nis wiz ya! ");
INSERT INTO ztp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mnaꞌb goꞌ lo Dios sa naꞌxyonꞌta goꞌ tyemp nxyoꞌb yop nde wiz jwanꞌ ndryoꞌxkwen men. ");
INSERT INTO ztp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tak zyasa jwanꞌ toz tir yo yalnathoz jwanꞌ teraꞌ yo xata mbre ner men xis izyo axta naya, nde naꞌyotraꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nde tez Dios naꞌtodopta tyemp ya, naꞌngen cho lyaꞌ, nde por kwent chanꞌ re men jwanꞌ mblía Dios jwanꞌ nasa todop Dios tyemp ya. ");
INSERT INTO ztp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Zyasa tez cho nye lo goꞌ: \"Wiꞌ goꞌ leꞌ Crist ndo ncheꞌ ya”, o \"Wiꞌ goꞌ leꞌ xaꞌ ndo ba”, naꞌlid lazoꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tak yocheꞌ re xaꞌ kwinꞌ, gab xaꞌ na nak crist nde na nak profet, nde li xaꞌ re jwanꞌ nzoyen re men wiꞌ men, nde re yalnaro toz sa kwinꞌno xaꞌ re men nde axta no re xaꞌ mblía Dios kwinꞌno xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ax nia nay lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jwanꞌ nasa tez nye xaꞌ lo goꞌ: “Wiꞌ goꞌ, leꞌ xaꞌ ndo lad izyo biz”, naꞌyad goꞌ tya, o tez nye xaꞌ lo goꞌ: “Wiꞌ goꞌ, leꞌ xaꞌ ndob lenꞌ yo ba”, naꞌlid lazoꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tak ta xa ndlya beltiꞌ ned tenꞌ nche'dke wiz nde ndloꞌy axta ned nchaꞌd wiz, tagaꞌ mod ak senꞌ lo yeꞌd Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tak one ploja nax maꞌ nguj tya ndyope re ngol. ");
INSERT INTO ztp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Senꞌ benꞌta ngolo mbriꞌd re yalti toz tyemp ya, yuꞌ wiz nde naꞌtorxnid mbeꞌ nde gab reta mbel nziꞌb lo beꞌ, nde dib yalne chanꞌ beꞌ win. ");
INSERT INTO ztp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Zyasa leꞌ yalnaro chanꞌ Xinꞌ Mbiꞌ, loꞌ lo beꞌ nde reta xaꞌ nzo lo izyo kwesyaj xaꞌ gon xaꞌ, nde wiꞌ xaꞌ Xinꞌ Mbiꞌ nde xis xkow lo beꞌ kon yalne nde yalnyebeꞌ toz chanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nde telꞌ Xaꞌ re anj chanꞌ Xaꞌ kwes ne toz trompet nde thope anj reta xaꞌ jwanꞌ mblía Dios dib nax izyo, axta tenꞌ ndyobte izyo nde axta tenꞌ ndib izyo. ");
INSERT INTO ztp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Pteꞌd goꞌ jwanꞌ ndloꞌ ya hig: Senꞌ ndryoꞌ bey lo neꞌy nde ndryoꞌ xoꞌb la yenꞌ na, zyasa mne goꞌ leꞌ beꞌ yi nde gaxla. ");
INSERT INTO ztp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tagaꞌ goꞌ senꞌ wiꞌ goꞌ re jwanꞌ reꞌ, mnega goꞌ leꞌ Xaꞌ ndogaxla yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nipa na lo goꞌ, nared men nzo tyemp reꞌ gaj axta kebeꞌ ak reta jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Beꞌ nde izyo tlux loy per xkiꞌs na naꞌluxta, leꞌy a akay. ");
INSERT INTO ztp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Per wiz nde hor aka naꞌngen cho nyey, neꞌkla re anj nzi lo beꞌ, benꞌta Xud na Dios mney. ");
INSERT INTO ztp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta xa ngoka tyemp ngo Noé, taga mod aka senꞌ lo yeꞌd Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tak lenꞌ re wiz senꞌ tera lya yi xuꞌ toz tira, re xaꞌ nzi ya nde nzi yuꞌ xaꞌ nit, nzi selyaꞌ xaꞌ nde ndaꞌ xaꞌ xinꞌ xaꞌ selyaꞌ, axta kebeꞌ ngote Noé lenꞌ bark, ");
INSERT INTO ztp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nde naꞌgonta xaꞌ diꞌs axta kebeꞌ mbla yi xuꞌ toz tiraꞌ, nde mblyow re xaꞌ, taga aka senꞌ yeꞌd Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Zyasa chop xaꞌ nge sinꞌ wan, thib xaꞌ yoꞌ nde tib xaꞌ baꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chop ngol nge toꞌ jwanꞌ ro molin, thib ngol yoꞌ nde tib ngol baꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jwanꞌ nasa, brena goꞌ, tak naꞌnyed goꞌ cho hor yal na. ");
INSERT INTO ztp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Per byen goꞌ jwanꞌ reꞌ, tez xaꞌ nak liz yo nye xaꞌ cho hor lya wanꞌ liz xaꞌ, tobna xaꞌ nde naꞌtad xaꞌ diꞌs lya wanꞌ liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jwanꞌ nasa, noga goꞌ tiblaꞌ brena goꞌ, tak leꞌ Xinꞌ Mbiꞌ yeꞌd hor jwanꞌ nandlid goꞌ xgab. ");
INSERT INTO ztp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Cho nak mos tiblaꞌ ndo nde nzo xgab yek naꞌ? Lo mos ya tanꞌno xaꞌ nyebeꞌ re men liz xaꞌ, sa taꞌ mos jwanꞌ wa re men liz xaꞌ senꞌ nakinꞌ mena. ");
INSERT INTO ztp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nabeꞌz toz nda mos ya senꞌ lo yeꞌd twiꞌ xaꞌ mos nde yosiꞌb xaꞌ mos ngeli mos re jwanꞌ mnibeꞌ xaꞌ lo mos. ");
INSERT INTO ztp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nipa na lo goꞌ, lo mos ya tanꞌ xaꞌ reta jwanꞌ ngeno xaꞌ, sa kenap mosa. ");
INSERT INTO ztp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per tez mos ya nakap nak, li mos xgab: \"leꞌ xwanꞌ na sowꞌraꞌ yeꞌd\", ");
INSERT INTO ztp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nde tolo kin mos re ta mos mos, tolo wa mos nde gu mos nit kon re xaꞌ guy. ");
INSERT INTO ztp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Leꞌ xaꞌ nyebeꞌ bere wiz nde hor jwanꞌ nangembedta mos. ");
INSERT INTO ztp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Zyasa jwanꞌ toz kin xaꞌ mos, nde ko xaꞌ mos plo nzo re xaꞌ kwinꞌ. Tya gon mos nde tyez le mos. ");
INSERT INTO ztp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Leꞌ yalnyebeꞌ lo beꞌ ak xaja nak siꞌ mzaꞌ yenꞌ jwanꞌ mxen kandil naꞌ, mbroꞌ ndaxiꞌ ned mbyo jwanꞌ selyaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gayꞌ mzaꞌ naxaxla's nde ti gayꞌ mzaꞌ ne yek na'. ");
INSERT INTO ztp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Leꞌ re gayꞌ mzaꞌ ta naꞌngenta xgab yek naꞌ ya, mbeꞌ mzaꞌ kandil per naꞌngwed mzaꞌ aseyt yoy tedib gob. ");
INSERT INTO ztp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per leꞌ re mzaꞌ nzo xgab yek naꞌ ya, mbeꞌ mzaꞌ kandil nde xaꞌta mbeꞌ mzaꞌ masra aseyt lenꞌ ye. ");
INSERT INTO ztp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nde ndolenꞌ mbyo selyaꞌ ya, tolo nde mkalꞌ lo re mzaꞌ nde mdat re mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nde mer rolja yalꞌ mbyen mbrez thi xaꞌ: \"¡Leꞌ mbyo selyaꞌ nde, goche goꞌ waxiꞌ ned goꞌ mbyo!\" ");
INSERT INTO ztp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Zyasa ngoche reta mzaꞌ, nde mdoxkwaꞌ mzaꞌ kandil mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Zyasa re gayꞌ mzaꞌ ngenta xgab yek naꞌ ya, nchab lo ti gayꞌ mzaꞌ ta nzo xgab yek naꞌ ya: \"Taꞌ goꞌ lud aseyt goꞌ ka náꞌ, tak ndo yuꞌ kandil náꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per re mzaꞌ ta nzo xgab yek naꞌ ya mkab: \"par naꞌakjwadta aseyt lo náꞌ nde lo goꞌ, mas jwin wa ka goꞌ aseyt goꞌ tenꞌ nto xaꞌy.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per laja nda tiꞌ re gayꞌ mzaꞌ ta naꞌngenta xgab yek naꞌ ya aseyt, leꞌ mbyo selyaꞌ mzin. Nde re mzaꞌ ta nzisaꞌla ngoteno mzaꞌ mbyo selyaꞌ ya lo yalselyaꞌ, nde mtowꞌ xaꞌ yala. ");
INSERT INTO ztp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Xisa mzin re mzaꞌ nangeta xgab yek naꞌ ya nde mbrez re mzaꞌ, nchab mzaꞌ: “¡Xa' nyebe', Xa' nyebe', bxalꞌ yala sa yote náꞌ!” ");
INSERT INTO ztp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per leꞌ mbyo mkab: “Galꞌ diꞌs, nanzolot na goꞌ”. ");
INSERT INTO ztp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zyasa nchab Jesús: —Brena goꞌ, tak naꞌnyed goꞌ cho wiz nde cho hor yeꞌd Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Leꞌ yalnyebeꞌ lo beꞌ nak xa nak thi mbiꞌ jwanꞌ ryoꞌ nda tij, nde mbrez xaꞌ re mos xaꞌ sa mtanꞌno xaꞌ re chanꞌ xaꞌ lo mos. ");
INSERT INTO ztp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Lo thib xaꞌ mdaꞌ xaꞌ gayꞌ mil tmi or, lo tedib xaꞌ mdaꞌ xaꞌ chop mila, nde lo tedib xaꞌ mdaꞌ xaꞌ ti mila, benꞌ xa nke xaꞌ sinꞌ ta mdaꞌ xaꞌy lo tiba xaꞌ; nde mbroꞌ xaꞌ nda xaꞌ tij. ");
INSERT INTO ztp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Leꞌ mos ta mkayaꞌ gayꞌ mil tmi ya, mkeno xaꞌy sinꞌ nde mbli xaꞌ gan ti gayꞌ mil tmi yek jwanꞌ ta mkayaꞌ xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Taga xaꞌ ta mkayaꞌ chop mil tmi ya, mbli xaꞌ gan ti chop mil la yek jwanꞌ ta mkayaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per xaꞌ ta mkayaꞌ ti mila ya, ngwathenꞌ xaꞌ thi yeꞌr nde mkaꞌs xaꞌ tmin xaꞌ nyebeꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mbriꞌd bro toz tyemp seraꞌ mbere xaꞌ nyebeꞌ lo re mos nde mbloꞌ xaꞌ kwent kon re mos xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nde mzin mos jwanꞌ ta mkayaꞌ gayꞌ mil tmi yaꞌ, nde ndeno xaꞌ tedib gayꞌ mil tmi nde nchab xaꞌ: \"Señor, gayꞌ mil tmi mdaꞌa lon leꞌ chanꞌ la ncheꞌyaꞌ nde mblin gan ti ta gayꞌ mila lo jwanꞌ ta mdaꞌa lon.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nde xaꞌ nyebeꞌ lo mos, nchab: \"Jwin toz mblia, mos galꞌ nak la, tiblaꞌ mblia rsinꞌ la, jwanꞌ lud mdan loa nde jwin mkenap lay, naya tayan masraꞌ broy loa. Briꞌd sa ko nale lazonꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Xisa mzin mos ta mkayaꞌ chop mil tmi, nde nchab: \"Señor chop mil tmi ta mdaꞌa lon, leꞌ chanꞌ la ncheꞌyaꞌ, mblin gan ti chop mil tmi lo jwanꞌ ta mdayaꞌa lon.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Leꞌ xaꞌ nyebeꞌ nchab: \"Jwin toz mblia, mos galꞌ nak la, tiblaꞌ mblia rsinꞌ la, jwanꞌ lud mdan loa nde jwin mkenap lay, naya tayan mas broy loa. Briꞌd sa ko nale lazonꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nde senꞌ lo mzin mos jwanꞌ ta mkayaꞌ thi mil tmi ya, nchab mos lo xaꞌ nyebeꞌ: \"Señor, mnen leꞌ lu nak thi xaꞌ ne toz nak, nthop la re jwanꞌ ngok plo namblot la bin, nde nthop la jwanꞌ ngok plo nambsit la mbis. ");
INSERT INTO ztp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jwanꞌ nasa mzyeb na nde ngwan mkaꞌs na tmin la lenꞌ izyo. Leꞌ tmin la ncheꞌyaꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Leꞌ xaꞌ nyebeꞌ nchab lo mos ya: \"Mos xkap nde mos saꞌb, mnea nthop na jwanꞌ plo namblot na bin, nde nthop na jwanꞌ plo nambsit na mbis. ");
INSERT INTO ztp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jwanꞌ nasa ndablo ndaꞌa tmina nkeno men sinꞌ, sa senꞌ mberen nkayan tmina kon re jwanꞌ mbliy gan.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Zyasa nchab xaꞌ: \"Pkib goꞌ tmi lo yaꞌ xaꞌ, nde pta' goꞌy lo xaꞌ ta nden siꞌ mila. ");
INSERT INTO ztp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tak xaꞌ ngenolay, masraꞌy kayaꞌ xaꞌ sa keno xaꞌ mas broy nde xaꞌ nangennodey, xaꞌ ya axta jwanꞌ lud ngeno xaꞌ yiꞌba yaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nde mos ngen cho sinꞌ ndli, blote goꞌ xaꞌ le lo yalkow, tya gon xaꞌ nde tyez le xaꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Senꞌ yeꞌd Xinꞌ Mbiꞌ xajka Rey kon yalnaro chanꞌ Xaꞌ nde kon reta anj nayon, zyasa tyob Xaꞌ tenꞌ nyebeꞌ Xaꞌ kon yalnaro chanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nde dyope reta men nzi dib xis izyo lo Xaꞌ, nde koxaꞌ Xaꞌ men lo ta men, ta xa ngoxaꞌ xaꞌ nkenap mbakxilꞌ re mbakxilꞌ xij re chib. ");
INSERT INTO ztp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nde re mbakxilꞌ kwek Xaꞌ lad ban Xaꞌ, leꞌ re chib kwek Xaꞌ lad beg Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Zyasa gab Rey lo re xaꞌ nzi lad ban Xaꞌ: \"Deꞌ reta goꞌ ta mbli leyꞌ Xud naꞌ, pkayaꞌ goꞌ tenꞌ nyebeꞌ goꞌ jwanꞌ mtanꞌla Xaꞌ par goꞌ axta senꞌ mdoxkwaꞌ izyo. ");
INSERT INTO ztp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Senꞌ ndyanꞌ na, mdaꞌ goꞌ jwanꞌ mdan, nchek lazoꞌn nde mdaꞌ goꞌ nittye ngun, mketeꞌn plo nanakta las na, mdaꞌ goꞌ plo mbled na. ");
INSERT INTO ztp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngenta xab na nde mdaꞌ goꞌ lar ngok na, mxak yis na nde ngwa tna goꞌ na, mkeꞌn lizyiꞌb nde ngwa twiꞌ goꞌ na.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Zyasa re xaꞌ galꞌ ndo nyabdiꞌs xaꞌ: \"Señor, ¿poa mbwiꞌ náꞌ lu ndyanꞌ la nde mdaꞌ náꞌ jwanꞌ mdaa? ¿Poa mbwiꞌ náꞌ nchek lazoꞌa nde mdaꞌ náꞌ nitye nguꞌa? ");
INSERT INTO ztp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Poa mbwiꞌ náꞌ lu ngetea xaꞌgaꞌ izyo nde mdaꞌ náꞌ plo mbled la o ngenta xab la nde mdaꞌ náꞌ lar ngok la? ");
INSERT INTO ztp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O pol mbwiꞌ náꞌ nayiz la, o ngea lizyiꞌb nde ngwa tna náꞌ lu?\" ");
INSERT INTO ztp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Zyasa kab Rey lo re xaꞌ ya: \"Nipa na lo goꞌ senꞌ mbli goꞌy lo thi wes na o btanꞌ na, jwanꞌ mas nabil ndyak, lon mbli goꞌy.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Zyasa noga lo xaꞌ ta nzi lad beg Rey gab Rey: \"Baxa bike goꞌ, men xkap toz, wa goꞌ lo bel adiꞌ jwanꞌ natoxkwaꞌ la par Maxuꞌ kon re anj chanꞌ Maxuꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tak senꞌ ndyanꞌ na, naꞌndaꞌd goꞌ jwanꞌ ngwan, nchek lazoꞌn naꞌndaꞌd goꞌ nitye ngun, ");
INSERT INTO ztp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mketeꞌn izyo plo nanakta las na nde naꞌndaꞌd goꞌ plo mbed na. Ngenta xab na nde naꞌndaꞌd goꞌ lar ngok na, mxak yis na nde mkeꞌn lizyiꞌb nde naꞌngatnad goꞌ na.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Zyasa no re xaꞌ ya kab lo Rey: \"Señor, ¿pol mbwiꞌ náꞌ ndyanꞌ la, nchek lazoꞌa, mketea izyo plo nanakta las la, ngenta lar gok la, mxak yis la nde mkea lizyiꞌb nde naꞌndlastod náꞌ lu?\" ");
INSERT INTO ztp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Leꞌ Rey kab lo re xaꞌ ya: \"Nipa na lo goꞌ, kwent naꞌndlid goꞌy lo thi men jwanꞌ mas nabil ndyak, lon naꞌndlid goꞌy.\" ");
INSERT INTO ztp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nde re xaꞌ reꞌ ya, ya lo pen adiꞌ, nde leꞌ re xaꞌ mbli jwanꞌ galꞌ, xaꞌ ya ya lo yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Senꞌ mne mdej Jesús reta diꞌs ya, nchab Xaꞌ lo re xin'te'd Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mne goꞌ lenꞌ ti chop wiz gal ni pask, nde leꞌ Xinꞌ Mbiꞌ tayaꞌ men Xaꞌ sa ke Xaꞌ lo krus. ");
INSERT INTO ztp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Zyasa, re nglweyꞌ jwanꞌ nyebeꞌ, re maestr nchak ley, nde re xaꞌ gox nyebeꞌ lo yez, mdyop xaꞌ lo le chanꞌ nglweyꞌ ro ndole Caifás, ");
INSERT INTO ztp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tya ngok diꞌs re xaꞌ sa kon yalkwinꞌ tyen xaꞌ Jesús nde kuj xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per nchab re xaꞌ: —Naꞌlid naꞌy lenꞌ ni reꞌ, sa naꞌxyolta re men. ");
INSERT INTO ztp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nde senꞌ ndo Jesús lenꞌ yez Betania, liz Simón xaꞌ mxak yis ye'sya's; ");
INSERT INTO ztp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","zyasa msin thi ngol ndeno thi bot ndole alabastro sey nzo nit naxe' nap toz ntak. Nde mblaj ngol bisa yek Jesús senꞌ ndob ya Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Senꞌ mbwiꞌ re xin'te'd Jesús jwanꞌ na, Mxi lazoꞌ xaꞌ nde nchab xaꞌ: —¿Kwanꞌ liy ta mxo ngol nit naxe'? ");
INSERT INTO ztp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jwanꞌ reꞌ ndoyal nap toz ndoy nde tmi ya ndaꞌ men lo re xaꞌ prob. ");
INSERT INTO ztp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nde mbin Jesús jwanꞌ na, nchab Jesús lo re xin'te'd Xaꞌ: —¿Kwan liy ndaꞌ goꞌ xyan yek ngol reꞌ? Thi yalwen mbli ngol reꞌ lon. ");
INSERT INTO ztp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tak goꞌ tatka nzono goꞌ xaꞌ prob, nde na naꞌyot na xij goꞌ dib tyemp. ");
INSERT INTO ztp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lo ta mchub ngol nit naxeꞌ yek na, mbli ngol ndosa'a na lo senꞌ gaꞌs na. ");
INSERT INTO ztp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nipana lo goꞌ, one plo tej men xkiꞌs Dios dib xis izyo, noga yaj jwanꞌ mbli ngol reꞌ lon, sa tamod telaꞌs men ngol. ");
INSERT INTO ztp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Zyasa Judas Iscariot, tib xaꞌ no nak re tib zen xin'te'd Jesús, ngwa xaꞌ lo re nglweyꞌ jwanꞌ nyebeꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nde nchab Judas lo re xaꞌ ya: —¿Plopa taꞌ goꞌ kan tez tayan Jesús lo goꞌ? Zyasa mdaꞌ xaꞌ galpsiꞌ tmi plata lo Judas. ");
INSERT INTO ztp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nde xata zya ndobte Judas tolo mkwanꞌ xaꞌ xamod tayaꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wis ner jwanꞌ ndyobte ni jwanꞌ ncha xaꞌ pan naꞌngenta lebadur, mbike re xin'te'd Jesús lo Jesús nde mnabdiꞌs xaꞌ: —¿Plo ncholaꞌs la toxkwaꞌ náꞌ rsyeꞌ waa lenꞌ yalꞌ pask? ");
INSERT INTO ztp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nde Jesús nchab: —Wa goꞌ yez, liz thi mbiꞌ nde gus goꞌ lo mbiꞌ: “Leꞌ Maestr ne: Leꞌ hor na ndosin gax, nde liz la wa rsyeꞌn ni pask kon re xin'te'd na”. ");
INSERT INTO ztp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nde re xin'te'd Jesús mbli reta jwanꞌ mnabeꞌ Jesús, nde mdoxkwaꞌ xaꞌ jwanꞌ wa rsyeꞌ xaꞌ lenꞌ yalꞌ ni pask. ");
INSERT INTO ztp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Senꞌ lo mbla yalꞌ ngo Jesús ro mes kon re tib sen xin'te'd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nde laja nzi ya re xaꞌ, nchab Jesús lo re xin'te'd Xaꞌ: —Galꞌpa diꞌs nin lo goꞌ, leꞌga thi goꞌ reꞌ tayaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Zyasa nabil toz ngo lazoꞌ re xin'te'd Jesús, nde thib thiba xaꞌ tolo mnabdiꞌs lo Jesús nchab xaꞌ: —¿Cho nay Señor? ");
INSERT INTO ztp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Zyasa mkab Jesús lo re xaꞌ: —Xaꞌ jwanꞌ thita ngo yanꞌ lenꞌ yen kon na, xaꞌ yay. ");
INSERT INTO ztp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lipa leꞌ Xinꞌ Mbiꞌ, rid ndaꞌb reta jwanꞌ nge ni lo xkiꞌs Dios rid Xaꞌ, per ¡nalat thos toz yate xaꞌ jwanꞌ tayaꞌ Xinꞌ Mbiꞌ! Mas jwin naꞌngalta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zyasa mkab Judas xaꞌ ta tayaꞌ Jesús nchab: —¿Cho nay? Maestr. Jesús mkab lo Judas: —Aaꞌ, luy. ");
INSERT INTO ztp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laja nzi ya re xaꞌ, Jesús mxen pan nde mdaꞌ Xaꞌ ndyux lo Dios, xisa mblirol Xaꞌy mdaꞌ Xaꞌy lo re Xinꞌ teꞌd Xaꞌ nde nchab Xaꞌ: —Bxen goꞌ pan nde bda goꞌy, jwanꞌ reꞌ nak belꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Xisa mxen Jesús kop nzo bin, nde ngolo mdaꞌ Xaꞌ dyux lo Dios, mdaꞌ Xaꞌy lo re xin'te'd Xaꞌ nde nchab Xaꞌ: — Guꞌ reta goꞌ jwanꞌ nzo lenꞌ kop reꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tak bin reꞌ nak ren na, ren jwan' nak mod kub mtanꞌ Dios xkiꞌs Dios, ren jwanꞌ xyo sa dyonꞌ xken bro toz men. ");
INSERT INTO ztp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Naya, nin lo goꞌ, naꞌgutraꞌ na jwan' nda' lus ub, axta wiz senꞌ guney tedib gob kon goꞌ tenꞌ nyebeꞌ Xud na. ");
INSERT INTO ztp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Senꞌ ngolo mbilꞌ re xaꞌ di lo Dios, mbroꞌ re xaꞌ nda xaꞌ yiꞌ Olib. ");
INSERT INTO ztp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zyasa nchab Jesús lo re xin'te'd Xaꞌ: —Na yalꞌ reꞌ reta goꞌ laꞌ goꞌ na, tak lo xkiꞌs Dios nchab: “Kuj na xaꞌ ngenap mbakxilꞌ nde re mbakxilꞌ ryaꞌs” ");
INSERT INTO ztp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per senꞌ mbroxbanla na, ner na nda Galilea, xis yed goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Zyasa Pedr nchab lo Jesús: —Tanye reta xaꞌ laꞌ xaꞌ lu, na naꞌlat na lu. ");
INSERT INTO ztp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nde Jesús mkab lo Pedr: —Nipa na loa, na yalꞌ reꞌ, benꞌ tera kwes ngid teꞌ, son gob nchab la lu nazolodla na. ");
INSERT INTO ztp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Leꞌ Pedr nchab lo Jesús: —Tanye non nakinꞌ gaj kon lu, naꞌgabta na nanzolod na lu. Nde reta xin'te'd Jesús taga nchab. ");
INSERT INTO ztp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zyasa mzin Jesús kon re xin'te'd Xaꞌ tenꞌ ndole Getsemaní, nde nchab Jesús lo re xaꞌ: —Ncheꞌta btob goꞌ laja leꞌn nda ba, nda todiꞌsno Dios. ");
INSERT INTO ztp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nde mbeꞌ Jesús Pedr kon rop xaꞌ xinꞌ Zebedeo, nde tolo nabil toz ngo lazoꞌ Jesús nde narax ndyak Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Zyasa nchab Jesús lo xaꞌ: —Nabil toz nzo lazoꞌn, ndenꞌ na gaj na lo yalnabil reꞌ. Ncheta kwed goꞌ nde brenano goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tud mde Jesús tya, mdoxub Jesús axta mdinꞌ lo Xaꞌ izyo, nde mdodiꞌsno Xaꞌ Dios, nchab Xaꞌ: —Xud na, tez toyal la, ptolaꞌn lo pen re, per naꞌakte xa ncholas na, aka xa ncholas la. ");
INSERT INTO ztp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nde mbere Jesús plo nzi xin'te'd Xaꞌ, leꞌ re xinꞌ ted Xaꞌ nzi yat, nde nchab Xaꞌ lo Pedr: —¿Cho nekthib hor naꞌndlid goꞌ gan mbenano goꞌ na? ");
INSERT INTO ztp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Brena goꞌ nde mnaꞌb goꞌ lo Dios sa naꞌkwinꞌnod Maxuꞌ goꞌ. Galꞌ diꞌs leꞌ xbin goꞌ ncholaꞌs li xa ndabloy, per belꞌ goꞌ naxekta. ");
INSERT INTO ztp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nde ngwa Jesús mbrop gob nde mnaꞌb Xaꞌ lo Dios nchab Xaꞌ: —Xud na, riꞌd na pen reꞌ tez naꞌnyed lyanꞌ lo ney, aka xa ncholaꞌs la. ");
INSERT INTO ztp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lo senꞌ mbere Xaꞌ tedib gob tenꞌ nzi xin'te'd Xaꞌ, leꞌ xin'te'd Xaꞌ nzi yat, tak naꞌxektra xaꞌ ncho mkalꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nde mblaꞌ Jesús re xaꞌ tya, nde bere ngwa naꞌb Jesús lo Dios byon gob, nchab Xaꞌ leꞌga leꞌ re diꞌs ya. ");
INSERT INTO ztp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Zyasa mbere Xaꞌ tenꞌ nzi re xin'te'd Xaꞌ nde nchab Xaꞌ: —¿Cho tata nzi yat goꞌ nde nzi nryoꞌxkwen goꞌ? Se mzin hor leꞌ Xinꞌ Mbiꞌ tayaꞌ xaꞌ lo re men nzoꞌb xken naꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Goche goꞌ, lenꞌ nda, wiꞌ goꞌ, leꞌ xaꞌ ta tayaꞌn nde gaxla. ");
INSERT INTO ztp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tata benꞌ ndotodiꞌs Jesús, leꞌ Judas mzin, kon bro toz men, Judas reꞌ no ngok kwent lo re tib sen xin'te'd Jesús, nde re men ta ndeno Judas, cho xaꞌ nden ya nde cho xaꞌ nden espad. Re xaꞌ ya, mtelꞌ re nglweyꞌ jwanꞌ nyebeꞌ, kon re xaꞌ gox jwanꞌ nyebeꞌ lo yez. ");
INSERT INTO ztp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nde Judas xaꞌ ta mdayaꞌ Jesús sa, mbyanꞌ diꞌs la xaꞌ kon re xaꞌ ya nchab xaꞌ: —Xaꞌ jwanꞌ ken chut kwat naꞌ, Xaꞌ yay, bxen goꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nde zyaga mbike Judas lo Jesús, nchab Judas: —¡Chan goꞌ Maestr! Nde mda' Judas chut kwat Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Leꞌ Jesús nchab lo Judas: —Amig, ¿cho kwan ndelia? Zyasa mbike gax re xaꞌ ya, mxen xaꞌ Jesús sa we xaꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Per thi xaꞌ ndo kon Jesús mbloꞌ xaꞌ espad xaꞌ nde thiptane mchoꞌ xaꞌ thi nza xaꞌ nak mos nglweyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zyasa nchab Jesús lo xaꞌ: —Blotsaꞌ espad la tenꞌ nzo tsaꞌy. Tak reta xaꞌ ngyo kon espad, taga kon espad gaj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Cho leꞌa ndyak na naꞌakta nyaꞌb re anj lo Xud na naya, nde Xaꞌ telꞌ por mil anj chanꞌ Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per tez ta lin, ¿xamod ak reta jwanꞌ ngeni lo xkiꞌs Dios, ta nchab nakinꞌ ak jwanꞌ ta ndoyak naya? ");
INSERT INTO ztp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zyasa nchab Jesús lo re men: —¿Kwan liy nde goꞌ kon espad nde kon ya sa we goꞌ na xaja wanꞌ? Reta wiz mdob na lenꞌ yodoꞌ kon goꞌ mbloꞌn xkiꞌs Dios lo goꞌ nde naꞌndenta goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per reta jwanꞌ reꞌ ndoyak, sa gak reta xkiꞌs Dios jwanꞌ mkeꞌ re profet. Zyasa mxonꞌ reta xin'te'd Jesús mblaꞌ xaꞌ thib Jesús tya. ");
INSERT INTO ztp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Reta xaꞌ ta mxen Jesús, mbeꞌ xaꞌ Jesús lo xaꞌ nak nglweyꞌ ro nale Caifas, tenꞌ mdyop re maestr nchak ley nde re xaꞌ gox nyebeꞌ lo yez. ");
INSERT INTO ztp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Per Pedr, tij tij ndanke xis Jesús, axta mzin lo le liz nglweyꞌ ro, nde ngote Pedr mdob Pedr kon re xaꞌ ngenap liz nglweyꞌ ro, sa wiꞌ Pedr nyenꞌ xamod yolo yatey. ");
INSERT INTO ztp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nde re nglweyꞌ jwanꞌ nyebeꞌ, re xaꞌ gox nyebeꞌ lo yez nde re xaꞌ nak sinꞌ, nkwanꞌ xaꞌ nyenꞌ cho yalkwinꞌ keꞌ xaꞌ yalke yek Jesús, sa toyal tayaꞌ xaꞌ Jesús gaj Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per naꞌnzalta xaꞌ cho yalkwinꞌ keꞌ xaꞌ yek Jesús, taꞌnye naꞌr re xaꞌ mkeꞌ jwas xis Jesús. Lulka mzin chop xaꞌ kwinꞌ, ");
INSERT INTO ztp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nde nchab xaꞌ: —Mbiꞌ reꞌ nchab: “Tlin gan tzil na yodoꞌ chanꞌ Dios nde lenꞌ son wiz toxkwaꞌ nakub ney tedib gob.” ");
INSERT INTO ztp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Zyasa mdoli nglweyꞌ ro nde nchab xaꞌ lo Jesús: —¿Cho ngen kwan nyea? ¿Kwan liy sa ta ni re xaꞌ reꞌ xis la? ");
INSERT INTO ztp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per Jesús nankabta lo xaꞌ. Zyasa leꞌ nglweyꞌ ro nchab lo Jesús: —Nyaꞌb na loa por le Dios naban, btej lon náꞌ tez lu nak Crist, Xaꞌ nak Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Leꞌ Jesús mkab: —Nay, ta xa nea ba, nde noga nin lo goꞌ, naya tolo wiꞌ goꞌ Xinꞌ mbiꞌ ndob lad banꞌ Dios ngeno dib yalnaro, nde wiꞌ goꞌ Xaꞌ senꞌ yeꞌd Xaꞌ xij xkow lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Zyasa leꞌ nglweyꞌ ro mpched xaꞌ xab xaꞌ nde nchab xaꞌ: —¡Mnixin xa' xis Dios! ¿Kwan liy kwanꞌra naꞌ masra men ta kwent? Lega leꞌ goꞌ mbin, mnixin xa' xis Dios. ");
INSERT INTO ztp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xa ngwiꞌ goꞌy? Leꞌ re xaꞌ ya mkab: —Yalke nchap Xaꞌ nde ndablo gaj Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zyasa mzuk xaꞌ lo Jesús, nde mdin xaꞌ Jesús. Nde ti pla xaꞌ mdis bad lo Jesús ");
INSERT INTO ztp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nde nchab xaꞌ: —Tez lu nak Crist, ptej lo náꞌ ¿cho ta mkeꞌy choa? ");
INSERT INTO ztp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Laja ndob Pedr lo le, thi ngol nge sinꞌ tya mbike gax lo Pedr nde chab ngol: —Noa ngete kon Jesús Xaꞌ Galilea. ");
INSERT INTO ztp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Leꞌ Pedr mkaꞌs lo reta xaꞌ nde nchab Pedr: —Nyet na cho kwan ta mbez la. ");
INSERT INTO ztp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lo senꞌ ndarote Pedr ro yala, mbwiꞌga tedib ngol Pedr, nde nchab ngol lo re xaꞌ nzi tya: —No mbiꞌ reꞌ mkete kon Jesús xaꞌ yez Nazaret. ");
INSERT INTO ztp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Leꞌ Pedr mkaꞌs tedib gob, nde Dios mtobro Pedr nchab Pedr: —Nanzolot na mbiꞌ ta ndej goꞌ ba ");
INSERT INTO ztp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tud ndate, mbike gax re xaꞌ nzi tya nde nchab xaꞌ lo Pedr: —Ndloꞌ tir noa ngete xis Jesús, tak axta xa ndodiꞌs la ndloꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Zyasa leꞌ Pedr nchab: —Nia na lo goꞌ nanzolot na mbiꞌ ba. ¡Dios totin tez ndo kwinꞌ na! Nde hor yaga mbrez ngid teꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Zyasa mtelaꞌs Pedr jwanꞌ nchab Jesús lo Pedr: “Benꞌ tera kwes ngid teꞌ, son gob nchab la lu nanzolodla na.” Nde mbroꞌte Pedr le, tya jwanꞌ toz nabil mbinꞌ Pedr. ");
INSERT INTO ztp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Senꞌ lo mduxni, re nglweyꞌ jwanꞌ nyebeꞌ nde re xaꞌ gox jwanꞌ nyebeꞌ lo yez, ngok diꞌs xaꞌ nyenꞌ xa li xaꞌ sa kuj xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nde ndobo Jesús mbeꞌ xaꞌ Jesús, mdayaꞌ xaꞌ Xaꞌ lo Poncio Pilat, xaꞌ nak gobernador. ");
INSERT INTO ztp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zyasa Judas xaꞌ ta mdayaꞌ Jesús, lo mne xaꞌ leꞌ Jesús gaj, narax mxak xaꞌ nde mzire xaꞌ re gal psiꞌ tmi plata lo re nglweyꞌ nyebeꞌ nde lo re xaꞌ gox jwanꞌ nyebeꞌ lo yez, ");
INSERT INTO ztp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nchab xaꞌ: —Mkwan na yalke lon tak mdayan ti mbiꞌ ngencho yalke nchap lo yalguj. Per re xaꞌ ya mkab: —Ngen cho xyo nzo náꞌy, kwent chanꞌ la jwanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nde mblobi Judas re tmi plata ya lenꞌ yodoꞌ, mbroꞌ xaꞌ tya nda xaꞌ mblo xaꞌ doꞌ yen xaꞌ, mbij xaꞌ lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Leꞌ re nglweyꞌ jwanꞌ nyebeꞌ, mtop xaꞌ tmi ya nde nchab xaꞌ: —Naleꞌd naka konꞌ tmi reꞌ lenꞌ plo nchotsaꞌ tmi yon, tak leꞌy mbiax yalguj chanꞌ thi mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nde senꞌ ngolo ngokꞌ diꞌs re xaꞌ, kon tmi ya mxiꞌ xaꞌ Wan chanꞌ xaꞌ ndoxkwaꞌ jwanꞌ yomin, sa tya gaꞌs re xaꞌ nde tib blad. ");
INSERT INTO ztp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jwanꞌ nasa axta wiz naya wan ya ndole Izyo Ren. ");
INSERT INTO ztp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tamod ngok jwanꞌ mni profet Jeremías senꞌ nchab xa: \"Mxen xaꞌ re gal psiꞌ tmi plata, yapa mtob re xaꞌ Israel ntak Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nde kon tmi ya mxiꞌ xaꞌ wan chanꞌ xaꞌ ndoxkwaꞌ jwanꞌ yomin, xa mnebeꞌ Dios lon.\" ");
INSERT INTO ztp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lo senꞌ mbeꞌ xaꞌ Jesús lo Pilat xaꞌ nak gobernador, nde mnaꞌb diꞌs xaꞌ lo Jesús, nchab xaꞌ: —¿Cho lu nak rey lo re xaꞌ judío? Jesús mkab lo xaꞌ: —Nay ta xa nea ba. ");
INSERT INTO ztp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Senꞌ re nglweyꞌ jwanꞌ nyebeꞌ nde re xaꞌ gox jwanꞌ nyebeꞌ lo yez, mkeꞌ xaꞌ yalke yek Jesús, nde Jesús neklud nankabta. ");
INSERT INTO ztp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Zyasa nchab Pilat lo Jesús: —¿Cho nanchonta la plopa yalke ngekeꞌ xaꞌ yek la? ");
INSERT INTO ztp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesús nek thiblan diꞌs naꞌnkapta, jwanꞌ nasa jwanꞌ toz nzoyen gobernador. ");
INSERT INTO ztp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lenꞌ wiz nchal ni, leꞌ gobernador ngeno thi mod, ndlaꞌ xaꞌ thi men nge lizyiꞌb, thi men jwanꞌ ncholaꞌs re ma yez lyaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Zyasa, thi xaꞌ nzo'b toz xkiꞌs naꞌ nge lizyiꞌb ndole Barrabás; ");
INSERT INTO ztp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","nde senꞌ mdyope reta ma yez, mnabdiꞌs Pilat lo xaꞌ: —¿Cho ncholaꞌs goꞌ lan? ¿Cho Barrabása o Jesús Xaꞌ ni xaꞌ Crist? ");
INSERT INTO ztp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tak mne Pilat kwent ngiꞌno re men Jesús jwanꞌ na mdayaꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Laja ndob Pilat tenꞌ ndyob xaꞌ nyaꞌb xaꞌ kwent, zyasa ngol Pilat mtelꞌ thi diꞌs lo Pilat nchab: “Naꞌtotit la mbiꞌ ta ngen cho yalke nchap, tak narax toz msaꞌ lazoꞌn Xaꞌ yalꞌ la.” ");
INSERT INTO ztp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per re nglweyꞌ jwanꞌ nyebeꞌ nde re xaꞌ gox nyebeꞌ lo yez mblo xaꞌ yek re men toz tir nzi tya, sa nyaꞌb xaꞌ baꞌ Barrabás nde Jesús gaj. ");
INSERT INTO ztp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Leꞌ Pilat mbere mnabdiꞌs tedib gob: —¿Lo rop xaꞌ, xanya xaꞌ ncholaꞌs goꞌ lan? Leꞌ re xaꞌ mkab: —Barrabás blaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat nchab lo re xaꞌ: —Mbay ¿Cho kwan linon Jesús Xaꞌ ni xaꞌ Crist? Leꞌ reta xaꞌ mkab: —¡Pkeꞌ Xaꞌ lo Kruz! ");
INSERT INTO ztp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nde gobernador nchab lo re xaꞌ: —¿Cho jwanꞌ narax mbli Xaꞌ? Per reta men masra ne mbrez nde nchab xaꞌ: —¡Pkeꞌ Xaꞌ lo kruz! ");
INSERT INTO ztp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lo mne Pilat ngen kwan li xaꞌ gan, cheꞌla masra mxyol re men, mxen Pilat nit nde mtach xaꞌ yaꞌ xaꞌ lo re ma yez nde nchab xaꞌ: —Ngen cho yalke nchap na lo ta gaj mbiꞌ nambi reꞌ, kwent chanꞌ goꞌ naka. ");
INSERT INTO ztp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nde mkab reta ma yez lo Pilat: —Yek náꞌ nde yek xinꞌ náꞌ ya yalke ta gaj mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Zyasa mblaꞌ Pilat Barrabás, nde mnibeꞌ xaꞌ mdin men Jesús zyara mdayaꞌ xaꞌ Jesús sa ke Jesús lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Zyasa re sondad gobernador mbeꞌ xaꞌ Jesús yolow, nde tya mdyope reta sondad cho Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nde mbloche xaꞌ xab Jesús, nde mxoꞌb xaꞌ thi lar naren xis Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","nde kon yits mdoxkwaꞌ xaꞌ thi koron mtob xaꞌ yek Jesús, nde mblo xaꞌ thi ya yaꞌ ban Jesús. Zyasa mdoxub re xaꞌ lo Jesús nde mxino xaꞌ Jesús nchab xaꞌ: —¡Naro toz nak Rey chanꞌ re xaꞌ Judío! ");
INSERT INTO ztp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mzuk xaꞌ lo Jesús, nde leꞌga leꞌ ya nden Jesús mxen xaꞌ mkeꞌ xaꞌy yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngolo mxino xaꞌ Jesús, mkib xaꞌ lar nachal Xaꞌ nde mbok xaꞌ xab Xaꞌ tedib gob nde mbeꞌ xaꞌ Xaꞌ, sa keꞌ xaꞌ Xaꞌ lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Senꞌ lo ndorote xaꞌ tya, mzyalꞌ xaꞌ thi mbiꞌ yez Cirene ndole Simón, mbiꞌ ya fwerz mchal xaꞌ mbeꞌ mbiꞌ krus. ");
INSERT INTO ztp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nde senꞌ mzin xaꞌ tenꞌ ndole Gólgota, (diꞌs reꞌ nak: sij yek men). ");
INSERT INTO ztp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tya mdaꞌ xaꞌ nit binagr nos kon nit nala, gu Jesús, per benꞌta mbli beꞌ xaꞌy, naꞌngud Xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Senꞌ ngolo mkeꞌ sondad Jesús lo kruz, mblibeꞌ xaꞌ xis xab Jesús nyenꞌ xanya xaꞌ kay. Tamod ngok jwanꞌ nchab profet: \"mblibeꞌ xaꞌ xis xab na, nde mblirol xaꞌy xij xaꞌ\" ");
INSERT INTO ztp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nde re sondad mdob tya sa kenap xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nde gap yek krus tenꞌ nge Jesús mke xaꞌ letr ndej yalke mkeꞌ xaꞌ Jesús lo kruz, nchab: \"XAꞌ REꞌ NAK ¨JESÚS, REY LO RE XAꞌ JUDIO\" ");
INSERT INTO ztp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nde noga chop xaꞌ wanꞌ mkeꞌ lo kruz cho Jesús tib xaꞌ mke lad ban, nde tib xaꞌ mke lad beg Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nde re xaꞌ ndarid tya nkwin xaꞌ yek xaꞌ, nde naxin mbez xaꞌ lo Jesús, ");
INSERT INTO ztp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mbez xaꞌ: —Lu ta mbez sil yodoꞌ nde lenꞌ son wiz bere ntoxkwaꞌ nakub ley tidib gob, ptolaꞌ lazoꞌa. Tez xinꞌ Dios nak la, bla lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tagaꞌ mbli re nglweyꞌ jwanꞌ nyebeꞌ, re maestr nchak ley, re xaꞌ fariseo, nde re xaꞌ gox nyebeꞌ lo yez nxino xaꞌ Jesús mbez xaꞌ lo ta xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Xagaꞌ re men mtalaꞌ Xaꞌ nde nalid Xaꞌ gan tolaꞌ Xaꞌ leꞌga leꞌ Xaꞌ. Tez Xaꞌ nak Rey lo xaꞌ yez Israel, lya Xaꞌ lo kruz naya sa li lazonꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dios ndli lazoꞌ Xaꞌ, Dios tolaꞌ Xaꞌ naya tez nkeꞌ lazoꞌ Dios Xaꞌ, tak nchab Xaꞌ Xinꞌ Dios nak Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nde axta noga re xaꞌ wanꞌ ta nge lo kruz cho Jesús taga naxinꞌ mbez xaꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nde rolja wiz mbla yalꞌkow dib nax izyo axta a rolka bzye. ");
INSERT INTO ztp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nde mer las tres bzye ya Jesús mbrez yaj toz nchab: —Elí, Elí, ¿lama sabaktani? —Diꞌs reꞌ nak: Dios na, Dios na, ¿Kwan liy mblaꞌa na? ");
INSERT INTO ztp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pla xaꞌ nzi tya mbin xaꞌ jwanꞌ na nde nchab xaꞌ: —Profet Elías, ngebez Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nde zyaga thi xaꞌ ngwa karel mxen xaꞌ thi xilꞌ nde mbwaz xaꞌy binagr, nde mtob xaꞌy lo thi ya nde mdaꞌ xaꞌy nguꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Leꞌ temas xaꞌ nchab: —Laꞌa, sa winꞌ nyenꞌ cho tyeꞌd tolaꞌ Elías Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nde Jesús ne toz mbrez yaj Xaꞌ tedib gob nde nguj Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Zyasa leꞌ lar nge lenꞌ yodoꞌ arolja mcheda xata gap axta xanꞌ neꞌy, mbwin xo nde mblye re ke, ");
INSERT INTO ztp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mxyalꞌ re baꞌ, nde naꞌr toz re xaꞌ nguj, jwanꞌ galꞌ mkete lo Dios mbroꞌ xban. ");
INSERT INTO ztp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nde mbroꞌte xaꞌ lenꞌ baꞌ, senꞌ mbroꞌxbanla Jesús, ngote re xaꞌ lenꞌ Jerusalén yez nayon nde nar toz lo re men mbro'to xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Zyasa leꞌ xaꞌ nyebeꞌ lo sondad kon re sondad xaꞌ ta nzi kenap Jesús, lo mbwiꞌ xaꞌ mbwin xo nde reta jwanꞌ ta ngoka, mzyeb toz xaꞌ nde nchab xaꞌ: —¡Liga Xinꞌpa Dios nak mbiꞌ reꞌ! ");
INSERT INTO ztp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nde tya, tij nzi wiꞌ nar toz ngol jwanꞌ ta mdonke xis Jesús, xata mbroꞌ Xaꞌ Galilea nde mbli xaꞌ sinꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nde xij re ngol ya nzo Mari Magdalen, Mari xnaꞌ Jakobo kon Jose nde kon ngol xnaꞌ xinꞌ Zebedeo. ");
INSERT INTO ztp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Senꞌ lo ndala yalꞌ, mzin thi mbiꞌ rik xaꞌ yez Arimatea ndole Jose, mbiꞌ ya noga ngok xin'te'd Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mbiꞌ ya ngwa lo Pilat ngwanab thabol Jesús lo Pilat. Nde Pilat mnibeꞌ sa taꞌ xaꞌ thabol lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nde mxen Jose thabol, mchal xaꞌ Xaꞌ thi lar nambi ");
INSERT INTO ztp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nde mkaꞌs xaꞌ Jesús lenꞌ baꞌn kub xaꞌ, jwanꞌ mdenꞌ xaꞌ lad ke. Ngolo mtowꞌ xaꞌ ro baꞌ kon thi ke ro, ngo xaꞌ ned ndya xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nde tya nzi Mari Magdalen kon tedib Mari, ndob xaꞌ ngoꞌ lo baꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lo tedib wiz, wiz jwanꞌ ndryoxkwen men, mdyope re nglweyꞌ jwanꞌ nyebeꞌ kon re xaꞌ fariseo, lo Pilat, ");
INSERT INTO ztp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nde nchab xaꞌ lo Pilat: —Wiꞌ goꞌ nea, ndelazoꞌ náꞌ leꞌ xaꞌ kwinꞌ na, senꞌ lo benꞌ naban xaꞌ nchab xaꞌ, lo yaxob son wiz ryoꞌ xban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jwanꞌ nasa, mnebeꞌ sa ya kenap men baꞌ axta kebeꞌ yaxob son wiz, tak ndaga ya re xin'te'd xaꞌ yalꞌ, nde li wanꞌ xaꞌ thabol nde gab xaꞌ lo re men: “Mbroꞌxban xaꞌ xij re men nguj”. Nde yalkwinꞌ ya ak yalkwinꞌ mas naro lo yalkwinꞌ ner. ");
INSERT INTO ztp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nde Pilat nchab lo re xaꞌ: —Leꞌ re sondad nzi ba, beꞌ goꞌ xaꞌ nde jwin ptowꞌ goꞌy, goꞌ ya mnela xamod li goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Zyasa ngwa re xaꞌ ya nde jwin mtowꞌ xaꞌ baꞌ nde mtob xaꞌ re sondad mkenapa. ");
INSERT INTO ztp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngolo mbrid wiz jwanꞌ ndryoxkwen men, senꞌ ndatuxni doming, ngwa Mari Magdalen kon tedib Mari, ngwa twiꞌ xaꞌ banꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nde mbwin thi xo toz. Tak thi anj chanꞌ Dios mbroꞌ lo beꞌ, mbla nde mzikeꞌ anj ke ta nowꞌ ro baꞌ nde mdob anj xis ke. ");
INSERT INTO ztp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anta ndlya bel nya xaꞌ, xa nya bel tiꞌ ba nde leꞌ xab xaꞌ nakis tir nya, xaja nya yike. ");
INSERT INTO ztp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Senꞌ mbwiꞌ re sondad anj, mzyeb toz xaꞌ, anta nxiꞌd re xaꞌ nde ngob xaꞌ xaja xaꞌ nguja xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Zyasa nchab anj lo rop ngol: —Naꞌzyebta goꞌ, mnela na leꞌ goꞌ nkwanꞌ Jesús, Xaꞌ ta mkeꞌ men lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naꞌngenta Xaꞌ ncheꞌya, leꞌ Xaꞌ mbroxbanla xa nchabka xaꞌ ya, deꞌ goꞌ sa wiꞌ goꞌ tenꞌ mdix men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pken goꞌ wa goꞌ nde gus goꞌ lo re xin'te'd Xaꞌ: “Leꞌ Xaꞌ mbroxbanla nde ndatela Xaꞌ Galilea, tya wiꞌ goꞌ Xaꞌ. Jwanꞌ nata nin lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Zyasa leꞌ rop ngol mbroꞌ tenꞌ ndob baꞌ, mzyeb ngol nde nale toz ngo lazoꞌ ngol mkeꞌ ngol karel ndayab ngola lo re xin'te'd Jesús. Nde laja nda rop ngol, ");
INSERT INTO ztp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","cho leꞌ Jesús mbroꞌto mni dyux lo ngol. Zyasa mbike gax rop ngol, mdoxub ngol, mbli naro ngol le Jesús nde mdeꞌs ngol ni Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nde Jesús nchab lo rop ngol: —Naꞌzyebta goꞌ. Wa yab goꞌ lo re xin'te'd na, sa ya xaꞌ Galilea, tya wiꞌ xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Laja nda rop ngol, pla sondad ngwa yez Jerusalén nde mdaꞌ xaꞌ kwent reta jwanꞌ ta ngotey lo re nglweyꞌ jwanꞌ nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nde re nglweyꞌ ya ngwa todiꞌsno re xaꞌ gox jwanꞌ nyebeꞌ lo yez nde thita ngok diꞌs re xaꞌ, nde tmi toz mdaꞌ xaꞌ lo re sondad, ");
INSERT INTO ztp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nde nchab xaꞌ lo re sondad: —Gus goꞌ, yalꞌ senꞌ nzi yat náꞌ mbyed re xin'te'd Xaꞌ, nde mbli wanꞌ xaꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nde tez leꞌ gobernador nye jwanꞌ reꞌ, náꞌ ko yek xaꞌ sa nangen cho kwan li no xaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nde re sondad mxen tmi nde mbli xaꞌ xata nchab re xaꞌ ya lo xaꞌ. Nde yalkwinꞌ reꞌ nchaj xij re xaꞌ Judío axta naya. ");
INSERT INTO ztp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nde re siꞌ btib xin'te'd Jesús nda Galilea, lo yiꞌ jwanꞌ tenꞌ mnabeꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nde senꞌ lo mbwiꞌ re xaꞌ Jesús, mdoxub xaꞌ lo Jesús, per ti pla xaꞌ ngok rop xgab naꞌ. ");
INSERT INTO ztp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nde Jesús mbike lo re xaꞌ nde nchab Jesús lo xaꞌ: —Dios mdaꞌa dib yalnibe lon sa nyebeꞌn lo beꞌ nde lo izyo. ");
INSERT INTO ztp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jwanꞌ nasa, wa goꞌ, nde ptoteꞌd goꞌ men dib nax izyo, sa ak xaꞌ xinꞌteꞌd na nde kole goꞌ xaꞌ kon le Xud goꞌ Dios, kon le Xinꞌ Xaꞌ, nde kon le Mbi Nayon, ");
INSERT INTO ztp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nde bloꞌ goꞌ lo men li men reta jwanꞌ mnibeꞌn lo goꞌ. Nde wiꞌ goꞌ nea, na ndono goꞌ reta wiz, axta kebeꞌ lux izyo. Tamod naka.");
INSERT INTO ztp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","14 Mod reꞌ mdobte diꞌs wen chanꞌ Jesucrist Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jwan' xa nchab lo yeꞌs mkeꞌ profet Isaías, diꞌs jwanꞌ nchab Dios lo Crist: Ncheꞌ tel na thi xaꞌ todiꞌs xkiꞌs na ndasiblo loa, xaꞌ ya ndasiblo ndatoxkwa' xa' xned la. ");
INSERT INTO ztp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nchen mbez ti xaꞌ izyo nagan: “Ptoxkwaꞌ goꞌ xned Xaꞌ Nyebeꞌ; nali bdix goꞌ xned Xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ngole Juan men izyo nagan, nde mdej xaꞌ nakin' ryo'le men, laꞌ men re jwanꞌ narax nak men nde bere men lo Dios, sa tonꞌ Dios xken men. ");
INSERT INTO ztp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nde reta men nzo lo xyon Judea nde re men nzo yez Jerusalén mbye'd xaꞌ lo Juan, mxo'bdol xaꞌ reta xken xaꞌ nde mblole Juan xaꞌ lenꞌ yoꞌ Jordán. ");
INSERT INTO ztp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nde xab Juan naksaꞌ yis kamey nde sint nachal lenꞌ Juan nak yid; nde jwan' ncha Juan nak maꞌ bix nchat lo wan, nde mzin wan nchu' Juan. ");
INSERT INTO ztp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nde mdej Juan' lo men, nchab Juan: —Xis na nde tib Xaꞌ ngeno yalne ro ke na nde nansalꞌta na nekla par go'ten yalyid ni Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na lipa benꞌta lenꞌ nit mblolen goꞌ; per Xaꞌ kole goꞌ kon Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lenꞌ wiz ya, Jesús mbroꞌ yez Nazaret lo xyon Galilea, mzin Xaꞌ lo Juan nde mblole Juan Xaꞌ lenꞌ yoꞌ Jordán. ");
INSERT INTO ztp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nde lo le'ja ryo'te Jesús lenꞌ nit zya mbwiꞌ Xaꞌ mxyalꞌ lo beꞌ nde xaja ti palom nya Mbi Nayon mblay yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nde lo beꞌ mbro' mbyen mni ti Xa' jwan' nchab: —Lu nak Xinꞌ na jwanꞌ toz nkeꞌ lazoꞌn la; lu ngo nale lazoꞌn. ");
INSERT INTO ztp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zyaga mbe' Mbi Nayon Jesús tenꞌ nak izyo nagan. ");
INSERT INTO ztp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nde tya mkete Jesús choꞌ wiz tenꞌ nzo re maꞌ tin nde taja ncholaꞌs Maxuꞌ tokan xaꞌ Jesús. Nde re áng mkenap xa' Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Senꞌ mblola xa' Juan liz yib, Jesús nda lo xyon Galilea ndatej Xaꞌ diꞌs wen lo yalnyebeꞌ chanꞌ Dios, ");
INSERT INTO ztp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nchab Xaꞌ: —Ngoxobla be', nde yalnyebeꞌ chanꞌ Dios ndosinlay gax; bere go' lo Dios nde blaꞌ goꞌ re jwanꞌ narax nak goꞌ nde bli lazoꞌ goꞌ diꞌs wen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús ngete ro nittoꞌ Galilea, mbwiꞌ Jesús ndo Simón kon Ndres rop wes xaꞌ, nge gobi xaꞌ ye'd lo nittoꞌ; tak xaꞌ nak men god mbel. ");
INSERT INTO ztp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zyasa nchab Jesús lo xaꞌ: —Deꞌ goꞌ nde ptonke goꞌ xis na, sa lilal na goꞌ men god, sa li goꞌ gan men par Dios. ");
INSERT INTO ztp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nde zyaga mblaꞌ xaꞌ ye'd, mdonke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Le'ga tya mde Jesús tud nde mbwiꞌ Xa' Jakob kon wes xa' Juan xinꞌ Zebedeo, taga lo bark nzo xaꞌ, ngeyibde xaꞌ ye'd. ");
INSERT INTO ztp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nde zyaga mbrez Jesús rop xaꞌ, mblaꞌta xaꞌ xud xaꞌ Zebedeo lenꞌ bark kon re mos, ndanke xa' xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nde mzin xaꞌ yez Capernaum; nde len' re wiz jwanꞌ ndryoxkwen men, Jesús nchote lenꞌ yo tenꞌ ndyop re men Israel, ntoteꞌd Xaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nde nzoyen reta men ngwiꞌ xaꞌ xa nate'd Jesús; tak ntote'd Jesús men xaga Xa' ngeno yalnyebeꞌ, na'nakta Xa' xa nak re maestr ndlo' ley. ");
INSERT INTO ztp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nde len' yo ten' ndyop re men israel tya ndo thi mbiꞌ ndono mbi narax, nde ne mbrez xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","nchab xaꞌ: —¡Aah! ¿Cho kwan ndyaknoa náꞌ, Jesús Xa' Nazaret? ¿Cho ndea sa lu'x la náꞌ? Mnen cho nak la, lu nak Xaꞌ Nayon chan' Dios. ");
INSERT INTO ztp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús mbres lo mbi narax, nchab Xaꞌ: —¡Btowꞌ roa nde broꞌte lazoꞌ mbiꞌ reꞌ! ");
INSERT INTO ztp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Le' mbi naraxa, mdinkey mbiꞌ ya nde ne mbrezyaja mbroꞌtey lazoꞌ mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nde reta men nzi tya nzoyen toz xaꞌ, nya'bdi's xa' lo ta xa' nchab xaꞌ: —¿Cho kwan jwanꞌ reꞌ? ¿Cho yalte'd kub naka, sa kon yalnyebeꞌ ni Xaꞌ lo re mbi narax nde nxobyeka xkiꞌs Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nde jwanꞌ toz mxyo'b xkiꞌs Jesús dib lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Senꞌ mbroꞌ xaꞌ lenꞌ yo tenꞌ ndyop men Israel, Jesús kon Jakob nde Juan ngwa xaꞌ liz Simón nde liz Ndres. ");
INSERT INTO ztp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Leꞌ xnaꞌsap Simón naxno xlye, nde zyaga nchab re mena lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zyasa mbike Jesús gax, mxen Jesús yaꞌ xaꞌ nde mbliche Jesús xaꞌ; nde zyaga mbyib xlye lo xaꞌ, nde leꞌ xaꞌ mdaꞌ jwan' mda re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Senꞌ ngwadla wiz, lo ndakowla izyo, mbyeꞌdno xaꞌ reta men nayiz lo Jesús nde re men jwanꞌ nzo mbi narax. ");
INSERT INTO ztp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Reta men nzo yez ya mdyop xaꞌ xis yala tenꞌ nzo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nde bro toz men mtodanꞌ Jesús choja re yiz jwanꞌ ndyak men nde taja mbloꞌche Xaꞌ re mbi narax jwanꞌ nzo lazoꞌ men. Per na'nda'd Jesús diꞌs ni re mbi narax, tak nzoloy Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tilꞌ toz tata benꞌ nakow nya ngoche Jesús nde nda xaꞌ tij, ti plo tenꞌ nagan nde tya mdodiꞌsno Xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Leꞌ Simón nde kon tipla xaꞌ ngwa kwanꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nde senꞌ mzyal xaꞌ Jesús, nchab xaꞌ: —¡Reta men nkwanꞌ xaꞌ lu! ");
INSERT INTO ztp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Leꞌ Jesús nchab: Ndanꞌ re yez jwanꞌ nzi gax ncheꞌ ndatej na' xkiꞌs Dios lo re men; tak jwanꞌ naga ndal na. ");
INSERT INTO ztp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nde ngwa Jesús reta ten' nzi re yo ndyop re men Israel jwanꞌ nak lo xyon Galilea, ngwa tej Xaꞌ xkiꞌs Dios nde mbloꞌche Xaꞌ re mbi narax. ");
INSERT INTO ztp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mbye'd ti xaꞌ lo Jesús, xa' ndyak yis tin ndole lepra anta ndoye belꞌ xaꞌ, mdoxub xaꞌ nde mnab xaꞌ lo Jesús, nchab xaꞌ: —Tezka ncholaꞌs la, toyal todan' la na lo yis re'. ");
INSERT INTO ztp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nden mblat lazoꞌ Jesús mbiꞌ ya, mxob yaꞌ Jesus yek xaꞌ, nde nchab Jesus lo xaꞌ: —Toyala, yan' nambia naya. ");
INSERT INTO ztp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nde senꞌ lo ta nchab Jesús lo xaꞌ, zyaga mbyi'b yiz dib xaꞌ nde mbi xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Zyaza mbloned Jesús xa' nde mna'b toz Jesús lo xaꞌ, nchab Jesús: ");
INSERT INTO ztp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nek tib lo men na'tejta lu jwanꞌ reꞌ, jwanꞌ ndablo lia, wa lo nglweyꞌ sa wiꞌ xaꞌ lu nde beꞌ maꞌ yon jwanꞌ nyebeꞌ Moisés, sa nye re men ke mbyak la lo yiz. ");
INSERT INTO ztp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per senꞌ lo ndyala xaꞌ, tolo mdej toz xa' lo re men, mxo'b xa' di's jwan' mbli Jesús lo xa', jwanꞌna mbli sa na'ngakta ngete Jesús lenꞌ yez, be'nta tij re ro yez mbyan' Jesús, nde reta lad ndryo' re men nzin xa' lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mbrid pla wiz, Jesús mbla len' yez Capernaum tedi gob; nde mbin re men Jesús nzo yo. ");
INSERT INTO ztp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Zyaga men toz tir mdyop, na'galtra' ten' kwe men nekla ro yo na'galtra; le' Jesús ndotej xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Zyasa mzin pla xaꞌ lo Jesús ndeno ti men nayiz naꞌakta tye, nde thap xa' ne' men yisa. ");
INSERT INTO ztp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nde lo ta bro toz men nziy, na'ndlid xaꞌ gan mbike xaꞌ lo Jesús, mched xaꞌ yek yo nde mbla xaꞌ men yiza kon dib ya lonꞌ xaꞌ ten' ndo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Senꞌ mbwiꞌ Jesús ndlipa lazoꞌ xaꞌ Jesús, nchab Jesús lo xa' yiza: —Xinꞌ na, mdyonꞌla reta xken la. ");
INSERT INTO ztp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tya ndob pla xa' nak maestr nte'd ley xkiꞌs Dios, mbli xaꞌ xgab lenꞌ lazoꞌ xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Kwan sa ta mbez Xaꞌ? Ni xin Xa' xis Dios. ¿Cho men ligan tonꞌ xken ta men, Benꞌta Dios ndli gan?” ");
INSERT INTO ztp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nde zyaga mne Jesús xgab jwanꞌ ndono re xa' ya lenꞌ lazoꞌ xaꞌ, nde nchab Jesús lo xaꞌ: —¿Cho kwan liy ta nya xgab ndli goꞌ lenꞌ lazoꞌ goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cho di's mas nambi, gab na lo xa' yiz reꞌ: “Re xken la mdyonꞌla,” o gab na: “Ptoli, bxen lonꞌ la nde pte?” ");
INSERT INTO ztp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Naya loꞌn lo goꞌ, leꞌ Xinꞌ Mbi' ngeno yalnyebeꞌ dib lo izyo sa tonꞌ Xaꞌ xken re men. Zyasa nchab Jesús lo xa' ta nayiza: ");
INSERT INTO ztp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Na ni loa, ptoli, bxen lonꞌ la nde bya liz la. ");
INSERT INTO ztp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zyaga mtoli xaꞌ yiza, mxen xaꞌ lonꞌ xaꞌ mbro'te xa' xij reta men, jwan' nasa nzoyen toz reta men, nde mni xaꞌ diꞌs wen lo Dios, nchab xaꞌ: —¡Tera winꞌ ti jwanꞌ ta mbwinꞌ naya! ");
INSERT INTO ztp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngolo jwanꞌ reꞌ Jesús nda ro nittoꞌ tedib gob. Nde reta men nda lo Xaꞌ, nde mtote'd Xa' men. ");
INSERT INTO ztp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nde lo ndarid Jesús, mbwiꞌ Xaꞌ Leviꞌ xinꞌ Alfeo, ndob xa' ten' nthop xaꞌ tmi low jwanꞌ nchax lo izyo, nde nchab Jesús lo xaꞌ: —Btoke xis na. Zyaga mdoli xaꞌ nde mdoke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Senꞌ nax Jesús ro mes kon re xinꞌ teꞌd Xaꞌ liz Leví, bro re xaꞌ jwanꞌ nthop tmi chanꞌ izyo nde re xaꞌ jwanꞌ nzo'b xken' thita nzi re xaꞌ ro mes kon Jesús nde re xin' te'd Jesus, tak bro toz men jwan' ndyonke xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nde re xaꞌ nak maestr ndlo' ley xkiꞌs Dios nde re xaꞌ nak fariseo, lo mbwiꞌ xaꞌ nax ya Jesús kon re men nthop tmi chan' izyo nde kon re men nzo'b xken', nchab xaꞌ lo re xinꞌ teꞌd Jesús: —¿Cho kwan nak jwanꞌ reꞌ, kwan sa ncha Xaꞌ kon re men nthop tmi nde kon re men nzo'b xken naꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Senꞌ l o mbin Jesús jwanꞌ reꞌ, Jesús nchab lo xaꞌ: —Re men nadanꞌ nanakiꞌnta xaꞌ men todanꞌ xaꞌ, che'la re men nayiza. Na'ndalta na sa bez na re men galꞌ, na ndal par re men nzo'b xken naꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nde re xaꞌ nak xinꞌ teꞌd Juan nde re xaꞌ fariseo ndli xaꞌ yalse; nde mbyeꞌd pla men lo Jesús, nchab xaꞌ: —¿Cho kwan liy sa re xinꞌ teꞌd Juan nde re xa' fariseo ndli xaꞌ yalse nde re xinꞌ teꞌd la na'ndlid xaꞌ yalse? ");
INSERT INTO ztp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús nchab lo xaꞌ: —¿Cho toyal re men jwan' nzi lo yalselya' li xa' yalse laj leꞌ mbyo selyaꞌ ndo kon xa'? Laj benꞌ ndo mbyo selya'ya kon xa', na'toyalta li xa' yalse. ");
INSERT INTO ztp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per tsin wiz senꞌ mbyo mselyaꞌya naꞌngentra', zyasa li xaꞌ yalse. ");
INSERT INTO ztp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ngen cho men nkibde tib ble lar kub lad lar gox; tak lar kub mbey nde cheda lar gox, zyasa masraꞌ cheda. ");
INSERT INTO ztp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nde taga', ngenta cho men ngo nit ub kub lenꞌ ti ye gox jwanꞌ naksaꞌ yid maꞌ; tak nit ub kub ncheda ye gox nde xyoy nde leꞌ ye ya yaja ngosaꞌy; Jwanꞌ nasa leꞌ nit ub kub ndablo yoy lenꞌ ti ye kub. ");
INSERT INTO ztp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ti wiz jwanꞌ ndryoxkwen men, Jesús kon re xinꞌ teꞌd xaꞌ ndarid xa' plo tenꞌ ndo trig, nde re xinꞌ teꞌd Jesús tolo mthop xaꞌ trig. ");
INSERT INTO ztp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Zyasa pla xaꞌ fariseo nchab xaꞌ lo Jesús: —Bwiꞌ, ¿Cho kwan liy re xinꞌ teꞌd la ngeli xaꞌ jwanꞌ nandabloda li xa' naya lenꞌ wiz ndryoxkwen men? ");
INSERT INTO ztp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Per Jesús mkab lo xaꞌ: —¿Cho tera' lab goꞌ jwanꞌ mbli David senꞌ lo mkeno xaꞌ yalti nde msi'b ndyanꞌ xaꞌ kon re men jwanꞌ nzino xaꞌ tya? ");
INSERT INTO ztp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David ngote xaꞌ lenꞌ liz Dios nde mda xaꞌ pan nayon nzi tya, pan jwanꞌ benꞌta re xaꞌ nak nglweyꞌ ro toyal way; nde noga mdaꞌ Davida mda re xaꞌ jwanꞌ ngete kon xaꞌ. lin' jwan' Abiatar nak mbol ngwleyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Noga nchab Jesús lo xaꞌ: —Par yalwen lo men mbyanꞌ wiz ndryoxkwen men nde nambyanꞌta wiz reꞌ par nye men yalti. ");
INSERT INTO ztp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jwanꞌ nasa, le' Xinꞌ Mbiꞌ nak Xa' men Nyebeꞌ len' wiz jwan' ndryoxkwen men. ");
INSERT INTO ztp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngote Jesús tedib gob lenꞌ yo tenꞌ ndyop men Israel, nde tya ndo ti mbi' mbis yaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nde ndola's pla xaꞌ sa nyenꞌ cho todanꞌ Jesús men yiza lenꞌ wiz ndryoxkwen men, sa zyal xaꞌ yalke keꞌ xaꞌ yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zyasa nchab Jesús lo mbi' mbis yanꞌ ya: —Ptoli nde pto xtowꞌ re men reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nde nchab Jesús lo re xaꞌ nzi tya: — ¿Cho yalke naka tez len' wiz jwanꞌ ndryoxkwen men li men jwanꞌ wen o jwan' narax, tola' men yalnaban chan' ti men, o kuj men xa'? Per nek tib xaꞌ nankabta. ");
INSERT INTO ztp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Zyasa mbwiꞌ nayiꞌ Jesús lo reta men nzi tya nde ngo nabil lazoꞌ Jesús lo taja ne lazoꞌ re men, nchab Jesús lo mbi' nayiza: —Btogaꞌ yaꞌa. Nde mtogaꞌ xaꞌ yaꞌ xaꞌ, taxa nawe mbyanꞌna nde mbyaka. ");
INSERT INTO ztp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Leꞌ re xaꞌ fariseo mbro'te ndya xaꞌ nde mdyop xaꞌ kon re men Herodes sa mdodiꞌs xaꞌ par zyal xaꞌ mod gaj Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Leꞌ Jesús nda ro nittoꞌ kon re xinꞌ teꞌd Xaꞌ nde bro toz men mdoke xis Jesús, xaꞌ nzi lo xyon Galilea. Nde re men Judea, ");
INSERT INTO ztp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","men yez Jerusalén, men nzi lo xyon Idumea, men nzi tib lad ro yoꞌ Jordán nde re men jwanꞌ nzo re yez nzi lo xyon Tiro nde Sidón, senꞌ mbin re men naro toz nak re jwanꞌ ndli Jesús, bro toz tir men mbyeꞌd lo Xa'. ");
INSERT INTO ztp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nde nchab Jesús lo re xinꞌ teꞌd Xaꞌ, ndablo thibla' tobsaꞌ xaꞌ ti bark yap Jesús, lo ta bro toz tir men ndyop, sa naga'sta men Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tak bro toz men mtodan' Jesús, jwanꞌ nasa reta men nayiz ncholaꞌs xaꞌ gal xaꞌ lad Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nde re mbi narax, lo ngwiꞌ xaꞌ Jesús, ndyoxub xaꞌ lo ni Jesús nde ne mbez xaꞌ, nchab xa': —Lu nak Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per mbrez toz Jesús lo re mbi narax sa na'koxo'bta xa' cho nak Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ngolo jwanꞌ na, Jesús ngwap yek ti yiꞌ, nde mbrez Xaꞌ men jwanꞌ nchola's Xaꞌ; nde ngwa re xa' lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nde mblí Jesús tib sen xa', sa re xa' ya tyeno Jesús nde telꞌ Jesús xaꞌ yatej xaꞌ xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nde keno xaꞌ yalnyebeꞌ todanꞌ xaꞌ re men yiz nde kote xaꞌ re mbi narax nzo lazoꞌ men. ");
INSERT INTO ztp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Re tib sen xaꞌ ya jwan' reꞌ: Simón (xaꞌ mblole Jesús Pey), ");
INSERT INTO ztp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakob kon Juan (rop wes xaꞌ reꞌ nak xinꞌ Zebedeo, rop xaꞌ reꞌ mblole Jesús, Boanerg, diꞌs reꞌ nak: “Xinꞌ mdiꞌ”); ");
INSERT INTO ztp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ti pla xaꞌ nak: Ndres, Blib, Bartol, Mateo, Max, Jakob (xinꞌ Alfeo), Tadeo, Simón xaꞌ Kananeo, ");
INSERT INTO ztp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nde Judas Iscariot (xaꞌ jwanꞌ tayaꞌ Jesús lo men sa kuj xaꞌ Jesús). Ngolo mne jwanꞌ reꞌ, zyasa ndya re xaꞌ yo. ");
INSERT INTO ztp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nde taxa mdyop bro toz men tya tedi gob, nayenta wa Jesús neka re xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Senꞌ mbin re xaꞌ liz Jesús jwanꞌ reꞌ, mbye'd xa' nde mbrez xaꞌ yek Jesús, tak nchab xaꞌ: —Ndoyosaꞌ yek mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Noga mzin pla maestr ndlo' ley xkiꞌs Dios, xa' mbroꞌ yez Jerusalén nchab xaꞌ, ke Jesús ndono Maxuꞌ ndole Beelzebuꞌ jwanꞌ nyebeꞌ lo re mbi narax nde por xaꞌ ya sa ndli Jesús gan ndryo'che re mbi narax nzo lazoꞌ men. ");
INSERT INTO ztp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nde sen' mbrez Jesús re men ya mdej Jesús ti kwent nabix lo xaꞌ, nchab Jesús: —¿Xamod kote Maxuꞌ le'ga le' Maxuꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tez ti yez ak rol xaꞌ nde yo xaꞌ kon le'ga re ta xaꞌ, naxekta xaꞌ, tlux xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nde tez ti liz men ak rol xaꞌ nde yo xaꞌ, re xaꞌ nzo yo ya naxekta xaꞌ bro. ");
INSERT INTO ztp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nde taga, tez Maxuꞌ ak rol xaꞌ nde yo xaꞌ kon le'ga ta xaꞌ, naxekta xaꞌ, tlux xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ngen cho xaꞌ ligan lya liz ti mbiꞌ ne toz, sa we wanꞌ xaꞌ re chanꞌ mbiꞌ, nerla ndablo tobo xaꞌ mbiꞌ, zyara' li xaꞌ gan we xaꞌ re chanꞌ mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Nipa na lo goꞌ, Dios ton' re yalke jwanꞌ ndli men nde choja re diꞌs xin jwanꞌ ni men. ");
INSERT INTO ztp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per choja men jwanꞌ ni xin xis Mbi Nayon, nek lud natonꞌta Dios xken xaꞌ, nchanꞌ no xaꞌ yalken xaꞌ tiptane. ");
INSERT INTO ztp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jwanꞌ reꞌ nchab Jesús lo xaꞌ, tak leꞌ xaꞌ nchab ke Jesús ndono mbi narax. ");
INSERT INTO ztp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Xisa zyara' mzin xnaꞌ Jesús kon re wes xaꞌ, nzi xaꞌ le, mbloned xaꞌ tib men sa yachez xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nde re men jwanꞌ nzi ndob cho Jesús tya, nchab xa' lo Jesús: —Xnaꞌa nde re wes la nzi le, ndekwanꞌ xaꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús mkab lo xa': —¿Cho nak xnaꞌn nde re wes na, ndyak goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nde mbwiꞌ Jesús lo re men jwanꞌ nzindob dib cho Jesus, nchab Xa': —Bwiꞌ goꞌ, le'ga goꞌ nak xnaꞌn nde wes na. ");
INSERT INTO ztp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tak re men ndli jwanꞌ ncholaꞌs Dios, xaꞌ ya nak wes na, btanꞌ na nde xnaꞌn. ");
INSERT INTO ztp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tedib gob mdobte Jesús mtoteꞌd Xaꞌ re men ro nittoꞌ nde bro toz men mdyop lo Xaꞌ, yaja ngwap Jesús lo ti bark jwanꞌ nzo'b lo nit nde tya mdob Xaꞌ, leꞌ reta men nzi ro yux. ");
INSERT INTO ztp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nde kon di's nabix mblo' Xa' lo re men na'r toz jwan', nde mblo' Xa' lo men jwan' xa naka yalte'd chan' Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Pto nza go': Ngo ti mbi mbroꞌ ndalo bin mbis. ");
INSERT INTO ztp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nde senꞌ ndogo xaꞌ bin, nzo mbis ngob ro ned, zyasa mbyeꞌd mbyin nde mda mbyina. ");
INSERT INTO ztp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tipla mbis ngob xij ke tenꞌ ngenta bro yo jwanꞌ nasa naban toz mblyena, ");
INSERT INTO ztp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","per senꞌ lo mbla toz be, mbolꞌ la tak nangenta loxa nde mbiza. ");
INSERT INTO ztp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tipla mbis ngob xij yis; nde mas mxyen yis, mtowꞌ yis yek neꞌy nde tamod sa nandopta lo neꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Leꞌ tipla mbis jwanꞌ ngob lo yobeꞌb, mblyena, mxyen na nde nawe mdob lo neꞌy, choy mdaꞌ galbsiꞌ mbis axta songal mbis nde nzoy mdaꞌ axta tib ayoꞌ mbis kad tiba. ");
INSERT INTO ztp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zyasa nchab Jesús lo xaꞌ: —¡Goꞌ jwanꞌ ndob nzanꞌ par gona, bin goꞌy! ");
INSERT INTO ztp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Senꞌ mbyanꞌ thipta Jesús, re xaꞌ jwanꞌ ngete nke xis Jesús nde kon re tib sen xinꞌ teꞌd Jesús, mnabdiꞌs xaꞌ lo Jesús nyenꞌ xamod nak di's nabix jwanꞌ ta mdej Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nde nchab Jesus lo xa': —Lo goꞌ ngoxkan Dios re diꞌs naga's jwanꞌ nak yalnyebeꞌ chanꞌ Dios; le' lo re men jwanꞌ ngete xisa, nab di's nabix tej men re jwanꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Sa te'nye ngwiꞌ xaꞌ per nawiꞌd xaꞌy, tenye nchon xaꞌ per na'yenta xaꞌy; sa na'syed xgab xaꞌ lo Dios nde natonꞌta Dios xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nde nchab Jesús lo xaꞌ: —¿Cho naꞌyenta goꞌ di's nabix reꞌ? ¿Xomodka yen goꞌ masra' re di's nabix sa? ");
INSERT INTO ztp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Xaꞌ jwanꞌ ngobin mbis, xa' ya nak xaꞌ ngobin xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nde re men jwan' nak xaja mbis nzo bin ro ned: nzobin xki's Dios lazo' xa', per sen' mne mbin xa'y, zyaga nde Maxuꞌ, nde nkib Maxuꞌ xkiꞌs Dios jwan' nzobin lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Taga' re men jwan' nak xaja mbis nzobin xij ke: re xa' re' sen' nchon xaꞌ xkiꞌs Dios, zyaga nale toz ncho lazoꞌ xaꞌ nkayaꞌ xa'y, ");
INSERT INTO ztp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per na'ngenta lox xkiꞌs Dios lazoꞌ xaꞌ, nak xaꞌ men plata wiz, tak senꞌ nde yalti lo xaꞌ o nchubla men xaꞌ xke chanꞌ xkiꞌs Dios, zyaga ndlaꞌ xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Re xa' re' nak xaja mbis jwan ngobin xij yis. Men ya, nchon xaꞌ xkiꞌs Dios, ");
INSERT INTO ztp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per ndyen toz xa' re jwanꞌ lo izyo nde ntokil'la xa' ak rik xa' nde ndyablaꞌs xaꞌ masra' jwanꞌ, reta jwanꞌ reꞌ ndyay lazoꞌ xaꞌ nde ntolu'xa xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Le' re men jwan' nak xaja mbis ngobin lo yo beꞌb: re xa' re' nchon xaꞌ xkiꞌs Dios nde ndli lazo' xaꞌy, nak xaꞌ xaja mbis bin jwanꞌ nawe ndob lonꞌ nde bro toz jwanꞌ ndaꞌy, choy ndaꞌ galbsiꞌ mbis, axta songal mbis nde axta por ayoꞌ mbis ndaꞌ kad thiba. ");
INSERT INTO ztp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Noga nchab Jesús: —¿Cho ndeno men xni sa towꞌ xaꞌ yek na'y kon ti xi beꞌ o ko xaꞌy xanꞌ lonꞌ? ¿Cho nanakta tob xaꞌy gap sa taꞌy xni? ");
INSERT INTO ztp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tak ngenta jwanꞌ nzo naga's na'ryoxo'bta, nek jwanꞌ nzo kaꞌslo, na'ryoxo'bta lo xni. ");
INSERT INTO ztp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Tez nzo goꞌ ndob nzanꞌ par gon goꞌy, bin goꞌy! ");
INSERT INTO ztp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nde noga nchab Jesús: —Jwin bwi' go' jwan' mbin go'; tak xa nchix goꞌ nka men, taga' chi'x xa' ka goꞌ nde masra'y kayaꞌ goꞌ jwan' xa mbin go'. ");
INSERT INTO ztp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tak men ngenolay, kayaꞌ xa' masra'y; Nde men nangenoday, axta jwanꞌ lud ngeno xaꞌ yi'ba lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Noga nchab Jesús: —Che' nak yalnyebeꞌ chanꞌ Dios, xa nak ti mbi' jwan' ngwalo bin mbis xis izyo, ");
INSERT INTO ztp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","nchat xaꞌ nde nchoche xa', yal' nde ndlyabe, leꞌ mbis nchas, nde ndoxena ana'nye xaꞌ xa ndoyaka. ");
INSERT INTO ztp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tak le'ga izyo ndli sa ndlyena, nerla ndryo'xoba nde nxyena, senꞌ lo mne mxyena zya ndryoꞌ do lo neꞌy, nde lo do sey ndryo'xob mbis. ");
INSERT INTO ztp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nde senꞌ ngol mbis, zyaga nthop xaꞌy, tak ngoxo'b be'y. ");
INSERT INTO ztp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Noga nchab Jesús: —¿Cho jwanꞌ thita nya kon yalnyebeꞌ chanꞌ Dios, o cho ti di's nabix thita lilal na'y? ");
INSERT INTO ztp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naka xa nak mbis mostaz, tak sen' li bin mena xis izyo, naka mbis mas bix lo reta mbis nzo xis izyo. ");
INSERT INTO ztp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per senꞌ ngo bin lay, nxyena, nde mas naroy lo reta ya bin nde nol' toz xoda, jwan' nasa re mbyin ntoyal ncho ma' xan' xkal na'y. ");
INSERT INTO ztp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na'r toz re di's nabix reꞌ ndloꞌ Jesús xkiꞌs Dios lo men, axaja nchen mena. ");
INSERT INTO ztp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nde napta di's nabix mdodiꞌs Jesús lo re men; benꞌ lo re xinꞌ teꞌd Xaꞌ ngoxkan Xaꞌ retay. ");
INSERT INTO ztp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Le'ga wiz ya, senꞌ ndolala yalꞌ, Jesús nchab lo re xinꞌ teꞌd Xaꞌ: —Ndanꞌ tedib lad ro nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nde mcha's xaꞌ reta men nzi tya, yaja mxen xa' bark, le' Jesús nzola lo bark nde xisa mdonke tipla bark jwanꞌ nzi tya. ");
INSERT INTO ztp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Per mxyo'b mbi toz lo nit, nde axta lenꞌ bark nchoche bde, ndosey nzo nit. ");
INSERT INTO ztp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Leꞌ Jesús naxyat xanꞌ bark, xis ti almwad; nde mbloꞌxkalꞌ xaꞌ Jesús, nchab xaꞌ: —Maestr, ¿Cho na'ndlid la xgab ta ndolan' lenꞌ nit? ");
INSERT INTO ztp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nde ngoche Jesús, mbrez Xaꞌ lo mbi nde nchab Xaꞌ lo bde: —¡Te'zta go'! ¡Xe bre goꞌ! Nde gotab mbi nde retay xe mbrey. ");
INSERT INTO ztp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nde nchab Jesús lo xaꞌ: —¿Cho kwan liy mzyeb toz goꞌ? ¿Cho na'ndlid lazoꞌ goꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Zyasa mzeb toz lazo' xaꞌ, nde nchab xaꞌ lo ta xaꞌ: —¿Cho Xaꞌ reꞌ, sa axta mbi nde nittoꞌ nxo'byeka Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mzin xaꞌ tedib lad ro nittoꞌ, tenꞌ nak lo xyon Gadara. ");
INSERT INTO ztp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nde sen' mbla Jesús lo bark, zyaga mbro'to ti mbiꞌ lo Jesús, mbi' jwan' mbroꞌ xij re baꞌ nde nzo mbi narax lazo' xa'. ");
INSERT INTO ztp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tenꞌ nzi re baꞌ tya nak liz xaꞌ nde nek thib men na'lida gan go men xa', nekla kon kaden . ");
INSERT INTO ztp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tak nar toz gob mbo men xaꞌ kon yi'b nde kaden, per nya kaden ncho' xa', nde nchix xa' yi'b; ngen cho men li gan tobo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nde reta yalꞌ nde ndlyabe ngete xaꞌ mbez xa' re lenꞌ wan nde xij re ba', ntowiyꞌ xaꞌ lad xaꞌ kon ke. ");
INSERT INTO ztp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Senꞌ mbwiꞌ xaꞌ tijra' nde Jesús, mke xaꞌ karrel nde mdo xub xaꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nde mbrezyaj xaꞌ, nchab xaꞌ: —¿Cho kwan ndyaknoa na, Jesús, Xinꞌ Dios naro toz? Nya'b na loa, ndowiꞌ Dios, na'totid la na. ");
INSERT INTO ztp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tak Jesús nchab la: —Mbi narax, broꞌte lazoꞌ mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nde mnabdiꞌs Jesús lo xaꞌ: —¿Cho lea? Leꞌ xaꞌ mkab, nchab xa': —Na ndole Bro toz; Tak bro toz tir náꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nde mna'b toz xaꞌ lo Jesús sa natelꞌta Jesús xaꞌ, xaꞌga lo xyon men. ");
INSERT INTO ztp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gax yek yi' tya nzi bro toz nguch nzi ya. ");
INSERT INTO ztp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nde mna'b reta mbi naraxa lo Jesús, nchaba: —Btelꞌ náꞌ lo re nguch sa lya náꞌ lenꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nde zyaga mdaꞌ Jesús diꞌs. Nde mbro' reta mbi naraxa, mblay lenꞌ reta nguch, lo re nguch nzi ti chop mil maꞌ nde mbro'xon' maꞌ mbixnda'b maꞌ yek ke, nde mbla maꞌ lenꞌ nittoꞌ, ngwap maꞌ nit nde nguj re maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Leꞌ re xaꞌ jwanꞌ nkenap nguch mxonꞌ xaꞌ nde ngwa tej xaꞌy lo re men nzi yez nde ranch. Nde mbro' reta men ngwa twiꞌ xaꞌ jwanꞌ ngok. ");
INSERT INTO ztp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sen' mzin reta men lo Jesús, mbwiꞌ xaꞌ mbiꞌ ta ngo bro toz mbi naraxa, xe ndob xaꞌ, nok xab xaꞌ nde mbi yek xaꞌ; nde mzyeb reta men. ");
INSERT INTO ztp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Leꞌ re men jwanꞌ mbwiꞌ mtodanꞌ Jesús mbiꞌ ya, mdej xa' lo re men xa ngotey kon mbiꞌ ta ngo mbi naraxa nde kwan ngotey kon re nguch. ");
INSERT INTO ztp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nde mdobte mna'b xaꞌ lo Jesús sa ryoꞌte Jesús lo xyon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Laj ndoyap Jesús lo bark, leꞌ mbiꞌ ta ngo mbi naraxa, mna'b toz xaꞌ lo Jesús sa tyonke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per na'nkapta Jesús diꞌs, che'la nchab Jesús lo xaꞌ: —Bya liz la, tenꞌ nzi re xaꞌ taa, ptej re yalnaro jwanꞌ mbli Dios loa nde xa mblat lazoꞌ Dios mbwiꞌ Xaꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zyasa ndya xaꞌ, nde dib lo xyon Decápolis mdobte mdej xa' plopa nak yalnaro jwanꞌ mbli Jesús lo xaꞌ; nde nzoyen re men mbin mena. ");
INSERT INTO ztp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Senꞌ mbere Jesús lo bark tedib lad ro nitto', men toz tir mdyop lo Jesús tya, yaja tyata mbyan' Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nde mbye'd ti xaꞌ ndole Jairo, xa' nyebeꞌ lenꞌ yo tenꞌ ndyop men Israel, senꞌ mbwiꞌ xaꞌ Jesús, mdo xub xaꞌ lo ni Jesús, ");
INSERT INTO ztp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nde mna'b toz xaꞌ, nchab xaꞌ: —Mzaꞌ xinꞌ na naxyajla or; deꞌ sa xo'b la yaꞌa yek or, sa dyanꞌ or nde nagajta or. ");
INSERT INTO ztp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zyasa nda Jesús kon Jaíro; nde bro toz men mdonke xis Xaꞌ, anta ngaꞌz men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Xija nzo ti ngol ndala tibsen linꞌ thiblaꞌ nge ren xa'. ");
INSERT INTO ztp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nde jwanꞌ tozla mbri'd xa' re yalti mkete xaꞌ lo re xa' ntoda'n men, nde mbre re tmin xaꞌ mbri'd xa' nde tatka nayiz xa', cheꞌla ndoro yiz lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Senꞌ mbin ngol re jwan' ndyodiꞌs men ndli Jesús, mbike ngol gax xis Jesús, nde mbwal ngol xab Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tak xgab ngol nak: “Masa gal ngol xab Jesús, sa dyanꞌ ngol.” ");
INSERT INTO ztp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nde zyaga ngota'b yiz ren lo ngol, mdenꞌ xaꞌ mbyak xaꞌ nde mblyaꞌ xaꞌ lo yiz. ");
INSERT INTO ztp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Zyaga mdenꞌ Jesús yalne chanꞌ Xaꞌ mbli mdyanꞌ ti men nde mbwiꞌ Xaꞌ lo re men, nchab Xaꞌ: —¿Cho mbwal lad xab na? ");
INSERT INTO ztp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Re xinꞌ teꞌd Xaꞌ nchab: —Bwiꞌ, jwanꞌ toz ngaꞌz men lu nde mbez la: “¿Cho mbwal lad xab na?” ");
INSERT INTO ztp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per Jesús, tatka ngwiꞌ Xaꞌ lo re men jwanꞌ nzi dib tenꞌ ndo Xaꞌ, nyenꞌ cho mbwal lad xab Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Zyasa leꞌ ngol ya, mzyeb toz xaꞌ nde nxid xaꞌ, tak mne xaꞌ jwanꞌ ngok lo xa', mbike xaꞌ gax lo Jesús nde mdo xub xaꞌ lo Jesús, nde mdej xaꞌ jwan' xa nakpe'y. ");
INSERT INTO ztp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Leꞌ Jesús nchab lo ngol: —Xinꞌ na, lo ta ndlipa lazoꞌa na, jwanꞌna mbli mblyaꞌa; nabeꞌz bya, tak mbyak la lo yiz jwanꞌ mxak la. ");
INSERT INTO ztp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Laj benꞌ ndotodiꞌs Jesús, mzin pla xaꞌ jwanꞌ mbroꞌ liz Jairo, nchab xaꞌ lo Jairo: —Ngujla mzaꞌ xinꞌ la; na'todotra' la lo maestr. ");
INSERT INTO ztp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Leꞌ Jesús, zyaga mbin Xaꞌ jwanꞌ nzi bez men tya, nchab Jesús lo Jaíro: —Nazyebta lu, benꞌta bli lazoꞌa na. ");
INSERT INTO ztp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nde naꞌndad Jesús diꞌs ndonke xaꞌga men xis Xaꞌ, benꞌta Pedr, Jakob nde Juan wes Jakob mdonke. ");
INSERT INTO ztp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nde lo mzin xaꞌ liz Jaíro, mbwiꞌ Jesús anta chepa nziyak re men, re xa' jwan' nzi yonꞌ nde re xa' jwan' mbez nabil. ");
INSERT INTO ztp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Leꞌ Jesús ngote lenꞌ yo nde nchab Xaꞌ: —¿Cho kwan liy taja nziyak goꞌ nde nziyon' goꞌ? Na'ngujta mzaꞌ, benꞌ naxyat mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nde re men mxino xaꞌ Jesús. Le' Jesús, mbloꞌte xaꞌ reta men le, ben' xud mzaꞌ nde xnaꞌ mzaꞌ nde kon re yon xinꞌ teꞌd Jesús ngote tenꞌ nax mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nde mxen Jesús yaꞌ mzaꞌ, nchab Jesús lo mza': —Talita kumi —diꞌs reꞌ nak: ¡Mzaꞌ lud, na ni loa, gocheꞌ! ");
INSERT INTO ztp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nde zyaga ngoche mzaꞌ nde mde mzaꞌ, ben' tibsen lin' nzor. Nde jwan' toz nzoyen re men. ");
INSERT INTO ztp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Per mna'b toz Jesús lo re xa', sa nekthib lo men na'gapta xa'y, nde nchab Jesús lo xa', taꞌ xaꞌ jwanꞌ wa mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mbroꞌ Jesús tya nde ndya Xaꞌ yez Nazaret tenꞌ nak laz Xaꞌ, kon re xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Senꞌ mzin wiz jwanꞌ ndryoxkwen men, Jesús mdobte mbloꞌ xkiꞌs Dios len' yo tenꞌ ndyop men Israel; bro toz men, mbin xa'y, nde nzoyen xaꞌ, nchab xaꞌ: —¿Plo ngwa teꞌd Xaꞌ re jwan' reꞌ? ¿Nde plo ngwa xiꞌ Xaꞌ yalnchak nde re yalnaro jwanꞌ ndli Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Cho na'nakta Xaꞌ reꞌ ta ntoxkwaꞌ re ya? Xnaꞌ Xaꞌ nak Marí nde wes Xaꞌ nak Jakob, José, Judas nde Simón? ¿Cho na'noda re men nak ptanꞌ Xaꞌ nche' nzo xaꞌ? Nde ntola mbre xaꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Leꞌ Jesús nchab lo xa': —Reta lad nxo'byek men ti profet, per plo tenꞌ nak laz xaꞌ, na'nxo'byekta men xaꞌ, nek re men ta xaꞌ nde neka men liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nde nek thib yalnaro na'ndlid Jesús tya, benꞌta pla men nayiz mxo'b yaꞌ Jesús yek xaꞌ nde mbyak men. ");
INSERT INTO ztp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nde nzoyen toz Jesús lo na'ndlid lazoꞌ men Xaꞌ. Nde mkete Jesús re yez bix jwanꞌ nzi dib gax tya, mblo' Xa' xki's Dios. ");
INSERT INTO ztp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngolo jwanꞌna, mbrez Jesús re tib sen xinꞌ teꞌd Xaꞌ nde mdaꞌ Jesús yalnyebeꞌ lo xaꞌ sa kote xaꞌ re mbi narax nzo lazoꞌ men nde mbloned Jesús chop chopa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nde mnabe' Jesus na'wed xa' nek thib jwan' par ned, benꞌta ti yaga jwanꞌ nata we xa'. Na'wed xaꞌ yex, nek jwanꞌ wa xaꞌ, nek tmi, ");
INSERT INTO ztp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ben' yalyid ke ni xa' nde benꞌ lar nokta xaꞌ we xa'. ");
INSERT INTO ztp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Noga nchab Jesus lo xa': Oneja cho liz men sin goꞌ, tya byanꞌ goꞌ axta kebeꞌ ryoꞌ goꞌ yez ya. ");
INSERT INTO ztp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nde tez nzo ten' na'kabta xaꞌ lo goꞌ nde na'tonzad xaꞌ jwan' tej goꞌ, broꞌte goꞌ tya nde bsib goꞌ yothiꞌ ni goꞌ, sa lo' ke namkaya'd xa' go'. Nipa na lo goꞌ senꞌ sin wiz jwanꞌ nya'b Dios kwent lo reta men, mas bro pen nye re men yez ta na'mkaya'd xa' goꞌ, ke re men yez Sodoma nde Gomorra. ");
INSERT INTO ztp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nde mbro' re xaꞌ, nda tej xaꞌ lo re men, laꞌ men re jwanꞌ narax nak men nde bere men lo Dios. ");
INSERT INTO ztp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nde bro toz re mbi narax mblo'te xa' lazoꞌ men nde bro toz re men nayiz mdaꞌb xaꞌ aceit yek men nde mbyak men. ");
INSERT INTO ztp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dib nax mxyo'b xkiꞌs Jesús, re jwanꞌ wen ndli Xaꞌ, axta rey Herodes xaꞌ nyebeꞌ lo xyon Galilea, mbin xaꞌy nde nchab xaꞌ: —Juan ngole men mbro'xban xij re xa' nguj, xaꞌ ya ta nak Jesús, jwanꞌ nasa nchak ndli xaꞌ reta yalnaro. ");
INSERT INTO ztp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tipla men nchab: —Elías nak Xa ya. Nde tipla men nchab: —Ti profeta, o ti profet ta ngo polay. ");
INSERT INTO ztp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Senꞌ mbin Herodes ta mbez re men, Herodes nchab: —Xaꞌ ya nak Juan, xaꞌ ta mnabeꞌn mcho' yek naꞌ, nde naya mbroxban xaꞌ xij re men ngujla. ");
INSERT INTO ztp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tak le'ga Herodes jwan' mtelꞌ men sa mxen xa' Juan nde mkedoꞌ xaꞌ Juan lenꞌ liz yib kon kaden, xke chanꞌ Herodías ngol Blib, wes Herodes, tak Herodes ndobno ngol. ");
INSERT INTO ztp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tak Juan nchab lo Herodes: —Na'ndabloda tyob noa ngol wes la. ");
INSERT INTO ztp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jwanꞌ nasa mbyiꞌno toz Herodías Juan, ncholaꞌs ngol kuj ngol xaꞌ, per na'lid ngol gan, ");
INSERT INTO ztp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tak Herodes mzyeb xaꞌ Juan, mne xaꞌ ke Juan nak xa' ti mbi' gal' nde mbi' nayon, jwanꞌ nasa thibla' ndla Herodes Juan; tak lo nchon xa' jwan' ndej Juan na'nyed xaꞌ kwan li xaꞌ, per dib nzo lazo' xa' ndonza xa' Juan. ");
INSERT INTO ztp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per mzin ti wiz wen lo Herodías, wiz jwan' ngoxo'b linꞌ Herodes, zya mbli xa' ni, mda rzye' xaꞌ kon re ta nak sinꞌ xaꞌ, re xaꞌ jwanꞌ nyebeꞌ lo re sondad nde re xaꞌ jwanꞌ nak xaꞌ ro lo xyon Galilea, ");
INSERT INTO ztp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tya ngote mzaꞌ xinꞌ Herodías, tolo mkani mzaꞌ, nde mbroꞌ toz lazoꞌ Herodes nde kon re xaꞌ nzi ro mes xa nkani mzaꞌ, nde nchab Herodes lo mzaꞌ: —Mna'b jwanꞌ ncholaꞌs la lon, ta ney kaa. ");
INSERT INTO ztp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nde mke'ro xa', nchab xa': Reta jwanꞌ nya'b la lon taney kaa, axta rol yalnyebe' chan' na tan kaa. ");
INSERT INTO ztp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Zya mbroꞌte mzaꞌ nde nchab mzaꞌ lo xnaꞌ mzaꞌ: —¿Cho kwan nya'b na? Leꞌ xnaꞌ mzaꞌ nchab: —Mna'b yek Juan ta ngole men. ");
INSERT INTO ztp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Zyasa naban toz mbere mzaꞌ lo rey, nde nchab mzaꞌ: —Ncholas na, le'ga naya taꞌa ngud yek Juan kan, tyoba ti lo yen. ");
INSERT INTO ztp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Leꞌ Rey Herodes nabil toz ngo lazo' xaꞌ; per lo ta mke'ro xa' nzi wiꞌ re men jwanꞌ nzi ro mesa, jwanꞌ nasa naꞌnkabrod xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nde zyaga mbloned rey ti sondad, mnabe' xaꞌ cho ngud yek Juan nde yedno xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Leꞌ sondad ngwa xa', mcho' xa' ngud yek Juan len' liz yi'b, ndeno xaꞌy ndoba ti lo yen nde mdayaꞌ xaꞌy lo mzaꞌ, leꞌ mzaꞌ mdaꞌya'y lo xnaꞌ mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Senꞌ mbin re xinꞌ teꞌd Juan jwan'na, ngwaxiꞌ xaꞌ thobol nde mkaꞌs xaꞌ xaꞌ len' ba'. ");
INSERT INTO ztp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zyasa re xa' nak apost thita mdyop xa' kon Jesús, nde mdej xaꞌ lo Jesús reta jwanꞌ ngwa li xaꞌ nde re jwanꞌ ngwa loꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús nchab lo xa': —Yaꞌ goꞌ ndanꞌ ti tenꞌ naꞌngenta men, sa ryo'xkwen naꞌ lud. Tak bro toz men jwan' ndya nde men jwan' nzin, nekla ta' men di's wa re xa' ");
INSERT INTO ztp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nde leꞌta xaꞌ nda lo ti bark ti plo tenꞌ naꞌngenta men. ");
INSERT INTO ztp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per bro toz men mne nda re xa' nde mblibeꞌ men Jesús; bro toz men jwanꞌ nzo re yez gax nzi tya nda ni xaꞌ nde nerla xaꞌ mzin, mkata re xa' lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sen' mbla Jesús lo bark, mbwiꞌ Xaꞌ men toz nzila tya, nde mblat lazoꞌ Jesús mbwiꞌ Xa' lo re men ya, tak nak men xaja mbakxilꞌ jwanꞌ naꞌngenta xa' kenap, nde mdobte mtoteꞌd Jesús xaꞌ lo bro toz jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Senꞌ mzyela izyo, re xinꞌ teꞌd Jesús mbike xaꞌ gax nde nchab xaꞌ lo Jesús: —Bzye tozla nde naꞌngenta liz men ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pchaꞌs reta men, sa ya ka xaꞌ jwanꞌ wa xaꞌ re yez jwanꞌ nzi gax ncheꞌ nde re ranch, tak ncheꞌ ngenta jwanꞌ wa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús mkab lo xaꞌ: —Goꞌ Ptaꞌ jwanꞌ wa men. Leꞌ xaꞌ nchab: —¿Plo ya xiꞌ náꞌ tmi tyuꞌ jwanꞌ wa reta men reꞌ? Tenye chop ayoꞌ wiz ke tib men sinꞌ nagalta tmi ya. ");
INSERT INTO ztp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús nchab lo xaꞌ: —Wa twiꞌ goꞌ nyenꞌ pla pan ngeno goꞌ. Zyasa ngwa twiꞌ xaꞌ nde nchab xaꞌ: —Benꞌta gayꞌ pan nde chopta mbel nzo. ");
INSERT INTO ztp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nde mnabeꞌ Jesús sa kweksaꞌ xaꞌ men lo yix naye nzi tya. ");
INSERT INTO ztp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nde mbrezaꞌ xaꞌ, ayoꞌ por ayoꞌ xaꞌ nde choꞌpsiꞌ por choꞌpsiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zyasa mxen Jesús re gayꞌ pan kon rop mbel nde mbwiꞌ Xaꞌ lo beꞌ, mbli ley' xa'y, nde mblirol Xaꞌ pan mda' Xa'y lo re xinꞌ teꞌd Xaꞌ sa yathi'd xaꞌy lo reta men nde taga mdi'd Xaꞌ mbel. ");
INSERT INTO ztp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nde mda reta men axta mze lenꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nde mthop xa' reta jwan' mbroxo'b, mbro' tib sen chokwid sey chan' pan nde mbel. ");
INSERT INTO ztp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nde reta xaꞌ jwanꞌ mda nak xa' ti gayꞌ mil mbi'. ");
INSERT INTO ztp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ngolo jwan' re', mbloned Jesús re xin' te'd xa' ngwap xa' lo ti bark sa nda xa' yez Betsaida tedib lad ro nit. Laja leꞌ Jesús ndotodiꞌsno re men sa rya's men. ");
INSERT INTO ztp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Senꞌ ngolo mcha's Jesús reta men, Jesús ngwap yek yi' ngwatodiꞌsno Xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lo mbla yal', leꞌ bark jwanꞌ nzo re xinꞌ teꞌd Xaꞌ ndale rolja nittoꞌ nde Jesús benꞌ ndo ro nit. ");
INSERT INTO ztp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nde mbwi' Jesús ne toz ndateno re xin' te'd Xaꞌ bark, tak narax nde mbi lo nit, senꞌ merla tuxni Jesús ndoyotu ten' nda bark ndani Xa' lo nittoꞌ, nde nchola's Xa' ri'dnda'b gal' Xa'. ");
INSERT INTO ztp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sen' mbwiꞌ re xaꞌ ndoni Jesús lo nittoꞌ, mbli xaꞌ xgab naka jwanꞌ bet, nde mbrez yaj toz re xa'. ");
INSERT INTO ztp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tak reta xaꞌ mbwiꞌ Jesús nde mzyeb toz xaꞌ. Per zyaga mni Jesús lo xa', nchab Jesús: —¡Blo ne lazoꞌ goꞌ, nay, naꞌzyepta goꞌ! ");
INSERT INTO ztp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nde ngwap Jesús lo bark, nde ngota'b mbi, nde nzoyen toz reta xaꞌ nde nale toz ngo lazo' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tak tera' yen re xaꞌ yalnaro jwanꞌ mbli Jesús kon re pan, ben' ne yek xaꞌ jwanꞌ nasa naꞌngyenta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Senꞌ ngolo mbri'd xaꞌ lo nittoꞌ, mzin xaꞌ lo xyon Genesaret, nde tya mkedoꞌ xaꞌ bark ro nit. ");
INSERT INTO ztp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nde laj ndola xaꞌ lo bark, zyaga reta men nzi tya mbyolo xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nde mchaꞌs xaꞌ diꞌs dib nax lo xyon ya, nde reta lad mdobte ndryo' re men ndeno xaꞌ re men nayiz lo Jesús, nge xaꞌ lo ya lonꞌ, nda xa' tenꞌ nchon xaꞌ ndo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nde one ploja nda Jesús, re yez ro, re yez bix nde re ranch, reta men ngote xaꞌ re men nayiz, ndob xaꞌ re mena ro ned nde nya'b toz xaꞌ lo Jesús sa ta' Jesús diꞌs te' benꞌ gal men yiza lad xab Jesús sa dyanꞌ xaꞌ. Nde reta men yiz jwanꞌ mbwal lad xab Jesús mdyan' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Re xaꞌ fariseo nde pla maestr nte'd ley xa' mbroꞌ yez Jerusalén, mdyop xaꞌ tenꞌ ndo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Re xa' re', mbwiꞌ xaꞌ pla xinꞌ teꞌd Jesús tata nabew ya xaꞌ ncha xaꞌ pan, na'ntachta xa' ya' xa', jwanꞌna nak yalke mkeꞌ xaꞌ yek xinꞌ teꞌd Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tak re xaꞌ fariseo nde reta men Israel, nxo'byek toz xaꞌ mod mtanꞌ re xaꞌ gox jwanꞌ mbre pola, tez naꞌyachta yaꞌ xaꞌ, natoyalta wa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nde lo mbere xaꞌ ngwa xaꞌ lo xbiꞌ, tez na'yachta yaꞌ xaꞌ na'wad xaꞌ. Nde na'r toz xaꞌga re jwanꞌ nkenap xaꞌ lo mod gox, xa nak yach re xi nchuꞌ xaꞌ nit, yach ré nde re yet yi'b jwanꞌ ndli rsinꞌ xaꞌ, nde axta re lon' xaꞌ, yacha. ");
INSERT INTO ztp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jwanꞌ nasa re xaꞌ fariseo nde re maestr nchak ley, mnabdiꞌs xaꞌ lo Jesús, nchab xaꞌ: —¿Cho kwan liy sa re xinꞌ teꞌd la na'ntachta xaꞌ ya' xa' senꞌ ncha xaꞌ, na'nxo'byekta xaꞌ re mod jwanꞌ mtanꞌ re xaꞌ gox mbre pola, che'la tata ya' xa' ncha xa'? ");
INSERT INTO ztp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús mkab lo xaꞌ: —Men kwinꞌ go', galꞌka mdej Isaías, jwan' xa ngeniga lo xkiꞌs Dios: Yez reꞌ benꞌ ro xaꞌ nxo'byek xaꞌ na, Le' lazoꞌ xaꞌ tij ndoy lon. ");
INSERT INTO ztp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Benꞌ nale nxo'byek xa' na, Ndloꞌ xaꞌ re yalte'd jwan' nak yalnyebe' chanꞌ men. ");
INSERT INTO ztp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tak mblaꞌ goꞌ re yalnyebeꞌ chanꞌ Dios, na leꞌ goꞌ ndyonke xis re mod gox jwanꞌ mtanꞌ re men gox pola, jwan' xa nak yach yet ré nde yach re xi jwanꞌ nchuꞌ goꞌ nit nde masraꞌ re jwanꞌ re' ndli goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Noga nchab Jesús: Thiptane mblo'tal goꞌ re yalnyebeꞌ chanꞌ Dios sa nxo'byek goꞌ re mod gox. ");
INSERT INTO ztp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tak Moisés nchab: “Bxo'byek xud la nde xnaꞌa;” nde: “Men jwanꞌ nke'de xis xud naꞌ o xnanꞌ, ndablo gaj xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Leꞌ goꞌ mbez: Toyal gab men lo xud men o lo xnaꞌ men: “Na'lit na gan tan jwan' la'ston la tak reta jwanꞌ ngenon naka, korbán.” (Diꞌs reꞌ nak: “naka jwan' nayon lo Dios”.) ");
INSERT INTO ztp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nde lo ta gab xaꞌ, na'toyalta la'sto xa' xud xaꞌ o xnaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tamod ngo'tal goꞌ yalnyebeꞌ chanꞌ Dios, ndyonke goꞌ xis re mod gox jwanꞌ nden goꞌ. Nde na'r toz jwanꞌ tamod ndli goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nde mbrez Jesús reta men nzi tya, nchab Jesús lo xaꞌ: —Reta goꞌ, pkeꞌnza jwanꞌ ni lo go' nde byen goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nekthib re jwan' ta nda len' men, na'ndlide narax lo men; per re xgab narax nde diꞌs narax jwanꞌ ndryoꞌ lazoꞌ men, jwanꞌna ndli narax lo men. ");
INSERT INTO ztp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Tez nzo goꞌ ngeno nzanꞌ sa gon go'y, bin goꞌy! ");
INSERT INTO ztp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Senꞌ mbroꞌ Jesús xij reta men nde ngote Xaꞌ lenꞌ yo, zya mna'bdiꞌs re xin' te'd Xa' nyenꞌ xamod nak di's nabixa. ");
INSERT INTO ztp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús nchab lo xaꞌ: —¿Cho noga' goꞌ nangyenta go'y? ¿Cho na'nyed goꞌ reta jwanꞌ ta ncha men na'ndlide narax lo men, ");
INSERT INTO ztp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tak na'ndlyade lazoꞌ men, leꞌy nda lenꞌ men nde tya ndryoꞌtey nday wan? Jwanꞌ reꞌ mdej Jesús, nchab Xaꞌ ke reta jwanꞌ ncha men na'dlide narax lo men. ");
INSERT INTO ztp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Per nchab Jesús: —Reta xgab narax nde diꞌs narax jwanꞌ ndryoꞌ lazoꞌ men, jwanꞌna ndli narax lo men. ");
INSERT INTO ztp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tak lazoꞌ men nchal reta xgab narax, xa nak, re xaꞌ jwan' ncha'xno tedib men na'nakta sal' xa', re xaꞌ ta ndli re ned yalxkap nde re xaꞌ nguj men, ");
INSERT INTO ztp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yalwanꞌ, yaltablaꞌs, yalxinlaꞌs, yalkwinꞌ, jwan' thiptane ndlya men lo jwan' narax, nayiꞌ xaꞌ nye xaꞌ chanꞌ ta xaꞌ, yaltodiꞌsyix, yalbxalꞌ nde yalneyek. ");
INSERT INTO ztp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Reta jwan' narax reꞌ, lazoꞌ men ndryoꞌy nde ndliy narax lo men. ");
INSERT INTO ztp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mbroꞌ Jesús tya, nda Xaꞌ lo xyon Tiro nde Sidón. Senꞌ mzin xaꞌ, mbla Xa' len' yo, na'nchola'sta Xaꞌ nye nek thib mena, per na'ndlid Xaꞌ gan nka'slo Xa'. ");
INSERT INTO ztp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tak ngo ti ngol ngeno xaꞌ ti mzaꞌ xinꞌ xaꞌ nzo mbi narax lazo'r, sen' mbin xaꞌ mzin Jesús, mbyeꞌd xaꞌ lo Jesús nde mdoxub ngol lo ni Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ngol reꞌ nanakta xaꞌ men Israel, leꞌ xaꞌ nak men lo xyon Sirofenicia. Nde mna'b toz xa' lo Jesús sa kote Jesús mbi narax nzo lazoꞌ mza'. ");
INSERT INTO ztp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Leꞌ Jesús nchab lo ngol: —Btaꞌ diꞌs sa nerla wa re mdyenꞌ, tak nawenta kib men jwanꞌ ndob yar nde taꞌ mena lo mbak. ");
INSERT INTO ztp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Leꞌ ngol mkab: —Taga naka Xaꞌ Nyebeꞌ; per re mbaka ndlya maꞌ xanꞌ mes nde ncha maꞌ re kos jwanꞌ nchab lo yaꞌ mdyenꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Zyasa nchab Jesús lo ngol: —Lo di's ta mkab la re', bya, leꞌ mbi narax mbroꞌtelay lazoꞌ xinꞌ la. ");
INSERT INTO ztp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nde senꞌ mzin ngol liz ngol, mbwiꞌ ngol mbro'tela mbi narax lazoꞌ mzaꞌ nde xe nax mzaꞌ lo lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tya bere mbro' Jesús lo xyon Tiro, mbri'd xaꞌ yez Sidón nde nda xaꞌ ro nittoꞌ chan' Galilea, tya mbri'd xaꞌ lo xyon Decápolis. ");
INSERT INTO ztp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nde tya mbye'dno xa' lo Jesús ti mbiꞌ nkwe' nde nka ro xa', nde mna'b toz xaꞌ sa xo'b yaꞌ Jesús yek mbiꞌ ta nayiza. ");
INSERT INTO ztp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nde xa'ta mbeꞌ Jesús mbiꞌ ya, mblo Jesús kwenyaꞌ Xaꞌ rop lenꞌ nza mbiꞌ nde kon lud xit suk Xaꞌ mdob Xaꞌy lo loz mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nde mbwiꞌ Jesús lo beꞌ, mdiꞌ lazoꞌ Xaꞌ, nde nchab Xaꞌ: —¡Efata! (Diꞌs ya nak: ¡Pxyalꞌ!) ");
INSERT INTO ztp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Zyaga mxyalꞌ rop nza men yiza nde mxyalꞌ ro xaꞌ nde mdobte nawe mdodiꞌs xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nde mnabeꞌ Jesús ngen cho lo men gab xa'y, per senꞌ nya'b toz Jesús na'tejta xa'y, masraꞌ ndej xa'y lo re men. ");
INSERT INTO ztp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nde jwan' toz tir nzoyen reta men, nchab xaꞌ: —¡Wen toz ndli Xaꞌ, ndli Xaꞌ nxyalꞌ nza men nkweꞌ nde ndli Xaꞌ ndyodiꞌs re men jwanꞌ naꞌakta todiꞌs. ");
INSERT INTO ztp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lenꞌ wiz ya taxa mkata bro toz men lo Jesús nde naꞌngenta jwanꞌ wa re men. Zyasa mbrez Jesús re xinꞌ teꞌd Xaꞌ nde nchab Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ndlat lazoꞌn ngwi'n re men reꞌ, tak ndala son wiz nzi xaꞌ kon na nche' nde naꞌngenod xaꞌ jwanꞌ wa xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","tez tata tera wa xaꞌ goned na xaꞌ liz xaꞌ, naxkeꞌ mbiy yek xaꞌ ned, tak nzo xaꞌ xija nde tij. ");
INSERT INTO ztp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Leꞌ re xa nak xinꞌ teꞌd Jesús nchab: —¿Plo ya xinꞌ jwanꞌ wa reta men reꞌ, tak ncheꞌ ngenta kwan nak nde tij nzi re yez? ");
INSERT INTO ztp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zya mnabdiꞌs Jesús lo xaꞌ: —¿Pla pan ngeno goꞌ? Leꞌ xaꞌ mkab: —Gaza. ");
INSERT INTO ztp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Zyasa mnabeꞌ Jesús tyob reta men izyo; nde mxen Jesús re gaz pan, ngolo mdaꞌ Xaꞌ dyux lo Dios, mblirol Xaꞌy, nde mdaꞌ Xaꞌy lo re xinꞌ teꞌd Xaꞌ, sa yathi'd xaꞌy; nde ngwathi'd xa'y lo reta men. ");
INSERT INTO ztp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noga ngeno xaꞌ pla mbel tya; nde taga mbli le'y Xaꞌy nde mnabeꞌ Jesús yathi'd xaꞌy lo reta men. ");
INSERT INTO ztp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nde mda men axta kebeꞌ mze lenꞌ men; ngolo mne mda reta men, zyasa mthop xaꞌ reta jwanꞌ mbroxo'b nde mkata tib gaz chokwida. ");
INSERT INTO ztp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Lo reta men jwanꞌ nzi tya, nzi ti thap mil xaꞌ, zyasa mchaꞌs Jesús reta men. ");
INSERT INTO ztp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nde ngwap Jesús lo bark kon re xinꞌ teꞌd Xaꞌ nde nda xaꞌ tenꞌ nak lo xyon Dalmanuta. ");
INSERT INTO ztp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tya mzin pla xaꞌ fariseo, tolo chepa mbrez xaꞌ lo Jesús, mna'b xaꞌ yalnaro jwanꞌ nde lo beꞌ, sa libeꞌ xaꞌ nyenꞌ cho liga Dios mtelꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zyasa axta mtiꞌ lazoꞌ Jesús nde nchab Jesus lo xaꞌ: —¿Kwan sa re men nzi nche' ncholaꞌs xaꞌ lin yalnaro lo xaꞌ? Nipa na lo go', ke nekthib yalnaro na'lot na lo me ta nzi nche'. ");
INSERT INTO ztp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nde mblaꞌ Jesús re men ya, bere ngwap xaꞌ lo bark tedib gob, nda xaꞌ tedib lad ro nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Le' re xin' te'd Jesús mbyaj yek xaꞌ nkweꞌ xaꞌ pan, benꞌ thipta pan ngeno xa' len' bark. ");
INSERT INTO ztp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Le' Jesús mnabe' lo xaꞌ, nchab Jesús: —Pto nza go', nda wiꞌ toz goꞌ kon lebadur jwan' nak re xaꞌ fariseo nde lebadur jwan' nak Herodes. ");
INSERT INTO ztp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nde mdobte nchab xaꞌ lo ta xaꞌ: —Tak na'ndenod naꞌ pan jwanꞌ nasa ta mbez Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zyaga mne Jesús jwan' ta nzi bez xaꞌ nde nchab Jesús lo xaꞌ: —¿Kwan ta nzi bez go',cho tak naꞌndenod goꞌ pana? ¿Cho naꞌnchonta goꞌ diꞌs, neka tera yen goꞌ? ¿Tata ben' ne toz lazo' goꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ndob ngud lo goꞌ nde nangwi'd goꞌ, ndob nza goꞌ nde nanchonta goꞌ diꞌs? ¿Nde naꞌntelaꞌsta go'? ");
INSERT INTO ztp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Senꞌ mdi'd na re gayꞌ pan xij re gayꞌ mil mbiꞌ, ¿pla chokwid pan jwanꞌ mbro'xo'b mthop goꞌ? Leꞌ xaꞌ mkab: —Tib sen na. ");
INSERT INTO ztp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nde senꞌ mdi'd na re gaz pan xij re tap mil men, ¿Pla chokwid pan mbro'xo'b mthop goꞌ? Leꞌ xaꞌ mkab: —Gaza. ");
INSERT INTO ztp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nde nchab Jesús lo xaꞌ: —¿Cho kwan liy tera' yen goꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zyaga mzin Xa' yez Betsaida; tya mbye'dno men ti xaꞌ naꞌakta wiꞌ nde mna'b xaꞌ lo Jesús sa gal Jesús men ta nayiza. ");
INSERT INTO ztp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Zyasa mxen Jesús yaꞌ mbiꞌ ta nayiz ngudlonꞌ ya, mbeꞌ Jesús xaꞌ lad ro yez; tya mzuk Jesús ngudlo xaꞌ nde mbwal Jesús ngudlo xaꞌ nde mnabdiꞌs Jesús lo xaꞌ, cho toyala wi' xa' lud ");
INSERT INTO ztp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zya mbwiꞌ xa' nde nchab xaꞌ: —Xanya ya nya re mena ndyak na, per ngwi'n ndye xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zyaga bere mbwal Jesús ngudlo xaꞌ tedib gob, nde mbli Jesús mbwi' xa'; nde nawe mxyal' lo xa', tij nchoni lo xa' nde nambi ngwi' xa' reta men. ");
INSERT INTO ztp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nde mbloned Jesús xaꞌ liz xaꞌ, nchab Jesús lo xaꞌ: —Naꞌlyad la lenꞌ yez nde nagapta luy nek tib lo men nzo yez. ");
INSERT INTO ztp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús mbroꞌ kon re xinꞌ teꞌd Xaꞌ nda xaꞌ re yez jwanꞌ nzi lo xyon Cesarea chan' Filipo. Nde ned mnabdiꞌs Jesús lo re xinꞌ teꞌd Xaꞌ, nchab Xa': —¿Cho nak na mbez re men? ");
INSERT INTO ztp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Leꞌ xinꞌ teꞌd Xaꞌ nchab: —Nzo men mbez nak la Juan Bautist, nzo men mbez nak la Elías nde nzo men mbez nzo cho ti profet nak la. ");
INSERT INTO ztp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zyasa nchab Jesús lo xaꞌ: —Mbay goꞌ, ¿Cho nak na mbez goꞌ? Le' Pedr mkab —Lu nak Xaꞌ Mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per mnabeꞌ Jesús lo xaꞌ nek thib lo men na'tejta xaꞌ jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nde mdobte mblo' Jesús lo xa' nakin' le' Xinꞌ Mbiꞌ rid Xa' brotoz yalti, nde re xaꞌ gol nak sinꞌ lo men Israel, re xaꞌ nak ngwleyꞌ ro nde re xaꞌ nak maestr ndlo' ley. nde kuj men Xin' Mbi', per yoxo'b mbyon wiz ryo'xban Xa'. ");
INSERT INTO ztp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nambi toz mdej Jesús re jwan' re'. Zyasa mbeꞌ Pey Jesús tedib lad nde mbrez Pey yek Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Leꞌ Jesús mbyek, mbwiꞌ Xaꞌ lo re xinꞌ teꞌd Xaꞌ nde mbrez Xaꞌ yek Pey, nchab Xaꞌ: —¡Bike lon Maxuꞌ! tak nandobta xgab la lo chanꞌ Dios, leꞌ xgab la ndob lo chan' men. ");
INSERT INTO ztp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Zya mbrez Jesús re xinꞌ teꞌd Xaꞌ kon reta men nzi tya nde nchab Xaꞌ: —Tez nzo goꞌ ncholaꞌs tyonke xis na, bla' go' re jwan' nak go', nde beꞌ goꞌ kruz goꞌ, nde ptonke goꞌ xis na. ");
INSERT INTO ztp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tak re men jwanꞌ ncholaꞌs tolaꞌ yalnaban chanꞌ xaꞌ lo izyo reꞌ, xaꞌ ya taꞌb yalnaban adiꞌ jwanꞌ ndaꞌ Dios; nde re men jwanꞌ taꞌb yalnaban chanꞌ xaꞌ lo izyo reꞌ por ndli lazoꞌ xaꞌ na nde diꞌs wen chanꞌ Dios, xaꞌ ya ligan yalnaban adiꞌ jwanꞌ ndaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tak, ¿cho sinꞌ liy lo men keno men reta jwanꞌ nzo lo izyo reꞌ nde ta'b men yalnaban adiꞌ ndaꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngenta cho men li gan kix par lyaꞌ xbin men. ");
INSERT INTO ztp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nde tez nzo xaꞌ ndyolaꞌs gab, ke ndli lazoꞌ xaꞌ na nde natejta xaꞌ xkiꞌs na lo re men jwanꞌ nzo'b xkenꞌ, men jwanꞌ mblaꞌ xkiꞌs Dios ta nzi naya, no na, Xinꞌ Mbiꞌ mbyeꞌd lo izyo reꞌ tolaꞌs na nyen men ya senꞌ yal na kon yalnaro chanꞌ Pay nde kon re áng Nayon. ");
INSERT INTO ztp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Noga nchab Jesús: —Nipa na lo goꞌ, ke nzo pla xaꞌ jwanꞌ nzi ncheꞌ na'gajta xaꞌ axta kebeꞌ wiꞌ xaꞌ yalnyebeꞌ chanꞌ Dios ye'd kon yalnaro. ");
INSERT INTO ztp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mbri'dnda'b xop wiz, Jesús ngwa ti yek yiꞌ nde benꞌta mbeꞌ Xaꞌ Pey, Jakob nde Juan, le'ta re xaꞌ ngwa; nde senꞌ lo mzin xaꞌ tya, nzi wiꞌ re yon xaꞌ mzyeꞌ nya Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Leꞌ xab Jesus thiptane nakistir ngolala anta ndyob xni nyay, ngenta nekthib men lo izyo jwan' ntach lar taja nakis nya. ");
INSERT INTO ztp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tya mbroꞌto Elías kon Moisés, ntotodiꞌsno xa' Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Leꞌ Pey nchab lo Jesús: —Maestr, wenka nzinꞌ ncheꞌ; sa toxkwaꞌ náꞌ son ramad, thiba chanꞌ la, thiba chanꞌ Moisés nde thiba chanꞌ Elías. ");
INSERT INTO ztp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Na'nyeda Pey jwanꞌ nchab Pey, tak mzyeb toz re yon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Zya mbla ti xkow yek re xaꞌ nde xij xkowa mbyen tib diꞌs jwanꞌ nchab: —Xaꞌ reꞌ nak xinꞌ na nkeꞌ toz lazoꞌn Xaꞌ. Bin goꞌ xkiꞌs Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nde zyaga, senꞌ lo mbwiꞌ xaꞌ, ngenta cho ndono Jesús benꞌta tib Jesús ndo. ");
INSERT INTO ztp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Senꞌ lo ngo xaꞌ ned, ndela xaꞌ lad yiꞌ, zya mnabeꞌ Jesús lo re yon xaꞌ ke nek thib lo men na'tejta xaꞌ jwanꞌ mbwiꞌ xaꞌ, axta kebeꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo ryoxban Xaꞌ xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mbin xaꞌ diꞌs, ngenta cho lo men ndej xaꞌy, per benꞌta re yon xaꞌ ndyodiꞌs, xomod nak jwan' ta ryo'xban Xaꞌ xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nde mnabdiꞌs xaꞌ lo Jesús, nchab xaꞌ: —¿Cho kwan ndliy mbez re maestr ndlo' ley xkiꞌs Dios, ke nakinꞌ nerla Elías ye'd? ");
INSERT INTO ztp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Leꞌ Jesús nchab: —Liy, nerka Elías ndablo ye'd, sa toni xaꞌ re men, nde xa nchabka lo xkiꞌs Dios leꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo nakinꞌ rid Xaꞌ yalti nde kotal men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per na ni lo goꞌ ke mbyeꞌdla Elías nde mtoti men xaꞌ mod ndalazoꞌ men, jwan' xa nchabka lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Senꞌ lo mzin Jesús tenꞌ nzi tipla xinꞌ teꞌd Xaꞌ, men toz nzi lo xaꞌ nde tya nzi pla xaꞌ nak maestr nteꞌd ley xkiꞌs Dios, anta chepa nzi bez xaꞌ kon xinꞌ teꞌd Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nde axta nzoyen re men senꞌ mbwiꞌ men mzin Jesús, mke xaꞌ karrel ngwa ni xaꞌ dyux lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zyasa mnabdiꞌs Jesús lo xaꞌ: —¿Cho kwan liy taja nzi bez goꞌ ncheꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Xija mkab tib xaꞌ, nchab: —Maestr, na ndeno xinꞌ na loa, tak ti mbi narax nzo lazoꞌr nde jwanꞌna mbli nda xkiꞌs or. ");
INSERT INTO ztp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nde one ploja ngeter ndyen mbi narax or, ngobiy or izyo, ndryoꞌ psinꞌ ror, ngaꞌz ler nde mbyez or. Nchab na lo re xinꞌ teꞌd la kote xaꞌ mbi narax nzo lazoꞌr, per na'lid xaꞌ gan. ");
INSERT INTO ztp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Leꞌ Jesús nchab lo xa': —¡Nak go' men nandlid lazonꞌ Dios! ¿Plopa ndablo keteꞌnon goꞌ? ¿Plopa ndablo xek na goꞌ? Deꞌno goꞌ mbyo ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Zyasa ngwano xaꞌ mbyo lo Jesús. Nde senꞌ mbwiꞌ mbi naraxa Jesús, xaja kwana mtotiy mbyo, mdinkey or izyo anta nchub or nde taja nke psinꞌ ror. ");
INSERT INTO ztp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús mnabdiꞌs lo xud or: —¿Pol ndate ta ndyak or? Leꞌ xud or nchab: —Xata lud ora. ");
INSERT INTO ztp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nde naꞌr toz gob axta lo ki nde lenꞌ nit ngobi mbi narax or par kuja or. Per tez tlia gan lia ti jwan', blat lazoꞌa náꞌ nde blaꞌsto náꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús nchab: —Tezka tlia gan li lazo'a, tak men jwanꞌ ndli lazonꞌ reta jwanꞌ taka lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Zyaga xud mbyo ya mbrezyaj xa', nchab xaꞌ: —Li lazoꞌ ney, blaꞌston sa masra' li lazoꞌn. ");
INSERT INTO ztp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nde senꞌ mbwiꞌ Jesús men toz ndodop tya, zya mbrez Jesús lo mbi narax, nchab Xaꞌ: —Mbi ngup, mbi nkweꞌ, na nyebeꞌ loa, broꞌte lazoꞌ mbyo reꞌ nde na'beretra lu. ");
INSERT INTO ztp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zyasa leꞌ mbi naraxa mbliy mbrez yaj or nde xaja kwana mtotiy mbyo tamod mbroꞌtey lazoꞌr; nde mbyanꞌ mbyo xaja men nguja. Reta men nzi tya, nchab xaꞌ: —Nguj mbyo. ");
INSERT INTO ztp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per Jesús, mxen Xaꞌ yaꞌ mbyo, mbliche Xaꞌ or, nde mtolir. ");
INSERT INTO ztp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Senꞌ ngote Jesús lenꞌ yo, zya re xinꞌ teꞌd Jesús xaꞌta mnabdiꞌs xaꞌ lo Jesús, nchab xaꞌ: —¿Cho kwan liy sa na'ndlid náꞌ gan ngote náꞌ mbi naraxa? ");
INSERT INTO ztp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nde nchab Jesús lo xa': —Tib ned mbi narax reꞌ na'ryo'teday tata, nakinꞌ nerla todiꞌsno men Dios nde li men yalse, sa ryo'tey. ");
INSERT INTO ztp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Senꞌ mbroꞌ Jesús tya kon re xinꞌ teꞌd Xaꞌ, ndeni xaꞌ dib lo xyon Galilea; nde na'ncholasta Jesús ke nek tib men nye plo ngete Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tak leꞌ Xaꞌ ndlo' lo re xinꞌ teꞌd Xaꞌ, nchab Xaꞌ: —Leꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo, tayaꞌ men Xaꞌ lo yaꞌ re men nde kuj men Xaꞌ. Per senꞌ lo ngujla Xaꞌ, ngoxo'b mbyon wiz ryo'xban Xaꞌ tedi gob. ");
INSERT INTO ztp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per naꞌngyenta xaꞌ jwanꞌ nchab Jesús nde mzyeb xaꞌ na'bdiꞌs xaꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nde senꞌ mzin xaꞌ yez Capernaum; tya ndob ti yo mbled xaꞌ, zyasa mnabdiꞌs Jesús lo re xinꞌ teꞌd Xaꞌ, nchab Xaꞌ: —¿Cho kwan taja ndetodiꞌs goꞌ neda? ");
INSERT INTO ztp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nek tib xaꞌ na'nkabta, tak ned ndebez xaꞌ lo ta xaꞌ xanya xa' ak mas xaꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zyasa mdob Jesús nde mbrez Xaꞌ re tib sen xinꞌ teꞌd Xaꞌ, nchab Xaꞌ: —Tez nzo goꞌ ncholaꞌs ak xaꞌ ner, xa' ya nakinꞌ tyo xis nde li xaꞌ sinꞌ lo reta go'. ");
INSERT INTO ztp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Zya mxen Jesús tib or lud, mto Xaꞌ or xij re xaꞌ nde mdob Xaꞌ or lo yaꞌ Xaꞌ, nchab Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Men jwanꞌ kayaꞌ ti or lud reꞌ por kwent chanꞌ na, xaꞌ ya mkayaꞌ na; nde xaꞌ jwanꞌ kayaꞌ na, namkayaꞌd xaꞌ na leꞌ xaꞌ mkayaꞌ Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Leꞌ Juan nchab: —Maestr, mbwiꞌ náꞌ tib xaꞌ, kon lea ndej xaꞌ sa ngote xaꞌ re mbi narax nzo lazoꞌ men nde nakte xaꞌ ta ngete kon naꞌ, jwanꞌ nasa mka náꞌ diꞌs li xaꞌy tak na'nzod xaꞌ xij naꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Per Jesús nchab: —Na'kad goꞌ diꞌs li xaꞌy; tak ngenta nek thib men kon len ndli xaꞌ yalnaro nde nixin xaꞌ xis na. ");
INSERT INTO ztp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tak xaꞌ jwanꞌ na'nixinta xis naꞌ, kon naꞌ ndo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nde choja men jwanꞌ taꞌlas tib xi nit gu goꞌ por kwent chanꞌ na, tak ndli lazoꞌ goꞌ Crist, Xaꞌ mtelꞌ Dios, nipa na lo goꞌ ke ngenola Dios jwanꞌ taꞌlas Xaꞌ lo men ya. ");
INSERT INTO ztp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nde choja xaꞌ jwanꞌ li sa cheb ti or lud re' lo yalke, or ta ndli lazonꞌ na reꞌ, mas wen nda xaꞌ tez tyobdoꞌ ti ke ro yen xaꞌ nde kobi men xaꞌ lenꞌ nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tez yaꞌa li sa gab la lo yalke, bchoꞌy. Mas wen ndaa kon thipta yaꞌa, kayaꞌa yalnaban adiꞌ, ke ndob rop yaꞌa nde yaa lo pen tenꞌ nzo bel naꞌakta yuꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","tya nzo re mbyeꞌd nandluxta nde bel nanchu'da. ");
INSERT INTO ztp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nde tez nia li sa gab la lo yalke, bchoꞌy. Mas wen ndaa kon thipta nia, kayaꞌa yalnaban adiꞌ, ke ndob rop nia nde yaa lo pen tenꞌ nzo bel naꞌakta yuꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","tya nzo re mbye'd na'ndluxta nde bel nanchu'da. ");
INSERT INTO ztp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nde tez ngud loa li sa gab la lo yalke, bloꞌtey. Mas wen ndaa kon thipta ngud loa, kayaꞌa yalnaban adiꞌ, ke ndob rop ngud loa nde yaa lo pen tenꞌ ndo bel naꞌakta yuꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tya nzo re mbye'd na'ndluxta nde bel nanchu'da. ");
INSERT INTO ztp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Tak reta men ak nasig kon bel nde reta jwanꞌ yon yo teda sa ak nasiga. ");
INSERT INTO ztp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wen nak ted, per tez leꞌ ted nanasigtay, ¿xomod li goꞌ ak nasiga tedi gob? Jwanꞌ nasa ndablo ak goꞌ xaja ted nasiga, nabeꞌz bre goꞌ kon kad tiba goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mbroꞌ Jesús yez Capernaum, nda Xaꞌ lo xyon Judea nde mzin Xaꞌ tedib lad ro yoꞌ Jordán, nde taxa mdyop re men lo Xaꞌ tya, nde bere mtote'd Xa' reta men mod jwanꞌ ndliga Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Zyasa mbike pla xaꞌ fariseo mnabdiꞌs xaꞌ lo Jesús benꞌ sa kwanꞌ xaꞌ mod keꞌ xaꞌ yalke yek Jesús, sa nchab xaꞌ: —¿Cho galꞌ naka laꞌ xaꞌ biꞌ ngol xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Le' Jesús mkab lo xaꞌ: —¿Xomodka nchab ley jwanꞌ mnabe' Moisés? ");
INSERT INTO ztp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Leꞌ xaꞌ nchab: — Moisés nta' di's toyal laꞌ men salꞌ men, benꞌ tyoxkwaꞌ yeꞌs jwanꞌ nyebeꞌ ke laꞌ xaꞌ biꞌ salꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Leꞌ Jesús mkab lo xaꞌ: —Por yalneyek chanꞌ goꞌ jwanꞌ nasa mkeꞌ Moisés yalnyebeꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tak sen' mdobte ner mtoxkwaꞌ Dios reta jwanꞌ, mbi' nde ngol mtoxkwaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Jwanꞌ nasa la' men biꞌ xud xaꞌ nde xnaꞌ xaꞌ nde tyobno xaꞌ ngol xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nde rop xaꞌ, thipta bel' ak xaꞌ.” Jwanꞌ nasa na'nakta xaꞌ chop, che'la thipta nak xa'. ");
INSERT INTO ztp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jwan' nasa, xa' jwanꞌ mtenta Dios, ngenta cho men li sa laꞌ xaꞌ salꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Senꞌ mzin re xaꞌ yo re xinꞌ teꞌd Jesus bere mnabdiꞌs xa' jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nde nchab Jesús lo xa': —Choja men jwan' laꞌ ngol na' nde ka xaꞌ tedib ngol, nak xa' men ndli jwan' xkap kon ngol xaꞌ jwan' nak ner. ");
INSERT INTO ztp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nde noga ngol, tez laꞌ xaꞌ salꞌ xaꞌ nde ka ngol tedib mbiꞌ, nak xa' ngol ndli jwan' xkap kon xa' bi' jwan' nak sal' ner xa'. ");
INSERT INTO ztp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nde ndano xa' re or bix lo Jesús sa xo'b ya' Xaꞌ yek or; leꞌ re xaꞌ nak xinꞌ teꞌd Jesús mbrez xaꞌ yek re men ta ndeno or bixa. ");
INSERT INTO ztp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Senꞌ lo mbwiꞌ Jesús ta nzi li xaꞌ, ngok nayiꞌ Jesús nde nchab Xaꞌ: —Btaꞌ goꞌ diꞌs ye'd re or bixa lon nde nakad goꞌ diꞌs; tak Dios nyebeꞌ lazoꞌ men jwanꞌ nak xaja or bix reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nipa na lo goꞌ, men jwanꞌ nakayaꞌda yalnyebeꞌ chanꞌ Dios, xaja ti or bix reꞌ, men ya naꞌlyada lo yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nde mdob Jesús or lo ya' Xa', mxob Xa' yaꞌ Xaꞌ yek or nde mbli leyꞌ Xaꞌ or. ");
INSERT INTO ztp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Laj ndoroꞌ Jesús sa nda xaꞌ, zya naban toz mzin ti mbiꞌ lo Jesús mdoxub xaꞌ nde nchab xaꞌ: —Maestr mnen ke galꞌ nak la, na nyabdiꞌs loa. ¿Cho kwan lin sa lin gan yalnaban adiꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Leꞌ Jesús mkab lo xaꞌ: —¿Cho kwan liy mbez la galꞌ nak na? Ngenta nek tib men galꞌ, benꞌta Dios nak Xaꞌ galꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Re jwanꞌ nyebeꞌ Dios mnea luy: Naꞌketenod la tedib men na'nakta salꞌ la. Na'kujta lu men. Na'lid la yalwanꞌ. Na'ked la yalke yek men jwanꞌ na'nakta xaꞌ. Na'kwinꞌta lu. Bxob yek xud la nde xnaꞌa. ");
INSERT INTO ztp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Leꞌ xaꞌ nchab: —Maestr, reta jwanꞌ re' axta lud nandolila nay. ");
INSERT INTO ztp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zya mbwiꞌ Jesús lo xaꞌ nde mblat lazoꞌ Jesús xaꞌ, nchab Jesús: —Tipta jwanꞌ tera lia, bya, ptho reta jwanꞌ ngenoa nde ptaꞌ tmi lo re xaꞌ jwanꞌ ngenta chanꞌ naꞌ, tamod kenoa bro toz jwanꞌ lo beꞌ zyasa deꞌ, sa wea kruz la nde tyonkea xis na. ");
INSERT INTO ztp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Zya mbli toz mbi' ya xgab senꞌ lo mbin xaꞌ diꞌs ya nde nabil ndya xaꞌ, tak bro toz jwanꞌ ngeno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zyasa mbwiꞌ Jesús lo re xinꞌ teꞌd Xaꞌ nde nchab Xaꞌ: —Plopa ne naka lo re xaꞌ ngeno bro toz jwanꞌ, sa yote xaꞌ lo yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nzoyen toz re xaꞌ nak xinꞌ teꞌd Jesús senꞌ mbin xaꞌ re diꞌs reꞌ; leꞌ Jesús bere nchab: —Xinꞌ na, plopa ne naka yote xaꞌ lo yalnyebeꞌ chanꞌ Dios, re xaꞌ ndob xgab naꞌ lo re jwanꞌ ngeno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas naleꞌ rid ndab ti kamey xan' ye'r yagux, ke rid ti xaꞌ rik lya xaꞌ lo yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Zya masraꞌ nzoyen re xaꞌ nde nchab xaꞌ lo ta xaꞌ: —¿Choꞌ men li gan lyaꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús mbwiꞌ lo xaꞌ nde nchab Jesús: —Lo re men nagana, leꞌ lo Dios nakte nagan, reta jwanꞌ tak li Dios. ");
INSERT INTO ztp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Leꞌ Pey mdobte nchab lo Jesús: —Náꞌ reꞌ, reta jwanꞌ mblaꞌ náꞌ nde mdonke náꞌ xis la. ");
INSERT INTO ztp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús mkab nde nchab xaꞌ: —Nipa na lo goꞌ, tez nzo men mblaꞌ liz naꞌ, wes naꞌ, ptanꞌ naꞌ, xud naꞌ, xnanꞌ, ngol naꞌ, xinꞌ naꞌ, izyon naꞌ tak ndyonke xaꞌ xis na nde ndataꞌ xaꞌ xkiꞌs Dios, ");
INSERT INTO ztp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","men ya laj naban xaꞌ kayaꞌ xaꞌy tib ayoꞌ gob masraꞌ. Kayaꞌ xaꞌ liz xaꞌ, wes xaꞌ, ptanꞌ xaꞌ, xnaꞌ xaꞌ, xinꞌ xaꞌ nde izyon xaꞌ nde noga toti men xaꞌ lo izyo reꞌ. Per sin tib wiz kayaꞌ xaꞌ yalnaban adiꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tak bro toz re men ta ndo ner naya yan' xa' xis, nde bro toz re xa' ndo xis ak xa' xa' ner. ");
INSERT INTO ztp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zyasa ngo xaꞌ ned nda xaꞌ yez Jerusalén. Jesús nda siblo, leꞌ re xinꞌ teꞌd Xaꞌ ndanke xis anta ngan xgab xaꞌ nde masraꞌ re men anta ndake seb xaꞌ xis Jesús. Zyasa xaꞌta mbrez Jesús re xinꞌ teꞌd Xaꞌ nde ndobte mdej Xa' re jwanꞌ yote Xaꞌ, nachab Xa': ");
INSERT INTO ztp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Bwiꞌ goꞌ naya ndanꞌ yez Jerusalén, leꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo reꞌ, tayaꞌ men Xaꞌ lo re ngwleyꞌ ro nde lo re xaꞌ nak maestr ndlo' ley xkiꞌs Dios, nde tya nyebeꞌ men gaj Xaꞌ nde tayaꞌ men Xaꞌ lo re men nanakta Israel, ");
INSERT INTO ztp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nde xino men Xaꞌ, kin men Xaꞌ, suk men lo Xaꞌ nde kuj men Xaꞌ; per yoxob mbyon wiz ryoxban Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zyasa Jakob nde Juan, xinꞌ Zebedeo, mbike xaꞌ lo Jesús nde nchab xaꞌ: —Maestr, ncholaꞌs náꞌ ke lia ti jwanꞌ nya'b náꞌ loa. ");
INSERT INTO ztp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Leꞌ Jesús nchab lo xaꞌ: —¿Cho kwan ncholaꞌs goꞌ lin? ");
INSERT INTO ztp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Leꞌ rop xaꞌ nchab: —Náꞌ ncholaꞌs senꞌ tyob la nyebeꞌa, taꞌa diꞌs tib náꞌ tyob lad ban la nde tedib náꞌ tyob lad beg la. ");
INSERT INTO ztp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús nchab lo xa': —Na'nyed goꞌ jwanꞌ nyab goꞌ. ¿Cho tli goꞌ gan rid goꞌ re yalti, jwanꞌ rid na nde gaj goꞌ mod jwanꞌ gaj na? ");
INSERT INTO ztp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Leꞌ rop xaꞌ mkab nde nchab xaꞌ: —Tli náꞌ gan. Jesús nchab lo xaꞌ: —Lin goꞌy, reta yalti rid na jwanꞌna rid goꞌ nde taj goꞌ, mod jwanꞌ gaj na. ");
INSERT INTO ztp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Leꞌ jwanꞌ ta nya'b goꞌ, tib goꞌ tyob lad ban na nde tedib goꞌ tyob lad beg na, nakta jwanꞌna kwent chanꞌ na, benꞌta Dios nyebeꞌ jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Senꞌ mbin ti siꞌ xinꞌ teꞌd Xaꞌ jwanꞌ reꞌ, zya mdobte ngok nayiꞌ xaꞌ lo Juan nde lo Jakob. ");
INSERT INTO ztp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zyasa mbrez Jesús re xaꞌ nde nchab Jesús lo xaꞌ: —Mnela goꞌ xamod nak re xaꞌ ta nchak sinꞌ ro, benꞌta ndob nyebeꞌ xaꞌ nde nchak naro xaꞌ lo tedib ned men. ");
INSERT INTO ztp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Leꞌ xij goꞌ reꞌ na'nakte tamod; cheꞌla, tez nzo goꞌ ncholaꞌs ak xaꞌ ro, xaꞌ ya nerla nakinꞌ li sinꞌ lo re goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nde tez nzo goꞌ ncholaꞌs nyebeꞌ, xaꞌ ya ndablo li sinꞌ lo re men. ");
INSERT INTO ztp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tak na Xinꞌ Mbiꞌ mbyeꞌd lo izyo reꞌ, na'ndalta na sa li men sinꞌ lon, na ndal sa lin sinꞌ lo men nde tob na yalnaban chanꞌ na, sa lyaꞌ re men lo xken men. ");
INSERT INTO ztp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zyasa mzin Jesús yez Jericó kon re xinꞌ teꞌd Xaꞌ. Nde senꞌ lo mbroꞌ xaꞌ yez ya kon reta men jwanꞌ ndanke xis xaꞌ, ned ndob ti xaꞌ ngwle nya'b gon ndole Bartimeo, xinꞌ Timeo. ");
INSERT INTO ztp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Senꞌ mbin xaꞌ leꞌ Jesús, Xaꞌ yez Nazaret ndarid tya, zyaga ne mbrez xaꞌ, nchab xaꞌ: —Jesús nde lo bin David, blat lazoꞌa na. ");
INSERT INTO ztp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nde nar men ngok nayiꞌ lo xaꞌ sa nakwesta xaꞌ, per zya mas ne mbrez xaꞌ: —¡Jesús nde lo bin David, blat lazoꞌa na! ");
INSERT INTO ztp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zya ngoto Jesús nde nchab Xaꞌ lo men: —Brez goꞌ xaꞌ. Nde mbrez xaꞌ men nayiza, nchab xaꞌ: —¡Blo nale lazoꞌa, ptoli, tak ngebez Xaꞌ lu! ");
INSERT INTO ztp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Leꞌ men ngwle ya zyaga gotoli xaꞌ, mblobi xaꞌ lar nzob xis xaꞌ nde nda xaꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús mnabdiꞌs lo xaꞌ: —¿Cho kwan ncholaꞌs la lin loa? Leꞌ men ngwle ya nchab: —Maestr, na ncholas xyalꞌ ngud lon sa wiꞌn. ");
INSERT INTO ztp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús nchab lo xaꞌ: —Bya, mbyak la lu, tak ndlipa lazoꞌa Dios. Zyaga mxyalꞌ ngud lo xaꞌ nde mdonke xaꞌ xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Senꞌ ndosin gaxla re xaꞌ yez Jerusalén, gax lo yez Betfage nde Betania, ngo' lo yi' Olib, Jesús mbloned chop xinꞌ teꞌd Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nde nchab Jesús lo xaꞌ: —Wa goꞌ yez lud ta nax ngo' lonꞌ reꞌ, senꞌ sin goꞌ tya, yosi'b goꞌ ti burr yenꞌ nkedoꞌ, ti burr jwanꞌ terka tyob xaꞌ xis naꞌ. Xak goꞌ maꞌ nde ye'dno goꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nde tez nzo xaꞌ nye lo goꞌ: “¿Cho kwan liy ta nya jwan' ndli go'?” Le' goꞌ gab lo xaꞌ: “Xaꞌ Nyebeꞌ nakinꞌ maꞌ, nde napa ye'dno Xaꞌ maꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Zyasa ngwa rop xaꞌ nde mzyal xaꞌ ti burr yenꞌ nkedoꞌ ro ned gax ti ro yo nde mxak xaꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nde pla xaꞌ jwanꞌ nzi tya, nchab xaꞌ: —¿Cho kwan liy ngexak goꞌ burr? ");
INSERT INTO ztp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Zya nchab xaꞌ jwan' xa mnabe' Jesús lo xaꞌ, nde mdaꞌ xaꞌ diꞌs mbeꞌ xaꞌ burr. ");
INSERT INTO ztp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nde mzin no xaꞌ burr lo Jesús, mxo'b xaꞌ xab xaꞌ xis maꞌ nde mdob Jesús xis ma'. ");
INSERT INTO ztp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bro toz men mxen xaꞌ lar jwanꞌ nzo'b xis xaꞌ, mtogaꞌ xaꞌy ned, tipla xaꞌ taja mchoꞌ re xod la wan nde mblek xaꞌy ned. ");
INSERT INTO ztp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nde reta men jwanꞌ nda siblo nde reta men jwanꞌ ndanke xis, nyaga ne mbez xaꞌ, nchab xaꞌ: —¡Naro Dios, Nayon nak Xaꞌ ta nde lo le Xa' Nyebe'! ");
INSERT INTO ztp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nayon nak yalnyebe' ta nde lo bin xud na' David, ¡Naro toz nak Dios lo beꞌ! ");
INSERT INTO ztp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nde ngote Jesús lenꞌ yez Jerusalén, nde tenꞌ ndob yodoꞌ, mbwiꞌ Xaꞌ reta jwan' nzi tya, yaja ndekowla izyo, nda Xaꞌ yez Betania kon re tib sen xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mduxni izyo tedib wiz, senꞌ lo mbroꞌ xaꞌ yez Betania, laj ndo xaꞌ ned msi'b ndyanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nde mbwiꞌ xaꞌ tij ndob tib ya hig ndo la lonꞌ, zyasa ngwa twiꞌ xaꞌ lo ya nyenꞌ cho tozal xaꞌ ti ngud wa xaꞌ. Nde senꞌ lo mzin xaꞌ tenꞌ ndob ya, nek tib ngud ngenta benꞌta la ndo lo ya, tak nakte tiemp jwanꞌ ndaꞌy ngud. ");
INSERT INTO ztp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Zyasa nchab Jesús lo ya hig: —Nek tib ngud ya natyotra loa wa men. Nde mbin re xinꞌ teꞌd Xaꞌ diꞌs jwanꞌ nchab Xaꞌ lo ya. ");
INSERT INTO ztp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Senꞌ lo mzin xaꞌ yez Jerusalén, Jesús ngote tenꞌ ndob yodoꞌ, tolo mblote Xaꞌ re men, re xaꞌ jwanꞌ nzi tho nde re xaꞌ jwanꞌ nzi tiꞌ. Mxen Jesús re mes xaꞌ jwanꞌ nzi nsilꞌ tmi, mtub Xaꞌy, taga mtub Xaꞌ re yasil xaꞌ nzi tho palom. ");
INSERT INTO ztp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nde naꞌndad Jesús diꞌs rid re men ndeno re jwanꞌ tenꞌ nak lo le chanꞌ yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nde mtoteꞌd Jesús re men, nchab Xaꞌ: —Lo xkiꞌs Dios ngeniy nchaba: “Liz na ryole yo todiꞌsno men Dios ten' ndyop reta men.” ¡Nde goꞌ mblilal ncheꞌ xaja ti yo tenꞌ ndyop re xaꞌ wanꞌ! ");
INSERT INTO ztp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nde re xaꞌ nak maestr ndlo' ley xkiꞌs Dios nde re ngwleyꞌ xa' nyebe' mbin xaꞌ re jwanꞌ nchab Jesús, zyasa tolo mkwanꞌ xaꞌ mod kuj xaꞌ Jesús, tak nzyeb xaꞌ, men toz nzoyen re jwanꞌ ndloꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Senꞌ ndela yalꞌ, zya mbroꞌ re xinꞌ teꞌd Xaꞌ yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mduxni tedib wiz, tilꞌ toz mbrid re xaꞌ tenꞌ ndob ya hig nde mbwiꞌ xaꞌ axta dib lox ya mbiz. ");
INSERT INTO ztp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Zyasa mtelaꞌs Pey nde nchab Pey lo Jesús: —Maestr, bwiꞌ, leꞌ ya hig ta mkeꞌdea ya, mbiza. ");
INSERT INTO ztp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Leꞌ Jesús nchab: —Blipa lazoꞌ goꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tak nipa na lo goꞌ tez nzo xaꞌ naꞌakropta xgab naꞌ, nde li lazoꞌ xaꞌy tak jwanꞌ gab xaꞌ, toyal gab xaꞌ lo kox reꞌ: “Byib ncheꞌ nde wa yo lenꞌ nittoꞌ”, nde taka. ");
INSERT INTO ztp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jwanꞌ nasa nin lo goꞌ, reta jwanꞌ ta nya'b goꞌ lo Dios, bli lazoꞌ goꞌ ke taꞌ Xaꞌy nde ta aka. ");
INSERT INTO ztp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nde senꞌ lo ndyodiꞌsno goꞌ Dios, tez nzo kwan narax ndateno goꞌ ta men goꞌ, ndablo tiptane bri'd goꞌy yek goꞌ, tamod sa Xud naꞌ ndob lo beꞌ tonꞌ Xaꞌ re xken goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tak tez narita goꞌy tiptane yek goꞌ re jwanꞌ narax ndli men lo goꞌ, no Xud naꞌ ndob lo beꞌ, natonꞌta Xaꞌ re xken goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zyasa bere nda xaꞌ yez Jerusalén tedib gob. Nde laj ngete Jesús tenꞌ ndob yodoꞌ, tya mbyeꞌd re ngwleyꞌ xa' nyebe', re xaꞌ nak maestr ndlo' ley xkiꞌs Dios nde re xaꞌ nak sinꞌ lo men Israel. ");
INSERT INTO ztp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nde nchab xaꞌ lo Jesús: —¿Kon cho yalnyebeꞌ ndlia re jwanꞌ reꞌ nde cho mdaꞌ diꞌs sa ndlia le? ");
INSERT INTO ztp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Leꞌ Jesús mkab lo xaꞌ: —Tej na lo goꞌ kon cho yalnyebeꞌ ndlin re jwanꞌ reꞌ, tez kab goꞌ ti jwanꞌ nyabdiꞌs na lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Lo mblole Juan men? ¿Cho naka jwan' nde lo be' o naka chan' men? Pkab goꞌ lon. ");
INSERT INTO ztp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Zyasa mdodiꞌsno xaꞌ ta xaꞌ nde nchab xaꞌ: —Tez gab naꞌ: Lo be' mbro'y, nye xaꞌ lonꞌ: “¿Cho kwan liy nandlid lazoꞌ goꞌ xkiꞌs xaꞌ sa?” ");
INSERT INTO ztp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nde tez gab naꞌ: Chan' mena Per mzyeb xaꞌ ta gab xaꞌ, tak reta men ndli lazonꞌ ke Juan liga ngok tib xaꞌ mbyeꞌd mdaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Zyasa nchab xaꞌ lo Jesús: —Nanyet náꞌy. Leꞌ Jesús mkab lo xaꞌ: —Noga na natejta na lo goꞌ kon cho yalnyebeꞌ ndlin re jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zyasa mdobte Jesús mdej Xaꞌ re di's nabix, nchab Xaꞌ: —Ngo ti mbiꞌ mblo bin lus ub nde mtowꞌ xaꞌ dib tenꞌ nzo bina kon ke, mtoxkwaꞌ xaꞌ ti plo tenꞌ koꞌ xaꞌ nit ub nde mtoxkwaꞌ xaꞌ ti yo ke gap toz nda'b, ’nde mtanꞌno xaꞌy lo pla men sa li men sinꞌna nde leꞌ xaꞌ ngo ned ndya tij. ");
INSERT INTO ztp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Senꞌ ngoxo'b beꞌ mtelꞌ xaꞌ ti mos lo re xa' nge sin', sa kaya' mos ngud mke lo lus ub. ");
INSERT INTO ztp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Leꞌ re xaꞌ ta nzo lo sin', mxen xaꞌ mos, mkeꞌ xaꞌy nde mbloned xaꞌ mos ngen kwan mtelꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Zya bere mtel' xaꞌ tedib mos, per mbwadke xaꞌ mos axta mbwiꞌy yek mos, nde noga mblo's xa' mos ndya mos. ");
INSERT INTO ztp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bere mtelꞌ xaꞌ tedib mos nde mos reꞌ mbij xaꞌ; taga mblino xaꞌ tipla mos jwanꞌ mtelꞌ xaꞌ nak xwanꞌ lus ub, cho mos mke xaꞌy nde cho mos mbij xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’ Lulka ngeno xaꞌ tibnya xinꞌ xaꞌ jwanꞌ nke toz lazoꞌ xaꞌ, mtel' xa' or lo re xa' ya, nchab xaꞌ: “Te' xo'b yek xaꞌ xin' na re'.” ");
INSERT INTO ztp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Leꞌ re xaꞌ ta mbyanꞌ no lus ub ba, nchab xaꞌ lo ta xaꞌ: “Or re' yan'no dib jwan' re'. Yeꞌd goꞌ, kuj naꞌ or sa naꞌ kayaꞌ dib jwan' re', aka chanꞌ naꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nde mxen xaꞌ or, mbij xaꞌ or nde mblobi xaꞌ or tij tenꞌ nzo'b lus ub. ");
INSERT INTO ztp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Cho kwan li xaꞌ ta nak xwanꞌ lus ub? Ye'd xaꞌ nde lu'x xaꞌ reta men ta mbyanꞌno lus ub nde tayaꞌ xaꞌy lo tedib ned men. ");
INSERT INTO ztp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Cho nandlapta goꞌ jwanꞌ nchab lo xkiꞌs Dios? Leꞌ ke jwanꞌ mblo'tal xaꞌ ntaꞌ yo, ke ya ngok tib ke jwanꞌ ndenkeꞌ dib yo. ");
INSERT INTO ztp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios ta mtoxkwaꞌy; nde naya naka tib jwanꞌ nzoyen na'. ");
INSERT INTO ztp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zya mchal xa' nten xaꞌ Jesús, tak mne xaꞌ xis xaꞌ ndej Jesus kwent nabix. Per mzyeb xaꞌ reta men yaja mbla' xa' Jesus nde nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Zyasa mtelꞌ xaꞌ pla xaꞌ fariseo nde pla men Herodes, sa yana'bdiꞌs xaꞌ lo Jesús, benꞌ sa kwanꞌ xaꞌ mod keꞌ xaꞌ yalke yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Senꞌ mzin xaꞌ nchab xaꞌ: —Maestr, mne náꞌ li re jwanꞌ ndyodiꞌs la nde nandyod la re jwanꞌ ndyodiꞌs men xis la, neka ndlia xgab cho xaꞌy, tak lu benꞌta ndloꞌa jwanꞌ li, nyenꞌ xa xo'b yek men Dios. Jwanꞌ nasa nyabdiꞌs náꞌ loa: “¿Cho ndablo kix naꞌ tmi chanꞌ izyo lo Cesar o nakixta naꞌy? ¿Taꞌ naꞌy, o nata'd naꞌy?” ");
INSERT INTO ztp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Leꞌ Jesús mnela xgab narax jwanꞌ ndono re men ya nde nchab Jesús lo xaꞌ: —¿Cho kwan liy nkwanꞌ goꞌ yalke keꞌ goꞌ yek na? Deꞌno goꞌ ti tmi Rom, wiꞌn. ");
INSERT INTO ztp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Zya ngwano xaꞌy, leꞌ Jesús nchab: —¿Cho lo xa' nde cho le nke lo tmi reꞌ? Leꞌ re xaꞌ mkab, nchab xaꞌ: —Chan' Cesar. ");
INSERT INTO ztp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Leꞌ Jesús nchab: —Btaꞌ goꞌ lo Cesar jwanꞌ nak chanꞌ Cesar nde btaꞌ goꞌ lo Dios jwanꞌ nak chanꞌ Dios. Nde nzoyen toz xaꞌ xa mkab Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Zyasa mbyeꞌd pla xaꞌ saduceos lo Jesús, re xaꞌ jwanꞌ mbez: “Re men nguj naryoxbanta men.” Jwanꞌ nasa mna'bdiꞌs xaꞌ lo Jesús, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestr, lo ley jwanꞌ mkeꞌ Moisés nchab: “Tez ti xaꞌ biꞌ mselyaꞌ, nde naꞌnkad ngol xinꞌ xaꞌ tata nguj xaꞌ, tya sa wes thabol ndablo selyaꞌno ngol, sa tanꞌ xaꞌ bin wes xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ngo ti xaꞌ mkeno gaz wes naꞌ. Xaꞌ ner, mka xaꞌ ngol nde naꞌnkad ngol xinꞌ xaꞌ, tata nguj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tya sa xa' brop mka ngol nde taga' naꞌnkad ngol xinꞌ xaꞌ, tata nguj xaꞌ. Nde taga' ngotey kon xaꞌ byon. ");
INSERT INTO ztp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nde tamod ngotey kon re gaz wes xaꞌ. Nek thib xaꞌ na'mkad ngol xinꞌ xaꞌ nde ngolo mbri'd re xa' noga ngol nguj. ");
INSERT INTO ztp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Lo senꞌ ryoxban re xa', xanya xaꞌ ak salꞌ ngol, lo ta re gaz wes xaꞌ mdobno ngol? ");
INSERT INTO ztp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zyasa mkab Jesús, nchab Xaꞌ: —¡Mbwan yek goꞌ! Tak nanzolot goꞌ xkiꞌs Dios neka nye goꞌ yalne chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tak senꞌ ryoxban men xij re xa' nguj, nekla selyaꞌ men, nek yo yalselya', che'la ak men xa nak re Áng ta nzi lo beꞌ ba. ");
INSERT INTO ztp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Per jwanꞌ ta ryo'xban re xaꞌ nguja, ¿Cho na'ndlapta goꞌ yeꞌs mkeꞌ Moisés, jwan' xa mni Dios lo xaꞌ lo ya yis, ten' nchab Dios: “Na nak Dios lo Abraham, Dios lo Isaak nde Dios lo Jakob”? ");
INSERT INTO ztp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios na'nakta Xaꞌ Dios chan' re men nguj, leꞌ Xaꞌ nak Dios chan' re men naban. Nde goꞌ thitane mbwan yek goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tya ndo tib xaꞌ nak maestr ndlo' ley xkiꞌs Dios, mbin xaꞌ re jwanꞌ mdodiꞌsno Jesús xaꞌ saduceo, nde mbwiꞌ xaꞌ nawe mkab Jesús, zyasa mbike xaꞌ lo Jesús nde mnabdiꞌs xaꞌ, nchab xaꞌ: —¿Lo reta yalnyebeꞌ jwanꞌ ngebez Dios, xanyay nak jwanꞌ ner? ");
INSERT INTO ztp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús mkab: —Leꞌ yalnyebeꞌ ner lo retay nak: “Pto nza goꞌ, men Israel; leꞌ Dios naꞌ, Xaꞌ nyebeꞌ lonꞌ, thipta Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nde keꞌ lazoꞌa Dios Xa' Nyebe' loa dib nzo lazoꞌa, dib yalnaban chanꞌ la, dib xgab la nde dib yalne chanꞌ la.” Jwanꞌ reꞌ nak yalnyebeꞌ ndak toz lo retay. ");
INSERT INTO ztp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Leꞌ yalnyebeꞌ brop lal naka: “Pkeꞌ lazoꞌa ta men la xaja nkeꞌ lazoꞌa le'ga lu.” Naꞌngentra tedib yalnyebeꞌ ro toz xa nak jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Zyasa xaꞌ nak maestr nteꞌd ley xkiꞌs Dios, nchab: —¡Linka luy, maestr! ¡Li jwanꞌ ndej la! Tipta Dios nde naꞌngentra tedib Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Leꞌ jwanꞌ keꞌ lazoꞌ men Dios, dib nzo lazoꞌ men, dib xgab men, dib yalnaban chanꞌ men nde dib yalne chanꞌ men nde keꞌ lazoꞌ men ta men axaja nke' lazoꞌ men le'ga men, re jwanꞌ reꞌ ndak toz, lo reta jwanꞌ ta ndli xaꞌ, nguj xaꞌ maꞌ sa taꞌ xaꞌ gon lo Dios. ");
INSERT INTO ztp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mbwiꞌ Jesús nawe mkab xaꞌ liga nchen xaꞌ xkiꞌs Dios, sa nchab Jesús lo xaꞌ: —Nandod la tij lo yalnyebeꞌ chan' Dios. Yaja nek thib men naꞌnabdiꞌstra xa' lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Laj ngeloꞌ Jesús xkiꞌs Dios lo men tenꞌ ndob yodoꞌ, zya mnabdiꞌs Jesús, nchab Xaꞌ: —¿Cho kwan ndliy re xaꞌ nak maestr ndlo' ley xkiꞌs Dios, mbez xaꞌ: “Lo bin David ye'd Xaꞌ telꞌ Dios”? ");
INSERT INTO ztp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tak yub David mni senꞌ ndono xaꞌ Mbi Nayon chanꞌ Dios, nchab xaꞌ: Leꞌ Dios nchab lo Xaꞌ Nyebeꞌ lon: “Ptob lad ban na, kebeꞌ lin sa lyayo re xaꞌ jwanꞌ nayiꞌ loa.” ");
INSERT INTO ztp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yub David mbez leꞌ Crist nak “Xaꞌ Nyebeꞌ lo David”. ¿Xamod yed Crist lo bin David sa? Nde bro toz men yez, nale ngo lazoꞌ xaꞌ mbin xaꞌ xkiꞌs Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Xij ngetoted Jesús men, nchab Xaꞌ: —Kenap toz goꞌ lo re xaꞌ nak maestr ndlo' ley xkiꞌs Dios, tak re xaꞌ reꞌ ndyen xaꞌ gok xaꞌ lar nolꞌ jwanꞌ ntak toz nde ndyen xaꞌ ni men dyux lo xaꞌ lo xbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nde nkwanꞌ xaꞌ jwin' tyobzaꞌ xaꞌ lenꞌ yo tenꞌ ndyop men Israel, taga senꞌ wa xaꞌ, nkwanꞌ xaꞌ tenꞌ jwin nya tyobsa' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nde nkib xaꞌ liz re ngol nguj salꞌ naꞌ, taja nolꞌ toz ndyodiꞌsno xaꞌ Dios sa tyak men naxut toz nak xaꞌ. Re xaꞌ reꞌ naro toz nak yalti kayaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús ndob gax ro yodoꞌ tenꞌ ndob jwanꞌ ngo xaꞌ tmi yon, ndowiꞌ Jesus xa ngo re men tmi tya, nar xaꞌ rik bro tmi ngo xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nde mzin ti ngol prob nguj salꞌ naꞌ, ndeno xaꞌ chop tmi jwanꞌ lud ntak nde mblo xaꞌy tya. ");
INSERT INTO ztp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zyasa mbrez Jesús re xinꞌ teꞌd Xaꞌ, nchab Xaꞌ: —Nipa na lo goꞌ, ngol prob ta nguj salꞌ naꞌ reꞌ, bro toz tmi mblo xaꞌ ke lo reta men. ");
INSERT INTO ztp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tak reta men, tmi jwanꞌ mbroxo'b lo xaꞌ, tmi ya mdaꞌ xaꞌ. Nde ngol reꞌ, reta tmi jwanꞌ nden xaꞌ, tyuꞌ jwanꞌ wa xaꞌ, retay mdaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Senꞌ ndaroꞌ Jesús tenꞌ ndob yodoꞌ, tib xinꞌ teꞌd Jesús nchab: —¡Maestr, bwiꞌ xa nawe nya re ke naksaꞌ yodoꞌ reꞌ nde nawe nya diba! ");
INSERT INTO ztp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mkab Jesús lo xa', nchab Jesús: —¿Cho ngwiꞌa dib yodoꞌ ro reꞌ? Nek thib ke ba nayaꞌntay xis ta ne'y, retay yub. ");
INSERT INTO ztp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zyasa nda xaꞌ tenꞌ ndole kox ya Olib, tenꞌ ndloꞌ ndob yodoꞌ. Tya mdob Jesús, leꞌ Pedr, Jakob, Juan nde Ndres, xaꞌta mnabdiꞌs xaꞌ lo Jesús, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Btej lo náꞌ. ¿Pol ak re jwanꞌ reꞌ? ¿Nde kwan libeꞌ men senꞌ lo tyobte aka? ");
INSERT INTO ztp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Leꞌ Jesús nchab: —Nda wiꞌ toz goꞌ sa nek thib men nakwinꞌnoda xa' goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tak nar toz xaꞌ ye'd nde nye xaꞌ: “Na nak Crist, Xaꞌ mtelꞌ Dios”. Nde bro toz men kwin'no xa'. ");
INSERT INTO ztp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nde senꞌ lo gon goꞌ nzo yalbyo nde nzo'b diꞌs yora yalbyo, nazyepta goꞌ, tak nakiꞌnka ta aka nde na'nakta jwanꞌ nata mney. ");
INSERT INTO ztp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Zyara' yo re yez kon yez nde rey kon rey; nde na'r toz tenꞌ win xo nde taja yo win, zya anta ndryoꞌ men karrel, jwanꞌ re' nak xanꞌ re yalti jwan' ye'd. ");
INSERT INTO ztp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Lega goꞌ, nda wiꞌ toz goꞌ, tak tayaꞌ men goꞌ lo re xaꞌ nak sinꞌ nde lenꞌ yo tenꞌ ndyop men Israel tya kin xaꞌ goꞌ. We xaꞌ goꞌ lo re xaꞌ nyebeꞌ lo reta yez nde lo rey tak ndli lazoꞌ goꞌ na, tya tej goꞌ na lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nde ndablo nerla diꞌs wen chanꞌ Dios ryaꞌs dib xis izyo. ");
INSERT INTO ztp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nde senꞌ nda xiꞌ xaꞌ goꞌ sa tayaꞌ xaꞌ goꞌ lo xaꞌ nak sinꞌ, nalit goꞌ xgab xamod kab goꞌ, tak Dios tob diꞌs ro goꞌ sa kab goꞌ nde nakta goꞌ jwanꞌ todiꞌs zya, Mbi Nayon chanꞌ Dios todiꞌs. ");
INSERT INTO ztp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nde nzo xaꞌ tayaꞌ lega wes xaꞌ sa kuj men xaꞌ, xud xaꞌ tayaꞌ xinꞌ xaꞌ nde xinꞌ xaꞌ yo xud xaꞌ nde kuj xaꞌ xud xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nde reta men yiꞌno xaꞌ goꞌ tak ndli lazoꞌ goꞌ na. Leꞌ goꞌ jwanꞌ ne ndo lo xkiꞌs Dios, xek goꞌ kebeꞌ yolo reta jwanꞌ reꞌ, men ya kayaꞌ yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Men ndlab, xaꞌ ya yen diꞌs jwanꞌ mkeꞌ profet Daniel nchab xa': “Senꞌ lo wiꞌ goꞌ ndoyak jwanꞌ narax nakap toz nya tenꞌ nandabloda aka”, zyasa bxonꞌ goꞌ, leꞌ reta men nzi lo xyon Judea, xyonꞌ xaꞌ nda xaꞌ yek yi'. ");
INSERT INTO ztp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Leꞌ xaꞌ ndo yek yo, lya xaꞌ nde na'yoted xaꞌ lenꞌ yo sa kote xaꞌ chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nde xaꞌ jwanꞌ nke sinꞌ wan, na'beretra xaꞌ sa we xaꞌ xab xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nalat tyák re ngol nzo xinꞌ nde re ngol jwanꞌ ngeno mbed mey wiz ya. ");
INSERT INTO ztp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mna'b toz goꞌ lo Dios, sa naꞌakta jwanꞌ reꞌ senꞌ nxyo'b yop. ");
INSERT INTO ztp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tak re wiz ya jwanꞌ toz yo yalti, ti yalti jwanꞌ nanchoda xata mtoxkwaꞌ Dios izyo nde axta naya nde na'yotray tedib gob. ");
INSERT INTO ztp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nde tez Xaꞌ Nyebeꞌ taꞌ diꞌs bro yo yalti, nek tib men nabantra; benꞌta tak nkeꞌ lazoꞌ Dios re men jwanꞌ mbli Xaꞌ, jwanꞌ nasa lud taꞌ Xaꞌ diꞌs yo yalti. ");
INSERT INTO ztp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Zyasa tez nzo men nye lo goꞌ: “Bwiꞌ goꞌ, xaꞌ reꞌ nak Crist xaꞌ mtelꞌ Dios”, “Bwiꞌ goꞌ, leꞌ Xaꞌ ndo ba”, nalid lazoꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tak zya ye'd re xaꞌ kwinꞌ gab xaꞌ, “xa' nak Crist nde xa' nak profet” nde li xaꞌ re yalnaro jwanꞌ nzoyen men, sa kwinꞌno xaꞌ men, axta noga re men jwanꞌ mbli Dios, chal xaꞌ kwin'no xaꞌ men ya. ");
INSERT INTO ztp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jwanꞌ nasa nda wiꞌ toz goꞌ; tak mdej la nay lo goꞌ nal tera aka. ");
INSERT INTO ztp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lenꞌ wiz ya, senꞌ mne mbrid reta yalti toz, leꞌ wiz na'toxnitray nde mbeꞌ natatray xni, ");
INSERT INTO ztp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nde reta mbel nzi lo beꞌ ryo'ndaba nde re yalne naro toz nzo lo beꞌ, xi'da. ");
INSERT INTO ztp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Zyasa wiꞌ goꞌ, Xinꞌ Mbiꞌ mbyeꞌd lo izyo, ye'd Xaꞌ xij xkow, ye'dno Xaꞌ yalne toz nde dib yalnaro chanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nde zya telꞌ Xaꞌ reta Áng Xaꞌ, nde thop Áng reta men jwanꞌ mbli Dios dib nax xis izyo, axta ploja tenꞌ mdib izyo nde mdib beꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Pteꞌd goꞌ di's nabix chan' ya hig: Senꞌ ndryo'xo'b re xod yen'na nde ndryo'xo'b re la yenꞌ lo xod, mne goꞌ leꞌ beꞌ yi ndea gax. ");
INSERT INTO ztp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nde taga jwanꞌ goꞌ, senꞌ mne go' ndoyakla reta jwanꞌ reꞌ, ndablo nye goꞌ leꞌ wiz yed Xaꞌ, ndosin gaxla. ");
INSERT INTO ztp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lipa nin lo goꞌ, reta jwan' re' ak sen' tera' lux reta men ta nzi naya. ");
INSERT INTO ztp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Le' beꞌ nde izyo tluxa, per re xkiꞌs na na'luxtay. ");
INSERT INTO ztp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Per wiz ya nde hor ya ngenta cho nyey, nekla re áng nzi lo beꞌ, nde nekla Xinꞌ Mbi' naꞌnyeday, benꞌta Pay mney. ");
INSERT INTO ztp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jwanꞌ nasa, brena goꞌ nde ptodiꞌsno goꞌ Dios, tak na'nyed goꞌ pol yoxo'b beꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Naka xa ti mbiꞌ mbroꞌ nda tij, mtanꞌno xa' liz xaꞌ lo men nde mda' xa' yalnyebe' lo re mos, nde kad thiba xaꞌ sinꞌ li xa' nde mnabeꞌ xaꞌ tyobna xaꞌ jwanꞌ kenap ro yo. ");
INSERT INTO ztp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Taga goꞌ, brena goꞌ, tak na'nyed goꞌ pol bere xaꞌ nak liz; cho ndakow izyoy, cho rol yalꞌ la, senꞌ mbez ngidteꞌy, o ndatuxni izyoy, ");
INSERT INTO ztp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa sen' lo xajta sin xaꞌ, naꞌyosibta xaꞌ goꞌ nziyat goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nde jwanꞌ ta ntej na lo goꞌ reꞌ, lo reta men ntej nay: Brena goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ndab ti chop wiz sin Pask nde ni chanꞌ pan ngenta lebadur, nde re xaꞌ nak ngwleyꞌ ro nde re xaꞌ jwanꞌ nak maestr nteꞌd ley xkiꞌs Dios, nkwanꞌ xaꞌ mod sa kon yalkwinꞌ kuj xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nde nchab xaꞌ: —Na'lid naꞌy lenꞌ wiz ni reꞌ, sa naꞌakxolta re men. ");
INSERT INTO ztp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Per Jesús nkete yez Betania, liz Simón xaꞌ jwanꞌ mxak yiz tin ndole lepra, laj nzi xaꞌ ro mes, mzin ti ngol ndeno ti bot naksaꞌ ke ndole alabastro, sey nzo nit naxeꞌ napta aceit nardo nde nap toza. Zyasa mdiꞌs ngol yen bot naksa' ke, mchub ngola yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nde ngo pla xaꞌ nayiꞌ xija, nchab xaꞌ lo ta xaꞌ: —¿Kwan liy sa taja ntoti ngol nit naxe' ba? ");
INSERT INTO ztp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tak ntoyal ntho xa'y nde taꞌy tmi jwanꞌ ndli men gan dib ti linꞌ, nde tmi ya ntaꞌ xa' lo re men prob. Mod re' mdodiꞌs xaꞌ xis ngol. ");
INSERT INTO ztp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Leꞌ Jesús nchab lo xaꞌ: —Blaꞌ goꞌ ngol, ¿Kwan liy ta mbez go' lo ngol? Wen nkeli ngol lon. ");
INSERT INTO ztp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Re men proba thibka nzino goꞌ xaꞌ nde choja wiz ncholaꞌs goꞌ laꞌsto goꞌ xaꞌ toyala; per na na'ndonod go' na dib tyemp. ");
INSERT INTO ztp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ngol reꞌ mbli xaꞌ jwan' mbli xaꞌ gan, tak nkenla ngol mblo xa' nit naxe' dib na sen' sin wiz ga's na. ");
INSERT INTO ztp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Lipa nin lo goꞌ, one ploja tej men diꞌs wen chanꞌ Dios, lo dib nax izyo, noga tej xa' jwanꞌ ta mbli ngol reꞌ, sa telaꞌs men ngol. ");
INSERT INTO ztp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zyasa Judas Iscariote, ti xaꞌ jwanꞌ nakwent lo re tib sen xinꞌ teꞌd Jesús, ngwa xaꞌ lo re xaꞌ nak ngwleyꞌ ro, sa tayaꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Senꞌ mbin re xaꞌ nak sin' jwanꞌ reꞌ, ndyen toz xaꞌ, nde mkeꞌyek xaꞌ kix xaꞌ ka Judas. Le' Judas mkwanꞌ mod nyenꞌ xa tayaꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Wiz ner senꞌ nchal ni ncha xaꞌ pan ngenta lebadur, sen' nchuj xaꞌ mbakxilꞌ lo Pask, zyasa re xinꞌ teꞌd Jesús nchab: —¿Plo ncholaꞌs la ya toxkwan' jwanꞌ wanꞌ lo ni Pask? ");
INSERT INTO ztp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nde mtel' Jesús chop xinꞌ teꞌd Xaꞌ, nchab Xaꞌ: —Wa goꞌ yez sa tya yosib goꞌ ti xaꞌ biꞌ ndano tib ré nit. Ptonke goꞌ xis xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","nde tenꞌ ndob yo sin xaꞌ, tya nyabdiꞌs goꞌ lo xaꞌ nak liz yo, gab goꞌ: “Leꞌ Maestr nyabdiꞌs: ¿Plo taꞌ goꞌ wa rsyeꞌ Xaꞌ kon re xinꞌ teꞌd Xaꞌ lo Pask reꞌ?” ");
INSERT INTO ztp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nde xa' loꞌ lo goꞌ ti yo ro chop xtaꞌ gap tenꞌ naksaꞌla; tya toxkwaꞌ goꞌ jwanꞌ wanꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ngwa rop xaꞌ nak xinꞌ teꞌd Jesús, mzin xaꞌ lenꞌ yez nde xata nchab Jesús lo xaꞌ, ta ngoka nde tya mtoxkwaꞌ xaꞌ jwanꞌ wa xaꞌ lo Pask. ");
INSERT INTO ztp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nde senꞌ mbla yalꞌ, mzin Jesús kon re tib sen xinꞌ teꞌd Xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nde senꞌ mblatob re xaꞌ ro mes, laj nzi ya xaꞌ, Jesus nchab lo xa': —Lipa nin lo goꞌ, xij goꞌ reꞌ nzo tib xaꞌ jwanꞌ ndob yanon, xaꞌ ya tayan'. ");
INSERT INTO ztp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Zyasa ndolo ngo nabil lazoꞌ re xaꞌ nde nchab xa' lo ta xa': —¿Cho nay? ");
INSERT INTO ztp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Leꞌ Jesús mkab, nchab Xa': —Xij re tib sen goꞌ reꞌ, nzo tib goꞌ jwanꞌ thipta ndo gaz pan naꞌ lenꞌ yen na, xaꞌ yay. ");
INSERT INTO ztp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Liga leꞌ Xinꞌ Mbiꞌ nakiꞌnka gaj Xaꞌ, jwan' xa nchabka lo xki's Dios, per ¡nalat toz nya mbi' jwanꞌ tayaꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo reꞌ! Wen toz nda mbiꞌ ya tez naꞌngalta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nde laj nzi ya re xaꞌ, mxen Jesús pan nde mbli leyꞌ Xaꞌy, nde mchix Xa'y, mdaꞌ Xaꞌy lo re xinꞌ teꞌd Xaꞌ, nchab Xaꞌ: —Bda goꞌy, jwanꞌ reꞌ nak belꞌ na. ");
INSERT INTO ztp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nde mxen Jesus jwanꞌ nzo nit ub, nde ngolo mdaꞌ Xaꞌ dyux lo Dios, mdaꞌ Xaꞌy lo re xinꞌ teꞌd Xaꞌ, nde ngu' reta xa'y. ");
INSERT INTO ztp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nde nchab Jesús: —Jwanꞌ reꞌ nak ren na, jwan' mda' nakub Dios xkiꞌs Xaꞌ, ren reꞌ xyoy par bro toz men. ");
INSERT INTO ztp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lipa nin lo goꞌ na'gutra na nit ub re' tedib gob, axta kebeꞌ gun nit ub kub ten' nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Senꞌ ngolo mbilꞌ xaꞌ salmo, mbroꞌ xaꞌ nda xaꞌ yek yi' Olib. ");
INSERT INTO ztp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zyasa nchab Jesús lo re xa': —Nayal' re' ta'b go' xgab go' lon, tak lo xkiꞌs Dios nchab: “Guj na Xaꞌ ndowa mbakxilꞌ nde ryaꞌs reta mbakxilꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lo senꞌ ngolo ryoxban na, ner na siblo lo goꞌ sin na Galilea. ");
INSERT INTO ztp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Zyasa Pey nchab lo Jesús: —¡Tenye reta xaꞌ ta'b xa' xgab xa' loa, na naꞌlit nay! ");
INSERT INTO ztp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Leꞌ Jesús nchab lo Pey: —Lipa nin loa le' lu, nayalꞌ reꞌ, senꞌ tera' kwez ngidteꞌ mbrop gob, lu mbyon la gob gab la, na'nzolot la na. ");
INSERT INTO ztp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Leꞌ Pey masraꞌ mdosaꞌ nchab Pey: —Te'nye mbij xa' na, na'lat na lu. Noga reta xa' taga' nchab xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ngolo jwanꞌna, nda xaꞌ tenꞌ ndole Getsemaní, nde nchab Jesús lo re xinꞌ teꞌd Xaꞌ: —Ncheta bre goꞌ, laja na nda todiꞌsno Dios. ");
INSERT INTO ztp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nde mbeꞌ Jesús Pey, Jakob nde Juan, nde ngonabil lazoꞌ Jesús, narax mxak Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nde nchab Xaꞌ: —Nabil toz nzo lazoꞌn, axta gaj na; ncheta byanꞌ goꞌ nde brena goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mde Jesús tud tya, mdoxub Xaꞌ mdinꞌ yek Xaꞌ izyo, nde mna'b Xaꞌ lo Dios, nyenꞌ cho toyal na'rita Xaꞌ lo yalti. ");
INSERT INTO ztp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nchab Xaꞌ: —¡Pay, Xud na! reta jwanꞌ toyal lia; nata'd la diꞌs rid na lo re yalti reꞌ, per nagaktay xa ncholas na, gaka xa ncholaꞌs la. ");
INSERT INTO ztp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Zyaga mbere Jesús nde ngosi'b Jesús re xaꞌ, nzi yat xaꞌ; nde nchab Jesus lo Pey: —Simón, ¿cho naxyat la? ¿Cho nek ti hor na'xekta la tyobnaa? ");
INSERT INTO ztp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Brena goꞌ nde ptodiꞌsno goꞌ Dios, sa na'tokil'ta maxuꞌ goꞌ; xbin men liga ndosaꞌy, per belꞌ men na'xektay. ");
INSERT INTO ztp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngwa todiꞌsno Jesús Dios tedib gob, le'ga re diꞌs ya nchab Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Senꞌ mbere Jesus, bere ngosi'b Xaꞌ re xinꞌ teꞌd Xaꞌ nzi yat re xa', tak xekta ngudlo xaꞌ ncho mkalꞌ nde nanyet xaꞌ kwan kab xaꞌ lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lo ngoxo'b byon gob mbere Jesús, nchab Xaꞌ: —¿Cho tatka nzi yat goꞌ nde nzi roxkwen goꞌ? ¡mney! mzin hor, naya taya' xa' Xinꞌ Mbiꞌ lo yaꞌ re men nzob xkenꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Goche goꞌ sa ndan', tak gax la nde xaꞌ jwanꞌ tayaꞌn. ");
INSERT INTO ztp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Laj benꞌ ndotodiꞌs Jesús, mzin Judas, ti xaꞌ jwanꞌ nakwent lo re tib sen xinꞌ teꞌd Jesus, ndeno xaꞌ bro toz men, kon espad nde ya, reta xaꞌ reꞌ mtelꞌ re xaꞌ nak ngwleyꞌ ro, re maestr ndlo' ley xkiꞌs Dios nde re xaꞌ jwanꞌ nak sinꞌ lo men Israel. ");
INSERT INTO ztp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tak xaꞌ jwanꞌ tayaꞌ Jesús, mbyanꞌdiꞌsla xaꞌ lo reta men ndano xaꞌ, nchab xaꞌ: —Xaꞌ jwanꞌ tan chut lad kwat na, Xaꞌ yay; tyen goꞌ Xaꞌ nde nata'd goꞌ diꞌs lyaꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nde senꞌ mzin Judas, zyaga mbike xaꞌ gax lo Jesús nde nchab xaꞌ: —¡Maestr, maestr! Nde mdaꞌ xaꞌ chut kwat Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Zyasa reta xa' ya mblo' ya xa' nde mxen xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per ti xaꞌ jwanꞌ ndo tya, mbloꞌte xaꞌ espad, mchoꞌ xaꞌ nza ti xaꞌ jwanꞌ nak sinꞌ lo mbol nglweyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Leꞌ Jesús mkab, nchab Xaꞌ: —¿Xaja men ndexen ti wan'na nde go' kon espad nde kon ya ndexen goꞌ na? ");
INSERT INTO ztp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Reta wiz mdon xij goꞌ mbloꞌn xkiꞌs Dios tenꞌ ndob yodoꞌ, nde na'ndenta goꞌ na; per taga gaka, sa ak jwanꞌ nchab lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Zyasa reta xa' nak xinꞌ teꞌd Jesús, mxonꞌ xaꞌ, mblaꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per ngo ti mbyo yenꞌ mdonke xis Jesús, benꞌ tib ble lar nachal or; nde mxen xa' or. ");
INSERT INTO ztp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Le' mbyo ya mbla'r lar nachal or, tata cheyꞌ or mxonꞌ or. ");
INSERT INTO ztp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Zyasa mzin no xaꞌ Jesús lo mbol ngwleyꞌ ro; nde tya mdyop re xaꞌ nak ngwleyꞌ nyebe', reta xaꞌ jwanꞌ nak sinꞌ lo men Israel nde re xaꞌ jwanꞌ nak maestr ndlo' ley xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Leꞌ Pey tij tij mdonke xaꞌ xis Jesús ngote xaꞌ lo le chan' mbol ngwleyꞌ ro; nde nzo Pedr xij re xaꞌ nkenap yodoꞌ, nzi bis xaꞌ lo ki. ");
INSERT INTO ztp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Leꞌ re xaꞌ jwanꞌ nak ngwleyꞌ nyebe' nde reta ta nak sinꞌ xaꞌ, nkwanꞌ xaꞌ cho yalke nchap Jesús sa tayaꞌ xaꞌ Jesús lo yalguj, nde nek thib yalke naꞌngasalta xaꞌ . ");
INSERT INTO ztp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tenye nar xaꞌ mdej diꞌs kwinꞌ xis Jesús per na'nsal'ta xki's xa'. ");
INSERT INTO ztp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Zyasa mdoli pla xaꞌ, mdej diꞌs kwinꞌ xis Jesus, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Mbin náꞌ cheꞌ nchab xaꞌ reꞌ: “Sil na yodoꞌ ta mtoxkwaꞌ ya' mena nde lenꞌ sonta wiz toxkwan tediba jwan' na'toxkwa'da men.” ");
INSERT INTO ztp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per nekla ta na'nsal'ta xki's xa' lo jwan' ndej xa'. ");
INSERT INTO ztp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Zyasa le' mbol ngwleyꞌ ro, mtoli xa' xij re men nzi tya, mna'bdiꞌs xaꞌ lo Jesús nchab xaꞌ: —¿Cho ngen kwan kab la? ¿Cho li jwanꞌ ta mbez re men reꞌ xisla? ");
INSERT INTO ztp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Leꞌ Jesús mtow' ro Xa' nde ngen kwan nkab Xaꞌ. Leꞌ mbol ngwleyꞌ ro bere mnabdiꞌs xaꞌ lo Jesús, nchab xaꞌ: —¿Cho lu nak Crist, Xinꞌ Xa' Nayon? ");
INSERT INTO ztp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Leꞌ Jesús nchab: —Nay; nde wiꞌ goꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo, tyob Xa' lad ban Dios tenꞌ nzo yalne toz, nde ye'd Xa' xij xkow lo be'. ");
INSERT INTO ztp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Zyasa leꞌ mbol ngwleyꞌ ro, mched xaꞌ xab xaꞌ, nchab xaꞌ: —¿Cho kwanra' mas ngembed na' men taꞌ kwent? ");
INSERT INTO ztp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Mbinla goꞌ, diꞌs xin mni Xaꞌ! ¿Xa ngwiꞌ goꞌ di's ba? Zyasa reta xaꞌ nchab: —¡Liga nchap Xaꞌ yalke, ndablo gaj Xaꞌ! ");
INSERT INTO ztp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nde pla men ntolo mzuk xa' lo Jesús, mtowꞌ xaꞌ lo Jesús nde mdin xaꞌ Jesús, nchab xaꞌ: —¡Btej, nyenꞌ cho nkeꞌy choa! Leꞌ re xaꞌ nkenap yodoꞌ taga mdin xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Leꞌ Pey ndo lo le lad la, tya ndarid tib ngol nge sinꞌ lo mbol ngwleyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Senꞌ mbwi' ngol ndobis Pey lo ki, xe mbwiꞌ ngol lo Pey, nchab ngol: —No lu mketenke xis Jesús, xaꞌ yez Nazaret. ");
INSERT INTO ztp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Leꞌ Pey mkalaꞌs, nchab Pey: —Na'nzolot na Xaꞌ, nanyet na kwan ta mbez la. Nde mbroꞌte Pey le; zyaga mbil' ngidteꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Leꞌ ngol ya, mbwiꞌ ngol Pey tedib gob, ntolo mtobte nchab ngol lo re xaꞌ nzi tya: —No xaꞌ reꞌ mketenke xis Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Le' Pey bere mkala's tedib gob. Nde tud la ndatey, re xaꞌ nzi tya bere nchab xaꞌ lo Pey: —Liga noga lu nak ti xaꞌ ta mketenke xis Jesús; tak men Galilea nak la, nde xaxa ndyodiꞌs re xa' ya taxa ndyodi's la. ");
INSERT INTO ztp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Zyasa ntolo mni xin Pey nde mke'ro Pey nchab Pey: —Na'nzolot na mbi' ta ndej goꞌ lon ba! ");
INSERT INTO ztp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nde zyaga mbil' ngidteꞌ mbrop gob. Zya mtelaꞌs Pey diꞌs jwanꞌ nchab Jesús lo Pey: “Senꞌ tera gol ngidte' brop gob, leꞌ lu mbyonla gob gab la nanzolot la na.” Nde mte'laꞌs Pey jwanꞌna, mbinꞌ Pey. ");
INSERT INTO ztp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tedib wiz til' toz, sen' ngolo mdodi's reta xaꞌ nyebeꞌ lo re men Israel, re xa' nak ngwleyꞌ nyebe', re xaꞌ nak sinꞌ lo men Israel nde re maestr ndlo' ley xkiꞌs Dios, nago Jesus mbe' xa' Xaꞌ, nde mda'ya' xa' Jesus lo Pilat. ");
INSERT INTO ztp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Leꞌ Pilat mnabdiꞌs lo Jesús, nchab xaꞌ: —¿Cho lu nak Rey lo re men Israel? Jesús mkab nde nchab Xaꞌ: —Lu ney. ");
INSERT INTO ztp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Leꞌ re xa' nak ngwleyꞌ nyebe' jwanꞌ toz mkeꞌ xaꞌ yalke yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bere mnabdiꞌs Pilat lo Jesús tedi gob, nchab xaꞌ: —¿Cho ngen kwan kab la? ¡Bwiꞌ, plopa yalke nkeꞌ men yek la! ");
INSERT INTO ztp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Leꞌ Jesús nekla lo jwan' na naꞌnkabta Xaꞌ; zyasa nzoyen toz Pilat. ");
INSERT INTO ztp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Le' naya, senꞌ nchal ni chanꞌ Pask ndla' xa' ti xaꞌ nke liz yi'b, choja xaꞌ jwan' nchola's xa' ryoꞌte. ");
INSERT INTO ztp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nde ngo ti xaꞌ ndole Barrabás, nke xa' liz yi'b kon tipla ta xaꞌ jwan' mbij xa' men lo byo. ");
INSERT INTO ztp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nde lo mzin reta men, mdobte mna'b xaꞌ lo Pilat jwan' xa ndliga xa' re len' lin'. ");
INSERT INTO ztp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Leꞌ Pilat mkab, nchab Pilat lo reta xa': —¿Cho ncholaꞌs goꞌ lan Xaꞌ ta nak Rey lo re men Israel? ");
INSERT INTO ztp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tak mne Pilat ke re xa' nak ngwleyꞌ nyebe' ben' por ngiꞌno xaꞌ Jesús sa mdayaꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Leꞌ re xa' nak ngwleyꞌ nyebe' mblo xaꞌ yek reta men sa mna'b xaꞌ mas jwin ryo'te Barrabás. ");
INSERT INTO ztp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bere mkab Pilat nchab xa' lo reta men: —¿Cho kwan ncholaꞌs goꞌ li non Xaꞌ ta mbez goꞌ nak Rey lo re men Israel? ");
INSERT INTO ztp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nde reta men ne mbrez xa', nchab xa': —¡Bkeꞌ Xaꞌ lo kruz! ");
INSERT INTO ztp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Leꞌ Pilat nchab lo xaꞌ: —¿Cho yalke mbli Xa'? Per masra' ne mbrez reta men, nchab xa': —¡Bkeꞌ Xaꞌ lo kruz! ");
INSERT INTO ztp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nde Pilat ndyen xa' li xa' jwan' nya'b reta men, mbloꞌte xa' Barrabás, nde mdaya' xa' Jesus, sen' mne mdin xa' Jesus, ke' xaꞌ Jesús lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Zyasa re soldad mbeꞌ xaꞌ Jesús len' yo, lo le chanꞌ yolow, nde mbrez xaꞌ reta soldad. ");
INSERT INTO ztp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nde mxo'b xaꞌ ti lar konch nane xis Jesus, nde mdob xaꞌ ti koron naksa' yis yek Jesús, ");
INSERT INTO ztp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","mdobte mni xaꞌ dyux lo Jesús, nchab xa': —¡Naro nak Rey lo re men Israel! ");
INSERT INTO ztp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nde mkeꞌ xaꞌy yek Jesus kon tible ya, nde mzuk xaꞌ lo Jesús, nde mdoxub xaꞌ lo Jesus xaga ti lo rey. ");
INSERT INTO ztp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Senꞌ mne mbloꞌs xaꞌ Jesús, mkib xaꞌ xab rey xis Jesús nde mxo'b xaꞌ le'ga xab Jesús xis Jesús, nde mbroꞌteno xaꞌ Jesús sa keꞌ xaꞌ Jesús lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nde mna'b xa ti lo mbiꞌ jwan' ndarid tya, Simon xa' yez Ciren, xud Lejantr nde xud Ruf, mbro' xa' lo sin' wan, nde mnabeꞌ xaꞌ lo Simón sa we xaꞌ kruz Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nde mbe' xaꞌ Jesús ti tenꞌ ndole Gólgota. (Diꞌs reꞌ nak: Cho yek men.) ");
INSERT INTO ztp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nde mdaꞌ xaꞌ nit ub nos mirra gu Jesús, per na'ngud Xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Senꞌ ngolo mkeꞌ xa' Jesús lo kruz, ndolo mdij xaꞌ sa nyenꞌ xanya xab Jesús dinꞌ tiba xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Senꞌ ndyekela wiz mkeꞌ xaꞌ Jesús lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nde yalke jwan' mke' xa' yek Jesus, nchaba: “REY LO RE MEN JUDIO.” ");
INSERT INTO ztp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nde noga chop xaꞌ wanꞌ mke' xa' cho Jesus, tib xaꞌ mke lad ban nde tedib xaꞌ mke lad beg. ");
INSERT INTO ztp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nde ngok jwanꞌ nchab lo xkiꞌs Dios: “Thipta mblo' men kwent Xa' kon re men nzo'b xkenꞌ.” ");
INSERT INTO ztp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nde re men ndarid tya mbloꞌs xaꞌ Jesús, nkwin xaꞌ yek xaꞌ, nchab xaꞌ lo Jesús: —Maga lu mbez, sil la yodoꞌ chanꞌ Dios nde lenꞌ son wiz tokub lay, ");
INSERT INTO ztp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ptolaꞌ lega lu, nde bla lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nde noga re xa' nak ngwleyꞌ nyebe' nde re xaꞌ nak maestr ndlo' ley xkiꞌs Dios, taga' mbloꞌs xaꞌ Jesús, nchab xaꞌ lo ta xaꞌ: —Xaga xaꞌla re men mtola' Xa' nde le'ga Xa' naꞌakta tolaꞌ Xaꞌ lazo' Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Crist, Rey lo men Israel, bla lo kruz naya, sa wiꞌ ná' nde li lazoꞌ ná' lu. Nde noga xaꞌ jwanꞌ nke lo kruz cho Jesús, mbloꞌs xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Senꞌ rolja wiz, mblato yalꞌkow dib nax izyo axta bzye. ");
INSERT INTO ztp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nde bzye ya mbrez yaj Jesús nchab Xaꞌ: —Eloi, Eloi, ¿lama sabaktani? (Diꞌs ya nak: Dios na, Dios na, ¿Cho kwan liy mblaꞌ ya'a na?) ");
INSERT INTO ztp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nde pla xaꞌ nzi tya, lo mbin xaꞌ ta mbrez Jesus, nchab xaꞌ: —Bwiꞌ goꞌ, ngebez Xaꞌ Elias. ");
INSERT INTO ztp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nde mke' ti xaꞌ karel, mbwaz xa' ti xilꞌ lo nit ub mbyál nde mtob xaꞌy ti lo ya, mda' xaꞌy ngu' Jesús, nchab xaꞌ: —Naa sa win' nyenꞌ cho tye'd la Elías Xaꞌ lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Le' Jesus, mbrez yaj Xa', nguj Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Zyasa lar nge tenꞌ Nayon lenꞌ yodoꞌ, chop mble ngoka, xata gap nde axta la. ");
INSERT INTO ztp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Leꞌ xaꞌ nyebeꞌ lo tib ayoꞌ sondad ta ndo xa' gax lo Jesus, ndowiꞌ xa' senꞌ mbrez Jesús nde nguj Jesus, nchab xaꞌ: —Lipa liga mbi' reꞌ nak Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Noga tij nzi pla ngol nzi wi' tya; xija nzo Marí Magdalen, nde Marí xnaꞌ Jakob or yenꞌ, wes José nde Salome. ");
INSERT INTO ztp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Re ngol reꞌ mketenke xis Jesús, nde mbli ngol sinꞌ lo Xaꞌ sen' ngwa xa' Galilea; nde tipla ngol mketenke xis Jesus senꞌ ngwa Xaꞌ Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sen' ndela yal', tak wiz yaja nak par toxkwaꞌ xaꞌ re chan' xaꞌ, tedib wiz nakla wiz ndryoxkwen men. ");
INSERT INTO ztp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jose xaꞌ yez Arimatea nak xa' ti xa' nakaya' sinꞌ ro lo yolow, no xa' ngembed ye'd Yalnyebeꞌ chanꞌ Dios, jwan' nasa na'nzyebta xa' mbike xa' lo Pilat, nde mna'b xa' thobol Jesús lo kruz. ");
INSERT INTO ztp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Leꞌ Pilat nzoyen toz senꞌ mbin xaꞌ ngujla Jesús; nde mbrez Pilat xaꞌ nyebeꞌ lo sondad, sa mnabdiꞌs Pilat lo xaꞌ nyen' cho nguj la Jesús? ");
INSERT INTO ztp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sen' lo mdej xa' nyebe' lo sondad ke nguj la Jesus, zyasa mdaꞌya Pilat thobol lo José, ");
INSERT INTO ztp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","le' Jose mxi' xa' lar nakis lar lan, nde mbla xaꞌ thabol lo kruz, mchal lar xaꞌ Xaꞌ nde mkaꞌs xaꞌ Jesus lenꞌ ti baꞌ nadenꞌ lenꞌ ke nde mdub xa' ti ke ro mtowꞌ xaꞌ ro baꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Leꞌ Marí Magdalen nde Marí xnaꞌ José mbwiꞌ xaꞌ plo mkaꞌs xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Senꞌ mbridla wiz ndryoxkwen men, leꞌ Marí Magdalen, Marí xnaꞌ Jakob, nde Salome, mxiꞌ xaꞌ nit naxeꞌ yalo xaꞌ lad thabol Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nde tilꞌ toz, wiz ner xan' sman, sen' ndoro'xo'b la wiz, ngwa ngol ro baꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nde nchab ngol lo ta ngol: —¿Cho xaꞌ sike' ke jwanꞌ nowꞌ ro baꞌ? ");
INSERT INTO ztp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per senꞌ mzin xaꞌ, mbwi' xa' mbike ke jwanꞌ nowꞌ ro baꞌ, ke ro toza. ");
INSERT INTO ztp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Senꞌ ngote xaꞌ lenꞌ baꞌ, mbwiꞌ xaꞌ ti mbyo yenꞌ ndob lad ban, dib mbyo nachal lar nakis, nde mzyeb toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Leꞌ mbyo nchab: —¡Nazyebta goꞌ! Goꞌ nkwanꞌ Jesús, Xaꞌ yez Nazaret, Xaꞌ jwanꞌ mke lo kruz. Ngenta Xaꞌ ncheꞌ, mbro'xbanla Xaꞌ. Bwiꞌ goꞌ plo tenꞌ ngo'x Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Per bya goꞌ, guz goꞌ lo re xinꞌ teꞌd Xaꞌ nde lo Pey, le' Xaꞌndasi'blola lo go' sin xa' Galilea, tya wiꞌ goꞌ Xaꞌ, xatka ne Xaꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Le' re ngol ya mbro' xa' len' ba' mke' xa' karel ndya xa', tak mxi'd toz xa' nde mzyeb xaꞌ; ngenta kwan ngab xaꞌ lo nek tib men tak mzyeb toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sen' lo ta mbro'xbanla Jesús tilꞌ toz, wiz ner xan' sman, nerla mbro'to Jesús lo Marí Magdalen, ngol jwanꞌ mbloꞌte Jesus gaz mbi narax lazonꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ngol ya ngwateja lo re xaꞌ jwanꞌ mketenke xis Jesús, tak nabil toz ndyak xaꞌ nde nzi yonꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Re xa' ya, senꞌ mbin xa' naban Jesús nde mbwiꞌ ngol Jesús, naꞌndlid lazoꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Per xisla xaꞌla mod mbroꞌto Jesus lo chop xinꞌ teꞌd Xaꞌ senꞌ rop xaꞌ reꞌ ndote, nda xa' ned wan. ");
INSERT INTO ztp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rop xaꞌ reꞌ ngwateja lo tipla xaꞌ; nde nekla xkiꞌs rop xaꞌ ya na'ndlid lazoꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ngolo jwan'na Jesús mbroꞌto lo re siꞌ thib xinꞌ teꞌd Xaꞌ, senꞌ nzi re xaꞌ ro mes, nde mtokox Jesús xaꞌ kwent na'ndlid lazoꞌ xa' nde nchak ne lazo' xaꞌ, tak namblid lazoꞌ xaꞌ re xaꞌ jwanꞌ mbwi' mbroxban Jesús. ");
INSERT INTO ztp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nde nchab Jesús lo xaꞌ: —Wa goꞌ dib nax izyo nde ptej goꞌ diꞌs wen chanꞌ Dios lo reta men. ");
INSERT INTO ztp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Men li lazon' xkiꞌs na nde ryole xaꞌ, xaꞌ ya lya'. Leꞌ xaꞌ na'lid lazonꞌ xkiꞌs na, xa' ya kix xaꞌ xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nde reta jwanꞌ re' toyal li re xa' jwan' li lazon' xkiꞌs na: Lo len kote xaꞌ re mbi narax, todiꞌs xaꞌ re diꞌs kub, ");
INSERT INTO ztp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tyen xaꞌ mbelꞌ lo yaꞌ xaꞌ nde tez gu xaꞌ nit tin, ngenta kwan tyak xaꞌ. Xob xaꞌ yaꞌ xaꞌ yek re men nayiz nde tyan' nadan' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Le' Xaꞌ Nyebe', sen' ngolo mdodi's Xa', ngwap Xa' ndya Xa' lo beꞌ, nde mdob Xaꞌ lad ban Dios. ");
INSERT INTO ztp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Leꞌ re xaꞌ nak xinꞌ teꞌd Jesús, mbroꞌ xaꞌ nda tej xaꞌ xkiꞌs Dios reta lad, Xa' Nyebe' ndolaꞌsto xaꞌ nde ngoto' Xa' liga re dis jwan' ndej xa' kon re yalnaro jwan' nchak lo men. Ta aka");
INSERT INTO ztp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Naꞌrla xaꞌ mchal naxut mkeꞌ xa' lo ye's, re jwanꞌ lipa ngok nde xata ngokpey xij naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ta xata mbwiꞌ xaꞌ xa mdobtey, tata mbloꞌ xaꞌy lonꞌ nde mke xaꞌ sinꞌ mdej xaꞌ xkiꞌs Dios lo men. ");
INSERT INTO ztp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jwanꞌ nasa nogaꞌ na jwin mnabdiꞌs na a xata ngokpa reta jwanꞌ reꞌ lo xa mdobtey nde lo ngolo jwin mnabdiꞌs nay, ngwiꞌn wen naka keꞌ ney lo ye's xata ngokpay, sa tel' nay loa Teoj xa' ntak toz, ");
INSERT INTO ztp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","sa jwin yoloa re jwanꞌ li ta mte'd la. ");
INSERT INTO ztp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Senꞌ ngok Herodes rey lo xyon Judea, ngo thi nglweyꞌ ndole Zacarias, xaꞌ nzo lo grup nglweyꞌ Abias. Leꞌ ngol xaꞌ ndole Elisabet nde noga ngol nde lo bin Aaron. ");
INSERT INTO ztp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nde rop xaꞌ galꞌ nak lo Dios, nxoꞌbyek xaꞌ xkiꞌs Dios dib nzo lazoꞌ xaꞌ nde re jwanꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per ngenta xinꞌ xaꞌ, tak Elizabeth xa' nij xa' nde ngoxla ropta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Thib wiz senꞌ mdinꞌ re xaꞌ nak grup nglweyꞌ chanꞌ Zacarias li xaꞌ sinꞌ lo Dios len' yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nde mod chanꞌ re nglweyꞌ nak ndlibe' xa' nyenꞌ cho ndinꞌ na, nde mdinꞌ Zacarias yote xaꞌ ten' nayon lenꞌ yodoꞌ chanꞌ Dios sa tolꞌ xaꞌ xtarak lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","nde hor jwan' nchol xtarak, reta men toz tir nzi le, nzi todiꞌsno xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zyasa mbroꞌto thi anj chanꞌ Dios lo Zacarias, ndoli lad ban tenꞌ ndoyol xtarak. ");
INSERT INTO ztp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Senꞌ mbwiꞌ Zacarias anj, nzoyen xa' nde mzyeb xa'. ");
INSERT INTO ztp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Le' anj nchab: —Zacarias, naꞌzyebta la, tak Dios mbinla jwanꞌ mnaꞌb la lo Dios, nde xaꞌ got la Elisabet tyan thi mbed biꞌ nde tob lea or Juan. ");
INSERT INTO ztp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nde nale toz yo lazoꞌa nde lyen la nde nale toz yo lazoꞌ bro men senꞌ gal or, ");
INSERT INTO ztp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tak le' or ak thi xa' ntak toz lo Dios. Nde naꞌgud or nit bin nekla nit xtus, ben' tera gal or Mbi Nayon chanꞌ Dios nyebeꞌla lazoꞌ or. ");
INSERT INTO ztp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nde li or sa bro men Israel bere xa' lo Dios xa', Xa' Nyebe' lo xa'. ");
INSERT INTO ztp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nde or, yate lo Xaꞌ Nyebeꞌ, kon xbi nde yalne chanꞌ Profet Elías, sa nabeꞌz kwe re xud mdyen' kon mdyen', nde sa teꞌd re men ndli jwanꞌ narax, xoꞌbyek xaꞌ xkiꞌs Dios. Tamod sa tosaꞌ or re men yez Dios, sa kaya' re men Xa' Nyebe'. ");
INSERT INTO ztp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarias mnabdiꞌs lo anj: —¿Xamod mnen ke li jwanꞌ reꞌ? Tak na ngoxla na nde xaꞌ got na no xaꞌ ngoxla xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Leꞌ anj mkab: —Na nak Gabriel, nde ndlin sinꞌ lo Dios; Xaꞌ mtelꞌ na sa todiꞌsnon la, tej na diꞌs wen chanꞌ Xaꞌ loa. ");
INSERT INTO ztp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per naya, ta nandlid lazoꞌa jwanꞌ nin loa, yanꞌ ngup la, nde naꞌgakta nia axta wiz ak reta jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Laja re men nzi le ngembed xa' Zacarias nde ndli xa' xgab kwan liy ndolen' toz Zacarias ten' nayon len' yodo'. ");
INSERT INTO ztp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Senꞌ mbroꞌte Zacarias tya, naꞌgakta ni xa', zyasa mbyen re men ke ti jwanꞌ mbroꞌto lo xaꞌ ten' nayon lenꞌ yodoꞌ, nde benꞌta señ ndli xaꞌ lo men, tak mbyan' ngup xa'. ");
INSERT INTO ztp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Senꞌ ngoxob wiz mne rsinꞌ Zacarias len' yodoꞌ, ndya xaꞌ liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tudla ndate, Elisabet ngol xa' mkelo xinꞌ na', nde nandroꞌd ngol liz ngol dib gayꞌ mbeꞌ nde mbli ngol xgab: ");
INSERT INTO ztp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","\"Wen toz nak Dios lon, mkib Xa' yantho ndyak na, na'wi'naraxtra' men na ta na'yod xin' na.\" ");
INSERT INTO ztp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Senꞌ ngoxo'b xop mbeꞌ ndo xa' yistan, Dios mtelꞌ anj Gabriel thi yez ndole Nazaret jwanꞌ nax lo xyon Galilea, ");
INSERT INTO ztp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tenꞌ nzo thi mzaꞌ yenꞌ ndole Mari, jwanꞌ tera gaxno mbiꞌ, jwan' nak di'sla selyaꞌ kon thi xaꞌ biꞌ ndole Jose, jwanꞌ nde lo bin rey David. ");
INSERT INTO ztp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nde ngote anj ten' ndo mzaꞌ, mni anj dyux lo mzaꞌ nchab anj: —¡Maa Mari, wen toz ngwiꞌ Dios la! Mbli leyꞌ Dios la xij re ngol nde ndono Dios la. ");
INSERT INTO ztp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Per senꞌ mbin Mari jwanꞌ nchab anj nyaga nzoyen Mari, mbli Mari xgab, kwan ta mbez anj. ");
INSERT INTO ztp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Zyasa nchab anj lo Mari: —Naꞌzyebta la Mari, tak wen toz ngwiꞌ Dios la. ");
INSERT INTO ztp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nde naya kelo xinꞌ la nde kaa thi mbed biꞌ nde tob lea or Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nde or ak thi xaꞌ ntak toz, nde ryoꞌ le or Xinꞌ Dios ro, nde Dios Xaꞌ Nyebeꞌ ta' ten' mnebe' rey David nyebe' or, lo bin David tenꞌ nde or. ");
INSERT INTO ztp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sa nyebeꞌ or lo reta men Israel thibtane, nde yalnyebeꞌ chanꞌ or naꞌluxtay. ");
INSERT INTO ztp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Zyasa mnabdiꞌs Mari lo anj: —¿Xamod ak jwanꞌ reꞌ tak tera tobnon mbiꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Zyasa mkab anj lo Mari: —Mbi Nayon yeꞌd xis la, nde yalne chanꞌ Dios ro ba lya xis la xaja xkala. Jwanꞌ nasa or gal loa, nayon or, nde Xinꞌ Dios ko'le men or. ");
INSERT INTO ztp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mbay na noga Elisabet xa' taa ka thi mbed, tenye ngoxla xaꞌ, nde naya ndola xaꞌ xop mbeꞌ lo yis tan, xaꞌ jwanꞌ mbez men nak xa' nij. ");
INSERT INTO ztp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tak par Dios na'ngyenta nekthib jwan' na'akta li Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Zyasa nchab Mari: —Ncheꞌ ndon, lin rsinꞌ Dios na, li Dios kon na xata nea lon. Ngolo jwan'na, ndya anj. ");
INSERT INTO ztp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nde lenꞌ wiz ya mken Mari, ngwa Mari thi yez nax lo yiꞌ xyon Judea, ");
INSERT INTO ztp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","senꞌ mzin Mari liz Zacarias, mni Mari dyux lo Elisabet. ");
INSERT INTO ztp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lo senꞌ mbin Elisabet dyux mni Mari, mbwin mbed lenꞌ Elisabet, nde mde' Mbi Nayon chanꞌ Dios xa'. ");
INSERT INTO ztp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Zyasa ne mni xa' nchab xaꞌ: —¡Mbli leyꞌ Dios la xij re ngol, nde mbli leyꞌ Dios xinꞌ la. ");
INSERT INTO ztp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cho nak na sa ndetna xnaꞌ Xaꞌ Nyebe' lon, na? ");
INSERT INTO ztp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nde leꞌ mbin na mnia dyux lon, mbwin mbed lenꞌ na, tak leꞌka nale ngo lazoꞌ or. ");
INSERT INTO ztp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nabe'z toz ndaa, tak mbli lazoꞌa xkiꞌs Dios, nde ak reta jwanꞌ ne Dios loa. ");
INSERT INTO ztp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Zyasa nchab Mari: Dib nzo lazoꞌn nin diꞌs wen lo Dios, ");
INSERT INTO ztp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nde xbin na nale toz nzo lazo'n lo Dios, Xaꞌ li sa lya'n. ");
INSERT INTO ztp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nde mblí Xa' na sa li rsinꞌ Xaꞌ na, teꞌnye nanakta na xaꞌ ntak nde naya dib tyemp gab reta men nzo lo izyo, Dios mbli ley' xa'. ");
INSERT INTO ztp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tak Dios ta ngeno dib yalne, mbli yalnaro toz lon, nayon nak le Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nde Dios thibla' ndlat lazonꞌ reta men jwanꞌ nzeb lazon' Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Naro nak re jwanꞌ ndli Dios kon yalne chanꞌ Dios, nde mcha's Dios re xa' nchak naro. ");
INSERT INTO ztp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mkib Dios yalnyebeꞌ lo re rey nchak naro, nde mbli naro Dios re xaꞌ nadoꞌ nak. ");
INSERT INTO ztp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Re xaꞌ ndyak win mdaꞌ Dios bro jwan' lo xaꞌ, Le' re xaꞌ ngeno bro jwanꞌ, tatanya xa' mse're Dios xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios mblasto xaꞌ Israel xa' ndli sin' lo Dios, nde nanchajta yek Dios ndlat lazoꞌ Dios xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ta xa thibtane mda' Xa' xki's Xa' lo re xa' gox lon' pola, lo Abraham nde lo re xa' nde lo bin Abraham. ");
INSERT INTO ztp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nde ngo Mari mer son mbeꞌ liz Elisabet, seraꞌ ndya Mari liz Mari. ");
INSERT INTO ztp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Senꞌ ngoxob be' gal xinꞌ Elisabet, thi mbed biꞌ ngol lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lo mbin reta men nzo gax liz xaꞌ nde re ta xaꞌ plopa yalwen mbli Dios mblat lazoꞌ Dios xaꞌ, ngwatna re men xaꞌ nde nale toz ngo lazoꞌ reta men kon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nde senꞌ ngoxo'b xon wiz ngol mbed, mbeꞌ xaꞌ or sa tob xaꞌ beꞌ lad or, tenꞌ nadan lad men biꞌba, nde ncholaꞌs xaꞌ kole xaꞌ or Zacarias xa ndole xud or. ");
INSERT INTO ztp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per xnaꞌ mbed nchab: —Naꞌryoꞌled mbed tamod, leꞌ mbed ryoꞌle Juan. ");
INSERT INTO ztp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Zyasa nchab xaꞌ: —¿Kwan liy? Ngen cho ta ndole Juan. ");
INSERT INTO ztp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zyasa kon señ mnabdiꞌs xaꞌ lo xud mbed, sa tej xaꞌ xamod nchola's xa' ryoꞌle mbed. ");
INSERT INTO ztp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Le' xud mbed mna'b thi ble tab, nde mkeꞌ xaꞌ lo tab: \"Mbed ndole Juan.\" Nde reta men nzoyen toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nde hor yaga taxa ngok mni Zacarias tedib gob, nde mdaꞌ Zacarias dyux lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nde reta xaꞌ jwanꞌ nzo gax liz Zacarias jwanꞌ toz nzoyen xaꞌ, nde mbrya's jwanꞌ na reta yez jwanꞌ nzi lo yiꞌ lo xyon Judea. ");
INSERT INTO ztp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nde reta xaꞌ jwanꞌ mbin jwanꞌ na mbli xaꞌ xgab: —¿Cho kwan ak mbed reꞌ senꞌ xyen or? Tak ndloꞌpa ndo yalwen chanꞌ Dios kon or. ");
INSERT INTO ztp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zyasa Zacarias xud mbed, mde' Mbi Nayon xa' nde mdej xaꞌ re jwanꞌ ak, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Naro toz nak Dios, chanꞌ re naꞌ, xa' Israel, tak mbyedtna Xaꞌ naꞌ nde mtolaꞌ Xaꞌ naꞌ, naꞌ jwanꞌ nak men yez Xaꞌ! ");
INSERT INTO ztp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mtelꞌ Dios thi or jwanꞌ ngeno bro toz yalne, sa tolaꞌ or naꞌ, Thi or jwanꞌ nde lo bin rey David xaꞌ jwanꞌ mbli sinꞌ lo Dios, ");
INSERT INTO ztp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ta xa nchab Dios lo re profet nayon Dios ngo pola. ");
INSERT INTO ztp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tolaꞌ Dios naꞌ lo re xaꞌ ndli jwanꞌ narax nde lo re xaꞌ nayi' lon'. ");
INSERT INTO ztp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nde tagaꞌ mdaꞌ Xaꞌ xkiꞌs Xaꞌ lyat lazoꞌ Xaꞌ reta xaꞌ gox lonꞌ, nde li Xaꞌ jwanꞌ nchab Xaꞌ lo re xaꞌ gox lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Re jwanꞌ mdaꞌ Dios xkiꞌs Dios li Dios lo Abraham xaꞌ gox lonꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ke Dios tolanꞌ lo yaꞌ re xaꞌ ndebeyonon', sa naꞌzyebta naꞌ linꞌ sinꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nayon nde galꞌ ketenꞌ lo Dios reta wiz naban naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nde lu xinꞌ lud na, ryoꞌlea profet Dios ro, tak lu kwiblo lo Xa' Nyebe', sa xalꞌ la ned rid Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Sa tej la lo reta men yez Dios, Dios tonꞌ xken xaꞌ nde tolaꞌ Dios xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tak Dios naꞌ, jwanꞌ toz mblat lazoꞌ Xaꞌ men, mtelꞌ Xaꞌ thi Xaꞌ nak xaja thi xni wiza lo naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sa toxni Xaꞌ lo reta men ngete lo yalꞌ kow, nde we Xaꞌ men lo ned nzo yalnabeꞌz. ");
INSERT INTO ztp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nde or luda ndoxen or, nde taja ndoxen yalnchak chan' or, nde ngo or re izyo nagan axta wiz senꞌ mbro' to or lo men Israel. ");
INSERT INTO ztp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lenꞌ wiz ya, rey Augusto mnebeꞌ, sa reta men ya taꞌ lenꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jwanꞌ reꞌ zyarka ngok ner, ngo le reta men lo libr, senꞌ ngok Cirenio gobernador yez Siria. ");
INSERT INTO ztp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nde reta men ndablo ya xaꞌ tenꞌ nak las xaꞌ, sa tya yo le xaꞌ lo yeꞌs. ");
INSERT INTO ztp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jwanꞌ nasa, mbroꞌ Jose yez Nazaret, jwanꞌ nax lo xyon xaꞌ Galilea, nda xaꞌ yez Belen jwanꞌ nax lo xyon Judea, tenꞌ ngol rey David, tak Jose nde lo bin rey David, ");
INSERT INTO ztp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","sa yo le xa' lo ye's kon Marí sal' xa', jwan' ndo lo yistan. ");
INSERT INTO ztp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nde laja benꞌ nzi xaꞌ yez Belen, mzin wiz gal xinꞌ Mari. ");
INSERT INTO ztp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tya ngol xinꞌ xaꞌ or ner, mchal lar xaꞌ or nde mdix xaꞌ or len' ya ten' ncho jwan' ncha ma' tak naꞌngasalta ti yo kwed xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nde gax yez Belen, nzi pla xaꞌ lenꞌ wan, ngenap mbakxilꞌ yalꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Zyasa xaj mbro'to ti anj chanꞌ Dios lo xaꞌ nde ngo xni chanꞌ Dios dib tenꞌ nzi xaꞌ, nde mzyeb toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Per anj nchab lo xaꞌ: —Naꞌzyebta goꞌ, tak na ndal tej thi diꞌs wen chanꞌ Dios lo goꞌ, jwanꞌ li yo nale lazoꞌ reta men: ");
INSERT INTO ztp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na wiz ngol thi mbed lenꞌ yez David, or ya tolaꞌ men, or nak Crist Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nde jwanꞌ reꞌ ak beꞌ lo goꞌ xamod yosal goꞌ mbed: Leꞌ mbed nachal thi lar nde nax mbed lenꞌ thi ya kano tenꞌ ncho jwanꞌ ncha maꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Zyasa xaj mbroꞌto thi byox anj chanꞌ Dios, tenꞌ ndo anj ya, nde ni re anj diꞌs wen lo Dios nchab anj: ");
INSERT INTO ztp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Naro toz nak Dios lo beꞌ! ¡Nde nabeꞌz kwe re men lo izyo, men jwan' nchal yalwen chan' Dios! ");
INSERT INTO ztp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Senꞌ mbere re anj ndya anj lo beꞌ, re xaꞌ ngenap mbakxilꞌ nchab xaꞌ lo ta xaꞌ: —Ndanꞌ yez Belen, nda winꞌ jwanꞌ ngok ta mbyed tej anj chanꞌ Dios lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Zyasa naban ngwa xaꞌ, nde mzyal xaꞌ Mari nde Jose kon mbed nax lenꞌ ya kano tenꞌ ncho jwanꞌ ncha maꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Senꞌ mbwiꞌ xaꞌ mbed, mdej xaꞌ reta kwent chanꞌ mbed, ta mdej anj lo xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nde reta xaꞌ jwanꞌ mbin kwent mdaꞌ re xaꞌ ngenap mbakxilꞌ la, leꞌka nzoyen re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per Mari mblosa' reta jwan' na len' lazo' Mari, nde thibla ndli Mari xgaba. ");
INSERT INTO ztp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Leꞌ re xaꞌ ngenap mbakxilꞌ, mbere xaꞌ tenꞌ nzi xaꞌ, laja ndo xa' ned nda xaꞌ, nda' xa' dyux lo Dios nde ni xaꞌ diꞌs wen lo Dios, tak reta jwanꞌ mbwiꞌ xaꞌ nde jwanꞌ mbin xaꞌ, ngoka xata nchab anj lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Senꞌ ngok xon wiz ngol mbed, mtob xaꞌ beꞌ tenꞌ nadan lad mbed. Nde mtob le xaꞌ mbed Jesus, ta xata nchab anj ryo'le mbed senꞌ teraꞌ kelo mbed len' Mari. ");
INSERT INTO ztp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Senꞌ ngoxob wiz ak nambi rop xa' xajka nyebeꞌ ley chanꞌ Moises, mbeꞌ xa' mbed yez Jerusalen sa lo' xa' mbed lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tamod mbli xaꞌ, tak ta nchab lo ley chanꞌ Dios: \"Reta mbed biꞌ jwanꞌ nchal ner, ak nayon or par Dios.\" ");
INSERT INTO ztp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nde mdaꞌ xaꞌ jwanꞌ yon, xajka nyebeꞌ ley chanꞌ Dios: chop ngog o chop mbyin be. ");
INSERT INTO ztp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lenꞌ wiz ya ngo thi xaꞌ ndole Simeon yez Jerusalen. Xaꞌ nak thi xaꞌ galꞌ nde nxoꞌbyek xa' xkiꞌs Dios, ngembed xaꞌ wiz telꞌ Dios thi xaꞌ konale lazo' men Israel. Nde Mbi Nayon ndono xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nde mblo' Mbi Nayon lo Simeon sa mne xa' ke na'gajta xa' axta kebe' wi' xa', Xa' jwan' mtel' Dios. ");
INSERT INTO ztp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Zyasa mbli Mbi Nayon ngwa Simeon yodoꞌ, senꞌ mzin Jose kon Mari ndeno xa' mbed yodoꞌ, sa li xaꞌ jwanꞌ nchab ley Moises, ");
INSERT INTO ztp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","zyasa mdeꞌs Simeon mbed nde mdaꞌ Simeon dyux lo Dios, nchab Simeon: ");
INSERT INTO ztp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dios ro, naya ngokla reta jwanꞌ xata nea lon, naya toyal nabe'z gaj na. ");
INSERT INTO ztp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tak mbwiꞌa na or jwanꞌ tolaꞌ re men, ");
INSERT INTO ztp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nde reta yez yolo xa' jwan' nak xgab la lia, tola'a re men. ");
INSERT INTO ztp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Or ak xni lo reta yez nanakta xa' Israel, nde por or sa xyob xki's yez Israel. ");
INSERT INTO ztp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jose nde Mari xnaꞌ Jesus leꞌka nzoyen xaꞌ mbin xaꞌ reta jwanꞌ nchab Simeon kwent chanꞌ mbed. ");
INSERT INTO ztp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Zyasa mbli leyꞌ Simeon xaꞌ, nde nchab Simeon lo Mari xnaꞌ Jesus: —Wiꞌ nea, Dios mtelꞌ or sa lir bro toz xa' Israel lyayo nde bro toz xa' tyotsa'. Jwan' lo' ak or, bro toz men na'ryo'd lazo' xa'y. ");
INSERT INTO ztp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Per reta jwanꞌ reꞌ aka xaja thi espada yada lazo'a. Nde men thoz ryo'xo'b jwan' nzo lazoꞌ xa'. ");
INSERT INTO ztp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nde tya ndoga' thi men got gox ndole An, xa' ya nak profet, xinꞌ Fanuel, jwan' nde lo bin Aser, sen' yen' ngol mpselyaꞌ ngol nde gaz linꞌ mdobno ngol salꞌ ngol, ");
INSERT INTO ztp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nde nzola xa' thap gal nzo thap linꞌ tata ndo thib xa'. Thibla' ndo ngol yodoꞌ, nde yalꞌ ndlyabe ndli ngol sinꞌ lo Dios, nke ngol yalse nde ndodi'sno ngol Dios. ");
INSERT INTO ztp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nde hor yaga' mbike ngol lo Jose nde Mari, mdobte mdaꞌ ngol dyux lo Dios, nde mdej ngol kwent chanꞌ Jesus lo reta xaꞌ jwanꞌ ngembed pol sin xaꞌ jwanꞌ tolaꞌ re men Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Senꞌ ngolo mbli Jose kon Mary reta jwanꞌ nyebeꞌ ley chanꞌ Dios, mbere xaꞌ yez Nazaret, tenꞌ nak las xaꞌ, jwanꞌ nax lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nde ndo xen Jesus nde taga' ndo yo xgab nde yalchak yek Jesus, nde yalwen chan' Dios thibla ndonoy Jesús. ");
INSERT INTO ztp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Reta linꞌ nda Jose kon Mari xud Jesus yez Jerusalen lo ni pask. ");
INSERT INTO ztp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Senꞌ nzo Jesus thib sen linꞌ, ngwa re xaꞌ lo ni pask a xaja nak mod chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Senꞌ ngolo ni, ngo xaꞌ ned ndya xaꞌ liz xaꞌ. Per naꞌnyed Mari xnaꞌ Jesus nde Jose, leꞌ Jesus mbyanꞌ yez Jerusalen, ");
INSERT INTO ztp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mbli xaꞌ xgab leꞌ Jesus ndya xij re men. Nde ndola xaꞌ ned dib tib wiz, seraꞌ mkwanꞌ xaꞌ Jesus xij re ta xaꞌ nde xij re xaꞌ ncholo xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","per naꞌngazalta xaꞌ Jesus. Zyasa mbere xaꞌ yez Jerusalen, nda kwanꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngoxob son wiz , seraꞌ mzyal xaꞌ Jesus lo le chan' yodoꞌ. Ndob or xij re maestr nchak ley, ndobyon or reta jwanꞌ ndloꞌ xaꞌ nde nyabdiꞌs or lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nde reta xaꞌ nchon jwanꞌ ndej or, nzoyen xaꞌ xa nchen or nde xa nkab or. ");
INSERT INTO ztp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Senꞌ mbwiꞌ xud or kon xnaꞌ or, leꞌka nzoyen xaꞌ; nde xnaꞌ or nchab lo or: —Xinꞌ na, ¿Kwan ta mblinoa ná'? Rop náꞌ xud la jwanꞌ toz ndli náꞌ xgab maa nde ngete kwanꞌ náꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus mkab lo xaꞌ: —¿Kwan liy nkwanꞌ goꞌ na? ¡Mnea go', lo rsin' xud na nakinꞌ ton! ");
INSERT INTO ztp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per naꞌngyenta xaꞌ jwanꞌ nchab or. ");
INSERT INTO ztp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Zyasa mbere or kon xaꞌ yez Nazaret nde mxobyek or reta jwanꞌ nyebeꞌ xud or, nde xnaꞌ or. Per xna' or ndli toz xa' xgab reta jwanꞌ ta ngoka. ");
INSERT INTO ztp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nde xa ndoxen or taga' ndoxenor yalchak nde nabe'z ngwi' Dios or nde taga' re men. ");
INSERT INTO ztp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lenꞌ linꞌ tsinꞌ chanꞌ Tiberio Cesar xaꞌ nyebeꞌ dib izyo chan' Rom, zya Poncio Pilato nak gobernador lo xyon Judea, Herodes nak gobernador lo xyon Galilea, Felip wes Herodes nak gobernador lo xyon Iturea nde re yez chanꞌ Traconite. Nde Lizaneas nak gobernador re yez chanꞌ Abilinia. ");
INSERT INTO ztp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Zya Anas nde Caifas nak nglweyꞌ ro. Lenꞌ wiz ya mni Dios lo Juan xinꞌ Zacarias jwanꞌ nzo izyo nagan, ");
INSERT INTO ztp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","jwanꞌ nasa, nkete Juan rop lad ro yoꞌ Jordan ngwa tej Juan lo re men ke nakinꞌ seꞌ xaꞌ xgab xaꞌ nde laꞌ xaꞌ jwanꞌ narax ndli xaꞌ nde ryoꞌle xaꞌ lenꞌ nit sa dyonꞌ xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jwanꞌ reꞌ ngok xa nchab lo ye's mke' profet Isaias: Nchen mbez ti men lad izyo nagan. \"Ptoxkwa' goꞌ xned Xa' Nyebe'. Nali bdix goꞌ xned Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Reta yeryo zye, reta yiꞌ nde reta kox ak lap, reta ned nato ak nakwa, nde reta ned narax nak, ak nali. ");
INSERT INTO ztp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nde reta men wiꞌ xa tola' Dios men.\" ");
INSERT INTO ztp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jwan' nasa nchab Juan lo re men toz tir jwan' nda lo Juan sa ryo'le: —¡Bin mzib nde goꞌ! ¿Cho ne lo go', lyaꞌ goꞌ lo yalnayiꞌ chanꞌ Dios jwanꞌ nde gaxla? ");
INSERT INTO ztp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ban goꞌ thi mod ke lo' liga mzyeꞌ xgab go' nde mblaꞌ goꞌ re jwanꞌ narax ndli goꞌ, nde naꞌlid go' xgab len' lazo' go': \"naꞌ nde lo bin Abraham\", tak na ni lo go', Dios toyal lilal Xa' re ke re' xin' Abraham. ");
INSERT INTO ztp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbay na tagaꞌ yiꞌbya nda'bsa'lay sa choꞌy axta dib lox ya jwanꞌ nandaꞌda ngud wen, xchoꞌy nde yobiy lo bel. ");
INSERT INTO ztp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zyasa re men mnabdiꞌs lo Juan: —¿Cho kwan ndablo li náꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan mkab lo xaꞌ nchab: —Go' jwanꞌ ngeno chop ned lar, ndablo taꞌ go' thib neda lo xaꞌ nangenoda nek thiba; nde go' ngeno jwanꞌ ncha, naxal' gok go', taga' bli go'. ");
INSERT INTO ztp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noga ngwa pla xaꞌ jwanꞌ nthop tmi low par yez Rom lo Juan, sa koꞌle Juan xaꞌ, nde mnabdiꞌs xaꞌ lo Juan nchab xaꞌ: —Maestr, ¿kwan ndablo li náꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan nchab lo xaꞌ: —Naꞌnyabta goꞌ masra tmi jwanꞌ nandabloda kix xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noga pla sondad mnabdiꞌs lo Juan nchab: —Mbay náꞌ, ¿kwan ndablo li náꞌ? Juan mkab lo xaꞌ: —Naꞌkibta goꞌ chanꞌ men, neka keꞌ goꞌ yalke yek men jwanꞌ ngen kwan ndli nde blo nale lazoꞌ goꞌ jwanꞌ nchax nka goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nde reta men nzimbed sin xaꞌ jwanꞌ telꞌ Dios nde mbli xaꞌ xgab nzo pa Juan nak Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Per Juan nchab lo xaꞌ: —Na galꞌ diꞌs nin lo goꞌ, na ngole goꞌ kon nit, per tib xa' nde xis na, Xaꞌ ya ngeno mas yalne ke na, Xaꞌ koꞌle goꞌ kon Mbi Nayon nde kon bel. Nde nanzal'ta na xak na neka kore yalyid Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nzola pal ya Xaꞌ sa to Xaꞌ trig, tombi Xaꞌy nde kosaꞌ Xaꞌ trig tenꞌ nchosaꞌy, le' yix tolꞌ Xaꞌ lo bel jwanꞌ nanchuda. ");
INSERT INTO ztp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mod reꞌ mdej Juan nde masraꞌ ntobeꞌ Juan yek men, senꞌ mdej Juan diꞌs wen chanꞌ Dios lo men. ");
INSERT INTO ztp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mbay lo mtokox Juan Herodes xaꞌ nyebeꞌ lo xyon Galilea, tak ndobno xaꞌ Herodias, ngol Blib wes xaꞌ nde por reta temasra' jwanꞌ narax mbli xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","mbliga' xa' tediba'y, mkeꞌ lizyiꞌb xa' Juan. ");
INSERT INTO ztp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Senꞌ ngegoꞌle Juan re men, zyasa no Jesus mbroꞌle. Nde laj ngetodi'sno Jesus Dios, mxyalꞌ lo beꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","nde mbla Mbi Nayon yek Jesus xaja nya thi paloma, zyasa mbyen thi diꞌs mbroꞌ lo beꞌ nchab: —Lu nak xinꞌ na jwanꞌ nkeꞌ toz lazoꞌn, nde nale toz nzo lazoꞌn ngwiꞌn la. ");
INSERT INTO ztp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sen' mdobte Jesus rsin' Jesus nzo Xa' mer galpsiꞌ linꞌ, nde reta men mbli xgab Jesus nak xinꞌ Jose. Nde Jose ngok xinꞌ Eli, ");
INSERT INTO ztp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ngok xinꞌ Matat, Matat ngok xinꞌ Levi, Levi ngok xinꞌ Melqui, Melqui ngok xinꞌ Jana, Jana ngok xinꞌ Jose, ");
INSERT INTO ztp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jose ngok xinꞌ Matatias, Matatias ngok xinꞌ Amos, Amos ngok xinꞌ Nahum, Nahum ngok xinꞌ Esli, Esli ngok xinꞌ Nagai, ");
INSERT INTO ztp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ngok xinꞌ Maat, Maat ngok xinꞌ Matatias, Matatias ngok xinꞌ Semei, Semei ngok xinꞌ Jose, Jose ngok xinꞌ Juda, ");
INSERT INTO ztp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Juda ngok xinꞌ Joana, Joana ngok xinꞌ Resa, Resa ngok xinꞌ Zorobabel, Zorobabel ngok xinꞌ Salatiel, Salatiel ngok xinꞌ Neri, ");
INSERT INTO ztp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ngok xinꞌ Melqui, Melqui ngok xinꞌ Adi, Adi ngok xinꞌ Cosam, Cosam ngok xinꞌ Elmodam, Elmodam ngok xinꞌ Er, ");
INSERT INTO ztp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ngok xinꞌ Josue, Josue ngok xinꞌ Eliezer, Eliezer ngok xinꞌ Jorim, Jorim ngok xinꞌ Matat, ");
INSERT INTO ztp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ngok xinꞌ Levi, Levi ngok xinꞌ Simeon, Simeon ngok xinꞌ Juda, Juda ngok xinꞌ Jose, Jose ngok xinꞌ Jonan, Jonan ngok xinꞌ Eliaquim, ");
INSERT INTO ztp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ngok xinꞌ Melea, Melea ngok xinꞌ Mainan, Mainan ngok xinꞌ Matata, Matata ngok xinꞌ Natan, ");
INSERT INTO ztp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natan ngok xinꞌ David, David ngok xinꞌ Isai, Isai ngok xinꞌ Obed, Obed ngok xinꞌ Booz, Booz ngok xinꞌ Salmon, Salmon ngok xinꞌ Naason, ");
INSERT INTO ztp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason ngok xinꞌ Aminadab, Aminadab ngok xinꞌ Aram, Aram ngok xinꞌ Esrom, Esrom ngok xinꞌ Fares, Fares ngok xinꞌ Juda, ");
INSERT INTO ztp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ngok xinꞌ Jakob, Jakob ngok xinꞌ Isaac, Isaac ngok xinꞌ Abraham, Abraham ngok xinꞌ Tare, Tare ngok xinꞌ Nacor, ");
INSERT INTO ztp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ngok xinꞌ Serug, Serug ngok xinꞌ Ragau, Ragau ngok xinꞌ Peleg, Peleg ngok xinꞌ Heber, Heber ngok xinꞌ Sala, ");
INSERT INTO ztp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ngok xinꞌ Cainan, Cainan ngok xinꞌ Arfaxad, Arfaxad ngok xinꞌ Sem, Sem ngok xinꞌ Noe, Noe ngok xinꞌ Lamec, ");
INSERT INTO ztp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ngok xinꞌ Matusalen, Matusalen ngok xinꞌ Enoc, Enoc ngok xinꞌ Jared, Jared ngok xinꞌ Mahalaleel, Mahalaleel ngok xinꞌ Cainan, ");
INSERT INTO ztp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan ngok xinꞌ Enos, Enos ngok xinꞌ Set, Set ngok xinꞌ Adan, Adan ngok xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Sen' mbere Jesus mbro' Xa' yo' Jordan, dib ben Xa' mde' Mbi Nayon, nde mbe' Mbi Nayon Xaꞌ izyo nagan. ");
INSERT INTO ztp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tya ngwa Jesus choꞌ wiz, nde re len' cho' wiza leꞌka mchal Maxu' tokil' Maxu' Jesus. Re len' wiz ya ngen kwan ngwa Jesus, lo ngoxob choꞌ wiz mzib lyanꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Zyasa nchab Maxuꞌ lo Jesus: —Tez lipa nak la Xinꞌ Dios, mnibe' sa yalal ke ba pan. ");
INSERT INTO ztp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus mkab: —Lo xkiꞌs Dios nchab: \"Nanakta benꞌta pan ban men, noga reta diꞌs ndryoꞌ ro Dios ndaꞌ yalnaban lo men.\" ");
INSERT INTO ztp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Zyasa mbeꞌ Maxuꞌ Jesus thi yek yiꞌ gap toz ndab nde tib a'til mbloꞌ Maxuꞌ reta yalnyebe' dib nax izyo lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nde nchab Maxuꞌ lo Jesus: —Tan dib yalnyebeꞌ nde yalne chanꞌ izyo loa, tak chanꞌ na naka, nde taney a choja lo xa' ncholas na taney. ");
INSERT INTO ztp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nde tez tyoxub la lon nde li naroa na, retey tan loa. ");
INSERT INTO ztp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Leꞌ Jesus mkab: —Baxa wa, Maxuꞌ, tak lo xkiꞌs Dios nchab: \"Lo Dios la Xa' Nyebe' loa tyoxub la, nde benꞌta lo Xaꞌ lia sinꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Xisa mbeꞌ Maxuꞌ Jesus yez Jerusalen nde mto Maxuꞌ Jesus yek yodoꞌ tenꞌ mas gap ndab nde nchab Maxuꞌ lo Jesus: —Tez Xinꞌ Dios nak la, gobi axta laba, ");
INSERT INTO ztp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tak lo xkiꞌs Dios nchab: Dios nyebe' lo re anj chanꞌ Dios, sa kenap xa' la. ");
INSERT INTO ztp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lo ya' xa' tyenke' xa' lu, sa na'chepta nia ke. ");
INSERT INTO ztp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus mkab: —Noga nchab lo xkiꞌs Dios: \"Naꞌtokilꞌta la Dios Xaꞌ Nyebeꞌ loa.\" ");
INSERT INTO ztp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nde senꞌ mbre reta yaltokilꞌ chan' Maxuꞌ, mblaꞌ Maxuꞌ Jesus thi tyemp axta kebe' zyal Maxu' thi wiz. ");
INSERT INTO ztp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Zyasa mbere Jesus lo xyon Galilea, nde dib ben Xa' mde' Mbi Nayon, nde mxyob xkiꞌs Xaꞌ reta yez nzi lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nde kad yez mdobte Jesus mbloꞌ Jesus xkiꞌs Dios lo men lenꞌ yo tenꞌ ndyop re xaꞌ Israel, nde reta men nabeꞌz ni xa' xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Senꞌ mzin Jesus yez Nazaret tenꞌ mxyen Xa', nde wiz jwanꞌ ndryoꞌxkwen re xaꞌ Israel, ngote Xa' lenꞌ yo tenꞌ ndyop re xaꞌ Israel a xajka nak mod jwan' ngeno Xa' nde mdoli Xa' sa lab Xa' xkiꞌs Dios lo reta men. ");
INSERT INTO ztp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Zyasa mda' xa' ye's jwan' mke' profet Isaias lo Jesus sa lab Jesusa, nde senꞌ mxalꞌ Xaꞌ ye's, mzyal Xaꞌ tenꞌ nchab: ");
INSERT INTO ztp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Mbi Nayon chanꞌ Dios ndonon, tak mblí Dios na, sa tej na diꞌs wen chanꞌ Dios lo re xaꞌ prob, mtelꞌ Dios na sa todanꞌ na re xaꞌ ndyak yis nabil, sa tej na lyaꞌ re xa' nge lizyi'b, todanꞌ na ngudlo re xaꞌ syeg, tola'n re xaꞌ nga'sno re yalti, ");
INSERT INTO ztp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nde sa tej na lo re men ngol be' nzo yalwen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Xisa mthus Jesus ye's mdaꞌ Jesus sa lo xaꞌ ndli sin' lo yo ndyop xa', nde mdob Jesus. Zyasa reta men nzi tya, ngwiꞌ do' xaꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Le' Jesus mdobte nchab lo xaꞌ: —Naya ngok jwanꞌ nchab lo xkiꞌs Dios ta mblab na lo goꞌ re'. ");
INSERT INTO ztp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nde reta xa' wen ni xa' xis Jesus, nde nzoyen xaꞌ mbin xaꞌ re diꞌs wen mni Jesus, nde nchab xaꞌ lo ta xaꞌ: —¿Cho nanakta xaꞌ reꞌ nak xinꞌ Jose? ");
INSERT INTO ztp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Zyasa nchab Jesus lo xaꞌ: —Mnepa na le' go' ncholaꞌs nye thi di's gol re' lon: \"Doctor, ¡Btoyak leꞌga lu!\" nde nye goꞌ: \"Re jwanꞌ mbin náꞌ mblia yez Capernaum, noga las la re' bliy.\" ");
INSERT INTO ztp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nde noga nchab Jesus: —Lipa nin lo goꞌ, ngen choꞌ thi profet nabe'z lyen men las xa' xa'. ");
INSERT INTO ztp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nipa na lo go' ngo thoz ngol nguj sal' na' dib Israel tyemp mkete profet Elias, sen' ta na'ndlada yi tson lin' narol nde jwan' toz ngo win dib nax izyo, ");
INSERT INTO ztp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","per namtelꞌta Dios Elias lo nek thib ngola, cheꞌla mtelꞌ Dios Elias lo thi ngol nguj sal' na' xa' yez Sarepta jwanꞌ nzi lo xyon Sidon. ");
INSERT INTO ztp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nde tagaꞌ tyemp mkete profet Eliseo, ngo naꞌr toz men ndyak ye'sya's yez Israel, per nek thib xa' namdyanꞌta, benꞌta Naaman xaꞌ yez Siria mdyanꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Senꞌ mbin re xaꞌ jwanꞌ nzi lenꞌ yo tenꞌ ndyop xaꞌ Israel re jwanꞌ nchab Jesus, jwanꞌ toz ngok nayiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Zyasa mbloꞌte xaꞌ Jesus len' yez, mbeꞌ xaꞌ Jesus axta gap yek yi, ten' nzi yez xa', tya ncholaꞌs xaꞌ chixkwe xaꞌ Jesus yek ble toz. ");
INSERT INTO ztp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per Jesus mbridndaꞌb xij xaꞌ nde nda Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zyasa mdola Jesus nda Xa' yez Capernaum, jwanꞌ nax lo xyon Galilea; nde re wiz jwanꞌ ndryoꞌxkwen xa' Israel, ndloꞌ Xa' xkiꞌs Dios lo men. ");
INSERT INTO ztp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nde le'ka nzoyen re men ngwi' xa' xa ndloꞌ Jesus xki's Dios, tak kon yalnyebeꞌ ni Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nde lenꞌ yo tenꞌ ndyop xaꞌ Israel, ndob thi men biꞌ nzo mbi narax lazon', nde mbrezyaj xaꞌ nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Blaꞌ náꞌ! ¿Cho kwan nchala's la li noa náꞌ, Jesus Xaꞌ Nazaret? ¿Choꞌ nde lux la náꞌ? Nzolon la, lu nak Xaꞌ Nayon chan' Dios. ");
INSERT INTO ztp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nde mbresno Jesus mbi naraxa nchab Jesus: —¡Btowꞌ roa nde bro'te lazo' mbiꞌ re'! Zyasa nzi wi' re men mblobi mbi naraxa mbiꞌ ya izyo, nde mbroꞌtey per ngen kwan mblinoy mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nde reta men nzi tya le'ka nzoyen xaꞌ, nde nchab xaꞌ lo ta xaꞌ: —¿Cho yalne ndono mbi' ba? Sa kon yalnyebeꞌ, nyebeꞌ mbi' lo mbi narax ryoꞌtey, ¡Nde ndryoꞌtey! ");
INSERT INTO ztp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nde jwan' toz mxyo'b xkis' Jesus reta yez jwan' nzi tya. ");
INSERT INTO ztp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zyasa Jesus mbroꞌte lenꞌ yo tenꞌ ndyop xaꞌ Israel, nde nda Jesus liz Simon, leꞌ xnaꞌsap Simon nax lo yis, jwanꞌ toz nzo xlye xaꞌ. Nde mna'b re xaꞌ lo Jesus sa todanꞌ Jesus xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zyasa mbla ke' yek Jesus lo xa', nde mnebeꞌ Jesus ryoꞌ xlye xaꞌ, nde mbroꞌ xlye nde zyaga ngoche xaꞌ nde mdaꞌ xaꞌ jwanꞌ mda reta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Senꞌ ndobix wiz, reta xaꞌ jwanꞌ ngeno men yis, jwanꞌ ndyak xaꞌxaꞌ yis ndeno xaꞌ xaꞌ lo Jesus nde Jesus mxoꞌb yaꞌ Jesus yek kad thiba xaꞌ, mtodanꞌ Jesus reta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nde naꞌr re xa' yisa mbroꞌte mbi narax lazon', nde mbrezyaja nchab ba: —¡Lu nak Xinꞌ Dios! Per Jesus mbresno mbi naraxa nde naꞌndaꞌd Jesus diꞌs niy, tak le'y mnela ke' Jesus nak Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Senꞌ mduxni, Jesus mbroꞌ yez ya, nda Xa' tenꞌ nagan, per re men ngwa kwanꞌ xaꞌ Jesus, nde senꞌ mzin xaꞌ tenꞌ ndo Jesus, ncholaꞌs xaꞌ tyenkeꞌ xaꞌ Jesus, sa naꞌyad Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","per Jesus nchab lo xaꞌ: —Noga nakinꞌ ya tej na diꞌs wen chanꞌ Dios lo re temas yez, re jwan' nak yalnyebe' chan' Dios tak por jwanꞌ naga mtelꞌ Dios na. ");
INSERT INTO ztp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tamod mkete loꞌ Jesus diꞌs wen chanꞌ Dios lenꞌ re yo tenꞌ ndyop xaꞌ Israel, dib lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Thi wiz ndo Jesus ro nittoꞌ Genesaret, nde men toz tir mdyop lo Jesus axta ngaꞌs xaꞌ Jesus tak ncholaꞌs xaꞌ gon xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesus mbwi' chop bark nalaj nzi gax ro yux, tak re xaꞌ goꞌd mbel mbla xaꞌ lo bark ngetach xaꞌ yeꞌd xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zyasa ngwap Jesus lo ti bark ya, nde bark ya nak chanꞌ Simon, nde mna'b Jesus lo Simon chep xa'y tud lenꞌ nittoꞌ. Zyasa mdob Jesus lenꞌ bark nde mdobte mbloꞌ Jesus xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Senꞌ mne mdaꞌ Jesus xkiꞌs Dios lo men, nchab Jesus lo Simon: —Beꞌ bark ten' na'sxa lenꞌ nit, nde kobi goꞌ yeꞌd goꞌ sa tyen goꞌ mbel. ");
INSERT INTO ztp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Zyasa mkab Simon: —Maestr, dib yalꞌ mke náꞌ goꞌd nde nek thib mbel naꞌngagada, per ta lu nyebeꞌy, gobin yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nde senꞌ mblobi xaꞌ yeꞌd lenꞌ nit bro toz tir mbel ngoga, axta ndo ched yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Zyasa mbli xaꞌ señ mbrez xaꞌ ta xaꞌ ta nzo tedib len' bark, sa ye'd la'sto xa' xaꞌ. Nde mbyed la'sto xa' xaꞌ mtozeꞌ xaꞌ rop bark, lo mze toz rop bark axta ndolathab bark lenꞌ nit. ");
INSERT INTO ztp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Senꞌ mbwiꞌ Simon Pedr jwanꞌ ta ngoka, mdoxub xaꞌ lo Jesus nde nchab xaꞌ: —Bike tij lon Xa' Nyebe', tak na nak xaꞌ nzoꞌb xken naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tak nzoyen Simon nde mzyeb toz xa' kon reta xaꞌ nzino xa', lo tant bro mbel ngoga. ");
INSERT INTO ztp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Taga' Jakob kon Juan xinꞌ Zebedeo ta god mbel Simon mzyeb toz xaꞌ. Per Jesus nchab lo Simon: —Naꞌzyebta la, tak xata naya le'a yalal men goꞌd, sa lia gan men par Dios. ");
INSERT INTO ztp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Senꞌ mzinno xaꞌ rop bark ro yux, mblaꞌ xaꞌ reta jwanꞌ tya, nde mdonke xaꞌ xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Thi wiz sen' ndo Jesus thi yez ya, mzin thi xaꞌ biꞌ ndyak ye'sya's lo Jesus, senꞌ mbwiꞌ xaꞌ Jesus mdoxub xaꞌ lo Jesus axta mdinꞌ yek xaꞌ izyo nde mnaꞌb xaꞌ lo Jesus nchab xaꞌ: —Xa' Nyebe', Nya'b na loa todan' na, lu toyal liy tez ncholaꞌs la li ley. ");
INSERT INTO ztp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zyasa mtogaꞌ Jesus yaꞌ Jesus nde mbwal Jesus xaꞌ ya nde nchab Jesus lo xaꞌ: —Ncholas na, dyanꞌ la. Nde zyaga mdyanꞌ xaꞌ lo yis ya. ");
INSERT INTO ztp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nde nchab Jesus lo xaꞌ: —Ngen cho lo tej la jwanꞌ reꞌ, benꞌta wa lo nglweyꞌ sa wiꞌ xaꞌ la, nde beꞌ yon jwanꞌ ndablo taꞌa lo ta mbyak la, a xata nyebeꞌ ley chanꞌ Moises, sa loꞌ ke mbyak la. ");
INSERT INTO ztp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mbay che'la masra' mxyob xkiꞌs Jesus, men toz mdyop lo Jesus sa gon xaꞌ kwent ndaꞌ Jesus, nde sa todanꞌ Jesus xaꞌ lo re yis ndyak xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per Jesus nda re tenꞌ nagan sa todiꞌsno Jesus Dios. ");
INSERT INTO ztp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Thi wiz Jesus ngeloꞌ xkiꞌs Dios lo men, tya mdob re xaꞌ fariseo kon re xaꞌ nak maestr loley, jwanꞌ nde re lo xyon Galilea, Judea nde yez Jerusalen. Nde Jesus ngeno yalne chanꞌ Dios, sa todanꞌ Xaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Zyasa mzin pla xaꞌ ndeno thi xaꞌ nguj thi ble, nzo'b lo yalonꞌ nde ncholaꞌs xaꞌ we xaꞌ xaꞌ axta lenꞌ yo tenꞌ ndo Jesus nde kix xa' xa' lo Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","per naꞌgakta yote xaꞌ, tak men toz tira, zyasa ngwap xaꞌ yek yo nde mkib xa' pla tej, sa tya mbla xaꞌ yalonꞌ nzoꞌb xaꞌ yisa tenꞌ ndo Jesus xtow re men toz tira'. ");
INSERT INTO ztp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Senꞌ mbwiꞌ Jesus jwanꞌ toz ndli lazoꞌ re xaꞌ ya Jesus, nchab Jesus lo xaꞌ nguj thi ble yaꞌ: —Mbiꞌ reta xken la mdyonꞌ la. ");
INSERT INTO ztp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Zyasa re xaꞌ fariseo nde re maestr nchak ley, mdobte mbli xaꞌ xgab: \"¿Cho nak mbiꞌ reꞌ? ¿Kwan ndliy ta narax ni xaꞌ xis Dios? Ngencho li gan tonꞌ xken men, benꞌta Dios tak tonꞌ xken men.\" ");
INSERT INTO ztp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Leꞌ Jesus mnela cho xgab ndli xaꞌ, nchab Jesus lo xaꞌ: —¿Kwan liy ta ndli goꞌ xgab? ");
INSERT INTO ztp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cho kwan mas nambi gab na lo xaꞌ: \"Leꞌ xken la mdyonꞌla\", o gab na lo xaꞌ: \"Goche nde pte\"? ");
INSERT INTO ztp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sa nye goꞌ leꞌ Xinꞌ Mbiꞌ ngeno yalnyebeꞌ sa tonꞌ Xaꞌ re xken men lo izyo reꞌ. Zyasa nchab Jesus lo xa' nguj thi ble ya: —Leꞌ loa nin, goche, bxen lonꞌ la nde bya liz la. ");
INSERT INTO ztp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nde zyaga ngoche xaꞌ ta nguj thi ble ya, nde nzi wiꞌ re men, mxen xaꞌ lonꞌ xaꞌ ndya xaꞌ liz xaꞌ, nde taja ndaꞌ xaꞌ dyux lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nde reta xaꞌ nzi tya leꞌka nzoyen xaꞌ nde nzyeb xaꞌ, ndaꞌ xaꞌ dyux lo Dios nchab xa: —Naya mbwinꞌ yalnaro chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Senꞌ mne jwanꞌ reꞌ, mbroꞌ Jesus nda Xaꞌ nde mbwiꞌ Xaꞌ thi xaꞌ biꞌ jwan' nyaꞌb tmi low ndole Levi, xaꞌ ya ndob tenꞌ nchax tmi low, nde nchab Jesus lo xaꞌ: —Ptonke xis na. ");
INSERT INTO ztp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Zyasa mdoli Levi, mblaꞌ xaꞌ reta jwanꞌ nde mdonke xaꞌ xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Xisa mda' Levi thi yalwa ro liz Levi par Jesus, nde bro xaꞌ jwan' naka sin' nthop tmi low nde temas re men nzi ro mes kon Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Per re xaꞌ fariseo nde re maestr nchak ley, mdobte ni xin xa' xis re xin'te'd Jesus nde nchab xa: —¿Kwan liy ncha goꞌ nde nchuꞌ go' kon re xaꞌ nthop tmi low nde re xaꞌ nzoꞌb xken naꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Leꞌ Jesus mkab lo xaꞌ: —Re xaꞌ nadanꞌ nanakinta xaꞌ doktor, benꞌta re xaꞌ nayiz, xaꞌ ya nakinꞌ doktor. ");
INSERT INTO ztp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nandalta na sa bez na re xaꞌ gal' ndo, lenꞌ ndal sa bez na re xaꞌ nzoꞌb xken naꞌ, sa laꞌ xaꞌ jwanꞌ narax nde bere xaꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Zyasa mnabdiꞌs xaꞌ lo Jesus, nchab xaꞌ: —¿Kwan liy re xin'te'd Juan nke toz xaꞌ yalse nde tibla' ndo di'sno xa' Dios nde tagaꞌ ndli re xin'te'd fariseo, per re xin'te'd la thiblaꞌ ncha xaꞌ nde nchuꞌ xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus mkab lo xaꞌ: —¿Cho nye toyal li goꞌ, sa re xaꞌ nzi lo yalselyaꞌ ke xa' yalse, laja mbyo ndo selyaꞌ ben' ndo xij xa'? ");
INSERT INTO ztp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per tsin wiz senꞌ we xaꞌ or nselyaꞌ, zyasa ke xaꞌ yalse. ");
INSERT INTO ztp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Zyasa mdej Jesus thi kwent nagan lo xaꞌ: —Ngen cho thi men nchoꞌ thi ble lar kub sa kibde xa'y lad lar gox. Tez ta li xaꞌ, benꞌta tati xaꞌ lar kub nde tagaꞌ lar gox nanzaltey kebdey kon lar kub. ");
INSERT INTO ztp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nde taga ngen choꞌ ngo bin kub lenꞌ yid gox, tez cho xaꞌ ta li, bin kuba li cheꞌd yid, xyo bin nde akti yid. ");
INSERT INTO ztp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jwanꞌ nasa ndablo ko men bin kub lenꞌ yid kub sa ropa na'yasaꞌda. ");
INSERT INTO ztp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nde re xaꞌ nchuꞌ bin ndala nzo, nanchalaꞌsta xaꞌ gu xaꞌ bin kub, tak mbez xaꞌ: \"bin jwanꞌ ndala nzo jwanꞌ na mas naxeꞌ ndyeꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Thib wiz jwanꞌ ndryoꞌxkwen re xaꞌ Israel, ndarid Jesus kon re xin'te'd Xa' tenꞌ nzobin trig, nde re xa' nak xin'te'd Jesus, nthop xaꞌ trig ngis xaꞌy lo yaꞌ xaꞌ nde ncha xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Zyasa pla xaꞌ fariseo nchab lo re xaꞌ: —¿Kwan liy ndli goꞌ jwanꞌ nandabloda li men na wiz ndryoꞌxkwen men? ");
INSERT INTO ztp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Leꞌ Jesus mkab lo xaꞌ: —¿Cho tera lab goꞌ jwanꞌ mbli David kon re men ndano xaꞌ lo senꞌ ndyanꞌ xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ngote xaꞌ lenꞌ liz Dios nde mxen xaꞌ pan nayon jwan' ben'ta nglwey' tak wa nde mda xaꞌy nde mdaꞌ xaꞌy mda re xaꞌ ndano xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nde noga nchab Jesus: —Le' na Xinꞌ Mbiꞌ, nyebe'n noga lo wiz jwan' ndryoꞌxkwen men. ");
INSERT INTO ztp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Xa'ga' thi wiz jwan' ndryoꞌxkwen men, ngote Jesus lenꞌ yo tenꞌ ndyop xaꞌ Israel, mdobte mbloꞌ Jesus xkiꞌs Dios lo re xaꞌ, nde xija ndo thi mbiꞌ jwan' mbis yaꞌ ban naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nde re maestr nchak ley nde re xaꞌ fariseo ngela's xa' nyenꞌ cho todanꞌ Jesus xaꞌ yisa len' wiz ya, sa zyal xaꞌ yalke keꞌ xaꞌ yek Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per Jesus mnela xgab ndli xaꞌ, nchab Jesus lo men ta mbis yanꞌ ya: —Ptoli nde pto xtowꞌ reꞌ. Zyasa mdoli xaꞌ nde mdo xaꞌ xtowꞌ re men nzi tya. ");
INSERT INTO ztp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Zyasa nchab Jesus lo re xaꞌ nzi tya: —Naya nyabdiꞌs na lo goꞌ: ¿Cho kwanꞌ ndablo li men lenꞌ wiz jwan' ndryoꞌxkwen men, li men jwanꞌ wen o li men jwanꞌ narax? ¿Cho tola' men yalnaban thi men o la' men di's gaj xa'? ");
INSERT INTO ztp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zyasa xe mbwiꞌ Jesus lo reta xaꞌ nzi tya nde nchab Jesus lo xaꞌ ta mbis yanꞌ ya: —Ptogaꞌ yaꞌa. Zyasa mtogaꞌ xaꞌ yaꞌ xaꞌ nde mdyanꞌ yaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Per re maestr nchak ley nde re xaꞌ fariseo jwanꞌ toz mxi lazoꞌ xaꞌ, nde mdobte mdodiꞌs re xaꞌ, sa nyenꞌ cho kwan lino xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nde len' re wiz ya ngwa Jesus thi yek yiꞌ sa todiꞌsno Jesus Dios, nde dib yalꞌ ya mdodiꞌsno Jesus Dios. ");
INSERT INTO ztp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Senꞌ mduxni mbrez Jesus re xin'te'd Xaꞌ, nde mblí Xaꞌ thib sen xaꞌ, nde re thib sen xaꞌ ya mblole Jesus Apost. ");
INSERT INTO ztp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Re xaꞌ ya nak: Simon xaꞌ jwanꞌ mbloꞌlegaꞌ Jesus Pedr, Ndres wes Simon, Jakob, Juan, Blib, Bartol, ");
INSERT INTO ztp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Max, Jakob xinꞌ Alfeo, Simon xaꞌ nzo xij partid kananist, ");
INSERT INTO ztp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas wes Jakob nde Judas Iscariot, xa' jwanꞌ mdaꞌyaꞌ Jesus sa kuj xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zyasa mdola Jesus yiꞌ ya kon re apost Xa' nde mbled Xaꞌ thi lo laꞌs. Nde bro toz re xin' ted Xa' nzi tya, taga men toz tir mdyop jwanꞌ nde re yez nzi dib lo xyon Judea, yez Jerusalen, re yez nzi gax ro nitto lo xyon Tiro nde lo xyon Sidon, reta men mzin sa gon men jwanꞌ ndej Xa' nde sa dyanꞌ men lo re yis ndyak men. ");
INSERT INTO ztp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nde reta men jwan' nzo mbi narax lazon' mtodanꞌ Xa' men. ");
INSERT INTO ztp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Zyasa reta men ncholaꞌs gal men lad Xa', tak lad Xa' ndryoꞌ re yalne jwan' dyanꞌ re men nayiz. ");
INSERT INTO ztp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus mbwiꞌ lo re xin'te'd Jesus, nde nchab Jesus lo xaꞌ: —Nabeꞌz toz nda re goꞌ ta ngekwan ngeno, tak chanꞌ goꞌ nak tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ꞌNabeꞌz toz nda goꞌ jwanꞌ ndyanꞌ naya, tak nix tse goꞌ, ꞌNabeꞌz toz nda goꞌ ta nchonꞌ naya, tak tsin wiz xi goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ꞌNabeꞌz toz nda go' senꞌ ngiꞌno men goꞌ, senꞌ na'nzal'tatra' men go', senꞌ ndloꞌs men goꞌ nde senꞌ nixin men xis goꞌ xaja men xkapa, por ndli lazoꞌ goꞌ na Xin' Mbi'. ");
INSERT INTO ztp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nale toz blo lazoꞌ goꞌ wiz ya, tak naro toz nak jwanꞌ kayaꞌ goꞌ lo beꞌ, tak taga' re xaꞌ gox lo go' mtoti xaꞌ re profet ngo pola. ");
INSERT INTO ztp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ꞌPer nalat tyak re goꞌ xa' rik, tak ngenoa goꞌ yalnale chanꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ꞌNalat tyak goꞌ ta ngeno jwanꞌ ncha naya, tak tsin wiz tyak goꞌ win! ꞌNalat tyak goꞌ jwanꞌ ta nale nzo lazonꞌ naya, tak tsin wiz gon goꞌ lo yalnabil. ");
INSERT INTO ztp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ꞌNalat tyak re goꞌ ta nabe'z ni re men xis go' naya, tak taga' nabe'z mni xaꞌ gox lo goꞌ xis re profet kwinꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ꞌPer na ni lo re goꞌ jwanꞌ ndoyon xkiꞌs na: Pkeꞌ lazoꞌ goꞌ re xa' nakap nak lo goꞌ, wen bli goꞌ lo re xaꞌ jwan' ngotal goꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bli ley' goꞌ re xaꞌ naxin ni xis goꞌ, mnaꞌb goꞌ lo Dios por re xaꞌ nke' yalkwin' xis goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tez cho ti xaꞌ keꞌy thi lad kwat la, pta' tedib lad kwat la keꞌ xaꞌy, nde tez cho xaꞌ kib chamar la, ptaꞌ diꞌs we xaꞌ noga camis la. ");
INSERT INTO ztp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nde tez cho xa' nyaꞌb thi jwan' loa ptaꞌy, nde tez cho xaꞌ kib jwanꞌ nak chanꞌ la, naꞌnyaꞌbta lay lo xa' sere xa'y. ");
INSERT INTO ztp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bli goꞌ lo re men a xaja ndryoꞌ lazoꞌ go' li men lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tak tez benꞌta nkeꞌ lazoꞌ goꞌ re xaꞌ nkeꞌ lazonꞌ goꞌ, ¿Cho yalwen ndoli goꞌ sa? Tak axta re xaꞌ ndli jwanꞌ narax ndli jwan' na. ");
INSERT INTO ztp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nde tez ben'ta ndli goꞌ yalwen lo re xaꞌ ndli wen lo goꞌ, ¿Cho yalwen ndoli goꞌ sa? Tak axta re xaꞌ ndli jwanꞌ narax taga' ndli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nde tez benꞌta ndaꞌ goꞌ prest lo re xaꞌ jwanꞌ tak kotay, ¿Cho yalwen ndoli goꞌ sa? Tak axta re xaꞌ ndli jwanꞌ narax, ndli prest xaꞌ jwanꞌ lo ta xaꞌ nde ngebed xaꞌ kayaꞌ xaꞌ xinꞌ neꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per goꞌ ndablo keꞌ lazoꞌ goꞌ re xaꞌ jwanꞌ nayiꞌ lo goꞌ, bli goꞌ yalwen lo xa', nde bkwan' prest go' jwan' ka xa' na'kembedta goꞌ kayaꞌ go nek thib jwanꞌ yotay. Tamod sa naro ak yalwen kayaꞌ goꞌ nde ndlo' nak goꞌ xinꞌ Dios ro, tak Dios wen toz nak Xa' lo re men nandyod cho nzo Dios nde lo re men ndli jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gok goꞌ men ndlat lazonꞌ ta mena, ta xa xud go' Dios ndlat lazoꞌ Xaꞌ reta men. ");
INSERT INTO ztp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Naꞌkoxyod goꞌ men, sa naꞌnyabta Dios kwent lo goꞌ. Nake'd goꞌ yalke yek men sa naꞌkeꞌd Dios yalke yek goꞌ, nde bri'd goꞌ yek go' re jwan' narax ndli men lo goꞌ sa taga' ton' Dios re xken go'. ");
INSERT INTO ztp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ptaꞌ goꞌ jwan' lo men nde Dios taꞌy lo goꞌ, kej sak, sib xa'y nde axta ndorasa ta' xa'y lo go', tak xa nchix goꞌ jwanꞌ ndaꞌ goꞌ taga' chix Dios jwanꞌ taꞌ Dios lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nde mdej Jesus thi kwent re': —¿Cho tak koꞌb thi xaꞌ nkow ngud lonꞌ ned lo tedib xaꞌ nkow ngud lonꞌ? ¿Cho naꞌgapta rop xaꞌ lenꞌ yeꞌr? ");
INSERT INTO ztp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nek thib xin' nte'd maestr mas ntak lo maestr, per senꞌ mne mteꞌd xaꞌ zyasa ak xaꞌ xaja Maestr xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ꞌ¿Kwan liy ngwiꞌa yix lud nzo ngudlo wes la, nde nangwiꞌt la ya ro nzo le'ga ngudloa? ");
INSERT INTO ztp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nde tez nangwiꞌt la ya ro nzo leꞌga ngudloa, ¿Xamod ncholaꞌs la gab la lo wes la nde btan' la: \"Ptaꞌ diꞌs sa go'ten yix lud nzo ngudloa ba?\" ¡Ma kwinꞌ! Nerla bloꞌ ya ro nzo ngudloa, sa jwin wiꞌa, seraꞌ ko'a yix lud nzo ngudlo wes la nde btan' la. ");
INSERT INTO ztp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesus nchab ngenta ya wen jwanꞌ nda' ngud mbye'd nde naꞌngenta ya yis jwanꞌ ndaꞌ ngud wen. ");
INSERT INTO ztp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tak re ya ncholo mena lo xa nak ngud nda'y. Nanthopta men ig lo ya yis neka nanthopta men ub lo yis ti. ");
INSERT INTO ztp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Men wen, ngo' men jwan' wen nzo lazo' men lo ndyodi's men nde men xkap, ngo' men jwan' xkap nzo lazo' men lo ndyodi's men, tak jwanꞌ mas nzo lazoꞌ men, jwanꞌ na ndryoꞌ ro men. ");
INSERT INTO ztp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ꞌ¿Cho kwan liy mbez goꞌ lon, \"Xaꞌ nyebeꞌ, Xaꞌ nyebeꞌ \", nde nandlid goꞌ jwanꞌ nin lo goꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Naya tej na lo goꞌ xamod nak xaꞌ nchon xkiꞌs na nde ndli xaꞌ jwanꞌ mbez na lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nak xaꞌ xaja thi xaꞌ mtaꞌ thi yo. Nerla na's mdenꞌ xaꞌ tenꞌ tyob xanꞌ neꞌy nde xis ke mdob xa' xan' ne'y nde senꞌ mxyen yoꞌ, ngwap nit nde dib ne nit mkanꞌ na lad yo, per naꞌndlidey gan nkwina yo, tak xis ke ndob yo. ");
INSERT INTO ztp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per xaꞌ nchon xkiꞌs na nde nandlid xaꞌy, nak xaꞌ xaja thi xaꞌ jwanꞌ ntaꞌ yo tata lo izyo nde naꞌngyen'ta xa' tenꞌ ngo xanꞌ yo, senꞌ mxyen yoꞌ nde dib ney mkanꞌ na lad yo, mbyub yo nde thiptane mbil la. ");
INSERT INTO ztp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Senꞌ mne mni Jesus lo re men, mbroꞌ Jesus nda Jesus yez Capernaum. ");
INSERT INTO ztp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nde yez ya nzo thi xaꞌ Rom, jwanꞌ nyebeꞌ lo thib ayoꞌ sondad, xaꞌ ya ngeno thi mos jwanꞌ nkeꞌ toz lazoꞌ xaꞌ, nde jwanꞌ toz nayiz mos, mer gaj mos. ");
INSERT INTO ztp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Senꞌ mbin xaꞌ nyebeꞌ ya ndej men Jesus, mtelꞌ xaꞌ pla xaꞌ Israel xaꞌ gox jwan' nyebe' lo re xa' Israel, sa ya naꞌb xaꞌ lo Jesus yeꞌd todanꞌ Jesus mos xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Senꞌ mzin re xaꞌ lo Jesus mnaꞌb toz xaꞌ lo Jesus nchab xaꞌ: —Nzal' ye'd la'stoa xaꞌ nyebeꞌ lo sondad. ");
INSERT INTO ztp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tak nkeꞌ lazoꞌ xaꞌ na', xaꞌ Israel nde mtaꞌ xaꞌ thi yo tenꞌ ndyop na'. ");
INSERT INTO ztp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Zyasa nda Jesus kon re xaꞌ ya, per senꞌ ndozin Jesus gax liz xaꞌ, zyasa leꞌ xaꞌ nyebeꞌ ya mtelꞌ pla xa' nzal' ta xaꞌ, ngwa yab lo Jesus: —Naꞌlit la xgab yotea lenꞌ liz na, tak nanzalꞌta na yotea lenꞌ liz na; ");
INSERT INTO ztp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","jwanꞌ nasa na'ngad yub na ngaxin la. Per benꞌta mnabeꞌ lo yis sa dyanꞌ mos na. ");
INSERT INTO ztp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tak noga na ngenon xaꞌ nyebeꞌ lon, nde noga ngenon re sondad jwanꞌ nyebeꞌn lon'. Senꞌ gab na lo thi xaꞌ, \"wa\", nda xaꞌ, senꞌ gab na lo thib xaꞌ, \"deꞌ \", nde xaꞌ, nde senꞌ nyebeꞌn lo mos na li xaꞌ thi jwanꞌ, ndli xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Senꞌ lo mbin Jesus jwanꞌ reꞌ leꞌka nzoyen Jesus, nde mbwiꞌ Jesus lo reta men ndanke xis Jesus nde nchab Jesus: —Lipa nin lo goꞌ ke nek thib xaꞌ Israel teraꞌ yosal na jwanꞌ ndli toz lazonꞌ xaja ndli lazoꞌ mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nde senꞌ mbere re xaꞌ ta mtelꞌ xaꞌ nyebeꞌ lo re sondada liz xaꞌ, mbwiꞌ xaꞌ leꞌ mos xaꞌ ya mdyanꞌla. ");
INSERT INTO ztp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Senꞌ mne mbrid re jwanꞌ reꞌ, ngwa Jesus thi yez ndole Nain, kon re xin'te'd Jesus nde men toz ndanke xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Senꞌ ndozin Jesus gax ro yez, mbwiꞌ Jesus nda ka's xa' thi thabol, nde thabol ya nak xinꞌ thi ngol nguj sal' na', thib nya or lo ngol. Nde men toz nda li kompay ngol. ");
INSERT INTO ztp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Senꞌ mbwiꞌ Jesus ngol ya, mblat lazoꞌ Jesus xaꞌ nde nchab Jesus lo xaꞌ: —Naꞌgonta la. ");
INSERT INTO ztp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nde mbike Jesus gax cho lon' nde mbwal Xa'y, leꞌ re xaꞌ neꞌ lon' nzob or nguja ngoto xaꞌ, nde nchab Jesus lo or nguja: —Mbyo, nin loa: ¡Goche! ");
INSERT INTO ztp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Zyasa ngoche or nguja nde mdobte mdodiꞌs or, nde mdaꞌya' Jesus or lo xnaꞌr. ");
INSERT INTO ztp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Le' reta men ta nzi wiꞌ ya mzyeb toz xa' jwanꞌ ta ngoka, nde mdobte ni xaꞌ diꞌs wen lo Dios nchab xaꞌ: —Thi profet ro nzo xij naꞌ. Nde nchaba xaꞌ: —Dios nde laꞌsto re men yez Dios. ");
INSERT INTO ztp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nde dib lo xyon Judea nde re yez nzi dib tya mbin xaꞌ jwanꞌ mbli Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Re xa' xin'te'd Juan ta ngole mena mdej xa' lo Juan re jwanꞌ mbli Jesus. Zyasa mbrez Juan chop xin'te'd Juan, ");
INSERT INTO ztp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nde mtelꞌ Juan xaꞌ lo Jesus, sa nyabdiꞌs xaꞌ lo Jesus: \"¿Cho lu nak xaꞌ ta nak kwent telꞌ Dios o ndablo kwed xaꞌ tediba xaꞌ?\" ");
INSERT INTO ztp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Senꞌ mzin rop xaꞌ ta mtelꞌ Juan na lo Jesus, nchab xaꞌ: —Juan ta ngole men mtel' ná' sa nyabdi's ná' loa: \"¿Cho lipa lu nak xaꞌ ta nak kwent telꞌ Dios o ndablo kwed náꞌ tedib xaꞌ?\" ");
INSERT INTO ztp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nde le'xa zyapa mtodanꞌ Jesus bro men nayiz, re men ndyak yalti, re men jwanꞌ nzo mbi narax, nde bro men nglwe mtodanꞌ Jesus ngudlo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Zyasa mkab Jesus lo xin'te'd Juan nchab Jesus: —Bya goꞌ nde btej goꞌ lo Juan reta jwanꞌ mbwiꞌ goꞌ nde reta jwanꞌ mbin goꞌ, re xaꞌ nglwe, ngwiꞌ xaꞌ, re xaꞌ naꞌakta tye ndye xaꞌ, re xaꞌ ndyak ye'sya's, mbyak xaꞌ, re xaꞌ nkweꞌ mxyalꞌ nza xaꞌ, re xaꞌ nguj mbroꞌxban, nde re xaꞌ prob ndoyon xa' diꞌs wen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nabeꞌz toz nda xaꞌ jwan' nanchakropta xgab na' kwent ndyonke xa' xis na. ");
INSERT INTO ztp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Senꞌ ndyala re xin'te'd Juan, Jesus mdobte mdodi's Xa' kwent chanꞌ Juan lo re men nchab Xa': —¿Cho kwan mbwi' go' sen' ngwa go' izyo nagan? ¿Cho benta thi yi nkwin mbi mbwiꞌ goꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Per, ¿cho ngwa wiꞌ goꞌ sa? ¿Cho thi mbiꞌ nok lar nap toza? Goꞌ mne le' re xaꞌ ndyokwa' nde re xa' ngeno re jwan' nap, liz rey nzo xa'. ");
INSERT INTO ztp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Per, ¿cho ngwa wiꞌ go sa? ¿Cho thi profet mbwiꞌ goꞌ? Lipa, nin lo goꞌ, thi profetka ngwa wiꞌ goꞌ, nde xa' nak mas ke thi profet. ");
INSERT INTO ztp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan reꞌ ngetej xkiꞌs Dios, tenꞌ nchab: Na telꞌ thi xaꞌ kwiblo loa, xaꞌ toxkwaꞌ xned la. ");
INSERT INTO ztp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ni lo goꞌ, xij reta mbi' ngol xis izyo re', tera' yo thi profet mas ntak lo Juan, per xaꞌ jwanꞌ mas lud ntak ten' nyebe' Dios, xaꞌ ya mas ntak lo Juan. ");
INSERT INTO ztp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Senꞌ mbin re men jwan' na nde axta re xaꞌ nthop tmi low par yez Rom mbyolo xa' gal' nak xned Dios, nde mblole Juan xa'. ");
INSERT INTO ztp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per re xaꞌ fariseo nde re maestr nchak ley, mblotal xaꞌ yalwen jwanꞌ nchola's Dios li Dios lo xaꞌ, tak na'ndeyalta xa' ngo'le Juan xa'. ");
INSERT INTO ztp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zyasa nchab Jesus: —¿Cho kwan kalal na kon re men nzo tyemp reꞌ? ¿Cho kwan lal nak xa'? ");
INSERT INTO ztp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nak xa' xaja re mbyo ta mbe lo xbiꞌ ngija nde mbez lo tan': \"Mkeꞌ náꞌ flaut, nde naꞌnkanida goꞌ, mbilꞌ náꞌ di nabil ndye, nde naꞌngonꞌta goꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tak mbyeꞌd Juan ngole men, namdada xaꞌ pan nde nanguꞌda xaꞌ bin, nde mbez goꞌ mbi narax nzo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mbye'd Xin' Mbi' ncha nde nchu', nde mbez goꞌ xaꞌ wacho nde xaꞌ nchuꞌ bin, nde nzalꞌ ta xa' re xaꞌ nthop tmi low par Rom nde kon re xaꞌ nzo'b xken na'. ");
INSERT INTO ztp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per yalnchak chan' Dios ndloꞌ ndonoy re men jwanꞌ lí nkwan' na. ");
INSERT INTO ztp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Zyasa thi xaꞌ fariseo mna'b lo Jesus, sa ya tha Jesus liz xaꞌ, senꞌ ngote Jesus len' liz xaꞌ mdob Jesus ro mes. ");
INSERT INTO ztp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nde yez ya nzo thi ngol jwanꞌ nzoꞌb xken naꞌ, senꞌ mne ngol ndobya Jesus liz xa' fariseo, ngwa ngol nde mbeꞌ ngol thi bot naksa' ke ndole alabastro nzo perfum. ");
INSERT INTO ztp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nchonꞌ ngol ndoxub ngol lad xis Jesus, nde kon nit mbe lo ngol mbwaz ngol ni Xa', xisa kon yis yek ngol mkwiꞌs ngol ni Xaꞌ, mda ngol chut ni Xaꞌ nde mchub ngol perfum ni Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Senꞌ mbwiꞌ xaꞌ fariseo ta mbeꞌ Jesus liz naꞌ ya, jwanꞌ mbli ngol ya, mbli xaꞌ xgab: \"Tez liga profet nak Xaꞌ reꞌ, mnea Xaꞌ cho men nak ngol ta ndo gal Xaꞌ, ngol nzo'b xken na'y.\" ");
INSERT INTO ztp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Zyasa nchab Jesus lo xaꞌ fariseo: —Simon, ncholas na tej na thi jwanꞌ loa. Le' Simon mkab: —Pteja, Maestr. ");
INSERT INTO ztp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus nchab: —Ngo chop xaꞌ nda'b tmi lo thi xaꞌ ngoꞌ prest. Thib xaꞌ ndab gayꞌ ayoꞌ tmi plat. Nde tedib xaꞌ nda'b chop siꞌ tmi plat. ");
INSERT INTO ztp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nde nek thib xa' nandlid gan ngixa lo xaꞌ ta mda' prest tmi ya, zyasa xaꞌ ta mda' prest tmi ya mton' xa' jwan' nda'b rop xa' ya. Naya ptej lon, ¿Lo rop xa', xanya xa' mas nke' lazo' xa' jwan' ta mda' prest tmi ya? ");
INSERT INTO ztp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Leꞌ Simon mkab: —Nda lazoꞌn xaꞌ jwanꞌ mdyon' mas bro tmi nda'b ba. Jesus nchab: —Lin lay. ");
INSERT INTO ztp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Zyasa mbwiꞌ Jesus lo ngol nde nchab Jesus lo Simon: —¿Bwiꞌ nea, ngol reꞌ? Senꞌ ngoteꞌn len' liz la namdat la nit ngech nin, per ngol reꞌ mtach nin kon nit mbe ngudlo ngol nde mtokwiꞌs ngola kon yis yek ngol. ");
INSERT INTO ztp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Namdad la chut kwat na, per ngol reꞌ xata ngoten liz la ndoya ngol chut nin. ");
INSERT INTO ztp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Namchupta la aseyt yek na, per ngol reꞌ mchub perfum nin. ");
INSERT INTO ztp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jwan' nasa na ni loa, reta xken ngol mdyon'la, jwanꞌ na bro toz nkeꞌ lazoꞌ ngol na, per xaꞌ lud xken naꞌ ndyonꞌ, lud nkeꞌ lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zyasa nchab Jesus lo ngol: —Reta xken la mdyon'la. ");
INSERT INTO ztp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nde re xaꞌ jwanꞌ nzino Jesus ro mes, nchab xaꞌ: —¿Cho nak Xaꞌ reꞌ, sa no Xa' nton' xken men? ");
INSERT INTO ztp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Per Jesus nchab lo ngol: —Tak mbli lazoꞌa na, jwanꞌ na mblya lo xken la, nabe'z bya. ");
INSERT INTO ztp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Senꞌ mne re jwanꞌ reꞌ, Jesus mkete naꞌr yez ro nde re rach, mkete loꞌ Jesus xkiꞌs Dios nde yalnyebe' chan' Dios lo re men nde kon re thib sen apost Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nogaꞌ pla ngol ngetenke xis Jesus jwanꞌ ta mtodanꞌ Jesus lo yis nde mbloꞌte Jesus mbi narax lazon'. Xija nda Mari xaꞌ ndolegaꞌ Magdalen, xaꞌ jwanꞌ mbloꞌte Jesus gaz mbi narax lazon'. ");
INSERT INTO ztp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","No ngol ndole Juán salꞌ xaꞌ ndole Chuza, xaꞌ jwanꞌ ndli sinꞌ lo Herodes nde Susan, nde temasraꞌ ngol jwanꞌ ndli kompay Jesus kon re jwanꞌ ngeno ngol. ");
INSERT INTO ztp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zyasa men toz mbroꞌ re yez ngwa wiꞌ xaꞌ Jesus, nde senꞌ mketa bro toz men lo Jesus, mdaꞌ Jesus thi diꞌs nagan yen men chanꞌ thi xaꞌ ngo bin. ");
INSERT INTO ztp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ngo thi xaꞌ ngobin mbro' nda lo mbis laja ngecha's xa'y ten' yoy, play ngob ro ned nde mdob ni mena nde mda mbina, ");
INSERT INTO ztp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","nde thi pla mbis ngob xij ke, mblyena nde mbiza, tak ngenta yo nakop sa xyena. ");
INSERT INTO ztp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Thi pla mbis ngob xij yis, le' yis ta thita mblyen kon mbisa, mko'ta yek mbis ta mblyena. ");
INSERT INTO ztp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per thi pla mbis ngob izyo wen, mblyena nde mxyena nde kad thibay mdaꞌy ayoꞌga mbis. Nde senꞌ mne mdaꞌ Jesus kwent reꞌ, mas ne mni Xa' nchab Xa': —¡Re xaꞌ ndob nzan, gon xaꞌ jwanꞌ reꞌ! ");
INSERT INTO ztp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Zyasa re xin'te'd Jesus mnabdiꞌs xa' lo Jesus: —¿Xamod nak kwent nagan reꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus nchab: —Dios ndli sa yen goꞌ re jwanꞌ nzo nagaꞌs tenꞌ nyebeꞌ Dios, per lo temas xaꞌ nagan ndej na re kwent, sa tenye ngwiꞌ xaꞌy naꞌyonida lo xaꞌ, tenye nchon xaꞌy, naꞌyenta xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cheꞌ mod nak kwent nagan reꞌ: mbis nak xki's Dios. ");
INSERT INTO ztp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Le' lo ta ngoba ro neda nak xa' nchon xkiꞌs Dios, per nde maxuꞌ nde nkib maxuꞌy lazoꞌ xa', sa naꞌlid lazoꞌ xay nde naꞌlyaꞌd xa'. ");
INSERT INTO ztp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Le' lo ta ngoba xij ke, nak xa' jwanꞌ nchon xkiꞌs Dios nde dib nale nzo lazoꞌ xa' ndli lazoꞌ xa'y, per nak xa' xaja trig ngenta bro lox naꞌ, ndli lazoꞌ xaꞌy lud tyemp nde senꞌ nde cho yalti lo xa'. zyaga ndlaꞌ xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Le' mbis ngob xij yisa nak xa' jwan' nchon xkiꞌs Dios, per senꞌ ndli xa' xgab re jwan' lo izyo re', ndyen xa' ak rik xa' nde ndyabla's xa' re jwanꞌ lo izyo, jwan' na ndli sa na'nxyenta xa' lo xki's Dios. ");
INSERT INTO ztp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbay le' mbis jwanꞌ ngob lo yo wena, nak xa' jwanꞌ nchon xkiꞌs Dios, nde ndli lazoꞌ xaꞌy dib nzo lazoꞌ xaꞌ nde nxobyek xaꞌy nde ne ndo xaꞌ lo xkiꞌs Dios, xaja' jwanꞌ bin ndaꞌ bro jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ngencho ntob xni thi kandil nde ntowꞌ xa' yek neꞌy kon thi jwanꞌ, o ntob xaꞌy xanꞌ kam, cheꞌla gap ntob xaꞌy, sa toꞌxniy lo re xaꞌ nchote lenꞌ yo. ");
INSERT INTO ztp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nde taga' ngenta jwanꞌ nzonagaꞌs na'ryoꞌxobta nde ngenta jwanꞌ nanyed men naꞌryo'xobta, retay tro'xobka. ");
INSERT INTO ztp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jwanꞌ nasa jwin bin goꞌ jwanꞌ nin lo goꞌ, tak xaꞌ jwanꞌ nchenla, masra' yen xaꞌ, per xaꞌ jwanꞌ lud nchen, axta jwan' ndli xa' xgab nchen xaꞌ, yiꞌba lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Zyasa mzin xnaꞌ Jesus na re wes Jesus tenꞌ ndo Jesus, per naꞌngakta mbike xaꞌ gax lo Jesus tak bro toz men nzi tya. ");
INSERT INTO ztp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Zyasa thi xa' ngwayab lo Jesus: —Xnaꞌa nde re wes la nzi le nde ncholaꞌs xaꞌ wiꞌ xaꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nde Jesus mkab lo xaꞌ: —Reta xaꞌ jwanꞌ nchon xkiꞌs Dios nde nxoꞌbyek xaꞌy, xaꞌ ya nak xnaꞌn, nde re wes na. ");
INSERT INTO ztp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Thib wiz, Jesus kon re xin'te'd Xa' ngo Xa' lenꞌ thi bark, nde nchab Xa' lo re xaꞌ: —Ndanꞌ tedib lad ro nittoꞌ. Zyasa nda re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Laja nda bark lo nittoꞌ, mdat Jesus. Zyasa mxyo'b thi mbi toz tir lo nit, nde tolo ndola nit lenꞌ bark, ya mer ndolana's bark lenꞌ nit. ");
INSERT INTO ztp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Zyasa mbloꞌxkalꞌ xaꞌ Jesus, nchab xaꞌ: —¡Maestr! ¡Maestr! ¡Ya mer ndolanꞌ lenꞌ nittoꞌ! Zyasa ngoche Jesus nde mni Xa' lo mbi nde lo bde nde xej ngotaꞌba, mbre xe retey. ");
INSERT INTO ztp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zyasa nchab Jesus lo re xin'te'd Xa': —¿Cho nandlid lazoꞌ go Dios? Per re xaꞌ nzyeb xaꞌ nde nzoyen xaꞌ, nyabdiꞌs xaꞌ lo ta xaꞌ nchab xaꞌ: —¿Cho nak Xaꞌ reꞌ, axta lo mbi nde lo bde nyebeꞌ Xaꞌ nde nxobyeka Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Zyasa mzin xaꞌ las men Gadara, jwanꞌ nzi ro nittoꞌ, ngoꞌ lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nde senꞌ mbla Jesus lo bark, mbyeꞌd thi xaꞌ yez ya mbike lo Jesus. Xaꞌ ya, ndala nzo mbi narax lazo' xaꞌ, nde tata kacheꞌy xaꞌ ngete xaꞌ, nanchod xaꞌ thi yo, cheꞌla re xij baꞌ ncho xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nde senꞌ mbwiꞌ xaꞌ Jesus, mdoxub xaꞌ lo Jesus nde mbrez yaj xaꞌ nchab xaꞌ: —¿Cho kwan ndyaknoa na Jesus Xinꞌ Dios ro? ¡Nyaꞌb na loa naꞌtotit la na! ");
INSERT INTO ztp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ta nchab xaꞌ, tak Jesus mnebeꞌ lo mbi narax ryoꞌtey lazoꞌ xaꞌ, tak naꞌr toz gob jwanꞌ toz mtoti mbi narax xaꞌ, nde tenye ntobo men yaꞌ xaꞌ nde ni xaꞌ kon kaden, sa naꞌxyonꞌta xaꞌ, per nyay nchoꞌ xaꞌ nde nche' mbi naraxa xa' re tenꞌ nagan. ");
INSERT INTO ztp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zyasa mna'bdiꞌs Jesus lo xaꞌ: —¿Cho lea? Le' mbi ya mkab: —Na ndole Legion. Ta nchab xaꞌ, tak bro toz tir mbi narax, mbla len' lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nde re mbi naraxa mnaꞌb toz lo Jesus sa natelꞌta Xaꞌy lenꞌ poz ngenta xanꞌ na'. ");
INSERT INTO ztp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nde gax tya nzi bro toz nguch lo kox nzi ya, zyasa mna'b toz re mbi naraxa lo Jesus sa taꞌ Jesus diꞌs yotey lenꞌ re nguch nde mdaꞌ Jesus diꞌs ngotey lenꞌ re nguch. ");
INSERT INTO ztp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zyasa mbroꞌte reta mbi naraxa lazoꞌ mbi' ya nde mblay lenꞌ re nguch, zyaga reta nguch mkeꞌ karel nde mbixndaꞌb nguch ble, mbla nguch lenꞌ nit nde ngwap nguch. ");
INSERT INTO ztp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nde senꞌ mbwiꞌ reta xaꞌ jwan' ngenap nguch jwanꞌna, mbroꞌ xaꞌ karel ngwatne xaꞌy lo re xaꞌ nzo yez nde nzo dib re ro yez. ");
INSERT INTO ztp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Zyasa re men ngwa wiꞌ jwanꞌ ngok, senꞌ mzin re men tenꞌ ndo Jesus, mbwiꞌ xaꞌ leꞌ xa' ta mbro' mbi narax lazonꞌ ya ndob lo Jesus, nok xab xaꞌ nde mdyanꞌ tir xaꞌ, zyasa jwanꞌ toz mzyeb re men. ");
INSERT INTO ztp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nde reta xaꞌ ta mbwiꞌ jwanꞌ ngok, mdej xaꞌ xa mdyanꞌ xaꞌ nzo mbi naraxa. ");
INSERT INTO ztp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Zyasa reta xaꞌ xyon Gadara, mna'b xaꞌ lo Jesus sa ryoꞌte Jesus tya, tak jwanꞌ toz mzyeb xaꞌ. Zyasa ngwap Jesus lo bark nda Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Leꞌ xaꞌ ta mbroꞌte re mbi narax lazonꞌ ya, mnaꞌb xa' lo Jesus sa taꞌ Jesus diꞌs tyonke xaꞌ xis Jesus, per Jesus mnibeꞌ yanꞌ xaꞌ, nde nchab Jesus lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Bere liz la nde btej plopa naro re jwanꞌ mbli Dios loa. Zyasa ndya xaꞌ, nde ngwa tej xaꞌ lo reta men yez xaꞌ, plopa naro re jwan' mbli Jesus lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Senꞌ mbere Jesus tedib lad ro nittoꞌ, reta men toz tir nzi tya ngo nale lazoꞌ xaꞌ mzin Jesus, tak nzimbedla xaꞌ sin Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Zyasa mzin thi mbiꞌ ndole Jairo lo Jesus, xaꞌ ya nak xaꞌ nyebeꞌ lenꞌ yo tenꞌ ndyop xaꞌ Israel. Nde mdoxub xaꞌ lo Jesus mna'b toz xaꞌ sa ya Jesus liz xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tak mza' xinꞌ xa' mer gaj nax lo yis, jwan' nzo thib senka lin' nde thi nyar lo xa'. Lo nda Jesus liz xaꞌ, men toz tir mdonke xis Jesus, anta ngaꞌs xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nde xij reta mena nzo thi ngol, ndala thib sen lin' ndyak yis ndlyaj ren, nde mbyal mkete ngol lo re doktor, mblu'x ngol reta jwanꞌ ngeno ngol nde ngen cho doktor ndli gan ntodanꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Zyasa mbike gax ngol a'xis Jesus, mbwal ngol lad xab Jesus, nde hor yaga ngota'b yis lo ngol. ");
INSERT INTO ztp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Zyasa mna'bdiꞌs Jesus: —¿Cho mbwal lad xab na? Nde reta xa' mkab namblid xa'y, zyasa Pedr kon temas xa' nchab lo Jesus: —Maestr cho nangwi'd la men toz ngaꞌs la nde ntobyaꞌ xaꞌ la, nde nya'bdiꞌs la: \"¿Cho mbwal lad xab na?\" ");
INSERT INTO ztp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Per Jesus bere nchab: —Thi xaꞌ mbwal xab na, tak nden' na mbroꞌ yalne lad na. ");
INSERT INTO ztp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nde senꞌ mne ngol naꞌgakta ka's ngol, nde anta nxiꞌd xa' bike xa', mdoxub xa' lo Jesus, nde nzi wi' reta men, mbloro ngol kwan liy mbwal ngol xab Xa', nde mdej ngol hor yaga ngotab yis . ");
INSERT INTO ztp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Zyasa nchab Jesus lo ngol: —Xinꞌ na, tak mbli lazoꞌa na, jwan' na mbyak la, nde naya nabeꞌz bya. ");
INSERT INTO ztp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tata benꞌ ndo todiꞌs Jesus, senꞌ mzin thi xaꞌ mbro' liz Jairo ta nyebe' lo yo ten' ndyop xa' Israel nde nchab xa': —Naꞌtyodoꞌtra' la lo Maestr. Tak ngujla xinꞌ la. ");
INSERT INTO ztp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Per lo mbin Jesus jwan' na nchab Jesus lo Jairo: —Naꞌzyepta la, benꞌta bli lazoꞌa Dios, nde xinꞌ la dyan'. ");
INSERT INTO ztp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nde senꞌ mzin Jesus liz Jairo, naꞌndad Jesus diꞌs ngate re men lenꞌ yo, benꞌta Pedr, Santiag nde Juan, kon xud mzaꞌ nde xnaꞌ mzaꞌ ngoteno Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nde reta men nabil ndyak, nchonꞌno xaꞌ mzaꞌ. Per Jesus nchab lo re men: —Naꞌgonta goꞌ, nangujta mzaꞌ, benꞌta naxyat mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Leꞌ re men mxino xaꞌ Jesus, tak mnea xaꞌ nguj mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Zyasa mxen Jesus yaꞌ mzaꞌ nde ne mni Xa' lo mzaꞌ: —¡Mzaꞌ, goche! ");
INSERT INTO ztp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Zyasa mbere xbin mzaꞌ, nde zyaga ngoche mzaꞌ, nde mnebeꞌ Jesus taꞌ xaꞌ jwanꞌ wa mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Leꞌ xud mzaꞌ nde xnaꞌ mzaꞌ nzoyen toz xaꞌ, per Jesus mnibe' lo xaꞌ, ngen cho lo gab xa' jwanꞌ ngok. ");
INSERT INTO ztp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zyasa mthop Jesus re thib sen xin'te'd Jesus, nde mdaꞌ Jesus yalne nde yalnyebeꞌ lo re xa' sa koꞌte xaꞌ re ned mbi narax nzo lazo' men nde sa todanꞌ xaꞌ re men nayis. ");
INSERT INTO ztp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nde mtelꞌ Jesus xaꞌ sa yatej xaꞌ di's wen chanꞌ Dios nde ya todanꞌ xaꞌ re men nayiz. ");
INSERT INTO ztp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nde nchab Jesus lo xaꞌ: —Nawed go' nek thib jwan' nakin' go' ned, nawed go' yaga, neka bols, neka jwan' wa go', neka tmiꞌ, neka chop ned lar. ");
INSERT INTO ztp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nde one cho yo sin go', tyata byan' goꞌ axta senꞌ ryoꞌte goꞌ yez ya. ");
INSERT INTO ztp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nde yez jwanꞌ naꞌtad ten' kwed goꞌ, broꞌte goꞌ tya nde bzib goꞌ yothiꞌ ni goꞌ, sa nye xaꞌ ke narax mbli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Zyasa mbroꞌ re xaꞌ, nde nda xaꞌ reta yez, nda tej xaꞌ diꞌs wen chanꞌ Dios nde nda todanꞌ xaꞌ re men yis. ");
INSERT INTO ztp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Senꞌ mbin rey Herodes reta jwanꞌ ndli Jesus, anaꞌnye xaꞌ kwan li xaꞌ, tak cho men mbez mbroꞌxban Juan. ");
INSERT INTO ztp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nde cho men mbez Elias mbroꞌto nde cho men mbez nzo cho thi profet ngo pola, mbro'xban. ");
INSERT INTO ztp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per Herodes nchab: —Leꞌga na mnibeꞌ mchoꞌ yek Juan. ¿Choga xaꞌ taja nchona ndej mena? Jwanꞌ nasa ncholaꞌs Herodes wiꞌ xa' Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Senꞌ mbere re apost Jesus, mdej xaꞌ reta jwanꞌ mbli xaꞌ lo Jesus. Zyasa xaꞌta mbeꞌ Jesus xaꞌ thi tenꞌ nagan lad yez Betsaida. ");
INSERT INTO ztp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per senꞌ mne re mena, mdoke xaꞌ xis Jesus, nde ndyen Jesus mbwi' Jesus xa'. Mbloꞌ Jesus xkiꞌs Dios lo xaꞌ nde mtodanꞌ Jesus re men nayiz. ");
INSERT INTO ztp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nde senꞌ ndozyela izyo, mbike re thib sen xin'te'd Jesus lo Jesus, nde nchab xaꞌ lo Jesus: —Gus lo re men sa ya xaꞌ re yez bix, nde re ranch nzi gax re' sa kwanꞌ xaꞌ tenꞌ ryoꞌxkwen xaꞌ nde kwanꞌ xaꞌ jwanꞌ wa xaꞌ, tak ncheꞌya ngen kwan nak. ");
INSERT INTO ztp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Zyasa nchab Jesus lo xaꞌ: —Pta' goꞌ jwanꞌ wa xaꞌ. Le' re xa' mkab: —Ngenta kwan nak benꞌta gayꞌ pan nde chop mbel ngeno náꞌ, o ¿nakinꞌ yatiꞌ náꞌ jwanꞌ wa re men toz re? ");
INSERT INTO ztp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nde lo re xaꞌ biꞌ, mer ti gayꞌ milka xaꞌ. Zyasa Jesus nchab lo re xin'te'd Xa': —Gus go lo re men, sa tyob xaꞌ por choꞌpsiga xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nde tamod mbli re xin'te'd Jesus, mdob xa' reta men. ");
INSERT INTO ztp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nde mxen Jesus re gayꞌ pan nde rop mbel, mbwiꞌ Xa' lo beꞌ, mdaꞌ Xa' dyux lo Dios, mblirol Xa'y nde mdaꞌ Xa'y lo re xinꞌteꞌd Xa', sa kiꞌd xin'te'd Xaꞌy lo reta men. ");
INSERT INTO ztp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Reta men mda axta ploja mze lenꞌ xaꞌ, ngolo mda xa', re xin'te'd Jesus mthop xaꞌ thib sen chokwid jwanꞌ mbroꞌxob. ");
INSERT INTO ztp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Thib wiz senꞌ xaꞌta nge todi'sno Jesus Dios, nde no re xin'te'd Xa' nzi tya, zyasa mnabdiꞌs Xa' lo re xin'te'd Xa' nchab Xa': —¿Cho xa' nak na mbez men? ");
INSERT INTO ztp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Le' re xa' mkab: —Pla xaꞌ mbez lu nak Juan jwan' ngole men, pla xaꞌ mbez lu nak Elias, nde pla xaꞌ mbez lu nak thi profet ngo pola nde mbroꞌxban. ");
INSERT INTO ztp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Zyasa nchab Jesus: —Mbay goꞌ, ¿Cho na, ndyak go'? Le' Pedr mkab: —Lu nak Crist, Xa' jwan' mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Per Jesus mnibe' lo re xin'te'd Xa', sa ngen cho lo gab xaꞌ jwanꞌ reꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","nde nchab Xa' lo xaꞌ: —Le' Xin' Mbi', nakinꞌ ridndaꞌb bro toz yalti nde reta men kotal men Xa', re xaꞌ gox jwanꞌ nyebeꞌ nde re nglweyꞌ jwanꞌ nyebeꞌ, nde re maestr nchak ley, kuj xaꞌ Xa', per yaxob son wiz ryoꞌxban Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nde nchab Jesus lo reta xaꞌ: —Tez cho goꞌ, nchola's tyonke xis na, bkalo go' lo re jwan' ndyen goꞌ li goꞌ, bta'ya' lazo' go' rid go' pen reta wiz xaja men ne' kruza nde ptonke goꞌ xis na. ");
INSERT INTO ztp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tak re xaꞌ ngenap lazon', xaꞌ ya che' ta'b xa' yalnaban xa', le' re xa' ta'ya' lazon' kwent chan' na, xaꞌ ya ligan yalnaban. ");
INSERT INTO ztp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Tak cho sinꞌ liy lo thi men, li men gan reta jwanꞌ lo izyo reꞌ, tez leꞌga leꞌ men ndyab men nde nge tolux men lazoꞌ men? ");
INSERT INTO ztp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tak tez cho goꞌ ndyolaꞌs kwent chan' na nde kwent chan' xki's na, noga Xin' Mbi' tyola's Xa' nye Xaꞌ go', senꞌ ye'd Xa' kon yalne chanꞌ Xa', kon yalne chan' Xud Xa', nde kon yalne chan' re anj nayon. ");
INSERT INTO ztp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nde lipa nin lo goꞌ, nzo pla men jwanꞌ nzi ncheꞌ ya, nagajta xaꞌ axta kebe' wiꞌ xaꞌ xamod nak tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Senꞌ ngok xonka wiz nchab Jesus jwanꞌ reꞌ, ngwa Jesus thi yek yiꞌ, sa todiꞌsno Jesus Dios, nde mbeꞌ Jesus Pedr, Juan nde Jakob. ");
INSERT INTO ztp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nde laj ndotodiꞌsno Jesus Dios, mzyeꞌ nya lo Jesus, nde xab Jesus anta nakis tir ngok nde anta ndlyabel nyay. ");
INSERT INTO ztp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nde mbroꞌto chop xaꞌ bi' ndotodiꞌsno xa' Jesus, rop xaꞌ ya nak Moises nde Elias, ");
INSERT INTO ztp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","mzalꞌ xni ndlyabel xaꞌ, nde mdodiꞌs xaꞌ kwent chan' yalguj jwanꞌ nakla rid Jesus yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nde Pedr, Juan nde Jakob, jwanꞌ toz ncho mkalꞌ lo xaꞌ, per mbrena xaꞌ, mbwiꞌ xaꞌ xni ndlyabel chanꞌ Jesus nde xni chan' rop xaꞌ jwanꞌ nzino Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nde laj ndya rop xaꞌ ya, Pedr nchab lo Jesus: —Maestr, ¡Wenka nzi náꞌ ncheꞌya! Sa toxkwaꞌ náꞌ son ramad; thiba kaa, thiba ka Moises nde thiba ka Elias. Per Pedr naꞌnyeda kwan li ta nchab Pedr. ");
INSERT INTO ztp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nde laj ndotodiꞌs Pedr, mbla thi xkow mkot reta xaꞌ, nde laj nzo xaꞌ lenꞌ xkow, mzyeb xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nde lenꞌ xkowa mbyen thi diꞌs nchab: —Xaꞌ reꞌ nak xinꞌ na, Xaꞌ jwanꞌ nkeꞌ toz lazo'n, bxoꞌbyek goꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Senꞌ mne mbyen diꞌs ya, thib Jesus ndo. Nde ngen cho lo mdej xa' jwan' mbwi' xa' dib tyemp mkete Jesus lo izyo. ");
INSERT INTO ztp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nde tedib wiz, senꞌ mbere xaꞌ yek yiꞌ, bro toz men mbyeꞌd wiꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Xij re men ya nzo ti xaꞌ biꞌ, ne mbres: —Maestr, nyaꞌb na loa, bwiꞌ xinꞌ na, tak thib nyar ngenon, ");
INSERT INTO ztp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","nde thi mbi narax ndyen or, ndliy mbezyaj or, ngobiy or izyo, nde ndryoꞌ psinꞌ ro or, ntotiy or nde naꞌlaꞌdey or. ");
INSERT INTO ztp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mna'bla na lo re xin'te'd la sa koꞌte xaꞌ mbi narax nzo or, per naꞌndlid xaꞌ gan ndroꞌtey. ");
INSERT INTO ztp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus mkab nchab: —¡Goꞌ nak tib ned men nandlid lazon' Dios nde men xkap nak goꞌ! ¿Axta plopa nakinꞌ ketenon goꞌ, nde xek na goꞌ? Deꞌno xinꞌ la ncheꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Laj ndo bike mbyo gax lo Jesus, mbli mbi narax ngobi mbyo izyo nde mtotiy mbyo; per Jesus mbrezno mbi naraxa, mtodanꞌ Jesus mbyo nde mda'ya' Jesus mbyo lo xud mbyo. ");
INSERT INTO ztp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nde reta men nzoyen xa', mbwiꞌ xa' yalnaro chanꞌ Dios. Laj nzoyen re men re jwan' ndli Jesus, Jesus nchab lo re xin'te'd Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Jwin bin goꞌ jwanꞌ reꞌ nde naꞌyajtey yek goꞌ: Le' Xin' Mbi' tayaꞌ xa' Xa' lo re men sa kuj men Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per naꞌngyenta xaꞌ jwanꞌ nchab Jesus lo xaꞌ, tak teraꞌ taꞌ Dios lo xaꞌ, sa yen xaꞌy; nde nzyeb xaꞌ nyaꞌbdiꞌs xaꞌ kwan ta nchab Jesusa lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zyasa re xin'te'd Jesus tolo mbez xaꞌ lo ta xaꞌ nyen' cho xa' mas ntak xij xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","per Jesus mnela cho xgab ndli xaꞌ. Zyasa mto Jesus thi or lud lo Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nde nchab Jesus lo xaꞌ: —Cho xaꞌ wen ngwi' or lud reꞌ por len, xa' ya wen ngwi' xaꞌ na, nde xa' wen ngwi' na, xaꞌ ya wen ngwi' Xaꞌ jwanꞌ mtelꞌ na. Tak xaꞌ jwanꞌ mas lud ntak xij goꞌ, xaꞌ ya nak xa' mas ntak. ");
INSERT INTO ztp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zyasa nchab Juan lo Jesus: —Maestr, mbwiꞌ náꞌ thi xaꞌ kon lea ngego'te mbi narax nzo lazo' men nde mka náꞌ di's li xaꞌy, tak nangeted xaꞌ kon naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus nchab lo xaꞌ: —Naꞌkad goꞌ diꞌs li xaꞌy. Tak xaꞌ nanaraxta nye naꞌ, kon naꞌ ndo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Senꞌ ndosin gaxla wiz ndya Jesus lo beꞌ, mtoli xgab Xa' ya Xa' Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mtelꞌ Xa' pla xaꞌ ndasiblo, sa ya kwan' xaꞌ yo tenꞌ kwed Jesus yez jwanꞌ nax lo xyon Samaria; ");
INSERT INTO ztp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","per re xaꞌ yez Samaria naꞌndaꞌd xaꞌ tenꞌ kwed Jesus, tak mne xaꞌ leꞌ Jesus nda Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lo mne rop xa' nak xin'te'd Jesus Jakob kon Juan jwan' na, nchab xa' lo Jesus: —Xaꞌ nyebeꞌ, ¿Cho ncholaꞌs la nyaꞌb náꞌ, ryoꞌ ki lo beꞌ sa luxa reta xaꞌ, xa mbli profet Elias? ");
INSERT INTO ztp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Per Jesus mbyek mbwiꞌ lo xaꞌ nde mtokox Jesus xaꞌ: —Goꞌ ba naꞌnyed go' cho men nak goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Leꞌ Xin' Mbiꞌ nandeda sa lux Xaꞌ xbin men, leꞌ Xaꞌ nde sa tolaꞌ Xaꞌy. Nde nda re xaꞌ tediba yez. ");
INSERT INTO ztp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Laj ndo xaꞌ ned, thi xaꞌ biꞌ nchab lo Jesus: —Xaꞌ Nyebeꞌ, na tonkyeꞌn xis la a ploja ndaa. ");
INSERT INTO ztp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus mkab lo xaꞌ nchab: —Re mbeꞌd ngeno maꞌ len' ke tenꞌ ncho maꞌ nde re mbin ngeno maꞌ lye'd maꞌ, per Xin' Mbiꞌ na'ngenod Xa' liz Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nde nchab Jesus lo tedib xaꞌ: —Ptonke xis na. Per xaꞌ ya mkab: —Xaꞌ Nyebeꞌ, nerla pta' di's ngolo mkas na xud na. ");
INSERT INTO ztp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus mkab nchab lo xaꞌ: —Blaꞌ re xaꞌ nguja, ka's xa' tha'bol xa', le' lu wa tej xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nde tediba' xaꞌ nchab lo Jesus: —Xaꞌ Nyebeꞌ, na tyonkeꞌ xis la, per ptaꞌ diꞌs nerla nda tne ney lo re xaꞌ liz na. ");
INSERT INTO ztp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus nchab lo xaꞌ: —Thi men jwan' ngele yogon nde ngwi' xa' a lad xis xa', nalid sin' xa' ten' nyebe' Dios. ");
INSERT INTO ztp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lo senꞌ mne jwanꞌ reꞌ, Jesus mblí tedib son gal nzo siꞌ xaꞌ, jwan' mtelꞌ Jesus chop chopa xaꞌ, sa kwiblo xaꞌ lo Jesus, ya xaꞌ reta yez nde reta tenꞌ nkelo Jesus ya Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nde nchab Jesus lo xa': —Gal' di's nin lo goꞌ, bro toz jwan' ngok, per lud xaꞌ nge sinꞌ lo neꞌy. Jwanꞌ nasa mna'b goꞌ lo xaꞌ nak xwanꞌ neꞌy sa telꞌ xaꞌ masra' men ke sin' lo jwan' ngok. ");
INSERT INTO ztp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Naya wa goꞌ, nde bwiꞌ goꞌ nea, na ngetelꞌ goꞌ xaja mbakxilꞌ yenꞌ xij mbak be. ");
INSERT INTO ztp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nde naꞌwed goꞌ bed, naꞌwed goꞌ tmi, naꞌwed goꞌ tedib ned yayid goꞌ, nde naꞌyatod goꞌ todiꞌsno goꞌ men zyalꞌ goꞌ ned. ");
INSERT INTO ztp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Senꞌ sin go' thi liz men, nerla mni goꞌ dyux lo xaꞌ, gus goꞌ: \"Yalnabe'z chan' Dios xyo'b xis re men liz go'.\" ");
INSERT INTO ztp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nde tez yo ya nzo xaꞌ nabeꞌz nak, yalnabe'z ta ndano go' ya yanꞌ na lo xaꞌ, per tez nanabeꞌzta nak xaꞌ, bere yalnabe'z go' lo go'. ");
INSERT INTO ztp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nde byanꞌ goꞌ yo ya, wa goꞌ nde gu goꞌ jwanꞌ kwek xaꞌ lo goꞌ, tak xaꞌ nke sinꞌ ndablo yax ka xaꞌ. Nde na'yanta goꞌ xa'xa' liz men. ");
INSERT INTO ztp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Senꞌ sin goꞌ thi yez tenꞌ wen nak xaꞌ lo goꞌ, bda goꞌ jwanꞌ kwek xaꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Btodanꞌ goꞌ re men nayiz nzo yez ya nde gus goꞌ lo xaꞌ: \"Le' yalnyebe' chan' Dios ndo sin gaxla lo goꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per tez sin goꞌ thi yez tenꞌ na'tonzad xa' go', broꞌte goꞌ re ro ned ro nde gus goꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"Axta re yothi' yez goꞌ, jwanꞌ mke lad ni náꞌ, zib náꞌy sa go'jka mne, per wi' go' nea, leꞌ yalnyebeꞌ chanꞌ Dios mzin gaxla lo goꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lipa' nin lo goꞌ senꞌ sin wiz nyaꞌb Dios kwent lo men, zyasa mas naro yalti par re xaꞌ yez reꞌ, ke par re xaꞌ yez Sodoma. ");
INSERT INTO ztp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nde nchab Jesus: —¡Nalat toz yate goꞌ men yez Corazin! ¡Nalat toz yate goꞌ men yez Betsaida! Tak tez lo yez Tiro nde lo yez Sidon ngak re yalnaro ta ngok xij go' re', ne' pola ndlaꞌ xaꞌ jwanꞌ narax ndli xaꞌ nde ngok xaꞌ lar nabaꞌd nde ndob xaꞌ lo di lo ki sa loꞌ mzyeꞌ xgab xaꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jwanꞌ na senꞌ sin wiz nyaꞌb Dios kwent lo re men, mas naro toz nak yalti rid re goꞌ, ke re yalti rid re xaꞌ yez Tiro nde re xaꞌ yez Sidon. ");
INSERT INTO ztp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nde goꞌ men yez Capernaum, ¿Cho ndyak goꞌ na axta lo beꞌ xap Dios goꞌ? ¡Nakte, le' goꞌ yatu axta lo bel adi'! ");
INSERT INTO ztp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xaꞌ ntobnza xki's go', xaꞌ ya ntobnza xkiꞌs na nde xaꞌ jwan' ngotal go', xa' ya ngotal na nde ngotal xaꞌ Xaꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Senꞌ mbere re son gal nzo siꞌ xaꞌ jwanꞌ mtelꞌ Jesus, nale toz nzo lazoꞌ xaꞌ nchab xaꞌ: —Xaꞌ Nyebeꞌ, axta re mbi narax nxobyeka ná' lo ndej ná' lea. ");
INSERT INTO ztp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus nchab lo xaꞌ: —Mbwiꞌn maxuꞌ ngob lo beꞌ xaja thi mdi'ba. ");
INSERT INTO ztp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nde na ta yalne lo goꞌ sa tyobni goꞌ xis mbelꞌ nde xis mxub, nde xis re yalne chanꞌ re mbi narax, nde ngen kwan linoy goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per naꞌkonaled lazoꞌ goꞌ kwent nxoꞌbyek re mbi narax goꞌ, cheꞌla blo nale lazoꞌ goꞌ tak nzola le goꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Zyasa hor yaga Mbi Nayon mbli ngo nale lazoꞌ Jesús, nde nchab Jesús: —Tan dyux loa, Xud na, lu jwanꞌ nyebeꞌ lo beꞌ nde lo izyo, tak mkaꞌs la jwanꞌ reꞌ lo re xaꞌ nchak nde lo re xaꞌ nchen, nde mbloꞌ lay lo re xaꞌ nak xaja or bix, tamod mbli lay Xud na, tak ta ncholaꞌs la aka. ");
INSERT INTO ztp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tak Xud na mdaꞌ reta jwan' lon. Ngen cho nzolo cho nak Xin' Xa', benꞌta Xud Xa' mney, nde ngen cho nzolo cho nak Xud Xa', benꞌta Xin' Xa' mney, nde Xin' Xa' teja lo men jwanꞌ nchola's Xin' Xa' tej Xa'y. ");
INSERT INTO ztp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Zyasa xata nchab Jesus lo re xin'te'd xaꞌ: —Nabe'z toz nda re men jwan' ngwi' re jwan' ngwi' go', ");
INSERT INTO ztp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","tak lipa nin lo goꞌ, naꞌr toz profet nde nar toz xaꞌ ngok rey mda'bla's xaꞌ ngwiꞌ xaꞌ reta jwanꞌ ta ndowiꞌ goꞌ nde nangwiꞌd xaꞌy, mda'bla's xaꞌ ngon xaꞌ reta jwanꞌ ta nchon goꞌ, nde naꞌngonta xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Zyasa thi maestr nchak ley xkiꞌs Dios, ngwa lo Jesus, nde mnabdiꞌs xaꞌ, sa libe' xaꞌ Jesus, nchab xaꞌ: —Maestr, ¿kwan ndablo lin sa kenon yalnaban adiꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus mkab lo xaꞌ: —¿Cho kwan ngeni ley chan' Moises? ¿Cho kwan ndlab la? ");
INSERT INTO ztp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Zyasa leꞌ maestr nchak ley xkis Dios mkab: —\"Bkeꞌ lazoꞌa Dios Xa' Nyebeꞌ loa dib nzo lazoꞌa, kon dib yalnaban chanꞌ la, kon dib yalne chanꞌ la, nde kon dib xgab la, nde bkeꞌ lazoa ta men la xajka nkeꞌ lazoꞌa leꞌga lu.\" ");
INSERT INTO ztp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Leꞌ Jesus nchab lo xaꞌ: —Wen mkab la, bli re jwanꞌ reꞌ, kenoa yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per maestr nchak ley xkiꞌs Dios, ndyak xa' galꞌ ndo xa' nde nchab xa' lo Jesus: —¿Cho nak ta men na sa? ");
INSERT INTO ztp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zyasa nchab Jesus: —Thi mbiꞌ mbroꞌ yez Jerusalen ndala nda yez Jerico, nde mbroꞌ pla wanꞌ lo xaꞌ ned, mkib wanꞌ reta chanꞌ xa', axta xab xa' mkib wan', mdin wan' xaꞌ, tawen xa' xajaꞌ men nguja xa' mbla' wan' xa' nde nda re wan'. ");
INSERT INTO ztp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nde leꞌga ned ya ndarid thi nglweyꞌ, senꞌ mbwiꞌ nglweyꞌ nax xaꞌ ya tya, che' mbri'd nglweyꞌ tedib lad ro ned nde nda nglwey'. ");
INSERT INTO ztp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nde ned yaga' mbriꞌdndab tiba xaꞌ nak nak sin' lo yodo', nde senꞌ mbwiꞌ xaꞌ nax xaꞌ ya, taga' benꞌta mbwiꞌ xaꞌ lo xaꞌ che' mbyek xa' thib lad ro ned nde nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per thi xaꞌ yez Samaria ndarid ned yaga' nde senꞌ mbwiꞌ xaꞌ nax mbi' ya, mblat lazoꞌ xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mbike xaꞌ gax lo mbi', nde mtombi xaꞌ lad mbi', mblo xa' aseyt kon bina. Nde mchal xaꞌ lar lad mbi' tenꞌ nawiꞌ ya, zyaga mxap xaꞌ mbi' xis bur xaꞌ nde mbeꞌ xaꞌ xaꞌ thi yo tenꞌ mbed men nde mkenap xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tedib wiz senꞌ mbroꞌ xaꞌ nda xaꞌ, mdaꞌ xaꞌ chop tmi plata lo xaꞌ nak xwanꞌ yo nde nchab xaꞌ: \"Bkenap mbiꞌ reꞌ, nde tez masra' mbro'to jwan' mbli goꞌ, na yixa lo goꞌ senꞌ beren.\" ");
INSERT INTO ztp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zyasa nchab Jesus lo maestr nchak ley: —¿Xa nya re yon xaꞌ reꞌ ngok ta men xaꞌ, tá mbro' wan' lon' ya? ");
INSERT INTO ztp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Zyasa maestr nchak ley nchab: —Xaꞌ jwanꞌ mblat lazonꞌ mbi' ya. Jesus nchab lo xaꞌ: —Bya nde tagaꞌ bli. ");
INSERT INTO ztp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Laja ndo Jesus ned, mzin Jesus thi yez lud, tya nzo thi ngol ndole Mart, ngol ya mdaꞌ liz naꞌ mbled Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nde Mart ngeno thi bel naꞌ ndole Mari, nde Mari mdob lo Jesus ndoyon reta jwanꞌ ndej Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per Mart, mas mbix rsin' naꞌ, zyasa nchab Mart lo Jesus: —Xaꞌ Nyebeꞌ, ¿Cho nandlit la xgab ta mbla' bel na na thib na lo sinꞌ? Gus lo xa' sa ta' ya' xa' lon. ");
INSERT INTO ztp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Per Jesus mkab: —Sib la Mart, jwanꞌ toz ndlia xgab nde mbix la rsinꞌ la, ");
INSERT INTO ztp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","per nzo thita jwanꞌ mas nakinꞌ nde Mari mblí jwanꞌ na, nde ngen cho kiba lo xa'. ");
INSERT INTO ztp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Thib wiz Jesus ndo thi ten' ndotodiꞌsno Xa' Dios, nde senꞌ mne mdodiꞌsno Xa' Dios, thi xin'te'd Xa' nchab lo Xa': —Xaꞌ Nyebeꞌ, bloꞌ lo náꞌ xamod todiꞌsno náꞌ Dios, ta xa mbloꞌ Juan lo re xin'te'd Juan. ");
INSERT INTO ztp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus nchab lo xaꞌ: —Senꞌ todiꞌsno goꞌ Dios, gab goꞌ: Xud náꞌ Dios, jwanꞌ ndob lo beꞌ, nayon nak lea. Yeꞌd yalnyebeꞌ chanꞌ la, Nde bli xa ncholaꞌs la, ta xa ndlia lo beꞌ, tagaꞌ bli lo izyo reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jwanꞌ nak la' náꞌ re wiz, bta'y na wiz. ");
INSERT INTO ztp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pton' reta xken náꞌ, tak no náꞌ ntori'd ná' yek náꞌ re jwanꞌ narax ndli men lo náꞌ. Nde nalayat la náꞌ li náꞌ re jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nde noga' nchab Jesus: —Tez nzo thi goꞌ ngeno thi amig naꞌ, nde rol yalꞌ nda go' liz xaꞌ, nde gab go' lo xaꞌ: \"Pkwan' son pan kan, ");
INSERT INTO ztp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tak thi amig na jwan' nde tij mzin liz na, nde ngen kwan ngenon tan wa xaꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nde amig ya lenꞌ lizta xaꞌ kab xaꞌ: \"Naꞌtyodoꞌd la lon, nowꞌla ro liz na nde re xinꞌ ná' naxla, naꞌgakta yochen tan pan loa.\" ");
INSERT INTO ztp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na ni lo go', te'nyega nak xa' amig xa', pa yache xa', sa taꞌ xaꞌ pan lo amig xaꞌ, per lo tibla' ndobez amig lo xaꞌ, tache xaꞌ ta' xa' reta jwanꞌ nakinꞌ amig xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jwanꞌ nasa nin lo goꞌ: Mna'b go'y de kaya' go'y, pkwan' goꞌy nde tasal goꞌy, brez goꞌ xis yala, nde txalꞌla lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tak xaꞌ jwan' nyaꞌba, nkayaꞌ xaꞌy, nde xaꞌ nkwanꞌ na nchasal xaꞌy, nde xaꞌ mbez xis yala, nxyalꞌla lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Cho thi go' ba jwan' nak xud mdyen', tez nyaꞌb or thi pan lo go', cho thi ke taꞌ goꞌ lo or? ¿o tez thi xin' go' nyaꞌb thi mbel lo goꞌ, cho thi mbelꞌ ta go' lo or? ");
INSERT INTO ztp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O tez nyaꞌb or thi ngo lo goꞌ, cho thi mxub ta' go' lo or? ");
INSERT INTO ztp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mbay goꞌ, teꞌnye narax nak goꞌ, nchak ndaꞌ goꞌ jwanꞌ wen lo xinꞌ goꞌ, plopa mas Xud naꞌ ndob lo beꞌ, taꞌ Xaꞌ Mbi Nayon chanꞌ Xaꞌ lo men jwanꞌ nyaꞌba lo Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus ngegoꞌte thi mbi narax jwanꞌ ndli sa na'akta todi's thi xaꞌ biꞌ, nde senꞌ mbroꞌte mbi narax mbiꞌ ya, mdobte mdodi's xaꞌ, nde reta men leꞌka nzoyen xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per pla xaꞌ nchab: —Mbi' re'ya ngo'te re mbi narax por yalne chan' Beelzebu, xa' jwan' nyebe' lo reta mbi narax. ");
INSERT INTO ztp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nde thi pla xaꞌ nchola's li beꞌ xaꞌ Jesus, nyaꞌb xaꞌ li Jesus thi yalnaro jwanꞌ ryoꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per Jesus mnela cho xgab ndli xaꞌ, nde nchab Jesus lo xaꞌ: —Reta xaꞌ nyebeꞌ jwanꞌ nchak rol nde ngyo xaꞌ leꞌga ta xaꞌ, tlayo xa', nde men nchak rol leꞌga lenꞌ liz men nde ngyo men, tlayo men. ");
INSERT INTO ztp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Taga re mbi narax chan' maxu' tez yo xa' le'ga ta xa'. ¿Xamod yobe yalnyebe' chanꞌ maxu' sa? Jwanꞌ reꞌ nin lo goꞌ, tak mbez goꞌ ke na ngote mbi narax por yalne chanꞌ Beelzebu. ");
INSERT INTO ztp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Per tez liga kon yalne chan' Beelzebu ngoten re mbi narax, ¿cho ndaꞌ yalne lo re xin'te'd goꞌ, par kote xaꞌ mbi narax? Jwanꞌ nasa leꞌga xin'te'd goꞌ mne narax ndo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per tez na ngote mbi narax por yalne chanꞌ Dios, jwanꞌ na ndloꞌ, le' yalnyebeꞌ chanꞌ Dios mzinla lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Senꞌ thi xaꞌ ne lazonꞌ thibla' ndenza' xa' yi'b nke' men byo nde ngenap xaꞌ re chanꞌ xa' jwan' nzo tsa' liz xaꞌ, zyasa re jwanꞌ ngeno xaꞌ ngenkwan tyaka. ");
INSERT INTO ztp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per tez nde tedib xaꞌ mas ne lo xa' ya, li xaꞌ gan lo xa', kib xaꞌ re yib xa' jwan' tá nda' yalne lo xa' ya, nde kiꞌd xaꞌ jwan' mkib xa'. ");
INSERT INTO ztp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Xaꞌ jwanꞌ na'ndoda kon na, xaꞌ ya narax nye xaꞌ na, nde xaꞌ jwanꞌ nanthopta men par na, xaꞌ ya cheꞌ nchaꞌs xaꞌ men na. ");
INSERT INTO ztp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Senꞌ ndryoꞌte mbi narax nzo lazo' thi men, ndaketey re tenꞌ nabis, nda kwanꞌ na tenꞌ ryoꞌxkwen na, per senꞌ na'yasaltey tenꞌ ryoxkwen na, zyasa ndliy xgab: \"Beren liz na tenꞌ mbroꞌn.\" ");
INSERT INTO ztp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nde senꞌ mzina, nzyala men ya, xaja thi yo mblyoba nde nawe nya. ");
INSERT INTO ztp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Zyasa nday nde nthopa thi gaz mbi mas natin ke mbi narax ya, nde ndlya rey lazo' men ya, nde mas narax ngote men ya ke jwan' mxak ner xa'. ");
INSERT INTO ztp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Laja ndotej Jesus re jwanꞌ reꞌ, thi ngol nzo xij re men ya ne mbrez xa', nchab xa': —¡Nabe'z toz nda ngol jwanꞌ mxan la nde mdaꞌ nis nguꞌa! ");
INSERT INTO ztp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus nchab: —¡Mas nabe'z toz nda re xaꞌ nchon xkiꞌs Dios nde nxobyek xaꞌy! ");
INSERT INTO ztp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Senꞌ masra' ndo ndop men lo Jesus, zyasa mdobte nchab Jesus lo xaꞌ: —Reta men nzo na tyemp reꞌ, men xkap xaꞌ nde nyaꞌb xaꞌ thi yalnaro wiꞌ xaꞌ, per ngentra' cho yalnaro wiꞌ xaꞌ benꞌta yalnaro chan' Jonas wiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Xa yalnaro jwan' ngok lo Jonas, mbli sa re men yez Ninive mbli lazo' xa' ke Dios mtel' Jonas, thi yalnaro yaga' lo'n sa lo' ke Dios mtel' na. ");
INSERT INTO ztp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Per wiz senꞌ nyaꞌb Dios kwent lo re men nzo na tyemp reꞌ, zyasa ryo'to ngol ngok rey lo yez Saba, nde ngol ya tej reta jwanꞌ narax mbli re men nzo naya, tak tij toz mbroꞌ ngol sa gon ngol yalnchak chan' rey Salomon, nde naya, lo go' ndo thi Xa' mas ntak lo rey Salomon. ");
INSERT INTO ztp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nde taga' ryo'to re men yez Ninibe, wiz senꞌ nyaꞌb Dios kwent lo re men nzi naya, nde re xaꞌ ya tej reta jwanꞌ narax mbli re men nzi naya, tak re men yez Ninibe mxobyek xaꞌ Jonas nde mblaꞌ xaꞌ re jwanꞌ narax nak xaꞌ nde mbli lazoꞌ xaꞌ Dios, nde naya, lo go' ndo thi Xa' mas ntak lo Jonas. ");
INSERT INTO ztp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ngen cho ntob ki ti kandil nde nka'slo xa'y, o ngo xa'y xanꞌ xibe', cheꞌla gap ntob xaꞌy, sa toxniy lo re men nchote lenꞌ yo. ");
INSERT INTO ztp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngudlo men nak xaja thi xni lo diben men, tez wen ngudloa, nawe nchoxni loa, per tez nayiz ngudloa, diben la ndo yalꞌkow. ");
INSERT INTO ztp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndawiꞌ toz la sa xnita ntoxni loa ba naꞌaktey yalꞌkow. ");
INSERT INTO ztp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jwan' nasa tez diben la nawe ndo lo xniy, ngenta nek lud yal'kowa, reta jwanꞌ nawe wiꞌa, xaja ti kandil nawe ntoxni ba. ");
INSERT INTO ztp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Senꞌ mne mdodiꞌs Jesus, thi xaꞌ fariseo mna'b xa' lo Jesus sa wa Jesus liz xaꞌ, zyasa ngwa Jesus liz xaꞌ nde ngote Jesus mdob Jesus ro mes. ");
INSERT INTO ztp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Zyasa xaꞌ fariseo nzoyen xaꞌ mbwiꞌ xaꞌ tak naꞌnad Jesus xa nak mod ngeno xaꞌ sen' ncha xa'. ");
INSERT INTO ztp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Per Jesus nchab lo xaꞌ: —Re goꞌ men fariseo ben'ta xis bas nde xis yen ntach goꞌ, per lenꞌ lazo' go' se nzo re xgab xkap, nde yalwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ne yek go'! ¿Cho naꞌnyed goꞌ Xaꞌ jwanꞌ mdoxkwaꞌ lad xis, Xaꞌ yaga' mdoxkwaꞌ lad lenꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ptaꞌ goꞌ gon lo xaꞌ prob lo re jwanꞌ ngeno goꞌ, tamod sa yanꞌ nambi goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Per nalat tyak goꞌ xaꞌ fariseo! tak ndaꞌ goꞌ dyezmo chanꞌ pthyon, chanꞌ rud, nde chan' re lo yeꞌd, per nandlid goꞌ re jwanꞌ galꞌ nde nankeꞌd lazoꞌ go' xa ndli Dios. Jwanꞌ re ndablo li goꞌ nde nalaꞌd goꞌ li goꞌ temasa. ");
INSERT INTO ztp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Nalat nya goꞌ xaꞌ fariseo! tak ndyen goꞌ tyob goꞌ lo re yasil nzi axta lo, lenꞌ yo tenꞌ ndyop xaꞌ Israel nde ncholaꞌs goꞌ, ni men dyux lo goꞌ lo xbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Nalat nya goꞌ xaꞌ fariseo nde maestr nchak ley, makwinꞌ, tak nak goꞌ xaja baꞌ nandlod nax nde ana'nye men ndyop ni men xis neꞌy! ");
INSERT INTO ztp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Zya mkab thi maestr nchak ley, nchab: —Maestr, no náꞌ nchaꞌd re diꞌs ta mbez la. ");
INSERT INTO ztp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Per Jesus nchab lo xaꞌ: —¡Taga' nalat nya goꞌ, maestr nchak ley!, tak cho kwan liy sa nyebe' go' li men thi jwan' na'lid men gan li men, nde go' nek lud na'ndlastod go' xa'. ");
INSERT INTO ztp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Nalat nya goꞌ! tak ndoxkwaꞌ goꞌ xna xis banꞌ profet, jwanꞌ mbij leꞌga leꞌ re xaꞌ gox lo bin tenꞌ nde goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jwanꞌ reꞌ ndloꞌ ke ndyen goꞌ re jwanꞌ mbli re xaꞌ gox lo bin tenꞌ nde goꞌ, tak xa' mbij re profet nde goꞌ mtoxkwaꞌ banꞌ profet. ");
INSERT INTO ztp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jwanꞌ nasa yalchak chanꞌ Dios nchab: \"Telꞌ na profet nde apost, pla xaꞌ kuj goꞌ nde pla xaꞌ chu'bla goꞌ.\" ");
INSERT INTO ztp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Per Dios nyaꞌb kwent lo re xaꞌ nzi naya, lo ta mbij xa' re profet axta senꞌ mdoxkwa izyo, ");
INSERT INTO ztp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","xata mbij xa' Abel axta Zacarias, xa' jwan' mbij goꞌ xlaj tenꞌ ntolꞌ xaꞌ jwanꞌ yon nde tenꞌ nayon lenꞌ yodoꞌ. Jwanꞌ na nin lo goꞌ, Dios nyaꞌb kwent chanꞌ ren re xaꞌ ya lo men nzi naya. ");
INSERT INTO ztp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Nalat nya goꞌ, maestr nchak ley!, tak nka goꞌ di's yolo men Dios, per le'ga go' mtow' go' ned lo go', nde taga' mtow' go' ned lo re men nchola's yolo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Senꞌ mne nchab Jesus re jwanꞌ reꞌ, zyasa re maestr nchak ley nde re fariseo jwanꞌ toz mxi lazoꞌ xaꞌ, nde mdobte masraꞌ mnabdiꞌs xaꞌ lo Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ncholaꞌs xaꞌ ni Jesus pla diꞌs jwanꞌ nandabloda ni Jesus, sa zyal xa' yalke ke' xa' yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Laja mdyop por mil men lo Jesus, lo taja bro toz men anta ngaꞌs ta men. Jesus mdobte mni, nerla lo re xin'te'd Jesus, nchab Jesus: —Pkenap lazoꞌ goꞌ lo re jwanꞌ ndloꞌ re xaꞌ fariseo, tak nandlid xa' jwan' ndlo' xa'. ");
INSERT INTO ztp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tak na'ngenta jwanꞌ nzo nagaꞌs, naꞌloda, nde ngenta thi jwanꞌ nkaꞌs men, naꞌryoꞌxo'bta. ");
INSERT INTO ztp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jwanꞌ nasa reta jwan' nagaꞌsta ndyodiꞌs goꞌ, le'y tonka men, nde reta jwanꞌ mdodiꞌs rslyanꞌ goꞌ lo nzo now'yo go', axta gap yek yo kwez men koxo'b mena. ");
INSERT INTO ztp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Le na ni lo goꞌ, amig na, na'zyebta goꞌ re xaꞌ nguj men, tak senꞌ mne mbij xaꞌ men, ngentraꞌ kwan mas ak li xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Per naya nin lo goꞌ cho ndablo seb lazoꞌ goꞌ: Pseb lazoꞌ goꞌ Xaꞌ jwanꞌ tak kib yalnaban, nde ngeno Xaꞌ yalne ko xaꞌ men lo bel. Xaꞌ ya pseb lazoꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Cho nakta gay' mbyin ntak chop tmi bix? Per Dios nanchajta yek na' nek thib mbyina. ");
INSERT INTO ztp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nde tagaꞌ go', axta re yis yek go' nagaba lo Dios. Jwanꞌ nasa nazyebta goꞌ, tak mas ntak goꞌ ke re mbyina. ");
INSERT INTO ztp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nipa na lo goꞌ, reta men jwanꞌ gab, nzolo xaꞌ na lo re men, taga' na Xin' Mbi' gab na lo re anj chanꞌ Dios, ke nzolon xa'. ");
INSERT INTO ztp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per men jwanꞌ gab na nanzolod xaꞌ na lo re men, noga na gab nanzolod na xaꞌ lo re anj chan' Dios. ");
INSERT INTO ztp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nde choja xaꞌ jwanꞌ ni xis Xin' Mbi', tonꞌ Dios xken xaꞌ, per xaꞌ nixin xis Mbi Nayon chanꞌ Dios, naꞌtonꞌta Dios xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nde senꞌ we xaꞌ goꞌ lo re men lenꞌ yo tenꞌ ndyop xaꞌ Israel, o lo re xaꞌ nyebeꞌ lo re yez nde lo re xaꞌ ngeno yalnyebeꞌ ro, naꞌlid goꞌ xgab xamod gab goꞌ lo xaꞌ o xamod kab goꞌ lo xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tak senꞌ sin hor ni goꞌ lo xaꞌ, zyasa Mbi Nayon chanꞌ Dios lo' lo goꞌ xamod kab goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zyasa thi xaꞌ biꞌ nzo xij men toza nchab lo Jesus: —Maestr, gus lo wes na sa li rol xaꞌ jwanꞌ ngok chanꞌ xud ná' nde taꞌ xaꞌ jwan' ndinꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus mkab lo xaꞌ, nchab: —Mbiꞌ, ¿Cho mtob na sa ak na juez o xaꞌ lirol jwanꞌ mtan' xud goꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nogaꞌ nchab Jesus: —Ndawiꞌ toz goꞌ nde bkenap lazoꞌ goꞌ lo re yaltabla's, tak yalnaban chan' men nandede lo re jwanꞌ toz ngeno men. ");
INSERT INTO ztp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Zyasa mdaꞌ Jesus thi kwent, nchab Jesus: —Ngo thi xaꞌ rik, lo izyon xa' ngok bro toz tir jwan'. ");
INSERT INTO ztp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nde mbli xaꞌ xgab: \"¿Kwan lin naya? Nangenot na tenꞌ gosaꞌn reta jwanꞌ ngok.\" ");
INSERT INTO ztp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Zyasa mbli xaꞌ xgab: \"Mnea na kwan lin. Sil na re ló ngenon, nde toxkwan thi pla ló mas naro, sa tya gosaꞌn reta jwanꞌ ngok nde reta jwanꞌ ngenon. ");
INSERT INTO ztp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Zyasa gab na lo lazoꞌn: Bro toz jwanꞌ ngenoa tala waa naꞌr linꞌ, naya broꞌxkwen, bda nde guꞌ nit, nde blo nale lazoꞌa.\" ");
INSERT INTO ztp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per Dios nchab lo xaꞌ: \"Mbiꞌ neyek, na yalꞌ reꞌ gaj la, nde reta jwanꞌ mblosaꞌa, ¿cho chanꞌ aka?\" ");
INSERT INTO ztp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tamod nchate xaꞌ ta ngosaꞌ bro jwanꞌ par le'ga xa' lo izyo reꞌ, per lo Dios ngen kwan ngeno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Xisa nchab Jesus lo re xin'te'd Jesus: —Naya nin lo goꞌ, naꞌlid goꞌ xgab por re jwanꞌ wa goꞌ, neka li goꞌ xgab ma lar gok goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tak yalnaban chanꞌ goꞌ mas ntak ke jwanꞌ ncha go', nde goꞌ mas ntak ke lar nchok go'. ");
INSERT INTO ztp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jwin bli goꞌ xgab xa re mbyaka, nangod maꞌ bin, neka nthop maꞌ kosech, neka ngeno maꞌ tenꞌ nchosaꞌ kosech ma', per Dios ndaꞌ jwanꞌ ncha maꞌ. ¡Plopa mas ntak goꞌ ke re mbina! ");
INSERT INTO ztp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Nde cho ti goꞌ ba li gan xyen tud, lo ndli toz goꞌ xgab? ");
INSERT INTO ztp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tez akta li go' nekla thi jwan' lud, ¿Kwan ndliy sa ndli goꞌ xgab temas re jwanꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Jwin bwiꞌ goꞌ xa nxyen re yeꞌ ba, nankedey sinꞌ, nantoxkwadey xab neꞌy, nde na nin lo goꞌ neka rey Salomon nangokxabta xa' xaja nya re yeꞌ ba. ");
INSERT INTO ztp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nde tez Dios ta ngok xab re ye' nzo wan, jwanꞌ naya nzoy yeꞌ mbiza, nde yola. ¡Chole'ta go' plopa jwan' ta' Dios lo go', per goꞌ lud ndli lazo' go' Dios! ");
INSERT INTO ztp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jwanꞌ nasa nin lo goꞌ, nalid goꞌ xgab jwanꞌ wa goꞌ nde jwanꞌ gok goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tak reta jwanꞌ reꞌ nak xgab lo men lo izyo reꞌya, per Xud goꞌ ndob lo beꞌ mnela Xaꞌ re jwanꞌ nakinꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Per nerla pkwanꞌ goꞌ yalnyebeꞌ chanꞌ Dios nde xamod gal' ak goꞌ lo Dios, zyasa Dios taꞌ reta jwanꞌ na lo goꞌ ");
INSERT INTO ztp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Naꞌzyebta goꞌ, mbakxilꞌ bix na, per Xud goꞌ ndob lo beꞌ, mblila Xaꞌ xgab taꞌ Xaꞌ yalnyebeꞌ chanꞌ Xaꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jwanꞌ nasa ptho goꞌ re jwanꞌ ngeno goꞌ, nde pta' goꞌy lo re xaꞌ nakinꞌ na, tamod ndogosaꞌ goꞌ jwanꞌ ntak toz lenꞌ thi bed jwanꞌ nandluxta, lo beꞌ tenꞌ nandlyad wanꞌ nde nanchad mbexa. ");
INSERT INTO ztp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tak tenꞌ ngeno goꞌ bro jwanꞌ ntak, tya ndob lazo' goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ptosa' go', gok xab go' nde thibla tyob ki kandil goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nde gok goꞌ xaja thi mos, jwanꞌ ngembed bere xwan' naꞌ, jwan' ngwa lo yalselyaꞌ, ngembedla xaꞌ xalꞌ xaꞌ ro yo senꞌ kwes xwan' xa' xis yala. ");
INSERT INTO ztp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nabeꞌz toz nda re mos ya, senꞌ sin xwan' xaꞌ, nzina xaꞌ. Nipa na lo goꞌ, leꞌga leꞌ xwan' mos nyebeꞌ tyob mos ro mes nde ko xaꞌ jwanꞌ wa mos. ");
INSERT INTO ztp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Re mos ya nabeꞌz nda xaꞌ, tez tenye rol yalꞌ o nda tuxni nzina xaꞌ senꞌ sin xwan' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nde ndablo nye goꞌ jwanꞌ reꞌ, tez thi xaꞌ nak xwanꞌ yo, mne xaꞌ cho hor lya xaꞌ wanꞌ liz xaꞌ, pa laꞌ xaꞌ liz xaꞌ lya wanꞌ, sa we wanꞌ chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Taga' goꞌ, ptosa' go', tak Xinꞌ Mbiꞌ yeꞌd senꞌ nandlid goꞌ xgab sin Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Zyasa mnabdiꞌs Pedr lo Jesus nchab: —Xaꞌ nyebeꞌ, ¿cho ben'ta lo ná' ndej la kwent reꞌ o lo reta mena? ");
INSERT INTO ztp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zyasa nchab Jesus: —¿Cho nak mos tiblaꞌ ndo nde nzo xgab yek naꞌ? Lo mos ya tanꞌno xaꞌ nyebeꞌ re men liz xaꞌ, sa taꞌ mos jwanꞌ ndin' re men liz xa' wa xa' sen' nchal hor wa xa'. ");
INSERT INTO ztp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nabe'z toz nda mos ya, sen' lo bere xa' nyebe' lo mos, yosal xa' mos ngeli mos jwan' mtan'no xa' mos. ");
INSERT INTO ztp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nipa na lo goꞌ, leꞌ xwan' mos ya tob xaꞌ mos kenap mos reta jwanꞌ ngeno xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per tez mos ya, ndli xgab sowꞌra sin xwan' na nde tyobte mos kin mos, mos bi nde mos got nde tyobte mos wa mos, gu mos nit nde tyus mos. ");
INSERT INTO ztp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nde wiz senꞌ nandlid mos xgab zin xwan' mos, nde hor jwanꞌ nangembeta mos zin xaꞌ, zyasa jwan' toz ta'pen xa' mos nde ko xaꞌ mos tenꞌ nzo re xaꞌ nandlid lazon' Dios. ");
INSERT INTO ztp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Per mos jwanꞌ mnela jwanꞌ ncholaꞌs xwan' mos, nde nandosa'd mos neka nxobyek mos xwan' mos, mos ya, leꞌka kin toz xaꞌ mos. ");
INSERT INTO ztp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per mos jwanꞌ namneda jwanꞌ ncholaꞌs xwan' mos, nde mbli mos jwanꞌ narax, mos ya mas lud kin xaꞌ. Nde mos jwanꞌ mdaꞌ xwan' mos bro yalnyebeꞌ lo mos, mos ya, mas bro kwent nyaꞌb xwan' mos lo mos, nde mos jwanꞌ mtanꞌ xaꞌ bro jwanꞌ lonꞌ, mas bro jwanꞌ nyaꞌb xaꞌ lo mos ya. ");
INSERT INTO ztp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zyasa nchab Jesus: —Na ndal, sa tob na ki izyo, ¡Nde axta ndya'bla's na ya ndoyola izyo! ");
INSERT INTO ztp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Per nerla rid na thi yalti toz, ¡Nde jwanꞌ toz ncho nabil lazoꞌn axta kebeꞌ ri'd na yalti ya! ");
INSERT INTO ztp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Cho ndyak goꞌ yalnabeꞌz ndalnon lo izyo reꞌ? Nandalnot na yalnabeꞌz, cheꞌla leꞌn ndal sa ak rol men. ");
INSERT INTO ztp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tak xata naya tyobte ak rol men, thi liz men nzo gayꞌ xa', son xaꞌ yo kon chop xaꞌ nde chop xaꞌ yo kon son xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Xud mdyenꞌ yo kon mdyenꞌ nde mdyenꞌ yo kon Xud mdyenꞌ, xnaꞌ mdyenꞌ yo kon mdyen got nde mdyenꞌ got yo kon xnaꞌ mdyenꞌ, xnaꞌyiꞌ ngol yo kon ngol, nde ngol yo kon xnaꞌyiꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nde nchab Jesus lo reta men: —Senꞌ ngwiꞌ goꞌ ndeke xkow lad ned ncha'd wiz, mbez goꞌ: \"yi lya\", nde ndlyaga yi. ");
INSERT INTO ztp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nde senꞌ nzyoꞌb mbi lad la, mbez goꞌ: \"ak nasoꞌ \" nde nchak nasoꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Makwin'! Nchak ntakbeꞌ goꞌ jwanꞌ lo beꞌ nde jwan' lo izyo. ¿Nde nanchakta ntakbeꞌ goꞌ tyemp nzo goꞌ naya? ");
INSERT INTO ztp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Kwandliy xanaꞌ leꞌga goꞌ koxyo goꞌ kwan nak jwanꞌ galꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tez xaꞌ jwan' ndebeyonoa mbeꞌ xaꞌ la yolow, laja ndo rop goꞌ ned, pken bsalꞌdiꞌs rop goꞌ xaꞌ, sa naꞌtayaꞌd xaꞌ la lo juez. Nde tez naꞌtad lia, leꞌ juez taꞌyaꞌa lo xa' nak sin' nde xa' nak sin' na keꞌ xaꞌ la lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nde nipa na loa, naꞌryoꞌted la tya axta kebeꞌ kix la re nak jwanꞌ ndaꞌb la. ");
INSERT INTO ztp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Len' wiz ya ngwa pla men lo Jesus, ngwatej xa' xamod mnabe' Pilat, mbij xa' pla xaꞌ lo xyon Galilea nde mkos xa' ren men ya kon ren maꞌ jwanꞌ mbij xaꞌ mda' xa' yon lo Dios. ");
INSERT INTO ztp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus mkab lo xaꞌ nchab: —¿Cho ndli goꞌ xgab jwanꞌ reꞌ ngote xaꞌ Galilea, tak mas nzoꞌb xken xaꞌ lo temas men las xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na ni lo goꞌ, naktey, noga' goꞌ tez naꞌlad goꞌ jwanꞌ narax ndli go' nde naꞌzed goꞌ xgab go', no go' taga' lux go'. ");
INSERT INTO ztp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O ndyak go' re sinꞌ son men jwanꞌ nguj, senꞌ ngob yo gap toz tir ndab ta ndob yez Siloe, mas nchap xaꞌ yalke ke re xaꞌ nzo yez Jerusalen? ");
INSERT INTO ztp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na ni lo goꞌ, naktey, noga' go' tez naꞌlad goꞌ jwanꞌ narax ndli goꞌ nde naꞌzed go' xgab goꞌ, no go' taga' lux go'. ");
INSERT INTO ztp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Zyasa Jesus mdej thi kwent nagan lo re men, nchab Xa': —Thi mbi' ngeno bin thi ya hig ten' nzobin lus ub xa', ngwa wiꞌ xaꞌ lo ya nyenꞌ cho ndo nguda, nde naꞌngazalta xa' nek thib ngud lo ne'y. ");
INSERT INTO ztp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Zyasa nchab xaꞌ lo xaꞌ ta ngenap lus uba: ꞌꞌWi' nea, ndala son linꞌ, tibla' nchakwan na ngud lo ya hig, per nek thib gob naꞌngasalta na ngud lo ne'y. Maska pchoꞌy; tak benꞌta nale ndoba.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Per xaꞌ ngenap izyo ya nchab: ꞌꞌXaꞌ nyebeꞌ, blaꞌ go'y linꞌ reꞌta, sa toleꞌn yo xanꞌ neꞌy nde gon beꞌba. ");
INSERT INTO ztp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Taꞌda taꞌy ngud, per tez naꞌtaꞌdey ngud, zyasa choꞌ lay.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lenꞌ wiz ndryoꞌxkwen men, Jesus ngelo' xkiꞌs Dios lenꞌ yo tenꞌ ndyop xaꞌ Israel, ");
INSERT INTO ztp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","nde xij re mena nzo thi ngol, jwanꞌ ndala sinꞌ son linꞌ nayiz. Thi mbi narax mtoleng xis ngol, nde nek lud naꞌgakta gaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Senꞌ mbwiꞌ Jesus ngol, mbrez Jesus ngol, nde nchab Jesus lo ngol: —Ngol, se mbro'ngi'b la lo yis ndyak la. ");
INSERT INTO ztp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Zyasa mxoꞌb Jesus yaꞌ Jesus yek ngol, nde hor yaga mbwaꞌ xis ngol nde mbli naro ngol Dios. ");
INSERT INTO ztp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per xaꞌ nyebeꞌ lenꞌ yo tenꞌ ndyop xaꞌ Israel, ngok nayiꞌ xaꞌ, tak mtodanꞌ Jesus xaꞌ ya lenꞌ wiz ndryoꞌxkwen men, nde nchab xaꞌ lo reta men nzi tya: —Xop wiz nzo jwan' ndablo ke men sinꞌ, len' re wiz ya deꞌ go' sa todanꞌ Xaꞌ goꞌ, nde naꞌyedta goꞌ lenꞌ wiz ndryoꞌxkwen men. ");
INSERT INTO ztp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Zyasa mkab Jesus lo xaꞌ: —Makwinꞌ, ¿Cho nek thib goꞌ nanxakta ngon naꞌ o bur naꞌ, sa yano goꞌ maꞌ gu maꞌ nit lenꞌ wiz ndryoꞌxkwen men? ");
INSERT INTO ztp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Per ngol ta nde lo bin Abraham re', ndala sinꞌ son linꞌ ntoti mbi narax ngol, ¿Cho naꞌgakta go'ngi'b na ngol lo yiz lenꞌ wiz ndryoꞌ xkwen men? ");
INSERT INTO ztp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Senꞌ nchab Jesus jwanꞌ reꞌ, re xaꞌ ta nayiꞌ ya ndyolaꞌs xaꞌ, per reta men nale toz ngo lazoꞌ xaꞌ por re yalnaro jwanꞌ ndli Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zyasa nchab Jesus: — ¿Kon cho thi jwan' lal nak ten' nyebe' Dios? ¿Kon cho kwan toyal kalal nay? ");
INSERT INTO ztp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Leꞌy nak xaja thi mbis mostas, jwanꞌ mblo bin thi xaꞌ lo izyon xaꞌ nde naro mxyena, ngoka thi ya nde re mbin ndoxkwaꞌ ma' lyeꞌd maꞌ lo re xod ya ya. ");
INSERT INTO ztp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nde bere nchab Jesus: — ¿Kon cho kwan tedib jwan' kalal na ten' nyebe' Dios? ");
INSERT INTO ztp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ta naka, xa nak levadur jwanꞌ nkos thi ngol kon son xi beꞌ di harin axta kebes dib koꞌb. ");
INSERT INTO ztp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nde senꞌ ndo Jesus ned nda Xaꞌ yez Jerusalen, taja nda loꞌ Jesus xkiꞌs Dios lo re men, re yez nde re ranch tenꞌ ndarid Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Zyasa thi xa' mnabdiꞌs lo Jesus: —Xaꞌ Nyebeꞌ, ¿cho nagabta men jwan' lyaꞌ? Jesus nchab: ");
INSERT INTO ztp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Pchal goꞌ yote goꞌ ro yala naya, tak nipa na lo goꞌ, bro toz men chal yotey per naꞌlid xaꞌ gan. ");
INSERT INTO ztp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nde senꞌ xaꞌ nak xwanꞌ yo, tyoli xa' towꞌ xaꞌ ro yo nde re goꞌ jwanꞌ mbyanꞌ le, kwes goꞌ nde gab goꞌ: ꞌꞌ Xwan' ná', bxalꞌ goꞌ ro yo lo ná'.ꞌꞌ Per xaꞌ kab lo goꞌ: ꞌꞌNa'nyet na plo mbro' go'.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Zyasa tyobte gab goꞌ: \"Thita mda na' nde thita nguꞌ na' nde re lo xbi' yez na' mtote'd la men.\" ");
INSERT INTO ztp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per Xaꞌ kab lo goꞌ: ꞌꞌNia na lo go', na'nyet na plo mbro' go'. Baxa wa goꞌ men ndli jwan' narax nak go'.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tya gon goꞌ nde te's kele goꞌ, senꞌ wiꞌ goꞌ Abraham, Isaac, Jakob nde reta xaꞌ mbrid xkiꞌs Dios pola, nzi xaꞌ tenꞌ nyebeꞌ Dios, nde goꞌ mbyanꞌ le. ");
INSERT INTO ztp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nde yeꞌd re men ryoꞌ dib nax izyo, nde tyob xaꞌ ro mes tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Zyasa re xa' ta ndo axta xiska, xa' ya tyo ner nde le' xa' ndo ner, xa' ya yan' axta xis. ");
INSERT INTO ztp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nde le'ga wiz ya mzin pla xaꞌ fariseo, nchab xa' lo Jesus: —Broꞌte ncheꞌya, tak Herodes ncholaꞌs kuj la. ");
INSERT INTO ztp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Zyasa Jesus mkab lo xaꞌ, nchab: —Bya goꞌ nde gus goꞌ lo mbe'd taya: ꞌꞌWiꞌ, naya nde yeꞌ go'ten mbi narax nzo re men nde ntodanꞌ na re men yis, nde wiz tolon rzin na.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per ndabloga ndan xned na naya, yeꞌ nde wiz, tak naꞌndabloda gaj thi profet ten' nanakta yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Men Jerusalen, men Jerusalen, goꞌ jwanꞌ nchuj re profet nde ngadke goꞌ re xaꞌ ntelꞌ Dios jwan' ncha's xkiꞌs Dios! ¡Naꞌr toz gob ncholas na nthop na re xinꞌ goꞌ, xaja ngidtan jwanꞌ nthop re chuy bix len' xil' na'. Per naꞌndoyalta goꞌ! ");
INSERT INTO ztp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bwiꞌ goꞌ nea, le' liz goꞌ yanꞌ nagan, nde nipa na lo goꞌ nagwiꞌtra goꞌ na axta kebeꞌ sin wiz senꞌ gab goꞌ: ꞌꞌNayon nak xaꞌ nde lo le Xaꞌ Nyebeꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Thib wiz jwan' ndryoꞌxkwen men, Jesus ngwa tha liz thi xaꞌ nyebeꞌ lo re xaꞌ fariseo, nde tipla xaꞌ fariseo nzi laꞌs xa' nyenꞌ kwan li Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nde tya ndo thi xaꞌ bi' ndyak yis ki. ");
INSERT INTO ztp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zyasa mnabdiꞌs Jesus lo re maestr nchak ley nde lo re xaꞌ fariseo: —¿Cho gal' nak todan' men thi xa' nayiz len' wiz ndryo'xkwen men? ");
INSERT INTO ztp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per naꞌnkapta xaꞌ. Zyasa mxen Jesus ya' xaꞌ yisa, mtodanꞌ Jesus xaꞌ nde mbloned Jesus xaꞌ, ndya xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nde nchab Jesus lo re xaꞌ: —¿Xanya thi goꞌ, tez le'xa len' wiz ndryoxkwen men gab thi bur goꞌ o thi ngon goꞌ lenꞌ poz, cho naꞌkoted goꞌ maꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nde ngen kwan ngak nkab xaꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lo mbwiꞌ Jesus lo re xaꞌ nde lo fyest, xa mbi xaꞌ re yasil nzi axta lo tyob xa', sa wa xaꞌ, zyasa mdaꞌ Jesus thi kwent lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Senꞌ kwes thi men goꞌ ya goꞌ lo yalselyaꞌ, naꞌkwid goꞌ tenꞌ ndyob xa' ntak tyob goꞌ, tak ndaga sin thib xaꞌ nde lo yalselyaꞌ jwanꞌ mas ntak lo goꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nde xaꞌ jwanꞌ ta mbrez goꞌ lo yalselyaꞌ ya, bike xaꞌ gax lo goꞌ nde nye xaꞌ lo go': \"Btaꞌ goꞌ tenꞌ ndob go' reꞌ tyob xaꞌ reꞌ.ꞌꞌ Zyasa nyata lo go' tyolaꞌs goꞌ nde yatob goꞌ axta xis. ");
INSERT INTO ztp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mbay le' go' senꞌ kwes xaꞌ goꞌ lo yalselyaꞌ, wa tob goꞌ axta xiska, sa senꞌ nde xaꞌ jwan mbrez goꞌ, nye xaꞌ lo goꞌ. ꞌꞌAmig, deꞌ go' tyob goꞌ xij re xa' ntak reꞌ.ꞌꞌ Zyasa ntak goꞌ lo re xaꞌ nzino go' ro mes. ");
INSERT INTO ztp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tak xaꞌ nchak naro, xaꞌ ya ryoꞌ yantho, nde xa' jwan' nanchak naroda xaꞌ ya ak naro. ");
INSERT INTO ztp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nogaꞌ nchab Jesus lo xaꞌ ta mbrez Jesus lo fyest ya: —Senꞌ kwes la men lo yalwa, naꞌkwesta la xaꞌ nak amig la, nek re wes la, nek re taa nde nek re xaꞌ rik jwanꞌ nzo gax liz la; tak reta xaꞌ reꞌ, no xaꞌ kwes xaꞌ lu lo yalwa chanꞌ xaꞌ, sa yotay nde tamod yaxa. ");
INSERT INTO ztp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Le' senꞌ ndlia thi fyest, brez re xaꞌ prob, re xaꞌ naꞌngenta thi ninꞌ, ngenta thi yan', re xaꞌ ngob nin', nde re xaꞌ nglwe. ");
INSERT INTO ztp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sa nabe'z toz yaa, tak xaꞌ reꞌ naꞌgakta kix xaꞌy loa. Per Dios taꞌy loa senꞌ ryoꞌxban re xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Senꞌ lo mbin thi xaꞌ ndob ro mes kon Jesus jwan' nchab Jesus, nchab xaꞌ lo Jesus: —¡Nabez toz nda xaꞌ jwanꞌ wa ro mes tenꞌ nyebeꞌ Dios! ");
INSERT INTO ztp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zyasa nchab Jesus: —Thi mbi mda' thi rzye' thoz wa re men, nde mbrez xaꞌ bro thoz men. ");
INSERT INTO ztp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Senꞌ ngoxob hor ya rsye'y, mtelꞌ xaꞌ mos xaꞌ, sa yatne mosa lo re xaꞌ ta mbrez xaꞌ ya: ꞌꞌDe' go', tak nzisa'la rzyeꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per reta xaꞌ mdobte, mtob ro choja jwan' sa nayad xa'. Xaꞌ ner nchab: ꞌꞌNya'b na loa gab la lo xa' nyebe' loa, penta mxin' thi izyo nde nakin' ya wi' ney.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nde tedib xaꞌ nchab: ꞌꞌNa penta mxin gayꞌ yunt ngon, nde nakinꞌ nda wiꞌn nyenꞌ cho ndli ma' sinꞌ. Nyab na loa ta gab la lo xaꞌ nyebeꞌ loa.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nde tedib xaꞌ nchab: ꞌꞌNa ngolo mpselyan, jwan' nasa naꞌlit na gan yan.\" ");
INSERT INTO ztp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Senꞌ mbere mos nchab mos reta jwan' na, lo xaꞌ nyebeꞌ lo mos. Zyasa mxi lazoꞌ xaꞌ nyebeꞌ, nde nchab xaꞌ lo mos: ꞌꞌBken wa re ned ro, re lenꞌ yez nde waxiꞌ re xaꞌ prob, re xaꞌ ngenta ninꞌ nde yanꞌ, re xaꞌ syeg nde re xaꞌ renk.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Senꞌ mbere mos nchab mos: ꞌꞌXa' nyebe' mblia na re jwanꞌ mnebeꞌ goꞌ lon, per tata ben' nalaja.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Zyasa nchab xaꞌ nyebeꞌ lo mos: ꞌꞌWa re ned ro, nde re ned bix, nde le'ka bchal xa' sa yeꞌd xaꞌ, sa se liz na. ");
INSERT INTO ztp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tak nipa na lo goꞌ nek thib xaꞌ, ta mbrez na nera', naꞌwarzyeꞌda jwan' mdoxkwan.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Men toz tir ndenke xis Jesus, nde mbyek Xa' nchab Xa' lo re men: ");
INSERT INTO ztp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tez cho goꞌ ncholaꞌs tyonke xis na, ndablo mas ke' lazo' go' na, ke xud go', xnaꞌ goꞌ, xaꞌ got goꞌ, re xinꞌ goꞌ, re wes goꞌ, re ptanꞌ goꞌ nde leꞌga leꞌ yalnaban chan' go', sa li goꞌ gan gak goꞌ xinꞌteꞌd na. ");
INSERT INTO ztp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nde tez na'taya'd lazo' go' rid go' pen xaja' men ne' kruza nde na'tyonked goꞌ xis na, naꞌlid go' gan ak goꞌ xin'te'd na. ");
INSERT INTO ztp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tez cho thi goꞌ ncholaꞌs toxkwaꞌ thi yo na'r toz xta', ¿Cho nanerta tyob goꞌ li goꞌ xgab sa koꞌ goꞌ kwent, nyenꞌ cho tal tmi talo goꞌy? ");
INSERT INTO ztp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ndaga na ben'ta mdixsa' go' xan' yo, nde na'ndlid go' gan ngaloy, reta men jwan' wi'y xino xa' go', ");
INSERT INTO ztp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nde gab xaꞌ: ꞌꞌXa' ba mdobte toxkwa' xaꞌ liz xaꞌ, nde naꞌndlid xaꞌ gan ngaloy.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nde taga' cho rey, senꞌ nda xaꞌ lo byo sa yo xaꞌ kon tediba rey, ndablo nerla li xaꞌ xgab, ¿Cho tak yo siꞌ mil sondad xaꞌ kon thibwal mil sondad jwanꞌ nde kon tedib rey? ");
INSERT INTO ztp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nde tez mne xa' naꞌlid xaꞌ gan, senꞌ tata benꞌ ndo tij tedib rey, telꞌ xaꞌ pla men xaꞌ yanaꞌb lo tedib rey ya, sa toyal xa' kwent. ");
INSERT INTO ztp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Taga', tez cho thi goꞌ naꞌlada re jwanꞌ ngeno go', na'lida goꞌ gan ak goꞌ xin'te'd na. ");
INSERT INTO ztp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wen nak ted, per tez tya'b naziga, ¿xamod ak nasiga tedib gob? ");
INSERT INTO ztp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nde naꞌlid sinꞌna, nekla li sin'na par beꞌb, benꞌta yobiy, tez ndob nza goꞌ, par gon goꞌ jwanꞌ reꞌ, bin goꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Reta xaꞌ jwanꞌ nthop tmi low par yez Rom, nde re men nzo'b xkena mbike xaꞌ sa gon xaꞌ jwanꞌ ndej Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Re xaꞌ fariseo nde re maestr nchak ley ngoxyo xaꞌ Jesus nde nchab xaꞌ: —Mbiꞌ re' nkata kon re xaꞌ nzoꞌb xken naꞌ nde nchano xaꞌ xa'. ");
INSERT INTO ztp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zyasa mdej Jesus thi kwent nagan lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Cho thi goꞌba, ngeno thib ayoꞌ mbakxilꞌ nde tez tyaꞌb thi maꞌ, cho naꞌlad goꞌ thi thap gal nzo tsinꞌ thap maꞌ lenꞌ wan nde yakwan' goꞌ maꞌ ta mdyaba, axta ke yosal goꞌ maꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nde senꞌ zyal goꞌ maꞌ, nawe toz yo lazoꞌ goꞌ we goꞌ maꞌ yen goꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","senꞌ sin goꞌ liz goꞌ, thop goꞌ re amig goꞌ nde re xaꞌ nzo gax liz goꞌ, nde gab goꞌ lo xaꞌ: ꞌꞌBlo nale lazoꞌ goꞌ kon na, tak mzyala mbakxilꞌ na ta mdyaba.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nin lo goꞌ taga' mas ncho yalnale lo beꞌ por thib xaꞌ nzoꞌb xken na', lo nzye' xgab xa' nde ndlaꞌ xa' jwan' narax, ke re thap gal nzo tsinꞌ thap xaꞌ jwanꞌ gal' ndo nde nanakin'ta zye' xgab xa' nde laꞌ xa' jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Taga', ¿cho thi ngol ngeno siꞌ tmi nde mtaꞌb ngol thiba, cho nangista ngol ki nde ndlo'b ngol yo, jwin ndryal ngol nkwanꞌ ngola axta kebe' yosala? ");
INSERT INTO ztp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nde senꞌ yosala, nthop ngol re xaꞌ nsal'ta ngol nde re xaꞌ nzo gax liz ngol, nde gab ngol lo xaꞌ: ꞌꞌBlo nale lazoꞌ goꞌ kon na, tak ngosal na tmin na ta mtab na ya.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nde nin lo goꞌ, taga' ncho nale lazoꞌ re anj chanꞌ Dios senꞌ thib xaꞌ nzoꞌb xken na', nzye' xgab xa' nde ndlaꞌ xa' jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Noga nchab Jesus: —Thi mbi' ngeno chop xinꞌ bi' naꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","nde or yenꞌ nchab lo xud naꞌ: \"Xud na, ptaꞌ jwanꞌ ndaꞌblo ak chanꞌ na.ꞌꞌ Zyasa mdiꞌd xaꞌ chenꞌ xaꞌ lo rop xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mbrid ta pla wiz, leꞌ xinꞌ xaꞌ or yenꞌ na, mthor reta jwanꞌ mdaꞌ xaꞌ lor, nde ndar tij, xa'la yez, nde tya mbriꞌdchor tmin or lo re jwanꞌ narax ngoxte lir. ");
INSERT INTO ztp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nde senꞌ mblu'xla or re tmin or, ngo thi win toz yez ya, nde mdobte ndya win lor. ");
INSERT INTO ztp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Zyasa ngwa kwanꞌ or sinꞌ lo thi xaꞌ yez ya, nde xaꞌ ya mtelꞌ or ya kenap or nguch. ");
INSERT INTO ztp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nde ndyanꞌ toz or, ncholaꞌs or war jwanꞌ ncha nguch, tak ngen cho taꞌ jwanꞌ war. ");
INSERT INTO ztp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Zyasa mblir xgab: \"¡Plopa re mos nge sinꞌ liz xud na, nde axta ndryoꞌ xoꞌb jwanꞌ ncha re mos, nde leꞌ na mer gaj na win ncheꞌya! ");
INSERT INTO ztp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mas beren liz xud na, nde gab na lo xaꞌ: ¡Xud na, mblin jwanꞌ narax loa nde mblin jwanꞌ narax lo Dios! ");
INSERT INTO ztp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanzalꞌta na koꞌlea na xinꞌ la; blilal na xaja thi mos la jwanꞌ nge sinꞌ loa.\" ");
INSERT INTO ztp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Zyasa mxen or ned, ndyar liz xud or. Senꞌ tata benꞌ tij nder, mbwiꞌ xud or or, mblat lazoꞌ xaꞌ or, mkeꞌ xaꞌ karel nda xiꞌ ned xaꞌ or, mdeꞌs xaꞌ or, nde mda xaꞌ chut kwat or. ");
INSERT INTO ztp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Zyasa nchab or, lo xud or: ꞌꞌXud na, mblin jwanꞌ narax lo Dios nde mblin jwanꞌ narax loa; nanzalꞌta na koꞌlea na xinꞌ la.\" ");
INSERT INTO ztp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per xud or nchab lo re mos xaꞌ, \"Bken go' waxiꞌ goꞌ lar wen bok xab goꞌ or, blo goꞌ thi ani kwen yaꞌr nde blo goꞌ yayid nir. ");
INSERT INTO ztp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nde waxiꞌ goꞌ thi ngon mas nacha nde bij goꞌ maꞌ wanꞌ nde linꞌ fyest. ");
INSERT INTO ztp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tak xinꞌ na reꞌ ngujla or, nde naya naban or, mdyab or, nde naya ngosal or.\" Zyasa mdobte mbli xaꞌ fyest. ");
INSERT INTO ztp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nde laja, leꞌ xinꞌ xaꞌ or gox naxte lo sinꞌ wan. Senꞌ mberer liz or, lo ndo sin gax or yo mbin or, nge keꞌ xaꞌ di nde nzo kani. ");
INSERT INTO ztp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zyasa mbrez or thi mos nde mnabdiꞌs or lo mos, cho kwan nchak. ");
INSERT INTO ztp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mos mkab: \"Wes la mbere nde xud goꞌ mnibeꞌ gaj ngon mas nachaꞌ, tak or wes la wen mberer nde nadanꞌ or.\" ");
INSERT INTO ztp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per wes or, or goxa, ngok nayiꞌ, nde nancholasta or yoter lenꞌ yo, zyasa mbroꞌ xud or, ngwayab xaꞌ lor, sa yeꞌd or yoter lenꞌ yo. ");
INSERT INTO ztp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Zyasa nchab or lo xud or: \"Bwiꞌ pla linꞌ ndo lin sinꞌ loa, nde thiblaꞌ nxoꞌbyek na la, nde nekla thi chib namdat la, par tyoxkwaꞌ thi komid wanon re xa' nzal'tan. ");
INSERT INTO ztp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nde naya mzin xinꞌ la jwanꞌ mblux reta tmin la lo re ngol ntho lad na' nde lo re jwanꞌ narax, nde mbij la ngon mas nacha par or.\" ");
INSERT INTO ztp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Zyasa nchab xud or: \"Xinꞌ na lu thibla nzo lon, nde reta jwanꞌ ngenon nak chanꞌ la. ");
INSERT INTO ztp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per naya ndablo konale lazonꞌ nde linꞌ fyest, tak wes la, ngujla nde naya naban or, mdya'b or nde ngosal or.\" ");
INSERT INTO ztp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus mdaꞌ thi kwent lo re xin'te'd Jesus, nchab Xa': —Ngo thi xaꞌ rik mkeno thi mos jwanꞌ ndowiꞌ re chanꞌ xaꞌ, nde ngwa yab men lo xaꞌ rika, leꞌ mos ndowiꞌ chanꞌ xaꞌ ya, ndoja ndlux mos re chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Zyasa mbrez xa' rika mos ya; nde nchab xaꞌ lo mos: ꞌꞌ¿Cho kwan nak jwanꞌ nchon na ndo linoa re chanꞌ na? Btej lon xamod ngea sinꞌ, tak naꞌtatra na sinꞌ kea. ");
INSERT INTO ztp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Zyasa mbli mos xgab: ¿Cho kwan lin naya, tak xaꞌ nak chanꞌ sinꞌ naꞌtatra xaꞌ sinꞌ keꞌn? Naꞌxektra na lin sinꞌ wan, nde ndyolas na nyaꞌb na gon. ");
INSERT INTO ztp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aa! Mnea na kwan linꞌ, sa yo men taꞌ liz naꞌ kwed na senꞌ mkib xaꞌ sinꞌ lon.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Zyasa mbrez mos, thib thiba xaꞌ jwanꞌ ndaꞌb lo patron mos, nde nchab mos lo xaꞌ ner: ꞌꞌ¿Plopa ndaꞌb la lo patron na?ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Leꞌ xaꞌ nchab: ꞌꞌNdab na thiba ayo barril aseit.ꞌꞌ Zyasa nchab mos lo xaꞌ: ꞌꞌNcheꞌ xkeꞌs la jwanꞌ ndob kwent la, btonꞌ thib ayoꞌ barril aseyt jwanꞌ ndob lo ney, nde benꞌta btob cho'psi' barril aseyt lo ney.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nde nchab mos lo tedib xaꞌ: ꞌꞌMbay lu, ¿plopa ndab la lo patron na?ꞌꞌ Xaꞌ ya nchab: ꞌꞌThib ayoꞌ sak trig ndaꞌb na.ꞌꞌZyasa nchab mos lo xaꞌ: ꞌꞌNcheꞌ xkeꞌs la jwanꞌ ndob kwent la, nde ptob benꞌta thap gal sak trig lo ney.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nde xaꞌ rika wen mbwiꞌ xaꞌ jwanꞌ mbli mos narax reꞌ, lo xa mkwanꞌ mos mod mbli mos. Tak mas nata yek re men lo izyo reꞌ, par lo re jwanꞌ lo izyo reꞌ, ke re men naxte lo xni chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na ni lo goꞌ, no goꞌ bli rsinꞌ goꞌ tmin goꞌ nde re jwanꞌ nchap goꞌ lo izyo reꞌ, sa li goꞌ gan amig, sa senꞌ lo mbre tmin goꞌ, ngeno goꞌ cho taꞌ tenꞌ kwed goꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Xaꞌ jwanꞌ naxut ndli rsinꞌ lud jwanꞌ, taga naxut ndli rsinꞌ xaꞌ jwanꞌ bro; per xaꞌ jwanꞌ narax ndli rsinꞌ jwanꞌ lud, taga narax li rsin xaꞌ jwanꞌ bro. ");
INSERT INTO ztp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jwanꞌ nasa tez nanaxuta ndli rsinꞌ goꞌ tmi nde re jwanꞌ ngeno goꞌ lo izyo reꞌ, ¿cho li lazonꞌ galꞌ li rsinꞌ goꞌ re jwanꞌ liga ntak toz? ");
INSERT INTO ztp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nde tez nandlid goꞌ jwanꞌ galꞌ lo jwanꞌ nanakta chanꞌ goꞌ, ¿Xomod li lazoꞌ men li goꞌ jwanꞌ galꞌ lo jwanꞌ nak chanꞌpa goꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ngen cho mos li gan ke sinꞌ lo chop xaꞌ nak xwanꞌ sinꞌ, tak giꞌno xaꞌ thi xaꞌ nde keꞌ lazoꞌ xaꞌ tedib xaꞌ, o li xaꞌ sinꞌ lo tib xaꞌ nde laꞌ xaꞌ tedib xaꞌ. Ngen cho men li gan li sinꞌ lo Dios nde nyalo xaꞌ yalrik. ");
INSERT INTO ztp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lo mbin re xaꞌ fariseo jwanꞌ nchab Jesus, mxiꞌno xaꞌ Jesus tak ndyablaꞌs toz re xa' tmi. ");
INSERT INTO ztp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Zyasa nchab Jesus lo xaꞌ: —Goꞌ ba, wen toz goꞌ lo re men ndyak goꞌ, per Dios nzolo lazoꞌ goꞌ, tak jwanꞌ mas ntak lo men, Dios ngo'tala. ");
INSERT INTO ztp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nde nchab Jesus: Ley chan' Moises nde re jwan' mbloꞌ re profet ngexobyek xaꞌy axta senꞌ mbyeꞌd Juan. Xata zya mdobte mbryaꞌs diꞌs wen chanꞌ Dios, nde reta men nchal yote tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mas nale' dyonꞌ beꞌ nde izyo, ke thi diꞌs nge lo ley, retay atakey xaja nchab lo ley. ");
INSERT INTO ztp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Reta xaꞌ biꞌ jwanꞌ ndlaꞌ ngol naꞌ, nde nselyaꞌ xaꞌ kon tediba' ngol, yalke nchap xa' lo Dios, nde xa' jwan' nselya' kon ngol ta mblaꞌ xaꞌ biꞌ ya, taga yalke nchap xa'. ");
INSERT INTO ztp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ꞌꞌNgo thi xaꞌ rik, nchok lar nawe nya nde lar nap, nde reta wiz ndli xaꞌ fyest nde nab jwan' wen ngo xaꞌ mes. ");
INSERT INTO ztp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nde nogaꞌ ngo thi xaꞌ prob ndole Lazaro nde ndo yeꞌs dib lad xaꞌ, ndyob xaꞌ izyo ro yalan xaꞌ rika. ");
INSERT INTO ztp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nde ndya'bla's xaꞌ wa xaꞌ jwanꞌ nchab ro mes xaꞌ rik sa se xa' nde axta re mbak mbike lo xa' ndyup mbak re ye's ndo lad xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Per thib wiz nguj Lazaro xa' nalat ndyaka, nde re anj chanꞌ Dios mbeꞌ Lazaro tenꞌ nzo Abraham. Nde noga xaꞌ rika nguj nde mka's men xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nde senꞌ nzo rik yeꞌr abil, nzo xaꞌ lo pen, zyasa mblit lo xaꞌ, nde tij mbwiꞌ xaꞌ Abraham, nde Lazaro ndo lad Abraham. ");
INSERT INTO ztp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Zyasa mbrez yaj rik lo Abraham nchab: ꞌꞌ¡Xud na Abraham, blat lazoꞌa na! Ptelꞌ Lazaro sa gas xaꞌ xi kwen yaꞌ xaꞌ lenꞌ nit nde yeꞌd tayal xaꞌ los na, tak naꞌxektra na lo bel reꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Per Abraham nchab: ꞌꞌXinꞌ na, ptelaꞌs ke bro jwanꞌ mkenoa nde wen mban la lo izyo, nde mbiꞌ reꞌ mbriꞌd yalti nde ngen kwan mkeno xaꞌ. Per naya nawe nzo xaꞌ ncheꞌ, nde leꞌ lu nzo lo pen. ");
INSERT INTO ztp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nde parka nzo thi xlaj toz jwanꞌ ngen cho gak rid, xij naꞌ, nde tenye xaꞌ nzo ncheꞌya ncholaꞌs xaꞌ ya xaꞌ tenꞌ nzoꞌa, naꞌgakta rid xaꞌ, nde xaꞌ nzo tenꞌ nzoꞌa ba, naꞌakta rida xaꞌ sa yeꞌd xaꞌ tenꞌ nzo náꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Zyasa nchab xaꞌ rik lo Abraham: \"Nyaꞌb na loa xud na, ptelꞌ Lazaro ya xaꞌ liz xud na, ");
INSERT INTO ztp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tak tya ngenon gayꞌ wes na, sa taꞌ Lazaro kwent lo xaꞌ, sa naꞌyeta xaꞌ tenꞌ nzon lo pen reꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham nchab: ꞌꞌNgenoa xaꞌ re jwanꞌ mkeꞌ Moises lo ye's, nde re jwanꞌ mkeꞌ re profet lo ye's ¡Ndablo xoꞌbyek xaꞌy!ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Per xaꞌ rik nchab: ꞌꞌXud na, Abraham, pa li lazoꞌ xaꞌy, per tez thi xaꞌ ngujla ryoꞌxban nde ryoꞌto xaꞌ lo xaꞌ, zyasa tli lazoꞌ xaꞌ Dios nde tseꞌ xgab xaꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per Abraham nchab lo xaꞌ rika: ꞌꞌTez na'xobyekta xaꞌ jwanꞌ mkeꞌ Moises, nde re profet, taga' naꞌlid lazoꞌ xaꞌy, teꞌnyega ryoꞌxban thi xaꞌ nguj.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus nchab lo re xin' te'd Jesus: —Tibka nzo jwanꞌ li sa gab men lo jwanꞌ narax, per ¡nalat nya men li gab ta men naꞌ lo jwanꞌ narax! ");
INSERT INTO ztp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas jwin nda xaꞌ, tyobdoꞌ thi ke ntoꞌ men jwanꞌ yen xaꞌ nde yobi xaꞌ lenꞌ nittoꞌ, ke li xaꞌ gab ti men lo yalke. ");
INSERT INTO ztp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pkenap goꞌ lazoꞌ goꞌ. ꞌꞌTez cho ta goꞌ mbli jwan' narax lo goꞌ; brez go' yek xaꞌ, tez zyeꞌ ak xaꞌ la' xa' jwan' narax, ptori'd go' yek go' jwanꞌ mbli xaꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nde teꞌnye gaz gob li xaꞌ jwan' narax lo goꞌ lenꞌ wiz, nde tez gaz gob nde xaꞌ lo goꞌ nde nye xaꞌ lo goꞌ: ꞌꞌNalitra nayꞌꞌ, ptori'd goꞌ yek go' jwan' mblino xa' go'. ");
INSERT INTO ztp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Zyasa nchab re xin'te'd Jesus lo Jesus: —Bli sa masra' li lazo' ná' lu. ");
INSERT INTO ztp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zyasa nchab Jesus: —Tez ndli lazoꞌ goꞌ Dios, masa thi jwanꞌ lud xapa thi mbis mostaz, toyal gab goꞌ lo ya reꞌ: “Byiꞌb ncheꞌya nde btob lenꞌ nittoꞌ”, txoꞌbyeka goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nde nchab Jesus: Tez thi goꞌ ba ngeno thi mos, jwanꞌ penta mbere ngwa sinꞌ wan o ngwa kenap re maꞌ, leꞌ hor mbere xaꞌ lo sinꞌ, ¿Cho tab goꞌ lo xaꞌ: ꞌꞌPtob sa waa?\" ");
INSERT INTO ztp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cheꞌla, gab goꞌ lo xaꞌ: ꞌꞌPtoxkwaꞌ jwanꞌ wa rzyeꞌn, pseꞌ xab la nde ptosaꞌ sa koa jwanꞌ wan nde jwanꞌ gun, senꞌ mne mdan seraꞌ waa nde gua.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Nde cho mdaꞌ goꞌ dyux lo mos lo mbli mos re jwanꞌ mnebeꞌ goꞌ?, nda lazoꞌn namdaꞌd goꞌ dyux lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Taga' goꞌ, ngolo mbli goꞌ re jwanꞌ mnibeꞌ Dios lo goꞌ li go', zyasa gab goꞌ: ꞌꞌMos ngen cho jwis nak náꞌ, tak benꞌta mbli náꞌ sinꞌ, jwanꞌ mnibeꞌta xaꞌ lo náꞌ ndli náꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Laj ndo Jesus ned ndya Xaꞌ yez Jerusalen, ndariꞌd Xaꞌ xij xyon men Samaria nde xyon men Galilea. ");
INSERT INTO ztp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nde senꞌ ndozin Jesus thi yez lud, mbroꞌ siꞌ xaꞌ biꞌ ndyak ye's ya's lo Jesus, nde re xaꞌ ya tijraꞌ mbre xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mbrez yaj xaꞌ, nchab xaꞌ: —¡Jesus, Maestr, blat lazoꞌa náꞌ! ");
INSERT INTO ztp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Senꞌ mbwiꞌ Jesus re xaꞌ, nchab Jesus lo xaꞌ: —Wa goꞌ sa wiꞌ nglweyꞌ goꞌ. Nde laj ndo xaꞌ ned, mbyak xaꞌ nde mbyanꞌ nambi belꞌ xaꞌ lo yis ndyak xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nde thib xaꞌ ya, senꞌ mne xaꞌ mbyak xaꞌ, mbere xaꞌ nde leꞌka ne mbrez xaꞌ nde mbli naro xaꞌ le Dios. ");
INSERT INTO ztp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nde mdoxub xaꞌ lo Jesus, axta mdinꞌ yek xaꞌ izyo, nde mdaꞌ xaꞌ dyux lo Jesus. Nde xaꞌ reꞌ, nak xaꞌ yez Samaria. ");
INSERT INTO ztp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Zyasa nchab Jesus: —¿Cho nakta siꞌ goꞌ jwanꞌ mbyanꞌ nambi belꞌ naꞌ nde mbyak lo yis? ¿Mbay ma thi yeꞌ xaꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Cho benꞌta thib xaꞌ thiblada mbere nde linaro xaꞌ le Dios? ");
INSERT INTO ztp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Zyasa nchab Jesus lo xaꞌ: —Btoli nde bya; Tak mbli lazoꞌa Dios jwanꞌ na mbyak la. ");
INSERT INTO ztp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Zyasa re xaꞌ fariseo mnabdiꞌs lo Jesus, pol sin yalnyebeꞌ chanꞌ Dios, zyasa mkab Jesus lo xa': — Yalnyebeꞌ chanꞌ Dios, na'aktey thi jwanꞌ toyal wi' reta mena sen' sina. ");
INSERT INTO ztp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ngen cho gab: ꞌꞌleꞌy ncheꞌyaꞌꞌ o ꞌꞌleꞌy ba\", tak yalnyebeꞌ chanꞌ Dios ndola xij goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zyasa nchab Jesus lo re xin'te'd Jesus: —Tsin wiz, sen' ncholaꞌs goꞌ wi' goꞌ thi wiz chanꞌ Xinꞌ Mbi, per naꞌwi'd goꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nde ryoꞌ pla xaꞌ nye lo goꞌ: ꞌꞌLeꞌ Xaꞌ ndo ncheꞌyaꞌꞌ, o ꞌꞌle' Xa' ndo baꞌꞌ, per na'yad go' nde naꞌtyonked goꞌ xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tak xaja ndloꞌ ncho xni belti dib lo be', taga' ak Xin' Mbi' senꞌ sin wiz yeꞌd Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per ner nakinꞌ riꞌd Xa' bro toz yalti nde kotal re men nzi naya Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ta xa ngok lenꞌ wiz senꞌ ngo Noe, taga' ak wiz senꞌ yeꞌd Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lenꞌ re wiz ya ncha xa' nde nchuꞌ xa', nselyaꞌ xa', nde ndaꞌ xa' xinꞌ got xa' sa selyaꞌr, axta mzin wiz senꞌ ngo Noe lenꞌ bark, nde mdobte nde nit toz tira, nde reta men mblux. ");
INSERT INTO ztp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nde taga' ngok lenꞌ re wiz ngo Lot: Re men ncha xaꞌ nchuꞌ xaꞌ, ndiꞌ xaꞌ nde nthoꞌ xaꞌ, ngo xaꞌ bin nde ntaꞌ xaꞌ yo. ");
INSERT INTO ztp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per wiz senꞌ mbroꞌte Lot yez Sodoma, mbroꞌ bel lo beꞌ xaja yike ba, nde mbluxa reta men yez Sodoma. ");
INSERT INTO ztp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nde taga' yotey lenꞌ wiz senꞌ ryotoꞌ Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wiz ya, xaꞌ jwanꞌ ndo yek yo, nalyad xa' ya xiꞌ xaꞌ chanꞌ xaꞌ nzi lenꞌ yo, nde re xaꞌ ndo len' wan naꞌbereda xaꞌ liz xa'. ");
INSERT INTO ztp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Ptelaꞌs goꞌ jwanꞌ ngote ngol Lot. ");
INSERT INTO ztp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xaꞌ jwanꞌ nkelo tolaꞌ yalnaban chanꞌ naꞌ, xaꞌ ya cheꞌ taꞌba, per xaꞌ jwanꞌ taꞌb yalnaban chanꞌ naꞌ lo ndli lazoꞌ xaꞌ na, xaꞌ ya cheꞌ tolaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nin lo goꞌ, yal' ya nzi yat chop xaꞌ lo ka, thib xaꞌ yoꞌ, nde tedib xaꞌ ba'. ");
INSERT INTO ztp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nde chop ngol thita nge yuꞌ, thib xaꞌ yoꞌ nde tedib xaꞌ baꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nde chop xaꞌ biꞌ nge sinꞌ wan; thib xaꞌ yoꞌ nde tedib xaꞌ baꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zyasa mnabdiꞌs re xin'te'd Jesus, nchab xa': —¿Xaꞌ Nyebeꞌ, plo ak re jwanꞌ reꞌ? Jesus mkab lo xaꞌ, nchab: —Tenꞌ nax maꞌ nguj, tya ndyope re ngol. ");
INSERT INTO ztp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus mdaꞌ thi kwent nagan, sa loꞌ Jesus xamod ndablo tiblaꞌ todi'sno men Dios nde sa naꞌlyayod men. ");
INSERT INTO ztp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nchab Jesus: —Thi yez ngo thi juez, jwanꞌ nanzepta lazoꞌn Dios neka ndyo xa' re men. ");
INSERT INTO ztp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Leꞌga yez ya ngo thi ngol nguj sal' na', jwanꞌ ngyo kon tediba xaꞌ nde nchanaꞌb ngol lo Juez sa nyaꞌb juez kwent lo xaꞌ ta ndabeyono ngol la. ");
INSERT INTO ztp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nde bro tyemp mkete ngol lo juez per naꞌgoxyod juez jwanꞌ nyaꞌb ngol, ya lulka sa mbli juez xgab: Nanzepta lazoꞌn Dios nde neka ndyon men, ");
INSERT INTO ztp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per ngol reꞌ thibla' ndotaꞌ ngol xyan yek na, mas laꞌston ngol, sa naꞌyetra ngol lon, tak yoloba yoche lazoꞌn. ");
INSERT INTO ztp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Zyasa nchab Jesus: —Bin goꞌ jwanꞌ nchab juez narax naka. ");
INSERT INTO ztp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nde cho ndyak goꞌ na'lastod Dios re xaꞌ jwanꞌ mblí Dios, jwan' nyaꞌb lo Dios yalꞌ ndlya be? ¿Cho ndyak goꞌ na, sowꞌ toz kab Dios lo xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na ni lo goꞌ, Dios naxax laꞌsto Xaꞌ go'. Per senꞌ ye'd Xinꞌ Mbiꞌ, ¿Cho benꞌ tasal xa' men jwanꞌ ndli lazoꞌn Dios lo izyo reꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus mdaꞌ kwent chanꞌ pla xaꞌ, jwanꞌ ndli xgab nak xaꞌ men galꞌ, nde ngotal xaꞌ temas men: ");
INSERT INTO ztp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ngo thi wiz, ngoxoꞌb chop xaꞌ biꞌ yodoꞌ, sa todi'sno xa' Dios: Thib xaꞌ nak xaꞌ fariseo, nde tedib xaꞌ nak, xaꞌ nyaꞌb tmi low. ");
INSERT INTO ztp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Leꞌ xaꞌ fariseo ndo li, nde ndotodi'sno xa' Dios nchab xaꞌ: ꞌꞌDios, tan dyux loa tak nanakta na xaja temas men, re men wanꞌ, re men ndli jwanꞌ narax, re men ndyen ngol xaꞌgaꞌ men, nde neka nak na xaja xaꞌ ta nyaꞌb tmi low ndo ba. ");
INSERT INTO ztp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na ndli yalse chop gob lenꞌ sman nde ndan dyesmo lo reta jwanꞌ ndlin gan.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Leꞌ xaꞌ nyaꞌb tmi lowa, mdo tij xaꞌ, nde neka ndlit xaꞌ lo xaꞌ wiꞌ xaꞌ lo beꞌ, benꞌta nginyaꞌ xaꞌ lazoꞌ xaꞌ nde nchab xaꞌ: ꞌꞌ¡Dios, blat lazoꞌa na, tak na nak xaꞌ nzoꞌb xken naꞌ!ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na ni lo goꞌ, leꞌ xaꞌ nyaꞌb tmi low, senꞌ ndya xaꞌ liz xaꞌ, mtonꞌka Dios xken xaꞌ, per xaꞌ fariseo naꞌntonꞌta Dios xken xaꞌ. Tak xaꞌ nchak naro, xaꞌ ya ryoꞌyantho, per xaꞌ nanchaknaroda, xaꞌ ya ak naro. ");
INSERT INTO ztp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tagaꞌ mzin re men ndeno re or bix lo Jesus, sa xoꞌb yaꞌ Jesus yek or, per senꞌ mbwiꞌ re xin'te'd Jesus jwanꞌ reꞌ, mdobte mbrezno xaꞌ re men ndeno re or bixa. ");
INSERT INTO ztp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Leꞌ Jesus mbrez re or bix nde nchab Jesus lo xinꞌ teꞌd Jesús: —Btaꞌ goꞌ diꞌs yeꞌd re or bix lon, nde naꞌkad goꞌ diꞌs, tak tenꞌ nyebeꞌ Dios nak par reta men jwanꞌ nak lazoꞌn xaja re or bixa. ");
INSERT INTO ztp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nde galꞌ diꞌs nin lo goꞌ, xaꞌ jwanꞌ nankayaꞌd yalnyebeꞌ chanꞌ Dios, xaja or bix, naꞌyoted xaꞌ tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Thi mbi' nak kabes mnabdiꞌs lo Jesus: —Maestr wen, ¿Kwan ndablo lin sa kayan yalnaban adiꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus nchab: —¿Kwan liy ngoꞌlea na xaꞌ wen? Ngen cho wen nak, benꞌta thita xaꞌ wen nzo, xaꞌ ya nak Dios. ");
INSERT INTO ztp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mnea la re jwanꞌ nyebeꞌ xkiꞌs Dios: ꞌꞌNaꞌtyenta la ngol jwanꞌ nanakta ngol la, naꞌkujta la men, naꞌliwanꞌta la, naꞌnit la diꞌs kwinꞌ xis nek thib men, xoꞌbyek xud la nde xnaꞌa.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Le mbi' ya nchab lo Jesus: —Reta jwanꞌ reꞌ nxobyek na xata lud na. ");
INSERT INTO ztp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Senꞌ mbin Jesus jwanꞌ reꞌ, nchab Jesus lo xaꞌ: —Thipta jwanꞌ nchak jwad lia, ptho reta jwanꞌ ngenoa nde ptaꞌ tmi lo re xaꞌ prob. Tamod sa kenoa yalrik lo beꞌ sera' deꞌ sa tyonkea xis na. ");
INSERT INTO ztp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Per senꞌ mbin xaꞌ jwanꞌ reꞌ, ngo nabil lazoꞌ xaꞌ, tak xaꞌ rik toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Senꞌ mbwiꞌ Jesus ngo nabil lazoꞌ xaꞌ, nchab Jesus: —¡Ne toz yote thi xaꞌ rik tenꞌ nyebeꞌ Dios! ");
INSERT INTO ztp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tak mas naleꞌ rid thi kamey lenꞌ yeꞌr yagux, ke rid thi xaꞌ rik tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Zyasa re xaꞌ mbin jwanꞌ reꞌ nchab xaꞌ, ¿Cho li gan lyaꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Zyasa nchab Jesus: —Re jwanꞌ ta naꞌakta li men, Dios tak li. ");
INSERT INTO ztp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedr nchab lo Jesus: —Náꞌ mblaꞌ náꞌ reta jwanꞌ ngeno náꞌ sa tyonke náꞌ xis la. ");
INSERT INTO ztp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zyasa nchab Jesus lo xaꞌ: —Lipa nin lo goꞌ, xaꞌ jwanꞌ mblaꞌ liz naꞌ, mblaꞌ salꞌ naꞌ, mblaꞌ wes naꞌ, mblaꞌ xud naꞌ, mblaꞌ xinꞌ naꞌ, por yalnyebeꞌ chanꞌ Dios, ");
INSERT INTO ztp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","xaꞌ ya kayaꞌ mas yalwen naya, nde mas yoloba kayaꞌ xaꞌ yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zyasa xaꞌta mbrez Jesus re tib sen xin'te'd Jesus, nde nchab Jesus lo xaꞌ: —Naya ndanꞌ yez Jerusalen, tenꞌ ak reta jwanꞌ mkeꞌ re profet yate Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tya tayaꞌ xaꞌ xaꞌ lo yaꞌ re xaꞌ nanakta xaꞌ Israel. Xaꞌ ya xino xaꞌ xaꞌ, loꞌs xaꞌ xaꞌ nde suk xaꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kin xaꞌ xaꞌ nde kuj xaꞌ xaꞌ; per yaxob mbyon wiz ryoꞌxban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per nek lud naꞌngyenta xaꞌ jwanꞌ nchab Jesus lo xaꞌ, anaꞌnye xaꞌ jwanꞌ nchab Jesus lo xaꞌ, tak jwanꞌ nagan yen mena. ");
INSERT INTO ztp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Senꞌ nde sin gax Jesus yez Jerico, tya ndob thi xaꞌ syeg ro ned, ndob na'b gon. ");
INSERT INTO ztp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Senꞌ mbin xaꞌ ndarid men toz tir tya, mnabdiꞌs xaꞌ, ¿Cho kwan ndoyak? ");
INSERT INTO ztp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Zyasa nchab men lo xaꞌ, Jesus Nazaret ndarid ncheꞌya. ");
INSERT INTO ztp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Zyasa mbrez yaj xaꞌ syega, nchab xaꞌ: —¡Jesus, xaꞌ nde lo bin David, blat lazoꞌa na! ");
INSERT INTO ztp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nde re xaꞌ nda siblo lo Jesus, mtokox xaꞌ xaꞌ syega, sa na'kwesta xaꞌ, per cheꞌla masra' ne mbrez xaꞌ: —¡Xaꞌ nde lo bin David, blat lazoꞌa na! ");
INSERT INTO ztp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zyasa ngoto Jesus, nde mnebeꞌ Jesus yeꞌdno men xaꞌ lo Jesus, senꞌ mzin xaꞌ lo Jesus, mnabdiꞌs Jesus lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Cho kwan ncholaꞌs la lin loa? Zyasa mkab xaꞌ syega nchab xaꞌ: —Xaꞌ Nyebeꞌ, na ncholas yoni lon. ");
INSERT INTO ztp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus nchab lo xaꞌ: —¡Leꞌ loa yoni! Tak lo mbli lazoꞌa na, mdyanꞌ la. ");
INSERT INTO ztp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Zyaga ngoni lo xaꞌ syega, mdonke xaꞌ xis Jesus nde mbli naro xaꞌ le Dios. Nde reta men jwanꞌ mbwiꞌ jwanꞌ ngok, no xaꞌ mbli naro xaꞌ le Dios. ");
INSERT INTO ztp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Lo ngote Jesus len' yez Jerico, ndaridndab Jesus lenꞌ yez, ");
INSERT INTO ztp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nde tya nzo thi mbiꞌ rik ndole Zaqueo, xaꞌ ya nak xaꞌ nyebeꞌ lo re xaꞌ nyaꞌb tmi low, ");
INSERT INTO ztp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","nde ncholaꞌs Zaqueo wiꞌ xaꞌ Jesus. Per naꞌgakta wiꞌ xaꞌ Jesus, tak bro thoz men nde Zaqueo xaꞌ lud xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jwanꞌ nasa mkeꞌ xaꞌ karel, mziblo xaꞌ nde ngwap xaꞌ thi lo ya ndole sicomoro, sa toyal wiꞌ xaꞌ Jesus, tak tya ridndaꞌb Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Senꞌ ndarid Jesus tya, mblit lo Jesus lo ya nde mbwiꞌ Xaꞌ nzo Zaqueo lo ya, nde nchab Xaꞌ lo Zaqueo: —Zaqueo nabanka bla, tak naya nakinꞌ kwed na liz la. ");
INSERT INTO ztp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zyasa leꞌ Zaqueo naban mbla xaꞌ, nde nale toz ngo lazoꞌ xaꞌ mbeꞌ xaꞌ Jesus liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Senꞌ mbwiꞌ re men jwanꞌ reꞌ, mdobte narax mdodiꞌs xaꞌ xis Jesus nchab xaꞌ, Jesus nda sa kwed Jesus liz thi xaꞌ nzoꞌb xken naꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zyasa mdoli Zaqueo nde nchab Zaqueo lo Jesus: —Xaꞌ Nyebeꞌ, wiꞌ nea, reta jwanꞌ ngenon tan rola lo re xaꞌ prob; nde tez mbli wanꞌ na cho lo men, zireney masraꞌ thap gob. ");
INSERT INTO ztp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus nchab lo xaꞌ: —Naya mzin wiz lyaꞌ re men nzo yo re', lo ta no mbiꞌ reꞌ nde lo bin Abraham. ");
INSERT INTO ztp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tak Xin' Mbi' nde Xaꞌ sa kwan' Xaꞌ nde tola' Xaꞌ re men mdyaꞌb. ");
INSERT INTO ztp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Laja nzi yon reta men jwanꞌ ndej Jesus, Jesus mdaꞌ thi kwent nagan lo xaꞌ, tak ndosin gaxla Jesus yez Jerusalen, nde re men ndli xgab leꞌ yalnyebeꞌ chanꞌ Dios ndosin gaxtirla. ");
INSERT INTO ztp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Zyasa nchab Jesus lo xa': —Ngo thi xaꞌ ntak toz, mbro' nda tij lo xaꞌga xyon men, sa tya kayaꞌ xaꞌ yalnyebeꞌ ak xaꞌ rey, sera' bere xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Senꞌ teraꞌ ryoꞌ xaꞌ, mbrez xaꞌ siꞌ mos xaꞌ, nde mdaꞌ xaꞌ bro tmi lo kad thib mos, nde nchab xaꞌ lo mos: \"Bli niꞌ go' tmi reꞌ sin', axta kebeꞌ beren.\" ");
INSERT INTO ztp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per re men las xaꞌ, ngiꞌno men xaꞌ, nde mtelꞌ re men las xaꞌ pla men ndyaga tya, yayab: ꞌꞌNa'nchola'sta náꞌ xaꞌ reꞌ ak rey lo náꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per mkayaꞌ xaꞌ yalnyebeꞌ ngok xaꞌ rey, nde senꞌ mbere xaꞌ las xaꞌ, mnebeꞌ xaꞌ kwes men re mos xaꞌ jwanꞌ mdaꞌyaꞌ xaꞌ tmi lonꞌ ya, sa nye xaꞌ, plopa mxyen tmin xa' lo mbli niꞌ mosa. ");
INSERT INTO ztp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mos ner mbyeꞌd nde nchab: ꞌꞌXaꞌ nyebeꞌ, tmi mdaꞌa lon mxyena siꞌ gob masra'.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Leꞌ rey nchab lo mos: ꞌꞌWen toz mblia, thi mos wen nak la lo ta galꞌ mkea sinꞌ, lo jwanꞌ lud mdan loa, naya lilal na lu, xaꞌ nyebeꞌ lo siꞌ yez.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Zyasa mbyeꞌd tedib mos nchab: ꞌꞌXaꞌ nyebeꞌ, tmi mdaꞌa lon, mxyena gayꞌ gob masra'.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Noga lo mos ya nchab xaꞌ: ꞌꞌLu nyebeꞌ lo gayꞌ yez.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Per mbyeꞌd tedib mos nchab lo rey: ꞌꞌXaꞌ nyebeꞌ, ncheꞌ tmin la, mchal na tmin la lo thi bayek nde mtobsaꞌney. ");
INSERT INTO ztp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tak nzyeb na lu, mnen, ne nak la, nyaꞌb la jwanꞌ namket la sinꞌ nde ndlit la jwan' ngok tenꞌ namblod la bin.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Zyasa nchab rey lo xaꞌ: ꞌꞌMos xkap, kon leꞌga xkiꞌs la koxyon la. Tez mneꞌa ne nak na, nyaꞌb na jwanꞌ namket na sinꞌ nde ndlit na jwan' ngok tenꞌ namblod na bin, ");
INSERT INTO ztp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Kwan ndliy sa namblot la tmin na yaꞌ xaꞌ nkeno tmi sinꞌ, sa senꞌ mberen ndaꞌyaꞌa tmin na kon xinꞌ neꞌy?ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nde nchab rey lo xaꞌ nzi tya: Bkib goꞌ tmi yaꞌ mos reꞌ, nde pta' goꞌy lo mos jwanꞌ ta nden siꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Zyasa mkab xaꞌ lo rey: ꞌꞌXaꞌ nyebeꞌ, ¡Per ndenla xaꞌ siꞌy! ");
INSERT INTO ztp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Per rey nchab: Nin lo goꞌ, xaꞌ jwanꞌ ngenolay, masra'y kayaꞌ xaꞌ, per xaꞌ nangenodey, axta jwanꞌ lud ngeno xaꞌ, yiꞌba yaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mbay re xaꞌ jwanꞌ ta ngiꞌno xa' na ba, xa' jwan' nancholaꞌsta ak na rey lo xaꞌ, deꞌno goꞌ xaꞌ ncheꞌya, nde bij goꞌ xaꞌ lon reꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Senꞌ mne nchab Jesus re jwanꞌ reꞌ, ndya Jesus yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Senꞌ ndo sin gax Jesus yez Betfage nde yez Betania, lad yiꞌ jwanꞌ ndole Oliv, zyasa mtelꞌ Jesus chop xin'te'd Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nchab Jesus lo xaꞌ: —Wa goꞌ yez nzi lad tso ba, sen' yote go' len' yez yosal goꞌ thi bur teꞌ yen' ngedoꞌ, ma' tera tyob nek thib men. Bxak goꞌ ma' nde deꞌno goꞌ ma'. ");
INSERT INTO ztp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nde tez cho men nyabdiꞌs lo goꞌ, kwan ndliy ngexak goꞌ bur, gus goꞌ lo xaꞌ, Xaꞌ Nyebeꞌ nakinꞌ ma'. ");
INSERT INTO ztp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Zyasa ngwa rop xaꞌ, nde mzyal xaꞌ bur a xata nchab Jesus lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nde laja ngexak xaꞌ bur, xwanꞌ bur mna'bdi's lo xaꞌ, nchab: —¿Kwan ndliy ngexak goꞌ bur? ");
INSERT INTO ztp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Zyasa mkab xaꞌ nchab xaꞌ: —Xaꞌ Nyebeꞌ nakinꞌ ma'. ");
INSERT INTO ztp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nde mbe' xaꞌ bur lo Jesus, mxob xaꞌ xab xaꞌ xis bur, nde mtob xaꞌ Jesus xis bur. ");
INSERT INTO ztp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nde xa nderidandab Jesus, taja ntogaꞌ men xab men lo ned. ");
INSERT INTO ztp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Senꞌ ndo sin gax Jesus, par tyola Jesus yiꞌ Oliv, zyasa reta xaꞌ ndanke xis Jesus mdobte ne mbrez xaꞌ tak nale nzo lazoꞌ xaꞌ nde ndaꞌ xaꞌ dyux lo Dios, por reta yalnaro jwanꞌ mbwiꞌ xaꞌ mbli Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nde nchab xaꞌ: —¡Nayon nak Rey jwanꞌ nde lo le Xaꞌ Nyebeꞌ! ¡Yalnabe'z lo be' nde naro toz nak Dios lo beꞌ! ");
INSERT INTO ztp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Zyasa pla xaꞌ fariseo jwanꞌ nzo xij re men nchab lo Jesus: —Maestr, brez yek re xaꞌ ta ndenke xis la. ");
INSERT INTO ztp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus mkab lo xaꞌ: —Leꞌ na ni lo goꞌ, tez re xa' re' nakwesta xa', re ke ba kwes. ");
INSERT INTO ztp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Senꞌ mzin Jesus gax yez Jerusalen, lo mbwiꞌ Jesus yez, mbinꞌno Jesus yez, ");
INSERT INTO ztp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nde nchab Jesus: —¡Tez goꞌ men Jerusalen, tez ngaka na wiz reꞌ nye goꞌ cho taꞌ yalnabeꞌz lo goꞌ! Per naya nzo nagasa, nde naꞌakta wiꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Per yeꞌd wiz nathoz par goꞌ, re xaꞌ ngi'no goꞌ, dib nchek yez la kwek xa' yo nde kwetowꞌ xaꞌ lo go'. ");
INSERT INTO ztp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nde thibtane lux reta goꞌ, kon re xinꞌ goꞌ, nde tub xaꞌ reta pto nde naꞌyanta nek thib ke xis ta ke, tak naꞌntakbeꞌd go' tyemp jwanꞌ senꞌ mbyeꞌdtna Dios goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zyasa ngote Jesus lo len yodoꞌ, nde mdobte mbloꞌte Jesus re xaꞌ ntho, nde re xaꞌ ndiꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nde nchab Jesus lo xaꞌ: —Lo xkiꞌs Dios ngeni: ꞌꞌLiz na nak yo ten' todi'sno men naꞌꞌ; per goꞌ mblilala yeꞌr ncho xaꞌ wanꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nde reta wiz ndloꞌ Jesus xkiꞌs Dios lo men, lo len yodoꞌ, leꞌ re xaꞌ nyebeꞌ lo re nglweyꞌ, re maestr nchak xkiꞌs Dios, nde re xaꞌ nyebeꞌ lo yez, nkwanꞌ xaꞌ xamod kuj xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per naꞌyosalta xa' xamod li xaꞌy, tak reta men leꞌka ntobnza xaꞌ nzi yon xkiꞌs Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Thib wiz senꞌ ngeloꞌ Jesus xkiꞌs Dios nde ngetej Xa' di's wen chan' Dios lo re men lo len yodo', mzin re xaꞌ nyebeꞌ lo re nglweyꞌ, re maestr nchak ley, nde re xaꞌ gox jwanꞌ nyebeꞌ lo yez, ");
INSERT INTO ztp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nde nchab xaꞌ lo Jesus: —Btej lo náꞌ, ¿kon cho yalnyebeꞌ ndlya re jwanꞌ reꞌ? ¿Cho mdaꞌ yalnyebeꞌ reꞌ loa? ");
INSERT INTO ztp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus mkab lo xaꞌ nchab: —Noga na nyaꞌbdiꞌs lo goꞌ, mne go' lon: ");
INSERT INTO ztp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cho mnebe' lo Juan ko'le Juan men? ¿Cho Diosa o mena? ");
INSERT INTO ztp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Zyasa nchab xaꞌ lo ta xaꞌ: —Tez gab na' Dios mtelꞌ Juan, nye Jesus lonꞌ, ꞌꞌ¿Kwan ndliy naꞌndlid lazoꞌ goꞌ jwanꞌ mbloꞌ Juan?ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nde tez gab naꞌ, men mtelꞌ Juan, reta men gadke xaꞌ naꞌ nde kuj xaꞌ naꞌ, tak ndli lazo' xa' le' Juan nak thi profet. ");
INSERT INTO ztp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Zyasa mkab xaꞌ, nchab xaꞌ: —Naꞌnyed náꞌ cho mtelꞌ Juan. ");
INSERT INTO ztp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Zyasa mkab Jesus lo xaꞌ nchab: —Taga' na naꞌtejta na cho mdaꞌ yalnyebeꞌ lon lin re jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Zyasa mdaꞌ Jesus tedib kwent nagan lo men, nchab Jesus: —Ngo thi mbiꞌ jwanꞌ mblo bin lus ub, nde mtan'no xa'y kwent rol lo ya' men sa kenap mena. Nde mbroꞌ xaꞌ nda xaꞌ tij bro tyemp. ");
INSERT INTO ztp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Senꞌ ngol tyemp dyop jwan' ngok, mtelꞌ xaꞌ biꞌ ya thi mos xaꞌ, sa ya naꞌb mos rol kosech jwanꞌ ndinꞌ kayaꞌ xaꞌ, lo xaꞌ ta ngenapa, per re xaꞌ ngenapa mdin xaꞌ mos nde tatanya mos mblo ned xaꞌ mos, ndya mos. ");
INSERT INTO ztp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Xisa mtelꞌ xaꞌ tedib mos, per noga mos ya mtoti xaꞌ, mdin xaꞌ mos nde mbloꞌs xaꞌ mos, ngen kwan mdayaꞌ xaꞌ lo mos, tatanya mos mbloned xaꞌ mos. ");
INSERT INTO ztp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Zyasa le' xwanꞌ lus ub bere mtelꞌ mbyon mos, per re xaꞌ ngenap lus ub, taga' mdin xaꞌ mos, nde mbloꞌte xaꞌ mos lo izyo tenꞌ nzo lus ub. ");
INSERT INTO ztp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Zyasa, xaꞌ nak xwanꞌ lus ub mbli xaꞌ xgab: ꞌꞌ¿Kwan lin naya? Telꞌ na xinꞌ na jwanꞌ nkeꞌ toz lazoꞌn, ta'da senꞌ wiꞌ xa' or txoꞌbyek xaꞌ or.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per senꞌ mbwiꞌ re xaꞌ ngenap lus ub, xinꞌ xaꞌ nak xwanꞌ lus ub, nchab xaꞌ lo ta xaꞌ: ꞌꞌOr reꞌ yan'no reta jwanꞌ nak chanꞌ xud or, kuj naꞌ or, sa jwan' ndin' or, na' yan'noy.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nde mbloꞌte xaꞌ or tenꞌ nzobin lus ub nde mbij xaꞌ or. Zyasa mna'bdi's Jesus: —¿Cho xgab ndli goꞌ?, ¿kwan lino xaꞌ nak xwanꞌ lus ub re xaꞌ ya? ");
INSERT INTO ztp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yeꞌd xaꞌ nde kuj xaꞌ reta xaꞌ ngenap lus ub, nde taꞌ xa' lus ub kenap xaꞌga men. Senꞌ mbin re xaꞌ nzi tya jwanꞌ reꞌ, nchab xaꞌ: —¡Ta nathoza lon' tez ta yatey! ");
INSERT INTO ztp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Per Jesus mbwiꞌ lo xaꞌ, nde nchab: —¿Xamod nak jwanꞌ nchab lo xkiꞌs Dios? Leꞌ ke jwanꞌ ta mblo'tal re xaꞌ ntaꞌ yo, ke ya ngolal ke jwanꞌ mas ntak, ");
INSERT INTO ztp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Achoja men ryoꞌndaꞌb xis ke ya, tas men, nde tez ke gab xis men, toꞌy men. ");
INSERT INTO ztp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Zyasa re xaꞌ nyebeꞌ lo re nglweyꞌ nde re xaꞌ nak maestr nchak ley, ncholaꞌs xaꞌ tyen xaꞌ Jesus or yaga, tak mbyen xaꞌ ke reta kwent ta mdaꞌ Jesus xis xaꞌ ndey. Per naꞌngakta nden xaꞌ Jesus tak nzyeb xaꞌ re men nzi tya. ");
INSERT INTO ztp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Zyasa re xaꞌ ya, mtelꞌ xaꞌ pla men sa ya laꞌs xaꞌ, nde li xaꞌ xaja men wena, sa li xaꞌ ni Jesus diꞌs naꞌleda, sa toyal keꞌ xaꞌ yalke yek Jesus nde toyal tayaꞌ xa' Jesus lo gobernador. ");
INSERT INTO ztp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Zyasa mnabdiꞌs xaꞌ lo Jesus, nchab xaꞌ: —Maestr, mne náꞌ ke re jwanꞌ nia nde re jwanꞌ ndloꞌa naka jwanꞌ li nde nambit la men, galꞌ ndloꞌa xkiꞌs Dios lo men. ");
INSERT INTO ztp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ptej lo náꞌ ¿Cho ndablo kix naꞌ tmi low lo Cesar o nandablode kix naꞌy? ");
INSERT INTO ztp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per Jesus mnela xgab narax ndli xaꞌ, nchab Jesus lo xaꞌ: —¿Kwan liy sa nchola's goꞌ tokan go' na? ");
INSERT INTO ztp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Bloꞌ goꞌ thi tmi lon. ¿Cho lo xa' nde cho le xa' ta nge lo tmi ba? Zyasa mkab xaꞌ, nchab xaꞌ: —Lo Cesar nde le Cesar nge lo neꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Zyasa nchab Jesus lo xaꞌ: —Ptaꞌ goꞌ lo Cesar jwanꞌ nak chanꞌ Cesar nde ptaꞌ goꞌ lo Dios jwanꞌ nak chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nde naꞌnzalta xaꞌ thi di's xamod ngala Jesus, cheꞌla nzoyen xaꞌ lo jwanꞌ mkab Jesus nde xe mbre xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Zyasa mbike pla xaꞌ Saduseo, jwanꞌ mbez ke nandryoꞌxbanta men ngujla tib gob; por jwanꞌ nasa ngwa nabdiꞌs xaꞌ lo Jesus nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestr, Moises mkeꞌ lo yes: Tez thi xaꞌ biꞌ ndob ngol naꞌ gaj xaꞌ nde ngenta xinꞌ xaꞌ, leꞌga wes thabol ndablo ka ngol sal' thabol, sa gal or bix nde or bix ya, ak xinꞌ wes or jwanꞌ ta nguja. ");
INSERT INTO ztp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wiꞌ nea, ngo thi xaꞌ gaz wes xaꞌ, xaꞌ nera mselyaꞌ, per nguj xa', nde ngenta xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Leꞌ wes xaꞌ or yenꞌ jwanꞌ nde xis xaꞌ, mselyaꞌno ngol ta nguj sal' na'ya nde taga' ngalta xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nde taga' or mbyon, mselyaꞌnor ngol nguj sal' na ya, per taga' ngenta xinꞌ or, nde taga' mbli temas wes or mselyaꞌnor ngol nguj sal' na' ya, per re gaz wes or nguj nde ngenta xinꞌ nek thib or. ");
INSERT INTO ztp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lulka no ngol ya nguj. ");
INSERT INTO ztp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mbay senꞌ ryoꞌxban re xaꞌ nguj, ¿Xanya xaꞌ ak salꞌ ngol ya, tez re gaz wes xa' mdobno ngol? ");
INSERT INTO ztp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus nchab lo xa': —Re men lo izyo reꞌ, re xaꞌ biꞌ nde re ngol nselyaꞌ xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per re xaꞌ jwanꞌ nzalꞌ ryoꞌxban lo yalguj sa gal xa' tedib izyo, naꞌselyaꞌtra xaꞌ, nde naꞌyotra yalselyaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tak naꞌgajtraꞌ xaꞌ. Tak xaja re anj chanꞌ Diosa nak xaꞌ nde xinꞌ Dios nak xaꞌ lo mbroꞌxban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nde axta Moises ndloꞌ, ke re xaꞌ nguj ndryoꞌxban, ma tenꞌ nda'y kwent nchol yabxi'd, tya mni Dios lo Moises nchab: Na nak Dios chanꞌ Abraham, Dios chanꞌ Isaac nde Dios chanꞌ Jakob. ");
INSERT INTO ztp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nde Dios nanakta Dios chanꞌ re xaꞌ nguj, Dios nak chanꞌ re xaꞌ naban, tak par Dios reta men naban ");
INSERT INTO ztp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Zyasa pla maestr nchak ley, nchab lo Jesus: —Maestr, jwin thoz mkab la. ");
INSERT INTO ztp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nde ngentra cho xa' ngoyek na' nabdi's lo Jesús. ");
INSERT INTO ztp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Zyasa mnabdiꞌs Jesus lo re men: —¿Kwan liy mbez men Crist nde lo bin David? ");
INSERT INTO ztp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nde leꞌga David mkeꞌ lo libr chanꞌ Salmos, tenꞌ nchab: Dios nchab lo Xaꞌ Nyebeꞌ lon: ꞌꞌPtob lad ban na, ");
INSERT INTO ztp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Axta kebeꞌ lin sa re xaꞌ nayiꞌ loa ak xis jwanꞌ tyobnia.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Xamod ye'd Crist lo bin David, tez le'ga' David mbez lo Xa', Xaꞌ Nyebeꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nde nzi yon reta men senꞌ nchab Jesus lo re xin'te'd Xaꞌ ");
INSERT INTO ztp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Pkenap lazoꞌ goꞌ lo re maestr nchak ley, jwan' nak xa', ndyen xaꞌ gok xaꞌ lar nolꞌ, nde ndyen xaꞌ nawe ni men dyux lo xaꞌ lo xbiꞌ. Nde nkwanꞌ xaꞌ tyob xaꞌ ten' ndyob re men ntak lenꞌ yo tenꞌ ndyop xaꞌ Israel, ndyen xa' tyob xa' tenꞌ ndyob re men ntak ten' ncho yalwa. ");
INSERT INTO ztp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nkib xaꞌ liz re ngol nguj sal' na', nde sa naꞌlo'd re jwanꞌ ndli xaꞌ, bro toz ndyodi'sno xaꞌ Dios. Re xaꞌ ya mas naro pen ya xa'. ");
INSERT INTO ztp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lo ndo Jesus yodoꞌ, mblit lo xaꞌ mbwiꞌ xaꞌ, xa ngo re xaꞌ rik tmi lenꞌ yin ncho tmi yon, ");
INSERT INTO ztp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","nde mbwiꞌ Jesus noga' thi ngol prob nguj sal' na', mblo chop tmi cobr lenꞌ yin ncho tmi yon. ");
INSERT INTO ztp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Zyasa nchab Jesus: —Nipa na lo goꞌ, le' ngol prob ta nguj sal' na' reꞌ, mdaꞌ mas broy ke lo reta xaꞌ mdaꞌ tmi, ");
INSERT INTO ztp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","tak reta men ndaꞌ tmi gon lo jwanꞌ ndryoxoꞌb lo xaꞌ, per ngol re' tenye lo ta prob xa', mdaꞌ xaꞌ reta tmi jwanꞌ nden xaꞌ par wa xa'. ");
INSERT INTO ztp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nde pla men nzi taꞌ kwent chanꞌ yodoꞌ, ndej xaꞌ re ke nawetoz nya ndaꞌ xna lo yodoꞌ nde re jwanꞌ yon mdaꞌ men mdoxkwaꞌ yodoꞌ. Zyasa nchab Jesus lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Reta ke nawe nya ndo wiꞌ goꞌ naya, sin tib wiz senꞌ naꞌyanꞌta nek thib ke reꞌ xis ta ke, retay yub. ");
INSERT INTO ztp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zyasa mnabdiꞌs xa' lo Jesus: —Maestr, ¿Pol ak re jwanꞌ reꞌ? ¿Cho kwan loꞌ, lo sen' mbyentir ak re jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus nchab: — Ndawi' toz goꞌ, naꞌkwinꞌno xaꞌ goꞌ, tak naꞌr xaꞌ yeꞌd nde lirsinꞌ xaꞌ len, nye xaꞌ: ꞌꞌNa nak xaꞌ mtelꞌ Diosꞌꞌ; ꞌꞌse mzin wiza.ꞌꞌ Per naꞌtyonked goꞌ xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nde senꞌ gon goꞌ nzo re byo nde re mayez yache yo kon re xa' nak sin', naꞌzyebta goꞌ, tak nakinꞌ ner re jwanꞌ reꞌ rid, per benꞌ teraꞌ sin lulka wiz. ");
INSERT INTO ztp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nde noga' nchab Jesus: —Thi yez keꞌ byo kon tediba' yez nde thi rey ke' byo kon tediba' rey. ");
INSERT INTO ztp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Zyasa naꞌr ten' win re xo toz, yo win nde ye'dbe re yis ngoꞌ, nde lo beꞌ yo re jwanꞌ nathoz, nde loꞌ re jwanꞌ naro ak lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Per senꞌ teraꞌ ak re jwanꞌ reꞌ, tyen men goꞌ, chubla xaꞌ goꞌ, we xaꞌ goꞌ lenꞌ yo tenꞌ ndyop xaꞌ Israel, nde we xaꞌ goꞌ lo re xaꞌ nak rey nde lo re xaꞌ nyebeꞌ yolow, ko xaꞌ goꞌ lizyiꞌb, kwent ndli lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tamod sa jwanꞌ reꞌ li sa tej goꞌ xkiꞌs na lo xa'. ");
INSERT INTO ztp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nde naꞌlid goꞌ xgab kwan kab goꞌ lo xaꞌ yolow, senꞌ ndo goꞌ lo xaꞌ, sa lya' go', ");
INSERT INTO ztp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tak na ta re di's nde yalnchak lo go' kab go', jwan' nek thib xa' jwan' ngi'no go' nalid xa' gan tow' xa' lo xki's go', nde nekla zyal ten' tyobro xa'. ");
INSERT INTO ztp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Per leꞌga xud goꞌ, leꞌga wes goꞌ, leꞌga ta goꞌ, nde leꞌga re xaꞌ nsal'ta goꞌ, tayaꞌ xaꞌ goꞌ nde kuj xaꞌ pla goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Reta men yiꞌno xaꞌ goꞌ, tak ndli lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per nek thib yisyek goꞌ ngen kwan tyak. ");
INSERT INTO ztp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Btoli xgab goꞌ ne pto goꞌ, sa gal goꞌ yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Per senꞌ wiꞌ goꞌ mzalꞌ sondad dib yez Jerusalen, zyasa mne goꞌ se mzin wiz lux yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Zyasa re xaꞌ nzo lo xyon Judea xyonꞌ xaꞌ ya xaꞌ re yiꞌ, nde re xaꞌ nzo lenꞌ yez, ryoꞌte xaꞌ tya nde re xaꞌ nzo wan naꞌyad xaꞌ lenꞌ yez. ");
INSERT INTO ztp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tak wiz ya nye xa' pen toz, sa ak reta jwanꞌ xa nchab lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nde wiz ya nalat toz yate re ngol jwanꞌ ndo lo yistan, nde re ngol jwanꞌ ngeno re mbed mey jwanꞌ nchuꞌ nis, tak pen toz rid reta men yez ya tak xyan chanꞌ Dios nde xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Zyasa bro men gaj lo byo, nde ti pla men we xaꞌ lizyiꞌb dib nax izyo, nde re xaꞌ nandlid lazoꞌn xkiꞌs Dios, nyebeꞌ xaꞌ yez Jerusalen axta senꞌ yaxoꞌb wiz taꞌ Dios diꞌs ak reta jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Zyasa loꞌ re jwanꞌ nathoz nya lo wiz, lo mbeꞌ nde lo re mbel lo beꞌ. Reta men nzo lo izyo gan yek men, nde jwanꞌ toz zyeb re men por nathoz toz tyez re bi nittoꞌ nde re bde nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nde re men axta kow xaꞌ zyeb xaꞌ, senꞌ li xaꞌ xgab re jwanꞌ ak lo izyo, tak re jwanꞌ nzi lo beꞌ win na. ");
INSERT INTO ztp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Zyasa wiꞌ goꞌ Xin' Mbi', yeꞌd xa xij xkow kon yalne nde kon xni ro thoz. ");
INSERT INTO ztp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Senꞌ tyobte ak re jwanꞌ reꞌ, blit yek goꞌ nde blone lazoꞌ goꞌ, tak mbyentirla lyaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Zyasa mdaꞌ Jesus thi kwent nagan, nchab Jesus: —Bwiꞌ goꞌ ya hig, o lo xaga' ya. ");
INSERT INTO ztp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Senꞌ ngwiꞌ goꞌ ndoroꞌ la yenꞌ na, mne goꞌ ndo sin gaxla beꞌ yi. ");
INSERT INTO ztp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tagaꞌ, senꞌ wiꞌ goꞌ ndoyak re jwanꞌ reꞌ, mne goꞌ ndo sin gax yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nipa na lo goꞌ ke naꞌgajta men nzo naya, axta ke ak reta jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Beꞌ nde izyo tluxa per xkiꞌs na naꞌluxtay. ");
INSERT INTO ztp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pkenap go' lazoꞌ goꞌ lo re jwanꞌ narax nzo lo izyo reꞌ, lo yalguy, lo re jwan' nda' xgab yek go', sa list nzi go' sen' sin wiz ya. ");
INSERT INTO ztp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tak wiz ya yeꞌd xaja ti koꞌ xis reta men nzo lo izyo reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jwanꞌ nasa bresaꞌ goꞌ, nde thibla btodi'sno go' Dios, sa ne nzo lazoꞌ goꞌ lo lyaꞌ goꞌ lo re jwanꞌ ak nde sa li goꞌ gan tyoli goꞌ lo Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dib ndlyabe ndloꞌ Jesus xkiꞌs Dios lo men lo len yodoꞌ, leꞌ senꞌ ndlya yalꞌ nda Jesus yiꞌ ni xaꞌ Oliv, tya nchanꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nde tilꞌ toz nda re men lo len yodoꞌ, sa gon xaꞌ xkiꞌs Dios ndloꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Senꞌ ndo sin gaxla ni jwanꞌ ncha xaꞌ pan nanchod lebadur, ni ya ndole Pask. ");
INSERT INTO ztp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Leꞌ re nglweyꞌ jwanꞌ nyebeꞌ, nde re maestr nchak ley, nkwanꞌ xaꞌ xamod kuj xaꞌ Jesus, tak nzyeb xaꞌ re ma yez. ");
INSERT INTO ztp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Zyasa mbla Maxuꞌ lazoꞌ Judas xa' ndole Iscariote, jwanꞌ no nak xin'te'd Jesus ta ndenta re thib sen xa' ya. ");
INSERT INTO ztp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nde ngwa Judas lo re nglweyꞌ jwanꞌ nyebeꞌ nde lo re xaꞌ nyebeꞌ lo re xaꞌ ngenap yodoꞌ, sa todiꞌsno Judas xaꞌ, sa nyenꞌ xamod taꞌyaꞌ Judas Jesus lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nale toz ngo lazoꞌ re xaꞌ, nde nchab xaꞌ taꞌ xaꞌ tmi lo Judas. ");
INSERT INTO ztp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Le' Judas mxeyal nde mdobte xa' mkwanꞌ xa' xamod taꞌyaꞌ xa' Jesus, senꞌ na'ngenta men. ");
INSERT INTO ztp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Senꞌ mzin wiz ncha xaꞌ pan nanchod lebadur, nde wiz ya ndablo kuj xaꞌ mbakxilꞌ yen', par ni pask. ");
INSERT INTO ztp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus mbloned Pedr nde Juan, nchab Jesus lo xaꞌ: —Wa toxkwaꞌ goꞌ jwanꞌ wa rzyenꞌ ni pask. ");
INSERT INTO ztp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Zyasa mnabdiꞌs xaꞌ lo Jesus, nchab xaꞌ: —¿Plo ncholaꞌs la toxkwaꞌ naꞌy? ");
INSERT INTO ztp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus mkab nchab lo xaꞌ: —Senꞌ lya go' lenꞌ yez Jerusalen yosal goꞌ thi xaꞌ biꞌ jwanꞌ neꞌ thi re nzo nit. Ptonke goꞌ xis xaꞌ axta sin goꞌ yo tenꞌ yote xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nde gab goꞌ lo xwanꞌ yo: ꞌꞌLeꞌ Maestr ne: ¿Plo ndob yo tenꞌ wa rzyeꞌn kon re xin'te'd na, rzyeꞌ chanꞌ pask?ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Zyasa loꞌ xaꞌ thi yo ro lo goꞌ, jwanꞌ ndob xtaꞌ gap, nde tya nzila re jwanꞌ nakinꞌ goꞌ, tya ptoxkwaꞌ goꞌ rzyeꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Zyasa ngwa rop xaꞌ nde mzyal xaꞌ retay a xata nchab Jesus lo xaꞌ, nde mtoxkwaꞌ xaꞌ rzyeꞌ par wa xaꞌ ni pask. ");
INSERT INTO ztp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Senꞌ mzin hor wa rzyeꞌ xaꞌ, mdob Jesus kon re thib sen xin'te'd Jesus ro mes. ");
INSERT INTO ztp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Zyasa nchab Jesus lo xaꞌ: —¡Jwanꞌ toz ndonkeꞌn wan rzyeꞌ chanꞌ pask reꞌ kon goꞌ, nal tera riꞌdndaꞌb na yalti! ");
INSERT INTO ztp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tak nin lo goꞌ ke naꞌwartraney tedib gob axta kebeꞌ akpey tenꞌ nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Zyasa mxen Jesus kop nde mdaꞌ Jesus dyux lo Dios, nde nchab Jesus lo xaꞌ; —Bxen goꞌ kop reꞌ guꞌ goꞌy nde bdiꞌd goꞌy lo ta goꞌ; ");
INSERT INTO ztp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tak nin lo goꞌ naꞌgutra na jwan' nda' lus ub, axta kebeꞌ sin wiz nyebeꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mxen na' Jesus pan nde mdaꞌ Xa' dyux lo Dios nde mbli rol Xa' pan nde mda' Xa'y lo re xin'te'd Xa', nde nchab Xa': —Jwanꞌ reꞌ nak belꞌ na, jwanꞌ tayan por goꞌ, bli goꞌ jwanꞌ reꞌ sa telaꞌs goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Senꞌ mne mda rsyeꞌ xaꞌ, mxen Jesus kop nchab Jesus lo xaꞌ: —Kop reꞌ nak nakub mda' Dios xki's Dios, jwan' mblí di's kon ren na, ren jwanꞌ xyo por goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Per naya, yaꞌ xaꞌ jwanꞌ taꞌyaꞌn lo re xaꞌ jwanꞌ ngiꞌno na, yaꞌ xaꞌ ya nzo'b lo mes kon yan'. ");
INSERT INTO ztp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naya leꞌ Xinꞌ Mbiꞌ nakinꞌ riꞌd Xa' xata mbyan'la aka, per ¡Nalat nya xaꞌ jwanꞌ taꞌya' Xa'! ");
INSERT INTO ztp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Zyasa mdobte re xin'te'd Jesus mnabdiꞌs lo re ta xaꞌ, xanya xa' ta li ya. ");
INSERT INTO ztp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zyasa re xin'te'd Jesus, mdobte mdodiꞌs xaꞌ lo ta xaꞌ nchab xaꞌ: \"¿Cho xaꞌ mas ntak?\" ");
INSERT INTO ztp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus nchab: —Re xaꞌ nak rey, nchak naro xaꞌ lo re yalnyebeꞌ ngeno xaꞌ, nde re xaꞌ yolow ncholaꞌs xaꞌ re ma yez xoꞌbyek men xaꞌ, nde re xaꞌ ngeno bro yalnyebeꞌ, ndli xaꞌ sa gab men lo xaꞌ, \"xaꞌ ndla'sto men nak go'.\" ");
INSERT INTO ztp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per goꞌ nandabloda li goꞌ mod ya, che'la xa' mas xa' gox xij go', ndablo ak xa' xaja xa' yen' na, nde xaꞌ jwanꞌ nyebeꞌ nakinꞌ ak xaja xaꞌ ndli sinꞌ lo ta men na'. ");
INSERT INTO ztp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tak ¿Cho mas ntak, cho xaꞌ jwanꞌ ndyob ro mes way o xaꞌ jwanꞌ ngo mesa? ¿Cho na'naktey xa' jwan' ndyob ro mes way? Per na ndo ncheꞌya xaja xaꞌ ngo mes. ");
INSERT INTO ztp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nde goꞌ thibla nzi goꞌ kon na lo re yalti mbriꞌd na. ");
INSERT INTO ztp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jwanꞌ nasa, na ta yalnyebeꞌ lo goꞌ, ta xa mdaꞌ Xud na yalnyebeꞌ lon, ");
INSERT INTO ztp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nde tyob go' ro mes na sa wa go' nde gu goꞌ sen' ndob nyebeꞌn, nde tyob goꞌ tenꞌ ndyob re rey sa koxyo goꞌ re thib sen bin xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Noga' nchab Jesus: —Simon, maxuꞌ mnaꞌb lo Dios sa tokan xaꞌ goꞌ, xaja men mbib triga. ");
INSERT INTO ztp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per na mnaꞌb lo Dios por lu, sa naꞌlat la xkiꞌs Dios jwanꞌ ndli lazoꞌa. Nde lu, senꞌ mberea lon tedib gob, la'stoa temas re men ndli lazonꞌ na sa tyo ne xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Le' Pedr nchab lo Jesus: —Xaꞌ Nyebeꞌ, toyal na yan lizyiꞌb kon lu nde axta gaj na kon lu. ");
INSERT INTO ztp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nde Jesus nchab: —Pedr, na ni loꞌa, leꞌga naya, benꞌ tera kwez ngidteꞌ, mbyonla gob gab la nanzolod la na. ");
INSERT INTO ztp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nde Jesus mnabdiꞌs lo xaꞌ, nchab: —Senꞌ mtelꞌ na goꞌ, nangwed go' tmi neka bed, neka tedib ned yalyid goꞌ, ¿cho ngok jwad jwanꞌ nakinꞌ goꞌ zya? Zyasa mkab re xaꞌ: —Ngen kwan ngok jwad lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Zyasa nchab Jesus lo xaꞌ: —Per naya, xaꞌ jwanꞌ ngeno bed, che' ndablo we xaꞌy, nde taga' xaꞌ nden tmi we xaꞌy, nde xaꞌ jwanꞌ nangenoda espad, ndablo tho xaꞌ chamar xaꞌ sa tiꞌ xaꞌ thiba. ");
INSERT INTO ztp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tak nin lo goꞌ, nakinꞌ ri'd na reta jwanꞌ nchab lo xkiꞌs Dios, tenꞌ nchab: \"mblino xaꞌ xaꞌ, xaja thi xaꞌ jwanꞌ mbli jwanꞌ naraxa.\" Tak ndablo ri'd na reta jwan' nchab lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Zyasa nchab xaꞌ lo Jesus: —Xaꞌ nyebeꞌ, ncheꞌ nzo chop espad. Jesus mkab: —Naꞌtodisꞌta naꞌ jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nde mbroꞌ Jesus nda Jesus yiꞌ Oliv tenꞌ nchaga Jesus, nde re xin'te'd Jesus mdonke xa' xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Senꞌ mzin Jesus tya, nchab Jesus lo xaꞌ: —Mnaꞌb goꞌ lo Dios sa naꞌtokanta maxuꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Zyasa mbike Jesus tib lad, xapa tenꞌ nzin thi ke ta ngobi mena, nde tya mdoxub Jesus sa todiꞌsno Jesus Dios. ");
INSERT INTO ztp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nde nchab Jesus: —Xud na, tez ncholaꞌs la, ptola'n lo re yalti toz reꞌ, per nagaktey xa ncholas na, aka xa ncholaꞌs la. ");
INSERT INTO ztp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Zyasa mbroꞌto thi anj mbro' lo be', mblo ne lazoꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nde lo ta nabil toz nzo lazo' Jesus, masra dib fwerz Jesus mnaꞌb Jesus lo Dios. Nde lon jwan' ndryo' lo Jesus xaja zun' rena nchaba izyo. ");
INSERT INTO ztp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Senꞌ mne mdodiꞌsno Jesus Dios mdoli Jesus, nda Xaꞌ tenꞌ nzi re xin'te'd Xaꞌ, nde ngosi'b Xa' reta xin' te'd Xaꞌ nziyat, tak nabil toz nzo lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Zyasa nchab Jesus lo xaꞌ: —¿Kwan ndliy nziyat goꞌ? Goche goꞌ nde mnaꞌb goꞌ lo Dios, sa na'ganta xgab goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tata benꞌ ndotodiꞌs Jesus, senꞌ mzin bro toz men. Nde xaꞌ jwanꞌ ndole Judas, xa' jwanꞌ nak ta thib sen xin'te'd Jesus, nda siblo lo reta men. Zyasa mbike Judas gax lo Jesus nde mda Judas chut kwat Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","per Jesus nchab: —Judas, ¿cho kon thi chut taꞌyaꞌa Xinꞌ Mbiꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Senꞌ mbwiꞌ re xaꞌ nzino Jesus re jwanꞌ ndoyak, zyasa mnabdiꞌs xaꞌ lo Jesus nchab xaꞌ: —Xaꞌ Nyebeꞌ, ¿cho ndablo keꞌ naꞌy cho xaꞌ kon espad? ");
INSERT INTO ztp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nde thib xaꞌ jwanꞌ nzino Jesus, mpchoꞌ nza ban thi xaꞌ nak mos nglweyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zyasa nchab Jesus lo xaꞌ: —Blaꞌ goꞌ xaꞌ, baja mney. Nde mbwal Jesus nza mos nde mtodanꞌ Jesus nza xa'. ");
INSERT INTO ztp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zyasa nchab Jesus lo re nglweyꞌ jwan' nyebe' nde re xaꞌ nyebeꞌ lo re xaꞌ nkenap yodoꞌ nde lo re xaꞌ gox jwanꞌ nde sa we xa' Jesus: —¿Goꞌ nde kon espad nde kon ya, sa tyen goꞌ na xaja ndyen men thi xaꞌ wanꞌ na? ");
INSERT INTO ztp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Senꞌ reta wiz mbrenon goꞌ lo len yodoꞌ, nde naꞌndenta goꞌ na. Per naya nak hor chanꞌ goꞌ, tyen goꞌ na, tak naya nde yalne chanꞌ yalꞌkow. ");
INSERT INTO ztp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Zyasa mxen xaꞌ Jesus nde mbeꞌ xaꞌ Jesus liz nglweyꞌ ro. Nde Pedr tij, tij, ndanke xisa. ");
INSERT INTO ztp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nde mtolꞌ xaꞌ ki xtowꞌ lo le, nde mdob xaꞌ dib ro, nde no Pedr mdob xij xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Zyasa thi ngol ndli sin' yo, lo mbwiꞌ ngol ndob Pedr tenꞌ ndoyol ki, xe mbwiꞌ ngol lo Pedr, nde nchab ngol: —No xaꞌ biꞌ reꞌ mketenke xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per Pedr mka's, nde nchab: —Ngol, nanzolot na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tudla ndate mbwiꞌ tediba xaꞌ Pedr nde nchab xaꞌ: —Noa nak thi men Jesus. Pedr mkab, nchab: —Naktey na. ");
INSERT INTO ztp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mbriꞌd thib hor pa, tediba xaꞌ nchab: —Gal' di's no xaꞌ reꞌ ndo kon Jesus, tak xaꞌ yez Galilea xa'. ");
INSERT INTO ztp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Per Pedr nchab: —Naꞌnyet na kwan ndej goꞌ. Nde tata benꞌ ndotodiꞌs Pedr, mbrez ngidteꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zyasa mbyek Jesus mbwiꞌ Jesus lo Pedr, nde mtelaꞌs Pedr jwanꞌ nchab Jesus lo Pedr: Ben' tera' kwez ngidteꞌ, mbyonla gob gab la nanzolod la na. ");
INSERT INTO ztp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Zyasa mbroꞌte Pedr tya, nde jwanꞌ toz nabil mbinꞌ Pedr. ");
INSERT INTO ztp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nde re xaꞌ jwanꞌ ngenap Jesus, nxino xaꞌ Jesus nde ngin xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nde mtowꞌ xaꞌ ngudlo Jesus, mke' xa'y lo Jesus nde mnabdiꞌs xaꞌ lo Jesus nchab xaꞌ: —Tez naye'a, ptej cho mkeꞌy choa! ");
INSERT INTO ztp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nde anta che'pa naxin mbrez xaꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Senꞌ mduxni tedib wiz, mketa reta xaꞌ gox jwanꞌ nyebeꞌ lo xaꞌ Israel, re nglweyꞌ jwanꞌ nyebeꞌ nde re maestr jwanꞌ nchak ley, mbeꞌ xaꞌ Jesus lo junt chanꞌ re xaꞌ ngeno yalnyebe' ro. Tya mnabdiꞌs xaꞌ lo Jesus: ");
INSERT INTO ztp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Ptej lo náꞌ, ¿Cho lu nak Xaꞌ mtelꞌ Dios? Jesus, nchab: —Tez nin lo goꞌ, nay, pa li lazoꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nde tez nyaꞌbdiꞌs na lo goꞌ, pa kab goꞌ lon, neka laꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per naya leꞌ Xinꞌ Mbiꞌ, tyob lad ban Dios jwanꞌ ngeno reta yalnyebeꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Zyasa reta xaꞌ mnabdiꞌs lo Jesus, nchab xa': —¿Cho lu nak Xinꞌ Dios? Jesus mkab: —Mne go' sa wi', le'ga goꞌ ndotej ke nay. ");
INSERT INTO ztp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Zyasa nchab xaꞌ: —¿Wenraꞌ na' kwanꞌ naꞌ men tej lonꞌ nchap Xaꞌ yalke? Yub naꞌ mbin ke le'ga ro Xaꞌ mbroꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Zyasa mdoli reta xaꞌ, nde mbeꞌ xaꞌ Jesus lo Pilat. ");
INSERT INTO ztp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nde mdobte mkeꞌ xaꞌ yalke yek Jesus, nchab xaꞌ: —Mbi' re' ngoga lo náꞌ, ngetoxol Xa' re men las náꞌ. Mbez Xaꞌ lo men, nandabloda kix náꞌ tmi low lo Cesar, nde mbloꞌro Xaꞌ, mbez Xaꞌ, le' Xaꞌ nak Xaꞌ mtelꞌ Dios, nde rey nak Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Zyasa mnabdiꞌs Pilat lo Jesus, nchab: —¿Cho lu nak Rey lo re xaꞌ Judi? —Jesus mkab, nchab: —Le'ga lu ndoteja. ");
INSERT INTO ztp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Zyasa nchab Pilat lo re nglweyꞌ jwanꞌ nyebeꞌ nde lo re men nzi tya. —Nekthib yalke naꞌnzalta na nchap mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per mas ne ro re xaꞌ, nchab xaꞌ: —Nyaga ndli xa' nchak xol' reta men dib Judea, xata mdobte Xa' axta Galilea nde naya axta nche' ngoxob Xa' ngetote'd re men. ");
INSERT INTO ztp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Senꞌ mbin Pilat jwanꞌ reꞌ, zyasa mnabdiꞌs Pilat nchab Pilat: —¿Cho xaꞌ Galilea mbiꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nde senꞌ mbin Pilat ke Jesus nak xaꞌ yez tenꞌ nyebe' Herodes, zyasa mtelꞌ Pilat Jesus lo Herodes, tak lenꞌ wiz ya noga Herodes mbya yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Senꞌ mbwiꞌ Herodes Jesus, jwanꞌ toz ngo nale lazoꞌ xa', tak ndala ncholaꞌs xa' wiꞌ xa' Jesus, tak nchon xa' nda' men kwent chan' Jesus nde ndombed xa' wiꞌ xa' li Jesus thi yalnaro. ");
INSERT INTO ztp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Zyasa mnabdiꞌs Herodes naꞌr jwanꞌ lo Jesus, per ngen kwan nkab Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Re nglweyꞌ jwanꞌ nyebeꞌ nde re maestr nchak ley ta nzi tya, anega ndo xa' ngeke' xa' yalke yek Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Zyasa Herodes nde kon re sondad xaꞌ, mblotal xaꞌ Jesus nde par xiꞌno xaꞌ Jesus mbwok xaꞌ Jesus thi lar wen nde bere mtelꞌ Herodes Jesus lo pilat tedib gob. ");
INSERT INTO ztp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nde lenꞌ wiz ya bere mzalꞌta Pilat kon Herodes tedib gob, tak mas pola nanzal'ta xki's rop xa'. ");
INSERT INTO ztp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Zyasa mbrez Pilat re nglweyꞌ jwanꞌ nyebeꞌ, re xaꞌ ngeno yalnyebeꞌ nde re ma yez, ");
INSERT INTO ztp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nde nchab Pilat lo xaꞌ: —Goꞌ ndeno mbiꞌ re lon, mbez goꞌ xaꞌ ntoxol re men, per naya nzi wiꞌ goꞌ mnabdiꞌs na lo xaꞌ, nde naꞌyosalta na nek thib yalke jwanꞌ nkeꞌ goꞌ yek xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nde noga' Herodes naꞌngazalta xa' nek thib yalke mbli mbiꞌ reꞌ, jwanꞌ nasa mzire Herodes xaꞌ lon tedib gob. Per ngen cho jwanꞌ narax mbli mbiꞌ reꞌ par gaj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Senꞌ mne mdin na Xa', lan Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nde reta lin' len' ni, nakin' la' xa' thi xa' jwan' nge lizyi'b. ");
INSERT INTO ztp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Zyasa reta xaꞌ nzi tya mdobte ne toz mbrez xaꞌ, nchab xaꞌ: —¡Blaꞌ diꞌs gaj mbiꞌ reꞌ nde blaꞌ Barrabas! ");
INSERT INTO ztp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tak Barrabas nge lizyiꞌb kwent mtoxol xaꞌ men xis xaꞌ nak sin' nde mbij xaꞌ thi men. ");
INSERT INTO ztp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Per Pilat mni lo xaꞌ tedib gob, tak Pilat ncholaꞌs laꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nde reta men masra ne toz mbrez xaꞌ, nchab xaꞌ: —¡Pkeꞌ Xaꞌ lo cruz! ¡Pkeꞌ Xaꞌ lo cruz! ");
INSERT INTO ztp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Zyasa ngo xob mbyon gob mni Pilat lo xaꞌ nchab: —Per ¿cho jwanꞌ narax mbli mbiꞌ reꞌ? Naꞌyozalta na nek thib jwanꞌ narax mbli Xaꞌ sa gaj Xaꞌ. Senꞌ mne mdin na Xa', lan Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per re men ne ro xaꞌ masra' ne toz mbrez xaꞌ, mnaꞌb xaꞌ sa keꞌ Pilat Jesus lo kruz, nde por lo ne toz mbez xaꞌ, mbli xaꞌ gan, mbli Pilat jwanꞌ ncholaꞌs xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Zyasa mnebeꞌ Pilat ak axaja ncholaꞌs re xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Zyasa mdaꞌ Pilat di's mbroꞌte Barrabas, xaꞌ jwanꞌ nge lizyiꞌb kwent mtoxol' xa' re men xis xaꞌ nak sin' nde mbij xaꞌ men nde mdayaꞌ Pilat Jesus axaja ncholaꞌs re xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Senꞌ mbeꞌ xaꞌ Jesus sa keꞌ xaꞌ Jesus lo kruz, zyasa thi xaꞌ yez Cirene ndole Simon, jwanꞌ ndobere ndya ngwa sin', mnibeꞌ sondad lo xaꞌ mxoꞌbyen xaꞌ kruz, mbeꞌ xaꞌy nde ndanke xaꞌ xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nde men toz ndanke xis Jesus nde re ngol jwanꞌ toz tir mbez ngol nchonꞌno ngol Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per Jesus mbwiꞌ lo re ngolꞌ nde nchab Jesus: —Men got yez Jerusalen, naꞌgonod goꞌ na, che'la leꞌga goꞌ bin'no go' nde bin'no re xinꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tak tsin wiz senꞌ gab men: ꞌꞌWen nda re ngol jwanꞌ na'nkeloda xinꞌ naꞌ nde re ngol jwanꞌ namxanta mbed, nekla mdaꞌ nis nguꞌ mbed.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Zyasa tyobte gab re men re lo yiꞌ: ꞌꞌGob xis náꞌ,ꞌꞌ nde lo re kox, ꞌꞌBwot xis náꞌ.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tez ta ndlino xaꞌ ya yeba, ¿cho leta ya bis, xa lino xa'y? ");
INSERT INTO ztp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nde noga mbeꞌ xaꞌ chop xaꞌ xkap, sa thita kuj xa' xa' kon Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Senꞌ mzin xaꞌ tenꞌ ndole \"Zij yek men,\" tya mkeꞌ xaꞌ Jesus lo kruz, nde kon rop xaꞌ xkapa: thib xaꞌ mkeꞌ xaꞌ lad ban Jesus nde tedib xaꞌ mkeꞌ xaꞌ lad beg Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Zyasa nchab Jesus: —Xud na, btonꞌ xken xaꞌ, tak naꞌnyed xaꞌ jwanꞌ ndli xaꞌ. Nde re sondad, mblibe' xaꞌ xis xab Jesus sa nyenꞌ xanya xaꞌ ndinꞌ yan'noy. ");
INSERT INTO ztp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nde men nzi tya nzi wiꞌ xa', nde axta re xaꞌ nyebeꞌ yolow nxino xaꞌ Jesus nchab xaꞌ: —Mtola' Xaꞌ xaꞌga re men, xa na'naya tolaꞌ Xaꞌ leꞌga leꞌ Xaꞌ, tez lipa nak Xaꞌ, Xaꞌ mtelꞌ Dios nde Xaꞌ mblí Dios. ");
INSERT INTO ztp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Noga re sondad nxino xaꞌ Jesus nde mbike xaꞌ gax tenꞌ nge Jesus sa taꞌ xaꞌ nit ub ni gu Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nde nchab xaꞌ lo Jesus: —¡Tez lu nak Rey lo re xa' judi, le' ptolaꞌ lazo'a. ");
INSERT INTO ztp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nde mkeꞌ xaꞌ thi letr a'yek Jesus, jwan' nge diꞌs grieg, diꞌs latin nde diꞌs hebreo, nchab: ꞌꞌXAꞌ REꞌ NAK REY LO RE XAꞌ JUDI.ꞌꞌ ");
INSERT INTO ztp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nde thib xaꞌ xkap nge lo cruz cho Jesus mnixin xaꞌ lo Jesus, nchab xaꞌ: —Tez nak la xaꞌ mtelꞌ Dios, le' ptolaꞌ lazo'a nde btolaꞌ náꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Le' tedib xaꞌ xkap jwanꞌ nge tedib lad cho Jesus, mbrez xa' yek ta xa': —¿Cho nanzyebta la Dios, ta thita yalti ndoriꞌd re yon naꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Per rop naꞌ nzal'ka na' rid naꞌ re yalti reꞌ, por re jwanꞌ narax mbli naꞌ; per mbiꞌ reꞌ namblid Xaꞌ nek thib jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Zyasa nchab xaꞌ lo Jesus: —Jesus, telaꞌs la na senꞌ tyobtea nyebeꞌa. ");
INSERT INTO ztp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus mkab lo xaꞌ: —Nipa na loa, thita kwen' lo beꞌ na wiz. ");
INSERT INTO ztp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nde a rolja wiz mbla yalꞌkow dib izyo, axta hor mbyon bzyeba. ");
INSERT INTO ztp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nde mdo' wiz, nde lar jwanꞌ nge len' yodoꞌ, a rolja mcheda ngok chop ley. ");
INSERT INTO ztp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zyasa ne mbrez Jesus, nde nchab Jesus: — Xud na, lo ya'a tayan xbin na. Nde senꞌ mne nchab Jesus jwanꞌ reꞌ, nguj Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Senꞌ mbwiꞌ xaꞌ nyebeꞌ lo re sondad jwan' ngok, mblinaro xaꞌ le Dios, nde nchab xaꞌ: —Lipa mbiꞌ reꞌ ngok Xaꞌ thi mbi' gal'. ");
INSERT INTO ztp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nde reta men jwanꞌ nzi tya, mbwiꞌ xaꞌ reta jwanꞌ ngok, mbere xa' yez, nginya' xaꞌ lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Le' re xaꞌ jwanꞌ ncholo Jesus, nde re ngol jwanꞌ xata jwan' mdonke xis Jesús xata mbro' xa' Galilea, tij mbre re xa' mbwi' xa' reta jwan'. ");
INSERT INTO ztp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ngo thi mbiꞌ wen nde galꞌ nak ndole Jose, xaꞌ yez Arimatea lo xyon Judea. Nde no xaꞌ nak xaꞌ nyebeꞌ ro lo re xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Per nanda'd ro xaꞌ lo re xaꞌ ta mtoti Jesus, tak xaꞌ ngembed sin yalnyebeꞌ chan' Dios, ");
INSERT INTO ztp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","zyasa ngwa xaꞌ lo Pilat nde mnaꞌb xaꞌ thabol Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Senꞌ ngolo mbla xaꞌ thabol Jesus lo cruz, mchal lar xaꞌ Xa' nde mka's xaꞌ Xa' lenꞌ baꞌ jwanꞌ mdenꞌ xaꞌ lad ke, tenꞌ tera' ga's nek thib men. ");
INSERT INTO ztp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nde wiz ya nak wiz ntoxkwaꞌ xaꞌ jwanꞌ wa xaꞌ lenꞌ wiz ndryoꞌxkwen xaꞌ, nde tud la ndab tyobte wiz ya. ");
INSERT INTO ztp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nde no re ngol jwanꞌ mbro'no Jesus Galilea, mdonke ngol nde mbwiꞌ ngol baꞌ tenꞌ mka's xa' Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Senꞌ mbere re ngol yo, mtoxkwaꞌ ngol aseyt nde pomad naxeꞌ ndyaꞌ. Nde mbroꞌxkwen xaꞌ wiz jwan' ndryoꞌxkwen men Israel, xata nyebeꞌ ley chan' Moisés. ");
INSERT INTO ztp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wiz ner xan' sman, til' toz ngwa re ngol ro baꞌ, nde mbeꞌ ngol re aseyt naxeꞌ jwanꞌ mdoxkwaꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Senꞌ mzin re ngol tya, mbwiꞌ ngol leꞌ ke jwanꞌ ta nowꞌ ro baꞌ ya, mbikey tib lad nde ndoxalꞌ ro baꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","lo senꞌ ngote ngol len' baꞌ naꞌngazalta ngol thabol Jesus Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Le'ka mbli ngol xgab nyed ngol kwan li ngol nde xaj mbwiꞌ ngol chop xaꞌ biꞌ ndoli gax lo ngol, nok lar ndlyabel nya. ");
INSERT INTO ztp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Zyasa jwanꞌ toz mzyeb ngol, nde mbla yek ngol axta mdin' yek ngol izyo, le' rop xaꞌ biꞌ ya, nchab lo ngol: —¿Kwan ndliy nkwanꞌ goꞌ Xaꞌ naban xij xaꞌ nguj? ");
INSERT INTO ztp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ngenta Xaꞌ ncheꞌya, leꞌ Xaꞌ mbroꞌxbanla. Ptelaꞌs goꞌ jwanꞌ ne Xaꞌ lo goꞌ, senꞌ benꞌ nzo Xaꞌ lo xyon Galilea, ");
INSERT INTO ztp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ne Xaꞌ lo goꞌ: Xin' Mbi', nakinꞌ tayaꞌ xaꞌ Xa' lo yaꞌ re xaꞌ nzoꞌb xken naꞌ, nde keꞌ xa' Xa' lo kruz, per senꞌ yaxoꞌb son wiz ryoꞌxban Xa'. ");
INSERT INTO ztp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Zyasa mtelaꞌs ngol re diꞌs jwanꞌ nchab Jesus, ");
INSERT INTO ztp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","nde senꞌ mbere ngol ngwa ngol ro baꞌ, zyasa mdej ngol reta jwanꞌ ngok lo re siꞌbthib xin'te'd Jesus nde lo temasra' men. ");
INSERT INTO ztp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nde re xa' ya nak Mari Magdalen, ngol ndole Juan, Mari xnaꞌ Jakob, nde tipla ngol. ");
INSERT INTO ztp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per re xin'te'd Jesus, mbli xaꞌ xgab mdya'b yek ngol lo ta ndyodi's ngol, nde naꞌndlid lazoꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Le' Pedr zyaga ngwa karel ngwa wiꞌ ro baꞌ; nde senꞌ mbwiꞌ Pedr lenꞌ baꞌ, benꞌta lar jwanꞌ mchal Jesus nax tya, zyasa mbere Pedr yo nde jwanꞌ toz nzoyen Pedr jwanꞌ ngok. ");
INSERT INTO ztp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lega wiz ya, chop xin'te'd Jesus, ndo ned nda yez ndole Emaus, nde yez Emaus nchanꞌ chopka hor tenꞌ nax yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nde rop xaꞌ ya ndatodiꞌs xaꞌ reta jwanꞌ ngok. ");
INSERT INTO ztp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nde laj ndatodiꞌs xaꞌ lo ta xaꞌ, Jesus mbike gax lo xa' nde thita nda xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","per mkal ngud lo xa' sa naꞌyolod xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Zyasa mnabdiꞌs Jesus lo xaꞌ nchab Jesus: —¿Cho jwan' taja ndetodiꞌs goꞌ nde kwan ndliy nabil nzo lazoꞌ goꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nde thi xaꞌ jwanꞌ ndole Cleofas, mkab nchab: —¿Cho thita lu xaꞌ thiblad yez Jerusalen naꞌnyet reta jwanꞌ ngok lenꞌ yez Jerusalen na lenꞌ wiz reꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Zyasa mnabdiꞌs Jesus lo xaꞌ: —¿Cho kwan ngok? Le' xaꞌ mkab: —Náꞌ ndetodiꞌs re jwanꞌ ngote Jesus Nazaret, Xaꞌ mtorid xkiꞌs Dios lo men, ngeno Xa' yalne lo re jwan' ndli Xa', lo Dios nde lo reta men. ");
INSERT INTO ztp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nde re nglweyꞌ jwanꞌ nyebeꞌ nde re xaꞌ jwanꞌ ngeno yalnyebeꞌ lo yez, mdayaꞌ xaꞌ Jesus lo re men sa kuj xa' Jesus, nde mkeꞌ xaꞌ Jesus lo kruz. ");
INSERT INTO ztp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Le' náꞌ mbli xgab ke Jesus ak xaꞌ tolaꞌ re náꞌ xaꞌ Israel lo yaꞌ re xaꞌ yez Rom, per naya ngokla son wiz ngok re jwanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nde pla ngol jwanꞌ mkete xij náꞌ, le'ka nzoyen náꞌ jwanꞌ mdej ngol, lo ngwa ngol ro baꞌ na tilꞌ reꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nde naꞌngazalta ngol thabol Jesus, senꞌ mbere ngol mdaꞌ ngol kwent lo náꞌ ke pla anj mbro'to lo ngol, nde nchab anj, le' Jesus naban xa'. ");
INSERT INTO ztp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Xisa ngwa thipla men náꞌ ro baꞌ nde taga' xa ne re ngol ya lo náꞌ, taga' ne xaꞌ lo náꞌ, naꞌngwiꞌd xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Zyasa nchab Jesus lo xaꞌ: —¡Xaxka ne yek goꞌ nanchenta goꞌ, sa li lazoꞌ goꞌ re jwanꞌ nchab re profet! ");
INSERT INTO ztp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Chon nanakinꞌta rid Xaꞌ mtelꞌ Dios reta yalti reꞌ, sera' sa yote Xa' ten' li naro Dios Xa'? ");
INSERT INTO ztp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nde mdobte mdej Jesus reta jwanꞌ nchab lo ley chanꞌ Moises, nde lo reta jwan' nke' re profet, nde re jwan' nchab xki's Dios, mblo'xkan Jesus xa nda'y kwent chan' Jesús lo xa'. ");
INSERT INTO ztp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Senꞌ mzin xaꞌ yez tenꞌ nda xaꞌ, zyasa mbli Jesus xaja thi xaꞌ ndara mas tij. ");
INSERT INTO ztp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Le' xa ya mna'b toz lo Jesus nchab xaꞌ: —Kwed la kon náꞌ, tak mzyela izyo, nde se ndela yalꞌ. Zyasa ngote Jesus lenꞌ yo nde mbled Jesus kon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Senꞌ ndob xaꞌ ro mes wa xaꞌ, mxen Jesus pan nde mdaꞌ Jesus dyux lo Dios, nde mbli rol Jesus pan nde mdiꞌd Jesus pan lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Axta zyara' mbi lo xaꞌ nde mbyolo xaꞌ Jesus, per hor yaga mti' Jesus lo xa'. ");
INSERT INTO ztp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Zyasa nchab xaꞌ lo ta xaꞌ: —¿Chon jwanꞌ nade axta ngo nale lazonꞌ senꞌ ndetodiꞌs xaꞌ lonꞌ ned nde ngoꞌxkan xaꞌ re xkiꞌs Dios jwanꞌ nge lo ye's lonꞌ? ");
INSERT INTO ztp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nde zyaga ngo xaꞌ ned mbere xaꞌ yez Jerusalen, nde senꞌ mzin xaꞌ tya thita nzi re si'bthib xin'te'd Jesus kon temas re xaꞌ nzino xa' tya. ");
INSERT INTO ztp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Zyasa nchab xaꞌ: Lo rop xaꞌ ta mzin na: —Lipa mbroꞌxban Jesus, tak Simon mbwiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Zyasa mdaꞌ rop xaꞌ ya kwent re jwanꞌ ngokte xa' ned lo nda xaꞌ, nde xamod mbyolo xaꞌ Jesus senꞌ mbli rol Jesus pan. ");
INSERT INTO ztp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Laj tata benꞌ nzi todiꞌs xaꞌ re jwanꞌ reꞌ, senꞌ xaj mbroꞌto Jesus xij re xaꞌ, nde mni Jesus dyux lo xaꞌ, nchab Jesus: —Yalnabez tyo kon go'. ");
INSERT INTO ztp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Zyasa jwanꞌ toz mzyeb re xaꞌ, mxak xaꞌ jwanꞌ bet ngwi' xa'. ");
INSERT INTO ztp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Per Jesus nchab lo xaꞌ: —¿Kwan ndliy nzyeb goꞌ? ¿Kwan ndliy tanya xgab ndli go'? ");
INSERT INTO ztp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bwiꞌ goꞌ yaꞌn nde bwiꞌ goꞌ nin, ¡nay! Bwal goꞌ na, sa nye goꞌ ke nay, tak jwan' bet ngenta belꞌ nde ngenta zij xa nak na re'. ");
INSERT INTO ztp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Laj ndotej Jesus jwanꞌ reꞌ lo re xaꞌ, mbloꞌ Jesus yaꞌ Jesus nde ni Jesus lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nde lo nale toz nzo lazoꞌ xaꞌ nde lo nzoyen xa' naꞌndlid lazoꞌ xa'y, zyasa nchab Jesus lo xaꞌ: —¿Choꞌ nzo kwan ngeno go' wa men? ");
INSERT INTO ztp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Zyasa mdaꞌ xaꞌ thi ble mbel mbyex nde thib ble ser nzo mzin lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nzi wi' re xa' ya mxen Xa'y mda Xa'y. ");
INSERT INTO ztp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Zyasa nchab Jesus lo xaꞌ: —Reta jwanꞌ re' mdej na lo go' senꞌ benꞌ nzinon goꞌ: nakinꞌka ri'd na reta jwan' re, xata nchab lo ley chan' Moisés nde re jwanꞌ mke' re profet, nde re jwanꞌ nchab lo libr chanꞌ Salmos. ");
INSERT INTO ztp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Zyasa mbli Jesus mxyal' yek re xa' sa yen xaꞌ jwanꞌ nchab lo xkiꞌs Dios, ");
INSERT INTO ztp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","nde nchab Jesus lo xaꞌ: —Cheꞌmod nchab lo xkiꞌs Dios jwanꞌ nge lo yez, le' Xaꞌ mtelꞌ Dios nakinꞌ gaj Xaꞌ, nde yaxo'b mbyon wiz ryoꞌxban Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","nde lo le Xa' ta' men kwent chan' Xa' sa la' men re jwan narax nde bere men lo Dios nde ton' Dios xken' men. Nde dib nax izyo yen kwent re' ya xata tyoptey yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nde go' mne xa nak reta jwan' re'. ");
INSERT INTO ztp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naya na telꞌ lo goꞌ jwanꞌ mke'yek Xud na taꞌ Xaꞌ lo goꞌ, per ndablo kwed goꞌ yez Jerusalen axta kebeꞌ kayaꞌ goꞌ yalne chanꞌ Dios jwanꞌ ryo' lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zyasa mbeꞌ Jesus reta xaꞌ jwanꞌ nzino Jesus axta yez Betania, nde mblen Jesus yaꞌ Jesus nde mbli ley' Jesus xa'. ");
INSERT INTO ztp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nde laj nge li ley' Jesus xa', mbla' Jesus xa', ngwap Jesus lo beꞌ ndya Jesus. ");
INSERT INTO ztp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Zyasa re xin'te'd Jesus, senꞌ mne mdoxub xa' lo Jesus, nale thoz ngo lazoꞌ xaꞌ mbere xaꞌ yez Jerusalen. ");
INSERT INTO ztp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nde thibla' nzi xaꞌ yodoꞌ, ni xaꞌ diꞌs wen lo Dios nde ndli ley' xa' le Dios. Ta naka.");
INSERT INTO ztp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Senꞌ ngos ngol ner reta jwan', nzola Diꞌs Nayon, nde Diꞌs ndo kon Dios, le' Diꞌs nak Dios. ");
INSERT INTO ztp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Xaꞌ reꞌ ndo kon Dios lo ngos ngol ner reta jwan' . ");
INSERT INTO ztp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Por Xa' sa mdoxkwaꞌ reta jwanꞌ nde tez naꞌngenta Xaꞌ nek thib jwanꞌ ta nzo ba, naꞌndoxkwadey. ");
INSERT INTO ztp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Xaꞌ nak yalnaban, nde yalnaban nak xni lo reta men. ");
INSERT INTO ztp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Leꞌ Xni ntoxniy lo yalꞌkow, nde yalꞌkow naꞌndlide gan ntu'y Xni. ");
INSERT INTO ztp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ngo ti mbiꞌ mtelꞌ Dios, mbiꞌ ya ndole Juan. ");
INSERT INTO ztp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mbiꞌ ya, mbyeꞌd tej kwent chanꞌ Xaꞌ nak Xni, tamod sa jwanꞌ ta mdej mbiꞌ ya li lazoꞌ men Xni. ");
INSERT INTO ztp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Naꞌnakta mbi' ya Xni, be'nta mbyeꞌd tej xa' kwent chanꞌ Xni. ");
INSERT INTO ztp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Xaꞌ jwanꞌ nak merpa Xni, jwan' ntoxni lo reta men, ndozinla lo izyo re'. ");
INSERT INTO ztp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nzola Xaꞌ lo izyo re' nde por Xaꞌ sa mdoxkwaꞌ izyo, per naꞌngyolod men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lo re men las Xaꞌ mbyeꞌd Xaꞌ, nde re men las Xaꞌ naꞌnkayaꞌd men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Leꞌ re men jwanꞌ mkayaꞌ men Xaꞌ, re men jwanꞌ ndli lazonꞌ Xaꞌ, lo re men ya mdaꞌ Xaꞌ yalnyebe' ak men xinꞌ Dios, ");
INSERT INTO ztp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","re xa' re' ngol nakub xa' ti gob, naktey tak mkelo xa' xa nkeloga thi mena, nekla xa nchola's thi mena, naka xa nchola's Dios. ");
INSERT INTO ztp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Leꞌ Diꞌs ya ngok men, ngo Xaꞌ xij naꞌ, dib Xaꞌ ndono yalwen nde jwanꞌ lipa. Nde mbwiꞌ náꞌ yalnaro chanꞌ Xaꞌ, ti yalnaro jwanꞌ xaga Xa' nak thib nya Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan mdej kwent chanꞌ Xaꞌ nde ne mbrez Juan, nchab Juan: —Xaꞌ reꞌ nak Xaꞌ jwanꞌ ta ndej na, senꞌ lo nchab na: Xaꞌ jwanꞌ nde xis na nzola Xaꞌ axta pola, tak nerla Xaꞌ nzo ke na. ");
INSERT INTO ztp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tak reta yalwen toz chanꞌ Xaꞌ nkayaꞌ naꞌy nde nzoꞌb xista nde yalwen. ");
INSERT INTO ztp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Leꞌ ley mdaꞌ Dios por Moisés, leꞌ yalwen nde jwanꞌ lipa mdaꞌ Dios por Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ngen cho tera' wiꞌ Dios, benꞌta thib nya Xinꞌ Dios, Xa' jwanꞌ thita nak kon Dios, Xaꞌ ya ndloꞌ lonꞌ cho nak Dios. ");
INSERT INTO ztp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Di's reꞌ mkab Juan, senꞌ re xaꞌ judí xaꞌ nak sinꞌ mbloned xaꞌ re ngwleyꞌ nde re xaꞌ levita, mbroꞌ xaꞌ yez Jerusalen sa ndanabdiꞌs xaꞌ lo Juan, nchab xaꞌ: ¿Lu, cho nak la? ");
INSERT INTO ztp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Leꞌ Juan mbloꞌro nde naꞌnka'sta Juan, nchab Juan: —Naꞌnakta na Crist. ");
INSERT INTO ztp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Zya bere mnabdiꞌs xaꞌ: —¿Choga lu sa? ¿Ota lu nak Elías? Leꞌ Juan mkab: —Nakte na. Zya bere nchab xaꞌ: —¿Ota lu nak xaꞌ jwanꞌ ni Dios lonꞌ sa tej lay lo men? Leꞌ Juan mkab lo xaꞌ: —Naꞌnakte. ");
INSERT INTO ztp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Zyasa nchab xaꞌ: —¿Choga nak la sa? Sa ta gab náꞌ lo xaꞌ jwanꞌ mbloned náꞌ. ¿Cho toyal tej la lo náꞌ, cho nak la? ");
INSERT INTO ztp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Leꞌ Juan nchab: —Na nak ti xaꞌ mbez izyo biz: “Nalí bdi'x goꞌ xned Xaꞌ Nyebeꞌ,” —xa nchab profet Isaías. ");
INSERT INTO ztp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nde re xaꞌ ta ngwa nabdiꞌs lo Juan nak xa' xa' fariseo. ");
INSERT INTO ztp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nde mnabdiꞌs xaꞌ, nchab xaꞌ: —¿Cho kwan liy ngolea men tez naꞌnakta lu Crist, ne' nak la Elías nde ne' nak la profet? ");
INSERT INTO ztp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Leꞌ Juan mkab lo re xaꞌ ya: —Na ngole men kon nit, per xij goꞌ ndo thi Xaꞌ naꞌnzolod goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xaꞌ ya ndenke xis na, nzola Xaꞌ axta pola nde naꞌnsal'ta na xak na kore yalyid Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Re jwanꞌ reꞌ ngok yez Betania, tedib lad ro yoꞌ Jordán, plo tenꞌ ngegole Juan men. ");
INSERT INTO ztp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tedib wiz, mbwiꞌ Juan, leꞌ Jesus nde lo Juan, sa nchab Juan: —¡Bwiꞌ goꞌ, Xaꞌ reꞌ nak Mbakxilꞌ yen' Dios, Xaꞌ jwanꞌ tonꞌ xken men lo izyo! ");
INSERT INTO ztp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Xaꞌ reꞌ nak xaꞌ ta ndej na ya: “Xaꞌ jwanꞌ nde xis na, nzola Xaꞌ axta pola, tak nerla Xaꞌ nzo ke na.” ");
INSERT INTO ztp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nek na, nancholot na Xaꞌ, per ndal na ngegolen men lenꞌ nit, sa yolo re men Israel Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nde noga mdej Juan, nchab Juan: —Mbwiꞌn Mbi Nayon mbroꞌ lo beꞌ ndey xaja ti palom mblatoba yek Xa'. ");
INSERT INTO ztp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nde naꞌngyolot na Xaꞌ, per Xaꞌ jwanꞌ mtelꞌ na golen men lenꞌ nit, Xaꞌ ya ne lon: “Yek Xaꞌ jwanꞌ wiꞌa lya Mbi Nayon, nde lyatoba yek Xaꞌ, Xaꞌ ya jwanꞌ kole men kon Mbi Nayon.” ");
INSERT INTO ztp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nde na mbwiꞌy, jwanꞌ nasa ndej na leꞌ Xaꞌ reꞌ nakpa Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Le' tedib wiz, ndo Juan tya tedib gob, kon chop xinꞌ teꞌd Juan. ");
INSERT INTO ztp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nde senꞌ mbwiꞌ Juan ngete Jesus tya, nde nchab Juan: —¡Bwiꞌ goꞌ, Xaꞌ reꞌ nak Mbakxilꞌ yen' Dios! ");
INSERT INTO ztp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lo senꞌ mbin rop xinꞌ teꞌd Juan jwanꞌ na, mdonke xaꞌ xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Lo mbyek Jesus, mbwiꞌ Jesus leꞌ rop xaꞌ ya ndenke xis Jesus, zya nchab Jesus lo xaꞌ: —¿Cho kwan nkwanꞌ goꞌ? Leꞌ rop xaꞌ ya nchab: —Rabí, —diꞌs reꞌ nak maestr —¿Plo nzoa? ");
INSERT INTO ztp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mkab Jesus lo xaꞌ: —Deꞌ goꞌ sa wiꞌ goꞌ. Zyasa ngwa xaꞌ nde mbwiꞌ xaꞌ plo nzo Jesus, nde mbled xaꞌ kon Jesus wiz ya, tak nzola hor thap bzyeba. ");
INSERT INTO ztp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tib xaꞌ ya nak Ndres wes Simón xaꞌ ndolegaꞌ Pedr. Ndres ya ta mbin jwanꞌ mdej Juan nde mdonke xaꞌ xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Xa´ reya´ nerla wez xa' Simón mzyalꞌ xa', nde nchab xaꞌ lo Simón: — Mzyal náꞌ Xa' mtel Dios, — diꞌs ya nak Crist. ");
INSERT INTO ztp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nde mbeꞌ Ndrés, Simón plo ndo Jesus, nde senꞌ mbwiꞌ Jesus xaꞌ, nchab Jesus: —Lu nak Simón, xinꞌ Jonás, lu ryole Cefas —diꞌs ya nak, Pedr. ");
INSERT INTO ztp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tedib wiz, Jesus mbli xgab nda Xaꞌ lo xyon Galilea tya mzyalꞌ Xaꞌ Blib, nde nchab Xaꞌ: —Btonke xis na. ");
INSERT INTO ztp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Leꞌ yez Blib nak Betsaida, tenꞌ nak yez Ndrés nde Pedr. ");
INSERT INTO ztp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Leꞌ Blib mzyal Natanael, nde nchab Blib: —Mzyal náꞌ Xaꞌ ta mdej Moisés lo ley nde Xa' yaga ta mdej re profet, Xaꞌ ya nak Jesus, xinꞌ José xaꞌ yez Nazaret. ");
INSERT INTO ztp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael nchab: —¿Cho nyea yez Nazaret ryo' ti jwan' wen? Leꞌ Blib nchab: —De sa wiꞌa. ");
INSERT INTO ztp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Senꞌ mbwiꞌ Jesus ndegax Natanael, nchab Jesus: —Ncheꞌ nde ti xaꞌ nakpa men Israel, ti xaꞌ jwanꞌ naꞌngenta yalkwinꞌ lazonꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Zya nchab Natanael lo Jesus: —¿Cho nyea nzoloa na? Jesus mkab lo Natanael: —Lo tera' kwes Blib la, senꞌ ndoa xanꞌ ya hig, tya mbwiꞌn la. ");
INSERT INTO ztp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael mkab: —Maestr, ¡Lu nak Xinꞌ Dios, lu nak Rey lo men Israel! ");
INSERT INTO ztp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus mkab lo Natanael nde nchab Jesus: —¿Cho lo ta nin loa: \"mbwiꞌn la ndoa xanꞌ ya hig,\" sa ndli lazoꞌa na? Naraꞌ wiꞌa mas jwanꞌ naro ke jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Noga nchab Jesus: —Gal' di's nin lo go', xata naya tyobte wiꞌ goꞌ xyalꞌ lo beꞌ nde re ánj chanꞌ Dios nchap xaꞌ nde ndlya xaꞌ tenꞌ ndo Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ngok byon wiz, ngo ti yalselyaꞌ yez Caná lo xyon Galilea. Tya ndo xnaꞌ Jesus, ");
INSERT INTO ztp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","nde noga mbrez xaꞌ Jesus lo yalselyaꞌ kon re xinꞌ teꞌd Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nde mbis nit ub, sa nchab xnaꞌ Jesus lo Jesus: —Na'ngenotra xa' nit ub. ");
INSERT INTO ztp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Leꞌ Jesus nchab: —¿Cho kwan liy lon ta mbez la ngol? Teraꞌ sin hor chanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Leꞌ xnaꞌ Jesus nchab lo re men jwan' ndli sinꞌ tya: —Bli goꞌ reta jwanꞌ nye Xaꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nde tya nzi xop yet nabiꞌ naksaꞌ ke, jwanꞌ ncho nit ndlirsinꞌ re xa' judí sa mbi xaꞌ lo Dios. Thiba yet ya ncho tap gal litr nit nde axta tib ayoꞌ litr nit nchoy. ");
INSERT INTO ztp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus nchab lo re xaꞌ ndli sinꞌ tya: —Ptoseꞌ goꞌ re yet reꞌ kon nit. Zyasa mtoseꞌlap xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nde nchab Jesus lo xa': —Bloꞌte goꞌ luda, nde beꞌ goꞌy lo xaꞌ nyebeꞌ lo ni. Nde mbe' xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Senꞌ mbli beꞌ xaꞌ nyebeꞌ nit jwanꞌ ngolal nit ub nde nekla nye xaꞌ plo mbroꞌy, benꞌta re xaꞌ nzi li sinꞌ mney, tak re xaꞌ ya mtoseꞌ yet kon nit ye. Leꞌ xaꞌ ta ndonyebeꞌ mbrez xaꞌ mbyo ta ndoselyaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Sa nchab xaꞌ lo mbyo: —Reta lo ni nerla nit ub wen ndaꞌ xaꞌ nchuꞌ men nde senꞌ jwanꞌ toz la nda yuꞌ mena, zyaraꞌ sa ngiꞌd xaꞌ nit ub jwanꞌ beja ntak. Leꞌ lu sa cheꞌla mblosaꞌa nit ub wen nde axta naya ndoyiꞌd lay. ");
INSERT INTO ztp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jwanꞌ reꞌ nak yalnaro ner mbli Jesus yez Caná lo xyon Galilea, mbloꞌ Xaꞌ yalnaro chanꞌ Xaꞌ, nde re xinꞌ teꞌd Jesus mbli lazoꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Senꞌ mne jwanꞌ reꞌ, Jesus nda yez Capernaum, kon xnaꞌ Xaꞌ, re wes Xaꞌ nde kon re xinꞌ teꞌd Xaꞌ, nde plata wiz mbled xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Senꞌ ndosin gaxla ni pask chanꞌ re xaꞌ judí, zya ngwap Jesus yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nde tenꞌ nak yodoꞌ tya ngosiꞌb Jesus nzi ntho xa' ngon, mbakxilꞌ nde palom, nde noga re xaꞌ jwanꞌ nzilꞌ tmi nzi ndob tya. ");
INSERT INTO ztp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Zyasa mtek Jesus ti doꞌ xa ti bins nde mbloꞌte Jesus reta men le, tagaꞌ mbloꞌte Jesus re mbakxilꞌ nde re ngon ta nzi tho xaꞌ, nde mchaꞌs Jesus tmin re xaꞌ nzilꞌ tmi nde mtub Jesus re mes xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nde nchab Jesus lo re xaꞌ ntho palom: —¡Bloꞌte goꞌ reta chenꞌ goꞌ ba ncheꞌ! ¡Naꞌlilalta goꞌ liz Xud na yo ncho xbiꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Zyasa re xaꞌ nak xinꞌ teꞌd Jesus mteꞌlaꞌs xaꞌ jwanꞌ nchab lo xkiꞌs Dios: “Yalno jwan' ngenon liz la, li gaj na.” ");
INSERT INTO ztp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Re xaꞌ judí xaꞌ nak sinꞌ mnabdiꞌs lo Jesus, nchab xaꞌ: —¿Cho yalnaro loꞌa lo náꞌ sa nye náꞌ ngenoa yalnyebeꞌ lia jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus mkab lo xaꞌ, nchab Jesus: —Psil goꞌ yodoꞌ reꞌ nde lenꞌ son wiz bere toxkwan diba. ");
INSERT INTO ztp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Leꞌ re xaꞌ judí xaꞌ nak sinꞌ mkab, nchab xaꞌ lo Jesus: —Choꞌbxop linꞌ mtaꞌ xaꞌ yodoꞌ reꞌ, nde lu mbez, lenꞌ sonta wiz bere toxkwaꞌa diba. ");
INSERT INTO ztp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Leꞌ Jesus ndotej yodoꞌ jwanꞌ nak leꞌga Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jwanꞌ nasa, senꞌ lo mbroꞌxban Jesus xij re men nguj, re xaꞌ nak xinꞌ teꞌd Jesus mteꞌlaꞌs xaꞌ diꞌs ta nchab Jesus, nde mbli lazoꞌ xaꞌ xkiꞌs Dios nde mbli lazoꞌ xaꞌ diꞌs ta mdej Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Laj benꞌ ngete Jesus yez Jerusalén lenꞌ ni chanꞌ Pask, bro toz men mbli lazoꞌ xaꞌ Jesus, tak ngwiꞌ xaꞌ re yalnaro ndli Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per naꞌndlid lazoꞌ Jesus re men, tak nzolo Jesus xgab ndono re men. ");
INSERT INTO ztp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nde naꞌnakinꞌta Jesus choraꞌ tej nyenꞌ xomod nak men, tak nzolola Xaꞌ xgab nzo lazoꞌ men. ");
INSERT INTO ztp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ngo ti mbiꞌ ndole Nikodem xaꞌ fariseo, nak xa' sinꞌ lo re men judí. ");
INSERT INTO ztp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Xaꞌ reꞌ, yal' ngwa xa' lo Jesus, nchab xaꞌ: —Maestr, mne náꞌ Dios mtelꞌ la sa toteꞌd la náꞌ, tak ngen cho xaꞌ ligan li yalnaro ta ndlia ba, tez naꞌndonoda xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus mkab lo xaꞌ, nchab Jesus: —Nipa na loa, men naꞌgalnakubta tedib gob naꞌtoyalta wiꞌ xaꞌ yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem mnabdiꞌs lo Jesus: —¿Xomod toyal gal ti men goxa tedib gob? ¿Cho toyal lya men lenꞌ xnaꞌ men nde gal men tedib gob? ");
INSERT INTO ztp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus mkab: —Nipa na loa, xaꞌ naꞌgalta lo nit nde lo Xbi naꞌtoyalta lya xaꞌ lo yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Men nchal lo xnanꞌ, nak men, men, nde men nchal lo Xbi, xbi naka. ");
INSERT INTO ztp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naꞌyoyenta lu ta mbez na loa: \"Nakinꞌ gal nakub men.\" ");
INSERT INTO ztp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbiba nxyoꞌba ploja tenꞌ ncholaꞌsa, nde nchon la ndye's nxyoꞌba, per nanyet la plo ndey nde plo nday. Tamod nak re men ta nchal lo Xbi. ");
INSERT INTO ztp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem mkab, nchab' xa': —¿Xomod nak jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus nchab lo Nicodem: —¿Lu nak Maestr lo re men Israel nde naꞌnyed la jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nipa na loa, jwanꞌ mne náꞌ jwanꞌ na ndyodiꞌs náꞌ nde jwanꞌ ngwiꞌ náꞌ jwanꞌna ndej náꞌ, per nandlid lazoꞌ goꞌ jwanꞌ ndej náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jwanꞌ lo izyo ndej na loa nde naꞌlid lazoꞌ lay ¿Xomodka li lazoꞌa tez tej na jwanꞌ lo beꞌ loa? ");
INSERT INTO ztp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ngen cho teraꞌ yap lo beꞌ, benꞌta thita Xaꞌ mbroꞌ lo beꞌ, Xaꞌ ya nak Xinꞌ Mbiꞌ, Xaꞌ nzo lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nde xa mxap gap Moisés mbelꞌ lo ya izyo biz, tagaꞌ nakinꞌ yap gap Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Sa reta men jwanꞌ ndli lazonꞌ Xaꞌ, naꞌtyapta men, cheꞌla keno men yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Lo ta jwanꞌ toz nkeꞌ lazoꞌ Dios reta men, jwanꞌ nasa mdaꞌ Dios thib nya Xinꞌ Dios, sa reta men jwanꞌ ndli lazonꞌ Xinꞌ Dios, naꞌtyapta men, cheꞌla keno men yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tak namtelꞌta Dios Xinꞌ Dios lo re men sa yathix men xken men, cheꞌla por Xinꞌ Dios sa lyaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Men li lazonꞌ Xinꞌ Dios, naꞌyathixta men xken men, leꞌ men jwanꞌ naꞌlid lazonꞌ Xaꞌ, men ya yathix xken naꞌ, tak naꞌndlid lazoꞌ xaꞌ thib nya Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nde jwanꞌ reꞌ nak yalke: Xni mbyeꞌda lo izyo, nde re men masra' mkeꞌ lazoꞌ xaꞌ yalꞌkow ke xni, tak re jwanꞌ ndli xaꞌ naka jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tak re men ta ndli jwanꞌ narax, naꞌndyenta xaꞌ xni, nde naꞌmbiked xaꞌ lo xni, sa naloꞌd re jwanꞌ ndli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Leꞌ men ndli jwanꞌ galꞌ, ncheꞌd xaꞌ lo xni, sa loꞌ ke re jwanꞌ ndli xaꞌ naka jwanꞌ ncholaꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sen' mne jwanꞌ reꞌ, Jesus kon re xinꞌ teꞌd Xa' ngwa re xaꞌ lo xyon Judea, tya mbyanꞌ Xaꞌ kon re xinꞌ teꞌd Xaꞌ nde mblole Xaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Noga Juan ngole men tenꞌ ndole Enón, gax tenꞌ ndole Salim, tak tya nzo bro toz nit, mzin re men lo Juan nde mblole Juan men. ");
INSERT INTO ztp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jwanꞌ reꞌ ngok senꞌ teraꞌ keꞌ lisyiꞌb xaꞌ Juan. ");
INSERT INTO ztp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zyaza re xaꞌ jwanꞌ nak xinꞌ teꞌd Juan ngwa xaꞌ kwent kon pla xaꞌ judí, kwent chanꞌ jwanꞌ nchak nambi xaꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Zya mbyeꞌd xaꞌ lo Juan, nchab xaꞌ: —Maestr, bwiꞌ leꞌ Xaꞌ ta mdo kon lu tedib lad ro yoꞌ Jordán, Xaꞌ jwanꞌ mdaꞌa kwent chanꞌ naꞌ ya, ngole Xaꞌ men, nde reta men nda lo Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Leꞌ Juan mkab nde nchab Juan: —Ngenta cho kwan ak li mbiꞌ, tez Xaꞌ ndob lo beꞌ naꞌtaꞌda Xa' diꞌs li mbiꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Leꞌga goꞌ mne senꞌ nchab na, naꞌnakta na Crist, na nak ti xaꞌ jwanꞌ ndesiblo lo Crist. ");
INSERT INTO ztp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ti lo yalselyaꞌ, mbyo jwanꞌ selyaꞌ, mbyo ya jwanꞌ ka ngol, leꞌ xaꞌ jwanꞌ nsalꞌta mbyoꞌ gax ndo xaꞌ cho mbyo nde nchon xaꞌ jwanꞌ ndyodiꞌs mbyo, nde nale toz ncho lazoꞌ xaꞌ nchon xaꞌ xkiꞌs mbyo. Tagaꞌ na, nale toz nzo lazoꞌn naya. ");
INSERT INTO ztp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jwanꞌ nasa, nakiꞌnka Xaꞌ ak mas Xaꞌ ntak nde na ak xaꞌ lud ntak. ");
INSERT INTO ztp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Xaꞌ jwanꞌ nde gap, nyebeꞌ Xaꞌ dib nax. Leꞌ xaꞌ lo izyo, men lo izyo nak xaꞌ nde jwanꞌ lo izyo ndyodiꞌs xaꞌ. Per Xaꞌ jwanꞌ nde lo beꞌ, nyebeꞌ Xaꞌ dib nax. ");
INSERT INTO ztp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nde jwanꞌ mbwiꞌ Xaꞌ nde mbin Xaꞌ, jwanꞌ na ndej Xaꞌ nde ngen cho men ndli lazonꞌ xkiꞌs Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Men jwanꞌ ndli lazonꞌ xkiꞌs Xaꞌ, men ya ndej leꞌ xkiꞌs Dios nak jwanꞌ li. ");
INSERT INTO ztp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tak Xaꞌ jwanꞌ Dios mtelꞌ, xkiꞌs Dios ndyodiꞌs Xaꞌ. Tak Dios naꞌnkad Xaꞌ Mbi Nayon chanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Leꞌ Pay nkeꞌ lazoꞌ Xaꞌ Xinꞌ Xaꞌ, nde reta jwanꞌ mdaꞌyaꞌ Xaꞌy lo yaꞌ Xinꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Men jwanꞌ li lazonꞌ Xinꞌ Dios, men ya ngeno yalnaban adiꞌ. Per men jwanꞌ naꞌlid lazonꞌ Xinꞌ Dios naꞌwiꞌd xaꞌ yalnaban, cheꞌla yalnayiꞌ chanꞌ Dios nzoꞌb xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Re xaꞌ fariseo mbin xaꞌ, bro toz men nak xinꞌ teꞌd Jesus nde taja bro toz men ngole Jesus ke Juan. ");
INSERT INTO ztp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tenyega naꞌnakta Jesus ngole men, xinꞌ teꞌd Jesus ngole men. ");
INSERT INTO ztp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Senꞌ mbin Jesus jwanꞌna, yaja mbroꞌ Jesus lo xyon Judea nde nda Xaꞌ lo xyon Galilea tedib gob. ");
INSERT INTO ztp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nde nakinꞌka rid Xaꞌ lo xyon Samaria. ");
INSERT INTO ztp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Zya mzin xaꞌ ti yez ndole Sikar lo xyon Samaria, gax tenꞌ nax wan jwanꞌ mdaꞌyaꞌ Jakob lo xinꞌ xaꞌ José polaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nde tya ndob pos jwanꞌ ngok chanꞌ Jakob. Nde awizta mzan Jesus ndo Xaꞌ ned, yaja mdob Xaꞌ ro pos. ");
INSERT INTO ztp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tya mzin ti ngol xyon Samaria ndeloꞌ ngol nit, leꞌ Jesus nchab lo ngol: —Btaꞌ lud nit gun. ");
INSERT INTO ztp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Laja re xaꞌ nak xinꞌ teꞌd Jesus ndya yez, nda ka xaꞌ jwanꞌ wa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Zyasa leꞌ ngol xyon Samaria nchab lo Jesus: —¿Cho kwan liy lon nyaꞌb la nit gua nde men judí nak la, nde na nak ti ngol lo xyon Samaria? (Ta nchab ngol, tak naꞌnzalꞌtad re xaꞌ judí kon re xaꞌ lo xyon Samaria.) ");
INSERT INTO ztp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Leꞌ Jesus mkab, nchab Xaꞌ lo ngol: —Tez yoloa jwanꞌ ntalaꞌs Dios, nde cho nak Xaꞌ ta ne loa: \"ptaꞌ nit gun, lu jwan' nyaꞌb nit lo Xaꞌ nde ta' Xaꞌ nit naban gua. ");
INSERT INTO ztp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Leꞌ ngol nchab: — Naꞌngenod la jwanꞌ koꞌa nit, nde naꞌs toz pos. ¿Plo koꞌa nit naban sa? ");
INSERT INTO ztp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Cho mas ntak la ke lo Jakob xaꞌ gox lonꞌ ngo pola, xaꞌ jwan' mtanꞌ pos reꞌ lo náꞌ, ncheꞌ nguꞌ re xinꞌ xaꞌ nit nde re manꞌ xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus mkab nde nchab Jesus lo ngol: —Choja men nchuꞌ nit reꞌ, nche'k xaꞌ tedib gob; ");
INSERT INTO ztp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Leꞌ xaꞌ gu nit jwan' tan lo xaꞌ, tiptane naꞌyektraꞌ lazoꞌ xaꞌ. Tak nit jwanꞌ tan gu xaꞌ, lenꞌ lazoꞌ xaꞌ ak tenꞌ tyob yalꞌ nit nde taꞌy yalnaban adiꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Leꞌ ngol nchab lo Jesus: —Xa' Nyebe', ptaꞌ nit ya gun, sa naꞌyektraꞌ na, nekla yeꞌd loꞌn nit ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus nchab lo ngol: —Wa chez salꞌ la sa yeꞌd rop goꞌ ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Leꞌ ngol nchab: —Naꞌngenot na salꞌ na. Jesus nchab lo ngol: —Galꞌka nea, naꞌngenod la salꞌ la; ");
INSERT INTO ztp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tak gayꞌla xaꞌ biꞌ ndoyak salꞌ la, nde xaꞌ jwanꞌ ndobnoa naya naꞌnakte salꞌ la. Li jwanꞌ ta mdej la. ");
INSERT INTO ztp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Leꞌ ngol nchab lo Jesus: —Xa' Nyebe', ndyak na, lu nak ti profet. ");
INSERT INTO ztp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Re xaꞌ gox lo náꞌ, xa' samaritan, yek yiꞌ reꞌ mbre xaꞌ mdaꞌ xa dyux lo Dios nde re goꞌ, men judí mbez Jerusalen tya ndablo taꞌ men dyux lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus nchab lo ngol: —Bli lazoꞌa na ngol, mzin hor nekla yek yiꞌ reꞌ, nekla Jerusalén na'nakinꞌtra ya taꞌ goꞌ dyux lo Pay. ");
INSERT INTO ztp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Naꞌnyed go' cho lo ndaꞌ goꞌ dyux, leꞌ náꞌ mne ná' cho lo ndaꞌ náꞌ dyux, tak Xaꞌ tolaꞌ men nde lo bin xa' judí. ");
INSERT INTO ztp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Leꞌ hor ndosinla nde naya nak hor senꞌ re xaꞌ jwanꞌ liga ndaꞌ dyux lo Pay, taꞌ xaꞌ dyux lo Pay kon xbin xaꞌ xaga ndabloy; tak noga Pay, men ya nkwanꞌ Xaꞌ, men taꞌ dyux lo Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios nak Xbi; nde men jwanꞌ ndaꞌ dyux lo Dios, ndablo li xaꞌy kon xbin xaꞌ jwanꞌ xa ncholaꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Leꞌ ngol nchab lo Jesus: —Mnen yeꞌd Xaꞌ telꞌ Dios (Xa' ndole Crist) —Nde senꞌ yeꞌd Xaꞌ, koꞌxkan Xaꞌ reta jwanꞌ lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus nchab: —Na jwanꞌná, Xaꞌ ya ndotodiꞌsnoa reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Zya mzin re xaꞌ nak xinꞌ teꞌd Jesus, nde nzoyen re xaꞌ tak mbwiꞌ xaꞌ ndotodiꞌsno Jesus ti ngol. Per nek thib xaꞌ nanabdiꞌsta lo Jesus, nyenꞌ cho kwanꞌ nyaꞌbdiꞌs Jesus lo ngol o cho kwan ndliy ndotodiꞌsno Jesus ngol. ");
INSERT INTO ztp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Zyasa mblaꞌ ngol rén ngol, nde ngwa ngol yez, nchab ngol lo reta men: ");
INSERT INTO ztp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Deꞌ goꞌ, sa wiꞌ goꞌ tib mbiꞌ jwanꞌ mdej lon reta jwanꞌ nak na. ¿Cho naꞌnakta Xaꞌ reꞌ nak Crist? ");
INSERT INTO ztp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Zyasa mbroꞌ re men lenꞌ yez, nda xaꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Laja leꞌ re xinꞌ teꞌd Jesus mnaꞌb xaꞌ lo Jesus, nchab xaꞌ: —Maestr, waa lud. ");
INSERT INTO ztp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Leꞌ Jesus nchab: —Ngenon ti jwanꞌ wan, naka ti jwanꞌ naꞌnyed goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Zyasa re xaꞌ nak xinꞌ teꞌd Jesus nchab xaꞌ lo ta xaꞌ: —¿Cho nzo cho mbyeꞌdno jwanꞌ wa xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus nchab lo xaꞌ: —Leꞌ yalwa chanꞌ na nak lin re jwanꞌ ncholaꞌs Xaꞌ jwanꞌ mtelꞌ na, nde tolon rsinꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Goꞌ mbez: “Ndaꞌb ti thap mbeꞌ sa dyop kosech”; leꞌ na ni lo goꞌ: Blit goꞌ lo goꞌ nde bwiꞌ goꞌ, leꞌ reta men ta ndeba nak xaꞌ xaja trig nzobinla nde ngoxoꞌbla beꞌ dyopa. ");
INSERT INTO ztp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nde xaꞌ jwanꞌ nthop kosech nchax nka xaꞌ, tak kosech jwan' nthop xaꞌ naka par yalnaban adiꞌ, sa xaꞌ jwanꞌ mblo bin thita nale yo lazoꞌ xaꞌ kon xaꞌ jwanꞌ mthop kosech. ");
INSERT INTO ztp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jwanꞌ nasa, liga jwanꞌ xa nchab diꞌs: “Xaꞌla men ngobin, nde xaꞌla men nthop kosech” ");
INSERT INTO ztp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na mtel goꞌ sa thop goꞌ cosech jwanꞌ namblobinta goꞌ, xaꞌla ti pla xaꞌ jwanꞌ mblobina nde goꞌ mbla lo rsinꞌ xaꞌ sa thop goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nde bro toz men lo xyon Samaria mbliꞌ lazoꞌ xaꞌ Jesus, por diꞌs jwanꞌ ndej ngol, tak nchab ngol: “Reta jwanꞌ mblin mdej Xaꞌ lon.” ");
INSERT INTO ztp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Zyasa re xaꞌ lo xyon Samaria mbyeꞌd xaꞌ lo Jesus nde mnaꞌb xaꞌ sa yanꞌ Jesus tya kon xaꞌ. Nde mbyanꞌ Jesus tya chop wiz. ");
INSERT INTO ztp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nde masraꞌ bro men mbli lazoꞌ xaꞌ xkiꞌspa Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nde nchab re xaꞌ lo ngol: —Naya naꞌnakta benꞌta xkiꞌs la ndli lazoꞌ náꞌ, noga yub diꞌs ro Xaꞌ mbin ná', nde mne náꞌ Xaꞌ reꞌ lipa nak Xaꞌ ntolaꞌ men lo xken men, Xaꞌ nak Crist. ");
INSERT INTO ztp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mbri'd chop wiz, Jesus mbroꞌ lo xyon Samaria nda Xaꞌ lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tak yub Jesus mdej ke ti profet tenꞌ nak las xaꞌ naꞌnxobyekta men xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Senꞌ mzin Jesus Galilea, re men yez ya ndyen xaꞌ mzin Jesus, tak mbwiꞌ xaꞌ re jwanꞌ mbli Jesus yez Jerusalén lo ni chanꞌ Pask; tak no re xaꞌ ya ngwa lo ni. ");
INSERT INTO ztp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Senꞌ mbere Jesus tedib gob yez Caná lo xyon Galilea tenꞌ ta mbli Jesus yalnaro mblilal Xaꞌ nit ye nit ub. Tya nzo ti mbiꞌ jwanꞌ ndli sinꞌ lo rey, ngeno xaꞌ tib xinꞌ xaꞌ nayiz nzo yez Capernaum. ");
INSERT INTO ztp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mbiꞌ reꞌ, senꞌ mbin xaꞌ mbroꞌ Jesus lo xyon Judea nde mzin Jesus lo xyon Galilea, zya mbyeꞌd xaꞌ lo Jesus, mnaꞌb xaꞌ ya Jesus liz xaꞌ sa todanꞌ Jesus xinꞌ xaꞌ jwan' ndayajla. ");
INSERT INTO ztp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Zyasa nchab Jesus lo xaꞌ: —Tez naꞌngwiꞌd goꞌ re yalnaro nde re jwanꞌ ndloꞌn lo goꞌ, pa li lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Leꞌ xaꞌ ta ndli sinꞌ lo rey, nchab xaꞌ: —Pken goꞌ ndyanꞌ liz na, naya tera gaj xinꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Leꞌ Jesus nchab lo mbiꞌ: —Bya, mbyak la xinꞌ la. Leꞌ mbiꞌ ya mbli lazoꞌ xaꞌ diꞌs nchab Jesus lo xaꞌ, nde ndya xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Senꞌ ndya xaꞌ, zya ngwaxiꞌned re mos xaꞌ, nde nchab mos lo xa: —Seba mbyak la xinꞌ la. ");
INSERT INTO ztp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Zyasa mnabdiꞌs xaꞌ lo mos: —¿Cho hor ndobteꞌ ngo wen lazoꞌr? Leꞌ mos nchab: —Naꞌya hor thib bsyeba mbroꞌ xlyer. ");
INSERT INTO ztp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Zyasa xaꞌ nak xud or mbyen xaꞌ, hor yaxa ta nchab Jesus lo xaꞌ: “Mbyak la xinꞌ la;” nde re liz xaꞌ mbli lazoꞌ xa' Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jwanꞌ reꞌ nak mbrop yalnaroꞌ mbli Jesus, senꞌ mbere Xaꞌ ngwa Xaꞌ lo xyon Judea nde mzin Xaꞌ lo xyon Galilea. ");
INSERT INTO ztp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ngolo re jwanꞌ re', re xaꞌ judí mkeno xa' ni chan' xa' nde Jesus ngwap Xa' yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nde lenꞌ yez Jerusalén, gax ro yala jwan' ndole chan' re Mbakxilꞌ, tya ndob ti tank, diꞌs hebreo ndoley Betesda. Ngenoy gayꞌ korredor. ");
INSERT INTO ztp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tya nzi bro toz men nayiz, men naꞌakta wiꞌ, men ngoꞌb ninꞌ, nde men naꞌakta tye, ngembed xaꞌ sa win nit. ");
INSERT INTO ztp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tak tij tij ncheꞌd ti anj lo nit, sa ngwin nit; nde xaꞌ jwanꞌ nerla ndlya lenꞌ tank senꞌ mnela mbwin nit, xaꞌ ya nchanꞌ nadanꞌ one choja yiz ndyak xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nde xija nzo ti mbiꞌ ndala galbsiꞌ xon linꞌ nayiz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Senꞌ mbwiꞌ Jesus nax mbiꞌ ya tya, nde mne Jesus ndala ta nax xaꞌ, zya mnabdiꞌs Jesus lo xaꞌ, nchab Jesus: —¿Cho ncholaꞌs la dyanꞌ la? ");
INSERT INTO ztp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Leꞌ xaꞌ yiza mkab: —Naꞌngenta cho ko na lenꞌ tank senꞌ lo ngwin nit. Tak lo senꞌ ncholas na lyan lenꞌ tank, nerla tedib xaꞌ ndlya. ");
INSERT INTO ztp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus nchab lo xaꞌ: —Btoli, bxen lonꞌ la nde pte. ");
INSERT INTO ztp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nde zyaga mbyak mbiꞌ ya lo yis, mxen xaꞌ lonꞌ xaꞌ nde mde xaꞌ. Lexa wiz ya nak wiz ndryoꞌxkwen men. ");
INSERT INTO ztp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Zyasa re xaꞌ judí xaꞌ nak sinꞌ, nchab xaꞌ lo mbiꞌ ta mbyaka: —Naya nak wiz ndryoꞌxkwen men; naꞌngenta mod wea lonꞌ la. ");
INSERT INTO ztp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Leꞌ xaꞌ biꞌ ya mkab: —Xaꞌ jwanꞌ mtodanꞌ na, xaꞌ ya ne lon: “Bxen lonꞌ la nde pte.” ");
INSERT INTO ztp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Leꞌ re xaꞌ judí xaꞌ nak sinꞌ mnabdiꞌs xaꞌ, nchab xaꞌ: —¿Cho xaꞌ ta ne loa: “Bxen lonꞌ la nde pte”? ");
INSERT INTO ztp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Leꞌ mbiꞌ ta mbyaka naꞌnyed xaꞌ cho xaꞌ ta mbli sa mbyak xaꞌ, tak Jesus zyaga mbroꞌte Xaꞌ xij re men nzi tya. ");
INSERT INTO ztp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Xixla zyaraꞌ mzyalꞌ Jesus mbiꞌ ya tenꞌ ndob yodoꞌ, nde nchab Jesus lo mbiꞌ: —Bwiꞌ, naya ta mbyak la; naꞌlitra la mas jwanꞌ narax, sa naꞌyetra tedib yalti mas naro xis la. ");
INSERT INTO ztp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Leꞌ mbiꞌ ya ngo ned nde ngwa tej xaꞌ lo re xaꞌ judí xaꞌ nak sinꞌ, ke Jesus nak Xaꞌ ta mtodanꞌ xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jwanꞌ nasa re xaꞌ judí xaꞌ nak sinꞌ tolo mketenke xaꞌ xis Jesus sa yoga Jesus, tak kwan liy sa lenꞌ wiz ndryoꞌxkwen men mtodanꞌ Jesus mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus nchab lo xaꞌ: —Leꞌ Xud na thiblaꞌ ndli Xaꞌ sinꞌ nde tagaꞌ na thiblaꞌ ndlin sinꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jwanꞌ nasa, re xaꞌ judí xaꞌ nak sinꞌ, masraꞌ nkwanꞌ xaꞌ mod gaj Jesus, tak naꞌnakte benꞌ naꞌnxobyekta Jesus wiz ndroꞌxkwen men, noga tak mbez Jesus ke Xud Jesus nak Dios, nchak lal Jesus kon Dios. ");
INSERT INTO ztp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Zyasa mkab Jesus nde nchab xaꞌ: —Nipa na lo goꞌ, leꞌ na Xinꞌ Dios ngen kwan ak li thib na, cheꞌla le'n ndli re jwanꞌ ngwiꞌn ndli Xud na; tak reta jwanꞌ ndli Xud na, jwanꞌna ndlin. ");
INSERT INTO ztp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tak Xud na nkeꞌ lazoꞌ Xa' na nde ndloꞌ Xaꞌ lon reta jwanꞌ ndli Xaꞌ; nde masraꞌ naro re jwanꞌ loꞌ Xaꞌ lon ke lo re jwanꞌ reꞌ, tloꞌ Xaꞌ re jwanꞌ nzoyen goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tak ta xa ngo'xban Xud na re men nguj nde ndaꞌ Xa' yalnaban, tagaꞌ na Xinꞌ Xud na ndan yalnaban lo re men jwanꞌ ncholas na ta nay. ");
INSERT INTO ztp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tak Xud na', nek thib lo men naꞌnyabta Xaꞌ kwent, cheꞌla lon mdaꞌ Xaꞌ yalnyebeꞌ ya, ");
INSERT INTO ztp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","sa reta men xobyek xaꞌ na ta xa nxobyek xaꞌ Xud na. Leꞌ men jwanꞌ naxobyekta na, naꞌnxobyekta xaꞌ Xud na, Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Nipa na lo go', men jwanꞌ nchon xkiꞌs na, nde ndli lazoꞌ xaꞌ Xaꞌ ta mtelꞌ na, men ya ngeno yalnaban adiꞌ; nde naꞌxyopta yalke xis xaꞌ, cheꞌla mbroꞌ xaꞌ lo yalguj nde lya xaꞌ lo yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nipa na lo goꞌ, ndosin hor, nde naya nak hor, senꞌ re xaꞌ nguj gon xaꞌ bez na, na Xinꞌ Dios, nde re xaꞌ ta gona ban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tak ta, xa Xud na leꞌga Xaꞌ ngeno yalne ndaꞌ Xaꞌ yalnaban, tagaꞌ mdaꞌ Xaꞌ yalne lon sa leꞌga na tan yalnaban lo men; ");
INSERT INTO ztp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","nde tagaꞌ mdaꞌ Xaꞌ yalnyebeꞌ lon sa nyaꞌb na kwent lo re men, lo ta nak na Xinꞌ Mbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Naꞌyoyenta goꞌ jwanꞌ reꞌ; tak sin hor senꞌ reta xaꞌ nzo lenꞌ baꞌ gon xaꞌ bez na, ");
INSERT INTO ztp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nde re xaꞌ jwanꞌ mbli wen ryoꞌxban xaꞌ sa kayaꞌ xaꞌ yalnaban; leꞌ re xaꞌ mbli jwanꞌ narax ryoꞌxban xaꞌ sa kix xaꞌ xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Naꞌlit na gan lin nek thib jwanꞌ leꞌga na. Tak xa nchon na ndej Xud na lon, tagaꞌ nyaꞌb na kwent lo men, nde kwent jwanꞌ nyaꞌb na galꞌ naka, tak naꞌndlit na jwanꞌ ncholas na, leꞌn ndli jwanꞌ ncholaꞌs Xud na, Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tez leꞌga na tan kwent chanꞌ na, naꞌlida jwanꞌ ndotej na. ");
INSERT INTO ztp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nzo tedib xaꞌ tej kwent chanꞌ na nde mnen leꞌ kwent chanꞌ na jwanꞌ ndej xaꞌ naka jwanꞌ li. ");
INSERT INTO ztp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Goꞌ mtelꞌ men sa nyabdiꞌs xaꞌ lo Juan, nde Juan mdaꞌ kwent jwanꞌ nak lipa. ");
INSERT INTO ztp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per naꞌnakinꞌta na tedibla men tej kwent chanꞌ na, ndotej na jwan' re' lo go', sa tolaꞌ Dios goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan ngok ti jwanꞌ mdoxni, nde lud tyemp ngo nale lazoꞌ goꞌ lo xni chanꞌ xa'. ");
INSERT INTO ztp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per ngenon re jwanꞌ ndloꞌ ke liga na nak Xinꞌ Dios ke lo re jwanꞌ ta mdej Juan. Tak re sinꞌ ta ndlin, jwanꞌ naxa mnabeꞌ Xud na lon lin, re jwanꞌna ndloꞌ ke Xud na mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Noga Xud na, Xaꞌ jwanꞌ mtelꞌ na mdej Xaꞌ kwent chanꞌ na. Nek lud naꞌngonta goꞌ xkiꞌs Xaꞌ, nekla ngwiꞌ goꞌ Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nekla ndono goꞌ xkiꞌs Xaꞌ lenꞌ lazoꞌ goꞌ, tak nandlid lazoꞌ goꞌ Xaꞌ jwanꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nteꞌd toz goꞌ yeꞌs nge xkiꞌs Dios; tak ndyak goꞌ tya nzyal goꞌ yalnaban adiꞌ, nde leꞌga tya ndeja kwent chanꞌ na, ");
INSERT INTO ztp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nde naꞌncholasta goꞌ yeꞌd goꞌ lon sa keno goꞌ yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Naꞌkayat na re yalnaro chanꞌ men. ");
INSERT INTO ztp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tak nzolon goꞌ, nde mnen naꞌnked lazoꞌ goꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ndal na tak Xud na mtelꞌ na, nde naꞌkayad goꞌ na; per tez yeꞌd ti xaꞌ ngen cho mtelꞌ, xaꞌ ya kayaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xomod toyal li lazoꞌ goꞌ na, tez benꞌta ncholaꞌs goꞌ men ni wen xis goꞌ, nde nancholaꞌsta goꞌ Dios ni wen xis goꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Naꞌtyenta goꞌ xgab ke na tej lo Xud na re jwanꞌ narax ndli goꞌ, nzo tib xaꞌ jwanꞌ teja, xaꞌ ya nak Moisés, xaꞌ ta ndob xgab goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tak tez ndli lazoꞌ goꞌ Moisés, noga na ndablo li lazoꞌ goꞌ, tak kwent chanꞌ na jwanꞌ mkeꞌ Moisés lo yeꞌs. ");
INSERT INTO ztp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per tez naꞌndlid lazoꞌ goꞌ diꞌs mkeꞌ Moisés, ¿xomod li lazoꞌ goꞌ xkiꞌs na sa? ");
INSERT INTO ztp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Senꞌ ngolo jwanꞌ reꞌ ya, Jesus mbroꞌ nda tedib lad ro nit chanꞌ Galilea, jwanꞌ ndolegaꞌ re nit chanꞌ Tiberias. ");
INSERT INTO ztp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nde men toz tir mdonke xis Jesus, tak ngwiꞌ xaꞌ re yalnaro jwanꞌ ndli Jesus lo re men nayiz. ");
INSERT INTO ztp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zyasa ngwap Jesus tib yek yiꞌ nde mdob Xaꞌ tya kon re xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nde ndeyenla nde Pask, ni chanꞌ re xaꞌ judí. ");
INSERT INTO ztp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Senꞌ mblit Jesus lo Jesus, mbwiꞌ Jesus men toz tir nde lo Xaꞌ, zyasa nchab Jesus lo Blib: —¿Plo yakanꞌ jwanꞌ wa reta men reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Per ta nchab Jesus lo xa' sa li be' Jesus xa', tak mnea Jesus cho kwan li Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Leꞌ Blib mkab lo Jesus: —Tmi jwanꞌ nzinaꞌ men ti chop ayoꞌ wiz naꞌgalta tmi ya tyuꞌ jwanꞌ wa re men reꞌ, tenye nchep nchepay dinꞌ thiba xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Leꞌ ti xinꞌ teꞌd Jesus ndole Ndrés wes Simón Pedr, nchab: ");
INSERT INTO ztp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ncheꞌ ndo ti mbyo, ngeno gayꞌ pan sebad nde chop mbel; ¿xa gal jwanꞌ reꞌ wa labaja men? ");
INSERT INTO ztp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Zyasa nchab Jesus lo xaꞌ: —Gus goꞌ lo reta men sa tyob xaꞌ. Tak tya jwan' toz nzo yix naye, nde mer nye ti gayꞌ mil men biꞌ jwanꞌ mdob. ");
INSERT INTO ztp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zyasa mxen Jesus re pan ya, nde senꞌ ngolo mdaꞌ Jesus dyux lo Dios, mdaꞌ Xaꞌy lo re xinꞌ teꞌd Xaꞌ, nde leꞌ xinꞌ teꞌd Xaꞌ mdiꞌda lo reta men nzi tya; tagaꞌ mod mdiꞌd Xaꞌ mbel, nde mda re xaꞌ axta kebeꞌ mze xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Senꞌ ngolo mze reta men, zyasa nchab Jesus lo re xinꞌ teꞌd Jesus: —Bthop goꞌ reta jwanꞌ ta mbroxoꞌba, sa nekluda naꞌaktida. ");
INSERT INTO ztp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nde lo re gayꞌ pan sebad, mze tibsen chokwid ngo re pedas bix pan jwanꞌ mbroꞌxoꞌb mthop xaꞌ, lo jwanꞌ ta mda reta men. ");
INSERT INTO ztp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Senꞌ lo mbwiꞌ re men yalnaro jwanꞌ mbli Jesus, nchab xaꞌ: —Liga Xaꞌ reꞌ nakpa profet, Xaꞌ ta nakla diꞌs yeꞌd lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Leꞌ Jesus mbyénla Xaꞌ, leꞌ reta men ya ncholaꞌs xaꞌ we xaꞌ Jesus sa ak Jesus rey lo xaꞌ, jwanꞌ nasa mbere Jesus nde thib Jesus nda yek ti kox ro. ");
INSERT INTO ztp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Senꞌ ndela yalꞌ, re xaꞌ nak xinꞌ teꞌd Jesus mdola xa' mzin xaꞌ ro nittoꞌ, ");
INSERT INTO ztp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ngwap xaꞌ lo ti bark nde nda xaꞌ lo nit sa sin xaꞌ yez Capernaum. Senꞌ mkowla izyo, teraꞌ sin Jesus tenꞌ nda re xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nde jwanꞌ toz ngwap bde tak mbi toz mxyo'b lo nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Senꞌ ndatela xaꞌ gayꞌ mil metr o xop mil metr lo nit, zya mbwiꞌ xaꞌ leꞌ Jesus ndeni lo nittoꞌ nde ndobike gax Jesus tenꞌ nda bark, zya mzyeb toz re xaꞌ nak xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Leꞌ Jesus nchab lo xaꞌ: —¡Nay, naꞌzyepta goꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Zyasa nale ngo lazoꞌ re xaꞌ senꞌ ngwap Jesus lo bark, nde naban mzin re xaꞌ tenꞌ nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Senꞌ tedib wiz, re men jwanꞌ mbyanꞌ tedib lad ro nittoꞌ mne xaꞌ thipta bark jwanꞌ mdob ro nit, nde Jesus naꞌngwapta Xaꞌ lo bark ya kon re xinꞌ teꞌd Xaꞌ, leꞌta re xinꞌ teꞌd Jesus nda. ");
INSERT INTO ztp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xisla zyaraꞌ mzin ti pla bark jwanꞌ mbroꞌ yez Tiberias, mzina gax tenꞌ ta mdaꞌ Jesus dyux lo Dios nde mda re men pan. ");
INSERT INTO ztp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Senꞌ mne re mena naꞌngenta Jesus tya, neka re xinꞌ teꞌd Jesus naꞌngenta, zyasa reta xaꞌ ngwap lo bark ta mzina nde nda xaꞌ yez Capernaum, nda kwanꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Senꞌ mzin reta xaꞌ tedib lad ro nittoꞌ, tya ngosi'b xaꞌ Jesus nde nchab xaꞌ lo Jesus: —Maestr, ¿Pol mzin la ncheꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Leꞌ Jesus nchab lo xaꞌ: —Nipa na lo goꞌ, nangetekwanꞌta goꞌ na tak mbyen goꞌ re yalnaro mblin, leꞌ goꞌ ngetekwanꞌ na tak mda goꞌ pan nde mze lenꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Naꞌkwaꞌnta goꞌ jwanꞌ ta ncha men nde ndluxa, leꞌ goꞌ pkwan jwanꞌ naꞌndluxta nde jwanꞌ ndaꞌ yalnaban adiꞌ lo goꞌ. Jwanꞌ reꞌ jwanꞌ ta ndaꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo lo goꞌ, tak yalnyebeꞌ reꞌ mdaꞌ Xud na Dios lon. ");
INSERT INTO ztp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Zyasa nchab re xaꞌ lo Jesus: —¿Cho kwan ndablo li náꞌ sa tyobte ak rsinꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mkab Jesus nde nchab lo xaꞌ: —Jwanꞌ reꞌ nak rsinꞌ Dios, ndablo li lazoꞌ goꞌ Xaꞌ jwanꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Zyasa nchab re xaꞌ lo Jesus: —¿Cho yalnaro loꞌa lo náꞌ, sa wiꞌ náꞌy, nde li lazoꞌ náꞌ lu? ¿Cho kwan lia? ");
INSERT INTO ztp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Re men gox lo naꞌ ngo pola mda xa' maná senꞌ ndo xaꞌ izyo bis, jwanꞌ xa chabka lo xkiꞌs Dios: “Lo be' mbroꞌ pan mdaꞌ Dios mda reta men.” ");
INSERT INTO ztp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Leꞌ Jesus nchab lo xaꞌ: —Gal' di's nipa na lo goꞌ: Naꞌnakta Moisés jwanꞌ mdaꞌ pan mbroꞌ lo beꞌ mda re xaꞌ, Xud na jwanꞌ ndaꞌ leꞌpa pan ndryoꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tak pan jwanꞌ ndaꞌ Dios, nak Xaꞌ jwanꞌ mbroꞌ lo beꞌ, nde ndaꞌ Xaꞌ yalnaban lo re men lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Zya nchab re xaꞌ lo Jesus: —Xaꞌ Nyebeꞌ, thiblaꞌ ptaꞌ pan reꞌ wa náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus nchab lo xaꞌ: —Na nak pan ndaꞌ yalnaban; nde men jwanꞌ nde lon, nek lud naꞌlyaꞌntra xaꞌ; nde men jwanꞌ li lazonꞌ na, nek lud naꞌyektraꞌ lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Xa niga na lo goꞌ, teꞌnyega ngwiꞌ goꞌ na, naꞌlid lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Reta men jwanꞌ ndaꞌ Xud na lon, nde xaꞌ lon, nde re xaꞌ jwanꞌ nde lon, naꞌgotet na xaꞌ le. ");
INSERT INTO ztp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tak nambroꞌt na lo be' sa lin jwanꞌ ncholas na, leꞌn ndal sa lin jwanꞌ ncholaꞌs Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nde jwanꞌ reꞌ nak jwanꞌ nchola's Xud na, Xaꞌ jwanꞌ mtelꞌ na; leꞌ reta men jwanꞌ mdaꞌ Xaꞌ lon, naꞌtabta na nek tib xaꞌ, cheꞌla goꞌxban na re men ya senꞌ yoxo'b wiz blus. ");
INSERT INTO ztp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nde jwanꞌ reꞌ nchola's Xaꞌ jwanꞌ mtelꞌ na; leꞌ reta men jwanꞌ wiꞌ Xinꞌ Dios, nde li lazoꞌ men Xaꞌ, men ya keno yalnaban adiꞌ nde goꞌxban na xaꞌ senꞌ yoxoꞌb wiz blus. ");
INSERT INTO ztp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zyasa re xaꞌ judí mdobte mbloxyo xaꞌ Jesus, tak nchab Jesus: “Na nak pan mbroꞌ lo beꞌ.” ");
INSERT INTO ztp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jwanꞌ nasa nchab re xaꞌ: —¿Cho naꞌnakta Xaꞌ reꞌ nak Jesus xinꞌ José, nzolonꞌ xud xaꞌ nde xnaꞌ xaꞌ? ¿Xomod sa mbez Xaꞌ: \"Lo beꞌ mbroꞌn\"? ");
INSERT INTO ztp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus mkab nde nchab Jesus lo xaꞌ: —Naꞌkoxyotra goꞌ na xij goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nek thib men naꞌlida gan yeꞌd lon, tez Xud na Xaꞌ mtelꞌ na naꞌyednod Xaꞌ men lon; nde na goꞌxban men senꞌ yoxoꞌb wiz blus. ");
INSERT INTO ztp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lo yeꞌs jwanꞌ mkeꞌ re profet, nchaba: \"Tatu wiz toteꞌd Dios reta men.\" Jwanꞌ nasa, reta men jwanꞌ nchon xkiꞌs Xud na nde mteꞌd xaꞌ lo Xud na, men ya nde lon. ");
INSERT INTO ztp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Naꞌngenta nek thib men jwanꞌ mbwiꞌla Xud na, benꞌta Xaꞌ jwanꞌ mbroꞌ tenꞌ ndob Dios, Xaꞌ ya mbwiꞌ Xud na. ");
INSERT INTO ztp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gal' di's nipa na lo goꞌ: Xaꞌ jwanꞌ li lazonꞌ na, xaꞌ ya ngeno yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nak pan ndaꞌ yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Re xaꞌ gox lo goꞌ jwanꞌ mbre pola, tenye mda xaꞌ maná senꞌ nzi xaꞌ izyo biz, nde ngujka xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Leꞌ na ndej pan mbroꞌ lo beꞌ, nde xaꞌ jwanꞌ wa pan reꞌ, naꞌgajta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na nak pan naban, jwanꞌ mbroꞌ lo beꞌ; tez nzo men wa pan reꞌ, thiptane ban xaꞌ. Leꞌ pan jwanꞌ tan naka belꞌ na, taꞌyaney sa keno men yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Zyasa re xaꞌ judí mkodi's xa', nchab xaꞌ lo ta xa': —¿Xomod sa belꞌ mbiꞌ reꞌ taꞌ mbiꞌ wanꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus nchab lo xaꞌ: —Gal' di's nipa na lo goꞌ, tez nawad goꞌ belꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo, nde nagud goꞌ ren Xaꞌ, naꞌkenod goꞌ yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Leꞌ men jwanꞌ wa belꞌ na nde gu xaꞌ ren na, xaꞌ ya keno yalnaban adiꞌ, nde na goꞌxban xaꞌ senꞌ yoxo'b wiz blus. ");
INSERT INTO ztp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tak belꞌ na nak jwanꞌ wapa men nde ren na nak jwanꞌ gupa men. ");
INSERT INTO ztp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xaꞌ jwanꞌ ncha belꞌ na nde nchuꞌ xaꞌ ren na, xaꞌ ya thiblaꞌ ndono na, nde na ndono xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Leꞌ Xud na, Xaꞌ jwanꞌ mtelꞌ na, naban Xaꞌ nde benꞌta Xaꞌ sa naban na, nde taga' men jwanꞌ wa belꞌ na, benꞌta na sa ban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pan reꞌ mbroꞌ lo beꞌ, men wa pan reꞌ keno xaꞌ yalnaban adiꞌ, nakte xa nak mana jwanꞌ mda re xaꞌ gox lo go' jwan' mbre pola, nde ngujka xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Reta jwanꞌ reꞌ nchab Jesus, mdoteꞌd Xaꞌ re men lenꞌ yo tenꞌ ndyop re xaꞌ Israel lenꞌ yez Capernaum. ");
INSERT INTO ztp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Naꞌr toz re xinꞌ teꞌd Jesus mbin xaꞌ jwanꞌ reꞌ nde nchab xaꞌ: —Nagan nak diꞌs reꞌ ¿Cho li gan yena? ");
INSERT INTO ztp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Zyasa mne Jesus leꞌ re xaꞌ nak xinꞌ teꞌd Jesus nzi goxyo xaꞌ diꞌs jwanꞌ ta mdej Jesus, zyasa nchab Jesus lo xaꞌ: —¿Cho ngwa'd go' xkiꞌs na? ");
INSERT INTO ztp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xomodka li goꞌ tez wiꞌ goꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo yap Xaꞌ tenꞌ nzoga Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Xbi jwanꞌna ndaꞌ yalnaban, leꞌ belꞌ ngen cho sinꞌ liy, nde re diꞌs jwanꞌ ndyodiꞌs na Xbi naka nde ndaꞌy yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per nzo pla goꞌ xija naꞌndlid lazoꞌ goꞌy. Tak axta xanꞌ naꞌy, mnela Jesus xanya men naꞌlid lazonꞌ Xaꞌ, nde cho xa' ta tayaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nde nchab Jesus: —Jwanꞌ nasa mbez na lo goꞌ, nek thib men naꞌlida gan yeꞌd lon, tez Xud na nataꞌda diꞌs. ");
INSERT INTO ztp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Xata zya, bro toz re xaꞌ nak xinꞌ teꞌd Jesus mbere xaꞌ xis, naꞌngetenketra' xaꞌ xis Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Zyasa nchab Jesus lo re thib sen xinꞌ teꞌd Xaꞌ: —¿Cho no goꞌ nchola's ndya? ");
INSERT INTO ztp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Leꞌ Simón Pedr mkab: —Xaꞌ Nyebeꞌ, ¿Cho lo ya náꞌ? Nde lu nkeno diꞌs nda' yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nde náꞌ, mbli lazoꞌ náꞌ lu nde mne náꞌ leꞌ lu nak Crist, Xinꞌ Dios naban. ");
INSERT INTO ztp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus nchab lo xaꞌ: —¿Cho naꞌnakta na jwanꞌ mbli re thib sen goꞌ nde thib goꞌ nzo xija nak maxuꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Leꞌ Jesus ndej Judas Iscariot, xinꞌ Simón; tak xaꞌ ya tayaꞌ Jesus, nde no xaꞌ nzo xij re tib sen xinꞌ teꞌd Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Senꞌ mbridla reta jwanꞌ reꞌ, Jesus ngete lo xyon Galilea; nde naꞌncholasta Xaꞌ kete Xaꞌ lo xyon Judea, tak tya re xaꞌ judí ncholaꞌs xaꞌ kuj xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ndosin gaxla ni chanꞌ re xaꞌ judí jwanꞌ ntaꞌb xaꞌ ramad, ");
INSERT INTO ztp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","leꞌ re wes Jesus nchab lo Jesus: —Broꞌte ncheꞌ nde gwa lo xyon Judea, sa wiꞌ re xinꞌ teꞌd la re yalnaro jwanꞌ ndlia. ");
INSERT INTO ztp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tak nek thib xaꞌ ta ncholaꞌs yolo men xa', naꞌndlinagaꞌsta xa' re jwan'. Leꞌa ta ndlila re jwan' re', wa liy xij reta men. ");
INSERT INTO ztp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ta nekla re wes Jesus nandlid lazoꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Zyasa nchab Jesus lo xaꞌ: —Teraꞌ yoxoꞌb beꞌ li nay, leꞌ goꞌ one choja beꞌ li goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Re men lo izyo re' naꞌyiꞌnoda xaꞌ goꞌ, leꞌ na, ngiꞌno xaꞌ na, tak leꞌn ndej narax nak re jwanꞌ ndli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wa goꞌ lo ni, na'yat na tak teraꞌ yoxoꞌb wiz na. ");
INSERT INTO ztp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Senꞌ lo ta nchab Jesus, mbyanꞌ Jesus yez Galilea. ");
INSERT INTO ztp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Senꞌ ndyala re wes Jesus lo ni, zyasa no Jesus ndya, per nalasta nkete Xaꞌ sa nawi'da men Xa'. ");
INSERT INTO ztp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nde re xaꞌ judí mkwanꞌ xaꞌ Jesus lo ni, nchab xaꞌ: —¿Ma Xaꞌ ya? ");
INSERT INTO ztp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nde nyaga ndyodiꞌs re xaꞌ xis Jesus tya, nzo xaꞌ nchab: “Wen nak Xaꞌ”; Nde nzo xaꞌ nchab: “Nakta xaꞌ men wen; benꞌta ngetekwinꞌno Xaꞌ re ma yez” ");
INSERT INTO ztp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Reta men nagaꞌsta ndej xaꞌ kwent chanꞌ Jesus, tak nzyeb men re xaꞌ judí. ");
INSERT INTO ztp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Senꞌ ndala rolja ni, Jesus ngoxo'b tenꞌ ndob yodoꞌ ,nde tolo mdobte mtoteꞌd Xaꞌ re men. ");
INSERT INTO ztp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Leꞌ re xaꞌ judí nzoyen xaꞌ, nchab xaꞌ: —¿Xomod taja nchak mbi reꞌ, nde namteꞌdta Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Leꞌ Jesus mkab: —Jwanꞌ ta ndloꞌn reꞌ naꞌnaktey chanꞌ na, leꞌy nak chanꞌ Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Men ndyen li jwanꞌ nchola's Dios, men ya yolo nyenꞌ cho chanꞌ Dios ndloꞌn o jwanꞌ nak xgab na ndloꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Men ndyodiꞌs jwanꞌ nak leꞌga xgab men, yalnaro chanꞌ xaꞌ nkwanꞌ xaꞌ; leꞌ Xaꞌ jwanꞌ nkwanꞌ yalnaro chanꞌ Xaꞌ jwanꞌ mtelꞌ Xaꞌ, Xaꞌ ya ndej jwanꞌ li nde naꞌndejta Xaꞌ yalkwinꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Cho naꞌmdayaꞌda Moisés ley lo goꞌ nde nek thib goꞌ naꞌnxobyekta ley. ¿Cho kwan liy sa ncholaꞌs goꞌ kuj goꞌ na? ");
INSERT INTO ztp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Leꞌ reta men mkab nde nchab xaꞌ lo Jesus: —¡Xbin maxuꞌ nzoa, ¿Cho ncholaꞌs kuj la? ");
INSERT INTO ztp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus mkab lo xaꞌ: —Len wiz ndryoꞌxkwen men mblin thi yalnaro, jwanꞌna taja nzoyen goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mbay liga, Moisés mnabeꞌ tyob be' lad men biꞌ ba (tenye naꞌnakte jwanꞌ mnabeꞌ Moisés, naka jwanꞌ mtanꞌ re xaꞌ gox mbre pola). sa leꞌ goꞌ lenꞌ wiꞌz ndryoꞌxkwen men ntob go' be' lad men biꞌ ba. ");
INSERT INTO ztp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nde sa naꞌyaꞌnta goꞌ narax lo ley ndyak goꞌ, ntob goꞌ be' lad or biꞌ lenꞌ wiz ndryoꞌxkwen men, ¿Kwanka liy sa nayiꞌ goꞌ lon lo thiptane mtodan' na ti mbiꞌ lenꞌ wiz jwanꞌ ndryoxkwen men? ");
INSERT INTO ztp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Naꞌkoxyod goꞌ jwanꞌ nzoꞌb xis ta ngwiꞌ goꞌ. Bloxyo goꞌ, per bli goꞌy xa nakpaꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zyasa pla xaꞌ yez Jerusalén nchab xaꞌ lo ta xaꞌ: ¿Cho naꞌnakta mbiꞌ reꞌ ta nkwanꞌ xaꞌ kuj xaꞌ ya? ");
INSERT INTO ztp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bwiꞌ goꞌ, galꞌ ndoni Xaꞌ lo reta men, nde ngenta kwan mbez men lo Xaꞌ. ¿O mbli lazo' re xaꞌ nak sinꞌ, liga Xaꞌ reꞌ nak Crist? ");
INSERT INTO ztp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per nzolonꞌ Xaꞌ reꞌ, mnenꞌ plo nde Xaꞌ, nde senꞌ lo yeꞌd Crist, ngenta cho men nye plo ryoꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Leꞌ Jesus nkeloꞌ xkiꞌs Dios lo re men tenꞌ ndob yodoꞌ, nde ne mbrez Jesus nchab Xaꞌ: —¡Nzolo goꞌ na nde mne goꞌ plo ndal na! nde naꞌndalta na por kwent chanꞌ na, Xaꞌ jwanꞌ mtelꞌ na galꞌ nak Xaꞌ, nde naꞌnzolod goꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Leꞌ na, nzolon Xaꞌ, tak lo Xaꞌ mbroꞌn, nde Xaꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zyasa nchola's re xaꞌ tyen xaꞌ Jesus; per nek thib xaꞌ naꞌngoꞌda yanꞌ tak teraꞌ sin hor chanꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nde bro toz men jwanꞌ nzi tya mbli lazoꞌ xaꞌ Jesus, nde nchab xaꞌ: —Senꞌ yeꞌd Crist, ¿Chon mas bro yalnaro li Xaꞌ ya ke lo Xaꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Senꞌ mbin re xaꞌ fariseo jwanꞌ ndyodiꞌs re men xis Jesus, zyasa thita ngok xaꞌ kon re ngwleyꞌ jwanꞌ nyebeꞌ sa mtelꞌ xaꞌ re xaꞌ nkenap yodoꞌ sa yaxen xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Zyasa nchab Jesus: —Tud benꞌ ndonon goꞌ, tak leꞌn bere lo Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kwanꞌ goꞌ na, nde naꞌzyalta goꞌ na; nde tenꞌ ton, naꞌlid goꞌ gan sin goꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Leꞌ re xaꞌ judí nchab xaꞌ lo ta xaꞌ: —¿Plo ya Xaꞌ, sa naꞌyasalta naꞌ Xaꞌ? ¿Cho nyea nda Xaꞌ lo re men Israel jwanꞌ ngete xij re xaꞌ grieg, sa ndatoteꞌd Xaꞌ re men grieg? ");
INSERT INTO ztp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Xomod nak diꞌs ta mbez Xaꞌ: “Kwanꞌ goꞌ na, nde naꞌzyalta goꞌ na, nde tenꞌ ton, naꞌlid goꞌ gan sin goꞌ tya”? ");
INSERT INTO ztp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lenꞌ wiz ro senꞌ yoto ni, mdoli Jesus nde ne mbrez Xaꞌ, nchab Xaꞌ: —Tez cho goꞌ nchek lazonꞌ, deꞌ goꞌ lon sa gu goꞌ nit. ");
INSERT INTO ztp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Men jwanꞌ ndli lazonꞌ na, xa nchabka lo xkiꞌs Dios: \"Lenꞌ lazoꞌ xaꞌ siꞌblen re yo' nda' nit naban\". ");
INSERT INTO ztp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus ndej Mbi Nayon jwanꞌ kayaꞌ re men li lazonꞌ Xaꞌ, leꞌ zya tera yeꞌd Mbi Nayon, tak benꞌ ngete Jesus lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Leꞌ pla xaꞌ jwanꞌ nzo xij men toza, senꞌ mbin xaꞌ xkiꞌs Jesus, nchab xaꞌ: —Xaꞌ reꞌ liga nak ti Xaꞌ ni Dios lonꞌ sa tej Xaꞌy lo men. ");
INSERT INTO ztp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Leꞌ ti pla xaꞌ nchab: —Xaꞌ reꞌ nak Crist. Per nzo xaꞌ nchab: —¿Cho lo xyon Galilea ryo' Crist? ");
INSERT INTO ztp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Cho naꞌnchabta lo xkiꞌs Dios, lo bin David nde yez Belén plo tenꞌ ngol David tya ndablo ryoꞌ Xaꞌ nak Crist? ");
INSERT INTO ztp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zyasa ngok rol men por diꞌs jwanꞌ nchab Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nzo xaꞌ xija ncholaꞌs nden xaꞌ Jesus per nek thib xaꞌ naꞌngoꞌda yanꞌ lad Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Senꞌ lo mbere re xaꞌ ta ngenap yodoꞌ mzin xaꞌ lo re ngwleyꞌ ro nde lo re xaꞌ fariseo; leꞌ re ngwleyꞌ ro nde re xaꞌ fariseo mnabdiꞌs xaꞌ lo re xaꞌ ta ngenap yodoꞌya, nchab xaꞌ: —¿Cho kwan liy sa naꞌngyednod goꞌ Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Leꞌ re xaꞌ jwanꞌ nkenap yodoꞌ, nchab: —¡Ngen cho ti mena tera' todiꞌs xa ndyodiꞌs mbiꞌ ya! ");
INSERT INTO ztp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Zyasa nchab re xaꞌ fariseo lo xaꞌ: —¿Cho noga' yek goꞌ mtokan Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Cho naꞌnyed goꞌ nek thib xaꞌ nak sinꞌ nde nek thib xaꞌ fariseo naꞌndlid lazoꞌ xaꞌ mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Leꞌ re men ta naꞌnyeda cho kwan nchab ley, xa' de xaꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Zyasa mkab Nicodem, xaꞌ ta ngwa todiꞌsno Jesus thi yalꞌla, tak no xaꞌ nak fariseo, sa nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Cho ngeni ley naꞌ, toyal koxyonꞌ ti mbiꞌ tez teraꞌ gon naꞌ xkiꞌs Xaꞌ nde nekla nyeꞌn cho kwan mbli Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Zyasa mkab re xaꞌ lo Nikodem, nchab xaꞌ: —¿Cho no lu nak men yez Galilea? Pteꞌd yeꞌs nge xkiꞌs Dios, sa nyea nek thib profet, naꞌndryoꞌd xaꞌ yez Galilea. ");
INSERT INTO ztp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Zyasa thiba xaꞌ ngo ned ndya xaꞌ liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Leꞌ Jesus mxen ned nda yiꞌ Olib. ");
INSERT INTO ztp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Senꞌ mduxni tedib wiz, mbere Jesus tenꞌ ndob yodoꞌ tedib gob nde reta men yez mbyeꞌd lo Jesus, zyasa mdob Jesus nde mbloꞌ Jesus xkiꞌs Dios lo men. ");
INSERT INTO ztp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Xija re xaꞌ nak maestr ndloꞌ ley xkiꞌs Dios nde re xaꞌ fariseo ndeno xaꞌ ti ngol ngoga naxno ngol ti mbiꞌ naꞌnakta salꞌ ngol; sa mto xaꞌ ngol xtowꞌ reta men nzi tya, ");
INSERT INTO ztp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","nde nchab xaꞌ lo Jesus: —Maestr, ngol reꞌ ngoga naxno ti mbiꞌ naꞌnakta salꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nde ley chanꞌ Moisés nyebeꞌ lo náꞌ ndablo gadke náꞌ re ngol ta ndli jwanꞌ reꞌ. ¿Lu, cho kwan nyea? ");
INSERT INTO ztp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ta nchab xaꞌ lo Jesus sa libeꞌ xaꞌ Jesus nde zyal mod keꞌ xaꞌ yalke yek Jesus. Leꞌ Jesus mbleng izyo nde nkeꞌ xaꞌ letr lo izyo kon kwenyaꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Leꞌ re xaꞌ ya tatka ndonabdiꞌs xaꞌ lo Jesus, zyasa mdoli Jesus nde nchab Jesus lo xaꞌ: —Tez nzo goꞌ xija naꞌngenta xken naꞌ, ner xaꞌ ya tyobte gadke ngol. ");
INSERT INTO ztp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Zya bere mbleng Jesus izyo tedib gob nde tatka ngekeꞌ Xaꞌ letr lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Leꞌ re xaꞌ ta nkeꞌ yalke yek ngola, senꞌ mbin xaꞌ ta nchab Jesus lo xaꞌ, zyasa tib tiba xaꞌ ngo ned ndya xaꞌ, tak mne xaꞌ nzoꞌb xken xaꞌ, nerla re xaꞌ gox ngo ned xisa mdonke masraꞌ xaꞌ; thipta Jesus mbyanꞌ nde kon ngol ndota tya, ");
INSERT INTO ztp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Senꞌ mxit yek Jesus, mbwiꞌ Jesus ngenta cho men nak, benꞌta thib ngol ndo tya, zyasa nchab Jesus lo ngol: —Ngol, ¿Ma re xaꞌ ta nkeꞌ yalke yek la ya? ¿Cho nek thib xaꞌ na'mnabe'da gaj la? ");
INSERT INTO ztp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Leꞌ ngol nchab: —Nek thib xaꞌy nye go'. Zyasa nchab Jesus lo ngol: —Nek na na'nyebet na gaj la; bya nde naꞌlitra lu jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus mni lo reta men tedib gob nde nchab Jesus: —Na nak xni lo reta men lo izyo; men jwanꞌ tyonke xis na, naꞌketed xaꞌ lo yalꞌkow, cheꞌla tyono xaꞌ xni ndaꞌ yalnaban. ");
INSERT INTO ztp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Zyasa re xaꞌ fariseo nchab lo Jesus: —Lu, lega jwanꞌ ndlia ndej la; nde re jwanꞌ ndlia naꞌnaktey jwan' li. ");
INSERT INTO ztp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus mkab nde nchab Jesus lo re xaꞌ: —Teꞌnye lega re jwanꞌ ndlin ndej na, per li re jwanꞌ ndlin, tak mnen plo mbro'n nde plo ndan; per goꞌ naꞌnyed goꞌ plo mbro'n nde plo ndan. ");
INSERT INTO ztp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Goꞌ ngoxyo men a xa nak xgab goꞌ; leꞌ na, naꞌngoxyot na nek thib men; ");
INSERT INTO ztp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nde tez na goxyon, galꞌ nak jwanꞌ ndlin, tak naꞌndlida thib nay, rop náꞌ Xud na ndliy, Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tak lo ley goꞌ nchab, tez chop men thita jwanꞌ ndej rop xaꞌ, xaꞌ ya ndej jwanꞌ li. ");
INSERT INTO ztp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jwanꞌ nasa, leꞌga na ndotej re jwanꞌ ndlin, nde Xud na Xaꞌ jwanꞌ mtelꞌ na, ndeja Xaꞌ jwanꞌ ndlin. ");
INSERT INTO ztp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Zyasa nchab xaꞌ lo Jesus: —¿Ma xud la? Leꞌ Jesus mkab lo xaꞌ: —Nek na naꞌnzolod goꞌ, tagaꞌ pa yolo goꞌ Xud na; tak tezka yolo goꞌ na, tagaꞌ tyolo goꞌ Xud na. ");
INSERT INTO ztp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Reta diꞌs reꞌ mni Jesus lo ndo Xaꞌ plo tenꞌ ndlya tmi yon chanꞌ yodoꞌ, tya mbloꞌ xaꞌ xkiꞌs Dios lo men; nde ngenta' cho xaꞌ nden Jesus, tak teraꞌ sin beꞌ yoga Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bere nchab Jesus lo xaꞌ: —Na ndya, nde kwanꞌ goꞌ na, per lo xken goꞌ gaj goꞌ; tak plo tenꞌ ndan, naꞌlid goꞌ gan yeꞌd goꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Zyasa re xaꞌ judí nchab: —¿Cho leꞌ kuj Xaꞌ lazoꞌ Xaꞌ, jwanꞌ nasa mbez Xaꞌ: Plo tenꞌ ndan naꞌlid goꞌ gan yeꞌd goꞌ tya? ");
INSERT INTO ztp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus nchab lo xaꞌ: —Goꞌ nak men nzo'b xken', jwan' xa nak re men narax lo izyo. Le' na naꞌnakta na Xaꞌ lo izyo, tak le'n nak Xa' nde lo be'. ");
INSERT INTO ztp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jwanꞌ nasa mbez na lo goꞌ, lo xken goꞌ gaj goꞌ, tak tez naꞌlid lazoꞌ goꞌ leꞌ Na Nak Xaꞌ Mtelꞌ Dios, lo xken goꞌ gaj goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Zyasa nchab xaꞌ lo Jesus: —¿Choga nak la sa? Leꞌ Jesus mkab lo xaꞌ: —Leꞌy nia na lo goꞌ neraꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nzo toz jwanꞌ tej na nde goxyon jwanꞌ nak goꞌ; per Xaꞌ jwanꞌ mtelꞌ na li jwanꞌ ndej Xaꞌ, nde jwanꞌ mbin na ndej Xaꞌ lon, jwanꞌna ndyodiꞌs na lo re men. ");
INSERT INTO ztp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nde naꞌngyenta men leꞌ Jesus ndotej Xud Xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jwanꞌ nasa nchab Jesus lo xaꞌ: —Senꞌ ke' goꞌ Xinꞌ Mbiꞌ lo kruz, zyasa yolo goꞌ, Na Nak Xa' Mtel' Dios, nde ngenta kwan lin le'ga na, cheꞌla xata ndloꞌ Xud na lon, jwanꞌna ndyodiꞌs na. ");
INSERT INTO ztp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tak Xaꞌ jwanꞌ mtelꞌ na, ndono Xaꞌ na; naꞌndlad Xud na na thib na, tak na thiblaꞌ ndlin jwanꞌ ndryoꞌ lazoꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Senꞌ ndotodiꞌs Jesus re jwanꞌ reꞌ, bro toz men mbli lazoꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Leꞌ re xaꞌ judí ta mblila lazonꞌ Jesus, nchab Jesus lo xaꞌ: —Tez yoto goꞌ lo xkiꞌs na, nak goꞌ Xinꞌ teꞌdpa na; ");
INSERT INTO ztp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nde yolo goꞌ jwan' lipa, nde jwan' lipa ya, li lya' goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Zya mkab re xaꞌ lo Jesus, nchab xaꞌ: —Náꞌ nde lo bin chanꞌ Abraham nde naꞌnzot náꞌ lo yaꞌ nek thib men; ¿Cho kwan liy mbez la lo náꞌ, lya' náꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Le' Jesus mkab lo xaꞌ: —Gal' di's nipa na lo go', reta men ndli jwanꞌ narax, lo yaꞌ jwanꞌ narax nzo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tak ti mos pa yanꞌ mos thiptane liz xaꞌ jwanꞌ nge mos sinꞌ, per ti xinꞌ biꞌ xaꞌ tyanꞌ or thiptane lo xud or. ");
INSERT INTO ztp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jwanꞌ nasa, tez Xinꞌ Dios tola' goꞌ, zyasa lipa mblyaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mnen lo bin chanꞌ Abraham nde goꞌ; per ncholaꞌs goꞌ kuj goꞌ na, tak naꞌnchotuda xkiꞌs na lazoꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na ndyodiꞌs re jwanꞌ ngwiꞌn ndli Xud na, nde leꞌ goꞌ ndli re jwanꞌ nchon goꞌ ndej xud goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Re men mkab nde nchab xaꞌ lo Jesus: —Lo bin chanꞌ Abraham nde náꞌ. Leꞌ Jesus nchab lo xaꞌ: —Tez liga lo bin Abraham nde goꞌ, re jwanꞌ mbli Abraham ndadlo li goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Leꞌ go', che'la ncholaꞌs goꞌ kuj goꞌ na, lo ta mdej na jwanꞌ li lo goꞌ, ke Dios ndlo' re jwan' lon, ¡nde Abraham naꞌmblid xaꞌ jwanꞌ ta ndli goꞌ ba! ");
INSERT INTO ztp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Goꞌ ndli re jwanꞌ ndli xud goꞌ. Zyasa nchab xaꞌ lo Jesus: —Naꞌnakta náꞌ mbed wan; ngeno náꞌ thipta xud náꞌ, Xaꞌ ya nak Dios! ");
INSERT INTO ztp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zyasa nchab Jesus lo xaꞌ: —Tez liga xud goꞌ nak Dios, ndablo keꞌ lazoꞌ goꞌ na, tak na mbroꞌ tenꞌ ndob Dios sa mzin na ncheꞌ; tak naꞌndalta na por kwent chanꞌ na, leꞌn ndal tak Dios mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Cho kwan liy naꞌyenta goꞌ jwanꞌ mbez na? Jwanꞌ ndliy nak, naꞌncholaꞌsta goꞌ gon goꞌ xkiꞌs na. ");
INSERT INTO ztp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xud goꞌ nak maxuꞌ, nde re jwanꞌ ndryoꞌ lazoꞌ xud goꞌ jwanꞌ na ncholaꞌs goꞌ li goꞌ. Maxuꞌ nak xaꞌ nguj men xata mdobte mdoxkwa' Dios izyo, nde naꞌnchotod xaꞌ lo jwanꞌ li, tak ngenta jwanꞌ li lenꞌ lazoꞌ xaꞌ. Senꞌ ndyodiꞌs xaꞌ yalkwinꞌ, jwanꞌna nak xkiꞌs xaꞌ; tak nakwinꞌ toz xaꞌ, xaꞌ nak xud yalkwinꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mbay na, lo ndej na jwanꞌ lipa, naꞌlid lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cho nzo xanya goꞌ toyal koxo'b ke nchap na yalke? Nde tez li jwanꞌ ndej na, ¿Cho kwan liy naꞌlid lazoꞌ goꞌ na sa? ");
INSERT INTO ztp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Men jwanꞌ nak xinꞌ Dios, xkiꞌs Dios nchon xaꞌ; Jwanꞌ nasa nanchonta goꞌy, tak naꞌnakta goꞌ xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zyasa mkab re xaꞌ judí nde nchab xaꞌ lo Jesus: —Cho nawenka mbez náꞌ, leꞌ lu nak Xaꞌ lo xyon Samaria, nde xbi chanꞌ maxuꞌ ndonoa. ");
INSERT INTO ztp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Leꞌ Jesus mkab lo xaꞌ: —Naꞌndonot na xbin maxuꞌ, cheꞌla leꞌn nxoꞌbyek Xud na; nde goꞌ naꞌnxobyekta goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naꞌnkwanta na yalnaro chanꞌ na, per nzo Xaꞌ nkwanꞌna nde Xaꞌ ya nyaꞌb kwent. ");
INSERT INTO ztp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Di's gal' nipa na lo go', men jwanꞌ kosaꞌ xkiꞌs na, na'wi'da xa' yalguj. ");
INSERT INTO ztp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Zyasa re xaꞌ judí nchab lo Jesus: —Naya mne náꞌ xbi chanꞌ maxuꞌ ndonoa. Abraham nde reta xaꞌ jwanꞌ mni Dios lonꞌ pola sa mdej xaꞌy lo men, nguj xaꞌ, nde lu mbez: “Men jwanꞌ xo'byek xkiꞌs na naꞌwi'da xaꞌ yalguj.” ");
INSERT INTO ztp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Cho mas naro nak la lo Abraham xaꞌ gox lo náꞌ ngo pola nde nguj xaꞌ? Nde noga re profet, nguj xaꞌ. ¿Cho men ro nak la ndyak la? ");
INSERT INTO ztp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus mkab lo xaꞌ: —Tez li naron leꞌga na, naꞌndakta yalnaro chanꞌ na; Xud na nak Xaꞌ jwanꞌ ndli naron, Xaꞌ ta mbez goꞌ nak Dios goꞌ ba. ");
INSERT INTO ztp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Leꞌ goꞌ, naꞌnzolod goꞌ Xaꞌ, benꞌta na nzolon Xaꞌ, nde tez gab na lo goꞌ naꞌnzolot na Xaꞌ, ngekwinꞌ na xaja nak re goꞌ ba. Per na, nzolon Xaꞌ nde ngosaꞌn xkiꞌs Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham xaꞌ gox ngo pola, nale toz ngo lazoꞌ xaꞌ wiꞌ xaꞌ wiz yal na; nde mbwiꞌ xaꞌy, nale toz ngo lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zyasa nchab re xaꞌ judí lo Jesus: —Teraꞌ yoa chopsiꞌ linꞌ ¿Nde mbwiꞌa la Abraham? ");
INSERT INTO ztp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus nchab lo xaꞌ: —Gal' di's nipa na lo go', senꞌ teraꞌ gal Abraham ndola na zya. ");
INSERT INTO ztp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Zyasa mxen re xaꞌ ke keꞌ xaꞌ cho Jesus, leꞌ Jesus mkaꞌslo nde mbroꞌte Jesus tenꞌ ndob yodoꞌ; nde mbriꞌd Jesus xij reta xaꞌ, nda Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Senꞌ ndaridnda'b Jesus, mbwiꞌ Jesus ti mbiꞌ xata ngol xaꞌ nkow lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Leꞌ re xinꞌ teꞌd Jesus mnabdiꞌs lo Jesus, nchab xaꞌ: —Maestr, ¿Cho kwan ndliy sa xata ngol mbiꞌ reꞌ nkow lo xaꞌ? ¿Cho leꞌga xken xaꞌy ota xken xud xaꞌy? ");
INSERT INTO ztp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus mkab: —Naꞌnakte xken xaꞌ nekla xken xud xaꞌ, ta ngol xaꞌ sa ryoꞌxob yalnaro jwanꞌ li Dios lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Laj benꞌ nani nya nakinꞌ lin rsinꞌ Xaꞌ jwanꞌ mtelꞌ na; tak senꞌ nde yalꞌ ngenta cho ke sinꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Laj ngete'n xij re men lo izyo, nak na xni lo reta men. ");
INSERT INTO ztp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Senꞌ ngolo ta nchab Jesus, mzuk Jesus izyo nde mbli ben Xaꞌ lud yo kon xit suk Xaꞌ, nde mdaꞌb Xaꞌ ben xis rop ngudlo mbiꞌ ta naꞌngwiꞌda ya. ");
INSERT INTO ztp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nde nchab Jesus lo mbiꞌ: —Wa ptach ngudloa nit nzo lenꞌ tank Siloé, diꞌs ya nak, Xaꞌ mtelꞌ na. Zyasa ngwa mbiꞌ, mtach xaꞌ ngudlo xaꞌ nde senꞌ mbere xaꞌ, nawe ngwiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Zyasa re men jwanꞌ nzo gax cho liz xaꞌ nde re men jwanꞌ mbwiꞌ nkow lo xaꞌ neraꞌ, ndolo nchab men: —¿Cho naꞌnakta xaꞌ reꞌ ta thiblaꞌ ndyob nyaꞌb gona? ");
INSERT INTO ztp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pla xaꞌ nchab: —Xaꞌ reꞌy. Nde tipla xaꞌ nchab: —Taxa nya xaꞌ. Leꞌ mbiꞌ ya nchab: —Na jwanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nde nchab re men lo xaꞌ: —¿Xomodka toyal wiꞌa sa? ");
INSERT INTO ztp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Leꞌ mbiꞌ mkab nde nchab mbiꞌ lo xaꞌ: —Xaꞌ ta ndole Jesus, Xaꞌ ya mtoxkwaꞌ lud ben nde mdaꞌb Xaꞌy xis rop ngud lon, nde ne Xaꞌ: “Waꞌ Siloé, nde ptach ngudloa.” Zya ngwan nde mtach na ngudlon nde zyasa mxoyal ngwiꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Zyasa nchab re men lo xaꞌ: —¿Ma Xaꞌ ya? Leꞌ mbiꞌ ya nchab: —Naꞌnyet nay. ");
INSERT INTO ztp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Zyasa mbeꞌ xaꞌ mbiꞌ ta ngok men mkow lonꞌ ya lo re xaꞌ fariseo. ");
INSERT INTO ztp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tak le'xa wiz jwanꞌ ndryoxkwen men senꞌ ta mdoxkwaꞌ Jesus ben nde mtodanꞌ Jesus ngudlo mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jwanꞌ nasa, re xaꞌ fariseo bere mnabdiꞌs xaꞌ lo mbiꞌ ya nyenꞌ xomod mxyalꞌ ngudlo mbiꞌ. Leꞌ mbiꞌ ya nchab lo xaꞌ: —Lud ben mdaꞌb Xaꞌ rop ngudlon, xisa mtach nay, nde naya ngwiꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Zyasa pla xaꞌ fariseo nchab: —Mbiꞌ ya, pa ak Xaꞌ men mbroꞌ lo Dios, tak naꞌnxobyekta Xaꞌ wiz ndryoxkwen men. Leꞌ tipla xaꞌ nchab: —¿Xomod ti men nzoꞌb xkenꞌ toyal li yalnaro? Nde anta chepa ngok xgab reta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Zyasa bere nchab xaꞌ lo mbiꞌ ta naꞌakta wiꞌ neraꞌ: —¿Cho kwan nyea, cho Xaꞌ ta mbli mxyalꞌ ngud loa ba? Leꞌ mbiꞌ ya nchab: —Xaꞌ ya nak ti mbiꞌ ni Dios lonꞌ sa ndej Xaꞌy lo men. ");
INSERT INTO ztp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per re xaꞌ judí naꞌndlid lazoꞌ xaꞌ cho mbiꞌ ya ta nkow lonꞌ neraꞌ nde naya ngwiꞌ xaꞌ, zyasa axta mbrez xaꞌ rop ta xud mbiꞌ ta mxyalꞌ ngud lon ya. ");
INSERT INTO ztp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nde mnabdiꞌs xaꞌ lo rop ta mena, nchab xaꞌ: —¿Cho xaꞌ reꞌ ta nak xinꞌ goꞌ ya, xaꞌ ta mbez goꞌ xata ngol xaꞌ nkow lo xaꞌ? ¿Xomodka naya ngwiꞌ xaꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Zyasa mkab rop ta xaꞌ nak xud mbiꞌ ya, nchab xaꞌ: —Mne náꞌ, xinꞌka náꞌ nak mbiꞌ reꞌ, nde xata ngol xaꞌ nkow lo xaꞌ; ");
INSERT INTO ztp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per naꞌnyet náꞌ xomod sa ngwiꞌ xaꞌ naya nde naꞌnchenta cho mbli sa mxyalꞌ ngud lo xaꞌ. Per gox la xaꞌ, leꞌ mnabdiꞌs goꞌ lo xaꞌ, xaꞌ toyal teja lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamod nchab rop ta xud mbiꞌ ya tak nzyeb xaꞌ re xaꞌ nak sinꞌ lo men judí, tak re xaꞌ judí mbyanꞌdiꞌsla xaꞌ, nchab xaꞌ; tez nzo men tej leꞌ Jesus nak Xaꞌ mtelꞌ Dios, kote xaꞌ men ya lenꞌ yo tenꞌ ndyop men Israel. ");
INSERT INTO ztp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jwanꞌ nasa nchab rop ta mena: “Narola xaꞌ, mnabdiꞌs goꞌ lo xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Zyasa bere mbrez xaꞌ mbiꞌ ta nkow lonꞌ neraꞌ, nde nchab xaꞌ lo mbiꞌ: —Dios ndowiꞌ, ptaꞌ kwent galꞌ lo náꞌ; tak mne náꞌ, nzoꞌb xken Xaꞌ ta ndej la ba. ");
INSERT INTO ztp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Zyasa mkab mbiꞌ ya, nchab mbiꞌ: —Tez nak Xaꞌ men nzoꞌb xken naꞌ, naꞌnyet na jwanꞌna; jwanꞌ mnen nak, pola nkow lon, per naya toyal wiꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Zya mnabdiꞌs xaꞌ lo mbiꞌ ya tedib gob: —¿Cho kwan mblino Xaꞌ ya lu? ¿Xomod mbli Xaꞌ sa ngoni loa? ");
INSERT INTO ztp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Leꞌ mbiꞌ mkab lo xaꞌ: —Mdejla nay lo goꞌ, per nancholaꞌsta goꞌ ngon goꞌy. ¿Cho kwan ndliy sa ncholaꞌs goꞌ gon goꞌy tedib gob? ¿Cho no goꞌ ncholaꞌs ak xinꞌ teꞌd Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Zyasa mbrezno xaꞌ mbiꞌ ya, nde nchab xaꞌ: —Lu ta nak xinꞌ teꞌd Xaꞌ ya; per náꞌ, xiꞌn teꞌd Moisés nak náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mne náꞌ, Dios mniga lo Moisés pola; per Xaꞌ ta ngeteba, naꞌnyed náꞌ plo mbroꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mkab mbiꞌ ya nde nchab mbiꞌ lo xaꞌ: —¡Nzoyen men jwanꞌ reꞌ! Tak goꞌ, naꞌnyed goꞌ plo mbroꞌ Xaꞌ nde leꞌ na, mxalꞌ Xaꞌ ngud lon. ");
INSERT INTO ztp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nde mnenꞌ, leꞌ Dios naꞌnchonta Xaꞌ xkiꞌs ti men nzoꞌb xken naꞌ; per tez ti men nzeb lazoꞌ xaꞌ Dios, nde ndli xaꞌ jwanꞌ ncholas Dios, xkiꞌs xaꞌ ya nchon Dios. ");
INSERT INTO ztp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Axta pola nanchonta men yo ti xaꞌ nxalꞌ ngudlo ti men nkow lonꞌ xata ngol men. ");
INSERT INTO ztp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tezka naꞌnakta Dios mtelꞌ mbiꞌ reꞌ, ngen cho kwan ak li Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Zyasa mkab re xaꞌ lo mbiꞌ ya nde nchab xaꞌ: —¡Xata ngol la nzoꞌb xken la! ¿Nde ncholaꞌs la toteꞌd la náꞌ? Nde thiptane mbloꞌte xaꞌ mbiꞌ ya lenꞌ yo tenꞌ nteꞌd xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mbin Jesus mbloꞌte xaꞌ mbiꞌ ta mxyalꞌ lonꞌ ya; nde senꞌ mzyalꞌ Jesus mbiꞌ ya, nchab Jesus lo mbiꞌ: —¿Cho ndli lazoꞌa Xinꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Leꞌ mbiꞌ ya mkab nde nchab mbiꞌ: —¿Cho Xaꞌ, sa li lazoꞌn Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus nchab lo xaꞌ: —Xaꞌ ya ndowiꞌa naya, leꞌ Xaꞌ ta ndodiꞌsnoa reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Zyasa nchab mbiꞌ ya: —Ndli lazoꞌn lu, Xaꞌ Nyebeꞌ. Nde mdoxub mbiꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Leꞌ Jesus nchab lo xaꞌ: —Ndal na lo izyo sa nyaꞌb na kwent lo re men, sa re men nkow lonꞌ, wiꞌ xaꞌ, nde re men jwanꞌ ngwiꞌ, kow lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Zyasa pla xaꞌ fariseo jwanꞌ ndo tya, senꞌ lo mbin xaꞌ jwanꞌ reꞌ, nchab xaꞌ lo Jesus: —¿Cho noga náꞌ nak men nkow lonꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus mkab lo xaꞌ: —Tez ngak goꞌ men nkow lonꞌ, pa keno goꞌ xken goꞌ; per naya ta mbez goꞌ ngwiꞌ goꞌ, jwanꞌ nasa nzoꞌb xken goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Zyasa nchab Jesus: —Nipa na lo go', xaꞌ jwanꞌ naꞌnchoteda tenꞌ nge yala ro yalo chanꞌ mbakxilꞌ, xagaꞌ tenꞌ nchote xaꞌ, xaꞌ ya nak wanꞌ nde xaꞌ xkap. ");
INSERT INTO ztp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Leꞌ xaꞌ nchote tenꞌ nge yala ro yalo, xaꞌ ya nak xaꞌ ngenap mbakxilꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Leꞌ xaꞌ jwanꞌ ngenap ro yala chanꞌ yalo, nxalꞌ xaꞌy lo xaꞌ jwanꞌ ngenap mbakxilꞌ nde re mbakxilꞌ ntakbeꞌ maꞌ xkiꞌs xaꞌ, nde ndej xaꞌ thiba le mbakxilꞌ, nde ngote xaꞌ maꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Senꞌ ngolo mbloꞌte xaꞌ re manꞌ xa', zya mbiblo xaꞌ lo maꞌ, nde ndyonke maꞌ xis xaꞌ tak ntakbe' maꞌ xki's xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per xaꞌ jwanꞌ naꞌnzolod maꞌ, naꞌtyonked maꞌ xis xaꞌ, nxyonꞌ maꞌ lo xaꞌ, tak naꞌntakbe'd maꞌ xkiꞌs xaꞌla men. ");
INSERT INTO ztp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kwent nabix reꞌ mni Jesus lo re men; per naꞌngyenta xaꞌ xamod nak jwanꞌ ndej Jesus lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zya bere nchab Jesus lo re xaꞌ tedib gob: —Nipa na lo goꞌ: Na nak yala chanꞌ re mbakxilꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Reta xaꞌ jwanꞌ mbyeꞌd senꞌ lo tera yal na, xaꞌ ya nak xaꞌ wanꞌ nde xaꞌ xkap; per naꞌngonta re mbakxilꞌ xkiꞌs xa'. ");
INSERT INTO ztp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na nak yala, men jwanꞌ yote tenꞌ ndon, tlaꞌ xaꞌ. Nde men ya ak xaja mbakxilꞌ ta nchote maꞌ nde ndryoꞌte maꞌ sa nzyal maꞌ yix naye. ");
INSERT INTO ztp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Leꞌ xaꞌ wanꞌ, benꞌta ndeli wanꞌ xaꞌ, kuj xaꞌ men nde tolux xaꞌ men; leꞌ na, ndal na sa keno men yalnaban nde sa brotosa keno men. ");
INSERT INTO ztp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na nak Xaꞌ nabeꞌz ngenap mbakxilꞌ. Tak Xaꞌ jwanꞌ nabeꞌz ngenap maꞌ, ndayaꞌ Xaꞌ yalnaban chanꞌ Xaꞌ por re mbakxilꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Leꞌ xaꞌ nchax nka, nakta xaꞌ men ngenap mbakxilꞌ, tak naꞌnakte mbakxilꞌ xaꞌ, senꞌ lo mne xaꞌ nde lob, ndlaꞌ xaꞌ re mbakxilꞌ nde nxyonꞌ xaꞌ, zyasa nkeꞌ loba cho mbakxilꞌ nde nchaꞌz lob reta maꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jwanꞌ nasa leꞌ xaꞌ nchax nka nxyonꞌ xaꞌ, tak benꞌta nkelo xaꞌ yax ka xaꞌ, nde nandyod xaꞌ re mbakxilꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Na nak Xaꞌ nabeꞌz ngenap mbakxilꞌ nde nzolon re mbakxilꞌ na nde tagaꞌ re mbakxilꞌ na nzolo maꞌ na ");
INSERT INTO ztp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","’Ta xa nzolo Xud na na, taga nzolon Xud na, nde tayan yalnaban chanꞌ na por re mbakxilꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ngenon tipla mbakxilꞌ jwanꞌ naꞌnzoda yalo reꞌ; no re maꞌ ya ndablo yaxin, nde gon maꞌ xkiꞌs na sa thipta yalo yo re maꞌ nde thipta Xaꞌ kenap maꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Jwanꞌ nasa nkeꞌ lazoꞌ Xud na na, tak tayan yalnaban chanꞌ na nde bere kayane tedib gob. ");
INSERT INTO ztp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ngenta cho kib yalnaban chanꞌ na, cheꞌla leꞌga na tayay. Tak ngenon yalne tayane nde ngenon yalne sa kayane tedib gob. Yalnyebeꞌ reꞌ mdaꞌ Xud na lon mkayan. ");
INSERT INTO ztp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zyasa bere ngok rol re xaꞌ judí tedib gob senꞌ mbin xaꞌ diꞌs reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Naꞌr toz xaꞌ nchab: —Mbi narax nzo lazo' Xaꞌ, ncholꞌ yek Xaꞌ ¿Cho kwan liy ndli lazo' goꞌ Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Leꞌ ti pla xaꞌ nchab: —Naꞌtaꞌda nak mod ndyodiꞌs xaꞌ jwanꞌ nzo mbi narax lozon'. ¿Cho tli mbi naraxa gan xyalꞌ ngudlo ti men jwanꞌ na'ngwida? ");
INSERT INTO ztp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Be' sen' nxyo'b yop, yez Jerusalen tya re xa' judí nzi li xaꞌ ni chanꞌ yodoꞌ jwan' nte'la's xa' lo mdaya' xa' yodo' lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Leꞌ Jesus ngete plo ndob yodoꞌ, tenꞌ ndaꞌb koredor chanꞌ Salomón. ");
INSERT INTO ztp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zyasa re xaꞌ judí mtowꞌ xaꞌ lo Jesus nde nchab xaꞌ: —¿Axta pol ndlia xgab tej la jwanꞌ galꞌ lo náꞌ? Tez luga nak Crist, galꞌ pteja lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus mkab lo xaꞌ: —Leꞌy nia na lo goꞌ nde naꞌndlid lazoꞌ goꞌy. Leꞌ re jwanꞌ ndlin kon yalnyebeꞌ chanꞌ Xud na, jwanꞌna ndej kwent chanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Per naꞌlid lazoꞌ goꞌy, tak naꞌnakta goꞌ mbakxilꞌ na, ta xa niga na lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Leꞌ re mbakxilꞌ na nxo'b yek or xki's na, nzolor na, nde ndyonker xis na, ");
INSERT INTO ztp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","nde na nda yalnaban adiꞌ lor; sa thiptane naluxta or, nde ngen cho kib or lo yaꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xud na jwanꞌ mdaꞌ re mbak xil' reꞌ lon nde naro toz nak yalne chanꞌ Xud na, ngen cho kib rer lo yaꞌ Xud na. ");
INSERT INTO ztp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na nde Xud na thita náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Zyasa re xaꞌ judí bere mxen xaꞌ ke tedib gob sa gadke xaꞌ Jesus, ");
INSERT INTO ztp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Leꞌ Jesus nchab lo xaꞌ: —Naꞌr re sin' wen jwan' mbro' lo Xud na mbloꞌn lo goꞌ; ¿Xanya thi jwanꞌna nak yalke sa gadke goꞌ na? ");
INSERT INTO ztp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zya mkab re xaꞌ judí, nchab xaꞌ: —Naꞌgadked náꞌ lu por re jwanꞌ wen ndlia, gadke náꞌ lu tak narax nia xis Dios; men nak la nde mbez la Dios nak la. ");
INSERT INTO ztp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus mkab lo xaꞌ: —¿Cho na'ngenida lo ley goꞌ: “Na nchab, leꞌga goꞌ dios nak go'? ");
INSERT INTO ztp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nde mne wen goꞌ leꞌ jwanꞌ ngeni lo ley naꞌnyeda kiꞌs mena, jwanꞌ nasa tez yub Dios, dios mblole Xaꞌ re men jwanꞌ mkayaꞌ xkiꞌs Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Cho kwan ndliy sa mbez goꞌ: Nixin na xis Dios senꞌ ndej na lo men leꞌ na nak Xinꞌ Dios? Nde Dios jwanꞌ mbli nayon Xaꞌ na nde mtelꞌ Xaꞌ na lo re men nzi lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tez naꞌndlít na re jwanꞌ ndli Xud na, naꞌlid lazoꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per tez ndli nay, nde teꞌnye naꞌlid lazoꞌ goꞌ na, masa bli lazoꞌ goꞌ re jwanꞌ ndlin, sa yolo goꞌ nde li lazoꞌ goꞌ leꞌ Xud na ndono na nde na ndono Xud na. ");
INSERT INTO ztp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Zya bere ncholaꞌs xaꞌ nden xaꞌ Jesus, per mblyaꞌ Jesus lo yaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yaja mbere Jesus tedib lad ro yoꞌ Jordán, plo tenꞌ mblole ner Juan men; nde tya mbyanꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nde bro toz men mbyeꞌd lo Jesus tya, nde nchab men: —Juan, liga, nek thib yalnaro namblid xaꞌ, per reta jwanꞌ ta mdej Juan kwent chanꞌ Xaꞌ reꞌ, liy. ");
INSERT INTO ztp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nde bro toz men mbli lazo xaꞌ Jesus tya. ");
INSERT INTO ztp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nzo ti mbiꞌ nayiz ndole Lazáro. Leꞌ xaꞌ nzo yez Betania kon Marí nde Mart ptanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Marí ptan' Lazáro ta nayiza, ngol re' ta mdaꞌb nit naxeꞌ xis ni Xaꞌ Nyebeꞌ nde kon yis yek ngol mkwiꞌs ngol ni Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Zyasa mtelꞌ rop bel ngol diꞌs lo Jesus, nchab ngol: —Xaꞌ Nyebeꞌ, nayiz xaꞌ ta nkeꞌ toz lazoꞌa ya. ");
INSERT INTO ztp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Senꞌ mbin Jesus jwanꞌna, nchab Jesus: —Yiz reꞌ naꞌnakte sa gaj xaꞌ, leꞌy loꞌ yalnaro chan Dios. nde loꞌy yalnaroꞌ chanꞌ Xin Dios. ");
INSERT INTO ztp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nde nkeꞌ toz lazoꞌ Jesus Mart, Marí nde Lázaro, ");
INSERT INTO ztp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","senꞌ mbin Jesus nayiz Lázaro, benꞌ mbled Jesus ti chop wiz tenꞌ ngetega Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nde senꞌ ngolo rop wiz ya, zya nchab Jesus lo re xinꞌ teꞌd Xaꞌ: —Ndanꞌ lo xyon Judea tedib gob. ");
INSERT INTO ztp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Leꞌ re xinꞌ teꞌd Xaꞌ nchab lo Xaꞌ: —Maestr, cho naꞌngwid la, tya leꞌ re xaꞌ judí ncholaꞌs xaꞌ gadke xaꞌ lu, ¿nde bere ndaa tya tedib gob? ");
INSERT INTO ztp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Leꞌ Jesus mkab lo xaꞌ: —¿Cho nangenoda wiz tib sen hor? Men jwan' ngete ndlyabe, nachepta men, tak xni wiꞌs ntoxni lo men; ");
INSERT INTO ztp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per xaꞌ jwanꞌ ngete yalꞌ, ncheb xaꞌ, tak naꞌndod xaꞌ lo xni. ");
INSERT INTO ztp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Senꞌ mne nchab Jesus jwanꞌ reꞌ, zya bere nchab Jesus lo xaꞌ tedib gob: —Naxyat Lázaro xa' nsal'tan'; per ndan sa goxkalꞌ na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Leꞌ re xinꞌ teꞌd Jesus nchab: —Xaꞌ Nyebeꞌ, tezka naxyat xaꞌ, tyak xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nde leꞌ Jesus ndej liga nguj Lázaro; per re xinꞌ teꞌd Jesus mbli xa' xgab benꞌta naxyat Lázaro. ");
INSERT INTO ztp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Zyasa galꞌ nchab Jesus lo xaꞌ: —Nguj Lazaro. ");
INSERT INTO ztp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nde nale nzo lazoꞌn por go' tak naꞌndot na tya, nde mas jwina par goꞌ sa toyal li lazoꞌ goꞌ na, naya ndanꞌ tenꞌ nax xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Leꞌ Max, xaꞌ ni men Kwach, nchab xaꞌ lo ta teꞌd xaꞌ: —Ndankenꞌ xis Jesus, sa thita gaj naꞌ kon Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Senꞌ mzin Jesus, zya ngokla thap wiz ndate mbwaꞌs Lázaro. ");
INSERT INTO ztp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Leꞌ yez Betania gax naxa cho yez Jerusalén, nzoy masraꞌ chop mil narol metr. ");
INSERT INTO ztp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nde bro toz xaꞌ judí nda lo nale xaꞌ lazoꞌ Mart nde Marí lo ta nguj ptanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Senꞌ lo mbin Mart ndozinla Jesus, zya ngwaxi' ned Mart Jesus; leꞌ Marí mbyanꞌ yo. ");
INSERT INTO ztp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Zyasa nchab Mart lo Jesus: —Xaꞌ Nyebeꞌ, ngaka ndoa ncheꞌ, naꞌngajta ptanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nde naya mnen, reta jwanꞌ nyaꞌb la lo Dios, Dios taꞌy loa. ");
INSERT INTO ztp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus nchab lo Mart: —Leꞌ ptanꞌ la ryoꞌxban. ");
INSERT INTO ztp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mart mkab lo Jesus: —Mnen troꞌxbanka xaꞌ senꞌ ryoꞌxban reta xaꞌ nguj lo yoxo'b wiz blus jwan'. ");
INSERT INTO ztp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus nchab lo Mart: —Na ngoꞌxban men nde na nda yalnaban; men jwanꞌ li lazonꞌ na, tenye ngujla xaꞌ, tban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nde reta men jwanꞌ naban nde ndli lazoꞌ xaꞌ na, xaꞌ ya naꞌgajta. ¿Cho ndli lazoꞌa jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mart nchab: —Ta naka Xaꞌ Nyebeꞌ, ndli lazoꞌn leꞌ lu nak Crist, Xinꞌ Dios, Xaꞌ nakwentla yeꞌd lo izyoꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Senꞌ ngolo nchab Mart jwan' re', zya ngwaxiꞌ Mart Marí nde nagaꞌsta nchab Mart lo Marí: —Leꞌ Maestr ndo ncheꞌ nde ngebez Xaꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Senꞌ mbin Marí jwanꞌna, naxax toz mdoli Marí nde nda Marí lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Leꞌ Jesus teraꞌ yote Xaꞌ lenꞌ yez, benꞌ ndo Xaꞌ ned tenꞌ ngoxi' ned Mart Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Leꞌ re xaꞌ judí ta nzi liz Marí nde nziliben xa' Marí, senꞌ lo mbwiꞌ xaꞌ naxax mdoli Marí nde mbroꞌte Marí le, zyasa mdonke re xaꞌ xisa, tak mbli xa' xgab, ro baꞌ ndayonꞌ Marí. ");
INSERT INTO ztp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Senꞌ mzin Marí lo Jesus, zya mdoxub Marí lo ni Jesus, nchab Marí: —Xaꞌ Nyebeꞌ, tez ngaka ndoa ncheꞌ, naꞌngajta ptanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Senꞌ mbwiꞌ Jesus nchonꞌ Marí nde noga re xaꞌ judí ta nzi li ben rop bel ngol nchonꞌ re xaꞌ, zyasa dib Xaꞌ mden'na nde mbra'syo'b Xa', ");
INSERT INTO ztp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","sa nchab Jesus lo xaꞌ: —¿Plo mkaꞌs goꞌ xaꞌ? Leꞌ re xaꞌ nchab: —Xaꞌ Nyebeꞌ, deꞌ sa wiꞌa ploy. ");
INSERT INTO ztp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nde mbinꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Zyasa nchab re xaꞌ judí: —¡Bwiꞌ goꞌ, plopa nkeꞌ lazoꞌ Xaꞌ Lázaro! ");
INSERT INTO ztp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Leꞌ tipla xaꞌ nchab: —Xaꞌ reꞌ mbli mbwiꞌ mbiꞌ ta nkow lonꞌ ya, ¿Cho naꞌngakta ndli Xaꞌ ti jwanꞌ sa naꞌngajta Lázaro? ");
INSERT INTO ztp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zyasa nabil toz ngo lazoꞌ Jesus tedib gob, mbike Jesus gax ro baꞌ. Leꞌ baꞌ naka ti yer lad ke nde tagaꞌ kon ti ke nowꞌa. ");
INSERT INTO ztp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Leꞌ Jesus nchab lo xaꞌ: —Pkib goꞌ ke. Leꞌ Mart ptanꞌ thabol, nchab: —Xaꞌ Nyebeꞌ, nakapla ndyaꞌ xaꞌ, tak ndatela tap wiz nguj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus nchab: —¿Cho naꞌnit na loa, tez tli lazoꞌa, twiꞌa yalnaro chanꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Zyasa mkib xaꞌ ke nowꞌ ro baꞌ tenꞌ mkaꞌs xaꞌ thabol. Leꞌ Jesus mbwiꞌ lo beꞌ nde nchab Jesus: —Xud na, ndan dyux loa tak mbin la xkiꞌs na. ");
INSERT INTO ztp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nde mnea na, lu thibla nchon la xkiꞌs na; per mbez na jwanꞌ reꞌ loa por re men ta nzi ncheꞌ, sa li lazoꞌ xaꞌ leꞌ lu mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Senꞌ ngolo ta nchab Jesus lo Dios, zya ne mbrez Jesus, nchab Xaꞌ: —¡Lázaro, deꞌ le reꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Zyasa leꞌ xaꞌ ta nguja, mbroꞌte xaꞌ lenꞌ baꞌ, nachal lar yaꞌ xaꞌ, ni xaꞌ nde dib lo xaꞌ. Jesus nchab: —Pkib goꞌ lar ta nachal xaꞌ, nde ptaꞌ goꞌ diꞌs ya xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zyasa bro toz re xaꞌ judí, xaꞌ jwanꞌ mblo nale lazoꞌ rop bel Marí, mbli lazoꞌ xaꞌ Jesus tak mbwiꞌ xaꞌ jwanꞌ mbli Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per pla xaꞌ nzo xija, ngwaꞌ xaꞌ lo re xaꞌ nak fariseo nde mdej xaꞌ jwanꞌ mbli Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Zyasa re ngwleyꞌ jwanꞌ nyebeꞌ nde re xaꞌ fariseo mthop xaꞌ re men nak sinꞌ lo yez Israel, nde nchab xaꞌ: —¿Cho kwan linꞌ? Tak mbiꞌ reꞌ jwanꞌ toz ndli Xa' re yalnaro. ");
INSERT INTO ztp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tez tatka tanꞌ diꞌs, reta men ndoli lazoꞌ men Xaꞌ; nde tyeꞌd re xaꞌ yez Rom tolu'x xaꞌ yodonꞌ náꞌ nde yez náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Zyasa ti xaꞌ nzo xija ndole Caifás, xaꞌ jwanꞌ nak mbol ngwleyꞌ ro lenꞌ linꞌ ya, nchab xaꞌ: —Ngen kwan mne goꞌ ba, ");
INSERT INTO ztp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","neka ndli goꞌ xgab, yalwen naka lonꞌ thipta mbiꞌ gaj por dib yez, ke reta men yez gaj. ");
INSERT INTO ztp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Diꞌs reꞌ naꞌngolte yek Caifás nde leꞌ xaꞌ nak mbol ngwleyꞌ ro lenꞌ linꞌ ya, jwanꞌ nasa Dios mni lo xaꞌ sa tej xaꞌ lo men leꞌ Jesus gaj por reta men yez. ");
INSERT INTO ztp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nde naꞌnakte benꞌta por reta men yez judi, noga sa thipta dyop re men nak xinꞌ Dios, re xaꞌ jwanꞌ ngetendraꞌs. ");
INSERT INTO ztp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nde xata wiz ya, mbyanꞌdiꞌs re xaꞌ nak sinꞌ lo men judí sa kuj xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jwanꞌ nasa, nangetetra Jesus dibxlaꞌs xij re men judí, mbroꞌte Xaꞌ lo xyon Judea nde nda Xaꞌ gax izyo biz, tenꞌ nax ti yez ndole Efraín. Tya mbyanꞌ Jesus kon re xinꞌ teꞌd Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nde ndoyenla pask, ni chanꞌ re xaꞌ judí; nde bro toz re men nzo yez, mbya xaꞌ Jerusalén senꞌ tera gal ni chanꞌ pask sa tombi lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nkwanꞌ xaꞌ Jesus, lo nzi xaꞌ yodoꞌ nyabdiꞌs xaꞌ lo ta xaꞌ, nchab xaꞌ: —¿Cho xgab ndli goꞌ? ¿Cho nayeꞌdta Jesus lo ni? ");
INSERT INTO ztp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nde re ngwleyꞌ jwanꞌ nyebeꞌ nde re xaꞌ fariseo, mnabeꞌ xaꞌ, tez cho men nye plo ngete Jesus, tej xaꞌy sa yaxen xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Benꞌ ndora xop wiz sa gal ni Pask, Jesus mbyeꞌd yez Betania, tenꞌ nzo Lázaro, xaꞌ jwanꞌ nguj nde mbroꞌxban xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nde tya mdoxkwaꞌ xaꞌ thi rsyeꞌ par Jesus; Mart ngo jwanꞌ mes, nde Lázaro nzo xij re xa' ta ndob ro mes kon Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Zyasa mxen Marí mer nye rol litr perfum jwan' naksa' napta aceyt ndole nardo, nde nap toza, zyasa mchub ngola xiꞌs ni Jesus nde mkwiꞌz ngola kon yiꞌs yek ngol. Nde dib lenꞌ yo mbryaꞌs naxeꞌ ndya' perfum. ");
INSERT INTO ztp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Leꞌ ti xinꞌ teꞌd Jesus ndole Judas Iscariot xinꞌ Simón, xaꞌ jwanꞌ tayaꞌ Jesus, nchab xa': ");
INSERT INTO ztp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Xana' ntho men perfum reꞌ nde ndaꞌy tmi jwanꞌ ndli men gan dib thi linꞌ nde tmi ya ndaꞌ men lo re xaꞌ prob? ");
INSERT INTO ztp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naꞌnchapta Judas jwanꞌ reꞌ tak liga nkeꞌ lazoꞌ xaꞌ re men prob, taja nchab xaꞌ tak leꞌ xaꞌ nak xaꞌ wanꞌ, ma leꞌ xaꞌ ntobsaꞌ tmi nde ndyen xaꞌ tmi jwanꞌ ndlya. ");
INSERT INTO ztp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Zyasa nchab Jesus: —Ptaꞌ diꞌs sa li ngola, tak wiz gaꞌs na mblosaꞌ ngol jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tak re xaꞌ proba thibka nzino goꞌ xaꞌ, leꞌ na ludla tyono goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bro toz xaꞌ judí mbin leꞌ Jesus nzo yez Betania, nde re xaꞌ mbyeꞌd tya, naꞌmbyeꞌdta xaꞌ benꞌta sa wiꞌ xaꞌ Jesus, noga mbyeꞌd xaꞌ sa wiꞌ xaꞌ Lázaro, xaꞌ ta mbloꞌxban Jesus xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Per re ngwleyꞌ jwanꞌ nyebeꞌ mbyanꞌdiꞌs xaꞌ noga Lázaro kuj xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tak xke Lázaro sa bro xaꞌ judí mblaꞌ xaꞌ re ngwleꞌy nde ndli lazoꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tedib wiz, bro toz men jwanꞌ nda lo ni pask, senꞌ mbin xaꞌ leꞌ Jesus ndozinla yez Jerusalén, ");
INSERT INTO ztp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","zya mxen xaꞌ ya' yin nde ngwa xiꞌ ned xaꞌ Jesus, nde mdobte mbrez xaꞌ: —¡Naro toz nak Dios! ¡Nayon nak Xaꞌ jwanꞌ ntelꞌ Dios! ¡Rey lo men Israel! ");
INSERT INTO ztp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nde mzyal Jesus ti bur yenꞌ, nde mdob Jesus xis maꞌ; xa nchab lo xkiꞌs Dios: ");
INSERT INTO ztp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Naꞌzyebta lu men nzi yez Sión. Ncheꞌ nde Xaꞌ nak Rey loa, Ndob Xaꞌ xis ti bur yenꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Senꞌ ndoyak re jwanꞌ reꞌ, zya re xaꞌ nak xinꞌ teꞌd Jesus naꞌngyenta xaꞌy; per senꞌ lo ngujla Jesus nde mbroxban Xaꞌ, zyasa mtelaꞌs re xaꞌ nak xinꞌ teꞌd Jesus leꞌ jwanꞌ reꞌ nchable lo xkiꞌs Dios, re jwanꞌ ngote Jesus nde ta ngoka. ");
INSERT INTO ztp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Leꞌ re men jwanꞌ nzi wiꞌ senꞌ mbrez Jesus Lázaro lo nzoa Lázaro lenꞌ baꞌ nde mbloꞌxban Jesus xaꞌ, re men ya ndaꞌ xaꞌ kwent jwanꞌ mbwiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jwanꞌ nasa, reta men nde lo Jesus, tak mbin xaꞌ yalnaro jwanꞌ mbli Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Leꞌ re xaꞌ fariseo nchab xaꞌ lo ta xaꞌ: —Bwiꞌ goꞌ, ngencho kwan ak linꞌ, reta men ndanke xis Xaꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Noga pla xaꞌ gryeg, xaꞌ jwanꞌ ndaꞌ dyux lo Dios, ngoxo'b xaꞌ yez Jerusalén sa nda xaꞌ lo ni. ");
INSERT INTO ztp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Re xaꞌ reꞌ mbike lo Blib, nde Blib nak xaꞌ yez Betsaida lad lo xyon Galilea, nde mnaꞌb xaꞌ lo Blib, nchab xaꞌ: —Xa' nyebe', náꞌ ncholaꞌs wi' Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Zyasa ngwa Blib nde nchab Bliba lo Ndres sa rop xaꞌ ngwayaba lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus mkab lo xaꞌ: —Mzin hor ryoxoꞌb yalnaro chanꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gal' di's nipa na lo go', tez ti mbis trig naꞌyode izyo nde na'gajte, nchanꞌ thiba; per tez yoy izyo nde gaja taꞌy bro toz trig. ");
INSERT INTO ztp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Men jwanꞌ nkeꞌ lazonꞌ yalnaban chanꞌ naꞌ, taꞌb xaꞌy; leꞌ xaꞌ jwanꞌ na'ndyoda yalnaban chanꞌ naꞌ lo re jwan' narax lo izyo, xaꞌ ya ngegosaꞌy lo yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tez cho goꞌ ncholaꞌs li sinꞌ lon, ptonke goꞌ xis na; nde tenꞌ ndon, tya tyo xaꞌ li sinꞌ lon. Tez cho xaꞌ li sinꞌ lon, Xud na li naro xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Nabil toz nzo lazoꞌn naya; ¿Nde cho gab na? ¿“Xud na, ptolaꞌn nal hor reꞌ? Chona jwanꞌ naga mzin na hor re'” ");
INSERT INTO ztp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xud na, bloꞌ plopa naro nak la. Zyasa lo beꞌ mbroꞌ ti diꞌs jwanꞌ mbyen nchab: —Mbloꞌa na yalnaro chanꞌ na, nde bere loꞌ ney tedib gob. ");
INSERT INTO ztp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Zyasa leꞌ reta men toz ta nzi tya mbin xaꞌy nde nchab xaꞌ, mdiꞌ mdez. Leꞌ tipla xaꞌ nchab: —Ti anj chanꞌ Dios mni lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zyasa nchab Jesus lo xaꞌ: —Par goꞌ sa mbyen diꞌs mbroꞌ lo beꞌ ba, nakte par na. ");
INSERT INTO ztp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Naya ngoxoꞌb beꞌ koxyo Dios re men nzi lo izyo nde naya leꞌ maxuꞌ xaꞌ nyebeꞌ lo izyo ryoꞌtal xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nde senꞌ keꞌnga xa' na lo kruz, bez na reta men sa li lazoꞌ xa' na. ");
INSERT INTO ztp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mdej Jesus jwanꞌ reꞌ sa yen re men nyenꞌ xamod gaj Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zyasa mkab reta xaꞌ lo Jesus, nchab xaꞌ: —Mne náꞌ xa nchab lo ley, leꞌ Xaꞌ nak Crist thiptane ban Xaꞌ. ¿Cho kwan liy sa mbez la, leꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo nakinꞌ gaj Xa'? ¿Cho Xaꞌ nak Xinꞌ Mbiꞌ mbyeꞌd lo izyo? ");
INSERT INTO ztp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Zyasa nchab Jesus lo xaꞌ: —Benꞌ nzo xni xij goꞌ ti tud; Pkete goꞌ naya laj benꞌ ngeno goꞌ xni, sa naꞌlyada yalꞌkow lo goꞌ; tak xaꞌ jwanꞌ ngete lo yalꞌkow naꞌnyed xaꞌ plo nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naya ta benꞌ ngeno goꞌ Xaꞌ nak xni, bli lazoꞌ goꞌ Xaꞌ sa ak goꞌ xinꞌ xni, senꞌ ngolo nchab Jesus re jwanꞌ reꞌ, Jesus nda nde mkaꞌslo Xaꞌ lo re men. ");
INSERT INTO ztp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nde tenye mbli Jesus naꞌr toz re yalnaro lo re men, naꞌndlid lazoꞌ xaꞌ Jesus; ");
INSERT INTO ztp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ta sa ak diꞌs mkeꞌ Isaías, xaꞌ jwanꞌ mni Dios lonꞌ pola sa mdej xaꞌy lo men, senꞌ nchab Isaías: Xaꞌ Nyebeꞌ, ¿Cho nzo men mbli lazonꞌ jwanꞌ mdej naꞌ lo xaꞌ? ¿Xanya lo re men mbloꞌ Xaꞌ Nyebeꞌ yalnaro chanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nde jwanꞌ reꞌ ndli sa naꞌndlid re men gan ndli lazoꞌ xaꞌ Jesus, tak noga nchab Isaías: ");
INSERT INTO ztp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mtowꞌ Dios ngudlo re men, sa ngok ne lazoꞌ xaꞌ; sa naꞌakta wiꞌ xaꞌ kon ngudlo xaꞌ, nde naꞌyenta lazoꞌ xaꞌ, bere xaꞌ lon, sa todanꞌ na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Re jwanꞌ reꞌ nchab Isaías, senꞌ mbwiꞌ xaꞌ re yalnaro jwanꞌ keno Jesus nde mdodiꞌs xaꞌ kwent chanꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Te'nyega ta naka, bro toz re xaꞌ nak sinꞌ lo men judí, mbli lazoꞌ xaꞌ Jesus; per xke re xaꞌ fariseo naꞌndejta xaꞌy nzi wiꞌ reta men, sa naꞌkoted xaꞌ xaꞌ lenꞌ yo tenꞌ ndyop men Israel. ");
INSERT INTO ztp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tak mas ndyen xaꞌ yanꞌ xaꞌ wen lo re men ke lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nde ne mni Jesus, nchab Xaꞌ: —Men jwanꞌ ndli lazonꞌ na, naꞌndlid lazoꞌ xaꞌ benꞌta na, noga ndli lazoꞌ xaꞌ, Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nde men jwanꞌ ngwiꞌ na, ngwiꞌ xaꞌ Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Le' na ta nak xni, ndal na lo izyo, sa reta men jwanꞌ ndli lazonꞌ na, naꞌbantra xaꞌ lo yalꞌkow. ");
INSERT INTO ztp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Men jwanꞌ nchon xkiꞌs na nde naꞌnxobyekta xaꞌy, naꞌnakta na nyaꞌb kwent lo xaꞌ; tak naꞌndalta na sa nyaꞌb na kwent lo re men lo izyo, cheꞌla ndal na sa tolaꞌn re men. ");
INSERT INTO ztp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Leꞌ men jwanꞌ ngotal na nde naꞌnxobyekta xaꞌ xkiꞌs na, ngenola xaꞌ cho nyaꞌb kwent lo xaꞌ; re diꞌs jwanꞌ mnin lo xaꞌ, diꞌs ya nyaꞌb kwent lo xaꞌ senꞌ yoxo'b wiz blus. ");
INSERT INTO ztp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tak re jwanꞌ mdodiꞌs na naꞌnakte xkiꞌs na, cheꞌla Xud na, Xaꞌ jwanꞌ mtelꞌ na, Xaꞌ ya mdaꞌ yalnyebeꞌ cho kwan ndablo tej na, nde cho kwan ndablo gab na. ");
INSERT INTO ztp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nde mnen leꞌ yalnyebeꞌ chanꞌ Xud na naka yalnaban adiꞌ. Jwanꞌ nasa, reta jwanꞌ ndyodiꞌs na, ndyodiꞌs nay xata ne Xud na lon. ");
INSERT INTO ztp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Senꞌ tera' gal ni pask, mnela Jesus mzingaxla hor sa ridnda'b Xa' lo izyo re' ndya Xaꞌ lo Xud Xaꞌ. Nde xa mkeꞌ lazoꞌ Xa' re men nak xinꞌ teꞌd Xaꞌ jwan' nzi lo izyo, taxa mkeꞌ lazoꞌ Xa' xaꞌ axta kebe' ngoloy. ");
INSERT INTO ztp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lo senꞌ nzi yarsyeꞌ re xaꞌ, kom le' maxu' mtobla lazoꞌ Judas Iscariot, xinꞌ Simón, sa tayaꞌ xa' Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mnela Jesus leꞌ Xud Xaꞌ mdayaꞌla reta jwanꞌ lo yaꞌ Xaꞌ, tak lo Dios mbroꞌ Xa' nde lo Dios ndya Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","zya ngotoli Xa' lo rsye, mkib Xaꞌ lar nzoꞌb xis Xaꞌ nde mxen Xaꞌ ti tway mbo Xaꞌy rlanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Zyaga mblo Xaꞌ nit lenꞌ ti xyej, nde mdobte mtach Xaꞌ ni re xinꞌ teꞌd Xaꞌ, nde mkwiꞌz Xaꞌy kon tway jwanꞌ nago rlanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Zyasa nde Jesus lo Simón Pedr, nde nchab Pedr lo Xaꞌ: —Xaꞌ Nyebeꞌ, ¿Lu tach nin? ");
INSERT INTO ztp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mkab Jesus nde nchab Xa': — Jwanꞌ ta ngelin reꞌ, pa yen lay naya, tyen lay tsow'xa. ");
INSERT INTO ztp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedr nchab: —Pa ta tir na diꞌs tach la nin. Jesus mkab lo Pedr: —Tez naꞌtachta na nia, naꞌakta la men na. ");
INSERT INTO ztp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Leꞌ Pedr nchab lo Xa': —¡Xa Nyebeꞌ, nanakta benꞌta nin, noga yaꞌn nde yek nay. ");
INSERT INTO ztp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus nchab: —Xaꞌ jwanꞌ ngodla, benꞌta ni xaꞌ nakinꞌ yach, tak nambila dib xaꞌ; Nde goꞌ, nambila goꞌ, teꞌnye naꞌnakta re goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tak mnela Xa' cho jwan' tayaꞌ , jwanꞌ nasa nchab Xa': “Naꞌnakta re goꞌ nambi”. ");
INSERT INTO ztp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Senꞌ ngolo mtach Jesus ni re xinꞌ teꞌd Jesus, mxen Xaꞌ lar jwanꞌ nxyobka xis Xaꞌ nde mbere Xaꞌ ro mes tedib gob nde nchab Xaꞌ lo re xinꞌ teꞌd Xaꞌ: —¿Cho mbyen goꞌ jwanꞌ ta mblin reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Goꞌ, mbez lon, Maestr nde Xaꞌ Nyebeꞌ, wen ta mbez goꞌ, tak liga nak nay. ");
INSERT INTO ztp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na nak Xaꞌ Nyebeꞌ nde Maestr, mtach na ni goꞌ, noga goꞌ ndablo tagaꞌ tach goꞌ ni ta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tak mbloꞌa ney lo goꞌ, jwanꞌ nasa ta xa mblin, taga' bli goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gal' di's nipa na lo go', ti mosa nanakta xa' mas naro lo xwan' xa', nekla ti xaꞌ ndye mandad naxa'da mas naro lo xa' jwan' mtelꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tez mne goꞌ reta jwanꞌ reꞌ, wen toz tir nda goꞌ tez li goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Naꞌndotejta na re goꞌ, mnela na xanya goꞌ mblin. Per nakinꞌka ak jwanꞌ nchab lo xkiꞌs Dios: “Xaꞌ ta ncha pan kon na, xaꞌ ya tayaꞌ na.” ");
INSERT INTO ztp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nal teraꞌ aka tej nay lo goꞌ, sa senꞌ lo ngoka, li lazoꞌ goꞌ, ke Na Nak. ");
INSERT INTO ztp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gal' di's nipa na lo goꞌ, men kayaꞌ xaꞌ jwanꞌ tel na, na ngekayaꞌ xaꞌ, nde leꞌ xaꞌ jwanꞌ nkayaꞌ na, ngekayaꞌ xaꞌ Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ngolo mni Jesus jwanꞌ re', nabil toz ngo lazoꞌ Xaꞌ, nde galꞌ mdej Xaꞌ, nchab Xaꞌ: —Gal' di's nipa na lo goꞌ, thib goꞌ ba tayaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Zyasa re xinꞌ teꞌd Jesus anta mbwiꞌ lo ta xaꞌ, naꞌnyed xaꞌ cho ndotej Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Leꞌ ti xinꞌ teꞌd Xa', xaꞌ jwanꞌ nkeꞌ toz lazoꞌ Jesus, xaꞌ ya nzobke' cho Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lo xaꞌ re', mbli Simón Pedr señ sa nyabdiꞌs xaꞌ lo Jesus nyenꞌ cho ta ndej Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Zyasa xa' ya, nzobke' xa' gax cho Jesus, nchab xaꞌ: —Xaꞌ Nyebeꞌ, ¿choy? ");
INSERT INTO ztp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mkab Jesus: —Lo xa' jwan' tan pan ta gaz na reꞌ, xaꞌ yay. Nde mbwaz Xa' pan, mdaꞌ Xaꞌy lo Judas Iscariot xinꞌ Simón. ");
INSERT INTO ztp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nde ngolo mda Judas ti bro pan, mbla Maxuꞌ xa'. Zyasa nchab Jesus lo xa': —Jwanꞌ ta lia ba, pkenka bliy. ");
INSERT INTO ztp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per nek thib xaꞌ ta nzo'b ro mesa naꞌngyenta xaꞌ kwan liy ta nchab Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tak pla xaꞌ mbli xgab, tak leꞌ Judas nak xaꞌ ndentsaꞌ tmi, jwan' nasa ta nchab Jesus lo Judas: Yati'a jwanꞌ nakinꞌ na' lo ni o ya taꞌa lud tmi ka re men ndyak yalti. ");
INSERT INTO ztp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Senꞌ ngolo ta mda Judas pan, zyaga nda xa' nde mblala yal'. ");
INSERT INTO ztp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Senꞌ lo mbro'te Judas, nchab Jesus: —Naya ndoroxo'b yalnaro chanꞌ Xinꞌ Mbiꞌ, nde Dios ak naro kon jwan' li Xinꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tez Dios ak naro kon jwan' li Xin' Xa', noga Dios li naro Dios Xaꞌ, nde mbyénla li Xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xinꞌ bix na, ben' ndon tud kon goꞌ. Kwanꞌ goꞌ na, per xa nchabka na lo re xaꞌ judí, taga nin lo goꞌ naya: Plo tenꞌ ndan, naꞌlid goꞌ gan tye goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tib yalnyebeꞌ kub tan lo goꞌ: Pkeꞌ lazoꞌ goꞌ ta goꞌ. Ta, xa mkeꞌ lazoꞌn goꞌ, tagaꞌ pkeꞌ lazoꞌ goꞌ ta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kon jwan' re' yolo reta men goꞌ ke go' nak xinꞌ teꞌd na, tez keꞌ lazoꞌ goꞌ ta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Le' Simón Pedr mnabdi's lo Jesus: —Xaꞌ Nyebeꞌ, ¿Plo ndaa? Jesus mkab lo xa': —Plo tenꞌ ndan, naꞌlit la gan tyea xis na naya, per tonkea xis na yoloxaba. ");
INSERT INTO ztp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Leꞌ Pedr nchab: —Xaꞌ Nyebeꞌ, ¿Cho kwan liy sa naꞌnyeda tyonkeꞌn xis la naya? ¡Toyal na axta gaj na por lu! ");
INSERT INTO ztp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Leꞌ Jesus mkab: —¿Nyea lin la gaj la por na? Gal' di's nipa na loa, na'golta ngidte', tezka na'kala'sta lu na tson gob. ");
INSERT INTO ztp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Nazye'd xgab goꞌ, thibla ptob xgab goꞌ lo Dios, noga ptob xgab goꞌ kon na. ");
INSERT INTO ztp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Liz Xud na jwan' toz nzo tenꞌ yo men; tez natada naka, chen seba mdejla nay lo goꞌ, ndyan, sa ndebektsa'n tenꞌ yo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nde tes ndyan nde kwektsa'n tenꞌ yo goꞌ, beren tedib gob, nde le'ga na wen go, sa tenꞌ yon tyagaꞌ yo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mnea goꞌ plo ndan nde nzolo goꞌ ned. ");
INSERT INTO ztp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Leꞌ Max nchab lo Jesus: —Xaꞌ Nyebeꞌ, naꞌnyed náꞌ plo ndaa, ¿Xomod, li ná' gan, nye náꞌ plo nda ned? ");
INSERT INTO ztp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus nchab lo xa': —Na nak ned, na nak lipa, nde na nak yalnaban; ngen cho sin lo Pay, tez na'nakte por na. ");
INSERT INTO ztp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tez ngolo goꞌ na, noga Pay talo go', nde xata naya nzolo goꞌ Xaꞌ nde mbwiꞌ goꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Le' Blib nchab lo Xa': —Xaꞌ Nyebeꞌ, bloꞌ Pay lo náꞌ sa mbli lazoꞌ náꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus nchab: —¿Plopa ndatela ndonon goꞌ, nde teraꞌ yoloa na Blib? Men jwanꞌ mbwiꞌla na, mbwiꞌla xaꞌ Pay; ¿Cho kwan liy sa mbez la: Bloꞌ Pay lo náꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Cho naꞌndlid lazoꞌa, na ndono Pay nde Pay ndono na? Re diꞌs jwanꞌ ndyodiꞌs na, naꞌndyodi'sta nay por kwent chan' na, che'la Pay jwanꞌ nzo ban lenꞌ lazoꞌn, Xaꞌ ndli reta jwa' mbwi' go' mblin. ");
INSERT INTO ztp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bli lazoꞌ goꞌ leꞌ na ndono Pay, nde Pay ndono na; tezka nandlid lazo' go'y, bli lazo' go' na por re jwan' ta mbwi' go' ngok. ");
INSERT INTO ztp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gal' di's nipa na lo go': Men ndli lazonꞌ na, reta jwan' ta mblin, noga xa' ya tak liy, nde mas naro jwanꞌ li xaꞌ, tak na ndya lo Pay. ");
INSERT INTO ztp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nde reta jwanꞌ nyaꞌb goꞌ lo Pay lo len, na liy, sa ak naro Pay por Xin' Xa'. ");
INSERT INTO ztp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tez nzo kwan nyaꞌb goꞌ lo len, na liy. ");
INSERT INTO ztp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tez nkeꞌ lazoꞌ goꞌ na, bxobyek goꞌ re yalnyebeꞌ chanꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nde na nyaꞌb lo Pay, sa Xaꞌ ta' tedib Xaꞌ li ben go' nde la'sto go', Xaꞌ ya tyono goꞌ thiptane: ");
INSERT INTO ztp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Le' Xbi ndlo' jwan' gal', re men lo izyo naꞌlid men gan kayaꞌ men Xa', tak nangwiꞌd men Xa', nekla ncholo men Xa', per goꞌ, nzolo goꞌ Xa', tak nzono go' Xa' nde tyono Xa' go'. ");
INSERT INTO ztp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Naꞌtanptyabta na goꞌ, tberen lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nda'b tiplata wiz, re men lo izyo nawiꞌtra xaꞌ na, per goꞌ twiꞌ goꞌ na, tak na naban na, noga goꞌ tban goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Senꞌ sin wiz ya, yolo goꞌ leꞌ na ndono Pay, nde goꞌ ndono na, nde na ndono goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xaꞌ jwan' nkaya' re yalnyebeꞌ chanꞌ na, nde nxobyek xaꞌy, xaꞌ ya nkeꞌ lazonꞌ na. Nde xaꞌ jwanꞌ nkeꞌ lazonꞌ na, keꞌ lazoꞌ Pay xaꞌ nde noga na keꞌ lazoꞌn xaꞌ nde ryoꞌton lo xa'. ");
INSERT INTO ztp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nchab Judas, (xa' naꞌnakte Iscariote): —Xaꞌ Nyebeꞌ, ¿Cho kwan liy sa benꞌta lo náꞌ ryoꞌtoa nde naꞌryotot la lo reta men lo izyo? ");
INSERT INTO ztp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mkab Jesus nde nchab Xaꞌ: —Men jwanꞌ nkeꞌ lazonꞌ na, xkiꞌs na xo'byek xaꞌ nde keꞌ lazoꞌ Pay xaꞌ, nde rop náꞌ yeꞌd lo xa' nde yono náꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Leꞌ xaꞌ jwanꞌ nankeꞌd lazonꞌ na, nanxobyekta xaꞌ xkiꞌs na. Nde re diꞌs jwanꞌ mbin goꞌ, naꞌnakte xkiꞌs na, che'la xkiꞌs pay naka, Xaꞌ ta mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ndej na re jwan' re' lo goꞌ na ta benꞌ ndon xij goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Leꞌ Xaꞌ jwan' liben goꞌ nde la'sto go', Xa' nak Mbi Nayon, Xa' ta telꞌ Xud na lo len, Xaꞌ loꞌ reta jwanꞌ lo goꞌ nde Xaꞌ te'la's lo goꞌ reta jwanꞌ ta mdej na lo goꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yalnabeꞌz tanon goꞌ, yalnabeꞌz chanꞌ na tan lo goꞌ, naꞌtat nay lo goꞌ jwanꞌ xa ndaꞌ re men lo izyo reꞌy. Naꞌakropta xgab goꞌ, nekla zyeb goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mbinla goꞌ ta nin lo goꞌ: Ndyan, nde bere yal na lo goꞌ. Tez liga nkeꞌ lazoꞌ goꞌ na, ndablo nale ngo lazoꞌ goꞌ, tak nia na lo goꞌ leꞌn bere lo Pay; tak Pay nak Xaꞌ ro lon. ");
INSERT INTO ztp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nde naya axnia nay lo go' nal tera' aka, sa senꞌ lo aka, tli lazoꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Naꞌyentra todi's na masra' jwan' lo goꞌ, tak ndosin gaxla xa' nyebeꞌ lo izyo re', nde naꞌnyebeꞌd xa' ya lon. ");
INSERT INTO ztp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ta sa nye re men lo izyo nkeꞌ lazoꞌn Pay, nde xa mnabe' Pay lon ta mbli ney. Ptoli goꞌ, yaꞌ goꞌ ndanꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Na nak le'pa lus ub, nde Xud na nak Xaꞌ ndlisinꞌna. ");
INSERT INTO ztp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nde re xod na jwanꞌ naꞌkeda ngud, choꞌ Xaꞌy, nde re xod jwanꞌ nke ngud, tombi Xaꞌy, sa taꞌy masraꞌ ngud. ");
INSERT INTO ztp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Leꞌ re goꞌ, nambila goꞌ por re diꞌs jwanꞌ mnin lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Thiblaꞌ ptono goꞌ na, nde taga tyonon goꞌ. Ta xa ti xoda, naꞌakta taꞌy ngud lo le'tay, tez naꞌndobte lad lus, tagaꞌ goꞌ naꞌngen kwan ak li goꞌ tez naꞌndonod goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Na nak lus ub, leꞌ re goꞌ nak xod; xaꞌ jwanꞌ thiblaꞌ ndono na, nde na ndono xaꞌ, xaꞌ re' ndaꞌ bro toz ngud; tak tez naꞌndonod goꞌ na, ngen kwan ak li goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Leꞌ xaꞌ jwanꞌ naꞌndonoda na, ryoꞌtal xaꞌ xaja xod na'ndada ngud, biza, dyopa nde yoy lo ki sa yola. ");
INSERT INTO ztp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tez thiblaꞌ ndono goꞌ na, nde thiblaꞌ ndono goꞌ xkiꞌs na, mnaꞌb goꞌ re jwanꞌ ncholaꞌs goꞌ nde taka lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lo jwan' re' ndli naro goꞌ Xud na, sen' nak go' xaja xod ndaꞌ bro toz ngud, nde tamod ndloꞌ nak goꞌ xinꞌ teꞌdpa na. ");
INSERT INTO ztp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Xa nkeꞌ lazoꞌ Pay na, ta nkeꞌ lazoꞌn goꞌ; thiblaꞌ pto goꞌ lo jwan' nkeꞌ lazoꞌn go'. ");
INSERT INTO ztp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tez xobyek goꞌ re yalnyebeꞌ chanꞌ na, thiblaꞌ tyo goꞌ lo jwan' nke' lazo'n go'; ta xa nxobyek na yalnyebeꞌ chanꞌ Xud na, nde thiblaꞌ ndon lo jwan' nke' lazo' Xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","\"Re jwanꞌ reꞌ nin lo goꞌ, sa yo nale lazo' go' xaja na, sa thiptane keno go' yalnale toz. ");
INSERT INTO ztp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jwanꞌ reꞌ nak yalnyabe' chan' na: Pkeꞌ lazoꞌ goꞌ ta goꞌ, ta xa nkeꞌ lazoꞌn goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ngencho ngeno ti yalke' lazoꞌ mas naro lo jwanꞌ reꞌ, lo tayaꞌ lazo' men gaj men por re men nzalta tos men. ");
INSERT INTO ztp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Goꞌ nak men nsalta tos na, tez li goꞌ re jwanꞌ nyebeꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Naꞌgoletra na goꞌ mos, tak ti mos naꞌnyed jwanꞌ ndli xa' nyebe' lo mos. Golen go' men nsalta toz na tak reta jwanꞌ ne Xud na lon, reta jwanꞌna mdej na lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Naꞌnakta goꞌ mblí na, na mblí goꞌ nde mtob na goꞌ ya goꞌ, ak goꞌ xaja xod ndaꞌ bro toz ngud, nde ngud ya naꞌndluxtay, sa reta jwanꞌ nyaꞌb goꞌ lo Xud na lo len, Xaꞌ taꞌy lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jwanꞌ reꞌ nyebeꞌn lo goꞌ: Pkeꞌ lazoꞌ goꞌ ta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","\"Tez re men lo izyo ngiꞌno xaꞌ goꞌ, ptela's goꞌ, nerla na mbyiꞌno xa' ke goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tez ngak goꞌ men lo izyo re', re men lo izyo keꞌ lazoꞌ xaꞌ goꞌ ta xa nke' lazo' xa' ta xa', per leꞌ goꞌ nanakta men lo izyo, tak na mblí goꞌ xij re men lo izyo, jwanꞌ nasa re men lo izyo ngiꞌno xaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pteꞌlaꞌs goꞌ re diꞌs jwanꞌ nila na lo goꞌ: “Naꞌlalta ntak ti mos kon xaꞌ jwanꞌ nyebeꞌ lo mos.” Tez mchobla xaꞌ na, noga goꞌ chobla xaꞌ; tezka nxobyek xaꞌ xkiꞌs na, noga xkiꞌs goꞌ txobyek xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Reta jwanꞌ reꞌ lino xaꞌ goꞌ por kwent chan' na, tak naꞌnzolod xaꞌ Xaꞌ jwanꞌ mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tez naꞌngyalta na, nde nekla ndodiꞌs na lo re men, na'kenod xaꞌ yalke, per naya nagenpa ro xa' tak nchap xaꞌ yalke. ");
INSERT INTO ztp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Re xaꞌ ngiꞌno na, noga ngino xa' Xud na. ");
INSERT INTO ztp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tez naꞌndlit na xij re men jwanꞌ ngencho ndli, nakenod xaꞌ yalke, per naya mbwiꞌla xaꞌy, jwan' na mbi'no xaꞌ na nde Xud na. ");
INSERT INTO ztp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per jwan' re' ngoka sa taga sa ak diꞌs ngeni lo ley chanꞌ Dios, jwanꞌ nchab: “Ngenta cho yalke mbiꞌno xaꞌ na”. ");
INSERT INTO ztp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Leꞌ senꞌ yeꞌd Xaꞌ ta li ben go' nde la'sto go', Xa' jwan' telꞌ na ryoꞌ tenꞌ ndob Xud na, Xaꞌ ya nak Mbi Nayon lí, yeꞌd loꞌ jwanꞌ gal' lo goꞌ, ryoꞌ Xaꞌ lo Xud na Xa' ya ta' kwent chan' na. ");
INSERT INTO ztp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Noga goꞌ tej ta' kwent chan', tak xata mdobten ndono goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Reta jwanꞌ reꞌ mdej na lo goꞌ sa nayod thi jwan' li cheb go'. ");
INSERT INTO ztp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tak kote xaꞌ goꞌ lenꞌ yo tenꞌ ndyop men Israel nde sin wiz choja mena kuj xaꞌ goꞌ, nde li xa' xgab sin' wen ngeli xa' lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nde jwanꞌ reꞌ lino xa' go' tak naꞌnzolod xaꞌ Pay, nekla nzolo xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Per nin re jwanꞌ reꞌ lo goꞌ, sa sen' sin wiz ya, teꞌlaꞌs goꞌ mdejla na jwanꞌ reꞌ lo goꞌ. ’Naꞌmdejta na jwanꞌ reꞌ lo goꞌ neraꞌ, tak zya ngetenon goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Leꞌ naya ndyan lo Xaꞌ jwanꞌ mtelꞌ na, nde nek thib goꞌ naꞌnyabdiꞌsta lon: \"¿Plo ndyaa?\" ");
INSERT INTO ztp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Cheꞌla, nabil ngo lazoꞌ goꞌ tak nin re jwanꞌ reꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nde kwent lí ndotan lo goꞌ: Mas wen naka lo goꞌ ta ndyan, tak tez naꞌyat na, naꞌyeta Xaꞌ liben go' nde la'sto go', nde tez lenꞌ ndya, tel na Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nde senꞌ sin Xa', ko Xaꞌ yek re men nzi lo izyo, cho men nzoꞌb xkena', cho nambi ndo nde cho xis nzo'b yalnayi' chan' Dios. ");
INSERT INTO ztp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","¿Cho xa' nzo'b xken na? re xa' jwan' naꞌndlid lazon' na, ");
INSERT INTO ztp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","¿cho nambi ndo? Na nambi ndo, tak leꞌn ndya lo Xud na nde naꞌwitra goꞌ na; ");
INSERT INTO ztp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","¿cho xis nzo'bla yalnayi' chan' Dios? xis xaꞌ jwanꞌ nyebeꞌ lo izyo re'y, xa' jwan' nchabla Dios jwan' yote. ");
INSERT INTO ztp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","\"Tata jwanꞌ tozraꞌ nzo tej na lo goꞌ, per naya naꞌlitra' goꞌ gan yen goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Leꞌ senꞌ yeꞌd Mbi Nayon Xaꞌ nak lí nde koned Xaꞌ goꞌ lo jwanꞌ lí; tak naꞌtodiꞌsta Xaꞌ leꞌga kwent chanꞌ Xaꞌ, leꞌ Xaꞌ todiꞌs re jwanꞌ nchon Xaꞌ, nde loꞌ Xaꞌ lo goꞌ reta jwanꞌ nara ak. ");
INSERT INTO ztp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Xa' ya li naro na, tak Xa' kaya' jwan' nak chan' na nde koxo'b Xa'y lo go'. ");
INSERT INTO ztp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Reta jwanꞌ ngeno Xud na, naka chanꞌ na, jwanꞌ nasa mbez na lo goꞌ, kaya' Xa' jwan' nak chan' na nde koxo'b Xa'y lo go'. ");
INSERT INTO ztp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","\"Tudla ndaꞌb naꞌwitra' goꞌ na, nde tud yoloxaba twiꞌ goꞌ na tedib gob, tak leꞌn ndya lo Xud na\". ");
INSERT INTO ztp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zyasa pla xinꞌ teꞌd Jesus nchab lo ta xaꞌ: —¿Xamod nak jwanꞌ ta ne Xa' lon': Tudla ndaꞌb naꞌwitra' goꞌ na nde tud yoloxaba twiꞌ goꞌ na tedib gob, tak leꞌn ndya lo Xud na? ");
INSERT INTO ztp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Xamod nak jwanꞌ ta mbez Xaꞌ: “Tudla ndaꞌb”? Naꞌyenta naꞌ jwanꞌ ne Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zyasa mnela Jesus, leꞌ re xinꞌ teꞌd Jesus ncholaꞌs xa' nyaꞌbdiꞌs xa' lo Jesus, jwanꞌ nasa ner Jesus nchab lo xaꞌ: —¿Goꞌ nyaꞌbdiꞌs lo ta goꞌ jwanꞌ ta mbez na lo goꞌ: Tudla ndaꞌb naꞌwitra goꞌ na, nde tud yoloxaba twiꞌ goꞌ na tedib gob. ");
INSERT INTO ztp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nipa na lo goꞌ, tonꞌ goꞌ nde tonabil lazoꞌ goꞌ, nde le' re men lo izyo che' lyen xaꞌ. Nde tenyega nabil yo lazoꞌ goꞌ, leꞌ yalnabil chanꞌ goꞌ yolala yalnale. ");
INSERT INTO ztp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Thi men got sen' ryoꞌke xaꞌ, nzi'b yo'b lo xa' tak mzin be' gal xin' xa', leꞌ senꞌ ngola mbed, naꞌtetra lazoꞌ xaꞌ re yoꞌb tak ndyen toz xaꞌ mzin ti mbed lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tagaꞌ goꞌ naya, nabil nzo lazoꞌ goꞌ; per senꞌ yeꞌdtwiꞌn goꞌ tedib gob, zyasa nale toz yo lazoꞌ goꞌ nde ngenta cho kib yalnale ya lazoꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Senꞌ sin wiz ya, ngentraꞌ kwan nyaꞌbdiꞌs goꞌ lon. Nipa na lo go', reta jwanꞌ nyaꞌb goꞌ lo Xud na lo len, Xaꞌ taꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Axta naya nek thib jwanꞌ tera nyaꞌb goꞌ lo len; mnaꞌb goꞌy, nde kayaꞌ goꞌy, sa yonale toz tir lazo' reta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Reta jwanꞌ reꞌ mdej na lo goꞌ kon di's nagan; nde tzin wiz senꞌ naꞌtejta nay lo goꞌ kon diꞌs naga yen men, zyasa galꞌ tej na kwent chanꞌ Pay lo go'. ");
INSERT INTO ztp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Le' wiz ya nyaꞌb go' lo len, nde na'nakintra' na nya'b lo Pay por go', ");
INSERT INTO ztp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yub Pay nkeꞌ lazoꞌ Xaꞌ goꞌ, tak goꞌ nkeꞌ lazoꞌ goꞌ na nde ndli lazoꞌ goꞌ leꞌ na mbroꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mbroꞌn lo Pay, nde ndal na lo izyo, tedib gob lan izyo, nde ndyan lo Pay. ");
INSERT INTO ztp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Zyasa nchab re xinꞌ teꞌd Xaꞌ lo Xaꞌ: —¡Naya nambi tir ndyodiꞌs la, naꞌmdejta luy kon diꞌs nagan yen men! ");
INSERT INTO ztp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naya mbyenla náꞌ, ke mnela lu reta jwanꞌ, naꞌnakinꞌta lu nyaꞌbdiꞌs men loa, jwanꞌ nasa ndli lazoꞌ náꞌ leꞌ lu mbro' lo Dios. ");
INSERT INTO ztp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus mkab lo xaꞌ: —¿Cho naya ndli lazoꞌ goꞌ na? ");
INSERT INTO ztp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","¡Naya msinla wiz, nde seba mzinley, leꞌ goꞌ ryaꞌs, thiba goꞌ tyen xned goꞌ nde laꞌ goꞌ thib na! Per nandod tib na, tak Pay ndono na. ");
INSERT INTO ztp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Reta jwanꞌ reꞌ mdej na lo goꞌ, sa kon na keno go' yalnabez. Lo izyo rid goꞌ yalti; per blipa lazoꞌ goꞌ na, na mbli gan lo re jwan' narax lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Senꞌ ngolo nchab Jesus re jwanꞌna, zya mbwiꞌ Xaꞌ lo beꞌ, nde nchab Xaꞌ: —Xud na, seba mzin wiza, bli naro Xinꞌ la, sa tagaꞌ li naro Xinꞌ la lu. ");
INSERT INTO ztp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Lu mdaꞌ yalnyebeꞌ lo Xinꞌ la sa nyebe' Xa' lo reta men, sa taꞌ Xinꞌ la yalnaban adiꞌ lo re men jwanꞌ mdaꞌyaꞌa lo Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nde jwanꞌ reꞌ nak yalnaban adiꞌ: Sa yolo men lu, tak thibta lu nakpa Dios nde yolo men Jesucrist, Xaꞌ mtelꞌ la. ");
INSERT INTO ztp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Mbli naron la lo izyo re', mtoloa na sinꞌ jwanꞌ mdayaꞌa lon lin. ");
INSERT INTO ztp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nde naya, Xud na, tenꞌ ndob la bli sa lo' yalnaro chan' na, ptaꞌ yalnaro jwanꞌ mkenon kon lu nera' lo teraꞌ tyoxkwaꞌ izyo. ");
INSERT INTO ztp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Mdejla na cho nak la lo re men jwanꞌ mdaꞌyaꞌa lon, xaꞌ jwanꞌ mblía xij re men lo izyo, re xaꞌ ya nak men la, nde mdayaꞌa xaꞌ lon, nde mxobyek xaꞌ xkiꞌs la. ");
INSERT INTO ztp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naya mne xaꞌ reta jwanꞌ ngenon, lu mda'y lon. ");
INSERT INTO ztp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tak reta diꞌs jwanꞌ mdej la lon, nchab nay lo xaꞌ nde mkayaꞌ xaꞌy. Leꞌ naya mne xaꞌ liga loa mbroꞌn nde mbli lazoꞌ xaꞌ lu mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Na nyaꞌb loa por re xaꞌ reꞌ; na'nyabta na por re men ta nandliꞌd lazonꞌ lu, na nyaꞌb por re xaꞌ jwanꞌ mdaꞌa lon, tak men la nak xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","nde reta chan' la nak chan' na, nde chan' na nak chan' la; nde reta xaꞌ reꞌ ndli naro xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Naꞌketetra na lo izyo tak leꞌn ndyal loa, per re xaꞌ reꞌ tatka nzi xaꞌ lo izyo. Xud na Nayon nak la, re xaꞌ jwanꞌ mdaꞌa lon, pkenap xaꞌ kon yalne chanꞌ la, sa thita ak xaꞌ, ta xa thita nak rop naꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Senꞌ mkete'n lo izyo, mkenap na xaꞌ kon yalne chanꞌ la; re xaꞌ jwanꞌ mdaꞌa lon mkenap na xaꞌ nde nek thib xaꞌ namdyapta, benꞌta mdyaꞌb xaꞌ jwanꞌ nak diꞌsla tyaꞌb, per taga sa ak jwanꞌ ngeni lo Xkiꞌs la. ");
INSERT INTO ztp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Nde naya ndyan tenꞌ ndob la; nde ngetej jwan' re' lo re men lo izyo, sa thiptane yo nale lazoꞌ xaꞌ ta xa nale nzo lazoꞌn. ");
INSERT INTO ztp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mdej na xkiꞌs la lo xaꞌ nde re men lo izyo mbyiꞌno men xaꞌ, tak naꞌnakta xaꞌ men lo izyo, ta xa na, naꞌnakta na men lo izyo re'. ");
INSERT INTO ztp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Naꞌnyabta na loa kotea xaꞌ lo izyo re', che'la ngenaꞌb loa sa kenap la xaꞌ lo ya' maxu'. ");
INSERT INTO ztp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Naꞌnakta xaꞌ men lo izyo, ta xa na, nanakta na men lo izyo. ");
INSERT INTO ztp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bli nayon xaꞌ lo jwan lí chanꞌ la, xkiꞌs la nak jwanꞌ lí. ");
INSERT INTO ztp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ta xa mtelꞌ la na lo re men lo izyo re', taga mtel na xaꞌ lo re men lo izyo re'. ");
INSERT INTO ztp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nde por xaꞌ sa lega' na nayon ngeten, sa noga' xaꞌ kon jwan' lí ak nayon xa'. ");
INSERT INTO ztp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Nde naꞌnyaꞌbta na loa benꞌta por re xaꞌ reꞌ, noga nyaꞌb na loa por re men jwanꞌ naraꞌ li lazoꞌn na, por diꞌs jwanꞌ tej re xaꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Sa reta xaꞌ thita ak xaꞌ, ta xa lu Xud na, ndono na nde na ndono lu, sa noga reta xaꞌ thipta ak xaꞌ kon naꞌ; sa reta men lo izyo li lazoꞌ men ke lu mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Leꞌ yalnaro jwanꞌ mdaꞌa lon, mda ney lo re xaꞌ, sa thipta ak xaꞌ, ta xa thibta nak rop naꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na ndono xaꞌ nde lu ndono na, sa tamod naxut thita kwe xa', sa re men lo izyo nye xaꞌ leꞌ lu mtelꞌ na, nde nkeꞌ lazoꞌa re xinꞌ teꞌd na, ta xa nkeꞌ lazoꞌa na. ");
INSERT INTO ztp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xud na, leꞌ reta xaꞌ ta mdaꞌa lon ba, ncholas na tenꞌ ton, no xaꞌ tyo tya kon na, sa wiꞌ xaꞌ yalnaro jwanꞌ mdaꞌa lon; tak ya nkeꞌla lazoꞌa na axta senꞌ teraꞌ tyoxkwaꞌ izyo. ");
INSERT INTO ztp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xud na, galꞌ nak la, re men lo izyo re' teraꞌ yolo xaꞌ lu, per na nzolon la nde re xin'te'd na re' mne xaꞌ ke lu mtelꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nde mbloꞌn lo xaꞌ cho nak la, nde thidka loꞌ ney lo xaꞌ, nde ta xa nkeꞌ lazoꞌa na, taga' ke' lazo' xaꞌ nde na tyonon xa'. ");
INSERT INTO ztp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Senꞌ ngolo mdodiꞌsno Jesus Dios, mbroꞌ Jesus kon re xinꞌ teꞌd Xaꞌ, nda xaꞌ tedib lad ro pte ndole Cedrón, tenꞌ nzo ya bin, tya mzin Jesus kon re xinꞌ teꞌd Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nde noga' Judas, xaꞌ jwanꞌ ta'yaꞌ Jesus, nzolo xaꞌ tya, tak naꞌr gob mdyop Jesus kon re xinꞌ teꞌd Jesus tya. ");
INSERT INTO ztp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zyasa mdoꞌb Judas ned lo bro toz sondad, lo re xaꞌ nak sinꞌ ngenap yodoꞌ, re xaꞌ jwanꞌ mtelꞌ re ngwleyꞌ nyebeꞌ nde re xaꞌ fariseo. Mzinno Judas reta xaꞌ tya, neꞌ xaꞌ xni kandil nde jwan' ndob ki nde re ned yiꞌb nke' xa' byo. ");
INSERT INTO ztp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Leꞌ Jesus, mnela Xaꞌ re jwanꞌ rid Xaꞌ, zya nerla Jesus mnabdiꞌs lo re xaꞌ ya, nchab Jesus lo xaꞌ: —¿Cho nkwanꞌ goꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Leꞌ re xaꞌ mkab: —Náꞌ nkwanꞌ Jesus Xaꞌ Nazaret. Jesus nchab: —Na nak Xa' ya. Nde xij re xaꞌ ya nzo Judas, xaꞌ ta tayaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Senꞌ nchab Jesus lo xaꞌ: “Na nak Xa' ya”, zya mbererexis re xaꞌ nde ngob xaꞌ izyo. ");
INSERT INTO ztp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Zyasa bere mnabdiꞌs Jesus lo xaꞌ tedib gob: —¿Cho nkwanꞌ goꞌ? Leꞌ re xaꞌ mkab: —Náꞌ nkwanꞌ Jesus, Xaꞌ Nazaret. ");
INSERT INTO ztp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus mkab lo xaꞌ: —Nia na lo goꞌ, na nak Xa' ya; tez na nkwanꞌ goꞌ, ptaꞌ goꞌ diꞌs sa ya re xaꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nde tamod sa ngok diꞌs jwanꞌ ta nchab Jesus: “Re men jwanꞌ mdaꞌa lon, nek thib xaꞌ naꞌntabta na.” ");
INSERT INTO ztp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Zyasa Simón Pedr, ngeteno xa' thi espad, mbloꞌte xaꞌy lenꞌ yid nde mpchoꞌ xaꞌ nza ban ti xaꞌ ndole Malko mos mbol ngwleyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Zyasa nchab Jesus lo Pedr: —Blozaꞌ espad la lenꞌ yid. ¿Cho naꞌndabloda rid na yalti ta mnabeꞌ Xud na? ");
INSERT INTO ztp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Zyasa reta sondad nde re xaꞌ nyebeꞌ lo sondad nde re xaꞌ nak sinꞌ ngenap yodoꞌ judi, mxen xaꞌ Jesus nde mtobo xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nde nerla mbeꞌ xaꞌ Jesus lo Anas, tak xaꞌ ya nak xudzap Caifas, xaꞌ jwanꞌ nak ngwleyꞌ ro linꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Leꞌga Caifas reꞌ ta nchab lo re xa' nyebe' lo men judí, mas wen thipta mbiꞌ gaj kwent chanꞌ dib yez. ");
INSERT INTO ztp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Leꞌ Simon Pedr kon tedib xinꞌ teꞌd Jesus mdonke xaꞌ xis Jesus. Leꞌ tedib xinꞌ teꞌd Jesus reꞌ, nzolola nglweyꞌ ro xaꞌ, nde ngote xaꞌ kon Jesus lo le liz nglweyꞌ ro; ");
INSERT INTO ztp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","leꞌ Pedr mbyanꞌ le xis yala. Zyasa, leꞌ xinꞌ teꞌd Jesus, xaꞌ ta nzolola ngwleyꞌ ro, mni xaꞌ lo ngol ta nkenap ro yala, sa mxeyal ngote Pedr lenꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Senꞌ ngote Pedr lenꞌ, zya mnabdiꞌs ngol ngenap royo lo Pedr, nchab ngol: —¿Cho noa nak ti xinꞌ teꞌd mbiꞌ ba? Leꞌ Pedr mkab: —Ngen, nanakte na. ");
INSERT INTO ztp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Leꞌ re mos chanꞌ nglweyꞌ nde re xaꞌ nak sinꞌ ngenap yodoꞌ, mtolꞌ xaꞌ ki sa biz xaꞌ, tak nchal xaꞌ, nde noga Pedr ndoli xij re xaꞌ ta nzi biza. ");
INSERT INTO ztp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Leꞌ nglweyꞌ ro mnabdiꞌs lo Jesus kwent chanꞌ re xinꞌ teꞌd Jesus nde xomod nak jwanꞌ ndloꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zyasa mkab Jesus lo xaꞌ: —Na gal' ndodi's na lo reta men nde thiblaꞌ mtoteꞌd na xaꞌ lenꞌ yo tenꞌ ndyop re men judí, nde tenꞌ ndob yodoꞌ, plo nkata re xaꞌ judí, nde nek thib jwanꞌ naꞌmdodiꞌsnagaꞌsta na lo re men. ");
INSERT INTO ztp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Cho kwan liy lon nyabdiꞌs la? Mnabdiꞌs lo re men jwanꞌ mbina, nyenꞌ kwan mdodiꞌs na lo xaꞌ, re xaꞌ ya mne re jwanꞌ mdodiꞌs na, xaꞌ teja lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Senꞌ nchab Jesus jwanꞌna, leꞌ ti xaꞌ nak sinꞌ ngenap yodoꞌ, mkeꞌ xaꞌy kwat Jesus, nchab xaꞌ: —¿Cho tamod nkab la lo ngwleyꞌ ro? ");
INSERT INTO ztp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus nchab: —Tez narax mnin lo xaꞌ, ptej nyenꞌ kwan narax nchab na, nde tez wen mnin, ¿Kwan liy mkeꞌ lay chon? ");
INSERT INTO ztp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nde tata ndobo Jesus, mtelꞌ Anas Jesus lo Caifas, ngwleyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Leꞌ Pedr ndoli, ndobiz lo ki, nde mnabdiꞌs xaꞌ lo Pedr, nchab xaꞌ: —¿Cho naꞌluda nak thib xinꞌ teꞌd Xaꞌ ba? Zya mkalaꞌs Pedr nde nchab Pedr: —Ngen, nanakte na. ");
INSERT INTO ztp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Leꞌ thi xaꞌ nak mos ngwleyꞌ ro, ta xaꞌ jwanꞌ ta mpchoꞌ Pedr nzanꞌ ya, nchab xaꞌ lo Pedr: —¿Cho naꞌluda mbwiꞌn ndono Xaꞌ tenꞌ nzo ya bin? ");
INSERT INTO ztp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Zya bere nkalaꞌs Pedr tedib gob, nde zyaga mbrez ngidteꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tilꞌ toz mbroꞌteno re xaꞌ Jesus liz Caifás nde mbe' xaꞌ Jesus yolow ten' nzo Pilat. Yaja naꞌngoteda re xaꞌ judí lenꞌ yolow, tak ley chanꞌ re xaꞌ judí nak, naꞌnyeda yote xaꞌ lenꞌ yo chan' xaꞌ naꞌnakta judí, sa tamod toyal wa rzyeꞌ xaꞌ lo ni chanꞌ Pask. ");
INSERT INTO ztp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jwanꞌ nasa mbroꞌte Pilat le, nde nchab Pilat lo re men: —¿Cho yalke nkeꞌ goꞌ yek mbiꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Zya mkab re xaꞌ lo Pilat, nchab xaꞌ: —Tez mbiꞌ reꞌ ngak ti mbiꞌ wen, payeꞌdno náꞌ Xaꞌ loa. ");
INSERT INTO ztp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Zyasa nchab Pilat lo re xaꞌ: —Beꞌ goꞌ Xaꞌ, nde mnaꞌb goꞌ kwent lo Xaꞌ a xa nak ley goꞌ. Leꞌ re xaꞌ judí nchab lo Pilat: —Per ná', re men judí, naꞌnyeda kuj náꞌ men. ");
INSERT INTO ztp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tamod sa ngok diꞌs jwanꞌ nchab Jesus, lo mdej Xa' lo re men nyenꞌ xamod gaj Xa'. ");
INSERT INTO ztp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Zyasa bere ngote Pilat lenꞌ yolow nde mbrez Pilat Jesus, nchab Pilat: —¿Cho lu nak Rey lo re men judí? ");
INSERT INTO ztp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus mkab lo Pilat: —¿Cho xkiꞌs la nak diꞌs reꞌ, o xaꞌla men mdej kwent chanꞌ na loa? ");
INSERT INTO ztp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Leꞌ Pilat mkab lo Jesus: —¿Cho ngak na men judí? Re men las la nde re ngwleyꞌ jwanꞌ nyebeꞌ, re xaꞌ ya mdayaꞌa lon. ¿Cho yalke mblia? ");
INSERT INTO ztp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus mkab: —Yalnyebeꞌ chanꞌ na na'nakte jwan' lo izyo re'; tez ngaka jwan' lo izyo re', reta men jwanꞌ mketenke xis na ndla xaꞌ na nde naꞌngagat na lo yaꞌ re men judí. Per yalnyebeꞌ chenꞌ na naꞌnakte jwan' lo izyo re'. ");
INSERT INTO ztp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Zyasa nchab Pilat lo Jesus: —¿Cho rey nak la? Jesus mkab: —Lu ney, rey nak na. Jwanꞌ naga ngol na, nde jwanꞌ naga ndal na lo izyo re', sa tej na jwanꞌ li. Nde reta men jwanꞌ nxobyek jwanꞌ lipa, nchon xaꞌ diꞌs ron. ");
INSERT INTO ztp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat nchab lo Jesus: —¿Cho kwan nak jwanꞌ li sa? Nde senꞌ ngolo ta nchab Pilat, zya ngwa Pilat tenꞌ nzi reta xaꞌ judí nde nchab Pilat lo xaꞌ: —Naꞌngasalta na nek thib yalke jwanꞌ nchap mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Leꞌ mod nzino goꞌ nak toyal lan thi xaꞌ nge lizyiꞌb nal lenꞌ pask reꞌ. ¿Cho ncholaꞌs goꞌ lan Xaꞌ nak Rey lo men judí? ");
INSERT INTO ztp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Zyasa reta xaꞌ ne mbrez tedib gob, nchab xaꞌ: —¡Naꞌla'd la xaꞌ ba! ¡Blaꞌ Barrabas! Nde Barrabas nak ti xaꞌ wanꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Zyasa mnabeꞌ Pilat mdin xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Leꞌ re sondad mtoxkwaꞌ ti koron yis mtob xaꞌ yek Jesus, nde mtogok xaꞌ Jesus thi lar konch. ");
INSERT INTO ztp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nde nchab xaꞌ lo Jesus: —¡Chan' go' Rey lo men judí! Nde mdin bad xaꞌ lo Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Zyasa mbroꞌte Pilat le tedib gob nde nchab Pilat lo re xaꞌ: —Bwiꞌ goꞌ, ncheꞌ ndenon Xaꞌ le, sa nye goꞌ nek thib yalke naꞌmzyalta na mbli mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nde mbroꞌte Jesus le, ndob koron yis yek Xaꞌ nde nzoꞌb lar konch xis Xaꞌ. Zya nchab Pilat lo re men: —¡Leꞌ mbiꞌ ncheꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Senꞌ re xaꞌ nak ngwleyꞌ jwanꞌ nyebeꞌ nde re xaꞌ nak sinꞌ ngenap yodoꞌ mbwi' xa' Jesus, tolo mbrez xaꞌ: —¡Pkeꞌ go' Xaꞌ lo kruz! ¡Pkeꞌ go' Xaꞌ lo kruz! Leꞌ Pilat nchab lo xaꞌ: — Beꞌ go' Xaꞌ, nde pkeꞌ goꞌ Xaꞌ lo kruz, tak nek thib yalke naꞌmzyalta na mbli mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Leꞌ re xaꞌ judí mkab: — Náꞌ ngeno thi ley, nde ley náꞌ nyebe' gaj Xaꞌ, tak leꞌga Xaꞌ mbez Xaꞌ na Xinꞌ Dios nak Xa'. ");
INSERT INTO ztp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Senꞌ mbin Pilat ta mbez re men, mas mzyeb Pilat. ");
INSERT INTO ztp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bere ngote Pilat lenꞌ yolow tedib gob, nde nchab Pilat lo Jesus: —¿Ploga ndea? Leꞌ Jesús naꞌnkabta Xaꞌ lo Pilat. ");
INSERT INTO ztp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Zyasa nchab Pilat lo Jesus: —¿Cho kwan ndliy nakapta lu lon? ¿Cho naꞌnyed la ngenon yalnyebeꞌ keꞌn la lo kruz, nde ngenon yalnyebeꞌ tolaꞌn la? ");
INSERT INTO ztp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mbay Jesus mkab: —Nek thib yalnyebeꞌ naꞌngenod la kon na, tezka Dios naꞌmda'de loa; Jwanꞌ nasa mas bro yalke nchap xa' mdaya'n loa ke lu. ");
INSERT INTO ztp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Zyasa mchal Pilat laꞌ Pilat Jesus; per reta xaꞌ judí ne mbrez xaꞌ, nchab xaꞌ: —¡Tez laꞌa mbiꞌ reꞌ, naꞌnakta lu xa' nzal'ta César! ¡Tak reta xaꞌ jwanꞌ ncholaꞌs ak rey, naꞌnxobyekta xaꞌ César! ");
INSERT INTO ztp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Senꞌ mbin Pilat jwanꞌna, mbroꞌteno Pilat Jesus le, nde mdob Pilat tenꞌ ndyobka xaꞌ sa nyaꞌb xaꞌ kwent lo men, tya ndole \"Nzikwaꞌ Ke\" nde diꞌs hebreo ndoley \"Gabata.\" ");
INSERT INTO ztp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Leꞌ tedib wiz nak wiz ni chanꞌ pask, sa rolja wiza. Pilat nchab lo re xaꞌ judí: —¡Bwiꞌ goꞌ, leꞌ Rey goꞌ ncheꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Leꞌ re xaꞌ mbrez, nchab xaꞌ: —¡Bij Xaꞌ! ¡Bij Xaꞌ! ¡Pkeꞌ Xaꞌ lo kruz! Leꞌ Pilat nchab lo re xaꞌ: —¿Chonyea Rey goꞌ ba keꞌn lo kruz? Zya mkab re xaꞌ nak ngwleyꞌ jwanꞌ nyebeꞌ, nchab xaꞌ: —¡Nangenod náꞌ tedib rey, benꞌta César nak rey náꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Zyasa mdayaꞌ Pilat Jesus lo re xaꞌ, sa keꞌ xaꞌ Jesus lo kruz. Mxen xaꞌ Jesus nde mbeꞌ xaꞌ Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Neꞌ Jesus kruz mbroꞌ Xaꞌ tya, nda xaꞌ tenꞌ ndole Sij yek men (diꞌs hebreo ndoley Gólgota). ");
INSERT INTO ztp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tya mkeꞌ xaꞌ Jesus lo kruz, nde kon ti chop mbiꞌ mkeꞌga xaꞌ lo kruz, thiba xaꞌ lad cho Jesus nde Jesus mke xtowꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Noga mnabeꞌ Pilat mkeꞌ xaꞌ letr yek kruz, jwanꞌ nchab: “JESÚS, XAꞌ YEZ NAZARET, REY LO RE MEN JUDI”. ");
INSERT INTO ztp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nde bro toz xaꞌ judí mblab diꞌs ta nge yek kruz, tak tenꞌ mkeꞌ xaꞌ Jesus lo kruz naka gax ro yez nde diꞌs jwanꞌ mkeꞌ xaꞌy nak diꞌs hebreo, gryeg nde latín. ");
INSERT INTO ztp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Zyasa re xaꞌ nak ngwleyꞌ jwanꞌ nyebeꞌ lo re men judí, nchab xaꞌ lo Pilat: —Naꞌked lay: “Rey lo re men judí.” Leꞌa pkeꞌy, “Xaꞌ jwanꞌ mbez nak Rey lo re men judí.” ");
INSERT INTO ztp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat mkab lo re xaꞌ: —Diꞌs jwanꞌ mkeꞌa na, mkeꞌa nay. ");
INSERT INTO ztp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Senꞌ ngolo mkeꞌ re sondad Jesus lo kruz, zyasa mxen sondad re xab Jesus, nde mdiꞌd xaꞌy xij re thap xaꞌ nde thibay mka thiba xaꞌ. Noga mxen xaꞌ lar jwanꞌ nxyob xis Jesus nde lar ya thipta bdib nzo diba xata gap nde axta la. ");
INSERT INTO ztp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Zyasa nchab re sondad lo ta xaꞌ: —Naꞌcheta naꞌy, mas jwin linꞌ ti jwanꞌ, kij naꞌ nyenꞌ cho yanꞌnoy. Jwanꞌ reꞌ mbli xaꞌ sa ngok diꞌs nge lo xkiꞌs Dios, jwanꞌ nchab: “Mdiꞌd xaꞌ xab na leꞌga xij xaꞌ, Nde mdij xaꞌ nyenꞌ cho xaꞌ yanꞌno lar jwanꞌ nzyob xis na”. Nde ta mbli re sondad. ");
INSERT INTO ztp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gaxta tenꞌ ndoli kruz jwanꞌ nge Jesus, tya ndo xnaꞌ Jesus, nde xnit Jesus, noga Marí salꞌ Cleofas nde Marí xaꞌ yez Magdala. ");
INSERT INTO ztp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Senꞌ mbwiꞌ Jesus lo xnaꞌ Jesus nde lo xinꞌ teꞌd Jesus xaꞌ nkeꞌ lazoꞌ Jesus nde nchab Jesus lo xnaꞌ Jesus: —May, xaꞌ ba ak xinꞌ la. ");
INSERT INTO ztp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Xisa, nchab Jesus lo xinꞌ teꞌd Jesus: —Xaꞌ ba ak xnaꞌa. Nde xata zya, leꞌ xinꞌ teꞌd Jesus ya, mbeꞌ xaꞌ Marí liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngolo jwanꞌ reꞌ, Jesus mnela reta jwan' ngokla nde sa ak jwanꞌ nchab lo xkiꞌs Dios, zya nchab Jesus: —Nchek na. ");
INSERT INTO ztp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nde tya ndob ti yet sey nzo nit ub mbyála. Zyasa mbwas xaꞌ xilꞌ lenꞌ nit ub, mdob xaꞌy ti lo ya ndole hisop, nde mdob xaꞌy ro Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Senꞌ nguꞌ Jesus nit ub mbyála, nchab Jesus: —¡Seba ngolo ngok retay! Nde mkiꞌs yek Jesus, nguj Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Leꞌ tedib wiz nak wiz ni chanꞌ pask, jwanꞌ nasa re xaꞌ judí nancholaꞌsta xaꞌ tata take re yon mbiꞌ ya lo kruz lenꞌ wiz ndryoꞌxkwen men, tak wiz yaꞌ nak ti wiz ro lo xaꞌ. Zyasa mnaꞌb xaꞌ lo Pilat, sa ya thiz xaꞌ xku re yon mbiꞌ ta nge lo kruza, sa nayen gaj xaꞌ nde la xaꞌ xaꞌ lo kruz. ");
INSERT INTO ztp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Zyasa ngwa re sondad nde mdiꞌz xaꞌ xku xaꞌ jwanꞌ nge ner, tagaꞌ mdiꞌz xaꞌ xku tedib xaꞌ jwanꞌ nge tedib lad cho Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Leꞌ senꞌ mzin xaꞌ lo Jesus, mbwiꞌ xaꞌ ngujla Jesus, yaja naꞌngiꞌzta xaꞌ xku Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per ti sondad jwanꞌ nzo xija, mdi'd xaꞌ ye'r ten' nak rlanꞌ Jesus kon ti yiꞌb nalé xin' nde zyaga mbroꞌ ren nde nita. ");
INSERT INTO ztp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Leꞌ xaꞌ jwanꞌ mbwiꞌy, ndej xaꞌ jwanꞌ reꞌ nde jwanꞌ ndej xaꞌ naka jwan' li; nde mne xaꞌ li jwanꞌ ndyodiꞌs xaꞌ, sa no goꞌ li lazoꞌ goꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tak reta jwanꞌ reꞌ ngoka sa ak jwanꞌ nchab lo xkiꞌs Dios: “Nek thib zij xaꞌ naꞌgasta”. ");
INSERT INTO ztp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nde tedib lad lo xkiꞌs Dios nchab: “Bwiꞌ goꞌ Xaꞌ jwanꞌ mdi'd men ye'r ten' nak rlanꞌ Xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ngolo jwanꞌ reꞌ, José xaꞌ yez Arimatea, (ti xaꞌ jwanꞌ nagaꞌsta ndyonke xis Jesus tak nzyeb xaꞌ re xaꞌ nak sinꞌ lo men judí,) ngwanaꞌb xaꞌ lo Pilat sa taꞌ Pilat diꞌs we xaꞌ thabol Jesus, nde mdaꞌ Pilat diꞌs, zyasa ngwa xaꞌ nde mbeꞌ xaꞌ thabol. ");
INSERT INTO ztp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Noga Nikodem, xaꞌ jwanꞌ ngwatodiꞌs lo Jesus ti yalꞌla, mbyeꞌdno xaꞌ ti galbsiꞌ kil jwanꞌ naxeꞌ, nosnoy chop ned jwanꞌ, mirra nde aloe. ");
INSERT INTO ztp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Rop xaꞌ reꞌ, mbla xaꞌ thabol Jesus nde mchal lar xaꞌ Jesus nde taja ndogo xaꞌ jwanꞌ naxeꞌ lad lar, mod jwanꞌ ndliga re xaꞌ judí senꞌ lo nkaꞌs xaꞌ ta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nde plo tenꞌ mke Jesus lo kruz, tya nax ti tenꞌ nzo jwanꞌ bin, nde xij jwanꞌ bina nax ti baꞌ kub, tenꞌ nek thib thabol tera yo. ");
INSERT INTO ztp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tya mkaꞌs xaꞌ Jesus tak baꞌ ya ndob gax nde tak tedib wiz nakla wiz ni chanꞌ pask. ");
INSERT INTO ztp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wis ner xanꞌ sman, tilꞌ toz tata benꞌ nakow nya, Marí Magdalen ngwa ro baꞌ nde mbwiꞌ Marí mbyiꞌb ke jwanꞌ nowꞌ ro baꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Zyasa mkeꞌ ngol karrel ngwa ngol lo Simón Pedr nde lo tedib xinꞌ teꞌd Jesus, xaꞌ jwanꞌ nkeꞌ toz lazoꞌ Jesus, nde nchab ngol lo xaꞌ: —¡Ngwaloꞌte xaꞌ Xaꞌ Nyebeꞌ lenꞌ baꞌ, nde naꞌnyed naꞌ plo mbeꞌ men Xaꞌ! ");
INSERT INTO ztp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Zyasa mbroꞌ Pedr kon tedib Xinꞌ teꞌd Jesus, ngwa xaꞌ tenꞌ nax baꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mkeꞌ rop xaꞌ karrel, per tedib xinꞌ teꞌd Jesus mas naban mde xaꞌ lo Pedr, nde ner xaꞌ mzin ro baꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nde mbleng xaꞌ sa mbwiꞌ xaꞌ lenꞌ baꞌ, benꞌta lar mchal Jesus nax tya, per naꞌndlad xaꞌ lenꞌ baꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Xista mzin Simón Pedr, leꞌ Pedr sa ngote lenꞌ baꞌ nde mbwiꞌ Pedr benꞌta lar jwanꞌ mchal Jesus nax tya, ");
INSERT INTO ztp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","leꞌ lar jwanꞌ mpchal xaꞌ yek Jesus naduza naxa tedib lad, naꞌnaxte cho lar jwanꞌ ta mpchal xaꞌ dib Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Zyasa no tedib xinꞌ teꞌd Jesus, xaꞌ jwanꞌ mzin neraꞌ, ngote xaꞌ lenꞌ baꞌ nde mbwiꞌ xaꞌ jwanꞌ ngok, zyasa mbli lazoꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tak teraꞌ yen xaꞌ jwanꞌ nchab lo xkiꞌs Dios, leꞌ Jesus ndabloga ryoꞌxban xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Zya mbere rop xaꞌ tenꞌ nzi masraꞌ ta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Leꞌ Marí ndo yonꞌ le, gax cho baꞌ. Nde laj ndo yonꞌ Marí, zya mbleng Marí sa mbwiꞌ Marí lenꞌ baꞌ; ");
INSERT INTO ztp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nde mbwiꞌ Marí chop anj chanꞌ Dios nok lar nakiꞌs, thib xaꞌ ndob tenꞌ ngo'x yek Jesus nde tedib xaꞌ ndob tenꞌ ngo'x ni Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nde nchab rop anj lo Marí: —¿Cho kwan ndliy nchonꞌ la ngota? Leꞌ Marí mkab: —Nchonꞌ na, tak mbeꞌ xa' Xaꞌ Nyebeꞌ lon, nde naꞌnyet na plo mbeꞌ men Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Benꞌta ngolo ta nchab Marí, mbyek Marí nde mbwiꞌ Marí cho le Jesus ndo tya, per naꞌngyolod Marí cho Jesus jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Zyasa nchab Jesus lo Marí: —¿Cho kwan ndliy nchonꞌ la ngota? ¿Cho nkwanꞌ la? Leꞌ Marí mbli xgab xaꞌ nkenap ya bina, zyasa nchab Marí lo Xaꞌ: —Tez goꞌ mbeꞌ Xaꞌ, ptej goꞌ lon plo ngwano goꞌ Xaꞌ, sa wen Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Leꞌ Jesus nchab: —¡Mari! Zya mbyek Mari nde nchab Mari: —¡Raboni! (diꞌs ya nak , Maestr). ");
INSERT INTO ztp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus nchab: —Nagalta lu na, tak teraꞌ yan lo Xud na. Leꞌa wa lo re xinꞌ teꞌd na nde gus lo xaꞌ, leꞌn ndya lo Xud na, Xaꞌ jwanꞌ nak Xud re goꞌ, Dios na nde Xaꞌ nak Dios goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Zyasa Marí Magdalen ngwatne xaꞌy lo re xinꞌ teꞌd Jesus nchab xaꞌ ke mbwiꞌ xaꞌ Xaꞌ Nyebeꞌ nde le'ga Xa' Nyebe' nchab jwanꞌ reꞌ lo Mary. ");
INSERT INTO ztp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Leꞌga wiz ya, wiz ner xanꞌ sman, senꞌ mbla yalꞌ, leꞌ re xaꞌ nak xinꞌ teꞌd Jesus saj nowꞌ reta yala tenꞌ nzi xaꞌ tak nzyeb xaꞌ re xaꞌ judí. Zyasa xajta mbroꞌto Jesus xtowꞌ re xinꞌ teꞌd Jesus nde nchab Jesus lo xaꞌ: —Yalnabeꞌz nzino goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Senꞌ ngolo ta nchab Jesus, mbloꞌ Xaꞌ yaꞌ Xaꞌ nde ro kostin Xaꞌ tenꞌ mcheda. Leꞌ re xinꞌ teꞌd Xaꞌ nale toz ngo lazoꞌ xaꞌ, mbwiꞌ xaꞌ Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zyasa nchab Jesus lo xaꞌ tedib gob: —Yalnabeꞌz nzino goꞌ. Ta xa mtelꞌ Xud na na, taga tel na goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Senꞌ ngolo ta nchab Jesus, mblabi Jesus yek xa' nde nchab Xaꞌ lo re xinꞌ teꞌd Xaꞌ: —Pkayaꞌ goꞌ Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Men jwan' gab go' dyon' xken na' ton Dios xken xa' ya nde men jwan' gab go' na'dyonta xken na' na'tonta Dios xken xa' ya. ");
INSERT INTO ztp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Leꞌ Max, xaꞌ jwanꞌ nakwent lo re thib sen xinꞌ teꞌd Jesus, xaꞌ jwanꞌ ngole xaꞌ Kwach, naꞌngenta xaꞌ senꞌ mzin Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Zyasa nchab tipla ta teꞌd xaꞌ lo xaꞌ: —Mbwiꞌ naꞌ Xaꞌ Nyebeꞌ. Leꞌ Max nchab: —Tez nawiꞌt na yaꞌ Xaꞌ tenꞌ mbla klab nde gon kwen yaꞌn tya nde gon yaꞌn ten' ta mched kostin Xaꞌ ya, pali lazoꞌ ney. ");
INSERT INTO ztp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mbridndaꞌb xon wiz, senꞌ nzi re xinꞌ teꞌd Jesus lenꞌ yo tedib gob, zya no Max ndo tya, nde saj nowꞌ ro yala nzi re xaꞌ, Jesus ngote lenꞌ yo, mdo Jesus xtowꞌ re xinꞌ teꞌd Jesus nde nchab Jesus lo xaꞌ: —Nabeꞌz nzi goꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Zyaga nchab Jesus lo Max: —Blo kwen yaꞌa ncheꞌ nde bwiꞌ yaꞌn; bzikeꞌ gax yaꞌa nde blo yaꞌa ye'r ta mched men kostin na; nde naꞌakta lu xa' ngenkwan ndli lazon', cheꞌla gok xa' ndlipa lazo'n Dios. ");
INSERT INTO ztp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Zyasa mkab Max nde nchab Max: —¡Xaꞌ nak Xwan' na nde Dios na! ");
INSERT INTO ztp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus nchab: —Max, lo ta mbwiꞌa na, jwanꞌ nasa mbli lazoꞌa na. ¡Nabeꞌz toz nda re men jwanꞌ naꞌmbwid xaꞌ na, nde ndli lazoꞌ xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Naꞌr toz re yalnaro mbliga' Jesus jwanꞌ mbwiꞌ re xinꞌ teꞌd Xaꞌ, nde re jwan' na nangedey lo yeꞌs reꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per jwanꞌ reꞌ mkey lo yeꞌs sa li lazoꞌ goꞌ leꞌ Jesus nak Crist, Xinꞌ Dios, sa lo li lazoꞌ goꞌ Xaꞌ keno goꞌ yalnaban lo le Xa'. ");
INSERT INTO ztp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngolo jwanꞌ reꞌ, Jesus mbroꞌto tedib gob lo re xinꞌ teꞌd Xaꞌ gax ro nittoꞌ yez Tiberias. Nde cheꞌmod mbroꞌto Jesus: ");
INSERT INTO ztp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Senꞌ thita mdyop re xaꞌ reꞌ, Simón Pedr, Max xaꞌ ndolegaꞌ Kwach, Natanael xaꞌ yez Caná lo xyon Galilea, Santyag nde Juan xinꞌ Zebedeo nde kon tedid chop xinꞌ teꞌd Jesus. ");
INSERT INTO ztp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Leꞌ Simón Pedr nchab lo re xaꞌ: —Leꞌn nda god mbel. Zya mkab re xaꞌ, nchab xaꞌ: —No náꞌ tye xis la. Nde ngwa re xaꞌ, ngwap xaꞌ lo ti bark per nek lud mbel naꞌndenta xaꞌ yalꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Senꞌ ndetuxnila, Jesus mbroꞌto lo yux ro nittoꞌ nde leꞌ re xinꞌ teꞌd Jesus naꞌnyed xaꞌ cho Jesus sa. ");
INSERT INTO ztp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus nchab lo re xaꞌ: —Xinꞌ bix na, ¿Cho kwan ngeno goꞌ wanꞌ? Leꞌ re xaꞌ mkab: Ngen cho kwan nak. ");
INSERT INTO ztp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesus nchab lo xaꞌ: —Blobi goꞌ yeꞌd lad ban bark, sa yoga mbel. Zya mblobi xaꞌ yeꞌd, nde naꞌlitraꞌ xaꞌ gan kwe xaꞌ yeꞌd, tak bro toz mbel ngoga. ");
INSERT INTO ztp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Zyasa leꞌ xinꞌ teꞌd Jesus, xaꞌ jwanꞌ nke toz lazoꞌ Jesus, nchab xaꞌ lo Pedr: —¡Xaꞌ Nyebeꞌy! Senꞌ lo mbin Simón Pedr ke Xaꞌ Nyebeꞌy, leꞌ Simón ngok xab naꞌ, (tak mbloche xaꞌ xab xaꞌ) nde ngobi xaꞌ lenꞌ nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Laja leꞌ ti pla xinꞌ teꞌd Jesus ndeno xaꞌ bark, ndegobnyo xaꞌ yeꞌd sey nzo mbel, nde ludla lo nit ngwa xaꞌ, benꞌ tib ayoꞌ metr ngwa xaꞌ lo nit. ");
INSERT INTO ztp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Senꞌ mzin xaꞌ ro yux, mbwi xaꞌ nzi kwiyꞌ nde ti mbel nzoꞌb lo kwiyꞌ nde no pan nzi tya. ");
INSERT INTO ztp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus nchab lo xaꞌ: Deꞌno goꞌ pla mbel, ta ngolo mxen goꞌ ba. ");
INSERT INTO ztp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Zyasa ngwap Simón Pedr lo bark sa mbrenga xaꞌ yeꞌd, mzina ro yux, sey nzo mbel nabiꞌ, thib ayoꞌ nzo chopsiꞌ son mbel nde tenyega layaja mbel, naꞌncheta yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus nchab lo xaꞌ: —Deꞌ goꞌ, sa wa goꞌ. Nde nek thib xinꞌ teꞌd Jesus naꞌngoneda lazoꞌ xaꞌ nabdiꞌs xaꞌ: \"¿Choga lu sa?\" tak mnela xaꞌ Xaꞌ Nyebeꞌy. ");
INSERT INTO ztp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zyasa mbike Jesus gax, mxen Jesus pan nde mdaꞌ Xaꞌy lo re xinꞌ teꞌd Xaꞌ, nde tagaꞌ mdiꞌd Xaꞌ mbel. ");
INSERT INTO ztp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jwanꞌ reꞌ ngok mbyon gob mbroꞌto Jesus lo re xinꞌ teꞌd Xaꞌ, senꞌ mbroꞌxbanla Xaꞌ xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Senꞌ ngolo mda re xaꞌ, Jesus nchab lo Simon Pedr: —Simón, xinꞌ Jonás, ¿Cho mas nkeꞌ lazoꞌa na ke lo re xaꞌ reꞌ? Pedr mkab: —Ta naka, Xaꞌ Nyebeꞌ, lu mne nkeꞌ lazoꞌn la. Jesus nchab: —Ptowa re mbakxilꞌ yen' na. ");
INSERT INTO ztp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Brop gob, Jesus mnabdiꞌs tedib gob, nchab Xaꞌ: —Simon, xinꞌ Jonas, ¿Cho nkeꞌ lazoꞌa na? Pedr mkab lo Jesus: —Ta naka, Xaꞌ Nyebeꞌ, lu mne nkeꞌ lazoꞌn la. Jesus nchab: —Pkenap re mbakxilꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ngok mbyon gob Jesus nchab: —Simon, xinꞌ Jonas, ¿Cho nkeꞌ lazoꞌa na? Zyasa ngo nabil lazoꞌ Pedr tak mbyonla gob mnabdiꞌs Jesus¿Cho nkeꞌ lazoꞌa na? Nde mkab Pedr lo Jesus: —Xaꞌ Nyebeꞌ, lu mne reta jwanꞌ; lu mne nkeꞌ lazoꞌn la. Jesus nchab: —Pkenap re mbakxilꞌ na. ");
INSERT INTO ztp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nipa na loa: Senꞌ ngok la mbyo yenꞌ, nchok xab la nde ndaa plo ncholaꞌs la, per senꞌ ngok gox la, togaꞌa yaꞌa nde tedib men gok xab la nde we xaꞌ lu tenꞌ naꞌncholasta lu yaa. ");
INSERT INTO ztp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ta nchab Jesus, mdej Xaꞌ xamod gaj Pedr sa li naro Pedr Dios. Senꞌ ngolo jwanꞌ reꞌ, nchab Jesus lo Pedr: —¡Btonke xis na! ");
INSERT INTO ztp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Lo mbyek Pedr, zya mbwiꞌ Pedr leꞌ xinꞌ teꞌd Jesus xaꞌ jwanꞌ nkeꞌ toz lazoꞌ Jesus ndenke tya, xaꞌ ta mxyo'bke' gax cho Jesus senꞌ lo mda rzye' xaꞌ nde mnabdiꞌs xaꞌ lo Jesus: “Xaꞌ Nyebeꞌ, ¿Cho xaꞌ jwanꞌ taꞌyaꞌa?” ");
INSERT INTO ztp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Senꞌ mbwiꞌ Pedr xaꞌ reꞌ, nchab Pedr lo Jesus: —Xaꞌ Nyebeꞌ, ¿Mbay xaꞌ reꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus mkab lo Pedr: —Tez ncholas na tata yanꞌ xaꞌ axta senꞌ beren tedib gob, ¿Cho xyoa jwan'na? Lu ptonke xis na. ");
INSERT INTO ztp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Leꞌ diꞌs ta nchab Jesus, mbryaꞌsa xij reta xinꞌ teꞌd Xaꞌ, ke leꞌ xinꞌ teꞌd Jesus ya, naꞌgajta xaꞌ. Per Jesus naꞌnchapta ke naꞌgajta xaꞌ ya, diꞌs nchab Jesus nak: “Tez ncholas na tata yanꞌ xaꞌ axta senꞌ beren tedib gob, ¿Cho xyoa jwanꞌna?” ");
INSERT INTO ztp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Leꞌga xinꞌ teꞌd Jesus ya nak xaꞌ reꞌ, xaꞌ ndaꞌ kwent re jwanꞌ reꞌ nde mkeꞌ xaꞌ re diꞌs reꞌ. Nde mnenꞌ leꞌ re jwanꞌ ndej xaꞌ jwan' liy. ");
INSERT INTO ztp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nde nzoraꞌ nar toz tir re jwanꞌ mbli Jesus, tez thib thibay ke lo yeꞌs, ndlin xgab pa gal lo izyo rya's reta libr jwanꞌ nge reta jwanꞌ mbli Jesus. Ta aka.");
INSERT INTO ztp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teoj xa' ntak toz, yeꞌs ner jwanꞌ mkeꞌn loa, tya mdej na re jwanꞌ mdobte mbli Jesús nde re jwanꞌ mbloꞌ Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","axta kebeꞌ mzin wiz ngwap Jesús lo beꞌ. Sen' ngol be' yap Jesús, kon Mbi Nayon mnabe' Jesús re jwanꞌ ndablo li re xaꞌ nak apóst Xa', men jwan' mblía Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nde sen' ngujla Jesús, xisa mbroꞌto naban Xaꞌ lo re men nak apóst Xaꞌ, naꞌr toz mod mbloꞌ Jesús liga naban Xaꞌ. Lenꞌ choꞌ wiz mbroꞌto Xaꞌ lo re men nak apóst Xaꞌ, nde mdej Xaꞌ re jwanꞌ nak yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ti gob sen' thita nzi re xa', zya mnabeꞌ Jesús lo re xaꞌ sa naꞌryoꞌd xaꞌ yez Jerusalén. Nchab Jesús lo re xa': —Bled go' sa kaya' go' jwanꞌ mkeꞌyek Xud na' Dios, re jwanꞌ xa mdejla na lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tak Juan, liga benꞌta lenꞌ nit mblole xaꞌ men, per goꞌ lenꞌ ti plata wiz ryoꞌle goꞌ kon Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zyasa re xaꞌ jwanꞌ nzidop tya mnabdiꞌs xaꞌ lo Jesús, nchab xaꞌ: —Xaꞌ Nyebeꞌ, ¿Cho naya ngoxoꞌb beꞌ si'rea yalnyebeꞌ lo yez Israel tedib gob? ");
INSERT INTO ztp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Leꞌ Jesús mkab lo xaꞌ: —Naꞌndiꞌnta goꞌ nye goꞌ cho beꞌ nde cho wiza, benꞌta Xud na' mney tak Xaꞌ ngeno yalnyebeꞌ li Xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per kayaꞌ go' yalne, senꞌ dib ben' go' ke' Mbi Nayon nde yatej goꞌ xkiꞌs na yez Jerusalén, dib lo xyon Judea nde lo xyon Samaria nde axta ploja mdib izyo. ");
INSERT INTO ztp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Senꞌ mne nchab Jesús re jwanꞌ reꞌ, nzi wiꞌta re men ngwap Jesús lo beꞌ, mbro' ti xkow mdapa dib Jesús, nde naꞌngwi'tra' xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nde laj nziwi' gal' re xaꞌ lo beꞌ xa ndoyap Jesús, zya gax cho re xaꞌ mbroꞌto chop mbiꞌ dib xa' nok lar nakis, ");
INSERT INTO ztp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","rop mbiꞌ ya nchab lo re xaꞌ: —Mbiꞌ lo xyon Galilea, ¿Cho kwan liy ngwiꞌ goꞌ lo beꞌ? Leꞌga Jesús ta mbroꞌ xij goꞌ reꞌ, ta xa ndya Xaꞌ lo beꞌ, taxa bere Xaꞌ tedib gob. ");
INSERT INTO ztp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Zyasa mbroꞌ xaꞌ yek kox ndole Olib sa mbere xaꞌ yez Jerusalén tedib gob (mde xaꞌ jwan' xapka ndaꞌ ley diꞌs ndye men lenꞌ wiz jwanꞌ ndryoꞌxkwen men). ");
INSERT INTO ztp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Senꞌ mzin re xaꞌ lenꞌ yez, zya ngwap xaꞌ lenꞌ yo xtaꞌ gap tenꞌ mbed xaꞌ nde tya mdyop re xaꞌ reꞌ: Pedr, Jakob, Juan, Ndres, Blib, Max, Bartol, Mateo, Jakob xinꞌ Alfeo, Simón xaꞌ cananist, nde Judas wes Jakob. ");
INSERT INTO ztp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Reta xaꞌ reꞌ thiblaꞌ ndyop xaꞌ sa thita ndyodiꞌsno xaꞌ Dios nde nyaꞌb xaꞌ lo Dios, xija nzo tipla ngol nde noga Marí xnaꞌ Jesús nde kon re wes Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lenꞌ wiz ya, Pedr mdoli xij reta wes nzi tya (tak tya nziga te' thib ayoꞌ nzo thib galka men), nde nchab Pedr lo re xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Re go' mbi', wes na, ndabloga ak jwanꞌ ngeni lo xkiꞌs Dios, diꞌs jwanꞌ mtob Mbi Nayon ro rey David, senꞌ lo mdej David Judas, xaꞌ jwanꞌ mdoꞌb ned lo re men ta mxen Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tak Judas ngok ti xaꞌ ngo xij náꞌ nde no xaꞌ ngok sinꞌ lo jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Leꞌ tmi jwanꞌ mzenaꞌ xaꞌ lo yalnaraxa, tmi ya mxiꞌ xaꞌ tible izyo, tya ngob tathoꞌ xaꞌ nde ngoskiꞌ xaꞌ axta mbroꞌche re xtiꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lo ta mbin reta men yez Jerusalén jwanꞌ ngok, jwanꞌ nasa izyo ya xki's xa' ndoley, \"Acéldama\", diꞌs ya nak: \"Izyo ren\". ");
INSERT INTO ztp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tak ta ngeni lo yeꞌs chanꞌ Salmo, jwanꞌ nchab: Nagán tyo liz xaꞌ nde ngenta cho men yoy. Nde noga nchaba: Tedib men kayaꞌ rsinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jwanꞌ nasa nakin'ka xij na' reꞌ kon' ti mbiꞌ jwanꞌ mdo kon naꞌ lo dipta mketenꞌ kon Jesús Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Xata mdobtey senꞌ mblole Juan Jesús nde axta wiz jwanꞌ ngwap Jesús lo beꞌ, ti mbiꞌ ya konꞌ sa laꞌsto xa náꞌ tej xaꞌ liga mbroꞌxban Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Zyasa mbloꞌya' xaꞌ chop mbiꞌ, tib xaꞌ ndole José, xaꞌ ndolegaꞌ Barsabás o Just ni men xaꞌ nde tedib xaꞌ ndole Matí. ");
INSERT INTO ztp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Zyasa mnaꞌb xaꞌ lo Dios, nchab xaꞌ: —Xaꞌ Nyebeꞌ, lu nzolo lazoꞌ reta men, bloꞌ lo náꞌ nyenꞌ xanya tib rop mbi' reꞌ mblía, ");
INSERT INTO ztp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sa xaꞌ ya kayaꞌ rsinꞌ Judas nde ak xaꞌ men jwanꞌ telꞌ la, tej xkiꞌs la, sinꞌ jwanꞌ mblaꞌ Judas por yalke jwan' mbli xaꞌ, nde nda xaꞌ tenꞌ nsal' xa' ya xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Zyasa mblibeꞌ xaꞌ rop mbiꞌ ya, nde ngobeꞌ Matíy, nde mbla Matí xij re siꞌbthib xaꞌ jwanꞌ nak apóst. ");
INSERT INTO ztp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Senꞌ mzin wiz ni chan' pentecostes, reta xaꞌ jwanꞌ ndli lazonꞌ Jesús thita ten' nzi dop reta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Zyasa xajta mbyen mdez ti bi toz mbroꞌ lo beꞌ, xaja ndyez ta nxyoꞌb mbi toza nde mze lenꞌ yo tenꞌ nzi ndob xaꞌ ngotey. ");
INSERT INTO ztp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nde xaja yaꞌ bela mbroꞌto re lo diꞌs, mblatoba yek kad thiba xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nde reta xa' mdeꞌ Mbi Nayon, mdobte mni xaꞌ xa'xaꞌ re diꞌs, axaja ndaꞌ Mbi Nayona lo xaꞌ ni xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lenꞌ yez Jerusalén nzigaꞌ re xaꞌ judí, re xaꞌ jwan' nxobyek toz re jwanꞌ ndli lazoꞌ xaꞌ, xaꞌ jwanꞌ mbroꞌ naꞌr toz re yez. ");
INSERT INTO ztp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Senꞌ mbyen mxyoꞌb mbi toza, men toz tir mdyop nde reta xaꞌ mbwan, tak kad thiba xaꞌ nchen xa' xkiꞌs xa' jwanꞌ ndyodiꞌs re xaꞌ nzi tya. ");
INSERT INTO ztp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nde anta nzya lazoꞌ re men nde taja nzoyen xaꞌ, nchab xaꞌ lo ta xaꞌ: —¡Bwiꞌ goꞌ! ¿Cho nanakta men lo xyon Galilea re xaꞌ ta ndyodiꞌsa? ");
INSERT INTO ztp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cho kwan liy sa xkiꞌs naꞌ, diꞌs jwanꞌ ngol nonꞌ nchon naꞌ ndyodiꞌs xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ncheꞌ nzi re men Partos, Medos, Elamitas, nde re na' nzo lo xyon Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO ztp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","xa' Frigia, Panfilia, Egipto nde re men lo xyon Africa gaxta yez Ciren, nde noga re men yez Rom xaꞌ jwanꞌ nzo ncheꞌ, men judí nde re xaꞌ jwanꞌ ngolal judí, ");
INSERT INTO ztp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","re men nzo lo xyon Creta nde Arabia. Mbyen naꞌ xkiꞌs naꞌ jwan mni xaꞌ, re yalnaro chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nde anta nzya lazoꞌ reta xaꞌ jwanꞌ toz nzoyen xaꞌ, nchab xaꞌ lo ta xaꞌ: —¿Cho kwan nak jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Leꞌ tipla xa', nxino xa' men ya, nchab xa': —Ndyus re men ba. ");
INSERT INTO ztp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Zyasa mdoli Pedr kon re siꞌ bthib xaꞌ nde ne mbrez Pedr, nchab Pedr: —Reta goꞌ men las na nde men jwanꞌ nzo Jerusalén, ndablo nye goꞌ jwanꞌ reꞌ nde bin goꞌ jwanꞌ tej na. ");
INSERT INTO ztp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Naꞌndyusta reta men re' ta xa ndli goꞌ xgaba, tak ben' tilꞌ naya. ");
INSERT INTO ztp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Che'la jwanꞌ ta ndoyak naya, jwanꞌ reꞌ ta mdej profet Joel, senꞌ nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dios nchab, yoloba sen' yoxo'b wiz, Lan Xbin na yek reta men. Leꞌ re xinꞌ biꞌ goꞌ nde xinꞌ got goꞌ, nin lor sa tej ora lo men, leꞌ re mdyenꞌ goꞌ wiꞌr jwanꞌ xaja men nzalꞌ lazonꞌ, nde re xaꞌ gox wiꞌ xaꞌ re jwanꞌ lenꞌ xkalꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nipa na lo go', lenꞌ re wiz ya, noga re mos na, xaꞌ biꞌ nde xaꞌ got, chub na Xbin na yek xa', nde nin lo xaꞌ sa tej xaꞌy lo men. ");
INSERT INTO ztp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lo beꞌ tan yalnzoyen, nde lo izyo loꞌn re jwan' wi' go', loꞌn ren, bel, nde bez chan' zen. ");
INSERT INTO ztp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Leꞌ wiz na'toxnitra'y, nde leꞌ mbeꞌ ak narena xaja ren, jwanꞌ reꞌ ak senꞌ teraꞌ yoxoꞌb wiz chanꞌ Xaꞌ Nyebeꞌ. Wiz ro toz tir nde wiz lo' chan' Xa' Nyebe'. ");
INSERT INTO ztp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nde reta men jwanꞌ nyeke' lo Xaꞌ Nyebeꞌ, men ya lyaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Reta go' mbi' men Israel, bin goꞌ re diꞌs reꞌ: Jesús, Xaꞌ yez Nazaret, Mbiꞌ mbloxo'bla Dios lo go', Xa' jwan' liga ngeno yalnyebe' por re jwanꞌ nzoyen men, re yalbzye nde re jwanꞌ mbloꞌ Dios, re jwanꞌ mbli Dios xij go' por Xa', ta xa mnela goꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mbiꞌ ya jwan' mdayaꞌ men Xaꞌ lo re xaꞌ nak sinꞌ, axa nak xgab Dios nde thita ngok goꞌ kon re men naraxa sa leꞌga goꞌ mxen goꞌ Xaꞌ nde mdaya' go' Xa' lo re men narax sa mbij men Xaꞌ nde mkeꞌ men Xaꞌ lo kruz. ");
INSERT INTO ztp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Leꞌga Xaꞌ ya, mbloꞌxban Dios Xaꞌ, naꞌmblayaꞌd Dios xaꞌ lo yoꞌb chanꞌ yalguj, tak yalguj naꞌnyeda ndenkeꞌy Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tak rey David mdej kwent chanꞌ Jesús, nchab xaꞌ: Thiblaꞌ ngwiꞌn Xaꞌ Nyebeꞌ ndo Xaꞌ lon, tak Xaꞌ ndo lad ban na, nde ngen kwan li gan kin yoy na. ");
INSERT INTO ztp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jwanꞌ nasa nale toz ngo lazoꞌn nde diꞌs nale mbroꞌ ron. nde dib ben na ryoꞌxkwen lo ta nzo ti jwan' ngenbed na, ");
INSERT INTO ztp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tak naꞌlaꞌd la na lenꞌ baꞌ, nekla taꞌa diꞌs gàz belꞌ Xaꞌ Nayon loa. ");
INSERT INTO ztp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Lu mbloꞌ lon xomod ban na, nale toz koa lazoꞌn lo tyonoa na. ");
INSERT INTO ztp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Wes na, nambi toz nak jwanꞌ reꞌ, David xaꞌ gox lon' ngo pola, nguj xaꞌ nde mbwaꞌs xaꞌ nde banꞌ xaꞌ axta nawiz reꞌ benꞌ naxa ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Leꞌ David ngok profet nde mne xa', leꞌ Dios mkeꞌyek lo xa' leꞌga lo bin xa' ryo' ti Xa' tyob nyebeꞌ tenꞌ ndob nyebeꞌ David. ");
INSERT INTO ztp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Axta pola mdejla David, leꞌ Crist ryoꞌxban, jwanꞌ nasa nchab David, naꞌlaꞌd Dios Xaꞌ lenꞌ baꞌ nde nekla gàz belꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesús re' jwan' Dios mbloꞌxban nde reta náꞌ mne ke ta naka. ");
INSERT INTO ztp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Leꞌ naya, Dios, mbli naro Xaꞌ Jesús, mtob Xa' Jesús lad ban Xa', nde mkaya' Jesús Mbi Nayon, jwanꞌ ta mkeꞌyek Jesús tayaꞌ Xaꞌ lonꞌ nde naya mbla Xaꞌy yek reta náꞌ, jwanꞌna ta ngwiꞌ goꞌ nde nchon goꞌ naya. ");
INSERT INTO ztp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tak David nangwapta xaꞌ lo beꞌ, per nchab xaꞌ: Leꞌ Xaꞌ Nyebeꞌ nchab lo Xaꞌ Nyebeꞌ lon: “Ptob lad ban na, ");
INSERT INTO ztp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","axta kebeꞌ lín sa re xaꞌ nayiꞌ loa ak xa' xis jwan' tyob nia.” ");
INSERT INTO ztp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Re go' men Israel, mne go' leꞌga Jesús re', Xaꞌ jwanꞌ mkeꞌ goꞌ lo kruz, Dios mblilal Xaꞌ, Xaꞌ Nyebeꞌ nde Xa' mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Senꞌ lo mbin re men jwanꞌ reꞌ, mden' xa'y len' lazo' xa' sa mnabdiꞌs xaꞌ lo Pedr nde lo ti pla apóst, nchab xaꞌ: —Wesa, ¿cho kwan ndablo li ná'? ");
INSERT INTO ztp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Zyasa nchab Pedr lo re xaꞌ: —Blaꞌ goꞌ re jwanꞌ narax nak go' nde bere goꞌ lo Dios nde kad thiba goꞌ bro'le lo le Jesucrist, sa tonꞌ Dios re xken goꞌ nde kayaꞌ goꞌ Mbi Nayon taꞌlaꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tak jwanꞌ reꞌ nak jwan' mkeꞌyek Dios lo reta goꞌ nde lo re xinꞌ goꞌ, nde lo reta men ndo tij; nde noga lo reta men jwanꞌ ncholaꞌs Dios na' Xa' Nyebe' kwez Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kon di's re' nde masraꞌ di's jwan' mni Pedr nde mtoni Pedr xaꞌ, nchab Pedr: Ptola' go' lazo' go' lo re jwan' narax ta nzo naya. ");
INSERT INTO ztp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Leꞌ re xa' ta mblí lazonꞌ diꞌs jwanꞌ mdej Pedr mbroꞌle xaꞌ nde ti son milka xaꞌ mbike wiz ya, lo re xaꞌ jwan' nzila. ");
INSERT INTO ztp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nde thiblaꞌ nxobyek xaꞌ re jwanꞌ ndloꞌ re apóst, thita nak re xaꞌ, sen' ncha xa' nde sen' ndyodiꞌsno xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nde axta mbixpa' xa' lo ngwi' xa' re yalbzye nde yalnaro jwan' ndli re apost. ");
INSERT INTO ztp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Reta xaꞌ jwanꞌ ndli lazonꞌ Jesús thipta mbre xaꞌ nde thipta mdi'd xa' lo ta xa' re jwanꞌ mkeno xa'. ");
INSERT INTO ztp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mtho xaꞌ izyon xaꞌ nde re jwanꞌ ngeno xaꞌ, nde ngiꞌd xaꞌ tmi lo reta xaꞌ, axaja nak yalti jwanꞌ ngeno kad thiba xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nde reta wiz thibla' ndyop xaꞌ tenꞌ ndob yodoꞌ, thita ncha re xa' liz ta xa', kon yalnale ngi'd xa' jwan' ncha xa', ngencho nabiz chan' na', ");
INSERT INTO ztp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ndli naro xaꞌ le Dios, nde wen ngwiꞌ re mayez xaꞌ. Nde Xaꞌ Nyebeꞌ ndli sa re wiz ndola masraꞌ men xij xaꞌ, re men jwanꞌ lyaꞌ lo xken naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedr kon Juan thipta nda rop xaꞌ yodoꞌ hor son bzyeba, senꞌ nchal hor ndyodiꞌs no xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tya nchano xa' ti mbiꞌ xata ngol mbiꞌ na'akta tye mbi' nde reta wiz ndatob xaꞌ mbiꞌ ya ro yala chanꞌ yodoꞌ jwanꞌ ndole Nawe Nya, sa tya nyaꞌb xaꞌ yisa gon lo re men jwanꞌ nda yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mbiꞌ ya, sen' mbwi' xa' ndozin Pedr kon Juan ndoyote xa' yodoꞌ, zyasa mnaꞌb mbiꞌ gon lo rop xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Leꞌ Pedr kon Juan xe mbwiꞌ xaꞌ lo mbiꞌ ya nde nchab Pedr lo mbiꞌ: —Bwiꞌ lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Zyasa xe mbwiꞌ mbiꞌ lo Pedr kon lo Juan, nkembed mbiꞌ nyenꞌ kwan taꞌ rop xaꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Zyasa nchab Pedr lo mbiꞌ: —Naꞌngenot na plat nekla or tan kaa, per jwanꞌ ngenon jwanꞌna tan kaa. Lo le Jesucrist Xaꞌ Nazaret, ptoli nde pte. ");
INSERT INTO ztp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Zyasa mxen Pedr yaꞌ ban xaꞌ yisa, mtoli Pedr xaꞌ nde zyaga mbwaꞌ rop ni xaꞌ nde mbwin rop yen ni xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ngotoligalꞌ xaꞌ, tolo mde xaꞌ nde ngote xaꞌ yodoꞌ kon Pedr nde Juan, ngete xaꞌ, nchat gap xaꞌ nde ndaꞌ xaꞌ dyux lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nde reta men yes, mbwiꞌ men ndye xaꞌ nde ndaꞌ xaꞌ dyux lo Dios, ");
INSERT INTO ztp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mbyolo men xaꞌ, tak leꞌ xaꞌ ndyob ro yala chanꞌ yodoꞌ jwanꞌ ndole Nawe nya, tya nyaꞌb xaꞌ gon, nde nzoyen toz reta men axta nzyeb men jwanꞌ ngok. ");
INSERT INTO ztp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Leꞌ mbiꞌ ta mdyanꞌna nala'tirta xaꞌ Pedr kon Juan nde nzoyen toz re men, taja ndebe men lo xa' tenꞌ ndole ro korredor chanꞌ Salomón. ");
INSERT INTO ztp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Senꞌ mbwiꞌ Pedr reta men ya, zya nchab Pedr lo xaꞌ: —Re go' mbi' yez Israel, ¿Cho kwan taja nzoyen goꞌ jwanꞌ ngok? ¿Cho kwan taja ngwiꞌ goꞌ lo náꞌ, cho ndyak goꞌ kon yalne chanꞌ náꞌ o por nayon nak ná' sa mtodanꞌ náꞌ xaꞌ re'? ");
INSERT INTO ztp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios ta mbli lazo' Abraham, Isaak nde Jakob re xaꞌ gox lon' ngo pola, Dios ya mbli naro Xaꞌ Xinꞌ Xaꞌ Jesús, Xaꞌ ta mdayaꞌ goꞌ nguja nde naꞌnkapta goꞌ diꞌs senꞌ lo ne Pilat lyaꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Cheꞌla naꞌndaꞌd goꞌ diꞌs ndlaꞌ Xaꞌ Nayon nde Xaꞌ Galꞌ, leꞌ goꞌ mnaꞌb mblyaꞌ ti xaꞌ guj men. ");
INSERT INTO ztp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Per mbij goꞌ Xaꞌ nak xwanꞌ yalnaban, Xaꞌ jwanꞌ mbloꞌxban Dios xij re men nguj, nde náꞌ mne jwan' re'. ");
INSERT INTO ztp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nde lo ndlipa lazoꞌ náꞌ le Jesús, jwanꞌ nasa mbwaꞌ ni mbiꞌ ta ngwiꞌ goꞌ nde nzolo goꞌ reꞌ, tak lo ndlipa lazoꞌ náꞌ Jesús jwanꞌ nasa thiptane mdyanꞌ tir xaꞌ lo ta nzi wiꞌ reta goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Wesa, naya mnen, naꞌnyed goꞌ jwanꞌ mbli goꞌ senꞌ lo mkata goꞌ kon re xaꞌ nak sinꞌ sa mbij goꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per Dios mbli sa tamod ngok diꞌs jwanꞌ mni Dios lo re xaꞌ nak profet polaꞌ, senꞌ nchab xaꞌ: Leꞌ Crist nakinꞌka rid yalti. ");
INSERT INTO ztp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jwanꞌ nasa, blaꞌ goꞌ reta jwanꞌ narax nak go' nde deꞌ goꞌ lo Dios, sa tonꞌ Xaꞌ xken goꞌ, sa tel' Xaꞌ Nyebeꞌ re wiz jwan' nixa yo lazoꞌ goꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nde telꞌ Dios Jesucrist lo go', Xaꞌ ta nakwentla yeꞌd. ");
INSERT INTO ztp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xa' jwan' nakinꞌka yo lo beꞌ axta senꞌ yoxoꞌb beꞌ tokub Dios reta jwanꞌ, re diꞌs jwanꞌ mnabeꞌ Dios mdej re profet Nayon, xaꞌ ngo pola. ");
INSERT INTO ztp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tak Moisés nchab lo re xaꞌ gox ta mbre polaꞌ: “Leꞌ Dios Xaꞌ Nyebeꞌ lonꞌ, leꞌga xij goꞌ koꞌ Xaꞌ ti profet, ta xa mbloꞌ Xaꞌ na reꞌ, nde Xaꞌ ya nakinꞌ xobyek goꞌ lo reta jwanꞌ nye Xaꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nde re men jwanꞌ naꞌtonzada xkiꞌs profet ya, men ya ryoꞌtal xij yez Dios.” ");
INSERT INTO ztp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Nde re profet ngo pola, xata mdobtey kon Samuel nde masraꞌ re profet, mdej xaꞌ re jwanꞌ ndoyak naya. ");
INSERT INTO ztp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na' nak re men jwan' nde lo bin re profet ta ngo pola nde noga par naꞌ nak di's jwan' mke'yek Dios kon re xaꞌ gox lon' ta ngo pola, senꞌ nchab Dios lo Abraham: “Lo bin la li leyꞌ na re liz reta men nzo dib xis izyo.” ");
INSERT INTO ztp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tak senꞌ mbloꞌxban Dios Xinꞌ Dios, nerla lo goꞌ mtelꞌ Dios Xaꞌ sa kad tiba goꞌ laꞌ goꞌ re jwanꞌ narax nak goꞌ nde li leyꞌ Xaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Benꞌ ndoni Pedr kon Juan lo re men, zya mzin re ngwleyꞌ, kon xaꞌ nyebeꞌ lo re xaꞌ ngenap yodoꞌ nde re xaꞌ saduceo. ");
INSERT INTO ztp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Reta xaꞌ reꞌ, nxi lazo' xaꞌ tak Pedr kon Juan ndloꞌ xaꞌ lo re men nde mbez xaꞌ, ke re xaꞌ nguj toyal ryoꞌxban xaꞌ, ta xa mbroꞌxban Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jwanꞌ nasa mxen xaꞌ Pedr kon Juan nde mkeꞌ lizyiꞌb xaꞌ rop mbiꞌ ya tib yalꞌ, tak mzyela izyo wiz ya. ");
INSERT INTO ztp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per bro toz xaꞌ jwanꞌ mbin xkiꞌs Dios mbli lazoꞌ xaꞌy. Benꞌ re xaꞌ biꞌta mer mkata ti gayꞌ mil xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tedib wiz, reta xaꞌ nak sinꞌ ro lo yez, re xaꞌ nak sinꞌ lo men judí nde re maestr nchak ley xkiꞌs Dios, mdyop xaꞌ yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Noga Anás mbol ngwleyꞌ ro, Caifás, Juan kon Lejandr nde reta xaꞌ ta re xa' nak ngwleyꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nde mdoli xa' Pedr kon Juan xtowꞌ reta xaꞌ nde mnabdiꞌs xaꞌ lo rop xa': —¿Cho mdaꞌ di's o cho mda' yalnyebe' ndli goꞌ reta jwanꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Zyasa Pedr, dib xaꞌ mdeꞌ Mbi Nayon, nchab xaꞌ: —Goꞌ xaꞌ nak sinꞌ ro lo yez, nde re goꞌ jwanꞌ nak sinꞌ lo men Israel: ");
INSERT INTO ztp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Leꞌ naya goꞌ nyaꞌbdiꞌs lo náꞌ yalwen jwanꞌ ngok lo ti men nayiz, tak nchola's go' nye goꞌ xomod mdyan' xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tej náꞌy lo goꞌ nde lo reta men yez Israel, ndablo nye goꞌ leꞌ mbiꞌ ta ngok nadan'na ndo lo goꞌ reꞌ, mdyanꞌ xaꞌ kon le Jesucrist Xaꞌ Nazaret, Xaꞌ ta mkeꞌ goꞌ lo kruz nde Dios mbloꞌxban Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús reꞌ nak ke ta mblo'tal re goꞌ jwan' ntaꞌ yo nde naya ke ya ngolal ke jwanꞌ mas ntak. ");
INSERT INTO ztp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nde na'ngentra' cho tedib xaꞌ tolaꞌ men, tak na'ngenta tedib xaꞌ lo izyo, xaꞌ jwanꞌ mtelꞌ Dios lo re men, sa toyal lyanꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Zyasa mbwiꞌ re xaꞌ nak sinꞌ, xa naꞌnzyebta Pedr kon Juan ndyodiꞌs xaꞌ, nde mne re men, rop xa' re' nak xa' mbi' naꞌmteꞌdta nde naꞌngenod xaꞌ yalchak, jwanꞌ nasa mblibeꞌ re xaꞌ ke liga xis Jesús mketenke rop mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nde lo mbwi' xa' mbi' ta mdyan'na, ndoli mbi' xij xa', zyasa naꞌakta keꞌ xaꞌ yalke yek Pedr kon Juan. ");
INSERT INTO ztp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Zyasa mnabeꞌ xaꞌ mbroꞌte re yon mbi' ya xij ten nzi xa' nde mbyanꞌ benꞌta re xaꞌ nak sinꞌ sa mdodiꞌs xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nchab xaꞌ: —¿Cho kwan linonꞌ rop mbiꞌ reꞌ? Reta men yez Jerusalén mne men re yalnaro jwanꞌ mbli xaꞌ nde naꞌlid naꞌ gan ka's na'y. ");
INSERT INTO ztp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Leꞌ naya, par naꞌryastra diꞌs reꞌ dib yez, zeb naꞌ xaꞌ, sa na'todiꞌstra' xaꞌ le Jesús lo nek thib men. ");
INSERT INTO ztp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Zyasa mbrez xaꞌ rop mbiꞌ ya, mzeb xa' xa' nde mnabeꞌ xaꞌ, sa nek lud naꞌtodiꞌstra' xaꞌ nde naloꞌtra' xaꞌ le Jesús lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Leꞌ Pedr kon Juan mkab lo re xaꞌ ya, nchab xaꞌ: —Leꞌga goꞌ bli xgab cho galꞌ naka lo Dios, nerla goꞌ xobyek náꞌ xisla xobyek ná' Dios. ");
INSERT INTO ztp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tak na'lid ná' gan na'tejta náꞌ jwanꞌ mbwiꞌ náꞌ nde jwanꞌ mbin náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Zyasa re xaꞌ nak sinꞌ benꞌta mzeb xaꞌ Pedr kon Juan nde mblaꞌ xaꞌ xaꞌ, tak naꞌngasalta xaꞌ xomod toti xaꞌ xaꞌ, tak reta men yez ndaꞌ xaꞌ dyux lo Dios por jwanꞌ ngok. ");
INSERT INTO ztp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Le' mbiꞌ ta mbli Dios yalnaro lonꞌ ta mdyan'na, nzola xaꞌ masraꞌ choꞌ linꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Senꞌ lo mblaꞌ xa' Pedr kon Juan, mbere rop xaꞌ tenꞌ nzi masraꞌ ta xaꞌ, nde mdej xaꞌ re jwanꞌ nchab re ngwleyꞌ nyebeꞌ nde re xaꞌ gox jwan' nak sin' lo xa'. ");
INSERT INTO ztp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Senꞌ mbin xaꞌ jwanꞌna, thipta mbrez re xaꞌ lo Dios, nchab xaꞌ: —Xaꞌ Nyebeꞌ dib nax izyo, lu nak Dios, Xaꞌ mtoxkwaꞌ beꞌ, izyo, nittoꞌ nde reta jwanꞌ nzoy. ");
INSERT INTO ztp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lu mtob diꞌs ro David xaꞌ mbli sinꞌ loa, senꞌ nchab la: ¿Kwan liy nchak bxol reta men? ¿Kwan liy sa re men yez ndli xaꞌ xgab li xa' jwan' na'lid sinꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mdyopbe re men nak rey lo izyo, nde thipta ngok re men nak sinꞌ ro, sa mbyiꞌno xaꞌ Dios nde mbyiꞌno xaꞌ Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tak len' yez re', rey Herodes, Poncio Pilat, re xaꞌ naꞌnakta Israel nde re xaꞌ nak Israel, liga thipta ngok re xa' sa mbyiꞌno xaꞌ Xinꞌ la Jesús, Xaꞌ Nayon ta mtelꞌ la. ");
INSERT INTO ztp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chemod sa mbli re men reta jwanꞌ nakla xgab la, re jwanꞌ mtan'la lu ak. ");
INSERT INTO ztp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nde naya, Xaꞌ Nyebeꞌ, bwiꞌ plopa nzeb xaꞌ re náꞌ ta ndli sinꞌ loa, jwanꞌ nasa nyaꞌb náꞌ loa blaꞌsto náꞌ sa yo ne lazo' náꞌ todiꞌs náꞌ xkiꞌs la, ");
INSERT INTO ztp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","laja ptoga' yaꞌa sa dyanꞌ re men nayiz, ak re yalnaro nde ak re jwanꞌ nzoyen men, por lo le xinꞌ la Jesús Xaꞌ Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Senꞌ mne mdodiꞌsno xaꞌ Dios, le' tenꞌ nzidop xaꞌ mbwin ti xo, nde dib ben reta xa' mdeꞌ Mbi Nayon, nde naꞌnzyeb tirta xaꞌ ndej xaꞌ xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nde reta men ta mbli lazonꞌ Jesús, thita nak lazoꞌ re xaꞌ nde thita xgab ndli xaꞌ, nde nek tib xaꞌ naꞌnzoyaꞌd re jwanꞌ, cheꞌla thipta ngeno xaꞌ reta jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nde kon yalne ro ndej re apóst xa mbroꞌxban Jesús Xa' Nyebe' nde bro toz tir yalwen nkayaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jwanꞌ nasa naꞌngenta nek thib xaꞌ ndyak yalti xija, tak re xaꞌ jwanꞌ ngeno izyo o liz xaꞌ, ntho xaꞌy nde ndeno xaꞌ tmi jwanꞌ mdyoy, ");
INSERT INTO ztp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nde ndayaꞌ xaꞌy lo re apóst nde leꞌ apóst ngiꞌda axa nak yalti ngeno kad thiba xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Zyasa José, xa' jwan' mtob le re apóst Bernabé (diꞌs ya nak, xa' ngone lazo' men) nak xaꞌ men levita, leꞌ xaꞌ ngol lo xyon Chipre. ");
INSERT INTO ztp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Xaꞌ reꞌ ngeno thible izyo, mtho xaꞌy nde mbe' xaꞌ tmi, mdayaꞌ xaꞌy lo re apóst. ");
INSERT INTO ztp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per ngo ti mbiꞌ, ndole Ananías, kon salꞌ xaꞌ Safira, mtho xaꞌ thible izyon xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nde mne ngol mxen xaꞌ lud tmi nde naꞌmdayaꞌd xaꞌ re tmi lo re apóst. ");
INSERT INTO ztp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Zyasa nchab Pedr lo xa': —Ananías, ¿Cho kwan liy mdaꞌa diꞌs mnabeꞌ maxuꞌ lazoꞌa, ncholaꞌs la kwinꞌnoa Mbi Nayon nde naꞌmdayaꞌd la reta tmi jwanꞌ mthoa izyo? ");
INSERT INTO ztp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Senꞌ tera thoa izyo ¿Cho nanakte chanꞌ la? Nde senꞌ mthola luy ¿Cho nanakta tmin la jwanꞌna? ¿Cho kwan liy ta nya xgab mbla lazoꞌa? yalkwinꞌ ta mblia ba, namblid lay lo ná', lo Dios mbli lay. ");
INSERT INTO ztp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Senꞌ mbin Ananías re diꞌs ya, ngob xaꞌ izyo nde nguj xaꞌ. Re men mbin jwanꞌna mzyeb toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tya mbike pla or yenꞌ, mchal lar or thabol, mbloꞌter xaꞌ nde ngwa kaꞌs or xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mbriꞌta sonka hor mzin xaꞌ got Ananías per naꞌnyed xaꞌ kwan ngotey. ");
INSERT INTO ztp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Zyasa nchab Pedr lo ngol: —Ptej lon, ¿Cho yapka mtho goꞌ izyo? Leꞌ ngol mkab: —Aaꞌ, yapka ngway. ");
INSERT INTO ztp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Zyasa nchab Pedr lo ngol: —¿Cho kwan liy thipta ngok diꞌs rop ta goꞌ sa kwin'no goꞌ Xbin Xaꞌ Nyebeꞌ? Bwiꞌ, leꞌ re or yenꞌ ta ngwa kaꞌs salꞌ la ndelaba, nde naya, noga lu wer. ");
INSERT INTO ztp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Zyaga ngob ngol lo ni Pedr nde nguj ngol. Senꞌ ngote re or yenꞌna, mbwi'r nguj ngol, mbeꞌr thobol, ngwa kaꞌs or xa' cho salꞌ xa'. ");
INSERT INTO ztp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nde reta men yodoꞌ nde men ta mbin jwanꞌ reꞌ, mzyeb toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nde naꞌr toz re yalnaro nde yalbzye mbli Dios lo yaꞌ re apóst xij re men, nde thita nzidop reta xaꞌ tenꞌ nak ro korredor chanꞌ Salomón. ");
INSERT INTO ztp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Leꞌ masraꞌ re men nzyeb xaꞌ tsal'ta xaꞌ re apóst, per re men yez, wen toz ni men xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nde masraꞌ ndoyaꞌr re xaꞌ jwanꞌ ndli lazonꞌ Jesús, men toza, ngola nde mbiꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Taja nche' xaꞌ re men nayiz lo lon' nde lo yalonꞌ, ntob xaꞌ xa' ro ned sa lo rid Pedr masa xim Pedr dinꞌ yek xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Noga bro toz re men jwanꞌ nzo re yez nzi gax Jerusalén, ndeno xaꞌ re men nayiz, re men nzo mbi narax nde reta men ya mdyan' xa'. ");
INSERT INTO ztp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Zyasa mdosa' mbol ngwleyꞌ ro kon re xaꞌ saduceo, xaꞌ jwanꞌ nzino mbol tya, mbla yalno lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mxen xaꞌ re apóst, nde mblo xaꞌ apóst lenꞌ lizyiꞌb low. ");
INSERT INTO ztp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Leꞌ ti anj chanꞌ Dios, yalꞌ mbyeꞌd xalꞌ xaꞌ ro lizyiꞌb sa mbloꞌte anj re apóst nde nchab anj lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Wa goꞌ nde gote go' yodoꞌ, ptej goꞌ lo re mayez diꞌs chan' yalnaban kub reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Senꞌ mbin xaꞌ diꞌs reꞌ, tilꞌ mzin xaꞌ yodoꞌ nde mbloꞌ xaꞌ xkiꞌs Dios lo re men. Laja leꞌ mbol ngwleyꞌ ro kon re xaꞌ jwanꞌ thita nak kon mbol, mbrez xaꞌ re xaꞌ nak sinꞌ lo men judí, sa todiꞌs xa', nde mnabe' xaꞌ yayo' re apóst ta nge lizyi'b. ");
INSERT INTO ztp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Leꞌ re xaꞌ ngenap yodo' sen' mzin xa' lizyiꞌb, na'ngenta re apost tya. Zyasa mbere xaꞌ nde mdej xaꞌy, ");
INSERT INTO ztp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","nchab xaꞌ: —Mbwiꞌ náꞌ saj nowꞌ dib lizyiꞌb nde re xaꞌ jwan' ngenap, nzi xaꞌ le ro lizyiꞌb; lo senꞌ mxalꞌ náꞌy, ngenta cho nak lenꞌ lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Senꞌ mbin mbol ngwleyꞌ ro jwanꞌ reꞌ nde kon xaꞌ nyebeꞌ lo re xaꞌ ngenap yodoꞌ nde re ngwleyꞌ jwanꞌ nyebeꞌ, mbli toz xaꞌ xgab xomod yolo re jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Zyasa mzin ti xaꞌ nchab: —Le' re mbi' ta mkeꞌ goꞌ lizyiꞌba, leꞌ xaꞌ nzi yodoꞌ nzitoteꞌd xaꞌ re men. ");
INSERT INTO ztp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Zyasa yub xa' jwan' nyebe' lo re xaꞌ ngenap yodoꞌ kon re men xa', ngwaxen xaꞌ re apóst nde na'ntotid xa' xa' tak mzyeb xaꞌ gad ke mayez xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Senꞌ lo mzino xa' re apóst, mbeꞌ xaꞌ xaꞌ lo re xaꞌ nak sinꞌ, leꞌ mbol ngwleyꞌ ro mnabdiꞌs, ");
INSERT INTO ztp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","nchab mbol lo xaꞌ: —¿Cho naꞌmnabeꞌd náꞌ lo goꞌ sa naꞌloꞌtra goꞌ le xa' ya lo re men? Nde naya, mdib yez Jerusalén ndoli lazoꞌ men jwanꞌ ndloꞌ goꞌ nde ncholaꞌs goꞌ yek náꞌ keꞌ goꞌ yalke ta nguj mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Zyasa mkab Pedr nde kon re apóst nchab xaꞌ: —Nakinꞌ nerla Dios xobyek náꞌ, zyaraꞌ xobyek na' men. ");
INSERT INTO ztp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dios chanꞌ re xaꞌ gox lonꞌ mbre pola, Dios ya mbloꞌxban Jesús, Xaꞌ jwanꞌ mbij goꞌ nde mkeꞌnga goꞌ Xaꞌ lo kruz. ");
INSERT INTO ztp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jesús ya, mbli naro Dios Xaꞌ nde ndob Xaꞌ lad ban Dios, sa nyebeꞌ Xaꞌ nde tolaꞌ Xaꞌ men, sa re men Israel laꞌ men re jwanꞌ narax nak men nde bere men lo Dios nde dyonꞌ xken men. ");
INSERT INTO ztp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nde náꞌ nak xaꞌ mbwiꞌ reta jwanꞌ reꞌ nde noga Mbi Nayon mbwiꞌy, Mbi Nayon ta mdaꞌ Dios lo re men jwanꞌ nxobyek Dios. ");
INSERT INTO ztp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Senꞌ mbin re xaꞌ nak sinꞌ jwanꞌna, mxitin lazoꞌ xaꞌ nde ncholaꞌs xaꞌ kuj xaꞌ re apóst. ");
INSERT INTO ztp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Zyasa xij re xaꞌ ta nzi tya, ngotoli ti xaꞌ fariseo ndole Gamaliel xaꞌ nchak toz ley chanꞌ Moisés nde re men yez nxobyek toz men xaꞌ, zya mnabeꞌ Gamaliel mbroꞌte re apóst le thib atil, ");
INSERT INTO ztp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","nde nchab Gamaliel lo re xa' nzi tya: —Re go' men las na, jwin bli goꞌ xgab jwanꞌ lino goꞌ re mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tak neraꞌ, ngo ti xaꞌ ndole Teudas, nchab xaꞌ nak xaꞌ ti xaꞌ ro nde mkata thap ayoꞌ men mketenke xis xaꞌ. Per senꞌ mbij men xaꞌ, le' re men jwanꞌ mketenke xis xaꞌ mbryaꞌs men nde tyaja ngolo chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Xis xa' ya, ngoche tedib xaꞌ ndole Judas xaꞌ Galilea, len' wiz jwan' ndyen le xaꞌ re men, taga bro toz men mdonke xis Judas, per senꞌ nguj xaꞌ, reta men jwanꞌ mdonke xis xaꞌ mbryaꞌs men. ");
INSERT INTO ztp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jwanꞌ nasa nin lo goꞌ naya, bla' goꞌ re mbiꞌ reꞌ nde naꞌgalta goꞌ xaꞌ, tak tez jwanꞌ ta ndloꞌ xaꞌ o sinꞌ ta ndli xaꞌ ba naka chanꞌ men, tluxa. ");
INSERT INTO ztp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per tez naka chanꞌ Dios, naꞌlid goꞌ gan luxa, ndawiꞌ toz goꞌ, nday kon Dios ngeyo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Zyasa mbli re xaꞌ xgab, liga jwan' mdej mbi' ya. Mbrez xaꞌ re apóst, mdin xaꞌ xaꞌ nde mnabeꞌ xaꞌ naꞌtodiꞌstra' xaꞌ le Jesús, zyaraꞌ mblaꞌ xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Leꞌ re apóst, senꞌ mbroꞌte xaꞌ tenꞌ nzi re xaꞌ nak sinꞌ, nale toz ngo lazoꞌ xaꞌ, tak Dios mdaꞌ diꞌs nsal' xa' mbriꞌd xaꞌ yalti por le Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nde reta wiz nda xa' yodoꞌ nde re liz men, thiblaꞌ ndloꞌ xaꞌ nde ndej xaꞌ ke Jesús nak Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lenꞌ re wiz ya, senꞌ jwanꞌ toz ndoya'r re men ndli lazonꞌ Jesús, zyasa re xaꞌ ni diꞌs gryeg mbrezno xaꞌ re xaꞌ ni diꞌs hebreo nchab xaꞌ, leꞌ re ngol nguj salꞌ naꞌ, xaꞌ jwanꞌ ni diꞌs gryeg naꞌndokayaꞌd xaꞌ jwanꞌ nakinꞌ xaꞌ re wiz jwan' xa ndabloy. ");
INSERT INTO ztp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Zyasa re thibsen apóst mthopbe xaꞌ reta men ta ndli lazoꞌn Jesús nde nchab xaꞌ: —Naleꞌda naka laꞌ náꞌ na'tejtra' náꞌ xkiꞌs Dios, sa benꞌ wi' náꞌ jwanꞌ nakinꞌ re men. ");
INSERT INTO ztp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jwanꞌ nasa re go' wes na, ptan na, pkwanꞌ goꞌ gaz mbiꞌ xij reꞌ, xaꞌ jwanꞌ wen nzoꞌb xkiꞌs naꞌ, dib xaꞌ mdeꞌ Mbi Nayon nde nchen xaꞌ, lo xaꞌ ya tayaꞌ náꞌ sinꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sa leꞌ náꞌ thibka todiꞌsno náꞌ Dios nde tej náꞌ xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zyasa mbroꞌ lazoꞌ reta men diꞌs ya, nde mblí xaꞌ Esteb, mbiꞌ ndli toz lazonꞌ Dios nde xa' mdeꞌ Mbi Nayon, tya mblí xaꞌ Blib, Prokoro, Nicanor, Timón, Parmen, nde Lax, xaꞌ yez Antioquía, xaꞌ jwanꞌ ngolal xaꞌ judí. ");
INSERT INTO ztp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Zyasa ngwano xaꞌ re gaz mbiꞌ reꞌ lo re apóst, sa mnaꞌb xaꞌ lo Dios nde mxoꞌb xa' yaꞌ xaꞌ yek re gaz mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Leꞌ xkiꞌs Dios masraꞌ ndoraꞌsa nde taja ndoyaꞌr re men jwan' ndli lazonꞌ Jesús yez Jerusalén; noga naꞌr re xaꞌ nak ngwleyꞌ mxobyek xaꞌ mblipa lazoꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nde Esteb, nak xaꞌ men mdeꞌ yalwen nde yalnyebeꞌ chanꞌ Dios, sa ndli xaꞌ re yalnaro toz nde yalbsye' xij re men yez. ");
INSERT INTO ztp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Zyasa pla xaꞌ jwan' ndye yo ten' ndyop re xa' Israel jwan' ndole Mos Mblyaꞌ, nde pla xa' jwan' mbroꞌ yez Ciren, yez Alejandria, lo xyon Cilicia nde lo xyon Asia, re xaꞌ ya jwinka ngwa xaꞌ kwent kon Esteb. ");
INSERT INTO ztp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per naꞌndlid xaꞌ gan lo Esteb, tak Esteb ndyodiꞌs kon yalnchak ndaꞌ Mbi Nayon lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Zyasa mdi'x xaꞌ mka pla men, sa gab men ke mbin xaꞌ mni xin Esteb xis Moisés nde xis Dios. ");
INSERT INTO ztp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nde tamod mtoxol xaꞌ reta mayez, re xaꞌ nak sinꞌ lo men judí nde re xaꞌ jwanꞌ nak maestr ndloꞌ ley xkiꞌs Dios, mbla xa' xis Esteb nde mxen xaꞌ Esteb nde mbeꞌ xaꞌ xaꞌ lo xaꞌ nak sinꞌ ro lo yez xa'. ");
INSERT INTO ztp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nde mkwanꞌ xaꞌ pla men kwinꞌ jwan' nchab: —Mbiꞌ reꞌ thiblaꞌ ni xin xaꞌ xis yodoꞌ nayon reꞌ nde xis ley chanꞌ Dios, ");
INSERT INTO ztp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","noga nchon náꞌ ndej xaꞌ, leꞌ Jesús Xaꞌ yez Nazaret lux Xaꞌ yodoꞌ reꞌ nde tseꞌ Xaꞌ mod gox jwanꞌ mtanꞌno Moisés naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Zyasa reta xaꞌ nak sinꞌ ro lo yez jwanꞌ nzi ndob tya senꞌ mbwiꞌ xaꞌ lo Esteb, mbwiꞌ xaꞌ xaja nya lo ti anj nya lo Esteb. ");
INSERT INTO ztp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Leꞌ xaꞌ nak ngwleꞌy ro mnabdiꞌs lo Esteb, nchab xaꞌ: —¿Cho li re di's ta ndej men xis la? ");
INSERT INTO ztp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Leꞌ Esteb mkab: —Reta goꞌ wes na nde men nak sinꞌ ro lo yez, bin goꞌ jwanꞌ nin lo goꞌ: Leꞌ Dios lo beꞌ mbroꞌto lo xud na' Abraham, senꞌ benꞌ nzo xaꞌ lo xyon Mesopotamia, senꞌ tera' ya xaꞌ yo xaꞌ lo xyon Harán. ");
INSERT INTO ztp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Zya nchab Dios lo xaꞌ: “Blaꞌ izyon la nde re xaꞌ taa, nde wa izyo jwanꞌ loꞌn loa.” ");
INSERT INTO ztp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Zyasa mbroꞌ Abraham lo xyon Caldea nde nda xaꞌ ngo xaꞌ yez Harán nde senꞌ nguj xud xaꞌ tya, zya ndeno Dios xaꞌ izyo reꞌ, tenꞌ nzo goꞌ naya. ");
INSERT INTO ztp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nde naꞌmdayaꞌd Dios izyo reꞌ lo xaꞌ, nek thib ble luda; per Dios mkeꞌyek tayaꞌy lo re men jwanꞌ yeꞌd lo bin chanꞌ Abraham, tenyega zya naꞌngenta xinꞌ Abraham. ");
INSERT INTO ztp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Noga nchab Dios: Re men jwanꞌ yeꞌd lo bin Abraham, yo xaꞌ ti yez tenꞌ naꞌnakta yez xaꞌ, tya toti toz men xaꞌ, li xaꞌ sinꞌ nde naꞌyaxta ka xaꞌ dib ti thap ayoꞌ linꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Noga nchab Dios: “Na nyaꞌb kwent lo yez tenꞌ ta li xaꞌ sinꞌ naꞌyaxta ka xaꞌ nde xisa ryoꞌte xaꞌ yez ya sa yeꞌd xaꞌ li xa' sin' lon ncheꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nde msal' Dios xkiꞌs Dios kon Abraham, nchab Dios: tyob be' lad men biꞌ. Jwanꞌ nasa senꞌ lo ngol Isaak xinꞌ Abraham, mdob xa' be' lad or senꞌ nzor xon wiz; taga' mbli Isaak kon xinꞌ xaꞌ Jakob nde tagaꞌ mbli Jakob kon re tib sen xinꞌ xaꞌ, re tib sen xaꞌ jwanꞌ ngok mdan lo Israel. ");
INSERT INTO ztp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Le' re xinꞌ Jakob reꞌ, mbyiꞌnor wes or José nde mthor José, sa mbeꞌ men José yez Egipto. Leꞌ Dios thiblaꞌ ndono José, ");
INSERT INTO ztp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nde mtolaꞌ Dios José lo reta yalti, mdaꞌ Dios yalnchak lo xaꞌ nde mbli Dios sa Faraón rey Egipto wen mbwiꞌ xaꞌ José, nde mdob rey José sa nyebeꞌ José lo reta yez nzi Egipto nde nyebeꞌ José lo re men liz rey. ");
INSERT INTO ztp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Zya ngo win nde yalti toz dib lo xyon Egipto nde lo xyon Canaán, leꞌ re xaꞌ gox xud ná jwanꞌ ngo pola, naꞌngenta jwanꞌ wa xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Senꞌ mbin Jakob nzo trig Egipto, zya mtelꞌ ner xaꞌ re xaꞌ gox lonꞌ xa' ngo pola sa yaka xaꞌ trig Egipto. ");
INSERT INTO ztp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lo ngok brop gob ngwa xaꞌ, zyasa mdej José lo re wes José cho nak José nde tamod mne Faraón cho lo bin nde José. ");
INSERT INTO ztp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nde mnabeꞌ José ngwayoꞌ xud xaꞌ Jakob nde reta men ta xaꞌ, lo reta xaꞌ mkata songal nzo sinꞌ xa'. ");
INSERT INTO ztp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tamod mzin Jakob Egipto, tya nguj xaꞌ, nde tyaga' nguj re xaꞌ gox lonꞌ ngo pola. ");
INSERT INTO ztp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Sen' nguj xa' mbeꞌ xaꞌ xa' yez Siquem nde mkaꞌs xaꞌ xa' baꞌ jwanꞌ mxiꞌ Abraham lo re xinꞌ Hamor tenꞌ nak yez Siquem. ");
INSERT INTO ztp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Senꞌ ndosin gax beꞌ ak jwanꞌ mkeꞌyek Dios, jwanꞌ ta mdaꞌ Dios xkiꞌs Dios lo Abraham, leꞌ yez Israel mxyena nde mbyaꞌr toz xaꞌ yez Egipto. ");
INSERT INTO ztp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Axta kebe' mblatob tedib rey kub Egipto, xaꞌ ya naꞌmbyolod xaꞌ José. ");
INSERT INTO ztp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nde rey ya, mkwinꞌno xaꞌ re men las naꞌ, mtoti xaꞌ reta xaꞌ gox lonꞌ mbre pola, mnabeꞌ rey lo xa' mbla' xaꞌ reta mbed biꞌn xa' sa gaj or, nde tamod nayaꞌrta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Leꞌxa zya ngol Moisés, ti mbed jwanꞌ mbroꞌ lazoꞌ Dios; nde sonta mbeꞌ mxyen mbed lo xna' mbed. ");
INSERT INTO ztp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tyaja mbla' xaꞌ mbed gaj mbed, leꞌ mzaꞌ xinꞌ Faraón mzyal mbed nde mxenꞌ mzaꞌ mbed xajka xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nde mtoteꞌd xaꞌ Moisés lo reta yalnchak chanꞌ men Egipto, ngolal xaꞌ ti mbiꞌ nchak, xa ndyodiꞌs xaꞌ tagaꞌ ndli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Senꞌ nzo Moisés choꞌ linꞌ, zya ngol lazo' xaꞌ ngwatna xaꞌ re men laz xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Senꞌ mbwiꞌ Moisés, ti xaꞌ Egipto ngetoti xaꞌ ti xaꞌ Israel, zyasa mbla Moisés xaꞌ Israel, mbij Moisés xaꞌ Egipto, tamod mblota Moisés jwanꞌ ta mblino xaꞌ Egipto xa' Israel. ");
INSERT INTO ztp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tak ndli Moisés xgab mnela re xaꞌ Israel por Moisés sa tolaꞌ Dios xaꞌ lo yaꞌ Egipto, per re xaꞌ Israel naꞌgyenta xaꞌ cho ta naka. ");
INSERT INTO ztp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tedib wiz ngosiꞌb Moisés chop xaꞌ Israel, nzi yo xaꞌ nde ncholaꞌs Moisés naꞌyod xaꞌ, sa nchab Moisés lo xaꞌ: “Thita men laz goꞌ¿Cho kwan liy sa ngyo goꞌ?” ");
INSERT INTO ztp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Zyasa leꞌ xaꞌ ta ngekeꞌy cho tanꞌ ya, mtobya' xaꞌ Moisés nde nchab xaꞌ: “¿Cho mtob la sa nyebeꞌa nde nyaꞌb la kwent lo náꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Cho ncholaꞌs la kuj la na, ta xa mbij la xaꞌ egipcio naꞌya?” ");
INSERT INTO ztp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Senꞌ mbin Moisés jwanꞌna, mxonꞌ xaꞌ nde nda xaꞌ ngo xaꞌ tenꞌ na'nakta laz xa', lo xyon Madián. Tya mkeno xa' chop xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Senꞌ mbriꞌd ndaꞌbla choꞌ linꞌ, mbroꞌto ti anj lo Moisés xij bel jwanꞌ ndoyol lo ya yis tenꞌ nak izyo bis gax tenꞌ nak yiꞌ Sinaí. ");
INSERT INTO ztp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Zyasa nzoyen toz Moisés jwanꞌ ta ndowiꞌ xaꞌ, nde senꞌ mbike gax xaꞌ sa jwin wiꞌ xaꞌy, zya mbin xaꞌ mni Xa' Nyebe' nde nchab Xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Na nak Dios ta mbli lazoꞌ re xaꞌ gox loa ngo pola, Dios ta mbli lazo' Abraham, Dios ta mbli lazo' Isaak, nde Dios ta mbli lazo' Jakob.” Leꞌ Moisés tolo mxiꞌd xaꞌ nde naꞌngwitraꞌ xaꞌ lo bel. ");
INSERT INTO ztp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Le' Xa' Nyebe' nchab lo Moisés: “Bkib yalyid nia, tak izyo tenꞌ ndoa nayon naka. ");
INSERT INTO ztp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tak ngwiꞌn plopa yalti ndoriꞌd yez na jwanꞌ nzi Egipto. Nchon na re jwanꞌ mbez xaꞌ, nde naya ndal na sa tolaꞌn xaꞌ. Jwanꞌ nasa, naya, ptosaꞌ, sa tel na lu Egipto.” ");
INSERT INTO ztp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nde Moisés ta mblotal xaꞌ, men ta nchab xaꞌ lonꞌ: “¿Cho mtob la sa nyebeꞌa nde nyaꞌb la kwent lo náꞌ?” Moisés ya ta mtelꞌ Dios xaga xaꞌ nyebeꞌ nde xaꞌ tolaꞌ men, lo ta mni anj lo Moisés sen' mbroꞌto anj ti lo ya yis. ");
INSERT INTO ztp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nde Moisés ya jwan' mbloꞌte re xaꞌ Israel, mbli xa' re yalnaro nde jwan' nzoyen men lo xyon Egipto, lenꞌ nittoꞌ Nane, nde izyo biz, dib thi cho' lin'. ");
INSERT INTO ztp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nde leꞌga Moisés ya ta nchab lo re men Israel: “Leꞌga xij goꞌ koꞌ Dios ti profet xa na reꞌ nde gon goꞌ diꞌs ro Xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Leꞌga Moisés ya mdono re xaꞌ Israel izyo bis tenꞌ nak yiꞌ Sinaí sa tya mni anj chanꞌ Dios lo Moisés nde mbriꞌd xaꞌ diꞌs lo re xaꞌ gox lonꞌ ta mbre pola, sa mkayaꞌ xaꞌ diꞌs ndaꞌ yalnaban jwanꞌ ta ngenoꞌn naya. ");
INSERT INTO ztp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Per re xaꞌ gox lonꞌ ta mbre pola, naꞌngonta xaꞌ diꞌs ro Moisés, mblo'tal xaꞌy nde len' lazo' xa' mdob bere xaꞌ Egipto. ");
INSERT INTO ztp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nde nchab xaꞌ lo Aarón: “Ptoxkwaꞌ pla dios loꞌ ned lonꞌ, tak Moisés ta mbloꞌtenꞌ izyo Egipto, naꞌnyet naꞌ kwan mxak xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Zyasa mdoxkwaꞌ xaꞌ ti mnab ngon yenꞌ, nde mbij xaꞌ maꞌ yon lo mnab nde nale toz ngo lazoꞌ xaꞌ lo jwanꞌ mdoxkwaꞌ yaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Zyasa mbla'ya' Dios xaꞌ nde mdaꞌ Dios di's mbli naro xaꞌ reta jwan' nzi'b lo beꞌ. Xa nchabka lo yeꞌs mkeꞌ re profet: ¿Men Israel, dipta choꞌ linꞌ jwanꞌ mdo goꞌ ned izyo biz ¿Cho mbij goꞌ maꞌ yon jwan' mdaya' go' lon? ");
INSERT INTO ztp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Cheꞌla nxob yen go' yo ndob Moloc, nde taga' mbli goꞌ kon mnab mbel lo beꞌ ndole Renfán, re mnab jwanꞌ leꞌga goꞌ mdoxkwaꞌ sa li naro goꞌy. jwanꞌ nasa tel na goꞌ mas tij lo Babilonia. ");
INSERT INTO ztp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Leꞌ re xaꞌ gox lonꞌ ta mbre pola, mkeno xa' yo nayon ten' ngoza' xa' re jwan' nge ley chan' Dios ten' nak izyo biz, ta xa mnabeꞌ Dios lo Moisés lo nchab Dios, ndablo toxkwaꞌ xaꞌ yo axata naksaꞌ jwanꞌ ta mbloꞌ Dios lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Re xaꞌ gox lonꞌ jwanꞌ mbre pola, mkayaꞌ xaꞌ yo nayon reꞌ, mbe' xa'y kon Josué izyo jwanꞌ mkib Dios lo tedib ned men jwanꞌ naꞌnakta Israel, sa mdayaꞌ Dios izyo ya lo re xaꞌ gox lonꞌ ta mbre pola, nde tya mbyanꞌ yo Nayon axta wiz jwanꞌ mkete David. ");
INSERT INTO ztp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nde wen mbwiꞌ Dios David, nde nchola's David ntoxkwaꞌ xa' ti yo tenꞌ ak liz Dios, Dios na' Jakob. ");
INSERT INTO ztp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Che'la Salomón ngok xaꞌ jwanꞌ mtoxkwaꞌ yodoꞌn Dios, ");
INSERT INTO ztp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tenyega, leꞌ Dios, Xaꞌ naro toz, naꞌnchod Xaꞌ yo ntoxkwaꞌ yaꞌ men, xa nchabka profet: ");
INSERT INTO ztp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Che'mod ne Xa' Nyebe': Lo beꞌ nak tenꞌ ndob na, nde lo izyo nak tenꞌ ndyo nin. ¿Cho ned yo toxkwaꞌ goꞌ ak liz na? ¿o plo tenꞌ ryo'xkwen na? ");
INSERT INTO ztp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Cho naꞌnakta yub na mdoxkwa reta jwanꞌ re'? ");
INSERT INTO ztp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Tadka ndoni Esteb, nchab Esteb: —Ne toz yek go', ngok ke lazoꞌ goꞌ nde naꞌtyobta nza go', thiblaꞌ ntaꞌb goꞌ Mbi Nayon, lal nak goꞌ kon re xaꞌ gox lo goꞌ ta mbre pola. ");
INSERT INTO ztp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Re xaꞌ ya mchubla xa' reta profet, mbij xaꞌ re xaꞌ jwanꞌ mbyeꞌd tej ner ke yeꞌd ti Xaꞌ galꞌ, Xaꞌ galꞌ ya jwanꞌ ta mdaya' goꞌ nde mbij goꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Goꞌ jwanꞌ mkayaꞌ ley chan' Dios ta mdaꞌ re anj, nde naꞌnxobyekta goꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Senꞌ mbin xaꞌ re diꞌs ya, xaja kwana mkexyan xaꞌ nde anta nte's le xaꞌ ngwiꞌ xaꞌ lo Esteb. ");
INSERT INTO ztp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Leꞌ Esteb, dib xaꞌ ndono Mbi Nayon, mbwiꞌ xaꞌ lo beꞌ, ngoni lo xaꞌ xni chanꞌ Dios, nde mbwiꞌ xaꞌ Jesús ndo lad ban Dios. ");
INSERT INTO ztp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nde nchab Esteb: —¡Bwiꞌ goꞌ! Ngwiꞌn ndoxalꞌ lo beꞌ, nde ngwiꞌn leꞌ Xinꞌ Mbiꞌ mbyeꞌd lo izyo ndo Xa' lad ban Dios. ");
INSERT INTO ztp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Zyasa mbrez yaj reta xaꞌ, mtowꞌ xaꞌ nza xaꞌ nde thita ngok xa' mxen xa' Esteb. ");
INSERT INTO ztp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nde mbloꞌte xaꞌ Esteb ro yez, tya mbwad ke xaꞌ Esteb; leꞌ re xaꞌ jwanꞌ mkeꞌ yalkwinꞌ xis Esteb, mkib xaꞌ lar nzoꞌb xis xaꞌ nde mtanꞌno xaꞌy lo mbyo ndole Saulo. ");
INSERT INTO ztp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Laj ngegadke xa' Esteb, mna'b Esteb lo Dios, nchab xaꞌ: —Jesús Xaꞌ Nyebeꞌ, pkayaꞌ xbin na. ");
INSERT INTO ztp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nde mdoxub Esteb mbrez yaj xaꞌ, nchab xaꞌ: —Xaꞌ Nyebeꞌ, natyenta lu kwent jwan' narax ta ndli reta mbiꞌ reꞌ. Nde senꞌ ngolo nchab xaꞌ diꞌs ya, nguj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nde thita ngok Saulo kon re xa' jwan' mbluj Esteb. Len' wiz ya jwanꞌ toz mdobte mchubla xaꞌ re men ndli lazonꞌ Jesús, jwanꞌ nzi yez Jerusalén; nde mbryaꞌs reta xaꞌ dib lo xyon Judea nde lo xyon Samaria, benꞌta re apósta mbyanꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nde pla xaꞌ jwanꞌ nxoꞌbyek toz Dios, ngwa kaꞌs xaꞌ Esteb nde jwanꞌ toz mbinꞌno xaꞌ Esteb. ");
INSERT INTO ztp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mbay le' Saulo nchubla reta men ndli lazonꞌ Jesús, ndlya xaꞌ reta liz men, ngoꞌbnyo xaꞌ mbiꞌ nde ngol, nde nkeꞌ lizyiꞌb xaꞌ reta men ya. ");
INSERT INTO ztp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mbay leꞌ re xaꞌ ta mbryaꞌsa, nda xaꞌ reta yez ndatej xaꞌ diꞌs wen chanꞌ Jesucrist lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Zyasa mdola Blib nda xa' yez Samaria, tya mdobte mdej xaꞌ xkiꞌs Jesucrist lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nde thita ngok reta men, ntonza toz xaꞌ re jwanꞌ mdej Blib, nchon xaꞌ nde ngwiꞌ xaꞌ re yalnaro ro ndli Blib. ");
INSERT INTO ztp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tak bro toz re xaꞌ jwanꞌ nzo mbi narax lazonꞌ mbi yek xaꞌ nde re mbi naraxa anta mbez yaja ndyroꞌtey; nde bro toz re xaꞌ jwanꞌ naꞌakta tye nde re xaꞌ ngoꞌb ninꞌ mdyan' xaꞌ ");
INSERT INTO ztp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jwanꞌ nasa nale toz ngo lazoꞌ re men yez ya. ");
INSERT INTO ztp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per tya nzo ti mbiꞌ ndole Simón, xaꞌ reꞌ ndala ndli xa' yalmxí nde kon jwan'na nkwinꞌno xaꞌ re men nzi Samaria, nxyal' xa' xaga ti xa' ro toza. ");
INSERT INTO ztp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nde ntonza toz reta men xkiꞌs mbiꞌ ya, axta re xa' ntak lo yez nde re men tata ba, mbez xaꞌ: —Jwan' re nak yalne ro chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nde ntonza toz men xkiꞌs mbiꞌ ya, tak ndala ngetetokan xaꞌ re men kon re yalmxí jwanꞌ ndli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per senꞌ lo mbli lazoꞌ re men diꞌs wen lo yalnyebeꞌ chanꞌ Dios nde lo le Jesucrist jwanꞌ ndej Blib, zyasa ngol nde mbi' mbro'le. ");
INSERT INTO ztp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Noga yub Simón mbli lazoꞌ xa' Jesús nde senꞌ mbro'le Simón, thiblaꞌ mdonke xaꞌ xis Blib, nde nzoyen xaꞌ ngwiꞌ xaꞌ re yalnaro nde yalbzye jwanꞌ ndli Blib. ");
INSERT INTO ztp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Senꞌ mbin re apóst jwan' nzi Jerusalén, ke re men lo xyon Samaria mbli lazo' xa' xkiꞌs Dios, zyasa mtelꞌ xaꞌ Pedr kon Juan yez ya. ");
INSERT INTO ztp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Rop xaꞌ reꞌ, senꞌ ngotu xaꞌ tya, mnaꞌb xaꞌ lo Dios por re men ya, sa kayaꞌ xaꞌ Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tak nek thib xaꞌ nzi tya teraꞌ yatu Mbi Nayon yek xa'; benꞌta mbro'le xaꞌ lo le Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Zyasa Pedr nde Juan mxoꞌb yaꞌ xaꞌ yek re men ya, nde mkayaꞌ xaꞌ Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lo sen' mbwi' Simón, ke lo mxo'bya' apóst yek re men sa nkayaꞌ men Mbi Nayon, zyasa mta'b simón tmi lo xa', ");
INSERT INTO ztp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nchab Simón: —Noga lon pta' goꞌ yalnyebeꞌ ba, sa choja men jwan' xoꞌb yaꞌn yek na' kayaꞌ xaꞌ Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Zyasa nchab Pedr lo Simón: —Watobyaj kon tmin la, tak ndlia xgab kon tmi tiꞌa yalnyebeꞌ jwanꞌ ndaꞌlas Dios! ");
INSERT INTO ztp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Naꞌndaꞌblod la nde naꞌnsalꞌta lu lia sinꞌ reꞌ, tak nagalꞌta nak lazoꞌa lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bse' xgab la nde blaꞌ jwan' narax nak la, nde mnaꞌb lo Dios teꞌ tonꞌ Xaꞌ xgab narax ta ndlia ba; ");
INSERT INTO ztp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","tak ngwiꞌn jwanꞌ toz nzo naxí lazoꞌa nde lo ya' jwanꞌ narax nkedo'a. ");
INSERT INTO ztp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Zyasa mkab Simón, nchab xa': —Mnaꞌb goꞌ por na lo Xaꞌ Nyebeꞌ, sa na'tyakta na nek thib jwanꞌ ta ndej goꞌ ba. ");
INSERT INTO ztp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Leꞌ rop apóst, senꞌ mne mda' xa' kwent nde sen' mne mdodiꞌs xaꞌ xkiꞌs Dios, zya mbere xaꞌ yez Jerusalén, nde naꞌr toz re yez jwanꞌ nzi lo xyon Samaria mbri'd xa' mdej xaꞌ diꞌs wen chanꞌ Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Senꞌ ngolo jwanꞌna, ti anj chanꞌ Xaꞌ Nyebeꞌ nchab lo Blib: —Ptosaꞌ nde wa ned la, ned izyo nagán jwanꞌ ndryoꞌ yez Jerusalén nde nzina yez Gaza. ");
INSERT INTO ztp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Zya mdosaꞌ Blib nda xaꞌ. Nde ned ngosiꞌb Blib ti mbiꞌ eunuk yez Etyope xaꞌ, mbiꞌ reꞌ ntobzaꞌ tmi chanꞌ ti rey got, Candace lo xyon Etyope, leꞌ mbiꞌ ya ngwa taꞌ dyux lo Dios yez Jerusalén, ");
INSERT INTO ztp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","senꞌ mbere mbiꞌ, ndob xaꞌ lo karret xaꞌ, ndob lab xaꞌ yeꞌs mkeꞌ profet Isaías. ");
INSERT INTO ztp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Zyasa nchab Mbi Nayon lo Blib: —Wa nde bike gax cho karret ba. ");
INSERT INTO ztp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Senꞌ mbike Blib gax cho karret, zya mbin Blib leꞌ mbiꞌ ya ngelab yeꞌs jwanꞌ mkeꞌ profet Isaías; zyasa mnabdiꞌs Blib lo xaꞌ, nchab Blib: —¿Cho nchen la jwanꞌ ngelab la? ");
INSERT INTO ztp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Leꞌ mbiꞌ nchab: —¿Xomod yen nay ta naꞌngenta cho koxkana lon? Nde mnaꞌb xa' lo Blib yap Blib lo karret sa tyob Blib cho xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Leꞌ lo xkiꞌs Dios tenꞌ ngelab xaꞌ, che' nchaba: Xa ndano men ti mbakxilꞌ ten' kuj men ma' ba, ta mbeꞌ men Xaꞌ, Xaja ti mbakxilꞌ ta naꞌmbezta lo nchoꞌ xaꞌ yiꞌs lad maꞌ, ta mtow' ro Xa' ");
INSERT INTO ztp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Lo nala ngwi' men Xaꞌ, na'galta mna'b re xa' nak sin' kwent lo Xa'; naꞌmkenod Xaꞌ xinꞌ Xaꞌ, tak mkib men yalnaban chanꞌ Xaꞌ xis izyo. ");
INSERT INTO ztp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Leꞌ xaꞌ ta nak eunuka mna'bdiꞌs xaꞌ lo Blib, nchab xaꞌ: —Nyaꞌb na loa, ptej lon ¿Cho xaꞌ ta ndej profet ncheꞌ; cho leꞌga profeta o nzo cho tedib xaꞌy? ");
INSERT INTO ztp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Zyasa leꞌga tenꞌ ta ngelab xaꞌ ya, tya mxen Blib nde mdej Blib diꞌs wen chanꞌ Jesucrist lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Laj ndo rop xaꞌ ned mzin xaꞌ tenꞌ nzi nit nde nchab xaꞌ lo Blib: —¡Ncheꞌ nzo nit! ¿Cho nzo kwan nka diꞌs sa ryoꞌlen? ");
INSERT INTO ztp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Leꞌ Blib nchab: —Tez dib nzo lazoꞌa ndli lazoꞌa Jesucrist, toyala. Leꞌ xaꞌ nak eunuka mkab: —Ndli lazoꞌn Jesucrist nak Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Zyasa mnabeꞌ xaꞌ mblatob karret, mbla rop xaꞌ nde nda xaꞌ lenꞌ nit nde mblo'le Blib xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Senꞌ mbroꞌte xaꞌ lenꞌ nit, leꞌ Mbi Nayon chanꞌ Xaꞌ Nyebeꞌ mbliy mtiꞌ Blib, leꞌ xaꞌ nak eunuk naꞌngwiꞌtra xaꞌ Blib, nde nale nzo lazoꞌ xaꞌ nda xaꞌ xned xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Leꞌ Blib mbroꞌto yez Azoto, nde a xa ndarid Blib re yez taja ndatej Blib diꞌs wen chanꞌ Jesucrist lo re men, axta kebeꞌ mzin xaꞌ yez Cesarea. ");
INSERT INTO ztp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Laja Saulo tatka ngetetoseb xaꞌ kuj xaꞌ re men nak xin' te'd Xa' Nyebe', ngwa xa' lo mbol ngwleyꞌ ro, ");
INSERT INTO ztp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nde mnaꞌb xa' yeꞌs lo mbol sa ta' mbol di's yakwanꞌ xa' men biꞌ nde ngol, re men jwanꞌ nzo lo ned kub chanꞌ Jesús, tenꞌ nzi re yo jwanꞌ ndyop men Israel yez Damasco, nde yedno xaꞌ re mena yez Jerusalén sa keꞌlizyiꞌb xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Laj ndo Saulo ned, lo ndozin la xa' gax yez Damasco, zya xajta mbroꞌ ti xni ro lo beꞌ mblay dib tenꞌ ndo xa'. ");
INSERT INTO ztp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nde ngob xaꞌ izyo, zya mbin xa' mni ti Xaꞌ jwanꞌ nchab: —Saulo, Saulo, ¿Cho kwan liy ngetechublaa na? ");
INSERT INTO ztp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Leꞌ Saulo mkab lo Xaꞌ: —¿Cho goꞌ Xa' Nyebe'? Leꞌ Xaꞌ nchab: —Na nak Jesús, Xaꞌ ta ngete chublaa ba; leꞌga loa ngekwanꞌ la mas yalti ta xa ndli ngon sen' nkeꞌni ma' xi ya nalé. ");
INSERT INTO ztp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Leꞌ Saulo anta nxi'd nde nzyeb, mkab xaꞌ: Xaꞌ Nyebeꞌ ¿Cho kwan ncholaꞌs la lin? Leꞌ Xaꞌ Nyebeꞌ nchab: Ptoli nde gote lenꞌ yez, sa tya yaj loa nyenꞌ kwan ndablo lia. ");
INSERT INTO ztp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Leꞌ re xaꞌ jwanꞌ ndano Saulo, mzyeb toz xaꞌ tak mbin xaꞌ mni ti men, per ngen cho mbwi' xa'. ");
INSERT INTO ztp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Senꞌ mdoli Saulo nde mxalꞌ xaꞌ ngud lo xaꞌ per naꞌaktra' wiꞌ xaꞌ; zyasa mxen xa' ya' Saulo nde mbeꞌ xa' xaꞌ yez Damasco. ");
INSERT INTO ztp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tya mdob xaꞌ son wiz naꞌakta wiꞌ xaꞌ, naꞌngwad xaꞌ, nde nanguꞌd xaꞌ nit. ");
INSERT INTO ztp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yez Damasco ngo ti xinꞌ teꞌd Jesús ndole Ananías, lo xaꞌ ya mni Xaꞌ Nyebe xaja men nzalꞌ lazonꞌ ba nde nchab Xaꞌ: —¡Ananías! Leꞌ Ananías mkab: Na ncheꞌ Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Leꞌ Xaꞌ Nyebeꞌ nchab: —Ptosaꞌ sa leꞌa ya ned ndole Nali, liz Judas tya nyabdiꞌs la ti xaꞌ ndole Saulo, xaꞌ yez Tarso, tak naya leꞌ xaꞌ ndotodiꞌsno Dios, ");
INSERT INTO ztp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","nde xaja men ntzaꞌ lazonꞌ ba ndowiꞌ xaꞌ ti mbiꞌ ndole Ananías ngote tenꞌ ndob xaꞌ, mbiꞌ ya nxoꞌb yanꞌ yek xaꞌ sa toyal wiꞌ xaꞌ tedi gob. ");
INSERT INTO ztp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sen' mbin Ananías jwan'na, nchab Ananías: —Xaꞌ Nyebeꞌ, bro toz men ndej kwent chanꞌ mbi' ya lon, plopa ntoti xaꞌ re men nayon la, men nzi yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nde naya nde mbi' ya ncheꞌ kon yalnyebeꞌ chanꞌ re ngwleyꞌ nyebeꞌ, sa we xaꞌ re men ta ndli lazonꞌ lu nde keꞌ lizyiꞌb xaꞌ re men ya. ");
INSERT INTO ztp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Leꞌ Xaꞌ Nyebeꞌ nchab: —Wa, tak sinꞌ toz li xaꞌ reꞌ lon, mblín xaꞌ sa yatej xaꞌ xkiꞌs na lo re men naꞌnakta yez Israel, lo re rey nde lo re men yez Israel. ");
INSERT INTO ztp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tak na loꞌ lo xaꞌ plopa nakinꞌ rid xaꞌ yalti por na. ");
INSERT INTO ztp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Zyasa ngwa Ananías nde ngote xaꞌ lenꞌ yo tenꞌ ndob Saulo, mxob yaꞌ xaꞌ yek Saulo, nde nchab xaꞌ: —Wes Saulo, Jesús Xaꞌ Nyebe', Xaꞌ ta mbroꞌto loa ned ta ndea ya, Xaꞌ ya mtelꞌ na sa wiꞌa tedib gob nde dib la te' Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Zyaga, xaja bexa nya jwanꞌ ngob ngud lo Saulo nde mbwiꞌ xaꞌ tedib gob zya ngotoli xa' nde mbro'le xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Zya mda Saulo, sa ngo ne lazoꞌ xaꞌ. Nde mbled Saulo tipla wiz yez Damasco kon re xaꞌ jwanꞌ ndli lazonꞌ Jesús, xa' nzo tya. ");
INSERT INTO ztp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Zyaga mdobte mdej Saulo xkiꞌs Crist lo re men tenꞌ nzi re yo jwanꞌ ndyop men Israel, nchab xaꞌ, liga Xa' re' nak Xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nde reta xaꞌ ta nchon jwanꞌ ndej Saulo anta nzoyen xaꞌ, nchab xaꞌ: —¿Cho naꞌnakta xaꞌ re' ta nchubla re men yez Jerusalén, re men jwanꞌ nxobyek Jesús nde jwan'na ndeli xaꞌ ncheꞌ ndexen xa' men sa we xaꞌ men lo re ngwleyꞌ nyebeꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per Saulo masraꞌ ncho ne lazoꞌ xaꞌ nde ntokan xa' yek re xaꞌ judí nzo yez Damasco, ndlo' Saulo ke Jesús nak Crist. ");
INSERT INTO ztp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Senꞌ mbriꞌdla naꞌr wiz, ngok diꞌs re xaꞌ judí sa kuj xaꞌ Saulo, ");
INSERT INTO ztp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","per mbin Saulo jwan' ndoke xa' lino xa' Saulo. Yalꞌ nde ndlyabe ngenap xaꞌ reta tenꞌ nge yala ro yez, sa kuj xaꞌ Saulo, ");
INSERT INTO ztp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","zyasa re xin' te'd Jesucrist, yalꞌ mbeꞌ xaꞌ Saulo mblo xaꞌ xa' lenꞌ ti chokwid nde mbla xaꞌ xa' xis pto jwanꞌ nowꞌ dib ro yez Damasco. ");
INSERT INTO ztp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Senꞌ mzin Saulo yez Jerusalén, ncholaꞌs xaꞌ kata xaꞌ re xin' te'd Jesucrist; per reta men ya nzyeb xaꞌ Saulo, tak naꞌlid lazoꞌ xaꞌ cho no Saulo nak xin' te'd Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Per Bernabé mbe' Saulo nde ngwano xaꞌ Saulo lo re apóst, mdej Bernabé xamod mbwiꞌ Saulo Xaꞌ Nyebeꞌ ned, mdodiꞌsno Xaꞌ Nyebe' Saulo nde xa naꞌnzyeb tirta Saulo ndej Saulo xkiꞌs Jesucrist lo re men yez Damasco. ");
INSERT INTO ztp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nde ngo Saulo kon re apóst yez Jerusalén nde thipta mkete re xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","noga naꞌnzyepta xaꞌ mdej xaꞌ xkiꞌs Jesucrist lo re men, nde ngwa xaꞌ kwent kon re xaꞌ judí, xaꞌ ni diꞌs grieg, leꞌ re xaꞌ ya ndoke kuj xaꞌ Saulo. ");
INSERT INTO ztp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Senꞌ mbin re wes jwanꞌna, mbeꞌ xaꞌ Saulo yez Cesarea, nde tya mtelꞌ xaꞌ Saulo yez Tarso. ");
INSERT INTO ztp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Zyasa reta men jwanꞌ ndli lazonꞌ Jesucrist re xaꞌ nzi lo xyon Judea, Galilea nde Samaria nabeꞌz nzi xaꞌ. Taja ndoxen xaꞌ lo xkiꞌs Dios, nzeb lazoꞌ xaꞌ Xaꞌ Nyebeꞌ nde ndla'sto Mbi Nayon xaꞌ sa masraꞌ men ndoli lazo' xa' di's wen. ");
INSERT INTO ztp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Laj ngete tna Pedr re men jwanꞌ ndli lazonꞌ Jesús, noga ngwatna Pedr re men nayon nzo yez Lida. ");
INSERT INTO ztp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tya ngosiꞌb Pedr ti xaꞌ biꞌ ndole Eneas, ndala xon linꞌ nax yis xaꞌ na'akta tye xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Leꞌ Pedr nchab: —Eneas, Jesucrist todanꞌ la. Ptoli nde bka xabyis la. Nde zyaga mdoli Eneas. ");
INSERT INTO ztp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nde re men nzo yez Lida nde yez Sarón lo mbwiꞌ xaꞌ mdyan' mbi' ya, reta xa' mbli lazoꞌ xaꞌ Xa' Nyebe'. ");
INSERT INTO ztp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Zya yez Jope ngo ti ngol xin' te'd Jesús ndole Tabita, lo diꞌs gryeg ndole xaꞌ Dorkas. Ngol ya, dipta naban xaꞌ mbli xaꞌ yalwen nde mblaꞌsto xaꞌ re men ndyak yalti. ");
INSERT INTO ztp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lenꞌ wiz ya mxen yis Dorcas nde nguj xaꞌ. Nde senꞌ ngolo mbwad xaꞌ thabol, zya ngwathix xaꞌ thabol yo xtaꞌ gap. ");
INSERT INTO ztp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ma na leꞌ yez Lida nzi gax yez Jope, sen' mbin re xin' te'd Jesús tya ngete Pedr, zya mtelꞌ xaꞌ chop mbiꞌ ngwanaꞌb lo Pedr, nchab xaꞌ: —Ken la yeꞌd la ten' nzi náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Zyaga mdonke Pedr xis xaꞌ. Senꞌ mzin Pedr, mbeꞌ xaꞌ Pedr yo xtaꞌ lad gap tenꞌ nax thabol, tya re ngol jwanꞌ nguj salꞌ naꞌ nchon' xa' mbike xa' lo Pedr, ndloꞌ xaꞌ re lar jwanꞌ mdoxkwaꞌ Dorkas senꞌ naban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Zyasa mbloꞌte Pedr reta xaꞌ le, mdoxub Pedr nde mnaꞌb Pedr lo Dios, ngolo jwanꞌna mbwiꞌ Pedr lo thabol, nchab Pedr: —¡Tabit, goche! Leꞌ Tabit mxalꞌ ngud lonꞌ nde senꞌ mbwiꞌ xa' Pedr, mdobli xa'. ");
INSERT INTO ztp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Zyasa mxen Pedr yaꞌ xa' sa mdoli xa'; nde mbrez Pedr re ngol jwanꞌ nguj salꞌ naꞌ nde re xaꞌ jwanꞌ ndli lazonꞌ Jesús, sa mbloꞌto naban Pedr Tabit lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Reta men nzo yez Jope mbin xaꞌ jwanꞌ ngoka, nde bro toz men mbli lazoꞌ xa' Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nde bro ngo Pedr yez Jope, liz ti xaꞌ ndole Simón, xaꞌ nke sinꞌ lo yid maꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ngo ti xaꞌ yez Cesarea ndole Kornel, xaꞌ nyebeꞌ lo thib ayoꞌ sondad jwanꞌ ndenta ndole Italian, ");
INSERT INTO ztp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mbiꞌ reꞌ nde re liz xaꞌ nxoꞌbyek toz xaꞌ nde ntseb lazoꞌ xaꞌ Dios, ndaꞌ xaꞌ gon lo re men yez, nde thibla' nya'b xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ti wiz, nzoja hor son bzyeba, xaja men mzalꞌ lazonꞌ ba mbwiꞌpa xa' ti anj chanꞌ Dios ngote anj tenꞌ ndo xaꞌ nde nchab anj: —¡Kornel! ");
INSERT INTO ztp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Xe mbwiꞌ Kornel lo anj nde mna'bdiꞌs zeb xaꞌ: ¿Cho kwana Xaꞌ Nyebeꞌ? Leꞌ anj nchab: —Reta jwanꞌ nya'b la lo Dios nde gon jwan' ndaꞌa lo re men nzina lo Dios xaja jwan yon. ");
INSERT INTO ztp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bloned pla xaꞌ bi', naya, ya yez Jope sa yaxiꞌ xaꞌ Simón xaꞌ ndolegaꞌ Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Leꞌ Pedr nzo liz ti xaꞌ ndole Simón, xaꞌ nke sinꞌ kon yid maꞌ, liz xaꞌ ndob gax ro nittoꞌ, sa Pedr nye loa kwan ndablo lia. ");
INSERT INTO ztp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Senꞌ ndya anj ta ndoni lo Kornel, zya mbrez Kornel chop xaꞌ ndli sinꞌ lo Kornel, nde kon ti sondad, xaꞌ nxoꞌbyek toz Dios nde thiblaꞌ ndla'sto xa' Kornel. ");
INSERT INTO ztp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Senꞌ ngolo mdej Kornel lo xa' ya, re jwanꞌ mbwiꞌ Kornel, mbloned Kornel xa' yez Jope. ");
INSERT INTO ztp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tedib wiz, laj ndo re xa' ned, ndozin gax la xaꞌ yez Jope. Pedr ngwap yek yo sa todiꞌsno xaꞌ Dios, ndosin rolja wiza. ");
INSERT INTO ztp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Zya mziꞌb ndyanꞌ toz Pedr nde nchola's xaꞌ wa xaꞌ; per laj ndotoxkwaꞌ jwanꞌ wa xaꞌ, zya mbroꞌto ti jwanꞌ lo Pedr xaja men nzalꞌ lazonꞌ ba, ");
INSERT INTO ztp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","mbwiꞌ Pedr ndoxalꞌ lo beꞌ, nde tya mbroꞌ ti lar ro ndobo re thap nza neꞌy, ndalay mzina izyo. ");
INSERT INTO ztp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lo lara nzo re ned maꞌ jwanꞌ ndob thap ninꞌ, re maꞌ ndye lenꞌnaꞌ izyo, nde re maꞌ nxyobi lo be'. ");
INSERT INTO ztp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Zya mbin Pedr mni ti Xaꞌ: —Ptoli, Pedr, bij maꞌ nde bda. ");
INSERT INTO ztp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Leꞌ Pedr nchab: Xaꞌ Nyebeꞌ, na'wat nay, tak terka wan nek thib jwanꞌ bew nde jwanꞌ xkap. ");
INSERT INTO ztp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mbrop gob bere mni Xaꞌ lo Pedr, nchab Xaꞌ: Jwanꞌ ta mtombila Dios, naꞌkoled lay jwanꞌ bew. ");
INSERT INTO ztp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Son gob ngok jwanꞌna, le' lar ya bere ngwapa lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Laj ndoli Pedr xgab, cho kwan nak jwanꞌ ta mbroꞌto lo Pedr, zya mzin re mbi' ya ro yo, xa' ta mtelꞌ Kornel, ndona'bdiꞌs xaꞌ plo nak liz Simón. ");
INSERT INTO ztp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nde mbrez xaꞌ xis yala mna'bdiꞌs xaꞌ, cho tya nzo ti xaꞌ ndole Simón, xa' ndolega' Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Laj ngeli Pedr xgab jwanꞌ ta mbwiꞌ Pedr, leꞌ Mbi Nayon nchab lo Pedr: —Ncheꞌ mzin son mbiꞌ ndekwanꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ptoli, nde bla, nde naꞌakropta xgab la yankea xis xaꞌ tak na mtel xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Zyasa mbla Pedr, nda Pedr lo xaꞌ nde nchab Pedr: —Na cheꞌya, na ta nkwan' goꞌ. ¿Cho kwan liy nde goꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Leꞌ xaꞌ nchab: —Kornel, xaꞌ nyebeꞌ lo thib ayo' sondad, ti mbiꞌ galꞌ nde ntseb lazonꞌ Dios, nde reta men Israel wen ni men xis xaꞌ, ti anj nayon chanꞌ Dios mnabeꞌ lo xaꞌ sa mbloned xa' ná' ndexiꞌ náꞌ lu, yaa liz xaꞌ sa gon xaꞌ xkiꞌs la. ");
INSERT INTO ztp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Zyasa mtori'd Pedr xaꞌ lenꞌ yo, mdaꞌ Pedr tenꞌ mbled xaꞌ. Lo senꞌ mduxni tedib wiz, ndanke Pedr xis xaꞌ, nde noga tipla wes yez Jope mdonke xis Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Axta tedib wiz mzin xaꞌ yez Cesarea. Leꞌ Kornel ndobed la, mbrez Kornel reta men nak ta xaꞌ nde re men jwanꞌ mas nzalꞌta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Senꞌ ngote Pedr, zya mbroꞌte Kornel ngwa xiꞌ ned xaꞌ Pedr, nde mdoxub xaꞌ lo Pedr, li naro xa' Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Zyaga mtoli Pedr xaꞌ, nchab Pedr lo xaꞌ: —Ptoli, tak noga na men nak na. ");
INSERT INTO ztp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Laja ndatodiꞌsno Pedr Kornel, ngote rop xaꞌ lenꞌ yo, sa mbwiꞌ Pedr men toz nzidop tya. ");
INSERT INTO ztp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nde nchab Pedr lo re xaꞌ: —Goꞌ mne plopa narax naka lo ti men judí salꞌta xaꞌ o bike gax xaꞌ lo men jwanꞌ naꞌnakta judí. Per Dios mbloꞌ lon, nek thib men naꞌndabloda go'len, men bew o men xkap. ");
INSERT INTO ztp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jwanꞌ nasa, senꞌ mbrez goꞌ na, zyaga ndal na, naꞌnkabrot na. Nde naya nyabdiꞌs na, ¿Cho kwan liy sa mbrez goꞌ na? ");
INSERT INTO ztp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Zyasa nchab Kornel: Nal thap wiza, che'ja hor nge'lin yalse liz na hor byon, nde leja ndotodiꞌsnon Dios, zya mbwiꞌn mbroꞌto ti mbiꞌ lon, nok ti lar anta ndyob xni nya. ");
INSERT INTO ztp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nde ne xaꞌ lon: “Kornel, Mbinla Dios re jwanꞌ nya'b la lo Xaꞌ nde re gon jwan' ndaꞌa lo men nzin na lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Leꞌ naya bloned pla xaꞌ ya yez Jope, sa yaxiꞌ xaꞌ ti xaꞌ ndole Simón xaꞌ jwanꞌ ndolegaꞌ Pedr, leꞌ xaꞌ nzo liz tediba Simón, xaꞌ nke sin' lo yid maꞌ, liz xaꞌ ndob ro nittoꞌ; nde senꞌ sin Pedr liz la, xaꞌ nyey loa.” ");
INSERT INTO ztp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jwanꞌ nasa zyaga mbloned na pla mbiꞌ ngwaxiꞌa, nde wen mblia ndea ncheꞌ. Leꞌ naya ncheꞌ nzi reta naꞌ lo Dios, sa gon náꞌ reta diꞌs jwanꞌ mdaꞌ Dios loa tej la lo náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Zyasa mdobte mdodiꞌs Pedr nde nchab Pedr lo xaꞌ: —Naya liga mbyen na, ke Dios nambid Xa' men, ");
INSERT INTO ztp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","cheꞌla, one choja yez nde re men, nkaya' Dios men sen' ntseb lazoꞌ men Dios nde li men jwanꞌ galꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios mni lo reta men Israel, mdej Xaꞌ diꞌs wen chanꞌ yalnabeꞌz por Jesucrist nde Xaꞌ re' nak xwan' reta men. ");
INSERT INTO ztp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Goꞌ mne, reta jwanꞌ ngok dib lo xyon Judea, mdobtey lo xyon Galilea, lo senꞌ mbri'dla Juan, mdej Juan xkiꞌs Dios nde mblo'le xaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nde mne goꞌ xa mbli leyꞌ Dios Jesús mdaꞌ Xaꞌ Mbi Nayon nde yalnyebeꞌ lo Jesús, Xaꞌ Nazaret, nde xa mketeli Jesús re jwanꞌ wen nde mtodanꞌ Xaꞌ re men jwanꞌ ntoti maxuꞌ, reta jwanꞌ reꞌ mbli Jesús tak Dios ndo kon Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Reta ná' mbwi' jwanꞌ mbli Jesús lo xyon Judea, yez Jerusalén, nde mbij men Xaꞌ mkeꞌnga men Xaꞌ lo kruz. ");
INSERT INTO ztp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per ngoxoꞌb mbyon wiz mbloxban Dios Xaꞌ, nde mbli Dios mbroꞌto Xaꞌ; ");
INSERT INTO ztp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","nambroꞌtod Xaꞌ lo dib yez, leꞌ Xaꞌ mbroꞌto lo náꞌ tak ax mblía Dios náꞌ sa mne náꞌ re jwanꞌ ngok, mda náꞌ nde nguꞌ náꞌ kon Xaꞌ senꞌ mbroꞌxbanla Xaꞌ xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nde mnabeꞌ Xaꞌ lo náꞌ sa ya ta' náꞌ xki's Xa' lo yez, nde tej náꞌ ke Dios mdob Jesús sa nyaꞌb Xaꞌ kwent lo re men naban nde lo re men nguj. ");
INSERT INTO ztp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Xaꞌ reꞌ ta ndej re profet, reta men jwanꞌ li lazonꞌ Xaꞌ, por le Xa' dyonꞌ xken men. ");
INSERT INTO ztp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Laj ndotodiꞌs Pedr, leꞌ Mbi Nayon mblatuy yek reta xaꞌ ta nzi yon xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nde re xa' ta ndeno Pedr, xa' jwan' nxobyek toz jwan' ta tyob be' lad men bi', nzoyen toz xaꞌ mbwiꞌ xaꞌ, ke noga re men naꞌnakta judí nda'la's Dios Mbi Nayon mblatuy yek xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nde mbin re xaꞌ, ke re men ya ndyodi's xa' xaꞌla re ned diꞌs jwan' na'nchenta men nde kon di's ya mni xa' di's wen lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Zyasa nchab Pedr: —¿Cho nzo kwan ka diꞌs ryo'le re men reꞌ lo ta mkayaꞌa xaꞌ Mbi Nayon xa naꞌ reꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nde mnabeꞌ Pedr ryo'le xaꞌ lo le Jesús, Xaꞌ Nyebeꞌ. Zyasa mnaꞌb re xaꞌ lo Pedr, yanꞌ Pedr tya pla wiz. ");
INSERT INTO ztp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nde mbin re apóst nde re wes nzi lo xyon Judea ke noga men naꞌnakta Israel mbli lazoꞌ xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lo ngoxo'b Pedr yez Jerusalén, le' re xaꞌ judí jwanꞌ nxobyek toz tyob be' lad men biꞌba, mbrezno xaꞌ Pedr, ");
INSERT INTO ztp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nchab xaꞌ: —Cho kwan liy ngotea lenꞌ liz men naꞌnakta judí nde mdanoa xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Zyasa mdobte mdej Pedr lo re xaꞌ axata ngoka, nchab Pedr: ");
INSERT INTO ztp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Na ndo yez Jope ndotodiꞌsnon Dios, zya mbroꞌto ti jwanꞌ lon xaja' men nzalꞌ lazonꞌ ba, mbwiꞌn ndela ti jwanꞌ mbroꞌ lo beꞌ nyay xaja' nya ti lar nakis ro ndobo re thap nza neꞌy nde mzina tenꞌ ndon. ");
INSERT INTO ztp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Zyasa jwin mbwiꞌn nyenꞌ kwan nzo lo lar, nde tya nzo re ned maꞌ ndob thap ninꞌ, re maꞌ wan, re maꞌ ndye lenꞌ naꞌ xis izyo, nde re maꞌ nxobi lo be'. ");
INSERT INTO ztp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Zya mbin na mni ti Xaꞌ, ne Xaꞌ lon: “Pedr, ptoli, bij maꞌ nde bda.” ");
INSERT INTO ztp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Leꞌ na nchab lo Xaꞌ: “Xaꞌ Nyebeꞌ naꞌwat na maꞌ; tak terka wan nek thib jwanꞌ bew nde jwanꞌ xkap.” ");
INSERT INTO ztp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Zyasa bere mbin na mni Xaꞌ mbrop gob, ne Xaꞌ: “Jwanꞌ mtombila Dios naꞌkoled lay jwanꞌ bew.” ");
INSERT INTO ztp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tson gob ngok jwanꞌna lon, zyasa retay ngwap lo beꞌ tedib gob. ");
INSERT INTO ztp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nde zyaga mzin son mbiꞌ yo tenꞌ nzon, mbro' xa' axta Cesarea ndekwan' xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nde ne Mbi Nayon lon, naꞌakropta xgab la tyonkea xis xaꞌ. Noga re xop wes reꞌ mdonke xis na nde ngote náꞌ liz ti mbiꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","nde mbiꞌ ya mdobte mdej lo náꞌ xamod mbwiꞌ xaꞌ mbroꞌto ti anj liz xaꞌ, nde nchab anj lo xaꞌ: “Ptelꞌ pla mbiꞌ ya yez Jope, sa yaxiꞌ xaꞌ Simón xaꞌ jwanꞌ ndolegaꞌ Pedr, ");
INSERT INTO ztp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","xaꞌ ya tej re di's loa xomod lyaꞌa nde lyaꞌ re men liz la.” ");
INSERT INTO ztp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Senꞌ mdobte mdodiꞌs na, zya ngotu Mbi Nayon yek reta xaꞌ, xajka ngotu Mbi Nayon yek reta naꞌ zyaya. ");
INSERT INTO ztp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Zyasa mteꞌlas na xkiꞌs Xaꞌ Nyebeꞌ, senꞌ lo ne Xaꞌ: “Juan, liga ben' lenꞌ nit mblole xaꞌ men, per goꞌ ryo'le kon Mbi Nayon.” ");
INSERT INTO ztp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nde tez leꞌga Dios mdaꞌy lo re xaꞌ ya, jwanꞌ ta mdaꞌ Dios lo re naꞌ ta ndlia lazonꞌ Jesucrist Xaꞌ Nyebeꞌ ¿Cho nak na sa tyotowꞌ na lo Dios? ");
INSERT INTO ztp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Senꞌ mbin re wes diꞌs ya, naꞌnkapta xaꞌ, mni xa' di's wen lo Dios, nchab xaꞌ: —¡Mbay noga re men naꞌnakta Israel ngebez Dios xa' sa laꞌ xaꞌ re jwanꞌ narax nak xaꞌ, bere xgab xaꞌ lo Dios nde kayaꞌ xaꞌ yalnaban adiꞌ! ");
INSERT INTO ztp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Senꞌ mbijla xaꞌ Xteb, zya mdobte mchubla xa ꞌ re men ndli lazonꞌ Jesús nde mxonꞌ men, nzo xaꞌ mzin lo xyon Fenicia, lo xyon Chipre nde yez Antioquía. Tya benꞌta lo re men judí mdej xaꞌ xkiꞌs Jesucrist, ngentraꞌ cho lo ndej xa'y. ");
INSERT INTO ztp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per xija nzo pla wes, xa' lo xyon Chipre nde yez Ciren, senꞌ mzin xaꞌ yez Antioquía, mdobte mdej xaꞌ diꞌs wen chanꞌ Jesús Xa' Nyebe' lo re xaꞌ judí ni di's grieg. ");
INSERT INTO ztp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nde Xaꞌ Nyebeꞌ ndolaꞌsto re men ya, nde bro toz men mbla' xa' re mod gox nak xa' nde mbli lazo' xa' Jesús Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Re jwan' re' mbin re xaꞌ nzi yodoꞌ Jerusalén sa mtelꞌ xaꞌ Bernabé ya xaꞌ Antioquía. ");
INSERT INTO ztp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Senꞌ mzin Bernabé tya, mbwiꞌ xaꞌ yalwen chanꞌ Dios, ngonale lazoꞌ xaꞌ, nde mtoni xaꞌ re men ndli lazon' Jesús sa thipta xgab tyen re xaꞌ tyonke xaꞌ xis Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tak Bernabé nak ti mbiꞌ wen, dib xaꞌ mde' Mbi Nayon nde ndlipa lazoꞌ xaꞌ Jesús. Nde bro toz men mdayaꞌ lazonꞌ lo Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Xisa ngwa kwanꞌ Bernabé Saulo yez Tarso, nde senꞌ ngosal xa', mbeꞌ xaꞌ xa' yez Antioquía. ");
INSERT INTO ztp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nde tya mbre xaꞌ kon re men yodoꞌ dibta tib linꞌ nde bro toz lo men mbloꞌ xaꞌ xkiꞌs Dios. Yez Antioquía, tya jwan' mblo'le ner xa' Cristian re men jwan' ndli lazon' Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lenꞌ re wiz ya, ngo pla profet mbroꞌ yez Jerusalén ngotu xa' yez Antioquía. ");
INSERT INTO ztp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tib xaꞌ ya ndole Agabo, mdoli xaꞌ xij reta wes nzi tya nde Mbi Nayon ntoni xaꞌ sa mdej xaꞌ, yo ti win toz dib izyo, nde jwanꞌna ngok lenꞌ linꞌ sen' mdob nyebeꞌ Claudio. ");
INSERT INTO ztp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Zyasa re wes nzi yez Antioquía mbyan'di's xa', axaja nchala lo xaꞌ mtelꞌ xaꞌ jwanꞌ laꞌsto xaꞌ re wes nzo lo xyon Judea. ");
INSERT INTO ztp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tamod mbli xaꞌ mtelꞌ xaꞌy lo Bernabé kon Saulo sa zina lo re xaꞌ nak sinꞌ lo yodoꞌ, xaꞌ nzi lo xyon Judea. ");
INSERT INTO ztp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Leꞌga len' lin' ya, rey Herodes mnabeꞌ mxen xaꞌ pla men yodoꞌ nde mtoti xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nde mbij xaꞌ Jakob wes Juan kon espad. ");
INSERT INTO ztp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Senꞌ mne Herodes ke ndyen re xaꞌ judí ta mbij xa' Jakob zyasa mnabeꞌ Herodes yoga Pedr. Len' wiz ya ncha xaꞌ pan ngenta lebadur. ");
INSERT INTO ztp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Senꞌ ngoga Pedr, mke' lizyi'b xaꞌ Pedr, nde mnabeꞌ xaꞌ lo sinꞌ thib sondad sa ngok rol xaꞌ, thap thapa sondad ngenap. Tak xgab Herodes nak, senꞌ ngoto ni pask zya koꞌto xaꞌ Pedr lo mayez sa kuj xa' Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nde jwin toz ngenap xaꞌ lizyiꞌb tenꞌ nge Pedr; leꞌ re xa' jwan' ndli lazon' Jesús dib nzo lazo' xa' nyaꞌb toz xaꞌ lo Dios por Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yalꞌ jwanꞌ tuxni izyo tedib wiz, senꞌ ta kote Herodes Pedr sa wi' xa' xa ak Pedr, leꞌ Pedr naxyat xtowꞌ chop sondad nde ndobo Pedr kon chop kaden nde masraꞌ sondad nzi kenap ro lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Zyasa mbroꞌto ti anj chanꞌ Dios nde dib lenꞌ lizyiꞌb mbla xni, leꞌ anj mzib ya' lad Pedr sa mbloꞌxkalꞌ anj xa' nde nchab anj lo xa': —¡Naban goche! Nde zyaga mbroꞌta kaden ta nago yaꞌ Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nde nchab anj lo Pedr: —Bo len' la, nde pkeꞌ yalyid nia. Nde ta mbli Pedr, zyasa nchab anj: —Bix xab la nde ptonke xis na. ");
INSERT INTO ztp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nde mbroꞌte anj, xisa mdonke Pedr per naꞌnyed xa' cho li ndoyakpa jwanꞌ ngeli anj, mxak Pedr naxsalꞌ lazoꞌ Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nde mbriꞌd xaꞌ tenꞌ nzi ner sondad jwan' ngenap, tagaꞌ mbrid xaꞌ brop tenꞌ ngenap sondad nde mzin xaꞌ ro yala naksaꞌ yiꞌb jwanꞌ nge ro ned, yala ya, yuba mxyalꞌla. Senꞌ mbroꞌte rop xaꞌ le, mde xaꞌ lud nde zyaga mtiꞌ anj lo Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Zyasa mbi lo Pedr nde nchab xa': —Naya liga mnen, Xaꞌ Nyebeꞌ mtelꞌ Xa' anj Xa' sa mtolaꞌ Xaꞌ na lo yaꞌ Herodes nde lo reta jwanꞌ ncholaꞌs re xaꞌ judí lino xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sen' mne Pedr re jwan' re', mzin Pedr liz Marí, xnaꞌ Juan xaꞌ ndolegaꞌ Mark, tya nzidop bro toz xaꞌ, nzinaꞌb xaꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Senꞌ mzin Pedr, mbrez Pedr xis yala jwanꞌ nge ro ned, le' ti mzaꞌ jwan' nge sin' tya ndole Rode, nda wiꞌ mzaꞌ nyenꞌ choy, ");
INSERT INTO ztp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","per senꞌ mblibeꞌ mzaꞌ xkiꞌs Pedr, nale toz ngo lazoꞌ mzaꞌ, yaja naꞌnxalꞌta mzaꞌ ro yala cheꞌla mkeꞌ mzaꞌ karrel nda mzaꞌ lenꞌ yo, nde nchab mzaꞌ lo re xaꞌ nzi tya, Pedr ndo xis yala le ba. ");
INSERT INTO ztp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Per re xaꞌ nzi tya, nchab xaꞌ lo mzaꞌ: —¡Ngosaꞌ yek la! Leꞌ mzaꞌ nega ndo, nchab mzaꞌ: Liy. Zyasa nchab xaꞌ: —Nzo pa anj Pedr ngete le ba. ");
INSERT INTO ztp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Leꞌ Pedr tatka mbez ndo le, zyara mxalꞌ xaꞌ ro yala sa mbwiꞌ xaꞌ liga Pedr ndo tya nde nzoyen toz re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Zyasa mtaꞌb yaꞌ Pedr lo xaꞌ sa naꞌkwestra' xaꞌ nde mdej Pedr lo xaꞌ, xamod mbloꞌte Xaꞌ Nyebeꞌ Pedr lenꞌ lizyiꞌb. Nde nchab Pedr lo re xaꞌ: —Ptej goꞌ jwanꞌ reꞌ lo Jakob nde lo re wes. Zyasa mbroꞌte Pedr nde nda Pedr xaꞌga plo. ");
INSERT INTO ztp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Senꞌ mduxni izyo, anta cheꞌpa mbez re sondad, tak naꞌnyed xaꞌ ma Pedr. ");
INSERT INTO ztp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Zya mnabeꞌ Herodes sa ngwa kwanꞌ xaꞌ Pedr, per naꞌngazalta xaꞌ Pedr, zyasa mkeꞌ Herodes yalke yek re sondad jwanꞌ mkenap nde mnabeꞌ Herodes mbij xaꞌ re sondad ya. Senꞌ ngolo re jwanꞌna, mbroꞌ Herodes lo xyon Judea nde nda Herodes yez Cesarea nde tya ngo xa'. ");
INSERT INTO ztp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nde Herodes ngiꞌno xa' re men yez Tiro nde Sidón, per rop yez reꞌ, thipta ngok diꞌs xaꞌ sa mbike xaꞌ lo Herodes, nerla mdodiꞌsno xaꞌ Blasto, xaꞌ jwanꞌ nakayaꞌ sinꞌ ro lo Herodes nde xaꞌ ya mblaꞌsto re xaꞌ sa mnaꞌb xaꞌ wen kwe xaꞌ kon rey, tak lo xyon rey ndryoꞌ jwanꞌ ncha re men yez Tiro nde Sidón. ");
INSERT INTO ztp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nde ti wiz jwan' mbyan' di'sla xa', ngok Herodes xab xa' jwan' nak xa' rey nde mdob Herodes tenꞌ ndyob nyebeꞌ xaꞌ nde mni xaꞌ lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Zyasa tolo mbrezyaj reta men, nchab xaꞌ: —¡Xa' ta ndoniba naꞌnakta xa' men, dios nak xa'! ");
INSERT INTO ztp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Zyaga ti anj chanꞌ Dios mbli zyaga mxen yiz Herodes tak naꞌmblinarod xaꞌ le Dios nde tolo mdobte mda mblyeꞌd belꞌ Herodes nde nguj xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Laja leꞌ xkiꞌs Xaꞌ Nyebeꞌ, ndoxena nde ndoraꞌsa dib nax. ");
INSERT INTO ztp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sen' ngolo rsin' Bernabé kon Saulo yez Jerusalén, mbere xaꞌ ndya xaꞌ yez Antioquía nde mbeꞌ xaꞌ Juan xaꞌ ndolegaꞌ Mark. ");
INSERT INTO ztp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Xij re wes ta nzi yodoꞌ yez Antioquía nzo re xaꞌ nak profet nde re xaꞌ nak maestr, re xaꞌ ya nak, Bernabé, Simón xaꞌ jwanꞌ ndolegaꞌ Ya't, Lus xaꞌ yez Ciren, Manaén xaꞌ jwanꞌ thipta mxyen kon Herodes xa' nyebeꞌ lo xyon Galilea nde kon Saulo. ");
INSERT INTO ztp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ti wiz senꞌ nzi li xaꞌ yalse nde nzilinaro xa' le Dios, zya nchab Mbi Nayon lo xaꞌ: —Bloꞌxaꞌ goꞌ Bernabé nde Saulo sa li xaꞌ sinꞌ jwanꞌ mbrez na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sen' lo mne mbli xaꞌ yalse nde mdodiꞌsno xaꞌ Dios, mxoꞌb yaꞌ xaꞌ yek Bernabé nde yek Saulo, ngolo jwanꞌna, mtelꞌ xaꞌ xaꞌ nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Leꞌ rop xaꞌ ta mbloned Mbi Nayon, nda xaꞌ lo xyon Seleucia jwan' nax ro nitto', nde tya mxen xaꞌ bark nda xaꞌ Chipre. ");
INSERT INTO ztp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Senꞌ mzin xaꞌ yez Salamina jwan' nax ro nitto', tya mdobte ngwatej xaꞌ xkiꞌs Dios re lenꞌ yo tenꞌ ndyop re men Israel. Noga ngeteno xaꞌ Juan ndli kompay xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Senꞌ ngolo mbriꞌdndaꞌb xaꞌ dib lo xyon Chipre mzin xaꞌ axta Pafos, tya ngoziꞌb xaꞌ ti xa' judí ndole Barjesús, xaꞌ mxí nak xa' nde profet kwinꞌ xa', ");
INSERT INTO ztp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","le' xaꞌ mxí reꞌ, thibla' gax ndo xaꞌ lo Sergio Paulo xa' nyebeꞌ lo yez, xa' nzo toz xgab yek xaꞌ, Sergio Paulo mnabeꞌ xa' sa ngwayoꞌ Bernabé kon Saulo tak ndyen toz xa' gon xa' xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Leꞌ Elimas, tamod nak le xaꞌ mxí ya di's gryeg, mchal toz xaꞌ towꞌ xaꞌ sa naꞌgonta Sergio xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Per Saulo, xaꞌ ndolega' Pab, dib xaꞌ mde' Mbi Nayon, mbwiꞌ galꞌ xaꞌ lo xaꞌ mxí ya, ");
INSERT INTO ztp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nde nchab xaꞌ: —¡Lu, nab yalkwinꞌ nde nab yalnarax nzo lazoꞌa, xinꞌ Maxuꞌ nak la, tak ngiꞌnoa re jwanꞌ galꞌ! ¿Cho naꞌnchoched lazo'a ndotokan la ned galꞌ chanꞌ Xaꞌ Nyebeꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Naya leꞌ yalnayiꞌ chanꞌ Xaꞌ Nyebeꞌ xyoꞌb xis la, kow ngud loa lud tyemp nde nawiꞌtra lu xni. Zyaga mkal ngud lo xaꞌ mxí ya nde thiptane mkow ngud lo xaꞌ, anta nchek xaꞌ, nkwanꞌ xaꞌ nyenꞌ cho tyen yaꞌ xaꞌ sa tye xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Zyasa Sergio Paulo, xaꞌ nyebeꞌ lo yez, mbwiꞌ xaꞌ jwanꞌ ngok nde mbli lazoꞌ xaꞌ Dios, nzoyen xaꞌ ngwiꞌ xaꞌ re yalteꞌd chanꞌ Jesús Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ngolo jwanꞌ reꞌ, mbroꞌ Pab yez Pafos mxen xaꞌ bark nde kon tipla wes nda xaꞌ yez Perge lo xyon Panfilia; le' Juan Marcos tyaja mblake xa' nde mbere xa' yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Leꞌ re xaꞌ ndaga xaꞌ, mbriꞌd xaꞌ yez Perge, mzin xaꞌ yez Antioquía lo xyon Pisidia. Nde wiz jwanꞌ ndryoꞌxkwen men, ngwa xa' lenꞌ yo tenꞌ ndyop re men Israel nde mdob xa'. ");
INSERT INTO ztp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Senꞌ ngolo mbwab ley chanꞌ Moisés nde yeꞌs jwanꞌ mkeꞌ re Profet, zyasa re xaꞌ nak sinꞌ lenꞌ yo tenꞌ ndyop men Israel, mnabeꞌ xaꞌ sa ngwatne xaꞌ lo re wes ta mzinaꞌ, nchab xaꞌ: —Wes, tez ndeno goꞌ cho diꞌs kone goꞌ lazoꞌ re men, ptej goꞌy lo men naya. ");
INSERT INTO ztp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Zyasa mdoli Pab nde mtaꞌb yaꞌ Pab lo re men sa xe kwe men nde nchab Pab lo xaꞌ: —Goꞌ men Israel nde goꞌ men nzeb lazonꞌ Dios, bin goꞌ jwanꞌ reꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios, Xaꞌ ta nak xwanꞌ yez Israel, mblí Xaꞌ re xaꞌ gox lonꞌ ta mbre pola sa mblilal Dios xaꞌ ti yez ro, te'nyega ngok xaꞌ men tedib lo ngo xaꞌ yez Egipto, kon yalne chanꞌ Dios mbloꞌte Dios xaꞌ yez ya. ");
INSERT INTO ztp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nde mxek Dios xaꞌ dibta lenꞌ choꞌ linꞌ tenꞌ nak izyo nagan. ");
INSERT INTO ztp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ngolo mbluꞌx Dios gaz ned yez nabiꞌ lo xyon Canaán, zyasa mdayaꞌ Dios yez ya lo re xaꞌ gox lonꞌ ta mbre pola. ");
INSERT INTO ztp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Xisa, mer ti thap ayoꞌ nzo choꞌpsiꞌ linꞌ, mdob Dios re xaꞌ ngok jwes sa nyebeꞌ xaꞌ lo yez Israel, axta linꞌ senꞌ ngo Profet Samuel. ");
INSERT INTO ztp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Zyasa mnaꞌb xaꞌ rey, nde mdaꞌ Dios Saúl xinꞌ Cis, mbiꞌ jwanꞌ nde lo bin Benjamín, mbiꞌ reꞌ ngok rey choꞌ linꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xisa mkib Dios yalnyebeꞌ lo Saúl, nde mtob Dios David ngok rey, nde mni Dios diꞌs wen xis David, nchab Dios: \"Axata nak lazo'n nak David xinꞌ Isaí, xaꞌ li reta jwanꞌ ncholas na.\" ");
INSERT INTO ztp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nde axata mkeꞌyek Dios ta ngoka, lo bin David mzin Jesús, Xaꞌ mtel' Dios tolaꞌ men Israel. ");
INSERT INTO ztp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Senꞌ teraꞌ ryoꞌto Jesús, Juan mdej lo reta men yez Israel, ryole men sa laꞌ men reta jwanꞌ narax nak men nde bere men lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Senꞌ ndoyolo rsinꞌ Juan, zya nchab Juan: “¿Cho nak na ndli goꞌ xgab? Naꞌnakta na Crist. Xis na reꞌ nde ti Xaꞌ nekla nsalꞌ na xak na yalyid nge ni Xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Wes na, re naꞌ ta nde lo bin Abraham nde re goꞌ men thib lad ta nseb lazonꞌ Dios, lo reta naꞌ mtelꞌ Dios xkiꞌs Dios, diꞌs ntolaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tak reta men yez Jerusalén nde re xaꞌ nak sinꞌ, naꞌngyolod xaꞌ Jesús, nekla ngyen xaꞌ xkiꞌs re profet jwanꞌ ndlab xaꞌ re lenꞌ wiz jwan' ndyroꞌxkwen men, per mbli xaꞌ jwanꞌ nchaba, lo senꞌ mkeꞌ xaꞌ yalke yek Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nde tenye naꞌngasalta xaꞌ nek thib yalke ndli gaj Jesús, per mnaꞌb xaꞌ lo Pilat gaj Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Senꞌ ngolo mbli xaꞌ reta jwanꞌ ngeni lo yeꞌs, jwanꞌ lino xaꞌ Jesús, zya mbla xaꞌ Jesús lo kruz nde mkaꞌs xaꞌ Jesús lenꞌ baꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per Dios mbloꞌxban Jesús xij re men nguj ");
INSERT INTO ztp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nde naꞌr toz wiz mbroꞌto Jesús lo re xaꞌ jwanꞌ ndyonke xis Jesús senꞌ dryoꞌ xa' Galilea nde ncha Xaꞌ Jerusalén, re xaꞌ ya nak xa' mney nde naya re xaꞌ ya ndyodiꞌs xkiꞌs Jesús lo re men yez naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Nde noga ndej náꞌ diꞌs wen chanꞌ Jesucrist, diꞌs ta mkeꞌyek Dios lo re xaꞌ gox lonꞌ ta mbre pola, ");
INSERT INTO ztp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nde naya, lo re naꞌ jwanꞌ nde lo bin chanꞌ re xaꞌ goxa, lonꞌ ngok jwanꞌ nchab Dios senꞌ lo mbroꞌxban Jesús, ta xa ngeni Salmo mbrop, jwanꞌ nchab: “Lu nak xinꞌ na, na mbli sa nzoa naya.” ");
INSERT INTO ztp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nde lo ta mbloꞌxban Dios Jesús xij re men nguj sa naꞌgasta belꞌ Xaꞌ, nchaba lo Salmos: “Lo goꞌ lin re yalwen nde jwanꞌ galꞌ ta mkeꞌyek na lo David.” ");
INSERT INTO ztp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jwanꞌ nasa, noga tedib lad lo salmos nchab: “Naꞌtad la diꞌs gàs belꞌ Xaꞌ Nayon loa.” ");
INSERT INTO ztp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tak David liga ngok xaꞌ sinꞌ lo re men jwanꞌ mbre tyemp xaꞌ, mbli xaꞌ jwanꞌ xa ncholaꞌs Dios, nde xisla nguj xaꞌ nde mbwaꞌs xaꞌ tenꞌ nzo kaꞌs re xaꞌ gox lo xaꞌ, nde ngoꞌs belꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per Jesús, Xaꞌ ta mbloꞌxban Dios naꞌngaꞌsta belꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Wes na, ptan na, ndablo yolo goꞌ jwanꞌ reꞌ, náꞌ ndej, benꞌta Jesús li sa dyonꞌ reta xken men, ");
INSERT INTO ztp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","tak reta men jwanꞌ naꞌngakta ndro'to nambi kon ley chanꞌ Moisés, Jesús mbli gan mbro'to nambi xa' lo ndli lazoꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ndawiꞌ toz goꞌ, sa naꞌyeta xis goꞌ diꞌs jwanꞌ mkeꞌ re profet, jwanꞌ nchab: ");
INSERT INTO ztp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Re goꞌ ta ngotal xkiꞌs na, bwiꞌ goꞌ, aka jwanꞌ nzoyen goꞌ, nde lux goꞌ, tak lenꞌ wiz ta nzi goꞌ reꞌ, lin ti jwanꞌ, naꞌlid lazoꞌ goꞌy tenye tej mena lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Senꞌ mbroꞌte Pab lenꞌ yo tenꞌ ndyop re men Israel kon re xaꞌ jwanꞌ ngeteno Pab, zyasa re xa' na'nakta men Israel mnaꞌb xa' lo Pab sa noga tedib wiz jwanꞌ ndryoꞌxkwen men todiꞌs Pab tud di's reꞌ lo xa'. ");
INSERT INTO ztp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Senꞌ ngolo mbryaꞌs re men, bro re xaꞌ judí nde re xaꞌ jwan' ngolal men judí, mdonke xaꞌ xis Pab nde xis Bernabé. Nde mni toz Pab lo re xa' ya, sa thiblaꞌ tyono xa' yalwen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Senꞌ ngoxoꞌb tedib wiz jwanꞌ ndryoꞌxkwen men, mer dib yez mdyop, sa gon xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per senꞌ mne re xaꞌ judí bro toz men mdyop, tolo mbyi'no xa' Pab, narax mkab xaꞌ lo re jwanꞌ ndej Pab, mkabro xaꞌ nde mni xin xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Leꞌ Pab kon Bernabé naꞌnzyepta xaꞌ, mkab xaꞌ: —Nerka lo goꞌ nakinꞌ todiꞌs náꞌ xkiꞌs Dios, per naya ta ngotal goꞌy nde leꞌga goꞌ ndyak na'nzalꞌta goꞌ kayaꞌ goꞌ yalnaban adiꞌ, jwanꞌ nasa mas nda náꞌ lo re men naꞌnakta Israel. ");
INSERT INTO ztp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tak tamod mnabeꞌ Xaꞌ Nyebeꞌ lo náꞌ, ne Xaꞌ: Mtob na lu sa ak la xni lo re men na'nakta Israel, nde axta ploja mdib izyo tej la lo re men, ke na tolaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Senꞌ mbin re xaꞌ naꞌnakta Israel jwanꞌ reꞌ nale toz ngo lazoꞌ xaꞌ nde nchab xaꞌ, wen toz nak xkiꞌs Xaꞌ Nyebeꞌ; nde mbli lazoꞌ xaꞌ Jesús, reta xaꞌ jwanꞌ nak be'la kayaꞌ yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nde xkiꞌs Dios mbrya'sa dib nax tya. ");
INSERT INTO ztp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Leꞌ re xaꞌ judí mtokilꞌ xaꞌ re ngol ta nxobyek re jwanꞌ ndli lazoꞌ re xaꞌ judí nde re ngol ntak nde kon re xaꞌ biꞌ jwanꞌ mas ntak lo yez, thipta ngok diꞌs re xaꞌ sa mtoxonꞌ xaꞌ Pab nde Bernabé, mbloꞌte xaꞌ xaꞌ lo xyon ya. ");
INSERT INTO ztp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Zyasa Pab kon Bernabé mzib xaꞌ yothiꞌ ni xaꞌ, sa mblo' ke mblo'tal re xa' ya xki's Dios, nde nda xaꞌ, mzin xaꞌ yez Iconio. ");
INSERT INTO ztp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Leꞌ re xaꞌ jwanꞌ ndli lazonꞌ Jesucrist nale toz nzo lazoꞌ xaꞌ nde dib ben xaꞌ mde' Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tenꞌ nak yez Iconio, Pab kon Bernabé ngote rop xaꞌ lenꞌ yo tenꞌ ndyop re men judí sa mdodi's xaꞌ xkiꞌs Dios lo re men nde bro toz re xaꞌ judí nde re xaꞌ na'nakta Israel mbli lazoꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per re xaꞌ judí jwanꞌ naꞌndlid lazonꞌ Jesús, mtokilꞌ xaꞌ re men naꞌnakta Israel sa mbyiꞌno xaꞌ re men ndli lazonꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nde tenye ta naka, bro tyemp ngo Pab kon Bernabé yez ya nde mdob xgab xaꞌ lo Xaꞌ Nyebeꞌ naꞌnzyepta xaꞌ ndyodiꞌs xaꞌ xkiꞌs Dios, leꞌ Xaꞌ Nyebeꞌ ndloꞌ ke liga re yalwen chanꞌ Xa' jwanꞌ ndyodiꞌs Pab, nde ndaꞌ Xaꞌ Nyebeꞌ yalne lo rop xa' sa ndli xaꞌ re yalnaro jwanꞌ nzoyen men. ");
INSERT INTO ztp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nde re men nzo yez ya ngok rol xaꞌ, nzo xaꞌ ndo kon re xaꞌ judí nde nzo xaꞌ ndo kon rop apóst. ");
INSERT INTO ztp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zyasa re xaꞌ judí nde re xaꞌ nanakta judí thipta ngok diꞌs xaꞌ kon re xaꞌ nak sinꞌ lo yez, sa toti xaꞌ nde gadke xaꞌ rop xaꞌ ta nak apóst. ");
INSERT INTO ztp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Senꞌ mbin rop apóst jwanꞌ reꞌ, mxonꞌ xaꞌ nda xaꞌ yez Listra nde yez Derbe, yez jwanꞌ nzi lo xyon Licaonia nde noga nda xaꞌ reta re yez jwanꞌ nzi gax tya, ");
INSERT INTO ztp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","nde tya mdej xaꞌ diꞌs wen chanꞌ Jesucrist lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yez Listra nzo ti mbiꞌ naꞌndyeda. Xata ngol xa nayiz ni xaꞌ jwan' nasa na'ndyed xa'. Mbiꞌ reꞌ ndob tya, ");
INSERT INTO ztp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ndoyon xaꞌ re diꞌs ni Pab, zya mbwiꞌ Pab lo xaꞌ tak mne Pab ndlipa lazoꞌ xaꞌ dyanꞌ xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nde ne mni Pab, nchab Pab: —¡Ptolí nde gal' pto nia! Leꞌ mbiꞌ ya ngwat xa' nde mde xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Senꞌ mbwiꞌ re men jwanꞌ mbli Pab, zyasa ne mbrez reta xa', kon xki's men lo xyon Licaónica, nchab xaꞌ: — ¡Dios nak re mbi' ta mzin lon' reꞌ! ");
INSERT INTO ztp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé mblole xaꞌ Júpiter nde Pab mblole xaꞌ Mercurio, tak Pab jwanꞌ ndo ye' diꞌs. ");
INSERT INTO ztp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zyasa ngwleyꞌ chanꞌ Júpiter ngeno xaꞌ yodonꞌ xaꞌ ndob ngoꞌ lo yez sa ndeno xaꞌ ngon nde yeꞌ, thipta nde xaꞌ kon reta men, ncholaꞌs xaꞌ kuj xaꞌ maꞌ yon jwanꞌ taꞌ xaꞌ lo Pab kon Bernabé. ");
INSERT INTO ztp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Senꞌ mne Bernabé kon Pab jwanꞌna, mched xaꞌ xab xaꞌ nde ngote xaꞌ xij reta men, ne mbrez xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","nchab xaꞌ: —¡Reta go' ba! ¿Cho kwan liy ndli goꞌ jwanꞌ reꞌ? Rop náꞌ reꞌ, tagaꞌ men nak náꞌ xa nak goꞌ ba, jwanꞌ nasa ndetej náꞌ lo goꞌ, blaꞌ goꞌ re mnab ta ngencho sin' li nde bli lazoꞌ goꞌ Dios naban, Xaꞌ ta mdoxkwaꞌ beꞌ nde izyo, nittoꞌ, nde reta jwanꞌ nzi lo kad thibay. ");
INSERT INTO ztp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pol lin'na' mdaꞌ Dios diꞌs kad men ban men axa ncholaꞌs men, ");
INSERT INTO ztp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","per thibka ndloꞌ Dios cho nak Dios, por re jwanꞌ wen ndli Xaꞌ; leꞌ Xaꞌ ndla yi ndryoꞌ lo beꞌ, sa nawe nchak re jwanꞌ bin, thiblaꞌ nzo jwanꞌ ncha men sa nale nzo lazoꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tenye nchab Pab kon Bernabé reta jwanꞌna, nen toz sa mbli xaꞌ gan mtowꞌ xaꞌ lo re men sa naꞌngujta men maꞌ yon lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Zyasa mzin pla xaꞌ judí mbroꞌ yez Antioquí nde Iconio, mblo xaꞌ yek reta men sa mzyeꞌ xgab men nde mbwadke xaꞌ Pab, ngolo jwanꞌ reꞌ mdoꞌbnyo xaꞌ Pab axta ro yez, tak mbli xaꞌ xgab nguj Pab. ");
INSERT INTO ztp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Leꞌ re xaꞌ jwanꞌ ndli lazonꞌ Jesús mdyop xaꞌ tenꞌ nax Pab, zya ngoche Pab nde nda Pab lenꞌ yez. Senꞌ mduxni tedid wiz mbroꞌ Pab tya kon Bernabé nde nda xaꞌ yez Derbe. ");
INSERT INTO ztp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Senꞌ ngolo mdej xaꞌ diꞌs wen chanꞌ Jesucrist dib yez Derbe, mbli xaꞌ gan bro toz men mbli lazoꞌ xaꞌ Jesús. Zyasa mbere Pab kon Bernabé yez Listra, yez Iconio nde yez Antioquí. ");
INSERT INTO ztp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Re yez ya mketegone xaꞌ lazoꞌ re men jwanꞌ ndli lazonꞌ Dios, ntoni xaꞌ re men ya sa naꞌlad xaꞌ thibla' tyo xaꞌ lo jwanꞌ ndlipa lazoꞌ xaꞌ, sa nchab Pab kon Bernabé lo re xaꞌ, ndabloga rid men lo reta yalti sa yote men lo yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nde kad yodo' mbloꞌ xaꞌ re xa' nak sinꞌ gol , senꞌ mne mnaꞌb xaꞌ lo Dios nde mne mbli xaꞌ yalse, mdaꞌyaꞌ xaꞌ re men ya lo Jesucrist Xaꞌ ta ndli lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Xisa mbriꞌd ndab Pab kon Bernabé lo xyon Pisidia nde mzin xaꞌ lo xyon Panfilia, ");
INSERT INTO ztp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","nde senꞌ ngolo mdej xaꞌ xkiꞌs Dios yez Perge, nda rop xaꞌ yez Atalia. ");
INSERT INTO ztp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tya mxen xaꞌ bark ndya xaꞌ yez Antioquí, tenꞌ ta re xa' nak wes mdaya' xa' xaꞌ lo Dios sa ya tej xaꞌ xkiꞌs Dios nde sin' ya jwan' ngolo mbli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Senꞌ mzin xaꞌ Antioquí, mthop xaꞌ reta men nzi yodoꞌ nde mdej xaꞌ plopa yalnaro mbli Dios lo xaꞌ nde xa mxyalꞌ yala jwan' li lazo' xa' lo re men naꞌnakta judí sa no re men ya mkayaꞌ xa' xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nde bro tyemp ngo Pab kon Bernabe tya, kon re men jwanꞌ ndli lazonꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Lenꞌ wiz ya mbroꞌ pla xaꞌ lo xyon Judea nde mzin xaꞌ yez Antioquí nde ndloꞌ xaꞌ lo re wes, tez na'tyopta be' tenꞌ nak lad men biꞌ jwanꞌ xa nyebeꞌ ley chanꞌ Moisés naꞌnyeda lyaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Leꞌ Pab kon Bernabé jwinka ngwa xaꞌ kwent kon re xaꞌ ya, yaja re wes nzi tya mnaꞌb xaꞌ lo Pab kon Bernabé kon tipla wes, sa ya xaꞌ yez Jerusalén sa todiꞌs xaꞌ jwanꞌ reꞌ kon re apóst nde re xaꞌ nak sinꞌ lo yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Zyasa re xaꞌ nzi yodoꞌ yez Antioquía, mbloned xaꞌ xaꞌ, nde mbrid xaꞌ lo xyon Fenicia nde Samaria mketetej xaꞌ lo re wes, ke re xaꞌ naꞌnakta judí mblaꞌ xaꞌ re mod gox chanꞌ xaꞌ nde mbli lazoꞌ xaꞌ Dios, senꞌ lo mbin re wes jwanꞌna, nale toz ngo lazoꞌ re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Senꞌ mzin Pab kon Bernabé yez Jerusalén, leꞌ re xaꞌ jwanꞌ nzi yodoꞌ, re xaꞌ jwanꞌ nak apóst nde re xaꞌ nak sinꞌ lo yodoꞌ mkayaꞌ xaꞌ xaꞌ, leꞌ Pab kon Bernabé mdej xaꞌ reta jwanꞌ mbli Dios kon xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per pla xaꞌ fariseo, xaꞌ mbli lazonꞌ Jesús, mdoli xaꞌ nde nchab xaꞌ: —Nakinꞌka nyebeꞌ men lo re xaꞌ naꞌnakta judí sa tyob be' lad xaꞌ tenꞌ nak lad men biꞌba nde nyebeꞌ men li xaꞌ jwan' nyebe' ley chan' Moisés. ");
INSERT INTO ztp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Zyasa mdyop re apóst nde re xaꞌ nak sinꞌ lo yodoꞌ, sa mdodiꞌs xaꞌ jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Senꞌ ngolo plopa mbrez xaꞌ, zyasa mdoli Pedr nde nchab Pedr lo xaꞌ: —Reta go' wes na, mnela go' axta neraꞌ mblí Dios na xij goꞌ sa yatej na diꞌs wen chanꞌ Jesucrist lo re xaꞌ naꞌnakta judí sa li lazoꞌ xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nde Dios ta nzolo lazoꞌ reta men, mbloꞌ Dios lo re xaꞌ ke mkayaꞌ Dios xaꞌ senꞌ lo mdaꞌ Dios Mbi Nayon lo xaꞌ, jwanꞌ xa mdaꞌga Dios lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tak thipta ngwiꞌ Dios re naꞌ nde taga' ngwi' Dios tedib ned xaꞌ, jwanꞌ nasa mtombi Dios lazoꞌ xaꞌ lo ndli lazoꞌ xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Le' naya, ¿Cho kwan liy sa nchola's go' li be' goꞌ Dios, mbez goꞌ lo men li xaꞌ ti jwanꞌ nek re xaꞌ gox lonꞌ mbre pola nde nek naꞌ naꞌndlid naꞌ gan li naꞌy? ");
INSERT INTO ztp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Cheꞌla, le' re na', ndli lazonꞌ mblyanꞌ por yalwen jwan' nda'la's Jesús Xaꞌ Nyebeꞌ nde taxa mod naka kon tedib ned xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Zyasa xe mbre reta men nde mkeꞌnza xaꞌ jwanꞌ ndej Bernabé kon Pab, plopa naro nak jwanꞌ mbloꞌ Dios nde jwanꞌ nzoyen men mbli Dios por xaꞌ, xij re men naꞌnakta Israel. ");
INSERT INTO ztp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Senꞌ mne mdodiꞌs rop xaꞌ, zya mkab Jakob nchab xaꞌ: —Wes na, ptonza goꞌ jwanꞌ nin. ");
INSERT INTO ztp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pedr mdej, xomod mbrez ner Dios re xaꞌ naꞌnakta judí nde mblilal Dios xaꞌ men yez Dios. ");
INSERT INTO ztp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nde jwanꞌ naxa ngeni lo yeꞌs mkeꞌ re profet pola, jwanꞌ nchab: ");
INSERT INTO ztp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ngolo jwanꞌ reꞌ beren sa nakub toxkwan liz David jwanꞌ ngob. Tokub na re pto, Nde liche nay tedib gob, ");
INSERT INTO ztp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Sa masraꞌ re men kwanꞌ xaꞌ Xaꞌ Nyebeꞌ, nde tagaꞌ re men jwanꞌ naꞌnakta judí, re xaꞌ ta ndli lazonꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tamod ne Xaꞌ Nyebeꞌ, axta pol linꞌna mdejla Xaꞌ re jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Jwanꞌ nasa mbez na, na'tow'ta na' lo re xa' naꞌnakta Israel ta ndoli lazon' xki's Dios, ");
INSERT INTO ztp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","benꞌta keꞌ men yeꞌs lo xaꞌ, sa naꞌwatra xaꞌ re jwanꞌ ta mbe lo mnab, naꞌlid xa' re lo jwan' xkap, naꞌwad xaꞌ maꞌ nchaj we, nde naꞌwad xaꞌ ren. ");
INSERT INTO ztp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tak axta pola, kad re yez ngo thiba xaꞌ jwanꞌ ndlab ley chanꞌ Moisés re lenꞌ yo tenꞌ ndyop men Israel, lenꞌ re wiz jwanꞌ ndryoxkwen men. ");
INSERT INTO ztp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Zyasa re apóst, kon re xaꞌ nak sinꞌ lo yodoꞌ nde reta men jwanꞌ ndyop yodoꞌ, mbloꞌ xaꞌ chop wes yanke xis Pab nde Bernabé sa telꞌ xaꞌ xaꞌ yez Antioquí, xaꞌ ya nak, Judas xaꞌ ndolegaꞌ Barsabás nde Silas, chop mbiꞌ jwanꞌ jwin nzo'b xki's na' xij re wes. ");
INSERT INTO ztp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kon xa' reꞌ mtel' xa' yeꞌs jwanꞌ nchab: “Re náꞌ jwanꞌ nak apóst, re xaꞌ nak sinꞌ gol lo yodoꞌ, nde kon re men jwanꞌ ndyop nak yodoꞌ, ni náꞌ lo re goꞌ wes naꞌnakta judí ta nzo yez Antioquía, lo xyon Siria nde lo xyon Cilisia, naxu't bre go'. ");
INSERT INTO ztp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tak mbin náꞌ le'ga xij náꞌ reꞌ mbroꞌ pla xaꞌ jwan' naꞌnakta náꞌ mda' di's lo xa' sa ngete xa' ngo narax xa' lazo' goꞌ kon xkiꞌs xaꞌ, ngete tokan xaꞌ goꞌ, nyebeꞌ xaꞌ lo goꞌ tyob be' lad goꞌ tenꞌ nak lad men biꞌba nde xo'byek goꞌ ley, ");
INSERT INTO ztp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","jwanꞌ nasa mas wen mbyanꞌdiꞌs náꞌ, mbloꞌ náꞌ chop wes mtelꞌ náꞌ, sa yatwiꞌ xaꞌ goꞌ thita nda xaꞌ kon Bernabé nde Pab xa' nke'lazo' ná', ");
INSERT INTO ztp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","tak rop mbiꞌ reꞌ mdob xaꞌ yalnaban chanꞌ xaꞌ lo yalnathoz por Jesucrist Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jwanꞌ nasa mtelꞌ naꞌ Judas nde Silas, sa yub xaꞌ tej jwanꞌ reꞌ lo re goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tak náꞌ nde Mbi Nayon, mbwi' náꞌ ke nandablotra' nyebe' náꞌ li goꞌ masra' jwan', ben'ta jwanꞌ ndablo li goꞌ nak: ");
INSERT INTO ztp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Naꞌwad goꞌ belꞌ maꞌ ta nchuj xaꞌ ndaꞌ xaꞌ lo mnab, naꞌwad goꞌ ren maꞌ, nekla wa goꞌ maꞌ ta nchaj we nde naꞌlid go' re lo ned jwan' xkap. Tez kenap lazoꞌ goꞌ lo re jwanꞌ reꞌ, wen toz ngeli goꞌ. Nabeꞌz bre goꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Zyasa mtelꞌ xaꞌ xaꞌ, ngo xaꞌ ned nda xaꞌ yez Antioquí nde senꞌ mzin xaꞌ tya, mthop xaꞌ reta wes yodoꞌ nde mdayaꞌ xaꞌ yeꞌs lo re wes. ");
INSERT INTO ztp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Senꞌ mblab wes yeꞌs, nale toz ngo lazoꞌ re xaꞌ tak mbloney lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Leꞌ Judas kon Silas nak xaꞌ profet, sa mblone xaꞌ lazoꞌ re wes nde mdodiꞌsno toz xaꞌ re wes sa tyosaꞌ re xaꞌ lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Senꞌ ngoxoꞌb beꞌ yo xaꞌ ned tya, nabez mbloned re wes xaꞌ sa bere xaꞌ lo re wes jwanꞌ mtelꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Leꞌ Silas mbroꞌ lazoꞌ xaꞌ mbyanꞌ xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Noga Pab kon Bernabé thibka mketeloꞌ xaꞌ diꞌs wen chanꞌ Xaꞌ Nyebeꞌ dib yez Antioquía kon tipla wes jwanꞌ nziga tya. ");
INSERT INTO ztp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mbrid lud tyemp, Pab nchab lo Bernabé: —Ndanꞌ tedib gob re yez tenꞌ ngwatejla naꞌ xkiꞌs Xaꞌ Nyebeꞌ, sa winꞌ re wes nyenꞌ xa nzi xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Leꞌ Bernabé ncholaꞌs no Juan tye, xaꞌ jwanꞌ ndolegaꞌ Mark. ");
INSERT INTO ztp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Per Pab naꞌndryo'd lazoꞌ xaꞌ we xaꞌ ti men jwanꞌ mblakela xis, xata mbyanꞌ xaꞌ yez Panfilia nde naꞌndlitra xaꞌ kompay lo rsinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jwanꞌna ndli sa jwinka ngwa Pab kwent kon Bernabé, yaja msilꞌ ta xaꞌ, leꞌ Bernabé mbeꞌ Mark mxen rop xaꞌ bark nde nda xaꞌ lo xyon Chipre, ");
INSERT INTO ztp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","leꞌ Pab, mblí Silas nde mbloned re wes xaꞌ, mbli ley' wes xa' lo yalwen chan' Xa' Nyebe', mbro' xa' nda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mbriꞌd xaꞌ lo xyon Siria nde lo xyon Cilisia, mkete xaꞌ re yodoꞌ mblo ne xaꞌ lazoꞌ re wes. ");
INSERT INTO ztp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ngolo jwanꞌna, Pab kon Silas mzin xa' yez Derbe nde yez Listra, tenꞌ nzo Timoteo ti xaꞌ jwanꞌ nak xinꞌ teꞌd Jesús, xinꞌ ti ngol judí xaꞌ ndliga lazonꞌ Jesús, leꞌ xud Timoteo na'nakta xa' men Israel. ");
INSERT INTO ztp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nde re wes nzo yez Listra nde yez Iconio, wen ndyodiꞌs xaꞌ xis Timoteo. ");
INSERT INTO ztp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pab ncholaꞌs no Timoteo tyonke xis Pab, sa mnabeꞌ Pab lo Timoteo mdob be' lad xa' tenꞌ nak lad men biꞌba, sa tamod re xaꞌ judí jwanꞌ nzo tya wen wiꞌ xaꞌ Timoteo, tak reta men mne leꞌ xud Timoteo nak xaꞌ gryeg. ");
INSERT INTO ztp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nde re yez jwan' ndarid xaꞌ, taja ndatej xaꞌ lo men, re jwan' ndablo li men, jwan' mbyan'di's re xaꞌ nak apóst nde re xaꞌ nak sinꞌ gol nzi yez Jerusalén sa xo'byek xa'y. ");
INSERT INTO ztp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jwanꞌ nasa re men yodoꞌ ta nzi tya masraꞌ ndob xgab xaꞌ lo jwanꞌ ndlipa lazoꞌ xaꞌ nde kad wiz masraꞌ ndoyaꞌr xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Lo ta naꞌndaꞌda Mbi Nayon diꞌs ngatej xaꞌ xkiꞌs Dios lo xyon Asia, yaja mbriꞌd xaꞌ lo xyon Frigia nde Galacia, ");
INSERT INTO ztp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","sa mzin xaꞌ lo xyon Misia, tya mbli xaꞌ xgab ya xaꞌ lo xyon Bitinia, per naꞌndaꞌda Mbi Nayon diꞌs nga xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Yaja ndagalꞌ xaꞌ mbriꞌd xaꞌ lo xyon Misia nde mdola xaꞌ mzin xaꞌ yez Troas. ");
INSERT INTO ztp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Senꞌ mbla yalꞌ, zya xaja men msalꞌ lazonꞌ ba mbwiꞌ Pab ti mbiꞌ lo xyon Macedon, mbiꞌ ya ndoli nde mnaꞌb toz xaꞌ lo Pab, nchab xaꞌ: “Yeꞌd la lo xyon Macedon sa laꞌstoa náꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Senꞌ ngolo mbwiꞌ Pab mbiꞌ ya, zyaga mdosaꞌ náꞌ nda náꞌ lo xyon Macedon, tak mne náꞌ Dios ngebez náꞌ sa yatej náꞌ diꞌs wen chanꞌ Jesucrits lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mxen náꞌ bark yez Troas, ndagalꞌ náꞌ yez Samotracia nde axta tedib wiz mzin náꞌ yez Neápolis. ");
INSERT INTO ztp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tya mbroꞌ náꞌ nda náꞌ yez Filipos, ti yez chanꞌ Rom, yez ntak lo xyon Macedon nde tya mbyanꞌ náꞌ pla wiz. ");
INSERT INTO ztp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nde lenꞌ wiz jwanꞌ ndryoꞌxkwen men, mbroꞌ náꞌ lenꞌ yez sa ngwa náꞌ ti ro yoꞌ tenꞌ thibka ndyop men sa ndyodiꞌsno xaꞌ Dios. Tya mdob náꞌ nde mdej náꞌ xkiꞌs Dios lo re ngol jwanꞌ nzi tya. ");
INSERT INTO ztp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Zyasa ti ngol ndole Lid, ngol yez Tiatira, xaꞌ ntho lar lan jwanꞌ nap toz. Ngol reꞌ nxobyek toz xaꞌ Dios, ndoyon ngol jwanꞌ ndotej Pab, tak Xaꞌ Nyebeꞌ mxalꞌ lazoꞌ ngol sa mtonza ngol xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Senꞌ ngolo mbroꞌle ngol kon re men liz ngol, zya mnaꞌb ngol lo náꞌ, ne ngol: —Tez ngwiꞌ goꞌ na liga ndli lazo'n Xaꞌ Nyebeꞌ, yaꞌ goꞌ ndyanꞌ liz na sa tya kwed goꞌ. Nde nega ndo ngol kebeꞌ mbled náꞌ liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Senꞌ lo nda ná' ten' todiꞌsno náꞌ Dios zya mzyalꞌ náꞌ ti mzaꞌ ndono xbi jwan' nayeꞌ mzaꞌ. Sinꞌ ya ndli mzaꞌ nde jwanꞌ toz nzenaꞌ mzaꞌ tmi jwanꞌ ndayaꞌ mzaꞌ lo xaꞌ nak xwan' mzaꞌ, lo ta nayeꞌ mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mzaꞌ reꞌ mdonke xis re náꞌ Pab nde tolo ne mbrez mzaꞌ, nchab mza': —Re mbiꞌ reꞌ ndli sinꞌ lo Dios naro toz, le' xa' ndetej lo goꞌ ned jwanꞌ xomod lyaꞌ men! ");
INSERT INTO ztp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nde naꞌr toz wiz ta mketebez mzaꞌ, axta kebeꞌ ngoche lazoꞌ Pab, nde mbyek Pab, nchab Pab lo xbi jwanꞌ ndono mzaꞌ: —Lo le Jesucrist, nyebeꞌn loa broꞌte lazoꞌ mzaꞌ ba. Nde zyaga mbroꞌte xbi ya lazoꞌ mzaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Leꞌ re xaꞌ ta nak xwan' mzaꞌ, senꞌ mne xaꞌ naꞌnzenaꞌtra' mzaꞌ tmi, zya mxen xaꞌ Pab nde Silas mbeꞌ xaꞌ xaꞌ lo men nak sinꞌ yolow ro. ");
INSERT INTO ztp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nde mbroꞌtono xaꞌ Pab kon Silas lo men nak sinꞌ nde nchab xaꞌ: —Rop mbiꞌ reꞌ nak men judí nde ngetetokan xaꞌ re men yez naꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ndloꞌ xaꞌ thibned jwanꞌ naꞌnyeda kaya' men nde jwan' na'ndabloda li men, tak naꞌ re', men yez Rom nak na'. ");
INSERT INTO ztp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Zyasa reta mayez mkeꞌ xaꞌ yalke yek Pab kon Silas, leꞌ re xaꞌ nak sinꞌ mnabeꞌ xaꞌ mbroꞌte xab Pab kon Silas nde mdin xaꞌ xaꞌ kon ya kos. ");
INSERT INTO ztp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Senꞌ ngolo mdin toz xaꞌ rop mbiꞌ re', mblo xaꞌ xaꞌ lizyiꞌb nde mnabeꞌ xaꞌ lo xaꞌ ngenap lizyiꞌb sa jwin toz kenap xaꞌ rop mbiꞌ re'. ");
INSERT INTO ztp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Senꞌ mkayaꞌ xaꞌ yalnyebeꞌ ya, zya ngwa lo xaꞌ Pab kon Silas ti tenꞌ mas naꞌs lenꞌ lizyiꞌb nde mblo xaꞌ ni Pab kon ni Silas lenꞌ yeꞌr lad ya tenꞌ naꞌnyeda tyoli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nde rolja yalꞌ, Pab kon Silas mdodiꞌsno xaꞌ Dios nde mbilꞌ xaꞌ lo Dios nde reta xaꞌ jwan' nge lizyiꞌ mbin xa' jwan'na. ");
INSERT INTO ztp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Zyasa mbye'd ti xo toz, axta re xanꞌ btoꞌ chanꞌ lizyiꞌb mbwina, zyaga mxyalꞌ reta ro yala nde mxyak re kaden jwanꞌ ndobo re xaꞌ nge lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Senꞌ mbroꞌxkalꞌ xaꞌ ta ngenap lizyiꞌb, mbwiꞌ xaꞌ ndoxalꞌ reta ro lizyiꞌb, zya mbloꞌte xaꞌ espad xaꞌ sa kuj xaꞌ lazoꞌ xaꞌ, tak mbli xaꞌ xgab mxonꞌ reta men nge lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Zya ne mbrez Pab, nchab Pab lo xaꞌ: —Naꞌkujta lu lazoꞌa, tak reta náꞌ nziꞌ ncheꞌ! ");
INSERT INTO ztp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Leꞌ xaꞌ ngenap lizyiꞌb mnaꞌb xaꞌ xni nde mkeꞌ xaꞌ karrel ngote xaꞌ lenꞌ lizyiꞌb, anta nxiꞌd xaꞌ mdo xub xaꞌ lo ni rop xa'. ");
INSERT INTO ztp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Zyaga mbloꞌte xaꞌ Pab kon Silas nde nchab xaꞌ: —¿Cho kwan ndablo lin sa lyaꞌn? ");
INSERT INTO ztp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Leꞌ Pab kon Silas mkab lo xaꞌ: —Bli lazoꞌa Jesucrist Xaꞌ Nyebeꞌ, sa lyaꞌa nde lyaꞌ reta men liz la. ");
INSERT INTO ztp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nde mdej xaꞌ xkiꞌs Dios lo mbiꞌ ya nde lo re men liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nde yalꞌ yaga, xaꞌ ta ngenap lizyiꞌba mtach xaꞌ tenꞌ nawiꞌy lad Pab nde lad Silas, nde zyaga ngwa xa' sa mbro'le xaꞌ nde kon re men liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nde mbeꞌ xaꞌ Pab kon Silas liz xaꞌ sa mda re xaꞌ nde nale toz ngo lazoꞌ re liz xaꞌ, tak mbli lazoꞌ xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Senꞌ mduxni izyo, re xaꞌ nak sinꞌ mtelꞌ xaꞌ policí sa ngwatne policí lo xaꞌ ta ngenap lizyiꞌb, sa laꞌ xaꞌ Pab kon Silas. ");
INSERT INTO ztp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Leꞌ xaꞌ ngenap lizyiꞌba, nchab xaꞌ lo Pab: —Re xaꞌ nak sinꞌ mnabeꞌ ryoꞌte goꞌ; jwanꞌ nasa broꞌte goꞌ nde nabeꞌz bya goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Leꞌ Pab nchab lo re policí: —Nzi wiꞌ reta men ngen cho yalke mdin xaꞌ náꞌ, mkeꞌ xaꞌ náꞌ lizyiꞌb nde men yez Rom nak náꞌ. ¿Nde naya ncholaꞌs xaꞌ nagaꞌs kote xaꞌ náꞌ? Naꞌakta jwanꞌna, nakinꞌ yub xaꞌ nyebeꞌ yeꞌd sa kote xaꞌ náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Leꞌ re policí ngwayab xaꞌy lo re xaꞌ nyebeꞌ, senꞌ mbin re xaꞌ nyebeꞌ leꞌ Pab kon Silas nak xaꞌ men Rom, mzyeb toz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Zyasa re xaꞌ nyebeꞌ ngwa xaꞌ nde mnaꞌb xaꞌ lo Pab kon Silas sa riꞌd xaꞌ yek xaꞌ re jwanꞌ ngok. Nde mbloꞌte xaꞌ xaꞌ lizyiꞌb nde mnaꞌb xaꞌ lo xaꞌ sa ryoꞌte xaꞌ lenꞌ yez. ");
INSERT INTO ztp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Senꞌ mbroꞌte rop xaꞌ lizyiꞌb, ngwa xaꞌ liz Lid, senꞌ ngolo mbwiꞌ xaꞌ re wes nde mblone xaꞌ lazoꞌ re wes, zya ngo xaꞌ ned ndya xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pab kon Silas, mbridndaꞌb xaꞌ yez Anfípolis nde yez Apolonia zyaraꞌ mzin xaꞌ yez Tesalónica, tya ndob ti yo jwanꞌ ndyop men Israel. ");
INSERT INTO ztp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Leꞌ Pab, xa naka xaꞌ, ngwa xaꞌ tenꞌ ndob yo ndyop re men Israel, nde son wiz jwanꞌ ta ndroxkwen men ngwa xaꞌ kwent kon re men nzi tya, ");
INSERT INTO ztp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nde xa ngeni xkiꞌs Dios ta mbloꞌxkan Paba lo re men, leꞌ Crist nakinꞌka rid Xaꞌ yalti nde ryoꞌxban Xaꞌ xij re men nguj nde noga nchab Pab: —Leꞌ Jesús ta ndej na reꞌ, Xaꞌ nak Crist. ");
INSERT INTO ztp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nde nzo pla xaꞌ judí mbli lazoꞌ xaꞌ Jesús, mkata xaꞌ kon Pab nde kon Silas, leꞌ re xaꞌ gryeg, xaꞌ jwan' nxobyek Dios nde re ngol jwanꞌ ntak lo yez, bro toz re xaꞌ reꞌ mbli lazoꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Zyasa re xaꞌ judí xaꞌ naꞌndlid lazonꞌ Jesús, mxí lazoꞌ xaꞌ, mthop xaꞌ pla mbiꞌ saꞌb, mbiꞌ narax, nde mkata bro xaꞌ sa ngok bxol xaꞌ lenꞌ yez. Mbla xaꞌ liz Jasón, nkwanꞌ xaꞌ Pab kon Silas sa kote xaꞌ xaꞌ nde tayaꞌ xaꞌ xaꞌ lo mayez. ");
INSERT INTO ztp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lo ta naꞌngasalta xaꞌ Pab kon Silas, zyasa mbeꞌ xaꞌ Jasón kon tipla wes, nde mdayaꞌ xaꞌ xaꞌ lo re xaꞌ nak sinꞌ lo yez, nchab xaꞌ: —Xaꞌ reꞌ ngetetokan men dib nax izyo nde naya nde xaꞌ ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón mdaꞌ yo nzo xaꞌ, nde reta men jwanꞌ ndyonke xis xaꞌ na'nxobyekta xaꞌ re jwanꞌ nyebeꞌ Cesar, tak mbez xaꞌ ke nzogaꞌ tedib rey ndole Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sen mbin re mayez jwanꞌ reꞌ nde kon re xaꞌ nak sinꞌ, zyasa ngok bxol reta xa'. ");
INSERT INTO ztp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Per Jasón nde ti pla wes mdi'x xaꞌ lo xaꞌ yolow sa mblaꞌ xaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zyaga re wes, yalꞌ mtelꞌ xaꞌ Pab kon Silas axta yez Berea. Nde benꞌta mzin ned xaꞌ Berea, ngwa xaꞌ yo tenꞌ ndyop re men judí. ");
INSERT INTO ztp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nde re men nzi tya mas wen nak xaꞌ ke re men nzi yez Tesalónica, tak re xaꞌ reꞌ, dib nzo lazoꞌ xaꞌ mbin xaꞌ xkiꞌs Dios nde reta wiz nteꞌd xaꞌ xkiꞌs Dios sa nye xaꞌ nyenꞌ cho li ta naka. ");
INSERT INTO ztp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nde bro toz re xaꞌ nzi tya mbli lazoꞌ xaꞌ Jesús, tagaꞌ bro re xaꞌ grieg, xa nak re ngol ndak lo yez nde re men biꞌ, mbli lazoꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Per re xaꞌ judí, xaꞌ yez Tesalónica, senꞌ mbin xaꞌ no yez Berea ngetetej Pab xkiꞌs Dios, zya ngwa xaꞌ tya, nde mtoxol xaꞌ re mayez. ");
INSERT INTO ztp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Zyaga, re wes, mtelꞌ xaꞌ Pab sa ya Pab ned ro nittoꞌ, leꞌ Silas kon Timoteo mbyanꞌ xaꞌ yez Berea. ");
INSERT INTO ztp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nde re wes jwanꞌ ndaloꞌ ned lo Pab, mbeꞌ xaꞌ Pab axta yez Atenas. Zyaga mbere xaꞌ tedib gob, ndeno xaꞌ diꞌs jwanꞌ mtelꞌ Pab lo Silas kon lo Timoteo sa ken xaꞌ ya xaꞌ tenꞌ nzo Pab. ");
INSERT INTO ztp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Laj mkembed Pab yez Atenas sa yotu Silas kon Timoteo, axta mbyow lazoꞌ Pab tak mbwiꞌ Pab mze len' yez nzi re mnab jwan' ndli lazo' xa'. ");
INSERT INTO ztp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jwanꞌ nasa, ngwa Pab di's kon re xa', lenꞌ yo tenꞌ ndyop men Israel, kon re xaꞌ judí nde re xa' jwan' nxobyek toz Dios, tagaꞌ kon re xaꞌ jwanꞌ ndyop lo xbiꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nde pla xaꞌ nchak, xaꞌ jwanꞌ nak epicúreos nde tedib ned xaꞌ nak estoicos, ngwa xaꞌ di's kon Pab. Nde tipla xaꞌ nchab: —¿Cho kwent ndaꞌ mbiꞌ todiꞌs pchoba? Tipla xaꞌ nchab: —Tyak men kwent chanꞌ tib ned dios kub ndetej xaꞌ . Tak leꞌ Pab ndej diꞌs wen chanꞌ Jesucrist nde chan' yalndryoxban. ");
INSERT INTO ztp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Zya mxen xaꞌ Pab nde mbeꞌ xaꞌ Pab Areópago, nde nchab xaꞌ: —¿Cho toyal nye náꞌ xamod nak yalteꞌd kub ta ndej la ba? ");
INSERT INTO ztp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tak na'nzolotirta náꞌ re jwanꞌ ta ndej la ba. Ncholaꞌs náꞌ nye náꞌ xomod naka. ");
INSERT INTO ztp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tak re men yez Atenas nde re men xaga yez jwan' nzo tya, ngentra' kwan mbix xa', benꞌta ndyen xaꞌ todiꞌs xaꞌ nde gon xaꞌ re jwanꞌ kub. ");
INSERT INTO ztp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Zyasa mdoli Pab xij re men nzi Areópago, nchab Pab: —Men yez Atenas, ngwiꞌn jwanꞌ toz ndli lazoꞌ goꞌ re dios jwanꞌ ngeno goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tak laj ndari'd na, mbwi'n ten' nxobyek goꞌ re dios goꞌ tya ngosiꞌb na ti tenꞌ nchab: \"LO DIOS NAꞌNZOLOD MEN\". Dios jwanꞌ ta naꞌnzolod goꞌ nde nxobyek goꞌ, Xaꞌ ya ta ndej na reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios ta mdoxkwaꞌ izyo nde reta jwanꞌ nzi xis izyo, Xaꞌ ya Nyebeꞌ lo beꞌ nde izyo. Na'nchod Xaꞌ lenꞌ yodoꞌ ndoxkwaꞌ ya men, ");
INSERT INTO ztp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nekla nakinꞌ Xaꞌ men toxkwaꞌ jwanꞌ ncholaꞌs Xaꞌ, tak Xaꞌ ndaꞌ yalnaban, Xaꞌ ndli sa nzì men nde Xa' nda' reta jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Kon thipta mbiꞌ mtoyaꞌr Dios reta ned men ta nzi dib xis izyo; nde Dios mtanꞌ nyenꞌ cho beꞌ ban men nde ploja kwe men. ");
INSERT INTO ztp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Sa kwanꞌ men Dios, tez toyala te' ya' men sa yosal men Xaꞌ, tak di's gal'ka na'ndod Dios tij lo na'. ");
INSERT INTO ztp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tak Dios ndli sa naban naꞌ, ngwin naꞌ nde nzonꞌ. Xa nchabka pla men go', xa' nchak, ntoxkwa' di ngo xij go' pola: “Lo bin Dios ndenꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Lo ta ndenꞌ lo bin Dios, nandabloda linꞌ xgab leꞌ Dios nya xaja nya ti mnab ta naksaꞌ or, jwanꞌ plat o ke, jwanꞌ ntoxkwaꞌ yaꞌ men, jwan' axaja nchal yek men ntoxkwa' men. ");
INSERT INTO ztp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Per Dios, mtoriꞌd yek Xaꞌ re jwanꞌ kow mbli re men nzi pola, nde naya Dios nyebeꞌ lo reta men, sa reta tenꞌ nzi men laꞌ men re jwanꞌ narax nak men nde bere men lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lo ta mtanꞌla Dios ti wiz nyaꞌb Xaꞌ kwent lo reta men kon ti mod galꞌ, jwanꞌna li mbiꞌ ta mblí Dios, nde mtan'no Dios Xa' lo reta men senꞌ lo mbliche Dios Xaꞌ xij re men nguj. ");
INSERT INTO ztp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Senꞌ mbin re xaꞌ jwanꞌ ta ryoꞌxban men nguj, nzo men mxino xaꞌ Pab nde nzo xaꞌ nchab: —Ba tedib gob sa gon náꞌ tud jwanꞌ ta ndej la ba. ");
INSERT INTO ztp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nde tamod mbro'te Pab xij re xa' ya. ");
INSERT INTO ztp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nzo pla xaꞌ mbli lazonꞌ xkiꞌs Dios nde mdonke xaꞌ xis Pab, xija nzo tib xaꞌ ndole Nich, xaꞌ jwanꞌ nzo xij re xaꞌ nyebeꞌ lo Areópago, kon ti ngol ndole Dámaris nde nzoraꞌ masraꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Senꞌ ngolo re jwanꞌ reꞌ, Pab mbroꞌ yez Atenas nde nda xaꞌ yez Corint. ");
INSERT INTO ztp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tya ngosi'b xaꞌ ti mbiꞌ judí ndole Aquil kon xaꞌ got xaꞌ Priscil xaꞌ lo xyon Ponto per leꞌ xaꞌ ngo Italia nde ludla ndate mbroꞌ xaꞌ Italia mzin xaꞌ yez Corint, tak Claudio xaꞌ nyebeꞌ lo yez Rom, mnabeꞌ sa reta men judí ndablo ryoꞌte xaꞌ yez Rom. Leꞌ Pab ngwatna rop ta xaꞌ reꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tak thipta rsin' xa', jwanꞌ nasa mbyanꞌ Pab kon xaꞌ sa thita mke xaꞌ sin', tak le' xa' ntoxkwaꞌ re yo yid maꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nde reta wiz jwanꞌ ndryoxkwen men nda Pab tenꞌ ndob yo ndyop re men Israel sa ncha Pab di's kon re xaꞌ judí nde re xaꞌ na'nakta judí sa ko Pab yek xa' li lazoꞌ xaꞌ Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Senꞌ mbroꞌ Silas kon Timoteo lo xyon Macedon nde mzin xaꞌ yez Corint, reta wiz mketetej Pab xkiꞌs Dios nde ngoꞌxkan Pab lo re xaꞌ judí ke Jesús nak Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per re xaꞌ judí naꞌndoyalta xaꞌ ndli lazoꞌ xaꞌ jwanꞌ ndej Pab nde mni xin xaꞌ, zyasa mzib Pab xab Pab nde nchab Pab lo xaꞌ: —Leꞌga goꞌ nchap yalke sa lux goꞌ, leꞌ na nambi ndon, ncheꞌja lan goꞌ, naya leꞌn nda lo re men naꞌnakta judí. ");
INSERT INTO ztp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Senꞌ mbroꞌ Pab tya, nda Pab liz ti xaꞌ ndole Just, xaꞌ nzeb lazonꞌ Dios, liz xaꞌ ndob gax cho yo tenꞌ ndyop re men Israel. ");
INSERT INTO ztp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Leꞌ Crispo, xaꞌ nyebeꞌ lenꞌ yo tenꞌ ndyop re men Israel, re liz xaꞌ mbli lazoꞌ xaꞌ Jesús, na bro toz re men yez Corint, lo mbin xaꞌ xkiꞌs Dios mbli lazoꞌ xaꞌy nde mbro'le xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Zyasa yalꞌ mni Xaꞌ Nyebeꞌ lo Pab xaja men nzalꞌ lazonꞌba, nchab Xaꞌ: —Naꞌzyepta lu, ptej xkiꞌs na lo re men nde natowꞌta la roa, ");
INSERT INTO ztp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","tak na ndo kon lu, nde nek thib xaꞌ naꞌlida gan toti xaꞌ lu, tak bro toz men ngenon yez reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jwan' nasa, tib linꞌ narol ngo Pab yez Corint, mbloꞌ xaꞌ xkiꞌs Dios lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lenꞌ linꞌ ya, Galión nak xaꞌ nyebeꞌ lo xyon Akaya, zyasa re xaꞌ judí thita ngok diꞌs xaꞌ sa keꞌ xaꞌ yalke yek Pab nde mbeꞌ xaꞌ Pab yolow, ");
INSERT INTO ztp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","sa nchab xaꞌ: —Mbiꞌ reꞌ, ngetetokilꞌ re men sa xobyek men Dios ti mod naꞌngenida ley. ");
INSERT INTO ztp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Le'ja tyobte kab Pab, ner Galión nchab lo re xaꞌ judí: —Re goꞌ men judí, tez ngaka nchap xaꞌ reꞌ cho yalke o tez nchap xa' yalke ro jwan' mbij xaꞌ men, zyasa ndabloga wiꞌn chenꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per tez napta diꞌsa, beꞌn le mena nde ley chanꞌ goꞌy, leꞌga goꞌ bwiꞌy, tak naꞌncholasta na goxyon jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nde mbloꞌte xaꞌ xaꞌ lenꞌ yolow. ");
INSERT INTO ztp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Zyasa reta xa' mxenta, mxen xaꞌ Sóstenes, xaꞌ jwanꞌ nyebeꞌ lenꞌ yo tenꞌ ndyop men Israel nde tyaga lo re xaꞌ yolowa mdin xaꞌ xaꞌ, anaꞌndyo Galión jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Leꞌ Pab tata bro ngo xa' yez Corint. Ngolo jwan'na, Pab nchab lo re wes ke yo Pab ned tyen xa' bark ya xa' lo xyon Siria, zyasa mbeꞌ Pab Priscil kon Aquil, lo senꞌ mzin xaꞌ yez Cencrea ro nitto', tya thiptane mchub Pab yek Pab, tak jwan'na mkeꞌyekla Pab lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Senꞌ mzin xaꞌ yez Éfeso, tya mblaꞌ Pab Priscil nde Aquil nde nda Pab tenꞌ ndob yo ndyop re men Israel, tya ngwa Pab diꞌs kon re xaꞌ judí. ");
INSERT INTO ztp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Re xaꞌ nzi tya mnaꞌb xaꞌ lo Pab sa kwed Pab lo xaꞌ tipla wiz, per naꞌndoyalta Pab, ");
INSERT INTO ztp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","che'la nchab Pab lo xaꞌ: — Nakinꞌ ndan yez Jerusalen sa tya riꞌd na ni jwanꞌ nde gaxla, per tez Dios nchola'sa tye'd winꞌ goꞌ tedib gob. Zyasa ngo Pab ned yez Éfeso, ngwap Pab bark ndya Pab. ");
INSERT INTO ztp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Senꞌ mzin Pab yez Cesarea, mbroꞌ Pab mbya Pab yez Jerusalén, mbya ni Pab dyux lo re wes nzi yodoꞌ, nde tya mdola Pab nda Pab yez Antioquí. ");
INSERT INTO ztp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ngolo ngo Pab tya ti tyemp, xisa mbroꞌ Pab ngwatna xaꞌ kad thiba yez jwanꞌ nzi lo xyon Galacia nde Frigia, ngwalo ne xaꞌ lazoꞌ re wes. ");
INSERT INTO ztp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zyasa yez Éfeso mzin ti xaꞌ judí ndole Apolos, xaꞌ yez Alejandrí, Mbiꞌ reꞌ nchak toz ndyodiꞌs xaꞌ nde jwin toz nzolo xaꞌ xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mtoteꞌd men xaꞌ lo xned Xaꞌ Nyebeꞌ, nde nale toz nzo lazoꞌ xaꞌ, ndyodiꞌs xaꞌ nde ndloꞌ xaꞌ xkiꞌs Dios axata nak kwent chanꞌ Jesús, te'nyega benꞌ jwanꞌ nzolo xaꞌ nak, jwanꞌ ta mblo'le Juan men. ");
INSERT INTO ztp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nde naꞌnzyebta Apolos tolo mdobte mdej xaꞌ xkiꞌs Dios lenꞌ yo tenꞌ ndyop re men Israel nde senꞌ mbin Priscil nde Aquil jwanꞌ reꞌ, zya xaꞌta mbeꞌ xaꞌ Apolos nde jwin mbloꞌxkan xaꞌ xamodpa nak xkiꞌs Dios lo Apolos. ");
INSERT INTO ztp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Senꞌ ncholaꞌs Apolos ya xaꞌ lo xyon Akaya, leꞌ re wes mblaꞌsto xaꞌ Apolos mkeꞌ xaꞌ ti yeꞌs mtelꞌ xaꞌ lo re wes nzi Akaya sa kayaꞌ xaꞌ Apolos. Senꞌ mzin Apolos lo xyon Akaya mblaꞌsto toz xaꞌ re men, re men jwanꞌ por yalwen chanꞌ Dios sa mbli lazoꞌ xaꞌ Jesús. ");
INSERT INTO ztp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nde nzi wiꞌ reta men, gal' mni Apolos lo re xa' judí, mblo'xkan Apolos xki's Dios axata ngeniy, ke Jesús nak Xaꞌ Mtelꞌ Dios, nde na'nsalta nkab re xa' judí. ");
INSERT INTO ztp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Laj ngete Apolos yez Corint, Pab ngolo mbri'd lo xyon men nzi yiꞌ nde mzin xaꞌ yez Éfeso, tya mzyalꞌ xaꞌ naꞌr men ndli lazonꞌ xkiꞌs Dios, ");
INSERT INTO ztp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","nde nchab Pab lo xaꞌ: —¿Cho mkayaꞌ goꞌ Mbi Nayon senꞌ mbli lazoꞌ goꞌ Jesús? Leꞌ xaꞌ mkab: —Nekla nchon náꞌ cho nzo Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Zyasa nchab Pab lo xaꞌ: —¿Xomodka mbro'le goꞌ sa? Leꞌ xaꞌ mkab: —Xata mod jwanꞌ mbloꞌ Juan lo náꞌ mbro'le náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Zya nchab Pab: —Juan mbro'le re men jwan' mbere lo Dios, nde nchab Juan lo re men sa li lazoꞌ men Xaꞌ jwan' ndenke xis Juan, Xaꞌ ya nak Jesús, Xaꞌ mtelꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Senꞌ mbin xaꞌ jwanꞌna, mbro'le xaꞌ lo le Jesús, Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nde senꞌ mxob yaꞌ Pab yek re xaꞌ, mbla Mbi Nayon yek re xaꞌ, nde mni xaꞌ xaꞌla diꞌs nde mdej xaꞌ re jwanꞌ teraꞌ ak. ");
INSERT INTO ztp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Reta xaꞌ biꞌ jwanꞌ nzi tya, mkata tibsenka xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nde naꞌnzyepta Pab nchote Pab lenꞌ yo ndyop men Israel, dipta lenꞌ son mbeꞌ, nda xaꞌ di's nde ndaꞌ xaꞌ kwent lo men sa yen men yalnyebeꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per nzo pla men ne yek naꞌ naꞌndlid lazoꞌ xaꞌy, cheꞌla nzi wiꞌ re men mni xin xaꞌ xis xned Dios, zyasa mblaꞌ Pab re xaꞌ ya nde xaꞌta mbeꞌ Pab re xaꞌ jwanꞌ ndli lazonꞌ Jesús, tenꞌ ndob yoskwel chanꞌ ti xaꞌ ndole Tiran, nde tya ncha Pab di's kon re xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tamod mbli xaꞌ lenꞌ chop linꞌ sa reta men nzo lo xyon Asia, xaꞌ judí nde xaꞌ na'nakta judí, mbin xaꞌ xkiꞌs Jesús Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nde mbli Dios re yalnaro toz kon ya' Pab, ");
INSERT INTO ztp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","axta re bayek nde re lar jwanꞌ ndinꞌ lad Pab, ncheꞌ xaꞌy lo re men nayiz nde nchak men lo re yiz ndyak men nde re mbi narax ndryoꞌtey lazoꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Per pla xaꞌ judí, xa' ngoꞌte mbi narax lazoꞌ re men, ncholaꞌs xaꞌ li rsinꞌ xaꞌ le Jesús Xaꞌ Nyebeꞌ, sa kote xaꞌ mbi narax, nde mbez xaꞌ lo mbi narax: —Lo le Jesús, Xaꞌ ta ndej Pab, nyebeꞌn loa broꞌte. ");
INSERT INTO ztp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jwanꞌna ndli re gas xinꞌ ti xaꞌ judí ndole Esceba, xaꞌ nyebeꞌ lo re nglweyꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per mbi naraxa nkaba lo xaꞌ nde nchaba: —Nzolon Jesús nde mnen cho nak Pab, per goꞌ, ¿Cho nak goꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nde leꞌ mbiꞌ ta ndono mbi naraxa, mboꞌ mbi' xis re xaꞌ ya, nde mbli mbiꞌ gan mkeꞌ mbi'y cho re xaꞌ, per mbli xaꞌ gan mxonꞌ xa' lenꞌ yo nde tata cheꞌy xaꞌ nda xaꞌ taja mbwiyꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Reta men nzo yez Éfeso, re xaꞌ judí nde re xaꞌ na'nakta judí senꞌ mbin xaꞌ jwanꞌ ngok, mzyeb toz xaꞌ, nde masraꞌ mxoꞌbyek xaꞌ le Jesús Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nde bro toz men jwanꞌ mblila lazonꞌ Jesús nche'd xaꞌ, nxobdol xa' nde ndej xaꞌ reta jwanꞌ narax ndli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tagaꞌ bro toz re xaꞌ ngok xaꞌ mxí, mbyedno xaꞌ re libr nteꞌd xaꞌ nde nzi wiꞌ re men mtolꞌ xaꞌy. Lo mbloꞌ xaꞌ kwent plopa ntak reta libr ya, mbroꞌtoy choꞌpziꞌ mil tmi plat. ");
INSERT INTO ztp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tamod ndoxena nde ndloꞌy yalne chanꞌ xkiꞌs Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Senꞌ ngolo re jwanꞌna, mbli Pab xgab ya Pab yez Jerusalén, per nerla rid xaꞌ lo xyon Macedon nde Akaya, nde noga nchab Pab: Senꞌ ngolo ngwan Jerusalen, nakinꞌka yan yez Rom. ");
INSERT INTO ztp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Zyasa mtel' Pab Timoteo kon Erast, chop xaꞌ jwanꞌ ndli kompay Pab sa ya xa' lo xyon Macedon, laja mbled Pab tud lo xyon Asia. ");
INSERT INTO ztp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Len' wiz ya, nakta lud mxyol re men yez Éfeso por kwent chanꞌ xned Dios. ");
INSERT INTO ztp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tak ti xaꞌ ndole Demetr, xa' ntoxkwaꞌ re jwanꞌ plat, ntoxkwaꞌ xaꞌ re yodoꞌ bix chanꞌ dios ndole Artemis, nde tmi toz nzenaꞌ re xa' ta ndoxkwa' re jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nde mthop Demetr re xaꞌ nke sinꞌ, le'ga sin' ya, sa nchab Demetr lo xaꞌ: —Reta go mbiꞌ, goꞌ mne benꞌta lo sinꞌ reꞌ nzenanꞌ tmin naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Per ngwiꞌla goꞌ nde nchonla goꞌ jwanꞌ ngeteli Pab, naꞌnakte benꞌta yez Éfeso noga mer dib lo xyon Asia, bro toz men ngetetokilꞌ xaꞌ nde mbez xaꞌ, ke naꞌnakta dios, re dios ta ntoxkwaꞌ yaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nde na'nakta be'nta lux re rsin' na', noga yodoꞌ ro chanꞌ dios Diana tluxa, tak reta men tolo taꞌb xaꞌ yalnaro chanꞌ dios, dib Asia nde dib nax izyo. ");
INSERT INTO ztp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Senꞌ mbin reta xaꞌ jwanꞌna, mxitin lazoꞌ xaꞌ nde ne mbrez xaꞌ, nchab xaꞌ: —¡Naro nak Diana, dios lo re men yez Éfeso! ");
INSERT INTO ztp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Reta men yez ngok bxol xaꞌ, nde zyaga mxen xaꞌ Gay kon Aristark, chop mbiꞌ jwanꞌ ndli compay Pab, mbi' lo xyon Macedon, mdoꞌbnyo xaꞌ rop mbiꞌ ya axta tenꞌ nzidop reta ma yez. ");
INSERT INTO ztp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nde ncholaꞌs Pab ndla Pab xija sa ni Pab lo re men, per re wes nzi tya naꞌnda'd xaꞌ diꞌs. ");
INSERT INTO ztp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Noga pla xaꞌ nak sinꞌ lo xyon Asia, xaꞌ jwanꞌ nzalꞌta Pab, mtelꞌ xaꞌ di's lo Pab sa naꞌyad Pab tenꞌ nzidop reta men ya. ");
INSERT INTO ztp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tak thibned xaꞌ mbez ti jwanꞌ nde tedibned xaꞌ mbez tedib jwanꞌ anta mbwan re xaꞌ, nde masraꞌ xaꞌ anaꞌnye xaꞌ kwan liy mdyop xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Le' pla xa' jwan' nak sin' lo men judí mblo' xa' Lejantr, nde mchep xa' Lejandr axta lo. Zyasa mtaꞌb yaꞌ Lejandr lo reta men sa naꞌkwestra' men, tak nchola's Lejandr ni xaꞌ lo mayez sa la xa' re men judí. ");
INSERT INTO ztp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per senꞌ mne re men ke no Lejandr nak men judí, mer nye ti chopka hor mas ne mbrez xaꞌ, nchab xaꞌ: —¡Naro nak Diana, dios lo re men yez Éfeso! ");
INSERT INTO ztp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Zyasa ti xaꞌ nak sinꞌ lo yolow, xaꞌ jwanꞌ nkeꞌ yeꞌs, senꞌ mbli xaꞌ gan mbrexe re men, zyasa nchab xaꞌ: —Men yez Éfeso, ¿Cho na'nyeda ke yez Éfeso ngenap men yodoꞌ chanꞌ dios ro Diana, nde Júpiter mbroꞌ mnab chan' dios re'? ");
INSERT INTO ztp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Lo ta reta men mne jwan' re', naꞌndabloda taja kwes go'. Xe bre goꞌ nde jwin bli goꞌ xgab ti jwanꞌ sa li goꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tak re mbiꞌ ta ndeno goꞌ ncheꞌ, namblid xaꞌ narax lo yodoꞌ, neka ni xin xaꞌ xis dios naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tez Demetr kon re men jwanꞌ ngeno xaꞌ sinꞌ, nkwanꞌ xaꞌ yalbyo kon xaꞌla men, jwanꞌ naga ndli nzo xaꞌ nak sinꞌ, nzo jwes, xaꞌ ya wiꞌ re jwanꞌna nde tya todiꞌs kad thiba xaꞌ nyenꞌ xa nak chanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nde tez nzo cho tedib jwanꞌ ncholaꞌs goꞌ, ndablo tej goꞌy senꞌ ncho yaltodiꞌs ro. ");
INSERT INTO ztp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tak jwan' ta ngok naya nzo mod ke yalke yek naꞌ nak na' men nkwan' byo, nde naꞌzyalta tan' kwent xomod ngok jwanꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nde senꞌ ngolo nchab xaꞌ jwanꞌ reꞌ, mchaꞌz xaꞌ reta men. ");
INSERT INTO ztp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Senꞌ lo mne taja ngok bxol reta men, zyasa mbrez Pab re xaꞌ ta ndli lazonꞌ Jesucrist nde senꞌ ngolo mtoni Pab xaꞌ, mdeꞌs Pab xaꞌ, nde nchab Pab lo xaꞌ ke yo Pab ned, zyasa nda Pab lo xyon Macedon. ");
INSERT INTO ztp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Senꞌ ngolo mbri'd Pab dib lo izyo ya nde noga jwanꞌ toz mtoni Pab re wes, zyaraꞌ mzin Pab lo xyon Grecia. ");
INSERT INTO ztp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Senꞌ ngolo son mbeꞌ nzo Pab Grecia, zya nak kwent tyen Pab bark nda Pab lo xyon Siria, per mbin Pab leꞌ re xaꞌ judí mbyanꞌdiꞌsla xa' toti xaꞌ Pab. Zyasa mbli Pab xgab tyen Pab ned lad lo xyon Macedon. ");
INSERT INTO ztp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nde naꞌr xaꞌ mdonke xis Pab, ti xaꞌ ndole Sópater xaꞌ yez Berea, Aristarco nde ti xaꞌ ndole Segund xaꞌ yez Tesalónica, Gay, xaꞌ yez Derbe nde Timoteo; leꞌ Tíquico nde Trófimo nak xaꞌ men lo xyon Asia. ");
INSERT INTO ztp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Re xaꞌ reꞌ mzi'blo nde mbled xaꞌ náꞌ yez Troas. ");
INSERT INTO ztp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Leꞌ náꞌ, senꞌ ngolo mbrid wiz jwanꞌ ncha men pan naꞌngenta lebadur, zya ngwap náꞌ lo bark, mbroꞌ náꞌ yez Filipos nde senꞌ ngoxoꞌb gayꞌ wiz zyaraꞌ mkata náꞌ xaꞌ, tenꞌ nak yez Troas tenꞌ mbyanꞌ náꞌ gaz wiz. ");
INSERT INTO ztp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wiz ner xanꞌ sman, zya mdyopbe reta náꞌ sa thita wa náꞌ pan, leꞌ Pab mbloꞌ xkiꞌs Dios tak tedib wiz yo Pab ned, nde mbroꞌnolꞌ mdodiꞌs Pab axta rol yalꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nde nzi toz re jwanꞌ ntoxni lenꞌ yo xtaꞌ gap tenꞌ nzi náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Leꞌ ti mbyo ndole Eutik, ndob or ro ventan nde tya mxen mkalꞌ or, tak nolꞌ toz mdodiꞌs Pab, zyasa thiptane mxen mkalꞌ yek or nde ngob or, mbroꞌr axta yo son xtaꞌ gap nde ngob or axta izyo, tya ngwaliche xaꞌ or nguj or. ");
INSERT INTO ztp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Zyasa naban toz mbla Pab mzin Pab tenꞌ nax or, mdeꞌs Pab or nde nchab Pab: —Naꞌzyepta goꞌ, naban mbyo. ");
INSERT INTO ztp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Zyaga bere ngwap xaꞌ gap tedib gob, mblirol xaꞌ pan mda re náꞌ nde tatka mdodiꞌs pab xkiꞌs Dios axta mduxni, nde tya ngo Pab ned ndya Pab. ");
INSERT INTO ztp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Leꞌ mbyo ta ngoba, naban or ndyano xaꞌ or, nde jwanꞌna ndli nale toz nzo lazoꞌ reta xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Leꞌ náꞌ mziꞌblo ngwap náꞌ bark nda náꞌ yez Asón sa tya yaxiꞌ náꞌ Pab, tak Pab mbroꞌ lazoꞌ xaꞌ nda ni xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Senꞌ mkata náꞌ xaꞌ yez Asón, mbeꞌ náꞌ xaꞌ lo bark nde nda náꞌ yez Mitilene. ");
INSERT INTO ztp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tya ngwap náꞌ bark nde tedib wiz mbriꞌd náꞌ ngo' lo izyo ndole Quío jwan' nax len' nitto' nde tedib wiz mzin náꞌ ro yez nax ro nit ndole Samos, tya zyaraꞌ mbriꞌd náꞌ yez Trogilio nde axta tedib wiz sa mzin náꞌ yez Mileto. ");
INSERT INTO ztp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tak xgab Pab nak, na'rita xaꞌ yez Éfeso, sa na'lyen'tozta xaꞌ Asia, tak ngen lazoꞌ xaꞌ sin xaꞌ yez Jerusalén, tezka tli xaꞌ gan tya rid xaꞌ wiz ni ndole Pentecostés. ");
INSERT INTO ztp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lo ndo Pab yez Mileto zya mbrez Pab re xaꞌ nak sinꞌ lo yodoꞌ yez Éfeso. ");
INSERT INTO ztp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Senꞌ mzin re xaꞌ lo Pab, zya nchab Pab lo xaꞌ: —Goꞌ mne, xamod mketeꞌn xij goꞌ dib tyemp, xata wiz jwanꞌ mzin ner na Asia. ");
INSERT INTO ztp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Lo dibta senꞌ ngon xij goꞌ mblin sinꞌ lo Xaꞌ nyebeꞌ kon dib nadoꞌ nzo lazoꞌn nde taja nge nit winꞌ lon, nchon' na lo ta ne mbriꞌd na re yalti jwanꞌ ncholaꞌs re xaꞌ judí li no xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per naꞌndlat na ndej na lo goꞌ re jwanꞌ li wen lo goꞌ, mbloꞌ nay lo goꞌ xij reta men nde mketeloꞌ nay liz goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nde tagaꞌ mbloꞌ nay lo re xaꞌ judí nde lo re xaꞌ naꞌnakta judí sa laꞌ xaꞌ re jwanꞌ narax nak xaꞌ nde bere xaꞌ lo Dios sa lipa lazoꞌ xaꞌ Jesucrist Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nde naya Mbi Nayon nyebeꞌ lon, ndan Jerusalén nde naꞌnyet na kwan yoteꞌn tya. ");
INSERT INTO ztp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Benꞌta jwanꞌ mnen nak, reta yez tenꞌ ngete'n, Mbi Nayon ndej lon keꞌlizyiꞌb xaꞌ na nde riꞌd na bro toz yalti. ");
INSERT INTO ztp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per na'ndlit na xgab nek thib jwanꞌna, nekla nkeꞌ lazoꞌn yalnaban chanꞌ na, cheꞌla ncholas na nale yolo rsin na, sinꞌ jwanꞌ mdayaꞌ Jesús Xaꞌ Nyebeꞌ lon, sa todiꞌs na diꞌs wen chanꞌ Jesucrist jwanꞌ nak yalwen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Nde mnepa na, nek thib goꞌ nde nek thib xaꞌ jwanꞌ mketetej na yalnyebeꞌ chanꞌ Dios, naꞌwiꞌtraꞌ goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jwanꞌ nasa, nawiz reꞌ nin lo reta goꞌ, ngenta cho yalke nchap na por kwent chanꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tak reta jwanꞌ ncholaꞌs Dios mdejla nay lo goꞌ, naꞌmkasta nay. ");
INSERT INTO ztp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jwanꞌ nasa pkenap lazoꞌ goꞌ nde pkenap goꞌ yez Dios, tak Mbi Nayon mdob goꞌ sa nak goꞌ xaꞌ kenapa, ta xa ngenap xaꞌ mbak xilꞌla, ta pkenap goꞌ yodonꞌ Xaꞌ Nyebeꞌ jwanꞌ mxiꞌ Xaꞌ kon ren Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Tak mnen, senꞌ naꞌngenta na, zya yeꞌd xaꞌga men xij goꞌ, xaja lob lusle ta ndlya xij mbak xilꞌla, ta toluꞌx xaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nde leꞌga xij goꞌ ryoꞌ xaꞌ loꞌ jwanꞌ kwinꞌ nde tokilꞌ xaꞌ re men ndli lazonꞌ Jesús sa tyonke men xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jwanꞌ nasa, bresaꞌ goꞌ nde ptelaꞌs goꞌ tak son linꞌ, yalꞌ nde ndlyabe naꞌmzanta na mtonin kad thiba goꞌ axta winꞌ mkaꞌba lon. ");
INSERT INTO ztp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Leꞌ naya, wes na nde ptan na, lo yaꞌ Dios tan na goꞌ, nde xkiꞌs Xaꞌ jwanꞌ nak yalwen, ngenoy yalne sa xyen goꞌ lo Dios, nde tayaꞌ Xaꞌ lo goꞌ jwanꞌ ta mkeꞌyek Dios lo re naꞌ ta nak yez nayon chanꞌ Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Naꞌndyablaꞌsta na jwanꞌ plat, neka jwanꞌ or, nde nekla thi xab men. ");
INSERT INTO ztp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Goꞌ mne, cheꞌla leꞌga yaꞌn nkwan na reta jwanꞌ nakinꞌ na nde jwanꞌ nakinꞌ re xaꞌ ngeteꞌnon. ");
INSERT INTO ztp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Reta jwanꞌ reꞌ mbloꞌn lo goꞌ, nakinꞌ li men sinꞌ sa laꞌsto men re xaꞌ nalát ndyak. Ptelaꞌs goꞌ diꞌs nchab Jesús: “Nabeꞌz toz nda men jwan' ndaꞌy, ke men kayaꞌy.” ");
INSERT INTO ztp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Senꞌ ngolo ta nchab Pab, mdoxub Pab nde thita mdoꞌdisno re xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ngolo jwanꞌna xaja kwana nchonꞌ reta xaꞌ, mdeꞌs xaꞌ Pab nde mdaꞌ xaꞌ chut lo Pab, ");
INSERT INTO ztp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","nabil toz ngo lazoꞌ re xaꞌ por diꞌs jwanꞌ nchab Pab, ke yaja naꞌwiꞌtra xaꞌ Pab. Nde ngwa toned xaꞌ Pab lo bark. ");
INSERT INTO ztp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Senꞌ ngo náꞌ ned, ngwap náꞌ bark ndagalꞌ náꞌ izyo ndole Cos jwan' nax len' nitto' nde tedib wiz ngwa náꞌ izyo ndole Rodas jwan' nax len' nitto' nde tya mbroꞌ náꞌ nda náꞌ yez Pátara. ");
INSERT INTO ztp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tya ngosiꞌb náꞌ ti bark jwanꞌ nda lo xyon Fenicia nde lo bark ya ngwap náꞌ nda ná'. ");
INSERT INTO ztp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Senꞌ mbwiꞌ náꞌ lo xyon Chipre jwanꞌ nzi xtowꞌ nit, mbyanꞌkey lad beg náꞌ, tak leꞌ náꞌ nda lo xyon Siria, nde leꞌ bark ndenoy yoꞌ jwanꞌ yanꞌ yez Tiro, tamod sa mzin náꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nde tya mzyal' náꞌ re xa' jwan' ndli lazonꞌ Jesús, tyaja mbled ná' gaz wiz. Leꞌ Mbi Nayon mni lo re wes nzi tya sa mdej xaꞌ lo Pab sa naꞌyad Pab yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Senꞌ ngoxoꞌb gaz wiz ngo náꞌ ned tya, leꞌ reta wes kon re men got xaꞌ, nde xinꞌ xaꞌ, ngwatoned xaꞌ náꞌ mzin náꞌ ro nittoꞌ, tya mdoxub re náꞌ nde mdodiꞌsno náꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ngolo jwanꞌna, mdeꞌs náꞌ ta náꞌ zyaraꞌ ngwap náꞌ lo bark nde leꞌ re wes ndya xaꞌ liz xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Senꞌ ngolo mbriꞌd náꞌ lo nittoꞌ, mbroꞌ náꞌ yez Tiro nde mzin náꞌ yez Tolemaida tya mdodiꞌsno náꞌ re wes nde thipta wiz mbled náꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lo tedib wiz, mbroꞌ Pab tya kon re náꞌ jwanꞌ nzino xaꞌ, ngwa náꞌ yez Cesarea, tya mzin náꞌ liz Blib xaꞌ jwan' ndej xkiꞌs Dios lo men, xaꞌ ya nak ti xaꞌ nzo xij re gaz xaꞌ ta mbli xaꞌ, xa' la'sto re apóst nde liz xaꞌ ya mbled náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Xaꞌ ya ngeno thap xinꞌ got xaꞌ, mzaꞌ yenꞌ nde Dios ni lo re mzaꞌ ya sa ndej mzaꞌ xkiꞌs Dios lo men. ");
INSERT INTO ztp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Senꞌ ndatela pla wiz nzi náꞌ tya, zyasa mzin ti xaꞌ nak profet mbroꞌ lo xyon Judea xaꞌ ndole Agabo. ");
INSERT INTO ztp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Xaꞌ reꞌ mbyeꞌd tenꞌ nzi náꞌ, mxen xaꞌ sint jwanꞌ nachal lenꞌ Pab, mtoboꞌ xaꞌ ni xaꞌ nde yaꞌ xaꞌ, nchab xaꞌ: — Che' mod ne Mbi Nayon, yez Jerusalén, cheꞌ go xaꞌ mbiꞌ ta nak chanꞌ sint reꞌ nde tayaꞌ xaꞌ xaꞌ lo yaꞌ re men naꞌnakta judí. ");
INSERT INTO ztp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Senꞌ mbin náꞌ jwanꞌ reꞌ nde kon re wes ta nzi tya mnaꞌb náꞌ lo Pab sa naꞌyad Pab yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Leꞌ Pab mkab lo náꞌ, ne xaꞌ: ¿Cho kwan liy sa nchonꞌ goꞌ nde ngonabil goꞌ lazoꞌn? Tak ndosaꞌla na, nde naꞌnakte benꞌta go xaꞌ na, noga axta kuj xaꞌ na yez Jerusalén por Jesús Xaꞌ Nyebeꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lo ta naꞌndlid náꞌ gan ngo náꞌ yek Pab, yaja nchab náꞌ: —Gaka xa ncholaꞌs Xaꞌ Nyebeꞌ! ");
INSERT INTO ztp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ngolo jwanꞌna, mdoxkwaꞌ náꞌ re chanꞌ náꞌ, nda náꞌ yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nde mdonke pla wes yez Cesarea xis náꞌ nde mbe' xa' ná' liz ti mbi' ndole Mnasón, xaꞌ lo xyon Chipre, xaꞌ jwan' ndala ndli lazo' xa' Jesús nde liz xaꞌ ya mbled náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Senꞌ mzin náꞌ yez Jerusalén, nale toz nzo lazoꞌ re wes mkaya' xaꞌ náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tedib wiz, re náꞌ Pab ngwatna náꞌ Jakob nde tya nzi re xaꞌ nak sinꞌ lo yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Senꞌ ngolo mni Pab dyux lo re wes, zya tolo mdej Pab kad thiba re jwanꞌ mbli Dios lo re xaꞌ naꞌnakta judí por sinꞌ jwanꞌ mketeli Pab. ");
INSERT INTO ztp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Senꞌ mbin re xaꞌ jwanꞌna, mbli naro xaꞌ Dios. Zyasa nchab xaꞌ lo Pab: —Wes, lu mne, xij reta xa' judí naꞌr mil xa' mbli lazoꞌ xaꞌ Jesús, nde reta xaꞌ ya mbez toz xa' ke nakin' xo'byek men ley chanꞌ Moisés. ");
INSERT INTO ztp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nde nchab xaꞌ ke ndloꞌa lo re men judí, re xaꞌ ta ngete tij sa naꞌxobyekta xaꞌ ley, nekla ke' xa' be' lad xinꞌ biꞌ xaꞌ nde nekla li xaꞌ re mod gox jwanꞌ nzino men. ");
INSERT INTO ztp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Le' naya cho kwan linꞌ? Tak lo nye re men ke mzin la ncheꞌ, zyaga dyop xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jwanꞌ nasa mas wen bli jwanꞌ reꞌ: Nzo tap xaꞌ bi xij naꞌ reꞌ, xaꞌ jwanꞌ ndablo li jwanꞌ mkeꞌyek xaꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Beꞌ xaꞌ, sa thipta wayak nambi re goꞌ nde lu kix sa choꞌ yisyek xaꞌ. Sa nye re men ke yalkwinꞌ re jwanꞌ ni xaꞌ xis la, cheꞌla no lu naxut ngetea, nxobyek la ley. ");
INSERT INTO ztp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Leꞌ re xaꞌ naꞌnakta judí, xaꞌ jwanꞌ ndli lazonꞌ Jesús, mtelꞌla náꞌ yeꞌs lo xaꞌ, jwanꞌ nchab, nandabloda kenap xaꞌ lo reta jwanꞌ reꞌ, benꞌta jwanꞌ ndablo li xaꞌ nak, naꞌwad xaꞌ re belꞌ jwanꞌ ngo lo mnab, nek ren, nek maꞌ nchaj we nde naꞌlid xa' re lo yalbew. ");
INSERT INTO ztp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Zyasa mbeꞌ Pab re mbiꞌ ya, nde tedib wiz ngwayak nambi re xaꞌ, zyaraꞌ ngwa xaꞌ yodoꞌ sa tej xaꞌ nyenꞌ cho wiz yoxoꞌb be' yolo ak nambi xaꞌ, sa kad tiba xaꞌ tayaꞌ xaꞌ jwanꞌ yon lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Senꞌ ndoyoxoꞌbla gaz wiz, pla xaꞌ judí, xaꞌ lo xyon Asia, senꞌ mbwiꞌ xaꞌ Pab ndo Pab yodoꞌ zya tolo mtoxol xaꞌ reta men nde mxen xaꞌ Pab, ");
INSERT INTO ztp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","nde ne mbrez xaꞌ, nchab xaꞌ: —¡Reta goꞌ men Israel karelka de' go'! Mbiꞌ reꞌ jwanꞌ ta ngete reta lad, ngete tej xaꞌ lo re men ke narax nzinꞌ las naꞌ, narax nak ley chanꞌ Moisés nde narax nzin' yodon' na, ndeno xaꞌ re men na'nakta judí yodoꞌ reꞌ, ngeli bew xaꞌ tenꞌ Nayon reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ta nchab xaꞌ, tak mbwiꞌla xaꞌ Pab len' yez Jerusalén kon Trófimo, xaꞌ yez Éfeso nde mbli xaꞌ xgab noga yodo' ngwano Pab xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Zyasa reta mayez ngok bxol nde mdyop xa' mxen xaꞌ Pab, ndoꞌbnyo xaꞌ Pab nde mbloꞌte xaꞌ Pab tenꞌ ndob yodoꞌ nde mtowꞌ xaꞌ ro yodoꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ncholaꞌs xaꞌ kuj xaꞌ Pab, per zyaga mbin mbol jwanꞌ nyebeꞌ lo ti mil sondad, ke reta men yez Jerusalén nzi yakbxol xa'. ");
INSERT INTO ztp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Zyaga mthop mbol reta sondad nde re xaꞌ nyebeꞌga lo sondad sa nda xaꞌ tenꞌ nzi yakbxol reta men. Senꞌ mbwiꞌ re men mzin mbol kon reta sondad mbol, zya mblaꞌ xaꞌ naꞌngintra' xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nde senꞌ mzin mbol, mnabeꞌ mbol lo sondad sa mxen xaꞌ Pab nde mbo xaꞌ Pab kon chop kaden; zyara' mnabdiꞌs mbol cho ta ngeyin xaꞌ ya nde cho kwan mbli xa'. ");
INSERT INTO ztp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per xij reta mena, cho xaꞌ mbez ti jwanꞌ nde cho xaꞌ mbez tedib jwanꞌ, ya naꞌyenta mbol nyebeꞌ jwanꞌ mbez re men, yaja mnabeꞌ mbol sa we sondad Pab ten' nzi sondad. ");
INSERT INTO ztp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Senꞌ ndozin re xaꞌ lo skaler tenꞌ nzi re sondad, tyaja mxo'b yen re sondad Pab, tak jwanꞌ toz naxol nchak reta men ncholaꞌs xaꞌ kuj xaꞌ Pab, ");
INSERT INTO ztp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","taja mbez reta men ndenke xaꞌ xisa nchab xaꞌ: —¡Bij go' xa'! ");
INSERT INTO ztp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Senꞌ ndoyoteno re sondad Pab lenꞌ tenꞌ nzi sondad, zya nchab Pab lo mbol nyebeꞌ: —¿Cho toyal todiꞌs na lud lo goꞌ? Leꞌ mbol nyebeꞌ mkab: —¿Cho nchak nia diꞌs gryeg? ");
INSERT INTO ztp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Cho na'nakta lu xaꞌ Egipto, xaꞌ ta mdobte yalbyo pola nde lad izyo bis mxonꞌno xaꞌ thap mil mbiꞌ jwanꞌ nchuj men? ");
INSERT INTO ztp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Zyasa nchab Pab lo xaꞌ: —Na nak merpa' ti mbiꞌ judí, las na nak yez Tarso, lo xyon Cilicia ti yez ro, jwanꞌ nasa nyaꞌb na loa, taꞌa diꞌs todiꞌs na lo re mayez. ");
INSERT INTO ztp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nde senꞌ mdaꞌ mbol nyebeꞌ diꞌs lo Pab, zya mdoli Pab lo skaler nde mtaꞌb yaꞌ Pab lo re mayez. Senꞌ xe mbre reta mayez, Pab mni diꞌs hebreo nde nchab Pab: ");
INSERT INTO ztp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Reta go' wes na nde xud na, ptonza goꞌ sa kab na lo goꞌ lo jwanꞌ ta ndlino goꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Senꞌ lo mbin re men ke di's hebreo mni Pab lo xa', zya masraꞌ mbre xe re xaꞌ. Nde nchab Pab lo xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Merpa' men judí nak na' nde yez Tarso ngol na, yez jwan' nax lo xyon Cilicia, per yez Jerusalén reꞌ mxyen na nde Gamaliel ngok xud te'd na, jwin' toz mblo' xa' lon jwan' xa nakpa ley chanꞌ re xaꞌ gox lonꞌ xaꞌ mbre pola. Thibla' nchal na nxobyek na Dios dib nzo lazo'n, ta xa ndliga re goꞌ ba naya. ");
INSERT INTO ztp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pola mchublan re men nzo lo Xned Jesucrist axta mbij na xaꞌ, mbiꞌ nde ngol mxen na xaꞌ nde mdayan xaꞌ sa ya xaꞌ lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mbol ngwleyꞌ ro nde re xaꞌ nak sinꞌ lo men judí mne xaꞌ jwanꞌ reꞌ, tak xaꞌ mdaꞌ yeꞌs lon senꞌ nakla di's yan yez Damásco yaxen na re men nzo tya, re men jwan' ndli lazonꞌ Jesucrist nde ye'dnon xaꞌ yez Jerusalén reꞌ sa kin men xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Jwanꞌ reꞌ ngotey laja ndon ned, ndozinla gax yez Damasco awizta ba xajta mbroꞌ ti xni toz lo beꞌ mblay dib tenꞌ ndon. ");
INSERT INTO ztp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nde ngob na izyo, na mbin na mni ti Xaꞌ lon, ne Xaꞌ: “Saulo, Saulo, ¿Cho kwan liy ngete chublaa na?” ");
INSERT INTO ztp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Zyasa mnabdiꞌs na lo Xaꞌ: “Cho goꞌ?” Leꞌ Xaꞌ mkab lon ne Xaꞌ: “Na nak Jesús Xaꞌ Nazaret, na ta ngete chublaa ba.” ");
INSERT INTO ztp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nde re xaꞌ jwanꞌ ndanon mbwiꞌpa xaꞌ xni nde mzyeb xaꞌ per naꞌngonta xaꞌ xkiꞌs Xaꞌ ta mni lon ya. ");
INSERT INTO ztp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nde mnabdiꞌs na lo Xa': “¿Kwan ndablo lin Xaꞌ Nyebeꞌ?” Leꞌ Xaꞌ Nyebeꞌ ne lon: “Ptolí nde waga yez Damasco, sa tya nye xaꞌ loa reta jwanꞌ ndablo lia.” ");
INSERT INTO ztp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Leꞌ na thiptane mkow ngud lon por xni jwanꞌ ta mblaya, yaja' re xaꞌ jwanꞌ ndanon mxen xaꞌ yaꞌn sa mzin na yez Damasco. ");
INSERT INTO ztp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Tya nzo ti mbiꞌ ndole Ananías, ti mbiꞌ gal' nde nxobyek toz xa' ley nde reta men judí nzo yez Damasco wen ni xaꞌ xis mbiꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mbiꞌ ya mbyeꞌd lon, mbike xaꞌ gax nde ne xaꞌ: “Wes Saulo, yoni ngud loa naya.” Nde zyaga ngoni ngud lon nde mbwiꞌn xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nde ne xaꞌ lon: “Dios ta ndli lazoꞌ re xaꞌ gox lonꞌ mbre pola, Dios ya mblí lu naya sa yoloa jwanꞌ ncholaꞌs Xa' nde wiꞌa Xaꞌ galꞌ sa gon la diꞌs ro Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tak lu ak mbiꞌ tej xkiꞌs Xaꞌ lo reta men, re jwanꞌ mbwiꞌa nde mbin la. ");
INSERT INTO ztp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nde naya, ¿Cho kwan ngembed la? Ptozaꞌ nde broꞌle, nde ptombi lazo'a lo re xken la, mna'ba lo le Xa'.” ");
INSERT INTO ztp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Nde jwanꞌ ngotey, senꞌ mberen yez Jerusalén, laj ndotodiꞌsnon Dios yodoꞌ, zya xaja men mzalꞌ lazonꞌba mbye'd ti jwan lon. ");
INSERT INTO ztp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nde mbwiꞌn Jesús, ne Xaꞌ lon: “Pkenka cha broꞌte yez Jerusalén, tak re men nzi ncheꞌ, naꞌtonzad xaꞌ xkiꞌs na jwanꞌ tej la.” ");
INSERT INTO ztp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Zyasa mkab na lo Xaꞌ nchab na: “Xaꞌ Nyebeꞌ, reta men mne mketeꞌn reta tenꞌ nzi re yo jwanꞌ ndyop re men judí, nde mben xaꞌ mke xaꞌ lizyiꞌb nde mdin na re xaꞌ ndli lazonꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nde senꞌ lo mbij men Xteb, xaꞌ jwanꞌ ndaꞌ kwent chanꞌ la, non mdo tya nde ndyen na senꞌ nguj Xteb, nde na mkenap xab re xaꞌ jwanꞌ mbij Xteb.” ");
INSERT INTO ztp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Leꞌ Jesús ne lon: “Waa, tak tij tel na lu, lo re xaꞌ naꞌnakta judí.” ");
INSERT INTO ztp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nde axta tyaja mbin xaꞌ xkiꞌs Pab, tolo ne mbrez reta xaꞌ, nchab xaꞌ: —Bij goꞌ mbiꞌ ba, naꞌnsal'ta xa' ban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nde axa mbez re men, taja mblobi xaꞌ re lar nzob xis xaꞌ nde ngobi xaꞌ yothiꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Leꞌ mbol nyebeꞌ, mnabeꞌ xaꞌ lo sondad sa mbeꞌ xaꞌ Pab tenꞌ nzi re sondad nde mnabeꞌ mbol mdin xaꞌ Pab sa koꞌro Pab nyenꞌ kwaꞌn liy sa taja mbez re men xis Pab. ");
INSERT INTO ztp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Senꞌ lo mdobola xaꞌ Pab, zyasa nchab Pab lo ti xaꞌ jwanꞌ nyebeꞌga lo re sondad ndo tya: —¿Cho toyal kin goꞌ ti xa' Rom, teꞌnye tera' zyal goꞌ cho yalke nchap xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Senꞌ mbin xaꞌ nyebeꞌ jwanꞌna, zya ngwatne xaꞌy lo mbol nyebeꞌ ro, nchab xaꞌ: —¿Cho kwan li goꞌ? Tak xaꞌ Rom nak mbiꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Zyasa ngwa mbol nyebeꞌ lo Pab nde nchab mbol: —¿Cho lí men Rom nak la? Leꞌ Pab mkab: —Liy. ");
INSERT INTO ztp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Leꞌ mbol nyebeꞌ nchab: —Na reꞌ, nap toz mbroꞌtoy lon sa ngok na men Rom. Pab nchab: —Le' na, ax ngol no nay. ");
INSERT INTO ztp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yaja re sondad ta nakwent kin Paba, senꞌ mbin xaꞌ jwanꞌna, tij mbike xaꞌ lo Pab nde no mbol nyebeꞌ, senꞌ mne mbol men Rom nak Pab, mzyeb mbol tak mdobo xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nde tedib wiz le' mbol nyebeꞌ nchola's nye xomodpa nak yalkeꞌ nkeꞌ re xaꞌ judí yek Pab, zyasa mnabe' mbol mxak xaꞌ kaden jwanꞌ nago Pab nde mnabeꞌ mbol mdyop re ngwleyꞌ ro nde reta xaꞌ nak sinꞌ. Zyasa ngwaxiꞌ xaꞌ Pab nde mbloꞌto xaꞌ Pab lo re xa' nzi tya. ");
INSERT INTO ztp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Zyasa xe mbwiꞌ Pab lo re xaꞌ nak sinꞌ nde nchab Pab: —Wes na, axta nawiz reꞌ tatka kon xgab nambi ndon lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Leꞌ Ananías mbol ngwleyꞌ ro, mnabeꞌ lo re xaꞌ nzi gax tya sa mdis xaꞌy ro Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Zyasa nchab Pab: —¡Dios keꞌy choa, xaꞌ kwinꞌ! Ndob la sa nyaꞌb la kwent lon xa ngeni ley nde leꞌga lu mdiꞌs la ley tak mnabeꞌa mdis xaꞌy ron. ");
INSERT INTO ztp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Leꞌ re xaꞌ nzi tya nchab lo Pab: —¿Cho kwan liy nixin la lo mbol ngwleyꞌ ro xaꞌ ndli sinꞌ lo Dios? ");
INSERT INTO ztp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Leꞌ Pab mkab: —Wesa, naꞌnyet na cho ngwleyꞌ ro nak xaꞌ; tak lo xkiꞌs Dios nchab: —Naꞌnixinta lu xis mdan lo yez la. ");
INSERT INTO ztp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Senꞌ mne Pab ke rol xaꞌ nzi tya nak saduceo nde rol xaꞌ nak fariseo, ne mni Pab lo re xaꞌ, nchab Pab: —Wesa, na nak fariseo xinꞌ ti xaꞌ fariseo, nde mbezke goꞌ lon tak ndli lazoꞌn ryoꞌxban re men nguj. ");
INSERT INTO ztp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Senꞌ ta nchab Pab, leꞌ re xaꞌ fariseo nde re xaꞌ saduceo tolo ngwa xa' kwent nde ngok rol xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tak re xaꞌ saduceo mbez naꞌryoꞌxbanta re men nguj nekla naꞌngenta re anj nde neka re xbi, mbay re xaꞌ fariseo ndli lazoꞌ xaꞌ reta jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nde anta che'pa mbez reta xaꞌ, zya mdoli pla xaꞌ fariseo xaꞌ nak maestr ndloꞌ ley xkiꞌs Dios, nchab xaꞌ: —Nek thib yalke naꞌngasalta náꞌ ndli mbiꞌ reꞌ, tak tez nzo cho xbi o anj mni lo xaꞌ, na'ke'd na' yalbyo kon Dios. ");
INSERT INTO ztp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nde jwanꞌ toz nzi yakbxol re xaꞌ, zyasa leꞌ mbol nyebeꞌ lo re sondad mzyeb xaꞌ yoloa naxguj xaꞌ Pab, zya mnabeꞌ xaꞌ mbyeꞌd pla sondad sa mblote xaꞌ Pab xija nde mbeꞌ xaꞌ Pab tenꞌ nzi re sondad. ");
INSERT INTO ztp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lo tedib yalꞌ, mbroꞌto Xa' Nyebe' lo Pab nde nchab Xa': —Blo ne lazoꞌa Pab, ta xa mdej la xkiꞌs na yez Jerusalén, tagaꞌ nakiꞌn tej lay yez Rom. ");
INSERT INTO ztp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Senꞌ mduxni tedib wiz zya mdyop pla xaꞌ judí, thita ngok diꞌs xaꞌ mxo'b xa' de xis xaꞌ mda' xa' xki's xa' na'wat xaꞌ neka gu xaꞌ nit axta kebeꞌ li xaꞌ gan gaj Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Masraꞌ ti choꞌ xaꞌ mkeꞌyek jwanꞌna, ");
INSERT INTO ztp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","re xaꞌ reꞌ ngwa lo re ngwleyꞌ jwanꞌ nyebeꞌ nde lo re xaꞌ nak sinꞌ lo men judí, nchab xaꞌ: —Reta náꞌ mxo'b de náꞌ xis náꞌ mdaꞌ náꞌ xkiꞌs náꞌ, ngenta kwan wa náꞌ, axta kebeꞌ li náꞌ gan gaj Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Leꞌ naya, re goꞌ kon re xaꞌ nak sinꞌ, mnaꞌb goꞌ lo mbol nyebeꞌ lo sondad sa yeꞌdno xaꞌ Pab lo goꞌ yeꞌ, benꞌta guz goꞌ lo xaꞌ, náꞌ ncholaꞌs jwin nye náꞌ xomodpa nak kwent chanꞌ Pab, nde leꞌ re náꞌ nzisaꞌa náꞌ ned sa kuj náꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Leꞌ mbyo xinꞌ ptanꞌ Pab, mbin mbyo ta ndyodiꞌs xaꞌ yogo'd xaꞌ ned, zya ngwa mbyo tenꞌ nzi re sondad nde nchab mbyoy lo Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Leꞌ Pab mbrez ti xaꞌ nyebeꞌ lo sondad, nde nchab Pab lo xaꞌ: —Beꞌ mbyo reꞌ lo mbol jwanꞌ nyebeꞌ lo re sondad, tak nakinꞌ toz tej mbyo ti jwanꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Zyasa ngwano xaꞌ mbyo lo mbol nyebeꞌ nde nchab xaꞌ: —Pab xaꞌ ta nge lizyiꞌb, mbrez xaꞌ na nde mnaꞌb xaꞌ lon sa ndenon mbyo reꞌ, tak ngeno mbyo ti jwanꞌ tej mbyo loa. ");
INSERT INTO ztp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Leꞌ mbol nyebeꞌ mxen xaꞌ yaꞌ mbyo, mbeꞌ xaꞌ mbyo tedib lad nde tya mnabdiꞌs xaꞌ lo mbyo, nchab xaꞌ: —¿Cho kwan ncholaꞌs la tej la lon? ");
INSERT INTO ztp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Leꞌ mbyo nchab: —Re xaꞌ judí thita ngok diꞌs xaꞌ sa yeꞌdnaꞌb xaꞌ lo goꞌ, ke yeꞌ we goꞌ Pab lo re xaꞌ nak sinꞌ, xajka men jwanꞌ jwin ncholaꞌs nye xomod nak yalke chanꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per naꞌlid lazoꞌ goꞌy, tak masraꞌ choꞌ xaꞌ nzisaꞌla towꞌ ned, nde mxo'b xa' de xis xaꞌ mdaꞌ xaꞌ xkiꞌs xaꞌ naꞌwad xaꞌ neka gu xaꞌ nit, axta kebeꞌ kuj xaꞌ Pab. Nde naya nzisaꞌa xaꞌ benꞌta ngembed xaꞌ nyenꞌ kwan gab goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Zyasa mbloned mbol mbyo ndyar nde mnabeꞌ mbol lor sa ngenta cho lo gab or jwanꞌ ngwatner lo mbol. ");
INSERT INTO ztp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Leꞌ mbol nyebeꞌ lo re sondad, mbrez xaꞌ chop sondad xaꞌ jwanꞌ nyebeꞌgaꞌ, sa nyabeꞌ xaꞌ, kwesaꞌ chop ayoꞌ sondad tye ni, songal nzo siꞌ sondad tyob way nde chop ayoꞌ sondad we yi'b nalé xinꞌ, sa ya xaꞌ yez Cesarea hor ye' yalꞌla, ");
INSERT INTO ztp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","nde mnabeꞌ xaꞌ ngoxab ti way tyob Pab sa naxuta we xaꞌ Pab lo Félix, xaꞌ nyebeꞌ ro. ");
INSERT INTO ztp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nde mkeꞌ xaꞌ ti yeꞌs jwanꞌ nchab: ");
INSERT INTO ztp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Na, Claudio Lisias, ngeke'n yeꞌs reꞌ loa Félix, xaꞌ nyebeꞌ ro, dyux nin loa. ");
INSERT INTO ztp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Re xaꞌ judí mxen xaꞌ mbiꞌ reꞌ nde ncholaꞌs xaꞌ kuj xaꞌ xaꞌ, per senꞌ mbin na xaꞌ Rom nak xaꞌ, zya ngwatolaꞌn xaꞌ kon re sondad na. ");
INSERT INTO ztp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nde ncholas na nyen cho yalke nchap xaꞌ sa mben xaꞌ lo re xaꞌ nak sinꞌ lo men judí. ");
INSERT INTO ztp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nde ngosi'b na, leꞌ yalke jwanꞌ nkeꞌ re men yek xaꞌ nak, leꞌga kwent chanꞌ ley jwanꞌ nzino xaꞌy nde naꞌnakte yalke jwanꞌ nzalꞌ gaj xaꞌ, o ya xaꞌ lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Per mbin na, leꞌ re xaꞌ judí ngok diꞌs xaꞌ kuj xaꞌ mbiꞌ reꞌ, jwanꞌ nasa zyaga mtel na xaꞌ loa nde gab na lo re men jwanꞌ nkeꞌ yalke yek xaꞌ, sa loa yatej xaꞌ nyenꞌ kwan nak yalke. Ba ndesalꞌ naꞌ.” ");
INSERT INTO ztp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Zyasa reta sondad mbli xaꞌy axa mnabeꞌ xaꞌ nyebeꞌy lo xaꞌ, yalꞌ mbeꞌ xaꞌ Pab nda xaꞌ yez Antípatris. ");
INSERT INTO ztp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nde tedib wiz leꞌ re sondad ta nda ni ya mbere xaꞌ tenꞌ nziga xaꞌ nde leꞌ re sondad ta ndob way ndanoga xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Senꞌ mzin xaꞌ yez Cesarea, mda'yaꞌ xaꞌ yeꞌs lo Félix xaꞌ nyebeꞌ ro nde tagaꞌ mda'yaꞌ xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Senꞌ ngolo mblab Félix yeꞌs, mnabdiꞌs xaꞌ cho yez nde Pab, sen' lo mne xaꞌ leꞌ Pab nak men Cilisia, ");
INSERT INTO ztp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nchab xaꞌ lo Pab: —Senꞌ yeꞌd re xaꞌ jwanꞌ nkeꞌ yalke yek la zyasa tej la lon xomod nak kwent chanꞌ la. Zyasa mnabeꞌ xaꞌ jwin kenap xaꞌ Pab tenꞌ ndob yolow chanꞌ Herodes. ");
INSERT INTO ztp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Senꞌ ngoxoꞌbla gayꞌ wiz, Ananías mbol ngwleyꞌ ro, kon pla xaꞌ nak sinꞌ lo men judí nde kon ti xaꞌ nchak ley ndole Tértulo. Re xaꞌ reꞌ mzin lo Félix xaꞌ nyebeꞌ ro, sa keꞌ xaꞌ yalke yek Pab. ");
INSERT INTO ztp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Senꞌ mbroꞌto Pab, leꞌ Tértulo mdobte mkeꞌ xaꞌ yalke yek Pab, nde nchab xaꞌ: —Lu Felix, xa' ntak toz, tak lu ndli sa nabeꞌz nzi náꞌ nde naꞌr toz jwanꞌ nawe ndoyaka lo yez por yalnchak chanꞌ la. ");
INSERT INTO ztp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Lu xa' ntak toz Felix, reta jwanꞌ reꞌ oneja plo ngete náꞌ thiblaꞌ nkayaꞌ náꞌy jwanꞌ nasa ndaꞌ náꞌ dyux loa. ");
INSERT INTO ztp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Par naꞌkibta náꞌ bro tyemp loa, nyaꞌb na gon la lud xkiꞌs náꞌ ta nagu'sla's nak la. ");
INSERT INTO ztp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mne náꞌ mbiꞌ reꞌ nak xaja bzin, tak reta tenꞌ ngete xaꞌ napta byo nkwanꞌ xaꞌ xij re men judí, nde xa' nyebeꞌ lo jwan' kwin' ta mbez ndli lazon' Jesús Xa' Nazaret. ");
INSERT INTO ztp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nde noga nchola's xa' li bew xa' ten' nak yodo' nayon; jwanꞌ nasa mxen náꞌ xaꞌ, nde ncholas náꞌ nyaꞌb náꞌ kwent lo xaꞌ jwanꞌ xa ngeni ley chanꞌ náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Per xija mbla mbol Lisia xaꞌ nyebeꞌ lo re soldad, kon gob mkib xaꞌ Pab lo yaꞌ náꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","nde mnabeꞌ xaꞌ, ke re men jwanꞌ ngeno yalke xis mbiꞌ reꞌ yeꞌd tej xaꞌy loa. Leꞌga lu mnaꞌb kwent lo xaꞌ sa nyea ke liga nak xaꞌ re jwanꞌ ta ndej náꞌ loa reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nde reta xaꞌ judí jwanꞌ nzi tya, nchab xaꞌ: Liy, ta naka. ");
INSERT INTO ztp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Zyasa Félix xaꞌ nyebeꞌ ro, mtaꞌb xaꞌ yaꞌ xaꞌ lo Pab sa kab Pab nde nchab Pab: —Mnen ndalinꞌ la nak la xaꞌ nyebeꞌ lo xyon reꞌ, jwanꞌ nasa dib nzo lazoꞌn kab na lo yalke jwanꞌ nkeꞌ xaꞌ yek na. ");
INSERT INTO ztp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Leꞌga lu toyal koxyoa cho li jwanꞌ reꞌ, tak naya tera' yoxoꞌb tib senka wiz senꞌ ngwa li naron Dios yez Jerusalén, ");
INSERT INTO ztp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","naꞌngosibta xaꞌ na ndoyan di's kon nek tib men, nekla ngete tobxol na re men, xa nak yodoꞌ, nekla re lenꞌ yo tenꞌ ndyop re men judí o nekla dib lenꞌ yez. ");
INSERT INTO ztp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Re men reꞌ, ngenta kwan tob ro xaꞌ sa tej xa' loa ke li re yalke jwanꞌ nkeꞌ xaꞌ yek na. ");
INSERT INTO ztp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per jwanꞌ goꞌron loa nak, na ndli sin' lo Dios ta ndli lazoꞌ re xaꞌ gox lon ngo pola jwan' xa nak Ned Kub ta ni xaꞌ yalkwinꞌna, tak ndli lazoꞌn re jwanꞌ ngeni ley, nde ndli lazo'n jwanꞌ mkeꞌ re profet. ");
INSERT INTO ztp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nde jwanꞌ ngembed na lo Dios, jwanꞌ naga ngembed re xaꞌ ba, leꞌ Dios koꞌxban reta xaꞌ nguj, xaꞌ mbli jwanꞌ galꞌ nde re xaꞌ mbli jwanꞌ naꞌgalꞌta. ");
INSERT INTO ztp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jwanꞌ nasa thiblaꞌ nchal na tyonon ti xgab nambi lo Dios nde lo re men. ");
INSERT INTO ztp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Ngoxo'bla pla linꞌ ta mketeꞌn xaꞌla re yez sa mberen ten' nak las na, ndanon ti gon lo re men nalat ndyak nde ndanon jwanꞌ yon lo Dios. ");
INSERT INTO ztp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Jwanꞌna ndolin yodoꞌ, lo mzin pla xaꞌ judí mbroꞌ Asia, mne xaꞌ leꞌn ngeli jwanꞌ nyebeꞌ ley chanꞌ Moisés sa ak nambin lo Dios, naꞌnakta na nzino bro toz men nekla ngetobxol na men. ");
INSERT INTO ztp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Re xaꞌ ya ndablo ndro'to loa reꞌ, sa ndej xaꞌ nyenꞌ kwan liy sa mxen xaꞌ na, tezka ngeno xaꞌ cho yalke xis na. ");
INSERT INTO ztp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O le'ga re xaꞌ ta nzi ncheꞌ, tej xaꞌ nyenꞌ kwan jwanꞌ narax mbwiꞌ xaꞌ mblin lo ta mbro'tono xaꞌ na lo men nak sinꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","o nzo plo, lo ta ne mbrez na xij re men, nchab na: “cho nkeꞌ goꞌ yalke yek na tak ndli lazoꞌn ryo'xban re men nguja.” ");
INSERT INTO ztp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Senꞌ mbin Félix jwanꞌ reꞌ, mto xaꞌ tedib beꞌ, tak mne wen la xaꞌ xomod nak xned Jesucrist, zyasa nchab Félix lo xaꞌ: —Senꞌ yeꞌd Lisias mbol nyebeꞌ lo soldad, zyasa wi'n xomodpa' nak chanꞌ goꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Zyasa mnabeꞌ Félix lo xaꞌ nyebeꞌ lo re soldad sa keꞌ lizyiꞌb xaꞌ Pab nde naꞌnkad xaꞌ diꞌs lo re men nzal'ta Pab, tez nzo cho ncholaꞌs laꞌsto xaꞌ Pab o yatna xaꞌ Pab, toyal li xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mbridndaꞌb pla wiz, mbyeꞌdno Félix ngol xaꞌ Drusil ti ngol nak judí. Zya mnabeꞌ Félix ngwayoꞌ Pab, sa gon xaꞌ nyen' xomod nak li lazoꞌ men Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per senꞌ mdej Pab nakinꞌ galꞌ ban men, ndablo leꞌga men kwek lazoꞌ men, nde tzin ti wiz tayaꞌ men kwent lo Dios, zyasa mzyeb Félix nde nchab xaꞌ lo Pab: —Bya naya, tedib wiz senꞌ yena lon zyasa bez na lu. ");
INSERT INTO ztp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Noga ncholaꞌs Félix ko Pab tmi yaꞌ Félix sa la' Félix Pab; jwanꞌ nasa naꞌr gob mbrez xaꞌ Pab nde mdodiꞌsno xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Senꞌ ngoxoꞌb chop linꞌ, mdayaꞌ Félix sinꞌ lo tedib xaꞌ kub ndole Porcio Festo. Nde ncholaꞌs Félix wen yanꞌ xaꞌ lo re men judí, yaja tata mtanꞌ xaꞌ Pab lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Sen' ngok son wiz mblatob Festo, zya mbroꞌ xa' Cesarea ndya xaꞌ yez Jerusalén. ");
INSERT INTO ztp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tya sa, re xaꞌ nak ngwleyꞌ lnyebeꞌ kon re xaꞌ nak sinꞌ lo men judí, mbike xaꞌ lo Festo sa mkeꞌ xaꞌ yalke yek Pab. ");
INSERT INTO ztp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Kon diꞌs wen mnaꞌb xaꞌ lo Festo, sa nyebeꞌ Festo yeꞌd Pab yez Jerusalén. Tak mdodi'sla xa' ko xaꞌ men ned sa tya kuj xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Le' Festo mkab ke Pab nge lizyiꞌb Cesarea, nde lenꞌ tiplata wiz yub Festo bere tya. ");
INSERT INTO ztp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nde nchab Festo lo xa': —Jwan' nasa, re go' ta nak sin', tye goꞌ ndanꞌ yez Cesarea sa tez liga nchap mbiꞌ ya yalke, tya tej goꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ben' xonta wiz o siꞌ wiz mbled Festo yez Jerusalén, nde mbere Festo Cesarea. Tedib wiz mdob Festo yolow nde mnabeꞌ Festo ngwaxi' xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Senꞌ ngoteno xa' Pab, zya mbike gax re xaꞌ judí, re xaꞌ mbroꞌ yez Jerusalén nde naꞌr toz re yalke nabiꞌ mkeꞌ xaꞌ yek Pab, per nekthiba na'ndloda ke li jwan' ndej xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Zyasa mkab Pab lo re yalke ta mke' xa' yek Pab, nchab Pab: —Ngen cho yalke mblin lo ley chanꞌ judí, nek lo yodoꞌ nde neka lo César xaꞌ nyebeꞌ Rom. ");
INSERT INTO ztp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Le' Festo ncholaꞌs wen yanꞌ xaꞌ lo re men judí, sa mkab xaꞌ lo Pab, nchab xaꞌ: —¿Cho ncholaꞌs la yap la Jerusalén, sa tya nyaꞌb na kwent loa? ");
INSERT INTO ztp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Leꞌ Pab mkab lo xa': —Tenꞌ nyebeꞌ César ndoa na, nde ncheꞌ jwan' ndablo nya'b xaꞌ kwent lon. Tak mnela lu, nek thib yalke namblit na lo re xaꞌ judí. ");
INSERT INTO ztp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Tak tez mblin yalke jwanꞌ ndablo gaj na, ngen kwan liy gaj na; per tez naꞌlida re yalke jwanꞌ nkeꞌ xaꞌ yek na, ngen cho tayaꞌ na lo yaꞌ re xaꞌ judí. Jwanꞌ nasa nyaꞌb na, César nyaꞌb kwent lon. ");
INSERT INTO ztp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Zyasa mdodiꞌsno Festo re xaꞌ nak sinꞌ nzi tya, nde nchab Festo lo Pab: —César nya'b kwent loa nchola's la, lo xa' yaa sa. ");
INSERT INTO ztp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mbrid pla wiz, rey Agripa kon Berenis mbyeꞌd xaꞌ yez Cesarea sa mni xaꞌ dyux lo Festo. ");
INSERT INTO ztp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nde tya mbre xaꞌ naꞌr wiz, zyasa mdej Festo kwent chanꞌ Pab lo rey, nchab Festo: —Ncheꞌ mblaꞌ Félix tib mbiꞌ nge lizyiꞌb, ");
INSERT INTO ztp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","tak senꞌ ngwan yez Jerusalén, zyasa re xaꞌ nak ngwleyꞌ nyebeꞌ nde re xaꞌ nak sinꞌ lo men judí ngwanaꞌb xaꞌ lon sa gaj mbiꞌ ta nge lizyiꞌb reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per mkab na lo xaꞌ, nchab na, cheꞌmod nak ley Rom, na'toyalta nyebeꞌn gaj xaꞌ tata, nerla ndablo ndo xaꞌ jwanꞌ nchap yalke nde nzi xaꞌ jwanꞌ nkeꞌ yalke yek xaꞌ, sa tya tej xaꞌ nyenꞌ kwan nak yalke, nde xaꞌ jwanꞌ nchap yalke toyal kab xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Jwanꞌ nasa, senꞌ ngolo mbye'd re xaꞌ lon, na'mbleta na na'r wiz, zyaga tedib wiz seba mdob na yolow, nde mnabeꞌn ngwaxiꞌ xaꞌ Pab lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Senꞌ nzila re xaꞌ jwanꞌ mdej kwan nak yalke, per naꞌndejta xaꞌ nek tib yalke jwanꞌ mblin xgab. ");
INSERT INTO ztp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Cheꞌla yalke jwanꞌ nkeꞌ xaꞌ yek Pab nak, napta kwent chanꞌ re jwanꞌ ndli lazoꞌ xaꞌy, nde ndej xaꞌ ti mbiꞌ ndole Jesús, Xaꞌ ngujla nde leꞌ Pab mbez naban Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nde naꞌnyet na xomod li men ti jwanꞌ ta naka, jwanꞌ nasa mna'bdiꞌs na lo Pab cho ncholaꞌs xaꞌ ya xaꞌ yez Jerusalén sa tya tayaꞌ xaꞌ kwent. ");
INSERT INTO ztp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Leꞌ Pab mnaꞌbka, César nyaꞌb kwent lo xaꞌ, jwanꞌ nasa mnabeꞌn take xaꞌ lizyiꞌb axta kebeꞌ tel na xaꞌ lo César. ");
INSERT INTO ztp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Zyasa nchab rey Agripa lo Festo: —Non ncholaꞌs gon xkiꞌs mbiꞌ ba. Leꞌ Festo mkab: —Yeꞌ sa gon la xkiꞌs xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tedib wiz, senꞌ mbroꞌto Agripa kon Berenice nyaga ndokwaꞌ xaꞌ, nde senꞌ ngote xaꞌ lenꞌ yolow kon re xaꞌ nyebeꞌ lo sondad nde re xaꞌ ro lo yez, zya mnabeꞌ Festo ngwaxiꞌ xaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nde nchab Festo: —Rey Agripa nde reta goꞌ ta nzi ncheꞌ, bwiꞌ goꞌ, mbiꞌ ya jwanꞌ reꞌ, reta men judí, xaꞌ yez Jerusalén nde re men ncheꞌ, ndetej xaꞌ yalke chanꞌ mbiꞌ reꞌ lon, nde taja nyaꞌb xaꞌ naꞌndablotra' ban mbiꞌ re'. ");
INSERT INTO ztp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per ngwiꞌn nangenta nek tib yalke jwanꞌ nsalꞌ gaj xaꞌ, nde leꞌga xaꞌ mnaꞌb ya xaꞌ lo César, sa César nyaꞌb kwent lo xaꞌ, jwanꞌ nasa tya tel na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tak naꞌngenta kwan keꞌn lo yeꞌs, tel na lo César xaꞌ nyebeꞌ lon, jwanꞌ nasa lo goꞌ mblo'ton xaꞌ ncheꞌ, loa rey Agripa, senꞌ mne mna'bdiꞌs goꞌ lo xaꞌ, sa zyal na jwanꞌ keꞌn lo yeꞌs. ");
INSERT INTO ztp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tak ndyak na, nawentay tel na ti xaꞌ nge lizyiꞌb lo César, nde na'tejta na cho kwan nak yalke nchap xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Zyasa nchab rey Agripa lo Pab: —Toyal kab la sa laa lazo'a. Le' Pab mblen yan' nde mkab Pab lo xa': ");
INSERT INTO ztp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Rey Agripa, nale toz nzo lazo'n toyal todiꞌs na loa naya, kab na lo yalke jwanꞌ nkeꞌ re xaꞌ judí yek na. ");
INSERT INTO ztp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tak lu nzoloa reta kostumbr chanꞌ xaꞌ judí nde mnea jwanꞌ ta ncha náꞌ di's, jwanꞌ nasa nyaꞌb na loa, yap lazoꞌa gon la jwanꞌ tej na. ");
INSERT INTO ztp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Axta lo yen' na, reta xaꞌ judí mne xaꞌ xomod mban na xij xaꞌ, tenꞌ nak laz na nde yez Jerusalén, ");
INSERT INTO ztp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","noga mnela xa' nde toyal tej xa' ke axta yen' na nakla na men fariseo, tak re men fariseo nyebe' toz xaꞌ xo'byek men ley chanꞌ Moises. ");
INSERT INTO ztp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nde naya, tak ngembed na jwanꞌ mkeꞌyek Dios lo re xaꞌ gox lonꞌ xaꞌ mbre pola, jwanꞌna nak yalke mbrez xaꞌ na ndon ncheꞌ sa nyaꞌb xaꞌ kwent lon. ");
INSERT INTO ztp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nde re thibsen xaꞌ jwanꞌ nde lo bin Israel, ngembed xaꞌ sa gal yaꞌ xaꞌ jwanꞌ mkeꞌyek Dios, jwanꞌ nasa yalꞌ nde ndlyabe nzi li xaꞌ sinꞌ lo Dios nde jwanꞌ naga ngembed na. Rey Agripa, jwanꞌna nak yalke nkeꞌ re xaꞌ judí yek na. ");
INSERT INTO ztp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¡Mbay! ¿Cho kwan liy sa naꞌlid lazoꞌ goꞌ ngoꞌxban Dios re men nguj sa? ");
INSERT INTO ztp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Pola liga mblin xgab, rsin na nak luꞌx na re men ta ndli lazonꞌ Jesús Xaꞌ Nazaret, ");
INSERT INTO ztp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","jwanꞌna mblin yez Jerusalén. Kon yalnyebeꞌ chanꞌ re ngwleyꞌ nyebeꞌ, mkeꞌ lizyiꞌb na bro toz xaꞌ ndli lazonꞌ Jesús, nde senꞌ mbij men xaꞌ, non mda xki's na. ");
INSERT INTO ztp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nde nar toz gob ngwan plo ndob re yo tenꞌ ndyop men Israel, tya ntotin xaꞌ axta kebeꞌ ni xin xaꞌ xis Jesús. Ngiꞌnotin na re xaꞌ, taja mketeꞌnkeꞌn xis xaꞌ axta re yez tij tenꞌ naꞌnakta laz naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Jwanꞌna ngete lin, senꞌ ndan yez Damasco kon yalnyebeꞌ chanꞌ re ngwleyꞌ nyebeꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","nde jwanꞌ nin lo goꞌ Rey, lo ndon ned nde rolja wiza mbwiꞌn ti xni toz mbroꞌ lo beꞌ mas naro xniy ke lo xni wiz, mblay dib ten' ndon nde dib ten' ndo re xaꞌ jwanꞌ ndanon. ");
INSERT INTO ztp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Senꞌ ngob re náꞌ izyo, zya mbin na mni ti Xaꞌ lon kon diꞌs hebreo, ne xaꞌ: “Saulo, Saulo, ¿Cho kwaꞌn liy ngetechoblaa na? Leꞌga loa nkwanꞌ la mas yalti, ta xa ndli ngon sen' nkeꞌni ma' xi ya nalé.” ");
INSERT INTO ztp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Zyasa nchab na: “¿Cho goꞌ Xaꞌ Nyebeꞌ?” Leꞌ Xaꞌ Nyebeꞌ ne lon: “Na nak Jesús, Xaꞌ ta ngetechoblaa ba. ");
INSERT INTO ztp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Goche nde btoliꞌ, tak jwanꞌ reꞌ ndli sa mbroꞌton loa, sa tob na lu lia sinꞌ lon nde tej la lo men jwanꞌ mbwiꞌa nde re jwanꞌ nara loꞌn loa. ");
INSERT INTO ztp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Tolaꞌn la lo yaꞌ re xaꞌ judí nde re xaꞌ naꞌnakta judí tak lo re xaꞌ ya tel na lu, ");
INSERT INTO ztp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","sa xalꞌ la ngud lo re men, ryoꞌ xaꞌ lo yalꞌkow sa yeꞌd xaꞌ lo xni, nde ryoꞌ xaꞌ lo yalne chanꞌ maxuꞌ sa yeꞌd xaꞌ lo Dios; nde lo lipa lazoꞌ xaꞌ na dyonꞌ reta xken xaꞌ, nde kayaꞌ xaꞌ jwanꞌ nkayaꞌ re men nayon lo Dios.” ");
INSERT INTO ztp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Jwanꞌ nasa, rey Agripa, naꞌndlit na yalneyek lo diꞌs ta mbin na mbroꞌ lo beꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nerla mdobten mdej na lo re men yez Damasco, yez Jerusalén nde dib lo xyon Judea nde lo re men naꞌnakta judí, mdej na lo xaꞌ nakinꞌ laꞌ xaꞌ re jwanꞌ narax ndli xaꞌ nde bere xaꞌ lo Dios nde li xaꞌ jwanꞌ wen sa loꞌ liga mblaꞌ xaꞌ re jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nde jwanꞌ nasa re xaꞌ judí, mxen xaꞌ na tenꞌ ndob yodoꞌ nde ncholaꞌs xaꞌ kuj xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per Dios ndlaꞌsto Xaꞌ na jwanꞌ nasa benꞌ ndon axta naya, ndej na xkiꞌs Jesucrist lo re men ngeno yalnyebeꞌ nde lo re men naꞌngenode, naꞌndlot na xaꞌla jwanꞌ, na ndloꞌ re jwanꞌ mdej re xaꞌ ta mbyeꞌd taꞌ xkiꞌs Dios pola nde jwanꞌ mdej Moisés re jwanꞌ ta mdej xaꞌ ndablo ak. ");
INSERT INTO ztp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Leꞌ Crist ndablo ridka re yalti, nde Xaꞌ ak Xaꞌ ner jwanꞌ ryoꞌxban xij re xaꞌ nguj, nde ak Xaꞌ xni lo re men yez Israel nde lo re men naꞌnakta judí. ");
INSERT INTO ztp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Laj benꞌ ndokab Pab lo re yalke jwan' nke' xa' yek Pab, zya ne mbrez Festo lo Pab: —¡Ngosaꞌ yek la Pab, nteꞌd toz la jwanꞌ nasa mtosaꞌy yek la. ");
INSERT INTO ztp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Leꞌ Pab nchab: —Naꞌngosaꞌda yek na, Festo xa' nyebe' ro, cheꞌla diꞌs lipaꞌ nde diꞌs galꞌ ta ndotej na. ");
INSERT INTO ztp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nde rey Agripa mne xaꞌ reta jwanꞌ reꞌ, jwanꞌ nasa ncheꞌ ndowiꞌ xaꞌ dib xla's ndotej nay; tak mnepa na ke no xa' mne xaꞌ reta jwanꞌ reꞌ, tak re jwanꞌ reꞌ naꞌngoktay tenꞌ nagaꞌs. ");
INSERT INTO ztp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Rey Agripa, ¿cho ndli lazoꞌa jwan' mdej re profet? Na mne ke ndli lazoꞌa ley. ");
INSERT INTO ztp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Zyasa rey Agripa nchab lo Pab: —¿Cho yapa lud tira se ndyak la koa yek na sa li lazoꞌn Jesús? ");
INSERT INTO ztp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Leꞌ Pab nchab: —Tenye luda o broy, Dios nchola's ke naꞌnakta benꞌta lu li lazonꞌ Jesús noga re xaꞌ ta nzi yon xkiꞌs na nayay, ak xaꞌ xaja na reꞌ, per naꞌnakte kon kaden reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Senꞌ ngolo ta nchab Pab, zya ngotoli rey, ngotoli xaꞌ nyebeꞌ lo re yez, ngotoli Berenis nde ngotoli re men jwanꞌ nzino xaꞌ tya. ");
INSERT INTO ztp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nde senꞌ nda xaꞌ xaꞌta tedib lad zya mdodiꞌs re xaꞌ, nchab xaꞌ: —Nekthib yalke naꞌnchapta mbiꞌ reꞌ sa gaj xaꞌ nde nekla nsalꞌ xaꞌ ke xaꞌ lizyiꞌb. ");
INSERT INTO ztp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nde nchab Agripa lo Festo: —Ndoyal ndroꞌ mbiꞌ reꞌ lizyiꞌb tez naꞌnaꞌbta xaꞌ ya xaꞌ lo César. ");
INSERT INTO ztp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Senꞌ mbyanꞌdiꞌs la xaꞌ sa telꞌ xaꞌ náꞌ lo bark par Italia, zyasa mxen xaꞌ Pab nde kon tipla xaꞌ jwanꞌ nge lizyiꞌb sa mdayaꞌ xaꞌ xaꞌ lo Julio, xaꞌ nyebeꞌ lo re sondad chanꞌ August. ");
INSERT INTO ztp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nde ngwap náꞌ lo ti bark chanꞌ yez Adramitio, bark ya ndriꞌd reta yez jwanꞌ nzi ro nittoꞌ lo xyon Asia nde noga Aristarco ndano náꞌ, ti mbiꞌ yez Tesalónica lo xyon Macedon. ");
INSERT INTO ztp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tedib wiz mzin náꞌ ro nit yez Sidón, leꞌ Julio wen mbli xaꞌ lo Pab, mdaꞌ xaꞌ diꞌs ngwatwiꞌ Pab re men nsalꞌta Pab nde re xaꞌ ya mblasto xaꞌ Pab lo re jwanꞌ nakinꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mbroꞌ náꞌ yez Sidón mxen náꞌ bark nda náꞌ, mbri'd ná' gax lo xyon Chipre ten' na'ngenta mbi ntow' lo ná'. ");
INSERT INTO ztp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nde mbri'd náꞌ ngoꞌ lo xyon Cilisia nde lo xyon Panfilia, tya mzin náꞌ yez ndole Mira lo xyon Licia. ");
INSERT INTO ztp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Leꞌ xaꞌ nyebeꞌ lo sondad ngosiꞌb xaꞌ ti bark chanꞌ xa' yez Alejandri, jwanꞌ nda lo xyon Italia, nde mxap xaꞌ náꞌ lo bark ya. ");
INSERT INTO ztp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nar wiz mdo náꞌ lo nit tak sowꞌ nda bark nde nen toz mzin náꞌ ngoꞌ lo yez Gnido, tak naꞌtaꞌda mbi diꞌs tye bark, zyasa mbyek náꞌ cho lo xyon Creta, ngoꞌ lo yez Salmón. ");
INSERT INTO ztp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nde ne toz nde náꞌ dib gax ro nit, zyara' mzin náꞌ yez ndole Wen Puert, gax cho yez Lasea. ");
INSERT INTO ztp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tak jwanꞌ tozla mbriꞌd beꞌ ndo náꞌ lo nit, nde ndyagaxla beꞌ nxyoꞌb mbi nde yi, nathoz nzo lo nit par tye bark, tak mbri'd la be' ndyon' xken men, jwanꞌ nasa mtoni Pab re xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","nchab Pab lo xaꞌ: —Reta goꞌ men biꞌ, ngwiꞌn nathoz nzo lo nit ta ndanꞌ naya, nzo ryes lux bark, lux re jwanꞌ ndanoy nde axta naꞌ nzo ryes lux naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Leꞌ xaꞌ nyebeꞌ lo sondad, naꞌngonta xaꞌ diꞌs ro Pab, cheꞌla mas mbin xa' xkiꞌs xaꞌ ta ntoteꞌ bark nde xaꞌ nak xwanꞌ bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nde ro nit tenꞌ nzi xaꞌ naꞌwenta nak tya par yan' xa' dib be' nxyob yop, jwanꞌ nasa re xaꞌ mbli xgab ndablo ryoꞌ xaꞌ tya, sa nyenꞌ cho tli xaꞌ gan sin xaꞌ yez Fenice, ro nittoꞌ lo xyon Creta, tenꞌ ndlo' lad la nde ga'p nde tya rid xaꞌ beꞌ nxyoꞌb yop. ");
INSERT INTO ztp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nde mbli xaꞌ xgab tli xaꞌ gan nda xaꞌ, tak anta naguꞌs nxyoꞌb mbi jwan' ndryo' lad la, zyasa mxap xaꞌ re yiꞌb jwanꞌ ndyenkeꞌ bark nde nda xaꞌ thita gax ro nittoꞌ dib ro xyon Creta. ");
INSERT INTO ztp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per ludla ndatey mbroꞌ ti mbi toz lad ga'p ndole Euroclidón mdina bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nde mdobte mchep mbi bark, yaja naꞌndlit náꞌ gan ngoneda, mdaꞌ náꞌ diꞌs mbe' mbi bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nde mbrid náꞌ axis ti izyo lud jwan' naxꞌ xtowꞌ nittoꞌ ndole Clauda tenꞌ ngentozta mbi, nde nen toz sa mbli náꞌ gan mxap náꞌ lo bark kano lud jwanꞌ ndlyaꞌ men. ");
INSERT INTO ztp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Senꞌ mne mxap náꞌy lo bark, zyasa mbo xaꞌ dib cho bark sa ne naka nde noga mzyeb xaꞌ yotob bark lo yux tenꞌ ndole Sirte, zyasa mbla xaꞌ re lar jwanꞌ ndaꞌb lo bark sa mdaꞌ xaꞌ diꞌs mchep mbi bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nde tedib wiz, masraꞌ mbryo mbi, yaja mdobte mblobi xaꞌ re jwanꞌ nzo lo bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nde senꞌ ngok mbyon wiz, lega re náꞌ mblobi náꞌ re jwanꞌ ndli rsinꞌ bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nde naꞌr wiz naꞌndlada be nekla ndloꞌ re mbel nzi lo beꞌ, nde mxyoꞌb toz mbi taja mdin mbi náꞌ, naꞌngebetra náꞌ lya' náꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Naꞌrla wiz mbriꞌd teraꞌ wa náꞌ, zyasa mdoli Pab xtowꞌ re xaꞌ, nde nchab Pab: —Reta goꞌ mbiꞌ, tez ngaka ngon goꞌ diꞌs ron naꞌndroꞌd naꞌ yez Creta, naꞌndrita naꞌ yalti reꞌ nde ngenta kwan tyak naꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per naya, nin lo goꞌ, blo ne lazoꞌ goꞌ, tak nek thib naꞌ naꞌluxta, benꞌta bark lux. ");
INSERT INTO ztp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Tak yalꞌla mbroꞌto ti anj chanꞌ Dios lon, Dios ta nak xwan' na nde lo Xaꞌ ta ndlin sinꞌ, ");
INSERT INTO ztp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","anj ya ne lon: “Pab, naꞌzyebta lu tak nakinꞌka sin la lo César xaꞌ nyebeꞌ Rom, nde por lu sa lyaꞌ re xaꞌ ta nzo lo bark.” ");
INSERT INTO ztp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Jwanꞌ nasa nin lo re goꞌ, blo ne lazoꞌ goꞌ, tak na, ndli lazoꞌn Dios, ta xa ne Xaꞌ lon ta aka. ");
INSERT INTO ztp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per te'nyega, nakin'ka yan' na' ti ten' nax izyo biz xtow' nittoꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Senꞌ ngoxoꞌb siꞌda yalꞌ ndochep mbi náꞌ lo nit, zya mzin náꞌ nittoꞌ tenꞌ ndole Adriático nde rolja yalꞌ re xaꞌ jwanꞌ ntoteꞌ bark mbli beꞌ xaꞌ gaxla nde izyo biz. ");
INSERT INTO ztp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Zyasa mchiꞌx xaꞌ nyenꞌ plopa naꞌs nit nde naꞌsa galbsiꞌ xop metr, zya mde bark tud nde bere mchiꞌx xaꞌy tedib gob nde tya naꞌs galbwaz metr. ");
INSERT INTO ztp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Zyasa mzyeb xaꞌ tak nzo ryes yodinꞌ xanꞌ bark xis ke, yaja xanꞌ bark mkenga xaꞌ thap yiꞌb jwanꞌ tyenkeꞌ bark nde taja ngen lazoꞌ xaꞌ tyuxni. ");
INSERT INTO ztp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Zyasa re xaꞌ ta ntoteꞌ bark ncholaꞌs xaꞌ xonꞌ xaꞌ nde mxen xaꞌ kano jwanꞌ ndlyaꞌ men sa mxoꞌb xaꞌy lo nit, mbli xa' xaga ndli men ta keꞌnga re yiꞌb jwanꞌ ndyenkeꞌ bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Zyasa nchab Pab lo re sondad kon xaꞌ jwanꞌ nyebeꞌ lo xaꞌ: —Tez xonꞌ re xaꞌ reꞌ, pa li goꞌ gan lyaꞌ goꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Zyasa mchoꞌ sondad doꞌ jwanꞌ ndenkeꞌ kano lud ta lyaꞌ men nde mblaꞌ xaꞌy nday lo nit. ");
INSERT INTO ztp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Senꞌ ndetuxni, zya mbrez Pab yek re xaꞌ sa wa xaꞌ, nde nchab Pab lo xaꞌ: —Ndatela siꞌda wiz taja ndli toz go' xgab nde naꞌnchad goꞌ nek lud jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Jwanꞌ nasa, nyaꞌb na lo goꞌ, bda goꞌ lud sa nawe yo lazoꞌ goꞌ, tak nek thib yisyek goꞌ nde nek thib goꞌ naꞌluxta. ");
INSERT INTO ztp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Senꞌ ngolo mni Pab lo xaꞌ, zya mxen Pab pan, nzi wiꞌ re xaꞌ mdaꞌ Pab dyux lo Dios, mblirol Pab pan nde tolo mdobte mda Pab. ");
INSERT INTO ztp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Zyasa reta xaꞌ ngone lazoꞌ xaꞌ nde tolo mda xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Lo reta náꞌ jwanꞌ nzo lo bark, nak náꞌ ti chop ayoꞌ nzo songal nzo sinꞌ thib men. ");
INSERT INTO ztp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Senꞌ ngolo mda re xaꞌ kebeꞌ mse xaꞌ, zya mblobi xaꞌ re trig lo nittoꞌ sa mxyax bark. ");
INSERT INTO ztp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Senꞌ mduxni, re xaꞌ ta ntoteꞌ bark naꞌngyolod xaꞌ tenꞌ nda xaꞌ, per ngoni lo xaꞌ ti tenꞌ nak ro nit lad lo yux, nde mchal xaꞌ mchep xaꞌ bark tya. ");
INSERT INTO ztp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mchoꞌ xaꞌ re doꞌ chanꞌ yiꞌb jwanꞌ ndenkeꞌ bark nde mblaꞌ xaꞌy lenꞌ nittoꞌ, mtoleꞌ xaꞌ ya jwanꞌ nchoned bark, leꞌ lar jwanꞌ ndaꞌb lo bark mxap xaꞌy gap lo mbi nde mdobte nda bark ro yux. ");
INSERT INTO ztp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Per ngotu bark ti tenꞌ nchak chop lo nit nde tya mblatha'b bark cheꞌ ngwaꞌd xi bark lo yux nde ngenta cho kwina, leꞌ xanꞌ bark nyaga mdin bdey nde mdobte ndobila. ");
INSERT INTO ztp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Leꞌ re sondad ncholaꞌs kuj xaꞌ re xaꞌ nak pres, sa naꞌxoꞌnta nek thib xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Leꞌ xaꞌ nyebeꞌ lo sondad, naꞌncholaꞌsta xaꞌ gaj Pab, yaja naꞌndad xaꞌ diꞌs nguj sondad re pres, nde mnabeꞌ xaꞌ xanya xaꞌ nij nit sa ner re xaꞌ ya yobi lo nit sa sin xaꞌ ro yux. ");
INSERT INTO ztp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nde re xaꞌ jwanꞌ naꞌakta nij nit mxen xaꞌ re ya tab nde mxen xa' re pedaz jwanꞌ lad bark, lo jwanꞌ na mxyoꞌb xaꞌ nde tamod ngotey, reta xaꞌ mblyaꞌ mzin xaꞌ izyo biz. ");
INSERT INTO ztp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Senꞌ mblyaꞌla re náꞌ, zyaraꞌ sa mne náꞌ Malta ndole izyo ta nzi xtowꞌ nittoꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nde re men nzo tya wen toz xaꞌ lo náꞌ, mtolꞌ xaꞌ ki nde mbrez xaꞌ náꞌ sa zyen náꞌ tak ndo yi nde jwanꞌ toz nal. ");
INSERT INTO ztp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Zyasa mthop Pab lud xod ya bis ngego Pab lo ki nde xija mbroꞌ ti mbelꞌ ndaxonꞌ maꞌ lo xlye nde mkeꞌ maꞌy yaꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Leꞌ re men nzo tya lo mne xaꞌ ngenga mbelꞌ yen yaꞌ Pab, zya nchab xaꞌ lo ta xaꞌ: —Nzo pa xaꞌ guj men xaꞌ ba, jwanꞌ nasa ne mblyaꞌ xaꞌ lo nittoꞌ, jwanꞌ nak galꞌ na'taꞌde diꞌs ban xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Zya msib Pab yaꞌ Pab lo bel, sa ngob mbelꞌ nde ngenta kwan ndak Pab. ");
INSERT INTO ztp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Reta men ngembed xaꞌ lya ki Pab o zyaga gaj Pab nde bro toz mkembed xaꞌ nyenꞌ kwan tyak Pab per ngen kwan jwanꞌ narax ndak Pab, yaja mzyeꞌ xgab re xaꞌ nde nchab xaꞌ ke dios nak Pab. ");
INSERT INTO ztp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gax tya nax pla izyo chanꞌ ti xaꞌ ndole Publio xaꞌ ntak lo yez jwanꞌ nax xtowꞌ nittoꞌ, nabeꞌz toz mkayaꞌ xaꞌ náꞌ, mdaꞌ xaꞌ liz xaꞌ mbled náꞌ son wiz. ");
INSERT INTO ztp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nde xud Publio nayiz, nax xaꞌ lo lon' nzo xlye xaꞌ nde ndyak xaꞌ chiꞌd ren; zya ngote Pab lenꞌ yo sa mbwiꞌ Pab xaꞌ, senꞌ mne mnaꞌb Pab lo Dios, mxoꞌb yaꞌ Pab yek xaꞌ nde mdyanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Lo ta ngok jwanꞌna, masraꞌ re men nayiz, xaꞌ nzo tya mbyeꞌd xaꞌ lo Pab nde tagaꞌ mdyanꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nde jwanꞌ toz mdaꞌ xaꞌ dyux lo náꞌ; senꞌ ngwap náꞌ bark, mtelꞌ xa' re jwanꞌ mas nakinꞌ náꞌ ned. ");
INSERT INTO ztp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Senꞌ ngoxoꞌb son mbeꞌ nzi náꞌ tya, ngwap náꞌ lo ti bark chanꞌ xaꞌ Alejandrí, tak no xaꞌ mbled tya dib beꞌ jwanꞌ mxyoꞌb yop; leꞌ lo bark nge chop mnab jwanꞌ ndole Cástor nde Pólux. ");
INSERT INTO ztp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Senꞌ mzin náꞌ yez Siracusa, tya mbled náꞌ son wiz. ");
INSERT INTO ztp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nde tya mbroꞌ náꞌ nda náꞌ thipta ro nit mzin náꞌ ti yez ndole Regio, nde tedib wiz mdobte mxyo'b mbi ned jwan' nde náꞌ, jwanꞌ nasa ngok mbrop wiz zyaraꞌ mzin náꞌ yez ndole Puteoli. ");
INSERT INTO ztp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tya mzyal náꞌ pla wes nde mnaꞌb xaꞌ lo náꞌ yanꞌ náꞌ lo xaꞌ gaz wiz; xisa mbroꞌ náꞌ nda náꞌ yez Rom. ");
INSERT INTO ztp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Senꞌ mbin re wes ke ndozin náꞌ, zya mbyeꞌdxiꞌned xaꞌ náꞌ axta lo xbi' ten' ndole Apio nde tenꞌ ndole Son Tabernas ten' mbed men. Senꞌ mbwiꞌ Pab re xaꞌ ya, mdaꞌ Pab dyux lo Dios nde ngo nale lazoꞌ Pab. ");
INSERT INTO ztp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Senꞌ mzin náꞌ Rom, leꞌ xaꞌ nyebeꞌ lo sondad mdayaꞌ xaꞌ re pres lo tib xa jwanꞌ nyebeꞌga lo reta sondad, leꞌ Pab, mdaꞌ xaꞌ diꞌs xaꞌta ngo Pab nde ti sondad mgenap. ");
INSERT INTO ztp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Senꞌ ngoxoꞌbla son wiz jwan' mzin náꞌ yez Rom, zya mbrez Pab re xaꞌ nyebeꞌ lo men judí nde senꞌ ngolo mdyop re xaꞌ, zya nchab Pab lo xaꞌ: —Wes na, ngen cho jwanꞌ narax mblin lo re mayez xaꞌ judí, nekla mblin narax kon re mod gox jwanꞌ mtanꞌ re xaꞌ gox lonꞌ mbre pola per mkeꞌ lizyiꞌb xaꞌ na yez Jerusalén nde naya ndetayaꞌ xaꞌ na lo men nak sinꞌ yez Rom. ");
INSERT INTO ztp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nde senꞌ mnaꞌb xaꞌ kwent lon, ngen cho yalke mzyal xaꞌ jwanꞌ nzalꞌ gaj na, jwanꞌ nasa ndonke xaꞌ ndlaꞌ xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per re xaꞌ judí naꞌncholaꞌsta xaꞌ laꞌ xaꞌ na, jwanꞌ nasa mnaꞌb na telꞌ xaꞌ na lo César, naꞌnakte tak ncholas na kenꞌ yalke yek re xaꞌ las na. ");
INSERT INTO ztp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Jwanꞌ nasa, mbrez na re goꞌ sa wiꞌn goꞌ nde todiꞌsnon goꞌ; tak xke jwanꞌ nkembed re naꞌ ta nak men Israel, yalke ya sa nagon kon kaden reꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Zyasa nchab re xaꞌ lo Pab: —Teraꞌ kayaꞌ náꞌ nek thib yeꞌs jwanꞌ mbroꞌ Judea jwanꞌ ndej kwent chanꞌ la nde nek thib wes jwanꞌ nkeꞌ yalke yek la o ni narax xis la teraꞌ yeꞌd xaꞌ ncheꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Per ncholaꞌs náꞌ gon náꞌ kwan nak xgab la, tak kwan liy sa reta lad narax ni men xis jwanꞌ ta ngetetej la ba. ");
INSERT INTO ztp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Zyasa mblí xaꞌ ti wiz dyop re xaꞌ, nde wiz ya bro toz men mdyop lo Pab, sa mdobte mdej Pab jwanꞌ nak yalnyebeꞌ chanꞌ Dios lo xaꞌ, xata mdobte Pab tilꞌ nde axta bzye. Mchal Pab li lazoꞌ xaꞌ Jesús sa mdej Pab lo xaꞌ jwanꞌ nak ley chanꞌ Moisés nde xkiꞌs re profet. ");
INSERT INTO ztp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nzo xaꞌ mbli lazonꞌ jwanꞌ mdej Pab nde nzo xaꞌ naꞌndlid lazoꞌne. ");
INSERT INTO ztp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nde lo ta naꞌnzalꞌdiꞌsta xkiꞌs re xaꞌ zya mdobte ngo xaꞌ ned nde nchab Pab lo xaꞌ: —Jwanꞌ naga sa, por Mbi Nayon mni Profet Isaías lo re xaꞌ gox lonꞌ mbre pola, nchab xaꞌ: ");
INSERT INTO ztp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Wa yez ba nde gus lo xaꞌ: Nchon goꞌy kon nza goꞌ, per naꞌyenta goꞌy, nde wiꞌ goꞌy, per naꞌyolod goꞌy. ");
INSERT INTO ztp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Tak ngok ne lazoꞌ re mayez reꞌ, nde now' nza xa' naꞌgonta xaꞌ diꞌs, nde nowꞌ ngud lo xaꞌ, tamod sa naꞌyonid ngud lo xaꞌ, nekla gon xaꞌ diꞌs kon nza xaꞌ, nde naꞌyenta xaꞌ dib nzo lazoꞌ xaꞌ, nekla bere xaꞌ lon sa todanꞌ na xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Nde naya ndablo nye goꞌ, leꞌ re xaꞌ naꞌnakta judí, xaꞌ ya kayaꞌ yaltolaꞌ chanꞌ Dios, nde re xaꞌ ya ton xkiꞌs na. ");
INSERT INTO ztp_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Nde senꞌ ngolo ta nchab Pab lo xaꞌ, zya tolo ngo re xaꞌ judí ned nde taja ndaya xaꞌ di's. ");
INSERT INTO ztp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Chop linꞌ dib ngo Pab ti yo tenꞌ mdi'x Pab nde tya mkayaꞌ Pab reta men jwanꞌ nda lo Pab, ");
INSERT INTO ztp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","dibxlaꞌs ndej Pab yalnyebeꞌ chanꞌ Dios nde ndloꞌ Pab xkisꞌ Jesucrist lo re men, nde ngen cho xa' nka diꞌs lo Pab.");
INSERT INTO ztp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Na Pab, men ndli sinꞌ lo Jesucrist, mbrez Dios na, nak na apóst, mblo'xa' Dios na sa tej na diꞌs wen chanꞌ Dios, ");
INSERT INTO ztp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","jwan' mkeꞌyekla Dios nera' ta mdej re profet jwan' mke lo Yeꞌs Nayon chanꞌ Dios, ");
INSERT INTO ztp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ndeja kwent chanꞌ Xinꞌ Xa', Jesucrist Xaꞌ Nyebeꞌ lonꞌ, Xaꞌ ngol lo bin David xajka mena, ");
INSERT INTO ztp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","sen' lo mbroꞌxban Xaꞌ xij re men nguj, mbro'xo'b nak Xaꞌ Xin' Dios por yalne chan' Mbi Nayon, ");
INSERT INTO ztp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","nde por Jesucrist mda' Dios yalwen lo ná' sa mtel' xa' ná' ndej ná' xki's Xa', sa dib nax lo izyo li lazo' men Jesucrist, xob yek men Xa' nde ke' lazo' men Xa', ");
INSERT INTO ztp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","nde noga' go' nzo xij reꞌ, mbrez Xa' go' sa ak go' men Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ngeke'n ye's re' lo reta go' jwan' nzo yez Rom, nke' lazo' Dios go' nde mbrez Dios go' sa nayon ban go'. Pkaya' go' yalwen nde yalnabe'z chan' Xud na' Dios por Jesucrist Xa' Nyebe'. ");
INSERT INTO ztp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nerla ndan dyux lo Dios na por Jesucrist por reta go', sa jwan' ta ndli lazo' go' rya'sa dib nax izyo. ");
INSERT INTO ztp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Tak Dios jwan' ta dib nzo lazo'n ndlin sin' lon' lo ndej na di's wen chan' Xin' Xa', mne ke thibla ndej na go' lo Xa' lo ndyodi'snon Xa'. ");
INSERT INTO ztp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ngena'b na lo Dios aka xa nchola's Xa' sa sin wiz lin gan yatwi'n go'. ");
INSERT INTO ztp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Tak ncholas na winꞌ goꞌ, sa tan lo go' thi yalwen chan' Dios jwan' toyal li go', sa mas tyosa' go'. ");
INSERT INTO ztp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Jwan re' sa go' nde na konen' lazo' tan' lo jwan' ta thita ndli lazon' ba. ");
INSERT INTO ztp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Per nancholasta na, wes na, ke yajla's yek goꞌ ke nar tozla gob mdosa'n yatwi'n goꞌ, per axta naya thibka ntowꞌ jwan' lon, sa noga xij go' wi'n xa ndoxen goꞌ lo xkiꞌs Dios, ta xa temas re xaꞌ nanakta judí ndoxen xaꞌ lo xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Lo re xaꞌ gryeg nde lo re xaꞌ naꞌnakta gryeg, lo re xaꞌ nchak nde lo re xaꞌ na'nchakta, ndabloga ya na. ");
INSERT INTO ztp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Jwanꞌ nasa, ngyen toz lazonꞌ yatej na diꞌs wen chanꞌ Jesucrist noga lo re goꞌ ta nzi yez Rom. ");
INSERT INTO ztp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Tak naꞌndyolasta na lo diꞌs wen chanꞌ Jesucrist, tak naka yalne chanꞌ Dios sa ntolaꞌy reta men jwanꞌ ndli lazon' Dios, nerla re xaꞌ judí nde noga re xaꞌ grieg. ");
INSERT INTO ztp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Tak lo diꞌs wen chanꞌ Jesucrist jwanꞌ galꞌ chanꞌ Dios ndryoꞌxo'ba lo men sen' ndli lazoꞌ men Xa', jwan' nasa nakin' thibla li lazo' men Xa', xa ngeni lo xkiꞌs Dios: “Men jwan' gal' nak, lo ndli lazo' xa', jwan' na li ban xa'” ");
INSERT INTO ztp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Le yalnayiꞌ chanꞌ Dios axta lo be' ndryo'toy ndey xis reta men ndli jwan' xkap nde re men jwan' nagal'ta nak, kon yalnaraxa ndyentob xa' jwan' li. ");
INSERT INTO ztp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Tak re jwanꞌ ta ndlo' cho nak Dios, ndlo'tira lo xa', tak leꞌga Dios mbloꞌtoy lo xa'. ");
INSERT INTO ztp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tak re jwanꞌ ta naꞌndloꞌda nak Dios, xa nak yalne adiꞌ nde yalnaro jwanꞌ nak Xaꞌ Dios, nambi tir ndryoꞌtoy xata mdoxkwa' izyo, tya yen men reta jwanꞌ mdoxkwaꞌ Dios, jwanꞌ nasa na'ngenta kwan tob ro xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Tak teꞌnye mbyolo xaꞌ Dios, naꞌndlinarod xaꞌ Dios xa ndabloy, nekla ndaꞌ xaꞌ dyux lo Dios, cheꞌla mbryo re jwan' narax ndono xa', nde le' lazoꞌ ta ngok ne mblatoy lo yal'kow. ");
INSERT INTO ztp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Mbez xaꞌ men nchak xaꞌ, ngok xaꞌ men neyek, ");
INSERT INTO ztp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","nde mpseꞌ xaꞌ yalnaro chanꞌ Dios, Xa' jwan' naꞌndluxta, por mnab chan' re men jwanꞌ ndlux, nde mnab re ma' ndob xil' na', mnab jwanꞌ naksaꞌ re maꞌ ndob thap ninꞌ, nde mnab re ma' jwan' ndye len' na' izyo. ");
INSERT INTO ztp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Jwanꞌ nasa mblaꞌyaꞌ Dios xaꞌ lo re jwanꞌ xkap, lo re jwanꞌ narax ndryoꞌ lazoꞌ xaꞌ, nde le'ga le' bel' xa' mblo' yantho kon re jwan' xkap mbli xa', ");
INSERT INTO ztp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Tak mpseꞌ xaꞌ jwanꞌ li chanꞌ Dios por yalkwinꞌ, nerla lo re jwan' mtoxkwa' Dios mdoxub xa' nde mxo'byek xaꞌ yub Dios jwan' mdoxkwan' reta jwan', Xaꞌ nayon adi'. Ta aka. ");
INSERT INTO ztp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Jwanꞌ nasa mdaꞌyaꞌ Dios xaꞌ sa li xaꞌ reta yantho jwan' ndryo' lazo' bel' xa'. Axta re ngol naꞌncholaꞌstra gaxno ngol xaꞌ bi, leꞌ ngol ndyen ta got ngol, ");
INSERT INTO ztp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","nde tagaꞌ mod ndli re xaꞌ biꞌ nandyenta' xa' gaxno xa' ngol nde mbla re yalxkap yek xaꞌ le'ga ta bi' xa' nchakno xa', ndli xaꞌ re yantho nchaxno xaꞌ le'ga ta biꞌ xaꞌ nde leꞌga re yalxkap chanꞌ xaꞌ ya li sa ya xa' lo pen. ");
INSERT INTO ztp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Mbay lo ta nangen kwan ndyak xa' Dios, jwanꞌ nasa mblaꞌyaꞌ Dios xaꞌ lo re xgab xkap jwanꞌ ndono xaꞌ, sa li xaꞌ re jwanꞌ naꞌndabloda li xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Mde' re jwan' narax xa', ndli re lo jwanꞌ xkap kon xaꞌ naꞌnakta salꞌ xaꞌ, ndli xaꞌ re ned jwanꞌ bew, ndyablaꞌs xaꞌ jwan' nanakta chan' xa', ndli xaꞌ yalxinlaꞌs, ndaxin lazo' xa' kon ta xa', nguj xaꞌ men, mbezno ta xaꞌ, nkwinꞌno xaꞌ ta men xaꞌ nde napta re jwanꞌ narax ndli xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ndyodiꞌs narax xaꞌ xis ta xa', ni xin xaꞌ, ngo'tal xaꞌ Dios, nakap mbez xaꞌ lo ta xaꞌ, nchak naro xaꞌ, nxyalꞌ xaꞌ, nata toz yek xaꞌ ndli xaꞌ re jwanꞌ narax, naꞌnxobyekta xaꞌ xud xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ne yek xaꞌ, naꞌgalꞌta nak xaꞌ, naꞌnkeꞌd lazoꞌ xaꞌ ta men xaꞌ, ne toz lazoꞌ xaꞌ, naꞌndlaꞌta lazoꞌ xa' men. ");
INSERT INTO ztp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Re men ya, tenye mne xaꞌ ke Dios nyaꞌb kwent lo xa', ke reta men ndli jwanꞌ narax nzalꞌ xa' gaj xa', na'nakte ben'ta ndli xaꞌy, che'la noga ndyen xaꞌ ngwiꞌ xaꞌ re men ndli jwanꞌ naraxa. ");
INSERT INTO ztp_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Jwanꞌ nasa, lu mbiꞌ, naꞌnyeda ryoꞌto nambia, oneja cho nak la. Tak senꞌ ngoxyoa tedib men, leꞌga loa nkwanꞌ la yalke tak ngoxyoa men nde noga lu tagaꞌ ndlia. ");
INSERT INTO ztp_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tak mnenꞌ leꞌ Dios galꞌ nyaꞌb Xaꞌ kwent lo re men ta ndli jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","¿Nde lu mbiꞌ, lo ta ngoxyoa men ta ndli jwan' re' nde taga' ndlia ¿cho lea ndyak na lyaꞌa lo yalnathoz chanꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","¿O ngoꞌtal la reta yalwen toz tir chanꞌ Dios, jwanꞌ plopa nxek Dios men nde naꞌnyed la leꞌ yalndlat lazoꞌ Dios men ngoneda lu sa laꞌa jwanꞌ narax nak la? ");
INSERT INTO ztp_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nde lo ne yek la nde lazo'a nanchola'sta lu laꞌa re jwanꞌ narax, zyasa leꞌga lu ngegosaꞌa yalnayiꞌ chanꞌ Dios xis la, senꞌ sin wiz yeꞌd yalnathoz chanꞌ Dios, jwanꞌ nyaꞌb Dios kwent galꞌ lo re men, ");
INSERT INTO ztp_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","nde Dios kix ka kad thiba men, a xa nak re jwanꞌ mbli men. ");
INSERT INTO ztp_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Yalnaban adiꞌ taꞌ Dios kayaꞌ re men jwanꞌ thiblaꞌ ndli yalwen, men nkwanꞌ yalnaro chan' Dios, men nxobyek nde men nkwan' jwanꞌ naꞌndluxta. ");
INSERT INTO ztp_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Per yalnayi' nde dib xyan chan' Dios kaya' re xaꞌ jwanꞌ ndli xgab benꞌta le'ga xaꞌ nde naꞌnxobyekta xaꞌ jwanꞌ li, cheꞌla ben'ta jwan' narax nxobyek xa'. ");
INSERT INTO ztp_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Pen nde yalnathoz rid reta xaꞌ ndli jwanꞌ narax, nerla re xaꞌ judí nde noga re xaꞌ gryeg ");
INSERT INTO ztp_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Per Dios li naro xa', ta' jwan' nzal' xa, nde ta' yalnabe'z lo re men ndli jwan' wen, nerla re xaꞌ judí nde noga re xa' na'nakta judí. ");
INSERT INTO ztp_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Tak Dios nambída men. ");
INSERT INTO ztp_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Tak re xaꞌ mbli jwan' narax naꞌnzoloda ley, tagaꞌ sinta ley nyaꞌb Dios kwent lo xaꞌ, nde leꞌ re xaꞌ mbli jwan' narax nzolo ley, taga kon ley nyaꞌb Dios kwent lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Tak re men jwanꞌ benꞌta nchon ley nde naꞌndlid xaꞌy, naꞌnakta xaꞌ men galꞌ lo Dios, leꞌ men jwanꞌ nxoꞌbyeka, men ya nak men galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Leꞌ re xaꞌ jwanꞌ naꞌnakta judí, teꞌnye naꞌngenod xaꞌ ley, nde kon xgab yek xa' mbli xa' jwan' nyebeꞌ ley, tak leꞌga xaꞌ nak ley lo xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","mod nak xaꞌ jwanꞌna ndloꞌ nxoꞌbyek xaꞌ ley. Nde leꞌga xaꞌ mne jwanꞌ reꞌ tak leꞌga xgab xaꞌ xoꞌb yalke xis xaꞌ o tolaꞌy xaꞌ ");
INSERT INTO ztp_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","senꞌ sin wiz nyaꞌb Dios kwent kon Jesucrist, re jwanꞌ nagaꞌs ndli men, xata nak diꞌs wen chanꞌ Jesucrist jwanꞌ ndloꞌn lo goꞌ reꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Mbay le' lu, mbez la nak la men judí, ndli lazoꞌa ley jwanꞌ mdaꞌ Dios, nde nxyalꞌ la nak la men Dios. ");
INSERT INTO ztp_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Nde nzoloa jwanꞌ ncholaꞌs Dios nde nchak mbia jwan wen tak tamod ndlo' leya loa. ");
INSERT INTO ztp_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nde mnepa la nak la men ngoꞌb ned lo re xaꞌ nkow lon' nde nak la xni lo re xaꞌ ndo lo yalꞌkow, ");
INSERT INTO ztp_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ntoteꞌd la re men jwanꞌ ngenta kwan mne nde tagaꞌ ntoteꞌd la re men jwanꞌ nak xaja or bix, tak ndyak la nzoloa ley nde ndlia xgab galꞌ toz ndoa nde mnea reta jwanꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Leꞌ lu jwanꞌ ntoteꞌd xaꞌla men ¿Kwan liy sa naꞌtoteꞌdta la leꞌga lu sa? nde lu jwanꞌ ndloꞌ lo men naꞌliwaꞌnta xaꞌ ¿Kwanka liy lu ndli wanꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Lu mbez naꞌndabloda gaxno men tedib xaꞌ jwanꞌ naꞌnakta salꞌ men ¿kwanka liy lu ndliy sa? Lu ta ngiꞌnoa re mnab ¿Kwanka liy ndli wanꞌ la re jwanꞌ nzi lenꞌ yodoꞌ tenꞌ ndob mnab sa? ");
INSERT INTO ztp_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Lu nxyalꞌ la ngenoa ley, per ngiꞌs la ley senꞌ naꞌnxobyekta lu Dios. ");
INSERT INTO ztp_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Jwanꞌ naga sa nchab lo xkiꞌs Dios: “por xke goꞌ sa re men naꞌnakta judí nixin xaꞌ xis Dios.” ");
INSERT INTO ztp_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nde gal' di's le' be' ndli sinꞌna tez nxobyek la ley, per tez naꞌnxobyekta lu ley, zyasa benꞌta nale ndob be' lad la naꞌngenta cho sinꞌ liy. ");
INSERT INTO ztp_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nde tez xaꞌ jwanꞌ nangeda be' lad na' per nxobyek xaꞌ re jwanꞌ nyebeꞌ ley, xaꞌ ya teꞌnye naꞌngeda be' xa' nak xaꞌ xajka men nge be'ba. ");
INSERT INTO ztp_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Leꞌ Xaꞌ jwanꞌ naꞌndobta be' nde nxobyek xaꞌ ley chanꞌ Dios, xaꞌ ya xoꞌb yalke xis la, tak lu tenyega ndob be' lad la nde ngenoa ley jwanꞌ nge lo yeꞌs per naꞌnxobyekta luy. ");
INSERT INTO ztp_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Tak lo nak men xaꞌ judi naꞌnakte benꞌta nzob xis ak mena, nde tagaꞌ lo tyob be' lad men bi'ba naꞌnakte benꞌta nzob xis li mena. ");
INSERT INTO ztp_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Men jwanꞌ liga nak judí, lenꞌ lazoꞌ xaꞌ nak xaꞌy, tagaꞌ xaꞌ jwanꞌ ndob be', lenꞌ lazoꞌ xaꞌ aka, naꞌakte jwanꞌ nyebeꞌ mbiꞌ, aka jwanꞌ nyebeꞌ Mbi Nayon. Men jwanꞌ ta nak, wen ngwiꞌ Dios xaꞌ teꞌnye ngoꞌtal re men xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Jwanꞌ nasa ¿Cho yalwen ndeno nak men judí? ¿O cho sinꞌ li tyob be' lad men biꞌ ba? ");
INSERT INTO ztp_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Naꞌr toz mod ndli sinꞌna. Jwanꞌ ner nak, lo re xa' judí jwan nerla mzin xkiꞌs Dios. ");
INSERT INTO ztp_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","¿Cho kwan yotey, tez nzo xaꞌ naꞌndlid lazonꞌ Dios? ¿Cho jwanꞌ nasa laꞌ Dios jwanꞌ galꞌ nak Dios? ");
INSERT INTO ztp_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Naꞌnakte! Dios thiblaꞌ wen nak Xaꞌ, teꞌnye reta men nakwinꞌ men, xa nchabka lo xkiꞌs Dios: Por xkiꞌs la nak la Xaꞌ galꞌ nde lu li gan senꞌ koxyo xaꞌ lu. ");
INSERT INTO ztp_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mbay tez yalnarax chanꞌ naꞌ ndloꞌy jwan' gal' nak Dios, ¿Cho kwan gab naꞌ? ¿Cho naꞌgalꞌta nak Dios senꞌ ndaꞌ Xaꞌ diꞌs ndriꞌd naꞌ pen? (Xajka thi mena ngenin lo go'.) ");
INSERT INTO ztp_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Naꞌnakte jwanꞌna! tak tezka ngak Dios Xaꞌ naꞌgalꞌta, ¿Xomod nyaꞌb Dios kwent lo reta men lo izyo sa? ");
INSERT INTO ztp_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mbay tez por yalkwinꞌ chanꞌ na sa ndloꞌ masraꞌ jwanꞌ li nde yalnaro chanꞌ Dios, ¿Cho kwan liy nyaꞌb Dios kwent lon xajka men nzoꞌb xken na' ba sa? ");
INSERT INTO ztp_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Jwan' nasa pla xa' nke'yalkwin' nde mbez xa' na' ndlo' jwan' re': linꞌ jwanꞌ narax sa yeꞌd yalwen xa' ta mbez sa nzalꞌ xaꞌ kix xaꞌ xken xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Cho kwan gab naꞌ? ¿Re naꞌ men judi cho mas ntak naꞌ lo tedib ned men? ¡Naꞌnakte! tak ta xa mbezka náꞌ lo goꞌ, re men judi nde re men naꞌnakta judí nzo'b xken xa'. ");
INSERT INTO ztp_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ta xa nchabka lo xkiꞌs Dios: Ngenta men gal' nak, nek thib men naꞌngenta. ");
INSERT INTO ztp_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ngenta cho men nchen, ngenta cho men nkwanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Reta men ngetetaꞌb, ngok xaꞌ men ngen cho rsinꞌ. Ngen cho li jwanꞌ wen, naꞌngenta nek thib xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Xa nak ti ro baꞌ ndoxalꞌla nak yen xaꞌ. Nde los xaꞌ nkwinꞌ xaꞌ. Leꞌ ro xaꞌ nzo diꞌs tin xa nak ro mbelꞌla. ");
INSERT INTO ztp_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Se ro xaꞌ nzo diꞌs nke'de xa' nde se lazo' xa' nzo xyan. ");
INSERT INTO ztp_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nken toz lazo' xa' kuj xa' men. ");
INSERT INTO ztp_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Yalti nde yalnabil ndano xa' ploja nda xa'. ");
INSERT INTO ztp_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nde nambyalod xaꞌ jwanꞌ nak yalnabeꞌz. ");
INSERT INTO ztp_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nek lud naꞌnzepta lazoꞌ xaꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Naya mnenꞌ, leꞌ reta jwanꞌ ta nge lo ley, ngeniy lo re men jwanꞌ nzo lo ley, sa nekthib xa' na'gabta na'ngenta xken xa', che'la reta xa' taya' kwent lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Tak nek thib xa' nayanꞌgalꞌta lo Dios lo ndli xaꞌ re jwanꞌ ngeni ley, tak ley benꞌta ndliy ngoxo'ba xken men. ");
INSERT INTO ztp_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Leꞌ naya teꞌnye naꞌlid men re jwanꞌ nyebeꞌ ley, Dios mbloꞌ lonꞌ xomod ndablo ak men ti men galꞌ lo Dios, jwanꞌ xa nchabka lo ley nde jwanꞌ mdej re profet. ");
INSERT INTO ztp_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Dios ndli nchanꞌ men ti men galꞌ lo ndli lazoꞌ men Jesucrist. Nde ndli Xaꞌy kon reta men, oneja cho mena. ");
INSERT INTO ztp_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Lo ta reta men mbli jwanꞌ narax, jwanꞌna mbli mbro'tal men lo yalnaro chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Leꞌ Dios, por yalwen chanꞌ Xaꞌ jwanꞌ naꞌnzalꞌta naꞌ kayanꞌ, tata mblilal Xaꞌ naꞌ men galꞌ lo Xaꞌ, lo ta mtolaꞌ Dios na' por jwan' mbli Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Dios mto Jesucrist sa mdaya' lazo' Xa' sa mbyax reta xken na' lo mxyo ren Xaꞌ nde ndli lazo' men Xa', tamod mblo' Dios ke gal' nak Xa' lo mxek Xa' nde na'ndapenta Xa' re men mbli yalke pola. ");
INSERT INTO ztp_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ta ngoka sa ndloꞌ plopa gal' nak Dios naya nde thibka galꞌ nak Xaꞌ tak ndli Xaꞌ ke re men jwanꞌ ndli lazonꞌ Jesucrist nchanꞌ men, men galꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","¿Ma yalbxalꞌ chanꞌ mbiꞌ sa? mbroꞌtala. ¿Cho kwanꞌ liy sa? ¿Cho tak lo mbli xaꞌ jwanꞌ nchab leya? Naꞌnakte, cheꞌla lo ndlipa lazoꞌ xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jwanꞌ nasa naya mnenꞌ, leꞌ Dios ndlilal Xaꞌ naꞌ men galꞌ senꞌ lipa lazoꞌ men Jesus nde naꞌnakte tak ndli men jwanꞌ nyebeꞌ ley. ");
INSERT INTO ztp_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Cho nak Dios benꞌta Dios chanꞌ re men judí? ¿Cho naꞌnoda nak Xaꞌ Dios chanꞌ re men naꞌnakta judí? Noga nak Xaꞌ Dios re men naꞌnakta judí. ");
INSERT INTO ztp_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Tak ben' thipta Dios nzo: Dios ta ndli sa nchanꞌ men, men galꞌ, re men ta ndlipa lazon' Xaꞌ, one cho ndob be' lad xa' o na'ngenta be' lad xa'. ");
INSERT INTO ztp_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mbay ¿Cho lo ta ndlipa lazonꞌ Jesucrist sa gab naꞌ naꞌntakta ley? Naꞌnakte, cheꞌla tamod ndej naꞌ ke liga ndak ley. ");
INSERT INTO ztp_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","¿Cho kwan gab naꞌ? ¿Cho kwan mbli Abraham gan lo yalnaban chanꞌ xaꞌ, xaꞌ gox lonꞌ ngo pola? ");
INSERT INTO ztp_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Tak tez mbyanꞌ Abraham xaꞌ galꞌ por re jwanꞌ mbli xaꞌ, ngeno Abraham kwan xyalꞌno xaꞌ, per na'akta xya'lno xa'y lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Tak ¿Cho kwan nchab lo xkiꞌs Dios? “Abraham mblipa lazoꞌ xaꞌ Dios jwanꞌ nasa mblilal Dios xaꞌ ti xaꞌ galꞌ.” ");
INSERT INTO ztp_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mbay, ti men jwanꞌ mke sinꞌ, tmi jwanꞌ nchax ka xaꞌ, nakte jwanꞌ ngetela's men lo xaꞌ, che'la mbli xaꞌ gana. ");
INSERT INTO ztp_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Mbay, tez nzo xa' ndli lazon' Dios, Xa' jwan' ngo'to nambi men nzob xken', Dios ndyen kwent jwan' na xaga thi men gal' nak. ");
INSERT INTO ztp_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Noga David mdej xaꞌ yalwen toz jwanꞌ ndaꞌ Dios senꞌ ndlilal Dios men ti men galꞌ, te'nyega ngenkwan ndli men sa nzal' mena, ");
INSERT INTO ztp_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","nchab xa': Nabeꞌz toz nda re men jwanꞌ mtonꞌ Dios re xken naꞌ, nde mtorid yek Dios re jwanꞌ narax mbli xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nabeꞌz toz nda re men jwanꞌ mto'n Dios reta xken naꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿Mbay yalnabez re' cho benꞌta re xaꞌ nge be' lad na' kayaꞌy o no re xaꞌ naꞌngenta be' lad na'y? Tak nchab naꞌ, Abraham mbli lazo' xa' Dios jwanꞌ nasa mblilal Dios xaꞌ ti xaꞌ galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mbay ¿Pol mbli Dios sa mbyanꞌ Abraham xaꞌ galꞌ? ¿Cho senꞌ mdobla be' lad xa'y o lo senꞌ tera tyob be' lad xaꞌy? Leꞌy ngok lo senꞌ tera tyob be' xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Nde xisla zyaraꞌ mdob be' lad Abraham ten' nak lad men biba, sa jwanꞌna nak ti beꞌ ndloꞌ mkayaꞌ Dios Abraham xaja ti xaꞌ galꞌ lo mblipa lazoꞌ Abraham Dios. Jwanꞌ nasa Abraham ngok xud re xaꞌ jwanꞌ benꞌta ndlipa lazoꞌ xaꞌ Dios tenye nandobta be' lad xa' nde Dios nkayaꞌ re men ya xaja men galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nde noga nak Abraham xud re xaꞌ jwan mdobla be' lad naꞌ tenꞌ nak lad men biꞌba nde re xaꞌ ya noga mbli lazoꞌ xaꞌ Dios ta xa mbli lazoꞌ xud naꞌ Abraham Dios lo tera' tyob be' lad Abraham. ");
INSERT INTO ztp_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Le' Dios, mke' yek Xaꞌ lo Abraham nde lo re men jwanꞌ nde lo bin Abraham sa tayaꞌ Dios dib nax izyo kaya' xa', nde naꞌnakte tak mxoꞌbyek Abraham ley, cheꞌla lo mblipa lazoꞌ Abraham Dios sa mkayaꞌ Dios Abraham xaga men galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Tak tez benꞌta re men jwanꞌ nxoꞌbyek ley men yata kayaꞌ jwanꞌ taꞌ Dios, zyasa leꞌ jwanꞌ ndlipa lazoꞌ men Dios ngen cho sinꞌ liy nde mbroꞌtal jwanꞌ mkeꞌyek Dios. ");
INSERT INTO ztp_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tak ley ndenoy yalnayiꞌ, nde tenꞌ naꞌngenta ley tagaꞌ ngenta yalke. ");
INSERT INTO ztp_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Jwanꞌ nasa, leꞌ jwanꞌ mkeꞌyek Dios mdaꞌ Dios lo Abraham, tatka ntaka lo reta men jwanꞌ nde lo bin Abraham, ngoka ti jwanꞌ mdalaꞌs Dios lo xaꞌ lo ndlipa lazoꞌ xaꞌ Dios. Nde naꞌnakte benꞌta lo re men nxobyek ley, noga naka lo reta men jwanꞌ ndli lazonꞌ Dios, ta xa Abraham mbli lazo' xa' Dios, jwanꞌ nasa Abraham nak xud reta naꞌ, ");
INSERT INTO ztp_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(jwanꞌ xa nchabka lo Xkiꞌs Dios: “Mblilal na lu xud reta men.” Dios jwanꞌ mblipa lazoꞌ Abraham Xa' jwan' ndaꞌ yalnaban lo reta men nguj, nde ndli Xa' ncho re jwanꞌ naꞌngenta, xajka jwan' nzola ba. ");
INSERT INTO ztp_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nde mbli lazo' Abraham, tenye naꞌnyada ak jwanꞌ nchab Dios, yalal xa' xud brotoz tir men, ta xa nchab Dios lo xa': “Bro toz tir men ya'r lo bin la. ");
INSERT INTO ztp_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham, naꞌndlayoda lazoꞌ xaꞌ lo jwanꞌ ndli lazoꞌ xaꞌ tenye mer nzola xaꞌ tib ayoꞌ linꞌ, Abraham kon Sar ndenꞌla xaꞌ gaj xaꞌ nde tenye ngox toz la xaꞌ nde Sar xa' nij xa' par keno xaꞌ xinꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Per naꞌndlayoda xgab Abraham nekla ngak rop xgab xaꞌ lo jwanꞌ mkeꞌyek Dios lo xaꞌ, cheꞌla ngone lazoꞌ xaꞌ lo jwanꞌ ndlipa lazoꞌ xaꞌ. Nde mbli naro xaꞌ le Dios, ");
INSERT INTO ztp_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","thiptane mtob xaꞌ xgab xaꞌ leꞌ Dios ngeno yalne sa li Dios re jwanꞌ mkeꞌyek Dios lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Jwanꞌ nasa mblilal Dios xaꞌ xa' galꞌ lo mbli lazoꞌ xa' Dios. ");
INSERT INTO ztp_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Nde senꞌ nchab xkiꞌs Dios, mblilal Dios Abraham xaꞌ galꞌ, naꞌnakte benꞌta Abraham, ");
INSERT INTO ztp_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","noga naꞌ ngeteja. jwan' re' nak lo re na' jwan' ta ndli lazo'n Xa', Xa' mblo'xban Jesus xij re men nguj, ");
INSERT INTO ztp_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Xaꞌ jwanꞌ mdayaꞌ yalnaban chanꞌ Xaꞌ sa nguj Xaꞌ por xken reta naꞌ nde mbroꞌxban Xaꞌ sa mbyanꞌ naꞌ men galꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Jwan' nasa, mblilal Dios naꞌ men galꞌ lo ndlipa lazonꞌ Xaꞌ, sa nabeꞌz ngwiꞌ Dios naꞌ por Jesucrist Xaꞌ Nyebeꞌ lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Por Crist sa ngol na' yalwen yoten' lo yalnaro chan Dios, lo mbli lazonꞌ Xaꞌ. Nde galꞌ tyonꞌ lo yalwen chanꞌ Dios, nale nzo lazonꞌ ngembed naꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Nde naꞌnakte benꞌta lo jwanꞌ reꞌ ko nale lazonꞌ, noga lo re yalti ko nale lazonꞌ, tak le'y ndli sa na'yoched lazon', ");
INSERT INTO ztp_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","nde lo na'nchoched lazon', nchobeꞌ jwan' nak naꞌ, leꞌ senꞌ ngobeꞌla jwan' nak naꞌ zya mne wenla na' jwan' ngembed na', ");
INSERT INTO ztp_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","leꞌ jwanꞌ ngembed naꞌ naꞌngoꞌyanthodey naꞌ, tak yalkeꞌ lazoꞌ chanꞌ Dios nzoy lenꞌ lazonꞌ por Mbi Nayon jwanꞌ mdaꞌ Dios lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Tak senꞌ lo naꞌngakta ntolanꞌ lazonꞌ, Crist nguj xa' por reta men nzo'b xkena' be' jwan' ndablo li xa'y. ");
INSERT INTO ztp_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Tak ngen cho ti men yo yek naꞌ gaj por thi men galꞌ nak, tezka nzo thi xa' taya' lazon' per por thi men wen toza. ");
INSERT INTO ztp_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Per Dios ndloꞌ plopa nkeꞌ lazoꞌ Xaꞌ naꞌ, tenye nak naꞌ men nzoꞌb xken naꞌ, Crist nguj por naꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Leꞌ naya, lo ta mblilal Dios naꞌ men galꞌ por ren Crist, plopa mas liga nak, por Crist lyan' lo yalnayiꞌ chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Tak senꞌ lo ngok na men ngiꞌno'n Dios, zya mtoyal Dios kwent kon naꞌ por nguj Xinꞌ Xaꞌ Jesucrist, choleꞌta naya, lo ta mton'la Xa' xken na', lyan' por yalnaban chan' Xa'. ");
INSERT INTO ztp_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Nde naꞌnakte benꞌta jwanꞌna, noga ncho nale lazonꞌ lo Dios por Xinꞌ Xaꞌ Jesucrist Xaꞌ Nyebeꞌ, tak por Xinꞌ Xaꞌ mtoyal Xa' kwent kon na'. ");
INSERT INTO ztp_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Jwanꞌ nasa, lo ta thipta mbiꞌ mbli sa mzin yalke lo izyo nde yalke ya ndeno yalguj nde yalguj mbwaꞌsnoy reta men tak reta men nchap yalke. ");
INSERT INTO ztp_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Tak lo senꞌ tera yo ley, nzola re jwan' narax lo izyo; per tez naꞌngenta ley zya, taga' ngenta cho li ryo'xo'b xken men. ");
INSERT INTO ztp_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Jwanꞌ nasa, reta men jwanꞌ ngo tyemp Adán axta tyemp Moisés, reta xa' nguj, te'nyega namblid xa' yalke xa mbli Adan. Adan ben'ta nak xa' ndlo Crist jwan' ndola ye'd. ");
INSERT INTO ztp_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Per yalke jwanꞌ mbli Adán, nalalta naka kon jwanꞌ ndalaꞌs Dios lo men. Tak lo xken thib mbiꞌ, men toz nguj, per yalwen jwanꞌ nanzalꞌta naꞌ ndalaꞌs Dios lonꞌ por thiptaꞌ mbiꞌ Xaꞌ ndole Jesucrist, yalwen ya mbryaꞌs sa liy yalwen lo reta men. ");
INSERT INTO ztp_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nde leꞌ jwanꞌ ndalaꞌs Dios lo men naꞌnakte xa nak yalke jwanꞌ ta mbli thib mbiꞌ ya, tak lo yalke ya Dios nyaꞌb kwent lo reta men, sa yathix men xken men por mbiꞌ jwanꞌ mbli yalke, per men jwanꞌ mtolaꞌ Dios, Dios mbli sa mbyanꞌ men, men galꞌ tenye naꞌr toz yalke mbli men. ");
INSERT INTO ztp_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mbay tez por xken thipta mbiꞌ, leꞌ yalguj mbli gan nyebeꞌ, cho leꞌtla re men jwanꞌ tata mblilal Dios men galꞌ, masta nyebeꞌ xaꞌ lo yalnaban kub por thibtaꞌ mbiꞌ nde mbiꞌ ya nak Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nde ta, xa yalke jwanꞌ mbli Adán reta men kix xken men, tagaꞌ leꞌ jwanꞌ galꞌ mbli Jesucrist, reta men mbyanꞌ men galꞌ nde keno men yalnaban. ");
INSERT INTO ztp_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Tak por yalneyek chanꞌ ti mbiꞌ sa bro toz men mxyoꞌb xken naꞌ, tagaꞌ por ti mbiꞌ jwanꞌ mxobyek, bro toz men nchanꞌ galꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Lo ngotu ley mas mbloꞌtoy xken men per laja masra' yalke ndli men, le' yalwen chan' Dios mas nathoz naroy, ");
INSERT INTO ztp_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","nde tagaꞌ, ta xa leꞌ yalke mkenoy yalnyebeꞌ sa mzin yalguj, tagaꞌ lo mbyanꞌla naꞌ men galꞌ lo Dios leꞌ yalwen chanꞌ Dios mkeno yalnyebeꞌ sa ngenonꞌ yalnaban adiꞌ por Jesucrist Xaꞌ nyebeꞌ lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Cho kwan gab naꞌ? ¿Cho ndablo tadka lin' jwan' narax sa xyen yalwen chanꞌ Dios? ");
INSERT INTO ztp_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","¡Ngen naꞌnakte! Tak re naꞌ jwanꞌ ngujla lo yalke ¿Xomod yoban naꞌ lo yalke tedib gob? ");
INSERT INTO ztp_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","¿Cho naꞌnyed goꞌ, reta naꞌ jwanꞌ ta mbroꞌle lo le Jesucrist, lo senꞌ mbroꞌlenꞌ zya nguj naꞌ jwan' xa nguj Xaꞌ? ");
INSERT INTO ztp_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Tak senꞌ mbro'lenꞌ zya thita mbwaꞌs naꞌ kon Crist nde nguj naꞌ sa ryoꞌxban naꞌ nde kenonꞌ yalnaban kub, ta xaja mbroꞌxban Crist kon yalnaro nde yalne chanꞌ Xud naꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Tak tez thita nak naꞌ kon Crist, nguj naꞌ xa nguj Xaꞌ, tagaꞌ ryoꞌxban naꞌ xa mbroxban Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Mnenꞌ leꞌ reta jwan' narax nak na' pola thita mkey lo kruz kon Crist, sa lux reta jwanꞌ narax ta nak na' nde thiptane na'litra' naꞌ sin' lo jwanꞌ narax. ");
INSERT INTO ztp_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Tak men jwanꞌ ngujla kon Crist, nanyebetra' jwan' narax lo men. ");
INSERT INTO ztp_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nde tez nguj naꞌ kon Crist, ndlipa lazon' thita ban naꞌ kon Xaꞌ, ");
INSERT INTO ztp_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","tak mnenꞌ, lo mbroꞌxban Crist xij re men nguj, naꞌngajtraꞌ Xaꞌ, tak yalguj naꞌnyabeꞌtraꞌ lo Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Tak lo nguj Crist, thipta gob nguj Xaꞌ por xken reta men nde naya lo naban Xaꞌ, naban Xaꞌ par Dios. ");
INSERT INTO ztp_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nde tagaꞌ goꞌ, ptob xgab goꞌ ngujla goꞌ par lo reta jwanꞌ narax nde naban goꞌ par Dios la ta thita nak go' kon Jesucrist, Xaꞌ Nyebeꞌ lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Jwanꞌ nasa, naꞌtad goꞌ diꞌs nyebeꞌ re jwanꞌ narax lo belꞌ goꞌ jwanꞌ ta ndluxa, nekla xobyek go' re jwan' narax ndryo' lazo' bel' go'. ");
INSERT INTO ztp_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nekla tayaꞌ goꞌ belꞌ goꞌ lo jwanꞌ narax sa liy sinꞌ lo re jwanꞌ xkap. Cheꞌla ptayaꞌ lazoꞌ goꞌ lo Dios xajka thi men jwanꞌ ngujla nde bere mbroꞌxban. Ptayaꞌ lazoꞌ goꞌ lo Dios sa li goꞌ sinꞌ lo jwanꞌ wen. ");
INSERT INTO ztp_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Tak re jwanꞌ narax naꞌnyebeꞌtra'y lo goꞌ, tak naꞌnzotra' goꞌ lo ley, che'la leꞌ goꞌ nzo lo yalwen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","¿Cho kwan linꞌ sa? ¿Cho tatka linꞌ jwan' narax ta naꞌnzot naꞌ lo ley, che'la nzon' lo yalwen chanꞌ Dios? ¡Naꞌnaktey tamod! ");
INSERT INTO ztp_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","¿Cho naꞌmned goꞌ, tez lya goꞌ lo yaꞌ ti men sa ke goꞌ sinꞌ lo xaꞌ nde xobyek goꞌ xaꞌ, zyasa nak go' mos lo xa' ta nxo'byek go' ya? tagaꞌ jwanꞌ reꞌ, tez xo'byek go' jwan' narax xaja xa' nyebe' lo go', jwan' na ndeno yalguj o xobyek goꞌ Dios sa yan' go' men gal' lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Per dyuxkix Dios, tak tenyega ngok goꞌ men mbli sinꞌ lo jwanꞌ narax nde naya dib nzo lazoꞌ goꞌ nxobyek goꞌ jwanꞌ mbloꞌ náꞌ lo goꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nde thiptane mblyaꞌ goꞌ lo yalke sa naya nak goꞌ men ndli sinꞌ lo jwanꞌ galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Nambi goꞌxkan na jwanꞌ reꞌ lo goꞌ, tak tata nala xgab go' yen go'y.) Ta xa nera ben'ta re jwanꞌ bew, yalxinlaꞌs mbix go', nde naya taxa ndablo bix goꞌ par ban go' mod gal' nde thiptane yan goꞌ men nayon lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Tak zya sen' ngok go' men ndli sinꞌ lo jwanꞌ narax, nandeched go' ban go' xa ndryo' lazo' Dios. ");
INSERT INTO ztp_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Per ¿Cho kwan mbli goꞌ gan lo re jwanꞌ narax ta mbli goꞌ sa? Nde naya ndyolaꞌs goꞌ. Tak jwanꞌna benꞌta yalguj ndenoy. ");
INSERT INTO ztp_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Tak naya ta mblyaꞌa goꞌ lo re yalke nde nak goꞌ men ndli sinꞌ lo Dios, jwanꞌna ngoxoꞌba goꞌ nak goꞌ men nayon lo Dios nde keno goꞌ yalnaban adiꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Tak jwanꞌ ndli men gan lo yalke nak yalguj nde leꞌ jwanꞌ ndalaꞌs Dios nak yalnaban adiꞌ kon Jesucrist, Xaꞌ Nyebeꞌ lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Wes na, ptan na, cho nanyeda go' le' ley nyebeꞌy lo men laj naban men, (lo men nzolo ley ngenin). ");
INSERT INTO ztp_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ta xa thi ngol ta mselyaꞌ ba, ley nyebeꞌ xobyek ngol salꞌ ngol laj naban xaꞌ, per tez nguj xaꞌ zya mblyaꞌ ngol lo ley jwanꞌ nyebeꞌ ndobno ngol salꞌ ngol. ");
INSERT INTO ztp_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Mbay tez benꞌ naban salꞌ ngol nde ka ngol tedib xaꞌ zyasa yalke nak jwanꞌ ngeli ngol, per tez nguj salꞌ ngol zya mblyaꞌ ngol lo ley ya nde toyal ka ngol tedib xaꞌ biꞌ, nde jwanꞌna naꞌnakte yalke. ");
INSERT INTO ztp_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Tagaꞌ goꞌ wes na, ptan na, lo ta nguj Crist lo kruz, noga' go' nguj go' lo ley, sa ak goꞌ chan' Crist, Xaꞌ ta mbroꞌxban xij re men nguj, tamod sa ryo'xob re jwan' wen li go' par Dios. ");
INSERT INTO ztp_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Tak pola laj senꞌ benꞌ ngete'n lo jwan' ncholaꞌs belꞌ naꞌ, reta jwan' narax ta ngoxkwen' ley len' lazonꞌ, ndliy gan lon' nde ngobnyoy na' lo yalguj. ");
INSERT INTO ztp_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Leꞌ naya mbro'xak na' lo ley ta nyebe' lon', lo ta nguj na', sa linꞌ sinꞌ lo Dios kon yalnaban kub por Mbi Nayon nde naꞌlitraꞌ naꞌ mod gox xa nyebe' ley. ");
INSERT INTO ztp_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","¿Cho kwan gab naꞌ sa? ¿Cho narax nak ley? ¡Ngen, naꞌnaktey! Tak tez naꞌngenta ley pa yolon cho nzo jwan' narax, tak taga' pa nyen kwan' nak yaltabla's, tez naꞌnchabta lo ley: “Naꞌtyablaꞌsta la chanꞌ men.” ");
INSERT INTO ztp_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Leꞌ yalnarax, mbli rsinꞌna yalnyebeꞌ chanꞌ ley nde mbloꞌxoꞌba yaltablaꞌs lenꞌ lazoꞌn tak tez naꞌngenta ley, leꞌ yalnarax nguja. ");
INSERT INTO ztp_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ngo ti tyemp mketeꞌn sinta ley, nde senꞌ mzin yalnyebeꞌ mbro'xob yalke, nde nguj na. ");
INSERT INTO ztp_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Tamod sa mbyen na, leꞌga yalnyebeꞌ ta ndablo taꞌ yalnaban lon, ngolala yalguj lon. ");
INSERT INTO ztp_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Tak jwanꞌ narax mbli rsinꞌna yalnyebeꞌ, mkwinꞌnoy na nde kon yalnyebeꞌ mbija na. ");
INSERT INTO ztp_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tamod sa ngwi'n liga leꞌ ley nayon naka nde leꞌ yalnyebeꞌ nayona, galꞌ naka nde wena. ");
INSERT INTO ztp_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Mbay ¿Cho jwanꞌ wena mbyeꞌd ngok yalguj lon sa? ¡Ngen, naꞌnakte! Le' jwanꞌ naraxa, par lo'y liga jwan' narax toz naka mbli sin' na jwan' wen sa mbija na. Nde tamod, por yalnyebe' mblo' xa nakap toz nak jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tak mnenꞌ leꞌ ley xki's Dios naka, nde leꞌ na men na, nadon lo jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Tak nayenta na re jwan' ndlin, naꞌndlit na re jwanꞌ ncholas na, cheꞌla re jwanꞌ naꞌncholasta na jwanꞌna ndlin. ");
INSERT INTO ztp_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Nde tez jwanꞌ naꞌncholaꞌsta na jwanꞌna ndlin, mnen ke wen nak ley. ");
INSERT INTO ztp_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Jwanꞌ nasa naꞌnakta na ndli re jwan' na, cheꞌla re jwanꞌ narax nzo lazoꞌn ndliy. ");
INSERT INTO ztp_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tak mnen jwan' ndya'bla's bel' na re', naꞌngenta yalwena, tak ndyen na lin jwan wen, per naꞌlit na gan li ney. ");
INSERT INTO ztp_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Tak naꞌndlit na jwanꞌ wen ta ncholas na, cheꞌla leꞌn ndli re jwanꞌ narax ta naꞌncholasta na lin. ");
INSERT INTO ztp_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nde tez lin jwanꞌ naꞌncholasta na, naꞌnakta na ndliy, cheꞌla jwanꞌ narax nzo lazoꞌn jwanꞌna ndliy. ");
INSERT INTO ztp_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Tenye' nchola's lin jwan' wen, nchozi'b na ley re', ben'ta jwan' narax ndonon. ");
INSERT INTO ztp_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Axta na's len' lazoꞌn ndyen na ley chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Per ngwiꞌn nzo ti ley jwan nyebeꞌ lo dib ben na, ndyosay lo ley jwan' nzo yek na, nde ndago'bnyoy na lo jwan' narax nzo dib ben na. ");
INSERT INTO ztp_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","¡Pro'b na re'! ¿Cho tolaꞌn lo jwan' nchola's bel' na liy, ta ndago'bnyoy na lo yalguj? ");
INSERT INTO ztp_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ndan dyux lo Dios Por Jesucrist Xaꞌ Nyebeꞌ lon. Leꞌ naya, kon xgab na lin sinꞌ lo ley chanꞌ Dios, per le' jwan' ncholas' bel' na, jwan'na ndli sa ndlin sin' lo jwan' narax. ");
INSERT INTO ztp_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Mbay naya na, re men ta ndono Jesucrist nekthib yalke nazobta xis xa', re men jwanꞌ naꞌngeteda xa ncholaꞌs belꞌ naꞌ, cheꞌla ngete xa' xa ncholaꞌs Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Tak ley chanꞌ Mbi Nayon ndaꞌy yalnaban lo ndononꞌ Jesuscrist, jwanꞌna mxa'ka na lo ley chanꞌ yalke nde lo yalguj. ");
INSERT INTO ztp_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Tak Dios mbli jwan' na'ngakta ndli ley, tak nala men nalid men gan la' men re jwan' narax, lo mtelꞌ Dios Xinꞌ Xaꞌ mbyeꞌd lo izyo, xajka ti mena nzo'b xken na' nde por xke re jwan' narax, nguj Xa' sa mdi'x Xa' xken reta men. ");
INSERT INTO ztp_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Jwanꞌ reꞌ mbli Dios sa lo na' toyal ak re jwan' gal' nya'b ley, tak naꞌbantraꞌ naꞌ xaja ncholaꞌs belꞌ naꞌ, cheꞌla naban naꞌ xaja ncholaꞌs Mbi Nayon. ");
INSERT INTO ztp_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Tak xa' ta ndli re jwanꞌ narax ncholaꞌs belꞌ xaꞌ, benꞌta re jwanꞌna ndli xaꞌ xgab, leꞌ men ndli re jwanꞌ ncholaꞌs Mbi Nayon, jwanꞌnata ndli men xgab. ");
INSERT INTO ztp_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Tak senꞌ ndli men xgab re jwanꞌ narax ncholaꞌs belꞌ men, ncheꞌy men lo yalguj, leꞌ senꞌ ndli men xgab re chanꞌ Mbi Nayon, naka yalnaban nde yalnabeꞌz. ");
INSERT INTO ztp_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Leꞌ men ta ndli xgab benꞌta re jwanꞌ narax ncholaꞌs belꞌ xaꞌ, xaꞌ ya ngiꞌno xa' Dios, tak naꞌnxoꞌbyekta xaꞌ ley chanꞌ Dios nde nekla li xaꞌ gan li xaꞌy. ");
INSERT INTO ztp_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Jwanꞌ nasa, re men ta naban benꞌta lo re jwanꞌ narax ncholaꞌs belꞌ xaꞌ, naꞌlid xaꞌ gan li xaꞌ jwanꞌ ndryoꞌ lazoꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Leꞌ goꞌ nambantraꞌ lo re jwanꞌ narax xa ncholaꞌs belꞌ goꞌ, leꞌ goꞌ naban xa ncholaꞌs Mbi Nayon, tezka Mbi Nayon chanꞌ Dios nzoy lenꞌ lazoꞌ goꞌ. Nde tez nzo xaꞌ naꞌndonoda Mbi Nayon chanꞌ Crist, xaꞌ ya naꞌnakta men Crist. ");
INSERT INTO ztp_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Tez ndono goꞌ Crist lenꞌ lazoꞌ goꞌ, leꞌ belꞌ goꞌ liga nguja lo yalnarax, nde leꞌ xbin goꞌ nabana tak mblilal Dios goꞌ men galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Nde tez ndono goꞌ Xbin Xaꞌ ta mbli mbroꞌxban Jesus xij re men nguj, leꞌga Xaꞌ ta mbli mbroꞌxban Jesucrist xij re men nguj, Xaꞌ ya ta' yalnaban lo kwerp goꞌ jwanꞌ ta ndluxa, por Xbi chanꞌ Xa' jwanꞌ ndono goꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Jwanꞌ nasa, wes na, ptan na, ngenon' jwan' ndablo lin', per na'nakte lin' re jwanꞌ narax ta ndryoꞌ lazoꞌ belꞌ naꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Tak tez nzo ban goꞌ lo re jwanꞌ narax xa ndryo' lazo' belꞌ goꞌ, taj goꞌ; per tez kon Xbin Dios li goꞌ lux reta jwanꞌ narax ndryoꞌ lazoꞌ belꞌ goꞌ, zyasa ban goꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Re men jwanꞌ ndaꞌ diꞌs sa Xbin Dios koneda xaꞌ, re men ya nak xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Tak naꞌmdaꞌd Dios lo goꞌ ti xbi jwanꞌ taꞌtiy goꞌ sa li goꞌ sinꞌ lo neꞌy nde zyeb goꞌ tedib gob, cheꞌla Dios mdaꞌ lo goꞌ ti Xbi jwanꞌ mbli sa ngok goꞌ xinꞌ Dios. Nde Xbi ya ndli sa mbez naꞌ lo Dios: “¡Xud na, pay!” ");
INSERT INTO ztp_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Leꞌga Xbin Dios, ndeja lo xbin naꞌ, ke nak naꞌ xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Tak lo nak naꞌ xinꞌ Dios, noga naꞌ ndablo kayaꞌ jwanꞌ taꞌ Dios nde jwanꞌ reꞌ thita keno neꞌy kon Crist, tak tez naya thita ndridndaꞌb naꞌ yalti kon Crist, yoloba nonꞌ kayaꞌ yalnaro chanꞌ Crist. ");
INSERT INTO ztp_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nde jwanꞌ mnepa na, leꞌ re yalti ta ndoriꞌd naꞌ naya, lud tira tez katalal mena kon yalnaro jwanꞌ winꞌ taꞌ Dios lonꞌ yoloba. ");
INSERT INTO ztp_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Tak re jwanꞌ ta mdoxkwaꞌ Dios, che'pa ngembed na, ncholaꞌsa ryoꞌto re men jwanꞌ nak xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Tak reta jwanꞌ mdoxkwaꞌ Dios nangelide re jwanꞌ ndablo liy, per naꞌnakte tak ta ncholaꞌsa, cheꞌla leꞌga Dios tamod mtanꞌ Xaꞌy, per thiblaꞌ ngembeda lyaꞌy, ");
INSERT INTO ztp_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Tak noga' re' jwanꞌ mtoxkwaꞌ Dios nakinꞌ lyaꞌy lo yaꞌ jwanꞌ nzoyay nde jwanꞌ li luxa, sa noy lya' wiz naro toz jwanꞌ tola' Dios re xinꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Tak mnenꞌ dibta naya leꞌ re jwanꞌ ta mdoxkwaꞌ Dios mbez yisa nde ndoba lo yob xaja ngol ta ndob lo yis tana. ");
INSERT INTO ztp_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nde naꞌnakte benꞌta jwanꞌna ta ndyak, noga re naꞌ ta ndyak, tenye nerla na' mkaya' Xbin Dios. Noga naꞌ mbez yis naꞌ ngembed naꞌ kayaꞌ Dios naꞌ ak xinꞌ Dios, nde lilal Dios kwerp naꞌ ti kwerp kub. ");
INSERT INTO ztp_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Tak lo mgembed naꞌ, jwanꞌ nasa mblyanꞌ, per tez ngwiꞌla na' jwanꞌ ngembed na', jwanꞌna naꞌnaktray jwanꞌ ngembed na', tak ¿Xa kwed men ti jwanꞌ ngwiꞌa men? ");
INSERT INTO ztp_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Mbay tez naꞌngwid naꞌ jwanꞌ ngembed naꞌ, ndablo xek naꞌ sowꞌ kwed naꞌy. ");
INSERT INTO ztp_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nde tagaꞌ, leꞌ Xbi chanꞌ Dios ndlaꞌstoy naꞌ senꞌ nala nzo lazonꞌ. Tak naꞌnyed naꞌ xomod todiꞌsnonꞌ Dios jwanꞌ xa ndabloy, per le' Mbi Nayon nyaꞌba lo Dios por naꞌ, mbez nabila kon bi naꞌyenta men. ");
INSERT INTO ztp_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Leꞌ Dios, Xaꞌ jwanꞌ nzolo lazoꞌ reta men, mne Dios jwanꞌ ndej Mbi Nayon, tak Mbi Nayon nyaꞌba jwanꞌ xa ncholaꞌs Dios par reta men jwanꞌ nak yez Nayon chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tan mnenꞌ reta men ta nkeꞌ lazonꞌ Dios, lo reta jwan' ndla'sto Dios men par yalwen, jwan' re' nak xa' jwan' mbrez Dios axa nak xgab Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Tak re men jwan' mbyolola Dios azta nera', mke'be'la Dios xa' sa ak xa' xata nak xin' Dios nde leꞌ Xinꞌ Dios ak Xaꞌ ner lo xij bro toz wes xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Nde re xaꞌ mke'bela Dios, re xaꞌ ya mbrez Dios, nde re xaꞌ jwanꞌ ta mbrez Dios, xa' ya mblilal Dios xaꞌ men galꞌ nde re xaꞌ ta mblilal Dios men galꞌla, xaꞌ ya mbli naro Dios. ");
INSERT INTO ztp_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","¿Cho kwanraꞌ gab naꞌ lo jwanꞌ reꞌ? Tez Dios ndono naꞌ, ¿Cho li gan lonꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Tak tez naꞌmkad Xaꞌ Xinꞌ Xaꞌ, cheꞌla mdaꞌyaꞌ Xaꞌ Xinꞌ Xaꞌ lo yalguj por reta naꞌ, ¿Xomod nataꞌ Xa' nde kon Xin' Xa' reta jwanꞌ lonꞌ sa? ");
INSERT INTO ztp_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","¿Cho xaꞌ keꞌ yalke yek re men ta mblíla Dios? Dios ndli sa nchanꞌ men xaꞌ galꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","¿Cho xaꞌ li sa yathix men xken men? Crist nak Xaꞌ nguj, nde naꞌnakte benꞌ jwanꞌna, noga mbroꞌxban Xaꞌ nde naya ndob Xaꞌ lad ban Dios nde tagaꞌ ngenaꞌb Xaꞌ lo Dios por naꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","¿Cho li gan sikeꞌ tij naꞌ lo ta ke'lazo'Crist na'? ¿Yaltiy o yalnabila, senꞌ nchubla xaꞌ na', wina, senꞌ naꞌngenta xab na'y, yalnathoza, o yalguja? ");
INSERT INTO ztp_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ta xa nchabka lo xkiꞌs Dios: Lo ta ndli lazoꞌ náꞌ lu reta wiz nzo náꞌ ro yalguj. Ndlino men náꞌ xaja ndlino men mbakxilꞌ ta kuj mena. ");
INSERT INTO ztp_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Tenye ndoriꞌd naꞌ lo reta jwanꞌ reꞌ, naꞌ jwanꞌ mas mbli gan mbroꞌxob kon Jesucrist Xaꞌ jwanꞌ nkeꞌ lazoꞌ naꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Jwanꞌ nasa, mnetir na, nekla yalguj, nek yalnaban, nek re anj, nek re yalnyebeꞌ nde yalne chanꞌ re mbi narax, nek re jwanꞌ nzo naya, nek re jwanꞌ nara yeꞌd, ");
INSERT INTO ztp_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nek re jwanꞌ mas gap ndaꞌb, nek re jwanꞌ mas naꞌs nde nek thib reta jwanꞌ ta nzo reꞌ, naꞌlide gan sikeꞌ tija naꞌ lo jwanꞌ nkeꞌ lazoꞌ Dios naꞌ por Jesucrist Xaꞌ Nyebeꞌ lonꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Li jwan' ndej na tak ndli lazo'n Crist, naꞌnkwiꞌnta na, tak xgab na nde Mbi Nayon ndeja lon, ");
INSERT INTO ztp_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","nabil toz ndyak na nde thibla nchow lazoꞌn. ");
INSERT INTO ztp_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Tak leꞌga na, ndya'bla's na xyoꞌ bde xis na nde tij tyon lo Crist, tezka jwanꞌna li wen lo re wes na nde lo re men tan. ");
INSERT INTO ztp_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Re xaꞌ ya nak xaꞌ men nde lo bin Israel, mblilal Dios xaꞌ xinꞌ Dios, mdo Dios xij xaꞌ kon yalnaro chanꞌ Dios, mdaꞌ Dios xkiꞌs Dios lo xaꞌ, mdaꞌ Dios ley lo xaꞌ, sa ak xaꞌ men li naro Dios nde mkeꞌyek Dios jwanꞌ lo xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Re xaꞌ ya ta nde lo bin chanꞌ re xaꞌ gox lonꞌ ngo pola nde lo bin ya ngol Crist, jwanꞌna nak lo izyo reꞌ, per Xaꞌ ya nak Dios lo reta jwanꞌ, dib adiꞌ Nayon nak Xaꞌ. Ta aka. ");
INSERT INTO ztp_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Nde naꞌgabta naꞌ mbwan xki's jwanꞌ mkeꞌyek Dios lo men Israel, tak naꞌnakta re men jwanꞌ nde lo bin Israel nak xa' men Israel. ");
INSERT INTO ztp_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Nekla re xaꞌ jwanꞌ nde lo bin Abraham nak xin Dios, tak Dios nchab: “Lo Isaak yeꞌd re men jwanꞌ ak bin la”. ");
INSERT INTO ztp_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Jwanꞌ reꞌ ndloꞌ lonꞌ, naꞌnakte benꞌta yeꞌd men ti lo bin xaꞌ lo izyo sa ak men xinꞌ Dios, cheꞌla re xaꞌ jwanꞌ nde lo bin jwanꞌ mkeꞌyek Dios, re xaꞌ ya nak xinꞌpa Dios. ");
INSERT INTO ztp_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Tak jwanꞌ reꞌ mke' yek Dios lo Abraham, nchab Xaꞌ: “Senꞌ beren tedib linꞌ, Sar keno ti xinꞌ bi' naꞌ.” ");
INSERT INTO ztp_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Nde naꞌnakte benꞌta jwanꞌna, tagaꞌ ngotey kon Rebek thipta xud rop mdyen' xa' ya nak Isaak xaꞌ gox lonꞌ ngo pola. ");
INSERT INTO ztp_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Senꞌ tera gal rop or, nekla teraꞌ lir jwanꞌ wen nde jwanꞌ narax, sa jwan' ndli Dios xgab jwan' xa mbí Dios men na'zye'dey, ke naꞌnankte por lo jwanꞌ ndli men, che'la por Dios Xa' jwan' mbez mena. ");
INSERT INTO ztp_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Nde nchab Dios lo Rebek: “Or ner, or ya li sinꞌ lo or xis.” ");
INSERT INTO ztp_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Xa nchabka lo xkiꞌs Dios, mkeꞌ lazoꞌn Jacob nde mbloꞌtal na Esaú. ");
INSERT INTO ztp_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","¿Cho kwan gab naꞌ? ¿Cho nagalꞌta nak jwanꞌ ndli Dios? Naꞌnakte jwanꞌna. ");
INSERT INTO ztp_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Tak lo Moisés nchab Dios: “Lin wen lo men jwanꞌ ncholas na lin wen nde tagaꞌ lat lazoꞌn men jwanꞌ ncholas na lat lazoꞌn.” ");
INSERT INTO ztp_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Jwanꞌ nasa, naꞌnakte jwanꞌ xa ncholaꞌs men, nekla men jwanꞌ ndaꞌ goba, cheꞌla Dios mbí Xaꞌ men jwanꞌ ndlat lazoꞌ Xaꞌ ");
INSERT INTO ztp_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Tak lo xkiꞌs Dios ngeni, tenꞌ nchab Dios lo Faraón: “Jwanꞌ naga sa mdob na lu ak la rey sa kon lu loꞌn yalne chanꞌ na nde reta men lo izyo yolo xaꞌ na”. ");
INSERT INTO ztp_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Jwanꞌ nasa, ndlat lazoꞌ Dios men jwanꞌ ncholaꞌs Diosꞌ lát lazoꞌ Dios, nde ndli ne Dios lazoꞌ men jwanꞌ ncholaꞌs Dios li ne Dios lazoꞌ xa'. ");
INSERT INTO ztp_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Leꞌ lu nye lon: “Tez ta naka, ¿Kwan liy nke' Dios yalke yek men tez nangencho li gan tow' lo jwan' nchola's Dios li Dios?” ");
INSERT INTO ztp_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","¡Le' lu mbiꞌ! ¿Cho nak la sa tyosa' lo Dios lo re jwanꞌ ndli Dios? Xa ti yet yoba, cho taba lo xaꞌ jwanꞌ mdoxkwaꞌy: “¿Kwan liy sa tamod mdoxkwaꞌa na?” ");
INSERT INTO ztp_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Leꞌ xaꞌ ndoxkwaꞌ yet yo ¿Cho naꞌakta lino xaꞌ yo min ya mod nda lazoꞌ xaꞌ, leꞌga yo ya toxkwaꞌ xaꞌ chop yet, tiba par sin' nambi nde tediba par sin bew. ");
INSERT INTO ztp_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Taxa mod ncholaꞌs Dios loꞌ Dios lo men, yalnayiꞌ nde yalne chanꞌ Xaꞌ, jwanꞌ nasa mxek toz Dios re men jwanꞌ nzalꞌ rid yalti nde men nzalꞌ lux. ");
INSERT INTO ztp_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Nde mbli Dios jwanꞌna sa loꞌ yalnaro jwanꞌ nak xni chanꞌ Dios, taxa mbli Dios kon xa' jwan' mblat lazoꞌ Dios, re xa' jwan' ax mtanla Dios sa no xa' kayaꞌ yalnaro toz chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Jwanꞌ nasa noga' na' mbrez Dios, nanaktey ben'ta re men judíy noga re men nanakta judiy. ");
INSERT INTO ztp_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ta xa nchabka lo yeꞌs mkeꞌ Oseas: Yez jwanꞌ naꞌnakta yez na, goꞌle ney yez na, nde yez jwanꞌ nankeꞌd lazoꞌn, keꞌ lazoꞌ ney. ");
INSERT INTO ztp_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Nde tenꞌ ne Xaꞌ lo goꞌ: nanakta go' yez na, Tya nye Xa' lo go: goꞌ nak xinꞌ Dios naban. ");
INSERT INTO ztp_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nde noga Isaías mdej xaꞌ yez Israel, nchab xaꞌ: “Tez xaja nzi yux ro nittoꞌ ba nak re xin' yes Israel, be'nta lud xaꞌ jwanꞌ lyaꞌ, ");
INSERT INTO ztp_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Tak ndoyen tozla nya'b Xaꞌ Nyebeꞌ kwent ti mod galꞌ, dib nax xis izyo.” ");
INSERT INTO ztp_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nde xa nchabka Isaías zya: Tez Xaꞌ jwanꞌ ngeno dib yalnyebeꞌ ro naꞌntanꞌta Xaꞌ bin naꞌ, naya ngyanꞌ naꞌ xa ngok Sodom nde Gomorr. ");
INSERT INTO ztp_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","¿Cho kwan gab naꞌ lud? ke re xaꞌ jwanꞌ naꞌnakta men judi, xaꞌ na'nkwan'ta tyo galꞌ lo Dios, mbli xa' gan ngol xa'y, tak mbli lazo' xa' Dios. ");
INSERT INTO ztp_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Mbay leꞌ re men yez Israel mchal xaꞌ ndli xaꞌ re jwanꞌ nchab ley sa yanꞌ xaꞌ men galꞌ, nde naꞌngalta xa'y. ");
INSERT INTO ztp_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","¿Cho kwan liy sa? Tak leꞌ xaꞌ nchola's yan' gal' lo ndli xa' ley nde na'ndlid lazo' xa' jwan' nasa mcheb xa' “ke jwanꞌ cheb men” ");
INSERT INTO ztp_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","jwan' xa ngeni lo xkiꞌs Dios: Bwiꞌ goꞌ nea, lenꞌ yez Sión tob na ti ke jwanꞌ cheb men, nde ke ya li sa yub men. nde men jwanꞌ li lazonꞌ ke ya, naryoꞌyanthod men. ");
INSERT INTO ztp_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Wes na, ptan na, jwan' ncholas na nzo lazo'n nde jwan' nya'b na lo Dios por re men Israel, sa lya' xa'. ");
INSERT INTO ztp_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nde mnen xa nak xaꞌ, no thoz lazo' xaꞌ li xaꞌ jwanꞌ ncholaꞌs Dios, per na'ndlid xa'y jwan' xa nakpe'y. ");
INSERT INTO ztp_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Tak naꞌyenta xa' mod ndli Dios sa ncholal men men gal', jwan'na nkwan' xa' mod xa' aka nde nanxobyekta xa' mod jwan' mtan'la Dios aka. ");
INSERT INTO ztp_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Tak Crist mbli sa ngota'b ley, sa reta men jwanꞌ ndli lazonꞌ Crist yanꞌ xaꞌ men galꞌ lo Dios. ");
INSERT INTO ztp_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mbay le' re men jwan' nchola's yan' gal' kon ley, che' mod mke' Moises “Men xobyek ley, lo ley ban xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Per leꞌ re men jwanꞌ yan' gal' lo ndli lazoꞌ xa' nchaba “Naꞌlit la xgab lenꞌ lazoꞌa: ¿Cho yap lo beꞌ? —tak jwanꞌna nak ngebez men lya Crist lo izyo—; ");
INSERT INTO ztp_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","nekla lia xgab: ¿Cho lya ten' nzo re xa' nguj?” —sa li xa' ryo'te Crist xij re xaꞌ nguj. ");
INSERT INTO ztp_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Mbay ¿Cho kwanka nchab Moisés? “Gax loa ndo xkiꞌs Dios, roa nde lazoꞌa nzoy.” Diꞌs reꞌ jwanꞌ ta ndej náꞌ lo go' ta ndli lazon'. ");
INSERT INTO ztp_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Tez kon diꞌs roa tej la leꞌ Jesus nak Xaꞌ Nyebeꞌ nde li lazoꞌa leꞌ Dios mbloꞌxban Jesus xij re xaꞌ nguj, zyasa lyaꞌa. ");
INSERT INTO ztp_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Tak kon lazoꞌ men ndli lazoꞌ men sa nchanꞌ men, men galꞌ lo Dios, nde kon ro men tej mena sa lya' men. ");
INSERT INTO ztp_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Xa nchabka lo xkiꞌs Dios: “Reta men jwanꞌ ndli lazonꞌ Jesucrist, naryoꞌyanthod men.” ");
INSERT INTO ztp_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Tak lal nak reta men lo Dios, one cho men judíy o men naꞌnakta judí, tak thipta Dios nak Xaꞌ Nyebeꞌ lo reta men, nde Xaꞌ ndaꞌ brotoza lo men jwan' nyeke' lo Xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","“Tak reta men jwanꞌ nyeke' lo Xaꞌ Nyebeꞌ, men ya lyaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","¿Xomod, nyeke' xa' lo ti Xaꞌ jwanꞌ teraꞌ li lazoꞌ xa'? ¿Nde xomod li lazoꞌ xa' ti Xaꞌ jwan' tera gon xa' nzo? ¿Nde xomod gon xa' Xaꞌ tez ngenta cho tej xkiꞌs Xaꞌ lo xa'? ");
INSERT INTO ztp_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Mbay ¿Xomod tej men xkiꞌs Xaꞌ ya tez ngenta cho telꞌ men? Ta xa nchabka lo xkiꞌs Dios: “¡Xa nawe naka yotu re xa' ta ndetej yalnabeꞌz, re xa' ta ndetej diꞌs wen chanꞌ Jesucrist!” ");
INSERT INTO ztp_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Nde naꞌnakta re xa' nxo'byek diꞌs wen chanꞌ Jesucrist, ta xa nchab Isaías: “Xaꞌ Nyebeꞌ, ¿Cho mbli lazonꞌ di's kub ta mdej ná' ba?” ");
INSERT INTO ztp_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Jwanꞌ nasa, par lipa lazoꞌ men Dios nakin' nerla gon mena, nde le' jwanꞌ ta nchon mena nak xkiꞌs Jesucrist. ");
INSERT INTO ztp_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Leꞌ na nyabdiꞌs: ¿Cho nyea teraꞌ gon xaꞌ xkiꞌs Dios? ¡Mbinla xaꞌy! Tak lo xkiꞌs Dios nchab: Dib nax izyo mbyen mni xaꞌ, Nde axta ploja ndib izyo nzin xkiꞌs xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nyabdiꞌs na tedib gob: ¿Cho teraꞌ nye re xaꞌ Israel jwanꞌ reꞌ? Jwanꞌ ner nchab Moíses nak: Na li sa lya yalno lazoꞌ goꞌ kon tedib ned men naꞌnakta yez na Nde na li sa lya naxí lazoꞌ goꞌ kon tedib ned men jwanꞌ ne yek na. ");
INSERT INTO ztp_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nde noga nchab Isaías: Re xaꞌ jwanꞌ naꞌnkwanꞌta na, mzyal xaꞌ na, Nde mbroꞌton lo re xaꞌ jwanꞌ nanyaꞌbdiꞌsta xaꞌ na. ");
INSERT INTO ztp_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Nde senꞌ mdej Isaías re xaꞌ Israel, nchab Isaías: “Dib wiz mdaꞌb yaꞌn lo ti yez ne yek naꞌ nde yez naꞌnchonta diꞌs.” ");
INSERT INTO ztp_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Nde naya nyabdiꞌs na, ¿Cho mblo'tal Dios yez Dios? Naꞌmbloꞌtalta Xaꞌy. Tak noga na nak men yez Israel, lo bin chanꞌ Abraham nde bin chanꞌ Benjamín. ");
INSERT INTO ztp_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nambloꞌtalta Dios yez Dios, jwanꞌ mblí Dios axta pola. ¿Cho naꞌnyed goꞌ kwan nchab xkiꞌs Dios lo ndeja kwent chanꞌ Elías, senꞌ mdej Elías lo Dios reta jwanꞌ ndli yez Israel? Sa nchab Elías: ");
INSERT INTO ztp_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Xaꞌ Nyebeꞌ, mbij men re xaꞌ nak profet la, nde noga mpsil xaꞌ re tenꞌ ntolꞌ xaꞌ jwanꞌ yon loa, benꞌ na mbyanꞌ nde ncholaꞌs xaꞌ kuj xaꞌ na.” ");
INSERT INTO ztp_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Leꞌ Dios mkab: “Mbloꞌxaꞌn ti gaz mil men par na, xaꞌ jwanꞌ naꞌndoxubta lo mnab Baal.” ");
INSERT INTO ztp_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Tagaꞌ naya, ben' nzo lud men Israel jwanꞌ mbyanꞌ mblí Dios lo yalwen chanꞌ Dios. ");
INSERT INTO ztp_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Nde lo yalwen chanꞌ Dios mbli Dios jwanꞌ reꞌ, naꞌnaktey jwanꞌ ndli leꞌga men, tak tez men ndliy, leꞌ yalwen chanꞌ Dios naꞌnakteꞌy yalwen. ");
INSERT INTO ztp_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","¿Cho kwan gab naꞌ sa? Re xaꞌ Israel naꞌngasalta xaꞌ jwanꞌ nkwanꞌ xaꞌ, per re xaꞌ jwanꞌ mblí Dios, mzyal xaꞌ jwanꞌ nkwanꞌ xaꞌ nde temasraꞌ xaꞌ ngok ne lazoꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Xa nchabka lo xkiꞌs Dios: “Dios mdaꞌ xbi jwanꞌ ndli ne lazoꞌ xaꞌ, ndob ngud lo xaꞌ nde naꞌngwid xaꞌ, ndob nza xaꞌ nde naꞌnchonta xaꞌ diꞌs nde axta wiz naya ta nak xaꞌ.” ");
INSERT INTO ztp_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Leꞌ David nchab: Re ni jwanꞌ ndli xaꞌ yolala koꞌ nde yolala yex jwanꞌ yoga xaꞌ, Sa cheb xaꞌ nde rid xaꞌ lo yalti. ");
INSERT INTO ztp_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Kow ngud lo xaꞌ sa nawiꞌd xaꞌ, Nde thiptane lyeng xis xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Leꞌ na nyabdiꞌs: ¿Sen' lo mpcheb re xaꞌ Israel cho thibtane ngob xaꞌ? ¡Naꞌnakte! cheꞌla, por yalneyek chanꞌ re xaꞌ judí sa mblyaꞌ re xaꞌ naꞌnakta judí, sa tamod lya yalno lazoꞌ re xaꞌ judí. ");
INSERT INTO ztp_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Mbay tez lo yalneyek chanꞌ re xaꞌ judi, jwanꞌna mbli yalwen lo reta men, nde lo mblayo re xaꞌ judi, jwanꞌna ngok yalwen lo re men naꞌnakta judi, ¡plopa mas yalwen liy tez re xaꞌ Israel bere li lazo' xaꞌ Dios! ");
INSERT INTO ztp_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Per na ndoni lo re goꞌ ta naꞌnakta men judi. Tak Dios mtelꞌ Xaꞌ na sa tej na xkiꞌs Dios lo re goꞌ ta naꞌnakta judi, nde rsin na re' ntak toza par na. ");
INSERT INTO ztp_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Tak ncholas na, teꞌ tamod pla re men jwan' thita lo bin xa' gox nde na', lya yalno lazoꞌ xaꞌ teꞌd xaꞌ lo goꞌ sa lyaꞌ xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Tak tez lo mbloꞌtal Dios re xaꞌ judi, jwanꞌna mbli sa mtoyal Dios kwent kon re men naꞌnakta judí, ¿Cho kwan yotey tez kayaꞌ Dios re xaꞌ judí tedib gob? Cheꞌla aka yalnaban lo re men nguj. ");
INSERT INTO ztp_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Tez pan ner, taꞌ mena lo Dios naka jwanꞌ yon, noga dib ko'b ngok leyꞌ ya. Nde tagaꞌ, tez lox ya, naka jwanꞌ yon, noga reta xod ya ngok leyꞌ ya. ");
INSERT INTO ztp_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Nzo pla xaꞌ judí jwan' nak xaja xod ya oliv per mchoꞌy nde tenꞌ mchoꞌ tya mbyelꞌl xod ya oliv wan jwan nak lu. Tamod sa thita ngenden la lad lox ya oliv bin nde ngenoa yalnaban jwanꞌ ngeno ya tan. ");
INSERT INTO ztp_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Naꞌaknarod la lo re xodpa ya oliv nde tez nchak naroa, lu mne, naꞌnakta lu ndli sa naye lox, cheꞌla lox ndli sa naye lu. ");
INSERT INTO ztp_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Leꞌ lu gab: “Taga naka, per re xodpa ya oliv mchoꞌy nde tya mbyelꞌ na.” ");
INSERT INTO ztp_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ta naka, mbyiꞌb re xaꞌ ta nak xodpa ya tak naꞌndlid lazoꞌ xaꞌ Dios, nde lu, lo ta ndlipa lazoꞌa jwanꞌ nasa mbyelꞌ la lad ya tan. Nde naya naꞌxyalꞌta la, cheꞌla bzeb lazoꞌa ");
INSERT INTO ztp_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Tak tez re xod jwanꞌ nak xodpa ya oliv na'mbekta lazo' Dios mpcho' Xa'y, tagaꞌ toyal lino Dios goꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Jwanꞌ nasa, bwiꞌ xa wen nak Dios nde noga bwiꞌ plopa ne nak Xaꞌ lo re men jwanꞌ nzoꞌb xken naꞌ, nde leꞌ loa wen nak Xaꞌ. Jwanꞌ nasa ndablo thiblaꞌ tyoa lo yalwen chanꞌ Dios, tak tez naꞌlid le, noa choꞌ Xa'. ");
INSERT INTO ztp_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Mbay axta re xaꞌ judí, tez bere li lazoꞌ xaꞌ Dios, tyelꞌ xaꞌ lad yatan tedib gob, tak naro nak Dios par kinꞌ Xaꞌy lad ya tan tedib gob. ");
INSERT INTO ztp_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Tak tez lu, nak la xod ya oliv wan nde naꞌndabloda yinꞌ la lad ya oliv bin per lada mbyin' la, ¡Cho leꞌtla re men judí jwanꞌ nak xodpa ya oliv bin, bere kyelꞌ Dios xaꞌ tedib gob lad ya oliv bin ten' ndobka xa'! ");
INSERT INTO ztp_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Tak na'ncholasta na wesa, na'yolod go' jwanꞌ nagaꞌs chanꞌ Dios, sa naꞌaknarod xgab goꞌ. Rol xaꞌ Israel ngok ne lazoꞌ xaꞌ, axta kebeꞌ re xaꞌ naꞌnakta judí li lazoꞌ xaꞌ Crist. ");
INSERT INTO ztp_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Senꞌ ngolo jwanꞌna, zyaraꞌ lyaꞌ reta xaꞌ Israel, ta xa nchabka lo xkiꞌs Dios: Yes Sion ryoꞌ Xaꞌ tolaꞌ men, Sa tombi Xaꞌ reta jwanꞌ narax nak re men liz Jakob. ");
INSERT INTO ztp_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Nde jwanꞌ reꞌ ak xkiꞌs na tan lo xaꞌ, Senꞌ lo ton na xken re xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Por yalwen lo goꞌ sa re xaꞌ judí ngiꞌno xaꞌ diꞌs wen chanꞌ Jesucrist, per lo ta mblí Dios xa' tatka nkeꞌ lazoꞌ Dios xaꞌ por re xaꞌ gox lo xa' ta ngo polaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Tak jwanꞌ ndaꞌ Dios naꞌnkipta Xaꞌy nde nekla mbere xgab Dios lo mbrez Dios xaꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Tak taga' nak go' neraꞌ naꞌmxobyekta goꞌ Dios, nde naya lo ta naꞌmxobyekta re xaꞌ Israel Dios, mblat lazoꞌ Dios goꞌ. ");
INSERT INTO ztp_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nde tagaꞌ, leꞌ naya re xaꞌ Israel naꞌmxobyekta xaꞌ Dios, sa tamod mblat lazoꞌ Dios goꞌ nde noga lat lazoꞌ Dios re xaꞌ Israel. ");
INSERT INTO ztp_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Tak Dios mbli sa ngok ne yek reta men, sa tamod thipta lyat lazoꞌ Dios reta men. ");
INSERT INTO ztp_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","¡Plopa naro nak yalrik chanꞌ Dios jwanꞌ nak yalnchak chanꞌ Xaꞌ nde re jwanꞌ nchen Xaꞌ! Ngenta cho men li gan koxkan re jwanꞌ ndli Dios nde ngen cho li gan yen re xned Dios. ");
INSERT INTO ztp_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Tak “¿Cho xaꞌ mbyenla re jwanꞌ nak xg