﻿USE sofia;
DROP TABLE IF EXISTS sofia.zsrNT_vpl;
CREATE TABLE zsrNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zsrNT_vpl WRITE;
INSERT INTO zsrNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni uzujaꞌ laquëꞌ xuz xnaꞌ gul gdöd queëꞌ Jesucristo, naquëꞌ zxiꞌn xsoëꞌ David, lencaꞌ zxiꞌn xsoëꞌ Abraham. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham guquëꞌ xuzëꞌ Isaac. Isaac guquëꞌ xuzëꞌ Jacob. Jacob guquëꞌ xuzquëꞌ Judá len yuguꞌ bönniꞌ böchëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá guquëꞌ xuzquëꞌ Fares len Zara, atiꞌ Tamar gucnu xnaꞌquëꞌ. Fares guquëꞌ xuzëꞌ Esrom. Esrom guquëꞌ xuzëꞌ Aram. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram guquëꞌ xuzëꞌ Aminadab. Aminadab guquëꞌ xuzëꞌ Naasón. Naasón guquëꞌ xuzëꞌ Salmón. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón guquëꞌ xuzëꞌ Booz, atiꞌ Rahab gucnu xnëꞌë. Booz guquëꞌ xuzëꞌ Obed. Rut gucnu xnëꞌë Obed naꞌ. Obed guquëꞌ xuzëꞌ Isaí. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí guquëꞌ xuzëꞌ David. David naꞌ gna béꞌinëꞌ bunách Israel, atiꞌ butság náꞌlenëꞌ‑nu ngul naꞌ gucnu ziꞌal ngul queëꞌ Urías, atiꞌ David len ngul ni glaquëꞌ xuz xnëꞌë Salomón. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón guquëꞌ xuzëꞌ Roboam. Roboam guquëꞌ xuzëꞌ Abías. Abías guquëꞌ xuzëꞌ Asa. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa guquëꞌ xuzëꞌ Josafat. Josafat guquëꞌ xuzëꞌ Joram. Joram guquëꞌ xuzëꞌ Uzías. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías guquëꞌ xuzëꞌ Jotam. Jotam guquëꞌ xuzëꞌ Acaz. Acaz guquëꞌ xuzëꞌ Ezequías. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías guquëꞌ xuzëꞌ Manasés. Manasés guquëꞌ xuzëꞌ Amón. Amón guquëꞌ xuzëꞌ Josías. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías guquëꞌ xuzquëꞌ Jeconías len yuguꞌ bönniꞌ böchëꞌë. Yuguꞌ bönniꞌ ni gulacuꞌë dza niꞌ catiꞌ yuguꞌ bönniꞌ Babilonia gulachë́ꞌë bunách Israel nadzungac lu xyuquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías guquëꞌ xuzëꞌ Salatiel. Salatiel guquëꞌ xuzëꞌ Zorobabel. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel guquëꞌ xuzëꞌ Abiud. Abiud guquëꞌ xuzëꞌ Eliaquim. Eliaquim guquëꞌ xuzëꞌ Azor. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor guquëꞌ xuzëꞌ Sadoc. Sadoc guquëꞌ xuzëꞌ Aquim. Aquim guquëꞌ xuzëꞌ Eliud. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud guquëꞌ xuzëꞌ Eleazar. Eleazar guquëꞌ xuzëꞌ Matán. Matán guquëꞌ xuzëꞌ Jacob. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob guquëꞌ xuzëꞌ José. José ni guquëꞌ bönniꞌ queënu María, atiꞌ María naꞌ gucnu xnëꞌë Jesús, lëꞌ caꞌ Cristo, Nu naꞌ tun löz bunách judío guidëꞌ duná béꞌinëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cni nac, glac chidáꞌ cöꞌ diꞌa dza ga gzu lau zoëꞌ Abraham ga bdxintë zoëꞌ David, atiꞌ glac caꞌ yechidáꞌ cöꞌ diꞌa dza ga gzu lau zoëꞌ David ga bdxintë dza yuguꞌ bönniꞌ Babilonia gulachë́ꞌë bunách Israel nadzungac, atiꞌ glac caꞌ yechidáꞌ cöꞌ diꞌa dza ga gzu lau dza niꞌ gulachë́ꞌë lequëꞌ ga bdxintë dza guljëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cni guc catiꞌ guljëꞌ Jesucristo. Catiꞌ niꞌ chnazíꞌ lu naꞌbiꞌ María, xnëꞌë Jesucristo utság náꞌlenbiꞌ José, len zíꞌatël catiꞌ ziꞌa utság náꞌlenëꞌ‑biꞌ, gyuꞌubiꞌ lëꞌbiꞌ María naꞌ tubiꞌ biꞌidauꞌ. Guc cni niꞌa qui yöl‑laꞌ huac queëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naquëꞌ bönniꞌ tsahuiꞌ José naꞌ, bönniꞌ queëbiꞌ María, san cutu guꞌnnëꞌ uquíëꞌ‑biꞌ laugac bunách. Guꞌnnëꞌ uláꞌalenëꞌ‑biꞌ bagachiꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tsal niꞌ rzaꞌ ladxëꞌë José ca naꞌ gunëꞌ, buluíꞌ lahuëꞌ gbaz laꞌy queëꞌ Xanruꞌ lahuëꞌ José lu yël bëchcál, len rëꞌ lëꞌ: ―José, zxiꞌn xsoëꞌ David. Cutu gádxinuꞌ siꞌu‑biꞌ María, gacbiꞌ ngul quiuꞌ, le yuꞌubiꞌ lëꞌbiꞌ biꞌi bö́nniꞌdauꞌ naꞌ ral‑laꞌ galjbiꞌ niꞌa qui yöl‑laꞌ huac queëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Galjbiꞌ queëbiꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ, atiꞌ guꞌu labiꞌ Jesús, le uslabiꞌ bunách queëbiꞌ lu dul‑laꞌ nabágaꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Cni guc yúguꞌtë lë ni quië butság lë naꞌ gnëꞌ Xanruꞌ lu ruꞌë bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Gul‑yutscaꞌ, tu ngul raꞌbandauꞌ, tsuꞌubiꞌ lëꞌbiꞌ biꞌidauꞌ, atiꞌ galjbiꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ, Atiꞌ luꞌë labiꞌ Emanuel. Emanuel nac tu didzaꞌ hebreo le rna: “Len rëꞌu Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Catiꞌ bubanëꞌ José lu yël bëchcál, benëꞌ ca naꞌ gudxëꞌ lëꞌ gbaz laꞌy queëꞌ Xanruꞌ, atiꞌ gzxiꞌë‑biꞌ María naꞌ, gucbiꞌ ngul queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Cutu gzóalenëꞌ‑biꞌ catiꞌ bdxinr dza chguljbiꞌ queëbiꞌ biꞌi bö́nniꞌdauꞌ, biꞌi ziꞌal queëbiꞌ, atiꞌ gluꞌë labiꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Catiꞌ guljbiꞌ Jesús yödz Belén, luyú Judea, rna bëꞌë luyú niꞌ Herodes, atiꞌ guladxinëꞌ Jerusalén bönniꞌ taꞌyejniꞌi, narujquëꞌ tu yödz dë zacaꞌ ga rlen gbidz. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gulanabëꞌ bönniꞌ ni, taꞌnë́ꞌ: ―¿Gazx zoabiꞌ biꞌidauꞌ naꞌ ral‑laꞌ gna béꞌibiꞌ bunách judío, biꞌidauꞌ naꞌ ziꞌa guljbiꞌ? Catiꞌ niꞌ zoatuꞌ ga rlen gbidz bléꞌituꞌ‑baꞌ bölj yeníꞌ nac bëꞌ chguljbiꞌ, atiꞌ zaꞌtuꞌ ni quië tsej ládxiꞌtuꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Catiꞌ gúquibeꞌinëꞌ lë ni Herodes, bönniꞌ rna bëꞌë, gröꞌtsquëꞌ baguíꞌi, len lëzcaꞌ cni gulabö́ꞌ baguíꞌi yúguꞌtë bunách nacuáꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Niꞌr bulidzëꞌ yúguꞌtë bxuz uná bëꞌ, len bönniꞌ gdauꞌ tuꞌsëdi, Herodes naꞌ, atiꞌ gnabnëꞌ lequëꞌ gazx ral‑laꞌ galjëꞌ Cristo, bönniꞌ naꞌ tunëꞌ löz bönniꞌ judío glëꞌë gna béꞌinëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tëꞌ lëꞌ: ―Lu yödz Belén luyú Judea. Cni nac le buzujëꞌ lu guich bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios le rna cni: ");
INSERT INTO zsrNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Cutu nacr cuidiꞌ lahuëꞌ Dios yödz Belén luyú Judá, Ca yödz gap nacuáꞌ nup taꞌná bëꞌ luyú ni, Le grujëꞌ yödz Belén bönniꞌ gaquëꞌ blau, Bönniꞌ naꞌ gun chiꞌë bunách Israel quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Niꞌr bulidzëꞌ bagachiꞌz bönniꞌ taꞌyejniꞌi naꞌ Herodes, len gnabnëꞌ lequëꞌ quië gnöznëꞌ dxiꞌa gácaꞌxtë chguc buluíꞌ lahui lauquëꞌ bölj naꞌ gulaléꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Niꞌr bsölëꞌë lequëꞌ tsjaquëꞌ Belén. Rëꞌ lequëꞌ: ―Gul‑tséaj niꞌ, len gul‑tsajnáb dxiꞌa nacx nac queëbiꞌ biꞌidauꞌ naꞌ. Catiꞌ chbdzö́liliꞌ‑biꞌ, dudíxjöiꞌliꞌ nedaꞌ, quië tsijaꞌ caꞌ nedaꞌ, tsej ladxaꞌa‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Gdöd gulayönnëꞌ didzaꞌ bëꞌë Herodes naꞌ, zjaquëꞌ bönniꞌ taꞌyejniꞌi naꞌ, atiꞌ nanörbaꞌ lauquëꞌ bölj naꞌ gulaléꞌinëꞌ catiꞌ niꞌ nacuꞌë ladzquëꞌ ga bdxintë yajsóa ga naꞌ dëbiꞌ biꞌidauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Catiꞌ gulaléꞌinëꞌ bölj naꞌ, guludzíjtsquinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Catiꞌ gulayaziëꞌ yuꞌu, gulaléꞌinëꞌ‑biꞌ biꞌi bö́nniꞌdauꞌ naꞌ, zóalenbiꞌ‑nu María, xnaꞌbiꞌ. Niꞌr guluzechu zxibquëꞌ laubiꞌ, len gulayíj ládxiꞌquëꞌ‑biꞌ. Gdöd naꞌ gulasaljëꞌ yuguꞌ guiꞌndauꞌ quequëꞌ len gulunödzjëꞌ queëbiꞌ oro, len yal, len nördauꞌ rlaꞌ zxix qui yag mirra. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Le chbuzéjniꞌnëꞌ lequëꞌ Dios lu yël bëchcál cui tshuöjquëꞌ ga zoëꞌ Herodes naꞌ, qui lë ni naꞌ yhuöjquëꞌ ladzquëꞌ nöz yubl. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gdöd guluzë́ꞌë niꞌ bönniꞌ taꞌyejniꞌi naꞌ, niꞌr buluíꞌ lahuëꞌ tuëꞌ gbaz laꞌy queëꞌ Xanruꞌ ga naꞌ dëꞌ José lu yël bëchcál, len rëꞌ lëꞌ: ―Gyas. Bchëꞌ‑biꞌ biꞌidauꞌ ni lencaꞌ xnaꞌbiꞌ, atiꞌ bzxundj ni. Gyeaj luyú Egipto, atiꞌ ugaꞌnuꞌ niꞌ catiꞌ gyëpraꞌ liꞌ nedaꞌ yetú. Cni gunuꞌ le uguiljëꞌ‑biꞌ biꞌidauꞌ ni Herodes quië gdöddëꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Niꞌr gyasëꞌ José, len niꞌ nac chdzöꞌl, bchëꞌë‑biꞌ biꞌidauꞌ naꞌ lencaꞌ xnaꞌbiꞌ, atiꞌ yjaquëꞌ luyú Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Gulugaꞌnëꞌ niꞌ catiꞌ gutrëꞌ Herodes. Cni guc quië butság lë naꞌ gnëꞌ Xanruꞌ Dios lu ruꞌë bönniꞌ bëꞌë didzaꞌ uláz queëꞌ, gnëꞌ: “Ga nac luyú Egipto bulidzaꞌ Zxiꞌnaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Catiꞌ gúquibeꞌinëꞌ Herodes cutu glunëꞌ ca rnëꞌ bönniꞌ taꞌyejniꞌi, gleynëꞌ Herodes naꞌ, atiꞌ gna béꞌinëꞌ bönniꞌ tsjaquëꞌ ludödcdëꞌ‑biꞌ yúguꞌtëbiꞌ biꞌi bö́nniꞌdauꞌ nacuaꞌbiꞌ Belén len gdu zbiꞌil ga dë Belén naꞌ, biꞌidauꞌ chyuꞌucbiꞌ chop iz len biꞌidauꞌ nahuëꞌnrcbiꞌ. Cni benëꞌ ca busaquëꞌ queëꞌ Herodes naꞌ, tsca chguc dza buluíꞌ lahui bölj, dza naꞌ guluzéjniꞌnëꞌ lëꞌ bönniꞌ taꞌyejniꞌi naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cni guc, butság lë naꞌ gnëꞌ Jeremías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lu yödz Ramá ryön chiꞌigac Nup taꞌbö́dx len nup taꞌbödxyaꞌa. Raquel rbödxnu niꞌa quegac zxiꞌnnu, Cutu gac nu huiꞌ zxön lënu, le chnatcbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gdöd gutiëꞌ Herodes naꞌ, niꞌr buluíꞌ lahuëꞌ gbaz laꞌy naꞌ queëꞌ Xanruꞌ lahuëꞌ José lu yël bëchcál ga niꞌ zoëꞌ luyú Egipto, len rëꞌ lëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Gyas. Bchëꞌ‑biꞌ biꞌi bö́nniꞌdauꞌ ni lencaꞌ xnaꞌbiꞌ, atiꞌ böaj luyú Israel, le chglatiëꞌ bönniꞌ niꞌ glëꞌnnëꞌ ludöddëꞌ‑biꞌ biꞌi bö́nniꞌdauꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Niꞌr gyasëꞌ José, atiꞌ bchëꞌë‑biꞌ biꞌi bö́nniꞌdauꞌ naꞌ lencaꞌ xnaꞌbiꞌ, atiꞌ yhuöjquëꞌ luyú Israel. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Catiꞌ gúquibeꞌinëꞌ José rna bëꞌë Arquelao luyú Judea le chgutiëꞌ Herodes, xuzëꞌ Arquelao, qui lë ni naꞌ gúdxinëꞌ José huöjëꞌ niꞌ. Catiꞌ buzéjniꞌnëꞌ lëꞌ Dios lu yël bëchcál, gyijëꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Catiꞌ bdxinëꞌ niꞌ, yajsóëꞌ yödz Nazaret. Cni guc quië butság lë naꞌ gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios ca ral‑laꞌ gac queëꞌ Jesús, siꞌ Lëꞌ, Bönniꞌ Nazaret. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yuguꞌ lu dza niꞌ buluíꞌ lahuëꞌ Juan, bönniꞌ naꞌ buquilëꞌ bunách nis, runëꞌ lban lu latj caꞌz luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan naꞌ rnëꞌ: ―Gul‑bíꞌi ládxiꞌliꞌ, le chzoa gdxin dza duná bëꞌ luyú ni Nu naꞌ zoa yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ca nac queëꞌ Juan naꞌ, buzujëꞌ lu guich Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, le rna cni: Ryön chiꞌë bönniꞌ rulidzëꞌ lu latj caꞌz, rnëꞌ: Gul‑páꞌ nöz gdxin queëliꞌ Xanruꞌ, Gul‑bíj li yuguꞌ nöz las tödëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nacuëꞌ zxëꞌ Juan lariꞌ náquini lítsaꞌbaꞌ böaꞌ, atiꞌ núguëꞌë lëꞌë pan guid. Rahuëꞌ‑baꞌ böchiꞌzú len riꞌjëꞌ bdxindauꞌ qui bözdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Guladxinëꞌ ga zoëꞌ Juan yuguꞌ bönniꞌ Jerusalén len bunách narujgac gdu luyú Judea, len gdu zbiꞌil ga dë yegu Jordán. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Catiꞌ gulaxóalëpëꞌ dul‑laꞌ nabágaꞌquëꞌ, Juan naꞌ buquilëꞌ lequëꞌ nis lu yegu Jordán naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Catiꞌ bléꞌinëꞌ Juan taꞌdxinëꞌ ga zoëꞌ zian bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ saduceo quië laꞌdilëꞌ nis, rëꞌ lequëꞌ: ―Lbiꞌiliꞌ, diꞌa dza quecbaꞌ bël sniaꞌ. ¿Nuzxa buzejniꞌi lbiꞌiliꞌ gzxundjliꞌ yöl‑laꞌ rusyúdx naꞌ ziꞌa gac quegac bunách? ");
INSERT INTO zsrNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gul‑gún le gac bëꞌ chbubíꞌi ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cutu cuequi icjliꞌ, cugnaliꞌ nacliꞌ tsahuiꞌ le nacliꞌ zxiꞌn xsoëꞌ Abraham, le rëpaꞌ lbiꞌiliꞌ, huac gunëꞌ Dios ga luhuöác zxiꞌn xsoëꞌ Abraham guiöj nacuáꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chzoa rböz guia huag gchugu yag le ruluíꞌ ca gac queëliꞌ. Yúguꞌtë yag cutaꞌbía le nac dxiꞌa, grúgugac atiꞌ laꞌguꞌquëꞌ leygac lu guiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Le nactë nedaꞌ ruquilaꞌ lbiꞌiliꞌ nis lu nis, nul‑liꞌ chbubíꞌi ládxiꞌliꞌ, san bönniꞌ naꞌ ral‑laꞌ guidëꞌ catiꞌ töd quiaꞌ nedaꞌ, lëꞌ gunëꞌ le ruluíꞌz yöl‑laꞌ rdil nis ni, uchiziëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy len guiꞌ queëꞌ. Bönniꞌ ni náctërëꞌ blau ca nedaꞌ, atiꞌ nedaꞌ cutu nacaꞌ lsacaꞌ gleycjaꞌ lölëꞌ nudë́ꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Zönëꞌ lu nëꞌë bcöꞌ queëꞌ, le ulubnëꞌ ga rdxiꞌa zxoaꞌ xtil queëꞌ. Uziꞌë zxoaꞌ xtil queëꞌ lu yuꞌu ga niꞌ gun chiꞌë lei, san uzéguiꞌë bëb qui lu guiꞌ, atiꞌ guiꞌ naꞌ cutu caꞌ ul. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Niꞌr buzë́ꞌë Jesús luyú Galilea, len bdxinëꞌ raꞌ yegu Jordán ga naꞌ zoëꞌ Juan, quië gdilëꞌ nis lu nëꞌë Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan buzaguëꞌë xnözëꞌ, rëꞌ Jesús: ―Nedaꞌ ral‑laꞌ gdilaꞌ nis lu naꞌu Liꞌ. ¿Atiꞌ Liꞌ zaꞌtsuꞌ quiaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Benn latj naꞌa, le cni ral‑laꞌ gunruꞌ gdutë le nac tsahuiꞌ. Niꞌr bëꞌë Lëꞌ latj Juan. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Catiꞌ chnadilëꞌ Jesús nis, laꞌ burujtëꞌ lu nis. Niꞌr gyalj luzxbá lahuëꞌ Jesús, atiꞌ bléꞌinëꞌ ruhuötjëꞌ Dios Böꞌ Laꞌy, bdxinëꞌ ga naꞌ zoëꞌ Jesús, rnëꞌë ca rnaꞌbaꞌ budödauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Niꞌr byön chiꞌi nu ruiꞌ didzaꞌ yehuaꞌ yubá, rna: ―Bönniꞌ ni naquëꞌ Zxiꞌnaꞌ. Nadxiꞌidaꞌ Lëꞌ len rdzag ladxaꞌa Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Niꞌr laꞌ bchëꞌtëꞌ Jesús lu latj caꞌz Dios Böꞌ Laꞌy quië gataꞌ latj siꞌ bëꞌ Lëꞌ Satanás tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Gdu choaꞌ dza choaꞌ yël cutu bi gdahuëꞌ Jesús, atiꞌ gdödr niꞌ rdunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Niꞌr bdxin ga zoëꞌ Jesús tuꞌ xöhuiꞌ, nu naꞌ rugáp bunách dul‑laꞌ, len rë Jesús: ―Chquiꞌ nacuꞌ gdu Zxiꞌnëꞌ Dios, gna naꞌa luhuöác yöt xtil guiöj nacuáꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bubiꞌë didzaꞌ Jesús, rëꞌ lei: ―Nayúj lu guich laꞌy, rna: “Clëgz yöt xtil nabánigac bunách, san lëzcaꞌ yúguꞌtë didzaꞌ ruꞌë Dios nabánigac bunách.” ");
INSERT INTO zsrNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niꞌr bchëꞌ Jesús tuꞌ xöhuiꞌ yödz laꞌy Jerusalén, atiꞌ niꞌ budxía Lëꞌ ga nac xtsaꞌ cjuꞌu gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Niꞌr rë Lëꞌ tuꞌ xöhuiꞌ, rna: ―Chquiꞌ nacuꞌ Liꞌ gdu Zxiꞌnëꞌ Dios, busladzuꞌ cuinuꞌ ni, le nayúj lu guich laꞌy, rna: Dios gsölëꞌë gbaz laꞌy queëꞌ lun chiꞌë Liꞌ, Atiꞌ luchisëꞌ Liꞌ lu naꞌquëꞌ, Cui tsajcheguꞌu guiöj, cui gunuꞌ ziꞌ niꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bubiꞌë didzaꞌ Jesús, rëꞌ lei: ―Yetú caꞌ nayúj lu guich laꞌy, le rë bunách, rna: “Cutu siꞌ bëꞌu Xanuꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Niꞌr bchëꞌ Jesús tuꞌ xöhuiꞌ ga nac tu lu guiꞌa sib, atiꞌ niꞌ buluíꞌi Lëꞌ yúguꞌtë yödz nacuáꞌ yödzlyú ni len yúguꞌtë yöl‑laꞌ tsahuiꞌ quegac. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Niꞌr rë Lëꞌ: ―Yúguꞌtë lë ni udödaꞌ lu naꞌu chquiꞌ uzechu zxibuꞌ lahuaꞌ gunuꞌ nedaꞌ zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús rëꞌ lei: ―Böaj quiuꞌ liꞌ, Satanás tuꞌ xöhuiꞌ, le nayúj lu guich laꞌy le rë netuꞌ, rna: “Xanuꞌ Dios tsej ladxuꞌu, len tuzëꞌ Lëꞌ gunuꞌ xchinëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niꞌr buzáꞌ ga naꞌ zoëꞌ Jesús Satanás tuꞌ xöhuiꞌ, atiꞌ guladxinëꞌ ga zoëꞌ gbaz laꞌy queëꞌ Dios len gláclenëꞌ Lëꞌ, gulaguꞌë le gdahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Catiꞌ byönnëꞌ Jesús nadzunëꞌ Juan lidx guia, gyijëꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Buzë́ꞌë yödz Nazaret, atiꞌ yajsóëꞌ yödz Capernaum ga nac raꞌ nis zxön, lu bzaꞌ quegac bunách Zabulón len bunách Neftalí. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Cni guc, butság lë naꞌ gnëꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Luyú Zabulón len luyú Neftalí, Laꞌ nöz raꞌ nis zxön yetsláꞌa yegu Jordán zacaꞌ ga rlen gbidz. Luyú Galilea, ga nacuáꞌ bunách cunacgac judío. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bunách chul nit niꞌ gulaleꞌi yeníꞌ, Atiꞌ bönniꞌ niꞌ nacquëꞌ ca nup chnatgac, blen quequëꞌ yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Catiꞌ niꞌr gzu lahuëꞌ Jesús runëꞌ lban, rëꞌ bunách niꞌ: ―Gul‑bíꞌi ládxiꞌliꞌ, le chzoa gdxin dza duná bëꞌ luyú ni Nu naꞌ zoa yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Catiꞌ gdëꞌ Jesús raꞌ nis zxön qui Galilea, niꞌ bléꞌinëꞌ chopëꞌ bönniꞌ. Tuëꞌ lëꞌ Simón, len zoa yetú lëꞌ Pedro, atiꞌ dzaguëꞌ lëꞌ Andrés, bönniꞌ böchëꞌë. Chopëꞌ ni taꞌchiljëꞌ yöxj böl quequëꞌ lu nis zxön naꞌ le nacquëꞌ uzö́n böl. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús rëꞌ lequëꞌ: ―Gul‑dutáꞌ nedaꞌ, atiꞌ gunaꞌ ga gchëꞌliꞌ quiaꞌ bunách, gunliꞌ ca runliꞌ rzönliꞌ‑baꞌ böl. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Laꞌ gulucaꞌntëꞌ yuguꞌ yöxj böl quequëꞌ chopëꞌ ni, zjáclenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Catiꞌ gdödëꞌ yelatiꞌ niꞌl Jesús, bléꞌinëꞌ yechopëꞌ bönniꞌ. Tuëꞌ lëꞌ Jacobo, atiꞌ dzaguëꞌ lëꞌ Juan, bönniꞌ böchëꞌë. Nacquëꞌ zxiꞌnëꞌ Zebedeo. Nacuꞌë lëꞌi bárcodauꞌ dzagquëꞌ Zebedeo, xuzquëꞌ, len tuꞌúnëꞌ yöxj böl quequëꞌ. Niꞌr Jesús bulidzëꞌ chopëꞌ ni tsajtaꞌquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Laꞌ gulucaꞌntëꞌ bárcodauꞌ naꞌ lencaꞌ xuzquëꞌ, zjáclenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Gdëꞌ Jesús gdu luyú Galilea, rusëdnëꞌ bunách gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Niꞌ benëꞌ lban qui didzaꞌ dxiꞌa ca ziꞌa duná bëꞌë luyú ni Dios, len bunëꞌ yúguꞌtë nup teꞌi tsca nac guidzhuë́ꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gzë didzaꞌ qui yöl‑laꞌ huac queëꞌ Jesús, atiꞌ gulayöni bunách gdu luyú Siria, atiꞌ djuaꞌgac ga zoëꞌ Jesús yúguꞌtë bönniꞌ téꞌinëꞌ zian guidzhuë́ꞌ quequëꞌ, len taꞌzacaꞌ taꞌguiꞌë. Djuaꞌquëꞌ caꞌ niꞌ bönniꞌ yuꞌugac lequëꞌ böꞌ xöhuiꞌ, len bönniꞌ téꞌinëꞌ huëꞌ xjutiꞌ, len bönniꞌ nacuꞌnquëꞌ bin niꞌa naꞌquëꞌ, atiꞌ Jesús bunëꞌ yúguꞌtë bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Rjaclen Jesús bunách zian narujgac luyú Galilea, len yuguꞌ yödz Decápolis, len yödz Jerusalén, lencaꞌ luyú Judea, len yuguꞌ yödz nacuáꞌ yetsláꞌl yegu Jordán zacaꞌ ga rlen gbidz. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Catiꞌ bléꞌinëꞌ Jesús zaꞌclen Lëꞌ bunách zian, niꞌr grenëꞌ tu lu guíꞌadauꞌ ga nac xtsaꞌ, atiꞌ lu guiꞌa niꞌ gröꞌë. Niꞌr guludubëꞌ ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gzu lahuëꞌ rusëdnëꞌ lequëꞌ, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Bicaꞌ ba bönniꞌ táquibeꞌinëꞌ taꞌyadzjnëꞌ le naqui queëꞌ Dios, le nadél‑liꞌquëꞌ latj ga rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Bicaꞌ ba bönniꞌ tuꞌhuiꞌni ládxiꞌquëꞌ le nabágaꞌquëꞌ dul‑laꞌ, le huiꞌ zxönëꞌ lequëꞌ Dioscz. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Bicaꞌ ba bönniꞌ nacquëꞌ nöxj ladxiꞌ lahuëꞌ Dios, le gataꞌ quequëꞌ luyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Bicaꞌ ba bönniꞌ taꞌzë́ ládxiꞌquëꞌ le nac tsahuiꞌ lahuëꞌ Dios, rac quequëꞌ ca rac quegac nup taꞌdún len taꞌbídx nis, le gunëꞌ Dios ga luziꞌë xbey lë naꞌ taꞌzë́ ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Bicaꞌ ba bönniꞌ tuꞌhuechiꞌ ládxiꞌquëꞌ lzaꞌquëꞌ, le huechiꞌ ladxëꞌë lequëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Bicaꞌ ba bönniꞌ nac dxiꞌa icj ládxiꞌdauꞌquëꞌ, cutu bi nabágaꞌquëꞌ, le laꞌléꞌinëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Bicaꞌ ba bönniꞌ taꞌbequi dxiëꞌ didzaꞌ bizxj, le laꞌzíꞌ laquëꞌ zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Bicaꞌ ba bönniꞌ taꞌzacaꞌ taꞌguiꞌë yuguꞌ le taꞌbía ládxiꞌgac lequëꞌ bunách catiꞌ tunëꞌ le nac tsahuiꞌ, le dë quequëꞌ latj ga rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Bicaꞌ ba lbiꞌiliꞌ catiꞌ tuꞌlídz lbiꞌiliꞌ ziꞌ bunách, len taꞌbía ládxiꞌgac lbiꞌiliꞌ, atiꞌ lu yöl‑laꞌ rziꞌ yëꞌ taꞌnë́ queëliꞌ le xöhuiꞌ le daꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gul‑dziji len gul‑dzág ládxiꞌliꞌ, le uzíꞌtscaliꞌ xbey niꞌ yehuaꞌ yubá. Ca rac queëliꞌ, guc quequëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios len gulacuꞌë zíꞌatël ca lbiꞌiliꞌ, le gulabía ládxiꞌgac caꞌ lequëꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gnëꞌ caꞌ Jesús: ―Lbiꞌiliꞌ nacliꞌ ca zödiꞌ luyú ni, san chquiꞌ nit yöl‑laꞌ snaꞌ qui zödiꞌ naꞌ, cutu gac gunruꞌ ga huöac snaꞌ. Cutur bi nac lsacaꞌ, san chnac tu le chuꞌnruꞌ, atiꞌ lulíb lei bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Lbiꞌiliꞌ nacliꞌ ca yeníꞌ yödzlyú ni quië uluiꞌliꞌ lahui le nac queëꞌ Dios. Gacliꞌ ca tu yödz dë tu lu guiꞌa, cutu gac ggachiꞌ yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Catiꞌ ruquél‑laꞌruꞌ guiꞌ, cutu rguꞌruꞌ lei zxan guiꞌn, san ga lnaꞌ ruzoaruꞌ lei quië uzeníꞌ yúguꞌtë nup nacuáꞌ lu yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ca naꞌ run yeníꞌ, ral‑laꞌ gunliꞌ caꞌ lbiꞌiliꞌ, güiꞌliꞌ latj gac bëꞌ le nacliꞌ laugac yúguꞌtë bunách, quië catiꞌ laꞌleꞌi le nac dxiꞌa runliꞌ, laꞌgúꞌu‑nëꞌ yöl‑laꞌ ba Xuzliꞌ Dios zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Gnëꞌ caꞌ Jesús: ―Cutu gáquiliꞌ bidaꞌ dusnitiaꞌ yuguꞌ le gna bëꞌë Moisés o zxba naꞌ gulusëdnëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. Bidaꞌ, clëg quië usnitiaꞌ yuguꞌ lë ni, san quië uluꞌa lahui gdu le rusëdi lë naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Le nactë rëpaꞌ lbiꞌiliꞌ. Tsal ni nacuáꞌ luzxbá len yödzlyú ni, cutu töd caꞌz nitú dídzaꞌdauꞌ, len nitú le rna bëꞌ zxba naꞌ, catiꞌ gacr yúguꞌtë le ral‑laꞌ gac. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Qui lë ni naꞌ, nútiꞌtëz bönniꞌ quitsjëꞌ tu zxba cuídiꞌdauꞌz zoa lu zxba naꞌ, len usëdnëꞌ bunách lun cni, bönniꞌ ni gáctërëꞌ cuídiꞌdauꞌz ca yúguꞌtë nup laꞌcuáꞌ ga rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá, san nútiꞌtëz bönniꞌ gunëꞌ ca rna bëꞌ zxba naꞌ len usëdnëꞌ bunách lun caꞌ cni, bönniꞌ ni gáctërëꞌ blau ga rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rëpaꞌ caꞌ lbiꞌiliꞌ: “Chquiꞌ cugunliꞌ le nactër dxiꞌa ca le tunëꞌ bönniꞌ gdauꞌ usëdi, lencaꞌ ca tunëꞌ bönniꞌ gdauꞌ fariseo, cutu caꞌ tsazliꞌ ga niꞌ rna bëꞌë Dios yehuaꞌ yubá.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gnëꞌ caꞌ Jesús: ―Chbyö́niliꞌ ca glëꞌ xuz xtauꞌliꞌ bönniꞌ gutaꞌ lu naꞌquëꞌ, gulanë́ꞌ: “Cutu gdö́diliꞌ bunách. Nu bönniꞌ gdödëꞌ bunách, nabaguëꞌë zxguiaꞌ huadxinëꞌ ga cuequi xbeynëꞌ lëꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ: Nu bönniꞌ rleynëꞌ böchiꞌ lzëꞌë, nabaguëꞌë zxguiaꞌ huadxinëꞌ ga cuequi xbeynëꞌ lëꞌ Dios. Lëzcaꞌ cni, nu bönniꞌ gnë ziꞌë queëꞌ böchiꞌ lzëꞌë nabaguëꞌë zxguiaꞌ laꞌbequi xbeynëꞌ lëꞌ bönniꞌ blau taꞌbequi xbey, atiꞌ nu bönniꞌ guiëꞌ lzëꞌë: “Böaꞌ cunözi”, nabaguëꞌë zxguiaꞌ bönniꞌ naꞌ tsijëꞌ lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Cni nac, chquiꞌ chzoa cuꞌu lu bcugu laꞌy tu le unödzjuꞌ, atiꞌ niꞌ tsajneynuꞌ zoa bizx quië rleynëꞌ liꞌ böchiꞌ lzaꞌu, ");
INSERT INTO zsrNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bcaꞌn lu bcugu niꞌ lë naꞌ unödzjuꞌ, len böaj lidxuꞌ. Ziꞌal yajcáꞌn tsahuiꞌ le benuꞌ queëꞌ böchiꞌ lzaꞌu, atiꞌ niꞌr gda unödzjuꞌ lë naꞌ nuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chquiꞌ zoa nu bönniꞌ rnabnëꞌ liꞌ bi quizxjuꞌ len gchëꞌë liꞌ ga cuequi xbeynëꞌ liꞌ bönniꞌ, budzagtë dxiꞌa bönniꞌ naꞌ tsal niꞌ yúꞌulenuꞌ lëꞌ nöz, cui udödëꞌ liꞌ lahuëꞌ bönniꞌ rbequi xbey, atiꞌ bönniꞌ ni udödëꞌ liꞌ lu nëꞌë bönniꞌ ruseyjëꞌ lidx guia, atiꞌ lëꞌ cuꞌë liꞌ lidx guia naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Le nactë rëpaꞌ liꞌ, cutu caꞌ urujuꞌ niꞌ catiꞌ gdxinr dza quizxjuꞌ ga buitë le ral‑luꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Gnëꞌ caꞌ Jesús: ―Chbyö́niliꞌ ca naꞌ gulanë́ꞌ: “Cutu gunuꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ: Nútiꞌtëz bönniꞌ ruyúëꞌ ngul len yöl‑laꞌ rzë ladxiꞌ le cunác, chbenëꞌ dul‑laꞌ len lënu lu icj ládxiꞌdauꞌhuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Qui lë ni naꞌ, chquiꞌ gun ga gunuꞌ dul‑laꞌ yöj lauꞌ yubél, gleaj lei len gruꞌn lei. Dxiꞌar gac quiuꞌ unitiuꞌ tu yöj lauꞌ, len clëg gduteoꞌ tsijuꞌ lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chquiꞌ gun ga gunuꞌ dul‑laꞌ naꞌu yubél, bchugu lei, len gruꞌn lei. Dxiꞌar gac quiuꞌ unitiuꞌ tu naꞌu, len clëg gduteoꞌ tsijuꞌ lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gnëꞌ caꞌ Jesús: ―Lëzcaꞌ gulanë́ꞌ: “Nútiꞌtëz bönniꞌ rusanëꞌ‑nu ngul queëꞌ, ral‑laꞌ unödzjëꞌ queënu guich le rna ruláꞌalenëꞌ‑nu.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ, chquiꞌ zoëꞌ bönniꞌ rusanëꞌ‑nu ngul queëꞌ, len cutu zoa le cunác runnu, gunëꞌ bönniꞌ naꞌ ga gunnu dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ chquiꞌ utság náꞌlennu bönniꞌ yubl, atiꞌ bönniꞌ naꞌ siꞌë‑nu ngul naꞌ, lëzcaꞌ gunëꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Gnëꞌ caꞌ Jesús: ―Lëzcaꞌ byö́niliꞌ ca glëꞌ xuz xtauꞌliꞌ bönniꞌ gutaꞌ lu naꞌquëꞌ, gulanë́ꞌ: “Cutu siꞌ yëꞌu catiꞌ rneynuꞌ Dios, atiꞌ ral‑laꞌ gunuꞌ lahuëꞌ Xanruꞌ Dios gdutë lë naꞌ rneynuꞌ Lëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ, cutu caꞌ gun tsutsu xtídzaꞌliꞌ. Cutu gun tsutsu xtídzaꞌliꞌ gneyliꞌ yehuaꞌ yubá, le nac ga röꞌë rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Cutu gun tsutsu xtídzaꞌliꞌ gneyliꞌ luyú ni, le nac luyú ni ca xlibi niꞌë Dios, len cutu gneyliꞌ Jerusalén, le nac ladzëꞌ Bönniꞌ náctërëꞌ blau rna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Cutu gun tsutsu xtidzuꞌu gneynuꞌ icjuꞌ, le cutu gac gunuꞌ ga huöac chguich o gasj nitú guitsaꞌ icjuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ral‑laꞌ gnazliꞌ: “ja”, o gnazliꞌ: “cutu”, le nac qui tuꞌ xöhuiꞌ le nadö́d bëꞌ ca nac didzaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Gnëꞌ caꞌ Jesús: ―Chbyö́niliꞌ ca nac le gna bëꞌë Moisés, gnëꞌ: “Nu bi run qui yöj lau lzëꞌi, ubíꞌi caꞌ qui, lencaꞌ nu bi run qui layiꞌ lzëꞌi, ubíꞌi caꞌ qui.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ: Cutu táꞌbagaꞌliꞌ nu guaꞌ döꞌ queëliꞌ, atiꞌ chquiꞌ nu capaꞌ xaguꞌ yubél, bëꞌ latj capaꞌ caꞌ yetú xaguꞌ yögl. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chquiꞌ zoa nu gun ga cuequi xbeynëꞌ liꞌ bönniꞌ len cua zxauꞌ, bëꞌ caꞌ qui lariꞌ rxoa cudzuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chquiꞌ zoa nu gun bayúdx guꞌu yuaꞌ qui gatsj hora, gyeajlen nu naꞌ gdu tu hora. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nu bi gnabi liꞌ, bnödzj qui, len nu bi guëꞌni gunnuꞌ qui tu chiꞌi, cutu táꞌbaguꞌu lë naꞌ gnabi liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gnëꞌ caꞌ Jesús: ―Lëzcaꞌ cni byö́niliꞌ lë naꞌ gulanë́ꞌ: “Ral‑laꞌ gdxiꞌinuꞌ nu nadxíꞌi liꞌ, len udiꞌinuꞌ nu curleꞌi liꞌ dxiꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ, gul‑dxíꞌi nup cutaꞌleꞌi lbiꞌiliꞌ dxiꞌa. Gul‑náb‑nëꞌ Dios gáclenëꞌ nup tuꞌlídz lbiꞌiliꞌ ziꞌ. Gul‑gún le nac dxiꞌa quegac nup tuꞌdíꞌi lbiꞌiliꞌ, len gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ gunëꞌ ga gac dxiꞌa quegac nup taꞌnë́ queëliꞌ len tuaꞌ döꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chquiꞌ gunliꞌ cni, gacliꞌ gdu zxiꞌnëꞌ Xuzruꞌ Dios, zoëꞌ yehuaꞌ yubá, le runëꞌ Lëꞌ ga ruzeníꞌ gbidz queëꞌ ga nacuáꞌ bunách tuaꞌdöꞌ, lencaꞌ ga nacuáꞌ bunách tsahuiꞌ. Rsölëꞌë tu nis guiöj quegac bunách tsahuiꞌ, lencaꞌ quegac bunách cunacgac tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chquiꞌ nadxiꞌizliꞌ bönniꞌ nadxiꞌicnëꞌ lbiꞌiliꞌ, ¿nuzxa caz cuꞌu lbiꞌiliꞌ yöl‑laꞌ ba? Lëzcaꞌ cni tunëꞌ bönniꞌ cunacgac tsahuiꞌ naꞌ, bönniꞌ tuꞌquizxjëꞌ uláz qui yödz ziꞌtuꞌ, nadxiꞌicnëꞌ lzaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chquiꞌ rugapliꞌ Dios tuzëꞌ böchiꞌ lzaꞌliꞌ, ¿bizxa caz runliꞌ le nactër dxiꞌa? Lëzcaꞌ cni tunëꞌ bönniꞌ cunúnbëꞌgac Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","San lbiꞌiliꞌ, gul‑gác gdu dxiꞌa, ca naꞌ naquëꞌ Xuzruꞌ Dios, zoëꞌ yehuaꞌ yubá, naquëꞌ gdu dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Gnëꞌ caꞌ Jesús: ―Gul‑güíꞌ ládxiꞌliꞌ gac gdu ca rej ládxiꞌliꞌ‑nëꞌ Dios, cugunzliꞌ lë ni laugac bunách quië laꞌleꞌi ca naꞌ runliꞌ. Chquiꞌ runliꞌ cni, cutu bi gunnëꞌ queëliꞌ Xuzruꞌ Dios zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Catiꞌ bi unödzjuꞌ qui nu bi ryadzj, cutu gunuꞌ ga glaꞌ lahui lë naꞌ runuꞌ ca tunëꞌ bönniꞌ tuꞌluíꞌz tsahuiꞌ cuinquëꞌ ga nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, lencaꞌ ga nac lu yëꞌy. Cni tunëꞌ quië laꞌgúꞌu lequëꞌ yöl‑laꞌ ba bunách. Le nactë rëpaꞌ lbiꞌiliꞌ, caꞌz nac yöl‑laꞌ ba gataꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","San liꞌ, catiꞌ bi unödzjuꞌ qui nu bi ryadzj, cutu caꞌ guꞌu latj gnözi nitú bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Naꞌa, lë naꞌ unödzjuꞌ, bagachiꞌz ral‑laꞌ unödzjuꞌ, atiꞌ Xuzruꞌ Dios, Nu rleꞌi ca naꞌ runuꞌ bagachiꞌz, Lëꞌ ubiꞌë quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gnëꞌ caꞌ Jesús: ―Catiꞌ ulidzliꞌ‑nëꞌ Dios, cutu gunliꞌ ca tunëꞌ bönniꞌ tuꞌluíꞌz tsahuiꞌ cuinquëꞌ, le taꞌdzág ládxiꞌquëꞌ taꞌzuinëꞌ tuꞌlidzëꞌ Dios gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, len gap nac lu yëꞌy quië laꞌleꞌi lequëꞌ bunách. Le nactë rëpaꞌ lbiꞌiliꞌ, caꞌz nac yöl‑laꞌ ba gataꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","San lbiꞌiliꞌ, catiꞌ ulidzliꞌ‑nëꞌ Dios gul‑tsáz lidxliꞌ len gul‑séyj yuꞌu. Gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ Xuzruꞌ Dios, zóalenëꞌ lbiꞌiliꞌ ga naꞌ zoaliꞌ queëzliꞌ, atiꞌ Xuzruꞌ Dios, Nu rleꞌi ca runliꞌ bagachiꞌz, Lëꞌ ubiꞌë queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Catiꞌ ulidzliꞌ‑nëꞌ Dios cutu gunliꞌ laꞌ yëꞌy laꞌ leyz ca naꞌ tunëꞌ bönniꞌ cunúnbëꞌquëꞌ Dios, le táquinëꞌ huayönnëꞌ lequëꞌ Dios le tuꞌlidzëꞌ laꞌ yëꞌy laꞌ leyz. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Cutu gunliꞌ ca naꞌ tunëꞌ lequëꞌ. Xuzruꞌ Dios, zíꞌatël catiꞌ ziꞌa gnabliꞌ, chnözcznëꞌ yuguꞌ le ryadzj queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Qui lë ni naꞌ, ral‑laꞌ ulidzliꞌ‑nëꞌ Dios gnaliꞌ cni: Xuz netuꞌ, zuꞌ yehuaꞌ yubá, Gac zxön lauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gda gna bëꞌu luyú ni. Ben ga gac luyú ni ca rdzag ladxuꞌu Liꞌ ca rac niꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Benn le gágutuꞌ naꞌa dza. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bnit lau netuꞌ le cunác bentuꞌ lauꞌ Liꞌ Ca runtuꞌ netuꞌ, runít lautuꞌ caꞌ nup bi tun queëtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Cutu guꞌu latj siꞌ bëꞌ netuꞌ tuꞌ xöhuiꞌ, San buslá netuꞌ lu naꞌ nu ruaꞌ döꞌ, Le naqui quiuꞌ ga rna bëꞌu, len yöl‑laꞌ uná bëꞌ, len yöl‑laꞌ ba. Cni rë́ꞌnituꞌ gactecz. Caꞌ gac. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Chquiꞌ unít lauliꞌ lzaꞌliꞌ, nup tuaꞌ döꞌ queëliꞌ, unít lahuëꞌ caꞌ lbiꞌiliꞌ Xuzruꞌ Dios, zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Chquiꞌ cutu unít lauliꞌ lzaꞌliꞌ, cutu unít lahuëꞌ lbiꞌiliꞌ Xuzruꞌ Dios ca nac dul‑laꞌ runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Gnëꞌ caꞌ Jesús: ―Catiꞌ gunliꞌ gubás, cutu gunliꞌ bayechiꞌ lauliꞌ ca tunëꞌ bönniꞌ tuꞌluíꞌz tsahuiꞌ cuinquëꞌ, le tunëꞌ bayechiꞌ lauquëꞌ quië láquibeꞌi bunách tunëꞌ gubás. Le nactë rëpaꞌ lbiꞌiliꞌ, caꞌz nac yöl‑laꞌ ba gataꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","San lbiꞌiliꞌ, catiꞌ gunliꞌ gubás, gul‑páꞌ icjliꞌ len gul‑quíb lauliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","cui láquibeꞌi bunách runliꞌ gubás. Bagachiꞌz ral‑laꞌ gunliꞌ gubás, atiꞌ Xuzruꞌ Dios, zóalenëꞌ lbiꞌiliꞌ ga naꞌ zoaliꞌ queëzliꞌ, Lëꞌ ubiꞌë queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Gnëꞌ caꞌ Jesús: ―Cutu utubliꞌ yöl‑laꞌ tsahuiꞌ luyú ni, ga ni tuꞌtöbaꞌ lei bëldauꞌ qui, atiꞌ rac ditj, len ga ni taꞌyáz gban, taꞌbanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","San gul‑túb yöl‑laꞌ tsahuiꞌ niꞌ yehuaꞌ yubá, ga niꞌ cutu lutöbaꞌ lei bëldauꞌ qui, len cutu gac ditj, len ga niꞌ cutu laꞌyáz gban cutu laꞌbanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ga niꞌ dë yöl‑laꞌ tsahuiꞌ queëliꞌ, niꞌ güiꞌ ládxiꞌliꞌ gdxinliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Gnëꞌ caꞌ Jesús: ―Yöj lauruꞌ nac ca tu le rguꞌu yeníꞌ icj ládxiꞌdauꞌruꞌ. Qui lë ni naꞌ, chquiꞌ yöj lauliꞌ nac dxiꞌa, gdútëliꞌ tsëpliꞌ yös yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Chquiꞌ yöj lauliꞌ cutu nac dxiꞌa, gdútëliꞌ nachul‑liꞌ. Qui lë ni naꞌ, chquiꞌ yeníꞌ zoalen lbiꞌiliꞌ nuhuöác le nac chul, szxö́nitër nachul‑liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Gnëꞌ caꞌ Jesús: ―Nutu nu gac gun xchinquëꞌ chop xanëꞌ, le uzóëꞌ tslaꞌl tuëꞌ atiꞌ yetúëꞌ naꞌ gdxiꞌinëꞌ, o ugáꞌnlenëꞌ tuëꞌ, atiꞌ yetúëꞌ naꞌ ubíj ladxëꞌë. Cutu gac gunliꞌ zxön Dios lencaꞌ dumí. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Gnëꞌ caꞌ Jesús: ―Yetú caꞌ rëpaꞌ lbiꞌiliꞌ: Cutu cöꞌliꞌ baguíꞌi niꞌa qui le gáguliꞌ o niꞌa qui le guiꞌjliꞌ, yuguꞌ le nabániliꞌ, o niꞌa qui lariꞌ gáculiꞌ. Záquiꞌtsquir yöl‑laꞌ naꞌbán queëliꞌ ca le gáguliꞌ, atiꞌ nactër lsacaꞌ gdu ca nayáꞌ nabinliꞌ ca lariꞌ gáculiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gul‑yú ca rac quecbaꞌ bguindauꞌ taꞌzubaꞌ luzxbá. Cutu caꞌ taz tuꞌzoabaꞌ, len cutu taꞌlapbaꞌ, len cutu tuꞌtubbaꞌ ga bi laꞌguꞌbaꞌ quecbaꞌ, san Xuzruꞌ Dios zoëꞌ yehuaꞌ yubá, rugáguczëꞌ lecbaꞌ. Záquiꞌtsquirliꞌ lbiꞌiliꞌ ca yuguꞌ bguindauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nuzxa caz bönniꞌ nutsëꞌë ladjliꞌ gac gunëꞌ ga soëꞌ gbanëꞌ yetú dzaz le rböꞌë baguíꞌi quië gac cni queëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Bizx quië rböꞌliꞌ baguíꞌi niꞌa qui le gáculiꞌ? Gul‑yutscaꞌ ca rac quegac yöjdauꞌ röꞌgac ladj guixiꞌ ca taꞌzxö́n. Cutu tun dxin len cutu tun du lariꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nedaꞌ rëpaꞌ lbiꞌiliꞌ, Salomón, bönniꞌ niꞌ gna bëꞌë, zal‑laꞌ szxöni gutaꞌ queëꞌ yöl‑laꞌ tsahuiꞌ, lariꞌ gucuëꞌ cutu gnaꞌtër lach ca rnaꞌgac yöjdauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dioscz runëꞌ lach yöj guíxiꞌdauꞌ röꞌgac ladj guixiꞌ, le nacuáꞌ naꞌa dza, atiꞌ cxö huidzj laꞌyegui lu guiꞌ. Chquiꞌ cni ruiꞌ ladxëꞌë yöj guíxiꞌdauꞌ, runëꞌ leygac lach, szxö́nitër gunëꞌ caꞌ queëliꞌ, curéjlëꞌliꞌ‑nëꞌ gdu ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Qui lë ni naꞌ, cutu cöꞌliꞌ baguíꞌi, cugnaliꞌ: “¿Bizxa gágutsatuꞌ?” o “¿Bizxa guíꞌjtsatuꞌ?” o “¿Bizxa lariꞌ gácutsatuꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bunách yödzlyú ni taꞌbö́ꞌ baguíꞌi niꞌa qui yúguꞌtë lë ni, san zoëꞌ Xuzruꞌ yehuaꞌ yubá, atiꞌ Lëꞌ nözcznëꞌ naquíniliꞌ yúguꞌtë lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naꞌa, gul‑güíꞌr ládxiꞌliꞌ gna béꞌinëꞌ lbiꞌiliꞌ Dios, len gunliꞌ le nac dxiꞌa lahuëꞌ Lëꞌ, atiꞌ Lëꞌ cuꞌë xnöz queëliꞌ yúguꞌtë lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Qui lë ni naꞌ, cutu cöꞌliꞌ baguíꞌi niꞌa qui le ral‑laꞌ gac cxö huidzj, le huac güiꞌ ládxiꞌliꞌ cxö huidzj le gac queëliꞌ dza naꞌ. Tu tu dza lac le ral‑laꞌ güiꞌ ládxiꞌliꞌ dza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gnëꞌ caꞌ Jesús: ―Cutu glag yudxliꞌ böchiꞌ lzaꞌliꞌ, cui gchugu bëꞌë caꞌ queëliꞌ Dios, ");
INSERT INTO zsrNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","le gchugu bëꞌë queëliꞌ Lëꞌ laꞌ leyz ca naꞌ rlag yudxliꞌ böchiꞌ lzaꞌliꞌ, atiꞌ ca naꞌ ruríx rudödliꞌ qui lzaꞌliꞌ, laꞌ caꞌz uríx udödëꞌ queëliꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bizx quië ruyúꞌ bëbdauꞌ yuꞌu yöj lahuëꞌ böchiꞌ lzaꞌu, len cutu ráquibeꞌinuꞌ yuꞌu le zxöntër yöj lauꞌ liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Guiëtsuꞌ‑nëꞌ böchiꞌ lzaꞌu: “Glöz, cuijaꞌ bëbdauꞌ yuꞌu yöj lauꞌ”, atiꞌ liꞌ, le zxöntër caꞌ yuꞌu yöj lauꞌ liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Liꞌ, bönniꞌ, ruluíꞌz tsahuiꞌ cuinuꞌ. Gleaj ziꞌal le zxön yuꞌu yöj lauꞌ liꞌ, atiꞌ niꞌr gléꞌinuꞌ dxíꞌadauꞌ quië gac cuijuꞌ bëbdauꞌ yuꞌu yöj lahuëꞌ böchiꞌ lzaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Cutu güiꞌliꞌ quecbaꞌ böꞌcuꞌ le nac laꞌy, qui nadxi luhueycjbaꞌ luzxuzxjbaꞌ lbiꞌiliꞌ, len cutu chuꞌnliꞌ le nac lsacaꞌ queëliꞌ laucbaꞌ cuch, qui nadxi luzadiꞌ níꞌabaꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Gnëꞌ caꞌ Jesús: ―Gul‑náb, atiꞌ Dios gunnëꞌ queëliꞌ. Gul‑guílj, atiꞌ gunnëꞌ latj gdzöl queëliꞌ. Gul‑lídz raꞌ yuꞌu, atiꞌ Lëꞌ gsaljëꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nútiꞌtëz bönniꞌ rnabëꞌ, rdél‑liꞌnëꞌ, atiꞌ bönniꞌ rguiljëꞌ, rdzöl queëꞌ, atiꞌ bönniꞌ rulidzëꞌ raꞌ yuꞌu, ryalj queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Chquiꞌ zoëꞌ bönniꞌ nutsëꞌë ladjliꞌ, atiꞌ zoabiꞌ biꞌi queëꞌ, chquiꞌ gnábibiꞌ lëꞌ yöt xtil, ¿naruꞌ unödzjëꞌ queëbiꞌ guiöj? ");
INSERT INTO zsrNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Chquiꞌ gnábibiꞌ lëꞌ tubaꞌ böl, ¿naruꞌ unödzjëꞌ queëbiꞌ bël? ");
INSERT INTO zsrNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lbiꞌiliꞌ nacliꞌ huiaꞌdöꞌ, san nö́ziliꞌ unödzjliꞌ quecbiꞌ zxiꞌnliꞌ le nac dxiꞌa. Nactër löz, Xuzliꞌ zoëꞌ yehuaꞌ yubá unödzjëꞌ quegac nup taꞌnabi Lëꞌ le nacgac dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Qui lë ni naꞌ, ca naꞌ rë́ꞌniliꞌ lun queëliꞌ bunách, lëzcaꞌ cni gul‑gún quequëꞌ. Lë ni le rna bëꞌ zxba queëꞌ Moisés, lencaꞌ le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gnëꞌ caꞌ Jesús: ―Gul‑tsáz ga nu ryaz le nac guidauꞌ. Lagaꞌ nac ga nu ryaz len yalj caꞌ nac nöz le rjaclenëꞌ bönniꞌ ga niꞌ laꞌnitiëꞌ, atiꞌ taꞌyaziëꞌ niꞌ bönniꞌ zian. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Guidauꞌ nac ga nu ryaz len lasdauꞌz nac nöz le rjaclen bunách ga niꞌ laꞌdél‑liꞌnëꞌ yöl‑laꞌ naꞌbán gdu, atiꞌ nababzëꞌ bönniꞌ taꞌdzölnëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gnëꞌ caꞌ Jesús: ―Gul‑gún chiꞌi cuinliꞌ qui nadxi laꞌzíꞌ yéꞌinëꞌ lbiꞌiliꞌ bönniꞌ taꞌzíꞌ yëꞌë, taꞌnë́ꞌ tuꞌë didzaꞌ uláz queëꞌ Dios. Laꞌdxinëꞌ ga zoaliꞌ bönniꞌ ni, len luluíꞌ cuinquëꞌ nöxj ládxiꞌdauꞌ ca naccbaꞌ böꞌcuꞌ zxílaꞌdauꞌ, san lu icj ládxiꞌdauꞌquëꞌ nacquëꞌ ca böꞌcuꞌ zugaꞌ sniaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yuguꞌ le tunëꞌ lac bëꞌ le nacquëꞌ. Cutu ruchibruꞌ le rbia lba uva lu yag yötsiꞌ, len cutu ruchibruꞌ le rbia yag higo lu guixiꞌ legui lasdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Cni nac, taꞌbía le nac dxiꞌa yúguꞌtë yag dxiꞌa, atiꞌ rbia le nac xöhuiꞌ yag xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Cutu gac cuia le nac xöhuiꞌ yag dxiꞌa naꞌ, len cutu gac cuia le nac dxiꞌa yag xöhuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yúguꞌtë yag cutaꞌbía le nac dxiꞌa laꞌrugu atiꞌ laꞌguꞌë leygac lu guiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Cni nac, lac bëꞌ le nacquëꞌ le tunëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gnëꞌ caꞌ Jesús: ―Zian nup të nedaꞌ: “Xan, Xan”, san clëg yúguꞌtëꞌ laꞌyaziëꞌ ga rna bëꞌë Dios yehuaꞌ yubá. Laꞌyazzëꞌ niꞌ bönniꞌ tunëꞌ ca rëꞌnnëꞌ Xuzaꞌ Dios, zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Catiꞌ gdxin dza udx qui yödzlyú ni, lëꞌ nedaꞌ bönniꞌ zian, laꞌnë́ꞌ: “Xan, Xan, bentuꞌ lban qui xtidzëꞌë Dios, buguntuꞌ dxin Lauꞌ Liꞌ, len buguntuꞌ caꞌ dxin Lauꞌ bubijtuꞌ yuguꞌ böꞌ xöhuiꞌ, len buguntuꞌ caꞌ dxin Lauꞌ bentuꞌ zian yöl‑laꞌ huac zxön.” ");
INSERT INTO zsrNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Niꞌr nedaꞌ gyëpaꞌ lequëꞌ: “Cutu caꞌ núnbëꞌa lbiꞌiliꞌ. Gul‑cuít ga zoaꞌ, lbiꞌiliꞌ ruaꞌliꞌ döꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Gnëꞌ caꞌ Jesús: ―Yetú caꞌ, nu ryöni xtidzaꞌa ni len gun ca rna, nu ni nac ca tu bönniꞌ rejniꞌi, buzóëꞌ lidxëꞌ ga nac lu guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Catiꞌ gul guiöjsiuꞌ len gzxön gbaꞌu, len gyeycj böꞌ, atiꞌ gdib nis cuit yuꞌu naꞌ, cutu gbix, le dxia xlibi lu guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Naꞌa, nu bönniꞌ ryönnëꞌ xtidzaꞌa ni, len cutu runëꞌ ca rna, bönniꞌ ni naquëꞌ ca tu bönniꞌ curejniꞌi, buzóëꞌ lidxëꞌ lu yuzx. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Catiꞌ gul guiöjsiuꞌ, len gzxön gbaꞌu, len gyeycj böꞌ, niꞌr gdaꞌ nis cuit yuꞌu naꞌ, atiꞌ gbixtë, len tsaz bguindj. ");
INSERT INTO zsrNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Catiꞌ budx bë́ꞌlenëꞌ lequëꞌ didzaꞌ ni Jesús, gulubani bunách zian niꞌ ca nac le rusëdnëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","le rusëdnëꞌ lequëꞌ ca bönniꞌ dë lu nëꞌë, len clëg ca tunëꞌ bönniꞌ gdauꞌ usëdi quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Catiꞌ bötjëꞌ Jesús lu guiꞌa naꞌ, zjaclen Lëꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bdxinëꞌ ga zoëꞌ Jesús bönniꞌ réꞌinëꞌ huëꞌ nudzuꞌ ruzö́d, atiꞌ buzechu zxibëꞌ lahuëꞌ Jesús, len rëꞌ Lëꞌ: ―Xan, chquiꞌ rëꞌnnuꞌ, huac unuꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Niꞌr bulitë nëꞌë Jesús len gdanëꞌ lëꞌ. Rëꞌ lëꞌ: ―Rëꞌndaꞌ. Huöacuꞌ dxiꞌa. Laꞌ bunittë xhuëꞌë bönniꞌ huëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Niꞌr gudxëꞌ lëꞌ Jesús: ―Byu, nutu nu guiꞌu cni, san gyeaj, yajluíꞌ cuinuꞌ lahuëꞌ bxuz, atiꞌ yajnö́dzj le gna bëꞌë Moisés le uluíꞌi bunách chböacuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Catiꞌ gyaziëꞌ Jesús yödz Capernaum, bdxinëꞌ ga zoëꞌ Jesús tu bönniꞌ nacuꞌë lu nëꞌë tu gayuꞌë bönniꞌ rjaquëꞌ gdil‑l, atiꞌ gútaꞌyuëꞌ lahuëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","rëꞌ Lëꞌ: ―Xan, biꞌi huen dxin quiaꞌ dëbiꞌ yuꞌu, réꞌibiꞌ huëꞌ nacuꞌnbiꞌ bin, len szxöni rzacaꞌ rguiꞌbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús rëꞌ lëꞌ: ―Nedaꞌ guidaꞌ unaꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bubiꞌë didzaꞌ bönniꞌ naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, rëꞌ Jesús: ―Xan, cutu nacaꞌ lsacaꞌ tsaziuꞌ lidxaꞌ, san tsa gnazuꞌ quiaꞌ, atiꞌ huöacbiꞌ biꞌi huen dxin quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Lëzcaꞌ nedaꞌ, zoa nu rna beꞌi nedaꞌ, len nacuꞌë caꞌ bönniꞌ rjaquëꞌ gdil‑l rna béꞌigacdaꞌ‑nëꞌ. Catiꞌ rëpaꞌ‑nëꞌ tuëꞌ: “Gyeaj niꞌ”, rijëꞌ. Catiꞌ rëpaꞌ‑nëꞌ yetúëꞌ: “Gda ni”, ridëꞌ. Catiꞌ rëpaꞌ‑nëꞌ bönniꞌ huen dxin quiaꞌ: “Ben dxin ni”, laꞌ runtëꞌ dxin naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Catiꞌ byönnëꞌ didzaꞌ ni Jesús, bubannëꞌ, atiꞌ gudxëꞌ bönniꞌ zjáclenëꞌ Lëꞌ, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, ga nacuáꞌ bunách Israel, nutu nu bönniꞌ rajxáquiꞌdaꞌ‑nëꞌ rejlëꞌë nedaꞌ ca runëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yetú caꞌ rëpaꞌ lbiꞌiliꞌ: Laꞌrúj bunách zian zacaꞌ ga rlen gbidz, len zacaꞌ ga rbia gbidz, atiꞌ laꞌböꞌlen tsazxö́n Abraham, len Isaac, len Jacob, niꞌ yehuaꞌ yubá ga rna bëꞌë Dios, ");
INSERT INTO zsrNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","san yuguꞌ bönniꞌ naꞌ gröczëꞌ Dios quië laꞌyaziëꞌ ga naꞌ rna bëꞌë Lëꞌ, chuꞌnëꞌ lequëꞌ niꞌl ga naꞌ nac chul, atiꞌ niꞌ laꞌbödxëꞌ, len lutíl‑l láyaꞌquëꞌ lu yöl‑laꞌ ruhuiꞌni quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Niꞌr Jesús gudxëꞌ bönniꞌ naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, rnëꞌ: ―Böaj lidxuꞌ. Ca naꞌ réjlëꞌu, caꞌ gac quiuꞌ. Laꞌ naꞌz böáctëbiꞌ biꞌi huen dxin queëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bdxinëꞌ Jesús lidxëꞌ Pedro, atiꞌ niꞌ bléꞌinëꞌ‑nu xnaꞌnu ngul queëꞌ Pedro, dënu lu daꞌa, len yuꞌnu tu xla. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gdanëꞌ naꞌnu Jesús, atiꞌ laꞌ burujtë tu xla naꞌ yuꞌnu. Niꞌr böasnu len bennnu le glahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Catiꞌ chrdzöꞌ dza naꞌ, djuaꞌquëꞌ ga zoëꞌ Jesús zian bönniꞌ yuꞌugac lequëꞌ böꞌ xöhuiꞌ, atiꞌ len yöl‑laꞌ rnëz queëꞌ bubijëꞌ yuguꞌ böꞌ xöhuiꞌ naꞌ, len bunëꞌ caꞌ yúguꞌtë nup teꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cni guc quië butság ca naꞌ gnëꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: “Lëꞌ buꞌë yuguꞌ le rzácaꞌruꞌ, len buꞌë caꞌ yuguꞌ guidzhuë́ꞌ queëruꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Catiꞌ bléꞌinëꞌ Jesús nacuáꞌ gdu cuitiëꞌ bunách zian, gna béꞌinëꞌ yuguꞌ bönniꞌ usë́d queëꞌ laꞌdödëꞌ yetsláꞌa nis zxön niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bdxinëꞌ ga naꞌ zoëꞌ Jesús tu bönniꞌ gdauꞌ usëdi, len rëꞌ Lëꞌ: ―Bönniꞌ Usëdi, sáꞌlenaꞌ Liꞌ gátiꞌtëz ga tsijuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús rëꞌ lëꞌ: ―Yuguꞌ bözaꞌ nacuáꞌ zxan guiöj quecbaꞌ, atiꞌ yuguꞌ bguindauꞌ, nudxía lidxcbaꞌ, san nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, cutu dë ga quixj icjaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yetúëꞌ bönniꞌ, naquëꞌ bönniꞌ usë́d queëꞌ Jesús, gudxëꞌ Lëꞌ: ―Xan, benn nedaꞌ latj huöjaꞌ ga gdxinr dza chbucachaꞌa‑nëꞌ xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús gudxëꞌ lëꞌ: ―Gdaꞌ nedaꞌ. Bëꞌ latj bönniꞌ tatczëꞌ lucachëꞌë nup lat quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Grenëꞌ Jesús lëꞌi bárcodauꞌ, dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Niꞌr gyeycj böꞌ bdunuꞌ lu nis zxön naꞌ, atiꞌ szxöni ryas rdxia nis zxön naꞌ ga bdxintë ryaz nis lëꞌi bárcodauꞌ naꞌ. Dëꞌ rasiëꞌ Jesús lëꞌi barco naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Niꞌr guladxinëꞌ ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ, atiꞌ guluspanëꞌ Lëꞌ, len tëꞌ Lëꞌ: ―Xan, buslá netuꞌ. Chrgáchiꞌruꞌ lu nis. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Bizx quië rádxiliꞌ? Latiꞌz réjlëꞌliꞌ‑nëꞌ Dios. Niꞌr gyasëꞌ Jesús len bulidzëꞌ böꞌ naꞌ reycj len nis zxön naꞌ, atiꞌ laꞌ gröꞌtë dxi. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gulubannëꞌ bönniꞌ naꞌ, taꞌnë́ꞌ: ―¿Nuzxa caz bönniꞌ ni? Ruiꞌzëꞌ didzaꞌ atiꞌ tun ca rnëꞌ böꞌ reycj len nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Catiꞌ bdxinëꞌ Jesús yetsláꞌa nis zxön ga naꞌ nac lu xyu yödz Gadara, gularujëꞌ chopëꞌ bönniꞌ ga nacuáꞌ ba quegac nup natgac, dutsagquëꞌ Jesús. Sniaꞌ nacquëꞌ, atiꞌ nutu nu rac töd laꞌ nöz niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Laꞌ gluiꞌtëꞌ zidzj didzaꞌ chopëꞌ ni, taꞌnë́ꞌ: ―¿Bizxa rál‑laꞌtuꞌ quiuꞌ, Jesús, Zxiꞌnëꞌ Dios? ¿Naruꞌ bdxintsuꞌ ni dusacaꞌ ziꞌu netuꞌ ziꞌal ca gdxin dza queëtuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ga niꞌ nacuꞌë nacuaꞌbaꞌ cuch zian taꞌdabaꞌ tágubaꞌ, nagaꞌnbaꞌ látiꞌdauꞌ ga nac ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gulanáb yechiꞌ Jesús böꞌ xöhuiꞌ naꞌ, të Lëꞌ: ―Chquiꞌ ubijuꞌ netuꞌ, benn latj tsajtsúꞌugactuꞌ‑baꞌ cuch zian niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Niꞌr Jesús gudxëꞌ leygac: ―Gul‑tséaj. Laꞌ gularujtë böꞌ xöhuiꞌ, yajtsazgac cuch zian niꞌ. Niꞌr jaréluꞌcbaꞌ yjacbaꞌ yúguꞌtëbaꞌ cuch zian naꞌ, yajbíxtëcbaꞌ ga nac lëꞌi guiöj, yajtsazcbaꞌ lu nis zxön, ga niꞌ gulayë́pibaꞌ nis, glatbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gládxinëꞌ bönniꞌ tuꞌyúëꞌ‑baꞌ cuch naꞌ, atiꞌ guluzxundjëꞌ. Catiꞌ guladxinëꞌ lu yödz, gulaguíxjöꞌë yúguꞌtë lë naꞌ guc quequëꞌ bönniꞌ niꞌ gulayúꞌu lequëꞌ böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Niꞌr gularúj bunách lu yödz niꞌ, yajtsagquëꞌ Jesús. Catiꞌ gulaléꞌinëꞌ Lëꞌ, glátaꞌyuëꞌ lahuëꞌ uzë́ꞌë lu xyuquëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Niꞌr bubenëꞌ Jesús lëꞌi bárcodauꞌ len gdödëꞌ yetsláꞌa nis zxön niꞌ, atiꞌ budxinëꞌ ga nac ladzëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Niꞌ djuaꞌquëꞌ ga zoëꞌ Jesús tu bönniꞌ nacuꞌnëꞌ bin, zxoëꞌ lu daꞌa yag. Catiꞌ bléꞌinëꞌ Jesús ca naꞌ taꞌyejlëꞌë Lëꞌ bönniꞌ ni, gudxëꞌ bönniꞌ naꞌ nacuꞌnëꞌ bin, rnëꞌ: ―Btip ladxuꞌu, zxíꞌnaꞌdauꞌ. Chbunít lahuaꞌ dul‑laꞌ nabaguꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nacuꞌë caꞌ niꞌ bönniꞌ gdauꞌ tuꞌsëdi, atiꞌ taꞌnë́ꞌ lu icj ládxiꞌdauꞌquëꞌ, taꞌnë́ꞌ: ―Didzaꞌ ruꞌë bönniꞌ ni ruzóa Dios tslaꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Catiꞌ ráquibeꞌinëꞌ Jesús le taꞌzáꞌ ládxiꞌquëꞌ, rëꞌ lequëꞌ: ―¿Bizx quië rzaꞌ ládxiꞌliꞌ cni le cunác? ");
INSERT INTO zsrNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Cutu nac baníg nu guiëz bönniꞌ ni: “Yuguꞌ dul‑laꞌ nabaguꞌu chbunít lahuaꞌ”, san nac baníg nu gun ga huöasëꞌ len uzéꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naꞌa, uluiꞌidaꞌ lbiꞌiliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, dë lu naꞌa yöl‑laꞌ uná bëꞌ luyú ni unít lahuaꞌ dul‑laꞌ. Niꞌr Jesús gudxëꞌ bönniꞌ naꞌ nacuꞌnëꞌ bin, rnëꞌ: ―Gyas. Bchis daꞌa yag quiuꞌ len böaj lidxuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Niꞌr laꞌ gyastëꞌ bönniꞌ naꞌ nacuꞌnëꞌ bin len böjëꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Catiꞌ gulaléꞌinëꞌ lë ni bönniꞌ nacuꞌë niꞌ, gulubannëꞌ, atiꞌ gulaguꞌë Dios yöl‑laꞌ ba le bunödzjëꞌ quegac bunách yöl‑laꞌ huac cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Catiꞌ buzë́ꞌë niꞌ Jesús, bléꞌinëꞌ bönniꞌ lëꞌ Mateo, röꞌë ga naꞌ ruquizxjëꞌ uláz qui yödz ziꞌtuꞌ, atiꞌ Jesús gudxëꞌ lëꞌ: ―Gdaꞌ nedaꞌ. Niꞌr laꞌ gyastëꞌ Mateo naꞌ, zéajlenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yetú le guc, catiꞌ niꞌ röꞌë Jesús rahuëꞌ ga nac lu yuꞌu, guladxinëꞌ ga zoëꞌ zian bönniꞌ tuꞌquízxj len yuguꞌ bönniꞌ caꞌz, atiꞌ gulabö́ꞌlenëꞌ Jesús tsazxö́n len yuguꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Catiꞌ gulaléꞌinëꞌ lë ni bönniꞌ gdauꞌ fariseo, gulanabnëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, taꞌnë́ꞌ: ―¿Bizx quië naꞌ rágulenëꞌ tsazxö́n bönniꞌ tuꞌquízxj len yelaꞌquëꞌ bönniꞌ dul‑laꞌ bönniꞌ rusëdnëꞌ lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Catiꞌ byönnëꞌ lë ni Jesús, rëꞌ lequëꞌ: ―Cutu naquincnëꞌ nu un bunách bönniꞌ nacquëꞌ dxiꞌa, san bönniꞌ téꞌinëꞌ naquincnëꞌ nu un bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gul‑tséaj len gul‑së́d le rna lë naꞌ nayúj lu guich laꞌy, rna cni: “Rëꞌndaꞌ luhuechiꞌ ládxiꞌquëꞌ lzaꞌquëꞌ bönniꞌ, len clëg ludödcdëꞌ‑baꞌ böaꞌ bëdx lu bcugu laꞌy quiaꞌ.” Bidaꞌ ni, clëg dulídzgacaꞌ‑nëꞌ bönniꞌ tsahuiꞌ, san bidaꞌ dulídzgacaꞌ‑nëꞌ bönniꞌ dul‑laꞌ quië lubíꞌi ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Niꞌr guladxinëꞌ ga zoëꞌ Jesús bönniꞌ daꞌquëꞌ Juan, bönniꞌ naꞌ buquilëꞌ bunách nis, len gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Bizx quië naꞌ netuꞌ lencaꞌ yuguꞌ bönniꞌ gdauꞌ fariseo, zian lzu runtuꞌ gubás, san yuguꞌ bönniꞌ usë́d quiuꞌ Liꞌ cutu tunëꞌ gubás? ");
INSERT INTO zsrNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ huactsa laꞌsëbi ládxiꞌgac nup nacuáꞌ lni qui yöl‑laꞌ rutság naꞌ tsal niꞌ zóalenëꞌ lequëꞌ bönniꞌ rutság nëꞌë? Ziꞌa zaꞌ dza catiꞌ gduëꞌ ga nacuꞌë bönniꞌ naꞌ rutság nëꞌë. Dza niꞌr lunëꞌ gubás. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Benëꞌ lsaquiꞌ Jesús, rnëꞌ: ―Nutu nu un lariꞌ tëb len lariꞌ cub, le uxúꞌn lariꞌ cub naꞌ nuguꞌë lariꞌ tëb naꞌ, atiꞌ gchözaꞌr lariꞌ tëb naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Lëzcaꞌ cni, nutu nu bönniꞌ rguëꞌë xisi uva cub lu röꞌö gul náquini guid, le gal xisi uva cub naꞌ, len uzxúzxj röꞌö gul naꞌ náquini guid, atiꞌ gac ditj xisi uva naꞌ, atiꞌ nit caꞌ röꞌö naꞌ náquini guid. Rgaꞌaruꞌ xisi uva cub lu röꞌö cub náquini guid, atiꞌ groptë tac chiꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsal niꞌ ruíꞌlenëꞌ lequëꞌ didzaꞌ ni Jesús, bdxinëꞌ ga zoëꞌ tu bönniꞌ rna béꞌinëꞌ bunách judío, atiꞌ buzechu zxibëꞌ lahuëꞌ Jesús, len rëꞌ Lëꞌ: ―Biꞌi nguldauꞌ quiaꞌ laꞌ budxtë gutbiꞌ. Gda gxoa naꞌu lëbiꞌ, atiꞌ ubanbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Laꞌ gyastëꞌ Jesús zéajlenëꞌ lëꞌ. Dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Niꞌr bdxinnu zacaꞌ cúdzuꞌlëꞌ Jesús ngul chguc chinnu iz réꞌinu, cutu ruhuíꞌi rön queënu qui huëꞌ quégaccznu ngul, atiꞌ gdannu lariꞌ nacuëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Cni bennu le rzaꞌ ládxiꞌnu, rnanu: “Chquiꞌ canzaꞌ zxëꞌ, huöacaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Niꞌr bueycjëꞌ Jesús, ruyúëꞌ lënu, atiꞌ rëꞌ‑nu: ―Btip ladxuꞌu, zxíꞌnaꞌdauꞌ. Chböacteuꞌ le réjlëꞌu nedaꞌ. Laꞌ naꞌz böáctënu. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Catiꞌ bdxinëꞌ Jesús lidxëꞌ bönniꞌ uná bëꞌ naꞌ, bléꞌinëꞌ niꞌ bönniꞌ tuꞌcödxëꞌ gui, len nup taꞌbö́dx yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús rëꞌ lequëꞌ: ―Gul‑cuít ni, le cutu natbiꞌ biꞌi nguldauꞌ ni. Raszbiꞌ naꞌ. Niꞌr gulutítj Lëꞌ nup nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Catiꞌ chnubijëꞌ niꞌl bunách naꞌ, gyaziëꞌ Jesús len gdel‑lëꞌë naꞌbiꞌ biꞌi ngul naꞌ, atiꞌ laꞌ gyástëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gzë didzaꞌ ca guc lë ni, atiꞌ gulayöni bunách nacuáꞌ gdutë luyú naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Catiꞌ brujëꞌ niꞌ Jesús, zjáclenëꞌ Lëꞌ chopëꞌ bönniꞌ nachúl lauquëꞌ. Tuꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Buechiꞌ ladxiꞌ netuꞌ, Liꞌ, zxiꞌn xsoëꞌ David. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Catiꞌ bdxinëꞌ Jesús ga nac lu yuꞌu, guladxinëꞌ ga zoëꞌ chopëꞌ bönniꞌ naꞌ nachúl lauquëꞌ. Jesús gnabnëꞌ lequëꞌ, rnëꞌ: ―¿I réjlëꞌliꞌ nedaꞌ, huac unaꞌ lbiꞌiliꞌ? Lequëꞌ taꞌnë́ꞌ: ―Ja, Xan. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Niꞌr gdanëꞌ yöj lauquëꞌ Jesús, rnëꞌ: ―Ca réjlëꞌliꞌ, caꞌ gac queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Laꞌ böaljtë yöj lauquëꞌ. Niꞌr buzeynëꞌ bach lequëꞌ Jesús, rnëꞌ: ―Gul‑güiꞌtecz ládxiꞌliꞌ nutu nu gnözi lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Catiꞌ gulurujëꞌ niꞌ, laꞌ guluzëtëꞌ didzaꞌ gdutë luyú niꞌ ca nac lë naꞌ benëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Catiꞌ gulurujëꞌ lu yuꞌu naꞌ Jesús len yuguꞌ bönniꞌ usë́d queëꞌ, guladxinëꞌ ga zoëꞌ Jesús bönniꞌ nachëꞌquëꞌ lahuëꞌ tu bönniꞌ curnë́ꞌ, yuꞌu lëꞌ böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Catiꞌ bubijëꞌ böꞌ xöhuiꞌ naꞌ Jesús, laꞌ gnëtëꞌ bönniꞌ naꞌ cugnë́ꞌ. Gulubannëꞌ bönniꞌ nacuꞌë niꞌ, taꞌnë́ꞌ: ―Gatga rléꞌinituꞌ le cni ladj bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Niꞌr gulanë́ꞌ queëꞌ bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―Bönniꞌ ni rubijëꞌ yuguꞌ böꞌ xöhuiꞌ, rugunëꞌ dxin yöl‑laꞌ huac qui xangac böꞌ xöhuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gdëꞌ Jesús gdu zbiꞌil gap nacuáꞌ yödz len gap nacuáꞌ yödzdauꞌ, atiꞌ gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, rusëdnëꞌ bunách nacuáꞌ niꞌ, len runëꞌ lban qui didzaꞌ dxiꞌa ca rna bëꞌë Dios. Bunëꞌ yúguꞌtë nup bi taꞌzacaꞌ taꞌguíꞌi yuguꞌ lu yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Catiꞌ bléꞌinëꞌ bunách zian niꞌ Jesús, buechiꞌ ladxëꞌë lequëꞌ, le taꞌzacaꞌ taꞌguiꞌë, len nudú ládxiꞌquëꞌ ca rac quecbaꞌ böꞌcuꞌ zxilaꞌ cuzóa nu uyú lecbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Niꞌr rëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Le nactë szxöni dë yöl, san nabábz nup taꞌláp. ");
INSERT INTO zsrNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Qui lë ni naꞌ, gul‑gátaꞌyu lahuëꞌ Dios, naquëꞌ Xan yöl naꞌ, gnábiliꞌ‑nëꞌ gsölëꞌë bönniꞌ huen dxin laꞌlapëꞌ yöl queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Niꞌr bulidzëꞌ Jesús idxínnutëꞌ bönniꞌ usë́d queëꞌ, len budödëꞌ lu naꞌquëꞌ yöl‑laꞌ uná bëꞌ lubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách, len luúnëꞌ yúguꞌtë nup teꞌi len yúguꞌtë nup bi taꞌzacaꞌ taꞌguíꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cni nac laquëꞌ idxínnutëꞌ gbaz naꞌ nasölëꞌë Jesús: Simón, (lëꞌ caꞌ Pedro), Andrés, (böchëꞌë Simón naꞌ), Jacobo, (zxiꞌnëꞌ Zebedeo), Juan, (böchëꞌë Jacobo naꞌ), ");
INSERT INTO zsrNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo, (bönniꞌ uquízxj), Jacobo, (zxiꞌnëꞌ Alfeo), Lebeo, (lëꞌ caꞌ Tadeo), ");
INSERT INTO zsrNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, (bönniꞌ ruiꞌ ladxëꞌë yödz queëꞌ), Judas Iscariote, (bönniꞌ udödëꞌ Jesús lu naꞌquëꞌ bönniꞌ ludöddëꞌ Lëꞌ). ");
INSERT INTO zsrNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Niꞌr Jesús bsölëꞌë idxínnutëꞌ bönniꞌ ni tsjenquëꞌ lban, atiꞌ gna béꞌinëꞌ lequëꞌ, rnëꞌ: ―Cutu tseajliꞌ ga nacuáꞌ bunách cunacgac judío, len cutu tsazliꞌ ladzgac bunách nacuáꞌ luyú Samaria. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gul‑tséaj ga nacuáꞌ bunách Israel, nacquëꞌ ca böꞌcuꞌ zxílaꞌdauꞌ nanitcbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gul‑tsjén lban, gnaliꞌ: “Chbdxin gal‑laꞌ dza gna bëꞌ luyú ni Nu naꞌ zoa yehuaꞌ yubá.” ");
INSERT INTO zsrNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gul‑ún nup teꞌi. Gul‑gún dxiꞌa nup teꞌi huëꞌ nudzuꞌ ruzö́d. Gul‑spán nup chnatgac. Gul‑bíj böꞌ xöhuiꞌ yuꞌugac bunách. Bennzaꞌ queëliꞌ yöl‑laꞌ uná bëꞌ ni. Gul‑gún dxin lei, cutu bi uquizxjliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Cutu bi guaꞌliꞌ lu bzud queëliꞌ, ni dumí oro, ni dumí plata, ni dumí lasdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Cutu guaꞌliꞌ yöxj yöt queëliꞌ le gáguliꞌ laꞌ nöz. Tuz lariꞌ gxoa yenliꞌ len cutu guaꞌliꞌ löl‑liꞌ o xuyág queëliꞌ, le udzölcznëꞌ bönniꞌ huen dxin le gahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Gátiꞌtëz yödz zxön o yödzdauꞌ ga gdxinliꞌ, gul‑náb nuzxa nac gdu ladxiꞌ lu yödz niꞌ, atiꞌ ugaꞌnliꞌ lidx nu naꞌ catiꞌ gal‑laꞌr dza urujliꞌ yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Catiꞌ tsazliꞌ tu lu yuꞌu, gul‑gáp Dios bunách nacuáꞌ lu yuꞌu naꞌ, gnábiliꞌ‑nëꞌ Dios unödzjëꞌ quequëꞌ le cuequi dxi icj ládxiꞌdauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chquiꞌ nacgac lsacaꞌ bunách nacuáꞌ lu yuꞌu niꞌ, ugaꞌnlen lequëꞌ le rbequi dxi ladxiꞌ naꞌ, san chquiꞌ cunacgac lsacaꞌ bunách naꞌ, gnabliꞌ cutu ugaꞌnlen lequëꞌ lë naꞌ rbequi dxi ladxiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gátiꞌtëz ga gdxinliꞌ ga cutu lun lbiꞌiliꞌ ba laꞌn bunách niꞌ, len cutu luzë́ nagquëꞌ xtídzaꞌliꞌ, gul‑rúj lu yuꞌu niꞌ o yödz niꞌ, atiꞌ gul‑cuíb bëchtö daꞌ lalabliꞌ, le uluíꞌi lequëꞌ nabágaꞌquëꞌ zxguiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Le nactë rëpaꞌ lbiꞌiliꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, laꞌzacaꞌ laꞌguíꞌir bunách yödz naꞌ ca laꞌzacaꞌ laꞌguíꞌi bunách gulacuáꞌ yödz Sodoma len yödz Gomorra, nup niꞌ busnitiëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Gnëꞌ caꞌ Jesús: ―Gul‑yutscaꞌ, nedaꞌ rsölaꞌa lbiꞌiliꞌ, gacliꞌ ca böꞌcuꞌ zxílaꞌdauꞌ taꞌdabaꞌ ga dzöꞌbaꞌ böꞌcuꞌ zugaꞌ sniaꞌ. Gul‑gác sinaꞌ ca naccbaꞌ sinaꞌ bël sniaꞌ, san gul‑gác caꞌ nöxj ladxiꞌ ca naccbaꞌ budödauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gul‑gún chiꞌi cuinliꞌ quegac bunách, le ludödëꞌ lbiꞌiliꞌ lu naꞌquëꞌ bönniꞌ yúlahuiꞌ, len laꞌguinëꞌ lbiꞌiliꞌ gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lëzcaꞌ cni, laꞌchë́ꞌë lbiꞌiliꞌ lauquëꞌ bönniꞌ blau len lauquëꞌ bönniꞌ taꞌná bëꞌë, le daꞌliꞌ nedaꞌ. Cni gac quië gac gunliꞌ lnaꞌ lau quiaꞌ lauquëꞌ bönniꞌ niꞌ len lauquëꞌ bönniꞌ cunacquëꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Niꞌr catiꞌ ludödëꞌ lbiꞌiliꞌ lu naꞌquëꞌ bönniꞌ uná bëꞌ naꞌ, cutu cöꞌliꞌ baguíꞌi nacx gnaliꞌ, le uchiziëꞌ Dios icj ládxiꞌdauꞌliꞌ laꞌ dza naꞌz didzaꞌ güiꞌliꞌ o ca gnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Clëg lbiꞌizliꞌ naꞌ gnaliꞌ, san Dios Böꞌ Laꞌy, Nu naꞌ rsölëꞌë queëliꞌ Xuzruꞌ Dios, Lëczëꞌ sóalenëꞌ lbiꞌiliꞌ len guꞌë didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Laꞌcuáꞌ bunách ludö́d bö́chiꞌgac lu naꞌquëꞌ bönniꞌ ludödcdëꞌ lequëꞌ, len lëzcaꞌ cni, bönniꞌ nacquëꞌ xuz ludödëꞌ zxiꞌnquëꞌ, atiꞌ laꞌcuꞌë bönniꞌ laꞌdáꞌbaguëꞌë xuzquëꞌ len lunëꞌ ga latiëꞌ xuzquëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Luzóa lbiꞌiliꞌ tslaꞌl yúguꞌtë bunách le daꞌliꞌ nedaꞌ, san nu ugáꞌn tsutsu ga gdxintër dza udx, nu ni ulá. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Catiꞌ lusacaꞌ ziꞌ lbiꞌiliꞌ bunách tu lu yödz, gul‑zxúndj niꞌ, tseajliꞌ yetú yödz, le rëpaꞌ lbiꞌiliꞌ, huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, ziꞌal catiꞌ udx gunliꞌ lban gap nacuáꞌ yödz quegac bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nútiꞌtëz nu nac bönniꞌ usë́d cutu nacrëꞌ blau ca nu rusëdi lëꞌ, len lëzcaꞌ cni, nu bönniꞌ naquëꞌ huen dxin cutu nacrëꞌ blau ca xanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu naꞌ nac bönniꞌ usë́d ral‑laꞌ udzijnëꞌ chquiꞌ huadél‑liꞌnëꞌ gaquëꞌ ca nac nu rusëdi lëꞌ, atiꞌ bönniꞌ huen dxin naꞌ ral‑laꞌ udzijnëꞌ chquiꞌ gaquëꞌ ca nac xanëꞌ. Chquiꞌ nedaꞌ nacaꞌ ca bönniꞌ xan yuꞌu, atiꞌ taꞌnë́ꞌ quiaꞌ, taꞌnë́ꞌ nacaꞌ Beelzebú tuꞌ xöhuiꞌ, szxö́nitër caꞌ laꞌnë́ꞌ quegac bunách laꞌdáꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Gnëꞌ caꞌ Jesús: ―Qui lë ni naꞌ, cutu gádxiliꞌ bunách. Hualáꞌ lahui yúguꞌtë le rac ba lanz, atiꞌ huac bëꞌ yúguꞌtë le nagachiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yuguꞌ didzaꞌ ruíꞌlenaꞌ lbiꞌiliꞌ ga nac chul, gul‑quixjöꞌ ga nac lu yeníꞌ, atiꞌ le rëpaꞌ lbiꞌiliꞌ ga nagachiꞌ, gul‑në́ zidzj ga nac yalj lulu. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cutu gádxiliꞌ nup tuꞌdödi gdu ca nayáꞌ nabingac bunách, san cutu gac lusnít böꞌ nacczruꞌ. Gul‑gadxi Dios, Nu naꞌ gac gdödi gdu ca nayáꞌ nabinliꞌ len chuꞌn böꞌ nacczliꞌ lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Taꞌdáꞌubaꞌ chopbaꞌ bguindauꞌ len tu dumí lasdauꞌ, san cugbixbaꞌ lyu nitubaꞌ chquiꞌ cutu ruꞌë latj Xuzruꞌ Dios gac cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lëzcaꞌ cni, nababgac lahuëꞌ Dios yúguꞌtë guitsaꞌ icjliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Qui lë ni naꞌ, cutu gádxiliꞌ. Ruiꞌtër ladxëꞌë lbiꞌiliꞌ Dios ca ruiꞌ ladxëꞌë‑baꞌ zianbaꞌ bguindauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Gnëꞌ caꞌ Jesús: ―Nu bönniꞌ siꞌ lu nëꞌë nedaꞌ laugac bunách, nedaꞌ siꞌ lu naꞌa bönniꞌ naꞌ lahuëꞌ Xuzaꞌ zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bönniꞌ taꞌdáꞌbaguëꞌë laugac bunách, taꞌnë́ꞌ cutu taꞌdë́ꞌë nedaꞌ, lëzcaꞌ cni nedaꞌ táꞌbagaꞌa lequëꞌ lahuëꞌ Xuzaꞌ zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Gnëꞌ caꞌ Jesús: ―Cutu gáquiliꞌ zaꞌa dguꞌa yödzlyú ni le rbequi dxi bunách. Cutu zaꞌa dguꞌa le rbequi dxi, san zaꞌa dguꞌa le gun ga laꞌrúj chopl bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Zaꞌa ni, gunaꞌ ga laꞌdáꞌbagaꞌ xuzquëꞌ bunách, len laꞌdáꞌbagaꞌnu caꞌ xnaꞌcnu ngul. Lëzcaꞌ cni, laꞌdáꞌbagaꞌnu yuguꞌ xtauꞌ zxiꞌnnu ngul zxoaꞌ lidxcnu. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Cni gac, laꞌ diꞌa dzaz quegac bunách lusacaꞌ ziꞌë lzaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nu nadxíꞌir xuz xnëꞌi ca nadxíꞌi nedaꞌ, cutu nac lsacaꞌ nu naꞌ taꞌ nedaꞌ, atiꞌ nu nadxíꞌir biꞌi bönniꞌ qui o biꞌi ngul qui ca nadxíꞌi nedaꞌ, cutu nac lsacaꞌ nu naꞌ taꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu cusíꞌ lu nëꞌi gac ca tu bönniꞌ zajtë́ꞌë lëꞌi yag cruz, len taꞌ nedaꞌ, cutu nac lsacaꞌ nu naꞌ gaqui quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nu ruiꞌ ladxiꞌ gun chiꞌi yöl‑laꞌ naꞌbán qui, unít lei, san nu unít yöl‑laꞌ naꞌbán qui le daꞌ nedaꞌ, ulá nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Gnëꞌ caꞌ Jesús: ―Nu gun lbiꞌiliꞌ ba laꞌn, nedaꞌ caꞌ gun ba laꞌn, atiꞌ nu naꞌ gun nedaꞌ ba laꞌn, gun ba laꞌn caꞌ Dios Xuz nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu gun ba laꞌn bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios le ruꞌë didzaꞌ uláz queëꞌ Dios, huadel‑liꞌ nu naꞌ lu nëꞌë Dios laꞌ leyz naꞌ gdél‑liꞌnëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. Lëzcaꞌ cni, nu gun ba laꞌn bönniꞌ tsahuiꞌ le naquëꞌ bönniꞌ tsahuiꞌ, huadel‑liꞌ nu naꞌ lu nëꞌë Dios laꞌ leyz naꞌ gdél‑liꞌnëꞌ bönniꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nútiꞌtëz nu unö́dzj queëꞌ tu bö́nniꞌdauꞌ ni tu zxbindauꞌz nis le naquëꞌ bönniꞌ usë́d quiaꞌ nedaꞌ, le nactë rëpaꞌ lbiꞌiliꞌ, cutu unít le ral‑laꞌ siꞌ nu naꞌ lu nëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Catiꞌ Jesús budx buzéjniꞌnëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, buzë́ꞌë niꞌ, zijëꞌ rajsëdnëꞌ bunách len rjenëꞌ lban yuguꞌ ladzgac bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Niꞌ yuꞌë lidx guia Juan, bönniꞌ buquilëꞌ bunách nis, byönnëꞌ ca nacgac le runëꞌ Jesús. Niꞌr Juan naꞌ bsölëꞌë chopëꞌ bönniꞌ daꞌquëꞌ lëꞌ, atiꞌ guladxinëꞌ ga naꞌ zoëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Chopëꞌ ni gulanabnëꞌ Jesús, tëꞌ Lëꞌ: ―¿I nacuꞌ Liꞌ Cristo, Bönniꞌ naꞌ ral‑laꞌ gdxinëꞌ yödzlyú ni, o huaböztuꞌ dza gdxinëꞌ yetúëꞌ bönniꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑tséaj tsajtíxjöiꞌliꞌ‑nëꞌ Juan lë ni ryö́niliꞌ len rléꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gul‑tsjödxëꞌ ca rac, tuꞌléꞌinëꞌ bönniꞌ bchul lauquëꞌ, atiꞌ tuꞌzë́ꞌë bönniꞌ cuguladë́ꞌ. Nuhuöacquëꞌ bönniꞌ güiꞌcnëꞌ huëꞌ nudzuꞌ ruzö́d, atiꞌ tuꞌyönnëꞌ bönniꞌ gulacödzuëꞌ. Tuꞌbanquëꞌ bönniꞌ glatiëꞌ, atiꞌ rac lban qui didzaꞌ dxiꞌa laugac bunách yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bicaꞌ ba bönniꞌ cugác chop ladxëꞌë, cu ubíj ladxëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Catiꞌ guluzë́ꞌë zhuöjquëꞌ bönniꞌ naꞌ daꞌquëꞌ Juan, niꞌr gzu lahuëꞌ Jesús ruíꞌlenëꞌ bunách nacuáꞌ niꞌ didzaꞌ ca nac queëꞌ Juan naꞌ. Rëꞌ lequëꞌ: ―¿Bizxa gúꞌniliꞌ gléꞌiliꞌ catiꞌ niꞌ gyeajliꞌ lu latj caꞌz? ¿Naruꞌ gúꞌniliꞌ gléꞌiliꞌ‑nëꞌ bönniꞌ naquëꞌ ca tu gui ruzéycj lei böꞌ reycj? ");
INSERT INTO zsrNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Chquiꞌ clëg, ¿bizxa gúꞌniliꞌ gléꞌiliꞌ? ¿Naruꞌ gúꞌniliꞌ gléꞌiliꞌ‑nëꞌ bönniꞌ nacuëꞌ lariꞌ dxíꞌadauꞌ? Nö́ziczliꞌ nacuꞌë lidxquëꞌ bönniꞌ taꞌná bëꞌë bönniꞌ nácuquëꞌ lariꞌ dxíꞌadauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yetú caꞌ, ¿bizxa gúꞌniliꞌ gléꞌiliꞌ? ¿Naruꞌ gúꞌniliꞌ gléꞌiliꞌ‑nëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios? Caꞌ nac, ráquidaꞌ. Rëpaꞌ lbiꞌiliꞌ, bléꞌiliꞌ‑nëꞌ bönniꞌ náctërëꞌ blau ca yezícaꞌrëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cni nac, le naquëꞌ Juan bönniꞌ naꞌ ruiꞌ didzaꞌ ca nac queëꞌ le nayúj lu guich laꞌy, rna: Byu, rsölaꞌa bönniꞌ gbaz quiaꞌ, nörëꞌ ca Liꞌ. Lëꞌ upë́ꞌë nöz ga töduꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Le nactë rëpaꞌ lbiꞌiliꞌ. Gdutë yödzlyú ni, nutu nu zoa nacr blau ca Juan, bönniꞌ niꞌ buquilëꞌ bunách nis, san nu nac cuídiꞌdauꞌz ga rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá nactër blau ca Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Catiꞌ niꞌ gzu lahuëꞌ buquilëꞌ bunách nis Juan, ga rdxintë naꞌa dza, bayúdx taꞌyáz bunách ga rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá, atiꞌ nup tunz bayúdx taꞌdel‑liꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ga bdxintë dza naꞌ blëꞌë Juan, le rna bëꞌ zxba queëꞌ Moisés len le guluzujëꞌ lu guich yúguꞌtë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios gluiꞌ didzaꞌ ca rna bëꞌ Nu naꞌ zoa yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chquiꞌ rë́ꞌniliꞌ siꞌ lu naꞌliꞌ lë ni, ral‑laꞌ gnö́ziliꞌ Juan naꞌ naquëꞌ Elías, bönniꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, bönniꞌ naꞌ Dios gnëꞌ ral‑laꞌ glaꞌ lahuëꞌ leyúbl dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nu zoa nag len ryöni ral‑laꞌ uzë́ nag. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Bizxa usáquiꞌdaꞌ bunách nacuáꞌ dza ni zoaruꞌ naꞌa? Nacquëꞌ ca biꞌidauꞌ taꞌböꞌbiꞌ lu yëꞌy. Zidzj tuꞌlídz lzaꞌcbiꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","taꞌnabiꞌ: “Rucödxtuꞌ queëliꞌ gui. ¿Bizx quië cutu ryaꞌliꞌ? Rul‑l yéchiꞌtuꞌ queëliꞌ. ¿Bizx quië cutu rbödx yéchiꞌliꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Cni nacliꞌ, le bidëꞌ Juan atiꞌ le cutu güiꞌ gdahuëꞌ ca ráguliꞌ lbiꞌiliꞌ, gnëliꞌ queëꞌ: “Tuꞌ xöhuiꞌ dzag lëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Niꞌr bdxinaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, len riꞌj rahuaꞌ, atiꞌ rnëliꞌ quiaꞌ: “Naquëꞌ bönniꞌ huágulëꞌë len bönniꞌ riꞌjëꞌ. Naquëꞌ lzaꞌquëꞌ bönniꞌ uquízxj len yezicaꞌ huen dul‑laꞌ.” Yöl‑laꞌ rejniꞌi queëꞌ Dios nac bëꞌ niꞌa qui le tun nup taꞌzíꞌ lu naꞌgac lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Niꞌr gzu lahuëꞌ Jesús ruzeynëꞌ bach bunách nacuáꞌ yödz gap niꞌ benëꞌ zian yöl‑laꞌ huac, le cutuꞌbiꞌini ládxiꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Gudxëꞌ lequëꞌ: ―Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bunách Corazín. Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bunách Betsaida. Laꞌnaruꞌ glac lu yödz Tiro len lu yödz Sidón yuguꞌ yöl‑laꞌ huac benaꞌ ga zoaliꞌ, dza niꞌtël lubíꞌi ládxiꞌgac bunách Tiro len Sidón naꞌ, lacuëꞌ lariꞌ tëb len ludxíëꞌ dö icjquëꞌ, le luluíꞌ tuꞌbíꞌi ládxiꞌgac bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, sacaꞌ quiꞌrliꞌ lbiꞌiliꞌ ca laꞌzacaꞌ laꞌguíꞌi bunách Tiro len Sidón, nup naꞌ busnitiëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lbiꞌiliꞌ, bunách Capernaum, guc queëliꞌ ca bdxíntëliꞌ ga nu ryaz yehuaꞌ yubá. Huötjliꞌ lu guiꞌ gabíl. Laꞌnaruꞌ glac lu yödz Sodoma yöl‑laꞌ huac benaꞌ ga zoaliꞌ, lugáꞌn bunách yödz niꞌ ga rdxintë naꞌa dza. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, sacaꞌ quiꞌrliꞌ lbiꞌiliꞌ ca laꞌzacaꞌ laꞌguíꞌi bunách Sodoma naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dza naꞌ bëꞌë didzaꞌ Jesús, rnëꞌ: ―Rguꞌa Liꞌ yöl‑laꞌ ba, Xuzaꞌ, nacuꞌ Xani yehuaꞌ yubá len Xani luyú ni, le bucachuꞌu lë ni, cui laꞌléꞌinëꞌ lei bönniꞌ taꞌyéjniꞌnëꞌ, san buluiꞌinuꞌ lei nup nacgac ca biꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Caꞌ gac, Xuzaꞌ, le cni bdzag ladxuꞌu Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yúguꞌtë nudödëꞌ lu naꞌa Xuzaꞌ. Nutu nu nunbëꞌ nedaꞌ, Zxiꞌnëꞌ Dios, san tuzëꞌ Dios Xuz, len nutu nu nunbëꞌ Lëꞌ Dios Xuz, san tuzaꞌ nedaꞌ, Zxiꞌnëꞌ Dios, lencaꞌ nup naꞌ rëꞌndaꞌ uluiꞌidaꞌ leygac Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Gul‑dá ga zoaꞌ yúguꞌtëliꞌ rajxáquiꞌliꞌ le rúnteczliꞌ dxin qui gdauꞌ, len nuaꞌliꞌ yuaꞌ ziꞌi quegac zxba qui gdauꞌ, atiꞌ nedaꞌ gunaꞌ ga uzíꞌ ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lu yöl‑laꞌ nöxj ladxiꞌ queëliꞌ gul‑gún xchinaꞌ, gacliꞌ ca bëdx taꞌziꞌbaꞌ yuguꞌ quecbaꞌ. Gul‑së́d lu naꞌa nedaꞌ, le nacaꞌ nöxj ladxiꞌ len cuidiꞌ ladxiꞌ, atiꞌ gdzöl queëliꞌ yöl‑laꞌ ruzíꞌ ladxiꞌ, le cuequi dxi ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yuguꞌ naꞌ uguꞌa lbiꞌiliꞌ, le nac le gna béꞌidaꞌ lbiꞌiliꞌ, cutu nac baníg, atiꞌ yuaꞌ uguꞌa lbiꞌiliꞌ le nac le rusëddaꞌ, dzaꞌdauꞌz nac. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dza niꞌ, le nac dza laꞌy quequëꞌ bönniꞌ judío, gdödëꞌ Jesús gap dë yöl zxoaꞌ xtil, atiꞌ taꞌdunëꞌ bönniꞌ usë́d queëꞌ len gulazú lauquëꞌ taꞌleycjëꞌ deu ga dxia zxoaꞌ xtil len tahuëꞌ zxoaꞌ xtil naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Catiꞌ gulaléꞌinëꞌ lë ni bönniꞌ gdauꞌ fariseo, tëꞌ Jesús: ―Byutscaꞌ, tunëꞌ bönniꞌ usë́d quiuꞌ le cural‑laꞌ gunruꞌ dza laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Niꞌr Jesús gudxëꞌ lequëꞌ: ―¿Naruꞌ cu nulábiniliꞌ lu guich laꞌy bi benëꞌ David catiꞌ gdunëꞌ atiꞌ guladún caꞌ nup gulacuaꞌlen lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gyaziëꞌ lu yuꞌu queëꞌ Dios len gdahuëꞌ yuguꞌ yöt xtil naguꞌuquëꞌ lu bcugu laꞌy, le cural‑laꞌ gahuëꞌ lëꞌ len cutu ral‑laꞌ lahuëꞌ bönniꞌ gulacuáꞌlenëꞌ lëꞌ, san légaczëꞌ bxuz dë latj lahuëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Naruꞌ cu nulábiniliꞌ le rna bëꞌ zxba queëꞌ Moisés ca tunëꞌ bxuz yuguꞌ dza laꞌy? Tunëꞌ dxin löꞌa gdauꞌ yuguꞌ dza laꞌy, len cutu taꞌbaguëꞌë zxguiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naꞌa, nedaꞌ rëpaꞌ lbiꞌiliꞌ, ni zoaꞌ nedaꞌ, nacaꞌ bönniꞌ nacrëꞌ blau ca gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cutu réjniꞌliꞌ lë naꞌ nayúj lu guich laꞌy, rna: “Rëꞌndaꞌ huechiꞌ ládxiꞌliꞌ lzaꞌliꞌ, len clëg gdö́digacliꞌ‑baꞌ böaꞌ bëdxdauꞌ ruzéguiꞌgacliꞌ‑baꞌ lu bcugu laꞌy quiaꞌ.” Laꞌnaruꞌ réjniꞌliꞌ lë ni, cutu gchúguliꞌ quegac nup cutaꞌbagaꞌ zxguiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Caꞌ nac, le nacaꞌ Xani dza laꞌy nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Niꞌr buzë́ꞌë niꞌ Jesús, atiꞌ gyaziëꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lu yuꞌu naꞌ zoëꞌ tu bönniꞌ narequiꞌ nëꞌë, atiꞌ le tëꞌnnëꞌ laꞌdzölnëꞌ bi luquíëꞌ Jesús, qui lë ni naꞌ gulanabnëꞌ Lëꞌ bönniꞌ judío uná bëꞌ naꞌ, taꞌnë́ꞌ: ―¿I dë latj unruꞌ nu reꞌi catiꞌ nac dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Nu bönniꞌ nutsëꞌë ladjliꞌ, chquiꞌ zoabaꞌ tubaꞌ böꞌcuꞌ zxilaꞌ queëꞌ, len chquiꞌ gbixbaꞌ lu yeru catiꞌ nac dza laꞌy, ¿naruꞌ cu tsajxönëꞌ‑baꞌ len tsajlijëꞌ‑baꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Záquiꞌtsquirnëꞌ tu bönniꞌ ca tubaꞌ böꞌcuꞌ zxilaꞌ. Qui lë ni naꞌ, dë latj gunruꞌ quegac bunách le nac dxiꞌa catiꞌ nac dza laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Niꞌr Jesús gudxëꞌ bönniꞌ huëꞌ naꞌ: ―Bli naꞌu. Catiꞌ bulí nëꞌë, laꞌ böactë dxiꞌa ca nac yetsláꞌa nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Niꞌr gulurujëꞌ bönniꞌ gdauꞌ fariseo naꞌ atiꞌ glun xtídzaꞌquëꞌ ludöddëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Catiꞌ ráquibeꞌinëꞌ lë ni Jesús, buzë́ꞌë niꞌ, atiꞌ zjaclen Lëꞌ bunách zian. Jesús bunëꞌ yúguꞌtë nup teꞌi ladj bunách naꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","len gna béꞌinëꞌ lequëꞌ cutu laꞌguíxjöiꞌnëꞌ bunách nu naquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cni gnëꞌ, quië butság lë naꞌ gnëꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Gul‑yutscaꞌ, bönniꞌ ni naquëꞌ huen dxin quiaꞌ, Nu naꞌ gröczaꞌ nedaꞌ. Nadxiꞌidaꞌ Lëꞌ len rdzag ladxaꞌa Lëꞌ. Uchiziaꞌ Lëꞌ Böꞌ Laꞌy. Lëꞌ quíxjöiꞌnëꞌ yúguꞌtë bunách ca gunaꞌ, Cuequi xbeydaꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nutu nu tíl‑lenëꞌ didzaꞌ len cutu ulidzëꞌ zidzj, Len nutu nu yöni chiꞌë ga nac ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tu guidauꞌ zoa bö cutu quitsjëꞌ lei, Atiꞌ guiꞌ chzoa ul, cutu usulëꞌ lei, Catiꞌ uzoarëꞌ le nac tsahuiꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lun löz Lëꞌ yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Niꞌr djuaꞌquëꞌ ga zoëꞌ Jesús tu bönniꞌ nachúl lahuëꞌ len curnë́ꞌ, le yuꞌu lëꞌ böꞌ xöhuiꞌ, atiꞌ Jesús bunëꞌ bönniꞌ naꞌ. Cni guc, rléꞌinëꞌ len ruꞌë didzaꞌ bönniꞌ naꞌ bchul lahuëꞌ len cugnë́ꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Qui lë ni naꞌ gulubani yúguꞌtë bunách nacuáꞌ niꞌ, taꞌná: ―¿Naruꞌ nactsëꞌ Zxiꞌn Xsoëꞌ David bönniꞌ ni, Bönniꞌ naꞌ ral‑laꞌ guidëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Catiꞌ gulayönnëꞌ lë ni bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―Bönniꞌ ni rubijëꞌ yuguꞌ böꞌ xöhuiꞌ le dzag Lëꞌ Beelzebú tuꞌ xöhuiꞌ, xangac böꞌ xöhuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ráquibeꞌinëꞌ Jesús lë naꞌ taꞌzáꞌ ládxiꞌquëꞌ atiꞌ rëꞌ lequëꞌ: ―Gátiꞌtëz ga taꞌná bëꞌ bunách, chquiꞌ laꞌrúj chopl len laꞌdil‑len lzaꞌgac bunách niꞌ, nit yöl‑laꞌ uná bëꞌ quequëꞌ. Lëzcaꞌ cni, chquiꞌ laꞌrúj chopl bunách nacuáꞌ tu yödz o tu yuꞌu, len laꞌdíl‑l, cutu gac laꞌdíaꞌ bunách nacuáꞌ yödz naꞌ o yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lëzcaꞌ cni, chquiꞌ ubíj laꞌ lzëꞌiz Satanás tuꞌ xöhuiꞌ, len laꞌdil‑len laꞌ leygacz böꞌ xöhuiꞌ naꞌ, ¿nacxcz gac gdiaꞌ yöl‑laꞌ uná bëꞌ qui tuꞌ xöhuiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Rnaliꞌ quiaꞌ rubijaꞌ yuguꞌ böꞌ xöhuiꞌ le dzag nedaꞌ Beelzebú tuꞌ xöhuiꞌ. Chquiꞌ runaꞌ cni, ¿nuzxa dzag nup daꞌgac lbiꞌiliꞌ catiꞌ tuꞌbíj böꞌ xöhuiꞌ? Qui lë ni naꞌ le tunczëꞌ nac bëꞌ nachíxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Naꞌa, chquiꞌ nedaꞌ rubijaꞌ yuguꞌ böꞌ xöhuiꞌ le zoalen nedaꞌ yöl‑laꞌ huac queëꞌ Dios Böꞌ Laꞌy, le nactë chbdxin ga zoaliꞌ le rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Naruꞌ huactsa nu bönniꞌ tsaziëꞌ lidxëꞌ bönniꞌ nal len cuijëꞌ yuguꞌ yöl‑laꞌ tsahuiꞌ dzöꞌ lidxëꞌ chquiꞌ ziꞌal cutu gúguëꞌë bönniꞌ nal naꞌ? Niꞌr gac tsaziëꞌ ulatjëꞌ lidxëꞌ bönniꞌ nal naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nu curún nedaꞌ tsazxö́n, rdáꞌbagaꞌ nedaꞌ, len nu curutúb tsazxö́n len nedaꞌ, ruslás nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ, ca nac yúguꞌtë dul‑laꞌ tun bunách len yuguꞌ didzaꞌ xöhuiꞌ taꞌná, unít lahuëꞌ lequëꞌ Dios, san nu bönniꞌ gnë ziꞌë queëꞌ Dios Böꞌ Laꞌy, cutu caꞌ unít lahuëꞌ lëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lëzcaꞌ cni, nu bönniꞌ gnëꞌ quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, Dios unít lahuëꞌ lëꞌ, san nu bönniꞌ gnëꞌ queëꞌ Dios Böꞌ Laꞌy, cutu caꞌ unít lahuëꞌ lëꞌ Dios. Cutu unít lahuëꞌ lëꞌ dza ni zoaruꞌ naꞌa, len cutu unít lahuëꞌ lëꞌ dza ziꞌa zaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gnëꞌ caꞌ Jesús: ―Chquiꞌ nac dxiꞌa yag, cuia le nac dxiꞌa yag naꞌ, san chquiꞌ nac xöhuiꞌ yag, cuia caꞌ le nac xöhuiꞌ. Cni nac, le rbia yag nac bëꞌ yag naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lbiꞌiliꞌ, diꞌa dza quecbaꞌ bël sniaꞌ nacliꞌ. ¿Nacx gac güiꞌliꞌ dxiꞌa didzaꞌ, chquiꞌ nacliꞌ xöhuiꞌ? Ca nac le taꞌzáꞌ ládxiꞌgac bunách, lëzcaꞌ cni tuiꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Didzaꞌ dxiꞌa ruꞌë bönniꞌ dxiꞌa le yuꞌu icj ládxiꞌdauꞌhuëꞌ le nac dxiꞌa, san didzaꞌ cunác dxiꞌa ruꞌë bönniꞌ huiaꞌdöꞌ le yuꞌu icj ládxiꞌdauꞌhuëꞌ le cunác dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, cuequi xbeynëꞌ bunách ca nac yúguꞌtë didzaꞌ gulanazëꞌ caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ca nac didzaꞌ ruꞌu, cuequi xbeynëꞌ liꞌ, atiꞌ urujuꞌ dxiꞌa o gbaguꞌu zxguiaꞌ niꞌa qui didzaꞌ naꞌ bëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niꞌr gulubiꞌë didzaꞌ yuguꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ tuꞌsëdi, tëꞌ Jesús: ―Bönniꞌ Usëdi, rë́ꞌnituꞌ gléꞌituꞌ tu le gunuꞌ le gac bëꞌ dë lu naꞌu yöl‑laꞌ uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Taꞌnabnëꞌ nedaꞌ gunaꞌ tu le gac bëꞌ nu nacaꞌ bönniꞌ tuaꞌdöꞌ ni, cuzóa gdu ládxiꞌquëꞌ. Cutu bi le gac bëꞌ laꞌléꞌinëꞌ, san tuz le nac bëꞌ naꞌ ca guc queëꞌ Jonás, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ca naꞌ guc queëꞌ Jonás naꞌ, bugaꞌnëꞌ lëꞌbaꞌ böl zxön gdu tsonn dza tsonn yël, lëzcaꞌ cni gac quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, tsonn dza tsonn yël ugaꞌnaꞌ zxan yu. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bönniꞌ gulacuꞌë yödz Nínive laꞌyasëꞌ dza gchuguëꞌ Dios quegac bunách catiꞌ cuequi xbeynëꞌ bunách dza ni zoaruꞌ naꞌa, atiꞌ le glunëꞌ uspagaꞌ bunách ni zxguiaꞌ le gulubíꞌi ládxiꞌquëꞌ bönniꞌ Nínive naꞌ catiꞌ niꞌ gdíxjöiꞌnëꞌ lequëꞌ Jonás xtidzëꞌë Dios, atiꞌ naꞌa zoaꞌ ni nedaꞌ, len náctëraꞌ blau ca Jonás naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lëzcaꞌ cni, ngul niꞌ gna béꞌinu yödz dë zacaꞌ ga rdöd gbidz beoꞌ ziag tsasnu dza gchuguëꞌ Dios quegac bunách catiꞌ cuequi xbeynëꞌ bunách dza ni zoaruꞌ naꞌa, atiꞌ le bennu uspagaꞌ lequëꞌ zxguiaꞌ, le brujnu ngul naꞌ ga nactër ziꞌtuꞌ quië yö́ninu didzaꞌ rejniꞌi bëꞌë Salomón, atiꞌ naꞌa zoaꞌ ni nedaꞌ, len náctëraꞌ blau ca Salomón naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Gnëꞌ caꞌ Jesús: ―Catiꞌ r‑ruj böꞌ xöhuiꞌ yuꞌu bönniꞌ, rda gap nabídx, rguilj ga uzíꞌ ladxiꞌ. Chquiꞌ cutu gdzöli ga naꞌ uzíꞌ ladxiꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","niꞌr gna: “Huöjaꞌ xlatjaꞌ ga niꞌ brujaꞌ.” Catiꞌ udxín ga niꞌ bruj, tsajxacaꞌ bönniꞌ naꞌ, naquëꞌ ca tu yuꞌu nadách, len nalúa, len chnabáꞌa quië nu tsajsóa niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Niꞌr tseaj, tsajxíꞌ yegádx böꞌ xöhuiꞌ nácgactër xöhuiꞌ ca lei, atiꞌ laꞌyáz yúguꞌtë, len laꞌcuáꞌ lu bönniꞌ naꞌ, atiꞌ ga udx huayáliꞌtër ca gac queëꞌ bönniꞌ naꞌ ca guc queëꞌ ziꞌal. Lëzcaꞌ cni gac quegac bunách tuaꞌdöꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Catiꞌ niꞌ ruíꞌlenëꞌ bunách didzaꞌ ni Jesús, guladxinëꞌ niꞌ xnëꞌë Jesús len yuguꞌ bönniꞌ böchëꞌë. Gulacuꞌë löꞌal len glëꞌnnëꞌ luíꞌlenëꞌ Jesús didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Niꞌr gdíxjöiꞌnëꞌ Jesús tu bönniꞌ, rëꞌ Lëꞌ: ―Byutscaꞌ, nacuꞌë löꞌal xnaꞌu len yuguꞌ bönniꞌ böchuꞌu, tëꞌnnëꞌ luíꞌlenëꞌ Liꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Bubiꞌë didzaꞌ Jesús, rëꞌ bönniꞌ naꞌ gdíxjöiꞌnëꞌ Lëꞌ cni, rnëꞌ: ―¿Nuzxa caz xnaꞌa len nupxcz bönniꞌ böchaꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Niꞌr bulí nëꞌë, buluꞌë yuguꞌ bönniꞌ usë́d queëꞌ, len rnëꞌ: ―Byutscaꞌ, bönniꞌ ni nacquëꞌ ca xnaꞌczaꞌ len bö́chiꞌczaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nútiꞌtëz nu run ca rëꞌncznëꞌ Xuzaꞌ zoëꞌ yehuaꞌ yubá, nu ni nac biꞌi bö́chiꞌczaꞌ, len biꞌi zanczaꞌ, len xnaꞌczaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Laꞌ dza niꞌz brujëꞌ Jesús lu yuꞌu, atiꞌ yajchöꞌë raꞌ nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Le guladxín ga zoëꞌ Jesús bunách zian, grenëꞌ tu lëꞌi bárcodauꞌ, len gröꞌë niꞌ, atiꞌ bunách zian naꞌ gulacuáꞌ luyú bidx raꞌ nis zxön naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Niꞌr bë́ꞌlenëꞌ lequëꞌ didzaꞌ Jesús, zian le busëdnëꞌ lequëꞌ, yuguꞌ le benëꞌ lsaquiꞌ, rnëꞌ: ―Gul‑yutscaꞌ, brujëꞌ bönniꞌ guz, zjësiëꞌ xseydauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tsal niꞌ zjësiëꞌ, glas raꞌ nöz laꞌgac xseydauꞌ naꞌ, atiꞌ guladxinbaꞌ bguindauꞌ, glëꞌjbaꞌ xseydauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Glas luyú ga röꞌ guiöj yelaꞌgac xseydauꞌ naꞌ, ga naꞌ curö́ꞌ szxöni yu, atiꞌ laꞌ gulalentë, le curö́ꞌ niꞌ szxöni yu. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Niꞌr catiꞌ budzáꞌa, laꞌ gulacuadtë len gulabídx lë naꞌ bësiëꞌ, le cunác ga lun luí. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gulalén ga gululén lba yötsiꞌ yelaꞌgac xseydauꞌ naꞌ glas, atiꞌ gulazxö́n lba yötsiꞌ naꞌ len gularöli lë naꞌ bësiëꞌ, glun ditj lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Glas ga nac luyú dxiꞌa yelaꞌgac xseydauꞌ naꞌ, atiꞌ gulunö́dzj. Gulunö́dzj yetú gayuaꞌtër caꞌ laꞌgac lë naꞌ bësiëꞌ. Gulunö́dzj yetsonnlalj caꞌ yelaꞌgac naꞌ, atiꞌ gulunö́dzj yechí uruáꞌ caꞌ yelaꞌgac naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nu zoa nag len ryöni, ral‑laꞌ uzë́ nag. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Niꞌr guladxinëꞌ ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ len gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Bizx quië ruíꞌlenuꞌ bunách didzaꞌ yuguꞌ le runuꞌ lsaquiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Ruꞌë lbiꞌiliꞌ latj Dios tséjniꞌliꞌ le nagachiꞌ ca rna bëꞌë Lëꞌ yehuaꞌ yubá, san cutu tëꞌni laꞌyejniꞌi bunách ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nu dë qui, Dios unödzjëꞌ qui yelatiꞌ, atiꞌ szxö́nitër gataꞌ qui, san nu cudë́ qui, laꞌz dui le dë qui gdua. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Qui lë ni naꞌ ruíꞌlenaꞌ lequëꞌ didzaꞌ yuguꞌ le runaꞌ lsaquiꞌ, le tuꞌyúëꞌ san cutu taꞌléꞌinëꞌ. Taꞌyönnëꞌ san cutu tuꞌzë́ nagquëꞌ len cutu taꞌyéjniꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cni rac quequëꞌ quië utság lë naꞌ gnëꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: Le nactë yö́niliꞌ san cutu tséjniꞌliꞌ. Uyuliꞌ gnaꞌliꞌ san cutu gléꞌiliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Le nazíd ládxiꞌdauꞌgac bunách ni, Len cutu ryaz icj nagquëꞌ. Nadzudiꞌ yöj lauquëꞌ, Cui laꞌléꞌinëꞌ len yöj lauquëꞌ naꞌ. Cutu luzë́ nagquëꞌ Len cutu luzejniꞌi ládxiꞌquëꞌ, Len cutu luhuöaquëꞌ quiaꞌ nedaꞌ Quië gac unaꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Naꞌa, bicaꞌ ba lbiꞌiliꞌ, le rleꞌi yöj lauliꞌ len ryöni nagliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Le nactë rëpaꞌ lbiꞌiliꞌ, glëꞌnnëꞌ laꞌléꞌinëꞌ le rléꞌiliꞌ lbiꞌiliꞌ zian bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios len yuguꞌ bönniꞌ tsahuiꞌ san cutu gulaléꞌinëꞌ lei. Glëꞌnnëꞌ laꞌyönnëꞌ le ryö́niliꞌ lbiꞌiliꞌ san cutu gulayönnëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gnëꞌ caꞌ Jesús: ―Gul‑zë́ nagliꞌ ca nac le benaꞌ lsaquiꞌ qui bönniꞌ guz. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nútiꞌtëz nu ryöni didzaꞌ ca rna bëꞌë Dios yehuaꞌ yubá len cutu rejniꞌi lei, rac qui didzaꞌ ryöni nu naꞌ ca guc qui xseydauꞌ naꞌ glas raꞌ nöz. Laꞌ zaꞌtë tuꞌ xöhuiꞌ len rugúa didzaꞌ naꞌ gyuꞌu icj ládxiꞌdauꞌhuëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Xseydauꞌ naꞌ glas luyú ga röꞌ guiöj ruluíꞌ ca rac queëꞌ bönniꞌ ryönnëꞌ didzaꞌ naꞌ len laꞌ ruzëtë naguëꞌ lu yöl‑laꞌ rudziji queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","san ca naꞌ cutu rdiaꞌ xseydauꞌ naꞌ le cudë́ ga gun luí, lëzcaꞌ cni rac queëꞌ bönniꞌ ni. Catiꞌ gdxin tu le usacaꞌ ziꞌ lëꞌ, atiꞌ laꞌbía ládxiꞌgac lëꞌ bunách le nazíꞌ lu nëꞌë didzaꞌ naꞌ, laꞌ gactë chop ladxëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xseydauꞌ naꞌ glas ga naꞌ gululén lba yötsiꞌ ruluíꞌ ca rac queëꞌ bönniꞌ naꞌ ryönnëꞌ didzaꞌ naꞌ, san ruiꞌ ladxëꞌë yuguꞌ le dë yödzlyú ni, atiꞌ nazíꞌ yëꞌë bönniꞌ naꞌ, le ruiꞌ ladxëꞌë yuguꞌ yöl‑laꞌ tsahuiꞌ qui. Yuguꞌ lë ni taꞌröli didzaꞌ naꞌ len tun ga cutu gun dxin lu icj ládxiꞌdauꞌhuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Xseydauꞌ naꞌ glas luyú dxiꞌa ruluíꞌ ca rac queëꞌ bönniꞌ ryönnëꞌ didzaꞌ naꞌ len réjniꞌnëꞌ lei, atiꞌ run dxin didzaꞌ naꞌ lu icj ládxiꞌdauꞌhuëꞌ. Nacgac laꞌgac bunách ca xseydauꞌ naꞌ gulunö́dzj yetú gayuaꞌtër caꞌ. Nacgac yelaꞌgac bunách ca xseydauꞌ naꞌ gulunö́dzj yetsonnlalj caꞌ, atiꞌ nacgac yelaꞌgac bunách ca xseydauꞌ naꞌ gulunö́dzj yechí uruáꞌ caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yetú le benëꞌ lsaquiꞌ Jesús, rëꞌ lequëꞌ: ―Ca gac ga gdxin le rna bëꞌë Dios yehuaꞌ yubá nac ca guc qui xseydauꞌ dxiꞌa guzëꞌ tu bönniꞌ ga nac laꞌ yël queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tsal naꞌ tasiëꞌ bönniꞌ nacuꞌë lidxëꞌ, bdxin niꞌ tu nu curleꞌi lëꞌ dxiꞌa, atiꞌ yjöz laꞌ yël queëꞌ xsey guíxiꞌdauꞌ xöhuiꞌ naláꞌ ca nac yöl zxoaꞌ xtil, atiꞌ böjëꞌ xlatjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Catiꞌ blen zxoaꞌ xtil naꞌ len gröꞌ deu qui, ga naꞌ dxia xuiꞌi, niꞌr glac bëꞌ guíxiꞌdauꞌ xöhuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Niꞌr guladxinëꞌ bönniꞌ huen dxin ga zoëꞌ bönniꞌ xan laꞌ yël naꞌ, len tëꞌ lëꞌ: “Xan, chquiꞌ guzuꞌ xseydauꞌ dxiꞌa laꞌ yël quiuꞌ, ¿nacx guc gulalén guíxiꞌdauꞌ xöhuiꞌ naꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gudxëꞌ lequëꞌ xan laꞌ yël naꞌ, rnëꞌ: “Benëꞌ cni bönniꞌ curléꞌinëꞌ nedaꞌ dxiꞌa.” Niꞌr gulanabnëꞌ lëꞌ huen dxin naꞌ, taꞌnë́ꞌ: “¿I rëꞌnnuꞌ tseajtuꞌ tsjöljtuꞌ guíxiꞌdauꞌ xöhuiꞌ naꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Xanquëꞌ rëꞌ lequëꞌ: “Cutu. Nazx caꞌ catiꞌ gládzuꞌliꞌ guíxiꞌdauꞌ xöhuiꞌ naꞌ, gládzuꞌlentëliꞌ caꞌ yöl zxoaꞌ xtil. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dxiꞌar gac güiꞌliꞌ latj laꞌzxöngar tsazxö́n catiꞌ gdxinr dza tsajtubruꞌ lei, atiꞌ niꞌr gyëpaꞌ nup lutúb lei: Gul‑túb ziꞌal guíxiꞌdauꞌ xöhuiꞌ naꞌ len gul‑gugaꞌ tsajxúndj hueaj quië uzéguiꞌruꞌ lei, atiꞌ niꞌr utubliꞌ zxoaꞌ xtil lu yuꞌu quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yetú le benëꞌ lsaquiꞌ Jesús, rëꞌ lequëꞌ: ―Ca gac ga gdxin le rna bëꞌë Dios yehuaꞌ yubá, gac ca rac qui tu xsey mostaza, le guzëꞌ tu bönniꞌ ga nac laꞌ yël queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Le nactë nactër cuidiꞌ xsey mostaza naꞌ ca yúguꞌtë xseydauꞌ yezicaꞌ, san catiꞌ chnadúz, rzxöntër ca yúguꞌtë guixiꞌ cuan len rac zxön ca nac tu yag, atiꞌ taꞌdxinbaꞌ bguindauꞌ tun lidxcbaꞌ lu zxuzaꞌ nëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yetú le benëꞌ lsaquiꞌ Jesús, rëꞌ lequëꞌ: ―Ca gac ga gdxin le rna bëꞌë Dios yehuaꞌ yubá gac ca le run xnëꞌi yöt xtil, le buchíxinu ngul len tsonn lbix yöjz zxoaꞌ xtil, atiꞌ gyazx gdutë cua naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yúguꞌtë lë ni benëꞌ lsaquiꞌ Jesús, bë́ꞌlenëꞌ bunách nacuáꞌ niꞌ didzaꞌ, len cutu bi didzaꞌ bë́ꞌlenëꞌ lequëꞌ le cubenëꞌ lsaquiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cni benëꞌ quië butság lë naꞌ buzujëꞌ lu guich bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: Guꞌa didzaꞌ yuguꞌ le gunaꞌ lsaquiꞌ. Gniaꞌ yuguꞌ le nagachiꞌ catiꞌ niꞌ gzu lau ziꞌa gutaꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Niꞌr buzeynëꞌ bunách nacuáꞌ niꞌ didzaꞌ Jesús, busölëꞌë lequëꞌ, atiꞌ gyaziëꞌ yuꞌu. Niꞌr guladxinëꞌ ga zoëꞌ bönniꞌ usë́d queëꞌ len tëꞌ Lëꞌ: ―Gdixjöiꞌ netuꞌ le rëꞌni gna lë naꞌ benuꞌ lsaquiꞌ qui guíxiꞌdauꞌ xöhuiꞌ naláꞌ ca nac yöl zxoaꞌ xtil. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Bönniꞌ razëꞌ xseydauꞌ dxiꞌa nacaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Laꞌ yël naꞌ nac yödzlyú ni, atiꞌ xseydauꞌ dxiꞌa naꞌ ruluíꞌ ca nacgac nup nababgac ga rna bëꞌë Dios. Guíxiꞌdauꞌ xöhuiꞌ naꞌ naláꞌ ca nac yöl zxoaꞌ xtil ruluíꞌ ca nacgac nup nacgac qui tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nu naꞌ curleꞌi dxiꞌa xan laꞌ yël naꞌ len yjöz guíxiꞌdauꞌ xöhuiꞌ naꞌ, tuꞌ xöhuiꞌcz nac. Dza lutubëꞌ naꞌ ruluíꞌ ca gac dza udx qui yödzlyú ni, atiꞌ nup naꞌ tuꞌtúb nacgac gbaz laꞌy queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ca naꞌ guc, gulutubëꞌ guíxiꞌdauꞌ xöhuiꞌ naꞌ, len guluzéguiꞌë lei lu guiꞌ, lëzcaꞌ cni gac catiꞌ udx qui yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, gsö́laꞌgacaꞌ‑nëꞌ gbaz laꞌy quiaꞌ, atiꞌ lubijëꞌ ga rna bëꞌë Dios yúguꞌtë nup tun ga tun dul‑laꞌ lzaꞌgac lencaꞌ nup tuaꞌ döꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yuguꞌ gbaz laꞌy naꞌ laꞌguꞌë lu guiꞌ gabíl yuguꞌ bönniꞌ tuaꞌdöꞌ naꞌ. Niꞌ laꞌbödxëꞌ len lutíl‑l láyaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Niꞌr laꞌyë́p yös yeníꞌ bunách tsahuiꞌ, lacquëꞌ ca gbidz ga niꞌ rna bëꞌë Dios yehuaꞌ yubá. Nu zoa nag len ryöni ral‑laꞌ uzë́ nag. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Lëzcaꞌ cni benëꞌ lsaquiꞌ Jesús, rnëꞌ: ―Le rna bëꞌë Dios yehuaꞌ yubá nac ca tu yöl‑laꞌ tsahuiꞌ nagachiꞌ tu laꞌ yël. Catiꞌ budzölnëꞌ lei tu bönniꞌ, bucachëꞌë lei leyúbl ga naꞌ bgachiꞌ, atiꞌ lu yöl‑laꞌ rudziji queëꞌ gyijëꞌ, yjë́tiꞌë yúguꞌtë le dë queëꞌ atiꞌ guꞌuëꞌ laꞌ yël naꞌ quië gataꞌ queëꞌ yöl‑laꞌ tsahuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Gnëꞌ caꞌ Jesús: ―Ca ral‑laꞌ së ládxiꞌliꞌ le rna bëꞌë Dios yehuaꞌ yubá nac ca benëꞌ tu bönniꞌ raꞌuëꞌ len ruútiꞌë, rguiljëꞌ yuguꞌ bga dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Catiꞌ bdzölnëꞌ tu bga záquiꞌtsqui, gyijëꞌ, yjë́tiꞌë yúguꞌtë le dë queëꞌ, atiꞌ guꞌuëꞌ bga naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Lëzcaꞌ cni gnëꞌ Jesús: ―Ca gac ga gdxin le rna bëꞌë Dios yehuaꞌ yubá, gac ca run tu yöxj böl le taꞌchiljëꞌ bönniꞌ lu nis zxön, le rajxíꞌ zian böl gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Catiꞌ chbdzaꞌ yöxj naꞌ, gulubijëꞌ lei luyú bidx raꞌ nis zxön naꞌ, atiꞌ niꞌ gulaböꞌë len gulaguꞌë‑baꞌ lu bdöꞌa yuguꞌ böl dxiꞌa, san yuguꞌ böl caꞌz, gularuꞌnëꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lëzcaꞌ cni gac catiꞌ udx qui yödzlyú ni. Laꞌrujëꞌ gbaz laꞌy queëꞌ Dios atiꞌ lubijëꞌ quizi bunách tsahuiꞌ, lucuitiëꞌ lequëꞌ ladj bunách tuaꞌdöꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","’Niꞌr laꞌguꞌë lu guiꞌ gabíl bunách tuaꞌdöꞌ naꞌ. Niꞌ laꞌbödxëꞌ len lutíl‑l láyaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Niꞌr Jesús gnabnëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―¿I réjniꞌliꞌ yúguꞌtë lë ni? Gulubiꞌë didzaꞌ, tëꞌ Lëꞌ: ―Ja, Xan. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesús gudxëꞌ lequëꞌ: ―Catiꞌ chnazíꞌ lu nëꞌë bönniꞌ gdauꞌ usëdi le rna bëꞌë Dios yehuaꞌ yubá, naquëꞌ ca bönniꞌ xan yuꞌu, rbijëꞌ ladj yöl‑laꞌ tsahuiꞌ queëꞌ le nac cub len le nac gul, le nacgac dxiꞌa, ruziꞌë xbey. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Catiꞌ budx benëꞌ yuguꞌ lsaquiꞌ ni Jesús, buzë́ꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Catiꞌ budxinëꞌ ladzëꞌ, busëdnëꞌ bunách nacuáꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ gulubannëꞌ, taꞌnë́ꞌ: ―¿Gazxcz bzëdnëꞌ yöl‑laꞌ rejniꞌi ni bönniꞌ ni? ¿Nacxcz nac, runëꞌ yuguꞌ yöl‑laꞌ huac ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naquëꞌ bönniꞌ ni zxiꞌnëꞌ bönniꞌ bëdx yag, atiꞌ lënu María xnëꞌë. Naquëꞌ bö́chiꞌquëꞌ Jacobo len José len Simón len Judas. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lëzcaꞌ nacuáꞌlennu rëꞌu ni ngul zanëꞌ. ¿Gazxcz bzëdnëꞌ yúguꞌtë lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Qui lë ni naꞌ glac chop ládxiꞌquëꞌ, gulucaꞌnëꞌ Lëꞌ. Niꞌr Jesús gudxëꞌ lequëꞌ: ―Tun ba laꞌn bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios yúguꞌtë bunách, san cutu tun lëꞌ ba laꞌn bunách uládz queëꞌ len bunách nacuáꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Qui lë ni naꞌ cutu benëꞌ Jesús niꞌ zian yöl‑laꞌ huac, le cutu taꞌyejlëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lu dza niꞌ, byönnëꞌ Herodes, bönniꞌ rna bëꞌë luyú Galilea, ca nacgac yöl‑laꞌ huac runëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes naꞌ gudxëꞌ yuguꞌ niꞌa nëꞌë, rnëꞌ: ―Bönniꞌ ni Juan, bönniꞌ buquilëꞌ bunách nis. Chbubanëꞌ lu yöl‑laꞌ gut. Qui lë ni naꞌ dë lu nëꞌë yöl‑laꞌ huac zxön naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Cni gnëꞌ Herodes le bsölëꞌë lëczëꞌ bönniꞌ gulazönëꞌ Juan len glúguëꞌë lëꞌ du guia, atiꞌ gulaguꞌë lëꞌ lidx guia le gúꞌninu cni Herodías, ngul naꞌ gucnu ngul queëꞌ Felipe, böchëꞌë Herodes naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Cni benëꞌ Herodes, le gudxëꞌ lëꞌ Juan naꞌ: “Cutu ral‑laꞌ sóalenuꞌ‑nu.” ");
INSERT INTO zsrNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Qui lë ni naꞌ guꞌnnëꞌ Herodes gdöddëꞌ Juan, san gúdxinëꞌ laꞌdáꞌbagaꞌ lëꞌ bunách lu yödz niꞌ, le taqui bunách naquëꞌ Juan naꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Niꞌr catiꞌ guc lni qui dza gyéꞌinëꞌ iz Herodes, brujbiꞌ biꞌi ngul queënu Herodías naꞌ len byaꞌabiꞌ laugac nup nacuáꞌ lni naꞌ, atiꞌ bdzag ladxëꞌë‑biꞌ Herodes. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Gzxiꞌ lu nëꞌë Herodes len benëꞌ tsutsu xtidzëꞌë unödzjëꞌ queëbiꞌ bítiꞌtëz bi gnabbiꞌ lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Le chnusë́dinu‑biꞌ ziꞌal xnaꞌbiꞌ, gudxbiꞌ lëꞌ: ―Benn quiaꞌ naꞌa tu lu zxigaꞌ zxön icjëꞌ Juan, bönniꞌ buquilëꞌ bunách nis. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Niꞌr buiꞌnnëꞌ Herodes, san le chbenëꞌ tsutsu xtidzëꞌë, len le gulayöni lëꞌ nup tiꞌj tágulen lëꞌ, qui lë ni naꞌ gna béꞌinëꞌ nu tsajnö́dzj queëbiꞌ icjëꞌ Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Cni guc, bsölëꞌë nu tsajríx yenëꞌ Juan ga niꞌ yuꞌë lidx guia. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bönniꞌ naꞌ nasölëꞌë buꞌë icjëꞌ Juan naꞌ, yuꞌu lu zxigaꞌ zxön, atiꞌ bunödzjëꞌ lei queëbiꞌ biꞌi ngul naꞌ, atiꞌ lëbiꞌ buaꞌbiꞌ lei queënu xnaꞌbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Niꞌr guladxinëꞌ niꞌ bönniꞌ guladë́ꞌë Juan naꞌ, atiꞌ guluúꞌë lëꞌ len gulucachëꞌë lëꞌ. Gdöd niꞌ, yajtíxjöiꞌcnëꞌ Jesús ca glac lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Catiꞌ ráquibeꞌinëꞌ lë ni Jesús, buzë́ꞌë niꞌ, atiꞌ grenëꞌ tu lëꞌi bárcodauꞌ, zijëꞌ laꞌ queëzëꞌ tu latj caꞌz. Catiꞌ gulayöni bunách tsijëꞌ niꞌ, gularujëꞌ yuguꞌ yödz niꞌ, yjaquëꞌ ga niꞌ gdxinëꞌ, taꞌzëꞌi níꞌaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Catiꞌ burujëꞌ lëꞌi barco Jesús, bléꞌinëꞌ nacuáꞌ niꞌ bunách zian, atiꞌ buechiꞌ ladxëꞌë lequëꞌ len bunëꞌ nup teꞌi, nútsaꞌgac ladjquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Catiꞌ chrdzöꞌ dza naꞌ, guladxinëꞌ ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ, len tëꞌ Lëꞌ: ―Chrdzöꞌ naꞌa, atiꞌ caꞌz nac latj ni. Busölaꞌ bunách ni tsjaquëꞌ gap dë yödzdauꞌ quië laꞌuëꞌ bi lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Cutu run bayúdx tsjaquëꞌ. Gul‑nö́dzj lbiꞌiliꞌ le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Niꞌr tëꞌ Lëꞌ: ―Gayuꞌz yöt xtil dë len chopzbaꞌ böl dëbaꞌ queëtuꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús rëꞌ lequëꞌ: ―Gul‑dguáꞌ quiaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Niꞌr gna béꞌinëꞌ bunách naꞌ Jesús laꞌbö́ꞌ ga yuꞌu dacaꞌ. Gdöd naꞌ gdel‑lëꞌë gayuꞌ yöt xtil naꞌ len chopbaꞌ böl naꞌ, atiꞌ bchis lahuëꞌ, ruyúëꞌ zacaꞌ yehuaꞌ yubá. Gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ yöt xtil naꞌ len budödëꞌ lei lu naꞌquëꞌ bönniꞌ usë́d queëꞌ, atiꞌ lequëꞌ gulaguisiëꞌ lei laugac bunách zian naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Glahuëꞌ yúguꞌtëꞌ len guluhuöljnëꞌ. Niꞌr gulutubëꞌ bizxj nagaꞌngac len guludzë́ꞌë chinnu bdöꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bönniꞌ niꞌ glahuëꞌ glaquëꞌ gdu chiʉ́n gayuꞌë, san nutu nu blab yuguꞌ ngul len biꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Niꞌr laꞌ bentëꞌ Jesús ga gulabenëꞌ lëꞌi bárcodauꞌ bönniꞌ usë́d queëꞌ, tsjaquëꞌ, laꞌnörëꞌ lahuëꞌ, laꞌdödëꞌ yetsláꞌa nis zxön niꞌ, tsal naꞌ uzeynëꞌ Lëꞌ bunách nacuáꞌ niꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Catiꞌ chnusölëꞌë bunách naꞌ Jesús, grenëꞌ ga nac tu lu guíꞌadauꞌ ga niꞌ yajsóëꞌ tuzëꞌ. Niꞌ bulidzëꞌ Dios. Catiꞌ chgul, tuzëꞌ zoëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bárcodauꞌ ga naꞌ nacuꞌë bönniꞌ usë́d queëꞌ rdöd gatsj lahuiꞌl nis zxön naꞌ, atiꞌ ryas bárcodauꞌ naꞌ le ryas rdxia nis zxön naꞌ, le ruzagaꞌ barco naꞌ böꞌ reycj. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gdöd ladxiꞌ yël, gbiguëꞌë Jesús gal‑laꞌ ga naꞌ nacuꞌë, rzëꞌi niꞌë lu nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Catiꞌ gulaléꞌinëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, rzëꞌi niꞌë lu nis zxön, szxöni gulaböꞌë baguíꞌi le tádxinëꞌ. Gulabödxyëꞌë, taꞌnë́ꞌ: ―Tu bxin naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Niꞌr Jesús laꞌ bulidztëꞌ lequëꞌ, rnëꞌ: ―Gul‑zxöni ládxiꞌliꞌ. Nedaꞌ ni. Cutu gádxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Niꞌr bubiꞌë didzaꞌ Pedro, rëꞌ Jesús: ―Xan, chquiꞌ nacuꞌ Liꞌ, gna beꞌi nedaꞌ guidaꞌ ga naꞌ zuꞌ lu nis. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús gudxëꞌ lëꞌ: ―Gda. Niꞌr bötjëꞌ Pedro lëꞌi bárcodauꞌ naꞌ len gzëꞌi niꞌë lu nis zxön, zijëꞌ ga naꞌ zoëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Niꞌr catiꞌ bléꞌinëꞌ Pedro ca rutá nis böꞌ naꞌ reycj, gúdxinëꞌ. Niꞌr gzu lahuëꞌ rötjëꞌ lu nis, atiꞌ grödxyëꞌë. Bulidzëꞌ Jesús, rnëꞌ: ―Xan, buslá nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús laꞌ bulitë nëꞌë. Buguel‑lëꞌë lëꞌ, len rëꞌ lëꞌ: ―Latiꞌz réjlëꞌu nedaꞌ. ¿Bizx quië guc chop ladxuꞌu? ");
INSERT INTO zsrNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Catiꞌ gulubenëꞌ lëꞌi bárcodauꞌ naꞌ, gröꞌ dxi böꞌ naꞌ reycj. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Niꞌr gulayíj ládxiꞌquëꞌ Jesús bönniꞌ nacuꞌë lëꞌi bárcodauꞌ naꞌ, taꞌnë́ꞌ: ―Le nactë, Zxiꞌnëꞌ Dios nacuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Catiꞌ chguladödëꞌ yetsláꞌa nis zxön naꞌ, laꞌ guladxintëꞌ lu xyu yödz Genesaret. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Catiꞌ guluúnbëꞌë Jesús bönniꞌ yödz niꞌ, gulasölëꞌë didzaꞌ gdutë luyú niꞌ, atiꞌ djuaꞌquëꞌ ga zoëꞌ Jesús yúguꞌtë nup teꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Glátaꞌyuëꞌ lahuëꞌ Jesús guꞌë lequëꞌ latj laꞌganzëꞌ ruiꞌi lariꞌ nacuëꞌ, atiꞌ laꞌ guluhuöactë yúguꞌtë nup naꞌ gulagán lariꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Niꞌr guladxinëꞌ ga zoëꞌ Jesús yuguꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ tuꞌsëdi, narujquëꞌ Jerusalén, atiꞌ tëꞌ Jesús: ");
INSERT INTO zsrNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Bizx quië tunëꞌ bönniꞌ usë́d quiuꞌ le rdöd bëꞌi ca nac le nalë́biruꞌ runruꞌ ca glunëꞌ xuz xtauꞌruꞌ? Cutu taꞌguíb naꞌquëꞌ ca nac qui gdauꞌ catiꞌ ziꞌa lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bubiꞌë didzaꞌ Jesús, gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Bizx quië lbiꞌiliꞌ caꞌ rucaꞌnliꞌ caꞌz zxba queëꞌ Dios quië gunliꞌ le nalë́biliꞌ runliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cni nac, le gna béꞌinëꞌ lbiꞌiliꞌ Dios, gnëꞌ: “Ben ba laꞌn xuz xnaꞌu”, len gnëꞌ caꞌ: “Nu gnë ziꞌ qui xuz xnëꞌi, tsaz gat nu naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","San lbiꞌiliꞌ rnaliꞌ: “Chquiꞌ nu guië xuz xnëꞌi: Cutu bi gac gunnaꞌ quiuꞌ le chgzxiꞌ lu naꞌa gunnaꞌ queëꞌ Dios yúguꞌtë, ");
INSERT INTO zsrNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","cutur bi ral‑laꞌ gun qui xuz xnëꞌi nu naꞌ.” Cni runliꞌ, rucaꞌnliꞌ caꞌz le gna bëꞌë Dios, quië gunliꞌ le nalë́biliꞌ runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lbiꞌiliꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ, gdu gdíxjöꞌë ca nacliꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bönniꞌ ni, lu rúꞌagaczëꞌ tunëꞌ nedaꞌ ba laꞌn, Len clëg gdu ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Daduz nac le taꞌyíj ládxiꞌquëꞌ nedaꞌ Le tuꞌsëdnëꞌ yuguꞌ le gulaná bëꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Niꞌr bulidzëꞌ bunách nacuáꞌ niꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑zë́ nagliꞌ le gyëpaꞌ lbiꞌiliꞌ len gul‑tsejniꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Clëg le ryaz ruꞌë bönniꞌ run ga cunaquëꞌ dxiꞌa lahuëꞌ Dios, san le r‑ruj ruꞌë, lë ni run ga cunaquëꞌ dxiꞌa lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Niꞌr gulabiguëꞌë ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ, len tëꞌ Lëꞌ: ―¿I nöznuꞌ gulaleynëꞌ bönniꞌ gdauꞌ fariseo catiꞌ gulayönnëꞌ didzaꞌ ni bëꞌu? ");
INSERT INTO zsrNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Yúguꞌtë le nadúz, le cuguzëꞌ Xuzaꞌ zoëꞌ yehuaꞌ yubá, huaduljgac gdu luí. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gul‑cáꞌn lequëꞌ. Chnachúl lauquëꞌ len taꞌchë́ꞌë nup nachúl laugac. Chquiꞌ tu bönniꞌ lau chul gchëꞌë yetúëꞌ bönniꞌ lau chul, gropëꞌ laꞌbixëꞌ lu yeru. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Niꞌr bubiꞌë didzaꞌ Pedro, rëꞌ Jesús: ―Bzejniꞌi netuꞌ lë ni runuꞌ lsaquiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús rëꞌ lequëꞌ: ―¿Naruꞌ cu réjniꞌtsaliꞌ caꞌ lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Naruꞌ cu réjniꞌtsaliꞌ ryaz lëꞌruꞌ yúguꞌtë le ryaz rúꞌaruꞌ, atiꞌ rurúj lëꞌruꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Naꞌa, le r‑ruj rúꞌaliꞌ, lu icj ládxiꞌdauꞌliꞌ zaꞌ, atiꞌ lë ni run ga cunacliꞌ dxiꞌa lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Cni rac, le taꞌlén lu icj ládxiꞌdauꞌliꞌ yuguꞌ le rzaꞌ ládxiꞌliꞌ le cunác, le lun ga gdö́diliꞌ bunách, len le lun ga quitsjliꞌ zxba qui yöl‑laꞌ nutság naꞌ, len le cunác runliꞌ, len yuguꞌ le rzë ládxiꞌliꞌ cuanliꞌ, len yuguꞌ le rnëliꞌ qui lzaꞌliꞌ le cunácz, len yuguꞌ le rnë xö́huiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yuguꞌ le cni tun ga cunaquëꞌ dxiꞌa lahuëꞌ Dios tu bönniꞌ, san chquiꞌ cunayár nëꞌë ca nac qui gdauꞌ catiꞌ bi gahuëꞌ, cutu gun ga cunaquëꞌ dxiꞌa lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Niꞌr buzë́ꞌë niꞌ Jesús, gyijëꞌ lu xyu yödz Tiro len yödz Sidón. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Brujnu yödz niꞌ tu ngul nababnu Canaán, atiꞌ bëꞌnu zidzj didzaꞌ, rënu Jesús: ―Xan, zxiꞌn xsoëꞌ David, buechiꞌ ladxiꞌ nedaꞌ. Biꞌi ngul quiaꞌ szxöni rzacaꞌ rguiꞌbiꞌ le yuꞌu lëbiꞌ böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Cutu bi didzaꞌ bubiꞌë Jesús. Niꞌr gulabiguëꞌë ga zoëꞌ bönniꞌ usë́d queëꞌ, atiꞌ glëꞌ Lëꞌ, taꞌnë́ꞌ: ―Busölaꞌ‑nu, le zaꞌnu cúdzuꞌruꞌ rbö́dxyaꞌanu. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ‑nu: ―Dios nasölëꞌë nedaꞌ gáclenaꞌ bunách Israel, nacgac ca böꞌcuꞌ zxílaꞌdauꞌ nanitcbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Niꞌr gbígaꞌnu ga zoëꞌ Jesús ngul naꞌ len gyij ládxiꞌnu Lëꞌ, rënu Lëꞌ: ―Xan, guclen nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Cutu nac dxiꞌa uguaruꞌ yöt quecbiꞌ biꞌidauꞌ len chuꞌnruꞌ lei laucbaꞌ bö́ꞌcuꞌdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Niꞌr rënu Jesús ngul naꞌ, rnanu: ―Ja, Xan, san tágubaꞌ bö́ꞌcuꞌdauꞌ naꞌ le bizxj tuꞌhuö́xj ga tagu xancbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Niꞌr bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Nguldauꞌ. Gdu nac ca réjlëꞌu nedaꞌ. Gac quiuꞌ ca rëꞌnnuꞌ. Laꞌ niꞌz böáctëbiꞌ biꞌi nguldauꞌ queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Niꞌr buzë́ꞌë niꞌ Jesús len gdödëꞌ ga nac raꞌ nis zxön qui Galilea. Grenëꞌ ga nac tu lu guíꞌadauꞌ, atiꞌ niꞌ gröꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Guladxín ga zoëꞌ Jesús bunách zian djuaꞌquëꞌ nup cutaꞌzáꞌ len nup nachúl laugac, len nup cutaꞌnë́, len nup narugu niꞌa naꞌgac, len zianr nup teꞌi, atiꞌ gulaguixjëꞌ lequëꞌ xniꞌë Jesús, atiꞌ Lëꞌ bunëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gulubani bunách niꞌ ca nac le benëꞌ Jesús, le gulaléꞌinëꞌ tuꞌnë́ nup cugulanë́, atiꞌ nuhuöacgac nup grugu niꞌa naꞌgac, atiꞌ tuꞌzáꞌ nup cugulazáꞌ, atiꞌ tuꞌleꞌi nup bchul laugac. Qui lë ni naꞌ gulaguꞌë yöl‑laꞌ ba Dios quegac bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Niꞌr Jesús bulidzëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, len rëꞌ lequëꞌ: ―Ruhuechiꞌ ladxaꞌa bunách zian ni, le chguc tsonn dza záꞌclenëꞌ nedaꞌ len cutu bi dë le lahuëꞌ. Cutu rëꞌndaꞌ usö́laꞌgacaꞌ‑nëꞌ tshuöjquëꞌ lidxquëꞌ taꞌdunzëꞌ caꞌ, nazx caꞌ ludú ládxiꞌquëꞌ laꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Niꞌr tëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Gazxcz gdzö́lituꞌ yöt xtil zian lu latj caꞌz ni, le ugágutuꞌ bunách zian ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―¿Balx yöt xtil dë queëliꞌ? Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Gadx, atiꞌ nababzbaꞌ böl cuidiꞌ dëbaꞌ queëtuꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Niꞌr Jesús gna béꞌinëꞌ bunách zian naꞌ laꞌbö́ꞌ lu yu. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Gdel‑lëꞌë gadx yöt xtil naꞌ len yuguꞌ böl naꞌ atiꞌ gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ groptë naꞌ len bunödzjëꞌ quequëꞌ bönniꞌ usë́d queëꞌ, atiꞌ lequëꞌ gulaguisiëꞌ laugac bunách zian naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Glahuëꞌ yúguꞌtëꞌ len guluhuöljnëꞌ. Gdöd niꞌ gulutubëꞌ le bizxj nagaꞌngac, atiꞌ guludzë́ꞌë gadx bdöꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nacquëꞌ choaꞌ gayuꞌë bönniꞌ naꞌ glahuëꞌ, san nutu nu blab yuguꞌ ngul len biꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Niꞌr Jesús busölëꞌë bunách naꞌ tshuöjquëꞌ lidxquëꞌ, atiꞌ grenëꞌ lëꞌi bárcodauꞌ niꞌ, zijëꞌ lu xyu yödz Magdala. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niꞌr guladxinëꞌ ga zoëꞌ Jesús yuguꞌ bönniꞌ gdauꞌ fariseo len yuguꞌ bönniꞌ gdauꞌ saduceo quië laꞌzíꞌ bëꞌë Jesús, atiꞌ gulanabnëꞌ Lëꞌ gunëꞌ tu le gac bëꞌ ga zaꞌ yöl‑laꞌ uná bëꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Catiꞌ rdzöꞌ, rnaliꞌ cni: “Gun dxiꞌa cxö, le röꞌ böaj xna luzxbá.” ");
INSERT INTO zsrNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Catiꞌ nac zildauꞌ, rnaliꞌ cni: “Cutu gun dxiꞌa naꞌa dza le röꞌ böaj xna len ruchúl luzxbá.” Lbiꞌiliꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Rac gnë yaꞌaliꞌ nac gun luzxbá, san cutu gac tséjniꞌliꞌ le rusëdi le tac dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bunách tuaꞌdöꞌ cuzóa gdu ládxiꞌgac taꞌnabi nedaꞌ gunaꞌ tu le gac bëꞌ nu nacaꞌ, san cutu bi le gac bëꞌ laꞌléꞌinëꞌ. Tuz lë naꞌ guc bëꞌ ca guc queëꞌ Jonás, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios laꞌléꞌinëꞌ. Niꞌr bucaꞌnëꞌ lequëꞌ Jesús, zhuöjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Catiꞌ guladxinëꞌ yetsláꞌa nis zxön niꞌ, gláquibeꞌinëꞌ bönniꞌ usë́d queëꞌ Jesús glal ládxiꞌquëꞌ luꞌë le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Gul‑yutscaꞌ. Gul‑gún chiꞌi cuinliꞌ qui le nac ca xnëꞌi yöt xtil quequëꞌ bönniꞌ gdauꞌ fariseo len quequëꞌ bönniꞌ gdauꞌ saduceo. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Niꞌr laꞌ légaczëꞌ glun xtídzaꞌquëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―Rnëꞌ cni le cunuaꞌruꞌ yöt xtil. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ráquibeꞌinëꞌ lë ni Jesús, atiꞌ rëꞌ lequëꞌ: ―¿Bizx quië run xtídzaꞌliꞌ laꞌ lbiꞌizliꞌ le cunuaꞌliꞌ yöt xtil? Latiꞌz réjlëꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Naruꞌ cu réjniꞌtsaliꞌ len cu rajnéytsaliꞌ ca guc quegac gayuꞌ yöt xtil niꞌ, lë naꞌ glahuëꞌ chiʉ́n gayuꞌë bönniꞌ, atiꞌ tsca zian bdöꞌa butubliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Naruꞌ cu rajnéytsaliꞌ caꞌ ca guc quegac gadx yöt xtil niꞌ, lë naꞌ glahuëꞌ choaꞌ gayuꞌë bönniꞌ atiꞌ tsca zian bdöꞌa butubliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Naruꞌ cu réjniꞌliꞌ? Cutu bëꞌa didzaꞌ qui yöt xtil catiꞌ gudxaꞌ lbiꞌiliꞌ gun chiꞌi cuinliꞌ qui le nac ca xnëꞌi yöt xtil quequëꞌ bönniꞌ gdauꞌ fariseo len quequëꞌ bönniꞌ gdauꞌ saduceo. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Niꞌr gulayéjniꞌnëꞌ cutu gudxëꞌ lequëꞌ Jesús lun chiꞌi cuinquëꞌ qui xnëꞌi yöt xtil, san ral‑laꞌ lun chiꞌi cuinquëꞌ qui le tuꞌsëdnëꞌ yuguꞌ bönniꞌ gdauꞌ fariseo len yuguꞌ bönniꞌ gdauꞌ saduceo. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Catiꞌ bdxinëꞌ Jesús lu xyu yödz Cesarea, ga naꞌ rna bëꞌë Filipo, gnabnëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―¿Nacx taꞌná bunách nu nacaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách? ");
INSERT INTO zsrNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Laꞌquëꞌ taꞌnë́ꞌ: “Juan nacuꞌ, bönniꞌ niꞌ buquilëꞌ bunách nis.” Yelaꞌquëꞌ taꞌnë́ꞌ: “Elías nacuꞌ, bönniꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios dza niꞌtë.” Yelaꞌquëꞌ taꞌnë́ꞌ: “Jeremías nacuꞌ, o yetúëꞌ bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Nazxga lbiꞌiliꞌ, ¿nuzxa rnaliꞌ nacaꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bubiꞌë didzaꞌ Simón Pedro, rëꞌ Lëꞌ: ―Liꞌ nacuꞌ Cristo, Zxiꞌnëꞌ Dios ban. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Bicaꞌ bauꞌ liꞌ, Simón, zxiꞌnëꞌ Jonás, le cutu buluiꞌinëꞌ liꞌ lë ni nu bönniꞌ, san Xuzaꞌ zoëꞌ yehuaꞌ yubá buluiꞌinëꞌ liꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nedaꞌ rëpaꞌ liꞌ, liꞌ nacuꞌ Pedro, atiꞌ lu guiöj ni ucuꞌa nup ludúb quiaꞌ, atiꞌ yöl‑laꞌ uná bëꞌ qui tuꞌ xöhuiꞌ cutu saquiꞌ uzagaꞌ xnözquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gunnaꞌ quiuꞌ yuguꞌ zxiꞌn guia qui latj ga rna bëꞌ Nu zoa yehuaꞌ yubá. Le gna bëꞌu luyú ni, chgna bëꞌ caꞌ Nu naꞌ zoa yehuaꞌ yubá, atiꞌ le guꞌu latj gac luyú ni, chbëꞌ latj gac lë naꞌ Nu naꞌ zoa niꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niꞌr Jesús gna béꞌinëꞌ yuguꞌ bönniꞌ usë́d queëꞌ nutu nu lëꞌë naquëꞌ Lëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Laꞌ dza niꞌz gzu lahuëꞌ Jesús rguíxjöiꞌnëꞌ yuguꞌ bönniꞌ usë́d queëꞌ run bayúdx tsijëꞌ Jerusalén, atiꞌ niꞌ lusacaꞌ ziꞌë Lëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi, len bönniꞌ gdauꞌ tuꞌsëdi, atiꞌ niꞌr ludöddëꞌ Lëꞌ, san catiꞌ gac tsonn dza ubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Niꞌr quizi bchëꞌë Jesús Pedro len gzu lahuëꞌ rdil‑lëꞌ Lëꞌ didzaꞌ, rnëꞌ: ―Xan, cutu guꞌë latj Dios. Cutu caꞌ gac quiuꞌ ca rnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Niꞌr bueycjëꞌ Jesús, len rëꞌ Pedro: ―Bcuit ga zoaꞌ. Runuꞌ ca run Satanás, tuꞌ xöhuiꞌ. Runuꞌ ga gac chop ladxaꞌa le cutu nac ca rzaꞌ ladxëꞌë Dios le rzaꞌ ladxuꞌu liꞌ, san ca taꞌzáꞌz ládxiꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Niꞌr Jesús gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Chquiꞌ zoëꞌ bönniꞌ rëꞌnnëꞌ tëꞌë nedaꞌ, ral‑laꞌ uzóëꞌ tslaꞌl yuguꞌ le rzë ladxëꞌë, len gaquëꞌ ca tu bönniꞌ zijëꞌ zajtë́ꞌë lëꞌi yag cruz, atiꞌ niꞌr gac tëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nu bönniꞌ guëꞌnnëꞌ gun chiꞌë yöl‑laꞌ naꞌbán queëꞌ, unitiëꞌ lei, san bönniꞌ unitiëꞌ yöl‑laꞌ naꞌbán queëꞌ le dëꞌë nedaꞌ, gataꞌ queëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Bizxa uziꞌtsëꞌ xbey bönniꞌ chquiꞌ utubëꞌ yúguꞌtë le dë yödzlyú ni san unitiëꞌ yöl‑laꞌ naꞌbán gdu queëꞌ? ¿Bizxa caz gac unödzjëꞌ bönniꞌ quië gataꞌ queëꞌ yöl‑laꞌ naꞌbán gdu? ");
INSERT INTO zsrNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Cni rniaꞌ, le huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, dzag nedaꞌ yöl‑laꞌ yeníꞌ queëꞌ Xuzaꞌ Dios, len dzagquëꞌ nedaꞌ gbaz laꞌy quiaꞌ. Niꞌr ubiꞌa qui queë bunách tsca nac le nungac. ");
INSERT INTO zsrNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Le nactë rëpaꞌ lbiꞌiliꞌ: “Cutu caꞌ lat laꞌgac nup nacuáꞌ ni catiꞌ laꞌleꞌir duná bëꞌa nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách.” ");
INSERT INTO zsrNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gdöd xop dza, Jesús gdel‑lëꞌë Pedro len Jacobo len Juan, böchëꞌë Jacobo naꞌ, atiꞌ bchëꞌë lequëꞌ, yjaquëꞌ quizi ga nac tu lu guiꞌa sib. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Niꞌ bdzaꞌ ca naláꞌ lahuëꞌ Jesús lauquëꞌ. Gyëp yös yeníꞌ lahuëꞌ Jesús ca ruzeníꞌ gbidz, atiꞌ böac chguichdauꞌz lariꞌ nacuëꞌ ca yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Niꞌr gulaléꞌinëꞌ bönniꞌ usë́d queëꞌ naꞌ buluíꞌ lauquëꞌ Moisés len Elías, tuíꞌlenëꞌ Jesús didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Niꞌr Pedro rëꞌ Jesús: ―Xan, nac dxiꞌa zoaruꞌ ni. Chquiꞌ rëꞌnnuꞌ, gunaꞌ ni tsonn yuꞌu lágaꞌdauꞌ, tu quiuꞌ, yetú queëꞌ Moisés, len yetú queëꞌ Elías. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsal niꞌ ruꞌë didzaꞌ ni Pedro, laꞌ gröꞌtë niꞌ tu böaj yeníꞌ le gzxoa lequëꞌ, atiꞌ lu böaj naꞌ byön chiꞌi nu rna: ―Bönniꞌ ni Zxiꞌnczaꞌ. Nadxiꞌidaꞌ‑nëꞌ len rdzag ladxaꞌa Lëꞌ. Gul‑zë́ nagliꞌ didzaꞌ guꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Catiꞌ gulayönnëꞌ chiꞌi naꞌ bönniꞌ usë́d queëꞌ, guladzöꞌë guzruꞌal len gladxi guladzöbnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Niꞌr gbiguëꞌë Jesús ga naꞌ nacuꞌë, atiꞌ gdanëꞌ lequëꞌ, rnëꞌ: ―Gul‑tsás. Cutu gádxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Catiꞌ gulachís lauquëꞌ, guluyúëꞌ, nutur nu gulaléꞌinëꞌ, san tuzëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Catiꞌ niꞌ tuꞌdinniëꞌ lu guiꞌa naꞌ, gna béꞌinëꞌ lequëꞌ Jesús, rnëꞌ: ―Nutu nu guiëliꞌ ca guc lë ni bléꞌiliꞌ catiꞌ ubanraꞌ lu yöl‑laꞌ gut nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Niꞌr gulanabnëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Bizx quië taꞌnë́ꞌ bönniꞌ gdauꞌ usëdi run bayúdx uluíꞌ lahuëꞌ Elías ziꞌal ca uluíꞌ lahuëꞌ Cristo? ");
INSERT INTO zsrNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Le nactë uluíꞌ lauczëꞌ ziꞌal Elías, len ucaꞌnëꞌ tsahuiꞌ yúguꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nedaꞌ rëpaꞌ lbiꞌiliꞌ: “Chbuluíꞌ lahuëꞌ Elías naꞌ, san cutu guluúnbëꞌë lëꞌ, atiꞌ yúguꞌtë ca rnaz quequëꞌ glunëꞌ queëꞌ.” Lëzcaꞌ cni lunëꞌ quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lusacaꞌ ziꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niꞌr gulayéjniꞌnëꞌ bönniꞌ usë́d queëꞌ, bë́ꞌlenëꞌ lequëꞌ didzaꞌ Jesús ca guc queëꞌ Juan, bönniꞌ naꞌ buquilëꞌ bunách nis. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Catiꞌ guladxinëꞌ ga naꞌ nacuáꞌ bunách zian, gbiguëꞌë ga zoëꞌ Jesús tu bönniꞌ, atiꞌ buzechu zxibëꞌ lahuëꞌ Jesús ");
INSERT INTO zsrNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","len rëꞌ Lëꞌ: ―Xan, buechiꞌ ladxiꞌ‑biꞌ biꞌi bö́nniꞌdauꞌ quiaꞌ, le réꞌibiꞌ xjutiꞌ, len szxöni rzacaꞌ rguiꞌbiꞌ, atiꞌ zian lzu rdzöꞌbiꞌ lu guiꞌ o lu nis. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chdguꞌa‑biꞌ lauquëꞌ bönniꞌ usë́d quiuꞌ san cutu guc luúnëꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Lbiꞌiliꞌ, bunách curéjlëꞌliꞌ len cunacliꞌ tsahuiꞌ. ¿Gácaꞌxtëcz ral‑laꞌ sóalenaꞌ lbiꞌiliꞌ quië tséjlëꞌliꞌ nedaꞌ? ¿Gácaꞌxtëcz ral‑laꞌ guaꞌ glenaꞌ queëliꞌ? Gul‑dguáꞌ‑biꞌ quiaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Niꞌr Jesús buzeynëꞌ ba nadx böꞌ xöhuiꞌ naꞌ yuꞌu lëbiꞌ, atiꞌ laꞌ burujtë lëbiꞌ, atiꞌ laꞌ naꞌz böáctëbiꞌ biꞌi bö́nniꞌdauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Niꞌr, quizi gulabiguëꞌë ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ, atiꞌ gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Bizx quië naꞌ netuꞌ cutu guc ubijtuꞌ böꞌ xöhuiꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús rëꞌ lequëꞌ: ―Cutu gzxáquiꞌliꞌ le curéjlëꞌliꞌ Dios gdu ládxiꞌliꞌ. Le nactë rëpaꞌ lbiꞌiliꞌ, zal‑laꞌ cuidiꞌz nac yöl‑laꞌ rejlëꞌ queëliꞌ Dios, nacz ca tu xseydauꞌ mostaza, huac guiëliꞌ guíꞌadauꞌ ni: “Bcuit ni len yajsóa niꞌl”, atiꞌ laꞌ gcuittë guíꞌadauꞌ naꞌ. Cutu bi zoa le cugác gunliꞌ chquiꞌ réjlëꞌliꞌ Dios gdu ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tu böꞌ xöhuiꞌ cni gac ubijliꞌ tuz chquiꞌ ulidzliꞌ‑nëꞌ Dios, len gunliꞌ gubás. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tsal niꞌ taꞌdë́ꞌ luyú Galilea, Jesús gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Zoa nu udö́d nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lu naꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ludöddëꞌ nedaꞌ, san catiꞌ gac tsonn dza Dios uspanëꞌ nedaꞌ. Niꞌr guluhuiꞌnnëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Catiꞌ guludxinëꞌ Capernaum Jesús len yuguꞌ bönniꞌ usë́d queëꞌ, guladxinëꞌ ga zoëꞌ Pedro bönniꞌ tuꞌquizxjëꞌ bunách lazgac qui gdauꞌ, atiꞌ tëꞌ Pedro: ―¿Naruꞌ cu quizxj lazëꞌ qui gdauꞌ bönniꞌ rusëdnëꞌ lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bubiꞌë didzaꞌ Pedro, rnëꞌ: ―Ja, huaguizxjëꞌ. Catiꞌ buaziëꞌ Pedro lu yuꞌu, Jesús laꞌ bulidztëꞌ lëꞌ len rëꞌ lëꞌ: ―¿Nacx rusacaꞌ quiuꞌ, Simón? Bönniꞌ taꞌná bëꞌë luyú ni, ¿nupx tuꞌquizxjëꞌ le rguizxj laz len lazxj qui yu? ¿Naruꞌ tuꞌquizxjëꞌ bunách uládz quequëꞌ o bunách gzaꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bubiꞌë didzaꞌ Pedro, rëꞌ Lëꞌ: ―Bunách gzaꞌa tuꞌquizxjëꞌ. Niꞌr Jesús rëꞌ lëꞌ: ―Qui lë ni naꞌ, cutu run bayúdx quizxj lazaꞌ qui gdauꞌ le nacaꞌ Zxiꞌnëꞌ Dios ca naꞌ cutu bi taꞌguízxj nup nacgac bunách uládz qui nu naꞌ ruquízxj. ");
INSERT INTO zsrNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naꞌa, quië nutu nu gun leyruꞌ, gyeaj raꞌ nis zxön, yajzál lu nis le rzönnuꞌ‑baꞌ böl, atiꞌ böl cuijuꞌ‑baꞌ ziꞌal, gzxiꞌ‑baꞌ. Catiꞌ gsaljuꞌ rúꞌabaꞌ, niꞌ gdzö́linuꞌ tu dumí lasdauꞌ. Gzxiꞌ lei, atiꞌ gdizxj lazaꞌ len lazuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Laꞌ dza niꞌz guladxinëꞌ ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ, atiꞌ gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Núzxalëꞌ bönniꞌ ni gaquëꞌ blau ga rna bëꞌë Dios yehuaꞌ yubá? ");
INSERT INTO zsrNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bulidzëꞌ‑biꞌ Jesús tubiꞌ biꞌi bö́nniꞌdauꞌ, atiꞌ buzóëꞌ‑biꞌ gatsj lahuiꞌl ga naꞌ nacuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Niꞌr rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, chquiꞌ cuhuöacliꞌ ca naccbiꞌ biꞌidauꞌ, cutu caꞌ tsazliꞌ ga niꞌ rna bëꞌë Dios yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Qui lë ni naꞌ, nútiꞌtëz nu gac nöxj ladxiꞌ len huöac ca nacbiꞌ biꞌidauꞌ ni, nu ni gac blau ga niꞌ rna bëꞌë Dios yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nútiꞌtëz nu gun ba laꞌn tubiꞌ biꞌidauꞌ cni le náquibiꞌ quiaꞌ, nédaꞌczaꞌ gun ba laꞌn. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gnëꞌ caꞌ Jesús: ―Nu gun ga gunbiꞌ dul‑laꞌ tubiꞌ biꞌidauꞌ cni réjlëꞌbiꞌ nedaꞌ, dxiꞌar gac queëꞌ bönniꞌ naꞌ laꞌnaruꞌ ugal‑lëꞌ guiöj ryë́tuni yag yenëꞌ, atiꞌ tsajsladzuꞌ cuinëꞌ lu nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bicaꞌ bayechiꞌ bunách yödzlyú ni tun ga tunëꞌ dul‑laꞌ lzaꞌgac. Nacuaꞌtecz le tun ga nu gun dul‑laꞌ, san bicaꞌ bayechiꞌ nu run ga nu gun dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Qui lë ni naꞌ, chquiꞌ gun ga gunuꞌ dul‑laꞌ naꞌu o niꞌu, bchugu lei, len gruꞌn lei. Dxiꞌar gac quiuꞌ tsajtsaziuꞌ ga suꞌ gbanuꞌ curzaꞌu o narugu niꞌa naꞌu, len clëg nacuáꞌ chop naꞌu len chop niꞌu atiꞌ tsajtsaziuꞌ lu guiꞌ gabíl le gatga ul. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chquiꞌ gun ga gunuꞌ dul‑laꞌ yöj lauꞌ, gleaj lei len gruꞌn lei. Dxiꞌar gac quiuꞌ tsajtsaziuꞌ ga suꞌ gbanuꞌ, zoa tuz yöj lauꞌ, len clëg nacuáꞌ chop yöj lauꞌ, atiꞌ tsajtsaziuꞌ lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Gnëꞌ caꞌ Jesús: ―Gul‑gún chiꞌi cuinliꞌ cui uzoaliꞌ‑biꞌ tslaꞌl nitubiꞌ biꞌidauꞌ cni. Nedaꞌ rëpaꞌ lbiꞌiliꞌ, nacuáꞌteczëꞌ gbaz laꞌy tun chiꞌë lecbiꞌ lahuëꞌ Xuzaꞌ zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bidaꞌ ni nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, quië usláꞌ nu ni nanít. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Nacx runi lbiꞌiliꞌ? Nu bönniꞌ, nacuaꞌbaꞌ queëꞌ tu gayuáꞌ böꞌcuꞌ zxilaꞌ, chquiꞌ nitbaꞌ tubaꞌ, ¿naruꞌ cu ucaꞌnëꞌ‑baꞌ taplalj yu chë́nnabaꞌ naꞌ len tsijëꞌ gap nac lu guiꞌa, tsajtiljëꞌ‑baꞌ böꞌcuꞌ zxílaꞌdauꞌ naꞌ nanitbaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chquiꞌ udzölnëꞌ‑baꞌ, le nactë rëpaꞌ lbiꞌiliꞌ, udzijrnëꞌ queëbaꞌ böꞌcuꞌ zxílaꞌdauꞌ naꞌ ca gunëꞌ quecbaꞌ yetaplalj yu chë́nnabaꞌ niꞌ cutu gulanitbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lëzcaꞌ cni, Xuzruꞌ Dios, zoëꞌ yehuaꞌ yubá, cutu rëꞌnnëꞌ nitbiꞌ nitubiꞌ biꞌidauꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gnëꞌ caꞌ Jesús: ―Chquiꞌ guaꞌ döꞌ quiuꞌ böchiꞌ lzaꞌu, gyeajtscaꞌ, yajcáꞌnlenëꞌ tsahuiꞌ laꞌ lbiꞌizliꞌ. Chquiꞌ uzë́ naguëꞌ liꞌ, chbuguel‑luꞌu böchiꞌ lzaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Chquiꞌ cutu uzë́ naguëꞌ xtidzuꞌu, bchëꞌë yetúëꞌ o yechopëꞌ bönniꞌ quië urúj li xtidzuꞌu lauquëꞌ chop tsonnëꞌ bönniꞌ, nup gac lun lnaꞌ lau qui xtídzaꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chquiꞌ cutu uzë́ naguëꞌ xtídzaꞌquëꞌ, gudx caꞌ bunách tuꞌdúb tuꞌsë́d queëꞌ Dios, len chquiꞌ cutu uzë́ naguëꞌ xtídzaꞌgac bunách naꞌ, niꞌr gaquëꞌ quiuꞌ bönniꞌ naꞌ ca bönniꞌ curejlëꞌë Dios len ca bönniꞌ ruquizxjëꞌ uláz qui yödz ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Le nactë rëpaꞌ lbiꞌiliꞌ, yúguꞌtë le gna bëꞌliꞌ luyú ni, nac le chgna bëꞌë Dios yehuaꞌ yubá, atiꞌ yúguꞌtë le güiꞌliꞌ latj luyú ni, nac le chbëꞌë latj Dios yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Lëzcaꞌ cni rëpaꞌ lbiꞌiliꞌ, chquiꞌ chopzliꞌ gun tuz xtídzaꞌliꞌ luyú ni ca nac tu le gnábiliꞌ‑nëꞌ Dios, gunnëꞌ queëliꞌ lë naꞌ Xuzczaꞌ Dios, zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ga nacuáꞌ chop tsonn nup ni nudubgac quiaꞌ nedaꞌ, zoaczaꞌ nedaꞌ gatsj lahuiꞌl ga naꞌ nacuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Niꞌr gbiguëꞌë Pedro ga zoëꞌ Jesús len gnabnëꞌ Lëꞌ, rnëꞌ: ―Xan, ¿bálaxtë lzu ral‑laꞌ unít lahuaꞌ böchiꞌ lzaꞌa, nu naꞌ ruaꞌ döꞌ quiaꞌ? ¿Naruꞌ gadx lzu? ");
INSERT INTO zsrNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús rëꞌ lëꞌ: ―Nedaꞌ rëpaꞌ liꞌ, clëg gadx lzuz, san gdu tsonnlalj yu chi cöꞌ nac gadx lzu. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gnëꞌ caꞌ Jesús: ―Yetú caꞌ, ca gun Nu naꞌ rna bëꞌ yehuaꞌ yubá nac ca benëꞌ bönniꞌ rna bëꞌë. Guꞌnnëꞌ ucáꞌnlenëꞌ tsahuiꞌ yuguꞌ bönniꞌ huen dxin queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Catiꞌ gzu lahuëꞌ rucáꞌnlenëꞌ lequëꞌ tsahuiꞌ, djuaꞌquëꞌ ga zoëꞌ tu bönniꞌ ral‑lëꞌë queëꞌ zian gayuáꞌ dumí. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Le cutu guc quizxjëꞌ, gna bëꞌë xanëꞌ laꞌdaꞌu lëꞌ len ngul queëꞌ, len yuguꞌ biꞌi queëꞌ, len yúguꞌtë le dë queëꞌ, atiꞌ niꞌr gazxj le ral‑lëꞌë queëꞌ xanëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Niꞌr buzechu zxibëꞌ lahuëꞌ xanëꞌ huen dxin naꞌ len gnabnëꞌ lëꞌ, rnëꞌ: “Xan, ben zxön ladxuꞌu nedaꞌ. Huaguizxjczaꞌ liꞌ yúguꞌtë.” ");
INSERT INTO zsrNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Niꞌr xanëꞌ naꞌ buechiꞌ ladxëꞌë bönniꞌ huen dxin queëꞌ naꞌ, len bunít lahuëꞌ lëꞌ lë naꞌ ral‑lëꞌë queëꞌ, atiꞌ busanëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Catiꞌ burujëꞌ niꞌ bönniꞌ huen dxin naꞌ, laꞌ yajtsagtëꞌ tu bönniꞌ rúnlenëꞌ lëꞌ tsazxö́n dxin, atiꞌ bönniꞌ naꞌ ral‑lëꞌë queëꞌ látiꞌdauꞌz dumí. Niꞌr gzxönëꞌ lëꞌ len gzxöndjëꞌ yenëꞌ, rëꞌ lëꞌ: “Gdizxjtë lë naꞌ ral‑luꞌu quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Niꞌr buzechu zxibëꞌ lahuëꞌ lzëꞌë naꞌ len gnab yechëꞌë lahuëꞌ, rnëꞌ: “Ben zxön ladxuꞌu nedaꞌ. Huaguizxjczaꞌ liꞌ yúguꞌtë.” ");
INSERT INTO zsrNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cutu guꞌnnëꞌ bönniꞌ huen dxin naꞌ, atiꞌ yajluꞌë lëꞌ lidx guia dza quizxjrëꞌ lë naꞌ ral‑lëꞌë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Catiꞌ gulaléꞌinëꞌ lë ni yezícaꞌrëꞌ huen dxin, guluhuíꞌntsquinëꞌ niꞌa queëꞌ, atiꞌ yajtíxjöiꞌcnëꞌ xanquëꞌ yúguꞌtë lë naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Niꞌr bulidzëꞌ bönniꞌ huen dxin naꞌ xanquëꞌ, atiꞌ rëꞌ lëꞌ: “Liꞌ, huen dxin cunác tsahuiꞌ. Yúguꞌtë dumí naꞌ gul‑luꞌu quiaꞌ bunít lahuaꞌ liꞌ. Busulaꞌ lë naꞌ gul‑luꞌu quiaꞌ le gnab yechuꞌu lahuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Naruꞌ cu ral‑laꞌ huechiꞌ ladxuꞌu caꞌ lzaꞌu ca naꞌ benaꞌ quiuꞌ nedaꞌ, buechiꞌ ladxaꞌa liꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Niꞌr gléytsquinëꞌ xanëꞌ len budödëꞌ lëꞌ lu naꞌgac nup lusacaꞌ ziꞌ lëꞌ dza quizxjrëꞌ gdutë le ral‑lëꞌë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Niꞌr rnëꞌ Jesús: ―Lëzcaꞌ cni gunëꞌ queëliꞌ Xuzaꞌ zoëꞌ yehuaꞌ yubá chquiꞌ cutu unít lauliꞌ gdu ládxiꞌliꞌ yuguꞌ böchiꞌ lzaꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Catiꞌ budx bëꞌë yuguꞌ didzaꞌ ni Jesús, buzë́ꞌë luyú Galilea, atiꞌ bdxinëꞌ luyú Judea le dë yetsláꞌa yegu Jordán zacaꞌ ga rlen gbidz. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zjaclen Jesús bunách zian, atiꞌ bunëꞌ lequëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niꞌr guladxinëꞌ ga zoëꞌ Jesús laꞌquëꞌ bönniꞌ gdauꞌ fariseo quië laꞌzíꞌ bëꞌë Lëꞌ, atiꞌ gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Naruꞌ dë latj bönniꞌ nutság nëꞌë usanëꞌ ngul queëꞌ niꞌa qui bítiꞌtëz bi rac? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ cu nulábniliꞌ le nayúj lu guich laꞌy ca benëꞌ bunách Dios catiꞌ ziꞌa benëꞌ yödzlyú, bönniꞌ len ngul benëꞌ lequëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Cni gnëꞌ Dios: “Qui lë ni naꞌ, ral‑laꞌ usanëꞌ xuz xnëꞌë bönniꞌ, atiꞌ tsaz tsajsóalenëꞌ‑nu ngul queëꞌ, atiꞌ gropëꞌ naꞌ luhuöaquëꞌ tuz bunách.” ");
INSERT INTO zsrNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cni nac, cutur nacquëꞌ chopëꞌ san tuz bunách chnuhuöacquëꞌ. Qui lë ni naꞌ, cutu ral‑laꞌ lulë́ꞌë bönniꞌ nup naꞌ benëꞌ tuz Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Niꞌr gulanabnëꞌ Jesús bönniꞌ gdauꞌ naꞌ, taꞌnë́ꞌ: ―¿Bizx quië naꞌ gna béꞌinëꞌ lequëꞌ Moisés le ruiꞌ latj bönniꞌ unödzjëꞌ queënu ngul queëꞌ tu guich le ruláꞌa yöl‑laꞌ nutság naꞌ, atiꞌ usanëꞌ‑nu ngul queëꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús rëꞌ lequëꞌ: ―Cni benëꞌ Moisés le nazíd icj ládxiꞌdauꞌliꞌ, bennëꞌ lbiꞌiliꞌ latj usanliꞌ‑nu ngul queëliꞌ, san catiꞌ gzu lau gutaꞌ gröꞌ yödzlyú, cutu guc cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nedaꞌ rëpaꞌ lbiꞌiliꞌ, chquiꞌ usanëꞌ‑nu ngul queëꞌ bönniꞌ len cutu gdálennu bönniꞌ yubl, atiꞌ utság náꞌlenëꞌ‑nu ngul yubl, gunëꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. Lëzcaꞌ cni, chquiꞌ utság náꞌlenëꞌ‑nu ngul naꞌ nu bönniꞌ, nusanëꞌ‑nu bönniꞌ queënu, gunëꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Niꞌr tëꞌ Jesús bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―Chquiꞌ cni nac queëꞌ bönniꞌ zóalenëꞌ‑nu ngul queëꞌ, dxiꞌar gac queëꞌ laꞌnaruꞌ cu gtsagcz nëꞌë, ugaꞌnëꞌ tuzëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu gac laꞌzíꞌ lu naꞌgac didzaꞌ ni yúguꞌtë bunách, san nupz naꞌ Dios ruzéjniꞌnëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nacuꞌë bönniꞌ cutu tuꞌtság náꞌlenquëꞌ ngul le cunacquëꞌ gdu bönniꞌ byuꞌ, le glaljëꞌ caꞌ, atiꞌ yelaꞌquëꞌ bönniꞌ cutu tuꞌtság náꞌlenquëꞌ ngul le guluzagaꞌ xnözquëꞌ bunách, atiꞌ yelaꞌquëꞌ bönniꞌ cutu tuꞌtság náꞌlenquëꞌ ngul quië gac lunëꞌ xchinëꞌ Dios Nu rna bëꞌ yehuaꞌ yubá. Nu saquiꞌ siꞌ lu nëꞌi didzaꞌ ni ral‑laꞌ siꞌ lu nëꞌi lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Niꞌr djuaꞌcquëꞌ‑biꞌ ga zoëꞌ Jesús biꞌidauꞌ xuz xnaꞌcbiꞌ quië gxoa nëꞌë lecbiꞌ len ulidzëꞌ Dios niꞌa quecbiꞌ, atiꞌ guluzaguëꞌë xnözquëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Niꞌr rëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑güíꞌ‑biꞌ latj biꞌidauꞌ laꞌdxinbiꞌ ga zoaꞌ, len cutu uzágaꞌliꞌ xnözcbiꞌ, le laꞌzíꞌ latj nup nacgac ca yuguꞌ biꞌidauꞌ cni ga niꞌ rna bëꞌë Dios yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bxoa nëꞌë lecbiꞌ Jesús, atiꞌ niꞌr buzë́ꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Duyúëꞌ Jesús bönniꞌ ni zoëꞌ iz cuidiꞌ queëꞌ, len rëꞌ Lëꞌ: ―Bönniꞌ Usëdi gdu dxiꞌa. ¿Bizxa le nac dxiꞌa ral‑laꞌ gunaꞌ quië gdél‑liꞌdaꞌ yöl‑laꞌ naꞌbán gdu? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―¿I nöznuꞌ bizxa naꞌ rnauꞌ quiaꞌ, rnauꞌ nacaꞌ gdu dxiꞌa? Nutu nu bönniꞌ naquëꞌ gdu dxiꞌa. Tuzëꞌ Dios naquëꞌ gdu dxiꞌa. Chquiꞌ rëꞌnnuꞌ gdél‑liꞌnuꞌ yöl‑laꞌ naꞌbán gdu, ben ca rna bëꞌ zxba queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Niꞌr rëꞌ Jesús bönniꞌ naꞌ, rnëꞌ: ―¿Bizxal zxba naꞌ? Jesús rëꞌ lëꞌ: ―Zxba naꞌ gna bëꞌë Moisés: Cutu gdödnuꞌ bunách. Cutu gunuꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. Cutu cuanuꞌ. Cutu gnëuꞌ qui lzaꞌu le cunácz. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ben ba laꞌn xuz xnaꞌu. Bdxiꞌi böchiꞌ lzaꞌu ca nadxíꞌi cuinuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gudxëꞌ Jesús bönniꞌ naꞌ ni zoëꞌ iz cuidiꞌ queëꞌ, rnëꞌ: ―Yúguꞌtë lë ni runaꞌ ga gdel‑laꞌ nacaꞌ biꞌidauꞌ. ¿Naruꞌ zoa yetú le ral‑laꞌ gunaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús rëꞌ lëꞌ: ―Chquiꞌ rëꞌnnuꞌ gacuꞌ gdu tsahuiꞌ, gyeaj, yjëtiꞌ le dë quiuꞌ, atiꞌ dumí naꞌ siꞌu, bunö́dzj quegac bunách yechiꞌ. Cni gataꞌ quiuꞌ yöl‑laꞌ tsahuiꞌ niꞌ yehuaꞌ yubá. Niꞌr gda, gdaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Catiꞌ byönnëꞌ didzaꞌ ni bönniꞌ naꞌ ni zoëꞌ iz cuidiꞌ queëꞌ, zhuöjëꞌ ruhuiꞌnnëꞌ le dëtsca yöl‑laꞌ tsahuiꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Niꞌr Jesús gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, baníg nac tsaziëꞌ ga rna bëꞌë Dios yehuaꞌ yubá bönniꞌ dë yöl‑laꞌ tsahuiꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yetú caꞌ rëpaꞌ lbiꞌiliꞌ, nacr baníg tsaziëꞌ ga niꞌ rna bëꞌë Dios bönniꞌ dë yöl‑laꞌ tsahuiꞌ queëꞌ ca tödbaꞌ böaꞌ lu nag yötsiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Catiꞌ gulayönnëꞌ didzaꞌ ni bönniꞌ usë́d queëꞌ, gulubannëꞌ, taꞌnë́ꞌ: ―¿Nuzxa caz gac ulá, chquiꞌnuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Buyúëꞌ lequëꞌ Jesús len rëꞌ lequëꞌ: ―Cutu gac lun lë ni bunách, san Dios huac gunëꞌ yúguꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Niꞌr bubiꞌë didzaꞌ Pedro, rëꞌ Jesús: ―Byutscaꞌ, netuꞌ chbucaꞌntuꞌ yúguꞌtë len záꞌlentuꞌ Liꞌ. ¿Bizxar gataꞌ queëtuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, dza niꞌ catiꞌ ucúb yödzlyú atiꞌ cöꞌa gna bëꞌa nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, ga niꞌ gáctëraꞌ blau, lëzcaꞌ lbiꞌiliꞌ záꞌlenliꞌ nedaꞌ, cöꞌliꞌ chinnu latj ga gna bëꞌliꞌ, cuequi xbeyliꞌ idxinnu cöꞌtë yödz quegac zxiꞌn xsoëꞌ Israel. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nu bönniꞌ rucaꞌnëꞌ lidxëꞌ, o yuguꞌ böchëꞌë, o yuguꞌ zanëꞌ, o xuzëꞌ, o xnëꞌë, o ngul queëꞌ, o yuguꞌ zxiꞌnëꞌ, o yuguꞌ laꞌ yël queëꞌ, quië gunëꞌ xchinaꞌ, bönniꞌ ni siꞌ queëꞌ yetú gayuaꞌtër caꞌ, len gataꞌ caꞌ queëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Zian nup naꞌa nacgac blau, caꞌz lugáꞌn, atiꞌ nup naꞌa nagaꞌngac caꞌz, hualác blau. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gnëꞌ caꞌ Jesús: ―Ca gun Nu naꞌ rna bëꞌ yehuaꞌ yubá nac ca benëꞌ tu bönniꞌ xan yuꞌu. Brujëꞌ zildauꞌ, yajtiljëꞌ bönniꞌ lunëꞌ dxin ga nac laꞌ yël queëꞌ ga naꞌ naduzgac lba uva. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Catiꞌ chbugáꞌnlenëꞌ tsahuiꞌ yuguꞌ bönniꞌ huen dxin naꞌ, quizxjëꞌ lequëꞌ tu dumí lazxj qui tu dza, bsölëꞌë lequëꞌ lunëꞌ dxin ga nac laꞌ yël queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Catiꞌ burujëꞌ gdu xsil, bléꞌinëꞌ yelaꞌquëꞌ bönniꞌ nacuaꞌzëꞌ caꞌ ga nac lu yëꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Rëꞌ lequëꞌ: “Gul‑tséaj caꞌ lbiꞌiliꞌ ga nac laꞌ yël quiaꞌ, atiꞌ quizxjaꞌ lbiꞌiliꞌ le nac tsahuiꞌ.” Laꞌ yjactëꞌ caꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Burujëꞌ leyúbl bönniꞌ xan yuꞌu naꞌ gdu huagbídz, lencaꞌ gdu xhuö udzö́ꞌ len laꞌ tuz ca benëꞌ, bsölëꞌë laꞌ yël queëꞌ yuguꞌ bönniꞌ yajxaquëꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Burujëꞌ caꞌ catiꞌ niꞌ zoa yelátiꞌdauꞌz gbidz len yajxaquëꞌë yelaꞌquëꞌ bönniꞌ nacuaꞌzëꞌ caꞌ niꞌ, atiꞌ rëꞌ lequëꞌ: “¿Bizx quië zóatsaliꞌ ni caꞌz gdu dza, cutu bi dxin runliꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tëꞌ lëꞌ bönniꞌ naꞌ, taꞌnë́ꞌ: “Nutu nu benn xchintuꞌ.” Niꞌr rëꞌ lequëꞌ: “Gul‑tséaj caꞌ lbiꞌiliꞌ ga nac laꞌ yël quiaꞌ, atiꞌ quizxjaꞌ lbiꞌiliꞌ le nac tsahuiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Catiꞌ chzoa gal, bönniꞌ xan laꞌ yël naꞌ rëꞌ bönniꞌ yuꞌu lu nëꞌë dxin naꞌ, rnëꞌ: “Blidz‑quëꞌ bönniꞌ huen dxin naꞌ, atiꞌ guꞌu lazxjquëꞌ, quizxjuꞌ ziꞌal bönniꞌ naꞌ guladxinëꞌ yajseytë. Udx naꞌ quizxjuꞌ bönniꞌ naꞌ guladxinëꞌ zíꞌatël.” ");
INSERT INTO zsrNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Niꞌr guladxinëꞌ bönniꞌ yjenquëꞌ dxin catiꞌ niꞌ zoa yelátiꞌdauꞌz gbidz, len gulaziꞌë tu tuhueajquëꞌ dumí lazxj qui tu dza. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Catiꞌ guladxinëꞌ bönniꞌ yjenquëꞌ dxin zíꞌatël, gláquinëꞌ huaziꞌquëꞌ yelatiꞌ, san lëzcaꞌ gulaziꞌë tu tuhueajquëꞌ dumí lazxj qui tu dza. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Catiꞌ gulaziꞌë lei, gulanëtsquëꞌ queëꞌ bönniꞌ xan yuꞌu naꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","taꞌnë́ꞌ: “Bönniꞌ ni guladxinëꞌ ga yajseytë, tu chiꞌz glunëꞌ dxin, len tuz ca gdizxjtsuꞌ lequëꞌ ca netuꞌ, atiꞌ netuꞌ ni bentuꞌ dxin gdu dza, gúguitscatuꞌ gbidz.” ");
INSERT INTO zsrNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bubiꞌë didzaꞌ xan laꞌ yël naꞌ, rëꞌ tuëꞌ: “Böchaꞌa, cutu bi runaꞌ quiuꞌ le cunác tsahuiꞌ. ¿Naruꞌ cu bugáꞌn tsáhuiꞌruꞌ siꞌu tu dumí lazxj qui tu dza? ");
INSERT INTO zsrNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gzxiꞌ lazxjuꞌ, len böaj lidxuꞌ. Nedaꞌ rëꞌndaꞌ quizxjaꞌ bönniꞌ ni yjenëꞌ dxin ga yajseytë laꞌ leyz ca naꞌ rguizxjaꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Naruꞌ cu dë lu naꞌa gunaꞌ ca rëꞌndaꞌ len yuguꞌ le naqui quiaꞌ? ¿Naruꞌ ruzxéꞌitsanuꞌ‑nëꞌ lzaꞌu le runnaꞌ queëꞌ szxöni?” ");
INSERT INTO zsrNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Cni nac, laꞌquëꞌ bönniꞌ, tuꞌcáꞌn lequëꞌ caꞌz bunách, lacquëꞌ blau, atiꞌ laꞌquëꞌ bönniꞌ, nacquëꞌ blau, lugaꞌnëꞌ caꞌz. Zian nup nulidzaꞌ, san nabábz nup laꞌrögac. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Catiꞌ niꞌ yuꞌë nöz Jesús, zijëꞌ Jerusalén, bchëꞌë quizi idxínnutëꞌ bönniꞌ usë́d queëꞌ, len rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Gul‑yutscaꞌ, rbenruꞌ zijruꞌ Jerusalén, atiꞌ niꞌ soa nu udö́d nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lu naꞌquëꞌ bxuz uná bëꞌ len lu naꞌquëꞌ bönniꞌ gdauꞌ tuꞌsëdi, atiꞌ laꞌchuguëꞌ quiaꞌ gatiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ludödëꞌ nedaꞌ lu naꞌquëꞌ bönniꞌ gzaꞌa quië lutitjëꞌ nedaꞌ. Laꞌguinëꞌ nedaꞌ len ludë́ꞌë nedaꞌ lëꞌi yag cruz, san catiꞌ gac tsonn dza, Dios uspanëꞌ nedaꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Niꞌr bdxinnu ga zoëꞌ Jesús xnaꞌquëꞌ Jacobo len Juan, yuguꞌ zxiꞌnëꞌ Zebedeo, dzagquëꞌ‑nu chopëꞌ ni, atiꞌ buzechu zxibnu lahuëꞌ Jesús, len gnábinu Lëꞌ tu le uzáꞌ ladxëꞌë queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús gnabnëꞌ‑nu, rnëꞌ: ―¿Bizxa rëꞌnnuꞌ? Rënu Lëꞌ: ―Gna bëꞌ cöꞌbiꞌ tubiꞌ zxiꞌnaꞌ ni cuit lëꞌu yubél len yetubiꞌ cöꞌbiꞌ cuit lëꞌu yögl ga niꞌ gna bëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu nö́ziliꞌ le rnabliꞌ. ¿Naruꞌ huac guaꞌ glenliꞌ le sacaꞌ quiꞌa nedaꞌ, len gdil‑liꞌ nis ca gdilaꞌ nedaꞌ nis, gatiaꞌ? Tëꞌ Lëꞌ: ―Huactuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Niꞌr Jesús rëꞌ lequëꞌ: ―Le nactë le ral‑laꞌ sacaꞌ quiꞌa nedaꞌ, gac caꞌ queëliꞌ, len le ral‑laꞌ gdilaꞌ nedaꞌ nis, gatiaꞌ, gdil‑liꞌ caꞌ nis lbiꞌiliꞌ, san quië cöꞌliꞌ cuit lëꞌa yubél o cuit lëꞌa yögl, cutu dë lu naꞌa nu guꞌa qui, san gataꞌ quegac nup niꞌ chnupë́ꞌë quegac Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Catiꞌ gulayönnëꞌ lë ni yechíëꞌ bönniꞌ usë́d queëꞌ Jesús, gulaleynëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Niꞌr bulidzëꞌ lequëꞌ Jesús, rnëꞌ: ―Nö́ziczliꞌ ca tunëꞌ bönniꞌ taꞌná béꞌinëꞌ bunách gzaꞌa, rdödtë bëꞌi taꞌná béꞌinëꞌ lequëꞌ, atiꞌ nup niꞌ nacgacr blau taꞌná beꞌi laꞌ lzaꞌgacz. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Cutu gac cni queëliꞌ. Nútiꞌtëzl‑liꞌ lbiꞌiliꞌ nu rëꞌni gac zxön ga zoaliꞌ, nu ni ral‑laꞌ gun dxin qui yezícaꞌrliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lëzcaꞌ cni, nútiꞌtëzl‑liꞌ lbiꞌiliꞌ nu guëꞌni gac blau, ral‑laꞌ gac ca bönniꞌ nadaꞌu qui yezícaꞌrliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lëzcaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, bidaꞌ ni, clëg quië nu gun xchinaꞌ, san quië gunaꞌ xchingac bunách, len udödaꞌ yöl‑laꞌ naꞌbán quiaꞌ, le quizxjdaꞌ quegac bunách zian quië lulá. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Catiꞌ niꞌ tuꞌrujëꞌ yödz Jericó, zjaclen Jesús bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nacuꞌë niꞌ chopëꞌ bönniꞌ nachúl lauquëꞌ, röꞌquëꞌ raꞌ nöz. Catiꞌ gulayönnëꞌ rdödëꞌ niꞌ Jesús, gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Xan, zxiꞌn xsoëꞌ David, buechiꞌ ladxiꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gulaná beꞌi lequëꞌ bunách zian nacuáꞌ niꞌ quië laꞌcuꞌë dxiz, san zidzjr gluꞌë didzaꞌ, taꞌnë́ꞌ: ―Xan, zxiꞌn xsoëꞌ David, buechiꞌ ladxiꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Niꞌr gzëꞌ rbözëꞌ Jesús, len bulidzëꞌ lequëꞌ, atiꞌ gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Bizxa rë́ꞌniliꞌ gunaꞌ queëliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tëꞌ Jesús: ―Xan, rë́ꞌnituꞌ gunuꞌ ga huöalj yöj lautuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Niꞌr buechiꞌ ladxëꞌë lequëꞌ Jesús len gdanëꞌ yöj lauquëꞌ. Laꞌ guluhuöaljtë yöj lauquëꞌ, atiꞌ yjáclenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Catiꞌ guladxíngalëꞌ yödz Jerusalén, len niꞌ nacuꞌë ga dë yödz Betfagé ga naꞌ zoa Guiꞌa Ga Röꞌgac Yag Olivo, niꞌr bsölëꞌë Jesús chopëꞌ bönniꞌ usë́d queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","len rëꞌ lequëꞌ: ―Gul‑tseajtscaꞌ yödzdauꞌ niꞌ ca dödl ga ni zoaruꞌ, atiꞌ laꞌ tsajxácaꞌtëliꞌ‑baꞌ tubaꞌ burro gnaꞌ nágaꞌbaꞌ, len dzag lëbaꞌ tubaꞌ burro byuꞌdauꞌ. Gul‑tsajsédx‑baꞌ len gchëꞌliꞌ‑baꞌ quiaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chquiꞌ nu bi guië lbiꞌiliꞌ, gul‑guië́ nu naꞌ: “Xanruꞌ rquinnëꞌ‑baꞌ.” Niꞌr gsölëꞌë quiaꞌ lecbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Cni guc quië butság ca naꞌ buzujëꞌ lu guich bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gul‑guië́ nup nacuáꞌ yödz Sión, Gul‑yutscaꞌ, zëꞌë queëliꞌ Bönniꞌ gna béꞌinëꞌ lbiꞌiliꞌ. Lu yöl‑laꞌ nöxj ladxiꞌ queëꞌ dxiëꞌ‑baꞌ tubaꞌ burro. Dxiëꞌ cúdzuꞌbaꞌ búrrodauꞌ nacbaꞌ zxiꞌnbaꞌ böaꞌ ruaꞌbaꞌ yuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Niꞌr yjaquëꞌ niꞌ bönniꞌ usë́d queëꞌ, atiꞌ glunëꞌ ca naꞌ gna béꞌinëꞌ lequëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gulachë́ꞌë‑baꞌ burro gnaꞌ naꞌ len burro byuꞌdauꞌ naꞌ, atiꞌ guludxíëꞌ cúdzuꞌcbaꞌ yuguꞌ lariꞌ guitsaꞌ quequëꞌ, atiꞌ lahui lariꞌ naꞌ gdxiëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nacuáꞌ caꞌ niꞌ bunách zian, atiꞌ gulachílj laꞌ nöz yuguꞌ lariꞌ taꞌxóa cúdzuꞌquëꞌ. Yelaꞌquëꞌ guluchibëꞌ zin le guluzxóëꞌ ga nac laꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zidzj gluiꞌ didzaꞌ bunách naꞌ nanörgac len nup naꞌ zjaclen Jesús, taꞌnë́ꞌ: ―Yöl‑laꞌ ba Lëꞌ, zxiꞌn xsoëꞌ David. Bicaꞌ ba nu ni zaꞌ niꞌa qui lëꞌ Xanruꞌ. Yöl‑laꞌ ba Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Catiꞌ gyaziëꞌ Jesús Jerusalén, glun rusbö́ yúguꞌtë bunách lu yödz naꞌ, atiꞌ zian nup glë lzaꞌgac, taꞌná: ―¿Nuzxa caz bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yelaꞌgac bunách niꞌ taꞌná: ―Nu ni Jesús, bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, nac ladzëꞌ Nazaret luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Catiꞌ gyaziëꞌ Jesús löꞌa gdauꞌ queëꞌ Dios, buláguëꞌë niꞌl yúguꞌtë nup tutiꞌ len taꞌu ga nac löꞌa gdauꞌ naꞌ. Burixëꞌ caꞌ yuguꞌ blag quequëꞌ bönniꞌ tuꞌtsë́ꞌë dumí yödz ziꞌtuꞌ, len yuguꞌ le taꞌböꞌi nup tutiꞌ budödauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Rëꞌ lequëꞌ: ―Nayúj lu guich laꞌy, rna: “Lidxaꞌ siꞌ lei, yuꞌu ga nu ulídz Dios”, san lbiꞌiliꞌ chnunliꞌ ni ca nac bloj quegac gban. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Catiꞌ niꞌ zoëꞌ Jesús nchil gdauꞌ, guladxinëꞌ ga naꞌ zoëꞌ laꞌquëꞌ bönniꞌ nachúl lauquëꞌ len bönniꞌ cutaꞌzë́ꞌë, atiꞌ Lëꞌ bunëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gulaleynëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi catiꞌ gulaléꞌinëꞌ yuguꞌ yöl‑laꞌ huac ni runëꞌ Jesús, len gulayönnëꞌ tuiꞌbiꞌ zidzj didzaꞌ biꞌidauꞌ ga nac nchil gdauꞌ, taꞌnabiꞌ: ―Bicaꞌ ba Lëꞌ, zxiꞌn xsoëꞌ David. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Niꞌr tëꞌ Jesús: ―¿Naruꞌ cu ryönnuꞌ ca taꞌnabiꞌ biꞌi ni? Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Ja, ryöndaꞌ. ¿Naruꞌ gatga nulábiniliꞌ le nayúj lu guich laꞌy cnicz ral‑laꞌ gac? Cni rna: “Liꞌ benuꞌ ga glul‑lbiꞌ yöl‑laꞌ ba le nac gdu yuguꞌ biꞌi cuidiꞌ len yuguꞌ biꞌidauꞌ niꞌ tádxiꞌbiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Niꞌr bucaꞌnëꞌ lequëꞌ Jesús len burujëꞌ Jerusalén, atiꞌ gyijëꞌ Betania ga niꞌ bugaꞌnëꞌ gdu yël. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Catiꞌ zaꞌ reníꞌ, atiꞌ niꞌ zhuöjëꞌ Jesús Jerusalén, rdunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bléꞌinëꞌ tu yag higo zoa gal‑laꞌ cuiti nöz, atiꞌ gbiguëꞌë ga naꞌ zoa, san cutu bi bdzö́linëꞌ lu yag naꞌ. Xlaguiꞌz dxia. Niꞌr Jesús gudxëꞌ lei: ―Cutur cuia le rbia quiuꞌ. Laꞌ gbidxtë yag higo naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Catiꞌ gulaléꞌinëꞌ lë ni bönniꞌ usë́d queëꞌ, gulubannëꞌ, atiꞌ gulanabnëꞌ Jesús, taꞌnë́ꞌ: ―¿Nacxcz guc, gbidxtë yag ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, chquiꞌ tséjlëꞌliꞌ Dios len cugác chop ládxiꞌliꞌ, clëgz huac gunliꞌ ca naꞌ benaꞌ qui yag ni, san chquiꞌ guiëliꞌ guiꞌa ni: “Bcuit len yajsóa lu nis zxön”, gac ca naꞌ gnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lëzcaꞌ cni, yúguꞌtë le gnabliꞌ catiꞌ ulidzliꞌ‑nëꞌ Dios, chquiꞌ huayéjlëꞌliꞌ gunnëꞌ queëliꞌ Dios, huaziꞌliꞌ lë naꞌ gnabliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Niꞌr gyaziëꞌ Jesús nchil gdauꞌ, len tsal niꞌ rusëdnëꞌ bunách nacuáꞌ niꞌ, guladxinëꞌ ga zoëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi, atiꞌ gulanabnëꞌ Jesús, taꞌnë́ꞌ: ―¿Bizxa yöl‑laꞌ uná bëꞌ dë lu naꞌu, runtsuꞌ yuguꞌ lë ni? ¿Nuzxa budö́d lu naꞌu yöl‑laꞌ uná bëꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Lëzcaꞌ nedaꞌ gnábtsquiꞌdaꞌ lbiꞌiliꞌ tu didzaꞌ. Chquiꞌ quíxjöiꞌliꞌ nedaꞌ ca nac, nedaꞌ caꞌ gyëpaꞌ lbiꞌiliꞌ bizxa yöl‑laꞌ uná bëꞌ dë lu naꞌa runaꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nuzxa caz bsölaꞌ Juan, buquilëꞌ bunách nis? ¿Naruꞌ Dios bsölëꞌë lëꞌ, o gulasölëꞌë lëꞌ bönniꞌ? Niꞌr gulazú lauquëꞌ bönniꞌ gdauꞌ naꞌ taꞌnë́ꞌ laꞌ légaczëꞌ: ―Chquiꞌ gnaruꞌ: Dios bsölëꞌë lëꞌ, laꞌ guiëtëꞌ rëꞌu: “¿Bizx quië cutu gyéjlëꞌliꞌ lëꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Naꞌa, chquiꞌ gnaruꞌ: Gulasölëꞌë lëꞌ bönniꞌ, rádxiruꞌ bunách lu yödz le taꞌyejlëꞌë yúguꞌtëꞌ Juan naꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Qui lë ni naꞌ gulubiꞌë didzaꞌ, tëꞌ Jesús: ―Cutu nö́zituꞌ. Jesús rëꞌ lequëꞌ: ―Nedaꞌ caꞌ, cutu gyëpaꞌ lbiꞌiliꞌ bizxa yöl‑laꞌ uná bëꞌ dë lu naꞌa runaꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Niꞌr Jesús gudxëꞌ yuguꞌ bönniꞌ gdauꞌ naꞌ: ―¿Nacx runi lbiꞌiliꞌ? Zoëꞌ bönniꞌ nacuaꞌbiꞌ chopbiꞌ biꞌi bönniꞌ queëꞌ, atiꞌ yjödxëꞌ‑biꞌ tubiꞌ biꞌi queëꞌ naꞌ, gnëꞌ: “Zxiꞌnaꞌ, gyeaj naꞌa tsjenuꞌ dxin ga nac laꞌ yël quiaꞌ ga röꞌgac lba uva.” ");
INSERT INTO zsrNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bubiꞌbiꞌ didzaꞌ biꞌi naꞌ, gudxbiꞌ‑nëꞌ: “Cutu rëꞌndaꞌ tsijaꞌ.” Gdöd niꞌ bubíꞌi ládxiꞌbiꞌ atiꞌ yjenbiꞌ dxin. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Niꞌr bönniꞌ naꞌ yjödxëꞌ‑biꞌ yetubiꞌ biꞌi queëꞌ naꞌ, len laꞌ leyz ca gnëꞌ, atiꞌ bubiꞌbiꞌ didzaꞌ biꞌi ni, gudxbiꞌ‑nëꞌ: “Huac, Dad. Huayijaꞌ.” Cutu gyeajbiꞌ biꞌi ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Núzxalbiꞌ biꞌi chop ni benbiꞌ le bdzag ladxëꞌë xuzbiꞌ? Gulubiꞌë didzaꞌ, tëꞌ Jesús: ―Biꞌi ziꞌal naꞌ. Niꞌr Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, laꞌnörëꞌ ca lbiꞌiliꞌ yuguꞌ bönniꞌ uquízxj tuaꞌdöꞌ len yuguꞌ ngul udá dzag, laꞌyaziëꞌ ga niꞌ rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cni gac, le bidëꞌ ga zoaliꞌ Juan, bönniꞌ buquilëꞌ bunách nis, len busëdnëꞌ lbiꞌiliꞌ le nac tsahuiꞌ ca ral‑laꞌ gunliꞌ, atiꞌ lbiꞌiliꞌ cutu gyéjlëꞌliꞌ lëꞌ, san gulayejlëꞌë lëꞌ yuguꞌ bönniꞌ uquízxj len yuguꞌ ngul udá dzag. Zal‑laꞌ bléꞌiliꞌ lë ni, cutu bubíꞌi ládxiꞌliꞌ quië tséjlëꞌliꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Gnëꞌ caꞌ Jesús: ―Gul‑zë́ nagliꞌ yetú le gunaꞌ lsaquiꞌ. Zoëꞌ bönniꞌ xan yuꞌu, atiꞌ bönniꞌ ni guzëꞌ laꞌ yël queëꞌ yuguꞌ lba uva. Glequëꞌ liꞌaj qui len bchöꞌnëꞌ lerui guiöj ga gsiëꞌ xisi uva naꞌ. Benëꞌ caꞌ tu yuꞌu xtsaꞌ ga nu uyú gdutë laꞌ yël queëꞌ. Niꞌr budödëꞌ laꞌ yël naꞌ lu naꞌquëꞌ bönniꞌ huen dxin, laꞌziꞌë quequëꞌ latiꞌ hueaj, atiꞌ gyijëꞌ yödz ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Catiꞌ chbdxin dza luchibëꞌ laꞌ yël naꞌ, bsölëꞌë bönniꞌ xan laꞌ yël laꞌquëꞌ niꞌa nëꞌë ga naꞌ nacuꞌë bönniꞌ huen dxin niꞌ quië luziꞌë lu naꞌquëꞌ uláz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Niꞌr yuguꞌ bönniꞌ huen dxin naꞌ gulazönëꞌ yuguꞌ niꞌa nëꞌë naꞌ. Glunëꞌ huëꞌ tuëꞌ len yetúëꞌ caꞌ guludöddëꞌ lëꞌ, len yetúëꞌ gululadxëꞌ lëꞌ guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Leyúbl bsölëꞌë caꞌ yelaꞌquëꞌ niꞌa nëꞌë bönniꞌ xan laꞌ yël naꞌ, glaquëꞌ ziántërëꞌ ca nup naꞌ bsölëꞌë ziꞌal, atiꞌ laꞌ tuz ca glunëꞌ quequëꞌ bönniꞌ huen dxin niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ga yajseytë, bsölëꞌë caꞌ zxiꞌnëꞌ ga naꞌ nacuꞌë. Gzaꞌ ladxëꞌë, rnëꞌ: “Hualunëꞌ ba laꞌn biꞌi quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Catiꞌ gulaléꞌinëꞌ‑biꞌ zxiꞌnëꞌ bönniꞌ huen dxin naꞌ, laꞌ gulanatëꞌ laꞌ légaczëꞌ: “Biꞌi ni gaqui queëbiꞌ laꞌ yël ni. Gul‑dá, gdö́diruꞌ‑biꞌ, atiꞌ gaqui queëruꞌ le ral‑laꞌ gaqui queëbiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Niꞌr gulazönëꞌ‑biꞌ, atiꞌ gulubijëꞌ‑biꞌ niꞌl laꞌ yël ga naꞌ röꞌgac lba uva, atiꞌ niꞌ guludöddëꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Niꞌr Jesús gnabnëꞌ lequëꞌ, gnëꞌ: ―Catiꞌ udxinëꞌ bönniꞌ xan laꞌ yël naꞌ, ¿nacx gunëꞌ quequëꞌ bönniꞌ huen dxin niꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Gulubiꞌë didzaꞌ bönniꞌ gdauꞌ naꞌ, tëꞌ Jesús: ―Usnitiëꞌ bönniꞌ tuaꞌdöꞌ naꞌ, atiꞌ laꞌ yël queëꞌ naꞌ udödëꞌ lu naꞌquëꞌ yelaꞌquëꞌ bönniꞌ huen dxin, bönniꞌ luꞌë lëꞌ uláz queëꞌ catiꞌ gdxin dza luchibëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Niꞌr gudxëꞌ lequëꞌ Jesús: ―¿Naruꞌ gatga nulábniliꞌ lë naꞌ nayúj lu guich laꞌy ca nac lë ni? Cni rna: Guiöj naꞌ gularuꞌnëꞌ bönniꞌ tuꞌcuꞌë zöꞌö, Laꞌ guiöj naꞌz chnac guiöj len zöꞌö. Lëczëꞌ Xanruꞌ benëꞌ ga nac cni Atiꞌ nac tu le run ga rubániruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ, xlatjliꞌ ga naꞌ rna bëꞌë Dios gdua queëliꞌ len gataꞌ quegac bunách lun ca ral‑laꞌ gun nu nadel‑liꞌ latj niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nu gtup lu guiöj ni, laꞌ cuinzi quitsj, atiꞌ chquiꞌ guiöj ni tsajbagaꞌ bönniꞌ, uzxúzxj lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Catiꞌ gulayönnëꞌ lë naꞌ benëꞌ lsaquiꞌ Jesús yuguꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ gdauꞌ fariseo, táquibeꞌinëꞌ bëꞌë didzaꞌ Jesús ca nac quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gulazú gulaböꞌë laꞌzönëꞌ Jesús, san gládxinëꞌ bunách zian nacuáꞌ niꞌ le taꞌyejlëꞌ naquëꞌ Jesús bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Leyúbl bë́ꞌlenëꞌ lequëꞌ didzaꞌ Jesús, benëꞌ lsaquiꞌ, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ca gac quegac nup laꞌyáz ga rna bëꞌë Dios yehuaꞌ yubá nac ca guc quegac nup bulidzëꞌ bönniꞌ rna bëꞌë catiꞌ benëꞌ lni qui dza utság naꞌbiꞌ biꞌi bönniꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bsölëꞌë niꞌa nëꞌë tsajxiꞌquëꞌ nup naꞌ chnulidzëꞌ lid lni queëbiꞌ, san cutu glëꞌnnëꞌ lidëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Niꞌr bsölëꞌë yelaꞌquëꞌ niꞌa nëꞌë len gudxëꞌ lequëꞌ: “Gul‑tsjödxtscaꞌ nup naꞌ chnulidzaꞌ, guiëliꞌ lequëꞌ: Gul‑yutscaꞌ, chnupáꞌa laꞌ huagu. Chbudö́dcdaꞌ‑baꞌ yuguꞌ xpëdxaꞌ len yuguꞌ böaꞌ bëdx renniꞌ quiaꞌ. Yúguꞌtë chnupáꞌa. Gul‑dá, soaruꞌ lni queëbiꞌ biꞌi quiaꞌ utság naꞌbiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Cutu glunëꞌ lequëꞌ ba laꞌn bönniꞌ naꞌ yajlidzquëꞌ, atiꞌ yjaquëꞌ qui queëquëꞌ. Tuëꞌ yjenëꞌ dxin, len yetúëꞌ gyijëꞌ tsjöꞌu tsjë́tiꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yelaꞌquëꞌ gulazönëꞌ yuguꞌ niꞌa nëꞌë naꞌ, atiꞌ gluꞌë döꞌ quequëꞌ len guludödcdëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Catiꞌ byönnëꞌ lë ni bönniꞌ naꞌ rna bëꞌë, gleynëꞌ len bsölëꞌë bönniꞌ queëꞌ rjaquëꞌ gdil‑l, guludödcdëꞌ bönniꞌ gdödi bunách naꞌ, atiꞌ guluquel‑lëꞌë guiꞌ ladzquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Niꞌr gudxëꞌ yuguꞌ niꞌa nëꞌë bönniꞌ naꞌ rna bëꞌë, gnëꞌ: “Le nactë chnupáꞌa qui lni naꞌ, san bönniꞌ niꞌ bulidzaꞌ lequëꞌ, cutu glaquëꞌ lsacaꞌ djaquëꞌ lni quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gul‑tseajtscaꞌ gap nac laꞌ nöz len gul‑lídz yúguꞌtë nup tsajxácaꞌliꞌ niꞌ lid lni queëbiꞌ biꞌi quiaꞌ utság naꞌbiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Niꞌr gularujëꞌ niꞌa nëꞌë naꞌ, zjaquëꞌ gap nac laꞌ nöz, atiꞌ gulutubëꞌ yúguꞌtë nup niꞌ yajxácaꞌquëꞌ, yuguꞌ bönniꞌ dxiꞌa len bönniꞌ tuaꞌdöꞌ, atiꞌ ga naꞌ rac lni gdzaꞌr bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Catiꞌ gyaziëꞌ bönniꞌ naꞌ rna bëꞌë quië uyúëꞌ nup niꞌ nudubgac, niꞌ bléꞌinëꞌ tu bönniꞌ cutu nacuëꞌ lariꞌ dxiꞌa le bunödzjëꞌ quequëꞌ bönniꞌ nacuꞌë lni naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Niꞌr gudxëꞌ bönniꞌ naꞌ: “Böchaꞌa, ¿zoatsuꞌ ni len cutu nacuꞌ lariꞌ dxiꞌa bunödzjaꞌ quegac nup nacuáꞌ lni?” Bönniꞌ naꞌ buséyj ruꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Niꞌr gudxëꞌ nup naꞌ tun xchinëꞌ bönniꞌ naꞌ rna bëꞌë, gnëꞌ: “Gul‑gugaꞌ niꞌa nëꞌë bönniꞌ ni. Gul‑tsajchúꞌn‑nëꞌ niꞌl ga naꞌ röꞌ chul. Niꞌ cödxëꞌ len utíl‑l layëꞌë, lu yöl‑laꞌ ruhuiꞌni queëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Zian nup nulidzaꞌ, san nabábz nup laꞌrögac. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Niꞌr guluzë́ꞌë niꞌ bönniꞌ gdauꞌ fariseo naꞌ, atiꞌ glun xtídzaꞌquëꞌ lunëꞌ ga bi gnëꞌ Jesús quië gac luquíëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Quië lunëꞌ cni, gulasölëꞌë ga zoëꞌ Jesús laꞌquëꞌ bönniꞌ daꞌquëꞌ lequëꞌ len bönniꞌ daꞌquëꞌ Herodes, nup naꞌ glë Jesús: ―Bönniꞌ Usëdi, nö́zituꞌ ruꞌu didzaꞌ Liꞌ catëz nac len nac gdutë li ca rusëdnuꞌ le naqui queëꞌ Dios, len cutu ruiꞌ ladxuꞌu le taꞌná quiuꞌ bunách, le cutu rbequi xbeynuꞌ bunách ca nac le taꞌnáz bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gdixjöiꞌ netuꞌ. ¿Nacx runi liꞌ? ¿I run bayúdx o cutu run bayúdx quizxj laztuꞌ queëꞌ César, bönniꞌ yödz ziꞌtuꞌ naꞌ rna béꞌinëꞌ rëꞌu? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ráquibeꞌinëꞌ Jesús tëꞌnnëꞌ lubijëꞌ Lëꞌ didzaꞌ, atiꞌ gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ, ¿bizx quië ruiꞌliꞌ didzaꞌ le ruzóa nedaꞌ raꞌ guiꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gul‑luíꞌi nedaꞌ dumí le rguizxj lazliꞌ. Niꞌr gululuiꞌinëꞌ Lëꞌ tu dumí yödz Roma. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Nuzxa lahui zoa ni, len nuzxa lei zoa lëꞌi dumí ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tëꞌ Lëꞌ: ―Queëꞌ César naꞌ. Niꞌr Jesús gudxëꞌ lequëꞌ: ―Gul‑quizxjëꞌ César le naqui queëꞌ César, atiꞌ Dios le naqui queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Catiꞌ gulayönnëꞌ lë ni, gulubannëꞌ ca nac didzaꞌ dxiꞌa bubiꞌë Jesús, atiꞌ gulucaꞌnëꞌ Lëꞌ, zhuöjctëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Laꞌ dza niꞌz guladxinëꞌ ga zoëꞌ Jesús bönniꞌ gdauꞌ saduceo, nup naꞌ taꞌná cutu lubán nup chnatgac, atiꞌ gulanabnëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","taꞌnë́ꞌ: ―Bönniꞌ Usëdi, Moisés gnëꞌ: “Chquiꞌ gatiëꞌ bönniꞌ zoanu ngul queëꞌ, len nutu nu biꞌi queëꞌ zoabiꞌ, niꞌr biꞌi böchëꞌë bönniꞌ naꞌ ral‑laꞌ utság náꞌlenbiꞌ‑nu ngul queëꞌ, cui nit diꞌa dza queëꞌ bönniꞌ bö́chiꞌbiꞌ naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gulacuaꞌbiꞌ ga zoatuꞌ gadx biꞌi bönniꞌ nac bö́chiꞌcbiꞌ. Biꞌi ziꞌal naꞌ butság náꞌlenbiꞌ‑nu ngul, atiꞌ gúttëbiꞌ. Le nutu nu biꞌi queëbiꞌ zoabiꞌ, biꞌi buróp naꞌ butság náꞌlenbiꞌ‑nu ngul uzë́b queëbiꞌ biꞌi bö́chiꞌbiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lëzcaꞌ cni guc queëbiꞌ biꞌi buróp naꞌ, lencaꞌ queëbiꞌ biꞌi bunn, len laꞌ tuz ca guc quecbiꞌ igádxtëbiꞌ, glatbiꞌ yúguꞌtëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga budxtë gutnu caꞌ ngul naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Catiꞌ gdxin dza lubán nup chnatgac, ¿núzxalbiꞌ biꞌi gadx niꞌ gáquinu queëbiꞌ ngul naꞌ, le gulutság náꞌlenbiꞌ‑nu ngul naꞌ yúguꞌtëbiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Nachíxitsquiliꞌ lbiꞌiliꞌ le curéjniꞌliꞌ le nayúj lu guich laꞌy, len le cunúnbëꞌliꞌ yöl‑laꞌ huac queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Catiꞌ gdxin dza lubán nup chnatgac, cutur gac yöl‑laꞌ rzoalen ngul, len cutu lutság naꞌquëꞌ, san lacquëꞌ ca nacquëꞌ gbaz laꞌy queëꞌ Dios nacuꞌë yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ca naꞌ ral‑laꞌ lubán nup chnatgac, ¿naruꞌ cu nulábiniliꞌ lë naꞌ gudxczëꞌ lbiꞌiliꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Cni gnëꞌ: “Nedaꞌ nacaꞌ Dios queëꞌ Abraham len Dios queëꞌ Isaac, len Dios queëꞌ Jacob.” Dios naꞌ cutu naquëꞌ Dios quegac nup natgac tsaz, san naquëꞌ Dios quequëꞌ bönniꞌ ni nabanquëꞌ zal‑laꞌ glatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Catiꞌ gulayöni didzaꞌ ni bunách nacuáꞌ niꞌ, gulubannëꞌ ca nac lë naꞌ rusëdnëꞌ lequëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Catiꞌ gláquibeꞌinëꞌ bönniꞌ gdauꞌ fariseo ca benëꞌ Jesús, buseyjëꞌ rúꞌaquëꞌ bönniꞌ gdauꞌ saduceo, niꞌr guludubëꞌ yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tuëꞌ bönniꞌ nutsëꞌë ladjquëꞌ len nazëdëꞌ zxba queëꞌ Moisés, guꞌnnëꞌ siꞌ bëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Qui lë ni naꞌ gnabnëꞌ Jesús, rnëꞌ: ―Bönniꞌ Usëdi, ¿bizxal zxba queëꞌ Dios nac blau? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús rëꞌ lëꞌ: ―Gdxiꞌinuꞌ Xanuꞌ Dios gdu ladxuꞌu, len gdu icj ládxiꞌdaꞌu, lencaꞌ len gdu yöl‑laꞌ rejniꞌi quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Zxba ni nac blau len nactër zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Zxba naꞌ nac buróp, laꞌ tuz ca nac, len cni rna: “Gdxiꞌinuꞌ böchiꞌ lzaꞌu ca nadxíꞌi cuinuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chop zxba ni nac ga zön yúguꞌtë le rna bëꞌ zxba queëꞌ Dios, len yúguꞌtë le gulusëdnëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsal niꞌ nacuꞌë tsazxö́n bönniꞌ gdauꞌ fariseo naꞌ, Jesús gnabnëꞌ lequëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","rnëꞌ: ―¿Nacx runi lbiꞌiliꞌ queëꞌ Bönniꞌ naꞌ lëꞌ Cristo? ¿Nuzxa zxiꞌn naquëꞌ? Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Zxiꞌn xsoëꞌ David naquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Niꞌr Jesús rëꞌ lequëꞌ: ―¿Bizx quië naꞌ lëczëꞌ David bulidzëꞌ Lëꞌ, gnëꞌ: “Xanaꞌ”? Cni gnëꞌ catiꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios Böꞌ Laꞌy, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xanruꞌ Dios gudxëꞌ Xanaꞌ: “Gröꞌ cuit lëꞌa yubél, Catiꞌ gunraꞌ ga luzechu zxibgac lauꞌ nup cutaꞌleꞌi Liꞌ dxiꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chquiꞌ David naꞌ rnëꞌ queëꞌ naquëꞌ Xanëꞌ, ¿nacxcz nac, rnaliꞌ naquëꞌ zxiꞌn xsoëꞌ David? ");
INSERT INTO zsrNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nutu nu guc ubíꞌi didzaꞌ, atiꞌ ga gzu lau dza naꞌ, nutur nu burugui bi gnabi Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Niꞌr Jesús bë́ꞌlenëꞌ bunách nacuáꞌ niꞌ len yuguꞌ bönniꞌ usë́d queëꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Rëꞌ lequëꞌ: ―Nuhuazquëꞌ xlatjëꞌ Moisés, tuꞌsëdnëꞌ bunách yuguꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ tuꞌsëdi. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Qui lë ni naꞌ, gul‑gún yúguꞌtë le lëꞌ lbiꞌiliꞌ, san cutu gunliꞌ lbiꞌiliꞌ ca naꞌ tunëꞌ lequëꞌ, le tu le taꞌnë́ꞌ len yetú le tunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Le taꞌná béꞌinëꞌ bunách nac ca tu yuaꞌ ziꞌi le cusaquiꞌ nu guaꞌ, atiꞌ tuꞌguꞌë lei yen zxichjgac bunách, san lequëꞌ cutu tëꞌnnëꞌ lustsáꞌlenquëꞌ lei, clëg len tuz xbönniꞌ naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yúguꞌtë le tunëꞌ, tunëꞌ quië laꞌleꞌi lequëꞌ bunách, le tunëꞌ zxön le túguëꞌë yen naꞌquëꞌ len raꞌ xgaquëꞌ ga naꞌ nuzujquëꞌ tu le nayúj lu guich laꞌy, len tuꞌtunnëꞌ luzx lariꞌ nácuquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tëꞌnnëꞌ laꞌböꞌë ga nac latj blau ga naꞌ tuꞌdubëꞌ tahuëꞌ, lencaꞌ ga naꞌ nac latj blau lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lëzcaꞌ cni, tëꞌnnëꞌ lugáp lequëꞌ didzaꞌ ba zxön bunách gap nac laugac bunách, len tëꞌnnëꞌ lë lequëꞌ: “Padiux, bönniꞌ usëdi.” ");
INSERT INTO zsrNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’San lbiꞌiliꞌ, cutu ral‑laꞌ gunliꞌ ga nu guië lbiꞌiliꞌ: “Bönniꞌ usëdi”, le zoa tuz Nu nac Bönniꞌ Usëdi queëliꞌ, nedaꞌ, Cristo, atiꞌ yúguꞌtëliꞌ nacliꞌ bö́chiꞌliꞌ tuliꞌ yetuliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nutu nu guiëliꞌ luyú ni, cu gnaliꞌ: “Xuz”, le zoa tuz Nu nac Xuzliꞌ, zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Cutu gunliꞌ ga nu guië lbiꞌiliꞌ: “Xan”, le zoa tuz Nu nac Xanliꞌ, nedaꞌ, Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu nutsaꞌ ladjliꞌ nu run xchinliꞌ yezícaꞌrliꞌ, nu ni gactër blau ga zoaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chquiꞌ nu uzóa cuini latj blau, caꞌz ugáꞌn nu naꞌ, san nu nac nöxj ladxiꞌ, gac blau. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Ruzágaꞌliꞌ nöz zjaclen bunách laꞌdxín ga niꞌ rna bëꞌë Dios yehuaꞌ yubá. Laꞌ lbiꞌizliꞌ cutu saquiꞌ tsazliꞌ, len cutu ruiꞌliꞌ latj laꞌyáz nup tëꞌni laꞌyáz. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Rgualiꞌ lidxcnu ngul uzëbdauꞌ, len quië uluíꞌz tsahuiꞌ cuinliꞌ, xtsey rulidzliꞌ‑nëꞌ Dios. Qui lë ni naꞌ, zxöntër le grugu queëliꞌ sacaꞌ quiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Rdödliꞌ gdu lu nis zxön len gdu yödzlyú ni quië gunliꞌ ga tsej ladxëꞌë Dios tsazxö́n len lbiꞌiliꞌ tu bönniꞌ, len catiꞌ niꞌ chgzxáquiꞌliꞌ‑nëꞌ, runliꞌ ga nabágaꞌrëꞌ zxguiaꞌ ca lbiꞌiliꞌ, tsajtsuꞌë lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ. Nachúl lauliꞌ atiꞌ rë́ꞌniliꞌ uluiꞌiliꞌ nöz bunách. Cni nac queëliꞌ le rnaliꞌ: “Chquiꞌ bi rziꞌ lu nëꞌë bönniꞌ, rneynëꞌ gdauꞌ, cutu run bayúdx, san chquiꞌ gneynëꞌ oro dzöꞌ gdauꞌ, bayúdx gun.” ");
INSERT INTO zsrNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lbiꞌiliꞌ, bönniꞌ lau chul len cutaꞌyejniꞌi. ¿Bizxal nacr blau? ¿Naruꞌ oro naꞌ o gdauꞌ le run laꞌy oro naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lëzcaꞌ cni rnaliꞌ: “Chquiꞌ gneynëꞌ bcugu laꞌy bönniꞌ, cutu gun bayúdx, san chquiꞌ gneynëꞌ gun zxoa lahui, bayúdx gun.” ");
INSERT INTO zsrNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lbiꞌiliꞌ, nazidliꞌ len nachúl lauliꞌ. ¿Bizxal nacr blau? ¿Naruꞌ gun zxoa lahuiz o bcugu laꞌy naꞌ run laꞌy gun naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Qui lë ni naꞌ, chquiꞌ rneynëꞌ bcugu laꞌy bönniꞌ, rneynëꞌ lei lencaꞌ yúguꞌtë le dë lahuiz. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Lëzcaꞌ cni, chquiꞌ rneynëꞌ gdauꞌ bönniꞌ, rneynëꞌ lei lencaꞌ Dios, nunczëꞌ xlatjëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lëzcaꞌ cni, chquiꞌ rneynëꞌ yehuaꞌ yubá bönniꞌ, rneynëꞌ latj ga röꞌë rna bëꞌë Dios, lencaꞌ Lëczëꞌ Dios röꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Cni nac queëliꞌ le rguizxjliꞌ qui gdauꞌ tu cuia tsa tu chi cuia le rziꞌliꞌ qui xhueaj len qui guixiꞌ anís len qui comino laꞌ huagu, san rucaꞌnliꞌ le nacr blau le rna bëꞌ zxba queëꞌ Dios, cutu runliꞌ le nac tsahuiꞌ, len cutu ruhuechiꞌ ládxiꞌliꞌ lzaꞌliꞌ, len cutu réjlëꞌliꞌ‑nëꞌ Dios. Yuguꞌ lë ni run bayúdx gunliꞌ len lëz cutu ucaꞌnliꞌ yezicaꞌ lë naꞌ runliꞌ, rguizxjliꞌ qui gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lbiꞌiliꞌ, nachúl lauliꞌ len rë́ꞌniliꞌ uluiꞌiliꞌ nöz bunách. Ca naꞌ runliꞌ nac ca rudödliꞌ bdzadzdauꞌ le riꞌjliꞌ, rubíjgacliꞌ‑baꞌ bö́ꞌyudauꞌ, san riꞌjliꞌ‑baꞌ böaꞌ taꞌbíëꞌ‑baꞌ bönniꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Nacliꞌ ca zxígaꞌdauꞌ ríꞌijiliꞌ len yöꞌön ráhuiliꞌ. Rguibliꞌ le nuaꞌ cuit lëꞌi, san icj ládxiꞌdauꞌliꞌ nadzëꞌir yuguꞌ le rbanliꞌ len yuguꞌ le cunác tsahuiꞌ runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo lau chul. Ziꞌal gul‑quíb le nuaꞌ lu zxígaꞌdauꞌ len lu yöꞌön, gacliꞌ dxiꞌa lu icj ládxiꞌdauꞌliꞌ, quië gacliꞌ caꞌ dxiꞌa cuit lëꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi, lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Cni nac queëliꞌ le nacliꞌ ca yeru ba quegac nup chnatgac, le nacgac chguichdauꞌz cuit lëꞌi, len le nactë lach nalaꞌgac, san nadzë́ꞌigac dxit quegac nup chnatgac lencaꞌ yúguꞌtë le zgut. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lëzcaꞌ cni nacliꞌ lbiꞌiliꞌ. Le nactë lahuiz ruluíꞌ cuinliꞌ tsahuiꞌ laugac bunách, san icj ládxiꞌdauꞌliꞌ nadzëꞌiz yuguꞌ le ruluíꞌz tsahuiꞌ cuini, len le cunác runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Ruchisliꞌ lguitj qui ba gap nagáchiꞌquëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, len ruiꞌliꞌ lguitj gap nagáchiꞌgac bunách tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Lëzcaꞌ cni rnaliꞌ: “Laꞌnaruꞌ zoatuꞌ dza niꞌtë catiꞌ gulacuꞌë xuz xtauꞌtuꞌ, cutu guntuꞌ lequëꞌ tsazxö́n catiꞌ guludödcdëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Le rnaliꞌ cni, laꞌ lbiꞌizliꞌ runliꞌ lnaꞌ lau nacliꞌ zxiꞌn xsoagac nup niꞌ guludödi bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Cni nac, gdu ruspagaꞌ cuinliꞌ zxguiaꞌ naꞌ gulabaguëꞌë xuz xtauꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Lbiꞌiliꞌ, nacliꞌ ca yuguꞌ bël sniaꞌ len diꞌa dza quegac bël sniaꞌ. ¿Nacxcz ulaliꞌ lu le usacaꞌ ziꞌ lbiꞌiliꞌ lu guiꞌ gabíl? ");
INSERT INTO zsrNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Qui lë ni naꞌ, nedaꞌ gsölaꞌa queëliꞌ bönniꞌ luꞌë didzaꞌ uláz queëꞌ Dios, lencaꞌ bönniꞌ taꞌyejniꞌi, len yuguꞌ bönniꞌ usëdi. Yuguꞌ bönniꞌ ni, laꞌquëꞌ gdö́diliꞌ, len yelaꞌquëꞌ udaꞌliꞌ lëꞌi yag cruz, len yelaꞌquëꞌ quinliꞌ gap nac lu yuꞌu ga rudubliꞌ rusëdliꞌ queëꞌ Dios, len ulagliꞌ lequëꞌ tu yetú yödz. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cni gac, gbágaꞌliꞌ lbiꞌiliꞌ zxguiaꞌ qui yúguꞌtë rön quequëꞌ bönniꞌ tsahuiꞌ le glalj luyú, ga gdel‑laꞌ nu budödi Abel, bönniꞌ tsahuiꞌ, ga rdxintë nup guludödi Zacarías, zxiꞌnëꞌ Berequías, bönniꞌ naꞌ budö́diliꞌ‑nëꞌ gatsj lahuiꞌl ga dë gdauꞌ len ga dë bcugu laꞌy ga naꞌ tuꞌzéguiꞌquëꞌ‑baꞌ lahuëꞌ Dios böaꞌ bëdxdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Le nactë rëpaꞌ lbiꞌiliꞌ, yúguꞌtë lë ni laꞌbagaꞌ bunách nacuáꞌ dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Lëzcaꞌ cni gnëꞌ Jesús: ―Jerusalén, Jerusalén, lbiꞌiliꞌ naꞌ rudö́digacliꞌ‑nëꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios len ruládxiꞌgacliꞌ guiöj nup nasölëꞌë queëliꞌ Dios. Zian lzu guꞌndaꞌ utubaꞌ lbiꞌiliꞌ quiaꞌ, ca runbaꞌ yjëd, rutubbaꞌ zxan xilbaꞌ zxíꞌnbaꞌdauꞌ, san cutu gúꞌniliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gul‑yutscaꞌ, caꞌz ugáꞌn yuꞌu lidxliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cni gac, le rëpaꞌ lbiꞌiliꞌ, naꞌa su lau cutur gléꞌiliꞌ nedaꞌ catiꞌ gnarliꞌ: “Laꞌy naquëꞌ bönniꞌ naꞌ zëꞌë uláz queëꞌ Xanruꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Brujëꞌ nchil gdauꞌ Jesús, len tsal niꞌ ruzë́ꞌë niꞌ, gulabiguëꞌë ga zoëꞌ bönniꞌ usë́d queëꞌ, atiꞌ gululuiꞌinëꞌ Lëꞌ ca nacgac zöꞌö naguꞌugac liꞌaj gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Rléꞌitsaliꞌ yúguꞌtë lë ni? Le nactë rëpaꞌ lbiꞌiliꞌ, cutu caꞌ ugáꞌn ni guiöj nabagaꞌ lzëꞌi, le cugguíndj. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Catiꞌ niꞌ röꞌë Jesús ga nac lu Guiꞌa Ga Röꞌgac Yag Olivo, guladxinëꞌ bönniꞌ usë́d queëꞌ ga naꞌ zoëꞌ queëzëꞌ, len tëꞌ Lëꞌ: ―Gdixjöiꞌ netuꞌ, ¿batx lac lë ni, len bizxa gac bëꞌ dza huöduꞌ len dza udx qui yödzlyú ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑yú qui nadxi nu siꞌ yeꞌi lbiꞌiliꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","le djaquëꞌ zian bönniꞌ, siꞌ laquëꞌ ca leaꞌ nedaꞌ. Laꞌnë́ꞌ nacquëꞌ Cristo, len laꞌzíꞌ yéꞌinëꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Huayö́niliꞌ rac gdil‑l len le ruiꞌ didzaꞌ qui gdil‑l, san cutu guni lbiꞌiliꞌ baníg, le ral‑laꞌ lac yúguꞌtë lë ni, le cutu rdxini dza udx catiꞌ lacr lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Til‑l tu yödz len yetú yödz, atiꞌ tu ga nu rna bëꞌ len yetú ga nu rna bëꞌ. Latsj guidzhuë́ꞌ zxön len gac gbin, atiꞌ zian latj saꞌ rtit. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yúguꞌtë lë ni nacgac le laꞌzú lau yuguꞌ le laꞌzacaꞌ laꞌguíꞌi bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Niꞌr ludö́d lbiꞌiliꞌ bunách lu naꞌ nu usacaꞌ ziꞌ lbiꞌiliꞌ. Luzóa lbiꞌiliꞌ tslaꞌl yúguꞌtë bunách le daꞌliꞌ nedaꞌ, len ludöddëꞌ laꞌliꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Catiꞌ gac cni, gac chop ládxiꞌgac zian bunách, lucáꞌn nedaꞌ, len udö́d tu yetú lzëꞌi, len tu yetú uzóa lzëꞌi tslaꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Niꞌr luluíꞌ lauquëꞌ zian bönniꞌ taꞌzíꞌ yëꞌë, luluíꞌ cuinquëꞌ ca bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios, len laꞌzíꞌ yéꞌinëꞌ zian bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Szxöni luaꞌ döꞌ bunách, atiꞌ qui lë ni naꞌ cutur laꞌdxíꞌi böchiꞌ lzaꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nu gaqui tsaz queëꞌ Dios ga gdxintë dza udx, nu ni ulá. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Gdu yödzlyú gac lban qui didzaꞌ dxiꞌa ca rna bëꞌë Dios quië gac lnaꞌ lau qui laugac yúguꞌtë bunách gzaꞌa, atiꞌ niꞌr gdxin dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","’Nu uláb lë ni ral‑laꞌ uzejniꞌi ladxiꞌ. Gnëꞌ Daniel, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: “Tsaz latj laꞌy queëꞌ Dios le curléꞌinëꞌ Dios dxiꞌa, lë naꞌ rusnít.” Catiꞌ gléꞌiliꞌ gac cni, niꞌr nup nacuáꞌ luyú Judea ral‑laꞌ tsajzxundjgac zacaꞌ guíꞌadauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nu dxia cjuꞌul cutu gal‑laꞌ huötj tsajxíꞌ bi dë qui lu yuꞌu, san ral‑laꞌ gzxundjtë. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nu zoa ladj guixiꞌ, cutu gal‑laꞌ huöj tsajxíꞌ lariꞌ qui. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bicaꞌ bayechiꞌ ngul ziꞌa luzoanu biꞌidauꞌ quecnu, lencaꞌ ngul niꞌ tuꞌgádxiꞌnu‑biꞌ biꞌidauꞌ quecnu catiꞌ gdxin dza niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ cui gdxin dza niꞌ gzxundjliꞌ catiꞌ rac beoꞌ ziag o catiꞌ nac dza laꞌy, ");
INSERT INTO zsrNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","le laꞌzacaꞌ laꞌguiꞌitër bunách dza niꞌ ca gulazacaꞌ gulaguíꞌi bunách dza niꞌtë catiꞌ ziꞌa gutaꞌ gröꞌ yödzlyú, ga rdxintë naꞌa dza, len clëg dza ziꞌa zaꞌ cutu laꞌzacaꞌ laꞌguíꞌi cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Catiꞌ gdxin dza niꞌ, chquiꞌ Dios cutu cuequi lahuëꞌ quequëꞌ, nutu nu ulá, san cuequi lahuëꞌ quequëꞌ dza niꞌ, gáclenëꞌ nup gröczëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Niꞌr cutu tséjlëꞌliꞌ chquiꞌ nu gdxin queëliꞌ, len guië lbiꞌiliꞌ: “Gul‑yutscaꞌ, ni zoëꞌ Cristo”, o gna: “Niꞌ zoëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Luluíꞌ lauquëꞌ zian bönniꞌ taꞌzíꞌ yëꞌë, laꞌnë́ꞌ nacquëꞌ Cristo, o laꞌnë́ꞌ tuꞌë didzaꞌ uláz queëꞌ Dios. Lunëꞌ le lac bëꞌ len le lun ga lubani bunách, atiꞌ laꞌzíꞌ yéꞌinëꞌ nup gröczëꞌ Dios chquiꞌ hualaꞌzáquiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gul‑yutscaꞌ, chgudxczaꞌ lbiꞌiliꞌ yúguꞌtë lë ni zíꞌatël ca ziꞌa lac. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Qui lë ni naꞌ, cutu grujliꞌ chquiꞌ laꞌdxín queëliꞌ nup lë lbiꞌiliꞌ: “Gul‑yutscaꞌ, niꞌ zoëꞌ Cristo lu latj caꞌz.” Lëzcaꞌ cni, cutu tséjlëꞌliꞌ chquiꞌ laꞌná: “Gul‑yutscaꞌ, lu yuꞌu zoëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ca naꞌ rac catiꞌ ryëp yös ga rlen gbidz, len ruzeníꞌ ga rbia gbidz, lëzcaꞌ cni gac catiꞌ huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lactë cni, ca naꞌ taꞌná bunách: “Gátiꞌtëz ga dë tu le nat, niꞌ ludubczbaꞌ bëchláb.” ");
INSERT INTO zsrNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Gnëꞌ caꞌ Jesús: ―Töd yuguꞌ dza niꞌ catiꞌ laꞌzacaꞌ laꞌguíꞌi cni bunách, gchul gbidz, atiꞌ beoꞌ cutu gunn yeníꞌ qui. Laꞌguindjbaꞌ bölj luzxbá, atiꞌ laꞌzxíz le nalaꞌgac luzxbá dë yöl‑laꞌ huac quegac. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Niꞌr glaꞌ lahui luzxbá le gac bëꞌ huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, atiꞌ laꞌbö́dx yechiꞌ yúguꞌtë bunách yödzlyú ni, catiꞌ laꞌleꞌi nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, zuzáꞌa lu böaj luzxbá, dë lu naꞌa yöl‑laꞌ uná bëꞌ zxön len yöl‑laꞌ yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Niꞌr gsö́laꞌgacaꞌ‑nëꞌ gbaz laꞌy quiaꞌ. Lucödxëꞌ zidzj trompeta, atiꞌ lutubëꞌ nup nabö́aꞌ quiaꞌ, nacuáꞌ gdap laꞌtë yödzlyú len yúguꞌtë latj zxan luzxbá. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Gul‑zejniꞌi ládxiꞌliꞌ le rusëdi lbiꞌiliꞌ le rac qui yag higo. Catiꞌ taꞌlén zxuzaꞌ nëꞌi huëꞌndauꞌ len chrubía xlaguiꞌ yuldauꞌ, nö́ziliꞌ chzoa gdxin dza gba. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lëzcaꞌ cni, catiꞌ gléꞌiliꞌ tac yúguꞌtë lë ni, gnö́ziliꞌ chzoa gdxin dza udx naꞌ len chrdzag lahui. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Le nactë rëpaꞌ lbiꞌiliꞌ, yúguꞌtë lë ni lac zíꞌatël ca lat bunách nacuáꞌ dza niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Huadö́d quegac luzxbá len luyú ni, san yuguꞌ xtidzaꞌa cutu laꞌdö́d caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Catiꞌ gdxin dza niꞌ nutu nu nözi. Cutu nözcnëꞌ gbaz laꞌy queëꞌ Dios nacuꞌë yehuaꞌ yubá len cutu nözdaꞌ nedaꞌ, Zxiꞌnëꞌ Dios, san tuzëꞌ Dios Xuz nöznëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ca naꞌ guc dza niꞌ catiꞌ niꞌ zoëꞌ Noé, lëzcaꞌ cni gac catiꞌ huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yuguꞌ dza niꞌ zíꞌatël ca ziꞌa gdxin nis guiöj le busnít yödzlyú, gliꞌj glahuëꞌ, gulutság naꞌquëꞌ len guludödëꞌ zxiꞌnquëꞌ lu yöl‑laꞌ rutság naꞌ ga bdxintë dza gyaziëꞌ Noé lëꞌi barco zxön niꞌ benëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","len cutu gláquibeꞌinëꞌ catiꞌ bdxintë nis guiöj le busnít yödzlyú atiꞌ gulanitiëꞌ yúguꞌtëꞌ. Lëzcaꞌ cni gac catiꞌ ziꞌa huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, nutu nu gáquibeꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dza huödaꞌ laꞌcuꞌë chopëꞌ bönniꞌ ladj guixiꞌ. Tuëꞌ uchëꞌa‑nëꞌ quiaꞌ atiꞌ yetúëꞌ ucaꞌnaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Laꞌcuaꞌnu chopnu ngul nacuaꞌnu huëtu. Tunu uchëꞌa‑nu quiaꞌ, atiꞌ yetunu ucaꞌnaꞌ‑nu. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Gul‑spán ládxiꞌliꞌ le cutu nö́ziliꞌ bizxa dza huödaꞌ nedaꞌ, Xanliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naꞌa, gul‑tsejniꞌi lë ni. Laꞌnaruꞌ nöznëꞌ xan yuꞌu bizxa dza guidëꞌ gban, huanë́ꞌë yël len cutu guꞌë latj nu quidj zöꞌö quië cuan le dzöꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Qui lë ni naꞌ, gul‑spán ládxiꞌliꞌ caꞌ lbiꞌiliꞌ, le huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, tu dza cutu nuzóa icjliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gnëꞌ caꞌ Jesús: ―¿Nuzxa caz bönniꞌ huen dxin naquëꞌ gdu len réjniꞌnëꞌ, bönniꞌ huen dxin naꞌ, xanëꞌ cuꞌë lu nëꞌë bunách nacuáꞌ lidxëꞌ quië guꞌë le lágugac catiꞌ gdxin dza? ");
INSERT INTO zsrNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bicaꞌ ba bönniꞌ huen dxin naꞌ naquëꞌ gdu, bönniꞌ naꞌ, catiꞌ udxinëꞌ xanëꞌ, duxaquëꞌ lëꞌ cni runëꞌ le nudödëꞌ xanëꞌ lu nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Le nactë rëpaꞌ lbiꞌiliꞌ, yúguꞌtë le dë queëꞌ xanëꞌ, udödëꞌ lu nëꞌë bönniꞌ huen dxin naꞌ runëꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Chquiꞌ huöaquëꞌ huiaꞌdöꞌ bönniꞌ huen dxin queëꞌ len saꞌ ladxëꞌë, gnëꞌ: “Huadzeynëꞌ xanaꞌ, cutu huödtëꞌ”, ");
INSERT INTO zsrNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","len chquiꞌ su lahuëꞌ gundëꞌ ziꞌ bönniꞌ túnlenëꞌ lëꞌ tsazxö́n dxin, len su lahuëꞌ caꞌ guiꞌj gágulenëꞌ nup taꞌzudxi, ");
INSERT INTO zsrNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","niꞌr huödëꞌ xanëꞌ bönniꞌ huen dxin naꞌ tu dza catiꞌ cuzóëꞌ rbözëꞌ o tu yël cutu ráquinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Niꞌr xanëꞌ naꞌ usacaꞌ ziꞌtsquëꞌ bönniꞌ huen dxin naꞌ len gunëꞌ ga gac queëꞌ ca naꞌ ral‑laꞌ gac quegac nup tuꞌluíꞌz tsahuiꞌ cuingac. Niꞌr cödx yechëꞌë len utíl‑l layëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Gnëꞌ caꞌ Jesús: ―Ca gac quegac nup ral‑laꞌ laꞌyáz ga rna bëꞌë Dios yehuaꞌ yubá nac ca guc quecbiꞌ chibiꞌ biꞌi ngul raꞌbandauꞌ. Gulaziꞌbiꞌ le nuaꞌgac guiꞌ quecbiꞌ, atiꞌ gularujbiꞌ tsajtsagcbiꞌ bönniꞌ utság nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gáyuꞌbiꞌ naccbiꞌ biꞌi cutaꞌyejniꞌi san yegáyuꞌbiꞌ nasínaꞌcbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gulaziꞌbiꞌ le nuaꞌgac guiꞌ quecbiꞌ biꞌi ngul cutaꞌyejniꞌi naꞌ san cutu gluaꞌbiꞌ yelatiꞌ za regui. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gluaꞌbiꞌ za regui lu bö́gaꞌdauꞌ quecbiꞌ biꞌi sinaꞌ naꞌ len le nuaꞌgac guiꞌ quecbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Le gdzeynëꞌ bönniꞌ utság nëꞌë, gdöd yël laucbiꞌ len glástëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Catiꞌ bdxin gdu ladxiꞌ yël, byön chiꞌi nu rnë zidzj, rna: “Chzëꞌë bönniꞌ utság nëꞌë. Gul‑rúj tsajtsagliꞌ‑nëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Niꞌr gulayasbiꞌ yúguꞌtëbiꞌ biꞌi ngul naꞌ, atiꞌ gulupaꞌbiꞌ le nuaꞌgac guiꞌ quecbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gluiꞌbiꞌ didzaꞌ biꞌi cutaꞌyejniꞌi naꞌ, glëbiꞌ yuguꞌ biꞌi sinaꞌ naꞌ: “Gul‑gúnn queëtuꞌ látiꞌdauꞌ za regui queëliꞌ le tuꞌúl le nuaꞌgac guiꞌ queëtuꞌ ni.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Gulubiꞌibiꞌ didzaꞌ biꞌi sinaꞌ naꞌ, gulanabiꞌ: “Cutu gac, le cutu bi ugáꞌn queëtuꞌ len queëliꞌ. Gul‑tsejtscaꞌ ga rdaꞌu za regui, tsjö́ꞌuliꞌ queëliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tsal niꞌ zjacbiꞌ zajxiꞌcbiꞌ lei, bdxinëꞌ bönniꞌ utság nëꞌë. Gulayázlentëbiꞌ lëꞌ ga naꞌ rac lni qui utság naꞌ biꞌi naꞌ nacuaꞌbiꞌ sinaꞌ taꞌbözbiꞌ lëꞌ, atiꞌ laꞌ gyeyjtë yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gdöd niꞌ guladxinbiꞌ niꞌ yezícaꞌrbiꞌ biꞌi ngul raꞌbandauꞌ naꞌ, atiꞌ gululidzbiꞌ‑nëꞌ, gulanabiꞌ: “Xan, Xan, bsalj queëtuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lëꞌ bubiꞌë didzaꞌ, rnëꞌ: “Le nactë rëpaꞌ lbiꞌiliꞌ, cutu núnbëꞌa lbiꞌiliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Gul‑spán ládxiꞌliꞌ, le cutu nö́ziliꞌ bizxa dza o bizxa yël huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gnëꞌ caꞌ Jesús: ―Ca gun Nu naꞌ rna bëꞌ yehuaꞌ yubá nac ca benëꞌ tu bönniꞌ, chzoa tsijëꞌ ziꞌtuꞌ. Bulidzëꞌ yuguꞌ bönniꞌ huen dxin queëꞌ len gluꞌë lu naꞌquëꞌ yuguꞌ le dë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tuëꞌ bönniꞌ huen dxin naꞌ, gluꞌë lu nëꞌë gayuꞌ dumí zacaꞌ, len yetúëꞌ gluꞌë lu nëꞌë chop dumí zacaꞌ. Yetúëꞌ gluꞌë caꞌ lu nëꞌë tu dumí zacaꞌ. Tu tuëꞌ gluꞌë lu naꞌquëꞌ tsca hueaj le laꞌzáquiꞌnëꞌ. Niꞌr laꞌ gzaꞌatëꞌ ga nac ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Gyijëꞌ bönniꞌ huen dxin naꞌ gzxiꞌë gayuꞌ dumí zacaꞌ naꞌ, len yajtíljlenëꞌ lei yegayuꞌ dumí zacaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lëzcaꞌ cni, bönniꞌ naꞌ gzxiꞌë chop dumí naꞌ, yajtíljlenëꞌ lei yechóp caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bönniꞌ naꞌ gzxiꞌë tu dumí gyijëꞌ len yajchöꞌnëꞌ lu yu, atiꞌ lu yu niꞌ bucachëꞌë dumí queëꞌ xanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Catiꞌ chgdzey, budxinëꞌ xanquëꞌ bönniꞌ huen dxin naꞌ, atiꞌ bugáꞌnlenëꞌ lequëꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ga gzu lau bdxintëꞌ bönniꞌ naꞌ gzxiꞌë gayuꞌ dumí zacaꞌ naꞌ, len zunuꞌë yegayuꞌ dumí caꞌ, atiꞌ rëꞌ xanëꞌ: “Xan, gayuꞌ dumí gluꞌu lu naꞌa. Ni dë yegayuꞌ dumí caꞌ yajtíljlenaꞌ lei.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Xanëꞌ naꞌ rëꞌ lëꞌ: “Nac dxiꞌa. Nacuꞌ huen dxin gdu. Tsáhuiꞌdauꞌ benuꞌ catiꞌ ni dë lu naꞌu látiꞌdauꞌz. Naꞌa szxö́nitër cuꞌa lu naꞌu. Gyaz ga zoaꞌ, udzíjilennuꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gdöd niꞌ bdxinëꞌ caꞌ bönniꞌ huen dxin naꞌ gzxiꞌë chop dumí zacaꞌ, rnëꞌ: “Xan, chop dumí gluꞌu lu naꞌa. Ni dë yechóp dumí caꞌ yajtíljlenaꞌ lei.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Niꞌr xanëꞌ naꞌ rëꞌ lëꞌ: “Nac dxiꞌa. Nacuꞌ huen dxin gdu. Tsáhuiꞌdauꞌ benuꞌ catiꞌ ni dë lu naꞌu látiꞌdauꞌz. Naꞌa, szxö́nitër cuꞌa lu naꞌu. Gyaz ga zoaꞌ, udzíjilennuꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Niꞌr catiꞌ bdxinëꞌ bönniꞌ huen dxin naꞌ gzxiꞌë tu dumí zacaꞌ naꞌ, rnëꞌ: “Xan, nözdaꞌ nacuꞌ bönniꞌ bizxj, le rlapuꞌ ga cutu guzuꞌ, len rutubuꞌ ga cutu bchiljuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Qui lë ni naꞌ gúdxidaꞌ liꞌ, atiꞌ gyijaꞌ, yajcachaꞌa dumí quiuꞌ lu yu. Ni dë naꞌa le naqui quiuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Niꞌr bubiꞌë didzaꞌ xanëꞌ, rëꞌ lëꞌ: “Nacuꞌ huen dxin cunác tsahuiꞌ len zxhuëd. Nözcznuꞌ rlapaꞌ ga cutu guzaꞌ len rutubaꞌ ga cutu bchiljaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Qui lë ni naꞌ, dxiꞌar gac quiuꞌ laꞌnaruꞌ bunödzjuꞌ dumí quiaꞌ lu naꞌquëꞌ bönniꞌ lugunëꞌ lei dxin, laꞌguíljlenëꞌ lei yelatiꞌ, quië catiꞌ huödaꞌ nedaꞌ, uziꞌa le naqui quiaꞌ len icji caꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Niꞌr xanëꞌ naꞌ gudxëꞌ nup nacuáꞌ niꞌ: “Gul‑cúa dumí naꞌ dë lu nëꞌë bönniꞌ ni, len gul‑cúꞌu lu nëꞌë bönniꞌ naꞌ dë queëꞌ chi dumí.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nútiꞌtëz nu rugún dxiꞌa dxin le dë qui, zoa nu unö́dzj queëꞌ yelatiꞌ, atiꞌ gataꞌ queëꞌ szxöni, san nu naꞌ cutu rugún dxiꞌa dxin le dë qui, laꞌz dui le dë qui gdua. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naꞌa, bönniꞌ huen dxin cunác tsahuiꞌ ni, gul‑tsajchúꞌn‑nëꞌ niꞌl ga nac chul. Niꞌ cödx yechëꞌë len utíl‑l layëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gnëꞌ caꞌ Jesús: ―Catiꞌ niꞌ huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, duná bëꞌa, atiꞌ dzagquëꞌ nedaꞌ yúguꞌtë gbaz laꞌy quiaꞌ, niꞌr cöꞌa latj tsahuiꞌ quiaꞌ, ga naꞌ cuequi xbeydaꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ludúb dëra lahuaꞌ nedaꞌ bunách yödzlyú ni, atiꞌ ucuꞌa lequëꞌ tslaꞌa hueaj ca runëꞌ bönniꞌ uyú böꞌcuꞌ zxilaꞌ, rucuꞌë‑baꞌ tslaꞌa hueajbaꞌ yuguꞌ chivo len yuguꞌ böꞌcuꞌ zxilaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yuguꞌ böꞌcuꞌ zxilaꞌ naꞌ ucuꞌë‑baꞌ cuit lëꞌë yubél, atiꞌ yuguꞌ chivo naꞌ ucuꞌë‑baꞌ cuit lëꞌë yögl. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Niꞌr, nedaꞌ, bönniꞌ uná bëꞌ, gyëpaꞌ nup nacuáꞌ cuit lëꞌa yubél, gniaꞌ: “Gul‑dá ga zoaꞌ, lbiꞌiliꞌ bubijëꞌ lbiꞌiliꞌ quizi queëꞌ Xuzaꞌ. Naqui queëliꞌ latj ga naꞌ rna bëꞌë, lë naꞌ bupë́ꞌë queëliꞌ dza niꞌtë catiꞌ niꞌ benëꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cni naqui queëliꞌ le gdunaꞌ, atiꞌ bennliꞌ le gdahuaꞌ. Gbidxaꞌ nis, atiꞌ bennliꞌ le guꞌa. Gucaꞌ ca bönniꞌ rda ziꞌtuꞌ, atiꞌ gluꞌliꞌ nedaꞌ lidxliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Byadzj le gacuaꞌ, atiꞌ bugáculiꞌ nedaꞌ le ráculiꞌ. Güiꞌidaꞌ, atiꞌ duyuliꞌ nedaꞌ. Gyuꞌa lidx guia, atiꞌ duyuliꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Niꞌr lubiꞌë didzaꞌ bönniꞌ tsahuiꞌ naꞌ, lëꞌ nedaꞌ: “Xan, ¿batx bléꞌituꞌ Liꞌ gdunuꞌ atiꞌ bugágutuꞌ Liꞌ? ¿Batx gbidxuꞌ atiꞌ benntuꞌ le guꞌu? ");
INSERT INTO zsrNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Batx bléꞌituꞌ Liꞌ gdauꞌ ziꞌtuꞌ atiꞌ gluꞌtuꞌ Liꞌ lidxtuꞌ? ¿Batx byadzj le gacuꞌ atiꞌ bugácutuꞌ Liꞌ le rácutuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Batx bléꞌituꞌ Liꞌ güiꞌinuꞌ o gyuꞌu lidx guia atiꞌ duyutuꞌ Liꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ubiꞌa didzaꞌ nedaꞌ, bönniꞌ uná bëꞌ, gyëpaꞌ lequëꞌ: “Le nactë rëpaꞌ lbiꞌiliꞌ, le benliꞌ cni queëꞌ nu bönniꞌ bö́chaꞌadauꞌ ni, zal‑laꞌ naquëꞌ bönniꞌ caꞌz, quiaꞌ nédaꞌczaꞌ benliꞌ caꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Niꞌr gyëpaꞌ nup nacuáꞌ cuit lëꞌa yögl, gniaꞌ: “Gul‑cuít ga zoaꞌ, lbiꞌiliꞌ naꞌ nabágaꞌliꞌ zxguiaꞌ, tsajtsazliꞌ lu guiꞌ cutu ul, lë naꞌ bupë́ꞌë Dios qui tuꞌ xöhuiꞌ len quegac gbaz daꞌgac lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cni gac queëliꞌ le gdunaꞌ, atiꞌ cutu bennliꞌ le gahuaꞌ. Gbidxaꞌ nis, atiꞌ cutu bennliꞌ le guiꞌjaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gucaꞌ ca bönniꞌ rda ziꞌtuꞌ, atiꞌ cutu gluꞌliꞌ nedaꞌ lidxliꞌ. Byadzj le gacuaꞌ, atiꞌ cutu bugáculiꞌ nedaꞌ le ráculiꞌ. Güiꞌidaꞌ lencaꞌ gyuꞌa lidx guia, atiꞌ cutu duyuliꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Niꞌr laꞌná caꞌ nup naꞌ, lë nedaꞌ: “Xan, ¿batx bléꞌituꞌ Liꞌ gdunuꞌ, o gbidxuꞌ, o gucuꞌ ca bönniꞌ rda ziꞌtuꞌ, o byadzj le gacuꞌ, o güiꞌinuꞌ, o gyuꞌu lidx guia, atiꞌ cutu gúclentuꞌ Liꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Niꞌr ubiꞌa didzaꞌ nedaꞌ, bönniꞌ uná bëꞌ, gyëpaꞌ lequëꞌ: “Le nactë rëpaꞌ lbiꞌiliꞌ, le cutu bi benliꞌ qui tu nu nutsaꞌ ladj nup nacuáꞌ ni, zal‑laꞌ nac caꞌz nu naꞌ, cutu bi benliꞌ quiaꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Niꞌr bunách tuaꞌdöꞌ naꞌ laꞌ tsajtsázgactë ga niꞌ laꞌzacaꞌ laꞌguiꞌitecz, san bunách tsahuiꞌ niꞌ gataꞌ yöl‑laꞌ naꞌbán gdu quegac. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Catiꞌ budx bëꞌë yuguꞌ didzaꞌ ni Jesús, gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","rnëꞌ: ―Nö́ziczliꞌ yechóp dza gdxin Lni Pascua, atiꞌ dza naꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, ludödëꞌ nedaꞌ lu naꞌgac nup ludáꞌ nedaꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Niꞌr guladxinëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi len bönniꞌ gul tuꞌzéjniꞌnëꞌ bunách judío, guludubëꞌ ga nac löꞌa lidx bxuz blau, lëꞌ Caifás. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Niꞌ glun xtídzaꞌquëꞌ laꞌzönëꞌ Jesús, lu yöl‑laꞌ rziꞌ yëꞌ quequëꞌ, quië ludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Taꞌnë́ꞌ: ―Cutu gunruꞌ lë ni dza lni, qui nadxi lun rusbö́ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Catiꞌ niꞌ zoëꞌ Jesús lu yödz Betania lu yuꞌu lidxëꞌ Simón, bönniꞌ naꞌ güiꞌinëꞌ huëꞌ nudzuꞌ ruzö́d, ");
INSERT INTO zsrNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bdxinnu cúdzuꞌlëꞌ Jesús tu ngul, nuaꞌnu tu bö́gaꞌdauꞌ náquini guiöj zacaꞌ, len yudz tu le rlaꞌ zxix le zacaꞌ szxöni, atiꞌ gluꞌnu lei icjëꞌ Jesús catiꞌ niꞌ röꞌë rahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Catiꞌ gulaléꞌinëꞌ lë ni bönniꞌ usë́d queëꞌ Jesús, gulaleynëꞌ, taꞌnë́ꞌ: ―¿Bizx quië raqui ditj lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Guc nu gutiꞌ lë ni len siꞌ dumí zian quië gáclenruꞌ bunách yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Catiꞌ byönnëꞌ lë ni Jesús, rëꞌ lequëꞌ: ―¿Bizx quië rnëliꞌ queënu ngul ni? Dxiꞌa nac le bennu quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Laꞌcuáꞌlentecz lbiꞌiliꞌ bunách yechiꞌ, san nedaꞌ cutu ugáꞌnlenteczaꞌ libiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Le bennu ngul ni, gluꞌnu nedaꞌ le rlaꞌ zxix ni, nac le rupaꞌnu nedaꞌ quië dza ggachaꞌa yeru ba. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Le nactë rëpaꞌ lbiꞌiliꞌ, gátiꞌtëz yödzlyú ga gac lban qui didzaꞌ dxiꞌa ni, lëzcaꞌ laꞌguixjöꞌ bunách le bennu quiaꞌ ngul ni quië nu tsajnéy lënu. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Niꞌr gyijëꞌ ga naꞌ nacuꞌë bxuz uná bëꞌ Judas Iscariote, bönniꞌ dzaguëꞌ chinnuëꞌ naꞌ daꞌquëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","len gudxëꞌ lequëꞌ: ―¿Bizxa gunnliꞌ quiaꞌ chquiꞌ nedaꞌ udödaꞌ‑nëꞌ Jesús lu naꞌliꞌ? Gulugáꞌnlenëꞌ lëꞌ tsahuiꞌ luꞌë lëꞌ chi uruáꞌ dumí plata. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Niꞌr gzu lahuëꞌ Judas naꞌ rzu rböꞌë udödëꞌ Jesús lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Catiꞌ nac dza rzu lau lni quequëꞌ bönniꞌ judío catiꞌ tahuëꞌ yöt xtil cunazíꞌ xnëꞌi, gulabiguëꞌë ga zoëꞌ Jesús bönniꞌ usë́d queëꞌ len tëꞌ Lëꞌ: ―¿Gazx rëꞌnnuꞌ tsajpaꞌtuꞌ queëruꞌ gáguruꞌ‑baꞌ böꞌcuꞌ zxílaꞌdauꞌ dzöꞌ Lni Pascua? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús rëꞌ lequëꞌ: ―Gul‑tseajtscaꞌ yödz niꞌ ga naꞌ zoëꞌ tu bönniꞌ len gul‑guië́ꞌë: “Bönniꞌ rusëdnëꞌ netuꞌ rnëꞌ: Chzaꞌ gal‑laꞌ dza quiaꞌ. Lu yuꞌu lidxuꞌ gágulengacaꞌ‑nëꞌ bönniꞌ usë́d quiaꞌ böꞌcuꞌ zxílaꞌdauꞌ dzöꞌ Lni Pascua.” ");
INSERT INTO zsrNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Niꞌr glunëꞌ bönniꞌ usë́d queëꞌ ca naꞌ gna béꞌinëꞌ lequëꞌ Jesús, atiꞌ gulupë́ꞌë niꞌ le lahuëꞌ dzöꞌ Lni Pascua. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Catiꞌ chgdzöꞌ dza naꞌ, Jesús grö́ꞌlenëꞌ idxínnutëꞌ bönniꞌ usë́d queëꞌ tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tsal niꞌ tahuëꞌ, Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, tu nu nutsaꞌ ladjliꞌ ni udö́d nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Niꞌr guluhuiꞌni ládxiꞌquëꞌ, len gulanabnëꞌ Jesús tu tuzëꞌ, taꞌnë́ꞌ: ―Xan, ¿naruꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Bönniꞌ ni rnëꞌ nëꞌë tsazxö́n len naꞌa lu yöꞌön, bönniꞌ ni udödëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Le nactë nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, huayijaꞌ ga gatiaꞌ ca naꞌ nayúj lu guich laꞌy ca ral‑laꞌ gac quiaꞌ, san bicaꞌ bayechiꞌ nu naꞌ udö́d nedaꞌ gatiaꞌ. Dxiꞌar gac queëꞌ bönniꞌ naꞌ laꞌ cuguljëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Niꞌr bubiꞌë didzaꞌ Judas, bönniꞌ naꞌ udödëꞌ Jesús, rnëꞌ: ―Bönniꞌ Usëdi, ¿naruꞌ nedaꞌ? Jesús rëꞌ lëꞌ: ―Ja, liꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsal niꞌ tahuëꞌ, gdel‑lëꞌë yöt xtil Jesús len gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ lei len bunödzjëꞌ quequëꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Gul‑síꞌ, gul‑gagu. Lë ni le nayáꞌ nabanaꞌ. Ca benaꞌ qui yöt xtil ni ruluíꞌ ca gac qui gdu ca nayáꞌ nabanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gdel‑lëꞌë caꞌ tu zxígaꞌdauꞌ len gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr bunödzjëꞌ caꞌ quequëꞌ, rnëꞌ: ―Gul‑guiꞌaj yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Lë ni ruluíꞌ ca nac xchönaꞌ le run tsutsu didzaꞌ cub rucáꞌn tsahuiꞌ. Xchönaꞌ naꞌ glalj niꞌa quegac bunách zian quië gac unít lahuëꞌ Dios yuguꞌ dul‑laꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Rëpaꞌ caꞌ lbiꞌiliꞌ, cutur guiꞌjaꞌ xisi le rbia lba uva ni catiꞌ gdxinr dza niꞌ guíꞌjlenaꞌ lbiꞌiliꞌ tu le cub ga niꞌ rna bëꞌë Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Catiꞌ budx glul‑lëꞌ yöl‑laꞌ ba queëꞌ Dios, yjaquëꞌ lu Guiꞌa Ga Röꞌgac Yag Olivo. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Niꞌr Jesús rëꞌ lequëꞌ: ―Yúguꞌtëliꞌ gac chop ládxiꞌliꞌ, ucaꞌnliꞌ nedaꞌ naꞌa dzöꞌ ni, le nayúj lu guich laꞌy ca gac quiaꞌ, rna: “Gunaꞌ ga gatiëꞌ Bönniꞌ Uyú Böꞌcuꞌ Zxilaꞌ, atiꞌ láslasbaꞌ böꞌcuꞌ zxilaꞌ naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Catiꞌ ubanaꞌ lu yöl‑laꞌ gut, niꞌr tsijaꞌ tsajnöraꞌ lauliꞌ zacaꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Niꞌr bubiꞌë didzaꞌ Pedro, rëꞌ Jesús: ―Zal‑laꞌ lac chop ládxiꞌquëꞌ, lucaꞌnëꞌ Liꞌ yúguꞌtëꞌ, nedaꞌ cutu gac chop ladxaꞌa, cutu ucaꞌnaꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús gudxëꞌ lëꞌ: ―Le nactë rëpaꞌ liꞌ, naꞌa dzöꞌ ni, catiꞌ ziꞌa cödxlbaꞌ zxiꞌn druz, liꞌ chgnauꞌ tsonn lzu cutu núnbëꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Niꞌr Pedro gudxëꞌ Jesús: ―Zal‑laꞌ gátlenteaꞌ Liꞌ, cutu caꞌ gniaꞌ cutu núnbëꞌa Liꞌ. Lëzcaꞌ cni gulanë́ꞌ yúguꞌtë bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Niꞌr Jesús bdxínlenëꞌ lequëꞌ laꞌ yël Getsemaní, atiꞌ gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ naꞌ, rnëꞌ: ―Gul‑cöꞌtscaꞌ ni tsal tsijaꞌ yelatiꞌ niꞌl, tsajlidzaꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús bchëꞌë Pedro len gropëꞌ zxiꞌnëꞌ Zebedeo, atiꞌ gzu lahuëꞌ ruhuiꞌnnëꞌ len rsëbi ladxëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Ruhuiꞌni ladxaꞌa len huatczaꞌ lu yöl‑laꞌ rsëbi ladxiꞌ. Gul‑gáꞌn ni len gul‑náꞌ yël tsazxö́n len nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gdödëꞌ Jesús yelátiꞌdauꞌ niꞌl, atiꞌ niꞌ byechuëꞌ. Butság lahuëꞌ lyu len bulidzëꞌ Dios, gnëꞌ: ―Xuzaꞌ, chquiꞌ huac, ben ga cugún bayúdx sacaꞌ quiꞌa lë ni, san clëg ca rëꞌndaꞌ nedaꞌ, san ca rëꞌnnuꞌ Liꞌ gunuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Catiꞌ budxinëꞌ Jesús ga naꞌ nacuꞌë bönniꞌ usë́d queëꞌ, yajxaquëꞌë lequëꞌ tasiëꞌ, atiꞌ rëꞌ Pedro: ―¿Naruꞌ cu guctsa gnáꞌlenuꞌ nedaꞌ tsazxö́n yël tu chiꞌitëz? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gul‑náꞌ yël len gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ gáclenëꞌ lbiꞌiliꞌ, cui güiꞌliꞌ latj siꞌ bëꞌ lbiꞌiliꞌ le xöhuiꞌ Satanás tuꞌ xöhuiꞌ. Böꞌ nacczliꞌ nasínaꞌtecz, san lu yöl‑laꞌ bunáchz queëliꞌ nacuídiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Niꞌr gyijëꞌ Jesús le buróp lzu len bulidzëꞌ Dios, rnëꞌ: ―Xuz, chquiꞌ cugác gunuꞌ ga cutu sacaꞌ quiꞌa lë ni, ben ca rdzag ladxuꞌu Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Catiꞌ böjëꞌ, leyúbl duxaquëꞌë lequëꞌ tasiëꞌ le nadö́dr yël yöj lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Niꞌr bucaꞌnëꞌ lequëꞌ Jesús, atiꞌ gyijëꞌ leyúbl len bulidzëꞌ Dios le bunn lzu, len tuz ca gnëꞌ ziꞌal rnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Leyúbl böjëꞌ ga naꞌ nacuꞌë bönniꞌ usë́d queëꞌ len rëꞌ lequëꞌ: ―¿Rástsaliꞌ naꞌa, len ruziꞌtsa ládxiꞌliꞌ? Gul‑yutscaꞌ, chbudzág lau. Nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, chnadödaꞌ lu naꞌquëꞌ bönniꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gul‑tsás, huayejruꞌ. Gul‑yutscaꞌ, chbdxinëꞌ ni bönniꞌ naꞌ rudödëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tsal niꞌ ruꞌë didzaꞌ ni Jesús, laꞌ bdxintëꞌ niꞌ Judas, bönniꞌ nabáblenëꞌ idxínnutëꞌ naꞌ, atiꞌ dzagquëꞌ lëꞌ bönniꞌ zian, nuaꞌquëꞌ guia tuchiꞌ len yuguꞌ yagdauꞌ. Nasö́laꞌquëꞌ lequëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzéjniꞌnëꞌ bunách judío. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, bönniꞌ naꞌ rudödëꞌ Jesús, chbuluiꞌinëꞌ lequëꞌ tu le gunëꞌ le gac bëꞌ nu nac Jesús, gnëꞌ: ―Bönniꞌ naꞌ utság lahuaꞌ‑nëꞌ, Lëꞌ naꞌ Jesús. Gul‑sönëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Niꞌr gbiguëꞌë Judas ga naꞌ zoëꞌ Jesús, rnëꞌ: ―Padiux, Bönniꞌ Usëdi. Niꞌr laꞌ butság lautëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús rëꞌ lëꞌ: ―Böchaꞌa, ¿bizxa huen zaꞌu ni? Niꞌr gulabiguëꞌë bönniꞌ naꞌ, gulazönëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gleycjëꞌ guia tuchiꞌ queëꞌ tuëꞌ bönniꞌ dzaguëꞌ Jesús len benëꞌ huëꞌ, bchuguëꞌ guid naguëꞌ huen dxin queëꞌ bxuz blau. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús gudxëꞌ lëꞌ: ―Bugúꞌ lidx, guia tuchiꞌ quiuꞌ naꞌ. Yúguꞌtë nup tuꞌdiꞌini guia tuchiꞌ, lu guia tuchiꞌ lat. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Naruꞌ cu nöznuꞌ huac ulidzaꞌ Xuzaꞌ, atiꞌ Lëꞌ laꞌ gsö́laꞌtëꞌ quiaꞌ ziantër ca chinnu cöꞌ gbaz laꞌy le nac zian gayuꞌë tu cöꞌ hueaj? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Chquiꞌ gunaꞌ cni, ¿nacx gac utság le nayúj lu guich laꞌy, rna cni ral‑laꞌ gac quiaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Niꞌr Jesús gudxëꞌ yuguꞌ bönniꞌ niꞌ: ―¿Brújtsaliꞌ nuaꞌliꞌ guia tuchiꞌ len yagdauꞌ quië sönliꞌ nedaꞌ ca runliꞌ rzönliꞌ‑nëꞌ gban? Yuguꞌ dza gröꞌa lauliꞌ ga nac nchil gdauꞌ busë́dgacdaꞌ bunách, san cutu gzxönliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Rac cni yúguꞌtë lë ni quië utság le nayúj lu guich laꞌy, ca naꞌ gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. Niꞌr gulucaꞌnëꞌ Jesús yúguꞌtë bönniꞌ usë́d queëꞌ, len guluzxundjëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Niꞌr gulachë́ꞌë Jesús bönniꞌ naꞌ zönquëꞌ Lëꞌ, guladxinëꞌ lahuëꞌ Caifás, bxuz blau, ga niꞌ nudubquëꞌ caꞌ bönniꞌ gdauꞌ tuꞌsëdi len bönniꞌ gul tuꞌzejniꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro nauzëꞌ Jesús ziꞌtuꞌ ziꞌtuꞌz, len bdxinëꞌ ga nac löꞌa lidx bxuz blau naꞌ, quië gléꞌinëꞌ nacx utsaguëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Guluguiljëꞌ nu uquí Jesús yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi len bönniꞌ gdauꞌ taꞌbequi xbey, zal‑laꞌ siꞌ yëꞌë bönniꞌ naꞌ, quië gac laꞌchuguëꞌ queëꞌ gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Cutu bi guludzölnëꞌ zal‑laꞌ guladxinëꞌ bönniꞌ zian len gulanë́ꞌ queëꞌ le cunácz. Ga budxtë guladxinëꞌ chopëꞌ bönniꞌ, atiꞌ lu yöl‑laꞌ rziꞌ yëꞌ quequëꞌ gulanë́ꞌ queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","taꞌnë́ꞌ: ―Bönniꞌ ni gnëꞌ: “Huac uquindjaꞌ gdauꞌ queëꞌ Dios, atiꞌ tsonn dzaz uchisaꞌ lei.” ");
INSERT INTO zsrNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Niꞌr gyasëꞌ gzuinëꞌ bxuz blau naꞌ, len rëꞌ Jesús: ―¿Naruꞌ cu rubiꞌtsuꞌ didzaꞌ? ¿Bizxa caz lë ni taꞌnë́ꞌ quiuꞌ bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús cutu bi gnëꞌ. Niꞌr bxuz blau gudxëꞌ Lëꞌ: ―Niꞌa queëꞌ Xanruꞌ Dios ban rna béꞌidaꞌ Liꞌ quíxjöꞌu le nacz. Gdixjöiꞌ netuꞌ chquiꞌ nacuꞌ Liꞌ Cristo, Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús rëꞌ lëꞌ: ―Ca naꞌ rnauꞌ nacaꞌ. Le nactë rëpaꞌ lbiꞌiliꞌ, gléꞌiliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, röꞌa cuit lëꞌë yubél Dios, ga niꞌ dë lu naꞌa yöl‑laꞌ uná bëꞌ, len guidaꞌ lu böaj luzxbá, gdxinaꞌ ga zoaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Niꞌr lu yöl‑laꞌ rley queëꞌ bchözëꞌ lariꞌ nacuëꞌ bxuz blau, rnëꞌ: ―Gnë ziꞌë queëꞌ Dios bönniꞌ ni. ¿Nuzxar naquíniruꞌ nu gnë queëꞌ bönniꞌ ni? Chbyö́niczliꞌ didzaꞌ xöhuiꞌ bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nacx runi lbiꞌiliꞌ? Gulubiꞌë didzaꞌ, gulanë́ꞌ: ―Nabaguëꞌë zxguiaꞌ gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Niꞌr guluchijëꞌ zxönaꞌ lahuëꞌ Jesús len gluꞌë döꞌ queëꞌ. Gulagapëꞌë ruꞌë Jesús yelaꞌquëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tëꞌ Lëꞌ: ―¿Nactsuꞌ Liꞌ Cristo? Gnë́yaꞌatscaꞌ naꞌa, ¿nuzxa naꞌ gdap Liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsal niꞌ glac lë naꞌ, löꞌal röꞌë Pedro, atiꞌ bdxinnu ga naꞌ zoëꞌ tunu ngul huen dxin, rnanu: ―Lëzcaꞌ liꞌ gdálenuꞌ Jesús, bönniꞌ Galilea naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gdáꞌbaguëꞌë Pedro laugac bunách nacuáꞌ niꞌ, rnëꞌ: ―Cutu nözdaꞌ nuzxa qui naꞌ ruꞌu didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Catiꞌ brujëꞌ Pedro ga nu ryaz löꞌa, bléꞌinu‑nëꞌ yetunu ngul, atiꞌ gudxnu nup nacuáꞌ niꞌ: ―Bönniꞌ ni gdálenëꞌ caꞌ Jesús, bönniꞌ Nazaret naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Leyúbl gdáꞌbaguëꞌë Pedro len gneynëꞌ Dios, rnëꞌ: ―Cutu caꞌ núnbëꞌa‑nëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yelátiꞌdauꞌz gdzey, gulabigaꞌ ga naꞌ zoëꞌ Pedro nup nacuáꞌ niꞌ, len tëꞌ lëꞌ: ―Le nactë liꞌ nunuꞌ caꞌ tsazxö́n lequëꞌ le nac bëꞌu yöl‑laꞌ ruiꞌz quiuꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Niꞌr gzu lahuëꞌ Pedro rudxía döꞌ cuinëꞌ len rneynëꞌ Dios, rnëꞌ: ―Cutu caꞌ núnbëꞌa‑nëꞌ bönniꞌ ni. Laꞌ naꞌz grö́dxtëbaꞌ zxiꞌn druz. ");
INSERT INTO zsrNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Niꞌr yajneynëꞌ Pedro didzaꞌ gudxëꞌ lëꞌ Jesús, gnëꞌ: “Catiꞌ ziꞌa cödxlbaꞌ zxiꞌn druz, tsonn lzu chgnauꞌ cutu núnbëꞌu nedaꞌ”, atiꞌ burujëꞌ niꞌ Pedro len grödx yéchiꞌtsquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Catiꞌ zaꞌ reníꞌ dza naꞌ, glun xtídzaꞌquëꞌ yúguꞌtë bxuz uná bëꞌ len bönniꞌ gul tuꞌzéjniꞌnëꞌ bönniꞌ judío quië ludöddëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gulachë́ꞌë Jesús náguëꞌë atiꞌ guludödëꞌ Lëꞌ lu nëꞌë Poncio Pilato, bönniꞌ rna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Catiꞌ chnö́zinëꞌ Judas, bönniꞌ naꞌ budödëꞌ Jesús lu naꞌquëꞌ bönniꞌ gdauꞌ, narugu queëꞌ Jesús gatiëꞌ, buiꞌnnëꞌ, atiꞌ yjuꞌë chi uruáꞌ dumí plata naꞌ lu naꞌquëꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ gul naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Rëꞌ lequëꞌ Judas: ―Benaꞌ dul‑laꞌ le budödaꞌ‑nëꞌ bönniꞌ tsahuiꞌ gatiëꞌ. Niꞌr tëꞌ lëꞌ: ―Cutu gun ga cöꞌtuꞌ baguíꞌi lë ni. Le benczuꞌ liꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Niꞌr gruꞌnëꞌ Judas yuguꞌ dumí plata naꞌ ga nac nchil gdauꞌ atiꞌ buzë́ꞌë niꞌ, yajsí yenëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Guluziꞌë yuguꞌ dumí plata naꞌ bxuz uná bëꞌ, taꞌnë́ꞌ: ―Cutu gunn cuꞌruꞌ dumí ni ga rguꞌruꞌ dumí gun, le nac lazxjëꞌ bönniꞌ gdödi bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Niꞌr glun xtídzaꞌquëꞌ, atiꞌ gláꞌuinëꞌ dumí naꞌ tu laꞌ yël queëꞌ bönniꞌ huen röꞌö quië gac ga laꞌgachëꞌë bönniꞌ gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Qui lë ni naꞌ, ga rdxintë naꞌa dza nazíꞌ lei latj naꞌ, Laꞌ Yël Rön. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cni guc, butság lë naꞌ gnëꞌ Jeremías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: “Gulaguel‑lëꞌë chi uruáꞌ dumí plata naꞌ, tsca le gulasáquiꞌnëꞌ Lëꞌ bönniꞌ Israel, ");
INSERT INTO zsrNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","atiꞌ dumí naꞌ gláꞌuinëꞌ laꞌ yël queëꞌ bönniꞌ huen röꞌö. Lë ni buluiꞌinëꞌ nedaꞌ Xanaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Catiꞌ guluschinëꞌ Jesús lahuëꞌ Pilato, bönniꞌ rna bëꞌë naꞌ, bönniꞌ ni gnabnëꞌ Jesús, rëꞌ Lëꞌ: ―¿I nacuꞌ Liꞌ Bönniꞌ gna béꞌinëꞌ bönniꞌ judío? Jesús rëꞌ lëꞌ: ―Le nacz rnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Catiꞌ guluquíëꞌ Jesús yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi, cutu bi didzaꞌ bubiꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Niꞌr Pilato rëꞌ Jesús: ―¿Naruꞌ cu ryö́ntsanuꞌ cátiꞌga zian le taꞌnë́ꞌ quiuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús cutu bi didzaꞌ bubiꞌë. Cni guc, bubannëꞌ bönniꞌ naꞌ rna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Catiꞌ nac dza Lni Pascua naꞌ, dëcz tu le runëꞌ Pilato, bönniꞌ naꞌ rna bëꞌë, ca taꞌnáb bunách rusanëꞌ tuëꞌ bönniꞌ yuꞌë lidx guia, nútiꞌtëz nu tëꞌni usanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dza naꞌ yuꞌë lidx guia niꞌ bönniꞌ nabaguëꞌë zxguiaꞌ, lëꞌ Barrabás. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Catiꞌ guludúb niꞌ bunách zian naꞌ, gnabnëꞌ lequëꞌ Pilato, rnëꞌ: ―¿Núzxalëꞌ rë́ꞌniliꞌ usanaꞌ queëliꞌ? ¿Naruꞌ Barrabás o Jesús, Bönniꞌ naꞌ lëꞌ Cristo? ");
INSERT INTO zsrNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Cni gnëꞌ Pilato le ráquibeꞌinëꞌ guludödëꞌ Jesús lu nëꞌë bönniꞌ gdauꞌ le tuꞌzxéꞌinëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tsal niꞌ röꞌë Pilato ga naꞌ rbequi xbeynëꞌ, bsö́laꞌnu nu tsjödx lëꞌ ngul queëꞌ, rna: ―Cutu bi gunuꞌ queëꞌ bönniꞌ tsahuiꞌ ni, le szxöni gúdxidaꞌ gdyël lu yël bëchcál le nac queëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gulagúꞌu yöl‑lëꞌë bunách zian niꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi, quië laꞌnabi Pilato usanëꞌ Barrabás naꞌ atiꞌ gdöddëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Leyúbl bëꞌë didzaꞌ bönniꞌ naꞌ rna bëꞌë, rëꞌ lequëꞌ: ―¿Núzxalëꞌ chopëꞌ ni rë́ꞌniliꞌ usanaꞌ‑nëꞌ queëliꞌ? Gulanë́ꞌ: ―Barrabás. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Niꞌr Pilato gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Nacx gunaꞌ queëꞌ Jesús, bönniꞌ naꞌ lëꞌ Cristo? Yúguꞌtëꞌ taꞌnë́ꞌ: ―Bdëꞌë lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Niꞌr bönniꞌ naꞌ rna bëꞌë rëꞌ lequëꞌ: ―¿Bizxa le cunác benëꞌ? Zidzjr gluꞌë didzaꞌ, taꞌnë́ꞌ: ―Bdëꞌë lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Catiꞌ ráquibeꞌinëꞌ Pilato cutu bruj xtidzëꞌë, san glunr rusbö́ bunách, niꞌr gdel‑lëꞌë nis len gdib nëꞌë lauquëꞌ, rnëꞌ: ―Cutu bi zxguiaꞌ nabagaꞌa nedaꞌ niꞌa qui yöl‑laꞌ gut queëꞌ bönniꞌ tsahuiꞌ ni. Le gunczliꞌ lbiꞌiliꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Gulubíꞌi didzaꞌ yúguꞌtë bunách niꞌ, taꞌná: ―Yöl‑laꞌ gut queëꞌ bönniꞌ ni gbágaꞌtuꞌ netuꞌ len laꞌbagaꞌ caꞌ zxiꞌntuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Caꞌ guc, Pilato busanëꞌ quequëꞌ Barrabás naꞌ. Niꞌr gna béꞌinëꞌ bönniꞌ rjaquëꞌ gdil‑l laꞌguinëꞌ Jesús, atiꞌ gdöd niꞌ budödëꞌ Lëꞌ lu naꞌquëꞌ quië ludë́ꞌë Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gulachë́ꞌë Jesús lu yuꞌu yúlahuiꞌ nazíꞌ lei pretorio bönniꞌ rjaquëꞌ gdil‑l nacuꞌë lu nëꞌë bönniꞌ naꞌ rna bëꞌë, atiꞌ niꞌ gulutubëꞌ ga naꞌ zoëꞌ Jesús yúguꞌtë bönniꞌ rjaquëꞌ gdil‑l nacuꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Niꞌr gulagǘëꞌ lariꞌ nacuëꞌ Jesús len gulugacuëꞌ Lëꞌ tu lariꞌ xna, ca rácugac nup taꞌná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Guludxíëꞌ icjëꞌ tu breguiꞌ zxuzaꞌ nëꞌi yag yötsiꞌ len guluzóëꞌ tu guidauꞌ lu nëꞌë yubél le ruluíꞌ ca tu xuyág qui bönniꞌ yúlahuiꞌ. Niꞌr guluzechu zxibquëꞌ lahuëꞌ len gulutitjëꞌ Lëꞌ, taꞌnë́ꞌ: ―Bicaꞌ zxön Liꞌ, rna béꞌinuꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niꞌr guluchijëꞌ Lëꞌ zxönaꞌ, atiꞌ guluguel‑lëꞌë gui naꞌ len gulaguinëꞌ icjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Gdöd gulutitjëꞌ Jesús, gulugǘëꞌ lariꞌ naꞌ nacuëꞌ, atiꞌ gulugacuëꞌ Lëꞌ lariꞌ queëczëꞌ. Niꞌr gulachë́ꞌë Lëꞌ quië tsajdaꞌquëꞌ Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Catiꞌ niꞌ gularujëꞌ, yajxácaꞌquëꞌ Simón, bönniꞌ Cirene, atiꞌ glunëꞌ ga biꞌë yag cruz queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Catiꞌ guladxinëꞌ latj nazíꞌ lei Gólgota, le rna lu didzaꞌ xidzaꞌ, Latj Qui Bögaꞌ Icjruꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","niꞌ guluguiꞌjëꞌ Jesús nup zi nutsiꞌi zxágalaꞌabaꞌ böaꞌ guixiꞌ. Catiꞌ buxíꞌ ruꞌë lei Jesús, cutu guꞌnnëꞌ guiꞌjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Catiꞌ chnudaꞌquëꞌ Lëꞌ lëꞌi yag cruz, gulaguisiëꞌ lariꞌ nacuëꞌ, len guluquitjëꞌ lahui le gac bëꞌ núzxalëꞌ gaqui queëꞌ. Cni guc, butság lë naꞌ gnëꞌ bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: “Gulaguisiëꞌ lariꞌ nacuaꞌ len guluquitjëꞌ lahui le gac bëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Niꞌr gulaböꞌë niꞌ, tuꞌyúëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lëzcaꞌ guluzóëꞌ lëꞌi yag cruz icjlëꞌ Jesús tu didzaꞌ rguixjöꞌ le nabaguëꞌë, rna cni: “Bönniꞌ ni Jesús, Bönniꞌ rna béꞌinëꞌ bunách judío.” ");
INSERT INTO zsrNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ga niꞌ dëꞌë Jesús, niꞌ guludë́ꞌë caꞌ lë́ꞌigac yag cruz chopëꞌ gban. Tuëꞌ guludë́ꞌë cuit lëꞌë yubél, len yetúëꞌ naꞌ cuit lëꞌë yögl. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Guladödëꞌ niꞌ bönniꞌ gululídz ziꞌë Jesús len gulutá icjquëꞌ, tuꞌtitjëꞌ Lëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","taꞌnë́ꞌ: ―Ja, Liꞌ naꞌ uquindjuꞌ gdauꞌ atiꞌ tsonn dzaz caꞌ uchistsuꞌ lei. Buslá cuinuꞌ naꞌa chquiꞌ nacuꞌ Liꞌ Zxiꞌnëꞌ Dios. Bötjtscaꞌ lëꞌi yag cruz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lëzcaꞌ cni gulutitjëꞌ Lëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi len yuguꞌ bönniꞌ gdauꞌ fariseo, len bönniꞌ gul tuꞌzejniꞌi, taꞌnë́ꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Yuguꞌ nu yubl buslë́ꞌ bönniꞌ ni, san cutu gac uslá cuinëꞌ. Chquiꞌ naquëꞌ bönniꞌ gna béꞌinëꞌ bunách Israel, huötjtsquëꞌ naꞌa lëꞌi yag cruz, atiꞌ tséjlëꞌtuꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Lëꞌ buzxöni ladxëꞌë Dios. Dios uslaczëꞌ Lëꞌ naꞌa chquiꞌ rëꞌnnëꞌ Lëꞌ, le gnëꞌ: “Zxiꞌnëꞌ Dios nacaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lëzcaꞌ cni gululídz ziꞌë Lëꞌ gban naꞌ daꞌquëꞌ lë́ꞌigac yag cruz ga niꞌ dëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Catiꞌ bdxin huagbídz, bchul gdutë yödzlyú ga bdxintë gdu rdöd xhuö. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gdu rdöd xhuö naꞌ, bëꞌë zidzj didzaꞌ Jesús, rnëꞌ: ―Elí, Elí, ¿lama sabactani? Didzaꞌ ni rna lu didzaꞌ xidzaꞌ: “Dios quiaꞌ, Dios quiaꞌ, ¿bizx quië nubíj ladxuꞌu nedaꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Catiꞌ gulayöni didzaꞌ ni nup nacuáꞌ niꞌ, taꞌná: ―Bönniꞌ ni rulidzëꞌ Elías, bönniꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Laꞌ gxítiꞌtëꞌ tuëꞌ bönniꞌ nutsëꞌë ladjquëꞌ len gdel‑lëꞌë tu le blul rzxup nis, atiꞌ buxúpinëꞌ lei nup zi len buzóëꞌ lei lu gui, atiꞌ butsaguëꞌ lei ruꞌë Jesús quië xupëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Niꞌr yelaꞌquëꞌ bönniꞌ niꞌ taꞌnë́ꞌ: ―Glözgar. Uyútscaꞌruꞌ chquiꞌ huidëꞌ Elías uslë́ꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Leyúbl grödxyëꞌë zidzj Jesús atiꞌ burujtë böꞌ nacczëꞌ, guttëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Laꞌ naꞌz brö́zaꞌtë lariꞌ nal‑laꞌ lu gdauꞌ, bruj chopl le gdel‑laꞌ icjl ga bdxintë xniꞌi. Niꞌr gtit luyú len gulaláꞌa guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gulayálj yeru ba quegac nup chnatgac, bönniꞌ niꞌ gulayejlëꞌë Dios, atiꞌ gulubanëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gdöd bubanëꞌ Jesús, gulurujëꞌ yeru ba quequëꞌ bönniꞌ naꞌ len gulayaziëꞌ yödz laꞌy Jerusalén, ga niꞌ gulaleꞌi lequëꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Niꞌr catiꞌ gulaléꞌinëꞌ gtit luyú len lë naꞌ glac, gládxinëꞌ bönniꞌ niꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l lencaꞌ bönniꞌ rjaquëꞌ gdil‑l nacuáꞌlenëꞌ lëꞌ tuꞌyúëꞌ Jesús, taꞌnë́ꞌ: ―Le nactë bönniꞌ ni guquëꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ziꞌtuꞌz gulacuaꞌnu niꞌ ngul zian tuꞌyunu Jesús, ngul naꞌ guladálennu Jesús catiꞌ niꞌ buzë́ꞌë luyú Galilea, atiꞌ glunnu xchinëꞌ, gulaguꞌnu le glahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nútsaꞌcnu caꞌ ladjcnu María Magdalena len María, xnaꞌquëꞌ Jacobo len José, atiꞌ zoanu caꞌ niꞌ xnaꞌquëꞌ zxiꞌnëꞌ Zebedeo. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Catiꞌ chrdzöꞌ dza naꞌ, bdxinëꞌ niꞌ José, bönniꞌ Arimatea, bönniꞌ dë yöl‑laꞌ tsahuiꞌ queëꞌ, len dëꞌë caꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yajyúëꞌ Pilato bönniꞌ ni len gnabëꞌ latj uꞌë Jesús. Niꞌr Pilato gna bëꞌë lunödzjëꞌ queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gzxiꞌë Lëꞌ José len buchö́linëꞌ Lëꞌ tu lariꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Niꞌr gluꞌë Lëꞌ yeru ba cub queëꞌ le naguidjëꞌ lëꞌi guiꞌa guiöj. Budë́ꞌë tu guiöj blag zxön ga nu ryaz yeru ba naꞌ atiꞌ zhuöjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Gulacuaꞌnu niꞌ María Magdalena len yetunu María caꞌ, röꞌcnu raꞌ yeru ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Catiꞌ zaꞌ reníꞌ yetú dza, gdöd gulupë́ꞌë qui dza laꞌy quequëꞌ bönniꞌ judío, guludubëꞌ ga zoëꞌ Pilato yuguꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ gdauꞌ fariseo. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tëꞌ Pilato: ―Bönniꞌ, rajneytuꞌ bi gnëꞌ bönniꞌ rziꞌ yëꞌ naꞌ, catiꞌ niꞌ zoëꞌ nabanëꞌ, gnëꞌ: “Catiꞌ gac tsonn dza ubanaꞌ lu yöl‑laꞌ gut.” ");
INSERT INTO zsrNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Qui lë ni naꞌ gna beꞌi nup lun chiꞌi ba niꞌ ga gdxintë dza bunn, cui djaquëꞌ chdzöꞌl bönniꞌ usë́d queëꞌ lubijëꞌ Lëꞌ. Niꞌr lëꞌ bunách: “Bubanëꞌ Jesús lu yöl‑laꞌ gut.” Chquiꞌ cni gac, didzaꞌ cunácz luꞌë guntër huiaꞌdöꞌ ca ben didzaꞌ cunácz naꞌ gluꞌë ziꞌal. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato gudxëꞌ lequëꞌ: ―Ni nacuꞌë bönniꞌ rjaquëꞌ gdil‑l. Gul‑chë́ꞌë queëliꞌ. Gul‑tséaj, gul‑gún chiꞌi yeru ba naꞌ tsca sáquiꞌliꞌ gunliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Niꞌr yjaquëꞌ niꞌ len guluseyjëꞌ dxiꞌa yeru ba naꞌ, len guludë́ꞌë lëꞌi guiöj naꞌ tu le gac bëꞌ chquiꞌ gsalj, atiꞌ gulucaꞌnëꞌ niꞌ bönniꞌ rjaquëꞌ gdil‑l lun chiꞌë lei. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Catiꞌ chgdöd dza laꞌy quequëꞌ bönniꞌ judío, len chzaꞌ reníꞌ dza domingo, yajyucnu yeru ba queëꞌ Jesús María Magdalena len yetunu María naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsalz gtit luyú. Cni guc, le bötjëꞌ tuëꞌ gbaz laꞌy queëꞌ Xanruꞌ narujëꞌ yehuaꞌ yubá. Bdxinëꞌ raꞌ yeru ba naꞌ atiꞌ gduëꞌ guiöj blag zxön naꞌ len gröꞌë lu guiöj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Naláꞌ lahui gbaz laꞌy naꞌ ca yös yeníꞌ, atiꞌ zxílaꞌdauꞌz nac lariꞌ nacuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Catiꞌ gulaléꞌinëꞌ lëꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l tun chiꞌë yeru ba naꞌ, gládxinëꞌ lëꞌ len gulazxiziëꞌ. Guladzöꞌë lu yu, glaquëꞌ ca bönniꞌ nat. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Niꞌr gbaz laꞌy naꞌ gudxëꞌ yuguꞌ ngul naꞌ, rnëꞌ: ―Cutu gádxiliꞌ. Nözdaꞌ ruguiljliꞌ‑nëꞌ Jesús, bönniꞌ naꞌ guludë́ꞌë Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Cutu zoëꞌ ni le chbubanëꞌ ca naꞌ chgnaczëꞌ Lëꞌ. Gul‑dá, uyuliꞌ ga niꞌ gutëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gul‑tséaj naꞌa, gul‑tsjö́dx‑quëꞌ bönniꞌ usë́d queëꞌ chbubanëꞌ Jesús lu yöl‑laꞌ gut, atiꞌ naꞌa Lëczëꞌ nörëꞌ lauliꞌ zacaꞌ luyú Galilea. Niꞌ uléꞌiliꞌ‑nëꞌ. Chgudxaꞌ lbiꞌiliꞌ le gluꞌë Dios lu naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Niꞌr laꞌ guluzáꞌtënu raꞌ yeru ba naꞌ, tádxinu len tuꞌdzíjinu, atiꞌ jaréluꞌcnu zjacnu zajtíxjöiꞌcnu yuguꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsal niꞌ zjacnu, yajtsaguëꞌ lecnu Jesús, len rëꞌ lecnu: ―Padiux. Niꞌr gulabígaꞌnu ga zoëꞌ Jesús len gulunídaꞌnu niꞌë. Gulayíj ládxiꞌcnu Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Niꞌr Jesús rëꞌ lecnu: ―Cutu gádxiliꞌ. Gul‑tséaj, gul‑tsajtixjöiꞌ‑cnëꞌ böchaꞌa tsjaquëꞌ zacaꞌ luyú Galilea, atiꞌ niꞌ luléꞌinëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tsal niꞌ zjacnu ngul naꞌ, guludxinëꞌ lu yödz niꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l glun chiꞌë yeru ba naꞌ, atiꞌ gulaguíxjöiꞌnëꞌ yuguꞌ bxuz uná bëꞌ yúguꞌtë lë naꞌ glac. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Catiꞌ chgulutubëꞌ bönniꞌ gul tuꞌzejniꞌi, glun xtídzaꞌquëꞌ. Niꞌr dumí zian gulunödzjëꞌ quequëꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tëꞌ lequëꞌ: ―Cni gnaliꞌ: “Guladxinëꞌ chdzöꞌl bönniꞌ usë́d queëꞌ len gulubijëꞌ Lëꞌ tsal niꞌ rastuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chquiꞌ huayönnëꞌ lë ni bönniꞌ rna bëꞌë, netuꞌ uzéjniꞌtuꞌ lëꞌ len guntuꞌ ga cutu bi gunëꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niꞌr gulaziꞌë dumí naꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l atiꞌ yjenquëꞌ ca naꞌ chnazëdquëꞌ. Cni guc, tuꞌzë́ꞌ didzaꞌ ni bönniꞌ judío ga rdxintë naꞌa dza. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Niꞌr yjaquëꞌ luyú Galilea idxineajtëꞌ bönniꞌ usë́d queëꞌ Jesús, atiꞌ guladxinëꞌ lu guíꞌadauꞌ naꞌ chbuluiꞌinëꞌ lequëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Catiꞌ gululéꞌinëꞌ Jesús, gulayíj ládxiꞌquëꞌ Lëꞌ, san laꞌquëꞌ glac chop ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Niꞌr gbiguëꞌë Jesús ga naꞌ nacuꞌë, len rëꞌ lequëꞌ: ―Dios chnudödëꞌ lu naꞌa yúguꞌtë yöl‑laꞌ uná bëꞌ yehuaꞌ yubá len luyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Qui lë ni naꞌ, gul‑tséaj, gul‑tsajsëdi yúguꞌtë bunách gzaꞌa gdutë yödzlyú. Gul‑quíl lequëꞌ nis, ugunliꞌ dxin lëꞌ Dios Xuz, len lëꞌ Dios Zxiꞌn, len lëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gul‑sëdi lequëꞌ lunëꞌ yúguꞌtë lë naꞌ gna béꞌidaꞌ lbiꞌiliꞌ. Gul‑yutscaꞌ, nédaꞌczaꞌ zóalenaꞌ lbiꞌiliꞌ yúguꞌtë dza ga gdxinr dza udx qui yödzlyú. Caꞌ gac.");
INSERT INTO zsrNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cni gzu lau didzaꞌ dxiꞌa ca guc queëꞌ Jesucristo, Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Butság lë naꞌ buzujëꞌ lu guich Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, le gnëꞌ Dios: Byutscaꞌ. Rsölaꞌa bönniꞌ gbaz quiaꞌ, nörëꞌ Lauꞌ. Lëꞌ upë́ꞌë nöz ga töduꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yön chiꞌë bönniꞌ ulidzëꞌ zidzj lu latj caꞌz, gnëꞌ: “Gul‑páꞌ nöz gdxin queëliꞌ Xanruꞌ. Gul‑bíj li yuguꞌ nöz las tödëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Lë ni butság, le ruquilëꞌ bunách nis Juan lu latj caꞌz, len runëꞌ lban quië laꞌdíl bunách nis, bönniꞌ naꞌ gulubíꞌi ládxiꞌquëꞌ quië unít lahuëꞌ Dios ca nac dul‑laꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gularúj bunách zian yúguꞌtë yödz luyú Judea lencaꞌ Jerusalén, yjaquëꞌ ga naꞌ zoëꞌ Juan, atiꞌ Juan naꞌ buquilëꞌ lequëꞌ nis lu yegu Jordán, bönniꞌ naꞌ gulaxóalëpëꞌ dul‑laꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nacuëꞌ Juan lariꞌ náquini lítsaꞌbaꞌ böaꞌ len tu pan guid núguëꞌë lëꞌë. Rahuëꞌ‑baꞌ böchiꞌzú len riꞌjëꞌ le zxix qui bözdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Runëꞌ lban Juan, rnëꞌ: ―Ziꞌa zëꞌë bönniꞌ töd naꞌa, naprëꞌ yöl‑laꞌ uná bëꞌ ca nedaꞌ. Cutu nacaꞌ nedaꞌ lsacaꞌ yechuaꞌ, gleycjaꞌ lölëꞌ nudë́ꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nedaꞌ ruquilaꞌ lbiꞌiliꞌ nis, san Lëꞌ gunëꞌ le ruluíꞌz yöl‑laꞌ rdil nis ni, uchiziëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tu dza niꞌ brujëꞌ Jesús yödz Nazaret luyú Galilea, atiꞌ buquilëꞌ Lëꞌ nis Juan naꞌ lu yegu Jordán. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Catiꞌ burujëꞌ lu nis Jesús, laꞌ naꞌz bléꞌinëꞌ gyalj luzxbá len ruhuötjëꞌ Dios Böꞌ Laꞌy, ruluíꞌ cuinëꞌ ca budödauꞌ, dusóalenëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Byön chiꞌi nu ruiꞌ didzaꞌ yehuaꞌ yubá, rna: ―Liꞌ nacuꞌ Zxiꞌnaꞌ. Nadxiꞌidaꞌ Liꞌ len rdzag ladxaꞌa Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Niꞌr bayúdx bchëꞌë Jesús lu latj caꞌz Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Choaꞌ dza gzoëꞌ Jesús latj caꞌz naꞌ, atiꞌ guꞌni Satanás tuꞌ xöhuiꞌ ugáp Jesús dul‑laꞌ. Gzoëꞌ Jesús ga niꞌ taꞌdabaꞌ böaꞌ guixiꞌ dzöꞌbaꞌ guíꞌadauꞌ. Gláclenëꞌ Jesús gbaz laꞌy queëꞌ Dios, gulaguꞌë le gdahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gdöd gulaguꞌë Juan naꞌ lidx guia, zijëꞌ Jesús luyú Galilea. Runëꞌ lban niꞌ qui didzaꞌ dxiꞌa ca rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Cni rnëꞌ: ―Chbdxin dza. Chzoa duná bëꞌë ni Dios. Gul‑bíꞌi ládxiꞌliꞌ len gul‑tsejlëꞌ didzaꞌ dxiꞌa ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tsal niꞌ rdëꞌ Jesús raꞌ nis zxön qui Galilea, bléꞌinëꞌ Simón len Andrés, bönniꞌ böchëꞌë Simón naꞌ. Nacquëꞌ uzö́n böl len taꞌchiljëꞌ yöxj böl quequëꞌ lu nis naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑dutáꞌ nedaꞌ, atiꞌ gunaꞌ ga gchëꞌliꞌ quiaꞌ bunách, gunliꞌ ca runliꞌ rzönliꞌ‑baꞌ böl. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Laꞌ gulucaꞌntëꞌ yöxj quequëꞌ, zjáclenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gdödëꞌ Jesús yelátiꞌdauꞌ niꞌl atiꞌ niꞌ bléꞌinëꞌ Jacobo len Juan, yuguꞌ zxiꞌnëꞌ Zebedeo, nacuꞌë lëꞌi bárcodauꞌ quequëꞌ, tuꞌúnëꞌ yöxj böl quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Laꞌ bulidztëꞌ lequëꞌ Jesús, atiꞌ gulucaꞌnëꞌ xuzquëꞌ Zebedeo, dzaguëꞌ yuguꞌ huen dxin queëꞌ lëꞌi bárcodauꞌ naꞌ, atiꞌ zjáclenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Guladxinëꞌ yödz Capernaum Jesús len bönniꞌ daꞌquëꞌ Lëꞌ. Catiꞌ niꞌ nac dza laꞌy quequëꞌ bönniꞌ judío, gyaziëꞌ Jesús yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ niꞌ gzu lahuëꞌ rusëdnëꞌ nup nudubgac niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gulubannëꞌ ca naꞌ rusëdnëꞌ Jesús, le rusëdnëꞌ ca runëꞌ bönniꞌ dë lu nëꞌë len clëg ca tunëꞌ bönniꞌ gdauꞌ usëdi. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Zoatëꞌ caꞌ niꞌ lu yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios tu bönniꞌ yuꞌu lëꞌ böꞌ xöhuiꞌ, atiꞌ grödxyëꞌë bönniꞌ naꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","rnëꞌ: ―¿Bizxa rál‑laꞌtuꞌ quiuꞌ, Jesús, bönniꞌ Nazaret? ¿Zaꞌtsuꞌ usnitiuꞌ netuꞌ? Núnbëꞌa Liꞌ, nacuꞌ Bönniꞌ Laꞌy queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Buzeynëꞌ lei ba nadx Jesús, rnëꞌ: ―Bseyj ruꞌu len burúj lu bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Niꞌr buxiztsca bönniꞌ naꞌ yuꞌu lëꞌ böꞌ xöhuiꞌ naꞌ, atiꞌ grödxyaꞌa zidzj, len laꞌ burujtë. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gulubannëꞌ yúguꞌtë bönniꞌ nacuꞌë niꞌ, atiꞌ gulanabi lzaꞌquëꞌ, taꞌnë́ꞌ: ―¿Bizxa caz lë ni? ¿Naruꞌ nactsa zxba cub? Len yöl‑laꞌ uná bëꞌ rna béꞌinëꞌ yuguꞌ böꞌ xöhuiꞌ, atiꞌ tun ca rnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Laꞌ gzëtë didzaꞌ qui yöl‑laꞌ huac queëꞌ Jesús, gulayöni bunách gdutë luyú Galilea naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Niꞌr burujëꞌ Jesús lu yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, len laꞌ gyéajlentëꞌ Jacobo len Juan, guladxinëꞌ lidxquëꞌ Simón len Andrés. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Niꞌ dënu xnaꞌnu ngul queëꞌ Pedro, yuꞌunu tu xla. Laꞌ gulaguíxjöiꞌtenëꞌ Jesús ca rac queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Niꞌr gbiguëꞌë Jesús, atiꞌ gdel‑lëꞌë naꞌnu, bchisëꞌ‑nu. Laꞌ burujtë tu xla naꞌ yuꞌunu, atiꞌ bupaꞌnu le glahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Catiꞌ chrdzöꞌ, ca gdxia gbidz, laꞌ djuáꞌgactëꞌ ga zoëꞌ Jesús yúguꞌtë nup teꞌi len bönniꞌ yuꞌu lequëꞌ böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gulaguír ga nu ryaz yuꞌu ga naꞌ zoëꞌ Jesús yúguꞌtë bunách lu yödz. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús bunëꞌ zian nup teꞌi, nac zian guidzhuë́ꞌ téꞌinëꞌ. Bubijëꞌ caꞌ zian böꞌ xöhuiꞌ yuꞌugac bunách naꞌ. Cutu bëꞌë latj laꞌnë́ böꞌ xöhuiꞌ naꞌ le núnbëꞌgac Lëꞌ Nu naquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zíꞌadauꞌ gyasëꞌ Jesús, niꞌ nac chul. Brujëꞌ yödz naꞌ, zijëꞌ tu latj caꞌz, atiꞌ niꞌ bulidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Zajtiljquëꞌ Jesús Simón len nup nacuaꞌlen lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Catiꞌ yajxácaꞌquëꞌ Lëꞌ, tëꞌ Lëꞌ: ―Tuꞌguílj Liꞌ yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Niꞌr gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Huayejruꞌ yuguꞌ dzag yödz, quië gunaꞌ caꞌ lban niꞌ. Qui lë ni naꞌ brujaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cni guc, gdödëꞌ Jesús gdu luyú Galilea, runëꞌ lban lu yuꞌu gap tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío len rubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bdxinëꞌ ga zoëꞌ Jesús bönniꞌ réꞌinëꞌ huëꞌ nudzuꞌ ruzö́d. Buzechu zxibëꞌ len gútaꞌyuëꞌ lahuëꞌ, rnëꞌ: ―Chquiꞌ rëꞌnnuꞌ, huac unuꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Buechiꞌ ladxëꞌë lëꞌ Jesús. Bulí nëꞌë, gdanëꞌ lëꞌ len gudxëꞌ lëꞌ: ―Rëꞌndaꞌ. Chnuhuöacuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ca gnëꞌ caꞌ, laꞌ bunittë huëꞌ réꞌinëꞌ, böaquëꞌ dxíꞌadauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Niꞌr buzeynëꞌ bach bönniꞌ naꞌ Jesús len laꞌ busö́laꞌtëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Cni gudxëꞌ lëꞌ: ―Nutu nu guiꞌu ca benaꞌ quiuꞌ, san gyeaj, yajluíꞌ cuinuꞌ lahuëꞌ bxuz, len yajnö́dzj quië le böacnuꞌ liꞌ qui gdauꞌ ca naꞌ gna bëꞌë Moisés, lë naꞌ uluíꞌi bunách chnuhuöacuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Burujëꞌ bönniꞌ ni len gzu lahuëꞌ rguíxjöiꞌnëꞌ bunách zian ca guc queëꞌ. Le buzë́ꞌ didzaꞌ ni, cutur guc tsaziëꞌ yalj lulu nitú lu yödz Jesús, san gzoazëꞌ niꞌl gap nac lu latj caꞌz. Ga niꞌ zoëꞌ Jesús guladxín lahuëꞌ bunách yúguꞌtë yödz. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Catiꞌ chgdöd chop tsonn dza, buaziëꞌ Jesús yödz Capernaum, atiꞌ gzë didzaꞌ zoëꞌ yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Laꞌ guludubtë bunách zian ga naꞌ zoëꞌ Jesús, ga bdxintë cutur gzxaquiꞌ laꞌcuꞌë niꞌ, ni raꞌ yuꞌu, atiꞌ Jesús benëꞌ lban qui xtidzëꞌë lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Niꞌr guladxinëꞌ ga naꞌ zoëꞌ Jesús tapëꞌ bönniꞌ, nuaꞌquëꞌ tu bönniꞌ huëꞌ nacuꞌnëꞌ bin. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cutu guc laꞌdxinëꞌ lahuëꞌ Jesús le nacuáꞌ niꞌ bunách zian. Qui lë ni naꞌ gulasaljëꞌ cjuꞌu ca dödl ga zoëꞌ Jesús. Catiꞌ budx guludxíëꞌ yeru naꞌ, niꞌ guluzötjëꞌ le deynëꞌ bönniꞌ huëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Catiꞌ gúquibeꞌinëꞌ Jesús ca naꞌ taꞌyejlëꞌë Lëꞌ, gudxëꞌ bönniꞌ huëꞌ naꞌ: ―Zxiꞌnaꞌ, chbunít lahuaꞌ liꞌ ca nac dul‑laꞌ nabaguꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Röꞌquëꞌ niꞌ laꞌquëꞌ bönniꞌ gdauꞌ usëdi, taꞌzáꞌ ládxiꞌquëꞌ, taꞌnë́ꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Bizx quië ruꞌë cni didzaꞌ bönniꞌ ni? Rucaꞌnëꞌ caꞌz Dios. Nutu nu bönniꞌ gac unít lahuëꞌ dul‑laꞌ. Tuzëꞌ Dios gac gunëꞌ lë ni.” ");
INSERT INTO zsrNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Laꞌ gúquibeꞌitenëꞌ Jesús le taꞌzáꞌ ládxiꞌquëꞌ, atiꞌ gudxëꞌ lequëꞌ: ―¿Bizx quië rzaꞌ ládxiꞌliꞌ cni? ");
INSERT INTO zsrNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cutu nac baníg nu guiëz bönniꞌ huëꞌ ni chbunít lau dul‑laꞌ nabaguëꞌë, san nac baníg nu gun ga huöasëꞌ len uꞌë le deynëꞌ len uzëꞌi niꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gunaꞌ le gac bëꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, dë lu naꞌa luyú ni unít lahuaꞌ dul‑laꞌ nabágaꞌgac bunách. Niꞌr Jesús gudxëꞌ bönniꞌ huëꞌ naꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Liꞌ rëpaꞌ: “Gyas. Buaꞌ le deynuꞌ len böaj lidxuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Laꞌ gyastëꞌ bönniꞌ huëꞌ naꞌ, buꞌë le gútiꞌnëꞌ len burujëꞌ laugac yúguꞌtë nup nacuáꞌ niꞌ. Gulubannëꞌ yúguꞌtëꞌ len gulaguꞌë Dios yöl‑laꞌ ba, taꞌnë́ꞌ: ―Gatga rléꞌinituꞌ le cni. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Burujëꞌ yödz Capernaum naꞌ Jesús, gdödëꞌ leyúbl raꞌ nis zxön. Guludúb ga zoëꞌ Jesús bunách zian, atiꞌ Lëꞌ busëdnëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Catiꞌ rdödëꞌ niꞌ Jesús, bléꞌinëꞌ Leví, zxiꞌnëꞌ Alfeo, röꞌë ga ruquizxjëꞌ uláz qui yödz ziꞌtuꞌ. Jesús gudxëꞌ lëꞌ: ―Gdaꞌ nedaꞌ. Laꞌ gyastëꞌ Leví naꞌ, zéajlenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gdöd guc lë ni, röꞌë Jesús rahuëꞌ lu yuꞌu lidxëꞌ Leví naꞌ, atiꞌ rö́ꞌlenquëꞌ tsazxö́n Jesús len yuguꞌ bönniꞌ usë́d queëꞌ zian bönniꞌ uquízxj len yelaꞌquëꞌ bönniꞌ caꞌz. Cni guc, le rjaclen Jesús bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Catiꞌ gulaléꞌinëꞌ Lëꞌ bönniꞌ gdauꞌ tuꞌsëdi len yuguꞌ bönniꞌ gdauꞌ fariseo, röꞌë rágulenëꞌ tsazxö́n yuguꞌ bönniꞌ uquízxj len yelaꞌquëꞌ bönniꞌ caꞌz, glëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, taꞌnë́ꞌ: ―¿Bizxa caz runtsëꞌ? Riꞌj rágulenëꞌ yuguꞌ bönniꞌ uquízxj len yelaꞌquëꞌ bönniꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Byönnëꞌ Jesús didzaꞌ ni tuꞌë len gudxëꞌ lequëꞌ: ―Cutu naquínigac nu un bunách nup nacuáꞌ dxiꞌa, san nup teꞌi naquínigac nu un bunách. Zaꞌa nedaꞌ, clëg dulídzgacaꞌ bunách tsahuiꞌ, san rulídzgacaꞌ bunách dul‑laꞌ quië lubíꞌi ládxiꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tu dza niꞌ tunëꞌ gubás bönniꞌ daꞌquëꞌ Juan len bönniꞌ daꞌquëꞌ yuguꞌ bönniꞌ gdauꞌ fariseo, atiꞌ guladxín ga zoëꞌ Jesús nup gulanabi Lëꞌ, taꞌná: ―¿Bizx quië tunëꞌ gubás bönniꞌ daꞌquëꞌ Juan len bönniꞌ daꞌquëꞌ yuguꞌ bönniꞌ gdauꞌ fariseo, san bönniꞌ daꞌquëꞌ Liꞌ cutu tunëꞌ gubás? ");
INSERT INTO zsrNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ ráquitsaliꞌ lun gubás nup nacuáꞌ lni queëꞌ bönniꞌ utság nëꞌë tsal niꞌ zóalenëꞌ lequëꞌ bönniꞌ naꞌ utság nëꞌë? Tsal niꞌ zóalenëꞌ lequëꞌ bönniꞌ naꞌ utság nëꞌë, cutu gac lunëꞌ gubás. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gdxin dza catiꞌ gduëꞌ bönniꞌ naꞌ utság nëꞌë, cutur sóalenëꞌ lequëꞌ, atiꞌ dza niꞌr lunëꞌ gubás. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Nutu nu bönniꞌ udë́ꞌë tu lariꞌ cubdauꞌ lu lariꞌ chnatë́b, le uxúꞌn lariꞌ cub naꞌ len huachözaꞌ lariꞌ tëb naꞌ, atiꞌ huarözaꞌr lariꞌ tëb naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lëzcaꞌ cni nutu nu bönniꞌ quëꞌë xisi uva cub lu röꞌö bidx náquini guid, le gal xisi uva cub naꞌ len uláꞌa röꞌö bidx naꞌ náquini guid, atiꞌ glalj xisi uva naꞌ len gac ditj röꞌö náquini guid. Xisi uva cub lu röꞌö náquini guid cub ral‑laꞌ caꞌaruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tu dza laꞌy quequëꞌ bönniꞌ judío, gdödëꞌ Jesús gap dë yöl zxoaꞌ xtil, atiꞌ bönniꞌ usë́d queëꞌ gulazú lauquëꞌ taꞌleycjëꞌ deu ga dxia zxoaꞌ xtil. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Niꞌr glëꞌ Jesús bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―Byutscaꞌ. ¿Bizx quië tunëꞌ bönniꞌ daꞌquëꞌ Liꞌ le cutu ral‑laꞌ gunruꞌ dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús gudxëꞌ lequëꞌ: ―¿Naruꞌ cu nulábniliꞌ ca benëꞌ David catiꞌ gdunëꞌ? Byadzj le lahuëꞌ, lëꞌ len nup nacuaꞌlen lëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","atiꞌ gyaziëꞌ lu yuꞌu queëꞌ Dios catiꞌ niꞌ naquëꞌ bxuz blau Abiatar, len gdahuëꞌ yöt xtil tuꞌcuꞌë lahuëꞌ Dios, lë naꞌ cutu dë latj nu gagu, san tuz bxuz dë latj lahuëꞌ lei. Bëꞌë caꞌ le lahuëꞌ bönniꞌ nacuáꞌlenëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Dios benëꞌ dza laꞌy quië luzíꞌ xbey bunách, clëg benëꞌ bunách quië lun chiꞌi dza laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Qui lë ni naꞌ, nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, nacaꞌ Xani dza laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Leyúbl gyaziëꞌ Jesús tu lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ zoëꞌ caꞌ niꞌ bönniꞌ narequiꞌ nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tuꞌyúëꞌ Jesús bönniꞌ gdauꞌ niꞌ chquiꞌ unëꞌ bönniꞌ naꞌ dza laꞌy, le tëꞌnnëꞌ luquíëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Niꞌr gudxëꞌ bönniꞌ naꞌ narequiꞌ nëꞌë Jesús, rnëꞌ: ―Gyas len gzui laugac bunách ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gnabnëꞌ bunách niꞌ Jesús, rnëꞌ: ―¿Naruꞌ dë latj gunruꞌ le nac dxiꞌa catiꞌ nac dza laꞌy o gunruꞌ le cunác? ¿Naruꞌ dë latj gunruꞌ ga laꞌdel‑liꞌ yöl‑laꞌ naꞌbán bunách o usnitruꞌ lei? Gulacuáꞌ dxiz bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Niꞌr len yöl‑laꞌ rley queëꞌ, buyúëꞌ Jesús bunách naꞌ nacuáꞌ gdu cuitiëꞌ, ruhuiꞌnnëꞌ le nacquëꞌ zid ladxiꞌ. Gudxëꞌ bönniꞌ naꞌ narequiꞌ nëꞌë, rnëꞌ: ―Bli naꞌu. Niꞌr bulí nëꞌë bönniꞌ naꞌ atiꞌ böactë dxíꞌadauꞌ nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Niꞌr gulurujëꞌ bönniꞌ gdauꞌ fariseo atiꞌ laꞌ gluntëꞌ tsazxö́n didzaꞌ len bönniꞌ daꞌquëꞌ Herodes bi lunëꞌ queëꞌ Jesús, quië ludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Buzë́ꞌë niꞌ Jesús tsazxö́n len bönniꞌ daꞌquëꞌ Lëꞌ, bdxinëꞌ raꞌ nis zxön, atiꞌ zjaclen Lëꞌ bunách zian narujgac luyú Galilea len luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Guladxín caꞌ ga zoëꞌ Jesús bunách zian narujgac Jerusalén len luyú Idumea len yetsláꞌa yegu Jordán len yödz nacuáꞌ gdu zbiꞌil ga nacuáꞌ yödz Tiro len yödz Sidón. Cni glunëꞌ, le gulayönnëꞌ ca nac yuguꞌ le zxön runëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Qui lë ni naꞌ Jesús gna béꞌinëꞌ bönniꞌ daꞌquëꞌ Lëꞌ lucö́zteczëꞌ tu bárcodauꞌ ga gac cuenëꞌ, cui luquí lutsútsj Lëꞌ bunách zian naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Cni guc, le chbunëꞌ zian nup teꞌi, atiꞌ gulaguír ga zoëꞌ bunách zian naꞌ quië laꞌgán Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Catiꞌ gulaleꞌi Jesús böꞌ xöhuiꞌ yuꞌugac bunách, guludxigaꞌ xniꞌë Jesús bunách naꞌ yuꞌugac, len gulabödxyaꞌa, taꞌná: ―Nacuꞌ Liꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Buzeynëꞌ ba nadx böꞌ xöhuiꞌ naꞌ Jesús, cui laꞌguixjöꞌ nu naquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Niꞌr grenëꞌ Jesús tu lu guíꞌadauꞌ, atiꞌ niꞌ bulidzëꞌ nup rëꞌnnëꞌ. Gulabiguëꞌë gdu cuitiëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bucuꞌë chinnuëꞌ bönniꞌ ni Jesús, quië laꞌcuáꞌlenëꞌ Lëꞌ len quië gsölëꞌë lequëꞌ tsjenquëꞌ lban. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Budödëꞌ lu naꞌquëꞌ yöl‑laꞌ huac luúnëꞌ nup teꞌi len lubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cni nacgac laquëꞌ: Simón, (nuzóëꞌ Jesús yetú lëꞌ, Pedro), ");
INSERT INTO zsrNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, Juan, (bönniꞌ böchëꞌë Jacobo, atiꞌ nacquëꞌ zxiꞌnëꞌ Zebedeo. Chopëꞌ ni, Jesús buzóëꞌ yetú laquëꞌ, Boanerges, le rna lu didzaꞌ xidzaꞌ: “Bönniꞌ sniaꞌ ca gziuꞌ”), ");
INSERT INTO zsrNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo, (zxiꞌnëꞌ Alfeo), Tadeo, Simón, (bönniꞌ ruiꞌ ladxëꞌë yödz queëꞌ), ");
INSERT INTO zsrNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, (bönniꞌ udödëꞌ Jesús lu naꞌquëꞌ bönniꞌ ludöddëꞌ Lëꞌ). Gdöd niꞌ guludxinëꞌ tu lu yuꞌu Jesús len bönniꞌ daꞌquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Leyúbl gulaguír ga zoëꞌ Jesús bunách zian, atiꞌ cutur gutaꞌ latj lahuëꞌ yöt Jesús len bönniꞌ naꞌ daꞌquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Catiꞌ gulayönnëꞌ ca rac queëꞌ Jesús diꞌa dza queëꞌ, guladxinëꞌ niꞌ quië luchë́ꞌë Lëꞌ, taꞌnë́ꞌ: “Rchixi icjëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lëzcaꞌ cni gulanë́ꞌ queëꞌ bönniꞌ gdauꞌ usëdi, narujquëꞌ Jerusalén, taꞌnë́ꞌ: ―Dzag Lëꞌ Beelzebú, xangac böꞌ xöhuiꞌ, atiꞌ len yöl‑laꞌ uná bëꞌ qui rubijëꞌ yuguꞌ böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Niꞌr bulidzëꞌ bönniꞌ gdauꞌ tuꞌsëdi naꞌ Jesús, len benëꞌ lsaquiꞌ, rnëꞌ: ―¿Naruꞌ ubijtsa laꞌ cuinzi Satanás tuꞌ xöhuiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chquiꞌ laꞌrúj chopl bunách tu yödz, len laꞌdil‑len lzaꞌgac, cutu gac gdiaꞌ yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lëzcaꞌ cni chquiꞌ laꞌrúj chopl bunách nacuáꞌ tu yuꞌu, len laꞌdil‑len lzaꞌgac, cutu gac laꞌdíaꞌ bunách nacuáꞌ yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Qui lë ni naꞌ, chquiꞌ táꞌbagaꞌ lzëꞌi Satanás tuꞌ xöhuiꞌ, narujgac chopl böꞌ xöhuiꞌ atiꞌ cutu gac gdiaꞌ yöl‑laꞌ uná bëꞌ qui, san chzoa udx qui. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nutu nu gac tsaz lidxëꞌ tu bönniꞌ nal len cuiaj yöl‑laꞌ tsahuiꞌ queëꞌ chquiꞌ cutu gáguëꞌë ziꞌal bönniꞌ nal naꞌ, atiꞌ niꞌr sáquiꞌnëꞌ cuijëꞌ le dzöꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Le nactë rëpaꞌ lbiꞌiliꞌ: Dios gac unít lahuëꞌ bunách ca nac yúguꞌtë dul‑laꞌ nabágaꞌgac len ca nac yúguꞌtë didzaꞌ xöhuiꞌ taꞌná, ");
INSERT INTO zsrNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","san nútiꞌtëz nu gnë xöhuiꞌ queëꞌ Dios Böꞌ Laꞌy, gatga unít lahuëꞌ nu naꞌ Dios. Tsaz nabagaꞌ zxguiaꞌ nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Cni gnëꞌ Jesús le taꞌnë́ꞌ queëꞌ bönniꞌ gdauꞌ usëdi naꞌ, taꞌnë́ꞌ: “Dzag Lëꞌ tuꞌ xöhuiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Niꞌr guladxinëꞌ ga zoëꞌ Jesús yuguꞌ bönniꞌ böchëꞌë lencaꞌ xnëꞌë. Gulacuꞌë löꞌal len gulasölëꞌë nu tsajlídz Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Glë Jesús bunách zian naꞌ röꞌgac cuitiëꞌ, taꞌnë́ꞌ: ―Nacuꞌë löꞌal yuguꞌ bönniꞌ böchuꞌu lencaꞌ xnaꞌu, tuꞌlidzëꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bubiꞌë didzaꞌ Jesús, gudxëꞌ lequëꞌ: ―¿Nuzxa caz naꞌ xnaꞌa, len nupxcz bönniꞌ böchaꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Niꞌr buyúëꞌ nup naꞌ röꞌgac gdu cuitiëꞌ, rnëꞌ: ―Gul‑yutscaꞌ. Nup ni nacgac ca xnaꞌa len yuguꞌ bönniꞌ böchaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nu run ca rëꞌnnëꞌ Dios, nu ni nac ca biꞌi böchaꞌa len biꞌi zanaꞌ lencaꞌ xnaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Leyúbl gzu lahuëꞌ Jesús rusëdnëꞌ bunách ga nac raꞌ nis zxön. Guludúb ga zoëꞌ bunách zian atiꞌ grenëꞌ Jesús tu lëꞌi bárcodauꞌ zxoa lu nis naꞌ, len gröꞌë niꞌ, atiꞌ yúguꞌtë bunách naꞌ gulacuáꞌ luyú raꞌ nis naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zian le busëdnëꞌ lequëꞌ Jesús, benëꞌ lsaquiꞌ. Tsal niꞌ rusëdnëꞌ lequëꞌ, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gul‑zë́ nagliꞌ didzaꞌ ni. Brujëꞌ bönniꞌ guz, zjësiëꞌ xseydauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tsal niꞌ rusiëꞌ, glas raꞌ nöz laꞌgac xseydauꞌ naꞌ, atiꞌ guladxinbaꞌ bguindauꞌ, glëꞌjbaꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Glas ga röꞌ guiöj ga cutu röꞌ szxöni yu yelaꞌgac xseydauꞌ naꞌ. Bayö́n gulalén xseydauꞌ naꞌ le cutu röꞌ szxöni yu. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Niꞌr catiꞌ blen gbidz, buquexuꞌ lei, atiꞌ gbidx, le cutu nun luí ga rëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Glas ga tuꞌlén lba yötsiꞌ yelaꞌgac xseydauꞌ naꞌ. Catiꞌ gulalén xseydauꞌ naꞌ, gululén caꞌ lba yötsiꞌ naꞌ len gularöli lei, atiꞌ cutu bi bunö́dzj lë naꞌ bësiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Glas ga nac luyú dxiꞌa yelaꞌgac xseydauꞌ naꞌ, atiꞌ gulazxö́n len xtsaꞌ raꞌ gulabö́ꞌ. Gulunö́dzj lë naꞌ bësiëꞌ. Tu dxiguꞌ xseydauꞌ naꞌ bësiëꞌ bunö́dzj yechí uruáꞌ xseydauꞌ caꞌ. Yetú bunö́dzj yetsonnlalj caꞌ atiꞌ yetú naꞌ bunö́dzj yetú gayuáꞌ caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Niꞌr gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Nu zoa nag len ryöni ral‑laꞌ uzë́ nag. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Catiꞌ chbugaꞌnëꞌ tuzëꞌ Jesús, guladxín ga zoëꞌ nup daꞌgac Lëꞌ, nungac tsazxö́n idxínnutëꞌ bönniꞌ usë́d queëꞌ atiꞌ gulanabnëꞌ Lëꞌ bi rëꞌni gna lë naꞌ benëꞌ lsaquiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Lbiꞌiliꞌ nadél‑liꞌliꞌ tséjniꞌliꞌ le nagachiꞌ ca rna bëꞌë Dios, san nup naꞌ cunacgac tuz len rëꞌu, yúguꞌtë ruíꞌlenaꞌ lequëꞌ didzaꞌ yuguꞌ le runaꞌ lsaquiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Cni runaꞌ quië utság lë naꞌ nayúj lu guich laꞌy, rna: “Luyúëꞌ len cutu laꞌléꞌinëꞌ. Luzë́ nagquëꞌ len cutu laꞌyéjniꞌnëꞌ len cutu lubíꞌi ládxiꞌquëꞌ quië gac unít lahuaꞌ lequëꞌ ca nac dul‑laꞌ nabágaꞌquëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gudxëꞌ caꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rnëꞌ: ―¿Naruꞌ cu réjniꞌtsaliꞌ lë naꞌ benaꞌ lsaquiꞌ? ¿Nacxcz gac tséjniꞌliꞌ yezicaꞌ le gunaꞌ lsaquiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Naquëꞌ nu ruzë́ didzaꞌ bönniꞌ guz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nacgac laꞌgac bunách ca xseydauꞌ naꞌ glas raꞌ nöz. Taꞌyönnëꞌ xtidzëꞌë Dios, len ca taꞌyönznëꞌ caꞌ, laꞌ zaꞌtë Satanás tuꞌ xöhuiꞌ, rgua didzaꞌ naꞌ bdxin lu icj ládxiꞌdauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nacgac yelaꞌgac bunách ca xseydauꞌ naꞌ glas ga röꞌ guiöj. Taꞌyönnëꞌ didzaꞌ naꞌ atiꞌ lu yöl‑laꞌ rudziji quequëꞌ taꞌziꞌë lei. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Cutu ryaz icj ládxiꞌdauꞌquëꞌ atiꞌ tu chiꞌz taꞌdë́ꞌë lei. Catiꞌ bi rac quequëꞌ o zoa nu rbia ladxiꞌ lequëꞌ le taꞌdë́ꞌë didzaꞌ naꞌ, laꞌ tuꞌhuöatë ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nacgac yelaꞌgac bunách ca xseydauꞌ naꞌ glas ga naꞌ tuꞌlén lba yötsiꞌ. Taꞌyönnëꞌ didzaꞌ naꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","san tuiꞌ ládxiꞌquëꞌ le nacgac qui yödzlyú ni. Nazíꞌ yéꞌicnëꞌ le nadxiꞌicnëꞌ yuguꞌ yöl‑laꞌ tsahuiꞌ len taꞌzë́ ládxiꞌquëꞌ yuguꞌ le dë. Taꞌyáz icj ládxiꞌdauꞌquëꞌ yúguꞌtë lë ni len tuꞌsnít didzaꞌ naꞌ, cui gun dxin lu icj ládxiꞌdauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nacgac yelaꞌgac bunách ca xseydauꞌ naꞌ glas ga nac luyú dxiꞌa. Taꞌyönnëꞌ didzaꞌ naꞌ len taꞌzíꞌ lu naꞌquëꞌ lei, atiꞌ run dxin lu icj ládxiꞌdauꞌquëꞌ. Nacgac laꞌgac bunách cni ca xseydauꞌ naꞌ gulunö́dzj yechí uruáꞌ hueaj. Nacgac yelaꞌgac ca xseydauꞌ naꞌ gulunö́dzj yetsonnlalj caꞌ, atiꞌ nacgac yelaꞌgac bunách ca xseydauꞌ naꞌ gulunö́dzj yetú gayuáꞌ caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Gudxëꞌ caꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rnëꞌ: ―¿Naruꞌ rgál‑laꞌruꞌ guiꞌ atiꞌ rudúsiꞌruꞌ lei tu guiꞌn o rguꞌruꞌ lei zxani le rátiꞌruꞌ? Cutu caꞌ runruꞌ cni san ruzoaruꞌ guiꞌ ga nac xtsaꞌ ga gunn yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yúguꞌtë le nagachiꞌ glaꞌ lahui atiꞌ yúguꞌtë le rac balánz laꞌrúj ga lnaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu zoa nag len ryöni ral‑laꞌ uzë́ nag. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gudxëꞌ caꞌ lequëꞌ: ―Gul‑güíꞌ ládxiꞌliꞌ le ryö́niliꞌ. Ca nac le rurixliꞌ, laꞌ leyz urixëꞌ queëliꞌ Dios atiꞌ gunnëꞌ queëliꞌ yelatiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nu dë qui, guꞌë qui yelatiꞌ, san nu cudë́ qui, laꞌz dui le dë qui, gdua. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Gnëꞌ caꞌ Jesús: ―Ca rac ni le rna bëꞌë Dios nac ca rac catiꞌ ruchijëꞌ zxoaꞌ xtil lu yu bönniꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chdzöꞌl rasiëꞌ len ryasëꞌ catiꞌ zaꞌ reníꞌ. Taꞌlén zxoaꞌ xtil naꞌ len taꞌzxö́n san cutu nöznëꞌ lëꞌ nacx rac taꞌzxö́n. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Laꞌ cuinzi luyú naꞌ ruxö́n le naduzgac luyú naꞌ, ziꞌal xyazi, niꞌr zaꞌ deu qui, len töd naꞌ cuia xuiꞌi nal lu deu qui. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Catiꞌ chnal xuiꞌi, laꞌ tseajtëꞌ tsajchuguëꞌ deu naꞌ le chbdxin dza uziꞌë xuiꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Gnëꞌ caꞌ Jesús: ―¿Bizxa caz gnaruꞌ ca rac ni le rna bëꞌë Dios? ¿Bizxa gunruꞌ lsaquiꞌ ca rac? ");
INSERT INTO zsrNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rac ca rac qui tu xseydauꞌ mostaza. Catiꞌ ryaz luyú nac xseydauꞌ nactër cuídiꞌ ca yúguꞌtë xseydauꞌ dzöꞌ luyú, ");
INSERT INTO zsrNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","san catiꞌ chnadúz, rlen len rzxöntër ca yúguꞌtë guixiꞌ cuan röꞌgac luyú. Tsca run yanaꞌ zxuzaꞌ nëꞌi, gac laꞌdxinbaꞌ bguindauꞌ ludxía lidxcbaꞌ lu zxul qui. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cni guc, busëdnëꞌ lequëꞌ Jesús, len zianr caꞌ le benëꞌ lsaquiꞌ tsca guc laꞌyéjniꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yúguꞌtë didzaꞌ bë́ꞌlenëꞌ bunách benëꞌ lsaquiꞌ atiꞌ yúguꞌtë didzaꞌ ni busálj laꞌnëꞌ, buzéjniꞌnëꞌ légaczëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Laꞌ dza naꞌz, catiꞌ gdzöꞌ, Jesús gudxëꞌ bönniꞌ daꞌquëꞌ Lëꞌ, rnëꞌ: ―Tö́dtscaꞌruꞌ yetsláꞌa nis zxön ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Niꞌr buláꞌalenëꞌ bunách zian nacuáꞌ niꞌ, atiꞌ gulusë́ꞌë bárcodauꞌ ga naꞌ chzoazëꞌ Jesús. Gulacuáꞌ caꞌ niꞌ yelaꞌgac bárcodauꞌ zjaclen lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gzu lau reycj böꞌ bdunuꞌ lu nis naꞌ, atiꞌ gdaꞌa nis lëꞌi bárcodauꞌ naꞌ. Caꞌ guc, zeaj rdzaꞌ nis lëꞌi bárcodauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dëꞌ rasiëꞌ Jesús lu xcugüëꞌ ga nac xtsaꞌl lëꞌi bárcodauꞌ naꞌ, atiꞌ guluspanëꞌ Lëꞌ, tëꞌ Lëꞌ: ―Bönniꞌ Usëdi. ¿Naruꞌ cu ruiꞌ ládxiꞌtsuꞌ netuꞌ? Huatcztuꞌ lu nis ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Niꞌr gyasëꞌ Jesús, len gna béꞌinëꞌ böꞌ naꞌ reycj, gnëꞌ: ―Cuꞌu bö. Gudxëꞌ caꞌ nis naꞌ, gnëꞌ: ―Dxiz gzoa. Gröꞌ dxi böꞌ naꞌ gyeycj len gzoa dxi lu nis zxön naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Niꞌr gudxëꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rnëꞌ: ―¿Bizx quië radxi rdzö́biliꞌ cni? ¿Naruꞌ cu réjlëꞌliꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Niꞌ tádxinëꞌ glë lzaꞌquëꞌ tuëꞌ yetúëꞌ: ―¿Nuzxa caz bönniꞌ ni? Tun ca rna xtidzëꞌë böꞌ reycj len nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Niꞌr guladxinëꞌ Jesús len bönniꞌ daꞌquëꞌ Lëꞌ yetsláꞌa nis zxön ga nac lu xyugac bunách Gadara. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Catiꞌ burujëꞌ Jesús lëꞌi bárcodauꞌ naꞌ, laꞌ dutsagtëꞌ Lëꞌ tu bönniꞌ r‑rujëꞌ bloj ga nacuáꞌ yeru ba. Bönniꞌ ni yuꞌu lëꞌ böꞌ xöhuiꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","len nun xlatjëꞌ ga naꞌ nacuáꞌ yeru ba. Nutu nu guc gugaꞌ bönniꞌ naꞌ, len clëg len du guia. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zian lzu guluzóëꞌ breguiꞌ guia yen nëꞌë len niꞌë len glúguëꞌë lëꞌ du guia. Yuguꞌ du guia naꞌ bulë́ꞌë atiꞌ breguiꞌ guia naꞌ buzxuzxjëꞌ. Cutu rzáquiꞌnëꞌ nu bönniꞌ gna béꞌinëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rdáteczëꞌ rbödxyëꞌë rël len të dza ga naꞌ nacuáꞌ yeru ba len gap nac lu guíꞌadauꞌ, run huëꞌ cuinëꞌ yuguꞌ lu guiöj dzöꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Catiꞌ bléꞌinëꞌ zëꞌë ziꞌtuꞌ Jesús, jaréluꞌë gyijëꞌ ga naꞌ zëꞌë Jesús, atiꞌ buzechu zxibëꞌ lahuëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bëꞌë zidzj didzaꞌ, rëꞌ Jesús: ―¿Bizxa ral‑laꞌa quiuꞌ Jesús, Zxiꞌnëꞌ Dios náctërëꞌ blau? Niꞌa queëꞌ Xanruꞌ Dios rátaꞌyuaꞌ lauꞌ, cutu usacaꞌ ziꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Cni gnëꞌ le chgudxëꞌ böꞌ xöhuiꞌ naꞌ Jesús: ―Liꞌ, böꞌ xöhuiꞌ, burúj lu bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús gnabnëꞌ lei, rnëꞌ: ―¿Bi leuꞌ? Bubíꞌi didzaꞌ lei, gudx Lëꞌ: ―Le Zian leaꞌ le nac ziantuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Gnab yechiꞌ Jesús cui gsölëꞌë yuguꞌ böꞌ xöhuiꞌ naꞌ ziꞌtuꞌ luyú niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nacuaꞌbaꞌ lu guíꞌadauꞌ niꞌz cuch zian, taꞌdabaꞌ tágubaꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Gulanáb yechiꞌ Jesús böꞌ xöhuiꞌ naꞌ, taꞌná: ―Bsölaꞌ netuꞌ ga niꞌ dzöꞌbaꞌ cuch zian. Bëꞌ netuꞌ latj tsajtsúꞌugactuꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Laꞌ bëꞌtëꞌ leygac latj Jesús atiꞌ gularúj böꞌ xöhuiꞌ naꞌ, yajtsuꞌugac cuch zian naꞌ, atiꞌ gulaxítiꞌbaꞌ cuch zian naꞌ, yajbixcbaꞌ ga nac raꞌ guiꞌa, yajtsuꞌucbaꞌ nis zxön. Lu nis zxön naꞌ gulayë́pibaꞌ nis, glatbaꞌ, len naccbaꞌ ca galj gayuaꞌbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Niꞌr gulazxúndj nup niꞌ glun chiꞌi cuch zian naꞌ, yajtíxjöiꞌcnëꞌ bunách lu yödz niꞌ lencaꞌ bunách nacuáꞌ ladj guixiꞌ niꞌ. Gularúj bunách lu yödz, zajyuquëꞌ bizxa naꞌ guc niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Catiꞌ guladxinëꞌ ga niꞌ zoëꞌ Jesús, gulaléꞌinëꞌ bönniꞌ naꞌ ziꞌal yuꞌugac lëꞌ böꞌ xöhuiꞌ. Bönniꞌ ni röꞌë niꞌ, nacuëꞌ lariꞌ len zoëꞌ dxíꞌadauꞌ, atiꞌ gladxi bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nup naꞌ gulaleꞌi le benëꞌ Jesús gulaguixjöiꞌ bunách naꞌ gularúj lu yödz ca naꞌ guc queëꞌ bönniꞌ naꞌ ziꞌal yuꞌugac lëꞌ böꞌ xöhuiꞌ, lencaꞌ ca guc quecbaꞌ cuch naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Niꞌr gulazú laugac bunách zian naꞌ táꞌtaꞌyuëꞌ lahuëꞌ Jesús urujëꞌ lu xyuquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Catiꞌ bubenëꞌ Jesús lëꞌi bárcodauꞌ, bönniꞌ naꞌ ziꞌal yuꞌugac lëꞌ böꞌ xöhuiꞌ zian, gútaꞌyuëꞌ lahuëꞌ Jesús guꞌë lëꞌ latj tséajlenëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús cutu bëꞌë lëꞌ latj, san gudxëꞌ lëꞌ: ―Böaj lidxuꞌ. Yajtixjöiꞌ yuguꞌ diꞌa dza quiuꞌ yuguꞌ le zxön benaꞌ quiuꞌ nedaꞌ, nacaꞌ Xanuꞌ, len ca benaꞌ buechiꞌ ladxaꞌa liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zhuöjëꞌ bönniꞌ naꞌ, ruzë́ꞌ didzaꞌ yuguꞌ yödz Decápolis ca nacgac le zxön benëꞌ queëꞌ Jesús, atiꞌ gulubani yúguꞌtë bunách nacuáꞌ yuguꞌ yödz niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Catiꞌ budxinëꞌ Jesús yetsláꞌa nis zxön naꞌ, niꞌr guludúb bunách zian ga naꞌ zoëꞌ raꞌ nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bidëꞌ caꞌ ga zoëꞌ Jesús bönniꞌ lëꞌ Jairo, bönniꞌ rna bëꞌë lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Catiꞌ bléꞌinëꞌ Jesús, buzechu zxibëꞌ lahuëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","len szxöni gútaꞌyuëꞌ lahuëꞌ, rnëꞌ: ―Chraqui gatbiꞌ biꞌi nguldauꞌ quiaꞌ. Gda gxoa naꞌu lëbiꞌ quië huöacbiꞌ len cui gatbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zéajlenëꞌ lëꞌ Jesús, atiꞌ zjaclen Jesús bunách zian, tuꞌquír Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Zoanu caꞌ niꞌ ngul, chnac chinnu iz réꞌinu, cutu ruhuíꞌi rön queënu qui huëꞌ quégaccznu ngul. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Szxöni chgzxacaꞌ gdiꞌnu lu naꞌquëꞌ zian bönniꞌ tuꞌún bunách. Daduz chbutönu dëra le dë queënu, cutu bi guclen lënu, san ryaliꞌ queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Catiꞌ byö́ninu tuiꞌ didzaꞌ bunách ca nac queëꞌ Jesús, gdödnu ladjl bunách zian naꞌ, bdxinnu zacaꞌ cúdzuꞌlëꞌ Jesús len gdannu lariꞌ nacuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cni bennu le rnanu: “Chquiꞌ canzaꞌ le nacuëꞌ, huöacaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Laꞌ buiꞌtë rön queënu atiꞌ ráquibeꞌinu chböacnu qui le guc queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Laꞌ gúquibeꞌitenëꞌ Jesús ben dxin yöl‑laꞌ huac queëꞌ, atiꞌ bueycjëꞌ, ruyúëꞌ bunách zian naꞌ, rnëꞌ: ―¿Nuzxa naꞌ gdan nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Niꞌr tëꞌ Lëꞌ bönniꞌ daꞌquëꞌ Lëꞌ, taꞌnë́ꞌ: ―Rléꞌicznuꞌ bunách zian ni tuꞌquír Liꞌ, len rnatsuꞌ: “¿Nuzxa naꞌ gdan nedaꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ruyúëꞌ Jesús gdu cuitiëꞌ quië gléꞌinëꞌ nuzxa naꞌ gdan Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Niꞌr gbígaꞌnu lahuëꞌ ngul naꞌ, rádxinu len rzxiznu le chnö́zinu bi naꞌ guc queënu, atiꞌ buzechu zxibnu lahuëꞌ Jesús, len gudxnu Lëꞌ gdutë le nacz. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús rëꞌ‑nu: ―Nguldauꞌ. Chböacuꞌ le réjlëꞌu nedaꞌ. Böaj lidxuꞌ gdu ladxuꞌu. Tsaz nuhuöacuꞌ qui le guc quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tsal niꞌ ruꞌë cni didzaꞌ Jesús, guladxín niꞌ nup narujgac lidxëꞌ bönniꞌ naꞌ rna bëꞌë lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, len tëꞌ bönniꞌ naꞌ: ―Chgutbiꞌ biꞌi nguldauꞌ quiuꞌ. Cutur upizxjnuꞌ Bönniꞌ Usëdi. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Cutu bëꞌ ladxëꞌë Jesús lë naꞌ taꞌnë́ꞌ, atiꞌ gudxëꞌ bönniꞌ uná bëꞌ naꞌ, rnëꞌ: ―Cutu gádxinuꞌ. Gyéjlëꞌzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Cutu bëꞌë latj Jesús tsjaclen Lëꞌ yezicaꞌr bunách, san légaczëꞌ Pedro len Jacobo, len Juan, böchëꞌë Jacobo naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Catiꞌ bdxinëꞌ lidxëꞌ bönniꞌ naꞌ rna bëꞌë ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, bléꞌinëꞌ rac rusbö́ lencaꞌ nup niꞌ taꞌbö́dx len nup taꞌbö́dx yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gyaziëꞌ Jesús len gudxëꞌ lequëꞌ: ―¿Bizx quië runliꞌ rusbö́ len rbödxliꞌ cni? Cutu natbiꞌ biꞌi nguldauꞌ ni. Raszbiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Niꞌr gulutitjëꞌ Jesús san Lëꞌ bubijëꞌ niꞌl yúguꞌtë bunách naꞌ atiꞌ bchëꞌë xuz xnaꞌbiꞌ biꞌi nguldauꞌ naꞌ lencaꞌ nup nacuaꞌlen Lëꞌ, gyaziëꞌ ga naꞌ dëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gdel‑lëꞌë naꞌbiꞌ biꞌi nguldauꞌ naꞌ len gudxëꞌ‑biꞌ: ―Talita, cumi. Didzaꞌ ni rna lu didzaꞌ xidzaꞌ: “Biꞌi nguldauꞌ. Gyas.” ");
INSERT INTO zsrNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Laꞌ gyástëbiꞌ biꞌi nguldauꞌ naꞌ len buzéꞌibiꞌ. Chyuꞌubiꞌ chinnu iz. Gulubani nup nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Niꞌr Jesús gna béꞌinëꞌ lequëꞌ nutu nu laꞌguíxjöiꞌnëꞌ lë naꞌ guc. Gudxëꞌ lequëꞌ: ―Gul‑güíꞌ le gágubiꞌ biꞌi nguldauꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Buzë́ꞌë niꞌ Jesús, budxinëꞌ ladzëꞌ, atiꞌ yjáclenëꞌ Lëꞌ bönniꞌ daꞌquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Catiꞌ bdxin dza laꞌy quequëꞌ bönniꞌ judío, gzu lahuëꞌ rusëdnëꞌ bunách Jesús ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios. Gulacuáꞌ niꞌ bunách zian taꞌyöni Lëꞌ. Gulubannëꞌ, taꞌnë́ꞌ: ―¿Gazxcz bzëdnëꞌ yuguꞌ lë ni bönniꞌ ni? ¿Bizxa caz yöl‑laꞌ rejniꞌi ni nadél‑liꞌnëꞌ? ¿Nacxcz runëꞌ le nacgac bëꞌ naꞌ zaꞌc yehuaꞌ yubá? ");
INSERT INTO zsrNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naquëꞌ bönniꞌ ni bëdx yag naꞌ, zxiꞌnnu María. Naquëꞌ bö́chiꞌquëꞌ Jacobo len José len Judas len Simón. Nacuáꞌlennu caꞌ rëꞌu ngul zanëꞌ. Qui lë ni naꞌ gulucaꞌnëꞌ Lëꞌ caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Niꞌr gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Gátiꞌtëz tunëꞌ ba laꞌn nu bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, san cutu tun Lëꞌ ba laꞌn bunách uládz queëꞌ len bunách diꞌa dza queëꞌ len bunách nacuáꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Qui lë ni naꞌ cutu guc gunëꞌ niꞌ Jesús nitú yöl‑laꞌ huac zxön. Tuz bunëꞌ nabábz bunách teꞌi, bxoa nëꞌë lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bubannëꞌ Jesús le cutaꞌyejlëꞌë Lëꞌ. Gdöd naꞌ gdödëꞌ yuguꞌ yödzdauꞌ nacuáꞌ zbiꞌil, rusëdnëꞌ bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Niꞌr bulidzëꞌ Jesús idxínnutëꞌ bönniꞌ daꞌquëꞌ Lëꞌ len gzu lahuëꞌ rsölëꞌë lequëꞌ chop hueajquëꞌ. Budödëꞌ lu naꞌquëꞌ yöl‑laꞌ uná bëꞌ lubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gna béꞌinëꞌ lequëꞌ cutu bi luꞌë laꞌ nöz, ni yöxj, ni yöt, ni dumí cutu laꞌguꞌë bzud quequëꞌ, san tuz xuyagdauꞌ luꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ral‑laꞌ ludë́ꞌë lölquëꞌ, san clëg chop lariꞌ luxóa yenquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gudxëꞌ caꞌ lequëꞌ: ―Gátiꞌtëz ga tsazliꞌ tu yuꞌu, gul‑zóa yuꞌu naꞌ catiꞌ uzaꞌrliꞌ yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chquiꞌ tsazliꞌ tu yödz ga cutu lun lbiꞌiliꞌ ba laꞌn bunách lu yödz naꞌ, len cutu luzë́ nagquëꞌ xtídzaꞌliꞌ, gul‑rúj niꞌ len gul‑quíndj bëchtö daꞌ lalabliꞌ. Lë ni gac bëꞌ nabágaꞌquëꞌ zxguiaꞌ. Le nactë rëpaꞌ lbiꞌiliꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, laꞌzacaꞌ laꞌguíꞌir bunách lu yödz naꞌ ca laꞌzacaꞌ laꞌguíꞌi bunách Sodoma len Gomorra, yuguꞌ yödz naꞌ busnitiëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Niꞌr gularujëꞌ bönniꞌ daꞌquëꞌ Lëꞌ, yjenquëꞌ lban ca ral‑laꞌ lubíꞌi ládxiꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gulubijëꞌ caꞌ zian böꞌ xöhuiꞌ yuꞌugac bunách. Gulaguꞌë le za zian nup teꞌi, guluúnëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Byönnëꞌ Herodes, bönniꞌ rna bëꞌë, ca nac le runëꞌ Jesús, le rzë didzaꞌ gátiꞌtëz qui yöl‑laꞌ huac queëꞌ Jesús. Laꞌgac bunách taꞌná: ―Chbubanëꞌ lu yöl‑laꞌ gut Juan, bönniꞌ niꞌ buquilëꞌ bunách nis. Qui lë ni naꞌ napëꞌ yöl‑laꞌ huac runëꞌ yuguꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yelaꞌgac bunách taꞌná: ―Naquëꞌ Elías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. Yelaꞌgac bunách taꞌná: ―Naquëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios ca glaquëꞌ bönniꞌ dza niꞌtë gluꞌë didzaꞌ uláz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Catiꞌ byönnëꞌ Herodes yuguꞌ lë ni, gnëꞌ: ―Naquëꞌ Juan, bönniꞌ naꞌ brixaꞌ yenëꞌ. Chbubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Cni gnëꞌ Herodes le bsölëꞌë lëczëꞌ nup yajxöngac Juan naꞌ, glúguëꞌë lëꞌ du guia lu yuꞌu lidx guia. Cni benëꞌ Herodes le rleynu‑nëꞌ Juan naꞌ Herodías, ngul naꞌ gucnu ngul queëꞌ Felipe, böchëꞌë Herodes naꞌ. Herodes gduëꞌ‑nu Herodías naꞌ, len butság náꞌlenëꞌ‑nu. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan naꞌ gudxëꞌ Herodes: ―Cutu ral‑laꞌ sóalenuꞌ‑nu ngul queëꞌ böchuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Qui lë ni naꞌ gzu gröꞌnu Herodías, gúꞌninu bi gunnu queëꞌ Juan, le gúꞌninu gdö́dinu lëꞌ, san cutu bi gzxáquiꞌnu ");
INSERT INTO zsrNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","le rádxinëꞌ Juan Herodes, le nözcznëꞌ naquëꞌ Juan naꞌ tsahuiꞌ len laꞌy. Qui lë ni naꞌ ben chiꞌë lëꞌ len buzë́ naguëꞌ lëꞌ gdu ladxëꞌë zal‑laꞌ lë naꞌ rnëꞌ Juan ben ga gröꞌë baguíꞌi Herodes naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Niꞌr bdxin tu dza gzxáquiꞌnu Herodías naꞌ, nac dza runëꞌ lni Herodes qui dza gyéꞌinëꞌ iz. Bupë́ꞌë le liꞌj lahuëꞌ bönniꞌ dë lu naꞌquëꞌ uláz queëꞌ len bönniꞌ nacuꞌë lu naꞌquëꞌ bönniꞌ rjaquëꞌ gdil‑l lencaꞌ bönniꞌ nacquëꞌ blau luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Gyazbiꞌ biꞌi ngul queënu Herodías ga naꞌ tiꞌj tahuëꞌ len byaꞌabiꞌ lauquëꞌ. Bdzag ladxëꞌë Herodes ca runbiꞌ, len guladzág ládxiꞌgac caꞌ nup tëꞌj tágulen lëꞌ. Niꞌr gudxëꞌ‑biꞌ biꞌi ngul naꞌ Herodes, gnëꞌ: ―Gnab bi rëꞌnnuꞌ gunnaꞌ quiuꞌ, atiꞌ gunaꞌ caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Benëꞌ tsutsu xtidzëꞌë, gudxëꞌ‑biꞌ: ―Niꞌa queëꞌ Xanruꞌ Dios gunnaꞌ quiuꞌ bítiꞌtëz bi gnabuꞌ ga gdxintë gatsj ga rna bëꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Burujbiꞌ lëbiꞌ, gudxbiꞌ xnaꞌbiꞌ: ―¿Bizxa gnabtsaꞌ? Lënu gudxnu‑biꞌ: ―Icjëꞌ Juan, bönniꞌ buquilëꞌ bunách nis, gnabuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Laꞌ buáztëbiꞌ ga naꞌ zoëꞌ Herodes, rëbiꞌ‑nëꞌ: ―Rëꞌndaꞌ gxuꞌ quiaꞌ naꞌa lu zxigaꞌ zxön icjëꞌ Juan, bönniꞌ naꞌ buquilëꞌ bunách nis. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Niꞌr buiꞌnnëꞌ Herodes, san le gneynëꞌ Dios, len le gulayöni caꞌ nup tágulen lëꞌ, cutu guꞌnnëꞌ nit xtidzëꞌë naꞌ gzxiꞌ lu nëꞌë queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herodes laꞌ bsö́laꞌtëꞌ bönniꞌ rijëꞌ gdil‑l zoëꞌ run chiꞌë, gna béꞌinëꞌ lëꞌ tsajxiꞌë icjëꞌ Juan. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Gyijëꞌ lidx guia bönniꞌ naꞌ rijëꞌ gdil‑l, yajrixëꞌ yen Juan naꞌ, atiꞌ buꞌë icjëꞌ, nuxóëꞌ lei lu zxigaꞌ zxön. Budödëꞌ lei lu naꞌbiꞌ biꞌi ngul naꞌ, atiꞌ lëbiꞌ bunödzjbiꞌ queënu xnaꞌbiꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Catiꞌ gulayönnëꞌ didzaꞌ chguc lë naꞌ bönniꞌ daꞌquëꞌ Juan naꞌ, guladxinëꞌ niꞌ len guluúꞌë lëꞌ, yajcáchiꞌquëꞌ lëꞌ yeru ba. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gdöd niꞌ guludubëꞌ ga zoëꞌ Jesús bönniꞌ gbaz queëꞌ, len gulaguíxjöiꞌnëꞌ Lëꞌ yúguꞌtë le glunëꞌ len yuguꞌ le gulusëdnëꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nacuáꞌ niꞌ bunách zian, nup zaꞌc len nup zjac, ga bdxintë cutur dë latj lahuëꞌ yöt Jesús len bönniꞌ daꞌquëꞌ Lëꞌ. Qui lë ni naꞌ gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑dá. Huayeajczruꞌ ga nac latj caꞌz, uzíꞌ ládxiꞌruꞌ tu chiꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Laꞌ légaczëꞌ yjaquëꞌ tu lëꞌi bárcodauꞌ, guladxinëꞌ tu latj caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gulaleꞌi lequëꞌ zjaquëꞌ niꞌ bunách zian len núnbëꞌgac Jesús. Qui lë ni naꞌ jaréluꞌquëꞌ yjaquëꞌ niꞌ bönniꞌ yúguꞌtë yödz niꞌ, gulazëꞌi níꞌaquëꞌ, atiꞌ guladxinëꞌ niꞌ zíꞌatël ca Jesús len yuguꞌ bönniꞌ daꞌquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Catiꞌ burujëꞌ Jesús lëꞌi bárcodauꞌ naꞌ, bléꞌinëꞌ bunách zian naꞌ atiꞌ buechiꞌ ladxëꞌë lequëꞌ le nacquëꞌ ca böꞌcuꞌ zxílaꞌdauꞌ cuzóa nu uyú lecbaꞌ. Gzu lahuëꞌ zian le rusëdnëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Catiꞌ chrdzöꞌ dza naꞌ, guladxinëꞌ ga zoëꞌ Jesús bönniꞌ daꞌquëꞌ Lëꞌ, tëꞌ Lëꞌ: ―Chrdzöꞌ atiꞌ latj caꞌz nac ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bsölaꞌ bunách zian ni tsjac yuguꞌ yuꞌudauꞌ len yuguꞌ yödzdauꞌ nacuáꞌ zbiꞌil, tsjö́ꞌugac yöt, le cutu bi dë ni le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bubiꞌë didzaꞌ Jesús, gudxëꞌ lequëꞌ: ―Gul‑güíꞌ le lahuëꞌ lbiꞌiczliꞌ. Glëꞌ Lëꞌ: ―¿Naruꞌ tsjö́ꞌutsatuꞌ yöt xtil lazxjruꞌ qui gdu xunuꞌ beoꞌ, atiꞌ güiꞌtuꞌ lahuëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús gudxëꞌ lequëꞌ: ―¿Balx yöt xtil dë queëliꞌ? Gul‑tsajyutscaꞌ. Catiꞌ chnözcnëꞌ, tëꞌ Lëꞌ: ―Gayuꞌz yöt xtil dë, len chopzbaꞌ böl dëbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Niꞌr gna bëꞌë Jesús lunëꞌ ga laꞌbö́ꞌ bunách zian naꞌ, laꞌcuꞌë tu cuia hueajquëꞌ ga nac lachiꞌ lu dacaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gulacuꞌë tu cuia hueajquëꞌ, tu gayuáꞌ hueajquëꞌ len chiʉ́n hueajquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Niꞌr gdel‑lëꞌë Jesús igáyuꞌtë yöt xtil naꞌ len gropbaꞌ böl naꞌ. Buyúëꞌ zacaꞌ luzxbá len gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ yöt xtil naꞌ len bëꞌë quequëꞌ bönniꞌ usë́d queëꞌ quië laꞌguisiëꞌ quegac bunách zian naꞌ. Gdisiëꞌ caꞌ gróptëbaꞌ böl naꞌ quequëꞌ yúguꞌtë bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Glahuëꞌ yúguꞌtëꞌ len guluhuöljnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Niꞌr gulutubëꞌ le bizxj qui yöt xtil naꞌ len quecbaꞌ böl, chinnu bdöꞌa guludzë́ꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Glaquëꞌ ca chiʉ́n gayuꞌë bönniꞌ naꞌ glahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Laꞌ bentëꞌ Jesús ga gulabenëꞌ lëꞌi bárcodauꞌ bönniꞌ daꞌquëꞌ Lëꞌ, laꞌnörëꞌ lahuëꞌ, laꞌdödëꞌ lu nis zxön naꞌ, laꞌdxinëꞌ lu yödz Betsaida, tsal niꞌ Lëꞌ ruzeynëꞌ bunách zian naꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Catiꞌ chbudx buzeynëꞌ lequëꞌ didzaꞌ, gyijëꞌ tu lu guíꞌadauꞌ, atiꞌ niꞌ bulidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Catiꞌ chgul, zeaj bárcodauꞌ naꞌ gatsj lahuiꞌ nis zxön, atiꞌ zoëꞌ Jesús tuzëꞌ luyú bidx naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bléꞌinëꞌ lequëꞌ Jesús, baníg tuꞌsë́ꞌë bárcodauꞌ naꞌ le reycj böꞌ zaꞌ ga naꞌ taꞌdödëꞌ. Gdöd ladxiꞌ yël bdxinëꞌ Jesús ga naꞌ nacuꞌë, rzëꞌi niꞌë lu nis zxön naꞌ, atiꞌ guꞌnnëꞌ tödzëꞌ ga naꞌ nacuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Catiꞌ gulaléꞌinëꞌ Lëꞌ rzëꞌi niꞌë lu nis zxön, gláquinëꞌ bxin naꞌ, len gulabödxyëꞌë ");
INSERT INTO zsrNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","le gulaléꞌinëꞌ Lëꞌ yúguꞌtëꞌ len gladxi guladzöbnëꞌ. Niꞌr laꞌ bulidztëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑típ ládxiꞌliꞌ. Nédaꞌczaꞌ. Cutu gádxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Grenëꞌ Jesús lëꞌi bárcodauꞌ ga naꞌ nacuꞌë, atiꞌ gröꞌ dxi böꞌ naꞌ reycj, atiꞌ lequëꞌ gulaníttsquinëꞌ gulubannëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Cutu taꞌyéjniꞌninëꞌ le ruluíꞌ lë naꞌ benëꞌ Jesús qui yöt xtil naꞌ. Niꞌ nac zid icj ládxiꞌdauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Guladödëꞌ yetsláꞌa nis zxön Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, guladxinëꞌ ga nac lu xyugac bunách Genesaret. Guludxiguëꞌë bárcodauꞌ luyú bidx niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Catiꞌ gulurujëꞌ lëꞌi bárcodauꞌ naꞌ, laꞌ guluúnbëꞌtë Jesús bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Gulaxitiꞌ bunách naꞌ, yjac yúguꞌtë yödzdauꞌ gdu zbiꞌil len gulazú lauquëꞌ djuaꞌquëꞌ ga zoëꞌ Jesús yúguꞌtë nup teꞌi, zxoagac yuguꞌ le deycni, atiꞌ guladxinëꞌ gátiꞌtëz taꞌyönnëꞌ zoëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gátiꞌtëz ga rdödëꞌ Jesús, yuguꞌ lu yödzdauꞌ len yuguꞌ yödz zxön len yuguꞌ yuꞌudauꞌ, tuꞌcuꞌë gap nac laꞌ nöz len gap nac lu yëꞌy nup teꞌi quequëꞌ, len táꞌtaꞌyuëꞌ lahuëꞌ Jesús guꞌë lequëꞌ latj laꞌganzëꞌ tuiꞌi lariꞌ nacuëꞌ. Guluhuöactë dxíꞌadauꞌ yúguꞌtë nup naꞌ gulagán lariꞌ naꞌ nacuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Niꞌr guludubëꞌ ga zoëꞌ Jesús laꞌquëꞌ bönniꞌ gdauꞌ fariseo len laꞌquëꞌ bönniꞌ gdauꞌ usëdi, narujquëꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bönniꞌ gdauꞌ ni gulaléꞌinëꞌ bönniꞌ usë́d queëꞌ Jesús tahuëꞌ yöt, cunadxíꞌagac naꞌquëꞌ, lë naꞌ rna: cutu nayargac ca nalëbcnëꞌ tunëꞌ. Qui lë ni naꞌ gulanë́ꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tunëꞌ bönniꞌ gdauꞌ fariseo naꞌ len yezicaꞌ bunách judío ca glëbcnëꞌ glunëꞌ xuz xtauꞌquëꞌ, len chquiꞌ cutu taꞌguíb naꞌquëꞌ zian lzu ca naꞌ nalëbcnëꞌ tunëꞌ, cutu caꞌ tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Catiꞌ tuꞌdxinëꞌ rjö́ꞌuquëꞌ lu yëꞌy, chquiꞌ cutu taꞌguibëꞌ lë naꞌ ca nalëbcnëꞌ tunëꞌ, cutu caꞌ tahuëꞌ. Zianr caꞌ tunëꞌ, yuguꞌ le nalëbcnëꞌ tunëꞌ, taꞌguibëꞌ zxigaꞌ yöꞌön, len yuguꞌ zxigaꞌ guia, len yuguꞌ le tátiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Qui lë ni naꞌ gulanabnëꞌ Jesús yuguꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ tuꞌsëdi, taꞌnë́ꞌ: ―¿Naruꞌ cutu tunëꞌ bönniꞌ usë́d quiuꞌ ca glëbcnëꞌ glunëꞌ xuz xtauꞌruꞌ, san tahuëꞌ yöt cunadxíꞌagac naꞌquëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Lbiꞌiliꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Nactë le gdíxjöꞌë queëliꞌ Isaías, bönniꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. Buzujëꞌ lu guich, gnëꞌ: Bunách ni, len rúꞌagacz tun nedaꞌ ba laꞌn, Clëg gdu ládxiꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Daduz nac yöl‑laꞌ ba taꞌguꞌë nedaꞌ Le tuꞌsëdnëꞌ le taꞌná bëꞌ bunách, Clëg zxba quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Cni nac, le rucaꞌnliꞌ le gna bëꞌë Dios, atiꞌ runliꞌ yuguꞌ le nazíꞌ láhuiliꞌ lu naꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Gudxëꞌ caꞌ lequëꞌ: ―Gdu rucaꞌnliꞌ caꞌz le gna bëꞌë Dios quië gunliꞌ ca nac le nalë́biliꞌ runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés gnëꞌ cni: “Ben ba laꞌn xuz xnaꞌu.” Gnëꞌ caꞌ: “Nu ulídz ziꞌ xuz o xnëꞌi, gul‑dö́ditë nu naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lbiꞌiliꞌ rnaliꞌ cni: “Chquiꞌ nu bönniꞌ guiëꞌ xuzëꞌ o xnëꞌë: ‘Cutu gac bi gunnaꞌ queëliꞌ, le nac Corbán’, le rna lu didzaꞌ xidzaꞌ: ‘Le nuzóaꞌ quizi queëꞌ Dios’,” ");
INSERT INTO zsrNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","niꞌr rnaliꞌ: “Cutu run bayúdx bi gunëꞌ quegac xuz xnëꞌë bönniꞌ naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Cni nac, rucaꞌnliꞌ caꞌz xtidzëꞌë Dios quië gunliꞌ le nalë́biliꞌ runliꞌ, yuguꞌ le rudödliꞌ lu naꞌgac zxiꞌn xsoaliꞌ. Zianr caꞌ le cni runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Niꞌr Jesús bulidzëꞌ bunách zian naꞌ nacuáꞌ niꞌ, rëꞌ lequëꞌ: ―Gul‑zë́ nagliꞌ didzaꞌ guꞌa, yúguꞌtëliꞌ, len gul‑tsejniꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Cutu bi dë le ryaz bönniꞌ le gac gun ga cunaquëꞌ dxiꞌa lahuëꞌ Dios, san le r‑ruj lëꞌ, lë ni gac gun ga cunaquëꞌ dxiꞌa lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chquiꞌ zoa nagliꞌ quië yö́niliꞌ, gul‑zë́ nagliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Catiꞌ buláꞌalenëꞌ bunách zian naꞌ Jesús len gyaziëꞌ tu yuꞌu, gulanabnëꞌ Lëꞌ bönniꞌ usë́d queëꞌ ca nac lë naꞌ benëꞌ lsaquiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús gudxëꞌ lequëꞌ: ―¿Ryadzjtsa caꞌ queëliꞌ yöl‑laꞌ rejniꞌi? ¿Naruꞌ cu réjniꞌiliꞌ, yúguꞌtë le ryaz bönniꞌ, cutu gac gun ga cunaquëꞌ dxiꞌa lahuëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nac cni le cutu ryaz icj ládxiꞌdauꞌhuëꞌ, san lëꞌëzëꞌ ryaz, len rurúj lëꞌë. Le gnëꞌ cni Jesús, buluiꞌinëꞌ rëꞌu nac dxiꞌa yúguꞌtë le riꞌj ráguruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gnëꞌ caꞌ Jesús: ―Le r‑ruj bönniꞌ run ga cunaquëꞌ dxiꞌa lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cni nac, le taꞌrúj icj ládxiꞌdauꞌquëꞌ bönniꞌ yuguꞌ le taꞌzáꞌ ládxiꞌquëꞌ le nac xöhuiꞌ, yuguꞌ le tun ga tunëꞌ dul‑laꞌ taꞌguitsjëꞌ zxba qui yöl‑laꞌ nutság naꞌ len yuguꞌ le cunác. Tun ga tuꞌdöddëꞌ bunách ");
INSERT INTO zsrNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","len taꞌbanëꞌ, len taꞌzë́ ládxiꞌquëꞌ le dë qui lzaꞌquëꞌ, len tuꞌë döꞌ, len taꞌzíꞌ yëꞌë, len tuꞌzxë́ꞌë, len taꞌnë́ꞌ qui lzaꞌquëꞌ, len tun ba zxön cuinquëꞌ, len tunëꞌ le cunözi. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yúguꞌtë le xöhuiꞌ cni taꞌrúj icj ládxiꞌdauꞌhuëꞌ bönniꞌ len tun ga cunaquëꞌ dxiꞌa lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Buzë́ꞌë niꞌ Jesús, bdxinëꞌ gal‑laꞌ ga nacuáꞌ yödz Tiro len yödz Sidón. Niꞌ gyaziëꞌ tu yuꞌu len guꞌnnëꞌ nutu nu gnözi, san cutu caꞌ guc ucachiꞌ cuinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Byö́ninu didzaꞌ rzë ca nac queëꞌ Jesús ngul, zoabiꞌ biꞌi nguldauꞌ queënu, yuꞌu lëbiꞌ böꞌ xöhuiꞌ, atiꞌ laꞌ bídtënu ga zoëꞌ Jesús, len buzechu zxibnu xniꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ngul ni cutu nacnu judío, san nababnu bunách Sirofenicia. Gútaꞌyunu lahuëꞌ Jesús ubijëꞌ böꞌ xöhuiꞌ naꞌ yuꞌu‑biꞌ biꞌi nguldauꞌ queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Niꞌr gudxëꞌ‑nu Jesús, rnëꞌ: ―Bëꞌ latj luhuö́lj ziꞌal nup nacgac ca zxiꞌn xan yuꞌu, le cutu nac dxiꞌa uguaruꞌ yöt quecbiꞌ biꞌi naꞌ len chuꞌnruꞌ lei laucbaꞌ bö́ꞌcuꞌdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bubiꞌinu didzaꞌ ngul naꞌ, gudxnu Jesús: ―Ja, Xan, san yuguꞌ bö́ꞌcuꞌdauꞌ nacuaꞌbaꞌ zxani ga tágubiꞌ, tágubaꞌ le bizxj tuꞌhuö́xj ga naꞌ tágubiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Niꞌr gudxëꞌ‑nu Jesús, rnëꞌ: ―Le gnauꞌ cni, huac huöjuꞌ. Chburúj böꞌ xöhuiꞌ naꞌ gyuꞌu‑biꞌ biꞌi nguldauꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Catiꞌ budxinnu lidxnu, bléꞌinu‑biꞌ biꞌi nguldauꞌ queënu naꞌ, dëbiꞌ lu daꞌa len chnurúj böꞌ xöhuiꞌ naꞌ gyuꞌu lëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Burujëꞌ Jesús latj naꞌ nabáb yödz Tiro atiꞌ gdödëꞌ gap dë yödz Sidón len yuguꞌ yödz Decápolis, bdxinëꞌ raꞌ nis zxön qui Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bunách niꞌ djuaꞌgac ga zoëꞌ Jesús tuëꞌ bönniꞌ nacödzuëꞌ len curnë́ꞌ, táꞌtaꞌyuëꞌ lahuëꞌ Jesús gxoa nëꞌë lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bubijëꞌ lëꞌ tslaꞌl Jesús ladj bunách naꞌ, atiꞌ bnëꞌë xbönniꞌ nëꞌë yeru naguëꞌ bönniꞌ naꞌ. Gruꞌnëꞌ zxö́naꞌdauꞌ len gdanëꞌ ludxëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Niꞌr buyúëꞌ luzxbál len gnë ladxëꞌë, rnëꞌ: ―Efata. Didzaꞌ hebreo ni rna lu didzaꞌ xidzaꞌ: “Gyalj”. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Laꞌ böaljtë naguëꞌ len laꞌ buguitjtë ludxëꞌë, gnëtëꞌ dxíꞌadauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Gna béꞌinëꞌ lequëꞌ Jesús nutu nu lëꞌ caꞌ, san tsca gna béꞌinëꞌ lequëꞌ, guluzë́tërëꞌ caꞌ didzaꞌ qui lë naꞌ benëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gulubannëꞌ, taꞌnë́ꞌ: ―Dxíꞌadauꞌ runëꞌ yúguꞌtë. Runëꞌ ga tuꞌyöni nup glac cödzu len ga tuꞌhuíꞌ didzaꞌ nup cugúc laꞌnë́. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yuguꞌ dza niꞌz guludúb ga zoëꞌ Jesús bunách zian. Le cudë́ le lahuëꞌ, Jesús bulidzëꞌ bönniꞌ usë́d queëꞌ len bë́ꞌlenëꞌ lequëꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Gudxëꞌ lequëꞌ: ―Ruhuechiꞌ ladxaꞌa bunách zian ni le chnac tsonn dza nacuáꞌlenëꞌ nedaꞌ ni len cutu dë le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Chquiꞌ usölaꞌa lequëꞌ lidxquëꞌ taꞌdunzëꞌ caꞌ, hualaꞌcuídiꞌnëꞌ laꞌ nöz, le zaꞌquëꞌ ziꞌtuꞌ laꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Gulubiꞌë didzaꞌ bönniꞌ usë́d queëꞌ, tëꞌ Lëꞌ: ―¿Bizxa ugágutsaruꞌ bunách guizx yu ni, ga ni nac latj caꞌz? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―¿Balx yöt xtil dë queëliꞌ? Tëꞌ Lëꞌ: ―Gadxz. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Niꞌr gna béꞌinëꞌ bunách zian naꞌ Jesús laꞌbö́ꞌ lyu. Gdel‑lëꞌë gadx yöt xtil naꞌ atiꞌ gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ leygac len bëꞌë quequëꞌ bönniꞌ usë́d queëꞌ quië laꞌguisiëꞌ laugac bunách zian naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gutaꞌ caꞌ quequëꞌ tu chopbaꞌ böl cuidiꞌ. Jesús gudxëꞌ Dios: “Xclenuꞌ”, atiꞌ gna béꞌinëꞌ lequëꞌ laꞌguisiëꞌ lecbaꞌ caꞌ laugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Glahuëꞌ yúguꞌtë bönniꞌ naꞌ len guluhuöljnëꞌ. Niꞌr gulutubëꞌ le bizxj nagaꞌngac, atiꞌ guladzáꞌ gdu gadx bdöꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bönniꞌ naꞌ glahuëꞌ glaquëꞌ gdu ca choaꞌ gayuꞌë. Jesús busölëꞌë lequëꞌ lidxquëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atiꞌ grenëꞌ lëꞌi bárcodauꞌ tsazxö́n len yuguꞌ bönniꞌ usë́d queëꞌ, guladxinëꞌ lu xyugac bunách Dalmanuta. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Niꞌr guladxinëꞌ ga zoëꞌ Jesús bönniꞌ gdauꞌ fariseo len gulazú lauquëꞌ taꞌdíl‑lenëꞌ Lëꞌ didzaꞌ. Glëꞌnnëꞌ laꞌzíꞌ bëꞌë Jesús. Qui lë ni naꞌ gulanabnëꞌ Lëꞌ gunëꞌ tu le nac bëꞌ zaꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gnëtsca ladxëꞌë Jesús, rnëꞌ: ―¿Bizx quië taꞌnábitsa nedaꞌ bunách ni gunaꞌ tu le nac bëꞌ zaꞌ yehuaꞌ yubá? Le nactë rëpaꞌ lbiꞌiliꞌ, cutu caꞌ gléꞌiliꞌ nitú le nac bëꞌ zaꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Niꞌr buláꞌalenëꞌ lequëꞌ, bubenëꞌ lëꞌi bárcodauꞌ len zijëꞌ yetsláꞌa nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Glal ládxiꞌquëꞌ bönniꞌ usë́d queëꞌ Jesús luꞌë bi lahuëꞌ atiꞌ tuz yöt xtil dë lëꞌi bárcodauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Niꞌr buzéjniꞌnëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑sácaꞌtscaꞌ queëliꞌ. Gul‑gún chiꞌi cuinliꞌ cui siꞌliꞌ le nac ca xnëꞌi yöt xtil quequëꞌ bönniꞌ gdauꞌ fariseo len queëꞌ Herodes. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gulazú lauquëꞌ tuꞌë didzaꞌ bönniꞌ usë́d queëꞌ laꞌ légaczëꞌ, taꞌnë́ꞌ: ―Gnëꞌ cni le cudë́ yöt xtil gáguruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ráquibeꞌinëꞌ Jesús le taꞌnë́ꞌ, atiꞌ rëꞌ lequëꞌ: ―¿Bizx quië ruiꞌliꞌ cni didzaꞌ le cudë́ yöt xtil gáguruꞌ? ¿Naruꞌ cu réjniꞌtsaliꞌ len cu ráquibeꞌitsaliꞌ? ¿Ni nactsa zid icj ládxiꞌdauꞌliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Zoatsa yöj lauliꞌ len cutu rléꞌiliꞌ, len zoatsa guid nagliꞌ len cutu ryö́niliꞌ? ¿Naruꞌ cu rajnéytsaliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Catiꞌ niꞌ buzxuzxjaꞌ gayuꞌ yöt xtil atiꞌ glahuëꞌ chiʉ́n gayuꞌë bönniꞌ, ¿balx bdöꞌa budzaꞌliꞌ le bizxj butubliꞌ? Gulanë́ꞌ: ―Chinnu. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Gnëꞌ caꞌ Jesús: ―Catiꞌ niꞌ buzxuzxjaꞌ gadx yöt xtil atiꞌ glagu choaꞌ gayuáꞌ bunách, ¿balx bdöꞌa budzaꞌliꞌ le bizxj butubliꞌ? Gulanë́ꞌ: ―Gadx. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Niꞌr Jesús gudxëꞌ lequëꞌ: ―¿Naruꞌ cu réjniꞌtsaliꞌ naꞌa, bëꞌa didzaꞌ qui le tuꞌsëdnëꞌ bönniꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Catiꞌ guladxinëꞌ yödz Betsaida Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, guladxín ga zoëꞌ Jesús nup djuaꞌgac queëꞌ tu bönniꞌ nachúl lahuëꞌ, táꞌtaꞌyuëꞌ lahuëꞌ canëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús gdel‑lëꞌë nëꞌë bönniꞌ naꞌ nachúl lahuëꞌ, atiꞌ bchëꞌë lëꞌ niꞌl raꞌ yödz. Niꞌ bdxiëꞌ zxönaꞌ yöj lahuëꞌ len bxoa nëꞌë lëꞌ. Niꞌr gnabnëꞌ lëꞌ, rnëꞌ: ―¿Ba rléꞌinuꞌ latiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Buyúëꞌ bönniꞌ naꞌ nachúl lahuëꞌ, rnëꞌ: ―Rléꞌigacdaꞌ bunách, nalaꞌgac ca yuguꞌ yag, san taꞌdá bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Leyúbl bxoa nëꞌë yöj lahuëꞌ Jesús, atiꞌ buyutsquëꞌ bönniꞌ naꞌ nachúl lahuëꞌ atiꞌ böactë dxíꞌadauꞌ yöj lahuëꞌ. Naꞌa rléꞌinëꞌ dxíꞌadauꞌ yúguꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Niꞌr Jesús busölëꞌë lëꞌ lidxëꞌ, rnëꞌ: ―Cutu tsajdöduꞌ lahuiꞌ yödz, len nutu nu guiꞌu caꞌ lu yödz ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Gdöd naꞌ, guluzë́ꞌë niꞌ Jesús len yuguꞌ bönniꞌ usë́d queëꞌ, guladödëꞌ yödzdauꞌ nababgac Cesarea, ga naꞌ rna bëꞌë Filipo. Tsal niꞌ yuꞌuquëꞌ nöz, Jesús gnabi yudxëꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―¿Bizxa taꞌná quiaꞌ bunách nu nacaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Taꞌná laꞌgac bunách nacuꞌ Juan, bönniꞌ buquilëꞌ bunách nis. Taꞌná yelaꞌgac nacuꞌ Elías, bönniꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. Taꞌná yelaꞌgac nacuꞌ yetúëꞌ bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Niꞌr gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―Nazx lbiꞌiliꞌ, ¿bizxa rnaliꞌ quiaꞌ nu nacaꞌ? Bubiꞌë didzaꞌ Pedro, rnëꞌ: ―Liꞌ nacuꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Niꞌr gna béꞌinëꞌ lequëꞌ Jesús nutu nu laꞌguíxjöiꞌnëꞌ nu naquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Niꞌr gzu lahuëꞌ Jesús rusëdnëꞌ bönniꞌ daꞌquëꞌ Lëꞌ, rnëꞌ: ―Run bayúdx sacaꞌ quiꞌa nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. Luzóëꞌ nedaꞌ tslaꞌl bönniꞌ gul tuꞌzejniꞌi len yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi. Ludöddëꞌ nedaꞌ, san catiꞌ gac tsonn dza ubanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yalj lulu bë́ꞌlenëꞌ lequëꞌ didzaꞌ ni. Niꞌr bchëꞌë Jesús tslaꞌl Pedro len gzu lahuëꞌ rdil‑lëꞌ Lëꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bueycjëꞌ Jesús, buyúëꞌ yezícaꞌrëꞌ bönniꞌ usë́d queëꞌ, atiꞌ buzeynëꞌ bach Pedro, rnëꞌ: ―Bcuit ga zoaꞌ. Nacuꞌ ca Satanás, tuꞌ xöhuiꞌ. Le rzaꞌ ladxuꞌu cutu nac queëꞌ Dios, san ca taꞌzáꞌ ládxiꞌgac bunách nac. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Niꞌr Jesús bulidzëꞌ yuguꞌ bönniꞌ usë́d queëꞌ lencaꞌ bunách nacuáꞌ niꞌ, len gudxëꞌ lequëꞌ: ―Chquiꞌ rëꞌnnëꞌ tëꞌë nedaꞌ bönniꞌ, ral‑laꞌ uzóëꞌ tslaꞌl le rëꞌncznëꞌ bönniꞌ naꞌ, len gaquëꞌ ca bönniꞌ zijëꞌ zajtë́ꞌë lëꞌi yag cruz, atiꞌ niꞌr huac tëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nu bönniꞌ ruiꞌtsca ladxëꞌë yöl‑laꞌ naꞌbán queëꞌ, unitiëꞌ lei, san nu bönniꞌ unitiëꞌ yöl‑laꞌ naꞌbán queëꞌ le dëꞌë nedaꞌ o le dëꞌë didzaꞌ dxiꞌa quiaꞌ, uguel‑lëꞌë bönniꞌ ni yöl‑laꞌ naꞌbán queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Naruꞌ uziꞌtsëꞌ xbey bönniꞌ chquiꞌ utubëꞌ yúguꞌtë le dë yödzlyú ni, san unít cuinëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Cutu bi gac unödzjëꞌ bönniꞌ le huöaꞌui cuinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chquiꞌ zoëꞌ bönniꞌ rutuiꞌnëꞌ nedaꞌ len xtidzaꞌa laugac bunách ni nucaꞌngac Dios len tun dul‑laꞌ, lëzcaꞌ cni nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, utuiꞌdaꞌ bönniꞌ naꞌ catiꞌ guídlenaꞌ yöl‑laꞌ yeníꞌ queëꞌ Xuzaꞌ, dzagquëꞌ nedaꞌ gbaz laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Gudxëꞌ caꞌ lequëꞌ Jesús, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, nacuáꞌ ni nup cutu lat catiꞌ laꞌleꞌir duná bëꞌë luyú ni Dios, glaꞌ lahui yöl‑laꞌ uná bëꞌ zxön queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Catiꞌ chguc xop dza, Jesús bchëꞌë Pedro len Jacobo len Juan, atiꞌ légaczëꞌ yjaquëꞌ tu lu guiꞌa sib. Niꞌ bdzaꞌ ca rnaꞌ lahuëꞌ Jesús lauquëꞌ yonnëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gyëp yös yeníꞌ lariꞌ nacuëꞌ Jesús, guc chguichdauꞌz. Zxílaꞌdauꞌz guc, nutu nu raꞌ lariꞌ yödzlyú ni gac gun chguichdauꞌz ca guc lariꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Gululuíꞌ lauquëꞌ Elías len Moisés, tuíꞌlenëꞌ Jesús didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Niꞌr Pedro gudxëꞌ Jesús: ―Bönniꞌ Usëdi, bicaꞌ ba rëꞌu zoaruꞌ ni. Gúntscaꞌtuꞌ tsonn yuꞌu lágaꞌdauꞌ, tu quiuꞌ, yetú queëꞌ Moisés, len yetú queëꞌ Elías. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Cni gnëꞌ Pedro le cutu nöznëꞌ Pedro bi naꞌ rnëꞌ, le tádxinëꞌ bönniꞌ usë́d queëꞌ Jesús naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niꞌr gröꞌ böaj gluꞌu zxul lequëꞌ, len byön chiꞌi nu ruiꞌ didzaꞌ lu böaj naꞌ, rna: ―Bönniꞌ ni Zxiꞌnaꞌ. Nadxiꞌidaꞌ Lëꞌ. Gul‑zë́ nagliꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Laꞌ guluyutëꞌ san cutur nu taꞌléꞌinëꞌ. Tuzëꞌ Jesús zóalenëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsal niꞌ yuꞌuquëꞌ nöz, tuꞌdinniëꞌ guiꞌa sib naꞌ, gna béꞌinëꞌ lequëꞌ Jesús nutu nu lëꞌ caꞌ, lë naꞌ gulaléꞌinëꞌ, catiꞌ ubanrëꞌ lu yöl‑laꞌ gut Lëꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Qui lë ni naꞌ gulagúꞌz icjquëꞌ didzaꞌ ni bëꞌë, atiꞌ laꞌ légaczëꞌ taꞌnabi yudxi lzaꞌquëꞌ bizxa rëꞌni gna didzaꞌ naꞌ bëꞌë: ubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gulanabnëꞌ Jesús, taꞌnë́ꞌ: ―¿Bizx quië taꞌnë́ꞌ bönniꞌ gdauꞌ usëdi run bayúdx guidëꞌ Elías ziꞌal ca guidëꞌ Cristo? ");
INSERT INTO zsrNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Le nactë guidëꞌ ziꞌal Elías len ucuꞌë yúguꞌtë ca ral‑laꞌ gac. Naꞌa, ¿bizx quië nayúj lu guich lë naꞌ rna run bayúdx sacaꞌ quiꞌë szxöni Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, atiꞌ lucáꞌn Lëꞌ caꞌz bunách? ");
INSERT INTO zsrNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Rëpaꞌ lbiꞌiliꞌ: Chbidëꞌ Elías, atiꞌ glunëꞌ queëꞌ tsca glëꞌnnëꞌ, tsca nayúj lu guich laꞌy ca ral‑laꞌ gac queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Catiꞌ niꞌ guludxinëꞌ Jesús len bönniꞌ dzagquëꞌ Lëꞌ ga naꞌ nacuꞌë yezícaꞌrëꞌ bönniꞌ usë́d queëꞌ Jesús, gulaléꞌinëꞌ nacuáꞌ niꞌ bunách zian, atiꞌ taꞌdíl‑lenëꞌ yuguꞌ bönniꞌ usë́d queëꞌ naꞌ didzaꞌ bönniꞌ gdauꞌ tuꞌsëdi. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Catiꞌ gulaleꞌi Jesús bunách zian naꞌ, gulubannëꞌ len jaréluꞌquëꞌ zaꞌquëꞌ ga naꞌ zëꞌë, djödxquëꞌ Lëꞌ: ―Padiux. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Niꞌr gnabnëꞌ bönniꞌ usë́d queëꞌ naꞌ Jesús, rnëꞌ: ―¿Bizxa didzaꞌ naꞌ rdíl‑lenliꞌ lequëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bubiꞌë didzaꞌ bönniꞌ nutsëꞌë ladj bunách zian naꞌ, rnëꞌ: ―Bönniꞌ Usëdi, nachëꞌa‑biꞌ quiuꞌ ni biꞌi bö́nniꞌdauꞌ quiaꞌ, yuꞌu lëbiꞌ böꞌ xöhuiꞌ run ga curnëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Catiꞌ ryuꞌu lëbiꞌ böꞌ xöhuiꞌ naꞌ, ruríx rutúl lëbiꞌ lyu, atiꞌ rbia bdxinaꞌ zidiꞌ rúꞌabiꞌ len rutíl‑l láyaꞌbiꞌ. Qui lë ni naꞌ zeaj rdxitbiꞌ. Gnabcdaꞌ‑nëꞌ bönniꞌ usë́d quiuꞌ lubijëꞌ böꞌ xöhuiꞌ naꞌ, san cutu gulazáquiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Lbiꞌiliꞌ, curéjlëꞌliꞌ. ¿Gácaꞌxtëcz ral‑laꞌ sóalenaꞌ lbiꞌiliꞌ? ¿Gácaꞌxtëcz ral‑laꞌ guaꞌ glenaꞌ queëliꞌ? Gul‑dguáꞌ‑biꞌ quiaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Djuaꞌquëꞌ‑biꞌ ga naꞌ zoëꞌ. Catiꞌ bleꞌi Jesús böꞌ xöhuiꞌ naꞌ, laꞌ buxiztë lëbiꞌ. Gdzöꞌbiꞌ lyu, atiꞌ brix butúl lëbiꞌ, len gdxia bdxinaꞌ zidiꞌ rúꞌabiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Niꞌr gnabnëꞌ xuzbiꞌ biꞌi naꞌ Jesús, rnëꞌ: ―¿Gacaꞌx chguc rac cni queëbiꞌ? Rnëꞌ xuzbiꞌ naꞌ: ―Niꞌ náctëbiꞌ biꞌidauꞌ réꞌibiꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zian lzu r‑ruꞌn lëbiꞌ lu guiꞌ len lu nis quië gdödi lëbiꞌ. Qui lë ni naꞌ, chquiꞌ racuꞌ latiꞌ, buechiꞌ ladxiꞌ netuꞌ, gáclenuꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús gudxëꞌ lëꞌ: ―Chquiꞌ huac tséjlëꞌu, yúguꞌtë huac chquiꞌ tséjlëꞌu Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Laꞌ bëꞌtëꞌ zidzj didzaꞌ xuzbiꞌ biꞌi naꞌ, rnëꞌ: ―Réjlëꞌa. Guclen nedaꞌ quië tséjlëꞌraꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Catiꞌ bléꞌinëꞌ Jesús zaꞌc bunách zian, tuꞌquí tuꞌtsútsj Lëꞌ, buzeynëꞌ ba nadx böꞌ xöhuiꞌ, rëꞌ lei: ―Liꞌ, böꞌ xöhuiꞌ runuꞌ ga curnë́ len curyöni bunách, rna béꞌidaꞌ liꞌ urujuꞌ lu biꞌi ni, len cutur tsuꞌu lëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Grödxyaꞌa böꞌ xöhuiꞌ naꞌ, atiꞌ brix butultsca lëbiꞌ len burujtë, bucáꞌn biꞌi naꞌ ca biꞌi natcz. Caꞌ nac, gluiꞌ didzaꞌ zian bunách niꞌ, taꞌná: ―Chnatbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Niꞌr gdel‑lëꞌë naꞌbiꞌ Jesús, buchisëꞌ‑biꞌ atiꞌ gzuibiꞌ biꞌi naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Niꞌr gyaziëꞌ Jesús tu yuꞌu, atiꞌ laꞌ légaczëꞌ gulanabnëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Bizx quië cutu guc ubijtuꞌ böꞌ xöhuiꞌ naꞌ netuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús gudxëꞌ lequëꞌ: ―Cutu gac ubijliꞌ caꞌz böꞌ xöhuiꞌ cni, san tuz chquiꞌ ulidzliꞌ‑nëꞌ Dios len gunliꞌ gubás. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Catiꞌ guluzë́ꞌë niꞌ Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, guladödëꞌ luyú Galilea. Cutu rëꞌnnëꞌ Jesús nu gnözi ga naꞌ zoëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","le rusëdnëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, rëꞌ lequëꞌ: ―Ludödëꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lu naꞌquëꞌ bönniꞌ ludöddëꞌ nedaꞌ, san töd gatiaꞌ, catiꞌ gac tsonn dza ubanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cutu gulayéjniꞌnëꞌ didzaꞌ ni rëꞌ lequëꞌ, atiꞌ le tádxinëꞌ, cutu bi gulanabnëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Niꞌr guladxinëꞌ yödz Capernaum Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, len tsal niꞌ nacuꞌë lu yuꞌu, Jesús gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Bizxa didzaꞌ naꞌ rdil‑len lzaꞌliꞌ catiꞌ niꞌ yuꞌuliꞌ nöz? ");
INSERT INTO zsrNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lequëꞌ guluséyj rúꞌaquëꞌ, le taꞌdil‑len lzaꞌquëꞌ didzaꞌ laꞌ nöz niꞌ núzxalquëꞌ gaquëꞌ bönniꞌ blau. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Niꞌr gröꞌë Jesús len bulidzëꞌ idxínnutëꞌ bönniꞌ usë́d queëꞌ, rëꞌ lequëꞌ: ―Nu rëꞌni gac blau ral‑laꞌ gac ca tu bönniꞌ cuidiꞌz lencaꞌ ca niꞌa naꞌliꞌ yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Niꞌr gdel‑lëꞌë‑biꞌ tubiꞌ biꞌidauꞌ Jesús len buzóëꞌ‑biꞌ gatsj lahuiꞌl ga naꞌ nacuꞌë. Niꞌ runidëꞌ‑biꞌ, rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nu bönniꞌ siꞌ lu nëꞌë tu biꞌidauꞌ cni le náquibiꞌ quiaꞌ, siꞌ lu nëꞌë caꞌ nedaꞌ, atiꞌ nu bönniꞌ siꞌ lu nëꞌë nedaꞌ, clëg nedaꞌz siꞌ lu nëꞌë, san siꞌ lu nëꞌë caꞌ Xuzaꞌ, nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Niꞌr Juan gudxëꞌ Jesús: ―Bönniꞌ Usëdi, bléꞌituꞌ‑nëꞌ bönniꞌ rubijëꞌ yuguꞌ böꞌ xöhuiꞌ, rugunëꞌ dxin lauꞌ. Gna béꞌituꞌ lëꞌ cutur gunëꞌ caꞌ, le cutu dëꞌë rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Niꞌr Jesús gudxëꞌ lëꞌ: ―Cutu gna béꞌiliꞌ lëꞌ, le chquiꞌ zoëꞌ bönniꞌ runëꞌ tu yöl‑laꞌ huac zaꞌ yehuaꞌ yubá, rugunëꞌ dxin laꞌ nedaꞌ, cutu caꞌ gac gnë ziꞌë quiaꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Cni nac, nu curdáꞌbagaꞌ rëꞌu, raclen rëꞌu nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nútiꞌtëz nu gunn queëliꞌ tu zxígaꞌdauꞌ nis guiꞌjliꞌ le daꞌliꞌ nedaꞌ, Cristo, siꞌcz le ral‑laꞌ siꞌ nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Gnëꞌ caꞌ Jesús: ―Nútiꞌtëz nu gun ga gunbiꞌ dul‑laꞌ tubiꞌ biꞌidauꞌ cni réjlëꞌbiꞌ nedaꞌ, dxiꞌar gac nu ugal‑laꞌ guich ryëtu yag yeni nu naꞌ, len tsajchúꞌn lëꞌ lu nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chquiꞌ tu naꞌu gun ga gunuꞌ dul‑laꞌ, bchugu lei. Dxiꞌar gac quiuꞌ tsajtsaziuꞌ ga suꞌ gbanuꞌ zoa tuz naꞌu, clëg zoa chop naꞌu, atiꞌ tsajtsaziuꞌ lu guiꞌ gabíl, ga niꞌ cutu ul guiꞌ qui. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Latj niꞌ cutu latbaꞌ bzugaꞌ yuꞌucbaꞌ nup tsajcuáꞌ niꞌ, atiꞌ guiꞌ naꞌ cutu caꞌ ul. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lëzcaꞌ cni, chquiꞌ tu niꞌu gun ga gunuꞌ dul‑laꞌ, bchugu lei. Dxiꞌar gac quiuꞌ, tsajtsaziuꞌ ga suꞌ gbanuꞌ zoa tuz niꞌu, clëg zoa chop niꞌu, atiꞌ tsajtsaziuꞌ lu guiꞌ gabíl, ga niꞌ cutu ul guiꞌ qui. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Latj niꞌ cutu latbaꞌ bzugaꞌ yuꞌucbaꞌ nup tsajcuáꞌ niꞌ, atiꞌ guiꞌ naꞌ cutu caꞌ ul. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Lëzcaꞌ cni, chquiꞌ tu yöj lauꞌ gun ga gunuꞌ dul‑laꞌ, gleaj lei. Dxiꞌar gac quiuꞌ tsajtsaziuꞌ ga rna bëꞌë Dios zoa tuz yöj lauꞌ, clëg zoa chop yöj lauꞌ, atiꞌ tsajtsaziuꞌ lu guiꞌ gabíl. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Latj niꞌ cutu latbaꞌ bzugaꞌ yuꞌucbaꞌ nup tsajcuáꞌ niꞌ, atiꞌ guiꞌ naꞌ cutu caꞌ ul. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ruxiꞌiruꞌ bëlaꞌ zödiꞌ, rugál‑laꞌruꞌ lei raꞌ guiꞌ, cui gac ditj. Lë ni rusëdi rëꞌu ca luhuöác dxiꞌa yúguꞌtë bunách. Lëzcaꞌ cni, rëꞌnnëꞌ Dios gzxiꞌi zödiꞌ yúguꞌtë böaꞌ bëdxdauꞌ tuꞌzéguiꞌquëꞌ‑baꞌ lu bcugu laꞌy queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dxiꞌa nac zödiꞌ, san chquiꞌ nit yöl‑laꞌ snaꞌ qui, ¿nacx úniruꞌ lei snaꞌ? Gul‑gác laꞌ lbiꞌizliꞌ ca zödiꞌ dxiꞌa, soaliꞌ dxíꞌadauꞌ tuliꞌ len yetuliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Buzë́ꞌë Jesús yödz Capernaum, gyijëꞌ luyú Judea len gdödëꞌ yetsláꞌa yegu Jordán zacaꞌ ga rlen gbidz. Niꞌ guludúb leyúbl ga zoëꞌ bunách zian, atiꞌ leyúbl busëdnëꞌ lequëꞌ ca runczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Niꞌr guladxinëꞌ ga zoëꞌ Jesús bönniꞌ gdauꞌ fariseo, tëꞌnnëꞌ lunëꞌ ga bi gnëꞌ Jesús quië gac luquíëꞌ Lëꞌ. Gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿I dë latj bönniꞌ nutság nëꞌë usanëꞌ‑nu ngul queëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―¿Bizxa gna béꞌinëꞌ lbiꞌiliꞌ Moisés? ");
INSERT INTO zsrNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Gulanë́ꞌ: ―Moisés bëꞌë latj bönniꞌ uzujëꞌ lu guich le rna ruláꞌalenëꞌ‑nu, atiꞌ niꞌr usanëꞌ‑nu ngul queëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Gna béꞌinëꞌ lbiꞌiliꞌ cni Moisés le nac zid icj ládxiꞌdauꞌliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","san catiꞌ gzu lau gutaꞌ yödzlyú, bönniꞌ len ngul Dios benëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gnëꞌ: “Qui lë ni naꞌ ucaꞌnëꞌ xuz xnëꞌë bönniꞌ, tsajsóalenëꞌ‑nu ngul queëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","atiꞌ chopëꞌ ni luhuöaquëꞌ ca tuz bunách.” Qui lë ni naꞌ cutur nacquëꞌ chopëꞌ san tuz chnacquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Qui lë ni naꞌ caꞌ, nu nac bunách cutu ral‑laꞌ uláꞌa nup naꞌ chnutsaguëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Catiꞌ guluyaziëꞌ yuꞌu, gulanabi yudxëꞌ Jesús bönniꞌ usë́d queëꞌ ca nac didzaꞌ naꞌ bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús gudxëꞌ lequëꞌ: ―Nútiꞌtëz bönniꞌ uláꞌalenëꞌ‑nu ngul queëꞌ len utság náꞌlenëꞌ‑nu ngul yubl, runëꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ le ruspaguëꞌë‑nu dul‑laꞌ ngul naꞌ gzóalenëꞌ‑nu ziꞌal. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lëzcaꞌ cni chquiꞌ usannu‑nëꞌ bönniꞌ queënu ngul nutság náꞌlennu lëꞌ, len siꞌnu‑nëꞌ bönniꞌ yubl, runnu caꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Niꞌr guladxín ga zoëꞌ Jesús bunách djuaꞌgac biꞌidauꞌ quegac, tëꞌni gxoa nëꞌë lecbiꞌ, atiꞌ gulazú lauquëꞌ bönniꞌ usë́d queëꞌ Jesús taꞌdíl‑l dídzaꞌquëꞌ nup naꞌ djuaꞌgac lecbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Catiꞌ bléꞌinëꞌ lë ni Jesús, gleynëꞌ len gudxëꞌ lequëꞌ: ―Gul‑güíꞌ‑cbiꞌ latj biꞌidauꞌ laꞌdxinbiꞌ quiaꞌ. Cutu uzágaꞌgacliꞌ‑biꞌ, le gataꞌ quegac nup nacgac ca biꞌidauꞌ ni, latj ga rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Le nactë rëpaꞌ lbiꞌiliꞌ: Nu cusíꞌ lu nëꞌi le rna bëꞌë Dios ca runbiꞌ biꞌidauꞌ, cutu caꞌ tsaz ga niꞌ rna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Niꞌr bunidëꞌ‑biꞌ yuguꞌ biꞌidauꞌ naꞌ Jesús, bxoa nëꞌë lecbiꞌ len bulídz tsahuëꞌë‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Catiꞌ buꞌë nöz Jesús, jaréluꞌë bidëꞌ bönniꞌ, buzechu zxibëꞌ lahuëꞌ Jesús len gnabnëꞌ Lëꞌ, rnëꞌ: ―Bönniꞌ Usëdi gdu dxiꞌa, ¿nacx gunaꞌ quië gdél‑liꞌdaꞌ yöl‑laꞌ naꞌbán gdu? ");
INSERT INTO zsrNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús gudxëꞌ lëꞌ: ―¿Bizx quië ruꞌu quiaꞌ didzaꞌ, rnauꞌ: “Gdu dxiꞌa”? Nutu nu bönniꞌ naquëꞌ gdu dxiꞌa. Tuzëꞌ Dios naquëꞌ gdu dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chnözcznuꞌ yuguꞌ le gna bëꞌë Dios, gnëꞌ: Cutu gunuꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. Cutu gdödduꞌ bunách. Cutu cuanuꞌ. Cutu gneuꞌ qui lzaꞌu le cunácz. Cutu ucachiꞌ lanuꞌ. Ben ba laꞌn xuz xnaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bubiꞌë didzaꞌ bönniꞌ naꞌ, rëꞌ Jesús: ―Bönniꞌ Usëdi, yúguꞌtë lë ni runczaꞌ catiꞌ niꞌ nacteaꞌ biꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Len yöl‑laꞌ dxiꞌi ladxiꞌ queëꞌ, buyúëꞌ lëꞌ Jesús, rnëꞌ: ―Tu le ryadzj quiuꞌ. Gyeaj, yjëtiꞌ yúguꞌtë le dë quiuꞌ len bnödzj quegac bunách yechiꞌ lë naꞌ siꞌu, atiꞌ gataꞌ quiuꞌ yöl‑laꞌ tsahuiꞌ yehuaꞌ yubá. Niꞌr huöduꞌ quiaꞌ, gacuꞌ ca bönniꞌ zijëꞌ zajtë́ꞌë lëꞌi yag cruz, atiꞌ taꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Catiꞌ byönnëꞌ didzaꞌ ni, buiꞌnnëꞌ atiꞌ zhuöjëꞌ rsëbi ladxëꞌë le dëtsca queëꞌ yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Niꞌr buyúëꞌ Jesús gdu cuitiëꞌ len gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ: ―Baníg nac laꞌyáz ga rna bëꞌë Dios nup taꞌleꞌi yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gulubannëꞌ bönniꞌ usë́d queëꞌ ca nac xtidzëꞌë atiꞌ leyúbl Jesús gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ, zxíꞌnaꞌdauꞌ, baníg nac laꞌyaziëꞌ ga rna bëꞌë Dios bönniꞌ tuꞌzxöni ládxiꞌquëꞌ yöl‑laꞌ tsahuiꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nacr baníg tsaziëꞌ ga rna bëꞌë Dios nu bönniꞌ rléꞌinëꞌ yöl‑laꞌ tsahuiꞌ, ca tödbaꞌ böaꞌ lu nag yötsiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Catiꞌ gulayönnëꞌ didzaꞌ ni, gulubántërnëꞌ caꞌ, taꞌnë́ꞌ laꞌ légaczëꞌ: ―¿Nuzxa caz gac ulá, chquiꞌnuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Buyúëꞌ lequëꞌ Jesús, rnëꞌ: ―Cutu gac gun lë ni bunách, san huaquëꞌ Dios, le rzáquiꞌnëꞌ Dios yúguꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Niꞌr Pedro gudxëꞌ Lëꞌ: ―Xan, netuꞌ nucaꞌntuꞌ yúguꞌtë len daꞌtuꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, nu bönniꞌ ucaꞌnëꞌ lidxëꞌ, o böchëꞌë, o zanëꞌ, o xuzëꞌ, o xnëꞌë, o ngul queëꞌ, o yuguꞌ zxiꞌnëꞌ, o xyuëꞌ, le runëꞌ xchinaꞌ o le runëꞌ lban qui didzaꞌ dxiꞌa quiaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bönniꞌ ni huazíꞌ queëꞌ yetú gayuaꞌtër caꞌ dza ni zoaruꞌ naꞌa, yuguꞌ lidxëꞌ, len yuguꞌ böchëꞌë, len yuguꞌ zanëꞌ, len yuguꞌ xnëꞌë, len yuguꞌ zxiꞌnëꞌ, len yuguꞌ xyuëꞌ, lencaꞌ yuguꞌ le laꞌbía ládxiꞌgac lëꞌ bunách, atiꞌ yödzlyú ziꞌa zaꞌ, gataꞌ yöl‑laꞌ naꞌbán gdu queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Zian nup nacgac blau naꞌa, lac cuidiꞌz niꞌ, atiꞌ nup nacgac cuidiꞌz naꞌa, lac blau niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Catiꞌ niꞌ yuꞌuquëꞌ nöz, taꞌbenëꞌ zjaquëꞌ Jerusalén, nanörëꞌ Jesús lauquëꞌ bönniꞌ usë́d queëꞌ. Nanitcnëꞌ len lu yöl‑laꞌ radxiz zjáclenëꞌ Lëꞌ. Leyúbl bchëꞌë quizi idxínnutëꞌ naꞌ Jesús. Gzu lahuëꞌ ruíꞌlenëꞌ lequëꞌ didzaꞌ ca nac le ral‑laꞌ gac queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","rnëꞌ: ―Rléꞌiczliꞌ rbenruꞌ zijruꞌ Jerusalén ga niꞌ soa nu udö́d nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lu naꞌgac bxuz uná bëꞌ len lu naꞌquëꞌ bönniꞌ gdauꞌ tuꞌsëdi. Laꞌchuguëꞌ quiaꞌ gatiaꞌ, len ludödëꞌ nedaꞌ lu naꞌquëꞌ bönniꞌ gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lutitjëꞌ nedaꞌ bönniꞌ naꞌ len lundëꞌ nedaꞌ ziꞌ. Luchijëꞌ nedaꞌ zxönaꞌ. Niꞌr ludöddëꞌ nedaꞌ, san catiꞌ gac tsonn dza ubanaꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Niꞌr gulabiguëꞌë lahuëꞌ Jesús Jacobo len Juan, zxiꞌnëꞌ Zebedeo, len tëꞌ Lëꞌ: ―Bönniꞌ Usëdi, rë́ꞌnituꞌ gunuꞌ queëtuꞌ le gnabtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús gudxëꞌ lequëꞌ: ―¿Bizxa rë́ꞌniliꞌ gunaꞌ queëliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Glëꞌ Lëꞌ: ―Catiꞌ gdxin dza cöꞌu ga gna bëꞌu, ben ga cöꞌtuꞌ tutuꞌ cuitiuꞌ yubél len yetutuꞌ cuitiuꞌ yögl. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Cutu nö́ziliꞌ bi rnabliꞌ. ¿Naruꞌ huac siꞌliꞌ le ral‑laꞌ siꞌa nedaꞌ, le nac le sacaꞌ quiꞌa? ¿Naruꞌ huac gdil‑liꞌ nis ca gdilaꞌ nedaꞌ nis, gatiaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Huactuꞌ. Jesús gudxëꞌ lequëꞌ: ―Le nactë, le sacaꞌ quiꞌa nedaꞌ, siꞌliꞌ caꞌ lbiꞌiliꞌ, len ca gdilaꞌ nedaꞌ nis, gdil‑liꞌ caꞌ nis, ");
INSERT INTO zsrNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","san cutu dë lu naꞌa cö́aꞌ nu cöꞌ cuitiaꞌ yubél len nu cöꞌ cuitiaꞌ yögl. Dios unödzjëꞌ quequëꞌ bönniꞌ chnupë́ꞌë quequëꞌ yuguꞌ latj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Catiꞌ gulayönnëꞌ didzaꞌ ni yechíëꞌ bönniꞌ usë́d queëꞌ Jesús, lequëꞌ taꞌleynëꞌ Jacobo len Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Niꞌr bulidzëꞌ lequëꞌ Jesús, rnëꞌ: ―Nö́ziczliꞌ ca tun nup taꞌná beꞌi yuguꞌ yödz, tuꞌzeynëꞌ bach bunách, atiꞌ nup nacgac blau ladjquëꞌ taꞌná beꞌi lzaꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Cutu gac cni queëliꞌ, san nu guëꞌni gac zxön ga zoaliꞌ, ral‑laꞌ gun xchinliꞌ yezícaꞌrliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","atiꞌ nútiꞌtëzl‑liꞌ nu guëꞌni gac blau ral‑laꞌ gac ca bönniꞌ nadaꞌu queëliꞌ yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cni ral‑laꞌ gunliꞌ le bidaꞌ ni nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, clëg quië nu gun xchinaꞌ, san quië gunaꞌ xchingac bunách len udödaꞌ yöl‑laꞌ naꞌbán quiaꞌ le huöáꞌuidaꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Niꞌr guladxinëꞌ yödz Jericó Jesús len bönniꞌ daꞌquëꞌ Lëꞌ. Catiꞌ niꞌ rurujëꞌ yödz ni Jesús, dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ lencaꞌ bunách zian. Raꞌ nöz niꞌ röꞌë bönniꞌ nachúl lahuëꞌ, lëꞌ Bartimeo, zxiꞌnëꞌ Timeo. Rnabëꞌ nu bi gunnz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Catiꞌ byönnëꞌ Bartimeo rdödëꞌ niꞌ Jesús, bönniꞌ Nazaret, gzu lahuëꞌ ruꞌë zidzj didzaꞌ, rnëꞌ: ―Jesús, zxiꞌn xsoëꞌ David. Buechiꞌ ladxiꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Guladíl‑l lëꞌ didzaꞌ nup taꞌdö́d niꞌ, të lëꞌ: ―Bseyj ruꞌu. Niꞌr zidzjr bulidzëꞌ, rnëꞌ: ―Zxiꞌn xsoëꞌ David. Buechiꞌ ladxiꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Niꞌr gzëꞌ dxiz Jesús, rbözëꞌ, atiꞌ rëꞌ lequëꞌ: ―Gul‑lidzëꞌ. Gululidzëꞌ bönniꞌ naꞌ nachúl lahuëꞌ, tëꞌ lëꞌ: ―Btip ladxuꞌu. Gyasch. Rulidzëꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Niꞌr gruꞌnëꞌ tslaꞌl lariꞌ naxóa yenëꞌ. Laꞌ gyastëꞌ len bidëꞌ ga naꞌ zoëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Gnabnëꞌ lëꞌ Jesús, rnëꞌ: ―¿Bizxa rëꞌnnuꞌ gunaꞌ quiuꞌ? Bubiꞌë didzaꞌ bönniꞌ naꞌ nachúl lahuëꞌ, rnëꞌ: ―Bönniꞌ Usëdi, rëꞌndaꞌ gunuꞌ ga huöalj yöj lahuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús gudxëꞌ lëꞌ: ―Böaj lidxuꞌ. Chnuhuöacuꞌ le réjlëꞌu nedaꞌ. Laꞌ böaljtë yöj lahuëꞌ atiꞌ zéajlenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Guladxinëꞌ Jesús len bönniꞌ daꞌquëꞌ Lëꞌ gal‑laꞌ ga dë Jerusalén, ga naꞌ nacuáꞌ yödz Betfagé len yödz Betania, len ga naꞌ dë caꞌ Guiꞌa Ga Röꞌgac Yag Olivo. Niꞌr Jesús bsölëꞌë chopëꞌ bönniꞌ usë́d queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","rëꞌ lequëꞌ: ―Gul‑tséaj lu yödzdauꞌ dë lauruꞌ niꞌ, len catiꞌ tsazliꞌ niꞌ, tsajxácaꞌliꞌ‑baꞌ niꞌ tubaꞌ búrrodauꞌ nágaꞌbaꞌ, nutu nu rbiani lëbaꞌ. Gul‑sédx‑baꞌ len gul‑chë́ꞌ‑baꞌ quiaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chquiꞌ nu bi guië lbiꞌiliꞌ le runliꞌ lë ni, gul‑guië́ nu naꞌ: “Xanruꞌ rquinnëꞌ‑baꞌ, atiꞌ laꞌ usö́laꞌtëꞌ‑baꞌ quiuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Niꞌr yjaquëꞌ yajxácaꞌquëꞌ‑baꞌ búrrodauꞌ naꞌ, nágaꞌbaꞌ ga nu ryaz löꞌa ga nac raꞌ nöz, atiꞌ gulasedxëꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nup nacuáꞌ niꞌ të lequëꞌ: ―¿Bizxa ni runliꞌ? ¿Bizx quië rsedxliꞌ‑baꞌ búrrodauꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Gulubiꞌë didzaꞌ bönniꞌ usë́d queëꞌ Jesús, glëꞌ lequëꞌ ca naꞌ chgudxczëꞌ lequëꞌ Jesús, atiꞌ gluiꞌ lequëꞌ latj bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Niꞌr gulachë́ꞌë‑baꞌ búrrodauꞌ naꞌ ga naꞌ zoëꞌ Jesús. Gulaxóëꞌ cúdzuꞌbaꞌ lariꞌ quequëꞌ atiꞌ Jesús gdxiëꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zian bönniꞌ nacuꞌë niꞌ gulachiljëꞌ lariꞌ quequëꞌ gap nac laꞌ nöz. Yelaꞌgac bunách niꞌ gulaguítsj zin le guluzxóa laꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gulazú lau tuiꞌ zidzj didzaꞌ nup nanörgac lahuëꞌ Jesús len nup naꞌ zaꞌc cúdzuꞌlëꞌ, taꞌnë́ꞌ: ―Yöl‑laꞌ ba. Dios gun laꞌyëꞌ Bönniꞌ zëꞌë ni, nasölëꞌë Lëꞌ Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dios gun laꞌyëꞌ Bönniꞌ ni ziꞌa gna bëꞌë, ca naꞌ gna bëꞌë xuz xtauꞌruꞌ David. Yöl‑laꞌ ba Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cni guc, bdxinëꞌ Jesús Jerusalén, atiꞌ gyaziëꞌ löꞌa gdauꞌ. Catiꞌ budx buyúëꞌ yúguꞌtë le nacuáꞌ gdu zbiꞌil niꞌ, burujëꞌ zacaꞌ yödz Betania le chrdzöꞌ, dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Catiꞌ zaꞌ reníꞌ yetú dza, atiꞌ tuꞌrujëꞌ yödz Betania Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, rdunëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ziꞌtuꞌ bléꞌinëꞌ tu yag higo dxia xlaguiꞌ. Gbiguëꞌë ga naꞌ zoa yag naꞌ chquiꞌ utsajxaquëꞌë latiꞌ le rbia. Catiꞌ bdxinëꞌ niꞌ cutu bi yajxaquëꞌë le rbia. Xlaguiꞌz dxia le cutu rdxini dza cuia. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Niꞌr bulidzëꞌ yag naꞌ Jesús, rnëꞌ: ―Cutur nu gagu le rbia quiuꞌ. Gulayönnëꞌ didzaꞌ ni bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Catiꞌ guladxinëꞌ Jerusalén Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, gyaziëꞌ Jesús löꞌa gdauꞌ len gzu lahuëꞌ rubijëꞌ niꞌl nup tutiꞌ len nup taꞌu löꞌa gdauꞌ. Brixëꞌ yuguꞌ blag quegac nup tuꞌtsáꞌ dumí gzaꞌa, lencaꞌ yuguꞌ ga taꞌbö́ꞌ nup tutiꞌ budödauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Cutu caꞌ bëꞌë latj nu bi guaꞌ, uzóa nöz ga nac löꞌa gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Busëdnëꞌ nup nacuáꞌ niꞌ, rnëꞌ: ―Nayúj lu guich laꞌy, rna: “Lidxaꞌ siꞌ lei, yuꞌu ga lulídz Dios bunách gdutë yödzlyú.” Lbiꞌiliꞌ chnunliꞌ lei ca nac bloj quegac gban. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Catiꞌ gulayönnëꞌ didzaꞌ ni yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi, gulazú lauquëꞌ taꞌzú taꞌböꞌë ludöddëꞌ Jesús, san le tádxinëꞌ bunách, cutu bi glunëꞌ queëꞌ, le tuꞌbani yúguꞌtë bunách ca nac le rusëdnëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Catiꞌ chrdzöꞌ burujëꞌ Jesús lu yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Catiꞌ zaꞌ reníꞌ yetú dza, guladödëꞌ Jesús len bönniꞌ daꞌquëꞌ Lëꞌ ga zoa yag higo naꞌ bulídz ziꞌë Jesús, len gulaléꞌinëꞌ lei, chnabídx gdu luí. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Niꞌr yajneynëꞌ Pedro bi guc atiꞌ gudxëꞌ Jesús: ―Bönniꞌ Usëdi, byutscaꞌ. Yag higo ni bulídz ziꞌu nij, chnabídx. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑tsejlëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Le nactë rëpaꞌ lbiꞌiliꞌ, chquiꞌ nu bönniꞌ guiëꞌ guíꞌadauꞌ ni: “Bcuit ni, yajsóa lu nis zxön”, len cugác chop ladxëꞌë bönniꞌ naꞌ san gdu ladxëꞌë tsejlëꞌë gunëꞌ Dios ca naꞌ rnëꞌ, caꞌ gac. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ: Yúguꞌtë le gnabliꞌ catiꞌ ulidzliꞌ‑nëꞌ Dios, gul‑tsejlëꞌ chbennëꞌ queëliꞌ Dios lë naꞌ rnabliꞌ, atiꞌ gunnëꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Catiꞌ niꞌ rulidzliꞌ‑nëꞌ Dios, chquiꞌ zoa nu rleyliꞌ nu bi ben queëliꞌ, gul‑nít lau nu naꞌ quië unít lahuëꞌ caꞌ lbiꞌiliꞌ ca nac dul‑laꞌ nabágaꞌliꞌ, Xuzliꞌ naꞌ zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Chquiꞌ cu unít lauliꞌ bunách, cutu unít lahuëꞌ lbiꞌiliꞌ dul‑laꞌ nabágaꞌliꞌ Xuzliꞌ zoëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Niꞌr yhuöjquëꞌ Jerusalén Jesús len bönniꞌ daꞌquëꞌ Lëꞌ. Catiꞌ niꞌ rdëꞌ Jesús ga nac nchil gdauꞌ, guladxinëꞌ ga zoëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi len bönniꞌ gul tuꞌzejniꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gulanabnëꞌ Jesús, taꞌnë́ꞌ: ―¿Bizxa yöl‑laꞌ uná bëꞌ dë lu naꞌu runuꞌ yuguꞌ lë ni? ¿Nuzxa caz budö́d lu naꞌu yöl‑laꞌ uná bëꞌ gunuꞌ cni? ");
INSERT INTO zsrNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Nedaꞌ caꞌ gnabdaꞌ lbiꞌiliꞌ tu didzaꞌ. Chquiꞌ ubiꞌiliꞌ quiaꞌ didzaꞌ, niꞌr gyëpaꞌ lbiꞌiliꞌ bi yöl‑laꞌ uná bëꞌ rundaꞌ yuguꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nuzxa budö́d lu nëꞌë Juan uquilëꞌ bunách nis? ¿Naruꞌ Dios o bunách? Gul‑natscaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gulazú lauquëꞌ tun xtídzaꞌquëꞌ laꞌ légaczëꞌ, taꞌnë́ꞌ: ―Chquiꞌ gnaruꞌ Dios bsölëꞌë lëꞌ, guiëꞌ rëꞌu: “¿Bizx quië cutu gyéjlëꞌliꞌ lëꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Naruꞌ guië́tsaruꞌ‑nëꞌ: “Gulasölëꞌë lëꞌ bönniꞌ”? Cni taꞌzáꞌ ládxiꞌquëꞌ le tádxinëꞌ bunách zian nacuáꞌ niꞌ le taqui yúguꞌtë bunách naꞌ bëꞌë didzaꞌ uláz queëꞌ Dios Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Qui lë ni naꞌ glëꞌ Jesús: ―Cutu nö́zituꞌ. Niꞌr Jesús gudxëꞌ lequëꞌ: ―Nedaꞌ caꞌ cutu quíxjöiꞌdaꞌ lbiꞌiliꞌ bi yöl‑laꞌ uná bëꞌ dë lu naꞌa rundaꞌ yuguꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Niꞌr gzu lahuëꞌ Jesús ruíꞌlenëꞌ bönniꞌ daꞌquëꞌ Lëꞌ didzaꞌ yuguꞌ le runëꞌ lsaquiꞌ, rnëꞌ: ―Gzoëꞌ bönniꞌ, szxöni bdëꞌë lba uva ga nac laꞌ yël queëꞌ. Glequëꞌ liꞌaj qui, len gchöꞌnëꞌ rögaꞌ guiöj ga gsiëꞌ xisi uva naꞌ. Budxíëꞌ tu yuꞌu gup ga nac xtsaꞌ ga nu uyú laꞌ yël naꞌ. ’Niꞌr budödëꞌ lu naꞌquëꞌ huen dxin laꞌ yël queëꞌ naꞌ, laꞌziꞌë gatsj hueaj le unö́dzj, atiꞌ gyijëꞌ yödz ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Catiꞌ bdxin dza luchibëꞌ le rbia, bsölëꞌë‑biꞌ biꞌi huen dxin queëꞌ tsajxiꞌbiꞌ lu naꞌquëꞌ huen dxin naꞌ le ral‑laꞌ siꞌë xanbiꞌ qui le gulabía lba uva naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Niꞌr gulaguel‑lëꞌë‑biꞌ biꞌi naꞌ yuguꞌ huen dxin naꞌ len glundëꞌ‑biꞌ ziꞌ, atiꞌ gulusölëꞌë‑biꞌ caꞌzbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Niꞌr bsölëꞌë‑biꞌ yetubiꞌ biꞌi huen dxin queëꞌ bönniꞌ xan laꞌ yël naꞌ, atiꞌ biꞌi ni gululadxëꞌ‑biꞌ guiöj, gululë́ꞌë icjbiꞌ. Gluꞌë döꞌ queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Niꞌr bsölëꞌë‑biꞌ caꞌ yetubiꞌ biꞌi huen dxin queëꞌ bönniꞌ xan laꞌ yël naꞌ, atiꞌ biꞌi ni guludöddëꞌ‑biꞌ. Bsölëꞌë‑biꞌ caꞌ zianrbiꞌ atiꞌ laꞌcbiꞌ gluncdëꞌ‑biꞌ ziꞌ len yelaꞌcbiꞌ guludödcdëꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Nutur nu nagáꞌn queëꞌ xan laꞌ yël naꞌ. Nagaꞌnzbiꞌ biꞌi bönniꞌ queëꞌ atiꞌ nadxíꞌitsquinëꞌ‑biꞌ. Ga yajseytë, bsölëꞌë‑biꞌ zxiꞌnëꞌ, rnëꞌ: “Lunëꞌ ba laꞌn zxiꞌnaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Niꞌr gulanë́ꞌ laꞌ légaczëꞌ bönniꞌ huen dxin naꞌ, taꞌnë́ꞌ: “Biꞌi ni ral‑laꞌ gaqui queëbiꞌ laꞌ yël ni. Gul‑dá, gdö́diruꞌ‑biꞌ atiꞌ gaqui queëruꞌ laꞌ yël ni.” ");
INSERT INTO zsrNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Qui lë ni naꞌ gulazönëꞌ‑biꞌ len guludöddëꞌ‑biꞌ. Gularuꞌnëꞌ‑biꞌ niꞌl laꞌ yël qui lba uva naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Niꞌr gnabnëꞌ bönniꞌ nacuꞌë niꞌ Jesús, rnëꞌ: ―¿Nacx gunëꞌ chquiꞌnuꞌ, bönniꞌ xan laꞌ yël naꞌ? Huidëꞌ len huadödcdëꞌ bönniꞌ huen dxin naꞌ, atiꞌ udödëꞌ lu naꞌgac bunách yubl laꞌ yël naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Naruꞌ cu nulábniliꞌ lë naꞌ nayúj lu guich laꞌy? Cni rna: Guiöj naꞌ gularuꞌnëꞌ bönniꞌ tuꞌcuꞌë zöꞌö, Naꞌa nac guiöj len, squin zöꞌö. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Xanruꞌ Dios benëꞌ ga nac cni Atiꞌ rubániruꞌ ca nac lë ni rléꞌiruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Niꞌr gulazú gulaböꞌë laꞌzönëꞌ Jesús le táquibeꞌinëꞌ benëꞌ lsaquiꞌ ni ca nac quequëꞌ, san tádxinëꞌ bunách zian nacuáꞌ niꞌ len qui lë ni naꞌ gulucaꞌnëꞌ Lëꞌ, zhuöjquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gdöd lë ni yuguꞌ bönniꞌ gdauꞌ uná bëꞌ naꞌ gulasölëꞌë ga zoëꞌ Jesús laꞌquëꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ daꞌquëꞌ Herodes quië lunëꞌ ga bi gnëꞌ Jesús quië gac luquíëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Guladxinëꞌ ga naꞌ zoëꞌ Jesús bönniꞌ ni, len tëꞌ Lëꞌ: ―Bönniꞌ Usëdi, nö́zituꞌ ruꞌu didzaꞌ gdutë li. Cutu ruiꞌ ladxuꞌu bi taꞌnáz bunách, le curuyuzuꞌ le tuꞌluíꞌz cuingac bunách, san rusëdnuꞌ ca nacz le rëꞌnnëꞌ Dios lun bunách. ¿I runn netuꞌ latj zxba queëꞌ Moisés quizxj laztuꞌ le tuꞌquizxjëꞌ uláz queëꞌ César? ¿Naruꞌ uguizxjtuꞌ o cutu quizxjtuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ráquibeꞌinëꞌ Jesús tuꞌë didzaꞌ lu yöl‑laꞌ rguilj ladxiꞌ quequëꞌ atiꞌ rëꞌ lequëꞌ: ―¿Bizx quië rubijliꞌ nedaꞌ didzaꞌ? Gul‑djuaꞌtscaꞌ quiaꞌ tu dumí rda quië gléꞌidaꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Djuaꞌquëꞌ lei atiꞌ gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―¿Nuzxa lahui daꞌ lëꞌi ni len nuzxa lei ni? Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Queëꞌ César naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Niꞌr Jesús gudxëꞌ lequëꞌ, rnëꞌ: ―Gul‑nö́dzj queëꞌ César le naqui queëꞌ César, atiꞌ queëꞌ Dios le naqui queëꞌ Dios. Gulubannëꞌ ca nac didzaꞌ bubiꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Niꞌr guladxinëꞌ ga zoëꞌ Jesús laꞌquëꞌ bönniꞌ gdauꞌ saduceo. Bönniꞌ ni taꞌnë́ꞌ cutu lubán nup chnatgac. Qui lë ni naꞌ glëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","taꞌnë́ꞌ: ―Bönniꞌ Usëdi, Moisés nuzujëꞌ queëtuꞌ lu guich chquiꞌ gatiëꞌ bönniꞌ cuzóa biꞌi queëꞌ, atiꞌ ugaꞌnnu ngul queëꞌ, ral‑laꞌ utság náꞌlenbiꞌ‑nu biꞌi böchëꞌë bönniꞌ naꞌ len uzoabiꞌ biꞌidauꞌ gacbiꞌ biꞌi queëbiꞌ bö́chiꞌbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gulacuaꞌbiꞌ gadxbiꞌ biꞌi nac bö́chiꞌcbiꞌ. Biꞌi ziꞌal naꞌ butság náꞌlenbiꞌ‑nu ngul, atiꞌ gutbiꞌ, nutu nu gul‑laꞌ biꞌidauꞌ queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Biꞌi buróp naꞌ butság náꞌlenbiꞌ‑nu ngul uzë́b naꞌ, atiꞌ gutbiꞌ caꞌ, nutu nu gul‑laꞌ biꞌidauꞌ queëbiꞌ. Lëzcaꞌ cni guc queëbiꞌ biꞌi bunn. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cni guc, gulutság náꞌlenbiꞌ‑nu yúguꞌtëbiꞌ, nutu nu gul‑laꞌ biꞌidauꞌ quecbiꞌ. Ga yajseytë, gutnu caꞌ ngul naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naꞌa, catiꞌ lubán nup chnatgac, ¿núzxalbiꞌ gáquinu queëbiꞌ ngul naꞌ, le gulutság náꞌlenbiꞌ‑nu igádxtëbiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Rchíxiliꞌ le cunúnbëꞌliꞌ le nayúj lu guich laꞌy len cutu nö́ziliꞌ ca nac yöl‑laꞌ huac queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Catiꞌ lubán nup chnatgac, cutu caꞌ lutság naꞌquëꞌ, len cutu laꞌcuáꞌlenëꞌ‑nu ngul bönniꞌ, san lacquëꞌ ca nacquëꞌ gbaz laꞌy queëꞌ Dios, nacuꞌë yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Naꞌa, ca nac quegac nup chnatgac chquiꞌ lubán, ¿naruꞌ cu nulábiniliꞌ le buzujëꞌ lu guich Moisés? Ruiꞌ didzaꞌ ca naꞌ bulidzëꞌ lëꞌ Dios lu yag yö́tsiꞌdauꞌ regui, rëꞌ lëꞌ: “Nedaꞌ nacaꞌ Dios queëꞌ Abraham len Dios queëꞌ Isaac, len Dios queëꞌ Jacob.” Le gnëꞌ cni quequëꞌ, nac bëꞌ nabanquëꞌ zal‑laꞌ glatiëꞌ ziꞌal. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios naquëꞌ Dios quegac nup nabangac, clëg quegac nup natgac tsaz. Szxö́nitër rchíxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bidëꞌ caꞌ ga zoëꞌ Jesús bönniꞌ gdauꞌ usëdi. Byönnëꞌ ca naꞌ gluíꞌlenëꞌ Jesús didzaꞌ len nöznëꞌ dxíꞌadauꞌ bubiꞌë didzaꞌ Jesús. Qui lë ni naꞌ gnabnëꞌ Jesús, rnëꞌ: ―¿Bizxal le gna bëꞌë Dios nactër blau ca yúguꞌtë le gna bëꞌë? ");
INSERT INTO zsrNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Le gna bëꞌë nactër blau ca yúguꞌtë nac lë naꞌ rna: “Gul‑yöni bunách Israel. Xanruꞌ Dios, tuzëꞌ Lëꞌ naquëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ral‑laꞌ gdxiꞌinuꞌ Xanuꞌ Dios gdu ladxuꞌu, len lu gdu icj ládxiꞌdaꞌu len lu gdu yöl‑laꞌ rejniꞌi quiuꞌ len lu gdu yöl‑laꞌ huac quiuꞌ.” Lë ni nac le gna bëꞌë nactër blau. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Le gna bëꞌë nac buróp, tuz ca nac. Cni rna: “Ral‑laꞌ gdxiꞌinuꞌ lzaꞌu ca nadxíꞌi cuinuꞌ.” Cutu caꞌ zoa yetú le gna bëꞌë nacr blau ca chop ni gna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Niꞌr gudxëꞌ Jesús bönniꞌ gdauꞌ usëdi naꞌ, rnëꞌ: ―Dxíꞌadauꞌ gnauꞌ, Bönniꞌ Usëdi. Le nacz rnauꞌ. Tuzëꞌ naquëꞌ Dios, len nutur nu zoa nac Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Quië gdxiꞌiruꞌ‑nëꞌ Dios gdu ládxiꞌruꞌ, len lu gdu yöl‑laꞌ rejniꞌi queëruꞌ len lu gdu icj ládxiꞌdauꞌruꞌ len lu gdu yöl‑laꞌ huac queëruꞌ, len quië gdxiꞌiruꞌ lzaꞌruꞌ ca nadxíꞌi cuinruꞌ, nacr lsacaꞌ ca yúguꞌtë böaꞌ bëdxdauꞌ rudö́dicruꞌ‑baꞌ lu bcugu laꞌy queëꞌ Dios, lencaꞌ ca yúguꞌtë böaꞌ bëdxdauꞌ ruzéguiꞌcruꞌ‑baꞌ lu bcugu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Catiꞌ byönnëꞌ Jesús dxíꞌadauꞌ rubiꞌë didzaꞌ bönniꞌ ni, niꞌr gudxëꞌ lëꞌ, rnëꞌ: ―Yelatiꞌz ryadzj quiuꞌ gúnbëꞌu le rna bëꞌë Dios. Nutur nu burugui bi gnabi Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Catiꞌ niꞌ rusëdnëꞌ Jesús bunách ga nac nchil gdauꞌ, rnëꞌ: ―¿Bizx quië taꞌnë́ꞌ bönniꞌ gdauꞌ usëdi naquëꞌ Cristo zxiꞌn xsoëꞌ David? ");
INSERT INTO zsrNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lëczëꞌ David naꞌ bëꞌë didzaꞌ, zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy, gnëꞌ: Xanruꞌ Dios gudxëꞌ Xanaꞌ: “Gröꞌ cuit lëꞌa yubél Catiꞌ gunraꞌ ga luzechu zxibgac Lauꞌ Nup cutaꞌleꞌi Liꞌ dxiꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Naruꞌ nactsëꞌ Cristo zxiꞌn xsoëꞌ David chquiꞌ lëczëꞌ David naꞌ rnëꞌ queëꞌ naquëꞌ Xanëꞌ? Guladzág ládxiꞌgac didzaꞌ ni bunách zian nacuáꞌ niꞌ tuꞌzë́ naggac Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Niꞌ rusëdnëꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑gún chiꞌi cuinliꞌ quequëꞌ bönniꞌ gdauꞌ tuꞌsëdi. Taꞌdzág ládxiꞌquëꞌ taꞌdë́ꞌ niꞌl naꞌl, nácuquëꞌ lariꞌ tunn. Taꞌdzág ládxiꞌquëꞌ caꞌ tuꞌlídz tsahuiꞌ lequëꞌ bunách gap nac lu yëꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Taꞌböꞌë yuguꞌ latj blau lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bunách lencaꞌ gap tuꞌdubëꞌ tiꞌj tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tuꞌgǘëꞌ lidxcnu ngul uzë́b len quië luluíꞌz tsahuiꞌ cuinquëꞌ, xtsey tuꞌlidzëꞌ Dios. Yuguꞌ bönniꞌ ni, gúntscarëꞌ lequëꞌ zxguiaꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tsal niꞌ röꞌë Jesús nchil gdauꞌ ga zoa guiꞌn ga taꞌgúꞌu bunách dumí gun, ruyúëꞌ ca tun bunách taꞌgúꞌu dumí lu guiꞌn. Dumí zian taꞌguꞌë bönniꞌ dë yöl‑laꞌ tsahuiꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Niꞌr bdxinnu niꞌ ngul yechiꞌ uzëbdauꞌ, gluꞌnu chop dumí lasdauꞌ, le zácaꞌgac látiꞌdauꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Niꞌr bulidzëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, ngul yechiꞌ uzëbdauꞌ ni gluꞌrnu ca yúguꞌtë nup bi taꞌgúꞌu lu guiꞌn qui gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Taꞌguꞌë qui le nagáꞌnz quequëꞌ yúguꞌtë bönniꞌ ni, san ngul ni, lu yöl‑laꞌ yéchiꞌdauꞌ queënu gluꞌnu gdutë laꞌz dui tsca le dëz queënu, le ral‑laꞌ gáhuinu. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Catiꞌ burujëꞌ Jesús nchil gdauꞌ, gudxëꞌ Lëꞌ tuëꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Bönniꞌ Usëdi, byutscaꞌ nactga yuguꞌ yuꞌu zxön ni, len nactga yuguꞌ guiöj lëꞌi zöꞌö quegac. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Rléꞌinuꞌ yuguꞌ yuꞌu zxön ni, san cutu caꞌ ugáꞌn ni guiöj lahui lzëꞌi, le luquíndj leygac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Niꞌr yjaquëꞌ Jesús len bönniꞌ daꞌquëꞌ Lëꞌ lu Guiꞌa Ga Röꞌgac Yag Olivo, guiꞌa naꞌ dë ca dödl raꞌ gdauꞌ. Catiꞌ chröꞌë niꞌ Jesús, glëꞌ Lëꞌ laꞌ légaczëꞌ Pedro len Jacobo len Juan len Andrés, ");
INSERT INTO zsrNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","taꞌnë́ꞌ: ―Gdixjöiꞌ netuꞌ batx lac lë ni. ¿Bizxa gac bëꞌ chzoa lac yúguꞌtë lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bubiꞌë didzaꞌ Jesús, rusëdnëꞌ lequëꞌ, rnëꞌ: ―Gul‑gún chiꞌi cuinliꞌ qui nadxi nu siꞌ yeꞌi lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Laꞌláꞌ lauquëꞌ zian bönniꞌ siꞌ laquëꞌ ca leaꞌ nedaꞌ, laꞌnë́ꞌ nacquëꞌ Cristo. Cni laꞌzíꞌ yéꞌinëꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Niꞌr catiꞌ yö́niliꞌ rac gdil‑l niꞌl naꞌl, cutu gádxiliꞌ. Yúguꞌtë lë ni ral‑laꞌ gac, san cutu rdxini dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tu yödz til‑len yetú yödz len tu ga nu rna bëꞌ tsajtil‑len yetú ga nu rna bëꞌ. Zian latj saꞌ rtit len gac gbin. Lun rusbö́ bunách. Yuguꞌ lë ni lac le su lau laꞌzacaꞌ laꞌguíꞌi bunách dza niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Niꞌr gul‑gún chiꞌi cuinliꞌ, le ludödëꞌ lbiꞌiliꞌ lu naꞌquëꞌ bönniꞌ yúlahuiꞌ. Laꞌguinëꞌ lbiꞌiliꞌ gap tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Gdxinliꞌ lauquëꞌ bönniꞌ taꞌná bëꞌë len lauquëꞌ bönniꞌ taꞌná béꞌinëꞌ yödz ziꞌtuꞌ. Lunëꞌ cni queëliꞌ le daꞌliꞌ nedaꞌ, san niꞌ gunliꞌ lnaꞌ lau quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ziꞌal ca gdxin dza udx, run bayúdx gac lban qui didzaꞌ dxiꞌa quiaꞌ laugac bunách gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Catiꞌ niꞌ laꞌchë́ꞌë lbiꞌiliꞌ, len ludödëꞌ lbiꞌiliꞌ lu naꞌquëꞌ bönniꞌ yúlahuiꞌ, cutu güiꞌ ládxiꞌliꞌ bizxa gnaliꞌ. Laꞌ dza niꞌz Dios gunnëꞌ queëliꞌ didzaꞌ güiꞌliꞌ, atiꞌ lë ni gnaliꞌ. Catiꞌ niꞌ güiꞌliꞌ didzaꞌ, clëg lbiꞌizliꞌ naꞌ gnaliꞌ, san Dios Böꞌ Laꞌy gnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ludö́d laꞌ bö́chiꞌgacz bunách lu naꞌquëꞌ bönniꞌ ludödcdëꞌ lequëꞌ. Bönniꞌ nacuaꞌbiꞌ biꞌi quequëꞌ ludödëꞌ laꞌ zxíꞌngacczëꞌ caꞌ, atiꞌ zxiꞌnquëꞌ naꞌ ludödbiꞌ laꞌ xuz xnáꞌgacczbiꞌ lu naꞌquëꞌ bönniꞌ ludödcdëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Luzóa lbiꞌiliꞌ tslaꞌl yúguꞌtë bunách le daꞌliꞌ nedaꞌ, san nul‑liꞌ guaꞌ glenliꞌ lë naꞌ gac ga gdxinr dza udx, ulaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nup tuꞌláb didzaꞌ ni ral‑laꞌ laꞌyejniꞌi. Buzujëꞌ lu guich Daniel, bönniꞌ niꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, le rna cni: “Tsaz ga cutu ral‑laꞌ tsaz tu le xöhuiꞌ le rusnít.” Dza niꞌr ral‑laꞌ laꞌzxúndj nup nacuáꞌ luyú Judea, tsjac gap nac guíꞌadauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu zoa cjuꞌu dza niꞌ ral‑laꞌ gzxundjtë, len cutu huötj zxan yuꞌu tsajxíꞌ bi dë qui lu yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu zoa ladj guixiꞌ ral‑laꞌ gzxundjtë, len cutu huöaj tsajxíꞌ lariꞌ rxoa yeni. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bicaꞌ bayechiꞌ ngul dza niꞌ nuaꞌcnu‑biꞌ biꞌidauꞌ, lencaꞌ ngul tuꞌgádxiꞌnu‑biꞌ biꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ cugún bayúdx gzxundjliꞌ catiꞌ nac beoꞌ ziag. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuguꞌ dza niꞌ laꞌzacaꞌ laꞌguíꞌir bunách ca le guc zíꞌatël catiꞌ ziꞌa gutaꞌ yödzlyú le benëꞌ Dios ga rdxintë naꞌa dza, ni dza ziꞌa zaꞌc cutu gac cni. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Laꞌnaruꞌ cu nunëꞌ Dios ga luhuöác nabábz yuguꞌ dza niꞌ, nutu nu ulá, san le nadxiꞌinëꞌ nup chgröczëꞌ, chnunëꞌ queëꞌ gunëꞌ ga luhuöác nabábz yuguꞌ dza niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Naꞌa, chquiꞌ nu guië lbiꞌiliꞌ: “Gul‑yutscaꞌ, ni zoëꞌ Cristo”, o gna: “Gul‑yutscaꞌ, niꞌ zoëꞌ”, cutu caꞌ tséjlëꞌliꞌ nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Laꞌláꞌ lahui zian nup laꞌzíꞌ yeꞌi bunách, laꞌnë́ꞌ nacquëꞌ Cristo len laꞌnë́ꞌ nacquëꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios. Luluiꞌnëꞌ le lac bëꞌ len lunëꞌ yuguꞌ yöl‑laꞌ huac zxön. Hualaꞌzíꞌ yéꞌinëꞌ caꞌ nup gröczëꞌ Dios laꞌnaruꞌ laꞌzáquiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Niꞌr lbiꞌiliꞌ, gul‑zóa ban ládxiꞌliꞌ. Yúguꞌtë chgudxaꞌ lbiꞌiliꞌ zíꞌatël ca gac. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gnëꞌ caꞌ Jesús: ―Yuguꞌ dza niꞌ, töd gac dza naꞌ laꞌzacaꞌ laꞌguíꞌi cni bunách, gchul gbidz len cutu gun yeníꞌ beoꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Laꞌguíndj bölj luzxbá len laꞌzxíz le nalaꞌgac, nacgac blau luzxbá naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Niꞌr laꞌleꞌi nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, zaꞌa lu böaj luzxbá, napaꞌ yöl‑laꞌ huac zxön len yöl‑laꞌ yeníꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gsö́laꞌgacaꞌ‑nëꞌ gbaz laꞌy quiaꞌ, lutubëꞌ bunách rö quiaꞌ nacuáꞌ idáp laꞌa yödzlyú, ga naguél‑laꞌtë luyú bidx, ga rdxintë ga naguel‑laꞌ luzxbá. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Gul‑tsejniꞌi le rusëdi lbiꞌiliꞌ yag higo. Catiꞌ taꞌlén zxuzaꞌ nëꞌi huëꞌndauꞌ len rubía xlaguiꞌ yulu, nö́ziliꞌ chzoa gdxin dza gba. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lëzcaꞌ cni, catiꞌ gléꞌiliꞌ tac lë ni, gnö́ziliꞌ chzoa gdxin dza udx naꞌ, len chrdzag lau. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Le nactë rëpaꞌ lbiꞌiliꞌ, yúguꞌtë lë ni lac zíꞌatël ca lat nup nacuáꞌ dza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Huadö́d qui luzxbá len qui luyú ni, san xtidzaꞌa gatga töd qui. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Catiꞌ gdxin dza niꞌ o dzöꞌ niꞌ, nutu nu nözi. Cutu nözcnëꞌ gbaz laꞌy nacuꞌë yehuaꞌ yubá, len cutu nözdaꞌ nedaꞌ, Zxiꞌnëꞌ Dios. Tuzëꞌ Dios Xuz nöznëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Qui lë ni naꞌ, gul‑spán ládxiꞌliꞌ. Gul‑zóa sinaꞌ len gul‑lidzëꞌ Dios le cutu nö́ziliꞌ bizxa dza gac lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gac ca rac catiꞌ zijëꞌ ziꞌtuꞌ tu bönniꞌ. Catiꞌ chzoa uzë́ꞌë lidxëꞌ, udödëꞌ lu naꞌquëꞌ huen dxin queëꞌ yuguꞌ le dë queëꞌ. Qui queëquëꞌ guꞌë xchinquëꞌ len gna bëꞌë soa ban ladxiꞌ nu zoa huen chiꞌi ga nu ryaz. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gul‑zóa lbiꞌiliꞌ ban ladxiꞌ le cutu nö́ziliꞌ batx huödëꞌ xan yuꞌu, catiꞌ chrdzöꞌ, o gatsj lahuiꞌ yël, o catiꞌ rbödxbaꞌ zxiꞌn druz, o zildauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gul‑gún cni, cui duxaquëꞌë lbiꞌiliꞌ rasliꞌ chquiꞌ huödëꞌ tu tsalz. ");
INSERT INTO zsrNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lë ni rëpaꞌ lbiꞌiliꞌ, rëpaꞌ caꞌ yúguꞌtë bunách: Gul‑zóa ban ladxiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yechóp dza caꞌ gac Lni Pascua catiꞌ tuꞌspanëꞌ bönniꞌ judío ca benëꞌ Dios, buslë́ꞌ xuz xtauꞌquëꞌ luyú Egipto, nac lni catiꞌ tahuëꞌ yöt xtil cunazíꞌ xnëꞌi. Taꞌzú taꞌböꞌë bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi laꞌzönëꞌ Jesús bagachiꞌz quië ludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Taꞌnë́ꞌ: ―Cutu gac sönruꞌ‑nëꞌ dza lni le lun rusbö́ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zoëꞌ Jesús yödz Betania, lu yuꞌu lidxëꞌ Simón, bönniꞌ güiꞌinëꞌ huëꞌ nudzuꞌ ruzö́d. Tsal niꞌ röꞌë rahuëꞌ Jesús, gyaznu ngul, nuaꞌnu bö́gaꞌdauꞌ náquini guiöj zacaꞌ, yudz le rlaꞌ zxix qui yöj susén las gdu, le zacaꞌ szxöni. Blaꞌanu bö́gaꞌdauꞌ naꞌ len gluꞌnu le rlaꞌ zxix icjëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gulaléylanëꞌ laꞌquëꞌ bönniꞌ nacuꞌë niꞌ, taꞌnë́ꞌ laꞌ légaczëꞌ: ―¿Bizx quië guc ditj le zxix naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Laꞌnaruꞌ nu gutiꞌ lë naꞌ, huazíꞌ qui yelatiꞌ ca lazxjruꞌ qui tu iz quië nu quisi quegac bunách yechiꞌ. Szxöni gulanë́ꞌ queënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Niꞌr Jesús bëꞌë didzaꞌ, rnëꞌ: ―Gul‑güíꞌ‑nu latj. ¿Bizx quië rnë ziꞌliꞌ queënu? Nac dxiꞌa le bennu quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nacuáꞌlentecz lbiꞌiliꞌ bunách yechiꞌ, len báttiꞌtëz guë́ꞌniliꞌ, huac gunliꞌ dxiꞌa quequëꞌ, san nedaꞌ cutu sóateczaꞌ ga zoaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tsca le gzxáquiꞌnu bennu ngul ni. Gluꞌnu nedaꞌ le rlaꞌ zxix ni, bupaꞌnu nedaꞌ zíꞌatël ca ggachaꞌa yeru ba. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Le nactë rëpaꞌ lbiꞌiliꞌ, gátiꞌtëz ga gac lban qui didzaꞌ dxiꞌa quiaꞌ gdu yödzlyú, soa nu quixjöꞌ caꞌ lë ni bennu quiaꞌ ngul ni. Cni gac quië nu tsajnéy lënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Niꞌr brujëꞌ Judas Iscariote, bönniꞌ nabáblenëꞌ chinnuëꞌ naꞌ daꞌquëꞌ Jesús, gyijëꞌ ga nacuꞌë bxuz uná bëꞌ quië udödëꞌ Jesús lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Catiꞌ gulayönnëꞌ xtidzëꞌë Judas naꞌ, guludzijnëꞌ atiꞌ gulazíꞌ lu naꞌquëꞌ luꞌë lëꞌ dumí. Niꞌr gzu lahuëꞌ Judas rzu rböꞌë udödëꞌ Jesús lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nac dza rzu lau lni tahuëꞌ yöt xtil cunazíꞌ xnëꞌi, dza naꞌ tuꞌdöddëꞌ‑baꞌ böꞌcuꞌ zxílaꞌdauꞌ tahuëꞌ Lni Pascua naꞌ, catiꞌ tuꞌspanëꞌ ca benëꞌ Dios buslë́ꞌ bönniꞌ judío luyú Egipto. Niꞌr gulanabnëꞌ Jesús bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Gazx rëꞌnnuꞌ tseajtuꞌ tsajpaꞌtuꞌ le gáguruꞌ xtsöꞌ qui Lni Pascua? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niꞌr bsölëꞌë chopëꞌ bönniꞌ usë́d queëꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑tséaj lu yödz. Niꞌ huadzagliꞌ tu bönniꞌ nuꞌë röꞌö nis. Gul‑tséajlenëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga naꞌ tsaziëꞌ, gul‑guië́ꞌ xan yuꞌu naꞌ: “Rnëꞌ Bönniꞌ Usëdi: ¿Gazx zoa yuꞌu ga naꞌ gágulengacaꞌ‑nëꞌ bönniꞌ usë́d quiaꞌ xtsöꞌ qui Lni Pascua?” ");
INSERT INTO zsrNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Niꞌr uluiꞌinëꞌ lbiꞌiliꞌ tu yuꞌu zxön ga nac buróp cuia ga chnabáꞌa. Gul‑páꞌ niꞌ le gáguruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Gularujëꞌ bönniꞌ usë́d queëꞌ naꞌ, guladxinëꞌ lu yödz, atiꞌ yajxácaꞌquëꞌ yúguꞌtë ca naꞌ chgudxëꞌ lequëꞌ Jesús. Gulupë́ꞌë niꞌ le lahuëꞌ qui Lni Pascua. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Catiꞌ chgul, bdxinëꞌ niꞌ Jesús, dzagquëꞌ Lëꞌ idxínnutëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tsal niꞌ röꞌquëꞌ tahuëꞌ, bëꞌë didzaꞌ Jesús, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, zoa nu dzag lbiꞌiliꞌ, nu rágulen nedaꞌ tsazxö́n, udö́d nedaꞌ lu naꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Niꞌr guluhuiꞌnnëꞌ len gulazú lauquëꞌ tëꞌ Lëꞌ tu tuëꞌ: ―¿Naruꞌ nedaꞌ? Yetúëꞌ caꞌ gnëꞌ: ―¿Naruꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Nac nu nutsaꞌ ladj chínnuliꞌ ni, bönniꞌ naꞌ nunë́ꞌë nëꞌë tsazxö́n len naꞌa lu zxigaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tsijaꞌ ga gatiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, ca naꞌ nayúj lu guich laꞌy ca gac quiaꞌ, san bicaꞌ bayechiꞌ bönniꞌ naꞌ udödëꞌ nedaꞌ lu naꞌquëꞌ bönniꞌ ludöddëꞌ nedaꞌ. Dxiꞌar gac queëꞌ bönniꞌ naꞌ laꞌnaruꞌ cu guljëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tsal niꞌ tahuëꞌ, gdel‑lëꞌë yöt xtil Jesús. Gudxëꞌ Dios: “Xclenuꞌ.” Buzxuzxjëꞌ lei len bëꞌë quequëꞌ, rnëꞌ: ―Gul‑gagu. Lë ni nac gdu ca nayáꞌ nabanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gdel‑lëꞌë caꞌ tu zxígaꞌdauꞌ len gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr bëꞌë quequëꞌ, atiꞌ glëꞌjcdëꞌ lei yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rëꞌ lequëꞌ Jesús: ―Lë ni xchönaꞌ le run tsutsu didzaꞌ cub rucáꞌn tsahuiꞌ, le núnlenëꞌ bunách Dios. Rön ni glalj niꞌa quegac bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Le nactë rëpaꞌ lbiꞌiliꞌ, cutur guiꞌjaꞌ xisi uva ga gdxinr dza guiꞌjaꞌ le cub ga niꞌ rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gdöd glul‑lëꞌ yöl‑laꞌ ba, gularujëꞌ zjaquëꞌ Guiꞌa Ga Röꞌgac Yag Olivo. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Niꞌr gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Yúguꞌtëliꞌ gac chop ládxiꞌliꞌ, ucaꞌnliꞌ nedaꞌ naꞌa dzöꞌ, le nayúj lu guich laꞌy, rna: “Gdöddaꞌ‑nëꞌ uyú böꞌcuꞌ zxilaꞌ, atiꞌ láslasbaꞌ böꞌcuꞌ zxilaꞌ naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Töd ubanaꞌ lu yöl‑laꞌ gut, ziꞌal ca lbiꞌiliꞌ tsijaꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Niꞌr Pedro gudxëꞌ Jesús, rnëꞌ: ―Zal‑laꞌ lac chop ládxiꞌquëꞌ, lucaꞌnëꞌ Liꞌ yúguꞌtëꞌ, cutu caꞌ gac chop ladxaꞌa nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús gudxëꞌ lëꞌ, rnëꞌ: ―Le nactë rëpaꞌ liꞌ, laꞌ dzöꞌ niz, ziꞌa cödxlbaꞌ zxiꞌn druz le buróp lzu, tsonn lzu gnauꞌ cutu núnbëꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Niꞌr gneynëꞌ Dios Pedro, rnëꞌ: ―Zal‑laꞌ gátlenteaꞌ Liꞌ tsazxö́n, cutu caꞌ gniaꞌ cutu núnbëꞌa Liꞌ. Lëzcaꞌ cni gulanë́ꞌ yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Niꞌr guladxinëꞌ laꞌ yël Getsemaní Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, atiꞌ gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑cö́ꞌ ni, tsal tsijaꞌ nedaꞌ, tsajlidzaꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bchëꞌë Pedro len Jacobo len Juan, atiꞌ gzu lahuëꞌ rdzöbnëꞌ Jesús len rsëbi ladxëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Huatczaꞌ lu yöl‑laꞌ rsëbi ladxiꞌ. Gul‑cö́z ni len gul‑náꞌ yël. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Niꞌr gzëꞌë Jesús yelátiꞌdauꞌ len butság lahuëꞌ lyu, bulidzëꞌ Dios. Gnabnëꞌ Lëꞌ, chquiꞌ huac, ucuitëꞌ queëꞌ le ral‑laꞌ sacaꞌ quiꞌë dza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Niꞌ rulidzëꞌ Dios, rnëꞌ: ―Xúzaꞌdauꞌ, yúguꞌtë huac gunuꞌ Liꞌ. Bcuit lë naꞌ ral‑laꞌ sacaꞌ quiꞌa, san clëg ca rëꞌndaꞌ nedaꞌ, san ca rëꞌnnuꞌ Liꞌ, gunuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Niꞌr böjëꞌ Jesús ga naꞌ nacuꞌë bönniꞌ usë́d queëꞌ, yajxaquëꞌë lequëꞌ tasiëꞌ. Gudxëꞌ Pedro: ―Simón, ¿rastsuꞌ? ¿Naruꞌ cu rubijtsuꞌ yen lauꞌ tu chiꞌitëz? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gul‑náꞌ yël len gul‑lidzëꞌ Dios, gnábiliꞌ‑nëꞌ cui gataꞌ latj dulúꞌu yöl‑laꞌ lbiꞌiliꞌ tuꞌ xöhuiꞌ. Le nactë böꞌ nacczliꞌ zoacz sinaꞌ, san lu yöl‑laꞌ bunách queëliꞌ rcuídiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Niꞌr zijëꞌ leyúbl Jesús, rulidzëꞌ Dios, len laꞌ tuz ca gnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Catiꞌ böjëꞌ leyúbl ga naꞌ nacuꞌë, yajxaquëꞌë lequëꞌ tasiëꞌ le dxia bëchcál lauquëꞌ. Cutu nözcnëꞌ bizxa didzaꞌ lubiꞌë, lëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Catiꞌ böjëꞌ le bunn lzu ga naꞌ nacuꞌë, rëꞌ lequëꞌ: ―¿Rástsaliꞌ? ¿Ruzíꞌtsa ládxiꞌliꞌ? Tscaꞌtiꞌ gaz. Chbdxin dza. Gul‑yutscaꞌ, Nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, chnadödaꞌ lu naꞌgac bunách dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gul‑tsás, huayejruꞌ. Gul‑yutscaꞌ, chzëꞌë bönniꞌ naꞌ udödëꞌ nedaꞌ lu naꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Niꞌ ruꞌë didzaꞌ ni Jesús, bdxinëꞌ Judas, bönniꞌ nabáblenëꞌ chinnuëꞌ naꞌ daꞌquëꞌ Jesús, atiꞌ záꞌclenëꞌ lëꞌ bönniꞌ zian, nuaꞌquëꞌ guia tuchiꞌ len yag. Nasö́laꞌquëꞌ lequëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi len bönniꞌ gul tuꞌzejniꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, bönniꞌ naꞌ rudödëꞌ Jesús lu naꞌquëꞌ chnuluiꞌinëꞌ lequëꞌ tu le gac bëꞌ nu nac Jesús, gnëꞌ: ―Bönniꞌ naꞌ utság lahuaꞌ‑nëꞌ, Lëꞌ naꞌ Jesús. Gul‑sönëꞌ len gul‑chë́ꞌë. Gul‑yutsquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Catiꞌ bdxinëꞌ niꞌ Judas, laꞌ gbígaꞌtëꞌ ga naꞌ zoëꞌ Jesús len gudxëꞌ Lëꞌ: ―Bönniꞌ Usëdi, Bönniꞌ Usëdi. Niꞌr butság lahuëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Niꞌr gulazönëꞌ Jesús len gulachë́ꞌë Lëꞌ nadzunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Niꞌr tuëꞌ bönniꞌ niꞌ dëꞌë Jesús glijëꞌ guia tuchiꞌ len benëꞌ‑biꞌ huëꞌ biꞌi huen dxin queëꞌ bxuz blau, bchuguëꞌ guid nagbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús gudxëꞌ bunách naꞌ, rnëꞌ: ―¿Narújtsaliꞌ nuaꞌliꞌ guia tuchiꞌ len yag quië sönliꞌ nedaꞌ, runliꞌ ca runliꞌ rzönliꞌ‑nëꞌ gban? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yuguꞌ dza gzóalenaꞌ lbiꞌiliꞌ rusë́dgacdaꞌ bunách ga nac nchil gdauꞌ atiꞌ cutu gzxönliꞌ nedaꞌ, san rac cni quië utság le nayúj lu guich laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Niꞌr gulucaꞌnëꞌ Jesús yúguꞌtë bönniꞌ usë́d queëꞌ, taꞌzxundjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Zoabiꞌ caꞌ niꞌ biꞌi raꞌbán zajnaubiꞌ Jesús, nuxóaz cuinbiꞌ lariꞌ blagaꞌ. Yuguꞌ bönniꞌ naꞌ nachëꞌquëꞌ Jesús gulazönëꞌ‑biꞌ ");
INSERT INTO zsrNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","san busanbiꞌ lariꞌ naꞌ, xguidzbiꞌ buzxundjbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gulachë́ꞌë Jesús lahuëꞌ bxuz blau, atiꞌ niꞌ guludubëꞌ yúguꞌtë bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi len bönniꞌ gdauꞌ tuꞌsëdi. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro yajnáuëꞌ Jesús ziꞌtuꞌ ziꞌtuꞌz, gyaziëꞌ löꞌa lidx bxuz blau naꞌ len grö́ꞌlenëꞌ tsazxö́n niꞌa nëꞌë bxuz blau naꞌ, rutsëꞌi cuinëꞌ raꞌ guiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yuguꞌ bxuz uná bëꞌ len yúguꞌtë bönniꞌ yúlahuiꞌ blau guluguiljëꞌ tu le luspaguëꞌë Jesús quië gac laꞌchuguëꞌ queëꞌ gatiëꞌ san cutu bi guludzölnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gulanë́ꞌ queëꞌ Jesús le cunácz bönniꞌ zian, san cutu yajlözgac le gulanë́ꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Niꞌr gulazuinëꞌ bönniꞌ gulanë́ꞌ queëꞌ Jesús le cunácz, taꞌnë́ꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Netuꞌ byö́nituꞌ didzaꞌ bëꞌë bönniꞌ ni, gnëꞌ: “Uquindjaꞌ gdauꞌ ni, lë ni naqui lu niꞌa lu naꞌ bunách, atiꞌ tsonn dzaz uchisaꞌ yetú le cunaqui lu niꞌa lu naꞌ bunách.” ");
INSERT INTO zsrNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni lë ni, cutu yajlözgac xtídzaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Niꞌr gyasëꞌ bxuz blau naꞌ gatsj lahuiꞌl bunách nacuáꞌ niꞌ, len gnabnëꞌ Jesús, rnëꞌ: ―¿Naruꞌ cu rubiꞌtsuꞌ didzaꞌ? ¿Bizxa naꞌ taꞌnë́ꞌ quiuꞌ bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús, dxiz zoëꞌ, cutu bi didzaꞌ rubiꞌë. Gnabnëꞌ Lëꞌ leyúbl bxuz blau naꞌ, rnëꞌ: ―¿Naruꞌ nacuꞌ Liꞌ Cristo, Zxiꞌnëꞌ Dios Laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Nacaꞌ. Gléꞌiliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, soaꞌ cöꞌa cuitiëꞌ yubél Dios napczëꞌ yöl‑laꞌ huac catiꞌ niꞌ huödaꞌ lu böaj luzxbá. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Niꞌr lu yöl‑laꞌ rley queëꞌ bchözëꞌ lariꞌ nacuëꞌ bxuz blau naꞌ, rnëꞌ: ―¿Nuzxar naquíniruꞌ nu quixjöꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ryö́niczliꞌ rucaꞌnëꞌ Dios caꞌz len didzaꞌ ruꞌë. ¿Nacx runi lbiꞌiliꞌ? Yúguꞌtëꞌ gulachuguëꞌ queëꞌ gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Niꞌr gulazú lauquëꞌ laꞌquëꞌ tuꞌchijëꞌ Jesús zxönaꞌ. Guluseyjëꞌ lahuëꞌ len glundëꞌ Lëꞌ ziꞌ, taꞌnë́ꞌ: ―Gnë yaꞌatscaꞌ nuzxa naꞌ bëꞌ Liꞌ. Gulagapëꞌë ruꞌë Jesús bönniꞌ niꞌa nëꞌë bxuz blau. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Catiꞌ niꞌ zoëꞌ Pedro löꞌa zxan yuꞌu, bdxinbiꞌ ga zoëꞌ biꞌi ngul huen dxin queëꞌ bxuz blau naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Catiꞌ bléꞌibiꞌ Pedro, röꞌë rutsëꞌi cuinëꞌ raꞌ guiꞌ, buyubiꞌ lëꞌ, rnabiꞌ: ―Daꞌu caꞌ liꞌ Jesús, bönniꞌ Nazaret naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Gdáꞌbaguëꞌë Pedro, rnëꞌ: ―Cutu núnbëꞌa‑nëꞌ, len cutu nözdaꞌ bizxa naꞌ rnauꞌ. Burujëꞌ Pedro yajsóëꞌ ga nu ryaz löꞌa. Niꞌr grödxbaꞌ zxiꞌn druz. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Buyubiꞌ lëꞌ leyúbl biꞌi ngul huen dxin naꞌ, len gzu laubiꞌ rëbiꞌ nup nacuáꞌ niꞌ: ―Bönniꞌ ni dzaguëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Leyúbl gdáꞌbaguëꞌë Pedro. Yelatiꞌ gdzey të Pedro nup nacuáꞌ niꞌ, taꞌná: ―Le nactë dzaguꞌ lequëꞌ, le nacuꞌ bönniꞌ Galilea. Yöl‑laꞌ ruiꞌz quiuꞌ didzaꞌ nac bëꞌu, le tuz ca rnëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Gzu lahuëꞌ Pedro rudxía döꞌ cuinëꞌ, len rneynëꞌ Dios, rnëꞌ: ―Cutu caꞌ núnbëꞌa‑nëꞌ bönniꞌ naꞌ ruiꞌliꞌ didzaꞌ ca nac queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Laꞌ grö́dxtëbaꞌ zxiꞌn druz le buróp lzu. Niꞌr yajneynëꞌ Pedro didzaꞌ naꞌ bëꞌë Jesús, gudxëꞌ lëꞌ: “Ziꞌa cödxlbaꞌ zxiꞌn druz le buróp lzu, tsonn lzu gnauꞌ cutu núnbëꞌu nedaꞌ.” Catiꞌ yajneynëꞌ didzaꞌ ni, gzu lahuëꞌ rbödxtsquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Niꞌ nac zildauꞌ, glun xtídzaꞌquëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi len bönniꞌ gdauꞌ tuꞌsëdi, len yúguꞌtë bönniꞌ yúlahuiꞌ blau. Niꞌr gulachë́ꞌë Jesús náguëꞌë len guludödëꞌ Lëꞌ lu nëꞌë Pilato, bönniꞌ rna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato gnabnëꞌ Jesús, rnëꞌ: ―¿Naruꞌ nacuꞌ Liꞌ Bönniꞌ gna béꞌinëꞌ bunách judío? Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Ca nacz rnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Zian le guluquíëꞌ Jesús bxuz uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Niꞌr gnabnëꞌ Lëꞌ leyúbl Pilato, rnëꞌ: ―¿Naruꞌ cu rubiꞌtsuꞌ didzaꞌ? Bzëtscaꞌ naguꞌ cátiꞌga zian le taꞌnë́ꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Cutu bi didzaꞌ bubiꞌë Jesús. Caꞌ guc, bubannëꞌ Pilato. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dë tu le runëꞌ Pilato catiꞌ rac lni naꞌ, rusanëꞌ quegac bunách tu bönniꞌ nadzunëꞌ lidx guia, nútiꞌtëz nu taꞌnáb. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nadzunëꞌ lidx guia bönniꞌ lëꞌ Barrabás, atiꞌ dzagquëꞌ lëꞌ yelaꞌquëꞌ lzëꞌë, bönniꞌ guludödcdëꞌ bunách catiꞌ guladáꞌbaguëꞌë yúlahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Catiꞌ guladxín niꞌ bunách zian, gulazú lauquëꞌ taꞌnabëꞌ lahuëꞌ Pilato gunëꞌ quequëꞌ ca runczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bubiꞌë didzaꞌ Pilato, rnëꞌ: ―¿I rë́ꞌniliꞌ usanaꞌ‑nëꞌ queëliꞌ Bönniꞌ Gna Béꞌinëꞌ Bunách Judío? ");
INSERT INTO zsrNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Cni gnëꞌ Pilato le ráquibeꞌinëꞌ guludödëꞌ Jesús lu nëꞌë bxuz uná bëꞌ le tuꞌzxéꞌinëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gulaguꞌë xla ládxiꞌgac bunách zian naꞌ bxuz uná bëꞌ naꞌ, quië laꞌnabëꞌ lahuëꞌ Pilato usanëꞌ lu naꞌquëꞌ Barrabás. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Niꞌr gnabnëꞌ lequëꞌ leyúbl Pilato, rnëꞌ: ―¿Bizxa rë́ꞌniliꞌ gunaꞌ queëꞌ bönniꞌ naꞌ ruiꞌliꞌ lëꞌ, Bönniꞌ Gna Béꞌinëꞌ Bunách Judío? ");
INSERT INTO zsrNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Bdëꞌë lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Gnabnëꞌ lequëꞌ Pilato, rnëꞌ: ―¿Bizxa caz döꞌ nuꞌë? Leyúbl tuꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Bdëꞌë lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Le guꞌnnëꞌ Pilato gunëꞌ ga laꞌdzág ládxiꞌgac bunách zian naꞌ, busanëꞌ lu naꞌquëꞌ Barrabás. Niꞌr gna béꞌinëꞌ nu quin Jesús, atiꞌ budödëꞌ Lëꞌ lu naꞌquëꞌ bönniꞌ ludë́ꞌë Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Niꞌr gulachë́ꞌë Jesús löꞌa yúlahuiꞌ bönniꞌ rjaquëꞌ gdil‑l, atiꞌ niꞌ gulutubëꞌ lzaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gulugacuëꞌ Jesús lariꞌ xna, len glunëꞌ tu breguiꞌ zxuzaꞌ nëꞌi yötsiꞌ, guludxíëꞌ icjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Niꞌr gulazú lauquëꞌ tuꞌlidzëꞌ Jesús, taꞌnë́ꞌ: ―Yöl‑laꞌ ba liꞌ, rna béꞌinuꞌ bunách judío. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gulaguinëꞌ gui icjëꞌ len guluchijëꞌ Lëꞌ zxönaꞌ. Guluzechu zxibquëꞌ lahuëꞌ, len lu yöl‑laꞌ rutítj glunëꞌ Lëꞌ ba laꞌn. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Catiꞌ budx gulutitjëꞌ Lëꞌ, gulugǘëꞌ lariꞌ xna naꞌ nacuëꞌ atiꞌ gulugacuëꞌ Lëꞌ lariꞌ queëczëꞌ. Niꞌr gulachë́ꞌë Lëꞌ niꞌl yúlahuiꞌ naꞌ quië tsajdaꞌquëꞌ Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Glunëꞌ ga guꞌë yag cruz queëꞌ Jesús bönniꞌ Cirene, rdödzëꞌ niꞌ zuzë́ꞌë ladj guixiꞌ. Lëꞌ Simón, len naquëꞌ xuzcbiꞌ Alejandro len Rufo. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gulachë́ꞌë Jesús latj nazíꞌ lei Gólgota, tu didzaꞌ hebreo le rna lu didzaꞌ xidzaꞌ, Latj Qui Bögaꞌ Icjruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gluꞌë le guiꞌjëꞌ Jesús xisi uva nutsiꞌi nör slaꞌ qui mirra, san Lëꞌ cutu guꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Niꞌr guludë́ꞌë Lëꞌ lëꞌi yag cruz, atiꞌ gulaguisiëꞌ lariꞌ nacuëꞌ Jesús, gulazíꞌ qui queëquëꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l. Gulubijëꞌ le gac bëꞌ quië laꞌnöznëꞌ bizxal gdel‑laꞌ qui queëquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nac gdu xsil catiꞌ guludë́ꞌë Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Didzaꞌ naꞌ guluzóëꞌ lëꞌi yag cruz icjlëꞌ Jesús ca nac le tuꞌquíëꞌ Lëꞌ rna cni: “Bönniꞌ Rna Béꞌinëꞌ Bunách Judío.” ");
INSERT INTO zsrNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tsazxö́n guludáꞌlenëꞌ Jesús lë́ꞌigac yag cruz chopëꞌ gban, tuëꞌ cuit lëꞌë yubél len yetúëꞌ cuit lëꞌë yögl. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Cni guc, butság lë naꞌ nayúj lu guich laꞌy, rna: “Gbáblenëꞌ bönniꞌ tuaꞌdöꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bönniꞌ taꞌdödëꞌ niꞌ tuꞌlídz ziꞌë Jesús, tuꞌtá icjquëꞌ, taꞌnë́ꞌ: ―¡Ja! ¿Naruꞌ uquindjtsuꞌ gdauꞌ queëꞌ Dios atiꞌ tsonn dzaz uchistsuꞌ lei? ");
INSERT INTO zsrNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Buslá cuinuꞌ naꞌa len bötj lëꞌi yag cruz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lëzcaꞌ cni tuꞌtitjëꞌ Lëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi, të lzaꞌquëꞌ tuëꞌ yetúëꞌ: ―Bunách yubl buslë́ꞌ, san cutu gac uslá cuinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taꞌnë́ꞌ caꞌ: ―¡Ja! ¿Nactsuꞌ Cristo, Bönniꞌ Gna Béꞌinëꞌ Bunách Israel? Bötjtscaꞌ naꞌa lëꞌi yag cruz quië gléꞌituꞌ atiꞌ tséjlëꞌtuꞌ Liꞌ. Gululídz ziꞌë caꞌ Lëꞌ bönniꞌ naꞌ daꞌquëꞌ tsazxö́n len Lëꞌ lë́ꞌigac yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Catiꞌ bdxin gdu huagbídz, bchul gdutë yödzlyú, guc cni ga bdxintë gdu rdöd xhuö. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gdu rdöd xhuö naꞌ bëꞌë zidzj didzaꞌ Jesús, rnëꞌ: ―Eloi, Eloi, ¿lama sabactani? Didzaꞌ hebreo ni rna lu didzaꞌ xidzaꞌ: “Dios quiaꞌ, Dios quiaꞌ, ¿bizx quië nubíj ladxuꞌu nedaꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gulayönnëꞌ didzaꞌ ni bönniꞌ nacuꞌë niꞌ, atiꞌ taꞌnë́ꞌ: ―Gul‑zëtscaꞌ nagliꞌ. Elías rulidzëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Niꞌr gxítiꞌë bönniꞌ nutsëꞌë ladjquëꞌ, buxúpinëꞌ nup zi tu le blul riꞌj nis. Budë́ꞌë lei lahui gui len bëꞌë le xupëꞌ Jesús, rnëꞌ: ―Cö́ztscaꞌruꞌ, uyuruꞌ chquiꞌ huidëꞌ Elías uzötjëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Grödxyëꞌë zidzj Jesús, guttëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Brözaꞌ lariꞌ yödx nal‑laꞌ lu gdauꞌ, bruj chopl, gdel‑laꞌ icjl burujtë zxanil. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bönniꞌ naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l zuinëꞌ lahuëꞌ Jesús, bléꞌinëꞌ ca naꞌ guc grödxyëꞌë Jesús, guttëꞌ, atiꞌ gnëꞌ: ―Le nactë bönniꞌ ni guquëꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nacuaꞌnu caꞌ niꞌ ngul, ziꞌtuꞌz tuꞌyunu. Nútsaꞌcnu ladjcnu María Magdalena len Salomé len María, xnaꞌcbiꞌ Jacobo cuidiꞌ len José. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ngul ni yjáclennu Jesús catiꞌ niꞌ gdëꞌ luyú Galilea, gláclennu Lëꞌ, gulaguꞌnu le glahuëꞌ. Nacuaꞌnu caꞌ niꞌ yelaꞌcnu ngul zian gulazáꞌclennu Lëꞌ lu yödz Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chzaꞌ ral len nac dza tuꞌpë́ꞌë, dza ziꞌa gdxin dza laꞌy quequëꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Qui lë ni naꞌ bidëꞌ José, bönniꞌ yödz Arimatea, naquëꞌ bönniꞌ blau ladjquëꞌ bönniꞌ yúlahuiꞌ blau, len rbözëꞌ caꞌ dza gna bëꞌë Dios. Gdu ladxëꞌë gyaziëꞌ ga naꞌ zoëꞌ Pilato len gnabnëꞌ lëꞌ guꞌë lëꞌ latj uꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bubannëꞌ Pilato le gnëꞌ chgutiëꞌ Jesús, atiꞌ bulidzëꞌ bönniꞌ naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l quië gnabnëꞌ lëꞌ chquiꞌ chnatiëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Catiꞌ byönnëꞌ ca naꞌ gnëꞌ bönniꞌ naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, bëꞌë José latj uꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Niꞌr José naꞌ guꞌuëꞌ lariꞌ záquiꞌtsqui, atiꞌ buzötjëꞌ Jesús lëꞌi yag cruz len buchö́linëꞌ Lëꞌ lariꞌ záquiꞌtsqui naꞌ. Niꞌr gluꞌë Lëꞌ yeru ba nadj lëꞌi guiꞌa guiöj. Budë́ꞌë tu guiöj blag zxön ga nu ryaz ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tuꞌyunu ga naꞌ rguꞌë Jesús María Magdalena len María, xnëꞌë José. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Catiꞌ chnadö́d dza laꞌy quegac bunách judío le nac dza sábado, taꞌziꞌnu yuguꞌ le rlaꞌ zxix quië tsajluꞌcnu Jesús María Magdalena, len Salomé, len María, xnëꞌë Jacobo. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Niꞌ nac zildauꞌ dza domingo, yjacnu raꞌ yeru ba queëꞌ. Guladxinnu niꞌ catiꞌ ziꞌa blen gbidz. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Të lzaꞌcnu: ―¿Nuzxa cuatsa queëruꞌ guiöj naꞌ daꞌ ga nu ryaz ba queëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Catiꞌ guladxinnu niꞌ, guluyunu len gulaléꞌinu chnadúa guiöj naꞌ, atiꞌ guiöj zxön nac. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Gulayuꞌnu yeru ba lëꞌi guiꞌa guiöj naꞌ, atiꞌ niꞌ gulaléꞌinu‑biꞌ tubiꞌ biꞌi bönniꞌ raꞌbán, nacbiꞌ gbaz laꞌy queëꞌ Dios. Röꞌbiꞌ tslaꞌa yubél lu yeru ba naꞌ, nácubiꞌ lariꞌ tunn chguichdauꞌz. Gládxitsquinu. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Niꞌr gudxbiꞌ lecnu biꞌi naꞌ, rnabiꞌ: ―Cutur gádxiliꞌ. Ruguiljliꞌ Jesús, bönniꞌ Nazaret, Nu naꞌ gdaꞌ lëꞌi yag cruz. Chbubanëꞌ. Cutu zoëꞌ ni. Gul‑yú ga ni gulaguꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gul‑tséaj naꞌa, gul‑tsajtixjöiꞌ caꞌ yuguꞌ bönniꞌ usë́d queëꞌ lencaꞌ Pedro, guiëliꞌ lequëꞌ: “Tsijëꞌ Jesús ziꞌal ca lbiꞌiliꞌ luyú Galilea. Niꞌ uléꞌiliꞌ‑nëꞌ ca naꞌ chgudxczëꞌ lbiꞌiliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Niꞌr gulurujnu niꞌ, guluzxundjnu raꞌ yeru ba naꞌ le taꞌzxiznu lu yöl‑laꞌ radxi rdzöbi quecnu. Nutu nu glënu caꞌ le tádxinu. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Catiꞌ bubanëꞌ Jesús zildauꞌ dza domingo naꞌ, buluíꞌ lahuëꞌ ziꞌal launu María Magdalena, ngul naꞌ bubijëꞌ gadx böꞌ xöhuiꞌ gulayúꞌu lënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Gyeajnu yajtíxjöiꞌnu nup naꞌ guladalen Jesús. Nup ni taꞌsëbi ládxiꞌgac len taꞌbö́dx. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Catiꞌ gulayönnëꞌ didzaꞌ ruiꞌnu, zoëꞌ nabanëꞌ Jesús atiꞌ bléꞌicznu Lëꞌ, cutu gulayejlëꞌë lënu. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gdöd naꞌ, nadzáꞌl buluíꞌ lahuëꞌ Jesús lauquëꞌ chopëꞌ bönniꞌ usë́d queëꞌ yuꞌuquëꞌ nöz, zjaquëꞌ ga nac ladj guixiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Niꞌr yjaquëꞌ, yajtíxjöiꞌcnëꞌ yezícaꞌrëꞌ, atiꞌ ni xtídzaꞌquëꞌ cutu gulayejlëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ga yajseytë, buluíꞌ lahuëꞌ Jesús lauquëꞌ idxineajtëꞌ tsal niꞌ röꞌquëꞌ tahuëꞌ, atiꞌ gdil‑lëꞌ lequëꞌ le cutu taꞌyejlëꞌë Lëꞌ len le nac zid icj ládxiꞌdauꞌquëꞌ, cutu gulayejlëꞌë xtídzaꞌgac nup naꞌ gulaleꞌi Lëꞌ nubanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Niꞌr gudxëꞌ lequëꞌ, rnëꞌ: ―Gul‑tséaj gdu yödzlyú tsjenliꞌ lban qui didzaꞌ dxiꞌa laugac yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu tsejlëꞌ nedaꞌ len gdil nis, ulá nu naꞌ, san nu cutu tsejlëꞌ, grugu qui, gat nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Le lac bëꞌ ni lunëꞌ bönniꞌ laꞌyejlëꞌë nedaꞌ. Lugunëꞌ dxin laꞌ nedaꞌ, lubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách len luꞌë didzaꞌ yubl. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Chquiꞌ laꞌzönëꞌ‑baꞌ bël lu naꞌquëꞌ, o chquiꞌ liꞌjëꞌ le nachë́ꞌ yöl‑laꞌ gut, cutu bi gun quequëꞌ. Laꞌxóa nëꞌë nup teꞌi, atiꞌ luhuöactë. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Catiꞌ budx bë́ꞌlenëꞌ lequëꞌ didzaꞌ ni Xanruꞌ, buchisëꞌ Lëꞌ Dios yehuaꞌ yubá ga niꞌ gröꞌë cuitiëꞌ yubél Dios. ");
INSERT INTO zsrNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Gularujëꞌ lequëꞌ, rjenquëꞌ lban yúguꞌtë yödz. Gúclenëꞌ lequëꞌ Xanruꞌ, benëꞌ ga glunëꞌ le nacgac bëꞌ nac gdutë li didzaꞌ tuꞌë. Caꞌ nac.");
INSERT INTO zsrNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Zian nup chglun bayúdx luzúj lu guich, gaz lu dzöꞌ yuguꞌ le naccz, le guc ga zoaruꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","catëz naꞌ gululuíꞌi rëꞌu nup niꞌ dza niꞌtë gulaleꞌi lei, len guluzë́ didzaꞌ qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Runi nedaꞌ nac dxiꞌa uzujaꞌ quiuꞌ lu guich, gaz lu dzöꞌ yuguꞌ lë ni, Teófilo, bönniꞌ tsáhuiꞌdauꞌ, le chbuguiljaꞌ gazxj ga rëꞌ ca nac yúguꞌtë lë naꞌ guc dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ruzujaꞌ quiuꞌ lu guich ni quië gnöznuꞌ nac gdutë li lë naꞌ chnazëduꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dza niꞌtë catiꞌ gna bëꞌë luyú Judea Herodes, niꞌ zoëꞌ bxuz lëꞌ Zacarías. Nabáblenëꞌ cöꞌ bxuz, nazíꞌ lei Cöꞌ Queëꞌ Abías. Nacnu caꞌ zxiꞌn xsoëꞌ Aarón, bönniꞌ guquëꞌ bxuz blau ziꞌal, Elisabet, ngul queëꞌ Zacarías naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nacquëꞌ tsahuiꞌ lahuëꞌ Dios Zacarías len Elisabet, len gdu ládxiꞌquëꞌ tunëꞌ ca rna xtidzëꞌë Dios len le rna bëꞌ zxba queëꞌ. Cni guc, nutu nu guc bi gnë quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nutu nu zoa biꞌi quequëꞌ, le nacnu ngul huödx Elisabet, atiꞌ chnagulquëꞌ groptëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bdxin dza gul‑laꞌ uláz qui cöꞌ naꞌ nabáblenëꞌ Zacarías lunëꞌ dxin lahuëꞌ Dios, lu yöl‑laꞌ bxuz quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ca nalëbcnëꞌ tunëꞌ bxuz, gul‑laꞌ uláz queëꞌ Zacarías gyaziëꞌ lu latj laꞌy qui gdauꞌ quië uzéguiꞌë yal lahuëꞌ Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tsal niꞌ ruzéguiꞌë yal Zacarías naꞌ, gulacuáꞌ niꞌl yúguꞌtë bunách, tuꞌlídz Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Laꞌ naꞌz buluíꞌ lahuëꞌ gbaz laꞌy queëꞌ Xanruꞌ ga zoëꞌ Zacarías naꞌ, zuinëꞌ tslaꞌa yubél bcugu laꞌy ga naꞌ regui yal. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Catiꞌ bléꞌinëꞌ gbaz laꞌy naꞌ Zacarías, gröꞌë baguíꞌi len gudxi bdzöbnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Niꞌr gudxëꞌ lëꞌ gbaz laꞌy naꞌ, gnëꞌ: ―Zacarías, cutu gádxinuꞌ, le chbyönnëꞌ Dios le rnabuꞌ lahuëꞌ, atiꞌ uzoanu‑biꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ Elisabet, ngul quiuꞌ, atiꞌ guꞌu labiꞌ Juan. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gataꞌ quiuꞌ le uziꞌu xbey len udzijnuꞌ, atiꞌ zian nup ludziji ládxiꞌgac le guljbiꞌ biꞌidauꞌ naꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","le gáctscabiꞌ zxön lahuëꞌ Dios. Cutu guiꞌjbiꞌ xisi uva len clëg tu le rsudxi bunách, atiꞌ gdu sóalenëꞌ‑biꞌ Dios Böꞌ Laꞌy catiꞌ su lau ziꞌa galjbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gunëꞌ Juan ni ga luhuöác queëꞌ Xanruꞌ zian bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nörëꞌ Lëꞌ ca Xanruꞌ, atiꞌ laꞌcuaꞌlen lëꞌ Böꞌ naꞌ len yöl‑laꞌ huac naꞌ gulacuaꞌlen Elías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. Cni gunëꞌ quië unëꞌ tuz nup nacgac xuz len zxiꞌnquëꞌ, len uzéjniꞌnëꞌ nup taꞌdáꞌbagaꞌ quië lacquëꞌ tsahuiꞌ, len ucözëꞌ bunách lacquëꞌ sinaꞌ laꞌzíꞌ lu naꞌquëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Gnabnëꞌ gbaz laꞌy naꞌ Zacarías, rnëꞌ: ―¿Bizxa gac bëꞌ quië gnözdaꞌ lac lë ni? Chnagulaꞌ nedaꞌ len chnagulnu caꞌ ngul quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bubiꞌë didzaꞌ gbaz laꞌy naꞌ, rnëꞌ: ―Nedaꞌ leaꞌ Gabriel. Runaꞌ dxin lahuëꞌ Dios. Lëczëꞌ bsölëꞌë nedaꞌ güíꞌlenaꞌ liꞌ didzaꞌ, len quíxjöiꞌdaꞌ liꞌ didzaꞌ dxiꞌa ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naꞌa, le cutu gyéjlëꞌu xtidzaꞌa, gcödzuꞌ len cutur gac gneuꞌ catiꞌ gacr lë ni. Yúguꞌtë lë ni udxín catiꞌ gdxin dza qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tsal niꞌ tac lë ni, nacuáꞌ niꞌl bunách, taꞌbözëꞌ Zacarías, atiꞌ tuꞌbannëꞌ le rdzeynëꞌ xtsey ga naꞌ zoëꞌ lu latj laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Catiꞌ burujëꞌ Zacarías, cutu guc güíꞌlenëꞌ lequëꞌ didzaꞌ, atiꞌ gláquibeꞌinëꞌ bléꞌinëꞌ tu le buluiꞌinëꞌ lëꞌ Dios lu latj laꞌy. Buláꞌ buluiꞌzëꞌ Zacarías, buzéjniꞌnëꞌ lequëꞌ, le curác gnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Catiꞌ bzaꞌa yuguꞌ dza naꞌ ral‑laꞌ gunëꞌ dxin lahuëꞌ Dios Zacarías, niꞌr böjëꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gdöd yuguꞌ dza naꞌ biaꞌnu‑biꞌ lëꞌnu biꞌidauꞌ Elisabet, ngul queëꞌ Zacarías naꞌ, atiꞌ gdu gayuꞌ beoꞌ bugaꞌnznu yuꞌu. Gzaꞌ ládxiꞌnu, ");
INSERT INTO zsrNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","rnanu: ―Cni runëꞌ quiaꞌ Xanruꞌ. Ruzáꞌ ladxëꞌë quiaꞌ biꞌidauꞌ, len runëꞌ ga cutur utuiꞌdaꞌ laugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Catiꞌ chguc xop beoꞌ, buluíꞌ lahuëꞌ gbaz laꞌy naꞌ, le bsölëꞌë lëczëꞌ Gabriel Dios, tsijëꞌ Nazaret, tu yödz luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios bsölëꞌë lëꞌ niꞌ tsajyúëꞌ‑biꞌ tubiꞌ biꞌi ngul raꞌbandauꞌ lëbiꞌ María. Chnazíꞌ lu naꞌbiꞌ María utság náꞌlenbiꞌ‑nëꞌ bönniꞌ lëꞌ José. Naquëꞌ José zxiꞌn xsoëꞌ David, bönniꞌ gna béꞌinëꞌ bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Catiꞌ gyaziëꞌ Gabriel naꞌ ga zoabiꞌ María, gudxëꞌ‑biꞌ: ―Padiux. Dios ruzáꞌ ladxëꞌë quiuꞌ. Zóalenëꞌ liꞌ Xanruꞌ Dios. Lëczëꞌ benëꞌ ga nacruꞌ liꞌ bicaꞌ ba ca yúguꞌtë ngul. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Catiꞌ bléꞌibiꞌ gbaz laꞌy naꞌ María, gröꞌbiꞌ baguíꞌi niꞌa qui didzaꞌ naꞌ bëꞌë, len rubani ládxiꞌbiꞌ nacx rna didzaꞌ naꞌ bulidzëꞌ‑biꞌ gbaz laꞌy naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Niꞌr gudxëꞌ‑biꞌ gbaz laꞌy naꞌ, rnëꞌ: ―María, cutu gádxinuꞌ, le chbdél‑liꞌnuꞌ le ruzáꞌ ladxëꞌë quiuꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Naꞌa, tsuꞌubiꞌ lëꞌu tubiꞌ biꞌidauꞌ, atiꞌ uzúꞌ‑biꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ, atiꞌ guꞌu labiꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jesús ni gáctërëꞌ blau, len siꞌ Lëꞌ Zxiꞌnëꞌ Dios, Nu nactër blau. Xanruꞌ Dios gunëꞌ ga gna bëꞌë ca naꞌ gna bëꞌë David, xuz gul gdöd queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jesús naꞌ gna béꞌitecznëꞌ bunách Israel, atiꞌ le gna bëꞌë Lëꞌ gatga udx qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Niꞌr gnábibiꞌ gbaz laꞌy naꞌ María, rnabiꞌ: ―¿Nacxcz gac lë ni, le cutu zóalenaꞌ bönniꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bubiꞌë didzaꞌ gbaz laꞌy naꞌ, rëꞌ‑biꞌ: ―Gdxinëꞌ ga zuꞌ Dios Böꞌ Laꞌy, atiꞌ soalen liꞌ yöl‑laꞌ huac queëꞌ Dios, Nu nactër blau, le gac ga zuꞌ ca tu zxul rguꞌu böaj. Qui lë ni naꞌ biꞌi bö́nniꞌdauꞌ naꞌ ral‑laꞌ galjbiꞌ, tsuꞌubiꞌ lu nëꞌë Dios, atiꞌ siꞌ labiꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yetú caꞌ, Elisabet, ngul diꞌa dza quiuꞌ, chnuaꞌnu‑biꞌ caꞌ lëꞌnu tubiꞌ biꞌi bö́nniꞌdauꞌ zal‑laꞌ chnagulnu. Gulanë́ꞌ queënu: “Nacnu ngul huödx”, san chzeaj xop beoꞌ nuaꞌnu‑biꞌ lëꞌnu biꞌidauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cutu bi zoa le cusáquiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Niꞌr María gnabiꞌ: ―Ni zoaꞌ. Tsaz nacaꞌ huen dxin queëꞌ Xanruꞌ. Gac quiaꞌ ca naꞌ chgnauꞌ. Niꞌr laꞌ buzaꞌtëꞌ gbaz laꞌy naꞌ ga zoabiꞌ María. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Laꞌ dza niꞌz gyuꞌubiꞌ nöz María, atiꞌ jaréluꞌbiꞌ gyeajbiꞌ ga nac guíꞌadauꞌ, bdxinbiꞌ tu yödz luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Niꞌ gyazbiꞌ lidxëꞌ Zacarías len gudxbiꞌ‑nu Elisabet: ―Padiux. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Catiꞌ byö́ninu Elisabet didzaꞌ naꞌ bëꞌbiꞌ María, laꞌ butatë cuinbiꞌ biꞌi huëꞌndauꞌ naꞌ yuꞌubiꞌ lëꞌnu, atiꞌ dusóalenëꞌ‑nu Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Niꞌr bëꞌnu zidzj didzaꞌ Elizabet, rnanu: ―Chnunëꞌ Dios ga nacruꞌ liꞌ bicaꞌ ba ca yúguꞌtë ngul len chnunëꞌ caꞌ ga nacbiꞌ bicaꞌ ba biꞌidauꞌ naꞌ yuꞌubiꞌ lëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Núzxatë nedaꞌ, zaꞌnu quiaꞌ xnëꞌë Xanaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Catiꞌ byöndaꞌ didzaꞌ bëꞌu, bulidzuꞌ nedaꞌ, lu yöl‑laꞌ rudziji queëbiꞌ laꞌ butatë cuinbiꞌ biꞌi huëꞌndauꞌ ni yuꞌubiꞌ lëꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bicaꞌ bauꞌ liꞌ le gyéjlëꞌu xtidzëꞌë gbaz laꞌy, atiꞌ udxíncz lë naꞌ gudxëꞌ liꞌ uláz queëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Niꞌr gnabiꞌ María: “Gdu ladxaꞌa runaꞌ Xanruꞌ zxön, ");
INSERT INTO zsrNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Len rudziji ládxiꞌlenaꞌ‑nëꞌ Dios, Nu ruslá nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dioscz buzáꞌ ladxëꞌë quiaꞌ nedaꞌ. Yuꞌa lu nëꞌë, tsaz nacaꞌ huen dxin queëꞌ. Naꞌa su lau, ca nac quiaꞌ laꞌná: ‘Bicaꞌ ba ngul naꞌ.’ ");
INSERT INTO zsrNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Zxöntër nac le benëꞌ quiaꞌ Dios uná bëꞌ. Laꞌy nac lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lëꞌ ruhuechiꞌ ládxiꞌteczëꞌ bunách tadxi Lëꞌ Naꞌa dza len dza ziꞌa zaꞌc. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yuguꞌ yöl‑laꞌ huac zxön chbenëꞌ Lëꞌ. Buzötjëꞌ nup glun zxön yöl‑laꞌ rejniꞌi quegac. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bugǘëꞌ yöl‑laꞌ uná bëꞌ quegac nup glac blau, Len benëꞌ ga glac blau nup glac nöxj ladxiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Benëꞌ ga guluhuö́lj guladzeꞌi nup guladún, Len bucaꞌnëꞌ caꞌz nup gulaleꞌi yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gúclenëꞌ bunách Israel, nup naꞌ tun xchinëꞌ, Le yajneynëꞌ lequëꞌ len buechiꞌ ladxëꞌë lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Benëꞌ ca gzxiꞌ lu nëꞌë gunëꞌ quequëꞌ xuz xtauꞌruꞌ Lencaꞌ queëꞌ Abraham len quegac zxiꞌn xsoëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bugáꞌnlenbiꞌ‑nu Elisabet María gdu ca tsonn beoꞌ, atiꞌ gdöd niꞌ böajbiꞌ lidxbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Catiꞌ bdxin dza ral‑laꞌ soabiꞌ biꞌidauꞌ queënu Elisabet, buzoanu‑biꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Gulayöni dzag yuꞌu queënu len yuguꞌ diꞌa dza queënu ca naꞌ guc, buechiꞌ ladxëꞌë‑nu Dios, atiꞌ guludzíjilen lënu. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Catiꞌ chguc xunuꞌ dza zoabiꞌ biꞌidauꞌ naꞌ, guladxinëꞌ diꞌa dza queënu quië laꞌchuguëꞌ lu xpë́laꞌbiꞌ biꞌi bö́nniꞌdauꞌ naꞌ lë naꞌ gac bëꞌ náquibiꞌ queëꞌ Dios, atiꞌ tëꞌnnëꞌ luꞌë labiꞌ Zacarías ca naꞌ lëꞌ xuzbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Niꞌr bubiꞌinu didzaꞌ Elisabet, xnaꞌbiꞌ, rnanu: ―Cutu. Juan siꞌ labiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Gulanabnëꞌ‑nu, taꞌnë́ꞌ: ―¿Bizx queë? Nutu nu diꞌa dza quiuꞌ lëꞌ Juan. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Niꞌr gululáꞌ gululuiꞌznëꞌ, gulanabnëꞌ xuzbiꞌ nacx rëꞌnnëꞌ guꞌë labiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Gnabëꞌ tu blagdauꞌ Zacarías naꞌ, atiꞌ buzujëꞌ lahui cni: “Juan lëbiꞌ.” Gulubannëꞌ yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Laꞌ niꞌz böaljtë ruꞌë Zacarías naꞌ len buguitjtë ludxëꞌë, atiꞌ bëꞌë didzaꞌ le gluꞌë Dios yöl‑laꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Niꞌr gládxinëꞌ len gulubannëꞌ yúguꞌtë dzag yuꞌu quequëꞌ, atiꞌ yúguꞌtë yödzdauꞌ nacuáꞌ lu guíꞌadauꞌ luyú Judea, gzë didzaꞌ ca guc lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gulazáꞌ ládxiꞌgac yúguꞌtë nup gulayöni ca naꞌ guc, taꞌná: ―¿Nacxcz gacbiꞌ biꞌi bö́nniꞌdauꞌ ni? Le nactë zóalenëꞌ‑biꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Niꞌr dusóalenëꞌ Zacarías, xuzbiꞌ Juan, Dios Böꞌ Laꞌy, atiꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yöl‑laꞌ ba Dios, Xangac bunách Israel Le duyúëꞌ rëꞌu, bunách queëꞌ, len böaꞌuëꞌ rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bsölëꞌë queëruꞌ Nu uslá rëꞌu, Len yöl‑laꞌ huac zxön qui, Nu naꞌ gulj ladj zxiꞌn xsoëꞌ David, Huen dxin queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dza niꞌtë gzxiꞌ lu nëꞌë gunëꞌ cni, Nac ca naꞌ gnëꞌ lu rúꞌaquëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Gzxiꞌ lu nëꞌë uslë́ꞌ rëꞌu Lu naꞌgac nup taꞌléy rëꞌu Lencaꞌ lu naꞌgac nup cutaꞌleꞌi rëꞌu dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gzxiꞌ lu nëꞌë huechiꞌ ladxëꞌë xuz xtauꞌruꞌ Len tsajneynëꞌ le gzxiꞌ lu nëꞌë le nac laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Lë ni benëꞌ tsutsu xtidzëꞌë gzxiꞌ lu nëꞌë, Le gunëꞌ queëꞌ Abraham, xuzruꞌ gul gdöd, Le nac tu le ral‑laꞌ gunëꞌ queëruꞌ rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Gzxiꞌ lu nëꞌë uslë́ꞌ rëꞌu Lu naꞌgac nup cutaꞌleꞌi rëꞌu dxiꞌa Quië cutur gádxiruꞌ gunruꞌ xchinëꞌ Lëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Len quië gacruꞌ baꞌa ladxiꞌ len gdu dxiꞌa Lahuëꞌ Lëꞌ yúguꞌtë dza soaruꞌ gbanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Liꞌ, zxíꞌnaꞌdauꞌ, siꞌ lauꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios Nu nactër blau Le tsajnöruꞌ ca Xanruꞌcz, upaꞌu nöz ga tödëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gunuꞌ ga laꞌnözi bunách queëꞌ ca gac lulá Len ca naꞌ unít lahuëꞌ Dios dul‑laꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cni gac, le ruhuéchiꞌtsca ladxëꞌë rëꞌu Dios Len runëꞌ ga tseníꞌ queëruꞌ Nu nac yeníꞌ gdu. ");
INSERT INTO zsrNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Lei gunn yeníꞌ ga nacuáꞌ nup nacuáꞌ gap nac chul len gap nac lu zxul qui yöl‑laꞌ gut Quië ugúꞌu rëꞌu nöz ga cöꞌ dxi ládxiꞌdauꞌruꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gzxönbiꞌ biꞌi bö́nniꞌdauꞌ naꞌ len bdip ládxiꞌbiꞌ. Gzoazbiꞌ gap nac lu latj caꞌz catiꞌ bdxinr dza buluíꞌ laubiꞌ laugac bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Laꞌ dza niꞌz gna bëꞌë Augusto César laꞌyáz lu guich yúguꞌtë bunách nacuáꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Catiꞌ ziꞌal lzu gulayáz lu guich ni, rna bëꞌë luyú Siria bönniꞌ lëꞌ Cirenio. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yúguꞌtë bunách yjac yödz qui queëquëꞌ ga naꞌ nababquëꞌ quië laꞌyaziëꞌ lu guich. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Gzëꞌë José yödz Nazaret luyú Galilea, zijëꞌ luyú Judea, len bdxinëꞌ yödz Belén, ga niꞌ guljëꞌ David, le naquëꞌ José zxiꞌn xsoëꞌ David naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gyijëꞌ niꞌ José quië tsaziëꞌ lu guich, atiꞌ dzagbiꞌ‑nëꞌ María, biꞌi ngul nazíꞌ lu naꞌbiꞌ utság náꞌlenbiꞌ lëꞌ, len chzoa soabiꞌ biꞌidauꞌ queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Catiꞌ niꞌ nacuꞌë lu yödz Belén, bdxin dza soabiꞌ biꞌidauꞌ queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Niꞌ buzoanu‑biꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ, biꞌi ziꞌal queënu. Buchö́linu‑biꞌ yuguꞌ láriꞌdauꞌ, atiꞌ gdixjnu‑biꞌ tu lu yuꞌudauꞌ ga taꞌgúꞌu le tágubaꞌ böaꞌ quegac bunách yuꞌugac nöz. Cni guc, le cutu bdzöli latj laꞌcuꞌë lu yuꞌu ga niꞌ taꞌdxinëꞌ bönniꞌ yuꞌugac nöz. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gal‑laꞌ raꞌ yödz Belén nacuꞌë ladj guixiꞌ bönniꞌ tuꞌyúëꞌ‑baꞌ böꞌcuꞌ zxilaꞌ, tun chiꞌë‑baꞌ chdzöꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Laꞌ buluiꞌtë lahuëꞌ gbaz laꞌy queëꞌ Xanruꞌ ga naꞌ nacuꞌë. Gluꞌu yeníꞌ ga naꞌ nacuꞌë yöl‑laꞌ yeníꞌ queëꞌ Xanruꞌ, atiꞌ gládxinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Niꞌr gudxëꞌ lequëꞌ gbaz laꞌy naꞌ, rnëꞌ: ―Cutu gádxiliꞌ. Naꞌa rguíxjöiꞌdaꞌ lbiꞌiliꞌ didzaꞌ gun ga udzíjitsquiliꞌ, le luzíꞌ caꞌ xbey yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Naꞌa chguljbiꞌ ladzëꞌ David Nu uslá lbiꞌiliꞌ. Nu ni nac Cristo, Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lë ni gac bëꞌ nu nacbiꞌ. Udzö́liliꞌ‑biꞌ biꞌidauꞌ naꞌ, narö́libiꞌ yuguꞌ láriꞌdauꞌ len dëbiꞌ tu lu yuꞌudauꞌ ga taꞌgúꞌu le tágubaꞌ böaꞌ quegac bunách yuꞌugac nöz. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ga naꞌ zoëꞌ gbaz laꞌy naꞌ, tu tsalz gululuíꞌ lauquëꞌ zianr caꞌ gbaz laꞌy queëꞌ Dios, narujquëꞌ yehuaꞌ yubá len taꞌguꞌë Dios yöl‑laꞌ ba, taꞌnë́ꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Yöl‑laꞌ ba Dios zoëꞌ xtsaꞌ, Atiꞌ gac luyú le cuequi dxi ládxiꞌdauꞌquëꞌ Bönniꞌ rdzag ladxëꞌë lequëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Catiꞌ guluzë́ꞌë gbaz laꞌy naꞌ ga niꞌ nacuꞌë, zhuöjquëꞌ yehuaꞌ yubá, niꞌr glë lzaꞌquëꞌ tuëꞌ yetúëꞌ bönniꞌ uyú böꞌcuꞌ zxilaꞌ naꞌ, taꞌnë́ꞌ: ―Uyéajtscaꞌruꞌ Belén quië gléꞌiruꞌ lë ni chguc ca naꞌ chbuluiꞌinëꞌ rëꞌu Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jaréluꞌquëꞌ yjaquëꞌ atiꞌ yajxácaꞌquëꞌ María len José, lencaꞌ biꞌidauꞌ naꞌ, dëbiꞌ tu lu yuꞌudauꞌ ga taꞌgúꞌu le tágubaꞌ böaꞌ quegac bunách yuꞌugac nöz. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Catiꞌ gulaléꞌinëꞌ lëbiꞌ, gulaguíxjöꞌë lë naꞌ ziꞌa gudxëꞌ lequëꞌ gbaz laꞌy naꞌ ca nac queëbiꞌ biꞌidauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Gulubani yúguꞌtë nup gulayöni didzaꞌ gluꞌë bönniꞌ uyú böꞌcuꞌ zxilaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gluꞌuz icj nagnu yuguꞌ didzaꞌ ni María, atiꞌ gzaꞌ ládxiꞌnu ca nac qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Zhuöjquëꞌ bönniꞌ naꞌ uyú böꞌcuꞌ zxilaꞌ, tunëꞌ zxön Dios len taꞌguꞌë Lëꞌ yöl‑laꞌ ba niꞌa qui yúguꞌtë lë naꞌ gulayönnëꞌ len gulaléꞌinëꞌ, le guc ca naꞌ gudxëꞌ lequëꞌ gbaz laꞌy naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Catiꞌ chguc xunuꞌ dza zoabiꞌ biꞌidauꞌ naꞌ, gulachuguëꞌ lu xpë́laꞌbiꞌ lë naꞌ nac bëꞌ náquibiꞌ queëꞌ Dios, atiꞌ gluꞌë labiꞌ Jesús ca naꞌ chbëꞌczëꞌ labiꞌ gbaz laꞌy naꞌ ziꞌal catiꞌ ziꞌa tsuꞌubiꞌ lëꞌnu xnaꞌbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Catiꞌ chbzaꞌa dza qui le tuꞌpáꞌ cuincnu ngul ca rna bëꞌ zxba queëꞌ Moisés, gulachë́ꞌë‑biꞌ biꞌidauꞌ Jesús Jerusalén quië laꞌguꞌë‑biꞌ lu nëꞌë Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Cni glunëꞌ, le nayúj lu guich lu zxba queëꞌ Xanruꞌ le rna: “Yúguꞌtëbiꞌ biꞌi bö́nniꞌdauꞌ naccbiꞌ biꞌi ziꞌal queënu xnaꞌcbiꞌ, lubijëꞌ‑biꞌ quizi queëꞌ Xanruꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Qui lë ni naꞌ yjaquëꞌ niꞌ quië ludödcdëꞌ‑baꞌ len laꞌguꞌquëꞌ‑baꞌ lahuëꞌ Dios chopbaꞌ gúgudauꞌ o chopbaꞌ budödauꞌ ca naꞌ rna bëꞌ zxba queëꞌ Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dza niꞌz zoëꞌ Jerusalén tu bönniꞌ lëꞌ Simeón. Bönniꞌ ni naquëꞌ tsahuiꞌ len rej ladxëꞌë Dios. Rbözëꞌ Nu naꞌ gsölëꞌë Dios, Nu gaclen bunách Israel. Zóalenëꞌ Simeón naꞌ Dios Böꞌ Laꞌy, ");
INSERT INTO zsrNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","len chbuluiꞌinëꞌ lëꞌ cutu gatiëꞌ catiꞌ gléꞌirnëꞌ Cristo, Nu naꞌ gsölëꞌë Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bdxinëꞌ Simeón naꞌ nchil gdauꞌ le bchëꞌë lëꞌ niꞌ Dios Böꞌ Laꞌy. Catiꞌ gulachë́ꞌë‑biꞌ biꞌidauꞌ Jesús nchil gdauꞌ xuz xnaꞌbiꞌ quië lunëꞌ queëbiꞌ ca rna bëꞌ zxba naꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","niꞌr bunidëꞌ‑biꞌ Simeón naꞌ, len gyij ladxëꞌë Dios, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Xanaꞌ, naꞌa huac gunnuꞌ nedaꞌ latj gatiaꞌ, Soa dxi ladxaꞌa Le chguc le gudxuꞌ nedaꞌ, huen dxin quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chbléꞌidaꞌ Nu naꞌ buzoaczuꞌ, Nu uslá bunách, ");
INSERT INTO zsrNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nu naꞌ rulúꞌu lahui laugac yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lëbiꞌ nacbiꞌ yeníꞌ uzeníꞌ bunách gzaꞌa Len nacbiꞌ caꞌ yeníꞌ quegac bunách Israel quiuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Gulubannëꞌ José len María, xnaꞌbiꞌ biꞌidauꞌ Jesús, ca nac lë naꞌ gnëꞌ Simeón ca nac queëbiꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Gnabnëꞌ Dios Simeón gunëꞌ ga gac dxiꞌa quequëꞌ, atiꞌ gudxëꞌ‑nu María, xnaꞌbiꞌ Jesús, rnëꞌ: ―Byutscaꞌ. Biꞌi ni nuzóëꞌ‑biꞌ Dios quië gunbiꞌ ga laꞌchixi bunách zian, atiꞌ luhuöás bunách zian ladj bunách Israel. Gacbiꞌ tu le nac bëꞌ, atiꞌ laꞌnë́ queëbiꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gac cni quië laꞌláꞌ lahui le taꞌzáꞌ ládxiꞌgac bunách zian. Yuguꞌ lë ni lac quiuꞌ ca tu guia tuchiꞌ le tsaz ládxiꞌdaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Zoanu caꞌ niꞌ Ana, ngul ruiꞌnu didzaꞌ uláz queëꞌ Dios. Nacnu zxiꞌnëꞌ Fanuel, bönniꞌ nababëꞌ diꞌa dza queëꞌ Aser. Chnagúltscanu Ana naꞌ, le gzóalennu bönniꞌ queënu gdu gadx iz gdöd gucnu raꞌbandauꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","atiꞌ bgaꞌnnu uzë́b catiꞌ bdxintë dza chyuꞌunu gdu ca taplalj yu tap iz. Cutu caꞌ rubíꞌi ruzaꞌnu ga nac nchil gdauꞌ. Rël len të dza rej ládxiꞌnu‑nëꞌ Dios, runnu gubás len rulidznu‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Laꞌ naꞌz bdxíntënu niꞌ, rënu‑nëꞌ Dios: “Xclenuꞌ.” Gdíxjöiꞌnu yúguꞌtë bunách ca nac queëbiꞌ biꞌidauꞌ Jesús, bunách naꞌ nacuáꞌ Jerusalén, taꞌbö́z dza gdxin Nu naꞌ gsölëꞌë Dios gaclen bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gdöd glunëꞌ José len María yúguꞌtë le rna bëꞌ zxba queëꞌ Xanruꞌ Dios, yhuöjquëꞌ ladzquëꞌ Nazaret luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gzxönbiꞌ biꞌidauꞌ Jesús len bdip ládxiꞌbiꞌ. Gutaꞌ queëbiꞌ yöl‑laꞌ rejniꞌi, atiꞌ zxön nac le ruzáꞌ ladxëꞌë queëbiꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yuguꞌ iz rjaquëꞌ Jerusalén xuz xnaꞌbiꞌ Jesús catiꞌ rac Lni Pascua, lni tuꞌspanëꞌ bönniꞌ judío ca benëꞌ Dios, bubijëꞌ xuz xtauꞌquëꞌ luyú Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Catiꞌ chyuꞌubiꞌ chinnu iz biꞌi Jesús, yjaquëꞌ Jerusalén ca tunczëꞌ catiꞌ rac lni naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Catiꞌ gdöd lni, zhuöjquëꞌ, san bugaꞌnbiꞌ Jerusalén biꞌidauꞌ Jesús, san cutu táquibeꞌinëꞌ José len María, xnaꞌbiꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Le táquinëꞌ nútsaꞌbiꞌ ladj bunách zian yúꞌulengac lequëꞌ nöz, tu dza nayáꞌ gulazë́ꞌë. Niꞌr catiꞌ guluguiljëꞌ‑biꞌ gap nacuáꞌ diꞌa dza quequëꞌ len gap nacuáꞌ nup núnbëꞌquëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","cutu guludzölnëꞌ‑biꞌ. Qui lë ni naꞌ yhuöjquëꞌ Jerusalén, zajtiljquëꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Catiꞌ chguc dza bunn, guludzölnëꞌ‑biꞌ ga nac nchil gdauꞌ, röꞌbiꞌ gatsj láhuiꞌlëꞌ bönniꞌ gdauꞌ tuꞌsëdi, ruzë́ nagbiꞌ didzaꞌ tuꞌë len rnabi yúdxibiꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gulubani yúguꞌtë nup gulayöni didzaꞌ bëꞌbiꞌ ca nac yöl‑laꞌ rejniꞌi queëbiꞌ len ca nacgac didzaꞌ bubiꞌibiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Catiꞌ gulaléꞌinëꞌ‑biꞌ xuz xnaꞌbiꞌ, gulubannëꞌ, atiꞌ gudxnu‑biꞌ xnaꞌbiꞌ, rnanu: ―Zxiꞌnaꞌ, ¿bizx quië benuꞌ cni queëtuꞌ? Byutscaꞌ, len yöl‑laꞌ ruúbi ruguíꞌi buguiljtuꞌ liꞌ nedaꞌ len xuzuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Niꞌr gudxbiꞌ lequëꞌ Jesús, rnabiꞌ: ―¿Bizx quië buguiljliꞌ nedaꞌ? ¿Naruꞌ cu nö́ziliꞌ run bayúdx gunaꞌ xchinëꞌ Xuzaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Cutu gulayéjniꞌnëꞌ xuz xnaꞌbiꞌ didzaꞌ naꞌ gudxbiꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bö́ajlenbiꞌ lequëꞌ Jesús, budxinbiꞌ Nazaret, atiꞌ benbiꞌ ca rna xtídzaꞌquëꞌ xuz xnaꞌbiꞌ. Gluꞌznu icj ládxiꞌdauꞌnu yúguꞌtë lë ni María, xnaꞌbiꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Rataꞌr queëbiꞌ biꞌi Jesús yöl‑laꞌ rejniꞌi, len rzxönbiꞌ. Burujbiꞌ dxiꞌa lahuëꞌ Dios len laugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Catiꞌ chguc chinu iz rna beꞌinë́ꞌ gdutë yödzlyú Tiberio César, atiꞌ rna bëꞌë Poncio Pilato luyú Judea, atiꞌ Herodes rna bëꞌë caꞌ luyú Galilea, atiꞌ Felipe, böchëꞌë Herodes naꞌ, rna bëꞌë luyú Iturea len luyú Traconite, atiꞌ Lisanias rna bëꞌë luyú Abilinia, ");
INSERT INTO zsrNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","yuguꞌ dza naꞌ nacquëꞌ bxuz blau Anás len Caifás, atiꞌ laꞌ naꞌz Dios bë́ꞌlenëꞌ Juan, zxiꞌnëꞌ Zacarías, didzaꞌ catiꞌ niꞌ zoëꞌ Juan lu latj caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Rdëꞌ Juan ni yúguꞌtë latj nacuáꞌ raꞌ yegu Jordán, runëꞌ lban ca ral‑laꞌ laꞌdíl nis nup tuꞌbíꞌi ládxiꞌgac quië unít lahuëꞌ Dios dul‑laꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Guc cni ca naꞌ nayúj lu guich laꞌy yuguꞌ didzaꞌ bëꞌë Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, rna: Ryön chiꞌë bönniꞌ rulidzëꞌ lu latj caꞌz, rnëꞌ: “Gul‑páꞌ nöz gdxin queëliꞌ Xanruꞌ. Gul‑bíj li yuguꞌ nöz las tödëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gdzë́ꞌigac yúguꞌtë gap nac rögaꞌ. Luhuöác lachiꞌ yúguꞌtë guiꞌa sib len guíꞌadauꞌ. Lurúj li nöz nayéycj narö́ligac, Atiꞌ luhuöác dxiꞌa nöz guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Laꞌleꞌi yúguꞌtë bunách Nu naꞌ gsölëꞌë Dios, Nu uslá bunách.” ");
INSERT INTO zsrNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Catiꞌ gularúj bunách zian quië laꞌdíl nis lu nëꞌë Juan, lëꞌ gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ, diꞌa dza quecbaꞌ bël sniaꞌ. ¿Nuzxa buluíꞌi lbiꞌiliꞌ gzxundjliꞌ yöl‑laꞌ rusyúdx ziꞌa gac quegac bunách? ");
INSERT INTO zsrNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Naꞌa, gul‑gún le lac bëꞌ chbubíꞌi ládxiꞌliꞌ len cutu saꞌ ládxiꞌliꞌ, cugnaliꞌ: “Nactuꞌ tsahuiꞌ le nactuꞌ zxiꞌn xsoëꞌ Abraham”, le rëpaꞌ lbiꞌiliꞌ, huac quel‑lëꞌë Dios yuguꞌ guiöj ni len gunëꞌ ga luhuöác zxiꞌn xsoëꞌ Abraham. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nacliꞌ ca yuguꞌ yag. Chzoa rböz guia huag gchugu yuguꞌ yag. Yúguꞌtë yag cutaꞌbía le nac dxiꞌa, laꞌchuguëꞌ yag naꞌ len laꞌguꞌë leygac lu guiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Niꞌr gulanabi lëꞌ bunách nacuáꞌ niꞌ, taꞌná: ―¿Nacx gúntsatuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bubiꞌë didzaꞌ Juan, rëꞌ lequëꞌ: ―Nu dë chop zxey ral‑laꞌ unö́dzj qui nu cudë́ qui, atiꞌ nu dë le gagu, lëzcaꞌ cni ral‑laꞌ quis quegac nup cudë́ le lagu. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Guladxinëꞌ caꞌ niꞌ quië laꞌdilëꞌ nis laꞌquëꞌ bönniꞌ tuꞌquizxjëꞌ lazgac bunách uláz qui yödz ziꞌtuꞌ, atiꞌ gulanabnëꞌ lëꞌ, taꞌnë́ꞌ: ―Bönniꞌ usëdi, ¿nacx gúntsatuꞌ netuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan gudxëꞌ lequëꞌ: ―Cutu uquizxjrliꞌ tsca le chgna béꞌinëꞌ lbiꞌiliꞌ bönniꞌ uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gulanabnëꞌ caꞌ lëꞌ laꞌquëꞌ bönniꞌ rjaquëꞌ gdil‑l, taꞌnë́ꞌ: ―¿Nazx netuꞌ, nacx guntuꞌ? Juan gudxëꞌ lequëꞌ: ―Cutur gun gádxiliꞌ nitú bunách quië cúaliꞌ le dë qui. Cutur gnëliꞌ quegac bunách le cunácz quië gunliꞌ ga laꞌguízxj lbiꞌiliꞌ, san gul‑dzág ládxiꞌliꞌ tsca razxjliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Taꞌzáꞌ ládxiꞌgac bunách naꞌ taꞌbö́z Nu naꞌ ral‑laꞌ gsölëꞌë Dios, chquiꞌ naquëꞌ Juan naꞌ bönniꞌ lëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bubiꞌë didzaꞌ Juan, gudxëꞌ yúguꞌtëꞌ, rnëꞌ: ―Le nactë nedaꞌ ruquilaꞌ lbiꞌiliꞌ nis, san zëꞌë bönniꞌ gunëꞌ le ruluíꞌz yöl‑laꞌ rdil nis ni, gchiziëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy len le nac guiꞌ queëꞌ. Bönniꞌ ni naprëꞌ yöl‑laꞌ uná bëꞌ ca nedaꞌ, atiꞌ nedaꞌ cutu nacaꞌ lsacaꞌ gleycjaꞌ lölëꞌ nudë́ꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Zönëꞌ lu nëꞌë bcöꞌ queëꞌ atiꞌ ulubëꞌ ga rlub zxoaꞌ xtil queëꞌ, lë ni ruluíꞌ le gac quegac bunách. Utubëꞌ zxoaꞌ xtil, len cuꞌë lei xlatji, san bëb qui uzéguiꞌë lu guiꞌ le gatga ul. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ca nacgac didzaꞌ ni len yelaꞌgac zian didzaꞌ le bchiziëꞌ icj naggac bunách, benëꞌ lban Juan lauquëꞌ qui didzaꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan naꞌ buquíëꞌ Herodes, bönniꞌ rna bëꞌë, le zóalenëꞌ‑nu Herodías, ngul queëꞌ Felipe, bönniꞌ böchëꞌë, lencaꞌ le runëꞌ zian le cunác. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Niꞌr benëꞌ Herodes tu le nacr huiaꞌdöꞌ, gluꞌë lidx guia Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dza naꞌ ziꞌa gdzunëꞌ lidx guia Juan, catiꞌ niꞌ ruquilëꞌ bunách nis, bdilëꞌ caꞌ nis Jesús. Catiꞌ niꞌ rulidzëꞌ Dios, gyalj luzxbá ");
INSERT INTO zsrNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","atiꞌ bötjëꞌ Dios Böꞌ Laꞌy, bdxinëꞌ ga naꞌ zoëꞌ Jesús. Buluíꞌ lahuëꞌ, rnëꞌë ca tubaꞌ budödauꞌ, atiꞌ byön chiꞌi Nu ruiꞌ didzaꞌ yehuaꞌ yubá, rna: ―Liꞌ nacuꞌ Zxiꞌnaꞌ. Nadxiꞌidaꞌ Liꞌ len rdzag ladxaꞌa Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Catiꞌ gzu lahuëꞌ runëꞌ xchinëꞌ Jesús, yuꞌë ca chi uruáꞌ iz. Taqui bunách naquëꞌ zxiꞌnëꞌ José. Jesús naquëꞌ zxiꞌn xsoëꞌ Elí, nu naꞌ naquëꞌ xuznu María. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí naꞌ guquëꞌ zxiꞌnëꞌ Matat, nu ni guc zxiꞌnëꞌ Leví, nu ni guc zxiꞌnëꞌ Melqui, nu ni guc zxiꞌnëꞌ Jana, nu ni guc zxiꞌnëꞌ yetúëꞌ José. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ni guquëꞌ zxiꞌnëꞌ Matatías, nu ni guc zxiꞌnëꞌ Amós, nu ni guc zxiꞌnëꞌ Nahum, nu ni guc zxiꞌnëꞌ Esli, nu ni guc zxiꞌnëꞌ Nagai. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai naꞌ guquëꞌ zxiꞌnëꞌ Maat, nu ni guc zxiꞌnëꞌ yetúëꞌ Matatías, nu ni guc zxiꞌnëꞌ Semei, nu ni guc zxiꞌnëꞌ yetúëꞌ José, nu ni guc zxiꞌnëꞌ Judá. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá naꞌ guquëꞌ zxiꞌnëꞌ Joana, nu ni guc zxiꞌnëꞌ Resa, nu ni guc zxiꞌnëꞌ Zorobabel, nu ni guc zxiꞌnëꞌ Salatiel, nu ni guc zxiꞌnëꞌ Neri. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri naꞌ guquëꞌ zxiꞌnëꞌ yetúëꞌ Melqui, nu ni guc zxiꞌnëꞌ Adi, nu ni guc zxiꞌnëꞌ Cosam, nu ni guc zxiꞌnëꞌ Elmodam, nu ni guc zxiꞌnëꞌ Er. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er naꞌ guquëꞌ zxiꞌnëꞌ Josué, nu ni guc zxiꞌnëꞌ Eliezer, nu ni guc zxiꞌnëꞌ Jorim, nu ni guc zxiꞌnëꞌ yetúëꞌ Matat. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat naꞌ guquëꞌ zxiꞌnëꞌ Leví, nu ni guc zxiꞌnëꞌ Simeón, nu ni guc zxiꞌnëꞌ Judá, nu ni guc zxiꞌnëꞌ yetúëꞌ José, nu ni guc zxiꞌnëꞌ Jonán, nu ni guc zxiꞌnëꞌ Eliaquim. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim naꞌ guquëꞌ zxiꞌnëꞌ Melea, nu ni guc zxiꞌnëꞌ Mainán, nu ni guc zxiꞌnëꞌ Matata, nu ni guc zxiꞌnëꞌ Natán. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán naꞌ guquëꞌ zxiꞌnëꞌ David, nu ni guc zxiꞌnëꞌ Isaí, nu ni guc zxiꞌnëꞌ Obed, nu ni guc zxiꞌnëꞌ Booz, nu ni guc zxiꞌnëꞌ Salmón, nu ni guc zxiꞌnëꞌ Naasón. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón naꞌ guquëꞌ zxiꞌnëꞌ Aminadab, nu ni guc zxiꞌnëꞌ Aram, nu ni guc zxiꞌnëꞌ Esrom, nu ni guc zxiꞌnëꞌ Fares, nu ni guc zxiꞌnëꞌ yetúëꞌ Judá. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá naꞌ guquëꞌ zxiꞌnëꞌ Jacob, nu ni guc zxiꞌnëꞌ Isaac, nu ni guc zxiꞌnëꞌ Abraham, nu ni guc zxiꞌnëꞌ Taré, nu ni guc zxiꞌnëꞌ Nacor. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor naꞌ guquëꞌ zxiꞌnëꞌ Serug, nu ni guc zxiꞌnëꞌ Ragau, nu ni guc zxiꞌnëꞌ Peleg, nu ni guc zxiꞌnëꞌ Heber, nu ni guc zxiꞌnëꞌ Sala. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala naꞌ guquëꞌ zxiꞌnëꞌ Cainán, nu ni guc zxiꞌnëꞌ Arfaxad, nu ni guc zxiꞌnëꞌ Sem, nu ni guc zxiꞌnëꞌ Noé, nu ni guc zxiꞌnëꞌ Lamec. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec naꞌ guquëꞌ zxiꞌnëꞌ Matusalén, nu ni guc zxiꞌnëꞌ Enoc, nu ni guc zxiꞌnëꞌ Jared, nu ni guc zxiꞌnëꞌ Mahalaleel, nu ni guc zxiꞌnëꞌ yetúëꞌ Cainán. ");
INSERT INTO zsrNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán naꞌ guquëꞌ zxiꞌnëꞌ Enós, nu ni guc zxiꞌnëꞌ Set, nu ni guc zxiꞌnëꞌ Adán, nu ni guc ca zxiꞌnczëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Buzë́ꞌë Jesús raꞌ yegu Jordán, gdu zóalenëꞌ Lëꞌ Dios Böꞌ Laꞌy, atiꞌ Dios Böꞌ Laꞌy naꞌ bchëꞌë Jesús lu latj caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Gzoëꞌ niꞌ Jesús gdu ca choaꞌ dza, atiꞌ gzxiꞌ bëꞌ Lëꞌ tuꞌ xöhuiꞌ quië gun ga gchíxinëꞌ Jesús. Cutu bi gdahuëꞌ Jesús yuguꞌ dza naꞌ, atiꞌ gdödr niꞌ rdunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Niꞌr gudx Jesús tuꞌ xöhuiꞌ naꞌ, rna: ―Chquiꞌ nacczuꞌ Liꞌ Zxiꞌnëꞌ Dios, gnatscaꞌ luhuöác yöt xtil guiöj ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bubiꞌë didzaꞌ Jesús, rëꞌ lei: ―Nayúj lu guich, rna: “Clëgz yöt xtil nabánigac bunách, san nabánigac caꞌ yúguꞌtë xtidzëꞌë Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Niꞌr bchëꞌ Jesús tuꞌ xöhuiꞌ naꞌ ga nac tu lu guiꞌa sib atiꞌ tu chiꞌidauꞌz buluíꞌi Lëꞌ yúguꞌtë xlatjgac nup taꞌná bëꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Rë Jesús tuꞌ xöhuiꞌ naꞌ, rna: ―Gunnaꞌ quiuꞌ yúguꞌtë xlatjgac nup taꞌná bëꞌ ni len yöl‑laꞌ tsahuiꞌ quegac, le nadö́d lu naꞌa yúguꞌtë lë ni, atiꞌ nu rëꞌnzdaꞌ ruꞌa qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chquiꞌ Liꞌ uzechu zxibuꞌ lahuaꞌ gunuꞌ nedaꞌ zxön, yúguꞌtë lë ni gaqui quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bubiꞌë didzaꞌ Jesús, rëꞌ lei: ―Bcuit ga zoaꞌ, Satanás, le nayúj lu guich laꞌy le rë netuꞌ, rna: “Xanuꞌ Dios tsej ladxuꞌu‑nëꞌ, len tuzëꞌ Lëꞌ gunuꞌ xchinëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Niꞌr bchëꞌ Jesús Jerusalén tuꞌ xöhuiꞌ naꞌ, atiꞌ budxía Lëꞌ cjuꞌu gdauꞌ, len rë Lëꞌ: ―Chquiꞌ nacuꞌ Zxiꞌnëꞌ Dios, busládzuꞌtscaꞌ cuinuꞌ ni ");
INSERT INTO zsrNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","le nayúj lu guich laꞌy, rna: Dios gsölëꞌë gbaz laꞌy queëꞌ, láclenëꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lu naꞌquëꞌ luchisëꞌ Liꞌ Cui tsajcheguꞌu guiöj, cugunuꞌ ziꞌ niꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bubiꞌë didzaꞌ Jesús, rëꞌ lei: ―Nayúj lu guich laꞌy, rë netuꞌ: “Cutu siꞌ bëꞌu Xanuꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Catiꞌ cutu budzöli yetú le siꞌ bëꞌ Jesús tuꞌ xöhuiꞌ naꞌ, buzáꞌ ga zoëꞌ tu chiꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Böjëꞌ Jesús luyú Galilea, dë lu nëꞌë yöl‑laꞌ huac queëꞌ Dios Böꞌ Laꞌy. Gzë didzaꞌ ca nac queëꞌ, atiꞌ gulayöni bunách nacuáꞌ yúguꞌtë yödz gdu zbiꞌil. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Busëdnëꞌ bunách Jesús gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ glun Lëꞌ zxön yúguꞌtë bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Niꞌr budxinëꞌ Jesús yödz Nazaret ga niꞌ gzxönëꞌ. Catiꞌ bdxin dza laꞌy quequëꞌ bönniꞌ judío, ca runczëꞌ Jesús, gyaziëꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ gzuinëꞌ quië ulabëꞌ tu le nayúj lu guich laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Guludödëꞌ lu nëꞌë Jesús guich ga naꞌ nayúj didzaꞌ bëꞌë Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. Catiꞌ bsaljëꞌ guich naꞌ, bdzölnëꞌ ga nayúj lu guich le rna: ");
INSERT INTO zsrNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Zóalenëꞌ nedaꞌ Böꞌ Laꞌy queëꞌ Xanruꞌ Le nubijëꞌ nedaꞌ quizi queëꞌ Quië quíxjöiꞌdaꞌ bunách yechiꞌ didzaꞌ dxiꞌa. Bsölëꞌë nedaꞌ unaꞌ nup rac ziꞌ ládxiꞌdauꞌgac, Len usyöndaꞌ nup nadzungac, ca gac lulá, Len unaꞌ bunách nachúl laugac, Len usláꞌ bunách zoa nu runi leygac ziꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Len gunaꞌ lban qui dza ruzáꞌ ladxëꞌë quegac bunách Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Niꞌr butubëꞌ guich naꞌ Jesús len buguꞌë lei lu nëꞌë bönniꞌ run chiꞌë yuguꞌ guich laꞌy, atiꞌ gröꞌë. Niꞌr gulanáꞌ Jesús yúguꞌtë nup nudubgac lu yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gzu lahuëꞌ Jesús rëꞌ lequëꞌ: ―Naꞌa dza ni zoaliꞌ lbiꞌiliꞌ, rudxíncz le nayúj lu guich ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Gulanë́ꞌ dxiꞌa queëꞌ yúguꞌtëꞌ, len gulubannëꞌ ca nac didzaꞌ dxiꞌa ruꞌë, atiꞌ taꞌnë́ꞌ: ―¿Naruꞌ clëg bönniꞌ ni zxiꞌnëꞌ José? ");
INSERT INTO zsrNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Rëꞌ lequëꞌ Jesús, rnëꞌ: ―Nazx huëliꞌ nedaꞌ lë ni taꞌná bunách, le rna: “Liꞌ, bönniꞌ ruún bunách, bun cuinuꞌ.” Lëzcaꞌ cni huëliꞌ nedaꞌ: “Yuguꞌ le byö́nituꞌ benuꞌ Capernaum, ben caꞌ ga ni nac ladzuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Gnëꞌ caꞌ Jesús: ―Le nactë rëpaꞌ lbiꞌiliꞌ, chquiꞌ zoëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, cutu tun lëꞌ ba laꞌn bunách uládz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Le nactë rëpaꞌ lbiꞌiliꞌ, gulacuaꞌnu zian ngul uzë́b luyú Israel yuguꞌ dza niꞌ zoëꞌ Elías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, catiꞌ niꞌ cutu gul guiöj gdu ca tsonn iz yu xop beoꞌ atiꞌ guc gbin luyú naꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","san Dios cutu bsölëꞌë Elías naꞌ ga nacuaꞌnu ngul uzë́b nacuaꞌnu luyú Israel, san bsölëꞌë lëꞌ ga naꞌ zoanu ngul uzë́b lu yödz Sarepta, le nabáb yödz Sidón. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lëzcaꞌ cni, gulacuáꞌ luyú Israel zian nup teꞌi huëꞌ nudzuꞌ ruzö́d dza niꞌ zoëꞌ Eliseo, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, san cutu böaquëꞌ nitúëꞌ bönniꞌ nutsëꞌë ladj bunách Israel naꞌ, san böaquëꞌ tuzëꞌ Naamán, bönniꞌ nababëꞌ luyú Siria. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Catiꞌ gulayönnëꞌ didzaꞌ ni, gulaleynëꞌ yúguꞌtë bönniꞌ nacuꞌë lu yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Niꞌr gulayasëꞌ len gulubijëꞌ Jesús niꞌl raꞌ yödz. Gulachë́ꞌë Lëꞌ ga nac lëꞌi guiꞌa guiöj ga naꞌ dë ladzquëꞌ quië lusládzuꞌë Lëꞌ ga nac lëꞌi guiꞌa guiöj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Niꞌr gdödëꞌ Jesús gatsj lahuiꞌl ga naꞌ nacuꞌë, zhuöjtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Niꞌr gyijëꞌ Jesús yödz Capernaum luyú Galilea, atiꞌ niꞌ busëdnëꞌ bunách yuguꞌ dza laꞌy quequëꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Gulubannëꞌ ca nac le rusëdnëꞌ lequëꞌ Jesús, le bëꞌë didzaꞌ ca tu bönniꞌ dë lu nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Zoatëꞌ caꞌ niꞌ lu yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ yuꞌu lëꞌ böꞌ xöhuiꞌ, atiꞌ bëꞌë zidzj didzaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","rnëꞌ: ―Bsan netuꞌ. ¿Bizxa rál‑laꞌtuꞌ quiuꞌ, Jesús, bönniꞌ Nazaret? ¿Naruꞌ zaꞌu usnitiuꞌ netuꞌ? Núnbëꞌa Liꞌ nu nacuꞌ. Bönniꞌ Laꞌy queëꞌ Dios nacuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Buzeynëꞌ ba nadx böꞌ xöhuiꞌ naꞌ Jesús, rëꞌ lei: ―Bseyj ruꞌu len burúj lu bönniꞌ ni. Niꞌr gruꞌn lyu bönniꞌ naꞌ böꞌ xöhuiꞌ naꞌ laugac bunách nacuáꞌ niꞌ len burujtë lu bönniꞌ naꞌ, san cutur bi ben queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Gulubannëꞌ yúguꞌtëꞌ len gluꞌë didzaꞌ tuëꞌ len yetúëꞌ, taꞌnë́ꞌ: ―¿Bizxa didzaꞌ ni ruꞌë? Len yöl‑laꞌ uná bëꞌ len yöl‑laꞌ huac zxön rna béꞌinëꞌ yuguꞌ böꞌ xöhuiꞌ, atiꞌ tuꞌrujtë böꞌ xöhuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gzë didzaꞌ ca nac queëꞌ Jesús, atiꞌ gulayöni bunách yúguꞌtë yödz gdu zbiꞌil. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Niꞌr gyasëꞌ Jesús len burujëꞌ lu yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, atiꞌ gyaziëꞌ lidxëꞌ Simón. Niꞌ zoanu xnaꞌnu ngul queëꞌ Simón naꞌ, yuꞌunu tu xla, atiꞌ glátaꞌyuëꞌ lahuëꞌ Jesús unëꞌ‑nu. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gbiguëꞌë Jesús ga naꞌ dënu, atiꞌ bulidzëꞌ huëꞌ xla naꞌ yuꞌunu. Laꞌ brujtë tu xla naꞌ yuꞌunu, atiꞌ laꞌ gyástënu len bëꞌnu le glahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Catiꞌ chrbia gbidz, guladxín niꞌ yúguꞌtë nup nacuaꞌlen lequëꞌ nup naꞌ teꞌi qui queëgac guidzhuë́ꞌ, atiꞌ yjuaꞌquëꞌ leygac ga naꞌ zoëꞌ Jesús. Lëꞌ bxoa nëꞌë nup naꞌ teꞌi, bunëꞌ leygac. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gulurúj caꞌ zian böꞌ xöhuiꞌ yuꞌugac bunách teꞌi naꞌ. Taꞌbödxyaꞌa böꞌ xöhuiꞌ, taꞌná: ―Liꞌ nacuꞌ zxiꞌnëꞌ Dios. Niꞌr buzeynëꞌ ba nadx yuguꞌ böꞌ xöhuiꞌ naꞌ Jesús, len cutu bëꞌë latj laꞌná, le nö́zigac naquëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Catiꞌ zaꞌ reníꞌ yetú dza, brujëꞌ Jesús Capernaum naꞌ, atiꞌ gyijëꞌ tu latj caꞌz. Niꞌ guluguílj Jesús bunách zian. Catiꞌ guladxinëꞌ ga naꞌ zoëꞌ, glëꞌnnëꞌ lutseynëꞌ Lëꞌ, cui uzë́ꞌë ga naꞌ nacuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Niꞌr gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Run bayúdx tsijaꞌ gap nacuáꞌ yezicaꞌ yödz, tsjenaꞌ caꞌ niꞌ lban qui didzaꞌ dxiꞌa ca rna bëꞌë Dios. Qui lë ni naꞌ bsölëꞌë nedaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cni guc, benëꞌ lban yuguꞌ yödz luyú Galilea len gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Catiꞌ niꞌ zoëꞌ Jesús raꞌ nis zxön nazíꞌ lei Genesaret, guluquí gulutsútsj Lëꞌ bunách zian quië laꞌyöni xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Niꞌr bléꞌinëꞌ chop bárcodauꞌ Jesús, zxoagac lu nis zxön ga naꞌ nac raꞌ yu bidx, atiꞌ narujquëꞌ lë́ꞌigac bárcodauꞌ naꞌ bönniꞌ uzö́n böl len taꞌguibëꞌ yöxj böl quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Grenëꞌ Jesús tu lëꞌi bárcodauꞌ naꞌ, le naqui queëꞌ Simón Pedro, atiꞌ gnabnëꞌ lëꞌ udxiguëꞌë lei yelátiꞌdauꞌ ziꞌtuꞌ ga nac raꞌ yu bidx naꞌ. Niꞌr gröꞌë Jesús lëꞌi bárcodauꞌ naꞌ, len röꞌzëꞌ caꞌ niꞌ rusëdnëꞌ bunách zian nacuáꞌ niꞌ lu yu bidx naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Catiꞌ budx bëꞌë didzaꞌ Jesús, niꞌr gudxëꞌ Simón, rnëꞌ: ―Bsaꞌ bárcodauꞌ ni lu nis zxön ga naꞌ röꞌ zil, atiꞌ niꞌ gul‑zál yöxj böl queëliꞌ quië sönliꞌ‑baꞌ böl. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bubiꞌë didzaꞌ Simón, rëꞌ Jesús: ―Bönniꞌ Usëdi, gdu yël chbentuꞌ dxin len nitubaꞌ böl cutu rzö́nituꞌ‑baꞌ, san didzaꞌ quiuꞌ gzálgaraꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Catiꞌ chgulazalëꞌ yöxj naꞌ, gulazönëꞌ ziántërbaꞌ böl atiꞌ ráquitiquiꞌ grözaꞌ yöxj böl naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Niꞌr gululáꞌ gululuiꞌznëꞌ, gululidzëꞌ lzaꞌquëꞌ nacuꞌë yetú lëꞌi bárcodauꞌ naꞌ djaquëꞌ láclenëꞌ lequëꞌ. Catiꞌ guladxinëꞌ niꞌ guludzë́ꞌëꞌ‑baꞌ böl groptë bárcodauꞌ naꞌ atiꞌ chraqui luhuö́tj lu nis bárcodauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Catiꞌ bléꞌinëꞌ lë ni Simón Pedro, niꞌr buzechu zxibëꞌ lahuëꞌ Jesús, rnëꞌ: ―Bcuit ga zoaꞌ, Xan, le nacaꞌ bönniꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Cni gnëꞌ le radxi rdzöbnëꞌ Pedro niꞌa quecbaꞌ böl zian naꞌ gulazönquëꞌ‑baꞌ, len lëzcaꞌ cni guc quegac nup nacuaꞌlen lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gladxi guladzöbnëꞌ caꞌ Jacobo len Juan, yuguꞌ zxiꞌnëꞌ Zebedeo, nup ni nacgac lzëꞌë Simón Pedro naꞌ. Niꞌr rëꞌ Simón naꞌ Jesús, rnëꞌ: ―Cutu gádxinuꞌ. Naꞌa su lauꞌ gchëꞌu quiaꞌ bunách ca runuꞌ rzönuꞌ‑baꞌ böl. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Catiꞌ chguluschinëꞌ yuguꞌ bárcodauꞌ naꞌ ga nac raꞌ yu bidx, niꞌr gulucaꞌnëꞌ niꞌ yúguꞌtë, atiꞌ zjáclenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Catiꞌ zoëꞌ Jesús tu lu yödz niꞌ, bdxinëꞌ ga naꞌ zoëꞌ bönniꞌ réꞌitsquinëꞌ huëꞌ nudzuꞌ ruzö́d. Catiꞌ bléꞌinëꞌ Jesús, butság lahuëꞌ lyu, len gútaꞌyuëꞌ lahuëꞌ, rnëꞌ: ―Xan, chquiꞌ rëꞌnnuꞌ, huac unuꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Niꞌr bulí nëꞌë Jesús len gdanëꞌ lëꞌ. Rëꞌ lëꞌ: ―Rëꞌndaꞌ. Gacuꞌ dxiꞌa. Laꞌ gbidxtë huëꞌ nudzuꞌ queëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Niꞌr gna béꞌinëꞌ lëꞌ Jesús nutu nu guiëꞌ caꞌ. Gudxëꞌ lëꞌ: ―Gyeaj, yajluíꞌ cuinuꞌ lahuëꞌ bxuz, atiꞌ yajnö́dzj quië le un dxiꞌa liꞌ qui gdauꞌ ca gna bëꞌë Moisés, lë naꞌ uluíꞌi lequëꞌ chböacuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gzëtër caꞌ didzaꞌ qui yöl‑laꞌ huac queëꞌ Jesús, atiꞌ guludúb ga naꞌ zoëꞌ bunách zian quië laꞌyöni xtidzëꞌë len quië unëꞌ lequëꞌ, ugǘëꞌ guidzhuë́ꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Niꞌr buzë́ꞌë niꞌ Jesús, gyijëꞌ tu latj caꞌz, atiꞌ niꞌ bulidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yetú dza, catiꞌ niꞌ rusëdnëꞌ bunách Jesús, röꞌquëꞌ caꞌ niꞌ yuguꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ tuꞌsëdi taquëꞌ zxba queëꞌ Moisés, narujquëꞌ yúguꞌtë yödz luyú Galilea len luyú Judea len lu yödz Jerusalén. Nac bëꞌ dë lu nëꞌë Jesús yöl‑laꞌ huac queëꞌ Xanruꞌ Dios le ruúnëꞌ bunách teꞌi nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Niꞌr guladxinëꞌ niꞌ bönniꞌ nuaꞌquëꞌ le deynëꞌ bönniꞌ huëꞌ nacuꞌnëꞌ bin, atiꞌ gulaguiljëꞌ nacx lunëꞌ laꞌguꞌë lëꞌ lu yuꞌu quië laꞌguixjëꞌ lëꞌ lahuëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Catiꞌ cutu guladzölnëꞌ nacx lunëꞌ, le nacuáꞌ niꞌ bunách zian, gulabenëꞌ cjuꞌu yuꞌu naꞌ len gulasaljëꞌ cjuꞌu naꞌ. Niꞌr guluzötjëꞌ niꞌ le deynëꞌ bönniꞌ huëꞌ naꞌ, atiꞌ gulaguixjëꞌ lëꞌ gatsj lahuiꞌl bunách niꞌ lahuëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Catiꞌ gúquibeꞌinëꞌ Jesús ca naꞌ taꞌyejlëꞌë Lëꞌ, gudxëꞌ bönniꞌ huëꞌ naꞌ: ―Bönniꞌ, yuguꞌ dul‑laꞌ nabaguꞌu chbunít lahuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niꞌr gulazú lauquëꞌ taꞌzáꞌ ládxiꞌquëꞌ bönniꞌ gdauꞌ tuꞌsëdi naꞌ len yuguꞌ bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―¿Nuzxa caz bönniꞌ ni rnëꞌ le rucáꞌn Dios caꞌz? ¿Nuzxa caz gac unít lau dul‑laꞌ? Tuzëꞌ Dios runít lahuëꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ráquibeꞌinëꞌ Jesús le taꞌzáꞌ ládxiꞌquëꞌ atiꞌ rëꞌ lequëꞌ: ―¿Bizx quië rzaꞌ ládxiꞌliꞌ cni? ");
INSERT INTO zsrNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Cutu nac baníg nu guiëz bönniꞌ ni: “Yuguꞌ dul‑laꞌ nabaguꞌu chbunít lahuaꞌ”, san nac baníg nu gun ga tsasëꞌ len sëꞌi niꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gunaꞌ ga gnö́ziliꞌ dë lu naꞌa luyú ni nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, yöl‑laꞌ uná bëꞌ unít lahuaꞌ dul‑laꞌ. Niꞌr gudxëꞌ bönniꞌ naꞌ nacuꞌnëꞌ bin, rnëꞌ: ―Liꞌ rëpaꞌ, gyas. Buaꞌ le deynuꞌ len böaj lidxuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Laꞌ gyastëꞌ bönniꞌ huëꞌ naꞌ lauquëꞌ atiꞌ buꞌë lë naꞌ gútiꞌnëꞌ, zhuöjëꞌ lidxëꞌ, rguꞌë Dios yöl‑laꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gulaníttsquinëꞌ yúguꞌtëꞌ, atiꞌ gulaguꞌë Dios yöl‑laꞌ ba, len tádxiznëꞌ caꞌ, taꞌnë́ꞌ: ―Naꞌa bléꞌiruꞌ le run ga rubániruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gdöd glac lë ni brujëꞌ niꞌ Jesús atiꞌ bléꞌinëꞌ tu bönniꞌ uquízxj lazgac bunách lëꞌ Leví, röꞌë ga naꞌ ruquizxjëꞌ, atiꞌ Jesús rëꞌ lëꞌ: ―Gdaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Laꞌ gyastëꞌ Leví, atiꞌ bucaꞌnëꞌ yúguꞌtë, zéajlenëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gdöd niꞌ, benëꞌ Leví naꞌ tu güiꞌi huagu queëꞌ Jesús ga nac lu yuꞌu lidxëꞌ, atiꞌ gulacuꞌë niꞌ zian bönniꞌ uquízxj len yelaꞌquëꞌ bönniꞌ taꞌbö́ꞌlenëꞌ lequëꞌ tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Niꞌr gulanë́ꞌ quequëꞌ bönniꞌ usë́d queëꞌ Jesús bönniꞌ gdauꞌ tuꞌsëdi len yuguꞌ bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―¿Bizx quië riꞌj rágulenliꞌ yuguꞌ bönniꞌ uquízxj len yelaꞌquëꞌ bönniꞌ dul‑laꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu naquincnëꞌ nu un bunách bönniꞌ nacuꞌë dxiꞌa, san bönniꞌ téꞌinëꞌ naquincnëꞌ nu un bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Zaꞌa, clëg ulídzgacaꞌ‑nëꞌ bönniꞌ tsahuiꞌ, san zaꞌa ulídzgacaꞌ‑nëꞌ bönniꞌ dul‑laꞌ quië lubíꞌi ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Niꞌr gulanabnëꞌ Jesús bönniꞌ gdauꞌ naꞌ, taꞌnë́ꞌ: ―¿Bizx quië tunëꞌ gubás zian lzu bönniꞌ daꞌquëꞌ Juan, len tuꞌlidzëꞌ Dios, atiꞌ tunëꞌ caꞌ cni bönniꞌ daꞌquëꞌ yuguꞌ bönniꞌ gdauꞌ fariseo, san bönniꞌ daꞌquëꞌ Liꞌ tiꞌj tahuëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús rëꞌ lequëꞌ: ―¿Naruꞌ huactsa gunliꞌ ga lunëꞌ gubás bönniꞌ nacuꞌë lni qui yöl‑laꞌ rutság naꞌ tsal niꞌ zóalenëꞌ lequëꞌ bönniꞌ rutság nëꞌë? ");
INSERT INTO zsrNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Huadxín dza catiꞌ gduëꞌ ga nacuꞌë bönniꞌ rutság nëꞌë. Dza niꞌr lunëꞌ gubás. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Niꞌr benëꞌ lsaquiꞌ ca nac lë ni Jesús, rëꞌ lequëꞌ: ―Nutu nu bönniꞌ gchuguëꞌ lariꞌ cub chnadía len cuijëꞌ tstacaꞌ le udë́ꞌë lëꞌi lariꞌ tëb. Chquiꞌ gunëꞌ cni, clëgz gac ditj lariꞌ cub naꞌ, san láriꞌdauꞌ naꞌ gruj lëꞌi lariꞌ cub naꞌ cutu tsajlö́z lariꞌ tëb naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Lëzcaꞌ cni, nutu nu bönniꞌ rguëꞌë xisi uva cub lu röꞌö gul náquini guid. Chquiꞌ nu gun cni, uláꞌa röꞌö gul naꞌ náquini guid xisi uva cub naꞌ, atiꞌ glalj xisi uva naꞌ, atiꞌ gac ditj röꞌö gul naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Qui lë ni naꞌ ral‑laꞌ caꞌaruꞌ xisi uva cub lu röꞌö náquini guid cub, atiꞌ groptë lac chiꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chquiꞌ zoa nu riꞌj xisi uva gul, cutu guë́ꞌnitë guiꞌj xisi uva cub, le rna: “Nacr szxiꞌ xisi uva gul naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Catiꞌ nac tu dza laꞌy quequëꞌ bönniꞌ judío, rdödëꞌ Jesús gap dë yöl zxoaꞌ xtil, atiꞌ taꞌleycjëꞌ deu ga dxia zxoaꞌ xtil bönniꞌ usë́d queëꞌ. Taꞌzxúbiꞌni naꞌquëꞌ lei len tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niꞌr gulanabnëꞌ lequëꞌ bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―¿Bizx quië runliꞌ le cural‑laꞌ gunruꞌ dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ cu nulábniliꞌ ca benëꞌ David catiꞌ gdunëꞌ, atiꞌ guladún caꞌ nup nacuaꞌlen lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gyaziëꞌ lu yuꞌu queëꞌ Dios len gzxiꞌë yöt xtil tuꞌcuꞌë lahuëꞌ Dios, lë naꞌ cutu ral‑laꞌ gáguruꞌ, san tuz bxuz dë latj lahuëꞌ, atiꞌ gdahuëꞌ lei David len bëꞌë caꞌ quegac nup nacuaꞌlen lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Niꞌr gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Nacaꞌ xani dza laꞌy nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Catiꞌ nac yetú dza laꞌy quequëꞌ bönniꞌ judío, gyaziëꞌ Jesús lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios len busëdnëꞌ nup nacuáꞌ niꞌ. Zoëꞌ caꞌ niꞌ bönniꞌ narequiꞌ nëꞌë yubél. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tuꞌyúëꞌ Jesús bönniꞌ gdauꞌ tuꞌsëdi len yuguꞌ bönniꞌ gdauꞌ fariseo quië laꞌléꞌinëꞌ chquiꞌ unëꞌ lëꞌ catiꞌ nac dza laꞌy quequëꞌ quië ludzölnëꞌ nacx luquíëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ráquibeꞌinëꞌ Jesús le taꞌzáꞌ ládxiꞌquëꞌ, atiꞌ gudxëꞌ bönniꞌ naꞌ narequiꞌ nëꞌë, rnëꞌ: ―Gyas. Gzui gatsj lahuiꞌl ni. Laꞌ gyastëꞌ bönniꞌ naꞌ, gzuinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Niꞌr gudxëꞌ yuguꞌ bönniꞌ gdauꞌ naꞌ Jesús, rnëꞌ: ―Unábitsquiꞌdaꞌ lbiꞌiliꞌ tu didzaꞌ. ¿Naruꞌ dë latj catiꞌ nac dza laꞌy gunruꞌ le nac dxiꞌa o gunruꞌ le cunác? ¿Naruꞌ dë latj uguél‑laꞌruꞌ yöl‑laꞌ naꞌbán quegac bunách, o uguaruꞌ lei? ");
INSERT INTO zsrNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Niꞌr buyúëꞌ Jesús yúguꞌtë bönniꞌ naꞌ nacuꞌë gdu cuitiëꞌ, atiꞌ gudxëꞌ bönniꞌ huëꞌ naꞌ: ―Bli naꞌu. Bulí nëꞌë bönniꞌ naꞌ, atiꞌ laꞌ böactë nëꞌë naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Niꞌr gulaleynëꞌ bönniꞌ gdauꞌ naꞌ, atiꞌ glun xtídzaꞌquëꞌ laꞌ légaczëꞌ nacx bi lunëꞌ queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dza niꞌ gyijëꞌ Jesús ga nac tu lu guíꞌadauꞌ. Niꞌ bulidzëꞌ Dios, atiꞌ gdu yël bë́ꞌlenëꞌ Dios didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Catiꞌ zaꞌ reníꞌ, bulidzëꞌ bönniꞌ daꞌquëꞌ Lëꞌ, atiꞌ gröëꞌ chinnuëꞌ quië lacquëꞌ gbaz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bulidzëꞌ Simón, (lëꞌ caꞌ Pedro), Andrés, (böchëꞌë Pedro), Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO zsrNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo, (zxiꞌnëꞌ Alfeo), Simón, (bönniꞌ ruiꞌ ladxëꞌë yödz queëꞌ), ");
INSERT INTO zsrNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, (böchëꞌë Jacobo), Judas Iscariote, (bönniꞌ udödëꞌ Jesús lu naꞌquëꞌ bönniꞌ ludöddëꞌ Lëꞌ). ");
INSERT INTO zsrNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bö́tjlenëꞌ bönniꞌ gbaz queëꞌ naꞌ Jesús lu guíꞌadauꞌ naꞌ, atiꞌ guladxinëꞌ tu ga nac lachiꞌ, ga niꞌ nacuꞌë zianr caꞌ bönniꞌ usë́d queëꞌ, nacuaꞌlen lequëꞌ bunách zian narujgac yúguꞌtë yödz luyú Judea len yödz Jerusalén, len yuguꞌ yödzdauꞌ dëgac raꞌ nis zxön ga naꞌ nacuáꞌ yödz Tiro len Sidón. Guladxín niꞌ bunách ni quië luzë́ nagquëꞌ xtidzëꞌë Jesús, len luhuöaquëꞌ lu guidzhuë́ꞌ qui queëquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Guluhuöaquëꞌ caꞌ bönniꞌ niꞌ taꞌzacaꞌ taꞌguiꞌë lu naꞌgac böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yúguꞌtë bunách zian naꞌ tuiꞌ ládxiꞌgac laꞌgán Jesús le ruúnëꞌ yúguꞌtëꞌ len yöl‑laꞌ huac queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Niꞌr buyúëꞌ Jesús bönniꞌ usë́d queëꞌ nacuꞌë niꞌ, len gudxëꞌ lequëꞌ: ―Bicaꞌ ba lbiꞌiliꞌ, nacliꞌ yechiꞌ ladxiꞌ, le gataꞌ queëliꞌ latj ga rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Bicaꞌ ba lbiꞌiliꞌ rdunliꞌ naꞌa, le huöljliꞌ. ’Bicaꞌ ba lbiꞌiliꞌ rbödxliꞌ naꞌa, le uzxidxliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Bicaꞌ ba lbiꞌiliꞌ, le zaꞌ dza catiꞌ culaꞌleꞌi lbiꞌiliꞌ dxiꞌa bunách len lubíj lbiꞌiliꞌ ga nacuáꞌ len laꞌnë́ ziꞌ queëliꞌ, len lucáꞌn caꞌz le nazíꞌ laliꞌ ca tu le nac xöhuiꞌ le daꞌliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gul‑zíꞌ xbey dza naꞌ len gul‑dziji, le nac zxön le gaqui queëliꞌ yehuaꞌ yubá. Lëzcaꞌ cni glunëꞌ xuz xtauꞌgac bunách ni quequëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, dë yöl‑laꞌ tsahuiꞌ queëliꞌ, le chdë le ruziꞌliꞌ xbey. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ nuhuö́lj nadzë́ꞌiliꞌ naꞌa, le huadunliꞌ. ’Bicaꞌ bayechiꞌ lbiꞌiliꞌ ruzxidxliꞌ naꞌa, le huíꞌniliꞌ len cödx yéchiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ taꞌnë́ dxiꞌa queëliꞌ yúguꞌtë bunách. Lëzcaꞌ cni glunëꞌ xuz xtauꞌliꞌ, gulanë́ꞌ dxiꞌa quequëꞌ bönniꞌ gulazíꞌ yëꞌë, gulanë́ꞌ nacquëꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gnëꞌ caꞌ Jesús: ―Lbiꞌiliꞌ zoaliꞌ ni ryö́niliꞌ nedaꞌ, rëpaꞌ lbiꞌiliꞌ: Gul‑dxíꞌi nup cutaꞌleꞌi lbiꞌiliꞌ dxiꞌa. Gul‑gún le nac dxiꞌa quegac nup tuꞌdíꞌi lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gul‑náb lahuëꞌ Dios gac dxiꞌa quegac nup tuaꞌ döꞌ queëliꞌ len gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ gáclenëꞌ nup taꞌnë́ ziꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chquiꞌ nu capaꞌ tslaꞌa xaguꞌ, bzë yetsláꞌa caꞌ xaguꞌ. Chquiꞌ nu cua lariꞌ naxóa cudzuꞌu, bëꞌ latj cua caꞌ zxauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nútiꞌtëz nu bi gnab le dë quiuꞌ, bnödzj qui, atiꞌ nu cua le naqui quiuꞌ, cutu unabuꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ca rë́ꞌniliꞌ lun queëliꞌ bunách, lëzcaꞌ cni gul‑gún quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Chquiꞌ nadxiꞌizliꞌ nup nadxiꞌigac lbiꞌiliꞌ, ¿bizxa yöl‑laꞌ ba gdél‑liꞌliꞌ? Lëzcaꞌ cni tunëꞌ bönniꞌ dul‑laꞌ, taꞌdxiꞌinëꞌ nup nadxiꞌigac lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chquiꞌ runliꞌ le nac dxiꞌa quegacz nup tun dxiꞌa queëliꞌ, ¿bizxa yöl‑laꞌ ba gdél‑liꞌliꞌ? Lëzcaꞌ cni tunëꞌ bönniꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chquiꞌ runödzjliꞌ quegac nup runliꞌ löz lubíꞌi queëliꞌ, ¿bizxa yöl‑laꞌ ba gdél‑liꞌliꞌ? Lëzcaꞌ cni tunëꞌ bönniꞌ dul‑laꞌ, tuꞌnödzjëꞌ quegac nup tun dul‑laꞌ, le tunëꞌ löz lubíꞌi quequëꞌ lë naꞌ gulunödzjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Gul‑dxíꞌi nup cutaꞌleꞌi lbiꞌiliꞌ dxiꞌa len gul‑gún le nac dxiꞌa. Gul‑nö́dzj quegac bunách zal‑laꞌ cutu runliꞌ löz nu ubíꞌi queëliꞌ. Chquiꞌ cni gunliꞌ, zxön nac le gataꞌ queëliꞌ, atiꞌ gacliꞌ zxiꞌnczëꞌ Dios, Nu nactër blau, le runëꞌ Lëꞌ le nac dxiꞌa quegac bunách cutaꞌdzág ládxiꞌgac len quegac bunách tuaꞌdöꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gul‑huechiꞌ ladxiꞌ bunách ca naꞌ runëꞌ Xuzliꞌ Dios, ruhuechiꞌ ladxëꞌë yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gnëꞌ caꞌ Jesús: ―Cutu glag yudxliꞌ lzaꞌliꞌ, atiꞌ nutu nu glag yudx lbiꞌiliꞌ. Cutu cuiaj bëꞌliꞌ qui lzaꞌliꞌ, atiꞌ nutu nu cuiaj bëꞌ queëliꞌ. Gul‑nít lau lzaꞌliꞌ, atiꞌ Dios unít lahuëꞌ caꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gul‑nö́dzj qui lzaꞌliꞌ, atiꞌ Dios gunnëꞌ queëliꞌ. Lunödzjëꞌ queëliꞌ le lurixëꞌ len tu guiꞌn rbixi le nac gdu, le naguír, len naguí gazxj ga rëꞌ, len zoatsca gba. Ca nac le rurixliꞌ, laꞌ caꞌz urixëꞌ caꞌ queëliꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Benëꞌ lsaquiꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ huactsa bönniꞌ lau chul gchëꞌë yetúëꞌ bönniꞌ lau chul? Cutu caꞌ gac, le laꞌbixëꞌ gropëꞌ tu yeru. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Cutu caꞌ gacrëꞌ blau bönniꞌ usë́d ca nu rusëdi lëꞌ, san catiꞌ udx gzëdëꞌ bönniꞌ naꞌ, gaquëꞌ ca nac nu naꞌ rusëdi lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bizx quië ruyúꞌ bëbdauꞌ yuꞌu yöj lahuëꞌ böchiꞌ lzaꞌu, len cutu rléꞌinuꞌ le zxön yuꞌu yöj lauꞌ liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Naruꞌ huactsa guiꞌu‑nëꞌ böchiꞌ lzaꞌu: “Böchaꞌa, benn latj cuijaꞌ bëbdauꞌ yuꞌu yöj lauꞌ”, len cutu rléꞌinuꞌ le zxön yuꞌu yöj lauꞌ liꞌ? Liꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinuꞌ. Gleaj ziꞌal le zxön yuꞌu yöj lauꞌ liꞌ, atiꞌ niꞌr gléꞌinuꞌ dxiꞌa quië cuijuꞌ bëbdauꞌ yuꞌu yöj lahuëꞌ böchiꞌ lzaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Gnëꞌ caꞌ Jesús: ―Cutu gac cuia le xöhuiꞌ yag dxiꞌa. Lëzcaꞌ cni, cutu gac cuia le nac dxiꞌa yag xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cni nac, le rbia yag nac bëꞌ ca nac yag naꞌ. Cutu ruchibruꞌ le rbia yag higo lu yag yötsiꞌ, len clëg lu bsequiꞌ yötsiꞌ cutu ruchibruꞌ le rbia lba uva. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Didzaꞌ dxiꞌa ruꞌë bönniꞌ dxiꞌa le yuꞌu icj ládxiꞌdauꞌhuëꞌ le nac dxiꞌa, atiꞌ didzaꞌ xöhuiꞌ ruꞌë bönniꞌ xöhuiꞌ le yuꞌu icj ládxiꞌdauꞌhuëꞌ le xöhuiꞌ. Rnë rúꞌaruꞌ ca nac le yuꞌu icj ládxiꞌdauꞌruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Gnëꞌ caꞌ Jesús: ―¿Bizx quië rulidzliꞌ nedaꞌ, rnaliꞌ: “Xantuꞌ, Xantuꞌ”, san cutu runliꞌ ca rna béꞌidaꞌ lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Uluiꞌidaꞌ lbiꞌiliꞌ ca nac nu naꞌ zaꞌ quiaꞌ len ryöni xtidzaꞌa len run ca rna béꞌidaꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nu ni nac ca bönniꞌ, catiꞌ benëꞌ lidxëꞌ, ga rëꞌ bchöꞌnëꞌ len bdxiëꞌ xlibi yuꞌu ga nac lu guiöj. Catiꞌ bötj gbaꞌu, bchöꞌn cuit yuꞌu naꞌ, san cutu guc uquíndj lei, le nulíb ga nac lu guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naꞌa, nu ryöni xtidzaꞌa len cutu run ca rna béꞌidaꞌ lei, nu ni nac ca bönniꞌ benëꞌ lidxëꞌ ga nac lu yu caꞌz, cutu nunëꞌ xlibi. Catiꞌ bchöꞌn cuit yuꞌu naꞌ gbaꞌu, laꞌ bguindjtë, atiꞌ gbix dëra zöꞌö qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Catiꞌ budx bë́ꞌlenëꞌ lequëꞌ didzaꞌ ni, gyaziëꞌ Jesús Capernaum. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lu yödz niꞌ zoëꞌ bönniꞌ Roma, nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l len zoabiꞌ biꞌi huen dxin queëꞌ nadxíꞌitsquinëꞌ‑biꞌ, atiꞌ biꞌi ni réꞌibiꞌ len chraqui gatbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Catiꞌ byönnëꞌ bönniꞌ ni didzaꞌ tuꞌë bönniꞌ ca nac queëꞌ Jesús, laꞌ bsö́laꞌtëꞌ ga naꞌ zoëꞌ Jesús laꞌquëꞌ bönniꞌ gul tuꞌzéjniꞌnëꞌ bönniꞌ judío, tsjö́taꞌyuquëꞌ lahuëꞌ Jesús guidëꞌ duhuenëꞌ‑biꞌ biꞌi huen dxin queëꞌ naꞌ réꞌibiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Guladxinëꞌ ga zoëꞌ Jesús bönniꞌ gul tuꞌzejniꞌi naꞌ, atiꞌ glátaꞌyuëꞌ lahuëꞌ gdu ládxiꞌquëꞌ, taꞌnë́ꞌ: ―Naquëꞌ lsacaꞌ bönniꞌ naꞌ gunuꞌ queëꞌ lë ni, ");
INSERT INTO zsrNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","le runëꞌ ba laꞌn bunách uládz queëruꞌ len benëꞌ queëruꞌ yuꞌu ga rudubruꞌ rusëdruꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Niꞌr gyéajlenëꞌ lequëꞌ Jesús. Catiꞌ chzoa laꞌdxinëꞌ lidxëꞌ bönniꞌ naꞌ, lëꞌ bsölëꞌë ga zëꞌë Jesús laꞌquëꞌ böchiꞌ lzëꞌë, tëꞌ Lëꞌ: ―Xan, rnëꞌ bönniꞌ naꞌ: “Cutu uguiꞌinuꞌ, le cutu nacaꞌ lsacaꞌ tsaziuꞌ lidxaꞌ ");
INSERT INTO zsrNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","len cutu nacaꞌ lsacaꞌ guidaꞌ ga zuꞌ. Qui lë ni naꞌ cutu burúguidaꞌ guidaꞌ ga zuꞌ. Bëꞌz didzaꞌ atiꞌ huöáctëbiꞌ biꞌi huen dxin quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nedaꞌ caꞌ, zoa nu rna beꞌi nedaꞌ, atiꞌ nacuꞌë caꞌ bönniꞌ rjaquëꞌ gdil‑l rna béꞌidaꞌ lequëꞌ. Rëpaꞌ‑nëꞌ tuëꞌ: Gyeaj niꞌ, atiꞌ rijëꞌ. Rëpaꞌ‑nëꞌ yetúëꞌ: Gda ni, atiꞌ ridëꞌ. Rëpaꞌ‑nëꞌ caꞌ huen dxin quiaꞌ: Ben dxin ni, atiꞌ runëꞌ dxin naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Catiꞌ byönnëꞌ didzaꞌ ni Jesús, bubannëꞌ queëꞌ bönniꞌ naꞌ, atiꞌ bueycjëꞌ, len gudxëꞌ bunách naꞌ zaꞌc cúdzuꞌlëꞌ, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, nutu nu bönniꞌ Israel cutu rajxáquiꞌdaꞌ‑nëꞌ rejlëꞌë nedaꞌ ca rejlëꞌë nedaꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Catiꞌ guludxinëꞌ bönniꞌ naꞌ bsölëꞌë lequëꞌ bönniꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, gulayaziëꞌ ga nac lu yuꞌu lidxëꞌ len gulaléꞌinëꞌ chböacbiꞌ biꞌi huen dxin naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gdöd guc lë ni, zijëꞌ Jesús yödz Naín, dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ lencaꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Catiꞌ bdxinëꞌ gal‑laꞌ raꞌ yödz naꞌ, niꞌ bléꞌinëꞌ bönniꞌ nuaꞌquëꞌ‑biꞌ tubiꞌ biꞌi bönniꞌ nat zajcáchiꞌquëꞌ‑biꞌ. Biꞌi nat naꞌ nacbiꞌ laꞌz dui biꞌi queënu ngul uzëbdauꞌ. Zjaclen‑nu ngul uzë́b naꞌ zian bunách uládz queënu. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Catiꞌ bléꞌinëꞌ‑nu Xanruꞌ, buechiꞌ ladxëꞌë‑nu, atiꞌ gudxëꞌ‑nu: ―Cutur cödxuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Niꞌr gbiguëꞌë Jesús, gdanëꞌ daꞌa yag ga naꞌ dëbiꞌ biꞌi nat naꞌ. Gulabözëꞌ bönniꞌ naꞌ nuaꞌquëꞌ‑biꞌ, atiꞌ Jesús gnëꞌ: ―Biꞌi, liꞌ rëpaꞌ, gyas. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Niꞌr bubanbiꞌ. Gröꞌbiꞌ biꞌi naꞌ ziꞌal natbiꞌ, atiꞌ gzu laubiꞌ ruiꞌbiꞌ didzaꞌ. Budödëꞌ‑biꞌ Jesús lu naꞌnu xnaꞌbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Catiꞌ gulaleꞌi lë ni bunách niꞌ, gládxinëꞌ yúguꞌtëꞌ, atiꞌ gulaguꞌë Dios yöl‑laꞌ ba, taꞌnë́ꞌ: ―Blëꞌë queëruꞌ bönniꞌ blau, ruꞌë didzaꞌ uláz queëꞌ Dios. Dioscz ráclenëꞌ bunách queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gzë didzaꞌ ca nac yöl‑laꞌ huac queëꞌ Jesús, atiꞌ gulayöni bunách yúguꞌtë yödz luyú Judea len yúguꞌtë yödz gdu zbiꞌil. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gulaguíxjöiꞌnëꞌ Juan bönniꞌ daꞌquëꞌ lëꞌ yúguꞌtë lë ni runëꞌ Jesús. Bulidzëꞌ Juan chopëꞌ bönniꞌ naꞌ daꞌquëꞌ lëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","atiꞌ bsölëꞌë lequëꞌ ga naꞌ zoëꞌ Jesús quië laꞌnabnëꞌ Lëꞌ, laꞌnë́ꞌ: “¿I nacuꞌ Liꞌ Cristo, bönniꞌ ral‑laꞌ guidëꞌ, o naruꞌ ral‑laꞌ cöztuꞌ‑nëꞌ bönniꞌ yubl?” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Catiꞌ guladxinëꞌ ga naꞌ zoëꞌ Jesús bönniꞌ naꞌ nasölëꞌë Juan, tëꞌ Jesús: ―Nasölëꞌë netuꞌ Juan, bönniꞌ buquilëꞌ bunách nis, quië gnábituꞌ Liꞌ, gnatuꞌ: “¿I nacuꞌ Liꞌ Cristo, bönniꞌ naꞌ ral‑laꞌ guidëꞌ, o naruꞌ ral‑laꞌ cöztuꞌ‑nëꞌ bönniꞌ yubl?” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Laꞌ naꞌz ruúnëꞌ Jesús zian nup teꞌi, yuguꞌ bönniꞌ huëꞌ len bönniꞌ yuꞌugac lequëꞌ böꞌ xöhuiꞌ, atiꞌ zian bönniꞌ lau chul busaljëꞌ yöj lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bubiꞌë didzaꞌ Jesús, rëꞌ chopëꞌ bönniꞌ naꞌ nasölëꞌë Juan, rnëꞌ: ―Gul‑tséaj, gul‑tsajtixjöiꞌ‑nëꞌ Juan ca nac le bléꞌiliꞌ len le byö́niliꞌ. Tuꞌléꞌinëꞌ bönniꞌ bchul lauquëꞌ. Tuꞌzë́ꞌë bönniꞌ glatsjëꞌ. Nuhuöacquëꞌ bönniꞌ güiꞌcnëꞌ huëꞌ nudzuꞌ ruzö́d. Tuꞌyönnëꞌ bönniꞌ gulacödzuëꞌ. Nubanquëꞌ bönniꞌ glatiëꞌ. Taꞌyönnëꞌ didzaꞌ dxiꞌa bönniꞌ yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bicaꞌ ba nu cugác chop ladxiꞌ zaꞌlen nedaꞌ zal‑laꞌ cutu runaꞌ ca raqui nu naꞌ ral‑laꞌ gunaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Catiꞌ guluzë́ꞌë niꞌ bönniꞌ naꞌ bsölëꞌë Juan, gzu lahuëꞌ Jesús rëꞌ bunách niꞌ ca nac queëꞌ Juan, rnëꞌ: ―¿Bizxa brujliꞌ yajyuliꞌ lu latj caꞌz? ¿Naruꞌ brujliꞌ yajyuliꞌ gui rutá lei böꞌ reycj? ");
INSERT INTO zsrNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Bizxa caz brujliꞌ yajyuliꞌ? ¿Naruꞌ brujliꞌ yajyuliꞌ‑nëꞌ bönniꞌ nacuëꞌ lariꞌ zácaꞌtsqui? Nö́ziczliꞌ nacuáꞌ lidxquëꞌ bönniꞌ taꞌná bëꞌë nup nácugac lariꞌ zácaꞌtsqui len tuꞌzíꞌ xbey yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Bizxa caz brujliꞌ yajyuliꞌ? ¿Naruꞌ brujliꞌ yajyuliꞌ‑nëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios? Ja, rëpaꞌ lbiꞌiliꞌ, atiꞌ náctërëꞌ blau ca nu ruiꞌ didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Naquëꞌ Juan bönniꞌ naꞌ nayúj lu guich laꞌy ca nac queëꞌ, rna: Byutscaꞌ, rsölaꞌa‑nëꞌ gbaz quiaꞌ, nörëꞌ ca Liꞌ. Bönniꞌ ni upë́ꞌë nöz ga töduꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Gap nacuáꞌ bunách, chquiꞌ zoëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, cutu nacrëꞌ blau ca Juan, bönniꞌ naꞌ buquilëꞌ bunách nis, san nu nactër cuidiꞌz ga rna bëꞌë Dios nactër blau ca Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Catiꞌ gulayöni didzaꞌ ni bëꞌë Juan bunách niꞌ len bönniꞌ tuꞌquizxjëꞌ lazgac bunách, gláquibeꞌinëꞌ le nac tsahuiꞌ lahuëꞌ Dios, len guladilëꞌ caꞌ nis lu nëꞌë Juan, ");
INSERT INTO zsrNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","san yuguꞌ bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ tuꞌsëdi taquëꞌ zxba queëꞌ Moisés cutu guladilëꞌ nis lu nëꞌë Juan, atiꞌ cni guc, gulucaꞌnëꞌ caꞌz le guꞌnnëꞌ Dios gunëꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Gnëꞌ caꞌ Xanruꞌ: ―¿Nacx usáquiꞌdaꞌ bunách dza ni zoaruꞌ naꞌa? ¿Nacxcz nacquëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nacquëꞌ ca biꞌidauꞌ taꞌguitjbiꞌ. Taꞌböꞌbiꞌ lu yëꞌy len taꞌbö́dxyaꞌabiꞌ. Taꞌnabiꞌ tubiꞌ yetubiꞌ: “Rucödxtuꞌ queëliꞌ gui san cutu ryaꞌliꞌ. Rul‑l yéchiꞌtuꞌ san cutu rbödxliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Cni nacliꞌ le bidëꞌ Juan, bönniꞌ buquilëꞌ bunách nis, len cutu gdahuëꞌ yöt xtil, len cutu guꞌë xisi uva, atiꞌ rnaliꞌ queëꞌ: “Tuꞌ xöhuiꞌ dzag lëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Catiꞌ bidaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, len riꞌj rahuaꞌ, rnaliꞌ quiaꞌ: “Bönniꞌ ni naquëꞌ bönniꞌ huáguxöꞌö len bönniꞌ riꞌjëꞌ. Naquëꞌ lzaꞌquëꞌ bönniꞌ tuꞌquizxjëꞌ len yezícaꞌrëꞌ bönniꞌ dul‑laꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Rëpaꞌ lbiꞌiliꞌ: Nac bëꞌ nup napgac yöl‑laꞌ rejniꞌi queëꞌ Dios niꞌa qui le tun. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bulidzëꞌ Jesús gágulenëꞌ lëꞌ tsazxö́n bönniꞌ gdauꞌ fariseo, atiꞌ gyaziëꞌ Jesús lidxëꞌ bönniꞌ naꞌ, len gröꞌë rahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Zoanu lu yödz naꞌ ngul udá dzag, len catiꞌ gnö́zinu röꞌë ráhuëꞌ Jesús lidxëꞌ bönniꞌ gdauꞌ fariseo naꞌ, niꞌr bdxinnu niꞌ nuaꞌnu bö́gaꞌdauꞌ náquini guiöj zacaꞌ le yudz tu le rlaꞌ zxix. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Catiꞌ bdxinnu zacaꞌ cúdzuꞌlëꞌ Jesús, gröꞌnu xniꞌë rbödxnu. Niꞌr gzu launu rguꞌnu nis rbödxnu niꞌë Jesús len ruzxinu niꞌë len guitsaꞌ icjnu. Butság launu niꞌë len gluꞌnu niꞌë lë naꞌ rlaꞌ zxix. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Catiꞌ bléꞌinëꞌ lë ni bönniꞌ gdauꞌ fariseo naꞌ nulidzëꞌ Jesús, gzaꞌ ladxëꞌë, rnëꞌ: “Laꞌnaruꞌ naquëꞌ bönniꞌ ni bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, huáquibeꞌinëꞌ nuzxa naꞌ len nacx nacnu ngul ni rgannu Lëꞌ, le nacnu ngul udá dzag.” ");
INSERT INTO zsrNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Niꞌr gudxëꞌ bönniꞌ fariseo naꞌ Jesús, rnëꞌ: ―Simón, dë tu le ral‑laꞌ gyëpaꞌ liꞌ. Bubiꞌë didzaꞌ bönniꞌ naꞌ, rnëꞌ: ―Gna, Bönniꞌ Usëdi. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús rëꞌ lëꞌ: ―Zoëꞌ bönniꞌ dë dumí queëꞌ atiꞌ nacuꞌë chopëꞌ bönniꞌ tal‑lëꞌë dumí queëꞌ. Tuëꞌ bönniꞌ naꞌ ral‑lëꞌë queëꞌ lazxjëꞌ qui chop iz, atiꞌ yetúëꞌ naꞌ ral‑lëꞌë queëꞌ lazxjëꞌ qui chop beoꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Le cudë́ quequëꞌ dumí luguizxjëꞌ lë naꞌ tal‑lëꞌë queëꞌ, qui lë ni naꞌ bunít lahuëꞌ gropëꞌ lë naꞌ tal‑lëꞌë queëꞌ. Gnatscaꞌ naꞌa. ¿Núzxalëꞌ bönniꞌ chopëꞌ ni gdxiꞌirnëꞌ bönniꞌ naꞌ bunít lahuëꞌ lequëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bubiꞌë didzaꞌ Simón naꞌ, rnëꞌ: ―Ráquidaꞌ nedaꞌ, bönniꞌ naꞌ rál‑laꞌrëꞌ queëꞌ dumí, lë naꞌ bunít lahuëꞌ. Jesús gudxëꞌ lëꞌ: ―Le nacz rnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Niꞌr bueycjëꞌ Jesús, atiꞌ niꞌ ruyúëꞌ‑nu ngul naꞌ, rëꞌ Simón: ―¿Naruꞌ rléꞌinuꞌ ngul ni? Gyaziaꞌ lidxuꞌ atiꞌ cutu bennuꞌ quiaꞌ nis quibdaꞌ niꞌa, san gluꞌnu niꞌa nis rbödxnu ngul ni, len buzxinu niꞌa len guitsaꞌ icjnu. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Cutu butság lauꞌ nedaꞌ, san catiꞌ bdxinteaꞌ lidxuꞌ, cutu ruzóa dxinu ngul ni, rutság launu niꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Cutu gluꞌu icjaꞌ le za, san gluꞌnu niꞌa lë naꞌ rlaꞌ zxix ngul ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Qui lë ni naꞌ rëpaꞌ liꞌ, dul‑laꞌ zian nabágaꞌnu ngul ni, chgyuꞌu yöl‑laꞌ runít lau quegac, atiꞌ nadxíꞌitsquinu nedaꞌ. Nu naꞌ Dios runít lahuëꞌ lei látiꞌdauꞌz, látiꞌdauꞌz nadxíꞌi Dios nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Niꞌr gudxëꞌ‑nu ngul naꞌ Jesús, rnëꞌ: ―Dul‑laꞌ nabaguꞌu chgyuꞌu yöl‑laꞌ runít lau qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Gulazú lauquëꞌ të lzaꞌquëꞌ bönniꞌ naꞌ taꞌbö́ꞌlenëꞌ Jesús tahuëꞌ, taꞌnë́ꞌ: ―¿Nuzxa caz bönniꞌ ni, runít lautsëꞌ caꞌ dul‑laꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Niꞌr gudxëꞌ‑nu ngul naꞌ Jesús, rnëꞌ: ―Le réjlëꞌu nedaꞌ, chbuláuꞌ liꞌ. Böaj lidxuꞌ, zoa dxi ladxuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gdöd glac lë ni, gdëꞌ Jesús gap nacuáꞌ zian yödz zxön len yuguꞌ yödzdauꞌ, atiꞌ niꞌ benëꞌ lban len gdíxjöꞌë didzaꞌ dxiꞌa ca rna bëꞌë Dios, dzagquëꞌ Lëꞌ idxínnutëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dzagcnu caꞌ Lëꞌ laꞌcnu ngul bunëꞌ lecnu Jesús, bubijëꞌ böꞌ xöhuiꞌ yuꞌugac lecnu, len bugǘëꞌ yuguꞌ guidzhuë́ꞌ quecnu. Nútsaꞌnu ladjcnu María, lënu caꞌ Magdalena, ngul naꞌ bubijëꞌ gadx böꞌ xöhuiꞌ yuꞌugac lënu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nútsaꞌnu caꞌ ladjcnu Juana, ngul queëꞌ Chuza, bönniꞌ dë lu nëꞌë le dë lidxëꞌ Herodes, len nútsaꞌnu caꞌ ladjcnu Susana. Taꞌguꞌnu le tahuëꞌ Jesús len yuguꞌ bönniꞌ usë́d queëꞌ ngul ni len zianrnu caꞌ, tuꞌnödzjnu le dë quecnu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gularúj yuguꞌ yödz niꞌ bunách zian, guladxín ga naꞌ zoëꞌ Jesús. Catiꞌ guludubëꞌ ga naꞌ zoëꞌ, Lëꞌ benëꞌ lsaquiꞌ, rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Brujëꞌ bönniꞌ guz, zjësiëꞌ xseydauꞌ. Catiꞌ niꞌ zjësiëꞌ, guluhuö́xj ga nac laꞌ nöz laꞌgac xseydauꞌ naꞌ, atiꞌ gululíb leygac bunách. Guladxinbaꞌ caꞌ bguindauꞌ, glëꞌjbaꞌ xseydauꞌ naꞌ dzöꞌ laꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Guluhuö́xj yelaꞌgac xseydauꞌ naꞌ lyu ga röꞌ guiöj. Catiꞌ gulalén xseydauꞌ naꞌ, laꞌ gulabidxtë le cunalupaꞌ yu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Guluhuö́xj yelaꞌgac xseydauꞌ naꞌ ga gululén lba yötsiꞌ. Tsazxö́n gulazxö́n lba yötsiꞌ naꞌ len xseydauꞌ naꞌ, atiꞌ gularöli xseydauꞌ naꞌ gulalén, lba yötsiꞌ naꞌ, len glun ditj leygac. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Guluhuö́xj yelaꞌgac xseydauꞌ naꞌ ga nac luyú dxiꞌa. Catiꞌ chgulazxö́n, gulunö́dzj. Tu dxiguꞌ naꞌ bunö́dzj yetú gayuaꞌtër xseydauꞌ caꞌ. Catiꞌ budx gnëꞌ cni Jesús, bëꞌë zidzj didzaꞌ, rnëꞌ: ―Nu zoa nag len ryöni ral‑laꞌ uzë́ nag. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Niꞌr gulanabnëꞌ Jesús bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Bizxa rëꞌni gna lë naꞌ benuꞌ lsaquiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús gudxëꞌ lequëꞌ: ―Dios ruzéjniꞌnëꞌ lbiꞌiliꞌ le nagachiꞌ ca rna bëꞌë Lëꞌ, san yezicaꞌ bunách ni, ruíꞌlenaꞌ lequëꞌ didzaꞌ le runaꞌ lsaquiꞌ quië catiꞌ luyúëꞌ, cutu laꞌléꞌinëꞌ, len catiꞌ laꞌyönnëꞌ, cutu laꞌyéjniꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Gnëꞌ caꞌ Jesús: ―Cni nac le ruluíꞌ lë naꞌ benaꞌ lsaquiꞌ: Xseydauꞌ naꞌ nac xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Xseydauꞌ naꞌ guluhuö́xj laꞌ nöz tuꞌluíꞌ ca rac quegac nup ni taꞌyöni didzaꞌ naꞌ san laꞌ zaꞌtë tuꞌ xöhuiꞌ len rgua didzaꞌ naꞌ bdxin lu icj ládxiꞌdauꞌquëꞌ bönniꞌ naꞌ, cui laꞌyejlëꞌë len cui lulë́ꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Xseydauꞌ naꞌ guluhuö́xj lyu ga röꞌ guiöj tuꞌluíꞌ ca rac quegac nup ni taꞌyöni didzaꞌ naꞌ len tuꞌdzijnëꞌ taꞌziꞌë lei, san nacquëꞌ ca xseydauꞌ naꞌ cutu ben lui. Tu chiꞌz taꞌyejlëꞌë, le rdxin le rziꞌ bëꞌ lequëꞌ, atiꞌ laꞌ tuꞌhuöatë ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Xseydauꞌ naꞌ guluhuö́xj ga gululén lba yötsiꞌ tuꞌluíꞌ ca rac quegac nup taꞌyöni didzaꞌ naꞌ, len catiꞌ chgulayönnëꞌ, tun nigui lequëꞌ yuguꞌ le tuiꞌ ládxiꞌquëꞌ yödzlyú ni, len yuguꞌ yöl‑laꞌ tsahuiꞌ qui, len yuguꞌ le taꞌdzág ládxiꞌquëꞌ tac ni, atiꞌ cutu run dxin didzaꞌ naꞌ lu icj ládxiꞌdauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Xseydauꞌ naꞌ guluhuö́xj ga nac luyú dxiꞌa tuꞌluíꞌ ca rac quegac nup ni, gdu ládxiꞌquëꞌ taꞌyönnëꞌ didzaꞌ naꞌ len taꞌguꞌë tsutsu lei lu icj ládxiꞌdauꞌquëꞌ, atiꞌ lu yöl‑laꞌ rböz zxön ladxiꞌ tunëꞌ ca rna didzaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Gnëꞌ caꞌ Jesús: ―Cutu caꞌ ruquel‑lëꞌë guiꞌ bönniꞌ atiꞌ laꞌ rudúsiꞌtëꞌ lei guiꞌn, len cutu rguꞌë lei zxani le rátiꞌnëꞌ, san ruzóëꞌ lei xlatj ga nac lnaꞌ lu yuꞌu, atiꞌ luzíꞌ xbey guiꞌ naꞌ nup laꞌyáz niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Glaꞌ lahui yúguꞌtë le nagachiꞌ, atiꞌ gac bëꞌ len gruj ga lnaꞌ yúguꞌtë le rac balánz. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Qui lë ni naꞌ, gul‑zë́ nagliꞌ, le huadél‑liꞌnëꞌ yelatiꞌ bönniꞌ ruzóëꞌ tsutsu icj ládxiꞌdauꞌhuëꞌ didzaꞌ ryönnëꞌ, huaziꞌrëꞌ xtidzëꞌë Dios, san bönniꞌ curuzóëꞌ tsutsu icj ládxiꞌdauꞌhuëꞌ didzaꞌ ryönnëꞌ, huadúa didzaꞌ naꞌ byönnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Niꞌr guladxinëꞌ ga naꞌ zoëꞌ Jesús xnëꞌë len yuguꞌ bönniꞌ böchëꞌë, san cutu guc laꞌbiguëꞌë gal‑laꞌ ga zoëꞌ le nacuáꞌ niꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Zoa niꞌ nu bulídz Jesús, rna: ―Nacuꞌë löꞌa xnaꞌu len yuguꞌ bönniꞌ böchuꞌu, tëꞌnnëꞌ luíꞌlenëꞌ Liꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Nup ni taꞌyöni xtidzëꞌë Dios len tun ca rna, bönniꞌ ni nacquëꞌ ca xnaꞌczaꞌ len yuguꞌ bönniꞌ bö́chiꞌczaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tu dza grenëꞌ Jesús tu lëꞌi bárcodauꞌ, dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, atiꞌ Jesús rëꞌ lequëꞌ: ―Huadö́dtscaꞌruꞌ yetsláꞌa nis zxön ni. Niꞌr zjactëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tsal niꞌ taꞌdödëꞌ lu nis zxön naꞌ, rasiëꞌ Jesús. Niꞌr gzu lau reycj böꞌ bdunuꞌ lu nis zxön naꞌ, atiꞌ chraqui huötj zxan nis bárcodauꞌ naꞌ len zoa banádx quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Niꞌr gulabiguëꞌë ga dëꞌ Jesús len guluspanëꞌ Lëꞌ, taꞌnë́ꞌ: ―¡Bönniꞌ Usëdi! ¡Bönniꞌ Usëdi! Chraqui huötjruꞌ lu nis. Catiꞌ bubanëꞌ Jesús, bulidzëꞌ böꞌ naꞌ reycj len nis naꞌ ryas rdxiatsca, atiꞌ gzoa dxi böꞌ naꞌ reycj len gröꞌ dxi lu nis zxön naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Niꞌr gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―¿Naruꞌ cu réjlëꞌliꞌ Dios? Gládxinëꞌ lequëꞌ len tuꞌbannëꞌ. Glë lzaꞌquëꞌ, tuëꞌ yetúëꞌ: ―¿Nuzxa caz bönniꞌ ni? Rna béꞌinëꞌ böꞌ reycj len nis zxön, atiꞌ tun ca rna xtidzëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Niꞌr guladxinëꞌ lu xyuquëꞌ bönniꞌ Gadara, le dë yetsláꞌa nis zxön ca dödl ga dë luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Catiꞌ brujëꞌ lëꞌi bárcodauꞌ naꞌ Jesús ga nac lu yu naꞌ, dutsaguëꞌ lëꞌ bönniꞌ yödz naꞌ. Chgdzey yuꞌu lëꞌ böꞌ xöhuiꞌ, len cutur racuëꞌ lariꞌ len cutur rzoëꞌ lu yuꞌu, san nun xlatjëꞌ lu bloj ga nadjgac yeru ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Catiꞌ bléꞌinëꞌ Jesús bönniꞌ naꞌ yuꞌu lëꞌ böꞌ xöhuiꞌ, grödxyëꞌë zidzj, atiꞌ buzechu zxibëꞌ lahuëꞌ Jesús len bëꞌë zidzj didzaꞌ, rnëꞌ: ―¿Bizxa ral‑laꞌa quiuꞌ, Jesús, Zxiꞌnëꞌ Dios náctërëꞌ blau? Rátaꞌyuaꞌ lauꞌ cui usacaꞌ ziꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Cni gnëꞌ le chgna béꞌinëꞌ Jesús böꞌ xöhuiꞌ naꞌ urúj lu bönniꞌ naꞌ. Zian lzu zíꞌatël brix butultsca bönniꞌ naꞌ böꞌ xöhuiꞌ naꞌ, atiꞌ glúguëꞌë lëꞌ du guia bönniꞌ yödz niꞌ len gulusijnëꞌ breguiꞌ guia niꞌa nëꞌë, san blëꞌë yuguꞌ du guia naꞌ, atiꞌ bchëꞌ lëꞌ lu latj caꞌz böꞌ xöhuiꞌ naꞌ yuꞌu lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Niꞌr gnabnëꞌ böꞌ xöhuiꞌ naꞌ Jesús, rnëꞌ: ―¿Bi leuꞌ? Böꞌ xöhuiꞌ naꞌ gudx Lëꞌ: ―Le Zian leaꞌ. Cni gna le yuꞌugac lëꞌ böꞌ xöhuiꞌ zian. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Niꞌr glátaꞌyu lahuëꞌ Jesús böꞌ xöhuiꞌ naꞌ cutu gsölëꞌë leygac latj chul quegac nup natgac. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nacuaꞌbaꞌ caꞌ niꞌ tu cöꞌbaꞌ cuch zian taꞌdabaꞌ tágubaꞌ lu guíꞌadauꞌ niꞌ, atiꞌ gulanáb yechiꞌ Jesús böꞌ xöhuiꞌ naꞌ guꞌë leygac latj tsajtsuꞌugac cuch zian naꞌ. Jesús bëꞌë leygac latj. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gulurúj lu bönniꞌ naꞌ böꞌ xöhuiꞌ, len yajtsuꞌugac cuch zian naꞌ, atiꞌ yjacbaꞌ cuch zian naꞌ ga nac lëꞌi guiöj. Yajbixcbaꞌ lu nis zxön, atiꞌ niꞌ gulayë́pibaꞌ nis. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Catiꞌ gulaléꞌinëꞌ ca naꞌ guc quecbaꞌ bönniꞌ tuꞌyuquëꞌ‑baꞌ cuch zian naꞌ, gladxi guladzöbnëꞌ. Gulazxundjëꞌ niꞌ, atiꞌ yhuöjquëꞌ yajtíxjöiꞌcnëꞌ nup nacuáꞌ yödz naꞌ len nup nacuáꞌ ladj guixiꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Niꞌr gularujëꞌ bönniꞌ yödz naꞌ, yajyuquëꞌ lë naꞌ guc. Catiꞌ guladxinëꞌ ga naꞌ zoëꞌ Jesús, gulaléꞌinëꞌ bönniꞌ naꞌ gulayúꞌu lëꞌ böꞌ xöhuiꞌ, röꞌë xniꞌë Jesús. Nacuëꞌ lariꞌ len dxíꞌadauꞌ chzoëꞌ, atiꞌ gládxinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Gulaguixjöiꞌ lequëꞌ ca guc nup naꞌ gulaleꞌi lë naꞌ guc, böaquëꞌ bönniꞌ naꞌ gulayúꞌu lëꞌ böꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Niꞌr glátaꞌyu lahuëꞌ Jesús urujëꞌ lu xyugac yúguꞌtë bunách zian naꞌ quegac yödz nababgac Gadara naꞌ, le tádxinëꞌ. Bubenëꞌ Jesús lëꞌi bárcodauꞌ naꞌ zhuöjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Gútaꞌyuëꞌ lahuëꞌ Jesús bönniꞌ naꞌ gulurúj lëꞌ böꞌ xöhuiꞌ naꞌ guꞌë lëꞌ latj tséajlenëꞌ Lëꞌ tsazxö́n. Gna béꞌinëꞌ lëꞌ Jesús ugaꞌnëꞌ niꞌ, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Böaj lidxuꞌ. Yajtixjöiꞌ bunách uládz quiuꞌ yuguꞌ le zxön benëꞌ quiuꞌ Dios. Böjëꞌ lidxëꞌ bönniꞌ naꞌ, atiꞌ buzë́ꞌ didzaꞌ gdu lu yödz niꞌ ca nac le zxön benëꞌ queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Catiꞌ budxinëꞌ Jesús yetsláꞌa nis zxön naꞌ, guludziji queëꞌ bunách zian nacuáꞌ niꞌ, le taꞌbözëꞌ Lëꞌ yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Niꞌr bdxinëꞌ ga zoëꞌ Jesús Jairo, bönniꞌ blau qui yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Byechuëꞌ xniꞌë Jesús len gútaꞌyuëꞌ lahuëꞌ tsijëꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cni benëꞌ le zoabiꞌ tubiꞌ biꞌi ngul queëꞌ, chraqui gatbiꞌ. Nacbiꞌ biꞌi tuticz queëꞌ len yuꞌubiꞌ ca chinnu iz. Tsal niꞌ zijëꞌ Jesús, naugac Lëꞌ bunách zian, tuꞌquír Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nútsaꞌnu ladj bunách zian naꞌ ngul, chguc chinnu iz rzacaꞌ rguiꞌnu, cutu ruhuíꞌi rön queënu qui huëꞌ quégaccznu ngul, atiꞌ chbutönu dëra le dë queënu, rguizxjnu nup tuꞌún bunách, san cutu guc nu bönniꞌ unëꞌ‑nu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gbígaꞌnu zacaꞌ cúdzuꞌlëꞌ Jesús len gdannu ruiꞌi lariꞌ nacuëꞌ, atiꞌ laꞌ buiꞌtë huëꞌ rön queënu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Niꞌr gnabnëꞌ nup nacuáꞌ niꞌ Jesús, rnëꞌ: ―¿Nuzxa naꞌ gdan nedaꞌ? Guladáꞌbaguëꞌë yúguꞌtëꞌ. Niꞌr glëꞌ Lëꞌ Pedro len nup nacuaꞌlen lëꞌ, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, nacuáꞌ ni bunách zian, tuꞌquír Liꞌ, len tuꞌdxiguëꞌë Liꞌ, atiꞌ ¿rnatsuꞌ: “¿Nuzxa naꞌ gdan nedaꞌ”? ");
INSERT INTO zsrNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Niꞌr Jesús gnëꞌ: ―Zoa nu gdan nedaꞌ, le gúquibeꞌidaꞌ bruj nedaꞌ yöl‑laꞌ huac le ruún bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Catiꞌ ráquibeꞌinu ngul naꞌ nöznëꞌ Jesús le bennu, niꞌr gzxiznu. Byéchunu xniꞌë Jesús len gdíxjöiꞌnu Lëꞌ laugac bunách zian naꞌ bizx quië naꞌ gdannu lariꞌ nacuëꞌ len ca naꞌ guc, laꞌ böáctënu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Niꞌr Jesús gudxëꞌ‑nu: ―Zxiꞌnaꞌ, le réjlëꞌu nedaꞌ chböacuꞌ. Böaj lidxuꞌ, zoa dxi ladxuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Catiꞌ niꞌ ruꞌë didzaꞌ ni Jesús, bdxinëꞌ niꞌ bönniꞌ zëꞌë lidxëꞌ bönniꞌ blau naꞌ qui yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, atiꞌ gudxëꞌ bönniꞌ blau naꞌ: ―Chgutbiꞌ biꞌi nguldauꞌ quiuꞌ. Cutur upizxjnuꞌ‑nëꞌ Bönniꞌ Usëdi. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Catiꞌ byönnëꞌ lë ni Jesús, bubiꞌë didzaꞌ, rëꞌ bönniꞌ blau naꞌ: ―Cutu gádxinuꞌ. Gyejlëꞌz Dios. Huöacbiꞌ biꞌi nguldauꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Catiꞌ gyaziëꞌ Jesús yuꞌu naꞌ, cutu bëꞌë latj nu tsazlen Lëꞌ san légaczëꞌ Pedro len Jacobo len Juan, lencaꞌ xuz xnaꞌbiꞌ nguldauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Taꞌbö́dx nup nacuáꞌ niꞌ. Taꞌbö́dx yechëꞌë queëbiꞌ biꞌi nguldauꞌ naꞌ, atiꞌ rëꞌ lequëꞌ Jesús, rnëꞌ: ―Cutur cödxliꞌ. Cutu natbiꞌ nguldauꞌ niꞌ. Raszbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gulutitjëꞌ Lëꞌ le nözcnëꞌ chnatbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Niꞌr gdel‑lëꞌë naꞌbiꞌ Jesús len bëꞌë zidzj didzaꞌ, rnëꞌ: ―Biꞌi nguldauꞌ, gyasch. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Niꞌr buꞌu böꞌ nacczbiꞌ, bubanbiꞌ, atiꞌ laꞌ gyástëbiꞌ. Gna béꞌinëꞌ lequëꞌ Jesús luꞌë le gágubiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gulubannëꞌ xuz xnaꞌbiꞌ, san Jesús gna béꞌinëꞌ lequëꞌ nutu nu lëꞌ ca naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Niꞌr butubëꞌ Jesús idxínnutëꞌ bönniꞌ usë́d queëꞌ, atiꞌ budödëꞌ lu naꞌquëꞌ yöl‑laꞌ huac len yöl‑laꞌ uná bëꞌ lubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách, len luúnëꞌ nup teꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bsölëꞌë lequëꞌ tsjenquëꞌ lban ca rna bëꞌë Dios len tsajhuenquëꞌ nup teꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús gudxëꞌ lequëꞌ: ―Cutu bi guaꞌliꞌ quië laꞌ nöz, ni xuyagdauꞌ, ni yöxj, ni yöt, ni dumí, len cutu gxoa yenliꞌ chop lariꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bítiꞌtëz yuꞌu ga tsazliꞌ, gul‑zóa niꞌ catiꞌ uzaꞌrliꞌ yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gátiꞌtëz ga cutu lun lbiꞌiliꞌ ba laꞌn bunách, gul‑rúj yödz naꞌ len gul‑cuíb bëchtö daꞌ lalabliꞌ, le uluíꞌi lequëꞌ nagáꞌn zxguiaꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Niꞌr gularujëꞌ bönniꞌ usë́d queëꞌ naꞌ. Guladödëꞌ yúguꞌtë yödzdauꞌ, tunëꞌ lban qui didzaꞌ dxiꞌa, len tuꞌúnëꞌ nup teꞌi yúguꞌtë lu yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Byönnëꞌ Herodes, bönniꞌ rna bëꞌë, ca nac yúguꞌtë le runëꞌ Jesús, atiꞌ gröꞌë baguíꞌi, le taꞌná bunách: ―Juan naꞌ chbubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yelaꞌquëꞌ taꞌnë́ꞌ: ―Chbulë́ꞌë Elías, bönniꞌ naꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. Yelaꞌquëꞌ taꞌnë́ꞌ: ―Chbubanëꞌ bönniꞌ bitsëꞌë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes naꞌ gnëꞌ: ―Juan naꞌ brixaꞌ yenëꞌ. ¿Nuzxa caz bönniꞌ ni, ryöndaꞌ queëꞌ runëꞌ yuguꞌ lë ni? Rzu rböꞌë Herodes gléꞌinëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Catiꞌ guludxinëꞌ ga zoëꞌ Jesús bönniꞌ gbaz nasölëꞌë Lëꞌ, gululuiꞌinëꞌ Lëꞌ yúguꞌtë le glunëꞌ. Niꞌr bchëꞌë lequëꞌ quizi Jesús. Yjaquëꞌ tu latj caꞌz lu xyu yödz Betsaida. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Catiꞌ chnö́zigac lë ni bunách, yajnaugac Lëꞌ, atiꞌ Jesús benëꞌ lequëꞌ ba laꞌn len bë́ꞌlenëꞌ lequëꞌ didzaꞌ ca rna bëꞌë Dios, atiꞌ bunëꞌ nup teꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Catiꞌ chzaꞌ ral dza naꞌ, gulabiguëꞌë ga zoëꞌ Jesús idxínnutëꞌ bönniꞌ gbaz queëꞌ, len tëꞌ Lëꞌ: ―Busölaꞌ bunách ni tsjac gap dë yödzdauꞌ len gap dë yuꞌudauꞌ gdu zbiꞌil quië tsajtiljquëꞌ gap lugaꞌnëꞌ len bi lahuëꞌ, le nac latj caꞌz ga ni zoaruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑guꞌë lbiꞌiliꞌ le lahuëꞌ. Tëꞌ Lëꞌ: ―Gayuꞌz yöt xtildauꞌ dë len chopzbaꞌ böl dëbaꞌ queëtuꞌ, o ¿naruꞌ huayéajtsatuꞌ tsjö́ꞌutuꞌ le lagu bunách zian ni? ");
INSERT INTO zsrNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nacuꞌë niꞌ ca chiʉ́n gayuꞌë bönniꞌ. Niꞌr gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Gul‑gún ga laꞌböꞌë tu cöꞌ hueajquëꞌ, lac ca chiʉ́n hueajquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cni glunëꞌ atiꞌ gulaböꞌë yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Niꞌr gdel‑lëꞌë Jesús gayuꞌ yöt xtil naꞌ len chopbaꞌ böl naꞌ, atiꞌ bchis lahuëꞌ ruyúëꞌ luzxbá, len rëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ leygac len bëꞌë quequëꞌ bönniꞌ usë́d queëꞌ quië lucuꞌë laugac bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Glahuëꞌ yúguꞌtëꞌ len guluhuöljnëꞌ. Gdöd naꞌ gulutubëꞌ yuguꞌ le nagáꞌn, atiꞌ guludzë́ꞌë gdu chinnu bdöꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tu dza tsal niꞌ zoëꞌ quizi Jesús, rulidzëꞌ Dios, atiꞌ dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―¿Nuzxa taꞌná bunách nu nacaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Taꞌná laꞌgac bunách nacuꞌ Juan, bönniꞌ buquilëꞌ bunách nis. Taꞌná yelaꞌgac nacuꞌ Elías, atiꞌ taꞌná yelaꞌgac nacuꞌ bönniꞌ bitsëꞌë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios dza niꞌtë, nubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Niꞌr gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―Nazx lbiꞌiliꞌ, ¿nuzxa rnaliꞌ nacaꞌ? Bubiꞌë didzaꞌ Pedro, rnëꞌ: ―Nacuꞌ Cristo nasölëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Niꞌr gudxtsquëꞌ lequëꞌ Jesús len gna béꞌinëꞌ lequëꞌ nutu nu lëꞌ Nu naquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Niꞌr rëꞌ lequëꞌ: ―Run bayúdx sacaꞌ quiꞌa nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, zian le gac quiaꞌ. Lucaꞌnëꞌ nedaꞌ caꞌz bönniꞌ gul tuꞌzejniꞌi len yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi. Ludöddëꞌ nedaꞌ, san töd tsonn dza Dios uspanëꞌ nedaꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gudxëꞌ caꞌ yúguꞌtëꞌ: ―Chquiꞌ rëꞌnnëꞌ bönniꞌ tëꞌë nedaꞌ, ral‑laꞌ uzóëꞌ tslaꞌl le naqui queëꞌ len gaquëꞌ ca bönniꞌ zijëꞌ zajtë́ꞌë lëꞌi yag cruz, atiꞌ niꞌr gac tëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nútiꞌtëz bönniꞌ ruiꞌ ladxëꞌë gun chiꞌë yöl‑laꞌ naꞌbán queëꞌ, unitiëꞌ lei, san bönniꞌ unitiëꞌ yöl‑laꞌ naꞌbán queëꞌ le dëꞌë nedaꞌ, bönniꞌ ni gataꞌ queëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cutu bi uziꞌë xbey bönniꞌ chquiꞌ utubëꞌ queëꞌ yúguꞌtë le dë yödzlyú ni san unitiëꞌ tsaz yöl‑laꞌ naꞌbán queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nu bönniꞌ rutuiꞌnëꞌ nedaꞌ len rutuiꞌnëꞌ caꞌ xtidzaꞌa, lëzcaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, utuiꞌdaꞌ bönniꞌ naꞌ catiꞌ huödaꞌ duná bëꞌa, dzaggac nedaꞌ yöl‑laꞌ yeníꞌ queëꞌ Xuzaꞌ len yöl‑laꞌ yeníꞌ quequëꞌ gbaz laꞌy queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Le nactë rëpaꞌ lbiꞌiliꞌ, nacuáꞌ ni laꞌquëꞌ bönniꞌ cutu latiëꞌ catiꞌ laꞌléꞌirnëꞌ dza duná bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Catiꞌ bzaꞌa xunuꞌ gbidz gdöd bëꞌë yuguꞌ didzaꞌ ni Jesús, niꞌr bchëꞌë Pedro len Juan len Jacobo, atiꞌ grenëꞌ tu lu guíꞌadauꞌ, ga naꞌ bulidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tsal niꞌ ruíꞌlenëꞌ Dios didzaꞌ, bdzaꞌ ca rnaꞌ lahuëꞌ, atiꞌ böac chguichdauꞌz lariꞌ nacuëꞌ len gyëp yös yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Niꞌr gululuíꞌ lauquëꞌ ga zoëꞌ Lëꞌ chopëꞌ bönniꞌ tuíꞌlenëꞌ Lëꞌ didzaꞌ. Nacquëꞌ Moisés len Elías. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Gulayëpëꞌ yös yeníꞌ chopëꞌ ni len tuíꞌlenëꞌ Jesús didzaꞌ ca ziꞌa uzë́ꞌë yödzlyú ni, gatiëꞌ lu yödz Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Zal‑laꞌ chractsca lasiëꞌ Pedro len nup nacuaꞌlen lëꞌ, bayúdx gulanaꞌzëꞌ taꞌléꞌinëꞌ yöl‑laꞌ yeníꞌ queëꞌ Jesús len chopëꞌ naꞌ nacuáꞌlenëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Catiꞌ guluzë́ꞌë niꞌ chopëꞌ naꞌ ga naꞌ zoëꞌ Jesús, niꞌr Pedro gudxëꞌ Lëꞌ: ―Bönniꞌ Usëdi, dxiꞌa nac zoaruꞌ ni. Gúntscaꞌtuꞌ tsonn yuꞌu lágaꞌdauꞌ, tu quiuꞌ, yetú queëꞌ Moisés, len yetú queëꞌ Elías. Cutu nöznëꞌ Pedro bi naꞌ rnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsal niꞌ ruꞌë didzaꞌ ni, laꞌ gröꞌtë böaj bucachiꞌ lequëꞌ, atiꞌ gládxinëꞌ le nacuꞌë lu böaj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Niꞌr byön chiꞌi Nu ruiꞌ didzaꞌ lu böaj naꞌ, rna: ―Bönniꞌ ni naquëꞌ Zxiꞌnaꞌ. Nadxiꞌidaꞌ Lëꞌ. Gul‑zë́ nagliꞌ didzaꞌ guꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Catiꞌ budx bëꞌ didzaꞌ chiꞌi naꞌ, tuzëꞌ Jesús nagáꞌnlenëꞌ lequëꞌ. Taꞌcuáꞌ dxiëꞌ bönniꞌ usë́d queëꞌ, atiꞌ dza naꞌ nutu nu glëꞌ ca nac le gulaléꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Catiꞌ zaꞌ reníꞌ yetú dza guluhuötjëꞌ lu guíꞌadauꞌ naꞌ Jesús len bönniꞌ naꞌ dzagquëꞌ Lëꞌ, atiꞌ gularúj bunách zian dutsaggac Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Niꞌr bëꞌë zidzj didzaꞌ tu bönniꞌ nutsëꞌë ladj bunách zian naꞌ. Bulidzëꞌ Jesús, rnëꞌ: ―Bönniꞌ Usëdi, rátaꞌyuaꞌ lauꞌ duyúꞌ‑biꞌ biꞌi bönniꞌ quiaꞌ le nacbiꞌ biꞌi tuticz quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuꞌu lëbiꞌ böꞌ xöhuiꞌ run ga rbö́dxyaꞌabiꞌ len ruxiztsca lëbiꞌ. Run ga rbia bdxinaꞌ zidiꞌ rúꞌabiꞌ len ruríx rutultsca lëbiꞌ, len gatga rusán lëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gútaꞌyuaꞌ lauquëꞌ bönniꞌ usë́d quiuꞌ lubijëꞌ lei, san cutu gulazáquiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Lbiꞌiliꞌ, curéjlëꞌliꞌ len nachixi icjliꞌ. ¿Gácaꞌxtë ral‑laꞌ sóalenaꞌ lbiꞌiliꞌ len guaꞌ glenaꞌ queëliꞌ? Djuaꞌ‑biꞌ ni biꞌi bönniꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Catiꞌ niꞌ zaꞌbiꞌ rbígaꞌbiꞌ ga naꞌ zoëꞌ Jesús, brix butultsca lëbiꞌ böꞌ xöhuiꞌ naꞌ, atiꞌ gdil‑lëꞌ böꞌ xöhuiꞌ naꞌ Jesús len bunëꞌ‑biꞌ biꞌi bönniꞌ naꞌ. Niꞌr buguꞌë‑biꞌ lu nëꞌë xuzbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Gulubani yúguꞌtë bunách niꞌ ca nac yöl‑laꞌ huac zxön queëꞌ Dios. Tsal niꞌ tuꞌbani yúguꞌtë bunách ca nac le zxön runëꞌ Jesús, Lëꞌ gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","rnëꞌ: ―Gul‑cúꞌu icj nagliꞌ didzaꞌ ni, le ziꞌa ludödëꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lu naꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cutu gulayéjniꞌnëꞌ didzaꞌ ni bönniꞌ usë́d queëꞌ, le cutu ruiꞌnëꞌ lequëꞌ latj Dios laꞌyéjniꞌnëꞌ, san cutu gulurúguinëꞌ laꞌnabnëꞌ Jesús ca nac didzaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Niꞌr gulazú lauquëꞌ tunëꞌ rusbö́ bönniꞌ usë́d queëꞌ Jesús. Taꞌnabi lzaꞌquëꞌ tuëꞌ yetúëꞌ núzxalëꞌ gaquëꞌ blau. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ráquibeꞌinëꞌ Jesús le taꞌzáꞌ ládxiꞌquëꞌ, atiꞌ gdel‑lëꞌë‑biꞌ tubiꞌ biꞌidauꞌ, len buzóëꞌ‑biꞌ cuitiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Niꞌr rëꞌ lequëꞌ: ―Nútiꞌtëz bönniꞌ gunëꞌ ba laꞌn tu biꞌidauꞌ cni le náquibiꞌ quiaꞌ, nédaꞌczaꞌ gunëꞌ ba laꞌn, atiꞌ nu bönniꞌ gunëꞌ nedaꞌ ba laꞌn, gunëꞌ caꞌ ba laꞌn Xuzaꞌ nasölëꞌë nedaꞌ. Qui lë ni naꞌ bönniꞌ nutsëꞌë ladjliꞌ nacrëꞌ nöxj ladxiꞌ, bönniꞌ ni naquëꞌ blau. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Niꞌr bulidzëꞌ Jesús Juan, rnëꞌ: ―Bönniꞌ Usëdi, bléꞌituꞌ‑nëꞌ bönniꞌ rugunëꞌ dxin lauꞌ rubijëꞌ böꞌ xöhuiꞌ, atiꞌ gna béꞌituꞌ‑nëꞌ le cutu dëꞌë rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús rëꞌ lëꞌ: ―Cutu gna béꞌiliꞌ‑nëꞌ, le raclen rëꞌu nu curdáꞌbagaꞌ rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Catiꞌ chzaꞌ gal‑laꞌ dza ral‑laꞌ gatiëꞌ Jesús len huëpëꞌ yehuaꞌ yubá, benëꞌ bayúdx tsijëꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bsölëꞌë yuguꞌ bönniꞌ gbaz queëꞌ laꞌnörëꞌ ca Lëꞌ, atiꞌ yjaquëꞌ tu yödzdauꞌ quegac bunách Samaria tsajpaꞌquëꞌ ga ugaꞌnëꞌ tu dzöꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Cutu glunëꞌ Jesús ba laꞌn bönniꞌ yödz naꞌ le chnac queëꞌ Jerusalén zijëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Catiꞌ gulaléꞌinëꞌ lë ni Jacobo len Juan, bönniꞌ usë́d queëꞌ, tëꞌ Jesús: ―Xan, ¿naruꞌ gnábtscaꞌtuꞌ huötj guiꞌ zaꞌ yehuaꞌ yubá le usnít lequëꞌ, guntuꞌ ca naꞌ benëꞌ Elías? ");
INSERT INTO zsrNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bueycjëꞌ Jesús len gdil‑lëꞌ lequëꞌ, rnëꞌ: ―Cutu nö́ziliꞌ bizxa böꞌ dzag lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bidaꞌ ni nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, clëg quië usnitiaꞌ yöl‑laꞌ naꞌbán quegac bunách, san bidaꞌ dusláꞌ bunách. Niꞌr yjaquëꞌ yödz yubl. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tsal niꞌ yuꞌuquëꞌ nöz Jesús len bönniꞌ daꞌquëꞌ Lëꞌ, bdxinëꞌ niꞌ tu bönniꞌ, len rëꞌ Jesús: ―Xan, rëꞌndaꞌ sáꞌlenaꞌ Liꞌ gátiꞌtëz ga tsijuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús rëꞌ lëꞌ: ―Yuguꞌ bözaꞌ, nacuáꞌ zxan guiöj quecbaꞌ, atiꞌ yuguꞌ bguindauꞌ, dxiagac lidxcbaꞌ, san nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, cutu dë quiaꞌ ga gataꞌ uzíꞌ ladxaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Niꞌr gudxëꞌ bönniꞌ yubl Jesús, rnëꞌ: ―Gdaꞌ nedaꞌ. Bönniꞌ ni gudxëꞌ Lëꞌ: ―Xan, benn nedaꞌ latj huöjaꞌ ziꞌal lidxaꞌ ga gdxinr dza chbucachaꞌa‑nëꞌ xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús gudxëꞌ lëꞌ: ―Bëꞌ latj bönniꞌ chzoa latiëꞌ lucachëꞌë nup chnat quequëꞌ, san liꞌ, gyeaj, yjen lban ca gna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Niꞌr bdxinëꞌ yetúëꞌ caꞌ, rëꞌ Jesús: ―Xan, rëꞌndaꞌ sáꞌlenaꞌ Liꞌ, san benn nedaꞌ latj tsijaꞌ ziꞌal tsajzéygacdaꞌ‑nëꞌ didzaꞌ diꞌa dza quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús gudxëꞌ lëꞌ: ―Nútiꞌtëz bönniꞌ ruiꞌ ladxëꞌë le rac yödzlyú naquëꞌ ca bönniꞌ rugaꞌnëꞌ‑baꞌ bëdx len ruyúëꞌ zacaꞌ cúdzuꞌlëꞌ. Nu run cni cutu nac lsacaꞌ tsaz ga rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gdöd glac lë ni, gröëꞌ Xanruꞌ yetsonnlalj yu chiëꞌ caꞌ bönniꞌ usë́d queëꞌ, atiꞌ bsölëꞌë lequëꞌ chop hueajquëꞌ laꞌnörëꞌ ca Lëꞌ tsjaquëꞌ yúguꞌtë yödz len yödzdauꞌ gap chzoa tödëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gudxëꞌ lequëꞌ: ―Le nactë, dëtsca dxin quiaꞌ, le nac ca tu laꞌ yël zxön ga nu tsajchíb, san nabábz huen dxin quiaꞌ. Qui lë ni naꞌ, gul‑gátaꞌyu lahuëꞌ Dios, naquëꞌ Xan laꞌ yël naꞌ, gsölëꞌë yuguꞌ huen dxin ga nac laꞌ yël queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gul‑tséaj naꞌa. Gul‑yutscaꞌ, nedaꞌ rsölaꞌa lbiꞌiliꞌ, nacliꞌ ca böꞌcuꞌ zxilaꞌ zjacbaꞌ ladjcbaꞌ böꞌcuꞌ zugaꞌ sniaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Cutu guaꞌliꞌ yöxj dumí ni bzud yöt, len cutu guaꞌliꞌ yetú cöꞌ löl‑liꞌ, len cutu tseyliꞌ güíꞌlenliꞌ bunách didzaꞌ gap nac laꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gátiꞌtëz yuꞌu ga tsazliꞌ, ziꞌal gnaliꞌ: “Le rbequi dxi ladxiꞌ gac quegac bunách nacuáꞌ yuꞌu ni.” ");
INSERT INTO zsrNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chquiꞌ zoa niꞌ nu bönniꞌ röꞌ dxi ladxëꞌë, ugaꞌnlen lëꞌ le rbequi dxi ladxiꞌ naꞌ gnabliꞌ, san chquiꞌ cuzóa niꞌ nu bönniꞌ cni, ugaꞌnlen lbiꞌiliꞌ le rbequi dxi ladxiꞌ naꞌ gnabliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gul‑gáꞌn yuꞌu ga naꞌ tsazliꞌ len gul‑guíꞌaj gul‑gagu bi lunnëꞌ queëliꞌ, le udzölcznëꞌ bönniꞌ huen dxin le gahuëꞌ. Cutu tödliꞌ yuꞌu yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gátiꞌtëz yödz ga tsazliꞌ atiꞌ lun lbiꞌiliꞌ ba laꞌn, gul‑gagu le lucuꞌë lauliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gul‑ún nup teꞌi nacuáꞌ yödz naꞌ, len gul‑guië́ lequëꞌ: “Chbdxin ga zoaliꞌ le rna bëꞌë Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gátiꞌtëz yödz ga tsazliꞌ, chquiꞌ cutu lun lbiꞌiliꞌ ba laꞌn, gul‑rúj tsajsoaliꞌ laꞌ nöz qui yödz naꞌ, gnaliꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bëchtö qui ladzliꞌ daꞌ lalabtuꞌ ruquindjtuꞌ lei, le ruluíꞌ nabágaꞌliꞌ zxguiaꞌ, san ral‑laꞌ gnö́ziliꞌ lë ni, chbdxin ga zoaliꞌ le rna bëꞌë Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nedaꞌ rëpaꞌ lbiꞌiliꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, laꞌzacaꞌ laꞌguíꞌir bunách yödz niꞌ ca laꞌzacaꞌ laꞌguíꞌi bunách yödz Sodoma, nup niꞌ busnitiëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gnëꞌ caꞌ Jesús: ―Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bunách yödz Corazín. Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bunách yödz Betsaida. Laꞌnaruꞌ glac lu yödz Tiro len lu yödz Sidón yuguꞌ yöl‑laꞌ huac rubani ca yuguꞌ le benaꞌ ga zoaliꞌ, dza niꞌtë lubíꞌi ládxiꞌquëꞌ bönniꞌ niꞌ, lacuëꞌ lariꞌ caꞌz len laꞌguꞌë dö cuinquëꞌ, le uluíꞌ chgulubíꞌi ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Qui lë ni naꞌ, catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách, sacaꞌ quiꞌrliꞌ ca laꞌzacaꞌ laꞌguiꞌë bönniꞌ Tiro len Sidón. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lbiꞌiliꞌ, bunách Capernaum. ¿Naruꞌ cugúc queëliꞌ ca gyëpliꞌ ga nu ryaz yehuaꞌ yubá? Huötjliꞌ tsajtsazliꞌ latj chul quegac nup natgac. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Niꞌr gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Nu ruzë́ nag lbiꞌiliꞌ, ruzë́ nag caꞌ nedaꞌ, atiꞌ nu rucáꞌn lbiꞌiliꞌ caꞌz, rucáꞌn caꞌ nedaꞌ caꞌz, len nu rucáꞌn nedaꞌ caꞌz, rucáꞌn caꞌ caꞌz Xuzaꞌ, nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Catiꞌ guludxinëꞌ ga zoëꞌ Jesús tsonnlalj yu chiëꞌ bönniꞌ naꞌ bsölëꞌë Lëꞌ, yjenquëꞌ lban, taꞌnë́ꞌ: ―Xan, tun ca rnatuꞌ böꞌ xöhuiꞌ catiꞌ ruguntuꞌ dxin lauꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús gudxëꞌ lequëꞌ: ―Nedaꞌ bléꞌidaꞌ Satanás tuꞌ xöhuiꞌ, gbix zxan luzxbá ca run yös, ryaz luyú. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gul‑yutscaꞌ, nedaꞌ nudödaꞌ lu naꞌliꞌ yöl‑laꞌ uná bëꞌ söncliꞌ‑baꞌ bël sniaꞌ len xajnö́ꞌ atiꞌ cutu bi gac queëliꞌ, atiꞌ uxicjliꞌ lu yöl‑laꞌ uná bëꞌ qui tuꞌ xöhuiꞌ, nu curleꞌi rëꞌu dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naꞌa, gul‑dziji, clëgz le tun ca rnaliꞌ böꞌ xöhuiꞌ, san le nayujgac laliꞌ lu guich niꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Laꞌ niꞌz rudzijnëꞌ Jesús, dzaguëꞌ Lëꞌ Dios Böꞌ Laꞌy, rnëꞌ: ―Rguꞌa Liꞌ yöl‑laꞌ ba, Xuzaꞌ, nacuꞌ Xani yehuaꞌ yubá len Xani luyú ni, le bucachuꞌu yuguꞌ lë ni lauquëꞌ bönniꞌ tac szxöni len bönniꞌ taꞌyejniꞌi, san buluiꞌicnuꞌ‑biꞌ biꞌidauꞌ ca nac. Caꞌ gac, Xuzaꞌ, le cni bdzag ladxuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Niꞌr gnëꞌ: ―Yúguꞌtë budödëꞌ lu naꞌa Xuzaꞌ. Nutu nu bönniꞌ nöznëꞌ Nu naquëꞌ Zxiꞌnëꞌ Dios, san tuzëꞌ Dios Xuz nöznëꞌ, atiꞌ nutu nu nözi Nu naquëꞌ Dios Xuz, san tuzëꞌ Zxiꞌnëꞌ nöznëꞌ, atiꞌ gnö́zigac caꞌ nup naꞌ Zxiꞌnëꞌ rëꞌnnëꞌ uluiꞌinëꞌ lequëꞌ Xuzëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Niꞌr buyúëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús len rëꞌ lequëꞌ: ―Bicaꞌ bagac nup taꞌleꞌi le rléꞌiliꞌ lbiꞌiliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","le rëpaꞌ lbiꞌiliꞌ: Glëꞌnnëꞌ laꞌléꞌinëꞌ le rléꞌiliꞌ zian bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios len bönniꞌ gulaná bëꞌë, san cutu gulaléꞌinëꞌ lei. Glëꞌnnëꞌ laꞌyönnëꞌ le ryö́niliꞌ, san cutu gulayönnëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Niꞌr gyasëꞌ bönniꞌ gdauꞌ usëdi, len quië siꞌ bëꞌë Jesús, gnabnëꞌ Lëꞌ, rnëꞌ: ―Bönniꞌ Usëdi, ¿bizxa ral‑laꞌ gunaꞌ quië gdél‑liꞌdaꞌ yöl‑laꞌ naꞌbán gdu? ");
INSERT INTO zsrNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús rëꞌ lëꞌ: ―¿Bizxa caz nayúj lu guich lu zxba queëꞌ Moisés? ¿Nacx rusacaꞌ quiuꞌ lë naꞌ rulabuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bubiꞌë didzaꞌ bönniꞌ naꞌ, rnëꞌ: ―Cni rna: Gdxiꞌinuꞌ Xanuꞌ Dios gdu ladxuꞌu, len lu gdu icj ládxiꞌdaꞌu, len lu gdu yöl‑laꞌ run quiuꞌ, len lu gdu yöl‑laꞌ rejniꞌi quiuꞌ, atiꞌ gdxiꞌinuꞌ böchiꞌ lzaꞌu ca nadxíꞌi cuinuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús rëꞌ lëꞌ: ―Dxíꞌadauꞌ bubiꞌu didzaꞌ. Ben cni, atiꞌ gataꞌ quiuꞌ yöl‑laꞌ naꞌbán naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Le guꞌnnëꞌ bönniꞌ naꞌ ubíj dxiꞌa cuinëꞌ, rëꞌ Jesús: ―¿Nuzxa naꞌ böchiꞌ lzaꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Gzëꞌë Jerusalén bönniꞌ, rudinniëꞌ, zijëꞌ yödz Jericó. Laꞌ nöz niꞌ gulazönëꞌ lëꞌ gban. Gulagǘëꞌ lariꞌ nacuëꞌ len glunëꞌ lëꞌ huëꞌ. Niꞌr guluzë́ꞌë niꞌ, nucaꞌnquëꞌ lëꞌ, chratczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Niꞌr gdödëꞌ laꞌ nöz niꞌ bxuz. Catiꞌ bléꞌinëꞌ bönniꞌ huëꞌ naꞌ, tslaꞌl gdödëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Gdödëꞌ caꞌ niꞌ bönniꞌ nababëꞌ zxiꞌn xsoëꞌ Leví, bönniꞌ naꞌ tunëꞌ dxin qui gdauꞌ. Catiꞌ bléꞌinëꞌ lëꞌ, tslaꞌl caꞌ gdödëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lëzcaꞌ yuꞌë nöz naꞌ bönniꞌ Samaria, atiꞌ bdxinëꞌ gal‑laꞌ ga dëꞌ bönniꞌ huëꞌ naꞌ. Catiꞌ bléꞌinëꞌ lëꞌ, buechiꞌ ladxëꞌë lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gbiguëꞌë ga naꞌ dëꞌ, atiꞌ gluꞌë le za len xisi uva nal lu huëꞌ queëꞌ, len buchö́linëꞌ lei lariꞌ. Niꞌr bdxiëꞌ lëꞌ cúdzuꞌbaꞌ böaꞌ queëꞌ len buꞌë lëꞌ yuꞌu ga taꞌdxinëꞌ bönniꞌ yuꞌuquëꞌ nöz, atiꞌ niꞌ ben chiꞌë lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Catiꞌ zaꞌ reníꞌ yetú dza, len chzoa uzë́ꞌë niꞌ bönniꞌ Samaria naꞌ, glijëꞌ lazxjëꞌ qui chop dza, le bucaꞌnëꞌ lu nëꞌë bönniꞌ xan yuꞌu naꞌ, rëꞌ lëꞌ: “Ben chiꞌë bönniꞌ ni, len chquiꞌ utö́uꞌ yelatiꞌ dumí, ubiꞌa quiuꞌ nedaꞌ catiꞌ huödaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naꞌa, ¿nacx runi liꞌ? ¿Núzxalëꞌ bönniꞌ yonn ni guquëꞌ böchiꞌ lzëꞌë bönniꞌ naꞌ gluꞌë döꞌ queëꞌ bönniꞌ gban? ");
INSERT INTO zsrNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bubiꞌë didzaꞌ bönniꞌ gdauꞌ usëdi naꞌ, rëꞌ Jesús: ―Bönniꞌ naꞌ buechiꞌ ladxëꞌë lëꞌ. Niꞌr Jesús gudxëꞌ lëꞌ: ―Gyeaj naꞌa, yjen caꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Niꞌr buꞌë nöz Jesús, bdxinëꞌ tu yödzdauꞌ ga niꞌ bchëꞌnu Lëꞌ lidxnu ngul lënu Marta. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ni zoanu ngul zxilnu lënu María, atiꞌ María naꞌ grö́ꞌtënu ga nac xniꞌë Jesús, ruzë́ nagnu xtidzëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta naꞌ bubi buguiꞌnu, zian dxin runnu, atiꞌ gbígaꞌnu ga naꞌ zoëꞌ Jesús, rënu Lëꞌ: ―Xan, ¿naruꞌ cu ruiꞌ ládxiꞌtsuꞌ nedaꞌ le nucaꞌnbiꞌ nedaꞌ biꞌi zxilaꞌ ni, atiꞌ tuzaꞌ runaꞌ dxin? Gudx‑biꞌ gáclenbiꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bubiꞌë didzaꞌ Jesús, rëꞌ‑nu: ―Marta, Marta, ruúbi ruguíꞌitsquinuꞌ, len zian le ruiꞌ ladxuꞌu runuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tuz le run bayúdx nu gun, atiꞌ María ni gröbiꞌ lë naꞌ nactër dxiꞌa, atiꞌ lë naꞌ gröbiꞌ cutu gdua queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tu dza niꞌ rulidzëꞌ Dios Jesús. Catiꞌ budx bë́ꞌlenëꞌ Dios didzaꞌ, rëꞌ Lëꞌ tuëꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Xan, bsëdi netuꞌ ulidztuꞌ‑nëꞌ Dios güíꞌlentuꞌ‑nëꞌ didzaꞌ, ca benëꞌ Juan, busëdnëꞌ bönniꞌ daꞌquëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Niꞌr Jesús rëꞌ lequëꞌ: ―Catiꞌ ulidzliꞌ‑nëꞌ Dios güíꞌlenliꞌ‑nëꞌ didzaꞌ, gul‑ná: Xuztuꞌ, zuꞌ yehuaꞌ yubá, gac zxön lauꞌ. Gda gna bëꞌu. Luyú ni gac ca rdzag ladxuꞌu Liꞌ, ca naꞌ rac niꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Benn le gágutuꞌ naꞌa dza. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bnit lau netuꞌ dul‑laꞌ nabágaꞌtuꞌ Ca netuꞌ caꞌ runít lautuꞌ nup bi tun queëtuꞌ. Cutu guꞌu latj siꞌ bëꞌ netuꞌ le xöhuiꞌ, San buslá netuꞌ lu naꞌ nu ruaꞌ döꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús rëꞌ caꞌ lequëꞌ: ―Chquiꞌ zoëꞌ bönniꞌ nutsëꞌë ladjliꞌ, len zoëꞌ böchiꞌ lzëꞌë, len chquiꞌ tsijëꞌ ga naꞌ zoëꞌ ladxiꞌ yël, atiꞌ ulidzëꞌ lëꞌ, gnëꞌ: “Böchaꞌa, benn quiaꞌ tsonn yöt xtil ");
INSERT INTO zsrNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","le ziꞌa bdxinëꞌ quiaꞌ böchiꞌ lzaꞌa, zëꞌë ziꞌtuꞌ, san cutu bi dë guꞌa‑nëꞌ gahuëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Naruꞌ ubiꞌë didzaꞌ cni bönniꞌ naꞌ zoëꞌ yuꞌu, guiëꞌ lëꞌ: “Cutu utsaꞌu nedaꞌ. Chnayéyj yuꞌu, atiꞌ chdë́lencbiꞌ nedaꞌ biꞌi quiaꞌ. Cutu gac tsasaꞌ bi gunnaꞌ quiuꞌ”? ");
INSERT INTO zsrNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Zal‑laꞌ cutu tsasëꞌ bi unödzjëꞌ queëꞌ le naquëꞌ böchiꞌ lzëꞌë, san tsasëꞌ len unödzjëꞌ queëꞌ yúguꞌtë le rquinnëꞌ quië cutur upizxjnëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ: Gul‑náb, atiꞌ Dios gunnëꞌ queëliꞌ. Gul‑quílj, atiꞌ gdzöl queëliꞌ. Gul‑lídz raꞌ yuꞌu, atiꞌ tsalj queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nu rnab, rziꞌ qui, atiꞌ nu rguilj, rdzöl qui, atiꞌ nu rulídz raꞌ yuꞌu, ryalj qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Chquiꞌ zoëꞌ bönniꞌ nutsëꞌë ladjliꞌ, naquëꞌ xuz, len chquiꞌ gnábibiꞌ lëꞌ yöt xtil zxiꞌnëꞌ, ¿naruꞌ unödzjtsëꞌ queëbiꞌ guiöj? Chquiꞌ gnábibiꞌ lëꞌ tubaꞌ böl, ¿naruꞌ unödzjtsëꞌ queëbiꞌ bël? ");
INSERT INTO zsrNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chquiꞌ gnábibiꞌ lëꞌ dxit qui börj, ¿naruꞌ unödzjtsëꞌ queëbiꞌ xajnö́ꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Cni nac, chquiꞌ nacliꞌ lbiꞌiliꞌ huiaꞌdöꞌ san nö́ziliꞌ unödzjliꞌ quecbiꞌ zxiꞌnliꞌ le nac dxiꞌa, nactër löz gunnëꞌ queëliꞌ Dios Böꞌ Laꞌy Xuzliꞌ zoëꞌ yehuaꞌ yubá, nul‑liꞌ gnábiliꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tu dza bubijëꞌ böꞌ xöhuiꞌ yuꞌu bönniꞌ Jesús, le run ga curnë́ꞌ. Catiꞌ burúj böꞌ xöhuiꞌ naꞌ, bëꞌë didzaꞌ bönniꞌ naꞌ cugnë́ꞌ, atiꞌ gulubani bunách nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Laꞌgac bunách nacuáꞌ niꞌ taꞌná: ―Len yöl‑laꞌ huac qui tuꞌ xöhuiꞌ Beelzebú, xangac böꞌ xöhuiꞌ, rubijëꞌ yuguꞌ böꞌ xöhuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Glëꞌni laꞌzíꞌ bëꞌ Jesús yelaꞌgac bunách naꞌ, atiꞌ gulanabi Lëꞌ gunëꞌ tu le gac bëꞌ zaꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ráquibeꞌinëꞌ Jesús le taꞌzáꞌ ládxiꞌquëꞌ, atiꞌ rëꞌ lequëꞌ: ―Gátiꞌtëz ga taꞌná beꞌi lzaꞌgac bunách, chquiꞌ laꞌrúj chopl laꞌ leygacz bunách naꞌ, laꞌnít. Chquiꞌ laꞌrúj chopl bunách nacuáꞌ tu yuꞌu, udx quegac. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lëzcaꞌ cni rac qui Satanás, tuꞌ xöhuiꞌ, lëzcaꞌ nazíꞌ lei Beelzebú. Chquiꞌ laꞌrúj chopl nup daꞌgac lei, ¿nacx gac gdiaꞌ yöl‑laꞌ uná bëꞌ qui? ¿Rnátsaliꞌ naꞌa: len yöl‑laꞌ huac qui Beelzebú rubijaꞌ yuguꞌ böꞌ xöhuiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chquiꞌ nedaꞌ, len yöl‑laꞌ huac qui Beelzebú rubijaꞌ yuguꞌ böꞌ xöhuiꞌ, ¿nuzxa runn quegac nup daꞌgac lbiꞌiliꞌ yöl‑laꞌ huac tuꞌbíj yuguꞌ böꞌ xöhuiꞌ? Qui lë ni naꞌ, nup ni nacgac bëꞌ nachíxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Chquiꞌ nedaꞌ, len yöl‑laꞌ huac queëꞌ Dios rubíjgacaꞌ böꞌ xöhuiꞌ, le nactë chbdxin ga zoaliꞌ le rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Catiꞌ dë lu nëꞌë le rneynëꞌ bönniꞌ nal, len run chiꞌë lidxëꞌ, nac chiꞌi dëra le dë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Naꞌa, chquiꞌ zëꞌë yetúëꞌ bönniꞌ náltërëꞌ ca lëꞌ len uxicjëꞌ lëꞌ, niꞌr cuëꞌ yúguꞌtë le rneynëꞌ, lë naꞌ ruzxöni ladxëꞌë, atiꞌ quisiëꞌ le dë queëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Nu curaclen nedaꞌ, rdáꞌbagaꞌ nedaꞌ. Nu curutublen nedaꞌ, ruslás nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Gnëꞌ caꞌ Jesús: ―Catiꞌ r‑ruj lu bönniꞌ böꞌ xöhuiꞌ, rda gap nabídx, rguilj ga uzíꞌ ladxiꞌ. Chquiꞌ cutu gdzöl qui, gna: “Huöjaꞌ xlatjaꞌ ga niꞌ brujaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Catiꞌ rudxín niꞌ, rajxacaꞌ bönniꞌ naꞌ, naquëꞌ ca tu yuꞌu chnulúa len chnabáꞌa quië nu tsajsóa niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Niꞌr reaj len rajxíꞌ yegádx böꞌ xöhuiꞌ, nácgactër xöhuiꞌ ca lei, atiꞌ taꞌyúꞌu bönniꞌ naꞌ. Naꞌa, le rac queëꞌ bönniꞌ naꞌ nayáliꞌtër ca le guc queëꞌ ziꞌal. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tsal niꞌ ruꞌë didzaꞌ ni Jesús, bëꞌnu zidzj didzaꞌ ngul nútsaꞌnu ladj bunách zian naꞌ, rnanu: ―Bicaꞌ ba ngul naꞌ biaꞌnu Liꞌ lëꞌnu, len bicaꞌ ba caꞌ lchuꞌnu ga naꞌ gudxuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bubiꞌë didzaꞌ Jesús, gnëꞌ: ―Nácgactër bicaꞌ ba nup taꞌyöni xtidzëꞌë Dios len tun ca rna. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsal niꞌ taꞌbigaꞌ ga zoëꞌ Jesús bunách zian, gzu lahuëꞌ ruꞌë didzaꞌ, rnëꞌ: ―Taꞌnabi nedaꞌ bunách tuaꞌdöꞌ ni gunaꞌ le gac bëꞌ ga zaꞌ yöl‑laꞌ huac quiaꞌ, san cutu bi le gac bëꞌ laꞌléꞌinëꞌ. Tuz le gac bëꞌ ca naꞌ guc queëꞌ Jonás laꞌléꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ca naꞌ guc queëꞌ Jonás, guquëꞌ tu le nac bëꞌ laugac bunách yödz Nínive, lëzcaꞌ cni gac quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, gacaꞌ tu le gac bëꞌ laugac bunách dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Catiꞌ gdxin dza gchuguëꞌ Dios quegac bunách len cuequi xbeynëꞌ bunách dza ni zoaruꞌ naꞌa, Dios uchisëꞌ‑nu ngul dza niꞌtë gna béꞌinu bunách luyú niꞌ dë tslaꞌa ga rdöd gbidz beoꞌ ziag, atiꞌ le bennu uluíꞌ nabágaꞌgac bunách ni zxguiaꞌ, le bidnu lënu, brujnu ga nac ziꞌtuꞌ quië duzë́ nagnu didzaꞌ rejniꞌi bëꞌë Salomón, bönniꞌ gna béꞌinëꞌ bunách Israel, san naꞌa, zoaꞌ ni nedaꞌ, len náctëraꞌ blau ca Salomón naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lëzcaꞌ cni, Dios uchisëꞌ bönniꞌ gulacuꞌë yödz Nínive catiꞌ gdxin dza gchugu bëꞌë quegac bunách len cuequi xbeynëꞌ bunách dza ni zoaruꞌ naꞌa, atiꞌ le glunëꞌ uluíꞌ nabágaꞌgac bunách ni zxguiaꞌ, le gulubíꞌi ládxiꞌquëꞌ bönniꞌ Nínive catiꞌ gulayönnëꞌ lban benëꞌ Jonás, atiꞌ naꞌa zoaꞌ ni nedaꞌ, len náctëraꞌ blau ca Jonás naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gnëꞌ caꞌ Jesús: ―Catiꞌ nu ruquel‑laꞌ guiꞌ, cutu rguꞌu lei ga nagachiꞌ, len cutu rudusiꞌ lei guiꞌn, san ruzóa lei xtsaꞌ ga lnaꞌ, quië uzeníꞌ quegac nup taꞌyáz yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yöj lauruꞌ nac ca tu le rguꞌu yeníꞌ lu icj ládxiꞌdauꞌruꞌ. Chquiꞌ yöj lauꞌ nac dxiꞌa, gduteoꞌ yudz le nac yeníꞌ, san chquiꞌ nac xöhuiꞌ yöj lauꞌ, gduteoꞌ yudz le nac chul xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ben chiꞌi cuinuꞌ naꞌa, cui huöac chul lë naꞌ rguꞌu yeníꞌ lu icj ládxiꞌdaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Cni nac, chquiꞌ gduteoꞌ nadzë́ꞌiznuꞌ le nac yeníꞌ len cutu bi zoalen liꞌ le chul xöhuiꞌ, yúguꞌtë gléꞌinuꞌ dxiꞌa ca rac catiꞌ ruzeníꞌ quiuꞌ guiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Catiꞌ budx bëꞌë didzaꞌ ni Jesús, bulidzëꞌ Lëꞌ tsajtágulenëꞌ lëꞌ bönniꞌ gdauꞌ fariseo. Catiꞌ gyaziëꞌ Jesús lidxëꞌ bönniꞌ gdauꞌ naꞌ, gröꞌë rahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Catiꞌ bléꞌinëꞌ Lëꞌ bönniꞌ gdauꞌ fariseo naꞌ, bubannëꞌ le cutu gdib nëꞌë Jesús catiꞌ ziꞌa gahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Xanruꞌ rëꞌ lëꞌ: ―Lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, rguib cuinliꞌ ca rguibliꞌ láhuilgac le riꞌiji ráhuiliꞌ, san lu icj ládxiꞌdauꞌliꞌ ruhuídiꞌliꞌ len rzaꞌ ládxiꞌliꞌ le cunác. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lbiꞌiliꞌ, bönniꞌ curéjniꞌliꞌ. ¿Naruꞌ cu nö́ziliꞌ, Nu ben le zoa lahuiz ben caꞌ le yuꞌu lëꞌil? ");
INSERT INTO zsrNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Naꞌa, gul‑gún gun le dë queëliꞌ, atiꞌ niꞌr huöac dxiꞌa yúguꞌtë le dë queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo. Rguizxjliꞌ qui gdauꞌ tu cuia tsa tu chi cuia le rziꞌliꞌ qui xhueaj, len qui guixiꞌ rud, len quegac guixiꞌ cuandauꞌ, san rudödzliꞌ le nac tsahuiꞌ len yöl‑laꞌ nadxíꞌi queëliꞌ Dios. Yuguꞌ lë ni run bayúdx gunliꞌ, len cutu ucaꞌnliꞌ yezícaꞌ lë naꞌ runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo. Rë́ꞌniliꞌ cöꞌliꞌ gap nac blau lu yuꞌu ga rudubliꞌ rusëdliꞌ queëꞌ Dios len rë́ꞌniliꞌ lulídz lbiꞌiliꞌ ba zxön bunách gap nac lahuiꞌ laugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi, lencaꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ fariseo, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ, le nacliꞌ ca nacgac yeru ba quegac nup natgac le cunalaꞌgac, atiꞌ taꞌdá láhuigac yeru ba naꞌ bunách len cutu táquibeꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Niꞌr bubiꞌë didzaꞌ bönniꞌ gdauꞌ usëdi raquëꞌ zxba queëꞌ Moisés, rëꞌ Jesús: ―Bönniꞌ Usëdi, catiꞌ rnauꞌ cni, netuꞌ caꞌ runuꞌ ziꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús rëꞌ lëꞌ: ―Bicaꞌ bayechiꞌ caꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi racliꞌ zxba queëꞌ Moisés, le ruspágaꞌcliꞌ bunách yuaꞌ ziꞌi le cugác nu guaꞌ, san lbiꞌiliꞌ ni latiꞌz cutu ruláhuiꞌliꞌ lei len naꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, le rchisliꞌ lguitj qui ba ga nagáchiꞌquëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, bönniꞌ niꞌ guludöddëꞌ lequëꞌ xuz xtauꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cni nac, runliꞌ lnaꞌ lau runliꞌ tuz le glunëꞌ xuz xtauꞌliꞌ le guludödcdëꞌ lequëꞌ xuz xtauꞌliꞌ naꞌ, atiꞌ lbiꞌiliꞌ rchisliꞌ lguitj qui ba ga nagáchiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Qui lë ni naꞌ, lu yöl‑laꞌ rejniꞌi queëꞌ, Dios gnëꞌ cni: “Gsölaꞌa quequëꞌ bönniꞌ luꞌë didzaꞌ uláz quiaꞌ len yuguꞌ bönniꞌ gbaz quiaꞌ, atiꞌ yuguꞌ bönniꞌ ni, laꞌquëꞌ ludödcdëꞌ, len yelaꞌquëꞌ laꞌbía ládxiꞌquëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cni gunëꞌ Dios le cuequi xbeynëꞌ bunách dza ni zoaruꞌ naꞌa, niꞌa qui rön quegac yúguꞌtë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ, bönniꞌ niꞌ guludödi lequëꞌ bunách catiꞌ gzu lau ziꞌa rataꞌ yödzlyú ");
INSERT INTO zsrNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ga gzu lau nu budödi Abel, ga bdxintë guludöddëꞌ Zacarías, bönniꞌ naꞌ guludöddëꞌ gatsj lahuiꞌl ga dë bcugu laꞌy ga naꞌ tuꞌzéguiꞌquëꞌ‑baꞌ böaꞌ bëdxdauꞌ lahuëꞌ Dios len ga zoa latj laꞌy. Qui lë ni naꞌ, rëpaꞌ lbiꞌiliꞌ, Dios cuequi xbeynëꞌ bunách dza ni zoaruꞌ naꞌa, niꞌa qui rön quegac yúguꞌtë bönniꞌ naꞌ guludödcdëꞌ lequëꞌ xuz xtauꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Bicaꞌ bayechiꞌ lbiꞌiliꞌ, bönniꞌ gdauꞌ usëdi, racliꞌ zxba queëꞌ Moisés. Laꞌ lbiꞌizliꞌ dë lu naꞌliꞌ zxiꞌn guia qui latj ga rdzö́liruꞌ yöl‑laꞌ rejniꞌi. Lbiꞌiliꞌ cutu ryazliꞌ, atiꞌ ruzágaꞌliꞌ xnözgac nup tëꞌni laꞌyáz. ");
INSERT INTO zsrNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Catiꞌ budx bë́ꞌlenëꞌ lequëꞌ didzaꞌ ni Jesús, gulaléytsquinëꞌ Lëꞌ bönniꞌ gdauꞌ tuꞌsëdi len yuguꞌ bönniꞌ gdauꞌ fariseo, atiꞌ gulazú lauquëꞌ taꞌnabi yúdxtsquinëꞌ Lëꞌ ca nac zian le tac, ");
INSERT INTO zsrNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","le tuꞌbijëꞌ Lëꞌ didzaꞌ quië gac luquíëꞌ Lëꞌ niꞌa qui didzaꞌ ubiꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Laꞌ dza naꞌz guludúb ga zoëꞌ Jesús zian gayuáꞌ bunách ga bdxintë taꞌröliz lzaꞌgac bunách naꞌ. Niꞌr gzu lahuëꞌ Jesús rëꞌ ziꞌal yuguꞌ bönniꞌ usë́d queëꞌ, rnëꞌ: ―Gul‑gún chiꞌi cuinliꞌ qui le nac ca xnëꞌi yöt xtil quequëꞌ bönniꞌ gdauꞌ fariseo, le nac yöl‑laꞌ ruluíꞌz tsahuiꞌ cuini quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Cutu bi dë le nac landauꞌz le cugláꞌ lahui, len cutu bi dë le nagachiꞌ le cugác bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qui lë ni naꞌ, yúguꞌtë le chgnaliꞌ ga nac chul, laꞌyöni lei bunách ga nac lu yeníꞌ, atiꞌ didzaꞌ bëꞌliꞌ bagachiꞌz ga gzoa lu yuꞌu nayéyj, gac lban qui ga nac lahuiꞌ laugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Gnëꞌ caꞌ Jesús: ―Bö́chaꞌadauꞌ, rëpaꞌ lbiꞌiliꞌ: Cutu gádxiliꞌ bönniꞌ tuꞌdödcdëꞌ bunách, atiꞌ töd naꞌ cutur bi gac lunëꞌ quegac. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Uluiꞌidaꞌ lbiꞌiliꞌ nu ral‑laꞌ gádxiliꞌ. Gul‑gadxi Nu naꞌ gac ugúa yöl‑laꞌ naꞌbán queëliꞌ, len töd naꞌ dë lu nëꞌë yöl‑laꞌ uná bëꞌ chuꞌnëꞌ lbiꞌiliꞌ lu guiꞌ gabíl. Ja, rëpaꞌ lbiꞌiliꞌ, gul‑gadxi Nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Naruꞌ cu tútiꞌquëꞌ‑baꞌ gáyuꞌbaꞌ bguindauꞌ len chop dumí lasdauꞌ? Nitubaꞌ lecbaꞌ, cutu ral ladxëꞌë‑baꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lëzcaꞌ cni, yúguꞌtë guitsaꞌ icjliꞌ nababgac lahuëꞌ Dios. Qui lë ni naꞌ, cutu gádxiliꞌ. Nazácaꞌtërliꞌ lbiꞌiliꞌ ca zianbaꞌ bguindauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gnëꞌ caꞌ Jesús: ―Rëpaꞌ lbiꞌiliꞌ: Yúguꞌtë bönniꞌ taꞌnë́ꞌ náquicnëꞌ quiaꞌ nedaꞌ laugac bunách, lëzcaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, gniaꞌ náquicnëꞌ quiaꞌ lauquëꞌ gbaz laꞌy queëꞌ Dios, ");
INSERT INTO zsrNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","atiꞌ bönniꞌ taꞌdáꞌbaguëꞌë náquicnëꞌ quiaꞌ laugac bunách, lëzcaꞌ nedaꞌ táꞌbagaꞌa náquicnëꞌ quiaꞌ lauquëꞌ gbaz laꞌy queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Yúguꞌtë nup bi laꞌnë́ quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, gac unít lahuëꞌ leygac Dios, san nu gnë ziꞌ queëꞌ Dios Böꞌ Laꞌy, cutu unít lahuëꞌ nu naꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Catiꞌ laꞌchë́ꞌë lbiꞌiliꞌ gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, len lauquëꞌ bönniꞌ laꞌbequi xbeynëꞌ lbiꞌiliꞌ, len lauquëꞌ bönniꞌ dë lu naꞌquëꞌ, cutu ubi uguiꞌiliꞌ nacx gunliꞌ o bizxa didzaꞌ ubiꞌiliꞌ, o bizxa gnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Laꞌ dza naꞌz usëdnëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy le ral‑laꞌ gnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Rëꞌ Jesús bönniꞌ nutsëꞌë ladj bunách zian naꞌ, rnëꞌ: ―Bönniꞌ Usëdi, gudxëꞌ böchaꞌa gunnëꞌ uláz quiaꞌ le gutaꞌ queëꞌ xuztuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús rëꞌ lëꞌ: ―Bönniꞌ. ¿Naruꞌ zoa nu buzóa nedaꞌ ca nu cuequi xbey lbiꞌiliꞌ, o nu gun gatsj le dë queëliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Niꞌr gudxëꞌ bunách nacuáꞌ niꞌ Jesús, rnëꞌ: ―Gul‑yutscaꞌ. Gul‑gún chiꞌi cuinliꞌ cui uhuídiꞌliꞌ. Le uziꞌë xbey bönniꞌ cutu nacz le zian le dë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Niꞌr bë́ꞌlenëꞌ lequëꞌ didzaꞌ Jesús, benëꞌ lsaquiꞌ, rnëꞌ: ―Zoëꞌ bönniꞌ rléꞌinëꞌ yöl‑laꞌ tsahuiꞌ queëꞌ, atiꞌ szxöni runö́dzj glap lu xyuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Niꞌr gzaꞌ ladxëꞌë bönniꞌ naꞌ, rnëꞌ: “¿Nacx guntsaꞌ? Cutu dë ga gun chiꞌa le ruláꞌ quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Niꞌr rnëꞌ: “Cni gunaꞌ. Uquindjcaꞌ yuꞌu ga run chiꞌa le ruláꞌ quiaꞌ, atiꞌ gunaꞌ yuguꞌ yuꞌu zxöntër caꞌ, atiꞌ niꞌ gun chiꞌa le ruláꞌ quiaꞌ len yuguꞌ le dë quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Niꞌr gac guië cuinaꞌ: Chdëtsca quiaꞌ zian le chnutubaꞌ, le gáhuidaꞌ zian iz. Uziꞌtsca ladxaꞌa. Guiꞌj gahuaꞌ, len udzijdaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Niꞌr Dios rëꞌ lëꞌ: “Liꞌ, bönniꞌ cunözi. Naꞌa dzöꞌ gatiuꞌ. Naꞌa, ¿nuzxa caz gaqui qui, lë naꞌ chnutubuꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cni rac queëꞌ bönniꞌ rutubëꞌ laꞌ queëzëꞌ yöl‑laꞌ tsahuiꞌ, len cutu runëꞌ le nac ca yöl‑laꞌ tsahuiꞌ lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gdöd niꞌ gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ: Cutu ubi uguiꞌiliꞌ niꞌa qui le guiꞌj gáguliꞌ, lë naꞌ nabániliꞌ, o niꞌa qui lariꞌ gáculiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nacr lsacaꞌ yöl‑laꞌ naꞌbán queëliꞌ ca le ráguliꞌ, atiꞌ nacr lsacaꞌ gdu ca nayáꞌ nabinliꞌ ca lariꞌ ráculiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gul‑yutëz ca rac quecbaꞌ beycj. Cutu tazbaꞌ, len cutu taꞌlapbaꞌ, len cutu nacuáꞌ quecbaꞌ ga lun chiꞌibaꞌ le ruláꞌ quecbaꞌ, san Dios rugahuëꞌ lecbaꞌ. ¿Naruꞌ cu nazácaꞌtërliꞌ lbiꞌiliꞌ ca yuguꞌ bguindauꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Nuzxa caz bönniꞌ nutsëꞌë ladjliꞌ gac gunëꞌ ga soëꞌ gbanëꞌ yetú chiꞌiꞌdauꞌz le ruúbi ruguíꞌi ládxiꞌdauꞌhuëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Qui lë ni naꞌ, chquiꞌ cugác gunliꞌ lë ni nac cuidiꞌz, ¿bizx quië ruúbi ruguiꞌiliꞌ niꞌa qui le nac zxöntër? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Gul‑yutëz ca taꞌzxö́n yöjdauꞌ. Cutu tun du lariꞌ len cutu tab lariꞌ, san rëpaꞌ lbiꞌiliꞌ, cutu gucr lach ca nacgac yöjdauꞌ ni lariꞌ gucuëꞌ Salomón, zal‑laꞌ szxöni gutaꞌ queëꞌ yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chquiꞌ runëꞌ lach Dios yuguꞌ yöj guíxiꞌdauꞌ röꞌgac naꞌa ladj guixiꞌ, atiꞌ cxö huidzj laꞌguꞌë leygac lu guiꞌ, ¿naruꞌ cu gunëꞌ queëliꞌ le zxöntër caꞌ, lbiꞌiliꞌ, curéjlëꞌliꞌ Dios gdu ládxiꞌliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Qui lë ni naꞌ, cutu güiꞌ ládxiꞌliꞌ le ral‑laꞌ gáguliꞌ, len le ral‑laꞌ guiꞌjliꞌ, len cutu ubi uguíꞌi ládxiꞌdauꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yúguꞌtë lë ni taꞌguílj bunách yödzlyú ni, san chnözcznëꞌ Xuzliꞌ Dios yuguꞌ le rquíniliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Gul‑güíꞌ ládxiꞌliꞌ tsazliꞌ ga rna bëꞌë Dios, atiꞌ yúguꞌtë lë ni cuꞌë xnöz queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Gnëꞌ caꞌ Jesús: ―Cutu gádxiliꞌ, lbiꞌiliꞌ naꞌ nacliꞌ yuguꞌ böꞌcuꞌ zxílaꞌdauꞌ quiaꞌ. Nababzliꞌ zoaliꞌ san rdzag ladxëꞌë Xuzliꞌ Dios gunnëꞌ lbiꞌiliꞌ latj tsazliꞌ ga niꞌ rna bëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gul‑gutiꞌ le dë queëliꞌ len gul‑nö́dzj quegac bunách yechiꞌ. Cni gac, gunliꞌ queëliꞌ yöxj dumí le cutu gac ditj, len cuꞌliꞌ yehuaꞌ yubá yöl‑laꞌ tsahuiꞌ naꞌ cutu ubídx udú, ga niꞌ cutu gdxin gban len cutu usnitbaꞌ lei böaꞌdauꞌ qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ga niꞌ dë yöl‑laꞌ tsahuiꞌ queëliꞌ, niꞌ güiꞌ ládxiꞌliꞌ gdxinliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Gnëꞌ caꞌ Jesús: ―Gul‑zóa sinaꞌ len gul‑quel‑laꞌ guiꞌ le uzeníꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gul‑gác ca bönniꞌ huen dxin taꞌbözëꞌ dza huödëꞌ xanquëꞌ, bönniꞌ zijëꞌ lni qui yöl‑laꞌ rutság naꞌ, quië catiꞌ udxinëꞌ len ulidzëꞌ, laꞌ laꞌsaljtëꞌ queëꞌ tsaziëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bicaꞌ bagac huen dxin naꞌ laꞌcuꞌë ban ladxiꞌ catiꞌ huödëꞌ xanquëꞌ. Le nactë rëpaꞌ lbiꞌiliꞌ, upáꞌ cuinëꞌ xanquëꞌ naꞌ, atiꞌ gunëꞌ ga laꞌböꞌë ga lahuëꞌ, atiꞌ cuꞌë le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zal‑laꞌ huödëꞌ catiꞌ chral o gdu ladxiꞌ yël, chquiꞌ duxaquëꞌ lequëꞌ nacuꞌë ban ladxiꞌ, bicaꞌ bagac huen dxin naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lë ni ral‑laꞌ gnö́ziliꞌ. Laꞌnaruꞌ nöznëꞌ xan yuꞌu bizxa dza huadxín gban, uspán ladxëꞌë len cutu guꞌë latj bönniꞌ udxíëꞌ yeru lidxëꞌ, cui cuanëꞌ le dzöꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Qui lë ni naꞌ, gul‑zóa ban ladxiꞌ caꞌ lbiꞌiliꞌ, le huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, dza curbözliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Niꞌr Pedro gnabnëꞌ Jesús, rnëꞌ: ―Xan, ¿naruꞌ rëꞌu netuꞌz lë ni runuꞌ lsaquiꞌ, o rëꞌu caꞌ cni yúguꞌtë bunách? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rëꞌ lëꞌ Xanruꞌ: ―¿Nuzxa naꞌ bönniꞌ huen dxin tsahuiꞌ len réjniꞌinëꞌ, dë lu nëꞌë uláz queëꞌ xanëꞌ? Bönniꞌ ni, xanëꞌ udödëꞌ lu nëꞌë lidxëꞌ quië catiꞌ gal‑laꞌr lahuëꞌ bönniꞌ nacuꞌë lidxëꞌ, guꞌë qui queëquëꞌ le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bicaꞌ ba bönniꞌ huen dxin naꞌ catiꞌ huödëꞌ xanëꞌ, duxaquëꞌë lëꞌ runëꞌ cni dxin naꞌ nudödëꞌ lu nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Le nactë rëpaꞌ lbiꞌiliꞌ, udödëꞌ xanëꞌ lu nëꞌë bönniꞌ huen dxin tsahuiꞌ naꞌ yúguꞌtë le dë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Chquiꞌ gáquinëꞌ huadzeynëꞌ huödëꞌ xanëꞌ bönniꞌ huen dxin cni, atiꞌ su lahuëꞌ guꞌë döꞌ quequëꞌ yezícaꞌrëꞌ huen dxin, bönniꞌ len ngul, len su lahuëꞌ guiꞌj gahuëꞌ len súdxinëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","niꞌr huödëꞌ xanëꞌ bönniꞌ huen dxin naꞌ catiꞌ curbözëꞌ lëꞌ len catiꞌ curáquibeꞌinëꞌ, atiꞌ usacaꞌ ziꞌë bönniꞌ huen dxin cunaquëꞌ tsahuiꞌ naꞌ, len gchuguëꞌ queëꞌ ca narugu quequëꞌ bönniꞌ cutaꞌyejlëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Bönniꞌ huen dxin naꞌ nöznëꞌ le rëꞌnnëꞌ xanëꞌ, len cutu zoëꞌ sinaꞌ, len cutu runëꞌ ca rnëꞌ xanëꞌ, bönniꞌ ni, szxö́nitër quinëꞌ lëꞌ xanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Chquiꞌ cutu nöznëꞌ le rëꞌnnëꞌ xanëꞌ bönniꞌ huen dxin, len gunëꞌ le gun ga gbaguëꞌë le quinëꞌ lëꞌ xanëꞌ, bönniꞌ ni quinëꞌ lëꞌ látiꞌdauꞌz. Bönniꞌ yuꞌu lu nëꞌë szxöni, szxöni unabëꞌ xanëꞌ lu nëꞌë, atiꞌ bönniꞌ naꞌ xanëꞌ nuzxöni ladxëꞌë lëꞌ szxöni, szxö́nitër caꞌ unabëꞌ xanëꞌ lu nëꞌë bönniꞌ huen dxin naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Gnëꞌ caꞌ Jesús: ―Bidaꞌ nedaꞌ djenaꞌ ga tsegui guiꞌ yödzlyú ni, len laꞌ bíquiꞌczdaꞌ chnaguel‑laꞌ guiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naꞌa, dë tu le ral‑laꞌ sacaꞌ quiꞌa le nac ca tu le gdildaꞌ nis, atiꞌ röꞌa baníg ga gdxintë gac cni quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Naruꞌ ráquiliꞌ bidaꞌ dulequi dxiaꞌ le rac yödzlyú ni? Rëpaꞌ lbiꞌiliꞌ: Cutu. Bidaꞌ dulequiaꞌ le gun ga laꞌrúj chopl bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Naꞌa su lau lulaꞌalen lzaꞌgac gayuꞌ bunách nacuáꞌ tu yuꞌu. Tsonnëꞌ laꞌdáꞌbaguëꞌë chopëꞌ naziꞌquëꞌ xtidzaꞌa, atiꞌ chopëꞌ naꞌ laꞌdáꞌbaguëꞌë tsonnëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nu bönniꞌ zoabiꞌ biꞌi bönniꞌ queëꞌ táꞌbaguëꞌë zxiꞌnëꞌ naꞌ, atiꞌ biꞌi bönniꞌ naꞌ táꞌbagaꞌbiꞌ xuzbiꞌ. Ngul zoabiꞌ biꞌi ngul queënu táꞌbagaꞌnu zxiꞌnnu naꞌ, atiꞌ biꞌi ngul naꞌ táꞌbagaꞌbiꞌ xnaꞌbiꞌ. Ngul zoanu ngul zxoaꞌ lidxnu táꞌbagaꞌnu zxoaꞌ lidxnu naꞌ, atiꞌ ngul zxoaꞌ lidxnu naꞌ táꞌbagaꞌnu xtauꞌ zxiꞌnnu. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Gudxëꞌ caꞌ bunách zian nacuáꞌ niꞌ Jesús, rnëꞌ: ―Catiꞌ rléꞌiliꞌ zaꞌ böaj zacaꞌ ga rbia gbidz, laꞌ rnátëliꞌ: “Hual guiöj”, atiꞌ cni rac. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Catiꞌ reycj böꞌ zaꞌ zacaꞌ ga rdöd gbidz beoꞌ ziag, rnaliꞌ: “Udzáꞌa naꞌa”, atiꞌ cni rac. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lbiꞌiliꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ. Nö́ziliꞌ le ruluíꞌ le rac luzxbá len le rac luyú ni, san cutu ráquibeꞌiliꞌ le ruluíꞌ le nacgac bëꞌ tac dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Gnëꞌ caꞌ Jesús: ―¿Bizx quië cutu rbequi xbeyliꞌ laꞌ lbiꞌizliꞌ ca nac le nac tsahuiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chquiꞌ zoa nu bi unabi yudxi liꞌ atiꞌ zeajliꞌ gdxinliꞌ yúlahuiꞌ, bëꞌ ladxuꞌu ugáꞌnlenuꞌ tsahuiꞌ nu naꞌ tsal niꞌ yuꞌuliꞌ nöz, cui uquí liꞌ lahuëꞌ bönniꞌ cuequi xbeynëꞌ lbiꞌiliꞌ, atiꞌ bönniꞌ cuequi xbey naꞌ udödëꞌ liꞌ lu nëꞌë bönniꞌ ruseyjëꞌ lidx guia, atiꞌ bönniꞌ naꞌ ruseyjëꞌ lidx guia cuꞌë liꞌ lidx guia naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Rëpaꞌ liꞌ, cutu urujuꞌ niꞌ catiꞌ udxr quizxjuꞌ yúguꞌtë dumí lasdauꞌ ral‑luꞌu qui nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Laꞌ dza niꞌz guladxinëꞌ niꞌ bönniꞌ taꞌguíxjöiꞌnëꞌ Jesús ca benëꞌ Pilato, budödcdëꞌ laꞌquëꞌ bönniꞌ Galilea len gzxiꞌë rön quequëꞌ, le bugútsiꞌnëꞌ xchöncbaꞌ böaꞌ bëdx chguludödcdëꞌ‑baꞌ quië laꞌguꞌë lahuëꞌ Dios xchöncbaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ ráquiliꞌ glacrëꞌ bönniꞌ dul‑laꞌ bönniꞌ Galilea naꞌ ca yezícaꞌrëꞌ bönniꞌ Galilea, le gulazacaꞌ gulaguiꞌë cni? ");
INSERT INTO zsrNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Rëpaꞌ lbiꞌiliꞌ: Cutu, atiꞌ chquiꞌ cutu ubíꞌi ládxiꞌliꞌ, nitliꞌ caꞌ yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lëzcaꞌ cni guc quequëꞌ chizxunëꞌ bönniꞌ niꞌ, yajbagaꞌ lequëꞌ yuꞌu zian cuia naꞌ nazíꞌ lei Siloé, atiꞌ glatiëꞌ. ¿Naruꞌ ráquiliꞌ gulabágaꞌtërëꞌ zxguiaꞌ lequëꞌ ca yezicaꞌ bunách nacuáꞌ Jerusalén? ");
INSERT INTO zsrNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Rëpaꞌ lbiꞌiliꞌ: Cutu, atiꞌ chquiꞌ cutu ubíꞌi ládxiꞌliꞌ, nitliꞌ caꞌ yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Niꞌr benëꞌ lsaquiꞌ Jesús, rëꞌ lequëꞌ: ―Zoëꞌ bönniꞌ, zoa yag higo nazëꞌ ga nac laꞌ yël queëꞌ. Rajtiljëꞌ le rbia yag naꞌ, san cutu bi rdzölnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Niꞌr gudxëꞌ bönniꞌ runëꞌ dxin laꞌ yël queëꞌ naꞌ, rnëꞌ: “Chguc tsonn iz ridaꞌ rdudiljaꞌ le cuia yag higo ni len cutu bi rdzöldaꞌ. Bchugu lei. ¿Bizx quië rnig luyú ni?” ");
INSERT INTO zsrNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Niꞌr bubiꞌë didzaꞌ bönniꞌ huen dxin naꞌ, rëꞌ lëꞌ: “Xan, bcaꞌngar lei yetú iztëz, atiꞌ gzatsaꞌ yu zxani len cuꞌa bëb zxani. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chquiꞌ cuia yag ni, gac dxiꞌa, san chquiꞌ cutu bi cuia, niꞌr gchuguꞌ lei.” ");
INSERT INTO zsrNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tu dza rusëdnëꞌ Jesús bunách nacuáꞌ yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío catiꞌ nac dza laꞌy quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Zoanu niꞌ ngul chguc chizxunuꞌ iz réꞌinu, le yuꞌu lënu böꞌ xöhuiꞌ run ga teꞌi bunách, atiꞌ nayéchutecznu rdanu, len cutu caꞌ rac ulí cuinnu. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Catiꞌ bléꞌinëꞌ‑nu Jesús, bulidzëꞌ‑nu, rnëꞌ: ―Nguldauꞌ, chböacuꞌ qui guidzhuë́ꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Niꞌr bxoa nëꞌë lënu Jesús, atiꞌ laꞌ bulitë cuinnu, len gluꞌnu‑nëꞌ Dios yöl‑laꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Niꞌr gleynëꞌ bönniꞌ blau qui yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios. Rleynëꞌ le bunëꞌ‑nu ngul naꞌ Jesús catiꞌ nac dza laꞌy. Gudxëꞌ nup nacuáꞌ niꞌ bönniꞌ blau naꞌ, rnëꞌ: ―Xop dza nacuáꞌ runruꞌ dxin. Dë latj yuguꞌ dza ni guidliꞌ nu un lbiꞌiliꞌ, len clëg dza laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Niꞌr bubiꞌë didzaꞌ Xanruꞌ, rnëꞌ: ―Lbiꞌiliꞌ, bönniꞌ ruluíꞌz tsahuiꞌ cuinliꞌ, ¿naruꞌ cu rusedxcliꞌ‑baꞌ böaꞌ bëdx qui queëliꞌ ga naꞌ daꞌcbaꞌ catiꞌ nac dza laꞌy, atiꞌ tsjuaꞌgacliꞌ‑baꞌ liꞌjbaꞌ nis? ");
INSERT INTO zsrNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nacnu zxiꞌn xsoëꞌ Abraham ngul ni len gdu chizxunuꞌ iz chyuꞌnu lu yal‑lj qui Satanás tuꞌ xöhuiꞌ. ¿Naruꞌ cu ral‑laꞌ nu usédx lënu zal‑laꞌ nac dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Catiꞌ bëꞌë didzaꞌ ni Jesús, gulutuiꞌnëꞌ yúguꞌtë bönniꞌ nacuꞌë niꞌ taꞌleynëꞌ Lëꞌ, san guludziji yezicaꞌ bunách, yúguꞌtë nup nacuáꞌ niꞌ, le taꞌléꞌinëꞌ yuguꞌ le zxön runëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Niꞌr rnëꞌ Jesús: ―¿Nacxcz rac rzxön le rna bëꞌë Dios, o bizxa usáquiꞌtsaruꞌ lei? ");
INSERT INTO zsrNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Rac ca rac qui xseydauꞌ mostaza, le gzxiꞌë bönniꞌ atiꞌ guzëꞌ lei ga nac laꞌ yël queëꞌ. Gzxön mostaza naꞌ len guc ca yag zxön, atiꞌ guladxinbaꞌ bguindauꞌ, glunbaꞌ lidxcbaꞌ lu zxuzaꞌ nëꞌi mostaza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Lëzcaꞌ cni rnëꞌ Jesús: ―¿Bizxa caz usáquiꞌtsadaꞌ le rna bëꞌë Dios? ");
INSERT INTO zsrNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nac ca xnëꞌi yöt xtil, le gzxiꞌnu ngul len bugútsiꞌnu tsonn cuia cua yöt xtil, atiꞌ gyazx gdutë cua naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsal niꞌ yuꞌë nöz Jesús, zijëꞌ Jerusalén, rdödëꞌ yuguꞌ yödz zxön len yuguꞌ yödzdauꞌ, rusëdnëꞌ bunách nacuáꞌ gap naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Gnabnëꞌ Jesús bönniꞌ zoëꞌ niꞌ, rnëꞌ: ―Xan, ¿naruꞌ nabábz nup lulá? Rëꞌ nup nacuáꞌ niꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","rnëꞌ: ―Gul‑güíꞌ ládxiꞌliꞌ tsazliꞌ zacaꞌ ga nu ryaz le nac guidauꞌ, le rëpaꞌ lbiꞌiliꞌ: Zian nup lëꞌni laꞌyáz niꞌ, san cutu laꞌzáquiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Töd tsasëꞌ useyjëꞌ yuꞌu xan yuꞌu, su lauliꞌ lbiꞌiliꞌ naꞌ zoaliꞌ niꞌl ulidzliꞌ‑nëꞌ raꞌ yuꞌu naꞌ, guiëliꞌ‑nëꞌ: “Xan, Xan, bsalj queëtuꞌ.” Niꞌr ubiꞌë didzaꞌ Lëꞌ, guiëꞌ lbiꞌiliꞌ: “Cutu nözdaꞌ nuzxa lbiꞌiliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Niꞌr su lauliꞌ gnaliꞌ: “Güiꞌ gdágulentuꞌ Liꞌ, atiꞌ busëdnuꞌ gap nac lu yëꞌy queëtuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Niꞌr guiëꞌ lbiꞌiliꞌ: “Rëpaꞌ lbiꞌiliꞌ, cutu nözdaꞌ gazx bunách lbiꞌiliꞌ. Gul‑cuít ga zoaꞌ, yúguꞌtëliꞌ ruaꞌliꞌ döꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Niꞌr cödx yéchiꞌliꞌ len utíl‑l láyaꞌliꞌ catiꞌ gléꞌigacliꞌ‑nëꞌ Abraham len Isaac, len Jacob, len yúguꞌtë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, nacuꞌë ga niꞌ rna bëꞌë Dios, san lbiꞌiliꞌ zoaliꞌ niꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Laꞌdxín bunách laꞌrúj zacaꞌ ga rlen gbidz, len zacaꞌ ga rbia gbidz, len zacaꞌ ga zaꞌ böꞌ ziag, len zacaꞌ ga rdöd gbidz beoꞌ ziag, atiꞌ laꞌböꞌë lahuëꞌ ga niꞌ rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Niꞌr lac blau laꞌgac bunách nacgac caꞌz naꞌa, atiꞌ lugáꞌn caꞌz laꞌgac nup nacgac blau naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Laꞌ dza niꞌz guladxinëꞌ ga zoëꞌ Jesús bönniꞌ gdauꞌ fariseo len tëꞌ Lëꞌ: ―Burúj, buzxúndj ni, le rëꞌnnëꞌ gdöddëꞌ Liꞌ Herodes. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús rëꞌ lequëꞌ: ―Gul‑tséaj, gul‑tsjödxëꞌ bönniꞌ naꞌ naquëꞌ ca tubaꞌ bözaꞌ, gnaliꞌ: “Byutscaꞌ, rubíjgacaꞌ böꞌ xöhuiꞌ len ruúnaꞌ bunách naꞌa len cxö, len catiꞌ gac lidzj, udx gunaꞌ dxin quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Run bayúdx tséajlenzaꞌ caꞌ nöz naꞌa len cxö len huidzj, atiꞌ gdxinaꞌ Jerusalén, le tuꞌdödcdëꞌ niꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Lbiꞌiliꞌ, zoaliꞌ Jerusalén. Rudö́digacliꞌ‑nëꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios len ruládxiꞌgacliꞌ‑nëꞌ guiöj bönniꞌ gbaz rsölëꞌë queëliꞌ Dios. Cátiꞌga zian lzu guꞌndaꞌ utubaꞌ lbiꞌiliꞌ quiaꞌ ca runbaꞌ yjëd, rutubbaꞌ zxiꞌnbaꞌ zxan xilbaꞌ, san cutu gúꞌniliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gul‑yutscaꞌ, caꞌz ugáꞌn lidxliꞌ, atiꞌ rëpaꞌ lbiꞌiliꞌ, cutur gléꞌiliꞌ nedaꞌ catiꞌ gdxinr dza gnaliꞌ: “Bicaꞌ ba nu zaꞌ uláz queëꞌ Xanruꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Catiꞌ nac dza laꞌy quequëꞌ bönniꞌ judío, gyaziëꞌ Jesús lidxëꞌ bönniꞌ uná bëꞌ, bönniꞌ gdauꞌ fariseo. Röꞌë Jesús rahuëꞌ, atiꞌ taꞌnë́ꞌë Lëꞌ bönniꞌ gdauꞌ fariseo nacuꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Zoëꞌ caꞌ niꞌ lahuëꞌ Jesús bönniꞌ réꞌinëꞌ huëꞌ gui. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Niꞌr Jesús gnabnëꞌ bönniꞌ gdauꞌ tuꞌsëdi taquëꞌ zxba queëꞌ Moisés len yuguꞌ bönniꞌ gdauꞌ fariseo, rnëꞌ: ―¿Naruꞌ dë latj unruꞌ nu reꞌi catiꞌ nac dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lequëꞌ guluséyj rúꞌaquëꞌ. Niꞌr gdel‑lëꞌë bönniꞌ huëꞌ naꞌ Jesús len bunëꞌ lëꞌ, atiꞌ laꞌ busö́laꞌtëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Niꞌr rëꞌ yuguꞌ bönniꞌ gdauꞌ naꞌ Jesús, rnëꞌ: ―Chquiꞌ zoëꞌ bönniꞌ nutsëꞌë ladjliꞌ, atiꞌ nacuaꞌbaꞌ queëꞌ böaꞌ bëdx, atiꞌ gbixbaꞌ tubaꞌ lu yeru, ¿naruꞌ cu tsajlijtëꞌ‑baꞌ, zal‑laꞌ nac dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Cutu bi didzaꞌ guc lubiꞌë ca nac lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Catiꞌ bléꞌinëꞌ Jesús ca tunëꞌ bönniꞌ gdauꞌ fariseo naꞌ, taꞌböꞌë latj blau ga naꞌ taꞌböꞌë tahuëꞌ, niꞌr benëꞌ lsaquiꞌ, rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Catiꞌ nu ulídz liꞌ guiduꞌ ga rac lni qui yöl‑laꞌ rutság naꞌ, cutu cöꞌu latj blau. Nazx caꞌ nulidzëꞌ caꞌ bönniꞌ náctërëꞌ blau ca liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Niꞌr huidëꞌ ga zuꞌ bönniꞌ naꞌ bulidzëꞌ liꞌ, len guiëꞌ liꞌ: “Bëꞌ latj bönniꞌ ni cöꞌë ga zuꞌ”, atiꞌ niꞌr lu yöl‑laꞌ rutuíꞌi quiuꞌ tsajchöꞌu zxanti. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Qui lë ni naꞌ, catiꞌ nu ulídz liꞌ, gyeaj yajchö́ꞌ zxanti, quië catiꞌ gdxinëꞌ bönniꞌ naꞌ bulidzëꞌ liꞌ, huëꞌ liꞌ: “Böchaꞌa, gdöd yelatiꞌ nil.” Niꞌr gacruꞌ liꞌ blau laugac nup taꞌböꞌlen liꞌ tsazxö́n. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nu run ba zxön cuini, lunëꞌ ga huötaꞌ huöxj, san nu zoa nöxj ladxiꞌ, lunëꞌ ga gacr blau nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús rëꞌ caꞌ bönniꞌ naꞌ bulidzëꞌ Lëꞌ, rnëꞌ: ―Catiꞌ gunuꞌ güiꞌi huagu o lnidauꞌ, cutu ulidzcuꞌ‑nëꞌ yuguꞌ böchiꞌ lzaꞌu len yuguꞌ bönniꞌ böchuꞌu len yuguꞌ diꞌa dza quiuꞌ, len yuguꞌ dzag yuꞌu quiuꞌ taꞌléꞌinëꞌ yöl‑laꞌ tsahuiꞌ quequëꞌ, le lulidzëꞌ caꞌ liꞌ, atiꞌ cni gac, ubíꞌi quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Catiꞌ gunuꞌ güiꞌi huagu, bulídz bunách yechiꞌ, len nup nabíx niꞌa naꞌgac, len nup cutaꞌzáꞌ, len yuguꞌ lau chul. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Niꞌr gacuꞌ bicaꞌ ba, le cutu gac bi lubiꞌë quiuꞌ bönniꞌ cni, san ubíꞌi quiuꞌ catiꞌ gdxin dza lubán nup natgac, nacgac tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Catiꞌ byönnëꞌ didzaꞌ ni bönniꞌ röꞌë rágulenëꞌ Jesús, rëꞌ Lëꞌ: ―Bicaꞌ ba nu gagu ga niꞌ rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús rëꞌ lëꞌ: ―Zoëꞌ bönniꞌ benëꞌ lni zxön, atiꞌ zian nup bulidzëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Catiꞌ chnabáꞌa laꞌ huagu, bsölëꞌë bönniꞌ huen dxin queëꞌ tsjödxëꞌ nup naꞌ chnulidzëꞌ, gnëꞌ: “Gul‑dá, yúguꞌtë chnabáꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gulazú lauquëꞌ yúguꞌtëꞌ taꞌnabëꞌ latj cutsjaquëꞌ. Bönniꞌ ziꞌal naꞌ rnëꞌ: “Ziꞌa gzxiꞌa tu laꞌ yël, len runtsca bayúdx tsajyúaꞌ lei. Rátaꞌyuaꞌ lauꞌ gunnuꞌ nedaꞌ latj.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yetúëꞌ rnëꞌ: “Ziꞌa gzxiꞌa gayuꞌ nözbaꞌ bëdx atiꞌ tsajxíꞌ bëꞌa lecbaꞌ ugúngacaꞌ‑baꞌ dxin. Rátaꞌyuaꞌ lauꞌ gunnuꞌ nedaꞌ latj.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yetúëꞌ rnëꞌ: “Ziꞌa butság naꞌa, len qui lë ni naꞌ cutu gac guidaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Catiꞌ böjëꞌ bönniꞌ huen dxin naꞌ, yajtíxjöiꞌnëꞌ xanëꞌ yúguꞌtë lë ni. Niꞌr gleynëꞌ bönniꞌ xan yuꞌu naꞌ, atiꞌ gudxëꞌ bönniꞌ huen dxin naꞌ, rnëꞌ: “Gyeajtë naꞌa gap nac lu yëꞌy len gap nac laꞌ nöz qui yödz ni, atiꞌ gchëꞌu ni bunách yechiꞌ len nup nabíx niꞌa naꞌgac, len nup cutaꞌzáꞌ, len yuguꞌ lau chul.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Catiꞌ chnunëꞌ cni bönniꞌ huen dxin naꞌ, rnëꞌ: “Xan, chbenaꞌ ca naꞌ gna béꞌinuꞌ nedaꞌ, atiꞌ ni dë latj.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Niꞌr gudxëꞌ bönniꞌ huen dxin naꞌ xanëꞌ, rnëꞌ: “Gyeaj gap nac laꞌ nöz len gap nac nöz las, atiꞌ ben bayúdx lid nup nacuáꞌ niꞌ quië gdzaꞌ lidxaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","le rëpaꞌ lbiꞌiliꞌ: Cutu gahuëꞌ qui lni quiaꞌ nitúëꞌ bönniꞌ niꞌ bulidzaꞌ ziꞌal.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yuguꞌ dza niꞌ rjaclen Jesús bunách zian, atiꞌ bueycjëꞌ Jesús, rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Chquiꞌ guídlenëꞌ nedaꞌ bönniꞌ len cutu gdxiꞌirnëꞌ nedaꞌ ca nadxiꞌinëꞌ xuz xnëꞌë, len ngul queëꞌ, len yuguꞌ zxiꞌnëꞌ, len yuguꞌ biꞌi böchëꞌë, len yuguꞌ biꞌi zanëꞌ, len yöl‑laꞌ naꞌbán queëꞌ, cutu gac gaquëꞌ bönniꞌ usë́d quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nu bönniꞌ cugaquëꞌ ca tu bönniꞌ zijëꞌ zajtë́ꞌë lëꞌi yag cruz, len tëꞌë nedaꞌ, cutu gac gaquëꞌ bönniꞌ usë́d quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chquiꞌ zoëꞌ bönniꞌ ladj lbiꞌiliꞌ guëꞌnnëꞌ gunëꞌ tu yuꞌu zian cuia, ¿naruꞌ cu cöꞌë ziꞌal ulabëꞌ gacaꞌx dumí ral‑laꞌ gtöëꞌ quië gnöznëꞌ chquiꞌ dë queëꞌ tsca le rquinnëꞌ quië usyudxëꞌ gunëꞌ yuꞌu naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chquiꞌ cutu gunëꞌ cni, len su lahuëꞌ cuequiëꞌ xlibi yuꞌu naꞌ, atiꞌ cutu gac usyudxëꞌ gunëꞌ yuꞌu naꞌ, niꞌr laꞌzú laugac lutítj lëꞌ yúguꞌtë nup laꞌleꞌi lei, ");
INSERT INTO zsrNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","laꞌná: “Bönniꞌ ni gzu lahuëꞌ runëꞌ yuꞌu, san cutu guc usyudxëꞌ gunëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Lëzcaꞌ cni, chquiꞌ zoëꞌ bönniꞌ rna bëꞌë, len ral‑laꞌ tsijëꞌ gdil‑l tsajtíl‑lenëꞌ yetúëꞌ bönniꞌ rna bëꞌë, ¿naruꞌ cu cöꞌë ziꞌal cuequi icjëꞌ chquiꞌ sáquiꞌnëꞌ tsajtíl‑lenëꞌ bönniꞌ niꞌ nachë́ꞌë galj milëꞌ bönniꞌ, atiꞌ lëꞌ chi milzëꞌ bönniꞌ nachë́ꞌë? ");
INSERT INTO zsrNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chquiꞌ cutu sáquiꞌnëꞌ, catiꞌ niꞌ zoëꞌ ziꞌtuꞌ yetúëꞌ bönniꞌ naꞌ rna bëꞌë, gsölëꞌë queëꞌ bönniꞌ gbaz queëꞌ, atiꞌ gnabëꞌ nacx ral‑laꞌ gunëꞌ quië ludzaguëꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cni nac, chquiꞌ zoëꞌ bönniꞌ ladj lbiꞌiliꞌ cutu ucaꞌnëꞌ yúguꞌtë le dë queëꞌ, cutu gac gaquëꞌ bönniꞌ usë́d quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Gnëꞌ caꞌ Jesús: ―Dxiꞌa nac zödiꞌ, san chquiꞌ nit yöl‑laꞌ snaꞌ qui, ¿nacx úniruꞌ lei snaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cutur nac lsacaꞌ zödiꞌ naꞌ, ni quië luyú, ni quië ga r‑ruꞌnruꞌ bëb, san chuꞌnruꞌ lei niꞌl. Nu zoa nag len ryöni, ral‑laꞌ uzë́ nag nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Guludubëꞌ ga zoëꞌ Jesús yúguꞌtë bönniꞌ uquízxj lazgac bunách len yuguꞌ bönniꞌ caꞌz quië luzë́ nagquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Qui lë ni naꞌ gulanë́ꞌ queëꞌ yuguꞌ bönniꞌ gdauꞌ fariseo, len bönniꞌ gdauꞌ tuꞌsëdi, taꞌnë́ꞌ: ―Bönniꞌ ni runëꞌ ba laꞌn bönniꞌ dul‑laꞌ, len rágulenëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Niꞌr benëꞌ lsaquiꞌ ni Jesús, rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Chquiꞌ zoëꞌ bönniꞌ ladj lbiꞌiliꞌ, nacuaꞌbaꞌ queëꞌ tu gayuaꞌbaꞌ böꞌcuꞌ zxilaꞌ, len chquiꞌ nitbaꞌ tubaꞌ, ¿naruꞌ cu ucaꞌnëꞌ yezícaꞌrbaꞌ taplalj yu chë́nnabaꞌ naꞌ ga nac lu latj caꞌz, atiꞌ tsijëꞌ tsajtiljëꞌ‑baꞌ böꞌcuꞌ zxilaꞌ naꞌ nanitbaꞌ, catiꞌ udzölrnëꞌ‑baꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Catiꞌ udzölnëꞌ‑baꞌ, lu yöl‑laꞌ rudziji queëꞌ gxoëꞌ‑baꞌ yen zxicjëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","len catiꞌ udxinëꞌ lidxëꞌ utubëꞌ yuguꞌ böchiꞌ lzëꞌë len yuguꞌ dzag yuꞌu queëꞌ, atiꞌ guiëꞌ lequëꞌ: “Gul‑dzíjilen nedaꞌ, le chbudzöldaꞌ‑baꞌ böꞌcuꞌ zxilaꞌ quiaꞌ gnitbaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rëpaꞌ lbiꞌiliꞌ: Lëzcaꞌ cni gactër yöl‑laꞌ rudziji yehuaꞌ yubá niꞌa queëꞌ tuëꞌ bönniꞌ dul‑laꞌ ubíꞌi ladxëꞌë ca gac quequëꞌ taplalj yu chënnëꞌ bönniꞌ tsahuiꞌ, bönniꞌ táquinëꞌ cutu naquincnëꞌ lubíꞌi ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Rnëꞌ caꞌ Jesús: ―Chquiꞌ zoanu ngul, dë queënu chi dumí plata, len chquiꞌ nit tu dumí plata naꞌ, ¿naruꞌ cu ggál‑laꞌnu guiꞌ, atiꞌ gluanu yuꞌu, uguílj yúdxinu lei catiꞌ udzö́lirnu lei? ");
INSERT INTO zsrNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Catiꞌ udzö́linu lei, utubnu yuguꞌ ngul lzaꞌnu, len yuguꞌ ngul dzag yuꞌu queënu, atiꞌ guiënu lecnu: “Gul‑dzíjilen nedaꞌ, le chbudzöldaꞌ dumí plata naꞌ gnit.” ");
INSERT INTO zsrNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Rëpaꞌ lbiꞌiliꞌ: Lëzcaꞌ cni, ludzíjtsquirnëꞌ gbaz laꞌy queëꞌ Dios niꞌa queëꞌ tuëꞌ bönniꞌ dul‑laꞌ ubíꞌi ladxëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Rnëꞌ caꞌ Jesús: ―Zoëꞌ bönniꞌ nacuaꞌbiꞌ chopbiꞌ biꞌi bönniꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Biꞌi cuidiꞌ naꞌ rëbiꞌ xuzbiꞌ: “Dad, benn quiaꞌ le dë quiuꞌ le ral‑laꞌ gaqui quiaꞌ.” Niꞌr xuzbiꞌ naꞌ gdisiëꞌ quecbiꞌ le dë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nabábz dza gdzey, yúguꞌtë butubbiꞌ biꞌi cuidiꞌ naꞌ, gyeajbiꞌ yödz ziꞌtuꞌ, atiꞌ niꞌ butöbiꞌ dëra le dë queëbiꞌ. Le cunác benbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Catiꞌ chbutöbiꞌ dëra le dë queëbiꞌ, guc gbin lu yödz ga naꞌ zoabiꞌ, atiꞌ byadzj queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Niꞌr gyeajbiꞌ yajsoabiꞌ huen dxin queëꞌ bönniꞌ lu yödz niꞌ, atiꞌ bönniꞌ naꞌ bsölëꞌë‑biꞌ ga dë laꞌ yël queëꞌ tsajgágubiꞌ‑baꞌ yuguꞌ cuch queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Guc ládxiꞌbiꞌ gágubiꞌ guixiꞌ caꞌz naꞌ tágubaꞌ cuch, san nutu nu bi bëꞌ le gágubiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Niꞌr bubíꞌi ládxiꞌbiꞌ, rnabiꞌ: “Cátiꞌga zian bönniꞌ huen dxin nacuꞌë lidxëꞌ xuzaꞌ, len dëtsca le tahuëꞌ, san nedaꞌ ni huatczaꞌ yöl‑laꞌ rdun. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Uzáꞌa ni, huöjaꞌ ga zoëꞌ xuzaꞌ, len tsjödxaꞌ‑nëꞌ: Dad, benaꞌ dul‑laꞌ lahuëꞌ Dios, zoëꞌ yehuaꞌ yubá, len lauꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cutur nacaꞌ nedaꞌ lsacaꞌ gacaꞌ zxiꞌnuꞌ. Ben nedaꞌ ca bönniꞌ huen dxin quiuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Niꞌr gyuꞌubiꞌ nöz, zhuöjbiꞌ ga zoëꞌ xuzbiꞌ. ’Catiꞌ niꞌ zoabiꞌ ziꞌtuꞌ zuzaꞌbiꞌ, bléꞌinëꞌ‑biꞌ xuzbiꞌ, len buechiꞌ ladxëꞌë‑biꞌ. Jaréluꞌë yajxíꞌgal‑lëꞌ‑biꞌ xuzbiꞌ len yajnidëꞌ yenbiꞌ, gdahuëꞌ‑biꞌ bzxidu. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Niꞌr zxiꞌnëꞌ naꞌ rëbiꞌ‑nëꞌ: “Dad, benaꞌ dul‑laꞌ lahuëꞌ Dios, zoëꞌ yehuaꞌ yubá, len lauꞌ liꞌ. Cutur nacaꞌ nedaꞌ lsacaꞌ gacaꞌ zxiꞌnuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Niꞌr xuzbiꞌ rëꞌ yuguꞌ bönniꞌ huen dxin queëꞌ, rnëꞌ: “Gul‑tsajleajtë lariꞌ zácaꞌtsqui, len gul‑gacu‑biꞌ. Gul‑cúꞌu le zacaꞌ xbönniꞌ naꞌbiꞌ, len gul‑dáꞌ lölbiꞌ níꞌabiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gul‑tsajxíꞌ‑baꞌ bëdx renniꞌ, atiꞌ gul‑dödi‑baꞌ. Gáguruꞌ‑baꞌ len gunruꞌ lni, ");
INSERT INTO zsrNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","le guc biꞌi bönniꞌ quiaꞌ ni ca biꞌi chnatbiꞌ, atiꞌ bubanbiꞌ. Gnitbiꞌ atiꞌ chbulaꞌabiꞌ naꞌa.” Niꞌr gulazú lauquëꞌ tuꞌdzijnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Tsal niꞌ rac lë ni, zoabiꞌ ladj guixiꞌ biꞌi bönniꞌ ziꞌal queëꞌ bönniꞌ naꞌ. Catiꞌ zuzaꞌbiꞌ rudxinbiꞌ gal‑laꞌ raꞌ yuꞌu, ryö́nibiꞌ rac huil‑l len rac huöꞌa lu yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Niꞌr bulidzbiꞌ‑nëꞌ bönniꞌ huen dxin zoëꞌ niꞌ, len gnábibiꞌ lëꞌ bizxa naꞌ rac. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bönniꞌ huen dxin naꞌ rëꞌ‑biꞌ: “Biꞌi böchuꞌu naꞌ budxinbiꞌ, atiꞌ gna bëꞌë xuzuꞌ guludöddëꞌ‑baꞌ bëdx renniꞌ, le budxinbiꞌ lu nëꞌë dxiꞌa tsáhuiꞌdauꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Niꞌr gleybiꞌ biꞌi ziꞌal naꞌ len cutu gúꞌnibiꞌ tsazbiꞌ yuꞌu. Niꞌr brujëꞌ xuzbiꞌ, len gútaꞌyuëꞌ laubiꞌ tsazbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bubiꞌibiꞌ didzaꞌ biꞌi ziꞌal naꞌ, rëbiꞌ‑nëꞌ xuzbiꞌ: “Nözcznuꞌ cátiꞌga zian iz benaꞌ dxin lauꞌ, len gatga gdáꞌbagaꞌa liꞌ, san gatga bennuꞌ quiaꞌ tubaꞌ böꞌcuꞌ zxílaꞌdauꞌ güíꞌlenaꞌ xbey yuguꞌ lzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naꞌa, catiꞌ budxinbiꞌ biꞌi quiuꞌ ni busnitbiꞌ yuguꞌ le dë quiuꞌ, gdálenbiꞌ‑nu yuguꞌ ngul udá dzag, benuꞌ ga guludöddëꞌ‑baꞌ bëdx renniꞌ niꞌa queëbiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Niꞌr rëꞌ‑biꞌ xuzbiꞌ, rnëꞌ: “Zxiꞌnaꞌ, liꞌ zóalenczuꞌ nedaꞌ atiꞌ yúguꞌtë le dë quiaꞌ, quiuꞌ naqui. ");
INSERT INTO zsrNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ben bayúdx gunruꞌ lni len udzíjiruꞌ, le gucbiꞌ biꞌi böchuꞌu ni ca biꞌi chnatczbiꞌ, atiꞌ nubanbiꞌ. Gnitbiꞌ atiꞌ chbulaꞌabiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Rëꞌ caꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rnëꞌ: ―Zoëꞌ bönniꞌ dë yöl‑laꞌ tsahuiꞌ queëꞌ, len zoëꞌ caꞌ queëꞌ bönniꞌ huen dxin dë lu nëꞌë uláz queëꞌ. Guladxinëꞌ bönniꞌ tuꞌquíëꞌ bönniꞌ huen dxin naꞌ lahuëꞌ xanëꞌ, taꞌnë́ꞌ queëꞌ rutözëꞌ le dë queëꞌ xanëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Niꞌr bulidzëꞌ bönniꞌ huen dxin naꞌ xan yuꞌu naꞌ, len rëꞌ lëꞌ: “¿Bizxa didzaꞌ ni ryöndaꞌ quiuꞌ? Bluiꞌ nedaꞌ le nac bëꞌ dxin nunuꞌ, le cutur gataꞌ lu naꞌu uláz quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Niꞌr gzaꞌ ladxëꞌë bönniꞌ huen dxin naꞌ, rnëꞌ: “¿Nacx guntsaꞌ? Rubijëꞌ nedaꞌ xanaꞌ latj blau ga runaꞌ dxin. Cutu sáquiꞌdaꞌ gunaꞌ dxin guꞌn, len utuiꞌdaꞌ gnabaꞌ nu bi gunnz quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naꞌa chnözdaꞌ nac gunaꞌ quië catiꞌ ubijëꞌ nedaꞌ latj blau ni, laꞌcuáꞌ nup luzíꞌ nedaꞌ lidxgac.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Niꞌr bulidzëꞌ yuguꞌ bönniꞌ bi tal‑lëꞌë queëꞌ xanëꞌ bönniꞌ huen dxin naꞌ, atiꞌ rëꞌ bönniꞌ ziꞌal: “¿Gacaꞌx ral‑luꞌu queëꞌ xanaꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lëꞌ rnëꞌ: “Tu gayuáꞌ röꞌö chugu le za ral‑laꞌa.” Rëꞌ lëꞌ bönniꞌ huen dxin blau naꞌ, rnëꞌ: “Ni dë guich ga nayúj le ral‑luꞌu. Gröꞌtë ni len bzuj yetú lu guich gna chiʉ́n röꞌö chugu ral‑luꞌu.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gdöd niꞌ gnabnëꞌ yetúëꞌ, rnëꞌ: “Nazx liꞌ, ¿gacaꞌx ral‑luꞌu?” Lëꞌ rnëꞌ: “Tu gayuáꞌ daꞌa zxoaꞌ xtil.” Niꞌr rëꞌ lëꞌ bönniꞌ huen dxin blau naꞌ, rnëꞌ: “Ni dë guich ga nayúj le ral‑luꞌu. Bzuj yetú lu guich gna taplalj daꞌa ral‑luꞌu.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ráquibeꞌinëꞌ xanëꞌ naꞌ sínaꞌtë benëꞌ bönniꞌ huen dxin cunác tsahuiꞌ naꞌ. Cni nac, nácgacrëꞌ sinaꞌ bönniꞌ yödzlyú ni lu yuguꞌ le tunëꞌ laꞌ légaczëꞌ, ca bunách taꞌdalen Dios lu yeníꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Gul‑cözlen dxiꞌa bunách, ugunliꞌ dxin yöl‑laꞌ tsahuiꞌ dë queëliꞌ yödzlyú ni, quië catiꞌ gdxin dza ucaꞌnliꞌ yuguꞌ lë ni, lunëꞌ lbiꞌiliꞌ ba laꞌn latj niꞌ zoa tzalzú. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Nu rugún dxiꞌa dxin tu le cuidiꞌz dë lu nëꞌi, lëzcaꞌ ugún dxiꞌa dxin tu le zxön gataꞌ lu nëꞌi. Nu cutu rugún dxiꞌa dxin tu le cuidiꞌz dë lu nëꞌi, cutu ugún dxiꞌa dxin tu le zxön gataꞌ lu nëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Qui lë ni naꞌ, chquiꞌ cutu rugunliꞌ dxiꞌa dxin yöl‑laꞌ tsahuiꞌ dë queëliꞌ yödzlyú ni, ¿nuzxa caz udö́d lu naꞌliꞌ yöl‑laꞌ tsahuiꞌ le nac gdu? ");
INSERT INTO zsrNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chquiꞌ cutu rugunliꞌ dxiꞌa dxin le dë lu naꞌliꞌ le naqui qui nu yubl, ¿nuzxa caz udö́d lu naꞌliꞌ le ral‑laꞌ gaqui quiëczliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Cutu gac gunëꞌ xchingac chop xanëꞌ nitúëꞌ huen dxin, le udiꞌinëꞌ tuëꞌ len gdxiꞌinëꞌ yetúëꞌ, o gunëꞌ ba laꞌn tuëꞌ, len uzóëꞌ tslaꞌl yetúëꞌ naꞌ. Cutu gac gunliꞌ xchinëꞌ Dios, len gunliꞌ caꞌ dxin quië uziꞌliꞌ xbey yöl‑laꞌ tsahuiꞌ qui yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Gulayönnëꞌ caꞌ didzaꞌ ni bönniꞌ gdauꞌ fariseo, atiꞌ le nadxiꞌicnëꞌ yöl‑laꞌ tsahuiꞌ quequëꞌ, qui lë ni naꞌ gulutitjëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Niꞌr Jesús rëꞌ lequëꞌ: ―Lbiꞌiliꞌ rubíj dxiꞌa cuinliꞌ laugac bunách, san nözcznëꞌ Dios le yuꞌu icj ládxiꞌdauꞌliꞌ, le nac lë naꞌ tun zxön bunách tu le ruzóëꞌ Dios tslaꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gnëꞌ caꞌ Jesús: ―Ga bdxintë dza zoëꞌ Juan, ben dxin le rna bëꞌ zxba queëꞌ Moisés len le guluzujëꞌ lu guich bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. Niꞌr catiꞌ bdxinëꞌ Juan naꞌ, gzu lau rac lban ca gac nu tsaz ga rna bëꞌë Dios, atiꞌ tun bayúdx yúguꞌtë bunách laꞌyáz niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Zal‑laꞌ rac cni, gacr huëz laꞌdö́d qui luzxbá len qui luyú ni ca nit tu didzaꞌz nayúj lu guich lu zxba queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Gnëꞌ caꞌ Jesús: ―Chquiꞌ uláꞌalenëꞌ ngul queëꞌ bönniꞌ, atiꞌ utság náꞌlenëꞌ‑nu ngul yubl, gunëꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ, atiꞌ nu utság naꞌlen ngul naꞌ nusanëꞌ‑nu bönniꞌ queënu, gun caꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Niꞌr benëꞌ lsaquiꞌ Jesús, rnëꞌ: ―Zoëꞌ bönniꞌ rléꞌinëꞌ yöl‑laꞌ tsahuiꞌ queëꞌ. Racuëꞌ lariꞌ xna len lariꞌ zácaꞌtsqui, atiꞌ yuguꞌ dza rúnteczëꞌ lni, tiꞌj tahuëꞌ le banaqui. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Zoëꞌ caꞌ niꞌ bönniꞌ yéchiꞌdauꞌ lëꞌ Lázaro, bönniꞌ rnabëꞌ nu bi unö́dzj queëꞌ, atiꞌ huë́ꞌtëzëꞌ röꞌë raꞌ yuꞌu queëꞌ bönniꞌ naꞌ rléꞌinëꞌ yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rac ladxëꞌë bönniꞌ yéchiꞌdauꞌ naꞌ gahuëꞌ le bizxj tuꞌhuö́xj zxani ga rahuëꞌ bönniꞌ naꞌ rléꞌinëꞌ yöl‑laꞌ tsahuiꞌ. Taꞌdxinbaꞌ caꞌ böꞌcuꞌ, taꞌlëꞌëbaꞌ lu huëꞌ queëꞌ bönniꞌ yéchiꞌdauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bdxin dza gutiëꞌ bönniꞌ yéchiꞌdauꞌ naꞌ, atiꞌ gulachë́ꞌë lëꞌ gbaz laꞌy queëꞌ Dios tsajsóalenëꞌ Abraham ga nac latj lach queëꞌ Dios. Gutiëꞌ caꞌ bönniꞌ naꞌ bléꞌinëꞌ yöl‑laꞌ tsahuiꞌ, atiꞌ gulucachëꞌë lëꞌ yeru ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Catiꞌ niꞌ rzacaꞌ rguiꞌë bönniꞌ naꞌ bléꞌinëꞌ yöl‑laꞌ tsahuiꞌ, zoëꞌ latj quegac nup natgac, bchis lahuëꞌ len bléꞌinëꞌ Abraham zoëꞌ ziꞌtuꞌ, dzaguëꞌ lëꞌ Lázaro naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Niꞌr bëꞌë zidzj didzaꞌ, rnëꞌ: “Xuzaꞌ, Abraham, buechiꞌ ladxiꞌ nedaꞌ. Bsölaꞌ quiaꞌ Lázaro uspisëꞌ xbönniꞌ nëꞌë len dusuhualëꞌ ludxaꞌa, le rzacaꞌ rguiꞌtscaꞌ lu guiꞌ ni.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Rëꞌ lëꞌ Abraham, rnëꞌ: “Zxiꞌnaꞌ, bsaꞌ ladxuꞌu ca guc quiuꞌ, buziꞌu xbey yöl‑laꞌ tsahuiꞌ tsal niꞌ zuꞌ nabanuꞌ, san Lázaro ni, guc queëꞌ yöl‑laꞌ yechiꞌ, atiꞌ naꞌa, ruzíꞌ zxönëꞌ Lázaro ni, san liꞌ rzacaꞌ rguiꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yetú caꞌ, raꞌ guiꞌa sib nac, zoa gatsj lahuiꞌl ga niꞌ zoaliꞌ lbiꞌiliꞌ len ga ni zoatuꞌ netuꞌ. Qui lë ni naꞌ nup nacuáꞌ ni len lëꞌni laꞌdö́d ga zoaliꞌ lbiꞌiliꞌ, cutu caꞌ gac lunëꞌ caꞌ, len cutu gac lid ni nup nacuáꞌ niꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Niꞌr rëꞌ lëꞌ bönniꞌ naꞌ bléꞌinëꞌ yöl‑laꞌ tsahuiꞌ, rnëꞌ: “Xuzaꞌ Abraham, rátaꞌyuaꞌ lauꞌ gsöluꞌu‑nëꞌ Lázaro tsijëꞌ lidxëꞌ xuzaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","le nacuꞌë niꞌ gáyuꞌë bönniꞌ böchaꞌa. Bsölëꞌë tsjenëꞌ lnaꞌ lau qui le rac ni, cui djaquëꞌ caꞌ latj ga ni rzacaꞌ rguiꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Niꞌr rëꞌ lëꞌ Abraham, rnëꞌ: “Dë quequëꞌ le buzujëꞌ lu guich Moisés len le guluzujëꞌ lu guich bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. Yuguꞌ didzaꞌ quequëꞌ naꞌ ral‑laꞌ luzë́ nagquëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bubiꞌë didzaꞌ bönniꞌ naꞌ bléꞌinëꞌ yöl‑laꞌ tsahuiꞌ, rnëꞌ: “Xuzaꞌ Abraham, cutu gac cni, san chquiꞌ ubanëꞌ bönniꞌ lu yöl‑laꞌ gut, len tsijëꞌ ga naꞌ nacuꞌë, lubíꞌi ládxiꞌquëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Rëꞌ lëꞌ Abraham, rnëꞌ: “Chquiꞌ cutu tuꞌzë́ nagquëꞌ didzaꞌ bëꞌë Moisés len le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, cutu laꞌyejlëꞌë zal‑laꞌ nu ubán lu yöl‑laꞌ gut.” ");
INSERT INTO zsrNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Rëꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rnëꞌ: ―Nacuaꞌtecz le tun ga lun dul‑laꞌ bunách, san bicaꞌ bayechiꞌ nu naꞌ run ga nu gun dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dxiꞌar gac queëꞌ bönniꞌ naꞌ runëꞌ cni, nu ugal‑laꞌ yag yenëꞌ guiöj ryëtu len tsajchúꞌn lëꞌ lu nis zxön, catiꞌl gunëꞌ ga gun dul‑laꞌ bö́nniꞌdauꞌ náquinëꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gul‑gún chiꞌi cuinliꞌ. Chquiꞌ guꞌë döꞌ quiuꞌ böchiꞌ lzaꞌu, bzejniꞌ‑nëꞌ, len chquiꞌ ubíꞌi ladxëꞌë, bnit lau lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Zal‑laꞌ gadx lzu tu dza guꞌë döꞌ quiuꞌ, len gadx lzu caꞌ guidëꞌ ga zuꞌ len guiëꞌ liꞌ: “Rubíꞌi ladxaꞌa”, ral‑laꞌ unít lauꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Niꞌr tëꞌ Xanruꞌ bönniꞌ gbaz queëꞌ, taꞌnë́ꞌ: ―Ben ga tséjlëꞌrtuꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rëꞌ lequëꞌ Xanruꞌ, rnëꞌ: ―Laꞌnaruꞌ nac cuidiꞌz yöl‑laꞌ rejlëꞌ queëliꞌ Dios, nacz ca xseydauꞌ mostaza, huac guiëliꞌ yag zxön ni: “Bcuit ni, yajsóa lu nis zxön”, atiꞌ gun ca rnaliꞌ yag naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gnëꞌ caꞌ Jesús: ―Chquiꞌ zoëꞌ bönniꞌ ladj lbiꞌiliꞌ, len zoëꞌ queëꞌ bönniꞌ nadaꞌu rugaꞌnëꞌ‑baꞌ bëdx o rlapëꞌ, catiꞌ udx gunëꞌ xchinëꞌ xanëꞌ, ¿naruꞌ huëtsëꞌ lëꞌ xanëꞌ, gnëꞌ: “Gda, gröꞌ gaguꞌ.”? ");
INSERT INTO zsrNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cutu. Cni guiëꞌ lëꞌ: “Bpaꞌa le gahuaꞌ. Gzoa sinaꞌ cuꞌu le guiꞌj gahuaꞌ, atiꞌ tödr naꞌ huac guiꞌj gaguꞌ liꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Naruꞌ huëtsëꞌ bönniꞌ nadaꞌu queëꞌ naꞌ: “Xclenuꞌ”, le benëꞌ ca gna béꞌinëꞌ lëꞌ? Runi nedaꞌ, cutu gunëꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lëzcaꞌ cni gac queëliꞌ. Catiꞌ chnunliꞌ yúguꞌtë le gna béꞌinëꞌ lbiꞌiliꞌ Dios, ral‑laꞌ gnaliꞌ: “Nactuꞌ huen dxin cunactuꞌ lsacaꞌ, le benztuꞌ le run bayúdx guntuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tsal niꞌ yuꞌë nöz Jesús, zijëꞌ Jerusalén, rdödëꞌ gap dë yödzdauꞌ nababgac luyú Samaria len luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Catiꞌ gyaziëꞌ tu yödzdauꞌ, gularujëꞌ dutsagquëꞌ Lëꞌ chiëꞌ bönniꞌ téꞌinëꞌ huëꞌ nudzuꞌ ruzö́d, atiꞌ gulacuꞌë ziꞌtuꞌz, ");
INSERT INTO zsrNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","len tuꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Jesús, Bönniꞌ Usëdi, buechiꞌ ladxiꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Catiꞌ bléꞌinëꞌ lequëꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑tséaj, gul‑tsajluíꞌ cuinliꞌ laugac bxuz. Tsal niꞌ zjaquëꞌ, guluhuöaquëꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Niꞌr tuëꞌ bönniꞌ nutsëꞌë ladjquëꞌ, catiꞌ ráquibeꞌinëꞌ chnuhuöaquëꞌ dxiꞌa, böjëꞌ ga naꞌ zoëꞌ Jesús, ruíꞌteczëꞌ zidzj didzaꞌ, rguꞌë Dios yöl‑laꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Byechuëꞌ len butság lahuëꞌ lyu lahuëꞌ Jesús, len rëꞌ Lëꞌ: “Xclenuꞌ.” Nababëꞌ Samaria bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Niꞌr Jesús rëꞌ lëꞌ: ―¿Naruꞌ cu guluhuöaquëꞌ dxiꞌa chiëꞌ bönniꞌ? ¿Gazx nacuaꞌtsëꞌ yezícaꞌrëꞌ bönniꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Naruꞌ cu zoa nu huöd cuꞌu Dios yöl‑laꞌ ba, san tuzëꞌ bönniꞌ gzaꞌa ni? ");
INSERT INTO zsrNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Niꞌr gudxëꞌ bönniꞌ naꞌ Jesús, rnëꞌ: ―Gyas len böaj lidxuꞌ. Chböacuꞌ dxiꞌa le réjlëꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Catiꞌ taꞌnabnëꞌ Jesús bönniꞌ gdauꞌ fariseo batx ral‑laꞌ gdxin le rna bëꞌë Dios, Lëꞌ bubiꞌë didzaꞌ, rëꞌ lequëꞌ: ―Ca gdxin le rna bëꞌë Dios, cutu nac le gléꞌiruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nutu nu gac gna: “Ni bdxin”, o gna: “Niꞌ bdxin.” Gul‑yutscaꞌ. Rna bëꞌë Dios lu icj ládxiꞌdauꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Niꞌr gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Huadxín dza catiꞌ guë́ꞌniliꞌ gléꞌiliꞌ dza huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, san cutu gléꞌiliꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Laꞌcuáꞌ nup lë lbiꞌiliꞌ: “Ni zoëꞌ”, o laꞌná: “Niꞌ zoëꞌ.” Cutu tseajliꞌ niꞌ, len cutu tséajlenliꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ca rac catiꞌ ryëp yös, ruzeníꞌ gdaꞌl luzxbá, lëzcaꞌ cni gac catiꞌ gdxin dza huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ziꞌal ca gac lë ni, run bayúdx sacaꞌ quiꞌitscaꞌ, atiꞌ lucáꞌn nedaꞌ caꞌz bunách dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ca naꞌ guc dza niꞌ zoëꞌ Noé, lëzcaꞌ cni gac catiꞌ gdxin dza huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dza niꞌtë naꞌ gliꞌj glahuëꞌ. Gulutság naꞌquëꞌ len guludödëꞌ zxiꞌnquëꞌ lu yöl‑laꞌ rutság naꞌ ga bdxintë dza gyaziëꞌ Noé lëꞌi barco zxön naꞌ nazíꞌ lei arca, atiꞌ bdxintë nis guiöj usnít yödzlyú le busnít yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lëzcaꞌ cni guc dza niꞌ zoëꞌ Lot. Gliꞌj glahuëꞌ. Glaꞌuëꞌ len glútiꞌë. Glazëꞌ xyuquëꞌ len glunëꞌ yuguꞌ yuꞌu quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Catiꞌ bdxin dza naꞌ burujëꞌ Lot lu yödz Sodoma, ca tu nis guiöj, böxj guiꞌ len le ruzéguiꞌtsca nazíꞌ lei azufre, atiꞌ busnít yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lëzcaꞌ cni gac catiꞌ gdxin dza uluíꞌ lahuaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Catiꞌ gdxin dza naꞌ, chquiꞌ zoëꞌ cjuꞌu bönniꞌ, len dzöꞌ yuꞌu naꞌ le dë queëꞌ, cutu ral‑laꞌ huötjëꞌ tsajxiꞌë le dë queëꞌ, atiꞌ nu zoa ladj guixiꞌ, lëzcaꞌ cni, cutu ral‑laꞌ huöjëꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gul‑sáꞌ ládxiꞌliꞌ ca guc queënu ngul queëꞌ Lot. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nu bönniꞌ rëꞌnnëꞌ gun chiꞌë yöl‑laꞌ naꞌbán queëꞌ, unitiëꞌ lei, san bönniꞌ unitiëꞌ yöl‑laꞌ naꞌbán queëꞌ, udel‑lëꞌë lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Rëpaꞌ lbiꞌiliꞌ: Catiꞌ gdxin rël naꞌ, laꞌcuꞌë chopëꞌ bönniꞌ tuz ga tasiëꞌ, atiꞌ tuëꞌ duxiꞌa‑nëꞌ, len yetúëꞌ ucaꞌnaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Laꞌcuaꞌnu huëtu tsazxö́n chopnu ngul, atiꞌ tunu duxiꞌa‑nu, len yetunu ucaꞌnaꞌ‑nu. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Laꞌcuꞌë ladj guixiꞌ chopëꞌ bönniꞌ, atiꞌ tuëꞌ duxiꞌa‑nëꞌ, len yetúëꞌ ucaꞌnaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Catiꞌ gulayönnëꞌ lë ni bönniꞌ usë́d queëꞌ Jesús, gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―Xan, ¿gazx gac lë ni? Jesús rëꞌ lequëꞌ: ―Ga dë tu le nat, niꞌ ludubczbaꞌ bëchláb. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Niꞌr benëꞌ lsaquiꞌ Jesús, rëꞌ lequëꞌ ca run bayúdx ulídzteczruꞌ‑nëꞌ Dios, len cugác chop ládxiꞌruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Rnëꞌ: ―Zoëꞌ tu yödz bönniꞌ rbequi xbey curádxinëꞌ Dios, len curunëꞌ bönniꞌ ba laꞌn. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Laꞌ yödz naꞌz zoanu ngul uzë́b, atiꞌ bdxinnu ga zoëꞌ bönniꞌ rbequi xbey naꞌ ngul ni, rnanu: “Glequi xbey le run quiaꞌ nu ruaꞌ döꞌ quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xtsey cutu guꞌnnëꞌ bi gunëꞌ queënu, san gdöd niꞌ gzaꞌ ladxëꞌë, rnëꞌ: “Cutu rádxidaꞌ‑nëꞌ Dios, len cutu runaꞌ bönniꞌ ba laꞌn, ");
INSERT INTO zsrNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","san le rupizxjnu nedaꞌ ngul uzë́b ni, qui lë ni naꞌ cuequi xbeydaꞌ‑nu, cui guídtecznu ni, len cui töd bëꞌi upizxjnu nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Niꞌr rëꞌ lequëꞌ Xanruꞌ, rnëꞌ: ―Gul‑zë́ nagliꞌ ca naꞌ gnëꞌ bönniꞌ rbequi xbey naꞌ cunaquëꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Naruꞌ cu cuequi xbeynëꞌ Dios bunách gröczëꞌ queëꞌ, nup naꞌ tuꞌlídz Lëꞌ rël len të dza? ¿Naruꞌ huadzéytsanëꞌ gáclenëꞌ lequëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rëpaꞌ lbiꞌiliꞌ: Laꞌ cuequi xbéytenëꞌ lequëꞌ. Catiꞌ huödaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, ¿naruꞌ gdzöldaꞌ luyú ni nup taꞌyejlëꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Benëꞌ lsaquiꞌ Jesús ca nac quequëꞌ bönniꞌ tuꞌbíj dxiꞌa cuinquëꞌ, len tuꞌcaꞌnëꞌ caꞌz yezicaꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Cni rnëꞌ: ―Guladxinëꞌ chopëꞌ bönniꞌ ga nac nchil gdauꞌ quië lulidzëꞌ Dios. Naquëꞌ bönniꞌ gdauꞌ fariseo tuëꞌ bönniꞌ naꞌ, atiꞌ yetúëꞌ naꞌ naquëꞌ bönniꞌ uquízxj lazgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Gzuinëꞌ bönniꞌ gdauꞌ fariseo naꞌ, len cni bulidzëꞌ Dios, rnëꞌ: “Dios, rëpaꞌ Liꞌ: Xclenuꞌ, le cunacaꞌ ca nacquëꞌ yezicaꞌrëꞌ bönniꞌ, nacquëꞌ gban, len cunacquëꞌ tsahuiꞌ. Taꞌguitsjëꞌ zxba qui yöl‑laꞌ nutság naꞌ. Lëzcaꞌ cutu nacaꞌ ca bönniꞌ uquízxj ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nedaꞌ runaꞌ gubás chop lzu tsa xunuꞌ dza hueaj, len runödzjaꞌ qui gdauꞌ tu cuia tsa tu chi cuia qui yúguꞌtë le rataꞌ quiaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gzoazëꞌ ziꞌtuꞌ bönniꞌ uquízxj naꞌ, len cutu böazxjnëꞌ gchis lahuëꞌ uyúëꞌ luzxbá, san gdapëꞌ lchuꞌë, rnëꞌ: “Dios, buechiꞌ ladxiꞌ nedaꞌ, bönniꞌ dul‑laꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Böjëꞌ lidxëꞌ bönniꞌ uquízxj naꞌ, nuhuöaquëꞌ tsahuiꞌ lahuëꞌ Dios, clëg yetúëꞌ bönniꞌ niꞌ. Nútiꞌtëz bönniꞌ run ba zxön cuinëꞌ, gunëꞌ Dios ga huötaꞌ huöxjëꞌ, san nu bönniꞌ rzoëꞌ nöxj ladxiꞌ, gunëꞌ Dios ga gacrëꞌ blau. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Niꞌr guladxinëꞌ ga zoëꞌ Jesús yuguꞌ bönniꞌ len ngul, nachëꞌquëꞌ‑biꞌ biꞌidauꞌ quequëꞌ quië gxoa nëꞌë lecbiꞌ Jesús. Catiꞌ gulaléꞌinëꞌ lë ni bönniꞌ usë́d queëꞌ Jesús, guladil‑lëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Niꞌr bulidzëꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, rnëꞌ: ―Gul‑güíꞌ‑biꞌ latj laꞌdxinbiꞌ ga zoaꞌ biꞌidauꞌ ni, cu uzágaꞌliꞌ xnö́zcbiꞌ, le gataꞌ quegac nup nacgac cni latj ga rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Le nactë rëpaꞌ lbiꞌiliꞌ: Nu cusíꞌ lu nëꞌi le rna bëꞌë Dios, ca runbiꞌ tubiꞌ biꞌidauꞌ, cutu caꞌ tsaz ga niꞌ rna bëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Gnabnëꞌ Jesús bönniꞌ uná bëꞌ, rnëꞌ: ―Bönniꞌ Usëdi gdu dxiꞌa. ¿Bizxa ral‑laꞌ gunaꞌ quië gdél‑liꞌdaꞌ yöl‑laꞌ naꞌbán gdu? ");
INSERT INTO zsrNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús rëꞌ lëꞌ: ―¿Bizx quië rëꞌu nedaꞌ: “Gdu dxiꞌa”? Nutu nu bönniꞌ naquëꞌ gdu dxiꞌa. Tuzëꞌ Dios naquëꞌ gdu dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nözcznuꞌ yuguꞌ le gna bëꞌë Dios: Cutu gunuꞌ dul‑laꞌ le rguitsj zxba qui yöl‑laꞌ nutság naꞌ. Cutu gdödcduꞌ bunách. Cutu cuanuꞌ. Cutu gneuꞌ qui lzaꞌu le cunácz. Ben ba laꞌn xuz xnaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rëꞌ Jesús bönniꞌ naꞌ, rnëꞌ: ―Yúguꞌtë lë ni runaꞌ ga gdel‑laꞌ nacaꞌ biꞌidauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Catiꞌ byönnëꞌ didzaꞌ ni Jesús, rëꞌ lëꞌ: ―Yetú le ryadzj quiuꞌ gunuꞌ. Bëtiꞌ yúguꞌtë le dë quiuꞌ, atiꞌ lë naꞌ siꞌu bnödzj quegac bunách yechiꞌ, atiꞌ gataꞌ quiuꞌ yöl‑laꞌ tsahuiꞌ yehuaꞌ yubá. Niꞌr gda, gdaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Catiꞌ byönnëꞌ didzaꞌ ni bönniꞌ naꞌ, ruhuiꞌnnëꞌ, le dëtsca yöl‑laꞌ tsahuiꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Catiꞌ bléꞌinëꞌ Jesús ca naꞌ ruhuiꞌnnëꞌ bönniꞌ naꞌ, rnëꞌ: ―Bicaꞌ baníg gac, laꞌyáz ga rna bëꞌë Dios nup taꞌleꞌi yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gacr huëz tödbaꞌ nag yötsiꞌ böaꞌ, ca tsaziëꞌ ga rna bëꞌë Dios bönniꞌ rléꞌinëꞌ yöl‑laꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Niꞌr nup gulayöni didzaꞌ ni taꞌná: ―¿Nuzxa caz gac ulá, chquiꞌnuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús gudxëꞌ lequëꞌ: ―Le cugác lunëꞌ bönniꞌ, huac gunëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niꞌr Pedro rëꞌ Jesús: ―Byutscaꞌ, netuꞌ nucaꞌntuꞌ yúguꞌtë le dë queëtuꞌ, len daꞌtuꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Niꞌr Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, nu bönniꞌ ucaꞌnëꞌ lidxëꞌ, o xuz xnëꞌë, o yuguꞌ böchiꞌ zanëꞌ, o ngul queëꞌ, o yuguꞌ zxiꞌnëꞌ, le ruiꞌ ladxëꞌë gna bëꞌë Dios, ");
INSERT INTO zsrNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bönniꞌ ni huaziꞌrëꞌ dza ni zoaruꞌ naꞌa, atiꞌ dza ziꞌa zaꞌ gdél‑liꞌnëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bchëꞌë quizi queëꞌ idxínnutëꞌ bönniꞌ usë́d queëꞌ Jesús, len rëꞌ lequëꞌ: ―Gul‑yutscaꞌ, rbenruꞌ zijruꞌ Jerusalén, ga niꞌ lutság yúguꞌtë le nayujgac lu guich ca gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios ca ral‑laꞌ gac quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ludödëꞌ nedaꞌ bönniꞌ Jerusalén lu naꞌquëꞌ bönniꞌ ziꞌtuꞌ, atiꞌ lutitjëꞌ nedaꞌ, len lulídz ziꞌë nedaꞌ, len luchijëꞌ nedaꞌ zxönaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Laꞌguinëꞌ nedaꞌ, atiꞌ tödr niꞌ ludöddëꞌ nedaꞌ, san catiꞌ gac tsonn dza ubanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cutu gulayéjniꞌnëꞌ didzaꞌ ni bönniꞌ usë́d queëꞌ, len cutu gláquibeꞌinëꞌ le ruíꞌlenëꞌ lequëꞌ didzaꞌ qui, le nac le cusaquiꞌ laꞌyéjniꞌndëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Catiꞌ chzoa gdxinëꞌ Jesús yödz Jericó, zoëꞌ niꞌ bönniꞌ nachúl lahuëꞌ. Röꞌë raꞌ nöz rnabëꞌ nu bi gunnz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bönniꞌ niꞌ byönnëꞌ taꞌdö́d niꞌ bunách zian, atiꞌ gnabëꞌ bizxa naꞌ rac. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bunách niꞌ të lëꞌ: ―Jesús, bönniꞌ Nazaret, rdödëꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Niꞌr bëꞌë zidzj didzaꞌ bönniꞌ naꞌ nachúl lahuëꞌ, rnëꞌ: ―Jesús, Zxiꞌn xsoëꞌ David, buechiꞌ ladxiꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Guladil‑lëꞌ bönniꞌ naꞌ nachúl lahuëꞌ bönniꞌ nanörquëꞌ lahuëꞌ Jesús, quië uséyj ruꞌë, san lëꞌ zidzjr bëꞌë didzaꞌ, rnëꞌ: ―Zxiꞌn xsoëꞌ David, buechiꞌ ladxiꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Niꞌr gzëꞌ dxiz Jesús rbözëꞌ, atiꞌ gna béꞌinëꞌ nu tsajlídz lëꞌ gdxinëꞌ lahuëꞌ. Catiꞌ bdxinëꞌ lahuëꞌ Jesús bönniꞌ naꞌ nachúl lahuëꞌ, gnabnëꞌ lëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","rnëꞌ: ―¿Bizxa rëꞌnnuꞌ gunaꞌ quiuꞌ? Bönniꞌ naꞌ nachúl lahuëꞌ rnëꞌ: ―Rëꞌndaꞌ huöalj yöj lahuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús rëꞌ lëꞌ: ―Chböalj yöj lauꞌ. Chböacuꞌ le réjlëꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Laꞌ niꞌz buléꞌitenëꞌ, atiꞌ zéajlenëꞌ Jesús, rguꞌë Dios yöl‑laꞌ ba. Gulagúꞌu caꞌ Dios yöl‑laꞌ ba yúguꞌtë bunách nacuáꞌ niꞌ taꞌleꞌi lë naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Niꞌr gyaziëꞌ Jesús Jericó, rdödëꞌ lu yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Niꞌ zoëꞌ bönniꞌ lëꞌ Zaqueo, bönniꞌ blau ladjquëꞌ bönniꞌ uquízxj len dë yöl‑laꞌ tsahuiꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ruiꞌ ladxëꞌë gléꞌinëꞌ Jesús bönniꞌ ni, san cutu guc queëꞌ le nacuáꞌ niꞌ bunách zian, len naquëꞌ ga rëꞌdauꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Niꞌr jaréluꞌë yajnörëꞌ laugac bunách zian naꞌ, atiꞌ yajchenëꞌ lu yag quië gac gléꞌinëꞌ Jesús, le ral‑laꞌ tödëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Catiꞌ bdxinëꞌ niꞌ Jesús, bchis lahuëꞌ ruyúëꞌ ga naꞌ dxiëꞌ Zaqueo naꞌ, len rëꞌ lëꞌ: ―Zaqueo, bötjtë lu yag naꞌ, le run bayúdx tsajgaꞌnaꞌ lidxuꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Niꞌr laꞌ bötjtëꞌ lu yag Zaqueo, atiꞌ lu yöl‑laꞌ rudziji queëꞌ bchëꞌë Jesús lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Catiꞌ gulaleꞌi lë ni bunách nacuáꞌ niꞌ, gulazú lauquëꞌ taꞌnë́ꞌ queëꞌ yúguꞌtëꞌ, taꞌnë́ꞌ: ―Gyaziëꞌ Jesús ugáꞌnlenëꞌ bönniꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Niꞌr gzuinëꞌ Zaqueo, len rëꞌ Xanruꞌ: ―Xan, byutscaꞌ. Gatsj le dë quiaꞌ guꞌa quegac bunách yechiꞌ, len chquiꞌ bi gdöd bëꞌi buquizxjaꞌ bunách, ubiꞌa quegac bunách naꞌ tap cuiatël caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús rëꞌ lëꞌ: ―Naꞌa dza ni bdxin yöl‑laꞌ ruslá quegac nup nacuáꞌ yuꞌu ni, le naquëꞌ caꞌ bönniꞌ ni zxiꞌn xsoëꞌ Abraham. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bidaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, dudiljaꞌ len dusláꞌ nup nanitgac. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tsal niꞌ taꞌyönnëꞌ didzaꞌ ni ruꞌë Jesús, rëꞌ lequëꞌ le runëꞌ lsaquiꞌ, le chzoa laꞌdxinëꞌ Jerusalén, atiꞌ táquinëꞌ chzoatë glaꞌ lahui le rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Cni rnëꞌ Jesús: ―Zoëꞌ bönniꞌ blau, zijëꞌ tu yödz ziꞌtuꞌ quië siꞌ lu nëꞌë niꞌ yöl‑laꞌ uná bëꞌ, atiꞌ niꞌr huödëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Catiꞌ chzoa tsijëꞌ niꞌ bulidzëꞌ chiëꞌ bönniꞌ huen dxin queëꞌ, len bëꞌë qui queëquëꞌ tu cöꞌ hueaj dumí, rëꞌ lequëꞌ: “Gul‑quiljlen dumí ni tsal huödaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cutaꞌléꞌinëꞌ lëꞌ dxiꞌa bönniꞌ uládz queëꞌ, atiꞌ gulasölëꞌë ga niꞌ tsijëꞌ yuguꞌ gbaz quequëꞌ, laꞌnë́ꞌ: “Cutu rë́ꞌnituꞌ gna béꞌinëꞌ netuꞌ bönniꞌ ni.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Niꞌr gzxiꞌ lu nëꞌë yöl‑laꞌ uná bëꞌ, atiꞌ budxinëꞌ ladzëꞌ. Niꞌ gna béꞌinëꞌ nu tsajlídz yuguꞌ bönniꞌ huen dxin naꞌ budödëꞌ lu naꞌquëꞌ dumí naꞌ, quië gnöznëꞌ gacaꞌx guluguíljlenëꞌ lei tu tuquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Catiꞌ bdxinëꞌ lahuëꞌ bönniꞌ ziꞌal naꞌ, rnëꞌ: “Xan, tu cöꞌ dumí quiuꞌ naꞌ chben icji yechí cöꞌ caꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Xanëꞌ naꞌ rëꞌ lëꞌ: “Dxiꞌa benuꞌ. Nacuꞌ huen dxin tsahuiꞌ. Le dxíꞌadauꞌ bugunuꞌ dxin latiꞌz naꞌ gutaꞌ lu naꞌu, naꞌa, gunaꞌ ga gna béꞌinuꞌ chi yödz.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Niꞌr bdxinëꞌ lahuëꞌ yetúëꞌ bönniꞌ huen dxin naꞌ, rnëꞌ: “Xan, tu cöꞌ dumí quiuꞌ naꞌ chben icji yegayuꞌ cöꞌ caꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Xanëꞌ naꞌ rëꞌ caꞌ lëꞌ: “Gna béꞌinuꞌ gayuꞌ yödz.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Niꞌr bdxinëꞌ lahuëꞌ yetúëꞌ, rnëꞌ: “Xan, ni dë tu cöꞌ dumí quiuꞌ naꞌ. Ben chiꞌa lei, butuldaꞌ lei lariꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","le rádxidaꞌ liꞌ, le nacuꞌ bönniꞌ bizxj. Runuꞌ ca naꞌ taꞌná bunách: Ruziꞌu le cutu bzuꞌ, len rlapuꞌ ga cutu guzuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Niꞌr xanëꞌ naꞌ rëꞌ lëꞌ: “Nacuꞌ huen dxin cunác tsahuiꞌ. Niꞌa qui didzaꞌ bëꞌu cuequi xbeydaꞌ liꞌ. Ráquibeꞌinuꞌ nacaꞌ bönniꞌ bizxj, len ruziꞌa le cutu bzoaꞌ, len rlapaꞌ ga cutu guzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Naꞌa, ¿bizx quië cutu yajlúꞌu dumí quiaꞌ naꞌ ga gun icji, quië catiꞌ huödaꞌ, uziꞌa lei gdu len icji?” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Niꞌr rëꞌ nup nacuáꞌ niꞌ: “Gul‑cúa lu nëꞌë dumí naꞌ, atiꞌ gul‑güíꞌ queëꞌ bönniꞌ naꞌ dë queëꞌ chi cöꞌ dumí.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lequëꞌ tëꞌ lëꞌ: “Xan, chdë queëꞌ chi cöꞌ dumí.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Niꞌr bubiꞌë didzaꞌ xanquëꞌ, rnëꞌ: “Rëpaꞌ lbiꞌiliꞌ: Nu rugún dxiꞌa dxin le dauꞌ dë lu nëꞌi, luzxöni ládxiꞌgac lëꞌ yelatiꞌ, san nu curugún dxiꞌa dxin le dauꞌ dë lu nëꞌi, lubíj lu nëꞌi lë naꞌ gutaꞌ lu nëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ca nac quequëꞌ bönniꞌ niꞌ cutaꞌléꞌinëꞌ nedaꞌ dxiꞌa, len cutu glëꞌnnëꞌ gna béꞌidaꞌ lequëꞌ, gul‑tsajxíꞌ lequëꞌ djaquëꞌ ni, len gul‑dödi lequëꞌ lahuaꞌ ni.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Catiꞌ budx gnëꞌ cni Jesús, buguel‑lëꞌë xnözëꞌ, zijëꞌ zacaꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Catiꞌ guladxinëꞌ gal‑laꞌ ga nacuáꞌ yödz Betfagé len yödz Betania, ga nac lu guíꞌadauꞌ nazíꞌ lei Guiꞌa Ga Röꞌgac Yag Olivo, bsölëꞌë Jesús chopëꞌ bönniꞌ usë́d queëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","rëꞌ lequëꞌ: ―Gul‑tséaj yödzdauꞌ niꞌ ca dödl ga zoaruꞌ, len catiꞌ tsazliꞌ niꞌ, tsajxácaꞌliꞌ‑baꞌ tubaꞌ búrrodauꞌ nágaꞌbaꞌ niꞌ, búrrodauꞌ naꞌ nutu nu rbiani lëbaꞌ. Gul‑sédx‑baꞌ, len gul‑duchë́ꞌ‑baꞌ quiaꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Chquiꞌ zoa nu gnabi lbiꞌiliꞌ, gna: “¿Bizx quië rsedxliꞌ‑baꞌ?”, ubiꞌiliꞌ didzaꞌ cni gnaliꞌ: “Xanruꞌ rquinnëꞌ‑baꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Zjaquëꞌ bönniꞌ usë́d queëꞌ naꞌ nasölëꞌë, atiꞌ yajxácaꞌquëꞌ‑baꞌ ca naꞌ chgudxëꞌ lequëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Catiꞌ gulasedxëꞌ‑baꞌ búrrodauꞌ naꞌ, bönniꞌ xanbaꞌ tëꞌ lequëꞌ: ―¿Bizx quië rsedxliꞌ‑baꞌ búrrodauꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Xanruꞌ rquinnëꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gulachë́ꞌë‑baꞌ ga naꞌ zoëꞌ Jesús. Catiꞌ chgulaxóëꞌ yuguꞌ lariꞌ tslaꞌa quequëꞌ cúdzuꞌbaꞌ búrrodauꞌ naꞌ, guludxíëꞌ Jesús cúdzuꞌbaꞌ lahui lariꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gap ral‑laꞌ tödëꞌ Jesús, gulachiljëꞌ lariꞌ quequëꞌ laꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Catiꞌ chguladxinëꞌ gal‑laꞌ ga zoa ldinn qui Guiꞌa Ga Röꞌgac Yag Olivo, lu yöl‑laꞌ rudziji quequëꞌ gulazú lauquëꞌ yúguꞌtë bönniꞌ daꞌquëꞌ Jesús, tuꞌë zidzj didzaꞌ, taꞌguꞌë Dios yöl‑laꞌ ba, niꞌa quegac yöl‑laꞌ huac zxön gulaléꞌinëꞌ benëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Taꞌnë́ꞌ: ―Yöl‑laꞌ ba bönniꞌ uná bëꞌ ni zëꞌë uláz queëꞌ Xanruꞌ Dios. Yehuaꞌ yubá zaꞌ le rbequi dxi ládxiꞌruꞌ. Yöl‑laꞌ ba Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Niꞌr tëꞌ Jesús bönniꞌ gdauꞌ fariseo nútsaꞌquëꞌ ladj bunách zian niꞌ, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, gdil‑l yuguꞌ bönniꞌ usë́d quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Rëpaꞌ lbiꞌiliꞌ: Chquiꞌ laꞌcuáꞌ dxiëꞌ bönniꞌ ni, hualuíꞌcz zidzj didzaꞌ yuguꞌ guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Catiꞌ bdxinëꞌ gal‑laꞌ raꞌ yödz naꞌ, len rléꞌinëꞌ lei, rbödxëꞌ qui Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","rnëꞌ: ―Rac ladxaꞌa huanö́ziliꞌ naꞌa dza le gac gun ga cuequi dxi ládxiꞌliꞌ lahuëꞌ Dios, san naꞌa chnagachiꞌ queëliꞌ, cui gléꞌiliꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hualaꞌdxín queëliꞌ dza catiꞌ laꞌbequi zöꞌö gdu zbiꞌil ga zoaliꞌ nup cutaꞌleꞌi lbiꞌiliꞌ dxiꞌa, len laꞌgúꞌu lbiꞌiliꞌ liꞌaj, atiꞌ yúguꞌtë latj gdu zbiꞌil lúnlenëꞌ lbiꞌiliꞌ gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Luquindjëꞌ zöꞌö run chiꞌi yödz queëliꞌ, len ludödcdëꞌ nup nacuáꞌ lu yödz ni. Cutu ugáꞌn guiöj lahui lzëꞌi. Yúguꞌtë lë ni gac queëliꞌ le cutu gúquibeꞌiliꞌ dza bidëꞌ Dios duyúëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Niꞌr gyaziëꞌ Jesús löꞌa gdauꞌ, len gzu lahuëꞌ rubijëꞌ niꞌl yúguꞌtë nup tutiꞌ, len nup taꞌu ga nac löꞌa gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rëꞌ lequëꞌ: ―Nayúj lu guich laꞌy, rna: “Lidxaꞌ nac yuꞌu ga lulídz Dios bunách”, san lbiꞌiliꞌ chnunliꞌ lei ca tu bloj quegac gban. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yuguꞌ dza rusëdnëꞌ Jesús bunách ga nac nchil gdauꞌ, atiꞌ gulazú gulaböꞌë ludöddëꞌ Lëꞌ yuguꞌ bxuz uná bëꞌ, len bönniꞌ gdauꞌ tuꞌsëdi, len yuguꞌ bönniꞌ blau qui lu yödz. ");
INSERT INTO zsrNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Cutu guludzölnëꞌ nacx ludöddëꞌ Lëꞌ, le tuꞌzë́ naggac xtidzëꞌë gdu ládxiꞌgac yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tu dza, catiꞌ niꞌ rusëdnëꞌ bunách Jesús ga nac nchil gdauꞌ, len rguíxjöꞌë didzaꞌ dxiꞌa, guladxinëꞌ ga naꞌ zoëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi, len bönniꞌ gul tuꞌzejniꞌi, ");
INSERT INTO zsrNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","atiꞌ tëꞌ Jesús: ―Gdixjöiꞌ netuꞌ. ¿Bizxa yöl‑laꞌ uná bëꞌ dë lu naꞌu runuꞌ cni? ¿Nuzxa caz budö́d lu naꞌu yöl‑laꞌ uná bëꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Huanabdaꞌ caꞌ lbiꞌiliꞌ tu didzaꞌ, atiꞌ ubiꞌiliꞌ gnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nuzxa bsölaꞌ Juan buquilëꞌ bunách nis? ¿Naruꞌ Dios, o bunách? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Glun xtídzaꞌquëꞌ laꞌ légaczëꞌ bönniꞌ gdauꞌ naꞌ, taꞌnë́ꞌ: ―Chquiꞌ gnaruꞌ: Bsölëꞌë lëꞌ Dios, guiëꞌ rëꞌu: “¿Bizx quië cutu gyéjlëꞌliꞌ‑nëꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chquiꞌ guiëruꞌ‑nëꞌ: Gulasölëꞌë lëꞌ bönniꞌ, luladxiꞌ rëꞌu guiöj bunách lu yödz ni, le nö́zgaccznëꞌ bëꞌë didzaꞌ uláz queëꞌ Dios Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Niꞌr gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Cutu nö́zituꞌ nuzxa naꞌ bsölaꞌ Juan. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Niꞌr Jesús rëꞌ lequëꞌ: ―Nedaꞌ caꞌ cutu gyëpaꞌ lbiꞌiliꞌ bi yöl‑laꞌ uná bëꞌ rúnidaꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Niꞌr laꞌ gzu lautëꞌ Jesús ruíꞌlenëꞌ bunách nacuáꞌ niꞌ didzaꞌ, runëꞌ lsaquiꞌ, rnëꞌ: ―Zoëꞌ bönniꞌ bdëꞌë laꞌ yël queëꞌ yuguꞌ lba uva, atiꞌ budödëꞌ laꞌ yël naꞌ lu naꞌquëꞌ bönniꞌ huen dxin lun gatsjëꞌ len lëꞌ le luziꞌë, atiꞌ gyijëꞌ ziꞌtuꞌ ga niꞌ bugaꞌnëꞌ xtsey. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Catiꞌ bdxin dza luchibëꞌ laꞌ yël naꞌ, bsölëꞌë tuëꞌ bönniꞌ gbaz queëꞌ ga naꞌ nacuꞌë huen dxin naꞌ quië siꞌë uláz queëꞌ qui le luziꞌë, san glundëꞌ lëꞌ ziꞌ huen dxin naꞌ, len gulusölëꞌë lëꞌ caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Leyúbl bsölëꞌë yetúëꞌ gbaz queëꞌ, atiꞌ lequëꞌ glundëꞌ lëꞌ caꞌ ziꞌ, len gluꞌë döꞌ queëꞌ, atiꞌ gulusölëꞌë lëꞌ caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Leyúbl bsölëꞌë quequëꞌ bönniꞌ bunn gbaz queëꞌ, atiꞌ guludxíëꞌ caꞌ lëꞌ huëꞌ, len gulubijëꞌ lëꞌ niꞌl laꞌ yël naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Niꞌr gzaꞌ ladxëꞌë xani laꞌ yël naꞌ, gnëꞌ: “¿Nacx guntsaꞌ? Gsölaꞌa quequëꞌ zxiꞌnczaꞌ nadxiꞌidaꞌ‑biꞌ. Catiꞌ laꞌléꞌinëꞌ‑biꞌ, nazx caꞌ lunëꞌ‑biꞌ ba laꞌn.” ");
INSERT INTO zsrNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Niꞌr, catiꞌ gulaléꞌinëꞌ‑biꞌ huen dxin naꞌ, glun xtídzaꞌquëꞌ laꞌ légaczëꞌ, taꞌnë́ꞌ: “Biꞌi ni gaqui queëbiꞌ laꞌ yël ni. Gul‑dá, gdö́diruꞌ‑biꞌ, quië gaqui queëruꞌ le ral‑laꞌ gaqui queëbiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gulubijëꞌ‑biꞌ niꞌl laꞌ yël naꞌ, guludöddëꞌ‑biꞌ. ’Naꞌa, ¿nacxcz gunëꞌ quequëꞌ xani laꞌ yël naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Guidëꞌ len gdöddëꞌ yuguꞌ huen dxin naꞌ, atiꞌ udödëꞌ laꞌ yël queëꞌ lu naꞌgac bunách yubl. Catiꞌ gulayöni lë ni bunách nacuáꞌ niꞌ, gulanë́ꞌ: ―Dios cugnë́ꞌ gac cni. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Niꞌr buyúëꞌ lequëꞌ Jesús, rnëꞌ: ―¿Bizxa rëꞌni gna lë naꞌ nayúj lu guich laꞌy, rna: Guiöj naꞌ gularuꞌnëꞌ bönniꞌ huen zöꞌö, Guiöj ni chnac guiöjlen squin zöꞌö? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nútiꞌtëz nu gbix lahui guiöj ni, quitsj nu naꞌ, atiꞌ nu bönniꞌ tsajbagaꞌ lëꞌ guiöj ni, uzxúzxj lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Laꞌ dza niꞌz, gulazú gulaböꞌë laꞌzönëꞌ Jesús yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi, le táquibeꞌinëꞌ gnëꞌ quequëꞌ lë naꞌ benëꞌ lsaquiꞌ, san gládxinëꞌ bunách zian nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Niꞌr guluyutsquëꞌ Jesús, len gulasölëꞌë bönniꞌ lubijëꞌ Lëꞌ didzaꞌ, luluíꞌ cuinquëꞌ ca bönniꞌ tsahuiꞌ, quië lunëꞌ ga bi gnëꞌ Jesús, quië gac ludödëꞌ Lëꞌ lu nëꞌë bönniꞌ rna béꞌinëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Quië lunëꞌ cni, gulanabnëꞌ Jesús, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, nö́zituꞌ le nacz rnauꞌ, len le nacz rusëdnuꞌ, len cutu rbequi xbeynuꞌ ca nac le tuꞌluíꞌz lahui bunách, san gdutë li nac ca rusëdnuꞌ zxba queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gdixjöiꞌ netuꞌ. ¿Naruꞌ run bayúdx quizxj laztuꞌ queëꞌ César, bönniꞌ Roma rna bëꞌë, o cutu? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ráquibeꞌinëꞌ Jesús le tëꞌnnëꞌ lunëꞌ queëꞌ, atiꞌ rëꞌ lequëꞌ: ―¿Bizx quië rziꞌ bëꞌliꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Gul‑luiꞌitsquiꞌ nedaꞌ tu dumí rda. ¿Nuzxa lahui daꞌ lëꞌi ni, len nuzxa lei nayúj ni? Gulubiꞌë didzaꞌ, taꞌnë́ꞌ: ―Queëꞌ César naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑nö́dzj queëꞌ César le naqui queëꞌ César, atiꞌ queëꞌ Dios le naqui queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Cutu guc lunëꞌ bi gnëꞌ Jesús quië gac luquíëꞌ Lëꞌ laugac bunách zian naꞌ, san gulubannëꞌ ca nac didzaꞌ bubiꞌë, atiꞌ guluséyj rúꞌaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Niꞌr guladxinëꞌ bönniꞌ gdauꞌ saduceo, nup naꞌ taꞌná cutu lubán nup chnatgac, atiꞌ gulanabnëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","taꞌnë́ꞌ: ―Bönniꞌ Usëdi, Moisés buzujëꞌ queëruꞌ lu guich, le rna: “Chquiꞌ gatiëꞌ bönniꞌ, atiꞌ ugaꞌnnu ngul queëꞌ, len chquiꞌ nutu nu zoa biꞌi queëꞌ, niꞌr ral‑laꞌ siꞌbiꞌ‑nu ngul queëꞌ naꞌ biꞌi böchëꞌë, quië uzoabiꞌ biꞌi queëꞌ bönniꞌ bö́chiꞌbiꞌ naꞌ gutiëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gulacuaꞌbiꞌ gadx biꞌi bönniꞌ naccbiꞌ bö́chiꞌbiꞌ, atiꞌ biꞌi ziꞌal naꞌ butság náꞌlenbiꞌ biꞌi ngul, len gutbiꞌ, cuzoabiꞌ biꞌi queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Niꞌr butság náꞌlenbiꞌ‑nu ngul naꞌ biꞌi buróp naꞌ, atiꞌ gutbiꞌ caꞌ biꞌi ni, cuzoabiꞌ biꞌi queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Butság náꞌlenbiꞌ‑nu biꞌi bunn naꞌ, atiꞌ laꞌ tuz ca glunbiꞌ igádxtëbiꞌ, len glatbiꞌ, cuzoabiꞌ biꞌi quecbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ga budxtë, gutnu caꞌ ngul naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naꞌa, catiꞌ lubán nup chnatgac, ¿núzxalbiꞌ gáquinu queëbiꞌ ngul naꞌ, le gulutság náꞌlenbiꞌ‑nu igádxtëbiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Tuꞌtság naꞌgac bunách dza ni zoaruꞌ naꞌa, len tuꞌnödzjëꞌ‑biꞌ zxiꞌnquëꞌ quië lutság naꞌcbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Naꞌa, nup nacgac lsacaꞌ lubán lu yöl‑laꞌ gut len tsajcuáꞌ yödzlyú ziꞌa gataꞌ, cutu lunëꞌ yöl‑laꞌ rzoalen ngul len cutu lutság naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Cni gac, le cutur latiëꞌ, san lacquëꞌ ca nacquëꞌ gbaz laꞌy queëꞌ Dios, len lacquëꞌ zxiꞌnëꞌ Dios, nup naꞌ lubán lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ca naꞌ ral‑laꞌ lubán nup chnatgac, ruluiꞌinëꞌ rëꞌu Moiséscz ga naꞌ nayúj lu guich ca nac qui yag yötsiꞌ regui, ga niꞌ ruꞌë didzaꞌ Xanruꞌ, rnëꞌ naquëꞌ Dios queëꞌ Abraham, len Dios queëꞌ Isaac, len Dios queëꞌ Jacob. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios naquëꞌ Dios, clëg quegac nup natgac tsaz, san quegac nup nabangac, le nabangac lahuëꞌ Lëꞌ yúguꞌtë bunách, zal‑laꞌ glat luyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Niꞌr gulubiꞌë didzaꞌ laꞌquëꞌ bönniꞌ gdauꞌ usëdi, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, dxíꞌadauꞌ gnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cutur gulurúguinëꞌ laꞌnabnëꞌ Lëꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Niꞌr Jesús rëꞌ lequëꞌ: ―¿Nacxcz naꞌ taꞌnë́ꞌ: “Cristo naquëꞌ zxiꞌnëꞌ David.”? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidcz bëꞌë didzaꞌ le nayúj lu guich laꞌy ga nayujgac salmo, rna: Xanruꞌ Dios gudxëꞌ Xanaꞌ: “Gröꞌ cuit lëꞌa yubél ");
INSERT INTO zsrNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Catiꞌ gunraꞌ ga luzechu zxibgac lauꞌ nup taꞌdáꞌbagaꞌ Liꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidcz naꞌ gnëꞌ queëꞌ naquëꞌ Xanëꞌ. ¿Nacxcz nac, rnaliꞌ lbiꞌiliꞌ naquëꞌ zxiꞌnëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tsal niꞌ tuꞌzë́ naggac Jesús yúguꞌtë bunách nacuáꞌ niꞌ, rëꞌ yuguꞌ bönniꞌ usë́d queëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gul‑gún chiꞌi cuinliꞌ quequëꞌ bönniꞌ gdauꞌ tuꞌsëdi, le taꞌdzág ládxiꞌquëꞌ taꞌdë́ꞌ nácuquëꞌ lariꞌ tunn, len tëꞌnnëꞌ lulídz lequëꞌ zxön bunách gap nac lu yëꞌy, len taꞌdzág ládxiꞌquëꞌ caꞌ taꞌböꞌë latj blau gap tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, len gap taꞌböꞌë tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Taꞌgǘëꞌ lidxcnu ngul uzëbdauꞌ, len quië luluíꞌ tsahuiꞌ cuinquëꞌ, xtsey tuꞌlidzëꞌ Dios. Yuguꞌ bönniꞌ ni, szxö́nitër gunëꞌ Dios ga laꞌzacaꞌ laꞌguiꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ga naꞌ zoëꞌ Jesús nchil gdauꞌ, bchis lahuëꞌ len rléꞌinëꞌ bönniꞌ dë yöl‑laꞌ tsahuiꞌ quequëꞌ, taꞌguꞌë gun lu guiꞌn qui dumí gun qui gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bléꞌinëꞌ caꞌ tu ngul yechiꞌ uzëbdauꞌ, rguꞌnu chop dumí lasdauꞌ, le zácaꞌgac látiꞌdauꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Rnëꞌ Jesús: ―Le nactë rëpaꞌ lbiꞌiliꞌ, le zxöntër gluꞌnu ngul yechiꞌ uzëbdauꞌ ni ca yezicaꞌ bunách naꞌ taꞌguꞌë dumí. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yúguꞌtëꞌ, tsca le nadö́d bëꞌi dë quequëꞌ, gulaguꞌë gun qui gdauꞌ, san ngul ni, lu yöl‑laꞌ yechiꞌ queënu gluꞌnu gdutë le dë queënu, le ral‑laꞌ gáhuinu. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nacuáꞌ niꞌ nup tuiꞌ didzaꞌ ca nac qui gdauꞌ naꞌ, ca naꞌ nazíꞌ lguitj qui, yuguꞌ guiöj záquiꞌtsquigac len gundauꞌ nacgac lach, atiꞌ rëꞌ lequëꞌ Jesús, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Yúguꞌtë lë ni rléꞌiliꞌ, huadxín dza catiꞌ cutur ugáꞌn ni guiöj lahui lzëꞌi, le lusnít gdauꞌ ni bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Niꞌr gulanabnëꞌ Jesús, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, ¿batx gac lë ni? ¿Bizxa gac bëꞌ chzoa gac cni? ");
INSERT INTO zsrNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Gul‑gún chiꞌi cuinliꞌ, qui nadxi nu siꞌ yeꞌi lbiꞌiliꞌ, le laꞌlaꞌquëꞌ bönniꞌ zian, laꞌzíꞌ laquëꞌ ca leaꞌ nedaꞌ, laꞌnë́ꞌ nacquëꞌ Cristo, len laꞌnë́ꞌ: “Chzaꞌ gal‑laꞌ dza udx.” Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Cutu tséajlenliꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Catiꞌ yö́niliꞌ rac gdil‑l, len taꞌdáꞌbagaꞌ yúlahuiꞌ bunách, cutu gadxi gdzö́biliꞌ, le run bayúdx lac ziꞌal le cni, san cutu zuítëni dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Niꞌr rëꞌ caꞌ lequëꞌ: ―Til‑l tu yödz len yetú yödz, atiꞌ bunách tu ga nu rna bëꞌ laꞌdil‑len bunách yetú ga nu rna bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Utittsca yödzlyú, atiꞌ zian latj gac gbin len latsj guidzhuë́ꞌ zxön. Laꞌláꞌ lahui luzxbá le lun gadxi bunách len le lac bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Zíꞌatël catiꞌ ziꞌa lac lë ni, laꞌzö́n lbiꞌiliꞌ bunách len laꞌbía ládxiꞌgac lbiꞌiliꞌ. Laꞌchë́ꞌë lbiꞌiliꞌ gap tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios quië lusyudxëꞌ lbiꞌiliꞌ, len laꞌguꞌë lbiꞌiliꞌ lidx guia. Laꞌchë́ꞌë lbiꞌiliꞌ lauquëꞌ bönniꞌ taꞌná bëꞌë, len lauquëꞌ bönniꞌ blau, le daꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Gac cni queëliꞌ quië sáquiꞌliꞌ gunliꞌ lnaꞌ lau quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tsutsu gul‑gún ládxiꞌliꞌ, cui cuequi icjliꞌ ziꞌal nacx gnaliꞌ uláz queëliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","le gunnaꞌ queëliꞌ didzaꞌ ubiꞌiliꞌ, len yöl‑laꞌ rejniꞌi, cui gac luxicjëꞌ lbiꞌiliꞌ, len cui gac bi laꞌnë́ꞌ qui xtídzaꞌliꞌ bönniꞌ niꞌ cutaꞌléꞌinëꞌ lbiꞌiliꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Niꞌr ludödëꞌ lbiꞌiliꞌ xuzczliꞌ, len yuguꞌ bönniꞌ bö́chiꞌczliꞌ, len yuguꞌ diꞌa dza queëczliꞌ, len yuguꞌ böchiꞌ lzaꞌczliꞌ, atiꞌ ludödcdëꞌ laꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Luzóa lbiꞌiliꞌ tslaꞌl yúguꞌtë bunách le daꞌliꞌ nedaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","san cutu nit nitú guitsaꞌ icjliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chquiꞌ ugaꞌnliꞌ tsutsu, gdél‑liꞌliꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Catiꞌ gléꞌiliꞌ naguꞌuquëꞌ liꞌaj Jerusalén bönniꞌ rjaquëꞌ gdil‑l, gnö́ziliꞌ chbdxin dza nit yödz ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Niꞌr nup nacuáꞌ luyú Judea ral‑laꞌ laꞌzxúndj ni len tsjac gap nac guíꞌadauꞌ, atiꞌ nup nacuáꞌ lu yödz ni ral‑laꞌ laꞌrúj ni, atiꞌ nup nacuáꞌ ladj guixiꞌ, cutu ral‑laꞌ ludxín lu yödz ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yuguꞌ dza niꞌ Dios gunëꞌ zxguiaꞌ nup nacuáꞌ yödz ni quië utság yúguꞌtë le nayúj lu guich laꞌy ca ral‑laꞌ gac quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Catiꞌ gdxin dza niꞌ, bicaꞌ bayechiꞌ ngul nuaꞌcnu‑biꞌ biꞌidauꞌ ziꞌa laljbiꞌ, len ngul tuꞌgádxiꞌnu‑biꞌ biꞌidauꞌ, le laꞌzacaꞌ laꞌguiꞌitsca bunách nacuáꞌ niꞌ, atiꞌ Dios guntsquëꞌ zxguiaꞌ bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Latiëꞌ zianëꞌ lu gdil‑l naꞌ, atiꞌ laꞌchë́ꞌë yelaꞌquëꞌ nadzunquëꞌ ga laꞌdxinëꞌ gdutë yödzlyú, atiꞌ yödz Jerusalén ni, lulíj lulibëꞌ lei bönniꞌ ziꞌtuꞌ naꞌ, catiꞌ gzaꞌar dza quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Gnëꞌ caꞌ Jesús: ―Niꞌr laꞌcuáꞌ le lac bëꞌ lu gbidz, len lu beoꞌ, len yuguꞌ lu bölj luzxbá atiꞌ luyú ni luchixi bunách, atiꞌ ládxinëꞌ, le yön chiꞌi gziuꞌ yu qui nis zxön len qui le ryas rdxia nis naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ludú ládxiꞌquëꞌ lu yöl‑laꞌ radxi quequëꞌ le laꞌzáꞌ ládxiꞌquëꞌ quegac le ral‑laꞌ lac yödzlyú, le laꞌzxíz le nalaꞌgac luzxbá. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Niꞌr laꞌléꞌinëꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, guidaꞌ lu böaj luzxbá, dë lu naꞌa yöl‑laꞌ uná bëꞌ, len glaꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Catiꞌ su lau lac lë ni, gul‑típ ládxiꞌliꞌ, len gul‑chís lauliꞌ, le chzoa udxinaꞌ nedaꞌ, huöaꞌuaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gudxëꞌ caꞌ lequëꞌ Jesús tu le benëꞌ lsaquiꞌ, rnëꞌ: ―Gul‑yutscaꞌ ca rac qui yag higo, len qui bítiꞌtëz yag yubl. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Catiꞌ rléꞌiliꞌ taꞌlén zxuzaꞌ nëꞌi huëꞌndauꞌ, nö́ziczliꞌ chzaꞌ gal‑laꞌ beoꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lëzcaꞌ cni, catiꞌ gléꞌiliꞌ chtac lë ni, gnö́ziliꞌ chzaꞌ gal‑laꞌ dza duná bëꞌë Dios luyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Le nactë rëpaꞌ lbiꞌiliꞌ, cutu lat bunách dza ni zoaruꞌ naꞌa, catiꞌ udxínr yúguꞌtë lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Laꞌdö́d qui luzxbá len qui luyú ni, san xtidzaꞌa, cutu töd caꞌz, san udxíncz ca rna. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Gul‑gún chiꞌi cuinliꞌ cui güiꞌliꞌ latj tsaz icj ládxiꞌdauꞌliꞌ le gun ditj lbiꞌiliꞌ, lë naꞌ nac yöl‑laꞌ ragu lëꞌë, len yöl‑laꞌ rzudxi, len yöl‑laꞌ ruúbi ruguíꞌi, quië catiꞌ gdxin dza niꞌ, cui soaliꞌ nit ladxiꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","len cui gac queëliꞌ ca tu le rzön bunách, ca nac le gac quegac yúguꞌtë bunách nacuáꞌ gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Qui lë ni naꞌ, gul‑zóa ban ladxiꞌ, len gul‑lídzteczëꞌ Dios, quië gac ulaliꞌ lu lë naꞌ ral‑laꞌ lac, len cui utuiꞌliꞌ catiꞌ gdxinliꞌ lahuaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lahuiꞌ dza rzoëꞌ Jesús nchil gdauꞌ, rusëdnëꞌ bunách, atiꞌ chdzöꞌl r‑rujëꞌ niꞌ rijëꞌ lu guíꞌadauꞌ nazíꞌ lei Guiꞌa Ga Röꞌgac Yag Olivo. ");
INSERT INTO zsrNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yuguꞌ zil guladxín ga zoëꞌ Jesús nchil gdauꞌ yúguꞌtë bunách quië luzë́ naggac xtidzëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Catiꞌ chzoa gdxin lni catiꞌ tahuëꞌ yöt xtil cunazíꞌ xnëꞌi, nazíꞌ lei Pascua lni naꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","guludubëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi. Taꞌzú taꞌböꞌë ludöddëꞌ Jesús, san cutu gulazáquiꞌnëꞌ le tádxinëꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Niꞌr yajtság Judas Satanás tuꞌ xöhuiꞌ. Judas lëꞌ caꞌ Iscariote, len nababëꞌ idxínnutëꞌ gbaz nasölëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gyijëꞌ Judas naꞌ, yjë́ꞌlenëꞌ didzaꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ dë lu naꞌquëꞌ qui gdauꞌ, nacx gunëꞌ quië udödëꞌ Jesús lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Guludzijnëꞌ bönniꞌ gdauꞌ naꞌ, len gulazíꞌ lu naꞌquëꞌ lunödzjëꞌ queëꞌ dumí. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Rdzag ladxëꞌë Judas, atiꞌ rzu rböꞌë udödëꞌ Jesús lu naꞌquëꞌ bagachiꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bdxin dza naꞌ tahuëꞌ yöt xtil cunazíꞌ xnëꞌi, catiꞌ ral‑laꞌ ludöddëꞌ‑baꞌ böꞌcuꞌ zxilaꞌ tahuëꞌ xtsöꞌ Lni Pascua. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bsölëꞌë Pedro len Juan, Jesús, rnëꞌ: ―Gul‑tséaj, gul‑tsajpáꞌ queëruꞌ le gáguruꞌ dzöꞌ Lni Pascua. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tëꞌ Lëꞌ: ―¿Gazx rëꞌnnuꞌ tsajpaꞌtuꞌ queëruꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Rëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑yutscaꞌ, catiꞌ tsazliꞌ lu yödz ni, niꞌ grujëꞌ bönniꞌ dutsaguëꞌ lbiꞌiliꞌ, zunuꞌë röꞌö nis. Gul‑tséajlenëꞌ ga gdxíntëliꞌ yuꞌu ga tsaziëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Gul‑guië́ꞌ xan yuꞌu naꞌ: “Bönniꞌ Usëdi rëꞌ liꞌ: ¿Gazx zoa yuꞌu lni ga gágulenaꞌ yuguꞌ bönniꞌ usë́d quiaꞌ xtsöꞌ Lni Pascua?” ");
INSERT INTO zsrNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Niꞌr uluiꞌinëꞌ lbiꞌiliꞌ tu yuꞌu zxön xtsaꞌ ga niꞌ chnabáꞌa. Gul‑páꞌ niꞌ le gáguruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Niꞌr yjaquëꞌ len yajxácaꞌquëꞌ ca naꞌ chgudxëꞌ lequëꞌ Jesús, atiꞌ gulupë́ꞌë niꞌ le lahuëꞌ xtsöꞌ Lni Pascua. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Catiꞌ bdxin dzöꞌ naꞌ, gröꞌë Jesús ga lahuëꞌ, atiꞌ gulabö́ꞌlenëꞌ Lëꞌ tsazxö́n gbaz queëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Niꞌr Jesús rëꞌ lequëꞌ: ―Guctsca ladxaꞌa gágulenaꞌ lbiꞌiliꞌ tsazxö́n xtsöꞌ ni zíꞌatël catiꞌ ziꞌa sacaꞌ quiꞌa len gatiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Rëpaꞌ lbiꞌiliꞌ: Cutur gahuaꞌ lë ni catiꞌ gdxinr dza gac le ruluíꞌz xtsöꞌ ni ga niꞌ rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gdel‑lëꞌë zxígaꞌdauꞌ len gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr rëꞌ lequëꞌ: ―Gul‑síꞌ lë ni len gul‑guíꞌaj latiꞌ hueaj, ");
INSERT INTO zsrNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","le rëpaꞌ lbiꞌiliꞌ: Cutur guiꞌjaꞌ xisi uva catiꞌ gdxinr le rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Niꞌr gdel‑lëꞌë yöt xtil len gudxëꞌ Dios: “Xclenuꞌ.” Gdöd niꞌ buzxuzxjëꞌ lei len bëꞌë qui queëquëꞌ, rnëꞌ: ―Lë ni nac gdu ca nayáꞌ nabanaꞌ le rudödaꞌ uláz queëliꞌ. Gul‑gún cni quië usáꞌ ládxiꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Catiꞌ budx glahuëꞌ, lëzcaꞌ cni bëꞌë didzaꞌ qui zxígaꞌdauꞌ naꞌ, rnëꞌ: ―Zxígaꞌdauꞌ ni ruluíꞌ ca nac didzaꞌ cub rucáꞌn tsahuiꞌ, atiꞌ run tsutsu lei rön quiaꞌ, rön naꞌ glalj niꞌa queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Naꞌa, röꞌë rágulenëꞌ nedaꞌ tsazxö́n bönniꞌ naꞌ udödëꞌ nedaꞌ lu naꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Le nactë huayijaꞌ ga ludöddëꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, gac quiaꞌ ca naꞌ nayúj lu guich laꞌy ca ral‑laꞌ gac quiaꞌ, san bicaꞌ bayechiꞌ bönniꞌ naꞌ udödëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Niꞌr gulazú lauquëꞌ taꞌnabnëꞌ Lëꞌ tu tuëꞌ, taꞌnë́ꞌ: ―¿Núzxaltuꞌ nu gun cni? ");
INSERT INTO zsrNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Niꞌr gluꞌë didzaꞌ laꞌ légaczëꞌ núzxalquëꞌ gdél‑liꞌnëꞌ latj blau. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús gudxëꞌ lequëꞌ: ―Bönniꞌ taꞌná bëꞌë tuꞌgunëꞌ dxin yöl‑laꞌ uná bëꞌ quequëꞌ, taꞌná béꞌinëꞌ bunách, atiꞌ nup niꞌ dë lu naꞌgac yöl‑laꞌ uná bëꞌ, lëquëꞌ bönniꞌ taclen. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lbiꞌiliꞌ cutu ral‑laꞌ gunliꞌ cni, san nu nac blau ladjliꞌ ral‑laꞌ gac ca nu nac cuídiꞌtër, atiꞌ nu rna bëꞌ ral‑laꞌ gac ca nu run dxin qui lzëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Nuzxal naꞌ nacr blau, nu naꞌ röꞌ ragu, o nu rupáꞌ laꞌ huagu? ¿Naruꞌ clëg nu naꞌ röꞌ ragu nacr blau? Nedaꞌ zóalenaꞌ lbiꞌiliꞌ ca nu rupáꞌ laꞌ huagu. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Lbiꞌiliꞌ ni gzóalenliꞌ nedaꞌ catiꞌ niꞌ bi guc quiaꞌ, yuguꞌ le gulazíꞌ bëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Qui lë ni naꞌ udödaꞌ lu naꞌliꞌ tu ga gna bëꞌliꞌ, ca naꞌ benëꞌ Xuzaꞌ, budödëꞌ lu naꞌa ga gna bëꞌa nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Cni gunaꞌ quië gac cöꞌliꞌ, guiꞌj gágulenliꞌ nedaꞌ ga niꞌ gna bëꞌa, atiꞌ cöꞌliꞌ xlatjczliꞌ ga cuequi xbeyliꞌ idxinnu cöꞌ zxiꞌn xsoëꞌ Israel. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gnëꞌ caꞌ cni Xanruꞌ: ―Simón, Simón. Byutscaꞌ. Chgnab lbiꞌiliꞌ Satanás tuꞌ xöhuiꞌ, quië uríx udö́d lbiꞌiliꞌ ca nu ruríx rudö́d zxoaꞌ xtil ");
INSERT INTO zsrNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","san chbulidzaꞌ‑nëꞌ Dios gnabdaꞌ Lëꞌ gáclenëꞌ liꞌ, cui udx udú yöl‑laꞌ rejlëꞌ quiuꞌ nedaꞌ. Naꞌa, catiꞌ huöacuꞌ quiaꞌ, btip ládxiꞌquëꞌ böchiꞌ lzaꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro rëꞌ Lëꞌ: ―Xan, chzoaꞌ sáꞌlenaꞌ Liꞌ, clëgz tsijaꞌ lidx guia, san lëzcaꞌ gátlenaꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús rëꞌ lëꞌ: ―Pedro, rëpaꞌ liꞌ: Ziꞌal cödxbaꞌ zxiꞌn druz naꞌa, chgdáꞌbaguꞌu tsonn lzu, gnauꞌ cutu núnbëꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gnabnëꞌ lequëꞌ Jesús, rnëꞌ: ―Catiꞌ bsölaꞌa lbiꞌiliꞌ cunuaꞌliꞌ yöxj yöt, ni bzud dumí, ni chop cöꞌ löl‑liꞌ, ¿naruꞌ bi byadzj queëliꞌ? Lequëꞌ taꞌnë́ꞌ: ―Cutu bi. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Niꞌr rëꞌ lequëꞌ: ―Naꞌa, nu dë qui yöxj yöt ral‑laꞌ guaꞌ lei, atiꞌ lëzcaꞌ cni ral‑laꞌ gun nu dë qui bzud dumí, atiꞌ nu cudë́ qui guia tuchiꞌ ral‑laꞌ gutiꞌ lariꞌ rxoa yeni len siꞌ tu guia tuchiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Rëpaꞌ lbiꞌiliꞌ: Run bayúdx gac quiaꞌ lë naꞌ nayúj lu guich laꞌy, rna: “Glunëꞌ queëꞌ ca tunëꞌ quegac nup tuaꞌ döꞌ”, le lutság yúguꞌtë le nayujgac lu guich ca ral‑laꞌ gac quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Niꞌr lequëꞌ taꞌnë́ꞌ: ―Xan, ni dë chop guia tuchiꞌ. Lëꞌ rëꞌ lequëꞌ: ―Chnac. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Niꞌr brujëꞌ Jesús len ca runczëꞌ zijëꞌ lu Guiꞌa Ga Röꞌgac Yag Olivo, atiꞌ zjáclenëꞌ Lëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Catiꞌ guladxinëꞌ niꞌ, rëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑lidzëꞌ Dios, gnábiliꞌ‑nëꞌ cui gataꞌ latj siꞌ bëꞌ lbiꞌiliꞌ tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Niꞌr gzëꞌë ga naꞌ nacuꞌë Jesús, gdödëꞌ yelatiꞌ tsca ga rdxin guiöj r‑ruꞌnruꞌ, atiꞌ niꞌ buzechu zxibëꞌ rulidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Rnëꞌ: ―Xuz, chquiꞌ rëꞌnnuꞌ, bcuas ga zoaꞌ lë naꞌ ral‑laꞌ sacaꞌ quiꞌa, san clëg ca rëꞌndaꞌ nedaꞌ, san ca rëꞌnnuꞌ Liꞌ gunuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Niꞌr buluíꞌ lahuëꞌ gbaz laꞌy queëꞌ Dios, zëꞌë yehuaꞌ yubá, atiꞌ butipëꞌ ladxëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lu yöl‑laꞌ rsëbi ladxiꞌ queëꞌ, gdu ladxëꞌë bulidzëꞌ Dios Jesús, atiꞌ guc ca rön rabaꞌ luyú nis yös queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Catiꞌ budx bulidzëꞌ Dios, gyasëꞌ len böjëꞌ ga naꞌ nacuꞌë bönniꞌ usë́d queëꞌ, atiꞌ duxaquëꞌë lequëꞌ tasiëꞌ niꞌa qui yöl‑laꞌ ruhuiꞌni quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Niꞌr Jesús rëꞌ lequëꞌ: ―¿Rástsaliꞌ? Gul‑tsás, gul‑lidzëꞌ Dios gnábiliꞌ‑nëꞌ cui gataꞌ latj siꞌ bëꞌ lbiꞌiliꞌ tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tsal niꞌ ruꞌë didzaꞌ Jesús, laꞌ guladxintëꞌ niꞌ bönniꞌ zian, dzaguëꞌ lequëꞌ Judas, bönniꞌ naꞌ nababëꞌ idxinnuëꞌ bönniꞌ usë́d queëꞌ Jesús, atiꞌ nanörëꞌ lauquëꞌ bönniꞌ zian naꞌ. Gbiguëꞌë ga zoëꞌ Jesús quië utság lahuëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Niꞌr Jesús rëꞌ lëꞌ: ―Judas, ¿naruꞌ rudödtsuꞌ cni nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, rutság lauꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Catiꞌ gulaléꞌinëꞌ ca naꞌ rac queëꞌ Jesús bönniꞌ naꞌ nacuáꞌlenëꞌ Lëꞌ, tëꞌ Lëꞌ: ―Xan, ¿naruꞌ güiꞌtuꞌ lequëꞌ guia tuchiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tuëꞌ bönniꞌ usë́d queëꞌ Jesús benëꞌ huëꞌ guid naguëꞌ bönniꞌ huen dxin queëꞌ bxuz blau. Burixëꞌ guid naguëꞌ yubél. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús rnëꞌ: ―Chnac naꞌa. Tscaꞌ gaz. Gdanëꞌ Jesús guid naguëꞌ bönniꞌ huen dxin naꞌ len bunëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Niꞌr rëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ dë lu naꞌquëꞌ qui gdauꞌ len bönniꞌ gul tuꞌzejniꞌi, bönniꞌ naꞌ cutaꞌléꞌinëꞌ Lëꞌ dxiꞌa, rnëꞌ: ―¿Narújtsaliꞌ nuaꞌliꞌ guia tuchiꞌ len yag quië sönliꞌ nedaꞌ ca runliꞌ rzönliꞌ‑nëꞌ gban? ");
INSERT INTO zsrNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yuguꞌ dza gzóalenczaꞌ lbiꞌiliꞌ nchil gdauꞌ, atiꞌ cutu bi benliꞌ quiaꞌ, san naꞌa chbdxin dza queëliꞌ, nac dza dë lu nëꞌi nu naꞌ zoa latj chul. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Niꞌr gulazönëꞌ Jesús len gulachë́ꞌë Lëꞌ ga naꞌ tuꞌschinëꞌ Lëꞌ lidxëꞌ bxuz blau. Pedro nahuëꞌ Jesús ziꞌtuꞌ ziꞌtuꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Catiꞌ chgulabequiëꞌ guiꞌ löꞌa lidxëꞌ bxuz blau niꞌa nëꞌë bxuz blau naꞌ, gulaböꞌë gdu zbiꞌil raꞌ guiꞌ naꞌ, atiꞌ Pedro grö́ꞌlenëꞌ lequëꞌ tsazxö́n. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Catiꞌ bléꞌibiꞌ‑nëꞌ Pedro tubiꞌ biꞌi ngul huen dxin, niꞌ röꞌzëꞌ raꞌ guiꞌ, buyubiꞌ lëꞌ, rnabiꞌ: ―Bönniꞌ ni dëꞌë caꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Gdáꞌbaguëꞌë Pedro, rnëꞌ: ―Ngul, cutu caꞌ núnbëꞌa‑nëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yelatiꞌ gdzey bléꞌinëꞌ Pedro yetúëꞌ bönniꞌ, atiꞌ rnëꞌ: ―Liꞌ daꞌu caꞌ lequëꞌ. Pedro gnëꞌ: ―Bönniꞌ, clëg nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yelatiꞌz gdzey, gnëꞌ yetúëꞌ bönniꞌ: ―Le nactë bönniꞌ ni dëꞌë Jesús, le naquëꞌ bönniꞌ Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Niꞌr Pedro gnëꞌ: ―Bönniꞌ, cutu nözdaꞌ bizxa naꞌ ruꞌu didzaꞌ qui. Tsal niꞌ ruꞌë didzaꞌ ni, laꞌ grö́dxtëbaꞌ zxiꞌn druz. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Niꞌr bueycjëꞌ Xanruꞌ ruyúëꞌ Pedro, atiꞌ yajneynëꞌ Pedro xtidzëꞌë Xanruꞌ, ca naꞌ gudxëꞌ lëꞌ: “Ziꞌal cödxbaꞌ zxiꞌn druz naꞌa, liꞌ chgdáꞌbaguꞌu tsonn lzu, gnauꞌ cutu núnbëꞌu nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Burujëꞌ niꞌl Pedro atiꞌ röncz grödxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Gulutitjëꞌ Jesús bönniꞌ naꞌ zönquëꞌ Lëꞌ, atiꞌ gulaguinëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Niꞌr guluseyjëꞌ lahuëꞌ Jesús, atiꞌ gulagapëꞌë lahuëꞌ len gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―Gnë́yaꞌatscaꞌ. ¿Nuzxa naꞌ gdapaꞌ Liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Zianr caꞌ gulanë́ꞌ queëꞌ le gluꞌë döꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Catiꞌ chzaꞌ reníꞌ dza naꞌ, guludubëꞌ bönniꞌ gul tuꞌzéjniꞌnëꞌ bunách judío len yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi, atiꞌ gulachë́ꞌë Jesús lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey, atiꞌ niꞌ gulanabnëꞌ Lëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","taꞌnë́ꞌ: ―Gdixjöiꞌ netuꞌ. ¿Naruꞌ nactsuꞌ Liꞌ Cristo? Jesús rëꞌ lequëꞌ: ―Chquiꞌ gyëpaꞌ lbiꞌiliꞌ nacaꞌ Cristo, cutu tséjlëꞌliꞌ nedaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","len chquiꞌ unabdaꞌ lbiꞌiliꞌ tu didzaꞌ, cutu ubiꞌiliꞌ didzaꞌ, len cutu usanliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naꞌa su lau, nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, cöꞌa cuit lëꞌë yubél Dios, náptërëꞌ yöl‑laꞌ uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gulanabnëꞌ Lëꞌ yúguꞌtëꞌ, taꞌnë́ꞌ: ―¿Naruꞌ nactsuꞌ Liꞌ Zxiꞌnëꞌ Dios? Lëꞌ gudxëꞌ lequëꞌ: ―Le nacz rnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Niꞌr taꞌnë́ꞌ: ―¿Nuzxar naquíniruꞌ nu gun lnaꞌ lau queëꞌ? Laꞌ rëꞌuz chbyö́niruꞌ didzaꞌ ruꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Niꞌr gulayasëꞌ yúguꞌtë bönniꞌ zian niꞌ, atiꞌ gulachë́ꞌë Jesús lahuëꞌ Pilato. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Niꞌ gulazú lauquëꞌ tuꞌquíëꞌ Lëꞌ, taꞌnë́ꞌ: ―Bönniꞌ ni, budzö́lituꞌ ca runëꞌ, runëꞌ ga taꞌdáꞌbagaꞌ yúlahuiꞌ bunách uládz queëtuꞌ, len ruzaguëꞌë xnözgac nup taꞌguízxj laz ruquizxjëꞌ César, len rnëꞌ lëczëꞌ naquëꞌ Cristo, bönniꞌ ral‑laꞌ gna bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Niꞌr Pilato gnabnëꞌ Jesús, rnëꞌ: ―¿Naruꞌ nacuꞌ Liꞌ nu gna beꞌi bunách judío? Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Le nacz rnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Niꞌr Pilato gudxëꞌ yuguꞌ bxuz uná bëꞌ len bunách nacuáꞌ niꞌ, rnëꞌ: ―Cutu bi rudzöldaꞌ le nac zxguiaꞌ nunëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Niꞌr glunrëꞌ tsutsu xtídzaꞌquëꞌ, taꞌnë́ꞌ: ―Runëꞌ ga tun rusbö́ bunách len rusëdnëꞌ cni bunách gdu luyú Judea. Gzu lahuëꞌ benëꞌ cni luyú Galilea ga rdxintë runëꞌ caꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Catiꞌ byönnëꞌ didzaꞌ ni Pilato, tuꞌë didzaꞌ qui luyú Galilea, niꞌr gnabnëꞌ lequëꞌ chquiꞌ naquëꞌ Jesús bönniꞌ Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Catiꞌ gnöznëꞌ nababëꞌ Jesús ga niꞌ rna bëꞌë Herodes, bsölëꞌë Lëꞌ lahuëꞌ Herodes naꞌ, le zoëꞌ caꞌ Jerusalén Herodes yuguꞌ dza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Catiꞌ bléꞌinëꞌ Jesús Herodes naꞌ, budzijnëꞌ, le chguc xtsey rëꞌnnëꞌ gléꞌinëꞌ Lëꞌ le chbyönnëꞌ le zian ca nac queëꞌ Jesús len runëꞌ löz gléꞌinëꞌ tu yöl‑laꞌ huac gunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Niꞌr zian le gnabnëꞌ Jesús Herodes, san Jesús, cutu bi didzaꞌ bubiꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nacuꞌë caꞌ niꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gdauꞌ tuꞌsëdi, atiꞌ guluquitsquëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Niꞌr gulucaꞌnëꞌ Jesús caꞌz Herodes len bönniꞌ queëꞌ rjaquëꞌ gdil‑l, len quië lutitjëꞌ Lëꞌ, gulugacuëꞌ Lëꞌ lariꞌ zacaꞌ ca racuëꞌ bönniꞌ rna bëꞌë, atiꞌ leyúbl guluschinëꞌ Lëꞌ lahuëꞌ Pilato. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dza naꞌ guludzaguëꞌ dxiꞌa Pilato len Herodes, le ziꞌal gulaléy lzaꞌquëꞌ tuëꞌ yetúëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Niꞌr butubëꞌ Pilato yuguꞌ bxuz uná bëꞌ len bönniꞌ dë lu naꞌquëꞌ len bunách lu yödz, ");
INSERT INTO zsrNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","atiꞌ rëꞌ lequëꞌ: ―Djuaꞌliꞌ‑nëꞌ lahuaꞌ nedaꞌ bönniꞌ ni, rnaliꞌ queëꞌ runëꞌ ga tun rusbö́ bunách, san catiꞌ gnabi yudxdaꞌ‑nëꞌ, atiꞌ zóatëliꞌ caꞌ ni, cutu bi budzöldaꞌ le nac zxguiaꞌ nabaguëꞌë, yuguꞌ lë naꞌ ruquiliꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Catiꞌ bsölaꞌa lbiꞌiliꞌ lahuëꞌ Herodes, cutu bi budzölnëꞌ le benëꞌ bönniꞌ ni le nac zxguiaꞌ nabaguëꞌë quië nu gchugu queëꞌ gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Naꞌa usacaꞌ ziꞌa‑nëꞌ len töd naꞌ usanaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Run bayúdx bi gunëꞌ Pilato, usanëꞌ lu naꞌgac bunách tuëꞌ bönniꞌ nadzunëꞌ catiꞌ rac lni naꞌ, ca naꞌ runczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Niꞌr gluꞌë zidzj didzaꞌ yúguꞌtë bönniꞌ nacuꞌë niꞌ, taꞌnë́ꞌ: ―Bdöddëꞌ bönniꞌ ni len bsanëꞌ queëtuꞌ Barrabás. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nadzunëꞌ lidx guia Barrabás naꞌ le gdil‑lenëꞌ yúlahuiꞌ lu yödz naꞌ len le budödcdëꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bulidzëꞌ lequëꞌ leyúbl Pilato, le rëꞌnnëꞌ usanëꞌ Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","atiꞌ leyúbl gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Bdëꞌë lëꞌi yag cruz, bdëꞌë lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Niꞌr Pilato gudxëꞌ lequëꞌ le bunn lzu, rnëꞌ: ―¿Bizxa caz le cunác benëꞌ bönniꞌ ni? Cutu bi budzöldaꞌ nunëꞌ le run ga nabaguëꞌë zxguiaꞌ gatiëꞌ. Usacaꞌ ziꞌa‑nëꞌ, atiꞌ niꞌr usanaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Zidzjr gluꞌë didzaꞌ, taꞌnabëꞌ tëꞌë Jesús lëꞌi yag cruz. Le gulabödxyëꞌë szxöni yuguꞌ bönniꞌ naꞌ len yuguꞌ bxuz uná bëꞌ, guladél‑liꞌnëꞌ gac ca naꞌ tëꞌnnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Niꞌr bchuguëꞌ queëꞌ Jesús Pilato, quië gac queëꞌ ca naꞌ taꞌnabëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Busanëꞌ quequëꞌ bönniꞌ naꞌ nadzunëꞌ lidx guia le gdil‑lenëꞌ yúlahuiꞌ len budödcdëꞌ bunách, bönniꞌ naꞌ chgulanabëꞌ, atiꞌ budödëꞌ Jesús quië gac queëꞌ ca naꞌ tëꞌnnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Catiꞌ niꞌ taꞌchë́ꞌë Jesús tsajdaꞌquëꞌ Lëꞌ lëꞌi yag cruz, gulazönëꞌ Simón, bönniꞌ yödz Cirene, zuzë́ꞌë ladj guixiꞌ, atiꞌ gulaxóëꞌ yen zxicjëꞌ yag cruz naꞌ quië guꞌë lei, tsijëꞌ cúdzuꞌlëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zajnaugac Jesús bunách zian lencaꞌ yuguꞌ ngul, taꞌbödxnu len taꞌbö́dx yéchiꞌnu queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Niꞌr bueycjëꞌ Jesús ruyúëꞌ lecnu, atiꞌ rëꞌ lecnu: ―Lbiꞌiliꞌ ngul Jerusalén. Cutu cödxliꞌ quiaꞌ nedaꞌ, san gul‑cö́dx queëczliꞌ len quecbiꞌ zxiꞌnliꞌ ");
INSERT INTO zsrNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","le huadxín dza laꞌná: “Bicaꞌ bagac yuguꞌ ngul huödx len ngul cutu gluaꞌnu‑biꞌ biꞌidauꞌ, len cutu gulugádxiꞌnu‑biꞌ biꞌidauꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Niꞌr laꞌzú laugac laꞌná bunách, lëꞌ yuguꞌ guiꞌa sib: “Gul‑dubagaꞌ netuꞌ”, len lëꞌ caꞌ yuguꞌ guíꞌadauꞌ: “Gul‑cachiꞌ netuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chquiꞌ cni tunëꞌ quiaꞌ nedaꞌ, nacaꞌ ca tu yag yaꞌa, ¿naruꞌ cu lúntërëꞌ caꞌ queëliꞌ, nacliꞌ ca yag bidx? ");
INSERT INTO zsrNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Gulachë́ꞌë caꞌ chopëꞌ bönniꞌ tuaꞌdöꞌ, quië ludödcdëꞌ lequëꞌ tsazxö́n len Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Catiꞌ guladxinëꞌ latj nazíꞌ lei Calavera, le rna lu didzaꞌ xidzaꞌ: “Latj Qui Bögaꞌ Icjruꞌ”, niꞌ guludë́ꞌë Jesús lëꞌi yag cruz. Guludë́ꞌë caꞌ lë́ꞌigac yag cruz chopëꞌ bönniꞌ tuaꞌdöꞌ naꞌ. Tuëꞌ guludë́ꞌë cuit lëꞌë yubél Jesús, len yetúëꞌ guludë́ꞌë cuit lëꞌë yögl. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Niꞌr Jesús rnëꞌ: ―Xuz, bnit lau lequëꞌ, le cutu nözcnëꞌ bi tunëꞌ. Gululë́ꞌë qui queëquëꞌ le nacuëꞌ Jesús bönniꞌ rjaquëꞌ gdil‑l nacuꞌë niꞌ, len guluquitjëꞌ le gac bëꞌ lahui. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gulutitjëꞌ Jesús bunách nacuáꞌ niꞌ tuꞌyú len bönniꞌ dë lu naꞌquëꞌ, taꞌnë́ꞌ: ―Yuguꞌ nu yubl buslë́ꞌ bönniꞌ ni. Naꞌa ral‑laꞌ uslá cuinëꞌ chquiꞌ naquëꞌ Cristo, bönniꞌ gröczëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Gulutitjëꞌ caꞌ Jesús bönniꞌ naꞌ rjaquëꞌ gdil‑l. Gulabiguëꞌë ga naꞌ zoëꞌ len guluguiꞌjëꞌ Lëꞌ nup zi, ");
INSERT INTO zsrNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","taꞌnë́ꞌ: ―Chquiꞌ nacuꞌ Liꞌ bönniꞌ gna béꞌinëꞌ bunách judío, buslá cuinuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Daꞌ caꞌ lëꞌi yag cruz icjlëꞌ Jesús tu le nayúj lu guich lu didzaꞌ griego len lu didzaꞌ latín len lu didzaꞌ hebreo, le rna cni: “Bönniꞌ Rna Béꞌinëꞌ Bunách Judío.” ");
INSERT INTO zsrNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tuëꞌ bönniꞌ huiaꞌdöꞌ naꞌ dëꞌë lëꞌi yag cruz bulídz ziꞌë Jesús, rnëꞌ: ―Chquiꞌ nacuꞌ Liꞌ Cristo, buslá cuinuꞌ lencaꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bubiꞌë didzaꞌ yetúëꞌ bönniꞌ huiaꞌdöꞌ naꞌ, gdil‑lëꞌ lzëꞌë naꞌ, rnëꞌ: ―¿Naruꞌ cu rádxinuꞌ‑nëꞌ Dios? Lëzcaꞌ liꞌ narugu quiuꞌ gatiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Le nactë rëꞌu, le ral‑laꞌz gac queëruꞌ rzacaꞌ rguiꞌruꞌ, ca naꞌ rajlö́z döꞌ biaꞌruꞌ, san Bönniꞌ ni, cutu bi döꞌ nuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Niꞌr bönniꞌ ni rëꞌ Jesús: ―Yajnéy nedaꞌ catiꞌ gdxinuꞌ ga niꞌ gna bëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús rëꞌ lëꞌ: ―Le nactë rëpaꞌ liꞌ, naꞌa dza ni sóalenuꞌ nedaꞌ latj lach quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Catiꞌ bdxin gdu huagbídz, bchul gdutë yödzlyú ga bdxinr gdu rdöd xhuö. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bchul gbidz, atiꞌ lariꞌ nal‑laꞌ lu gdauꞌ brözaꞌ chop diꞌil. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Niꞌr bëꞌë zidzj didzaꞌ Jesús, rnëꞌ: ―Xuz, rguꞌa lu naꞌu böꞌ nacczaꞌ. Catiꞌ budx gnëꞌ cni, brujtë böꞌ nacczëꞌ, gutiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Catiꞌ bléꞌinëꞌ ca naꞌ guc bönniꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, gluꞌë Dios yöl‑laꞌ ba, rnëꞌ: ―Le nactë bönniꞌ ni guquëꞌ bönniꞌ tsahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Catiꞌ gulaléꞌinëꞌ lë naꞌ guc yúguꞌtë bönniꞌ nacuꞌë niꞌ tuꞌyúëꞌ, yhuöjquëꞌ yödz, taꞌgapaꞌ lchuꞌquëꞌ le tuꞌbannëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ziꞌtuꞌz gulugáꞌn yúguꞌtë nup niꞌ núnbëꞌgac Jesús len ngul naꞌ yjáclennu Lëꞌ catiꞌ niꞌ gzoëꞌ luyú Galilea, tuꞌyúëꞌ lë ni rac. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Zoëꞌ caꞌ niꞌ bönniꞌ yödz Arimatea qui luyú Judea, lëꞌ José. Bönniꞌ ni naquëꞌ dxiꞌa len tsahuiꞌ, len nabáblenëꞌ bönniꞌ gdauꞌ taꞌbequi xbey. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Cutu benëꞌ tuz nup naꞌ gulachugu queëꞌ Jesús, le rbözëꞌ caꞌ José ni le rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Niꞌr gyijëꞌ lahuëꞌ Pilato José naꞌ len gnabëꞌ latj uꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Catiꞌ chnuzötjëꞌ Lëꞌ, buchö́linëꞌ Lëꞌ lariꞌ, atiꞌ gluꞌë Jesús yeru ba, le nadj lëꞌi guiꞌa guiöj, atiꞌ lu ba naꞌ, nutu nu nagüiꞌcnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dza naꞌ nac dza tuꞌpë́ꞌë qui dza laꞌy quequëꞌ bönniꞌ judío, le ziꞌa gdxin dza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yjacnu caꞌ niꞌ ngul naꞌ gulazáꞌlennu Jesús, catiꞌ niꞌ gzoëꞌ luyú Galilea, atiꞌ gulaléꞌinu yeru ba naꞌ, len ca na guc, gulaguꞌë Lëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Catiꞌ yhuöjcnu yuꞌu, gulupaꞌnu nör rlaꞌ zxix len yuguꞌ le za rlaꞌ zxix. Niꞌr guluzíꞌ ládxiꞌcnu dza laꞌy naꞌ quequëꞌ bönniꞌ judío ca naꞌ rna bëꞌ zxba queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Catiꞌ bdxin dza rguel‑laꞌ semán naꞌ, catiꞌ niꞌ nac zildauꞌ, guladxinnu ngul naꞌ raꞌ yeru ba queëꞌ Jesús. Nuaꞌcnu yuguꞌ le rlaꞌ zxix, lë naꞌ chnupaꞌcnu, atiꞌ dzagcnu lecnu yelaꞌcnu ngul. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Catiꞌ guladxinnu niꞌ, duxácaꞌcnu chnadúa guiöj naꞌ daꞌ ga nu ryaz yeru ba queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Catiꞌ gulayaznu yeru ba naꞌ, cutu guludzö́linu niꞌ Xanruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Catiꞌ niꞌ taꞌböꞌnu baguíꞌi niꞌa qui lë ni, laꞌ guladxintëꞌ niꞌ len gulazuinëꞌ ga naꞌ nacuaꞌnu chopëꞌ bönniꞌ nácuquëꞌ lariꞌ ryëp yös yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Niꞌr gládxinu len guluzö́tj icjcnu, tuꞌyunu lyu, atiꞌ tëꞌ lecnu gbaz laꞌy naꞌ, taꞌnë́ꞌ: ―¿Bizx quië ruguiljliꞌ xlatj nu nat nu zoa nabán? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Cutu zoëꞌ ni, le chbubanëꞌ. Gul‑tsajnéy lë naꞌ chgudxczëꞌ lbiꞌiliꞌ catiꞌ niꞌ zoëꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Gnëꞌ: “Run bayúdx nu udö́d nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, lu naꞌquëꞌ bönniꞌ dul‑laꞌ, atiꞌ ludë́ꞌë nedaꞌ lëꞌi yag cruz, atiꞌ ubanaꞌ catiꞌ gac tsonn dza.” ");
INSERT INTO zsrNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Niꞌr yajneycnu didzaꞌ naꞌ bëꞌë Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","atiꞌ guluzaꞌnu raꞌ yeru ba naꞌ, yajtíxjöiꞌcnu idxineajtëꞌ bönniꞌ gbaz queëꞌ Cristo len yezícaꞌrëꞌ caꞌ, ca nac lë naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ngul naꞌ yajtíxjöiꞌcnu bönniꞌ gbaz naꞌ yuguꞌ lë ni, naccnu María Magdalena, len Juana, len María, xnëꞌë Jacobo, len yelaꞌcnu ngul naꞌ dzagcnu lecnu. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gláquinëꞌ bönniꞌ gbaz naꞌ didzaꞌ chixi tuiꞌnu len cutu gulayejlëꞌë lecnu. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Niꞌr gyasëꞌ Pedro len jaréluꞌë zijëꞌ raꞌ yeru ba naꞌ. Catiꞌ buyúëꞌ lu ba naꞌ, bléꞌinëꞌ yuguꞌ lariꞌz nacuáꞌ niꞌ, atiꞌ niꞌr böjëꞌ lidxëꞌ, rubannëꞌ ca nac lë naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Laꞌ dza naꞌz zjaquëꞌ chopëꞌ, yuꞌuquëꞌ nöz rdxintë Emaús, le nac ca chop hora rzaꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yúꞌugaczëꞌ caꞌ nöz, tuꞌë didzaꞌ ca nac yúguꞌtë lë naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tsal niꞌ yuꞌuquëꞌ nöz, tuꞌë didzaꞌ ni laꞌ légaczëꞌ, gbiguëꞌë gal‑laꞌ lëczëꞌ Jesús len tsazxö́n gdálenëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Cutu guluúnbëꞌë Lëꞌ le nac ca tu le nabagaꞌ yöj lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Niꞌr Jesús gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Bizxa didzaꞌ naꞌ ruiꞌliꞌ laꞌ lbiꞌizliꞌ yuꞌuliꞌ nöz? ¿Bizx quië naꞌ ruhuíꞌniliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bubiꞌë didzaꞌ bönniꞌ naꞌ lëꞌ Cleofas, rëꞌ Lëꞌ: ―¿Nactsuꞌ bönniꞌ ziꞌtuꞌ lu yödz Jerusalén, len tuzuꞌ liꞌ cutu nöznuꞌ lë naꞌ guc nij nas niꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niꞌr Jesús rëꞌ lequëꞌ: ―¿Bizxa naꞌ guc? Tëꞌ Lëꞌ: ―Lë naꞌ guc queëꞌ Jesús, bönniꞌ Nazaret. Guquëꞌ bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, atiꞌ len yöl‑laꞌ huac zxön benëꞌ dxin len bëꞌë didzaꞌ lahuëꞌ Dios len laugac yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Guludödëꞌ Lëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ taꞌná béꞌinëꞌ netuꞌ, glunëꞌ ga nu bchugu queëꞌ gatiëꞌ, atiꞌ guludë́ꞌë Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Netuꞌ bentuꞌ löz guquëꞌ Lëꞌ bönniꞌ naꞌ ral‑laꞌ huöaꞌuëꞌ bunách Israel, san naꞌa chguc tsonn dza catiꞌ glac lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yetú caꞌ, glunnu ga gröꞌtuꞌ baguíꞌi laꞌcnu ngul nútsaꞌcnu ladjtuꞌ. Yjacnu raꞌ yeru ba queëꞌ catiꞌ ziꞌa glen gbidz naꞌa dza, ");
INSERT INTO zsrNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","len catiꞌ cutu guludzö́linu Lëꞌ, duhuöjcnu, len glënu netuꞌ gulaléꞌinu caꞌ yuguꞌ gbaz laꞌy queëꞌ Dios, nup niꞌ glë lecnu zoëꞌ nabanëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Niꞌr yjaquëꞌ raꞌ yeru ba naꞌ laꞌquëꞌ bönniꞌ lzaꞌtuꞌ len yajxácaꞌquëꞌ lei ca naꞌ gulananu ngul naꞌ, san cutu gulaléꞌinëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Niꞌr Jesús gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ, bönniꞌ curejniꞌi. Nazíd icj ládxiꞌdauꞌliꞌ cui tséjlëꞌliꞌ yúguꞌtë le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Naruꞌ cu ben bayúdx sacaꞌ quiꞌë Cristo yuguꞌ lë ni len tsaziëꞌ ga niꞌ gáctërëꞌ blau? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niꞌr gzu lahuëꞌ Jesús rguíxjöiꞌnëꞌ lequëꞌ yúguꞌtë le ruiꞌ didzaꞌ ca nac queëꞌ nayujgac lu guich laꞌy, ca naꞌ gzu lau bëꞌë didzaꞌ Moisés ga bdxintë yuguꞌ le gulanë́ꞌ yúguꞌtë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Catiꞌ guladxinëꞌ yödzdauꞌ ga naꞌ zjaquëꞌ, benëꞌ Jesús ca bönniꞌ zéajtërëꞌ ziꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Glunëꞌ bayúdx ugáꞌnlenëꞌ lequëꞌ, taꞌnë́ꞌ: ―Bgaꞌnlen netuꞌ, le chrdzöꞌ naꞌa, len chzoa gal. Niꞌr gyaziëꞌ yuꞌu Jesús, bugáꞌnlenëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Catiꞌ niꞌ röꞌë rágulenëꞌ lequëꞌ Jesús, gdel‑lëꞌë yöt xtil len gudxëꞌ Dios: “Xclenuꞌ.” Niꞌr buzxuzxjëꞌ lei, len bëꞌë quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Laꞌ niꞌz bdua lë naꞌ gbagaꞌ yöj lauquëꞌ, atiꞌ guluúnbëꞌë Jesús, atiꞌ Lëꞌ bunít cuinëꞌ lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Niꞌr glë lzaꞌquëꞌ tuëꞌ yetúëꞌ: ―¿Naruꞌ cu böálaꞌtsca ládxiꞌdauꞌruꞌ tsal niꞌ ruíꞌlenëꞌ rëꞌu didzaꞌ laꞌ nöz, len catiꞌ niꞌ ruzálj laꞌnëꞌ le nayúj lu guich laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Laꞌ niꞌz gulayasëꞌ yhuöjquëꞌ Jerusalén, atiꞌ yajxácaꞌquëꞌ nudubquëꞌ idxineajtëꞌ bönniꞌ gbaz queëꞌ Jesús len nup nacuaꞌlen lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Niꞌr glëꞌ chopëꞌ naꞌ bönniꞌ naꞌ nacuꞌë niꞌ: ―Chbubanczëꞌ Xanruꞌ, atiꞌ buluíꞌ lahuëꞌ, bléꞌinëꞌ Lëꞌ Simón. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niꞌr gulaguíxjöꞌë ca naꞌ guc quequëꞌ laꞌ nöz chopëꞌ naꞌ, len ca naꞌ guluúnbëꞌë Jesús catiꞌ niꞌ buzxuzxjëꞌ yöt xtil naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsal niꞌ tuꞌë didzaꞌ ca nacgac lë ni, laꞌ yajsoatëꞌ Jesús gatsj lahuiꞌl ga naꞌ nacuꞌë, atiꞌ rëꞌ lequëꞌ: ―Gul‑zóa dxi ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Niꞌr gladxi guladzöbnëꞌ le táquinëꞌ bxin taꞌléꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús rëꞌ lequëꞌ: ―¿Bizx quië röꞌliꞌ baguíꞌi? ¿Bizx quië rzaꞌ ládxiꞌliꞌ yuguꞌ lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gul‑yutscaꞌ naꞌa len niꞌa. Nédaꞌczaꞌ ni. Gul‑cán nedaꞌ len gul‑yú nedaꞌ, le cutu daꞌ bëlaꞌ bxin, len cutu yuꞌu dxit ca ni rléꞌiliꞌ nac quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Niꞌ ruiꞌzëꞌ caꞌ didzaꞌ ni, buluiꞌinëꞌ lequëꞌ nëꞌë len niꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Niꞌa qui yöl‑laꞌ rudziji quequëꞌ cutu gulayejlëꞌë, len tsal ban raz gulacuꞌë. Qui lë ni naꞌ Jesús gudxëꞌ lequëꞌ: ―¿I dë queëliꞌ ni le gahuaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Niꞌr gulunödzjëꞌ queëꞌ látiꞌdauꞌbaꞌ böl chnéguiꞌbaꞌ, len tu quízxiꞌbaꞌ böz. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gzxiꞌë lei Jesús len gdahuëꞌ lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Niꞌr rëꞌ lequëꞌ: ―Lë naꞌ glac quiaꞌ glac ca naꞌ gudxczaꞌ lbiꞌiliꞌ catiꞌ niꞌ zóalenaꞌ lbiꞌiliꞌ, gniaꞌ: “Run bayúdx utság yúguꞌtë le nayúj lu guich lu zxba queëꞌ Moisés len le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, len le nayúj lu guich nazíꞌ lei Salmos, ca ral‑laꞌ gac quiaꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Niꞌr buzéjniꞌnëꞌ lequëꞌ lë naꞌ nayujgac lu guich laꞌy, ");
INSERT INTO zsrNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","rëꞌ lequëꞌ: ―Cni nayúj lu guich ca run bayúdx gac queëꞌ Cristo, sacaꞌ quiꞌë len ubanëꞌ lu yöl‑laꞌ gut catiꞌ gac tsonn dza, ");
INSERT INTO zsrNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","atiꞌ gdutë yödzlyú ral‑laꞌ gac lban ca nac quiaꞌ nedaꞌ quië lubíꞌi ládxiꞌgac bunách quië unít lahuëꞌ Dios dul‑laꞌ nabágaꞌquëꞌ. Lu yödz Jerusalén su lau gac lban naꞌ ");
INSERT INTO zsrNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","atiꞌ lbiꞌiczliꞌ naꞌ bléꞌiliꞌ yuguꞌ lë ni ral‑laꞌ gunliꞌ lnaꞌ lau qui. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gul‑yutscaꞌ, gsölaꞌa queëliꞌ le gzxiꞌ lu nëꞌë Xuzaꞌ gunnëꞌ queëliꞌ, san gul‑gáꞌnz Jerusalén catiꞌ gdxinr queëliꞌ yöl‑laꞌ huac naꞌ zaꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Niꞌr bchëꞌë bönniꞌ daꞌquëꞌ Lëꞌ Jesús, zjaquëꞌ yödz Betania, atiꞌ niꞌ bchis nëꞌë len bulídz tsahuëꞌë lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tsal niꞌ rulídz tsáhuiꞌzëꞌ caꞌ lequëꞌ, gzaꞌtëꞌ ga naꞌ nacuꞌë, buëpëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gdöd gulayíj ládxiꞌquëꞌ Lëꞌ, lu yöl‑laꞌ rudziji quequëꞌ yhuöjquëꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Gulacuáꞌteczëꞌ nchil gdauꞌ, taꞌguꞌë Dios yöl‑laꞌ ba len tunëꞌ Lëꞌ zxön. Caꞌ nac.");
INSERT INTO zsrNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Catiꞌ gzu lau, zíꞌatël catiꞌ ziꞌa gataꞌ yödzlyú, niꞌ zoaczëꞌ Bönniꞌ lëꞌ Didzaꞌ, atiꞌ zóalenëꞌ Dios Bönniꞌ naꞌ naquëꞌ Didzaꞌ, len naccz Dios Didzaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Zóalenëꞌ Dios Bönniꞌ naꞌ naquëꞌ Didzaꞌ catiꞌ niꞌ gzu lau ziꞌa rataꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lu nëꞌë Bönniꞌ ni, Dios benëꞌ yúguꞌtë le dë, len cutu bi dë le nunëꞌ Dios le cutu benëꞌ lu nëꞌë Bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dëcz queëꞌ yöl‑laꞌ naꞌbán, atiꞌ yöl‑laꞌ naꞌbán naꞌ nac ca tu yeníꞌ ruzeníꞌ lu icj ládxiꞌdauꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ruzeníꞌ ga nac chul xöhuiꞌ yeníꞌ naꞌ, san cutu caꞌ saquiꞌ usúl yeníꞌ naꞌ le chul xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios bsölëꞌë ni bönniꞌ lëꞌ Juan. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bidëꞌ bönniꞌ ni quië gaquëꞌ nu gun lnaꞌ lau. Bidëꞌ quië gunëꞌ lnaꞌ lau queëꞌ Bönniꞌ naꞌ naquëꞌ yeníꞌ, quië tséjlëꞌgac Dios yúguꞌtë bunách niꞌa qui lë naꞌ runëꞌ lnaꞌ lau. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Cutu naquëꞌ yeníꞌ naꞌ Juan, san bidëꞌ quië gunëꞌ lnaꞌ lau queëꞌ Bönniꞌ naꞌ naquëꞌ yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Niꞌ ryaziëꞌ yödzlyú ni Bönniꞌ naꞌ naquëꞌ yeníꞌ le nac gdu, atiꞌ ruzeniꞌë lu icj ládxiꞌdauꞌgac yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bdxinëꞌ yödzlyú ni Bönniꞌ naꞌ naquëꞌ yeníꞌ, atiꞌ lu nëꞌë Lëꞌ Dios benëꞌ yödzlyú ni, san cutu guluúnbëꞌë Lëꞌ bunách yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bdxinëꞌ ga naqui queëꞌ, san cutu caꞌ gulazíꞌ lu naꞌquëꞌ Lëꞌ bönniꞌ nabáblenëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yúguꞌtë bönniꞌ gulazíꞌ lu naꞌquëꞌ Lëꞌ, bönniꞌ niꞌ gulayejlëꞌë Jesús, Lëꞌ benëꞌ ga dë lu naꞌquëꞌ lacquëꞌ zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nacquëꞌ zxiꞌnëꞌ Dios bönniꞌ ni, clëg le nacquëꞌ zxiꞌngac bunách, len clëg le naljquëꞌ niꞌa qui le taꞌzë́ ládxiꞌgac bunách, o niꞌa qui tu le rëꞌnnëꞌ tu bönniꞌ, san nacquëꞌ cni le rëꞌncznëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Böaquëꞌ bunách Bönniꞌ naꞌ naquëꞌ Didzaꞌ, len tu chiꞌz gzóalenëꞌ rëꞌu, gdu dzaggac Lëꞌ le ruzáꞌ ladxëꞌë queëruꞌ Dios len le nac gdutë li. Bléꞌituꞌ yöl‑laꞌ yeníꞌ queëꞌ, atiꞌ yöl‑laꞌ yeníꞌ queëꞌ naꞌ nac le ruiꞌ queëbiꞌ biꞌi laꞌz dui qui, Nu naꞌ nac Xuzbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Benëꞌ lnaꞌ lau queëꞌ Bönniꞌ naꞌ Juan, len bëꞌë zidzj didzaꞌ, rnëꞌ: ―Naquëꞌ Bönniꞌ ni Nu naꞌ gdíxjöꞌa qui, gniaꞌ: “Bönniꞌ ziꞌa záꞌtëlëꞌ ca nedaꞌ náctërëꞌ blau ca nedaꞌ, le zoaczëꞌ Lëꞌ ziꞌal ca nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Le nac gdu queëꞌ buziꞌruꞌ xbey yúguꞌtëruꞌ, lë naꞌ buzáꞌ ladxëꞌë queëruꞌ, len zianr caꞌ le ruzáꞌ ladxëꞌë queëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bdxin queëruꞌ zxba queëꞌ Dios lu nëꞌë Moisés, san le ruzáꞌ ladxëꞌë queëruꞌ Dios len le nac gdutë li guladxín queëruꞌ lu nëꞌë Jesucristo. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gatga nu bleꞌi Dios, san Lëꞌ, laꞌz dui Zxiꞌnëꞌ Dios, Nu naꞌ nadxíꞌitsquinëꞌ Dios Xuz, Lëꞌ naꞌ benëꞌ ga núnbëꞌruꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lë ni nac le benëꞌ lnaꞌ lau Juan, catiꞌ niꞌ bönniꞌ judío uná bëꞌ nacuꞌë Jerusalén gulasölëꞌë ga zoëꞌ Juan yuguꞌ bxuz len yuguꞌ bönniꞌ zxiꞌn xsoëꞌ Leví, nup nacgac niꞌa naꞌquëꞌ bxuz, quië laꞌnabnëꞌ Juan naꞌ, laꞌnë́ꞌ: ―¿Nuzxa bönniꞌ liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yalj lulu bëꞌë didzaꞌ Juan len cutu gdáꞌbaguëꞌë, san gdíxjöꞌë catëz nac, rnëꞌ: ―Cutu nacaꞌ Cristo, Bönniꞌ naꞌ gzxiꞌ lu nëꞌë Dios gsölëꞌë queëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Niꞌr gulanabnëꞌ lëꞌ leyúbl, tëꞌ lëꞌ: ―¿Nuzxa caz liꞌ? ¿Naruꞌ nacuꞌ liꞌ Elías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios? Gnëꞌ Juan: ―Cutu nacaꞌ. Niꞌr tëꞌ lëꞌ: ―¿Naruꞌ nacuꞌ liꞌ bönniꞌ naꞌ ral‑laꞌ guidëꞌ guꞌë didzaꞌ uláz queëꞌ Dios? Bubiꞌë didzaꞌ Juan, rnëꞌ: ―Clëg nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Niꞌr tëꞌ lëꞌ: ―¿Nuzxa caz nacuꞌ? Gdixjöiꞌ netuꞌ quië gac quíxjöiꞌtuꞌ nup gulasölaꞌ netuꞌ. ¿Bizxa rnauꞌ liꞌ nuzxa nacuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bubiꞌë didzaꞌ Juan, rëꞌ lequëꞌ: ―Nedaꞌ nacaꞌ bönniꞌ naꞌ, nayúj lu guich laꞌy ca nac queëꞌ, rna: “Ryön chiꞌi nu rulídz lu latj caꞌz, rna: Gul‑bíj li nöz gdxin queëliꞌ Xanruꞌ.” Cni gnëꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nacquëꞌ bönniꞌ gdauꞌ fariseo bönniꞌ naꞌ nasö́laꞌquëꞌ bönniꞌ judío uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Gulanabnëꞌ Juan, tëꞌ lëꞌ: ―¿Bizx quië ruquiluꞌ bunách nis chquiꞌ cutu nacuꞌ liꞌ Cristo, len cutu nacuꞌ Elías, len cutu nacuꞌ bönniꞌ naꞌ ral‑laꞌ guidëꞌ guꞌë didzaꞌ uláz queëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Bubiꞌë didzaꞌ Juan naꞌ, rëꞌ lequëꞌ: ―Nedaꞌ ruquilaꞌ bunách nis lu nis, san gatsj lahuiꞌl ga zoaliꞌ zoëꞌ bönniꞌ cutu núnbëꞌliꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Bönniꞌ ni naquëꞌ Bönniꞌ naꞌ ziꞌa záꞌtëlëꞌ ca nedaꞌ, len náctërëꞌ blau ca nedaꞌ, atiꞌ cutu nacaꞌ lsacaꞌ nedaꞌ uleycjaꞌ lölëꞌ nudë́ꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yúguꞌtë lë ni guc lu xyu yödz Betábara, ga nac yetsláꞌa yegu Jordán, zacaꞌ ga rlen gbidz, ga niꞌ buquilëꞌ bunách nis Juan. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dza buróp niꞌ Juan bléꞌinëꞌ Jesús, zëꞌë ga zoëꞌ, atiꞌ rnëꞌ: ―Gul‑yutscaꞌ. Bönniꞌ ni naquëꞌ böꞌcuꞌ zxílaꞌdauꞌ queëꞌ Dios, rugǘëꞌ dul‑laꞌ quegac bunách yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lëꞌ naquëꞌ bönniꞌ naꞌ gniaꞌ queëꞌ: “Ziꞌa záꞌtëlëꞌ ca nedaꞌ tu bönniꞌ, náctërëꞌ blau ca nedaꞌ, le zoaczëꞌ ziꞌal ca nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Cutu núnbëꞌa‑nëꞌ nedaꞌ ziꞌal, san bidaꞌ, ruquilaꞌ bunách nis quië lunbëꞌ Lëꞌ bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Benëꞌ lnaꞌ lau queëꞌ Lëꞌ Juan, rnëꞌ: ―Bléꞌidaꞌ‑nëꞌ Dios Böꞌ Laꞌy, bötjëꞌ brujëꞌ yehuaꞌ yubá, gnëꞌë ca rnaꞌbaꞌ budödauꞌ, atiꞌ bdxinëꞌ ga zoëꞌ Jesús len bugáꞌnlenëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cutu núnbeꞌidaꞌ Lëꞌ nedaꞌ ziꞌal. Gudx nedaꞌ Nu naꞌ bsölaꞌ nedaꞌ uquilaꞌ bunách nis, gnëꞌ: “Catiꞌ gléꞌinuꞌ‑nëꞌ huötjëꞌ Dios Böꞌ Laꞌy, tsajsóalenëꞌ Bönniꞌ len ugáꞌnlenëꞌ Lëꞌ, Bönniꞌ ni gunëꞌ le ruluíꞌz yöl‑laꞌ rdil nis ni, uchiziëꞌ bunách Dios Böꞌ Laꞌy.” ");
INSERT INTO zsrNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naꞌa, chbléꞌidaꞌ lë naꞌ len runaꞌ lnaꞌ lau queëꞌ Bönniꞌ ni, naquëꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yetú dza caꞌ, leyúbl zoëꞌ niꞌ Juan atiꞌ nacuáꞌlenëꞌ lëꞌ chopëꞌ bönniꞌ daꞌquëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Catiꞌ Juan naꞌ bléꞌinëꞌ Jesús, rdödëꞌ niꞌ, niꞌr gudxëꞌ bönniꞌ naꞌ daꞌquëꞌ lëꞌ, rnëꞌ: ―Gul‑yutscaꞌ. Niꞌ zoëꞌ bönniꞌ naꞌ naquëꞌ böꞌcuꞌ zxílaꞌdauꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gulayönnëꞌ didzaꞌ ni bëꞌë Juan chopëꞌ bönniꞌ naꞌ daꞌquëꞌ lëꞌ, atiꞌ yajnauquëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Niꞌr bueycjëꞌ Jesús len bléꞌinëꞌ chopëꞌ ni nauquëꞌ Lëꞌ, atiꞌ rëꞌ lequëꞌ: ―¿Bizxa rguiljliꞌ? Tëꞌ Lëꞌ: ―Bönniꞌ Usëdi, ¿gazx zuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑dá, uyuliꞌ. Niꞌr yjáclenëꞌ Lëꞌ len gulaléꞌinëꞌ ga naꞌ zoëꞌ, atiꞌ gulugáꞌnlenëꞌ Lëꞌ dza naꞌ, le chzaꞌ ral. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés, böchëꞌë Simón Pedro, naquëꞌ tuëꞌ bönniꞌ chopëꞌ niꞌ gulayönnëꞌ didzaꞌ bëꞌë Juan len yajnauquëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés naꞌ, ziꞌal yajtiljëꞌ bönniꞌ böchëꞌë, lëꞌ Simón, atiꞌ rëꞌ lëꞌ: ―Chbdzö́lituꞌ‑nëꞌ Mesías. Mesías nac tu didzaꞌ hebreo le rna lu didzaꞌ griego: “Cristo”, atiꞌ lu didzaꞌ xidzaꞌ: “Bönniꞌ naböczëꞌ Dios”. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Niꞌr Andrés naꞌ laꞌ bchëꞌtëꞌ Simón ga naꞌ zoëꞌ Jesús. Catiꞌ bléꞌinëꞌ lëꞌ Jesús, rëꞌ lëꞌ: ―Liꞌ nacuꞌ Simón, zxiꞌnëꞌ Jonás. Naꞌa, siꞌ lauꞌ Cefas. Cefas nac caꞌ tu didzaꞌ hebreo le rna: “Pedro” lu didzaꞌ griego, atiꞌ lu didzaꞌ xidzaꞌ: “Guiöj”. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Catiꞌ zaꞌ reníꞌ yetú dza, guꞌnnëꞌ Jesús tsijëꞌ luyú Galilea, atiꞌ yajxaquëꞌë Felipe, len rëꞌ lëꞌ: ―Gdaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Naquëꞌ Felipe bönniꞌ yödz Betsaida, le nac ladzquëꞌ Andrés len Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe bdzölnëꞌ Natanael, len rëꞌ lëꞌ: ―Chbdzö́lituꞌ‑nëꞌ bönniꞌ naꞌ buzujëꞌ queëꞌ lu guich Moisés lu zxba queëꞌ Dios, atiꞌ guluzujëꞌ caꞌ queëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. Bönniꞌ ni Jesús, zxiꞌnëꞌ José, bönniꞌ yödz Nazaret. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael rëꞌ lëꞌ: ―¿Naruꞌ hualaꞌtsa Nazaret tu le nac dxiꞌa? Felipe rëꞌ lëꞌ: ―Gda uyúꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Catiꞌ bléꞌinëꞌ Jesús zëꞌë ga zoëꞌ Natanael naꞌ, rnëꞌ: ―Gul‑yú ni bönniꞌ naquëꞌ gdu bönniꞌ Israel len cutu rnazëꞌ caꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Niꞌr Natanael gnabnëꞌ Jesús, rëꞌ Lëꞌ: ―¿Naruꞌ núnbëꞌtsuꞌ nedaꞌ? Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Catiꞌ ziꞌa ulídztërëꞌ liꞌ Felipe, catiꞌ niꞌ zuꞌ zxan yag higo, bléꞌidaꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Niꞌr bubiꞌë didzaꞌ Natanael, rëꞌ Lëꞌ: ―Bönniꞌ Usëdi, Liꞌ nacuꞌ Zxiꞌnëꞌ Dios. Liꞌ nacuꞌ Nu gna beꞌi bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―¿Réjlëꞌtsuꞌ, le gudxaꞌ liꞌ: “Bléꞌidaꞌ liꞌ zxan yag higo”? Yuguꞌ le zxöntër ca lë ni hualéꞌinuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lëzcaꞌ cni rëꞌ lequëꞌ Jesús, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ, gléꞌiliꞌ nayálj luzxbá, len yuguꞌ gbaz laꞌy queëꞌ Dios taꞌbenëꞌ len tuꞌhuötjëꞌ ga zoaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Catiꞌ chguc tsonn dza, guc lni qui yöl‑laꞌ rutság naꞌ lu yödz Caná luyú Galilea, atiꞌ zoanu niꞌ xnëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Lëzcaꞌ zoa nu bulídz Jesús len yuguꞌ bönniꞌ usë́d queëꞌ djaquëꞌ lni naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Catiꞌ byadzj xisi uva liꞌjëꞌ, niꞌr gudxnu Jesús xnëꞌë, rnanu: ―Cutur dë xisi uva liꞌjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Bubiꞌë didzaꞌ Jesús, rëꞌ‑nu: ―Nguldauꞌ. ¿Bizx quië rulidzuꞌ nedaꞌ? Cutu caꞌ rdxini dza uluꞌa lahui yöl‑laꞌ huac quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niꞌr gudxnu‑nëꞌ bönniꞌ huen dxin taꞌguꞌë le tahuëꞌ xnëꞌë Jesús, rnanu: ―Gul‑gún yúguꞌtë le guiëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nacuáꞌ niꞌ xop yusuꞌ guiöj tuꞌgunëꞌ dxin bönniꞌ judío catiꞌ tuꞌpáꞌ cuinquëꞌ ca nalëbcnëꞌ tunëꞌ, len rúdzugac chop tsonn röꞌö nis tu tu yusuꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Gudxëꞌ yuguꞌ bönniꞌ huen dxin naꞌ Jesús, rnëꞌ: ―Gul‑dzáꞌ nis yuguꞌ yusuꞌ ni. Guludzë́ꞌë nis yuguꞌ yusuꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑gachiꞌ naꞌa, len gul‑tsjuáꞌ lahuëꞌ bönniꞌ zoëꞌ raꞌ yusuꞌ. Yjuaꞌquëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Buyúëꞌ chquiꞌ nazxíꞌ nis naꞌ nuhuöác xisi uva bönniꞌ naꞌ zoëꞌ raꞌ yusuꞌ, san cutu ráquibeꞌinëꞌ gazx zaꞌ. Nözcnëꞌ bönniꞌ huen dxin naꞌ gláchëꞌë nis naꞌ. Niꞌr bulidzëꞌ bönniꞌ utság nëꞌë bönniꞌ naꞌ zoëꞌ raꞌ yusuꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","len rëꞌ lëꞌ: ―Ziꞌal tuꞌnödzjëꞌ xisi uva nacr szxiꞌ yúguꞌtë bönniꞌ, len catiꞌ chgliꞌjëꞌ szxöni, niꞌr tuꞌnödzjëꞌ le cunazxíꞌ. Liꞌ, ga bdxintë naꞌa ben chiꞌu xisi uva nacr szxiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yöl‑laꞌ huac nac bëꞌ ni benëꞌ Jesús lu yödz Caná luyú Galilea nac le rzu lau yuguꞌ yöl‑laꞌ huac gunëꞌ. Cni guc, buluꞌë lahui yöl‑laꞌ zxön queëꞌ, atiꞌ gulayejlëꞌë Lëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Gdöd naꞌ gyijëꞌ Jesús yödz Capernaum, dzagquëꞌ Lëꞌ xnëꞌë len yuguꞌ bönniꞌ böchëꞌë len yuguꞌ bönniꞌ usë́d queëꞌ, atiꞌ zian dza gulacuꞌë Capernaum naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Catiꞌ chzoa gdxin Lni Pascua catiꞌ tuꞌspanëꞌ bönniꞌ judío ca benëꞌ Dios, buslë́ꞌ xuz xtauꞌquëꞌ luyú Egipto, gyijëꞌ Jesús Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lu yödz naꞌ yajxaquëꞌë Jesús dzöꞌë löꞌa gdauꞌ bönniꞌ tútiꞌë‑baꞌ yuguꞌ bëdx, len yuguꞌ böꞌcuꞌ zxilaꞌ, len yuguꞌ budödauꞌ, böaꞌ bëdx naꞌ tuꞌdödcdëꞌ‑baꞌ lahuëꞌ Dios. Röꞌquëꞌ caꞌ niꞌ bönniꞌ tuꞌtsë́ꞌë dumí zaꞌ gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Catiꞌ bléꞌinëꞌ lë ni Jesús, buzal‑lëꞌ yuguꞌ du las le quindëꞌ bunách naꞌ, atiꞌ bulaguëꞌë yúguꞌtëꞌ niꞌl löꞌa gdauꞌ, len bulaguëꞌë‑baꞌ caꞌ niꞌl yuguꞌ böꞌcuꞌ zxilaꞌ len yuguꞌ bëdx. Bësiëꞌ lu yu dumí quequëꞌ bönniꞌ naꞌ tuꞌtsë́ꞌë dumí, len brixëꞌ yuguꞌ blag quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Niꞌr Jesús gudxëꞌ bönniꞌ naꞌ tútiꞌë‑baꞌ yuguꞌ budödauꞌ, rnëꞌ: ―Gul‑cúa ni yuguꞌ lë ni. Cutu úniliꞌ yëꞌy lidxëꞌ Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Niꞌr yajneycnëꞌ bönniꞌ usë́d queëꞌ Jesús le nayúj lu guich laꞌy, rna: “Le ruiꞌtsca ladxaꞌa lidxuꞌ, regui rla ládxiꞌdauꞌhuaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Niꞌr gulubiꞌë didzaꞌ bönniꞌ judío uná bëꞌ nacuꞌë niꞌ, tëꞌ Jesús: ―¿Bizxa yöl‑laꞌ huac uluiꞌinuꞌ netuꞌ le gac bëꞌ dë lu naꞌu runuꞌ yuguꞌ lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Gul‑quíndj gdauꞌ ni, atiꞌ tsonn dzaz uchisaꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Niꞌr tëꞌ Lëꞌ bönniꞌ judío, taꞌnë́ꞌ: ―Gdu xopʉ́n iz gyaꞌ gdauꞌ ni, atiꞌ Liꞌ, ¿tsonn dzaz uchistsuꞌ lei? ");
INSERT INTO zsrNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gdauꞌ naꞌ bëꞌë didzaꞌ qui Jesús nac laꞌ cuinczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Qui lë ni naꞌ, catiꞌ bubanëꞌ Jesús lu yöl‑laꞌ gut, yajneycnëꞌ bönniꞌ usë́d queëꞌ Jesús ca naꞌ gnëꞌ, atiꞌ gulayejlëꞌë le nayúj lu guich laꞌy lencaꞌ yuguꞌ didzaꞌ bëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Catiꞌ niꞌ zoëꞌ Jesús Jerusalén, catiꞌ rac Lni Pascua naꞌ, gulayejlëꞌ Jesús bunách zian, le gulaléꞌinëꞌ yuguꞌ yöl‑laꞌ huac runëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Cutu buzxöni ladxëꞌë lequëꞌ Jesús, le núnbëꞌczëꞌ yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Cutu naquinnëꞌ Jesús nu quixjöiꞌ Lëꞌ ca nacgac bunách, le nözcznëꞌ Lëꞌ le yuꞌu icj ládxiꞌdauꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nicodemo, bönniꞌ gdauꞌ fariseo, nabáblenëꞌ yuguꞌ bönniꞌ judío uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chdzöꞌl bidëꞌ ga zoëꞌ Jesús bönniꞌ ni, len rëꞌ Lëꞌ: ―Bönniꞌ Usëdi. Ráquibeꞌituꞌ nasölëꞌë Liꞌ Dios quië usëdnuꞌ netuꞌ. Cutu sáquiꞌnëꞌ bönniꞌ gunëꞌ yöl‑laꞌ huac nacgac bëꞌ ca nacgac le cni runuꞌ Liꞌ chquiꞌ cuzóalenëꞌ lëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Le nactë rëpaꞌ liꞌ, nu cugálj leyúbl, cutu caꞌ gleꞌi latj ga niꞌ rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Gnabnëꞌ Lëꞌ Nicodemo, rnëꞌ: ―¿Nacxcz sáquiꞌnëꞌ bönniꞌ galjëꞌ leyúbl catiꞌ chnaquëꞌ bönniꞌ gul? ¿Naruꞌ huactsa uꞌë leyúbl lëꞌnu xnëꞌë, atiꞌ galjëꞌ yetú? ");
INSERT INTO zsrNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Le nactë rëpaꞌ liꞌ. Nu bönniꞌ cugaljëꞌ niꞌa qui nis len niꞌa queëꞌ Dios Böꞌ Laꞌy, cutu gac tsaziëꞌ ga rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nu naꞌ nalj lu niꞌa lu naꞌ bunách, bunáchz nac, san nu nalj niꞌa queëꞌ Dios Böꞌ Laꞌy, Böꞌ Laꞌy nabani nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Cutu ubannuꞌ le rëpaꞌ liꞌ, run bayúdx galjuꞌ leyúbl. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gátiꞌtëz reycj böꞌ, atiꞌ ryönnuꞌ rnë böꞌ naꞌ, san cutu nöznuꞌ gazx zaꞌ, o gazx zeaj. Lëzcaꞌ cni rac quegac nup naljgac niꞌa queëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niꞌr gnabnëꞌ Jesús Nicodemo, rnëꞌ: ―¿Nacxcz gac lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―¿Rusë́dtsanuꞌ liꞌ bunách Israel, len cutu nöznuꞌ yuguꞌ lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Le nactë rëpaꞌ liꞌ, le nö́zituꞌ ruiꞌtuꞌ didzaꞌ qui, len le bléꞌituꞌ runtuꞌ lnaꞌ lau qui, san cutu rziꞌ lu naꞌliꞌ lë naꞌ runtuꞌ lnaꞌ lau. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chquiꞌ cutu réjlëꞌliꞌ nedaꞌ catiꞌ ruíꞌlenaꞌ lbiꞌiliꞌ didzaꞌ ca nac le rac yödzlyú ni, ¿nacxcz gac tséjlëꞌliꞌ chquiꞌ gyëpaꞌ lbiꞌiliꞌ le tac yehuaꞌ yubá? ");
INSERT INTO zsrNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Gatga grenëꞌ bönniꞌ yehuaꞌ yubá, san tuzaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, bötjaꞌ brujaꞌ yehuaꞌ yubá, atiꞌ zoaczaꞌ niꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ca naꞌ benëꞌ Moisés lu latj caꞌz, buchisëꞌ‑baꞌ bël náquinibaꞌ guia, budë́ꞌë‑baꞌ lëꞌi yag, lëzcaꞌ cni run bayúdx gac quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, luchisëꞌ nedaꞌ xtsaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Cni gac quiaꞌ, cui laꞌnít yúguꞌtë nup laꞌyejlëꞌ nedaꞌ, san gataꞌ quequëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Le bdxíꞌitsquinëꞌ bunách yödzlyú Dios, budödëꞌ laꞌz dui Zxiꞌnëꞌ, cui laꞌnít yúguꞌtë nup laꞌyejlëꞌ Lëꞌ, san gataꞌ quequëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios bsölëꞌë Zxiꞌnëꞌ yödzlyú ni, clëg quië gchuguëꞌ quegac bunách yödzlyú ni, san quië lulá bunách yödzlyú ni niꞌa queëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu bönniꞌ rejlëꞌë Lëꞌ, Zxiꞌnëꞌ Dios, cutu caꞌ narugu queëꞌ, san bönniꞌ curejlëꞌë Lëꞌ, chnarugu queëꞌ, le cutu rejlëꞌë Lëꞌ, laꞌz dui Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Qui lë ni naꞌ chnarugu quegac bunách, le bdxinëꞌ yödzlyú ni Bönniꞌ naꞌ naquëꞌ yeníꞌ, san glunr zxön le nac chul xöhuiꞌ bunách ni ca le glunëꞌ zxön Bönniꞌ naꞌ naquëꞌ yeníꞌ, le nacgac xöhuiꞌ le tunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Cutu rdzag ládxiꞌquëꞌ yeníꞌ yúguꞌtë bönniꞌ tuꞌë döꞌ, len cutu djaquëꞌ lu yeníꞌ, cui glaꞌ lahui le tunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Rdxin lu yeníꞌ nu run le nac gdutë li quië gac bëꞌ nungac niꞌa queëꞌ Dios le run nu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gdöd naꞌ, gyéajlenëꞌ bönniꞌ daꞌquëꞌ Lëꞌ Jesús, guladxinëꞌ luyú Judea, atiꞌ niꞌ gzóalenëꞌ lequëꞌ, tuꞌquilëꞌ bunách nis. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lëzcaꞌ ruquilëꞌ bunách nis Juan ga nazíꞌ lei Enón, gal‑laꞌ ga dë yödz Salim, le dë niꞌ nis zil. Latj naꞌ taꞌdxín bunách len taꞌdíl nis. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Rac cni zíꞌatël catiꞌ ziꞌa gdzunëꞌ lidx guia Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Niꞌr gulazú lauquëꞌ laꞌquëꞌ bönniꞌ daꞌquëꞌ Juan taꞌdíl‑lenëꞌ bönniꞌ judío didzaꞌ ca nac qui yöl‑laꞌ rupáꞌ cuini qui gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Guladxinëꞌ ga zoëꞌ Juan len tëꞌ lëꞌ: ―Bönniꞌ usëdi. Byutscaꞌ. Ruquilëꞌ bunách nis bönniꞌ naꞌ gzóalenëꞌ liꞌ yetsláꞌa yegu Jordán, bönniꞌ naꞌ benuꞌ lnaꞌ lau queëꞌ, atiꞌ taꞌdxín ga zoëꞌ yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Niꞌr bubiꞌë didzaꞌ Juan, rëꞌ lequëꞌ: ―Cutu bi dë lu nëꞌë bönniꞌ, chquiꞌ Dios cutu nudödëꞌ lei lu nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Byö́niczliꞌ lë naꞌ benaꞌ lnaꞌ lau, gniaꞌ: “Cutu nacaꞌ nedaꞌ Cristo”, san Dios nasölëꞌë nedaꞌ quíxjöiꞌdaꞌ bunách ziꞌa zëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bönniꞌ naꞌ rziꞌë‑biꞌ biꞌi ngul rutság naꞌbiꞌ naquëꞌ bönniꞌ rutság nëꞌë, san böchiꞌ lzëꞌë bönniꞌ rutság nëꞌë, len dzaguëꞌ lëꞌ, ruzë́ naguëꞌ didzaꞌ ruꞌë, len rudzijnëꞌ le ryönnëꞌ didzaꞌ ruꞌë bönniꞌ rutság nëꞌë. Lëzcaꞌ cni, rudzíjtsquidaꞌ nedaꞌ le rac cni lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Run bayúdx gacrëꞌ blau caꞌ Cristo, san nedaꞌ, run bayúdx gacraꞌ cuidiꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Gnëꞌ caꞌ Juan: ―Bönniꞌ naꞌ zëꞌë zacaꞌ xtsaꞌl náctërëꞌ blau ca yúguꞌtë bunách. Bönniꞌ naquëꞌ bunách yödzlyú ni, qui yödzlyú ni naquëꞌ, len ruꞌë didzaꞌ qui le rac yödzlyú ni, san Bönniꞌ naꞌ zëꞌë zacaꞌ yehuaꞌ yubál náctërëꞌ blau ca yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bönniꞌ ni runëꞌ lnaꞌ lau qui le bléꞌinëꞌ len le byönnëꞌ, san nutu nu rziꞌ lu nëꞌi le runëꞌ lnaꞌ lau. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nútiꞌtëz bönniꞌ rziꞌ lu nëꞌë lë naꞌ runëꞌ lnaꞌ lau, bönniꞌ ni ruluꞌë lahui rejlëꞌë nac gdutë li didzaꞌ ruꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bönniꞌ naꞌ nasölëꞌë Dios, didzaꞌ queëꞌ Dios ruꞌë, le nuzóëꞌ Dios gdu ladxëꞌë lu Bönniꞌ naꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Xuz nadxiꞌinëꞌ Zxiꞌnëꞌ, atiꞌ yúguꞌtë le dë chnudödëꞌ lu nëꞌë Zxiꞌnëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu bönniꞌ rejlëꞌë Dios Zxiꞌn, dë yöl‑laꞌ naꞌbán gdu queëꞌ, san bönniꞌ curejlëꞌë Dios Zxiꞌn, cutu gdél‑liꞌnëꞌ yöl‑laꞌ naꞌbán naꞌ, san nabaguëꞌë zxguiaꞌ lahuëꞌ Dios bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Gulayönnëꞌ bönniꞌ gdauꞌ fariseo ca naꞌ daꞌgac Jesús zianr bunách ca daꞌgac Juan, atiꞌ ruquilëꞌ caꞌ nis zianr bunách ca ruquilëꞌ nis Juan. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Cutu ruquilëꞌ bunách nis Jesúscz, san tuꞌquilëꞌ bunách nis bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Catiꞌ gúquibeꞌinëꞌ lë ni Jesús, buzë́ꞌë luyú Judea, zijëꞌ leyúbl luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ga niꞌ zijëꞌ, run bayúdx tödëꞌ luyú Samaria. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Cni guc, bdxinëꞌ Jesús tu yödzdauꞌ luyú Samaria, nazíꞌ lei Sicar, gal‑laꞌ ga dë yu naꞌ bunödzjëꞌ Jacob queëbiꞌ José queëꞌ dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Latj naꞌ zoa tu yeru nis nachöꞌnëꞌ ga rëꞌ Jacobo naꞌ. Catiꞌ bdxinëꞌ niꞌ Jesús, gröꞌë raꞌ yeru nis naꞌ le yajxáquiꞌnëꞌ yuꞌë nöz. Guc gdu huagbídz. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Niꞌr bdxinnu niꞌ ngul Samaria quië siꞌnu nis. Jesús rëꞌ‑nu: ―Benn le guiꞌjaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tuzëꞌ zoëꞌ Jesús le chzjaquëꞌ bönniꞌ usë́d queëꞌ lu yödz zajxiꞌquëꞌ le lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Niꞌr rënu Jesús ngul Samaria naꞌ, rnanu: ―¿Rnábtsanuꞌ nedaꞌ le guiꞌjuꞌ, len nacuꞌ bönniꞌ judío? Nedaꞌ ni nacaꞌ ngul Samaria. Cni gnanu le cutu taꞌdzág dxiꞌa bunách Samaria len bunách judío. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Bubiꞌë didzaꞌ Jesús, rëꞌ‑nu: ―Laꞌnaruꞌ núnbëꞌu le runödzjëꞌ Dios, len nuzxa naꞌ rë liꞌ: “Benn le guiꞌjaꞌ”, liꞌ gnabuꞌ atiꞌ Lëꞌ gunnëꞌ quiuꞌ nis runn yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Niꞌr rënu Lëꞌ ngul naꞌ, rnanu: ―Bönniꞌ, cutu nuꞌu le cuíajnuꞌ nis, atiꞌ yeru nis ni, dxiꞌtër röꞌ. ¿Gazx dë nis naꞌ runn yöl‑laꞌ naꞌbán? ");
INSERT INTO zsrNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Naruꞌ náctërtsuꞌ Liꞌ zxön ca xuzruꞌ gul gdöd Jacob, bönniꞌ niꞌ bennëꞌ queëtuꞌ yeru nis ni, ga ni gzxiꞌë nis guꞌë, len gliꞌjbiꞌ caꞌ zxiꞌnëꞌ, len glëꞌjbaꞌ caꞌ böaꞌ bëdx queëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Bubiꞌë didzaꞌ Jesús, rëꞌ‑nu: ―Nútiꞌtëz nu guiꞌj nis ni, leyúbl ubídx nis, ");
INSERT INTO zsrNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","san nu guiꞌj nis naꞌ unödzjaꞌ nedaꞌ, cutur gbidx icj ládxiꞌdauꞌhuëꞌ, le unödzjaꞌ queëꞌ nis naꞌ gac lu icj ládxiꞌdauꞌhuëꞌ ca tu ga ralj nis, le güiꞌ queëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niꞌr rënu Lëꞌ ngul naꞌ, rnanu: ―Bönniꞌ, benn quiaꞌ nis naꞌ, quië cutur ubidxaꞌ, len cutur duxiꞌa nis ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús rëꞌ‑nu: ―Gyeaj, yajlidzëꞌ bönniꞌ quiuꞌ, atiꞌ huöduꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bubiꞌinu didzaꞌ ngul naꞌ, rënu Lëꞌ: ―Cutu nu zoa bönniꞌ quiaꞌ. Niꞌr Jesús rëꞌ‑nu: ―Ca nacz rnauꞌ, “cutu nu zoa bönniꞌ quiaꞌ”, ");
INSERT INTO zsrNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","le chgzóalenuꞌ gayuꞌ bönniꞌ, atiꞌ bönniꞌ naꞌ zóalenuꞌ‑nëꞌ naꞌa, cutu naquëꞌ bönniꞌ quiuꞌ. Didzaꞌ ni ruꞌu, ca nacz rnauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Niꞌr rënu Lëꞌ ngul naꞌ, rnanu: ―Bönniꞌ, runi nedaꞌ nacuꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gulayíj ládxiꞌquëꞌ Dios xuz xtauꞌruꞌ lu guiꞌa ni, san rnaliꞌ lbiꞌiliꞌ Jerusalén nac ga ral‑laꞌ laꞌyíj ládxiꞌgac Dios bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús rëꞌ‑nu: ―Ngul, gyejlëꞌ nedaꞌ. Zaꞌ dza catiꞌ tsej ládxiꞌliꞌ‑nëꞌ Dios Xuz zal‑laꞌ cutu dusoaliꞌ guíꞌadauꞌ ni, len cutu tsajsoaliꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lbiꞌiliꞌ rej ládxiꞌliꞌ Nu cu núnbëꞌliꞌ, san netuꞌ núnbëꞌtuꞌ Nu naꞌ rej ládxiꞌtuꞌ, le benëꞌ queëꞌ Dios glaꞌ lahui yöl‑laꞌ ruslá niꞌa quequëꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Naꞌa, zaꞌ dza, len chrdxin dza naꞌ, catiꞌ nup le nactë taꞌyíj ládxiꞌgac Dios, laꞌyíj ládxiꞌquëꞌ Lëꞌ, zóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy len le nac gdutë li, le rëꞌnnëꞌ Dios Xuz lacquëꞌ queëꞌ bönniꞌ laꞌyíj ládxiꞌquëꞌ Lëꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios naquëꞌ Böꞌ, atiꞌ nup taꞌyíj ládxiꞌgac Lëꞌ, run bayúdx laꞌyíj ládxiꞌquëꞌ Lëꞌ, zóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy len le nac gdutë li. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Niꞌr rënu Lëꞌ ngul naꞌ, rnanu: ―Nözdaꞌ ral‑laꞌ guidëꞌ Mesías, Bönniꞌ naꞌ lëꞌ Cristo. Catiꞌ guidrëꞌ Lëꞌ quíxjöiꞌnëꞌ rëꞌu yúguꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús rëꞌ‑nu: ―Lëczëꞌ, ruíꞌlenëꞌ liꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ractë cni guludxinëꞌ bönniꞌ usë́d queëꞌ Jesús, atiꞌ gulubannëꞌ le ruíꞌlenëꞌ‑nu ngul didzaꞌ, san cutu burúguinëꞌ gnabnëꞌ Lëꞌ nitúëꞌ, cugnë́ꞌ: “¿Bizxa rnabnuꞌ lënu?” o: “¿Bizxa didzaꞌ ruíꞌlenuꞌ‑nu?” ");
INSERT INTO zsrNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Niꞌr bucaꞌnnu niꞌ xchöꞌnu ngul naꞌ, atiꞌ böajnu laꞌ yödz, zjödxnu nup nacuáꞌ niꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","rnanu: ―Gul‑dá, gléꞌiliꞌ‑nëꞌ bönniꞌ gudxëꞌ nedaꞌ yúguꞌtë le chnunaꞌ. ¿Naruꞌ cunactsëꞌ Lëꞌ Cristo? ");
INSERT INTO zsrNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Niꞌr gularúj bunách yödz naꞌ, guladxinëꞌ ga zoëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tsal niꞌ zhuöjnu ngul naꞌ, glunëꞌ bayúdx bönniꞌ usë́d queëꞌ Jesús, tëꞌ Lëꞌ: ―Bönniꞌ Usëdi, gdagu. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús rëꞌ lequëꞌ: ―Dë tu le rahuaꞌ, le cunö́ziliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Niꞌr gulanabi lzaꞌquëꞌ tuëꞌ yetúëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Nuzxa chdguaꞌtsa le gdahuëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Niꞌr Jesús rëꞌ lequëꞌ: ―Le nabánidaꞌ nac gunaꞌ ca rëꞌnnëꞌ Xuzaꞌ nasölëꞌë nedaꞌ, len udx gunaꞌ xchinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Cni rnaliꞌ lbiꞌiliꞌ: “Yetáp beoꞌ huadxín dza lapruꞌ.” Nedaꞌ rëpaꞌ lbiꞌiliꞌ: Gul‑chís lauliꞌ uyuliꞌ bunách nacgac ca gap naduzgac, le chnabidxgac quië tsajlapruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bönniꞌ naꞌ rlapëꞌ rziꞌë lazxjëꞌ, atiꞌ lë naꞌ rlapëꞌ bönniꞌ naꞌ, nac quië gataꞌ quegac bunách yöl‑laꞌ naꞌbán gdu, quië gac ludziji tsazxö́n nu raz len nu rlap. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nac gdutë li lë naꞌ rna cni: “Tu nu raz, len yetú nu rlap.” ");
INSERT INTO zsrNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nedaꞌ bsölaꞌa lbiꞌiliꞌ tsajlapliꞌ ga cutu guzliꞌ. Glun dxin glaz bunách yubl, atiꞌ lbiꞌiliꞌ ruziꞌliꞌ xbey dxin naꞌ nunquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gulayejlëꞌë Jesús zian bunách Samaria nacuáꞌ yödz Sicar naꞌ niꞌa qui xtídzaꞌnu ngul naꞌ, bennu lnaꞌ lau queëꞌ, gnanu: “Gudxëꞌ nedaꞌ yúguꞌtë le chnunaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Catiꞌ guladxinëꞌ bönniꞌ Samaria ga niꞌ zoëꞌ Jesús, glátaꞌyuëꞌ lahuëꞌ ugáꞌnlenëꞌ lequëꞌ. Yechóp dza bugaꞌnëꞌ niꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cni guc, gulayejlëꞌë Lëꞌ ziántërëꞌ caꞌ bönniꞌ niꞌ niꞌa qui didzaꞌ bëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Niꞌr glëꞌ‑nu ngul naꞌ bönniꞌ niꞌ, taꞌnë́ꞌ: ―Naꞌa réjlëꞌtuꞌ Lëꞌ, clëgz niꞌa qui didzaꞌ bëꞌu liꞌ, san lëzcaꞌ le byö́nituꞌ Lëꞌ netuꞌ, len nö́zituꞌ le nactë naquëꞌ Cristo, Nu ruslá bunách yödzlyú, bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yechóp dza caꞌ, buzë́ꞌë Jesús luyú Samaria, zijëꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Cni benëꞌ, le gdíxjöꞌë Lëczëꞌ Jesús, gnëꞌ: “Cutu tun ba laꞌn bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, bunách uládz queëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Catiꞌ bdxinëꞌ Jesús luyú Galilea, glunëꞌ Lëꞌ ba laꞌn bönniꞌ Galilea naꞌ le yjaquëꞌ caꞌ Jerusalén catiꞌ guc Lni Pascua len gulaléꞌinëꞌ le benëꞌ niꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Niꞌr böjëꞌ Jesús yödz Caná luyú Galilea, ga niꞌ benëꞌ ga böac xisi uva nis. Lu yödz Capernaum naꞌ zoëꞌ bönniꞌ dë lu nëꞌë uláz queëꞌ bönniꞌ rna bëꞌë, atiꞌ réꞌibiꞌ biꞌi bönniꞌ queëꞌ bönniꞌ naꞌ dë lu nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Catiꞌ byönnëꞌ bönniꞌ ni chbuzë́ꞌë Jesús luyú Judea len budxinëꞌ luyú Galilea naꞌ, niꞌr gyijëꞌ ga naꞌ zoëꞌ Jesús, len gútaꞌyuëꞌ lahuëꞌ guidëꞌ lidxëꞌ, duhuenëꞌ‑biꞌ biꞌi bönniꞌ queëꞌ naꞌ, le chraqui gatbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Niꞌr Jesús rëꞌ lëꞌ: ―Cutu caꞌ tséjlëꞌliꞌ chquiꞌ cutu gléꞌiliꞌ le nacgac bëꞌ len yuguꞌ yöl‑laꞌ huac gunaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Niꞌr gudxëꞌ Jesús bönniꞌ naꞌ dë lu nëꞌë uláz queëꞌ bönniꞌ rna bëꞌë, rnëꞌ: ―Bönniꞌ, diaꞌtë qui nadxi gatbiꞌ biꞌi quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Niꞌr Jesús rëꞌ lëꞌ: ―Böaj lidxuꞌ. Nabanbiꞌ biꞌi quiuꞌ. Gyejlëꞌë didzaꞌ bëꞌë Jesús bönniꞌ ni, atiꞌ zhuöjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tsal niꞌ yuꞌë nöz zhuöjëꞌ, duxíꞌgal‑laꞌquëꞌ lëꞌ bönniꞌ huen dxin queëꞌ atiꞌ gulaguíxjöiꞌnëꞌ lëꞌ, taꞌnë́ꞌ: ―Nabanbiꞌ biꞌi quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gnabnëꞌ lequëꞌ bat cal gzu lau ruhuöác ládxiꞌbiꞌ. Tëꞌ lëꞌ: ―Baꞌy, gdu huagbídz, burúj tu xla yuꞌubiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Niꞌr gúquibeꞌinëꞌ xuzbiꞌ biꞌi naꞌ, böacbiꞌ catiꞌ niꞌ bë́ꞌlenëꞌ lëꞌ didzaꞌ Jesús, gudxëꞌ lëꞌ: “Nabanbiꞌ biꞌi quiuꞌ.” Qui lë ni naꞌ gyejlëꞌë Jesús atiꞌ gulayejlëꞌ caꞌ Lëꞌ bunách nacuáꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yöl‑laꞌ huac ni nac le buróp benëꞌ Jesús catiꞌ niꞌ zoëꞌ luyú Galilea, gdöd buzë́ꞌë luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gdöd guc lë ni, guc lni quequëꞌ bönniꞌ judío, atiꞌ gyijëꞌ Jesús Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lu yödz naꞌ, gal‑laꞌ ga tuꞌúꞌubaꞌ böꞌcuꞌ zxilaꞌ, dë tu pil nis zxön, nazíꞌ lei Betesda lu didzaꞌ hebreo, len nacuáꞌ gayuꞌ nchil don qui. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yuguꞌ nchil naꞌ dëquëꞌ zian bönniꞌ téꞌinëꞌ, bönniꞌ nachúl lauquëꞌ, len bönniꞌ cutaꞌzë́ꞌë, len bönniꞌ nacuꞌnquëꞌ bin. Taꞌbözëꞌ bat cal utá cuini nis naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Cni rac, le ruhuötjëꞌ tu chiꞌi hueaj gbaz laꞌy queëꞌ Dios, ryaziëꞌ lu nis naꞌ, len rutë́ꞌ nis naꞌ. Huöactëꞌ ca nac bítiꞌtëz guidzhuë́ꞌ rac queëꞌ bönniꞌ tsajtsuꞌë ziꞌal lu nis naꞌ catiꞌ rutá cuini. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Zoëꞌ niꞌ bönniꞌ, chguc chizxunuꞌ uruáꞌ iz réꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Catiꞌ bléꞌinëꞌ dëꞌ niꞌ bönniꞌ huëꞌ naꞌ Jesús, len ráquibeꞌinëꞌ chguc zian iz réꞌinëꞌ, gnabnëꞌ lëꞌ, rnëꞌ: ―¿I rëꞌnnuꞌ huöacuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Bubiꞌë didzaꞌ bönniꞌ huëꞌ naꞌ, rëꞌ Jesús: ―Bönniꞌ, nutu nu zoa cuꞌu nedaꞌ lu nis naꞌ catiꞌ rutá cuini. Tsal zijaꞌ nedaꞌ, ryaziëꞌ bönniꞌ yubl ziꞌal ca nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús rëꞌ lëꞌ: ―Gyasch. Buaꞌ le deynuꞌ, len gzëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Laꞌ böactëꞌ bönniꞌ naꞌ, atiꞌ buꞌë le gútiꞌnëꞌ len gzëꞌë. Dza naꞌ rac cni nac dza laꞌy quequëꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Niꞌr glëꞌ bönniꞌ naꞌ nuhuöaquëꞌ bönniꞌ judío uná bëꞌ, taꞌnë́ꞌ: ―Dza laꞌy nac naꞌa. Cutu ral‑laꞌ uꞌu le rátiꞌnuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bubiꞌë didzaꞌ bönniꞌ naꞌ, rëꞌ lequëꞌ: ―Gudxczëꞌ nedaꞌ bönniꞌ naꞌ bunëꞌ nedaꞌ, gnëꞌ: “Buaꞌ le deynuꞌ len gzëꞌi.” ");
INSERT INTO zsrNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Niꞌr gulanabnëꞌ lëꞌ, taꞌnë́ꞌ: ―¿Nuzxa naꞌ gudx cni liꞌ: “Buaꞌ le deynuꞌ len gzëꞌi”? ");
INSERT INTO zsrNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cutu nöznëꞌ nuzxa naꞌ bönniꞌ naꞌ nuhuöaquëꞌ, le chbuzë́ꞌë Jesús latj niꞌ le nacuáꞌ niꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Gdöd guc lë ni, yajxaquëꞌë bönniꞌ naꞌ Jesús ga nac nchil gdauꞌ, atiꞌ rëꞌ lëꞌ: ―Byutscaꞌ. Chböacuꞌ. Cutur gunuꞌ dul‑laꞌ, cui gac quiuꞌ tu le nacr ziꞌ ca lë naꞌ guc quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gyijëꞌ bönniꞌ naꞌ, yajtíxjöiꞌnëꞌ yuguꞌ bönniꞌ judío uná bëꞌ Jesús naꞌ bunëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Qui lë ni naꞌ gulabía ládxiꞌquëꞌ Jesús bönniꞌ judío uná bëꞌ len glëꞌnnëꞌ ludöddëꞌ Lëꞌ, le runëꞌ yuguꞌ lë ni catiꞌ nac dza laꞌy quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Xuzaꞌ naꞌatë runëꞌ dxin, atiꞌ nedaꞌ caꞌ runaꞌ dxin. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Qui lë ni naꞌ glëꞌnrnëꞌ bönniꞌ judío uná bëꞌ ludöddëꞌ Jesús, clëgz le gditsjëꞌ zxba qui dza laꞌy quequëꞌ, san lëzcaꞌ le gnëꞌ naquëꞌ Dios Xuzczëꞌ, atiꞌ cni nac nun cuinëꞌ tuz ca naquëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ. Cutu bi gac gunaꞌ nedaꞌ, Zxiꞌnëꞌ Dios, racz quiaꞌ san tuz lë naꞌ rléꞌidaꞌ runëꞌ Dios Xuz. Yúguꞌtë le runëꞌ Dios Xuz, lëzcaꞌ cni runaꞌ nedaꞌ, Zxiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dios Xuz nadxiꞌinëꞌ nedaꞌ, Zxiꞌnëꞌ, len ruluiꞌinëꞌ nedaꞌ yúguꞌtë le runëꞌ, atiꞌ yuguꞌ le zxöntër ca lë ni uluiꞌinëꞌ nedaꞌ, le lun ga ubániliꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ca naꞌ runëꞌ Dios Xuz, ruspanëꞌ nup natgac, len ruhuë́ꞌë quequëꞌ yöl‑laꞌ naꞌbán, lëzcaꞌ cni runaꞌ nedaꞌ, Zxiꞌnëꞌ, runödzjaꞌ quegac bunách yöl‑laꞌ naꞌbán ca rëꞌnczdaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nutu nu rbequi xbeynëꞌ Dios Xuz, san chnudödëꞌ lu naꞌa nedaꞌ, Zxiꞌnëꞌ, yúguꞌtë yöl‑laꞌ uná bëꞌ cuequi xbeydaꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Cni nac quië lun ba laꞌn nedaꞌ, Zxiꞌnëꞌ, yúguꞌtë bunách ca naꞌ tun ba laꞌn Dios Xuz. Nu cu run ba laꞌn nedaꞌ, Zxiꞌnëꞌ, cutu run ba laꞌn Dios Xuz, nasölëꞌë nedaꞌ, Zxiꞌnëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Le nactë rëpaꞌ lbiꞌiliꞌ. Dë yöl‑laꞌ naꞌbán gdu queëꞌ bönniꞌ ryönnëꞌ didzaꞌ ruꞌa len rejlëꞌë Dios Xuz naꞌ nasölëꞌë nedaꞌ, atiꞌ cutu grugu queëꞌ, san naquëꞌ ca nu chnubán lu yöl‑laꞌ gut le chdë yöl‑laꞌ naꞌbán gdu queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Le nactë rëpaꞌ lbiꞌiliꞌ, zaꞌ dza, len chrdxin dza naꞌ, catiꞌ laꞌyöni chiꞌa nedaꞌ, Zxiꞌnëꞌ Dios, nup chnatgac, atiꞌ nup laꞌyöni xtidzaꞌa len lun ca rna, huöataꞌ yöl‑laꞌ naꞌbán quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ca naꞌ dë lu nëꞌë Dios Xuz unödzjëꞌ quegac bunách yöl‑laꞌ naꞌbán, lëzcaꞌ cni benëꞌ ga dë lu naꞌa nedaꞌ, Zxiꞌnëꞌ, unödzjaꞌ quegac bunách yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Lëzcaꞌ cni budödëꞌ lu naꞌa yöl‑laꞌ uná bëꞌ cuequi xbeydaꞌ bunách, le nacaꞌ Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cutu ubániliꞌ ca nac lë ni, le huadxín dza catiꞌ laꞌyöni chiꞌa yúguꞌtë nup chnatgac, ");
INSERT INTO zsrNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","len lurúj yeru ba. Lubán nup naꞌ glun le nac tsahuiꞌ, huöataꞌ quequëꞌ yöl‑laꞌ naꞌbán, san nup naꞌ glun le cunác, lubán, atiꞌ grugu quequëꞌ latiëꞌ tsaz. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Gnëꞌ caꞌ Jesús: ―Cutu bi gac gunaꞌ laꞌ nedaꞌz. Ca nac le ryöndaꞌ rëꞌ nedaꞌ Xuzaꞌ, cni rbequi xbeydaꞌ, atiꞌ ca naꞌ rbequi xbeydaꞌ nac tsahuiꞌ, le cutu runaꞌ ca rëꞌnzdaꞌ nedaꞌ, san ca rëꞌncznëꞌ Xuzaꞌ nasölëꞌë nedaꞌ, runaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chquiꞌ nedaꞌ runaꞌ lnaꞌ lau qui laꞌ cuinczaꞌ, cutu nac lsacaꞌ lë naꞌ runaꞌ lnaꞌ lau. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Zoa Nu yubl Nu run lnaꞌ lau quiaꞌ nedaꞌ, Lëꞌ Xuzaꞌ, atiꞌ nözdaꞌ nac lsacaꞌ le runëꞌ lnaꞌ lau quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lbiꞌiliꞌ bsö́laꞌliꞌ bönniꞌ yajnabcnëꞌ Juan, atiꞌ lë naꞌ benëꞌ lnaꞌ lau quiaꞌ nac gdutë li. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nedaꞌ cutu naquindaꞌ nu bönniꞌ gunëꞌ lnaꞌ lau quiaꞌ, san ruꞌa didzaꞌ ni quië ulaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Guc ca tu guiꞌ yör didzaꞌ bëꞌë Juan naꞌ, le gyegui len buzeníꞌ, atiꞌ lbiꞌiliꞌ, tu chiꞌz bdzag ládxiꞌliꞌ uziꞌliꞌ xbey yeníꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Naꞌa, zoa le run lnaꞌ lau quiaꞌ nedaꞌ le nacr gdu ca lë naꞌ benëꞌ lnaꞌ lau quiaꞌ Juan. Yuguꞌ le budödëꞌ lu naꞌa gunaꞌ Dios Xuz, laꞌ leyz naꞌ runaꞌ, atiꞌ yuguꞌ lë naꞌ runaꞌ, tun lnaꞌ lau quiaꞌ, len nacgac bëꞌ bsölëꞌë nedaꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Lëzcaꞌ runëꞌ lnaꞌ lau quiaꞌ Dios Xuz nasölëꞌë nedaꞌ. Gatga byö́niliꞌ chiꞌë, len gatga bléꞌiliꞌ lahuëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","len cutu nazíꞌ lu naꞌliꞌ xtidzëꞌë, le cutu réjlëꞌliꞌ nedaꞌ, nu naꞌ bsölëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Rusëdliꞌ le nayúj lu guich laꞌy, le ráquiliꞌ huataꞌ queëliꞌ yöl‑laꞌ naꞌbán gdu niꞌa qui lë naꞌ nayúj lu guich laꞌy, atiꞌ lë naꞌ nayúj lu guich run lnaꞌ lau quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Cutu rë́ꞌniliꞌ guidliꞌ quiaꞌ nedaꞌ quië gataꞌ queëliꞌ yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Cutu rguiljaꞌ yöl‑laꞌ ba laꞌgúꞌu nedaꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nedaꞌ núnbëꞌa lbiꞌiliꞌ, len nözdaꞌ cutu nadxiꞌiliꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bdxinaꞌ ni uláz queëꞌ Dios Xuz, atiꞌ lbiꞌiliꞌ cutu rziꞌ lu naꞌliꞌ nedaꞌ, san chquiꞌ huadxín nu yubl nu guid racz qui, bönniꞌ naꞌ siꞌ lu naꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nacxcz gac tséjlëꞌliꞌ Dios chquiꞌ rziꞌliꞌ yöl‑laꞌ run zxön qui lzaꞌliꞌ tuliꞌ yetuliꞌ, len cutu rguiljliꞌ yöl‑laꞌ run zxön naꞌ zaꞌ lu nëꞌë laꞌz dui Dios? ");
INSERT INTO zsrNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Cutu uzóa icjliꞌ uquíaꞌ lbiꞌiliꞌ lahuëꞌ Xuzaꞌ. Nu naꞌ uquí lbiꞌiliꞌ nac lëczëꞌ Moisés, bönniꞌ naꞌ ruzxöni ládxiꞌliꞌ‑nëꞌ, zal‑laꞌ gutiëꞌ dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Laꞌnaruꞌ réjlëꞌliꞌ‑nëꞌ Moisés, tséjlëꞌliꞌ caꞌ nedaꞌ, le buzujëꞌ Moisés lu guich ca nac quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Naꞌa, ¿nacxcz gac tséjlëꞌliꞌ didzaꞌ ruꞌa nedaꞌ chquiꞌ cutu réjlëꞌliꞌ yuguꞌ le buzujëꞌ lu guich Moisés? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gdöd guc lë ni, gyijëꞌ Jesús yetsláꞌa Nis Zxön Qui Galilea, nazíꞌ lei caꞌ Nis Zxön Queëꞌ Tiberias. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yajnaugac Jesús bunách zian le gulaleꞌi yuguꞌ yöl‑laꞌ huac benëꞌ, bunëꞌ bönniꞌ téꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Niꞌr grenëꞌ Jesús, gyijëꞌ ga nac tu lu guíꞌadauꞌ, atiꞌ niꞌ grö́ꞌlenëꞌ yuguꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chzoa gdxin Lni Pascua catiꞌ tuꞌspanëꞌ bönniꞌ judío ca benëꞌ Dios, bubijëꞌ luyú Egipto xuz xtauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Catiꞌ bchis lahuëꞌ Jesús len bléꞌinëꞌ bunách zian zaꞌc ga zoëꞌ, niꞌr rëꞌ Felipe: ―¿Gazx tsjö́ꞌuruꞌ yöt xtil lagu bunách zian ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Cni gnëꞌ Jesús quië siꞌ bëꞌë Felipe naꞌ, le nözcznëꞌ Lëꞌ nac gunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Bubiꞌë didzaꞌ Felipe, rnëꞌ: ―Laꞌnaruꞌ siꞌruꞌ yöt xtil lazxjruꞌ qui gdu xunuꞌ beoꞌ, cutu gaqui látiꞌdauꞌ hueaj lagu bunách zian ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Niꞌr rëꞌ Jesús bönniꞌ usë́d queëꞌ, lëꞌ Andrés, böchëꞌë Simón Pedro, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ni zoabiꞌ biꞌi bönniꞌ, nuaꞌbiꞌ gayuꞌ yöt xtil náquini zxoaꞌ cebada, len chopbaꞌ böl cuídiꞌdauꞌ. ¿Naruꞌ huáquiꞌtsa ugagu cátiꞌga zian bunách le dauꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑gún ga laꞌbö́ꞌ lyu bunách zian ni. Latj naꞌ, szxöni röꞌ dacaꞌ, atiꞌ niꞌ gulaböꞌë gdu ca chiʉ́n gayuꞌë bönniꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Niꞌr gdel‑lëꞌë Jesús yöt xtil naꞌ. Catiꞌ chgudxëꞌ Dios: “Xclenuꞌ”, gdisiëꞌ lei quequëꞌ bönniꞌ usë́d queëꞌ, atiꞌ lequëꞌ gulaguisiëꞌ lei quegac yúguꞌtë nup naꞌ röꞌgac lu dacaꞌ niꞌ. Lëzcaꞌ cni glunëꞌ quecbaꞌ böl cuídiꞌdauꞌ naꞌ, atiꞌ glahuëꞌ tsca glëꞌnnëꞌ lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Catiꞌ chguluhuöljnëꞌ, rëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Gul‑túb le bizxj nagaꞌngac, cui lac ditj. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gulutubëꞌ caꞌ, atiꞌ guludzë́ꞌë chinnu bdö́ꞌadauꞌ le bizxj quegac gayuꞌ yöt xtil náquini zxoaꞌ cebada naꞌ, le gulugáꞌn quequëꞌ bönniꞌ naꞌ glahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Catiꞌ gulaléꞌinëꞌ bönniꞌ niꞌ yöl‑laꞌ huac naꞌ benëꞌ Jesús, taꞌnë́ꞌ: ―Le nactë bönniꞌ ni naquëꞌ bönniꞌ naꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, bönniꞌ naꞌ ral‑laꞌ guidëꞌ yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Le ráquibeꞌinëꞌ Jesús tëꞌnnëꞌ laꞌchë́ꞌë Lëꞌ bayúdx quië lunëꞌ ga gna béꞌinëꞌ lequëꞌ, qui lë ni naꞌ buzë́ꞌë niꞌ, zijëꞌ tuzëꞌ tu lu guiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Catiꞌ chzaꞌ ral, yjaquëꞌ bönniꞌ usë́d queëꞌ Jesús, guladxinëꞌ raꞌ nis zxön. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Niꞌ gulabenëꞌ tu lëꞌi bárcodauꞌ, zjaquëꞌ taꞌdödëꞌ lu nis zxön naꞌ, quië ludxinëꞌ Capernaum. Chnac chul atiꞌ Jesús cutu rdxíninëꞌ ga naꞌ nacuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gzu lau reycj böꞌ bdunuꞌ lu nis zxön naꞌ, atiꞌ ryas rdxia nis naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Catiꞌ chgulusë́ꞌë bárcodauꞌ naꞌ, gzaꞌ le nac tsca rzaꞌruꞌ tu hora, niꞌr gulaléꞌinëꞌ Jesús rzëꞌi niꞌë lu nis zxön naꞌ, len zëꞌë rbiguëꞌë ga naꞌ zeaj barco naꞌ, atiꞌ gladxi guladzöbnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Niꞌr Jesús rëꞌ lequëꞌ: ―Nédaꞌczaꞌ. Cutu gádxiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Niꞌr len yöl‑laꞌ rudziji quequëꞌ guluguel‑lëꞌë Lëꞌ lëꞌi bárcodauꞌ naꞌ, atiꞌ laꞌ bdxintë bárcodauꞌ naꞌ lu yu bidx ga niꞌ zjaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dza buróp niꞌ, gláquibeꞌi bunách zian naꞌ nagaꞌngac yetsláꞌa nis zxön bdxin niꞌ tuz bárcodauꞌ atiꞌ Jesús cutu grénlenëꞌ yuguꞌ bönniꞌ usë́d queëꞌ lëꞌi bárcodauꞌ naꞌ, san légaczëꞌ naꞌ yjaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Niꞌr gularúj yelaꞌgac bárcodauꞌ lu yödz Tiberias, atiꞌ guladxín tu latj dë gal‑laꞌz ga niꞌ glahuëꞌ yöt xtil catiꞌ niꞌ Xanruꞌ Jesús gudxëꞌ Dios: “Xclenuꞌ”, qui. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Le gulaléꞌinëꞌ cutur zoëꞌ niꞌ Jesús len cutu nacuꞌë niꞌ bönniꞌ usë́d queëꞌ, qui lë ni naꞌ gulabenëꞌ lë́ꞌigac bárcodauꞌ naꞌ, yjaquëꞌ Capernaum, tuꞌguiljëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Catiꞌ guladxín bunách zian naꞌ yetsláꞌa nis zxön naꞌ, yajxácaꞌquëꞌ Jesús, len tëꞌ Lëꞌ: ―Bönniꞌ Usëdi, ¿batx bdxinuꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Ruguiljliꞌ nedaꞌ, clëg le bléꞌiliꞌ yuguꞌ yöl‑laꞌ huac benaꞌ, san le gdáguliꞌ yöt xtil niꞌ len böljliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gul‑gún dxin, clëg quië siꞌliꞌ laꞌ huagu rdöd qui, san quië siꞌliꞌ laꞌ huagu naꞌ ugaꞌntecz, len runn yöl‑laꞌ naꞌbán gdu. Lë ni laꞌ huagu gunnaꞌ queëliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, le buluꞌë lahui Xuzaꞌ Dios nacaꞌ Zxiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Niꞌr gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Bizxa run bayúdx guntuꞌ quië guntuꞌ le rdzag ladxëꞌë Dios? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Lë ni le rdzag ladxëꞌë Dios, quië tséjlëꞌliꞌ nedaꞌ, nacaꞌ nu bsölëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Niꞌr gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Bizxa le nac bëꞌ runuꞌ, le gléꞌituꞌ quië tséjlëꞌtuꞌ Liꞌ? ¿Bizxa yöl‑laꞌ huac runuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Glahuëꞌ xuz xtauꞌruꞌ yöt xtil nazíꞌ lei maná lu latj caꞌz, ca nayúj lu guich laꞌy, rna: “Yöt xtil qui yehuaꞌ yubá bëꞌë quequëꞌ Moisés, glahuëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Clëg Moisés naꞌ bennëꞌ queëliꞌ yöt xtil qui yehuaꞌ yubá, san Xuzaꞌ Dios runnëꞌ queëliꞌ yöt xtil gdu qui yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yöt xtil naꞌ runnëꞌ quegac bunách Dios nacaꞌ nedaꞌ, lë naꞌ bruj yehuaꞌ yubá len runö́dzj quegac bunách yödzlyú ni yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niꞌr tëꞌ Lëꞌ: ―Xan, benntecz queëtuꞌ yöt xtil naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús rëꞌ lequëꞌ: ―Nedaꞌ nacaꞌ yöt xtil nabánigac tsaz bunách. Nu zaꞌlen nedaꞌ, huölj gdzeꞌi tsaz nu naꞌ le nac queëꞌ Dios, atiꞌ nu tsejlëꞌ nedaꞌ, chnëꞌj tsaz le nac queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nac ca naꞌ chgudxczaꞌ lbiꞌiliꞌ, zal‑laꞌ rléꞌiliꞌ nedaꞌ, cutu caꞌ réjlëꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yúguꞌtë nup naꞌ runnëꞌ quiaꞌ Xuzaꞌ, lid quiaꞌ, atiꞌ nup naꞌ lid quiaꞌ, cutu usáꞌgacaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Cni nac, le bötjaꞌ brujaꞌ yehuaꞌ yubá, clëg quië gunaꞌ ca rëꞌndaꞌ nédaꞌczaꞌ, san quië gunaꞌ ca rëꞌnnëꞌ Dios Xuz, nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Lë ni le rëꞌnnëꞌ Xuzaꞌ nasölëꞌë nedaꞌ, rëꞌnnëꞌ cutu unitiaꞌ nitú nup naꞌ bennëꞌ quiaꞌ, san uspanaꞌ lequëꞌ dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Lë ni le rëꞌnnëꞌ Dios Xuz nasölëꞌë nedaꞌ, rëꞌnnëꞌ gataꞌ yöl‑laꞌ naꞌbán quequëꞌ, yúguꞌtë nup naꞌ laꞌleꞌi nedaꞌ, Zxiꞌnëꞌ, len laꞌyejlëꞌë nedaꞌ, atiꞌ nedaꞌ uspanaꞌ lequëꞌ dza udx naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Niꞌr gulanë́ꞌ queëꞌ Jesús bönniꞌ judío uná bëꞌ le gnëꞌ: “Nedaꞌ nacaꞌ yöt xtil naꞌ bötj, bruj yehuaꞌ yubá.” ");
INSERT INTO zsrNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Qui lë ni naꞌ taꞌnë́ꞌ: ―¿Naruꞌ clëg bönniꞌ ni Jesús, zxiꞌnëꞌ José? Núnbëꞌczruꞌ xuz xnëꞌë. ¿Nacxcz nac naꞌ, rnëꞌ bönniꞌ ni: “Bötjaꞌ brujaꞌ yehuaꞌ yubá”? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu gnëliꞌ quiaꞌ laꞌ lbiꞌizliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cutu sáquiꞌnëꞌ guidëꞌ quiaꞌ nitúëꞌ bönniꞌ chquiꞌ cutu duguꞌë quiaꞌ nu naꞌ Xuzaꞌ nasölëꞌë nedaꞌ, atiꞌ nedaꞌ uspanaꞌ nu naꞌ dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nayúj lu guich laꞌy ca gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, rna cni: “Dios usëdnëꞌ yúguꞌtë bunách.” Qui lë ni naꞌ, zaꞌquëꞌ quiaꞌ yúguꞌtë bönniꞌ taꞌyönnëꞌ chiꞌë Xuzaꞌ len nazëdquëꞌ lu nëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nutu nu bönniꞌ bléꞌinëꞌ Dios Xuz, san tuzëꞌ Bönniꞌ naꞌ brujëꞌ ga zoëꞌ Dios. Bönniꞌ ni rléꞌicznëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Le nactë rëpaꞌ lbiꞌiliꞌ: Nútiꞌtëz bönniꞌ rejlëꞌë nedaꞌ dë queëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nedaꞌ nacaꞌ yöt xtil nabánigac tsaz bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Glahuëꞌ xuz xtauꞌliꞌ yöt xtil naꞌ nazíꞌ lei maná lu latj caꞌz, len catiꞌ bzaꞌa dza quequëꞌ glatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nedaꞌ nacaꞌ yöt xtil ruhuö́tj r‑ruj yehuaꞌ yubá, atiꞌ nútiꞌtëz bönniꞌ gahuëꞌ lei, cutu caꞌ gatiëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nédaꞌczaꞌ nacaꞌ yöt xtil naꞌ nabánigac bunách, bötj bruj yehuaꞌ yubá, atiꞌ chquiꞌ nútiꞌtëz bönniꞌ gahuëꞌ yöt xtil naꞌ, gbánteczëꞌ bönniꞌ naꞌ. Yöt xtil naꞌ runödzjaꞌ nedaꞌ nac xpëlaꞌa, le runödzjaꞌ quië gataꞌ yöl‑laꞌ naꞌbán quegac bunách yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Niꞌr gulachixi lzaꞌquëꞌ bönniꞌ judío uná bëꞌ, taꞌnë́ꞌ: ―¿Naruꞌ huactsa bönniꞌ ni gunnëꞌ queëruꞌ xpëlëꞌë gáguruꞌ lei? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Qui lë ni naꞌ Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Chquiꞌ cu gáguliꞌ xpëlaꞌa nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, len chquiꞌ cu guiꞌjliꞌ xchönaꞌ, cutu caꞌ zoalen lbiꞌiliꞌ yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nútiꞌtëz nu gagu xpëlaꞌa len guiꞌj xchönaꞌ, dë qui yöl‑laꞌ naꞌbán gdu, atiꞌ nedaꞌ uspanaꞌ nu naꞌ dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cni gac, le nac xpëlaꞌa laꞌ huagu gdu, atiꞌ xchönaꞌ nac tu le nac gdu quië nu guiꞌj lei. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nútiꞌtëz bönniꞌ gahuëꞌ xpëlaꞌa len guiꞌjëꞌ xchönaꞌ, sóalenteczëꞌ nedaꞌ bönniꞌ naꞌ, atiꞌ nedaꞌ sóalenteczaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ca naꞌ zoëꞌ nabanëꞌ Dios Xuz nasölëꞌë nedaꞌ, atiꞌ nedaꞌ nabánidaꞌ Lëꞌ, lëzcaꞌ cni gbáninëꞌ nedaꞌ nútiꞌtëz bönniꞌ gahuëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lë ni yöt xtil bötj bruj yehuaꞌ yubá, len cutu nac ca yöt xtil naꞌ nazíꞌ lei maná, lë naꞌ glahuëꞌ xuz xtauꞌliꞌ, len catiꞌ bzaꞌa dza quequëꞌ, glatiëꞌ. Nútiꞌtëz bönniꞌ gahuëꞌ yöt xtil ni gbánteczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yuguꞌ didzaꞌ ni bëꞌë Jesús ga nac tu lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ guc lë ni tsal niꞌ rusëdnëꞌ bunách Capernaum. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Catiꞌ gulayönnëꞌ didzaꞌ ni, gulanë́ꞌ qui zian bönniꞌ usë́d queëꞌ Jesús, taꞌnë́ꞌ: ―Banigtë didzaꞌ ni. ¿Nuzxa caz gac siꞌ lu nëꞌi lei? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ráquibeꞌinëꞌ Jesús taꞌnë́ꞌ qui xtidzëꞌë bönniꞌ usë́d queëꞌ, atiꞌ gnabnëꞌ lequëꞌ, rnëꞌ: ―¿Naruꞌ run lbiꞌiliꞌ ziꞌ didzaꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nacxcz gac chquiꞌ hualéꞌiliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, huëpaꞌ huöjaꞌ ga niꞌ zoaꞌ ziꞌal? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Le nac queëꞌ Dios Böꞌ Laꞌy nac le runn queëliꞌ yöl‑laꞌ naꞌbán. Le nac bëlaꞌz cutu caꞌ nu uzíꞌ xbey. Yuguꞌ didzaꞌ naꞌ bë́ꞌlenaꞌ lbiꞌiliꞌ nacgac queëꞌ Dios Böꞌ Laꞌy len tunn quegac bunách yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Naꞌa, laꞌliꞌ cutu réjlëꞌliꞌ. Gnëꞌ cni Jesús le nözcznëꞌ dza niꞌtë nup naꞌ cutaꞌyejlëꞌ, lencaꞌ nu naꞌ udö́d Lëꞌ lu naꞌquëꞌ bönniꞌ ludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Qui lë ni naꞌ gnëꞌ: ―Qui lë ni naꞌ chgudxczaꞌ lbiꞌiliꞌ: “Cutu sáquiꞌnëꞌ tëꞌë nedaꞌ nitúëꞌ bönniꞌ chquiꞌ cutu guꞌë lëꞌ latj Dios Xuz.” ");
INSERT INTO zsrNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dza naꞌ glac chop ládxiꞌquëꞌ zian bönniꞌ usë́d queëꞌ len cutur guladálenëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Niꞌr Jesús gnabnëꞌ idxínnutëꞌ bönniꞌ usë́d queëꞌ naꞌ, rëꞌ lequëꞌ: ―¿Naruꞌ ubígaꞌtsaliꞌ caꞌ lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bubiꞌë didzaꞌ Pedro, rëꞌ Lëꞌ: ―Xan, ¿nuzxa qui tseajtuꞌ? Liꞌ napuꞌ didzaꞌ tunn queëtuꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Netuꞌ ni réjlëꞌtuꞌ Liꞌ, len núnbëꞌtuꞌ Liꞌ, nacuꞌ Cristo naꞌ nasölëꞌë Dios, len nacuꞌ caꞌ Zxiꞌnëꞌ Dios ban. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Gröczaꞌ lbiꞌiliꞌ chínnuliꞌ ni, san tuëꞌ bönniꞌ ladj lbiꞌiliꞌ dzag lëꞌ tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Didzaꞌ ni bëꞌë Jesús queëꞌ Judas Iscariote, zxiꞌnëꞌ tu bönniꞌ lëꞌ Simón, le naquëꞌ Judas bönniꞌ naꞌ udödëꞌ Jesús lu naꞌquëꞌ bönniꞌ ludöddëꞌ Lëꞌ, len nabáblenëꞌ yechineajëꞌ bönniꞌ usë́d queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gdöd guc lë ni gdëꞌ Jesús luyú Galilea. Cutu guꞌnnëꞌ tsijëꞌ luyú Judea le tëꞌnnëꞌ bönniꞌ judío uná bëꞌ niꞌ ludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dza niꞌ chzoa gdxin lni quequëꞌ bönniꞌ judío catiꞌ tuꞌspanëꞌ ca gulacuꞌë zxan lbin lágaꞌdauꞌ xuz xtauꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Qui lë ni naꞌ tëꞌ Jesús bönniꞌ böchëꞌë, taꞌnë́ꞌ: ―Bruj ni len gyeaj luyú Judea quië laꞌléꞌinëꞌ caꞌ yuguꞌ yöl‑laꞌ huac runuꞌ bönniꞌ usë́d quiuꞌ nacuꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chquiꞌ rëꞌnnëꞌ bönniꞌ lunbëꞌ lëꞌ bunách, cutu runëꞌ bagachiꞌz le runëꞌ. Le runuꞌ yuguꞌ yöl‑laꞌ huac cni, bluiꞌ cuinuꞌ laugac yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cni gulanë́ꞌ, le cu taꞌyejlëꞌë Jesús bönniꞌ böchëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Niꞌr Jesús rëꞌ lequëꞌ: ―Cutu rdxini dza quiaꞌ uluíꞌ lahuaꞌ laugac bunách, san dza queëliꞌ tseajliꞌ niꞌ chzoacz. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cutu tuꞌzóa lbiꞌiliꞌ tslaꞌl bunách yödzlyú ni, san tuꞌzóa nedaꞌ tslaꞌl le runaꞌ lnaꞌ lau quequëꞌ, rniaꞌ nac xöhuiꞌ le tunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gul‑tséaj lbiꞌiliꞌ lni naꞌ. Cutu tsijaꞌ naꞌa lni naꞌ le cutu rdxini dza quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Catiꞌ chgudxëꞌ lequëꞌ lë ni, bugaꞌnëꞌ niꞌ luyú Galilea. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gdöd zjaquëꞌ lni naꞌ bönniꞌ böchëꞌë Jesús, niꞌr zijëꞌ caꞌ Lëꞌ, clëg yalj lulu, san bagachiꞌz zijëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ga naꞌ rac lni naꞌ, guluguiljëꞌ Jesús bönniꞌ judío uná bëꞌ, taꞌnë́ꞌ: ―¿Gazx zoëꞌ bönniꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Szxöni gluiꞌ didzaꞌ ca nac queëꞌ Jesús bunách zian niꞌ. Laꞌquëꞌ taꞌnë́ꞌ: ―Naquëꞌ dxiꞌa. Yelaꞌquëꞌ taꞌnë́ꞌ: ―Cutu naquëꞌ dxiꞌa le rziꞌ yéꞌinëꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Cutu bëꞌë didzaꞌ yalj lulu ca nac queëꞌ Jesús nitúëꞌ bönniꞌ, le tadxi yuguꞌ bönniꞌ judío uná bëꞌ bunách zian naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Catiꞌ chbdxin gatsj lni naꞌ, blëꞌë Jesús raꞌ gdauꞌ len busëdnëꞌ bunách nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Gulubannëꞌ bönniꞌ judío, taꞌnë́ꞌ: ―¿Nacxcz nac, raquëꞌ szxöni bönniꞌ ni len cutu caꞌ nazëdëꞌ qui gdauꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Le rusëddaꞌ nedaꞌ, clëg quiaꞌ naꞌ, san queëꞌ Dios Xuz naꞌ nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chquiꞌ rëꞌnnëꞌ nu bönniꞌ gunëꞌ ca rëꞌnnëꞌ Dios, huáquibeꞌinëꞌ bönniꞌ naꞌ chquiꞌ naqui queëꞌ Dios le rusëddaꞌ bunách o chquiꞌ racz quiaꞌ ruꞌa didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu bönniꞌ ruꞌë didzaꞌ racz queëꞌ, runëꞌ cni quië lun lëꞌ ba laꞌn bunách, san bönniꞌ naꞌ rëꞌnnëꞌ lun bunách ba laꞌn nu nasölaꞌ lëꞌ, bönniꞌ ni ruꞌë didzaꞌ gdutë li len cutu caꞌ rziꞌ yëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Bennëꞌ queëliꞌ zxba queëꞌ Dios Moisés, san nituliꞌ cutu runliꞌ ca rna bëꞌ zxba naꞌ. ¿Bizx quië rzu rböꞌliꞌ gdö́diliꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gulubíꞌi didzaꞌ bunách zian naꞌ, të Lëꞌ: ―Tuꞌ xöhuiꞌ dzag liꞌ. ¿Nuzxa caz rzu rböꞌ gdödi liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Tu yöl‑laꞌ huac benaꞌ, atiꞌ rubániliꞌ yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Le nactë bennëꞌ queëliꞌ Moisés lë naꞌ nac bëꞌ narugu lu xpë́laꞌliꞌ. Clëg Moiséscz bennëꞌ queëliꞌ lë naꞌ, san gzxiꞌë lei lu naꞌquëꞌ xuz xtauꞌhuëꞌ. Naꞌa, zal‑laꞌ nac dza laꞌy, rchúguliꞌ lu xpë́laꞌcbiꞌ biꞌi bö́nniꞌdauꞌ lë naꞌ nac bëꞌ náquicbiꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chquiꞌ taꞌziꞌbiꞌ lu xpë́laꞌcbiꞌ lë naꞌ nac bëꞌ catiꞌ nac dza laꞌy, cui quitsjliꞌ zxba queëꞌ Moisés, ¿naruꞌ rléytsaliꞌ nedaꞌ le bunaꞌ‑nëꞌ bönniꞌ, böaquëꞌ dxíꞌadauꞌ catiꞌ nac dza laꞌy? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Cutu ral‑laꞌ cuequi xbeyzliꞌ caꞌ, san gul‑bequi xbey ca rajlö́z le nac gdutë li. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Niꞌr gluꞌë didzaꞌ laꞌquëꞌ bönniꞌ nacuꞌë Jerusalén, taꞌnë́ꞌ: ―¿Naruꞌ clëg bönniꞌ ni nu naꞌ tuꞌguiljëꞌ bönniꞌ judío uná bëꞌ quië ludöddëꞌ Lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gul‑yutscaꞌ, yalj lulu ruꞌë didzaꞌ len cutu bi tëꞌ Lëꞌ. ¿Naruꞌ táquibeꞌinëꞌ bönniꞌ taꞌná béꞌinëꞌ rëꞌu, le nactë bönniꞌ ni naquëꞌ Cristo, Nu naꞌ ral‑laꞌ gna beꞌi rëꞌu? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bönniꞌ ni, nö́ziczruꞌ gazx bönniꞌ Lëꞌ. Catiꞌ guidëꞌ Cristo, nutu nu gnözi gazx bönniꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Niꞌ zoëꞌ Jesús rusëdnëꞌ bunách nchil gdauꞌ, len catiꞌ byönnëꞌ didzaꞌ ni, niꞌr bëꞌë zidzj didzaꞌ, rnëꞌ: ―¿Naruꞌ núnbëꞌtsaliꞌ nedaꞌ len nö́zitsaliꞌ gazx bönniꞌ nedaꞌ? Bidaꞌ ni, clëg racz quiaꞌ, san Dioscz nasölëꞌë nedaꞌ, atiꞌ Lëꞌ, cutu núnbëꞌliꞌ‑nëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nedaꞌ núnbëꞌa‑nëꞌ, le zaꞌa queëꞌ Lëꞌ atiꞌ Lëczëꞌ nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niꞌr glunëꞌ bayúdx laꞌzönëꞌ Lëꞌ, san nutu nu gzxön Lëꞌ, le cutu rdxini dza queëꞌ tsuꞌë lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gulayejlëꞌ Lëꞌ zian bunách niꞌ, taꞌná: ―Catiꞌ guidëꞌ Cristo, ¿naruꞌ gunëꞌ zianr yöl‑laꞌ huac ca le runëꞌ bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Gulayönnëꞌ bönniꞌ gdauꞌ fariseo yuguꞌ didzaꞌ ni tuiꞌ bunách ca nac queëꞌ Jesús, atiꞌ gulasölëꞌë niꞌa naꞌquëꞌ tsajxönquëꞌ Jesús yuguꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ gdauꞌ fariseo naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Niꞌr Jesús gnëꞌ: ―Yetú chiꞌz sóalenaꞌ lbiꞌiliꞌ atiꞌ niꞌr huöjaꞌ ga zoëꞌ Xuzaꞌ nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Uguiljliꞌ nedaꞌ san cutu udzö́liliꞌ nedaꞌ. Ga niꞌ tsajsóaꞌ nedaꞌ cutu gac guidliꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Niꞌr tëꞌ lzaꞌquëꞌ bönniꞌ judío, taꞌnë́ꞌ: ―¿Gazx tseajtsëꞌ bönniꞌ ni, ga niꞌ cutu udzö́liruꞌ‑nëꞌ? ¿Naruꞌ huayeajtsëꞌ ga nacuꞌë bönniꞌ judío náslasquëꞌ gdutë yödzlyú len usëdnëꞌ yuguꞌ bönniꞌ gzaꞌa niꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Bizxa rëꞌni gna didzaꞌ naꞌ bëꞌë: “Uguiljliꞌ nedaꞌ san cutu udzö́liliꞌ nedaꞌ”, lencaꞌ: “Ga niꞌ tsajsóaꞌ nedaꞌ cutu gac guidliꞌ lbiꞌiliꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Catiꞌ niꞌ nac dza udx qui lni naꞌ, dza naꞌ nac blau, gyasëꞌ gzuinëꞌ Jesús len bëꞌë zidzj didzaꞌ, rnëꞌ: ―Chquiꞌ zoëꞌ bönniꞌ rbidx icj ládxiꞌdauꞌhuëꞌ, ral‑laꞌ guidëꞌ ga zoaꞌ bönniꞌ naꞌ len guiꞌjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nu bönniꞌ rejlëꞌë nedaꞌ, gac queëꞌ ca naꞌ nayúj lu guich laꞌy, rna: “Lu icj ládxiꞌdauꞌhuëꞌ bönniꞌ naꞌ glen le nac ca nis yegu”, lë naꞌ luzíꞌ xbey bunách, gataꞌ quequëꞌ yöl‑laꞌ naꞌbán. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Didzaꞌ ni bëꞌë Jesús ca nac queëꞌ Dios Böꞌ Laꞌy, Nu ral‑laꞌ dusoalen bönniꞌ naꞌ laꞌyejlëꞌë Jesús. Cni gnëꞌ Jesús le cutu rdxíninëꞌ Dios Böꞌ Laꞌy, le cutu ruhuëpnëꞌ Jesús ga gáctërëꞌ blau. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Catiꞌ gulayöni didzaꞌ ni, gulaná laꞌgac bunách zian naꞌ, taꞌná: ―Le nactë naquëꞌ bönniꞌ ni bönniꞌ naꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, bönniꞌ naꞌ gzxiꞌ lu nëꞌë Dios gsölëꞌë queëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Taꞌnë́ꞌ yelaꞌquëꞌ: ―Naquëꞌ Cristo bönniꞌ ni. Taꞌná laꞌgac bunách: ―¿Naruꞌ Galilea grujtsëꞌ Cristo? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nayúj lu guich laꞌy le rna: “Cristo galjëꞌ ladj zxiꞌn xsoëꞌ David len gaquëꞌ caꞌ bönniꞌ Belén le guc ladzëꞌ David naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Cni guc, gularúj chopl bunách naꞌ niꞌa queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tëꞌnnëꞌ laꞌquëꞌ laꞌzönëꞌ Jesús san nutu nu bi ben queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Niꞌr guludxinëꞌ niꞌa naꞌquëꞌ yuguꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ gdauꞌ fariseo ga naꞌ nacuꞌë bönniꞌ gdauꞌ naꞌ, atiꞌ lequëꞌ glëꞌ niꞌa naꞌquëꞌ naꞌ, taꞌnë́ꞌ: ―¿Bizx quië cutu zuchëꞌliꞌ‑nëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gulubiꞌë didzaꞌ niꞌa naꞌquëꞌ, taꞌnë́ꞌ: ―Nutu nu bönniꞌ ruꞌë didzaꞌ ca ruꞌë didzaꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Niꞌr gulubiꞌë didzaꞌ bönniꞌ gdauꞌ fariseo naꞌ, taꞌnë́ꞌ: ―¿Naruꞌ bë́ꞌtsaliꞌ latj gzxiꞌ yéꞌinëꞌ caꞌ lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Naruꞌ gyéjlëꞌtsëꞌ Lëꞌ nu bönniꞌ uná bëꞌ o nu bönniꞌ gdauꞌ fariseo? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bönniꞌ ni cutaquëꞌ zxba queëꞌ Dios, döꞌ dxiaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Zoëꞌ caꞌ niꞌ Nicodemo, bönniꞌ naꞌ bdxinëꞌ ga zoëꞌ Jesús chdzöꞌl, le naquëꞌ caꞌ bönniꞌ gdauꞌ fariseo, atiꞌ rëꞌ lequëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Naruꞌ rusyúdxtsaruꞌ bönniꞌ lu zxba queëruꞌ chquiꞌ cutu yö́niruꞌ lëꞌ ziꞌal quië gnö́ziruꞌ bi benëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Niꞌr gulubiꞌë didzaꞌ yezícaꞌrëꞌ naꞌ, tëꞌ lëꞌ: ―¿Nactsuꞌ caꞌ liꞌ bönniꞌ Galilea? Blab le nayúj lu guich laꞌy atiꞌ uyúꞌ gatga bruj luyú Galilea nitúëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Niꞌr qui queëquëꞌ yhuöjquëꞌ lidxquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Gyijëꞌ Jesús ga nac lu Guiꞌa Ga Röꞌgac Yag Olivo. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Catiꞌ zaꞌ reníꞌ budxinëꞌ Jesús raꞌ gdauꞌ, atiꞌ guladxín ga zoëꞌ yúguꞌtë bunách. Gröꞌë niꞌ Jesús, rusëdnëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Niꞌr duchëꞌquëꞌ‑nu ga zoëꞌ Jesús ngul, bönniꞌ gdauꞌ tuꞌsëdi len yuguꞌ bönniꞌ gdauꞌ fariseo, guladzölnëꞌ‑nu niꞌ rguitsjnu zxba qui yöl‑laꞌ nutság naꞌ. Guluschinëꞌ‑nu laugac bunách naꞌ tuꞌzë́ naggac Jesús, ");
INSERT INTO zsrNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","atiꞌ tëꞌ Lëꞌ: ―Bönniꞌ Usëdi, ngul ni gzxöntuꞌ‑nu niꞌ runnu dul‑laꞌ rguitsjnu zxba qui yöl‑laꞌ nutság naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lu zxba queëꞌ Moisés, gna béꞌinëꞌ netuꞌ uládxiꞌtuꞌ‑nu guiöj ngul runnu cni, gatnu. ¿Nazxga Liꞌ, nacx rnauꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cni gulanë́ꞌ quië laꞌzíꞌ bëꞌë Jesús quië laꞌzáquiꞌnëꞌ luquíëꞌ Lëꞌ. Niꞌr byechuëꞌ Jesús, ruyúëꞌ lyu len ruzujëꞌ lyu naꞌ len xbönniꞌ nëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Catiꞌ gulanábtsquinëꞌ Lëꞌ, niꞌr buzuinëꞌ Jesús len rëꞌ lequëꞌ: ―Nul‑liꞌ cununliꞌ dul‑laꞌ su lauliꞌ uládxiꞌliꞌ‑nu guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Leyúbl byechuëꞌ Jesús, ruyúëꞌ lyu len bguel‑lëꞌë ruzujëꞌ leyúbl lyu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Catiꞌ gulayönnëꞌ didzaꞌ ni, guluxö́s lequëꞌ ládxiꞌdauꞌquëꞌ, atiꞌ gularujëꞌ tu tuëꞌ, gulazú lauquëꞌ bönniꞌ gulr ga bdxintë bönniꞌ cuidiꞌ. Nagaꞌnëꞌ niꞌ Jesús, dzagnu Lëꞌ ngul naꞌ zoanu gatsj lahuiꞌl nup naꞌ tuꞌzë́ naggac Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Niꞌr buzuinëꞌ leyúbl Jesús, len nutu nu bléꞌinëꞌ nu ruquí lënu, san tuznu ngul naꞌ, atiꞌ rëꞌ‑nu: ―Ngul, ¿gazx nacuáꞌ nup naꞌ guluquí liꞌ? ¿Naruꞌ cutu zoa nu bönniꞌ rchuguëꞌ quiuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lënu rnanu: ―Nutu nucz, Xan. Niꞌr Jesús rëꞌ‑nu: ―Lëzcaꞌ nedaꞌ, cutu rchugaꞌ quiuꞌ. Böaj lidxuꞌ, len cutur gunuꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Leyúbl bë́ꞌlenëꞌ lequëꞌ didzaꞌ Jesús, rnëꞌ: ―Nedaꞌ nacaꞌ yeníꞌ quegac bunách yödzlyú. Nu bönniꞌ záꞌlenëꞌ nedaꞌ, cutu tëꞌ ga chul xöhuiꞌ san soalen bönniꞌ naꞌ yeníꞌ uluíꞌi lëꞌ nac gataꞌ yöl‑laꞌ naꞌbán gdu queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Niꞌr tëꞌ Lëꞌ bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―Liꞌ runuꞌ lnaꞌ lau qui laꞌ cuinzuꞌ. Cutu nac lsacaꞌ le runuꞌ lnaꞌ lau. Daduz nac. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Zal‑laꞌ runaꞌ lnaꞌ lau qui laꞌ cuinzaꞌ, gdutë li nac le runaꞌ lnaꞌ lau, le nözdaꞌ ga brujaꞌ len ga tsijaꞌ, san lbiꞌiliꞌ cutu nö́ziliꞌ gazx zaꞌa len clëg gazx tsijaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lbiꞌiliꞌ rbequi xbeyliꞌ ca le tac yödzlyú ni, san nedaꞌ, racz quiaꞌ nutu nu bönniꞌ cutu rbequi xbeydaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Laꞌnaruꞌ cuequi xbeydaꞌ, ca nacz cuequi xbeydaꞌ, le clëg nedaꞌz cuequi xbeydaꞌ, san gunëꞌ nedaꞌ tsazxö́n Xuzaꞌ nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lëzcaꞌ cni lu zxba queëꞌ Moisés nayúj lu guich le rna: “Le tunëꞌ lnaꞌ lau chopëꞌ bönniꞌ, gdutë li nac.” ");
INSERT INTO zsrNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nedaꞌ runaꞌ lnaꞌ lau qui laꞌ cuinzaꞌ, atiꞌ Xuzaꞌ nasölëꞌë nedaꞌ, runëꞌ caꞌ lnaꞌ lau quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Niꞌr gulanabnëꞌ Lëꞌ bönniꞌ gdauꞌ fariseo naꞌ, taꞌnë́ꞌ: ―¿Gazx zoatsëꞌ Xuzuꞌ? Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu núnbëꞌliꞌ nedaꞌ, len cutu núnbëꞌliꞌ‑nëꞌ Xuzaꞌ. Laꞌnaruꞌ núnbëꞌliꞌ nedaꞌ, lëzcaꞌ Xuzaꞌ gúnbëꞌliꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yuguꞌ didzaꞌ ni bëꞌë Jesús catiꞌ niꞌ zoëꞌ rusëdnëꞌ bunách nchil gdauꞌ, ga naꞌ nacuáꞌ guiꞌn gap taꞌguꞌë gun qui gdauꞌ, san nutu nu gzxön Lëꞌ, le cutu rdxini dza queëꞌ tsuꞌë lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Leyúbl rëꞌ lequëꞌ Jesús, rnëꞌ: ―Uzáꞌa yödzlyú ni, atiꞌ uguiljliꞌ nu uslá lbiꞌiliꞌ, san ugáꞌn dul‑laꞌ nabágaꞌliꞌ, gatliꞌ. Ga tsijaꞌ nedaꞌ, cutu gac guidliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Niꞌr gluꞌë didzaꞌ bönniꞌ judío uná bëꞌ, taꞌnë́ꞌ: ―¿Naruꞌ gdödi cuinëꞌ? Rnëꞌ: “Ga tsijaꞌ nedaꞌ, lbiꞌiliꞌ cutu gac guidliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús rëꞌ lequëꞌ: ―Lbiꞌiliꞌ nacliꞌ qui luyú dë dxiꞌl ni, san nedaꞌ zaꞌa yehuaꞌ yubá xtsaꞌ. Lbiꞌiliꞌ nacliꞌ bunách yödzlyú ni, san nedaꞌ cutu nacaꞌ bönniꞌ yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Qui lë ni naꞌ gudxaꞌ lbiꞌiliꞌ: “Ugáꞌn dul‑laꞌ nabágaꞌliꞌ, gatliꞌ.” Chquiꞌ cutu tséjlëꞌliꞌ nacczaꞌ Nu uslá, ugáꞌn dul‑laꞌ nabágaꞌliꞌ, gatliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Niꞌr gulanabnëꞌ Lëꞌ, taꞌnë́ꞌ: ―¿Nuzxa caz nacuꞌ? Jesús rëꞌ lequëꞌ: ―Nacaꞌ laꞌ leyz ca naꞌ chgudxaꞌ lbiꞌiliꞌ dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Zian le ral‑laꞌ gyëpaꞌ lbiꞌiliꞌ len cuequi xbeydaꞌ le nac queëliꞌ. Didzaꞌ gdutë li ruꞌë Xuzaꞌ nasölëꞌë nedaꞌ, atiꞌ didzaꞌ byöndaꞌ ruꞌë Lëꞌ, ruíꞌlenaꞌ bunách yödzlyú ni didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Cutu gulayéjniꞌnëꞌ ruíꞌlenëꞌ lequëꞌ didzaꞌ ca nac queëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Qui lë ni naꞌ Jesús rëꞌ lequëꞌ: ―Catiꞌ gdxin dza uchisliꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, gdö́diliꞌ nedaꞌ, niꞌr gáquibeꞌiliꞌ nacczaꞌ Nu ruslá, len cutu bi runaꞌ racz quiaꞌ, san ca naꞌ buluiꞌinëꞌ nedaꞌ Xuzaꞌ, caꞌ ruꞌa didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Zóalenëꞌ nedaꞌ Xuzaꞌ nasölëꞌë nedaꞌ. Cutu nucaꞌnëꞌ nedaꞌ tuzaꞌ Xuzaꞌ, le rúnteczaꞌ le rdzag ladxëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Catiꞌ bëꞌë didzaꞌ ni Jesús, gulayejlëꞌë Lëꞌ bönniꞌ zian. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Niꞌr Jesús gudxëꞌ bönniꞌ judío naꞌ taꞌyejlëꞌë Lëꞌ, rnëꞌ: ―Chquiꞌ gúnteczliꞌ ca rna xtidzaꞌa, gacliꞌ gdu bönniꞌ usë́d quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gúnbëꞌliꞌ le nac gdutë li atiꞌ usán lbiꞌiliꞌ le nac gdutë li naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gulubiꞌë didzaꞌ, tëꞌ Lëꞌ: ―Zxiꞌn xsoëꞌ Abraham nactuꞌ, len nutu nu ben netuꞌ bönniꞌ nadáꞌugac. ¿Atiꞌ rnatsuꞌ: “Usán lbiꞌiliꞌ”? ");
INSERT INTO zsrNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Yúguꞌtë nup tun dul‑laꞌ, nadzungac lu naꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cutu ugaꞌntecz lidxëꞌ xan yuꞌu nu nac bönniꞌ nadaꞌu, san nu nac zxiꞌnëꞌ xan yuꞌu naꞌ rugaꞌntecz lidx nu naꞌ nac xan yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Cni nac, chquiꞌ usán lbiꞌiliꞌ Nu naꞌ nac Zxiꞌnëꞌ Dios, le nactë ulaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nözdaꞌ nacliꞌ zxiꞌn xsoëꞌ Abraham, san rzu rböꞌliꞌ gdö́diliꞌ nedaꞌ, le cunazíꞌ lu naꞌliꞌ xtidzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nedaꞌ ruꞌa didzaꞌ ca nac le bléꞌidaꞌ ga naꞌ zoëꞌ Xuzaꞌ, san lbiꞌiliꞌ runliꞌ le byö́niliꞌ ga zoa xuzczliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gulubiꞌë didzaꞌ, tëꞌ Lëꞌ: ―Abraham naquëꞌ xuztuꞌ. Niꞌr Jesús rëꞌ lequëꞌ: ―Laꞌnaruꞌ nacliꞌ gdu zxiꞌn xsoëꞌ Abraham, gunliꞌ ca naꞌ benëꞌ Abraham. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Naꞌa, rzu rböꞌliꞌ gdö́diliꞌ nedaꞌ, zal‑laꞌ ruíꞌlenaꞌ lbiꞌiliꞌ didzaꞌ gdutë li, didzaꞌ naꞌ byöndaꞌ bëꞌë Dios. Cutu benëꞌ cni Abraham. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lbiꞌiliꞌ runliꞌ ca run xuzczliꞌ. Niꞌr tëꞌ Lëꞌ: ―Netuꞌ cutu caꞌ nactuꞌ biꞌi lagu. Tuzëꞌ Dios naquëꞌ Xuztuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Niꞌr Jesús rëꞌ lequëꞌ: ―Laꞌnaruꞌ naquëꞌ Dios gdu Xuzliꞌ, huadxiꞌiliꞌ nedaꞌ, le brujaꞌ nedaꞌ ga zoëꞌ Dios, bidaꞌ luyú ni, len clëg racz quiaꞌ bidaꞌ, san Dioscz bsölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bizx quië cutu gac tséjniꞌliꞌ didzaꞌ ruꞌa? Nac le curë́ꞌniliꞌ uzë́ nagliꞌ xtidzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xuzczliꞌ nac tuꞌ xöhuiꞌ. Náquiliꞌ qui tuꞌ xöhuiꞌ len rë́ꞌniliꞌ gunliꞌ le rzë ladxiꞌ xuzliꞌ naꞌ. Dza niꞌtë nac gdödi bunách tuꞌ xöhuiꞌ len cutu nazíꞌ lu nëꞌi le nac gdutë li, le cutu caꞌ ruiꞌ didzaꞌ gdutë li. Catiꞌ rziꞌ yëꞌ tuꞌ xöhuiꞌ, ca naccz ruiꞌ didzaꞌ, le nac nu rziꞌ yëꞌ, len nac ca xuzgaccz nup taꞌzíꞌ yëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Le ruꞌa nedaꞌ didzaꞌ gdutë li cutu réjlëꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Núzxal‑liꞌ gac uspágaꞌliꞌ nedaꞌ dul‑laꞌ? Chquiꞌ ruꞌa didzaꞌ gdutë li, ¿bizx quië cutu réjlëꞌliꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nu nac queëꞌ Dios, ruzë́ nag xtidzëꞌë Dios, san lbiꞌiliꞌ, le cunacliꞌ queëꞌ Dios, cutu ruzë́ nagliꞌ xtidzëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Niꞌr gulubiꞌë didzaꞌ bönniꞌ judío, tëꞌ Jesús: ―Catëz gnatuꞌ catiꞌ gnatuꞌ nacuꞌ bönniꞌ Samaria, atiꞌ dzag Liꞌ tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu dzag nedaꞌ tuꞌ xöhuiꞌ. Nedaꞌ runaꞌ Xuzaꞌ ba laꞌn, atiꞌ lbiꞌiliꞌ ruzoaliꞌ nedaꞌ tslaꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Cutu runaꞌ zxön cuinaꞌ. Zoa Nu run zxön nedaꞌ, atiꞌ Lëꞌ rbequi xbeynëꞌ rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Le nactë rëpaꞌ lbiꞌiliꞌ: Nu bönniꞌ siꞌ lu nëꞌë xtidzaꞌa, cutu caꞌ gatiëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Niꞌr tëꞌ Lëꞌ bönniꞌ judío naꞌ, taꞌnë́ꞌ: ―Naꞌa ráquibeꞌituꞌ dzag Liꞌ tuꞌ xöhuiꞌ. Abraham gutiëꞌ, atiꞌ glatiëꞌ caꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, san Liꞌ rnauꞌ: “Nu bönniꞌ siꞌ lu nëꞌë xtidzaꞌa, cutu caꞌ gatiëꞌ bönniꞌ naꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Naruꞌ náctërtsuꞌ Liꞌ blau ca xuzruꞌ Abraham? Gutiëꞌ lëꞌ atiꞌ glatiëꞌ caꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. ¿Núzxatër run cuinuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Chquiꞌ nedaꞌ gunaꞌ zxön cuinaꞌ, yöl‑laꞌ zxön naꞌ cutu bi gac. Xuzaꞌ runëꞌ nedaꞌ zxön, atiꞌ lbiꞌiliꞌ rnaliꞌ naquëꞌ Dios queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lbiꞌiliꞌ cutu núnbëꞌliꞌ‑nëꞌ Dios Xuz, san nedaꞌ núnbëꞌa‑nëꞌ. Laꞌnaruꞌ gniaꞌ: Cutu núnbëꞌa‑nëꞌ, gacaꞌ nu rziꞌ yëꞌ ca naꞌ nacliꞌ lbiꞌiliꞌ, rziꞌ yëꞌliꞌ. Naꞌa, le nactë núnbëꞌa‑nëꞌ len nazíꞌ lu naꞌa xtidzëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xuzliꞌ Abraham budzijnëꞌ le ral‑laꞌ gléꞌinëꞌ dza soaꞌ yödzlyú ni, len zal‑laꞌ gutiëꞌ dza niꞌtë, bléꞌinëꞌ lei, len budzíjtsquinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Niꞌr tëꞌ Jesús bönniꞌ judío naꞌ, taꞌnë́ꞌ: ―Cutu yuiꞌnuꞌ chiʉ́n iz. ¿Naruꞌ bléꞌitsanuꞌ Abraham? ");
INSERT INTO zsrNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús rëꞌ lequëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Zíꞌatël ca soëꞌ Abraham, nedaꞌ zoaczaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Niꞌr gulaguel‑lëꞌë guiöj luladxëꞌ Jesús, san Lëꞌ bunittë cuinëꞌ, burujëꞌ löꞌa gdauꞌ naꞌ. Gdödëꞌ gatsj lahuiꞌl ga naꞌ nacuꞌë, zhuöjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Catiꞌ gdödëꞌ Jesús tu latj, bléꞌinëꞌ niꞌ bönniꞌ guljëꞌ nachultë lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gulanabnëꞌ Jesús bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, ¿nuzxa ben dul‑laꞌ? ¿Naruꞌ bönniꞌ ni o xuz xnëꞌë le guljëꞌ nachultë lahuëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Cutu nac le benëꞌ dul‑laꞌ bönniꞌ ni, len clëg le glunëꞌ dul‑laꞌ xuz xnëꞌë, san nac quië glaꞌ lahui yöl‑laꞌ huac queëꞌ Dios niꞌa queëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Run bayúdx gunruꞌ xchinëꞌ Xuzaꞌ nasölëꞌë nedaꞌ, tsal ni nac ca lahuiꞌ dza. Huadxín dza gac chul qui yöl‑laꞌ gut, catiꞌ nutu nu gac gun dxin. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tsal ni zoaꞌ yödzlyú ni, nacaꞌ yeníꞌ quegac bunách yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Catiꞌ budx bëꞌë didzaꞌ ni Jesús, gruꞌnëꞌ zxönaꞌ lyu, atiꞌ benëꞌ gúnaꞌdauꞌ len zxönaꞌ naꞌ, len buguꞌë gunaꞌ naꞌ yöj lahuëꞌ bönniꞌ naꞌ nachúl lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Niꞌr rëꞌ lëꞌ: ―Gyeaj yajtíb lauꞌ lu biaj nis nazíꞌ lei Siloé. Siloé nac tu didzaꞌ hebreo le rna: “Nasölaꞌ”. Niꞌr gyijëꞌ niꞌ bönniꞌ naꞌ nachúl lahuëꞌ, yajtíb lahuëꞌ. Catiꞌ buzë́ꞌë niꞌ chrléꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Niꞌr gulubani bunách dzag yuꞌu queëꞌ len nup niꞌ gulaleꞌi lëꞌ zíꞌatël catiꞌ niꞌ nachúl lahuëꞌ, taꞌná: ―¿Naruꞌ clëg bönniꞌ ni bönniꞌ naꞌ rböꞌë rnabëꞌ nu bi gnödzj queëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Laꞌquëꞌ taꞌnë́ꞌ: ―Lëꞌ naꞌ. Yelaꞌquëꞌ taꞌnë́ꞌ: ―Cutu caꞌ, san ca rnaꞌ lahuëꞌ bönniꞌ naꞌ, rnaꞌ lahuëꞌ caꞌ bönniꞌ ni. Lëꞌ rnëꞌ: ―Nedaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Niꞌr gulanabnëꞌ lëꞌ, taꞌnë́ꞌ: ―¿Nacxcz guc, gyalj yöj lauꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Bubiꞌë didzaꞌ, rëꞌ lequëꞌ: ―Bönniꞌ naꞌ lëꞌ Jesús benëꞌ gúnaꞌdauꞌ atiꞌ gdëbëꞌ yöj lahuaꞌ gúnaꞌdauꞌ naꞌ, len gudxëꞌ nedaꞌ: “Gyeaj raꞌ biaj nis nazíꞌ lei Siloé, yajtíb lauꞌ.” Gyijaꞌ niꞌ, yajtíb lahuaꞌ, atiꞌ gyaljtë yöj lahuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Niꞌr gulanabnëꞌ lëꞌ, taꞌnë́ꞌ: ―¿Gazx zoëꞌ bönniꞌ naꞌ? Lëꞌ rëꞌ lequëꞌ: ―Cutu nözdaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Niꞌr gulachë́ꞌë bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ, guluschinëꞌ lëꞌ lauquëꞌ bönniꞌ gdauꞌ fariseo. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Le nac dza laꞌy quequëꞌ catiꞌ benëꞌ Jesús gúnaꞌdauꞌ naꞌ, len bsaljëꞌ yöj lahuëꞌ bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","qui lë ni naꞌ gulanabnëꞌ lëꞌ leyúbl bönniꞌ gdauꞌ fariseo naꞌ nacx guc gyalj yöj lahuëꞌ. Lëꞌ gudxëꞌ lequëꞌ: ―Budxíëꞌ gúnaꞌdauꞌ yöj lahuaꞌ, atiꞌ yajtibaꞌ lei len rléꞌidaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Niꞌr gluꞌë didzaꞌ laꞌquëꞌ bönniꞌ gdauꞌ fariseo naꞌ, taꞌnë́ꞌ: ―Cutu naquëꞌ queëꞌ Dios bönniꞌ naꞌ, le curún chiꞌë dza laꞌy. Yelaꞌquëꞌ taꞌnë́ꞌ: ―¿Naruꞌ huactsa bönniꞌ dul‑laꞌ gunëꞌ yuguꞌ yöl‑laꞌ huac runëꞌ bönniꞌ naꞌ? Cni guc, gularujëꞌ chopl. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Leyúbl gulanabnëꞌ bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ, taꞌnë́ꞌ: ―¿Bizxa rnauꞌ liꞌ queëꞌ bönniꞌ naꞌ, bsaljëꞌ yöj lauꞌ? Lëꞌ rnëꞌ: ―Naquëꞌ bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Cutu gulayejlëꞌë bönniꞌ judío uná bëꞌ naꞌ guljëꞌ nachultë lahuëꞌ bönniꞌ naꞌ, len gyalj yöj lahuëꞌ, catiꞌ gululidzrëꞌ xuz xnëꞌë bönniꞌ naꞌ gyalj yöj lahuëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","len gulanabnëꞌ lequëꞌ, taꞌnë́ꞌ: ―¿Naruꞌ naquëꞌ zxiꞌnliꞌ bönniꞌ ni, rnaliꞌ guljëꞌ nachultë lahuëꞌ? ¿Nacxcz nac rléꞌinëꞌ naꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Gulubiꞌë didzaꞌ xuz xnëꞌë naꞌ, tëꞌ lequëꞌ: ―Nö́zituꞌ naquëꞌ zxiꞌntuꞌ bönniꞌ ni, len guljëꞌ nachultë lahuëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","san nacx guc, rléꞌinëꞌ naꞌa, cutu nö́zituꞌ, len nuzxa naꞌ bsalj yöj lahuëꞌ, cutu nö́zituꞌ. Gul‑náb‑nëꞌ lëꞌ, le chnaquëꞌ bönniꞌ chnac. Lëczëꞌ quíxjöꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cni gulanë́ꞌ xuz xnëꞌë bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ, le tádxinëꞌ yuguꞌ bönniꞌ judío uná bëꞌ, le chglun xtídzaꞌquëꞌ bönniꞌ judío naꞌ chquiꞌ nu bönniꞌ siꞌ lu nëꞌë naquëꞌ Cristo Jesús, tsaz lubijëꞌ bönniꞌ naꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Qui lë ni naꞌ gulanë́ꞌ xuz xnëꞌë: “Gul‑náb‑nëꞌ lëꞌ, le chnaquëꞌ bönniꞌ chnac.” ");
INSERT INTO zsrNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Niꞌr gululidzëꞌ leyúbl bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ bönniꞌ judío uná bëꞌ, atiꞌ tëꞌ lëꞌ: ―Niꞌa queëꞌ Xanruꞌ Dios gdixjöꞌ le nacz. Netuꞌ ráquibéꞌituꞌ naquëꞌ bönniꞌ dul‑laꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Niꞌr bubiꞌë didzaꞌ, rnëꞌ: ―Chquiꞌ naquëꞌ bönniꞌ dul‑laꞌ cutu nözdaꞌ. Tu le nözdaꞌ. Ziꞌal nachúl lahuaꞌ, atiꞌ naꞌa rléꞌidaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Gulanabnëꞌ lëꞌ leyúbl, taꞌnë́ꞌ: ―¿Bizxa benëꞌ quiuꞌ? ¿Nacx benëꞌ bsaljëꞌ yöj lauꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bubiꞌë didzaꞌ, rëꞌ lequëꞌ: ―Chgudxczaꞌ lbiꞌiliꞌ, san cutu gúꞌniliꞌ siꞌ lu naꞌliꞌ xtidzaꞌa. ¿Bizx quië naꞌ rë́ꞌniliꞌ yö́niliꞌ leyúbl? ¿Naruꞌ rë́ꞌniliꞌ taꞌliꞌ caꞌ Lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Niꞌr gululídz ziꞌë lëꞌ, taꞌnë́ꞌ: ―Liꞌ daꞌu Lëꞌ, san netuꞌ daꞌtuꞌ Moisés. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Netuꞌ nö́zituꞌ bë́ꞌlenëꞌ Moisés didzaꞌ Dios, san ca nac queëꞌ bönniꞌ ni, cutu nö́zituꞌ nuzxa caz bsölaꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Niꞌr bubiꞌë didzaꞌ bönniꞌ naꞌ, rëꞌ lequëꞌ: ―Lë ni run ga rubandaꞌ. Lbiꞌiliꞌ cutu nö́ziliꞌ nuzxa bsölaꞌ bönniꞌ ni, atiꞌ Lëꞌ bsaljëꞌ yöj lahuaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nö́ziruꞌ cutu ryönnëꞌ yuguꞌ bönniꞌ dul‑laꞌ Dios, san chquiꞌ rej ladxëꞌë Dios bönniꞌ len runëꞌ ca rëꞌnnëꞌ Lëꞌ, bönniꞌ ni, Dios ryönnëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dza niꞌtë cutu ryön nu gna chquiꞌ nu bönniꞌ bsaljëꞌ yöj lahuëꞌ bönniꞌ guljëꞌ nachultë lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Laꞌnaruꞌ cunaquëꞌ queëꞌ Dios bönniꞌ ni, cutu bi gac gunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Niꞌr gulubiꞌë didzaꞌ, tëꞌ lëꞌ: ―Ca guljuꞌ nac bëꞌ nabaguꞌu dul‑laꞌ. ¿Atiꞌ liꞌ rusë́ditsanuꞌ netuꞌ? Niꞌr gulubijëꞌ lëꞌ niꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Byönnëꞌ Jesús ca glunëꞌ bönniꞌ judío uná bëꞌ, gulubijëꞌ bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ. Catiꞌ budzaguëꞌ lëꞌ, gudxëꞌ lëꞌ: ―¿I réjlëꞌu Zxiꞌnëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bubiꞌë didzaꞌ lëꞌ, rëꞌ Jesús: ―¿Nuzxa naꞌ, Xan, quië tséjlëꞌa Lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús rëꞌ lëꞌ: ―Chbléꞌinuꞌ Lëꞌ, atiꞌ nedaꞌ ni ruíꞌlenaꞌ liꞌ didzaꞌ, nacaꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Niꞌr bönniꞌ naꞌ, gyalj yöj lahuëꞌ, gyij ladxëꞌë Jesús, len rëꞌ Lëꞌ: ―Xan, réjlëꞌa Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús rnëꞌ: ―Quië cuequi xbeydaꞌ bunách bidaꞌ yödzlyú ni, quië luleꞌi nup nachúl nanitgac, len lac ca nu nachúl lahui nup taqui taꞌleꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Catiꞌ gulayönnëꞌ didzaꞌ ni bönniꞌ gdauꞌ fariseo naꞌ nacuáꞌlenëꞌ Jesús, niꞌr tëꞌ Lëꞌ: ―¿Naruꞌ nachúl naníttsatuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Laꞌnaruꞌ nachúlz yöj lauliꞌ, cutu gbágaꞌliꞌ dul‑laꞌ. Naꞌa rnaliꞌ: “Rléꞌituꞌ.” Qui lë ni naꞌ nabágaꞌliꞌ dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Gnëꞌ caꞌ Jesús: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Nu bönniꞌ curyaziëꞌ zacaꞌ ga nu ryaz liꞌaj quecbaꞌ böꞌcuꞌ zxilaꞌ, san tsaziëꞌ zacaꞌ ga yubl, bönniꞌ ni naquëꞌ gban len rbanczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nu bönniꞌ ryaziëꞌ zacaꞌ ga nu ryaz naquëꞌ bönniꞌ run chíꞌigacczëꞌ‑baꞌ böꞌcuꞌ zxilaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Quië tsaziëꞌ bönniꞌ ni, rsalj nu zoa run chiꞌi ga nu ryaz, atiꞌ taꞌyö́nibaꞌ chiꞌë böꞌcuꞌ zxilaꞌ naꞌ len tuꞌúnbëꞌbaꞌ‑nëꞌ. Lëꞌ rulidzëꞌ‑baꞌ qui queëbaꞌ ca lëcbaꞌ len rubijëꞌ‑baꞌ yuguꞌ böꞌcuꞌ zxilaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Catiꞌ chnubijëꞌ‑baꞌ yúguꞌtëbaꞌ böꞌcuꞌ zxilaꞌ náquicbaꞌ queëꞌ, rajnörëꞌ laucbaꞌ, atiꞌ böꞌcuꞌ zxilaꞌ naꞌ rajnaucbaꞌ lëꞌ, le tuꞌúnbëꞌbaꞌ chiꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bönniꞌ yubl cutu tsajnaucbaꞌ lëꞌ, san luzxúndjibaꞌ lëꞌ, le cutu núnbëꞌcbaꞌ chiꞌiquëꞌ bönniꞌ yubl. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Le run lsaquiꞌ ni gudxëꞌ lequëꞌ Jesús, san cutu gulayéjniꞌnëꞌ lë naꞌ rëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Niꞌr rëꞌ lequëꞌ leyúbl Jesús, rnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Nedaꞌ nacaꞌ ca tu ga taꞌyazbaꞌ böꞌcuꞌ zxilaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Chgulalë́ꞌë zian bönniꞌ gulanë́ꞌ nacquëꞌ Cristo, san yúguꞌtë bönniꞌ naꞌ guladxinëꞌ ziꞌal ca nedaꞌ, nacquëꞌ gban len taꞌbanczëꞌ, atiꞌ cutu guluzë́ nagcbaꞌ lequëꞌ böꞌcuꞌ zxilaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nedaꞌ nacaꞌ ca tu ga nu ryaz. Nútiꞌtëz bönniꞌ tsázlenëꞌ nedaꞌ, ulë́ꞌ bönniꞌ naꞌ, len gaquëꞌ ca tubaꞌ böꞌcuꞌ zxilaꞌ ryazbaꞌ len rurujbaꞌ, len rdzö́libaꞌ le rágubaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Zaꞌzëꞌ gban quië cuanëꞌ‑baꞌ len gdöddëꞌ‑baꞌ len usnitiëꞌ‑baꞌ. Nedaꞌ bidaꞌ quië gataꞌ yöl‑laꞌ naꞌbán gdu quegac bunách nacgac ca böꞌcuꞌ zxilaꞌ quiaꞌ, len gataꞌ gdu quequëꞌ yöl‑laꞌ naꞌbán gdu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nedaꞌ run chíꞌigacaꞌ bunách quiaꞌ ca runëꞌ bönniꞌ, lu yöl‑laꞌ dxiꞌi ladxiꞌ queëꞌ run chiꞌë‑baꞌ böꞌcuꞌ zxilaꞌ. Bönniꞌ cni run chiꞌë‑baꞌ böꞌcuꞌ zxilaꞌ zoaczëꞌ udödëꞌ yöl‑laꞌ naꞌbán queëꞌ niꞌa quecbaꞌ böꞌcuꞌ zxilaꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bönniꞌ nazxjëꞌ run chiꞌë‑baꞌ böꞌcuꞌ zxilaꞌ, catiꞌ rléꞌinëꞌ zaꞌbaꞌ böꞌcuꞌ zugaꞌ sniaꞌ, rucaꞌnëꞌ‑baꞌ böꞌcuꞌ zxilaꞌ naꞌ, len ruzxundjëꞌ, atiꞌ ráguyaꞌabaꞌ yuguꞌ böꞌcuꞌ zxilaꞌ naꞌ böꞌcuꞌ zugaꞌ sniaꞌ naꞌ len ruslasbaꞌ lecbaꞌ. Cni runëꞌ bönniꞌ naꞌ run chiꞌë‑baꞌ böꞌcuꞌ zxilaꞌ le cunaquëꞌ gdu nu run chiꞌi‑baꞌ böꞌcuꞌ zxilaꞌ, atiꞌ cutu náquicbaꞌ queëczëꞌ böꞌcuꞌ zxilaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ruzxundjëꞌ bönniꞌ nazxjëꞌ naꞌ le run chiꞌë‑baꞌ böꞌcuꞌ zxilaꞌ naꞌ quië siꞌzëꞌ dumí len cutu ruiꞌ ladxëꞌë‑baꞌ böꞌcuꞌ zxilaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Nedaꞌ nacaꞌ bönniꞌ, lu yöl‑laꞌ dxiꞌi ladxiꞌ quiaꞌ run chíꞌigacaꞌ‑baꞌ böꞌcuꞌ zxilaꞌ. Ca naꞌ nunbëꞌë nedaꞌ Xuzaꞌ, atiꞌ nedaꞌ núnbëꞌa‑nëꞌ Xuzaꞌ, lëzcaꞌ cni núnbëꞌgacaꞌ bunách quiaꞌ nacgac ca böꞌcuꞌ zxilaꞌ quiaꞌ, len rudödaꞌ yöl‑laꞌ naꞌbán quiaꞌ niꞌa quecbaꞌ böꞌcuꞌ zxilaꞌ naꞌ, atiꞌ böꞌcuꞌ zxilaꞌ naꞌ náquicbaꞌ quiaꞌ núnbëꞌcbaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Lëzcaꞌ nacuaꞌbaꞌ quiaꞌ yeláꞌgacrbaꞌ böꞌcuꞌ zxilaꞌ cunababcbaꞌ ni. Lëzcaꞌ lecbaꞌ ral‑laꞌ tsajxíꞌgacaꞌ‑baꞌ. Lecbaꞌ luzë́ nagcbaꞌ chiꞌa, len lacbaꞌ tuz len yezícaꞌrbaꞌ böꞌcuꞌ zxilaꞌ quiaꞌ, atiꞌ nédaꞌczaꞌ gun chíꞌigacaꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Qui lë ni naꞌ nadxiꞌinëꞌ nedaꞌ Xuzaꞌ, le rudödaꞌ yöl‑laꞌ naꞌbán quiaꞌ, guꞌa latj nu gdödi nedaꞌ, atiꞌ uziꞌa lei leyúbl, ubanaꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nutu nu bönniꞌ sáquiꞌnëꞌ gdöddëꞌ nedaꞌ san nédaꞌczaꞌ rudödaꞌ yöl‑laꞌ naꞌbán quiaꞌ, gatiaꞌ. Dë lu naꞌa udödaꞌ lei, len dë lu naꞌa uziꞌa lei leyúbl. Cni nac le gna béꞌinëꞌ nedaꞌ Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Catiꞌ gulayönnëꞌ didzaꞌ ni bönniꞌ judío, leyúbl gularujëꞌ chopl ca táquinëꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zianëꞌ taꞌnë́ꞌ: ―Yuꞌu Lëꞌ böꞌ xöhuiꞌ, len nachixi icjëꞌ. ¿Bizx quië ruzë́ nagliꞌ Lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yelaꞌquëꞌ taꞌnë́ꞌ: ―Cutu caꞌ ruꞌë cni didzaꞌ bönniꞌ yuꞌu lëꞌ böꞌ xöhuiꞌ. ¿Naruꞌ huactsa böꞌ xöhuiꞌ usálj yöj lauquëꞌ bönniꞌ nachúl lauquëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Rac beoꞌ ziag len nac dza naꞌ tunëꞌ lni yödz Jerusalén, tuꞌspanëꞌ ca gulaguꞌë lu nëꞌë Dios gdauꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Rdëꞌ Jesús raꞌ gdauꞌ ga nac nchil qui, nazíꞌ lei Nchil Queëꞌ Salomón. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Gulaguꞌë Jesús liꞌaj bönniꞌ judío uná bëꞌ len tëꞌ Lëꞌ: ―¿Batxcz usanuꞌ runuꞌ ga röꞌtuꞌ baguíꞌi? Chquiꞌ nacuꞌ liꞌ Cristo, ca nacz gdixjöiꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús rëꞌ lequëꞌ: ―Chgudxczaꞌ lbiꞌiliꞌ, san cutu réjlëꞌliꞌ nedaꞌ. Nacgac bëꞌ nu nacaꞌ yuguꞌ dxin runaꞌ le dë lu naꞌa uláz queëꞌ Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lbiꞌiliꞌ cutu réjlëꞌliꞌ nedaꞌ, le cutu nabáblenliꞌ nup nacgac böꞌcuꞌ zxilaꞌ quiaꞌ, ca naꞌ chgudxczaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Taꞌyö́nibaꞌ chiꞌa böꞌcuꞌ zxilaꞌ quiaꞌ, len tuꞌúnbëꞌbaꞌ nedaꞌ, atiꞌ nedaꞌ núnbëꞌgacaꞌ‑baꞌ, atiꞌ rdjáclenbaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nedaꞌ runödzjaꞌ quecbaꞌ yöl‑laꞌ naꞌbán gdu, atiꞌ cutu caꞌ laꞌnitbaꞌ, atiꞌ nutu nu saquiꞌ ubíj lecbaꞌ lu naꞌa nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bennëꞌ quiaꞌ lecbaꞌ Xuzaꞌ Dios, atiꞌ Lëꞌ náptërëꞌ yöl‑laꞌ huac ca yúguꞌtë bunách, atiꞌ nutu nu saquiꞌ ubíj lecbaꞌ lu nëꞌë Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nedaꞌ len Dios Xuz, tuz nactuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Leyúbl guluguel‑lëꞌë guiöj luladxëꞌ Jesús bönniꞌ judío uná bëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús rëꞌ lequëꞌ: ―Zian le nac dxiꞌa benaꞌ lauliꞌ le dë lu naꞌa uláz queëꞌ Xuzaꞌ. ¿Niꞌa qui bizxal dxin dxiꞌa ni uládxiꞌliꞌ nedaꞌ guiöj? ");
INSERT INTO zsrNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Gulubiꞌë didzaꞌ bönniꞌ judío uná bëꞌ naꞌ, tëꞌ Lëꞌ: ―Niꞌa qui dxin dxiꞌa cutu uládxiꞌtuꞌ liꞌ guiöj, san le curnéuꞌ dxiꞌa queëꞌ Dios, le nacuꞌ liꞌ bunáchz, len run cuinuꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ cu nayúj lu guich lu zxba queëliꞌ ca gnëꞌ Dios, rna: “Nedaꞌ rniaꞌ: Nacliꞌ yuguꞌ dios”? ");
INSERT INTO zsrNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nö́ziczruꞌ tsaz nayújcz le nayúj lu guich laꞌy. Lu guich laꞌy naꞌ ruiꞌ laquëꞌ dios, bönniꞌ niꞌ bë́ꞌlenëꞌ lequëꞌ didzaꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios bubijëꞌ nedaꞌ quizi queëꞌ len bsölëꞌë nedaꞌ yödzlyú ni. ¿Naruꞌ rnátsaliꞌ quiaꞌ: “Liꞌ cutu rneuꞌ dxiꞌa queëꞌ Dios”, le gniaꞌ: Zxiꞌnëꞌ Dios nacaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Chquiꞌ cutu runaꞌ dxin budödëꞌ lu naꞌa Xuzaꞌ Dios, cutu ral‑laꞌ tséjlëꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Chquiꞌ runaꞌ dxin budödëꞌ lu naꞌa Dios, zal‑laꞌ cutu réjlëꞌliꞌ nédaꞌczaꞌ, gul‑tsejlëꞌ le nacgac bëꞌ dxin naꞌ runaꞌ, quië gáquibeꞌiliꞌ naquëꞌ tuz len nedaꞌ Dios Xuz, atiꞌ nedaꞌ caꞌ nacaꞌ tuz len Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Leyúbl gulazú gulaböꞌë laꞌzönëꞌ Jesús, san Lëꞌ bulë́ꞌ lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Niꞌr gyijëꞌ Jesús leyúbl yetsláꞌa yegu Jordán, ga niꞌ zíꞌatël buquilëꞌ bunách nis Juan, atiꞌ bugaꞌnëꞌ niꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Guladxín ga zoëꞌ Jesús bunách zian, taꞌná: ―Le nactë cutu benëꞌ Juan nitú yöl‑laꞌ huac zxön, san yúguꞌtë le gnëꞌ Juan naꞌ ca ral‑laꞌ gac queëꞌ bönniꞌ ni, gdutë li nac. ");
INSERT INTO zsrNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Qui lë ni naꞌ gulayejlëꞌë Jesús bönniꞌ zian ga naꞌ zoëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dza niꞌ réꞌinëꞌ Lázaro, bönniꞌ Betania, le nac ladzcnu María len Marta. Nacnu Marta zxilnu María. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nacnu María naꞌ ngul zanëꞌ Lázaro, bönniꞌ naꞌ réꞌinëꞌ, len nacnu caꞌ ngul naꞌ gluꞌnu le rlaꞌ zxix niꞌë Xanruꞌ, len buzxinu niꞌë len guitsaꞌ icjnu. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gulasö́laꞌnu ngul zanëꞌ Lázaro naꞌ nu yjödx Jesús, gna: ―Xan, byutscaꞌ, réꞌinëꞌ Lázaro, bönniꞌ naꞌ nadxiꞌinuꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Catiꞌ byönnëꞌ didzaꞌ ni Jesús, gudxëꞌ nup nacuáꞌ niꞌ, rnëꞌ: ―Guidzhuë́ꞌ ni cutu nac le gdödi lëꞌ tsaz, san nac quië glaꞌ lahui yöl‑laꞌ yeníꞌ queëꞌ Dios, atiꞌ niꞌa qui guidzhuë́ꞌ ni glaꞌ lahui caꞌ yöl‑laꞌ yeníꞌ quiaꞌ nedaꞌ, Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús nadxiꞌinëꞌ‑nu Marta, len ngul zxilnu Marta naꞌ, len Lázaro naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Zal‑laꞌ nadxiꞌinëꞌ lequëꞌ Jesús, catiꞌ byönnëꞌ réꞌinëꞌ Lázaro, yechóp dza caꞌ bugaꞌnëꞌ ga naꞌ zoëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Catiꞌ bzaꞌa chop dza naꞌ, gudxëꞌ yuguꞌ bönniꞌ usë́d queëꞌ Jesús, rnëꞌ: ―Huayejruꞌ leyúbl luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Niꞌr tëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―Bönniꞌ Usëdi, ziꞌa gulazú gulaböꞌë luladxëꞌ Liꞌ guiöj bönniꞌ judío uná bëꞌ niꞌ. ¿Naruꞌ huayejtsuꞌ niꞌ leyúbl? ");
INSERT INTO zsrNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Zoacz chinnu hora lahuiꞌ dza. Nu bönniꞌ rdëꞌ lahuiꞌ dza, cutu tsajchéguꞌë, le rléꞌinëꞌ, le zoalen lëꞌ yeníꞌ zoa yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Chquiꞌ rdëꞌ chdzöꞌl bönniꞌ, rajchéguꞌë, le cutu zoalen lëꞌ yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Catiꞌ budx bëꞌë didzaꞌ ni Jesús, niꞌr gudxëꞌ lequëꞌ: ―Rasiëꞌ Lázaro, böchiꞌ lzaꞌruꞌ, atiꞌ tsijaꞌ nedaꞌ, tsajspanaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Niꞌr tëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―Xan, chquiꞌ rasiëꞌ, huöaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Gnëꞌ cni Jesús le chgutiëꞌ Lázaro, san lequëꞌ táquinëꞌ gnëꞌ: “Raszëꞌ Lázaro.” ");
INSERT INTO zsrNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Niꞌr gudxëꞌ lequëꞌ yalj lulu Jesús, gnëꞌ: ―Chgutiëꞌ Lázaro. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Rudzijdaꞌ le cutu zoaꞌ niꞌ, le gac naꞌa tu le uziꞌliꞌ xbey, le gun ga tséjlëꞌliꞌ nedaꞌ. Huayejruꞌ naꞌa ga naꞌ dëꞌ Lázaro. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Niꞌr gudxëꞌ yezícaꞌrëꞌ bönniꞌ usë́d queëꞌ Jesús Tomás, bönniꞌ naꞌ tuꞌë lëꞌ, Bönniꞌ Cuach, rnëꞌ: ―Huayejruꞌ caꞌ rëꞌu, gátlenruꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","Dë gal‑laꞌz ga dë Jerusalén yödz Betania naꞌ, nac ca rzaꞌruꞌ tu hóratëz. Qui lë ni naꞌ chguladxinëꞌ zian bönniꞌ judío ga naꞌ nacuaꞌnu Marta len María, tuꞌhuíꞌ zxönëꞌ lecnu le gutiëꞌ bönniꞌ zancnu. Catiꞌ bdxinëꞌ niꞌ Jesús, byönnëꞌ chguc tap dza yuꞌë yeru ba Lázaro naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Catiꞌ byö́ninu didzaꞌ Marta, zëꞌë Jesús, niꞌr brujnu yuꞌu, yajtsagnu Lëꞌ, san María bugaꞌnnu yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta naꞌ rënu Jesús: ―Xan, laꞌnaruꞌ zuꞌ ni, cutu gatiëꞌ bönniꞌ zanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lëzcaꞌ naꞌa, nözdaꞌ yúguꞌtë le gnabuꞌ lahuëꞌ Dios, Dios gunnëꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús rëꞌ‑nu: ―Ubanëꞌ bönniꞌ zanuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta rënu Lëꞌ: ―Nözdaꞌ ubanëꞌ catiꞌ gdxin dza udx catiꞌ lubán nup chnatgac. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Niꞌr Jesús rëꞌ‑nu: ―Nacczaꞌ nedaꞌ Nu ruspán nup chnatgac lencaꞌ Nu nabánigac bunách. Nu tsejlëꞌ nedaꞌ, zal‑laꞌ gat nu naꞌ, ubáncz, ");
INSERT INTO zsrNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","atiꞌ yúguꞌtë bönniꞌ nabanquëꞌ len taꞌyejlëꞌë nedaꞌ, cutu caꞌ latiëꞌ tsaz. ¿I réjlëꞌu lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta rënu Lëꞌ: ―Ja, Xan. Réjlëꞌa nacuꞌ Liꞌ Cristo, Zxiꞌnëꞌ Dios, Bönniꞌ naꞌ gzxiꞌ lu nëꞌë Dios gsölëꞌë yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Catiꞌ budx bëꞌnu didzaꞌ ni Marta naꞌ, böajnu yuꞌu, yajlidznu María, zxilnu, len bagachiꞌz rënu lënu: ―Bönniꞌ Usëdi zoëꞌ ni, rulidzëꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Catiꞌ byö́ninu didzaꞌ ni María, laꞌ gyástënu, zeajnu ga naꞌ zoëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Cutu ryaznëꞌ Jesús laꞌ yödzdauꞌ naꞌ, san zoazëꞌ ga naꞌ yajtsagnu Lëꞌ Marta. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Catiꞌ gulaléꞌinëꞌ‑nu María naꞌ gyasnu len jaréluꞌnu brujnu bönniꞌ judío naꞌ nacuáꞌlenëꞌ‑nu ga nac lu yuꞌu len tuꞌhuíꞌ zxönëꞌ‑nu, niꞌr glauquëꞌ‑nu, taꞌnë́ꞌ: ―Huayeajnu raꞌ yeru ba tsajchödxnu niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Niꞌr bdxinnu María ga naꞌ zoëꞌ Jesús. Catiꞌ bléꞌinu Lëꞌ, byéchunu xniꞌë, rënu Lëꞌ: ―Xan, laꞌnaruꞌ zuꞌ ni, cutu gatiëꞌ bönniꞌ zanaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Catiꞌ bléꞌinëꞌ Jesús rbödxnu, len taꞌbödxëꞌ caꞌ bönniꞌ judío naꞌ dzagquëꞌ‑nu, niꞌr buiꞌnnëꞌ len gnëtsca ladxëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Rnëꞌ: ―¿Gazx bucáchiꞌliꞌ‑nëꞌ? Tëꞌ Lëꞌ: ―Gda uyúꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Grödxëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Niꞌr gulanë́ꞌ bönniꞌ judío naꞌ, taꞌnë́ꞌ: ―Gul‑yutscaꞌ tscátiꞌga nadxiꞌinëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Laꞌquëꞌ taꞌnë́ꞌ: ―Benëꞌ ga rléꞌinëꞌ bönniꞌ naꞌ ziꞌal nachúl lahuëꞌ bönniꞌ ni. ¿Naruꞌ cu guctsa gunëꞌ ga cu gatiëꞌ Lázaro? ");
INSERT INTO zsrNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Leyúbl gnëtsca ladxëꞌë Jesús, atiꞌ bdxinëꞌ raꞌ yeru ba naꞌ. Ba naꞌ nac tu yeru nadj lëꞌi guiꞌa guiöj, atiꞌ daꞌ tu guiöj blag nuséyj ga nu ryaz lei. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Gudxëꞌ nup nacuáꞌ niꞌ Jesús, rnëꞌ: ―Gul‑cúa guiöj ni. Niꞌr Marta, ngul zanëꞌ bönniꞌ nat naꞌ, rënu Lëꞌ: ―Xan, chrlëꞌë zgut le chguc tap dza natiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús rëꞌ‑nu: ―¿Naruꞌ clëg chgudxczaꞌ liꞌ chquiꞌ réjlëꞌu, hualéꞌinuꞌ yöl‑laꞌ yeníꞌ queëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Niꞌr gulagǘëꞌ guiöj blag naꞌ nuséyj ga nu ryaz yeru ba ga naꞌ yuꞌë bönniꞌ nat naꞌ. Buyúëꞌ Jesús zacaꞌ luzxbál, rnëꞌ: ―Xuzaꞌ, xclenuꞌ, rëpaꞌ Liꞌ, le ryönnuꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nedaꞌ nözdaꞌ ryö́ntecznuꞌ nedaꞌ, san ruꞌa didzaꞌ ni quië luzíꞌ xbey bunách zian ni len laꞌyejlëꞌ Liꞌ naꞌ nasöluꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Catiꞌ budx bëꞌë didzaꞌ ni Jesús, zidzj bulidzëꞌ, rnëꞌ: ―Lázaro, burúj nil. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Burujëꞌ bönniꞌ nat naꞌ lu yeru ba, narö́ligacr niꞌa nëꞌë yuguꞌ láriꞌdauꞌ, len nagachiꞌ caꞌ lahuëꞌ yetú láriꞌdauꞌ. Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑lí lariꞌ naꞌ naröli niꞌa nëꞌë len gul‑guꞌë latj sëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Niꞌr gulayejlëꞌë Jesús zian bönniꞌ judío naꞌ yjáclenëꞌ tsazxö́n María len gulaléꞌinëꞌ lë naꞌ benëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Laꞌquëꞌ yjaquëꞌ ga nacuꞌë bönniꞌ gdauꞌ fariseo len gulaguíxjöiꞌnëꞌ lequëꞌ ca naꞌ benëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Niꞌr guludúblenëꞌ tsazxö́n bönniꞌ gdauꞌ taꞌbequi xbey yuguꞌ bönniꞌ gdauꞌ fariseo naꞌ, len yuguꞌ bxuz uná bëꞌ, taꞌnë́ꞌ: ―¿Nacxcz gunruꞌ? Runëꞌ bönniꞌ ni zian yöl‑laꞌ huac zxön. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chquiꞌ güiꞌzruꞌ‑nëꞌ latj gunëꞌ ca ni runczëꞌ, laꞌyejlëꞌ Lëꞌ yúguꞌtë bunách, atiꞌ udjaquëꞌ ni bönniꞌ Roma, duquindjquëꞌ gdauꞌ laꞌy queëruꞌ, len yödz queëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Niꞌr bëꞌë didzaꞌ Caifás, bxuz blau iz naꞌ, len dzaguëꞌ lequëꞌ, rëꞌ lequëꞌ: ―Lbiꞌiliꞌ cutu bi nö́ziliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","len cutu ráquibeꞌiliꞌ run bayúdx gatiëꞌ tuëꞌ bönniꞌ niꞌa quegac bunách, cui nit gdu yödz. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Clëg racz queëꞌ bëꞌë didzaꞌ ni, san le naquëꞌ bxuz blau iz naꞌ, qui lë ni naꞌ bëꞌë didzaꞌ uláz queëꞌ Dios ca ral‑laꞌ gatiëꞌ Jesús niꞌa quegac bunách yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Gatiëꞌ Jesús, clëgz niꞌa qui yödz naꞌ, san gatiëꞌ caꞌ quië utubëꞌ zxiꞌnëꞌ Dios náslasquëꞌ, quië lacquëꞌ tuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Cni guc, laꞌ dza naꞌz glun xtídzaꞌquëꞌ ludöddëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Qui lë ni naꞌ cutur gdëꞌ Jesús yalj lulu gap nacuáꞌ bunách judío, san buzë́ꞌë niꞌ, zijëꞌ tu latj gal‑laꞌ ga nac latj caꞌz, atiꞌ bdxinëꞌ yödz Efraín, ga niꞌ bugaꞌnëꞌ, atiꞌ dzagquëꞌ Lëꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dza naꞌ chzaꞌ gal‑laꞌ Lni PAscua quequëꞌ bönniꞌ judío catiꞌ tuꞌspanëꞌ ca benëꞌ Dios, bubijëꞌ luyú Egipto bunách queëꞌ. Gularúj bunách zian yuguꞌ yödz niꞌ, atiꞌ gulabenëꞌ, zjaquëꞌ Jerusalén catiꞌ ziꞌa gdxin lni naꞌ quië tsajpáꞌ cuinquëꞌ ca nac qui gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tuꞌguiljëꞌ Jesús bönniꞌ naꞌ nacuꞌë Jerusalén, len catiꞌ niꞌ nacuꞌë nchil gdauꞌ, gulanabi lzaꞌquëꞌ tuëꞌ yetúëꞌ, taꞌnë́ꞌ: ―¿Bizxa rsácaꞌliꞌ? ¿Huidtsëꞌ lni, o cutu guidëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Chgulaná bëꞌë yuguꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ gdauꞌ fariseo chquiꞌ nu nözi ga zoëꞌ Jesús, ral‑laꞌ dudixjöiꞌ lequëꞌ quië gac tsajxönquëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Catiꞌ niꞌ nagaꞌngac yexóp dza gdxin Lni Pascua catiꞌ tuꞌspanëꞌ ca benëꞌ Dios, bubijëꞌ luyú Egipto bunách queëꞌ, niꞌr bdxinëꞌ Jesús lu yödz Betania, ga naꞌ zoëꞌ Lázaro, bönniꞌ naꞌ gutiëꞌ len bubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Niꞌ gulaguꞌë tu güiꞌi huagu gahuëꞌ Jesús. Gluꞌnu le lahuëꞌ María, atiꞌ nutsëꞌë Lázaro ladj bönniꞌ rö́ꞌlenquëꞌ Jesús tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Niꞌr gdél‑laꞌnu María ca tu guia le rlaꞌ zxix qui yöj susén las gdu, le záquiꞌtsqui, len gluꞌnu lei niꞌë Jesús. Buzxinu niꞌë len guitsaꞌ icjnu. Gdutë lu yuꞌu naꞌ gze böꞌ zxix. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Niꞌr bëꞌë didzaꞌ bönniꞌ usë́d queëꞌ Jesús, lëꞌ Judas Iscariote, zxiꞌnëꞌ tu bönniꞌ lëꞌ Simón, len naquëꞌ bönniꞌ naꞌ udödëꞌ Jesús lu naꞌquëꞌ bönniꞌ gdauꞌ, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Bizx quië cugdaꞌu le rlaꞌ zxix naꞌ le zacaꞌ lazxjruꞌ qui tu iz, atiꞌ huac nu quis dumí naꞌ quegac bunách yechiꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gnëꞌ cni, clëg le ruiꞌ ladxëꞌë bunách yechiꞌ, san le naquëꞌ gban, len lëczëꞌ nuꞌë bzud dumí quequëꞌ, len rubíjlanëꞌ dumí naꞌ tuꞌchijëꞌ lu bzud naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Niꞌr Jesús rëꞌ lëꞌ: ―Bëꞌ‑nu latj, le nac lë ni bennu tu le nabáꞌa quië dza ggachaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Laꞌcuáꞌlentecz lbiꞌiliꞌ bunách yechiꞌ, san nedaꞌ cutu ugáꞌnteczaꞌ ga zoaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Catiꞌ gulayönnëꞌ zoëꞌ Jesús Betania, guladxinëꞌ niꞌ zian bönniꞌ judío, clëgz le zoëꞌ niꞌ Jesús, san lëzcaꞌ le tëꞌnnëꞌ laꞌléꞌinëꞌ Lázaro, bönniꞌ naꞌ buspanëꞌ lëꞌ Jesús lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Niꞌr glun xtídzaꞌquëꞌ bxuz uná bëꞌ, ludöddëꞌ caꞌ Lázaro, ");
INSERT INTO zsrNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","le taꞌyejlëꞌë Jesús len chnuláꞌalenquëꞌ bxuz uná bëꞌ naꞌ zian bönniꞌ judío niꞌa queëꞌ Lázaro naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Guladxín Jerusalén bunách zian dza Lni Pascua, atiꞌ dza buróp naꞌ taꞌyönnëꞌ zëꞌë Jesús niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Niꞌr gulaguitsjëꞌ zin len gularujëꞌ zajxíꞌgal‑laꞌquëꞌ Jesús, atiꞌ gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Yöl‑laꞌ ba Dios. Yöl‑laꞌ ba Bönniꞌ ni zëꞌë uláz queëꞌ Xanruꞌ, gna béꞌinëꞌ bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Bdzölnëꞌ‑baꞌ tubaꞌ búrrodauꞌ Jesús, atiꞌ gdxiëꞌ‑baꞌ ca naꞌ nayúj lu guich laꞌy, rna: ");
INSERT INTO zsrNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Cutu gádxiliꞌ, lbiꞌiliꞌ, zoaliꞌ yödz Sión. Gul‑yutscaꞌ, zëꞌë Bönniꞌ gna béꞌinëꞌ lbiꞌiliꞌ. Dxiëꞌ‑baꞌ tubaꞌ búrrodauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Catiꞌ niꞌ ziꞌa guc lë ni, cutu gulayéjniꞌnëꞌ bönniꞌ usë́d queëꞌ Jesús, san gdöd niꞌ, catiꞌ bubanëꞌ Jesús lu yöl‑laꞌ gut, buëpëꞌ yehuaꞌ yubá queëꞌ, niꞌr yajneycnëꞌ lë ni nayúj lu guich laꞌy ca ral‑laꞌ gac queëꞌ, atiꞌ guc cni queëꞌ lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lëzcaꞌ glunëꞌ lnaꞌ lau queëꞌ Jesús bönniꞌ naꞌ gulacuáꞌlenëꞌ Lëꞌ catiꞌ niꞌ bulidzëꞌ Lázaro, yuꞌë yeru ba, len buspanëꞌ lëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Qui lë ni naꞌ caꞌ gularujëꞌ bönniꞌ yajxíꞌgal‑laꞌquëꞌ Jesús, le gulayönnëꞌ ca nac yöl‑laꞌ huac ni benëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Niꞌr gulanë́ꞌ laꞌ légaczëꞌ bönniꞌ gdauꞌ fariseo, taꞌnë́ꞌ: ―Chnac bëꞌ cutu bi sáquiꞌruꞌ gunruꞌ. Gul‑yú ca daꞌgac Lëꞌ yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Dzagquëꞌ nup naꞌ guladxín Jerusalén dza Lni Pascua naꞌ laꞌquëꞌ bönniꞌ gzaꞌa quië laꞌyíj ládxiꞌquëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yajtsagquëꞌ Felipe, bönniꞌ Betsaida qui luyú Galilea, yuguꞌ bönniꞌ gzaꞌa naꞌ, atiꞌ glátaꞌyuëꞌ lahuëꞌ, taꞌnë́ꞌ: ―Bönniꞌ, rë́ꞌnituꞌ gléꞌituꞌ‑nëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Gyijëꞌ Felipe naꞌ, yjödxëꞌ caꞌ Andrés. Niꞌr Andrés len Felipe naꞌ glëꞌ caꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Chzoa gdxin dza gatiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, huöjaꞌ xlatjaꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Le nactë rëpaꞌ lbiꞌiliꞌ: Ugáꞌn leyz tu xseydauꞌ chquiꞌ cutu ggachiꞌ luyú len udx qui. Chquiꞌ udx qui xseydauꞌ naꞌ, atiꞌ glen, szxö́nitër unö́dzj. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu bönniꞌ ruiꞌ ládxiꞌtsquëꞌ yöl‑laꞌ naꞌbán queëꞌ, unitiëꞌ lei, le gatiëꞌ tsaz bönniꞌ naꞌ. Nu bönniꞌ cutu ruiꞌ ladxëꞌë yöl‑laꞌ naꞌbán dë queëꞌ yödzlyú ni gun chiꞌë lei ga gdxinr dza gataꞌ yöl‑laꞌ naꞌbán gdu queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chquiꞌ rëꞌnnëꞌ bönniꞌ gunëꞌ xchinaꞌ, ral‑laꞌ tëꞌë nedaꞌ bönniꞌ naꞌ, atiꞌ ga niꞌ tsajsóaꞌ nedaꞌ, niꞌ tsajsóëꞌ caꞌ bönniꞌ naꞌ runëꞌ xchinaꞌ. Chquiꞌ runëꞌ xchinaꞌ bönniꞌ, gunëꞌ ba laꞌn bönniꞌ naꞌ Xuzaꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Gnëꞌ caꞌ Jesús: ―Naꞌa röꞌtscaꞌ baguíꞌi nedaꞌ. ¿Nacx gnatsaꞌ? ¿Naruꞌ gniaꞌ: Xuzaꞌ, buslá nedaꞌ lu le ral‑laꞌ gac quiaꞌ naꞌa? Qui lë ni naꞌ bidaꞌ, quië guaꞌ glenaꞌ le ral‑laꞌ gac quiaꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xuzaꞌ, ben ga glaꞌ lahui yöl‑laꞌ yeníꞌ quiuꞌ. Niꞌr byön chiꞌi Nu ruiꞌ didzaꞌ yehuaꞌ yubá, rna: ―Chbenaꞌ ga naláꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ, atiꞌ leyúbl gunaꞌ ga glaꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gulayöni chiꞌi ni bunách zian nacuáꞌ niꞌ, atiꞌ taꞌná: ―Gziuꞌ naꞌ gnë. Yelaꞌgac bunách naꞌ taꞌná: ―Bë́ꞌlenëꞌ Lëꞌ didzaꞌ gbaz laꞌy queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―Byön chiꞌi ni, clëg quië uziꞌa xbey nedaꞌ, san quië uziꞌliꞌ xbey lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chbdxin dza cuequi xbeynëꞌ bunách yödzlyú ni Dios. Naꞌa chuꞌnëꞌ Dios niꞌl tuꞌ xöhuiꞌ rna beꞌi bunách yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Naꞌa, chquiꞌ luchisëꞌ nedaꞌ xtsaꞌ bönniꞌ ludöddëꞌ nedaꞌ, gunaꞌ ga ludúb quiaꞌ yúguꞌtë bunách. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Didzaꞌ ni bëꞌë Jesús nac bëꞌ nac gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Të Jesús bunách zian naꞌ, taꞌná: ―Netuꞌ byö́nituꞌ nup gululáb le rna bëꞌ zxba queëꞌ Dios, lë naꞌ rna: “Sóateczëꞌ Cristo.” ¿Nacxcz nac, rnauꞌ Liꞌ: “Run bayúdx Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, luchisëꞌ Lëꞌ xtsaꞌ”? ¿Nuzxa naꞌ Bönniꞌ Nuhuöaquëꞌ Gdu Bunách? ");
INSERT INTO zsrNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Niꞌr Jesús rëꞌ lequëꞌ: ―Yetú chiꞌidauꞌz sóalenaꞌ lbiꞌiliꞌ nedaꞌ, nacaꞌ yeníꞌ queëliꞌ. Gul‑tá tsal ni zóalenaꞌ lbiꞌiliꞌ len dë queëliꞌ yeníꞌ, cui gchul nitliꞌ. Nu bönniꞌ rdëꞌ ga chul xöhuiꞌ cutu nöznëꞌ gazx zijëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tsal ni zóalenaꞌ lbiꞌiliꞌ nedaꞌ, nacaꞌ yeníꞌ queëliꞌ. Gul‑tsejlëꞌ nedaꞌ nacaꞌ yeníꞌ queëliꞌ quië gléꞌiliꞌ yeníꞌ naꞌ nac gdu. Catiꞌ budx bëꞌë didzaꞌ ni Jesús, yhuöjëꞌ yajcachiꞌ lahuëꞌ lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zal‑laꞌ benëꞌ Jesús zian yöl‑laꞌ huac lauquëꞌ, cutu gulayejlëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cni guc quië butság lë naꞌ buzujëꞌ lu guich Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: Xan, ¿nuzxa caz gyejlëꞌ didzaꞌ bëꞌtuꞌ? ¿Nuzxa caz buluiꞌinëꞌ lei Xanruꞌ yöl‑laꞌ huac queëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Cni guc, cutu guc laꞌyejlëꞌë Jesús. Guc ca naꞌ gnëꞌ caꞌ Isaías: ");
INSERT INTO zsrNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios benëꞌ ga gulachúl gulanitiëꞌ, Atiꞌ guc zid ládxiꞌdauꞌquëꞌ Cui laꞌléꞌinëꞌ len yöj lauquëꞌ, Len cui laꞌyéjniꞌnëꞌ lu icj ládxiꞌdauꞌquëꞌ. Cutu luhuöaquëꞌ quiaꞌ quië úngacaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Bëꞌë didzaꞌ ni Isaías le bléꞌinëꞌ yöl‑laꞌ yeníꞌ queëꞌ Cristo, len bëꞌë didzaꞌ ca nac queëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Zal‑laꞌ rac cni, gulayejlëꞌ Jesús bunách zian, len ga bdxintë gulayejlëꞌë Lëꞌ laꞌquëꞌ bönniꞌ uná bëꞌ, san le tádxinëꞌ yuguꞌ bönniꞌ gdauꞌ fariseo, cutu glunëꞌ lnaꞌ lau queëꞌ yalj lulu, cui lubijëꞌ lequëꞌ tsaz ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Cni glunëꞌ le tunrëꞌ zxön le tun lequëꞌ ba laꞌn bunách ca le runëꞌ lequëꞌ ba laꞌn Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Bëꞌë zidzj didzaꞌ Jesús, rnëꞌ: ―Nu bönniꞌ rejlëꞌë nedaꞌ, clëg nedaꞌz rejlëꞌë, san rejlëꞌë caꞌ Xuzaꞌ nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Lëzcaꞌ cni, nu bönniꞌ rléꞌinëꞌ nedaꞌ, rléꞌinëꞌ caꞌ Xuzaꞌ nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nedaꞌ nacaꞌ yeníꞌ len bidaꞌ yödzlyú ni, cui lugaꞌnëꞌ ga chul xöhuiꞌ yúguꞌtë bönniꞌ laꞌyejlëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Chquiꞌ ryönnëꞌ xtidzaꞌa bönniꞌ len cutu runëꞌ lei ba laꞌn, clëg nedaꞌ gchugaꞌ queëꞌ bönniꞌ naꞌ, le bidaꞌ ni, clëg quië gchugaꞌ quegac bunách yödzlyú ni, san quië usláꞌ bunách yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu bönniꞌ ruzóëꞌ nedaꞌ tslaꞌl len cutu rziꞌ lu nëꞌë xtidzaꞌa, chzoa le gchugu queëꞌ bönniꞌ naꞌ. Didzaꞌ naꞌ chbë́ꞌlenaꞌ lbiꞌiliꞌ nac tu le gchugu queëꞌ bönniꞌ naꞌ dza udx. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Cni nac, ruꞌa didzaꞌ, clëg racz quiaꞌ, san gudxëꞌ nedaꞌ Xuzaꞌ nasölëꞌë nedaꞌ le ral‑laꞌ gniaꞌ, lencaꞌ ca ral‑laꞌ guꞌa didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nözdaꞌ gna bëꞌë cni Dios quië gataꞌ quegac bunách yöl‑laꞌ naꞌbán gdu. Cni nac, didzaꞌ naꞌ ruꞌa, ruꞌa didzaꞌ ca naꞌ chgudxczëꞌ nedaꞌ Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Niꞌ nac dza ziꞌa gdxin Lni Pascua catiꞌ tuꞌspanëꞌ ca benëꞌ Dios, bubijëꞌ luyú Egipto bunách queëꞌ. Nözcznëꞌ Jesús chbdxin dza queëꞌ gatiëꞌ, catiꞌ ral‑laꞌ uzë́ꞌë yödzlyú ni, huöjëꞌ ga zoëꞌ Xuzëꞌ. Ca naꞌ nadxiꞌinëꞌ bunách queëꞌ nacuáꞌ yödzlyú ni, naꞌa nadxiꞌinëꞌ lequëꞌ ga gdxintë gatiëꞌ uláz quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chnagúꞌu yöl‑laꞌ Judas Iscariote, zxiꞌnëꞌ tu bönniꞌ lëꞌ Simón, Satanás tuꞌ xöhuiꞌ, quië udödëꞌ Jesús lu naꞌgac nup ludödi Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nözcznëꞌ Jesús ca nac, brujëꞌ ga zoëꞌ Dios, len huöjëꞌ caꞌ ga naꞌ zoëꞌ Dios, atiꞌ chnudödëꞌ lu nëꞌë Lëꞌ Dios Xuzëꞌ gdutë yöl‑laꞌ uná bëꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Qui lë ni naꞌ, catiꞌ niꞌ tahuëꞌ, gyasëꞌ Jesús len gduëꞌ lariꞌ rxoa yenëꞌ. Gdel‑lëꞌë tu lariꞌ ruzxini naꞌruꞌ le bdëꞌë lëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Niꞌr gdëꞌë nis lu zxigaꞌ guia, atiꞌ gzu lahuëꞌ rguibëꞌ níꞌaquëꞌ bönniꞌ usë́d queëꞌ, len ruzxinëꞌ níꞌaquëꞌ len lariꞌ naꞌ daꞌ lëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Catiꞌ bdxinëꞌ ga röꞌë Simón Pedro, Pedro naꞌ rëꞌ Lëꞌ: ―Xan, ¿naruꞌ Liꞌ quibtsuꞌ niꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Lë ni runaꞌ, cutu réjniꞌnuꞌ naꞌa, san huadzéy tséjniꞌnuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Niꞌr Pedro rëꞌ Lëꞌ: ―Cutu quibczuꞌ Liꞌ niꞌa. Jesús rëꞌ lëꞌ: ―Chquiꞌ nedaꞌ cutu quibaꞌ liꞌ, cutu caꞌ sáquiꞌnuꞌ gunuꞌ nedaꞌ tsazxö́n. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Niꞌr Simón Pedro rëꞌ Lëꞌ: ―Xan, clëgz niꞌa quibuꞌ, san quibuꞌ caꞌ naꞌa len icjaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús rëꞌ lëꞌ: ―Nu nayár, níꞌazëꞌ run bayúdx tsar, le nacczëꞌ dxiꞌa gdutëꞌ, atiꞌ lbiꞌiliꞌ nacliꞌ dxiꞌa, san clëg yúguꞌtëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Gnëꞌ cni Jesús: “Clëg yúguꞌtëliꞌ nacliꞌ dxiꞌa”, le nözcznëꞌ nulquëꞌ naꞌ udödëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gdöd gdibëꞌ níꞌaquëꞌ Jesús, buguel‑lëꞌë lariꞌ naꞌ buxóa yenëꞌ. Buböꞌë ga tahuëꞌ, atiꞌ rëꞌ lequëꞌ: ―¿I réjniꞌliꞌ lë naꞌ ziꞌa benaꞌ queëliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lbiꞌiliꞌ ruiꞌliꞌ laꞌ “Bönniꞌ Usëdi”, lencaꞌ “Xan”. Dxiꞌa nac ca rnaliꞌ, le cni nacaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naꞌa, chquiꞌ nedaꞌ nacaꞌ Xanliꞌ len Bönniꞌ Usëdi queëliꞌ, atiꞌ gdibaꞌ níꞌaliꞌ, lëzcaꞌ cni ral‑laꞌ gunliꞌ lbiꞌiliꞌ, quibliꞌ niꞌa lzaꞌliꞌ tuliꞌ yetuliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tu le buluiꞌidaꞌ lbiꞌiliꞌ quië gunliꞌ lbiꞌiliꞌ ca naꞌ benaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Le nactë rëpaꞌ lbiꞌiliꞌ: Cutu náctërëꞌ blau ca xanëꞌ bönniꞌ huen dxin, atiꞌ bönniꞌ gbaz cutu náctërëꞌ blau ca nu nasölaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chquiꞌ réjniꞌliꞌ yúguꞌtë lë ni, bicaꞌ ba lbiꞌiliꞌ chquiꞌ gunliꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Didzaꞌ ni ruꞌa cutu rëpaꞌ yúguꞌtëliꞌ. Nözczdaꞌ nup gröczaꞌ nedaꞌ, san run bayúdx utság lë naꞌ nayúj lu guich laꞌy, rna: “Nu rágulen nedaꞌ tsazxö́n, nu ni táꞌbagaꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Naꞌa rguíxjöiꞌdaꞌ lbiꞌiliꞌ ziꞌal ca gac, quië catiꞌ gac cni, tséjlëꞌliꞌ zoaczaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Le nactë rëpaꞌ lbiꞌiliꞌ: Nu bönniꞌ gunëꞌ ba laꞌn gbaz gsölaꞌa nedaꞌ, nedaꞌ caꞌ gunëꞌ ba laꞌn, atiꞌ nu bönniꞌ gunëꞌ nedaꞌ ba laꞌn, gunëꞌ caꞌ ba laꞌn Xuzaꞌ, nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Catiꞌ budx bëꞌë didzaꞌ ni Jesús, buiꞌnnëꞌ atiꞌ yalj lulu gnëꞌ: ―Le nactë rëpaꞌ lbiꞌiliꞌ: Tu bönniꞌ nutsëꞌë ladjliꞌ udödëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Niꞌr guluyú lau lzaꞌquëꞌ tuëꞌ yetúëꞌ bönniꞌ usë́d queëꞌ len gulaböꞌtsquëꞌ baguíꞌi taꞌnáb ládxiꞌquëꞌ nuzxa qui naꞌ gnëꞌ cni Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tuëꞌ bönniꞌ usë́d queëꞌ Jesús, bönniꞌ naꞌ Jesús nadxiꞌinëꞌ lëꞌ, zoëꞌ cuit lëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro buláꞌ buluiꞌizëꞌ bönniꞌ ni quië gnabnëꞌ Jesús nuzxa qui naꞌ gnëꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Niꞌr bönniꞌ naꞌ zoëꞌ cuit lëꞌë Jesús rëꞌ Lëꞌ: ―Xan, ¿nuzxa naꞌ ruꞌu didzaꞌ qui? ");
INSERT INTO zsrNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Naquëꞌ bönniꞌ naꞌ guꞌa‑nëꞌ yöt xtil nabís. Niꞌr buspisëꞌ yöt xtil naꞌ, len bëꞌë queëꞌ Judas Iscariote, zxiꞌnëꞌ bönniꞌ lëꞌ Simón. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gdöd gdahuëꞌ yöt xtil naꞌ Judas, gyaz icj ládxiꞌdauꞌhuëꞌ Satanás tuꞌ xöhuiꞌ. Niꞌr Jesús rëꞌ lëꞌ: ―Lë naꞌ gunuꞌ, yjentë naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Cutu taꞌyéjniꞌnëꞌ bizx quië naꞌ gudxëꞌ lëꞌ cni Jesús yezícaꞌrëꞌ bönniꞌ usë́d queëꞌ röꞌquëꞌ tahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Le nuꞌë Judas bzud dumí quequëꞌ, táquinëꞌ laꞌquëꞌ gudxëꞌ lëꞌ Jesús: “Yajxíꞌ le gáguruꞌ lni”, o gnëꞌ: “Bëꞌ latiꞌ quegac bunách yechiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Catiꞌ budx gdahuëꞌ yöt xtil naꞌ, len niꞌ nac chdzöꞌl, laꞌ brujtëꞌ Judas. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Catiꞌ chbrujëꞌ Judas naꞌ, niꞌr gnëꞌ Jesús: ―Naꞌa chzoa glaꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ nedaꞌ, Bönniꞌ Nuhuöaquëꞌ Gdu Bunách, len glaꞌ lahui caꞌ yöl‑laꞌ yeníꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chquiꞌ glaꞌ lahui yöl‑laꞌ yeníꞌ queëꞌ Dios niꞌa quiaꞌ nedaꞌ, Zxiꞌnëꞌ, lëzcaꞌ Lëczëꞌ Dios gunëꞌ ga glaꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ nedaꞌ, Zxiꞌnëꞌ, len laꞌ guntëꞌ cni. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Zxíꞌnaꞌdauꞌ, yetú chiꞌz zóalenaꞌ lbiꞌiliꞌ. Uguiljliꞌ nedaꞌ, atiꞌ ca naꞌ chgúdxgacaꞌ‑nëꞌ bönniꞌ judío, lëzcaꞌ cni rëpaꞌ lbiꞌiliꞌ naꞌa: Ga naꞌ tsijaꞌ nedaꞌ, cutu gac guidliꞌ racz queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tu zxba cub rna béꞌidaꞌ lbiꞌiliꞌ le rna cni: “Gul‑dxíꞌi lzaꞌliꞌ tuliꞌ yetuliꞌ”. Ca naꞌ nedaꞌ nadxiꞌidaꞌ lbiꞌiliꞌ, lëzcaꞌ cni ral‑laꞌ gdxiꞌiliꞌ lzaꞌliꞌ tuliꞌ yetuliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chquiꞌ huadxíꞌi lzaꞌliꞌ tuliꞌ yetuliꞌ, láquibeꞌi yúguꞌtë bunách daꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Niꞌr gnabnëꞌ Jesús Simón Pedro, rnëꞌ: ―Xan, ¿gazxcz tsijuꞌ? Bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Ga naꞌ tsijaꞌ nedaꞌ, cutu gac sáꞌlenuꞌ nedaꞌ naꞌa, san huadzéy guiduꞌ ga tsijaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro rëꞌ Lëꞌ: ―Xan, ¿bizx quië cutu gac sáꞌlenaꞌ Liꞌ naꞌa? Chzoaꞌ udödaꞌ yöl‑laꞌ naꞌbán quiaꞌ, gatiaꞌ le nadxiꞌidaꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―¿Naruꞌ udöduꞌ yöl‑laꞌ naꞌbán quiuꞌ le nadxiꞌinuꞌ nedaꞌ? Le nactë rëpaꞌ liꞌ, tsonn lzu táꞌbaguꞌu, gnauꞌ cutu núnbëꞌu nedaꞌ ziꞌal ca cödxbaꞌ zxiꞌn druz. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Rnëꞌ Jesús: ―Cutu gchixi icj ládxiꞌdauꞌliꞌ. Gul‑tsejlëꞌ Dios, len gul‑tsejlëꞌ caꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lu yuꞌu lidxëꞌ Xuzaꞌ latj zian nacuáꞌ. Laꞌnaruꞌ cu nac cni, nedaꞌ chgudxczaꞌ lbiꞌiliꞌ. Tsijaꞌ naꞌa, tsajpáꞌa queëliꞌ latj ga tsajsoaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chquiꞌ huayijaꞌ len tsajpáꞌa queëliꞌ latj ga tsajsoaliꞌ, huödaꞌ leyúbl, uchëꞌa lbiꞌiliꞌ latj quiaꞌ, quië ga naꞌ tsajsóaꞌ nedaꞌ, niꞌ tsajsoaliꞌ caꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nö́ziczliꞌ ga niꞌ tsijaꞌ, len núnbëꞌliꞌ caꞌ nöz. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás rëꞌ Lëꞌ: ―Xan, cutu nö́zituꞌ gazx naꞌ tsijuꞌ. ¿Nacxcz gac gúnbëꞌtuꞌ nöz? ");
INSERT INTO zsrNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Nedaꞌ nacczaꞌ nöz, len nacaꞌ caꞌ le nac gdutë li, len nacaꞌ caꞌ Nu nabánigac bunách. Niꞌa quiaꞌ nedaꞌz gac nu gdxin ga zoëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Laꞌnaruꞌ núnbëꞌliꞌ nedaꞌ, Xuzaꞌ caꞌ núnbëꞌliꞌ‑nëꞌ. Naꞌa, núnbëꞌliꞌ‑nëꞌ len chbléꞌiliꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Niꞌr Felipe rëꞌ Lëꞌ: ―Xan, buluíꞌi netuꞌ Xuzuꞌ, atiꞌ nactë queëtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Felipe, xtsey chguc zóalenaꞌ lbiꞌiliꞌ. ¿Naruꞌ cu núnbëꞌtsuꞌ nedaꞌ? Nu bönniꞌ rléꞌinëꞌ nedaꞌ, rléꞌinëꞌ caꞌ Xuzaꞌ. ¿Rnatsuꞌ: “Buluíꞌi netuꞌ Xuzuꞌ”? ");
INSERT INTO zsrNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Naruꞌ cu réjlëꞌu zóalenczaꞌ‑nëꞌ Xuzaꞌ, atiꞌ Xuzaꞌ zóalenczëꞌ nedaꞌ? Yuguꞌ didzaꞌ ni ruíꞌlenaꞌ lbiꞌiliꞌ, clëg racz quiaꞌ ruꞌa didzaꞌ ni, san Xuzaꞌ zóalenczëꞌ nedaꞌ, Lëczëꞌ runëꞌ dxin ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gul‑tsejlëꞌ nedaꞌ, zóalenczaꞌ‑nëꞌ Xuzaꞌ, atiꞌ Xuzaꞌ zóalenczëꞌ nedaꞌ. Chquiꞌ cugác gunliꞌ cni, gul‑tsejlëꞌ nedaꞌ niꞌa quegac dxin ni runaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Le nactë rëpaꞌ lbiꞌiliꞌ: Yuguꞌ dxin ni runaꞌ nedaꞌ, lëzcaꞌ cni gunëꞌ bönniꞌ naꞌ rejlëꞌë nedaꞌ, atiꞌ le zxöntër caꞌ gunëꞌ bönniꞌ naꞌ le huöjaꞌ ga zoëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yúguꞌtë le gnabliꞌ lahuëꞌ Dios Xuz len ugunliꞌ dxin laꞌ nedaꞌ, nedaꞌ gunaꞌ lë naꞌ gnabliꞌ, quië uluꞌa lahui yöl‑laꞌ yeníꞌ zxön queëꞌ Dios Xuz nedaꞌ, Zxiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bítiꞌtëz bi gnabliꞌ len ugunliꞌ dxin laꞌ nedaꞌ, nedaꞌ gunaꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Rnëꞌ caꞌ Jesús: ―Chquiꞌ nadxiꞌiliꞌ nedaꞌ, gul‑gún le rëpaꞌ lbiꞌiliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","atiꞌ nedaꞌ gátaꞌyuaꞌ lahuëꞌ Dios Xuz, atiꞌ Lëꞌ gsölëꞌë queëliꞌ Nu yubl Nu gaclen lbiꞌiliꞌ, Nu huiꞌ zxön lbiꞌiliꞌ, len sóalentecz lbiꞌiliꞌ. Nu ni nac Dios Böꞌ Laꞌy, Nu ruiꞌ didzaꞌ gdutë li. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Cutu gac luzíꞌ xbëꞌ Lëꞌ bunách yödzlyú ni, le cutu gac laꞌléꞌinëꞌ Lëꞌ len cutu gac lunbëꞌë Lëꞌ, san zóalenczëꞌ lbiꞌiliꞌ, atiꞌ soëꞌ lu icj ládxiꞌdauꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Cutu ucaꞌnaꞌ lbiꞌiliꞌ ca yuguꞌ biꞌi uzëbdauꞌ. Huödaꞌ dusóalenaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yetú chiꞌidauꞌz cutur laꞌleꞌi nedaꞌ bunách yödzlyú ni, san lbiꞌiliꞌ uléꞌiliꞌ nedaꞌ. Le zoaczaꞌ nabanaꞌ nedaꞌ, lbiꞌiliꞌ caꞌ, tsaz soaliꞌ gbanliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dza niꞌr catiꞌ dusóalenëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy naꞌ, gnö́ziczliꞌ zóalenczaꞌ‑nëꞌ Xuzaꞌ Dios, atiꞌ lbiꞌiliꞌ zóalenliꞌ nedaꞌ, atiꞌ nedaꞌ caꞌ zóalenczaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nu bönniꞌ rziꞌ lu nëꞌë xtidzaꞌa len runëꞌ ca rna, nac bëꞌ nadxiꞌinëꞌ nedaꞌ bönniꞌ naꞌ. Xuzaꞌ Dios gdxiꞌinëꞌ bönniꞌ naꞌ nadxiꞌinëꞌ nedaꞌ, atiꞌ nedaꞌ gdxiꞌidaꞌ‑nëꞌ bönniꞌ naꞌ len uluíꞌ lahuaꞌ lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas rëꞌ lëꞌ, san clëg Judas Iscariote, rnëꞌ: ―Xan, ¿nacxcz gac uluíꞌ lauꞌ lautuꞌ netuꞌ, len cutu uluíꞌ lauꞌ laugac bunách yödzlyú? ");
INSERT INTO zsrNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Gunëꞌ ca rna xtidzaꞌa bönniꞌ nadxiꞌinëꞌ nedaꞌ, atiꞌ Xuzaꞌ Dios gdxiꞌinëꞌ bönniꞌ naꞌ, atiꞌ guidtuꞌ dusóalentuꞌ‑nëꞌ bönniꞌ naꞌ lu icj ládxiꞌdauꞌhuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Cutu runëꞌ ca rna xtidzaꞌa bönniꞌ cunadxiꞌinëꞌ nedaꞌ. Didzaꞌ naꞌ byö́niliꞌ bëꞌa nedaꞌ, clëgz quiaꞌ naꞌ, san nac queëꞌ Dios Xuz nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Rëpczaꞌ lbiꞌiliꞌ yuguꞌ lë ni tsal ni zóalenaꞌ lbiꞌiliꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","san gáclenëꞌ lbiꞌiliꞌ len huiꞌ zxönëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy, Nu naꞌ gsölëꞌë queëliꞌ Xuzaꞌ Dios le ugunliꞌ dxin laꞌ nedaꞌ. Usëdnëꞌ lbiꞌiliꞌ yúguꞌtë, len usë́ꞌë ládxiꞌliꞌ ca nac yúguꞌtë didzaꞌ naꞌ chgudxaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Rucaꞌnaꞌ queëliꞌ le cuequi dxi ládxiꞌliꞌ. Runnaꞌ queëliꞌ le röꞌ dxi ladxiꞌ quiaꞌ. Le röꞌ dxi ladxiꞌ naꞌ runnaꞌ queëliꞌ cutu nac ca le tunn queëliꞌ bunách yödzlyú ni. Cutu gchixi icj ládxiꞌdauꞌliꞌ, len cutu gadxi gdzö́biliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chbyö́niliꞌ ca naꞌ chgudxaꞌ lbiꞌiliꞌ: Huöjaꞌ, atiꞌ huödaꞌ dusóalenaꞌ lbiꞌiliꞌ. Laꞌnaruꞌ nadxiꞌiliꞌ nedaꞌ, udzíjiliꞌ catiꞌ niꞌ gudxaꞌ lbiꞌiliꞌ huöjaꞌ ga zoëꞌ Dios Xuz, le náctërëꞌ blau Dios ca nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Naꞌa, chgudxaꞌ lbiꞌiliꞌ ziꞌal ca ziꞌa gac, quië catiꞌ gac cni, tséjlëꞌliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","’Cutur güíꞌlenaꞌ lbiꞌiliꞌ didzaꞌ zian, le zaꞌ tuꞌ xöhuiꞌ, nu rna beꞌi bunách yödzlyú ni. Zal‑laꞌ cutu bi dë lu nëꞌi bi gun quiaꞌ nedaꞌ, cni ral‑laꞌ gac quië láquibeꞌi bunách yödzlyú ni nadxiꞌidaꞌ‑nëꞌ Dios Xuz, len runaꞌ ca naꞌ chgudxëꞌ nedaꞌ gunaꞌ. Gul‑tsás, uzaꞌruꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Lëzcaꞌ cni gudxëꞌ lequëꞌ Jesús: ―Nacaꞌ nedaꞌ ca tu lba uva le nac gdu, atiꞌ Xuzaꞌ naquëꞌ ca bönniꞌ guz guꞌn run chiꞌë lba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ugǘëꞌ yúguꞌtë zxuzaꞌ nëꞌi lba naꞌ nacaꞌ nedaꞌ, le cutu bi taꞌbía, atiꞌ uchiꞌë yúguꞌtë zxuzaꞌ nëꞌi naꞌ taꞌbía, quië laꞌbía yelatiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lbiꞌiliꞌ chnacliꞌ dxiꞌa niꞌa qui didzaꞌ naꞌ chgudxaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gul‑daꞌtecz nedaꞌ, ca naꞌ nedaꞌ dáꞌteczaꞌ caꞌ lbiꞌiliꞌ. Ca nac qui zxuzaꞌ nëꞌi lba naꞌ, cutu gac bi cuia racz qui, chquiꞌ cudaꞌtecz lba naꞌ, lëzcaꞌ cni nac queëliꞌ, cutu bi gac gunliꞌ chquiꞌ cutu táꞌteczliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nacaꞌ nedaꞌ ca lba naꞌ, atiꞌ lbiꞌiliꞌ nacliꞌ ca zxuzaꞌ nëꞌi. Nu bönniꞌ dáꞌteczëꞌ nedaꞌ, ca naꞌ nedaꞌ dáꞌteczaꞌ lëꞌ, bönniꞌ ni naquëꞌ ca zxuzaꞌ nëꞌi lba naꞌ rbia szxöni, le chquiꞌ nuláꞌalenliꞌ nedaꞌ, cutu bi gac gunliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu bönniꞌ cu dáꞌteczëꞌ nedaꞌ, gac queëꞌ ca rac quegac zxuzaꞌ nëꞌi lba naꞌ cunacgac dxiꞌa, taꞌruꞌnëꞌ zxuzaꞌ nëꞌi naꞌ atiꞌ laꞌbídx. Catiꞌ chnabidxgac zxuzaꞌ nëꞌi naꞌ, lutubëꞌ leygac len laꞌguꞌë leygac lu guiꞌ, atiꞌ tséguigac. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Chquiꞌ táꞌteczliꞌ nedaꞌ, len gunliꞌ ca rna xtidzaꞌa, huac gnabliꞌ bi guë́ꞌniliꞌ, atiꞌ nedaꞌ gunaꞌ lë naꞌ gnabliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Gunliꞌ ba laꞌn Xuzaꞌ Dios catiꞌ gunliꞌ xchinëꞌ, gacliꞌ ca zxuzaꞌ nëꞌi lba naꞌ taꞌbía, len cni gac bëꞌ nacliꞌ gdu bönniꞌ taꞌdë́ꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ca naꞌ nadxiꞌinëꞌ nedaꞌ Dios Xuz, lëzcaꞌ cni nadxiꞌidaꞌ lbiꞌiliꞌ. Gul‑guntecz ca ral‑laꞌ gunëꞌ bönniꞌ nadxiꞌidaꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chquiꞌ gunliꞌ ca rëpaꞌ lbiꞌiliꞌ, gunliꞌ ca ral‑laꞌ gunëꞌ bönniꞌ nadxiꞌidaꞌ‑nëꞌ, ca naꞌ nedaꞌ caꞌ runaꞌ ca chgudxëꞌ nedaꞌ Xuzaꞌ Dios gunaꞌ, len rúnteczaꞌ le rdzag ladxëꞌë Dios nadxiꞌinëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Yuguꞌ didzaꞌ ni rëpaꞌ lbiꞌiliꞌ quië udzíjilenliꞌ tsazxö́n nedaꞌ len gac gdu ca naꞌ udzíjiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lë ni nac le rëpaꞌ lbiꞌiliꞌ gunliꞌ. “Gul‑dxíꞌi lzaꞌliꞌ tuliꞌ yetuliꞌ, ca naꞌ nedaꞌ caꞌ nadxiꞌidaꞌ lbiꞌiliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cutu gac gdxiꞌirnëꞌ lzëꞌë bönniꞌ ca nu udö́d yöl‑laꞌ naꞌbán qui, gatiëꞌ bönniꞌ naꞌ quië gáclenëꞌ yuguꞌ böchiꞌ lzëꞌë le nadxiꞌinëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lbiꞌiliꞌ nacliꞌ böchiꞌ lzaꞌa chquiꞌ gunliꞌ ca naꞌ chgudxaꞌ lbiꞌiliꞌ gunliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cutur gniaꞌ queëliꞌ nacliꞌ huen dxin quiaꞌ, le cutu nöznëꞌ bönniꞌ huen dxin nac gunëꞌ xanëꞌ. Nedaꞌ chgniaꞌ queëliꞌ nacliꞌ böchiꞌ lzaꞌa, le chbenaꞌ ga nö́ziliꞌ yúguꞌtë le chgudxëꞌ nedaꞌ Xuzaꞌ gunaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Clëg lbiꞌiliꞌ gröliꞌ nedaꞌ, san nedaꞌ gröczaꞌ lbiꞌiliꞌ, len buzóaꞌ lbiꞌiliꞌ quië tseajliꞌ bi tsjenliꞌ, ca naꞌ tun zxuzaꞌ nëꞌi lba naꞌ taꞌbía szxöni, atiꞌ ugaꞌntecz lë naꞌ gunliꞌ. Cni gac, gunnëꞌ queëliꞌ Xuzaꞌ Dios yúguꞌtë le gnabliꞌ lahuëꞌ len ugunliꞌ dxin laꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lë ni nac le rëpaꞌ lbiꞌiliꞌ gunliꞌ: “Gul‑dxíꞌi lzaꞌliꞌ tuliꞌ yetuliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Gnëꞌ caꞌ Jesús: ―Chquiꞌ tuꞌzóa lbiꞌiliꞌ tslaꞌl bunách yödzlyú ni, nö́ziliꞌ chguluzóëꞌ nedaꞌ tslaꞌl ziꞌal ca tuꞌzóëꞌ lbiꞌiliꞌ tslaꞌl naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Laꞌnaruꞌ nacliꞌ tuz len bunách yödzlyú ni, hualaꞌdxíꞌi lbiꞌiliꞌ bunách yödzlyú ni ca naꞌ taꞌdxíꞌi lzaꞌgac, san tuꞌzóa lbiꞌiliꞌ tslaꞌl bunách yödzlyú ni le cunacliꞌ tuz len leygac, le gröczaꞌ lbiꞌiliꞌ nedaꞌ, len bubijaꞌ lbiꞌiliꞌ ladj bunách yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gul‑tsajnéy didzaꞌ naꞌ chgudxaꞌ lbiꞌiliꞌ, gniaꞌ: “Cutu náctërëꞌ blau bönniꞌ huen dxin ca xanëꞌ.” Chquiꞌ gulabía ládxiꞌgac nedaꞌ bunách, laꞌbía ládxiꞌgac caꞌ lbiꞌiliꞌ. Chquiꞌ nacuáꞌ nup tun ca rna xtidzaꞌa, lun caꞌ ca rna xtídzaꞌliꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yúguꞌtë lë ni lun queëliꞌ bunách le daꞌliꞌ nedaꞌ, le cutu núnbëꞌgac Dios Xuz nasölëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Laꞌnaruꞌ cu bidaꞌ, len laꞌnaruꞌ cu bë́ꞌlenaꞌ lequëꞌ didzaꞌ, cutu laꞌbaguëꞌë dul‑laꞌ, san naꞌa le bidaꞌ ni, cutu bi zoa bi laꞌnë́ꞌ qui dul‑laꞌ nabágaꞌquëꞌ le ubíj lequëꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu bönniꞌ ruzóëꞌ nedaꞌ tslaꞌl, ruzóëꞌ caꞌ tslaꞌl Xuzaꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Laꞌnaruꞌ cu benaꞌ yuguꞌ yöl‑laꞌ huac ga nacuꞌë, yuguꞌ le nutu nu ben ca glac, cutu laꞌbaguëꞌë dul‑laꞌ. Naꞌa, gulaléꞌinëꞌ yuguꞌ lë naꞌ benaꞌ, atiꞌ tuꞌzóëꞌ nedaꞌ tslaꞌl len tuꞌzóëꞌ caꞌ tslaꞌl Xuzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cni rac, quië utság ca rna xtidzëꞌë Dios, le nazíꞌ lu naꞌquëꞌ, rna: “Tuꞌzóëꞌ nedaꞌ tslaꞌl len cutu zoa bizx queë.” ");
INSERT INTO zsrNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Catiꞌ gdxinëꞌ ni Dios Böꞌ Laꞌy, Nu ruiꞌ didzaꞌ gdutë li, len Nu gaclen lbiꞌiliꞌ len huiꞌ zxön lbiꞌiliꞌ, Nu naꞌ gsölaꞌa queëliꞌ uláz queëꞌ Dios Xuz, Nu ni gun lnaꞌ lau quiaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lbiꞌiliꞌ caꞌ gunliꞌ lnaꞌ lau quiaꞌ, le zóalenczliꞌ nedaꞌ tsazxö́n dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Yuguꞌ didzaꞌ ni chgudxaꞌ lbiꞌiliꞌ, cui gac chop ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tsaz lubijëꞌ lbiꞌiliꞌ ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ gdxin dza catiꞌ nu bönniꞌ gdöddëꞌ lbiꞌiliꞌ gáquinëꞌ dxin queëꞌ Dios runëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cni lunëꞌ, le cunúnbëꞌquëꞌ Dios Xuz, len le cunúnbëꞌquëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Rëpaꞌ lbiꞌiliꞌ yuguꞌ didzaꞌ ni, quië catiꞌ gdxin dza naꞌ, tsajneyliꞌ didzaꞌ ni chgudxczaꞌ lbiꞌiliꞌ. Gnëꞌ caꞌ Jesús: ―Yuguꞌ didzaꞌ ni cutu gudxaꞌ lbiꞌiliꞌ dza niꞌtë, le niꞌ zóalenczaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Naꞌa huöjaꞌ, tsajsóalenaꞌ‑nëꞌ Dios Xuz, nasölëꞌë nedaꞌ, atiꞌ cutu gnábiliꞌ nedaꞌ nituliꞌ lbiꞌiliꞌ, cugnaliꞌ: “¿Gazx tsijuꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Naꞌa, le rëpaꞌ lbiꞌiliꞌ yuguꞌ didzaꞌ ni, rsëbi ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nedaꞌ rëpaꞌ lbiꞌiliꞌ le nac gdutë li. Dxiꞌar gac queëliꞌ huöjaꞌ, le chquiꞌ cuhuöjaꞌ, cutu dusóalenëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy, Nu naꞌ gaclen lbiꞌiliꞌ len huiꞌ zxön lbiꞌiliꞌ, san chquiꞌ huöjaꞌ, gsölaꞌa‑nëꞌ, dusóalenëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Catiꞌ guidëꞌ Lëꞌ, gunëꞌ ga láquibeꞌi bunách yödzlyú ni nabágaꞌgac dul‑laꞌ, len cutu núnbëꞌgac le nac tsahuiꞌ, atiꞌ gchuguëꞌ quequëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nabágaꞌquëꞌ dul‑laꞌ le cutaꞌyejlëꞌë nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cutu núnbëꞌquëꞌ le nac tsahuiꞌ le ludöddëꞌ nedaꞌ, huöjaꞌ ga zoëꞌ Dios Xuz, Nu nac tsahuiꞌ, atiꞌ cutur laꞌléꞌinëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gchuguëꞌ quequëꞌ Dios le chbchuguëꞌ qui tuꞌ xöhuiꞌ nu rna beꞌi bunách yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Yelaꞌgac zian didzaꞌ rëꞌndaꞌ güíꞌlenaꞌ lbiꞌiliꞌ, san cutu gac tséjniꞌliꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Catiꞌ guidëꞌ Dios Böꞌ Laꞌy, Nu ruiꞌ didzaꞌ gdutë li, Lëꞌ usëdnëꞌ lbiꞌiliꞌ yúguꞌtë le nac gdutë li naꞌ, le cutu guꞌë didzaꞌ racz queëꞌ, san guꞌë yúguꞌtë didzaꞌ naꞌ yönnëꞌ ruꞌë Xuzaꞌ, len gunëꞌ ga gnö́ziliꞌ yúguꞌtë le ral‑laꞌ gac. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lëꞌ gunëꞌ nedaꞌ ba laꞌn, le siꞌë le naqui quiaꞌ, len gunëꞌ ga gnö́ziliꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yúguꞌtë le naqui queëꞌ Dios Xuz naqui quiaꞌ. Qui lë ni naꞌ gniaꞌ siꞌë le naqui quiaꞌ, len gunëꞌ ga gnö́ziliꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Gnëꞌ caꞌ Jesús: ―Yetú chiꞌidauꞌz len cutur gléꞌiliꞌ nedaꞌ, atiꞌ yetú chiꞌidauꞌz caꞌ uléꞌiliꞌ nedaꞌ, le huöjaꞌ ga zoëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Niꞌr të lzaꞌquëꞌ tuëꞌ yetúëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―¿Bizxa rna didzaꞌ ni rëꞌ rëꞌu? Rnëꞌ: “Yetú chiꞌidauꞌz, len cutur gléꞌiliꞌ nedaꞌ, atiꞌ yetú chiꞌidauꞌz caꞌ uléꞌiliꞌ nedaꞌ, len nac le huöjaꞌ ga zoëꞌ Dios Xuz.” ");
INSERT INTO zsrNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Niꞌr gulanë́ꞌ: ―¿Bizxa caz rëꞌni gna didzaꞌ ni, gnëꞌ: “Yetú chiꞌidauꞌz”? Cutu réjniꞌtuꞌ didzaꞌ ni ruꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ráquibeꞌinëꞌ Jesús tëꞌnnëꞌ laꞌnabnëꞌ Lëꞌ, atiꞌ rëꞌ lequëꞌ: ―¿Naruꞌ rnabitsa lzaꞌliꞌ ca nac qui didzaꞌ naꞌ bëꞌa, gniaꞌ: Yetú chiꞌidauꞌz, len cutur gléꞌiliꞌ nedaꞌ, atiꞌ yetú chiꞌidauꞌz caꞌ uléꞌiliꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Le nactë rëpaꞌ lbiꞌiliꞌ: Cödxliꞌ len gsëbi ládxiꞌliꞌ, san bunách yödzlyú ni ludziji catiꞌ ludöddëꞌ nedaꞌ. Niꞌr zal‑laꞌ gsëbi ládxiꞌliꞌ, huöac yöl‑laꞌ rudziji yöl‑laꞌ rsëbi ladxiꞌ queëliꞌ catiꞌ uléꞌiliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tu ngul catiꞌ chzoa soabiꞌ biꞌidauꞌ queënu, rzacaꞌ rguiꞌnu, le chbdxin dza queënu, san catiꞌ chzoabiꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ queënu, cutur rajneynu lë naꞌ butsagnu, le rudzíjinu le chguljbiꞌ tubiꞌ biꞌi bö́nniꞌdauꞌ yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lëzcaꞌ cni rac queëliꞌ, rsëbi ládxiꞌliꞌ naꞌa, san huödaꞌ duyúaꞌ lbiꞌiliꞌ, atiꞌ niꞌr udziji ládxiꞌliꞌ, atiꞌ cutu sáquiꞌnëꞌ bönniꞌ ugǘëꞌ yöl‑laꞌ rudziji queëliꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Dza niꞌr cutu bi gnábiliꞌ nedaꞌ. Le nactë rëpaꞌ lbiꞌiliꞌ: Yúguꞌtë le gnabliꞌ lahuëꞌ Dios Xuz, len ugunliꞌ dxin laꞌ nedaꞌ, Lëꞌ gunnëꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ga rdxintë naꞌa dza cutu rugunliꞌ dxin laꞌ nedaꞌ catiꞌ bi rnábiliꞌ‑nëꞌ Dios Xuz. Gul‑náb cni, atiꞌ gdél‑liꞌliꞌ lë naꞌ gnabliꞌ, quië gac gdu yöl‑laꞌ rudziji queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Gnëꞌ caꞌ Jesús: ―Yuguꞌ lë naꞌ chbë́ꞌlenaꞌ lbiꞌiliꞌ didzaꞌ benaꞌ lsaquiꞌ. Huadxín dza catiꞌ cutur güíꞌlenaꞌ lbiꞌiliꞌ didzaꞌ le runaꞌ lsaquiꞌ, san yalj lulu güíꞌlenaꞌ lbiꞌiliꞌ didzaꞌ ca nac queëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Dza naꞌ gnabliꞌ lahuëꞌ Dios len ugunliꞌ dxin laꞌ nedaꞌ, atiꞌ rëpaꞌ lbiꞌiliꞌ, cutu gun bayúdx gátaꞌyuaꞌ lahuëꞌ Dios Xuz uláz queëliꞌ, le nadxiꞌinëꞌ lbiꞌiliꞌ Lëczëꞌ Dios Xuz. Nadxiꞌinëꞌ lbiꞌiliꞌ le nadxiꞌiliꞌ nedaꞌ len réjlëꞌliꞌ brujaꞌ ga zoëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Brujaꞌ ga zoëꞌ Dios Xuz, len bdxinaꞌ yödzlyú ni. Yetú caꞌ, ucaꞌnaꞌ yödzlyú ni, atiꞌ huöjaꞌ ga zoëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Niꞌr glëꞌ Lëꞌ bönniꞌ usë́d queëꞌ, taꞌnë́ꞌ: ―Naꞌa ruꞌu didzaꞌ yalj lulu, len cutur runuꞌ lsaquiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naꞌa ráquibeꞌituꞌ nözcznuꞌ Liꞌ yúguꞌtë len cutu run bayúdx nu bi gnabi yudxi Liꞌ, le rguíxjöiꞌnuꞌ netuꞌ le ziꞌa gnabtuꞌ. Qui lë ni naꞌ réjlëꞌtuꞌ brujuꞌ ga zoëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Bubiꞌë didzaꞌ Jesús, rëꞌ lequëꞌ: ―¿Naruꞌ réjlëꞌtsaliꞌ nedaꞌ naꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gul‑yú, huadxín dza, len chrdxin dza naꞌ, catiꞌ gáslasliꞌ qui queëliꞌ, ucaꞌnliꞌ nedaꞌ tuzaꞌ, san cutu soaꞌ tuzaꞌ, le zóalenczëꞌ nedaꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yuguꞌ didzaꞌ ni chgudxaꞌ lbiꞌiliꞌ quië cuequi dxi ládxiꞌliꞌ, le nacliꞌ quiaꞌ nedaꞌ. Yödzlyú ni gac queëliꞌ le usacaꞌ ziꞌ lbiꞌiliꞌ, san gul‑típ ládxiꞌliꞌ. Nedaꞌ chbuxicjaꞌ lu le rac yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Budx bëꞌë yuguꞌ didzaꞌ ni Jesús, bchis lahuëꞌ, ruyúëꞌ yehuaꞌ yubál, rnëꞌ: ―Dios Xuz, chbdxin dza. Ben ga glaꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ nedaꞌ, Zxiꞌnuꞌ, quië gac gunaꞌ ga glaꞌ lahui yöl‑laꞌ yeníꞌ quiuꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ben cni le chnudöduꞌ lu naꞌa yöl‑laꞌ uná bëꞌ gna béꞌidaꞌ yúguꞌtë bunách, len guꞌa yöl‑laꞌ naꞌbán gdu quegac yúguꞌtë nup naꞌ chbennuꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lë ni nac yöl‑laꞌ naꞌbán gdu naꞌ, le núnbëꞌquëꞌ Liꞌ, nacuꞌ laꞌz dui Dios gdu, len le núnbëꞌquëꞌ caꞌ nedaꞌ, Jesucristo, atiꞌ Liꞌ nasöluꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nedaꞌ chbenaꞌ ga naláꞌ lahui yöl‑laꞌ yeníꞌ quiuꞌ yödzlyú ni, len chbudx benaꞌ dxin naꞌ budöduꞌ lu naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naꞌa, Xuz, ben ga glaꞌ lahui yöl‑laꞌ yeníꞌ napaꞌ tsazxö́n len Liꞌ, gac quiaꞌ yöl‑laꞌ yeníꞌ naꞌ gutaꞌ quiaꞌ tsazxö́n len Liꞌ dza niꞌtë ziꞌa gataꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Chbuluꞌa lahui le nacuꞌ Liꞌ lauquëꞌ bönniꞌ ni bennuꞌ quiaꞌ, nup naꞌ bubijuꞌ ladj bunách yödzlyú. Gláquinëꞌ quiuꞌ bönniꞌ ni, atiꞌ bénngacuꞌ‑nëꞌ quiaꞌ, atiꞌ tunëꞌ ca rna xtidzuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naꞌa nözcnëꞌ lu naꞌu Liꞌ zaꞌc yúguꞌtë lë naꞌ bennuꞌ quiaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","le chbudödaꞌ lu naꞌquëꞌ didzaꞌ naꞌ budöduꞌ Liꞌ lu naꞌa nedaꞌ, atiꞌ lequëꞌ nazíꞌ lu naꞌquëꞌ lei, len táquibeꞌinëꞌ brujaꞌ ga zuꞌ Liꞌ, len taꞌyejlëꞌë Liꞌ nasöluꞌu nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nedaꞌ rátaꞌyuaꞌ Lauꞌ gáclenuꞌ lequëꞌ. Rátaꞌyuaꞌ Lauꞌ, clëg gáclenuꞌ yúguꞌtë bunách yödzlyú, san gáclengacuꞌ‑nëꞌ bönniꞌ ni chbénngacuꞌ‑nëꞌ quiaꞌ, le náquicnëꞌ quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yúguꞌtë nup náquigac quiaꞌ náquigac caꞌ quiuꞌ, atiꞌ nup naꞌ náquigac quiuꞌ náquigac caꞌ quiaꞌ, atiꞌ ca nacgac nup naꞌ ruluíꞌ lahui yöl‑laꞌ yeníꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Naꞌa, cutur ugaꞌnaꞌ yödzlyú ni, san lugaꞌnëꞌ yödzlyú yuguꞌ bönniꞌ ni, atiꞌ nedaꞌ dusóalenaꞌ Liꞌ. Xuz Laꞌy, len yöl‑laꞌ huac quiuꞌ ben chiꞌi nup ni chbennuꞌ quiaꞌ, quië lacquëꞌ tuz, ca naꞌ nacruꞌ tuz rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Catiꞌ niꞌ gzóalenaꞌ lequëꞌ yödzlyú ni, ben chíꞌigacaꞌ‑nëꞌ, bugunaꞌ dxin yöl‑laꞌ huac naꞌ bennuꞌ quiaꞌ. Nup naꞌ bennuꞌ quiaꞌ, ben chíꞌigacaꞌ‑nëꞌ, atiꞌ nitúëꞌ cutu bunitiaꞌ‑nëꞌ, san tuzëꞌ bönniꞌ naꞌ naquëꞌ ca zxiꞌn tuꞌ xöhuiꞌ, len ral‑laꞌ nitiëꞌ tsaz, quië utság le nayúj lu guich laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Naꞌa dusóalenaꞌ Liꞌ, san tsal ni zoaꞌ yödzlyú ni, ruꞌa yuguꞌ didzaꞌ ni quië gac gdu quequëꞌ yöl‑laꞌ rudziji ca naꞌ rac quiaꞌ nedaꞌ yöl‑laꞌ rudziji. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nedaꞌ chbudödaꞌ lu naꞌquëꞌ xtidzuꞌu, atiꞌ tuꞌzóa lequëꞌ tslaꞌl bunách yödzlyú ni le cunacquëꞌ tuz len leygac, ca naꞌ nac quiaꞌ nedaꞌ, cutu nacaꞌ tuz len bunách yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Rátaꞌyuaꞌ Lauꞌ, clëg cuacuꞌ‑nëꞌ yödzlyú ni, san gun chíꞌigacuꞌ‑nëꞌ, cui laꞌdzunëꞌ lu naꞌ tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Cutu nacquëꞌ tuz len bunách yödzlyú ni ca naꞌ nac quiaꞌ nedaꞌ, cutu nacaꞌ tuz len bunách yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bubíj quizi quiuꞌ lequëꞌ, ugunuꞌ dxin le nac gdutë li. Le nac gdutë li naꞌ nac xtidzuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ca naꞌ benuꞌ Liꞌ, bsöluꞌu nedaꞌ ladj bunách yödzlyú ni, lëzcaꞌ cni runaꞌ nedaꞌ, rsö́laꞌgacaꞌ‑nëꞌ ladj bunách yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Le nadxíꞌigacdaꞌ‑nëꞌ rudö́d cuinaꞌ quiuꞌ, quië lurujëꞌ caꞌ lequëꞌ quizi quiuꞌ le nazíꞌ lu naꞌquëꞌ le nac gdutë li. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Rátaꞌyuaꞌ Lauꞌ, clëg quégaczëꞌ bönniꞌ ni, san lëzcaꞌ quequëꞌ bönniꞌ niꞌ laꞌyejlëꞌë nedaꞌ niꞌa qui didzaꞌ luꞌë bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rátaꞌyuaꞌ Lauꞌ gunuꞌ ga lacquëꞌ tuz yúguꞌtëꞌ, len lacquëꞌ caꞌ tuz len rëꞌu, ca naꞌ nacuꞌ Liꞌ, Xuzaꞌ, nacuꞌ tuz len nedaꞌ, atiꞌ nedaꞌ caꞌ, nacaꞌ tuz len Liꞌ. Cni ral‑laꞌ lacquëꞌ quië laꞌyejlëꞌ yezicaꞌ bunách yödzlyú ni, bsö́laꞌczuꞌ nedaꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yöl‑laꞌ yeníꞌ naꞌ bennuꞌ quiaꞌ, nedaꞌ bëꞌa caꞌ quequëꞌ, quië lacquëꞌ tuz, ca naꞌ nacruꞌ tuz rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Liꞌ nacuꞌ tuz len nedaꞌ, atiꞌ nedaꞌ gacaꞌ tuz len lequëꞌ, quië gac gdu ca nacquëꞌ tuz, len cni láquibeꞌi yezicaꞌ bunách yödzlyú ni, bsö́laꞌczuꞌ nedaꞌ Liꞌ, atiꞌ nadxíꞌigacduꞌ‑nëꞌ ca naꞌ nadxiꞌinuꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xúzaꞌdauꞌ, rëꞌndaꞌ laꞌcuáꞌlenëꞌ nedaꞌ ga naꞌ tsajsóaꞌ bönniꞌ ni bénngacuꞌ‑nëꞌ quiaꞌ, quië laꞌléꞌinëꞌ yöl‑laꞌ yeníꞌ naꞌ bennuꞌ quiaꞌ le nadxiꞌinuꞌ nedaꞌ dza niꞌtë, catiꞌ ziꞌa gunuꞌ yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xuzaꞌ tsahuiꞌ, cutu núnbëꞌgac Liꞌ bunách yödzlyú ni, san nedaꞌ núnbëꞌczaꞌ Liꞌ, atiꞌ yuguꞌ bönniꞌ ni chnözcnëꞌ bsö́laꞌczuꞌ nedaꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Benaꞌ ga nözcnëꞌ le nacuꞌ Liꞌ, len gunraꞌ caꞌ ga laꞌnöznëꞌ lë ni quië ca naꞌ nadxiꞌinuꞌ Liꞌ nedaꞌ, lëzcaꞌ cni laꞌdxíꞌi lzaꞌquëꞌ, atiꞌ gacczaꞌ caꞌ tuz len lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Catiꞌ budx bëꞌë yuguꞌ didzaꞌ ni Jesús, brujëꞌ niꞌ atiꞌ zéajlenëꞌ yuguꞌ bönniꞌ usë́d queëꞌ. Gdödëꞌ yetsláꞌa yegu Cedrón len bdxinëꞌ ga niꞌ dë tu laꞌ yël, atiꞌ latj ni gyázlenëꞌ yuguꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Lëzcaꞌ Judas, bönniꞌ naꞌ udödëꞌ Jesús, nunbëꞌë laꞌ yël naꞌ, le butubëꞌ niꞌ Jesús zian lzu yuguꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Niꞌr bchëꞌë Judas tu cöꞌ bönniꞌ rjaquëꞌ gdil‑l len yuguꞌ bönniꞌ niꞌa naꞌquëꞌ bxuz uná bëꞌ len niꞌa naꞌquëꞌ bönniꞌ gdauꞌ fariseo, atiꞌ yjaquëꞌ ga niꞌ zoëꞌ Jesús, nuaꞌquëꞌ yuguꞌ guiꞌ yör, len yuguꞌ le taꞌneynëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Niꞌr, le nözcznëꞌ Jesús yúguꞌtë le ral‑laꞌ gac queëꞌ, brujëꞌ ga niꞌ zoëꞌ len rëꞌ lequëꞌ: ―¿Nuzxa rguiljliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gulubiꞌë didzaꞌ, tëꞌ Lëꞌ: ―Jesús, bönniꞌ Nazaret, rguiljtuꞌ‑nëꞌ. Jesús rëꞌ lequëꞌ: ―Nédaꞌczaꞌ. Zóalenëꞌ caꞌ lequëꞌ Judas, bönniꞌ naꞌ rudödëꞌ Jesús lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Catiꞌ Jesús gudxëꞌ lequëꞌ: “Nédaꞌczaꞌ”, niꞌr gulubiguëꞌë guzcudzuꞌl len guladzöꞌë lyu. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús gnabnëꞌ lequëꞌ leyúbl, rnëꞌ: ―¿Nuzxa rguiljliꞌ? Tëꞌ Lëꞌ: ―Jesús, bönniꞌ Nazaret, rguiljtuꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Niꞌr bubiꞌë didzaꞌ Jesús, rnëꞌ: ―Chgudxaꞌ lbiꞌiliꞌ, nédaꞌczaꞌ. Chquiꞌ rguiljliꞌ nedaꞌ, gul‑güíꞌ‑quëꞌ latj tshuöjquëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cni gnëꞌ Jesús quië butság didzaꞌ naꞌ bëꞌë, gnëꞌ: “Nup ni bennuꞌ quiaꞌ, nitúëꞌ cutu bunitiaꞌ‑nëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Niꞌr, le nuꞌë guia tuchiꞌ Simón Pedro, gleycjëꞌ lei, len bentëꞌ huëꞌ Malco, huen dxin queëꞌ bxuz blau, bchuguëꞌ guid naguëꞌ yubél bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Niꞌr Jesús rëꞌ Pedro naꞌ: ―Bugúꞌu lidx, guia tuchiꞌ quiuꞌ. ¿Naruꞌ cu ral‑laꞌ sacaꞌ quiꞌa lë naꞌ chnunëꞌ quiaꞌ Xuzaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gulazönëꞌ Jesús len glúguëꞌë Lëꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l len bönniꞌ naꞌ nacuꞌë lu nëꞌë, lencaꞌ yuguꞌ bönniꞌ niꞌa naꞌquëꞌ bönniꞌ judío uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Niꞌr gulachë́ꞌë Lëꞌ ziꞌal lahuëꞌ Anás, le naquëꞌ xtauꞌ zxiꞌnëꞌ Caifás, bönniꞌ naquëꞌ bxuz blau iz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Naquëꞌ Caifás bönniꞌ naꞌ buzéjniꞌnëꞌ yuguꞌ bönniꞌ judío uná bëꞌ, buluiꞌinëꞌ lequëꞌ dxiꞌar gac gatiëꞌ tuzëꞌ bönniꞌ len clëg nit gdutë yödz quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yjaquëꞌ cúdzuꞌlëꞌ Jesús Simón Pedro len yetúëꞌ bönniꞌ usë́d queëꞌ Jesús, zajnauquëꞌ Lëꞌ. Bönniꞌ usë́d ni gyázlenëꞌ Jesús löꞌa qui lidx bxuz blau, le nunbëꞌë lëꞌ bxuz blau naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bugaꞌnëꞌ Pedro niꞌl ga nu ryaz löꞌa naꞌ. Qui lë ni naꞌ burujëꞌ bönniꞌ usë́d naꞌ nunbëꞌë lëꞌ bxuz blau, atiꞌ bë́ꞌlenëꞌ‑nu didzaꞌ ngul naꞌ run chiꞌinu ga nu ryaz löꞌa naꞌ, len benëꞌ ga gyaziëꞌ Pedro löꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Niꞌr rënu Pedro ngul naꞌ run chiꞌinu ga nu ryaz löꞌa, rnanu: ―¿Naruꞌ cu daꞌu caꞌ liꞌ bönniꞌ ni? Bubiꞌë didzaꞌ Pedro, rnëꞌ: ―Clëg nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Le run ziag, nabéquiquëꞌ guiꞌ yuguꞌ bönniꞌ huen dxin len yuguꞌ bönniꞌ niꞌa naꞌgac bunách gdauꞌ, atiꞌ zuicnëꞌ raꞌ guiꞌ naꞌ, tuꞌtsëꞌi cuinquëꞌ. Lëzcaꞌ zuílenëꞌ lequëꞌ Pedro, rutsëꞌi cuinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Niꞌr gnabi yudxnëꞌ Jesús bxuz blau quië gnöznëꞌ nupx daꞌgac Lëꞌ len nacx nac le rusëdnëꞌ bunách Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Yalj lulu bë́ꞌlenaꞌ yúguꞌtë bunách didzaꞌ. Busë́dteczdaꞌ lequëꞌ gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios lencaꞌ nchil gdauꞌ, ga niꞌ tuꞌdubëꞌ yúguꞌtë bönniꞌ judío, len cutu bi didzaꞌ bëꞌa bagachiꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bizx quië rnabi yudxnuꞌ nedaꞌ? Gnabi yudxi nup niꞌ gulayöni didzaꞌ bë́ꞌlenaꞌ lequëꞌ. Byutscaꞌ, nözcnëꞌ didzaꞌ naꞌ bë́ꞌlenaꞌ lequëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Catiꞌ budx bëꞌë didzaꞌ ni Jesús, gdapëꞌë ruꞌë Jesús bönniꞌ niꞌa naꞌgac bunách gdauꞌ zoëꞌ niꞌ, rnëꞌ: ―¿Naruꞌ cni rubiꞌtsuꞌ didzaꞌ lahuëꞌ bxuz blau? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Chquiꞌ cugníaꞌ dxiꞌa, gdixjöꞌ bizxal didzaꞌ bëꞌa cunác dxiꞌa, len chquiꞌ guc dxiꞌa didzaꞌ bëꞌa, ¿bizx quië naꞌ gdapuꞌu nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Niꞌr bsölëꞌë Jesús náguëꞌë Anás naꞌ, atiꞌ guluschinëꞌ Lëꞌ lahuëꞌ Caifás, naquëꞌ gdu bxuz blau. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Catiꞌ niꞌ zuinëꞌ Pedro raꞌ guiꞌ rutsëꞌi cuinëꞌ, glëꞌ lëꞌ bönniꞌ nacuꞌë niꞌ, taꞌnë́ꞌ: ―¿Naruꞌ cu daꞌu caꞌ liꞌ Jesús naꞌ? Gdáꞌbaguëꞌë Pedro, rnëꞌ: ―Clëg nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Zoëꞌ niꞌ bönniꞌ huen dxin queëꞌ bxuz blau, naquëꞌ diꞌa dza queëꞌ bönniꞌ naꞌ Pedro bchuguëꞌ guid naguëꞌ, atiꞌ bönniꞌ huen dxin naꞌ rëꞌ Pedro: ―¿Naruꞌ cu bléꞌiczdaꞌ liꞌ laꞌ yël niꞌ, dzaguꞌ‑nëꞌ Jesús? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Leyúbl gdáꞌbaguëꞌë Pedro, atiꞌ laꞌ grö́dxtëbaꞌ zxiꞌn druz. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Niꞌr gulachë́ꞌë Jesús, guluzë́ꞌë lidxëꞌ Caifás naꞌ, len guladxinëꞌ yúlahuiꞌ queëꞌ bönniꞌ rna bëꞌë, nazíꞌ lei Pretorio. Chzaꞌ reníꞌ dza naꞌ atiꞌ cutu gulayaziëꞌ yúlahuiꞌ naꞌ bönniꞌ judío, le táquinëꞌ laꞌbaguëꞌë zxguiaꞌ chquiꞌ laꞌyaziëꞌ niꞌ, le gun ga cugác lahuëꞌ xtsöꞌ Lni Pascua, lni naꞌ tuꞌspanëꞌ ca benëꞌ Dios, bubijëꞌ bunách Israel luyú Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Niꞌr brujëꞌ Pilato, bönniꞌ rna bëꞌë naꞌ, bdxinëꞌ ga naꞌ nacuꞌë, len rëꞌ lequëꞌ: ―¿Bizxa ruquiliꞌ‑nëꞌ bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Gulubiꞌë didzaꞌ, tëꞌ lëꞌ: ―Laꞌnaruꞌ cu nuꞌë döꞌ bönniꞌ ni, cutu udödtuꞌ‑nëꞌ lauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Niꞌr rëꞌ lequëꞌ Pilato, rnëꞌ: ―Lbiꞌiczliꞌ gul‑chë́ꞌë, len gul‑bequi xbey Lëꞌ ca rna bëꞌ zxba queëliꞌ. Tëꞌ lëꞌ bönniꞌ judío, taꞌnë́ꞌ: ―Cutu dë lu naꞌtuꞌ nu gdö́dituꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Cni guc quië butság xtidzëꞌë Jesús, le bëꞌë nac ral‑laꞌ gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Niꞌr buaziëꞌ yúlahuiꞌ naꞌ Pilato, atiꞌ bulidzëꞌ Jesús len rëꞌ Lëꞌ: ―¿I nacuꞌ Liꞌ Bönniꞌ Rna Béꞌinëꞌ Bönniꞌ Judío? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―¿I racz quiuꞌ rnauꞌ cni, o glë liꞌ cni bunách ca nac quiaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato rëꞌ Lëꞌ: ―¿Naruꞌ ráquitsanuꞌ nacaꞌ judío? Guludödëꞌ Liꞌ lu naꞌa yuguꞌ bönniꞌ uládz quiuꞌ len yuguꞌ bxuz uná bëꞌ. ¿Bizxa caz benuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Niꞌr bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Rna bëꞌa nedaꞌ, san clëg ca taꞌná bëꞌ bunách yödzlyú ni. Laꞌnaruꞌ rna bëꞌa ca taꞌná bëꞌ bunách yödzlyú, laꞌdil‑lëꞌ bönniꞌ daꞌquëꞌ nedaꞌ, cui luꞌë latj nu udö́d nedaꞌ lu naꞌquëꞌ bönniꞌ judío. Ca rna bëꞌa nedaꞌ cutu nac ca taꞌná bëꞌ bunách yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Niꞌr Pilato rëꞌ Lëꞌ: ―¿Nactsuꞌ caꞌ bönniꞌ rna bëꞌë? Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Nacaꞌ ca naꞌ rnauꞌ. Qui lë ni naꞌ bidaꞌ ga guljaꞌ yödzlyú ni, quië gunaꞌ lnaꞌ lau qui le nac gdutë li. Tuꞌzë́ naggac didzaꞌ ruꞌa yúguꞌtë nup ni tun le nac gdutë li. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato rëꞌ Lëꞌ: ―¿Bizxa naꞌ le nac gdutë li? Catiꞌ budx gnëꞌ cni Pilato, burujëꞌ leyúbl ga naꞌ nacuꞌë bönniꞌ judío uná bëꞌ naꞌ, len rëꞌ lequëꞌ: ―Cutu bi döꞌ rudzöldaꞌ nuꞌë bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lbiꞌiliꞌ dë tu le nalë́biliꞌ runliꞌ catiꞌ rac Lni Pascua ni, rnabliꞌ lahuaꞌ usanaꞌ‑nëꞌ queëliꞌ tuëꞌ bönniꞌ nadzunëꞌ. ¿I rë́ꞌniliꞌ usanaꞌ‑nëꞌ queëliꞌ Bönniꞌ Rna Béꞌinëꞌ Bönniꞌ Judío? ");
INSERT INTO zsrNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Niꞌr gluꞌë zidzj didzaꞌ leyúbl yúguꞌtëꞌ, taꞌnë́ꞌ: ―Clëg bönniꞌ ni, san Barrabás usanuꞌ‑nëꞌ queëtuꞌ. Barrabás naꞌ naquëꞌ gban. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Niꞌr bchëꞌë Jesús Pilato, len benëꞌ ga gulaguinëꞌ Lëꞌ bönniꞌ rjaquëꞌ gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Glunëꞌ tu breguiꞌ zxuzaꞌ nëꞌi yötsiꞌ bönniꞌ rjaquëꞌ gdil‑l, atiꞌ guludxíëꞌ lei icjëꞌ Jesús, len gulugacuëꞌ Lëꞌ tu lariꞌ tunn xna ca nac le tacuëꞌ bönniꞌ taꞌná bëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Niꞌr gulabiguëꞌë lahuëꞌ Jesús, len tëꞌ Lëꞌ: ―Bicaꞌ bauꞌ Liꞌ, Bönniꞌ Rna Béꞌinëꞌ Bunách Judío. Niꞌr gulagapëꞌë lau ruꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Niꞌr burujëꞌ leyúbl Pilato, len rëꞌ yuguꞌ bönniꞌ judío uná bëꞌ, rnëꞌ: ―Gul‑yú, ubijaꞌ‑nëꞌ lauliꞌ ni quië gnö́ziliꞌ nitú le nac döꞌ cutu rudzöldaꞌ nuꞌë bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Niꞌr brujëꞌ Jesús, dxia icjëꞌ breguiꞌ zxuzaꞌ nëꞌi yötsiꞌ naꞌ len nacuëꞌ lariꞌ tunn xna naꞌ. Pilato rëꞌ lequëꞌ: ―Ni zoëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Catiꞌ gulaléꞌinëꞌ Jesús yuguꞌ bxuz uná bëꞌ len yuguꞌ bönniꞌ niꞌa naꞌquëꞌ, zidzj gluꞌë didzaꞌ, taꞌnë́ꞌ: ―Bdëꞌë lëꞌi yag cruz. Bdëꞌë lëꞌi yag cruz. Pilato rëꞌ lequëꞌ: ―Lbiꞌiczliꞌ gul‑chë́ꞌë len gul‑tsajdë́ꞌë lëꞌi yag cruz. Nedaꞌ cutu bi döꞌ budzöldaꞌ nuꞌë bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Niꞌr bönniꞌ judío naꞌ tëꞌ lëꞌ: ―Dë queëtuꞌ tu zxba, len rna bëꞌ zxba queëtuꞌ naꞌ ral‑laꞌ gatiëꞌ bönniꞌ ni le gnëꞌ naquëꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Catiꞌ byönnëꞌ didzaꞌ ni Pilato, gudxrnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Leyúbl buaziëꞌ yúlahuiꞌ naꞌ, len rëꞌ Jesús: ―¿Gazxtë bönniꞌ Liꞌ? Cutu bi didzaꞌ bubiꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Niꞌr Pilato rëꞌ Lëꞌ: ―¿Naruꞌ cu ubiꞌitsuꞌ didzaꞌ, quíxjöiꞌnuꞌ nedaꞌ? ¿Naruꞌ cu nöznuꞌ dë lu naꞌa udáꞌa Liꞌ lëꞌi yag cruz, len dë lu naꞌa usanaꞌ Liꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Bubiꞌë didzaꞌ Jesús, rëꞌ lëꞌ: ―Cutu bi dë lu naꞌu gunuꞌ quiaꞌ laꞌnaruꞌ cu nudödëꞌ lu naꞌu yöl‑laꞌ uná bëꞌ naꞌ Dios. Qui lë ni naꞌ, bönniꞌ naꞌ budödëꞌ nedaꞌ lu naꞌu nabágaꞌrëꞌ zxguiaꞌ ca liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Laꞌ niꞌz rzu rböꞌë Pilato usanëꞌ Jesús, san gluꞌë zidzj didzaꞌ bönniꞌ judío uná bëꞌ, taꞌnë́ꞌ: ―Chquiꞌ usanuꞌ‑nëꞌ bönniꞌ ni, cutu rdzaguꞌ‑nëꞌ dxiꞌa César, bönniꞌ rna béꞌinëꞌ gdutë yödzlyú. Nu bönniꞌ run cuinëꞌ bönniꞌ rna bëꞌë, rdáꞌbaguëꞌë César naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Catiꞌ byönnëꞌ didzaꞌ ni Pilato, gna béꞌinëꞌ nup tsajxiꞌgac Jesús, atiꞌ gröꞌë xlatjëꞌ ga rbequi xbeynëꞌ, latj naꞌ nazíꞌ lei Löꞌa Ga Zxoagac Guiöj Blag, len ca nac didzaꞌ hebreo nazíꞌ lei Gabata. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Laꞌ dza naꞌz nac dza ziꞌa gdxin Lni Pascua, len nac gdu huagbídz. Niꞌr gudxëꞌ yuguꞌ bönniꞌ judío uná bëꞌ naꞌ Pilato, rnëꞌ: ―Ni zoëꞌ bönniꞌ rna béꞌinëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Bëtiëꞌ, bëtiëꞌ. Bdëꞌë lëꞌi yag cruz. Pilato rëꞌ lequëꞌ: ―¿Rnábitsaliꞌ nedaꞌ udáꞌa‑nëꞌ lëꞌi yag cruz bönniꞌ rna béꞌinëꞌ lbiꞌiliꞌ? Gulubiꞌë didzaꞌ bxuz uná bëꞌ, taꞌnë́ꞌ: ―Nutur nu zoa rna beꞌi netuꞌ. Tuzëꞌ César rna béꞌinëꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Qui lë ni naꞌ budödëꞌ Jesús lu naꞌquëꞌ Pilato, quië tsajdaꞌquëꞌ Lëꞌ lëꞌi yag cruz. Niꞌr gulaguel‑lëꞌë Jesús, len gulachë́ꞌë Lëꞌ niꞌl. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Brujëꞌ niꞌ Jesús, nuꞌë yag cruz queëꞌ, zijëꞌ latj nazíꞌ lei Latj Qui Bögaꞌ Icjruꞌ, len ca nac didzaꞌ hebreo nazíꞌ lei Gólgota. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Niꞌ guludë́ꞌë Jesús lëꞌi yag cruz, atiꞌ guludáꞌlenëꞌ Lëꞌ tsazxö́n lë́ꞌigac yag cruz yechopëꞌ bönniꞌ. Tslaꞌa hueaj taꞌdë́ꞌë, atiꞌ Jesús dëꞌë gatsj lahuiꞌl chopëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bsölëꞌë Pilato bönniꞌ buzujëꞌ lu guich tu didzaꞌ le buzóëꞌ lëꞌi yag cruz icjlëꞌ Jesús, le rna cni: “Jesús, Bönniꞌ Nazaret, Bönniꞌ Rna Béꞌinëꞌ Bönniꞌ Judío.” ");
INSERT INTO zsrNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gululabëꞌ didzaꞌ ni zian bönniꞌ judío, le zoa gal‑laꞌz raꞌ yödz ga naꞌ guludë́ꞌë Jesús lëꞌi yag cruz, atiꞌ didzaꞌ naꞌ nuzujëꞌ lu didzaꞌ hebreo, len lu didzaꞌ griego, len lu didzaꞌ latín. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tëꞌ Pilato bxuz uná bëꞌ quequëꞌ bönniꞌ judío, taꞌnë́ꞌ: ―Cutu uzujuꞌ, Bönniꞌ Rna Béꞌinëꞌ Bönniꞌ Judío. Bzuj cni: “Lëꞌ gnëꞌ: Gna béꞌidaꞌ bönniꞌ judío.” ");
INSERT INTO zsrNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bubiꞌë didzaꞌ Pilato, rëꞌ lequëꞌ: ―Le chnuzujaꞌ, tsaz chnuzujaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Catiꞌ budx guludë́ꞌë Jesús lëꞌi yag cruz bönniꞌ naꞌ rjaquëꞌ gdil‑l, gulaguel‑lëꞌë lariꞌ nacuëꞌ Jesús. Gulabijëꞌ tapl, tu cuia hueaj gutaꞌ qui queëquëꞌ. Gulaguel‑lëꞌë caꞌ lariꞌ gxoa yenëꞌ Jesús, atiꞌ lariꞌ naꞌ cutu nadía, san nadúb tuz ca nadúb. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Niꞌr bönniꞌ naꞌ rjaquëꞌ gdil‑l glë lzaꞌquëꞌ tuëꞌ yetúëꞌ, taꞌnë́ꞌ: ―Cutu gchúguruꞌ lei, san dxiꞌar gac uyuruꞌ le gac bëꞌ quië gnö́ziruꞌ nuzxa gaqui qui. Cni guc, butság ca nayúj lu guich laꞌy, rna: Gulaguisiëꞌ qui queëquëꞌ lariꞌ nacuaꞌ, Len qui lariꞌ quiaꞌ guluyúëꞌ le nac bëꞌ. Cni glunëꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gulacuaꞌnu gal‑laꞌ ga naꞌ dëꞌë Jesús lëꞌi yag cruz xnëꞌë, len ngul zxilnu xnëꞌë, len María, ngul queëꞌ Cleofas, len María Magdalena. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Catiꞌ bléꞌinëꞌ‑nu xnëꞌë Jesús, len bléꞌinëꞌ caꞌ niꞌ bönniꞌ usë́d queëꞌ naꞌ nadxiꞌinëꞌ, gudxëꞌ‑nu xnëꞌë: ―Naꞌa, naꞌ zoëꞌ zxiꞌnuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Niꞌr gudxëꞌ bönniꞌ usë́d queëꞌ naꞌ: ―Naꞌ zoanu xnaꞌu. Laꞌ dza niꞌz benëꞌ ga yajsoanu lidxëꞌ bönniꞌ usë́d naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gdöd ni, le nözcznëꞌ Jesús yúguꞌtë chböa budzág lahui, len quië utság le nayúj lu guich laꞌy, gnëꞌ: ―Rbidxaꞌ nis. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dë niꞌ tu zxigaꞌ yudz nup zi. Niꞌr bönniꞌ naꞌ rjaquëꞌ gdil‑l guluguiꞌjëꞌ nup zi naꞌ tu le blul rzxup nis, atiꞌ guluzóëꞌ lei lahui gui, len guludë́ꞌë lei ruꞌë Jesús quië xupëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Budx guꞌë Jesús nup zi naꞌ, gnëꞌ: ―Chnactë. Niꞌr buzö́tj icjëꞌ. Burujtë böꞌ nacczëꞌ, gutiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Niꞌr, le nac dza ziꞌa gdxin Lni Pascua naꞌ, len le cural‑laꞌ lugáꞌn nup natgac lë́ꞌigac yag cruz catiꞌ nac dza laꞌy quequëꞌ, le nac tu dza laꞌy zxöntë, qui lë ni naꞌ glátaꞌyuëꞌ lahuëꞌ Pilato bönniꞌ judío guiëꞌ bönniꞌ rjaquëꞌ gdil‑l tsajtitsjquëꞌ zxgatsjquëꞌ bönniꞌ daꞌquëꞌ lë́ꞌigac yag cruz, len luzötjëꞌ lequëꞌ lë́ꞌigac yag cruz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Qui lë ni naꞌ gulabiguëꞌë niꞌ bönniꞌ rjaquëꞌ gdil‑l, atiꞌ gulaguitsjëꞌ zxgatsjëꞌ bönniꞌ ziꞌal, len lëzcaꞌ cni glunëꞌ queëꞌ yetúëꞌ bönniꞌ naꞌ dáꞌlenëꞌ Jesús lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Catiꞌ guladxinëꞌ ga naꞌ dëꞌë Jesús len gulaléꞌinëꞌ chnatiëꞌ, cutu gulaguitsjëꞌ zxgatsjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Niꞌr bunë́ꞌë yag tuchiꞌ cuit lëꞌë Jesús tuëꞌ bönniꞌ naꞌ rijëꞌ gdil‑l, atiꞌ laꞌ brujtë rön len nis. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nedaꞌ, Juan, bléꞌidaꞌ lë ni, len runaꞌ lnaꞌ lau qui, atiꞌ le runaꞌ lnaꞌ lau nac gdutë li. Nözczdaꞌ ruꞌa didzaꞌ gdutë li, quië tséjlëꞌliꞌ caꞌ lbiꞌiliꞌ ca nac queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Glac yuguꞌ lë ni quië butság le nayúj lu guich laꞌy, rna: “Cutu gatsj nitú dxit yuꞌë.” ");
INSERT INTO zsrNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yetú le nayúj caꞌ lu guich rna cni: “Luyúëꞌ bönniꞌ naꞌ gulunë́ꞌë lëꞌ yag tuchiꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gdöd guc yúguꞌtë lë ni, gyijëꞌ José, bönniꞌ yödz Arimatea, len dëꞌë Jesús, san bagachiꞌz le rádxinëꞌ yuguꞌ bönniꞌ judío uná bëꞌ, atiꞌ gnabëꞌ lahuëꞌ Pilato guꞌë lëꞌ latj uꞌë Jesús. Pilato bëꞌë lëꞌ latj. Niꞌr bdxinëꞌ José ga naꞌ dëꞌë Jesús lëꞌi yag cruz, atiꞌ buꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Lëzcaꞌ bdxinëꞌ niꞌ Nicodemo, bönniꞌ naꞌ gyijëꞌ ziꞌal yajyúëꞌ Jesús chdzöꞌl, nuꞌë tu le nutsiꞌi nör slaꞌ qui mirra, len tu le rlaꞌ zxix, nac ca tu gayuáꞌ guia. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Niꞌr gulaguel‑lëꞌë Jesús José len Nicodemo naꞌ, len guluchö́linëꞌ Lëꞌ yuguꞌ láriꞌdauꞌ atiꞌ gulaguꞌë lahuil lë naꞌ nutsiꞌi nör slaꞌ qui mirra len le rlaꞌ zxix, glunëꞌ ca nalëbcnëꞌ tunëꞌ bönniꞌ judío catiꞌ tuꞌcachëꞌë bönniꞌ nat. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gal‑laꞌ ga naꞌ guludë́ꞌë Jesús lëꞌi yag cruz dë tu laꞌ yël, atiꞌ gatsj lahuiꞌl laꞌ yël naꞌ zoa tu yeru ba cub nadj lëꞌi guiꞌa guiöj, yeru ba naꞌ nutu nu taꞌgüiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lu yeru ba naꞌ gulaguꞌë Jesús le dë gal‑laꞌz yeru ba naꞌ len le nac dza tuꞌpë́ꞌë qui Lni Pascua bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Catiꞌ chnac zildauꞌ dza domingo, niꞌ nac chul, gyeajnu María Magdalena raꞌ yeru ba naꞌ, atiꞌ bléꞌinu chnadúa guiöj blag naꞌ buséyj ga nu ryaz yeru ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Niꞌr jaréluꞌnu böajnu ga zoëꞌ Simón Pedro, dzaguëꞌ lëꞌ yetúëꞌ bönniꞌ usë́d, bönniꞌ naꞌ Jesús nadxiꞌinëꞌ lëꞌ, atiꞌ rënu lequëꞌ: ―Gulubijëꞌ Xanruꞌ yeru ba niꞌ, len cutu nö́zituꞌ gazx gulaguꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Niꞌr gularujëꞌ Pedro len yetúëꞌ bönniꞌ usë́d naꞌ, zjaquëꞌ raꞌ yeru ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tsazxö́n taꞌxítiꞌë gropëꞌ, san yetúëꞌ bönniꞌ usë́d naꞌ jaréluꞌrëꞌ gxítiꞌë ca Pedro, atiꞌ ziꞌal lëꞌ bdxinëꞌ raꞌ yeru ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Byechuëꞌ len buyúëꞌ lu yeru ba naꞌ, len bléꞌinëꞌ yuguꞌ láriꞌdauꞌ naꞌ gularöli‑nëꞌ Jesús, nacuáꞌ niꞌ, san cutu gyaziëꞌ yeru ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Niꞌr bdxinëꞌ Simón Pedro cúdzuꞌlëꞌ yetúëꞌ bönniꞌ usë́d naꞌ, atiꞌ gyaziëꞌ lëꞌ yeru ba naꞌ, len bléꞌinëꞌ láriꞌdauꞌ naꞌ nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lëzcaꞌ bléꞌinëꞌ láriꞌdauꞌ naꞌ gulaxóëꞌ icjëꞌ Jesús, cutu dëlen yezicaꞌ láriꞌdauꞌ naꞌ, san tslaꞌl nudúb quizi. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Niꞌr gyaziëꞌ caꞌ yetúëꞌ bönniꞌ usë́d naꞌ bdxinëꞌ ziꞌal raꞌ yeru ba naꞌ, len bléꞌinëꞌ ca naꞌ nac, atiꞌ gyejlëꞌë didzaꞌ bëꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cni guc, le cutu taꞌyéjniꞌnidëꞌ le nayúj lu guich laꞌy ca run bayúdx gac queëꞌ Jesús, ubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Niꞌr gropëꞌ bönniꞌ usë́d naꞌ yhuöjquëꞌ lidxquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bugaꞌnnu María niꞌl raꞌ yeru ba naꞌ, rbödxnu. Tsal niꞌ rbödxnu, byéchunu, buyunu lu yeru ba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Niꞌ bléꞌinu chopëꞌ gbaz laꞌy queëꞌ Dios, nácuquëꞌ lariꞌ chguich. Röꞌquëꞌ niꞌ, tuëꞌ icjl ba naꞌ, len yetúëꞌ xniꞌl ba naꞌ ga niꞌ gulaguꞌë Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tëꞌ lënu gbaz laꞌy naꞌ, taꞌnë́ꞌ: ―Nguldauꞌ, ¿bizx quië rbödxuꞌ? Rënu lequëꞌ: ―Le guluúꞌë Xanaꞌ, len cutu nözdaꞌ gazx gulaguꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Catiꞌ budx gnanu cni, bueycjnu len bléꞌinu‑nëꞌ Jesús, zoëꞌ niꞌ, san cutu ráquibeꞌinu Jesús naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Niꞌr Jesús gudxëꞌ‑nu: ―Nguldauꞌ, ¿bizx quië rbödxuꞌ? ¿Nuzxa ruguiljuꞌ? Le ráquinu naquëꞌ Lëꞌ bönniꞌ run chiꞌë laꞌ yël naꞌ, rënu Lëꞌ: ―Bönniꞌ, chquiꞌ liꞌ buꞌu‑nëꞌ, gdixjöiꞌ nedaꞌ gazx gluꞌu‑nëꞌ, atiꞌ nedaꞌ uꞌa‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Niꞌr Jesús gudxëꞌ‑nu: ―María. Niꞌr bueycjnu, len lu didzaꞌ hebreo rënu Lëꞌ: ―Raboni. Didzaꞌ ni rna: “Bönniꞌ Usëdi quiaꞌ”. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús rëꞌ‑nu: ―Cutu canuꞌ nedaꞌ, le cutu ruhuë́pidaꞌ ga zoëꞌ Xuzaꞌ. Naꞌa, gyeaj ga nacuꞌë böchiꞌ lzaꞌa, atiꞌ yjödx‑quëꞌ: “Cni rnëꞌ Jesús: Huëpaꞌ ga zoëꞌ Xuzaꞌ, naquëꞌ caꞌ Xuzliꞌ. Naquëꞌ Dios quiaꞌ, len Dios queëliꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Niꞌr gyeajnu María Magdalena naꞌ, yajtíxjöiꞌnu bönniꞌ usë́d queëꞌ Jesús chbléꞌinu‑nëꞌ Xanruꞌ len ca nac didzaꞌ naꞌ gudxëꞌ‑nu. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Catiꞌ chgul laꞌ dza naꞌz, le nac dza domingo, nudubquëꞌ bönniꞌ usë́d queëꞌ Jesús, atiꞌ nayéyj yuꞌu ga naꞌ nacuꞌë le tádxinëꞌ yuguꞌ bönniꞌ judío uná bëꞌ. Niꞌr buluíꞌ lahuëꞌ Jesús gatsj lahuiꞌl ga naꞌ nacuꞌë, len rëꞌ lequëꞌ: ―Gul‑zóa dxi ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Catiꞌ budx gudxëꞌ lequëꞌ didzaꞌ ni, buluiꞌinëꞌ lequëꞌ nëꞌë len cuit lëꞌë. Niꞌr tuꞌdzijnëꞌ bönniꞌ usë́d naꞌ le tuꞌléꞌinëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Niꞌr rëꞌ lequëꞌ leyúbl Jesús, rnëꞌ: ―Gul‑zóa dxi ládxiꞌliꞌ. Ca benëꞌ Xuzaꞌ, bsölëꞌë nedaꞌ, lëzcaꞌ cni rsölaꞌa lbiꞌiliꞌ tsjenliꞌ xchinaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Catiꞌ budx gnëꞌ cni, bulubëꞌ lauquëꞌ len rëꞌ lequëꞌ: ―Gul‑síꞌ lu naꞌliꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nútiꞌtëz nu unít lauliꞌ, nu naꞌ ben dul‑laꞌ, chyuꞌu yöl‑laꞌ runít lau qui, atiꞌ nútiꞌtëz nu cutu unít lauliꞌ lei, nagáꞌn dul‑laꞌ qui nu naꞌ nun dul‑laꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Cutu zóalenëꞌ lequëꞌ Tomás catiꞌ duyúëꞌ lequëꞌ Jesús. Naquëꞌ Tomás tuëꞌ bönniꞌ chinnuëꞌ niꞌ, len tuꞌë caꞌ lëꞌ Bönniꞌ Cuach. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Gdöd niꞌ glëꞌ Tomás yezícaꞌrëꞌ bönniꞌ usë́d naꞌ, taꞌnë́ꞌ: ―Chbléꞌituꞌ‑nëꞌ Xanruꞌ. Tomás rëꞌ lequëꞌ: ―Chquiꞌ cutu gléꞌidaꞌ nëꞌë ga bnëꞌ bdidj, len gnëꞌa xbönniꞌ naꞌa ga naꞌ bnëꞌgac bdidj naꞌ, len gnëꞌa naꞌa cuit lëꞌë ga naꞌ bnëꞌ yag tuchiꞌ, cutu caꞌ tséjlëꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Catiꞌ chgdöd yexunuꞌ dza, nudubquëꞌ leyúbl lu yuꞌu bönniꞌ usë́d naꞌ, atiꞌ zóalenëꞌ lequëꞌ Tomás naꞌ. Zal‑laꞌ nayéyj yuꞌu ga naꞌ nacuꞌë, buluíꞌ lahuëꞌ Jesús gatsj lahuiꞌl ga naꞌ nacuꞌë, len rëꞌ lequëꞌ: ―Gul‑zóa dxi ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Niꞌr Jesús rëꞌ Tomás naꞌ: ―Bnëꞌ ni xbönniꞌ naꞌu, len byu naꞌa ni. Bnëꞌ naꞌu cuit lëꞌa ni, len cutur gac chop ladxuꞌu, san gyejlëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Niꞌr bubiꞌë didzaꞌ Tomás, rëꞌ Lëꞌ: ―Xánaꞌdauꞌ, len Dios quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús rëꞌ lëꞌ: ―Tomás, le bléꞌinuꞌ nedaꞌ, réjlëꞌu. Bicaꞌ ba nup niꞌ laꞌyejlëꞌ nedaꞌ zal‑laꞌ cutu laꞌleꞌi nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Benëꞌ Jesús zianr caꞌ yöl‑laꞌ huac lauquëꞌ bönniꞌ usë́d queëꞌ, le cunayujgac lu guich ni. ");
INSERT INTO zsrNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yuguꞌ lë ni nuzujaꞌ lu guich quië tséjlëꞌliꞌ naquëꞌ Jesús Bönniꞌ naꞌ ruꞌë Dios lëꞌ Cristo, Zxiꞌnëꞌ Dios, len catiꞌ tséjlëꞌliꞌ, gataꞌ queëliꞌ yöl‑laꞌ naꞌbán gdu le réjlëꞌliꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Gdöd guc lë ni, leyúbl buluíꞌ lahuëꞌ Jesús lauquëꞌ bönniꞌ usë́d queëꞌ ga nac raꞌ nis zxön qui Tiberias, atiꞌ cni guc ca naꞌ buluíꞌ lahuëꞌ lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nudubquëꞌ Simón Pedro, len Tomás, bönniꞌ naꞌ tuꞌë caꞌ lëꞌ Bönniꞌ Cuach, len Natanael, bönniꞌ yödz Caná qui luyú Galilea, len yuguꞌ bönniꞌ zxiꞌnëꞌ Zebedeo, len yechopëꞌ caꞌ bönniꞌ usë́d queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro rëꞌ lequëꞌ: ―Tsijaꞌ tsajxönaꞌ‑baꞌ böl. Tëꞌ lëꞌ yezícaꞌrëꞌ, taꞌnë́ꞌ: ―Huazáꞌlentuꞌ caꞌ liꞌ. Niꞌr yjaquëꞌ len gulabenëꞌ tu lëꞌi bárcodauꞌ, atiꞌ rël niꞌ nitubaꞌ böl cutu gulazönëꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Catiꞌ chzaꞌ reníꞌ, yajsóëꞌ Jesús luyú raꞌ nis naꞌ, san cutu táquibeꞌinëꞌ Jesús naꞌ bönniꞌ usë́d queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Niꞌr Jesús rëꞌ lequëꞌ: ―Zxíꞌnaꞌdauꞌ, ¿naruꞌ cudeybaꞌ latiꞌ böl queëliꞌ? Gulubiꞌë didzaꞌ, tëꞌ Lëꞌ: ―Nitubaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑chílj tslaꞌa yubél barco yöxj böl queëliꞌ atiꞌ sö́ngacliꞌ‑baꞌ. Niꞌr gulachiljëꞌ lei, atiꞌ cutur guc lubijëꞌ lei, le naguírabaꞌ böl lëꞌi yöxj böl naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Niꞌr rëꞌ Pedro bönniꞌ usë́d naꞌ nadxiꞌinëꞌ lëꞌ Jesús, rnëꞌ: ―Xanruꞌ naꞌ. Catiꞌ byönnëꞌ Simón Pedro, “Xanruꞌ naꞌ”, böacuëꞌ lariꞌ gucuëꞌ, le nagǘëꞌ lei ziꞌal, atiꞌ gyaziëꞌ lu nis. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Guladxinëꞌ yezícaꞌrëꞌ bönniꞌ usë́d naꞌ, tuꞌsë́ꞌë barco naꞌ, zunaꞌyjquëꞌ yöxj ga naꞌ dzöꞌbaꞌ böl, le cutu nac ziꞌtuꞌ ga dë luyú bidx, nacz ca tu gayuáꞌ lagaꞌ níꞌaruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Catiꞌ guladxinëꞌ luyú bidx naꞌ, gulaléꞌinëꞌ röꞌ niꞌ guiꞌ yal, len zxoabaꞌ lahui tubaꞌ böl, len dë caꞌ niꞌ yöt. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús rëꞌ lequëꞌ: ―Gul‑dguáꞌ‑baꞌ ni böl naꞌ ziꞌa gzxö́ngacliꞌ‑baꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Grenëꞌ Pedro lëꞌi barco naꞌ, guꞌyjëꞌ yöxj naꞌ zacaꞌ luyú bidx, nadzáꞌgacrbaꞌ böl zxön, gdu tu gayuáꞌ yu chíꞌinuʉ́nbaꞌ. Zal‑li naccbaꞌ böl zian, cutu brözaꞌ yöxj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Niꞌr Jesús rëꞌ lequëꞌ: ―Gul‑dá gáguliꞌ. Cutu burúguinëꞌ gnabnëꞌ Lëꞌ nitúëꞌ bönniꞌ usë́d naꞌ, cugnë́ꞌ: “¿Nuzxa Liꞌ?” Nö́zgaccznëꞌ naquëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Niꞌr gbiguëꞌë Jesús len gdel‑lëꞌë yöt naꞌ lencaꞌ böl naꞌ, atiꞌ bëꞌë quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lë ni nac le bunn lzu buluíꞌ lahuëꞌ Jesús lauquëꞌ bönniꞌ usë́d queëꞌ gdöd bubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Catiꞌ budx glahuëꞌ, Jesús rëꞌ Simón Pedro: ―Simón, zxiꞌnëꞌ Jonás, ¿naruꞌ nadxiꞌirnuꞌ nedaꞌ ca nadxiꞌicnëꞌ nedaꞌ bönniꞌ ni? Bubiꞌë didzaꞌ Pedro, rëꞌ Lëꞌ: ―Ja, Xan. Liꞌ nözcznuꞌ rdzag ladxaꞌa Liꞌ. Jesús rëꞌ lëꞌ: ―Bgagu yuguꞌ böꞌcuꞌ zxílaꞌdauꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús rëꞌ lëꞌ le buróp lzu, rnëꞌ: ―Simón, zxiꞌnëꞌ Jonás, ¿naruꞌ nadxiꞌinuꞌ nedaꞌ? Bubiꞌë didzaꞌ Pedro, rëꞌ Lëꞌ: ―Ja, Xan. Liꞌ nözcznuꞌ rdzag ladxaꞌa Liꞌ. Jesús rëꞌ lëꞌ: ―Bgagu yuguꞌ böꞌcuꞌ zxilaꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús rëꞌ lëꞌ le bunn lzu: ―Simón, zxiꞌnëꞌ Jonás, ¿ba rdzag ladxuꞌu nedaꞌ? Buiꞌnnëꞌ Pedro le chbunn lzu gnabi yudxnëꞌ lëꞌ, gnëꞌ: “¿Ba rdzag ladxuꞌu nedaꞌ?” Bubiꞌë didzaꞌ Pedro, rëꞌ Lëꞌ: ―Xan, yúguꞌtë nözcznuꞌ Liꞌ. Nöznuꞌ rdzag ladxaꞌa Liꞌ. Jesús rëꞌ lëꞌ: ―Bgagu yuguꞌ böꞌcuꞌ zxilaꞌ quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Le nactë rëpaꞌ liꞌ, catiꞌ niꞌ nacuꞌ raꞌbandauꞌ, racz quiuꞌ bugacu cuinuꞌ, len ca gnaz quiuꞌ gdauꞌ. Catiꞌ gguluꞌ, ulí naꞌu, atiꞌ nu yubl ugacu liꞌ lariꞌ, len gchëꞌ liꞌ ga niꞌ cutu guëꞌnnuꞌ tsijuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yuguꞌ didzaꞌ ni bëꞌë Jesús nac bëꞌ nac gatiëꞌ Pedro, tsajtë́ꞌë lëꞌi yag cruz, quië gac yöl‑laꞌ ba queëꞌ Dios. Catiꞌ budx gnëꞌ cni Jesús, gnëꞌ caꞌ yetú: ―Gdaꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bueycjëꞌ Pedro len bléꞌinëꞌ zajnauëꞌ lequëꞌ bönniꞌ usë́d naꞌ Jesús nadxiꞌinëꞌ lëꞌ. Naquëꞌ bönniꞌ usë́d naꞌ gröꞌë cuit lëꞌë Jesús catiꞌ niꞌ glahuëꞌ, len gudxëꞌ Jesús: “Xan, ¿nuzxa naꞌ udö́d Liꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Catiꞌ bléꞌinëꞌ lëꞌ Pedro, rëꞌ Jesús: ―Xan, ¿bizxa gunëꞌ bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús rëꞌ lëꞌ: ―Chquiꞌ rëꞌndaꞌ ugaꞌnëꞌ bönniꞌ ni ga gdxinr dza huödaꞌ, cutu ral‑laꞌ cöꞌu baguíꞌi. Gdaꞌ nedaꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gzë didzaꞌ ni ga nacuꞌë bö́chiꞌruꞌ taꞌyejlëꞌë Cristo. Táquinëꞌ cutu gatiëꞌ bönniꞌ usë́d naꞌ. Cutu gudxëꞌ lëꞌ Jesús cutu gatiëꞌ, san cni gnëꞌ: “Chquiꞌ rëꞌndaꞌ ugaꞌnëꞌ bönniꞌ ni ga gdxinr dza huödaꞌ, cutu ral‑laꞌ cöꞌu baguíꞌi.” ");
INSERT INTO zsrNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Bönniꞌ usë́d ni nacaꞌ nedaꞌ, Juan. Runaꞌ lnaꞌ lau quegac lë ni, len nuzujaꞌ lu guich yuguꞌ lë ni, atiꞌ nö́ziliꞌ nac gdutë li le runaꞌ lnaꞌ lau. ");
INSERT INTO zsrNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zianr caꞌ le benëꞌ Jesús. Chquiꞌ nu uzúj leygac lu guich tu tu, rsacaꞌ quiaꞌ yödzlyú ni cutu gaqui laꞌcuáꞌ guich naꞌ ral‑laꞌ nu uzúj. Caꞌ gac.");
INSERT INTO zsrNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Catiꞌ buzujaꞌ quiuꞌ lu guich ziꞌal, liꞌ, Teófilo, nedaꞌ, Lucas, buzujaꞌ lu guich yúguꞌtë le gzu lahuëꞌ runëꞌ Jesús len rusëdnëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ga bdxintë dza buëpëꞌ yehuaꞌ yubá. Catiꞌ ziꞌa huëpëꞌ yehuaꞌ yubá Jesús, dzaguëꞌ Lëꞌ Dios Böꞌ Laꞌy, gna bëꞌë ca ral‑laꞌ lunëꞌ gbaz queëꞌ, bönniꞌ naꞌ gröczëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gdöd gzxacaꞌ gdiꞌë Jesús, gutiëꞌ. Niꞌr bubanëꞌ len buluíꞌ lahuëꞌ lauquëꞌ gbaz queëꞌ naꞌ. Buluiꞌinëꞌ lequëꞌ zian le glac bëꞌ zoëꞌ nabanëꞌ, le cugác nu táꞌbagaꞌ. Zian lzu buluíꞌ lahuëꞌ lauquëꞌ gdu ca choaꞌ dza, len bë́ꞌlenëꞌ lequëꞌ didzaꞌ ca rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Catiꞌ niꞌ nacuꞌë tsazxö́n, gna béꞌinëꞌ lequëꞌ culuzë́ꞌë Jerusalén. Gudxëꞌ lequëꞌ Jesús, rnëꞌ: ―Gul‑cö́z niꞌ le gzxiꞌ lu nëꞌë gsölëꞌë queëliꞌ Xuzaꞌ ca naꞌ chgdíxjöiꞌczdaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gnëꞌ caꞌ: ―Le nactë buquilëꞌ bunách nis Juan lu nis, atiꞌ cutu tseytsqui gac queëliꞌ le ruluíꞌ yöl‑laꞌ rdil nis ni, dusóalenëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Niꞌr gulanabnëꞌ Jesús bönniꞌ taꞌyejlëꞌë Lëꞌ nudubquëꞌ niꞌ, taꞌnë́ꞌ: ―Xan, ¿naruꞌ gunuꞌ ga laꞌná bëꞌ leyúbl bunách Israel dza ni zoaruꞌ naꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús gudxëꞌ lequëꞌ: ―Cutu naqui queëliꞌ gnö́ziliꞌ bizxa dza o bizxa dzöꞌ gunëꞌ Dios Xuz le nuzóëꞌ lu naꞌczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Siꞌliꞌ yöl‑laꞌ huac catiꞌ guidëꞌ Dios Böꞌ Laꞌy dusóalenëꞌ lbiꞌiliꞌ. Niꞌr gunliꞌ lnaꞌ lau quiaꞌ nedaꞌ lu yödz Jerusalén, len gdu luyú Judea, len luyú Samaria, len ga gdxíntëliꞌ gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Catiꞌ budx bë́ꞌlenëꞌ lequëꞌ didzaꞌ ni, tsal niꞌ tuꞌyuzëꞌ caꞌ Lëꞌ, laꞌ buëptëꞌ xtsaꞌ ga röꞌ böaj le bucachiꞌ Lëꞌ, atiꞌ cutur gulaléꞌinëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tsal niꞌ tuꞌyúëꞌ luzxbál catiꞌ niꞌ buëpëꞌ Jesús, gululuíꞌ lauquëꞌ ga naꞌ nacuꞌë chopëꞌ gbaz laꞌy, nácuquëꞌ lariꞌ chguichdauꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Glëꞌ lequëꞌ chopëꞌ ni, taꞌnë́ꞌ: ―Bönniꞌ Galilea, ¿bizx quië ruyuliꞌ luzxbál? Lëczëꞌ Jesús ni ziꞌa gzëꞌë ga zoaliꞌ, buëpëꞌ yehuaꞌ yubá, lëzcaꞌ cni huödëꞌ leyúbl ca naꞌ chbléꞌiliꞌ‑nëꞌ zhuöjëꞌ yehuaꞌ yubá. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Niꞌr gulazë́ꞌë guíꞌadauꞌ naꞌ nazíꞌ lei Guiꞌa Ga Röꞌgac Yag Olivo, yhuöjquëꞌ Jerusalén. Dë gal‑laꞌz ga dë Jerusalén guíꞌadauꞌ ni, tsca naziꞌquëꞌ latj taꞌzë́ꞌë dza laꞌy quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Catiꞌ guludxinëꞌ yödz niꞌ, gulabenëꞌ ga nac buróp cuia lu yuꞌu, ga niꞌ taꞌcuꞌë Pedro len Jacobo len Juan len Andrés len Felipe len Tomás len Bartolomé len Mateo len Jacobo, zxiꞌnëꞌ Alfeo, len Simón, bönniꞌ naꞌ ruiꞌ ladxëꞌë ladzëꞌ, len Judas, böchëꞌë Jacobo. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tsazxö́n tuꞌlidzëꞌ Dios yúguꞌtë bönniꞌ ni, atiꞌ nunquëꞌ lequëꞌ tsazxö́n yuguꞌ böchëꞌë Jesús, len María, xnëꞌë Jesús, len yelaꞌcnu ngul caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Laꞌ dza naꞌz gzuinëꞌ Pedro gatsj lahuiꞌl ga nacuꞌë böchiꞌ lzaꞌruꞌ naꞌ taꞌyejlëꞌë Cristo. Glac gdu ca xoplalj bunách nup nudubgac niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Gudxëꞌ lequëꞌ Pedro, rnëꞌ: ―Böchiꞌ lzaꞌadauꞌ. Ben bayúdx butság le nayúj lu guich laꞌy, ca naꞌ gnëꞌ zíꞌatël Dios Böꞌ Laꞌy, le buzujëꞌ lu guich David, ca guc queëꞌ Judas, bönniꞌ naꞌ bchëꞌë nup niꞌ gulazö́n Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Gbáblenëꞌ rëꞌu Judas naꞌ, len bénlenëꞌ rëꞌu tsazxö́n dxin ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Gulaziꞌnëꞌ tu laꞌ yël lazxj qui döꞌ naꞌ biꞌë bönniꞌ ni. Gbixëꞌ brözaꞌ lëꞌë Judas ni, atiꞌ gularúj yúguꞌtë le dzöꞌ lëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Catiꞌ gulayöni lë ni bunách nacuáꞌ Jerusalén, gluꞌë lei laꞌ yël naꞌ Acéldama, tu didzaꞌ hebreo le rna lu didzaꞌ xidzaꞌ: “Laꞌ Yël Qui Rön”. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Cni guc queëꞌ Judas, ca naꞌ nayúj lu guich laꞌy nazíꞌ lei Salmos, le rna: Ugáꞌn caꞌz lidxëꞌ, Len cutu gdzöl nu soa yuꞌu naꞌ. Rna caꞌ: Nu yubl tsaz xlatjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Run bayúdx naꞌa cöruꞌ‑nëꞌ bönniꞌ gunëꞌ rëꞌu tsazxö́n quië gunëꞌ lnaꞌ lau queëꞌ Jesús, ca guc, bubanëꞌ lu yöl‑laꞌ gut. Ral‑laꞌ gaquëꞌ bönniꞌ nutsëꞌë ladj bönniꞌ niꞌ gulacuáꞌlenëꞌ rëꞌu dza niꞌtë catiꞌ niꞌ gdálenëꞌ rëꞌu Xanruꞌ Jesús, gulazú lauquëꞌ nacuáꞌlenëꞌ rëꞌu catiꞌ niꞌ buquilëꞌ bunách nis Juan, ga bdxintë dza buëpëꞌ Jesús yehuaꞌ yubá, gzëꞌë ga zoaruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Niꞌr gululuꞌë chopëꞌ, José len Matías. José naꞌ lëꞌ caꞌ Barsabás, len zoa yetú lëꞌ Justo. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Niꞌr gululidzëꞌ Dios, taꞌnë́ꞌ: ―Xantuꞌ Dios, núnbëꞌczuꞌ icj ládxiꞌdauꞌgac yúguꞌtë bunách. Buluíꞌi netuꞌ nulquëꞌ chopëꞌ ni chgröczuꞌ Liꞌ ");
INSERT INTO zsrNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","quië tsaziëꞌ lu dxin ni quië gaquëꞌ gbaz quiuꞌ, tsaziëꞌ xlatjëꞌ Judas, bönniꞌ niꞌ bnitiëꞌ xlatjëꞌ le benëꞌ dul‑laꞌ, atiꞌ gyijëꞌ xlatjczëꞌ latj chul. ");
INSERT INTO zsrNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Niꞌr guluzujëꞌ yuguꞌ lu guich laquëꞌ, tu queëꞌ José len yetú queëꞌ Matías. Gulugútsiꞌnëꞌ lzaꞌgac len gulubijëꞌ tu, atiꞌ bruj le nayúj lëꞌ Matías. Cni guc, gbáblenëꞌ yechineajëꞌ gbaz queëꞌ Cristo Matías naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Catiꞌ chbdxin dza Pentecostés, tsazxö́n nudubquëꞌ yúguꞌtë bönniꞌ taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tu tsalz byön bö bruj luzxbá, byön ca ryön catiꞌ reycj böꞌ bdunuꞌ, atiꞌ byön gdutë lu yuꞌu ga naꞌ röꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Gululuíꞌ lahui lauquëꞌ lu böꞌz yuguꞌ blul guiꞌdauꞌ, atiꞌ gulaguís qui queëquëꞌ, yajsóalengac lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dusóalenëꞌ yúguꞌtëꞌ Dios Böꞌ Laꞌy, atiꞌ gulazú lauquëꞌ tuꞌë didzaꞌ yubl, tsca nac le bëꞌë qui queëquëꞌ Dios Böꞌ Laꞌy luꞌë didzaꞌ yubl naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nacuꞌë Jerusalén dza naꞌ bönniꞌ judío, nacquëꞌ bönniꞌ taꞌyíj ládxiꞌquëꞌ Dios, len zaꞌquëꞌ narujquëꞌ yúguꞌtë yödz gdu yödzlyú ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Catiꞌ gulayönnëꞌ bö naꞌ, guludubëꞌ bönniꞌ zian, atiꞌ szxöni gulaböꞌë baguíꞌi, le gulayönnëꞌ, ca nac xtídzaꞌquëꞌ qui queëquëꞌ, tuꞌë didzaꞌ bönniꞌ naꞌ taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gulanáꞌ badxëꞌ yúguꞌtëꞌ, len gulubannëꞌ, taꞌnë́ꞌ: ―Gul‑yutscaꞌ. ¿Naruꞌ clëg bönniꞌ Galilea yúguꞌtë bönniꞌ ni tuꞌë didzaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nacxcz nac ryö́niruꞌ tuꞌë xtídzaꞌruꞌ ca nac didzaꞌ ruiꞌruꞌ tu turuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Rëꞌu ni nacruꞌ bönniꞌ zian yödz, bönniꞌ narujquëꞌ luyú Partia, len luyú Media, len luyú Elam, len luyú Mesopotamia, len luyú Judea, len luyú Capadocia, len luyú Ponto, len luyú Asia, ");
INSERT INTO zsrNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","len luyú Frigia, len luyú Panfilia, len luyú Egipto, len luyú África, le nacr ziꞌtuꞌ ga zoa luyú Cirene. Lëzcaꞌ nacuꞌë ni bönniꞌ yödz Roma. Laꞌquëꞌ nacquëꞌ bönniꞌ judío len yelaꞌquëꞌ nazíꞌ lu naꞌquëꞌ le taꞌyejlëꞌë Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Lëzcaꞌ nacuꞌë ni bönniꞌ narujquëꞌ Creta, len luyú Arabia. Ryö́niruꞌ tuꞌë didzaꞌ ruiꞌruꞌ qui queëruꞌ, taꞌguíxjöꞌë yuguꞌ le zxön benëꞌ Dios, le run ga rubániruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Cni guc, gulubannëꞌ yúguꞌtëꞌ, len szxöni gulaböꞌë baguíꞌi. Glë lzaꞌquëꞌ tuëꞌ yetúëꞌ, taꞌnë́ꞌ: ―¿Bizxa caz lë ni? ");
INSERT INTO zsrNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gulutitjëꞌ laꞌquëꞌ, taꞌnë́ꞌ: ―Taꞌzúdxinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Niꞌr Pedro gzuílenëꞌ yechineajëꞌ gbaz naꞌ nasölëꞌë Cristo, atiꞌ gzu lahuëꞌ ruꞌë zidzj didzaꞌ, rëꞌ lequëꞌ: ―Lbiꞌiliꞌ, bönniꞌ Judea, len yúguꞌtëliꞌ zoaliꞌ Jerusalén. Lë ni ral‑laꞌ gnö́ziliꞌ. Gul‑zë́ nagliꞌ le gyëpaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Netuꞌ ni cutu rzúdxituꞌ ca naꞌ ráquiliꞌ lbiꞌiliꞌ, le ni zoaruꞌ ziꞌa gal‑laꞌ xsil, atiꞌ nutu nu rzudxi hora cni. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lë ni nac le gnëꞌ Joel, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cni rnëꞌ Dios: Lë ni le gac dza tsajséytëgac. Gsölaꞌa Böꞌ Laꞌy quiaꞌ Tsajsóalenëꞌ yúguꞌtë bunách. Luiꞌbiꞌ didzaꞌ uláz quiaꞌ zxiꞌnliꞌ, bönniꞌ len ngul. Laꞌléꞌibiꞌ biꞌi raꞌbán le uluꞌa lahui, Atiꞌ laꞌneynëꞌ yël bönniꞌ gul. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Catiꞌ gdxin dza niꞌ quisiaꞌ Böꞌ Laꞌy quiaꞌ Tsajsóalenëꞌ huen dxin quiaꞌ, bönniꞌ len ngul, Atiꞌ luꞌë didzaꞌ uláz quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Uluꞌa luzxbá xtsaꞌ le lun ga lubani bunách, Atiꞌ yödzlyú uluꞌa le lac bëꞌ, Rön len guiꞌ, len dzön ca böaj. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gchul gbidz Atiꞌ gac xna beoꞌ ca nac rön. Cni gac catiꞌ ziꞌa gdxin dza niꞌ chbuluꞌë Dios. Gac dza niꞌ ca gatga rléꞌiruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lulá yúguꞌtë nup niꞌ lulídz Lëꞌ Xanruꞌ, Lu yöl‑laꞌ rejlëꞌ quequëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Gul‑zë́ nagliꞌ lë ni gyëpaꞌ lbiꞌiliꞌ, bönniꞌ Israel. Dioscz benëꞌ ba laꞌn ga zoaliꞌ Jesús, bönniꞌ Nazaret. Dios bëꞌë Lëꞌ latj benëꞌ le tun ga rubániruꞌ, yuguꞌ yöl‑laꞌ huac, len le tac bëꞌ. Yúguꞌtë lë naꞌ benëꞌ Dios lu nëꞌë Jesús, ca naꞌ chnö́ziczliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lëzcaꞌ cni, Dios bëꞌë latj nu budö́d Jesús lu naꞌliꞌ. Cni guc, ca naꞌ chgna ladxëꞌë Dios gunëꞌ, len ca nac le chbucözëꞌ dza niꞌtë. Lbiꞌiczliꞌ gzxönliꞌ‑nëꞌ Jesús, len budödliꞌ‑nëꞌ lu naꞌquëꞌ bönniꞌ xöhuiꞌ tuaꞌdöꞌ, bönniꞌ guludöddëꞌ Lëꞌ catiꞌ niꞌ guludaꞌquëꞌ Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Niꞌr Dioscz buspanëꞌ Jesús naꞌ, buslë́ꞌ Lëꞌ lu yöl‑laꞌ gut, le cutu guc ugaꞌnëꞌ tsaz lu yöl‑laꞌ gut naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ca nac lë ni, bëꞌë didzaꞌ uláz queëꞌ Dios David ca nac queëꞌ Jesús, gnëꞌ: Bléꞌiteczdaꞌ‑nëꞌ Xanruꞌ, zoëꞌ lahuaꞌ. Lëꞌ zoëꞌ cuit lëꞌa yubél, rzönëꞌ nedaꞌ, Cui gac nu bi gun quiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Qui lë ni naꞌ budziji ladxaꞌa, Atiꞌ lu yöl‑laꞌ rudziji quiaꞌ bil‑laꞌ. Qui lë ni naꞌ gunaꞌ löz Lëꞌ Catiꞌ gdxin dza gatiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Xantuꞌ Dios, nözdaꞌ cutu ucaꞌnuꞌ nedaꞌ latj chul quegac nup natgac. Cutu guꞌu latj nit gdu ca nayáꞌ nabanaꞌ, Nacaꞌ bönniꞌ nadxiꞌicznuꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Buzéjniꞌnuꞌ nedaꞌ ca ral‑laꞌ gunaꞌ Quië gdél‑liꞌdaꞌ yöl‑laꞌ naꞌbán gdu. Gunuꞌ ga udzijdaꞌ le zóalenczuꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Naꞌa, böchaꞌa. Nac bëꞌ gutiëꞌ xuz xtauꞌruꞌ David, len bgachëꞌë yeru ba, atiꞌ dë ga zoaruꞌ ba queëꞌ naꞌ ga rdxintë naꞌa dza. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bëꞌë didzaꞌ uláz queëꞌ Dios David naꞌ, len gnöznëꞌ David, benëꞌ tsutsu didzaꞌ Dios le gzxiꞌ lu nëꞌë queëꞌ, gunëꞌ ga galjëꞌ Cristo ladj zxiꞌn xsoëꞌ, atiꞌ Cristo naꞌ gna bëꞌë, tsaziëꞌ xlatjëꞌ David naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Le bléꞌinëꞌ lë ni ziꞌal David, bëꞌë didzaꞌ ca guc, bubanëꞌ Cristo, len ca guc, cutu bugaꞌnëꞌ latj chul quegac nup natgac, atiꞌ cutu gnit le gyaꞌ gbanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios buspanëꞌ Jesús lu yöl‑laꞌ gut, len ca guc lë ni yúguꞌtëtuꞌ runtuꞌ lnaꞌ lau qui. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cni guc, len yöl‑laꞌ huac queëꞌ, Dios buchisëꞌ Lëꞌ xtsaꞌ ga niꞌ náctërëꞌ zxön. Naꞌa, Cristo chbsölëꞌë ni Dios Böꞌ Laꞌy, rac ca naꞌ gzxiꞌ lu nëꞌë Dios gunëꞌ lu nëꞌë Cristo, atiꞌ Dios Böꞌ Laꞌy naꞌ runëꞌ yuguꞌ lë ni rléꞌiliꞌ len ryö́niliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Cutu buëpëꞌ yehuaꞌ yubá David naꞌ, san lëczëꞌ David naꞌ gnëꞌ: Xanruꞌ Dios gudxëꞌ Xanaꞌ: “Gröꞌ cuit lëꞌa yubél ga nac blau ");
INSERT INTO zsrNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Catiꞌ gunraꞌ ga luzechu zxibgac lauꞌ nup taꞌdáꞌbagaꞌ Liꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Naꞌa, bunách Israel, le nacz ral‑laꞌ gnö́ziliꞌ. Dios benëꞌ ga naquëꞌ Xanruꞌ len Bönniꞌ Ruslá, Lëczëꞌ Jesús ni, bönniꞌ naꞌ budaꞌliꞌ‑nëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Catiꞌ gulayönnëꞌ lë ni bönniꞌ niꞌ, gulaböꞌë baguíꞌi, atiꞌ glëꞌ Pedro len yezícaꞌrëꞌ bönniꞌ gbaz queëꞌ Cristo, taꞌnë́ꞌ: ―Bö́chiꞌtuꞌ, ¿nacx gúntsatuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Niꞌr Pedro gudxëꞌ lequëꞌ: ―Gul‑bíꞌi ládxiꞌliꞌ, len gdil‑liꞌ nis tu tuliꞌ lu lëꞌ Jesucristo quië unít lahuëꞌ Dios dul‑laꞌ nabágaꞌliꞌ, atiꞌ dusóalenëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy, Nu gsölëꞌë queëliꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Queëliꞌ naqui le gzxiꞌ lu nëꞌë Dios, len quegac zxiꞌnliꞌ, lencaꞌ quegac yúguꞌtë bunách gzaꞌa, yúguꞌtë bönniꞌ niꞌ ulidzëꞌ lequëꞌ Xanruꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yuguꞌ didzaꞌ ni len yelaꞌgac zian didzaꞌ benëꞌ lnaꞌ lau Pedro, bchiziëꞌ icj nagquëꞌ, gnëꞌ: ―Gul‑gún ga ulaliꞌ, gcuitliꞌ ga nacuáꞌ bunách tuaꞌdöꞌ nacuáꞌ dza ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Cni guc, guladíl nis nup niꞌ gulazíꞌ lu naꞌgac didzaꞌ naꞌ bëꞌë Pedro. Dza naꞌ glun tuz lequëꞌ ca chi uruáꞌ gayuáꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Glunëꞌ yúguꞌtëꞌ gdutë le gulusëdnëꞌ lequëꞌ gbaz nasölëꞌë Cristo. Glaquëꞌ tuz tuëꞌ len yetúëꞌ, len tsazxö́n glahuëꞌ le rusáꞌ ládxiꞌruꞌ ca gutiëꞌ Jesús, atiꞌ glunëꞌ tsazxö́n, gululidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Zian le run ga rubániruꞌ len zian le tac bëꞌ glunëꞌ gbaz queëꞌ Cristo, san gladxi guladzöbi yezicaꞌr bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tuz glac yúguꞌtë nup naꞌ taꞌyejlëꞌ Cristo, atiꞌ guluúnëꞌ tuz yúguꞌtë le dë quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Catiꞌ gulaléꞌinëꞌ taꞌyadzji nup nútsaꞌgac ladjquëꞌ, niꞌr bönniꞌ bi dë quequëꞌ glútiꞌë lei, atiꞌ gulaguisiëꞌ dumí naꞌ qui queëgac nup niꞌ bi taꞌyadzji. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yuguꞌ dza guludubëꞌ tsazxö́n nchil gdauꞌ, atiꞌ gap nac lu yuꞌu glahuëꞌ le rusáꞌ ládxiꞌruꞌ ca gutiëꞌ Xanruꞌ. Tsazxö́n glahuëꞌ, atiꞌ guludzijnëꞌ len glac gdu ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gulaguꞌë Dios yöl‑laꞌ ba, atiꞌ glun lequëꞌ ba laꞌn yúguꞌtë bunách. Tu tu dza buzanëꞌ Xanruꞌ nup tuꞌdúb queëꞌ, nup naꞌ tuꞌlá. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dza niꞌ gulabenëꞌ zjaquëꞌ tsazxö́n nchil gdauꞌ Pedro len Juan, catiꞌ tuꞌdúb niꞌ tuꞌlídz Dios bunách, le nac gdu rdöd xhuö. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ga niꞌ taꞌdödëꞌ zoëꞌ bönniꞌ curzë́ꞌë dza niꞌtë niꞌ naquëꞌ biꞌidauꞌ. Yuguꞌ dza rjuaꞌquëꞌ lëꞌ niꞌ, taꞌbequëꞌ lëꞌ raꞌ gdauꞌ ga nazíꞌ lei Ga Nu Ryaz Lach, quië gnabëꞌ nu bi unö́dzjz queëꞌ ladj nup niꞌ taꞌyáz nchil gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bönniꞌ ni, catiꞌ bléꞌinëꞌ Pedro len Juan zjaquëꞌ taꞌyaziëꞌ nchil gdauꞌ, gútaꞌyuëꞌ lauquëꞌ bi lunödzjzëꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Niꞌr guluyúëꞌ lëꞌ Pedro len Juan, atiꞌ gudxëꞌ lëꞌ Pedro: ―Byu netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Niꞌr buzëtsca naguëꞌ lequëꞌ bönniꞌ naꞌ le runëꞌ löz bi lunödzjzëꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro gudxëꞌ lëꞌ: ―Cutu dë quiaꞌ dumí plata ni oro, san le dëz quiaꞌ gunnaꞌ quiuꞌ. Niꞌa qui yöl‑laꞌ huac qui lëꞌ Jesucristo, bönniꞌ Nazaret, gyas len gzëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Niꞌr gdel‑lëꞌë nëꞌë yubél bönniꞌ huëꞌ naꞌ Pedro, len bchisëꞌ lëꞌ, atiꞌ laꞌ böactë niꞌë len buguítj beycj niꞌë bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Niꞌr gzuinëꞌ bönniꞌ naꞌ atiꞌ gxítiꞌë len gzëꞌë. Gyázlenëꞌ tsazxö́n Pedro len Juan nchil gdauꞌ, rzëꞌi niꞌë len rxítiꞌë, len rguꞌë Dios yöl‑laꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yúguꞌtë bunách nacuáꞌ niꞌ taꞌleꞌi lëꞌ rzëꞌi niꞌë len rguꞌë Dios yöl‑laꞌ ba. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Cni guc, gládxinëꞌ len gulubannëꞌ ca nac lë naꞌ guc, le guluúnbëꞌë lëꞌ, naquëꞌ bönniꞌ naꞌ rböꞌë raꞌ gdauꞌ ga nazíꞌ lei Ga Nu Ryaz Lach, rnabëꞌ nu bi unö́dzjz queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tsal niꞌ zönëꞌ naꞌquëꞌ Pedro len Juan bönniꞌ naꞌ cugzë́ꞌë atiꞌ böaquëꞌ, guludúb yúguꞌtë bunách ga naꞌ nacuꞌë nchil gdauꞌ nazíꞌ lei: Nchil Queëꞌ Salomón, atiꞌ gulanáꞌ badxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Catiꞌ bléꞌinëꞌ lë ni Pedro, gudxëꞌ bunách naꞌ: ―Lbiꞌiliꞌ, bönniꞌ Israel, ¿bizx quië rubániliꞌ ca nac lë ni? ¿Bizx quië ruyuliꞌ netuꞌ, ráquitsaliꞌ netuꞌz buntuꞌ‑nëꞌ bönniꞌ ni, bentuꞌ ga gzëꞌi niꞌë niꞌa qui yöl‑laꞌ huac queëztuꞌ, o niꞌa qui le rej ládxiꞌtuꞌ‑nëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nac lë ni le benëꞌ Dios, naquëꞌ Dios quequëꞌ xuz xtauꞌruꞌ Abraham len Isaac len Jacob, béntërëꞌ Jesús, Zxiꞌnëꞌ, ba laꞌn. Jesús ni, lbiꞌiczliꞌ budödliꞌ‑nëꞌ lu naꞌquëꞌ bönniꞌ taꞌná béꞌinëꞌ lbiꞌiliꞌ. Catiꞌ guꞌnnëꞌ Pilato usanëꞌ Jesús, gdáꞌbagaꞌliꞌ‑nëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gdáꞌbagaꞌliꞌ‑nëꞌ Bönniꞌ Tsahuiꞌ len Laꞌy, atiꞌ gnabliꞌ gsanëꞌ queëliꞌ bönniꞌ gdödi bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Cni guc, budö́diliꞌ‑nëꞌ Bönniꞌ runnczëꞌ queëruꞌ yöl‑laꞌ naꞌbán gdu. Niꞌr Dios buspanëꞌ Lëꞌ lu yöl‑laꞌ gut, atiꞌ ca nac lë ni runtuꞌ lnaꞌ lau qui. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Le gyejlëꞌë Jesús, böac niꞌë bönniꞌ ni, rléꞌiliꞌ‑nëꞌ len núnbëꞌliꞌ‑nëꞌ. Le rejlëꞌë Jesús, Lëꞌ bunëꞌ dxíꞌadauꞌ bönniꞌ ni, atiꞌ rléꞌiliꞌ yúguꞌtëliꞌ le nacz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Naꞌa, böchaꞌa, nözdaꞌ benliꞌ cni, budö́diliꞌ‑nëꞌ Jesús le cutu gyéjniꞌliꞌ, len cutu gulayéjniꞌnëꞌ bönniꞌ taꞌná béꞌinëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cni buschinëꞌ Dios didzaꞌ naꞌ bëꞌë ziꞌal, le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ ca ral‑laꞌ sacaꞌ quiꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Qui lë ni naꞌ, gul‑bíꞌi ládxiꞌliꞌ, len gul‑huöác queëꞌ Dios, quië ugǘëꞌ dul‑laꞌ nabágaꞌliꞌ, len gunëꞌ ga huöac ládxiꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Niꞌr gsölëꞌë leyúbl Jesús, Bönniꞌ naꞌ dza niꞌtë buzóëꞌ quië gaquëꞌ Cristo, Nu naꞌ gna beꞌi lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Naꞌa, run bayúdx ugaꞌnëꞌ niꞌ yehuaꞌ yubá catiꞌ gdxinr dza duhuenëꞌ tsahuiꞌ yúguꞌtë le rac, gac ca naꞌ chgnaczëꞌ Dios, lë naꞌ gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ, bönniꞌ niꞌ gulacuꞌë dza niꞌtë. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lëzcaꞌ cni gudxëꞌ xuz xtauꞌruꞌ Moisés, gnëꞌ: “Xanruꞌ Dios gsölëꞌë queëliꞌ bönniꞌ galjëꞌ ladjgac diꞌa dza queëliꞌ. Gaquëꞌ bönniꞌ guꞌë didzaꞌ uláz queëꞌ Dios. Gsölëꞌë Lëꞌ queëliꞌ ca naꞌ bsölëꞌë nedaꞌ. Run bayúdx uzë́ nagliꞌ‑nëꞌ ca nac yúguꞌtë le guiëꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Laꞌnít len lulaꞌalen bunách queëꞌ Dios yúguꞌtë nup culuzë́ naggac bönniꞌ niꞌ guꞌë didzaꞌ uláz queëꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ca nac dza ni zoaruꞌ naꞌa, gulaguíxjöꞌë yúguꞌtë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios ga gdél‑laꞌtë zoëꞌ Samuel len gdöd niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lbiꞌiliꞌ nacliꞌ zxiꞌn xsoaquëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, atiꞌ naqui queëliꞌ didzaꞌ rucáꞌn tsahuiꞌ, le bénlenëꞌ xuz xtauꞌruꞌ Dios, catiꞌ niꞌ gudxëꞌ Abraham: “Niꞌa qui le gunëꞌ zxiꞌn xsuꞌ lac bicaꞌ ba yúguꞌtë bunách yödzlyú.” ");
INSERT INTO zsrNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Catiꞌ Dios buspanëꞌ Zxiꞌnëꞌ lu yöl‑laꞌ gut, bsölëꞌë Lëꞌ ziꞌal queëliꞌ quië gunëꞌ ga gacliꞌ bicaꞌ ba, ucaꞌnliꞌ le cunác runliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tsal niꞌ tuíꞌlenëꞌ bunách naꞌ didzaꞌ Pedro len Juan, tu tsalz guladxinëꞌ ga naꞌ nacuꞌë yuguꞌ bxuz judío len yuguꞌ bönniꞌ gdauꞌ saduceo, len bönniꞌ nacuáꞌ lu nëꞌë niꞌa naꞌquëꞌ bönniꞌ gdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gulaleynëꞌ bönniꞌ ni le tuꞌsëdnëꞌ bunách Pedro len Juan, len taꞌguíxjöꞌë lubán nup chnatgac le bubanëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Niꞌr gulazönëꞌ Pedro len Juan, atiꞌ gulaguꞌë lequëꞌ lidx guia ga gdxinr dza yubl le chrdzöꞌ dza naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Gulayejlëꞌ Cristo zian nup niꞌ gulayöni didzaꞌ gluꞌë Pedro len Juan. Naꞌa, bönniꞌz taꞌyejlëꞌë Cristo nacquëꞌ gdu chiʉ́n gayuꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dza buróp niꞌ, guludubëꞌ Jerusalén yuguꞌ bönniꞌ uná bëꞌ, len bönniꞌ gul tuꞌzejniꞌnëꞌ bunách judío, len bönniꞌ gdauꞌ tuꞌsëdi. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Guludubëꞌ caꞌ niꞌ Anás, bxuz blau, len Caifás, len Juan len Alejandro, lencaꞌ yúguꞌtë bönniꞌ diꞌa dza quequëꞌ bxuz blau. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Niꞌr gulachë́ꞌë Pedro len Juan, atiꞌ guluschinëꞌ lequëꞌ gatsj lahuiꞌl ga naꞌ nacuꞌë, len gulanabnëꞌ lequëꞌ, taꞌnë́ꞌ: ―¿Bizxa yöl‑laꞌ uná bëꞌ dë lu naꞌliꞌ runliꞌ lë ni? ¿Nuzxa budö́d lu naꞌliꞌ yöl‑laꞌ uná bëꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Niꞌr gudxëꞌ lequëꞌ Pedro, zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy, rnëꞌ: ―Lbiꞌiliꞌ, nul‑liꞌ rna béꞌiliꞌ netuꞌ, bunách Israel, len lbiꞌiliꞌ bönniꞌ gul. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Naꞌa, ¿rnábitsaliꞌ netuꞌ ca nac dxin dxiꞌa bentuꞌ queëꞌ bönniꞌ huëꞌ ni, len nacx guc, böaquëꞌ bönniꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Rguíxjöiꞌtuꞌ lbiꞌiliꞌ quië laꞌnözi yúguꞌtë bunách Israel. Zoëꞌ ni lauliꞌ bönniꞌ ni, nuhuöaquëꞌ le ben dxin yöl‑laꞌ huac queëꞌ Jesucristo, bönniꞌ Nazaret, Bönniꞌ niꞌ budaꞌliꞌ‑nëꞌ lëꞌi yag cruz, san Dios buspanëꞌ Lëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Dios bëꞌë didzaꞌ ca nac queëꞌ Jesús ni, catiꞌ niꞌ gnëꞌ: “Guiöj naꞌ gruꞌnliꞌ lbiꞌiliꞌ, rucuaꞌliꞌ zöꞌö, san guiöj ni gröczaꞌ nedaꞌ quië gac guiöjlen zöꞌö.” ");
INSERT INTO zsrNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nutur nu zoa nu gac uslá bunách, le cutu caꞌ zoa yödzlyú ni yetúëꞌ bönniꞌ nuzóëꞌ Dios, nu gac uslá rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Catiꞌ gulaléꞌinëꞌ nacquëꞌ rugu ladxiꞌ Pedro len Juan, len gláquibeꞌinëꞌ cunazëdquëꞌ qui gdauꞌ len nacquëꞌ bönniꞌ caꞌz, gulubannëꞌ atiꞌ yajneycnëꞌ gulacuáꞌlenëꞌ Jesús Pedro len Juan naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lëzcaꞌ gulaléꞌinëꞌ niꞌ bönniꞌ naꞌ böaquëꞌ, zuinëꞌ lauquëꞌ, atiꞌ cutu caꞌ guc bi laꞌnë́ꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Niꞌr gulaná béꞌinëꞌ nup lubíj lequëꞌ löꞌal yuꞌu ga naꞌ nudubquëꞌ, atiꞌ glun xtídzaꞌquëꞌ laꞌ légaczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Gulanë́ꞌ: ―¿Nacx gúntsaruꞌ quequëꞌ bönniꞌ ni? Le nactë glunëꞌ tu le run ga tuꞌbani bunách, atiꞌ nö́zigac cni yúguꞌtë bunách nacuáꞌ Jerusalén. Cutu gac táꞌbagaꞌruꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Naꞌa, cui sër didzaꞌ laꞌyöni zianr caꞌ bunách, uzeyruꞌ ba nadx lequëꞌ cui luíꞌlenrëꞌ bunách didzaꞌ ca nac queëꞌ Jesús naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Niꞌr gululidzëꞌ Pedro len Juan, atiꞌ guluzeynëꞌ ba nadx lequëꞌ cui luíꞌlenrëꞌ bunách didzaꞌ, len cui lusëdnëꞌ lequëꞌ ca nac queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Niꞌr gulubiꞌë didzaꞌ Pedro len Juan, glëꞌ lequëꞌ: ―Gul‑bequi xbey lbiꞌiliꞌ chquiꞌ nac tsahuiꞌ lahuëꞌ Dios uzë́r nagtuꞌ xtídzaꞌliꞌ lbiꞌiliꞌ ca xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Cutu gac soa dxituꞌ. Run bayúdx güiꞌtuꞌ didzaꞌ qui le bléꞌituꞌ len le byö́nituꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Niꞌr guluzeynëꞌ ba nadx lequëꞌ bönniꞌ gdauꞌ taꞌbequi xbey, san gulusanëꞌ lequëꞌ le cutu guludzölnëꞌ nacx lunëꞌ lequëꞌ zxguiaꞌ. Cni glunëꞌ le gládxinëꞌ bunách lu yödz niꞌ, le taꞌguꞌë Dios yöl‑laꞌ ba yúguꞌtëꞌ niꞌa qui lë naꞌ guc. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bönniꞌ naꞌ böaquëꞌ, guc queëꞌ lë naꞌ run ga rubániruꞌ, chyuꞌurëꞌ ca choaꞌ iz. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Catiꞌ gulusanëꞌ lequëꞌ, guludxinëꞌ Pedro len Juan ga naꞌ nacuꞌë lzaꞌquëꞌ, atiꞌ gulaguíxjöiꞌnëꞌ lequëꞌ yúguꞌtë lë naꞌ glëꞌ lequëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzéjniꞌnëꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Catiꞌ gulayönnëꞌ lë ni, tsazxö́n gululidzëꞌ Dios, gulanë́ꞌ: ―Xantuꞌ Dios, náctëruꞌ blau. Liꞌ nacuꞌ Dios, benuꞌ luzxbá. Benuꞌ luyú. Benuꞌ nis zxön. Benuꞌ yúguꞌtë le nacuáꞌ tu tu latj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Uláz quiuꞌ Liꞌ bëꞌë didzaꞌ David, bönniꞌ huen dxin quiuꞌ, gzóalenëꞌ lëꞌ Dios Böꞌ Laꞌy, gnëꞌ: ¿Bizx quië tun rusbö́ bunách Len taꞌzáꞌ ládxiꞌgac le cunác? ");
INSERT INTO zsrNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Glunëꞌ rusbö́ bönniꞌ taꞌná bëꞌë yödzlyú ni Atiꞌ glaquëꞌ tuz bönniꞌ uná bëꞌ. Guladáꞌbaguëꞌë Xanruꞌ Dios, Lencaꞌ Cristo, bönniꞌ gröczëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Le nactë glaquëꞌ tuz lu yödz ni Herodes len Poncio Pilato len yuguꞌ bönniꞌ gzaꞌa len yuguꞌ bönniꞌ Israel. Guladáꞌbaguëꞌë Jesús, Zxiꞌnuꞌ laꞌy, Nu naꞌ buzúꞌ queëtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Glunëꞌ yúguꞌtë le bucözuꞌ zíꞌatël ca gzxiꞌ lu naꞌu atiꞌ guc ca naꞌ benuꞌ tsutsu xtidzuꞌu ca ral‑laꞌ gac. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naꞌa, Xantuꞌ, byu le tuꞌzeynëꞌ ba nadx netuꞌ, len ben ga gactuꞌ rugu ladxiꞌ, güiꞌtuꞌ xtidzuꞌu, netuꞌ bönniꞌ huen dxin quiuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ben ga gac úngactuꞌ nup teꞌi, soalen netuꞌ yöl‑laꞌ huac quiuꞌ, len ben ga gac gúngactuꞌ le lun ga ubánituꞌ len le lac bëꞌ, gac cni le zóalenëꞌ netuꞌ Jesús, Zxiꞌnuꞌ laꞌy. Caꞌ gac. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Catiꞌ budx gululidzëꞌ Dios, gzxiz latj ga naꞌ nacuꞌë, atiꞌ gdu gzóalenëꞌ yúguꞌtëꞌ Dios Böꞌ Laꞌy, atiꞌ len yöl‑laꞌ rugu ladxiꞌ quequëꞌ gluꞌë xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bunách zian naꞌ taꞌyejlëꞌ Cristo, tuz ca röꞌ icjquëꞌ len tuz ca glunëꞌ. Cutu gnëꞌ naqui queëzëꞌ le dë queëꞌ nitúëꞌ bönniꞌ nutsëꞌë ladjquëꞌ, san guluúnëꞌ tuz le dë quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Len yöl‑laꞌ huac zxön gulaguíxjöꞌë ca bubanëꞌ Xanruꞌ Jesús gbaz naꞌ nasölëꞌë Lëꞌ, atiꞌ guclen yúguꞌtëꞌ le buzáꞌ ladxëꞌë quequëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nutu nu bi byadzj nu nutsaꞌ ladjquëꞌ. Yúguꞌtë bönniꞌ bi dë quequëꞌ, xyuquëꞌ, o lidxquëꞌ, glútiꞌë lei, atiꞌ dumí qui naꞌ yjuaꞌquëꞌ ");
INSERT INTO zsrNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","len guludödëꞌ lei lu naꞌquëꞌ gbaz naꞌ nasölëꞌë Cristo, atiꞌ lequëꞌ gulaguisiëꞌ lei qui queëgac nup bi byadzj quegac. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Zoëꞌ niꞌ José, bönniꞌ guluzóëꞌ yetú lëꞌ Bernabé gbaz naꞌ nasölëꞌë Cristo, le rna lu didzaꞌ xidzaꞌ, Bönniꞌ Ruhuíꞌ Zxönëꞌ. Nabáblenëꞌ zxiꞌn xsoëꞌ Leví, len guljëꞌ luyú Chipre. ");
INSERT INTO zsrNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bë́tiꞌë tu cöꞌ xyuëꞌ bönniꞌ ni, atiꞌ yjuꞌë dumí qui naꞌ, len budödëꞌ lei lu naꞌquëꞌ gbaz naꞌ nasölëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Zoëꞌ bönniꞌ yubl lëꞌ Ananías, bë́tiꞌë tu cöꞌ xyuëꞌ, atiꞌ bennu tsazxö́n lëꞌ Safira, ngul queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bucáchiꞌlanëꞌ dumí qui yu naꞌ Ananías naꞌ, atiꞌ nö́zinu caꞌ ngul queëꞌ. Le bugáꞌnz yjuꞌë len gluꞌë lei lu naꞌquëꞌ gbaz nasölëꞌë Cristo, rnëꞌ: ―Tscaníz gzxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro gudxëꞌ lëꞌ: ―Ananías, ¿naruꞌ gyaztsa Satanás tuꞌ xöhuiꞌ lu icj ládxiꞌdaꞌu len ben ga rziꞌ yéꞌinuꞌ Dios Böꞌ Laꞌy, atiꞌ bucachiꞌ lanuꞌ dumí qui xyuꞌ naꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tsal niꞌ nagáꞌn lu naꞌu yu naꞌ, ¿naruꞌ cu naqui quizi quiuꞌ? Gdöd bë́tiꞌu lei, ¿naruꞌ cu dëcz lu naꞌu dumí qui naꞌ? ¿Bizx quië gröꞌ icjuꞌ gunuꞌ cni? Dioscz gzxiꞌ yéꞌinuꞌ, clëgz bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Catiꞌ byönnëꞌ didzaꞌ ni Ananías, gdzöꞌë len guttëꞌ. Niꞌr gulabígaꞌtëbiꞌ biꞌi raꞌbán, atiꞌ guluchö́libiꞌ lëꞌ lariꞌ len gluaꞌbiꞌ lëꞌ yajcáchiꞌcbiꞌ lëꞌ. Gladxi guladzöbi yúguꞌtë nup niꞌ gulayöni ca guc lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ca tsonn hora gdöd niꞌ, bdxinnu niꞌ ngul queëꞌ Ananías naꞌ, len cutu nö́zinu lë naꞌ guc queëꞌ bönniꞌ queënu. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Niꞌr Pedro gudxëꞌ‑nu: ―Gdixjöiꞌ nedaꞌ. ¿Naruꞌ gzxiꞌliꞌ tscaníz xyuliꞌ naꞌ? Gnanu: ―Ja, tscaníz gzxiꞌtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Niꞌr Pedro gudxëꞌ‑nu: ―¿Bizx quië ben tuz xtídzaꞌliꞌ gzxiꞌ bëꞌ xö́huiꞌliꞌ Dios Böꞌ Laꞌy? Byutscaꞌ. Chzoa ludxinbiꞌ biꞌi gulucáchiꞌbiꞌ‑nëꞌ bönniꞌ quiuꞌ, atiꞌ lubijbiꞌ caꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Niꞌr laꞌ gdzö́ꞌtënu xniꞌë Pedro len gúttënu. Catiꞌ gulayazbiꞌ biꞌi raꞌbán naꞌ, gulaléꞌibiꞌ‑nu chnatnu. Niꞌr gulubijbiꞌ‑nu, atiꞌ yajcáchiꞌcbiꞌ‑nu cuit lëꞌë bönniꞌ queënu. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Qui lë ni naꞌ gladxi guladzöbi yúguꞌtë bunách queëꞌ Dios, atiꞌ gladxi caꞌ yúguꞌtë nup gulayöni ca guc lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zian le tac bëꞌ len yuguꞌ yöl‑laꞌ huac zxön glunëꞌ laugac bunách lu yödz bönniꞌ gbaz naꞌ nasölëꞌë Cristo. Guludubëꞌ tsazxö́n yúguꞌtëꞌ ga nac nchil gdauꞌ nazíꞌ lei Nchil Queëꞌ Salomón. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ladj nup niꞌ cutaꞌyejlëꞌ Cristo, nutu nu burugui tsajtáꞌ lequëꞌ, atiꞌ glun lequëꞌ ba laꞌn bunách lu yödz niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Niꞌr gulayejlëꞌ Cristo yelaꞌgac bunách zian caꞌ, bönniꞌ len ngul. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Catiꞌ gulaleꞌi bunách yuguꞌ le tunëꞌ bönniꞌ niꞌ taꞌyejlëꞌë Cristo, yjuaꞌgac gap nac laꞌ nöz nup teꞌi, atiꞌ gulaxóëꞌ lequëꞌ lu daꞌa yag len yelaꞌgac lu daꞌaz, quië catiꞌ tödëꞌ niꞌ Pedro, tsa zxulz queëꞌ cuꞌu zxul laꞌgac bunách huëꞌ naꞌ, quië luhuöác. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lëzcaꞌ gularúj bunách yuguꞌ dzag yödz, guladxinëꞌ Jerusalén, nuaꞌquëꞌ nup teꞌi len nup taꞌzacaꞌ taꞌguíꞌi, yuꞌugac lequëꞌ böꞌ xöhuiꞌ, atiꞌ guluhuöaquëꞌ yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Qui lë ni naꞌ guluzxéꞌinëꞌ Pedro bxuz blau len yuguꞌ bönniꞌ gdauꞌ saduceo naꞌ daꞌquëꞌ bxuz blau. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Niꞌr gulazönëꞌ yuguꞌ gbaz naꞌ nasölëꞌë Cristo bxuz blau naꞌ len bönniꞌ naꞌ daꞌquëꞌ lëꞌ, atiꞌ gulaguꞌë lequëꞌ lidx guia. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Niꞌr chdzöꞌl bdxinëꞌ gbaz laꞌy queëꞌ Xanruꞌ, atiꞌ bsaljëꞌ lidx guia naꞌ len bubijëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Gudxëꞌ lequëꞌ gbaz laꞌy naꞌ, rnëꞌ: ―Gul‑tséaj, gul‑tsajsóa nchil gdauꞌ len gul‑tsjëꞌlen bunách niꞌ didzaꞌ, quíxjöiꞌliꞌ lequëꞌ ca nac yöl‑laꞌ naꞌbán gdu ni len ca gac laꞌdél‑liꞌnëꞌ lei. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Catiꞌ gulayönnëꞌ didzaꞌ ni ruꞌë gbaz laꞌy naꞌ, len catiꞌ zaꞌ reníꞌ zildauꞌ gulayaziëꞌ nchil gdauꞌ, len gulusëdnëꞌ bunách. Laꞌ niꞌz guludubëꞌ bxuz blau len nup nacuaꞌlen lëꞌ tsazxö́n len bönniꞌ gdauꞌ taꞌbequi xbey len bönniꞌ gul tuꞌzéjniꞌnëꞌ bunách Israel, atiꞌ gulasölëꞌë nup tsjac lidx guia tsajxiꞌcquëꞌ gbaz naꞌ nasölëꞌë Cristo, táquinëꞌ niꞌ nacuꞌë lidx guia naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Catiꞌ guladxinëꞌ niꞌ niꞌa naꞌquëꞌ bönniꞌ gdauꞌ naꞌ, cutu yajxácaꞌquëꞌ lequëꞌ lu yuꞌu lidx guia naꞌ, atiꞌ niꞌr guluhueycjëꞌ dutíxjöꞌquëꞌ caꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Glëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, taꞌnë́ꞌ: ―Le nactë yajxácaꞌtuꞌ nayeyjtë lidx guia, atiꞌ nacuáꞌ raꞌ lidx guia naꞌ nup tun chiꞌi, san catiꞌ bsaljtuꞌ, nutu nu yajxácaꞌtuꞌ lu yuꞌu naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Catiꞌ gulayönnëꞌ didzaꞌ ni bxuz blau len yuguꞌ bxuz uná bëꞌ len bönniꞌ nacuáꞌ lu nëꞌë niꞌa naꞌgac bunách gdauꞌ, gulaböꞌtsquëꞌ baguíꞌi le cutu nözcnëꞌ gazx gdxintë lë naꞌ rac. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Niꞌr bdxinëꞌ niꞌ bönniꞌ gdíxjöiꞌnëꞌ lequëꞌ, rnëꞌ: ―Gul‑yutscaꞌ. Nacuꞌë nchil gdauꞌ tuꞌsëdnëꞌ bunách bönniꞌ naꞌ glúꞌgacliꞌ‑nëꞌ lidx guia. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Niꞌr gyijëꞌ bönniꞌ naꞌ nacuꞌë lu nëꞌë niꞌa naꞌgac bunách gdauꞌ, dzagquëꞌ lëꞌ niꞌa naꞌquëꞌ naꞌ, atiꞌ gulachë́ꞌë yuguꞌ gbaz naꞌ nasölëꞌë Cristo, san cutu bi glunëꞌ quequëꞌ, le gládxinëꞌ luladxiꞌ lequëꞌ guiöj bunách nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Catiꞌ chnachëꞌquëꞌ yuguꞌ gbaz naꞌ, guluschinëꞌ lequëꞌ lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, atiꞌ gnabnëꞌ lequëꞌ bxuz blau, ");
INSERT INTO zsrNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","rnëꞌ: ―¿Naruꞌ cu gúdxtscatuꞌ lbiꞌiliꞌ cu usë́diliꞌ bunách ca nac queëꞌ bönniꞌ naꞌ? Naꞌa, chgdisliꞌ zxba ni gdutë yödz Jerusalén, len rë́ꞌniliꞌ uspágaꞌliꞌ netuꞌ zxguiaꞌ niꞌa qui yöl‑laꞌ gut queëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Niꞌr gulubiꞌë didzaꞌ Pedro len yezícaꞌrëꞌ gbaz naꞌ nasölëꞌë Cristo, taꞌnë́ꞌ: ―Run bayúdx uzë́r nagtuꞌ xtidzëꞌë Dios ca xtídzaꞌgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lbiꞌiliꞌ budö́diliꞌ‑nëꞌ Jesús catiꞌ niꞌ budaꞌliꞌ‑nëꞌ lëꞌi yag cruz, san Dios quequëꞌ xuz xtauꞌruꞌ buspanëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jesús ni, Dios buzoaczëꞌ Lëꞌ ga náctërëꞌ blau cuit lëꞌë yubél, quië gaquëꞌ Bönniꞌ Blau len Bönniꞌ Ruslá, len gunëꞌ ga lubíꞌi ládxiꞌgac bunách Israel, quië gac unít lahuëꞌ dul‑laꞌ nabágaꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ca nac lë ni, runtuꞌ lnaꞌ lau qui netuꞌ, atiꞌ lëzcaꞌ runëꞌ lnaꞌ lau qui Dios Böꞌ Laꞌy, Nu naꞌ rsölëꞌë Dios quegac nup tun ca rna xtidzëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Catiꞌ gulayönnëꞌ lë ni bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, gulaleynëꞌ len glëꞌnnëꞌ ludödcdëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Niꞌr gzuinëꞌ lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ Gamaliel, bönniꞌ gdauꞌ fariseo. Ractsquëꞌ zxba queëꞌ Moisés bönniꞌ ni, atiꞌ tun lëꞌ ba laꞌn yúguꞌtë bunách. Gna béꞌinëꞌ nup lubíj löꞌal tu chiꞌidauꞌ yuguꞌ gbaz naꞌ nasölëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Niꞌr gudxëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, gnëꞌ: ―Lbiꞌiliꞌ, bönniꞌ Israel, gul‑yutëz queëliꞌ ca nac le rë́ꞌniliꞌ gunliꞌ quequëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ral‑laꞌ tsajneyliꞌ ca guc zíꞌatël ziꞌa gdxin dza ni zoaruꞌ. Gyasëꞌ Teudas, atiꞌ ben cuinëꞌ ca bönniꞌ náctërëꞌ blau. Glaquëꞌ bönniꞌ yajtaꞌquëꞌ lëꞌ gdu tap gayuꞌë bönniꞌ. Guludöddëꞌ lëꞌ bönniꞌ rjaquëꞌ gdil‑l, atiꞌ glaslas yúguꞌtë nup niꞌ yajtaꞌgac lëꞌ, atiꞌ gnitz caꞌ yúguꞌtë le benëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Gdöd guc lë ni, gyasëꞌ caꞌ Judas, bönniꞌ Galilea. Benëꞌ cni catiꞌ niꞌ nac dza taꞌyáz lu guich bunách, taꞌguízxj lazquëꞌ, atiꞌ yajtaꞌgac lëꞌ bunách zian. Lëzcaꞌ guludöddëꞌ bönniꞌ ni, atiꞌ glaslas yúguꞌtë nup niꞌ yajtaꞌgac lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Qui lë ni naꞌ rëpaꞌ lbiꞌiliꞌ: Gul‑sán‑quëꞌ bönniꞌ ni, len cutu bi gunliꞌ quequëꞌ. Chquiꞌ nac quegacz bunách lë ni taꞌnë́ꞌ o lë ni tunëꞌ, nitcz, ");
INSERT INTO zsrNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","san chquiꞌ nac queëꞌ Dios, cutu gac usnitliꞌ lei. ¡Qui nadxi tíl‑lenliꞌ‑nëꞌ Dios! ");
INSERT INTO zsrNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Niꞌr glunëꞌ tuz didzaꞌ len lëꞌ. Gululidzëꞌ yuguꞌ gbaz naꞌ nasölëꞌë Cristo, atiꞌ gulaguinëꞌ lequëꞌ len guluzeynëꞌ lequëꞌ ba nadx cui luíꞌlenrëꞌ bunách didzaꞌ ca nac queëꞌ Jesús. Niꞌr gulusanëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Gularujëꞌ lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ gbaz naꞌ nasölëꞌë Cristo, tuꞌdzijnëꞌ le bëꞌë lequëꞌ latj Dios gulazacaꞌ gulaguiꞌë le daꞌquëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yuguꞌ dza gulusë́dtecznëꞌ bunách len glunëꞌ lban queëꞌ Jesucristo nchil gdauꞌ len gap nac lu yuꞌu lidxgac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dza niꞌ, le gulayán bunách taꞌyejlëꞌ Cristo, gulanë́ꞌ quequëꞌ bönniꞌ judío tuꞌë didzaꞌ hebreo yuguꞌ bönniꞌ judío tuꞌë didzaꞌ griego, niꞌa qui le rac catiꞌ taꞌguisiëꞌ le lágunu ngul uzë́b, nutu nu ruiꞌ le lágunu ngul uzë́b quequëꞌ bönniꞌ niꞌ tuꞌë didzaꞌ griego. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Niꞌr gulutubëꞌ yúguꞌtë bunách niꞌ taꞌyejlëꞌ Cristo idxínnutëꞌ gbaz naꞌ nasölëꞌë Cristo, atiꞌ tëꞌ lequëꞌ: ―Cutu nac dxiꞌa soa dxituꞌ cuguntuꞌ lban qui xtidzëꞌë Dios quië guntuꞌ dxin cuꞌtuꞌ le lagu bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Qui lë ni naꞌ, böchiꞌ lzaꞌtuꞌ, gul‑cö́‑quëꞌ gadxëꞌ bönniꞌ ladjliꞌ quië uguꞌruꞌ lu naꞌquëꞌ dxin ni. Yuguꞌ bönniꞌ naꞌ run bayúdx lacquëꞌ bönniꞌ tun lequëꞌ ba laꞌn yúguꞌtë bunách, len nacquëꞌ bönniꞌ taꞌyejniꞌi, len nac bëꞌ zóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Netuꞌ ni ulídztecztuꞌ‑nëꞌ Dios, len usë́dituꞌ bunách xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Guladzág ládxiꞌquëꞌ didzaꞌ ni yúguꞌtëꞌ, atiꞌ gulabö́ëꞌ Esteban, bönniꞌ rejlëꞌë Cristo gdu ladxëꞌë len gdu zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy. Lëzcaꞌ gulabö́ëꞌ Felipe, len Prócoro, len Nicanor, len Timón, len Parmenas, len Nicolás, bönniꞌ yödz Antioquía, ziꞌal butsë́ꞌë ca runëꞌ quië tsej ladxëꞌë Dios ca tunëꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Niꞌr guluschinëꞌ nup naꞌ gulabö́ëꞌ lauquëꞌ gbaz naꞌ nasölëꞌë Cristo. Gulaxóa naꞌquëꞌ lequëꞌ bönniꞌ gbaz naꞌ, tuꞌlidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gzër xtidzëꞌë Xanruꞌ, atiꞌ gulayantsca bunách taꞌyejlëꞌ Cristo nacuáꞌ Jerusalén. Lëzcaꞌ gulazíꞌ lu naꞌquëꞌ le réjlëꞌruꞌ Cristo zian bxuz judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Benëꞌ le tun ga rubániruꞌ, len le tac bëꞌ laugac bunách lu yödz Esteban, gdu zoalen lëꞌ yöl‑laꞌ huac queëꞌ Dios le buzáꞌ ladxëꞌë queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Niꞌr gulayasëꞌ laꞌquëꞌ bönniꞌ nababquëꞌ yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, nazíꞌ lei Yuꞌu Quegac Bönniꞌ Nadzangac. Glunëꞌ lequëꞌ tsazxö́n bönniꞌ narujquëꞌ Cirene len Alejandría, len luyú Cilicia, len luyú Asia. Bönniꞌ ni guladíl‑lenëꞌ Esteban didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Cutu guluxicjëꞌ didzaꞌ ruꞌë, le bëꞌë didzaꞌ Esteban len yöl‑laꞌ rejniꞌi, le zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Niꞌr gulaguizxjëꞌ bönniꞌ laꞌzíꞌ yëꞌë, laꞌnë́ꞌ: “Netuꞌ byö́nituꞌ didzaꞌ ruꞌë Esteban, rnë ziꞌë queëꞌ Moisés len queëꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Cni guc, gulaguꞌë xla ládxiꞌgac bunách bönniꞌ ni. Gulaguꞌë xla ládxiꞌquëꞌ caꞌ bönniꞌ gul tuꞌzejniꞌi, len bönniꞌ gdauꞌ tuꞌsëdi. Gulabía diꞌë Esteban bönniꞌ ni. Gulazönëꞌ lëꞌ len gulachë́ꞌë lëꞌ lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Lëzcaꞌ gulucuꞌë lauquëꞌ nup gulaguixjöꞌ le cunácz, bönniꞌ naꞌ gulanë́ꞌ: ―Cutu zoëꞌ dxiz bönniꞌ ni rnë ziꞌë qui gdauꞌ laꞌy ni, len qui zxba queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Byö́nituꞌ didzaꞌ bëꞌë bönniꞌ ni ca gunëꞌ Jesús, bönniꞌ Nazaret, rnëꞌ usnitiëꞌ gdauꞌ ni, len utsë́ꞌë yuguꞌ le nalë́biruꞌ runruꞌ, yuguꞌ lë naꞌ gna béꞌinëꞌ rëꞌu Moisés. ");
INSERT INTO zsrNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Niꞌr guluyúëꞌ Esteban bönniꞌ gdauꞌ taꞌbequi xbey len yúguꞌtë nup röꞌgac niꞌ, atiꞌ gulaléꞌinëꞌ lahuëꞌ, rnaꞌ ca rnaꞌ lahuëꞌ gbaz laꞌy queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Niꞌr gnabnëꞌ Esteban bxuz blau, rnëꞌ: ―¿Naruꞌ nacz cni? ");
INSERT INTO zsrNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Bubiꞌë didzaꞌ Esteban, rnëꞌ: ―Lbiꞌiliꞌ, bönniꞌ gul, len lbiꞌiliꞌ, böchaꞌa. Gul‑zë́ nagliꞌ le gyëpaꞌ lbiꞌiliꞌ. Dios, Nu nactër blau, buluíꞌ lahuëꞌ ga zoëꞌ Abraham, xuzruꞌ gul gdöd, catiꞌ niꞌ zoëꞌ luyú Mesopotamia, catiꞌ ziꞌa tsajsóëꞌ yödz Harán. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios gudxëꞌ lëꞌ: “Bruj ladzuꞌ len blaꞌalen diꞌa dza quiuꞌ, atiꞌ gyeaj luyú niꞌ uluiꞌidaꞌ liꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Niꞌr brujëꞌ Abraham luyú Mesopotamia le nac xyugac bunách Caldea, atiꞌ yajsóëꞌ Harán. Lu yödz niꞌ gutiëꞌ xuzëꞌ Abraham naꞌ, atiꞌ lëꞌ buzë́ꞌë niꞌ, atiꞌ Dios bchëꞌë lëꞌ latj ni, ga ni zoaruꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dios cutu bëꞌë lëꞌ latj gaqui queëꞌ luyú ni. Ni latiꞌ bunödzjëꞌ queëꞌ ga soëꞌ luyú ni, san gzxiꞌ lu nëꞌë Dios unödzjëꞌ queëꞌ luyú ni, atiꞌ töd gatiëꞌ Abraham gaqui quegac zxiꞌn xsoëꞌ luyú ni, zal‑laꞌ cutu nacuíꞌnibiꞌ biꞌi queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lëzcaꞌ cni gudxëꞌ Abraham Dios: “Tsjaquëꞌ zxiꞌn xsuꞌ lu xyugac bunách gzaꞌa, atiꞌ niꞌ lacquëꞌ ca bunách ziꞌtuꞌ. Lunëꞌ bönniꞌ luyú niꞌ ga lacquëꞌ bönniꞌ nadáꞌugac zxiꞌn xsuꞌ. Lusacaꞌ ziꞌë lequëꞌ gdu ca tap gayuáꞌ iz.” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lëzcaꞌ gudxëꞌ lëꞌ Dios: “Nedaꞌ usyudxaꞌ bunách luyú niꞌ, ga niꞌ lacquëꞌ bönniꞌ nadáꞌugac zxiꞌn xsuꞌ, atiꞌ töd niꞌ lurujëꞌ niꞌ, atiꞌ lunëꞌ xchinaꞌ luyú ni.” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios bénlenëꞌ Abraham didzaꞌ rucáꞌn tsahuiꞌ len gna béꞌinëꞌ lëꞌ gchuguëꞌ lu xpë́laꞌquëꞌ bönniꞌ nacuꞌë lidxëꞌ tu le gac bëꞌ nazíꞌ lu naꞌquëꞌ didzaꞌ naꞌ rucáꞌn tsahuiꞌ. Gdöd niꞌ guquëꞌ Abraham xuzbiꞌ biꞌi Isaac, len catiꞌ chgúquibiꞌ xunuꞌ gbidz, bchuguëꞌ lu xpë́laꞌbiꞌ lë naꞌ nac bëꞌ. Isaac naꞌ, lëzcaꞌ cni benëꞌ queëbiꞌ biꞌi Jacob, zxiꞌnëꞌ, len cni benëꞌ caꞌ Jacob quegac idxínnutëbiꞌ biꞌi bönniꞌ queëꞌ, nup niꞌ glac xuz xtauꞌgac idxinnu cöꞌ diꞌa dza quegac bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Xuz xtauꞌruꞌ naꞌ, lu yöl‑laꞌ ruzxeꞌi quequëꞌ, glútiꞌë‑biꞌ biꞌi José, bö́chiꞌquëꞌ, lu naꞌquëꞌ bönniꞌ niꞌ yjuaꞌquëꞌ‑biꞌ luyú Egipto. Dios gzóalenëꞌ‑biꞌ biꞌi José naꞌ ");
INSERT INTO zsrNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","len buslë́ꞌ‑biꞌ lu le glac queëbiꞌ. Dios bëꞌë‑biꞌ yöl‑laꞌ rejniꞌi, le ben ga bdzag ladxëꞌë‑biꞌ Faraón, bönniꞌ rna béꞌinëꞌ bunách Egipto, atiꞌ Faraón naꞌ budödëꞌ lu naꞌbiꞌ biꞌi José yöl‑laꞌ uná bëꞌ gna béꞌibiꞌ luyú Egipto len yúguꞌtë bunách nacuáꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Niꞌr guctsca gbin gdu luyú Egipto, len luyú Canaán ni, atiꞌ gulazacaꞌ gulaguíꞌi yúguꞌtë bunách dza niꞌ. Cutu bdzöli le lahuëꞌ xuz xtauꞌruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Catiꞌ byönnëꞌ Jacob dë zxoaꞌ xtil luyú Egipto, bsölëꞌë niꞌ yuguꞌ zxiꞌnëꞌ, bönniꞌ niꞌ nacquëꞌ xuz xtauꞌruꞌ. Cni guc le ziꞌal lzu yjaquëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Catiꞌ le buróp lzu yjaquëꞌ luyú Egipto, benëꞌ José ga guluúnbëꞌë lëꞌ böchëꞌë. Cni guc, gnöznëꞌ Faraón nup nacgac diꞌa dza queëꞌ José. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Niꞌr bsölëꞌë didzaꞌ José, benëꞌ ga bdxinëꞌ niꞌ Jacob, xuzëꞌ, dzaggac lëꞌ diꞌa dza queëꞌ, glac gdu tsonnlalj yu chinu bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Cni guc, bdxinëꞌ Jacob luyú Egipto, ga niꞌ gutiëꞌ lëꞌ, atiꞌ glatiëꞌ caꞌ niꞌ xuz xtauꞌruꞌ catiꞌ bzaꞌa dza quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Catiꞌ glatiëꞌ tu tu xuz xtauꞌruꞌ yjuaꞌquëꞌ lequëꞌ luyú Siquem yuguꞌ zxiꞌn xsoaquëꞌ, atiꞌ niꞌ gulucachëꞌë lequëꞌ yeru ba lu bloj naꞌ guꞌuëꞌ Abraham lu naꞌgac zxiꞌnëꞌ Hemor, bönniꞌ Siquem. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Gdöd zian iz, catiꞌ bdxin dza ral‑laꞌ gac le gzxiꞌ lu nëꞌë Dios, lë naꞌ benëꞌ tsutsu xtidzëꞌë gunëꞌ queëꞌ Abraham, gulayán bunách yuguꞌ cöꞌ zxiꞌn xsoëꞌ Israel, glac bunách zian catiꞌ niꞌ gulacuáꞌ luyú Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Niꞌr gyaziëꞌ bönniꞌ yubl gna bëꞌë luyú Egipto naꞌ, len gatga byönnëꞌ ca nac le benëꞌ José, gúclenëꞌ bunách Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gzxiꞌ yéꞌinëꞌ bunách uládz queëruꞌ bönniꞌ naꞌ rna bëꞌë. Busacaꞌ ziꞌë xuz xtauꞌruꞌ naꞌ len benëꞌ ga lusanëꞌ‑biꞌ biꞌi bönniꞌ huëꞌndauꞌ qui queëquëꞌ, quië latbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Laꞌ dza niꞌz guljbiꞌ caꞌ biꞌidauꞌ Moisés, atiꞌ bdzag ladxëꞌë‑biꞌ Dios. Gdu ca tsonn beoꞌ guluscul‑lëꞌ‑biꞌ xuz xnaꞌbiꞌ lidxquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Catiꞌ bdxin dza lusanëꞌ‑biꞌ xuz xnaꞌbiꞌ quië gatbiꞌ biꞌidauꞌ Moisés naꞌ, bdxinnu ngul zxiꞌnëꞌ Faraón ga niꞌ gulucaꞌnëꞌ‑biꞌ, atiꞌ yajxiꞌnu‑biꞌ len buscul‑lnu‑biꞌ ca biꞌi queëcznu. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Cni guc, bzëdbiꞌ biꞌi Moisés yúguꞌtë le taquëꞌ bönniꞌ Egipto len gúctërbiꞌ zxön ca nac didzaꞌ bëꞌbiꞌ len ca nacgac le benbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Catiꞌ chyuꞌubiꞌ choaꞌ iz biꞌi Moisés, gna ládxiꞌbiꞌ tsajyubiꞌ bunách uládz queëbiꞌ, bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Catiꞌ bdxinbiꞌ ga naꞌ nacuꞌë, bléꞌibiꞌ‑nëꞌ bönniꞌ Egipto, rusacaꞌ ziꞌë bönniꞌ uládz queëbiꞌ. Niꞌr gúclenbiꞌ‑nëꞌ bönniꞌ uládz queëbiꞌ naꞌ len budö́dibiꞌ‑nëꞌ bönniꞌ Egipto naꞌ. Cni guc, buzíꞌ labiꞌ bönniꞌ naꞌ biꞌi Moisés uláz queëꞌ bönniꞌ uládz queëbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Gúquibiꞌ Moisés hualaꞌyéjniꞌnëꞌ bönniꞌ bö́chiꞌbiꞌ gunëꞌ Dios ga uslabiꞌ lequëꞌ lëczbiꞌ, san lequëꞌ cutu gulayéjniꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yetú dza caꞌ yajxácaꞌbiꞌ yechopëꞌ bönniꞌ Israel, taꞌdil‑lëꞌ, atiꞌ gúꞌnibiꞌ cuequi dxibiꞌ lequëꞌ, len gudxbiꞌ lequëꞌ: “Lbiꞌiliꞌ, bö́chiꞌliꞌ nac. ¿Bizx quië ruaꞌliꞌ lzaꞌliꞌ döꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Niꞌr bönniꞌ naꞌ ruꞌë döꞌ qui lzëꞌë budxiguëꞌë‑biꞌ biꞌi Moisés, gnëꞌ: “¿Núzxatë buzóa liꞌ gna béꞌinuꞌ netuꞌ, len cuequi xbeynuꞌ le runtuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Naruꞌ rë́ꞌnitsanuꞌ gdödduꞌ caꞌ nedaꞌ ca benuꞌ nij, budödduꞌ‑nëꞌ bönniꞌ Egipto naꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Catiꞌ byö́nibiꞌ didzaꞌ ni biꞌi Moisés, buzxundjbiꞌ niꞌ, yajsoabiꞌ luyú Madián ga niꞌ gzoabiꞌ ca bönniꞌ ziꞌtuꞌ. Luyú Madián naꞌ butság náꞌlenbiꞌ‑nu ngul lu yödz niꞌ, atiꞌ guljcbiꞌ chopbiꞌ biꞌi bönniꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Catiꞌ chgdöd choaꞌ iz zoëꞌ niꞌ, buluíꞌ lahuëꞌ ga zoëꞌ gbaz laꞌy queëꞌ Dios lu guiꞌ qui yag yö́tsiꞌdauꞌ regui, ga niꞌ nac lu latj caꞌz, le zoa lu guiꞌa nazíꞌ lei Sinaí. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Catiꞌ bléꞌinëꞌ guiꞌ naꞌ Moisés, bubannëꞌ, atiꞌ gbiguëꞌë gal‑laꞌ quië gléꞌinëꞌ dxiꞌa, atiꞌ niꞌ byönnëꞌ chiꞌë Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Cni gudxëꞌ lëꞌ Xanruꞌ: “Nedaꞌ nacaꞌ Dios quequëꞌ xuz xtaꞌu. Nacaꞌ Dios queëꞌ Abraham, len Dios queëꞌ Isaac, len Dios queëꞌ Jacob.” Niꞌr lu yöl‑laꞌ radxi queëꞌ, gzxiztsquëꞌ Moisés, len cutur burúguinëꞌ uyúëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Gudxëꞌ lëꞌ Xanruꞌ: “Bleycj löluꞌ nudaꞌu, le nac laꞌy ga ni zuꞌ le zoaczaꞌ ni nedaꞌ, nacaꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Le nactë chbléꞌidaꞌ le taꞌzacaꞌ taꞌguíꞌi bunách quiaꞌ nacuáꞌ luyú Egipto, len chbyöndaꞌ taꞌbö́dx yechëꞌë. Bötjaꞌ, zoaꞌ ni quië usláꞌ lequëꞌ. Gda naꞌa, gsölaꞌa liꞌ luyú Egipto.” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Zal‑le gulucaꞌnëꞌ lëꞌ caꞌz bönniꞌ uládz queëꞌ Moisés, gulanë́ꞌ: “¿Núzxatë buzóa liꞌ gna béꞌinuꞌ netuꞌ, len cuequi xbeynuꞌ le runtuꞌ?”, Dios bsölëꞌë lëꞌ quië gaquëꞌ bönniꞌ uná bëꞌ, len bönniꞌ ruslá, ca naꞌ gudxëꞌ Moisés gbaz laꞌy naꞌ queëꞌ Dios, buluíꞌ lahuëꞌ lu yag yö́tsiꞌdauꞌ regui ga naꞌ zoëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés ni bubijëꞌ luyú Egipto bönniꞌ uládz queëruꞌ, guc cni gdöd benëꞌ le glun ga gulubani bunách niꞌ, len le tac bëꞌ benëꞌ luyú niꞌ. Lëzcaꞌ cni benëꞌ lu nis zxön nazíꞌ lei Nis Xna. Cni benëꞌ lauquëꞌ gdu ca choaꞌ iz lu latj caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Lëczëꞌ Moisés naꞌ gudxëꞌ bunách Israel niꞌ, gnëꞌ: “Xanruꞌ Dios gsölëꞌë queëliꞌ bönniꞌ galjëꞌ ladj diꞌa dza queëliꞌ, gaquëꞌ bönniꞌ guꞌë didzaꞌ uláz queëꞌ Dios. Gsölëꞌë lëꞌ queëliꞌ ca naꞌ bsölëꞌë nedaꞌ. Lëczëꞌ run bayúdx uzë́ nagliꞌ‑nëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lëzcaꞌ lëczëꞌ Moisés naꞌ gzóalenëꞌ bunách nudubgac queëꞌ Dios lu latj caꞌz, atiꞌ bdzaguëꞌ lëꞌ gbaz laꞌy queëꞌ Dios, nu naꞌ bëꞌlen lëꞌ didzaꞌ lu guiꞌa Sinaí naꞌ. Gzóalenëꞌ xuz xtauꞌruꞌ Moisés, atiꞌ Dios budödëꞌ lu nëꞌë zxba laꞌy queëꞌ, le ruiꞌ didzaꞌ ca gac laꞌdel‑liꞌ yöl‑laꞌ naꞌbán bunách, atiꞌ zxba ni budödëꞌ Moisés lu naꞌgac zxiꞌn xsoaquëꞌ ga rdxintë queëruꞌ rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Cutu glëꞌnnëꞌ xuz xtauꞌruꞌ lunëꞌ ca rna xtidzëꞌë Moisés, san guluzóëꞌ lëꞌ tslaꞌl, len glëꞌnnëꞌ tshuöjquëꞌ luyú Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Catiꞌ niꞌ zoëꞌ lu guiꞌa Sinaí naꞌ Moisés, lequëꞌ glëꞌ Aarón, böchëꞌë Moisés naꞌ, gulanë́ꞌ: “Rë́ꞌnituꞌ gunuꞌ yuguꞌ dios queëtuꞌ, bdauꞌ guiöj bdauꞌ yag, quië laꞌnö́r lautuꞌ. Cutu nö́zituꞌ bi guc queëꞌ Moisés, bönniꞌ naꞌ nubijëꞌ netuꞌ luyú Egipto.” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Niꞌr glunëꞌ tu bdauꞌ oro le nac ca tu bëdxdauꞌ, atiꞌ guludödcdëꞌ‑baꞌ böꞌcuꞌ zxílaꞌdauꞌ, len gulaguꞌquëꞌ‑baꞌ lau bdauꞌ oro naꞌ, atiꞌ glunëꞌ lni lau bdauꞌ naꞌ nunquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Qui lë ni naꞌ bucaꞌnëꞌ lequëꞌ Dios len bubíj ladxëꞌë lequëꞌ. Niꞌr gulayíj ládxiꞌquëꞌ le taꞌyë́p luzxbá. Ca nac lë ni nayúj lu guich le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, rna: Lbiꞌiliꞌ, bunách Israel, ¿Naruꞌ glúꞌgactsaliꞌ‑baꞌ quiaꞌ nedaꞌ böaꞌ bëdx niꞌ Budö́digacliꞌ‑baꞌ len buzéguiꞌgacliꞌ‑baꞌ, Lë naꞌ benliꞌ lu latj caꞌz gdu ca choaꞌ iz? ");
INSERT INTO zsrNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Cutu glúꞌgacliꞌ‑baꞌ quiaꞌ nedaꞌ, San biaꞌliꞌ nich qui Moloc, bdauꞌ guiöj queëliꞌ. Biaꞌliꞌ caꞌ tu le nac ca bölj luzxbá nazíꞌ lei Refán, Lë naꞌ buzoaliꞌ ca Dios queëliꞌ. Yuguꞌ bdauꞌ guiöj bdauꞌ yag ni, Laꞌ lbiꞌizliꞌ benliꞌ quië gyij ládxiꞌliꞌ leygac. Qui lë ni naꞌ, ubijaꞌ lbiꞌiliꞌ lu xyuliꞌ, Gchëꞌa lbiꞌiliꞌ ziꞌtuꞌr ga dë luyú Babilonia. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Catiꞌ niꞌ gulacuꞌë xuz xtauꞌruꞌ lu latj caꞌz, gutaꞌ quequëꞌ yuꞌu lariꞌ ga glun chiꞌë zxba queëꞌ Dios, lë naꞌ nac bëꞌ zóalenëꞌ lequëꞌ Dios. Glunëꞌ yuꞌu lariꞌ naꞌ ca naꞌ gna béꞌinëꞌ Moisés Dios, catiꞌ niꞌ gudxëꞌ lëꞌ gunëꞌ lei ca nac lë naꞌ bléꞌinëꞌ, le buluiꞌinëꞌ lëꞌ Dios lu guiꞌa niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lëzcaꞌ guludödëꞌ yuꞌu lariꞌ naꞌ lu naꞌquëꞌ zxiꞌnquëꞌ ga bdxintë dza niꞌ gluꞌë lei luyú ni xuz xtauꞌruꞌ, catiꞌ niꞌ dzaguëꞌ lequëꞌ Josué, atiꞌ gulagǘëꞌ xyugac bunách gzaꞌa, nup niꞌ bulaguëꞌë Dios lauquëꞌ xuz xtauꞌruꞌ. Cni glunëꞌ zian iz ga bdxintë dza zoëꞌ David. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Bdzag ladxëꞌë David naꞌ Dios, atiꞌ lëꞌ gnabnëꞌ Dios guꞌë lëꞌ latj gunëꞌ tu yuꞌu ga soëꞌ Dios queëꞌ Jacob. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Cutu bëꞌë lëꞌ latj Dios, san benëꞌ yuꞌu queëꞌ Dios Salomón, zxiꞌnëꞌ David naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Cni benëꞌ zal‑laꞌ cutu zoëꞌ Dios, Nu nactër blau, lu gdauꞌ nungac bunách. Ca nac lë ni gnëꞌ bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios, gnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yehuaꞌ yubá nac ga röꞌa rna bëꞌa Atiꞌ yödzlyú nac xlibi niꞌa. Rnëꞌ Xanruꞌ: “¿Naruꞌ gúntsaliꞌ lidxaꞌ? ¿Naruꞌ zoatsa latj ga ral‑laꞌ uzíꞌ ladxaꞌa? ");
INSERT INTO zsrNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Naruꞌ clëg len naꞌczaꞌ benaꞌ yúguꞌtë lë ni?” ");
INSERT INTO zsrNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Niꞌr gudxëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ Esteban, gnëꞌ: ―Lbiꞌiliꞌ, bönniꞌ zid, cutu bi ryaz icj nagliꞌ. Nazíd icj ládxiꞌdauꞌliꞌ ca rac quegac bunách cunúnbëꞌgac Dios. Rdáꞌbagaꞌteczliꞌ‑nëꞌ Dios Böꞌ Laꞌy. Ca naꞌ glunëꞌ xuz xtauꞌliꞌ, runliꞌ caꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gulabía ládxiꞌquëꞌ yúguꞌtë bönniꞌ niꞌ gluꞌë didzaꞌ uláz queëꞌ Dios xuz xtauꞌliꞌ naꞌ. Lëzcaꞌ guludödcdëꞌ bönniꞌ niꞌ gulaguíxjöꞌë ziꞌal ca ral‑laꞌ guidëꞌ Cristo, Bönniꞌ Tsahuiꞌ, atiꞌ naꞌa, catiꞌ niꞌ bdxinëꞌ Bönniꞌ Tsahuiꞌ naꞌ, lbiꞌiczliꞌ budödliꞌ‑nëꞌ lu naꞌquëꞌ bönniꞌ guludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lbiꞌiczliꞌ dë lu naꞌliꞌ zxba queëꞌ Dios, lë naꞌ guludödëꞌ lu naꞌquëꞌ xuz xtauꞌliꞌ yuguꞌ gbaz laꞌy queëꞌ Dios, san cutu runliꞌ ca rna. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Catiꞌ gulayönnëꞌ didzaꞌ ni bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, gulaléytsquinëꞌ Esteban, atiꞌ lu yöl‑laꞌ rley quequëꞌ lëꞌ gulutíl‑l láyiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Niꞌr buyúëꞌ luzxbál Esteban naꞌ, zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy, atiꞌ bléꞌinëꞌ latj yeníꞌ ga zoëꞌ Dios lencaꞌ Jesús, zuinëꞌ cuit lëꞌë yubél Dios ga náctërëꞌ blau. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Niꞌr gnëꞌ: ―Gul‑yutscaꞌ. Rléꞌidaꞌ nayálj luzxbá, atiꞌ zuinëꞌ cuit lëꞌë yubél Dios Bönniꞌ Nuhuöaquëꞌ Gdu Bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Niꞌr guluséyj nagquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, atiꞌ gulabödxyëꞌë zidzj, len tsazxö́n gulabía diꞌë lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Gulubijëꞌ lëꞌ niꞌl raꞌ yödz naꞌ, atiꞌ niꞌ gululadxëꞌ lëꞌ guiöj. Yuguꞌ bönniꞌ niꞌ tunëꞌ lnaꞌ lau le tuꞌquíëꞌ Esteban gulucuꞌë lariꞌ taꞌxóa yenquëꞌ xniꞌë bönniꞌ lëꞌ Saulo catiꞌ niꞌ gululadxëꞌ Esteban guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Catiꞌ niꞌ tuꞌladxëꞌ Esteban guiöj, lëꞌ bulidzëꞌ Dios, gnëꞌ: ―Xanaꞌ Jesús. Buzíꞌ böꞌ nacczaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Niꞌr byechuëꞌ, buzechu zxibëꞌ, len bëꞌë zidzj didzaꞌ, gnëꞌ: ―Xan. Cutu uspaguꞌu lequëꞌ dul‑laꞌ ni. Catiꞌ budx bëꞌë didzaꞌ ni, guttëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Saulo benëꞌ tsazxö́n bönniꞌ niꞌ guludöddëꞌ Esteban. Laꞌ niꞌz gluaꞌquëꞌ Esteban bönniꞌ taꞌyíj ládxiꞌquëꞌ Dios, atiꞌ yajcáchiꞌquëꞌ lëꞌ. Szxöni gulabödxëꞌ queëꞌ. Dza naꞌ szxöni gulabía ládxiꞌquëꞌ bunách queëꞌ Cristo nacuáꞌ Jerusalén bönniꞌ judío cutaꞌyejlëꞌ. Lëzcaꞌ gdxia ladxëꞌë bunách queëꞌ Cristo Saulo. Gyaziëꞌ gap nac lu yuꞌu quequëꞌ, atiꞌ gzxönëꞌ yuguꞌ bönniꞌ len ngul, gluꞌë lequëꞌ lidx guia. Niꞌr glaslas gdu luyú Judea len luyú Samaria yelatiꞌz cuguluhuöatë bunách queëꞌ Cristo, atiꞌ gulugaꞌnëꞌ Jerusalén légaczëꞌ gbaz naꞌ nasölëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yjaquëꞌ yúguꞌtë latj bönniꞌ naꞌ gláslasiëꞌ, atiꞌ glunëꞌ lban qui didzaꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Niꞌr gyijëꞌ luyú Samaria Felipe, bönniꞌ dzaguëꞌ nup naꞌ glaslas, atiꞌ niꞌ benëꞌ lban ca nac queëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Guludúb bunách niꞌ, atiꞌ gdu ládxiꞌquëꞌ guluzë́ nagquëꞌ didzaꞌ ruꞌë Felipe naꞌ, le gulayönnëꞌ xtidzëꞌë len gulaléꞌinëꞌ le tac bëꞌ runëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Cni guc, le benëꞌ ga gulurúj zian böꞌ xöhuiꞌ yuꞌugac bunách, taꞌbödxyaꞌa zidzj, atiꞌ guluhuöác zian nup teꞌi huëꞌ nacúꞌn bin len nup cutaꞌzáꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Cni guc, guludziji bunách yödz niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Zoëꞌ niꞌ Simón, bönniꞌ ziꞌal guquëꞌ bönniꞌ udzáꞌ unë́ yaꞌa lu yödz naꞌ, len gzxiꞌ yéꞌinëꞌ bunách Samaria naꞌ, gnëꞌ lëczëꞌ naquëꞌ bönniꞌ náctërëꞌ zxön. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Guluzëtsca naggac bönniꞌ ni yúguꞌtë bunách, ga rguel‑laꞌ yuguꞌ bönniꞌ caꞌz ga rdxintë yuguꞌ bönniꞌ blau, gulanë́ꞌ: “Bönniꞌ ni, dë lu nëꞌë yöl‑laꞌ huac zxön queëꞌ Dios.” ");
INSERT INTO zsrNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Cni guc, glunëꞌ lëꞌ ba laꞌn, le xtsey nazíꞌ yéꞌinëꞌ lequëꞌ len yöl‑laꞌ udzáꞌ unë́ yaꞌa queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Catiꞌ gulayejlëꞌë lban runëꞌ Felipe qui didzaꞌ dxiꞌa ca rna bëꞌë Dios len ca nac queëꞌ Jesucristo, niꞌr guladilëꞌ nis, bönniꞌ len ngul. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Niꞌr gyejlëꞌë caꞌ Simón naꞌ, len bdilëꞌ nis, atiꞌ gdálenteczëꞌ tsazxö́n Felipe naꞌ. Catiꞌ bléꞌinëꞌ yuguꞌ yöl‑laꞌ huac zxön len le tac bëꞌ runëꞌ Felipe, bubannëꞌ Simón naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Catiꞌ gulayönnëꞌ ca guc lë ni gbaz naꞌ nasölëꞌë Cristo nacuꞌë Jerusalén, chnazíꞌ lu naꞌgac xtidzëꞌë Dios bunách luyú Samaria, niꞌr gulasölëꞌë niꞌ Pedro len Juan. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Catiꞌ guladxinëꞌ niꞌ Pedro len Juan naꞌ, gululidzëꞌ Dios uláz quegac bunách niꞌ taꞌyejlëꞌ Cristo quië dusóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ga bdxintë dza naꞌ, cutu rdxíninëꞌ quequëꞌ Dios Böꞌ Laꞌy. Nadílgaczëꞌ nis quië lacquëꞌ tuz len Xanruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Niꞌr gulaxóa naꞌquëꞌ bunách Samaria naꞌ Pedro len Juan naꞌ. Gululidzëꞌ Dios, atiꞌ dusóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Catiꞌ bléꞌinëꞌ Simón, bönniꞌ udzáꞌ naꞌ, le guc catiꞌ gulaxóa naꞌquëꞌ bunách niꞌ gbaz naꞌ nasölëꞌë Cristo, dusóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy, guꞌnnëꞌ quizxjëꞌ lequëꞌ dumí, ");
INSERT INTO zsrNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","rëꞌ lequëꞌ: ―Benn caꞌ quiaꞌ yöl‑laꞌ huac ni, quië catiꞌ gxoa naꞌa nútiꞌtëz bunách, dusóalenëꞌ nu naꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Niꞌr gudxëꞌ lëꞌ Pedro, rnëꞌ: ―Nit tsazxö́n len liꞌ dumí quiuꞌ, le ráquinuꞌ len dumí gdél‑liꞌnuꞌ yöl‑laꞌ huac queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Cutu nacuꞌ lsacaꞌ gutsuꞌu lë ni, le cunác dxiꞌa icj ládxiꞌdaꞌu lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bubíꞌi ladxuꞌu ca nac huiaꞌdöꞌ ni runuꞌ, len gútaꞌyu lahuëꞌ Dios, nazx caꞌ unít lahuëꞌ liꞌ ca nac lë ni rzaꞌ ladxuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Rléꞌidaꞌ nabaguꞌu zxguiaꞌ len nadzunuꞌ lu yal‑lj qui tuꞌ xöhuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Niꞌr bubiꞌë didzaꞌ Simón naꞌ, rëꞌ lequëꞌ: ―Gul‑lidzëꞌ Dios, gátaꞌyuliꞌ lahuëꞌ Xanruꞌ niꞌa quiaꞌ cui gac quiaꞌ nitú lë naꞌ chgnaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Catiꞌ budx glunëꞌ lnaꞌ lau queëꞌ Cristo lu yödz niꞌ Pedro len Juan naꞌ, len gulaguíxjöꞌë xtidzëꞌë Dios, glunëꞌ caꞌ lban qui didzaꞌ dxiꞌa gap nacuáꞌ zian ladzquëꞌ bönniꞌ Samaria, atiꞌ gdöd niꞌ yhuöjquëꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Niꞌr bë́ꞌlenëꞌ Felipe didzaꞌ gbaz laꞌy queëꞌ Xanruꞌ, gudxëꞌ lëꞌ: ―Gyas len gyeaj zacaꞌ ga rdöd gbidz beoꞌ ziag, gdxinuꞌ ga niꞌ rlaꞌa nöz zeaj Jerusalén zeajtë yödz Gaza, nöz naꞌ rdöd lu latj caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Niꞌr gyuꞌë nöz Felipe naꞌ, zijëꞌ. Laꞌ nöz niꞌ yajtsaguëꞌ bönniꞌ Etiopía, naquëꞌ bönniꞌ huödx. Luyú Etiopía naquëꞌ blau launu Candace, ngul rna béꞌinu bunách Etiopía naꞌ, len yuꞌu lu nëꞌë yúguꞌtë yöl‑laꞌ tsahuiꞌ queënu dzöꞌ lidxnu. Gyijëꞌ Jerusalén bönniꞌ ni quië gyij ladxëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Naꞌa, zhuöjëꞌ ladzëꞌ, röꞌë lu carreta queëꞌ, len rulabëꞌ le nayúj lu guich ca gnëꞌ Isaías, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Niꞌr Dios Böꞌ Laꞌy gudxëꞌ Felipe naꞌ: ―Gbigaꞌ ga zeaj carreta naꞌ, len gyeajlen lei. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Catiꞌ chgbiguëꞌë niꞌ Felipe, byönnëꞌ ruꞌë didzaꞌ bönniꞌ huödx naꞌ, rulabëꞌ le nayúj lu guich ca gnëꞌ Isaías, atiꞌ gudxëꞌ lëꞌ: ―¿Naruꞌ réjniꞌnuꞌ lë naꞌ rulabuꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Bubiꞌë didzaꞌ bönniꞌ Etiopía naꞌ, gnëꞌ: ―¿Nacx gac tséjniꞌdaꞌ chquiꞌ nutu nu zoa uzejniꞌi nedaꞌ? Niꞌr gútaꞌyuëꞌ lahuëꞌ Felipe cuenëꞌ len cö́ꞌlenëꞌ lëꞌ tsazxö́n lu carreta naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lë naꞌ nayúj lu guich rulabëꞌ, rna cni: Ca böꞌcuꞌ zxílaꞌdauꞌ, Gulachë́ꞌë Lëꞌ quië ludöddëꞌ Lëꞌ, Len ca böꞌcuꞌ zxílaꞌdauꞌ, Cutu rnëbaꞌ catiꞌ nu rchugu lítsaꞌbaꞌ, Caꞌ benëꞌ Lëꞌ, cutu bsalj ruꞌë gnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gulucaꞌnëꞌ Lëꞌ caꞌz, Len cutu gluꞌë latj nu cuequi xbey Lëꞌ. ¿Nuzxa caz gac quixjöꞌ zxguiaꞌ nabágaꞌgac bunách uládz queëꞌ? Laꞌ légaczëꞌ guludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Gnabnëꞌ Felipe bönniꞌ huödx naꞌ, rëꞌ lëꞌ: ―Rátaꞌyuaꞌ lauꞌ quíxjöiꞌnuꞌ nedaꞌ. ¿Nuzxa qui gnëꞌ cni bönniꞌ naꞌ bëꞌë didzaꞌ uláz queëꞌ Dios? ¿Naruꞌ queëczëꞌ, o qui nu yubl? ");
INSERT INTO zsrNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Niꞌr laꞌ didzaꞌ niz bguel‑lëꞌë Felipe, gdíxjöiꞌnëꞌ lëꞌ didzaꞌ dxiꞌa ca nac queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Catiꞌ niꞌ yuꞌuquëꞌ nöz zjaquëꞌ, guladxinëꞌ ga dë nis, atiꞌ rëꞌ Felipe bönniꞌ huödx naꞌ, rnëꞌ: ―Byutscaꞌ. Ni dë nis. ¿Naruꞌ huactsa gdilaꞌ nis? ");
INSERT INTO zsrNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe gudxëꞌ lëꞌ: ―Chquiꞌ réjlëꞌu gdu ladxuꞌu, huac gdiluꞌ nis. Lëꞌ bubiꞌë didzaꞌ, rnëꞌ: ―Réjlëꞌa Jesucristo, naquëꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Niꞌr benëꞌ ga gzoa dxiz carreta queëꞌ naꞌ, atiꞌ guluhuötjëꞌ groptëꞌ, yajtsazquëꞌ lu nis. Niꞌr Felipe buquilëꞌ bönniꞌ huödx naꞌ nis. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Catiꞌ gulurujëꞌ lu nis, buchë́ꞌë Felipe Dios Böꞌ Laꞌy, atiꞌ cutur bléꞌinëꞌ lëꞌ bönniꞌ huödx naꞌ. Niꞌr buguel‑lëꞌë xnözëꞌ, zhuöjëꞌ rudzijnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Catiꞌ chráquibeꞌinëꞌ Felipe, zoëꞌ lu yödz Azoto. Gdödëꞌ yúguꞌtë yödz niꞌ, atiꞌ benëꞌ lban qui didzaꞌ dxiꞌa, ga bdxintëꞌ yödz Cesarea. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Niꞌ ruzeynëꞌ ba nadx nup taꞌyejlëꞌ Xanruꞌ Saulo, guꞌnnëꞌ gdödcdëꞌ lequëꞌ. Quië gunëꞌ cni bdxinëꞌ lahuëꞌ bxuz blau ");
INSERT INTO zsrNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","len gnabnëꞌ lëꞌ guich uná bëꞌ le tsjuꞌë lauquëꞌ bönniꞌ uná bëꞌ quegac yuꞌu gap tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío nacuꞌë Damasco, atiꞌ chquiꞌ utsajxaquëꞌë niꞌ yuguꞌ bönniꞌ len ngul taꞌyejlëꞌë Jesús, gac gchëꞌë lequëꞌ nadzunquëꞌ lu yödz Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tsal niꞌ yuꞌuquëꞌ nöz Saulo len nup nacuaꞌlen lëꞌ, zjaquëꞌ, len catiꞌ chzoa laꞌdxinëꞌ Damasco, tu tsalz buzeniꞌtsca yeníꞌ zaꞌ luzxbá, le buzeníꞌ ga niꞌ zjaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Niꞌr gdzöꞌë lyu Saulo, len byönnëꞌ chiꞌi nu rë lëꞌ: ―Saulo, Saulo, ¿bizx quië rbia ladxuꞌu nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Gnabnëꞌ Lëꞌ Saulo, gnëꞌ: ―¿Nuzxa liꞌ, Xan? Lëꞌ gnëꞌ: ―Nedaꞌ Jesús, nu rbia ladxuꞌu. Run ziꞌ cuinuꞌ, rdáꞌbaguꞌu nedaꞌ. Rac quiuꞌ ca naꞌ rac queëbaꞌ bëdx, run ziꞌ cuinbaꞌ rchéguꞌbaꞌ yag tuchiꞌ tundëꞌ‑baꞌ ziꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Niꞌr gzxiztsquëꞌ, gúdxinëꞌ Saulo, gnëꞌ: ―Xan, ¿bizxa rëꞌnnuꞌ gunaꞌ? Xanruꞌ gudxëꞌ lëꞌ: ―Gyas len gyaz lu yödz, atiꞌ niꞌ gsölaꞌa quiuꞌ nu guië liꞌ le ral‑laꞌ gunuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gládxinëꞌ bönniꞌ naꞌ zjáclenëꞌ Saulo, le gulayönnëꞌ chiꞌi naꞌ, zal‑le nutu nu gulaléꞌinëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Niꞌr böasëꞌ luyú Saulo, len catiꞌ gxaꞌ yöj lahuëꞌ, cutu caꞌ rléꞌinëꞌ. Qui lë ni naꞌ gulaguel‑lëꞌë nëꞌë, len gulachë́ꞌë lëꞌ Damasco. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Gzoëꞌ niꞌ tsonn dza nachúl lahuëꞌ, len cutu bi güiꞌ gdahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Zoëꞌ caꞌ Damasco Ananías, bönniꞌ rejlëꞌë Cristo, atiꞌ Xanruꞌ buluíꞌ lahuëꞌ ga zoëꞌ ca tu lu yël bëchcál, len gudxëꞌ lëꞌ: ―Ananías. Lëꞌ bubiꞌë didzaꞌ, gnëꞌ: ―Ni zoaꞌ, Xan. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xanruꞌ gudxëꞌ lëꞌ: ―Gyas, len gyeaj ga nac laꞌ nöz naꞌ nazíꞌ lei Nöz Li, atiꞌ lu yuꞌu lidxëꞌ Judas gnab didzaꞌ queëꞌ Saulo, bönniꞌ Tarso. Lu yuꞌu naꞌ rulidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Chbléꞌinëꞌ bönniꞌ ni ca tu lu yël bëchcál zëꞌë tsaziëꞌ ga zoëꞌ bönniꞌ lëꞌ Ananías, len gxoa nëꞌë lëꞌ quië huöalj yöj lahuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Niꞌr bubiꞌë didzaꞌ Ananías, rëꞌ Lëꞌ: ―Xan, zian nup chgulaguixjöiꞌ nedaꞌ ca runëꞌ bönniꞌ ni, zian le nac döꞌ nuꞌë le benëꞌ quegac bunách taꞌyejlëꞌ Liꞌ, nacuꞌë Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Zëꞌë caꞌ ni, dë lu nëꞌë uláz quequëꞌ bxuz uná bëꞌ sönëꞌ yúguꞌtë nup tuꞌlídz Dios len lauꞌ Liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Niꞌr Xanruꞌ rëꞌ Ananías naꞌ, rnëꞌ: ―Gyeaj, le gröczaꞌ nedaꞌ bönniꞌ ni quië gunëꞌ lban ca nac quiaꞌ laugac bunách gzaꞌa, len lauquëꞌ bönniꞌ taꞌná béꞌinëꞌ lequëꞌ, lencaꞌ laugac bunách Israel. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Uluiꞌidaꞌ lëꞌ le zian le sacaꞌ quiꞌë uláz quiaꞌ nedaꞌ, gunëꞌ xchinaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Niꞌr gyijëꞌ niꞌ Ananías, atiꞌ gyaziëꞌ yuꞌu len bxoa nëꞌë Saulo, rëꞌ lëꞌ: ―Böchaꞌa Saulo, Xanruꞌ Jesús, Nu naꞌ buluíꞌ lahui laꞌ nöz ga niꞌ zaꞌu, bsölëꞌë nedaꞌ quië huöalj yöj lauꞌ len dusóalenëꞌ liꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Laꞌ niꞌz gulaguíndj lu yöj lahuëꞌ le nac ca xlácubaꞌ böl, atiꞌ laꞌ böaljtë yöj lahuëꞌ. Niꞌr gyasëꞌ Saulo, len bdilëꞌ nis. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Gdöd niꞌ gdahuëꞌ len böac ladxëꞌë. Ca chop tsonn dza gzóalenëꞌ bönniꞌ taꞌyejlëꞌë Cristo nacuꞌë Damasco. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Laꞌ gzu lautëꞌ Saulo runëꞌ lban queëꞌ Cristo gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, rnëꞌ: ―Jesúscz naquëꞌ Zxiꞌnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Gulubannëꞌ yúguꞌtë bönniꞌ niꞌ taꞌyönnëꞌ lëꞌ, taꞌnë́ꞌ: ―¿Naruꞌ clëg bönniꞌ ni bönniꞌ naꞌ busnitiëꞌ nup nacuáꞌ Jerusalén, tuꞌlídz Dios lu lëꞌ Jesús? Quië gunëꞌ cni bidëꞌ caꞌ ni quië gchëꞌë lequëꞌ nadzunquëꞌ lauquëꞌ bxuz uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bdipr ladxëꞌë Saulo, len benëꞌ ga gulaböꞌë baguíꞌi bönniꞌ judío nacuꞌë Damasco, buluiꞌinëꞌ lequëꞌ Jesúscz naquëꞌ Cristo, bönniꞌ naꞌ tunëꞌ löz duná béꞌinëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Catiꞌ chgdöd zian dza, glun xtídzaꞌquëꞌ bönniꞌ judío niꞌ ludöddëꞌ Saulo. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Rël len të dza gulabö́ꞌ nisiëꞌ lëꞌ bönniꞌ judío ga nu ryaz zöꞌö run chiꞌi yödz naꞌ quië ludöddëꞌ lëꞌ, san gúquibeꞌinëꞌ Saulo le tëꞌnnëꞌ lunëꞌ queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Niꞌr gulaguel‑lëꞌë Saulo chdzöꞌl bönniꞌ taꞌyejlëꞌë Cristo, atiꞌ gulaguꞌë lëꞌ tu lu bdöꞌa zxön nagaꞌ du, len guluzötjëꞌ lëꞌ niꞌl lu zöꞌö run chiꞌi yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Catiꞌ budxinëꞌ Saulo Jerusalén, guꞌnnëꞌ tsjenëꞌ tsazxö́n bönniꞌ niꞌ taꞌyejlëꞌë Cristo, san gládxinëꞌ lëꞌ yúguꞌtëꞌ, le cutaꞌyejlëꞌë rejlëꞌë Cristo Saulo naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Niꞌr gdel‑lëꞌë Saulo Bernabé, len bchëꞌë lëꞌ ga naꞌ nacuꞌë gbaz nasölëꞌë Cristo. Gdíxjöiꞌnëꞌ lequëꞌ ca naꞌ guc queëꞌ Saulo, bléꞌinëꞌ Xanruꞌ laꞌ nöz, atiꞌ bë́ꞌlenëꞌ lëꞌ didzaꞌ Xanruꞌcz, len ca naꞌ benëꞌ Saulo lu yödz Damasco, len yöl‑laꞌ rugu ladxiꞌ benëꞌ lban ca nac queëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Niꞌr gzóalenëꞌ lequëꞌ Saulo lu yödz Jerusalén, atiꞌ gdálenëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lu yöl‑laꞌ rugu ladxiꞌ benëꞌ lban Saulo ca nac queëꞌ Xanruꞌ, len gdíl‑lenëꞌ didzaꞌ bönniꞌ judío tuꞌë didzaꞌ griego, atiꞌ lequëꞌ gulazú gulaböꞌë ludöddëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Catiꞌ gláquibeꞌinëꞌ lë ni bö́chiꞌruꞌ taꞌyejlëꞌë Cristo, gulachë́ꞌë Saulo lu yödz Cesarea, atiꞌ gulasölëꞌë lëꞌ Tarso, le nac ladzëꞌ Saulo. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Niꞌr guc dxiꞌa quegac yúguꞌtë cöꞌ bunách queëꞌ Cristo, nacuáꞌ gdu luyú Judea, len luyú Galilea, len luyú Samaria, atiꞌ guladíp ládxiꞌquëꞌ. Gulacuꞌë lu yöl‑laꞌ radxi quequëꞌ Xanruꞌ, atiꞌ gulayanëꞌ le gúclenëꞌ lequëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Yetú le guc, catiꞌ yajyúëꞌ yuguꞌ bö́chiꞌruꞌ Pedro, bdxinëꞌ ga nacuꞌë bönniꞌ taꞌyejlëꞌë Jesús lu yödz Lida. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yajxaquëꞌë niꞌ bönniꞌ lëꞌ Eneas, chguc xunuꞌ iz dëꞌ réꞌinëꞌ nacuꞌnëꞌ bin. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro gudxëꞌ lëꞌ: ―Eneas, ruúnëꞌ liꞌ Jesucristo. Gyas len btub xtaꞌu. Laꞌ gyastëꞌ Eneas naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Gulaleꞌi lëꞌ yúguꞌtë nup nacuáꞌ yödz Lida, len yödz Sarón, atiꞌ guluhuöaquëꞌ queëꞌ Xanruꞌ, taꞌyejlëꞌë Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yetú caꞌ le guc, lu yödz Jope zoanu ngul réjlëꞌnu Cristo, lënu Tabita, len ca nac didzaꞌ griego lënu Dorcas. Bennu zian le nacgac dxiꞌa len le taclen bunách yechiꞌ ngul ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Le guc dza niꞌ, güiꞌinu Dorcas naꞌ len gutnu. Gdöd gulaguibnu lënu, gulaguixjëꞌ‑nu tu lu yuꞌu ga nac buróp cuia. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Le dë gal‑laꞌz ga naꞌ dë yödz Jope yödz Lida ga naꞌ zoëꞌ Pedro, gulayönnëꞌ zoëꞌ niꞌ Pedro bönniꞌ Jope naꞌ taꞌyejlëꞌë Cristo, atiꞌ qui lë ni naꞌ gulasölëꞌë ga zoëꞌ chopëꞌ bönniꞌ, glátaꞌyuëꞌ lahuëꞌ, tëꞌ lëꞌ: ―Cutu tseynuꞌ guiduꞌ queëtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Niꞌr laꞌ gyastëꞌ Pedro, zéajlenëꞌ lequëꞌ. Catiꞌ bdxinëꞌ niꞌ, laꞌ gulachëꞌtëꞌ lëꞌ ga nac lu yuꞌu ga dënu ngul nat naꞌ. Niꞌr guludubnu gdu cuitiëꞌ ngul uzë́b, taꞌbödxnu len tuꞌluiꞌinu lëꞌ lariꞌ quequëꞌ bönniꞌ len ngul, yuguꞌ le bennu Dorcas catiꞌ niꞌ zóalennu lecnu. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Niꞌr bubijëꞌ niꞌl yúguꞌtë nup nacuáꞌ niꞌ Pedro, atiꞌ buzechu zxibëꞌ, rulidzëꞌ Dios. Niꞌr bueycjëꞌ ga dënu Dorcas naꞌ, gnëꞌ: ―Tabita, gyas. Laꞌ buxaꞌtë yöj launu Dorcas. Catiꞌ bléꞌinu‑nëꞌ Pedro, laꞌ gyástënu, gröꞌnu. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Gdel‑lëꞌë naꞌnu Pedro, buchisëꞌ‑nu. Niꞌr bulidzëꞌ bönniꞌ naꞌ taꞌyejlëꞌë Jesús, len yuguꞌ ngul uzë́b naꞌ, atiꞌ buschinëꞌ‑nu lauquëꞌ Dorcas naꞌ, nabannu. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ca guc lë ni gzë didzaꞌ gdu lu yödz Jope, atiꞌ gulayejlëꞌ Xanruꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Zian dza bugaꞌnëꞌ Pedro yödz Jope naꞌ lu yuꞌu lidxëꞌ Simón, bönniꞌ runëꞌ tsahuiꞌ guid zxa bëdx. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Zoëꞌ Cesarea bönniꞌ lëꞌ Cornelio, nacuꞌë lu nëꞌë tu gayuꞌë bönniꞌ rjaquëꞌ gdil‑l, nazíꞌ laquëꞌ Bönniꞌ Italia Rjaquëꞌ Gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rej ladxëꞌë Dios Cornelio naꞌ len rádxinëꞌ Lëꞌ, atiꞌ nungac lëꞌ tsazxö́n yúguꞌtë bunách nacuáꞌ lidxëꞌ. Dumí zian runödzjëꞌ le raclen bunách yechiꞌ, len rulídzteczëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gdu rdöd xhuö bléꞌinëꞌ Cornelio ca tu lu yël bëchcál, ryaziëꞌ ga zoëꞌ gbaz laꞌy queëꞌ Dios, len rëꞌ lëꞌ: ―Cornelio. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gúdxinëꞌ Cornelio. Buyúëꞌ gbaz laꞌy naꞌ, len gudxëꞌ lëꞌ: ―¿Bizxa rnauꞌ, Xan? Gudxëꞌ lëꞌ gbaz laꞌy naꞌ, rnëꞌ: ―Dios ryönnëꞌ le rulidzuꞌ‑nëꞌ, len nözcznëꞌ ca runuꞌ, ráclenuꞌ bunách yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Naꞌa, gsö́laꞌcuꞌ‑nëꞌ bönniꞌ tsjaquëꞌ yödz Jope tsajlidzquëꞌ bönniꞌ lëꞌ Simón, zoa yetú lëꞌ Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Bönniꞌ ni zoëꞌ lidxëꞌ bönniꞌ runëꞌ tsahuiꞌ guid zxa bëdx. Bönniꞌ ni, lëzcaꞌ lëꞌ Simón, atiꞌ zoa lidxëꞌ raꞌ nis zxön. Pedro naꞌ guiëꞌ liꞌ le ral‑laꞌ gunuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Catiꞌ chbuzë́ꞌë gbaz laꞌy naꞌ bë́ꞌlenëꞌ lëꞌ didzaꞌ, bulidzëꞌ‑biꞌ Cornelio chopbiꞌ biꞌi huen dxin queëꞌ len tuëꞌ bönniꞌ rijëꞌ gdil‑l rej ladxëꞌë Dios, dzaguëꞌ bunách nacuáꞌ lidxëꞌ Cornelio. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Catiꞌ budx gdíxjöiꞌnëꞌ lequëꞌ yúguꞌtë le guc, bsölëꞌë lequëꞌ yödz Jope. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Dza buróp, tsal niꞌ yuꞌuquëꞌ nöz, len taꞌdxinëꞌ gal‑laꞌ ga dë Jope naꞌ, laꞌ niꞌz grenëꞌ Pedro cjuꞌu quië ulidzëꞌ Dios, niꞌ nac gdu huagbídz. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Laꞌ naꞌz rdunëꞌ Pedro len guꞌnnëꞌ gahuëꞌ, san tsal niꞌ tuꞌpë́ꞌë queëꞌ, bléꞌinëꞌ le nac ca tu lu yël bëchcál. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bléꞌinëꞌ nayálj luzxbá len ruhuö́tj ga zoëꞌ tu le nac ca lariꞌ guitsaꞌ zxön, nagaꞌ idáp laꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lahui lariꞌ naꞌ dxiacbaꞌ böaꞌ guixiꞌ gzaꞌa nacuáꞌ tap niꞌa naꞌcbaꞌ, len böaꞌ taꞌyj lëꞌcbaꞌ lyu, len böaꞌ zoa xilcbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Niꞌr byönnëꞌ chiꞌi nu rë lëꞌ: ―Pedro, gyas. Bdödi‑cbaꞌ len gdagu. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bubiꞌë didzaꞌ Pedro, rnëꞌ: ―Cutu, Xan. Gatga gdahuaꞌ le cural‑laꞌ gágutuꞌ o le cunác dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Le buróp lzu byönnëꞌ chiꞌi nu naꞌ gudx lëꞌ: ―Le nunëꞌ dxiꞌa Dios, cutu gnauꞌ qui: “Cunác dxiꞌa”. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tsonn lzu guc cni, atiꞌ niꞌr laꞌ buëptë luzxbá lariꞌ zxön naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tsal niꞌ röꞌë baguíꞌi Pedro, rzaꞌ ladxëꞌë bizxa rëꞌni gna lë naꞌ bléꞌinëꞌ ca tu lu yël bëchcál, guladxinëꞌ raꞌ yuꞌu bönniꞌ naꞌ nasölëꞌë lequëꞌ Cornelio, taꞌnabëꞌ gazx zoa lidxëꞌ Simón naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Catiꞌ guladxinëꞌ niꞌ, gululidzëꞌ nup nacuáꞌ yuꞌu naꞌ, len gulanabnëꞌ lequëꞌ chquiꞌ zoëꞌ niꞌ bönniꞌ lëꞌ Simón, zoa yetú lëꞌ Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tsal niꞌ rzaꞌ ladxëꞌë Pedro ca nac lë naꞌ bléꞌinëꞌ, gudxëꞌ lëꞌ Dios Böꞌ Laꞌy, gnëꞌ: ―Byutscaꞌ. Chguladxinëꞌ ni tsonnëꞌ bönniꞌ, tuꞌguiljëꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gyasch naꞌa. Bötj zxan yuꞌu. Cutu gac chop ladxuꞌu tséajlenuꞌ lequëꞌ, le nasölaꞌa lequëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Niꞌr bötjëꞌ Pedro zxan yuꞌu ga naꞌ nacuꞌë bönniꞌ naꞌ nasölëꞌë Cornelio, len gudxëꞌ lequëꞌ: ―Nedaꞌ bönniꞌ ruguiljliꞌ. ¿Bizxa huen zaꞌliꞌ ni? ");
INSERT INTO zsrNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gulubiꞌë didzaꞌ, tëꞌ lëꞌ: ―Nasölëꞌë netuꞌ Cornelio, bönniꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l. Naquëꞌ bönniꞌ tsahuiꞌ, len rádxinëꞌ Dios. Tunëꞌ ba laꞌn bönniꞌ ni len nadxiꞌicnëꞌ lëꞌ yúguꞌtë bönniꞌ judío. Yetú caꞌ le guc, bë́ꞌlenëꞌ lëꞌ didzaꞌ gbaz laꞌy queëꞌ Dios, gudxëꞌ lëꞌ gsölëꞌë nu dulídz liꞌ guiduꞌ lidxëꞌ quië yönnëꞌ didzaꞌ guꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Niꞌr gluꞌë lequëꞌ lu yuꞌu Pedro len bëꞌë ga laꞌcuꞌë. Catiꞌ zaꞌ reníꞌ yetú dza, gyasëꞌ Pedro, atiꞌ gyéajlenëꞌ lequëꞌ. Glunëꞌ lëꞌ tsazxö́n laꞌquëꞌ bö́chiꞌruꞌ nacuꞌë Jope naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dza bunn niꞌ, guladxinëꞌ Cesarea. Chzoëꞌ rbözëꞌ lequëꞌ Cornelio, len chnutubëꞌ lidxëꞌ yuguꞌ diꞌa dza queëꞌ, len yuguꞌ böchiꞌ lzëꞌë nadxiꞌirnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Catiꞌ gyaziëꞌ Pedro löꞌa, brujëꞌ yuꞌu Cornelio, yajtsaguëꞌ lëꞌ. Byechuëꞌ xniꞌë Pedro len gyij ladxëꞌë lëꞌ ca runruꞌ queëꞌ Dioscz. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro buchisëꞌ lëꞌ, len gudxëꞌ lëꞌ: ―Gyas. Lëz bunách yödzlyú nacaꞌ ca nacuꞌ liꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Niꞌ tuiꞌzëꞌ caꞌ didzaꞌ, gyaztëꞌ yuꞌu Pedro, len yajxaquëꞌë nudubgac niꞌ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Niꞌr gudxëꞌ lequëꞌ Pedro, rnëꞌ: ―Lbiꞌiliꞌ nö́ziczliꞌ ca rna bëꞌ zxba queëꞌ Moisés, cural‑laꞌ gunëꞌ bönniꞌ judío tsazxö́n o tsázlenëꞌ bönniꞌ gzaꞌa. Naꞌa, Dios buluiꞌinëꞌ nedaꞌ cutu ral‑laꞌ gniaꞌ queëꞌ nitúëꞌ bönniꞌ naquëꞌ caꞌz o cunaquëꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Qui lë ni naꞌ catiꞌ bulidzliꞌ nedaꞌ, laꞌ bidteaꞌ, len cutu guc chop ladxaꞌa. Rnabaꞌ naꞌa, ¿bizx quië naꞌ bulidzliꞌ nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Niꞌr bubiꞌë didzaꞌ Cornelio, gnëꞌ: ―Chguc tap dza ca hora zoaruꞌ naꞌa, gdu rdöd xhuö, catiꞌ niꞌ runaꞌ gubás len rulidzaꞌ‑nëꞌ Dios lu yuꞌu lidxaꞌ ni, bléꞌidaꞌ‑biꞌ biꞌi bönniꞌ raꞌbán nácubiꞌ lariꞌ ryëp yös yeníꞌ, duluíꞌ laubiꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Cni gudxbiꞌ nedaꞌ: “Cornelio. Dios ryönnëꞌ le rulidzuꞌ‑nëꞌ, len nöznëꞌ ca runuꞌ, ráclenuꞌ bunách yechiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Naꞌa, gsöluꞌu lu yödz Jope nu tsajlídz bönniꞌ lëꞌ Simón, zoa yetú lëꞌ Pedro. Bönniꞌ ni zoëꞌ lidxëꞌ bönniꞌ runëꞌ tsahuiꞌ guid zxa bëdx, len lëꞌ caꞌ Simón. Zoa raꞌ nis zxön lidxëꞌ bönniꞌ ni. Catiꞌ gdxinëꞌ ga zuꞌ Pedro naꞌ, güíꞌlenëꞌ liꞌ didzaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Cni guc, laꞌ bsö́laꞌteaꞌ nu tsajtílj liꞌ, atiꞌ dxiꞌa benuꞌ biduꞌ ga zoatuꞌ ni. Qui lë ni naꞌ zoatuꞌ ni yúguꞌtëtuꞌ, nudubtuꞌ lahuëꞌ Dios quië uzë́ nagtuꞌ yúguꞌtë le gna béꞌinëꞌ liꞌ Dios guiꞌu netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Niꞌr gzu lahuëꞌ Pedro ruꞌë didzaꞌ, rnëꞌ: ―Le nactë réjniꞌdaꞌ naꞌa, cutu ruyuzëꞌ yöl‑laꞌ rnëz quegac bunách Dios, san tuz nunëꞌ rëꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Rdzag ladxëꞌë bunách gdutë yödzlyú Dios, nup naꞌ tadxi Lëꞌ len tun le nac dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bsölëꞌë xtidzëꞌë Dios ga nacuáꞌ bunách Israel, len bsölëꞌë nu ben lban qui didzaꞌ dxiꞌa, le run ga rac dxiꞌa quegac bunách, lë naꞌ bdxin queëruꞌ lu nëꞌë Jesucristo. Lëczëꞌ naquëꞌ Xanruꞌ yúguꞌtëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Lbiꞌiczliꞌ nö́ziliꞌ lë naꞌ guc luyú Judea, le gzu lau guc luyú Galilea gdöd benëꞌ lban Juan quië laꞌdíl bunách nis. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nö́ziliꞌ ca benëꞌ Dios le guc queëꞌ Jesús, bönniꞌ Nazaret. Bsölëꞌë queëꞌ Dios Böꞌ Laꞌy len yöl‑laꞌ huac queëꞌ. Nö́ziliꞌ ca naꞌ gdëꞌ Jesús, runëꞌ le nac dxiꞌa, len ruúnëꞌ yúguꞌtë nup gulazacaꞌ gulaguíꞌi lu naꞌ tuꞌ xöhuiꞌ. Cni benëꞌ, le gzóalenëꞌ Lëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Naꞌa, netuꞌ runtuꞌ lnaꞌ lau qui yúguꞌtë lë naꞌ benëꞌ Jesús luyú Judea len lu yödz Jerusalén, len ca naꞌ guc, guludöddëꞌ Jesús, guludë́ꞌë Lëꞌ lëꞌi yag cruz. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Niꞌr Dios buspanëꞌ Lëꞌ catiꞌ guc tsonn dza natiëꞌ, len benëꞌ ga buluíꞌ lahuëꞌ ga zoatuꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Cutu buluíꞌ lahuëꞌ laugac yúguꞌtë bunách, san lautuꞌ netuꞌ buluíꞌ lahuëꞌ. Dios gröëꞌ netuꞌ dza niꞌtë quië guntuꞌ lnaꞌ lau queëꞌ Jesús, atiꞌ güiꞌ gdágulentuꞌ Lëꞌ tsazxö́n gdöd bubanëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gna béꞌinëꞌ netuꞌ Dios guntuꞌ lban laugac bunách, atiꞌ runtuꞌ lnaꞌ lau queëꞌ Cristo, naquëꞌ Nu buzoaczëꞌ Dios quië cuequi xbeynëꞌ nup nabangac len nup chnatgac. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Lëzcaꞌ glunëꞌ lnaꞌ lau queëꞌ Jesús yúguꞌtë bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, gulanë́ꞌ: “Yúguꞌtë nup laꞌyejlëꞌ Lëꞌ, Dios unít lahuëꞌ dul‑laꞌ nabágaꞌquëꞌ niꞌa qui le benëꞌ Lëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Niꞌ ruiꞌzëꞌ cni didzaꞌ Pedro, laꞌ bdxintëꞌ Dios Böꞌ Laꞌy, dusóalenëꞌ lequëꞌ, yúguꞌtë nup niꞌ taꞌyöni lban runëꞌ Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Gulanáꞌ badxëꞌ bönniꞌ judío taꞌyejlëꞌë Cristo, nup naꞌ guladxín niꞌ tsazxö́n len Pedro, le dusóalenëꞌ bunách niꞌ cunacgac judío Dios Böꞌ Laꞌy, nasölëꞌë Lëꞌ Dios Xuz. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Cni glunëꞌ le gulayönnëꞌ tuꞌë didzaꞌ yubl, len tunëꞌ Dios zxön bönniꞌ gzaꞌa naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Niꞌr bëꞌë didzaꞌ Pedro, gnëꞌ: ―¿Naruꞌ huactsa nu gna beꞌi bunách ni cui laꞌdíl nis? Nac bëꞌ dusóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy, ca naꞌ dusóalenëꞌ caꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Gna bëꞌë Pedro laꞌdilëꞌ nis le nazíꞌ lu naꞌquëꞌ lëꞌ Xanruꞌ Jesús. Niꞌr glátaꞌyuëꞌ lahuëꞌ Pedro bönniꞌ niꞌ ugáꞌnlenëꞌ lequëꞌ ca chop tsonn dza. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Gulayönnëꞌ gbaz nasölëꞌë Cristo len bö́chiꞌruꞌ nacuꞌë luyú Judea ca naꞌ gulazíꞌ lu naꞌquëꞌ xtidzëꞌë Dios bönniꞌ cunacquëꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Catiꞌ budxinëꞌ Pedro Jerusalén, guladíl‑lenëꞌ lëꞌ didzaꞌ bö́chiꞌruꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Glëꞌ Pedro: ―¿Bizx quië yjítslenuꞌ bönniꞌ cunacquëꞌ judío, len gdágulenuꞌ lequëꞌ tsazxö́n? ");
INSERT INTO zsrNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Niꞌr gzu lahuëꞌ Pedro rguíxjöiꞌnëꞌ lequëꞌ gdutë lë naꞌ guc, ");
INSERT INTO zsrNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","rnëꞌ: ―Gzoaꞌ lu yödz Jope, len catiꞌ niꞌ rulidzaꞌ‑nëꞌ Dios, bléꞌidaꞌ ca tu lu yël bëchcál tu le buluiꞌinëꞌ nedaꞌ Dios. Bléꞌidaꞌ bötj bruj luzxbá tu le nac ca lariꞌ guitsaꞌ zxön, nagaꞌ idáp laꞌa, atiꞌ bdxin ga naꞌ zoaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Catiꞌ niꞌ ruyúaꞌ lei quië gléꞌidaꞌ le dxia lahuil, bléꞌigacdaꞌ‑baꞌ böaꞌ guixiꞌ nacuáꞌ tap niꞌa naꞌcbaꞌ, yuguꞌ böaꞌ guixiꞌ sniaꞌ, len böaꞌ taꞌyj lëꞌcbaꞌ lyu, len böaꞌ zoa xilcbaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Byöndaꞌ chiꞌi nu gudx nedaꞌ: “Pedro, gyas. Bdödi‑baꞌ len gdagu.” ");
INSERT INTO zsrNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Niꞌr gudxaꞌ‑nëꞌ: “Cutu, Xan. Gatga gdahuaꞌ le cural‑laꞌ gágutuꞌ, o le cunác dxiꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Niꞌr le buróp lzu bulídz nedaꞌ chiꞌi luzxbá naꞌ, gudx nedaꞌ: “Le nunëꞌ dxiꞌa Dios, cutu gnauꞌ qui: cunác dxiꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tsonn lzu guc cni, atiꞌ niꞌr laꞌ buëptë luzxbá gdutë lë naꞌ bléꞌidaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Laꞌ niꞌz guladxintëꞌ raꞌ yuꞌu ga naꞌ zoaꞌ tsonnëꞌ bönniꞌ, narujquëꞌ yödz Cesarea, nasölëꞌë lequëꞌ bönniꞌ lëꞌ Cornelio. Dudiljquëꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dios Böꞌ Laꞌy gudxëꞌ nedaꞌ: “Gyeajlen lequëꞌ, cugác chop ladxuꞌu.” Lëzcaꞌ gulazáꞌlenëꞌ nedaꞌ tsazxö́n izxoptëꞌ bö́chiꞌruꞌ ni, gyeajtuꞌ Cesarea atiꞌ gyaztuꞌ lidxëꞌ bönniꞌ zoëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Bönniꞌ niꞌ gdíxjöiꞌnëꞌ netuꞌ ca naꞌ bléꞌinëꞌ, bdxinëꞌ gbaz laꞌy queëꞌ Dios lu yuꞌu lidxëꞌ. Gzuinëꞌ lahuëꞌ len gudxëꞌ lëꞌ: “Naꞌa gsö́laꞌcuꞌ‑nëꞌ bönniꞌ tsjaquëꞌ yödz Jope, tsajlidzquëꞌ Simón, zoa yetú lëꞌ Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Bönniꞌ naꞌ güíꞌlenëꞌ liꞌ didzaꞌ nac gac uláuꞌ liꞌ len lulá caꞌ yúguꞌtë bunách nacuáꞌ lidxuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Catiꞌ niꞌ gzu lahuaꞌ ruíꞌlenaꞌ lequëꞌ didzaꞌ, dusóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy ca naꞌ dusóalenëꞌ rëꞌu zíꞌatël. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Niꞌr yajneydaꞌ didzaꞌ naꞌ bëꞌë Xanruꞌ, gnëꞌ: “Le nactë Juan buquilëꞌ bunách nis lu nis, san lbiꞌiliꞌ, gac queëliꞌ le ruluíꞌz yöl‑laꞌ rdil nis naꞌ, dusóalenëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy.” ");
INSERT INTO zsrNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Qui lë ni naꞌ, chquiꞌ Dios bsölëꞌë quequëꞌ Dios Böꞌ Laꞌy, laꞌ tuz ca benëꞌ queëruꞌ rëꞌu réjlëꞌruꞌ Xanruꞌ Jesucristo, ¿núzxatë nedaꞌ gna béꞌidaꞌ‑nëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Niꞌr, catiꞌ gulayönnëꞌ lë ni, gulacuáꞌ dxiëꞌ len gulaguꞌë Dios yöl‑laꞌ ba, taꞌnë́ꞌ: ―Cni nac, Dios ruꞌë caꞌ latj bönniꞌ cunacquëꞌ judío, tuꞌbíꞌi ládxiꞌquëꞌ quië laꞌdél‑liꞌnëꞌ yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Catiꞌ niꞌ guludöddëꞌ Esteban bönniꞌ judío cutaꞌyejlëꞌ len gulabía ládxiꞌquëꞌ yezicaꞌ bunách taꞌyejlëꞌ Cristo, guluzxúndj bunách ni len glaslas zian yödz luyú Fenicia len luyú Chipre len lu yödz Antioquía. Niꞌ glunëꞌ lban qui xtidzëꞌë Dios, san laugacz bunách judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Gulacuáꞌlenëꞌ caꞌ lequëꞌ yuguꞌ bönniꞌ Chipre, len yuguꞌ bönniꞌ Cirene, atiꞌ bönniꞌ ni, catiꞌ guladxinëꞌ Antioquía, gluíꞌlenëꞌ caꞌ didzaꞌ yuguꞌ bönniꞌ gzaꞌa, glunëꞌ lban lauquëꞌ qui didzaꞌ dxiꞌa ca nac queëꞌ Xanruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gzoalen lequëꞌ yöl‑laꞌ huac queëꞌ Xanruꞌ, atiꞌ gulayejlëꞌ Xanruꞌ bunách zian, len guluhuöác queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Catiꞌ bdxin didzaꞌ ca guc lë ni, atiꞌ gulayönnëꞌ bönniꞌ queëꞌ Cristo nacuꞌë Jerusalén, gulasölëꞌë Bernabé tsijëꞌ Antioquía naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Catiꞌ bdxinëꞌ Antioquía Bernabé, bléꞌinëꞌ le ruzáꞌ ladxëꞌë quequëꞌ Dios, atiꞌ budzijnëꞌ. Buchiziëꞌ icj nagquëꞌ laꞌdíaꞌteczëꞌ queëꞌ Xanruꞌ gdu ládxiꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Naquëꞌ tsahuiꞌ Bernabé naꞌ len gdu zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy, len gdu ladxëꞌë rejlëꞌë Cristo. Niꞌa qui lban benëꞌ Bernabé, gulayejlëꞌ Xanruꞌ bunách zian lu yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Gdöd niꞌ, gyijëꞌ Bernabé yödz Tarso, yajtiljëꞌ Saulo. Catiꞌ budzölnëꞌ lëꞌ, buchë́ꞌë lëꞌ Antioquía. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Gdu ca tu iz gulacuꞌë niꞌ, tunëꞌ tsazxö́n bunách queëꞌ Cristo, len tuꞌsëdnëꞌ bunách zian. Lu yödz Antioquía naꞌ, le ziꞌal lzu gulazíꞌ laquëꞌ bunách queëꞌ Cristo, nup niꞌ taꞌyejlëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dza niꞌ gularujëꞌ Jerusalén, yjaquëꞌ Antioquía laꞌquëꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Gzuinëꞌ Agabo, bönniꞌ dzaguëꞌ yuguꞌ bönniꞌ naꞌ, len uláz queëꞌ Dios Böꞌ Laꞌy buzéjniꞌnëꞌ lequëꞌ, gnëꞌ: ―Ziꞌa gac gbin gdutë yödzlyú. Guc gbin naꞌ catiꞌ niꞌ rna bëꞌë Claudio, bönniꞌ Roma. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Niꞌr gulazíꞌ lu naꞌquëꞌ bönniꞌ taꞌyejlëꞌë Cristo nacuꞌë Antioquía laꞌsölëꞌë tsca le dëz qui queëquëꞌ, le gaclen bö́chiꞌruꞌ nacuꞌë luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Cni glunëꞌ, atiꞌ lë naꞌ gulunödzjëꞌ, gulaguꞌë lu naꞌquëꞌ Bernabé len Saulo quië luꞌë lei lauquëꞌ bönniꞌ gul tun chiꞌë bunách queëꞌ Cristo nacuꞌë Judea. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dza naꞌ benëꞌ ga gulazönëꞌ laꞌquëꞌ bönniꞌ queëꞌ Cristo Herodes, bönniꞌ rna bëꞌë, quië lusacaꞌ ziꞌë lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gna béꞌinëꞌ bönniꞌ guludöddëꞌ Jacobo, böchëꞌë Juan. Gluꞌë lëꞌ guia tuchiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Catiꞌ gúquibeꞌinëꞌ Herodes guladzág ládxiꞌquëꞌ lë ni bönniꞌ judío, benëꞌ ga gulazönëꞌ caꞌ Pedro. Glac lë ni dza niꞌ rac lni catiꞌ tahuëꞌ yöt xtil cunazíꞌ xnëꞌi. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Gdöd gulazönëꞌ Pedro, gulaguꞌë lëꞌ lidx guia, len guludödëꞌ lëꞌ lu naꞌquëꞌ tap cöꞌ bönniꞌ rjaquëꞌ gdil‑l, nacuꞌë tapëꞌ tu hueaj cöꞌ naꞌ, quië lun chiꞌë lëꞌ. Yuꞌu ladxëꞌë Herodes ubijëꞌ Pedro laugac bunách töd Lni Pascua, lni naꞌ tuꞌspanëꞌ ca benëꞌ Dios, bubijëꞌ bunách judío luyú Egipto. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Cni guc, nun chíꞌigacrëꞌ Pedro lu yuꞌu lidx guia naꞌ, san gululidztecz Dios bunách queëꞌ Cristo, taꞌnabëꞌ queëꞌ Pedro lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Catiꞌ ziꞌa gdxin dza yuꞌu ladxëꞌë Herodes ubijëꞌ Pedro lidx guia naꞌ, laꞌ dzöꞌ niꞌz dëꞌ rasiëꞌ Pedro, len nacuꞌë chopëꞌ bönniꞌ rjaquëꞌ gdil‑l cuit lëꞌë Pedro naꞌ, núgaꞌquëꞌ lëꞌ chop du guia. Gulacuꞌë ga nu ryaz lidx guia naꞌ yelaꞌquëꞌ bönniꞌ rjaquëꞌ gdil‑l tun chiꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tu tsalz buluíꞌ lahuëꞌ niꞌ gbaz laꞌy queëꞌ Xanruꞌ, atiꞌ buzeniꞌtsca yeníꞌ lidx guia. Gdanëꞌ cuit lëꞌë Pedro gbaz laꞌy naꞌ, atiꞌ buspanëꞌ lëꞌ len gudxëꞌ lëꞌ: ―Gyasch. Niꞌr guluhuédx du guia naꞌ nagaꞌ nëꞌë Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Gudxëꞌ lëꞌ gbaz laꞌy naꞌ, gnëꞌ: ―Begaꞌ lëꞌu len bdaꞌ löluꞌ. Laꞌ bentëꞌ cni Pedro. Niꞌr gudxëꞌ lëꞌ gbaz laꞌy, rnëꞌ: ―Bxoa lariꞌ yenuꞌ len gda len nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Burujëꞌ Pedro, zéajlenëꞌ gbaz laꞌy naꞌ, san cutu ráquibeꞌinëꞌ nacz le runëꞌ gbaz laꞌy naꞌ. Gúquinëꞌ yëlz rneynëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Catiꞌ chguladödëꞌ ga nacuꞌë bönniꞌ ziꞌa len bönniꞌ buróp cöꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l tun chiꞌë, guladxinëꞌ ga zoa le náquini guia nuséyj ga nu ryaz lidx guia naꞌ, le rurúj laꞌ nöz qui yödz. Ga nu ryaz naꞌ, racz qui gyalj. Catiꞌ gularujëꞌ niꞌ, gulazë́ꞌë ga rdzag yetúr nöz, atiꞌ niꞌ laꞌ buláꞌalentëꞌ Pedro gbaz laꞌy naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Niꞌr ráquibeꞌinëꞌ Pedro, atiꞌ lu icj ládxiꞌdauꞌzëꞌ gnëꞌ: ―Naꞌa chnözdaꞌ le nactë bsölëꞌë Xanruꞌ gbaz laꞌy queëꞌ, len buslë́ꞌ nedaꞌ lu nëꞌë Herodes, len lu yúguꞌtë le glëꞌnnëꞌ lunëꞌ quiaꞌ bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tsal niꞌ yuꞌë nöz Pedro, rzaꞌ ladxëꞌë ca nac lë naꞌ guc, atiꞌ bdxinëꞌ lidxnu María, xnaꞌbiꞌ Juan, biꞌi naꞌ zoa yetú labiꞌ Marcos. Lu yuꞌu ni nudubgac bunách zian taꞌyejlëꞌ Cristo, tuꞌlidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Catiꞌ bulidzëꞌ Pedro raꞌ yuꞌu löꞌa, brujbiꞌ biꞌi ngul lëbiꞌ Rode quië gnö́zibiꞌ nuzxa naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Catiꞌ búnbëꞌbiꞌ chiꞌë Pedro biꞌi ngul ni, lu yöl‑laꞌ rudziji queëbiꞌ cutu bsaljbiꞌ yuꞌu, san jaréluꞌbiꞌ böajbiꞌ lu yuꞌu, yajtíxjöiꞌbiꞌ nup nacuáꞌ niꞌ, rnabiꞌ: ―Zoëꞌ Pedro raꞌ yuꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Niꞌr glëꞌ lëbiꞌ: ―Rchixi icjuꞌ. Lëbiꞌ tsutsur ben xtídzaꞌbiꞌ nac cni. Niꞌr gulanë́ꞌ: ―Clëg lëꞌ. Bxin queëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tsal naꞌ cutu zoa dxiëꞌ Pedro rulidzëꞌ nup nacuáꞌ lu yuꞌu. Catiꞌ gulasaljëꞌ yuꞌu, gulanitznëꞌ, gulaléꞌinëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Niꞌr bchis nëꞌë Pedro quië laꞌcuꞌë dxiz, atiꞌ gdíxjöiꞌnëꞌ lequëꞌ ca benëꞌ Xanruꞌ, bubijëꞌ lëꞌ lidx guia. Niꞌr gudxëꞌ lequëꞌ: ―Gul‑tsajtixjöiꞌ‑cnëꞌ caꞌ Jacobo len yuguꞌ bö́chiꞌruꞌ ca naꞌ guc. Niꞌr burujëꞌ niꞌ Pedro, zijëꞌ ga yubl. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Catiꞌ zaꞌ reníꞌ dza naꞌ, glunëꞌ rusbö́ bönniꞌ rjaquëꞌ gdil‑l nacx guc, cutur yuꞌë lidx guia Pedro. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Niꞌr bsölëꞌë Herodes nup tsajxiꞌgac Pedro. Catiꞌ cutu guludzölnëꞌ lëꞌ, gnabi yudxnëꞌ bönniꞌ naꞌ rjaquëꞌ gdil‑l glun chiꞌë Pedro. Gdöd niꞌ gna béꞌinëꞌ nup guludödi bönniꞌ naꞌ rjaquëꞌ gdil‑l. Niꞌr gzëꞌë Herodes luyú Judea, zijëꞌ Cesarea, atiꞌ niꞌ bugaꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Dza niꞌz rleynëꞌ Herodes bunách yödz Tiro len Sidón. Ziꞌal gulasölaꞌ bunách lu xyuëꞌ Herodes naꞌ le byadzj quegac bunách lu xyugac yödz Tiro len Sidón naꞌ, san le rleynëꞌ lequëꞌ Herodes, cutur bi taꞌsölëꞌë quequëꞌ. Niꞌr glunëꞌ tuz bönniꞌ Tiro len Sidón naꞌ atiꞌ glunëꞌ ga soëꞌ Blasto unë́ quequëꞌ lahuëꞌ Herodes naꞌ. Naquëꞌ Blasto naꞌ huen dxin nadél‑liꞌnëꞌ latj blau lahuëꞌ Herodes. Glëꞌnnëꞌ laꞌdxinëꞌ lahuëꞌ Herodes bönniꞌ Tiro len Sidón naꞌ, quië laꞌnabnëꞌ lëꞌ ugáꞌn tsahuiꞌ didzaꞌ bizxj quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Niꞌr bdxiëꞌ bëꞌ Herodes dza yönnëꞌ lequëꞌ, atiꞌ dza naꞌ gröꞌë xlatjëꞌ ga rbequi xbeynëꞌ bi rac, nacuëꞌ lariꞌ zacaꞌ atiꞌ benëꞌ lban lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Niꞌr gululidzëꞌ zidzj bönniꞌ naꞌ, taꞌnë́ꞌ: ―Clëg bönniꞌz ni. Dioscz ni ruꞌë didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Laꞌ naꞌz laꞌ bëꞌtëꞌ lëꞌ gbaz laꞌy queëꞌ Xanruꞌ le buziꞌë lëczëꞌ yöl‑laꞌ ba ral‑laꞌ gac queëꞌ Dios. Niꞌr gröꞌë bzugaꞌ Herodes naꞌ, atiꞌ gutiëꞌ le tágubaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Niꞌr guc lban qui xtidzëꞌë Xanruꞌ, atiꞌ gulayán nup nazíꞌ lu naꞌgac lei. ");
INSERT INTO zsrNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Catiꞌ chguludödëꞌ dumí naꞌ Bernabé len Saulo lu naꞌquëꞌ bönniꞌ gul tun chiꞌë bunách queëꞌ Cristo nacuꞌë Jerusalén, guluzë́ꞌë niꞌ, yhuöjquëꞌ Antioquía. Gulachë́ꞌë‑biꞌ caꞌ biꞌi Juan, zoa yetú labiꞌ Marcos. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Dza naꞌz gulacuꞌë Antioquía bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios len bönniꞌ tuꞌsëdnëꞌ bunách, nútsaꞌquëꞌ ladj bunách queëꞌ Cristo lu yödz naꞌ. Cni lëquëꞌ: Bernabé, Simón, (lëꞌ caꞌ Niger), Lucio, (bönniꞌ Cirene), Saulo, Manaén, (bönniꞌ naꞌ gzxö́nlenëꞌ tsazxö́n Herodes, bönniꞌ rna bëꞌë luyú Galilea). ");
INSERT INTO zsrNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tsal niꞌ nudubquëꞌ queëꞌ Xanruꞌ len tunëꞌ gubás bönniꞌ ni, gudxëꞌ lequëꞌ Dios Böꞌ Laꞌy, rnëꞌ: ―Gul‑bíaj‑quëꞌ quizi quiaꞌ Bernabé len Saulo quië tsjenquëꞌ dxin naꞌ bulidzaꞌ lequëꞌ lunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Budx glunëꞌ gubás len gululidzëꞌ Dios, niꞌr gulaxóa naꞌquëꞌ chopëꞌ ni, len gulasölëꞌë lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Niꞌr, yjaquëꞌ yödz Seleucia Bernabé len Saulo, le bsölëꞌë lequëꞌ niꞌ Dios Böꞌ Laꞌy, atiꞌ niꞌ gulabenëꞌ tu lëꞌi barco le bchëꞌ lequëꞌ ga nac tu luyú bidx lu nis zxön, nazíꞌ lei Chipre. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Catiꞌ guladxinëꞌ niꞌ lu yödz Salamina, niꞌ gulaguíxjöꞌë xtidzëꞌë Dios gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Nachëꞌquëꞌ‑biꞌ biꞌi Juan quië gáclenbiꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Budx guladödëꞌ gdu gap dë yödzdauꞌ luyú bidx naꞌ lu nis zxön, niꞌr guladxinëꞌ yödz Pafos. Niꞌ yajxácaꞌquëꞌ Barjesús, bönniꞌ judío. Naquëꞌ bönniꞌ udzáꞌ rziꞌ yëꞌë, rnëꞌ ruꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bönniꞌ ni dzaguëꞌ Sergio Paulo, bönniꞌ rejniꞌi rna bëꞌë. Bulidzëꞌ Bernabé len Saulo bönniꞌ rna bëꞌë naꞌ, le rëꞌnnëꞌ yönnëꞌ xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Niꞌr gdáꞌbaguëꞌë Bernabé len Saulo bönniꞌ udzáꞌ naꞌ, le guꞌnnëꞌ gunëꞌ ga cu tsejlëꞌë Dios bönniꞌ rna bëꞌë. Lëꞌ caꞌ Elimas bönniꞌ udzáꞌ naꞌ, tsca nac xtídzaꞌgac bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Niꞌr buzóa tsutsu lahuëꞌ Saulo, lëꞌ caꞌ Pablo, gdu zóalenëꞌ lëꞌ Dios Böꞌ Laꞌy, ruyúëꞌ Elimas naꞌ ");
INSERT INTO zsrNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","len rëꞌ lëꞌ: ―Liꞌ, bönniꞌ rziꞌ yëꞌ len bönniꞌ huiaꞌdöꞌ, nacuꞌ ca zxiꞌncz tuꞌ xöhuiꞌ len bönniꞌ curleꞌi dxiꞌa yúguꞌtë le nac tsahuiꞌ. ¿Naruꞌ cuzóa dxitsuꞌ ca runuꞌ, rdáꞌbaguꞌu didzaꞌ tsahuiꞌ queëꞌ Xanruꞌ, len ruzaguꞌu xnöz nu rëꞌni tsejlëꞌ Lëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Naꞌa, usacaꞌ ziꞌë liꞌ Xanruꞌ, atiꞌ gchul lauꞌ, len cutu gléꞌinuꞌ gbidz nabáb dza. Laꞌ bchultë lahuëꞌ Elimas naꞌ, atiꞌ gdëꞌ naꞌl niꞌl, rguiljëꞌ nuzxa sön nëꞌë gchëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Catiꞌ bléꞌinëꞌ lë naꞌ guc bönniꞌ naꞌ rna bëꞌë, bubannëꞌ ca nac xtidzëꞌë Xanruꞌ, atiꞌ gyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Niꞌr guluzë́ꞌë yödz Pafos naꞌ Pablo len bönniꞌ dzagquëꞌ lëꞌ, nacuꞌë tu lëꞌi barco, atiꞌ guladxinëꞌ yödz Perge luyú Panfilia. Lu yödz naꞌ buláꞌalenbiꞌ lequëꞌ biꞌi Juan, böajbiꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Gdöd niꞌ guluzë́ꞌë Perge naꞌ, yjaquëꞌ Antioquía luyú Pisidia. Lu yödz naꞌ, catiꞌ niꞌ nac dza laꞌy quequëꞌ bönniꞌ judío, gulayaziëꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, atiꞌ lu yuꞌu naꞌ gulaböꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Niꞌr bulabëꞌ guich ga nayúj zxba queëꞌ Dios bönniꞌ zoëꞌ niꞌ, lencaꞌ le nayúj lu guich ca gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios. Gdöd niꞌ gulasölëꞌë nu yjödx Saulo len Bernabé bönniꞌ uná bëꞌ qui yuꞌu naꞌ, gnëꞌ: ―Lbiꞌiliꞌ, bö́chiꞌtuꞌ. Chquiꞌ ral‑laꞌ bi gnaliꞌ le uzejniꞌi netuꞌ, gul‑në́. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Niꞌr gyasëꞌ Pablo, len bchis nëꞌë quië laꞌcuꞌë dxiz, gnëꞌ: ―Gul‑zë́ nagliꞌ le gyëpaꞌ lbiꞌiliꞌ, bönniꞌ Israel, len lbiꞌiliꞌ, nul‑liꞌ rádxiliꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Xanruꞌ Dios, Nu taꞌyíj ládxiꞌgac bunách Israel, gröczëꞌ xuz xtauꞌruꞌ len benëꞌ ga gulayantsquëꞌ catiꞌ niꞌ nacquëꞌ bönniꞌ ziꞌtuꞌ luyú Egipto. Len yöl‑laꞌ huac zxön queëꞌ bubijëꞌ lequëꞌ luyú niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Gdu choaꞌ iz biaꞌ blenëꞌ quequëꞌ Dios catiꞌ niꞌ guladë́ꞌ gdu luyú bidx lu latj caꞌz. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Catiꞌ budx busnitiëꞌ gadx cöꞌ yödz gulacuáꞌ luyú Canaán, bunödzjëꞌ quequëꞌ xuz xtauꞌruꞌ xyugac bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gdöd niꞌ, le guc gdu ca tap gayuáꞌ yu chiʉ́n iz, Dios bucuꞌë quequëꞌ bönniꞌ glequi xbeynëꞌ lequëꞌ ga bdxintë zoëꞌ Samuel, bönniꞌ bëꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Niꞌr gulanabëꞌ lahuëꞌ Dios uzóëꞌ quequëꞌ bönniꞌ gna bëꞌë, atiꞌ Dios buzóëꞌ quequëꞌ Saúl, zxiꞌnëꞌ Cis, nababëꞌ diꞌa dza queëꞌ Benjamín. Gdu ca choaꞌ iz gna béꞌinëꞌ lequëꞌ Saúl naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Gdöd niꞌ Dios gduëꞌ Saúl naꞌ, atiꞌ buzóëꞌ quequëꞌ David quië gna bëꞌë. Dios benëꞌ lnaꞌ lau queëꞌ David ni, gnëꞌ: “Nözdaꞌ runëꞌ le rdzag ladxaꞌa David, zxiꞌnëꞌ Isaí, len gunëꞌ yúguꞌtë le rëꞌndaꞌ nedaꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ladj zxiꞌn xsoëꞌ David ni, Dios benëꞌ ga guljëꞌ Jesús quië uslë́ꞌ bunách Israel, ca naꞌ zíꞌatël gzxiꞌ lu nëꞌë Dios gunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ziꞌal catiꞌ ziꞌa glëꞌë Jesús, benëꞌ lban Juan laugac yúguꞌtë bunách Israel quië lubíꞌi ládxiꞌgac len laꞌdíl nis bunách niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Catiꞌ niꞌ chzoa udx gunëꞌ lban Juan naꞌ, gnëꞌ: “¿Nuzxa ráquiliꞌ nacaꞌ nedaꞌ? Cutu nacaꞌ Cristo, bönniꞌ naꞌ ral‑laꞌ guidëꞌ. Naꞌa, gul‑yutscaꞌ. Chzaꞌ gal‑laꞌ gdxinëꞌ ga zoaꞌ ni bönniꞌ naꞌ, atiꞌ nedaꞌ cutu nacaꞌ lsacaꞌ gleycjaꞌ lölëꞌ nudë́ꞌë.” ");
INSERT INTO zsrNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Lbiꞌiliꞌ, böchaꞌa, yuguꞌ zxiꞌn xsoëꞌ Abraham, len nul‑liꞌ zoaliꞌ ni, rádxiliꞌ‑nëꞌ Dios. Dioscz bsölëꞌë queëliꞌ didzaꞌ ni quië ulaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Cutu guluúnbëꞌ Jesús nup nacuáꞌ Jerusalén len bönniꞌ taꞌná béꞌinëꞌ lequëꞌ, len cutu gulayéjniꞌnëꞌ le nayúj lu guich le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, zal‑laꞌ tuꞌlabczëꞌ yuguꞌ didzaꞌ ni yuguꞌ dza laꞌy, san lu yöl‑laꞌ curejniꞌi quequëꞌ glunëꞌ ga butság ca rna didzaꞌ ni catiꞌ niꞌ gulachuguëꞌ queëꞌ Jesús gatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Zal‑laꞌ cutu budzöli le nabaguëꞌë Jesús gatiëꞌ, gulanabëꞌ lahuëꞌ Pilato gna béꞌinëꞌ bönniꞌ ludöddëꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Catiꞌ budx glunëꞌ queëꞌ yúguꞌtë le nayúj lu guich ca ral‑laꞌ gac queëꞌ, guluzötjëꞌ Lëꞌ lëꞌi yag cruz len gulucachëꞌë Lëꞌ yeru ba. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Niꞌr Dios buspanëꞌ Lëꞌ lu yöl‑laꞌ gut, ");
INSERT INTO zsrNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","atiꞌ zian dza buluíꞌ lahuëꞌ Jesús laugac nup yjaclen Lëꞌ tsazxö́n catiꞌ niꞌ gzëꞌë Galilea, bdxinëꞌ Jerusalén. Naꞌa, tunëꞌ lnaꞌ lau queëꞌ yuguꞌ bönniꞌ naꞌ laugac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Cni nac, lëzcaꞌ netuꞌ ni rguíxjöiꞌtuꞌ lbiꞌiliꞌ didzaꞌ dxiꞌa ca nac lë naꞌ gzxiꞌ lu nëꞌë Dios gunëꞌ quequëꞌ xuz xtauꞌruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lë naꞌ gzxiꞌ lu nëꞌë quequëꞌ Dios, Lëczëꞌ benëꞌ ga butság queëruꞌ, nacruꞌ zxiꞌn xsoaquëꞌ. Cni benëꞌ catiꞌ buspanëꞌ Jesús, guc ca naꞌ nayúj lu guich ga zoa salmo buróp, le rna cni: “Liꞌ nacuꞌ Zxiꞌnaꞌ. Nedaꞌ buzoaczaꞌ Liꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ca nac naꞌ, Dios buspanëꞌ Lëꞌ lu yöl‑laꞌ gut cui nit le gyaꞌ gbanëꞌ, Lëczëꞌ Dios gnëꞌ cni: “Gunnaꞌ queëliꞌ le nacgac bicaꞌ ba gzxiꞌ lu naꞌa lahuëꞌ David.” ");
INSERT INTO zsrNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Qui lë ni naꞌ nayúj caꞌ lu guich, ga zoa yetú salmo, le rna cni: “Cutu guꞌu latj ugaꞌnëꞌ bönniꞌ laꞌy quiuꞌ ga nit le gyaꞌ gbanëꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Le guc queëꞌ David nac bëꞌ. Gdöd benëꞌ dxin laugac bunách uládz queëꞌ, ca naꞌ gna béꞌinëꞌ lëꞌ Dios, niꞌr gutiëꞌ atiꞌ gulaguꞌë lëꞌ yeru ba ga nacuꞌë xuz xtauꞌhuëꞌ, atiꞌ gnit le gyaꞌ gbanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Naꞌa, Jesús naꞌ, Dios buspanëꞌ Lëꞌ, atiꞌ cutu gnit lu yeru ba le gyaꞌ gbanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Lbiꞌiliꞌ, böchaꞌa, ral‑laꞌ gnö́ziliꞌ lë ni rguíxjöiꞌtuꞌ lbiꞌiliꞌ. Dios runít lahuëꞌ lbiꞌiliꞌ ca nac dul‑laꞌ nabágaꞌliꞌ niꞌa qui le benëꞌ Jesús ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Naꞌa, Dios ruúnëꞌ tsahuiꞌ yúguꞌtë nup taꞌyejlëꞌ Jesús, rugǘëꞌ yuguꞌ dul‑laꞌ naꞌ le cugúc ugúa zxba queëꞌ Dios, le bëꞌë Moisés. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gul‑gún chiꞌi cuinliꞌ naꞌa cui gac queëliꞌ le nayúj lu guich le gulanë́ꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, rna cni: ");
INSERT INTO zsrNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Gul‑yutscaꞌ, lbiꞌiliꞌ, bönniꞌ cutún ba laꞌn. Ubániliꞌ san lu yöl‑laꞌ curejlëꞌ queëliꞌ gatliꞌ. Nedaꞌ gunaꞌ tu dxin dza ni zoaliꞌ, Atiꞌ zal‑laꞌ nu quixjöiꞌ lbiꞌiliꞌ le ruluíꞌ dxin naꞌ, cutu caꞌ tséjlëꞌliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Catiꞌ gulurujëꞌ lu yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío Pablo len bönniꞌ naꞌ dzagquëꞌ lëꞌ, niꞌr glátaꞌyu lauquëꞌ bunách niꞌ laꞌguíxjöiꞌnëꞌ lequëꞌ yuguꞌ lë ni catiꞌ gdxin yetú dza laꞌy quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Catiꞌ niꞌ gulurujëꞌ lu yuꞌu naꞌ bönniꞌ nudubquëꞌ niꞌ, glunëꞌ tsazxö́n Pablo len Bernabé zian bönniꞌ judío len bönniꞌ nuhuöacquëꞌ judío, bönniꞌ taꞌyíj ládxiꞌquëꞌ Dios. Chopëꞌ ni gluíꞌlenëꞌ lequëꞌ didzaꞌ, len gulusë́ꞌë ládxiꞌquëꞌ quië lácteczëꞌ tsutsu, lunëꞌ löz le ruzáꞌ ladxëꞌë quequëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Yexunuꞌ gbidz caꞌ catiꞌ bdxin yetú dza laꞌy quequëꞌ, guludubëꞌ yelatiꞌz cuguluhuöatë bunách lu yödz naꞌ quië laꞌyönnëꞌ xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Niꞌr guluzxéꞌinëꞌ bönniꞌ judío cutaꞌyejlëꞌ, catiꞌ gulaléꞌinëꞌ bunách zian naꞌ, atiꞌ gulanë́ꞌ qui didzaꞌ ruꞌë Pablo, len guladáꞌbaguëꞌë lei. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Niꞌr gdu lu yöl‑laꞌ rugu ladxiꞌ quequëꞌ, glëꞌ yuguꞌ bönniꞌ judío naꞌ Pablo len Bernabé, taꞌnë́ꞌ: ―Ben bayúdx quíxjöiꞌtuꞌ lbiꞌiliꞌ ziꞌal xtidzëꞌë Dios, san le rucaꞌnliꞌ caꞌz didzaꞌ ni, len runi lbiꞌiliꞌ cutu nacliꞌ lsacaꞌ gdél‑liꞌliꞌ yöl‑laꞌ naꞌbán gdu ni, qui lë ni naꞌ, naꞌa uyeajtuꞌ ga nacuáꞌ bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Lëzcaꞌ cni gna béꞌinëꞌ netuꞌ Xanruꞌ Dios guntuꞌ lban queëꞌ Cristo laugac bunách gzaꞌa, nac ca rna didzaꞌ naꞌ bëꞌë Dios ca nac queëꞌ Cristo, gnëꞌ: Nuzóaꞌ Liꞌ quië gacuꞌ yeníꞌ quegac bunách gzaꞌa, Len gacuꞌ Nu uslá bunách gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Catiꞌ gulayöni didzaꞌ ni bunách gzaꞌa nacuáꞌ niꞌ, guludzijnëꞌ len gulaguꞌë Xanruꞌ yöl‑laꞌ ba niꞌa qui xtidzëꞌë. Gulayejlëꞌ Cristo yúguꞌtë nup niꞌ chnunëꞌ quegac Dios gataꞌ quegac yöl‑laꞌ naꞌbán gdu. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Cni guc, gzë xtidzëꞌë Xanruꞌ, atiꞌ gulayöni lei bunách yúguꞌtë yödz nacuáꞌ luyú niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Niꞌr gulagúꞌu yöl‑lëꞌë yuguꞌ bönniꞌ blau qui yödz niꞌ bönniꞌ judío cutaꞌyejlëꞌ naꞌ cui laꞌléꞌinëꞌ dxiꞌa Pablo len Bernabé. Lëzcaꞌ cni gulagúꞌu yöl‑lëꞌë ngul blau niꞌ taꞌyíj ládxiꞌnu Dios. Cni guc, glunëꞌ ga gulabía ládxiꞌquëꞌ Pablo len Bernabé, atiꞌ gululaguëꞌ chopëꞌ ni niꞌl lu xyuquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Niꞌr guluquindjëꞌ yu bëchtö daꞌ lalabquëꞌ Pablo len Bernabé le ruluíꞌi nagáꞌn zxguiaꞌ nabágaꞌgac bunách lu yödz naꞌ, atiꞌ yjaquëꞌ lu yödz Iconio. ");
INSERT INTO zsrNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Guludzijnëꞌ bönniꞌ yödz Antioquía naꞌ, bönniꞌ taꞌyejlëꞌ Xanruꞌ, atiꞌ gzóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Catiꞌ guladxinëꞌ Iconio Pablo len Bernabé, gulayaziëꞌ tsazxö́n lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ niꞌ gluꞌë didzaꞌ. Cni guc, gulayejlëꞌ Cristo zian bunách judío, lencaꞌ zian bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Niꞌr gulagúꞌu yöl‑lëꞌë laꞌquëꞌ bönniꞌ gzaꞌa bönniꞌ judío cutaꞌyejlëꞌ, cui laꞌléꞌinëꞌ dxiꞌa bö́chiꞌruꞌ taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Le gulayejlëꞌ Cristo bunách zian naꞌ, zian dza gulacuꞌë niꞌ Pablo len Bernabé, atiꞌ lu yöl‑laꞌ rugu ladxiꞌ gluꞌë xtidzëꞌë Dios, le tuꞌzxöni ládxiꞌquëꞌ Xanruꞌ. Lëczëꞌ Xanruꞌ buluꞌë nac gdutë li didzaꞌ tuꞌë ca nac le ruzáꞌ ladxëꞌë quegac bunách Dios, le bëꞌë latj glunëꞌ le tac bëꞌ len le tun ga tuꞌbani bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Niꞌr gularúj chopl bunách lu yödz naꞌ. Laꞌquëꞌ guladë́ꞌë bönniꞌ judío cutaꞌyejlëꞌ, atiꞌ yelaꞌquëꞌ guladë́ꞌë Bernabé len Pablo, gbaz naꞌ nasölëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Niꞌr bönniꞌ judío cutaꞌyejlëꞌ naꞌ len yuguꞌ bönniꞌ gzaꞌa niꞌ glunëꞌ tuz bönniꞌ taꞌná béꞌinëꞌ lequëꞌ, atiꞌ gularujëꞌ quië luꞌë döꞌ quequëꞌ gbaz naꞌ nasölëꞌë Cristo len luladxëꞌ lequëꞌ guiöj. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Catiꞌ táquibeꞌinëꞌ lë ni Pablo len Bernabé, guluzxundjëꞌ niꞌ, yjaquëꞌ yödz Listra len Derbe luyú Licaonia, atiꞌ niꞌ guladödëꞌ yúguꞌtë yödzdauꞌ gdu zbiꞌil, ");
INSERT INTO zsrNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","gap niꞌ glunëꞌ lban qui didzaꞌ dxiꞌa ca nac queëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lu yödz Listra zoëꞌ bönniꞌ curzë́ꞌë. Röꞌzëꞌ niꞌ le curzaꞌczëꞌ catiꞌ niꞌ guljëꞌ len gatga gzëꞌi niꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ruzë́ naguëꞌ didzaꞌ ruꞌë Pablo bönniꞌ ni. Buyúëꞌ lëꞌ Pablo len gúquibeꞌinëꞌ rejlëꞌë Cristo quië huöaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Niꞌr bëꞌë zidzj didzaꞌ Pablo, rëꞌ lëꞌ: ―Gzui. Laꞌ gxítiꞌtëꞌ bönniꞌ naꞌ len gzëꞌi niꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Catiꞌ gulaléꞌinëꞌ lë naꞌ benëꞌ Pablo bönniꞌ Listra, gulazú lauquëꞌ tuꞌë zidzj didzaꞌ lu didzaꞌ tuꞌë bönniꞌ Licaonia naꞌ, taꞌnë́ꞌ: ―Yuguꞌ dios bönniꞌ ni. Nuhuötjquëꞌ ga zoaruꞌ, tuꞌluíꞌ cuinquëꞌ ca nacquëꞌ bönniꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé naꞌ, gulanë́ꞌ naquëꞌ Júpiter, ca lëꞌ dios blau quequëꞌ, atiꞌ Pablo, gulanë́ꞌ naquëꞌ Mercurio, yetú dios quequëꞌ. Cni gulanë́ꞌ le ruꞌë didzaꞌ Pablo ca naꞌ taꞌnë́ꞌ runëꞌ Mercurio naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ga niꞌ nacuꞌë zoa gdauꞌ qui Júpiter, cuit nöztëz ga niꞌ taꞌyáz bunách yödz naꞌ. Laꞌ bdxintëꞌ niꞌ bxuz qui Júpiter naꞌ, nachë́ꞌë‑baꞌ yuguꞌ bëdx len nuꞌë caꞌ yuguꞌ breguiꞌ yöj, atiꞌ dzaggac lëꞌ bunách zian. Glëꞌnnëꞌ ludödcdëꞌ‑baꞌ bëdx naꞌ lauquëꞌ Pablo len Bernabé quië laꞌyíj ládxiꞌquëꞌ lequëꞌ ca tunëꞌ quegac dios quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Catiꞌ gláquibeꞌinëꞌ lë ni Bernabé len Pablo, gbaz naꞌ nasölëꞌë Cristo, gulachözëꞌë lariꞌ nácuquëꞌ. Tuꞌhuiꞌnnëꞌ le tunëꞌ bönniꞌ ni le cural‑laꞌ lunëꞌ, atiꞌ gulaxítiꞌë, yajcuꞌë gatsj lahuiꞌl bunách zian naꞌ, len gluꞌë zidzj didzaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","tëꞌ lequëꞌ: ―Lbiꞌiliꞌ bunách. ¿Bizx quië runliꞌ cni? Lëz bönniꞌ ca lbiꞌiliꞌ nactuꞌ, len rguíxjöiꞌtuꞌ lbiꞌiliꞌ lë nicz ral‑laꞌ ucaꞌnliꞌ, le cunácz ni, quië gáquiliꞌ queëꞌ Dios ban. Dios ni benëꞌ luzxbá len yödzlyú, len nis zxön, len yúguꞌtë le nacuáꞌ tu tu latj naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Iz chguladö́d, glun yúguꞌtë bunách ca rnaz qui queëgac, atiꞌ Dios cutu buzaguëꞌë xnözgac, ");
INSERT INTO zsrNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","san benëꞌ ga glac le tun lnaꞌ lau queëꞌ, niꞌa qui le nacgac dxiꞌa benëꞌ quequëꞌ. Rsölëꞌë queëruꞌ nis guiöj, len runëꞌ ga taꞌyán le razruꞌ. Ruzö́lj rudzéꞌinëꞌ rëꞌu len runëꞌ ga rudziji ládxiꞌruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Zal‑laꞌ glëꞌ lequëꞌ cni Bernabé len Pablo, cannz guluxicjëꞌ guluzaguëꞌë xnözgac bunách zian naꞌ, cui ludödcdëꞌ‑baꞌ bëdx naꞌ lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Niꞌr guladxinëꞌ niꞌ laꞌquëꞌ bönniꞌ judío cutaꞌyejlëꞌë, narujquëꞌ Antioquía len Iconio, atiꞌ gulagúꞌu yöl‑lëꞌë bunách zian naꞌ. Niꞌr gululadxëꞌ Pablo guiöj yúguꞌtëꞌ, len glaꞌyjëꞌ lëꞌ niꞌl raꞌ yödz naꞌ, le táquinëꞌ chnatiëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Niꞌr catiꞌ guludubëꞌ gdu zbiꞌil ga dëꞌ Pablo bönniꞌ taꞌyejlëꞌë Cristo, gyasëꞌ Pablo len buaziëꞌ lu yödz naꞌ. Catiꞌ zaꞌ reníꞌ yetú dza, burújlenëꞌ Bernabé, yjaquëꞌ yödz Derbe. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Lu yödz niꞌ glunëꞌ lban qui didzaꞌ dxiꞌa ca nac queëꞌ Jesucristo, atiꞌ gulayejlëꞌ Cristo bunách zian niꞌ. Gdöd niꞌ yhuöjquëꞌ Listra, len Iconio, len Antioquía. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Catiꞌ guladödëꞌ yuguꞌ yödz naꞌ Bernabé len Pablo, gulutipëꞌ ládxiꞌquëꞌ bönniꞌ niꞌ taꞌyejlëꞌë Cristo, len gulusë́ꞌë ládxiꞌquëꞌ lugaꞌnëꞌ tsutsu ca naꞌ taꞌyejlëꞌë Lëꞌ. Glëꞌ lequëꞌ: ―Rëꞌu tsazczruꞌ ga rna bëꞌë Dios, run bayúdx sacaꞌ quiꞌruꞌ zian le gac queëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tu cöꞌ hueaj bunách niꞌ queëꞌ Cristo, gulucuꞌë bönniꞌ gul lun chiꞌë bunách queëꞌ Cristo naꞌ. Catiꞌ chgululidzëꞌ Dios len glunëꞌ gubás, niꞌr gulaguꞌë lequëꞌ lu nëꞌë Xanruꞌ, Nu naꞌ taꞌyejlëꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Niꞌr guladödëꞌ luyú Pisidia Pablo len Bernabé, atiꞌ guladxinëꞌ luyú Panfilia. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Budx glunëꞌ lban qui xtidzëꞌë Cristo lu yödz Perge, yjaquëꞌ yödz Atalia. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Guluzë́ꞌë niꞌ, atiꞌ gulabenëꞌ tu lëꞌi barco len guludxinëꞌ yödz Antioquía, ga naꞌ nacuꞌë bönniꞌ queëꞌ Cristo, bönniꞌ naꞌ gulasölëꞌë lequëꞌ tsjenquëꞌ lban, catiꞌ niꞌ gulaguꞌë lequëꞌ lu nëꞌë Dios, Nu naꞌ ruzáꞌ ladxiꞌ quequëꞌ lunëꞌ xchinëꞌ, dxin naꞌ chbudx glunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Catiꞌ niꞌ guludxinëꞌ Antioquía, guludúb bunách queëꞌ Cristo nacuáꞌ niꞌ. Niꞌr gulaguíxjöiꞌnëꞌ lequëꞌ Pablo len Bernabé ca nacgac le zxön benëꞌ Dios lu naꞌquëꞌ, lencaꞌ ca benëꞌ Dios, bëꞌë latj taꞌyejlëꞌ caꞌ Lëꞌ bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Zian dza gulugáꞌnlenëꞌ bunách niꞌ taꞌyejlëꞌ Cristo Pablo len Bernabé. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Niꞌr guladxinëꞌ Antioquía laꞌquëꞌ bönniꞌ narujquëꞌ luyú Judea, atiꞌ gulusëdnëꞌ bö́chiꞌruꞌ niꞌ, taꞌnë́ꞌ: ―Chquiꞌ cutu grugu lu xpë́laꞌliꞌ ca nalë́bituꞌ runtuꞌ ca naꞌ gna bëꞌë Moisés, cutu gac ulaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Niꞌr guladíl‑lenëꞌ lequëꞌ didzaꞌ Pablo len Bernabé, atiꞌ glactsca rusbö́. Gdöd niꞌ, gulabö́ëꞌ Pablo len Bernabé len yelaꞌquëꞌ bönniꞌ bö́chiꞌruꞌ niꞌ, quië tsjaquëꞌ Jerusalén, laꞌdxinëꞌ lauquëꞌ gbaz niꞌ queëꞌ Cristo, lencaꞌ lauquëꞌ bönniꞌ gul tun chiꞌë bunách queëꞌ Cristo niꞌ, quië luíꞌlenëꞌ lequëꞌ didzaꞌ ca nac lë ni rac, tuꞌsëdnëꞌ bunách bönniꞌ naꞌ le nachixi. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Niꞌr guluguꞌë lequëꞌ nöz bönniꞌ queëꞌ Cristo nacuꞌë Antioquía, atiꞌ guladödëꞌ lu xyu yödz Fenicia len luyú Samaria, atiꞌ gulaguíxjöiꞌnëꞌ böchiꞌ lzaꞌruꞌ niꞌ ca guc, guluhuöaquëꞌ queëꞌ Cristo bönniꞌ gzaꞌa. Lë ni ben ga guludzijnëꞌ yúguꞌtë böchiꞌ lzaꞌruꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Catiꞌ guladxinëꞌ Jerusalén Pablo len Bernabé, glunëꞌ lequëꞌ ba laꞌn bönniꞌ queëꞌ Cristo nacuꞌë niꞌ, lencaꞌ yuguꞌ gbaz nasölëꞌë Lëꞌ, len bönniꞌ gul tun chiꞌë. Gulaguíxjöiꞌnëꞌ lequëꞌ Pablo len Bernabé yúguꞌtë le benëꞌ Dios lu naꞌquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Niꞌr gulayasëꞌ laꞌquëꞌ bönniꞌ gdauꞌ fariseo chtaꞌyejlëꞌë Cristo, taꞌnë́ꞌ: ―Run bayúdx grugu lu xpë́laꞌquëꞌ bönniꞌ gzaꞌa naꞌ taꞌyejlëꞌëꞌë Cristo, len gna béꞌiruꞌ lequëꞌ lunëꞌ ca rna bëꞌ zxba queëꞌ Moisés. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Niꞌr guludubëꞌ gbaz nasölëꞌë Cristo len bönniꞌ gul tun chiꞌë bunách queëꞌ, quië laꞌbequi xbeynëꞌ lë ni rac. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Gdöd gluꞌë zian didzaꞌ, gzuinëꞌ Pedro len gudxëꞌ lequëꞌ: ―Böchaꞌa. Nö́ziczliꞌ ca guc dza niꞌtë, Dios gröczëꞌ nedaꞌ quië gunaꞌ lban laugac bunách gzaꞌa quië laꞌyönnëꞌ didzaꞌ dxiꞌa len laꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios, Nu nunbëꞌcz le yuꞌu icj ládxiꞌdauꞌgac bunách, buzóëꞌ le nac bëꞌ runëꞌ lequëꞌ ba laꞌn, le bsölëꞌë quequëꞌ Dios Böꞌ Laꞌy, lëz ca bsölëꞌë queëruꞌ Lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Cutu butsë́ꞌë ca benëꞌ quequëꞌ len queëruꞌ, atiꞌ lëzcaꞌ lequëꞌ bunëꞌ dxiꞌa icj ládxiꞌdauꞌquëꞌ le taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Naꞌa, ¿bizx quië run leyliꞌ‑nëꞌ Dios, ruspágaꞌliꞌ yuaꞌ xyengac böchiꞌ lzaꞌruꞌ? Yuaꞌ ni, le nac le taꞌná bëꞌ zxba queëꞌ Moisés, cutu guc guaꞌruꞌ rëꞌu, len cutu guc luꞌë xuz xtauꞌruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Rëꞌu ni, réjlëꞌruꞌ nularuꞌ niꞌa qui le buzáꞌ ladxëꞌë queëruꞌ Xanruꞌ Jesús, len lëz ca nularuꞌ rëꞌu, lulë́ꞌ caꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Catiꞌ budx bëꞌë didzaꞌ ni Pedro, gulacuꞌë dxiz yúguꞌtëꞌ, atiꞌ guluzë́ nagquëꞌ didzaꞌ gluꞌë Bernabé len Pablo, gulaguíxjöiꞌnëꞌ lequëꞌ le tac bëꞌ len le tun ga tuꞌbani bunách, yuguꞌ le benëꞌ Dios lu naꞌquëꞌ ga nacuáꞌ bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Catiꞌ budx gluꞌë didzaꞌ ni Bernabé len Pablo, bubiꞌë didzaꞌ Jacobo, gnëꞌ: ―Böchaꞌa. Gul‑zë́ nagliꞌ le gyëpaꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Chgdíxjöiꞌcznëꞌ rëꞌu Simón Pedro ca benëꞌ Dios, buluꞌë lahui yöl‑laꞌ huac queëꞌ le ziꞌal lzu laugac bunách gzaꞌa quië bubijëꞌ quizi queëꞌ bunách nútsaꞌgac ladjquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ca nac lë ni rajlözgac xtídzaꞌquëꞌ bönniꞌ gluꞌë didzaꞌ uláz queëꞌ Dios, ca naꞌ nayúj lu guich laꞌy, rna: ");
INSERT INTO zsrNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Dza töd lë ni huödaꞌ len uchisaꞌ Nu gna bëꞌ, Tsaziëꞌ xlatjëꞌ David, Gunaꞌ ca run nu ruchís tu yuꞌu naguíndj. Uchisaꞌ caꞌ bunách laꞌcuáꞌ lidxëꞌ, nup nagaꞌngac, Gunaꞌ ca run nu ruchís tu zöꞌö gul. Cni uchisaꞌ le gna bëꞌë David ");
INSERT INTO zsrNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Quië luguílj Xanruꞌ yezicaꞌ bunách. Luguílj Lëꞌ bunách gzaꞌa, Atiꞌ siꞌ lagac: bunách queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Cni rnëꞌ Xanruꞌ, Nu naꞌ dza niꞌtë ben ga nac bëꞌ yúguꞌtë lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Qui lë ni naꞌ runi nedaꞌ cutu ral‑laꞌ gun níguiruꞌ bunách gzaꞌa, nup tuꞌhuöác queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ral‑laꞌ uzujruꞌ quequëꞌ lu guich quië lucaꞌnëꞌ yuguꞌ le cural‑laꞌ lahuëꞌ, le nadö́d laugac bdauꞌ guiöj bdauꞌ yag, len cui lunëꞌ le cunác, len cui lahuëꞌ xpë́laꞌcbaꞌ böaꞌ guixiꞌ cunarujcbaꞌ rön, len cui lahuëꞌ xchönbaꞌ nútiꞌtëz böaꞌ guixiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dza niꞌtë nacuáꞌ yúguꞌtë yödz nup tun lban lu yuꞌu gap tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, len tunëꞌ lban qui le buzujëꞌ lu guich Moisés. Tuꞌlabczëꞌ lei yuguꞌ dza laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Niꞌr guladzág ládxiꞌquëꞌ gbaz nasölëꞌë Cristo len bönniꞌ gul tun chiꞌë, len yúguꞌtë bunách queëꞌ Cristo, laꞌbö́ëꞌ laꞌquëꞌ bönniꞌ ladjquëꞌ quië laꞌsölëꞌë lequëꞌ Antioquía, tsjáclenëꞌ Pablo len Bernabé. Chopëꞌ naꞌ gulabö́ëꞌ, lëquëꞌ Judas, zoa yetú lëꞌ Barsabás, lencaꞌ Silas, nacquëꞌ bönniꞌ blau dzagquëꞌ bö́chiꞌruꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Guluzujëꞌ lu guich le guludödëꞌ lu naꞌquëꞌ luꞌë, le rna cni: ―Netuꞌ, gbaz nasölëꞌë Cristo, len bönniꞌ gul tun chiꞌë, len yuguꞌ bö́chiꞌruꞌ, rugaptuꞌ lbiꞌiliꞌ Dios, bö́chiꞌtuꞌ, nacliꞌ bunách gzaꞌa zoaliꞌ Antioquía len yuguꞌ yödz luyú Siria len Cilicia. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Byö́nituꞌ ca tun laꞌgac bunách gularúj ga zoatuꞌ, bönniꞌ naꞌ cutu bsö́laꞌtuꞌ lequëꞌ. Dutsaꞌquëꞌ lbiꞌiliꞌ niꞌa qui le taꞌnë́ꞌ, len tuꞌchíxinëꞌ icj ládxiꞌdauꞌliꞌ, le taꞌná bëꞌë grugu lu xpë́laꞌliꞌ len gunliꞌ ca rna bëꞌ zxba queëꞌ Moisés. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Qui lë ni naꞌ bdzag ládxiꞌtuꞌ catiꞌ chben tuz xtídzaꞌtuꞌ, grötuꞌ chopëꞌ bönniꞌ, nup gsö́laꞌtuꞌ, duyuquëꞌ lbiꞌiliꞌ. Guídlenquëꞌ Bernabé len Pablo, nup ni nadxiꞌiruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Chyjaquëꞌ gap gzoa banádx latiëꞌ Bernabé len Pablo le nadxiꞌicnëꞌ Xanruꞌ Jesucristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Cni nac, rsö́laꞌtuꞌ queëliꞌ Judas len Silas. Chopëꞌ ni laꞌguíxjöiꞌnëꞌ lbiꞌiliꞌ lë ni ruzujtuꞌ lu guich ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Buluiꞌinëꞌ netuꞌ Dios Böꞌ Laꞌy le rdzag ladxëꞌë, len lëzcaꞌ cni rdzag ládxiꞌtuꞌ netuꞌ, cutu uspágaꞌrtuꞌ lbiꞌiliꞌ yuaꞌ, le nac le rna bëꞌ zxba queëꞌ Moisés, san tuz yuguꞌ lë ni run bayúdx gunliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Cutu gáguliꞌ le nadö́d laugac bdauꞌ guiöj bdauꞌ yag. Cutu gáguliꞌ rön. Cutu gáguliꞌ xpë́laꞌcbaꞌ böaꞌ guixiꞌ cunarujcbaꞌ rön. Cutu gunliꞌ le cunác. Chquiꞌ gun chiꞌi cuinliꞌ, gunliꞌ ca rna yuguꞌ lë ni, gunliꞌ dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Cni guc guladxinëꞌ Antioquía yuguꞌ bönniꞌ naꞌ nasö́laꞌquëꞌ. Niꞌ gulutubëꞌ bunách queëꞌ Cristo nacuáꞌ niꞌ, atiꞌ gulaguꞌë lu naꞌquëꞌ guich naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Catiꞌ chbudx gululabëꞌ lei, guludzijnëꞌ ca nac le nayúj lu guich naꞌ, le ruhuíꞌ zxön lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Le nacquëꞌ caꞌ bönniꞌ tuꞌë didzaꞌ uláz queëꞌ Dios Judas len Silas, guluhuíꞌ zxönëꞌ lequëꞌ len gulutipëꞌ ládxiꞌquëꞌ bö́chiꞌruꞌ niꞌ, gulugunëꞌ dxin didzaꞌ zian gluíꞌlenëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Gdöd guludzeynëꞌ niꞌ nabáb dza chopëꞌ ni, niꞌr bö́chiꞌruꞌ niꞌ guluzeynëꞌ lequëꞌ dxiꞌa didzaꞌ quië tshuöjquëꞌ Jerusalén ga nacuꞌë bönniꞌ gulasölëꞌë lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bdzag ladxëꞌë Silas bugaꞌnëꞌ Antioquía. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Gulugaꞌnëꞌ caꞌ Antioquía Pablo len Bernabé, atiꞌ gulusëdnëꞌ bunách len glunëꞌ lban qui xtidzëꞌë Xanruꞌ. Lëzcaꞌ cni glun zianr caꞌ bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Gdöd nabáb dza Pablo gudxëꞌ Bernabé: ―Huayejruꞌ leyúbl tsajyucruꞌ‑nëꞌ bö́chiꞌruꞌ nacuꞌë yúguꞌtë yödz gap chyjenruꞌ lban qui xtidzëꞌë Xanruꞌ, quië gléꞌiruꞌ nacx rac quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Guꞌnnëꞌ Bernabé laꞌchë́ꞌë‑biꞌ biꞌi Juan Marcos, tséajlenbiꞌ lequëꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","san cutu bdzag ladxëꞌë Pablo laꞌchë́ꞌë‑biꞌ tséajlenbiꞌ lequëꞌ le buláꞌalenbiꞌ lequëꞌ luyú Panfilia len cutur yjénlenbiꞌ lequëꞌ dxin queëꞌ Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Cutu guc tuz xtídzaꞌquëꞌ Bernabé len Pablo ga bdxintë gululáꞌalenëꞌ tuëꞌ yetúëꞌ. Bchëꞌë‑biꞌ biꞌi Marcos Bernabé atiꞌ gulabenëꞌ tu lëꞌi barco, yjaquëꞌ luyú Chipre. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo gröëꞌ Silas quië tséajlenëꞌ lëꞌ. Niꞌr gulaguꞌë lequëꞌ lu nëꞌë Xanruꞌ bö́chiꞌruꞌ, gulanabnëꞌ Lëꞌ uzáꞌ ladxëꞌë quequëꞌ, atiꞌ zjaquëꞌ Pablo len Silas. ");
INSERT INTO zsrNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Guladödëꞌ yuguꞌ yödz luyú Siria len Cilicia, atiꞌ gulutipëꞌ ládxiꞌgac bunách queëꞌ Cristo nacuáꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Gdöd niꞌ guladxinëꞌ yödz Derbe len Listra Pablo len Silas. Niꞌ zoabiꞌ biꞌi bönniꞌ réjlëꞌbiꞌ Cristo, lëbiꞌ Timoteo. Nacbiꞌ zxiꞌnnu ngul judío réjlëꞌnu Cristo, san cutu naquëꞌ judío xuzbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tunëꞌ lnaꞌ lau queëbiꞌ bö́chiꞌruꞌ nacuꞌë Listra len Iconio, taꞌnë́ꞌ runbiꞌ le nac dxiꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Guꞌnnëꞌ Pablo tséajlenbiꞌ lëꞌ biꞌi ni, atiꞌ gdel‑lëꞌë‑biꞌ len bchuguëꞌ lu xpë́laꞌbiꞌ ca tun bunách judío. Cni benëꞌ cui laꞌnë́ꞌ queëbiꞌ bönniꞌ judío nacuꞌë niꞌ, le nözcnëꞌ yúguꞌtëꞌ cutu naquëꞌ judío xuzbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Catiꞌ guladödëꞌ gap nacuáꞌ yödz niꞌ Pablo len nup dzaggac lëꞌ, tu tu yödz naꞌ guludödëꞌ lu naꞌquëꞌ bö́chiꞌruꞌ nacuꞌë niꞌ yuguꞌ zxba naꞌ glunëꞌ gbaz nasölëꞌë Cristo len bönniꞌ gul tun chiꞌë bunách queëꞌ, nacuꞌë Jerusalén. Guludödëꞌ zxba ni lu naꞌquëꞌ quië lunëꞌ ca rna bëꞌ zxba naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Cni guc, guladíp ládxiꞌgac ca nac le réjlëꞌruꞌ Cristo yúguꞌtë cöꞌ bunách queëꞌ Cristo, atiꞌ gulayán tu tu dza. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Guladödëꞌ luyú Frigia len luyú Galacia Pablo len bönniꞌ dzagquëꞌ lëꞌ, le buzaguëꞌë xnözquëꞌ Dios Böꞌ Laꞌy, cui tsajtíxjöꞌquëꞌ xtidzëꞌë Xanruꞌ luyú Asia. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Catiꞌ guladxinëꞌ luyú Misia, glëꞌnnëꞌ tsjaquëꞌ luyú Bitinia, san cutu bëꞌë lequëꞌ latj Dios Böꞌ Laꞌy, Nu rsölëꞌë queëruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Niꞌr guladödëꞌ gal‑laꞌ ga dë Misia, atiꞌ yjaquëꞌ yödz Troas. Nedaꞌ Lucas, ruzujaꞌ quiuꞌ lu guich lë ni, gzoaꞌ Troas naꞌ, atiꞌ yajsóalenaꞌ‑nëꞌ Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lu yödz niꞌ Dios buluiꞌinëꞌ Pablo tu le bléꞌinëꞌ lu yël bëchcál. Buluíꞌ lahuëꞌ lëꞌ bönniꞌ Macedonia, zuinëꞌ len rátaꞌyuëꞌ lahuëꞌ Pablo, rnëꞌ: “Gdöd ladztuꞌ, lu xyutuꞌ Macedonia, len guclen netuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Catiꞌ bléꞌinëꞌ lë ni Pablo, lë naꞌ buluíꞌ lahui lëꞌ, laꞌ bëꞌ ládxiꞌtëtuꞌ tseajtuꞌ luyú Macedonia, le gúquibeꞌituꞌ Dios chbulidzëꞌ netuꞌ tsjentuꞌ lban qui didzaꞌ dxiꞌa laugac bunách luyú niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Niꞌr grentuꞌ lëꞌi barco, buzaꞌtuꞌ Troas. Tinz gdödtuꞌ ga bdxintuꞌ Samotracia, atiꞌ gdöd yetú dza bdxintuꞌ yödz Neápolis. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Buzaꞌtuꞌ niꞌ, atiꞌ bdxintuꞌ Filipos, yödz naꞌ nacr blau ca yúguꞌtë yödz nababgac tslaꞌa niꞌ luyú Macedonia. Lu yödz niꞌ nucuaꞌquëꞌ bunách uládz quequëꞌ bönniꞌ Roma. Lu yödz niz gzoatuꞌ nabáb dza. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Catiꞌ bdxin tu dza laꞌy, brujtuꞌ lu yödz, gyeajtuꞌ raꞌ yegu ga naꞌ tuꞌdúbcz, tuꞌlídz Dios bunách yödz naꞌ. Niꞌ gröꞌtuꞌ len gdíxjöiꞌtuꞌ ngul nudubcnu niꞌ ca nac xtidzëꞌë Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nútsaꞌnu ladjcnu niꞌ Lidia, ngul Tiatira. Nacnu ngul huëtiꞌ lariꞌ xna záquiꞌtsqui. Rej ládxiꞌnu Dios ngul ni, atiꞌ buzë́ nagnu didzaꞌ bëꞌë Pablo, atiꞌ Xanruꞌ gúclenëꞌ‑nu quië gzxiꞌ lu naꞌnu didzaꞌ naꞌ bëꞌë Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Niꞌr bdilnu nis lënu, atiꞌ guladíl caꞌ nis bunách nacuáꞌ lidxnu. Gdöd niꞌ gútaꞌyunu lautuꞌ, gnanu: ―Chquiꞌ ráquibeꞌiliꞌ réjlëꞌa Xanruꞌ, gul‑tsáz lidxaꞌ, len gul‑zóa niꞌ. Bennu bayúdx ugaꞌntuꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yetú le guc tu dza tsal niꞌ zeajtuꞌ ga naꞌ rulidztuꞌ‑nëꞌ Dios, brujbiꞌ dutsagbiꞌ netuꞌ biꞌi ngul yuꞌu lëbiꞌ böꞌ run ga rnë yaꞌabiꞌ. Len yöl‑laꞌ rnë yaꞌa queëbiꞌ runbiꞌ ga taꞌziꞌtsquëꞌ dumí bönniꞌ xanbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Biꞌi ngul ni zajnaubiꞌ‑nëꞌ Pablo len netuꞌ, ruiꞌbiꞌ zidzj didzaꞌ, rnabiꞌ: ―Bönniꞌ ni tunëꞌ xchinëꞌ Dios náctërëꞌ blau. Taꞌguíxjöiꞌnëꞌ lbiꞌiliꞌ nac gac ulaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Cni benbiꞌ zian dza. Catiꞌ cutur bdzag ladxëꞌë Pablo, bueycjëꞌ len bulidzëꞌ böꞌ naꞌ yuꞌu lëbiꞌ, rnëꞌ: ―Niꞌa queëꞌ Xanruꞌ Jesucristo, rna béꞌidaꞌ liꞌ. Burúj icj ládxiꞌdauꞌbiꞌ biꞌi ngul ni. Laꞌ niꞌz burujtë böꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Catiꞌ gulaléꞌinëꞌ xanbiꞌ chburúj böꞌ naꞌ run ga rnë yaꞌabiꞌ, len cutur nac löz laꞌziꞌë dumí niꞌa queëbiꞌ, qui lë ni naꞌ gulazönëꞌ Pablo len Silas, atiꞌ gulachë́ꞌë lequëꞌ lauquëꞌ bönniꞌ yúlahuiꞌ, nudubquëꞌ ga nac lu yëꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Gulucuꞌë lequëꞌ lauquëꞌ bönniꞌ yúlahuiꞌ naꞌ, taꞌnë́ꞌ: ―Nacquëꞌ judío bönniꞌ ni len tunëꞌ ga tun rusbö́ bunách yödz ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tuꞌsëdnëꞌ le cural‑laꞌ siꞌ lu naꞌruꞌ len cural‑laꞌ gunruꞌ, le nababruꞌ Roma. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Niꞌr guladáꞌbagaꞌ Pablo len Silas bunách zian niꞌ, atiꞌ gulaná béꞌinëꞌ nup gulaléycj lariꞌ nácuquëꞌ Pablo len Silas bönniꞌ yúlahuiꞌ, atiꞌ gulaguinëꞌ lequëꞌ gbaꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gdöd gulaguintsquëꞌ lequëꞌ, gulaguꞌë lequëꞌ lidx guia. Gulaná béꞌinëꞌ bönniꞌ ruseyjëꞌ lidx guia naꞌ gun chiꞌitsquëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bönniꞌ ni, catiꞌ chgulaná béꞌinëꞌ lëꞌ cni, gluꞌë lequëꞌ lu yuꞌu död lidx guia naꞌ, len gluꞌë níꞌaquëꞌ yeru yag taꞌzö́n níꞌaquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Gdu ladxiꞌ yël tuꞌlidzëꞌ Dios Pablo len Silas, len tul‑lëꞌ yöl‑laꞌ ba queëꞌ Dios, atiꞌ taꞌyönnëꞌ bönniꞌ nadzunquëꞌ lidx guia naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Niꞌr tu tsalz gtittsca luyú. Cni guc ga bdxintë gzxiz xlibi zöꞌö lidx guia naꞌ, atiꞌ laꞌ gulayaljtë yúguꞌtë gap nu ryaz, atiꞌ guluhuédx caꞌ du guia nágaꞌgac bönniꞌ nadzunquëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bubanëꞌ bönniꞌ naꞌ ruseyjëꞌ lidx guia. Catiꞌ bléꞌinëꞌ nayaljgac gap nu ryaz lidx guia naꞌ, gleycjëꞌ guia tuchiꞌ queëꞌ quië gdödi cuinëꞌ, le ráquinëꞌ chguluzxundjëꞌ bönniꞌ nadzunquëꞌ lidx guia naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Niꞌr zidzj bulidzëꞌ lëꞌ Pablo, gnëꞌ: ―Cutu bi guni cuinuꞌ, le zoatuꞌ ni yúguꞌtëtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Niꞌr gnabëꞌ guiꞌ bönniꞌ naꞌ, atiꞌ gdaꞌatëꞌ lu yuꞌu lidx guia naꞌ. Gzxiztsquëꞌ lu yöl‑laꞌ radxi, atiꞌ byechuëꞌ xníꞌaquëꞌ Pablo len Silas. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Catiꞌ chnubijëꞌ lequëꞌ lidx guia naꞌ, gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ, bönniꞌ, ¿bizxa ral‑laꞌ gunaꞌ quië uláꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Lequëꞌ tëꞌ lëꞌ: ―Gyejlëꞌë Xanruꞌ Jesucristo atiꞌ uláuꞌ liꞌ, len lëzcaꞌ cni lulá bunách nacuáꞌ lidxuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Gluíꞌlenëꞌ lëꞌ didzaꞌ ca nac qui xtidzëꞌë Xanruꞌ, dzaggac lëꞌ yúguꞌtë bunách nacuáꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Laꞌ naꞌz, niꞌ nac chdzöꞌl laꞌ bchëꞌtëꞌ lequëꞌ, atiꞌ yajtibëꞌ lequëꞌ ga dxiaquëꞌ huëꞌ. Gdöd niꞌ, laꞌ bdiltëꞌ nis, atiꞌ guladíl caꞌ nis yúguꞌtë bunách nacuáꞌ lidxëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Niꞌr bchëꞌë lequëꞌ lidxëꞌ, len bëꞌë le glahuëꞌ. Rudzijnëꞌ lëꞌ len tuꞌdziji caꞌ yúguꞌtë bunách nacuáꞌ lidxëꞌ le taꞌyejlëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Catiꞌ zaꞌ reníꞌ dza naꞌ, gulasölëꞌë niꞌa naꞌquëꞌ bönniꞌ yúlahuiꞌ, atiꞌ glëꞌ bönniꞌ naꞌ ruseyjëꞌ lidx guia, taꞌnë́ꞌ: ―Bsan‑quëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Niꞌr gdíxjöiꞌnëꞌ Pablo didzaꞌ ni bönniꞌ naꞌ ruseyjëꞌ lidx guia, gnëꞌ: ―Gulasölëꞌë didzaꞌ bönniꞌ yúlahuiꞌ usanaꞌ lbiꞌiliꞌ. Naꞌa, gul‑rúj, len gul‑huö́j dxíꞌadauꞌ ga rzoaliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Niꞌr brujëꞌ Pablo len gudxëꞌ yuguꞌ niꞌa naꞌquëꞌ bönniꞌ yúlahuiꞌ naꞌ, gnëꞌ: ―Chgulaguinëꞌ netuꞌ laugac bunách zal‑laꞌ cutu narúguini queëtuꞌ ca rna bëꞌ zxba, len gulaguꞌë netuꞌ lidx guia, atiꞌ netuꞌ ni nababtuꞌ Roma. ¿Naruꞌ tuꞌsantsëꞌ netuꞌ bagachiꞌz? Cutu caꞌ gac. Lídgarëꞌ lequëꞌ dusanquëꞌ netuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Yhuöjquëꞌ niꞌa naꞌquëꞌ bönniꞌ yúlahuiꞌ naꞌ yajtíxjöiꞌcnëꞌ bönniꞌ yúlahuiꞌ didzaꞌ ni, atiꞌ lequëꞌ gládxinëꞌ catiꞌ gulayönnëꞌ nababquëꞌ Roma Pablo len Silas. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Catiꞌ guladxinëꞌ lidx guia niꞌ, glátaꞌyuëꞌ lauquëꞌ Pablo len Silas cutu luspaguëꞌë lequëꞌ zxguiaꞌ. Niꞌr gulabijëꞌ lequëꞌ lidx guia naꞌ len glátaꞌyuëꞌ lauquëꞌ lurujëꞌ yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Niꞌr gularujëꞌ lidx guia naꞌ Pablo len Silas, atiꞌ gulayaziëꞌ lidxnu Lidia. Catiꞌ chgulaléꞌinëꞌ bö́chiꞌruꞌ nacuꞌë niꞌ, guluchiziëꞌ didzaꞌ icj nagquëꞌ atiꞌ laꞌ guluzaꞌtëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Guladödëꞌ Pablo len Silas lu yödz Anfípolis len lu yödz Apolonia, atiꞌ guladxinëꞌ lu yödz Tesalónica, ga niꞌ zoa tu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bugaꞌnëꞌ niꞌ Pablo gdu galj dza, len ca runczëꞌ, gyijëꞌ ga zoa yuꞌu naꞌ catiꞌ nac dza laꞌy quequëꞌ bönniꞌ judío, atiꞌ bë́ꞌlenëꞌ lequëꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Busálj laꞌnëꞌ len buluiꞌinëꞌ lequëꞌ rusëdi le nayúj lu guich laꞌy run bayúdx sacaꞌ quiꞌë Cristo, Nu naꞌ tunëꞌ löz bönniꞌ judío duslë́ꞌ lequëꞌ, atiꞌ töd gatiëꞌ ubanëꞌ lu yöl‑laꞌ gut. Niꞌr gudxëꞌ lequëꞌ Pablo: ―Cni guc queëꞌ bönniꞌ naꞌ lëꞌ Jesús, runaꞌ lban queëꞌ ga ni zoaliꞌ. Bönniꞌ ni naquëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Niꞌr gulayejlëꞌë Cristo laꞌquëꞌ, atiꞌ glunëꞌ tsazxö́n Pablo len Silas. Lëzcaꞌ cni gulayejlëꞌë Cristo zian bönniꞌ gzaꞌa, bönniꞌ taꞌyíj ládxiꞌquëꞌ Dios. Lëzcaꞌ gulayéjlëꞌnu Cristo ngul blau zian. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Niꞌr lu yöl‑laꞌ ruzxeꞌi quequëꞌ Pablo bönniꞌ judío cutaꞌyejlëꞌ, gulutubëꞌ bönniꞌ cunacquëꞌ tsahuiꞌ, bönniꞌ taꞌdazëꞌ caꞌ. Catiꞌ chgulutubëꞌ bunách zian, glunëꞌ ga glun rusbö́ gdu lu yödz naꞌ, atiꞌ bayúdx gulayaziëꞌ lidxëꞌ Jasón quië lubijëꞌ Pablo len Silas laugac bunách naꞌ tun rusbö́. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Catiꞌ cutu guludzölnëꞌ Pablo len Silas, gulabijëꞌ Jasón len yezícaꞌrëꞌ bö́chiꞌruꞌ nacuꞌë niꞌ, atiꞌ gulachë́ꞌë lequëꞌ lauquëꞌ bönniꞌ yúlahuiꞌ. Gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Chguladxinëꞌ caꞌ ni bönniꞌ naꞌ nutsáꞌquëꞌ bunách gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón ni gluꞌë lequëꞌ lidxëꞌ. Taꞌdáꞌbaguëꞌë zxba queëꞌ César, bönniꞌ rna béꞌinëꞌ rëꞌu, yúguꞌtë bönniꞌ ni, taꞌnë́ꞌ: “Zoëꞌ yetúëꞌ bönniꞌ rna bëꞌë, lëꞌ Jesús.” ");
INSERT INTO zsrNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Catiꞌ gulayönnëꞌ lë ni, gulaböꞌë baguíꞌi bönniꞌ lu yödz len bönniꞌ yúlahuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Niꞌr, gdöd gulaziꞌë dumí le bucáꞌngarëꞌ Jasón len yezícaꞌrëꞌ bönniꞌ naꞌ bönniꞌ yúlahuiꞌ, gulusanëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Niꞌr laꞌ gulasö́laꞌtëꞌ Pablo len Silas bö́chiꞌruꞌ niꞌ, niꞌ nac chdzöꞌl, zjaquëꞌ yödz Berea. Catiꞌ guladxinëꞌ niꞌ, gulayaziëꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío nacuꞌë niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Glacrëꞌ tsahuiꞌ bönniꞌ ni ca bönniꞌ nacuꞌë Tesalónica, le gulazíꞌ lu naꞌquëꞌ xtidzëꞌë Xanruꞌ gdu ládxiꞌquëꞌ. Yuguꞌ dza gululabtsquëꞌ dxiꞌa le nayúj lu guich laꞌy, quië láquibeꞌinëꞌ chquiꞌ nacz lë naꞌ rnëꞌ Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Cni guc, gulayejlëꞌë Cristo zian bönniꞌ judío. Lëzcaꞌ cni, gulayejlëꞌë Cristo zian bönniꞌ gzaꞌa, yuguꞌ ngul blau len yuguꞌ bönniꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Niꞌr catiꞌ gláquibeꞌinëꞌ bönniꞌ judío nacuꞌë Tesalónica, lëzcaꞌ rguíxjöꞌë Pablo xtidzëꞌë Dios lu yödz Berea, yjaquëꞌ niꞌ, len glunëꞌ caꞌ niꞌ ga glun rusbö́ bunách zian. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Niꞌr laꞌ gulasö́laꞌtëꞌ Pablo bö́chiꞌruꞌ niꞌ, tsijëꞌ ga nac raꞌ nis zxön, san gulugaꞌnzëꞌ Berea Silas len biꞌi Timoteo. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Gulachë́ꞌë Pablo bönniꞌ Berea naꞌ lu yödz Atenas. Niꞌr laꞌ yhuöjctëꞌ lu yödz Berea, tuꞌúꞌë xtidzëꞌë Pablo, lëꞌ Silas len biꞌi Timoteo tsjactëꞌ ga niꞌ zoëꞌ Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Tsal niꞌ zoëꞌ Pablo rbözëꞌ Silas len biꞌi Timoteo lu yödz Atenas, ruhuiꞌni ladxëꞌë le rléꞌinëꞌ taꞌyíj ládxiꞌgac bdauꞌ guiöj bdauꞌ yag yúguꞌtë bunách yödz naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Qui lë ni naꞌ bë́ꞌlenëꞌ bönniꞌ judío len bönniꞌ taꞌyíj ládxiꞌquëꞌ Dios didzaꞌ ga nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios. Yuguꞌ dza bë́ꞌlenëꞌ nup taꞌdá lu yëꞌy didzaꞌ ca nac xtidzëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gluíꞌlenëꞌ Pablo didzaꞌ laꞌquëꞌ bönniꞌ daꞌquëꞌ le tuꞌsëdnëꞌ bönniꞌ epicúreo len le tuꞌsëdnëꞌ bönniꞌ estoico. Laꞌquëꞌ gulanë́ꞌ: ―¿Bizxa rë́ꞌnitsanëꞌ gnëꞌ bönniꞌ huëꞌ didzaꞌ ni? Yelaꞌquëꞌ gulanë́ꞌ: ―Ráquituꞌ naquëꞌ nu run lban quegac dios ziꞌtuꞌ. Cni gulanë́ꞌ le runëꞌ lban Pablo lauquëꞌ qui didzaꞌ dxiꞌa queëꞌ Jesús, len qui yöl‑laꞌ rubán. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Niꞌr gulaguel‑lëꞌë nëꞌë Pablo, len gulachë́ꞌë lëꞌ lu guiꞌa ga tuꞌdubëꞌ tuꞌë didzaꞌ, nazíꞌ lei Areópago, taꞌnë́ꞌ: ―¿Naruꞌ huactsa yö́nituꞌ didzaꞌ cub ni rguíxjöꞌu? ");
INSERT INTO zsrNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Rusyönnuꞌ netuꞌ le tun ga rubánituꞌ. Naꞌa, rë́ꞌnituꞌ gnö́zituꞌ bizxa rna didzaꞌ ni ruꞌu. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Cutur bi taꞌdzág ládxiꞌquëꞌ lunëꞌ bönniꞌ Atenas naꞌ len bönniꞌ gzaꞌa nacuꞌë niꞌ, san laꞌyö́niznëꞌ len luiꞌzëꞌ didzaꞌ tu le cub. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Niꞌr gzuinëꞌ Pablo gatsj lahuiꞌl löꞌa Areópago naꞌ, gnëꞌ: ―Bönniꞌ Atenas, yúguꞌtë le rléꞌidaꞌ nac bëꞌ szxöni rej ládxiꞌgacliꞌ dios queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Catiꞌ gdödaꞌ lu yödz len buyúgacaꞌ le rej ládxiꞌliꞌ, yajxacaꞌa caꞌ tu nich ga niꞌ nayúj le rna cni: “Tu Dios, Nutu Nu Nunbëꞌ Lëꞌ.” Dios naꞌ rej ládxiꞌliꞌ‑nëꞌ zal‑laꞌ cutu núnbëꞌliꞌ‑nëꞌ, Dios ni runaꞌ lban queëꞌ lauliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios ni benëꞌ yödzlyú len yúguꞌtë le nacuáꞌ yödzlyú ni. Naquëꞌ Xani yehuaꞌ yubá len Xani luyú ni, len cutu caꞌ zoëꞌ gdauꞌ nungac bunách. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Cutu bi ryadzj queëꞌ le gac lunö́dzj queëꞌ bunách, le runödzjëꞌ Lëczëꞌ quegac yúguꞌtë bunách yöl‑laꞌ naꞌbán len yúguꞌtë le rquíniruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Lëꞌ benëꞌ tuzëꞌ bönniꞌ ga zaꞌc yúguꞌtë bunách gzaꞌa quië laꞌcuáꞌ gdu yödzlyú, len buluꞌë dza laꞌcuáꞌ len gap ral‑laꞌ laꞌcuáꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dios bucuꞌë lequëꞌ quië luguiljëꞌ Lëꞌ, chquiꞌ náctiꞌtëz laꞌdzölnëꞌ Lëꞌ zal‑laꞌ laꞌgán laꞌzönzëꞌ. Cni rac zal‑laꞌ cutu zoëꞌ ziꞌtuꞌ ga zoaruꞌ tu turuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Lëczëꞌ runëꞌ ga zoaruꞌ nabanruꞌ, len bi gac gunruꞌ, len le nacruꞌ. Nac ca naꞌ gulanë́ꞌ laꞌquëꞌ bönniꞌ nútsaꞌquëꞌ ladjliꞌ, nup guluzúj yuguꞌ le rul‑l, gulanë́ꞌ: “Diꞌa dza queëꞌ Dios nacruꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Naꞌa, chquiꞌ nacruꞌ diꞌa dza queëꞌ Dios, cutu ral‑laꞌ gnaruꞌ naquëꞌ Dios ca tu bdauꞌ guiöj bdauꞌ yag o le náquini oro, o plata, o guiöj, le nungac bunách ca nac tu le taꞌguíndjz icjgac. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dios budödëꞌ caꞌz yuguꞌ le glunëꞌ lu yöl‑laꞌ curejniꞌi quequëꞌ iz chguladö́d, san naꞌa rna béꞌinëꞌ yúguꞌtë bunách gdutë yödzlyú lubíꞌi ládxiꞌgac. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dios chnuluꞌë tu dza catiꞌ cuequi xbeynëꞌ yúguꞌtë bunách. Gdu tsahuiꞌ nac ca cuequi xbeynëꞌ lequëꞌ lu nëꞌë Jesús, bönniꞌ naꞌ buzoaczëꞌ Lëꞌ, atiꞌ laugac yúguꞌtë bunách benëꞌ tsutsu gac cni le buspanëꞌ Lëꞌ lu yöl‑laꞌ gut. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Catiꞌ gulayönnëꞌ didzaꞌ bëꞌë Pablo ca guc, zoa nu bubán lu yöl‑laꞌ gut, gulutitjëꞌ laꞌquëꞌ, atiꞌ yelaꞌquëꞌ gulanë́ꞌ: ―Yö́nigatuꞌ yetú lë ni ruꞌu didzaꞌ qui. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Niꞌr burujëꞌ Pablo gatsj lahuiꞌl ga naꞌ nacuꞌë, zhuöjëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Gulayejlëꞌë Cristo laꞌquëꞌ, len glunëꞌ tsazxö́n Pablo. Nutsëꞌë ladjquëꞌ Dionisio, bönniꞌ areópago, atiꞌ nútsaꞌnu caꞌ ladjquëꞌ ngul naꞌ lënu Dámaris. Gulayejlëꞌë caꞌ Cristo yelaꞌquëꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Gdöd guc lë ni, buzë́ꞌë Pablo yödz Atenas naꞌ, atiꞌ gyijëꞌ yödz Corinto. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Niꞌ yajxaquëꞌë Aquilo, bönniꞌ judío. Guljëꞌ bönniꞌ ni luyú Ponto, len ziꞌa bdxíngazëꞌ Corinto naꞌ. Buzë́ꞌë luyú Italia len ngul queëꞌ, lënu Priscila, le gna bëꞌë Claudio, bönniꞌ uná bëꞌ, lurujëꞌ yödz Roma bönniꞌ judío. Gyijëꞌ Pablo ga nacuꞌë Aquilo len Priscila naꞌ ");
INSERT INTO zsrNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","le nac tuz dxin tunëꞌ Aquilo len Pablo. Bugáꞌnlenëꞌ lequëꞌ, atiꞌ tsazxö́n glunëꞌ dxin, tunëꞌ yuꞌu láriꞌdauꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Catiꞌ nacgac dza laꞌy quequëꞌ bönniꞌ judío, ryaziëꞌ Pablo lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, ga niꞌ bë́ꞌlenëꞌ lequëꞌ didzaꞌ. Guꞌnnëꞌ uluiꞌinëꞌ bönniꞌ judío len bönniꞌ gzaꞌa nacuꞌë niꞌ, nac gdutë li le rguíxjöꞌë ca nac queëꞌ Jesucristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Catiꞌ guladxinëꞌ niꞌ Silas len biꞌi Timoteo, nuzaꞌquëꞌ luyú Macedonia, nuguíꞌtsquinëꞌ Pablo, runëꞌ lban qui xtidzëꞌë Dios len runëꞌ lnaꞌ lau lauquëꞌ bönniꞌ judío, rnëꞌ: ―Jesús naquëꞌ Cristo, Nu naꞌ tunëꞌ löz bönniꞌ judío duslë́ꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Catiꞌ guladáꞌbaguëꞌë xtidzëꞌë bönniꞌ judío nacuꞌë niꞌ, len gulanë́ ziꞌë qui, niꞌr gdxibëꞌ lariꞌ nacuëꞌ Pablo quië uluiꞌinëꞌ lequëꞌ cutur nabaguëꞌë lëꞌ niꞌa quequëꞌ, atiꞌ gudxëꞌ lequëꞌ: ―Laꞌ cuinzliꞌ nabágaꞌliꞌ zxguiaꞌ qui yöl‑laꞌ gut queëliꞌ, clëg nedaꞌ nabagaꞌa lei. Naꞌa, huayijaꞌ ga nacuáꞌ bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Niꞌr burujëꞌ niꞌ Pablo, gyijëꞌ lidxëꞌ Justo, bönniꞌ rej ladxëꞌë Dios, atiꞌ zoa lidxëꞌ gal‑laꞌ raꞌ yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Gyejlëꞌë Xanruꞌ Jesús Crispo, bönniꞌ blau qui yuꞌu ga naꞌ tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios, dzaggac lëꞌ yúguꞌtë bunách nacuáꞌ lidxëꞌ. Catiꞌ gulayönnëꞌ xtidzëꞌë Dios, gulayejlëꞌë Cristo zian bönniꞌ Corinto, atiꞌ guladilëꞌ nis. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Niꞌr Lëczëꞌ Xanruꞌ gudxëꞌ Pablo lu yël bëchcál, gnëꞌ: ―Cutu gádxinuꞌ, len cutu suꞌ dxiz, quíxjöꞌu xtidzaꞌa, ");
INSERT INTO zsrNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","le zóalenczaꞌ liꞌ nedaꞌ, atiꞌ nutu nu ulapaꞌ nëꞌi liꞌ quië guaꞌ döꞌ quiuꞌ, le náquigac quiaꞌ bunách zian lu yödz ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gdu ca tu iz yu gatsj bugaꞌnëꞌ niꞌ Pablo, atiꞌ busëdnëꞌ lequëꞌ xtidzëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Catiꞌ bdxin dza rna bëꞌë Galión luyú Acaya, glaquëꞌ tuz bönniꞌ judío cutaꞌyejlëꞌ, atiꞌ guladáꞌbaguëꞌë Pablo, len gulachë́ꞌë lëꞌ ga röꞌë rbequi xbeynëꞌ Galión naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Glëꞌ Galión naꞌ: ―Bönniꞌ ni rguꞌu yöl‑lëꞌë bunách quië lunëꞌ ba laꞌn Dios, ca rdáꞌbagaꞌ zxba queëtuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Catiꞌ chzoa guꞌë didzaꞌ Pablo, Galión naꞌ gudxëꞌ yuguꞌ bönniꞌ judío, rnëꞌ: ―Lbiꞌiliꞌ, bönniꞌ judío, laꞌnaruꞌ guc le rguitsj zxba queëꞌ César, o tu le cunác, guaꞌ glenaꞌ uzë́ nagaꞌ xtídzaꞌliꞌ ca ral‑laꞌ gunaꞌ, ");
INSERT INTO zsrNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","san chquiꞌ nac didzaꞌ bizxj qui didzaꞌz, o qui lagac bunách, len ca nac zxba queëzliꞌ, gul‑cáꞌn tsahuiꞌ lbiꞌizliꞌ, le cutu rëꞌndaꞌ nedaꞌ gacaꞌ nu cuequi xbey yuguꞌ le cni. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Niꞌr bulaguëꞌë lequëꞌ Galión lu yuꞌu yúlahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Niꞌr gulaguel‑lëꞌë Sóstenes, bönniꞌ blau qui yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, yúguꞌtë bönniꞌ uládz naꞌ, atiꞌ gulaguinëꞌ lëꞌ löꞌa yúlahuiꞌ, san cutu bëꞌ ladxëꞌë Galión lë naꞌ rac. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Zian dza bugaꞌnëꞌ lu yödz naꞌ Pablo, atiꞌ gdöd buzeynëꞌ bö́chiꞌruꞌ nacuꞌë niꞌ didzaꞌ, gyijëꞌ yödz Cencrea, ga niꞌ benëꞌ yutuz icjëꞌ, le dë tu le nazíꞌ lu nëꞌë lahuëꞌ Dios gunëꞌ. Niꞌr grenëꞌ tu lëꞌi barco, gyijëꞌ luyú Siria, dzagquëꞌ lëꞌ Priscila len Aquilo. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Catiꞌ guladxinëꞌ yödz Éfeso, niꞌ buláꞌalenëꞌ lequëꞌ Pablo. Gyaziëꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, atiꞌ bë́ꞌlenëꞌ nup nacuáꞌ niꞌ didzaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Glátaꞌyuëꞌ lahuëꞌ Pablo bönniꞌ niꞌ ugáꞌnlenëꞌ lequëꞌ yelatiꞌ xtsey, san lëꞌ cutu guꞌnnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Buzeynëꞌ lequëꞌ didzaꞌ, gnëꞌ: ―Run bayúdx soaꞌ gapaꞌ lni ziꞌa gac Jerusalén, atiꞌ leyúbl huödaꞌ ga ni zoaliꞌ, chquiꞌ huëꞌnnëꞌ Dios. Niꞌr grenëꞌ lëꞌi barco Pablo, buzë́ꞌë Éfeso naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Gdöd bdxinëꞌ Pablo yödz Cesarea, grenëꞌ gyijëꞌ Jerusalén, ga niꞌ yajyúëꞌ bunách queëꞌ Cristo, atiꞌ niꞌr buzë́ꞌë niꞌ, gyijëꞌ Antioquía. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Gdöd zoëꞌ niꞌ nabáb dza, brujëꞌ niꞌ, zijëꞌ tu tu yödz luyú Galacia len Frigia. Benëꞌ tsutsu bö́chiꞌruꞌ nacuꞌë niꞌ ca nac le taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tu dza niꞌ bdxinëꞌ Éfeso Apolos, bönniꞌ judío. Guljëꞌ bönniꞌ ni lu yödz Alejandría, len nabéꞌitsquinëꞌ ruꞌë didzaꞌ, len nazëdtsquëꞌ le nayúj lu guich laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Chnazëdëꞌ bönniꞌ ni ca nac le réjlëꞌruꞌ Xanruꞌ. Gdu ladxëꞌë bëꞌë didzaꞌ, len ca nacz busëdnëꞌ bunách ca nac queëꞌ Jesús, zal‑laꞌ nunbëꞌë tuz le ruquíl bunách nis ca benëꞌ Juan. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Gzu lahuëꞌ Apolos ruꞌë didzaꞌ gdu ladxëꞌë ga nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Catiꞌ gulayönnëꞌ didzaꞌ ruꞌë Apolos naꞌ Priscila len Aquilo, gulachë́ꞌë lëꞌ quizi, atiꞌ guluzéjniꞌnëꞌ lëꞌ dxiꞌar ca nac didzaꞌ queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Catiꞌ guꞌnnëꞌ Apolos tödëꞌ luyú Acaya, gulutipëꞌ ladxëꞌë bö́chiꞌruꞌ nacuꞌë Éfeso, atiꞌ guluzujëꞌ lu guich le tsjuꞌë lu naꞌquëꞌ bönniꞌ taꞌyejlëꞌë Cristo luyú Acaya naꞌ, quië lunëꞌ ba laꞌn Apolos. Catiꞌ bdxinëꞌ Apolos luyú niꞌ, guluziꞌtsca xbey didzaꞌ ruꞌë Apolos naꞌ nup niꞌ chtaꞌyejlëꞌ Cristo, le ruzáꞌ ladxëꞌë quequëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Cni guc, le buxicjëꞌ yuguꞌ bönniꞌ judío niꞌ Apolos laugac yúguꞌtë bunách, le bugunëꞌ dxin le nayúj lu guich laꞌy, buluꞌë naquëꞌ Cristo bönniꞌ naꞌ lëꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tsal niꞌ zoëꞌ Apolos lu yödz Corinto, gdödëꞌ Pablo gap nacuáꞌ yödz yelatiꞌ raꞌl, atiꞌ bdxinëꞌ Éfeso. Niꞌ yajxaquëꞌë laꞌquëꞌ bönniꞌ taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Gnabnëꞌ lequëꞌ Pablo, rnëꞌ: ―¿Naruꞌ dusóalenëꞌ lbiꞌiliꞌ Dios Böꞌ Laꞌy catiꞌ niꞌ ziꞌa gyéjlëꞌliꞌ Cristo? Glëꞌ lëꞌ: ―Cutu nayö́nituꞌ chquiꞌ zoëꞌ Dios Böꞌ Laꞌy. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Niꞌr gnabnëꞌ lequëꞌ Pablo, rnëꞌ: ―¿Nacx guc le bdil‑liꞌ nis? Taꞌnë́ꞌ: ―Ca buquilëꞌ bunách nis Juan. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo gnëꞌ: ―Buquilëꞌ bunách nis Juan, nup niꞌ gulubíꞌi ládxiꞌgac, atiꞌ Juancz gudxëꞌ lequëꞌ ral‑laꞌ laꞌyejlëꞌë Nu naꞌ ziꞌa zaꞌtël ca lëꞌ, atiꞌ Nu ni nac Jesús, lëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Catiꞌ gulayönnëꞌ didzaꞌ ni ruꞌë Pablo bönniꞌ naꞌ, guladilëꞌ nis le chtaꞌyejlëꞌë Xanruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Catiꞌ bxoa nëꞌë lequëꞌ Pablo, rulidzëꞌ Dios, dusóalenëꞌ lequëꞌ Dios Böꞌ Laꞌy, atiꞌ gluꞌë didzaꞌ yubl, len gluꞌë didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Glaquëꞌ bönniꞌ ni gdu chinnuëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Gdu ca tsonn beoꞌ zoëꞌ niꞌ Pablo, atiꞌ gyaziëꞌ lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío, len lu yöl‑laꞌ rugu ladxiꞌ benëꞌ lban lauquëꞌ. Bë́ꞌlenëꞌ lequëꞌ didzaꞌ, guꞌnnëꞌ uluiꞌinëꞌ lequëꞌ nacz le rguíxjöꞌë ca rna bëꞌë Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Niꞌr bzid icj ládxiꞌdauꞌquëꞌ laꞌquëꞌ len cutu gulayejlëꞌë Cristo, atiꞌ gulanë́ ziꞌë qui didzaꞌ queëꞌ Xanruꞌ ga nacuáꞌ bunách zian naꞌ. Niꞌr buláꞌalenëꞌ lequëꞌ Pablo len bubijëꞌ quizi nup taꞌyejlëꞌ Cristo. Yuguꞌ dza bë́ꞌlenëꞌ bunách ni taꞌyejlëꞌ Cristo didzaꞌ ga naꞌ tuꞌdubëꞌ lu yuꞌu ga rusëdnëꞌ bunách Tiranno. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Cni bénteczëꞌ Pablo gdu ca chop iz, atiꞌ cni guc, gulayöni didzaꞌ ca nac queëꞌ Xanruꞌ Jesús yúguꞌtë bunách gap nacuáꞌ yödz luyú Asia, bunách judío len bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios benëꞌ yuguꞌ yöl‑laꞌ huac zxön lu nëꞌë Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Cni guc, gulaziꞌë yuguꞌ láriꞌdauꞌ béguëꞌë icjëꞌ Pablo len yuguꞌ lariꞌ tslaꞌa bugal‑lëꞌ lëꞌë laꞌquëꞌ bönniꞌ, atiꞌ yjuaꞌquëꞌ leygac gap nacuáꞌ nup teꞌi, atiꞌ guluhuöaquëꞌ ca nac guidzhuë́ꞌ qui queëquëꞌ, len gulurúj böꞌ xöhuiꞌ yuꞌugac bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Niꞌr glëꞌnnëꞌ lugunëꞌ dxin lëꞌ Xanruꞌ Jesús laꞌquëꞌ bönniꞌ judío udá dzag tuꞌbijëꞌ böꞌ xöhuiꞌ, quië lubijëꞌ böꞌ xöhuiꞌ yuꞌugac bunách, taꞌnë́ꞌ: ―Len lëꞌ Jesús, Nu naꞌ runëꞌ lban qui Pablo, rna béꞌituꞌ lbiꞌiliꞌ urujliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Cni glunëꞌ gadx bönniꞌ zxiꞌnëꞌ Esceva, bönniꞌ judío, bönniꞌ blau ladjquëꞌ bxuz uná bëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bubíꞌi didzaꞌ böꞌ xöhuiꞌ naꞌ, gna: ―Núnbëꞌa‑nëꞌ Jesús, len nözdaꞌ nu nac Pablo, san lbiꞌiliꞌ, ¿núzxatë lbiꞌiliꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Niꞌr gxítiꞌë bönniꞌ naꞌ yuꞌu lëꞌ böꞌ xöhuiꞌ, yjenëꞌ lequëꞌ ziꞌ len buxicjëꞌ yúguꞌtëꞌ, le gzxáquiꞌrnëꞌ ca lequëꞌ. Cni guc, xguídgaczëꞌ len huë́ꞌgactëzëꞌ guluzxundjëꞌ lu yuꞌu niꞌ gadxëꞌ bönniꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ca guc lë ni gzë didzaꞌ atiꞌ gulayöni yúguꞌtë nup nacuáꞌ Éfeso, bunách judío len bunách gzaꞌa, atiꞌ yúguꞌtëꞌ gládxinëꞌ Dios. Qui lë ni naꞌ glunëꞌ zxön lëꞌ Xanruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Lëzcaꞌ guladxinëꞌ zian bönniꞌ taꞌyejlëꞌë Cristo len gulaxóalëpëꞌ dul‑laꞌ nabágaꞌquëꞌ len gulaguíxjöꞌë le chglunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Lëzcaꞌ cni glunëꞌ zian bönniꞌ, ziꞌal glunëꞌ yöl‑laꞌ udzáꞌ. Djuaꞌquëꞌ yuguꞌ guich udzáꞌ quequëꞌ, atiꞌ guluzéguiꞌë leygac laugac yúguꞌtë bunách. Gululabëꞌ tsca zácaꞌgac guich naꞌ, guc gdu chi un mil dumí plata. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Cni guc, gzëtsca didzaꞌ len bdél‑liꞌtsca bunách xtidzëꞌë Xanruꞌ. Gdu ládxiꞌquëꞌ gulayejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Gdöd glac lë ni, benëꞌ queëꞌ Pablo tsijëꞌ Jerusalén, san ziꞌal ral‑laꞌ tödëꞌ yuguꞌ yödz luyú Macedonia len Acaya, atiꞌ gnëꞌ: ―Töd tsijaꞌ Jerusalén, run bayúdx tsijaꞌ caꞌ Roma. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Niꞌr bsölëꞌë‑biꞌ luyú Macedonia chopbiꞌ biꞌi bönniꞌ táclenbiꞌ lëꞌ, lëcbiꞌ Timoteo len Erasto, san bugaꞌnëꞌ lëꞌ nabáb dza luyú Asia naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dza niꞌ glun rusbö́ bunách Éfeso, atiꞌ guladáꞌbaguëꞌë xtidzëꞌë Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Benëꞌ ga glunëꞌ rusbö́ naꞌ Demetrio, bönniꞌ bëdx guia plata. Runczëꞌ yuguꞌ lidx bdauꞌ guiöj bdauꞌ yag náquicni plata qui dios quequëꞌ, lënu Diana. Szxöni gulaziꞌë dumí bönniꞌ tunëꞌ dxin ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Butubëꞌ yezícaꞌrëꞌ bönniꞌ tunëꞌ laꞌ dxin niz Demetrio, atiꞌ gudxëꞌ lequëꞌ: ―Böchaꞌa, nö́ziczliꞌ ca nac dxin runruꞌ, runn dumí queëruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Rléꞌiliꞌ len ryö́niliꞌ ca runëꞌ Pablo naꞌ. Clëgz Éfeso ni, san gdu luyú Asia chbdél‑liꞌnëꞌ bunách zian, atiꞌ chbutsë́ꞌë ca tunëꞌ, rëꞌ lequëꞌ: “Cutu nacgac dios le nungac bunách.” ");
INSERT INTO zsrNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Clëgz zoa banádx ugáꞌn caꞌz dxin ni runruꞌ, san lëzcaꞌ zoa banádx ugáꞌn caꞌz gdauꞌ qui dios zxön lënu Diana. Cni gac, ugáꞌn caꞌz yöl‑laꞌ zxön queënu, dios ni taꞌyíj ládxiꞌgac‑nu bunách gdutë luyú Asia lencaꞌ gdutë yödzlyú. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Catiꞌ gulayönnëꞌ didzaꞌ ni bönniꞌ naꞌ, gulaleynëꞌ, atiꞌ gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Náctërnu zxön Diana, dios queëruꞌ rëꞌu, bunách Éfeso. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Cni guc, glun rusbö́ bunácx gdutë lu yödz naꞌ, atiꞌ tuz glaquëꞌ, len jaréluꞌquëꞌ yjaquëꞌ löꞌa yúlahuiꞌ. Glaꞌyjëꞌ niꞌ Gayo len Aristarco, bönniꞌ nababquëꞌ Macedonia len dzagquëꞌ Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Catiꞌ guꞌnnëꞌ Pablo tsaziëꞌ ga nacuáꞌ bunách zian naꞌ, cutu caꞌ gluꞌë lëꞌ latj bönniꞌ taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Lëzcaꞌ cni glunëꞌ laꞌquëꞌ bönniꞌ yúlahuiꞌ qui luyú Asia, bönniꞌ taꞌléꞌinëꞌ Pablo dxiꞌa. Gulasölëꞌë queëꞌ nup glátaꞌyu lahuëꞌ cu tsijëꞌ löꞌa yúlahuiꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ga niꞌ tunëꞌ rusbö́ len taꞌbödxyëꞌë, tu le taꞌnë́ꞌ laꞌquëꞌ, len yetú le taꞌnë́ꞌ yelaꞌquëꞌ, le chrö́ꞌgaczëꞌ bröli bönniꞌ zian naꞌ tunëꞌ rusbö́, len yelatiꞌz cuguluhuöatëꞌ cutu nözcnëꞌ bizx quië naꞌ nudubquëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Niꞌr gulabijëꞌ Alejandro ladj bunách zian naꞌ bönniꞌ judío, atiꞌ guludxiguëꞌë lëꞌ lauquëꞌ. Buluꞌë len nëꞌë Alejandro naꞌ, quië laꞌböꞌë dxiz, le guꞌnnëꞌ guꞌë didzaꞌ gaclen yuguꞌ bönniꞌ judío naꞌ laugac yúguꞌtë bunách naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Catiꞌ gláquibeꞌinëꞌ naquëꞌ judío, gluꞌë tsazxö́n zidzj didzaꞌ yúguꞌtëꞌ gdu ca chop hora, taꞌnë́ꞌ: ―Náctërnu zxön Diana, dios queëruꞌ rëꞌu bunách Éfeso. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Niꞌr benëꞌ bönniꞌ uzúj qui yúlahuiꞌ ga laꞌbö́ꞌ dxiz bunách zian naꞌ, gnëꞌ: ―Bönniꞌ Éfeso, nö́zigac yúguꞌtë bunách zoa ni gdauꞌ queënu Diana, dios zxön. Rëꞌu ni, bunách Éfeso, run chiꞌiruꞌ gdauꞌ naꞌ lencaꞌ bdauꞌ naꞌ böxj ga zoaruꞌ, bruj luzxbá. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nutu nu gac táꞌbagaꞌ lë ni. Qui lë ni naꞌ run bayúdx soaliꞌ dxiz, len cutu bi gúntëzliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nachë́ꞌgacliꞌ‑nëꞌ ni bönniꞌ ni, len cutu taꞌbanëꞌ le dzöꞌ gdauꞌ, len cutu taꞌnë́ xöhuëꞌë queënu dios queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Qui lë ni naꞌ, chquiꞌ zoa didzaꞌ bizxj quequëꞌ Demetrio len bönniꞌ bëdx guia plata nacuáꞌlenëꞌ lëꞌ, len nútiꞌtëz bönniꞌ, dë latj ga nu uzë́ nag lequëꞌ, atiꞌ zoa nu cuequi xbey lequëꞌ. Niꞌ huac luquí lzaꞌquëꞌ tuëꞌ yetúëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Naꞌa, chquiꞌ dë yetú le gnabliꞌ, huac ucaꞌnruꞌ tsahuiꞌ lei catiꞌ ludúb bönniꞌ yúlahuiꞌ ca naꞌ rna bëꞌ yúlahuiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Zoa banádx nu uquí rëꞌu niꞌa qui rusbö́ ni guc naꞌa, gna rdáꞌbagaꞌruꞌ yúlahuiꞌ. Cutu bi gac quíxjöꞌruꞌ bizx quië guc rusbö́ ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Catiꞌ budx bëꞌë didzaꞌ ni, busölëꞌë lidxgac bunách zian naꞌ nudubgac niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Catiꞌ gröꞌ dxi rusbö́ naꞌ guc lu yödz Éfeso, bulidzëꞌ Pablo yuguꞌ bönniꞌ taꞌyejlëꞌë Cristo, atiꞌ bchiziëꞌ icj nagquëꞌ didzaꞌ. Gdöd niꞌ bunidëꞌ lequëꞌ len laꞌ buláꞌalentëꞌ lequëꞌ. Brujëꞌ niꞌ atiꞌ gyijëꞌ luyú Macedonia. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Gdödëꞌ yuguꞌ yödz luyú niꞌ, ruzéjniꞌtsquinëꞌ bö́chiꞌruꞌ nacuꞌë niꞌ, atiꞌ gdöd niꞌ bdxinëꞌ luyú Grecia. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Niꞌ gzoëꞌ Pablo gdu ca tsonn beoꞌ. Catiꞌ chzoa cuenëꞌ tu lëꞌi barco tsijëꞌ luyú Siria, gúquibeꞌinëꞌ taꞌbö́ꞌ nisiëꞌ lëꞌ bönniꞌ judío quië laꞌzönëꞌ lëꞌ. Qui lë ni naꞌ bguel‑lëꞌë nöz zhuöjëꞌ luyú Macedonia, atiꞌ bdxinëꞌ yödz Filipos. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Zjáclenëꞌ lëꞌ tsazxö́n Sópater, zxiꞌnëꞌ Pirro, bönniꞌ Berea, len Aristarco len Segundo, yuguꞌ bönniꞌ Tesalónica, len Gayo, bönniꞌ Derbe, lencaꞌ biꞌi Timoteo len Tíquico len Trófimo, yuguꞌ bönniꞌ Asia. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Niꞌr yajnörquëꞌ lahuëꞌ Pablo bönniꞌ ni, yjaquëꞌ yödz Troas, ga niꞌ gulabözëꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Lu yödz Filipos naꞌ, nedaꞌ, Lucas, yajtsagaꞌ‑nëꞌ Pablo. Catiꞌ chgdöd lni catiꞌ tahuëꞌ bönniꞌ judío yöt xtil cunazíꞌ xnëꞌi, gyaztuꞌ tu lëꞌi barco len buzaꞌtuꞌ Filipos naꞌ. Gdöd gayuꞌ dza budzagtuꞌ bönniꞌ niꞌ yajnörquëꞌ lahuëꞌ Pablo, yjaquëꞌ Troas, atiꞌ niꞌ bugaꞌntuꞌ gadx dza. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dza domingo guludubëꞌ bönniꞌ taꞌyejlëꞌë Cristo quië lahuëꞌ yöt xtil le rusáꞌ ládxiꞌruꞌ ca gutiëꞌ Jesucristo. Niꞌ busëdnëꞌ lequëꞌ Pablo, len le ral‑laꞌ uzë́ꞌë niꞌ catiꞌ zaꞌ reníꞌ dza naꞌ, xtsey bëꞌë didzaꞌ, ga bdxintë gdöd ladxiꞌ yël. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ga niꞌ nudubquëꞌ nac lu yuꞌu xtsaꞌ, atiꞌ nacuáꞌ niꞌ zian le taꞌgúꞌu yeníꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Zoabiꞌ niꞌ biꞌi Eutico, röꞌbiꞌ ga raꞌa leniꞌ qui yuꞌu naꞌ, atiꞌ nadö́dr yël queëbiꞌ le rtunn lban runëꞌ Pablo. Ga niꞌ röꞌbiꞌ rasbiꞌ biꞌi naꞌ nac ga bunn cuia yuꞌu, atiꞌ raszbiꞌ caꞌ gbíxtëbiꞌ, böxjbiꞌ ga bdxíntëbiꞌ zxan yuꞌu. Náttëbiꞌ gululisëꞌ‑biꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bötjëꞌ Pablo zxan yuꞌu naꞌ, atiꞌ yajxóëꞌ lëbiꞌ, len bunidëꞌ‑biꞌ. Niꞌr gudxëꞌ nup nacuáꞌ niꞌ: ―Cutu gadxi gdzö́biliꞌ. Nabanbiꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Catiꞌ chbubenëꞌ xtsaꞌ Pablo, gdel‑lëꞌë yöt xtil, gdahuëꞌ. Niꞌr bë́ꞌlenëꞌ lequëꞌ didzaꞌ Pablo ga bdxintë zil bal. Gdöd niꞌ burujëꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Biꞌi bönniꞌ raꞌbán naꞌ gbixbiꞌ, nabanbiꞌ guluchë́ꞌë‑biꞌ len szxöni guluzíꞌ zxönëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Gnörtuꞌ yajchentuꞌ lëꞌi barco, atiꞌ gdödtuꞌ ga bdxintuꞌ yödz Asón quië tsajtsagtuꞌ‑nëꞌ niꞌ Pablo, gac ca naꞌ chben xtídzaꞌtuꞌ, le guꞌnnëꞌ Pablo tsijëꞌ niꞌ sëꞌiz niꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Catiꞌ chbudzagtuꞌ‑nëꞌ lu yödz Asón naꞌ, grénlenëꞌ netuꞌ lëꞌi barco, atiꞌ gyeajtuꞌ Mitilene. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Buzáꞌ niꞌ barco, atiꞌ dza buróp bdxintuꞌ töd li ga zoa luyú bidx nazíꞌ lei Quío, atiꞌ yetú dza caꞌ gdödtuꞌ töd li ga dë Samos len bdxintuꞌ yödz Trogilio ga niꞌ gzoatuꞌ tu chiꞌi. Yetú dza caꞌ bdxintuꞌ yödz Mileto. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Cni bentuꞌ le chbenëꞌ queëꞌ Pablo tödzëꞌ Éfeso, cui tseynëꞌ luyú Asia, le run bayúdx soëꞌ Jerusalén catiꞌ nac dza Pentecostés chquiꞌ sáquiꞌnëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Catiꞌ niꞌ zoëꞌ Pablo lu yödz Mileto, bsölëꞌë nu yajlídz bönniꞌ gul tun chiꞌë bunách queëꞌ Cristo nacuꞌë Éfeso. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Catiꞌ guladxinëꞌ ga zoëꞌ Pablo, lëꞌ gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ chnö́ziczliꞌ ca bénteczaꞌ ga zoaliꞌ ga gdel‑laꞌ bdxinaꞌ luyú Asia. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yuguꞌ dza benaꞌ xchinëꞌ Xanruꞌ lu yöl‑laꞌ nöxj ladxiꞌ, ga bdxintë grödxaꞌ niꞌa queëliꞌ, atiꞌ zian le guc quiaꞌ le gzxiꞌ bëꞌ nedaꞌ niꞌa qui le cunác glunëꞌ quiaꞌ bunách judío cutaꞌyejlëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bénteczaꞌ lban ga zoaliꞌ qui yúguꞌtë le ruziꞌliꞌ xbey, len busëddaꞌ lbiꞌiliꞌ yalj lulu ga nudubliꞌ len gap nac lu yuꞌu lidxliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Benaꞌ lnaꞌ lau laugac bunách judío len laugac bunách gzaꞌa quië lubíꞌi ládxiꞌgac, luhuöác queëꞌ Dios, len laꞌyejlëꞌ Xanruꞌ Jesucristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Naꞌa, chnunëꞌ quiaꞌ Dios Böꞌ Laꞌy tsijaꞌ Jerusalén, len cutu nözdaꞌ bizxa gac quiaꞌ niꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Yúguꞌtë yödz ga rdaꞌ, rguíxjöiꞌnëꞌ nedaꞌ Dios Böꞌ Laꞌy, rëꞌ nedaꞌ laꞌguꞌë nedaꞌ lidx guia len lusacaꞌ ziꞌë nedaꞌ bönniꞌ judío cutaꞌyejlëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Cutu bi runi nedaꞌ qui lë naꞌ gac, zal‑laꞌ gatiaꞌ o cugatiaꞌ, san ruiꞌ ládxiꞌzgaꞌ udx gunaꞌ le chbdel‑laꞌa runaꞌ, quië gunaꞌ dxin naꞌ budödëꞌ lu naꞌa Xanruꞌ Jesús, le nac gunaꞌ lban qui didzaꞌ dxiꞌa ca nac le ruzáꞌ ladxëꞌë queëruꞌ Dios. Cni gunaꞌ len yöl‑laꞌ rudziji. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Naꞌa, yúguꞌtëliꞌ naꞌ chbenaꞌ lban lauliꞌ ca rna bëꞌë Dios, nözdaꞌ cutur gléꞌiliꞌ nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Qui lë ni naꞌ, le nacz rëpaꞌ lbiꞌiliꞌ naꞌa dza. Cutu nabagaꞌa nedaꞌ queëliꞌ nituliꞌ lbiꞌiliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Cutu bi bucáchiꞌdaꞌ lbiꞌiliꞌ, san gdíxjöiꞌdaꞌ lbiꞌiliꞌ yúguꞌtë le rnëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Qui lë ni naꞌ, gul‑gún chiꞌi cuinliꞌ, len gul‑gún chiꞌi yúguꞌtë bunách queëꞌ Cristo, le nuzóëꞌ libiꞌliꞌ Dios Böꞌ Laꞌy quië uyuliꞌ lequëꞌ, len gun chiꞌiliꞌ bunách queëꞌ Xanruꞌ, Nu naꞌ, uláz quequëꞌ gutiëꞌ, bulaljëꞌ xchönëꞌ le böáꞌuinëꞌ lequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Chnözdaꞌ, töd uzáꞌa ga zoaliꞌ, laꞌyáz ga zoaliꞌ nup lëꞌni lusnít bunách queëꞌ Cristo, lunëꞌ ca tunbaꞌ böꞌcuꞌ zugaꞌ sniaꞌ, tuꞌsnitbaꞌ yuguꞌ böꞌcuꞌ zxilaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Laꞌrujëꞌ bönniꞌ nútsaꞌquëꞌ ladjliꞌ, atiꞌ luꞌë didzaꞌ cunácz quië lubijëꞌ quégaczëꞌ nup taꞌyejlëꞌ Cristo nútsaꞌgac ladjliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Qui lë ni naꞌ, gul‑zóa ban ladxiꞌ len gul‑tsajnéy ca benaꞌ nedaꞌ gdu ca tsonn iz, rël len të dza buchiziaꞌ icj nagliꞌ tu tuliꞌ ga bdxintë grödxaꞌ queëliꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Naꞌa, böchiꞌ lzaꞌadauꞌ, rguꞌa lbiꞌiliꞌ lu nëꞌë Dios. Rnabaꞌ lahuëꞌ uzáꞌ ladxëꞌë queëliꞌ, gunëꞌ ca rna xtidzëꞌë. Dios gunëꞌ lbiꞌiliꞌ tsutsu len gunëꞌ ga gdél‑liꞌliꞌ gunliꞌ tsazxö́n nup nubijëꞌ quizi queëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Gatga gzë ladxaꞌa le naqui quequëꞌ böchiꞌ lzaꞌa. Cutu gzë ladxaꞌa dumí, o lariꞌ quequëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nö́ziczliꞌ dxiꞌa, naꞌ cuinczaꞌ benaꞌ dxin quië gac gaꞌuaꞌ le byadzj quiaꞌ len quegac nup gulacuaꞌlen nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ca nac yúguꞌtë le benaꞌ, buluiꞌidaꞌ lbiꞌiliꞌ cni ral‑laꞌ gunruꞌ dxin quië gac gáclenruꞌ nup bi taꞌyadzji. Ral‑laꞌ tsajneyruꞌ didzaꞌ bëꞌë Xanruꞌ Jesús, gnëꞌ: “Uzíꞌr xbey nu bi runö́dzj ca nu bi rziꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Catiꞌ budx bëꞌë didzaꞌ ni Pablo, buzechu zxibëꞌ, atiꞌ benëꞌ tsazxö́n yúguꞌtëꞌ, gululidzëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Niꞌr gulabödxëꞌ yúguꞌtëꞌ, atiꞌ gulunidëꞌ yenëꞌ Pablo, len glahuëꞌ lëꞌ bzxidu. ");
INSERT INTO zsrNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Cni glunëꞌ le guluhuiꞌnnëꞌ niꞌa qui didzaꞌ naꞌ bëꞌë Pablo, gnëꞌ: “Cutur gléꞌiliꞌ nedaꞌ.” Tsazxö́n yjáclenëꞌ lëꞌ, guladxinëꞌ ga grenëꞌ lëꞌ lëꞌi barco. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Gdöd buláꞌalentuꞌ lequëꞌ, gyuꞌutë nöz barco naꞌ, atiꞌ tinz gyeajtuꞌ ga zoa luyú bidx nazíꞌ lei Cos. Dza buróp naꞌ, gdödtuꞌ yetú latj nazíꞌ lei Rodas, atiꞌ buzaꞌtuꞌ niꞌ len bdxintuꞌ yödz Pátara. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Niꞌ yajxácaꞌtuꞌ barco yubl zeaj luyú Fenicia. Grentuꞌ lëꞌi barco naꞌ, atiꞌ gyuꞌutë nöz. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Gdödtuꞌ ga naláꞌ Chipre, dë tslaꞌa yögl, atiꞌ gyeajtuꞌ luyú Siria. Niꞌ gyaz barco naꞌ lu yödz Tiro, le ral‑laꞌ tsajcáꞌn niꞌ yuaꞌ dzöꞌ lëꞌi barco naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Lu yödz Tiro naꞌ yajxácaꞌtuꞌ bönniꞌ niꞌ taꞌyejlëꞌë Cristo, atiꞌ niꞌ bugáꞌnlentuꞌ lequëꞌ gdu gadx dza. Le chbuluiꞌinëꞌ lequëꞌ Dios Böꞌ Laꞌy le ral‑laꞌ gac queëꞌ Pablo, glëꞌ lëꞌ cutu tsijëꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Catiꞌ chbzaꞌa dza naꞌ, burujtuꞌ niꞌ, atiꞌ tsazxö́n gulazáꞌlenëꞌ netuꞌ yúguꞌtëꞌ len yuguꞌ ngul quequëꞌ len yuguꞌ biꞌi quequëꞌ, ga bdxíntëtuꞌ niꞌl raꞌ yödz naꞌ. Raꞌ nis zxön niꞌ buzechu zxibtuꞌ len bulidztuꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Budx bunidaꞌ lzaꞌtuꞌ tutuꞌ yetutuꞌ, bubentuꞌ lëꞌi barco, atiꞌ lequëꞌ yhuöjquëꞌ lidxquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Buzaꞌtë barco naꞌ lu yödz Tiro, atiꞌ ga yajséy bdxin lu yödz Tolemaida. Niꞌ burujtuꞌ lëꞌi barco naꞌ. Bugaptuꞌ Dios bö́chiꞌruꞌ nacuꞌë niꞌ, atiꞌ bugáꞌnlentuꞌ lequëꞌ tu dza. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Catiꞌ zaꞌ reníꞌ yetú dza, burujëꞌ niꞌ Pablo, atiꞌ dzagtuꞌ‑nëꞌ netuꞌ gyeajtuꞌ yödz Cesarea. Niꞌ gyaztuꞌ lu yuꞌu lidxëꞌ Felipe, atiꞌ bugáꞌnlentuꞌ lëꞌ. Runëꞌ lban qui didzaꞌ dxiꞌa Felipe naꞌ, len bitsëꞌë gadxëꞌ bönniꞌ niꞌ gulucuꞌë dza niꞌtë quië láclenëꞌ bunách queëꞌ Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nacuaꞌbiꞌ tap biꞌi ngul raꞌbán queëꞌ Felipe naꞌ, tuiꞌbiꞌ didzaꞌ uláz queëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Gdöd gdzeytuꞌ niꞌ chop tsonn dza, niꞌr bdxinëꞌ Agabo, bönniꞌ ruꞌë didzaꞌ uláz queëꞌ Dios, narujëꞌ luyú Judea. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bönniꞌ ni duyúëꞌ netuꞌ, atiꞌ gdel‑lëꞌë pan guid queëꞌ Pablo. Béguëꞌë niꞌa naꞌ cuinëꞌ, gnëꞌ: ―Cni rnëꞌ Dios Böꞌ Laꞌy: “Cni lunëꞌ bönniꞌ judío nacuꞌë Jerusalén. Lúguëꞌë bönniꞌ ni naqui queëꞌ pan guid ni, atiꞌ ludödëꞌ lëꞌ lu naꞌgac bunách gzaꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Catiꞌ byö́nituꞌ didzaꞌ ni, gútaꞌyutuꞌ lahuëꞌ Pablo, netuꞌ len nup nacuáꞌ niꞌ, cui tsijëꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bubiꞌë didzaꞌ Pablo, gnëꞌ: ―¿Bizxa ni runliꞌ, rbödxliꞌ len rushuíꞌniliꞌ nedaꞌ? Nedaꞌ chzoaczaꞌ sinaꞌ, clëgz lúguëꞌë nedaꞌ, san gatiaꞌ caꞌ Jerusalén niꞌa queëꞌ Xanruꞌ Jesús. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Le cutu gzxáquiꞌtuꞌ‑nëꞌ didzaꞌ, cutur bi gudxtuꞌ‑nëꞌ, atiꞌ gnatuꞌ: ―Gac ca dzag ladxëꞌë Xanruꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Catiꞌ chguladö́d dza naꞌ, bupaꞌtuꞌ queëtuꞌ, atiꞌ gyeajtuꞌ Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Gulazáꞌlenëꞌ netuꞌ laꞌquëꞌ bönniꞌ taꞌyejlëꞌë Cristo, nacuꞌë Cesarea, atiꞌ dzaguëꞌ lequëꞌ Mnasón, bönniꞌ Chipre. Rejlëꞌë Cristo dza niꞌtë, atiꞌ ral‑laꞌ tsajgaꞌntuꞌ lidxëꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Catiꞌ bdxintuꞌ Jerusalén, len yöl‑laꞌ rudziji quequëꞌ glunëꞌ netuꞌ ba laꞌn bö́chiꞌruꞌ niꞌ taꞌyejlëꞌë Cristo. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Dza buróp naꞌ gyázlenëꞌ netuꞌ Pablo lu yuꞌu, yajyutuꞌ‑nëꞌ Jacobo, atiꞌ nudubquëꞌ niꞌ yúguꞌtë bönniꞌ gul tun chiꞌë bunách queëꞌ Cristo nacuꞌë Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Catiꞌ chbugapëꞌ Dios lequëꞌ Pablo, buluiꞌinëꞌ lequëꞌ yúguꞌtë le benëꞌ Dios lu nëꞌë lëꞌ ga nacuáꞌ bunách gzaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Catiꞌ gulayönnëꞌ lë ni, gulaguꞌë Dios yöl‑laꞌ ba. Niꞌr glëꞌ Pablo: ―Rléꞌicznuꞌ, bö́chiꞌtuꞌ, cátiꞌga zian gayuꞌë bönniꞌ judío taꞌyejlëꞌë Cristo, atiꞌ tuntsquëꞌ ba laꞌn zxba queëꞌ Moisés yúguꞌtëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Chgulayönnëꞌ yuguꞌ le tuiꞌ quiuꞌ didzaꞌ bunách, taꞌná rguꞌu yöl‑luꞌu yúguꞌtë bönniꞌ judío nútsaꞌquëꞌ ladj bunách gzaꞌa, quië lucaꞌnëꞌ le gna bëꞌë Moisés, len rna béꞌinuꞌ lequëꞌ cu laꞌchuguëꞌ lu xpë́laꞌcbiꞌ biꞌi bö́nniꞌdauꞌ quequëꞌ, len cu lunëꞌ ba laꞌn yuguꞌ le nalë́biruꞌ runruꞌ rëꞌu, bunách judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Nacx gunruꞌ naꞌa? Hualaꞌrúj bunách zian catiꞌ laꞌyöni chbdxinuꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Naꞌa, ben lë ni rëtuꞌ liꞌ. Nacuáꞌlenëꞌ netuꞌ ni tapëꞌ bönniꞌ, chnazíꞌ lu naꞌquëꞌ lahuëꞌ Dios tu le lunëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bchëꞌë quiuꞌ yuguꞌ bönniꞌ ni, len ben tsazxö́n lequëꞌ gun dxiꞌa cuinliꞌ ca nac qui gdauꞌ, len gdizxj liꞌ le ral‑laꞌ laꞌguizxjëꞌ quië lun yutuz icjquëꞌ. Niꞌr laꞌnöznëꞌ yúguꞌtë bönniꞌ judío cutu nacz lë naꞌ taꞌnë́ꞌ quiuꞌ, san lëzcaꞌ liꞌ runuꞌ le nac dxiꞌa len runuꞌ ca rna bëꞌ zxba queëꞌ Moisés. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ca nac quegac bunách gzaꞌa, nup niꞌ chtaꞌyejlëꞌ Cristo, chben xtídzaꞌtuꞌ len buzujtuꞌ lu guich ca ral‑laꞌ lunëꞌ. Cutu run bayúdx lun chiꞌë yuguꞌ lë ni tunëꞌ bönniꞌ judío, san tuz: Cu lahuëꞌ le taꞌgúꞌu bunách laugac bdauꞌ guiöj bdauꞌ yag, Len cu lahuëꞌ rön, Len cu lahuëꞌ xpë́laꞌcbaꞌ böaꞌ guixiꞌ cunarujcbaꞌ rön, Len cu lunëꞌ le cunác. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Niꞌr bchëꞌë queëꞌ Pablo tapëꞌ bönniꞌ naꞌ, atiꞌ dza buróp niꞌ ben dxiꞌa cuinëꞌ tsazxö́n len lequëꞌ ca nac qui gdauꞌ. Niꞌr gyaziëꞌ löꞌa gdauꞌ, quië gac bëꞌ bizxa dza udx lunëꞌ le tuꞌún dxiꞌa cuinquëꞌ, dza niꞌ ral‑laꞌ tsjuaꞌquëꞌ le laꞌguꞌë lahuëꞌ Dios qui queëquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Catiꞌ chzoa gzaꞌa gadx dza naꞌ, gulaléꞌinëꞌ Pablo laꞌquëꞌ judío narujquëꞌ luyú Asia, zoëꞌ löꞌa gdauꞌ. Glunëꞌ ga glun rusbö́ bunách zian, atiꞌ gulazönëꞌ Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Gul‑gaclen netuꞌ, bönniꞌ Israel. Bönniꞌ ni yúguꞌtë latj rusëdnëꞌ yúguꞌtë bunách lucáꞌn caꞌz yödz queëruꞌ len zxba queëꞌ Moisés, len gdauꞌ queëruꞌ ni. Naꞌa, chgluꞌë gdauꞌ ni yuguꞌ bönniꞌ gzaꞌa. Cni runëꞌ, run ditjnëꞌ latj laꞌy ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Cni gulanë́ꞌ le gulaléꞌinëꞌ Pablo ziꞌal lu yödz dzaguëꞌ Trófimo, bönniꞌ Éfeso, len táquinëꞌ gluꞌë gdauꞌ bönniꞌ ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Cni guc, guludúb yúguꞌtë bunách yödz, len gulaguirëꞌ niꞌ. Niꞌr gulazönëꞌ Pablo len glaꞌyjëꞌ lëꞌ, gulubijëꞌ lëꞌ löꞌa gdauꞌ, atiꞌ laꞌ guluseyjtëꞌ ga nu ryaz löꞌa gdauꞌ naꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Catiꞌ chtáquicznëꞌ ludöddëꞌ Pablo, bdxin didzaꞌ lahuëꞌ bönniꞌ blau nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l. Byönnëꞌ tun rusbö́ yúguꞌtë bunách Jerusalén. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Laꞌ butubtëꞌ bönniꞌ rjaquëꞌ gdil‑l len bönniꞌ taꞌná béꞌinëꞌ lequëꞌ bönniꞌ blau ni, atiꞌ jaréluꞌë gyéajlenëꞌ lequëꞌ ga naꞌ tun rusbö́ bunách naꞌ. Catiꞌ gulaleꞌi bunách niꞌ bönniꞌ blau naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, len bönniꞌ naꞌ rjaquëꞌ gdil‑l, gulusanëꞌ taꞌguinëꞌ Pablo. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Niꞌr gbiguëꞌë bönniꞌ blau naꞌ, len gzxönëꞌ Pablo, atiꞌ gna béꞌinëꞌ bönniꞌ rjaquëꞌ gdil‑l lúguëꞌë lëꞌ chop du guia. Gdöd niꞌ gnabnëꞌ bunách zian niꞌ, rnëꞌ: ―¿Nuzxa caz bönniꞌ ni, len bizxa benëꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Taꞌbödxyaꞌa bunách zian naꞌ, len qui queëgac ca taꞌná. Cni guc, cutu bi guc tséjniꞌnëꞌ bönniꞌ blau naꞌ, le tun rusbö́ bunách naꞌ, atiꞌ gna béꞌinëꞌ bönniꞌ rjaquëꞌ gdil‑l laꞌchë́ꞌë Pablo lu yuꞌu zxön ga tuꞌdubëꞌ bönniꞌ rjaquëꞌ gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Catiꞌ guladxinëꞌ ga nac niꞌyëpiꞌ qui yuꞌu zxön naꞌ, gluiꞌnëꞌ Pablo bönniꞌ naꞌ rjaquëꞌ gdil‑l, le dxíadiꞌigac lequëꞌ bunách zian, ");
INSERT INTO zsrNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","le zaꞌc cúdzuꞌquëꞌ bunách naꞌ, taꞌbödxyaꞌa, taꞌná: ―Gul‑döddëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Catiꞌ niꞌ gulazú lauquëꞌ laꞌguꞌë Pablo lu yuꞌu zxön niꞌ, lëꞌ gudxëꞌ bönniꞌ blau naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, gnëꞌ: ―¿Naruꞌ gunnuꞌ latj gyëpaꞌ liꞌ tu didzaꞌ? Bönniꞌ blau naꞌ gudxëꞌ Pablo: ―¿Ractsuꞌ didzaꞌ griego? ");
INSERT INTO zsrNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Naruꞌ clëg liꞌ bönniꞌ Egipto naꞌ dza lahui niz butubëꞌ bönniꞌ guladáꞌbaguëꞌë yúlahuiꞌ, atiꞌ bchëꞌë lu latj caꞌz gdu choaꞌ gayuꞌë bönniꞌ gdödi bunách? ");
INSERT INTO zsrNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Niꞌr gudxëꞌ lëꞌ Pablo, gnëꞌ: ―Le nactë nacaꞌ nedaꞌ judío. Guljaꞌ Tarso, yödz blau luyú Cilicia. Rátaꞌyuaꞌ lauꞌ gunnuꞌ nedaꞌ latj guꞌa didzaꞌ laugac bunách ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Bëꞌë lëꞌ latj bönniꞌ blau naꞌ, atiꞌ gzuinëꞌ Pablo ga nac niꞌyëpiꞌ, len bchis nëꞌë quië laꞌcuáꞌ dxiz bunách zian niꞌ. Catiꞌ chgulacuꞌë dxiz, bë́ꞌlenëꞌ lequëꞌ didzaꞌ Pablo lu didzaꞌ hebreo. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Cni gnëꞌ Pablo: ―Lbiꞌiliꞌ, bönniꞌ gul, len lbiꞌiliꞌ böchaꞌa. Gul‑zë́ nagliꞌ le gyëpaꞌ lbiꞌiliꞌ ca nac le runaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Catiꞌ gulayönnëꞌ ruꞌë didzaꞌ hebreo, gulacuaꞌrëꞌ dxiz. Gudxëꞌ lequëꞌ Pablo, rnëꞌ: ");
INSERT INTO zsrNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Nacczaꞌ nedaꞌ judío. Guljaꞌ lu yödz Tarso luyú Cilicia, san gzxönaꞌ lu yödz ni, atiꞌ busëdnëꞌ nedaꞌ Gamaliel gdu ca nac zxba quequëꞌ xuz xtauꞌruꞌ. Bëꞌtecz ladxaꞌa gyij ladxaꞌa Dios ca runliꞌ lbiꞌiliꞌ naꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ziꞌal gdxia ládxiꞌgacaꞌ‑nëꞌ bönniꞌ nazíꞌ lu naꞌquëꞌ xtidzëꞌë Cristo, len bchë́ꞌgacaꞌ‑nëꞌ ga latiëꞌ. Gzxö́ngacaꞌ‑nëꞌ, len glúꞌgacaꞌ‑nëꞌ lidx guia, yuguꞌ bönniꞌ len ngul. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Lëzcaꞌ huac lunëꞌ lnaꞌ lau qui le glunëꞌ yuguꞌ bxuz uná bëꞌ len bönniꞌ gul tuꞌzejniꞌi. Glunëꞌ guich uná bëꞌ le yjuꞌa ga nacuꞌë bö́chiꞌruꞌ judío lu yödz Damasco. Gyijaꞌ niꞌ tsajxö́ngacaꞌ nup niꞌ taꞌyejlëꞌ Cristo, quië duchë́ꞌgacaꞌ‑nëꞌ nágaꞌquëꞌ Jerusalén ni, quië lacquëꞌ zxguiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Niꞌr gnëꞌ Pablo: ―Catiꞌ niꞌ zijaꞌ laꞌ nöz, len ziꞌa gdxinaꞌ Damasco, guc gdu huagbídz, tu tsalz gyëp yös yeníꞌ zaꞌ luzxbá, le buzeníꞌ ga naꞌ zijaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Laꞌ yjö́taꞌteaꞌ lyu, len byöndaꞌ chiꞌi Nu gudx nedaꞌ: “Saulo, Saulo, ¿bizx quië rbia ladxuꞌu nedaꞌ?” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Niꞌr gnabdaꞌ lëꞌ, gniaꞌ: “¿Nuzxa liꞌ, Xan?” Lëꞌ gudxëꞌ nedaꞌ: “Nedaꞌ ni Jesús, bönniꞌ Nazaret. Nédaꞌczaꞌ rbia ladxuꞌu.” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Gulaleꞌicz yeníꞌ naꞌ nup niꞌ gulacuaꞌlen nedaꞌ, len gladxi, san cutu gulayöni chiꞌi Nu naꞌ bulídz nedaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Niꞌr gudxaꞌ‑nëꞌ: “¿Nacx gunaꞌ, Xan?” Xanruꞌ gudxëꞌ nedaꞌ: “Gyas, len gyeaj Damasco. Niꞌ zoa nu guië liꞌ ca nac yúguꞌtë le ral‑laꞌ gunuꞌ.” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Le cutur bi rléꞌidaꞌ le budíꞌi lahuaꞌ yös yeníꞌ naꞌ gyëptsca, qui lë ni naꞌ gulaguel‑lëꞌë naꞌa bönniꞌ dzagquëꞌ nedaꞌ, atiꞌ gulachë́ꞌë nedaꞌ ga bdxinteaꞌ Damasco. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Niꞌ zoëꞌ Ananías, bönniꞌ runëꞌ gdu ca rna bëꞌ zxba queëꞌ Dios, atiꞌ tunëꞌ lëꞌ ba laꞌn bönniꞌ judío nacuꞌë Damasco. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bdxinëꞌ ga zoaꞌ Ananías naꞌ, len gudxëꞌ nedaꞌ: “Saulo, böchaꞌa, huöalj yöj lauꞌ.” Laꞌ niꞌz böalj yöj lahuaꞌ, atiꞌ bléꞌidaꞌ lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Lëꞌ gudxëꞌ nedaꞌ: “Dios quequëꞌ xuz xtauꞌruꞌ, dza niꞌtë gröczëꞌ liꞌ quië gnöznuꞌ le rëꞌncznëꞌ Lëꞌ, len gléꞌinuꞌ‑nëꞌ Bönniꞌ tsahuiꞌ, Lëczëꞌ Zxiꞌnëꞌ, len yönnuꞌ le guiëꞌ liꞌ Lëczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Cni gac, le ral‑laꞌ gunuꞌ lnaꞌ lau queëꞌ Lëꞌ laugac yúguꞌtë bunách, quíxjöiꞌnuꞌ lequëꞌ ca nac le chbléꞌinuꞌ len le chbyönnuꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Naꞌa, ¿bizx quië rdzeynuꞌ? Gyas, len bdil nis. Blidzëꞌ Xanruꞌ unëꞌ liꞌ dxiꞌa, ugǘëꞌ dul‑laꞌ nabaguꞌu.” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Gnëꞌ caꞌ Pablo: ―Gdöd niꞌ, catiꞌ budxinaꞌ Jerusalén, len tsal niꞌ rulidzaꞌ‑nëꞌ Dios nchil gdauꞌ, bléꞌidaꞌ tu le nac ca tu lu yël bëchcál. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Bléꞌidaꞌ‑nëꞌ Xanruꞌ, atiꞌ gudxëꞌ nedaꞌ: “Jareluꞌ gyeaj. Burujtë Jerusalén ni, le cutu lunëꞌ ba laꞌn le gunuꞌ lnaꞌ lau quiaꞌ bönniꞌ ni.” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nedaꞌ gudxaꞌ‑nëꞌ: “Xan, nö́zgaccznëꞌ ca benaꞌ nedaꞌ. Gyaziaꞌ gap nac lu yuꞌu ga tuꞌdubëꞌ tuꞌsëdëꞌ queëꞌ Dios bönniꞌ judío. Gdinaꞌ nup niꞌ taꞌyejlëꞌ Liꞌ, len glúꞌgacaꞌ‑nëꞌ lidx guia. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Catiꞌ niꞌ guludöddëꞌ Esteban, bönniꞌ niꞌ benëꞌ lnaꞌ lau quiuꞌ, lëzcaꞌ zoaꞌ niꞌ nedaꞌ, benaꞌ tuz bönniꞌ guludöddëꞌ lëꞌ le ben chiꞌa lariꞌ nácuquëꞌ bönniꞌ naꞌ gululadxëꞌ lëꞌ guiöj.” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Niꞌr gudxëꞌ nedaꞌ Xanruꞌ: “Gyeaj, le rsölaꞌa liꞌ laugac bunách gzaꞌa.” ");
INSERT INTO zsrNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Niz ze lau guluzë́ nagquëꞌ didzaꞌ bëꞌë Pablo bönniꞌ judío, atiꞌ niꞌr gulabödxyëꞌë. Gluꞌë zidzj didzaꞌ, taꞌnë́ꞌ: ―Gul‑döddëꞌ bönniꞌ ni. Cutur ral‑laꞌ soëꞌ gbanëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Niꞌr le taꞌbödxyëꞌë, len taꞌchöztsquëꞌ le nácuquëꞌ lu yöl‑laꞌ rley quequëꞌ, len tuꞌchijëꞌ bëchtö yu lu böꞌz, ");
INSERT INTO zsrNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","gna bëꞌë bönniꞌ blau naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l luguꞌë Pablo yuꞌu zxön naꞌ. Lëzcaꞌ gna béꞌinëꞌ lequëꞌ laꞌguinëꞌ Pablo quië quíxjöꞌë le nacz, quië laꞌnöznëꞌ bizx quië naꞌ taꞌbödxyëꞌë cni queëꞌ Pablo bönniꞌ judío. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Catiꞌ glúguëꞌë lëꞌ pan guid quië laꞌguinëꞌ lëꞌ, Pablo gudxëꞌ tu bönniꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l zoëꞌ niꞌ, rnëꞌ: ―¿Naruꞌ dë latj quinliꞌ nedaꞌ? Nababaꞌ Roma, atiꞌ nutu nu glequi xbey nedaꞌ chquiꞌ nabagaꞌa zxguiaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Catiꞌ byönnëꞌ lë ni bönniꞌ naꞌ, gyijëꞌ yajtíxjöiꞌnëꞌ bönniꞌ blau naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l. Rëꞌ lëꞌ: ―¿Bizxa caz ni runruꞌ? Bönniꞌ ni nababëꞌ Roma. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Niꞌr bidëꞌ ga zoëꞌ Pablo bönniꞌ blau naꞌ, len gudxëꞌ lëꞌ: ―Gdixjöꞌ. ¿Naruꞌ nababuꞌ liꞌ Roma? Pablo gudxëꞌ lëꞌ: ―Ja, nababaꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Bubiꞌë didzaꞌ bönniꞌ blau naꞌ, gnëꞌ: ―Nedaꞌ ni, dumí zian gdizxjaꞌ quië gbabaꞌ Roma. Niꞌr Pablo gudxëꞌ lëꞌ: ―Nedaꞌ gbabaꞌ Roma catiꞌ niꞌ guljaꞌ le nababquëꞌ Roma xuz xnaꞌa. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Catiꞌ gulayönnëꞌ lë ni, laꞌ gulubígaꞌtëꞌ ga zoëꞌ Pablo bönniꞌ naꞌ chzoa laꞌguinëꞌ lëꞌ. Lëzcaꞌ, catiꞌ gnöznëꞌ nababëꞌ Roma Pablo, gúdxinëꞌ bönniꞌ blau naꞌ le chgna bëꞌë glúguëꞌë lëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Dza buróp niꞌ, guꞌnnëꞌ bönniꞌ blau naꞌ gnöznëꞌ gazxj ga rëꞌ bizxa naꞌ tuꞌquíëꞌ Pablo bönniꞌ judío. Gna bëꞌë gulusedxëꞌ du guia naꞌ náguëꞌë Pablo, atiꞌ gna bëꞌë ludubëꞌ bxuz uná bëꞌ judío, len yúguꞌtë bönniꞌ gdauꞌ taꞌbequi xbey. Niꞌr bubijëꞌ Pablo ga naꞌ naguꞌuquëꞌ lëꞌ atiꞌ buzóëꞌ lëꞌ lauquëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Niꞌr buyutsquëꞌ lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ Pablo, gnëꞌ: ―Lbiꞌiliꞌ, böchaꞌa. Ga rdxintë naꞌa rbözaꞌ dxíꞌadauꞌ. Cni nac, cutu zoa le ruxö́s nedaꞌ ládxiꞌdauꞌhuaꞌ lahuëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Niꞌr gna béꞌinëꞌ nup nacuáꞌ cuit lëꞌë Pablo Ananías, bxuz blau, laꞌgapëꞌë ruꞌë. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pablo gudxëꞌ lëꞌ: ―Lëzcaꞌ cni ubiꞌë quiuꞌ Dios, liꞌ, ruluíꞌz tsahuiꞌ cuinuꞌ. ¿Naruꞌ röꞌczuꞌ rbequi xbeynuꞌ nedaꞌ ca rna bëꞌ zxba, san rdöd bëꞌi runuꞌ ca rna bëꞌ zxba naꞌ, rna béꞌinuꞌ laꞌgapëꞌë nedaꞌ? ");
INSERT INTO zsrNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nup nacuáꞌ niꞌ të Pablo: ―¿Naruꞌ rulídz ziꞌtsuꞌ‑nëꞌ bxuz blau queëꞌ Dios? ");
INSERT INTO zsrNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo gudxëꞌ lequëꞌ: ―Lbiꞌiliꞌ, böchaꞌa. Nayúj lu guich, rna: “Cutu ulídz ziꞌu nu rna beꞌi bunách uládz quiuꞌ”, san nedaꞌ cutu gúquibeꞌidaꞌ naquëꞌ bxuz blau. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Niꞌr gúquibeꞌinëꞌ Pablo nacquëꞌ bönniꞌ gdauꞌ saduceo laꞌquëꞌ, atiꞌ yelaꞌquëꞌ bönniꞌ gdauꞌ fariseo, atiꞌ bëꞌë zidzj didzaꞌ lauquëꞌ bönniꞌ gdauꞌ taꞌbequi xbey naꞌ, gnëꞌ: ―Lbiꞌiliꞌ, böchaꞌa. Nacaꞌ bönniꞌ fariseo, len nacaꞌ zxiꞌnëꞌ bönniꞌ fariseo. Naꞌa rbequi xbeyliꞌ nedaꞌ le runaꞌ löz lubán nup chnatgac. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Catiꞌ bëꞌë didzaꞌ ni Pablo, gularujëꞌ chopl bönniꞌ gdauꞌ fariseo len bönniꞌ gdauꞌ saduceo, atiꞌ guladíl‑l didzëꞌë laꞌ légaczëꞌ. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Cni glunëꞌ le taꞌnë́ꞌ bönniꞌ saduceo naꞌ cutu lubán nup chnatgac, len cutu nacuꞌë gbaz laꞌy, len cutu nacuáꞌ böꞌ nacgaccz bunách, san taꞌyejlëꞌë bönniꞌ gdauꞌ fariseo nacz yúguꞌtë lë ni. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Qui lë ni naꞌ gulabödxyëꞌë. Niꞌr gulayasëꞌ bönniꞌ nazëdquëꞌ zxba queëꞌ Dios, bönniꞌ gdauꞌ fariseo, atiꞌ guladíl‑l didzëꞌë, taꞌnë́ꞌ: ―Rusácaꞌtuꞌ queëtuꞌ cutu bi döꞌ nuꞌë bönniꞌ ni, le chquiꞌ bëꞌlen lëꞌ didzaꞌ böꞌ naccz bunách, o chquiꞌ bë́ꞌlenëꞌ lëꞌ didzaꞌ gbaz laꞌy queëꞌ Dios, cutu ral‑laꞌ táꞌbagaꞌruꞌ‑nëꞌ Dios. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Catiꞌ chtaꞌdil‑ltsca didzëꞌë bönniꞌ judío naꞌ, gúdxinëꞌ bönniꞌ blau naꞌ nacuꞌë lu nëꞌë bönniꞌ rjaquëꞌ gdil‑l, le ráquinëꞌ luzxúzxj luquindjëꞌ Pablo. Niꞌr gna bëꞌë tsjaquëꞌ bönniꞌ rjaquëꞌ gdil‑l tsajliajquëꞌ Pablo ladj bönniꞌ judío naꞌ, len luchë́ꞌë lëꞌ lu yuꞌu zxön ga naꞌ tuꞌdubëꞌ bönniꞌ rjaquëꞌ gdil‑l. ");
INSERT INTO zsrNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Catiꞌ chnac chdzöꞌl laꞌ dza naꞌz, buluíꞌ lahuëꞌ Xanruꞌ ga zoëꞌ Pablo, len gudxëꞌ lëꞌ: ―Butíp ladxuꞌu, Pablo. Ca naꞌ chbenuꞌ lnaꞌ lau quiaꞌ Jerusalén ni, lëzcaꞌ run bayúdx gunuꞌ