﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpzNTpp_vpl;
CREATE TABLE zpzNTpp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpzNTpp_vpl WRITE;
INSERT INTO zpzNTpp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nu nii tub lisht ni de gyitoo bel ni Jesucrisht, biñ nu bruu lat nez gyitoo Dabi nu nez gyitoo Abraham. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham guc yu uz Isaac. Zeꞌ Isaac guc yu uz Jacob. Zeꞌ Jacob guc yu uz Judá nu deꞌ zir de bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zeꞌ Judá guc yu uz Fares nu Zara. Zeꞌ ñaa dey, mi zeꞌ lam Tamar. Zeꞌ Fares guc yu uz Esrom. Zeꞌ Esrom guc yu uz Aram. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram guc yu uz Aminadab. Aminadab guc yu uz Naasón. Naasón guc yu uz Salmón. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón guc yu uz Booz. Zeꞌ ñaay lam Rahab. Zeꞌ Booz guc yu uz Obed. Zeꞌ ñaay lam Rut. Obed guc yu uz Isaí. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí guc yu uz rey Dabi. Zeꞌ Dabi guc yu uz Salomoong. Zeꞌ ñaay, ndeꞌ biñ nu guc mñaa Urías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoong guc yu uz Roboam. Zeꞌ Roboam guc yu uz Abías. Zeꞌ Abías guc yu uz Asa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa guc yu uz Josafat. Josafat guc yu uz Joram. Joram guc yu uz Uzías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías guc yu uz Jotam. Jotam guc yu uz Acaz. Acaz guc yu uz Ezequías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías guc yu uz Manasés. Manasés guc yu uz Amón. Amón guc yu uz Josías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías guc yu uz Jeconías nu de bicy yu. Tiem zeꞌ gua de mbecy Israeel pres gashtal lo yu ni Babilonia. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Despuees ornu bri dey Babilonia, Jeconías guc yu uz Salatiel. Salatiel guc yu uz Zorobabel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel guc yu uz Abiud. Abiud guc yu uz Eliaquim. Zeꞌ Eliaquim guc yu uz Azor. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor guc yu uz Sadoc. Sadoc guc yu uz Aquim. Aquim guc yu uz Eliud. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Zeꞌ Eliud guc yu uz Eleazar. Eleazar guc yu uz Matán. Matán guc yu uz Jacob. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob guc yu uz See ñgyee Li. Fiñ zeꞌ guc ñi ñaa Jesuuz, biñ nu rnii den nu nac Mesías, biñ nu ca lo cuen nu cyid nu co mbañ de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Orzeꞌ gush ñi nese tiem nu bzu Abraham gashtal tiem nu bzu Dabi guc trotap nac nez dey. Nunu gucaꞌ trotap nac nez dey, gush ñi nese tiem nu bzu Dabi gashtal tiem nu gua dey pres gal Babilonia. Nunu gucaꞌ tub trotapaꞌ nac nez dey nese tiem nu gua dey pres zeꞌ gashtal tiem nu gul Mesías, biñ nu ca lo cuen nu cyid nu co mbañ de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mod nu guc ornu gul Jesucrisht. Li, fiñ nu guc ñaam, bi byaꞌ lo riidz nu chelaañ See, tees anzir nu gyatublaazh dey, orzeꞌ bi rabee nu secyi zuñ nu nac coz ily nu bicy Espiriit Yon ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","See, yu nu gac ñgyeeñ nac yu tub mbecy nu ricy coz nu seꞌñ. Orzeꞌ wangalagy yu coy gyel mbecy niñ lo dela mbecy. Orzeꞌ mnii tooy nu tily yu trat zeꞌ dze ga nu wachelaay ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lat nu rash yu shcab nu nac ndeꞌ, orzeꞌ bruu zac tub anc ni Ñgyoozh loy lat pcaal yu. Orzeꞌ anc zeꞌ nay: ―See nez Dabi, cueꞌ dzib ru nu gash ru Li nu gac mñaar, gun secyi zuñ nu nac Espiriit Yon ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na gaal ñi tub mdoo gyeey. Orzeꞌ co lar mi Jesuuz. Ni gruu lam gun mi zeꞌ co mbañ mi de mbecy ledz mi nu nac cyi dey ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dela de coz ii ni guuc ñi par nu byuꞌ niñ gal nu mnii Shuaan den lat de riidz nu bzeeñ tub yu nu mnii por cuen nim ornu nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tub fiñ feñ yon chuꞌ iꞌñ ñi. Orzeꞌ gaal ñi tub mdoo gyeey. Mi zeꞌ co la dey mi Emanuel, mniim. (Riidz Emanuel zeꞌ yaruuñ: Ñgyoozh nac num de ub naa.) ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na ornu See briish yu yaa ni pcaal zeꞌ, orzeꞌ bicy yu gal nu mnii anc ni Shuaan den. Orzeꞌ pchelaay Li. Byac ñi mñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tees wangal dey losaꞌy gashtal bi bded nu gul iꞌñ ñi. Nunu See bloo lay mi Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesuuz gul mi tub gyedz nu ri lo yu ni Judea nu la Beleeng. Gul mi tiem nu Herodes nac yu rey. Orzeꞌ bri la be mbecy nu bruu gashtal zeꞌ nu driib doo, briy Jerusaleeng. De yu zeꞌ nac dey mbecy nu rsyaꞌ de mod nu ricy bel baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Orzeꞌ bdugyiꞌ dey: ―¿Ca lugaar gul rey ni de mbecy Israeel? Gun gashtal zeꞌ nu driib doo bzaac de̱ bel baa nu briic muesht nu bi gul yu. Ndeꞌ nu yap de̱ nu griib zily de̱ yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na ornu güeñ rey Herodes ndeꞌ, orzeꞌ tonaꞌ la guc deet nañ lardooy. Nunu ni ziꞌl guc deet nañ lardoo deꞌ zir de mbecy gyedz Jerusaleeng ornu güeñ yu de coz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Orzeꞌ Herodes bredz yu de uz zub lo, nunu bredz yu de yu nu rlyuu leey nu bzeeñ Moisees nu gyatublaazh dey. Orzeꞌ bdugyiꞌy lo dey ben ca lugaar gal Mesías, biñ nu ca lo cuen nu cyid nu co mbañ de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Orzeꞌ de yu zeꞌ nay: ―Gal mi tub gyedz nu ri lo yu ni Judea nu la Beleeng, gun ni pcaa tub yu nu mnii por cuen ni Ñgyoozh ornu pcaay: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ru Beleeng, tub gyedz nu ri lo yu ni Judea, ru walab tub gyedz nu ich zir zu par deꞌ zir de gyedz ily nu yuꞌ lo de yu ni Judea, gun zeꞌ nu ri ru gruu zac tub biñ nu gyub ic. Mi zeꞌ gyub ic mi de mbecy ne̱, de mbecy Israeel. Ni pcaa de yu nu mnii por cuen ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Orzeꞌ Herodes dze ga bredz yu de yu nu rsyaꞌ mod nu ricy bel baa. Gazeꞌ nu bdugyiꞌy lo dey la gaal tiem nu bruu zac bel baa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Orzeꞌ bzuu nez yu dey zay Beleeng. Orzeꞌ nay: ―Gua der gal zeꞌ. Nap yub der mdoo zeꞌ. Ornu gyap ru yu zeꞌ, orzeꞌ yeedaꞌ der laabaꞌ par ii gun orzeꞌ gyoor rishlo̱. Gun niꞌ ya̱ cha̱ griib zilya̱ yu ―na Herodes. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na ornu byaꞌ lo nu bee dey riidz nu rey Herodes, orzeꞌ de yu nu rsyaꞌ mod nu ricy bel baa zeꞌ bruu dey loy zay. Na ornu bi zaab za dey zay, orzeꞌ bruu zacaꞌ bel baa nu bi bzaac dey anzir par zeꞌ nu driib doo zeꞌ. Za ma gashtal zeꞌ nu mbish mdoo zeꞌ. Zeꞌ guca ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ornu bzaac dey bel baa zeꞌ, orzeꞌ tonaꞌ la bet lagy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Orzeꞌ ornu guꞌ dey nañ yuꞌ, orzeꞌ bzaac dey mdoo zeꞌ nu ñaam Li. Orzeꞌ gusu tib dey nunu briib zily dey mdoo zeꞌ. Gazeꞌ nu tub ga la dey pshaal yu ruꞌ cajo̱o̱ niy. Orzeꞌ briic dey or ganim. Briic dey tub lo yaal nap nu dzi ñgyup sac ganim. Nunu briic dey tub lo gaꞌ bid nu zguul tiꞌ nu la mirra ganim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Orzeꞌ despuees mnii Ñgyoozh lat pcaal dey nu cueꞌ cush cyay ded yu lo Herodes. Orzeꞌ reñaꞌ nez bish cya dey yay par ledz yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Despuees ornu bi ya de yu nu rsyaꞌ mod nu ricy bel baa zeꞌ, orzeꞌ bruu zac tub anc ni Ñgyoozh Shuaan den lat pcaal See. Orzeꞌ nay rab yuy: ―Wesh te. Gush mdoo ii nu ñaam. Orzeꞌ na gua dze der gashtal lo de yu ni Egipto. Zeꞌ cyiiñ ru gashtal ornu ya̱ ne̱e̱ lor, gun Herodes yub yu mdoo ii par nu cut yuy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Orzeꞌ See lueg la wesh tey, nunu gush yu mdoo zeꞌ, nunu pteey ñaa mdoo zeꞌ. Orzeꞌ gush nez yu zay laab nañ rel zeꞌ, za nuy mdoo zeꞌ nu ñaam par Egipto. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zeꞌ pcyiiñ dey gashtal gut la Herodes. Ni guuc ñi par nu byuꞌ niñ gal nu mnii Ñgyoozh Shuaan den lat de riidz nu pcaa tub yu nu mnii por cuen nim ornu nam: “Ya̱ bredza̱ iꞌña̱ par nu gruum Egipto”, nam. Ni pcaa yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na ornu gud lagy Herodes nu de yu nu rsyaꞌ mod nu ricy bel baa zeꞌ nu bguu dey yu, orzeꞌ tonaꞌ la guzi lagy yu. Orzeꞌ bicy yu mandaar nu cut mbecy de yu nguzh miꞌ nu yuꞌ ñaꞌn cyup par gash. Cut dey de yu nguzh nu yuꞌ Beleeng gal nu de yu nguzh nu yuꞌ dub yub la gaab ga ruꞌñ. Ni mod bicy yu gun gush yu tiem nu bruu zac bel baa gal nu mnii de yu nu rsyaꞌ mod nu ricy ma zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ni mod guc ñi par nu byuꞌ niñ gal nu pcaa Jeremías, tub yu nu mnii por cuen ni Ñgyoozh ornu pcaay: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lat gyedz nu la Ramá zaab tiꞌ mbecy. Tonaꞌ la ruun dey. Tonaꞌ la ricy dey sentiir. De yu nu ruun zeꞌ, ndeꞌ nez Raquel. Ruun dey nu nac iꞌñ yu. Tees walagy dey nu cuic mbecy consuel niy gun dela de iꞌñ dey bi gut yu. Ni pcaa Jeremías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Despuees ornu gut Herodes, orzeꞌ tub anc ni Ñgyoozh Shuaan den bruu zacaꞌy lat pcaal See lat nu rcyiiñ yu Egipto. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Orzeꞌ nay rab yuy: ―Wesh te. Gun gyar nu yu nguzh zeꞌ nu ñaam. Yaa par lo de yu ni Israeel, gun na bi gut yu nu rlagy cut yu nguzh zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Orzeꞌ See wesh tey ya nuy yu nguzh zeꞌ nu ñaam Li. Yay par lo de yu ni Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tees ornu güeñ yu nu Arquelao byeeñ yu lo uz yu Herodes nu riib ic yu Judea, orzeꞌ gudzib yu ñgyay lugaar zeꞌ. Orzeꞌ laabaꞌ lat pcaal yu mnii Ñgyoozh loy lac mod gyicy yu. Orzeꞌ guay tub lugaar ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na ornu briy zeꞌ, guay pcyiiñ yu tub gyedz nu la Nazaret. Ni guc de ndeꞌ par nu byuꞌ niñ gal nu mnii tub yu nu mnii por cuen ni Ñgyoozh ornu mniiy nu mbecy niiy nu Jesuuz nac mi tub mbecy Nazaret. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tiem zeꞌ bri Waa nu briib nis mbecy tub lugaar ub zi lo yu ni Judea. Orzeꞌ brugyiꞌ rshaal yu riidz nu bruu lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Orzeꞌ nay: ―Mneꞌ der dela cyi nu ricy ru gun sñuu ga cyid gyel gubier ni Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Gun Isaías, yu nu mnii por cuen ni Ñgyoozh, laab Waa bzat yu ornu nay: Zaab tiꞌ tub mbecy. Rbish tiy tub lugaar ub zi. Orzeꞌ nay: “Nañ lardoo den nañ gal nu na tub nez. Orzeꞌ bicy nap der nez zeꞌ par ornu cyid Shuaan den. Pshaal der tub nez nu li par nu ded mi”, na Isaías, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Shab Waa, ndeꞌ byaañ nu gyich camey. Zeꞌ nañ yu ri tub sinch gyid. Coz nu bdow yu, ndeꞌ gushagy nu dziñ doo ni bez gyish. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","De mbecy nu yuꞌ Jerusaleeng, nu de mbecy nu yuꞌ lo de yu nu la Judea, nu de mbecy nu yuꞌ gaab ga ruꞌ gyoow Jordaang, za dey nu zuub gyidag yu coz nu rnii Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na ornu blazh pshuub ruꞌ dey dela cyiy, orzeꞌ Waa briic yu nu wi nis dey gyoow Jordaang. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tees ornu bzaac Waa nu dzi zigy de mbecy fariseo gal nu mbecy saduceo bruꞌña dey par nu cuic yu nu zu nis dey, orzeꞌ nay: ―De ru mbecy shiñ ricy, ¿cyu mnii lo der nu gac gla der lo cashtig ily ni Ñgyoozh nu bi yad gaab ñi? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bicy der tub mod nu nap gabe nu bi mneꞌ der cyir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cueꞌ gnii too der nu glar ni de cashtig zeꞌ nu nac nu rnii der: “Nac naa nez gyitoo bel nin Abraham”, rniir, gun rishli Ñgyoozh gac gyash mi gashtal de gyitaꞌ ii nu gyicy mi nu gyac ñi nez Abraham. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gun cashtig ni Ñgyoozh nañ gal na tub gyibag. Bi zu lily laañ par nu shiꞌñ ñi dela yag gashtal lyu lañ. Dela yag nu wacuic uugy nap, gyiꞌñ ñi nunu chañ lo gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Ya̱ nu rishli drica̱ nu zu nis der nu nis par nu gabe nu bi mneꞌ der cyir, tees biñ nu cyid par lo̱, mi zeꞌ cuic mi Espiriit Yon ni Ñgyoozh ni mbecy, nunu cuic mi tub cashtig nu nañ gal nu na gyi. Mi zeꞌ gya zir zum par ya̱. Ya̱ rila wangyapa̱ du̱ ni gyid lab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mi zeꞌ nam gal nu na tub mbecy nu bi zu lily nu tub ya ruꞌ biiz par nu com dela mbigy trig, nunu gyicy tublaazh mi ñii par nu cuꞌ choow mi ñii nañ ye. Zeꞌ de gyid ich ñi zeed mi ñii chañ lo tub gyi nu rila wayu ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tiem zeꞌ Jesuuz bruum Galilea zam gashtal ruꞌ gyoow Jordaang. Orzeꞌ bruꞌñam lugaar zeꞌ nu ri Waa gun orzeꞌ cuic yu nu zu nis mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nu loga la “Cueꞌ”, na Waa rab yum. Orzeꞌ nay: ―Ya̱ rlagy ñi nu cuic ru nu zu nisa̱. Zeꞌ ii ca ru yad ru lo̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Orzeꞌ na Jesuuz rab mi yu: ―Bzaan la nu ni gac ñii na, gun rlagy ñi nu gyicy yac den nu de coz nu rlagy Ñgyoozh ―nam. Orzeꞌ Waa pshet ic yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuanzir nu wi nis Jesuuz, orzeꞌ bruum lo nis. Orzeꞌ sij la byaal gyibaa. Orzeꞌ Jesuuz bzaac mi Espiriit Yon ni Ñgyoozh nu bet mi. Bet mi gal nu yet tub begy gusub mi toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Orzeꞌ zaab tiꞌ nu rnii gashtal gyibaa. Orzeꞌ nam: ―Mi ii iꞌña̱, biñ nu tonaꞌ la rca̱ nunu tonaꞌ la yet lagya̱ ―nam gal baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gazeꞌ nu Espiriit Yon ni Ñgyoozh gua num Jesuuz tub lugaar ub zi par nu gyicy nuras preb mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Brim cyuu dzi nu cyuu rel nunu rila wangow mi gyit. Orzeꞌ despuees byan mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Orzeꞌ bechaꞌ nuras lom par nu gyicy yu preb mi. Orzeꞌ nay: ―Benu ru rishli gaal nac ru iꞌñ Ñgyoozh, orzeꞌ mnii lo de gyitaꞌ ii nu gyac ñi gyishtily ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Orzeꞌ Jesuuz nam rab mi nuras: ―Lat de riidz ni Ñgyoozh rniiñ: “Walab gyishtily ziꞌl gyicy ñi nu cui mbañ mbecy, sinu niꞌ ziꞌl dela riidz nu rnii Ñgyoozh gyicy ñi nu cui mbañ dey”, rniiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Gazeꞌ nu za nu nuras mi par Jerusaleeng, gyedz ni Ñgyoozh. Orzeꞌ pshup yu Jesuuz zeꞌ nu gya zir ni yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Orzeꞌ nay rab yum: ―Benu ru rishli gaal nac ru iꞌñ Ñgyoozh, bzut yeñ gashtal lo yu re, gun ryat ru lat de riidz ni Ñgyoozh ornu rniiñ: Ñgyoozh cuꞌm riiñ yaa de anc nim nu ña dey ru. Orzeꞌ laagy yaa dey ru gun orzeꞌ cueꞌ nu gad güii par ni gyiꞌr lo de gyitaꞌ, rniiñ ―na nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Orzeꞌ Jesuuz nam rab mi nuras: ―Niꞌ ziꞌl rniiñ lat de riidz nim: “Cueꞌ gyicy ru preb Ñgyoozh Shuaan ru, biñ nu nac Ñgyoozh nir”, rniiñ ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gazeꞌ nu za nu gaꞌ nuras mi gashtal too tub bicy ily. Orzeꞌ blyuuy dela lugaar nu yuꞌ gyishlombecy nu dela gyel lily niñ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Orzeꞌ nay rab yum: ―Ya̱ rica̱ dela nde nir benu zu tib ru lo̱ par nu riib zily ru ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Orzeꞌ Jesuuz nam rab mi nuras. ―Bruu chu lo̱ ii nuras, gun lat de riidz ni Ñgyoozh rniiñ: “Briib zily Shuaan ru biñ nu nac Ñgyoozh nir, nunu coz nu rlagy ziꞌl mi gyicy ru”, rnii riidz nim ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Orzeꞌ nuras bruu chuy lo Jesuuz. Orzeꞌ bruꞌña de anc par nu locyuub dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ornu Jesuuz güeñ mi nu pshet lag mbecy Waa pres, orzeꞌ zam par Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tees wancyiiñ mi Nazaret sinu guam pcyiiñ mi tub gyedz nu la Capernaum. Capernaum ndeꞌ garee riñ ruꞌ nisyudoo lo yu ni de nez mbecy Zabulón nu ni nez Neftalí. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ni mod guc ñi par nu gyuꞌ niñ gal nu pcaa Isaías, yu nu mnii por cuen ni Ñgyoozh: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","De yu ni nez Zabulón nu de yu ni nez Neftalí nu ri tub la gaꞌ ruꞌ gyoow Jordaang garee ruꞌ nisyudoo, gal nu de lo yu ni Galilea, zeꞌ nu yuꞌ mbecy nu walab mbecy Israeel, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","de mbecy nu yuꞌ lugaar zeꞌ rded dey zeꞌ nu cow. Gzac dey tub gyi ily nu cuic ñi yaa. Gyi zeꞌ ndeꞌ cuic ñi yaa lat de mbecy nu yuꞌ zeꞌ nu cow, zeꞌ nu yuꞌ mbecy nu na gal nu na mbecy gut, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nese tiem zeꞌ brugyiꞌ Jesuuz nu rshaal mi de coz ni Ñgyoozh. Orzeꞌ nam: ―Mneꞌ der dela cyi nu ricy ru gun sñuu ga cyid gyel gubier ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lat nu gusa Jesuuz de ruꞌ nisyudoo ni Galilea, orzeꞌ bzaac mi cyup mbecy nuy bicy yu. Tub yu lay Simo̱o̱, nunu laab yu zeꞌ rnii dey Bed. Zeꞌ tuubaꞌy lay Ndrees. Rup laa dey nac yu mbecy rub bel. Yuꞌ dey nu rneꞌy gyish niy lo nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Orzeꞌ na Jesuuz rab mi dey: ―Da ca der icha̱. Orzeꞌ ya̱ gyicya̱ nu gal nu rub der bel, niꞌ ziꞌl teꞌ der mbecy gun orzeꞌ cyid ca dey icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Orzeꞌ laab or la zeꞌ bzeeñ dey gyish niy za ca dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Orzeꞌ bzam sñuu miiñ par lo. Zeꞌ bzaacaꞌm tub cyupaꞌ dey nuy bicy yu: Santiag nuy Waa. De yu zeꞌ nac yu iꞌñ Zebedeo. Yuꞌ dey nañ tub barc nuy uz yu. Laabaꞌ gyish nu rub bel ricy nap dey. Orzeꞌ Jesuuz bredz mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Orzeꞌ lueg la bzeeñ ga dey barc niy. Bzeeñ ga la dey uz yu. Orzeꞌ za nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesuuz gusam dutuub la lo yu ni Galilea. Tub ga la lugaar nu rded mi, rlyuum ni de mbecy nañ de yuꞌ nu rsyaꞌ dey riidz ni Ñgyoozh, nunu pshaal mi de riidz nu sac ni gyel gubier nim, nunu bicy yac mi de lo la güii nu rac ni de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Orzeꞌ bzu laa riidz dutuub la lo yu ni Siria de coz nu ricy mi. Orzeꞌ brugyiꞌ rza nu dey dela mbecy nu rat de lo la güii lom, nu dela mbecy nu rzac de lo la coz deet. Rza nu dey de yu nu bicy ni nuras. Rza nu gaꞌ dey de yu nu nash bi. Nunu rza nu gaꞌ dey de yu nu nac mbecy chi̱. Orzeꞌ Jesuuz bicy yac mi dela dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nunu tonaꞌ la mbecy zigy bruuy lo yu ni Galilea, bruu dey lat de tii gyedz nu rnii dey Decápolis, nunu bruu gaꞌ dey Jerusaleeng, nunu bruu gaꞌ dey de la lo yu ni Judea, nunu bruu gaꞌ dey tub laꞌ gaꞌ lo yu ni ruꞌ gyoow Jordaang. Orzeꞌ dela de yu zeꞌ guay lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na ornu Jesuuz bzaac mi de mbecy zigy zeꞌ, orzeꞌ gup mi too tub bicy. Orzeꞌ gusub mi. Orzeꞌ de yu nu rsyaꞌ lom byatublaazh dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Orzeꞌ brugyiꞌ rlyuum ni dey. Gazeꞌ nu nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Dzi ni de mbecy nu rad lagy nu ricy falt coz ni Ñgyoozh ni, gun de yu zeꞌ gzac dey lo gyel gubier nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Dzi ni de mbecy nu ricy shni nu nac cyi gun Ñgyoozh cuic mi consuel niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Dzi ni de mbecy nu wayicy gyel lily ni, gun dutuub la gyishlombecy nu yad par lo gyiyeeñ ñi yaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dzi ni de mbecy nu ric la añ ni nu gyanap yu lo Ñgyoozh, gun mi zeꞌ gyicy mi nu gac yu gal nu rlagy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Dzi ni de mbecy nu rashni lagy losaꞌ, gun Ñgyoozh gashnii gaꞌ lagy mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dzi ni de mbecy nu caacy lardoo, gun de yu zeꞌ gzac dey lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Dzi ni de mbecy nu gyicy nu gyanap mbecy nu losaꞌy, gun Ñgyoozh gniim: “De yu zeꞌ iꞌña̱”, gniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dzi ni de mbecy nu rzac zi nu nac de coz nu seꞌñ, gun de yu zeꞌ gzac dey lo gyel gubier ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Dzi ni de ru ornu mbecy nii ziy ni der, ornu mbecy griib dey de lo la gyidza too der nu nac ya̱ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ornu gyeñ der de coz zeꞌ, orzeꞌ bet lagy der, nunu bicy der nu nap zu lagy ru gun gyibaa gyad tub i der nu tonaꞌ la coz ily. Gun niꞌ ziꞌl mod pshet zi dey de yu nu mnii por cuen ni Ñgyoozh, de yu nu guꞌ anzir nu chuꞌ de ru ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’De ru ricy der lat de mbecy ni gyishlombecy ii gal nu ricy zed nu tub nac beel. Tees benu zed gruu nu riꞌ niñ, orzeꞌ ¿lac mod gyicy der par nu cush cyaꞌ nu riꞌ niñ tuubaꞌ tir? Benu gruu nu riꞌ niñ, orzeꞌ se laꞌ la cyiiñ ñi, sinu par nu duneꞌñ nunu par nu zuub gyiꞌ cyu ziꞌl mbecy nu ded tooñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’De ru na der gal nu na tub gyi lat de mbecy nu yuꞌ gyishlombecy ii. Tub gyedz nu riib too tub bicy rila wac cach loñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Niꞌ ziꞌl mbecy wacaa dey gyi tub candiil par nu griiy ñi nañ tub cajo̱o̱, sinu gzuub dey ñi tub zeꞌ nu gya par nu cuic ñi yaa lo dela mbecy nu yuꞌ nañ yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Niꞌ ziꞌl mod bicy de ru. Gun mod nu gyicy der ndeꞌ nañ gal nu na yaa ni candiil. Orzeꞌ bicy der mod nu nap, gun ornu de mbecy gzac dey de coz nu ricy der, orzeꞌ gyabic dey gyel mbecy ni Ñgyoozh uz den nu zub gyibaa ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Cueꞌ saꞌ lagy der nu ya̱ yapa̱ nu tilya̱ leey ni Moisees o nu tilya̱ de riidz nu blyuu de yu nu mnii por cuen ni Ñgyoozh. Gun ya̱ walab nu yapa̱ par nu tilya̱ de leey zeꞌ sinu par nu rica̱ nu gad lagy der lac yaruuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gun rishli rne̱e̱ lo der nu lat nu zu gyibaa nu gyishlombecy ii, wac nit lo ni tub riidz ni de leey zeꞌ. Wanit loñ gashtal shuub la tiem nu gac dela coz nu bi cañ nu gac ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndeꞌ nu cyu ziꞌl mbecy nu wayicy paa nu mas tub coz miꞌ ni leey zeꞌ, nunu cyu ziꞌl mbecy nu lyuu ni losaꞌ nu ni gyicy yu, orzeꞌ Ñgyoozh niim nu yu zeꞌ gash zir zuy lat de mbecy nu riib ic mi par deꞌ zir mbecy. Zeꞌ de yu nu ricy yac nu de leey zeꞌ, nunu lyuuy ni losaꞌy nu ni gyicy dey, orzeꞌ niim nu yu zeꞌ nac yu mbecy zub lo lat de mbecy nu riib ic mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gun ya̱ rne̱e̱ lo de ru nu benu wayicy paa zir der nu de leey zeꞌ gazeꞌ de mbecy nu rlyuuñ, gal nu de mbecy fariseo, orzeꞌ rila wazac der lo Ñgyoozh ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’De ru bi güeñ der nu mnii de gyitoo bel nir: “Cueꞌ cut ru losaꞌr, gun cyu ziꞌl mbecy nu rut losaꞌ, yu zeꞌ rlagy ñi nu cuic de yu nu zu riiñ cashtig niy”, mnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tees ya̱ rne̱e̱ lo der nu cyu ziꞌl mbecy nu rzi lagy lo losaꞌ, yu zeꞌ Ñgyoozh gri beem niy. Nunu yu nu gab zi losaꞌ, de mbecy ni junt zub lo gri beey niy. Nunu yu nu gnii nu tub losaꞌ nu nac yu tub mbecy ton, yu nu ni nii zeꞌ yad ñi niy nu gyay lo gyi ni gabily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ndeꞌ nu benu cha nur gun nir zeꞌ nu driib zily ru Ñgyoozh, orzeꞌ zeꞌ gyezaꞌ lagy ru nu tub losaꞌr ca ic yu lor, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","orzeꞌ bzeeñ gun nir zeꞌ nu driib zily ru Ñgyoozh zeꞌ. Nu loga la gua bicy rishnap nu losaꞌr. Gazeꞌ nu cush cyar zeꞌ nu driib zily ru Ñgyoozh par nu cuic ru gun nir nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Benu ca na tub losaꞌr rlagy yu cuꞌy cyir lo de fushtiz, orzeꞌ bzu altant nu gyicy ru rishnap nur yu lat nu gabee cuic ñi tiem nir, anzir nu guꞌy ru yaa de fushtiz. Gun ornu bi bguꞌy ru yaa de fushtiz, orzeꞌ gyabic dey ru yaa de yu nu riib ic roꞌ gyiib. Orzeꞌ shet lag yu ru nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gun rishli ya̱ rne̱e̱ lo der nu waruur nañ gashtal cuaa lar dela tiñ nu nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’De ru bi güeñ der nu mnii de gyitoo bel ornu nay: “Cueꞌ gal der losaꞌr nu wanchelaar”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tees ya̱ rne̱e̱ lo der nu cyu ziꞌl mbecy nu güii lo tub biñ mñaa nu rnii ziꞌl tooy nu rlagy yu gal yum, orzeꞌ yu zeꞌ bi bicy yu cyi nu bi gul yum nañ lardooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Orzeꞌ benu tub urlo beer gyicy ñi nu gyicy ru cyi, orzeꞌ cor ñii nunu neꞌr ñii, gun nap zir benu duneꞌ tub zi lugaar ni cuerp nir, gazeꞌ nu dutuub la cuerp nir gyet lag ñi gabily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nunu benu yaa beer gyicy ñi nu gyicy ru cyi, orzeꞌ pshiꞌñ ñi nunu mneꞌñ chañ zet, gun nap zir nu duneꞌ tub zi lugaar ni cuerp nir, gazeꞌ nu dutuub la cuerp nir gyet lag ñi gabily ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Niꞌ ziꞌl mnii dey gulas: “Cyu ziꞌl mbecy nu rlagy zaan mñaa, orzeꞌ rlagy ñi nu coy tub gyicy ni rishbeey nu zaan yu losaꞌy”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tees ya̱ rne̱e̱ lo der nu benu tub mbecy zaan yu mñaay, benu walab nu nac nu byuꞌ beem nu reñaꞌ yu gyeey, orzeꞌ ndeꞌ cyi na, gun ricy yu nu gyicy mñaay coz cyi ornu gash mi reñaꞌ yu gyeey. Nunu yu gyeey nu gash biñ mñaa zeꞌ niꞌ ricy yu coz cyi nu nac de coz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Niꞌ bi güeñ der nu mnii de gyitoo bel: “Cueꞌ gyicy der nu wayicy yac ru nu de coz nu mniir lo Ñgyoozh, Shuaan na, nu segur la gyicy ru, sinu gyicy yac ru nu de riidz nu mniir lom nu segur la gyicy ru”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tees ya̱ rne̱e̱ lo der nu rila cueꞌ niir lo mbecy nu segur la rishli tub riidz. Ornu nii der tub riidz, orzeꞌ cueꞌ zat ru gyibaa par nu gabe nu rishli rniir, gun gashtal zeꞌ zub Ñgyoozh riib ic mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nunu ornu niir tub riidz cueꞌ zat ru gyishlombecy par nu gabe nu rishli rniir, gun ii tub lugaar nu zu gyiꞌ Ñgyoozh. Ni cueꞌ zat ru Jerusaleeng, gun ndeꞌ gyedz nu zu rey zub lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni cueꞌ zat ru too ub ru par nu gabe nu riidz nu rniir ndeꞌ coz rishli, gun ni tub gyich toor wac gyicy caacy ru ñii o nu gyicy caas ru ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Orzeꞌ tub zi coz nu gac nii der, ndeꞌ “Laab ni” o “Walab ni”, gun mas lac ruꞌ co ic ru nu niir par nu gabe nu rishli rniir, orzeꞌ ndeꞌ gruuñ gashtal lo nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’De ru bi güeñ der nu mnii dey gulas: “Benu tub mbecy cad güiiy urlo losaꞌy, orzeꞌ losaꞌy cush cya gaꞌy cad güiiy urlo yu nu ni bicy zeꞌ. Benu tub mbecy cad güiiy lay losaꞌy, orzeꞌ cush cya gaꞌy cad güiiy lay yu nu ni bicy zeꞌ”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tees ya̱ rne̱e̱ lo der: Cueꞌ co yaa der lo mbecy nu shiñ ricy nu de ru. Sinu lugaar nu co yaar, nap zir nu “O la” mnii der. Benu tub mbecy shet yu zig tub laꞌ yalor, orzeꞌ zaabaꞌr tub laꞌ gaꞌ loy nu shet yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Benu tub mbecy shechaꞌy ru lo de fushtiz par nu coy yaag ru, orzeꞌ briic la niy nunu briicaꞌ la checyet nir niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Benu mbecy caay ru nu cha nur suuy cyaal or nez, orzeꞌ cha nu lar ñii tub or nez. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Benu ca na mbecy cyiñ yu la coz lor cuic ru ñii niy. Benu ca na mbecy rlagy yu coy la coz lor, orzeꞌ cueꞌ zu ir nu wabic ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Niꞌ bi güeñ der nu bi mnii dey gulas: “Pca der de amig nir. Zeꞌ de losaꞌ yuur bicy nu gazi lagy ru loy”, mnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tees ya̱ rne̱e̱ lo der: Pca der de losaꞌ yuur, nunu bdiiñ der lo Ñgyoozh ni de yu nu shiñ ricy nu de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gun orzeꞌ laab ricy der gal nu rlagy ñi nu gyicy de mbecy nu nac iꞌñ Ñgyoozh, uz den, biñ nu zub gyibaa. Gun mi zeꞌ ricy mi nu driib doo par nu ca yaa too mbecy nap nu mbecy a̱ꞌ nap. Nunu ricy mi nu yet gyey too mbecy nap nu too mbecy a̱ꞌ nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gun benu de ru ca der de mbecy nu rca ziꞌl ru, orzeꞌ ¿la ñuu i der gyad? Gun mas de yu nu rteꞌ tiñ par gubier Rom niꞌ ricy dey ndeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nunu benu de bicy ziꞌl ru nap nii nu der yu, ¿a dzi coz ilyaꞌ ricy der rziir? Mas gashtal de mbecy nu walab mbecy ni Ñgyoozh ni ricy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Guc der mbecy nu sac falt ni gal nu na Ñgyoozh, Uz der nu zub gyibaa, nac mi biñ nu sac falt ni. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Bzu der altant nu nac de coz nu gyicy der par Ñgyoozh. Cueꞌ glyuu der ñii lo mbecy par nu gzac dey coz nu ricy der, gun benu ni gyicy der, orzeꞌ Ñgyoozh, uz den, biñ nu zub gyibaa rila wabic mi i der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Ornu cuic ru gun ni tub mbecy nu ricy falt ñi ni, orzeꞌ cueꞌ cuic ru nu gad lagy mbecy. Gun ni ricy de mbecy rzuu lo nañ de yuꞌ nu rsyaꞌ der riidz ni Ñgyoozh nu lat de cay. Ni mod ricy dey par nu dela mbecy gyabic dey gyel mbecy niy. Tees ya̱ rishli rne̱e̱ lo der nu gyel mbecy nu byabic ziꞌl dey niy, ndeꞌ ziꞌl dela i dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Zeꞌ ornu ru cuic ru gun ni mbecy nu ricy falt ñi ni, orzeꞌ cueꞌ cuic ru nu gad lagy par ni tub amig nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sinu dze ga gyicy ru ñii. Orzeꞌ Ñgyoozh uz na zac mi de coz nu ricy de ru dze ga. Orzeꞌ gyabic mi i der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Na de ru ornu nii nu der Ñgyoozh, orzeꞌ cueꞌ gyicy der gal nu ricy de mbecy rzuu lo, gal nu ricy de mbecy nu yet lagy nu gyes su nii nu Ñgyoozh nañ de yuꞌ nu rsyaꞌ den riidz nim, nu de zeꞌ nu yacyup laꞌ nez. Ni ricy dey par nu gzac dela mbecy de coz nu ricy dey. Ya̱ rishli rne̱e̱ lo der nu ndeꞌ ziꞌl dela i dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tees ru ornu nii nur Ñgyoozh, guꞌ nañ yuꞌ nir nunu soow ru roꞌ nir. Orzeꞌ mnii nu Ñgyoozh, uz ru, biñ nu zu lor. Orzeꞌ Ñgyoozh, uz ru, biñ nu rad lagy de coz nu ricy mbecy dze ga, mi zeꞌ gyabic mi i der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Lat nu rnii nu der Ñgyoozh, cueꞌ zañ tir gniir riidz nu wacyiiñ gal nu ricy de yu nu a̱ꞌ yuꞌ lo Ñgyoozh. De mbecy zeꞌ rnii tooy nu segur la cuic mi de coz nu rgyiiñ dey nu nac nu dzi zañ riidz rnii dey, rziiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Orzeꞌ cueꞌ gyicy der gal nu ricy de yu zeꞌ, gun Ñgyoozh, uz den, bi rad lagy mi ca na coz nu cyiiñ ni der anzir nu cyiñ der lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","De ru, i mod gnii nu der Ñgyoozh ―nam―. Ñgyoozh, Uz de̱, ru biñ nu zub gyibaa. Rlagy ñi ca lagy de̱ lor. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","De̱ ya̱ rdiñ de̱ nu cyid gyel gubier nir lat de̱. Rdiñ de̱ lor nu gac ñii gyishlombecy ii gal nu rlagy ru, nunu gal nu rac gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dzi na doo coz nu rlagy ñi nu da̱w de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bicy sulagy ne̱ de̱ ni de coz cyi nu ricy de̱ gal nu de̱ ya̱, ricy sulagyaꞌ de̱ ni de yu nu shiñ ricy nu de̱ ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Cueꞌ zaan ru nu gyet lag de̱ lo preb, sinu bloo chu de̱ ya̱ lat de coz a̱ꞌ nap. Gun ru nac ru biñ nu riib ic nunu ru nac ru biñ nu gac gyicy dela coz nunu ru nac ru biñ nu lily na. Ni nac ru par tub la. Ni gac ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Se benu de ru gyicy sulagy der ni reñaꞌ mbecy nu shiñ ricy nuy ru, orzeꞌ niꞌ ziꞌl Ñgyoozh, uz den, biñ nu zub gyibaa, gyicy sulagyaꞌm ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tees benu wagyicy sulagy der ni reñaꞌ mbecy, orzeꞌ niꞌ ziꞌl Ñgyoozh, uz den, wayicy sulagy mi ni de cyi nu ricy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ornu de ru ca der ni ub ru nu cueꞌ gow ru gyit lat nu rzu bich der nu nac Ñgyoozh, cueꞌ gyicy der nu gabe nu ricy shnir gal nu ricy de mbecy rzuu lo. De yu zeꞌ rash dey tub mod par nu gabe nu ni ricy dey lo Ñgyoozh. Ya̱ rishli rne̱e̱ lo der nu ndeꞌ ziꞌl dela i dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","De ru, ornu gyicy ru ndeꞌ par lo Ñgyoozh, orzeꞌ bdaab lo der nunu bzu caacy der, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","gun orzeꞌ deꞌ zir mbecy wad lagy dey ti ni ricy der. Tub zi la Ñgyoozh, Uz den, biñ nu zu ngach nu de ru, rad lagy mi. Orzeꞌ Ñgyoozh, Uz den, biñ nu rzac de coz nu ricy der dze ga, orzeꞌ mi zeꞌ gyabic mi i der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Cueꞌ cyaañ der de gyel nap nir gyishlombecy ii, gun de gyel nap nu yuꞌ gyishlombecy ii gac gnit lo bigyich ñi, gac griib guul ñi, gac chuꞌ gubaan nañ yuꞌ coy ñi nu cha nuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nap zir pcyaañ der gyel nap nir gyibaa. Gun lugaar zeꞌ wac nit lo bigyich ñi, nunu warib guul ñi. Ni gubaan wac chuꞌy nu cha nuy ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gun zeꞌ nu rcyaañ ru gyel nap nir, zeꞌ lugaar nu ric la añ nir lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Urlor, ndeꞌ nañ gal na tub candiil nu rbic yaa nañ shcab nir. Orzeꞌ benu gyicy ru coz nap nu urlor, orzeꞌ gzu yaa nañ dutuub la shcab nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tees benu gyicy ru coz cyi nu urlor, cow la zu nañ shcab nir. Nunu benu sac la yaa nañ shcab nir, orzeꞌ cow la zu. Orzeꞌ tonaꞌ la shiñ zu nañ shcab nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Rila wac nu tub mbecy gyicy yu riiñ ni cyup patro̱o̱ niy, gun benu ni, orzeꞌ gazi lagy yu lo tub yu. Zeꞌ tuubaꞌy cay yu. O nu gyicy paay nuy tub yu. Zeꞌ tuubaꞌy güii naañ yu loy. Orzeꞌ wac zu bich mbecy nu nac Ñgyoozh, nunu niꞌ ziꞌl wac zu bich yu nu nac de gyel nap nu yuꞌ gyishlombecy ii laab tub ziꞌl tiem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ndeꞌ nu ya̱ rne̱e̱ lo der: Cueꞌ sug ic der nu nac de coz nu gow der o nu goꞌ der par nu cui mbañ ru gyishlombecy ii. Ni cueꞌ sug ic der nu nac shab ru. ¿A walab dzi zir sac nu cui mbañ der lo Ñgyoozh gazeꞌ de coz nu gow der? Nunu ¿a walab nu dzi zir sac cuerp ni der gazeꞌ shab ru? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Güii der de chigyiñ nu rded lo bi. Ni wagnuuz ma. Ni wagteꞌ ma cosech par nu cuꞌ choow ma ñii nañ ye. Tees Ñgyoozh uz den, biñ nu zub gyibaa, rgoow mi de ma. Zeꞌ yegar de ru. ¿A walab sac zir der gazeꞌ de chigyiñ? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ca na de ru nu nac nu dzi rsug ic der, orzeꞌ gac tuuñ zir der lo yur mas ñuu se tub or? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Lagu dzi rsug ic der nu nac shab ru? Bduꞌ cuen der lac mod raly de ya gyee nu nash ngush. Ni wagyicy ñi riiñ. Ni wagriꞌñ iily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tees ya̱ rne̱e̱ lo der nu rey Salomoong, mas tonaꞌ la guaniꞌñ yu, tees wansuy tub negy nu nsaap ñi gal nu na de gyee zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Benu Ñgyoozh rtiish mi de gyish, de nu nash ngush na nunu ina gyañ lo gyi nañ yo, ndeꞌ nu segur la tiish mi de ru, mbecy nu a̱ꞌ ricy cup consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ndeꞌ nu cueꞌ dzi csug ic der. Orzeꞌ niir: “¿Ca gad de coz nu dow na?”, o rnii gaꞌ der: “¿Ca gad de coz nu doꞌn?” o rnii gaꞌ der: “¿Ca gad negy cuish naa?” rnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gun dela de coz zeꞌ ricy ñi nu rsug ic mbecy nu walab mbecy ni Ñgyoozh. Tees de ru, zu Ñgyoozh uz der, biñ nu zub gyibaa nunu mi zeꞌ bi rad lagy mi nu de ndeꞌ coz nu galagy ñi ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Orzeꞌ nu loga la bzub lo der nu nac gyel gubier ni Ñgyoozh, nunu niꞌ bzub lo der ni nu rlagy mi nu gyanap der lom. Orzeꞌ ub mi cuic mi dela coz nu galagy ñi ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Orzeꞌ cueꞌ dzi gash der shab par nu nac ina, gun yuꞌ gaꞌ coz par ina nu gash der shcab. Tub dzi ga yuꞌ zir coz nu gash der shcab ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Cueꞌ nii der nu yuꞌ falt ni losaꞌr gun orzeꞌ Ñgyoozh waniim nu yuꞌ falt ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gun mod nu gyicy der nu losaꞌr, laabaꞌ mod zeꞌ gyicy Ñgyoozh num de ru. Nunu laabaꞌ beey nu tush pee der ni losaꞌr, laabaꞌ beey zeꞌ tush pee Ñgyoozh ni de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","De ru na der gal nu na mbecy nu rguꞌ cuen toop miꞌ nu ri urlo losaꞌ. Zeꞌ yabicy nu ri urlo ub ru, ndeꞌ wagyicy cuen der ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Zeꞌ benu ru ri tub yabicy urlor, orzeꞌ ¿lagu rnii gaꞌr lo losaꞌr: “Doo urlor gun lo̱o̱ toop miꞌ zeꞌ”, rnii gaꞌ der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡A mbecy rzuu lo! Bloo yabicy ily nu ri urlor loga la, gun orzeꞌ nap zir zac ru toop miꞌ nu ri urlo losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Yuꞌ mbecy nu na dey gal nu na che̱ꞌ. Cueꞌ cuic der coz nap ni Ñgyoozh ni che̱ꞌ nis cush cya ma shet ruꞌ ma der. Yuꞌ gaꞌ mbecy na dey gal nu na cuch. Orzeꞌ cueꞌ cuic der de coz nu dzi sac nir ni cuch gun nis tab yu ma ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Bdiiñ der lo Ñgyoozh, gun Ñgyoozh cuic mi de coz nu cyiñ der. Byub der ñii gun orzeꞌ gad ñi ni der. Mnii nu der mi, gun orzeꞌ shaal mi roꞌ ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gun cyu ziꞌl mbecy nu rgyiiñ, gad ñi niy. Cyu ziꞌl mbecy nu ryub, gyad yuñ. Nunu cyu ziꞌl mbecy nu rnii num, shaal mi roꞌ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Walab gaal grusu tub mbecy lat der nu cuic yu tub gyitaꞌ ni iꞌñ yu ornu rgyiiñ yu tub gyishtily loy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O walab gaal cuic yu tub bily ni iꞌñ yu ornu rgyiiñ yu tub bel loy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Gunca de ru nac der mbecy a̱ꞌ nap rad lagy der lac mod rbic ru coz nap ni iꞌñ ru, zeꞌ yegar Ñgyoozh, uz den, biñ nu zub gyibaa wabicy mi coz nap ni de yu nu rgyiiñ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ndeꞌ nu i mod bicy der: Gal mod nu rlagy ub der nu gyicy nu mbecy ru, orzeꞌ niꞌ ziꞌl mod bicy nu der dey. Gun ndeꞌ mod nu yaruu leey nu bzeeñ Moisees nu de riidz nu bzeeñ de yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Guꞌ der gyeroꞌ nu shii. Gun roꞌ nu gash de mbecy nez nu gyay par gabily, ndeꞌ tub roꞌ she nunu ndeꞌ tub nez zu. Nunu zigy dey gash yu nez zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tees roꞌ nu gash mbecy nez nu gyay zeꞌ nu cui mbañ yu, ndeꞌ tub roꞌ shii nunu tub nez las. Nunu ñuu zi dey gyap yuñ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Bzu der cuidad nu de mbecy rguu, de yu nu ricy nu rnii por cuen ni Ñgyoozh. De yu zeꞌ ruꞌña dey lat der. Rlyu nu na dey gal nu na tub shily mazh. Tees nañ lardoo dey nañ gal nu na tub lob dañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","De ru gac gyuꞌ lo der dey nu nac de coz nu ricy yu. Gun tub ya gyech wac cuic ñi urbyay. Niꞌ tub ya gyech wac cuic ñi urlas mni. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tees tub yag benu nap nañ, orzeꞌ rbic ñi uugy nap. Zeꞌ tuubaꞌ yag a̱ꞌ nap na, ndeꞌ rbic ñi uugy wacyiiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yag nu nap na zeꞌ rila wac cuic ñi uugy nu wacyiiñ. Zeꞌ yag a̱ꞌ nap na zeꞌ, rila wac cuic ñi uugy nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dela yag nu wacuic uugy nap gyiꞌñ ñi, nunu chañ lo gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndeꞌ nu de ru gyuꞌ lo der de mbecy rguu zeꞌ nu nac mod nu ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Walab dela mbecy nu nii lo̱: “Shuaana̱, Shuaana̱”, rniiy, walab dela de yu zeꞌ gzac dey lo gyel gubier ni Ñgyoozh, sinu tub zi la de yu nu ricy ziꞌl coz nu rlagy Ñgyoozh, uz den, biñ nu zub gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ornu shuub dzi nu ri bee Ñgyoozh ni dela mbecy, orzeꞌ zigy mbecy niiy lo̱: “Shuaana̱, Shuaana̱, de̱ ya̱ pshaal de̱ riidz ni Ñgyoozh nu nac rishbeey nir. Nunu nu nac rishbeey nir bloo chu̱ de̱ zañ nuras. Nunu nu nac rishbeey nir bicy de̱ zañ nusuriidz”, gnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tees ya̱ gne̱e̱ lo dey: “Rila a̱ꞌ yuꞌ lo̱ de ru. Bruu chu der lo̱ ii, de ru mbecy shiñ ricy”, gne̱e̱ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Orzeꞌ na, dela de mbecy nu rzuub gyidag de riidz nu rne̱e̱ nunu ricy yu gal nu rne̱e̱, de yu zeꞌ nac yu mbecy nu yuꞌ shcab ni. Nay gal nu na tub mbecy nu bzaa tub yuꞌ. Gush yu semient niñ nu gyitaꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Orzeꞌ bet gyey. Nunu bri nis yu. Nunu bded tub gyey bi ily. Nunu bdugyiñ ich yuꞌ zeꞌ tees wangyet lag ñi, gun lo gyitaꞌ zub ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tees dela de yu nu rzuub gyidag de riidz nu rne̱e̱, zeꞌ wagyicy yu gal nu rne̱e̱, de yu zeꞌ nay gal nu na tub mbecy nu sac shcab ni nu bzaay yuꞌy lo yu uzh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Orzeꞌ bet gyey. Nunu bri nis yu. Nunu bded tub gyey bi ily. Bdugyiñ ich yuꞌ zeꞌ. Orzeꞌ bduꞌ chuꞌñ yuꞌ zeꞌ. Nunu coz ily guc ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ornu blazh mnii Jesuuz de coz zeꞌ, orzeꞌ de mbecy tonaꞌ la za nu ic dey nu nac de coz nu blyuum ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gun blyuum ni dey gal nu rlyuu tub mbecy nu ricy cup rishbeey, walab gal nu na coz nu rlyuu de mbecy nu rlyuu leey ni Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ornu Jesuuz bet mi nu bruum logyiꞌ, orzeꞌ tonaꞌ la mbecy zigy gua ca dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Orzeꞌ bruꞌña tub mbecy nu taꞌ gyedz nu la lepra lom. Orzeꞌ gusu tib yu lom. Orzeꞌ nay rab yum: ―Jesuuz, benu rlagy ru, orzeꞌ gac gyicy yac ru ya̱ ni güii ne̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Orzeꞌ Jesuuz gul yaam yu. Orzeꞌ nam rab mi yu: ―Rlagya̱. Na byac ru ―nam rab mi yu. Orzeꞌ lueg la byac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Orzeꞌ na gaꞌ Jesuuz rab mi yu: ―Na ne̱e̱ lor nu cueꞌ la niir lo ni tub la mbecy, sinu gua lo uz nu cha lyuur ub ru loy. Orzeꞌ cuic ru gun nir nu rniiñ lo leey ni Moisees par nu gad lagy dela mbecy nu bi byac ru ni güii nir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ornu Jesuuz guꞌm ruꞌ gyedz Capernaum, orzeꞌ bruꞌña tub yu nu riib ic tub gaynal soldad lom. Orzeꞌ bdiiñ yu tub faboor lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Orzeꞌ nay: ―Jesuuz, ya̱ zu tub moz ne̱ yu̱ꞌ mbish rat yu. Na byac yu mbecy chi̱ nunu dzi rzac yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Orzeꞌ Jesuuz nam rab mi yu: ―Ya̱ cha̱ nu gyicy yaca̱ yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Orzeꞌ na gaꞌ yu nu riib ic zeꞌ: ―Rila wangyapa̱ nu char yu̱ꞌ, nomaas benu nii ziꞌl ru nu gyac moz ne̱, orzeꞌ gyac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gun niꞌ ya̱ ricya̱ de coz nu rnii de yu nu gya zir zu par ya̱. Nunu niꞌ yuꞌ gaꞌ soldad nu gash zir zu par ya̱ nu ricy yu de coz nu rne̱e̱. Ornu rne̱e̱ lo tub yu nu “Char re”, ne̱e̱, orzeꞌ rzay. Zeꞌ tuubay, ornu dredza̱ yu nu cyid yu, orzeꞌ ryiid yu. Nunu ornu rca̱a̱ moz ne̱ nu gyicy yu la coz, orzeꞌ ricy yuñ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ornu güeñ Jesuuz de riidz zeꞌ, orzeꞌ tonaꞌ la za nu ic mi. Orzeꞌ nam rab mi de yu nu za ca ich mi: ―Ya̱ rishli rne̱e̱ lo der nu lat de mbecy Israeel rila nigul gyapa̱ ni tub la mbecy nu ricy cup consuel lo̱ gal nu na consuel nu ricy cup yu ii ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya̱ rne̱e̱ lo der nu dub yub la gyishlombecy gruu mbecy nu gzub dey goy gyit tublaazh la nu Abraham, nu Isaac gal nu Jacob lugaar zeꞌ nu riib ic Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tees de yu nu rlyu nu gya cyiiñ lo Ñgyoozh, de yu zeꞌ duneꞌ dey zeꞌ nu cow, zeꞌ nu chuꞌ mbecy nu gun yu nunu nu siigy lay yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Orzeꞌ Jesuuz nam rab mi yu nu riib ic zeꞌ: ―Yaa la yuꞌr, gun gac ñii gal nu ru mnii toor ―nam. Orzeꞌ laab or la zeꞌ byac moz ni yu nu riib ic zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Orzeꞌ Jesuuz guam yuꞌ Bed. Orzeꞌ zeꞌ bzaac mi ñaa gud yu riib rat mi. Pcaañ zig nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Orzeꞌ Jesuuz bduꞌ yaam yaa biñ rat zeꞌ. Orzeꞌ lueg la bruu zig mi. Orzeꞌ wesh tem brugyiꞌ rzu bich mi nu nac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na ornu bi yecheñ, orzeꞌ de mbecy bruꞌña nu dey zigy mbecy nu bicy ni nuras lo Jesuuz. Orzeꞌ bloo chum de nuras zeꞌ nu tub zi riidz nim. Nunu bicy yac mi zañ de mbecy rat. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ni guuc ñi par nu gyuꞌ ni de riidz nu pcaa Isaías, tub yu nu mnii por cuen ni Ñgyoozh ornu bzat yu Mesías ornu mniiy: “Mi zeꞌ co chum de güii gyidz nu yuꞌ nañ cuerp nin, nunu gyicy yac mi de ub na ni de güii.” Ni pcaa Isaías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ornu bzaac Jesuuz nu dzi bdeꞌ mbecy lom, orzeꞌ mniim lo de yu rsyaꞌ lom nu cha dey tub laꞌ gaꞌ ruꞌ nisyudoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Orzeꞌ bruꞌña tub yu nu rlyuu leey ni Ñgyoozh. Orzeꞌ nay: ―Masht, ya̱ bi zu lilya̱ nu cha du̱ ru ca ziꞌl zeꞌ nu char ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Orzeꞌ na Jesuuz rab mi yu: ―De bez ricy cup ma blyuu ni ma. Zeꞌ de chigyiñ ricy cup ma teez ma. Tees ya̱, biñ nu byac mbecy, a̱ꞌ ricy cupa̱ ni tub lugaar miꞌ par nu gabisha̱ zu lagya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Orzeꞌ bruꞌña tuubaꞌ yu nu rsyaꞌ lom. Orzeꞌ nay rab yum: ―Jesuuz, ¿a wazaan ru nu leza̱ gashtal gat uza̱? Orzeꞌ cacha̱ yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Orzeꞌ na Jesuuz rab mi yu: ―Na la da ca icha̱. Bzaan ndeꞌ par de mbecy nu na gal na mbecy gut nu cach dey losaꞌ gut yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Orzeꞌ Jesuuz guꞌm nañ barc nu de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Orzeꞌ lat nu za dey zeꞌ, sij la bruꞌña tub gyey bi ily lo nisyudoo, nunu tonaꞌ la coz ily bicy gyey bi zeꞌ. Orzeꞌ de nguuly lo nisyudoo psoow lañ barc. Zeꞌ Jesuuz mbish mi nas mi nañ barc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Orzeꞌ de yu nu rsyaꞌ lom pcueeñ dey mi. Orzeꞌ na dey rab yum: ―¡Shuaan de̱, bloo mbañ den! Gun bi rnit lo den lo nis ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Orzeꞌ Jesuuz nam rab mi dey: ―¿Lagu dzi rdzib der? ¡Dzi ga ñuu miꞌ consuel ricy cup der lo̱! ―nam. Orzeꞌ wesh tem mniim lo bi nu lo nisyudoo nu gariñ. Orzeꞌ rup laañ gucañ. Se ri zu la byac. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Orzeꞌ za nu la ic dey. Orzeꞌ na dey rab yu losaꞌy: ―¿Zeꞌ cyuꞌ mbecy nac mi ii? Gashtal bi nu nisyudoo rzuub gyidag ñi nim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ornu Jesuuz bruꞌñam tub laꞌ gaꞌ ruꞌ nisyudoo, orzeꞌ bruum nañ barc par lo yu ni Gadara. Orzeꞌ bruꞌña cyup mbecy nu bruu nañ de blyuu nu rcach dey añ lom. De yu zeꞌ yu nu bicy ni nuras. Nunu raloc dey. Ni tub la mbecy wagac ded dey nez nu rded cyup de yu zeꞌ par nu dzi tañ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Orzeꞌ brugyiꞌ rbish ti dey: ―¿La ryub ru yad ru lo̱ ii Jesuuz iꞌñ Ñgyoozh? ¿A yad ru nu ted zir de̱ ya̱ anzir nu shuub tiem? ―na nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na sñuu miiñ par lo rded row tub nac cuch zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Orzeꞌ de nuras mnishbaa dey lo Jesuuz. Orzeꞌ na dey: ―Zeꞌ benu co chur de̱ ya̱, bzaan nu chuꞌ de̱ nañ de cuch re ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Orzeꞌ Jesuuz nam rab mi dey: ―Gua der ―nam. Orzeꞌ de nuras zeꞌ gua dey guꞌy nañ de cuch zigy zeꞌ. Laab or la zeꞌ dela de cuch zigy zeꞌ rzab la de ma carer bzu tiily ma par gyoow. Orzeꞌ bet lag de ma lo nisyudoo. Orzeꞌ gut de ma lo nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Orzeꞌ de yu nu rña de cuch zeꞌ gush dey carer yay par lat gyedz. Orzeꞌ brugyiꞌ ryoo dey riidz de coz nu guc nu de mbecy nu bicy ni nuras zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Orzeꞌ dela de mbecy nu yuꞌ gyedz zeꞌ bruu dey zay lo Jesuuz. Na ornu bzaac dey mi, orzeꞌ mnishbaa dey lom nu gruum ledz dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Orzeꞌ Jesuuz guꞌm nañ tub barc zam tub laꞌ gaꞌ ruꞌ nisyudoo. Orzeꞌ brim gyedz nu rcyiiñ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Orzeꞌ bruꞌña nu dey tub mbecy chi̱ lom. Riib yu lo nuun. Na ornu Jesuuz gud lagy mi nu dzi ricy cup dey consuel lom, orzeꞌ nam rab mi yu rat zeꞌ: ―Yu feñ, cueꞌ dzi gyicy shnir. Briic baloor. Ya̱ bi ricy sulagya̱ de cyir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Laab zeꞌ nguaa la be de yu nu rlyuu leey ni Ñgyoozh. Orzeꞌ na dey nañ lardooy: “Coz nu yu ii mniiy, ndeꞌ zañ contr ni Ñgyoozh”, rnii dey nañ lardooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tees Jesuuz gud lagy mi de coz nu mnii dey nañ lardooy. Orzeꞌ nam rab mi dey. ―¿Lagu dzi shiñ rnii too der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dzi zir a̱ꞌ biigy par nu ne̱e̱ nu bi ricy sulagya̱ de cyir gazeꞌ nu ne̱e̱ nu wes su nunu bza. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tees na lyu̱u̱ lo der nu ya̱, biñ nu byac mbecy, ricy cupa̱ rishbeey nu gyicy sulagya̱ de cyi de mbecy gyishlombecy ii ―nam. Orzeꞌ Jesuuz nam rab mi mbecy chi̱ zeꞌ: ―Weshte. Gush nuun nir yaa yuꞌr ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Orzeꞌ mbecy chi̱ zeꞌ weshtey nunu yay par yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ornu de mbecy bzaac dey ndeꞌ, orzeꞌ gudzib dey, nunu byabic dey gyel mbecy ni Ñgyoozh. Byabic dey gyel mbecy nim gun briic mi rishbeey ni mbecy nu gyicy yu coz ily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Orzeꞌ Jesuuz bruum lugaar zeꞌ zam. Na nez nu zam bzaac mi ya̱, tub mbecy nu la Mateo zuba̱ rlo̱o̱ tiñ tub lugaar zeꞌ nu rboo dey tiñ por cuen ni gubier Rom. Gazeꞌ nu nam rab mi ya̱: ―Da ca icha̱ ―nam. Orzeꞌ wes su̱ za ca̱ ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na despuees, ornu Jesuuz bruꞌñam yu̱ꞌ, lat nu zub mi row mi gyit, orzeꞌ bruꞌña zigy de mbecy nu rboo tiñ por cuen ni gubier Rom, nu zigy de mbecy bduneꞌ bruꞌña dey. Orzeꞌ gusub dey nuy mi tublaazh la lo tub ziꞌl mez. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na ornu bzaac de mbecy fariseo, orzeꞌ bdugyiꞌ dey lo de yu nu rsyaꞌ lom: ―¿Lagu moscuel ni de ru row yu gyit tublaazh nu de mbecy nu rboo tiñ por cuen ni gubier gal nu de mbecy bduneꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na ornu güeñ Jesuuz ndeꞌ, orzeꞌ nam rab mi dey: ―Par de mbecy ruub walagy ñi doctoor tees par de mbecy rat rlagy ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gua der. Gash ñuur shcab ben lac yaruu riidz ni Ñgyoozh zeꞌ nu rniiñ: “Ñgyoozh nam: Ya̱ rlagya̱ nu gashni lagy der losaꞌr. Walagya̱ nu cuic der gun bañcyug lo̱, nam.” Ni rniiñ gun niꞌ ya̱ a̱ꞌ yapa̱ nu redza̱ de mbecy nu sac cyi, sinu dredza̱ de mbecy cyi par nu neꞌ dey cyiy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na de yu nu rsyaꞌ lo Waa nu briib nis mbecy bruꞌña dey lo Jesuuz. Orzeꞌ na dey rab yum: ―De̱ ya̱ gal nu de mbecy fariseo rca̱ de̱ ni uba̱ nu cueꞌ da̱w de̱ gyit lat nu rzu bich de̱ nu nac Ñgyoozh. ¿Lagu de yu nu rsyaꞌ lor wagyicy dey ndeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Orzeꞌ na Jesuuz nam rab mi dey: ―Ya̱ na gal nu na tub nob. ¿Walab gaal gac gyicy shni de mbecy nu yuꞌ lo fandang lat nu gabee rded nob lat dey? Tees shuub dzi nu co mbecy nob zeꞌ lat dey. Orzeꞌ gazeꞌ nu gac ca dey ni ub yu nu cueꞌ goy gyit par nu gyicy shni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Gun mod nu bicy de gyitoo bel, ndeꞌ nañ gal nu na tub negy gush. Ni tub la mbecy wayicy mi rumien negy gush nu tub laꞌ negy cub nu nigul gyoꞌ nis, gun nis gash beñ negy cub zeꞌ. Orzeꞌ shaa ye zir negy gush zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nunu mod nu bicy de gyitoo bel, ndeꞌ nañ gal nu na tub gyid gush nu rguꞌ choow dey ñup ni urbyay. Ni tub la mbecy wac cuꞌ choow yu ñup urbyay cub nañ gyid gush gun nis cyich ñiñ. Orzeꞌ shu dela ñup urbyay zeꞌ. Orzeꞌ nit lo gyid zeꞌ. Ndeꞌ nu rlagy ñi cuꞌ choow dey ñup urbyay cub nañ gyid cub, gun orzeꞌ rup laañ zu nap ñi ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lat nu Jesuuz gabee zum rniim de riidz zeꞌ, orzeꞌ bruꞌña tub yu nu riib ic lat de mbecy Israeel. Orzeꞌ gusu tib yu lom. Orzeꞌ nay rab yum: ―Iꞌña̱ saa la gut ñi. Tees benu ru char gal yaar ñii, orzeꞌ gyabañ ñi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Orzeꞌ wes su Jesuuz nu za num yu. Nunu de yu nu rsyaꞌ lom za nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na zu tub biñ mñaa. Bi bzaꞌ trocyup ñaꞌn nu rat mi nu rshu reñ mi. Orzeꞌ bechaꞌm par ich Jesuuz. Gazeꞌ nu gul yaam ruꞌ shab mi, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","gun mnii toom nu mas ñuu shab Jesuuz gal yaam, orzeꞌ gyac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Orzeꞌ Jesuuz bish cyam bgüiim lo biñ mñaa zeꞌ. Orzeꞌ nam rab mim: ―Cueꞌ dzib ru biñ mñaa. Nu nac nu bicy cup ru consuel lo̱, ndeꞌ nu byac ru ―nam. Orzeꞌ lueg la byac biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na ornu bruꞌña Jesuuz yuꞌ mbecy nu riib ic zeꞌ, orzeꞌ guꞌm nañ yuꞌ. Orzeꞌ bzaac mi nu bi nguaa de musiic, nunu bzaac mi nu dzi deet nguaa de mbecy nu ricy shni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Orzeꞌ nam: ―Bruu chu der ii, gun fiñ guzh ii nu nas ziꞌl ñi walab nu guut ñi ―nam. Orzeꞌ de mbecy brugyiꞌ rigy nu naañ dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cuanzir nu bruu de mbecy ich yuꞌ zeꞌ, orzeꞌ Jesuuz guꞌm nañ yuꞌ. Gazeꞌ nu bduꞌ yaam yaa fiñ guzh gut zeꞌ. Orzeꞌ wesh teñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Orzeꞌ bzu laa riidz ni de coz nu guc zeꞌ dutuub la de lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ornu Jesuuz bruum lugaar zeꞌ zam, orzeꞌ cyup mbecy lo caꞌ za cay ich mi. Orzeꞌ brugyiꞌ rbish ti dey: ―Gushni ñuu lagy de̱ ya̱, Jesuuz, nez rey Dabi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ornu Jesuuz guꞌm nañ yuꞌ, orzeꞌ de yu lo caꞌ zeꞌ bechaꞌ dey lom. Orzeꞌ bdugyiꞌm lo dey: ―¿A rzeña lagy der nu gac gyicya̱ nu ndeꞌ? ―nam. Orzeꞌ na dey: ―Rzeña lagy de̱ Jesuuz ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Orzeꞌ Jesuuz gul yaam urlo dey. Orzeꞌ nam rab mi dey: ―Gac ñii gal nu rzeña lagy der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Orzeꞌ byanap urlo dey. Orzeꞌ Jesuuz fert bduꞌm riiñ yaa dey. Orzeꞌ nam rab mi dey: ―Cueꞌ nii der lo ni tub la mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tees, laab or bruu dey lom, orzeꞌ brugyiꞌ rtush las dey riidz dutuub la lugaar zeꞌ, de coz nu bicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lat nu bruu de mbecy nu guc lo caꞌ zeꞌ lom, orzeꞌ bruꞌña la be mbecy nuy tub mbecy nu byagop lom. Byagop yu nu bicy ni nuras yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Orzeꞌ cuanzir nu bloo chum nuras zeꞌ, orzeꞌ gop zeꞌ brugyiꞌ rniiy. Orzeꞌ tonaꞌ la za nu ic de mbecy. Orzeꞌ na dey: ―Rila a̱ꞌ zac den coz nu na gal nu na nii lo de yu ni de mbecy Israeel ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tees de mbecy fariseo na dey: ―Yu nu riib ic de nuras briic yu rishbeey ni yu ii par nu co chuy deꞌ zir nuras ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesuuz gusam dela lat gyedz nu dela ranch. Tub ga la gyedz nu rded mi rlyuum ni de mbecy nañ yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Pshaal mi de riidz nu sac ni gyel gubier ni Ñgyoozh, nunu bicy yac mi mbecy ni de lo la güii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ornu bzaac mi de mbecy zigy, orzeꞌ tonaꞌ la gushni lagy mi dey, gun shni yuꞌ dey, nunu rshiꞌñ dey baloor. Na dey gal nu na shily nu sac cyu nu rña. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ―Rishli gaal cosech tonaꞌ la sheñ ñi, tees de yu nu ricy riiñ, ñuu zi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndeꞌ nu, bdiiñ der lo Shuaan cosech zeꞌ nu gzeed zir mi mbecy nu teꞌ de cosech zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Orzeꞌ Jesuuz bredz mi zaꞌ trocyup laa yu nu rsyaꞌ lom. Orzeꞌ briic mi rishbeey ni dey par nu co chu dey de nuras, nunu briic mi rishbeey nu gyicy yac dey mbecy nu rat de lo la güii, nu dela coz shni nu rzac de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Orzeꞌ nii nu la de trocyup Aposht. Gush lañ yu loga la, ndeꞌ Simo̱o̱, yu nu rnii dey Bed, nu bicy yu Ndrees, nu Santiag nu bicy yu Waa, de yu zeꞌ iꞌñ Zebedeo, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Lip nu Bartol, nu Tomaas nu ya̱, Mateo, tub mbecy nu pteꞌ tiñ por cuen ni gubier Rom, nu Santiag, iꞌñ Alfeo, nu Tadeo, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nu Simo̱o̱, yu nu nac partid nu la Celote, nu Judas Iscariote, yu nu bish cya ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Orzeꞌ Jesuuz bzuu nez mi de trocyup Aposht. Orzeꞌ bduꞌm riiñ yaa dey. Orzeꞌ nam: ―Cueꞌ cha der lat de mbecy nu walab mbecy Israeel, nunu ni cueꞌ cha der de zeꞌ nu yuꞌ mbecy Samaria. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nap zir gua der lat de mbecy Israeel, de yu nu na gal nu na shily bduneꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gua der lo dey, nunu mnii der nu sñuu ga ri gyel gubier ni Ñgyoozh lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bicy yac der de mbecy rat, nunu bicy der nu gyabañ de mbecy gut, nunu bicy der nu gyacaacy de mbecy gubag nu nac gyedz nu la lepra, nunu co chu der de nuras. Ya̱ leew la grica̱ mod zeꞌ ni der nu gac gyicy ru de coz zeꞌ. Ndeꞌ nu cueꞌ co der ir ornu gyicy der de ndeꞌ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Cueꞌ cha nu der tiñ or, ni tiñ plat, ni tiñ corient. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni cueꞌ cha nu der moraal par nu rir coz nu gow der nez. Ni cueꞌ cha nu der cyup shab ru. Nomaas nu zu ziꞌl der zeꞌ gua nu. Nunu cueꞌ cha nu der cyup nez gyid lab ru. Ni cueꞌ cha nu der cyup yangar. Gun mbecy nu ricy riiñ yad ñi nu cuic dey coz nu gow yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ornu gri der tub gyedz o tub ranch, orzeꞌ yub der tub mbecy nap, nu cyiiñ der loy gashtal gruu la der lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ornu chuꞌ der nañ yuꞌ zeꞌ, ornu nii nu der yu ñgyoozh, orzeꞌ nii der nu Ñgyoozh gac num dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Benu mbecy guyuꞌ zeꞌ nac yu mbecy nap, orzeꞌ gac ñii gal nu mnii der. Tees benu a̱ꞌ nap yu, orzeꞌ wac ñi gal nu mnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Benu mbecy washet ic dey nu chuꞌr tub yuꞌ o tub gyedz, ni wazuub gyidag dey ni der, orzeꞌ gruu der lugaar zeꞌ nunu cyib der yu gyedz ni gyid lab ru par nu gabe nu a̱ꞌ nap bicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya̱ rishli rne̱e̱ lo der nu ornu shuub dzi nu gri bee Ñgyoozh ni de mbecy nu yuꞌ gyedz zeꞌ, cashtig ily zir cuic mi ni dey gazeꞌ cashtig nu cuic mi ni de mbecy nu guꞌ gyedz nu la Sodoma nu Gomorra ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Güii der na. Ya̱ zu neza̱ der char. Nunu na der gal nu na shily nu cha lat lob. Guc der mbecy nu dzach zu gal nu zu bily, tees guc der mbecy gugy na gal nu na begy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bzu der cuidad gun yuꞌ de mbecy nu guꞌy der yaa de fushtiz nunu yuꞌ gaꞌ mbecy nu gaaz dey de ru nañ yuꞌ nu rsyaꞌ den riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gashtal lo gubier nu lo de rey cha nu dey de ru nu nac ya̱, gun orzeꞌ gac zat der ya̱ lo dey gal nu lo de mbecy nu walab mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tees ornu guꞌ dey de ru yaa de fushtiz, cueꞌ sug ic der la na riidz nu niir nunu cueꞌ sug ic der nu lac na riidz nu gniir, gun ornu shuub tiem nu galagy ñi nu gnii der, orzeꞌ Ñgyoozh cuic mi riidz nu gniir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gun riidz nu de ru gniir, ndeꞌ walab riidz ni ru ziꞌl, sinu ndeꞌ riidz ni Espiriit Yon ni Ñgyoozh uz den. Orzeꞌ de ru gniir riidz nu druu lo mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Tees yuꞌ mbecy nu guꞌ dey bicy yu yaa de mbecy nu rzi lagy par nu cut dey yu. Nunu yuꞌ gaꞌ mbecy nu ni ziꞌl gyicy nu dey iꞌñ yu. Zeꞌ yu gaꞌ dey cush cyay ich uz yu gun orzeꞌ cut mbecy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dela de mbecy gazi lagy dey lo der par nu nac ya̱. Tees yu nu gagye gashtal gat la, yu zeꞌ gruu mbañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nunu ornu rted zi dey de ru tub gyedz, orzeꞌ cha der tuubaꞌ gyedz. Tees ya̱ rishli rne̱e̱ lo der nu walazh chesa der de gyedz ni de mbecy Israeel anzir nu yapa̱ tuubaꞌ tir, ya̱, biñ nu byac mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Sac ni tub yu nguzh scuel nu zily zir nac yu par moscuel niy. Nunu sac ni tub moz nu zily zir nac yu par patro̱o̱ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Beñ benu tub yu nguzh scuel gyac yu gal nu na moscuel niy. Nunu niꞌ ziꞌl beñ benu tub moz gyac yu gal nu na patro̱o̱ niy. Benu nii mbecy nu ya̱, tub mbecy nu riib ic nañ tub yuꞌ, naca̱ tub nuras nu la Beelzebé, orzeꞌ dzi zir rnii dey ni de ru, mbecy nu nac famil ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ndeꞌ nu cueꞌ dzib der lo de mbecy. Gun sac ni tub coz ngach nu waruu zac ñi. Nunu dela coz nu wagad lagy mbecy, ndeꞌ gad lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","De coz nu rne̱e̱ lo der ngach, ndeꞌ co zac der ñii lat dela mbecy. Nunu de coz nu rne̱e̱ lo der dze ga, ndeꞌ ye la nii der lo de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cueꞌ dzib der lo de mbecy nu rut cuerp ni losaꞌ, tees wac cut dey lardoo losaꞌy. Nap zir gudzib der lo Ñgyoozh biñ nu gac nit lo cuerp ni mbecy nu lardooy gabily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿A walab nu rut dey cyup chigyiñ miꞌ par tub sentab miꞌ? Tees ni tub ma wayet lag ma lo yu benu Ñgyoozh uz der wazaan mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Zeꞌ yegar de ru, Ñgyoozh rad lagy mi la be gyich too der. Delañ ngab ñi nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ndeꞌ nu cue dzib der, gun de ru dzi zir sac der gazeꞌ de chigyiñ zigy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Cyu ziꞌl mbecy nu gnii lo losaꞌ nu ya̱ naca̱ Shuaan yu, niꞌ ziꞌl ne̱e̱ ya̱ lo Ñgyoozh uza̱ nu zub gyibaa nu nac yu ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tees cyu ziꞌl mbecy nu nii nu a̱ꞌ naca̱ Shuaan yu lo de mbecy, orzeꞌ niꞌ ziꞌl gyicya̱ du̱ yu lo Ñgyoozh, uza̱, biñ nu zub gyibaa. Ne̱e̱ nu a̱ꞌ nac yu ne̱ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Cueꞌ nii too der nu ya̱ yapa̱ nu gyicya̱ nu nap chuꞌ mbecy nu losaꞌy. Walab nu gyicya̱ nu nap chuꞌ dey, sinu nu chucoo dey nu losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya̱ yapa̱ nu gyicya̱ nu de yu gyeey chay contr ni uz yu. Zeꞌ fiñ mñaa chañ contr ni ñaañ. Tub fiñ mñaa chañ contr ni ñaa gud ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","De yu nu gac losaꞌ yuu dey gruuy laab lat famil ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Mbecy nu rca zir uz, o yu nu rca zir ñaa gazeꞌ ya̱, yu zeꞌ rila wangyap yu nu gac yu ne̱. Yu nu rca zir iꞌñ gyeey o iꞌñ yu fiñ mñaa gazeꞌ ya̱, yu zeꞌ niꞌ ziꞌl wangyap yu nu gac yu ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cyu ziꞌl mbecy nu washet ic nu gzac zi nu nac ya̱, yu zeꞌ niꞌ ziꞌl wangyap yu nu gac yu ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yu nu rlagy co nap ub gyishlombecy ii yu zeꞌ wad nu cui mbañ yu. Zeꞌ yu nu shet ic nu zac zi, nunu mas gat yu nu nac ya̱, yu zeꞌ gruu mbañ yu ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Cyu ziꞌl mbecy nu nap nii nu de ru, niꞌ ziꞌl nap nii nuy ya̱ nunu niꞌ nap nii nuy biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Cyu ziꞌl mbecy nu nap nii nu de yu nu mnii por cuen ni Ñgyoozh nu nac nu chay loy por cuen nim, orzeꞌ laabaꞌ i yu nu rnii por cuen ni Ñgyoozh zeꞌ gyad niy. Cyu ziꞌl mbecy nu nap nii nu tub mbecy nap, yu zeꞌ laaba i mbecy nap zeꞌ gyad niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cyu ziꞌl mbecy nu cuic mas ñuu tub taz nis rag goꞌ yu nu blaazhaꞌ zir mbecy shni, yu nu yad ca icha̱, yu zeꞌ segur la gyad iy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Na ornu blazh bduꞌ Jesuuz riiñ yaa de yu nu rsyaꞌ lom, orzeꞌ bruum zam. Za lyuum nunu za shaal mi de riidz nu druu lo Ñgyoozh lo de mbecy nu yuꞌ de gyedz gaab ga ni de lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Waa nu briib nis mbecy bet lag yu pres. Na ornu güeñ yu de coz nu ricy Crisht na, orzeꞌ bzuu nez yu la be de yu nu rsyaꞌ loy nu cha tugyiꞌ dey lom, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ben a laab mi biñ nu ca lo cuen nu cyid, o ti cuez dey nu cyid reñaꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na ornu gua dey bdugyiꞌy lo Jesuuz, orzeꞌ nam rab mi dey: ―Yaa nii der lo Waa de coz nu rzac der gal nu de coz nu reñ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yaa nii der loy nu de lo caꞌ bi rzac dey; de mbecy coj rac rza nap la dey; de mbecy nu rat nu taꞌ gyedz nu la lepra byac dey; de go̱ꞌ bi reñ dey; de yu nu bi gut byabañ yu tuubaꞌ tir; nunu rdunii de riidz nu sac ni Ñgyoozh lo de mbecy zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dzi ni de mbecy nu wayeca nu ricy cup consuel lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na ornu bi ya de yu zeꞌ, orzeꞌ Jesuuz bzat mi Waa lo de mbecy zigy. Orzeꞌ nam: ―Ornu gua der gua güiir Waa tub lugaar ub zi, ¿la nay guzii der? ¿Uti a guzii der nu nac yu mbecy nu ricy cyup ic gal nu na tub yagyi nu rguul bi par re par ii guzii der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Zeꞌ benu walab, orzeꞌ ¿la na tub mbecy nu gua güii der? ¿A gua güii der tub mbecy nu zu tub negy cyit na? Walab ni, gun rad lagy der nu yu nu zu negy cyit na, yu zeꞌ rcyiiñ yu yuꞌ rey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Orzeꞌ la gaal na tub mbecy gua güii der? ¿A gua güii der tub yu nu rnii por cuen ni Ñgyoozh? Laab, nunu ya̱ rne̱e̱ lo der nu zily zir nac Waa gazeꞌ de yu nu mnii por cuen nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gun laab Waa rzat riidz ni Ñgyoozh zeꞌ nu rniiñ: Ñgyoozh nam rab mi biñ nu ca lo cuen nu co mbañ mbecy: “Ya̱ zuu neza̱ yu nu nii por cuen ne̱ nu cha gay lor, gun orzeꞌ zu lily yu nez nu char”, nam. Ni rnii riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Gun ya̱ rishli rne̱e̱ lo der nu ni tub la mbecy nu pcyiiñ gyishlombecy ii a̱ꞌ zily zir nac yu gazeꞌ Waa nu briib nis mbecy par lo Ñgyoozh. Tees yu nu gash zir zu lat de yu nu gyub ic Ñgyoozh, yu zeꞌ gya zir zuy par Waa nu briib nis mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Gun nese tiem nu Waa brugyiꞌy nu rshaal yu riidz ni Ñgyoozh, nunu gashtal dzi na, za rii la rdeꞌ mbecy lo de yu nu riib ic Ñgyoozh. Nunu fert la pshet yaa dey yu ben a wazaꞌ lo dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gun dela riidz nu mnii de yu nu mnii por cuen ni Ñgyoozh nu de leey nu bzeeñ Moisees bzat ñi gyel gubier nim gal pshuub la dzi nu bri Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ndeꞌ nu ne̱e̱ lo der ben a wayeña lagy der nu Waa nac yu Elías, yu nu ca lo cuen nu cyid. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Benu ca na der zub gyidag ru, orzeꞌ bicy der nu gyet lag ru cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Na, ¿la ñuu tub coz nu saapa̱ de mbecy nu yuꞌ tiem na? Na dey gal nu na de yu nguzh nu nguaa rgyit lat yagyiꞌ. Lat nu rtub su losaꞌ dey, orzeꞌ ye ga la rbish ti dey nguaay, orzeꞌ na dey rab yu losaꞌy: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bla̱a̱ de̱ di gyel cyit nu bdzi, tees wangul gyiꞌ der. Na ornu bdul ru̱ꞌ de̱ tub di nu shni za, ni wanguun der”, rnii dey nguaay. Gun de mbecy nu yuꞌ tiem na wangalagy dey ni tub la mod. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gun Waa biid yu. Wangoow nap yu nunu wangoꞌy ñup. Orzeꞌ rnii dey nu tub nuras riib ic yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Zeꞌ ornu ya̱, biñ nu byac mbecy, bri̱, orzeꞌ ya̱ rda̱w la ziꞌl coz nunu rdo̱ꞌ la ziꞌl ñup. Orzeꞌ rnii dey nu naca̱ mbecy row shaad nunu mbecy roꞌ ñup, nunu naca̱ amig ni de mbecy bduneꞌ nunu naca̱ amig ni de yu nu rboo tiñ por cuen ni gubier Rom. Orzeꞌ ni tub la mod wangyet lagy dey. Tees rabee nu de mod nu psaꞌ lagy Ñgyoozh ndeꞌ mod nap nu nac nu gruu nap ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Orzeꞌ Jesuuz brugyiꞌ rshuu num de mbecy nu yuꞌ gyedz zeꞌ nu bicy zir mi nusuriidz, gun wanneꞌ dey de cyi nu ricy yu. Orzeꞌ nam rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Cuaa de ru mbecy nu yuꞌ gyedz Corazín! Nunu, ¡cuaa de ru mbecy gyedz Betsaida! Gun benu ñgyicya̱ nusuriidz lat de mbecy nu yuꞌ gyedz Tiro nu gyedz Sidón gal nu bicya̱ lat de ru, orzeꞌ bi gulas nneꞌ dey cyiy. Orzeꞌ nzu dey shab cuiñ yu nunu ncoo dey diꞌñ tooy par nu gabe nu ñgyac dey mbecy shni. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tees ya̱ rne̱e̱ lo der nu dzi nu gri bee Ñgyoozh ni de mbecy, cashtig ily zir cuic mi ni de ru gazeꞌ ni de mbecy nu yuꞌ gyedz Tiro nu Sidón. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Zeꞌ de ru mbecy nu yuꞌ gyedz Capernaum, ¿a rlagy der chup ru gal gyibaa? Tees de ru gyet lag der zeꞌ nu blaazhaꞌ zir gyi ni gabily. Gun zeꞌ benu ñgyicya̱ nusuriidz gyedz Sodoma gal nu bicya̱ lat de ru, orzeꞌ gabee ri ruꞌ gyedz zeꞌ na. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tees ya̱ rne̱e̱ lo der nu dzi zir cashtig ily cuic Ñgyoozh ni de ru ornu shuub dzi nu gri beem ni der, gazeꞌ ni de mbecy nu guꞌ Sodoma ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Orzeꞌ tiem zeꞌ Jesuuz nam: ―Ñgyoozh, uz de̱, biñ nu nac Shuaan gyibaa gal nu gyishlombecy ii, ya̱ drica̱ gras nir gun bicy ru nu rad lagy de yu nu na gal nu na mdoo de coz nu pcach ru lo de yu nu rad lagy nu lo de yu nu yet lag cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ni bicy ru gun ndeꞌ coz nu rlagy ub ru ―nam rab mi Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Orzeꞌ nam rab mi de mbecy: ―Ñgyoozh, uza̱, bguꞌm dela coz ya̱a̱, gun ni tub la mbecy wagad lagy dey lac na ya̱, iꞌñ mi sinu tub zi Ñgyoozh, uza̱ rad lagy mi lac na ya̱ nim. Nunu se cyu la rad lagy lac na Ñgyoozh. Sinu tub zi ya̱, iꞌñ mi rad lagya̱ lac nam. Nunu cyu ziꞌl mbecy nu rlagya̱ gac lyuum loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Da der lo̱, de ru mbecy nu na gal nu na mbecy gutsiñ nunu de ru mbecy nu na gal nu na mbecy nu nuu yuu, gun ya̱ grica̱ nu zu lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gush der yug nu grica̱ nir nunu psyaꞌ der lo̱ gun ya̱ pase̱za̱ nunu gugy na̱ nañ lardo̱o̱, gun orzeꞌ gad nu zu lagy der nañ lardoor. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gun yug nu grica̱ ni der ndeꞌ a̱ꞌ fers cha nu der ñii nunu yuu nu grica̱ gu der, ndeꞌ yuu dzach ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na tiem zeꞌ, tub sab, dzi nu rzu lagy mbecy Israeel, Jesuuz bded mi lat tub nac trig. Orzeꞌ de yu nu rsyaꞌ lom briib nu ran dey. Orzeꞌ brugyiꞌ rcyug dey zaꞌ ni trig. Orzeꞌ bdow dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na ornu bzaac de mbecy fariseo, orzeꞌ na dey rab yu Jesuuz: ―Güii de yu nu rsyaꞌ lor. Ricy dey tub coz nu a̱ꞌ yad ñi nu gyicy den sab ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Orzeꞌ nam rab mi dey: ―¿Walab gaal nigul syaꞌ der coz nu bicy Dabi lat nu byan yu nu sac coz nu gow yu? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Orzeꞌ guꞌy nañ yuꞌ ni Ñgyoozh nu de yu nu rded nuy. Nunu bdow dey gyishtily nu bzeeñ mbecy zeꞌ. Ndeꞌ gyishtily nu zu riiñ lo Ñgyoozh. Bdow dey ñi mas a̱ꞌ yad ñi nu ni gyicy dey. Gun gyishtily zeꞌ, de uz ziꞌl gac gow yuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O a niꞌ nigul syaꞌ der leey ni Moisees zeꞌ nu rniiñ nu de uz ricy dey coz nu zañ contr ni leey ni dzi nu rzu lagy mbecy; tees ndeꞌ a walab nu cyi na nu ni ricy dey? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya̱ rne̱e̱ lo der nu lat de ru na zu tub coz nu zily zir nac gazeꞌ yuꞌ nu driib zily den Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","De ru wangyet lag der cuen lac yaruu de riidz ni Ñgyoozh, zeꞌ nu rniiñ: “Ya̱ rlagya̱ nu gashni lagy der losaꞌr. Walagya̱ nu cut ru bañcyug nu cyid gun lo̱, na Ñgyoozh”, rniiñ. Benu ñgyet lag der cuen, orzeꞌ wanii der nu yuꞌ cyi mbecy ornu sac cyiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gun ya̱, biñ nu byac mbecy, riib ica̱ dzi nu rzu lagy mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Orzeꞌ bruu Jesuuz lugaar zeꞌ zam. Orzeꞌ guꞌm nañ tub yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Zeꞌ nañ yuꞌ zeꞌ ri tub mbecy yaa gush beñ. Nunu yuꞌ gaꞌ la be mbecy nu ryub dey tub mod par nu griib dey cyi too Jesuuz. Orzeꞌ na dey rab yum: ―¿A gruu nap ñi par lo leey ni Moisees nu gyicy yac den tub mbecy rat sab, dzi nu rzu lagy mbecy? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―¿A grusu tub der lat ii benu yuꞌ shily ni der, zeꞌ gyet lag tub ma gyeryuu, a waya boo der ma dzi nu rzu lagy mbecy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tees dzi zir sac tub mbecy gazeꞌ tub shily. Ndeꞌ nu nap gruuñ par lo leey zeꞌ nu nap gyicy den sab, dzi nu rzu lagy mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Orzeꞌ nam rab mi mbecy rat zeꞌ: ―Bzaab yaar lo̱ ―nam. Orzeꞌ mbecy rat zeꞌ bzaab yaay lom. Orzeꞌ lueg la byanap ñi gal nu na tuubañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Orzeꞌ de mbecy fariseo bruu chu dey lom. Orzeꞌ brugyiꞌ ro dey riidz nu lac mod gyicy dey par nu cut yum. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na ornu gud lagy Jesuuz nu ni rnii dey, orzeꞌ bruum lugaar zeꞌ zam. Nunu zigy mbecy za ca dey ich mi. Orzeꞌ bicy yac mi dela mbecy rat nu yuꞌ lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nunu pcach mi ruꞌ dey nu cueꞌ nii dey lo de mbecy cyu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ni bicy mi gun par nu gyuꞌ ni de riidz nu pcaa Isaías ornu mniiy: Orzeꞌ Ñgyoozh nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ii zu biñ nu pcui̱ nu gyicy riiñ ne̱. Mi zeꞌ biñ nu rca̱ nunu biñ nu gyedzuꞌ lagya̱. Ya̱ zeeda̱ Espiriit Yon ne̱ nu gac num mi zeꞌ. Orzeꞌ mi zeꞌ cuic mi nu gad lagy dela mbecy ni gyel fushtiz ne̱, gashtal de mbecy nu walab mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mi zeꞌ wo zim riidz nu de mbecy, nunu wabish tim. Nunu waya sam niim lat cay par nu gyeñ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nunu waca chu lom lo ni tub la mbecy shni. Nunu niꞌ ziꞌl washiꞌñ mi baloor shni nu ricy cup dey. Sinu rzu fert mi gashtal zu nap lam gyel fushtiz nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nunu de lo la nez mbecy cyish lo dey lom, na Ñgyoozh, na Isaías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Orzeꞌ bruꞌña nu de mbecy tub gop lom, nunu caꞌ loy. Ni nay par nu bicy ni nuras yu. Orzeꞌ Jesuuz bicy yac mi yu. Orzeꞌ byanap urloy nunu brugyiꞌ rac rniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Orzeꞌ tonaꞌ la za nu ic de mbecy nunu brugyiꞌ rgugyiꞌ dey lo losaꞌy. Orzeꞌ na dey: ―¿A walab gaal yu ii yu nu nac nez Dabi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na ornu güeñ de mbecy fariseo, orzeꞌ na dey: ―Beelzebé, yu nu riib ic de nuras, yu zeꞌ bicy yu nu cyiiñ yu ii nu co chuy deꞌ zir de nuras ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na ornu gud lagy Jesuuz de coz nu rnii too dey, orzeꞌ nam rab mi dey: ―Benu tub nac mbecy dulew dey nu chucooy laab nu losaꞌ ziꞌl yu, orzeꞌ nit lo dey. O benu tub famil o de mbecy nu yuꞌ tub gyedz chucooy laab nu losaꞌ ziꞌl yu, niꞌ ziꞌl wazu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Benu tub nuras co chuy laab nu losaꞌ nuras yu, orzeꞌ gyach dey, nunu wazu laa riiñ nu gyicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","De ru rnii der nu Beelzebé bicy yu nu cyiiñ ya̱ nu loo chu̱ nuras. Zeꞌ benu ni, orzeꞌ ¿cyu briic rishbeey ni de losaꞌr nu ni ricy yu? Ndeꞌ nu de losaꞌr zeꞌ gac lyuu dey lo der nu de ru radza der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tees Espiriit Yon ni Ñgyoozh ricy mi nu ya̱ rac rloo chu̱ nuras, nunu nu nac nu ndeꞌ rabee nu bi bri gyel gubier ni Ñgyoozh lat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Tees rlagy ñi nu gyicy mbecy gan nuras zub lo, gazeꞌ nu gac co chu dey deꞌ zir nuras nu zaab ich. Gal nu ricy nu dey tub mbecy fert. Benu rlagy dey chuꞌy yuꞌy, orzeꞌ nu loga la rlagy ñi cyiig dey yu. Gazeꞌ nu gac chuꞌ dey yuꞌy par nu co dey suuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Gun yu nu waya faboor ne̱, yu zeꞌ zay contr ne̱. Nunu yu nu walocyuub ya̱ nu te̱ꞌ de mbecy, yu zeꞌ tush las yu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ndeꞌ nu ya̱ rne̱e̱ lo der nu Ñgyoozh gac gyicy sulagy mi ni cyu ziꞌl mbecy ni de lo la cyi nu ricy yu nunu de lo la riidz a̱ꞌ nap nu driib ruꞌy. Tees cyu ziꞌl mbecy nu nii zi ni Espiriit Yon nim, yu zeꞌ wayicy sulagy mi niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cyu ziꞌl mbecy nu nii zi ne̱ ya̱ biñ nu byac mbecy, Ñgyoozh gac gyicy sulagy mi niy. Tees yu nu nii zi ni Espiriit Yon nim, de yu zeꞌ wayicy sulagy mi ni dey tiem nu yuꞌn na, gal nu tiem nu yad par lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Benu tub yag nap nañ, orzeꞌ nap na uugy rbic ñi. Zeꞌ benu tub yag a̱ꞌ nap nañ, orzeꞌ rbic ñi uugy shiñ na. Ndeꞌ nu gyuꞌ lo der la na tub yag nu nac uugy nu rbic ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡De ru, mbecy a̱ꞌ nap! ¿Lac gyicy der gniir coz nap, zeꞌ nac der mbecy a̱ꞌ nap? Gun nu ruꞌ mbecy rniiy lac na de coz nu dzi yuꞌ nañ lardooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Benu tub mbecy nap, yu zeꞌ rniiy coz nap gun coz nap yuꞌ nañ lardooy. Benu tub mbecy a̱ꞌ nap, rniiy coz a̱ꞌ nap. Ni rniiy gun yuꞌ coz a̱ꞌ nap nañ lardooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ya̱ rne̱e̱ lo der nu ornu shuub dzi nu ri bee Ñgyoozh ni dela mbecy, orzeꞌ rlagy ñi nii der la gyiꞌ nu mnii der tub ga de riidz ton nu briib ruꞌ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gun dub gal na riidz nu mnii der, dub ni ri bee Ñgyoozh ni der, ben a nu gruu nap der o nu gruu fals der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Orzeꞌ la be de mbecy fariseo gal nu de yu nu rlyuu leey ni Ñgyoozh brugyiꞌ rnii dey. Orzeꞌ na dey rab yu Jesuuz: ―Masht, de̱ ya̱ rlagy de̱ nu zaca̱ nu gyicy ru tub nusuriidz par nu gad lagy de̱ nu laab ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Orzeꞌ na Jesuuz rab mi dey: ―Par de mbecy a̱ꞌ nap, de yu nu wagyicy paa nu yuꞌ tiem na, wadaꞌ muesht par nu zac dey. Nomaas muesht ni Jonás, yu nu mnii por cuen ni Ñgyoozh, ndeꞌ ziꞌl muesht nu gad ni de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gal nu Jonás briy chon dzi nu chon rel nañ tub bel ily, ndeꞌ nu niꞌ ziꞌl ya̱, biñ nu byac mbecy cui̱ chon dzi nu chon rel zeꞌ nu yuꞌ añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ornu shuub dzi nu ri bee Ñgyoozh ni dela mbecy nu yuꞌ tiem na, orzeꞌ de mbecy gyedz Nínive gyes su dey nu niiy nu yuꞌ cyi der. Gun de mbecy Nínive mneꞌ dey cyiy ornu güeñ dey de riidz ni Ñgyoozh nu pshaal Jonás loy. Nunu na la, zu tub mbecy lat der nu gya zir zuy par Jonás. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gun niꞌ ziꞌl biñ mñaa nu riib ic tub nasyoong nu ri par yaa been ornu güiin par zeꞌ nu driib doo, gazaꞌm gyes sum ornu shuub dzi nu gri bee Ñgyoozh ni dela mbecy. Orzeꞌ gazaꞌ biñ mñaa zeꞌ gyes suum nu niim nu yuꞌ cyi der, gun mi zeꞌ bruum tub lugaar nu tonaꞌ la zet par nu guam bzuub gyidag mi shcab lily ni rey Salomoong, nunu na la zu tub mbecy lat der nu gya zir zuy gazeꞌ rey Salomoong. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’De ru na der gal nu na tub mbecy ornu druu chu nuras loy. Orzeꞌ nuras zeꞌ rzay tub lugaar wach. Ryub yu tub lugaar nu zu lagy yu. Na ornu wagad lugaar zeꞌ, orzeꞌ rnii tooy: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nap zir cush cyan, laab zeꞌ nu bruun”, rnii tooy. Na ornu griy, orzeꞌ gyap yu mbecy zeꞌ nu nay gal nu na tub yuꞌ nu nat laa nañ, nunu se cyudz la zu nañ ñi nu bdulyuub. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Orzeꞌ chay nu cha teꞌy tub gagyaꞌ nuras nu shiñ zir ricy gazeꞌ ub yu. Orzeꞌ chuꞌ dey nañ mbecy zeꞌ nu cyiiñ yu. Orzeꞌ mbecy zeꞌ yashiñ zir na mod nu nay, gazeꞌ nu loga. Ndeꞌ mod nu gzac de mbecy a̱ꞌ nap nu yuꞌ na ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gabee rnii ruꞌ Jesuuz nu de mbecy, ornu bruꞌña ñaam nu de bicy mi. Yuꞌ dey gashtal ich la yuꞌ nu rlagy yu nii nuy Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Orzeꞌ tub mbecy byooy rishlom: ―Ñaar nu de bicy ru yuꞌ dey gashtal ich yuꞌ re. Rlagy dey nii nuy ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Orzeꞌ Jesuuz nam rab mi yu nu byoo rishlom zeꞌ: ―¿Cyu ña̱a̱, cyu de bicya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Orzeꞌ blyuu yaam lo de yu nu rsyaꞌ lom. Orzeꞌ nam: ―Ii nguaa ña̱a̱ nunu ii nguaa de bicya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cyu ziꞌl mbecy nu ricy coz nu rlagy Ñgyoozh, uza̱ nu zub gyibaa, de yu zeꞌ nac dey bicya̱ nu zana̱ nu ña̱a̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Orzeꞌ laab dzi zeꞌ bruu Jesuuz nañ yuꞌ nu rcyiiñ mi zam par ruꞌ nisyudoo. Orzeꞌ zeꞌ gusub mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Orzeꞌ como tonaꞌ la mbecy zigy byatublaazh dey lom, orzeꞌ guꞌm nañ tub barc gusub mi. Zeꞌ de mbecy zigy gucua dey ruꞌ nisyudoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Zeꞌ blyuum zañ coz ni dey nu riidz tiily. Orzeꞌ nam rab mi dey: ―Tub mbecy bruuy zay za nuuz yu mbigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lat nu rtich yu de mbigy zeꞌ, yuꞌñ bet lag ñi ruꞌ gyernez, orzeꞌ bruꞌña chigyiñ bdow ma ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Zeꞌ yuꞌ gaꞌñ bet lag ñi lo yu las ruꞌ nu ri gyitaꞌ par nañ. Orzeꞌ dzach briib ñi gun las ruꞌ yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na ornu briib doo na, orzeꞌ bziiñ. Orzeꞌ guwach ñi gun sac sheñ yu nu shet nap ñi lyuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Zeꞌ yuꞌ gaꞌñ bet lag ñi lat gyech. Orzeꞌ dzach guuly gyech zeꞌ. Orzeꞌ pcyiig ñi de yamni zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Zeꞌ yuꞌ gaꞌñ bet lag ñi lo yu nap. De ndeꞌ tonaꞌ la nap na cosech briic ñi. Yuꞌñ briic ñi tub gaynal mbigy. Yuꞌñ briic ñi gayon mbigy. Zeꞌ yuꞌ gaꞌñ briic ñi gal rup tii mbigy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Orzeꞌ na gaꞌm: ―Mbecy nu zub gyidag rlagy ñi gyicy yu nu gyet lag yu cuen ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na despuees de yu nu rsyaꞌ lom bechaꞌ dey lom, orzeꞌ na dey rab yum: ―¿La gyiꞌ nu rniir nu riidz tiily lo de mbecy? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Orzeꞌ Jesuuz nam rab mi dey: ―Par de ru Ñgyoozh briic mi nu gad lagy der coz ni gyel gubier nim, de coz nu wagad lagy mbecy gulas. Tees de yu re wac gyet lag dey cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gun mbecy nu ricy cup la coz, sheñ zir gad niy. Orzeꞌ tonaꞌ la coz sheñ gyicy cup yu. Tees yu nu sac ni, gashtal coz miiñ nu ricy cup yu gruuñ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndeꞌ nu ya̱ rne̱e̱ mod ni riidz tiily, gun orzeꞌ zac dey tees wayuꞌ loy, nunu gyeñ dey tees wayet lag yu cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gun orzeꞌ gyuꞌ niñ gal nu mnii Isaías, yu nu mnii por cuen ni Ñgyoozh ornu nay: Ñgyoozh nam: “Mas gyeñ der, tees wayet lag der cuen. Nunu mas mbi la güii der, tees wayuꞌ lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gun shcab ni de mbecy ii guton ñi, nunu byoow gyidag dey, nunu byoow urlo dey. Gun orzeꞌ wazac dey nu urloy, nunu wayeñ dey nu gyidag yu, nunu wayet lag dey cuen nu shcab niy, nunu nis cush cya dey par lo̱, nis gyicy napa̱ dey”, na Ñgyoozh, na Isaías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Tees de ru dzi ni der, gun rzac der nu urlor, nunu reñ der nu gyidag ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya̱ rishli rne̱e̱ lo der nu zigy de yu nu mnii por cuen ni Ñgyoozh gal nu zigy de mbecy nap ngulagy dey nzac yu de coz nu de ru rzac ru, tees wansac dey. Nunu ngulagy dey ñgyeñ yu de coz nu reñ de ru, tees wangyeñ dey ―na Jesuuz―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Bzuub gyidag der. Orzeꞌ gad lagy der lac yaruu riidz ni mbecy nu mnuuz mbigy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","De mbecy nu rzuub gyidag riidz ni gyel gubier ni Ñgyoozh par wayet lag dey cuen, de yu zeꞌ na dey gal nu na yu nu ri ruꞌ gyernez. Rnii mbecy riidz zeꞌ lo dey, tees orzeꞌ druꞌña nuras rbooy de riidz nap zeꞌ nañ lardoo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Zeꞌ yuꞌ mbecy nu na gal nu na mbigy nu bet lag lo yu las ruꞌ nu ri gyitaꞌ par ñañ. Ornu nu loga la reñ dey riidz ni Ñgyoozh, orzeꞌ “O” rnii dey nunu yet lagy yuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tees par nu las ruꞌ yu zeꞌ, wac shet riidz zeꞌ sheñ lyuñ. Orzeꞌ la be ziꞌl dzi ragyee dey. Tees despuees, ornu druꞌña nu zac ziy o ornu druꞌñañ nu deet rzac yu nu nac riidz zeꞌ, orzeꞌ druu chu dey lo riidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Zeꞌ yuꞌ mbecy nu na gal nu na mbigy nu bdunuuz lat gyech zeꞌ. De yu zeꞌ rzuub gyidag dey riidz ni Ñgyoozh. Tees de gyel rsug ic nu nac de coz ni gyishlombecy ii nunu de gyel ye rzac lo gyel nap, de ndeꞌ ricy ñi gan dey. Gal nu ricy gyech nu wacsaan ñi nu cuic ya mni cosech, ni ricy de coz zeꞌ. Wacsaan ñi gyicy nap riidz ni Ñgyoozh shcab ni de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Zeꞌ yuꞌ mbecy nu na gal nu na mbigy nu bet lag lo yu nap. Orzeꞌ ornu reñ dey riidz zeꞌ, orzeꞌ yet lag dey cuen, nunu rbic ñi cosech nañ lardooy. Yuꞌñ briic ñi tub gaynal mbigy. Yuꞌñ briic ñi gayon mbigy. Yuꞌ gaꞌñ briic ñi gal rup tii mbigy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Orzeꞌ Jesuuz mniim tuubaꞌ riidz tiily lo dey. Orzeꞌ nam: ―Mod nu ricy riidz ni gyel gubier ni Ñgyoozh, nañ gal nu na mod nu bicy mbecy nu gua nuuz mbigy bducui lo yu ni zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tees ornu dela dey nas yu rel, orzeꞌ bruꞌña losaꞌ yuuy. Orzeꞌ mnuuz yu mbigy gyish lat de mbigy nap zeꞌ. Orzeꞌ yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na ornu guuly ñi nunu pshuub tiem nu ca nan zaꞌ niñ, orzeꞌ niꞌ ziꞌl guuly gyish nu bdunuuz lat yamni zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Orzeꞌ bruꞌña de yu nu ricy riiñ ni mbecy zeꞌ. Orzeꞌ na dey rab yuy: “¿Lac guc briib de gyish zeꞌ? Zeꞌ ru mnuuz ru mbigy bducui”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Orzeꞌ na yu nu mnuuz mbigy zeꞌ rab yu dey: “Ca ziꞌl na tub yu nu rzi lagy gua nuuz yu ndeꞌ”, nay. Orzeꞌ na gaꞌ de yu nu ricy riiñ zeꞌ: “¿A rlagy ru cha̱ de̱ loo lyu̱ de̱ de gyish zeꞌ?” na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Orzeꞌ na yu nu mnuuz mbigy zeꞌ rab yu dey: “Walagya̱, gun ornu co lyu der de gyish zeꞌ, orzeꞌ gyicy ñi nu gruu lyu gaꞌ ya mni zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nap zir zaan der galy ñi tublaazh la gashtal shuub tiem nu te̱ꞌ cosech. Orzeꞌ gyicya̱ mandaar lo de yu nu ricy riiñ ne̱ nu co lyu dey de gyish zeꞌ loga la. Orzeꞌ gag yeñ ñi par nu chañ lo gyi. Orzeꞌ gazeꞌ nu teꞌ dey cosech zeꞌ nunu cuꞌ choow dey ñi nañ ye”, nay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Orzeꞌ Jesuuz mniim tuubaꞌ riidz tiily lo dey. Orzeꞌ nam: ―Gyel gubier ni Ñgyoozh rac ñi gal nu rac nu tub mbigy ya urnishtas nu rnuuz mbecy lo yu niy, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","gun ndeꞌ mbigy nu blazhaꞌ zir mbigy miꞌ gazeꞌ deꞌ zir mbigy. Tees ornu raly ñi zily zir ñi yac ñi gazeꞌ deꞌ zir de yag miꞌ. Yac ñi gal nu na tub yag ily. Gashtal de chigyiñ nu rded lo bi druꞌña ma lat yaañ, nunu rzaa ma teez ma ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Orzeꞌ mniim tuubaꞌ riidz tiily lo dey. Orzeꞌ nam: ―Gyel gubier ni Ñgyoozh nañ gal nu na lebadur nu gush tub biñ mñaa. Bduꞌm ñii lat chon nac arin. Orzeꞌ ptub yaam ñii, gun orzeꞌ lebadur zeꞌ cshup ñi dela cub zañ zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","De la ndeꞌ mnii Jesuuz lo de mbecy nu riidz tiily. Nunu waniim lo dey benu walab nu riidz tiily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ni bicy mi par nu gyuꞌ niñ gal nu mnii tub yu nu mnii por cuen ni Ñgyoozh ornu nay: Biñ nu ca lo cuen nu cyid nam: “Ya̱ gne̱e̱ lo dey nu riidz tiily. Ya̱ gne̱e̱ lo dey de coz nu wangad lagy mbecy nese nu bzub gyiꞌ gyishlombecy”, nam, na yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Orzeꞌ Jesuuz mnii num dey ñgyoozh, orzeꞌ bzuu nez mi dey yay yuꞌy. Orzeꞌ guꞌm nañ yuꞌ. Orzeꞌ bruꞌña de yu nu rsyaꞌ lom. Orzeꞌ byatublaazh dey lom. Orzeꞌ na dey rab yum: ―¿Lac yaruu de riidz tiily ni gyish nu briib lat ya mni zeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Orzeꞌ Jesuuz nam rab mi dey: ―Mbecy nu mnuuz mbigy bducui zeꞌ, ndeꞌ ya̱ biñ nu byac mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na yu zeꞌ ndeꞌ gyishlombecy ii. Zeꞌ de mbigy bducui zeꞌ, ndeꞌ de mbecy nu rash gyel gubier ni Ñgyoozh. Zeꞌ de gyish zeꞌ, ndeꞌ de mbecy nu nac nu nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zeꞌ mbecy rzi lagy nu mnuuz mbigy gyish zeꞌ, ndeꞌ nuras. Zeꞌ cosech zeꞌ nu ndeꞌ ornu shuub dzi ni gyishlombecy ii. Zeꞌ de mbecy nu teꞌ cosech zeꞌ, ndeꞌ de anc ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Gal nu rteꞌ dey de gyish nu neꞌ dey ñi lo gyi, niꞌ ziꞌl gac ornu shuub dzi ni gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tiem zeꞌ ya̱ biñ nu byac mbecy zuu neza̱ de anc ne̱ nu cha teꞌ dey dela mbecy nu rlyuu coz cyi lo losaꞌ, gal nu de mbecy nu a̱ꞌ nap ricy. De anc zeꞌ coy de mbecy nu shiñ ricy zeꞌ lat de mbecy nu nac nu gyel gubier ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Orzeꞌ zeed yu dey chay lo gyi. Zeꞌ nu chuꞌ dey gun yu nunu siigy lay yu ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Gazeꞌ nu de mbecy ni Ñgyoozh ryal gabe dey gal nu rabe doo güidz lugaar zeꞌ nu riib ic Ñgyoozh, uz dey. De yu nu rzuub gyidag rlagy ñi nu gyicy yu nu gyet lag yu cuen ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Gyel gubier ni Ñgyoozh nañ gal nu na gyel nap nu ri ngach lo yu. Orzeꞌ tub mbecy byap yu gyel nap zeꞌ. Orzeꞌ pcach yuñ tuubaꞌ tir laab lugaar zeꞌ. Nunu tonaꞌ la bet lagy yu. Orzeꞌ yay biit yu dela coz nu ricy cup yu, gazeꞌ nu wiiy lugaar zeꞌ nu ri gyel nap zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Niꞌ ziꞌl mod ricy nu mbecy gyel gubier ni Ñgyoozh gal nu ricy de mbecy nu ricy dalje̱z nu rded ryub dey urndub nu dzi cyit na. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na ornu gyap yu tub urndub nu tonaꞌ la ñgyup sac, orzeꞌ yay nu cut yu dela coz nu ricy cup yu. Orzeꞌ cush cyay ziy urndub nu dzi sac zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Mod nu rac nu gyel gubier ni Ñgyoozh, ndeꞌ mod nu rac nu tub gyish nu rub mbecy bel. Gyish zeꞌ rneꞌ dey ñi lo nisyudoo. Orzeꞌ zañ lo bel rzuꞌ ma nañ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na ornu dzaa nañ gyish zeꞌ, orzeꞌ co dey ñi par lo yu wach. Orzeꞌ chesub dey nu cuiy de bel nu guꞌ nañ gyish zeꞌ. Orzeꞌ de bañ nap cuꞌ choow dey ma nañ chicyiw niy. Zeꞌ bañ wacyiiñ neꞌ dey ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Niꞌ ziꞌl mod gac ornu shuub dzi ni gyishlombecy ii. De anc gruꞌña dey. Co reñ yu de mbecy a̱ꞌ nap lat de mbecy nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Orzeꞌ zeed yu dey chay lo gyi, zeꞌ nu chuꞌ dey gun yu nunu siigy lay yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Orzeꞌ nam rab mi dey: ―¿A yet lag der cuen dela de riidz ii? ―nam. ―A̱, yet lag de̱ cuen ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Orzeꞌ na gaꞌm rab mi dey: ―Ornu tub mbecy nu rlyuu leey ni Ñgyoozh rac yu de coz ni gyel gubier nim, orzeꞌ yac yu gal nu na shuaan tub yuꞌ. Orzeꞌ yu zeꞌ rbooy coz cub nu coz gush zeꞌ nu yuꞌ choow de coz niy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ornu blazh mnii Jesuuz de riidz tiily zeꞌ, orzeꞌ bruum zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Orzeꞌ brim ledz mi. Gazeꞌ nu brugyiꞌ rlyuum ni de mbecy nañ yuꞌ nu rsyaꞌ dey riidz ni Ñgyoozh. Orzeꞌ tonaꞌ la za nu ic de mbecy. Orzeꞌ na dey: ―Zeꞌ ¿ca psyaꞌ gaꞌ yu ii de coz ily nu rniiy? Zeꞌ ¿lac mod ricy yu nu rac ricy yu de nusuriidz zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Zeꞌ ¿a walab yu ii iꞌñ biryag? Zeꞌ, ñaay ndeꞌ Li nu de bicy yu Santiag, nu See, nu Simo̱o̱, nu Judas. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nunu ¿a walab laab lat na ii rcyiiñ de zan yu? Zeꞌ ¿ca guud de coz nu ricy yu beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Orzeꞌ wancheel reñ dey mi. Orzeꞌ nam rab mi dey: ―Ca ziꞌl lugaar mbecy rca lagy dey lo yu nu rnii por cuen ni Ñgyoozh. Nomaas ledz yu, nu de famil niy waca lagy dey loy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Orzeꞌ wangac gyicy mi zañ nusuriidz par nu wangyicy cup de mbecy zeꞌ consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Laab tiem zeꞌ rey Herodes, yu nu riib ic lo de yu ni Galilea, güeñ yu de riidz nu zaab ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Orzeꞌ nay rab yu de yu nu zu riiñ loy: ―Yu zeꞌ, ndeꞌ Waa nu briib nis mbecy. Byabañ yu. Ndeꞌ nu rac ricy yu de nusuriidz ily zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ni mniiy gun laab yu bicy yu mandaar nu pcyiig dey Waa nu pshet lag dey yu nañ yuꞌ gyiib. Ni bicy yu par nu nac Herodías, mñaa bicy yu Lip. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gun Waa nu briib nis mbecy zaab rnii lay lo rey Herodes. Orzeꞌ rniiy: ―Ru rach ñi nir lo Ñgyoozh nu gush ru biñ mñaa zeꞌ ―rniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Orzeꞌ rey Herodes ngulagy yu ñgyut yu Waa, tees gudzib yu lo de mbecy Israeel. Gun bicy dey Waa par tub yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tees ornu pshuub dzi nu bicy dey saꞌ ni dzi nu gul rey Herodes, orzeꞌ iꞌñ Herodías bilgyiꞌñ lo dela mbecy. Orzeꞌ rey Herodes tonaꞌ la bet lagy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Orzeꞌ mniiy lo fiñ zeꞌ nu waded la cuic yu la ziꞌl coz nu cyiñ ñi loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Orzeꞌ nu loga la bdugyiꞌñ lo ñaañ. Gazeꞌ nu nañ rab ñi rey Herodes: ―Rlagya̱ nu cuic ru too Waa ne̱ nañ tub gyaꞌn ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Orzeꞌ rey Herodes tonaꞌ la bicy shniy ornu güeñ yu riidz zeꞌ, tees como lo rgüii la de mbecy nu nguaa zeꞌ mniiy nu waded la cuic yu la ziꞌl coz nu cyiñ fiñ feñ zeꞌ, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","orzeꞌ bicy yu mandaar lo tub soldad nu cha shiꞌñ yu too Waa nañ yuꞌ gyiib. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Orzeꞌ lueg la za nuy ñi nañ tub gyaꞌn. Orzeꞌ briic yu ni fiñ feñ zeꞌ. Orzeꞌ fiñ feñ zeꞌ gush ñi ndeꞌ. Orzeꞌ byabic ñi ndeꞌ ni ñaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Orzeꞌ despuees bruꞌña de yu nu rsyaꞌ lo Waa nu gua te dey cuerp niy. Orzeꞌ pcach dey ñi. Orzeꞌ gua nii dey lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ornu güeñ Jesuuz coz nu bzac Waa, orzeꞌ bruum lugaar zeꞌ. Zam tub lugaar ub zi nañ tub barc. Na ornu gud lagy de mbecy, orzeꞌ bruu dey lat de gyedz za ca̱ dey ich mi par lo yu bigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Orzeꞌ Jesuuz bruum nañ barc. Na ornu bzaac mi de mbecy zigy, orzeꞌ gushni lagy mi dey. Orzeꞌ bicy yac mi de mbecy rat nu gua nu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na or becheñ, orzeꞌ bruꞌña de yu nu rsyaꞌ lom. Orzeꞌ na dey rab yum: ―Na tonaꞌ la bi gudze nunu ii tub lugaar ub zi. Bzuu nez de mbecy gyay, gun orzeꞌ cha dey lat de gyedz nu yuꞌ gaab ga, gun orzeꞌ zi dey coz nu gow yu ―na dey rab yum. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Orzeꞌ na Jesuuz rab mi dey: ―Walagy ñi nu gya dey. De ru briic coz nu gow dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Orzeꞌ na gaꞌ dey: ―Sac laꞌ zir coz nu ricy cup de̱ nomaas gaay gyishtily nu cyup bel miꞌ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Orzeꞌ na gaꞌm rab mi dey: ―Da nu der ñii lo̱ ii ben ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Orzeꞌ Jesuuz mniim lo de mbecy nu gzub dey lo gyizh. Orzeꞌ bduꞌ yaam gaay gyishtily zeꞌ nu cyup bel zeꞌ. Orzeꞌ bgüiim par baa. Orzeꞌ briic mi gras ni Ñgyoozh. Orzeꞌ blew mi gyishtily zeꞌ. Orzeꞌ briic mi ñii ni de yu nu rsyaꞌ lom. Orzeꞌ bleez dey ñi lat de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Orzeꞌ dela mbecy bdow gyel la dey. Ornu blazh nu bdow dey, orzeꞌ brusub trocyup ruꞌ chicyiw de coz nguzh ni gyishtily nu pteꞌ dey zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","De yu nu bdow zeꞌ gaay miily dey nac yu: Zeꞌ reñ de biñ mñaa nu de yu nguzh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Orzeꞌ Jesuuz mniim lo de yu nu rsyaꞌ lom nu chuꞌ dey nañ barc par nu cha ga dey lo gashtal tub laꞌ gaꞌ ruꞌ nisyudoo. Orzeꞌ Jesuuz byeeñ gam par nu nii num de mbecy ñgyoozh. Orzeꞌ bzuu nez mi dey yay yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Na ornu blazh nu mnii num dey ñgyoozh na, orzeꞌ ub zi lam zam tub logyiꞌ nu nii num Ñgyoozh. Na or becheñ laab lugaar zeꞌ zum ub zi lam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Laab tiem zeꞌ zaab barc nu za nu de yu nu rsyaꞌ lom gazel nisyudoo. Tees tonaꞌ la ricy nu de nguuly lo nisyudoo barc zeꞌ, gun par nez nu zañ druu bi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na ornu gabee cas ruꞌ zu, orzeꞌ rza la Jesuuz. Lo nis zam lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na ornu bzaac dey nu yad mi lo nis, orzeꞌ tonaꞌ la gudzib dey. Orzeꞌ rbish ti la dey. Orzeꞌ na dey: ―¡Ndeꞌ tub bis! ―na dey. Nunu rbish ti dey nu tantaꞌ gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tees orzeꞌ Jesuuz nam rab mi dey: ―¡Briic der baloor! ¡Ya̱ nu ndeꞌ! ¡Cueꞌ dzib der! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Orzeꞌ Bed nay rab yum: ―Shuaan de̱, zeꞌ benu laab ru, orzeꞌ bicy nu ya̱ gza̱ lo nis nu yapa̱ lor ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Orzeꞌ nam rab mi yu: ―Da ―nam. Orzeꞌ Bed bruuy nañ barc, nunu brugyiꞌ nu rzay lo nis zay par lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tees ornu bduꞌ cuen yu nu dzi druu bi, orzeꞌ gudzib yu. Orzeꞌ brugyiꞌ rzez ti̱y lo nis. Orzeꞌ brish tiy. Orzeꞌ nay: ―¡Shuaan de̱, bloo mbañ ya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Orzeꞌ lueg la Jesuuz bduꞌ yaam yaay. Orzeꞌ nam rab mi yu: ―¡Dzi ga ñuu miꞌ consuel ricy cup ru! ¿Lagu bicy cyup ic ru? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na ornu guꞌy nañ barc nuy mi, orzeꞌ lueg la guri bi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Orzeꞌ de yu nu yuꞌ nañ barc zeꞌ gusutib dey lo Jesuuz. Orzeꞌ na dey rab yum: ―¡Rishli gaal ru nac ru iꞌñ Ñgyoozh! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Orzeꞌ bded dey lo nisyudoo zeꞌ. Orzeꞌ bruꞌña dey lo de yu ni Genesaret. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ornu de mbecy nu yuꞌ lugaar zeꞌ byuꞌ lo dey Jesuuz, orzeꞌ ptush las dey riidz par dela lugaar zeꞌ. Orzeꞌ za nu dey dela mbecy rat lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Orzeꞌ mnishbaa dey lom nu zaan mi gal dey mas ñuu ruꞌ shab mi. Orzeꞌ dela yu nu gul yaa ruꞌ shab mi byac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Orzeꞌ la be de mbecy fariseo, gal nu de mbecy nu rlyuu leey ni Ñgyoozh bruu dey Jerusaleeng za dey lo Jesuuz. Orzeꞌ bdugyiꞌ dey lom. Orzeꞌ na dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Lagu de yu nu rsyaꞌ lo ru wagyicy yac dey nu de cushtom ni de gyitoo bel ni den nu wagnaa dey anzir nu gow yu gyit gal mod nu bzeeñ de gyitoo bel? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Orzeꞌ Jesuuz nam rab mi dey: ―Zeꞌ de ru, ¿lagu rlagy der zuub yaar de riidz ni Ñgyoozh par nu gyicy yac der cushtom ni gyitoo bel nir? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","―Gun Ñgyoozh nam: “Pca lagy lo uz ru nunu pca lagy ru lo ñaar, gun yu nu nii zi ni uz o yu nu nii zi ni ñaa, yu zeꞌ rlagy ñi nu gat yu”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tees de ru rniir nu benu tub mbecy niiy lo uz yu o niiy lo ñaay nu la ziꞌl coz nu rlagy ñi cuic yu ni dey, ndeꞌ bi briic yu ni Ñgyoozh. Orzeꞌ walagy ñi locyuub yu uz yu nu ñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ndeꞌ nu par nu nac de cushtom ni gyitoo bel ni der, orzeꞌ rzu chu der de riidz nu rnii Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡A de ru mbecy rzuu lo! Tonaꞌ la nap mnii Isaías, yu nu mnii por cuen ni Ñgyoozh, ornu mniiy: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","De mbecy ii rzat dey ya̱ nu ruꞌ ziꞌl yu. Tees nañ lardoo dey ricy zet lagy yu lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Se la la cyiiñ ñi nu driib zily dey ya̱ gun driib zily ton dey ya̱. Leey nu bloo ic mbecy, ndeꞌ ziꞌl rlyuu dey. Ni na Ñgyoozh lat de riidz ni Isaías ―na Jesucrisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gazeꞌ nu bredz Jesuuz de mbecy zigy nu gyatublaazh dey lom. Orzeꞌ nam rab mi dey: ―Dela der bzuub gyidag der, nunu bicy der nu gyet lag ru cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ndeꞌ nu walab coz nu chuꞌ par ruꞌ mbecy gyicy ñi nu gabag yu, sinu coz nu driib ruꞌ dey, ndeꞌ gyicy ñi nu gabag yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Orzeꞌ de yu nu rsyaꞌ lom bechaꞌ dey lom. Orzeꞌ na dey rab yum: ―¿A wangad lagy ru nu de mbecy fariseo guzi lagy dey ornu güeñ yu de coz nu mniir? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Orzeꞌ na gaꞌm: ―Coz nu rlyuu mbecy, ndeꞌ nañ gal nu na tub ya mni. Ca ziꞌl na tub ya mni nu walab Ñgyoozh uza̱ mnuuz mi, ndeꞌ rlagy ñi nu gruu lyuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cueꞌ gyicy cuen der dey, gun na dey gal na mbecy locaꞌ. Benu tub lo caꞌ lyuuy nez ni losaꞌ lo caꞌy, orzeꞌ rup laa dey gyet lag yu tub ziꞌl gyegy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Orzeꞌ Bed nay rab yu Jesuuz: ―Pshaal lo de̱ de riidz tiily nu mniir zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Orzeꞌ na Jesuuz: ―¿Walab gaal niꞌ de ru wangyet lag der cuen? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A wagad lagy ru nu de coz nu chuꞌ par ruꞌ mbecy yaañ par nañ yu? Orzeꞌ gruu gaꞌñ nañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tees de coz nu driib ruꞌ mbecy, ndeꞌ druuñ gashtal nañ lardooy. Orzeꞌ de coz zeꞌ ricy ñi nu rabag yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gun nañ lardoo dey druu shcab a̱ꞌ nap. Zeꞌ druu nu rut dey losaꞌy. Zeꞌ druu nu ral dey losaꞌy nu wanchelaay. Zeꞌ druu nu ral dey losaꞌy de lo la mod nu a̱ꞌ nap. Zeꞌ druu nu ricy dey gubaan. Zeꞌ druu nu rguu dey. Zeꞌ druu nu rnii dey rishcuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","De ndeꞌ coz nu ricy ñi nu rabag mbecy. Tees benu mbecy wanaay ornu gow yu gyit, walab ndeꞌ gyicy ñi nu gabag yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Orzeꞌ Jesuuz bruum lugaar zeꞌ zam par lo de yu ni gyedz Tiro nu Sidón. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Orzeꞌ bruꞌña tub biñ mñaa, biñ Cananea nu pcyiiñ lugaar zeꞌ, lo Jesuuz. Orzeꞌ rbish ti num Jesuuz. Orzeꞌ nam: ―¡Jesuuz, biñ nu nac nez Dabi, gushni ñuu lagy ya̱! Fiñ guzh ne̱ bicy ni nuras ñi nunu tonaꞌ la rzac ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tees Jesuuz rila waniim. Orzeꞌ bruꞌña de yu nu rsyaꞌ lom. Orzeꞌ na dey rab yum: ―Mnii lo biñ mñaa re nu gyam, gun yad mi rbish tim par ich na ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Orzeꞌ na Jesuuz: ―Ñgyoozh bzuu nez mi ya̱ nu yapa̱ lat de mbecy Israeel, de yu nu na gal nu na shily bduneꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tees biñ mñaa zeꞌ bechaꞌm lo Jesuuz. Orzeꞌ gusu tib mi. Orzeꞌ nam: ―Jesuuz, blocyuub ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Orzeꞌ na gaꞌ Jesuuz: ―Walab seꞌñ nu loon gyishtily yaa de yu nguzh nin par nu neꞌn ñi lo che̱ꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Orzeꞌ na biñ mñaa zeꞌ rab mi Jesuuz: ―Laab ni gal nu mniir. Tees mas de che̱ꞌ gac gow ma de coz nguzh nu gyet lag lo mez ni shuaan ma ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Orzeꞌ Jesuuz nam rab mi biñ mñaa zeꞌ: ―¡Dzi ga fert ricy cup ru consuel lo̱! Na ya̱ gyicya̱ gal nu rlagy ru ―nam. Orzeꞌ laab or la zeꞌ byac fiñ nguzh nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Orzeꞌ bruu Jesuuz lugaar zeꞌ zam dub ruꞌ nisyudoo la ni Galilea. Orzeꞌ pcam tub logyiꞌ zam. Orzeꞌ zeꞌ gusub mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Orzeꞌ tonaꞌ la mbecy zigy byatublaazh dey lugaar zeꞌ nu zub mi. Gua nu dey mbecy coj, gal nu mbecy lo caꞌ. Gua nu dey mbecy yaa bicy, gal nu mbecy gop. Gua nu dey zañ zir lo de mbecy rat. Gua tish dey de yu zeꞌ lom. Orzeꞌ bicy yac mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Orzeꞌ tonaꞌ la za nu ic de mbecy ornu bzaac dey nu de mbecy gop brugyiꞌ rniiy; nu de mbecy yaa bicy byanap yaa dey; nu de mbecy coj brugyiꞌ rza nap dey; nu de mbecy lo caꞌ brugyiꞌ rzac dey. Orzeꞌ brugyiꞌ nu driib zily dey Ñgyoozh, biñ nu driib zily de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Orzeꞌ Jesuuz bredz mi de yu nu rsyaꞌ lom nu gyatublaazh dey. Orzeꞌ nam rab mi dey: ―Ya̱ rashni lagya̱ de mbecy zigy ii gun bi bzaꞌ chon dzi nu yuꞌ dey lo̱ ii, nunu blazh coz nu gow dey. Walagya̱ zuu neza̱ dey gyay yuꞌy gal ran ziꞌl yu, gun dzi ga suun ñi dey nez nu yay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Orzeꞌ na de yu nu rsyaꞌ lom: ―¿Tees lac gyicy na nu gad de coz nu gow de mbecy zigy ii? Gun ii tub lugaar zeꞌ nu sac la mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―¿La be gyishtily ricy cup der? ―nam. Orzeꞌ na dey: ―Gagy gyishtily nu cyup chon bel miꞌ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Orzeꞌ Jesuuz bicy mi mandaar nu gzub dey lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Orzeꞌ gush mi gagy gyishtily zeꞌ nu de bel zeꞌ. Orzeꞌ briic mi gras ni Ñgyoozh. Orzeꞌ blew mi ñii briic mi ni de yu nu rsyaꞌ lom. Orzeꞌ de yu zeꞌ bleez dey ñi lat de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Orzeꞌ dela dey bdow gyel lay. Orzeꞌ blazh zeꞌ, pteꞌ dey gagy la chicyiw de coz ngush nu brusub. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","De yu nu bdow gyishtily zeꞌ tap miily dey nac yu. Reñ de biñ mñaa nu de yu nguzh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Despuees ni de nu ndeꞌ, Jesuuz mnii num dey ñgyoozh. Orzeꞌ bzuu nez mi dey yay. Orzeꞌ guꞌm nañ barc. Orzeꞌ zam par lo yu ni Magadán. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Orzeꞌ bruꞌña gaꞌ de mbecy fariseo nu de mbecy saduceo lo Jesuuz. Brugyiꞌ rgugyiꞌ dey lom par nu gyicy dey preb mi. Bdiiñ dey lom nu gyicy mi tub nusuriidz baa par nu gabe nu Ñgyoozh nac num mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tees Jesuuz nam rab mi dey: ―Or nu bi za doo, orzeꞌ rnii der: “Nap zu ina gun bi taꞌ za ña par zeꞌ nu za doo”, rnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nunu or zaꞌ yu rnii der: “Dzi na gyet gyey gun zu cow de ruꞌ baa nunu taꞌ za ña”, rnii der. ¡Mbecy rzuu lo! Rad lagy der lac yaruu de muesht nu taꞌ baa, tees wagad lagy der lac yaruu de muesht nu ricy nu gabe la tiem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Par de mbecy a̱ꞌ nap, de yu nu wagyicy paa nu yuꞌ tiem na, rgyiiñ dey tub nusuriidz, tees wad ñi ni dey; nomaas nusuriidz ni Jonás, yu nu mnii por cuen ni Ñgyoozh, ndeꞌ ziꞌl nusuriidz nu gad ni dey ―nam. Orzeꞌ Jesuuz bruum lat dey zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na ornu de yu nu rsyaꞌ lom bi gul dey tub laꞌ gaꞌ ruꞌ nisyudoo, orzeꞌ mnit lagy dey cha nuy gyishtily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Orzeꞌ na Jesuuz rab mi dey: ―Bduꞌ cuen der nunu bicy cuidad der nu lebadur ni de mbecy fariseo nu de mbecy saduceo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Orzeꞌ de yu nu rsyaꞌ lom brugyiꞌ ro dey riidz nu losaꞌy. Gazeꞌ nu na dey: ―¿Ti walab nu a̱ꞌ dun gyishtily, ndeꞌ nu ni rniim? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tees Jesuuz gud lagy mi de coz nu mnii dey. Orzeꞌ nam rab mi dey: ―¿Lagu rnii der nu wangyiid nur gyishtily? ¿A ndeꞌ nu ni rne̱e̱ rzii der? ¡Dzi ga consuel miꞌ ricy cup der lo̱! ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A gaal zi gabee wagyet lag der cuen? ¿A wagyezaꞌ lagy der ni gaay gyishtily nu bleza̱ lat gaay miily mbecy? Zeꞌ ¿la be chicyiw pteꞌ der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nunu niꞌ ¿a wagyezaꞌ lagy der ni gagy gyishtily nu bleeza̱ lat tap miily mbecy? Zeꞌ ¿la be chicyiw de nu brusub pteꞌ der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Walab gaal wangyet lag der cuen nu walab gyishtily bzata̱ lo der ornu mne̱e̱ lo der nu bicy cuidad der nu lebadur ni de mbecy fariseo nu de mbecy saduceo? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Orzeꞌ bet lag dey cuen nu Jesuuz walab nu bzat mi lebadur nu yuꞌ nañ gyishtily; sinu bzat mi de riidz nu rlyuu de mbecy fariseo nu de mbecy saduceo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ornu bruꞌña Jesuuz lo de yu nu yuꞌ gaab ga Cesarea ni Felipo, orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ―¿Cyu rnii de mbecy nu nac ya̱, biñ nu byac mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Orzeꞌ na dey: ―Yuꞌ mbecy nu rniiy nu ru Waa nu briib nis mbecy. Zeꞌ yuꞌ gaꞌ dey rniiy nu ru Elías. Zeꞌ yuꞌ gaꞌ dey rniiy nu ru Jeremías, o ca ziꞌl na de yu nu mnii por cuen ni Ñgyoozh, rnii dey ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","―Zeꞌ de ru ¿cyu rnii der nu naca̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Orzeꞌ na Bed rab yum: ―Laab ru Mesías, iꞌñ Ñgyoozh mbañ, biñ nu ca lo cuen nu gzeed Ñgyoozh nu co mbañ de mbecy nim ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Orzeꞌ na Jesuuz: ―Dzi nir Simo̱o̱, iꞌñ Jonás, gun ni tub la mbecy wancuic yu nu gad lagy ru, sinu Ñgyoozh uza̱ nu zub gyibaa briic mi nu gad lagy ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya̱ ne̱e̱ lor nu ru Bed, tub mbecy nu na gal nu na tub gyitaꞌ. Nunu dela mbecy nu nac nu gyitaꞌ zeꞌ nac dey mbecy ne̱. Nunu de yu zeꞌ mas gat dey tees wanit loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nunu ya̱ rica̱ rishbeey nir par nu shaal ru nez nu chuꞌ mbecy lat de yu nu riib ic Ñgyoozh. La ziꞌl mod nu ricy mbecy, benu ru niir nu walab ni rlagy ñi gyishlombecy ii, orzeꞌ niꞌ ziꞌl gashtal gyibaa walab ni rlagy ñi nii Ñgyoozh. Nunu la ziꞌl coz nu ru niir nu laab ni gyishlombecy ii, orzeꞌ niꞌ ziꞌl laab ni nii Ñgyoozh gashtal gyibaa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Orzeꞌ Jesuuz mniim lo de yu nu rsyaꞌ lom nu cueꞌ nii dey lo ni tub la mbecy nu nac mi Mesías, biñ nu ca lo cuen nu co mbañ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nese tiem zeꞌ Jesuuz brugyiꞌ rniim lo de yu nu rsyaꞌ lom nu rlagy ñi nu gyam Jerusaleeng. Nunu mniim nu de yu bel ni de mbecy Israeel, nu de uz zub lo, nu de yu nu rlyuu leey ni Moisees, de yu zeꞌ gyicy dey nu tonaꞌ la gzac zim. Orzeꞌ mniim nu cut dey mi tees nañ chon dzi gyabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Orzeꞌ Bed gua nu reñ yu Jesuuz. Gazeꞌ nu fert mniiy tub riidz lom. Orzeꞌ nay rab yum: ―¡Shuaan de̱, cueꞌ zaan yaa Ñgyoozh nu rila cueꞌ ni zac ru! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Orzeꞌ Jesuuz bish cyam mniim loy. Orzeꞌ nam: ―¡Bruu chu lo̱ ii nuras! Ricy ru nu yabiigy zir coz nu rlagy ñi gyicya̱, gun shcab nir wasaap ñi shcab ni Ñgyoozh; sinu shcab nir ndeꞌ shcab nu ricy cup mbecy ziꞌl ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Orzeꞌ Jesuuz nam rab mi de yu nu rsyaꞌ lom: ―Benu ca na mbecy rlagy yu nu gac yu mbecy nu rsyaꞌ lo̱, orzeꞌ rlagy ñi nu cueꞌ gyicy cuen yu coz nu rlagy ub yu. Nunu rlagy ñi nu shet ic yu nu gzac ziy nu nac ya̱. Orzeꞌ rlagy ñi gyicy yu gal nu rlagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gun yu nu rlagy co nap ub, yu zeꞌ nit loy. Tees yu nu nit lo nu nac ya̱, yu zeꞌ rishli gruu mbañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gun ¿la rusub ni mbecy benu gyicy yu gan dela coz nu yuꞌ gyishlombecy, tees lardooy duneꞌñ? ¿Nunu la coz gac cyish mbecy nu gyad lardooy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gun ya̱ biñ nu byac mbecy sñuu ga yapa̱ nu gyel lily ni Ñgyoozh uza̱ nu de anc nim. Orzeꞌ gazeꞌ nu ya̱ gyabica̱ i tub ga la de mbecy dub gal nu na coz nu bicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gun ya̱ rish li rne̱e̱ lo der nu la be de mbecy nu yuꞌ lat der ii na la, wat dey gashtal zac la dey ya̱, biñ nu byac mbecy nu yapa̱ mod ni tub rey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ornu bded tub shuup dzi, orzeꞌ Jesuuz gua nu reñ mi Bed nu Santiag nu Waa, bicy yu. Orzeꞌ gup mi too tub bicy nu dzi gya nu de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Orzeꞌ bdza nu na Jesuuz lo rgüii la dey. Orzeꞌ gal nu na doo güidz ni na lom byac. Zeꞌ shab mi byacaacy ryal lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Orzeꞌ sij la bruu zac Elías nu Moisees, lo rgüii la de yu nu rsyaꞌ lom, nu ro dey riidz nu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Orzeꞌ Bed nay rab yu Jesuuz: ―Shuaan de̱, ¡dzi ga nap nu yu̱ꞌ de̱ ii! Benu rlagy ru, orzeꞌ za̱a̱ de̱ chon ramad ni der: tub par ru, tuubaꞌ par Moisees, tuubaꞌ par Elías ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Orzeꞌ lat nu gabee rnii Bed, orzeꞌ bruu zac tub za ryal too dey. Orzeꞌ psoow ñi dey. Orzeꞌ zaab tiꞌ mbecy lat za zeꞌ. Orzeꞌ nam: ―Mi ii iꞌña̱ nu tonaꞌ la rca̱, nunu tonaꞌ la yet lagya̱. Bzuub gyidag der nim ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na ornu güeñ de yu nu rsyaꞌ lom de riidz zeꞌ, orzeꞌ gugyit tiily la dey lo yu. Nunu tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Orzeꞌ bechaꞌ Jesuuz lo dey nunu gul yaam dey. Orzeꞌ nam rab mi dey: ―Wes su der. Cueꞌ dzib der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na ornu briꞌ lo dey, orzeꞌ wansacaꞌ dey cyuꞌ zir mbecy. Se Jesuuz ziꞌl bzaac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Gazeꞌ nu gush nez num dey bet mi par gyiꞌ bicy zeꞌ. Na lat nu ya num dey, orzeꞌ pcach mi ruꞌ dey. Orzeꞌ nam rab mi dey: ―Cueꞌ nii der lo ni tub la mbecy de coz nu bruu zac lo der gashtal shuub la dzi nu ya̱, biñ nu byac mbecy, gata̱ nunu gyabaña̱ tuubaꞌ tir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Orzeꞌ de yu nu rsyaꞌ lom zeꞌ na dey rab yum: ―¿Lagu de yu nu rlyuu leey ni Ñgyoozh rniiy nu Elías rlagy ñi nu cyid yu loga la? Gazeꞌ nu cyid Mesías, biñ nu ca lo cuen nu co mbañ mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Orzeꞌ na Jesuuz rab mi dey: ―Rishli gaal nu Elías cyid yu loga la par nu gzu nap yu de la coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tees ya̱ ne̱e̱ lo der nu Elías bi biid yu, nunu de mbecy wangyuꞌ lo dey yu, tees bicy nu dey yu dela coz a̱ꞌ nap nu mnii too dey nu gyicy nuy yu. Niꞌ ziꞌl mod ted zi dey ya̱, biñ nu byac mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Orzeꞌ de yu nu rsyaꞌ lom bet lag dey cuen nu Waa nu briib nis mbecy rzat mi lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na ornu bruꞌñam zeꞌ nu byatublaazh de mbecy, orzeꞌ tub mbecy bruꞌñay lo Jesuuz. Gusu tib yu lom. Orzeꞌ nay rab yum: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Jesuuz, gushni ñuu lagy iꞌña̱ gun ricy ñi bi rat caꞌ niy. Nunu tonaꞌ la rzac yu. Bi guzañ tir yet lag yu lo gyi nu lo nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bi gua̱ du̱ yu lo de yu nu rsyaꞌ lor, tees wangac gyicy yac dey yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Orzeꞌ na Jesuuz: ―¡A der mbecy nu yuꞌ na! Dzi ga wagyicy cup der consuel lo̱. Dzi ga mnu shcab ni der. ¿Laꞌ zir be tiem rlagy ñi nu chesa̱ du̱ der? Da nu der yu nguzh rat zeꞌ lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Orzeꞌ Jesuuz bicy mi mandaar lo nuras zeꞌ nu cueꞌ ni gyicy yu. Orzeꞌ bruu chuy lo yu nguzh rat zeꞌ. Orzeꞌ laab or la zeꞌ byac yu nguzh zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na ornu bded ndeꞌ, orzeꞌ de yu nu rsyaꞌ lom mnii nu reñ dey mi. Orzeꞌ na dey: ―¿Lagu wangac loo chu̱ de̱ nuras zeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Orzeꞌ nam rab mi dey: ―Ndeꞌ par nu dzi ñuu miꞌ consuel ricy cup der lo̱. Gun rishli rne̱e̱ lo der benu ricy cup der mas ñuu miiñ consuel, mas ñuu gal nu na mbigy urnishtas, orzeꞌ gac nii der lo tub bicy nu gruu chuñ nu chañ tuubaꞌ lugaar nunu gac ñii gal nu nii der. Gun ni tub coz warusuñ nu wac ñi benu ricy cup der consuel lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tees de nuras nu ni na, yu zeꞌ waruu chuy benu i ziꞌl, sinu rlagy ñi nu cyiñ der lo Ñgyoozh, nunu ca der ni ub ru nu cueꞌ gow ru gyit lat nu rzu bich der nu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lat nu gabee rded mi tublaazh num de yu nu rsyaꞌ lom lo de yu ni Galilea, orzeꞌ Jesuuz nam rab mi dey: ―Ya̱, biñ nu byac mbecy, guꞌ dey ya̱ yaa deꞌ zir mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Orzeꞌ cut dey ya̱. Tees dzi chon gyabaña̱ ―nam. Orzeꞌ de yu nu rsyaꞌ lom, ornu güeñ dey ndeꞌ, tonaꞌ la bicy shni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na ornu Jesuuz nu de yu nu rsyaꞌ lom bri dey Capernaum, orzeꞌ de yu nu rboo tiñ por cuen ni yuꞌ nu driib zily dey Ñgyoozh bruꞌña dey lo Bed. Orzeꞌ na dey rab yuy: ―Zeꞌ masht nir, ¿a cuic yu tiñ nu dric den par cuen ni yuꞌ nu riib zily den Ñgyoozh? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Orzeꞌ na Bed: ―Cuic mi ñii ―nay. Ornu Bed guꞌy nañ yu, orzeꞌ Jesuuz mniim loga la. Orzeꞌ nam: ―¿La ñuu shcab rash ru Simo̱o̱? ¿Ca na de mbecy cyish yu tiñ ni de rey gyishlombecy ii? ¿A de yu guledz cyish yu, uti de mbecy yad? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Orzeꞌ na gaꞌ Bed: ―Laab de mbecy yad ―nay. Orzeꞌ na Jesuuz: ―Orzeꞌ de mbecy guledz, ¿a walagy ñi nu cyish dey beni? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Par nu cueꞌ gyicy na nu gazi lagy ni tub la mbecy, orzeꞌ gua ruꞌ nisyudoo. Shet lag ru duu gyedz nir nu rub bel. Orzeꞌ bel loga la nu gad nir, orzeꞌ güiir ruꞌ ma. Zeꞌ ri tub tiñ nu gal ñii nu griib ru lo rup laa den. Orzeꞌ cha nur ñii cuic ru ni dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Laab tiem zeꞌ bruꞌña de yu nu rsyaꞌ lom. Orzeꞌ na dey: ―¿Cyu nu gya zir zu lat de yu nu riib ic Ñgyoozh? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Orzeꞌ Jesuuz bredz mi tub yu nguzh miꞌ nu chay lom. Orzeꞌ bzum yu lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Orzeꞌ nam rab mi dey: ―Ya̱ rishli rne̱e̱ lo der, benu wachaa der mod nu ricy ru, nunu benu wash der mod nu na gal nu na yu nguzh ii, orzeꞌ wac chuꞌ der lat de yu nu riib ic Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mbecy nu gya zir zu lat de yu nu riib ic Ñgyoozh, yu zeꞌ yu nu gyicy gyel gyidz ni. Nunu yu zeꞌ yu nu gyac gal nu na yu nguzh miꞌ ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ca ziꞌl na mbecy nu shet ic yu nu gac nuy tub yu nguzh miꞌ gal nu na yu ii, orzeꞌ niꞌ pshet ic yu nu gac nuy ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Orzeꞌ na gaꞌ Jesuuz: ―Cyu ziꞌl mbecy nu gyicy nu gnu tub mbecy shni nu ricy cup consuel lo̱, nap zir nu cyiig dey tub gyitaꞌ gyech ily nu rdugu yeñ yu. Gazeꞌ nu shet lag dey yu lo nisyudoo par nu gat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Dzi ga cuaa de mbecy gyishlombecy ii nu ricy dey nu rnu losaꞌy! Gun segur la yuꞌ coz nu ricy ñi nu ricy mbecy cyi, tees ¡cuaa mbecy nu rlyuu coz cyi lo losaꞌ! ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ndeꞌ nu benu tub yaar o tub gyiꞌr gyicy ñi nu gyicy ru cyi, orzeꞌ nap zir nu cyug ru ñii nunu neꞌr ñii gun nap zir nu gzur nu tuꞌnc tub yaar o nu tuꞌnc tub gyiꞌr, gazeꞌ nu shet lag Ñgyoozh dutuub la cuerp nir lo gyi nu rila wayu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nunu benu tub urlor gyicy ñi nu gyicy ru cyi, orzeꞌ cor ñii, nunu neꞌr ñii, gun nap zir nu gzur nu tub zi urlor gazeꞌ nu gyet lag ru lo gyi ni gabily nu rup laa urlor ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Orzeꞌ na gaꞌm: ―Orzeꞌ cueꞌ güii naañ der lo de mbecy nu na gal nu na de yu nguzh miꞌ ii. Gun gyibaa zaab zu la de anc ni dey lo Ñgyoozh, uz na, biñ nu zub gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gun ya̱ biñ nu byac mbecy, yapa̱ nu loo mbaña̱ de mbecy bduneꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Lac ñuu rzii der? Zeꞌ benu tub mbecy zu tub gaynal shily niy, orzeꞌ duneꞌ tub ma niy, ¿a walab nu zeeñ yu nobent zub gaa ma logyiꞌ, orzeꞌ cha yub yu tub bañ nu bduneꞌ zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gun ya̱ rishli rne̱e̱ lo der, benu gyicy yu gan nu gyad ma niy, orzeꞌ gyet zir lagy yu nu nac tub ma zeꞌ, gazeꞌ nu nac nobent zub gaa bañ nu wantuneꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Niꞌ ziꞌl mod ricy Ñgyoozh, uz den, biñ nu zub gyibaa. Walagy mi nu duneꞌ ni tub mbecy nu na gal nu na de yu nguzh miꞌ ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Orzeꞌ na gaꞌm: ―Zeꞌ benu ca na tub losaꞌr shiñ ricy nuy ru, orzeꞌ gua ub ziꞌl ru loy. Ornu ub ziy, orzeꞌ niir loy la na falt niy. Zeꞌ benu zuub gyidag yu nir, orzeꞌ bicy ru gan bzu nap ruy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Zeꞌ benu wazuub gyidag yu nir, orzeꞌ cuedz ru sa tub o sa cyup losaꞌr nu cha nur loy. Gun orzeꞌ gac cyup o chon teshtig nu gyeñ dey de coz nu gniir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tees benu wazuub gyidag yu ni de yu zeꞌ, orzeꞌ gua niir lo de mbecy ni Ñgyoozh ornu yuꞌ tublaazh dey. Orzeꞌ benu wangyeñ yu ni dela mbecy zeꞌ, orzeꞌ gyicy der yu par tub mbecy nu walab mbecy ni Ñgyoozh, o par tub mbecy nu rteꞌ tiñ por cuen ni gubier Rom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ya̱ rishli rne̱e̱ lo der: lac ziꞌl mod nu ricy mbecy, benu de ru niir gashtal gyishlombecy ii nu walab ni rlagy ñi, orzeꞌ niꞌ ziꞌl gashtal gyibaa walab ni rlagy ñi nii Ñgyoozh. Nunu la ziꞌl coz nu de ru niir gashtal gyishlombecy ii nu laab ni, orzeꞌ niꞌ ziꞌ laab ni nii Ñgyoozh gashtal gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Nunu ne̱e̱ ga̱ꞌ lo der: benu cyup der tub ziꞌl riidz nu gniir ornu cyiñ der lo Ñgyoozh, uz der, biñ nu zub gyibaa, orzeꞌ gyicy mi gal nu rlagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gun ca ziꞌl zeꞌ nu gyatublaazh cyup der o chon ru nu nac ya̱, zeꞌ zu̱ lat der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Orzeꞌ bruꞌña Bed lo Jesuuz. Orzeꞌ nay rab yum: ―Shuaan de̱, ¿la be tir rlagy ñi nu gyicy sulagya̱ ni losa̱ꞌ ornu shiñ gyicy nuy ya̱? ¿A mas ñuu gagy tir? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Orzeꞌ na Jesuuz rab mi Bed: ―Walab nu rne̱e̱ nu gagy ziꞌl tir gyicy sulagy ru ni losaꞌr, sinu gashtal gagy tir nu setent gyicy sulagy ru ni losaꞌr ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ndeꞌ nu mod nu rac nu gyel gubier ni Ñgyoozh, ndeꞌ nañ gal nu na mod nu rac nu tub rey. Rey zeꞌ ngulagy yu nzaꞌ loy ni de coz nu ca lo cuen ni de moz niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Saa la brugyiꞌy nu rzaꞌ loy nu de moz niy ornu bruꞌña nu dey tub yu nu zaab bee miyo̱o̱ la niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Orzeꞌ como moz zeꞌ sac la tiñ niy par nu gyabic yu ni rey zeꞌ, orzeꞌ rey zeꞌ mniiy nu saꞌy moz zeꞌ nu mñaay nu de yu nguzh niy nu dela suuy par nu gad tiñ nu cyish yu dela diꞌñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Orzeꞌ moz zeꞌ gusu tib yu lo rey zeꞌ. Orzeꞌ nay rab yuy: “Cua̱a̱ ya̱, bicy cup ñuu pase̱z ne̱. Ya̱ grish gulya̱ dela ndeꞌ nir”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Orzeꞌ rey zeꞌ gushni lagy yuy. Orzeꞌ bicy sulagy yu ni moz zeꞌ ni dela diꞌñ yu. Orzeꞌ blaay yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Na ornu moz zeꞌ bruuy roꞌ rey zeꞌ yay, orzeꞌ bdzeel yu losaꞌ moz yu, tub yu nu zaab ñuu miꞌ tiñ niy. Orzeꞌ bduꞌ yaay ngüe̱z yu. Orzeꞌ brugyiꞌ rsi̱i̱y yeñ yu. Orzeꞌ nay rab yuy: “Gyabic ru tiñ nu zaab ru zeꞌ ne̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Orzeꞌ losaꞌ moz yu zeꞌ gusu tib yu loy. Orzeꞌ nay: “Bicy cup ñuu pase̱z ne̱. Gazeꞌ gyabica̱ delañ nir”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tees yu zeꞌ wangalagy yu gyicy cup yu pase̱z ni losaꞌy, sinu mniiy nu cha yu zeꞌ nañ yuꞌ gyiib gashtal cuaa lay dela nu zaab yu niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na ornu bzaac deꞌ zir moz de coz nu guc, orzeꞌ tonaꞌ la deet guc nañ lardoo dey. Orzeꞌ gua too dey rishlo rey dela coz nu guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Orzeꞌ rey zeꞌ bredz yu moz zeꞌ nu chay loy. Orzeꞌ nay rab yuy: “¡Ru mbecy a̱ꞌ nap! Ya̱ bicy sulagya̱ nir ni dela diꞌñ ru gun mnishbaar lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Orzeꞌ niꞌ ru rlagy ñi nu ñgyashni lagy ru losaꞌr gal nu ya̱ gushni lagya̱ ru”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Orzeꞌ tonaꞌ la guzi lagy rey zeꞌ. Orzeꞌ bzeed yu moz zeꞌ lo cashtig gashtal cuaa lay dela diꞌñ yu ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Orzeꞌ na gaꞌm: ―Niꞌ ziꞌl gyicy Ñgyoozh, uza̱, biñ nu zub gyibaa, nu de ru benu wayicy sulagy der ni losaꞌr nañ lardoor ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ornu blazh mnii Jesuuz de riidz zeꞌ, orzeꞌ bruum lo de yu ni Galilea zam par lo de yu ni Judea nu ri tub laꞌ gaꞌ dzu gyoow Jordaang. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Orzeꞌ tonaꞌ la mbecy zigy gua ca dey ich mi. Orzeꞌ zeꞌ bicy yac mi zañ mbecy rat. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Orzeꞌ bruꞌña la be de mbecy fariseo par nu gyicy dey preb mi. Gazeꞌ nu na dey rab yum: ―¿A nap zuñ par lo leey ni Moisees nu gac zaan mbecy mñaay nu nac la ziꞌl gyiꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Orzeꞌ na Jesuuz rab mi dey: ―¿Walab gaal nigul syaꞌ der de riidz ni Ñgyoozh, zeꞌ nu rniiñ nu nese nu bzub gyiꞌ gyishlombecy Ñgyoozh psaꞌ lagy mi tub yu gyeey nu tub biñ mñaa? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Niꞌ ziꞌl rniiñ nu de yu gyeey zeeñ dey uz yu nu ñaay par nu gyatublaazh yu nu mñaay. Orzeꞌ lo cyup dey gyac yu se tub zi mbecy, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ndeꞌ nu walabaꞌ cyup dey nac yu sinu se tub ziy. Ndeꞌ nu ni tub la mbecy wac gyicy yu nu glaꞌ losaꞌ cyup mbecy, benu bi nac dey mbecy nu bi bicy tublaazh Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Orzeꞌ na de mbecy fariseo zeꞌ rab yum: ―Benu ni, ¿lagu mnii Moisees nu co mbecy gyicy rishbeey nu gzaan dey mñaay, orzeꞌ gzu nez yum gyam? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Orzeꞌ na Jesuuz rab mi dey: ―Laab par nu dzi zed lo der, ndeꞌ nu Moisees briic yu rishbeey nu zaan der mñaar. Tees nese nu bzub gyiꞌ gyishlombecy walab ni mod rlagy ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya̱ rne̱e̱ lo der nu cyu ziꞌl mbecy nu coy gyicy nu zaan yu mñaay, benu walab nu nac nu shiñ bicy mi nu reñaꞌ yu gyeey, orzeꞌ chelaay tuubaꞌ biñ mñaa, orzeꞌ yu zeꞌ ricy yu cyi nu wangyicy paay nu mñaay. (Nunu cyu ziꞌl mbecy nu gash tub biñ mñaa nu bzaan ñgyee, orzeꞌ yu zeꞌ niꞌ ziꞌl ricy yu cyi par lo Ñgyoozh nu gul yu mñaa losaꞌy) ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Orzeꞌ de yu nu rsyaꞌ lom nay rab yum: ―Benu ni rac nu tub yu gyeey nu mñaay, orzeꞌ nap zir nu cueꞌ chelaan ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Orzeꞌ na Jesuuz rab mi dey: ―Par walab dela mbecy gac gyicy yac yu de riidz nu mnii der zeꞌ, tees de yu nu locyuub Ñgyoozh ziꞌl nu gac gzu laay ub ziy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gun zañ coz gyicy ñi nu wacyiiñ mbecy nu chelaay. Gun yuꞌ mbecy nil nese nu gul laay wacyiiñ yu nu chelaay. Zeꞌ yuꞌ gaꞌ dey, mbecy bicy yu nu wacyiiñ yu nu chelaay. Zeꞌ yuꞌ gaꞌ mbecy ricy yu nu wacyiiñ yu nu chelaay nu nac gyel gubier ni Ñgyoozh. Benu ca na mbecy gac gyicy yu nu cueꞌ chelaay, orzeꞌ gac gyicy yuñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Orzeꞌ la be mbecy bruꞌña nu dey de yu nguzh lo Jesuuz par nu gal yaam dey nunu cyiñ mi lo Ñgyoozh ni dey. Orzeꞌ de yu nu rsyaꞌ lom bdzaꞌ dey ni de mbecy nu bruꞌña nu de yu nguzh zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Orzeꞌ na Jesuuz rab mi dey: ―Bzaan der gyechaꞌ de yu nguzh lo̱. Cueꞌ niir lo dey nu ruu chuy. Gun lugaar zeꞌ nu riib ic Ñgyoozh, ndeꞌ lugaar nu yuꞌ mbecy nu na gal nu na de yu nguzh ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Orzeꞌ gul yaam de yu nguzh zeꞌ. Orzeꞌ bruum lugaar zeꞌ zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tub tir gua tub yu feñ lo Jesuuz. Orzeꞌ nay rab yum: ―Masht nap, ¿la ñuu coz nap rlagy ñi nu gyicya̱ par nu cui mbaña̱ tub la? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Orzeꞌ na Jesuuz rab mi yu: ―¿Lagu rnii gaꞌ ru nu nap ya̱? Se cyuꞌ zir nu nap sinu tub zi la Ñgyoozh. Benu rlagy ru gad gyel mbañ nir, orzeꞌ rlagy ñi gyicy yac ru nu de riidz nu rnii Ñgyoozh lo de mbecy nu gyicy yac dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Orzeꞌ na yu feñ zeꞌ: ―¿Ca na de riidz nu rzat ru zeꞌ? ―nay. Orzeꞌ na Jesuuz: ―Cueꞌ cut ru losaꞌr. Cueꞌ gal ru mbecy nu wanchelaar. Cueꞌ gyicy ru gubaan. Cueꞌ riib ru gyidza too losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pca lagy lo uz ru nunu pca lagy lo ñaar, nunu pca losaꞌr gal nu rcar ub ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Orzeꞌ na yu feñ zeꞌ: ―Dela ndeꞌ bi bicy yaca̱ ñii. ¿Laꞌ zir coz rlagy ñi nu gyicya̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Orzeꞌ na Jesuuz rab mi yu: ―Benu rlagy ru gac ru mbecy nu zu gal mod nu rlagy Ñgyoozh, orzeꞌ yaa cut ru dela coz nu yuꞌ nir. Gazeꞌ nu tiñ zeꞌ cuic ru ni de mbecy zi. Orzeꞌ gyibaa gyad gyel nap nir. Nunu cyid ru nu cyid car icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na ornu güeñ yu feñ zeꞌ de riidz zeꞌ, orzeꞌ tonaꞌ la bicy shniy. Orzeꞌ yay. Gun tonaꞌ la yuꞌ gyel nap niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Orzeꞌ Jesuuz nam rab mi de yu nu rsyaꞌ lom: ―Ya̱ rishli rne̱e̱ lo der nu tonaꞌ la biigy nu chuꞌ tub guaniꞌñ lat de mbecy nu riib ic Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nunu ne̱e̱ ga̱ꞌ lo der nu a̱ꞌ biigy zir nu ded tub camey gyeegy gyiꞌ tub gyishtiib gazeꞌ par nu chuꞌ tub mbecy guaniꞌñ lat de mbecy nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na ornu güeñ de yu nu rsyaꞌ lom ndeꞌ, orzeꞌ tonaꞌ la za nu ic dey. Orzeꞌ brugyiꞌ rnii dey: ―Zeꞌ benu ni, ¿cyu gac gruu mbañ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Orzeꞌ Jesuuz bgüiim lo dey. Orzeꞌ nam rab mi dey: ―Par de mbecy, rila wac gyicy dey ndeꞌ. Tees Ñgyoozh gac gyicy mi dela coz ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Orzeꞌ na Bed rab yum: ―Zeꞌ de̱ ya̱ bzeeñ de̱ dela coz nu yuꞌ ne̱ de̱ nunu yap ca̱ de̱ ich ru. Orzeꞌ ¿la ñuu coz gad ne̱ de̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Orzeꞌ Jesuuz nam rab mi dey: ―Ya̱ rishli rne̱e̱ lo der, ornu shuub tiem nu bi zu nap dela coz, ornu ya̱ biñ nu byac mbecy, chesuba̱ nu gyub ica̱ zeꞌ nu yuꞌ gyel lily ne̱, orzeꞌ de ru mbecy nu yad ca icha̱ niꞌ chesub der lo trocyup yashily par nu gri bee der ni de trocyup nac nez mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nunu dela de mbecy nu bzeeñ coz ni nu nac ya̱, de yu nu bzeeñ yuꞌ, de yu nu bzeeñ bicy, de yu nu bzeeñ zan, de yu nu bzeeñ uz, de yu nu bzeeñ ñaa, de yu nu bzeeñ iꞌñ, de yu nu bzeeñ yu ni, de yu zeꞌ tub gaynal tant nu sheñ zir gyad niy nunu gad nu cui mbañ yu lo Ñgyoozh tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tees zigy de mbecy nu gya zir zu na, de yu zeꞌ gyac yu yu nu gash zir zu par lo. Zeꞌ zigy de mbecy nu gash zu na, de yu zeꞌ gyac dey mbecy nu gya zir zu par lo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Orzeꞌ na gaꞌ Jesuuz: ―Mod nu rac nu gyel gubier ni Ñgyoozh, ndeꞌ nañ gal nu na mod nu guc nu tub mbecy nu bicy cup tub nac lyucy urbyay. Tub or napor bruuy yuꞌy guay gua yub yu moz nu gyicy yu riiñ lat lyucy urbyay niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Orzeꞌ bzaꞌ lo nuy dey nu cyish yu tub tiñ plat ni dey tub dzi ga. Orzeꞌ bzeed yu dey zay gyicy yu riiñ lat lyucy urbyay niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na tub gyiib gaa or napor bruuy guay lat yagyiꞌ tuubaꞌ tir. Orzeꞌ bzaac yu la be mbecy nu zu nat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Orzeꞌ nay rab yu de mbecy zeꞌ: “Niꞌ de ru gua der gyicy ru riiñ lat lyucy urbyay ne̱, nunu grisha̱ꞌ ni der ca na nu yad ñi”, nay. Orzeꞌ de yu zeꞌ gua dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na tub or wi doo niꞌ ziꞌl bicy yu. Na tub gyiib chon or gudze, niꞌ ziꞌl bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na ornu sñuu ga gyap or gyiib gaay, orzeꞌ bish cya gaꞌy lat yagyiꞌ. Orzeꞌ byapaꞌy tub nacaꞌ moz yuꞌ nat yu. Orzeꞌ nay rab yu dey: “Zeꞌ ¿lagu ni yuꞌ der ii? ¿Gua la dzi wangyicy der riiñ?” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Orzeꞌ na de moz zeꞌ: “Ndeꞌ gun ni tub la mbecy wancuic yu riiñ nu gyicy de̱”, na dey. Orzeꞌ na gaꞌy rab yu dey: “Niꞌ de ru gua der gyicy ru riiñ lat lyucy urbyay ne̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Na or becheñ, orzeꞌ na yu nu guni lyucy urbyay zeꞌ rab yu yu nu riib ic de moz: “Bredz de moz nu gyatublaazh dey. Orzeꞌ gyabic ru i dey. Nu loga la gyabic ru i de yu nu guꞌ lo riiñ or gudze. Orzeꞌ gazeꞌ nu gyabic ru i de yu nu guꞌ lo riiñ nese or napor”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Orzeꞌ brugyiꞌ rgyish yu ni de yu nu guꞌ lo riiñ gyiib gaay or gudze nu tub ga tiñ plat. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na ornu bdugyi de yu nu guꞌ lo riiñ or napor nu gyash niy, orzeꞌ mnii too dey nu sheñ zir gyad niy. Tees niꞌ ziꞌl byabic yu ni dey tub ga ziꞌl tiñ plat. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na ornu byad i dey, orzeꞌ brugyiꞌ rnid ruꞌ dey nu rzat zi dey yu nu guni lyucy urbyay zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Orzeꞌ na dey rab yu yu nu guni lyucy urbyay zeꞌ: “De yu nu bruꞌña or gudze se tub or zi bicy yu riiñ. Zeꞌ de̱ ya̱ gua la dzi gugye̱e̱ de̱ lo riiñ, nunu gua la dzi taꞌ de̱ lo ba”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tees yu nu guni lyucy urbyay zeꞌ nay rab yu tub de yu zeꞌ: “A̱ cue, par ya̱ walab nu bicy ras du̱ ru. ¿A walab nu bzaꞌ lo du̱ ru nu grisha̱ tub tiñ plat nir par tub dzi?” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Nap zir O la mnii. Yaa la, yaa nu ca na la nu bi guud nir, gun ya̱ rlagya̱ risha̱ ni yu nu bruꞌña or gudze niꞌ ziꞌl gal nu brisha̱ ni ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A walab seꞌñ benu ya̱ gyicya̱ ca na la nu yad ica̱ nu tiñ ne̱? ¿O ti rasaap lagy ru nu ya̱ naca̱ mbecy nap lagy?” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Ndeꞌ nu de mbecy nu gash zu na, de yu zeꞌ gyac yu mbecy nu gya zir zu. Zeꞌ de mbecy nu gya zu na, de yu zeꞌ gyac yu mbecy nu gash zir zu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Orzeꞌ lat nu rca Jesuuz zam par Jerusaleeng, za nu reñ mi de trocyup yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Gal nu de ru rzac ru, rcan zan par Jerusaleeng. Orzeꞌ guꞌ dey ya̱, biñ nu byac mbecy, yaa de uz zub lo gal nu yaa de yu nu rlyuu leey nu bzeeñ Moisees. Orzeꞌ nii dey nu rlagy ñi nu gata̱ nu yuꞌ falt ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Gazeꞌ nu guꞌ dey ya̱ yaa de mbecy yad par nu gubdzaa dey ya̱, nunu gaaz dey ya̱ nu cuart nunu caa dey ya̱ lo cruuz. Tees dzi chon gyabaña̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Orzeꞌ bruꞌña ñaa de iꞌñ Zebedeo lom. Bruꞌña num de iꞌñ mi. Orzeꞌ gusub tib mi lo Jesuuz par nu bdiiñ mi tub faboor lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Orzeꞌ na Jesuuz rab mi biñ mñaa zeꞌ: ―¿La coz rlagy ru? ―nam. Orzeꞌ na biñ mñaa zeꞌ: ―Ya̱ rlagya̱ nu ornu bi riib ic ru, orzeꞌ gyicy ru mandaar nu tub iꞌña̱ gzub ñi par yaa beer, Zeꞌ tuubaꞌñ gzub ñi par yaa reg ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Orzeꞌ na Jesuuz: ―De ru wagad lagy der la coz rgyiiñ ru lo̱. ¿A gagye de ru nu gzuub ruꞌr taz nu gzuub dey ru̱ꞌ? ―nam. Orzeꞌ na dey: ―Gac gagye̱ de̱ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Orzeꞌ na gaꞌm rab mi dey: ―Rishli gaal taz nu zuub dey ru̱ꞌ ya̱, laabaꞌ ndeꞌ zuub dey ruꞌ de ru. Tees par nu gzub der par yaa be̱e̱ o par yaa rega̱, ndeꞌ walab cuen ne̱ ya̱ nu gyicya̱ ñii du̱ der; sinu de lugaar zeꞌ, ndeꞌ par de yu nu bi pcui Ñgyoozh, uz den ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na ornu güeñ se tii gaꞌ de yu nu rsyaꞌ lom zeꞌ, orzeꞌ bdzaꞌ dey ni cyup de yu zeꞌ nuy bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Orzeꞌ Jesuuz bredz mi dey. Orzeꞌ nam: ―De ru rad lagy der nu de mbecy nu ricy gyel gubier ni reñaꞌ lugaar, dzi ricy dey gyel lily niy nu de mbecy shni. De mbecy zub lo zaab ricy lay mandaar dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tees lat de ru walab ni mod rlagy ñi. Zeꞌ benu ca na tub mbecy nu ri lat der rlagy yu nu gac yu tub yu lily, orzeꞌ rlagy ñi nu gyicy yu coz nu rlagy deꞌ zir losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nunu benu ca na tub yu nu ri lat der rlagy yu gac yu mbecy zub lo, orzeꞌ rlagy ñi nu gyicy yu de coz nu galagy ñi ni deꞌ zir losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndeꞌ nu niꞌ ziꞌl mod ya̱, biñ nu byac mbecy, a̱ꞌ yapa̱ nu gyicy mbecy coz nu rlagya̱, sinu par nu gyicya̱ coz nu rlagy mbecy nunu par nu gata̱, gun grisha̱ nu gruu zigy mbecy lo cashtig ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na ornu bruum gyedz Jericó, orzeꞌ tonaꞌ la zigy mbecy za ca dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na zu cyup mbecy lo caꞌ gusub dey cuit nez nu zam. Ornu güeñ dey nu yad mi, orzeꞌ brugyiꞌ rbish ti dey. Orzeꞌ na dey: ―¡Jesuuz nez Dabi, gushni ñuu lagy de̱ ya̱! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Orzeꞌ de mbecy zigy bdzaꞌ dey niy, nunu mnii dey nu cueꞌ cush ti dey. Tees de yu zeꞌ rbish ti gaꞌ zir dey. Orzeꞌ na dey: ―¡Jesuuz nez Dabi, gushni ñuu lagy de̱ ya̱! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gazeꞌ nu gusu Jesuuz. Orzeꞌ bredz mi de lo caꞌ zeꞌ. Orzeꞌ nam rab mi dey: ―¿La coz rlagy der nu gyicya̱ du̱ de ru? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Orzeꞌ na dey: ―De̱ ya̱ rlagy de̱ nu gyanap urlo de̱ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Orzeꞌ Jesuuz gushni lagy mi dey. Orzeꞌ gul yaam urlo dey. Orzeꞌ laab or la zeꞌ byanap urlo dey. Orzeꞌ za ca dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ornu bruꞌña dey gyiꞌ bicy ni ya Oliva gaab ga Betfagé, tub gyedz nu ri gaab ga Jerusaleeng, orzeꞌ Jesuuz bzuu nez mi cyup de yu nu rsyaꞌ lom nu cha ga dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Gazeꞌ nu nam rab mi dey: ―Gua der gyedz nu ri gal dzu re. Orzeꞌ re gyap der tub bur gus ca cuñ ma nu tub bur miꞌ ni ma. Orzeꞌ shaagy der ma cyid nur de ma lo̱ ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Benu ca na mbecy niiy lo der nu lagu, orzeꞌ nii der: “Shuaan na cyiiñ ma nim. Gazeꞌ nu lueg la tush cya gaꞌm ma”, nii der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ni guuc ñi par nu byuꞌ niñ gal nu pcaa tub yu nu mnii por cuen ni Ñgyoozh ornu pcaay: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mnii der lo de mbecy gyedz Sión, orzeꞌ nii der: “Güii, yad rey ni der lor. Nac mi tub mbecy shni. Riib mi tub bur miꞌ, tub bañ nu nac iꞌñ tub bur yuu.” Ni pcaa tub yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Orzeꞌ de yu nu rsyaꞌ lom gua dey bicy yu gal nu mniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Orzeꞌ gua nu dey bur gus zeꞌ nu bur miꞌ ni ma lom. Orzeꞌ briib dey shab yu ich bur miꞌ zeꞌ. Orzeꞌ gutib Jesuuz ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nunu tonaꞌ la mbecy zigy yuꞌ zeꞌ. Yuꞌ dey pcuaay shab yu gyernez. Yuꞌ gaꞌ dey pshiñ yu yaa yag nu pcuaay gyernez. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Orzeꞌ dela mbecy nu zub lo lom, gal nu de yu nu zaab par ich mi brugyiꞌ rbish ti dey. Orzeꞌ na dey: ―¡Dzi ga zily nac biñ nu bruu lat nez rey Dabi! ¡Ñgyoozh nac num ru, biñ nu bzuꞌ nez mi! ¡Dzi ga zily nac Ñgyoozh, biñ nu gya zir zu! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na ornu Jesuuz guꞌm lat gyedz Jerusaleeng, orzeꞌ dela mbecy se nu ryach ziꞌl dey. Orzeꞌ brugyiꞌ rgugyiꞌ dey lo losaꞌy: ―¿Zeꞌ cyu ndeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Orzeꞌ na de mbecy: ―Yu zeꞌ Jesuuz, tub yu nu rnii por cuen ni Ñgyoozh, yu nu bruu Nazaret, tub gyedz nu ri lo yu ni Galilea ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Orzeꞌ Jesuuz guꞌm loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh. Orzeꞌ bloom de yu nu nguaa rut zeꞌ gal nu de yu nu rzii nañ yuꞌ zeꞌ. Orzeꞌ ptush cyam mez ni de yu nu rtich tiñ, gal nu yashily ni de yu nu rut begy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Orzeꞌ nam rab mi dey: ―Ñgyoozh nam lat riidz nim: “Yuꞌ ne̱ gruu lañ yuꞌ nu gnii nu mbecy ya̱”, nam. Zeꞌ de ru ricy der ñii nu nañ gal nu na tub blyuu ni gubaan ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Orzeꞌ bruꞌña de mbecy lo caꞌ nu de mbecy coj lo Jesuuz loliꞌ ni yuꞌ zeꞌ. Orzeꞌ bicy yac mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tees de uz zub lo gal nu de yu nu rlyuu leey nu bzeeñ Moisees bzaac dey de nusuriidz nu bicy mi. Nunu güeñ dey nu dzi rbish ti de yu nguzh nu yuꞌ zeꞌ. Orzeꞌ na de yu nguzh zeꞌ: “¡Dzi ga zily nac biñ nu bruu lat nez rey Dabi!” na dey. Orzeꞌ de uz zeꞌ nu de yu nu rlyuu leey zeꞌ tonaꞌ la guzi lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Orzeꞌ na dey rab yum: ―¿A wagyeñ ru de coz nu rbish ti de yu nguzh zeꞌ? ―na dey. Orzeꞌ na Jesuuz rab mi dey: ―A̱, reña̱. ¿A walab gaal nigul syaꞌ de ru lat riidz ni Ñgyoozh zeꞌ nu rniiñ: Ñgyoozh, ru bicy ru nu ruꞌ de yu nguzh gal nu ruꞌ de mdoo driib nu rbish ti dey nu ryabic dey gyel mbecy nir mod nu nap, rniiñ? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Orzeꞌ bzeeñ mi dey bruum zam gashtal gyedz Betania. Zeꞌ bechem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na ornu bzaꞌ yu, orzeꞌ gush nez mi ya gaꞌm par Jerusaleeng. Orzeꞌ briib nu ran mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Orzeꞌ bzaac mi tub ya las zub ñi cuit nez. Orzeꞌ gush nez mi zam looñ. Tees ni tub uugy wangyap mi looñ. Nomaas lyag ziꞌl taꞌ niñ. Orzeꞌ nam rab mi ya las zeꞌ: ―¡Bee dzi na par lo rila wazacaꞌ lor nu cuic ru uugy! ―nam. Orzeꞌ lueg la guwach ya las zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na ornu bzaac de yu nu rsyaꞌ lom tonaꞌ la za nu ic dey. Orzeꞌ bdugyiꞌ dey lo Jesuuz: ―¿Lagu nu dzi dzach guwach ya las re? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Orzeꞌ nam rab mi dey: ―Ya̱ rishli rne̱e̱ lo der benu ricy cup der consuel lo̱, nunu benu cueꞌ gyicy cyup ic der, walab nu tub lo ziꞌl nu i gyicy nu der ya las, sinu niꞌ gac nii der lo tub bicy re: “Bruu chu. Gua gyet lag ru lo nisyudoo re”, niir, nunu ni gac ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nunu benu de ru gyicy cup der consuel ornu cyiñ der de coz nu rlagy ru lo Ñgyoozh, orzeꞌ gad ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na ornu bri Jesuuz Jerusaleeng, orzeꞌ guꞌm loliꞌ ni yuꞌ nu driib zily de mbecy Ñgyoozh. Lat nu zum rlyuum ni de mbecy, orzeꞌ bruꞌña de uz zub lo gal nu de yu bel ni de mbecy Israeel. Orzeꞌ bdugyiꞌ dey lo Jesuuz. Orzeꞌ na dey rab yum: ―¿La na rishbeey ricy cup ru nu ricy ru de coz ii? ¿Cyu briic rishbeey zeꞌ nir? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Orzeꞌ na Jesuuz rab mi dey: ―Niꞌ ya̱ dugyi̱ꞌ tub coz lo der. Benu tush cya der ñii, orzeꞌ niꞌ ya̱ ne̱e̱ lo der la na rishbeey ricy cupa̱ nu ricya̱ de coz ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Cyu bzuu nez Waa nu biid yu nu briib nis yu mbecy? ¿A Ñgyoozh bzuu nez mi yu uti mbecy? ―nam. Gazeꞌ nu brugyiꞌ ro dey riidz nu losaꞌy. Orzeꞌ na dey: ―Benu niin nu Ñgyoozh bzuu nez mi yu biid yu, orzeꞌ nii Jesuuz gab yu de ub na: “Zeꞌ ¿lagu wancheña lagy der de riidz nu mniiy beni?” gniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Zeꞌ benu gniin nu mbecy bzuu nez yuy, orzeꞌ dzib na lo de mbecy, gun dela mbecy ricy dey Waa par tub yu nu mnii por cuen ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Orzeꞌ na dey rab yu Jesuuz: ―Wagad lagy de̱ ―na dey. Orzeꞌ nam rab mi dey: ―Niꞌ ya̱ wane̱e̱ lo der la na rishbeey ricy cupa̱ nu ricya̱ de coz ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Orzeꞌ na Jesuuz rab mi dey: ―¿La ñuu shcab gash der ni tub riidz nu gne̱e̱ lo der na? Zu tub mbecy. Zu cyup iꞌñ yu. Orzeꞌ guay lo iꞌñ yu, yu gush zeꞌ. Orzeꞌ nay rab yuy: “Gua gyicy ru riiñ lat lyucy urbyay ne̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Orzeꞌ na yu feñ zeꞌ rab yu uz yu: “¡Waya̱!” nay. Tees despuees bdza shcab niy. Orzeꞌ guay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Orzeꞌ mbecy zeꞌ guay lo tuubaꞌ iꞌñ yu. Orzeꞌ niꞌ ziꞌl mniiy. Orzeꞌ na yu feñ zeꞌ rab yu Uz yu: “O. Ya̱ cha̱”, nay. Tees wanchay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Orzeꞌ ca na lo cyup de yu feñ zeꞌ bicy yu coz nu rlagy uz yu? ―na Jesuuz. Orzeꞌ na dey rab yum: ―Yu feñ loga zeꞌ bicy yu coz nu rlagy uz yu ―na dey. Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der gashtal de yu nu rteꞌ tiñ por cuen ni gubier Rom, gal nu de biñ congal, de yu zeꞌ chuꞌ dey lat de mbecy nu riib ic Ñgyoozh anzir nu chuꞌ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gun Waa nu briib nis mbecy biid yu nu blyuuy ni der nu lac gyicy der nu chuꞌr nu mod nu seꞌñ, tees de ru wancheña lagy der niy. Zeꞌ de yu nu rteꞌ tiñ por cuen ni gubier Rom, gal nu de biñ congal guña lagy dey ni Waa. Tees de ru mas bzaac der de nu ndeꞌ, tees wanneꞌ der de cyi nu ricy ru par nu ñgyeña lagy der de coz nu mniiy ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Bzuub gyidag der tuubaꞌ riidz tiily ii: Tub shuaan tub nac yu mnuuz yu tub nac lyucy urbyay. Gazeꞌ nu bduꞌy loꞌ dub yub la ruꞌñ. Orzeꞌ bzaay tub zo nu dushu̱u̱ de urbyay zeꞌ. Nunu bzaay tub zeꞌ nu gya. Orzeꞌ too zeꞌ bzuub yu tub yuꞌ nu duña de lyucy urbyay zeꞌ. Gazeꞌ nu bzeeñ yuñ yaa mbecy nu nuuz dey coz cyaal. Gazeꞌ nu gush nez yu zay tub lugaar zet. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na ornu byap tiem nu dulag urbyay zeꞌ na, orzeꞌ shuaan urbyay zeꞌ bzuu nez yu la be moz niy zay lo de yu nu mnuuz coz cyaal zeꞌ nu gyabicy yu ca na nu bdugyi yu nu guni yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tees de yu nu mnuuz coz cyaal zeꞌ pshet yaa dey de moz zeꞌ. Tub yu bgaaz dey yu. Tuubaꞌy biit dey yu. Zeꞌ tuubaꞌy bgoow gyitaꞌ dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Orzeꞌ shuaan lyucy urbyay zeꞌ bzeedaꞌy tub nacaꞌ moz. Zañ zir yu bzeed yu byaj cyup gazeꞌ nu loga, tees de yu zeꞌ niꞌ ziꞌl mod bicy nu dey de moz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Na despuees ni de nu ndeꞌ, orzeꞌ bzeed lay ub la iꞌñ yu. Orzeꞌ mnii tooy: “Ca gaal lagy dey lo iꞌñ na”, mnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tees ornu bzaac de mbecy nu mnuuz coz cyaal zeꞌ, iꞌñ shuaan lyucy urbyay zeꞌ, orzeꞌ na dey rab yu losaꞌy: “Yu re gyiyeeñ nuy gyel nap ni uz yu. Na yaa der chan dut nay. Orzeꞌ de ub na gyiyeeñ dun de gyel nap niy”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Orzeꞌ pshet yaa dey yu nunu bloo dey yu lat lyucy urbyay zeꞌ. Orzeꞌ biit dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Zeꞌ na ornu cyid shuaan lyucy urbyay zeꞌ, ¿la gyicy nuy de yu nu mnuuz coz cyaal zeꞌ rsaꞌ lagy der? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Orzeꞌ na dey: ―Waded la cut yu de mbecy wagat lo zeꞌ. Orzeꞌ cuic yu de lyucy urbyay zeꞌ ni reñaꞌ mbecy, gun orzeꞌ tiem ni de nu ndeꞌ glew dey ñi gal nu yad ñi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Orzeꞌ na gaꞌm rab mi dey: ―¿A rila nigul syaꞌ de ru lat de riidz ni Ñgyoozh zeꞌ nu rniiñ: Gyitaꞌ nu mneꞌ de biryu byac ñi gyitaꞌ nu ricy zir ñi presis; nii tub coz nu ricy Ñgyoozh nunu ndeꞌ tonaꞌ la cyit par de ub na, rniiñ? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ndeꞌ nu ya̱ rne̱e̱ lo der nu Ñgyoozh gyicy mi nu gruu gyel gubier nim yaa de ru. Orzeꞌ gyuꞌñ yaa reñaꞌ mbecy, de yu nu gyicy paa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Cyu ziꞌl mbecy nu gyes saa lo gyitaꞌ zeꞌ, orzeꞌ gzug lay. Zeꞌ benu gyitaꞌ zeꞌ gyet lag ñi too ca na mbecy, orzeꞌ gyagyez la mbecy zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Orzeꞌ de uz zub lo gal nu de mbecy fariseo güeñ dey de riidz tiily nu mniim zeꞌ. Orzeꞌ bet lag dey cuen nu lo dey pcaam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Orzeꞌ ngulagy dey nguꞌ yaay mi, tees gudzib dey lo de mbecy gun bicy dey Jesuuz par tub yu nu rnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Orzeꞌ brugyiꞌ gaꞌ rnii Jesuuz nu riidz tiily lo dey tuubaꞌ tir. Orzeꞌ nam rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Mod nu rac nu gyel gubier ni Ñgyoozh, ndeꞌ mod nu guc nu tub rey. Rey zeꞌ bzu yey tub saꞌ ni fandang par nu chelaa yu feñ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Orzeꞌ mniiy lo de moz niy nu chay cha teey de yu nu ca lo cuen nu cha fandang. Tees de yu nu ca lo cuen nu cha zeꞌ, wangalagy dey ñgyay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Orzeꞌ bzeed yu reñaꞌ moz nu chay. Orzeꞌ mniiy lo dey: “Mnii lo de yu nu ca lo cuen nu cyid zeꞌ nu bi bzu lilya̱ dela coz nu dow den. Nunu bi bicya̱ mandaar nu gut chigud gal nu de bañ nu bi bicy reꞌña̱. Delañ bi zu lily ñii nu cyid dey fandang”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tees de yu nu ca lo cuen nu cha fandang zeꞌ, wangyicy cuen dey. Tub yu zay lat naay. Zeꞌ tuubaꞌy zay gyicy yu dalje̱z niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Zeꞌ tub nacaꞌ dey bduꞌ yaa dey de moz ni rey zeꞌ. Orzeꞌ shiñ bicy nu dey yu gashtal biit la dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Orzeꞌ tonaꞌ la guzi lagy rey zeꞌ. Orzeꞌ bicy yu mandaar lo de soldad niy nu chay cut yu de mbecy nu biit moz niy zeꞌ, nunu caay gyi ledz dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Gazeꞌ nu bredz yu de moz niy. Orzeꞌ nay: “Dela de coz bi zu lily ñii par fandang, tees de yu nu ca lo cuen nu ñgyiid, wangyap dey nu ñgyiid yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Orzeꞌ na gua der de nez zu. Orzeꞌ cuedz der cyu ziꞌl mbecy nu gyap ru nu cyid yu fandang”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Orzeꞌ de moz zeꞌ bruu dey zay de lat cay. Nunu bicy tublaazh dey ca na la de mbecy nu byap dey: tant mbecy a̱ꞌ nap nunu tant mbecy nap. Orzeꞌ bdzaa la nañ yuꞌ zeꞌ nu yuꞌ mbecy lo fandang. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Orzeꞌ rey zeꞌ guꞌy nañ yuꞌ zeꞌ nu bgüiiy lo dela mbecy nu bruꞌña zeꞌ. Orzeꞌ bduꞌ cuen yu lo tub mbecy nu a̱ꞌ zuy negy par fandang. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Orzeꞌ na rey zeꞌ rab yu mbecy zeꞌ: “¿Lac guc guꞌr ii zeꞌ a̱ꞌ zur negy par fandang?” nay. Tees mbecy zeꞌ rila waniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Orzeꞌ rey zeꞌ nay rab yu de moz niy: “Pcyiigy der gyiꞌy nunu pcyiig der yaay. Nunu mneꞌ der yu chay zeꞌ nu cow, zeꞌ nu gun yu nunu siigy lay yu”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gun Ñgyoozh rbedz mi zigy mbecy tees ñuu zi mbecy pcuim ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Orzeꞌ de mbecy fariseo ya dey, nunu orzeꞌ psaap dey riidz ben lac mod gac gyicy dey nu gadzam nu riidz par nu cuꞌ zi dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Orzeꞌ bzuu nez dey la be de mbecy nu nac nu de mbecy fariseo nu la be gaꞌ de mbecy ni Herodes nu cha nii dey lom. Orzeꞌ na dey rab yum: ―Masht, de̱ ya̱ rad lagy de̱ nu ru rniir coz rishli. Nunu ru wagyicy cuen ru de coz nu rnii mbecy, sinu rlyuur ni dey mod nu rlagy Ñgyoozh nu chuꞌ dey, gun ru a̱ꞌ nac ru mbecy nu rcui. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Orzeꞌ mnii ñuu lo̱ de̱ mod nu ru rnii toor. ¿A gruu nap ñi nu griib den tiñ nu rbic dey ni yu nu riib ic de nasyoong, uti waruu nap ñi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tees Jesuuz gud lagy mi nu nac dey mbecy rzi lagy. Orzeꞌ nam: ―Mbecy rzuu lo, ¿lagu rzu der caa zeꞌ lo̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Blyuu der tiñ nu cyish ru zeꞌ lo̱ ―nam. Orzeꞌ gua nu dey tub tiñ plat lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Orzeꞌ Jesuuz bdugyiꞌm lo dey: ―¿Cyu nab ca lo tiñ ii nunu cyu nu la ca looñ? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Orzeꞌ na dey: ―Lo César, yu nu riib ic de nasyoong, gal nu nu lay ―na dey. Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Benu ni, orzeꞌ briic der ni César, yu nu riib ic zeꞌ, de coz nu nac niy, nunu briicaꞌ der ni Ñgyoozh de coz nu nac nim ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Na ornu güeñ dey de riidz zeꞌ, orzeꞌ za nu la ic dey nunu zu ga lam gush nez dey yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Laab dzi zeꞌ gua la be de mbecy saduceo gua güii dey Jesuuz. De mbecy saduceo rnii dey nu ornu gat mbecy, orzeꞌ wagyabañaꞌ dey. Ndeꞌ nu bdugyiꞌ dey lo Jesuuz. Orzeꞌ na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Masht, Moisees mniiy nu benu tub mbecy gat yu, zeꞌ gyiyeeñ mñaay, zeꞌ sac la iꞌñ yu, orzeꞌ gash bicy yu byud zeꞌ, gun orzeꞌ cuic yu mdoo ni byud zeꞌ por cuen ni gyitoo bicy yu, na Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na lat de ub na ii bzu gagy mbecy nuy bicy yu. Orzeꞌ yu loga guud mñaay. Orzeꞌ gut yu. Zeꞌ mñaay wangaal lam mdoo. Orzeꞌ byeeñ byud zeꞌ lo yu nu gul loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Niꞌ ziꞌl bzac yu zeꞌ nu gut yu. Orzeꞌ niꞌ ziꞌl bzac yu chon nu gul loy. Orzeꞌ niꞌ ziꞌl bzac byud zeꞌ nu zaꞌ gagy la dey nuy bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na ornu blazh dela dey gut yu, orzeꞌ niꞌ ziꞌl biñ mñaa zeꞌ gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Zeꞌ na ornu shuub dzi nu gyabañ de mbecy gut zeꞌ, orzeꞌ ¿ca na de yu zeꞌ lo gagy yu nuy bicy yu gac mñaa dey mi zeꞌ? Gun dela dey pcyiiñ nuy mi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Orzeꞌ Jesuuz nam rab mi dey: ―De ru radza der, gun de ru wagyet lag der cuen de coz nu mniiñ lat de riidz ni Ñgyoozh. Ni wagad lagy der la na coz nu gac gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ornu de mbecy nu bi gut gyabañ dey, orzeꞌ wachelaa gaꞌ dey, sinu orzeꞌ chuꞌ dey gal nu yuꞌ de anc nu yuꞌ gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Zeꞌ na ni nu gyabañ mbecy, ¿walab gaal wacsyaꞌ der de riidz nu bzeeñ Ñgyoozh par de ru? Laab mi nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ya̱ naca̱ Ñgyoozh ni Abraham, naca̱ Ñgyoozh ni Isaac, nunu naca̱ Ñgyoozh ni Jacob.” ¡Gun Ñgyoozh a̱ꞌ nac mi Ñgyoozh ni mbecy nu byaꞌ lo la sinu nac mi Ñgyoozh ni mbecy nu mbañ mas bi gut yu! ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na ornu güeñ de mbecy de riidz zeꞌ, orzeꞌ za nu la ic dey nu nac de coz nu blyuum. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Orzeꞌ ornu gud lagy de mbecy fariseo nu psoow mi ruꞌ de mbecy saduceo, orzeꞌ byatublaazh dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Orzeꞌ bruu su tub yu nu rlyuu leey ni Ñgyoozh nu bdugyiꞌy lom par nu shet lag yum nañ caa. Orzeꞌ nay rab yum: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Masht, ¿ca na leey ni Ñgyoozh nac ñii leey zub lo zir? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Orzeꞌ na Jesuuz rab mi yu: ―“Pca Shuaan ru, biñ nu nac Ñgyoozh nir, nu dutuub la lardoor, nu dela gyel mbañ nir, gal nu nu dela shcab nir.” ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ndeꞌ leey zub lo zir par deꞌ zir leey. Ndeꞌ leey nu gya zir zu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Zeꞌ leey cyup, ndeꞌ nu “Pca der losaꞌr gal nu rcar ub ru.” Ndeꞌ saap ñi leey loga zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Orzeꞌ lo cyup de leey zeꞌ nac ñi cyong deꞌ zir leey nu bzeeñ Moisees, gal nu deꞌ zir de riidz nu bzeeñ de yu nu mnii por cuen ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lat nu gabee yuꞌ tublaazh de mbecy fariseo, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","orzeꞌ na Jesuuz rab mi dey: ―¿La ñuu shcab rash der nu nac Mesías, biñ nu ca lo cuen nu co mbañ mbecy? ¿Cyu nez nac mi? ―nam. Orzeꞌ na dey: ―Nez Dabi nac mi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Orzeꞌ na Jesuuz rab mi dey: ―Benu ni, ¿lagu mnii Espiriit Yon ni Ñgyoozh lo Dabi nu mniiy nu nac mi Shuaan yu? Gun ub la Dabi nay: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ñgyoozh nam rab mi Shuaana̱: “Gzub ru lugaar nu gzub mbecy nu gya zir zu par yaa be̱e̱ ii, gashtal gyicy la̱ nu gyicy ru gan de losaꞌr yuur”, na Ñgyoozh, na Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","’Orzeꞌ ¿walab gaal gac gruu Mesías, biñ nu ca lo cuen nu co mbañ mbecy lat nez Dabi, benu Dabi mniiy nu nac mi Shuaan yu? Gun bi guzañ naꞌñ gul Dabi anzir nu gal mi. Orzeꞌ ¿walab gaal gac gruum lat nez yu? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Orzeꞌ rila wangac tush cya dey ni tub riidz. Nunu nese laab dzi la zeꞌ wancuicaꞌ dey baloor nu ngugyiꞌy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gazeꞌ nu Jesuuz nam rab mi de mbecy gal nu de yu nu rsyaꞌ lom: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―De yu nu rlyuu leey ni Ñgyoozh gal nu de mbecy fariseo zu dey riiñ nu rshaal dey lac yaruu leey nu bzeeñ Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ndeꞌ nu de ru rlagy ñi zuub gyidag der ni de coz nu rnii dey, tees cueꞌ gyicy der mod nu ricy dey, gun coz nu rlyuu dey, ndeꞌ walab mod nu ricy de ub yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ndeꞌ nañ gal nu na nu rzuub dey yuu ich mbecy gashtal wagagyee gaꞌ la dey. Zeꞌ de ub yu walagy yu gal yuñ ni nu tub mbiz yu par nu locyuub yu losaꞌy nu guy yuu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dela coz nu ricy dey, tub lo ziꞌl ricy dey par nu gabe nu dzi rlyu dey. Yet lagy dey rcaay tub nac riidz ni Ñgyoozh cyugay nu ic chidz yu, nunu yet lagy dey gyicy tuñ zir yu shab yu par nu gabe nu nac dey mbecy da. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yet lagy dey rzub yu lugaar nu gua de mbecy lily lat gasht, nunu yet lagy dey rzub yu lugaar nu gua de mbecy zub lo nañ yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yet lagy dey ornu rca lagy de mbecy loy ornu rnii nu dey yu lat yagyiꞌ. Nunu niꞌ yet lagy dey ornu rnii de mbecy yu masht. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Zeꞌ de ru walagy ñi nu nii de mbecy nu nac der masht, gun dela de ru bicy ru losaꞌr nunu tub zi masht ni der zum. Ndeꞌ ya̱ biñ nu blosu Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nunu rila walagy ñi nii der nu uz ru ni tub la mbecy gyishlombecy ii, gun zu tub zi uz der. Ndeꞌ Ñgyoozh, biñ nu zub gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nunu cueꞌ shet ic der nu nii dey nu nac ru tub yu nu riib ic ni dey, gun tub zi ya̱, biñ nu ca lo cuen nu co mbañ mbecy naca̱ biñ riib ic de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mbecy nu ricy coz nu galagy ñi ni losaꞌ, yu zeꞌ yu nu gya zir zu lat de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Gun cyu ziꞌl mbecy nu ricy zily ub, yu zeꞌ gruu gyel mbecy niy. Zeꞌ yu nu ricy gyel gyidz ni, yu zeꞌ gyac yu mbecy nu gya zir zu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Cuaa de ru, mbecy nu rlyuu leey ni Ñgyoozh, gal nu de ru mbecy fariseo, gun nac der mbecy rzuu lo! De ru rsoow der roꞌ nu chuꞌ de mbecy lat de yu nu riib ic Ñgyoozh, gun orzeꞌ wac chuꞌ mbecy lugaar zeꞌ. Gun ni de ub ru wayuꞌr lugaar zeꞌ, ni wacsaan der nu chuꞌ deꞌ zir mbecy nu rlagy chuꞌ lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Cuaa de ru mbecy nu rlyuu leey ni Ñgyoozh nu de ru mbecy fariseo, gun nac der mbecy rzuu lo! Nunu rboo der yuꞌ de byud nu de gyel nap nim. Orzeꞌ par nu rlagy der nu soow sur lo de coz a̱ꞌ nap nu ricy ru, orzeꞌ chi rnii nu der Ñgyoozh. Ndeꞌ nu de ru cashtig ily zir gad ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Cuaa de ru mbecy nu rlyuu leey ni Ñgyoozh gal nu de ru mbecy fariseo, gun nac der mbecy rzuu lo! Tonaꞌ la rboo lo der rded ru dutuub la lugaar par nu gyicy ru gan mas ñuu tub mbecy nu chetib ic leey ni der yu. Nunu ornu bi bicy der gan tub mbecy, orzeꞌ ricy der nu dub gal nu na cashtig nu yad ñi nu gad ni der gabily, orzeꞌ de yu zeꞌ cyup tir ni na cashtig yad ñi nu gad ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Cuaa de ru! Na der gal nu na mbecy lo caꞌ. Zeꞌ rlyuu der nez ni losaꞌr. De ru rniir: “Benu zat na yuꞌ ni Ñgyoozh par nu gabe nu gyicy paa den nu riidz nu rniin, orzeꞌ walagy ñi gyicy paan nu riidz zeꞌ. Zeꞌ benu zat den or nu yuꞌ nañ yuꞌ ni Ñgyoozh par nu gabe nu ricy paan nu riidz nu rniin, orzeꞌ rlagy ñi gyicy paan”, rnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Der mbecy ton! ¡Mbecy lo caꞌ! ¿Ca na nu ricy zir ñi presis: a yuꞌ ni Ñgyoozh uti or nu taꞌ nañ ñi? Gun yuꞌ ni Ñgyoozh, ndeꞌ ricy ñi nu or zeꞌ nac ñii coz nim. Walab or zeꞌ ricy ñi nu yuꞌ zeꞌ nac ñii yuꞌ ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nunu niꞌ ziꞌl rnii de ru: “Benu tub mbecy zat yu mez nu zu zeꞌ nu rcaa dey gyi bañcyug par nu gabe nu ricy paay nu riidz nu rniiy, orzeꞌ walagy ñi gyicy paay nu riidz nu mniiy. Zeꞌ benu zat yu bañcyug nu riib lo mez zeꞌ, orzeꞌ rlagy ñi nu gyicy paay”, rnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mbecy lo caꞌ! ¿Ca na coz ricy zir ñi presis: a mez uti bañcyug nu riib loñ? Gun mez zeꞌ ricy ñi nu bañcyug nu riib loñ, ma zeꞌ cyiiñ ma par Ñgyoozh. Tees walab bañcyug zeꞌ gyicy ma nu cyiiñ mez zeꞌ par Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mbecy nu rzat mez zeꞌ rzat yuñ par nu gabe nu gyicy yac yu riidz nu rniiy. Orzeꞌ niꞌ ziꞌl rzat yu bañcyug nu riib loñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mbecy nu rzat yuꞌ ni Ñgyoozh, walab tub lo ziꞌl yuꞌ zeꞌ rzat yu, sinu niꞌ rzat yu Ñgyoozh, biñ nu zu nañ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nunu mbecy nu rzat gyibaa walab tub lo ziꞌl gyibaa rzat yu, sinu niꞌ rzat yu lugaar zeꞌ nu riib ic Ñgyoozh, gal nu biñ nu zub lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Dzi ga cuaa de ru mbecy nu rlyuu leey ni Ñgyoozh gal nu de ru mbecy fariseo gun nac der mbecy rzuu lo! Dela coz nu ricy cup der, lo tii nac ñii, rbic der tub nac ñii ni Ñgyoozh: gashtal de gyish loow comid, de mushtily, de aniis, de comin rbic der nim. Tub nac gaañ lo tii nac ga de gyish miꞌ zeꞌ rbic der nim. Tees wagyicy cuen der de riidz nu ricy ñi presis nu ca lo leey. Wagyicy cuen der de riidz nu rniiñ nu chuꞌn nu seꞌñ. Ni wagyicy cuen der de riidz nu rniiñ nu gashni lagy na losaꞌn, nu de riidz nu rniiñ nu nap chuꞌ den. Rlagy ñi gyicy yac der nu de riidz zeꞌ, nunu cueꞌ checa der nu gyicy ru deꞌ zir coz nu bi ricy ru zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Na der gal nu na lo caꞌ nu rlyuu nez ni losaꞌ. De ru rzeed der beꞌy miꞌ nu ibel tees camey rab der dutuub la ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Cuaa de ru mbecy nu rlyuu leey ni Ñgyoozh nu de ru mbecy fariseo! ¡Nac der mbecy rzuu lo! Na der gal na tub taz uti tub gyaꞌn. Par ich ziꞌl ñi tonaꞌ la nap rgyiib der. Zeꞌ par nañ ñi dza la yuꞌ coz nu bicy gubaan der, nu de coz nu ye rzac der lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Mbecy fariseo lo caꞌ! Rlagy ñi nu loga la cyib der par nañ taz zeꞌ, nu gyaꞌn zeꞌ. Orzeꞌ niꞌ ziꞌl par ich ñi gac ñii coz caacy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Cuaa de ru mbecy nu rlyuu leey ni Ñgyoozh gal nu de ru mbecy fariseo! ¡Nac der mbecy rzuu lo! Na der gal nu na ruꞌ baa ni añ nu dzi guzig par ich. Nap rabeeñ par ich ñi. Zeꞌ par nañ ñi yuꞌ rit nu beel guudz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niꞌ ziꞌl par lo de mbecy, rlyu nu nac der mbecy nap, zeꞌ nañ lardoo der nac ru mbecy rzuu lo, nunu nac der mbecy nu ricy de lo la cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Cuaa de ru, mbecy nu rlyuu leey ni Ñgyoozh gal nu de ru mbecy fariseo! ¡Nac der mbecy rzuu lo! Nap ricy nap der ruꞌ baa ni de yu nu mnii por cuen ni Ñgyoozh, nu ruꞌ baa ni de yu nu guc mbecy nap par nu gabe nu rca lagy der lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Orzeꞌ rnii der: “Bi bicy na nu de ub na ñcyiiñ na tiem nu guꞌ de gyitoo bel nin, orzeꞌ de ub na waric yaan ornu biit dey de yu nu mnii por cuen ni Ñgyoozh”, rnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nu nac de riidz nu rnii der zeꞌ, ndeꞌ rabee nu rad lagy der nu nac ru nez de yu nu biit de yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Benu ni, orzeꞌ de ru bzaꞌ lo la der laz nu bzuub de gyitoo bel ni der gyiꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Na der gal na bily. Na der gal na nez bily. ¿Lagu rnii too der nu glar lo cashtig nu cuic Ñgyoozh? Cashtig zeꞌ, ndeꞌ gabily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndeꞌ nu ya̱ zeeda̱ mbecy nu nii por cuen ni Ñgyoozh, nunu zeeda̱ mbecy nu rad lagy, nunu zeeda̱ mbecy nu lyuu ni der. Tees yuꞌ nu cut der dey. Yuꞌ gaꞌ nu caa der yu lo cruuz. Yuꞌ gaꞌ nu gaaz der yu nañ yuꞌ nu rsyaꞌ der riidz ni Ñgyoozh. Nunu yuꞌ gaꞌ nu gzab der ich yu gazaꞌ gyedz la. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndeꞌ nu too de ru gzeed Ñgyoozh dela cashtig gyiꞌ nu biit dey de mbecy nap zeꞌ: nese nu biit dey Abeel gashtal nu biit dey Zacarí, iꞌñ Berequías, yu nu biit der loliꞌ ni yuꞌ ni Ñgyoozh par gazel ni mez nu rcuaa der gun lom nu yuꞌ yon nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya̱ rishli rne̱e̱ lo der nu dela cashtig nu nac nu gut de mbecy nap zeꞌ dugyiñ gazaꞌ de ru, mbecy nu yuꞌ tiem na ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡A̱ der mbecy Jerusaleeng! Rut der de yu nu rnii por cuen ni Ñgyoozh. Nunu rgoow gyitaꞌ der de yu nu rzeed Ñgyoozh lat der. Zañ tir ngulagya̱ ñgyicy tublaazha̱ der gal nu ricy tub gyid ornu ricy tublaazh ma dzich ni ma nañ loweꞌ ma. Tees de ru wangalagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na ledz der gyiyeeñ ub ziñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gun ya̱ rne̱e̱ lo der nu nese na la wazacaꞌ la der ya̱ gashtal shuub la dzi ornu nii der: “Dzi ga zily nac biñ nu bzuu nez Ñgyoozh, Shuaan na, biñ nu cyid lo den”, nii der ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Orzeꞌ bruu Jesuuz loliꞌ ni yuꞌ nu driib zily de mbecy Ñgyoozh zam. Orzeꞌ bruꞌña de yu nu rsyaꞌ lom. Orzeꞌ brugyiꞌ rlyuu dey de yuꞌ zeꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Orzeꞌ na Jesuuz rab mi dey: ―¿A rzac der dela coz ii? Ya̱ rishli rne̱e̱ lo der nu sac tub gyitaꞌ ii nu gyiyeeñ ñi too losaꞌñ. Delañ dudily ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Orzeꞌ za num dey par too bicy ni ya Oliva. Orzeꞌ gusub mi. Orzeꞌ de yu nu rsyaꞌ lom byatublaazh dey lom par nu cugyiꞌ reñ dey lom. Orzeꞌ na dey: ―Mnii lo̱ de̱ nu gul gac de ndeꞌ. ¿La na muesht gruu zac ornu cyid ru tuubaꞌ tir? Nunu ¿gul shuub dzi ni tiem nu yuꞌn na? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Orzeꞌ na Jesuuz rab mi dey: ―Bzu der cuidad nis guu mbecy der, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","gun tonaꞌ la zigy mbecy grusac yu nu gash yu nu la̱. “Ya̱ Mesías, biñ nu ca lo cuen nu co mbañ mbecy”, niiy. Orzeꞌ gyicy yu nu tonaꞌ la zigy mbecy gadza̱ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ornu gyeñ der nu bi yuꞌ gyel yuu gaab ga, gal nu de zeꞌ nu zet, tees cueꞌ dzib der, gun ndeꞌ coz nu rlagy ñi nu gac. Tees gabee nigul shuub dzi nu gyaꞌ lo dela coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gun tub nac mbecy chuꞌy gyel yuu nu tub nacaꞌ mbecy. Nunu tub gubier chuꞌy gyel yuu nu tuubaꞌ gubier. Nunu cyid cubiñ. Nunu grib duru zañ lugaar ni gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tees dela ndeꞌ nu gzub ziꞌl gyiꞌñ nu gzac zi de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Orzeꞌ guꞌ dey de ru yaa mbecy par nu shet zi dey de ru nunu par nu cut dey de ru. Nunu dela de mbecy gazi lagy dey lo der par nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nunu tiem zeꞌ zigy de ru checa der nu gyicy cup ru consuel lo̱. Nunu gazi lagy der lo losaꞌr. Nunu cush cyaꞌ tub, cush cya tub ziꞌl der ich losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nunu gruu sac zigy mbecy rguu, mbecy nu nii nu nac mbecy nu rnii por cuen ni Ñgyoozh. Nunu gyicy dey nu gadza zigy mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nunu par nu tonaꞌ la gyañ nu shiñ gyicy de mbecy, orzeꞌ checa dey nu rcay losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tees yu nu gagye gashtal gat la, yu zeꞌ yu nu co mbañ Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nunu de riidz nu sac ni gyel gubier ni Ñgyoozh grush las ñi dutuub la gyishlombecy par nu gad lagy de lo la mbecy. Gazeꞌ nu shuub dzi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Na Ñeel, yu nu mnii por cuen ni Ñgyoozh, bzeeñ yu riidz ni coz bag nu gyicy ñi nu nit lo. Ornu zac der nu chuꞌñ lugaar ni Ñgyoozh, (Mbecy nu csyaꞌ de riidz ii rlagy ñi nu gyicy yu nu gyet lag yu cuen.) ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","orzeꞌ de mbecy nu yuꞌ lo de yu ni Judea rlagy ñi nu ruu chu dey chay par logyiꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nunu mbecy nu zub too yuꞌ walagy ñi nu gyet yu nu chuꞌy nañ yuꞌy nu coy la coz anzir nu ruu chuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mbecy nu ri ricy riiñ lat naa, walagy ñi nu cush cyay cha gyiy shab yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Tees cuaa de biñ mñaa nu secyi zu tiem zeꞌ! ¡Cuaa de biñ nu rgagy mdoo tiem zeꞌ! ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bdiiñ der lo Ñgyoozh nu cueꞌ nu ruu chu der tiem rag, ni sab, dzi nu rzu lagy mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gun tiem zeꞌ dzi zir zac zi mbecy gazeꞌ de tiem nu bded gaal ziꞌl nu bzub gyiꞌ gyishlombecy, nunu gazeꞌ deꞌ zir tiem nu yad par lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nunu benu Ñgyoozh wayicy shub mi tiem zeꞌ, orzeꞌ ni tub la mbecy waruu mbañ yu. Tees gyicy shuub mi tiem zeꞌ par nu nac de mbecy nu bi pcuim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Orzeꞌ benu ca na mbecy niiy lo der: “Güii ii zu Mesías, biñ nu ca lo cuen nu co mbañ mbecy” o “Güii re rim”, niiy. Tees de ru cueꞌ cheña lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gun grusu mbecy rguu nu niiy nu nac yu Mesías. Nunu grusu mbecy rguu nu niiy nu nac yu mbecy nu rnii por cuen ni Ñgyoozh. Zañ muesht lyuu dey, nunu zañ nusuriidz gyicy dey par nu gad mod nu guu dey mbecy. Mas gashtal de mbecy nu bi pcui Ñgyoozh guu mbecy zeꞌ dey, benu gac. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bzuub gyidag der, ya̱ tiem bi mne̱e̱ lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ndeꞌ nu benu mbecy niiy lo der: “Güii der, tub lugaar ub zi ri Mesías”, niiy, cueꞌ cha der loy. O benu nii gaꞌ dey: “Guii der, re ri ngach mi”, nii dey, cueꞌ cheña lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gun ya̱, biñ nu byac mbecy, sij ziꞌl gruꞌña̱ gal nu ricy yaa ni guzii ornu rzuñ dutuub la baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gun zeꞌ nu nguaa de cuerp gut, zeꞌ gyatublaazh dela lyash ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Na ornu ded tiem nu zac zi de mbecy zeꞌ, orzeꞌ gyet cow lo doo güidz, nunu beey wabicaꞌ ma yaa. De bel nu taꞌ baa gyet lag ma. Nunu dela fers nu nash baa cueñ ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Orzeꞌ gruu sac muesht ne̱ ya̱, biñ nu byac mbecy, baa. Orzeꞌ de lo la mbecy nu yuꞌ gyishlombecy gun yu. Orzeꞌ zac dey ya̱, biñ nu byac mbecy, nu yapa̱ lat za baa. Zac dey nu gac gyicya̱ coz ily, nunu zac dey nu tonaꞌ la lily na̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Orzeꞌ ya̱ zuu neza̱ de anc ne̱, ornu fert dulaa trompet par nu cha teꞌ dey de mbecy nu bi bducui gashtal se tap la scyiñ ni gyishlombecy: gash ñi gashtal zeꞌ nu bzub gyiꞌ baa nu gashtal zeꞌ nu byaꞌ loñ ni gyiꞌ baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Psyaꞌ der mod nu ricy ya las. Ornu bi rgaꞌñ nu driib lyag niñ, orzeꞌ de ru bi rad lagy der nu bi yad tiem zig. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Niꞌ ziꞌl mod ornu zac der gac dela coz nu mne̱e̱ lo der, orzeꞌ bi neñ der nu ya̱, biñ nu byac mbecy, bi zu̱ la̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya̱ rishli rne̱e̱ lo der nu de mbecy nu yuꞌ tiem zeꞌ walazh dey gat yu gal gac la dela de coz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Baa nuñ gyishlombecy ii delañ ded niñ, tees riidz nu ya̱ rne̱e̱ ndeꞌ rila waded niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Tees dzi zeꞌ, nu or zeꞌ, se cyu la rad lagy. Ni de anc nu yuꞌ gyibaa, ni ya̱ iꞌñ Ñgyoozh wagad lagya̱, sinu tub zi la Ñgyoozh uz den rad lagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Gal nu guc tiem ni Noé, niꞌ ziꞌl gac ornu shuub dzi nu ya̱ yapa̱ tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tiem zeꞌ anzir nu gyet gyey ily nu mnit lo gyishlombecy zeꞌ, orzeꞌ de mbecy pcyiiñ dey gyishlombecy ii. Nu bdow ziꞌl dey, nunu goꞌy, nunu pchelaa dey gashtal pshuub la dzi nu guꞌ Noé nañ barc. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tees ni wannii la too dey ti ni gac ñii gashtal bruꞌña la gyey. Orzeꞌ za nuñ dey. Niꞌ ziꞌl gac ornu shuub dzi nu ya̱ biñ nu byac mbecy yapa̱ tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Orzeꞌ tiem zeꞌ cyup mbecy riy ricy yu riiñ lat naay. Tub yu gruuy gyishlombecy ii nu gyay. Zeꞌ tubaꞌy gyiyeeñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cyup biñ mñaa cam rom iiñ gyech. Tub mi gruum gyishlombecy ii nu gyam. Zeꞌ tubaꞌm gyiyeeñ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Orzeꞌ bzu der altant gun wagad lagy der ca dzi yap ya̱, biñ nu nac Shuaan der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tees bicy der nu gad lagy ru tub coz. Benu tub shuaan tub yuꞌ gad lagy yu la or cyid gubaan, orzeꞌ zu lily yu nunu wazaan yu nu chuꞌy nañ yuꞌy nu coy suuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ndeꞌ nu de ru rlagy ñi nu gyiyeeñ lily der, gun ya̱ biñ nu byac mbecy yapa̱ or nu rila a̱ꞌ saꞌ lagy der ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Ca na moz nu ricy paa nu moz nu yuꞌ shcab ni? Yu zeꞌ bduꞌ patro̱o̱ niy riiñ yaay nu gyub ic yu deꞌ zir moz nu yuꞌ niy, par nu cuic yu nu gow de yu zeꞌ or niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dzi ni moz zeꞌ benu gyap patro̱o̱ niy yu ornu griy nu ricy yu gal nu mniiy loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya̱ rishli rne̱e̱ lo der nu patro̱o̱ niy cuꞌy riiñ yaay nu gyub ic yu dela coz niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tees benu moz zeꞌ nac yu mbecy a̱ꞌ nap, orzeꞌ nii tooy nu wari gyiily patro̱o̱ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Orzeꞌ gyicy ras nuy de losaꞌ moz yu. Gow yu, nunu goꞌy nu de mbecy rzugy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Orzeꞌ gri patro̱o̱ niy tub dzi nu a̱ꞌ saꞌ la lagy yu. Griy tub or nu wagad lagy lay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Orzeꞌ tonaꞌ la cashtig ily cuic yu ni moz zeꞌ. Gyicy nuy yu gal nu ricy nu dey de mbecy rzuu lo. Orzeꞌ gun yu, nunu siigy lay yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Mod nu rac nu gyel gubier ni Ñgyoozh, ndeꞌ nañ gal nu na mod nu guc nu tii fiñ feñ. Gush deñ candiil niñ gua cheel ñi nob. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na gaay ñi nac ñii fiñ ndeja̱d. Zeꞌ gaayaꞌ deñ nac ñii fiñ cuidad. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Orzeꞌ de fiñ ndeja̱d zeꞌ za nu deñ candiil niñ. Tees wancha nu sheñ deñ asecy par nu nchaa gaꞌ deñ nañ candiil niñ tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Zeꞌ de fiñ cuidad zeꞌ za nu deñ candiil niñ gal nu sheñ asecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na ornu bded tiem nu wangri nob zeꞌ, orzeꞌ brugyiꞌ nu ryeed pcaal deñ. Orzeꞌ gush pcaal delañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na ornu bi yad razeel rel, orzeꞌ brugyiꞌ rbish ti mbecy: “¡Bi yeed nob! ¡Bruu der nu cha cheel ru nob!” rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Orzeꞌ dela de fiñ feñ zeꞌ wesh te deñ carer, nunu bzu nap deñ candiil niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Orzeꞌ de fiñ ndeja̱d zeꞌ nañ rab ñi de fiñ cuidad zeꞌ: “Doo ñuu asecy ni der ne̱ de̱, gun ryuu candiil ne̱”, naañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Orzeꞌ na de fiñ cuidad zeꞌ: “Waric de̱ asecy. Gun ni par de̱ ya̱ wal ñii, zeꞌ yegar par de ru. Gua der lo mbecy nu rut asecy. Orzeꞌ lo mbecy zeꞌ zi der ñii nir”, na deñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tees lat nu gua zii de fiñ ndeja̱d zeꞌ asecy niñ, lat zeꞌ bri la nob. Orzeꞌ de fiñ nu bzu lily zeꞌ guꞌ deñ nu nob lo fandang. Orzeꞌ byoow roꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na ornu byoow roꞌ, orzeꞌ bri gaayaꞌ de fiñ ndeja̱d zeꞌ. Orzeꞌ na deñ taꞌñ gyeroꞌ: “Pshaal ñuu roꞌ ne̱ de̱”, na deñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tees orzeꞌ na nob zeꞌ: “Ya̱ rishli a̱ꞌ yuꞌ lo̱ de ru”, nay ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Orzeꞌ na gaꞌm: ―Orzeꞌ rlagy ñi gac der mbecy nu rzu altant, gun ni wagad lagy der ni ca dzi ni ca na or yap ya̱, biñ nu byac mbecy, tuubaꞌ tir ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Mod nu rac nu gyel gubier ni Ñgyoozh, ndeꞌ nañ gal nu na mod nu bzac tub mbecy nu gua biaj. Ornu bi zuu lay nu chay tub lugaar, orzeꞌ bredz yu dela moz niy nu bduꞌy riiñ yaay nu ñay dela suuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Orzeꞌ tub yu briic yu gaay tant tiñ niy. Zeꞌ tuubaꞌy briic yu cyup tant tiñ niy. Zeꞌ tuubaꞌy briic yu tub tant tiñ niy. Dub gal mod nu rlyu nu cyiiñ tub ga dey dub ni tiñ briic yu ni dey. Orzeꞌ gush nez yu zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na moz nu guud gaay tant tiñ ni zeꞌ, lueg la guay bicy yu dalje̱z nu tiñ zeꞌ. Orzeꞌ bicy yu gan tub gaayaꞌ tant tiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Niꞌ ziꞌl bicy moz nu guud cyup tant tiñ ni zeꞌ. Orzeꞌ bicy yu gan tub cyupaꞌ tant gal nu guud niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tees yu nu guud tub tant ni zeꞌ, orzeꞌ yay bduuñ yu gyegy nu pcach yu tiñ ni patro̱o̱ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Na ornu bi rac zañ tiem, orzeꞌ bri patro̱o̱ zeꞌ. Orzeꞌ bzaꞌ loy nu de moz zeꞌ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nu loga la bruꞌña yu nu guud gaay tant tiñ ni zeꞌ. Orzeꞌ byabic yu gaay tant nu za nuy zeꞌ gal nu tub gaayaꞌ tant iꞌñ ñi. Orzeꞌ nay rab yu patro̱o̱ niy: “Ru briic ru gaay tant ne̱. Na ii gaꞌ tub gaayaꞌ tant nu bicya̱ gan”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Orzeꞌ patro̱o̱ zeꞌ nay rab yuy: “Nap tonaꞌ la. Ru nac ru tub moz nu ricy paa. Na par nu bicy paar nu ñuu miꞌ nu briica̱ nir, na riiñ ily zir grica̱ nu gyicy ru. Gyeed gun gyet lagy ru nur ya̱”, na patro̱o̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Orzeꞌ bruꞌña gaꞌ yu nu guud cyup tant ni zeꞌ. Orzeꞌ nay rab yu patro̱o̱ niy: “Ru briic ru cyup tant ne̱. Ndeꞌ nu gyash ru ñii nir, gal nu cyupaꞌ tant nu bicya̱ gan”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Orzeꞌ na patro̱o̱ niy rab yuy: “Nap tonaꞌ la. Ru nac ru tub moz nu ricy paa. Na par nu bicy paar nu ñuu miꞌ nu briica̱ nir, ndeꞌ nu na riiñ ily zir grica̱ nu gyicy ru. Na gyeed gun gyet lagy ru nur ya̱”, na patro̱o̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Tees ornu bruꞌña gaꞌ yu nu guud tub tant tiñ ni zeꞌ, orzeꞌ nay rab yu patro̱o̱ niy: “Ya̱ rad lagya̱ nu ru nac ru tub mbecy nu dzi cyigy lardoo. Gun ru wagyicy ru riiñ, tees rboor gana̱z ni de moz nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Orzeꞌ gudziba̱. Ndeꞌ nu ya̱ pcacha̱ tiñ nir lo yu. Ndeꞌ nu ii gyash ru ca na nu nir”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Orzeꞌ patro̱o̱ zeꞌ nay rab yuy: “Dzi ga mbecy zed nac ru. Dzi ga a̱ꞌ nap ru, benu ru rad lagy ru nu ya̱ ryasha̱ de gana̱z ni de moz ne̱, mas wagyicy uba̱ riiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Orzeꞌ ¿lagu wanchar ñgya seeñ ru tiñ zeꞌ nañ banc? Gun orzeꞌ ornu ndri̱ gyabic ru tiñ ne̱ nu ñuu iꞌñ ñi”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Orzeꞌ na patro̱o̱ rab yu de yu nu yuꞌ zeꞌ: “Bloo der tub tant tiñ nu ri yaay. Briic der ñii ni yu nu ricy cup tii tant. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gun mbecy nu bi ricy cup gad zir ñi niy nunu gashtal grusubaꞌ lañ niy. Zeꞌ mbecy nu sac ni gashtal coz miiñ nu ricy cup yu gruuñ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Zeꞌ moz wacyiiñ ii, bloo der yu chay ich yuꞌ, zeꞌ nu cow. Zeꞌ gun yu nunu siigy lay yu”, nay ―na Jesuuz―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ornu ya̱, biñ nu byac mbecy, chuꞌ nu gaca̱ rey, orzeꞌ yapa̱ nu de anc ne̱ nunu chesuba̱ nu gyub ica̱ de mbecy lugaar zeꞌ nu yuꞌ gyel lily ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Orzeꞌ dela mbecy ni gyishlombecy gyatublaazh dey lo̱. Orzeꞌ ya̱ glewa̱ dey nu gyac cyup nac yu gal nu ricy tub mbecy nu rña shily nu co reñ yu shily lat de chiib. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Orzeꞌ ya̱ zeeda̱ de shily par yaa be̱e̱. Zeꞌ de chiib zeeda̱ ma par yaa rega̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Orzeꞌ ya̱ biñ nu nac rey, ne̱e̱ lo de mbecy nu yuꞌ par yaa be̱e̱: “Da der gun Ñgyoozh, uz den, nap ricy num der. Gush der gyel nap nu bi bzu ye Ñgyoozh ni der zeꞌ nu riib ic mi nese anzir nu gzub gyiꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gun ya̱ byana̱, zeꞌ de ru briic ru coz nu da̱w. Ya̱ bigya̱ nis, zeꞌ de ru briic ru nis do̱ꞌ. Ya̱ guca̱ mbecy zu nez, zeꞌ de ru bredz ru ya̱ nu gua̱ yuꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ya̱ bicy falt shaba̱, zeꞌ de ru briic ru shaba̱. Ya̱ gurata̱, zeꞌ de ru biid güii der ya̱. Ya̱ bet laga̱ nañ yuꞌ gyiib, zeꞌ de ru biid zaab lo der ya̱”, ne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Orzeꞌ de mbecy nap nu yuꞌ par yaa be̱e̱ nii dey: “Shuaan de̱, ¿gul bzaac de̱ ru nu ran ru, zeꞌ briic de̱ coz nu gow ru? O ¿gul bzaac de̱ ru nu rbigy ru nis, zeꞌ briic de̱ nis goꞌr? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O ¿gul bzaac de̱ ru nu zu nez ru, zeꞌ briic de̱ posad nir? O ¿gul bicy falt shab ru, zeꞌ bric de̱ ñii nir? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O ¿gul bzaac de̱ ru gurat ru, o gul bzaac de̱ ru rir yuꞌ gyiib, zeꞌ gua zaab lo de̱ ru?” nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Orzeꞌ ya̱, biñ nu nac rey, ne̱e̱ lo dey: “Ya̱ rishli rne̱e̱ lo dela de ru mbecy nu ni bicy nu de bicya̱, de mbecy nu blaazhaꞌ zir mbecy shni, orzeꞌ niꞌ ziꞌl bicy nu der ya̱”, ne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Orzeꞌ ya̱, biñ nu nac rey, ne̱e̱ lo de mbecy nu yuꞌ par yaa rega̱: “Bruu chu de ru lo̱ ii, de ru mbecy nu bzaa lagy Ñgyoozh ni. Gua der lo gyi nu rila wayu: lo gyi nu bzu ye Ñgyoozh par nuras nu de anc niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gun ya̱ byana̱, zeꞌ de ru wancuic der nu da̱w. Ya̱ bigya̱ nis, zeꞌ de ru wancuic ru nis do̱ꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ya̱ guca̱ mbecy zu nez, zeꞌ de ru wancuedz ru ya̱ nu cha̱ yuꞌr. Ya̱ bicy falt shaba̱, zeꞌ de ru wancuic der ñii ne̱. Ya̱ gurata̱ nunu betlaga̱ nañ yuꞌ gyiib, zeꞌ de ru wancyiid güii der ya̱”, ne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Orzeꞌ nii dey lo̱: “Shuaan de̱, ¿gul bzaac de̱ ru nu ran ru, o nu bigy ru nis, o nu zu nez ru, o nu sac shab ru, o nu rat ru, o nu rir nañ yuꞌ gyiib, zeꞌ wanlocyuub de̱ ru?” nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Orzeꞌ ya̱, biñ nu nac rey, ne̱e̱ ga̱ꞌ lo dey: “Ya̱ rishli rne̱e̱ lo der nu la ziꞌl tiem nu wanlocyuub der mas ñuu tub de mbecy nu blaazhaꞌ zir mbecy shni, orzeꞌ niꞌ ziꞌl wanlocyuub der ya̱”, ne̱e̱ lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Orzeꞌ de yu zeꞌ gyet lag dey lo cashtig nu rila wayeca. Zeꞌ de mbecy nap gad nu cui mbañ dey lo Ñgyoozh tub la ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na ornu blazh mnii Jesuuz dela de riidz zeꞌ, orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―De ru bi rad lagy der nu nañ cyup dzi chuꞌ saꞌ ni Pas. Orzeꞌ ya̱, biñ nu byac mbecy, guꞌ dey ya̱ yaa de mbecy par nu cut dey ya̱ lo cruuz ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Orzeꞌ laab tiem zeꞌ de uz zub lo gal nu de yu bel ni de mbecy Israeel byatublaazh dey yuꞌ Caifás, yu nu riib ic de uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Orzeꞌ bloo ic dey tub mod par nu shet lag dey Jesuuz pres nu nac gyel rguu, gun orzeꞌ gyicy dey nu gat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tees na dey: ―Walagy ñi shet yaan yu lat saꞌ gun nis gyach de mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na lat nu pcyiiñ Jesuuz Betania yuꞌ Simo̱o̱, yu nu gurat gyedz nu la lepra, ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","orzeꞌ bruꞌña tub biñ mñaa lo Jesuuz nu tub lamet nu byaa nu gyitaꞌ nu la alabastro. Dza laa nañ ñi nu yuꞌ asecy zguul nu dzi ñgyup sac. Orzeꞌ lat nu gabee zub mi rom gyit, orzeꞌ biñ mñaa zeꞌ pcoom asecy zguul zeꞌ too Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na ornu bzaac de yu nu rsyaꞌ lom, orzeꞌ guzi lagy dey. Orzeꞌ brugyiꞌ rnii dey: ―¿Lagu leew la mnit lom asecy zguul re? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gun nde ñgyac nsaꞌy ñi par nu sheñ tiñ ñgyaad. Orzeꞌ tiñ zeꞌ mbic mi ni de mbecy zi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na ornu gud lagy Jesuuz de coz nu mnii dey, orzeꞌ nam rab mi dey: ―¿Lagu ricy seed der biñ mñaa ii? Mi ii tonaꞌ la nap bicy num ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gun mbecy zi dub laa tiem yuꞌy lat der. Tees ya̱ walab dub laa tiem cyiiña̱ lat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Coz nu bicy biñ mñaa ii num ya̱ ornu pcoom asecy zguul cuerp ne̱, ndeꞌ par nu rzu lily mi ya̱ par ornu cach dey ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya̱ rishli rne̱e̱ lo der nu ca ziꞌl lugaar ni gyishlombecy nu shaal dey riidz nu sac nu bruu lo Ñgyoozh, orzeꞌ nii gaꞌ dey coz nu bicy nu biñ mñaa ii ya̱ par nu gyezaꞌ lagy mbecy mi ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Orzeꞌ Judas Iscariote, tub yu nu bruu lat trocyup de yu nu blosu Jesuuz, gua niiy lo de yu nu riib ic de uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Orzeꞌ nay rab yu dey: ―¿La be cyish der ne̱, orzeꞌ ya̱ gyabica̱ Jesuuz yaa der? ―nay. Orzeꞌ bzaꞌ lo dey nu cyish yu gal rub tii tiñ plat niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Orzeꞌ nese or la zeꞌ brugyiꞌ ryub Judas mod par nu guꞌy Jesuuz yaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dzi loga ni saꞌ nu row dey gyishtily nu sac lebadur, orzeꞌ de yu nu rsyaꞌ lo Jesuuz bruꞌña dey lom. Orzeꞌ na dey rab yum: ―¿Ca rlagy ru nu cha̱ de̱ zu ye̱ coz nu gyicy na che dzi saꞌ ni Pas? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Orzeꞌ nam rab mi dey: ―Yaa der lat gyedz. Orzeꞌ cha der lo i mbecy. Orzeꞌ zeꞌ nii der: “Masht nam: Ya̱ byap or ne̱, nunu ya̱ nu de yu nu rsyaꞌ lo̱ ded de̱ saꞌ ni Pas yuꞌr, nam.” Ni nii der ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Orzeꞌ de yu nu rsyaꞌ lom bicy dey gal nu mniim. Orzeꞌ bzu ye dey tub comid ni dzi saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na or biche, orzeꞌ gusub Jesuuz nu de trocyup yu nu rsyaꞌ lom nu gyicy dey che. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Orzeꞌ lat nu ricy dey che, orzeꞌ nam rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu lat de ru gruu su tub ru nu cush cyar icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Orzeꞌ tonaꞌ la bicy shni de yu nu rsyaꞌ lom. Orzeꞌ tub ga dey brugyiꞌ rgugyiꞌ dey lom. Orzeꞌ na dey: ―Shuaana̱, ¿walab gaal ya̱? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Orzeꞌ na Jesuuz rab mi dey: ―Tub yu nu rneꞌ gyishtily laab nañ tub ziꞌl gyaꞌn nu ya̱, yu zeꞌ cush cyaꞌy icha̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gun ya̱, biñ nu byac mbecy, rishli gata̱ gal nu pcaa de yu nu mnii por cuen ni Ñgyoozh. ¡Tees cuaa yu nu cush cya icha̱! Nap zir bi bicy na nu cueꞌ ñgyal yu nu ni gyicy zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Orzeꞌ na Judas, yu nu bish cya ich mi: ―Masht, ¿walab gaal ya̱? ―nay. Orzeꞌ na Jesuuz: ―Gal nu ru mniir, ndeꞌ laab ni ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na lat nu gabee nguaa dey row yu gyit, orzeꞌ Jesuuz gush mi tub gyishtily. Orzeꞌ briic mi gras ni Ñgyoozh nu nac ñii. Gazeꞌ nu blew mi ñii. Orzeꞌ briic mi ñii ni de yu nu rsyaꞌ lom. Orzeꞌ nam: ―Gush der gyishtily ii gow ru, gun nii cuerp ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Gazeꞌ nu gusha̱ꞌm tub taz nu yuꞌ ñup urbyay. Orzeꞌ briicaꞌm gras ni Ñgyoozh. Gazeꞌ nu briic mi ñii ni dey. Orzeꞌ nam: ―Dela de ru goꞌ der nu yuꞌ nañ taz ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gun nu nii reña̱ nu gzu nap ñi trat cub nu bicy Ñgyoozh nu de mbecy. Nu nii reña̱ nu dushu par nu gruu mbañ zigy mbecy, par nu gyicy sulagy Ñgyoozh ni dela cyi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya̱ rishli rne̱e̱ lo der nu rila wadoꞌ ga̱ꞌ ñup ni urbyay tuubaꞌ tir gashtal shuub la dzi nu do̱ꞌ du̱ de ru ñup cub lugaar zeꞌ nu riib ic Ñgyoozh, uz den ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na ornu blazh biil num dey tub Salmo, orzeꞌ bruu num dey yuꞌ zeꞌ za num dey bicy ni ya Oliva. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Gazeꞌ nu nam rab mi dey: ―Rel na dela de ru checa der nu gyicy cup ru consuel lo̱ nu nac de coz nu gzaca̱, gun ni rniiñ lat de riidz ni Ñgyoozh. Orzeꞌ nam: “Ya̱ duta̱ biñ nu rña shily, orzeꞌ dela shily nim grush las ma”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tees despuees ornu gyabaña̱, orzeꞌ ya̱ gya̱ ga̱ lo de ru par Galilea ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Orzeꞌ na Bed rab yum: ―Mas dela dey checa dey nu gyicy cup dey consuel lor nu nac de coz nu gzac ru, tees ya̱ rila wane̱ꞌ ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Orzeꞌ na gaꞌm rab mi yu: ―Ya̱ rishli rne̱e̱ lor nu laab rel na, anzir nu cuedz ngüel ruꞌ loga ma, chon tir niir nu a̱ꞌ yuꞌ lor ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tees Bed bzu fert yu. Orzeꞌ nay: ―Mas gata̱ du̱ ru, tees ya̱ rila wane̱e̱ nu a̱ꞌ yuꞌ lo̱ ru ―nay. Nunu niꞌ ziꞌl mnii deꞌ zir de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Orzeꞌ Jesuuz gush nez mi zam nu de yu nu rsyaꞌ lom tub lugaar nu la Getsemaní. Orzeꞌ nam: ―Bzub der ii lat nu ya̱ cha̱ par re nu ne̱e̱ du̱ Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Orzeꞌ za nu reñ mi Bed nu rup laa iꞌñ Zebedeo. Orzeꞌ brugyiꞌ ricy shnim, nunu tonaꞌ la deet rac nañ lardoom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Orzeꞌ nam rab mi dey: ―Ya̱ rlagy la̱ gata̱ nu tantaꞌ shni rac nañ lardo̱o̱. Blez der ii nunu bzu der altant nu ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gazeꞌ nu gua gaꞌm sñuu miiñ par lo. Orzeꞌ wes saa tiily mi lo yu nunu brugyiꞌ rnii num Ñgyoozh. Orzeꞌ nam: ―Uza̱, benu gac, ¿a wabo chur taz nu gzuub ruꞌ? Tees cueꞌ gac ñii gal nu rlagya̱ sinu gal nu rlagy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na ornu bish cyam lo de yu nu rsyaꞌ lom zeꞌ, orzeꞌ byap mi dey nguaa nas yu. Orzeꞌ nam rab mi Bed: ―¿Walab gaal ni ñuu tub or wangagyee der nu nzu der altant nu ya̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bzu der altant nunu mnii nu der Ñgyoozh, gun orzeꞌ cueꞌ gyicy de coz cyi gan der. Gun nañ lardoo der rlagy ru gyicy ru coz nap tees cuerp ni der wacyiiñ ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Orzeꞌ nu cyup la nu rzam nu rnii num Ñgyoozh, orzeꞌ nam: ―Uza̱, ben a wac co chur taz nu gzuub ru̱ꞌ o gashtal do̱ꞌ la ñii, tees gac ñii gal nu ru rlagy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Orzeꞌ bish cya gaꞌm tuubaꞌ tir zam lo dey. Orzeꞌ niꞌ ziꞌl byap mi dey nguaa nas yu, gun rsuun la pcaal dey tantaꞌ nu yeed ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Orzeꞌ bzeeñ mi dey za gaꞌm nu nii num Ñgyoozh tir chon la. Orzeꞌ mniim laab de riidz nu mniim or loga. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Orzeꞌ bish cya gaꞌm lo dey. Orzeꞌ nam rab mi dey: ―¿Walab gaal gabee nas ruꞌ der nunu gabee rzu lagy der? Na bi ryap or nu ya̱, biñ nu byac mbecy, guꞌ dey ya̱ yaa de mbecy cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wes su der yaa na. Gun bi yad gaab yu nu cush cya icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lat nu gabee rnii ruꞌm, lueg la bruꞌña Judas, tub yu nu bruu lat trocyup de yu nu rsyaꞌ lom. Bruꞌñay nu zigy mbecy nu nuu mandzicy, nu yu nu nuu garot. Yad dey par mandaar ni de yu nu zub lo ni de uz, nunu par mandaar ni de yu bel ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zeꞌ Judas, yu nu bish cya ich mi, bi mniiy lo dey lac mod gyicy yu par nu gad lagy dey cyu Jesuuz. Orzeꞌ mniiy: ―Yu nu da̱w chit lo, yu zeꞌ ndeꞌ. Orzeꞌ gua nu der yu pres ―mniiy lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na ornu bruꞌña Judas lo Jesuuz, orzeꞌ bechaꞌy lom. Orzeꞌ nay rab yum: ―¡Masht, shnu ru! ―nay. Orzeꞌ bdow yu chit lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Orzeꞌ na Jesuuz rab mi yu: ―Judas, bicy ca na la nu yad ru gyicy ru ―nam. Orzeꞌ bechaꞌ de mbecy lom. Bduꞌ yaa dey mi. Gazeꞌ nu za nu dey mi pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tees tub yu nu zu nu Jesuuz bloo zay mandzicy niy nañ gyid yuꞌñ. Orzeꞌ pcyug yu gyidag tub moz ni yu nu riib ic de uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Orzeꞌ na Jesuuz: ―Bduꞌ choow mandzicy zeꞌ seꞌñ gun dela yu nu rgyish lo lo mandzicy gat yu nu mandzicy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A wagad lagy der nu ya̱ gac ne̱e̱ lo Ñgyoozh, uza̱, nu zeed mi zigy zir anc par trocyup nac soldad nu locyuub dey ya̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tees benu ni, ¿lac mod gac par nu gyuꞌ ni de riidz ni Ñgyoozh gal nu rniiñ nu gac? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Orzeꞌ na Jesuuz rab mi de mbecy zigy zeꞌ: ―¿Lagu yad tub der ya̱ gal nu rza tub dey tub gubaan: nu mandzicy nu garot? Gun de dzi la bri̱ blyu̱u̱ ni der loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh. Nunu wancuꞌ yaa der ya̱ nu ñgya nu der ya̱ pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tees dela nii ni raac ñi par nu gyuꞌ niñ gal nu bi cañ lat de riidz ni Ñgyoozh, gal nu mnii de yu nu mnii por cuen nim ―na Jesuuz. Orzeꞌ laab or la zeꞌ dela de yu nu rsyaꞌ lom bzeeñ dey mi. Bruu chu dey lom zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Orzeꞌ de yu nu gua tub Jesuuz gua nu dey mi yuꞌ Caifás, yu nu riib ic de uz. Zeꞌ byatublaazh de yu nu rlyuu leey ni Ñgyoozh, nu de yu bel ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Zeꞌ Bed gua cay ich Jesuuz. Orzeꞌ zet zet ziꞌl zaab yu ich mi gashtal bri lay loliꞌ ni yu nu riib ic zeꞌ. Orzeꞌ guꞌy gusub yu loliꞌ zeꞌ nu de yu nu rña yuꞌ zeꞌ par nu güiiy ben lac mod zaꞌ lo dey nu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Orzeꞌ de uz zub lo, nu dela de yu nu zu riiñ lat junt zub lo byub dey mod par nu griib dey cyi fals toom, gun orzeꞌ gad mod nu cut dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tees rila wangad ni tub la mod ni dey mas zigy mbecy gua dey briib dey gyidza toom. Orzeꞌ gal brusu gaal cyup mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Orzeꞌ na dey: ―Yu ii nay: “Ya̱ gac tilya̱ yuꞌ nu driib zily den Ñgyoozh, nunu nañ chon dzi gac shes su̱ ñii tuubaꞌ tir”, nay ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Orzeꞌ yu nu riib ic zeꞌ wes suy, orzeꞌ nay rab yu Jesuuz: ―¿A waniir lagu sac falt nir? ¿La ñuu cyi driib dey ic ru? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tees Jesuuz ri ziꞌl zum. Rila waniim. Orzeꞌ na gaꞌ yu nu riib ic zeꞌ: ―Rishli gaal ni Ñgyoozh mbañ, mnii lo̱ de̱ benu nac ru Mesías, biñ nu nac iꞌñ Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Orzeꞌ na Jesuuz rab mi yu: ―Laab gal nu ru mniir. Ya̱ rishli rne̱e̱ lo der nu gzac der ya̱, biñ nu byac mbecy, zuba̱ par yaa bee Ñgyoozh, biñ nu rac ricy de lo la coz ily. Nunu gzac der ya̱ yapa̱ lat za ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Orzeꞌ yu nu riib ic zeꞌ pshala lay shab yu par nu gabe nu walab seꞌñ mniim. Orzeꞌ nay: ―Yu ii bzat ziy Ñgyoozh. ¿Laꞌ zir be teshtig rlagy ñi par yu ii? Na bi güeñ der de riidz a̱ꞌ nap nu mniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿La ñuu rnii too der? ―nay. ―Yu ii yuꞌ falt niy nunu rlagy ñi gat yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Orzeꞌ brugyiꞌ rcoo yeñ dey lom. Nunu brugyiꞌ nu rgaaz dey mi. Zeꞌ yuꞌ gaꞌ dey briich yaay lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","―Ru, Mesías, ¡mnii lo̱ de̱ cyu briich yaa lor! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na Bed gusub yu loliꞌ ni ich yuꞌ zeꞌ. Orzeꞌ bruꞌña tub criad loy. Orzeꞌ nañ rab ñiy: ―Niꞌ ru gusa nur Jesuuz, biñ nu bruu Galilea, ¿shiñ? ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tees Bed mniiy nu walab lo rgüii la dela mbecy. Orzeꞌ nay: ―Ya̱ wagad lagya̱ la coz rniir ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Orzeꞌ zay par gyeroꞌ. Zeꞌ bzaac tuubaꞌ criad yu. Orzeꞌ nañ rab ñi de mbecy nu yuꞌ zeꞌ: ―Niꞌ mbecy ii gusa num Jesuuz, biñ nu bruu Nazaret ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Orzeꞌ niꞌ ziꞌl mnii Bed nu walab. Orzeꞌ nay: ―Ñgyoozh shiñ gyicy num ya̱ benu ya̱ walab rishli rne̱e̱. ¡Ya̱ a̱ꞌ yuꞌ lo̱ cyu mbecy ndeꞌ! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na guchi gaꞌ sñuu ndeꞌ, orzeꞌ de yu nu yuꞌ zeꞌ na dey rab yu Bed: ―Wanted la niꞌ ru nac ru tub yu nu bruu lat dey, gun rabee nu nac mod nu za riidz nu rniir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Orzeꞌ Bed nay: ―Ñgyoozh shiñ gyicy num ya̱ benu walab rishli rne̱e̱. ¡Ya̱ a̱ꞌ yuꞌ lo̱ cyu mbecy ndeꞌ! ―nay. Orzeꞌ laab or la zeꞌ bredz ngüel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Orzeꞌ byezaꞌ lagy yu de coz nu mnii Jesuuz ornu nam: “Anzir nu cuedz ngüel ruꞌ loga ma, ru niir nu a̱ꞌ yuꞌ lor ya̱ chon tir” ―nam. Orzeꞌ bruu Bed zay. Nunu tonaꞌ la zi ruun yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Laab bzaꞌ yu la tuubaꞌ dzi, orzeꞌ de uz zub lo gal nu de yu bel ni de mbecy Israeel byatublaazh dey par nu go dey riidz ben lac mod gyicy dey par nu gat Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Orzeꞌ pcyiig dey mi za nuy mi. Orzeꞌ bguꞌ dey mi yaa Poncio Pilato, yu nu riib ic por cuen ni gubier Rom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na ornu Judas, yu nu bish cya ich Jesuuz, ornu gud lagy yu nu mnii dey nu gat Jesuuz, orzeꞌ brugyiꞌ nu rnii tooy nu nap zir benu cueꞌ ñlyuuy Jesuuz lo dey. Orzeꞌ bish cyay gua zeeñ yu gal rub tii tiñ plat zeꞌ lo de uz zub lo, nu lo de yu bel ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Orzeꞌ nay: ―Ya̱ shiñ bicya̱ nu nac nu bish cya̱ ich tub mbecy nu sac falt ni, nunu gashtal cut la dey yu ―nay. Tees de yu zeꞌ nay rab yuy: ―Par nu nac nu ndeꞌ se la la nu ricy ñi ne̱ de̱ ya̱. ¡Ndeꞌ cuen ni ru! ―na dey rab yu Judas. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Orzeꞌ mneꞌ la Judas tiñ zeꞌ loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh. Orzeꞌ bruuy zeꞌ yay. Orzeꞌ bzaab gyi̱y ub yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Orzeꞌ de uz zub lo pteꞌ dey dela tiñ zeꞌ. Orzeꞌ na dey: ―Wac zeeñ den tiñ ii nañ alcansi ni gun, gun tiñ ii bicy ñi nu gut mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Orzeꞌ psaap dey riidz ben lac gyicy nu dey tiñ zeꞌ. Orzeꞌ wii dey tub nac yu nu la Yu ni Mbecy nu Rzaa Gyis. Orzeꞌ yu zeꞌ wii dey ñi nu tiñ zeꞌ, par nu gac ñii tub campyo̱o̱ nu cach dey de mbecy yad. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndeꞌ nu gashtal tiem na, yu zeꞌ lañ Yu nu Guud nu Nac Reñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ni mod guc ñi par nu byuꞌ niñ gal nu mnii Jeremías, tub yu nu mnii por cuen ni Ñgyoozh, ornu nay: Orzeꞌ gush dey gal rub tii tiñ plat zeꞌ, pres nu mnii de mbecy Israeel nu cyish dey nu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Orzeꞌ nu tiñ zeꞌ wii dey tub nac yu nu la Yu ni Mbecy nu Rzaa Gyis, gal nu mnii Ñgyoozh lo̱ nu gyicya̱, na Jeremías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na Jesuuz zum lo yu nu riib ic por cuen ni gubier par nu cugyiꞌy lom. Orzeꞌ nay: ―¿A ru nac ru rey ni de mbecy Israeel? ―nay. Orzeꞌ na Jesuuz: ―Laab ni gal nu ru mniir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Orzeꞌ de uz zub lo zeꞌ gal nu de yu bel ni de mbecy Israeel brugyiꞌ driib dey cyi too Jesuuz, tees rila wanniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Orzeꞌ Pilato bdugyiꞌy lom tuubaꞌ tir: ―¿A wagyeñ ru de cyi nu driib dey toor? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tees Jesuuz ni tub riidz wanniim. Orzeꞌ Pilato, yu nu riib ic zeꞌ, tonaꞌ la za nu ic yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na de ñaꞌn la, lat nu rzuꞌ saꞌ ni Pas, orzeꞌ yu nu riib ic zeꞌ, rlaay tub pres: ca ziꞌl na yu nu gnii mbecy nu dulaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tees tiem zeꞌ ri tub mbecy nu la Barrabás pres. Yu zeꞌ dela mbecy yuꞌ lo dey yu par nu dzi coz ily bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Orzeꞌ lat nu bi yuꞌ tublaazh de mbecy, orzeꞌ na Pilato rab yu dey: ―¿Ca na mbecy rlagy der nu gla̱a̱? ¿A gla̱a̱ Barrabás o ti gla̱a̱ Jesuuz, yu nu rnii der Mesías? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ni mniiy gun nap gud lagy yu nu nac gyel rasaap lagy, ndeꞌ nu bguꞌ dey Jesuuz yaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na lat nu gusub Pilato lugaar zeꞌ nu dri beey cyi, orzeꞌ bzeed mñaay tub raso̱o̱ loy. Orzeꞌ nam: “Cueꞌ neꞌ ic ru lat asunt ni mbecy nu sac falt ni zeꞌ, gun che tonaꞌ la shiñ bguu pcaala̱ nu nac mi zeꞌ”, na mñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tees de uz zub lo zeꞌ gal nu de yu bel zeꞌ pcuugy dey lardoo de mbecy zigy nu cyiñ dey nu glaa Pilato Barrabás. Orzeꞌ cyiñ dey nu gat Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tees ornu ni bicy dey, orzeꞌ Pilato, yu nu riib ic zeꞌ, orzeꞌ bdugyiꞌy lo dey tuubaꞌ tir. Orzeꞌ nay: ―¿Ca na dey lo cyup yu rlagy der nu gla̱a̱ yu? ―nay. Orzeꞌ na de mbecy: ―¡Barrabás! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Orzeꞌ na gaꞌ Pilato: ―Zeꞌ ¿la coz rlagy der nu gyicya̱ du̱ Jesuuz, yu nu rnii der Mesías? ―nay. Orzeꞌ dela dey mniiy: ―¡Cut ruy lo cruuz! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Orzeꞌ na gaꞌ Pilato: ―¿La ñuu coz a̱ꞌ nap bicy yu? ―nay. Tees dzi zir bish ti dey. Orzeꞌ na dey: ―¡Cut ruy lo cruuz! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na ornu Pilato gud lagy yu nu wayicy yu gan, sinu de mbecy zigy bi yuꞌ la dey nu gyicy yu coz deet, orzeꞌ mniiy lo tub mbecy nu cha gyiiy nis par nu naay lo rgüii la dela mbecy. Orzeꞌ nay: ―Ya̱ sac falt ne̱. Benu cut der mbecy nap ii, ndeꞌ falt ni de ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Orzeꞌ na gaꞌ de mbecy zigy: ―Nu gat yu zeꞌ, ndeꞌ cuen ne̱ de̱ ya̱, gal nu ni de nez de̱ nu gruu zac par lo ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Orzeꞌ Pilato blaay Barrabás nu nac de riidz nu mnii de mbecy. Orzeꞌ bicy yu mandaar nu gaaz dey Jesuuz. Orzeꞌ bguꞌy mi yaa dey par nu caa dey mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Orzeꞌ de soldad gua nu dey mi nañ yuꞌ zeꞌ nu riib ic de gubier. Orzeꞌ dela soldad nu yuꞌ zeꞌ byatublaazh dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Orzeꞌ bloo dey shab mi. Orzeꞌ bzuu dey mi tub negy ña. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Gazeꞌ nu bel dey ya gyech. Bzaa dey tub coron nu bri dey toom. Orzeꞌ bzuu dey tub yagyi yaa beem. Orzeꞌ gusu tib dey lom. Nunu brugyiꞌ rguu bdzaa dey mi. Orzeꞌ na dey: ―Shnu ru, rey ni de mbecy Israeel ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Orzeꞌ brugyiꞌ rco yeñ dey lom. Orzeꞌ bloo dey yag nu zu yaam zeꞌ, nunu brugyiꞌ rshet dey ñi toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ornu blazh bguu bdzaa dey mi, orzeꞌ bloo dey negy ña zeꞌ yeñ mi. Orzeꞌ bzuu dey mi laab shab mi. Orzeꞌ za nu dey mi par nu caay mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Orzeꞌ nez nu za dey bdzeel yu tub mbecy Cirene, yu nu la Simo̱o̱. Orzeꞌ por fers la pcaa dey yu nu cha nuy cruuz ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Orzeꞌ bruꞌña dey tub lugaar nu la Gólgota. Ndeꞌ tub riidz nu yaruuñ: Lugaar ni cyug too añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Gazeꞌ nu briic dey ñup urbyay nu yuꞌ can nu tub lo coz lya nu goꞌm. Tees ornu bicy mi preb ñi, orzeꞌ wangalagy mi goꞌm ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Orzeꞌ pcaa dey mi lo cruuz. Orzeꞌ de soldad bloo dey cuen ben ca na dey dugyiy tub ga shab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Despuees ni de nu ndeꞌ, orzeꞌ gusub dey nu rñay mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Orzeꞌ par too cruuz nu pcaa dey mi, pcaa dey tub gyicy cyim nu rniiñ de falt nim. Orzeꞌ rniiñ: “Yu ii Jesuuz, rey ni de mbecy Israeel”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Orzeꞌ niꞌ ziꞌl pcaa dey cyup gubaan lo cruuz cuit mi: tub yu par yaa beem, zeꞌ tuubaꞌy par yaa reg mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Orzeꞌ de mbecy nu rded lom rgyib la ic dey nu gyel rgubdzaa, nunu rab zi dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Orzeꞌ na dey: ―Ru mniir nu nit lor yuꞌ nu driib zily mbecy Ñgyoozh, nunu nañ chon dzi mniir nu shes sur ñii. ¡Na bloo mbañ ub ru na! Benu rishli nac ru iꞌñ Ñgyoozh. ¡Bet lo cruuz! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Niꞌ ziꞌl de uz zub lo, nu de yu nu rlyuu leey ni Ñgyoozh, nu de yu bel ni de mbecy Israeel bgubdzaa dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Orzeꞌ na dey: ―Bloo mbañ yu reñaꞌ mbecy, tees ub yu wagac co mbañ yu. Nunu nac yu rey ni de mbecy Israeel. Zeꞌ benu gyet yu lo cruuz, orzeꞌ cheña lagy den niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bicy cup yu consuel lo Ñgyoozh. Na rlagy ñi co mbañ Ñgyoozh yu benu rishli yet lagy mi mod nu bicy yu, gun rniiy nu nac yu iꞌñ mi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Orzeꞌ niꞌ ziꞌl de gubaan nu ca num lo cruuz brugyiꞌ nu rgubdzaa dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Orzeꞌ tub or widoo bet cow dutuub la lo yu gal tub gyiib chon or gudze, gazeꞌ nu bzu yaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gazeꞌ nu or zeꞌ ye brish ti Jesuuz. Orzeꞌ nam: ―Elí, Elí, ¿lema sabactani? ―nam. Riidz zeꞌ yaruuñ: “Ñgyoozh ne̱, Ñgyoozh ne̱, ¿lagu bzaan ru ya̱?” ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Orzeꞌ la be mbecy nu yuꞌ zeꞌ, ornu güeñ dey nu brish tim, orzeꞌ na dey: ―Yu re rbedz yu Elías, yu nu mnii por cuen ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Orzeꞌ lueg la tub mbecy gush yu carer gua gyiiy tub coz nu chayoꞌ nis. Orzeꞌ psal yuñ lo ñup zii ni urbyay. Gazeꞌ nu bzuub yuñ lo tub yagyi. Briic yuñ goꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tees deꞌ zir mbecy na dey: ―Blez güiin, ben a cyid Elías nu co mbañ yuy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Orzeꞌ tuubaꞌ tir ye brish tim. Orzeꞌ gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Orzeꞌ laab or zeꞌ negy nu zaab gyeroꞌ ni lugaar yon nañ yuꞌ nu driib zily mbecy Ñgyoozh pshala lañ gaal zi nu gush ñi gal ic lañ nu gal lo yu la. Nunu briib duru. Nunu de gyitaꞌ bet rich ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nunu de baa ni añ byaal ruꞌñ. Nunu zigy mbecy ni Ñgyoozh nu bi gut byabañ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Orzeꞌ bruu dey gyerbaa niy. Na despuees, ornu byabañ Jesuuz, orzeꞌ bya dey Jerusaleeng, gyedz ni Ñgyoozh. Orzeꞌ zeꞌ zigy mbecy bzaac dey de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na ornu bzaac yu nu riib ic de soldad gal nu deꞌ zir soldad nu briib duru zeꞌ nu dela deꞌ zir coz nu guc, orzeꞌ gudzib dey. Orzeꞌ na dey: ―¡Rishli gaal biñ ii guc mi iꞌñ Ñgyoozh! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Orzeꞌ zet yuꞌ zigy biñ mñaa. Rgüii dem lo Jesuuz. Laab de mi zeꞌ biñ nu gua ca ich Jesuuz nese nu gusam Galilea, nunu blocyuub dem Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lat de biñ mñaa zeꞌ ri Li nu bruu tub gyedz nu la Magadán, nu tuubaꞌ Li, ñaa Santiag nu See, nu ñaa de iꞌñ Zebedeo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na or bi yecheñ, orzeꞌ bruꞌña See, tub mbecy guaniꞌñ nu bruu Arimatea. Niꞌ yu zeꞌ nac yu tub yu nu rsyaꞌ lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Orzeꞌ guay lo Pilato, nu bdiiñ yu cuerp ni Jesuuz loy. Orzeꞌ Pilato mniiy nu cuic dey cuerp ni Jesuuz ni See. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Orzeꞌ gush yu cuerp nim, nunu ptiish yuñ tub sab cacy fin. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Orzeꞌ gua riy mi nañ tub gyerbaa cub ni ub yu. Gyerbaa zeꞌ sa bicy yu mandaar nu bduuñ dey ñi nañ gyitaꞌ. Orzeꞌ psoow yu ruꞌñ nu tub gyitaꞌ ily. Orzeꞌ yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tees Li nu bruu Magadán, nu tuubaꞌ Li gucua dem ruꞌ baa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na or bzaꞌ yu tuubaꞌ dzi, laab ndeꞌ dzi nu rzu lagy mbecy, orzeꞌ de uz zub lo, nu de mbecy fariseo gua dey lo Pilato. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Orzeꞌ na dey: ―Shi Pilato, byezaꞌ lagy de̱ nu lat nu gabee mbañ mbecy rguu zeꞌ, orzeꞌ nay: “Ornu bi bzaꞌ chon dzi nu guta̱, orzeꞌ gyabaña̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ndeꞌ nu ne̱e̱ lor nu gyicy ru mandaar lo de mbecy nu cha ña dey ruꞌ baa niy gashtal shuub la dzi chon, gun nis ruꞌña de yu nu rsyaꞌ loy rel. Orzeꞌ co dze dey cuerp niy. Gazeꞌ nu nii dey lo mbecy nu byabañ yu. Orzeꞌ benu ni gac nu nac gyel rguu zeꞌ, orzeꞌ shiñ zir gruuñ gazeꞌ gyel rguu nu mnii Jesuuz nu loga ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Orzeꞌ na Pilato: ―Gac cha nu der de soldad nu gña dey. Gua der nu gyicy segur ru ruꞌ baa niy. Ca na la benu gac ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Orzeꞌ bruu dey zay. Nunu bicy segur dey ruꞌ baa. Orzeꞌ pcaa dey beey lo gyitaꞌ nu rsoow ruꞌ gyerbaa zeꞌ. Nunu bzeeñ dey soldad zeꞌ nu rña dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na or bded sab, dzi nu rzu lagy mbecy, ornu bzaꞌ yu noming napor, orzeꞌ Li nu bruu Magadán, nu tuubaꞌ Li gua dem gal ruꞌ baa ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Orzeꞌ de repent la briib tub duru ily. Orzeꞌ bruu tub anc ni Ñgyoozh gashtal gyibaa. Bet yu lo yu. Orzeꞌ ptuyub yu gyitaꞌ nu rsoow ruꞌ gyerbaa zeꞌ. Gazeꞌ nu gusub yu tooñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anc zeꞌ rabeey gal nu rabee gyi ni guzii. Zeꞌ shab yu, ndeꞌ tub negy cacy iily laa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na ornu bzaac de soldad anc zeꞌ, orzeꞌ gush la bis dey nu tantaꞌ gudzib yu. Orzeꞌ bdzoꞌw la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Orzeꞌ anc zeꞌ nay rab yu de biñ mñaa zeꞌ: ―Cueꞌ dzib der. Ya̱ rad lagya̱ nu de ru ryub der Jesuuz, biñ nu gut lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Sacaꞌm ii. Bi byabañ mi gal nu mniim nu gzac mi. Orzeꞌ da der da güiir lugaar zeꞌ nu bri dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Orzeꞌ na gaꞌ anc zeꞌ: ―Dzach zi der yaa niir lo de yu nu rsyaꞌ lom. Niir nu Jesuuz bi byabañ mi. Orzeꞌ mi zeꞌ bi ya gam lo der par Galilea. Re zac der mi. Ni niir lo dey. Ndeꞌ coz nu ca lo cuen nu ne̱e̱ lo der ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Orzeꞌ dzach bruu dem ruꞌ baa zeꞌ yam carer. Gudzib dem tees niꞌ ziꞌl tonaꞌ la yet lagy dem. Orzeꞌ ya dem carer ya num raso̱o̱ lo de yu nu rsyaꞌ lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Orzeꞌ sij la bruu zac Jesuuz lo dem. Orzeꞌ nam: ―Shnu ru ―nam rab mi biñ mñaa zeꞌ. Orzeꞌ de mi zeꞌ bechaꞌm lo Jesuuz. Orzeꞌ bduyaa dem yeñ gyiꞌm nunu pca dem mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Orzeꞌ na Jesuuz rab mi de biñ mñaa zeꞌ: ―Cueꞌ dzib der. Yaa nii der lo de bicya̱ nu gya dey Galilea. Orzeꞌ zeꞌ zac dey ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na lat nu bi ya de biñ mñaa zeꞌ, orzeꞌ la be de soldad nu mña ruꞌ baa zeꞌ byay nu bya tooy riidz lo de uz zub lo dela de coz nu guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Orzeꞌ de uz zub lo zeꞌ guay gua tooy rishlo de yu bel ni de mbecy Israeel par nu gyicy dey tub ziꞌl riidz. Orzeꞌ sheñ tiñ briic dey ni de soldad. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Orzeꞌ na dey rab yu de soldad zeꞌ: ―Rlagy ñi nii der nu de yu nu rsyaꞌ lo Jesuuz, gua dey rel, orzeꞌ bloo dze dey cuerp ni Jesuuz lat nu nas der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nunu benu gyeñ Pilato, yu nu riib ic, nu ni mod bzac der, orzeꞌ de̱ ya̱ cyaag de̱ ic yu, gun orzeꞌ de̱ ya̱ soow su̱ de ru loy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Orzeꞌ de soldad zeꞌ gush dey de tiñ zeꞌ. Orzeꞌ bicy dey gal nu mnii de uz zub lo zeꞌ. Orzeꞌ riidz nu mnii de soldad zeꞌ, ndeꞌ riidz nu zaab lat de mbecy Israeel mas gashtal dzi na. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Orzeꞌ de trotub yu nu rsyaꞌ lom gua dey Galilea gashtal logyiꞌ zeꞌ nu mnii Jesuuz nu cha dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Orzeꞌ ornu bzaac dey mi, orzeꞌ pca dey mi. Nomaas yuꞌ la be mbecy lat dey nu wangad lagy dey ti laab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Orzeꞌ Jesuuz byagaab mi lo dey. Orzeꞌ nam rab mi dey: ―Ñgyoozh briic mi rishbeey ne̱ nu gyicya̱ dela coz gyibaa nu gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gua der lo dela mbecy nu yuꞌ dutuub la gyishlombecy, nunu gyicy der nu gyac dey mbecy nu rsyaꞌ lo̱. Nunu briic der nu zu nis dey par nu gabe nu nac nu dey Ñgyoozh uz den, nunu par nu gabe nu nac nu dey ya̱ iꞌñ mi, nunu par nu gabe nu nac nu dey Espiriit Yon nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nunu lyuu der ni dey nu gyicy paay nu dela coz nu mne̱e̱ lo der. Nunu cueꞌ nit lagy der nu ya̱ nac du̱ der dub laa tiem gashtal shuub la dzi ni gyishlombecy ii ―nam.");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nu loga la ni de riidz nu sac nu rnii de coz ni Jesucrisht, iꞌñ Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías, yu nu mnii por cuen ni Ñgyoozh nil bi pcaay: Ñgyoozh nam rab mi Mesías: Ya̱ zuu neza̱ tub mbecy nu cha nuy raso̱o̱ ne̱. Yu zeꞌ cha gay lo ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Zaab tiꞌ tub mbecy rbishtiy tub lugaar ub zi. Orzeꞌ nay: “Nañ lardoo den nañ gal nu na tub nez. Orzeꞌ bicy nap der nez zeꞌ par ornu cyid Shuaan den. Pshaal der tub nez nu li par nu ded mi”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Orzeꞌ mbecy nu bzuu nez Ñgyoozh zeꞌ, ndeꞌ Waa nu briib nis mbecy. Pcyiiñ yu tub lugaar ub zi nunu blyuuy ni de mbecy nu rlagy ñi neꞌ dey dela cyi nu ricy yu, nunu gzu nis dey. Orzeꞌ gyicy sulagy Ñgyoozh de cyi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Orzeꞌ zigy mbecy nu yuꞌ lo yu ni Judea nunu zigy de mbecy nu yuꞌ Jerusaleeng rza dey loy nu rzuub gyidag dey de riidz nu rniiy. Na ornu blazh pshuub ruꞌ dey dela cyi nu ricy dey na, orzeꞌ Waa briic yu nu wi nis dey gyoow Jordaang. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na shab Waa, ndeꞌ byaañ nu gyich camey. Zeꞌ nañ yu ri tub sinch gyid. Coz nu bdow yu, ndeꞌ gushagy nu dziñ doo ni bez gyish. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Orzeꞌ nay rab yu de mbecy: ―Par lo ya̱ bi yad la tuubaꞌ mbecy nu gac gyicy coz ily zir par ya̱. Ya̱ ni wayapa̱ nu shaagya̱ gyid nu zub gyid lab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya̱ rica̱ nu zu nis der nu nis, tees mi zeꞌ cuic mi Espiriit Yon ni der ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Orzeꞌ guc ñi tiem zeꞌ nu Jesuuz bruum Nazaret, tub gyedz nu ri lo de yu ni Galilea. Zam lo Waa gal ruꞌ gyoow Jordaang. Orzeꞌ Waa briic yu nu zu nis mi gyoow zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Orzeꞌ cuanzir nu bruum lo nis, bzaac mi byaal baa. Orzeꞌ Espiriit Yon ni Ñgyoozh gal nu na tub begy nam bet mi gusub mi toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Orzeꞌ zaab tiꞌ Ñgyoozh gal gyibaa rniim. Orzeꞌ nam: ―Ru nac ru iꞌña̱, biñ nu tonaꞌ la rca̱, nunu tonaꞌ la yet lagya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gazeꞌ nu lueg la Espiriit Yon ni Ñgyoozh gua num Jesuuz tub lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Orzeꞌ cyuu dzi brim lugaar ub zi zeꞌ. Zeꞌ bicy nuras preb mi. Zeꞌ brim lat de bañ gyish. Tees de anc bzu bich dey nu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na despuees nu guti Waa yuꞌ gyiib na, Jesuuz bruum lo yu ni Judea, zam par lo yu ni Galilea nu shaal mi riidz nu sac ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Orzeꞌ nam: ―Na bi pshuub dzi nunu sñuu ga cyid gyel gubier ni Ñgyoozh. Orzeꞌ mneꞌ der dela cyi nu ricy ru, nunu bicy cup der consuel lo de riidz nu sac zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na tub dzi na bded mi ruꞌ nisyudoo ni Galilea. Orzeꞌ bzaac mi Simo̱o̱ nu Ndrees bicy yu. Yuꞌ dey nu driy gyish nu rub bel lo nisyudoo, gun ruplaa dey nac yu mbecy rub bel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Orzeꞌ na Jesuuz rab mi dey: ―Da ca der icha̱. Orzeꞌ ya̱ gyicya̱ nu gal nu rub der bel, niꞌ ziꞌl teꞌ der mbecy gun orzeꞌ cyid ca dey icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Orzeꞌ lueg la bzeeñ dey gyish niy za cay ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na ornu bza gaꞌm sñuu miiñ par lo, zeꞌ bzaac mi Santiag, iꞌñ Zebedeo, nu bicy yu Waa yuꞌ dey nañ barc. Laabaꞌ gyish nu rub bel ricy nap dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Laab bzaac lam dey bredzaꞌ lam yu. Orzeꞌ lueg la bzeeñ dey uz yu Zebedeo nañ barc nu de moz niy. Orzeꞌ za ca la dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gazeꞌ nu bri num dey tub gyedz nu la Capernaum. Sab, dzi nu rzu lagy mbecy, guꞌ num dey nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tonaꞌ la za nu ic dey de coz nu rlyuum, gun rlyuum ni dey gal nu rlyuu tub mbecy nu riib ic zaꞌ la, walab gal nu ricy de yu nu rlyuu leey ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na nañ yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh zeꞌ, ri tub mbecy nu bicy ni nuras. Orzeꞌ rbish tiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Orzeꞌ nay rab yu Jesuuz: ―¿Lagu yad ru lat de̱ Jesuuz Nazaret? ¿A yad ru nu zaꞌ lor de̱ ya̱? Ya̱ rad lagya̱ nu ru nac ru mbecy yon ni Ñgyoozh ―nay rab yu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Orzeꞌ Jesuuz bdzaꞌm ni nuras zeꞌ. Orzeꞌ nam rab mi yu: ―Dzi chel nunu bruu chu lo yu ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Orzeꞌ nuras zeꞌ bicy yu nu bicy ñi bi ni mbecy zeꞌ. Nunu rbish tiy. Gazeꞌ nu bruu chuy loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Orzeꞌ dela de mbecy zeꞌ za nu la ic dey nunu brugyiꞌ rnii dey lo losaꞌy: ―¿Lac yaruu nii? Rlyuuy tub leey cub, nunu rlyuuy gal nu ricy mbecy nu riib ic zaꞌ la. ¡Gazaꞌ nuras ricy yu mandaar, nunu rzuub gyidag dey niy! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Orzeꞌ lueg la brush las de riidz ni de coz nu bicy Jesuuz dela lugaar nu yuꞌ gaab ga Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cuanzir bruum nañ yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh zeꞌ, orzeꞌ guam yuꞌ Simo̱o̱ nu Ndrees. Gua num Santiag nu Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tees ñaa gud Simo̱o̱ riib rat mi. Pcaañ zig nim. Cuanzir bruꞌña Jesuuz, mnii dey lom nu rat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Gazeꞌ nu gua Jesuuz bduꞌ yaam yaa biñ rat zeꞌ pshes sum mi. Orzeꞌ lueg la bruu zigy mi, nunu brugyiꞌ rzu bich mi nu nac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na ornu bi za doo, or nu bi yecheñ, orzeꞌ de mbecy bruꞌña nu dey dela mbecy rat nunu dela mbecy nu bicy ni nuras lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nunu dela mbecy gyedz byatublaazh dey roꞌ Simo̱o̱ nu Ndrees. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Orzeꞌ zigy mbecy bicy yac mi, nunu zañ lo güii bicy mi nu mnit ni dey. Nunu bloo chum zañ nuras. Tees wansaan mi nu nii de nuras, gun yuꞌ lo dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na tuubaꞌ dzi, or napor, gabee caas ruꞌ zu, orzeꞌ weshtem. Bruum lat gyedz. Zam tub lugaar ub zi nu nii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Zeꞌ Simo̱o̱ nu de losaꞌy gua yub dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na ornu byad mi na, orzeꞌ na dey rab yum: ―Dela mbecy ryub dey ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Orzeꞌ nam rab mi dey: ―Yaa chan deꞌ zir gyedz nu yuꞌ gaab ga, gun orzeꞌ shaal na de riidz nu bruu lo Ñgyoozh, gun par ndeꞌ yapa̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Orzeꞌ gusam dela gyedz nu yuꞌ Galilea. Pshaal mi de riidz nu bruu lo Ñgyoozh nañ de yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh. Nunu bloo chum zañ nuras nu bicy ni mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Orzeꞌ bruꞌña tub mbecy nu rat tub lo gyedz nu la lepra. Orzeꞌ gusu tib yu lo Jesuuz bdiiñ yu lom nu gyicy yac mi yu. Gazeꞌ nu nay rab yum: ―Ru gac gyicy yac ru ya̱ benu rlagy ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Orzeꞌ Jesuuz gushni lagy mi yu. Orzeꞌ gul yaam yu. Gazeꞌ nu nam rab mi yu: ―Rlagya̱. ¡Na byac ru! ―nam rab mi yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Orzeꞌ lueg la mnit la gyedz zeꞌ, nunu byacyudz dutuub la cuerp niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Orzeꞌ fert pcach mi ruꞌy. Gazeꞌ nu nam rab mi yu: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Na ne̱e̱ lor nu cueꞌ la niir lo ni tub la mbecy, sinu gua lo uz cha lyuur ub ru loy. Orzeꞌ cuic ru gun nu rlagy ñi par nu gyacaacy ru par lo Ñgyoozh gal nu rniiñ lo leey ni Moisees, gun orzeꞌ gad lagy dela mbecy nu bi byac ru ni güii nir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tees yu zeꞌ guay mniiy lo ti cyuꞌ la mbecy. Orzeꞌ brush las riidz zeꞌ gal wangacaꞌ la chuꞌm nu suelt la lat gyedz. Zeꞌ ngush ziꞌl gusam. Tees de mbecy nu bruu gal reñ ga la lugaar druꞌña ruꞌ dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Or bzaꞌ la be dzi bish cya gaꞌ Jesuuz yam par Capernaum. Orzeꞌ brush las riidz nu zum yuꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Orzeꞌ byatublaazh mbecy lom gal wagadaꞌ la lugaar nu gzu dey mas par ich zeꞌ nu zub gyeroꞌ. Nunu pshaal mi riidz ni Ñgyoozh lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Orzeꞌ bruꞌña tap mbecy. Bruꞌña nu dey tub mbecy chi̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na ornu tantaꞌ nu wangac chuꞌ dey lo Jesuuz na nu nac de mbecy zigy zeꞌ, orzeꞌ gup dey par too yuꞌ. Gazeꞌ nu pshaal dey par too yuꞌ nañ zeꞌ nu zub Jesuuz. Orzeꞌ pshet dey nuun nu riib mbecy rat zeꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Orzeꞌ ornu Jesuuz gud lagy mi nu ricy cup dey consuel lom, orzeꞌ nam rab mi mbecy chi̱ zeꞌ: ―Yu feñ, ya̱ bi ricy sulagya̱ de cyir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Laab zeꞌ nguaa la be de yu nu rlyuu leey ni Ñgyoozh. Orzeꞌ de yu zeꞌ na dey nañ lardooy: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Lagu ni rniiy? Coz nu rniiy, ndeꞌ zañ contr ni Ñgyoozh. Tub zi la Ñgyoozh gac gyicy sulagy mi de cyi nu ricy mbecy”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Orzeꞌ lueg la gud lagy Jesuuz nañ lardoom nu ni rnii too dey. Orzeꞌ nam rab mi dey: ―¿Lagu ni rnii too der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dzi zir a̱ꞌ biigy par nu ne̱e̱ nu bi ricy sulagya̱ de cyir gazeꞌ nu ne̱e̱ nu wes zu, byash nuun nir nunu bza. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tees ya̱ ne̱e̱ lo yu re nu gyes suy gzay par nu gad lagy der nu ya̱, biñ nu byac mbecy, ricy cupa̱ rishbeey nu gyicy sulagya̱ de cyi de mbecy gyishlombecy ii. Gazeꞌ nu nam rab mi mbecy rat zeꞌ: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ya̱ ne̱e̱ du̱ ru wes su, gush nuun nir, yaa yuꞌr ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orzeꞌ wes suy, nunu lueg la pshet yaay nuun niy. Orzeꞌ gush nez yu yay lo rgüii la dela mbecy zeꞌ. Nu nac ndeꞌ, ndeꞌ nu za nu ic dela dey nunu byabic dey gyel mbecy ni Ñgyoozh. Gazeꞌ nu na dey: ―Rila nigul zac na coz nu na gal na nii ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Gazeꞌ nu za gaꞌ Jesuuz par ruꞌ nisyudoo. Zeꞌ dela mbecy zigy bruꞌña dey lom, nunu rlyuum ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na nez nu zam, orzeꞌ bzaac mi Leví, iꞌñ Alfeo. Zub yu zeꞌ nu rboo mbecy tiñ por cuen ni gubier Rom. Gazeꞌ nu nam rab mi yu: ―Da ca icha̱ ―nam. Orzeꞌ wes suy za cay ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na despuees, lat nu zub Jesuuz rom gyit yuꞌ Leví, zeꞌ nguaa zigy mbecy nu rboo tiñ por cuen ni gubier, nu zigy de mbecy bduneꞌ. Nguaa dey zeꞌ nu Jesuuz nu de yu nu rsyaꞌ lom, gun yuꞌ zigy mbecy bduneꞌ lat de mbecy nu rdeꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na ornu bzaac de mbecy fariseo nu de mbecy nu rlyuu leey ni Ñgyoozh nu Jesuuz rom gyit nu de mbecy zeꞌ, orzeꞌ bdugyiꞌ dey lo de yu nu rsyaꞌ lom: ―¿Lagu moscuel ni de ru row yu gyit tublaazh nu de mbecy nu rboo tiñ por cuen ni gubier nu de mbecy bduneꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ornu güeñ Jesuuz ndeꞌ, orzeꞌ nam rab mi dey: ―Par de mbecy ruub walagy ñi doctoor, tees par de mbecy rat rlagy ñi. Gal nu doctoor wagyicy nuy mbecy ruub guñaa, niꞌ ya̱ a̱ꞌ yapa̱ nu redza̱ mbecy nu sac cyi, sinu dredza̱ de mbecy cyi par nu neꞌ dey cyiy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","De yu nu rsyaꞌ lo Waa nu briib nis mbecy, nu de yu nu rsyaꞌ lo de mbecy fariseo rca dey ni ub yu nu cueꞌ gow dey gyit lat nu rzu bich dey nu nac Ñgyoozh. Orzeꞌ gua mbecy lo Jesuuz. Orzeꞌ na dey rab yum: ―¿Lagu de yu nu rsyaꞌ lo Waa nu de yu nu rsyaꞌ lo de mbecy faraseo rca dey ni ub yu nu cueꞌ goy gyit lat nu rzu bich dey nu nac Ñgyoozh, tees de mbecy nu rsyaꞌ lo ru wagyicy dey ndeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ na gal nu na tub nob. ¿Walab gaal gac ca de yu nu yuꞌ lo fandang ni ub yu nu cueꞌ goy gyit lat nu gabee rded nob lat dey? Lat nu gabee rded nob lat dey, wac ca dey ni ub yu nu cueꞌ goy gyit. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tees shuub tub dzi nu co mbecy nob zeꞌ lat dey. Orzeꞌ tiem zeꞌ ca dey ni ub yu nu cueꞌ goy gyit par nu gyicy shni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Gun mod nu bicy de gyitoo bel, ndeꞌ nañ gal nu na tub negy gush. Ni tub la mbecy wayicy mi rumien negy gush nu tub laꞌ negy cub nu nigul gyoꞌ nis, gun nis gash beñ negy cub zeꞌ. Orzeꞌ shaa ye zir negy gush zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nunu mod nu bicy de gyitoo bel, ndeꞌ nañ gal na tub gyid gush nu rguꞌ choow dey ñup ni urbyay. Ni tub la mbecy wac cuꞌ choow yu ñup ni urbyay cub nañ gyid gush, gun nis cyich ñiñ. Orzeꞌ shu dela ñup ni urbyay zeꞌ, nunu nit lo gyid zeꞌ. Ndeꞌ nu rlagy ñi cuꞌ choow dey ñup urbyay cub nañ gyid cub ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na tub sab, dzi nu rzu lagy de mbecy Israeel, Jesuuz bded mi lat tub nac trig nu de yu nu rsyaꞌ lom. Orzeꞌ lat nu bded dem, orzeꞌ de yu nu rsyaꞌ lom zeꞌ brugyiꞌ rcyug dey zaꞌ nu gow dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na ornu gud lagy de mbecy fariseo na, orzeꞌ na dey rab yu Jesuuz: ―Güii, ¿lagu de yu nu rsyaꞌ lor ricy dey tub coz nu a̱ꞌ yad ñi nu gyicy dey dzi nu rzu lagy den? Ndeꞌ walab seꞌñ par lo leey ni den―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Orzeꞌ na Jesuuz rab mi dey: ―¿Walab gaal nigul syaꞌ der coz nu bicy Dabi tiem nu bicy falt coz nu cyiiñ niy lat nu byan yu nu de mbecy nu gusa nuy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Laab de yu zeꞌ guꞌy nañ yuꞌ ni Ñgyoozh tiem nu Abiatar bzuy riiñ ni yu nu riib ic de uz. Orzeꞌ Dabi bdow yu gyishtily nu bzeeñ de mbecy nañ yuꞌ zeꞌ. Ndeꞌ gyishtily nu zu riiñ lo Ñgyoozh. Nunu de uz nu zu riiñ ni Ñgyoozh ziꞌl gac gow yuñ. Tees Dabi bdow yu gyishtily zeꞌ, nunu briic yuñ gow de yu nu gusa nuy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Gazeꞌ nu naꞌm rab mi dey: ―Ñgyoozh psaꞌ lagy mi sab, dzi nu zu lagy mbecy par de mbecy. Walab nu psaꞌ lagy mi de mbecy par leey ni dzi nu rzu lagy mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ndeꞌ nu ya̱, biñ nu byac mbecy, riib ica̱ sab, dzi nu rzu lagy mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Orzeꞌ tuubaꞌ dzi, orzeꞌ gua gaꞌ Jesuuz nañ tub yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Zeꞌ ri tub mbecy yaa gush beñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Orzeꞌ de yu nu rzi lagy lom psiiñ dey nim ben a gyicy yac mi mbecy rat zeꞌ sab, dzi nu rzu lagy mbecy, gun dzi ga ñgyaad tub mod nu riib dey cyi ic mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Orzeꞌ nam rab mi mbecy yaa gush beñ zeꞌ: ―Wes su. Da lo̱ gashtal gazel ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gazeꞌ nu nam rab mi de yu nu rzi lagy lom: ―¿A nap zuñ par lo leey ni Moisees nu gyicy den coz nap sab, dzi nu rzu lagy mbecy? ¿A nap nu gyicy den coz nap uti nu gyicy den coz a̱ꞌ nap? ¿A nii tub dzi nu gloo mbañ naa mbecy uti tub dzi nu gnit lon mbecy? ―nam. Tees wannii la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Orzeꞌ bgüii tañ mi lo dey, nunu bicy mi sentiir, gun sac gyel rashni lagy ni dey. Gazeꞌ nu nam rab mi mbecy rat zeꞌ: ―Bzaab yaar lo̱ ―nam. Orzeꞌ mbecy zeꞌ bzaab yaay lom. Orzeꞌ byanap lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Gazeꞌ nu lueg la bruu chu de mbecy fariseo. Byatublaazh dey nu de mbecy ni Herodes nu bee dey riidz ben lac mod zaꞌ lo dey Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tees Jesuuz za num de mbecy nu rsyaꞌ lom gal ruꞌ nisyudoo. Nunu tonaꞌ la mbecy zigy za ca dey ich mi. Yuꞌ mbecy nu bruu de lo yu ni Galilea. Yuꞌ mbecy nu bruu de lo yu ni Judea. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yuꞌ mbecy nu bruu Jerusaleeng. Yuꞌ mbecy nu bruu lo de yu nu la Idumea. Yuꞌ mbecy nu bruu tub laꞌ gaꞌ ni gyoow Jordaang. Nunu yuꞌ gaꞌ mbecy nu bruu lo de yu ni Tiro nu Sidón. Dela zeꞌ bruu dey za güii dey Jesuuz gun güeñ dey de coz ily nu bicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gazeꞌ nu mniim lo de yu nu rsyaꞌ lom nu zu lily dey tub barc nu ruu chum nu nac de mbecy zigy nis cyiꞌñ zu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gun dela mbecy rat byatublaazh dey lom nu rlagy dey gal yaa dey mi nu nac nu bi bicy yac mi zigy mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nunu dela de yu nu bicy ni nuras, ornu rzac dey mi, yes saa la dey lom. Orzeꞌ dub ruꞌ la dey rbish ti nuy mi. Orzeꞌ rnii dey: ―¡Ru nac ru iꞌñ Ñgyoozh! ―rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Orzeꞌ tonaꞌ la fert mniim lo dey nu cueꞌ nii dey lo mbecy cyu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Despuees ndeꞌ gazeꞌ nu za Jesuuz tub logyiꞌ. Orzeꞌ bredz mi ca na de yu nu rlagy mi. Orzeꞌ gua dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Gazeꞌ nu bloo zum trocyup dey par nu chesa num yu nunu par nu zuu nez mi dey chay cha shaal dey de riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nunu briic mi rishbeey ni dey par nu co chu dey de nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Orzeꞌ nii nu la de trocyup yu nu pcuim zeꞌ. Gush lañ: Simo̱o̱, yu nu bloo lam Bed, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nu Santiag nu bicy yu Waa, de iꞌñ Zebedeo. De yu zeꞌ bloo lam Boanerges. Riidz zeꞌ yaruuñ: De Iꞌñ guzii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Zeꞌ tuubaꞌy Ndrees, nu Lip, nu Bartol, nu Mateo, nu Tomaas, nu Santiag, iꞌñ Alfeo, nu Tadeo, nu Simo̱o̱, yu nu nac partid nu la Celote, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nu Judas Iscariote, yu nu bish cya ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Orzeꞌ Jesuuz guꞌm nañ yuꞌ. Orzeꞌ zeꞌ byatublaazhaꞌ de mbecy zigy lom tuubaꞌ tir gal wangacaꞌ la ñgyow mi gyit nu de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Orzeꞌ de famil nim güeñ dey de coz nu guc. Orzeꞌ za dey lom nu ricy pee dey cha nu dey mi por fers la, gun mnii mbecy nu guton mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tees de mbecy nu bruu Jerusaleeng, de yu nu rlyuu leey ni Ñgyoozh, mnii dey nu Beelzebé, yu nu riib ic de nuras, bicy niy mi, nunu bicy yu nu cyiiñ yu ii nu co chuy deꞌ zir nuras, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Orzeꞌ Jesuuz bredz mi dey nu gyechaꞌ dey lom. Gazeꞌ nu mniim lo dey nu riidz tiily. Orzeꞌ nam: ―¿Walab gaal gac co chu nuras laab losaꞌ nuras yu? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Benu tub nac mbecy dulew dey nu chucoo dey laab nu losaꞌ ziꞌl yu, orzeꞌ rila wazu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nunu benu tub famil chu cooy laab nu losaꞌ ziꞌl yu, orzeꞌ niꞌ ziꞌl wazu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nunu benu de nuras dulew dey nunu chu coo dey laab nu losaꞌ dey, orzeꞌ niꞌ ziꞌl wazu dey, sinu nit lo dey ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Tees rlagy ñi nu gyicy mbecy gan yu nu riib ic de nuras zub lo. Gazeꞌ nu gac co chuy deꞌ zir nuras nu zaab ich. Gun ni tub la mbecy wac chuꞌy yuꞌ tub mbecy fert nu coy suuy benu wacyiigy dey yu loga. Tees benu nu loga la cyiig dey yu, gazeꞌ nu gac chuꞌ dey yuꞌy nu coy suuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Rishli, ya̱ ne̱e̱ lo der nu Ñgyoozh gac gyicy sulagy mi ni de mbecy ni de lo la cyi nu ricy yu nunu de lo la riidz a̱ꞌ nap nu rniiy, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tees cyu ziꞌl mbecy nu nii zi ni Espiriit Yon nim, yu zeꞌ wayicy sulagy mi niy. Ndeꞌ cyi nu rila wac gyecy ―na Jesuuz rab mi de mbecy nu shiñ mnii zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ni mniim lo dey gun mnii dey nu bicy ni nuras mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Orzeꞌ bruꞌña ñaam nu de bicy mi. Yuꞌ dey gashtal ich yuꞌ. Gazeꞌ nu bzeed dey raso̱o̱ lo Jesuuz nu cham lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Orzeꞌ na de mbecy zigy nu nguaa lom zeꞌ rab yum: ―Gal ich yuꞌ re zu ñaar nu de bicy ru ryub dey ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Orzeꞌ nam rab mi dey: ―¿Cyu ña̱a̱ nunu cyu de bicya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Gazeꞌ nu bgüiim dub yub la lom. Orzeꞌ nam rab mi dey: ―Ii nguaa ña̱a̱, nunu ii nguaa bicya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cyu ziꞌl mbecy nu ricy coz nu rlagy Ñgyoozh, de yu zeꞌ nac dey bicya̱, zana̱, nu ña̱a̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Orzeꞌ Jesuuz brugyiꞌ gaꞌm rlyuum ni de mbecy ruꞌ nisyudoo, nunu tonaꞌ la mbecy zigy byatublaazh dey lom. Orzeꞌ ndeꞌ nu guꞌm, nañ tub barc gusub mi gal zaab ziꞌl ñi lo nis. Zeꞌ de mbecy zigy gucua dey lo yu ruꞌ nisyudoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zeꞌ blyuum zañ coz ni dey nu riidz tiily. Na lat nu rlyuum ni dey, orzeꞌ nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Bzuub gyidag der: Tub mbecy bruuy zay za nuuz yu mbigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lat nu rtich yu mbigy zeꞌ, yuꞌñ bet lag ñi ruꞌ gyernez. Orzeꞌ bruꞌña chigyiñ bdow ma ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zeꞌ yuꞌ gaꞌñ bet lag ñi lo yu las ruꞌ nu ri gyitaꞌ par nañ. Orzeꞌ dzach briib ñi gun las ruꞌ yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Na ornu briib doo na, orzeꞌ bziiñ. Orzeꞌ guwach ñi gun sac sheñ yu nu shet nap ñi lyuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zeꞌ yuꞌñ bet lag ñi lat gyech. Orzeꞌ dzach guuly gyech zeꞌ. Orzeꞌ pcyiig ñi de yamni zeꞌ. Orzeꞌ wancuic ñi cosech. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Zeꞌ yuꞌ gaꞌñ nu bet lag ñi lo yu nap. Briib ñi nunu guuly ñi. Orzeꞌ tonaꞌ la cosech nap briic ñi. Yuꞌñ briic ñi gal rub tii mbigy. Yuꞌñ briic ñi gayon mbigy. Yuꞌñ briic ñi tub gaynal mbigy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Orzeꞌ na gaꞌm: ―Yu nu zub gyidag rlagy ñi gyicy yu nu gyet lag yu cuen ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na ornu bya ub zim, de yu nu yuꞌ lom nu de trocyup yu nu bloo sum zeꞌ bdugyiꞌ dey lom lac yaruu de riidz tiily zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gazeꞌ nu nam rab mi dey: ―Ñgyoozh briic mi nu gad lagy de ru coz ni gyel gubier nim, de coz nu wangad lagy mbecy gulas. Zeꞌ de mbecy nu a̱ꞌ riib ic mi, ya̱ rshaala̱ lo dey nu riidz tiily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Gun orzeꞌ mas zac dey, tees wayuꞌ loy, nunu mas gyeñ dey, tees wayet lag dey cuen, nunu nis cush cya dey par lom. Orzeꞌ gyicy sulagy mi ni dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gazeꞌ nu naꞌm rab mi dey: ―Benu wagyet lag der cuen riidz tiily zeꞌ, ¿lac mod gyet lag der cuen deꞌ zir ñi? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yu nu gua nuuz mbigy zeꞌ, ndeꞌ yu nu rshaal riidz nu bruu lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yuꞌ mbecy nu na gal nu na mbigy nu nguaa ruꞌ gyernez, lugaar zeꞌ nu bdunuuz riidz ni Ñgyoozh. Orzeꞌ cuanzir nu reñ dey riidz zeꞌ, orzeꞌ lueg la druꞌña nuras nu rbooy ñi nañ lardoo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Zeꞌ yuꞌ gaꞌ mbecy nu na gal nu na mbigy nu nguaa lo yu las ruꞌ nu ri gyitaꞌ par nañ zeꞌ. Ornu nu loga la reñ dey riidz ni Ñgyoozh zeꞌ, orzeꞌ “O” rnii dey, nunu yet lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tees par nu las ruꞌ yu zeꞌ, orzeꞌ wac shet riidz zeꞌ sheñ lyuñ. Orzeꞌ ragyee dey la be ziꞌl tiem. Tees despuees, ornu druꞌñañ nu rzac zi dey o nu rzac deet dey nu nac riidz zeꞌ, orzeꞌ druu chu dey lo riidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Zeꞌ yuꞌ gaꞌ mbecy nu na gal na de mbigy nu bdunuuz lat gyech zeꞌ. De yu zeꞌ rzuub gyidag dey riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tees de gyel rsug ic nu nac de coz ni gyishlombecy ii, nunu de gyel ye rzac lo gyel nap, nunu de gyel rzaab lagy reñaꞌ coz, de ndeꞌ ricy ñi gan dey. Gal nu ricy gyech nu wacsaan ñi cuic yamni cosech, ni ricy de coz zeꞌ. Wacsaan ñi gyicy nap riidz ni Ñgyoozh shcab ni de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Zeꞌ yuꞌ gaꞌ mbecy nu na gal nu na de mbigy nu bet lag lo yu nap zeꞌ. De yu zeꞌ “O” rniiy ornu reñ yu de riidz ni Ñgyoozh, nunu rbic ñi cosech nañ lardoo dey. Yuꞌñ rbic ñi gal rub tii. Yuꞌñ rbic ñi gayon. Yuꞌ gaꞌñ rbic ñi tub gaynal. Ni ricy riidz ni Ñgyoozh nu mbecy zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Gazeꞌ nu na gaꞌm: ―¿Walab gaal ri de mbecy tub candiil nañ tub cajo̱o̱ o nañ tub nuun? ¿A walab nu rzuub dey ñi seꞌñ? Gun orzeꞌ cuic ñi yaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sac ni tub coz ngach nu waruu zac ñi. Nunu dela coz nu wagad lagy mbecy, ndeꞌ gad lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","De mbecy nu zub gyidag rlagy ñi gyicy yu nu gyet lag yu cuen ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gazeꞌ nu na gaꞌm: ―Orzeꞌ nap bduꞌ cuen der de riidz nu reñ ru nim, gun dub gal nu ricy yac der de riidz zeꞌ, dub ñi gyet lag zir ru cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gun yu nu ricy yac de riidz zeꞌ nay gal na tub mbecy nu ricy cup la coz. Yu nu ricy cup sheñ, sheñ zir gad niy. Zeꞌ yu nu sac ni, gashtal coz miiñ nu ricy cup yu gruuñ niy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Orzeꞌ naꞌm: ―Gyel gubier ni Ñgyoozh rac ñi gal nu rac nu tub mbecy nu rnuuz mbigy. Mbecy rza nuuz yu mbigy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Orzeꞌ raas yu. Or zaꞌ yu yeshtey. Lat nu zaab za la dzi niy, mbigy zeꞌ driib ñi. Gazeꞌ nu raly ñi. Nunu wagad lagy yu lac mod driib ñi nunu ni lac mod raly ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gun ub la yu ricy ñi nu driib mbigy zeꞌ. Orzeꞌ nu loga la raly tub gyizh. Orzeꞌ gazeꞌ nu daꞌ zaꞌ niñ. Orzeꞌ lat zeꞌ raly de mbigy nu daꞌ nañ gyez zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Orzeꞌ ornu bi gul de mbigy zeꞌ, lueg la shiꞌñ yuñ gun bi pshuub dzi nu dudeꞌñ. Niꞌ ziꞌl mod rac nu gyel gubier ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Gazeꞌ nu na gaꞌm: ―¿La ñuu coz nu rac gal nu rac nu gyel gubier ni Ñgyoozh? ¿La ñuu coz saapa̱ nu gyel gubier nim? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gyel gubier ni Ñgyoozh rac ñi gal nu rac nu tub mbigy ya urnishtas. Ornu rdunuuz ñi, miiñ zir ñi par dela mbigy nu yuꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tees ornu dunuuz ñi, orzeꞌ raly ñi. Orzeꞌ zily zir ñi yac ñi gazeꞌ deꞌ zir yag miꞌ. She rgyich yaañ mas gal de chigyiñ rzaa ma teez ma lat gaꞌl nu rbic de yaañ zeꞌ. Ni mod rac nu gyel gubier ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zañ riidz tiily nu na gal nu na de ndeꞌ mniim. Ni mod blyuum de riidz ni gyel gubier ni Ñgyoozh ni dey. Dub gal mod nu gac gyet lag dey cuen, dub ni mniim lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tees wanniim lo dey benu walab nu de riidz tiily zeꞌ. Nunu ornu ub zim nu de yu nu rsyaꞌ lom, orzeꞌ pshaal mi dela riidz zeꞌ lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Laab dzi zeꞌ, or becheñ, orzeꞌ Jesuuz nam rab mi dey: ―Yaa der chan gal naa tub laꞌ gaꞌ dzu ruꞌ nisyudoo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Orzeꞌ bzeeñ dey dela mbecy zigy, za nu dey Jesuuz laab nañ barc nu bi rim zeꞌ. Nunu za gaꞌ reñaꞌ barc zeꞌ nu za barc nu rim zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tees lat nu za dey zeꞌ, sij la bruꞌña tub gyey bi ily. Orzeꞌ de nguuly lo nisyudoo rzuꞌñ nañ barc zeꞌ se nu dzaa ziꞌl ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zeꞌ Jesuuz mbish mi nas mi par iiñ barc zeꞌ lo tub almad. Gazeꞌ nu pcueeñ dey mi. Orzeꞌ na dey rab yum: ―¡Masht! ¿A se la la nu ricy ñi nir nu nit lo den lo nis? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Gazeꞌ nu weshtem nunu bicy mi mandaar lo bi. Orzeꞌ nam rab mi nisyudoo: ―¡Guri! ―nam. Orzeꞌ guri bi nunu se ri zu la byac. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Gazeꞌ nu nam rab mi dey: ―¿Lagu dzi rdzib der? ¿Walab gaal gabee wagyicy cup der consuel lo̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Orzeꞌ tonaꞌ la gudzib dey. Orzeꞌ na dey rab yu losaꞌy: ―Zeꞌ ¿cyu mbecy nac mi ii? Gal bi nunu gal nisyudoo rzuub gyidag ñi nim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Orzeꞌ bruꞌña dey tub laꞌ gaꞌ ruꞌ nisyudoo lo yu ni Gerasa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Orzeꞌ cuanzir nu bruu Jesuuz nañ barc zeꞌ, orzeꞌ lueg la bdzeel mi tub mbecy nu bruu lat de blyuu nu rcach de mbecy añ. Yu zeꞌ tub mbecy nu bicy ni nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nunu lat de blyuu zeꞌ rcyiiñ yu. Nunu ni tub la mbecy wagac cyiig yuy. Mas nu caden wagac gag yu, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","gun zañ tir pcyiig dey gyiꞌy nu yaay nu caden. Tees rsug yu caden zeꞌ. Nunu ni tub la mbecy wagac gyicy yu nu cuez seꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Zaab za lay dzi rel la rded yu de logyiꞌ nu lat de blyuu zeꞌ. Rbish tiy, nunu rshiꞌñ yu ub yu nu gyitaꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tees ornu bzaac yu Jesuuz zet ruꞌ nu zam, orzeꞌ gush yu carer zay lom. Orzeꞌ gusu tib yu lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Gazeꞌ nu na Jesuuz rab mi yu: ―Bruu chu lo mbecy ii nuras ―nam. Orzeꞌ dub ruꞌ la nuras zeꞌ rbish tiy. Gazeꞌ nu nay rab yu Jesuuz. ―¿La ryub ru yad ru lo̱ Jesuuz, iꞌñ Ñgyoozh, biñ nu zily zir nac? ¡Cyoozh cueꞌ sheed zir ya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Orzeꞌ na Jesuuz rab mi yu: ―¿La lar? ―nam. Gazeꞌ nu nay rab yum: ―Ya̱ la̱ bee miily gun zigy de̱ naca̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Orzeꞌ tonaꞌ mnishbaay lom nu cueꞌ co chum yu lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na par gyiꞌ bicy zeꞌ tonaꞌ la cuch zigy rded ma row ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Orzeꞌ dela nuras zeꞌ mnishbaa dey lo Jesuuz. Gazeꞌ nu na dey: ―Bzuu nez de̱ ya̱ lo de cuch re gun orzeꞌ chu̱ꞌ de̱ nañ ma ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Orzeꞌ briic Jesuuz rishbeey nu gruu dey. Gazeꞌ nu bruu dey lo mbecy zeꞌ. Guꞌy nañ de cuch zigy zeꞌ. Orzeꞌ rzab la de ma bzu tiily ma par gyoow. Bet lag de ma lo nisyudoo. Gut de ma lo nis. Cyup la miily cuch zeꞌ gut ma lo nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Orzeꞌ de yu nu rña de cuch zeꞌ gush dey carer ya niiy de coz nu guc lo de mbecy nu yuꞌ lat gyedz nu lo de mbecy nu yuꞌ ngush. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na ornu bruꞌña de mbecy zeꞌ lo Jesuuz nunu ornu bzaac dey mbecy nu bicy ni de nuras zeꞌ, zub yu, zuy shab yu, nunu byanap shcab niy, orzeꞌ tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Orzeꞌ dela de mbecy nu bzaac coz nu guc zeꞌ mniiy lo de mbecy zigy zeꞌ lac mod guc nu de cuch zeꞌ nunu lac mod guc nu mbecy nu bicy ni nuras zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Orzeꞌ brugyiꞌ rnishbaa dey lo Jesuuz nu ruum ledz dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na ornu guꞌ Jesuuz nañ barc zeꞌ, orzeꞌ yu nu bicy ni nuras zeꞌ mnishbaay lom nu cha num yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tees Jesuuz wansaan mi. Orzeꞌ nam rab mi yu: ―Yaa lo de famil nir nunu niir de coz ily nu bicy Ñgyoozh num ru. Niir nu Ñgyoozh gushni lagy mi ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gazeꞌ nu mbecy zeꞌ gush nez yu zay. Orzeꞌ brugyiꞌ rniiy lo dela mbecy nu yuꞌ lo de yu ni Decápolis de coz ily nu bicy Jesuuz num yu. Orzeꞌ tonaꞌ la za nu ic de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Orzeꞌ Jesuuz guꞌm nañ barc gulaꞌm tub laꞌ gaꞌ dzu ruꞌ nisyudoo. Orzeꞌ tonaꞌ la mbecy zigy byatublaazh dey lom. Laab ruꞌ nisyudoo zeꞌ zum. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Orzeꞌ bruꞌña tub mbecy nu la Jairo, yu nu riib ic nañ tub yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Laab bzaac lay Jesuuz, orzeꞌ wes saay lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nunu tonaꞌ la mnishbaay lom. Orzeꞌ nay rab yum: ―Iꞌña̱ se nu gat ziꞌl lañ. Cua̱a̱ ya̱ chan gal yaar ñii gun, orzeꞌ gyac ñi, nunu cui mbañ ñi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Orzeꞌ Jesuuz za num yu. Tonaꞌ la mbecy zigy za ca dey ich mi gal rcyiꞌñ su la dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Orzeꞌ lat de mbecy zeꞌ ri tub biñ mñaa nu bzaꞌ trocyup ñaꞌn rshu reñ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Zigy doctoor bicy nuy mi zañ lo guñaa. Mnit lo dela tiñ nim, nunu wangyac mi. Ca nu bicy ye zir ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na ornu guꞌ gyidag mi de coz nu bicy Jesuuz na, orzeꞌ bechaꞌm par ich Jesuuz lat de mbecy zigy zeꞌ, nunu gul yaam shab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Gun mnii toom nu mas ñuu shab Jesuuz gal yaam, orzeꞌ gyac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Orzeꞌ laab or la zeꞌ guca reñ zeꞌ, nunu gud lagy lam nu byac mi ni güii zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lueg la gud lagy Jesuuz nañ lardoom nu bruu fers nim. Orzeꞌ bish cyam bgüiim par ich mi lat de mbecy zigy. Gazeꞌ nu nam: ―¿Cyu gul shaba̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Orzeꞌ de yu nu rsyaꞌ lom na dey rab yum: ―Ru rzac ru nu de mbecy zigy rcyiꞌñ su dey ru. Zeꞌ ii nar: “¿Cyu gul ya̱?” nar ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tees gabee rgüii ruꞌm dub yub la lom par nu zac mi cyu gul mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Orzeꞌ bruꞌña biñ mñaa zeꞌ. Tonaꞌ la gudzib mi, nunu rash la bis mi, gun gud lagy mi coz nu bzac mi. Orzeꞌ wes saam yeñ gyiꞌ Jesuuz, nunu mniim dela coz nu rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Gazeꞌ nu na Jesuuz rab mi biñ mñaa zeꞌ: ―Biñ mñaa, ru byac ru gun bicy cup ru consuel lo̱. Orzeꞌ dub gusht la yaa, nunu bi mnit güii nu rat ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lat nu gabee rnii nu ruꞌ Jesuuz biñ mñaa zeꞌ, orzeꞌ bruꞌña tub mbecy nu bruu yuꞌ mbecy nu riib ic zeꞌ. Orzeꞌ nay rab yu yu nu riib ic zeꞌ: ―Iꞌñ ru bi guut ñi. Cueꞌ gaꞌ gyicy seed zir ru Masht ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tees Jesuuz wangyicy cuen lam de riidz nu rniiy. Orzeꞌ nam rab mi yu nu riib ic zeꞌ: ―Cueꞌ dzib ru. Bicy cup ziꞌl consuel lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Orzeꞌ wansaanaꞌm cha ca zir mbecy ich mi nomaas Bed, nu Santiag, nu Waa, bicy yu za num. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gazeꞌ nu ornu bruꞌñam yuꞌ yu nu riib ic zeꞌ, orzeꞌ bzaac mi nu se byach ziꞌl mbecy yuꞌy. Yuꞌ mbecy ruun yu. Yuꞌ gaꞌy rbish tiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na ornu guꞌm nañ yuꞌ na, orzeꞌ nam rab mi dey: ―¿Lagu dzi rded deet der? ¿Lagu ruun der? Zeꞌ fiñ nguzh ii nu nas ñi; walab nu guut ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Orzeꞌ brugyiꞌ rigy nu naañ dey mi. Orzeꞌ bloom dela dey par ich yuꞌ zeꞌ. Orzeꞌ guꞌm nu uz fiñ nguzh zeꞌ nu ñaañ nu chon de yu nu rsyaꞌ lom zeꞌ par zeꞌ nu mbish ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Orzeꞌ bduꞌ yaam yaañ. Gazeꞌ nu nam rab mi ñii: ―Talita cum ―nam. Benu gyal riidz zeꞌ, orzeꞌ nam: Fiñ nguzh, ya̱ rne̱e̱ du̱ ru weshte, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Orzeꞌ laab or la zeꞌ weshte fiñ nguzh zeꞌ brugyiꞌ rded ñi. Na fiñ zeꞌ bi yuꞌñ tub ñaꞌn trocyup. Orzeꞌ tonaꞌ la za nu ic de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tees Jesuuz pcach mi ruꞌ dey nu cueꞌ la cuic dey nu gad lagy mbecy nu ni bicy mi. Nunu mniim nu cuic dey coz nu gow fiñ nguzh zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Orzeꞌ bruu Jesuuz lugaar zeꞌ yam par ledz mi, Nazaret. Nunu de yu nu rsyaꞌ lom ya nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na ornu pshuub sab, dzi nu rzu lagy mbecy na, orzeꞌ brugyiꞌ rlyuum ni dey nañ yuꞌ nu rsyaꞌ dey riidz ni Ñgyoozh. Ornu de mbecy zigy güeñ dey de coz nu rlyuum, orzeꞌ tonaꞌ la za nu ic dey. Orzeꞌ na dey: ―Zeꞌ ¿ca guud de riidz re niy? Zeꞌ ¿ca guud shcab niy? Zeꞌ ¿lac mod rac ricy yu nusuriidz ily zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Zeꞌ ¿a walab yu ii biryag zeꞌ? Ñaay Li. Bicy yu Santiag, nu See, nu Judas, nu Simo̱o̱. Nunu ¿a walab laab lat na ii rcyiiñ de zan yu? ―na dey. Orzeꞌ wancheel reñ dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Orzeꞌ nam rab mi dey: ―Ca ziꞌl lugaar mbecy rca lagy dey lo yu nu rnii por cuen ni Ñgyoozh, nomaas de mbecy ledz yu, nu de famil niy, nu de famil nu yuꞌ nuy nañ yuꞌy, dela de yu zeꞌ waca lagy dey loy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Orzeꞌ zeꞌ wangac gyicy mi nusuriidz, nomaas la be ziꞌl mbecy rat gul yaam dey. Bicy yac mi yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Orzeꞌ za nu la ic mi nu wangyicy cup dey consuel lom. Orzeꞌ bruum Nazaret, gusam deꞌ zir gyedz nu yuꞌ gaab. Blyuum ni de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Orzeꞌ bredz mi de trocyup yu nu bi bloo sum zeꞌ nu gyatublaazh dey. Gazeꞌ nu brugyiꞌ rzuu nez mi dey rzay cyup ga dey tub ga nez. Nunu briic mi rishbeey nu co chu dey nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nunu bicy mi mandaar lo dey nu cueꞌ cha nuy ni tub la coz par nez. Nomaas tub yanga ziꞌl dey cha nuy. Ni cueꞌ cha nu dey moraal, ni cueꞌ cha nu dey gyishtily, nunu cueꞌ cha nu dey tiñ nañ nerbid niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nomaas gyidlab ziꞌl caa gyiꞌ dey. Nunu cueꞌ cha nu dey cyup yaag yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Orzeꞌ naꞌm rab mi dey: ―Ca zeꞌ nu cha der, guꞌ der nañ tub yuꞌ. Orzeꞌ zeꞌ cyiiñ der gashtal gruu la der lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ca ziꞌl zeꞌ nu washet ic dey nu chuꞌ der, ni wazuub gyidag dey riidz nu nii der, orzeꞌ ornu gruu der lugaar zeꞌ, cyib der yu gyedz nu taꞌ gyidlab ru par nu gabe nu a̱ꞌ nap bicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Orzeꞌ bruu dey zay nunu mnii dey lo de mbecy nu rlagy ñi neꞌ dey dela cyi nu ricy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nunu bloo chu dey zañ nuras. Nunu briily dey asecy zigy mbecy rat. Nunu byac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bzu laa riidz de coz nu ricy Jesuuz. Orzeꞌ rey Herodes güeñ yu de riidz zeꞌ. Orzeꞌ nay: ―Byabañ Waa nu briib nis mbecy. Ndeꞌ nu cyiiñ yu nu gyicy yu de nusuriidz zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yuꞌ mbecy rnii dey nu Jesuuz nac mi Elías. Nunu yuꞌ gaꞌ mbecy rniiy nu Jesuuz nac mi tub mbecy nu rnii por cuen ni Ñgyoozh gal nu na de yu nu guꞌ gulas. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ornu Herodes güeñ yu de coz nu mnii mbecy, orzeꞌ nay: ―Laab yu zeꞌ Waa, yu nu bicya̱ mandaar nu pcyug dey too. Na byabañ yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ni mniiy gun laab yu bicy yu mandaar nu pcyiig dey Waa, nunu pshet lag dey yu nañ yuꞌ gyiib nu nac Herodías, mñaa bicy yu Lip, gun Herodes gush yum. Bicy mñaay mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Zeꞌ Waa mniiy lo Herodes nu rach ñii lo Ñgyoozh nu gush yu mñaa bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Orzeꞌ Herodías guzi lagy mi lo Waa. Ngulagy mi ñgyut mi yu tees wangac, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","gun Herodes gudzib yu loy. Gud lagy yu nu Waa nac yu mbecy nap par lo mbecy, nunu tant par lo Ñgyoozh. Orzeꞌ wansaan yu nu shiñ gyicy nu mbecy Waa. Nunu ornu mnii Waa loy, bet lagy yu mas pcan shcab niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tees orzeꞌ pshuub tub dzi nu guud mod nu gyicy Herodías nu gat Waa. Dzi zeꞌ, ndeꞌ dzi nu bicy dey saꞌ ni dzi nu gul Herodes. Orzeꞌ bredz yu de fushtiz, nu de yu nu riib ic de soldad, nu de yu nu ricy ñi presis nu yuꞌ lo de yu ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Orzeꞌ ornu bruꞌña iꞌñ Herodías zeꞌ nu nguaa dey, orzeꞌ bily gyiꞌñ. Orzeꞌ tonaꞌ la bet lagy Herodes gal nu de mbecy nu nguaa nuy lo mez. Orzeꞌ nay rab yu fiñ zeꞌ: ―Bdiiñ la ziꞌl coz nu rlagy ru lo̱. Orzeꞌ ya̱ rica̱ ñii nir ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Orzeꞌ mniiy nu waded la cuic yu la ziꞌl coz nu cyiñ ñi mas gal cyaal de coz nu riib ic yu cuic yu niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ornu bruuñ, orzeꞌ zañ lo ñaañ. Gazeꞌ nu nañ rab ñim: ―¿La coz diña̱? ―naañ. Orzeꞌ na Herodías rab mi ñii: ―Gua cyiñ ru too Waa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Orzeꞌ fiñ zeꞌ rlal dza lañ lueg la zañ lo Herodes bdiiñ ñi too Waa. Gazeꞌ nu nañ: ―Ya̱ rlagya̱ nu lueg la cuic ru too Waa nu driib nis mbecy nañ tub gyaꞌn ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes tonaꞌ la bicy shniy. Tees gun bi mniiy nu waded la cuic yu la ziꞌl coz nu cyiñ ñi nunu bi güeñ dela mbecy nu nguaa nuy zeꞌ, orzeꞌ wangacaꞌ gyicy cyup ic yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Orzeꞌ lueg la bzuu nez yu tub soldad bicy yu mandaar loy nu cyid nuy too Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Orzeꞌ gua soldad zeꞌ, pshiñ yu too Waa nañ yuꞌ gyiib. Orzeꞌ biid nuy ñi nañ tub gyaꞌn. Briic yu ni fiñ feñ zeꞌ. Orzeꞌ fiñ feñ zeꞌ byabic ñi ndeꞌ ni ñaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na ornu gud lagy de yu nu rsyaꞌ lo Waa na, orzeꞌ gua te dey cuerp niy. Pcach dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zeꞌ de trocyup aposht nu bzuu nez Jesuuz zeꞌ bi byatublaazhaꞌ dey nuy mi. Orzeꞌ mnii dey lom dela coz nu bicy yu nu dela coz nu blyuuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Orzeꞌ Jesuuz nam rab mi dey: ―Yaa der chan tub lugaar ub zi. Zu lagy ñuu der ―nam. Ni mniim gun tonaꞌ la zigy mbecy ya yeed la dey gashtal wacuicaꞌ lañ tiem nu gow dey gyit. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Orzeꞌ guꞌ num dey nañ tub barc. Za dey tub lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tees de mbecy bzaac dey bruum zam, nunu byuꞌ lo dey mi. Orzeꞌ zigy mbecy nu bruu dela gyedz nu yuꞌ ruꞌ nisyudoo zeꞌ, bicy lal dey zay gyiꞌ lay tub laꞌ gaꞌ ruꞌ nisyudoo. Orzeꞌ bruꞌña dey anzir nu ruꞌñam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na ornu bruum nañ barc zeꞌ, orzeꞌ bzaac mi dela mbecy zigy zeꞌ. Orzeꞌ gushni lagy mi dey, gun na dey gal na shily nu sac cyu rña. Zeꞌ brugyiꞌ rlyuum zañ lo coz ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ornu bi rdze, orzeꞌ de yu nu rsyaꞌ lom nay rab yum: ―Ii tub lugaar ub zi nunu tonaꞌ la gudze. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Orzeꞌ bzuu nez mbecy chay de lugaar ii nu de gyedz nu yuꞌ gaab. Orzeꞌ zi dey coz nu gow yu, gun ii sac coz nu gow dey ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Orzeꞌ na Jesuuz rab mi dey: ―De ru, briic coz nu gow dey ―nam. Orzeꞌ na dey rab yum: ―¿Walab gaal galagy ru nu gzi̱ de̱ bee miily la tiñ gyishtily nu ricy na gow dey? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Orzeꞌ na Jesuuz: ―¿La be gyishtily ricy cup der? Gua güii der ben ―nam. Ornu gud lagy dey la be, orzeꞌ na dey: ―Gaay gyishtily nu cyup bel ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Orzeꞌ Jesuuz mniim lo dela mbecy nu zub yu lo de gyizh caꞌ bee nac gay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Orzeꞌ gucua bee nac ga mbecy. Lo tub nac ga dey bee tub gaynal yu o bee cyaal gaynal yu gucuay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Orzeꞌ bduꞌ yaam gaay gyishtily zeꞌ nu cyup bel zeꞌ. Bgüiim par baa. Nunu briic mi gras ni Ñgyoozh nu nac de ndeꞌ. Gazeꞌ nu blew mi gyishtily zeꞌ briicaꞌm ñii ni de yu nu rsyaꞌ lom nu cyez dey ñi ni de mbecy zigy. Orzeꞌ blewaꞌm cyup bel zeꞌ briicaꞌm ñii ni de yu nu rsyaꞌ lom par nu cyez dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Orzeꞌ dela de mbecy bdow gyel la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ornu bded nu bdow dey, orzeꞌ brusub trocyup ruꞌ chicyiw de coz nguzh ni gyishtily zeꞌ nu ni de bel zeꞌ nu pteꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lo dela yu gyeey nu bdow de gyishtily zeꞌ, gaay miily dey nac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cuanzir blazh ndeꞌ, orzeꞌ Jesuuz mniim lo de yu nu rsyaꞌ lom nu chuꞌ dey nañ barc nu cha ga dey lom gal tub gyedz nu ri tub laꞌ gaꞌ ruꞌ nisyudoo nu la Betsaida. Ub mi byeeñ gam par nu nii num de mbecy ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na or blazh nu mnii num dey ñgyoozh na, orzeꞌ pcam par tub logyiꞌ. Zam nu nii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na ornu becheñ na, barc zeꞌ ri nu dey ñi laab gazel nisyudoo. Zeꞌ Jesuuz ub zi lam byeeñ mi par lo yu bigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Orzeꞌ bzaac mi nu tonaꞌ la fers za barc ni dey, gun par nez nu zañ druu bi. Na ornu gabee caas ruꞌ zu, orzeꞌ rza la Jesuuz. Lo nis zam lo dey. Orzeꞌ ricy peem nu ded lom lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Na ornu bzaac dey nu yad mi lo nis, orzeꞌ bis guzii dey mi. Orzeꞌ bish ti dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gun dela dey bzaac yum, nunu tonaꞌ la gudzib dey. Tees Jesuuz lueg la mnii num dey. Orzeꞌ nam rab mi dey: ―¡Briic der baloor! ¡Ya̱ ndeꞌ! ¡Cueꞌ dzib der! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Orzeꞌ guꞌm nañ barc zeꞌ nu yuꞌ dey, nunu guca nu druu bi. Orzeꞌ tonaꞌ la za nu ic dey, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","gun wangyet lag dey cuen coz nu bicy mi nu de gyishtily zeꞌ. Gun noow na shcab ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ornu blazh bded dey lo nisyudoo, bruꞌña dey lo de yu ni Genesaret. Ruꞌ zeꞌ bzeeñ dey barc niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Orzeꞌ cuanzir nu bruu Jesuuz nañ barc zeꞌ, lueg la byuꞌ lo de mbecy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Orzeꞌ dzach la gusa dey dutuub la lugaar, nunu brugyiꞌ druꞌña nu dey mbecy rat lo nuun ca ziꞌl lugaar nu güeñ dey nu zum. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ca ziꞌl zeꞌ nu rded mi, de ranch, de lat gyedz, o ngush, pcuaa dey de mbecy rat de lat yagyiꞌ, nunu mnishbaa dey lom nu zaan mi gal dey mas ñuu ruꞌ shab mi. Orzeꞌ dela de yu nu gul mi byac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Orzeꞌ la be de mbecy fariseo nu la be de mbecy nu rlyuu leey ni Ñgyoozh bruu dey Jerusaleeng gua dey lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dey zeꞌ bzaac yu nu la be de mbecy nu rsyaꞌ lo Jesuuz a̱ꞌ caacy yaa dey row yu gyit, gun wannaa dey gal nu rlagy ñi par lo leey ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gun dela mbecy fariseo nu dela mbecy Israeel wow dey benu wanaa dey gal nu rlagy ñi nu ricy yac dey de cushtom ni gyitoo bel niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nunu ornu rza dey yagyiꞌ, ornu cush cya dey driy, benu wanaa dey, wagow yu. Nunu zañ zir cushtom rlagy ñi gyicy yac dey. Gush lañ: mas ñuu nu rgyiib dey de coz. Yuꞌ mod nu rgyiib dey taz, de gyaꞌn, de gyiib nu ray de coz, de nuun, de. Dela ndeꞌ rlagy ñi gyicy yac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Orzeꞌ de mbecy fariseo nu de mbecy nu rlyuu leey ni Ñgyoozh bdugyiꞌ dey lo Jesuuz. Orzeꞌ na dey: ―¿Lagu de yu nu rsyaꞌ lo ru wagyicy yac dey cushtom ni de gyitoo bel nu wagnaa dey row yu gyit? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Orzeꞌ nam rab mi dey: ―Tonaꞌ la nap mnii Isaías lac na de ru, mbecy nu rzuu lo, ornu pcaay: De mbecy ii rzat dey ya̱ nu ruꞌ ziꞌl yu, tees nañ lardoo dey ricy zet lagy yu lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Se la la cyiiñ nu driib zily dey ya̱, gun driib zily ton dey ya̱. Leey nu bloo ic mbecy, ndeꞌ ziꞌl rlyuu dey. Ni na Ñgyoozh lat de riidz ni Isaías. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Rzu chu der leey ni Ñgyoozh par nu rzu fert der cushtom ni mbecy ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Orzeꞌ na gaꞌm: ―Dzi ga nap nu rzu chu der leey ni Ñgyoozh par nu gyicy yac der leey ni gyitoo bel ni der, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","gun Ñgyoozh pcaam Moisees nu caay: “Pca lagy lo uz ru nunu pca lagy lo ñaar. Yu nu nii zi ni uz, o yu nu nii zi ni ñaa, rlagy ñi nu gat yu”, pcaa Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Tees de ru rniir nu benu tub mbecy niiy lo uz yu o niiy lo ñaay nu la ziꞌl coz nu rlagy ñi cuic yu ni dey, ndeꞌ corbán, orzeꞌ walagy ñi locyuub yu uz yu nu ñaay. (Corbán ndeꞌ yaruuñ gun nu rbic dey lo Ñgyoozh.) ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Orzeꞌ ricy der nu se la la cyiiñ riidz ni Ñgyoozh par nu nac de cushtom nu bzeeñ de gyitoo gush ni der. Nunu zañ zir coz nu na gal na ndeꞌ ricy der ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gazeꞌ nu bredz mi de mbecy zigy nu gyatublaazh dey lom. Orzeꞌ nam rab mi dey: ―Dela der bzuub gyidag der nunu bicy der nu gyet lag ru cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sac ni tub la coz par ich mbecy nu ornu chuꞌñ nañ yu gyicy ñi nu gabag yu. Tees de coz nu druu nañ lardoo mbecy, dela ndeꞌ ricy ñi nu rabag yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Benu zub gyidag der, orzeꞌ rlagy ñi nu zuub gyidag der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Orzeꞌ bruum lo de mbecy zigy zeꞌ yam. Ornu guꞌm nañ yuꞌ, orzeꞌ de yu nu rsyaꞌ lom bdugyiꞌ dey lac za de riidz nu mniim zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Orzeꞌ nam rab mi dey: ―¿Walab gaal niꞌ de ru wagyet lag der cuen? ¿Walab gaal wagad lagy der nu coz nu chuꞌ nañ mbecy wac gyicy ñi nu gabag yu? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gun de coz zeꞌ walab nañ lardooy rzuꞌñ, sinu nañ yu, nunu ruu gaꞌñ ―nam. Ndeꞌ yaruuñ nu dela coz nu gow mbecy nac ñii coz cacy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Orzeꞌ na gaꞌm: ―Gun de coz nu druu nañ lardoo mbecy, de ndeꞌ ricy ñi nu rabag yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gun nañ lardoo dey druu shcab a̱ꞌ nap. Zeꞌ druu nu ral dey losaꞌy nu wanchelaay. Zeꞌ druu nu ricy dey gubaan. Zeꞌ druu nu rut dey losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Zeꞌ druu nu ral dey mñaa losaꞌy. Zeꞌ druu nu ye rzac dey lo coz ni losaꞌy. Zeꞌ druu nu shiñ ricy dey. Zeꞌ druu nu rguu dey. Zeꞌ druu de lo la bis nu ricy cup dey. Zeꞌ druu nu ricy saap lagy dey. Zeꞌ druu nu rnii dey rishcuen. Zeꞌ druu nu ricy leꞌ dey. Zeꞌ druu nu ricy dey de lo la coz ton. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dela coz a̱ꞌ nap zeꞌ druuñ nañ lardoo mbecy, nunu ricy ñi nu rabag yu ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Orzeꞌ bruum lugaar zeꞌ zam par lo de yu ni gyedz Tiro. Orzeꞌ guꞌm nañ tub yuꞌ. Wangalagy mi nzac mbecy mi tees wangac ngach lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Orzeꞌ lueg la güeñ tub biñ mñaa nu gu iꞌñ tub fiñ feñ nu bicy ni nuras nu zu Jesuuz. Orzeꞌ bruꞌñam wes saam yeñ gyiꞌm, nunu mnishbaam lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Biñ mñaa zeꞌ walab mbecy guledz tees nac mi mbecy sirofenicia. Orzeꞌ mnishbaam lo Jesuuz nu co chum nuras nu bicy ni iꞌñ mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Orzeꞌ Jesuuz nam rab mi biñ mñaa zeꞌ: ―Nu loga la rlagy ñi locyuuba̱ de neza̱, de mbecy Israeel. Gun de yu zeꞌ nac yu iꞌñ Ñgyoozh. Gun walab seꞌñ nu gruu gyishtily yaa de yu nguzh duneꞌñ lo che̱ꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Orzeꞌ na biñ mñaa zeꞌ: ―Tees mas de che̱ꞌ nu rded nañ mez gow ma nguzh ruꞌ de fiñ nguzh nu gyet lag lo yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Orzeꞌ na gaꞌ Jesuuz rab mim: ―Nu nac nu ni mniir, gya lar. Bi bruu chu nuras lo iꞌñ ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Orzeꞌ gush nez biñ mñaa zeꞌ yam. Na or brim yuꞌm na, bzaac mi iꞌñ mi, nunu bi bruu chu nuras loñ riib ñi lo nuun. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zeꞌ Jesuuz bruum de lugaar garee Tiro zam par gyedz Sidón. Gazeꞌ nu bruum Sidón zam par de lugaar nu la Decápolis. Orzeꞌ bruum Decápolis. Gazeꞌ nu zam par lo nisyudoo ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Orzeꞌ zeꞌ bruꞌña nu dey tub mbecy go̱ꞌ. Nunu wagac nii nap yu. Mnishbaa dey lom nu gal yaam yu par nu gyicy yac mi yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Orzeꞌ Jesuuz bruu num mbecy rat zeꞌ lat de mbecy zigy. Gua nu reñ mi yu. Gazeꞌ nu mneꞌ mbiz mi gyidag yu. Pcoom nis yeñ mi yaam. Gazeꞌ nu gul mi lyudz yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gazeꞌ nu bgüiim par baa. Byash lagy mi. Orzeꞌ nam rab mi yu: ―¡Efata! ―nam. Benu gyal riidz nu mniim zeꞌ, orzeꞌ nam: ¡Byaal!, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Orzeꞌ lueg la byaal la gyidag yu nunu byachi̱ lyudz yu. Nunu byanap la rniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Gazeꞌ nu bicy mi mandaar nu cueꞌ la nii dey lo ni tub la mbecy. Dub gal nu fert zir rcach mi ruꞌ dey dub ni mnii zir dey lo mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tonaꞌ la za nu ic mbecy. Orzeꞌ na dey: ―Dela coz nu ricy yu nap ricy yu. ¡Ricy yu nu reñ mbecy go̱ꞌ nunu ricy yu nu rnii mbecy gop! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tiem zeꞌ, ornu byatublaazhaꞌ dela mbecy zigy nunu wangad coz nu gow dey, orzeꞌ Jesuuz bredz mi de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ya̱ rashni lagya̱ de mbecy zigy, gun bi bzaꞌ chon dzi nu yuꞌ dey lo̱ ii, nunu blazh coz nu gow dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Benu zuu neza̱ dey gyay yuꞌy gal ran ziꞌl yu, orzeꞌ suun ñi dey nez, gun yuꞌ dey zet bruuy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Orzeꞌ na de yu nu rsyaꞌ lom rab yum: ―¿Lac gyicyaꞌ de ub na goow na dela mbecy zigy lugaar ub zi ii? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Orzeꞌ nam rab mi dey: ―¿La be gyishtily ricy cup der? ―nam. Orzeꞌ na dey: ―Gagy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Gazeꞌ nu bicy mi mandaar lo de mbecy zigy nu checua dey. Orzeꞌ gush mi gagy gyishtily zeꞌ. Orzeꞌ briic mi gras ni Ñgyoozh. Gazeꞌ nu blew mi ñii. Briic mi ni de yu nu rsyaꞌ lom nu cuic dey ni de mbecy zigy. Gazeꞌ nu bleez dey ñi ni dela mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ricy cupaꞌ dey la be bel miꞌ. Orzeꞌ briicaꞌm gras ni Ñgyoozh nunu pcaa gaꞌm de yu nu rsyaꞌ lom nu cuic dey ma gow de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Orzeꞌ dela mbecy zigy bdow gyel la dey. Orzeꞌ blazh zeꞌ, pteꞌ dey gagy la chicyiw coz nguzh nu brusub. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","De yu nu bdow zeꞌ, tap miily dey nac yu. Orzeꞌ Jesuuz ptush las mi dey yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gazeꞌ nu lueg la guꞌ num de yu nu rsyaꞌ lom nañ tub barc. Bruum lugaar zeꞌ. Gazeꞌ nu bruꞌñam lo yu nu la Dalmanuta. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Orzeꞌ bruꞌña de mbecy fariseo brugyiꞌ rgugyiꞌ dey lom par nu gyicy dey preb mi. Bdiiñ dey lom nu gyicy mi tub nusuriidz baa par nu gabe nu Ñgyoozh nac num mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gazeꞌ nu gyi la byash lagy mi. Orzeꞌ nam rab mi dey: ―Ya̱ warica̱ nusuriidz. ¿Lagu rgyiiñaꞌ de mbecy nu yuꞌ na nusuriidz? Ya̱ rishli rne̱e̱ lo der nu wadaꞌ nusuriidz par de mbecy nu yuꞌ na ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Orzeꞌ bruum lugaar zeꞌ. Guꞌ gaꞌm nañ barc zam tub laꞌ gaꞌ ruꞌ nisyudoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na de yu nu rsyaꞌ lom na mnit lagy dey cha nuy gyishtily. Nomaas tub zi gyishtily ricy cup dey nañ barc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Orzeꞌ Jesuuz mniim lo dey nu gyicy cuidad dey. Gazeꞌ nu nam rab mi dey: ―Bduꞌ cuen der nunu bicy cuidad der nu lebadur ni de mbecy fariseo nu lebadur ni Herodes ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Orzeꞌ de yu nu rsyaꞌ lom bee dey riidz nu losaꞌy. Gazeꞌ nu na dey: ―¿Ti walab nu a̱ꞌ dun gyishtily, ndeꞌ nu ni rniim? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ornu gud lagy Jesuuz coz nu mnii dey, orzeꞌ nam rab mi dey: ―¿Lagu rnii der nu wancyiid nu der gyishtily, ndeꞌ nu ni mne̱e̱? ¿Walab gaal wagyet lag der cuen? ¿Walab gaal noow na shcab ni der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zub urlo der, ¿walab gaal wacsac der? Nunu zub gyidag der ¿walab gaal wagyeñ der? Nunu ¿walab gaal wagyezaꞌ lagy der? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ornu blewa̱ gyishtily nu bdow gaay miily mbecy, ¿la be la chicyiw gyishtily nu brusub pteꞌ der? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Orzeꞌ na dey: ―Trocyup ―nay. Orzeꞌ nam: ―Zeꞌ ornu blewa̱ gyishtily nu bdow tap miily mbecy, ¿la be chicyiw gyishtily nu brusub pteꞌ der? ―nam. Orzeꞌ na dey: ―Gagy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gazeꞌ nu nam rab mi dey: ―¿A walab gaal gabee wagyet lag ruꞌ der cuen? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gazeꞌ nu bruꞌñam Betsaida. Zeꞌ bruꞌña nu dey tub mbecy lo caꞌ lom. Mnishbaa dey lom nu gal yaam yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Orzeꞌ bduꞌ yaam yaa mbecy lo caꞌ zeꞌ. Gua num yu par ruꞌ gyedz. Orzeꞌ pcoom nis yeñ mi urloy nunu gul yaam yu. Gazeꞌ nu bdugyiꞌm loy ben a rzac yu mas ñuu ga. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gazeꞌ nu brugyiꞌ rgüiiy. Orzeꞌ nay rab yum: ―Ya̱ rzaca̱ mbecy gal na yag nay rded yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bdaabaꞌ yaam urloy. Orzeꞌ mbi la bgüiiy. Orzeꞌ byac yu nunu byanap la rzac yu dela coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Gazeꞌ nu bzuu nez mi yu gyay yuꞌy. Orzeꞌ nam rab mi yu: ―Cueꞌ chuꞌr lat gyedz ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Despuees orzeꞌ bruu Jesuuz Galilea za num de yu nu rsyaꞌ lom par de gyedz nu yuꞌ lo yu ni Cesarea ni Filipo. Nez zam bdugyiꞌm lo de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―¿Cyu rnii mbecy nu nac ya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Orzeꞌ na dey: ―Yuꞌ mbecy rniiy nu ru Waa nu briib nis mbecy. Zeꞌ yuꞌ gaꞌ dey rniiy nu ru Elías. Zeꞌ yuꞌ gaꞌ dey rniiy nu ru tub yu nu guꞌ gulas nu mnii por cuen ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Orzeꞌ nam rab mi dey: ―Zeꞌ de ru, ¿cyu rnii der nu naca̱? ―nam. Orzeꞌ na Bed rab yum: ―Ru nac ru Mesías, biñ nu ca lo cuen nu co mbañ de mbecy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Orzeꞌ Jesuuz mniim lo dey nu cueꞌ niiy lo ni tub la mbecy cyu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Gazeꞌ nu brugyiꞌ rlyuum ni dey nu ub mi, biñ nu byac mbecy, rlagy ñi gzac mi zañ lo coz deet. Nunu de yu bel ni de mbecy Israeel, nu de uz zub lo, nu de yu nu rlyuu leey ni Ñgyoozh, de yu zeꞌ rlagy ñi neꞌ dey mi. Nunu rlagy ñi nu cut dey mi. Tees nañ chon dzi gyabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Orzeꞌ naal la mniim de coz zeꞌ. Orzeꞌ Bed gua nu reñ yum. Gazeꞌ nu mniiy lom nu cueꞌ ni niim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tees Jesuuz bish cyam bgüiim lo de yu nu rsyaꞌ lom. Orzeꞌ fert mniim lo Bed. Orzeꞌ nam: ―¡Bruu chu lo̱ ii nuras! Gun shcab nir wasaap ñi shcab ni Ñgyoozh, sinu shcab nir, ndeꞌ shcab ni mbecy ziꞌl ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Orzeꞌ bredz mi dela mbecy nu de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―Benu ca na mbecy rlagy yu gac yu mbecy nu rsyaꞌ lo, orzeꞌ rlagy ñi cueꞌ gyicy cuen yu coz nu rlagy ub yu. Nunu rlagy ñi shet ic yu nu gzac ziy nu nac ya̱. Orzeꞌ rlagy ñi gyicy yu gal nu rlagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gun yu nu rlagy co nap ub, yu zeꞌ gnit loy. Tees yu nu nit lo nu nac ya̱, nunu nu nac riidz nu sac nu bruu lo Ñgyoozh, yu zeꞌ yu nu rishli gruu mbañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gun ¿la rusub ni mbecy benu gyicy yu gan dela coz nu yuꞌ gyishlombecy tees lardooy duneꞌñ? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nunu ¿la coz gac cyish mbecy nu gyad lardooy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tees cyu ziꞌl mbecy nu gat lo nu nac ya̱ nunu gat lo gaꞌy nu nac de riidz nu rne̱e̱ lo rgüii la mbecy nu wagyicy paa ni Ñgyoozh nunu de mbecy cyi nu yuꞌ na, orzeꞌ niꞌ ya̱, biñ nu byac mbecy, gat lo̱ nu nac de yu zeꞌ ornu shuub dzi nu yapa̱ nu gyel lily ni uza̱ gal nu de anc yon ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Orzeꞌ naꞌ Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu yuꞌ ca na mbecy nu yuꞌ ii na la nu wat dey gal zac la dey nu cyid gyel gubier ni Ñgyoozh, nunu gabe nu dzi coz ily gac ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ornu bded tub shuup dzi, orzeꞌ Jesuuz gua nu reñ mi Bed, nu Santiag, nu Waa. Orzeꞌ gup mi too tub bicy gya num dey. Orzeꞌ zeꞌ bdza nu nam lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Shab mi byaryal ñi. Tonaꞌ la byacaacy ñi. Caacy zir ñi byac ñi gazeꞌ nu caacy nu ricy de lo la yashtily nu yuꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Orzeꞌ zeꞌ bruu zac Elías nu Moisees lo rgüii la de yu nu rsyaꞌ lom. Orzeꞌ bee dey riidz nu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Orzeꞌ na Bed rab yu Jesuuz: ―Masht, ¡dzi ga nap nu yu̱ꞌ de̱ ii! Na za̱a̱ de̱ chon ramad ni der: tub par ru nu tuubaꞌ par Moisees nu tuubaꞌ par Elías ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ni mniiy, gun wagad lagy yu coz nu niiy, gun tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Orzeꞌ bruu zac tub za psoow ñi dey. Nunu lat za zeꞌ zaab tiꞌ mbecy. Orzeꞌ nam: ―Mi ii iꞌña̱ nu tonaꞌ la rca̱. Bzuub gyidag der nim ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Orzeꞌ sij ziꞌl ornu briꞌ lo dey wansacaꞌ dey cyuꞌ zir mbecy. Zeꞌ Jesuuz ziꞌl bzaac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Gazeꞌ nu gush nez num dey bet mi par gyiꞌ bicy zeꞌ. Na lat nu ya num dey, orzeꞌ pcach mi ruꞌ dey nu cueꞌ nii dey lo ni tub la mbecy de coz nu bzaac yu. Sinu gal ornu gyabañ Jesuuz, biñ nu byac mbecy, gazeꞌ nu nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Orzeꞌ bicy yac dey pcach ruꞌ dey. Tees bdugyiꞌ dey lo losaꞌy lac yaruu nu gyabañ mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Orzeꞌ na dey rab yum: ―¿Lagu de yu nu rlyuu leey ni Ñgyoozh rniiy nu Elías rlagy ñi cyid yu loga la? Gazeꞌ nu cyid Mesías, biñ nu ca lo cuen nu co mbañ mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Orzeꞌ na Jesuuz rab mi dey: ―Laab rlagy ñi cyid Elías loga nu gzu nap yu dela coz. Nunu bi cañ nu ya̱, biñ nu byac mbecy, rlagy ñi gzac zi̱ nu zañ lo coz, nunu rlagy ñi gyicy ñgya dey lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tees ya̱ rne̱e̱ lo der nu Elías rishli bi biid yu nunu bicy nu dey yu dela coz a̱ꞌ nap nu mnii too dey nu gyicy nuy yu gal nu bi cañ nu gzac yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na ornu bruꞌñam gyiꞌ bicy zeꞌ, zeꞌ nu byeeñ deꞌ zir de yu nu rsyaꞌ lom, orzeꞌ zeꞌ bzaac mi nu tonaꞌ la mbecy zigy byatublaazh lo de yu zeꞌ. Nunu gazaꞌ de yu nu rlyuu leey ni Ñgyoozh yuꞌy zi ro dey riidz nu de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na cuanzir nu bzaac dey mi, orzeꞌ za nu la ic dey, nunu bechaꞌ dey lom carer mnii nuy mi ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Orzeꞌ nam rab mi de yu nu rlyuu leey ni Ñgyoozh: ―¿La coz rgugyiꞌ der lo dey? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Orzeꞌ brusu tub mbecy lat de mbecy zigy zeꞌ nay rab yum: ―Masht, ya̱ yap du̱ iꞌña̱ nu bicy ni nuras lor. Bicy yu nu byagop yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ca ziꞌl nu shet yaay yu ricy yu nu ricy ñi bi niy. Bdziñ la driib ruꞌy, nunu row yu lay yu, nunu rgyigy yu. Ya̱ mne̱e̱ lo de yu nu rsyaꞌ lor nu co chu dey yu, tees wangac ni dey ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Orzeꞌ na Jesuuz rab mi dey: ―¡A̱ der mbecy nu yuꞌ na! Dzi ga wagyicy cup der consuel lo̱. ¿Laꞌ zir be tiem rlagy ñi chesa̱ du̱ der? ¿Laꞌ zir be tiem rlagy ñi nu gagye̱ lo der? Da nu der yu nguzh rat zeꞌ lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gazeꞌ nu gua nu dey yu nguzh zeꞌ lom. Orzeꞌ ornu bzaac yu Jesuuz, orzeꞌ lueg la bicy nuras zeꞌ nu bicy ñi bi niy. Wes saa lay rdudub lay mbish yu. Nunu driib bdziñ ruꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Gazeꞌ nu na Jesuuz rab mi uz yu: ―¿La be la tiem rac nu ni rzac yu? ―nam. Orzeꞌ nay rab yum: ―Nese miiñ lay ni rzac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nunu zaab cyaꞌ la rshes saa nuras yu lo boo nunu rshet lag yuy lo nis par nu cut yuy. Tees benu gac gyicy ru la ñuu nur yu, gushni ñuu lagy de̱. Blocyuub de̱ benu gac ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Orzeꞌ na Jesuuz rab mi yu: ―Yadaꞌ nu naꞌr: “Benu gac”, naꞌr. Dela coz gac gyicya̱ du̱ yu nu ricy cup consuel ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Orzeꞌ lueg la brish ti uz yu nguzh zeꞌ. Orzeꞌ nay: ―Ya̱ ricy cupa̱ consuel lor. Nunu blocyuub ya̱ nu gyicy cup zira̱ consuel ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Orzeꞌ ornu Jesuuz bzaac mi nu byatublaazh de mbecy zigy lom, gazeꞌ nu rdzaꞌm ni nuras zeꞌ. Orzeꞌ nam rab mi yu: ―Nuras nu ricy go̱ꞌ nunu nu ricy gop, ya̱ ricya̱ mandaar lor nu bruu chu loy ii. Nunu cueꞌ gaꞌ cush cyar cyid ru loy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Orzeꞌ brish ti nuras zeꞌ, nunu bicy yu nu tonaꞌ la bi ily bicy ñi ni yu nguzh zeꞌ. Gazeꞌ nu bruu chuy. Bya añ la yu nguzh zeꞌ bzeeñ yu gal mnii la de mbecy nu gut yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tees Jesuuz bduꞌ yaam yaay bles sum yu. Orzeꞌ wes suy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Despuees ornu Jesuuz brim yuꞌ, gazeꞌ nu de yu nu rsyaꞌ lom bdugyiꞌ reñ la dey lom. Orzeꞌ na dey: ―¿Lagu wangac loo chu̱ de nuras zeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Orzeꞌ nam rab mi dey: ―Nuras nu ni na wac ruu chuy i ziꞌl, sinu rlagy ñi cyiñ mbecy lo Ñgyoozh nunu rlagy ñi nu ca dey ni ub yu nu cueꞌ goy gyit lat nu zu bich dey nu nac Ñgyoozh. Orzeꞌ gazeꞌ nu gac co chu dey nuras zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gazeꞌ nu bruum lugaar zeꞌ gusam dela lo yu ni Galilea, nunu wangalagy mi nu gad lagy mbecy ca chesam, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","gun blyuum ni de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―Ya̱, biñ nu byac mbecy, guꞌ dey ya̱ yaa de mbecy. Orzeꞌ cut dey ya̱. Tees nu zaꞌ dzi chon gyabaña̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tees wangyet lag dey cuen lac yaruu riidz zeꞌ. Nunu gudzib dey nu cugyiꞌy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Gazeꞌ nu brim gyedz Capernaum. Ornu guꞌm nañ yuꞌ, orzeꞌ bdugyiꞌm lo dey. Orzeꞌ nam rab mi dey: ―¿La ridz ro der nu losaꞌr ornu yap na nez? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tees wannii la dey gun gyernez bee dey riidz nu losaꞌy nu ca na dey gac yu yu nu gya zir zu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gazeꞌ nu gusub mi nunu bredz mi zaꞌ trocyup laa dey. Orzeꞌ nam rab mi dey: ―Benu ca na mbecy rlagy yu gac yu yu nu gya zir zu, orzeꞌ rlagy ñi gyicy yu nu nac yu mbecy nu wagyicy ñi presis nunu gyicy yu de coz nu rlagy dela losaꞌy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Orzeꞌ bduꞌ yaam tub yu nguzh miꞌ. Bzum yu lat dey. Gazeꞌ nu bri yaam yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Orzeꞌ nam rab mi dey: ―Cyu ziꞌl yu nu shet ic nu gac yu tub yu nu na gal na yu nguzh miꞌ ii nu nac ya̱, orzeꞌ niꞌ ziꞌl shet ic yu nu gac nuy ya̱. Nunu yu nu shet ic nu gac nu ya̱, walab ne̱ ya̱ ziꞌl shet ic yu, sinu niꞌ shet ic yu ni biñ nu bzuu nez ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Orzeꞌ na Waa rab yum: ―Masht, de̱ ya̱ bzaac de̱ tub mbecy bloo chuy nuras nu nac rishbeey nu bruu lor, tees mne̱e̱ de̱ nu cueꞌ nu ni gyicy yu gun wachesa nuy de ub na ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Orzeꞌ na Jesuuz: ―Cue ca der niy, gun sac ni tub la mbecy nu gyicy nusuriidz nu nac rishbeey nu bruu lo̱, se lueg la gac shiñ niiy ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gun yu nu wacha contr nin, yu zeꞌ yu nu rza faboor ni den. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nunu cyu ziꞌl mbecy nu cuic mas ñuu tub taz nis goꞌ der nu nac ru ne̱, biñ nu ca lo cuen nu co mbañ mbecy, rishli rne̱e̱ lo der nu yu zeꞌ segur la gyad iy ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Cyu ziꞌl yu nu gyicy nu gnu yu nu na gal na tub yu nguzh nu ricy cup consuel lo̱, nap zir benu cyiigy dey tub gyitaꞌ ily nu rdugu yeñ yu. Gazeꞌ nu shet lag dey yu lo nisyudoo par nu gat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Benu tub yaar gyicy ñi nu gnur, nap zir pcyug ñi, gun nap zir nu gzur nu tuꞌnc yaar gazeꞌ nu gyar gabily nu rup laa yaar lo gyi nu rila wayu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lugaar zeꞌ wat byaꞌ nunu rila wayu gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nunu benu gyiꞌr gyicy ñi nu gnur, nap zir pcyug ñi, gun nap zir nu gzur nu tuꞌnc tub gyiꞌr, gazeꞌ nu gyet lag ru gabily nu rup laa gyiꞌr lo gyi nu rila wayu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lugaar zeꞌ wat byaꞌ nunu rila wayu gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nunu benu tub urlor gyicy ñi nu gnur, orzeꞌ cor ñii, gun nap zir nu chuꞌr zeꞌ nu riib ic Ñgyoozh nu tub zi urlor, gazeꞌ nu gyet lag ru gabily nu rup laa urlor. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lugaar zeꞌ nu wat byaꞌ nunu rila wayu gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Gun dela mbecy go gyi too dey gal nu ricy zed nu rgoñ too la coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tees benu zed ruu nu riꞌ niñ, orzeꞌ wacyiiñ ñi. Cueꞌ zaan der nu ruu nu riꞌ ni zed zeꞌ nañ lardoo der. Nunu nu gyel ri zu guꞌ der nu losaꞌr ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Orzeꞌ bruu Jesuuz Capernaum zam lo de yu nu la Judea nunu lo de yu nu ri tub laꞌ gaꞌ dzu gyoow Jordaang. Orzeꞌ tonaꞌ la mbecy zigy byatublaazh dey lom. Gazeꞌ nu blyuum ni dey tuubaꞌ tir laab gal nu nil ricy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Orzeꞌ bruꞌña la be de mbecy fariseo nu gyicy dey preb mi. Gazeꞌ nu na dey rab yum: ―¿A nap zuñ par lo leey ni Moisees nu zaan mbecy mñaay? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Orzeꞌ na Jesuuz rab mi dey: ―¿La coz mnii Moisees nu gyicy mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Orzeꞌ na dey: ―Moisees bzaan yu nu co mbecy gyicy ni rishbeey. Orzeꞌ cyuu nuy mi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Gazeꞌ nu na Jesuuz: ―Moisees ni pcaay leey zeꞌ nu nac nu zed lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tees nese nu bzub gyiꞌ gyishlombecy “Ñgyoozh psaꞌ lagy mi tub yu gyeey nu tub biñ mñaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ndeꞌ nu de yu gyeey zeeñ yu uz yu nunu zeeñ yu ñaay par nu gyatublaazh yu nu mñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Orzeꞌ lo rup laa dey gyac dey se tub ziꞌl mbecy”, rniiñ. Ndeꞌ nu walabaꞌ cyup dey nac yu, sinu se tub zi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nunu ndeꞌ nu ni tub la mbecy wac gyicy yu nu glaꞌ losaꞌ cyup mbecy, benu bi nac dey mbecy nu bicy tublaazh Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Despuees ornu ub zi lam rim nañ yuꞌ nu de yu nu rsyaꞌ lom, orzeꞌ mnii dey lom nu shaal mi riidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Gazeꞌ nu nam rab mi dey: ―Cyu ziꞌl la mbecy nu coy gyicy nu zaan yu mñaay, zeꞌ chelaay nu tuubaꞌ biñ mñaa, orzeꞌ yu zeꞌ ricy yu cyi nu wangyicy paay nu mñaa logay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nunu benu biñ mñaa com gyicy nu zaan mi ñgyeem nunu chelaam tuubaꞌ yu gyeey, mi zeꞌ ricy mi cyi nu wangyicy paam nu ñgyee logam ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Orzeꞌ la be mbecy bruꞌña nu dey de yu nguzh lo Jesuuz nu gal yaam dey. Orzeꞌ de yu nu rsyaꞌ lom rdzaꞌ dey ni de mbecy nu yad nu de yu nguzh zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tees ornu bzaac Jesuuz nu rdzaꞌ dey, orzeꞌ wangyuꞌ lagy mi. Gazeꞌ nu nam rab mi dey: ―Bzaan der gyechaꞌ de yu nguzh lo̱. Cueꞌ niir lo dey nu ruu chuy, gun lugaar zeꞌ nu riib ic Ñgyoozh, ndeꞌ lugaar nu yuꞌ mbecy nu na gal nu na de yu nguzh ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya̱ rishli rne̱e̱ lo der nu yu nu wazaan nu gyub ic Ñgyoozh gal nu ricy de yu nguzh ii, orzeꞌ wac chuꞌy zeꞌ nu riib ic mi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Gazeꞌ nu bduꞌ yaam de yu nguzh zeꞌ. Bri yaam yu. Bdiiñ mi lo Ñgyoozh niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lat nu rash nez Jesuuz zam, bruꞌña tub mbecy gusu tib yu lom. Orzeꞌ nay rab yum: ―Masht nap, ¿la ñuu coz rlagy ñi nu gyicya̱ par nu cui mbaña̱ tub la? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Orzeꞌ na Jesuuz rab mi yu: ―¿La gu rnii gaꞌ ru nu nap ya̱? Se cyuꞌ zir nu nap sinu tub zi la Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ru rad lagy ru de coz nu rcaa Ñgyoozh de mbecy nu gyicy yac dey. Cueꞌ cut ru losaꞌr. Cueꞌ gal ru mbecy nu wanchelaar. Cueꞌ gyicy ru gubaan. Cueꞌ riib ru gyidza too losaꞌr. Cueꞌ gyicy ru gan tiñ nu nac gyel rguu. Pca lagy lo uz ru nunu pca lagy lo ñaar ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Orzeꞌ mbecy zeꞌ nay rab yum: ―Tees masht, dela ndeꞌ bi bicy yaca̱ ñii nese miiñ la ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Gazeꞌ nu Jesuuz bgüiim loy nunu pcam yu. Orzeꞌ nam rab mi yu: ―Ru ricy falt tub coz nir. Yaa cut ru dela coz nu yuꞌ nir. Gazeꞌ nu tiñ zeꞌ cuic ru ni de mbecy zi. Orzeꞌ gyibaa gyad gyel nap nir. Nunu cyid ru cyid car icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tees ornu güeñ mbecy zeꞌ nu ni mnii Jesuuz, orzeꞌ byashni bgüiiy. Orzeꞌ gush nez yu yay, gun tonaꞌ la yuꞌ gyel nap niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Orzeꞌ Jesuuz bgüiim dub yub la lom. Gazeꞌ nu naꞌm rab mi de yu nu rsyaꞌ lom: ―¡Dzi ga biigy nu chuꞌ mbecy guaniꞌñ lat de mbecy nu riib ic Ñgyoozh! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ornu de yu nu rsyaꞌ lom güeñ dey nu ni mniim, za nu la ic dey. Gazeꞌ nu naꞌm rab mi dey: ―¡Tonaꞌ la biigy nu chuꞌ mbecy lat de mbecy nu riib ic Ñgyoozh! ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A̱ꞌ biigy zir ded tub camey gyeegy gyiꞌ tub gyishtiib gazeꞌ nu chuꞌ tub mbecy guaniꞌñ lat de mbecy nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Orzeꞌ dzi zir za nu ic de yu nu rsyaꞌ lom. Gazeꞌ nu na dey: ―Benu ni, ¿cyu gac gruu mbañ beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Orzeꞌ Jesuuz bgüiim lo dey. Gazeꞌ nu nam rab mi dey: ―Par de mbecy ndeꞌ coz nu rila wac, tees par Ñgyoozh walab ni, gun Ñgyoozh gac gyicy mi dela coz ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Orzeꞌ na Bed rab yum: ―Zeꞌ de̱ ya̱ bzeeñ de̱ dela coz nu yuꞌ ne̱ de̱ nu yap ca̱ de̱ ich ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Orzeꞌ na gaꞌ Jesuuz: ―Ya̱ rishli rne̱e̱ lo der nu dela de yu nu bzeeñ yuꞌ, yu nu bzeeñ bicy, yu nu bzeeñ zan, yu nu bzeeñ ñaa, yu nu bzeeñ uz, yu nu bzeeñ iꞌñ, yu nu bzeeñ yu ni nu nac ya̱ nunu nu nac de riidz nu sac nu bruu lo Ñgyoozh, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","orzeꞌ sac ni tub la dey zeꞌ nu wayicy yu gan mas tub gaaynal tir sheñ zir de coz zeꞌ gyishlombecy ii. Dey zeꞌ gyicy yu gan mas tub gaaynal tir sheñ zir de yuꞌy, bicy yu, zan yu, ñaay, iꞌñ yu, yu niy, nunu niꞌ gyicy yu gan nu gzac ziy. Nunu tiem nu yad par lo gad nu cui mbañ dey tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tees zigy de mbecy nu gya zir zu na, dey zeꞌ gyac yu mbecy nu gash zir zu par lo. Zeꞌ zigy mbecy nu gash zir zu na, de yu zeꞌ gac dey yu nu gya zir zu par lo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Orzeꞌ Jesuuz rcam zam par Jerusaleeng. Ub mi zub lom. Zeꞌ par ich mi zaab de yu nu rsyaꞌ lom. Za nu la ic dey nunu rdzib dey lat nu za cay ich mi. Orzeꞌ gua nu reñ mi de trocyup de yu nu bloo sum zeꞌ. Gazeꞌ nu brugyiꞌ rniim lo dey de coz nu gzac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Orzeꞌ nam: ―De ru rzac der nu na rcan zan par Jerusaleeng. Orzeꞌ zeꞌ guꞌ dey ya̱, biñ nu byac mbecy, yaa de uz zub lo, nu yaa de mbecy nu rlyuu leey nu bzeeñ Moisees. Nii dey nu rlagy ñi nu gata̱ nu yuꞌ falt ne̱. Gazeꞌ nu guꞌ dey ya̱ yaa de mbecy yad. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Orzeꞌ gubdzaa dey ya̱, nunu coo yeñ dey lo̱, nunu gaaz dey ya̱ nu cuart. Gazeꞌ nu cut dey ya̱. Tees dzi chon gyabaña̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Orzeꞌ bechaꞌ Waa nu Santiag, de iꞌñ Zebedeo lom. Gazeꞌ nu na dey rab yum: ―Masht, de̱ ya̱ rlagy de̱ nu gyicy ru ca na coz nu diñ de̱ lor ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Orzeꞌ na Jesuuz rab mi dey: ―¿La coz rlagy der gyicya̱ du̱ ru? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gazeꞌ nu na dey rab yum: ―Bicy ñuu nu zub de̱ cuit ru zeꞌ nu gzub ru nu gyel lily nir: tub de̱ par yaa beer, zeꞌ tuubaꞌ de̱ par yaa reg ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Orzeꞌ na Jesuuz rab mi dey: ―De ru wagad lagy der la coz rgyiiñ ru. ¿A gagye der gzuub ruꞌr taz nu gzub dey ru̱ꞌ? Nunu ¿a gagye der ded ru gyoow nu ya̱ deda̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Orzeꞌ na dey: ―Gagye̱ de̱ ―nay. Gazeꞌ nu nam rab mi dey: ―Rishli gaal zuub ruꞌ der taz nu ya̱ zuub ru̱ꞌ nunu ded der gyoow nu ya̱ deda̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tees par nu gzuub der par yaa be̱e̱ o par yaa rega̱, ndeꞌ walab cuen ne̱ ya̱ nu ni gyicya̱ du̱ der; sinu de lugaar zeꞌ, ndeꞌ par de yu nu pcui Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na ornu güeñ zaꞌ tii gaꞌ de yu nu rsyaꞌ lom zeꞌ, orzeꞌ bdzaꞌ dey ni Santiag nu ni Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Orzeꞌ Jesuuz bredz mi dey. Gazeꞌ nu nam: ―De ru rad lagy der nu de mbecy nu ricy gyel gubier ni reñaꞌ lugaar, dzi ricy dey gyel lily niy nu de mbecy shni. De mbecy zub lo zaab ricy lay mandaar dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tees lat de ru walab ni mod rlagy ñi. Zeꞌ benu ca na der rlagy ru gac ru yu lily, orzeꞌ rlagy ñi nu gyicy ru coz nu rlagy deꞌ zir losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nunu benu ca na tub yu nu ri lat der rlagy yu gac yu mbecy zub lo, orzeꞌ rlagy ñi gyicy yu de coz nu galagy ñi ni deꞌ zir losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gun ya̱, biñ nu byac mbecy, a̱ꞌ yapa̱ nu gyicy mbecy coz nu rlagya̱, sinu par nu gyicya̱ coz nu rlagy mbecy nunu par nu gata̱, gun grisha̱ nu gruu zigy mbecy lo cashtig ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Gazeꞌ nu bruꞌña dem tub gyedz nu la Jericó. Ornu bruum Jericó nu de yu nu rsyaꞌ lom nu de mbecy zigy, orzeꞌ gyernez zeꞌ zub tub lo caꞌ rgyiiñ yu gun. Bartimeo lay. Zeꞌ uz yu lay Timeo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ornu güeñ yu nu laab Jesuuz Nazaret rded mi, orzeꞌ brugyiꞌ rbish tiy. Orzeꞌ nay: ―¡Jesuuz nez Dabi, gushni ñuu lagy ya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Orzeꞌ zigy mbecy bdzaꞌ dey niy, nunu mnii dey nu cueꞌ cush tiy. Tees orzeꞌ rbish ti gaꞌ zir yu. Orzeꞌ nay: ―¡Jesuuz nez Dabi, gushni ñuu lagy ya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Gazeꞌ nu gusu Jesuuz. Orzeꞌ nam: ―Bredz der yu ―nam. Gazeꞌ nu bredz dey lo caꞌ zeꞌ. Orzeꞌ na dey rab yuy: ―Briic baloor. Wes su gun rbedz mi ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Orzeꞌ gush za laay shab yu par ich yu. Wes suy carer zay lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Orzeꞌ nam rab mi yu: ―¿La coz rlagy ru gyicya̱ du̱ ru? ―nam. Orzeꞌ na lo caꞌ zeꞌ rab yum: ―Masht, ya̱ rlagya̱ nu zac nap la̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Orzeꞌ na Jesuuz: ―Yaa la ru na gun ru bicy cup ru consuel lo̱. Ndeꞌ nu byac ru ―nam. Orzeꞌ laab or la zeꞌ byanap rzac yu nunu za cay ich Jesuuz par nez nu zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Orzeꞌ bruꞌña dey gyiꞌ bicy ni ya Oliva. Bicy zeꞌ, ndeꞌ gaab ga Betfagé nu Betania, cyup gyedz nu ri gaab ga Jerusaleeng. Orzeꞌ Jesuuz bzuu nez mi cyup de yu nu rsyaꞌ lom nu cha ga dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Gazeꞌ nu nam rab mi dey: ―Gua der gyedz nu ri gal dzu re. Laab chuꞌ la der lat gyedz zeꞌ, orzeꞌ gyap der tub bur feñ ca cuñ ma: bañ nu nigul gyub la mbecy. Orzeꞌ shaagy der ma, cyid nur ma par ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Benu ca na mbecy niiy lo der: “¿Lagu rshaagy der bur zeꞌ?” niiy, orzeꞌ nii der nu “Shuaan na cyiiñ ma nim. Gazeꞌ nu lueg la tush cya gaꞌm ma”, nii der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gazeꞌ nu gush nez dey zay. Byap dey bur feñ zeꞌ ca cuñ ma gyernez, roꞌ ni tub yuꞌ. Gazeꞌ nu pshaagy dey ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Orzeꞌ na de mbecy nu yuꞌ lugaar zeꞌ rab yu dey: ―¿Lagu rshaagy der bur zeꞌ? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Orzeꞌ mnii dey lo mbecy zeꞌ gal nu mnii Jesuuz. Gazeꞌ nu bzaan dey nu cha nu dey bur zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Orzeꞌ gua nu dey ma lo Jesuuz. Orzeꞌ briib dey shab yu ich bur feñ zeꞌ. Gazeꞌ nu gutib Jesuuz ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tonaꞌ la zigy mbecy pcuaay shab yu gyernez. Nunu yuꞌ gaꞌ dey pshiꞌñ yu yaa yag nu nash ngush pcuaay gyernez. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Orzeꞌ dela de mbecy nu zub lo lom nunu dela de mbecy nu zaab par ich mi brugyiꞌ rbishti dey. Orzeꞌ na dey: ―¡Dzi ga zily nac ru! ¡Ñgyoozh nac num ru biñ nu bzuu nez mi! ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ñgyoozh nap ricy num gyel gubier nu yad ni biñ nu bruu lat nez gyitoo bel nin Dabi! ¡Dzi ga zily nac biñ nu gya zir zu! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ornu guꞌ Jesuuz lat gyedz Jerusaleeng, orzeꞌ guꞌm loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh. Orzeꞌ briꞌ lom dutuub la loliꞌ zeꞌ. Orzeꞌ bruum zam par Betania nu de trocyup yu nu bi bloo sum zeꞌ, gun bi gudze. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tuubaꞌ dzi, ornu bruum Betania, orzeꞌ briib nu ran mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Orzeꞌ bzaac mi tub ya las zub ñi zet. Taꞌ lyag niñ. Gazeꞌ nu gua güiim ben a wad uugy niñ gom. Tees ornu bruꞌñam looñ se la la coz byap mi. Nomaas lyag ziꞌl taꞌ niñ, gun walab tiem nu rbic ñi uugy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Orzeꞌ nam rab mi ñii: ―¡Laab ru rila wowaꞌ mbecy uugy nir! ―nam. Nunu güeñ de yu nu rsyaꞌ lom nu ni mniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gazeꞌ nu brim Jerusaleeng. Orzeꞌ guꞌ gaꞌm loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh brugyiꞌ rboom de yu nu nguaa rut gal nu de yu nu rzii nañ yuꞌ zeꞌ. Nunu ptush cyam mez ni de yu nu rtich tiñ. Nunu ptush cya gaꞌm yashily ni de yu nu rut begy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nunu wansaanaꞌm nu chesa nu mbecy la coz loliꞌ ni yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Blyuum ni de mbecy. Orzeꞌ nam rab mi dey: ―Ñgyoozh nam lat riidz nim: “Yuꞌ ne̱ gruu lañ yuꞌ nu gnii nu de lo la mbecy ya̱”, nam. Zeꞌ de ru ricy der nu nañ gal nu na tub blyuu ni gubaan ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Orzeꞌ güeñ de uz zub lo nu de yu nu rlyuu leey ni Ñgyoozh. Orzeꞌ brugyiꞌ nu ryub dey tub mod nu cut dey mi, gun rdzib dey lom, gun dela de mbecy zigy za nu ic dey de coz nu rlyuum. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tees or becheñ, orzeꞌ bruu gaꞌ Jesuuz gal nu de yu nu rsyaꞌ lom Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na or bzaꞌ yu tuubaꞌ dzi bdedaꞌ dey lo ya las zeꞌ. Bzaac dey nu guwach ñi gashtal lyu lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Orzeꞌ byezaꞌ lagy Bed coz nu mnii Jesuuz. Gazeꞌ nu nay rab yum: ―Masht, ¡güii la! Guwach ya las nu bzaa lagy ru ni re ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Orzeꞌ nam rab mi dey: ―Bicy cup der consuel lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya̱ rishli rne̱e̱ lo der nu cyu ziꞌl mbecy nu nii lo bicy ii: “Bruu chu. Gua gyet lag ru lo nisyudoo”, niiy, nunu cueꞌ gyicy cyup ic yu sinu gyicy cup yu consuel nu gac coz nu niiy, orzeꞌ gac ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ndeꞌ nu ya̱ rne̱e̱ lo der nu la ziꞌl coz nu cyiñ der ornu rnii nu der Ñgyoozh, bicy cup der consuel nu gad ñi, gun orzeꞌ gad ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nunu lat nu zu der rnii nu der Ñgyoozh, bicy sulagy der ni losaꞌr benu rzi lagy ru loy, gun orzeꞌ niꞌ Ñgyoozh, uz der nu zub gyibaa, gyicy sulagy mi de coz a̱ꞌ nap nu ricy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tees benu de ru wayicy sulagy der ni losaꞌr, niꞌ Ñgyoozh uz der nu zub gyibaa wayicy sulagy mi de coz a̱ꞌ nap nu ricy der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gazeꞌ nu brii gaꞌm Jerusaleeng. Lat nu rded mi loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh, de uz zub lo gal nu de yu nu rlyuu leey ni Ñgyoozh nu de yu bel ni de mbecy Israeel bruꞌña dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Orzeꞌ na dey rab yum: ―¿La na rishbeey ricy cup ru nu ricy ru de coz ii? ¿Cyu briic rishbeey nu ni ricy ru? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Orzeꞌ na Jesuuz rab mi dey: ―Niꞌ ya̱ dugyiꞌ tub coz lo der. Benu tush cya der ñii, orzeꞌ niꞌ ya̱ ne̱e̱ lo der nu la na rishbeey ricy cupa̱ nu ricya̱ de coz ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Cyu bzuu nez Waa nu biid yu nu briib nis yu mbecy? ¿A Ñgyoozh bzuu nez mi yu uti mbecy? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Gazeꞌ nu brugyiꞌ ro dey riidz nu losaꞌy yuꞌy. Orzeꞌ na dey: ―Benu niin nu Ñgyoozh bzuu nez mi yu biid yu, orzeꞌ nii Jesuuz gab yu de ub na: “Zeꞌ ¿lagu wancheña lagy der de riidz nu mniiy, beni?”, gniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tees wac niin nu mbecy bzuu nez yuy biid yu ―na dey. Ni mnii dey, gun rdzib dey lo mbecy, gun dela mbecy bicy dey Waa par tub yu nu rishli rnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Orzeꞌ na dey rab yu Jesuuz: ―Wagad lagy de̱ ―na dey. Orzeꞌ na Jesuuz rab mi dey: ―Niꞌ ya̱ wane̱e̱ lo der la na rishbeey ricy cupa̱ nu ricya̱ de coz ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Orzeꞌ brugyiꞌ rnii Jesuuz lo de mbecy nu riidz tiily. Gazeꞌ nu nam rab mi dey: ―Tub mbecy mnuuz yu tub nac lyucy urbyay. Bduꞌy loꞌ dub yub la ruꞌñ. Orzeꞌ bzaay tub zo nu dushi̱i̱ de urbyay zeꞌ. Nunu bzaay tub zeꞌ nu gya bzuub yu tub yuꞌ nu bduñañ. Gazeꞌ nu bzeeñ yuñ yaa mbecy nu nuuz dey coz cyaal. Gazeꞌ nu gush nez yu zay tub lugaar zet. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na ornu byap tiem nu dulag urbyay zeꞌ na, orzeꞌ bzuu nez yu tub moz lo de yu nu mnuuz coz cyaal zeꞌ par nu cha gyiy ca na de coz nu bruu lo de lyucy zeꞌ nu bdugyiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tees de yu zeꞌ bduꞌ yaa dey moz zeꞌ bgaaz dey yu, nunu se la la briic dey niy yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Orzeꞌ yu nu guni lyucy urbyay zeꞌ bzeed yu tuubaꞌ moz, tees niꞌ ziꞌl yu zeꞌ tonaꞌ la shiñ bicy nu dey yu. Pcad güii dey tooy. Orzeꞌ gud güiiy bish cyay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Zeꞌ bzeedaꞌ yu nu guni lyucy urbyay zeꞌ tuubaꞌ moz. Orzeꞌ yu zeꞌ biit dey yu. Ga ub ni laa bzeed yu zigy moz, nunu dela dey shiñ bicy nu dey yu. Yuꞌy bgaaz dey yu. Yuꞌy biit dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Sacaꞌ zir mbecy nu rcyiiñ loy. Zeꞌ iꞌñ ziꞌl yu nu dzi rcay zu. Por fi̱i̱ gazeꞌ nu bzeed yu iꞌñ yu. Orzeꞌ mnii tooy: “Ca gaal lagy dey lo iꞌñ na”, mnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Na ornu bruꞌña iꞌñ yu zeꞌ nu nash lyucy urbyay zeꞌ, orzeꞌ na de yu nu mnuuz coz cyaal zeꞌ rab yu losaꞌy: “Yu re gyiyeeñ nuy de gyel nap ni uz yu. Yaa der chan dut nay, gun orzeꞌ gyiyeeñ gyel nap nin”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Orzeꞌ bduꞌ yaa dey yu zeꞌ. Biit yuy. Bloo dey yu lat lyucy urbyay zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Na ¿la coz gyicy yu nu guni lyucy urbyay zeꞌ nu de yu nu mnuuz coz cyaal zeꞌ? Chay cut yu dela yu nu mnuuz coz cyaal zeꞌ. Orzeꞌ zeeñ yu lyucy urbyay zeꞌ yaa reñaꞌ moz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Walab gaal gabee wacsyaꞌ der riidz ni Ñgyoozh zeꞌ nu rniiñ: Gyitaꞌ nu mneꞌ de biryu byac ñi gyitaꞌ nu ricy zir ñi presis. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nii tub coz nu ricy Ñgyoozh nunu tonaꞌ la cyit par de ub na, rniiñ, ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Orzeꞌ ngulagy dey nguꞌ yaay mi, gun psaꞌ lagy dey nu loy pcaam ornu mniim riidz tiily zeꞌ. Tees rdzib dey lo de mbecy zigy. Orzeꞌ bruu chu dey lom. Gush nez dey zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gazeꞌ nu bzuu nez dey la be mbecy fariseo nu la be mbecy ni Herodes par nu gyicy dey nu gadzam nu riidz gun orzeꞌ gad mod nu cuꞌ zi dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bruꞌña dey lom na. Gazeꞌ nu na dey rab yum: ―Masht, de̱ ya̱ rad lagya̱ nu rniir nu rishli. Nunu ru wagyicy cuen ru de coz nu rnii mbecy, gun a̱ꞌ nac ru mbecy nu rcui, sinu rniir mod nu rlagy Ñgyoozh nu chuꞌ den. Mnii lo de̱: ¿A gruu nap ñi nu riib na tiñ nu rbic dey ni César, yu nu riib ic de nasyoong, uti waruu nap ñi? ¿A rish na uti warish na? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tees Jesuuz gud lagy mi nu nac dey mbecy rzuu lo. Orzeꞌ nam rab mi dey: ―¿Lagu rzu der caa zeꞌ lo̱? Da nu der tub tiñ güi̱i̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gazeꞌ nu gua nu dey tub tiñ lom. Orzeꞌ nam rab mi dey: ―¿Cyu nab ca lo tiñ ii nunu cyu nu la ca looñ? ―nam. Orzeꞌ na dey: ―Lo César, yu nu riib ic de nasyoong, gal nu nu lay ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Gazeꞌ nu nam rab mi dey: ―Beni briic der ni César de coz nu nac niy, nunu briic der ni Ñgyoozh de coz nu nac nim ―nam. Orzeꞌ tonaꞌ la za nu ic dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Gazeꞌ nu bruꞌña tub nac mbecy saduceo lom, de yu nu rnii nu wagyabañ de mbecy gut. Orzeꞌ na dey rab yum: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Masht, Moisees pcaay par dela den nu benu tub mbecy gat bicy yu nunu zeeñ yu mñaay, zeꞌ sac iꞌñ mi, orzeꞌ yu zeꞌ rlagy ñi chelaay mñaa bicy yu par nu cuic yu iꞌñ mi nu gyac ni bicy yu nu bi gut zeꞌ. Orzeꞌ guul yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bzu gagy mbecy nuy bicy yu. Orzeꞌ yu loga la pchelaay. Orzeꞌ gut yu nunu wancuic yu iꞌñ mñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Orzeꞌ bicy cyup yu zeꞌ pchelaa gaꞌy mi. Zeꞌ gutaꞌy nunu niꞌ ziꞌl wancuic yu iꞌñ mi. Orzeꞌ niꞌ ziꞌl yu chon pchelaa gaꞌy nu biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Orzeꞌ niꞌ ziꞌl zaꞌ gagy laa dey pchelaay mi. Tees ni tub la dey wancuic yu iꞌñ mi. Por fi̱i̱ gutaꞌ la biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Or shuub dzi nu gyabañaꞌ de mbecy gut, ¿ca na dey zeꞌ gac mñaay biñ mñaa zeꞌ, gun zaꞌ gagy laa dey pchelaay mi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Orzeꞌ na Jesuuz rab mi dey: ―De ru radza der gun wagyet lag der cuen de coz nu rniiñ lat riidz ni Ñgyoozh. Ni wagad lagy der la na coz nu gac gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gun ornu gyabañ de mbecy nu bi gut, orzeꞌ wachelaa gaꞌ dey, sinu chuꞌ dey gal nu yuꞌ de anc nu yuꞌ gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Zeꞌ ni nu gyabañ mbecy, ¿walab gaal wacsyaꞌ der gyicy nu bzeeñ Moisees lac mod mnii nu Ñgyoozh yu ornu mniim lat tub yag nu rca gyi? Orzeꞌ nam rab mi yu: “Ya̱ naca̱ Ñgyoozh ni Abraham, naca̱ Ñgyoozh ni Isaac, nunu naca̱ Ñgyoozh ni Jacob”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Gun Ñgyoozh a̱ꞌ nac mi Ñgyoozh ni mbecy nu byaꞌ lo la, sinu nac mi Ñgyoozh ni mbecy nu mbañ, mas bi gut yu! Ndeꞌ nu de ru radza der ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Orzeꞌ bruꞌña tub mbecy nu rlyuu leey ni Ñgyoozh. Yu zeꞌ güeñ yu de riidz nu bee Jesuuz nu de mbecy saduceo nunu bduꞌ cuen yu nu nap mniim. Orzeꞌ nay rab yum: ―¿Ca na leey ni Ñgyoozh nac ñii leey zub lo zir? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Orzeꞌ na Jesuuz rab mi yu: ―Leey nu zub lo zir, ndeꞌ: “De mbecy Israeel nap bzuub gyidag der. Ñgyoozh, Shuaan na, tub zi lam nac mi Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Orzeꞌ pca der Shuaan ru, biñ nu nac Ñgyoozh nir nu dutuub la lardoor, nu dela gyel mbañ nir, nu dutuub la shcab nir, nu dela fers nir.” ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndeꞌ nu loga la. Zeꞌ leey cyup ndeꞌ: “Pca der losaꞌr gal nu rcar ub ru.” Sacaꞌ zir leey nu zily zir nac par cyup leey zeꞌ ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Orzeꞌ mbecy zeꞌ nay rab yum: ―Rishli, masht, dzi nap mniir nu zu tub zi Ñgyoozh. Sac cyuꞌ zir Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nunu nu caan Ñgyoozh nu dutuub la lardoon, nu dutuub la shcab nin, nu dela gyel mbañ nin, nu dela fers nin, nunu caan losaꞌn gal nu rcaan ub na. De ndeꞌ ricy zir ñi presis gazeꞌ de gun nu rzaay na lo Ñgyoozh gal nu dela deꞌ zir gun nu ricy na lom ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ornu güeñ Jesuuz nu dzi nap mniiy gal nu rnii mbecy nu nap rad lagy, orzeꞌ nam rab mi yu: ―Ru walabaꞌ nu dzi ricy falt par nu gyub ic Ñgyoozh ru ―nam. Orzeꞌ ni tubaꞌ la mbecy wangash lagy yu nu ngugyiꞌy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lat nu blyuu Jesuuz loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh, orzeꞌ nam rab mi dey: ―¿Lagu rnii de yu nu rlyuu leey ni Ñgyoozh nu Mesías, biñ nu ca lo cuen nu co mbañ mbecy, gruum lat nez Dabi? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Gun Espiriit Yon ni Ñgyoozh pcaam uub la Dabi nu niiy ornu nay: Ñgyoozh nam rab mi Shuaan na: “Gzub ru lugaar ni mbecy nu gya zir zu, par yaa be̱e̱ ii gashtal gyicy la̱ nu gyicy ru gan losaꞌ yuur”, nam, na Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Orzeꞌ ub la Dabi mniiy nu nac mi Shuaan yu. ¿Walab gaal gac gruu Mesías lat nez Dabi? ―na Jesuuz. Orzeꞌ dela de mbecy zigy yet lagy dey rzuub gyidag yu coz nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lat nu rlyuum ni dey, orzeꞌ nam: ―Cuidad der nu de mbecy nu rlyuu leey ni Ñgyoozh. Gun dey re yet lagy dey chesay nu shab duñ yu, nunu yet lagy dey nu rca lagy mbecy loy ornu rnii nu dey yu lat yagyiꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nunu gusht ni dey nu gzub yu lo yashily ni mbecy nu ricy ñi presis nañ yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh, nunu yet lagy dey lugaar ni mbecy lily lat saꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tees rboo dey yuꞌ byud gal nu gyel nap nim. Orzeꞌ par nu rsoow su dey lo de coz a̱ꞌ nap nu ricy nu dey byud zeꞌ, chi rnii nu dey Ñgyoozh. Ndeꞌ nu dey zeꞌ cashtig ily zir gad ni dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesuuz zub mi roꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh, gaab zeꞌ nu ca alcansi nu rguꞌ dey gun. Zub mi rgüiim lo de mbecy nu rguꞌ tiñ nañ alcansi zeꞌ. Orzeꞌ zigy de guaniꞌñ nu druꞌña zeꞌ sheñ tiñ rguꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Orzeꞌ bruꞌña tub byud nu dzi gyel zi zu. Pshet lag mi cyup sentab miꞌ nañ alcansi zeꞌ, tiñ nu dzi a̱ꞌ sac. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Orzeꞌ bredz Jesuuz de yu nu rsyaꞌ lom. Gazeꞌ nu nam rab mi dey: ―Rishli gaal coz ily zir bicy byud re gazeꞌ dela deꞌ zir mbecy nu rguꞌ tiñ nañ alcansi ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gun dela de guaniꞌñ, de coz nu brusub ziꞌl ni dey briic yu. Zeꞌ byud re gyel zi zum. Briic mi dela tiñ nim. Dela tiñ nu rcyiiñ nim briic mi ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lat nu druu Jesuuz loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh, orzeꞌ na tub yu nu rsyaꞌ lom rab yum: ―¡Masht, güii dzi ga coz ily de gyitaꞌ nu gup yuꞌ ii, nunu dzi ga coz ily de yuꞌ ii! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Orzeꞌ na Jesuuz rab mi yu: ―¿A rzac ru de yuꞌ ily ii? Tees ii sac ni tub gyitaꞌ nu gyeeñ ñi too losaꞌñ. Delañ dudily ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gazeꞌ nu bruum zam too bicy ni ya Oliva, tub laꞌ gaꞌ dzu ni yuꞌ nu driib zily mbecy Ñgyoozh. Na ornu gusub mi na, orzeꞌ Bed, nu Santiag, nu Waa, nu Ndrees, bdugyiꞌ reñ dey lom. Gazeꞌ nu na dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Mnii lo̱ de̱, ¿gul gac de coz nu mniir zeꞌ? Nunu ¿la na muesht gruu zac ornu gac dela coz zeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Orzeꞌ Jesuuz brugyiꞌ rniim lo dey. Gazeꞌ nu nam: ―Bzu der cuidad nis guu mbecy der, ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","gun tonaꞌ la zigy mbecy gruu zac yu nu gash yu nu la̱. “Ya̱ Mesías, biñ nu ca lo cuen nu co mbañ mbecy”, niiy. Orzeꞌ gyicy yu nu tonaꞌ la zigy mbecy gadza dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Na ornu gyeñ der nu bi yuꞌ gyel yuu gaab ga gal nu de zeꞌ nu zet, cueꞌ dzib der, gun ndeꞌ coz nu rlagy ñi nu gac. Tees gabee nigul shuub dzi nu gyaꞌ lo dela coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gun tub nac mbecy chuꞌy gyel yuu nu tub nacaꞌ mbecy. Nunu tub gubier chuꞌy gyel yuu nu tuubaꞌ gubier. Grib duru zañ lugaar. Cyid cubiñ. Tees dela de ndeꞌ nu gzub ziꞌl gyiꞌñ nu gzac zi de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Tees de ru bzu der cuidad nu ub ru, gun guꞌ dey der yaa de fushtiz. Nunu gaaz dey der nañ de yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Nunu cuꞌ cyi dey der lo de mbecy nu riib ic nu lo de rey nu nac ya̱, gun orzeꞌ lyuu der de coz rishli ne̱ lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nunu rlagy ñi nu gyal de riidz nu sac ne̱ lat de lo la nac mbecy anzir nu gyaꞌ lo dela coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tees ornu cha nu dey der guꞌ dey der yaa de fushtiz, cueꞌ sug ic der lac na riidz nu niir, sinu nii der de riidz nu rbic Espiriit Yon ni Ñgyoozh laab or la zeꞌ, gun riidz nu nii der, ndeꞌ walab riidz ni ub der, sinu riidz nu cuic Espiriit Yon ni Ñgyoozh, nii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nunu de mbecy cush cyay ich bicy yu gyicy yu nu gat yu. Zeꞌ de mbecy nu yuꞌ iꞌñ cush cyay ich iꞌñ yu. Nunu de yu feñ cush cya dey ich uz yu. Gyicy yu nu gat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nunu dela mbecy gazi lagy dey lo der nu nac ya̱. Tees yu nu gagye gashtal gat la, yu zeꞌ yu nu co mbañ Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Na Dañeel, yu nu mnii por cuen ni Ñgyoozh, bzeeñ yu riidz ni coz bag nu gyicy nu nit lo. Ornu zac der coz bag zeꞌ chuꞌñ zeꞌ nu walab seꞌñ, orzeꞌ de mbecy nu yuꞌ lo yu ni Judea rlagy ñi ruu chu dey chay par logyiꞌ. (Yu nu csyaꞌ de riidz ii rlagy ñi gyet lag yu cuen.) ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Orzeꞌ yu nu zub too yuꞌ, walagy ñi nu gyet yu chuꞌy nañ yuꞌ nu chagyiy coz nu cha nuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yu nu ricy riiñ lat naa, cueꞌ gaꞌ cush cyay cha gyiy shab yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Tees cuaa de biñ mñaa nu secyi zu! ¡Cuaa de biñ nu rgaagy mdoo tiem zeꞌ! ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bdiiñ der lo Ñgyoozh nu cueꞌ nu tiem rag shuub dzi nu ruu chu der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gun tiem zeꞌ zac zi zir mbecy gazeꞌ de tiem nu bded, gaal ziꞌl nu bzub gyiꞌ dela coz nu psaꞌ lagy Ñgyoozh. Nunu gzac zi zir dey tiem zeꞌ gazeꞌ deꞌ zir tiem nu yad par lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nunu benu Ñgyoozh wayicy shub mi tiem zeꞌ, ni tub la mbecy waruu mbañ yu. Tees gyicy shub mi tiem zeꞌ par nu nac de mbecy nim nu bi pcuim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Orzeꞌ benu ca na mbecy niiy lo der: “Güii ii zu Mesías, o güii re rim”, nii dey, cueꞌ cheña lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gun gruu zac mbecy rguu nu niiy nu nac yu Mesías nunu gruu zac mbecy rguu nu niiy nu nac yu mbecy nu rnii por cuen ni Ñgyoozh. Lyuu dey zañ muesht, nunu gyicy dey zañ nusuriidz nu cha nu ic mbecy par nu gad mod nu guu dey mbecy. Mas gashtal de mbecy nu bi pcui Ñgyoozh guu dey benu gac. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Tees de ru cuidad der! Gun tiem bi bzata̱ ñii lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Na ornu ded tiem nu zac zi de mbecy zeꞌ, orzeꞌ gyet cow lo doo nunu beey wabicaꞌ ma yaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","De bel nu taꞌ baa gyet lag ma, nunu de fers nu nash baa cueñ ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Orzeꞌ despuees ndeꞌ zac dey ya̱, biñ nu byac mbecy, yapa̱ lat za. Zac dey nu gac gyicya̱ coz ily nunu tonaꞌ la lily na̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gazeꞌ nu zuu neza̱ de anc ne̱ nu cha teꞌy de mbecy nu bi bducui nu yuꞌ gashtal se tap la scyiñ ni gyishlombecy: gash ñi nese zeꞌ nu blaazhaꞌ la nu zet ni gyishlombecy gashtal baa la. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Psyaꞌ der mod nu ricy ya las. Ornu bi rgaꞌñ nu driib lyag niñ, orzeꞌ bi neñ der nu bi yad tiem zig. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Niꞌ ziꞌl mod ornu zac der nu gac dela coz nu mne̱e̱ lo der, orzeꞌ bi neñ der nu ya̱, biñ nu byac mbecy, bi zu̱ la̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya̱ rishli rne̱e̱ lo der nu de mbecy nu yuꞌ tiem zeꞌ walazh dey gat yu gal gac dela coz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Baa nuñ gyishlombecy ii, delañ ded niñ, tees riidz nu ya̱ rne̱e̱, ndeꞌ rila waded niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Tees dzi zeꞌ, nu or zeꞌ, se cyu la rad lagy. Ni de anc nu yuꞌ gyibaa, ni ya̱, iꞌñ Ñgyoozh, wagad lagya̱, sinu tub zi la Ñgyoozh, uz den rad lagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Bicy cuidad der. Bzu der altant, gun wagad lagy der gul cyid tiem zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dela ndeꞌ nañ gal na tub mbecy nu bi zuu lay nu chay byaj. Anzir nu chay, bduꞌy riiñ yaa de moz niy, nunu tub ga la dey nu tub ga riiñ nu gyicy yu. Orzeꞌ pcaay yu nu rña gyeroꞌ nu zuy altant par ornu griy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ndeꞌ nu ni de ru bzu der altant, gun wagad lagy der gul yapa̱: ti or bi becheñ, ti or guzeel rel, ti or gabee caas ruꞌ zu, ti or zaꞌ yu. Wagad lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cuidad nis gac der gal na tub mbecy nu nas. Wansu lily yu ornu gri shuaan yu. Cuidad der nis ni na der ornu ya̱ yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nunu coz nu rne̱e̱ lo der, rne̱e̱ lo dela mbecy: nu zu der altant ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ornu ricy falt ruꞌ cyup dzi par nu chuꞌ saꞌ ni Pas, saꞌ nu row dey gyishtily nu sac lebadur, orzeꞌ de uz zub lo nu de yu nu rlyuu leey ni Ñgyoozh byub dey tub mod nu shet lag dey Jesuuz pres nu nac gyel rguu, gun orzeꞌ gyicy dey nu gat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Orzeꞌ na dey rab yu losaꞌy: ―Walagy ñi nu shet yaan yu lat saꞌ, gun nis gyach de mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lat nu rcyiiñ Jesuuz Betania nañ yuꞌ ni Simo̱o̱, yu nu gurat gyedz nu la lepra, lat nu zub mi lo mez, orzeꞌ bruꞌña tub biñ mñaa nu tub lamet nu byaa nu gyitaꞌ nu la alabastro. Dza laa nañ ñi yuꞌ asecy zguul. Du uub la asecy nu bruu nu tub lo gyish nu la nardo. Tonaꞌ la ñgyup sac ñi. Gazeꞌ nu pcyug mi yeñ lamet zeꞌ. Pcoom asecy zeꞌ too Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Orzeꞌ yuꞌ mbecy rdzaꞌ dey. Gazeꞌ nu na dey rab yu losaꞌy: ―¿Lagu leew la mnit lom asecy zguul re? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gun nde ñgyac nsaꞌy ñi ñgyup zir par chon gaaynal tiñ denario. Orzeꞌ tiñ zeꞌ mbic mi ni de mbecy zi ―na dey. Nunu rdzaꞌ dey ni biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tees Jesuuz nam rab mi dey: ―Zaan der. ¿Lagu ricy seed der mi? Mi ii tonaꞌ la nap bicy num ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gun mbecy zi dub laa tiem yuꞌy lat der. La ziꞌl tiem nu galagy der gac gyicy ru coz nap nur dey. Tees ya̱ walab dub laa tiem cyiiña̱ lat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mi ii ricy mi coz nu rac ricy mi. Driily ga lam asecy cuerp ne̱ gun orzeꞌ zu lily mi ñii anzir nu cach dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya̱ rishli rne̱e̱ lo der nu ca ziꞌl lugaar ni gyishlombecy nu shaal dey riidz nu sac nu bruu lo Ñgyoozh, nii gaꞌ dey coz nu bicy nu biñ mñaa ii ya̱ par nu gyezaꞌ lagy mbecy mi ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Orzeꞌ Judas Iscariote, tub yu nu bruu lat de trocyup yu nu bloo su Jesuuz, bruuy zeꞌ zay lo de uz zub lo par nu guꞌ dzey mi yaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na ornu güeñ de uz zub lo zeꞌ nu mnii Judas nu ni gyicy yu, orzeꞌ bet lagy dey. Gazeꞌ nu mnii dey nu segur la cyish yu niy. Orzeꞌ Judas byub yu mod nu guꞌ dzey mi yaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dzi loga la ni saꞌ nu row dey gyishtily nu sac lebadur, dzi nu rut dey shily ni saꞌ ni Pas, orzeꞌ na de yu nu rsyaꞌ lom rab yum: ―¿Ca rlagy ru nu cha̱ de̱ zu ye̱ coz nu gyicy na che saꞌ ni Pas? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Gazeꞌ nu bzuu nez mi cyup dey. Orzeꞌ nam rab mi yu: ―Yaa der lat gyedz. Re dzeel der tub mbecy nu ya nu tub reꞌ nis. Yu zeꞌ cha ca der ich yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Zeꞌ nu chuꞌy nañ yuꞌ, zeꞌ nii der lo shuaan yuꞌ zeꞌ: “Masht nam nu yap tugyi̱ꞌ lor ben ca na cuart zeꞌ nu gow mi gyit nu gyicy mi che ni saꞌ ni Pas nu de̱ ya̱, mbecy nu rsyaꞌ lom”, nii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Gazeꞌ nu yu zeꞌ lyuuy tub cuart ily nu zub gya. Bi nguaa dela coz nu cyiiñ nañ ñi nunu bi zu lily ñii. Zeꞌ zu ye der nu dow den comid ni saꞌ ni Pas ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Gazeꞌ nu bruu dey zeꞌ ya dey lat gyedz. Guc ñi gal nu mnii Jesuuz. Gazeꞌ nu zeꞌ bzu ye dey comid ni saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na ornu becheñ na, orzeꞌ brim nu de trocyup yu nu bloo sum zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lat nu zub nu Jesuuz dey lo mez row num dey comid zeꞌ, orzeꞌ nam: ―Ya̱ rishli rne̱e̱ lo der nu lo dela der gal nu nguaa der nu row nur ya̱ ii, rusu tub der nu cush cyar icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Orzeꞌ brugyiꞌ ricy shni de yu nu rsyaꞌ lom zeꞌ. Orzeꞌ tub ga la dey brugyiꞌ rgugyiꞌ dey lom. Orzeꞌ nay: ―¿Walab gaal ya̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Orzeꞌ nam rab mi dey: ―Lo trocyup der nu rneꞌr gyishtily nir nañ tub ziꞌl gyaꞌn nu ya̱, grusu tub der nu cush cyar icha̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gun ya̱, biñ nu byac mbecy, rishli gata̱ gal nu pcaa de yu nu mnii por cuen ni Ñgyoozh. ¡Tees cuaa yu nu cush cya ich ya̱, biñ nu byac mbecy! Nap zir benu cueꞌ ñgyal yu nu ni gyicy zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na lat nu gabee nguaa dey row yu gyit, orzeꞌ Jesuuz gush mi tub gyishtily. Orzeꞌ briic mi gras ni Ñgyoozh nu nac ñii. Gazeꞌ nu blew mi ñii briic mi ni dey. Orzeꞌ nam rab mi dey: ―Gush der nii, gun nii cuerp ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gazeꞌ nu gushaꞌm tub taz nu yuꞌ ñup urbyay. Orzeꞌ briicaꞌm gras ni Ñgyoozh. Gazeꞌ nu briicaꞌm ñi nu goꞌ dela dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Gazeꞌ nu nam rab mi dey: ―Nu nii reña̱ nu dushu par nu gruu mbañ zigy mbecy. Nii reña̱ nu bzu nap ñi trat nu bicy nu Ñgyoozh mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya̱ rishli rne̱e̱ lo der nu rila wado̱ꞌ ga̱ꞌ ñup ni urbyay gal do̱ꞌ la̱ ñup cub zeꞌ nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ornu blazh biil num dey tub salmo, gazeꞌ nu bruu num dey yuꞌ zeꞌ za num dey bicy ni ya Oliva. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Gazeꞌ nu nam rab mi dey: ―Dela der checa der nu gyicy cup ru consuel lo̱, gun ni rniiñ lat de riidz ni Ñgyoozh. Orzeꞌ nam: “Ya̱ duta̱ biñ nu rña shily. Orzeꞌ dela shily nim grush las ma”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tees despuees nu gyabaña̱, orzeꞌ ya̱ gya̱ ga̱ lo der par Galilea ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Orzeꞌ na Bed rab yum: ―Mas dela dey checa dey nu gyicy cup dey consuel lor, tees ya̱ rila wayeca̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Orzeꞌ na Jesuuz rab mi yu: ―Ya̱ rishli rne̱e̱ lor nu laab rel na, anzir nu cuedz ngüel ruꞌ cyup ma, ru chon tir niir nu a̱ꞌ yuꞌ lor ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tees Bed fert la zuy. Orzeꞌ nay: ―Mas gata̱ du̱ ru, tees ya̱ rila wane̱e̱ nu a̱ꞌ yuꞌ lo̱ ru ―nay. Orzeꞌ dela dey niꞌ ziꞌl mniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Orzeꞌ bruu num dey bicy ni ya Oliva za num dey tub lugaar nu la Getsemaní. Orzeꞌ nam rab mi dey: ―Bzub der ii lat nu ya̱ cha ne̱e̱ du̱ Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Gazeꞌ nu gua nu reñ mi Bed, nu Santiag, nu Waa. Orzeꞌ brugyiꞌ ricy shnim, nunu tonaꞌ la deet rac nañ lardoom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Gazeꞌ nu nam rab mi dey: ―Ya̱ rlagy la̱ gata̱ nu shni rac nañ lardo̱o̱. Blez der ii, nunu bzu der altant nu ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Gazeꞌ nu gua gaꞌm sñumiiñ par lo. Wes saa tiily mi lo yu. Orzeꞌ mnii num Ñgyoozh ben a wac gyicy mi nu cueꞌ shuub or nu zac zim zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Gazeꞌ nu nam rab mi Ñgyoozh: ―Uza̱, ru gac gyicy ru dela coz. Orzeꞌ bloo chu taz nu rlagy ñi zuub ru̱ꞌ. Tees cueꞌ gac ñii gal nu rlagya̱, sinu gal nu rlagy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na ornu bish cyam lo dey, nguaa nas dey. Orzeꞌ nam rab mi Bed: ―Simo̱o̱, ¿walab gaal nas ru? ¿Walab gaal ni tub or wangagyeer nzur altant? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bzu der altant nunu mnii nu der Ñgyoozh, gun orzeꞌ cueꞌ gyicy de coz cyi gan der. Gun nañ lardoo der rlagy der gyicy ru coz nap, tees cuerp ni der waccyiiñ ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Gazeꞌ nu guam tuubaꞌ tir mnii num Ñgyoozh gal nu mnii gaꞌ ziꞌl mi nu loga. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Orzeꞌ bish cya gaꞌm tuubaꞌ tir zam lo dey. Orzeꞌ niꞌ ziꞌl byap mi dey nguaa nas yu, gun rsuun la pcaal dey tantaꞌ nu yeed ñi. Orzeꞌ ni wangash lagy dey nu nii nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gazeꞌ nu guam tuubaꞌ tir mnii num Ñgyoozh. Ornu bish cya gaꞌm byaj chon, orzeꞌ nam rab mi dey: ―¿Walab gaal gabee nas ruꞌ der? ¿Walab gaal gabee zu lagy ruꞌ der? Bi bded ni nu gas der na. Na byap or nu ya̱, biñ nu byac mbecy guꞌ dey ya̱ yaa de mbecy cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wes su der yaa na, gun bi yad gaab yu nu cush cya icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lat nu gabee rnii ruꞌm lueg la bruꞌña Judas, tub yu nu bruu lat trocyup yu nu bi bloo sum zeꞌ. Bruꞌñay nu zigy mbecy, nu nuu mandzicy, nu yu nu nuu garot, nu. Yad dey par mandaar ni de yu zub lo ni de uz, nu par mandaar ni de yu nu rlyuu leey ni Ñgyoozh, nu par mandaar ni de yu bel ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zeꞌ Judas, yu nu bish cya ich mi, briic yu tub mod nu gad lagy dey cyu Jesuuz. Anzir bi mniiy: “Yu nu da̱w chit lo zeꞌ, yu zeꞌ ndeꞌ. Bduꞌ yaa der yu nunu nap ña der yu lat nu cha nu der yu”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na ornu bruꞌña Judas lo Jesuuz, orzeꞌ bechaꞌy lom. Orzeꞌ nay rab yum: ―¡Masht! ―nay. Orzeꞌ bdow yu chit lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Orzeꞌ bduꞌ la yaa dey mi nu cha nu dey mi pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tees tub yu nu zu lat zeꞌ bloo zay mandzicy niy nañ gyid yuꞌñ. Orzeꞌ pcyug yu gyidag tub moz ni yu nu riib ic de uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Zeꞌ Jesuuz nam rab mi de mbecy: ―¿Lagu yad tub der ya̱ gal nu rza tub dey tub gubaan: nu mandzicy nu garot? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gun de dzi la bri̱ blyu̱u̱ ni der loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh, nunu wancuꞌ yaa der ya̱ nu ñgya nu der ya̱ pres. Tees ni raac ñi par nu gyuꞌ niñ gal nu bi pca lat riidz ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Orzeꞌ dela de yu nu rsyaꞌ lom bzeeñ dey mi, bruu chu dey lom zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tees tub yu feñ gua cay ich mi. Tub laꞌ li la negy mbish yu. Orzeꞌ bduꞌ yaa gaꞌ dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tees yu zeꞌ bruu za laay nañ negy zeꞌ gush yu carer zay gyid yaagy lay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gazeꞌ nu gua nu dey Jesuuz lo yu nu riib ic de uz. Zeꞌ byatublaazh dela de uz zub lo, nu de yu bel ni de mbecy Israeel, nu de yu nu rlyuu leey ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Zeꞌ Bed gua cay ich Jesuuz. Orzeꞌ zet zet ziꞌl zaab yu ich mi gashtal bri lay loliꞌ ni uz nu riib ic zeꞌ. Gal nañ zeꞌ guay zub nuy de yu nu rña zeꞌ bidz nuy dey gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","De uz zub lo, nu de yu nu zu riiñ lo junt zub lo byub dey mod nu riib dey cyi too Jesuuz, gun orzeꞌ gad mod nu cut dey mi, tees rila wangad ni tub la mod ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gun zañ mbecy briib dey gyidza toom. Tees walab tub ziꞌl na riidz nu mnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Orzeꞌ yuꞌ mbecy wes suy briib yu gyidza toom. Orzeꞌ nay: ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―De̱ ya̱ güeñ de̱ nu nay: “Ya̱ tilya̱ yuꞌ nu driib zily mbecy Ñgyoozh, yuꞌ nu byaa nu yaa mbecy. Orzeꞌ nañ chon dzi shes su̱ tuubaꞌ yuꞌ nu gya nu walab nu yaa mbecy”, nay ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tees mas ni par walab tub ziꞌl na riidz nu rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Orzeꞌ yu nu riib ic de uz wes suy lat de mbecy. Gazeꞌ nu nay rab yu Jesuuz: ―¿A waniir lagu sac falt nir? ¿La ñuu cyi driib dey ic ru? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tees Jesuuz ri ziꞌl zum. Rila wanii lam. Zeꞌ bdugyiꞌ gaꞌ yu riib ic zeꞌ lom. Orzeꞌ naꞌy rab yum: ―¿A ru nac ru Mesías, iꞌñ Ñgyoozh Yon? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Orzeꞌ na Jesuuz rab mi yu: ―Laab ya̱ ndeꞌ. Nunu ru zac ru ya̱, biñ nu byac mbecy, zuba̱ yaa bee Ñgyoozh, biñ nu rac ricy de lo la coz ily. Nunu gzac der ya̱ yapa̱ lat za ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Orzeꞌ yu nu riib ic de uz zeꞌ pshaa lay shab yu par nu gabe nu walab seꞌñ mniim. Gazeꞌ nu nay: ―¿Laꞌ zir be teshtig rlagy ñi par yu ii? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","De ru güeñ ru nu rzat ziy Ñgyoozh. ¿La ñuu rnii too der? ―nay. Orzeꞌ dela dey mniiy nu rlagy ñi gat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Orzeꞌ yuꞌ mbecy brugyiꞌ rcoo yeñ yu lom. Nunu yuꞌ dey psoow yu lom. Gazeꞌ nu bdi dey mi. Orzeꞌ nay rab yum: ―¡Briic raso̱o̱! ¿Cyu bdi ru? ―rnii dey. Nunu de yu nu rña yuꞌ ni Ñgyoozh briich yaa dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Zeꞌ Bed byeeñ yu loliꞌ par gyiꞌ. Orzeꞌ bruꞌña tub criad ni yu riib ic de uz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ornu bzaac ñi Bed zuy rbidz yu gyi, bgüiiñ loy. Gazeꞌ nu nañ rab ñiy: ―Niꞌ ru rded nur Jesuuz Nazaret, ¿shiñ? ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tees Bed mniiy nu walab. Orzeꞌ nay: ―A̱ꞌ yuꞌ lo̱ ya̱ yu zeꞌ. Ni wagad lagya̱ la coz rniir ―nay. Gazeꞌ nu bruuy loliꞌ guay par gyeroꞌ. Orzeꞌ bredz la ngüel. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Zeꞌ criad zeꞌ bgüiiñ loy tuubaꞌ tir. Gazeꞌ nu brugyiꞌ rniiñ lo de mbecy nu yuꞌ zeꞌ. Orzeꞌ nañ: ―Mi re tub biñ nu bruu lat de mbecy zeꞌ ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tees Bed mnii gaꞌy nu walab. Na or guchi gaꞌ sñuu ndeꞌ, zeꞌ, orzeꞌ de yu nu nguaa zeꞌ nay rab yuy: ―Wanted la nu ru bruur lat de mbecy zeꞌ, gun ru nac ru mbecy Galilea ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Orzeꞌ Bed mniiy nu Ñgyoozh shiñ gyicy num yu benu walab rishli rniiy. Orzeꞌ nay: ―¡Ñgyoozh rad lagy mi nu ya̱ a̱ꞌ yuꞌ lo̱ cyu mbecy nu rnii der zeꞌ! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nunu lueg la bredzaꞌ la ngüel ruꞌ cyup ma. Orzeꞌ byezaꞌ la lagy Bed de riidz nu mnii Jesuuz ornu nam: “Anzir cuedz ngüel ruꞌ cyup ma, ru niir nu a̱ꞌ yuꞌ lor ya̱ chon tir”, nam. Byezaꞌ lagy yu ndeꞌ, orzeꞌ brugyiꞌ ruun yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Laab bzaꞌ yu la tuubaꞌ dzi, de uz zub lo, gal nu de yu bel ni de mbecy Israeel, nu de yu nu rlyuu leey ni Ñgyoozh, nu dela de mbecy nu zu riiñ ni junt zub lo byatublaazh dey beey riidz nu la gyicy nu dey Jesuuz. Gazeꞌ nu pcyiig dey mi za nuy mi. Bguꞌ dey mi yaa Poncio Pilato. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Orzeꞌ na Pilato rab yum: ―¿A ru nac ru rey ni de mbecy Israeel? ―nay. Orzeꞌ na Jesuuz rab mi yu: ―Laab ni gal nu ru mniir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Orzeꞌ de uz zub lo zeꞌ briib dey zañ cyi toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gazeꞌ nu na gaꞌ Pilato rab yum: ―¿A wagniir? Güii ñuu la zañ cyi driib dey toor ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tees Jesuuz rila wanniim. Orzeꞌ za nu la ic Pilato zuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na de ñaꞌn la lat nu rzuꞌ saꞌ ni Pas, orzeꞌ Pilato rlaay tub ga pres, ca ziꞌl na yu nu gnii mbecy nu dulaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Zeꞌ yuꞌ la be mbecy nañ yuꞌ gyiib nu rboo lo lo gubier. De yu zeꞌ biit dey mbecy lat nu guꞌ dey gyel yuu nu bish cyay ich gubier. Lat de mbecy zeꞌ ri tub mbecy nu la Barrabás. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Orzeꞌ bruꞌña dela de mbecy zigy, nunu mnii dey lo Pilato nu gyicy yu gal nu ricy ziꞌl yu lat saꞌ zeꞌ de ñaꞌn la. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Orzeꞌ na Pilato rab yu dey: ―¿A rlagy der la̱a̱ yu nu nac rey ni de mbecy Israeel? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gun Pilato gud lagy yu nu de uz zub lo bguꞌ dey Jesuuz yaay nu nac gyel saap lagy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tees de uz zub lo zeꞌ bduꞌ dey lagy de mbecy zigy gun orzeꞌ laa dey Barrabás lugaar nu laa dey Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Orzeꞌ Pilato nay rab yu dey: ―Beni, ¿la coz rlagy der gyicy du̱ yu nu rnii der rey ni de mbecy Israeel? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Orzeꞌ dub ruꞌ la dey rbish tiy: ―¡Cut ruy lo cruuz! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Gazeꞌ nu na Pilato rab yu dey: ―¿La ñuu coz a̱ꞌ nap bicy yu? ―nay. Tees dzi zir rbish ti dey. Orzeꞌ na dey: ―¡Cut ruy lo cruuz! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gazeꞌ nu blaa Pilato Barrabás, gun rlagy yu ganap lagy de mbecy zigy loy. Orzeꞌ despuees bicy yu mandaar nu gaaz dey Jesuuz. Gazeꞌ nu bguꞌy mi yaa de soldad nu caa dey mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Orzeꞌ de soldad gua nu dey mi loliꞌ ni yuꞌ zeꞌ nu riib ic gubier. (Ndeꞌ tub yuꞌ nu la pretorio.) Orzeꞌ zeꞌ bicy tublaazh dey dela de soldad. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Orzeꞌ bzuu dey mi tub negy bizat. Gazeꞌ nu bel dey ya gyech bzaa dey tub coron nu bri dey toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gazeꞌ nu brugyiꞌ ricy dey nu rnii nuy mi ñgyoozh: ―¡Shnur, rey ni de mbecy Israeel! ―rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nunu rshet dey toom nu tub yagyi, nunu rcoo yeñ dey lom, nunu rzu tib dey lom ricy dey nu dzi rca lagy dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Orzeꞌ despuees nu bguu bdzaa dey mi, bloo dey negy bizat nu zu yeñ mi zeꞌ. Orzeꞌ bzuu dey mi laab shab mi. Gazeꞌ nu bruu nu dey mi lugaar zeꞌ, za nu dey mi par nu caay mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nez za dey bdzeel yu tub mbecy Cirene nu la Simo̱o̱. Yu zeꞌ uz Alejandro nu Rufo. Bruuy ngush yeed yu. Ornu bdzeel yu de soldad, orzeꞌ por fers la pcaa dey yu nu cha nuy cruuz ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gazeꞌ nu za nu dey mi tub lugaar nu la Gólgota. Ndeꞌ tub riidz nu yaruuñ: Lugaar ni cyug too añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gazeꞌ nu briic dey ñup urbay nu yuꞌ can nu tub lo asecy nu la mirra goꞌm. Tees wangoꞌm ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Gazeꞌ nu pcaa dey mi lo cruuz. Orzeꞌ de soldad bloo dey cuen ben ca na dey dugyiy tub ga shab mi. Ni mod bleez dey shab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tub gyiib gaa or napor pcaa dey mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lo gyicy cyim pcaa dey: “Rey ni de mbecy Israeel”, pcaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pcaa dey mi lo cruuz nu cyup gubaan, tub yu par yaa beem, zeꞌ tuubaꞌy par yaa reg mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Orzeꞌ byuꞌ niñ gal nu pcaañ lat de riidz ni Ñgyoozh zeꞌ nu rniiñ: “Bicy dey mi par mbecy a̱ꞌ nap”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Orzeꞌ de mbecy nu rded zeꞌ rguu bdzaa dey mi. Rgyib la ic dey nu gyel rguu bdzaa. Orzeꞌ na dey: ―¡Ja̱j! Ru mniir nu nit lor yuꞌ nu driib zily mbecy Ñgyoozh nunu nañ chon dzi shes sur ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na bloo mbañ ub ru na. Bet lo cruuz ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Niꞌ de yu zub lo ni uz nu de yu nu rlyuu leey ni Ñgyoozh rguu bdzaa dey mi. Rnii zi dey nim nu losaꞌy. Orzeꞌ na dey: ―Bloo mbañ yu reñaꞌ mbecy. Tees ub yu wagac co mbañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Rlagy ñi nu gyet Mesías, biñ nu nac rey ni de mbecy Israeel, lo cruuz, gun orzeꞌ gzac na nunu cheña lagy na nu laab mi ―na dey. Orzeꞌ niꞌ ziꞌl de yu nu ca num lo cruuz rguu bdzaa dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Orzeꞌ tub gyiib trocyup or widoo, bet cow dutuub la lo yu gal tub gyiib chon or gudze. Gazeꞌ nu bzu yaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gazeꞌ nu laab or zeꞌ ye brish ti Jesuuz. Orzeꞌ nam: ―Eloi, Eloi, ¿lema sabactani? ―nam. Riidz zeꞌ yaruuñ: Ñgyoozh ne̱, Ñgyoozh ne̱, ¿lagu bzaan ru ya̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Orzeꞌ la be de mbecy nu yuꞌ zeꞌ, ornu güeñ dey nu brish tim, orzeꞌ na dey: ―Güii, yu re rbedz yu Elías, yu nu mnii por cuen ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Orzeꞌ tub mbecy gush yu carer, psal yu tub coz nu chayoꞌ nis lo ñup zii ni urbyay. Gazeꞌ nu bzuub yuñ lo tub yagyi. Briic yuñ goꞌm. Orzeꞌ nay rab yu losaꞌy: ―Blez güiin ben a cyid Elías shet yuy lo cruuz ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tees Jesuuz brish tim stub nu ye. Orzeꞌ gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gazeꞌ nu negy nu zaab gyeroꞌ ni lugaar yon nañ yuꞌ nu driib zily mbecy Ñgyoozh pshaa la lañ gaal ziꞌl nu gush ñi gal ic lañ gal lo yu la. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Orzeꞌ yu nu riib ic de soldad, yu nu zu par lo Jesuuz, ornu bzaac yu nu lac gut mi, orzeꞌ nay: ―Rishli gaal biñ ii guc mi iꞌñ Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Niꞌ yuꞌ gaꞌ la be biñ mñaa. Zet rgüii dem lo Jesuuz. Lat zeꞌ ri Li, biñ nu bruu Magadán, nu Li ñaa Santiag miꞌ nu See, nu Salomé. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","De mi zeꞌ gua ca dem ich Jesuuz, nunu bzu bich dem nu nac mi lat nu gusam Galilea. De mi zeꞌ nu zigy zir biñ mñaa bruu num mi Galilea bri nu dem mi gal Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na dzi zeꞌ, ndeꞌ dzi nu zu lily mbecy par saꞌ ni Pas. Ndeꞌ dzi birs anzir sab dzi nu zu lagy mbecy. Orzeꞌ or gudze ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","bruꞌña See lo Pilato. Yad nu See yu nu guledz Arimatea. Nac yu tub mbecy lily nu zu riiñ lat junt zub lo. Nunu nac yu tub yu nu rcyish lo lo gyel gubier ni Ñgyoozh. Orzeꞌ See guay lo Pilato bdiiñ yu cuerp ni Jesuuz loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato za nu ic yu nu güeñ yu nu bi gut Jesuuz. Orzeꞌ bredz yu yu nu riib ic de soldad zeꞌ. Orzeꞌ bdugyiꞌy loy ben a bi gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Orzeꞌ ornu mnii yu nu riib ic zeꞌ nu bi gut mi, orzeꞌ briic Pilato rishbeey nu cha nu See cuerp nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Orzeꞌ See wiiy tub sab fin. Gazeꞌ nu pshet yu cuerp ni Jesuuz lo cruuz. Gazeꞌ nu ptiish yu sab zeꞌ cuerp nim. Gazeꞌ nu briy mi gyerbaa nu bduguuñ nañ gyitaꞌ. Gazeꞌ nu psoow yu ruꞌ baa zeꞌ nu tub gyitaꞌ ily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Li, biñ nu bruu Magadán, nu Li ñaa See bzaac dem zeꞌ nu briy cuerp ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na ornu bded sab, dzi nu rzu lagy mbecy, orzeꞌ Li biñ nu bruu Magadán, nu Li ñaa Santiag, nu Salomé wii dem coz zguul nu cha coo dem cuerp ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Orzeꞌ noming napor, briib ziꞌl doo za dem ruꞌ baa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Orzeꞌ lat nu za dem, ro dem riidz nu losaꞌm. Orzeꞌ na dem: ―¿Cyu ctuyub gyitaꞌ nu noow ruꞌ baa par nu chuꞌn? ―na dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tees ornu bruꞌña dem ruꞌ baa zeꞌ, bzaac dem nu bi bruu yub gyitaꞌ nu noow ruꞌñ zeꞌ. Zeꞌ ndeꞌ tonaꞌ la gyitaꞌ ily. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ornu guꞌ dem nañ gyerbaa zeꞌ, orzeꞌ bzaac dem tub yu feñ zub yu par yaa bee. Zuy tub negy cacy duñ. Orzeꞌ tonaꞌ la gudzib dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Orzeꞌ yu feñ zeꞌ nay rab yu dem: ―Cueꞌ dzib der. De ru ryub der Jesuuz biñ nu bruu Nazaret, biñ nu biit dey lo cruuz. Na bi byabañ mi. Sacaꞌm ii. Bgüii der zeꞌ nu bri dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tees gua der gua niir lo de yu nu rsyaꞌ lom nu lo Bed nu bi ya gam lo dey par Galilea. Re zac der mi gal nu mniim ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Orzeꞌ de mi zeꞌ gush dem carer bruu dem ruꞌ baa zeꞌ yam. Nunu gush la bis nim nu gudzib mi. Ni wannii la dem lo ni tub la mbecy gun gudzib dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na ornu byabañ Jesuuz noming napor la, nu loga la bruu zac mi lo Li, biñ nu bruu Magadán, biñ nu bloo chum gagy nuras lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Orzeꞌ mi zeꞌ gush nez mi za toom riidz lo deꞌ zir de yu nu gusa nu Jesuuz. Zam lo dey lat nu yuꞌ dey ruun dey nunu ricy shniy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tees ornu güeñ dey nu mnii Li nu byabañ Jesuuz nunu bzaac mim, orzeꞌ wancheña lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Despuees ndeꞌ, orzeꞌ bruu sacaꞌm lo cyup dey lat nu za dey ngush. Reñaꞌ nam byac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Orzeꞌ bish cya dey gua nii dey lo deꞌ zir de losaꞌy. Tees niꞌ de yu zeꞌ wancheña lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Despuees ndeꞌ, orzeꞌ bruu zac mi lo de trotub yu nu bloo sum zeꞌ lat nu nguaa dey lo mez row yu gyit. Orzeꞌ pshuu num dey nu nac nu wancheña lagy dey nunu bicy cyigy lardoo dey, gun wacheña lagy dey ni de yu nu bzaac nu bi byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Orzeꞌ nam rab mi dey: ―Gua der dutuub la gyishlombecy. Mnii der riidz nu sac nu bruu lo Ñgyoozh lo dela mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yu nu gyicy cup consuel lo de riidz nu sac zeꞌ nunu gzu nis yu, yu zeꞌ gruu mbañ yu. Zeꞌ yu nu wagyicy cup consuel, yu zeꞌ waruu nap yu ornu ri beem niy nu nac cyiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nunu de yu nu ricy cup consuel gac gyicy dey zañ coz par nu gabe nu laab coz ni Ñgyoozh rnii dey. Nu nac ya̱ co chu dey nuras. Gnii dey riidz reñaꞌ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Benu gan dey bily se la la gzac yu. Nunu mas goꞌ dey benen se la la gyicy nuñ dey. Ornu griib yaa dey mbecy rat, orzeꞌ gyac dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Orzeꞌ Shuaan na Jesuuz despuees nu mnii num dey, orzeꞌ pshup Ñgyoozh mi gyibaa. Orzeꞌ gusub mi par yaa beem. ");
INSERT INTO zpzNTpp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Orzeꞌ de yu zeꞌ bruu dey gusay, pshaal dey de riidz nu sac nu bruu lo Ñgyoozh dela lugaar. Nunu Shuaan na blocyuub mi dey, nunu bicy fert mi de riidz nu rnii dey nu nac de nusuriidz ily nu ricy dey. Ni gac ñii.");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Zigy mbecy gush dey riiñ nu caay de coz nu guc lat den ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","dub gal nu na de riidz nu bzeeñ de yu nu bzac urlo la de coz zeꞌ nese nu bzub la gyiꞌñ, de riidz nu bzeeñ de yu nu bzu riiñ nu tush las yu de riidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ndeꞌ nu ru, shi Tioj, como ya̱ nap bdugyi̱ꞌ nu nac dela coz zeꞌ, orzeꞌ ya̱ rze̱e̱ nu nap benu ca̱a̱ dela coz zeꞌ lo gyicy, tub ga la riidz nu lugaar niñ. Orzeꞌ zeeda̱ ñii nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gun orzeꞌ gad lagy ru nu rishli dela coz nu bdulyuu nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Orzeꞌ tiem nu guc Herodes rey ni de gyedz nu yuꞌ lo yu ni Judea, bzu tub uz nu la Zacarí. Orzeꞌ yu zeꞌ byeeñ yu lo tub nac uz nu rnii dey uz ni Abías. Zeꞌ mñaay lam Bee. Gazaꞌ mi zeꞌ nac mi nez Aroong. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Orzeꞌ rup laa dey bicy dey coz nu seꞌñ par lo Ñgyoozh. Bicy dey dela coz nu mniim lo leey nim. Orzeꞌ ni tub la mbecy wangac nii dey nu yuꞌ falt niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tees sac iꞌñ dey, gun Bee wangac chuꞌ iꞌñ mi. Nunu rup laa dey bi gubel yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Orzeꞌ tub tiem de uz nu nac nu Zacarí briic dey sman niy. Orzeꞌ gazaꞌ Zacarí bzuy riiñ lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Orzeꞌ de uz blooy cuen ich cushtom ni dey, nunu laabaꞌ Zacarí bdugyiy nu chuꞌy nañ yuꞌ nu driib zily mbecy Ñgyoozh, Shuaan na, par nu zu dzeeñ yaal yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na lat nu rzu dzeeñ yaal yu, orzeꞌ dela mbecy nu rca Ñgyoozh lugaar zeꞌ byatublaazh dey ich yuꞌ zeꞌ nu nii nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Orzeꞌ lat zeꞌ bruu zac tub anc ni Ñgyoozh lo Zacarí gusuy par bee mez zeꞌ nu zub psiꞌñ yaal. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Orzeꞌ ornu bzaac Zacarí anc zeꞌ, orzeꞌ lorgut lay. Orzeꞌ tonaꞌ la gudzib yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tees anc zeꞌ nay rab yu Zacarí: ―Cueꞌ dzib ru Zacarí, gun Ñgyoozh “O” mniim gush mi de riidz nu mniir lom, nunu mñaar, Bee, gaal mi tub mdoo. Zeꞌ mdoo zeꞌ co lar yu Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Orzeꞌ tonaꞌ la chesu cyit lagy ru nu nac yu, nunu zigy mbecy gyet lagy yu nu nac nu gal mdoo zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gun yu zeꞌ gac yu tub yu lily par lo Ñgyoozh. Orzeꞌ rila woꞌy ñup ni urbyay. Ni woꞌy mashcaly. Ni woꞌy ni tub la loñ. Nunu Espiriit Yon ni Ñgyoozh bi riib ic zaꞌ lam nañ lardooy nese anzir nu gal yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Orzeꞌ yu zeꞌ gyicy yu nu zigy mbecy Israeel ca dey Ñgyoozh, Shuaan dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Orzeꞌ yu zeꞌ chay riiñ ni Ñgyoozh anzir nu cyid Shuaan na. Fert gyicy yu riiñ nim gal nu bicy Elías, yu nu mnii por cuen nim. Gun orzeꞌ gyicy yu nu gyanap riidz ni de mbecy nuy iꞌñ yu, nunu gyicy yu nu syaꞌ de mbecy nu rnid ruꞌ lo de mbecy nap. Orzeꞌ ni mod gac par nu zu lily yu de mbecy par ornu cyid Shuaan na ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Orzeꞌ na Zacarí rab yu anc zeꞌ: ―¿Lac mod gad lagya̱ nu gac ñii gal nu mniir? Gun ya̱ dzi byabela̱. Nunu niꞌ ziꞌl mña̱a̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Orzeꞌ na gaꞌ anc zeꞌ: ―Ya̱ naca̱ Gabrieel. Ya̱ zu̱ lo Ñgyoozh. Nunu mi zeꞌ bzuu nez mi ya̱ nu yap ne̱e̱ du̱ ru nunu rica̱ nu gad lagy ru de riidz nap nu mne̱e̱ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Orzeꞌ na, como wancheña lagy ru de riidz nu mne̱e̱ lor, de riidz nu segur la gac, orzeꞌ ndeꞌ nu gyac ru mbecy gop. Wac niir gashtal shuub la dzi nu gyuꞌ ni de riidz nu mne̱e̱ ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lat zeꞌ yuꞌ de mbecy rbez yu Zacarí ich yuꞌ. Gush dey shcab ben lagu dzi blaay nañ yuꞌ ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na ornu bruuy nañ yuꞌ zeꞌ, wangacaꞌ niiy. Orzeꞌ gud lagy dey nu bdeꞌ loy nañ yuꞌ zeꞌ, gun bicy yaay lo dey. Nunu ni la mod nay byeeñ yu. Wangacaꞌ niiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na ornu pshuub dzi niy bruuy sman, orzeꞌ yay yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Orzeꞌ despuees ni de nu ndeꞌ, orzeꞌ guꞌ iꞌñ mñaay Bee. Orzeꞌ nañ gaay beey wancyuu lam yuꞌm. Orzeꞌ mnii toom: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ni bicy nu Ñgyoozh ya̱, gun orzeꞌ na cueꞌ güii naañ mbecy lo̱ par nu sac iꞌña̱”, mnii toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na ornu bi bzaꞌ shuup beey nu yuꞌ iꞌñ Bee, orzeꞌ Ñgyoozh bzeed mi Gabrieel, yu nu nac anc nim, zay Nazaret, tub gyedz nu ri lo yu ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Zay lo tub fiñ feñ nu nigul dzeel yu gyeey. Fiñ zeꞌ lañ Li. Fiñ zeꞌ bi guc nap niñ nu chelaañ See, tub mbecy nu bruu lat nez rey Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Orzeꞌ guꞌ anc zeꞌ zeꞌ nu zub ñi. Orzeꞌ nay rab yuñ: ―¡Shnur! ―nay―. Ñgyoozh nac num ru, nunu tonaꞌ la nap gyicy mi num ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Orzeꞌ ornu bzaac ñi anc zeꞌ, tonaꞌ la deet guc nañ lardooñ nu nac riidz nu mniiy. Orzeꞌ gush ñi shcab ben lac mod yaruu riidz nu mniiy loñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Orzeꞌ na anc zeꞌ rab yuñ: ―Li, cueꞌ dzib ru, gun Ñgyoozh bi psaꞌ lagy mi nu nap gyicy num ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ru chuꞌ iꞌñ ru. Orzeꞌ gaal ru tub mdoo gyeey. Orzeꞌ co lar mi Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mi zeꞌ gac mi tub biñ lily. Nii dey nu “Mi zeꞌ iꞌñ Ñgyoozh biñ nu gya zir zu”, nii dey. Orzeꞌ Ñgyoozh gyicy mi nu gac mdoo zeꞌ nir rey lugaar ni gyitoo bel nim Dabi, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","gun orzeꞌ gyub ic mi de nez Israeel tub la, nunu rila wayeca nu gyub ic mi den ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Orzeꞌ na gaꞌ Li: ―¿Lac mod chuꞌ iꞌña̱ zeꞌ rila nigul dzeela̱ biñ gyeey? ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Orzeꞌ na gaꞌ anc zeꞌ: ―Espiriit Yon ni Ñgyoozh gyet mi nu gac num ru. Nunu Ñgyoozh, biñ nu gya zir zu, tonaꞌ la coz ily gyicy mi lat nu gac num ru. Ndeꞌ nu mdoo nir nu gal gac mi mbecy yon, tub mbecy nu nii dey “Iꞌñ Ñgyoozh”, nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Niꞌ nis ru, Bee, gaal mi tub mdoo mas byabel mi. Biñ nu rnii dey nu wagac chuꞌ iꞌñ, mi zeꞌ bi bzaꞌ shuup beey nu yuꞌ iꞌñ mi, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","gun Ñgyoozh gac gyicy mi dela coz ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Orzeꞌ na Li: ―Ya̱ naca̱ tub fiñ feñ nu ricy de coz nu rlagy Ñgyoozh. Orzeꞌ Ñgyoozh gyicy num ya̱ gal nu mniir ―naañ. Orzeꞌ laab ndeꞌ la bruu anc zeꞌ yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Laab tiem zeꞌ bruu Li zeꞌ nu rcyiiñ ñi zañ carer tub gyedz nu ri tub logyiꞌ ni Judea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na ornu bruꞌñañ, orzeꞌ guꞌñ nañ yuꞌ Zacarí. Orzeꞌ mnii nuñ Bee ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na ornu güeñ Bee riidz nu mnii Li, orzeꞌ pcueñ mdoo nañ mi. Orzeꞌ briib ic zaꞌ la Espiriit Yon ni Ñgyoozh mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Orzeꞌ ye la mniim: ―¡Nap zir gyicy nu Ñgyoozh ru gazeꞌ deꞌ zir biñ mñaa! ¡Nunu niꞌ ziꞌl nap gyicy num mdoo nir! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cyu guc ya̱ par nu cyid güii ñaa Shuaana̱ ya̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cuanzir nu güeña̱ nu mnii nur ya̱, orzeꞌ pcueñ mdoo naña̱ nu dzi bet lagy ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dzi nir nu guña lagy ru nu gyuꞌ niñ gal nu mnii Ñgyoozh, Shuaan na ―na Bee. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Orzeꞌ na Li: Ya̱ gyabica̱ gyel mbecy ni Ñgyoozh nu dutuub la lardo̱o̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tonaꞌ la yet lagya̱ nañ lardo̱o̱ nu nac Ñgyoozh, biñ nu co mbañ ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gun mi zeꞌ bduꞌ cuen mi ya̱, tub fiñ feñ nu ricy coz nu rlagy mi. Bzaac mi nu naca̱ tub mbecy shni. Orzeꞌ zigy mbecy nu yad par lo nii dem nu ya̱ naca̱ tub fiñ feñ nu dzi ni. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gun Ñgyoozh, biñ nu gac gyicy dela coz, mi zeꞌ tonaꞌ la coz ily ricy num ya̱. ¡Mi zeꞌ tonaꞌ la yon mi! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dub laa tiem nap ricy num de mbecy nu rca lagy lom. Tant de mbecy zeꞌ nap ricy num, tant iꞌñ dem nu gruu zac par lo nap gyicy num. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Coz ily ricy mi nu nac nu dzi fert mi. Mas la ziꞌl coz nu rboo ic mbecy leꞌ, tees ptush las mi dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mi zeꞌ bloom riiñ nu zu biñ nu nac rey. Tees laagy nañ mi de mbecy shni. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Cuic mi coz nap gow mbecy ran gashtal dzaa la nañ dem. Zeꞌ mbecy guaniꞌñ, zuu nez mi dem gyam ñgyiꞌñ yaam. Ni wabic lam coz nu gow dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Blocyuub mi de mbecy Israeel, de biñ nu ricy coz nu rniim. Nunu wanit lagy mi nu nap gyicy num dem par nu rashni lagy mi dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bicy num Abraham gal nu dela nez mi gal nu mniim lo de gyitoo bel ni den nu segur la gyicy mi. Ni mnii Li. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Orzeꞌ Li pcyiiñ nuñ Bee tub chon beey. Orzeꞌ bruuñ yaañ yuꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na ornu pshuub dzi nu gaal Bee mdoo, orzeꞌ gul tub mdoo gyeey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Orzeꞌ ornu de mbecy nu rcyiiñ num garee ga, gal nu dela famil nim bzaac dey nu nap bicy nu Ñgyoozh mi, orzeꞌ bet lagy dey nuy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Orzeꞌ ornu bzaꞌ shuñ dzi nu gul mdoo zeꞌ, orzeꞌ pcaa dey beey sircunsision cuerp ni mdoo zeꞌ. Orzeꞌ bicy pee dey mboo la dey yu laabaꞌ gal nu la uz yu, Zacarí. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tees ñaa mdoo zeꞌ nam: ―¡Cueꞌ! Rlagy ñi loo lan ñi Waa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Orzeꞌ na dey rab yum: ―Sac ni tub la famil nir nu ni lay ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Orzeꞌ bicy yaa dey lo Zacarí par nu gad lagy dey lac rlagy yu gruu la mdoo niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Orzeꞌ bdiiñ yu tub laꞌ yala nu caay loñ. Orzeꞌ dela mbecy tonaꞌ la za nu ic dey ornu bzaac dey nu pcaay: “Yu zeꞌ gruu lay Waa”, pcaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Orzeꞌ laab or la zeꞌ briib rishniiy tuubaꞌ tir. Orzeꞌ brugyiꞌ ryabic yu gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Orzeꞌ dela de mbecy nu yuꞌ nuy garee tonaꞌ la gudzib dey. Orzeꞌ dutuub la logyiꞌ ni Judea bzu riidz de coz nu guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Orzeꞌ dela mbecy nu güeñ riidz zeꞌ gush dey shcab nu nac ñii. Orzeꞌ na dey rab yu losaꞌy: ―¿Ben cyu gac yu nguzh zeꞌ? ―na dey―. Gun rishli gaal rabee nu ricy Ñgyoozh coz ily num yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Orzeꞌ Espiriit Yon briib ic zaꞌ lam Zacarí, uz mdoo zeꞌ. Orzeꞌ brugyiꞌ rniiy por cuen ni Ñgyoozh. Orzeꞌ nay: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Rlagy ñi gyabic na gyel mbecy ni Shuaan na, biñ nu nac Ñgyoozh ni de mbecy Israeel! Gun biid mi nu co mbañ mi dela mbecy nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bzuu nez mi tub biñ fert nu co mbañ de ub na. Mi zeꞌ laabaꞌ nez Dabi, yu nu bicy de coz nu rlagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gulas mniim nu ni gyicy mi nu nac de riidz nu bzeeñ de yu nu mnii por cuen nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nunu mniim nu com de ub na yaa losaꞌ yuun nu yaa de yu nu rzi lagy lon. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ni bicy mi par nu mniim nu nap gyicy num de too bel ni den. Gun wannit lagy mi trat yon nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nunu trat zeꞌ, ndeꞌ riidz nu mniim lo gyitoo bel ni den Abraham nu segur la gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Riidz zeꞌ rniiñ nu gyicy mi nu glan lo de losaꞌ yuun, gun orzeꞌ wadzib la den gyicy den coz nu rniim, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nunu gun orzeꞌ cuin lom como nac naa mbecy nu nac nim, nunu mbecy nu bi byanap lom. Orzeꞌ cuin lom dutuub la lo yun. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zeꞌ ru, iꞌña̱, mbecy gnii dey nu ru nac ru tub yu nu gnii por cuen ni Ñgyoozh, biñ nu gya zir zu, gun ru cha gar par lo Shuaan na. Gyicy nap ru nañ lardoo de mbecy gal nu ricy nap dey tub nez ornu ded tub yu lily. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gun orzeꞌ gad lagy dela mbecy ni Ñgyoozh nu gyicy sulagy mi de cyi dey. Nunu co mbañ mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gun Ñgyoozh ni den, nu nac nu tonaꞌ la rashni lagy mi mbecy nim, ndeꞌ nu ni gyicy num dey. Gyicy mi nu cyid biñ nu co mbañ mbecy gal nu driib doo. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Orzeꞌ dzi zeꞌ cuic mi yaa ni de mbecy nu yuꞌ zeꞌ nu cow, de mbecy nu ca lo cuen nu gat, gun orzeꞌ lyuuñ ni dey ca par gash yu par nu che ti ri añ ni dey, na Zacarí. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Orzeꞌ yu nguzh zeꞌ zaab raly yu, nunu byafert yu nu nac de coz ni Ñgyoozh. Orzeꞌ pcyiiñ yu tub lugaar ub zi gashtal pshuub la dzi nu blyuuy ub yu lo de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tiem zeꞌ Augusto, yu nu riib ic de nasyoong, pshes nañ yu tub acta nu mniiy lo dey nu cha boo dey ñaꞌn mbecy dutuub la lugaar nu riib ic yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ndeꞌ tir loga la gua loo dey ñaꞌn mbecy lat nu zu Cirenio riiñ nu riib ic yu de gyedz nu yuꞌ lo yu ni Siria. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Orzeꞌ dela mbecy bya dey ledz yu nu cuic yu ñaꞌn yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ndeꞌ nu See bruuy tub gyedz ni Galilea nu la Nazaret. Orzeꞌ yay Beleeng, tub gyedz ni Judea, gun gyedz zeꞌ gul rey Dabi, nunu See nac yu nez Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Orzeꞌ zeꞌ yay nu cuic yu ñaꞌn yu. Nunu ya nuy Li, fiñ nu bi ca lo cuen nu chelaay. Nunu fiñ zeꞌ bi yuꞌ iꞌñ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Orzeꞌ lat nu rcyiiñ dey Beleeng, orzeꞌ pshuub dzi nu gal mdoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Orzeꞌ zeꞌ gul mdoo loga niñ. Orzeꞌ ptiish ñi mdoo zeꞌ negy. Orzeꞌ briñ mdoo zeꞌ nañ tub cano, zeꞌ nu row bañcyug gyizh, gun wangadaꞌ lugaar nu ndri dey nañ yuꞌ ni mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na gaab ga Beleeng yuꞌ la be mbecy nu rña shily. Gua la rel rña dey shily niy lat gyish. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Orzeꞌ bruu zac tub anc ni Ñgyoozh lo dey. Orzeꞌ pca yaa nu bruu lo Ñgyoozh dub yub la zeꞌ nu yuꞌ dey. Orzeꞌ tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Orzeꞌ na anc zeꞌ rab yu dey: ―Cueꞌ dzib der. Ya̱ yap ne̱e̱ tub riidz nu tonaꞌ la nap. Nu nac riidz zeꞌ tonaꞌ la gyet lagy dela mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dzi na la gul tub mdoo ledz Dabi. Nunu mi zeꞌ biñ nu co mbañ der. Mi zeꞌ nac mi Mesías, Shuaan na, biñ nu ca lo cuen nu cyid. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mod nu gad lagy der nu laab mi, ndeꞌ nu gyap der mdoo zeꞌ mbish mi negy rim nañ cano zeꞌ nu row bañcyug gyizh ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Orzeꞌ laab or la zeꞌ bruu zac tub nac anc zigy nu bruu gal gyibaa lo tuubaꞌ anc zeꞌ. Orzeꞌ ryabic dey gyel mbecy ni Ñgyoozh. Orzeꞌ na dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Rlagy ñi gyabic mbecy gyel mbecy ni Ñgyoozh gal gyibaa lugaar nu gya zir zu. Zeꞌ gyishlombecy ii rlagy ñi nu chuꞌ dela mbecy nu gyel ri zu, de mbecy nu gyedzuꞌ lagy mi, na de anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na ornu de anc zeꞌ ya dey gyibaa, orzeꞌ de yu rña shily zeꞌ na dey rab yu losaꞌy: ―Yaa chan Beleeng, cha güiiñ de coz nu guc, de coz nu mnii Ñgyoozh Shuaan den ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Orzeꞌ bicy lal la dey zay. Na ornu bruꞌña dey, orzeꞌ bzaac dey Li, nu See, gal nu mdoo zeꞌ rim nañ cano. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Orzeꞌ ornu bzaac de yu nu rña shily zeꞌ mdoo zeꞌ, orzeꞌ byoo dey rishlo dela mbecy de coz nu mnii anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Orzeꞌ dela mbecy nu güeñ riidz nu mnii de yu nu rña shily zeꞌ gush dey shcab nu nac ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Orzeꞌ Li pcaa ic ñi dela riidz zeꞌ nunu gush ñi shcab nu nac ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Orzeꞌ de yu nu rña shily zeꞌ yay ryabic dey gyel mbecy ni Ñgyoozh nu nac de coz nu güeñ dey nunu nu nac de coz nu bzaac dey. Gun guc ñi gal nu mnii de anc zeꞌ lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na ornu bzaꞌ shuñ dzi nu gul mi, orzeꞌ pcaa dey beey nu la sircunsision cuerp nim. Orzeꞌ bloo la dey mi Jesuuz. Bloo la dey mi gal nu mnii anc zeꞌ lo Li anzir nu chuꞌ iꞌñ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na ornu pshuub dzi nu gyicy dey gal nu rnii leey ni Moisees par nu gyacaacy mbecy lo Ñgyoozh, orzeꞌ za nu dey mdoo zeꞌ Jerusaleeng par nu lyuu dey mi lo Ñgyoozh, Shuaan na. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ni bicy dey gun lat de riidz ni leey ni Ñgyoozh Shuaan na bi cañ: “Dela de iꞌñ gyeey dey, benu mdoo loga la, orzeꞌ rlagy ñi zu chu dey yu nu gac yu ni Ñgyoozh, Shuaan na.” ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Orzeꞌ briic dey tub gun gal nu bi cañ lo leey ni Ñgyoozh, Shuaan na. Gun zeꞌ, ndeꞌ cyup begy o cyup culmbu feñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na tiem zeꞌ zu tub mbecy nu la Simyo̱o̱ Jerusaleeng. Yu zeꞌ tub mbecy nap, nunu tonaꞌ la rca lagy yu lo Ñgyoozh, nunu blez yu par ornu shuub dzi nu gruu mbañ de mbecy Israeel. Nunu Espiriit Yon ni Ñgyoozh guc num yu, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nunu mniim loy nu wat yu anzir nu gzac yu Mesías, biñ nu zuu nez Ñgyoozh nu cyid. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Orzeꞌ mniim loy nu chay nañ yuꞌ nu driib zily mbecy Israeel Ñgyoozh. Orzeꞌ ornu de mbel ni Jesuuz bruꞌña nu dey mi nañ yuꞌ zeꞌ par nu gyicy dey gal nu rniiñ lo leey, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","orzeꞌ Simyo̱o̱ bduꞌ yaay mdoo zeꞌ. Orzeꞌ briic yu gras ni Ñgyoozh. Orzeꞌ nay: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ñgyoozh, Shuaan de̱, na bi bicy yac ru nu de riidz nu mniir nu segur la gyicy ru. Na ya̱, yu nu ricy coz nu rniir, bi guti ye lagya̱ nu gata̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gun ya̱ bi bzaac urlo̱ la̱ biñ nu bzuu nez ru nu co mbañ mbecy, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","biñ nu bzur nu bzaac lo de lo la mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mi zeꞌ nam gal nu na tub yaa nu gyicy nu nap zac de mbecy nu walab mbecy Israeel. Nunu nu nac mi zeꞌ gabe gyel lily ni de mbecy nir, de mbecy Israeel, na Simyo̱o̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Orzeꞌ uz Jesuuz nu ñaam za nu la ic dey coz nu mnii Simyo̱o̱ nu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Orzeꞌ Simyo̱o̱ bdiiñ yu lo Ñgyoozh ni dey. Orzeꞌ nay rab yu Li, ñaa Jesuuz: ―Mdoo ii bi zuu lam nu gyicy mi nu nit lo zigy mbecy Israeel nunu gyicyaꞌm nu zigy dey gruu mbañ yu. Mi ii tub muesht nu bruu lo Ñgyoozh. Nunu zigy mbecy cha dey contr nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gun orzeꞌ gabe coz nu rlagy zigy dey gyicy yu nañ lardooy. Tees de nu ndeꞌ gyicy nuñ ru gal nu ricy tub mandzicy riꞌñ nu gzub ñi gashtal nañ lardoor ―na Simyo̱o̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nunu bzu gaꞌ tub biñ mñaa nu rnii por cuen ni Ñgyoozh nu la An. Mi zeꞌ iꞌñ Fanuel, tub mbecy nez Aser. Mi zeꞌ tonaꞌ la gubel mi. Dzi feñ mi pchelaam. Nunu gagy zi ñaꞌn pcyiiñ num ñgyeem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Orzeꞌ gut yu. Zeꞌ ochent zub tap ñaꞌn rac nu byeeñ byud mi. Orzeꞌ mi zeꞌ rila wancyuum nañ yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. Sinu dzi rel la briib zily mi Ñgyoozh. Nunu pcam ni ub mi nu wangow mi gyit nu rnii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Orzeꞌ laab or la zeꞌ briic mi gras ni Ñgyoozh. Nunu bzat mi Jesuuz lo dela mbecy nu rbez nu co mbañ Ñgyoozh de mbecy Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na ornu bi bicy yac dey leey ni Ñgyoozh Shuaan na na, orzeꞌ bish cya dey yay Galilea. Ya dey gal ledz gaal yu, tub gyedz nu la Nazaret. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Orzeꞌ Jesuuz zaab raly zir mi, nunu yafert zir mi, nunu ral zir shcab nim. Nunu Ñgyoozh nap guc num mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na de mbel ni Jesuuz de ñaꞌn la rza dey Jerusaleeng rza dey saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Orzeꞌ ornu bi yuꞌ Jesuuz tub ñaꞌn trocyup, gua dey saꞌ zeꞌ gal mod nu nil ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na ornu bi bded saꞌ zeꞌ, orzeꞌ gush nez dey yay. Zeꞌ Jesuuz byeeñ gam Jerusaleeng. Nunu wangad lagy de mbel nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Guzii dey nu ya Jesuuz lat deꞌ zir mbecy. Bi bzaꞌ tub dzi nu zu dey nez. Orzeꞌ brugyiꞌ nu ryub dey mi lat de famil nim, nunu lat de mbecy nu yuꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tees wangyad mi ni dey. Orzeꞌ bish cya gaꞌ dey yay laabaꞌ Jerusaleeng nu yub dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na ornu bzaꞌ dzi chon, orzeꞌ byad mi ni dey zub mi nañ yuꞌ nu driib zily mbecy Ñgyoozh nu de yu nu rlyuu leey ni de mbecy Israeel. Rzuub gyidag mi ni dey, nunu rgugyiꞌm lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nunu dela de yu nu reñ de riidz nu rniim za nu la ic dey nu nac nu dzi lily rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ornu bzaac de mbel nim mi, za nu la ic dey. Orzeꞌ ñaam nañ rab ñim: ―Fiñ nguzh, ¿lagu ni bicy nur de̱? Uz ru nu ya̱ tonaꞌ la deet guc nañ lardo̱o̱ de̱ nu ryub de̱ ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Orzeꞌ na Jesuuz rab mi ñaam: ―¿Lagu ryub der ya̱? ¿A wagad lagy der nu ya̱ rlagy ñi nu cui̱ nañ yuꞌ ni Ñgyoozh uza̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tees wangyet lag dey cuen de coz nu mniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Orzeꞌ Jesuuz bish cya gaꞌm num dey yam Nazaret. Zeꞌ pcyiiñ mi nunu bzuub gyidag mi dela coz nu mnii dey. Orzeꞌ ñaam pcaa ic ñi dela coz nu guc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Orzeꞌ Jesuuz zaab raly zir mi. Raly cuerp nim, nunu ral shcab nim. Orzeꞌ Ñgyoozh bet lagy mi nu nac mi, nunu niꞌ ziꞌl mbecy bet lagy dey nu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na bi bzaꞌ tiiñ ñaꞌn nu riib ic yu nu la Tiberio de nasyoong. Zeꞌ Poncio Pilato byub ic yu Judea por cuen ni gubier. Nunu Herodes byub ic yu por cuen ni gubier Galilea. Nunu bicy yu, Lip, byub icaꞌy por cuen ni gubier Iturea nu Traconite. Nunu Lisanias byub ic yu por cuen ni gubier Abilinia. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Orzeꞌ Anás nu Caifás byub ic dey de uz Israeel. Orzeꞌ tiem zeꞌ Ñgyoozh mniim lo Waa, iꞌñ Zacarí, tub lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Orzeꞌ Waa gusay dela lugaar nu ri gaab ga gyoow Jordaang. Orzeꞌ nay rab yu de mbecy: ―Mneꞌ der dela cyi nu ricy ru nunu bzu nis der, gun orzeꞌ Ñgyoozh gyicy sulagy mi de cyi der ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gun Isaías, yu nu mnii por cuen ni Ñgyoozh, laab Waa bzat yu ornu pcaay: Zaab tiꞌ tub mbecy rbish tiy tub lugaar ub zi. Orzeꞌ nay: “Nañ lardoo der nañ gal nu na tub nez. Orzeꞌ bicy nap der nez zeꞌ par ornu cyid Shuaan ru. Pshaal der tub nez nu li par nu ded mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dela nez nu a̱ꞌ tub ruꞌ gyicy tub ruꞌ der ñii. Nunu de zeꞌ nu zub bicy ily gyicy lacy der ñii. Nunu de nez nu a̱ꞌ li guꞌ li der ñii. Nunu dela de nez nu dzi wech zu, gyicy tub ruꞌ der ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Orzeꞌ de lo la mbecy gzac dey biñ nu bzuu nez Ñgyoozh nu co mbañ den”, nay, na Isaías. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Orzeꞌ tonaꞌ la mbecy zigy bruu dey nu yad yu par nu rlagy dey nu griib nis Waa dey. Orzeꞌ Waa nay rab yu dey: ―¡Der mbecy shiñ ricy! ¿Cyu mnii lo der nu gac gla der lo cashtig ily ni Ñgyoozh nu bi yad gaab? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bicy der tub mod nu nap gabe nu bi mneꞌ der de cyi nu ricy ru. Cueꞌ gnii too der nu gla der ni de cashtig zeꞌ nu nac nu rnii der: “De ub na nac naa nez gyitoo bel nin Abraham”, rnii der, gun ya̱ rishli rne̱e̱ lo der nu Ñgyoozh gac gyicy mi nu mas gashtal de gyitaꞌ ii gyac ñi nez Abraham. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gun cashtig ni Ñgyoozh nañ gal na tub gyibag. Bi zu lily ñii par nu shiꞌñ ñi dela yag gashtal lyu lañ. Dela yag nu wacuic uugy nap gyiꞌñ ñi. Orzeꞌ chañ lo gyi ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Orzeꞌ na de mbecy rab yu Waa: ―¿Lac mod gyicy de̱ beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Orzeꞌ na Waa rab yu dey: ―Benu tub mbecy mbish cyup shab yu, orzeꞌ rlagy ñi cuic yu tub ni yu nu sac ni, nunu benu yuꞌ nu row tub mbecy, orzeꞌ rlagyaꞌñ nu cuicaꞌy ñuu gow yu nu sac nu row ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gazaꞌ de yu nu rboo tiñ por cuen ni gubier Rom za gaꞌ dey lo Waa par nu griib nis yu dey. Orzeꞌ na dey rab yu Waa: ―Masht, zeꞌ de̱ ya̱, ¿la coz rlagy ñi nu gyicy de̱? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Orzeꞌ Waa nay: ―Rlagy ñi nu co der tiñ gal nu ca lo cuen nu co der, nunu cueꞌ nu sheñ zir co der ―nay rab yu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Niꞌ ziꞌl de soldad nu yuꞌ zeꞌ bdugyiꞌ gaꞌ dey lo Waa. Orzeꞌ na dey: ―Zeꞌ de̱ ya̱, ¿lac mod gyicy de̱? ―na dey. Orzeꞌ na Waa rab yu dey: ―Cueꞌ co der tiñ ni mbecy por fers la, nunu cueꞌ riib der gyidza too dey. Bzu la der conform ca na la i der nu ricy ru gan ―na Waa rab yu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Orzeꞌ de mbecy brugyiꞌ rgyish lo dey nu zac lo dey tub coz ily, nunu brugyiꞌ rgugyiꞌ dey lo losaꞌy ben a walab Waa nac yu Mesías, biñ nu ca lo cuen nu cyid. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Orzeꞌ Waa nay rab yu dey: ―Ya̱ rishli griib nisa̱ der nu nis, tees cyid tub biñ nu cuic Espiriit Yon ni Ñgyoozh ni mbecy, nunu cuic mi cashtig nu na gal nu na gyi ni dey. Mi zeꞌ tub biñ nu gya zir zu par ya̱. Ya̱ ni wayapa̱ nu shagya̱ gyid nu zub gyid lab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mi zeꞌ nam gal na tub mbecy nu bi zu lily nu tub yag ruꞌ biiz par nu com dela mbigy trig, nunu gyicy tublaazh mi ñii par nu cuꞌ choow mi nañ ye. Zeꞌ de gyid ich ñi zeed mi ñii chañ lo tub gyi nu rila wayu ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Orzeꞌ ni mod nunu zañ zir mod Waa pshaal yu de riidz nu sac nu bruu lo Ñgyoozh lo de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Orzeꞌ pshuu nuy Herodes, yu nu riib ic por cuen ni gubier nu nac nu gush yu Herodías, mñaa bicy yu Lip. Nunu yuꞌ zir coz a̱ꞌ nap nu bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nunu shiñ zir bicy yu ornu bicy yu mandaar nu pshet lag mbecy Waa nañ yuꞌ gyiib. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tiem zeꞌ ornu Waa griib nis yu de mbecy, orzeꞌ niꞌ ziꞌl Jesuuz briic yu nu winis mi. Na lat nu rnii num Ñgyoozh, orzeꞌ byaal la baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Orzeꞌ bruu zac Espiriit Yon ni Ñgyoozh nu na gal na tub beg. Orzeꞌ bet mi toom. Orzeꞌ zaab tiꞌ Ñgyoozh. Gal gyibaa rniim. Orzeꞌ nam: ―Ru nac ru iꞌña̱ nu tonaꞌ la rca̱, nunu tonaꞌ la yet lagya̱ ―na Ñgyoozh gashtal gyibaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ornu bzuub Jesuuz gyiꞌ riiñ nu ricy mi, orzeꞌ yuꞌm ñaꞌn gal rup tii. Orzeꞌ de mbecy guzii dey nu mi zeꞌ iꞌñ See. Zeꞌ See yu zeꞌ iꞌñ Elí. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Orzeꞌ Elí guc yu iꞌñ Matat. Orzeꞌ Matat guc yu iꞌñ Leví. Orzeꞌ Leví guc yu iꞌñ Melqui. Orzeꞌ Melqui guc yu iꞌñ Janai. Orzeꞌ Janai guc yu iꞌñ See. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Orzeꞌ See guc yu iꞌñ Matatías. Orzeꞌ Matatías guc yu iꞌñ Amós. Orzeꞌ Amós guc yu iꞌñ Nau. Orzeꞌ Nau guc yu iꞌñ Esli. Orzeꞌ Esli guc yu iꞌñ Nagai. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Orzeꞌ Nagai guc yu iꞌñ Maat. Orzeꞌ Maat guc yu iꞌñ Matatías. Orzeꞌ Matatías guc yu iꞌñ Semei. Orzeꞌ Semei guc yu iꞌñ Josec. Orzeꞌ Josec guc yu iꞌñ Judá. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Orzeꞌ Judá guc yu iꞌñ Joanán. Orzeꞌ Joanán guc yu iꞌñ Resa. Orzeꞌ Resa guc yu iꞌñ Zorobabel. Orzeꞌ Zorobabel guc yu iꞌñ Salatiel. Orzeꞌ Salatiel guc yu iꞌñ Neri. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Orzeꞌ Neri guc yu iꞌñ Melqui. Orzeꞌ Melqui guc yu iꞌñ Adi. Orzeꞌ Adi guc yu iꞌñ Cosam. Orzeꞌ Cosam guc yu iꞌñ Elmadam. Orzeꞌ Elmadam guc yu iꞌñ Er. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Orzeꞌ Er guc yu iꞌñ Jesuuz. Orzeꞌ Jesuuz guc yu iꞌñ Eliezer. Orzeꞌ Eliezer guc yu iꞌñ Jorim. Orzeꞌ Jorim guc yu iꞌñ Matat. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Orzeꞌ Matat guc yu iꞌñ Leví. Orzeꞌ Leví guc yu iꞌñ Simyo̱o̱. Orzeꞌ Simyo̱o̱ guc yu iꞌñ Judá. Orzeꞌ Judá guc yu iꞌñ See. Orzeꞌ See guc yu iꞌñ Jonam. Orzeꞌ Jonam guc yu iꞌñ Eliaquim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Orzeꞌ Eliaquim guc yu iꞌñ Melea. Orzeꞌ Melea guc yu iꞌñ Mena. Orzeꞌ Mena guc yu iꞌñ Matata. Orzeꞌ Matata guc yu iꞌñ Natán. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Orzeꞌ Natán guc yu iꞌñ Dabi. Orzeꞌ Dabi guc yu iꞌñ Isaí. Orzeꞌ Isaí guc yu iꞌñ Obed. Orzeꞌ Obed guc yu iꞌñ Booz. Orzeꞌ Booz guc yu iꞌñ Sala. Orzeꞌ Sala guc yu iꞌñ Naasón. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Orzeꞌ Naasón guc yu iꞌñ Aminadab. Orzeꞌ Aminadab guc yu iꞌñ Admin. Orzeꞌ Admin guc yu iꞌñ Arni. Orzeꞌ Arni guc yu iꞌñ Esrom. Orzeꞌ Esrom guc yu iꞌñ Fares. Orzeꞌ Fares guc yu iꞌñ Judá. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Orzeꞌ Judá guc yu iꞌñ Jacob. Orzeꞌ Jacob guc yu iꞌñ Isaac. Orzeꞌ Isaac guc yu iꞌñ Abraham. Orzeꞌ Abraham guc yu iꞌñ Taré. Orzeꞌ Taré guc yu iꞌñ Nacor. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Orzeꞌ Nacor guc yu iꞌñ Serug. Orzeꞌ Serug guc yu iꞌñ Ragau. Orzeꞌ Ragau guc yu iꞌñ Peleg. Orzeꞌ Peleg guc yu iꞌñ Heber. Orzeꞌ Heber guc yu iꞌñ Sala. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Orzeꞌ Sala guc yu iꞌñ Cainán. Orzeꞌ Cainán guc yu iꞌñ Arfaxad. Orzeꞌ Arfaxad guc yu iꞌñ Sem. Orzeꞌ Sem guc yu iꞌñ Noé. Orzeꞌ Noé guc yu iꞌñ Lamec. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Orzeꞌ Lamec guc yu iꞌñ Matusalén. Orzeꞌ Matusalén guc yu iꞌñ Enoc. Orzeꞌ Enoc guc yu iꞌñ Jared. Orzeꞌ Jared guc yu iꞌñ Mahalaleel. Orzeꞌ Mahalaleel guc yu iꞌñ Cainán. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Orzeꞌ Cainán guc yu iꞌñ Enós. Orzeꞌ Enós guc yu iꞌñ Set. Orzeꞌ Set guc yu iꞌñ Adaang. Orzeꞌ Adaang guc yu iꞌñ Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Orzeꞌ Jesuuz brugyiꞌ riib ic zaꞌ la Espiriit Yon ni Ñgyoozh mi. Gazeꞌ nu bruum gashtal gyoow Jordaang zam. Orzeꞌ Espiriit Yon ni Ñgyoozh za num mi tub lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Zeꞌ brim cyuu dzi. Orzeꞌ zeꞌ bicy nuras preb mi. Dub laa lat nu brim zeꞌ wangow lam gyit. Na despuees, orzeꞌ briib nu ran mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Orzeꞌ na nuras rab yum: ―Benu ru rishli gaal nac ru iꞌñ Ñgyoozh, orzeꞌ mnii lo de gyitaꞌ ii nu gyac ni gyishtily ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Orzeꞌ Jesuuz nam rab mi nuras: ―Lat de riidz ni Ñgyoozh rniin: “Walab gyishtily ziꞌl gyicy ñi nu cui mbañ mbecy”, rniiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Gazeꞌ nu nuras gua nuy mi tub zeꞌ nu gya. Orzeꞌ nañ tub miiñ ziꞌl blyuuy dela lugaar ni gyishlombecy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Orzeꞌ nay: ―Ya̱ gyicya̱ nu gac gyub ic ru dutuub la gyishlombecy ii, nunu grica̱ dela gyel nap nu yuꞌ loñ nir. Ya̱ bi guud ñi ne̱, nunu gac grica̱ ñii ni cyu ziꞌl mbecy nu rlagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ya̱ grica̱ ndeꞌ nir benu zu tib ru lo̱ nu griib zily ru ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Orzeꞌ Jesuuz nam rab mi nuras: ―Gun lat de riidz ni Ñgyoozh rniin: “Briib zily Shuaan ru, biñ nu nac Ñgyoozh nir, nunu se coz nu rlagy ziꞌl mi gyicy ru”, rnii riidz nim ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Gazeꞌ nu za nu nuras mi par Jerusaleeng. Orzeꞌ pshup yum zeꞌ nu gya zir ni yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. Orzeꞌ nay rab yu Jesuuz: ―Benu rishli gaal nac ru iꞌñ Ñgyoozh, orzeꞌ bzut yeñ gashtal lo yu la re. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gun lat de riidz ni Ñgyoozh rniiñ: Ñgyoozh cuꞌm riiñ yaa de anc nim nu ña dey ru, nunu wazaan dey nu shiñ gzac ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Orzeꞌ lagy yaa dey ru, gun orzeꞌ cueꞌ nu gad güii par ni gyiꞌr lo de gyitaꞌ, rniiñ, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Orzeꞌ Jesuuz nam rab mi yu: ―Niꞌ ziꞌl rniiñ lat de riidz nim: “Cueꞌ gyicy ru preb Ñgyoozh, Shuaan ru”, rniiñ ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Orzeꞌ nuras wangadaꞌ mod nu ñgyicy yu preb Jesuuz. Orzeꞌ bruu chuy lom par la be tiem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Orzeꞌ Jesuuz ya gaꞌm par lo de yu ni Galilea, nunu riib ic zaꞌ la Espiriit Yon ni Ñgyoozh mi. Orzeꞌ brush las riidz ni de coz nu bicy mi dela lugaar nu yuꞌ gaab ga zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Orzeꞌ rlyuum nañ de yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh de ga la lugaar zeꞌ nu rded mi. Nunu dela mbecy ryabic dey gyel mbecy nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Orzeꞌ Jesuuz yam Nazaret, gyedz zeꞌ nu guul mi. Na ornu pshuub sab, dzi nu rzu lagy de mbecy Israeel, orzeꞌ bicy mi gal mod nu nil ricy mi. Orzeꞌ guꞌm nañ yuꞌ zeꞌ nu rsyaꞌ dey riidz ni Ñgyoozh. Gazeꞌ nu wes sum nu lab mi riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Orzeꞌ briic dey libr ni Isaías, tub yu nu rnii por cuen ni Ñgyoozh, par nu lab mi. Na ornu pshaal mi looñ, orzeꞌ byap mi zeꞌ nu cañ nu rniiñ: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espiriit Yon ni Ñgyoozh Shuaana̱ riib ic mi ya̱, gun bzum ya̱ nu cha̱ ne̱e̱ de riidz nu sac lo de mbecy zi. Nunu bzuu nez mi ya̱ par nu gyicya̱ nu cueꞌ gyub ic reñaꞌ coz nañ lardoo de mbecy. Nunu bzuu nez mi ya̱ nu gyicya̱ nu zac de mbecy nu wacsac. Nunu bzuu nez mi ya̱ par nu gyicya̱ nu gruu nap de mbecy nu rzac zi nu nac nu shiñ ricy nu de losaꞌy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nunu bzuu nez mi ya̱ nu ne̱e̱ lo dela mbecy nu bi pshuub ñaꞌn nu nap gyicy nu Ñgyoozh dela mbecy, rniiñ, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Laab ndeꞌ la. Orzeꞌ Jesuuz ptub mi gyicy zeꞌ. Orzeꞌ byabic mi ñii ni yu nu zu riiñ nañ yuꞌ zeꞌ. Orzeꞌ gusub mi. Orzeꞌ mbi la bgüii de yu nu yuꞌ nañ yuꞌ zeꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Orzeꞌ brugyiꞌ rniim. Orzeꞌ nam rab mi dey: ―Lat nu blaba̱ de riidz zeꞌ lo der, orzeꞌ byuꞌ niñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Orzeꞌ dela mbecy nap mnii dey nu nac Jesuuz, nunu bet lagy dey de riidz cyit na nu mniim. Orzeꞌ na dey rab dey losaꞌy: ―Zeꞌ, ¿a walab yu ii iꞌñ See? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ rad lagya̱ nu segur la nii der tub riidz cyit. Riidz zeꞌ, ndeꞌ: “Ru nac ru tub mbecy nu ricy guñaa. Orzeꞌ gyicy yac ru ub ru. Orzeꞌ gal nu bicy ru gyedz Capernaum, niꞌ ziꞌl gyicy ru ledz ru ii”, nii der lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ya̱ rishli rne̱e̱ lo der nu ni tub la mbecy nu rnii por cuen ni Ñgyoozh, de mbecy ledz yu wagyicy cuen dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gun rishli gaal tonaꞌ la yuꞌ byud Israeel tiem ni Elías, yu nu mnii por cuen ni Ñgyoozh, tiem nu wangyet gyey chon naꞌñ nu. Nunu tonaꞌ la byan mbecy dutuub la lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tees Elías wanchay lo ni tub la byud nu yuꞌ Israeel, sinu guay lo tub byud nu rcyiiñ Sarepta. Ndeꞌ tub gyedz nu ri gaab ga Sidón. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Niꞌ ziꞌl tiem ni Eliseo, yu nu mnii por cuen ni Ñgyoozh, tonaꞌ la zigy de mbecy Israeel gurat yu gyedz nu la lepra. Tees ni tub la dey wangyac yu. Nomaas byac tub mbecy nu la Naamán. Yu zeꞌ tub mbecy nu bruu lo yu ni Siria ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ornu güeñ dela mbecy nu nguaa nañ yuꞌ zeꞌ de riidz nu mniim, orzeꞌ tonaꞌ la pchaꞌ ic dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Orzeꞌ wes su dey, nunu gua nu dey Jesuuz por fers la par ruꞌ gyedz zeꞌ. Gazeꞌ nu pshup dey mi too tub bicy zeꞌ nu ri gyedz zeꞌ, gun bicy pee dey nu nshet lag dey mi gal zeꞌ nu gya ni bicy zeꞌ, gal lo yu la. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Orzeꞌ bded mi lat dey yam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Orzeꞌ Jesuuz yam tub gyedz nu ri lo yu ni Galilea nu la Capernaum. Orzeꞌ sab, dzi nu rzu lagy mbecy Israeel, guꞌm nañ yuꞌ zeꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh par nu lyuum ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Orzeꞌ de mbecy za nu la ic dey nu nac coz nu rniim, gun rlyuum ni dey gal nu rlyuu tub mbecy nu riib ic zaꞌ la. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na nañ yuꞌ zeꞌ ri tub mbecy nu bicy ni nuras. Orzeꞌ ye la rbish tiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Orzeꞌ nay rab yu Jesuuz: ―Bruu chu. ¿Lagu yad ru lat de̱, Jesuuz, biñ nu bruu Nazaret? ¿A yad ru par nu zaꞌ lor de̱ ya̱? Ya̱ rad lagya̱ nu ru nac ru mbecy yon ni Ñgyoozh ―nay rab yu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Orzeꞌ Jesuuz bdzaꞌm ni nuras zeꞌ. Orzeꞌ nam rab mi yu: ―Dzi chel, nunu bruu chu lo yu ii ―nam. Orzeꞌ nuras zeꞌ mneꞌy mbecy zeꞌ lo yu lo rgüii la dela mbecy. Orzeꞌ gazeꞌ nu bruu chuy lo mbecy zeꞌ, nunu se la la bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Orzeꞌ dela mbecy nu yuꞌ zeꞌ gudzib dey. Orzeꞌ na dey rab dey losaꞌy: ―¿Lac yaruu nu nii? ¡Mbecy ii ricy cup yu rishbeey, nunu ricy cup yu mod nu ricy yu mandaar gashtal nuras, nunu orzeꞌ druu chu dey lo mbecy! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Orzeꞌ lueg la bzu riidz ni de coz nu bicy Jesuuz dela lugaar nu yuꞌ gaab ga. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Orzeꞌ Jesuuz bruum nañ yuꞌ zeꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh. Orzeꞌ yam yuꞌ Simo̱o̱. Zeꞌ ñaa gud Simo̱o̱ riib rat mi. Tonaꞌ la pcaañ zig nim. Orzeꞌ mnishbaa dey lo Jesuuz nu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Orzeꞌ gazeꞌ nu gua Jesuuz bzaab tily mi lom. Orzeꞌ bicy mi mandaar nu gruu zig zeꞌ. Orzeꞌ bruu zig mi. Gazeꞌ nu lueg la weshtem, nunu brugyiꞌ rzu bich mi nu nac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na ornu bi za doo na, orzeꞌ dela mbecy nu ricy cup famil ni nu rat zañ lo güii, orzeꞌ gua nu dey yu lo Jesuuz. Orzeꞌ mi zeꞌ briib yaam too tub ga la dey. Gazeꞌ nu byac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nunu bruu chu zañ nuras nu bicy ni mbecy nu yuꞌ lat de mbecy rat zeꞌ. Orzeꞌ nuras zeꞌ rbish ti dey. Orzeꞌ na dey rab yu Jesuuz: ―¡Ru nac ru iꞌñ Ñgyoozh! ―na dey. Orzeꞌ Jesuuz bdzaꞌm ni de nuras zeꞌ. Orzeꞌ wansaan mi nu nii zir dey, gun yuꞌ lo dey mi nu nac mi Mesías, biñ nu ca lo cuen nu cyid. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na or bzaꞌ yu tuubaꞌ dzi na, orzeꞌ Jesuuz bruum lat gyedz zam tub lugaar ub zi. Orzeꞌ de mbecy brugyiꞌ nu ryub dey mi. Orzeꞌ bruꞌña dey zeꞌ nu zum. Orzeꞌ bicy pee dey nu wazaan yu nu gruum lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Orzeꞌ nam rab mi dey: ―Tees niꞌ ziꞌl rlagy ñi cha shaala̱ de riidz nap ni gyel gubier ni Ñgyoozh de reñaꞌ gyedz, gun par ndeꞌ bzuu nez Ñgyoozh ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Orzeꞌ Jesuuz gusam pshaal mi de riidz nu bruu lo Ñgyoozh nañ de yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh nu yuꞌ de lo yu ni Judea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Guc ñi tub tiem nu Jesuuz brim ruꞌ nisyudoo tub gyedz nu la Genesaret. Orzeꞌ de mbecy rcyiꞌñ su laa dey mi, gun rlagy dey gyeñ dey de riidz ni Ñgyoozh nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Orzeꞌ Jesuuz bzaac mi cyup barc zuñ ruꞌ nisyudoo. Nat laa nañ ñi, gun de yu nu rub bel bruu dey nañ ñi nu za tiib dey gyish niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Orzeꞌ Jesuuz guꞌm nañ tub barc zeꞌ. Orzeꞌ barc zeꞌ, ndeꞌ barc ni Simo̱o̱. Gazeꞌ nu mniim lo Simo̱o̱ nu gyicy zet zir yu barc zeꞌ par ruꞌ nisyudoo. Orzeꞌ gusub mi, nunu brugyiꞌ rlyuum ni mbecy gal nañ barc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na ornu blazh blyuum ni dey na, orzeꞌ nam rab mi Simo̱o̱: ―Gua nu barc nir zeꞌ nu gyi ni nisyudoo. Orzeꞌ neꞌr gyish nir lo nis par nu cub ru bel ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Orzeꞌ na Simo̱o̱ rab yum: ―Masht, gua la rel ricy de̱ riiñ nu rdub de̱ bel. Zeꞌ ii rila wangad la ma ni de̱. Tees na como ru mniir, orzeꞌ ya̱ ne̱ꞌ gyish ne̱ lo nisyudoo ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na ornu mneꞌ dey gyish niy lo nisyudoo na, orzeꞌ tonaꞌ la guud bel ni dey. Gashtal riꞌñ la gyish ni dey tantaꞌ nu yuꞌ bel nañ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Gazeꞌ nu bicy yaa dey lo losaꞌy, de yu nu yuꞌ nañ reñaꞌ barc par nu cha locyuub dey yu. Gazeꞌ nu gua nu de yu zeꞌ barc niy. Orzeꞌ bdzaa la nañ rup laa barc ni dey nu yuꞌ bel. Se nu ches ti ziꞌl barc ni dey lo nisyudoo tantaꞌ nu yuꞌ ma nañ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na ornu Bed bzaac yu de nu ndeꞌ, orzeꞌ gusu tib yu lo Jesuuz. Orzeꞌ nay rab yum: ―Bruu chu lo̱ Shuaana̱, gun ya̱ naca̱ mbecy cyi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ni mniiy gun gudzib yu, nunu niꞌ ziꞌl gudzibaꞌ deꞌ zir mbecy nu nac de bel zañ nu guud zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gazaꞌ Santiag nu Waa, de iꞌñ Zebedeo, gudzib dey. De yu zeꞌ losaꞌ Simo̱o̱. Orzeꞌ Jesuuz nam rab mi Simo̱o̱: ―Cueꞌ dzib der, gun nese na la gal nu rub der bel, niꞌ ziꞌl teꞌ der de mbecy, gun orzeꞌ cyid ca dey icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Gazeꞌ nu gua zeeñ dey de barc niy par lo yu bigy. Orzeꞌ zeꞌ bzeeñ dey barc niy. Orzeꞌ za ca̱ dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tub dzi Jesuuz zam tub gyedz. Orzeꞌ zeꞌ bruꞌña tub mbecy nu rat tub lo gyedz nu la lepra. Na ornu bzaac yu Jesuuz, orzeꞌ wes saa tiily yu gashtal lo yu la. Orzeꞌ mnishbaay lo Jesuuz. Orzeꞌ nay rab yum: ―Benu rlagy ru, ru gac gyicy yac ru ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Orzeꞌ Jesuuz gul yaam yu. Orzeꞌ nam: ―Rlagya̱. Orzeꞌ na byac ru ―nam. Orzeꞌ lueg la mnit la gyedz zeꞌ cuerp niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Orzeꞌ na gaꞌ Jesuuz rab mi yu: ―Cueꞌ niir lo ni tub la mbecy, sinu gua lo uz cha lyuur ub ru loy. Orzeꞌ cuic ru gun nu rlagy ñi par nu gyacaacy ru par lo Ñgyoozh gal nu mnii Moisees nu gyicy na, gun orzeꞌ gad lagy dela mbecy nu bi byac ru ni güii nu rat ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mas ni mniim, tees de coz nu bicy mi bzu zir ñi. Nunu tonaꞌ la mbecy zigy byatublaazh dey lom par nu zuub gyidag dey nim, nunu par nu gyicy yac mi de güii nu rat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tees Jesuuz bruu chum lo dey zam tub lugaar ub zi nu nii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tub dzi zub Jesuuz rlyuum ni de mbecy. Lat zeꞌ nguaa la be mbecy fariseo nu de yu nu rlyuu leey ni Ñgyoozh. De yu zeꞌ bruu dey dela lugaar ni Galilea, nu de lugaar ni Judea, gal nu de lugaar ni Jerusaleeng. Nunu rabee nu Ñgyoozh ricy mi coz ily nu nac Jesuuz nu nac nu bicy yac mi de mbecy rat. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Orzeꞌ bruꞌña nu dey tub mbecy chi̱ lom riib yu lo tub nuun. Bicy pee dey nu chuꞌ nu dey mbecy chi̱ zeꞌ nañ yuꞌ zeꞌ nu zub Jesuuz par nu cyish dey yu lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tees wangad mod nu chuꞌ nu dey mbecy chi̱ zeꞌ, gun dzi yuꞌ mbecy. Gazeꞌ nu gup dey par too yuꞌ. Gazeꞌ nu blaat dey tub gyeegy lat de tej. Gazeꞌ nu pshet dey nuun nu riib mbecy rat zeꞌ lat de mbecy zigy zeꞌ nu zub Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na ornu gud lagy mi nu ricy cup dey consuel lom na, orzeꞌ nam rab mi mbecy chi̱ zeꞌ: ―Ru, de cyir bi byecy ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Orzeꞌ de yu nu rlyuu leey ni Ñgyoozh, nu de mbecy fariseo brugyiꞌ nu rnii too dey: “¿Cyu mbecy yu ii? ¿Lagu rniiy coz nu za contr ni Ñgyoozh? Tub zi la Ñgyoozh gac gyicy sulagy mi de cyi nu ricy mbecy”, rnii too dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tees Jesuuz gud lagy mi nu ni rnii too dey. Gazeꞌ nu nam rab mi dey: ―¿Lagu ni rnii too der? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dzi zir a̱ꞌ biigy par nu ne̱e̱ nu bi bicy sulagya̱ de cyir gazeꞌ nu ne̱e̱ wes su nunu bza ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tees ya̱ ne̱e̱ lo yu re nu gyes suy nunu gzay, gun orzeꞌ gad lagy der nu ya̱, biñ nu byac mbecy, ricy cupa̱ rishbeey nu gyicy sulagya̱ de cyi mbecy gyishlombecy ii ―nam. Gazeꞌ nu nam rab mi mbecy chi̱ zeꞌ: ―Ya̱ ne̱e̱ du̱ ru wes su, gush nuun nir nunu yaa yuꞌr ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Orzeꞌ lueg la wes suy lo rgüii la de mbecy zigy zeꞌ. Orzeꞌ bduꞌ yaay nuun nu byub yu lo zeꞌ. Orzeꞌ yay yuꞌy. Nunu ryabic yu gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Orzeꞌ dela yu nu nguaa zeꞌ za nu la ic dey. Orzeꞌ byabic dey gyel mbecy ni Ñgyoozh, nunu tonaꞌ la gudzib dey. Orzeꞌ na dey: ―Dzi na bzaac na tub nusuriidz ily ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ornu bded ni de nu ndeꞌ, orzeꞌ bruu Jesuuz zam. Orzeꞌ bzaac mi tub yu nu rboo tiñ por cuen ni gubier Rom. Yu zeꞌ lay Leví. Zub yu zeꞌ nu rboo dey tiñ. Orzeꞌ na Jesuuz rab mi yu: ―Da ca icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Orzeꞌ wes suy. Bzeeñ ga lay de yu nu nguaa nuy zeꞌ za cay ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na despuees, orzeꞌ Leví bicy yu tub saꞌ ily yuꞌy nu nac Jesuuz. Nunu zeꞌ nguaa gaꞌ de yu nu rboo tiñ por cuen ni gubier Rom, gal nu zigy zir de mbecy. Tublaazh la nguaa dey lo mez row dey gyit. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tees de mbecy fariseo, gal nu de yu nu rlyuu ley ni Ñgyoozh, brugyiꞌ nu zi ga la rnii dey nu de yu nu rsyaꞌ lo Jesuuz. Orzeꞌ na dey: ―¿Lagu row der, nunu lagu roꞌ der nis nu de mbecy nu rboo tiñ por cuen ni gubier Rom, gal nu nu de mbecy cyi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Orzeꞌ Jesuuz nam rab mi dey: ―Par de mbecy ruub walagy ñi doctoor, tees par de mbecy rat rlagy ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Gal nu doctoor wagyicy nuy mbecy ruub guñaa, niꞌ ya̱ a̱ꞌ yapa̱ nu redza̱ mbecy nu sac cyi, sinu dredza̱ de mbecy cyi par nu neꞌ dey de cyiy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Orzeꞌ na dey rab yu Jesuuz: ―De yu nu rsyaꞌ lo Waa rca dey ni ub yu nu cueꞌ goy gyit lat nu rzu bich dey nu nac Ñgyoozh. Nunu cyaꞌ rnii nu dey mi. Nunu niꞌ ziꞌl ricy de yu nu rsyaꞌ lo de mbecy fariseo. Zeꞌ de yu nu rsyaꞌ lo ru de dzi la row dey nunu roꞌ dey ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Orzeꞌ Jesuuz nam rab mi dey: ―Ya̱ na̱ gal nu na tub nob. ¿Walab gaal gac ca de yu nu yuꞌ lo fandang ni ub yu nu cueꞌ goy gyit lat nu gabee rded nob lat dey? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tees shuub tub dzi nu co mbecy nob zeꞌ lat dey. Orzeꞌ gazeꞌ nu gac ca dey ni ub yu nu cueꞌ goy gyit par nu gyicy shni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Orzeꞌ Jesuuz mniim tub riidz tiily lo dey. Orzeꞌ nam: ―Gun mod nu bicy de gyitoo bel, ndeꞌ nañ gal nu na tub negy gush. Ni tub la mbecy washiꞌñ mi tub negy cub nu gad tub laꞌ negy nu gyicy mi rumien negy gush, gun nis gash beñ negy cub zeꞌ. Orzeꞌ gyicy ñi nu shaa negy cub zeꞌ. Nunu negy cub zeꞌ wagyap ñi negy gush zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nunu mod nu ricy de gyitoo bel, ndeꞌ nañ gal nu na tub gyid gush nu rguꞌ choow dey ñup ni urbyay. Ni tub la mbecy wac cuꞌ choow dey ñup ni urbyay cub nañ gyid gush, gun nis cyich ñiñ. Orzeꞌ shu dela ñup ni urbyay zeꞌ, nunu nit lo gyid zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ndeꞌ nu rlagy ñi cuꞌ choow dey ñup ni urbyay cub nañ gyid cub, gun orzeꞌ rup laañ wanit lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nunu ni tub la yu nu roꞌ ñup ni urbyay gush walagy yu goꞌy ñup ni urbyay cub, gun rnii dey nu “Nap zir roꞌ ñup ni urbyay gush”, rnii dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na tub dzi sab, dzi nu rzu lagy mbecy Israeel, orzeꞌ Jesuuz bded mi nu de yu nu rsyaꞌ lom lat tub nac trig. Orzeꞌ de yu nu rsyaꞌ lom brugyiꞌ nu rcyug dey zaꞌ ni trig zeꞌ. Gazeꞌ nu brugyiꞌ nu rzuub dey ñi nu yaay. Orzeꞌ gazeꞌ nu bdow dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Orzeꞌ la be mbecy fariseo na dey rab yu Jesuuz: ―¿Lagu ricy de ru riiñ nu a̱ꞌ yad ñi nu gyicy mbecy dzi nu rzu lagy den? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Orzeꞌ na Jesuuz rab mi dey: ―¿Walab gaal nigul syaꞌ der lat de riidz ni Ñgyoozh zeꞌ nu rniiñ de coz nu bicy Dabi lat nu byan yu nu de losaꞌy nu gusa nuy? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Orzeꞌ guꞌ dey nañ yuꞌ ni Ñgyoozh. Bloo dey de gyishtily nu nguaa zeꞌ. Ndeꞌ de uz nu zu riiñ lo Ñgyoozh ziꞌl gac gow yuñ. Tees Dabi bdow yu gyishtily zeꞌ, nunu briicaꞌy gow de yu nu gusa nuy ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Gun ya̱, biñ nu byac mbecy, riib ica̱ sab, dzi nu rzu lagy mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na tuubaꞌ dzi sab, dzi nu rzu lagy mbecy, orzeꞌ guꞌm nañ yuꞌ zeꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Orzeꞌ brugyiꞌ rlyuum ni dey, nunu nañ yuꞌ zeꞌ ri tub mbecy nu gush beñ tub laꞌ yaa beey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Orzeꞌ la be de yu nu rlyuu leey ni Ñgyoozh, gal nu la be mbecy fariseo psiiñ dey nim, ben a gyicy yac mi mbecy rat zeꞌ sab, dzi nu rzu lagy mbecy, gun dzi ga gad tub mod nu riib dey cyi ic mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tees Jesuuz gud lagy mi la coz rnii too dey. Orzeꞌ nam rab mi mbecy nu gush beñ yaa zeꞌ: ―Wes su. Da lo̱ gashtal gazel ii ―nam. Orzeꞌ mbecy nu gush beñ yaa zeꞌ wes suy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Orzeꞌ Jesuuz nam rab mi deꞌ zir de mbecy: ―Na ya̱ dugyi̱ꞌ tub coz lo der. ¿Ca na coz nu nap zuñ par lo leey ni Moisees nu gyicy na sab, dzi nu rzu lagy mbecy? ¿A nap nu gyicy na coz nap, o ti nap nu gyicy na coz a̱ꞌ nap? ¿A nii tub dzi nu gloo mbañ naa mbecy, o ti nii tub dzi nu gnit lon mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Orzeꞌ bgüiim lo de yu nu yuꞌ lom. Gazeꞌ nu nam rab mi mbecy yaa gush beñ zeꞌ: ―Bzaab yaar lo̱ ―nam. Orzeꞌ mbecy zeꞌ bzaab yaay lom. Orzeꞌ byanap la yaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Zeꞌ deꞌ zir de mbecy tonaꞌ la pchaꞌ ic dey. Orzeꞌ brugyiꞌ nu ro dey riidz ben lac mod gyicy nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Orzeꞌ laab tiem zeꞌ Jesuuz zam tub logyiꞌ nu nii num Ñgyoozh. Orzeꞌ gua la rel nu rim zeꞌ rnii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na ornu bzaꞌ yu na, orzeꞌ bredz mi de yu nu rsyaꞌ lom. Orzeꞌ lat de yu zeꞌ bloo sum trocyup dey. Orzeꞌ bloo lam dey aposht. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Orzeꞌ nii nu la de trocyup de yu nu bloo sum zeꞌ. Gush lañ: Simo̱o̱, yu nu bloo lam Bed, nu bicy yu Ndrees, nu Santiag, nu Waa, nu Lip, nu Bartol, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nu Mateo, nu Tomaas, nu Santiag, iꞌñ Alfeo, nu Simo̱o̱, yu nu nac partid nu la celote, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nu Judas, bicy Santiag, nu Judas Iscariote, yu nu bish cya ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Orzeꞌ Jesuuz bruum logyiꞌ bet mi nu de yu nu bloo sum zeꞌ. Gazeꞌ nu gucua dem tub zeꞌ nu lacy. Orzeꞌ zeꞌ bi nguaa zigy de yu nu rsyaꞌ lom. Nunu nguaa zigy zir mbecy, de yu nu bruu lo yu ni Judea, nu de yu nu bruu Jerusaleeng, nu yu nu bruu Tiro nu Sidón, cyup gyedz nu ri ruꞌ nisyudoo. Dela dey zeꞌ yad dey par nu zuub gyidag dey de riidz nu rnii Jesuuz, nunu par nu gyicy mi nu nit de güii nu rat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nunu niꞌ ziꞌl bicy yac mi de mbecy nu bicy ni nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndeꞌ nu dela de mbecy rlagy dey nu gal yaa dey Jesuuz, gun gyicy yac mi dey nu nac fers nu gruu nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gazeꞌ nu Jesuuz bgüiim lo de yu nu rsyaꞌ lom. Gazeꞌ nu nam rab mi dey: ―Dzi ni de ru mbecy nu gyel zi zu, gun de ru gzac ru lo gyel gubier ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dzi ni de ru mbecy nu ran na, gun orzeꞌ gad nu gyel ni der. ’Dzi ni de ru mbecy nu ruun na, gun par lo orzeꞌ gyigy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Dzi ni der ornu rzi lagy mbecy lo der, nunu ornu cyuu nu dey der, nunu ornu rnii zi dey ni der, nunu ornu rnii dey nu nac der mbecy a̱ꞌ nap nu nac ya̱, biñ nu byac mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Orzeꞌ tonaꞌ la bet lagy der dzi zeꞌ, nunu gal briich la gyiꞌ der lo yu, gun gyibaa gyad tub i der nu tonaꞌ la coz ily, gun niꞌ ziꞌl mod de gyitoo bel ni den pshet zi dey de mbecy nu rnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’¡Tees cuaa de ru mbecy guaniꞌñ, gun bi bicy der gusht ni der! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Nunu cuaa de ru mbecy nu dza nañ, gun par lo gyan der! ’¡Nunu cuaa de ru mbecy nu dzi rigy na, gun par lo gun der nu gyicy shnir! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Cuaa gaꞌ der ornu dela mbecy ryabic dey gyel mbecy nir, gun niꞌ ziꞌl de too bel ni dey byabic dey gyel mbecy ni de mbecy nu mnii fals por cuen ni Ñgyoozh gulas! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Tees ya̱ rne̱e̱ lo der mbecy nu rzuub gyidag ne̱ ya̱: Pca der losaꞌ yuur, nunu nap bicy nu der de yu nu rzi lagy lor. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nunu nap mnii der ni de yu nu shiñ rnii rab de ru. Nunu bdiiñ der lo Ñgyoozh ni de yu nu rnii zi ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Benu tub mbecy shet yu zig tub laꞌ ya lor, orzeꞌ zaabaꞌ der tub laꞌ gaꞌ loy nu shet yu. Nunu benu ca na mbecy rbooy chicyet ni der, orzeꞌ briic la niy, nunu briicaꞌ yaag ru niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nunu benu ca na mbecy cyiñ yu la coz lor, orzeꞌ cuic ru ñii niy. Nunu benu ca na mbecy rbooy la coz nir, orzeꞌ cueꞌ niir loy nu gyabic yu nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nunu bicy nu der deꞌ zir mbecy gal mod nu rlagy ub der nu gyicy nu dey der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Nunu benu de ru ca ziꞌl der de yu nu rca ziꞌl ru, ¿a dzi coz ilyaꞌ ricy der rziir? Gun mas gashtal de mbecy cyi rca dey losaꞌy benu niꞌ rca losaꞌy ub yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nunu benu nap gyicy der nu de mbecy nu nap ziꞌl gyicy nu ru, ¿a ndeꞌ la nu dzi coz ilyaꞌ ricy der, rziir? Gun mas gashtal de mbecy cyi ni ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nunu benu rbic der de coz nu rboo mbecy nu rzii der nu gyabicaꞌy nir, ¿a dzi coz ilyaꞌ ricy der rziir? Gun niꞌ ziꞌl de mbecy cyi rbicaꞌ dey de coz rboo losaꞌy. Nunu rgyish lo dey nu gyabicaꞌ losaꞌy niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Orzeꞌ pca der losaꞌ yuur, nunu nap bicy nu der dey, nunu briic der coz nu co losaꞌr. Nunu cueꞌ cyish lo der nu gyabic yu ni tub la coz nir. Orzeꞌ gyad tub i der nu tonaꞌ la coz ily. Nunu orzeꞌ gyac der iꞌñ Ñgyoozh, biñ nu gya zir zu. Gun mi zeꞌ nap mi num de mbecy nu sac graseer, gal nu de mbecy a̱ꞌ nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Guc der mbecy nu rashni lagy losaꞌ, gal nu Ñgyoozh uz der rashni lagy mi mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Cueꞌ nii der nu yuꞌ falt ni losaꞌr, gun orzeꞌ Ñgyoozh waniim ti yuꞌ falt ni der. Cueꞌ nii der nu rlagy ñi nu cha losaꞌr lo cashtig, gun orzeꞌ Ñgyoozh waniim nu de ru rlagy ñi char lo cashtig. Bicy sulagy der ni losaꞌr. Orzeꞌ Ñgyoozh gyicy sulagyaꞌm ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Briic der coz nu galagy losaꞌr, gun orzeꞌ Ñgyoozh cuicaꞌm de coz nu galagy der. Nunu cuic zaꞌ lam ñii ni der. Gun dub gal nu gyicy nu der losaꞌr, dub ni gyicy num de ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Orzeꞌ Jesuuz mniim tub riidz tiily lo dey. Orzeꞌ nam: ―¿Walab gaal gac tub lo caꞌ lyuuy nez ni tuubaꞌ mbecy lo caꞌ? ¿A walab orzeꞌ rup laa dey gyet lag yu nañ tub ziꞌl gyeegy? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sac ni tub yu nguzh scuel nu zily zir nac yu par moscuel niy. Tees ornu lazh syaꞌ dey, orzeꞌ gazeꞌ nu saap yu moscuel niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’De ru na der gal na mbecy nu rguꞌ cuen toop miꞌ nu ri urlo losaꞌ, zeꞌ yabicy nu ri urlo ub der, ndeꞌ wagyicy cuen der ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Zeꞌ benu ri tub yabicy urlo der, zeꞌ wayicy cuen ru ñii, ¿orzeꞌ lagu rnii gaꞌ der lo losaꞌr: “Doo urlor, gun lo̱o̱ toop miꞌ zeꞌ”, rnii gaꞌ der? ¡A mbecy rzuu lo! Bloo yabicy ily nu ri urlor loga la, gun orzeꞌ nap zir zac ru cor toop miꞌ nu ri urlo losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Sac ni tub la yag nap nu cuic ñi uugy shiñ na, nunu niꞌ sac tub yag a̱ꞌ nap na nu cuic ñi uugy nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tub ga la yag rad lagy den la nañ nu nac de uugy nu rbic ñi, gun tub ya gyech wac cuic ñi urlas mni. Nunu niꞌ tub gyish gyech wac cuic ñi urbyay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Benu tub mbecy nap, yu zeꞌ rniiy coz nap, gun coz nap yuꞌ nañ lardooy. Benu tub mbecy a̱ꞌ nap, rniiy coz a̱ꞌ nap, gun yuꞌ coz a̱ꞌ nap nañ lardooy. Dub gal lac na coz nu yuꞌ nañ lardooy dub ni na coz nu rniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Lagu rnii der ya̱, “Shuaana̱, Shuaana̱”, rnii der zeꞌ wagyicy der gal nu rne̱e̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Benu tub mbecy cyid yu lo̱, nunu gyeñ yu riidz nu rne̱e̱, nunu gyicy yac yuñ, orzeꞌ ya̱ rne̱e̱ lor la nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Orzeꞌ yu zeꞌ nay gal na tub mbecy nu bzaa tub yuꞌ. Gyi bduuñ yu simient niñ. Orzeꞌ bzuub yu simient niñ lo gyitaꞌ. Na ornu bet gyey, orzeꞌ guuly gyoow. Orzeꞌ bdugyiñ ich yuꞌ zeꞌ. Tees wangyes saañ, gun nap byaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tees dela mbecy nu rzuub gyidag coz nu rne̱e̱, zeꞌ wayicy dey gal nu rne̱e̱, de yu zeꞌ nay gal na tub mbecy nu bzaa tub yuꞌ. Zeꞌ ni wansu lay simient niñ. Na ornu bet gyey, orzeꞌ guuly gyoow. Orzeꞌ bdiñ yeeñ yuꞌ zeꞌ. Orzeꞌ wes saañ. Orzeꞌ mnit lo dutuub la yuꞌ zeꞌ ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na ornu blazh mniim lo de mbecy, orzeꞌ zam tub gyedz nu la Capernaum. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Orzeꞌ zeꞌ rcyiiñ tub mbecy nu riib ic tub gaynal soldad Rom. Zeꞌ zu tub moz niy nu dzi rcay. Orzeꞌ moz zeꞌ mbish rat yu. Se nu gat ziꞌl yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na ornu mbecy nu riib ic zeꞌ güeñ yu riidz nu rnii mbecy ni de coz nu ricy Jesuuz, orzeꞌ bzuu nez yu la be yu bel ni de mbecy Israeel nu cha nishbaa dey lo Jesuuz, gun orzeꞌ cham gyicy yac mi moz niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Orzeꞌ de yu bel zeꞌ gua dey mnishbaa dey lo Jesuuz. Orzeꞌ na dey rab yum: ―Yad ñi nir nu locyuub ru mbecy zeꞌ, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","gun dzi rcay de mbecy Israeel. Nunu laab yu bicy yu nu byaa yuꞌ nu rsya̱ꞌ de̱ riidz ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Orzeꞌ Jesuuz za num dey par yuꞌ mbecy nu riib ic zeꞌ. Na ornu bi ya gaab dem zeꞌ nu zub yuꞌy, orzeꞌ yu nu riib ic zeꞌ bzuu nez yu amig niy nu cha nii dey lo Jesuuz. Orzeꞌ na dey rab yu Jesuuz: ―Jesuuz, yu nu riib ic de soldad mniiy nu yap ne̱e̱ lor nu walagy yu gyicy seed yu ru, gun wangyap yu nu char yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nunu ndeꞌ nu ni wancyiid cheel ub yu ru. Nomaas nu nii ziꞌl ru nu gyac moz niy. Orzeꞌ gyac yu nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gun niꞌ yu zeꞌ ricy yu de coz nu rnii de yu nu gya zir zu par ub yu, nay. Nunu niꞌ yuꞌ gaꞌ soldad nu gash zir zu par ub yu, nay. Na ornu niiy lo tub yu nu chay, orzeꞌ chay. Na ornu rbedz yu tuubaꞌy nu chay loy, orzeꞌ rzay. Na ornu rniiy lo moz niy nu gyicy yu tub riiñ niy, orzeꞌ ricy yuñ ―na amig ni yu nu riib ic zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na ornu güeñ Jesuuz de riidz zeꞌ, tonaꞌ la za nu ic mi. Orzeꞌ bish cyam bgüiim lo de mbecy nu za ca ich mi. Orzeꞌ nam rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu lat de mbecy Israeel nigul gyapa̱ ni tub la mbecy nu ricy cup consuel lo̱ gal nu na consuel nu ricy cup yu ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Orzeꞌ de amig zeꞌ niy bish cyay yay. Na ornu bri dey na, orzeꞌ bi byac moz ni yu nu riib ic tub gaynal soldad zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na ornu bded de nu ndeꞌ na, orzeꞌ Jesuuz zam tub gyedz nu la Naíñ. Orzeꞌ de yu nu rsyaꞌ lom, gal nu zigy de mbecy za nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na cuanzir nu brim ruꞌ gyedz na, orzeꞌ bzaac mi nu yad de mbecy nu yad cach dey añ. Añ zeꞌ, yu zeꞌ tub zi lay zuy ni ñaay. Nunu ñaay, mi zeꞌ tub byud. Orzeꞌ zigy mbecy gyedz zeꞌ yad nu dey añ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na ornu Shuaan na bzaac mi, orzeꞌ gushni lagy mim. Orzeꞌ nam rab mim: ―Cueꞌ gun ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Orzeꞌ bechaꞌm lo gyiñ ni añ zeꞌ. Orzeꞌ gul yaam ñii. Orzeꞌ de mbecy nu za nu gyiñ zeꞌ guchuꞌ ri la dey. Orzeꞌ na Jesuuz rab mi añ zeꞌ: ―Yu feñ, ya̱ rne̱e̱ du̱ ru: “¡Wes su!” ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Orzeꞌ mbecy nu gut zeꞌ gusub yu nañ gyiñ zeꞌ. Orzeꞌ brugyiꞌ rniiy. Orzeꞌ Jesuuz byabic mi yu ni ñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Orzeꞌ dela mbecy nu bzaac de ndeꞌ tonaꞌ la gudzib dey. Orzeꞌ brugyiꞌ nu ryabic dey gyel mbecy ni Ñgyoozh. Orzeꞌ na dey: ―Bi bruu zac tub yu lily nu rnii por cuen ni Ñgyoozh lat de ub na ―na dey. Orzeꞌ rnii gaꞌ dey: ―Ñgyoozh yad mi nu locyuub mi de mbecy nim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Orzeꞌ brush las de coz nu bicy Jesuuz par dutuub la lo de yu ni Judea gal nu de lugaar nu yuꞌ gaab ga. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Orzeꞌ mnii de yu nu rsyaꞌ lo Waa nu driib nis mbecy dela coz nu ricy Jesuuz. Orzeꞌ bredz yu cyup de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Orzeꞌ bzuu nez yu de yu zeꞌ nu cha tugyiꞌ dey lo Shuaan na Jesuuz ben a laab mi biñ nu ca lo cuen nu cyid, o ti cuez dey nu cyid reñaꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Orzeꞌ de yu zeꞌ za dey lo Jesuuz. Na ornu bruꞌña dey na, orzeꞌ na dey rab yum: ―Waa nu driib nis mbecy bzuu nez yu de̱ ya̱ nu yap tugyi̱ꞌ lor ben a laab ru biñ nu ca lo cuen nu cyid, o ti lez de̱ nu cyid reñaꞌm ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Orzeꞌ laab or la zeꞌ bicy yac mi zigy mbecy rat. Ricy yac mi mbecy nu rzac zi nu nac güii. Nunu ii rboo chum nuras nu bicy ni mbecy. Nunu ricy mi nu zigy lo caꞌ rzac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gazeꞌ nu lueg la mniim lo cyup yu nu bzuu nez Waa zeꞌ. Orzeꞌ nam: ―Yaa nii der lo Waa dela coz nu bzaac der, gal nu dela coz nu güeñ der. Nii der nu de lo caꞌ bi rzac dey. Zeꞌ de mbecy coj rac rza nap la dey. Zeꞌ de mbecy rat nu taꞌ gyedz nu la lepra bi byac dey. Zeꞌ de mbecy go̱ꞌ bi reñ dey. Nunu de mbecy nu bi gut byabañ dey. Nunu dunii de riidz nu sac ni Ñgyoozh lo de mbecy zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dzi ni mbecy nu wayeca nu ricy cup consuel lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na ornu bi ya de yu zeꞌ na, orzeꞌ Jesuuz bzat mi Waa lo de mbecy zigy. Orzeꞌ nam: ―Ornu gua der gua güiir Waa tub lugaar ub zi, ¿la nay guzii der? ¿O ti guzii der nu nac yu mbecy nu ricy cyup ic, gal nu na tub yagyi nu rguul bi par re par ii la guzii der? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Zeꞌ benu walab, orzeꞌ ¿la na tub mbecy gua güii der? ¿A gua güii der tub mbecy nu zu negy cyit na? Walab, gun rad lagy der nu yu nu zu negy cyit na, nunu zu baay, yu zeꞌ rcyiiñ yu yuꞌ rey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Orzeꞌ la gaal na tub mbecy nu gua güii der? ¿A gua güii der tub yu nu rnii por cuen ni Ñgyoozh? Laab, como ya̱ rne̱e̱ lo der nu gua güii der tub mbecy nu zily zir nac gazeꞌ de yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gun laab Waa rzat riidz ni Ñgyoozh zeꞌ nu rniiñ: Ñgyoozh nam rab mi biñ nu ca lo cuen nu cyid: Ya̱ zuu neza̱ yu nu nii por cuen ne̱ nu cha gay lor, gun orzeꞌ zu lily yu nez nu char, nam. Ni rnii riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gun ya̱ rishli rne̱e̱ lo der nu ni tub la mbecy a̱ꞌ zily zir nac yu gazeꞌ Waa par lo Ñgyoozh. Tees yu nu gash zir zu lat de yu nu gyub ic Ñgyoozh, yu zeꞌ gya zir zuy par Waa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Orzeꞌ dela mbecy mas mbecy nu rboo tiñ por cuen ni gubier Rom, ornu güeñ dey de riidz nu mnii Jesuuz, orzeꞌ mnii dey nu mod nu rlagy Ñgyoozh, ndeꞌ mod nu laab ñi. Gun anzir Waa briic yu nu zu nis dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tees de mbecy Fariseo, gal nu de yu nu rlyuu leey ni Ñgyoozh, wangalagy dey nu ndriib nis Waa dey, ca nu bzu chu dey mod nu rlagy Ñgyoozh nu gyicy num dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Orzeꞌ na gaꞌ Jesuuz: ―¿La ñuu tub coz nu saapa̱ de mbecy nu yuꞌ tiem na? ¿La ñuu na dey? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na dey gal nu na yu nguzh nu nguaa rgyit lat yagyiꞌ. Orzeꞌ ye la rbish ti dey nguaay. Orzeꞌ na dey rab yu losaꞌy: “Bla̱a̱ de̱ di gyel cyit nu bdzi. Tees wangulgyiꞌ der. Na ornu bdulruꞌ de̱ tub di nu shni za, ni wanguun der”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gun de mbecy nu yuꞌ na wangalagy dey ni tub la mod. Gun Waa biid yu wangow nap yu. Nunu wangoꞌy ñup. Orzeꞌ de ru rnii der nu tub nuras bicy niy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Zeꞌ ornu ya̱, biñ nu byac mbecy bri̱, orzeꞌ ya̱ rda̱w la ziꞌl coz, nunu rdo̱ꞌ la ziꞌl ñup. Orzeꞌ rnii der nu naca̱ mbecy row shaad, nunu naca̱ mbecy roꞌ ñup, nunu naca̱ amig ni de mbecy bduneꞌ, nunu naca̱ amig ni de yu nu rboo tiñ por cuen ni gubier Rom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ni tub la mod wangyet lagy der. Tees rabee nu de mod nu psaꞌ lagy Ñgyoozh, ndeꞌ mod nap, nu nac nu gruu nap ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Orzeꞌ tub mbecy fariseo bredz yu Jesuuz nu cha tom gyit yuꞌy. Orzeꞌ guam yuꞌy. Na ornu bi zub mi lo mez na, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","orzeꞌ bruꞌña tub biñ mñaa lom. Orzeꞌ mi zeꞌ tub biñ nu rcyiiñ gyedz zeꞌ, nunu nac mi mbecy a̱ꞌ nap. Orzeꞌ gud lagy mi nu Jesuuz za tom gyit yuꞌ mbecy fariseo zeꞌ. Orzeꞌ bruꞌña num tub bas nu byaa nu gyitaꞌ nu la alabastro. Zeꞌ nañ bas zeꞌ dza laa nu yuꞌ nis zguul. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Orzeꞌ gusub tiily mi yeñ gyiꞌ Jesuuz. Ruun mi. Gazeꞌ nu rcoom nis urlom gyiꞌ Jesuuz. Orzeꞌ gazeꞌ nu rcuiigy mi ñii nu gyich ic mi. Lat zeꞌ pca ruꞌ biñ mñaa zeꞌ gyiꞌm. Orzeꞌ pcoo gaꞌm asecy zguul zeꞌ gyiꞌ Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na ornu mbecy fariseo, yu nu bredz Jesuuz nu guam yuꞌ zeꞌ, bzaac yu de coz nu bicy biñ mñaa zeꞌ, orzeꞌ nay nañ lardooy: “Benu rishli gaal mbecy ii nac yu tub yu nu rnii por cuen ni Ñgyoozh, orzeꞌ gad lagy yu la na biñ mñaa nu gul mi yu. Mi re tub biñ mñaa a̱ꞌ nap”, rnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Orzeꞌ na Jesuuz rab mi mbecy fariseo zeꞌ: ―Simo̱o̱, ya̱ rlagya̱ ne̱e̱ tub coz lor ―nam. Orzeꞌ na mbecy fariseo zeꞌ rab yu Jesuuz: ―Mnii lo̱, masht ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Orzeꞌ na Jesuuz: ―Cyup mbecy zaab yu tiñ ni tub mbecy nu rbic tiñ nu rboo losaꞌ. Tub yu zaab yu gaay gaynal tiñ plat. Zeꞌ tuubaꞌy zaab yu cyaal gaynal tiñ plat. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Orzeꞌ como rup laa dey wangac gyabic yu tiñ zeꞌ, orzeꞌ yu nu rbic tiñ zeꞌ bicy sulagy yu diꞌñ rup laa dey. Na mnii lo̱ Simo̱o̱: ¿ca na de yu zeꞌ rca zir dey yu nu rbic tiñ zeꞌ? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Orzeꞌ na Simo̱o̱: ―Ya̱ rze̱e̱ nu mbecy nu coz ily zir bicy sulagy yu ni zeꞌ, yu zeꞌ rca zir yu yu nu briic tiñ zeꞌ co dey ―nay. Orzeꞌ na Jesuuz rab mi yu: ―Laab ni gal nu mniir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Orzeꞌ lat nu rgüiim lo biñ mñaa zeꞌ, orzeꞌ na Jesuuz rab mi Simo̱o̱: ―¿A rzac ru biñ ii? Ya̱, ornu gu̱ꞌ nañ yuꞌr, orzeꞌ wancuic ru nis nu diba̱ gyi̱ꞌ. Zeꞌ biñ mñaa ii bdiib mi gyi̱ꞌ nu nis urlom, nunu pcuiigy mi ñii nu gyich toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ru ni wanca ruꞌr ya̱, tees biñ mñaa ii nese nu guꞌm nañ yuꞌ ii wanchecam nu rca ruꞌm gyi̱ꞌ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","’Ni wancoor asecy to̱o̱, tees mi ii pcoom asecy zguul gyi̱ꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ndeꞌ nu ya̱ rne̱e̱ lor nu Ñgyoozh gyicy sulagy mi dela cyi zañ nu bicy mi, gun tonaꞌ la rcam ya̱. Tees benu Ñgyoozh gyicy sulagy mi de cyi ñuu zi ni tub mbecy, orzeꞌ yu zeꞌ beñ zi rcay ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Orzeꞌ nam rab mi biñ mñaa zeꞌ: ―Ñgyoozh bi bicy sulagy mi de cyir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Orzeꞌ de yu nu nguaa num lo mez brugyiꞌ nu ro dey riidz nu losaꞌy. Orzeꞌ na dey: ―¿Cyu mbecy yu ii? Mas gashtal cyi mbecy ricy sulagy yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Orzeꞌ nam rab mi biñ mñaa zeꞌ: ―Ru bruu mbañ ru nu nac nu bicy cup ru consuel lo̱. Na yaa nu dub gusht la ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na ornu bded de nu ndeꞌ na, orzeꞌ Jesuuz gusam de gyedz, gal nu de ranch. Orzeꞌ pshaal mi de riidz nu sac ni gyel gubier ni Ñgyoozh. Nunu de trocyup de aposht gusa nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nunu niꞌ la be de biñ mñaa gusa num mi. Lat zeꞌ ri Li nu bruu tub gyedz nu la Magadán. Jesuuz bloo chum gagy nuras lo mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nunu niꞌ ziꞌl ri Wan, mñaa Cuza. Cuza yu zeꞌ yu nu riib ic asunt ni Herodes. Nunu ri gaꞌ Susan lat zeꞌ, gal nu zañ zir biñ mñaa. Orzeꞌ de biñ mñaa zeꞌ rlocyuub dem Jesuuz, gal nu de yu nu rsyaꞌ lom. Rlocyuub dem Jesuuz nu nac de coz nu rad ni dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tonaꞌ la zañ mbecy bruu dey ledz yu za dey lo Jesuuz. Orzeꞌ tonaꞌ la mbecy zigy byatublaazh dey lom. Orzeꞌ brugyiꞌ rniim nu riidz tiily. Orzeꞌ nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tub mbecy bruuy zay za nuuz yu mbigy. Lat nu rtich yu de mbigy zeꞌ, yuꞌñ bet lag ñi ruꞌ gyernez. Orzeꞌ mbecy bded yu bzuub gyiꞌy tooñ. Nunu bruꞌña chigyiñ bdow ma ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zeꞌ yuꞌ gaꞌñ bet lag ñi lo yu las ruꞌ nu ri gyitaꞌ par nañ. Orzeꞌ ornu briib ñi na, orzeꞌ guwach ñi, gun a̱ꞌ lyup lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zeꞌ yuꞌ gaꞌñ bet lag ñi lat gyech. Orzeꞌ gyech tublaazh la guuly ñi nu de ya mni zeꞌ. Orzeꞌ pcyiig ñi de ya mni zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Zeꞌ yuꞌ gaꞌñ bet lag ñi lo yu nap. Briib ñi nunu guuly ñi. Orzeꞌ tonaꞌ la cosech nap briic ñi. Gashtal tub gaynal mbigy briic tub ga mbigy nu bdunuuz ―nam. Orzeꞌ na gaꞌm: ―¡Mbecy nu zub gyidag rlagy ñi gyicy yu nu gyet lag yu cuen! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Orzeꞌ de yu nu rsyaꞌ lom bdugyiꞌ dey lom lac yaruu de riidz tiily zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Gazeꞌ nu nam rab mi dey: ―Ñgyoozh briic mi nu gad lagy de ru de coz ni gyel gubier nim, de coz nu wagad lagy mbecy gulas. Zeꞌ deꞌ zir mbecy ya̱ shaala̱ lo dey nu riidz tiily. Gun orzeꞌ mas zac dey, tees wayuꞌ loy, nunu mas gyeñ dey, tees wayet lag dey cuen ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Orzeꞌ nam: ―Orzeꞌ na ya̱ ne̱e̱ lo der lac yaruu de riidz tiily zeꞌ. Orzeꞌ de mbigy zeꞌ nañ gal na riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Orzeꞌ de mbigy nu bet lag ruꞌ gyernez, ndeꞌ nañ gal nu na mbecy nu reñ de riidz ni gyel gubier ni Ñgyoozh. Rnii mbecy riidz zeꞌ lo dey, tees orzeꞌ druꞌña nuras rbooy de riidz zeꞌ nañ lardoo dey, gun orzeꞌ cueꞌ nu cheña lagy dey niñ. Orzeꞌ cueꞌ nu gruu mbañ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Zeꞌ mbigy nu bet lag lo yu las ruꞌ nu ri gyitaꞌ par nañ, ndeꞌ nañ gal nu na de mbecy nu reñ de riidz zeꞌ. Orzeꞌ lueg la “O” rniiy nunu yet lagy yu. Tees a̱ꞌ fert yu par nu wacshet riidz zeꞌ sheñ lyuñ nañ lardooy. Orzeꞌ la be ziꞌl dzi ragyeey. Tees ornu shuub dzi nu gac preb dey, orzeꞌ wagyee dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zeꞌ de mbigy nu bet lag lat de ya gyech zeꞌ, ndeꞌ nañ gal nu na mbecy nu rzuub gyidag de riidz zeꞌ. Tees como mbecy zeꞌ dzi zuy shcab ni de coz ni gyishlombecy, nunu como rlagy yu gyicy yu gusht niy, orzeꞌ de ndeꞌ rsoow ñi lo de riidz zeꞌ. Orzeꞌ ndeꞌ nu wacuic riidz zeꞌ cosech nañ lardoo mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Zeꞌ de mbigy nu bet lag lo yu nap zeꞌ, ndeꞌ mbecy nu rzuub gyidag de riidz zeꞌ nu lardooy. Orzeꞌ bicy yac dey niñ. Orzeꞌ briic ñi cosech nap nañ lardoo dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Orzeꞌ na gaꞌ Jesuuz: ―Ni tub la mbecy wacaa dey gyi tub candiil nu riiy ñi nañ tub la coz, o nañ tub nuun, sinu zuub dey ñi seꞌñ, gun orzeꞌ cuic ñi yaa lo de yu nu chuꞌ nañ yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Niꞌ ziꞌl rac nu de riidz nu bruu lo Ñgyoozh. Gun dela de riidz ngach nim gyicy mi nu gad lagy de mbecy, nunu dela de riidz nu wagad lagy dey, shaal mi ñii lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Orzeꞌ nap bzuub gyidag der, gun yu nu ricy cup sheñ, sheñ zir gad niy. Zeꞌ yu nu sac ni, gashtal coz miiñ nu rnii tooy nu gyicy cup yu gruuñ niy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Orzeꞌ bruꞌña ñaam, nu de bicy mi. Tees wangac ñgyechaꞌ dey lo Jesuuz, gun dzi yuꞌ mbecy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Orzeꞌ tub mbecy byooy rishlo Jesuuz. Orzeꞌ nay rab yum: ―Ñaar nu de bicy ru yuꞌ dey gashtal ich yuꞌ re, nunu rlagy dey zac yu ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Orzeꞌ na Jesuuz rab mi yu nu byoo rishlom zeꞌ: ―Yu nu reñ de riidz ni Ñgyoozh nunu “O” rniiy nu rzuub gyidag yuñ, orzeꞌ de yu zeꞌ nac dey bicya̱ nu ña̱a̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tub dzi Jesuuz guꞌm nañ tub barc nu de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―Yaa der chan gal naa tub laꞌ gaꞌ dzu ruꞌ nisyudoo ―nam. Orzeꞌ guꞌ dey nañ barc zeꞌ za dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na lat nu za dey na, orzeꞌ Jesuuz gugyit mi nas mi. Orzeꞌ sij la bruꞌña tub gyey bi ily. Orzeꞌ brugyiꞌ nu rzuꞌ nis nañ barc zeꞌ. Orzeꞌ byarishdzidz nañ barc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gazeꞌ nu gua cueeñ dey mi. Orzeꞌ na dey rab yum: ―¡Masht, masht, bi rnit lo den lo nis! ―na dey. Gazeꞌ nu weshtem. Gazeꞌ nu bicy mi mandaar lo bi, nu lo de nguuly lo nis. Orzeꞌ guri bi. Nunu se ri zu la byac. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gazeꞌ nu nam rab mi de yu nu rsyaꞌ lom: ―¿La bzaac der? ¿Lagu wagyicy cup der consuel lo̱? ―nam. Orzeꞌ tonaꞌ la za nu ic dey nunu gudzib dey. Orzeꞌ na dey rab yu losaꞌy: ―¿Zeꞌ cyu mbecy nac mi ii? Mi ii ricy mi mandaar mas gashtal lo bi nu lo nisyudoo, nunu rzuub gyidag ñi nim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Orzeꞌ bri dem tub laꞌ gaꞌ ruꞌ nisyudoo, tub lugaar nu la Gerasa nu ri par lo Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na laab bruu la Jesuuz nañ barc na, orzeꞌ bruu za la tub mbecy yad yu. Bruuy par lat gyedz. Yu zeꞌ tub mbecy nu bicy ni nuras. Orzeꞌ bechaꞌy lo Jesuuz. Nunu dzi bi rac tiem nu wacsuy shab yu. Nunu walab nañ yuꞌ rcyiiñ yu, sinu lat de blyuu nu rcach dey añ rcyiiñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na ornu bzaac yu Jesuuz, orzeꞌ gusu tib yu lom. Orzeꞌ dub ruꞌ la nuras zeꞌ rbish tiy. Gazeꞌ nu nay rab yu Jesuuz: ―¿La ryub ru yad ru lo̱ Jesuuz, iꞌñ Ñgyoozh, biñ nu zily zir nac? ¡Ya̱ rnishba̱a̱ lor nu cueꞌ shet zir ya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ni mniiy, gun Jesuuz mniim lo nuras zeꞌ nu gruchuy lo mbecy zeꞌ. Yad nu tonaꞌ la guzañ ñaꞌn nu ni ricy nuy mbecy zeꞌ. Nunu de mbecy rcyiig dey gyiꞌy nu yaay nu caden. Tees rshiꞌñ rshiꞌñ lay caden. Orzeꞌ nuras zeꞌ ricy yu nu rza mbecy zeꞌ lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Orzeꞌ na Jesuuz rab mi nuras zeꞌ: ―¿La lar? ―nam. Gazeꞌ nu nay rab yum: ―Ya̱ la̱ bee miily ―nay. Ni mniiy gun dzi zigy yu bicy niy mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Orzeꞌ de nuras zeꞌ mnishbaa dey lom nu cueꞌ zeed mi dey zeꞌ nu cow. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gun lugaar zeꞌ rded row tub nac cuch zigy. Orzeꞌ nuras zeꞌ mnishbaa dey lo Jesuuz nu cuic mi rishbeey nu chuꞌ dey nañ de cuch zeꞌ. Orzeꞌ gazeꞌ nu briic mi rishbeey ni dey nu chuꞌ dey nañ de cuch zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gazeꞌ nu bruu chu dey lo mbecy zeꞌ. Orzeꞌ guꞌ dey nañ de cuch zeꞌ. Orzeꞌ de cuch zeꞌ rzab la de ma bzu tiily ma par gyoow. Orzeꞌ bet lag de ma lo nisyudoo. Orzeꞌ gut de ma lo nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Orzeꞌ de yu nu rña de cuch zeꞌ gush dey carer ya niiy de coz nu guc lo de mbecy nu yuꞌ lat gyedz, gal nu lo de mbecy nu yuꞌ ngush. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gazeꞌ nu bruu dey yad güiiy de coz nu guc. Na ornu bruꞌña dey zeꞌ nu zub Jesuuz na, orzeꞌ bzaac dey mbecy nu bicy ni nuras zeꞌ zub yu yeñ gyiꞌm. Zuy shab yu, nunu byanap la shcab niy. Orzeꞌ tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Orzeꞌ dela de mbecy nu bzaac coz nu guc zeꞌ mnii dey lo de mbecy zigy zeꞌ lac mod byac mbecy nu bicy ni nuras zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Orzeꞌ dela de mbecy nu yuꞌ lo yu ni Gerasa brugyiꞌ rnishbaa dey lo Jesuuz nu ruum ledz dey, gun tonaꞌ la rdzib dey lom. Orzeꞌ Jesuuz guꞌm nañ barc zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Orzeꞌ yu nu bicy ni nuras zeꞌ mnishbaay lom nu cha num yu. Orzeꞌ Jesuuz nam rab mi yu: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Yaa lo de famil nir. Orzeꞌ gyoor rishlo dey de coz nu bicy Ñgyoozh num ru ―nam. Orzeꞌ mbecy zeꞌ gush nez yu yay. Byooy rishlo dela mbecy nu yuꞌ gyedz zeꞌ de coz nu bicy Ñgyoozh num yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na ornu Jesuuz bruꞌñam tub laꞌ gaꞌ ruꞌ nisyudoo na, orzeꞌ de mbecy zigy nu yuꞌ zeꞌ tonaꞌ la bet lagy dey ornu bruꞌñam lo dey. Gun dela dey yuꞌ dey rbez yum. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Orzeꞌ bruꞌña tub mbecy nu la Jairo. Yu zeꞌ riib ic yu nañ yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Orzeꞌ gugyit tiily yu yeñ gyiꞌ Jesuuz. Gazeꞌ nu mnishbaay lom nu cham yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gun zu tub zi la iꞌñ yu, tub fiñ mñaa ñaꞌn trocyup. Orzeꞌ fiñ zeꞌ rat ñi. Se nu gat ziꞌl lañ. Orzeꞌ rlagy yu nu gyicy yac mi ñii. Orzeꞌ Jesuuz za num yu, nunu tonaꞌ la mbecy zigy za nu dey mi gal rcyiꞌñ su la dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Orzeꞌ lat de mbecy zeꞌ ri tub biñ mñaa nu bi bzaꞌ trocyup ñaꞌn nu rshu reñ mi. Nunu mniit mi dela tiñ nim lo doctoor, tees ni tub la dey wangac ñgyicy yac dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Orzeꞌ biñ mñaa zeꞌ bechaꞌm par ich Jesuuz. Orzeꞌ gul yaam ruꞌ shab mi. Orzeꞌ laab or la zeꞌ guca reñ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Orzeꞌ Jesuuz nam: ―¿Cyu gul yaa ya̱? ―nam. Orzeꞌ dela mbecy mnii dey nu walab dey gul yaay mi. Orzeꞌ na Bed rab yum: ―Masht, de mbecy dub yub la rcyiꞌñ su dey ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tees Jesuuz bzu fert mi. Orzeꞌ nam: ―Ca zi na mbecy gul yaa ya̱. Gun gud lagya̱, nu nac nu bruu fers ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Orzeꞌ ornu gud lagy biñ mñaa zeꞌ nu wacaꞌ cach lom lo Jesuuz, orzeꞌ za laam gusu tib mi lom. Nunu rash la bis mi. Orzeꞌ mniim lo de mbecy zigy zeꞌ la gyiꞌ nu gul yaam shab Jesuuz. Nunu mnii gaꞌm nu byac mi laab or la zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gazeꞌ nu na Jesuuz rab mi biñ mñaa zeꞌ: ―Biñ mñaa, ru byac ru gun bicy cup ru consuel lo̱. Orzeꞌ dub gusht la yaa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lat nu gabee rnii ruꞌ Jesuuz nu biñ mñaa zeꞌ, orzeꞌ bruꞌña tub mbecy nu biid nu raso̱o̱, yu nu bruu gashtal yuꞌ Jairo, yu nu riib ic zeꞌ. Orzeꞌ nay rab yu Jairo: ―Iꞌñ ru bi guut ñi. Orzeꞌ cueꞌ gaꞌ gyicy seed zir ru masht ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tees Jesuuz güeñ mi nu ni mniiy lo Jairo. Orzeꞌ nam rab mi Jairo: ―Cueꞌ dzib ru. Bicy cup ziꞌl consuel lo̱. Orzeꞌ iꞌñ ru gyac ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na ornu bruꞌñam yuꞌ Jairo na, orzeꞌ wansaanaꞌm nu chuꞌ zir mbecy nañ yuꞌ zeꞌ nu mbish fiñ nguzh zeꞌ. Nomaas guꞌ num Bed nu Santiag, nu Waa, gal nu uz fiñ nguzh zeꞌ gal nu ñaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Orzeꞌ dela mbecy nu nguaa zeꞌ ricy shni dey, nunu ruun dey nu nac fiñ nguzh zeꞌ. Orzeꞌ nam rab mi dey: ―Cueꞌ gun der. Fiñ nguzh ii nu nas ziꞌl ñi. Walab nu guut ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Orzeꞌ brugyiꞌ nu rigy nu ñaañ dey mi, gun gud lagy dey nu gut fiñ nguzh zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Orzeꞌ bduꞌ yaam yaañ. Gazeꞌ nu ye la mniim. Orzeꞌ nam rab mi ñii: ―¡Fiñ nguzh, weshte! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Orzeꞌ byabañ fiñ nguzh zeꞌ. Orzeꞌ lueg la weshteñ. Orzeꞌ Jesuuz bicy mi mandaar nu cuic dey coz nu goñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Orzeꞌ de mbel ni fiñ nguzh zeꞌ za nu la ic dey. Tees Jesuuz bduꞌm riiñ yaa dey nu cueꞌ la nii dey lo ni tub la mbecy de coz nu guc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Orzeꞌ Jesuuz bredz mi trocyup de yu nu rsyaꞌ lom nu gyatublaazh dey lom. Orzeꞌ briic mi rishbeey nu co chu dey nuras, nunu gyicy yac dey mbecy rat. Nunu bicy mi nu cyiiñ dey nu gyicy dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Orzeꞌ bzuu nez mi dey nu cha dey cha shaal yu de riidz ni gyel gubier ni Ñgyoozh, nunu par nu gyicy yac dey de mbecy rat. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Orzeꞌ nam rab mi dey: ―Cueꞌ cha nu der ni tub la coz nu cyiiñ ni der par nez. Cueꞌ cha nu der yangar. Cueꞌ cha nu der moraal. Ni cueꞌ cha nu der gyit. Ni cueꞌ cha nu der tiñ. Shab nu zu ziꞌl der cha nur. Cueꞌ cha nu der reñaꞌ shab ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ca ziꞌl zeꞌ nu chuꞌ der nañ yuꞌ, orzeꞌ zeꞌ cyiiñ der gashtal gruu la der lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ca ziꞌl zeꞌ nu washet ic dey nu chuꞌ der nañ yuꞌ, orzeꞌ ornu gruu der lugaar zeꞌ, orzeꞌ cyib der yu gyedz nu taꞌ gyid lab ru par nu gabe nu a̱ꞌ nap bicy dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Orzeꞌ gush nez dey zay de lugaar nu yuꞌ gaab ga zeꞌ. Pshaal dey riidz ni Ñgyoozh, nunu bicy yac dey de mbecy rat. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Orzeꞌ rey Herodes güeñ yu coz nu guc nu nac Jesuuz. Orzeꞌ tonaꞌ la pcan shcab niy. Gun yuꞌ mbecy nu rniiy nu Waa nu driib nis mbecy byabañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Zeꞌ yuꞌ gaꞌy rniiy nu yu zeꞌ Elías, yu nu mnii por cuen ni Ñgyoozh. Zeꞌ yuꞌ gaꞌ dey rniiy nu yu zeꞌ ca zi na de yu nu mnii por cuen ni Ñgyoozh nu guꞌ gulas. Na byabañ yu, rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tees Herodes nay: ―Gunca laab ya̱ bicya̱ mandaar nu pcyug dey too Waa. ¿Zeꞌ cyu mbecy nac yu zeꞌ beni? Ya̱ reña̱ nu rnii mbecy zañ coz nu ricy yu ―nay. Ndeꞌ nu Herodes byub yu zañ mod nu gac zac yu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na ornu bi bri de yu nu rsyaꞌ lom na, orzeꞌ mnii dey lom de coz nu bicy dey. Gazeꞌ nu gua nu reñ mi dey tub gyedz nu la Betsaida. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na ornu gud lagy de mbecy zigy na, orzeꞌ za ca dey ich mi. Orzeꞌ Jesuuz pcueez mi dey. Orzeꞌ mniim riidz ni gyel gubier ni Ñgyoozh lo dey. Nunu bicy yac mi zañ mbecy rat. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na ornu bi rdze na, orzeꞌ de trocyup de yu nu rsyaꞌ lom bechaꞌ dey lom. Orzeꞌ na dey rab yum: ―Bzuu nez de mbecy ii nu cha yub dey posad niy, nunu cha yub dey coz nu goy. Cha dey de gyedz gal nu de ranch nu yuꞌ gaab ga ii, gun ii tub lugaar ub zi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Orzeꞌ na Jesuuz rab mi dey: ―Briic de ru coz nu gow dey ―nam. Orzeꞌ na dey rab yum: ―A̱ꞌ ricy cup de̱ sheñ. Nomaas ricy cup de̱ gaay zi gyishtily nu cyup bel. ¿A rlagy ru nu cha̱ zi̱ zir de̱ de coz nu gow dey? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gun nac gaay miily de mbecy zeꞌ. Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Mnii der lo de mbecy nu gzub dey bee cyaal gaynal ga dey tub ga seꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Orzeꞌ ni bicy dey. Orzeꞌ de mbecy gucua dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Orzeꞌ bduꞌ yaam gaay gyishtily zeꞌ nu cyup bel zeꞌ. Orzeꞌ bgüiim par baa nunu briic mi gras ni Ñgyoozh nu nac ñii. Gazeꞌ nu blew mi ñii. Nunu briicaꞌm ñii ni de yu nu rsyaꞌ lom nu cyez dey ni de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Orzeꞌ dela mbecy bdow gyel la dey. Nunu ii pteꞌ dey trocyup ruꞌ chicyiw de coz nguzh nu brusub zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tub dzi bzub Jesuuz ub zi lam mnii num Ñgyoozh. Nomaas de yu nu rsyaꞌ lom yuꞌ nu dey mi. Orzeꞌ nam rab mi dey: ―¿Cyu rnii mbecy nu nac ya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Orzeꞌ na dey: ―Yuꞌ mbecy nu rniiy nu ru Waa nu driib nis mbecy. Zeꞌ yuꞌ gaꞌ dey rniiy nu ru Elías. Zeꞌ yuꞌ gaꞌ dey rniiy nu ru tub yu nu mnii por cuen ni Ñgyoozh gulas. Zeꞌ na byabañ yu, rnii dey ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Orzeꞌ nam rab mi dey: ―Zeꞌ de ru, ¿cyu rnii der nu naca̱? ―nam. Orzeꞌ na Bed rab yum: ―Ru nac ru Mesías, biñ nu bzuu nez Ñgyoozh nu cyid ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tees Jesuuz tonaꞌ la nap bduꞌm riiñ yaa dey nu cueꞌ nii dey de riidz zeꞌ lo ni tub la mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gazeꞌ nu nam rab mi dey: ―Ya̱, biñ nu byac mbecy, rlagy ñi nu zac zi̱ zañ lo coz deet. Nunu de yu bel ni de mbecy Israeel, nu de uz zub lo, nu de yu nu rlyuu leey ni Ñgyoozh gneꞌ dey ya̱. Orzeꞌ cut mbecy ya̱. Orzeꞌ dzi chon, orzeꞌ gyabaña̱ ―nam rab mi de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Orzeꞌ na Jesuuz rab mi dela mbecy: ―Benu ca na mbecy rlagy yu nu gac yu mbecy nu rsyaꞌ lo̱, orzeꞌ rlagy ñi nu cueꞌ gyicy cuen yu coz nu rlagy ub yu. Nunu rlagy ñi nu shet ic yu nu zac ziy de dzi la nu nac ya̱. Orzeꞌ rlagy ñi nu gyicy yu gal nu rlagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gun yu nu rlagy co nap ub, yu zeꞌ gnit loy. Tees yu nu nit lo nu nac ya̱, yu zeꞌ yu nu rishli gruu mbañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Gun la rusub ni mbecy, benu gyicy yu gan dela coz ni gyishlombecy, zeꞌ ub yu gnit loy? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tees cyu ziꞌl mbecy nu gat lo nu nac ya̱, nunu gat loo gaꞌy nu nac de riidz nu rne̱e̱ lo dey, orzeꞌ niꞌ ya̱, biñ nu byac mbecy, gat lo̱ nu nac de yu zeꞌ, ornu shuub dzi nu yapa̱ nu gyel lily ne̱, gal nu gyel lily ni Ñgyoozh uza̱, gal nu gyel lily ni de anc yon. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gun ya̱ rishli rne̱e̱ lo der nu la be de mbecy nu yuꞌ lat der ii na wat dey gashtal zac la dey gyel lily ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na ornu bded shuñ dzi na, orzeꞌ Jesuuz gua nu reñ mi Bed, nu Santiag, nu Waa. Orzeꞌ gup mi num dey too tub bicy nu nii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na lat nu rnii num Ñgyoozh na, orzeꞌ bdza nu na lom. Nunu shab mi byacaacy ñi. Ryal lañ tantaꞌ nu caacy ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Orzeꞌ sij la bruu zac cyup mbecy bee nu dey mi riidz. De yu zeꞌ Moisees gal nu Elías. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nunu bzu yaa lo dela dey. Orzeꞌ bee nu dey Jesuuz riidz nu lac mod gat mi Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Orzeꞌ lat zeꞌ Bed nu deꞌ zir de losaꞌy gush pcaal dey. Tees orzeꞌ briish dey yaa. Nunu bzaac dey gyel lily ni Jesuuz gal nu cyup de yu nu yuꞌ num zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ornu bruu chu cyup de yu zeꞌ lo Jesuuz, orzeꞌ Bed nay rab yum: ―¡Masht, dzi ga nap nu yu̱ꞌ de̱ ii! Na za̱a̱ de̱ chon ramad ni der: tub par ru, tuubaꞌ par Moisees, nu tuubaꞌ par Elías ―nay. Gun Bed wangad lagy yu la coz niiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na lat nu rniiy na, orzeꞌ bruu zac tub za. Orzeꞌ psoow ñi dey. Orzeꞌ tonaꞌ la gudzib dey ornu psoow za zeꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Orzeꞌ lat za zeꞌ zaab tiꞌ mbecy nu rnii. Orzeꞌ nam: ―Mi ii iꞌña̱ nu bzu chu̱. Bzuub gyidag der nim ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na ornu bi bded nu güeñ dey nu mnii mbecy zeꞌ na, orzeꞌ bzaac dey Jesuuz ub zi lam zum. Orzeꞌ guchuꞌ ri la dey. Orzeꞌ wanii la dey lo ni tub la mbecy de coz nu bzaac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na or bzaꞌ yu tuubaꞌ dzi na, orzeꞌ bruum par too bicy, bet mi par gyiꞌ. Orzeꞌ bruu zac zigy mbecy nu gua cheel dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Orzeꞌ lat de mbecy zigy zeꞌ ri tub mbecy. Orzeꞌ ye la rbish tiy. Orzeꞌ nay: ―Masht, gyicy ru tub faboor nur ya̱ nu güiir iꞌña̱, gun tub zi yu ii ne̱ zuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Gun nuras rguꞌ yaay yu, nunu ricy yu nu rbish tiy. Nunu ii ricy yu nu ricy ñi bi niy. Nunu driib bdziñ ruꞌy. Tonaꞌ la shiñ ricy nuy yu, nunu walagy yu nu ruu chuy loy ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya̱ mnishba̱a̱ lo de yu nu rsyaꞌ lor nu co chu dey yu, tees wangac ni dey ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Orzeꞌ na Jesuuz rab mi dey: ―¡A der mbecy nu yuꞌ na! ¡Dzi ga wagyicy cup der consuel lo̱! ¡Dzi ga mnu shcab ni der! ¿Laꞌ zir be tiem rlagy ñi nu chesa̱ du̱ der? ¿Laꞌ zir be tiem rlagy ñi nu gagye̱ lo der? ―nam. Gazeꞌ nu nam rab mi uz yu nguzh zeꞌ: ―Da nu yu nguzh nir lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na ornu yu nguzh zeꞌ zay lo Jesuuz na, orzeꞌ nuras zeꞌ mneꞌy yu nguzh zeꞌ lo yu. Orzeꞌ bicy yu nu ricyaꞌñ bi niy. Tees Jesuuz bdzaꞌm ni nuras zeꞌ. Orzeꞌ bicy yac mi yu nguzh zeꞌ. Orzeꞌ byabic mi yu ni uz yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Orzeꞌ dela mbecy tonaꞌ la za nu ic dey nu nac de coz ily nu ricy Ñgyoozh. Lat nu yuꞌ dey za nu ic yu nu nac de coz nu bicy mi, orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Bzuub gyidag der coz nu ne̱e̱ lo der, nunu cueꞌ nit lagy der ñii. Ya̱, biñ nu byac mbecy, guꞌ dey ya̱ yaa de mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tees de yu zeꞌ wangyet lag dey cuen de coz nu mniim. Gun Ñgyoozh wansaan mi nu ñgyet lag dey cuen. Nunu gudzib dey nu ñgugyiꞌy lom lac yaruu de riidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na de yu nu rsyaꞌ lom brugyiꞌ nu ro zi dey riidz ben ca na dey gyac yu yu nu gya zir zu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Na ornu gud lagy Jesuuz nu ni mnii dey na, orzeꞌ bduꞌ yaam tub yu nguzh bzum yu lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Orzeꞌ nam rab mi dey: ―Cyu ziꞌl yu nu shet ic nu gac tub mbecy nu na gal nu na yu nguzh ii nu nac ya̱, orzeꞌ niꞌ ziꞌl shet ic yu nu gac nuy ya̱. Nunu yu nu shet ic nu gac nu ya̱, walab ne̱ ya̱ ziꞌl shet ic yu nu gac nuy, sinu niꞌ ziꞌl shet ic yu nu gac nuy Ñgyoozh, biñ nu bzuu nez ya̱. Gun mbecy nu gash zir zu lat de ru, yu zeꞌ yu nu ricy zir ñi presis ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Orzeꞌ na Waa rab yum: ―Masht, de̱ ya̱ bzaac de̱ tub mbecy nu bloo chuy nuras nu nac rishbeey nu bruu lor, tees mne̱e̱ de̱ nu cueꞌ nu ni gyicy yu, gun wachesa nuy de ub na ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Orzeꞌ na Jesuuz rab mi yu: ―Cueꞌ ca der niy, gun yu nu wacha contr nin, yu zeꞌ yu nu rza faboor nin ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na ornu bi rgaab nu shuub dzi nu chup Jesuuz gyibaa, orzeꞌ Jesuuz bi zuu lam ca na nu zum. Orzeꞌ gush nez mi zam par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Orzeꞌ bzuu nez mi mbecy nu cha ga dey lom nu cha nu dey raso̱o̱ tub lugaar ni Samaria. Gun orzeꞌ gzu lily dey ornu grim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tees de mbecy Samaria wangalagy dey nu cuez mi lat dey, gun gud lagy dey nu par Jerusaleeng rsaap mi nu zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na ornu bzaac Santiag nu Waa nu ni ricy dey na, orzeꞌ na dey: ―Shuaana̱, ¿a walagy ru gyicy na mandaar nu gyet gyi nu gruuñ baa, gun orzeꞌ gnit loñ de yu zeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Orzeꞌ bish cya Jesuuz bdzaꞌm ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Orzeꞌ lueg la za dey tuubaꞌ gyedz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na lat nu zaab za dem nez na, orzeꞌ na tub mbecy rab yum: ―Shuaana̱, ya̱ rlagya̱ cha du̱ ru ca ziꞌl zeꞌ nu char ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Orzeꞌ na gaꞌ Jesuuz rab mi yu: ―De bez ricy cup ma blyuu ni ma. Zeꞌ de chigyiñ ricy cup ma teez ma. Tees ya̱, biñ nu byac mbecy, a̱ꞌ ricy cupa̱ ni tub lugaar miꞌ par nu gabisha̱ zu lagya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Orzeꞌ Jesuuz nam rab mi tuubaꞌy: ―Da ca icha̱ ―nam. Orzeꞌ yu zeꞌ nay rab yum: ―Shuaana̱, ¿a wazaan ru leza̱ gashtal gat uza̱? Orzeꞌ gazeꞌ nu cha ca̱ ich ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Orzeꞌ na Jesuuz rab mi yu: ―Bzaan ndeꞌ par de mbecy nu na gal nu na mbecy gut nu cach dey losaꞌ gut yu. Zeꞌ ru char cha shaal ru riidz ni gyel gubier ni Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Orzeꞌ tuubaꞌy nay rab yum: ―Shuaana̱, ya̱ rlagya̱ cha ca̱ ich ru. Nomaas ¿a wazaan ru nu gya̱ yu̱ꞌ gya̱ ne̱e̱ du̱ de famil ne̱ ñgyoozh? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Orzeꞌ na Jesuuz rab mi yu: ―Yu nu bi driib yaa ich yaa arad, zeꞌ despuees cush cyay güiiy par ich yu, orzeꞌ yu zeꞌ wac chuꞌy zeꞌ nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na despuees ni de nu ndeꞌ na, orzeꞌ Shuaan na Jesuuz pcuim setent zub cyup mbecy. Orzeꞌ bzuu nez mi dey nu cha ga dey lom cyup ga dey tub ga gyedz o tub ga lugaar, zeꞌ nu rlagy ñi nu cham. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Orzeꞌ nam rab mi dey: ―De mbecy nu yuꞌ ii na na dey gal na tub cosech. Rishli cosech tonaꞌ la sheñ ñi. Tees de mbecy nu gyicy riiñ loñ ñuu zi dey. Ndeꞌ nu bdiiñ der lo Ñgyoozh Shuaan cosech zeꞌ nu gzeed zir mi de mbecy nu teꞌ cosech zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Orzeꞌ gua der. Na der gal nu na shily nu zuu neza̱ nu cha lat lob. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Cueꞌ cha nu der gyish gyit nir, nunu cueꞌ cha nu der bay tiñ nir. Ni cueꞌ cha nu reñ der gyid lab ru. Nu ca gyiꞌ ziꞌl der cha nur. Nunu cueꞌ chi glaa der nez nu nii nur losaꞌr ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na ornu chuꞌ der nañ tub yuꞌ, orzeꞌ nii nur de mbecy zeꞌ ñgyoozh. Orzeꞌ nii der: “Ñgyoozh zeed mi gyel ri zu lat der”, niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Benu nañ yuꞌ zeꞌ rcyiiñ mbecy nu wagyet lagy gyel yuu, orzeꞌ gyuꞌ niñ gal nu mnii der. Tees benu walab ni, orzeꞌ wayuꞌ niñ gal nu mnii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Orzeꞌ laab yuꞌ la zeꞌ gri der. Orzeꞌ la ziꞌl coz nu yuꞌ ni de mbecy nu yuꞌ zeꞌ gow der nunu goꞌ der. Gun yu nu ricy riiñ yad ñi niy nu gyad iy. Nunu cueꞌ gri der reñ reñ la yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na ornu gruꞌña der tub gyedz zeꞌ nu shet ic dey nu cyiiñ der na, orzeꞌ gow der la ziꞌl coz nu cuic dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Orzeꞌ gyicy yac der de mbecy rat nu yuꞌ zeꞌ. Orzeꞌ nii der lo dey: “Sñuu ga cyid gyel gubier ni Ñgyoozh lat der”, nii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Zeꞌ benu gruꞌña der tub gyedz zeꞌ nu washet ic dey nu cyiiñ ru, orzeꞌ cha der lat cay. Orzeꞌ nii der: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Mas gashtal de yu gyedz nu yuꞌ gyedz ni der nu taꞌ gyid lab de̱ dib de̱ ñii par nu gabe nu a̱ꞌ nap bicy der! Tees nap gad lagy der nu sñuu ga cyid gyel gubier ni Ñgyoozh lat der”, niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya̱ ne̱e̱ lo der nu ornu shuub dzi nu gri bee Ñgyoozh ni dela mbecy, dzi zir cashtig ily cuic mi ni de mbecy gyedz zeꞌ gazeꞌ ni de mbecy Sodoma. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Cuaa de ru mbecy gyedz Corazín! ¡Nunu cuaa gaꞌ de ru mbecy Betsaida! Gun benu ñgyicy ya̱ nusuriidz lat de mbecy nu yuꞌ gyedz Tiro nu lat de mbecy nu yuꞌ gyedz Sidón gal nu bicya̱ lat de ru, orzeꞌ bi gulas mneꞌ dey de cyi nu ricy yu. Orzeꞌ nzu dey shab cuiñ yu, nunu ncoo dey diꞌñ tooy par nu gabe nu ñgyac dey mbecy shni. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tees ya̱ rne̱e̱ lo der ornu shuub dzi nu gri bee Ñgyoozh ni de mbecy, cashtig ily zir cuic mi ni de ru gazeꞌ ni de mbecy nu yuꞌ gyedz Tiro nu Sidón. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Zeꞌ de ru mbecy gyedz Capernaum, ¿a rlagy der chup der gal gyibaa? Tees gyet lag der gal zeꞌ nu blaazhaꞌ zir gyi ni gabily. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Yu nu rzuub gyidag ni de ru niꞌ ziꞌl rzuub gyidag yu ne̱ ya̱. Nunu yu nu rzu chu de ru niꞌ ziꞌl rzu chuy ya̱. Nunu yu nu rzu chu ya̱, niꞌ ziꞌl rzu chuy Ñgyoozh, biñ nu bzuu nez ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Orzeꞌ setent zub cyup mbecy zeꞌ gua dey riiñ. Na ornu bish cya dey na, orzeꞌ tonaꞌ la bet lagy dey. Orzeꞌ na dey: ―¡Shuaan de̱, gashtal de nuras rzuub gyidag yu ni de̱ ornu rne̱e̱ du̱ de̱ yu nu nac ru! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Orzeꞌ na Jesuuz: ―Tees ya̱ bzaaca̱ nuras nu nay gal nu na tub gyi ni guzii nu bruuy gyibaa bet lag yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ya̱ bicya̱ nu de ru cyiiñ der nu zar too bily nu too gune, nunu se la la zac der. Nunu bicya̱ nu gyicy der gan dela losaꞌ yuur mas tonaꞌ la fert yu. Nunu se la la coz zac der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Orzeꞌ cueꞌ gyet lagy der nu nac nu rzuub gyidag de nuras ni der, sinu bet zir lagy der gun bi ca nu la der lat de mbecy nu bi ya gyibaa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Laab or la zeꞌ Jesuuz tonaꞌ la yet lagy mi nu nac Espiriit Yon ni Ñgyoozh. Orzeꞌ nam: ―Ñgyoozh uza̱, biñ nu nac Shuaan gyibaa gal nu gyishlombecy, ya̱ drica̱ gras nir gun ru bicy ru nu gad lagy de yu nu na gal nu na mdoo de coz nu pcach ru lo de yu nu yuꞌ shcab ni, nu lo de yu nu yet lag cuen. Ni bicy ru gun ndeꞌ coz nu rlagy ru ―nam rab mi Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Orzeꞌ nam: ―Ñgyoozh uza̱ bduꞌm riiñ ya̱a̱ nu gyub ica̱ dela coz. Nunu ni tub la mbecy wad lagy yu cyu ya̱, iꞌñ Ñgyoozh. Nomaas Ñgyoozh uza̱, mi zeꞌ rad lagy mi. Nunu niꞌ ziꞌl wagad lagy dey cyu nac Ñgyoozh, uza̱. Nomaas ya̱ iꞌñ mi rad lagya̱. Nunu niꞌ ziꞌl de mbecy nu rica̱ nu gad lagy cyu nac mi, de yu zeꞌ gad lagy dey cyu nac mi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Orzeꞌ gazeꞌ nu bish cyam lo de yu nu rsyaꞌ lom. Orzeꞌ mnii gareñ lam lo dey. Orzeꞌ nam: ―Dzi ni de mbecy nu zac dela coz nu de ru rzac ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gun zigy de mbecy nu mnii por cuen ni Ñgyoozh, gal nu zigy de rey ngulagy dey nzac yu de coz nu de ru rzac ru, tees wansac dey. Nunu ngulagy dey ñgyeñ yu de coz nu reñ de ru, tees wangyeñ dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Orzeꞌ tub mbecy nu rlyuu leey ni Ñgyoozh gua niiy lo Jesuuz ben a wad tub mod nu riib yu cyi ic mi. Orzeꞌ nay rab yum: ―Masht, ¿lac mod rlagy ñi gyicya̱ par nu gad nu cui mbaña̱ tub la? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Orzeꞌ Jesuuz nam rab mi yu: ―¿La coz ca lo leey ni Moisees? ¿Lac mod yaruu leey zeꞌ rziir? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Orzeꞌ na mbecy zeꞌ rab yum: ―Pca Shuaan ru, biñ nu nac Ñgyoozh nir, nu dutuub la lardoor nu dela gyel mbañ nir, nu dela fers nir, gal nu dela shcab nir. Nunu pca losaꞌr gal nu rcar ub ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Orzeꞌ na Jesuuz rab mi yu: ―Nap rnii ru. Benu ni gyicy ru, orzeꞌ gad nu cui mbañ ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Orzeꞌ mbecy zeꞌ, como rlagy yu gyicy yu nu gabe nu nap yu par lo Ñgyoozh, orzeꞌ nay rab yu Jesuuz: ―¿Cyu nac losa̱ꞌ? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Orzeꞌ na Jesuuz rab mi yu: ―Bzu tub mbecy. Orzeꞌ bruuy gyedz Jericó yay par Jerusaleeng. Orzeꞌ nez nu yay bdzeel yu gubaan. Orzeꞌ de gubaan zeꞌ bgo la dey tooy. Orzeꞌ bloo dey dela suuy. Dela shab yu, dela bloo dey. Gazeꞌ nu bdi su dey yu. Orzeꞌ gazeꞌ nu ya dey. Se nu gat ziꞌl yu bzeeñ de gubaan zeꞌ ya dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Zeꞌ yad nu laab ziꞌl nez zeꞌ bded tub uz. Tees ornu bzaac yu mbecy nu mbish zeꞌ, orzeꞌ zet byach yu zeꞌ nu mbish mbecy nu guud güii zeꞌ. Orzeꞌ yaa lay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Orzeꞌ niꞌ ziꞌl bruꞌña tub mbecy nez Leví lugaar zeꞌ. Niꞌ yu zeꞌ nac yu tub yu nu ricy riiñ nañ yuꞌ nu driib zily mbecy Ñgyoozh. Na ornu bzaac yu mbecy nu mbish zeꞌ, orzeꞌ zetaꞌ byach yu zeꞌ nu mbish yu zeꞌ. Orzeꞌ yaa gaꞌ lay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tees ornu bded tub mbecy Samaria nez zeꞌ, orzeꞌ bzaac yu nu mbish mbecy zeꞌ. Orzeꞌ gushni lagy yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Orzeꞌ bechaꞌy lo mbecy zeꞌ. Gazeꞌ nu bicy nuy mbecy zeꞌ guñaa. Orzeꞌ briily yu asecy nu ñup ni urbyay zeꞌ nu guud güii ni mbecy zeꞌ. Gazeꞌ nu ptiish yu negy zeꞌ nu guud güii ni mbecy zeꞌ. Orzeꞌ briib yu mbecy zeꞌ ich bañcyug niy. Orzeꞌ ya nuy yu nañ tub yuꞌ, zeꞌ nu rgyiiñ mbecy posad. Orzeꞌ laab yu bgüiiy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na tuubaꞌ dzi na, orzeꞌ mbecy Samaria zeꞌ blooy cyup tiñ briic yu ni shuaan yuꞌ zeꞌ. Orzeꞌ nay rab yuy: “Nap ziꞌl güiir mbecy ii. Nunu benu gyicy zir yu gasht, orzeꞌ ya̱ risha̱ ornu cush cya̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zeꞌ orzeꞌ na, ¿ca na lo chon de mbecy zeꞌ bicy nuy yu nu guud güii zeꞌ gal mod nu rlagy ñi nu gyicy mbecy nu losaꞌy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Orzeꞌ na yu nu rlyuu leey zeꞌ rab yu Jesuuz: ―Yu nu gushni lagy mbecy nu guud güii zeꞌ ―nay. Orzeꞌ na Jesuuz rab mi yu: ―Orzeꞌ gua nunu niꞌ ziꞌl gyicy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Orzeꞌ ya Jesuuz. Gazeꞌ nu bruꞌñam tub gyedz. Gyedz zeꞌ rcyiiñ tub fiñ mñaa nu la Mart. Orzeꞌ mniiñ lo Jesuuz nu chuꞌm nañ yuꞌ niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Zeꞌ bily ñii lañ Li. Orzeꞌ gusub ñi yeñ gyiꞌ Jesuuz par nu zuub gyidag ñi de riidz nu rlyuum. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Orzeꞌ Mart rchaꞌ ic ñi nu nac nu dzi yuꞌ riiñ ricy ñi. Orzeꞌ bechaꞌñ lo Jesuuz. Orzeꞌ nañ: ―Shuaana̱, ¿a wagyicy cuen ru nu bilya̱ dela riiñ bzeeñ ñi nu gyicya̱ ub zi̱? Mnii loñ nu locyuub ñi ya̱ ―naañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Orzeꞌ na Jesuuz rab mi Mart: ―Mart, Mart tonaꞌ la rsug ic ru nunu deet rac nañ lardoor nu nac zañ coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tees tub zi coz nu ricy ñi presis. Zeꞌ Li pcuiñ tub coz nu nap zir par nu gyicy ñi. Nunu se cyu la gac co niñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tub tir Jesuuz zub mi rnii num Ñgyoozh tub lugaar. Na ornu blazh mnii num Ñgyoozh na, orzeꞌ na tub yu nu rsyaꞌ lom: ―Shuaan de̱, blyuu ne̱ de̱ lac mod ne̱e̱ du̱ de̱ Ñgyoozh gal nu Waa blyuuy ni de yu nu rsyaꞌ loy ―nay rab yum. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Orzeꞌ Jesuuz nam rab mi yu: ―Ornu nii nu der Ñgyoozh, orzeꞌ i mod nii der: Ñgyoozh, uz de̱, rlagy ñi ca lagy de̱ lor. De̱ ya̱ rdiñ de̱ nu cyid gyel gubier nir lat de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tub dzi ga cuic ru de coz nu rlagy ñi nu da̱w de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bicy sulagy ne̱ de̱ ni de coz cyi nu ricy de̱, gal nu de̱ ya̱ ricy sulagyaꞌ de̱ ni de yu nu shiñ ricy nu de̱ ya̱. Nunu cueꞌ zaan ru nu gyet lag de̱ lo preb ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Gyicy peen zu tub amig ni ca na de ru. Orzeꞌ char loy tub guzeel rel. Orzeꞌ niir loy: “¿A zu ru? Ya̱ yapa̱ lor ben a sac chon gyishtily nir cuic ru lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gun saa la bri tub amig ne̱ nu guay byaj. Zeꞌ ya̱ rila sac coz ne̱ nu rica̱ gow yu”, niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Orzeꞌ amig zeꞌ nir nii gaꞌy gab yu ru gal ri ziꞌl yu nañ yuꞌ. Orzeꞌ niiy: “Cueꞌ gyicy seed ru ya̱, gun roꞌ ne̱ noow ñi, nunu ya̱ nu de yu nguzh ne̱ bi rib das de̱ lo nuun. Ndeꞌ nu wayeshte̱ nu rica̱ la coz nir”, niiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Orzeꞌ ya̱ ne̱e̱ lor nu mas wayeshtey nu cuic yu coz nu rlagy ru par nu nac yu amig nir, tees ca ni gaal cuic yu dela coz nu cyiiñ nir nu nac nu zaab rgyiiñ lar loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ndeꞌ nu ya̱ rne̱e̱ lo der: Bdiiñ der lo Ñgyoozh, gun Ñgyoozh cuic mi de coz nu cyiiñ ni der. Byub der ñii, gun orzeꞌ gyad ñi ni der. Mnii nu der mi, gun orzeꞌ shaal mi roꞌ ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gun cyu ziꞌl mbecy nu rgyiiñ gad ñi niy. Nunu cyu ziꞌl mbecy nu ryub gyad yuñ. Nunu cyu ziꞌl mbecy nu rnii num shaal mi roꞌ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Walab gaal grusu tub mbecy lat der nu cuic yu tub bily ni iꞌñ yu ornu rgyiiñ yu tub bel loy? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ¿walab gaal grusu tub mbecy nu cuic yu tub gune ni iꞌñ yu ornu rgyiiñ yu nguu gyid loy? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gunca de ru nac der mbecy a̱ꞌ nap rad lagy der lac mod rbic ru coz nap ni iꞌñ ru, zeꞌ yegar Ñgyoozh, uz den, biñ nu zub gyibaa, wabic mi Espiriit Yon ni de yu rgyiiñ lom ―na Jesuuz rab mi de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tub tiem Jesuuz bloo chum nuras, gun nuras zeꞌ bicy yu nu byagop tub mbecy. Na ornu nuras bruu chuy lo yu nu byagop zeꞌ, orzeꞌ yu zeꞌ brugyiꞌ rniiy. Orzeꞌ de mbecy nu yuꞌ zeꞌ za nu la ic dey nu nac ndeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Zeꞌ yuꞌ gaꞌ mbecy nu rniiy: ―Beelzebé, yu nu riib ic de nuras, yu zeꞌ bicy yu nu cyiiñ yu ii nu co chuy deꞌ zir de nuras ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Zeꞌ yuꞌ gaꞌ mbecy nu byub yu tub mod par nu gyicy yu nu gadzam. Mniiy lom nu cuic mi tub muesht baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tees gud lagy mi de coz nu rnii too dey. Orzeꞌ nam rab mi dey: ―Benu tub nac mbecy dulew dey nu chucooy laab nu losaꞌ ziꞌl yu, orzeꞌ rila wazu dey. Nunu benu tub famil chucooy laab nu losaꞌ ziꞌl yu, orzeꞌ niꞌ ziꞌl wazu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nunu benu de nuras dulew yu nunu chucoo dey laab nu losaꞌ ziꞌl yu, orzeꞌ niꞌ ziꞌl wazu dey, sinu nit lo dey. Ni rne̱e̱ gun de ru rnii der nu ya̱ rlo̱o̱ chu̱ nuras nu nac rishbeey ni Beelzebé, yu nu riib ic de nuras. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tees benu ni, orzeꞌ cyu briic rishbeey ni de losaꞌr nu ni ricy yu. Ndeꞌ nu de losaꞌr ricy dey nu rabee nu radza der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gun benu ya̱ gac loo chu̱ nuras nu nac coz ily nu ricy Ñgyoozh nu nac ya̱, orzeꞌ ndeꞌ yaruuñ nu bi bri gyel gubier ni Ñgyoozh lat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Gun benu tub mbecy fert zu tañ yu nu rñay yuꞌy, orzeꞌ de coz nu yuꞌ choow nañ yuꞌy nguaa segur ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tees benu ruꞌña tuubaꞌ mbecy nu fert zir, orzeꞌ yu zeꞌ gyicy yu gan yu. Orzeꞌ coy dela gyiib dañ nu rgyish loy lo zeꞌ. Nunu gyash yu dela coz nu ricy cup yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Gun yu nu waya faboor ne̱, yu zeꞌ zay contr ne̱. Nunu yu nu walocyuub ya̱ nu te̱ꞌ de mbecy, yu zeꞌ tush las yu dey ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’De ru na der gal na tub mbecy ornu druu chu nuras loy. Orzeꞌ nuras zeꞌ rzay tub lugaar wach. Rded yu ryub yu tub lugaar zeꞌ nu zu lagy yu. Na ornu wagad lugaar zeꞌ, orzeꞌ rnii tooy: “Nap zir cush cyan laabaꞌ zeꞌ nu bruun”, rnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na ornu griy na, orzeꞌ gyap yu mbecy zeꞌ nay gal nu na tub yuꞌ nu nat laa nañ. Nunu se cyudz la zu nañ ñi nu bdulyuub. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Orzeꞌ chay nu cha teꞌy tub gagyaꞌ nuras nu shiñ zir ricy gazeꞌ ub yu. Orzeꞌ chuꞌ dey nañ mbecy zeꞌ cyiiñ yu. Orzeꞌ mbecy zeꞌ yashiñ zir na mod nu nay gazeꞌ nu loga ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lat nu mnii Jesuuz de riidz zeꞌ, orzeꞌ bruu zac tub biñ mñaa lat de mbecy zigy zeꞌ. Orzeꞌ nam rab mi Jesuuz: ―¡Dzi ni biñ mñaa, biñ nu bgaal ru, nunu briic mi nu gugy ru! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Orzeꞌ na Jesuuz: ―¡Dzi zir dzi ni mbecy benu zuub gyidag yu de coz nu rnii Ñgyoozh nunu gyicy yac yu niñ! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na lat nu rdeꞌ de mbecy zigy lo Jesuuz na, orzeꞌ brugyiꞌ rniim lo dey. Orzeꞌ nam: ―Dzi ga a̱ꞌ nap de mbecy nu yuꞌ na. Rgyiiñaꞌ dey tub muesht ni nusuriidz lo̱, tees ya̱ warica̱ ñii ni dey. Nomaas muesht ni Jonás, yu nu mnii por cuen ni Ñgyoozh, ndeꞌ ziꞌl muesht nu gad ni de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tees gal nu Jonás guc yu tub muesht ni de mbecy gyedz Nínive, ndeꞌ nu niꞌ ziꞌl ya̱, biñ nu byac mbecy, gaca̱ tub muesht ni de mbecy nu yuꞌ tiem na. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ornu shuub dzi nu ri bee Ñgyoozh ni dela mbecy nu yuꞌ tiem na, orzeꞌ biñ mñaa nu riib ic tub nasyoong nu ri par yaa been, ornu güiin par zeꞌ nu driib doo, gazaꞌm gyes sum niim nu yuꞌ cyi der, mbecy nu yuꞌ na. Gun mi zeꞌ zet zir bruum biid mi nu bzuub gyidag mi de coz nu mnii Salomoong. Nunu ya̱, biñ nu zu ii na, gya zir zu̱ gazeꞌ Salomoong. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nunu ornu shuub dzi nu ri bee Ñgyoozh ni dela mbecy, orzeꞌ dela mbecy nu yuꞌ gyedz Nínive gyes su gaꞌ dey nu nii dey nu yuꞌ cyi der mbecy nu yuꞌ tiem na. Gun de mbecy Nínive mneꞌ dey cyiy ornu güeñ dey de riidz ni Ñgyoozh nu pshaal Jonás lo dey. Nunu ya̱ biñ nu zu ii na, gya zir zu̱ gazeꞌ Jonás ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ni tub la mbecy wacaay gyi tub candiil nu riiy ñi tub lugaar ngach. Ni wariiy ñi nañ tub cajo̱o̱, sinu zuub yuñ seꞌñ, gun orzeꞌ cuic ñi yaa lo de mbecy nu rzuꞌ nañ yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Urlor, ndeꞌ nañ gal na tub candiil nu rbic yaa nañ shcab nir. Orzeꞌ benu gyicy ru coz nap nu urlor, orzeꞌ gzu yaa nañ dutuub la shcab nir. Tees benu gyicy ru coz cyi nu urlor, orzeꞌ cow la zu nañ shcab nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Orzeꞌ bicy cuidad, gun dzi ga walab yaa yuꞌ nañ shcab nir, sinu zu cow la nañ shcab nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tees benu dutuub la nañ shcab nir yuꞌ yaa nunu benu sac ni ñumiiñ zeꞌ nu cow, orzeꞌ naal la zac ru dela coz, gal nu rzac ru ornu tub candiil rbic ñi yaa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na ornu blazh mnii Jesuuz de nu ndeꞌ na, orzeꞌ tub mbecy fariseo bredz yu Jesuuz nu cham yuꞌy nu gow mi gyit. Orzeꞌ guꞌm nañ yuꞌ gusub mi lo mez. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na ornu bzaac yu nu wanaam gal mod nu rnii leey ni dey anzir nu gom gyit, orzeꞌ za nu la ic yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Orzeꞌ nam rab mi yu: ―De ru mbecy fariseo ich ziꞌl taz rgyiib der, nunu niꞌ ziꞌl ricy der nu gyaꞌn. Zeꞌ par nañ lardoo der dza laa yuꞌ coz a̱ꞌ nap nu ricy der. Yuꞌ gaꞌ gyel gubaan nu ricy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mbecy ton! ¿A wagad lagy der laab biñ nu bzaa nañ ñi, laab mi bzaam par ich ñi? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Benu cuic der coz nu yuꞌ nir ni de mbecy zi, orzeꞌ caacy nañ lardoor. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Cuaa de ru mbecy fariseo! Gun mas lo tii nac loow comid, rboo reñ der tub nac ñii nu rbic der ni Ñgyoozh. Ni ricy der nu menta, nu rud, nunu nu deꞌ zir gyish loow comid. Tees wagyicy cuen der mod nu rlagy ñi par nu chuꞌ den par lo Ñgyoozh, nunu ni waca der mi. De ndeꞌ rlagy ñi gyicy der, nunu walagy ñi laa yaa der deꞌ zir coz nap nu bi ricy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Cuaa de ru mbecy fariseo! Gun yet lagy der gzub der lo yashily ni mbecy zub lo nañ yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Nunu yet lagy der ornu mbecy ca lagy dey lo der ornu nii nu dey der lat yagyiꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Cuaa de ru! Na der gal nu na baa ni añ nu wacabee ca ri. Orzeꞌ de mbecy rded dey par ich ñi, tees wagad lagy dey ti rded dey tooñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Orzeꞌ na tub yu nu rlyuu leey ni Ñgyoozh rab yum: ―Masht, ornu ni rniir, orzeꞌ niꞌ ziꞌl rnii zi gaꞌr ni de̱ ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Orzeꞌ nam rab mi yu: ―¡Niꞌ ziꞌl cuaa de ru mbecy nu rlyuu leey ni Ñgyoozh! Gun rzuub der yuu ich mbecy. Ni wagyee ni tub la mbecy nu guy yuu zeꞌ. Zeꞌ de ru walagy der locyuub der losaꞌr nu guy yuu zeꞌ ni nu tub mbiz ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Cuaa de ru! Ricy zig der ruꞌ baa ni de yu nu mnii por cuen ni Ñgyoozh, de yu nu guꞌ gulas. Tees na der gal nu na de gyitoo bel ni der, gun de yu zeꞌ biit dey de yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Orzeꞌ rabee nu gal gaa la na der gal nu na gyitoo bel ni der. Gun de yu zeꞌ biit yu de yu nu mnii por cuen ni Ñgyoozh. Zeꞌ de ru ricy zig der ruꞌ baa ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ndeꞌ nu como Ñgyoozh rad lagy mi dela coz, orzeꞌ mniim: “Ya̱ gzuu neza̱ yu nu gnii por cuen ne̱, nunu gzuu neza̱ de aposht. Tees yuꞌ nu cut dey yu. Nunu yuꞌ gaꞌ nu shet zi dey yu”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndeꞌ nu Ñgyoozh zeed mi cashtig too de mbecy nu yuꞌ na nu nac dela yu nu mnii por cuen nim nu biit mbecy nese nu bzub gyiꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nese nu biit dey Abeel, gashtal nu biit dey Zacarí, yu nu biit dey loliꞌ ni yuꞌ ni Ñgyoozh par gazel ni mez nu rcuaa der gun lom nu yuꞌ yon nim. Orzeꞌ Ñgyoozh zeed mi cashtig ni de mbecy nu yuꞌ tiem na nu nac nu gut dela de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Cuaa de ru, mbecy nu rlyuu leey ni Ñgyoozh! De ru ricy cup der mod nu cuic der nu gad lagy de mbecy de coz nu rishli. Per walab tub lo ziꞌl nu walagy der gad lagy ru de coz nu rishli, sinu niꞌ ziꞌl wazaan der nu gad lagy deꞌ zir mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na ornu mniim de nu ndeꞌ, orzeꞌ de yu nu rlyuu leey, nu de mbecy fariseo tonaꞌ la bdzaꞌ dey. Orzeꞌ brugyiꞌ nu ricy seed dey mi nu rgugyiꞌ dey zañ lo coz lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bicy dey preb mi ben a wad mod nu riib dey cyi toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Orzeꞌ tonaꞌ la mbecy zigy bdeꞌ dey lo Jesuuz. Bee miily la dey bdeꞌ dey lom gashtal rzuub la gyiꞌ dey losaꞌy. Orzeꞌ Jesuuz nu loga la brugyiꞌ rniim lo de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―Cuidad der nu lebadur ni de mbecy fariseo. Lebadur zeꞌ, ndeꞌ gyel rzuu lo ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gun dela coz nu walagy dey nu gad lagy mbecy, ca ni gaal gad lagy mbecy par lo. Nunu sac ni tub coz nu cach dey nu wad lagy mbecy par lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gun la ziꞌl riidz nu ro der rel gyeñ mbecy ñi or widoo. Nunu la ziꞌl riidz dze ga nu ro der nañ yuꞌ nir, gyeñ de mbecy nu zaab tiꞌ riidz zeꞌ gal too yuꞌ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’De ru mbecy, ya̱ rne̱e̱ lo der nu cueꞌ dzib der lo de mbecy nu rut cuerp ni losaꞌ, tees wac nu laꞌ zir gyicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tees ya̱ rne̱e̱ lo der nu cyu lo rlagy ñi nu dzib der. Rlagy ñi nu dzib der lo biñ nu gac cut cuerp ni der, nunu despuees orzeꞌ neꞌm ñii gabily. Orzeꞌ gudzib zir der lo mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿A walab nu rut dey gaay chigyiñ miꞌ par cyup sentab miꞌ? Nunu Ñgyoozh ni wagnit lagy mi ni tub ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Zeꞌ yegar de ru. Ñgyoozh rad lagy mi la be gyich too der. Delañ ngab ñi nim. Ndeꞌ nu cueꞌ dzib der, gun de ru sac zir der gazeꞌ de chigyiñ zigy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ya̱ ne̱e̱ lo der nu benu tub mbecy niiy nu naca̱ Shuaan yu lo losaꞌy, orzeꞌ niꞌ ziꞌl ya̱, biñ nu byac mbecy, ne̱e̱ lo de anc zigy ni Ñgyoozh nu yuꞌ gyibaa nu nac yu ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tees de mbecy nu rcach ruꞌ ya̱ lo de mbecy, orzeꞌ niꞌ ya̱ cach ru̱ꞌ ga̱ꞌ dey lo de anc ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Orzeꞌ cyu ziꞌl mbecy nu nii zi ne̱ ya̱, biñ nu byac mbecy, orzeꞌ Ñgyoozh gyicy sulagy mi niy. Tees de yu nu nii zi ni Espiriit Yon nim, de yu zeꞌ wayicy sulagy mi ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Yuꞌ nu guꞌ dey der yaa de yu nu riib ic nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh. Zeꞌ yuꞌ gaꞌ nu guꞌ dey der yaa feez. Nunu yuꞌ gaꞌ nu guꞌ dey der yaa de fushtiz. Ornu ni gyicy nu dey der, orzeꞌ cueꞌ sug ic der nu lac mod gyicy ru par nu gabe nu sac falt nir. Ni cueꞌ sug ic der la na riidz nu niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gun ornu shuub or nu nii der zeꞌ, orzeꞌ Espiriit Yon ni Ñgyoozh lyuum ni der lac mod niir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Orzeꞌ bruu su tub mbecy lat de mbecy zigy. Orzeꞌ nay rab yu Jesuuz: ―Masht, mnii lo bicya̱ nu cuic yu gyel nap nu ya̱ bdugyi̱ ornu gut uza̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Orzeꞌ na Jesuuz rab mi yu: ―Ru mbecy, ¿cyu bicy nu ya̱ naca̱ feez nu lewa̱ gyel nap ni de ru? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Orzeꞌ nam rab mi de mbecy: ―Bicy cuidad der nu nac de lo la gyel ye rzac. Gun mbecy walab nu nac nu ricy cup dey zañ lo coz, ndeꞌ gyicy ñi nu cui mbañ yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Orzeꞌ mniim tub riidz tiily lo dey. Orzeꞌ nam: ―Bzu tub mbecy guaniꞌñ. Tonaꞌ la sheñ cosech rteꞌy lo yu niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Orzeꞌ brugyiꞌ nu rnii tooy: “¿Zeꞌ na lac mod gyicya̱? Sacaꞌ la ca lugaar nu duꞌ choowa̱ cosech ne̱”, mnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Orzeꞌ mnii gaꞌ tooy: “Ya̱ bi gud lagya̱ lac mod gyicya̱. Tilya̱ de ye ne̱. Orzeꞌ za̱a̱ zira̱ nu zily zir. Gun orzeꞌ nañ zeꞌ duꞌ choowa̱ dela cosech ne̱, nunu dela coz nu ricy cupa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Orzeꞌ ne̱e̱ nañ lardo̱o̱: Dzi ga nap. Bduꞌ choowa̱ zañ coz nu cyiiñ ne̱ par zañ ñaꞌn. Na gac zu lagya̱. Gac da̱w. Gac do̱ꞌ. Nunu gac gyicya̱ gusht ne̱.” Ni mnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Orzeꞌ na Ñgyoozh rab mi yu: “¡Mbecy ton! Laab rel na gat ru. Zeꞌ de coz nu bduꞌ choow ru, orzeꞌ ¿cyu ni gyeñ ñi?” ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Orzeꞌ ni mod zac mbecy benu cyaañ yu gyel nap niy par ub ziꞌl yu, tees sac coz nu sac niy par lo Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Despuees orzeꞌ Jesuuz nam rab mi de yu nu rsyaꞌ lom: ―Cueꞌ sug ic der nu nac de coz nu gow der par nu cui mbañ der. Ni cueꞌ csug ic der nu nac shab ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gun dzi zir sac nu cui mbañ der gazeꞌ de coz nu gow der. Nunu cuerp ni der sac zir ñi gazeꞌ shab ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Güii der mod nu ricy de byac. Ni wagnuuz ma. Nunu ni wagteꞌ ma. Nunu sac ye ni ma. Mas ni, tees Ñgyoozh rgoow mi de ma. ¡Zeꞌ yegar de ru sac zir der gazeꞌ de chigyiñ! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ca na de ru nu nac nu dzi rsug ic der gac tuuñ zir der lo yur, mas ñuu se tub or? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Zeꞌ benu wac gyicy der de coz miꞌ zeꞌ, ¿lagu dzi rsug ic der nu nac deꞌ zir coz? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Güii lac mod raly de ya gyee. Ni wagyicy ñi riiñ. Ni wagriꞌñ iily. Mas ni, tees ya̱ rne̱e̱ lo der nu rey Salomoong, mas tonaꞌ la guaniꞌñ yu, tees wansuy negy nu nsaap ñi gal nu na de gyee zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Benu Ñgyoozh rtiish mi de gyish nu nash ngush na, zeꞌ ina gyañ lo gyi nañ yo, ndeꞌ nu segur la tiish mi de ru mbecy nu wagyicy cup consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndeꞌ nu cueꞌ dzi csug ic der chesar nu yub ru de coz nu gow der o nu goꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gun dela de coz zeꞌ rsug ic de mbecy ni gyishlombecy. Tees de ru zu Ñgyoozh, uz der. Nunu mi zeꞌ bi rad lagy mi la coz galagy ñi ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Orzeꞌ bzub lo der nu nac gyel gubier ni Ñgyoozh. Orzeꞌ mi zeꞌ cuic mi dela coz nu galagy ñi ni der ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Der mbecy nu na gal nu na shily ne̱, cueꞌ dzib der. Sac zig der. Tees Ñgyoozh, uz na, yet lagy mi nu gyicy mi nu gyub ic nu der mi lugaar zeꞌ nu riib ic mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Orzeꞌ biit der de coz nu yuꞌ nir. Orzeꞌ nu tiñ nu gad ni der zeꞌ cuic der ni mbecy zi. Orzeꞌ bicy der nu gad tub nerbid tiñ nu yuꞌ gyibaa ni der, gun wayaguush ñi. Pcyaañ der gyel nap nir gyibaa zeꞌ nu rila walaazh ñi. Zeꞌ ni wayuꞌ gubaan nu coy ñi, ni bigyich wac nit lo ma ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gun lugaar zeꞌ nu rcyaañ der gyel nap nir, zeꞌ lugaar nu ric la añ ni der lo ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Rlagy ñi nu gac der tub mbecy nu lily gaa la zu. Na der gal na tub mbecy nu bi bzu lily yu. Bzuy shab yu, nunu bi pcaay gyi candiil niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nunu rlagy ñi gyicy der gal nu ricy de moz nu rbez yu patro̱o̱ niy nu griy nu guay lo fandang. Na ornu griy, gnii nuy de moz niy. Orzeꞌ lueg la shaal dey roꞌ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dzi ni de moz benu patro̱o̱ niy gyap yu dey zu ga lagy yu ornu griy. Ya̱ rishli rne̱e̱ lo der nu laab patro̱o̱ zeꞌ gyicy yu nu gzub dey lo mez. Orzeꞌ patro̱o̱ niy zu lily yu nu saay gyaꞌn nu gow dey gyit. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dzi ni de moz zeꞌ benu patro̱o̱ niy gyap yu dey zu ga lagy yu mas guzeel rel riy, o mas bi rzaꞌ yu riy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na gad lagy der de nu nii. Benu shuaan tub yuꞌ gad lagy yu la or ruꞌña gubaan, orzeꞌ wazaan yu nu chuꞌy nañ yuꞌy nu coy suuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Orzeꞌ niꞌ ziꞌl de ru rlagy ñi nu gac der tub mbecy nu lily zu. Gun ya̱, biñ nu byac mbecy, yapa̱ or nu a̱ꞌ saꞌ la lagy der ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Orzeꞌ Bed nay rab yu Jesuuz: ―Shuaan de̱, riidz tiily nu mniir lo̱ de̱ zeꞌ, ¿a ndeꞌ par de̱ ya̱ ziꞌl, uti ndeꞌ par dela mbecy? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Orzeꞌ Jesuuz nam rab mi yu: ―¿Ca na moz nu ricy paa, nu moz nu yuꞌ shcab ñi? Yu zeꞌ bduꞌ patro̱o̱ niy riiñ yaay nu gyub ic yu deꞌ zir moz nu yuꞌ niy, par nu cuic yu nu gow de yu zeꞌ or niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dzi ni moz zeꞌ benu gyap patro̱o̱ niy yu ornu griy nu ricy yu gal nu mniiy loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya̱ rishli rne̱e̱ lo der nu patro̱o̱ niy cuꞌy riiñ yaay nu gyub ic yu dela coz niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tees benu moz zeꞌ nac yu mbecy a̱ꞌ nap, orzeꞌ nii tooy nu wari gyiily patro̱o̱ niy. Orzeꞌ cugyiꞌ gyicy ras nuy de losaꞌ moz yu. Mñaa gyeey la gyicy ras nuy. Gow yu nunu goꞌy, nunu gzugy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Orzeꞌ gri patro̱o̱ niy tub dzi nu a̱ꞌ saꞌ la lagy yu. Griy tub or nu wagad lagy lay. Orzeꞌ tonaꞌ la cashtig ily cuic yu ni moz zeꞌ. Gyicy yu gal nu ricy nu dey mbecy wagyicy paa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’De moz nu rad lagy de coz nu rlagy patro̱o̱ ni, tees wacsu lily yu de coz nu rniiy, ni wacsuub gyidag yu niy, orzeꞌ yu zeꞌ, cuic dey cashtig niy. Orzeꞌ zañ golp gad niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Zeꞌ de moz nu wagad lagy de coz nu rlagy patro̱o̱ ni, niꞌ ziꞌl yad ñi nu gad cashtig niy, orzeꞌ ornu cuic dey cashtig niy, orzeꞌ ñuu zi zir golp gad niy. Gun de mbecy nu briic Ñgyoozh sheñ ni, orzeꞌ niꞌ ziꞌl niim nu gyabic yu sheñ. Nunu yu nu sheñ bguꞌ Ñgyoozh yaa, orzeꞌ yu zeꞌ cyish lo zir Ñgyoozh loy nu gyicy yu zañ zir coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ya̱ yapa̱ nu gyicya̱ nu ri bee Ñgyoozh ni dela mbecy nu yuꞌ gyishlombecy. Gyicy mi gal nu ricy gyi. Bicy na nu bi rca gyi zeꞌ, orzeꞌ tonaꞌ la gyet lagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nunu ya̱ rlagy ñi nu tonaꞌ la gzac zi̱. Nunu tonaꞌ la deet gac nañ lardo̱o̱ gashtal gded la nu gzac zi̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A rnii too der nu ya̱ yapa̱ nu gyicya̱ nu nap chuꞌ mbecy nu losaꞌy gyishlombecy? Walab nu gyicya̱ nu nap chuꞌ dey, sinu gyicya̱ nu chucoo dey nu losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gun na par lo gaay mbecy laab nu famil ziꞌl ni dey chucooy. Chon yu chay contr ni cyup yu. Zeꞌ cyup yu chay contr ni chon yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Gun yuꞌ mbecy gush nu chay contr ni iꞌñ yu yu gyeey. Zeꞌ yu zeꞌ chay contr ni uz yu. Zeꞌ yuꞌ gaꞌ biñ mñaa nu cham contr ni iꞌñ mi fiñ mñaa. Zeꞌ fiñ zeꞌ chañ contr ni ñaañ. Zeꞌ yuꞌ gaꞌ biñ mñaa nu cham contr ni shis mi. Zeꞌ fiñ zeꞌ chañ contr ni ñaa gud ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Orzeꞌ na gaꞌ Jesuuz rab mi de mbecy: ―Ornu de ru rzac der nu yad za par zeꞌ nu rza doo, orzeꞌ rnii der nu gyet gyey. Nunu ni raac ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Zeꞌ ornu bi druuñ par yaa reg na ornu güiin par zeꞌ nu rza doo, orzeꞌ rnii der nu bi yad tiem zig. Nunu ni raac ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Mbecy rzuꞌ lo! Benu rad lagy der muesht nu taꞌ baa, gal nu muesht nu yuꞌ lo yu, ¿se lagu wagad lagy der la tiem yuꞌ der beni? ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Orzeꞌ na gaꞌm rab mi dey: ―¿Lagu wagnii too der par ub ru ben ca na nu nap? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Orzeꞌ benu ca na tub losaꞌr rlagy yu cuꞌy cyir nu cha nuy ru lo de fushtiz, orzeꞌ bzu altant nu gyicy ru rishnap nur yu lat nu gabee cuic ñi tiem nir. Gun orzeꞌ cueꞌ cha nuy ru lo feez. Gun benu wayicy ru ndeꞌ, orzeꞌ feez zeꞌ guꞌy ru yaa de yu nu rña yuꞌ gyiib. Orzeꞌ de yu nu rña yuꞌ gyiib shet lag dey ru nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya̱ rne̱e̱ lor nu waruur nañ gashtal cuaa lar dela tiñ nu nii dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Orzeꞌ laab tiem zeꞌ la be mbecy gua güii dey Jesuuz. Orzeꞌ byoo dey rishlom nu Pilato bicy yu nu gut la be mbecy Galilea. Orzeꞌ gucan reñ de mbecy zeꞌ nu reñ bañcyug nu briic dey gun lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Orzeꞌ na Jesuuz rab mi dey: ―¿A rnii too der nu de mbecy nu gut zeꞌ dzi zir nac yu mbecy cyi par deꞌ zir mbecy Galilea, nunu ndeꞌ nu ni bzac dey? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ya̱ rne̱e̱ lo der nu walab. Nunu benu de ru waneꞌ der dela cyi nu ricy der, orzeꞌ niꞌ de ru gat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿La coz rnii der nu nac tiiñ zu chon mbecy nu gut ornu bet lag tub yuꞌ gya too dey tub gyedz nu la Siloé? ¿A rash der shcab nu de yu zeꞌ dzi zir bicy dey coz cyi gazeꞌ deꞌ zir mbecy nu rcyiiñ Jerusaleeng? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya̱ rne̱e̱ lo der nu walab, nunu benu de ru waneꞌ der de cyi nu ricy ru, orzeꞌ niꞌ ziꞌl gat der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Orzeꞌ Jesuuz mniim tub riidz tiily lo dey. Orzeꞌ nam: ―Bzu tub mbecy. Bzub tub ya las niy. Bzub ñi lat lyucy urbyay niy. Orzeꞌ gua güiiy ben a taꞌ uugy niñ. Tees wangyap yu ni tub uugy niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Orzeꞌ nay rab yu moz niy nu ricy riiñ lat naa zeꞌ: “Güii. Bzaꞌ chon ñaꞌn zaab ryap la̱ rgüi̱i̱ ya las ii nu ryuba̱ uugy niñ. Tees rila wagyapa̱ uugy niñ. Orzeꞌ na pshiꞌñ ñi. ¿Gun lagu leew la ricy seed ñi lat naa?” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tees yu nu ricy riiñ zeꞌ nay rab yu patro̱o̱ niy: “Patro̱o̱, bzaan zub ñi stub ñaꞌn. Orzeꞌ gla̱a̱ yu gyiꞌñ. Gazeꞌ nu du̱ꞌ abon gyiꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Benu ni, orzeꞌ cyup ridz cuic ñi uugy. Zeꞌ benu wabic ñi uugy, orzeꞌ nap zir gyiꞌñ ñi”, nay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tub tiem, tub sab, dzi nu rzu lagy mbecy, orzeꞌ Jesuuz rim nañ tub yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh rlyuum ni de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nunu zeꞌ ri tub biñ mñaa nu bi bzaꞌ tiiñ zu chon ñaꞌn rat mi. Gun bi bicy ni nuras mi, nunu bicy yu nu brong mi. Orzeꞌ rila wangac ñgyuꞌ lim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na ornu Jesuuz bzaac mi biñ mñaa zeꞌ, orzeꞌ bredz mi biñ mñaa zeꞌ. Orzeꞌ nam: ―Biñ mñaa, bi byac ru ni güii nu rat ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Orzeꞌ gazeꞌ nu gul yaam biñ mñaa zeꞌ. Orzeꞌ laab or la zeꞌ byuꞌ li cuerp ni biñ mñaa zeꞌ. Orzeꞌ brugyiꞌ nu ryabic mi gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tees yu nu riib ic nañ yuꞌ zeꞌ guzi lagy yu, gun Jesuuz bicy yac mi biñ mñaa zeꞌ sab, dzi nu rzu lagy mbecy. Orzeꞌ nay rab yu deꞌ zir de mbecy nu yuꞌ zeꞌ: ―Yuꞌ tub shuup dzi nañ tub sman par nu gyicy na riiñ. Orzeꞌ lat de dzi zeꞌ cyid der par nu gyicy yac mbecy der. Tees dzi nu rzu lagy mbecy, cueꞌ cyid der par nu gyicy yac mbecy der ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Orzeꞌ na Jesuuz rab mi dey: ―Der mbecy rzuu lo, ¿de ru walab gaal washaagy der tor nir o bur nir sab, dzi nu rzu lagy mbecy, par nu cha nu der ma nu goꞌ ma nis? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Zeꞌ biñ mñaa ii, mi ii nez Abraham, nunu bi bzaꞌ tiiñ zu chon ñaꞌn nu pcyiig nuras biñ mñaa ii nu güii nu rat mi. Orzeꞌ beni ¿a wac gyagy biñ mñaa ii ni güii nu rat mi sab, dzi nu rzu lagy mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ornu ni mnii Jesuuz, orzeꞌ de losaꞌ yuum tonaꞌ la gut lo dey. Tees deꞌ zir de mbecy tonaꞌ la bet lagy dey nu nac de coz ily nu ricy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Orzeꞌ na gaꞌ Jesuuz: ―¿La na gyel gubier ni Ñgyoozh? ¿La ñuu coz saapa̱ nu gyel gubier nim? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Gyel gubier ni Ñgyoozh rac ñi gal nu rac nu tub mbigy ya urnishtas nu rnuuz mbecy lo yu niy. Orzeꞌ gazeꞌ nu raly ñi gashtal gyac lañ tub yag ily mas gashtal de chigyiñ rzaa ma teez ma lat yaañ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gazeꞌ nu na gaꞌm: ―¿La ñuu coz saapa̱ nu gyel gubier ni Ñgyoozh? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gyel gubier ni Ñgyoozh nañ gal nu na lebadur nu gush tub biñ mñaa. Bduꞌm ñii lat chon nac arin, gun orzeꞌ lebadur zeꞌ cshup ñi dela cub zañ zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na nez nu yam par Jerusaleeng na, orzeꞌ blyuum ni de mbecy dela gyedz gal nu dela ranch nu yuꞌ nez nu zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Orzeꞌ gazeꞌ nu bruu su tub mbecy. Orzeꞌ nay rab yum: ―Shuaana̱, ¿a ñuu zi zi mbecy gruu mbañ yu? ―nay. Gazeꞌ nu nam rab mi yu: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Bicy der fers nu chuꞌ der roꞌ shii, gun ya̱ ne̱e̱ lor tonaꞌ la zigy mbecy galagy dey chuꞌy, tees wac chuꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Orzeꞌ yu guyuꞌ gyeshtey nunu soow yu roꞌ. Orzeꞌ de ru, de mbecy nu yuꞌ par ich gnii der: “Shuaana̱, pshaal roꞌ ne̱”, nii der. Tees yu guyuꞌ zeꞌ gnii gaꞌy gab yu de ru: “Ya̱ wagad lagya̱ ca bruu der”, niiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Gazeꞌ nu nii gaꞌ de ru: “Zeꞌ ¿lagu ni rnii ru? Zeꞌ de̱ ya̱ tublaazh la bda̱w du̱ de̱ ru gyit. Nunu tublaazh la bdoꞌ du̱ de̱ ru. Nunu laab ru blyuur ne̱ de̱ lat cay ledz de̱”, nii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Orzeꞌ yu guyuꞌ zeꞌ nii gaꞌy gab yu der: “Ya̱ bi mne̱e̱ lo der nu wagad lagya̱ ca bruu der. Orzeꞌ bruu chu der lo̱, der mbecy nu shiñ ricy”, niiy gab yu de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Orzeꞌ zeꞌ gun der nunu siigy lay der ornu zac der Abraham, nu Isaac, nu Jacob, gal nu deꞌ zir de yu nu mnii por cuen ni Ñgyoozh yuꞌ dey zeꞌ nu riib ic mi. Zeꞌ ii de ru bi zu chu der par ich. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Gun cyid mbecy nu gruu gazaꞌ dela lugaar ni gyishlombecy nu gzub dey lo mez nu gow dey gyit zeꞌ nu riib ic Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Orzeꞌ la be de mbecy nu gash zir zu na, de yu zeꞌ gyac yu yu nu gya zir zu par lo, nunu la be de mbecy nu gya zir zu na, de yu zeꞌ gyac yu yu nu gash zir zu par lo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Gazeꞌ nu bruꞌña la be de mbecy fariseo. Orzeꞌ na dey rab yu Jesuuz: ―Gua la ru, gun Herodes rlagy yu cut yu ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Gazeꞌ nu nam rab mi dey: ―Gua der gua niir lo mbecy rguu zeꞌ nu na gal nu ina ya̱ lo̱o̱ chu̱ nuras nu bicy ni mbecy, nunu gyicy yaca̱ mbecy rat. Orzeꞌ widz na, gyaꞌ lo de riiñ nu ricya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rlagy ñi zab za̱ la̱ nez dzi na, nu ina, nu widz na. Gun walab seꞌñ nu gat tub mbecy nu rnii por cuen ni Ñgyoozh reñaꞌ lugaar par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡A der mbecy Jerusaleeng! Rut der de mbecy nu rnii por cuen ni Ñgyoozh. Nunu rgoow gyitaꞌ der de mbecy nu rzeed Ñgyoozh lat der. Zañ tir ngulagya̱ ñgyicy tublaazha̱ der gal nu ricy tub gyid ornu ricy tublaazh ma dzich ni ma nañ loweꞌ ma. Tees de ru wangalagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na ledz der gyiyeeñ ub ziñ. Gun ya̱ ne̱e̱ lo der nu wazacaꞌ la der ya̱ gashtal shuub la dzi nu nii der: “Dzi ga zily nac biñ nu bzuu nez Ñgyoozh Shuaan na, biñ nu cyid lo den”, nii der ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Guc ñi tub tiem, tub sab, dzi nu rzu lagy mbecy, orzeꞌ Jesuuz guam gua tom gyit yuꞌ tub yu zub lo ni de mbecy fariseo. Nunu zeꞌ yuꞌ la be mbecy fariseo nu rguꞌ cuen ga dey mi ben lac mod gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nunu ri gaꞌ tub mbecy nu yuꞌ gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Orzeꞌ Jesuuz bdugyiꞌm lo de yu nu rlyuu leey ni Ñgyoozh gal nu lo de mbecy fariseo. Orzeꞌ nam rab mi dey: ―¿A nap zuñ lo leey ni Moisees nu gyicy yac na mbecy rat sab, dzi nu rzu lagy mbecy, uti a̱ꞌ nap? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tees dey zeꞌ wanii lay. Gazeꞌ nu gul yaam mbecy rat zeꞌ. Orzeꞌ gazeꞌ nu bicy yac mi yu. Orzeꞌ gazeꞌ nu bzuu nez mi yu yay yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gazeꞌ nu nam rab mi de mbecy fariseo: ―Benu ca na de ru gyet lag tub iꞌñ der nañ tub zo, o tub tor ni der gyet lag ma, orzeꞌ ¿a walab co der ma, mas sab, dzi nu rzu lagy mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Orzeꞌ de yu zeꞌ rila wannii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ornu Jesuuz bzaac mi de mbecy nu ya tow gyit ryub dey lugaar ni mbecy zub lo lo mez nu zub dey, orzeꞌ gazeꞌ nu briic mi consef ni dey. Orzeꞌ nam rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ornu cuedz mbecy de ru nu cha der lo fandang, orzeꞌ cueꞌ zub der seꞌ mbecy zub lo, gun dzi ga gruꞌña tub mbecy nu lily zir na gazeꞌ ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Orzeꞌ gruꞌña mbecy nu bredz rup laa der gal nu mbecy lily zeꞌ. Orzeꞌ niiy gab yu ru: “Zeꞌ nu zub ru gac cuic ru nu zub yu lily ii”, niiy gab yu ru. Orzeꞌ ru gruu gyel mbecy nir, nunu chesub ru seꞌ mbecy zaab ich zir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lugaar nu gyicy ru ndeꞌ, orzeꞌ i mod gyicy ru: Ornu cuedz dey ru nu char fandang, orzeꞌ ornu ruꞌñar, orzeꞌ zub ru seꞌ mbecy nu zaab ich zir. Gun ornu ruꞌña mbecy nu bredz ru zeꞌ, orzeꞌ niiy gab yu ru: “Mbecy, ru char zub ru seꞌ mbecy zub lo zir”, niiy gab yu ru. Orzeꞌ ornu gyicy ru ndeꞌ, orzeꞌ deꞌ zir mbecy nu nguaa lo mez zeꞌ ca lagy dey lor. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gun yu nu ricy zily ub, yu zeꞌ gruu gyel mbecy niy. Zeꞌ yu nu ricy gyel gyidz ni, yu zeꞌ gyed gyel mbecy niy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Orzeꞌ nam rab mi mbecy nu bredz mi nu cha tom gyit yuꞌ zeꞌ: ―Ornu cuic ru cui o che nu gow mbecy, orzeꞌ cueꞌ cuedz ru amig nir. Ni cueꞌ cuedz ru de bicy ru. Ni cueꞌ cuedz ru de uz ru. Ni cueꞌ cuedz ru de yu guaniꞌñ lat losaꞌr. Gun benu ni gyicy ru, orzeꞌ niꞌ ziꞌl de yu zeꞌ cuedz dey ru nu cha tor gyit yuꞌy. Orzeꞌ ni mod gyad ir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lugaar nu gyicy der ndeꞌ, orzeꞌ i mod gyicy ru. Ornu gyicy ru tub saꞌ, orzeꞌ cuedz ru de mbecy zi nu cyid dey lor. Cuedz ru mbecy nu wagac za, nunu cuedz ru mbecy coj, nunu cuedz ru mbecy lo caꞌ. De yu zeꞌ cuedz ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dzi ni der benu ni gyicy ru. Gun de yu zeꞌ wacaꞌ gyabic dey ir. Tees ru gyad ir ornu shuub dzi nu gyabañ de mbecy nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na ornu güeñ tub yu nu bzub nu Jesuuz lo mez de coz zeꞌ, orzeꞌ nay rab yum: ―¡Dzi ni de mbecy nu cha tow gyit lo saꞌ zeꞌ nu riib ic Ñgyoozh! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Orzeꞌ Jesuuz nam: ―Bzu tub mbecy. Orzeꞌ bicy yu tub saꞌ ily. Orzeꞌ bredz yu zigy mbecy nu chay lo saꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na ornu pshuub or na, orzeꞌ bzuu nez yu tub moz niy nu cha niiy lo de mbecy nu ca lo cuen nu cha lo saꞌ zeꞌ. Orzeꞌ nay: “Da der, gun dela coz bi zu lily ñii”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Orzeꞌ dela dey mnii dey rishtoꞌ lo. Orzeꞌ mbecy nu guay lo loga la zeꞌ nay: “Ya̱ wac cha̱, gun saa la wi tub nac yu. Ndeꞌ nu ya̱ cha güi̱i̱ ñii. Orzeꞌ bicy sulagy ne̱, gun wac cha̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Zeꞌ tuubaꞌy nay: “Wac cha̱, gun saa la wi̱ gaay nez tor. Orzeꞌ na cha̱ gyicya̱ preb ma ben a nap ricy ma riiñ. Orzeꞌ bicy sulagy ne̱, gun wac cha̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Zeꞌ tuubaꞌy nay: “Wac cha̱, gun saa la pchela̱a̱. Ndeꞌ nu wac cha̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Orzeꞌ gazeꞌ nu moz zeꞌ bish cyay yay. Ornu briy na, orzeꞌ mniiy dela ndeꞌ lo patro̱o̱ niy. Orzeꞌ patro̱o̱ niy tonaꞌ la guzi lagy yu. Gazeꞌ nu nay rab yu moz niy zeꞌ: “Dzach ru gua lat cay, gal nu de nez miꞌ nu riib lat gyedz. Orzeꞌ cyid nur de mbecy zi, nu de mbecy nu wagac za, nu mbecy lo caꞌ, gal nu mbecy coj”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Na ornu bi rac la be or, orzeꞌ moz zeꞌ nay rab yu patro̱o̱ niy: “Na bi bicya̱ dela coz nu mniir, nunu gabee gad ruꞌ lugaar nu gzub mbecy benu cyid yu”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Orzeꞌ patro̱o̱ zeꞌ nay rab yu moz niy: “Gua de nez zu gal nu de nez las nu riib ngush. Orzeꞌ niir lo reñaꞌ mbecy nu cyid dey, gun orzeꞌ chuꞌ zir mbecy gashtal dzaa la nañ yuꞌ ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gun ya̱ rne̱e̱ nu ni tub la mbecy nu mne̱e̱ nu cyid nu loga la wow yu de coz nu bzu ye̱”, nay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Orzeꞌ tonaꞌ la zigy mbecy za ca dey ich Jesuuz. Orzeꞌ bish cyam bgüiim lo dey. Orzeꞌ nam rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Benu ca na mbecy cyid cay icha̱, zeꞌ benu rca zir yu uz yu, o ñaay, o mñaay, o iꞌñ yu, o bicy yu, o zan yu, o ub yu gazeꞌ ya̱, orzeꞌ yu zeꞌ rila wangyap yu nu gac yu mbecy nu rsyaꞌ lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cyu ziꞌl mbecy nu washet ic nu gzac zi nu nac ya̱, nunu benu washet ic yu nu gyicy yu gal nu ya̱ rlagya̱, orzeꞌ yu zeꞌ niꞌ ziꞌl wangyap yu nu gac yu mbecy nu rsyaꞌ lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Orzeꞌ benu ca na de ru rlagy der zaar tub yuꞌ gya, orzeꞌ ¿a walab nu loga la rlagy ñi nu zub ru cor cuen ben a gal tiñ nir par nu gyaꞌ lo yuꞌ zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tees benu de ru gzu ziꞌl der simient niñ, zeꞌ wazaꞌ lo der ñii, orzeꞌ ornu gzac de mbecy, orzeꞌ cugyiꞌ gubdzaa dey der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Orzeꞌ nii dey: “Yu re nu bzuub ziꞌl yu gyiꞌ yuꞌ niy per wangac nzaꞌ loy ñi”, nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O benu tub rey chay nu chuꞌy gyel yuu nu tuubaꞌ rey, orzeꞌ ¿a walab nu loga la rlagy ñi nu nii tooy ben a zu tii miily soldad niy lo tub gal miily soldad nu chucoo nuy zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Zeꞌ benu wazuy lo gyel yuu zeꞌ, orzeꞌ ornu gabee zet ruꞌ zu tuubaꞌ rey nu chucoo nuy zeꞌ, orzeꞌ gzuu nez yu tub moz niy nu niiy lo tuubaꞌ losaꞌy nu cueꞌ gyicy yu gyel yuu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Orzeꞌ niꞌ ziꞌl de ru. Benu washet ic der nu zeeñ der de coz nu ricy cup der, orzeꞌ wangyap der gac ru mbecy nu rsyaꞌ lo̱ ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Zed, ndeꞌ nap ricy ñi benu yuꞌ nu riꞌ niñ. Tees benu zed zeꞌ ruu nu riꞌ niñ, ¿orzeꞌ lac mod chuꞌ gaꞌ nu riꞌ niñ tuubaꞌ tir? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Orzeꞌ rila wacyiiñ ñi. Ni wacyiiñ ñi nu gyicy nap ñi yu. Nunu ni wacyiiñ ñi par abon. Orzeꞌ nap zir nu neꞌ dey ñi. Yu nu zub gyidag, rlagy ñi gyicy yu nu gyet lag yu cuen ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dela yu nu rboo tiñ por cuen ni gubier Rom, gal nu reñaꞌ mbecy bduneꞌ bechaꞌ dey lo Jesuuz par nu zuub gyidag dey de coz nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Zeꞌ de mbecy fariseo gal nu de yu nu rlyuu leey ni Ñgyoozh rnid ruꞌ dey nu nac mi. Orzeꞌ na dey: ―Yu re rnii nuy mbecy cyi nunu row nuy dey gyit ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Orzeꞌ Jesuuz mniim riidz tiily lo dey. Orzeꞌ nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Benu ca na de ru zu tub gaynal shily nir, seꞌ duneꞌ tub ma, orzeꞌ ¿a walab zeeñ der nobent zuub gaa ma ngush? Orzeꞌ gazeꞌ nu cha der cha yub der tub bañ nu bduneꞌ zeꞌ gashtal gyad la ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na ornu gyad ma na, orzeꞌ tonaꞌ la gyet lagy der. Orzeꞌ riib yeñ der ma gya nur ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na ornu rir yuꞌr na, orzeꞌ cha teꞌr de amig nir gal nu de mbecy nu yuꞌ gaab ga. Orzeꞌ nii der gab ru dey: “Bet lagy der nur ya̱, gun ya̱ byada̱ shily ne̱, bañ nu bduneꞌ”, nii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ya̱ rishli rne̱e̱ lo der, cyit zir rac gyibaa nu nac tub mbecy cyi ornu rneꞌy dela cyi nu ricy yu, gazeꞌ nu nac nobent zub gaa mbecy nap nu walagy ñi nu neꞌ cyi nu ricy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Gyicy peen nu tub biñ mñaa nu ricy cup tii tiñ plat. Orzeꞌ duneꞌ tub ñi nim. Orzeꞌ ¿la coz gyicy mi? Nu loga la caam gyi candiil nim. Orzeꞌ gazeꞌ nu lyuub mi nañ yuꞌ nim. Orzeꞌ nap yub mi ñii gashtal gyad lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na ornu gyad ñi nim na, orzeꞌ cuedz mi dela amig nim, gal nu dela mbecy nu yuꞌ gaab ga. Orzeꞌ niim gab mi dey: “Tonaꞌ la yet lagya̱ gun bi byada̱ de tiñ nu bduneꞌ ne̱”, niim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Orzeꞌ ya̱ rne̱e̱ lo der nu tonaꞌ la yet lagy de anc ni Ñgyoozh nu nac tub mbecy cyi nu rneꞌy de cyi nu ricy yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Orzeꞌ Jesuuz mniim tuubaꞌ riidz tiily lo dey. Orzeꞌ nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","―Zu tub mbecy. Zu cyup iꞌñ yu. Orzeꞌ yu miꞌ zeꞌ nay rab yu uz yu: “Tat, cuic ru gyel nap nir nu ya̱ dugyi̱”, nay. Orzeꞌ yu zeꞌ blew yu gyel nap zeꞌ niy lat de iꞌñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na ornu bi rac la be tiem, orzeꞌ yu miꞌ zeꞌ biit yu dela coz nu bdugyiy. Orzeꞌ gush nez yu za nuy tiñ zeꞌ tub lugaar zet. Gashtal tuubaꞌ nasyoong zay. Orzeꞌ zeꞌ mniit ton yu dela tiñ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na ornu blazh mniit yu dela tiñ niy, orzeꞌ biid tub cubiñ ily lugaar zeꞌ. Orzeꞌ brugyiꞌ rded yu gyel ran. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Orzeꞌ gua yub yu riiñ lo tub mbecy guledz. Orzeꞌ yu zeꞌ bzuu nez yuy chay ranch niy nu cha ñay cuch. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Orzeꞌ yu miꞌ zeꞌ ngulagy yu ñgyow yu gyid ich zaa nu row cuch zeꞌ par nu dzaa nañ yu. Tees ni tub la mbecy wancuic yu ndeꞌ gow yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Laab ndeꞌ la orzeꞌ mnii tooy: “De moz nu rcyiiñ lo uza̱ rad nu row dey gashtal drusubaꞌ lañ. Zeꞌ ya̱ se nu gat ziꞌla̱ gyel ran. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndeꞌ nu na nap zir cush cya̱ gya̱ yuꞌ uza̱. Orzeꞌ ne̱e̱ loy: Tat, ya̱ guch ñii ne̱ lo Ñgyoozh, nunu guch ñii ne̱ lo ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A̱ꞌ yadaꞌñ nu nii dey nu naca̱ iꞌñ ru. Orzeꞌ na bicy nu ya̱ gal nu ricy nur de moz nir, ne̱e̱ lo uza̱”, rnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Orzeꞌ gazeꞌ nu gush nez yu yay lo uz yu. ’Na ornu gabee zet yay, orzeꞌ uz yu bzaac yuy. Orzeꞌ gushni lagy yuy. Gazeꞌ nu gush nez yu zay za cheel yuy. Orzeꞌ bduꞌ yaay yeñ yu. Orzeꞌ bdoy chit loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Orzeꞌ yu feñ zeꞌ nay rab yu uz yu: “Tat, guch ñii ne̱ lo Ñgyoozh, nunu guch ñii ne̱ lo ru. A̱ꞌ yadaꞌñ ne̱ nu nii dey nu naca̱ iꞌñ ru”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Gazeꞌ nu uz yu bicy yu mandaar lo de moz niy. Orzeꞌ nay rab yu de moz niy: “Dzach der, gua gyii der negy nu cyit zir na. Orzeꞌ zuu der yu negy zeꞌ. Nunu rii gaꞌ der tub biꞌ yaay. Nunu caa der gyid lab gyiꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Orzeꞌ gua tee der chigud, bañ feñ nu reꞌñ zir par lo dela ma. Orzeꞌ gyicy na saꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gun iꞌña̱ ii nay gal nu na tub mbecy nu bi gut. Tees na byabañ yu. Guc yu mbecy bduneꞌ. Tees na byad yu”, nay. ¡Orzeꞌ brugyiꞌ nu ricy dey saꞌ! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Orzeꞌ lat zeꞌ iꞌñ yu yu gush zeꞌ riy lat naay. Orzeꞌ bish cyay yay. Na ornu yay bi rgaab roꞌ na, orzeꞌ güeñ yu nu rlaa musiic. Nunu rulgyiꞌ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Orzeꞌ bredz yu tub moz nu ri lo saꞌ zeꞌ. Orzeꞌ bdugyiꞌy loy la coz rac. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Orzeꞌ moz zeꞌ nay rab yuy: “Bi bri bicy ru. Orzeꞌ uz ru bicy yu mandaar nu cut dey tub chigud, bañ feñ nu reꞌñ zir par lo dela ma. Gun bicy ru bri nap yu, nunu bri ruub yu”, na moz zeꞌ rab yu yu gush zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Orzeꞌ yu gush zeꞌ tonaꞌ la guzi lagy yu. Orzeꞌ wangalagy yu ñgyuꞌy yuꞌ. Orzeꞌ gazeꞌ nu uz yu bruuy nu mnishbaay loy nu chuꞌy yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Orzeꞌ nay rab yu uz yu: “Ru rad lagy ru nu bi guzañ ñaꞌn nu ya̱ ricya̱ riiñ nir. Nunu rila wangyicya̱ nu wazuub gyidaga̱ nir. Tees ru rila wancuic ru ni tub chiib feñ par nu ñgyicya̱ saꞌ nu de amig ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tees lugaar nu ni ñgyicy nur ya̱, per ca yu re biit ru chigud, bañ feñ nu reꞌñ zir par nu gyicy ru saꞌ nu briy. Zeꞌ yu re mniit ton yu tiñ nir lo de biñ congal”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Orzeꞌ na gaꞌ uz yu rab yuy: “A uza, ru dub laa tiem nac nur ya̱, nunu dela coz nu ricy cupa̱, ndeꞌ coz nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tees na dzi nap nu gyicy na saꞌ nu gyet lagy na, gun bicy ru nay gal nu na tub mbecy nu bi gut. Tees na byabañ yu. Bi bduneꞌy, tees na byadaꞌy”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Orzeꞌ na gaꞌ Jesuuz rab mi de yu nu rsyaꞌ lom: ―Bzu tub mbecy guaniꞌñ. Nunu bzu tub moz nu byub ic de coz niy. Orzeꞌ bruu zu tub mbecy briib yu cyi ic moz zeꞌ nu rniit ton yu gyel nap ni patro̱o̱ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Orzeꞌ gazeꞌ nu patro̱o̱ niy zeꞌ bredz yu moz niy. Orzeꞌ nay rab yuy: “¿La ñuu riidz zaab nu rnii dey nir? Zeed cuen ru lo̱ de riiñ nu ricy ru, gun na wacaꞌ gac ru moz ne̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Orzeꞌ moz zeꞌ bzub yu gush yu shcab: “¿Lac mod gyicy na? Gun patro̱o̱ nin blooy riiñ yaan. Zeꞌ sac fers nin nu gyicy na riiñ ngush, nunu gat loon benu chesan diñ na gun. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na la bi rad lagy na la coz gyicy na. Gun orzeꞌ gad cyu nu cuic yuꞌ chuꞌn ornu shuub dzi nu wayicyaꞌn riiñ.” Ni mnii tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Orzeꞌ bredz yu tub ga yu nu zaab tiñ ni patro̱o̱ niy. Gazeꞌ nu nay rab yu yu nu bruꞌña loga la: “¿La be zaab ru ni patro̱o̱ ne̱?”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Orzeꞌ yu nu bruꞌña loga la zeꞌ nay rab yuy: “Ya̱ zaaba̱ gal rub tii zu tap gaynal litr asecy niy”, nay. Orzeꞌ na moz nu riib ic zeꞌ nay rab yuy: “Ii gyicy nu taꞌ de nu zaab ru. Gazeꞌ nu zub ru zaar tuubaꞌ nu niiñ nu zaab ru tiiñ zu tub gaynal litr asecy”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na ornu blazh mniiy lo yu zeꞌ na, orzeꞌ nay rab yu tuubaꞌ yu nu zaab ni patro̱o̱ niy zeꞌ: “Zeꞌ ru, ¿la be zaab ru?”, nay. Orzeꞌ yu zeꞌ nay rab yu yu nu riib ic zeꞌ: “Tub gaynal bult trig”, nay. Orzeꞌ na moz nu riib ic zeꞌ: “Ii gyicy nu taꞌ de nu zaab ru. Orzeꞌ zaar tuubaꞌ gyicy nu niiñ nu zaab ru ochent bult trig”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Orzeꞌ patro̱o̱ niy zeꞌ mniiy nu dzi lily na moz niy par nu dzi bzuy altant. Gun de mbecy nu ricy mod ni cualcyer la mbecy gyishlombecy ii, de yu zeꞌ dzi zir zu dey altant gazeꞌ de mbecy nu ricy mod nu rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ya̱ do̱o̱ rishlor lac mod gyicy nur de gyel nap nir nu yuꞌ gyishlombecy ii. Gyicy nur ñii tub mod par nu gad amig nir. Gun orzeꞌ ornu lazh de gyel nap nir, orzeꞌ gad mbecy nu nap nii nuy ru zeꞌ nu cyiiñ ru tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Gun yu nu ricy paa nu ñumiiñ, orzeꞌ niꞌ ziꞌl ricy paay nu sheñ. Nunu yu nu wagyicy paa nu ñumiiñ, niꞌ ziꞌl wagyicy paay nu sheñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Orzeꞌ benu wac gyicy cup mbecy consuel lo der nu nac gyel nap ni gyishlombecy ii, ¿orzeꞌ walab gaal gac gyicy cup Ñgyoozh consuel lo der nu nac gyel nap nu rishli? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nunu benu wayicy paa der nu suu reñaꞌ mbecy, orzeꞌ se cyu la cuic la coz nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Gun ni tub la mbecy nu ricy riiñ wagyicy yu riiñ ni cyup patro̱o̱ niy. Gun benu ni, orzeꞌ ga zi lagy yu lo tub yu. Zeꞌ tuubaꞌy cay yu. O nu gyicy paay nuy tub yu. Zeꞌ güii naañ yu lo tuubaꞌy. Orzeꞌ wac zu bich mbecy nu nac Ñgyoozh, nunu niꞌ ziꞌl wac zu bich yu nu nac de gyel nap nu yuꞌ gyishlombecy ii laab tub ziꞌl tiem ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na ornu güeñ de mbecy fariseo de coz zeꞌ na, como dzi rca dey tiñ, orzeꞌ bgubdzaa dey Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Orzeꞌ na Jesuuz: ―De ru lo mbecy ziꞌl ricy der nu dzi nap ru. Tees Ñgyoozh rad lagy mi la coz yuꞌ nañ lardoo der. Gun de coz nu rzii mbecy nu tonaꞌ la sac, par lo Ñgyoozh rila a̱ꞌ sac ñi ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Nese gulas gashtal pshuub la tiem ni Waa nu driib nis mbecy, de mbecy rshaal dey de riidz ni leey ni Moisees, gal nu de riidz ni de yu nu mnii por cuen ni Ñgyoozh. Tees nese tiem zeꞌ rshaal dey de riidz nu sac ni gyel gubier ni Ñgyoozh. Ndeꞌ nu na zigy mbecy ricy dey fers par nu chuꞌy zeꞌ nu riib ic Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Tees a̱ꞌ biigy zir nit lo baa nu gyishlombecy ii, gazeꞌ nu ricy falt nu gyuꞌ ni tub coz miꞌ ni leey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Benu tub mbecy coy gyicy rishbeey nu zaan yu mñaay, zeꞌ chelaay tuubaꞌ biñ mñaa, orzeꞌ yu zeꞌ ricy yu cyi. Nunu yu nu chelaa biñ mñaa nu bzaan ñgyee zeꞌ niꞌ ziꞌl ricy yu cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Bzu tub mbecy guaniꞌñ. Nunu tonaꞌ la negy ñgyup rzuy. Nunu de dzi la rzu baay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Zeꞌ bzu gaꞌ tub mbecy zi nu la Lázaro. Bzu laa gyedz dutuub la cuerp niy. Nunu rzub yu roꞌ ni guaniꞌñ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yu zeꞌ rgyish loy nu mas ñuu de coz nguzh nu yet lag lo yu nu goy. Nunu gal de che̱ꞌ yechaꞌ ma rleꞌ ma zeꞌ nu taꞌ gyedz niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Orzeꞌ pshuub dzi nu gut mbecy zi zeꞌ. Orzeꞌ anc ya nuy yu zeꞌ nu ri gyitoo Abraham. Niꞌ ziꞌl yu guaniꞌñ zeꞌ gut yu. Orzeꞌ pcach dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Orzeꞌ lat nu ri mbecy guaniꞌñ zeꞌ, zeꞌ nu rza mbecy gut, orzeꞌ pshes nañ ic yu bgüiiy zet. Orzeꞌ bzaac yu Abraham nu Lázaro yuꞌ dey tublaazh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Orzeꞌ brish ti nuy Abraham. Orzeꞌ nay: “¡Uza̱ Abraham, gushni ñuu lagy ya̱! Orzeꞌ zuu nez ru Lázaro nu cyid yu lo̱, gun sal yu too mbiz yu lo nis. Orzeꞌ gyicy yu nu gyag lyudza̱, gun tonaꞌ la rzac zi̱ lo gyi ii”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Orzeꞌ na Abraham rab yuy: “Uza̱, bicy nu gyezaꞌ lagy nu ru dzi gusht bzur lat nu gabee mbañ ru. Zeꞌ Lázaro ii dzi shni pcyiiñ yu. Orzeꞌ na ya̱ rica̱ consuel niy ii. Zeꞌ ru rzac zir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Zeꞌ tuubaꞌ coz, ri tub gyerlas ily cyaal nez par zeꞌ nu ru rir. Orzeꞌ benu ca na tub mbecy nu ri ii galagy yu chay par zeꞌ nu ru rir, orzeꞌ wac. Nunu niꞌ ziꞌl de yu nu ri zeꞌ nu ru rir wacaꞌ cyid dey par ii”, na Abraham. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Orzeꞌ na yu guaniꞌñ zeꞌ: “Beni orzeꞌ ya̱ nishba̱a̱ lor uza̱ Abraham nu zuu nez ru Lázaro chay yuꞌ uza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Gun zu gaay bicya̱. Orzeꞌ nii Lázaro lo dey nu gyicy cuidad dey ub yu, gun orzeꞌ cueꞌ nu gyed dey lugaar ii zeꞌ nu rzac zi mbecy”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Orzeꞌ na Abraham: “De yu zeꞌ bi ricy cup dey de riidz nu bzeeñ Moisees, nu de riidz nu bzeeñ de yu nu mnii por cuen ni Ñgyoozh. Orzeꞌ rlagy ñi nu gyicy cuen dey ñi”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Orzeꞌ na yu guaniꞌñ zeꞌ: “Laab ni uza̱ Abraham, tees benu tub mbecy gut gyabañ yu nunu gruu zac yu lat dey, orzeꞌ neꞌ dey dela cyi nu ricy yu”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tees Abraham nay: “Benu wayicy cuen dey de riidz ni Moisees gal nu de riidz ni de yu nu mnii por cuen ni Ñgyoozh, orzeꞌ niꞌ ziꞌl waguugy lardoo dey mas tub mbecy gut gyabañ yu”, nay ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Orzeꞌ Jesuuz nam rab mi de yu nu rsyaꞌ lom: ―Dub laa tiem yuꞌ coz a̱ꞌ nap nu ricy ñi nu ricy mbecy cyi. ¡Tees cuaa mbecy nu ricy yu nu gyicy de losaꞌy cyi! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nap zir benu cyiig dey tub gyitaꞌ gyech yeñ yu. Orzeꞌ shet lag dey yu lo nisyudoo. Nap zir ndeꞌ gazeꞌ nu gyicy yu nu gyicy tub yu shni cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Orzeꞌ bicy cuidad der! ’Benu tub losaꞌr ricy yu cyi, orzeꞌ shuu nur yu. Tees benu neꞌy de cyi nu ricy yu, gyicy sulagy ru niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mas tub gagy tir gyicy yu coz nu walab seꞌñ nuy ru nañ tub dzi, nunu benu tub ga gaꞌ tir cyid yu lor nunu niiy nu wayicyaꞌy de coz nu bicy nuy der zeꞌ, orzeꞌ gyicy sulagy der niy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Orzeꞌ de yu nu bloo su Shuaan na Jesuuz na dey rab yum: ―Locyuub ru de̱ nu fert zir gyicy cup de̱ consuel lor ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Orzeꞌ Shuaan na Jesuuz nam: ―Benu de ru ricy cup der consuel lo̱ mas ñuu miꞌ, gal nu na mbigy urnishtas, orzeꞌ gac nii der lo yag ily ii nu gruu lyuñ nu chañ gal lo nisyudoo. Orzeꞌ zeꞌ gzub ñi, gnii der. Orzeꞌ yag ii gyicy ñi gal nu de ru niir ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Gyicy pee lan nu zu tub moz ni ca na tub de ru. Orzeꞌ ricy yu riiñ rlaꞌy yu, o nu rñay shily. Na ornu riy yuꞌ or gudze nu guay lat naay, wanii gaal der: “Gyeed zub ru gor gyit”, niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Walab nu ni nii der, sinu niir: “Bzu lily, gun gyicya̱ che. Orzeꞌ zu bich ru nu nac ya̱ lat nu rda̱w nunu rdo̱ꞌ. Ornu lazh da̱w ya̱, orzeꞌ gow ru, nunu goꞌr”, niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Niꞌ ziꞌl waric na gras ni moz benu gyicy ziꞌl yu gal nu yad ñi nu gyicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Niꞌ ziꞌl de ru, ornu glazh gyicy der gal nu mnii Ñgyoozh nu gyicy der, orzeꞌ niir: “Gur moz ziꞌl nac de̱. Wangyicy de̱ coz ily. Nomaas bicy de̱ gal nu yad ñi nu gyicy de̱”, nii der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Orzeꞌ nez nu ya Jesuuz par Jerusaleeng, bded mi lo de yu nu ri ruꞌ bzaa ni Samaria, gal nu lo de yu ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ornu brim ruꞌ tub gyedz miꞌ, orzeꞌ bdzeel mi tii mbecy nu rat tub lo güii nu la lepra. Orzeꞌ zet yuꞌ dey ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","rbish ti nu dey mi. Orzeꞌ na dey: ―¡Jesuuz, masht, gushni ñuu lagy de̱ ya̱! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Orzeꞌ ornu Jesuuz bzaac mi dey, orzeꞌ nam: ―Gua der lo uz rlyuur ub ru, gun orzeꞌ gad lagy yu nu bi byac der ―nam. Orzeꞌ nez nu za dey byac dey ni güii zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Orzeꞌ tub yu nu gurat zeꞌ, ornu gud lagy yu nu byac yu, orzeꞌ bish cyay gua gaꞌy lo Jesuuz. Orzeꞌ ye la rniiy nu ryabic yu gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Orzeꞌ gugyit tiily yu gal lo yu la yeñ gyiꞌ Jesuuz nu rbic yu gras nim. Yu zeꞌ nac yu mbecy Samaria. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Orzeꞌ Jesuuz nam: ―¿Walab gaal walab tii mbecy byac yu? ¿Ca za se gaa de mbecy zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿A sacaꞌ zir yu nu rbic gras ni Ñgyoozh gazeꞌ mbecy ii? Ni a̱ꞌ nac yu mbecy guledz ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Orzeꞌ nam rab mi mbecy zeꞌ: ―Wes su, nunu yaa. Ru bi byac ru par nu bicy cup ru consuel lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Orzeꞌ la be mbecy fariseo bdugyiꞌ dey lo Jesuuz ben gul cyid gyel gubier ni Ñgyoozh. Orzeꞌ nam rab mi dey: ―Mod nu cyid gyel gubier ni Ñgyoozh, ndeꞌ walab mod nu zac mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wac nii mbecy nu par ii zuñ, o par re zuñ. Gun bi zu gyel gubier ni Ñgyoozh lat de ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ―Shuub dzi ornu de ru galagy der gzac der tub dzi nu ya̱, biñ nu byac mbecy, gzu̱ lat der, tees or la zeꞌ wazacaꞌ der ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Gun gruu zac mbecy nu nii dey: “Ii zum”, o “Re zum”, nii dey. Tees cueꞌ cha güii der, nunu ni cueꞌ cha ca der ich dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gun gal nu rzu gyi ni guzii baa nu ricy ñi nu rzu yaa rup chu laꞌ gaa la, orzeꞌ ni mod gyicy ya̱, biñ nu byac mbecy, ornu shuub dzi nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tees nu loga la rlagy ñi nu gzac zi̱. Nunu rlagy ñi nu gzu chu de mbecy nu yuꞌ tiem na ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Gal nu guc tiem ni Noé, orzeꞌ niꞌ ziꞌl mod gac ornu ya̱, biñ nu byac mbecy, yapa̱ tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tiem zeꞌ de mbecy nu bdow ziꞌl dey, nunu goꞌy, nunu pchelaa dey. Ni bicy dey gashtal ornu pshuub dzi nu guꞌ Noé nañ barc. Na ornu bruꞌña gyey, orzeꞌ dela dey gut yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nunu niꞌ ziꞌl guc tiem ni Lot. De mbecy row dey, nunu roꞌ dey. Rzii dey la coz, nunu rut dey la coz. Rnuuz dey la coz, nunu rzaa dey yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tees ornu bruu Lot lat gyedz Sodoma, orzeꞌ bet gyey gyi gal nu asufre. Orzeꞌ dela dey gut yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Niꞌ ziꞌl gac ornu ya̱, biñ nu byac mbecy, gruu zaca̱ tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Orzeꞌ dzi zeꞌ yu nu zub too yuꞌ, cueꞌ nu gyet yu nu coy suuy nu yuꞌ nañ yuꞌ anzir nu ruu chuy. Nunu niꞌ ziꞌl yu nu ricy riiñ lat naa, cueꞌ gaꞌ cush cyay gyay yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Byezaꞌ lagy der mñaa Lot. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gun yu nu rlagy co nap ub, yu zeꞌ gnit loy. Tees yu nu shet ic nu gat, yu zeꞌ gruu nap yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Tees ya̱ rne̱e̱ lo der nu rel zeꞌ cyup mbecy riib yu laab lo tub ziꞌl nuun nas yu. Orzeꞌ tub yu gruuy gyishlombecy ii nu gyay. Orzeꞌ tuubaꞌy gyiyeeñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na cyup biñ mñaa cam rom iiñ gyech. Orzeꞌ tub mi gruum gyishlombecy ii nu gyam. Zeꞌ tuubaꞌm gyiyeeñ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Na cyup mbecy riy ricy yu riiñ lat naay. Orzeꞌ tub yu gruuy gyishlombecy ii nu gyay. Zeꞌ tuubaꞌy gyiyeeñ yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Orzeꞌ na de yu nu rsyaꞌ lom rab yum: ―¿Ca gac de coz zeꞌ Shuaan de̱? ―na dey. Gazeꞌ nu nam rab mi dey: ―Zeꞌ nu nguaa de cuerp gut, zeꞌ gyatublaazh dela lyash ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Orzeꞌ Jesuuz mniim tub riidz tiily lo dey, gun orzeꞌ glyuum ni dey nu zaab nii nu laa dey Ñgyoozh, nunu cueꞌ shiꞌñ dey baloor. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Orzeꞌ nam: ―Tub gyedz bzu tub feez. Orzeꞌ ni wanchib lay lo Ñgyoozh, ni wanca lagy yu lo mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nunu laab gyedz zeꞌ bzu tub byud. Orzeꞌ bicy cup mi tub gyel chaꞌ ic. Orzeꞌ zaab rza lam lo feez zeꞌ nu rgyiiñ mi loy nu gyicy nuy losaꞌ yuum gal nu yad ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Orzeꞌ bi guzañ tiem feez zeꞌ wangalagy yu locyuub yum. Orzeꞌ despuees mnii tooy: “Mas ya̱ wacchiba̱ lo Ñgyoozh nunu ni waca lagya̱ lo mbecy, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tees como byud ii wachecam nu ricy seed mi ya̱, orzeꞌ ya̱ locyuuba̱m nu gad gyel fushtiz nim, gun orzeꞌ cueꞌ nu zaab cyid lam. Gun benu zaab cyid lam, orzeꞌ gyicy mi nu lazh fers ne̱”, mnii tooy ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Orzeꞌ na gaꞌ Jesuuz: ―De ru zuub gyidag der de coz nu mnii feez a̱ꞌ nap zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Beni, ¿walab gaal wabic Ñgyoozh gyel fushtiz ni de mbecy nu bi pcuim, de mbecy nu dzi rel la rnii num? Walab nu dzi tuñ laam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya̱ rne̱e̱ lor nu dzach cuic mi gyel fushtiz ni dey. Tees ornu ya̱, biñ nu byac mbecy, yapa̱ tuubaꞌ tir, ¿a gyapa̱ mbecy nu ricy cup consuel lo̱ gyishlombecy ii? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Orzeꞌ mniim tuubaꞌ riidz tiily ii lo la be mbecy nu ricy nu nac mbecy nap, zeꞌ rgüii naañ yu lo deꞌ zir losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Orzeꞌ nam: ―Cyup mbecy guay nañ yuꞌ zeꞌ nu driib zily mbecy Ñgyoozh par nu nii nu dey mi. Tub yu nac yu tub mbecy fariseo. Zeꞌ tuubaꞌy nac yu tub mbecy nu rboo tiñ por cuen ni gubier Rom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Orzeꞌ mbecy fariseo zeꞌ bzuy mnii nuy Ñgyoozh. Orzeꞌ nay: “Ñgyoozh, ya̱ rica̱ gras nir, gun ya̱ walab nu na̱ gal nu na deꞌ zir mbecy. A̱ꞌ naca̱ gubaan. A̱ꞌ naca̱ mbecy shiñ ricy. A̱ꞌ naca̱ mbecy nu ricy cyi nu biñ mñaa. Ni a̱ꞌ naca̱ mbecy nu na gal nu na mbecy ii, yu nu rboo tiñ por cuen ni gubier. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ya̱ rca̱ ne̱ nu cueꞌ da̱w gyit cyup tir nañ tub sman par nu rzu bicha̱ nu nac ru. Nunu lo tii coz nu ricya̱ gan, rlo̱o̱ tuub ñi nu drica̱ nir”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tees mbecy nu rboo tiñ por cuen ni gubier zeꞌ zet bzuy. Ni wangalagy yu shes nañ loy nu güiiy par baa, sinu pshet yu lyush yu. Orzeꞌ nay: “¡Ñgyoozh, gushni ñuu lagy ya̱, gun ya̱ naca̱ mbecy cyi!” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Orzeꞌ na gaꞌ Jesuuz: ―Ya̱ rne̱e̱ lo der nu mbecy nu rboo tiñ por cuen ni gubier zeꞌ, Ñgyoozh bicy sulagy mi niy. Orzeꞌ yay. Zeꞌ mbecy fariseo zeꞌ, Ñgyoozh wangyicy sulagy mi niy. Gun cyu ziꞌl mbecy nu ricy zily ub yu, yu zeꞌ gruu gyel mbecy niy. Zeꞌ yu nu ricy gyel gyidz ni, yu zeꞌ gyed gyel mbecy niy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Orzeꞌ la be mbecy bruꞌña nu dey yu nguzh miꞌ lo Jesuuz par nu gal yaam dey. Na ornu bzaac de yu nu rsyaꞌ lom, orzeꞌ brugyiꞌ rdzaꞌ dey ni de mbecy nu yad nu de yu nguzh miꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Orzeꞌ Jesuuz bredz mi dey. Orzeꞌ nam rab mi dey: ―Bzaan der nu gyechaꞌ de yu nguzh miꞌ lo̱. Cueꞌ niir lo dey nu ruu chuy. Gun lugaar zeꞌ nu riib ic Ñgyoozh, ndeꞌ lugaar nu yuꞌ mbecy nu na gal nu na de yu nguzh ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya̱ rishli rne̱e̱ lo der nu yu nu wazaan nu gyub ic Ñgyoozh gal nu ricy de yu nguzh ii, orzeꞌ wac chuꞌy zeꞌ nu riib ic mi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Orzeꞌ tub yu nu riib ic lat de mbecy Israeel nay rab yu Jesuuz: ―Masht nap, ¿la ñuu coz rlagy ñi nu gyicya̱ par nu cui mbaña̱ tub la? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Orzeꞌ na Jesuuz rab mi yu: ―¿Lagu rnii gaꞌ ru nu nap ya̱? Zeꞌ cyu zir nu nap, sinu tub zi la Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ru bi rad lagy ru de coz nu rnii Ñgyoozh nu gyicy yac ru. Cueꞌ gal ru mbecy nu wanchelaar. Cueꞌ cut ru losaꞌr. Cueꞌ gyicy ru gubaan. Cueꞌ riib ru gyidza too losaꞌr. Pca lagy lo uz ru, nunu pca lagy lo ñaar ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Orzeꞌ yu nu riib ic zeꞌ nay rab yum: ―Dela ndeꞌ bi bicy yaca̱ ñi nese miiñ la̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na ornu güeñ mi ndeꞌ, orzeꞌ nam rab mi yu: ―Tees ru ricy falt se tub coz nir nu gyicy ru. Yaa cut ru dela coz nu yuꞌ nir. Gazeꞌ nu tiñ zeꞌ cuic ru ni de mbecy zi. Orzeꞌ gyibaa gyad gyel nap nir. Gazeꞌ nu cyid ru cyid car icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tees ornu güeñ mbecy zeꞌ nu ni mnii Jesuuz, orzeꞌ tonaꞌ la bicy shniy, gun tonaꞌ la guaniꞌñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na ornu bzaac Jesuuz nu dzi ricy shniy, orzeꞌ nam: ―¡Dzi ga biigy nu chuꞌ mbecy guaniꞌñ lat de mbecy nu riib ic Ñgyoozh! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A̱ꞌ biigy zir ded tub camey gyeegy gyiꞌ tub gyishtiib, gazeꞌ nu chuꞌ tub mbecy guaniꞌñ lat de mbecy nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Orzeꞌ de mbecy nu güeñ zeꞌ na dey rab yum: ―Beni, ¿cyu gac gruu mbañ, beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Gazeꞌ nu nam rab mi dey: ―Coz nu wagac gyicy mbecy, tees Ñgyoozh gac gyicy mi ñii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Orzeꞌ na Bed rab yum: ―Shuaan de̱, de̱ ya̱ bzeeñ de̱ dela coz nu yuꞌ ne̱ de̱ nu yap ca̱ de̱ ich ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Orzeꞌ na gaꞌm rab mi yu: ―Ya̱ rishli rne̱e̱ lo der nu cyu ziꞌl mbecy nu bzeeñ la coz ni nu nac gyel gubier ni Ñgyoozh, orzeꞌ de yu zeꞌ sheñ zir gyad niy. De yu nu bzeeñ yuꞌ, yu nu bzeeñ mñaa, yu nu bzeeñ bicy, yu nu bzeeñ uz, yu nu bzeeñ iꞌñ, o la ziꞌl coz nu bzeeñ dey, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tees sheñ zir gad niy gyishlombecy ii, nunu tuubaꞌ lo yu zeꞌ gad nu cui mbañ yu tub la ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Orzeꞌ Jesuuz gua nu reñ mi trocyup de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―Na gyan par gyedz Jerusaleeng, gun orzeꞌ gyuꞌ niñ ni dela coz nu pcaa de yu nu mnii por cuen ni Ñgyoozh nu gzac ya̱, biñ nu byac mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gun guꞌ dey ya̱ yaa mbecy yad. Nunu de yu zeꞌ gubdzaa dey ya̱. Nunu gab zi dey ya̱. Nunu co yeñ dey lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Orzeꞌ gaaz dey ya̱ nu cuart. Gazeꞌ nu cut dey ya̱. Tees ornu zaꞌ dzi chon, orzeꞌ gyabaña̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Orzeꞌ de yu zeꞌ rila wangyet lag dey cuen de nu ndeꞌ. Ni wangad lagy dey de coz nu mniim. Tees de coz zeꞌ, ndeꞌ coz nu wangac gyet lag dey cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ornu bi rgaab Jesuuz tub gyedz nu la Jericó, orzeꞌ nez nu zam, zeꞌ zub tub mbecy lo caꞌ nu rgyiiñ yu gun. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na ornu güeñ yu nu dzi rded mbecy zigy loy, orzeꞌ bdugyiꞌy ben la coz rac. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Orzeꞌ mnii dey nu Jesuuz, biñ nu bruu Nazaret, yad mi lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Orzeꞌ brugyiꞌ rbish tiy. Orzeꞌ nay: ―¡Jesuuz, nez Dabi, gushni ñuu lagya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Orzeꞌ de mbecy nu yad lo bdzaꞌ dey niy, gun orzeꞌ gariy. Tees orzeꞌ rbish ti gaꞌ zir yu. Orzeꞌ na gaꞌy: ―¡Jesuuz, nez Dabi, gushni ñuu lagya̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Gazeꞌ nu gusum. Orzeꞌ mniim lo dey nu cha tee dey lo ca zeꞌ. Na ornu bruꞌñay lom na, orzeꞌ nam rab mi yu: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿La coz rlagy ru gyicy du̱ ru? ―nam. Orzeꞌ na lo caꞌ zeꞌ rab yum: ―Shuaana̱, rlagya̱ nu zac nap la̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Orzeꞌ na Jesuuz rab mi yu: ―¡Na gac gzac ru! Byac ru nu nac nu bicy cup ru consuel lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Orzeꞌ laab or la zeꞌ lo caꞌ zeꞌ brugyiꞌ rzac yu. Orzeꞌ za cay ich Jesuuz, nunu ryabic yu gyel mbecy ni Ñgyoozh. Nunu niꞌ ziꞌl dela mbecy nu bzaac de coz nu guc zeꞌ ryabic dey gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Orzeꞌ Jesuuz guꞌm gyedz Jericó. Orzeꞌ brugyiꞌ nu rded mi gyedz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Laab gyedz zeꞌ zu tub mbecy nu la Zaqueo. Yu zeꞌ riib ic yu de mbecy nu rboo tiñ por cuen ni gubier Rom. Nunu tonaꞌ la guaniꞌñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Orzeꞌ yu zeꞌ rlagy yu zac yu Jesuuz, tees wangac gun dzi yuꞌ mbecy. Nunu Zaqueo dzi shub yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ndeꞌ nu gush yu carer zay par lo. Orzeꞌ par nu rlagy yu gad mod nu gzac yum, orzeꞌ gup yu lo tub yag garee zeꞌ nu ded mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na ornu bded Jesuuz gyiꞌ yag zeꞌ, orzeꞌ pshes nañ lom bgüiim par ic. Orzeꞌ nam: ―Zaqueo, dzach ru bet, gun na rlagya̱ gyeche̱ yuꞌr ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Orzeꞌ Zaqueo dzach bet yu. Orzeꞌ dub gal rii la lagy yu mniiy nu gyam yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na ornu bzaac de mbecy na, orzeꞌ dela dey brugyiꞌ rnii zi dey ni Jesuuz. Orzeꞌ mnii dey nu a̱ꞌ nap ricy mi, gun cyiiñ mi lo tub mbecy cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Orzeꞌ Zaqueo wes suy. Orzeꞌ nay rab yu Shuaan na Jesuuz: ―Shuaana̱, lo dela coz nu yuꞌ ne̱, ya̱ grica̱ cyaal ni de mbecy zi, nunu benu ya̱ bicy gubaana̱ coz ni ca na tub mbecy, orzeꞌ tap tant gyabica̱ niy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Orzeꞌ na Jesuuz: ―Dzi na gruu mbañ de mbecy nu yuꞌ yuꞌ ii. Nunu gazaꞌ mbecy ii nac yu nez Abraham. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gun ya̱, biñ nu byac mbecy, yapa̱ gyishlombecy par nu yuba̱ de mbecy nu bduneꞌ, nunu par nu gloo mbaña̱ dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Orzeꞌ de mbecy zeꞌ rzuub gyidag dey de coz nu rnii Jesuuz. Orzeꞌ brugyiꞌ rniim tub riidz tiily lo dey, gun lugaar zeꞌ gaab ga Jerusaleeng, nunu de mbecy zeꞌ mnii too dey nu laab or la zeꞌ cyid gyel gubier ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Orzeꞌ nam rab mi dey: ―Bzu tub mbecy. Orzeꞌ yu zeꞌ famil ni rey. Orzeꞌ mbecy zeꞌ bruuy zay tub lugaar zet. Zay gashtal tuubaꞌ nasyoong par nu gac yu rey ni de mbecy nu yuꞌ lugaar zeꞌ. Orzeꞌ grii gaꞌy ledz yu zeꞌ nu bruuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Orzeꞌ anzir nu chay, orzeꞌ bredz yu tii moz niy. Orzeꞌ bzeeñ yu tub nac gaa la tiñ yaa tub ga dey. Orzeꞌ nay rab yu dey: “Gyicy der dalje̱z nu de tiñ nu brica̱ ni der ii gal shuub la dzi nu cush cya̱ tuubaꞌ tir”, nay rab yu de moz niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na lugaar zeꞌ nu zay nu gac yu rey zeꞌ, de mbecy zeꞌ wangyet lagy dey yu. Orzeꞌ bzuu nez dey la be mbecy nu chay lo rey zeꞌ nu cha niiy: “De̱ ya̱ walagy de̱ nu mbecy ii gac yu rey ne̱ de̱”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Tees yu zeꞌ guꞌy nu gac yu rey. Gazeꞌ nu bish cya gaꞌy briy ledz yu. Na ornu briy na, orzeꞌ bredz yu de moz niy, de yu nu bzeeñ yu tiñ yaa zeꞌ, par nu gad lagy yu la be bicy tub ga dey gan. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Orzeꞌ bruꞌña mbecy loga la. Orzeꞌ nay: “Tiñ nu bzeeñ ru lo̱, ndeꞌ byañ ñii. Byac ñi tii tant”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Orzeꞌ rey zeꞌ nay rab yuy: “Nap tonaꞌ la bicy ru. Ru nac ru tub moz nap. Par nu ru bicy paar nur ñumiiñ, orzeꞌ ndeꞌ nu gyicya̱ nu ru gyub ic ru tii gyedz”, na rey zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Orzeꞌ bruꞌña tuubaꞌy. Orzeꞌ nay: “Shuaana̱, byañ tiñ nir. Byac ñi gaay tant”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Orzeꞌ na rey zeꞌ rab yu moz niy: “Ya̱ gyicya̱ nu ru gyub ic ru gaay gyedz”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Orzeꞌ bruꞌña tuubaꞌy. Orzeꞌ nay: “Shuaana̱, ii yap du̱ tiñ nir. Bduꞌ choowa̱ ñii nañ tub bay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gun ya̱ gudziba̱ lor, gun ru nac ru mbecy cyigy lardoo, gun ru gyash ru coz nu walab nir, nunu ru rteꞌr zeꞌ nu walab ru rnuuz ru”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Orzeꞌ rey zeꞌ nay: “Moz a̱ꞌ nap, nu nac riidz nu rniir ya̱ ne̱e̱ nu yuꞌ falt nir. Benu rad lagy ru nu naca̱ mbecy cyigy lardoo, benu rad lagy ru nu gyasha̱ coz nu walab ne̱, benu rad lagy ru nu rte̱ꞌ zeꞌ nu walaba̱ mnuuza̱, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿orzeꞌ lagu wancha nur tiñ ne̱ nañ banc? Orzeꞌ ornu ya̱ nri̱ yu̱ꞌ, orzeꞌ ñgyabic ru ne̱ nu iꞌñ ñi”, na rey zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Orzeꞌ na gaꞌ rey zeꞌ rab yu deꞌ zir mbecy nu yuꞌ lugaar zeꞌ: “Bloo der tiñ niy. Orzeꞌ briic der ñii ni yu nu bicy gan tii tant”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Orzeꞌ na dey: “Shuaan de̱, yu zeꞌ bi ricy cup yu tii tant”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Orzeꞌ na rey zeꞌ rab yu dey: “Tees ya̱ rne̱e̱ lo der nu yu nu ricy cup sheñ, sheñ zir gad niy. Tees yu nu sac ni, gashtal coz miiñ nu ricy cup yu gruuñ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na de losaꞌ yu̱u̱, de yu nu wangalagy nu gaca̱ rey ni zeꞌ, da nu der yu ii. Orzeꞌ biit der yu ii lo rgüi̱i̱ la̱”, nay ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na ornu blazh mniim de coz zeꞌ na, orzeꞌ gush nezaꞌm zam par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Orzeꞌ bruꞌñam tub lugaar gaab ga tub gyedz nu la Betfagé nu tuubaꞌ gyedz nu la Betania. Lugaar zeꞌ gaab ga bicy ni Ya Oliva. Orzeꞌ zeꞌ bzuu nez mi cyup de yu nu rsyaꞌ lom nu cha ga dey lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Orzeꞌ nam rab mi dey: ―Gua der gal gyedz miꞌ nu ri par lo zeꞌ. Orzeꞌ ornu gruꞌña der lugaar zeꞌ, orzeꞌ gyap der tub bur ca cuñ ma, bañ nu nigul gyub la mbecy. Orzeꞌ shaagy der ma. Gazeꞌ nu cyid nu der ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Benu ca na mbecy niiy lo der: “¿Lagu rshaagy der bur zeꞌ?” niiy, orzeꞌ nii der, “Shuaan na cyiiñ ma nim”, nii der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Orzeꞌ de yu nu rsyaꞌ lom gua dey, nunu byap dey bur zeꞌ gal nu mnii Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na lat nu rshaagy dey bur zeꞌ, orzeꞌ na yu nu guni ma rab yu dey: ―¿Lagu rshaagy der bur zeꞌ? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Orzeꞌ de yu zeꞌ nay: ―Shuaana̱ cyiiñ ma nim. Ndeꞌ nu rshaagy de̱ ma ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Orzeꞌ gazeꞌ nu za nu dey ma lo Jesuuz. Gazeꞌ nu briib dey shab yu ich ma. Orzeꞌ pshup dey mi ich ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Orzeꞌ lat nu zaab za lam, orzeꞌ de mbecy rcuaa dey shab yu nez nu zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na ornu bruꞌñam gaab ga zeꞌ nu gyet nez par gyiꞌ bicy ni Ya Oliva, orzeꞌ dela mbecy nu za ca ich mi brugyiꞌ nu rbish ti dey nu yet lagy yu. Nunu ii ryabic dey gyel mbecy ni Ñgyoozh nu nac de nusuriidz nu bzaac dey nu bicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Orzeꞌ na dey: ―¡Dzi ni biñ nu bzuu nez Ñgyoozh nu gac rey ni den! ¡Dela anc nu yuꞌ gyibaa nap zu lagy dey! ¡Rlagy ñi gyabic den gyel mbecy ni Ñgyoozh, biñ nu gya zir zu! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Orzeꞌ la be mbecy fariseo nu yuꞌ lat de mbecy zigy zeꞌ na dey rab yu Jesuuz: ―Masht, bdzaꞌ ni de mbecy nu yad ca ich ru ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Orzeꞌ nam rab mi dey: ―Ya̱ ne̱e̱ lo der nu benu de yu ii gari dey nu cush tiy, orzeꞌ gashtal de gyitaꞌ ii cush tiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na ornu bi rgaab rim Jerusaleeng, orzeꞌ bgüiim par lat gyedz. Orzeꞌ ruun mi nu nac de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Orzeꞌ nam: ―¡Dzi ga nap bicy na nu ru gyet lag ru cuen ni de riidz nu cuic gyel ri zu dzi na! Tees wagyet lag ru cuen ni de riidz zeꞌ. Orzeꞌ wac zac ru gyel ri zu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na cyid tub dzi nu gri loꞌ de losaꞌ yuur. Orzeꞌ soow dey dela nez nu ruu der. Orzeꞌ dub yub la shet yaa dey ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Orzeꞌ gnit lo zaꞌ la dey ru. Cut dey de mbecy ledz ru. Nunu ni tub gyitaꞌ wazeeñaꞌ dey ñi too losaꞌñ. Ni zac ru, gun wancuꞌ lor Ñgyoozh ornu biid mi nu co mbañ mi ru ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na ornu blazh ndeꞌ na, orzeꞌ gazeꞌ nu guꞌ Jesuuz nañ yuꞌ nu driib zily mbecy Israeel Ñgyoozh. Orzeꞌ brugyiꞌ rboom de mbecy nu nguaa rut nañ yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Orzeꞌ nam rab mi dey: ―Lat de riidz ni Ñgyoozh rniiñ: “Yuꞌ ne̱ gruu lañ yuꞌ nu gnii nu mbecy ya̱. Zeꞌ de ru ricy der ñii nu nañ gal na tub blyuu ni gubaan”, rniiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Orzeꞌ de dzi la Jesuuz rlyuum ni de mbecy nañ yuꞌ nu driib zily dey Ñgyoozh. Orzeꞌ de yu zub lo ni uz, gal nu de yu nu rlyuu leey, gal nu de yu zub lo ni de mbecy gyedz, gusa dey nu ryub dey lac mod cut dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tees wangad mod nu ni ñgyicy dey, gun dela mbecy nap rzuub gyidag dey ni de coz nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tub dzi Jesuuz rim nañ yuꞌ nu driib zily mbecy Ñgyoozh. Rlyuum ni de mbecy nunu rshaal mi de riidz nu rbic gyel mbañ. Gazeꞌ nu bruꞌña de yu nu riib ic de uz, nu de yu nu rlyuu leey ni Ñgyoozh, gal nu de yu bel ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Gazeꞌ nu na dey rab yum: ―¿La na rishbeey ricy cup ru nu ricy ru de coz ii? ¿Cyu briic rishbeey zeꞌ nir? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Orzeꞌ na gaꞌ Jesuuz: ―Niꞌ ziꞌl ya̱ dugyi̱ꞌ ga̱ꞌ tub coz lo der. Mnii lo̱: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cyu bzuu nez Waa nu guay briib nis yu mbecy? ¿A Ñgyoozh bzuu nez mi yu, uti mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Orzeꞌ brugyiꞌ nu ro dey riidz nu losaꞌy. Orzeꞌ na dey: “Benu niin nu Ñgyoozh bzuu nez mi yu biid yu, orzeꞌ niiy: ¿Lagu wancheña lagy der de riidz nu mniiy, beni?, niiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nunu wac niin nu mbecy bzuu nez dey yu, gun dzi ga cut mbecy de ub na nu gyitaꞌ, gun dela dey rzu fert dey nu Waa mniiy por cuen ni Ñgyoozh”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Orzeꞌ ndeꞌ nu mnii dey nu wangad lagy dey cyu bzuu nez Waa nu griib nis yu mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Orzeꞌ Jesuuz nam rab mi dey: ―Benu ni, niꞌ ya̱ wane̱e̱ la rishbeey ricy cupa̱ nu ricya̱ de nu nii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gazeꞌ nu lueg la Jesuuz brugyiꞌ rniim nu riidz tiily lo de mbecy. Orzeꞌ nam rab mi dey: ―Bzu tub mbecy nu mnuuz tub nac lyucy urbyay. Gazeꞌ nu briic yu nu ndeꞌ par coz cyaal ni tuubaꞌ mbecy. Gazeꞌ nu gush nez yu zay byaj tuñ tiem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na ornu byap tiem nu dulag urbyay zeꞌ na, orzeꞌ bzuu nez yu tub moz niy lo de yu nu gush coz cyaal zeꞌ par nu cha gyiy ca na de coz nu bruu lo de lyucy urbyay zeꞌ, ca na nu dugyiy. Tees de yu zeꞌ bgaaz dey moz zeꞌ nunu dzi lay bzuu nez dey yu yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Orzeꞌ gazeꞌ nu yu nu guni lyucy urbyay zeꞌ bzeed yu tuubaꞌ moz niy. Tees niꞌ ziꞌl yu zeꞌ mnii zi dey niy, nunu bgaaz dey yu, nunu niꞌ ziꞌl dzi lay bzuu nez dey yu yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Gazeꞌ nu bzeedaꞌ yu nu guni lyucy urbyay zeꞌ tuubaꞌ moz. Orzeꞌ yu zeꞌ pcad güii dey yu, nunu bloo dey yu lat lyucy urbyay zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Laab ndeꞌ la, orzeꞌ na yu nu guni lyucy urbyay zeꞌ: “Zeꞌ na, ¿lac gyicya̱? Orzeꞌ ya̱ zeeda̱ iꞌña̱ nu dzi rca̱ nu chay lo dey. Ca gaal lagy dey loy, gun yu re iꞌña̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tees ornu de yu zeꞌ bzaac dey iꞌñ yu nu guni lyucy urbyay zeꞌ, orzeꞌ na dey rab yu losaꞌy: “Yu re gyeñ nuy gyel nap ni uz yu. Yaa der chan dut nay, gun orzeꞌ gyeñ gyel nap zeꞌ ni den”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Orzeꞌ bduꞌ yaa dey yu zeꞌ. Bloo dey yu lat lyucy urbyay zeꞌ. Orzeꞌ biit dey yu. ’¿Na lac gyicy yu nu guni lyucy urbyay zeꞌ nu de yu nu mnuuz coz cyaal zeꞌ rsaꞌ lagy der? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na chay cut yu dela yu nu mnuuz coz cyaal zeꞌ. Orzeꞌ zeeñ yu lyucy urbyay zeꞌ yaa reñaꞌ mbecy ―nam rab mi dey. Na ornu güeñ dey de coz nu mniim zeꞌ, orzeꞌ na dey: ―¡Cueꞌ nu ni gac ñii! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Orzeꞌ Jesuuz bgüiim lo dey. Orzeꞌ nam rab mi dey: ―Beni lac mod yaruu de riidz ni Ñgyoozh zeꞌ nu rniiñ: Gyitaꞌ nu mneꞌ biryu, byac ñi gyitaꞌ nu ricy zir ñi presis rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Cyu ziꞌl mbecy nu gyes saa lo gyitaꞌ zeꞌ, orzeꞌ gzug lay. Zeꞌ benu gyitaꞌ zeꞌ gyet lag ñi too ca na mbecy, orzeꞌ gyagyez la mbecy zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Orzeꞌ de uz zub lo gal nu de yu nu rlyuu leey ni Ñgyoozh ngulagy dey nguꞌ yaa dey Jesuuz laab or la zeꞌ, gun gud lagy dey nu lo dey pcaam ornu mniim riidz tiily zeꞌ. Tees wancuꞌ yaa dey mi, gun rdzib dey lo de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Orzeꞌ psiiñ dey ni Jesuuz. Orzeꞌ bzuu nez dey la be mbecy nu chay lom. Orzeꞌ mbecy zeꞌ bicy dey tub mod nap par lo Jesuuz, tees gal nu bduꞌ cuen ziꞌl dey mi ben a wad mod nu guꞌ dey mi yaa de yu nu riib ic por cuen ni gubier. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Orzeꞌ na dey rab yum: ―Masht, de̱ ya̱ rad lagy de̱ nu de coz nu rniir gal nu de coz nu rlyuur, ndeꞌ coz rishli, nunu wagyicy cuen ru la na tub ga mbecy, sinu rlyuur mod nu rlagy Ñgyoozh nu chuꞌ den nu rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿A gruu nap ñi nu griib den tiñ nu rbic dey ni yu nu riib ic de nasyoong, uti waruu nap ñi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tees Jesuuz bi gud lagy mi nu walab nu dutuub la lardoo dey rniiy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Orzeꞌ nam rab mi dey: ―Blyuu der tub tiñ lo̱. ¿Cyu nab ca lo tiñ ii? Nunu ¿cyu nu la ca looñ? ―nam. Orzeꞌ na dey: ―Lo César, yu nu riib ic de nasyoong, gal nu nu lay ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gazeꞌ nu nam rab mi dey: ―Briic der ni yu nu riib ic de nasyoong coz nu nac niy. Nunu briicaꞌ der ni Ñgyoozh coz nu nac nim ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Orzeꞌ wangad mod nu riib dey cyi ic mi nu nac de coz nu mniim lo dela mbecy, sinu se za nu ziꞌl ic dey yuꞌy. Orzeꞌ wannii gaꞌ la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Gazeꞌ nu gua la be mbecy saduceo gua güii dey Jesuuz. Na de mbecy saduceo rnii dey nu ornu gat mbecy, orzeꞌ wayabañ dey. Orzeꞌ ndeꞌ nu bdugyiꞌ dey lo Jesuuz. Orzeꞌ na dey rab yum: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Masht, Moisees pcaay par dela den nu benu tub mbecy gat bicy yu, nunu zeeñ yu mñaay, zeꞌ sac iꞌñ mi, orzeꞌ mbecy zeꞌ rlagy ñi chelaay mñaa bicy yu nu gut zeꞌ par nu cuic yu iꞌñ mi por cuen ni bicy yu yu nu gut zeꞌ, na Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Orzeꞌ bzu gagy mbecy nuy bicy yu. Orzeꞌ yu loga la guud mñaay. Orzeꞌ gut yu nunu wangyeeñ iꞌñ yu ni mñaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Orzeꞌ yu cyup zeꞌ pchelaa gaꞌy mi. Orzeꞌ niꞌ ziꞌl gutaꞌy, nunu wangyeeñ iꞌñ yu ni biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Orzeꞌ niꞌ ziꞌl yu chon pchelaa gaꞌy nu biñ mñaa zeꞌ. Orzeꞌ zaꞌ gagy laa dey pchelaay mi. Tees wangyeeñ iꞌñ ni tub la dey nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Laab ndeꞌ la, orzeꞌ biñ mñaa zeꞌ gutaꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na ornu shuub dzi nu gyabañ de mbecy gut, ¿ca na dey zeꞌ gac mñaay biñ mñaa zeꞌ? Gun zaꞌ gagy laa dey pchelaay mi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Orzeꞌ na Jesuuz rab mi dey: ―Gyishlombecy ii de yu gyeey, nu de biñ mñaa rchelaa dey losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tees de yu gyeey nu de biñ mñaa nu yad ñi nu gyabañ gri dey tuubaꞌ lo yu, de yu zeꞌ wachelaa gaꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gun orzeꞌ wataꞌ dey, sinu chuꞌ dey gal nu yuꞌ de anc, nunu gyac dey iꞌñ Ñgyoozh nu nac nu gyabañ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gun laab Moisees bicy yu nu bi gud lagy na nu gyabañ de mbecy nu bi gut lat de riidz nu bzeeñ yu ni yag nu rca gyi zeꞌ. Lat de riidz zeꞌ mnii Moisees nu Shuaan na nac mi Ñgyoozh ni Abraham, nac mi Ñgyoozh ni Isaac, nunu nac mi Ñgyoozh ni Jacob, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gun Ñgyoozh a̱ꞌ nac mi Ñgyoozh ni mbecy nu bi byaꞌ lo la, sinu nac mi Ñgyoozh ni mbecy nu gabee zu, gun par mi zeꞌ dela mbecy gabee zu dey ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Orzeꞌ la be de mbecy nu rlyuu leey ni Ñgyoozh nu yuꞌ zeꞌ na dey: ―Masht, tonaꞌ la nap mniir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gun wancuicaꞌ dey baloor nu ngugyiꞌ zir yu lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Orzeꞌ Jesuuz nam rab mi dey: ―¿Lagu rnii dey nu Mesías, biñ nu ca lo cuen nu cyid, gruum lat nez Dabi? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gun laab Dabi mniiy tub riidz lo libr ni Salmos. Orzeꞌ nay: Ñgyoozh nam rab mi Shuaana̱, Gzub ru lugaar ni mbecy nu gya zir zu, par yaa be̱e̱ ii, ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Gashtal gyicy la̱ nu gyicy ru gan losaꞌ yuur, nam, na Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Orzeꞌ ¿lac mod gruu Mesías lat nez Dabi, benu ub la Dabi rniiy rab yum: “Shuaana̱”, rniiy? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Orzeꞌ dela de mbecy yuꞌ dey rzuub gyidag yu ni Jesuuz. Orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Cuidad der nu de mbecy nu rlyuu leey ni Ñgyoozh. Gun de yu zeꞌ yet lagy dey chesay nu shab duñ yu, nunu yet lagy dey nu rca lagy mbecy loy ornu rnii nu dey yu lat yagyiꞌ. Nunu gusht ni dey nu gzub yu lo yashily ni de mbecy nu ricy ñi presis nañ yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh. Nunu yet lagy dey lugaar ni de mbecy lily zeꞌ nu yuꞌ saꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tees rboo dey yuꞌ byud. Orzeꞌ par nu rsoow su dey lo de coz a̱ꞌ nap nu ricy nu dey byud zeꞌ, orzeꞌ chi rnii nu dey Ñgyoozh. Ndeꞌ nu cashtig ily zir gad ni dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Orzeꞌ Jesuuz zum rgüiim lo de mbecy guaniꞌñ lat nu rguꞌ dey tiñ gun nañ alcansi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Gazeꞌ nu bzaac mi nu pshet lag tub byud nu dzi gyel zi zu cyup sentab miꞌ nañ alcansi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Orzeꞌ nam: ―Ya̱ rishli rne̱e̱ lo der nu byud re mas gyel zi zum, tees sheñ zir briic mi gazeꞌ deꞌ zir mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gun dela mbecy rbic yu tiñ nu drusub ziꞌl niy. Zeꞌ byud re gyel zi zum. Tees briic mi dela tiñ nu rcyiiñ nim par nu cui mbañ mi ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Orzeꞌ la be de yu nu rsyaꞌ lo Jesuuz ro dey riidz nu losaꞌy nu nac yuꞌ nu driib zily mbecy Ñgyoozh. Rnii dey nu tonaꞌ la cyit na de gyitaꞌ nu gup ñi, nunu rnii gaꞌ dey nu cyit na lo gyitaꞌ nu bdudii nu gun nu briic mbecy. Orzeꞌ na Jesuuz rab mi dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Shuub tub dzi nu de yuꞌ nu rzac der ii dudily ñi. Ni tub gyitaꞌ wayeñ ñi too losaꞌñ, sinu delañ nit loñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Orzeꞌ de yu nu rsyaꞌ lom bdugyiꞌ dey lom. Orzeꞌ na dey rab yum: ―Masht, mnii lo̱ de̱. ¿Gul gac de coz nu mniir zeꞌ? Nunu ¿la na muesht gruu zac ornu bi zuu lañ nu gac de coz zeꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Orzeꞌ na Jesuuz rab mi dey: ―Bzu der cuidad nis guu mbecy der, gun tonaꞌ la zigy mbecy gruu zac yu nu gash yu nu la̱. Nii dey nu “Ya̱ naca̱ mi zeꞌ”, niiy. Nunu nii gaꞌ dey nu “Na bi pshuub tiem”, niiy. Tees cueꞌ cha ca der ich yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na ornu gyeñ der nu yuꞌ gyel yuu, orzeꞌ cueꞌ dzib der, gun ndeꞌ coz nu rlagy ñi nu gac nu loga la. Mas ni, tees walab nu bi pshuub la dzi zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Orzeꞌ na gaꞌm: ―Gun tub nac mbecy chuꞌy gyel yuu nu tub nacaꞌ mbecy. Nunu tub gubier chuꞌy gyel yuu nu tuubaꞌ gubier. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Grib duru ily. Nunu cyid cubiñ. Nunu chuꞌ güii zañ lugaar ni gyishlombecy. Nunu baa gruu zac coz nu dzib mbecy. Nunu tonaꞌ la muesht ily gruu zac. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Tees anzir nu gac de coz zeꞌ, orzeꞌ shet yaa dey de ru. Nunu shet zi dey der. Orzeꞌ cha nu dey der nañ yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh. Orzeꞌ zeꞌ gri bee dey ni der. Gazeꞌ nu neꞌ dey der nañ yuꞌ gyiib. Nunu cuꞌ cyi dey der lo yu nu riib ic por cuen ni gubier gal nu lo de rey nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Gun orzeꞌ gad mod nu gzat der ya̱ lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Orzeꞌ bicy der tub mod nu cueꞌ zu lily der ben lac mod niir anzir nu char lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Gun ya̱ grica̱ riidz nu gnii der. Orzeꞌ par nu dzi nap gnii der, orzeꞌ rila wad mod nu gnii de losaꞌ yuu der nu walab ni gal nu nii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tees zigy mbecy cush cya dey ich der. Gazaꞌ uz der, nu bicy ru, nu de famil ni der, nu de amig nir, dela de yu zeꞌ cush cya dey ich ru. Orzeꞌ cut dey ca na de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nunu dela mbecy gazi lagy dey lo der nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tees de ru ni tub gyich too der waduneꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Orzeꞌ bzu fert der, gun orzeꞌ ni mod gad nu gruu mbañ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ornu gzac der nu dub yub la ruꞌ gyedz Jerusaleeng bi bri loꞌ soldad, orzeꞌ gad lagy der nu sñuu ga gnit loñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Orzeꞌ de yu nu yuꞌ lo yu ni Judea, rlagy ñi nu ruu chu dey par logyiꞌ. Nunu de yu nu yuꞌ lat gyedz Jerusaleeng rlagy ñi nu ruu dey lat gyedz zeꞌ. Zeꞌ de yu nu ricy riiñ lat naa walagy ñi nu gyay par lat gyedz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gun tiem zeꞌ, ndeꞌ tub tiem nu cuic Ñgyoozh cashtig, gun orzeꞌ gyuꞌ niñ gal nu bi cañ lat de riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Cuaa de biñ mñaa nu segyi zu tiem zeꞌ! Nunu, ¡cuaa gaꞌ de biñ nu rgaagy mdoo tiem zeꞌ! Gun tonaꞌ la gzac zi mbecy lugaar ii. Nunu Ñgyoozh tonaꞌ la cashtig ily cuic mi ni de mbecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yuꞌ mbecy nu gat nu mandzicy. Nunu yuꞌ gaꞌ mbecy nu cha nu dey pres de ga la zeꞌ ni gyishlombecy. Orzeꞌ de mbecy nu walab mbecy Israeel gzuub gyiꞌ dey gyedz Jerusaleeng gal shuub la dzi nu gyaꞌ lo tiem nu briic Ñgyoozh ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Orzeꞌ gruu zac muesht lo doo, nu lo beey, gal nu lo de bel nu taꞌ baa. Nunu dela mbecy nu yuꞌ lo yu lazh la consuel ni dey. Nunu dzib dey nu dzi siigy nisyudoo gal nu de nguuly loñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Orzeꞌ de mbecy csuun ñi dey nu dzib dey ornu gash dey shcab de coz nu gac gyishlombecy. Nunu gashtal dela fers nu nash baa cueñ ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Orzeꞌ gazeꞌ nu gzac dey ya̱ biñ nu byac mbecy yapa̱ lat za. Gzac dey nu gac gyicya̱ coz ily. Nunu tonaꞌ la lily na. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ornu cugyiꞌ nu gac dela coz zeꞌ, orzeꞌ briic der baloor, nunu pshes nañ too der, gun sñuu ga bi gla der lo de coz a̱ꞌ nap ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Orzeꞌ gazeꞌ nu Jesuuz mniim tub riidz tiily lo dey. Orzeꞌ nam: ―Bduꞌ cuen der mod nu ricy ya las o ca ziꞌl na yag. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ornu bi rgaꞌñ nu driib lyag niñ, orzeꞌ de ru bi rad lagy der nu bi yad tiem zig. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Orzeꞌ niꞌ ziꞌl mod, ornu gzac der nu gac de coz zeꞌ, orzeꞌ gad lagy der nu sñuu ga cyid gyel gubier ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ya̱ rishli rne̱e̱ lo der nu dela coz zeꞌ gac ñii anzir nu gat dela mbecy nu yuꞌ tiem zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Baa nuñ gyishlombecy ii, delañ ded niñ, tees riidz nu ya̱ rne̱e̱, ndeꞌ rila waded niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Bicy cuidad der nis zaan der nu gyacyigy lardoo der nu nac de bis, nu nac nu gzugy der, nu nac nu sug ic der, nu nac coz ni gyishlombecy ii. Gun orzeꞌ sij ziꞌl gruu zac dzi zeꞌ ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","gal nu ricy tub caa. Gun gruu zac ñi lo dela mbecy nu yuꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Orzeꞌ bzu der altant, nunu mnii nu der Ñgyoozh dub laa tiem, gun orzeꞌ gad tub mod nu cueꞌ gzac der lo dela coz nu gac zeꞌ, nunu orzeꞌ gac gyechaꞌ der lo ya̱, biñ nu byac mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Orzeꞌ Jesuuz rlyuum ni de mbecy orwi doo nañ yuꞌ nu driib zily dey Ñgyoozh. Zeꞌ or yecheñ, orzeꞌ rzam too bicy nu la bicy ni Ya Oliva. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Orzeꞌ ornu rzaꞌ yu, orzeꞌ dela mbecy rza dey nañ yuꞌ nu driib zily dey Ñgyoozh par nu rzuub gyidag dey de coz nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Orzeꞌ tiem zeꞌ bi rgaab chuꞌ saꞌ nu gow dey gyishtily nu sac lebadur. Saꞌ zeꞌ, ndeꞌ rnii dey saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Orzeꞌ de uz zub lo, gal nu de yu nu rlyuu leey ni Ñgyoozh ryub dey mod nu cut dey Jesuuz, tees rdzib dey lo mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Orzeꞌ nuras guꞌy nañ lardoo Judas, tub yu nu bruu laab lat de trocyup yu nu bloo sum zeꞌ. Yu zeꞌ lay Judas Iscariote. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Orzeꞌ yu zeꞌ guay lo de uz zub lo, gal nu lo de yu nu riib ic nañ yuꞌ nu driib zily mbecy Ñgyoozh. Orzeꞌ mniiy lo dey nu lac mod gyicy yu nu guꞌy Jesuuz yaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Orzeꞌ de yu zeꞌ tonaꞌ la bet lagy dey. Orzeꞌ mnii dey nu cyish dey tiñ ni Judas. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Orzeꞌ Judas “O” nay. Orzeꞌ brugyiꞌ ryub yu tub mod nu nap nu guꞌy Jesuuz yaa de yu nu rzi lagy lom. Byub yu tub mod nu cueꞌ nu gad lagy de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Orzeꞌ pshuub dzi ni saꞌ nu row dey gyishtily nu sac lebadur. Dzi zeꞌ rut dey shily ni saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Orzeꞌ bzuu nez mi Bed nu Waa nu cha dey tub riiñ. Orzeꞌ nam rab mi dey: ―Gua der gun zu lily ru nu gyicy den che ni saꞌ ni Pas ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Orzeꞌ na dey rab yum: ―¿Ca rlagy ru nu cha̱ de̱ nu gzu lily de̱? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Orzeꞌ nam rab mi dey: ―Ornu chuꞌ der lat gyedz, orzeꞌ zeꞌ dzeel der tub mbecy nu ya nu tub reꞌ nis. Orzeꞌ ich yu zeꞌ cha ca der gal grii lay yuꞌ zeꞌ nu chuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Orzeꞌ niir gab ru shuaan yuꞌ zeꞌ: “Masht mniim nu yap tugyi̱ꞌ lor ben ca na cuart nu gow mi gyit nu gyicy mi che ni saꞌ ni Pas nu de̱ ya̱, mbecy nu rsyaꞌ lom”, niir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Orzeꞌ gazeꞌ nu yu zeꞌ lyuuy tub cuart ily nu zub gya. Orzeꞌ zeꞌ bi nguaa dela coz nu cyiiñ nañ ñi. Orzeꞌ zeꞌ zu ye der nu dow den comid ni saꞌ ni Pas ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gazeꞌ nu de yu zeꞌ gua dey lat gyedz. Orzeꞌ bzaac dey nu guc ñi gal nu mnii Jesuuz. Orzeꞌ zeꞌ bzu ye dey nu gyicy dey che ni saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na ornu byap or nu gyicy mi che na, orzeꞌ gusub mi lo mez nu de aposht nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Orzeꞌ nam rab mi dey: ―¡Ya̱ tonaꞌ la rlagya̱ nu gyicy du̱ de ru che ni saꞌ ni Pas ii anzir nu ya̱ gata̱! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ya̱ rne̱e̱ lo der nu ya̱ rila wayicaꞌ che du̱ de ru gashtal shuub la dzi nu gyicya̱ ñii mod nu rlagy ñi zeꞌ nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gazeꞌ nu gush mi tub taz. Orzeꞌ brugyiꞌ rbic mi gras ni Ñgyoozh nu nac ñii. Orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ―Gush der nu nii, nunu briic der nu goꞌ tub ga losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya̱ rishli rne̱e̱ lo der nu rila wado̱ꞌ ga̱ꞌ ñup ni urbyay gal do̱ꞌ la̱ ñup cub zeꞌ nu riib ic Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Gazeꞌ nu gushaꞌm tub gyishtily. Orzeꞌ briic mi gras ni Ñgyoozh nu nac ñii. Gazeꞌ nu blew mi ñii briic mi ni dey. Orzeꞌ nam rab mi dey: ―Nii cuerp ne̱ nu rica̱ nu gat par nu gruu mbañ der. Mod ii gyicy der par nu gyezaꞌ lagy der ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Orzeꞌ ornu blazh nu bdow dey, orzeꞌ niꞌ ziꞌl bicy mi nu tub taz ñup urbyay. Orzeꞌ nam rab mi dey: ―Nii tub trat cub nu gyicy Ñgyoozh nu de mbecy nu nac nu shu reña̱. Nunu shu reña̱ par nu gruu mbañ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tees laab lo mez nu zuba̱ ii na, zub yu nu cush cya icha̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tees ya̱, biñ nu byac mbecy, gata̱, gun ndeꞌ coz nu rlagy Ñgyoozh nu gzaca̱. Tees ¡cuaa yu nu cush cya icha̱! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Orzeꞌ de yu nu rsyaꞌ lom brugyiꞌ nu rgugyiꞌ dey lo losaꞌy ben ca na dey cush cyay ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Orzeꞌ de yu nu rsyaꞌ lom bee dey riidz nu losaꞌy ben ca na yu nu gya zir zu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Orzeꞌ na Jesuuz rab mi dey: ―Lat de mbecy nu a̱ꞌ yuꞌ lo Ñgyoozh, de rey ricy yu mandaar de mbecy ledz yu, nunu rnii dey “Patro̱o̱” par mbecy nu ricy mandaar, rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tees lat de ru walab ni mod rlagy ñi gyicy der, sinu lat de ru yu nu gya zir zu gal gaa la zuy nu de yu feñ. Nunu yu nu riib ic rlagy ñi gyicy yu gal nu ricy de moz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Orzeꞌ ¿ca na yu nu gya zir zu: yu nu gzub lo mez o ti yu nu csaa gyaꞌn? Yu nu gzub lo mez, yu zeꞌ gya zir zuy. Tees ya̱ rdeda̱ lat der rzu bicha̱ nu nac der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’De ru guc nur ya̱ lat nu bzac deeta̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ndeꞌ nu ya̱ gyicya̱ nu gyub ic de ru gal nu gyicy Ñgyoozh nu gyub ic ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nunu de ru gow der gyit nunu goꞌ der nis zeꞌ nu gyub ica̱. Nunu gzub der lo yashily nu gri bee der ni trocyup nac nez mbecy Israeel ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gazeꞌ nu nam rab mi Simo̱o̱: ―Simo̱o̱, nuras bdiiñ yu rishbeey nu gyicy yu preb de ru. Cyib yu der gal nu rgyib dey trig. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tees ya̱ mnishba̱a̱ lo Ñgyoozh nu nac ru, gun orzeꞌ cueꞌ nu checar nu gyicy cup ru consuel lo̱. Nunu ru ornu cush cyar lo̱, orzeꞌ locyuub ru deꞌ zir de bicy ru nu fert zir gyicy cup dey consuel lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Orzeꞌ Simo̱o̱ nay rab yum: ―Shuaana̱, ya̱ bi zu̱ la̱ ca na nu zu̱. Cha̱ du̱ ru nañ yuꞌ gyiib. Mas gashtal gata̱ du̱ ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Orzeꞌ Jesuuz nam rab mi yu: ―Bed, ya̱ ne̱e̱ lor nu laab rel na anzir nu cuedz ngüel, orzeꞌ ru niir nu a̱ꞌ yuꞌ lor ya̱ chon tir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Orzeꞌ gazeꞌ nu Jesuuz bdugyiꞌm lo dey. Orzeꞌ nam: ―Ornu ya̱ bzuu neza̱ de ru nu char riiñ, mas sac gyish gyit ni der, mas sac nerbid tiñ ni der, mas sac reñaꞌ gyid lab der, tees ¿a yuꞌ coz nu bicy falt ni der? ―nam. Orzeꞌ na dey: ―Se la la coz bicy falt ne̱ de̱ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Orzeꞌ nam: ―Tees na reñaꞌ mod gyicy der. Benu mbecy ricy cup yu gyish gyit niy, orzeꞌ cha nuy ñi. Niꞌ ziꞌl benu ricy cup yu nerbid tiñ, orzeꞌ cha nuy ñi. Nunu benu tub mbecy sac mandzicy niy, orzeꞌ rlagy ñi cut yu chacyet niy. Orzeꞌ gad tiñ nu ziy mandzicy niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gun ya̱ rne̱e̱ lo der nu rlagy ñi nu gyuꞌ niñ gal nu bi cañ lat de riidz ni Ñgyoozh nu nac ya̱. Rniiñ: “Briib cuen dey mi lat de mbecy a̱ꞌ nap”, rniiñ. Tees dela coz nu bi cañ nu nac ya̱ rlagy ñi nu gyuꞌ niñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Orzeꞌ na dey: ―Shuaan de̱, ii mbish cyup mandzicy ―na dey. Orzeꞌ nam rab mi dey: ―Beñ ndeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Orzeꞌ gazeꞌ nu Jesuuz gush nez mi zam. Laab gal mod nu nil ricy mi, zam bicy ni Ya Oliva. Orzeꞌ de yu nu rsyaꞌ lom za ca dey ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na ornu bruꞌñam lugaar zeꞌ, orzeꞌ nam rab mi dey: ―Mnii nu der Ñgyoozh, gun orzeꞌ cueꞌ nu gyicy de coz cyi gan der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Orzeꞌ bruu chum lo dey. Nu rnii gal nu tuñ nu zaan na tub gyitaꞌ ni tuñ bruu chum lo dey. Orzeꞌ gusu tib mi nu mnii num Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Orzeꞌ nam: ―Ñgyoozh uza̱, benu gac, bloo chu taz nu rlagy ñi nu gzuub ru̱ꞌ. Tees cueꞌ gac ñii gal nu rlagy ya̱, sinu gal nu rlagy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Orzeꞌ lat nu rnii num Ñgyoozh, orzeꞌ bet tub anc nu bruu gyibaa par nu cuic yu fers nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Orzeꞌ par nu tonaꞌ la deet rac nañ lardoom, orzeꞌ fert zir mnii num Ñgyoozh. Orzeꞌ nis nu rlag lom, ndeꞌ nañ gal nu na ndzuj reñ yet ñi lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na ornu blazh mnii num Ñgyoozh, orzeꞌ zam zeꞌ nu nguaa de yu nu rsyaꞌ lom. Na ornu bruꞌñam lo dey, orzeꞌ nguaa nas dey, gun rsuun lañ dey nu dzi ricy shni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Orzeꞌ nam rab mi dey: ―¿Walab gaal nguaa nas der? Wesh te der nunu mnii nu der Ñgyoozh, gun cueꞌ nu gyicy de coz cyi gan der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lat nu gabee rnii Jesuuz zum, orzeꞌ bruꞌña mbecy zigy. Orzeꞌ Judas, tub yu nu bruu lat trocyup de yu nu bloo sum zeꞌ, yu zeꞌ zub loy lo dey. Orzeꞌ bechaꞌy lom nu bdoy chit lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tees Jesuuz nam rab mi yu: ―Judas, ¿a nu nac tub chit guꞌr ya̱, biñ nu byac mbecy, yaa de yu nu rzi lagy lo̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na ornu bzaac de yu nu yuꞌ nu Jesuuz de coz nu bicy nu dey mi, orzeꞌ na dey rab yum: ―Shuaan de̱, ¿a shet yaa de̱ yu nu mandzicy? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Orzeꞌ tub de yu zeꞌ pcad güiiy tub moz ni yu nu riib ic de uz. Orzeꞌ pcyug yu gyidag beey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Orzeꞌ na Jesuuz: ―Bzaan nu ndeꞌ ―nam rab mi yu. Gazeꞌ nu gul yaam gyidag nu guud güii ni moz zeꞌ. Orzeꞌ bicy mi nu byanapaꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Orzeꞌ gazeꞌ nu nam rab mi de yu zub lo ni uz, gal nu de yu nu rña nañ yuꞌ nu driib zily mbecy Ñgyoozh, gal nu de yu bel ni de mbecy Israeel, de yu nu yad teem zeꞌ. Orzeꞌ nam: ―¿Lagu yad tub der ya̱ gal nu rza tub dey tub gubaan: nu mandzicy nu garot? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gun de dzi la bri̱ du̱ der nañ yuꞌ nu driib zily mbecy Ñgyoozh. Tees ni wancuꞌ yaa der ya̱. Tees na pshuub or nu gyicy der gal nu rlagy ru, tub or nu riib ic nuras ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Gazeꞌ nu za nu dey Jesuuz pres par yuꞌ yu nu riib ic de uz. Orzeꞌ Bed zet zet ziꞌl zaab yu za cay ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na gazel la loliꞌ ni yuꞌ zeꞌ nguaa gyi. Orzeꞌ zeꞌ nguaa de mbecy rbidz dey gyi. Na ornu bruꞌña Bed, orzeꞌ gusubaꞌy lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na ornu bzaac tub criad nu zub yu rbidz yu gyi zeꞌ, orzeꞌ mbi la bgüiim loy. Orzeꞌ nam: ―Fiñ ii laabaꞌ Jesuuz re rded nuñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tees Bed mniiy nu walab. Orzeꞌ nay rab yu criad zeꞌ: ―Biñ mñaa, ni a̱ꞌ yuꞌ lo̱ ya̱ yu zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na guchi gaꞌ ziꞌl nu mnii criad zeꞌ, orzeꞌ bzaac tuubaꞌy Bed. Orzeꞌ nay rab yu Bed: ―Ru laab losaꞌr yu re ―nay. Orzeꞌ Bed nay: ―Walab. Walab losa̱ꞌ ya̱ yu re ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tub or gaal guc nu ni mniiy nu Bed, orzeꞌ na tuubaꞌy: ―Wanted la nu yu ii nac nuy yu re. Gun gazaꞌ yu ii nac yu mbecy Galilea ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Orzeꞌ Bed nay: ―Walab. Ni wagad lagya̱ la coz rniir ―nay rab yuy. Orzeꞌ laab or la zeꞌ, lat nu gabee rnii ruꞌ Bed, orzeꞌ bredz ngüel. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Orzeꞌ Shuaan na Jesuuz bish cyam bgüiim lo Bed. Orzeꞌ Bed byezaꞌ lagy yu de riidz nu mnii Jesuuz loy ornu nam: “Dzi na, anzir nu cuedz ngüel, orzeꞌ ru niir nu a̱ꞌ yuur lor ya̱ chon tir”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gazeꞌ nu bruu Bed zeꞌ zay. Nunu tonaꞌ la zi ruun yu zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Orzeꞌ de yu nu rña Jesuuz rgubdzaa dey mi, nunu ii rgyi su dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Orzeꞌ psoow dey lom. Orzeꞌ na dey rab yum: ―¡Mnii ben cyu bdi ru! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nunu zañ zir coz mnii dey nu rab zii dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na ornu bzaꞌ yu tuubaꞌ dzi na, orzeꞌ byatublaazh de yu bel ni de mbecy Israeel, gal nu de yu zub lo ni uz, gal nu de yu nu rlyuu leey ni Ñgyoozh. Gazeꞌ nu za nu dey Jesuuz lat junt zub lo. Orzeꞌ bdugyiꞌ dey lom. Gazeꞌ nu na dey rab yum: ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Mnii lo de̱, ¿a laab ru Mesías? ―na dey. Orzeꞌ nam: ―Zeꞌ benu ne̱e̱ nu laaba̱, zeꞌ de ru wayeña lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nunu benu dugyi̱ꞌ lo der ni wanii der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tees na bi yad shuub or nu ya̱, biñ nu byac mbecy, chesuba̱ par yaa bee Ñgyoozh, biñ nu gac gyicy dela coz ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Orzeꞌ dela dey bdugyiꞌy lom. Orzeꞌ na dey rab yum: ―Orzeꞌ ¿a laab ru nac ru iꞌñ Ñgyoozh beni? ―na dey rab yum. Orzeꞌ nam rab mi dey: ―Laab der rniir nu ya̱ naca̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Gazeꞌ nu na dey: ―¿Laꞌ zir be teshtig rlagy ñi par yu ii? Gun de ub na güeñ gyidag lan de riidz nu briib ruꞌ ub yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Orzeꞌ dela mbecy wes su dey. Gazeꞌ nu za nu dey Jesuuz lo Pilato. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na ornu bruꞌña dey loy, orzeꞌ brugyiꞌ nu driib dey cyi toom. Orzeꞌ na dey: ―De̱ ya̱ byap de̱ yu ii ricy yu nu radza de mbecy ledza̱. Nunu rniiy nu walagy ñi nu rish de̱ tiñ nu rboo dey por cuen ni yu nu riib ic de nasyoong. Nunu ricy yu ub yu nu nac yu Mesías. Nunu nac yu rey ricy yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Orzeꞌ Pilato nay rab yum: ―¿A ru nac ru rey ni de mbecy Israeel? ―nay. Orzeꞌ nam rab mi yu: ―Laab ni gal nu ru mniir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Orzeꞌ gazeꞌ nu Pilato mniiy lo de yu zub lo ni uz, gal nu lo de mbecy. Orzeꞌ nay: ―Ya̱ wangyap la̱ ni tub la falt ni mbecy ii ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tees de mbecy fert la zu dey. Orzeꞌ na dey: ―Yu ii ricy yu nu deet rac ledz de̱ nu nac coz nu rlyuuy. Nu loga la ni bicy yu Galilea. Na gaꞌ niꞌ ziꞌl ricy yu lo de yu ni Judea ii ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ornu Pilato güeñ yu de nu ndeꞌ, orzeꞌ bdugyiꞌy lo dey ben a nac mi mbecy Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na ornu gud lagy yu nu laab mi mbecy Galilea, orzeꞌ bzuu nez yum zam lo Herodes, gun yu zeꞌ riib ic yu Galilea por cuen ni gubier Rom, nunu tiem zeꞌ riy Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Orzeꞌ Herodes tonaꞌ la bet lagy yu ornu bzaac yu Jesuuz, gun bi rac tiem rlagy yu gzac yum, gun güeñ yu de coz nu rnii mbecy nu ricy mi. Orzeꞌ rgyish loy nu rlagy yu zac yu tub nusuriidz nu gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Orzeꞌ zañ coz bdugyiꞌy lom. Tees Jesuuz rila wanniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Niꞌ ziꞌl zeꞌ yuꞌ de uz zub lo gal nu de yu nu rlyuu leey ni Ñgyoozh. Orzeꞌ bzu fert dey, nunu briib zir dey cyi toom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Orzeꞌ Herodes gal nu de soldad niy shiñ bicy nu dey mi. Orzeꞌ bigy nu naañ dey mi. Orzeꞌ ptiish dey mi tub negy fin. Orzeꞌ bzuu nez dey mi tub tiraꞌ nu zam lo Pilato. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Orzeꞌ dzi zeꞌ Herodes nu Pilato bicy dey rishnap nu losaꞌy. Zeꞌ anzir rzi lagy dey lo losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Orzeꞌ Pilato bicy tublaazh yu de uz zub lo, gal nu de yu bel ni de mbecy Israeel, gal nu de mbecy gyedz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Orzeꞌ nay: ―De ru yad nu der mbecy ii lo̱, nunu mnii der nu ricy yu nu radza mbecy. Tees ya̱ bdugyiꞌ biigya̱ loy lo rgüii la der, nunu wangyapa̱ ni tub la falt niy nu nac cyi nu briib der tooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nunu niꞌ ziꞌl Herodes wangyap yu falt niy. Ndeꞌ nu ptush cyay yu yad yu lo̱. Gun yu ii sac la cyi nu bicy yu nu gyicy ñi nu yad ñi nu gat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Orzeꞌ ndeꞌ nu ya̱ grica̱ cashtig niy. Orzeꞌ gazeꞌ nu gla̱a̱ yu ―nay rab yu de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na de ñaꞌn la, lat nu rzuꞌ saꞌ ni Pas, Pilato rlagy ñi laay tub pres par nu gyicy yu nu gyet lagy de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tees orzeꞌ dela dey dub ruꞌ lay rbish tiy. Orzeꞌ na dey: ―¡Biit yu! ¡Orzeꞌ glaar Barrabás! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Gun Barrabás mneꞌ dey yu nañ yuꞌ gyiib par nu bicy yu nu byach mbecy, nunu par nu biit yu mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tees Pilato rlagy yu nu glaay Jesuuz. Orzeꞌ gazeꞌ nu mniiy lo de mbecy tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tees orzeꞌ de mbecy dzi zir ye rbish ti dey. Orzeꞌ na dey: ―¡Cut ruy lo cruuz! ¡Cut ruy lo cruuz! ―na dey rab yu Pilato. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Orzeꞌ Pilato tir chon la mniiy lo de mbecy. Orzeꞌ nay: ―¿La ñuu coz a̱ꞌ nap bicy yu? Ya̱ wangyapa̱ ni tub la cyi nu bicy yu nu gyicy ñi nu yad ñi nu gat yu. Orzeꞌ ya̱ grica̱ cashtig niy. Orzeꞌ gazeꞌ nu gla̱a̱ yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tees de mbecy zeꞌ rzaab rbish ti la dey nu rnii dey nu gat mi lo cruuz. Orzeꞌ par nu tantaꞌ rbish ti dey, orzeꞌ ndeꞌ nu “O” mnii Pilato. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Orzeꞌ Pilato pshet ic yu nu gyicy yu gal mod nu mnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gazeꞌ nu blaay yu nu mnii mbecy. Yu zeꞌ yu nu bicy nu byach mbecy nunu yu nu biit mbecy. Orzeꞌ bguꞌy Jesuuz yaa dey par nu gyicy dey ca na nu rlagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na ornu za nu dey Jesuuz nu caa dey mi lo cruuz, orzeꞌ nez nu za dey bdzeel dey tub mbecy Cirene nu la Simo̱o̱. Yu zeꞌ bruuy ngush yeed yu. Orzeꞌ pshet yaa dey yu. Orzeꞌ briib dey cruuz nim yeñ yu. Orzeꞌ bicy dey nu guy cruuz zeꞌ cha cay ich Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nunu tonaꞌ la mbecy zigy za ca ich mi. Nunu lat dey yuꞌ zigy biñ mñaa. Ruun dem nunu rbish tim za ca dem ich mi nu nac nu tonaꞌ la ricy shni dem nu nac Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Orzeꞌ Jesuuz bgüiim lo de biñ mñaa zeꞌ. Orzeꞌ nam: ―Der biñ mñaa Jerusaleeng, cueꞌ gun der nu nac ya̱, sinu biiñ der nu nac ub der nunu nu nac iꞌñ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gun shuub dzi nu nii mbecy: “Dzi ni biñ mñaa nu wanchuꞌ iꞌñ. Dzi ni biñ mñaa nu wangaal mdoo. Nunu niꞌ ziꞌl dzi ni biñ mñaa nu wangaagy mdoo”, nii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Orzeꞌ cugyiꞌ de mbecy nu niiy gab yu de bicy: “¡Bish cya to̱o̱ de̱!”, niiy, nunu nii gaꞌ dey gab yu de bicy miiñ: “¡I pcach de̱ ya̱!” niiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gun benu ni mod ricy dey nu yag caꞌ, orzeꞌ dzi zir gyicy dey ornu cha wach ñi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nunu za nu gaꞌ dey cyup mbecy nu bicy cyi par nu caa dey yu tublaazh nu Jesuuz lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na ornu bruꞌña dey lugaar nu la Calavera, orzeꞌ pcaa dey Jesuuz lo cruuz. Nunu pcaa gaꞌ dey cyup mbecy cyi zeꞌ lo cruuz. Tub yu pcaa dey yu par yaa beem. Zeꞌ tuubaꞌy pcaa dey yu par yaa reg mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Orzeꞌ na Jesuuz rab mi Ñgyoozh: ―Ñgyoozh uza̱, bicy sulagy ni dey, gun wagad lagy dey de coz nu ricy yu ―nam. Orzeꞌ de soldad bloo dey suert par nu cyez dey shab mi lat losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Orzeꞌ de mbecy yuꞌ dey rgüiiy lom. Nunu gal de fushtiz bgubdzaa dey mi. Orzeꞌ na dey: ―Bloo mbañ yu reñaꞌ mbecy. Na rlagyaꞌñ nu co mbañ yu ub yu benu rishli gaal nac yu Mesías, biñ nu bloo zu Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","De soldad niꞌ ziꞌl bgubdzaa dey mi. Orzeꞌ bechaꞌ dey lom nunu briic dey ñup zii goꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Orzeꞌ na dey rab yum: ―¡Benu ru nac ru rey ni de mbecy Israeel, bloo mbañ ub ru! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Zeꞌ par too cruuz zeꞌ pcaa dey tub yala nu taꞌ letr. Orzeꞌ rniiñ: “Yu ii rey ni de mbecy Israeel”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na tub yu nu ca cuit mi mnii ziy nim. Orzeꞌ nay rab yum: ―Benu ru nac ru Mesías, biñ nu ca lo cuen nu cyid, orzeꞌ bloo mbañ ub ru, nunu bloo mbañaꞌ de̱ ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tees tuubaꞌ losaꞌy bdzaꞌy niy. Orzeꞌ nay rab yuy: ―¿A wacchib ru lo Ñgyoozh? Gun bi taꞌ den laabaꞌ lo cashtig. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gun de ub na yad ñi nu gzac zin, gun na drish na de coz nu bicy na. Tees yu ii rila wangyicy yu coz a̱ꞌ nap ―nay rab yu losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Orzeꞌ na gaꞌy rab yu Jesuuz: ―Jesuuz, gyezaꞌ lagy ru ya̱, ornu cugyiꞌ nu gyub ic ru de mbecy nir ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Orzeꞌ Jesuuz nam rab mi yu: ―Ya̱ rishli rne̱e̱ lor nu dzi na bi ri nur ya gyibaa ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Orzeꞌ tub gyiib trocyup or widoo, orzeꞌ bet cow dutuub la lo yu gashtal gyiib chon or gudze. Orzeꞌ bzu yaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ni doo wancuic ñi yaa. Zeꞌ negy nu zaab lugaar yon ni yuꞌ nu driib zily mbecy Ñgyoozh pshelañ. Cyaal, cyaal lañ guc ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Orzeꞌ Jesuuz ye la brish tim. Orzeꞌ nam rab mi Ñgyoozh: ―¡Uza̱, byash lardo̱o̱! ―nam. Na ornu blazh mniim ndeꞌ, orzeꞌ gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na ornu bzaac yu nu riib ic de soldad Rom de coz nu guc na, orzeꞌ brugyiꞌ ryabic yu gyel mbecy ni Ñgyoozh. Orzeꞌ nay: ―Rishli gaal yu ii nac yu mbecy nu sac falt ni ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Orzeꞌ dela mbecy zigy nu yuꞌ lugaar zeꞌ, ornu bzaac dey nu ni guc, orzeꞌ gush nez dey zay. Rgyich yaa dey lyush yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tees dela mbecy nu yuꞌ lo Jesuuz, nunu gazaꞌ de biñ mñaa, biñ nu za ca ich mi nese nu bruum Galilea, orzeꞌ de yu zeꞌ byeeñ gay lugaar zeꞌ. Orzeꞌ zet yuꞌ dey rgüiiy de coz nu guc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Bzu tub mbecy nu la See. Yu zeꞌ bruuy tub gyedz ni Judea nu la Arimatea. Nunu nac yu tub mbecy nap. Nunu ricy yu mod nu seꞌñ. Nunu yu zeꞌ nac yu tub yu nu zu riiñ lat de junt zub lo ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yu zeꞌ rgyish loy lo gyel gubier ni Ñgyoozh, nunu wangyicy yu tub ziꞌl riidz nu de yu nu guꞌ junt zeꞌ ben lac mod ñgyicy nu dey Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Orzeꞌ gush nez yu guay lo Pilato bdiiñ yu cuerp ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na ornu bi pshet yu cuerp nim lo cruuz, orzeꞌ ptiish yu cuerp nim zeꞌ tub sab nu byaa nu lino. Gazeꞌ nu briy ñi nañ tub gyerbaa cub nu bduguuñ nañ tub gyitaꞌ. Gyerbaa zeꞌ nigul cui la añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ndeꞌ guc ñi dzi byer or gudze. Dzi zeꞌ rzu lily dey par nu zu lagy dey sab. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Orzeꞌ de biñ mñaa nu guca ich Jesuuz nese nu bruum Galilea gua nu dem See par ruꞌ baa ni Jesuuz. Orzeꞌ bzaac dem lac mod briy cuerp nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na ornu bri dem yuꞌ na, orzeꞌ bzu lily dem coz zguul gal nu coz nu coo dem cuerp ni Jesuuz. Orzeꞌ ornu pshuub dzi sab, orzeꞌ bzu lagy dem gal nu rniiñ lo leey nu gyicy dem. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Noming, dzi loga ni sman, orzeꞌ de biñ mñaa zeꞌ napor la za dem ruꞌ baa ni Jesuuz. Za nu dem coz zguul nu bzu lily dem zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na ornu bruꞌña dem ruꞌ baa zeꞌ na, orzeꞌ bzaac dem nu sacaꞌ gyitaꞌ nu noow ruꞌ baa zeꞌ seꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Orzeꞌ guꞌ dem gyeegy ni baa zeꞌ. Orzeꞌ bzaac dem nu sacaꞌ cuerp ni Shuaan na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Orzeꞌ pcan shcab ni dem yuꞌm. Orzeꞌ wagad lagy dem lac gyicy mi. Orzeꞌ sij la bruu zac cyup mbecy. Orzeꞌ gusu dey garee lom. Zeꞌ zu dey negy cacy iily la. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tonaꞌ la gudzib dem. Orzeꞌ gusab tiily la dem gal lo yu la. Orzeꞌ de mbecy zeꞌ nay rab yu dem: ―¿Lagu ryub der tub biñ mbañ lat de añ ii? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gun mi zeꞌ sacaꞌm ii, sinu bi byabañ mi. Bicy der nu gyezaꞌ lagy der de coz nu mniim lat nu gusam Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mniim nu rlagy ñi nu guꞌ dey ub mi, biñ nu byac mbecy, yaa de mbecy cyi. Orzeꞌ de yu zeꞌ rlagy ñi caa dey mi lo cruuz. Orzeꞌ nu zaꞌ dzi chon, orzeꞌ gyabañ mi, nam ―na de mbecy shab cacy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Orzeꞌ gazeꞌ nu de mi zeꞌ byezaꞌ lagy dem de riidz nu mnii Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Orzeꞌ bruu dem ruꞌ baa zeꞌ bish cya dem yam. Orzeꞌ byoo dem rishlo de trotub de aposht, gal nu lo deꞌ zir mbecy de coz nu guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","De biñ nu bya too riidz zeꞌ, mi zeꞌ Li, biñ nu bruu Magadán, nu Wan, gal nu Li ñaa Santiag, gal nu deꞌ zir de biñ mñaa. Orzeꞌ mnii dem riidz zeꞌ lo de aposht. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tees de yu zeꞌ guzii dey nu riidz ton ziꞌl rnii dem. Orzeꞌ wancheña lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Orzeꞌ mas ni, tees Bed gush yu carer zay ruꞌ baa ni Jesuuz. Na ornu bruꞌñay na, orzeꞌ bgüiiy nañ gyerbaa zeꞌ. Orzeꞌ bzaac yu se sab ziꞌl nim mbish ñi. Orzeꞌ bish cyay yay par yuꞌ. Nunu za nu la ic yu nu nac de coz nu guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Orzeꞌ laab dzi zeꞌ cyup de yu nu rsyaꞌ lom za dey tub gyedz nu la Emaés. Gyedz zeꞌ riñ tub nu rnii trotub miily metr nu ruun Jerusaleeng ruꞌñan gyedz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na nez nu za dey, orzeꞌ ro dey riidz nu nac dela coz nu guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na lat nu ro dey riidz na, orzeꞌ laab Jesuuz bechaꞌm lo dey. Orzeꞌ gazeꞌ nu za num dey tublaazh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Orzeꞌ mas bzaac dey mi, tees wangyuꞌ lo dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Orzeꞌ nam rab mi dey: ―¿La riidz ro der yad ru? ―nam. Orzeꞌ guca dey nu ricy shniy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Orzeꞌ tub yu nu rsyaꞌ lom zeꞌ lay Cleofas. Orzeꞌ nay rab yum: ―¿A tub zi la ru mbecy nu pcyiiñ Jerusaleeng nu wagad lagy de coz nu sa guc zeꞌ? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Orzeꞌ na gaꞌ Jesuuz: ―¿La coz guc? ―nam. Orzeꞌ na gaꞌy: ―De coz ni Jesuuz, biñ nu bruu Nazaret. Mi zeꞌ guc mi tub biñ nu rnii por cuen ni Ñgyoozh. Ñgyoozh, gal nu dela mbecy bicy dey Jesuuz par tub mbecy nu tonaꞌ la coz ily ricy nunu tonaꞌ la coz ily rnii. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Orzeꞌ de uz zub lo gal nu de fushtiz ledz na bguꞌ dey mi yaa mbecy, gun orzeꞌ gyicy dey nu gat mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tees de̱ ya̱ brish lo̱ de̱ nu mi zeꞌ nac mi biñ nu co mbañ de mbecy Israeel. Tees na bi bzaꞌ chon dzi nu gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tees la be de biñ mñaa nu nac nu de̱ ya̱ bicy mi nu za̱ du̱ la ic de̱. Gun cas ruꞌ zu gua dem ruꞌ baa ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Na ornu wangyap dem cuerp ni Jesuuz, orzeꞌ bish cya dem yam. Orzeꞌ mnii dem nu bruu zac la be anc lo dem. Orzeꞌ anc zeꞌ mniiy nu Jesuuz mbañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Orzeꞌ gazeꞌ nu gua la be de losa̱ꞌ gal ruꞌ baa zeꞌ. Orzeꞌ bzaac yu nu ni gaal ni zu, gal nu mnii de biñ mñaa zeꞌ. Tees wansacaꞌ dey Jesuuz ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Orzeꞌ na Jesuuz: ―¡Dzi ga cyigy too der! ¡Dzi ga gyee cheña lagy der de riidz ni de yu nu mnii por cuen ni Ñgyoozh! ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Walab gaal walagy ñi nu zac zi Mesías anzir nu gyam lo gyel lily nim? ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Orzeꞌ gazeꞌ nu brugyiꞌ nu rshaal mi dela seꞌ lat riidz ni Ñgyoozh zeꞌ nu rzat ñi ub mi. Gush lam de riidz nu bzeeñ Moisees. Orzeꞌ yad mi dela libr nu pcaa de yu nu mnii por cuen ni Ñgyoozh rshaal mi lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na ornu bri dey gyedz nu rsaap dey zeꞌ, orzeꞌ Jesuuz bicy lam nu zu ga ziꞌl mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tees de yu zeꞌ pcueez dey mi nu gyeeñ mi num dey. Orzeꞌ na dey rab yum: ―Byeeñ la nu de̱ ya̱, gun na bi gudze. Sñuu ga gyecheñ ―na dey. Orzeꞌ Jesuuz guꞌm nañ yuꞌ par nu gyeñ num dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na ornu bi nguaa dem lo mez na, orzeꞌ bduꞌ yaam gyishtily. Orzeꞌ briic mi gras ni Ñgyoozh nu nac ñii. Orzeꞌ blew mi ñii briic mi ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Orzeꞌ or la zeꞌ de yu zeꞌ byaal la urlo dey. Orzeꞌ byuꞌ lo dey mi. Orzeꞌ mi zeꞌ mnit mi lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Orzeꞌ na dey rab yu losaꞌy: ―¿A walab nu nap zu lagy na nez nu yap na ornu mniim lo den, nunu ornu pshaal mi riidz ni Ñgyoozh lon? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Orzeꞌ wancuez la dey, sinu gush nez la dey yay Jerusaleeng. Na ornu bri dey na, orzeꞌ zeꞌ byap dey zaꞌ trotub la de yu nu rsyaꞌ lom yuꞌ tublaazh dey nu deꞌ zir de losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Orzeꞌ na de yu nu rsyaꞌ lom rab yu de yu nu bri zeꞌ: ―Rishli ni gaal Shuaan na byabañ mi, gun bruu zac mi lo Simo̱o̱ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Orzeꞌ de yu nu bri zeꞌ byoo dey rishlo dey nu la coz bzaac dey nez. Nunu mnii gaꞌ dey lac mod byuꞌ lo dey mi ornu psug mi gyishtily. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na lat nu gabee yuꞌ dey rniiy de coz zeꞌ, orzeꞌ bruu zacaꞌ Jesuuz lat dey. Orzeꞌ mnii num dey ñgyoozh. Orzeꞌ nam: ―Gyel ri zu briñ lat der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Orzeꞌ de yu nu rsyaꞌ lom tonaꞌ la gudzib dey. Bis guzii dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Orzeꞌ Jesuuz nam rab mi dey: ―¿Lagu rdzib der? ¿Lagu wacheña lagy der nu ya̱ nu ndeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Güii der ya̱a̱ nunu güii der gyi̱ꞌ. Laab ya̱ nu ndeꞌ. Güii der ya̱, nunu gul yaa der ya̱. Bis a̱ꞌ ricy cup ñi cuerp niñ gal nu rzac der nu na ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Orzeꞌ ornu blazh mniim de ndeꞌ, orzeꞌ blyuum yaam lo dey gal nu gyiꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Orzeꞌ de yu zeꞌ gabee wacheña lagy dey ti laab mi, tantaꞌ nu yet lagy dey, nunu tantaꞌ nu za nu ic dey. Orzeꞌ Jesuuz nam rab mi dey: ―¿A yuꞌ ñuu la coz ni der don? ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Orzeꞌ briic dey tub laꞌ bel nu guuy lo boo gom. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Orzeꞌ gush mi ñii. Orzeꞌ bdom ñii lo rgüii dela dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Orzeꞌ gazeꞌ nu nam rab mi dey: ―Coz nu bzaca̱, ndeꞌ mne̱e̱ lo der lat nu gabee gusa du̱ der. Orzeꞌ dela coz nu cañ lo leey ni Moisees, nu dela coz nu cañ lat de riidz ni de yu nu mnii por cuen ni Ñgyoozh, gal nu dela coz nu cañ lo libr ni salmos nu nac ya̱, dela riidz zeꞌ byuꞌ niñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Orzeꞌ bicy mi nu gyet lag dey cuen de riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Orzeꞌ nam rab mi dey: ―Bi cañ nu ya̱, Mesías, biñ nu ca lo cuen nu cyid. Cañ nu rlagy ñi gata̱. Tees ornu zaꞌ dzi chon, orzeꞌ gyabaña̱ꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nunu rniiñ nu de mbecy rlagy ñi cha shaal dey riidz ni Ñgyoozh lo dela mbecy nu nac ya̱. Nii dey nu rlagy ñi neꞌ mbecy dela cyi nu ricy yu, gun orzeꞌ Ñgyoozh gyicy sulagy mi ni dey. Gash dey Jerusaleeng. Orzeꞌ cha dey dutuub la gyishlombecy nu cha shaal dey riidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Orzeꞌ de ru nac der teshtig ni de coz nu guc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Orzeꞌ ya̱ gzuu neza̱ Espiriit Yon ni Ñgyoozh nu cyid mi lat der gal nu Ñgyoozh uz na bi mneꞌ ic mi nu cuic mim ni der. Tees de ru gyeñ der gyedz Jerusaleeng ii gashtal gyicy la Ñgyoozh gyibaa nu cyiiñ der. Orzeꞌ gazeꞌ nu gruu der char ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Orzeꞌ gazeꞌ nu Jesuuz bruu num dey gyedz Jerusaleeng. Guam num dey gal Betania. Orzeꞌ zeꞌ pshes nañ yaam bdiiñ mi lo Ñgyoozh nu locyuub mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Orzeꞌ lat nu ni bicy mi bruu chum lo dey. Gazeꞌ nu gup mi gyibaa yam. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na ornu blazh nu briib zily dey mi, orzeꞌ bish cya dey yay par Jerusaleeng. Nunu tonaꞌ la bet lagy dey yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nunu de dzi la yuꞌ dey nañ yuꞌ nu driib zily de mbecy Ñgyoozh nu ryabic dey gyel mbecy nim.");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nese anzir nu gya gyishlombecy, biñ nu la riidz ni Ñgyoozh nil bi zum. Mi zeꞌ nac num Ñgyoozh, nunu nac mi Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nunu nil bi zum nu Ñgyoozh nese anzir nu gya gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dela coz nu psaꞌ lagy Ñgyoozh, mi zeꞌ bicy mi ñii. Nunu ni tub la coz wansaꞌ lagy Ñgyoozh benu walab nu nac mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mi zeꞌ nac mi biñ nu rbic gyel mbañ nu rishli. Nunu gyel mbañ zeꞌ nañ gal nu na tub yaa nu ricy ñi nu gyal shcab ni de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Zeꞌ yaa zeꞌ bzu laañ zeꞌ nu cow, nunu de zeꞌ nu cow zeꞌ rila wangyicy ñi gan nu nsoow ñi lo yaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bzu tub mbecy, yu nu bzuu nez Ñgyoozh. Yu zeꞌ lay Waa nu driib nis mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Biid yu par nu cuic yu nu gad lagy de mbecy nu cyu biñ nu na gal nu na yaa zeꞌ, gun orzeꞌ de yu nu gzuub gyidag de riidz nu niiy, orzeꞌ de yu zeꞌ gyicy cup dey consuel lom nu nac de riidz nu mniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yu zeꞌ walab biñ nu na gal nu na yaa zeꞌ, sinu Ñgyoozh bzuu nez mi yu biid yu par nu cuic yu nu gad lagy mbecy cyu nac mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Gun biñ nu nac yaa nu rishli zeꞌ bi yad mi par nu cuic mi nu gad lagy dela mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Laab biñ nu la riidz ni Ñgyoozh zeꞌ brim gyishlombecy. Nunu mas Ñgyoozh psaꞌ lagy mi dela coz ni gyishlombecy nu nac mi, tees de mbecy ni gyishlombecy wangyuꞌ lo dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Brim ledz mi tees de mbecy nu yuꞌ ledz mi wannii dey “O” nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dela mbecy nu “O” mnii nim nunu bicy cup dey consuel lom, orzeꞌ de yu zeꞌ briic mi mod ni dey nu gyac yu iꞌñ Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Walab nu byac dey iꞌñ Ñgyoozh par nu gul dey ni tub biñ mñaa, nunu walab nu byac dey iꞌñ Ñgyoozh par nu nac coz nu rlagy ca na tub mbecy, sinu byac dey iꞌñ Ñgyoozh gal nu ub mi bicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nunu biñ nu la riidz ni Ñgyoozh zeꞌ byac mi mbecy gyishlombecy, nunu pcyiiñ mi lat den. Nunu tonaꞌ la gugy nam num de ub na. Nunu rniim dub ub la coz rishli. Nunu de ub na bi bzaac na gyel lily nim, gyel lily nu yad ñi nu gad ni biñ nu tub zi zu ni uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Waa bzat yum. Orzeꞌ ye la mniiy: ―Mi zeꞌ biñ nu bzata̱ ornu mne̱e̱ lo der nu biñ nu yad par icha̱ gya zir zum gazeꞌ ya̱, gun mi zeꞌ nil bi zum anzir nu gal ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Par nu nac nu dzi gugy nam, zaab nap la ricy num de ub na. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gun briic Ñgyoozh leey ni den nu nac Moisees. Zeꞌ nu nac Jesuuz, nap ricy num de ub na nunu blyuum de coz rishli nim lo den. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni tub la mbecy wacsac dey Ñgyoozh. Tees iꞌñ mi, biñ nu tub zi zu nim, nac num mi. Mi zeꞌ briic mi nu gad lagy na la nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nii de coz nu mnii Waa ornu de fushtiz ni de mbecy Israeel bzuu nez dey de uz gal nu la be de mbecy nu bruu lat nez Levita nu yuꞌ Jerusaleeng nu cha dey cugyiꞌy lo Waa. Orzeꞌ na dey rab yu Waa: ―¿Cyu nac ru? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Orzeꞌ Waa naal la mniiy lo dey cyu nac yu. Orzeꞌ nay: ―Ya̱ walab Mesías, biñ nu ca lo cuen nu co mbañ mbecy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Orzeꞌ bdugyiꞌ gaꞌ dey loy: ―¿Zeꞌ cyu gaal nac ru beni? ¿A walab Elías, yu nu mnii por cuen ni Ñgyoozh, nac ru beni? ―na dey. Orzeꞌ na gaꞌ Waa: ―Walab yu zeꞌ naca̱ ―nay. Orzeꞌ na gaꞌ dey: ―¿A walab ru yu nu rnii por cuen ni Ñgyoozh nu ca lo cuen nu cyid? ―na dey. Orzeꞌ na Waa: ―Walab ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Orzeꞌ na gaꞌ dey: ―¿Cyu nac ru beni? Gun rlagy ñi nu gya du̱ de̱ raso̱o̱ lo deyu nu bzuu nez de̱ ya̱ nu yapa̱. ¿Cyu nac ub ru? Mnii beni ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Orzeꞌ na Waa rab yu dey: ―Ya̱ naca̱ tub mbecy, tub yu nu bzat Isaías, yu nu mnii por cuen ni Ñgyoozh ornu nay: “Zaab tiꞌ tub mbecy rbish tiy tub lugaar ub zi. Orzeꞌ nay: Bicy nap der nañ lardoor gal nu ricy nap der tub nez nu ded tub yu lily, gun bi cyid Shuaan den”, na Isaías ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na de yu nu bzuu nez de mbecy fariseo nu gua tugyiꞌy lo Waa, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","orzeꞌ na dey rab yu Waa: ―Zeꞌ benu a̱ꞌ nac ru Mesías, biñ nu ca lo cuen nu co mbañ mbecy, ni a̱ꞌ nac ru Elías, ni a̱ꞌ nac ru yu nu rnii por cuen ni Ñgyoozh, zeꞌ ¿lagu rbic ru nu zu nis mbecy beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Orzeꞌ na Waa rab yu dey: ―Ya̱ driib nisa̱ mbecy nu nis, tees lat de ub na zu tub mbecy nu a̱ꞌ yuꞌ lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mi zeꞌ cyid mi par lo ya̱, tees ya̱ wangyapa̱ nu shaagya̱ ni gyid nu zub gyid lab mi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dela de coz ii guc ñi tub lugaar ni tub gyedz nu la Betania, par tub laꞌ gaꞌ ruꞌ gyoow Jordaang. Ndeꞌ lugaar zeꞌ nu driib nis Waa de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na tuubaꞌ dzi orzeꞌ bzaac Waa Jesuuz nu yad mi loy. Orzeꞌ nay: ―Güii der, re yad tub mbecy nu na gal nu na tub shily nu gac gun lo Ñgyoozh. Mi zeꞌ cyib mi cyi de mbecy nu yuꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mi zeꞌ biñ nu bzata̱ lo der ornu ya̱ mne̱e̱: “Biñ nu yad par ich ya̱, gya zir zum gazeꞌ ya̱, gun mi zeꞌ nil bi zum anzir nu gal ya̱”, mne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wangad lagya̱ cyu nac mi, tees ya̱ yapa̱ nu griib nisa̱ mbecy nu nis gun par nu cuꞌ lo de mbecy Israeel mi cyu nac mi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nii riidz nu mnii Waa ornu nay: ―Ya̱ bzaaca̱ Espiriit Yon ni Ñgyoozh nam gal nu na tub begy bet mi. Bruum gal gyibaa. Gusub mi too mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ya̱ gabee wangyuꞌ lo̱m cyu nac mi. Tees Ñgyoozh, biñ nu bzuu nez ya̱ nu griib nisa̱ mbecy nu nis, nam rab mi ya̱: “Ornu gzac ru nu gyet Espiriit Yon ne̱ too tub mbecy, orzeꞌ mi zeꞌ biñ nu cuic Espiriit Yon zeꞌ ne̱ ni de mbecy”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ya̱ bi bzaaca̱ de coz zeꞌ. Ndeꞌ nu ya̱ naca̱ teshtig nu mi zeꞌ nac mi iꞌñ Ñgyoozh ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na orzeꞌ tuubaꞌ dzi, orzeꞌ Waa laab lugaar zeꞌ zuy nu cyup de yu nu rsyaꞌ loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na ornu bzaac yu nu bded Jesuuz, orzeꞌ nay: ―Güii der. Re rded tub mbecy nu na gal na tub shily nu gac gun lo Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na ornu güeñ cyup de yu nu rsyaꞌ loy de riidz zeꞌ, orzeꞌ za dey za cay ich Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Orzeꞌ Jesuuz bish cyam, nunu bzaac mi nu yad dey. Orzeꞌ nam rab mi dey: ―¿La coz ryub der? ―nam. Orzeꞌ na dey rab yum: ―Masht, ¿ca rcyiiñ ru? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Orzeꞌ na Jesuuz rab mi dey: ―Yaa der chan gun cha güiir ca rcyiiña̱ ―nam. Orzeꞌ gush nez dey za nuy mi. Orzeꞌ bzaac dey ca rcyiiñ mi. Orzeꞌ byeeñ nu dey mi gua la nu gudze zeꞌ, gun bi yuꞌn tub gyiib tap or gudze ornu bri num dey zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tub de yu nu güeñ ni Waa, yu nu gua ca ich Jesuuz, lay Ndrees bicy yu Simo̱o̱ Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Orzeꞌ lueg la gua yub yu bicy yu Simo̱o̱. Orzeꞌ nay rab yuy: ―De̱ ya̱ bi bdzeel de̱ Mesías, bin nu ca lo cuen nu co mbañ den ―nay. (Mesías, ndeꞌ tub ziꞌl yaruuñ nu Crisht.) ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Orzeꞌ lueg la za nuy Simo̱o̱ lo Jesuuz. Orzeꞌ Jesuuz mbi la bgüiim loy. Orzeꞌ nam rab mi yu: ―Ru lar Simo̱o̱ iꞌñ Waa. Tees na loo la̱ ru Cefas. (Cefas nu Bed tub ziꞌl nu yaruu riidz zeꞌ. Ndeꞌ gyitaꞌ.) ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na tuubaꞌ dzi, orzeꞌ Jesuuz mnii ic mi gyam tub lugaar ni Galilea. Orzeꞌ zeꞌ bdzeel mi Lip. Orzeꞌ nam rab mi yu: ―Da, da ca icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na Lip nac yu tub mbecy gyedz nu la Betsaida. Laab zeꞌ ledz Ndrees nu Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Orzeꞌ Lip guay gua yub yu Natanael. Na ornu bdzeel yuy, orzeꞌ nay rab yuy: ―Na bi bdzeel de̱ biñ nu bzat Moisees lo de gyicy zeꞌ nu ca leey ni Ñgyoozh. Laab mi zeꞌ biñ nu bzat de yu nu mnii por cuen ni Ñgyoozh. Mi zeꞌ Jesuuz iꞌñ See. Zeꞌ ledz mi, ndeꞌ Nazaret ―na Lip. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Orzeꞌ na gaꞌ Natanael: ―¿Walab gaal gac gruu ñuu la coz nap gyedz Nazaret? ―na Natanael. Orzeꞌ na Lip rab yuy: ―Da güiir ben a walab ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na ornu Jesuuz bzaac mi nu byagaab Natanael lom, Orzeꞌ nam: ―Güii, ii yad tub mbecy nu rishli gaal nac mbecy Israeel, tub yu nu sac gyel rguu nañ lardoo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Orzeꞌ Natanael bdugyiꞌy lom: ―¿Lac bicy ru? ¿Lagu nu gud lagy ru lac mbecy na̱? ―nay. Orzeꞌ na Jesuuz rab mi yu: ―Ya̱ bzaaca̱ ru lat nu gusub ru gyiꞌ yalas anzir nu cuedz Lip ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Orzeꞌ na Natanael rab yum: ―Masht, ru nac ru iꞌñ Ñgyoozh. Ru nac ru rey nu nac Shuaan de mbecy Israeel ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Orzeꞌ Jesuuz nam rab mi yu: ―¿A ricy cup ru consuel lo̱ nu nac ziꞌl nu mne̱e̱ nu bzaaca̱ ru nu gusub ru gyiꞌ yalas? Coz ily zir gzac ru par lo gazeꞌ coz nu bzaac ru na ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Orzeꞌ na gaꞌm rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu gzac der nu gyal gyibaa, nunu gzac der nu chup gyet la de anc ni Ñgyoozh lo̱ ya̱, biñ nu byac mbecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na ornu bi bzaꞌ chon dzi nu yuꞌ fandang tub gyedz nu la Caná lo yu ni Galilea. Laab lat zeꞌ ri ñaa Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nunu niꞌ ziꞌl mnii gaꞌ dey lo Jesuuz nu lo de yu nu rsyaꞌ lom nu cha dey lo fandang zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na ornu blazh ñup ni urbyay nu goꞌ dey, orzeꞌ na ñaa Jesuuz rab mim: ―Blazh ñup ni urbyay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Orzeꞌ na gaꞌ Jesuuz rab mi ñaam Li: ―Ña, ¿lagu rniir riidz zeꞌ lo̱? Nigul shuub dzi nu gzac mbecy de gyel lily ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Orzeꞌ na gaꞌ ñaam rab mi de moz nu yuꞌ lo fandang zeꞌ: ―Bicy der la ziꞌl coz nu gniiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, zeꞌ nguaa gaꞌ shuup reꞌ nu byaa nu gyitaꞌ. Nañ reꞌ zeꞌ rguꞌ de mbecy Israeel nis par nu rnaa dey nunu par nu rgyiib dey la coz gal nu rnii leey ni dey. Zeꞌ tub ga de reꞌ zeꞌ rzuꞌ tub cyaal gaynal, o tub setent litr nis nañ ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Orzeꞌ na Jesuuz rab mi de moz zeꞌ: ―Bduꞌ der nis nañ de reꞌ re gal dzaa lañ ―nam. Orzeꞌ de yu zeꞌ pchaa dey ñi gal ruꞌ lañ. Orzeꞌ nis zeꞌ byac ñi ñup ni urbyay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Orzeꞌ na gaꞌm rab mi dey: ―Na bdaꞌ der nis ii gua nu der goꞌ yu nu riib ic lo fandang ―nam. Orzeꞌ gua nu dey ñi goꞌ yu nu riib ic zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Orzeꞌ yu nu riib ic zeꞌ bicy yu preb nis nu byac ñup ni urbyay zeꞌ, sinu wangad lagy lay ca bruuñ. Tees de moz nu bdaꞌ nis zeꞌ gud lagy dey ca bruuñ. Orzeꞌ yu nu riib ic zeꞌ bredz yu yu nu nac nob zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Orzeꞌ nay rab yuy: ―Dela mbecy nu loga la rbic dey ñup nap ni urbyay goꞌ de mbecy nu rdeꞌ lo fandang. Na ornu dzi bi goꞌ shaad dey ñup nap zeꞌ, orzeꞌ rbic dey de ñup corient goꞌ dey. Zeꞌ ru bzeeñ ru ñup nap gashtal na rbic ru goꞌ dey ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ndeꞌ nusuriidz nu bicy mi nu loga la tub gyedz nu ri lo yu ni Galilea nu la Caná. Zeꞌ blyuum gyel lily nim lo de mbecy, nunu de yu nu rsyaꞌ lom bicy cup zir dey consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na ornu bded zeꞌ, orzeꞌ bruum Caná gush nez mi zam nu ñaam, gal nu de bicy mi, gal nu de yu nu rsyaꞌ lom za num dey par Capernaum. Zeꞌ pcyiiñ mi la be dzi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na ornu sñuu ga shuub dzi nu chuꞌ de mbecy Israeel saꞌ ni Pas, orzeꞌ Jesuuz yam par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na ornu brim Jerusaleeng, orzeꞌ guꞌm loliꞌ ni yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. Orzeꞌ byap mi de mbecy nu rut tor, nu shily, gal nu begy ni de mbecy. Nunu byapaꞌm de mbecy nu nguaa lo mez nu rchaa tiñ ni de mbecy nu bruu reñaꞌ lugaar. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na ornu bzaac mi de coz zeꞌ, orzeꞌ bzaam tub chicot nu duu lyaar. Orzeꞌ nu ndeꞌ pcyuu num dey, nu tor niy, gal nu shily niy. Bloom dey ich loꞌ ni yuꞌ zeꞌ. Orzeꞌ ptush las mi tiñ ni de yu nu rchaa tiñ zeꞌ nunu blaagy yaam mez ni dey. Orzeꞌ brush las tiñ ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Zeꞌ de yu nu rut begy zeꞌ nam rab mi dey: ―Bloo der de bañcyug ii lugaar ii. Cueꞌ gyicy der yuꞌ ni Ñgyoozh uza̱ par tub yagyiꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Orzeꞌ de yu nu rsyaꞌ lom byezaꞌ lagy dey zeꞌ nu rniiñ lat riidz ni Ñgyoozh: “Ya̱ rzu ferta̱ nu nac yuꞌr gashtal wagagye̱e̱ ga̱ꞌ la̱”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Orzeꞌ de yu zub lo ni de mbecy Israeel bdugyiꞌ dey lom: ―¿La ñuu muesht lyuur lo̱ de̱ par nu gabe nu ricy cup ru rishbeey nu ricy ru de coz ii? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Orzeꞌ na gaꞌm rab mi dey: ―Ptily der yuꞌ ni Ñgyoozh ii. Orzeꞌ ya̱ zu napa̱ ñii nañ chon dzi tuubaꞌ tir gal nu nañ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Orzeꞌ na de mbecy Israeel rab yum: ―Cyuu zub shuup ñaꞌn guꞌ dey bicy yu riiñ, gazeꞌ nu byaꞌ lo yuꞌ ni Ñgyoozh ii. Zeꞌ ru naꞌr nu nañ chon zi dzi bi gzu nap ru ñii ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tees yuꞌ ni Ñgyoozh nu bzat Jesucrisht, ndeꞌ cuerp nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tees ornu byabañ mi, orzeꞌ de yu nu rsyaꞌ lom byezaꞌ lagy dey nu bi mniim nu ni gac ñii. Orzeꞌ guña lagy dey de riidz ni Ñgyoozh gal nu de riidz nu mnii Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lat nu Jesuuz rded mi Jerusaleeng, lat saꞌ ni Pas, tonaꞌ la zigy mbecy bicy cup dey consuel lom nu nac de nusuriidz nu bicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tees Jesuuz wangyicy cup mi consuel lo dey gun gud lagy mi lac mod na dela mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni tub la mbecy walagy ñi nu nii dey lom mod nu na de mbecy, gun ub mi rad lagy mi la na nañ lardoo dela dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bzu tub mbecy fariseo lay Nicodemo. Nac yu tub mbecy nu zu riiñ lat de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Orzeꞌ tub rel guay gua güiiy Jesuuz. Orzeꞌ nay rab yum: ―Masht, de̱ ya̱ rad lagy de̱ nu Ñgyoozh bzuu nez mi ru yad ru par nu lyuur ni de mbecy, gun ni tub la mbecy wac gyicy dey de nusuriidz nu ricy ru zeꞌ benu walab Ñgyoozh nac num yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Orzeꞌ na Jesuuz rab mi yu: ―Ya̱ rishli rne̱e̱ lor nu ni tub la mbecy wazac yu lo gyel gubier ni Ñgyoozh benu wal yu tuubaꞌ tir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Orzeꞌ bdugyiꞌ Nicodemo lom: ―¿Par lac mod gyicy tub mbecy gush nu gal yu tuubaꞌ tir? ¿Walab gaal gac chuꞌ tub mbecy gush nañ ñaay par nu gal yu tuubaꞌ tir? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Orzeꞌ na gaꞌ Jesuuz rab mi yu: ―Ya̱ rishli rne̱e̱ lor nu ni tub la mbecy wazac yu lo gyel gubier ni Ñgyoozh benu wal yu lat nis, nunu benu wal yu nu nac Espiriit Yon ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ornu tub mbecy ral yu ni ñaay, orzeꞌ mbecy ziꞌl nac yu. Tees benu tub mbecy gal yu nu nac Espiriit Yon ni Ñgyoozh, orzeꞌ ni Ñgyoozh nac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Cueꞌ cha nu ic ru nu rne̱e̱ lor nu rlagy ñi nu gal der tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gush ñuu shcab mod nu ricy bi. Ca ziꞌl lugaar druuñ. Reñ ru rsiigy ñi, tees wagad lagy der ca druuñ, nunu wagad lagy der ca par chañ. Niꞌ ziꞌl wagad lagy mbecy lac mod rac nu ral yu nu nac Espiriit Yon ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Orzeꞌ na gaꞌ Nicodemo rab yu Jesuuz: ―¿Zeꞌ lac mod gac de coz nu rniir zeꞌ? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Orzeꞌ na Jesuuz: ―Gunca ru nac ru tub moscuel zub lo ni de mbecy Israeel, ¿zeꞌ a wagad lagy ru de coz zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya̱ rishli rne̱e̱ lo der de coz nu rad lagy de̱, nunu dric de̱ raso̱o̱ ni de coz nu bzaac de̱. Zeꞌ ni tub la der wagnii der “O” nu de riidz nu rne̱e̱ de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Zeꞌ benu wacheña lagy der ornu rne̱e̱ de coz nu rac gyishlombecy ii, zeꞌ yegar benu ne̱e̱ ga̱ꞌ de coz nu rac gyibaa cheña gaꞌ lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni tub la mbecy nigul chup yu gyibaa, sinu tub zi ya̱, biñ nu byac mbecy, bru̱u̱ gyibaa bri̱ gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Gal nu Moisees pcaay tub bily gyiib lo tub yag. Orzeꞌ pshes su dey yag zeꞌ lat nu gusa de too bel nin tub lugaar ub zi, niꞌ ziꞌl ya̱, biñ nu byac mbecy, rlagy ñi nu caa dey ya̱ lo tub yag nu she su dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Gun orzeꞌ de yu nu gyicy cup consuel lo̱, orzeꞌ de yu zeꞌ gad gyel mbañ nu tub la ni dey ―nam―. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Gun Ñgyoozh tonaꞌ la rcam de ru mbecy nu yuꞌ gyishlombecy ii. Ndeꞌ nu gal briic lam ya̱ iꞌñ mi nu tub zi zu nim ni der. Gun orzeꞌ de mbecy nu gyicy cup consuel lo̱, de yu zeꞌ wanit lo dey, sinu gad nu cui mbañ dey tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gun Ñgyoozh wanseed mi ya̱, biñ nu nac iꞌñ mi, gyishlombecy ii par nu niim nu yuꞌ falt ni de mbecy, sinu par nu co mbañ mi dey nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Cyu ziꞌl mbecy nu gyicy cup consuel lo̱ ya̱, iꞌñ Ñgyoozh, de yu zeꞌ wanii Ñgyoozh ti yuꞌ falt niy. Tees de yu nu wayicy cup consuel lo̱, Ñgyoozh bi mniim nu yuꞌ falt ni dey nu nac nu wangyicy cup dey consuel lo̱ ya̱, iꞌñ mi nu tub zi zu nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Rnii Ñgyoozh nu yuꞌ falt ni dey gun ya̱, biñ nu lyuu yaa ni coz rishli lo de mbecy, yapa̱ gyishlombecy ii, tees de mbecy bet zir lagy dey zeꞌ nu cow, gazeꞌ zeꞌ nu yuꞌ yaa ni coz rishli par nu nac nu shiñ ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ca ziꞌl na mbecy nu shiñ ricy, yu zeꞌ wagyet lagy yu zeꞌ nu yuꞌ yaa ni coz rishli, nunu wagyechaꞌy zeꞌ nu yuꞌ yaa ni coz rishli par nu walagy dey gyuꞌ bee de coz cyi nu ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tees ca ziꞌl na mbecy nu ricy coz nu laab ñi, yu zeꞌ yechaꞌy zeꞌ nu yuꞌ yaa ni coz rishli, gun de coz nap nu ricy yu, ndeꞌ coz nu bruu lo Ñgyoozh ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Na, despuees ornu bded de nu ndeꞌ, orzeꞌ Jesuuz gush nez mi za num de yu nu rsyaꞌ lom par de lo yu ni Judea. Zeꞌ pcyiiñ mi num dey la be dzi. Orzeꞌ briic mi nu bzu nis mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Niꞌ ziꞌl Waa rded yu driib nis yu mbecy tub gyedz nu la Enín garee ga gyedz nu la Salim, gun lugaar zeꞌ yuꞌ sheñ nis. Orzeꞌ de mbecy rza dey loy. Orzeꞌ rbic yu nu zu nis dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gun tiem zeꞌ Waa nigul gyet lag yu nañ yuꞌ gyiib. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na, la be de yu nu rsyaꞌ lo Waa, bee zi dey riidz nu tuubaꞌ mbecy Israeel gyiꞌ nu nac nu lac mod gyacaacy de mbecy par lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Orzeꞌ gua too dey rishlo Waa. Orzeꞌ na dey rab yuy: ―Masht, yu nu byeeñ nu ru tub laꞌ gaꞌ dzu ruꞌ gyoow Jordaang, laab yu nu bzat ru lo̱ de̱, yu zeꞌ driib nis yu mbecy. Nunu dela mbecy rza dey loy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Orzeꞌ na gaꞌ Waa rab yu dey: ―Ni tub la mbecy wac gyicy yu tub riiñ ni Ñgyoozh benu walab Ñgyoozh bduꞌm ñii yaay nu gyicy yuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","De ru bi güeñ der nu naal la mne̱e̱ lo der nu ya̱ walab Mesías, biñ nu ca lo cuen nu co mbañ mbecy, sinu ya̱ naca̱ tub yu nu bzuu nez Ñgyoozh nu cha̱ ga̱ lo par mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ya̱ na gal nu na tub amig ni tub yu nu nac nob. Biñ nu nac ni nob zeꞌ, mi zeꞌ par yu nu nac nob zeꞌ. Mi zeꞌ walab par amig niy. Zeꞌ yu nu nac amig niy, tonaꞌ la yet lagy yu ornu reñ yu nu zaab tiꞌy rniiy. Niꞌ ziꞌl na ya̱ tonaꞌ la yet lagya̱ nu nac de coz nu rniir lo̱, gal nu yet lagy de amig ni nob zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gun mi zeꞌ yagya zir zum. Zeꞌ ya̱ nu yagash zir zu̱ ―na Waa―. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Biñ nu bruu lo Ñgyoozh, mi zeꞌ gya zir zum par dela mbecy. Zeꞌ de ub na, mbecy nu bruu gyishlombecy ii, nac naa ni gyishlombecy. Orzeꞌ rnii den de coz nu rac gyishlombecy. Tees biñ nu bruu gyibaa, mi zeꞌ gya zir zum par dela mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mi zeꞌ rniim de coz nu bzaac mi, gal nu de coz nu güeñ mi, tees se ñuu zi zi mbecy “O” rnii nu nac de coz nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tees de mbecy nu “O” rnii ni de coz nu rniim, yu zeꞌ ricy dey nu gabe nu par ub yu, de riidz nu rnii Ñgyoozh, ndeꞌ riidz rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Zeꞌ biñ nu bzuu nez Ñgyoozh, mi zeꞌ rniim riidz ni Ñgyoozh, gun Ñgyoozh briic zaꞌ lam Espiriit Yon nim ni mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ñgyoozh, uz na, tonaꞌ la rcam iꞌñ mi, Jesuuz, nunu bicy mi nu mi zeꞌ gyub ic mi dela coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","De yu nu gyicy cup consuel lo iꞌñ mi, de yu zeꞌ cui mbañ dey tub la. Tees de yu nu wazuub gyidag nim, de yu zeꞌ wad nu cui mbañ dey. Sinu Ñgyoozh zeed mi cashtig ily nim too dey ―na Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","De mbecy fariseo güeñ dey nu zigy zir de mbecy nu za ca ich Jesuuz, gazeꞌ de yu nu za ca ich Waa. Nunu rbic zir mi nu zu nis mbecy gazeꞌ Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mas walab ub la Jesuuz driib nis mi mbecy, sinu de yu nu rsyaꞌ lom rbic dey nu zu nis mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na ornu gud lagy Jesuuz de nu ndeꞌ, orzeꞌ bruum lo yu ni Judea, orzeꞌ yam par de lo yu ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na zeꞌ nu yam rlagy ñi nu ded mi lo de yu ni Samaria. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Orzeꞌ bruꞌñam tub gyedz nu la Sicar nu ri lo yu ni Samaria. Gyedz zeꞌ gare ga ri tub nac yu nu briic Jacob ni iꞌñ yu See. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lugaar zeꞌ zub zo nu rnii dey, “Zo ni Jacob.” Zeꞌ gusub Jesuuz nu rzu lagy mi gun gutsiñ mi nu tuñ bzam nez. Ndeꞌ tub or widoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Orzeꞌ de yu nu rsyaꞌ lom bzeeñ dey mi. Orzeꞌ za dey lat gyedz nu za zii dey coz nu gow yu. Orzeꞌ bruꞌña tub biñ mñaa Samaria, bruꞌñam ruꞌ zo zeꞌ nu za gyiim nis. Orzeꞌ na Jesuuz rab mi biñ mñaa zeꞌ: ―Doo ñuu nis nir do̱ꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Orzeꞌ na biñ mñaa zeꞌ rab mi Jesuuz: ―Ru nac ru tub mbecy Israeel. Zeꞌ ya̱ naca̱ tub biñ mñaa Samaria. Orzeꞌ ¿lagu rgyiiñ ru nis goꞌr lo̱? ―nam. Gun de mbecy Israeel wagac gyicy dey ni tub la coz nu mbecy Samaria, gun a̱ꞌ nap yuꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Orzeꞌ na gaꞌ Jesuuz rab mi biñ mñaa zeꞌ: ―Bi bicy na nu ru gad lagy ru la na coz nu rbic Ñgyoozh, nunu bicy na nu gad lagy ru cyu nac ya̱, nu rdiña̱ nis do̱ꞌ lor, orzeꞌ ru cyiñ ru nis lo̱ ya̱ goꞌr. Orzeꞌ ya̱ rica̱ nis nu rbic gyel mbañ nu rishli nu goꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Orzeꞌ biñ mñaa Samaria zeꞌ nam rab mi Jesuuz: ―Zeꞌ ru, ni a̱ꞌ nur la nu par nu cor nis, gun zo ii gyi ri nis nañ ñi. Zeꞌ ru, ¿ca cor nis nu cuic gyel mbañ zeꞌ ne̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gyitoo bel ne̱ de̱ Jacob bzeeñ mi zo ii ne̱ de̱ ya̱. Nunu laab ii goꞌm nis gal nu de iꞌñ mi nu de bañcyug nim. ¿Walab gaal lily zir na ru gazeꞌ gyitoo bel ne̱ de̱ zeꞌ? ―na biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Orzeꞌ na Jesuuz: ―Dela de mbecy nu goꞌ nis ii, wayeca nu cuigy zir dey nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Zeꞌ de mbecy nu goꞌ nis nu ya̱ grica̱, de mbecy zeꞌ rila wabigyaꞌ dey nis. Gun nis nu ya̱ grica̱, ndeꞌ gyicy ñi nu gyac nañ lardoo dey gal na tub zeꞌ nu driib nis. Nis zeꞌ gyicy ñi nu cui mbañ dey tub la ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Orzeꞌ na biñ mñaa zeꞌ rab mi Jesuuz: ―Beni, orzeꞌ cuic ru nis zeꞌ do̱ꞌ gun cueꞌ gaꞌ nu cuigya̱ꞌ ñii nunu cueꞌ gaꞌ gyap gyi̱i̱ ñii ii ―na biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Orzeꞌ na gaꞌ Jesuuz: ―Yaa, ya te ñgyeer, nunu cyid nur yu ii ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Orzeꞌ na gaꞌ biñ mña̱a̱ zeꞌ: ―Sac ñgye̱e̱ ya̱ ―nam. Orzeꞌ na gaꞌ Jesuuz: ―Ru gaal rishli rniir nu sac ñgyeer, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gun bi bzu gaay ñgyeer. Zeꞌ yu nu zu gaꞌ na, yu zeꞌ walab ñgyeer. Ru rishli mniir lo̱ nu sac ñgyeer ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ornu biñ mñaa zeꞌ güeñ mi nu ndeꞌ, orzeꞌ nam rab mi Jesuuz: ―Na bet laga̱ cuen nu ru nac ru tub biñ nu rnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","De gyitoo bel ne̱ de̱, de biñ Samaria, briib zily dem Ñgyoozh too bicy ii. Zeꞌ de ru rnii der nu gal Jerusaleeng rlagy ñi nu riib zily mbecy Ñgyoozh, rnii der ―na biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Orzeꞌ na Jesuuz rab mi biñ mñaa zeꞌ: ―Biñ mñaa, guña ñuu lagy riidz nu rne̱e̱. Shuub tub dzi nu de mbecy griib zily dey Ñgyoozh, uz den. Orzeꞌ walagyaꞌñ nu cyid dey too bicy ii, ni nu gya dey Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","De ru mbecy Samaria wagad lagy der la na biñ nu driib zily ru. Tees de̱ ya̱ mbecy Israeel rad lagy de̱ la na biñ nu driib zily de̱, gun lat de mbecy Israeel gruu mod par nu gruu mbañ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tees shuub dzi, nunu na la ndeꞌ ornu de mbecy nu rishli gaal griib zily Ñgyoozh uz na gyicy dey ñi tub mod nu rishli, mod nu rlagy Espiriit Yon ni Ñgyoozh, gun ndeꞌ mod nu rlagy Ñgyoozh uz na. Ndeꞌ mod nu rlagy mi nu gyicy de yu nu griib zily mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gun Ñgyoozh nac mi Espiriit, nunu de yu nu griib zily mi rlagy ñi nu gyicy dey ñi tub mod nu rishli, tub mod nu rlagy Espiriit Yon nim ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Orzeꞌ na biñ mñaa zeꞌ rab mi Jesuuz: ―Rad lagya̱ nu cyid Mesías, biñ nu pcui Ñgyoozh nu co mbañ mi den. Laab mi zeꞌ lam Crisht. Ornu mi zeꞌ cyid mi, orzeꞌ shaal mi dela coz lo̱ de̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Orzeꞌ na gaꞌ Jesuuz: ―Mi zeꞌ nac ya̱, biñ nu rnii nu ru na la ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Laab or la zeꞌ bri de yu nu rsyaꞌ lom. Orzeꞌ za nu la ic dey nu Jesuuz rom riidz nu tub biñ mñaa. Tees ni tub la dey wancuic yu baloor nu ngugyiꞌy lo biñ mñaa zeꞌ la coz rlagy mi, o nu ngugyiꞌ dey lo Jesuuz ben lagu ro num biñ mñaa zeꞌ riidz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Orzeꞌ biñ mñaa zeꞌ bzeeñ ga lam reꞌ nim. Yam lat gyedz. Orzeꞌ nam rab mi de mbecy: ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Da der gun cha güiir tub biñ gyeey nu mniim dela coz nu bicya̱. ¿Ben a chii la a walab mi zeꞌ Mesías? ―na biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Orzeꞌ bruu de mbecy lat gyedz zeꞌ za dey lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lat nu ya biñ mñaa zeꞌ, orzeꞌ de yu nu rsyaꞌ lo Jesuuz rnishbaa dey lom nu gow mi gyit. Orzeꞌ na dey: ―Masht, bdow mas ñuu miꞌ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Orzeꞌ nam rab mi dey: ―Ya̱ ricy cupa̱ coz nu da̱w. Tees de ru wagad lagy der la coz ndeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Orzeꞌ de yu nu rsyaꞌ lom brugyiꞌ rgugyiꞌ dey lo losaꞌy. Orzeꞌ na dey: ―¿Walab gaal bi biid nu ca na mbecy coz nu gow mi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ornu gyicya̱ coz nu rlagy Ñgyoozh, biñ nu bzuu nez ya̱, nunu ornu gzaꞌ lo̱ riiñ nim, orzeꞌ ndeꞌ nañ gal na de coz nu da̱w. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","De ru mbish tub riidz nu rnii der: “Gabee ricy falt ruꞌ tap beey par nu teꞌn cosech”, rnii der. Zeꞌ ya̱ rne̱e̱ lo der nu güiir lo de mbecy nu yad ii. Na dey gal nu na tub nac gyel. Güii la nañ. Bi guc niñ nu dudeꞌ cosech, gun bi zu lily dey nañ lardooy nu gyicy cup dey consuel lo̱ ―na Jesuuz―. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","’Gun de yu nu cha teꞌ cosech zeꞌ, bi gyad iy, nunu cosech nu rteꞌ dey zeꞌ, ndeꞌ de mbecy par nu cui mbañ dey tub la, gun orzeꞌ de yu nu rnuuz, gal nu de yu nu rteꞌ tublaazh la gyet lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nii tub riidz nu rishli nu rnii mbecy: “Tub yu rnuuz yu. Zeꞌ tuubaꞌy rteꞌy.” ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya̱ bzuu neza̱ der nu gua teꞌr lat tub nac gyel zeꞌ nu wangyicy la der riiñ. Zeꞌ reñaꞌ dey bicy yu riiñ lat gyel zeꞌ. Zeꞌ de ru byash der cosech nu nac riiñ nu bicy reñaꞌ dey ―nam rab mi de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, tonaꞌ la zigy de mbecy Samaria nu yuꞌ gyedz zeꞌ bicy cup dey consuel lo Jesuuz nu nac nu mnii biñ mñaa zeꞌ lo dey. Orzeꞌ nam: “Mi zeꞌ mniim lo̱ dela coz nu bicya̱”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na ornu bruꞌña de mbecy Samaria lom, orzeꞌ mnishbaa dey lom nu gyiyeeñ mi num dey. Orzeꞌ byeeñ num dey cyup dzi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Orzeꞌ zigy zir mbecy bicy cup dey consuel lo Jesuuz nu nac de riidz nu mniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Orzeꞌ na dey rab yu biñ mñaa zeꞌ: ―Na ricy cup de̱ consuel lo Jesuuz walab nu nac riidz nu mnii ziꞌl ru, sinu nu nac nu güeñ gyidag la de̱. Nunu rishli gud lagy de̱ nu mi ii nac mi biñ nu co mbañ de mbecy nu yuꞌ gyishlombecy ―na dey rab yu biñ mñaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na ornu bded ni cyup dzi zeꞌ, orzeꞌ bruu Jesuuz Samaria nu yam par lo de yu ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Gun laab ub mi mniim nu tub yu nu rnii por cuen ni Ñgyoozh waca lagy de mbecy ledz yu loy, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na ornu brim lo de yu ni Galilea, orzeꞌ de mbecy nu yuꞌ de lugaar zeꞌ nap bicy nu dey mi, gun bi bya dey saꞌ ni Pas Jerusaleeng. Ndeꞌ bi bzaac dey de coz nu bicy mi lat saꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Orzeꞌ Jesuuz bish cyam zam Caná, tub gyedz nu ri lo yu ni Galilea. Laab lugaar zeꞌ nu bicy mi nu byac nis ñup ni urbyay. Na zu tub mbecy nu zu riiñ ni gubier. Zeꞌ iꞌñ yu mbish rat yu Capernaum. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yu zeꞌ, ornu güeñ yu nu bruum Judea nu brim Galilea, orzeꞌ guay mnishbaay lom nu cham yuꞌy nu gyicy yac mi iꞌñ yu, gun bi zuu lay nu gat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Orzeꞌ Jesuuz nam rab mi yu nu zu riiñ zeꞌ: ―De ru wagyicy cup der consuel lo̱ benu wazac der muesht o nusuriidz ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Orzeꞌ na yu nu zu riiñ zeꞌ rab yu Jesuuz: ―Jesuuz, yaa chan gun nis gat iꞌña̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Orzeꞌ na Jesuuz rab mi yu: ―Yaa la gun iꞌñ ru mbañ yu ―nam. Orzeꞌ mbecy zeꞌ guña lagy yu de riidz nu mnii Jesuuz. Orzeꞌ yay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na nez nu yay, orzeꞌ gua cheel de moz niy yu. Orzeꞌ na dey: ―¡Iꞌñ ru mbañ yu! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Orzeꞌ bdugyiꞌy lo dey ben la or brugyiꞌ nu zesu nap lagy iꞌñ yu. Orzeꞌ na dey rab yuy: ―Naag, tub gyiib tub or gudze, orzeꞌ bruu zig yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Orzeꞌ byezaꞌ lagy yu nu laab or zeꞌ mnii Jesuuz loy. Ornu nam: “Iꞌñ ru gruu mbañ yu”, nam. Orzeꞌ bicy cup dey consuel lom nu dela famil niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ndeꞌ nusuriidz cyup nu bicy Jesuuz despuees nu bruum lo yu nu la Judea ornu zam par lo de yu ni Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Despuees ni de nu ndeꞌ, orzeꞌ de mbecy Israeel guꞌ dey tub saꞌ. Orzeꞌ Jesuuz yaa gaꞌm par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na Jerusaleeng, garee ga zeꞌ nu ca tub gyeroꞌ ily nu la roꞌ ni shily, zeꞌ ri tub gyel. Gyel zeꞌ lañ benu nu riidz hebreo, orzeꞌ lañ Betzata. Zeꞌ ruꞌ gyel zeꞌ ca gaay coredoor. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Zeꞌ nañ de coredoor zeꞌ nguaa zigy mbecy rat. Zeꞌ nguaa lo caꞌ, nguaa mbecy coj, nguaa gaꞌ mbecy chi̱. Zeꞌ nguaa dey lo yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Zeꞌ nguaa rbez dey gun gul gul yet tub anc ni Ñgyoozh nu rcueñ suy nis ni gyel zeꞌ, gun yu rat nu gyicy gan nu gyet loñ loga la, ornu rcueñ ñii, orzeꞌ yu zeꞌ gyac yu ni cualcyer la güii nu ricy cup yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lat de yu rat zeꞌ ri tub yu nu bi bzaꞌ gal rub tiiñ zu chon ñaꞌn nu rat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ornu Jesuuz bzaac mi yu, orzeꞌ como gud lagy mi nu bi rac ñaꞌn mbish rat yu, orzeꞌ nam rab mi yu: ―¿A rlagy ru gyac ru? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Orzeꞌ na yu rat zeꞌ: ―Wagad cyu nu locyuub ya̱ nu gyeta̱ lo nis re ornu rcueñ suñ. De tir la ornu rcueñ suñ, ornu ricy pe̱e̱ nu gyeta̱, orzeꞌ ricy reñaꞌ dey gan ya̱ nu yet yu loñ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Orzeꞌ na Jesuuz rab mi yu: ―Wesh te nunu byash daꞌ nir nunu bza ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Orzeꞌ lueg la byac yu, nunu byash yu daꞌ niy, nunu brugyiꞌ rzay. Zeꞌ dzi zeꞌ, ndeꞌ sab dzi nu rzu lagy mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Orzeꞌ de yu zub lo ni de mbecy Israeel na dey rab yu yu nu byac zeꞌ: ―Na dzi sab, dzi nu rzu lagy mbecy. Zañ contr ni leey nin nu gya nur daꞌ nir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Orzeꞌ na yu nu gurat zeꞌ rab yu dey: ―Yu nu bicy yac ya̱ nay rab yu ya̱: “Byash daꞌ nir nunu bza”, nay rab yu ya̱ ―na yu rat zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Orzeꞌ na gaꞌ dey rab yu yu nu gu rat zeꞌ: ―¿Cyu mbecy nu mnii lor nu gyash ru daꞌ nir, nunu bza? ―na dey rab yu yu gurat zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tees yu nu gurat zeꞌ wangad lagy yu cyu nac biñ nu bicy nu byac yu, gun Jesuuz mnit mi lat de mbecy zigy nu yuꞌ lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na despuees, orzeꞌ byap Jesuuz yu nu gurat zeꞌ loliꞌ ni yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. Orzeꞌ nam rab mi yu: ―Güii na, ru bi byac ru. Cueꞌ gaꞌ gyicy ru coz cyi, nis shiñ zir gzac ru par lo ―nam rab mi yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Orzeꞌ yu gurat zeꞌ bruu chuy lo Jesuuz nu za tooy rishlo de yu zub lo ni de mbecy Israeel nu Jesuuz bicy yac mi yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gyiꞌ ndeꞌ brugyiꞌ nu zaab mbecy ich Jesuuz: gyiꞌ nu bicy yac mi tub mbecy sab, dzi nu rzu lagy mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Orzeꞌ Jesuuz nam rab mi dey: ―Ñgyoozh, uza̱, zaab ricy lam riiñ. Ndeꞌ nu niꞌ ya̱ ricya̱ riiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nu nac riidz zeꞌ, orzeꞌ de mbecy Israeel bzu fert zir dey nu cut yu Jesuuz, gun walab tub lo ziꞌl nu nac nu zam contr ni leey ni dzi sab, dzi nu rzu lagy mbecy, sinu niꞌ ziꞌl nu bicy mi nu gal gaa la nac mi nu Ñgyoozh ornu mniim nu Ñgyoozh nac mi uz mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu ya̱ biñ nu nac iꞌñ Ñgyoozh wac gyicya̱ ni tub la coz nu nac shcab ziꞌl ne̱, sinu ricya̱ coz nu rzaca̱ nu ricy Ñgyoozh uza̱. Gun la ziꞌl coz nu ricy Ñgyoozh uza̱ niꞌ ziꞌl ricy ya̱ iꞌñ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gun Ñgyoozh uza̱ rcam ya̱, biñ nu nac iꞌñ mi, nunu rlyuum lo̱ de coz nu ricy mi; nunu coz ily zir lyuum nu gyicya̱ gun orzeꞌ cha nu ic der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gal nu Ñgyoozh uza̱ gyicy mi nu gyabañ de añ nu bi gut nunu cuic mi nu cui mbañ dey, niꞌ ziꞌl ya̱, iꞌñ mi, rica̱ gyel mbañ ni cyu ziꞌl nu galagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gun Ñgyoozh, uza̱, wari beem ni ni tub la mbecy ni de cyi nu ricy dey, sinu ndeꞌ bzeeñ mi yaa ya̱, iꞌñ mi, nu gri be̱e̱ ni de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Gun orzeꞌ dela mbecy ca lagy dey lo̱ ya̱, gal nu rca lagyaꞌ dey lo Ñgyoozh uza̱. De yu nu waca lagy lo ya̱, niꞌ ziꞌl waca lagy dey lo Ñgyoozh uza̱, biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ya̱ rishli rne̱e̱ lo der nu de yu nu gzuub gyidag de riidz nu ya̱ rne̱e̱, nunu gyicy cup dey consuel lo biñ nu bzuu nez ya̱, orzeꞌ de yu zeꞌ cui mbañ yu tub la. Wane̱e̱ nu yuꞌ falt niy, sinu bi bded loy lo lugaar zeꞌ nu yuꞌ mbecy gut. Bi guud nu cui mbañ dey tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya̱ rishli rne̱e̱ lo der nu shuub tub tiem, nunu tiem zeꞌ, ndeꞌ bi guush ñi nese na la, ornu gyeñ gyidag de yu nu na gal nu na añ de riidz nu ne̱e̱ ya̱, iꞌñ Ñgyoozh, orzeꞌ de yu nu gyeñ de riidz zeꞌ gad nu cui mbañ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gun gal nu Ñgyoozh uza̱ ricy mi nu cui mbañ de mbecy, ndeꞌ nu niꞌ ziꞌl ya̱, iꞌñ mi bicy mi nu gyicya̱ nu cui mbañ de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nunu briic mi rishbeey ne̱ nu gri be̱e̱ ni de mbecy, gun ya̱ naca̱ biñ nu byac mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cueꞌ cha nu ic der nu nac de riidz ii, gun shuub dzi nu dela de añ gyeñ dey nu zaab ti̱ꞌ ornu gne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Orzeꞌ gruu dey gyerbaa niy. Orzeꞌ de yu nu nap bicy, gyabañ dey par nu cui mbañ yu. Zeꞌ de yu nu shiñ bicy gyabañ dey par nu gyay lo cashtig. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Wac gyicya̱ ni tub la coz nu gruu ic ziꞌla̱. Tees gri be̱e̱ ni mbecy gal nu reña̱ nu rnii Ñgyoozh, uza̱. Nunu coz nu gne̱e̱ ornu gri be̱e̱, ndeꞌ coz nu seꞌñ, gun ya̱ walab nu ricya̱ coz nu rlagy uba̱, sinu ricya̱ coz nu rnii uza̱, biñ nu bzuu nez ya̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Benu laab uba̱ cha̱ faboor ne̱, orzeꞌ wacyiiñ riidz nu rne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tees zu tuubaꞌ biñ nu rza faboor ne̱, nunu rad lagya̱ nu riidz nu rniim, ndeꞌ coz rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Na de ru bzuu nez der mbecy nu cha tugyiꞌy lo Waa nu driib nis mbecy, nunu de riidz nu mnii yu zeꞌ, ndeꞌ coz rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Zeꞌ ya̱, walab nu rlagy ñi tub mbecy nu chay faboor ne̱, tees ya̱ rzata̱ Waa lo der gun dzi ga gruu mbañ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yu zeꞌ nay gal nu na tub candiil par nu cuic ñi yaa. De ru bet lagy der yaa zeꞌ la be ziꞌl dzi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tees yuꞌ coz nap zir cuic ñi nu gad lagy der cyu naca̱ gazeꞌ de riidz nu mnii Waa. De coz nu ricya̱, laab de coz nu mnii Ñgyoozh lo̱ nu gyicya̱, de ndeꞌ ricy ñi nu gabe cyu naca̱, nunu gyicy ñi nu gabe nu mi zeꞌ bzuu nez mi ya̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nunu niꞌ Ñgyoozh, uza̱, biñ nu bzuu nez ya̱ rniim cyu naca̱. Zeꞌ de ru rila wangyeñ der de riidz nu rniim, nunu rila wanchuꞌ lo der mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nunu wancheti riidz nim nañ lardoo der, gun wangyicy cup der consuel lo ya̱, biñ nu bzuu nez mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","De ru nap rsyaꞌ der riidz ni Ñgyoozh gun rash der shcab nu lat de riidz zeꞌ gyap der riidz nu gyicy ñi nu cui mbañ der tub la. Zeꞌ lat de riidz zeꞌ rzat ñi ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Zeꞌ de ru walagy der cyid ru lo̱ par nu gad gyel mbañ zeꞌ ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’A̱ꞌ ricy ñi presis ne̱ nu gyabic mbecy gyel mbecy ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tees rad lagya̱ la na der nunu rad lagya̱ nu waca der Ñgyoozh nañ lardoor. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gun ya̱ yapa̱ por mandaar ni Ñgyoozh uza̱. Zeꞌ de ru wacshet ic der nu chu̱ꞌ lat der. Tees benu ruꞌña reñaꞌ mbecy nu mandaar ni ub ziꞌl yu, orzeꞌ rshet ic der nu chuꞌy lat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","De ru, lat de ub ziꞌl ru, driib zily der losaꞌr. Rila wagyub der mod par nu Ñgyoozh ziꞌl griib zily mi der. Benu ni gyicy der, ¿lac mod gyicy cup der consuel lo̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Cueꞌ nii too der nu ya̱ du̱ꞌ cyi̱ der lo Ñgyoozh uza̱. Yu nu rguꞌ cyi der lo Ñgyoozh, ndeꞌ Moisees, yu nu bzeeñ leey nu rgyish lo der lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Gun benu de ru ñgyeña lagy der ni de riidz nu bzeeñ Moisees zeꞌ, orzeꞌ niꞌ ziꞌl ñgyeña lagy der ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tees como wancheña lagy der ni de riidz nu bzeeñ Moisees, orzeꞌ lac mod cheña gaꞌ lagy der de riidz nu rne̱e̱ ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na despuees ni de nu ndeꞌ, orzeꞌ Jesuuz zam tub laꞌ gaꞌ ruꞌ nisyudoo ni Galilea. Laab ndeꞌ nisyudoo ni Tiberias. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Orzeꞌ zigy mbecy za ca dey ich mi, gun bzaac dey de nusuriidz ily nu bicy mi nu de mbecy rat zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Orzeꞌ Jesuuz gup mi too tub bicy. Orzeꞌ gusub mi nu de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na tiem zeꞌ bi rgaab tub saꞌ ni de mbecy Israeel nu la saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na ornu briꞌ lom, orzeꞌ bzaac mi nu tonaꞌ la zigy mbecy bdeꞌ dey lom. Orzeꞌ nam rab mi Lip: ―¿Ca chan cha gyiin coz nu gric na gow dela de mbecy ii? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ni mniim ben la gnii Lip, gun ub mi bi rad lagy mi la na coz nu gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Orzeꞌ na Lip rab yum: ―Ni nu sac i moz ni cyup gaynal dzi wal ñii nu gad coz nu gow dey mas ñuu ga ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Orzeꞌ brusu tub dey lat de yu nu rsyaꞌ lom, yu nu la Ndrees, yu zeꞌ laab bicy Simo̱o̱ Bed. Orzeꞌ nay rab yu Jesuuz: ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ii zu tub yu nguzh nuuy gaay gyishtily nu byaa nu arin ni sebada, nunu nuuy cyup bel. ¿Par ca gal laa ndeꞌ lat de mbecy zigy? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Orzeꞌ na gaꞌm rab mi yu: ―Mnii der lo dela mbecy nu gzub dey ―nam. Lugaar zeꞌ tonaꞌ la nash gyizh caꞌ. Orzeꞌ gucua dey loñ. Nac tub gaay miily yu gyeey lat de mbecy nu gucua lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Orzeꞌ Jesuuz gush mi de gyishtily zeꞌ. Orzeꞌ briic mi gras ni Ñgyoozh. Orzeꞌ briic mi ñii nu dugyeez ñi lat de mbecy nu nguaa zeꞌ. Niꞌ ziꞌl bicy mi nu de bel zeꞌ nu dugyeez ma lat dey dub gal nu galagy ñi ni tub ga dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na ornu blazh bdow dey, orzeꞌ na Jesuuz rab mi de yu nu rsyaꞌ lom: ―Gua teꞌ der de coz nu brusub gun cueꞌ nu nit loñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Orzeꞌ de yu zeꞌ brugyiꞌ rteꞌ dey de gyishtily nguzh nu brusub ni gaay gyishtily sebada zeꞌ. Orzeꞌ bduꞌ dey ñi nañ trocyup chicyiw nunu bdzaa lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ornu bzaac de mbecy nu nguaa zeꞌ nusuriidz nu bicy Jesuuz nu de gyishtily zeꞌ, orzeꞌ na dey rab yu losaꞌy: ―Rishli gaal mi ii nac mi tub biñ nu rnii por cuen ni Ñgyoozh. Mi ii nac mi biñ nu rnii por cuen ni Ñgyoozh nu ca lo cuen nu cyid gyishlombecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tees Jesuuz gud lagy mi nu rlagy dey nu zeeñ yum rey por fers la. Orzeꞌ bruum lat dey zam ub zim too tub bicy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na ornu becheñ, orzeꞌ de yu nu rsyaꞌ lo Jesuuz bet dey par ruꞌ nisyudoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Orzeꞌ guꞌ dey nañ tub barc. Orzeꞌ bded dey lo nisyudoo par nu cha dey par Capernaum. Na ornu bi bet rel nap la, orzeꞌ gaal zi nigul ruꞌña Jesuuz lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Laab or zeꞌ tonaꞌ la fert bruꞌña tub bi ily, nunu tonaꞌ la ricy ñi nu rzup nguuly lo nisyudoo zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na ornu dzi bi psaa dey barc zeꞌ lo nis nu rnii tub gaay o shuup miily metr, orzeꞌ bzaac dey Jesuuz nu rzam lo nis, nunu yagaab mi lo dey. Orzeꞌ tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Orzeꞌ nam rab mi dey: ―¡Ya̱ nu ndeꞌ! ¡Cueꞌ dzib der! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Orzeꞌ de yu zeꞌ pshet ic dey nu chuꞌm nañ barc zeꞌ. Orzeꞌ sij la bri dey gashtal lugaar zeꞌ nu rsaap dey chay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na ornu bzaꞌ yu tuubaꞌ dzi, orzeꞌ de mbecy nu byeeñ tub laꞌ gaꞌ dzu ruꞌ nisyudoo brugyiꞌ rnii too dey. Gud lagy dey nu za ga de yu nu rsyaꞌ lo Jesuuz nañ tub zi barc nu zu lugaar zeꞌ. Nunu gud lagy dey nu de yu zeꞌ wancha nu dey Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Zeꞌ lat zeꞌ bri reñaꞌ barc. Barc zeꞌ bruuñ gyedz Tiberias. Briñ gaab ga lugaar zeꞌ nu bdow dey gyishtily despuees ornu Shuaan na Jesuuz briic mi gras ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na ornu de mbecy zigy zeꞌ bzaac dey nu sac Jesuuz lugaar zeꞌ gal nu de yu nu rsyaꞌ lom, orzeꞌ niꞌ ziꞌl de mbecy zeꞌ guꞌ dey nañ barc. Orzeꞌ za dey za yub yum par Capernaum. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na ornu bri de mbecy zigy zeꞌ tub laꞌ gaꞌ ruꞌ nisyudoo, orzeꞌ bdzeel dey Jesuuz. Orzeꞌ na dey rab yum: ―Masht, ¿gul brir lugaar ii? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu de ru ryub der ya̱ par nu nac nu brica̱ nu bdow der nu byel la nir. Walab par nu bet lag der cuen de nusuriidz nu bicya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Cueꞌ gyicy der riiñ par de coz nu gow der gyishlombecy ii, gun ndeꞌ wazu tuuñ ñi; sinu bicy der riiñ par de coz nu gow der nu gyicy ñi nu cui mbañ der tub la. Ndeꞌ coz nu gric ya̱, biñ nu byac mbecy. Gun de nusuriidz nu ricya̱, ndeꞌ tub sey nu briic Ñgyoozh ne̱ par nu gabe nu laab ñi de riidz nu rne̱e̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Orzeꞌ na dey rab yum: ―¿Ca na coz nu rlagy ñi nu gyicy de̱ par nu gyicy de̱ coz nu rlagy Ñgyoozh? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Coz nu rlagy Ñgyoozh nu gyicy der, ndeꞌ nu gyicy cup der consuel lo ya̱, biñ nu bzuu nez mi ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Orzeꞌ na dey rab yu Jesuuz: ―¿La ñuu nusuriidz lyuur lo̱ de̱ par nu gzac de̱, gun orzeꞌ gyicy cup de̱ consuel lor? ¿La ñuu na coz nu gyicy ru? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gun de gyitoo bel ni den bdow dey tub lo gyishtily nu la maná. Ndeꞌ bruuñ gal gyibaa lat nu gusa dey de lugaar ub zi, gal nu rniiñ lat riidz ni Ñgyoozh: “Ñgyoozh briic mi gyishtily nu bruu gyibaa gow dey”, rniiñ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu walab Moisees briic yu gyishtily nu bruu gyibaa nu gow dey, sinu Ñgyoozh, uza̱, briic mi ñii. Zeꞌ na Ñgyoozh, uza̱, mi zeꞌ rbic mi gyishtily nu rishli nu bruu gyibaa nu gow der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gun gyishtily nu rbic Ñgyoozh zeꞌ, ndeꞌ gyishtily nu bruu gyibaa bet ñi gyishlombecy ii, nunu rishli rbic ñi nu cui mbañ de mbecy gyishlombecy ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Orzeꞌ na dey rab yum: ―Jesuuz, cuic ru gyishtily nu rniir zeꞌ da̱w de̱ de dzi la ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ naca̱ gyishtily nu rbic gyel mbañ zeꞌ. Yu nu gyechaꞌ lo̱, yu zeꞌ rila wariibaꞌ nu gyan yu nañ lardooy. Nunu de yu nu gyicy cup consuel lo̱ rila wariibaꞌ nu cuigy dey nis nañ lardooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tees ya̱ bi mne̱e̱ lo der nu mas rzac der ya̱, tees wayicy cup der consuel lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dela de yu nu rbic Ñgyoozh ne̱ yechaꞌ dey lo̱. Nunu de yu nu gyechaꞌ lo̱ walo̱o̱ chu̱ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gun ya̱ walab nu bru̱u̱ gyibaa par nu yapa̱ nu gyicya̱ coz nu rlagy uba̱, sinu yapa̱ nu gyicya̱ coz nu rlagy Ñgyoozh, uza̱, biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nunu biñ nu bzuu nez ya̱ zeꞌ rlagy mi nu ni gyicya̱ nu cueꞌ zaana̱ nu duneꞌ ni tub la mbecy nu briic mi ne̱, sinu gyicya̱ nu gyabañ de mbecy nu bi gut ornu laab ndeꞌ la nu shuub dzi nu ded ni gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gun coz nu rlagy Ñgyoozh, uza̱, ndeꞌ nu dela mbecy nu cuꞌ lo ya̱, iꞌñ mi, nunu gyicy cup dey consuel lo̱, orzeꞌ cui mbañ dey tub la; nunu gyicya̱ nu gyabañ de mbecy nu bi gut ornu laab ndeꞌ la nu shuub dzi nu ded ni gyishlombecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Orzeꞌ la be de mbecy Israeel brugyiꞌ rnii deet dey nu nac Jesuuz, par nu mniim: “Ya̱ naca̱ gyishtily nu bruu gyibaa beta̱ gyishlombecy ii”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nunu na gaꞌ dey: ―¿A walab yu ii, yu nu nac iꞌñ See? De ub na yuꞌ lo den uz yu, nunu yuꞌ lo den ñaay. Güii la rnii gaꞌy na. Nay nu gyibaa bruuy bet yu gyishlombecy ii ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Cueꞌ nii deet der lat losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni tub la mbecy wac gyechaꞌ dey lo̱ benu walab Ñgyoozh uza̱ biñ nu bzuu nez ya̱, rniim nañ lardoo dey nu gyechaꞌy lo̱. Nunu gyicya̱ nu gyabañ yu ornu shuub dzi nu ded ni gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Gun ca tub riidz lat de riidz nu bzeeñ de yu nu mnii por cuen ni Ñgyoozh. Orzeꞌ rniiñ: “Ñgyoozh rlyuum ni dela mbecy”, rniiñ. Ndeꞌ nu dela de yu nu rzuub gyidag de riidz ni Ñgyoozh uza̱, nunu rsyaꞌ dey lom, de yu zeꞌ gyechaꞌ dey lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ndeꞌ nu walab nu ca na tub mbecy bi bzaac yu Ñgyoozh uza̱; sinu tub zi la ya̱, biñ nu bruu lom rzaca̱m. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ya̱ rishli rne̱e̱ lo der nu cyu ziꞌl yu nu gyicy cup consuel lo̱, yu zeꞌ bi guud nu cui mbañ yu tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gun ya̱ naca̱ gyishtily nu cuic gyel mbañ ni mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","De gyitoo bel ni de ru bdow dey gyishtily nu la maná nu briic Ñgyoozh lat nu gusa dey de lugaar ub zi, tees gut dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tees gyishtily nu ya̱ rzata̱ lo der, ndeꞌ gyishtily nu bruu gyibaa. Mbecy nu gow gyishtily zeꞌ wat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ya̱ naca̱ gyishtily nu cuic gyel mbañ: gyishtily nu bruu gyibaa. De yu nu gow gyishtily zeꞌ, cui mbañ yu tub la, nunu gyishtily nu ya̱ grica̱ ni dey, ndeꞌ laab cuerp ne̱. Rica̱ ñii, gun orzeꞌ de mbecy gyishlombecy gad nu cui mbañ dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Orzeꞌ la be de mbecy Israeel brugyiꞌ nu ro zi dey riidz nu losaꞌy. Orzeꞌ na dey: ―¿Lac mod gyicyaꞌ yu ii par nu cuic yu cuerp niy dow den? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der benu wow der cuerp ne̱ ya̱, biñ nu byac mbecy, nunu benu woꞌ der reña̱, orzeꞌ wad nu cui mbañ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cyu ziꞌl mbecy nu gow cuerp ne̱ nunu goꞌy reña̱, yu zeꞌ bi guud nu cui mbañ yu tub la, nunu gyicya̱ nu gyabañ yu ornu laab ndeꞌ la nu shuub dzi nu ded ni gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gun cuerp ne̱, ndeꞌ tub comid nu rishli gaal. Zeꞌ reña̱, ndeꞌ tub nis nu rishli gaal nu goꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gun de yu nu gow cuerp ne̱ nunu goꞌy reña̱, de yu zeꞌ cyiiñ du̱ yu, nunu de yu zeꞌ cyiiñ nuy ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ñgyoozh uza̱, biñ nu bzuu nez ya̱, mbañ mi, nunu ya̱ mbaña̱ par nu nac mi zeꞌ. Ndeꞌ nu niꞌ ziꞌl mod de yu nu gow cuerp ne̱, cui mbañ yu nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gyishtily nu ya̱ rzata̱ lo der, ndeꞌ gyishtily nu bruu gal gyibaa. Gyishtily nu rne̱e̱ ii, nii wasaap ñi gyishtily nu la maná nu bdow de gyitoo bel ni den. Mas bdow dey de gyishtily zeꞌ, tees gut dey. Zeꞌ de yu nu gow gyishtily nu ya̱ rne̱e̱, de yu zeꞌ cui mbañ dey tub la ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","De nii coz nu blyuu Jesuuz ni de mbecy nu byatublaazh nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh Capernaum. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na zigy de yu nu rsyaꞌ lom, ornu güeñ dey de ndeꞌ, orzeꞌ na dey rab yu losaꞌy: ―De riidz nu mniim ii, dzi ga biigy. ¿Cyu gagye nu gyeñ de nu nde? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na ornu gud lagy Jesuuz nañ lardoom nu rnii deet dey nu nac ndeꞌ, orzeꞌ nam rab mi dey: ―¿A nu nac de riidz nu mne̱e̱ ii, ndeꞌ nu wangyuꞌ lagy der? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Zeꞌ la gyicyaꞌ der benu gzac ru nu ya̱, biñ nu byac mbecy, nu chupa̱ gyibaa, zeꞌ nu pcyiiña̱ nu loga? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiriit Yon ni Ñgyoozh, mi zeꞌ gyicy mi nu cui mbañ de mbecy gun de mbecy gyishlombecy se la la cyiiñ dey par nu gyicy dey nu cui mbañ yu. Tees de riidz nu mne̱e̱ lo der ii, nii coz nu bruu lo Espiriit Yon ni Ñgyoozh. Nunu mi zeꞌ gyicy mi nu cui mbañ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tees gabee yuꞌ la be mbecy lat der nu wagyicy cup consuel lo̱ ―nam. Gun Jesuuz nil bi gud lagy mi nese anzir nu cuim dey nu ca na de yu nu wayicy cup consuel lom, nunu bi gud lagyaꞌm ca na yu nu guꞌm yaa mbecy rzi lagy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Orzeꞌ na gaꞌm: ―Ndeꞌ nu ya̱ bi mne̱e̱ lo der nu ni tub la mbecy wac gyechaꞌ dey lo̱, benu walab Ñgyoozh niim nañ lardoo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Par nu nac de riidz zeꞌ, zigy de yu nu rsyaꞌ lom bya ich yu nunu wanchesa nu gaꞌ dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Orzeꞌ na Jesuuz rab mi de trocyup yu nu rsyaꞌ lom: ―Zeꞌ de ru, ¿a niꞌ rlagy der ruu chur lo̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Orzeꞌ na Simo̱o̱ Bed: ―Shuaan de̱, ¿zeꞌ cyu lo cha̱ de̱ beni? De riidz nu ru rniir, ndeꞌ riidz nu gyicy ñi nu cui mbañ de̱ tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nunu de̱ ya̱ bi ricy cup de̱ consuel lor, nunu bi rad lagy de̱ nu ru nac ru biñ yon nu bruu lo Ñgyoozh ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―¿A walab nu pcui̱ de trocyup de ru? Zeꞌ lo trocyup der, tub yu nac yu tub mbecy ni nuras ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Lat nu mniim de riidz ii, orzeꞌ bzat mi Judas, iꞌñ Simo̱o̱ Iscariote, gun mas Judas nac yu tub de trocyup yu nu rsyaꞌ lom, tees yu zeꞌ yu nu bguꞌ Jesuuz yaa mbecy nu rzi lagy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Despuees ni de nu ndeꞌ, orzeꞌ gusam de lugaar ni Galilea. Orzeꞌ wangalagy mi ñgyes sam Judea, gun lugaar zeꞌ rded de yu zub lo ni de mbecy Israeel ryub yum par nu cut dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na tiem zeꞌ bi yad shuub dzi nu chuꞌ de mbecy Israeel tub saꞌ nu la saꞌ ni ramad. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Orzeꞌ na de bicy mi rab yum: ―Cueꞌ gyiyeeñ ru ii. Gush nez yaa par lo de yu ni Judea, gun orzeꞌ de yu nu rsyaꞌ lor zac dey de coz ily nu ricy ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Gun ni tub la mbecy wayicy yu coz ngach benu rlagy yu nu nap cuꞌ lo mbecy yu. Como bi ricy ru de coz ily, orzeꞌ rlagy ñi nu lyuur de coz nu ricy ru lo dela mbecy ni gyishlombecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gun gashtal de bicy mi wangyicy cup dey consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Orzeꞌ na Jesuuz rab mi dey: ―Gaal zi nigul shuub tiem ne̱ nu chu̱ꞌ Jerusaleeng. Zeꞌ par de ru la ziꞌl tiem ndeꞌ coz nu nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","De mbecy ni gyishlombecy wac gazi lagy dey lo de ru, tees lo ya̱ rzi lagy dey, gun naal la ricya̱ nu rabee nu de coz nu ricy dey, ndeꞌ coz a̱ꞌ nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","De ru yaa der saꞌ, gun ya̱ waya̱ na, gun gaal zi nigul shuub tiem ne̱ nu gya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ornu blazh mniim de riidz zeꞌ, orzeꞌ byeeñ gam Galilea. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Na despuees ornu bi gush nez de bicy mi nu ya dey saꞌ zeꞌ, orzeꞌ gush nezaꞌ ub mi yam. Nomaas walab nu suelt la yam, sinu yam tub mod nu dze ga. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na de mbecy zub lo ni de mbecy Israeel byub dey mi lat saꞌ. Orzeꞌ na dey rab yu losaꞌy: ―¿Ca rded yu zeꞌ na? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na lat de mbecy zigy brugyiꞌ ro dey riidz dze ga nu rzat dey mi. Yuꞌ dey nay: “Yu zeꞌ nac yu tub mbecy nap.” Tees yuꞌ gaꞌ dey rniiy: “Yu zeꞌ walab mbecy nap nac yu, sinu ricy yu nu radza mbecy”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nunu ni tub la mbecy wansat dey mi ye ga la nu nac nu rdzib dey lo de yu zub lo ni de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na ornu bi guzeel saꞌ, orzeꞌ guꞌ Jesuuz loliꞌ ni yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. Orzeꞌ brugyiꞌ rlyuum ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Orzeꞌ tonaꞌ la za nu ic de yu zub lo ni de mbecy Israeel: ―¿Lac bicy yu ii nu gud lagy yu ni de coz nu rniiy, gun wanchay scuel? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Orzeꞌ na Jesuuz rab mi dey: ―Riidz nu rlyu̱u̱, ndeꞌ walab riidz nu bruu nañ shcab ni uba̱, sinu ndeꞌ riidz nu bruu lo Ñgyoozh, biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cyu ziꞌl mbecy benu shet ic yu nu gyicy yu coz nu rlagy Ñgyoozh, orzeꞌ gad lagy yu benu riidz nu rlyu̱u̱, ndeꞌ bruuñ lo Ñgyoozh, o nu rlyu̱u̱ riidz nu rlagy ub ziꞌl la̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gun benu mbecy nu rnii nu shcab ni ub ziꞌl, yu zeꞌ ni rniiy gun rlagy yu nu gyabic mbecy gyel mbecy niy. Zeꞌ yu nu ryub gyel mbecy par yu nu bzuu nez yu, yu zeꞌ coz nu rniiy, ndeꞌ coz nu rishli, nunu sac la gyel rguu nañ lardooy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿A walab nu rishli nu Moisees bzeeñ yu leey yaa der? Tees ni tub la der wagyicy yac der niñ. Orzeꞌ ¿zeꞌ lagu ryub der mod nu cut ru ya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Orzeꞌ na la be de mbecy zigy zeꞌ rab yum: ―¡Ru bicy ni nuras ru! ¿Zeꞌ cyu nu rlagy cut ru zeꞌ beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Dela de ru za nu ic der nu nac tub zi coz nu bicya̱ sab, dzi nu rzu lagy mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tees Moisees pcaay der nu caar beey sircunsision cuerp ni de yu nguzh ni der. Mas sab, dzi nu rzu lagy mbecy Israeel, rcaa der beey ni sircunsision cuerp ni yu nguzh ni der, como ndeꞌ coz nu pcaa Moisees der nu gyicy ru. Tees ndeꞌ walab coz nu bzuub Moisees gyiꞌñ, sinu ndeꞌ coz nu nil ricy de gyitoo bel ni den. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Benu de ru rcaar beey sircunsision cuerp ni yu nguzh ni der mas sab, dzi nu rzu lagy mbecy, par nu cueꞌ chuꞌ falt ni der nu leey ni sircunsision nu bzeeñ Moisees, orzeꞌ ¿lagu rzi lagy der lo̱ gyiꞌ nu bicy yaca̱ dutuub la cuerp ni tub mbecy rat, sab, dzi nu rzu lagy mbecy Israeel? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Cueꞌ nii too der la na tub coz tub nu rgüii ziꞌl der looñ. Ornu nii too der la na tub coz, orzeꞌ bicy der mod nu seꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na la be de mbecy nu yuꞌ Jerusaleeng, orzeꞌ brugyiꞌ rgugyiꞌ dey lo losaꞌy: ―¿Zeꞌ a walab yu ii yu nu ryub dey mod nu cut yu zeꞌ? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Güii ñuu! Lo rgüii la mbecy rniiy. Nunu ni tub la mbecy wagnii dey nu yuꞌ falt niy. ¿Posib a walab nu rad lagy de fushtiz nu rishli gaal nu yu re nac yu Mesías? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tees ornu cyid Mesías, orzeꞌ ni tub la mbecy wad lagy dey ca gruum. Zeꞌ yu ii rad lagy den ca ledz yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na tiem zeꞌ zu Jesuuz loliꞌ ni yuꞌ nu driib zily de mbecy Ñgyoozh, nunu rlyuum ni dey. Orzeꞌ brugyiꞌ ye ga la rniim: ―¡Laab ni yuꞌ lo der ya̱, nunu rad lagy der ca bru̱u̱! Tees walab nu yapa̱ nu nac nu rlagy ub ziꞌl la̱, tees biñ nu bzuu nez ya̱, mi zeꞌ nac mi biñ nu ricy paa, nunu mi zeꞌ a̱ꞌ yuꞌ lo der mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tees ya̱ yuꞌ lo̱m, gun ya̱ bru̱u̱ lom, nunu mi zeꞌ bzuu nez mi ya̱ yapa̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yuꞌ mbecy ngulagy dey ñgya nu dey mi pres, tees ni tub la dey wanshet yaay mi gun nigul shuub tiem nu ni gyicy nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tees zigy mbecy bicy cup dey consuel lom. Orzeꞌ na dey: ―Ornu cyid Mesías, ¿walab gaal gyicy zir mi nusuriidz, gazeꞌ gal nu ricy yu ii? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na ornu güeñ de mbecy fariseo de riidz nu bee de mbecy dze ga nu nac Jesuuz, de yu zeꞌ gal nu de yu zub lo ni de uz bzuu nez dey la be de yu nu rña nañ yuꞌ ni Ñgyoozh nu cha nu dey mi pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Orzeꞌ nam rab mi dey: ―Gabee chesa du̱ de ru se la be dzi. Orzeꞌ gru̱u̱ lat der nu gya̱ lo biñ nu bzuu nez ya̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","De ru yub der ya̱, tees wayada̱ꞌ ni der, gun wac cha der lugaar zeꞌ nu ya̱ gya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na de yu zub lo ni de mbecy Israeel brugyiꞌ ro dey riidz nu losaꞌy. Orzeꞌ na dey: ―¿Zeꞌ ca cha gaꞌ yu ii nu wayadaꞌy ni den? ¿Walab gaal chay lat de mbecy Israeel nu rcyiiñ reñaꞌ nasyoong nu cha lyuuy ni de mbecy nu walab mbecy Israeel? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Lac yaruu de riidz nu rniiy: “Yub der ya̱, tees wayada̱ ni der, gun wac cha der lugaar zeꞌ nu ya̱ gya̱”, nay? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Laab ndeꞌ la dzi nu bded ni saꞌ zeꞌ; ndeꞌ dzi nu ricy zir ñi presis. Orzeꞌ dzi zeꞌ wes su Jesuuz. Orzeꞌ ye la mniim: ―Benu ca na der rbigy ru nis nañ lardoor, orzeꞌ da der lo̱. Ya̱ grica̱ nis goꞌ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ndeꞌ gal nu rniiñ lat de riidz ni Ñgyoozh. Rniiñ nu de yu nu gyicy cup consuel lo̱, grib nis nu cuic gyel mbañ nañ lardoo dey, rniiñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na nis nu bzat Jesuuz zeꞌ, ndeꞌ Espiriit Yon ni Ñgyoozh, biñ nu cuic Ñgyoozh ni de yu nu gyicy cup consuel lom, gun tiem zeꞌ Ñgyoozh nigul cuic mi Espiriit Yon nim ni mbecy, gun Jesuuz nigul cush cyam nu gyam lo gyel lily nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na lat zeꞌ yuꞌ la be mbecy. Ornu güeñ dey de riidz zeꞌ, orzeꞌ na dey: ―Segur la yu ii nac yu yu nu mnii por cuen ni Ñgyoozh, yu nu ca lo cuen nu cyid ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Zeꞌ yuꞌ gaꞌ dey nay: ―Laab mi ii nac mi Mesías, biñ nu ca lo cuen nu co mbañ de ub na ―na dey. Tees yuꞌ gaꞌ dey nay: ―Walab, gun Mesías walab Galilea ca lo cuen nu gruum ―na dey―. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿A walab nu rniiñ lat de riidz ni Ñgyoozh nu Mesías gruum lat de nez rey Dabi, nunu gal mi Beleeng, laab lugaar zeꞌ nu gul rey Dabi? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Orzeꞌ de mbecy byacyup nac dey nu nac Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yuꞌ dey ngulagy yu ñgya nuy mi pres, tees ni tub lay wancuꞌ yaay mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Orzeꞌ bish cya de yu nu rña nañ yuꞌ ni Ñgyoozh nu yay lo de mbecy fariseo, gal nu lo de uz zub lo. Orzeꞌ na de yu zeꞌ rab yu de yu nu rña zeꞌ: ―¿Lagu wancyiid nu der Jesuuz? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Orzeꞌ na gaꞌ de yu nu rña zeꞌ: ―¡Rila wagrusu ni tub la mbecy nu gniiy gal nu rnii yu zeꞌ! ―na de yu nu rña zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Orzeꞌ na gaꞌ de mbecy fariseo rab yu dey: ―¿A niꞌ ziꞌl de ru bi bguu gaꞌy der? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Guncar ni tub la de fushtiz ni den, ni de mbecy fariseo wacheña lagy dey nu nac yu Mesías. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tees de mbecy nu a̱ꞌ yuꞌ lo leey nu bzeeñ Moisees, de yu zeꞌ cuic Ñgyoozh cashtig ni dey ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Zeꞌ ri tub mbecy fariseo nu la Nicodemo lat dey. Yu zeꞌ yu nu gua güii Jesuuz anzir. Orzeꞌ nay rab yu dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Gun lo leey nu bzeeñ Moisees ni den rniiñ nu wac niin nu yuꞌ falt ni tub mbecy anzir nu gyeñ na de coz nu rniiy, nunu anzir nu gad lagy na de coz nu bicy yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Orzeꞌ na gaꞌ dey rab yu Nicodemo: ―¿Walab gaal gazaꞌr nac ru mbecy Galilea? Nap psyaꞌ lat de riidz ni Ñgyoozh, gun orzeꞌ gad lagy ru nu rila waruu ni tub yu nu rnii por cuen ni Ñgyoozh Galilea ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Orzeꞌ tub ga la mbecy ya dey yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tees Jesuuz pcam zam par too bicy ni ya Oliva. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na or nu bzaꞌ yu tuubaꞌ dzi, orzeꞌ bish cyam yam loliꞌ ni yuꞌ nu driib zily de mbecy Ñgyoozh. Orzeꞌ brugyiꞌ rdeꞌ mbecy lom. Orzeꞌ gusub mi nunu brugyiꞌ nu rlyuum ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Orzeꞌ de yu nu rlyuu leey nu bzeeñ Moisees, gal nu deꞌ zir mbecy fariseo, gua nu dey tub biñ mñaa lo Jesuuz par nu byuꞌ beem nu yu gyeey nu walab ñgyeem. Orzeꞌ bzu dey mi gazel de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Orzeꞌ na dey rab yu Jesuuz: ―Masht, biñ mñaa ii bdub dey mi lat nu gucyaal la yuꞌ num yu gyeey, yu nu walab ñgyeem. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ornu Moisees bzeeñ yu leey ni den, orzeꞌ nay nu rlagy ñi nu gow gyitaꞌ den biñ mñaa nu na gal nu na mi ii gal gat lam. Zeꞌ ru, ¿la ñuu niir? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ni bicy dey par nu bzu dey tub caa ni Jesuuz, gun orzeꞌ gad mod nu griib dey cyi ic mi. Orzeꞌ Jesuuz gusab tiily mi. Orzeꞌ brugyiꞌ rcaam lo yu nu mbiz mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Lat nu zu dey rgugyiꞌy lom, orzeꞌ wes sum. Orzeꞌ nam rab mi dey: ―Ca na de ru, mbecy nu wangyicy coz cyi, orzeꞌ pshet der gyitaꞌ biñ mñaa ii loga la ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Orzeꞌ gusab tiilyaꞌm tuubaꞌ tir. Orzeꞌ brugyiꞌ rcaa gaꞌm letr lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na ornu güeñ dey riidz zeꞌ, orzeꞌ brugyiꞌ tub ga, tub ga dey druu chuy. Brugyiꞌ druu chu de yu gush loga la. Gazeꞌ nu brugyiꞌ druu chu de yu feñ. Orzeꞌ se Jesuuz ziꞌl byeeñ mi nu biñ mñaa nu gabee zum lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Orzeꞌ wes su Jesuuz. Orzeꞌ nam rab mi biñ mñaa zeꞌ: ―Biñ mñaa, ¿ca za de yu zeꞌ na? ¿A sac ni tubaꞌ la mbecy nu niiy nu yuꞌ falt nir? ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Orzeꞌ na biñ mñaa zeꞌ rab mi Jesuuz: ―Sac ni se tubaꞌ la dem ―na biñ mñaa zeꞌ. Orzeꞌ na gaꞌ Jesuuz: ―Niꞌ ya̱ wane̱e̱ nu yuꞌ falt nir. Na yaa yuꞌr, nunu cueꞌ gaꞌ gyicy ru cyi ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Orzeꞌ na Jesuuz rab mi de mbecy zeꞌ: ―Ya̱ naca̱ yaa nu rbic nu gyal shcab ni de mbecy gyishlombecy. Yu nu cyid ca ich ya̱, yu zeꞌ gad yaa zeꞌ niy nu gyicy ñi nu cui mbañ yu. Nunu rila a̱ꞌ nac yu mbecy nu wagad lagy de coz nu rlagy Ñgyoozh ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Orzeꞌ na de mbecy fariseo rab yum: ―Ru laab ub ziꞌl ru rzat ru ub ru, ndeꞌ nu se la la cyiiñ de riidz nu rniir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Mas laab uba̱ rzata̱ uba̱, tees riidz nu rne̱e̱ ndeꞌ riidz nu rishli. Gun rad lagya̱ ca bru̱u̱, nunu rad lagya̱ ca gya̱. Zeꞌ de ru wagad lagy der ca bru̱u̱, nunu ni wagad lagy der ca gya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","De ru rnii too der ben lac na tub mbecy mod nu ricy mbecy gyishlombecy. Zeꞌ ya̱, a̱ꞌ nii to̱o̱ ti yuꞌ falt ni ni tub la mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tees benu ya̱ nii to̱o̱ nu yuꞌ falt ni tub mbecy, orzeꞌ ndeꞌ coz rishli, gun walab ub zi̱ gyicya̱ ñii, sinu nu Ñgyoozh uza̱, biñ nu bzuu nez ya̱, mi zeꞌ nac num ya̱ ornu gyicya̱ de ndeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Gun bi cañ lat leey nu bzeeñ Moisees ni der nu rniiñ: “Benu cyup mbecy tub ziꞌl riidz rnii dey, orzeꞌ ndeꞌ riidz nu cyiiñ”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Zeꞌ na, ya̱ rne̱e̱ por cuen ne̱. Nunu uza̱, biñ nu bzuu nez ya̱, mi zeꞌ biñ cyup nu rnii por cuen ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Orzeꞌ na gaꞌ dey rab yu Jesuuz: ―¿Zeꞌ ca zu uz ru beni? ―na dey. Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―De ru a̱ꞌ yuꞌ lo der ya̱. Yegar uza̱ chuꞌ lo gaꞌ der mi. Gun zeꞌ benu gyuꞌ lo der ya̱, orzeꞌ niꞌ ziꞌl gyuꞌ lo der uza̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","De nii riidz nu mnii Jesuuz lat nu rlyuum ni de mbecy zeꞌ nu zub yuꞌ nu driib zily de mbecy Ñgyoozh. Laab lugaar zeꞌ nu ca alcansi ni tiñ gun zeꞌ zum. Tees ni tub la mbecy wancuꞌ yaa dey mi ñgya nuy mi pres, gun nigul shuub dzi nu ni gyicy nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Orzeꞌ Jesuuz na gaꞌm rab mi dey: ―Ya̱ gru̱u̱ lat der nu gya̱. Orzeꞌ de ru yub der ya̱, tees de ru gat der lat nu gabee nac der mbecy cyi. Nunu wac gya der zeꞌ nu ya̱ gya̱ ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Orzeꞌ na gaꞌ de yu zub lo ni de mbecy Israeel: ―¿Lac yaruu de riidz ii niy nu wac gyan zeꞌ nu gyay? ¿Walab gaal nu cut yu ub yu? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―De ru nac ru ni gyishlombecy ii. Zeꞌ ya̱ naca̱ ni gyibaa, gun de ru ledz ru gyishlombecy ii. Zeꞌ ya̱ walab ii ledza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndeꞌ nu ya̱ mne̱e̱ lo der nu gat der lat nu gabee nac der mbecy cyi. Gun gat der lat nu gabee nac der mbecy cyi benu wacheña lagy der nu ya̱ naca̱ biñ nu mne̱e̱ nu naca̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Orzeꞌ na dey rab yu Jesuuz: ―¿Zeꞌ ru, cyu nac ru beni? ―na dey. Orzeꞌ na gaꞌm rab mi dey: ―Ya̱ bi mne̱e̱ lo der nese nu loga la cyu naca̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yuꞌ tonaꞌ la coz nu gac ne̱e̱ nu nac de ru, nunu yuꞌ tonaꞌ la cyi nu gac griiba̱ ic der, tees tub lo ziꞌl riidz nu mnii biñ nu bzuu nez ya̱, ndeꞌ gne̱e̱ lo de ru, mbecy nu yuꞌ gyishlombecy ii. Nunu mi zeꞌ rniim riidz nu rishli ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Lat de riidz nu mnii Jesuuz, bzat mi Ñgyoozh uz mi, tees wangyet lag dey cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Orzeꞌ nam rab mi dey: ―Ornu caa der ya̱, biñ nu byac mbecy, lo tub ya cruuz, orzeꞌ gad lagy der nu ya̱ naca̱ biñ nu mne̱e̱ nu naca̱. Nunu niꞌ ziꞌl gad lagy der nu walab nu rne̱e̱ nu nac ub ziꞌl la̱, sinu rne̱e̱ tub lo ziꞌl coz nu blyuu Ñgyoozh uza̱ ne̱ nu gne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Gun Ñgyoozh, biñ nu bzuu nez ya̱, nac num ya̱. Mi zeꞌ wansaan mi ya̱ nu chesa̱ ub zi̱ gun dub laa tiem ricya̱ coz nu mi zeꞌ yet lagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ornu mnii Jesuuz de riidz zeꞌ, orzeꞌ zigy mbecy bicy cup dey consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Orzeꞌ na Jesuuz rab mi de yu zub lo ni de mbecy Israeel, de yu nu bicy cup consuel lom: ―Benu de ru zaab gyicy paa la der nu de riidz nu rne̱e̱, orzeꞌ rishli gaal nac der yu nu rsyaꞌ lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Orzeꞌ gad lagy der ca na nu coz rishli. Orzeꞌ nu nac coz rishli zeꞌ gla der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Orzeꞌ na dey rab yu Jesuuz: ―De̱ ya̱ nac de̱ nez Abraham, nunu rila nigul gac de̱ moz ni ni tub la mbecy. ¿Lac yaruu gaꞌ ndeꞌ nu rniir nu gla̱ de̱? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu de mbecy nu ricy coz cyi, yu zeꞌ nac yu moz ni de cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tub moz ni mbecy, a̱ꞌ nac yu famil ni mbecy tees yu nu nac iꞌñ mbecy nac yu famil niy par tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Benu ya̱ iꞌñ Ñgyoozh gyicya̱ nu gla der ni de cyi, orzeꞌ rishli gaal dulaa der lo cyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Rad lagya̱ nu de ru nac ru nez Abraham, tees rlagy der cut ru ya̱, gun wayicy cuen der de riidz nu rne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ya̱ rne̱e̱ de coz nu rad lagya̱ lat nu gusa du̱ Ñgyoozh uza̱. Zeꞌ de ru ricy der de coz nu blyuu uz der nir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Orzeꞌ na dey rab yum: ―¡Abraham, yu zeꞌ nac yu uz de̱! ―na dey. Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Bi bicy na nu rishli gaal nu nac der iꞌñ Abraham, orzeꞌ ñgyicy der gal nu bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tees ya̱ rne̱e̱ de coz rishli lo der, de riidz nu güeña̱ ni Ñgyoozh, tees rlagy der cut ru ya̱. ¡Abraham rila wangyicy yu ni tub la coz gal nu rlagy de ru gyicy ru nur ya̱! ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","De ru gal gaa la ricy der nu uz ru ―nam. Orzeꞌ na dey rab yum: ―De̱ ya̱ a̱ꞌ nac de̱ gyid lab. De̱ ya̱ ricy cup de̱ tub zi uz de̱. Mi zeꞌ Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Gazeꞌ nu na Jesuuz rab mi dey: ―Benu rishli gaal ñgyac der iꞌñ Ñgyoozh, orzeꞌ nca der ya̱, gun ya̱ lo Ñgyoozh bru̱u̱ yapa̱. Nunu walab nu yapa̱ nu nac coz nu rlagy ub ziꞌl la̱, sinu Ñgyoozh bzuu nez mi ya̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Lagu wagac gyet lag der cuen de riidz nu rne̱e̱? Ndeꞌ gun walagy der nu zuub gyidag der de riidz nu rne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gun uz der, ndeꞌ ub la nuras. Nunu de ru na der gal nu na yu zeꞌ. Orzeꞌ rlagy der gyicy ru coz nu gyicy ñi nu gyet lagy yu. Gun nuras bicy yu nu gut mbecy nese nu loga la. Nunu rila wagchay faboor ni coz rishli, gun rila wagniiy nu rishli. Ornu rguuy, ni ricy yu gun ni nay, gun nac yu mbecy rguu. Nunu nac yu cyoong de mbecy rguu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tees como ya̱ rne̱e̱ de coz rishli lo der, ndeꞌ nu wacheña lagy der de riidz nu rne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ca na de ru gac gyicy ru nu gabe ca na cyi nu bicya̱? Zeꞌ benu ya̱ rne̱e̱ coz rishli, orzeꞌ ¿lagu wacheña lagy der de coz nu rne̱e̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yu nu bi nac mbecy ni Ñgyoozh, yu zeꞌ rzuub gyidag yu riidz nim. Zeꞌ de ru par nu a̱ꞌ nac der mbecy nim, ndeꞌ nu wacsuub gyidag der nim ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Orzeꞌ na gaꞌ de mbecy Israeel rab yum: ―¿A walab nu ricy cup de̱ raso̱o̱ ornu rne̱e̱ de̱ nu nac ru mbecy Samaria, nunu bicy ni nuras ru? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Walab nu bicy ni nuras ya̱. Tees driib zilya̱ Ñgyoozh uza̱. Zeꞌ de ru rgüii naañ der lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Walab nu rlagya̱ nu gyabic mbecy gyel mbecy ne̱, tees zu tub biñ nu rlagy nu gyabic mbecy gyel mbecy ne̱ ya̱, nunu mi zeꞌ zam faboor ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ya̱ rishli rne̱e̱ lo der nu cyu ziꞌl mbecy nu zuub gyidag riidz nu rne̱e̱, yu zeꞌ rila wat yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Orzeꞌ na gaꞌ de mbecy Israeel: ―Na gaal rishli rad lagy de̱ nu bicy ni nuras ru. Abraham gut yu, nunu de yu nu mnii por cuen ni Ñgyoozh gutaꞌ dey. Zeꞌ ru naꞌr nu cyu ziꞌl mbecy nu gzuub gyidag de riidz nu rniir, de yu zeꞌ mniir nu wat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A rsaꞌ lagy ru nu zily zir nac ru gazeꞌ gyitoo bel ni den Abraham? Yu zeꞌ gut yu. Nunu gutaꞌ de yu nu mnii por cuen ni Ñgyoozh. ¿Orzeꞌ cyu rsaꞌ lagy ru nac ru beni? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Benu griib zilya̱ uba̱, orzeꞌ se la la sac ndeꞌ. Tees biñ nu driib zilya̱, mi zeꞌ uza̱, biñ nu de ru rniir nu nac Ñgyoozh nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","De ru rila wancuꞌ lo der mi, tees ya̱ bi bduꞌ lo̱m. Bi bicy na nu ne̱e̱ nu wantuꞌ lo̱m, orzeꞌ naca̱ tub mbecy rguu gal nu na de ru. Tees ya̱ rishli gaal bduꞌ lo̱m, nunu rzuub gyidaga̱ de riidz nu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gyitoo bel ni der Abraham tonaꞌ la bet lagy yu, gun briish loy nu zac yu dzi nu gruu zaca̱ gyishlombecy ii, nunu ornu bzaac yu dzi zeꞌ, orzeꞌ bet lagy yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Orzeꞌ na gaꞌ de mbecy Israeel rab yum: ―Ru, gaal zi nigul shuub ru cyaal gaynal ñaꞌn, zeꞌ naꞌr nu bi bzaac ru gyitoo Abraham ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ya̱ rishli rne̱e̱ lo der nu ya̱ nil bi zu̱ nese anzir nu gal Abraham gyishlombecy ii ―nam rab mi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Orzeꞌ brugyiꞌ rteꞌ dey gyitaꞌ nu gow gyitaꞌ dey mi gal gat lam. Tees wansac dey ca gush mi. Orzeꞌ bruum loliꞌ ni yuꞌ nu driib zily mbecy Ñgyoozh zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lat nu za Jesuuz tub nez, orzeꞌ bzaac mi tub mbecy lo caꞌ nu nil nay nese nu gul yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Orzeꞌ na de yu nu rsyaꞌ lom: ―Masht, ¿ca na dey yuꞌ cyiy nu bicy ñi nu byacaꞌ lo yu re nese ornu gul yu? ¿A nu nac cyi ub yu uti nu nac cyi de mbel niy? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ni walab nu nac cyi ub yu byacaꞌ loy, nunu ni walab nu nac cyi de mbel niy, sinu byacaꞌ loy par nu gabe nu la na riiñ nu ricy Ñgyoozh nu nac yu re. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lat nu gabee cuic ñi tiem, rlagy ñi nu gyicy den de coz nu rlagy Ñgyoozh, biñ nu bzuu nez ya̱, gun shuub tiem nu wacaꞌ gyicy den coz nu rlagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lat nu gabee rcyiiña̱ gyishlombecy ii, ya̱ na gal nu na tub yaa nu rbic nu gad lagy de mbecy ni de coz rishli ni Ñgyoozh ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Na ornu blazh mniim de riidz zeꞌ, orzeꞌ pshu nis ruꞌm lo yu. Orzeꞌ bicy biñ mi ñuu miꞌ yu. Orzeꞌ bdaab mi biñ zeꞌ ruꞌ iz lo caꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Orzeꞌ nam rab mi yu: ―Gua cyib ru ruꞌ iz ru ruꞌ zo ni Siloé ―nam rab mi yu. (Benu shaal na riidz ni Siloé zeꞌ, orzeꞌ yaruuñ: Bzuu nez.) Orzeꞌ lo caꞌ zeꞌ gua tiib yu ruꞌ iz yu. Orzeꞌ gush nez yu yay, nunu bi rzac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Orzeꞌ na de mbecy nu yuꞌ nuy gaab ga gal nu de yu nu rzac nu rgyiiñ yu gun, orzeꞌ na dey rab yu losaꞌy: ―¿A walab yu ii yu nu rzub nu rgyiiñ gun? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yuꞌ gaꞌ dey rniiy: ―Laab yu re ndeꞌ ―na dey. Zeꞌ yuꞌ gaꞌ dey nay: ―Walab yu nde; nomaas nu rlyu nu niꞌ ziꞌl nay gal nu na yu nu rgyiiñ gun zeꞌ ―na dey. Tees, orzeꞌ na yu nu guc lo caꞌ zeꞌ: ―Laab ya̱ ndeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Orzeꞌ na gaꞌ de mbecy zeꞌ: ―¿Zeꞌ lac guc nu rac rzac ru na? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Orzeꞌ na gaꞌ yu nu guc lo caꞌ zeꞌ rab yu dey: ―Tub mbecy nu la Jesuuz bzaay biñ. Orzeꞌ bdaab yuñ ruꞌ iza̱. Orzeꞌ nay rab yu ya̱: “Gua cyib ru ruꞌ iz ru ruꞌ zo ni Siloé”, nay rab yu ya̱. Orzeꞌ gua̱ ruꞌ zo zeꞌ. Na cuanzir nu blazh bdiba̱ ruꞌ iza̱, orzeꞌ brugyiꞌ rzaca̱ ―na yu nu guc lo caꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Orzeꞌ na gaꞌ dey rab yuy: ―¿Zeꞌ ca zu mbecy zeꞌ na? ―na dey. Orzeꞌ na gaꞌ yu nu guc lo caꞌ zeꞌ: ―Wagad lagya̱ ca zay ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Orzeꞌ gua nu dey yu nu guc lo caꞌ zeꞌ lo de mbecy fariseo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Zeꞌ dzi nu bzaa Jesuuz biñ nu bicy yac mi mbecy lo caꞌ zeꞌ, ndeꞌ sab, dzi nu rzu lagy mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Orzeꞌ de mbecy fariseo bdugyiꞌ dey loy, ben lac mod byanap ur loy. Orzeꞌ nay rab yu dey: ―Yu zeꞌ bdaab yu biñ ruꞌ iza̱. Orzeꞌ gua tiba̱ ñii. Orzeꞌ na rzaca̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Orzeꞌ la be de mbecy fariseo na dey: ―Yu nu bicy coz ii, yu zeꞌ walab mbecy ni Ñgyoozh, gun wagyicy yac yu nu leey ni sab, dzi nu rzu lagy mbecy Israeel ―nay. Zeꞌ yuꞌ gaꞌ dey nay: ―Zeꞌ benu nac yu mbecy cyi, orzeꞌ ¿lac mod gac gyicy yu de nusuriidz gal nu na nu ndeꞌ? ―na dey. Orzeꞌ byac cyup nac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Orzeꞌ na gaꞌ dey rab yu yu nu guc lo caꞌ zeꞌ: ―¿La ñuu niir par nu nac yu zeꞌ, como bicy nap yu urlor? ―na dey. Orzeꞌ na gaꞌ yu nu guc lo caꞌ zeꞌ: ―Yu zeꞌ nac yu tub yu nu rnii por cuen ni Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tees de yu zub lo ni de mbecy Israeel wancheña lagy dey nu guc yu mbecy lo caꞌ, zeꞌ na rzac yu, gashtal bredz la dey de mbel niy. Orzeꞌ guña lagy dey nu yu zeꞌ guc yu lo caꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na ornu bruꞌña de mbel ni lo caꞌ zeꞌ, orzeꞌ bdugyiꞌ de mbecy zeꞌ lo dey. Orzeꞌ nay: ―¿A laab yu ii nac yu iꞌñ der? De ru rnii der nu caꞌ loy ornu gul yu. Zeꞌ benu ni, ¿lac guc? ¿Lagu nu rzac yu na? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Orzeꞌ na de mbel ni lo caꞌ zeꞌ: ―Rad lagy de̱ nu yu ii nac yu iꞌñ de̱, nunu nese nu gul laay caꞌ loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tees wagad lagy de̱ lac guc nu rzac yu. Ni wagad lagy de̱ cyu bicy nap urloy. Bdugyiꞌ der loy ben. Bi nu ñaꞌn yu ii. Gac niiy por cuen ni ub yu ―na de mbel ni yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ni mnii de mbel niy par nu gudzib dey lo de yu zub lo ni de mbecy Israeel, gun de yu zeꞌ bi psaap dey riidz nu cyu ziꞌl mbecy nu gniiy nu Jesuuz nac mi Mesías, orzeꞌ wazaanaꞌ dey nu chuꞌy lat de mbecy ornu rsyaꞌ dey riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndeꞌ nu ni mnii de mbel niy, ornu na dey: “Bdugyiꞌ der loy. Bi nu ñaꞌn yu ii”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Orzeꞌ de yu zub lo ni de mbecy Israeel bredza̱ꞌ dey yu nu guc lo caꞌ zeꞌ. Orzeꞌ na dey rab yuy: ―Mnii lo̱ de̱ rishli gaal ni Ñgyoozh. De̱ ya̱ rad lagy de̱ nu yu zeꞌ nac yu tub mbecy cyi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Orzeꞌ na yu nu guc lo caꞌ zeꞌ rab yu dey: ―Wagad lagya̱ ti nac yu mbecy cyi o ti a̱ꞌ nac yu. Tees tub coz nu rad lagya̱, ndeꞌ nu guca̱ lo caꞌ, tees na rzaca̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Orzeꞌ na gaꞌ dey rab yu yu nu guc lo caꞌ zeꞌ: ―¿Lac mod bicy nuy ru? ¿Lac bicy yu ornu bicy yac yu urlor? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Orzeꞌ na gaꞌ yu nu guc lo caꞌ zeꞌ: ―Ya̱ bi mne̱e̱ lo der, tees wangyicy cuen der de riidz nu mne̱e̱. ¿Lagu rlagy der nu ne̱e̱ lor tuubaꞌ tir? ¿Walab gaal niꞌ de ru rlagy der syaꞌr loy? ―na yu nu guc lo caꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Orzeꞌ brugyiꞌ rsuriidz dey yu. Orzeꞌ na dey: ―Ru nac ru tub yu nu rsyaꞌ lo mbecy zeꞌ. Zeꞌ de̱ ya̱ naca̱ yu nu rsyaꞌ lo gyitoo Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","De̱ ya̱ rad lagy de̱ nu Ñgyoozh mnii num Moisees, tees mbecy zeꞌ, ni wagad lagy de̱ ca ledz yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Orzeꞌ na gaꞌ yu nu guc lo caꞌ zeꞌ: ―¡Cha du ic na de coz nu rnii der! De ru wagad lagy der ca bruuy, tees bicy yac yu urlo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","De ub na nap rad lagy den nu Ñgyoozh wayicy cuen mi de coz nu rnii de mbecy cyi; tees ricy cuen mi de mbecy nu rca lagy lom gal nu de yu nu ricy coz nu rlagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gaal zi nu bzub gyiꞌ gyishlombecy nigul gyeñ den nu gruu su tub mbecy nu gyicy yac yu urlo tub mbecy lo caꞌ nu nil nay nese ornu gul laay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Zeꞌ benu walab lo Ñgyoozh bruuy, orzeꞌ wac ñgyicy yu ni tub la coz ―na yu nu guc lo caꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Orzeꞌ na gaꞌ dey rab yuy: ―Ru nese nu gul laar nil nac ru mbecy cyi. Zeꞌ na, ¿a rlagy ru rlyuur ne̱ de̱ ya̱? ―na dey. Orzeꞌ pcyuu nu dey yu lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na ornu Jesuuz güeñ mi nu pcyuu nu dey yu nu guc lo caꞌ zeꞌ, orzeꞌ byub mi yu. Na ornu byad yu nim, orzeꞌ nam rab mi yu: ―¿A ricy cup ru consuel lo biñ nu byac mbecy? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Orzeꞌ na yu nu guc lo caꞌ zeꞌ: ―Jesuuz, mnii lo̱ cyu ndeꞌ, gun orzeꞌ gyicy cupa̱ consuel loy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Orzeꞌ na gaꞌ Jesuuz rab mi yu: ―Bi bzaac ru cyu ndeꞌ. Ndeꞌ ya̱, biñ nu rnii nur na ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Orzeꞌ nay rab yu Jesuuz: ―Shuaana̱, ya̱ gyicy cupa̱ consuel lor ―nay. Orzeꞌ guzu tib yu lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Orzeꞌ na Jesuuz rab mi yu: ―Ya̱ yapa̱ gyishlombecy ii par nu cui̱ de mbecy, gun orzeꞌ de lo caꞌ gad lagy dey. Zeꞌ de mbecy nu rzac gyacaꞌ lo dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Orzeꞌ la be de mbecy fariseo nu yuꞌ garee ga güeñ dey de riidz nu mniim. Orzeꞌ na dey rab yum: ―¿Walab gaal gazaꞌ de ub na nac na lo caꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Orzeꞌ na Jesuuz rab mi dey: ―Benu de ru nac der mbecy lo caꞌ, orzeꞌ sac falt ni der, tees gun rnii der nu rzac ru, ndeꞌ nu gabee yuꞌ falt ni der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Orzeꞌ na Jesuuz: ―Tees ya̱ rishli rne̱e̱ nu de yu nu wayuꞌ par gyeroꞌ ni chicyer ni shily, zeꞌ chuꞌy par reñaꞌ lugaar ni chicyer, yu zeꞌ nac yu tub gubaan, nunu nac yu mbecy a̱ꞌ nap. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tees yu nu rzuꞌ par gyeroꞌ ni chicyer ni shily, yu zeꞌ nac yu yu nu rña ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Gun yu nu ca gyeroꞌ ni chicyer zeꞌ rshaal yu roꞌ zeꞌ ornu ruꞌña yu nu rña de shily zeꞌ. Orzeꞌ shily zeꞌ reñ ma nu zaab tiꞌy rniiy. Orzeꞌ rbedz yu ma tub ga la ma niy nu nu la ma. Orzeꞌ rbooy ma nañ chicyer zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na ornu bi blazh bruu dela ma, orzeꞌ yu nu rña ma rzay par lo ma. Orzeꞌ de shily zeꞌ za ca ma ich yu gun yuꞌ lo ma tiꞌy ornu rniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tees de ma zeꞌ wacha ca ma ich mbecy nu a̱ꞌ yuꞌ lo ma, sinu druu chu ma loy, gun a̱ꞌ yuꞌ lo ma tiꞌy, gun nac yu mbecy a̱ꞌ yuꞌ lo ma ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesuuz mniim de riidz tiily zeꞌ lo dey, tees wangyet lagy dey cuen lac yaruuñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Orzeꞌ ndeꞌ nu Jesuuz mnii gaꞌm tuubaꞌ tir: ―Ya̱ rishli rne̱e̱ lo der: ya̱ na gal nu na gyeroꞌ ni chicyer zeꞌ nu rzuꞌ de shily. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dela de yu nu biid lo zir gazeꞌ ya̱, mas mnii dey nu nac yu yu nu rña shily, guc dey gubaan, nunu guc dey mbecy a̱ꞌ nap. Tees de shily wangyicy cuen ma dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ya̱ na gal na gyeroꞌ ni chicyer zeꞌ. De yu nu chuꞌ gyeroꞌ zeꞌ, gruu mbañ yu. De yu zeꞌ na dey gal nu na shily: nu rzuꞌ ma nañ chicyer, nunu druu gaꞌ ma, nunu rad gyizh nu row ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’De gubaan ryiid yu par nu gyicy ziꞌl yu gubaan, nunu par nu cut yu, nunu par nu nit loy; tees ya̱ yapa̱ par nu grica̱ gyel mbañ ni der, nunu par nu gyicy cup zaꞌ la der ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Ya̱ na gal nu na tub biñ nu nap rña shily. Zeꞌ biñ nu nap rña shily zeꞌ, shet ic mi nu gat mi nu nac de shily zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Benu tub moz nu ryash ni nu rña de shily, zeꞌ ndeꞌ walab fis niy, nunu shily zeꞌ walab niy ma, zeꞌ benu zac yu nu yad tub lob, orzeꞌ zeeñ gay de shily zeꞌ. Gash yu carer gyay. Orzeꞌ lob zeꞌ shet ruꞌ ma de shily zeꞌ, nunu tush las ma de ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Orzeꞌ moz zeꞌ gruu chuy lo de shily zeꞌ, gun nu nac tiñ ziꞌl ricy yu riiñ, walab nu rcay de ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Zeꞌ ya̱ naca̱ biñ nu nap rña de shily. Gal nu ya̱ yuꞌ lo̱ de ma ne̱, nunu yuꞌ lo gaꞌ de ma ya̱, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","niꞌ ziꞌl Ñgyoozh uza̱ yuꞌ lom ya̱, nunu niꞌ ziꞌl ya̱ yuꞌ lo̱ Ñgyoozh uza̱. Nunu ya̱ shet ica̱ nu gata̱ nu nac de shily ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nunu yuꞌ gaꞌ shily ne̱: bañ nu sac lat tub nac de bañ nu yuꞌ ii. Niꞌ de ma zeꞌ rlagy ñi nu cha te̱ꞌ ma. Orzeꞌ de ma zeꞌ zuub gyidag de ma ne̱ nunu gyac se tub nac ziꞌl de ma. Orzeꞌ gyac se tub ziꞌl ya̱ biñ nu rña ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ñgyoozh uza̱ rcam ya̱ gun shet ica̱ nu gata̱, gun orzeꞌ cush cya̱ nu gyabañaꞌ tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni tub la mbecy wac cut yu ya̱, benu wazaana̱. Tees ndeꞌ coz nu bruu nañ lardo̱o̱ ub la̱ nu shet ica̱ nu cut mbecy ya̱. Ya̱ ricy cupa̱ rishbeey nu zaana̱ nu cut mbecy ya̱, nunu ricy cupa̱ꞌ rishbeey nu gyabaña̱ tuubaꞌ tir. Ndeꞌ riiñ nu bduꞌ Ñgyoozh uza̱ ya̱a̱ ―na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Orzeꞌ byac cyup nac de mbecy Israeel tuubaꞌ tir nu nac de riidz nu mniim zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yuꞌ zigy mbecy nu rnii dey: ―Cueꞌ gyicy cuen der yu, gun bicy ni nuras yu. Orzeꞌ guloc yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tees yuꞌ gaꞌ mbecy nu rnii dey: ―Benu tub mbecy gyicy ni nuras yu, rila wac niiy gal nu rnii yu ii. ¿Walab gaal gac gyicy nap tub nuras urlo tub mbecy lo caꞌ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na ornu pshuub tiem nu bri nu rag, orzeꞌ guꞌ dey tub saꞌ Jerusaleeng par nu gyicy dey nu gyezaꞌ lagy mbecy tiem nu bzu chu dey yuꞌ par nu griib zily dey Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Orzeꞌ rded Jesuuz tub lugaar ni yuꞌ zeꞌ nu la coredoor ni Salomoong. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Orzeꞌ de mbecy Israeel bri loꞌ la dey mi. Orzeꞌ na dey rab yum: ―Zeꞌ ¿la be ruꞌ tiem gyicy ru nu wad lagy de̱? Naal la mnii lo̱ de̱ tub tir ziꞌl benu ru nac ru Mesías, biñ nu ca lo cuen nu co mbañ de̱ ya̱ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Orzeꞌ na Jesuuz rab mi dey: ―Ya̱ bi mne̱e̱ lo der, tees wancheña lagy der. De coz nu mnii Ñgyoozh nu ricya̱, ndeꞌ rlyuuñ nu naca̱ Mesías. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tees de ru wacheña lagy der de coz nu rne̱e̱, gun a̱ꞌ nac der shily ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","De shily ne̱ ryuꞌ lo ma ti̱ꞌ ornu rne̱e̱. Nunu ya̱ yuꞌ lo̱ de ma ne̱. Nunu de ma zeꞌ ryiid ca ma icha̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gyicya̱ nu cui mbañ de ma tub la, nunu rila wanit lo de ma. Nunu se cyu la gac co za de ma ya̱a̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ñgyoozh uza̱, biñ nu briic de ma ne̱, mi zeꞌ zily zir nac mi par deꞌ zir mbecy. Nunu ni tub la mbecy wac co dey ma yaam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ya̱ nu Ñgyoozh uza̱ tub ziꞌl nu nac de̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Orzeꞌ de mbecy zeꞌ pteꞌ gaꞌ dey gyitaꞌ nu shet dey nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Orzeꞌ nam rab mi dey: ―Bicya̱ zañ de coz nap nu bruu lo Ñgyoozh lo rgüii la der. ¿A nu nac ca na de coz zeꞌ rgoow gyitaꞌ der ya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Orzeꞌ na gaꞌ de mbecy rab yum: ―Walab nu rgoow gyitaꞌ de̱ ru nu nac ca na tub coz nap nu ricy ru, sinu rgoow gyitaꞌ de̱ ru nu nac nu mnii zir ni Ñgyoozh, gun ru mbecy ziꞌl nac ru, tees ricy ru nu nac ru Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Orzeꞌ na Jesuuz rab mi dey: ―Lat de riidz nu bzeeñ Ñgyoozh ni der, Ñgyoozh nam rab mi de mbecy: “De ru nac der de ñgyoozh”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Rad lagy den de coz nu rnii riidz ni Ñgyoozh, nu rila wagruu fals ñi. Ñgyoozh bloo lam de mbecy “De ñgyoozh”: de yu nu bri riidz nim lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Zeꞌ Ñgyoozh bzum ya̱, nunu bzuu nez mi ya̱ yapa̱ gyishlombecy ii. Benu ni, ¿lagu rnii der nu ya̱ rne̱e̱ zi̱ ni Ñgyoozh nu nac nu mne̱e̱ nu naca̱ iꞌñ mi? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Benu wagyicya̱ de coz nu bruu lo Ñgyoozh, uza̱, orzeꞌ cueꞌ cheña lagy der de coz nu rne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tees benu ricya̱ de coz zeꞌ, mas wacheña lagy der ne̱, tees guña lagy der ni de coz nu ricya̱, gun tub tir ziꞌl gad lagy der nu ya̱ tub ziꞌl naca̱ du̱ Ñgyoozh, uza̱, nunu Ñgyoozh, uza̱, tub ziꞌl nac mi nu ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Orzeꞌ tub tiraꞌ ngulagy dey nguꞌ yaay mi nu ñgya nu dey mi pres. Tees blam yaa dey zam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Orzeꞌ Jesuuz bish cyam za gaꞌm tub laꞌ gaꞌ ruꞌ gyoow Jordaang. Orzeꞌ pcyiiñ mi zeꞌ. Zeꞌ lugaar nu gusa Waa briib nis yu mbecy anzir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Zigy mbecy bdeꞌ dey lom. Orzeꞌ na dey: ―Waa wangyicy yu ni tub la nusuriidz, tees dela coz nu mniiy nu nac mbecy ii, ndeꞌ coz rishli ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Orzeꞌ zañ mbecy bicy cup dey consuel lo Jesuuz lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bzu tub mbecy rat: yu nu la Lázaro. Yu zeꞌ tub mbecy Betania, gyedz zeꞌ nu rcyiiñ Li nu bily ñii Mart. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Laab Li zeꞌ, fiñ zeꞌ nu pcoo asecy zguul gyiꞌ Shuaan den Jesuuz. Orzeꞌ pcuiigy ñi gyiꞌm nu gyich ic ñi. Fiñ zeꞌ zan Lázaro, yu nu gurat zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Orzeꞌ rup laa deñ nu bily ñii bzeed ñi tub raso̱o̱ lo Jesuuz. Orzeꞌ na raso̱o̱ zeꞌ: ―Shuaan de̱, amig nir riib rat ñi ―na raso̱o̱ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na ornu güeñ Jesuuz raso̱o̱ zeꞌ, orzeꞌ nam: ―Tees güii zeꞌ walab nu zaꞌ loñ yu tub tir ziꞌl, sinu gush güii zeꞌ par nu gabe nu dzi lily na Ñgyoozh, nunu niꞌ ziꞌl par nu gabe gyel lily ne̱ ya̱, iꞌñ mi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na Jesuuz tonaꞌ la guzañ lagy mi Mart, gal nu bily ñii Li, gal nu Lázaro. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tees ornu bri raso̱o̱ nu riib rat Lázaro, orzeꞌ byeeñ mi se cyup dzi lugaar zeꞌ nu rcyiiñ mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na ornu bded cyup dzi zeꞌ, orzeꞌ nam rab mi de yu nu rsyaꞌ lom: ―Yaa gaꞌ der gyan Judea tuubaꞌ tir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Orzeꞌ na de yu nu rsyaꞌ lom: ―Masht, ¿a walab nu sa ñuu, de mbecy Israeel bicy pee dey ngoow gyitaꞌy ru gashtal ñgyat lar? ¿Walab gaal rlagy ru gya gaꞌr tuubaꞌ tir? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Orzeꞌ na Jesuuz: ―¿A walab rishli nu trocyup or ndeꞌ yuꞌ yaa nañ tub dzi? Benu ca na tub mbecy rded yu zeꞌ nu yuꞌ yaa, orzeꞌ waglagy gyiꞌy, gun rzac dey ya̱, biñ nu rbic yaa lo de mbecy gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tees benu rded yu rel, orzeꞌ rlagy gyiꞌy, gun sac yaa nu gzac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Orzeꞌ na gaꞌm: ―Lázaro, amig ni den, gush pcaal yu, tees na cha̱ gun cueeña̱ yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Orzeꞌ na gaꞌ de yu nu rsyaꞌ lom: ―Shuaan de̱, benu nas yu, ¿orzeꞌ yaruuñ nu gruu nap yu shiñ? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tees riidz ni Jesuuz yaruuñ nu gut Lázaro, tees de yu nu rsyaꞌ lom guzii dey nu mniim nu nas ziꞌl yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Orzeꞌ Jesuuz naal la mniim lo dey. Orzeꞌ nam: ―Gut Lázaro. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tees nu nac de ru yet lagya̱ nu saca̱ loy, gun orzeꞌ gyicy cup der consuel lo̱. Yaa der chan lo cuerp na ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Orzeꞌ Tomaas, yu nu rnii dey cuach, nay rab yu deꞌ zir de yu nu rsyaꞌ lo Jesuuz: ―Yaa der cha dun masht nin, gun orzeꞌ gat den tublaazh dun mi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na ornu bri Jesuuz Betania, orzeꞌ briic mbecy nu gad lagy mi nu bi gut Lázaro nunu bi bzaꞌ tap dzi nu ri cuerp niy gyerbaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania, ndeꞌ tub chon miily metr nu zet riñ nu Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nunu zigy de mbecy Israeel za güii dey Mart nu Li nu cuic dey consuel ni deñ nu nac nu gut zan ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na ornu güeñ Mart nu bi zaab riidz nu bi yeed Jesuuz, orzeꞌ za cheel ñim. Tees Li byeeñ ñi yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Orzeꞌ na Mart rab ñi Jesuuz: ―Shuaana̱, bicy na nu zur ii, orzeꞌ cueꞌ ñgyat zana̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tees rad lagya̱ nu mas na, Ñgyoozh gyicy mi la ziꞌl coz nu cyiñ ru lom ―naañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Orzeꞌ na gaꞌ Jesuuz rab mi Mart: ―Zan ru gyabañ yu tuubaꞌ tir ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Orzeꞌ na gaꞌ Mart: ―Bi rad lagya̱ nu gyabañ ñi ornu gyabañ de añ ornu shuub dzi nu gyaꞌ lo gyishlombecy ii ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Orzeꞌ na gaꞌ Jesuuz rab mi ñii: ―Ya̱ naca̱ biñ nu gyicy nu gyabañ de añ, nunu naca̱ biñ nu gyicy nu cui mbañ de mbecy. Orzeꞌ cyu ziꞌl mbecy nu gyicy cup consuel lo̱, mas gat yu, tees cui mbañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Cyu ziꞌl mbecy nu gabee mbañ, benu gyicy cup yu consuel lo̱, orzeꞌ yu zeꞌ rishli gaal wataꞌy. ¿A rzeña lagy der de nu ndeꞌ Mart? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Orzeꞌ na gaꞌ Mart: ―Laab Shuaana̱, rzeña lagya̱ nu ru nac ru Mesías, iꞌñ Ñgyoozh, biñ nu ca lo cuen nu cyid gyishlombecy ii ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na ornu blazh mnii Mart de riidz zeꞌ, orzeꞌ bish cyañ yaañ. Orzeꞌ dze ga bredz ñi bily ñii Li. Orzeꞌ nañ: ―Masht bi yeed gaab mi nunu rbedz mi ru nu char lom ―naañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na ornu güeñ Li riidz zeꞌ, orzeꞌ lueg la wes suñ zañ lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Zeꞌ Jesuuz gaal zi nigul chuꞌm ruꞌ gyedz, sinu gabee zum lugaar zeꞌ nu bdzeel mi Mart. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na de mbecy zeꞌ nguaay yuꞌ Li nu rbic dey consuel niñ. Ornu bzaac dey nu dzach wes suñ zañ, orzeꞌ za ca dey ich ñi, gun mnii too dey nu zañ nu gun ñi ruꞌ baa ni zan ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na ornu bruꞌña Li lugaar zeꞌ nu zu Jesuuz, orzeꞌ cuanzir nu bzaac ñim, orzeꞌ bdugyiñ yee lañ yeñ gyiꞌm. Orzeꞌ nañ: ―Shuaan de̱, bicy na nu zur ii, orzeꞌ cueꞌ ñgyat zana̱ ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na ornu bzaac Jesuuz nu dzi ruun Li gal nu de mbecy nu bruꞌña nuñ, orzeꞌ tonaꞌ la shni guc añ nim nunu gyi la byash lagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Orzeꞌ nam rab mi dey: ―¿Ca lugaar pcach der yu? ―nam. Orzeꞌ na gaꞌ dey: ―Shuaan de̱, da güiir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Orzeꞌ biiñ Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Orzeꞌ na de mbecy Israeel: ―¡Güii ñuu la! ¡Razañ lagy yu Lázaro! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tees yuꞌ de mbecy zeꞌ nay: ―Yu ii bicy yu nu rzac mbecy lo caꞌ. ¿A walab nu ñgyac ñgyicy yu tub mod nu cueꞌ ñgyat Lázaro? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Orzeꞌ Jesuuz tonaꞌ la shni guc añ nim tuubaꞌ tir. Orzeꞌ zam ruꞌ baa. Baa zeꞌ, ndeꞌ tub blyuu. Nunu psoow dey ruꞌñ nu tub gyitaꞌ ily. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Orzeꞌ na Jesuuz: ―Byash der gyitaꞌ re ―nam. Orzeꞌ na Mart, zan yu nu gut zeꞌ: ―Shuaan de̱, dzi bi byafert tiꞌ gun bi rac tap dzi nu pcach de̱ ñii ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Orzeꞌ na gaꞌ Jesuuz rab mi ñii: ―¿A walab bi mne̱e̱ lor, benu gyicy cup ru consuel lo̱, orzeꞌ gzac ru gyel lily ni Ñgyoozh? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Orzeꞌ byash dey gyitaꞌ zeꞌ. Orzeꞌ Jesuuz bgüiim par baa. Orzeꞌ nam: ―Ñgyoozh uza̱, ya̱ drica̱ gras nir gun güeñ ru de coz nu mne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Rad lagya̱ nu dub laa tiem reñ ru de riidz nu rne̱e̱, tees ya̱ ni rne̱e̱ gun ndeꞌ coz nap par de mbecy nu yuꞌ ii, gun orzeꞌ cheña lagy dey nu ru bzuu nez ru ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Na ornu blazh mniim de riidz zeꞌ, orzeꞌ brish tim. Orzeꞌ nam: ―¡Bruu zeꞌ Lázaro! Da ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Orzeꞌ Lázaro bruuy, tees gabee nag yaay nu gyiꞌy nu negy nu ptiish dey yu gal nu bay nu mbish loy. Orzeꞌ na Jesuuz: ―Pshaagy der yu, gun orzeꞌ gac gyay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zigy de mbecy nu gua nu Li, ornu bzaac dey de coz nu bicy Jesuuz, orzeꞌ bicy cup dey consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tees yuꞌ gaꞌ mbecy bish cya dey lo de mbecy fariseo nu byoo dey rishloy de coz nu bicy Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Orzeꞌ de mbecy fariseo, nu de yu zub lo ni de uz, gal nu de yu nu riib ic ni junt zub lo, orzeꞌ na dey: ―¿La ñuu coz gyicy den na? Gun mbecy zeꞌ dzi guzañ nusuriidz ricy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Benu zaan den nu ni gyicy zir yu, orzeꞌ dela mbecy gyicy cup dey consuel loy. Orzeꞌ cyid de soldad Rom nu nit lo dey yuꞌ yon ni den gal nu de ledz na ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tees lat dey brusu tub yu nu la Caifás. Yu zeꞌ yu nu riib ic de uz ñaꞌn zeꞌ. Orzeꞌ nay rab yu dey: ―De ru rila wagad lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni wagad lagy der ca na nu nap zir par de ru. Nap zir nu gat tub zi mbecy par lo dela mbecy gazeꞌ nu nit lo dela losaꞌn: de mbecy Israeel ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tees Caifás walab nu mniiy riidz nu bruu ic ub ziꞌl yu, sinu mniiy por cuen ni Ñgyoozh ornu mniiy nu Jesuuz gat mi par de mbecy Israeel, como nac yu yu nu riib ic de uz ñaꞌn zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nunu walab nu nac mbecy Israeel ziꞌl gut mi, sinu niꞌ ziꞌl gut mi par nu nac dela mbecy ni Ñgyoozh nu yuꞌ dela lugaar ni gyishlombecy, gun orzeꞌ gyac se tub nac ziꞌl dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gush ñi nese dzi zeꞌ nu psaap dey riidz nu cut dey Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Orzeꞌ Jesuuz wanchesa gaꞌm suelt la lat de mbecy Israeel. Orzeꞌ bruum lo de yu ni Judea zam tub lugaar ub zi ni tub gyedz nu la Efraín. Orzeꞌ zeꞌ pcyiiñ mi nu de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na ornu se ñuu ga shuub dzi nu chuꞌ de mbecy Israeel saꞌ ni Pas, orzeꞌ zigy de mbecy nu yuꞌ reñaꞌ gyedz ya dey par Jerusaleeng, gun orzeꞌ gyicy dey coz nu gyicy nu gyacaacy dey par lo Ñgyoozh anzir nu chuꞌ saꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Orzeꞌ brugyiꞌ rded dey ryub yu Jesuuz, nunu rgugyiꞌ dey lo losaꞌy lugaar zeꞌ nu driib zily dey Ñgyoozh. Orzeꞌ na dey: ―¿La ñuu rnii too der? ¿A cyid yu saꞌ o ti wayid yu? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Orzeꞌ de yu zub lo ni de uz, gal nu de mbecy fariseo, orzeꞌ mnii dey lo de mbecy ben ca na dey rad lagy yu ca zu Jesuuz. Orzeꞌ rlagy ñi cha too dey rishlo dey gun orzeꞌ cha nu dey mi pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesuuz guam Betania shuup ruꞌ dzi anzir nu chuꞌ saꞌ ni Pas. Betania zeꞌ nu pcyiiñ Lázaro, yu nu bicy mi nu byabañ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Orzeꞌ de mbecy nu yuꞌ zeꞌ bzu ye dey tub che nu gow nuy mi. Zeꞌ Mart psaañ gyaꞌn. Nunu gazaꞌ Lázaro riy lat de yu nu nguaa lo mez nu gyicy che zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Orzeꞌ Li bruꞌña nuñ chon gaynal gram tub lo asecy zguul nu la nardo nu tonaꞌ la ñgyup sac. Orzeꞌ pcooñ ndeꞌ gyiꞌ Jesuuz. Orzeꞌ pcuiigy ñi asecy zeꞌ nu gyich ic ñi. Orzeꞌ bzu laa nu zguul dutuub la nañ yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Zeꞌ zu Judas Iscariote, tub yu nu rsyaꞌ lom. Laab yu zeꞌ yu nu bguꞌ Jesuuz yaa de yu nu rzi lagy lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Orzeꞌ nay: ―¿Lagu wansaꞌy asecy zguul re nu sac i mbecy ni chon gaynal dzi? Gun orzeꞌ gad tiñ nu gric na ni de mbecy zi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tees Judas ni mniiy, gun nac yu gubaan walab par nu nac nu rcay de mbecy zi. Nunu bzuy riiñ nu ri yaay nerbid nu rguꞌ dey tiñ ni dey. Nunu yuꞌ nu rboo dzey tiñ zeꞌ par ub ziꞌl yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Orzeꞌ na Jesuuz: ―Cueꞌ gyicy zeed ru fiñ ii, gun bi bzu lily ñii asecy ii par nu duzu cuerp ne̱ par ornu shuub dzi nu cach dey ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ya̱ walab nu tuñ cyiiña̱ lat der, tees de mbecy zi zaab yuꞌ la dey lat der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zigy de mbecy nu zu riiñ ni de mbecy Israeel güeñ dey nu zu Jesuuz Betania. Orzeꞌ gua dey zeꞌ walab tub lo ziꞌl nu za güii dey mi sinu niꞌ ziꞌl par nu za güii dey Lázaro, yu nu bicy mi nu byabañ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Orzeꞌ de yu zub lo ni de uz bzaꞌ lo dey nu niꞌ cut dey Lázaro, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","gun par nu nac yu zeꞌ zigy de mbecy Israeel druu chu dey lo de uz par nu ricy cup dey consuel lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Orzeꞌ tuubaꞌ dzi de mbecy zigy nu gua saꞌ ni Pas güeñ dey nu bi yeed Jesuuz par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Orzeꞌ blag dey de yaa ya gyiñ. Orzeꞌ za cheel dey mi. Nunu rbish ti dey. Orzeꞌ na dey: ―¡Dzi ga zily nac Ñgyoozh! ¡Ñgyoozh nac num ru, biñ nu bzuu nez mi! ¡Ñgyoozh nac num ru, biñ nu nac rey ni de ub na, mbecy Israeel! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Orzeꞌ guud tub bur miꞌ ni Jesuuz. Orzeꞌ byub mi ma gal nu rniiñ lat de riidz ni Ñgyoozh. Rniiñ: ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Cueꞌ dzib der, mbecy nu yuꞌ gyedz Sión. Güii der. Re yad rey ni der. Riib mi tub bur miꞌ, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tiem zeꞌ de yu nu rsyaꞌ lom wangyet lag dey cuen de nu ndeꞌ. Tees ornu Jesuuz bish cyam lo gyel lily nim, orzeꞌ byezaꞌ lagy dey nu de riidz ni Ñgyoozh mniiñ nu ni zac mi nunu mniiñ nu ni gyicy nu mbecy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na gazaꞌ de mbecy nu bzaac ornu Jesuuz bredz mi Lázaro nu ruuy gyerbaa niy nunu bicy mi nu byabañ yu, de yu zeꞌ mnii dey lo mbecy coz nu bzaac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ndeꞌ nu zigy mbecy gua cheel dey mi, gun güeñ dey nu bicy mi nusuriidz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Orzeꞌ na de mbecy fariseo rab dey losaꞌy: ―Na bi bzaac der nu rila wadaꞌ mod ni den. Güii der. Dela mbecy za ca dey ich yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na lat de mbecy nu gua Jerusaleeng nu briib zily dey Ñgyoozh lat saꞌ, lat de yu zeꞌ ri la be mbecy griego. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Orzeꞌ de yu zeꞌ bechaꞌ dey lo Lip. Yu zeꞌ nac yu tub mbecy Betsaida, tub gyedz nu ri lo yu ni Galilea. Orzeꞌ na dey rab yuy: ―De̱ ya̱ rlagy de̱ ne̱e̱ du̱ Jesuuz ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Orzeꞌ Lip gua niiy lo Ndrees. Orzeꞌ rup laa dey gua nii dey lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Orzeꞌ nam rab mi dey: ―Bi rshuub tiem nu ya̱, biñ nu byac mbecy, gri̱ lo gyel lily ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ya̱ rishli rne̱e̱ lo der nu benu tub mbigy trig wayet lag ñi lo yu nu nit loñ, orzeꞌ laab tub ziꞌl mbigy nac ñii. Tees benu nit loñ, orzeꞌ cuic ñi zañ cosech. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yu nu rash shcab nu ricy ñi presis nu cui mbañ gyishlombecy ii, yu zeꞌ gat yu. Tees yu nu rash shcab nu a̱ꞌ ricy ñi presis nu cui mbañ gyishlombecy ii, yu zeꞌ gad nu cui mbañ yu tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Gun benu ca na tub mbecy rlagy yu nu gyicy yu gal nu rne̱e̱, orzeꞌ rlagy ñi nu cyid cay icha̱. Orzeꞌ zeꞌ nu ya̱ zu̱, laabaꞌ zeꞌ gzuy. Nunu Ñgyoozh, uza̱, gyicy mi nu gya gzuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’¡Na deet rac nañ lardo̱o̱! ¿Per la ñuu coz ne̱e̱? ¿A gne̱e̱: “Uza̱, bloo chu de coz nu gzaca̱ na”? ¡Tees laab par gyiꞌ ndeꞌ nu yapa̱ gyishlombecy ii! ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Uza̱ bicy nu gyed gyel mbecy nir ―nam. Orzeꞌ zaab tiꞌ nu mnii Ñgyoozh gashtal gyibaa. Orzeꞌ nam: ―Bi bicya̱ nu bruu zac gyel mbecy ne̱, nunu gyicya̱ nu gruu zac zir ñi par lo ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Orzeꞌ de mbecy zigy nu yuꞌ zeꞌ güeñ dey nu zaab tiꞌ zeꞌ. Orzeꞌ yuꞌ dey nu rniiy nu ndeꞌ guzii. Zeꞌ yuꞌ gaꞌ dey nu mniiy nu ndeꞌ tub anc nu mnii nuy Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Orzeꞌ Jesuuz nam rab mi dey: ―Walab nu nac ya̱ ndeꞌ nu zaab tiꞌ rnii sinu par nu nac de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na bi pshuub tiem nu gyuꞌ bee nu dzi a̱ꞌ nap de mbecy nu yuꞌ gyishlombecy ii. Nunu na Ñgyoozh gyicy mi gan nuras, yu nu riib ic gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tees ornu caa dey ya̱ lo cruuz, orzeꞌ laab ya̱ gyicya̱ nu gyechaꞌ dela mbecy lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ni mod mniim par nu briic mi nu gad lagy dey nu lac mod gat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Orzeꞌ na de mbecy zigy zeꞌ rab yum: ―De ub na rad lagy na nu lat de riidz ni leey ni den rniiñ nu Mesías, biñ nu ca lo cuen nu co mbañ mbecy, cui mbañ mi tub la, rniiñ. Benu ni, orzeꞌ ¿lagu rniir nu ru, biñ nu byac mbecy, caa dey ru lo cruuz, rniir? Orzeꞌ ¿ca na biñ nu byac mbecy nac ru beni? ―na de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ya̱, biñ nu rlyuu yaa, gabee chesa̱ ru̱ꞌ sñuu la be dzi lat der. Orzeꞌ zaab za la der lat nu gabee yuꞌ yaa gun orzeꞌ cueꞌ gyet cow ni der. Gun de mbecy nu rded zeꞌ nu cow wagad lagy dey ca par gash yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Orzeꞌ bicy cup der consuel lo ya̱, biñ nu rlyuu yaa, lat nu gabee rdeda̱ lat der, gun orzeꞌ nac der mbecy nu rded zeꞌ nu yuꞌ yaa ―nam. Na ornu blazh mniim de riidz zeꞌ, bruum lat dey nunu guam pcach lom ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mas Jesuuz bicy mi zañ nusuriidz ily lo dey, tees wangyicy cup dey consuel lom, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","gun orzeꞌ byuꞌ niñ gal nu pcaa Isaías, yu nu mnii por cuen ni Ñgyoozh. Orzeꞌ nay: Ñgyoozh, ¿cyu guña lagy ni de riidz nu mne̱e̱? Nunu ¿Cyu gac gyet lag cuen de coz ily nu gac gyicy ru? na Isaías. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndeꞌ nu wangac ñgyeña lagy dey, gun niꞌ ziꞌl pcaa Isaías: ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ñgyoozh nam: “Ya̱ psowa̱ urlo dey. Gun orzeꞌ cueꞌ gac zac dey nu urloy. Nunu bicya̱ nu guton shcab ni dey. Gun orzeꞌ cueꞌ gac gyet lag dey cuen, nis cush cya dey lo̱. Orzeꞌ gyicy napa̱ dey”, na Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","De riidz ii mnii Isaías gun bzaac yu gyel lily ni Jesuuz nunu laab mi zeꞌ bzat yu lat de riidz nu bzeeñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mas ni tees zigy de mbecy zub lo ni de mbecy Israeel bicy cup dey consuel lo Jesuuz. Tees wangyicy dey nu ñgyad lagy de losaꞌy gun rdzib dey lo de mbecy fariseo gun dzi ga cyuu nu dey yu nañ yuꞌ nu rsyaꞌ dey riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gun dzi zir yet lagy dey nu grib zily mbecy dey gazeꞌ nu grib zily Ñgyoozh yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Orzeꞌ Jesuuz ye la mniim. Orzeꞌ nam: ―Cyu ziꞌl mbecy nu ricy cup consuel lo ya̱, walab ti lo ya̱ ziꞌl ricy cup yu consuel, sinu niꞌ ziꞌl ricy cup yu consuel lo Ñgyoozh, uza̱, biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nunu mbecy nu rzac ya̱, niꞌ ziꞌl rad lagy yu la na biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ya̱ yapa̱ gyishlombecy ii par nu lyu̱u̱ yaa, gun orzeꞌ dela mbecy nu gyicy cup consuel lo̱, de yu zeꞌ wagyiyeeñ yu zeꞌ nu cow. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tees cyu ziꞌl mbecy nu gyeñ de riidz nu rne̱e̱, zeꞌ wazuub gyidag yuñ, walab ya̱ ne̱e̱ nu yuꞌ falt niy. Gun walab nu yapa̱ nu ne̱e̱ nu yuꞌ falt ni de mbecy ni gyishlombecy, sinu yapa̱ par nu gloo mbaña̱ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yu nu walagy gac nu ya̱, nunu yu nu wayicy cuen de riidz nu rne̱e̱, de yu zeꞌ bi zu tub coz nu gyicy ñi nu gyuꞌ bee nu yuꞌ falt ni dey. Gun de riidz nu ya̱ mne̱e̱, ndeꞌ gyicy ñi nu gyuꞌ bee nu yuꞌ falt ni dey ornu shuub dzi nu gyaꞌ lo gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gun ya̱ walab nu rne̱e̱ por cuen ni uba̱, sinu rne̱e̱ de riidz nu mnii Ñgyoozh, uza̱, biñ nu bzuu nez ya̱ nu gne̱e̱, nunu gne̱e̱ ñii mod nu mniim lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nunu rad lagya̱ nu de coz nu rnii Ñgyoozh, uza̱, ndeꞌ gyicy ñi nu cui mbañ mbecy tub la. Bi güeñ der beni nu de coz nu mne̱e̱, mne̱e̱ ñii lo der gal nu pcaam ya̱ nu ne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anzir nu shuub dzi nu chuꞌ saꞌ ni Pas, orzeꞌ bi gud lagy Jesuuz nu bi pshuub or nim nu ruum gyishlombecy nu gyam lo Ñgyoozh uz mi. Nunu dub laa tiem pcam de mbecy nu bicy cup consuel lom gyishlombecy ii. Nunu ni laa bicy mi gashtal pshuub la dzi nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na Jesuuz gusub mi nu gyicy mi che nu de yu nu rsyaꞌ lom. Orzeꞌ nuras bi bicy yu nu mnii too Judas Iscariote iꞌñ Simo̱o̱ nu cush cyay ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zeꞌ Jesuuz gud lagy mi nu Ñgyoozh briic mi fers nim nu gac gyicy mi dela coz. Nunu gud lagy mi nu lo Ñgyoozh bruum. Nunu gud lagy mi nu cush cyam nu gyam lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Orzeꞌ Jesuuz wes sum zeꞌ nu zub mi ricy mi che. Orzeꞌ bloom shab mi nu riib par ich. Orzeꞌ gush mi tub negy nu cuiigy mi dey. Orzeꞌ brim ñii nañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Orzeꞌ bduꞌm nis nañ tub casuel. Orzeꞌ brugyiꞌ nu rgyiib mi gyiꞌ tub ga de yu nu rsyaꞌ lom, nunu pcuiigy mi gyiꞌ dey nu negy nu bri nañ mi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na ornu bdugyi Bed nu cyib mi gyiꞌy, orzeꞌ nay rab yum: ―Shuaan na, ¿walab gaal ru cyib ru gyi̱ꞌ ya̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Orzeꞌ na Jesuuz rab mi yu: ―Na na la wagyet lag ru cuen de coz nu ricy du̱ ru, tees par lo, orzeꞌ gyet lag ru cuen ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Orzeꞌ na gaꞌ Bed: ―¡Mas lac ruꞌ ya̱ washet ica̱ nu ru cyib ru gyi̱ꞌ! ―nay. Orzeꞌ nam rab mi yu: ―Zeꞌ benu wadiba̱ gyiꞌr, orzeꞌ wac gac ru mbecy ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Orzeꞌ na gaꞌ Simo̱o̱ Bed: ―¡Zeꞌ benu ni, orzeꞌ cueꞌ nu gyiꞌ ziꞌla̱ cyib ru, sinu niꞌ ziꞌl ya̱a̱ gal nu to̱o̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Orzeꞌ na Jesuuz rab mi yu: ―Cyu ziꞌl mbecy nu bi blaagy, yu zeꞌ walagy ñi nu cyib yu deꞌ zir lugaar ni cuerp niy. No maas gyiꞌ ziꞌl yu rlagy ñi nu cyib yu, gun dutuub la cuerp niy bi byacaacy ñi. Zeꞌ de ru bi byacaacy der, tees walab dela der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesuuz mniim nu walab dela dey byacaacy yu, gun bi gud lagy mi nu ca na yu nu cush cya ich mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na ornu blazh nu bdiib mi gyiꞌ dey, orzeꞌ bzu gaꞌm shab mi nu riib par ich zeꞌ. Orzeꞌ bish cya gaꞌm nu gusub mi lo mez tuubaꞌ tir. Orzeꞌ nam: ―De ru, ¿a bet lag der cuen coz nu bicy du̱ der ii na? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","De ru rnii der nu ya̱ naca̱ moscuel nunu naca̱ Shuaan der. Nunu laab ni gal nu de ru rniir nu naca̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tees como ya̱ naca̱ moscuel ni der, nunu naca̱ Shuaan der, se ya̱ bdiba̱ gyiꞌ der, ndeꞌ nu niꞌ de ru rlagy ñi nu cyib tub, cyib tub ziꞌl der gyiꞌ losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nii tub mod nu blyu̱u̱ ni der, gun orzeꞌ niꞌ ziꞌl mod gyicy nu der losaꞌr: gal nu ya̱ bicy du̱ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ya̱ rishli rne̱e̱ lo der, nu ni tub la moz walab nu zily zir nac yu gazeꞌ patro̱o̱ niy. Nunu ni tub la mbecy nu rza nu raso̱o̱ walab nu zily zir nac yu gazeꞌ yu nu rzuu nez yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na como bi gyet lag der cuen de coz ii, orzeꞌ dzi ni der benu gyicy der gal nu ya̱ mne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Walab nu rzata̱ dela de ru, gun rad lagya̱ la na lardoo de mbecy nu bi pcui̱. Tees rlagy ñi nu gyuꞌ niñ gal nu rniiñ lat de riidz ni Ñgyoozh zeꞌ nu rniiñ: “Tub mbecy nu bdow nu ya̱ gyishtily, mbecy zeꞌ cush cyay icha̱”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ya̱ tiem ne̱e̱ de riidz ii lo der, anzir nu gac ñii, gun orzeꞌ ornu gac ñii, de ru cheña lagy der nu ya̱ naca̱ biñ nu naca̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ya̱ rishli rne̱e̱ lo der, benu ca na tub mbecy cueez yu tub yu nu gzuu neza̱ nu gyiyeeñ nuy yu, orzeꞌ niꞌ ziꞌl cueez yu ya̱ nu gyiyeeñ du̱ yu. Nunu cyu ziꞌl mbecy nu cueez ya̱, niꞌ ziꞌl cueez yu Ñgyoozh biñ nu bzuu nez ya̱ nu yapa̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na ornu blazh mnii Jesuuz de riidz zeꞌ, orzeꞌ tonaꞌ la deet guc nañ lardoom. Orzeꞌ naal la mniim lo dey. Orzeꞌ nam: ―Ya̱ rishli ne̱e̱ lo der nu lat de ru gruu tub mbecy nu cush cya icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Orzeꞌ de yu nu rsyaꞌ lom, brugyiꞌ nu rgüii tub, rgüii tub ziꞌl dey lo losaꞌy, gun wagad lagy dey cyu rniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cuit Jesuuz gusub ya̱, tub yu rsyaꞌ lom, nu gyicy du̱m che. Laab ya̱ yu nu dzi razañ lagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Orzeꞌ Simo̱o̱ Bed briic yu nu gad lagya̱ nu rlagy yu nii nuy ya̱. Orzeꞌ nay: ―Bdugyiꞌ lom ben ca na den rzat mi ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Orzeꞌ byagaab zira̱ lo Jesuuz. Orzeꞌ mne̱e̱: ―Shuaan de̱, ¿cyu ndeꞌ? ―mne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Orzeꞌ na Jesuuz: ―Ya̱ sala̱ tub laꞌ gyishtily. Orzeꞌ yu nu grica̱ ñii ni zeꞌ orzeꞌ yu zeꞌ ndeꞌ ―nam. Na ornu blazh mniim de riidz zeꞌ, orzeꞌ psal mi tub laꞌ gyishtily. Orzeꞌ briic mi ñii ni Judas, yu nu nac iꞌñ Simo̱o̱ Iscariote. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nunu cuanzir gush Judas gyishtily zeꞌ, orzeꞌ nuras gutib ic yu nañ lardooy. Orzeꞌ na Jesuuz rab mi yu: ―Na bicy lal gua gyicy ru ca na coz nu gyicy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tees ni tub la de yu nu nguaa lo mez zeꞌ wangyet lag dey cuen lagu nu ni mniim gugy mi Judas. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gun Judas nac yu yu nu riib ic nerbid tiñ. Orzeꞌ la be de yu nu nguaa zeꞌ mnii too dey nu Jesuuz mniim lo Judas nu cha ziiy coz nu cyiiñ par saꞌ. O benu walab ni, orzeꞌ nu cha leez yu la tub coz lat de mbecy zi, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Orzeꞌ laab gush la Judas gyishtily zeꞌ. Orzeꞌ bruuy zay. Ndeꞌ tub or bi rel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na despuees ornu bi bruu Judas nu zay, orzeꞌ na Jesuuz: ―Na bi pshuub dzi ne̱ ya̱, biñ nu byac mbecy, nu gabe nu dzi lily na̱, nunu nu nac ya̱ gabe nu dzi lily na Ñgyoozh uza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nunu benu gabe nu dzi lily na Ñgyoozh nu nac ya̱, orzeꞌ niꞌ ziꞌl Ñgyoozh gyicy mi nu gabe gyel lily ne̱ ya̱, nunu bi gyicy gyiily lam ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","De ru, yu nu na gal nu na iꞌña̱, walabaꞌ nu tuñ tiem cyiiñ du̱ der. De ru yub der ya̱, tees niꞌ ziꞌl rne̱e̱ lo der na gal nu mne̱e̱ lo de mbecy Israeel: “Wac gya der zeꞌ nu ya̱ gya̱.” ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ya̱ gzeeña̱ tuubaꞌ riiñ cub nu gyicy der: nu ca tub, ca tub ziꞌl der losaꞌr. Gal nu ya̱ rca̱ de ru, niꞌ ziꞌl gyicy der nu ca tub, ca tub ziꞌl der losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zeꞌ benu de ru ca tub, ca tub ziꞌl der losaꞌr, orzeꞌ dela mbecy gad lagy dey nu de ru nac der mbecy nu rsyaꞌ lo̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Orzeꞌ na Simo̱o̱ Bed rab yu Jesuuz: ―Shuaan de̱, ¿zeꞌ ca char? ―nay. Orzeꞌ na Jesuuz: ―Na na la wac cyid car icha̱ zeꞌ nu ya̱ gya̱. Tees par lo gac cyid car icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Orzeꞌ na Bed rab yum: ―Shuaan de̱, ¿lagu wac yap ca̱ ich ru na la? ¡Ya̱ bi zu̱ la̱ ca na nu zu̱, mas gata̱ nu nac ru! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Orzeꞌ na gaꞌ Jesuuz rab mi yu: ―¿A rishli gaal bi zur nu gat ru par nu nac ya̱? Ya̱ rishli rne̱e̱ lor nu anzir nu cuedz ngüel, orzeꞌ chon tir niir nu a̱ꞌ yuꞌ lor ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Orzeꞌ na gaꞌm rab mi dey: ―Cueꞌ zaan der nu gac deet nañ lardoor. Bicy cup der consuel lo Ñgyoozh, nunu niꞌ ziꞌl bicy cup der consuel lo̱ ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gun lugaar zeꞌ nu rcyiiñ Ñgyoozh uza̱, tonaꞌ la yuꞌ lugaar par nu cyiiñ mbecy. Zeꞌ benu walab ni, orzeꞌ ya̱ bi mne̱e̱ lo der. Ndeꞌ nu ya̱ gya̱ ga̱. Gun zu napa̱ lugaar nu cyiiñ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nunu despuees ornu bi ya̱a̱, nunu bi bzu napa̱ lugaar nu cyiiñ der, orzeꞌ yapa̱ tuubaꞌ tir par nu gya du̱ der, gun orzeꞌ cyiiñ der laab lugaar zeꞌ nu ya̱ cyiiña̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","De ru bi rad lagy der ca par gash ru nez par nu gri der zeꞌ nu ya̱ gya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Orzeꞌ na Tomaas rab yu Jesuuz: ―Shuaana̱, wagad lagy de̱ ca gyar. Yegar nu gad lagya̱ꞌ de̱ ca par riib nez nu ya zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―Ya̱ naca̱ biñ nu rlyuu nez nu gya mbecy lo Ñgyoozh, nunu naca̱ biñ nu rnii coz rishli ni Ñgyoozh, nunu naca̱ biñ nu gyicy nu cui mbañ de mbecy. Gun wac gri ni tub la mbecy lo Ñgyoozh benu walab nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Como de ru bi yuꞌ lo der ya̱, ndeꞌ nu niꞌ ziꞌl bi yuꞌ lo der Ñgyoozh uza̱. Nunu nese na la bi yuꞌ lo der mi. Nunu bi bzaac der mi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Orzeꞌ na Lip rab yu Jesuuz: ―Shuaana̱, blyuu Ñgyoozh uz ru lo̱ de̱. Orzeꞌ bi guuc la ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Orzeꞌ na gaꞌ Jesuuz: ―Lip, gula be la tiem rded du̱ de ru. ¿Walab gaal gabee a̱ꞌ yuꞌ lor ya̱? Cyu ziꞌl mbecy nu rzac ya, yu zeꞌ bi bzaac yu Ñgyoozh uza̱. ¿Lagu rniir nu lyu̱u̱ Ñgyoozh uza̱ lor? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A wacheña lagy ru Lip nu ya̱ tub ziꞌl naca̱ nu Ñgyoozh uza̱, nunu Ñgyoozh uza̱ tub ziꞌl nac mi num ya̱? ―nam rab mi Lip. Orzeꞌ na gaꞌm: ―De riidz nu mne̱e̱ lo der na, ndeꞌ walab riidz nu bloo ic ya̱ ziꞌl, sinu Ñgyoozh uza̱, biñ nu rcyiiñ nañ lardo̱o̱, mi zeꞌ ricy mi de coz ily nu rlagy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Guña lagy der nu ya̱ tub ziꞌl naca̱ nu Ñgyoozh uza̱, nunu Ñgyoozh uza̱ tub ziꞌl nac mi nu ya̱. Benu wacheña lagy der nu nac de riidz nu rne̱e̱ ziꞌl la, orzeꞌ guña lagy der mas ñuu nu nac de coz ily nu ricya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ya̱ rishli rne̱e̱ lo der nu cyu ziꞌl mbecy nu gyicy cup consuel lo̱, niꞌ ziꞌl gac gyicy yu de coz ily nu ya̱ ricya̱, nunu coz ilyaꞌ zir gac gyicy yu, gun ya̱ gya̱ lo Ñgyoozh uza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nunu dela coz nu cyiñ der lo̱ par nu nac der mbecy nu ricy cup consuel lo̱, orzeꞌ gyicya̱ ñii, gun orzeꞌ gabe gyel lily ni Ñgyoozh uza̱ nu nac ya̱, iꞌñ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Gyicya̱ la ziꞌl coz nu cyiñ der lo̱ nu nac nu ricy cup der consuel lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Benu de ru rca der ya̱, orzeꞌ gzuub gyidag der de coz nu rne̱e̱ nu gyicy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Orzeꞌ ya̱ ne̱e̱ du̱ Ñgyoozh uza̱ nu gzeed mi tuubaꞌ biñ nu glocyuub de ru. Nunu mi zeꞌ cyiiñ num der tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mi zeꞌ Espiriit Yon, biñ nu glyuu de coz rishli ni Ñgyoozh. De mbecy nu riib ic gyishlombecy wazaan dey nu cuez mi loy. Gun wacsac dey mi. Nunu a̱ꞌ yuꞌ lo dey mi. Tees de ru yuꞌ lo der mi, gun mi zeꞌ nac num de ru, nunu rcyiiñ mi nañ lardoo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Ya̱ wazeeñ ga̱ de ru ub zir nu wad cyu nu glocyuub der. Sinu yapa̱ lo der tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nañ tub miꞌ ziꞌl tiem de mbecy ni gyishlombecy wazacaꞌ dey ya̱. Tees de ru gzac der ya̱. Nunu par nu nac nu ya̱ cui mbaña̱, ndeꞌ nu de ru cui mbañ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ornu shuub dzi nu ya̱ yapa̱, orzeꞌ de ru gad lagy ru nu ya̱ tub ziꞌl naca̱ nu Ñgyoozh uza̱, nunu de ru nac nu der ya̱. Zeꞌ ya̱ nac du̱ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Cyu ziꞌl mbecy nu “O” nii ni de riidz nu ya̱ rne̱e̱, nunu gyicy yac yu niñ, yu zeꞌ yu nu rca ya̱. Nunu cyu ziꞌl mbecy nu rca ya̱, Ñgyoozh uza̱ rca gaꞌm yu. Nunu niꞌ ya̱ rca̱ yu. Nunu gyicya̱ nu gad lagy yu nu nac du̱ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Orzeꞌ na Judas (reñaꞌ Judas, walab Judas Iscariote): ―Shuaan de̱, ¿lagu gyicy ru nu gad lagy de̱ ya̱, zeꞌ wayicy ru nu gad lagy de mbecy ni gyishlombecy? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Orzeꞌ na gaꞌ Jesuuz: ―Cyu ziꞌl mbecy nu rca ya̱, yu zeꞌ ricy yac yu nu de riidz nu rne̱e̱. Nunu Ñgyoozh uza̱ rcam yu. Nunu ya̱ nu Ñgyoozh uza̱ cha̱ de̱ loy nu cyiiñ du̱ de̱ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Cyu ziꞌl mbecy nu waca ya̱, de yu zeꞌ wagyicy yac yu nu de riidz nu ya̱ rne̱e̱. Tees de riidz ne̱, ndeꞌ walab riidz nu bruu ic ya̱ ziꞌl, sinu ndeꞌ riidz nu bruu lo Ñgyoozh uza̱, biñ nu bzuu nez ya̱ nu yapa̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ya̱ rne̱e̱ dela de riidz ii lo der lat nu gabee zu̱ lat der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tees Espiriit Yon, biñ nu gzeed Ñgyoozh uza̱ nu glocyuub de ru nu nac ya̱, mi zeꞌ biñ nu lyuu ni der dela coz, nunu gyicy mi nu gyezaꞌ lagy der dela riidz nu mne̱e̱ lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ornu bi gya̱, orzeꞌ gzeeña̱ gyel ri zu nañ lardoo der. Gyel ri zu ni ub la̱ grica̱ ni der, nunu walab nu grica̱ ñii mod nu rbic de mbecy ni gyishlombecy ii. Cueꞌ zaan der nu gac deet nañ lardoor, nunu cueꞌ dzib der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","De ru bi güeñ der nu bi mne̱e̱ nu gya̱. Tees ya̱ yapa̱ cyiiñ du̱ der tubaꞌ tir. Bi bicy na nu de ru rca der ya̱, orzeꞌ cyit ni der ornu gad lagy ru nu ya̱ gya̱ lo Ñgyoozh uza̱, gun mi zeꞌ gya zir zum gazeꞌ ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ya̱ tiem rne̱e̱ de coz ii lo der, anzir nu gac ñii, gun orzeꞌ ornu gac ñii, cheña lagy der de coz nu mne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ya̱ watuuñ du̱ꞌ zir der nu riidz ii, gun bi yad nuras, yu nu riib ic gyishlombecy ii. Tees yu zeꞌ se la la cyiiñ yu par ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tees ni rlagy ñi nu gac, gun orzeꞌ gad lagy de mbecy ni gyishlombecy nu ya̱ rca̱ Ñgyoozh uza̱ nunu gad lagy dey nu ricya̱ de coz nu mniim lo̱. Orzeꞌ nam: ―Wes su der yaa chan, gun gruun ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Orzeꞌ na gaꞌ Jesuuz: ―Ya̱ naca̱ biñ nu na gal nu na lyucy urbyay nu rishli. Zeꞌ Ñgyoozh uza̱ ricy mi riiñ nu lyucy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nunu de ru na der gal nu na yaa lyucy zeꞌ. Benu ca na tub yaa lyucy zeꞌ wacuic ñi urbyay, orzeꞌ cyug mi ñii. Nunu de yaañ nu rbic urbyay dugyug loñ par nu gyanap zir ñi par nu cuic zir ñi urbyay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tees de ru bi byanap der nu nac de riidz nu rne̱e̱ lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bicy der nu cyiiñ nur ya̱ gal nu ya̱ rcyiiñ du̱ de ru. Gun tub yaa lyucy urbyay, wabic ñi urbyay benu ub ziꞌl ñi. Tees cuic ñi urbyay benu nash ñii cyong lyucy zeꞌ. Niꞌ ziꞌl nu de ru, wac gyicy ru coz nu rlagy Ñgyoozh benu walab nu rcyiiñ nu der ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ya̱ naca̱ biñ nu na gal nu na lyucy urbyay. Zeꞌ de ru nac der yaañ. Ornu tub mbecy rcyiiñ nuy ya̱, nunu ornu ya̱ rcyiiñ du̱ yu, orzeꞌ yu zeꞌ yu nu dzi ricy riiñ ni Ñgyoozh. Gun benu walab nu nac ya̱, orzeꞌ se la la gac gyicy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Cyu ziꞌl mbecy nu nac reñ nu ya̱, yu zeꞌ gduneꞌy. Gzac yu gal nu rzac tub yaa yag ornu rzi̱i̱ñ. Orzeꞌ gyicy tublaazh dey yaañ. Orzeꞌ ne̱ꞌ dey ñi lo gyi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Benu de ru gyicy der nu cyiiñ nur ya̱, nunu benu riidz nu rne̱e̱ ndeꞌ checañ ic der, orzeꞌ la ziꞌl coz nu cyiñ der lo̱, orzeꞌ gad ñi ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ñgyoozh uza̱ gruu zac gyel lily nim ornu de ru gyicy der zañ coz nu rlagy mi. Nunu ni mod gazeꞌ nu rishli gyac der yu nu rsyaꞌ lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nunu ya̱ rca̱ de ru gal nu Ñgyoozh uza̱ rcam ya̱. Cueꞌ dily lo der lo de coz nu rlagya̱ nu nac nu rca̱ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Benu gzuub gyidag der de coz nu rne̱e̱ nu gyicy ru, orzeꞌ “O” nii der ni de coz nu rlagya̱ nu nac nu rca̱ der. Gyicy der gal nu ricya̱ gun ya̱ bzuub gyidaga̱ ni Ñgyoozh uza̱, nunu “O” mne̱e̱ ni de coz nu rlagy mi nu nac nu rcam ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ni mne̱e̱ lo der, gun orzeꞌ gyet lagy der gal nu yet lagya̱. Nunu bded ruꞌ gaꞌ la nu gyet lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Coz nu rne̱e̱ lo der nu gyicy ru ndeꞌ nu ca tub, ca tub ziꞌl der losaꞌr gal nu ya̱ rca̱ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Benu tub mbecy “O” niiy nu gat yu nu nac amig niy, orzeꞌ yu zeꞌ rca zir yu amig niy par deꞌ zir mod nu gac cay amig zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","De ru nac der amig ne̱ benu gyicy der de coz nu ya̱ rne̱e̱ nu gyicy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ya̱ wane̱e̱ ga̱ꞌ nu de ru nu nac der moz ne̱, gun tub moz wagad lagy yu la na coz nu ricy patro̱o̱ niy. Sinu ya̱ rne̱e̱ nu de ru nac ru amig ne̱, gun ya̱ bi mne̱e̱ lo der dela coz nu mnii Ñgyoozh uza̱ lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","De ru walab nu pcui der ya̱, sinu ya̱ pcui̱ de ru nunu bdu̱ꞌ riiñ yaa der nu gyicy der gan zañ de coz nu rlagy Ñgyoozh, coz nu wanit lo. Orzeꞌ Ñgyoozh, uza̱, cuic mi dela coz nu cyiñ der lom nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Orzeꞌ nii coz nu rne̱e̱ lo der nu gyicy ru: Nu ca tub, ca tub ziꞌl der losaꞌr. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Como de mbecy ni gyishlombecy gazi lagy dey lo de ru, bicy der nu gad lagy ru nu lo ya̱ guzi lagy dey loga la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bi bicy na nu de ru ñgyac der mbecy ni gyishlombecy, orzeꞌ de mbecy ni gyishlombecy nca dey de ru gal nu rca dey deꞌ zir losaꞌy. Tees ya̱ pcui̱ de ru lat de mbecy ni gyishlombecy, nunu ndeꞌ nu de mbecy ni gyishlombecy rzi lagy dey lo der. Gun a̱ꞌ nacaꞌ der ni gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bicy der nu gyezaꞌ lagy ru nu ya̱ mne̱e̱ lo der: “Sac ni tub moz nu gya zir zuy par patro̱o̱ niy”, mne̱e̱ lo der. Como yuꞌ mbecy nu bzab dey ich ya̱, ndeꞌ nu niꞌ ziꞌl gzab dey ich de ru. Nunu como yuꞌ mbecy nu bzuub gyidag dey de riidz nu ya̱ mne̱e̱, orzeꞌ gzuub gyidagaꞌ dey ni de riidz nu gnii de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tees gzab dey ich der nu nac ya̱, gun a̱ꞌ yuꞌ lo dey Ñgyoozh, biñ nu bzuu nez ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Bicy na nu cueꞌ nu ya̱ nyapa̱ nu nne̱e̱ lo dey, orzeꞌ sac la falt ni dey nu nac nu zaab dey ich den. Tees na wac nii dey nu sac falt ni dey nu nac de coz nu ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Cyu ziꞌl mbecy nu rzi lagy lo ya̱, niꞌ ziꞌl rzi lagy yu lo Ñgyoozh uza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bicy na nu cueꞌ ñgyicya̱ zañ nusuriidz lat dey, coz nu rila nigul gyicy ni tub la mbecy, orzeꞌ sac la falt ni dey. Tees na bi bzaac dey de coz nu bicya̱ zeꞌ. Mas ni tees rzi lagy dey lo̱ nunu rzi lagya̱ꞌ dey lo Ñgyoozh, uza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tees ni mod rlagy ñi gac ñii par nu gyuꞌ ni de riidz nu bi ca lat leey nu bzeeñ Ñgyoozh ni dey. Zeꞌ rniiñ: “Rzi lagy dey lo̱ mas sac la la gyiꞌ.” ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Tees ya̱ zeeda̱ Espiriit Yon lo der, biñ nu glocyuub de ru. Mi zeꞌ biñ nu gnii de coz rishli ni Ñgyoozh nunu mi zeꞌ biñ nu gruu lom. Ornu cyid mi, mi zeꞌ gniim lo der cyu naca̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nunu niꞌ de ru gnii der cyu nac ya̱ gun nac nu der ya̱ nese nu loga la nu brugyiꞌ ricya̱ riiñ ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ya̱ bzata̱ de riidz ii lo der par nu cueꞌ checa der nu gyicy cup ru consuel lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gun wabicaꞌ dey lugaar nu gyatublaazh der nu dey nañ yuꞌ nu rsyaꞌ dey riidz ni Ñgyoozh. Nunu shuub dzi nu benu ca na tub mbecy cut yu de ru, orzeꞌ rash yu shcab nu gyicy yu ndeꞌ lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ni mod ricy dey gun a̱ꞌ yuꞌ lo dey Ñgyoozh uza̱ nunu niꞌ a̱ꞌ yuꞌ lo dey ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tees ya̱ bzata̱ de riidz ii lo der gun orzeꞌ ornu shuub dzi nu gac ñii, orzeꞌ gyezaꞌ lagy der de riidz nu mne̱e̱ lo der. ’Ya̱ walab nu mne̱e̱ de riidz ii lo der nese nu loga la nu brugyiꞌ nu rsyaꞌ der lo̱, gun nese tiem zeꞌ bi nac du̱ ya̱ de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tees na bi gya̱ lo Ñgyoozh, biñ nu bzuu nez ya̱. Tees ni tub la der wacugyiꞌr lo̱ ca gya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nomaas ca nu ricy shni der ornu mne̱e̱ de riidz ii lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tees ya̱ rishli rne̱e̱ lo der nu nap zir nu gya̱ par de ru, gun zeꞌ benu waya̱, orzeꞌ Espiriit Yon, biñ nu glocyuub de ru, wayid mi lo der. Tees benu gya̱, orzeꞌ ya̱ zuu neza̱m cyid mi lo der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ornu mi zeꞌ cyid mi, orzeꞌ naal la cuic mi nu gad lagy mbecy nu yuꞌ cyiy, nunu cuic mi nu gad lagy dey nu gac gyanap dey lo Ñgyoozh, nunu cuic mi nu gad lagy dey nu Ñgyoozh ri beem ni dela mbecy nu nac cyi dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cuic mi nu gad lagy dey nu yuꞌ cyiy gun wagyicy cup dey consuel lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cuic mi nu gad lagy dey nu gac gyanap dey gun ya̱ gya̱ lo Ñgyoozh uza̱, nunu wazacaꞌ der ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nunu cuic mi nu gad lagy dey nu gri beem ni de mbecy gun nuras, yu nu riib ic gyishlombecy ii, bi mnii Ñgyoozh nu gyay lo cashtig. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Yuꞌ ruꞌ zañ coz nu rlagya̱ ne̱e̱ lo der, tees na na la ni wagyee gaꞌ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ornu cyid Espiriit Yon ni Ñgyoozh, biñ nu rnii de coz rishli, orzeꞌ mi zeꞌ gyoom rishlo der dela coz rishli ni Ñgyoozh. Walab nu gniim nu nac shcab ni ub ziꞌl mi, sinu gniim de coz nu gnii Ñgyoozh lom. Nunu cuic mi nu gad lagy der ni de coz nu gac par lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mi zeꞌ gyicy mi nu gyabic mbecy gyel mbecy ne̱, gun de riidz nu ya̱ gne̱e̱ lom, laabaꞌ ndeꞌ gniim lo de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gun dela coz nu rad lagy Ñgyoozh uza̱, niꞌ ziꞌl ya̱ rad lagya̱ de coz zeꞌ. Ndeꞌ nu ya̱ mne̱e̱ lo der nu de riidz nu ne̱e̱ lo Espiriit Yon, laabaꞌ ndeꞌ gniim lo de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Nañ tub miiñ ziꞌl, orzeꞌ wazacaꞌ der ya̱. Tees nañ tub miiñaꞌ ziꞌl, orzeꞌ gzacaꞌ der ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Orzeꞌ la be de yu nu rsyaꞌ lom bee nu dey losaꞌy riidz. Orzeꞌ na dey: ―¿Lac yaruu de riidz zeꞌ nu nam nu nañ tub miiñ ziꞌl, orzeꞌ wazacaꞌ den mi; tees nañ tub miiñaꞌ ziꞌl, orzeꞌ bi gzacaꞌ den mi, gun gyam lo Ñgyoozh, uz mi, nam? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Lac yaruu de riidz zeꞌ nu nañ tub miiñ? Rila wac gyet lag na cuen de coz nu mniim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Orzeꞌ Jesuuz guud lagy mi nu rlagy dey cugyiꞌy lom. Orzeꞌ nam rab mi dey: ―Ya̱ bi mne̱e̱ lo der nu nañ tub miiñ ziꞌl orzeꞌ wazac der ya̱. Orzeꞌ nañ tub miiñaꞌ ziꞌl, orzeꞌ bi gzacaꞌ der ya̱, mne̱e̱. ¿A walab riidz nu mne̱e̱ zeꞌ, rgugyiꞌ der lo losaꞌr? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ya̱ rishli rne̱e̱ lo der nu de ru gun ru nunu gyicy shni der. Zeꞌ de mbecy ni gyishlombecy cyit ni dey. De ru gyicy shni der tees gruu gyel shni zu lagy zeꞌ ni der nunu gyet lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ornu tub biñ mñaa bi rac ye nim nu gaal mi mdoo, orzeꞌ ricy shnim gun bi pshuub or nim. Tees ornu bi bded nu gul mdoo nim, orzeꞌ nit lagy mi nu gutow nim gun cyit nim nu bri mdoo lom gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Niꞌ ziꞌl de ru. Ricy shni der na. Tees ya̱ cush cya̱ nu yap güi̱i̱ der par lo. Orzeꞌ gyel ni lardoo der nu gyet lagy ru. Nunu ni tub la mbecy wacgyicy dey nu checa der nu gyet lagy ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ornu shuub dzi zeꞌ, orzeꞌ wugyiꞌ gaꞌ der lo̱. ’Ya̱ rishli rne̱e̱ lo der nu Ñgyoozh, uza̱, cuic mi la ziꞌl coz nu cyiñ der lom nu nac ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nunu mas gal dzi na ni tub la coz nigul cyiiñ der lom nu nac ya̱. Bdiiñ der lom nunu gad ñi ni der gun orzeꞌ dub gal rii la lagy der gyet lagy ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ya̱ bi mne̱e̱ lo der de coz ii mod ni riidz tiily. Tees shuub dzi nu wane̱e̱ ga̱ꞌ lo der nu riidz tiily, sinu naal la gne̱e̱ lo der nu nac de coz ni Ñgyoozh, uza̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ornu shuub dzi zeꞌ, orzeꞌ wane̱e̱ lo der nu ya̱ diña̱ coz nu rlagy der lom, sinu ub la de ru cyiñ der coz zeꞌ lom nu nac ya̱, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","gun ub la Ñgyoozh, uza̱, rcam der. Rcam der gun de ru rca gaꞌ der ya̱ nunu guña lagy der nu ya̱ bru̱u̱ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ya̱ bru̱u̱ lo Ñgyoozh, uza̱, yapa̱ gyishlombecy ii. Na ya̱ gru̱u̱ gyishlombecy ii par nu gya̱ lo Ñgyoozh, uza̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Orzeꞌ na gaꞌ de yu nu rsyaꞌ lom rab yum: ―Na gaal naal la rniir. Walab nu riidz tiily rniir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na gaal gud lagy de̱ nu ru rad lagy ru dela coz. Ni walagy ñi nu cugyiꞌ mbecy lor par nu gad lagy ru la na coz nu rlagy yu. Ndeꞌ gyicy ñi nu cheña lagy de̱ nu ru bruur lo Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―¿A ndeꞌ nu gal na guña lagy der? ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na bi pshuub or, nunu na la ndeꞌ, ornu de ru grush las der tub ga lar nu nez nir. Nunu gzeeñ ga der ya̱ ub zi̱. Tees walab ub zi gyiyeeña̱ gun Ñgyoozh, uza̱, gac num ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","De la riidz ii rne̱e̱ lo der gun cheti ri añ ni der nu nac nu tub ziꞌl nac der nu ya̱. Gyishlombecy ii, de ru gzac zi der. Tees briic der baloor. Ya̱ bi bicya̱ gan gyishlombecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na ornu blazh mnii Jesuuz dela de riidz zeꞌ, orzeꞌ bgüiim par gyibaa. Orzeꞌ nam: ―Ñgyoozh, uza̱, bi pshuub or ne̱ na. Bicy nu gabe gyel lily ne̱ ya̱, iꞌñ ru, gun orzeꞌ ya̱ gyicya̱ nu gabe gyel lily ni ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gun ru briic ru rishbeey ne̱ nu gyub ica̱ dela mbecy. Gun orzeꞌ gyicya̱ nu cui mbañ dela de yu nu briic ru ne̱ tub la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nunu mod nu cui mbañ dey tub la, ndeꞌ nu nac nu cuꞌ lo dey ru, biñ nu tub zi la nac, Ñgyoozh rishli, nunu cuꞌ lo dey ya̱, Jesucrisht, biñ nu bzuu nez ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ya̱ bicya̱ nu gabe gyel lily nir gyishlombecy ii. Na bi bzaꞌ lo̱ de riiñ nu bduꞌr ya̱a̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndeꞌ nu, Ñgyoozh, uza̱, gyabicaꞌr gyel lily ne̱ ornu gri̱ lor, gyel lily nu bicy cupa̱ lor nil nese anzir nu gzub gyiꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’De mbecy nu bloo sur lat de mbecy nu yuꞌ gyishlombecy ii par nu cuic ru dey ne̱, de yu zeꞌ bi brica̱ nu gad lagy dey nu cyu nac ru. Nil nac de yu zeꞌ nir. Zeꞌ na de yu zeꞌ briic ru ne̱. Nunu de yu zeꞌ bzuub gyidag dey de riidz nu rniir, ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","nunu na bi gud lagy dey nu dela coz nu briic ru ne̱, ndeꞌ bruuñ lor. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ya̱ bi mne̱e̱ lo dey de coz nu mniir lo̱, nunu de yu zeꞌ “O” mnii dey. Nunu bi gud lagy dey nu rishli gaal lo ru bru̱u̱. Nunu guña lagy dey nu ru bzuu nez ru ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Na ya̱ rdiña̱ lor nu nac dey. Walab nu rdiña̱ lor nu nac de mbecy ni gyishlombecy. Tees rdiña̱ par de yu nu briic ru ne̱, gun nac dey nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Dela mbecy nu nac ne̱, niꞌ nac yu nir. Nunu de yu nu nac nir, niꞌ nac dey ne̱. Nunu nu nac de yu zeꞌ rabee de gyel lily ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ya̱ wacyiiñ tuña̱ꞌ gyishlombecy ii. Tees de yu zeꞌ gyiyeeñ yu gyishlombecy ii lat nu ya̱ yapa̱ cyiiñ du̱ ru. Ñgyoozh, uza̱, biñ yon, mña de yu nu briic ru ne̱ nu mod fert nu ricy cup ru, gun orzeꞌ rishli gaal tub ziꞌl gac dey nu losaꞌy gal nu tub ziꞌl nac ya̱ nu ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lat nu pcyiiñ du̱ dey gyishlombecy ii, ya̱ mña̱ dey nu nac tub mod fert nu bruu lor. Mña̱ de yu nu briic ru ne̱. Nunu ni tub la dey wantuneꞌy, sinu tub zi yu nu nil bi ca lo cuen nu duneꞌ. Gun orzeꞌ gyuꞌ niñ gal nu rniiñ lat de riidz nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Na ya̱ bi yapa̱ lor. Tees ya̱ rne̱e̱ de riidz ii lor lat nu gabee rcyiiña̱ gyishlombecy ii, gun orzeꞌ dub gal rii la lagy dey gyet lagy yu gal nu ya̱ yet lagya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ya̱ bi brica̱ nu gad lagy dey de riidz nir. Tees de mbecy ni gyishlombecy rzi lagy yu lo dey gun a̱ꞌ zu dey shcab gal nu zu de mbecy nu yuꞌ gyishlombecy ii shcab, como niꞌ ziꞌl ya̱ a̱ꞌ zu̱ de shcab zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Walab nu rdiña̱ lor nu cor dey lat de mbecy nu yuꞌ gyishlombecy ii, sinu rdiña̱ lor nu ña nap ru dey nu cueꞌ shiñ gyicy nu yu nu rnii dey nuras a̱ꞌ nap dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gal nu ya̱ a̱ꞌ zu̱ shcab nu zu de mbecy nu yuꞌ gyishlombecy ii, niꞌ ziꞌl de yu ii a̱ꞌ zu gaꞌ dey shcab zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bzu chu dey par nu gzu bich yu nu nac ru ziꞌl. Ni bicy nu nac de riidz nu rishli. Gun de riidz nir, ndeꞌ coz rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gal nu ru bzuu nez ru ya̱ lat de mbecy nu yuꞌ gyishlombecy ii, niꞌ ziꞌl ya̱ gzuu neza̱ dey chay lat de mbecy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nunu par nu nac de yu ii ricya̱ uba̱ par tub mbecy nu rzu bich nu nac ru ziꞌl, gun orzeꞌ niꞌ ziꞌl de yu ii gyac dey mbecy nu rzu bich nu nac ru ziꞌl. Ni gyicy dey nu nac de riidz rishli nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ya̱ walab nu rdiña̱ lor par nu nac de yu ii ziꞌl, sinu niꞌ ziꞌl rdiña̱ lor par nu nac de yu nu gyicy cup consuel lo̱ ornu gyeñ dey de riidz nu nii de yu ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ñgyoozh, uza̱, ya̱ rdiña̱ lor nu dela de yu ii, tub ziꞌl gac dey nu losaꞌy. Niꞌ ziꞌl tub ziꞌl gac yu nu de ub na gal nu ru tub ziꞌl nac ru nu ya̱ nunu ya̱ tub ziꞌl naca̱ du̱ ru. Nunu tub nac ziꞌl dey gac yu nu losaꞌy, gun orzeꞌ de mbecy nu yuꞌ gyishlombecy cheña lagy dey nu ru bzuu nez ru ya̱ yapa̱ gyishlombecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bicya̱ nu gabe nu nac dey mbecy nu lily na gal nu ru bicy ru nu gabe gyel lily ne̱ ya̱, gun orzeꞌ tub ziꞌl nac dey nu losaꞌy gal nu de ub na tub ziꞌl nac naa. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ya̱ tub ziꞌl naca̱ du̱ dey, nunu ru tub ziꞌl nac ru nur ya̱, gun orzeꞌ wayicy falt par ni ñuu miiñ nu tub ziꞌl gac dey nu losaꞌy, gun orzeꞌ de mbecy nu yuꞌ gyishlombecy ii gad lagy dey nu ru bzuu nez ru ya̱, nunu tonaꞌ la rcar de yu ii gal nu rca gaꞌr ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ñgyoozh, uza̱, ru briic ru de yu ii ne̱, nunu ya̱ rlagya̱ nu cyiiñ dey zeꞌ nu ya̱ cyiiña̱, gun orzeꞌ gzac dey de gyel lily ne̱: gyel lily nu briic ru ne̱. Gun ru rcar ya̱ nese anzir nu bzub gyiꞌ gyishlombecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ñgyoozh, uza̱, ru biñ nu dzi nap. De mbecy nu yuꞌ gyishlombecy ii a̱ꞌ yuꞌ lo dey ru. Tees ya̱ yuꞌ lo̱ ru. Nunu niꞌ ziꞌl de yu ii rad lagy dey nu ru bzuu nez ru ya̱ nu yapa̱ lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ya̱ bi brica̱ nu gad lagy dey nu cyu nac ru, nunu gric zira̱ nu gad lagy dey par lo, gun orzeꞌ mod nu ru rcar ya̱, laabaꞌ mod zeꞌ ca dey losaꞌy. Nunu laab ya̱ tub ziꞌl naca̱ du̱ dey ―na Jesuuz rab mi Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na ornu bded nu mnii Jesuuz de riidz zeꞌ, orzeꞌ bruum nu de yu nu rsyaꞌ lom lugaar zeꞌ nunu zam tub laꞌ gaꞌ gyerlas nu la Cedrón. Zeꞌ ri tub nac yag mni. Zeꞌ guꞌ Jesuuz lat ñi nu de yu nu rsyaꞌ lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Judas, yu nu bish cya ich mi, niꞌ yuꞌ loy lat de yag mni zeꞌ, gun zañ tir byatublaazh Jesuuz nu de yu nu rsyaꞌ lom lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Orzeꞌ Judas bruꞌña nuy tub nac soldad Rom gal nu cyup chon de mbecy nu rña nañ yuꞌ nu driib zily de mbecy Israeel Ñgyoozh. De yu zeꞌ güay par mandaar ni de yu zub lo ni de uz gal nu de mbecy fariseo. Orzeꞌ dela de yu zeꞌ zu tañ dey. Nuu dey candiil, nunu nuu gaꞌ dey yag nu zub gyi lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tees Jesuuz bi gud lagy mi dela coz nu gzac mi. Orzeꞌ bruum lat de yu nu rsyaꞌ lom. Orzeꞌ nam rab mi dey: ―¿Cyu ryub der? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Orzeꞌ na dey rab yum: ―Tub mbecy Nazaret, yu nu la Jesuuz, yu zeꞌ ryub de̱ ―na dey. Orzeꞌ na gaꞌ Jesuuz: ―Ya̱ nu ndeꞌ ―nam. Orzeꞌ Judas, yu nu bish cya ich mi, gazaꞌy zuy lat de yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na ornu mnii Jesuuz: “Ya̱ nu ndeꞌ”, nam, orzeꞌ dela dey bya ich yu nunu wes saa la dey lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Orzeꞌ na gaꞌ Jesuuz rab mi dey: ―¿Zeꞌ cyu gaal ryub der? ―nam. Orzeꞌ na gaꞌ dey: ―Mbecy Nazaret. Yu nu la Jesuuz ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Orzeꞌ na gaꞌm rab mi dey: ―Ya̱ bi mne̱e̱ lo der nu ya̱ ndeꞌ. Zeꞌ benu ya̱ ryub der, orzeꞌ bzaan der nu gya de yu ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tees mniim de riidz zeꞌ par nu gyuꞌ niñ gal nu mniim nu gac ñii ornu mniim: “Ñgyoozh, uza̱, ya̱ wansaana̱ nduneꞌ ni tub la de yu nu briic ru ne̱”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Orzeꞌ Simo̱o̱ Bed nuuy tub mandzicy. Orzeꞌ bloo zay ñi nunu pshiꞌñ yu gyidag bee tub moz ni uz nu riib ic deꞌ zir de uz. Moz zeꞌ lay Malco. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Orzeꞌ Jesuuz nam rab mi Bed: ―Dzach ru bri mandzicy zeꞌ seꞌñ. Taz nu gzuub Ñgyoozh, uza̱, ru̱ꞌ, ¿walab gaal wane̱e̱ “O” nu do̱ꞌ ñii? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Orzeꞌ de soldad Rom zeꞌ gal nu de yu nu riib ic dey gal nu de yu nu rña yuꞌ nu driib zily mbecy Ñgyoozh, de yu zeꞌ pcyiig dey yaa Jesuuz. Orzeꞌ za nu dey mi pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nu loga la gua nu dey mi lo Anás. Gun Anás nac yu uz gud Caifás, yu nu byub ic de uz ñaꞌn zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Orzeꞌ laab Caifás nac yu yu nu byoo rishlo de yu nu riib ic de mbecy Israeel. Mniiy nu nap zir nu gat tub zi mbecy gazeꞌ nu gat dela de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Orzeꞌ Simo̱o̱ Bed gal nu tuubaꞌ losaꞌy nu rsyaꞌ lo Jesuuz gua ca dey ich mi. Zeꞌ yu nu riib ic de uz zeꞌ nap yuꞌ loy tuubaꞌ yu nu rsyaꞌ lom zeꞌ. Orzeꞌ guꞌy nu Jesuuz loliꞌ ni yuꞌ ni uz nu riib ic zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tees Bed byeeñ gay par ich zeꞌ nu ca roꞌ. Orzeꞌ laab yu nu nap yuꞌ lo uz zeꞌ bish cyay nu gua nii nuy fiñ mñaa nu zu riiñ nu rshaal roꞌ zeꞌ. Nunu bicy yu nu guꞌ Bed loliꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Orzeꞌ na fiñ nu rshaal roꞌ zeꞌ rab ñi Bed: ―¿A gazaꞌ ru nac ru tub mbecy nu rsyaꞌ lo mi re? ―nañ. Orzeꞌ na Bed rab yuñ: ―Walab ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Como dzi rag, orzeꞌ de moz gal nu de yu nu rña zeꞌ pcuaa dey gyi. Orzeꞌ dub yub la yuꞌ dey nu rbidz dey ñi. Orzeꞌ gazaꞌ Bed riy lat de yu zeꞌ nu rbidz yu gyi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na yu nu riib ic de uz brugyiꞌ nu rgugyiꞌy lo Jesuuz nu nac de yu nu rsyaꞌ lom gal nu nu nac de coz nu blyuum ni de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Orzeꞌ Jesuuz nam rab mi yu: ―Ya̱ lo nu loo la mne̱e̱ lat dela mbecy. Dub laa tiem blyu̱u̱ ni de mbecy nañ de yuꞌ nu rsyaꞌ mbecy riidz ni Ñgyoozh gal nu nañ yuꞌ zeꞌ nu driib zily dey mi. Nunu zeꞌ nu yatublaazh de mbecy, zeꞌ rlyu̱u̱ ni dey. Ya̱ ni tub la coz wanne̱e̱ ngach. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Orzeꞌ lagu rgugyiꞌr lo̱? Bdugyiꞌ lo de mbecy nu bzuub gyidag de coz nu mne̱e̱, nunu de yu zeꞌ gyooy rishlor ni de coz nu mne̱e̱. De yu zeꞌ rad lagy dey de coz nu mne̱e̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ornu ni mnii Jesuuz, orzeꞌ tub yu nu rña zeꞌ pshet yu tub yaa nim. Orzeꞌ nay rab yum: ―¿A ni na riidz nu rlagy ñi nu niir gab ru yu nu riib ic de uz? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Orzeꞌ na Jesuuz rab mi yu: ―Benu shiñ mne̱e̱, orzeꞌ mnii lo de mbecy nu yuꞌ ii la na coz nu mne̱e̱. Zeꞌ benu laab ñi gal nu mne̱e̱, ¿orzeꞌ lagu pshet ru ne̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Orzeꞌ gal nag ziꞌl mi bzuu nez Anás mi zam lo Caifás, yu nu riib ic de uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Dub laa lat de ndeꞌ, laab zeꞌ gabee zu Bed nu rbidz yu gyi. Orzeꞌ na dey rab yu Bed: ―¿A walab gazaꞌ ru nac ru tub yu nu rsyaꞌ lo mbecy re? ―na dey. Orzeꞌ Bed pcach ruꞌy. Orzeꞌ nay: ―Walab ya̱ ndeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na zeꞌ zu tub moz ni yu nu riib ic de uz zeꞌ. Yu zeꞌ nac yu famil ni mbecy nu pshiꞌñ Bed gyidag zeꞌ. Orzeꞌ nay rab yu Bed: ―Gazaꞌ ru bzaaca̱ nu mbecy zeꞌ lat de yag mni zeꞌ, ¿shiñ? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Orzeꞌ Bed pcach ruꞌy mi tuubaꞌ tir. Orzeꞌ laab or la zeꞌ bredz ngüel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na or bi bzaꞌ yu, orzeꞌ bruu dey lo Caifás. Orzeꞌ za nu dey Jesuuz par roꞌ riiñ ni yu nu riib ic por cuen ni Rom. Zeꞌ de yu nu riib ic lat de mbecy Israeel wanchuꞌ dey nañ yuꞌ riiñ, gun walagy dey nu gabag yu par lo Ñgyoozh, gun orzeꞌ gac gyicy dey che de coz nu row dey lat saꞌ ni Pas. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Orzeꞌ bruu Pilato gua niiy lo dey. Orzeꞌ nay: ―¿La cyi driib der ic mbecy ii? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Orzeꞌ na dey: ―De̱ ya̱ wayap du̱ de̱ yu lor benu walab nu bicy yu coz cyi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Orzeꞌ na Pilato rab yu dey: ―Laab de ru yaa nu der yu nu gri bee der niy gal nu rniiñ lo leey ni der ―nay. Orzeꞌ na gaꞌ dey: ―Tees par lo leey a̱ꞌ ricy cup de̱ rishbeey nu gyicy de̱ nu gat ni tub la mbecy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ni guuc ñi par nu byuꞌ niñ gal nu mnii Jesuuz ornu mniim lac mod gat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Orzeꞌ Pilato bish cyay guꞌy nañ yuꞌ riiñ tuubaꞌ tir. Orzeꞌ bredz yu Jesuuz nu cugyiꞌy lom. Orzeꞌ nay: ―¿A ru nac ru rey ni de mbecy Israeel? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Orzeꞌ na Jesuuz rab mi yu: ―¿A ndeꞌ coz nu mnii too ub lar nu cugyiꞌr lo̱? Uti ¿a bzat reñaꞌ mbecy ya̱ lor? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Orzeꞌ na Pilato: ―¿Walab gaal rnii toor nu ya̱ naca̱ mbecy Israeel? Laab de mbecy ledz ru nunu de uz zub lo, de yu zeꞌ bguꞌ dey ru ya̱a̱. Na niir la coz bicy ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Orzeꞌ na gaꞌ Jesuuz: ―Ya̱ walab nu riib ica̱ gal mod nu riib ic de rey nu yuꞌ gyishlombecy ii. Gun benu ni, orzeꞌ de mbecy ne̱ chucoo dey par nu cueꞌ guꞌ dey ya̱ yaa de mbecy Israeel. Tees ya̱ walab nu riib ica̱ gal mod nu ricy de rey nu yuꞌ gyishlombecy ii ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Orzeꞌ na Pilato rab yum: ―¿A nac ru tub rey, beni? ―nay. Orzeꞌ na Jesuuz: ―Laab ni gal nu ru mniir nu ya̱ naca̱ rey. Gyiꞌ ndeꞌ nu yapa̱ gyishlombecy ii. Orzeꞌ ii gula̱, gun orzeꞌ rne̱e̱ de coz rishli. Cyu ziꞌl mbecy nu yet lagy de coz rishli, de yu zeꞌ rzuub gyidag yu ne̱ ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Orzeꞌ na Pilato: ―¿Caꞌ zir na de coz rishli? ―nay. Na ornu blazh bdugyiꞌ Pilato lom, orzeꞌ bruuy ich yuꞌ tuubaꞌ tir nu zay lo de mbecy zigy. Orzeꞌ nay rab yu dey: ―Ya̱ wagyapa̱ ni tub la cyi nu bicy mbecy ii ―nay―. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tees de ru ricy cup ru tub cushtom nu ya̱ gla̱a̱ tub pres lat saꞌ ni Pas. ¿Zeꞌ na a rlagy der nu gla̱a̱ rey ni de ru, mbecy Israeel? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Orzeꞌ dela dey dub ruꞌ lay rbrish tiy. Orzeꞌ na dey: ―¡Yu zeꞌ cueꞌ laar yu! ¡Blaa Barrabás! ―na dey. Zeꞌ Barrabás guc yu tub gubaan. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Orzeꞌ Pilato bicy yu mandaar lo de soldad nu cha nu dey Jesuuz nunu bicy yu mandaar nu gaaz dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Orzeꞌ de soldad ptel dey yaa ya gyech. Orzeꞌ bzaa dey tub coron nu briy toom. Orzeꞌ bzuu dey mi tub negy bizat. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Orzeꞌ byagaab dey lom. Orzeꞌ na dey: ―¡Shnu ru, rey ni de mbecy Israeel! ―na dey. Nunu brugyiꞌ rshet dey yalom. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Orzeꞌ bish cya Pilato lo de mbecy zigy tuubaꞌ tir. Orzeꞌ nay rab yu dey: ―Güii der na, ya̱ yap du̱ yu lo der na gun orzeꞌ gad lagy der nu ya̱ wagyapa̱ ni tub la cyi nu bicy yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Orzeꞌ bruꞌña nu dey Jesuuz lo de mbecy zigy. Gabee ri coron gyech zeꞌ toom nunu gabee zum negy bizat zeꞌ. Orzeꞌ na gaꞌ Pilato: ―¡Güii der, ii zu mbecy ii! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na ornu bzaac de yu zub lo ni de uz gal nu de yu nu rña nañ yuꞌ nu driib zily mbecy Ñgyoozh, orzeꞌ brugyiꞌ rbish ti dey. Orzeꞌ na dey: ―¡Cut ruy lo cruuz! ¡Cut ruy lo cruuz! ―na dey. Orzeꞌ na gaꞌ Pilato rab yu dey: ―Laab de ru gua nu der yu nu caa der yu lo cruuz. Zeꞌ ya̱, ya̱ wagyapa̱ ni tub la cyi nu bicy yu ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Orzeꞌ na gaꞌ de mbecy zigy: ―De̱ ya̱ ricy cup de̱ tub leey. Nunu por leey la zeꞌ, yu zeꞌ rlagy ñi gat yu, gun bicy yu ub yu nu nac yu iꞌñ Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na ornu güeñ Pilato riidz zeꞌ, orzeꞌ gudzib zir yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Orzeꞌ bish cyay guꞌy nañ yuꞌ riiñ tuubaꞌ tir. Orzeꞌ bdugyiꞌy lo Jesuuz. Orzeꞌ nay rab yum: ―Zeꞌ ¿ca gaal ledz ru? ―nay. Tees Jesuuz wannii lam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Orzeꞌ na Pilato rab yum: ―Zeꞌ ¿a wanii gaal ru lo̱ beni? ¿A wagad lagy ru nu ya̱ ricy cupa̱ rishbeey nu ca̱a̱ ru lo cruuz? Nunu niꞌ ziꞌl ricy cupa̱ rishbeey nu gla̱a̱ ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Orzeꞌ na Jesuuz rab mi yu: ―Ru rila a̱ꞌ ricy cup ru rishbeey nu la gyicy nur ya̱ zeꞌ benu walab Ñgyoozh briic mi ñii nir. Ndeꞌ nu cyi ily zir zaab yu nu bguꞌ ya̱ yaar gazeꞌ ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nese or la zeꞌ Pilato byub yu tub mod nu laay Jesuuz. Tees de mbecy zigy zeꞌ brish ti nu zir dey yu. Orzeꞌ na dey: ―¡Zeꞌ benu yu zeꞌ glaar yu, orzeꞌ ru a̱ꞌ nac nur César, yu nu riib ic de nasyoong! ¡Gun cyu ziꞌl mbecy nu ricy yu nu nac yu rey, yu zeꞌ zay contr ni César! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ornu güeñ Pilato de riidz zeꞌ, orzeꞌ mniiy nu cha nu dey Jesuuz ich yuꞌ riiñ zeꞌ. Orzeꞌ gusub yu zeꞌ nu riib ic dey, tub lugaar nu la Gabata benu nu riidz hebreo. Riidz zeꞌ yaruuñ: Lugaar zeꞌ nu bduꞌ dey gyitaꞌ lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ndeꞌ tub or widoo tub dzi anzir ni saꞌ ni Pas. Orzeꞌ na Pilato rab yu de mbecy Israeel: ―¡Ii zu rey ni der na! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Orzeꞌ brish ti dey: ―¡Biit yu! ¡Biit yu! ¡Cut ruy lo cruuz! ―na dey. Orzeꞌ na Pilato: ―¿Walab gaal rlagy der nu duta̱ rey ni der lo cruuz? ―nay. Orzeꞌ na de uz zub lo: ―¡De̱ ya̱ a̱ꞌ ricy cup de̱ renaꞌ rey sinu César ziꞌl! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Orzeꞌ Pilato bguꞌy mi yaa dey par nu cut dey mi lo cruuz. Orzeꞌ za nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Orzeꞌ bruu Jesuuz lugaar zeꞌ za num cruuz nu cam lo. Orzeꞌ bruꞌñam tub lugaar nu la Gólgota benu nu riidz hebreo. Riidz zeꞌ yaruuñ: Lugaar ni cyug too añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Zeꞌ pcaa dey mi lo cruuz gal nu cyupaꞌ mbecy. Tub ga dey cay tub laꞌ gaꞌ cuit mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Orzeꞌ Pilato bicy yu mandaar nu zaa dey tub nac letr. Orzeꞌ pcaa dey ñi too cruuz nim. Orzeꞌ letr zeꞌ rniiñ: “Jesuuz, yu nu bruu Nazaret, rey ni de mbecy Israeel”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Orzeꞌ zigy mbecy Israeel psyaꞌ dey de riidz nu rnii de letr zeꞌ gun lugaar zeꞌ nu pcaa dey mi lo cruuz zeꞌ garee ga ruꞌ gyedz. Zeꞌ letr zeꞌ bzaa dey ñi nu riidz hebreo, nu riidz lati̱i̱, gal nu riidz griego. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Orzeꞌ de uz zub lo ni de mbecy Israeel, bish cya dey nu gua niiy lo Pilato. Orzeꞌ na dey: ―Cueꞌ ncaar “Rey ni de mbecy Israeel”, sinu nap zir nu caar “Yu nu rnii nu nac rey ni de mbecy Israeel” ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Orzeꞌ na Pilato: ―Bi cañ ca nu nu cañ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Despuees ornu bi pcaa de soldad Jesuuz lo cruuz, orzeꞌ byash dey shab mi, nunu orzeꞌ tap nac ñii bicy dey nu dugyi tub gay. Orzeꞌ gush dey negy duñ nu ca yeñ mi. Ndeꞌ tub negy nu tub zily la zuñ gal yeñ mi nu gal yeñ gyiꞌ lam ornu bdugab ñi. Sac la zeꞌ nu bdugyib niñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Orzeꞌ na de soldad rab yu losaꞌy: ―Nap zir cueꞌ shaan ñi sinu loon suert ni losaꞌn ben ca na den dugyin ñi ―na dey. Ni guuc ñi par nu byuꞌ niñ gal nu rniiñ lat de riidz ni Ñgyoozh: “Bleez dey shaba̱ lat losaꞌy. Bloo dey suert ni losaꞌy ben ca nay dugyiy negy duñ nu pcaa yeña̱”, rniiñ lat riidz ni Ñgyoozh. De ndeꞌ coz nu bicy de soldad. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na garee zeꞌ nu zu cruuz nu ca Jesuuz, zeꞌ zu ñaam, gal nu bily ñaam, nu Li mñaa Cleofas, gal nu Li biñ nu bruu Magadán. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Orzeꞌ Jesuuz bzaac mi ñaam nu zum garee ga nu ya̱, tub yu nu rsyaꞌ lom. Laab ya̱, yu nu dzi razañ lagy mi. Orzeꞌ nam rab mi ñaam: ―Ña, yu nu zu zeꞌ, bicy yu par tub iꞌñ ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Orzeꞌ nam rab mi ya̱, yu nu rsyaꞌ lom zeꞌ: ―Biñ nu zu zeꞌ, bicy mi par tub ñaar ―nam. Orzeꞌ nese laab or la zeꞌ byasha̱ biñ mñaa zeꞌ nu ya du̱m yu̱ꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na despuees ni de nu ndeꞌ, orzeꞌ Jesuuz bi gud lagy mi nu bi bzaꞌ lom de riiñ nu biid mi. Orzeꞌ par nu gyuꞌ niñ gal nu rniiñ lat de riidz ni Ñgyoozh, orzeꞌ nam: ―Rbigya̱ nis ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Orzeꞌ zeꞌ zu tub teg yuꞌ ñup zii nañ ñi. Orzeꞌ psal dey tub coz nu chayoꞌ nis lo ñup zeꞌ. Pcyiig dey ñi lo tub lo yag nu la hisopo. Orzeꞌ pcaa dey ñi ruꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Orzeꞌ goꞌm ñup zeꞌ. Orzeꞌ nam: ―Byaꞌ loñ ―nam. Orzeꞌ gusab tiily toom. Orzeꞌ gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ndeꞌ tub dzi anzir ni saꞌ ni Pas. Zeꞌ de mbecy zub lo ni de mbecy Israeel walagy dey ca añ lo cruuz dzi sab, dzi nu rzu lagy mbecy, gun dzi zeꞌ, ndeꞌ tub dzi da. Orzeꞌ gua nishbaa dey lo Pilato nu gyicy yu mandaar lo soldad nu cha dey cyicy yu gyiꞌ de yu nu taꞌ lo cruuz zeꞌ par nu gyel gyet de añ zeꞌ lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Orzeꞌ gua de soldad zeꞌ. Pcyicy dey gyiꞌ yu nu bruꞌña dey lo loga la. Gazeꞌ nu pcyicyaꞌ dey gyiꞌ yu nu ca lo cruuz, cruuz nu zu tub laꞌ gaꞌ cuit Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tees ornu bruꞌña dey lo Jesuuz, orzeꞌ bzaac dey nu bi gut mi. Orzeꞌ ndeꞌ nu wancyicyaꞌ dey gyiꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tees tub de soldad mneꞌy tub yag too lyuch lat rit lyush mi. Orzeꞌ lueg la bruu reñ nunu bruu nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Laab ya̱, yu nu rnii de coz nu guc ii, ndeꞌ coz nu bzaac urlo̱ la̱. Nunu rne̱e̱ coz rishli. Laab ya̱ rad lagya̱ nu coz nu rne̱e̱, ndeꞌ coz rishli. Ni mne̱e̱ gun orzeꞌ niꞌ de ru cheña lagy der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dela coz ii ni guuc ñi par nu byuꞌ niñ gal nu rniiñ lat de riidz ni Ñgyoozh zeꞌ nu rniiñ: “Ni tub rit mi wacyicy dey”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Zeꞌ tub seꞌ gaꞌ lat riidz ni Ñgyoozh rniiñ: “De mbecy güii dey lo biñ nu mneꞌ dey yag too lyuch nañ”, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Despuees ni de nu ndeꞌ, orzeꞌ See, tub yu nu bruu Arimatea, bdiiñ yu rishbeey lo Pilato nu cha nuy cuerp ni Jesuuz. Zeꞌ yu zeꞌ niꞌ nac yu tub yu nu rsyaꞌ lom. Tees dze ga rsyaꞌy lom nu nac nu rdzib yu lo de yu zub lo ni de mbecy Israeel. Orzeꞌ Pilato briic yu rishbeey. Orzeꞌ See gua nuy cuerp nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Orzeꞌ Nicodemo, yu nu gua bee riidz nu Jesuuz nu loga la tub rel, yu zeꞌ bruꞌña nuy tub nu rnii gal rup tii cyil coz zguul. Coz zguul zeꞌ ndeꞌ tub lo bid nu la mirra guꞌ can nu tub lo gyez ni yag nu la áloe. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Orzeꞌ laab de yu zeꞌ gua nu dey cuerp ni Jesuuz. Orzeꞌ ptiish dey cuerp zeꞌ negy. Lo negy zeꞌ taꞌ de coz zguul. Bicy dey mod nu rlagy ñi gal nu na cushtom ni de mbecy Israeel ornu rcach dey añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gaab ga zeꞌ nu pcaa dey mi lo cruuz, zeꞌ ri tub nac yag mni. Nunu lat yag mni zeꞌ ca tub gyerbaa cub nu nigul cui la añ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Orzeꞌ zeꞌ bri dey cuerp ni Jesuuz, gun gyerbaa zeꞌ garee ga cañ nunu sñuu ga shuub dzi nu rzu lagy de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na noming, dzi loga ni sman, gabee caas ruꞌ zu, gua Li nu bruu Magadán ruꞌ baa ni Jesuuz. Orzeꞌ bzaac ñi nu bi bdugyash gyitaꞌ nu rsoow ruꞌ baa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Orzeꞌ gush ñi carer yaañ lo Simo̱o̱ Bed, gal nu lo ya̱ tuubaꞌ yu nu rsyaꞌ lo Jesuuz, yu nu dzi razañ lagy mi zeꞌ. Orzeꞌ nañ rab ñi de̱: ―¡Bloo dem cuerp ni Shuaan den nañ gyerbaa za nu dem! Na ¿cyu cuic raso̱o̱ ca bicy dem ñii? ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Orzeꞌ Bed gal nu ya̱ za de̱ za güi̱i̱ ruꞌ baa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Orzeꞌ rup laa de̱ brush de̱ carer za̱, tees ya̱ bded lo̱ lo Bed. Orzeꞌ bruꞌña̱ ruꞌ baa loga la. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Orzeꞌ bzaab tiilya̱ nu bgüi̱i̱ nañ gyerbaa zeꞌ. Zeꞌ bzaaca̱ se sab ziꞌl nim nguaañ. Tees wanchu̱ꞌ nañ gyerbaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Orzeꞌ par icha̱ bruꞌña Simo̱o̱ Bed. Orzeꞌ lueg la guꞌy nañ gyerbaa zeꞌ. Nunu niꞌ ziꞌl bzaac yu sab zeꞌ nguaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nunu bzaacaꞌy negy nu ptiish dey too Jesuuz nguaa reñ ñi nu sab nim nunu nap nach cyup ñi nguaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Orzeꞌ gazeꞌ nu niꞌ ziꞌl guꞌ ga̱ꞌ ya̱; mas laab ya̱ bruꞌña̱ loga la ruꞌ gyerbaa zeꞌ. Orzeꞌ bzaaca̱ de nu ndeꞌ. Orzeꞌ guña lagya̱ nu byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tees de̱ ya̱ gabee nigul gyet lag de̱ cuen lac yaruu de riidz ni Ñgyoozh nu rniiñ nu mi zeꞌ rlagy ñi nu gyabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Orzeꞌ bish cya de̱ ya̱a̱ de̱ par yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Orzeꞌ Li zeꞌ gusuñ ruun ñi par ich roꞌ ni gyerbaa zeꞌ. Lat nu ruun lañ zeꞌ, orzeꞌ bzaab tiily ñi bgüiiñ nañ gyerbaa zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Orzeꞌ bzaac ñi cyup anc nañ gyerbaa zeꞌ. Zu dey negy cacy. Zub dey zeꞌ nu gubish cuerp ni Jesuuz. Tub yu zub yu zeꞌ nu gubish toom. Zeꞌ tuubaꞌy zub yu par zeꞌ nu gubish gyiꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Orzeꞌ de anc zeꞌ nay rab yu Li: ―Biñ mñaa, ¿la gyiꞌ, lagu ruun ru? ―na dey. Orzeꞌ na Li: ―Gun za nu mbecy Shuaana̱, nunu wagad lagya̱ ca bicy dem mi ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Na ornu blazh mniiñ de riidz zeꞌ, orzeꞌ bish cyañ bgüiiñ par ich ñi. Orzeꞌ bzaac ñi nu zu Jesuuz. Tees wangyuꞌ loñ ti laab mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Orzeꞌ na Jesuuz rab mi ñii: ―Biñ mñaa, ¿la gyiꞌ, lagu ruun ru? ¿Cyu ryub ru? ―nam. Orzeꞌ mnii tooñ nu ndeꞌ tub mbecy nu ricy riiñ lat de ya mni nu nash zeꞌ. Orzeꞌ nañ: ―Zeꞌ benu ru gua nur cuerp nim, orzeꞌ mnii lo̱ ca bicy ru ñii, gun orzeꞌ ya̱ cha gyi̱ cuerp zeꞌ ―nañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Orzeꞌ na Jesuuz rab mi ñii: ―¡Li! ―nam. Orzeꞌ bish cyañ bgüiiñ lom. Orzeꞌ mnii nuñ mi nu riidz hebreo: ―¡Rabuni! ―nañ. Riidz zeꞌ, ndeꞌ yaruuñ moscuel. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Orzeꞌ na Jesuuz rab mi ñii: ―Bzaan yaa ya̱, gun gaal zi nigul gya̱ lo Ñgyoozh uza̱. Tees na yaa niir lo de bicya̱ nu bi gya̱ ga̱ꞌ lo biñ nu nac uza̱, gal nu uz der: lo biñ nu nac Ñgyoozh ne̱, gal nu Ñgyoozh ni de ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Orzeꞌ Li nu bruu Magadán gush nez ñi yaa tooñ rishlo de yu nu rsyaꞌ lom. Mniiñ lo dey nu bzaac ñi Shuaan den. Nunu mnii gaꞌñ lo dey de coz nu mniim looñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na ornu bi becheñ ni laab dzi loga ni sman zeꞌ, orzeꞌ byatublaazh de yu nu rsyaꞌ lom nañ tub yuꞌ. Nunu nicy psoow dey roꞌ nu nac nu rdzib dey lo de yu zub lo ni de mbecy Israeel. Orzeꞌ Jesuuz bruꞌñam gusum lat dey. Orzeꞌ nam rab mi dey: ―¡Gyel ri zu briñ lat der! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ornu blazh mniim riidz zeꞌ, orzeꞌ blyuum yaam lo dey nunu blyuu gaꞌm rit lyush mi lo dey. Orzeꞌ tonaꞌ la bet lagy dey nu bzaac dey Shuaan den. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Orzeꞌ na gaꞌ Jesuuz rab mi dey tuubaꞌ tir: ―¡Gyel ri zu briñ lat der! Gal nu Ñgyoozh uza̱ bzuu nez mi ya̱ yapa̱ gyishlombecy ii, ndeꞌ nu niꞌ ziꞌl ya̱ gzuu neza̱ der char lat de mbecy nu yuꞌ gyishlombecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Orzeꞌ blaam lo dey. Orzeꞌ nam: ―Na rica̱ Espiriit Yon ni Ñgyoozh nu gac num der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Benu de ru gyicy sulagy ru cyi ca na tub mbecy, orzeꞌ Ñgyoozh gyicy sulagy mi niy. Zeꞌ benu wayicy sulagy der ni dey, orzeꞌ niꞌ Ñgyoozh wayicy sulagy mi ni de yu zeꞌ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na lo trocyup de yu nu rsyaꞌ lom, tub yu ndeꞌ Tomaas, yu nu rnii dey cuach. Orzeꞌ yu zeꞌ sac yu lat dey ornu bruꞌña Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Despuees, orzeꞌ deꞌ zir de losaꞌy nu rsyaꞌ lom byoo dey rishloy coz nu bzaac dey. Orzeꞌ na dey: ―Bi bzaac de̱ Shuaan den ―na dey. Tees Tomaas nay rab yu dey: ―Tees benu wazaca̱ zeꞌ nu guud güii ni yaam nu bzub bey nunu benu waneꞌ mbiza̱ zeꞌ nu guud güii zeꞌ nim, nunu benu waneꞌ ya̱a̱ zeꞌ nu guud güii ni rit lyush mi, orzeꞌ rila wayeña̱ lagya̱ de riidz nu rnii der ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na ornu bzaꞌ shuñ dzi na, orzeꞌ byatublaazhaꞌ de yu nu rsyaꞌ lom laabaꞌ nañ yuꞌ zeꞌ. Orzeꞌ gazaꞌ Tomaas riy lat dey. Nunu ni ziꞌl noow nicy de roꞌ ni yuꞌ nu yuꞌ dey. Orzeꞌ bruꞌña Jesuuz gusum lat dey. Orzeꞌ nam: ―¡Gyel ri zu briñ lat der! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Orzeꞌ nam rab mi Tomaas: ―Tomaas, mneꞌ mbiz ru lo rya̱a̱ ii, nunu güii la na ya̱a̱. Bzaab yaar lo̱ nunu mneꞌ yaa ruꞌ rit lyusha̱. Cueꞌ gac ru mbecy nu wacheña lagy, sinu guc mbecy nu zeña lagy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Orzeꞌ na Tomaas rab yum: ―¡Ru nac ru Shuaana̱ nunu nac ru Ñgyoozh ne̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Orzeꞌ na Jesuuz rab mi yu: ―¿A guña lagy ru na par nu bzaac lar ya̱? Dzi ni de mbecy nu rzeña lagy sinu wacsac lay ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesuuz zañ tonaꞌ la nusuriidz bicy mi lo rgüii la de yu nu rsyaꞌ lom nunu de nu ndeꞌ wanca gaꞌñ lo gyicy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tees de nu nii pcañ lo gyicy ii gun orzeꞌ cheña lagy der nu Jesuuz nac mi Mesías, biñ nu ca lo cuen nu cyid co mbañ mbecy, nunu nac mi iꞌñ Ñgyoozh. Nunu par nu nac nu gyicy cup der consuel lom orzeꞌ cui mbañ der. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Na despuees ni de nu ndeꞌ, orzeꞌ bruꞌña Jesuuz lo̱ de̱ ya̱ yu nu rsyaꞌ lom tuubaꞌ tir ruꞌ nisyudoo ni Tiberias. Orzeꞌ i mod guc ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Orzeꞌ zeꞌ yuꞌ tublaazh la be de yu nu rsyaꞌ lom. Zeꞌ zu Simo̱o̱ Bed, nu Tomaas, yu nu rnii dey cuach, gal nu Natanael, yu nu bruu Caná, tub gyedz nu ri lo yu ni Galilea, gal nu ya̱ nu bicya̱ Santiag, de̱ ya̱ nu nac iꞌñ Zebedeo, gal nu se cyup mbecy nu rsyaꞌ lo Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Orzeꞌ na Simo̱o̱ Bed rab yu deꞌ zir de̱: ―Ya̱ cha̱ guuz bel ―nay. Orzeꞌ na dey rab yu Bed: ―Niꞌ de̱ ya̱ cha̱ du̱ ru ―na dey. Orzeꞌ brush nez de̱ za̱. Orzeꞌ guꞌ de̱ nañ tub barc. Gua la rel byub de̱ bel tees ni tub ma wangad ma. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na ornu bi brugyiꞌ nu bi yad nu rzaꞌ yu, orzeꞌ bruꞌña Jesuuz gusub mi ruꞌ nisyudoo. Tees de̱ ya̱, yu nu rsyaꞌ lom, wangyuꞌ lo de̱ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Orzeꞌ nam rab mi de̱: ―Der yu feñ, ¿a wangad la bel ni der? ―nam. Orzeꞌ mne̱e̱ de̱: ―Rila wangad ma ―mne̱e̱ de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Orzeꞌ na gaꞌ Jesuuz rab mi de̱: ―Orzeꞌ mneꞌ der gyish zeꞌ par bee barc gun orzeꞌ gad ma ni der ―nam. Orzeꞌ mneꞌ de̱ gyish zeꞌ lo nis, nunu par nu tonaꞌ la zañ bel guꞌ ma nañ gyish ne̱ de̱, orzeꞌ ni wagacaꞌ nu loo de̱ ñii lo nis nu cshup de̱ ñii nañ barc. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Orzeꞌ ya̱, yu nu rsyaꞌ lo Jesuuz nu dzi razañ lagy mi zeꞌ, mne̱e̱ lo Bed: ―¡Laab Jesuuz, biñ nu nac Shuaan den! ―Mne̱e̱. Laab güeñ la Simo̱o̱ Bed nu laab mi zeꞌ Shuaan den, orzeꞌ bzuy shab yu gun a̱ꞌ zuy shab yu. Orzeꞌ bet lay lo nis zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Orzeꞌ deꞌ zir de̱ ya̱, losaꞌy, gal ri ziꞌl de̱ nañ barc rgayu̱ tuñ la de̱ gyish nu yuꞌ bel zeꞌ. A̱ꞌ zet zaab barc lo nis. Nu rnii tub gaynal gaal metr nu zet nu zaab ñi lo nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na ornu bru̱u̱ de̱ nañ barc par lo yu bigy, orzeꞌ bzaac de̱ nu bi nguaa gyi nunu riib tub bel loñ. Nunu nguaa gaꞌ gyishtily. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Orzeꞌ na Jesuuz rab mi de̱: ―Da nu der la be bel, bañ nu sa bdub der na ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Orzeꞌ Simo̱o̱ Bed guꞌy nañ barc. Bduꞌ yaay gyish nu yuꞌ de bel zeꞌ. Bgaꞌ yu tuñ lay ñi za nuy ñi par ruꞌ nisyudoo. Dza la nañ ñi yuꞌ du ub bel ily la. Yuꞌ tub gaynal nu̱ zub chon bel zeꞌ nac ma. Mas tonaꞌ la bel zañ yuꞌ nañ gyish zeꞌ, tees wanshaañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Orzeꞌ na Jesuuz rab mi de̱: ―Gyeed der gun gyicy ru siily ―nam. Tees ni tub la de̱ wanric de̱ baloor nu ndugyi̱ꞌ de̱ lom ben cyu nac mi, gun gud lagy de̱ nu laab mi, ndeꞌ Shuaan de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Orzeꞌ Jesuuz bechaꞌm lo de̱. Orzeꞌ bduꞌ yaam gyishtily zeꞌ. Briic mi ne̱ de̱. Orzeꞌ niꞌ ziꞌl bicy num de bel zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Orzeꞌ ndeꞌ tir chon nu bzaac de̱ Jesuuz despuees ornu bi byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na ornu blazh bicy de̱ siily, Jesuuz nam rab mi Bed: ―Simo̱o̱, iꞌñ Jonás, ¿a rca zir ru ya̱, gazeꞌ gal mod nu rca deꞌ zir de yu ii ya̱? ―nam. Orzeꞌ na Bed: ―Laab Shuaana̱, ru rad lagy ru nu rca̱ ru ―nay. Orzeꞌ na gaꞌ Jesuuz: ―Orzeꞌ mña de mbecy nu nac shily ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Orzeꞌ mnii gaꞌm tir cyup la loy. Orzeꞌ nam: ―Simo̱o̱, iꞌñ Jonás, ¿a rca zir ru ya̱, gazeꞌ gal mod nu rca deꞌ zir de yu ii ya̱? ―nam. Orzeꞌ na gaꞌ Bed rab yum: ―Laab Shuaana̱, ru rad lagy ru nu rca̱ ru ―nay. Orzeꞌ na gaꞌ Jesuuz: ―Orzeꞌ mña de mbecy nu nac shily ne̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Orzeꞌ na gaꞌm rab mi yu tir chon la: ―Simo̱o̱, iꞌñ Jonás, ¿a rcar ya̱? ―nam. Orzeꞌ tonaꞌ la bicy shni Bed gyiꞌ nu bdugyiꞌm chon tir loy ornu nam: “¿A rcar ya̱?” nam. Orzeꞌ nay rab yum: ―Shuaana̱, ru rad lagy ru dela coz. Nunu rad lagy ru nu ya̱ rca̱ ru ―nay. Orzeꞌ na gaꞌ Jesuuz. ―Mña de mbecy nu nac shily ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ya̱ rishli rne̱e̱ lor nu lat nu gufeñ ru, bzur shab ru nunu guar ca ziꞌl lugaar nu rlagy ru char. Tees ornu gyaguush ru, orzeꞌ zaab yaar lo tuubaꞌ mbecy. Orzeꞌ yu zeꞌ gzuuy ru shab ru. Orzeꞌ yu zeꞌ cha nuy ru lugaar zeꞌ nu walagy ru char ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na ornu mnii Jesuuz de riidz zeꞌ, ndeꞌ par nu gyicy mi nu gabe lac mod gruu zac gyel lily ni Ñgyoozh nu nac nu gat Bed. Orzeꞌ na gaꞌm rab mi Bed: ―¡Da ca icha̱! ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na ornu bish cya Bed bgüiiy par ich yu, orzeꞌ bzaac yu ya̱, yu nu dzi razañ lagy Jesuuz zeꞌ. Laab ya̱ yu nu bzub cuit mi ornu bicy de̱ che du̱m, nunu bdugyi̱ꞌ lom: “Shuaana̱, ¿ca na yu nu cush cya ich ru zeꞌ?” ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na ornu bzaac Bed ya̱, orzeꞌ bdugyiꞌy lo Jesuuz. Orzeꞌ nay: ―Shuaan de̱, se yu re, ¿la zac yu? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Orzeꞌ na Jesuuz rab mi yu: ―Zeꞌ benu ya̱ rlagya̱, orzeꞌ yu re gabee mbañ yu ornu yapa̱ tuubaꞌ tir. Ru, ¿la nu ricy ñi nir? Nomaas nu da ca ziꞌl icha̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Orzeꞌ bzu riidz lat dela de yu nu rsyaꞌ lom nu ya̱ wata̱. Tees walab nu mnii Jesuuz nu wata̱. Coz nu mniim ndeꞌ: “Zeꞌ benu ya̱ rlagya̱, orzeꞌ yu re gabee mbañ yu ornu yapa̱ tuubaꞌ tir. Ru, ¿la nu ricy ñi nir?”, mniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nunu laab ya̱, yu nu mnii de riidz ii. De riidz ii pca̱a̱ lo gyicy; nunu rad lagy de̱ nu ndeꞌ coz rishli nu mne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesuuz zañ zir coz bicy mi. Nunu benu tub ga la de coz zeꞌ ncaañ lo gyicy, ya̱ rze̱e̱ nu ni wal gyishlombecy nu chuꞌ de gyicy zeꞌ, benu nca delañ.");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Shi Tioj, gyicy nu pca̱a̱ loga la, lo gyicy zeꞌ pca̱a̱ dela coz nu bicy Jesuuz gal nu de coz nu blyuum nese nu bzuub mi gyiꞌ de riiñ nu bicy mi ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","gal pshuub la dzi nu gup mi gyibaa. Anzir nu gyam gyibaa, orzeꞌ nu nac Espiriit Yon ni Ñgyoozh mniim lo de yu nu pcuim nu gac aposht de coz nu gyicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Lat cyuu dzi despuees ornu bi byabañ mi nu gut mi, zañ tir bruu zac mi lo dey. Nu mod zeꞌ briic mi nu gad lagy dey nu mbañ mi. Lat nu bruu zac mi, orzeꞌ bzat mi gyel gubier ni Ñgyoozh lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ornu gabee rded nu ruꞌm dey, orzeꞌ mniim lo dey nu cueꞌ ruuy Jerusaleeng. Gazeꞌ nu nam rab mi dey: ―Cuez der gashtal cuic la Ñgyoozh biñ nu bi mniim nu segur la cuic mi ni der. Ya̱ bi mne̱e̱ lo der nu ni gyicy mi, gun ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Waa rishli nu nis ziꞌl briib nis yu mbecy, tees na de ru gal nu bgo nis too der ornu bzuꞌ nis ru nu nis, niꞌ ziꞌl sñuu ga gyet Espiriit Yon ni Ñgyoozh lat der nu cyiiñ num espiriit ni der ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na lat nu yuꞌ tublaazh dey nuy mi, orzeꞌ bdugyiꞌ dey lom. Gazeꞌ nu na dey: ―Shuaan de̱, ¿a na pshuub tiem nu gzu nap ru lat de mbecy Israeel gal nu bzuuñ gulas? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Gazeꞌ nu na Jesuuz rab mi dey: ―Walab cuen ni de ru nu gad lagy ru ca dzi o ca tiem nu gyicy Ñgyoozh de coz nu bzeeñ mi nu gac cuen ni ub ziꞌl mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tees ornu Espiriit Yon nim gyet mi lat der, orzeꞌ gyicy mi nu cyiiñ der nu gzat ru ya̱ lat de mbecy nu yuꞌ Jerusaleeng, lat de mbecy nu yuꞌ dutuub la lo yu ni Judea, lat de mbecy nu yuꞌ dutuub la lo yu ni Samaria, nunu dela lugaar nu byazet zir ni gyishlombecy ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Despuees ornu blazh mnii Jesuuz de ndeꞌ, orzeꞌ lo rgüii la dey wes nañ mi yam gyibaa. Byoow mi lat tub nac za yam. Orzeꞌ wangacaꞌ zac dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lat nu yuꞌ dey taꞌ loy baa rgüiiy nu yam, orzeꞌ bruu zac cyup mbecy shab caacy gusuy lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Gazeꞌ nu nay rab yu dey: ―Der mbecy Galilea, ¿lagu ni yuꞌ der rgüiir baa? Laab Jesuuz bruum lat der yaam gyibaa. Tees niꞌ ziꞌl mod gal nu bzaac der yam niꞌ ziꞌl mod zac der ornu cyid mi tuubaꞌ tir ―na de anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bicy nu la Bicy ni Ya Oliva, zeꞌ yuꞌ dey. Bicy zeꞌ gaab ga byeeñ ñi nu Jerusaleeng, tub la be metr nu ca lo cuen ni leey ni dey nu rac rza mbecy sab dzi nu rzu lagy mbecy Israeel. Gazeꞌ nu gush nez dey yay par lat gyedz Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ornu bri dey lat gyedz, orzeꞌ gup dey gal shily cyup ni yuꞌ zeꞌ, zeꞌ nu rzuꞌ dey. Zeꞌ ri Bed, Santiag, Waa, Ndrees, Lip, Bartol, Mateo, Santiag iꞌñ Alfeo, Simo̱o̱, yu nu nash leey Caneneo, nu Judas, bicy Santiag. Dela de yu zeꞌ yuꞌy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nunu zaab rnii nu laa dey Ñgyoozh nu tub ziꞌl shcab: gazaꞌ de biñ mñaa yuꞌm lat zeꞌ, gazaꞌ Li ñaa Jesuuz, nunu gazaꞌ de bicy Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na ornu bded la be dzi, orzeꞌ byatublaazh dey. Byatublaazh nu rnii tub gaynal zub gal de mbecy ni Crisht. Orzeꞌ wes su Bed. Gazeꞌ nu nay rab yu dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Der bicy na, Espiriit Yon ni Ñgyoozh bi mniim lo Dabi nu caay de coz nu bicy Judas, yu nu blyuu Jesuuz lo de yu nu gua num pres. Rlagy ñi gac ñii gal nu bi cañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Niꞌ Judas guc yu tub losaꞌ de aposht. Gazaꞌy bdugyiy riiñ, laab riiñ nu bdugyi de̱ ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tees despuees nu bicy yu coz cyi nu bguꞌy Jesuuz yaa de yu nu rzi lagy lom, orzeꞌ laab nu tiñ nu byash niy zeꞌ wiiy tub lugaar zeꞌ nu biit yu ub yu. Orzeꞌ bet lag yu tub lugaar gya. Bzu tooy lo yu. Orzeꞌ briich ñi nañ yu. Orzeꞌ bruu za dela coz nu yuꞌ nañ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Orzeꞌ ornu dela de mbecy nu yuꞌ Jerusaleeng gud lagy dey coz nu guc lugaar zeꞌ, orzeꞌ bloo la dey ñi Lugaar ni Reñ. Benu nu riidz dey, orzeꞌ Acéldama lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Gun Dabi bi pcaay coz nu gac lugaar ni Judas lo libr ni Salmo, zeꞌ nu mniiy: Yuꞌy gyac ñi gal nu na tub lugaar ub zi nu sac la mbecy. Orzeꞌ waruu su gaꞌ la mbecy nu cyiiñ yu nañ ñi, nay. Orzeꞌ nay tuubaꞌ lugaar ni libr zeꞌ: Orzeꞌ tuubaꞌ mbecy gyub ic yu riiñ nu bdugyiy, na Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Na lat na ii yuꞌ mbecy nu gusa nu de ub na dub laa lat nu gusa dun Shuaan na Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Brugyiꞌ rded nu dey de ub na nese dzi nu briic Waa nu zu nis mi, gashtal dzi nu yaa lam gyibaa. Na rlagy ñi nu chuꞌ ca na tub dey lat na par nu niiy nu bzaac den nu byabañ mi ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Orzeꞌ bloo su dey cyup mbecy. Tub yu lay See, laab yu zeꞌ lay Barsabás, nunu laab yu lay Jusht. Bloo su dey yu zeꞌ nu tuubaꞌ mbecy nu la Matías. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gazeꞌ nu brugyiꞌ rnii nu dey Ñgyoozh. Orzeꞌ na dey: ―Ñgyoozh, ru rad lagy ru la na lardoo dela mbecy. Na lo cyup de yu ii, blyuu lo̱ de̱ ca na dey bi pcuiir ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","par nu gac yu aposht. Chuꞌy lo Judas. Gun Judas nu nac nu bicy yu coz a̱ꞌ nap, orzeꞌ bzeeñ yu riiñ nu zuy par nu yay lugaar zeꞌ nu byap yu gyay ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Gazeꞌ nu bloo dey suert ben ca na de yu zeꞌ chuꞌy. Orzeꞌ Matías bruu suert niy nu chuꞌy lat de trotub aposht zeꞌ. Yu zeꞌ guꞌy lugaar ni Judas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ornu pshuub dzi ni saꞌ nu la Pentecostés, dela de mbecy ni Crisht yuꞌ dey tublaazh la tub seꞌ ziꞌl. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Orzeꞌ derepent la brugyiꞌ rzigy baa. Gal rac nu yad tub bi ily ni rac. Nunu dutuub la nañ yuꞌ zeꞌ nu nguaa dey bzigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Orzeꞌ bruu zac gal nu na lyush gyi na bruu zac. Gul ñii tub ga la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Orzeꞌ dela dey gutib ic zaꞌ la Espiriit Yon ni Ñgyoozh dey, nunu brugyiꞌ rnii dey riidz reñaꞌ mbecy. Dub gal lac na riidz nu briic Espiriit Yon ni Ñgyoozh nu nii dey dub ni mod mniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tiem zeꞌ zañ mbecy Israeel nu zu shcab nu nac de coz ni Ñgyoozh yuꞌy Jerusaleeng. Zañ lugaar ni gyishlombecy bruu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ornu bzigy zeꞌ, orzeꞌ tonaꞌ la mbecy zigy byatublaazh yu. Nunu guton la dey yuꞌy, gun tub ga la de mbecy ni Crisht zeꞌ brugyiꞌ rniiy riidz de mbecy nu bdeꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dela mbecy bdzoꞌw laa dey, nunu za nu la ic dey. Orzeꞌ nay: ―¡Güii ñuu! Zeꞌ ¿a walab mbecy Galilea nac dela mbecy nu rnii ii? ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Zeꞌ ¿lac guc nu rac rnii dey de riidz guledz tub ga la den? ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Gun ii yuꞌ mbecy nu bruu zañ lugaar. Yuꞌ mbecy nu bruu Partia, yu nu bruu Media, yu nu bruu Elam, yu nu bruu Mesopotamia, yu nu bruu Judea, yu nu bruu Capadocia, yu nu bruu Ponto, yu nu bruu Asia, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","yu nu bruu Frigia, yu nu bruu Panfilia, yu nu bruu Egipto, yu nu bruu de lugaar ni Libia nu yuꞌ par lo Cirene. Dela zeꞌ bruu de mbecy nu yuꞌ ii. Nunu gazaꞌ de mbecy nu bruu Rom nu rcyiiñ laab ii. Yuꞌ de yu nu nac mbecy Israeel nese nu gul laa dey, nunu yuꞌ gaꞌ de yu nu byac mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nunu gazaꞌ mbecy nu bruu Creta, mbecy nu bruu Arabia. ¡Dela zeꞌ bruu tub nac ga den, tees dela den reñ na coz ily ni Ñgyoozh nu riidz na! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dela mbecy bdzoꞌw laa dey, nunu guton la dey yuꞌy. Se nu rgugyiꞌ ziꞌl dey lo losaꞌy yuꞌy: ―Zeꞌ ¿lac yaruu de nu nii? ―rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tees yuꞌ gaꞌ mbecy canu rgubdzaa dey. Orzeꞌ nay: ―¡Ni ricy dey gun rzugy yu! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Orzeꞌ wes su Bed nu deꞌ zir de trotub aposht gazeꞌ nu brugyiꞌ ye la rniiy. Orzeꞌ nay: ―De ru mbecy Israeel, gal nu dela de ru mbecy nu yuꞌ gyedz Jerusaleeng, rlagy ñi gad lagy der de coz nu rac ii, nunu nap bzuub gyidag der de coz nu ne̱e̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","De mbecy ii walab nu rzugy dey gal nu rnii too de ru. Gyiib gaa zi or napor yuꞌn na. Walab i or gzugy mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sinu na ricy yac ñi coz nu pcaa Joeel, yu nu mnii por cuen ni Ñgyoozh. Ñgyoozh nam: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ornu bi yad lazh tiem, ya̱ rica̱ Espiriit ne̱ ni de lo la mbecy. Orzeꞌ dela de yu nguzh ni dey, gal nu dela de fiñ nguzh ni dey, gnii dey por cuen ne̱. De yu feñ gyicya̱ nu deꞌ lo dey de coz nu gac. Nunu de yu bel lat pcaal dey rica̱ nu gad lagy yu de coz nu gac. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Laab tiem zeꞌ rica̱ Espiriit Yon ne̱ ni yu nu ricy coz nu rne̱e̱, nunu rica̱ꞌm ni de biñ mñaa nu ricy de coz nu rne̱e̱. Orzeꞌ gnii dey por cuen ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ya̱ gyicya̱ zañ coz ily baa. Zeꞌ lo yu gyicya̱ coz par nu gad lagy mbecy la tiem. Shu reñ; grib gyi; nunu grib dzeeñ nan. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gyet cow lo doo. Zeꞌ lo beey gyet ña gal na reñ. Dela ndeꞌ gac ñii anzir nu shuub dzi nu bi pcui̱ par nu gyicy ya̱ gyel fushtiz ne̱. Dzi zeꞌ tonaꞌ la dzi ily. Nunu dzi zeꞌ tonaꞌ la cyit gac. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nunu dela mbecy nu nish baa lo̱ nu gloo mbaña̱ dey, de yu zeꞌ gruu mbañ yu, nam. Ni pcaa Joeel gulas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’De ru mbecy Israeel, bzuub gyidag der de coz nu ne̱e̱ na. Ñgyoozh naal la briic mi nu gad lagy der nu Jesuuz, biñ nu pcyiiñ Nazaret, bduꞌ gyim riiñ ni Ñgyoozh nu nac de coz ily nu bicy mi lat de ru. Ñgyoozh bicy mi nu bicy Jesuuz zañ coz ily. Bicy mi nusuriidz. Bicy mi zañ coz par nu gad lagy der cyu nac mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tees Ñgyoozh nil nese gulas bi mne̱ꞌ ic mi, coz nu gyicy mi. Nunu bi gud lagy mi nu gyet lag mi yaa der. Orzeꞌ de ru gua nu der mi pres. Gazeꞌ nu bicy der nu de mbecy nu wagyicy yac de leey ni Ñgyoozh biit dey mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tees Ñgyoozh bicy mi nu byabañ mi. Bloom mi lat de mbecy gut, gun zeꞌ nu yuꞌ mbecy gut wac soow ñi lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gun Dabi laab mi bzat yu ornu pcaay: Ya̱ rad lagya̱ nu zaab zu gala Ñgyoozh lo̱. Zub mi par yaa be̱e̱, gun orzeꞌ mas lac ruꞌ wagyicy deet mbecy nuy ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ndeꞌ nu tonaꞌ la gusu cyit lagya̱, nunu mne̱e̱ riidz nu rnii mbecy nu zu cyit lagy. Nunu drish lo̱ lo Ñgyoozh nu nac cuerp ne̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gun ru wazaan ru nu gyiyeeñ lardo̱o̱ lat de mbecy gut. Ni wazaan ru nu gadz cuerp ni mbecy yon nir. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ru mniir lo̱ mod nu gyicya̱ par nu cui mbaña̱. Ya̱ tonaꞌ la chesu cyit lagya̱, gun nac nur ya̱, pcaa Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Der bicy na, naal la za de riidz ii. Gyitoo bel ni den Dabi gut yu. Orzeꞌ pcach dey yu. Nunu baa niy rzac den ñi mas gal dzi na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tees Dabi guc yu tub mbecy nu mnii por cuen ni Ñgyoozh. Gud lagy yu nu Ñgyoozh mniim nu waded la nu lat ca na tub nez yu, ruu biñ nu pcuim nu gac Shuaan den gal nu ub yu guc yu rey nu byub ic den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ndeꞌ nu Dabi gud lagy yu coz nu gyicy Ñgyoozh. Mniiy nu biñ nu pcuim nu co mbañ de mbecy nim gat mi. Orzeꞌ gyabañ mi. Mniiy nu lardoom wayiyeeñ ñi lugaar zeꞌ nu ryeeñ de mbecy gut, nunu mniiy nu cuerp nim wadz ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mi zeꞌ laab Jesuuz. Bicy Ñgyoozh nu byabañ mi, nunu de̱ ya̱ bzaac urlo̱ la̱ de ndeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na Ñgyoozh bicy mi nu zub mi zeꞌ nu zub biñ zub lo zir par dela. Zub mi par yaa beem. Orzeꞌ Ñgyoozh Uz mi briic mi Espiriit Yon nim ni mi zeꞌ. Gal nu mniim, ni bicy mi. Na dela coz nu rzac der ii, nunu dela coz nu reñ der ii, dela nii bruuñ gal lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Gun Dabi walab ub yu gup yu gyibaa gal nu gup Jesuuz. Sinu ub lay mniiy ornu nay: Ñgyoozh nam rab mi Shuaan na: Bzub par yaa be̱e̱, seꞌ mbecy zub lo zir, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Lat nu gyicya̱ nu gyicy ru gan de losaꞌ yuur, nam, na Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Ndeꞌ nu dela mbecy Israeel rlagy ñi nu gad lagy dey nu Jesuuz, biñ nu biit dey lo cruuz, Ñgyoozh bicy mi nu nac mi Shuaan den, nunu nac mi biñ nu bloo sum nu co mbañ den ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ornu güeñ de mbecy de riidz zeꞌ, orzeꞌ tonaꞌ la bicy dey sentiir nañ lardooy. Gazeꞌ nu na dey rab yu Bed nu deꞌ zir de aposht: ―Der bicy na, ¿la coz rlagy ñi nu gyicy de̱? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Orzeꞌ na Bed rab yu dey: ―Mne̱ꞌ der dela de cyi nu ricy ru, nunu dela der bzu nis der par nu gabe nu nac der mbecy ni Jesucrisht, gun orzeꞌ gyicy sulagy Ñgyoozh de cyi der, nunu gazeꞌ nu cuic mi Espiriit Yon nim ni der. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gun Ñgyoozh bi mniim nu segur la cuic mi Espiriit Yon nim ni de ru nu ni de iꞌñ ru nu chuꞌ par lo, nu ni dela de mbecy nu yuꞌ zet, de yu nu bi blosum ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dela ndeꞌ mniiy, nunu zañ zir riidz mniiy lo dey. Briic yu consef ni dey. Nunu mniiy lac gyicy dey. Orzeꞌ i mod mniiy: ―Bicy der nu glar ni cashtig nu cuic Ñgyoozh ni de mbecy a̱ꞌ nap nu yuꞌ na ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Orzeꞌ de yu nu “O” mnii ni de riidz nu mnii Bed, dela dey bzu nis yu. Dzi zeꞌ chon miily mbecy brugyiꞌ ricy cup yu consuel lo Jesuuz, reñ de yu nu nil bi ricy cup consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Orzeꞌ dela dey fert la zu dey shcab nu nac de coz nu rlyuu de aposht. Nunu yatublaazh dela dey nu ro nuy losaꞌy riidz. Nunu yatublaazh dela dey ricy yu che nu losaꞌy gal mod nu bzeeñ Crisht. Nunu yatublaazh dey nii nuy Ñgyoozh. De ndeꞌ coz nu zaab bicy la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dela de mbecy za nu ic dey nu nac de coz nu bicy de aposht, gun de aposht bicy dey zañ coz ily. Nunu zañ nusuriidz bicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Dela de yu nu ricy cup consuel lo Crisht zeꞌ tonaꞌ la nap byap riidz ni dey nu losaꞌy. Nunu dela dey rlew yu de coz nu cyiiñ lat de losaꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rut dey de coz nu yuꞌ niy. Orzeꞌ rlew dey ñuu ga tiñ nu losaꞌy dub gal lac tant nu cyiiñ ni tub ga dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Orzeꞌ de dzi la yatublaazh dey nañ yuꞌ nu driib zily mbecy Ñgyoozh, nunu yatublaazhaꞌ dey yuꞌ losaꞌy nu ricy dey che tublaazh gal mod nu bzeeñ Crisht. Nap zu lagy dey. Nunu dub gal ri lagy dey bicy yu de ndeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ryabic dey gyel mbecy ni Ñgyoozh. Nunu dela reñaꞌ mbecy, nap yuꞌ nuy dey. Nunu Ñgyoozh tub dzi ga rcyaañ zir mi mbecy nu ricy cup consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tub dzi Bed nu Waa rca dey zay par ic tublaazh la. Za dey zeꞌ nu zub yuꞌ nu driib zily mbecy Ñgyoozh. Bi yuꞌn tub gyiib chon or gudze. Ndeꞌ or nu rnii nu mbecy Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Orzeꞌ tub mbecy nu nil coj la ornu gul, de dzi la rza nu mbecy yu. Rzuub dey yu gyeroꞌ nu la Roꞌ Cyit Na. Laab roꞌ ni yuꞌ nu driib zily dey Ñgyoozh. Rza nu dey mbecy coj zeꞌ rzuub dey yu zeꞌ par nu rgyiiñ yu gun lo de mbecy nu rzuꞌ nañ yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na ornu bzaac yu Bed nu Waa nu se nu chuꞌ ziꞌl dey nañ yuꞌ zeꞌ, orzeꞌ bdiiñ yu gun lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Orzeꞌ rgüii dey loy. Gazeꞌ nu na Bed rab yuy: ―Bgüii lo̱ de̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Orzeꞌ mbecy coj zeꞌ mbi la bgüiiy lo dey, gun psaꞌ lagy yu nu la zi coz cuic dey niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tees Bed nay rab yuy: ―Rila sac tiñ ne̱ nu rica̱ nir, tees coz nu ricy cupa̱ gac rica̱ nir. Nu rishbeey ni Jesucrisht, biñ nu pcyiiñ Nazaret, ya̱ rne̱e̱ du̱ ru wes su nunu bza ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Gazeꞌ nu bduꞌ yaa Bed yaa bee mbecy coj zeꞌ pshes suy yu. Orzeꞌ lueg la byanap lab yu, nunu byanap yeñ gyiꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Orzeꞌ rzab lay wes suy, nunu brugyiꞌ lay rzay. Gazeꞌ nu guꞌ nuy dey nañ yuꞌ nu driib zily mbecy Ñgyoozh. Rza lay, nunu yes nañ yu, nunu brugyiꞌ ryabic yu gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Orzeꞌ dela de mbecy zigy bzaac dey nu rac rzay, nunu ryabic yu gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Se nu za nu ziꞌl ic dey, nunu bdzoꞌw laa dey nu nac coz nu guc nu yu zeꞌ, gun byuꞌ lo dey yu nu laab yu nu rzub rgyiiñ gun gyeroꞌ nu la Roꞌ Cyit Na ni yuꞌ nu driib zily mbecy Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Zeꞌ mbecy nu guc coj zeꞌ waglaa gaꞌ la yaay Bed nu Waa. Nunu dela de mbecy za nu la ic dey. Nunu orzeꞌ lueg la byatublaazh dey par ruꞌ tub coredoor ni yuꞌ nu driib zily mbecy Ñgyoozh. Coredoor zeꞌ lañ Coredoor ni Salomoong. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ornu bzaac Bed de ndeꞌ, orzeꞌ nay rab yu dela mbecy: ―Der mbecy Israeel, ¿lagu dzi za nu ic der nu nac nii? ¿Lagu dzi rgüii der lo̱ de̱? Walab nu dzi rcyiiñ de ub ziꞌl de̱, nunu walab nu dzi nac du̱ de̱ Ñgyoozh, walab ndeꞌ nu rac rza mbecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñgyoozh, biñ nu guc nu de gyitoo bel ni den, Abraham, Isaac nu Jacob, laab mi zeꞌ ricy zily mi Iꞌñ mi Jesuuz tiem na. De ru bguꞌ der mi yaa de mbecy nu riib ic. De ru mnii zi der nim mas tiem nu ngulagy Pilato nlaay mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mi zeꞌ biñ yon, biñ nu sac cyi, tees de ru mneꞌ der mi. Lugaar nu nii der nu ndulaa mi zeꞌ, ca tub yu nu rut mbecy mnii der nu dulaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Orzeꞌ biit der mi zeꞌ, biñ nu rbic gyel mbañ. Tees Ñgyoozh bicy mi nu byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Laab nu nac Jesuuz zeꞌ, byanap gyiꞌ mbecy ii, gun de̱ ya̱ ricy cup de̱ consuel lom. Nunu yu ii, yu nu nil rzac der, nunu yuꞌ lo der yu. Nu nac nu ricy cup de̱ consuel lom, ndeꞌ nu byac nap lay lo rgüii la dela der. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Der bicy na, ya̱ rad lagya̱ nu de ru gal nu de yu nu riib ic ni der, ornu biit der Jesuuz, rishli gaal wangyet lag nap der cuen coz nu bicy ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ni guc gun byuꞌ ni de coz nu gulas bi mnii Ñgyoozh nu nac de yu nu mnii por cuen nim. Mniim nu Mesías, biñ nu ca lo cuen nu co mbañ mbecy rlagy ñi nu zac zim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ndeꞌ nu na mneꞌ der dela de coz cyi nu ricy ru. “O” mnii der ni Ñgyoozh, gun orzeꞌ cyib mi dela cyi der. Gun orzeꞌ gyicy mi nu cyid tiem nu gad nu zu lagy der nañ lardoor como nac num der. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nunu zeed mi Jesuuz. Mi zeꞌ Mesías, biñ nu nil nese gulas bi bloo sum par de ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mi zeꞌ rlagy ñi cyiiñ mi gyibaa gal shuub la dzi nu gzu nap Ñgyoozh dela coz gal nu bi mnii de mbecy nu bloo sum nu mnii por cuen nim gulas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Gun Moisees nay rab yu de gyitoo bel ni den: “Ñgyoozh, Shuaan den, gzeed mi tuubaꞌ mbecy nu nii por cuen nim gal nu bzeed mi ya̱. Mbecy zeꞌ laab lat losaꞌ ziꞌl der gruuy. Rlagy ñi zuub gyidag der dela coz nu gniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Cyu ziꞌl mbecy nu wazuub gyidag ni mbecy nu nii por cuen nim zeꞌ, dela dey zu chum yu, nunu nit lom yu”, na Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Dela de yu nu mnii por cuen ni Ñgyoozh, gaal zi gush ñi nese Samueel, nu deꞌ zir dey, dela de yu zeꞌ bi mnii dey coz nu rac tiem na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yaa de ru gyiyeeñ dela gyel nap nu mnii Ñgyoozh nu segur la cuic mi: de coz nu mniim lo de yu nu mnii por cuen nim nu nii dey. Nunu yaa de ru gyiyeeñ dela gyel nap ni trat nu bicy Ñgyoozh num de gyitoo bel ni den, ornu nam rab mi Abraham: “Nu nac nez ru cyid gyel nap lat dela mbecy nu yuꞌ gyishlombecy”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Orzeꞌ ornu bicy mi nu byabañ Iꞌñ mi, nu loga la bzeed mi mi zeꞌ nu cyid mi lat de ru nu gyicy mi coz nap num der. Ni bicy mi gun orzeꞌ tub ga la der gruur lo de coz cyi nu ricy ru ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lat nu zu Bed nu Waa, rniiy lo de mbecy zigy, orzeꞌ bruꞌña de uz ni de mbecy Israeel, nunu bruꞌña de yu nu rña yuꞌ nu driib zily mbecy Ñgyoozh, nunu bruꞌña de mbecy saduceo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pchaꞌ ic dey, gun blyuu Bed ni de mbecy nu Jesuuz byabañ mi. Nunu ndeꞌ cuic ñi nu gad lagy de mbecy nu gyabañ dela mbecy gut. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Orzeꞌ bduꞌ yaa dey Bed. Mneꞌ dey yu nañ yuꞌ gyiib. Orzeꞌ gal zeꞌ byeeñ yu gal tuubaꞌ dzi, gun bi gudze. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Zeꞌ zigy mbecy nu güeñ de riidz nu mnii Bed, bicy cup dey consuel lo Jesuuz. Orzeꞌ byañ dey. Nu rnii tub gaay miily dey byac yu orzeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Orzeꞌ tuubaꞌ dzi byatublaazh zigy mbecy zub lo ni de mbecy Israeel. Yuꞌ de yu nu riib ic de mbecy Israeel. Yuꞌ gaꞌ de yu bel ni dey. Yuꞌ de yu rlyuu leey ni mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Byatublaazh dey Jerusaleeng nu Anás, yu nu riib ic de uz ni de mbecy Israeel, nu Caifás, nu Waa, nu Alejandro, nu deꞌ zir de yu nu nac famil ni yu nu riib ic de uz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Orzeꞌ bzuu nez dey mbecy nu cha tee dey Bed nu Waa. Orzeꞌ bzuub dey yu lat dey. Orzeꞌ na dey rab yuy: ―¿Lac guc nu rac ricy der nii?, o ¿cyu briic rishbeey nu ni gyicy der? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Orzeꞌ Espiriit Yon ni Ñgyoozh riib ic zaꞌ lam nañ lardoo Bed. Orzeꞌ nay rab yu dey: ―De ru, yu nu riib ic ledz na, gal nu de ru yu bel, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","benu rgugyiꞌ der par nu nac coz nap nu bicy de̱ nu mbecy coj zeꞌ, nunu par nu gad lagy der lac mod byac yu, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","orzeꞌ ya̱ rica̱ nu gad lagy de ru gal nu dela mbecy Israeel nu nu nac rishbeey ni Jesucrisht, biñ nu pcyiiñ Nazaret, byac yu ii, nunu ndeꞌ nu zuy lat dela der ii na la. Laab mi zeꞌ biñ nu pcaa der lo cruuz. Tees Ñgyoozh bicy mi nu byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesuuz nam gal nu na tub gyitaꞌ. Zeꞌ de ru nar gal na biryu. Gyitaꞌ zeꞌ mneꞌ der ñii, tees na byac ñi gyitaꞌ zub lo zir. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nu nac Jesucrisht ziꞌl gac ruu mbañ den, gun Ñgyoozh wansat mi ni tubaꞌ la mbecy gyishlombecy ii lo den nu co mbañ de ub na ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Orzeꞌ de mbecy nu zu riiñ zeꞌ tonaꞌ la za nu ic yu, ornu bzaac dey nu wachib la Bed nu Waa mniiy, mas nac dey mbecy cualcyer la. A̱ꞌ yuꞌ lo dey gyicy. Tees de mbecy nu zu riiñ zeꞌ byuꞌ lo dey yu nu nac yu mbecy nu gusa nu Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tees wangacaꞌ nii dey gun bzaac dey mbecy nu byac zeꞌ. Zuy nu Bed nu Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Orzeꞌ bzuu nez dey Bed nu Waa nu ruu dey lat de mbecy zeꞌ. Orzeꞌ brugyiꞌ ro nu dey losaꞌy riidz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Orzeꞌ na dey: ―¿Lac gyicy tun dey? Dela mbecy nu yuꞌ Jerusaleeng gad lagy dey nu bicy dey nusuriidz zeꞌ nunu wac niin nu walab ni. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tees par nu cueꞌ gad lagy zir mbecy de riidz nu rnii dey, rlagy ñi nu gyicy den mandaar lo dey nu bee na ziꞌl par lo rila cueꞌ gaꞌ nii dey nu nac Jesuuz ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Orzeꞌ bredz dey Bed nu Waa. Orzeꞌ mnii dey lo dey nu rila cueꞌ gaꞌ nii dey, nunu cueꞌ lyuu dey nu nac Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Orzeꞌ na Bed nu Waa rab yu dey: ―Gush der shcab ben ca na nu nap zir par lo Ñgyoozh: a nu zuub gyidag de̱ ni de ru uti nu zuub gyidag de̱ nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gun wac checa̱ de̱ nu zat de̱ de coz nu bzaaca̱, gal nu de riidz nu güeña̱ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Orzeꞌ fert zir mnii dey lo Bed nu lo Waa nu cueꞌ ni gyicy dey. Orzeꞌ blaa dey yu. Wangad la mod nu mbic dey cashtig ni dey, gun dela mbecy ryabic dey gyel mbecy ni Ñgyoozh par nu nac de coz nu bzaac dey, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","gun mbecy nu byac nu mod ni nusuriidz zeꞌ, yu zeꞌ bded cyuu ñaꞌn yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cuanzir nu blaa dey Bed nu Waa, orzeꞌ bish cya gaꞌ dey zay lo de losaꞌy. Orzeꞌ briic dey nu gad lagy de yu zeꞌ de coz nu mnii de uz ni de mbecy Israeel, gal nu de yu bel ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ornu güeñ dey ndeꞌ, orzeꞌ mnii nu dey Ñgyoozh tublaazh la. Orzeꞌ na dey rab yum: ―Shuaan de̱, ru nac ru biñ nu psaꞌ lagy baa nu gyishlombecy, nu nisyudoo, nu dela coz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ru mniir ornu Espiriit Yon nir pcaam gyitoo bel ne̱ de̱ Dabi, yu nu bicy dela coz nu mniir, ornu mniiy: ¿Lagu dzi guzi lagy de mbecy nu walab mbecy Israeel? ¿Lagu bicy dey mod ton par nu gyicy yu gan Ñgyoozh? ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","De rey nu de yu nu zu riiñ bi bzu lily dey nu chucooy nu Ñgyoozh. Byatublaazh dey nu zay contr nim, nunu zay contr ni biñ nu bloo sum, na Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Gun laab Herodes nu Poncio Pilato byatublaazh dey gyedz ii nuy de mbecy nu walab mbecy Israeel, gal nu de mbecy Israeel par nu cha dey contr ni Jesuuz. Jesuuz nac mi biñ Yon nu bicy yac dela coz nu ru mniir. Jesuuz nac mi Mesías, biñ nu ca lo cuen nu co mbañ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tees byatublaazh dey gun bicy yu dela coz nu bi bloo ic ru nu gac. Ru bloo ic ru ndeꞌ, gun ru ricy cup ru mod nu ni gyicy ru, nunu ndeꞌ mod nu rlagy ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Orzeꞌ ru, Ñgyoozh, bduꞌ cuen ni nu rnii zi dey ne̱ de̱, nunu doo baloor ne̱ de̱ par nu wadzib la de̱ ne̱e̱ de riidz nu ruu lor. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gun orzeꞌ gyicy ru nu gzac dela mbecy nu dzi coz ily gyicy ru. Ricy yac ru de mbecy rat, nunu ricy ru nusuriidz nu nac Jesuuz, biñ Yon nu bicy yac dela coz nu mniir ―na dey rab yu Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ornu blazh mnii nu dey Ñgyoozh, orzeꞌ bicy mi nu briib duru lugaar zeꞌ nu byatublaazh dey zeꞌ. Orzeꞌ Espiriit Yon nim gutib ic zaꞌ lam nañ lardoo tub ga la dey. Orzeꞌ brugyiꞌ nu wachib la dey rniiy de riidz nu bruu lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Dela de mbecy nu bicy cup consuel lo Crisht bicy dey tub ziꞌl shcab. Ni tub la mbecy wangyicy yu nu de coz niy, ndeꞌ coz par ub ziꞌl yu. Orzeꞌ dela coz nac ñii ni delay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nunu fert la bzat de aposht nu byabañ Crisht lo de mbecy. Nunu Ñgyoozh briic mi de gyel nap ni dela dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sac ni tub mbecy lat dey nu ricy falt la coz niy. De yu nu mbish yu ni, biit yu yu niy. Zeꞌ de yu nu zub yuꞌ, biit yu yuꞌy. Orzeꞌ gua nu dey tiñ nu guud niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Orzeꞌ bzeeñ dey ñi yaa de aposht. Orzeꞌ bleez dey de tiñ zeꞌ ni de mbecy dub gal lac ga lagy tub ga dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ni mod bicy tub mbecy nu la See. Yu zeꞌ nez Leví. Gul yu Chipre, tees de aposht bloo la dey yu Bernabee. Riidz zeꞌ yaruuñ: Yu nu rbic consuel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mbish tub nac yu niy. Orzeꞌ biit yu yu zeꞌ niy. Orzeꞌ gua zeeñ yu tiñ yaa de aposht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Zeꞌ zu tub mbecy nu la Ananías. Mñaay lam Safira. Orzeꞌ biit dey tub nac yu niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pcaa chuy tub nac tiñ par ub yu. Orzeꞌ bzeeñ yu deꞌ zir tiñ zeꞌ yaa de aposht. Nunu gud lagy mñaay dela coz nu bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Orzeꞌ na Bed rab yuy: ―Ananías, walab seꞌñ nu bzaan ru nu nuras gyicy yu nu guur Espiriit Yon ni Ñgyoozh ornu pcaa chur ñuu tiñ ni yu nir par ub ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Anzir nu cut ru yu zeꞌ, orzeꞌ nac ñii coz nir. Na ornu biit ru ñii, niꞌ ziꞌl tiñ nu guud nir zeꞌ nac ñii coz nir. Orzeꞌ ¿lagu ni mnii toor nu bguur? Ru bguur Ñgyoozh. Walab mbecy bguur ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Orzeꞌ cuanzir nu güeñ Ananías de riidz zeꞌ, orzeꞌ wes saa lay lo yu, nunu gut lay. Orzeꞌ dela mbecy, ornu gud lagy dey nu gut yu, dela dey gudzib yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Orzeꞌ wes su la be yu feñ. Orzeꞌ ptiish dey yu negy. Orzeꞌ za nu dey yu nu cach yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na ornu bi bi bded nu bzaꞌ chon or, orzeꞌ bruꞌña mñaay tees wangad lagy mi la guc. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Orzeꞌ na Bed rab yum: ―Mnii ben ¿a rishli a ndeꞌ dela tiñ nu guud ornu biit der yu nir? ―nay. Orzeꞌ nam: ―Laab ndeꞌ dela tiñ nu guud ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Orzeꞌ na Bed rab yum: ―¿Lagu bicy der preb Espiriit Yon ni Ñgyoozh nu ñgyeer? Bzuub gyidag rzigy gyiꞌ de yu nu yeed nu gua cach ñgyeer. Bi yeed dey roꞌ ii, nunu niꞌ ziꞌl cha nu dey ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Orzeꞌ lueg la wes saa gaꞌ lam garee la lo Bed. Orzeꞌ gut lam. Orzeꞌ bruꞌña de yu feñ zeꞌ. Bzaac dey nu mbish mi gut mi. Orzeꞌ za nuꞌ la dey mi. Pcach dey mi laab cuit ñgyeem. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Orzeꞌ dela de mbecy ni Crisht nu deꞌ zir de mbecy, ornu güeñ dey nu ni guc, orzeꞌ tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na orzeꞌ de aposht bicy dey zañ nusuriidz, nunu bicy dey zañ coz nu za nu ic mbecy. Orzeꞌ dela mbecy nu ricy cup consuel lo Crisht byatublaazh dey tub lugaar nu la Coredoor ni Salomoong. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ni tub la de mbecy nu a̱ꞌ ricy cup consuel lo Crisht walagy yu chuꞌy lat dey, tees dela mbecy gyedz mnii nap yu ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Orzeꞌ dzi zir ryañ de mbecy nu ricy cup consuel lo Ñgyoozh: tant yu gyeey nunu tant biñ mñaa. Orzeꞌ tonaꞌ la mbecy zigy byac. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Par nu nac de coz nu bicy de aposht, orzeꞌ ndeꞌ nu de mbecy gua nu dey de mbecy rat gyernez. Orzeꞌ brish dey yu lo nuun nu lo daꞌ, gun ornu ded Bed ben a wal mas ñuu sheñ yu de mbecy rat zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nunu tonaꞌ la bruꞌña de mbecy zigy nu yuꞌ de gyedz nu ri gaab ga Jerusaleeng. Gua nu dey de mbecy rat, nunu gua nu dey de mbecy nu bicy ni nuras. Nunu dela dey byac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Orzeꞌ gusaap lagy yu nu riib ic de uz ni mbecy Israeel, gal nu de yu nu nac nuy, de yu nu nac nu leey ni de mbecy saduceo. Orzeꞌ bicy dey tub ziꞌl riidz nu shiñ gyicy nu dey de aposht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Orzeꞌ pshet yaa dey de aposht. Gua nu dey yu yuꞌ gyiib. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tees laab rel zeꞌ bruꞌña tub anc ni Ñgyoozh. Orzeꞌ pshaal yu roꞌ ni yuꞌ gyiib zeꞌ. Orzeꞌ blooy dey par ich yuꞌ. Orzeꞌ nay rab yu dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gua der zeꞌ nu driib zily de mbecy Ñgyoozh. Orzeꞌ shaal der lo de mbecy de riidz nu rnii lac mod gyicy de mbecy ni Crisht ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Orzeꞌ de aposht bicy yac dey gal nu mnii anc zeꞌ. Or bzaꞌ yu tuubaꞌ dzi, orzeꞌ gua dey zeꞌ nu zub yuꞌ nu driib zily de mbecy Ñgyoozh. Orzeꞌ brugyiꞌ rlyuu dey ni de mbecy. Na yu nu riib ic de uz nu deꞌ zir losaꞌy bredz dey de yu bel nu zu riiñ ni junt zub lo nu gyatublaazh dey. Orzeꞌ bzeed dey raso̱o̱ lo de yu nu rña roꞌ gyiib zeꞌ nu coy de aposht nu cha nuy yu lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tees ornu bruꞌña de yu nu za nu raso̱o̱ roꞌ gyiib, orzeꞌ wangyadaꞌ de aposht ni dey. Orzeꞌ bish cya gaꞌ dey yay lo de mbecy nu yuꞌ junt zeꞌ. Orzeꞌ nay rab yu dey: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Ornu bruꞌña de̱ roꞌ gyiib, orzeꞌ noow nicy lañ. Nunu yuꞌ de yu nu rña roꞌ zeꞌ. Tees ornu pshaal de̱ roꞌ, orzeꞌ bzaac de̱ nu sacaꞌ ni tubaꞌ la mbecy zeꞌ nañ ñi ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na ornu güeñ yu nu riib ic de yu nu rña yuꞌ zeꞌ, nunu ornu güeñ de uz zub lo, orzeꞌ brugyiꞌ rash dey shcab nu la zi coz yad ñi nu gac par lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Gazeꞌ nu bruꞌña tub mbecy. Orzeꞌ nay rab yu dey: ―Güii der, de mbecy nu mneꞌ der nañ yuꞌ gyiib, yuꞌy loliꞌ ni yuꞌ nu driib zily den Ñgyoozh. Rlyuu dey ni de mbecy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Orzeꞌ tub yu nu riib ic de mbecy nu rña yuꞌ nu driib zily mbecy Ñgyoozh nu de yu nu rña yuꞌ zeꞌ gua tee dey de aposht. Gua nu dey yu lo de yu nu zu riiñ ni junt zeꞌ. Tees walab por fers la gua nu dey yu, gun rdzib dey lo de mbecy zigy nis shet dey gyitaꞌ too dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Orzeꞌ bicy dey nu guꞌ de aposht nañ yuꞌ zeꞌ. Bzu dey yu par zeꞌ nu taꞌ lo de mbecy nu yuꞌ junt zeꞌ. Orzeꞌ yu nu riib ic de uz nay rab yu de aposht: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―De̱ ya̱ fert pca̱a̱ de̱ der nu cueꞌ lyuu der ni de mbecy nu nac mbecy zeꞌ, tees ¡na güii la bicy der! De ru ptush las der riidz, nunu rlyuu der dutuub la Jerusaleeng. Nunu de ru rlagy ru gyicy ru nu de̱ ya̱ yuꞌ falt ne̱ nu gut yu ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Orzeꞌ na Bed nu deꞌ zir de aposht: ―Rlagy ñi nu zuub gyidag de̱ ni Ñgyoozh walab ni mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ñgyoozh, biñ nu briib zily de gyitoo bel ni den, bicy mi nu byabañ Jesuuz, biñ nu biit der ornu pcaa der mi lo cruuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Orzeꞌ Ñgyoozh bicy zily mi mi zeꞌ. Gusub mi par yaa bee Ñgyoozh. Byac mi biñ nu riib ic, nunu biñ nu rboo mbañ de mbecy, gun orzeꞌ gad mod nu neꞌ de mbecy Israeel de coz cyi nu ricy yu. Nunu gyicy sulagy Ñgyoozh de cyi nu ricy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","De̱ ya̱ rne̱e̱ de coz nu bzaac de̱ lo de mbecy. Ni ricy de̱ nu nac Espiriit Yon ni Ñgyoozh, biñ nu briic Ñgyoozh ni de yu nu rzuub gyidag nim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na ornu güeñ de yu nu yuꞌ junt zeꞌ de riidz nu mnii de aposht, orzeꞌ tonaꞌ la guzi lagy dey. Orzeꞌ ngulagy dey ñgyut yu de aposht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tees lat de mbecy zeꞌ ri tub yu nu la Gamaliel. Guc yu mbecy fariseo. Guc yu tub mbecy nu rlyuu leey ni Ñgyoozh. Nunu dela mbecy pca lagy dey loy. Orzeꞌ yu zeꞌ wes suy lat de mbecy nu yuꞌ junt zeꞌ. Orzeꞌ pcaay de mbecy nu co chu dey de aposht tub miiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Orzeꞌ nay rab yu de mbecy nu yuꞌ junt zeꞌ: ―De ru mbecy Israeel, cuidad der nu nac coz nu rlagy ru gyicy nur de mbecy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Rad lagy der nu bi rac tiem bruu zac Teudas. Mniiy nu nac yu tub mbecy lily. Nunu tub tap gaynal mbecy gusa nu dey yu. Tees biit mbecy yu, nunu brush las de yu nu gusa nuy. Orzeꞌ guca de coz nu bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Orzeꞌ despuees bruu zacaꞌ Judas, yu nu gul Galilea. Tiem zeꞌ bruu ñaꞌn de mbecy. Niꞌ yu zeꞌ gusa nu mbecy yu. Tees biitaꞌ mbecy yu, nunu brush lasaꞌ de yu nu gusa nuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Orzeꞌ niꞌ ziꞌl rac na. Orzeꞌ ya̱ rdo̱o̱ rishlo der nu cueꞌ shiñ gyicy nu der de yu ii. Blaa der dey, gun benu coz nu rboo ic ub ziꞌl dey o benu coz nu ricy dey, ndeꞌ coz ni mbecy ziꞌl, orzeꞌ nit loñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tees benu ndeꞌ coz nu bruu lo Ñgyoozh, orzeꞌ rila wac nit lo der ñii. Cuidad der nis cha der contr ni Ñgyoozh ―nay. Orzeꞌ de mbecy nu yuꞌ junt zeꞌ bicy yac dey nu consef ni Gamaliel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Orzeꞌ bredz dey de aposht. Gazeꞌ nu bgaaz dey yu. Gazeꞌ nu pcaa dey yu nu rila cueꞌ gaꞌ nii dey nu nac Jesuuz. Gazeꞌ nu blaa dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Orzeꞌ bruu de aposht lo de mbecy nu guꞌ junt zeꞌ. Orzeꞌ tonaꞌ la bet lagy dey, gun Ñgyoozh bicy mi nu byap dey nu gzac ziy, nunu byap dey nu bruu gyel mbecy ni dey nu nac Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nunu de dzi la zaab rlyuu la dey ni de mbecy zeꞌ nu zub yuꞌ nu driib zily de mbecy Ñgyoozh, gal nu nañ yuꞌ ni mbecy, nunu zaab rshaal la dey lo de mbecy de riidz nu sac ni Jesuuz, biñ nu ca lo cuen nu co mbañ mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Laab tiem zeꞌ, ornu bi ryañ zir de mbecy nu ricy cup consuel lo Crisht, orzeꞌ de mbecy Israeel nu rnii griego nu de mbecy Israeel nu rnii hebreo, riidz guledz, bdzaꞌ dey ni losaꞌy. De mbecy nu rnii griego mnii dey nu wagyicy paa mbecy ornu rgyeez dey de coz nu gow byud nu yuꞌ lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Orzeꞌ trocyup de aposht zeꞌ bredz dey de mbecy nu ricy cup consuel lo Crisht. Orzeꞌ na dey rab yu dey: ―Walab seꞌñ nu checa̱ de̱ nu ne̱e̱ de riidz ni Ñgyoozh par nu lyu̱u̱ de̱ ni der nu lac mod gyicy nu der de coz nu gow de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Orzeꞌ de ru bicy na, laab lat der bloo su gagy yu gyeey, de yu nu rca lagy der lo. Rlagy ñi mbecy nu riib ic zaꞌ la Espiriit Yon ni Ñgyoozh nañ lardoo, nunu rlagy ñi mbecy nu yuꞌ shcab ni. Orzeꞌ de̱ ya̱ du̱ꞌ de̱ riiñ zeꞌ yaa dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Zeꞌ de̱ ya̱, dub laa tiem ne̱e̱ du̱ de̱ Ñgyoozh, nunu shaal de̱ de riidz nim ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Orzeꞌ dela mbecy bet lagy dey riidz nu mnii de aposht zeꞌ. Orzeꞌ bloo su dey Shteb, tub mbecy nu tonaꞌ la fert ricy cup consuel lo Crisht. Nunu riib ic zaꞌ la Espiriit Yon ni Ñgyoozh nañ lardooy. Gush lañ: Lip, nu Proc, nu Nicanor, nu Timón, nu Parmenas, nu Lyaa, tub mbecy nu gul Antioquía. De uz yu walab mbecy Israeel, tees ub yu gush yu leey ni mbecy Israeel. Dela yu zeꞌ bloo su dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Orzeꞌ de mbecy gua nu dey yu lo de aposht. Orzeꞌ de aposht briib yaay too tub ga dey, nunu mnii nu dey Ñgyoozh nu nac dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Orzeꞌ zaab drush las la de riidz ni Ñgyoozh. Orzeꞌ tonaꞌ la byañ de mbecy nu ricy cup consuel lo Crisht Jerusaleeng. Gashtal zigy de uz ni de mbecy Israeel bicy cup dey consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Orzeꞌ yu nu la Shteb zeꞌ, tonaꞌ la nap bicy nu Ñgyoozh yu nunu dzi rcyiiñ yu nu gyicy yu coz nu rlagy mi. Bicy yu zañ nusuriidz, nunu zañ coz nu za nu ic mbecy bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tees yuꞌ la be mbecy nu gua contr niy. Yuꞌ mbecy nu bruu lat de mbecy nu rza nañ yuꞌ nu rsyaꞌ de mbecy riidz ni Ñgyoozh, yuꞌ nu la Yuꞌ ni De Mbecy nu Bdulaa Yaa. Yuꞌ mbecy nu bruu Cirene, yuꞌ mbecy nu bruu Alejandría, yuꞌ mbecy Cilicia. Yuꞌ gaꞌ mbecy nu bruu lo de yu nu la Asia. Orzeꞌ brugyiꞌ ro zi dey riidz nu Shteb. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tees Espiriit Yon ni Ñgyoozh pshaal mi shcab ni Shteb. Par nu tonaꞌ la nap mniiy, wangacaꞌ la nii de mbecy nu radzay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Orzeꞌ briish dey ni mbecy par nu riib yu cyi fals ic Shteb. Orzeꞌ na de mbecy zeꞌ: ―De̱ ya̱ güeña̱ nu Shteb rniiy riidz nu za contr ni Moisees, nu riidz nu za contr ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ni mod pchaꞌ dey ic de mbecy. Pchaꞌ dey ic de yu bel, nunu pchaꞌ dey ic de yu nu rlyuu leey ni Ñgyoozh. Orzeꞌ gua dey lo Shteb pshet yaa dey yu. Gua nu dey yu lo de yu nu yuꞌ junt zub lo zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Gazeꞌ nu gua nu dey la be de mbecy nu briib cyi fals ic Shteb. Orzeꞌ na dey: ―Mbecy ii zaab rnii lay riidz nu za contr ni yuꞌ yon nu driib zily den Ñgyoozh, nunu rniiy riidz nu za contr ni leey nu bzeeñ Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gun güeñ de̱ nu mniiy nu Jesuuz, tub mbecy nu pcyiiñ Nazaret, tily yu yuꞌ yon ni Ñgyoozh nin, nunu rchaay de cushtom nu bzeeñ Moisees ni de gyitoo bel ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Orzeꞌ dela mbecy nu nguaa lat junt zeꞌ bgüii dey lo Shteb. Orzeꞌ bzaac dey nu rgüiiy gal nu rgüii tub anc. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yu nu riib ic de uz ni de mbecy Israeel nay rab yu Shteb: ―¿A laab rishli? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Orzeꞌ na Shteb rab yu de mbecy zigy: ―De ru bicya̱ gal nu de ru uza̱ bzuub gyidag der ne̱. Ñgyoozh, biñ nu zily zir nac, bruu zac mi lo gyitoo bel nin Abraham, lat nu pcyiiñ yu Mesopotamia, anzir nu chay cyiiñ yu Harán. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Orzeꞌ nam rab mi yu: “Bzeeñ famil nir, nunu bzeeñ ledz ru. Gua lo yu nu ya̱ lyu̱u̱ lor”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Orzeꞌ bruu Abraham lo de yu ni Caldea. Zay cyiiñ yu Harán. Na ornu gut uz yu, orzeꞌ Ñgyoozh bicy mi nu yad yu de lugaar ii cyiiñ yu. Ledz na ii pcyiiñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tees Ñgyoozh wancuic mi ni tub lugaar ganiy. Ni ñuu miiñ yu wancuic mi niy. Tees mniim nu segur la cuic mi de lugaar ii ganiy. Mniim nu segur la nu de lugaar ii gac niy, nunu gac ni de nez yu par lo, mas tiem zeꞌ sac iꞌñ yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nii coz nu mnii Ñgyoozh lo Abraham: “De nez ru rcyiiñ yu tub lugaar nu walab ledz yu. Gac yu moz ni mbecy por fers la. De mbecy lugaar zeꞌ tonaꞌ la shiñ gyicy nu dey yu lat tap gaynal naꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tees ya̱ rica̱ cashtig ni de yu nu shiñ gyicy zeꞌ. Gazeꞌ nu gruu de nez ru lugaar zeꞌ, nunu ca dey ya̱ ii”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Orzeꞌ Ñgyoozh bicy mi tub trat nu Abraham, nunu mniim nu rlagy ñi ca beey nu la sircunsision cuerp ni de yu gyeey par nu gabe nu nac nuy trat zeꞌ. Orzeꞌ gazeꞌ nu gul Isaac, iꞌñ yu. Ornu bzaꞌ shuñ dzi nu gul Isaac, orzeꞌ pcaay beey sircunsision cuerp niy. Orzeꞌ despuees Isaac pcaay beey sircunsision cuerp ni iꞌñ yu Jacob. Jacob pcaay beey sircunsision cuerp ni trocyup iꞌñ yu: laab lo de yu zeꞌ guch trocyup nac nez de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Tees de iꞌñ yu bicy saap lagy dey ich bicy yu See. Orzeꞌ biit dey yu. Orzeꞌ mbecy wii dey yu. Byac yu moz por fers la ni tub mbecy Egipto. Tees Ñgyoozh gusa num yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nunu Ñgyoozh bloo nap mi yu lat dela gyel deet nu bzac yu. Ornu bruꞌñay lo Faraón, yu nu riib ic Egipto, orzeꞌ Ñgyoozh bicy mi nu gud lagy Faraón nu nap yu, nunu yuꞌ shcab niy. Orzeꞌ Faraón bduꞌy riiñ yaay nu gyub ic yu lo dela yu ni Egipto, nunu gyub ic yu nañ yuꞌy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Na biid cubiñ lo dela de yu ni Egipto nu lo de yu ni Canaán. Tonaꞌ la bzac zi mbecy nu nac cubiñ zeꞌ. Wangad coz nu gow de gyitoo bel ni den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ornu Jacob güeñ yu nu yuꞌ trig Egipto, bzuu nez yu de iꞌñ yu, de yu nu nac gyitoo bel ni den, nu cha dey zeꞌ. Ndeꞌ byaj loga la nu gya dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Byaj cyup See mniiy lo de bicy yu cyu nac yu. Orzeꞌ gud lagy Faraón cyu nez nac See. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Orzeꞌ See bzeed yu raso̱o̱ lo uz yu, nunu lo dela famil niy. Mniiy nu cha dey gashtal Egipto. Chon gal ruub gaay dey nac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Orzeꞌ Jacob guay Egipto. Zeꞌ gut yu nu dela too bel ni den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Orzeꞌ despuees gua nu dey cuerp ni See, gal nu cuerp ni Jacob par Siquem. Pcach dey ñi nañ tub gyeeg ni blyuu nu wii Abraham par la be pezh lo de nez Hamor. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Na or bi pshuub dzi nu gyicy yac Ñgyoozh ni de riidz nu mniim lo Abraham, orzeꞌ tonaꞌ la byañ de nez na Egipto. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Orzeꞌ reñaꞌ mbecy gutib ic yu Egipto. Yu zeꞌ wanchuꞌ loy See. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Bguuy de nez den. Shiñ bicy nuy dey. Pcaay de nez den por fers la nu neꞌ dey de mdoo gyeey nu sa gul ni dey, gun orzeꞌ gat yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Orzeꞌ tiem zeꞌ gul Moisees. Tonaꞌ la bet lagy Ñgyoozh yu. Nañ chon beey bguul dey yu yuꞌ uz yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ornu bloo chu dey yu, orzeꞌ byash iꞌñ Faraón yu. Bicy iꞌñ ñiy. Bguul ñiy gal iꞌñ lañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Orzeꞌ de mbecy blyuu dey ni Moisees dela shcab lily ni de mbecy Egipto. Orzeꞌ Moisees byac yu tub mbecy nu tonaꞌ la lily na. Coz ily bicy yu, nunu coz ily mniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Na ornu Moisees yuꞌy tub ñaꞌn cyuu, orzeꞌ mnii tooy nu cha güiiy la ricy de losaꞌy, de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Orzeꞌ bzaac yu nu shiñ ricy tub mbecy Egipto nu tub losaꞌy. Orzeꞌ pcay yu. Orzeꞌ bicy gal gay nu mbecy Egipto zeꞌ. Orzeꞌ biit yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Psaꞌ lagy yu nu de losaꞌy ñgyet lag dey cuen nu Ñgyoozh gyicy mi nu laab yu co nap yu de losaꞌy yaa de mbecy Egipto. Tees wangyet lag dey cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na tuubaꞌ dzi bzaac yu nu rucoo tub mbecy Israeel laab nu losaꞌy. Bicy peey nu ñgyicy yu nu ganap lagy dey lo losaꞌy. Orzeꞌ nay rab yu dey: “¡Bzub gyidag der! De ru bicy ru losaꞌr. ¿Lagu shiñ ricy nur losaꞌr?” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Orzeꞌ yu nu shiñ ricy nu losaꞌ zeꞌ bzuub yaay Moisees par cuit yu. Orzeꞌ nay rab yuy: “Se cyu la briib riiñ ic ru nu gyub ic ru de̱ ya̱, nunu par nu gri beer ne̱ de̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Zeꞌ na, ¿a cutaꞌr ya̱ gal nu biit ru mbecy Egipto zeꞌ naag?” nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","’Na ornu güeñ Moisees ndeꞌ na, orzeꞌ bruu chuy Egipto. Orzeꞌ gua yat yu. Guay pcyiiñ yu lo de yu nu la Madián. Zeꞌ pchelaay. Orzeꞌ gul cyup iꞌñ gyeey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Na ornu bzaꞌ cyuu ñaꞌn, orzeꞌ bruu zac tub anc loy lat lyush gyi nu rcañ tub yag tub lugaar ub zi gaab ga bicy Sinaí. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tonaꞌ la za nu ic yu par nu nac coz nu bzaac yu. Orzeꞌ byagaab yu lo yag zeꞌ par nu zac nap zir yuñ. Orzeꞌ güeñ yu nu rnii Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Orzeꞌ nam: “Ya̱ naca̱ Ñgyoozh ni de gyitoo bel nir: Ñgyoozh ni Abraham, Ñgyoozh ni Isaac, Ñgyoozh ni Jacob”, nam. Orzeꞌ gush bis yu nu gudzib yu nu nac de coz nu bzaac yu. Orzeꞌ wancuicaꞌy baloor nu ngüiiy lo yag zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Orzeꞌ na Ñgyoozh rab mi yu: “Bloo gyid lab ru, gun zeꞌ nu zur zeꞌ, zeꞌ lugaar yon. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ya̱ rzaca̱ nu dzi rzac zi de mbecy ne̱ Egipto, nunu reña̱ nu rzuub tiꞌ dey. Ndeꞌ nu ya̱ bi beta̱ na, par nu gloo mbaña̱ dey. Da, gun ya̱ zuu neza̱ ru gyar par Egipto”, na Ñgyoozh rab mi Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Moisees, bdiily lo de mbecy Israeel loy. Mnii dey: “Se cyu la bicy nu ru gyub ic ru de̱ ya̱, nunu ri beer ne̱ de̱”, mnii dey. Zeꞌ Moisees Ñgyoozh bzuu nez mi yu nu gyub ic yu dey, nunu par nu co nap yu dey. Ni bicy mi nu nac anc nu bruu zac lat yag nu pca gyi zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Orzeꞌ laab Moisees gua nuy de mbecy ornu bruu dey Egipto. Bicy yu nusuriidz, nunu bicy yu coz nu za nu ic mbecy. Bicy yu de ndeꞌ Egipto, gal nu ruꞌ nisyudoo ña, gal nu de lugaar ub zi de nez nu gusa dey cyuu ñaꞌn. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Laab Moisees mniiy gugy yu de mbecy Israeel: “Ñgyoozh gzuu nez mi tub mbecy nu nii por cuen nim gal nu bzuu nez mi ya̱. Mbecy zeꞌ gruuy lat nez de ru”, na Moisees. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisees, yu zeꞌ yu nu gusa lat de mbecy zigy, de mbecy Israeel, lugaar ub zi. Gusa nuy de gyitoo bel ni den, nunu gusa nuy anc, yu nu mnii loy too bicy Sinaí. Laab yu gush yu riidz ni Ñgyoozh, riidz nu rnii lac mod cyiiñ den. Orzeꞌ bzeeñ yuñ par de ub na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’De gyitoo bel bdiily lo dey loy. Wansuub gyidag dey niy. Bzu chu dey yu, nunu bicy pee dey mbish cya gaꞌy par Egipto. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ndeꞌ nu na dey rab yu Aroong: “Bzaa la be ñgyoozh nu cha gam par lo den, gun wagad lagy den la bzac Moisees, yu nu bloo de ub na Egipto”, na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Gazeꞌ nu bzaa dey tub nab mod nu na tub biser. Orzeꞌ biit dey bañcyug. Pshu dey reñ ma looñ. Tonaꞌ la bet lagy dey coz nu bzaa dey nu yaay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Orzeꞌ Ñgyoozh bruum lat dey. Nunu bzaan mi nu gyicy ñgyoozh dey de bel baa. Ndeꞌ coz nu bi ca lo libr ni de mbecy nu mnii por cuen ni Ñgyoozh. Orzeꞌ rniiñ: Ñgyoozh nam: De ru mbecy Israeel, walab lo ya̱ biit der bañcyug nu pshur reñ lat cyuu ñaꞌn nu gusa der de lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Sinu biit der bañcyug nañ yuꞌ ni ñgyoozh nu la Moloc, tub ñgyoozh nu gusa nu der tiem zeꞌ. Nunu biit der bañcyug lo nab bel baa, tub ñgyoozh ni der nu la Refán. De ndeꞌ nab nu bzaa der. Bicy der ñii par ñgyoozh ni der. Orzeꞌ ya̱ zuu neza̱ der gal lugaar nu zetaꞌ zir par Babilonia, nam, ni pcaa de mbecy nu mnii por cuen nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’De gyitoo bel ni den bicy cup dey tub yuꞌ negy zeꞌ nu pca dey Ñgyoozh lat nu gusa dey de lugaar ub zi. Yuꞌ zeꞌ byaañ mod nu mnii Ñgyoozh lo Moisees. Mod nu bzaac yu, ni mod bzaa dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ornu gusa nu dey Josué, orzeꞌ za nu dey yuꞌ negy zeꞌ lugaar zeꞌ nu bloo dey yu yaa reñaꞌ mbecy, de mbecy nu bloo chu Ñgyoozh. Orzeꞌ lo de yu zeꞌ byeeñ yuꞌ negy zeꞌ gal pshuub la tiem ni Dabi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dabi bicy yu mod nu nap bicy nu Ñgyoozh yu. Orzeꞌ bdiiñ yu rishbeey lo Ñgyoozh nu zaay tub yuꞌ par ub mi, laab biñ nu briib zily Jacob. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tees Salomoong, yu zeꞌ bzaay yuꞌ zeꞌ ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tees mi zeꞌ, biñ nu zily zir nac wac cyiiñ mi nañ yuꞌ nu rzaa mbecy. Ndeꞌ nu ni mnii de yu nu mnii por cuen nim ornu nay: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ñgyoozh nam: “Gyibaa, zeꞌ nañ gal nu na tub yashily nu zuba̱ riib ica̱ dela coz. Zeꞌ gyishlombecy ii nañ gal nu na tub coz nu zub gyi̱ꞌ. ¿La na yuꞌ nu zaa der ne̱? ¿Ca zu tub lugaar nu zu lagya̱? ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A walab ya̱ bza̱a̱ dela coz ii?” mniim, na de yu nu mnii por cuen nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’¡Dzi ga cyigy too der! ¡Lardoo der nañ gal nu na lardoo tub mbecy nu a̱ꞌ yuꞌ lo Ñgyoozh! Na der gal nu na tub mbecy go̱ꞌ par lo de riidz ni Ñgyoozh. De ru nar gal naꞌ ziꞌl de gyitoo bel nir. Dub laa tiem ricy der coz nu za contr ni Espiriit Yon ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sac ni tub mbecy nu mnii por cuen ni Ñgyoozh nu wansheed zi de gyitoo bel ni der. Tees biit dey dela mbecy nu mnii nu cyid biñ Yon, biñ nu ricy yac dela coz nu rnii Ñgyoozh. Orzeꞌ na de ru bish cya der ich biñ yon zeꞌ, nunu biit der mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Laab de ru mbecy nu byeeñ leey ni Ñgyoozh yaa, leey nu bzeeñ de anc, tees wagyicy yac der niñ ―na Shteb. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ornu de mbecy nu yuꞌ junt zeꞌ güeñ dey de riidz nu mnii Shteb, orzeꞌ tonaꞌ la guzi lagy dey, nunu psiigy lay dey loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tees Espiriit Yon ni Ñgyoozh briib ic zaꞌ lam nañ lardoo Shteb. Orzeꞌ bgüiiy par gyibaa, nunu bzaac yu gyel lily ni Ñgyoozh, nunu bzaac yu Jesuuz zum par yaa bee Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Orzeꞌ nay: ―¡Güii der! Ya̱ rzaca̱ ryaal baa, nunu biñ nu byac mbecy zum par yaa bee Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Orzeꞌ de mbecy psoow dey gyidag yu, nunu brish ti dey. Orzeꞌ bgo la dey too Shteb. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Orzeꞌ bruu nu dey yu lat gyedz. Orzeꞌ bgoow gyitaꞌ dey yu par nu gat yu. De mbecy nu mnii nu bzaac nu shiñ bicy Shteb zeꞌ bzeeñ dey shab yu nu ña tub yu feñ nu la Saulo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Orzeꞌ de mbecy fert la yuꞌ dey rgoow gyitaꞌy Shteb lat nu rnii nuy Ñgyoozh. Orzeꞌ nay: ―Jesuuz, Shuaana̱, byash espiriit ne̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Orzeꞌ gusu tib yu. Gazeꞌ nu ye la mniiy. Orzeꞌ nay: ―Shuaana̱, cueꞌ cuic ru cashtig ni dey nu nac coz nu ricy yu ―nay. Na ornu mniiy ndeꞌ, orzeꞌ gut lay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nunu Saulo bet lagy yu nu biit dey Shteb. Laab dzi zeꞌ de mbecy nu ricy cup consuel lo Crisht Jerusaleeng brugyiꞌ nu tonaꞌ la rzac zi dey. Orzeꞌ dela dey brush las yu par dela lugaar ni Judea nu dela lugaar ni Samaria. Nomaas de aposht ziꞌl wancyuu dey Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tees la be mbecy nu tonaꞌ la rca lagy lo Ñgyoozh, de yu zeꞌ pcach dey Shteb, nunu tonaꞌ la bicy dey sentiir. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tees Saulo mbicy peey nu nit loy dela mbecy nu ricy cup consuel lo Crisht. Gazaꞌ yuꞌ gazaꞌ yuꞌ la rzuꞌy. Bgayu tuñ lay mñaa gyeey la de yu nu ricy cup consuel lo Crisht par nu cha nuy dey nañ yuꞌ gyiib. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na de mbecy nu ricy cup consuel lo Crisht brush las dey zay dela lugaar. Za shaal dey riidz ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Orzeꞌ Lip guay gyedz nu la Samaria. Lo de mbecy zeꞌ pshaal yu riidz ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","De mbecy zigy dzi nap bicy cuen dey de riidz nu mnii Lip. Bzuub gyidag dey riidz nu mniiy, nunu bzaac dey de nusuriidz nu bicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nunu zigy mbecy nu bicy ni nuras byac yu. De nuras tonaꞌ la rbish tiy. Orzeꞌ bruu chuy lo dey. Zañ mbecy chi̱, gal nu zañ mbecy coj byac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nunu de mbecy Samaria tonaꞌ la gucyit lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na laab gyedz zeꞌ rcyiiñ tub mbecy nu la Simo̱o̱. Bi rac tiem rguuy de mbecy Samaria nu fis gyel tuꞌ niy. Mniiy nu tonaꞌ la mbecy lily nac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Dela mbecy nu yuꞌ gyedz zeꞌ dzi nap bicy cuen dey de riidz nu rniiy gush lañ de yu shni gashtal de yu lily. Mnii dey: ―Simo̱o̱ nac yu biñ ni Ñgyoozh nu dzi cyiiñ nu gyicy coz ily ―rnii dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tonaꞌ la bicy cuen de mbecy yu gun dzi gulas rguuy dey nu fis gyel tuꞌ niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tees ornu bicy cup de mbecy consuel lo de riidz nap ni gyel gubier ni Ñgyoozh nunu de riidz nap ni Jesucrisht, de riidz nu mnii Lip, orzeꞌ bzu nis dey. Bzu nis de yu gyeey nunu bzu nisaꞌ de biñ mñaa. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Niꞌ Simo̱o̱ bicy cup yu consuel lo Crisht. Ornu bzu nis yu, orzeꞌ gua cay ich Lip dela lugaar zeꞌ nu zay, nunu tonaꞌ la gua nu ic yu ornu bzaac yu nu ricy Lip nusuriidz, gal nu deꞌ zir de coz ily. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na de aposht nu yuꞌ Jerusaleeng güeñ dey nu de mbecy Samaria gush dey de riidz ni Ñgyoozh. Orzeꞌ bzuu nez dey Bed nu Waa nu chay lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na ornu bruꞌña dey, mnii nu dey Ñgyoozh nu nac de mbecy nu ricy cup consuel lo Crisht. Bdiiñ dey lo Ñgyoozh nu cuic mi Espiriit Yon nim ni dey, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","gun Espiriit Yon ni Ñgyoozh nigul gyicy nim ni tub la dey. Nomaas nu bi bzu nis ziꞌl dey par nu gabe nu nac yu mbecy ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Orzeꞌ Bed nu Waa gul yaa dey de mbecy zeꞌ, nunu Ñgyoozh briic mi Espiriit Yon nim ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na Simo̱o̱ bzaac yu nu Ñgyoozh briic mi Espiriit Yon nim ni de mbecy ornu gul yaa de aposht dey. Orzeꞌ mniiy nu cuic yu tiñ ni Bed nu ni Waa. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Orzeꞌ nay: ―Gyicy ru nu gac gyicy ya̱ ndeꞌ, gun orzeꞌ cyu ziꞌl mbecy nu gal ya̱a̱ Ñgyoozh cuic mi Espiriit Yon nim niy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Orzeꞌ na Bed rab yu Simo̱o̱: ―¡Ru nu dela tiñ nir gyar gabily! Gun ru rnii toor nu gac zir coz nu cuic Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Riiñ nu ricy de̱ ya̱ nii rila wac gyicy ru ñii, gun a̱ꞌ nap lardoor par lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Orzeꞌ mneꞌ coz a̱ꞌ nap nu rlagy ru gyicy ru zeꞌ nunu bdiiñ lo Ñgyoozh ben a gyicy sulagy mi nir par nu nac coz nu psaꞌ lagy ru nañ lardoor. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gun ya̱ rad lagya̱ nu ru dza laa nañ lardoor yuꞌ coz lya nunu coz cyi riib ic ñi ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Orzeꞌ na Simo̱o̱ rab yu Bed nu Waa: ―Bdiiñ lo Ñgyoozh ne̱ nu cueꞌ gzaca̱ de coz nu mniir zeꞌ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na ornu Bed nu Waa pshaal dey de coz nap nu bicy Jesuuz num dey, nunu mnii dey riidz ni Ñgyoozh, orzeꞌ bruu dey Samaria ya dey par Jerusaleeng. Lat nu ya dey, zañ tir pshaal dey de riidz nu sac nu bruu lo Ñgyoozh de gyedz nu yuꞌ lo yu ni Samaria. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Orzeꞌ tub anc ni Ñgyoozh mniiy lo Lip. Orzeꞌ nay: ―Bzu lily, nunu gua par yaa been ornu güiin zeꞌ nu driib doo par zeꞌ nu riib nez nu za par Gaza ―nay. Laab nez nu za zeꞌ rded ñi tub lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Orzeꞌ Lip bzu lily yu. Orzeꞌ zay. Na laab nez nu zay zeꞌ bdzeel yu tub mbecy Etiopía. Yu zeꞌ nac yu mbecy capo̱o̱. Tonaꞌ la riiñ ily zuy. Nac yu tesorer ni biñ mñaa nu nac rey ni de mbecy Etiopía. Yu zeꞌ guay Jerusaleeng par nu riib zily yu Ñgyoozh, tees ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","bi bish cyay yay par ledz yu. Zub yu nañ caret niy rsyaꞌy libr ni Isaías, tub yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Orzeꞌ na Espiriit Yon ni Ñgyoozh rab mi Lip: ―Bechaꞌ lo caret re, nunu cueꞌ gyazet ru looñ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Orzeꞌ ornu bechaꞌ Lip lo caret zeꞌ, orzeꞌ güeñ yu nu rlab mbecy zeꞌ riidz ni libr ni Isaías, yu nu mnii por cuen ni Ñgyoozh. Orzeꞌ nay rab yu mbecy zeꞌ: ―¿A yet lag ru cuen de riidz nu rlab ru? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Orzeꞌ na mbecy zeꞌ rab yu Lip: ―¿Lac gyicya̱ gyet laga̱ cuen, zeꞌ sac cyu yu nu shaal lo̱? ―nay. Orzeꞌ mniiy lo Lip nu chuꞌy nañ caret nu gzub nuy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na zeꞌ nu rlab yu lo riidz ni Ñgyoozh zeꞌ rniiñ: Mi zeꞌ nam gal na tub shily nu za nu dey lo mbecy par nu cut yu ma. Mi zeꞌ nam gal nu tub shily nu wanii la ma ornu rshiꞌñ mbecy gyich ma. Ni tub riidz wanniim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mbecy bicy gyidz dey mi, nunu wangyicy dey gyel fushtiz nuy mi. Ni tub la mbecy wac zat dey nez mi, gun bzaꞌ lo dey lo yum, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Orzeꞌ mbecy nu zu riiñ zeꞌ nay rab yu Lip: ―Mnii lo̱ cyu mbecy rzat yu nu mnii por cuen ni Ñgyoozh lat nu pcaay riidz ii. ¿A laab ub yu rzat yu uti reñaꞌ mbecy? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Orzeꞌ Lip brugyiꞌ rniiy. Gush yu nu loga la zeꞌ nu blab mbecy zeꞌ lo libr ni Isaías. Orzeꞌ mniiy dela riidz nap ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na lat nu zaab za dey nez, bruꞌña dey tub lugaar zeꞌ nu yuꞌ nis. Orzeꞌ na yu nu zu riiñ zeꞌ rab yu Lip: ―Ii yuꞌ nis. ¿A wac zu nisa̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Orzeꞌ na Lip rab yuy: ―Gac zu nis ru, benu ru ricy cup ru consuel lo Crisht nu dutuub la lardoor ―nay. Orzeꞌ nay rab yu Lip: ―Ya̱ zeña lagya̱ nu Jesucrisht nac mi Iꞌñ Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Orzeꞌ yu nu zu riiñ zeꞌ mnii nuy mbecy nu rsaa caret zeꞌ nu chesuy. Na orzeꞌ bruuy nañ caret za nuy Lip tublaazh la par lo nis. Orzeꞌ Lip briib nis yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na ornu bruuy lo nis, orzeꞌ Espiriit Yon ni Ñgyoozh byash mi Lip za num yu. Mbecy nu zu riiñ zeꞌ wansaacaꞌy Lip tuubaꞌ tir, tees lat nu zaab zay nez, tonaꞌ la zu cyit lagy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Lip gud lagy yu nu zuy tub gyedz nu la Azoto. Orzeꞌ zay gazaꞌ gyedz la pshaal yu de riidz nu sac nu bruu lo Ñgyoozh gashtal bruꞌña lay tub gyedz nu la Cesarea. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Laab tiem zeꞌ Saulo gabee mniiy nu cut yu de mbecy nu ricy cup consuel lo Shuaan den. Orzeꞌ guay lo mbecy nu riib ic de uz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Lo yu zeꞌ blooy tub gyicy ni rishbeey nu cha nuy lo de mbecy nu rza nañ yuꞌ nu rsyaꞌ mbecy Israeel riidz ni Ñgyoozh, de yu nu yuꞌ Damasco. Orzeꞌ nu gyicy zeꞌ ricy cup yu rishbeey nu gya nuy de yu nu gush nez cub ni Crisht par Jerusaleeng. Tant yu gyeey nunu tant biñ mñaa gya nuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na nez nu zay, ornu birgaab Damasco, orzeꞌ sij la bet tub yaa. Bruuñ gashtal baa bet ñi dub yub la lo Saulo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Orzeꞌ wes saay lo yu. Orzeꞌ güeñ yu nu zaab tiꞌ tub mbecy rniim. Orzeꞌ nam rab mi yu: ―Saulo, Saulo, ¿lagu rsheed zir ya̱? ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Orzeꞌ na Saulo: ―¿Cyu ru Shuaana̱? ―nay. Orzeꞌ na gaꞌ biñ nu zaab tiꞌ nu rnii zeꞌ. ―Ya̱ naca̱ Jesuuz, biñ nu ru rsheed zir. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Weshte. Guꞌ lat gyedz. Zeꞌ nii mbecy la coz rlagy ñi nu gyicy ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Orzeꞌ de yu nu za nuy wagnii la dey, gun tonaꞌ la gudzib dey, gun güeñ dey nu rnii mbecy, tees wansac yu ni tub la mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Orzeꞌ Saulo weshtey. Na ornu pshaal yu urloy na, orzeꞌ wangac zac yu ni tub la coz. Orzeꞌ bduꞌ yaa dey yaay za nu dey yu par Damasco. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chon dzi wangac zac yu. Chon dzi ndeꞌ rila wangoy gyit, nunu rila wangoꞌy nis. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Zeꞌ Damasco zu tub mbecy nu ricy cup consuel lo Crisht, yu nu la Ananías. Orzeꞌ Shuaan den bruu zac mi loy. Orzeꞌ nam rab mi yu: ―¡Ananías! ―nam. Orzeꞌ na Ananías: ―Ii zu, Shuaana̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Orzeꞌ na Shuaan den rab mi yu: ―Wes su. Gua tub cay nu la Cay nu Li. Orzeꞌ yuꞌ Judas zeꞌ cugyiꞌr tub mbecy nu ledz Tarso, yu nu la Saulo. Zuy rnii nuy ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Orzeꞌ mod ni pcaal bdeꞌ tub mbecy nu la Ananías loy. Gal yaay yu gun orzeꞌ zac yu tuubaꞌ tir ―nam rab mi Ananías. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Orzeꞌ Ananías nay rab yum: ―Zañ mbecy rniiy coz nu ricy yu zeꞌ lo̱. Zañ coz a̱ꞌ nap bicy nuy de mbecy nir nu yuꞌ Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Orzeꞌ na briy Damasco nu rishbeey nu bruu lo mbecy nu riib ic de uz par nu gya nuy dela mbecy nu rzat ru pres ―na Ananías. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Orzeꞌ na Shuaan den rab mi yu: ―Gua gun ya̱ bloo su̱ yu nu gyicy yu riiñ ne̱, nunu zat yu ya̱ lo de mbecy. Zat yu ya̱ lo de mbecy nu walab mbecy Israeel. Nunu zat yu ya̱ lo de mbecy nu zu riiñ. Nunu zat yu ya̱ lo de mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Laab ub la̱ lyu̱u̱ loy dela coz nu gzac ziy nu nac ya̱ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Orzeꞌ gua Ananías. Guꞌy nañ yuꞌ zeꞌ. Gul yaay Saulo. Orzeꞌ nay rab yuy: ―Bicya̱ Saulo, Shuaan den Jesuuz, biñ nu bruu zac lor nez nu yad ru, bzuu nez mi ya̱ nu yapa̱ lor, gun orzeꞌ zac ru tuubaꞌ tir, nunu gac ru mbecy nu gyub ic zaꞌ la Espiriit Yon ni Ñgyoozh nañ lardoo ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Orzeꞌ lueg la tub coz nu na gal na gyid ich bel bruuñ urlo Saulo bet lag ñi. Orzeꞌ brugyiꞌ rzac yu tuubaꞌ tir. Orzeꞌ wes suy, nunu bzu nis yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na ornu bdoy gyit, orzeꞌ guud fers niy. Orzeꞌ Saulo byeeñ yu la be dzi nu de yu nu ricy cup consuel lo Crisht, de yu nu yuꞌ Damasco. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Orzeꞌ lueg la za Saulo yuꞌ zeꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh, nunu brugyiꞌ nu rshaal yu de coz ni Crisht. Orzeꞌ nay: ―Mi zeꞌ nac mi iꞌñ Ñgyoozh ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dela mbecy nu güeñ zeꞌ tonaꞌ la za nu ic dey. Orzeꞌ na dey: ―¿A walab yu ii mbecy nu gusa pshet zi de mbecy nu rzat Jesuuz Jerusaleeng? Nunu ¿a walab nu yad yu ii par nu cha nuy dey pres, nunu guꞌy dey yaa de yu zub lo ni uz? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tees niga niga byanap zir rshaal Saulo de riidz ni Crisht. Tonaꞌ la nap blyuuy nu Jesuuz nac mi Mesías, biñ nu ca lo cuen nu co mbañ mbecy. Ni wangacaꞌ la nii de mbecy Israeel nu yuꞌ Damasco nu radzay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ornu bzaꞌ la be dzi, byatublaazh de mbecy Israeel, nunu psaap dey riidz nu cut dey Saulo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tees mbecy mnii dey loy de coz nu rlagy dey gyicy nuy yu. Dzi rel la mña dey de roꞌ nu druu mbecy ruꞌ gyedz, gun rlagy dey cut yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Orzeꞌ de mbecy nu ricy cup consuel lo Crisht bri dey yu nañ tub chicyiw ily. Pshet dey yu par ich loꞌ ni gyedz zeꞌ rel. Ni mod briib dzey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na ornu Saulo briy Jerusaleeng, bicy peey nu ñgyac nuy de mbecy nu ricy cup consuel lo Crisht, tees wancheña lagy dey nu ricy cup yu consuel lom, nunu rdzib dela dey loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Orzeꞌ Bernabee blocyuub yuy. Gua nuy yu lo de aposht. Orzeꞌ pshaal yu lo dey nu bzaac Saulo Shuaan den gyernez, nunu mnii num yu. Mniiy nu Saulo wacchib lay bzat yu Crisht lat de mbecy Damasco. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Orzeꞌ Saulo byeeñ nuy dey, nunu gusay dutuub la lat gyedz Jerusaleeng. Wacchib lay rzat yu Crisht lat de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Orzeꞌ bee nuy de mbecy Israeel riidz, de yu nu rnii riidz griego. Nunu ptub su losaꞌ dey nu riidz. Tees de mbecy zeꞌ mbicy pee dey nu ñgyut dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tees ornu gud lagy de bicy na, orzeꞌ gua nu dey Saulo par Cesarea. Orzeꞌ bzuu nez dey yu yay Tarso. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Orzeꞌ dela de mbecy ni Crisht nu yuꞌ lo de yu ni Judea, gal nu lo de yu ni Galilea, gal nu lo de yu ni Samaria, bi yuꞌ gyel ri zu lat dey, nunu byafert zir dey nañ lardooy. Nunu Espiriit Yon ni Ñgyoozh blocyuub mi dey nu byañ zir yu lat nu gusa dey nu pca lagy dey lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Zeꞌ Bed gusay lat de mbecy ni Crisht. Guay lat de mbecy ni Crisht nu yuꞌ Lida. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Zeꞌ bdzeel yu tub mbecy nu la Eneas. Yu zeꞌ tub mbecy chi̱. Bi bzaꞌ shuñ ñaꞌn nu wagac gyeshtey. Orzeꞌ Bed nay rab yuy: ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","―Eneas, Jesucrisht gyicy yac mi ru. Weshte, nunu byash daꞌ nir ―nay. Orzeꞌ lueg la weshte Eneas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Orzeꞌ dela mbecy nu yuꞌ Lida, nunu dela mbecy nu yuꞌ lo de yu ni Sarón byac dey mbecy nu ricy cup consuel lo Shuaan den ornu bzaac dey nu byac yu zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na zu tub biñ mñaa nu la Tabita nu ricy cup consuel lo Crisht. Benu nu riidz griego, orzeꞌ lam Dorcas. Rcyiiñ mi tub gyedz nu la Jope. Dub laa lat nu bzu biñ mñaa zeꞌ gyishlombecy, bicy mi coz nap. Blocyuub mi de mbecy zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Laab tiem zeꞌ gush güiim gut mi. Orzeꞌ blaagy dey mi. Gazeꞌ nu briish dey mi nañ tub yuꞌ. Shily cyup nu zub gya briish dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na Jope gaab ga riñ nu Lida. Orzeꞌ ornu güeñ de yu nu ricy cup consuel lo Crisht, de yu nu yuꞌ Jope nu ri Bed Lida, orzeꞌ bzuu nez dey cyup mbecy nu cha nuy raso̱o̱ nu gyicy lal Bed chay lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Orzeꞌ Bed bzu lily yu za nuy dey. Na ornu briy lugaar zeꞌ na, orzeꞌ gup nu dey yu nañ yuꞌ cyup shily nu zub gya zeꞌ. Orzeꞌ dela de byud bdeꞌ dem loy nu ruun dem. Nunu blyuu dem dela yaag, nu dela negy nu bzaa Dorcas ornu bzum gyishlombecy loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Orzeꞌ Bed bloo chuy dem par ich yuꞌ. Orzeꞌ gusu tib yu mnii nuy Ñgyoozh. Orzeꞌ bgüiiy lo biñ mñaa gut zeꞌ. Orzeꞌ nay rab yum: ―¡Tabita, weshte! ―nay. Orzeꞌ mi zeꞌ mbi bgüiim loy. Ornu bzaac mi Bed, orzeꞌ weshtem. Gusub mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Orzeꞌ Bed bduꞌ yaay yaam blocyuub yum. Gazeꞌ nu wes sum. Orzeꞌ bredz mbecy de yu nu ricy cup consuel, gal nu de byud. Orzeꞌ blyuuy mi lo dey nu mbañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Orzeꞌ bzu laa riidz ni de coz nu bicy yu dutuub la gyedz Jope. Nunu zañ mbecy bicy cup dey consuel lo Shuaan den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Orzeꞌ Bed byeeñ yu Jope zañ dzi. Zeꞌ pcyiiñ nuy tub mbecy, tub yu nu rcuugy gyid bañcyug, tub yu nu la Simo̱o̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Zu tub mbecy nu rcyiiñ Cesarea, yu nu la Cornelio. Yu zeꞌ yu nu riib ic tub gaynal soldad Rom. Byub ic yu tub nac soldad nu la Mbecy Italia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yu zeꞌ tonaꞌ la pcaa ic yu de coz ni Ñgyoozh. Pca lagy yu lom nu dela famil niy. Zañ gun briic yu ni de mbecy zi lat de mbecy Israeel, nunu zaab rnii nu laay Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Orzeꞌ tub dzi, tub gyiib chon or gudze, bruu zac tub anc ni Ñgyoozh loy. Orzeꞌ nay rab yuy: ―¡Cornelio! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Orzeꞌ mbi la bgüii Cornelio lo anc zeꞌ gun gudzib yu. Orzeꞌ nay: ―¿La coz rac shuaana̱? ―nay rab yu anc. Orzeꞌ na anc rab yu Cornelio: ―Ñgyoozh mniim nu nap ornu güeñ mi nu rnii nur mi, nunu ornu rzac mi de gun nu rbic ru ni de mbecy zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Orzeꞌ na zuu nez ru la be mbecy chay Jope nu cyid nuy tub mbecy nu la Simo̱o̱. Laab yu zeꞌ yu nu la Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yu zeꞌ rcyiiñ yu nu tub mbecy nu la laabaꞌ Simo̱o̱, tub yu nu rcuugy gyid bañcyug. Rcyiiñ yu ruꞌ nisyudoo ―na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na ornu bruu chu anc lo Cornelio. Orzeꞌ bredz Cornelio cyup yu nu ricy riiñ nañ yuꞌy nu tub soldad. Soldad zeꞌ tub yu nu dzi rcaa ic de coz ni Ñgyoozh, nunu nac yu mbecy nu ricy ziꞌl coz nu rlagy Cornelio. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Orzeꞌ mniiy lo dey de coz nu guc. Gazeꞌ nu bzuu nez yu dey zay par Jope. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na tuubaꞌ dzi, lat nu de mbecy zeꞌ zaab zay nez, sñuu ga ziꞌl ri dey Jope, orzeꞌ Bed gup yu too yuꞌ tub or wi doo par nu nii nuy Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Orzeꞌ brugyiꞌ ran yu. Rlagy yu goy gyit. Na lat nu rduzu ye de coz nu goy, Ñgyoozh bicy mi nu bruu zac tub coz loy mod ni pcaal. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bzaac yu nu byaal baa. Orzeꞌ bet tub coz nu na gal nu na tub negy cuadrad nag seꞌ tap la scyiñ niñ yet ñi par lo yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Orzeꞌ lo negy zeꞌ nguaa de lo la bañcyug nu ricy cup tap gyiꞌ: gazaꞌ de lo la nez bily nu de lo la chigyiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Orzeꞌ na Ñgyoozh rab mi Bed: ―Bed, wes su. Biit de bañcyug zeꞌ gow ru ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Orzeꞌ na Bed: ―Cueꞌ Shuaana̱. Ya̱ rila wada̱w de coz bag nu rlyuu leey ni Moisees, nunu rila wada̱w coz nu a̱ꞌ yad ñi nu da̱w ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Orzeꞌ na gaꞌ Ñgyoozh rab mi yu tuubaꞌ tir: ―Benu ya̱ Ñgyoozh bicy caacya̱ la coz, orzeꞌ cueꞌ niir nu ndeꞌ bag nañ ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chon tir guc de coz zeꞌ. Orzeꞌ lueg la negy zeꞌ gupaꞌñ baa. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Orzeꞌ Bed gush yu shcab nañ lardooy ben lac yaruu de coz nu bruu zac loy. Laab or la zeꞌ byad yuꞌ ni Simo̱o̱ ni de mbecy nu bzuu nez Cornelio. Guchuꞌ dey roꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Orzeꞌ rbish ti dey nu bdugyiꞌy ben a zu tub yu nu la Simo̱o̱, laab yu zeꞌ yu nu la Bed, lo de mbecy nu yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na Bed gabee rash yu shcab par nu gyet lag yu cuen lac yaruu de coz nu bruu zac loy. Orzeꞌ Espiriit Yon ni Ñgyoozh nam rab mi yu: ―Bzuub gyidag. Zu chon mbecy nu ryub dey ru. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Orzeꞌ na bzu lily laa. Bet la. Cueꞌ gyicy cyup ic ru nu cha nur dey, gun ya̱ bzuu neza̱ dey ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Orzeꞌ Bed bet yu. Zay lo de yu zeꞌ. Orzeꞌ nay rab yu dey: ―Ya̱ yu nu ryub der zeꞌ. ¿La riñ yad der lo̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Gazeꞌ nu na dey: ―Cornelio, yu nu riib ic tub gaynal soldad, bzuu nez yu de̱ ya̱ yapa̱. Yu zeꞌ tub mbecy nap. Rca lagy yu lo Ñgyoozh. Nunu dela de mbecy Israeel nap rnii dey niy. Tub anc ni Ñgyoozh mniiy loy nu cuedz yu ru char yuꞌy, gun orzeꞌ gac gyeñ yu coz nu rlagy ru niir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Orzeꞌ Bed mniiy nu chuꞌ dey nañ yuꞌ, nunu mniiy nu gyeche dey zeꞌ. Orzeꞌ tuubaꞌ dzi bzu lily Bed nu za nuy dey, nunu la be de bicy na nu yuꞌ Jope za nuy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Orzeꞌ gal tuubaꞌ dzi bri dey Cesarea. Zeꞌ blez Cornelio, nu de famil niy, nu de yu nu tonaꞌ la amig niy. Tub nac laa de yu zeꞌ bredz yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na ornu Bed bruꞌñay roꞌ Cornelio, orzeꞌ Cornelio za cheel yuy. Orzeꞌ gusu tib yu loy nu driib zily yuy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tees Bed pshes suy yu. Orzeꞌ nay: ―Wes su gun niꞌ ya̱ naca̱ mbecy gal nu na ru ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Orzeꞌ Bed zaab ro lay riidz nu Cornelio lat nu ya dey nañ yuꞌ. Ornu guꞌy nañ yuꞌ, orzeꞌ bzaac yu nu yuꞌ zigy mbecy nu byatublaazh nañ yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Orzeꞌ na Bed rab yu dey: ―De ru nap rad lagy der nu leey ni de mbecy Israeel wazaan ñi nu gac nu dey mbecy nu walab mbecy Israeel. Nunu wac nu cha zaab lo dey loy. Tees Ñgyoozh blyuum ne̱ nu cueꞌ ne̱e̱ lo ni tub mbecy nu nac yu mbecy bduneꞌ o nu nac yu mbecy nu a̱ꞌ yad ñi nu cha zaab lo̱ lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Orzeꞌ ornu bredz ru ya̱, wanne̱e̱ deeta̱, sinu lueg la yapa̱. Tees na rlagya̱ gad lagya̱ la gyiꞌ bredz ru ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Orzeꞌ na Cornelio rab yu Bed: ―Gutap dzi ya̱ zu̱ yu̱ꞌ. Orzeꞌ i la or pca̱ uba̱ nu cueꞌ da̱w gyit lat nu mne̱e̱ du̱ Ñgyoozh. Orzeꞌ bruu zac tub mbecy shab ryal lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Orzeꞌ nay rab yu ya̱: “Cornelio, Ñgyoozh reñ mi coz nu rniir lom, nunu mniim nu dzi nap ornu rzac mi de gun nu rbic ru ni de mbecy zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ndeꞌ nu na zuu nez ru moz chay Jope nu cha teey tub mbecy nu la Simo̱o̱, laab yu zeꞌ yu la Bed. Yu zeꞌ rcyiiñ yu yuꞌ tub mbecy nu la laabaꞌ Simo̱o̱, tub yu nu rcuugy gyid bañcyug. Rcyiiñ yu ruꞌ nisyudoo”, na anc zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Orzeꞌ ya̱ lueg la bzuu neza̱ dey nu biid teey ru. Nunu nap ñuu bicy ru nu yad ru. Na byatublaazh de̱ ii, nunu Ñgyoozh zum lat de̱, nunu rlagy de̱ gyeña̱ dela coz nu pcaa Shuaan den ru nu niir lo de̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Orzeꞌ brugyiꞌ rnii Bed. Orzeꞌ nay: ―Na gaal bet laga̱ cuen nu rishli Ñgyoozh tub ziꞌl mod ricy num dela mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tees Ñgyoozh gyash mi mbecy mas cyu ziꞌl nez yu benu ca lagy dey lom, nunu gyicy dey coz nu seꞌñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","De ru rad lagy der nu Ñgyoozh bzeed mi raso̱o̱ ni de nez mbecy Israeel. Mniim nu nu nac Jesucrisht, biñ nu nac Shuaan dela mbecy, chuꞌ gyel ri zu nañ lardoo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","De ru rad lagy ru la coz guc dutuub la lugaar nu yuꞌ de mbecy Israeel. Coz zeꞌ brugyiꞌñ lo de yu ni Galilea, despuees nu briib nis Waa de mbecy, nunu pshaal yu de riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","De ru rad lagy ru de coz ni Jesuuz, biñ nu pcyiiñ Nazaret. Rad lagy de ru nu pcui Ñgyoozh mi, nunu briic Ñgyoozh Espiriit Yon nim ni Jesuuz. Ñgyoozh bicy mi nu cyiiñ mi nu gyicy mi coz ily dela lugaar nu gusam. Bicy mi coz nap, nunu bicy yac mi de mbecy nu bicy ras nu nuras. De ndeꞌ bicy mi gun Ñgyoozh nac num mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nunu de̱ ya̱ rne̱e̱ de̱ nu bzaac de̱ dela coz nu bicy mi ledz mbecy Israeel, nunu dela coz nu bicy mi Jerusaleeng. Pcaa dey mi lo cruuz. Ni mod biit dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tees ornu bzaꞌ dzi chon nu gut mi, orzeꞌ Ñgyoozh bicy mi nu byabañ mi, nunu bicy mi nu bruu zac mi lat de̱ ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Walab dela mbecy bzaac dey mi, sinu de̱ ya̱ ziꞌl, yu nu bi pcui Ñgyoozh nu gne̱e̱ de̱ lo de mbecy de coz nu guc, de̱ ya̱ bzaac de̱m. Bda̱w du̱ de̱m gyit, nunu bdo̱ꞌ de̱ nis du̱m despuees ornu byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Orzeꞌ pcaam de̱ ya̱ nu shaal de̱ de riidz nu sac nu bruu lo Ñgyoozh lo de mbecy, nunu pcaam de̱ ya̱ nu ne̱e̱ de̱ nu segur la mi zeꞌ nac mi biñ nu bloo su Ñgyoozh par nu ri beem ni dela mbecy mbañ, nunu par nu ri beem ni dela mbecy nu bi gut. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dela yu nu mnii por cuen ni Ñgyoozh bi bzat dey mi. Mnii dey nu dela mbecy, de yu nu gyicy cup consuel lom, gyicy sulagy Ñgyoozh de cyi nu bicy dey. Par nu nac Jesucrisht gyicy sulagy mi ni dey ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lat nu gabee rnii Bed de riidz zeꞌ, orzeꞌ Espiriit Yon ni Ñgyoozh bicy nim tub ga la de yu nu rzuub gyidag de riidz nu rniiy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","De mbecy Israeel nu ricy cup consuel lo Crisht, de yu nu za nu Bed, tonaꞌ la za nu ic dey ornu bzaac dey nu Espiriit Yon ni Ñgyoozh niꞌ bicy nim de mbecy nu walab mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gud lagy dey nu bicy ni Espiriit Yon ni Ñgyoozh dey, gun mnii dey riidz reñaꞌ mbecy, nunu ryabic dey gyel mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Orzeꞌ na Bed: ―De mbecy nu yuꞌ ii byac ni Espiriit Yon ni Ñgyoozh gal nu gucaꞌ ziꞌl nu de ub na. Orzeꞌ ¿cyu gac ca ni dey nu cueꞌ zu nis dey? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Orzeꞌ Bed pcaay mbecy nu griib nis yu dey par nu gabe nu nac dey mbecy ni Jesucrisht. Orzeꞌ de mbecy zeꞌ mnishbaa dey lo Bed nu gyiyeeñ nuy dey la be dzi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Orzeꞌ de aposht nu deꞌ zir bicy na nu yuꞌ lo yu ni Judea güeñ dey nu niꞌ yuꞌ mbecy nu walab mbecy Israeel nu guña lagy dey de riidz nu bruu lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Orzeꞌ ornu bri Bed Jerusaleeng, de yu nu rlagy caa beey sircunsision cuerp ni mbecy nu walab mbecy Israeel mnii zi dey niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Orzeꞌ na dey rab yuy: ―¿Lagu gua güiir de mbecy nu walab mbecy Israeel? ¿Lagu bdow nur dey gyit? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Orzeꞌ Bed pshaal yu dela coz nu guc gal zeꞌ nu bzub la gyiꞌ de coz nu bzac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Orzeꞌ nay: ―Ya̱ bri̱ Jope. Orzeꞌ lat nu mne̱e̱ du̱ Ñgyoozh, orzeꞌ bicy mi nu bdeꞌ tub coz lo̱. Ya̱ bzaaca̱ nu yet tub coz nu na gal na negy cuadrad ily. Zaꞌ tap la scyiñ niñ nag yet ñi. Bruuñ baa bet ñi gashtal lo̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Orzeꞌ mbi la bgüi̱i̱ nañ ñi. Orzeꞌ bzaaca̱ de bañcyug nu zub tap gyiꞌ. Bzaaca̱ de bañ gyish. Bzaaca̱ de lo la mni bily. Nunu bzaaca̱ de chigyiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Orzeꞌ güeña̱ nu mnii Ñgyoozh. Orzeꞌ nam rab mi ya̱: “Bed, wes su. Biit de ma zeꞌ gow ru”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Orzeꞌ Mne̱e̱ lom: “Cueꞌ Shuaana̱. Rila wagda̱w de coz bag nu rlyuu leey ni Moisees, nunu rila wagda̱w coz nu a̱ꞌ yad ñi nu da̱w”, rugya̱m. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Orzeꞌ Ñgyoozh mnii gaꞌm tuubaꞌ tir gal gyibaa. Orzeꞌ nam: “Benu ya̱, Ñgyoozh, bicy caacya̱ la coz, orzeꞌ ru cueꞌ niir nu ndeꞌ coz bag”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ni bicy mi chon tir. Orzeꞌ despuees bish cya gaꞌ negy zeꞌ gup ñi baa tuubaꞌ tir. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Orzeꞌ lueg la bruꞌña chon mbecy yuꞌ zeꞌ nu rcyiiña̱. Mbecy nu rcyiiñ gal Cesarea bzuu nez yu de mbecy zeꞌ nu yad yub dey ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Orzeꞌ Espiriit Yon ni Ñgyoozh mniim lo̱ nu cueꞌ gyicy cyup ica̱ nu waya̱ du̱ dey. Niꞌ shuup de bicy na nu yuꞌ ii gua nu dey ya̱ par Cesarea. Orzeꞌ dela de̱ gu̱ꞌ nañ yuꞌ ni Cornelio. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mniiy nu bzaac yu tub anc nañ yuꞌy. Orzeꞌ anc zeꞌ mniiy loy: “Bzuu nez tub mbecy chay Jope cha tey tub mbecy nu la Simo̱o̱. Laab yu zeꞌ yu nu la Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yu zeꞌ gniiy de riidz lor. Nu nac riidz zeꞌ gruu mbañ ru nu dela famil nir”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Orzeꞌ na ornu brugyiꞌ rne̱e̱ lo dey, orzeꞌ Espiriit Yon ni Ñgyoozh bicy nim dey gal nu bicy mi nu de ub na nu loga. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Orzeꞌ byezaꞌ lagya̱ tub coz nu mnii Shuaan den ornu nam: “Waa briib nis yu de ru nu nis, tees ya̱ zeeda̱ Espiriit Yon nu gyicy nim der”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Orzeꞌ benu Ñgyoozh rbic mi ni de mbecy nu walab mbecy Israeel laabaꞌ coz nu briic mi ni de ub na ornu bicy cup na consuel lo Shuaan den, orzeꞌ ¿cyu guc ya̱ nu ca̱ ni Ñgyoozh nu cueꞌ ni gyicy mi? ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na ornu güeñ de mbecy ndeꞌ, orzeꞌ guca dey nu rnii ziy ni Bed, nunu byabic dey gyel mbecy ni Ñgyoozh. Orzeꞌ na dey: ―Orzeꞌ beni niꞌ ziꞌl briic Ñgyoozh ni de mbecy nu walab mbecy Israeel mod nu neꞌ dey dela coz cyi nu ricy yu gun orzeꞌ cui mbañ dey tub la ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","De mbecy nu ricy cup consuel lo Crisht brush las dey ornu bzac ziy tiem nu gut Shteb. Yuꞌy zay gashtal Fenicia. Yuꞌy zay gashtal Chipre. Yuꞌ gaꞌy zay gashtal Antioquía. Pshaal dey de riidz nu bruu lo Ñgyoozh lo de mbecy Israeel ziꞌl. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Zeꞌ la be mbecy Chipre, nu la be mbecy Cirene, de yu nu ricy cup consuel lo Crisht, bri dey tub gyedz nu la Antioquía. Zeꞌ pshaal dey de riidz nu sac ni Shuaan den Jesuuz lo gazaꞌ de mbecy nu walab mbecy Israeel. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tonaꞌ la blocyuub Ñgyoozh dey, nunu tonaꞌ la mbecy zigy bicy cup dey consuel lo Shuaan den, nunu guc nu dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na ornu güeñ de mbecy nu ricy cup consuel lo Crisht nu yuꞌ Jerusaleeng de coz nu guc, orzeꞌ bzeed dey Bernabee gal Antioquía. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na ornu briy, orzeꞌ bzaac yu nu tonaꞌ la nap bicy nu Ñgyoozh de mbecy zeꞌ. Orzeꞌ tonaꞌ la bet lagy yu, nunu fert la mniiy lo dey nu gyicy paay nu Shuaan den nu dutuub la lardoo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Na Bernabee nac yu mbecy nap. Espiriit Yon ni Ñgyoozh briib ic zaꞌ lam nañ lardooy. Nunu fert la bicy cup yu consuel lo Ñgyoozh. Orzeꞌ zigy mbecy zeꞌ brugyiꞌ nu ricy cup dey consuel lo Shuaan na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Orzeꞌ Bernabee guay Tarso nu yub yu Saulo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na ornu byad yu na, orzeꞌ gua nuy yu par Antioquía. Nañ tub ñaꞌn rup laa dey byatublaazh yu nu de mbecy nu ricy cup consuel lo Crisht nunu blyuu dey ni tub nac mbecy zigy. Antioquía, zeꞌ bzub gyiꞌñ nu rnii dey “Mbecy ni Crisht” de yu nu ricy cup consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tiem zeꞌ bruu la be mbecy nu mnii por cuen ni Ñgyoozh Jerusaleeng. Za dey par Antioquía. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tub mbecy nu la Agabo wes suy lat de mbecy zigy. Orzeꞌ Espiriit Yon ni Ñgyoozh blocyuub mi yu, nunu mniiy nu sñuu ga cyid tub cubiñ ily dutuub la gyishlombecy. Cubiñ zeꞌ biid ñi, ornu Clau byub ic yu de nasyoong. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Orzeꞌ dela de mbecy ni Crisht mneꞌ ic dey nu zeed yu ñuu tiñ nu locyuub yu de bicy yu nu yuꞌ lo de yu ni Judea. Dub gal lac nu gagye tub ga dey, dub ni bzeed dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Orzeꞌ ni bicy dey. Orzeꞌ bzuu nez dey Bernabee nu Saulo nu byazeñ yu gun zeꞌ yaa de yu bel nu riib ic de mbecy ni Crisht nu yuꞌ lo de yu ni Judea. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tiem zeꞌ Herodes, tub yu nu riib ic de mbecy Israeel, brugyiꞌ rsheed ziy la be mbecy ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pcaay mbecy nu cut yu Santiag bicy Waa, nu mandzicy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na ornu bzaac yu nu tonaꞌ la bet lagy mbecy Israeel nu biit yu Santiag, orzeꞌ pshetaꞌ yaay Bed. Ni guc tub saꞌ nu row dey gyishtily nu sac lebadur. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na ornu bded nu bduꞌ yaay Bed, mneꞌy yu nañ yuꞌ gyiib. Zeꞌ bguꞌ dey yu yaa tap nac soldad. Tap ga soldad lo tub nac yu. De yu zeꞌ mña dey yu. Herodes mnii tooy nu cha nuy Bed lo de mbecy zigy, de mbecy Israeel or ded saꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Orzeꞌ guti Bed yuꞌ gyiib, tees de mbecy ni Crisht fert la mnii nu dey Ñgyoozh nu nac yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tub dzi anzir nu co ic Herodes nu cha nuy Bed lo de mbecy, na or guzeel rel, orzeꞌ nas la Bed lat cyup soldad nu rñay zeꞌ. Nag yu nu cyup caden. Nunu zu cyupaꞌ soldad roꞌ gyiib zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Orzeꞌ derepent la bruu zac tub anc ni Ñgyoozh lo Bed. Orzeꞌ dutuub la nañ yuꞌ zeꞌ bzu yaa. Orzeꞌ gul yaa anc zeꞌ cuit yu. Orzeꞌ brish yu yaa. Orzeꞌ nay rab yuy: ―¡Bicy lal! ¡Weshte! ―nay. Orzeꞌ lueg la bet lag caden nu nag yeñ yaa Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Orzeꞌ na anc rab yuy: ―Bicy nicy sinch nir, nunu pcaa gyiꞌ gyid lab ru ―nay. Orzeꞌ ni bicy Bed. Orzeꞌ na anc: ―Bzuu yeñ shab ru. Orzeꞌ cyid car icha̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Orzeꞌ za ca Bed ich yu. Orzeꞌ bruuy nañ yuꞌ gyiib. Par wangad lagy yu ti coz nu ricy anc zeꞌ ndeꞌ coz rishli. Psaꞌ lagy yu nu Ñgyoozh ricy num yu mod ni pcaal. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Orzeꞌ bded dey lugaar loga la nu rña soldad. Niga bdedaꞌ dey lugaar cyup. Niga byap dey tub roꞌ nu byaa nu gyiib. Roꞌ zeꞌ benu shaal nañ, orzeꞌ gac ruun nañ yuꞌ gyiib chuꞌn lat cay. Orzeꞌ roꞌ zeꞌ byaal ub lañ. Orzeꞌ bruu dey nañ yuꞌ gyiib zeꞌ. Bza dey lat tub cay. Orzeꞌ derepent la bzeeñ anc yu ub zi lay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Orzeꞌ gud lagy yu la coz guc. Orzeꞌ mnii tooy: ―Na gaal gud lagya̱ nu rishli Ñgyoozh bzuu nez mi tub anc nu blooy ya̱ yaa Herodes, nunu bloo chuy ya̱ lo dela coz nu ricy pee de mbecy Israeel gyicy nuy ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na ornu gud lagy yu ndeꞌ, orzeꞌ zay par yuꞌ Li, ñaa Waa, laab yu zeꞌ yu nu la Marc. Zigy mbecy byatublaazh dey zeꞌ nu rnii nu dey Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Orzeꞌ psiigy yu lo yaroꞌ ni loliꞌ. Orzeꞌ tub fiñ feñ nu la Rode bruuñ za güiiñ ben cyu ndeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tees ornu güeñ ñi nu zaab tiꞌ Bed, orzeꞌ byuꞌ loñ nu laab yu. Orzeꞌ par nu tantaꞌ la bet lagy ñi wanshaalaꞌñ roꞌ zeꞌ sinu carer la gush ñi zañ par lat de mbecy. Mniiñ nu zu Bed ich yuꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Orzeꞌ na dey: ―¡Ru tub mbecy ton! ―na dey. Tees bzu fert ñi nu laab rishli rniiñ. Orzeꞌ naꞌ dey: ―Par walab yu ndeꞌ, sinu yu zeꞌ tub anc nu nac nuy ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lat nu za fiñ mñaa zeꞌ, orzeꞌ fert la ca Bed rsiigy yu lo yaroꞌ ni loliꞌ zeꞌ. Orzeꞌ or guchi pshaal dey roꞌ. Na ornu bzaac dey Bed, tonaꞌ la za nu ic dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Orzeꞌ bicy Bed yaay par nu checa dey nu ricy yu zu redz. Orzeꞌ byooy rishlo dey lac bzac yu ornu Ñgyoozh bloom yu nañ yuꞌ gyiib. Orzeꞌ nay: ―Niir lo Santiag, gal nu lo deꞌ zir de bicy na de coz nu guc zeꞌ ―nay. Orzeꞌ bruuy zay tuubaꞌ lugaar. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na or bzaꞌ yu tuubaꞌ dzi, orzeꞌ tonaꞌ la pcan shcab ni de soldad. Orzeꞌ na dey rab yu losaꞌy: ―¿La bzac Bed? ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Orzeꞌ Herodes pcaay de mbecy nu yub yu Bed par wangyad yu. Orzeꞌ bdugyiꞌy lo de soldad nu rña zeꞌ. Orzeꞌ pcaay mbecy nu cut yu de soldad zeꞌ. Despuees ni de nu ndeꞌ, Herodes bruuy lo de yu ni Judea zay cyiiñ yu Cesarea. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Orzeꞌ Herodes tonaꞌ la guzi lagy yu lo de mbecy Tiro nu Sidón. Orzeꞌ tublaazh la gua güii dey yu. Nu loga la bicy dey Blasto par amig. Yu zeꞌ zuy riiñ nu riib ic yu nañ yuꞌ ni Herodes. Orzeꞌ mnishbaa dey lo Herodes nu cueꞌ chucoo nuy dey, gun de coz nu row dey druuñ de lugaar nu riib ic yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Orzeꞌ Herodes bzuy tub dzi nu nii nuy de mbecy zigy. Dzi zeꞌ bzuy negy nu rzu mbecy nu riib ic. Orzeꞌ gusub yu lo yashily, zeꞌ nu riib ic yu. Orzeꞌ mniiy riidz lo de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Orzeꞌ de mbecy brish ti dey. Orzeꞌ na dey: ―¡Yu nu rnii nu de ub na, yu re walab mbecy, sinu tub ñgyoozh! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Orzeꞌ tub anc ni Ñgyoozh lueg la pshet yaay Herodes. Bicy yu nu gush güiiy. Ni bicy anc zeꞌ, gun wangyicy zily yu Ñgyoozh. Orzeꞌ bdow byaꞌy gut yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Niga niga güeñ zir mbecy de riidz ni Ñgyoozh, nunu bicy cup zir dey consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Orzeꞌ blazh riiñ ni Bernabee nu Saulo Jerusaleeng. Gazeꞌ nu bish cya gaꞌ dey zay par Antioquía tuubaꞌ tir. Za nuy Waa. Laab yu zeꞌ yu nu la Marc. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lat de mbecy ni Crisht nu yuꞌ Antioquía yuꞌ la be mbecy nu rnii por cuen ni Ñgyoozh, nunu yuꞌ gaꞌ la be mbecy nu rlyuu coz ni Ñgyoozh. Tub yu lay Bernabee. Tuubaꞌy lay Simo̱o̱, laab yu zeꞌ yu nu la Cas. Tuubaꞌy lay Lucio, yu zeꞌ mbecy Cirene. Tuubaꞌy lay Manaén, yu nu tublaazh la bguul dey nu Herodes, yu nu byub ic Galilea. Tuubaꞌy lay Saulo. De yu zeꞌ zuy riiñ lat de mbecy ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Orzeꞌ tub dzi lat nu rzu bich dey nu nac Shuaan den, nunu lat nu rca dey ni ub yu nu cueꞌ gow yu gyit nu rzu bich dey nu nac Ñgyoozh, orzeꞌ na Espiriit Yon ni Ñgyoozh rab mi dey: ―Bloo reñ der Bernabee nu Saulo par nu gyicy dey riiñ nu pcui̱ nu gyicy yu ―nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Na ornu bded ni nu pca dey ni ub yu nu cueꞌ goy gyit lat nu mnii nu dey Ñgyoozh, orzeꞌ briib yaa dey too de yu zeꞌ. Orzeꞌ bzuu nez dey yu zay lo riiñ nu briic Espiriit Yon ni Ñgyoozh nu gyicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Orzeꞌ Espiriit Yon ni Ñgyoozh bzuu nez mi dey zay. Bruu dey Antioquía za dey par Seleucia. Zeꞌ gush dey tub barc zay par Chipre, tub nac yu nu ri lo nisyudoo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na ornu bri dey Salamina, tub gyedz nu ri lo yu ni Chipre, orzeꞌ pshaal dey riidz ni Ñgyoozh nañ de yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh. Waa za nuy dey par nu locyuub yu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bded dey lo yu nu ri lo nisyudoo zeꞌ. Orzeꞌ bri dey tub gyedz nu la Pafos. Zeꞌ bdzeel dey tub tuꞌ nu la Barjesús. Yu zeꞌ mbecy Israeel, nunu rniiy nu nac yu tub mbecy nu rnii por cuen ni Ñgyoozh, tees walab rishli. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yu zeꞌ nac nuy Sergio Paulo. Nunu Sergio Paulo, yu zeꞌ riib ic yu yu nu ri lo nisyudoo zeꞌ. Nac yu mbecy nu tonaꞌ la yuꞌ shcab ni. Orzeꞌ bredz yu Bernabee nu Saulo nu cha dey loy gun rlagy yu gyeñ yu riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Zeꞌ tuꞌ zeꞌ tuubaꞌ nu lay ndeꞌ Elimas. Orzeꞌ yu zeꞌ guay contr ni dey. Orzeꞌ bduꞌy lagy yu nu riib ic lo de yu zeꞌ, par nu cueꞌ gyicy cup yu consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Orzeꞌ Espiriit Yon ni Ñgyoozh briib ic zaꞌ lam nañ lardoo Saulo, laab yu zeꞌ yu nu la Baly. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Orzeꞌ Baly mbi la bgüiiy lo tuꞌ zeꞌ. Orzeꞌ nay: ―¡Mbecy rguu, mbecy rgubdzaa, ru nar gal nu na nuras! Ru zar contr ni dela coz nu seꞌñ, nunu rila wachecar nu rchaar dela riidz rishli ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Orzeꞌ na Ñgyoozh shet yaam ru. Na gyacaꞌ lor. Ru wazacaꞌr yaa ni doo par la be tiem ―nay. Orzeꞌ lueg la bet dzeeñ urlo Elimas. Orzeꞌ brugyiꞌ ryub yu ca na mbecy nu gan yu yaay nu lyuuy nez niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Orzeꞌ yu riib ic zeꞌ, ornu bzaac yu de coz nu guc, orzeꞌ bicy cup yu consuel lo Crisht. Tonaꞌ la za nu ic yu nu nac de riidz ni Shuaan den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Baly nu de losaꞌy bruuy Pafos, guꞌ dey nañ tub barc zay. Za dey par Perge, tub gyedz nu ri lo de yu nu la Panfilia. Tees zeꞌ bruu Waa lat dey. Bish cyay yay par Jerusaleeng. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Orzeꞌ bruu Baly nu de losaꞌy Perge. Zay par Antioquía, tub gyedz nu ri lo tub nac yu nu la Pisidia. Orzeꞌ sab, dzi nu rzu lagy mbecy Israeel, gua dey nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh. Orzeꞌ gusub dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na ornu blazh nu blab mbecy tub nac riidz nu taꞌ lo leey ni Ñgyoozh nu bzeeñ Moisees, gal nu tub nac riidz nu bzeeñ de yu nu mnii por cuen nim, orzeꞌ yu nu riib ic nañ yuꞌ zeꞌ bzeed yu raso̱o̱ lo Baly, gal nu lo de losaꞌy. Orzeꞌ nay: ―Bicy na, benu ricy cup ru tub consef, orzeꞌ gac niir lo de mbecy na la ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Orzeꞌ Baly wes suy. Bicy yaay par nu ri gua dey nu cueꞌ gyicy yu zu redz. Orzeꞌ brugyiꞌ rniiy. Orzeꞌ nay: ―Bzuub gyidag de ru mbecy Israeel nu de ru mbecy nu rca lagy lo Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ñgyoozh ni de mbecy Israeel pcuim de gyitoo bel ni den. Bicy mi nu byañ dey lat nu gabee rcyiiñ dey gal nu rcyiiñ mbecy yad lugaar nu la Egipto. Tonaꞌ la fert bicy num dey ornu bloom dey Egipto. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Orzeꞌ nañ cyuu ñaꞌn gugyeem lo dey lat nu shiñ bicy dey tub lugaar ub zi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Orzeꞌ mnit lom gagy nac mbecy nu pcyiiñ lo de yu nu la Canaán, nunu briic mi lugaar zeꞌ nu gani de mbecy nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Orzeꞌ nañ tap gaynal nu ñaꞌn, briic mi mbecy nu gyub ic dey por cuen nim. De yu zeꞌ byub ic yu gashtal pshuub la tiem ni Samueel, yu nu mnii por cuen nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Orzeꞌ bdiiñ dey lom nu cuic mi tub mbecy nu gac rey ni dey. Orzeꞌ Ñgyoozh briic mi Sauul, iꞌñ yu nu la Cis, nez Benjamiing, par nu gac rey ni dey nañ cyuu ñaꞌn. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Orzeꞌ despuees bloom Sauul nunu bicy mi nu byac Dabi rey ni dey. Ñgyoozh bzat mi Dabi ornu nam: “Ya̱ bzaaca̱ nu mod nu na Dabi iꞌñ Isaí nañ lardooy, ndeꞌ mod nu tonaꞌ la yet lagya̱. Yu zeꞌ gyicy yu dela coz nu rlagya̱”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ñgyoozh bicy mi nu Jesuuz, biñ nu bruu lat famil ni Dabi, byac mi biñ nu co mbañ de mbecy Israeel. Gulas mnii Ñgyoozh nu segur la ni gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Anzir nu cyid Jesuuz, Waa pshaal yu de coz ni Ñgyoozh lo de mbecy Israeel. Mniiy nu neꞌ dey dela coz cyi nu ricy yu, nunu zu nis dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ornu sñuu ga lazh de riiñ nu briic Ñgyoozh nu gyicy Waa, orzeꞌ nay rab yu de mbecy: “Ya̱ a̱ꞌ naca̱ biñ nu rnii too de ru nu naca̱, tees ornu lazh de coz nu ricya̱, orzeꞌ cyid tuubaꞌ mbecy. Ni gyid lab mi wangyapa̱ lo̱o̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Der bicy na nu nac nez Abraham, nunu de ru mbecy nu rca lagy lo Ñgyoozh nu yuꞌ lat ii, par de ub na bzeed Ñgyoozh riidz nu lac mod co mbañ mi den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tees de yu nu yuꞌ Jerusaleeng nu de yu nu riib ic dey wangad lagy dey cyu nac Jesuuz. Niꞌ ziꞌl wangyet lag dey cuen de riidz nu bzeeñ de mbecy nu mnii por cuen ni Ñgyoozh, de riidz nu rlab dey de sab la, dzi nu rzu lagy mbecy Israeel, nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh. Ndeꞌ nu mnii dey nu gat mi par nu byuꞌ niñ gal nu pcaa de yu nu mnii por cuen ni Ñgyoozh ornu mnii dey nu rlagy ñi gat mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mas wangyap dey ni tub la falt nim nu gyicy ñi nu gat mi, tees mnishbaa dey lo Pilato nu gyicy yu mandaar lo de mbecy nu cut dey mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Orzeꞌ bicy nu dey mi dela coz nu bi cañ nu gyicy nu dey mi, gal nu rniiñ lat de riidz ni Ñgyoozh. Gazeꞌ nu pshet dey mi lo cruuz. Orzeꞌ pcach dey mi nañ tub blyuu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tees Ñgyoozh bicy mi nu byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Orzeꞌ zañ dzi bruu zac mi lo de yu nu gusa num ornu bruum Galilea guam par Jerusaleeng. Na de yu zeꞌ mnii dey lo de mbecy Israeel nu bzaac dey nu byabañ mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Orzeꞌ de̱ ya̱ yap ne̱e̱ de̱ lo de ru tub riidz nu tonaꞌ la cyit na. Riidz zeꞌ, ndeꞌ coz nu mnii Ñgyoozh lo de gyitoo bel ni den nu segur la gyicy mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Coz zeꞌ bicy mi nu byuꞌ niñ par de ub na, gun laab nez den de gyitoo bel zeꞌ. Ni bicy mi ornu bicy mi nu byabañ Jesuuz. Ni rniiñ lo salmo cyup ornu Ñgyoozh nam: “Ru nac ru Iꞌña̱. Dzi na ya̱ gyicya̱ nu cui mbañ ru”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Niꞌ ziꞌl mnii Ñgyoozh lat de riidz nim, ornu mniim nu gyicy mi nu gyabañ Jesuuz, nunu wazaan mi nu gadz cuerp nim. Orzeꞌ nam rab mi biñ nu pcuim: “Ya̱ tonaꞌ la nap gyicy du̱ ru gal nu mne̱e̱ lo Dabi nu segur la gyicya̱”, nam. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Zeꞌ tuubaꞌ lugaar mnii yu nu mnii por cuen nim rab yum: “Ru wazaan ru nu gadz cuerp ni biñ Yon nir”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tees tiem nu pcyiiñ Dabi gyishlombecy, bicy yu de coz nu rlagy Ñgyoozh nu gyicy yu. Gazeꞌ nu gut yu. Pcach dey yu lat de baa ni gyitoo bel ni den. Orzeꞌ byayu cuerp niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tees biñ nu bicy Ñgyoozh nu byabañ, mi zeꞌ wangadz cuerp nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Orzeꞌ na der bicy na, ya̱ rne̱e̱ lo der coz nu rlagy ñi nu gad lagy der nu Ñgyoozh gyicy sulagy mi ni mbecy nu nac Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nunu rlagy ñi gad lagy der nu dela mbecy nu gyicy cup consuel lo Crisht gla dey ni dela cyi. Zeꞌ leey nu bzeeñ Moisees wancyiiñ ñi nu gyicy ñi nu la de mbecy ni de cyi nu ricy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Orzeꞌ bicy cuidad der nis zac ru coz nu mnii de yu nu mnii por cuen ni Ñgyoozh gulas, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ornu pcaa dey gal nu Ñgyoozh mniim: De ru mbecy rgubdzaa, güii der. Gua nu ic der, nunu gat der, gun coz nu gyicya̱ tiem nu cyiiñ ru gyishlombecy ii, ndeꞌ tub coz nu rila wayeña lagy ru. Mas shaal mbecy coz zeꞌ lo der, tees wayeña lagy ru, nam ―na Baly rab yu de mbecy nu nguaa nañ yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na lat nu bruu Baly nu Bernabee nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh, orzeꞌ de mbecy nu walab mbecy Israeel nese nu gul yu mniiy nu cha gaꞌ dey nañ yuꞌ zeꞌ tuubaꞌ sab, dzi nu zu lagy dey, nunu nii zir dey de coz zeꞌ lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na ornu blaazh brush las de mbecy, orzeꞌ zañ mbecy Israeel, nunu zañ mbecy nu gush leey ni de mbecy Israeel guaca dey ich Baly nu Bernabee. Orzeꞌ Baly briic yu consef ni dey, nunu mniiy nu zaab gash la dey de coz nap nu rbic Ñgyoozh niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Orzeꞌ tuubaꞌ sab, dzi nu rzu lagy mbecy, tonaꞌ la mbecy zigy byatublaazh yu. Sñuu ga ziꞌl mbecy ricy falt par nu lazh dela mbecy gyedz zeꞌ. Byatublaazh dey par nu zuub gyidag yu de riidz ni Shuaan den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na ornu de mbecy Israeel bzaac dey de mbecy zigy zeꞌ, orzeꞌ tonaꞌ la bicy saap lagy dey ich Baly nu Bernabee. Orzeꞌ mnii dey riidz nu za contr ni riidz nu mnii Baly, nunu gugy zi dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Orzeꞌ Baly nu Bernabee fert zir mnii dey. Orzeꞌ na dey: ―Rlagy ñi nu nu loga la shaal de̱ riidz ni Ñgyoozh lo de ru. Tees como de ru rzu chu der de riidz zeꞌ, nunu como de ru ricy der ub ru par mbecy nu wangyap nu cui mbañ tub la, orzeꞌ de̱ ya̱ zaan de̱ de ru. Na cha̱ de̱ lat de mbecy nu walab mbecy Israeel, ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","gun ni bicy Shuaan den mandaar ornu nam: Ya̱ bicya̱ nu nar gal nu na tub yaa par nu zac de mbecy nu walab mbecy Israeel. Ya̱ gyicya̱ nu dela mbecy nu yuꞌ gal nu blaazhaꞌ zir zeꞌ nu zet ni gyishlombecy cui mbañ dey nu nac ru, nam ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na ornu güeñ de mbecy nu walab mbecy Israeel de riidz zeꞌ, orzeꞌ tonaꞌ la bet lagy dey, nunu bicy zily dey riidz ni Ñgyoozh. Nunu de yu nu bi pcui Ñgyoozh par nu cui mbañ yu tub la, brugyiꞌ ricy cup dey consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Orzeꞌ brush las riidz ni Ñgyoozh par dutuub la lugaar gaab ga ni Antioquía ni Pisidia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tees de mbecy Israeel pchaꞌ dey ic de mbecy zub lo gyedz zeꞌ, nunu pchaꞌ dey ic de biñ mñaa lily nu walab mbecy Israeel, de biñ mñaa nu driib zily Ñgyoozh. Orzeꞌ de mbecy zeꞌ brugyiꞌ ricy dey nu rsheed zi dey Baly nu Bernabee. Orzeꞌ pcyuu nu dey yu lo de yu ni dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Orzeꞌ Baly nu Bernabee bdib dey gyid lab yu par tub muesht nu gabe nu wangash de mbecy gyedz zeꞌ dey. Orzeꞌ bruu dey lugaar zeꞌ, zay tub gyedz nu la Iconio. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tees de mbecy Antioquía ni Pisidia nu ricy cup consuel lo Crisht tonaꞌ la zu cyit lagy dey, nunu riib ic zaꞌ la Espiriit Yon ni Ñgyoozh nañ lardoo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na Iconio tublaazh la gua Baly nu Bernabee nañ yuꞌ nu rsyaꞌ de mbecy Israeel riidz ni Ñgyoozh. Tonaꞌ la nap mnii dey. Ndeꞌ nu tonaꞌ la mbecy zigy bicy cup dey consuel lo Crisht. Yuꞌ mbecy Israeel bicy cup yu consuel lo Crisht, nunu yuꞌ gaꞌ mbecy nu walab mbecy Israeel bicy cup yu consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tees de mbecy Israeel nu wangyicy cup consuel lo Crisht bicy dey nu pchaꞌ ic mbecy nu walab mbecy Israeel, nunu bicy dey nu bish cya dey ich de bicy na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tees Baly nu Bernabee tuñ pcyiiñ dey lugaar zeꞌ. Wanchib la dey pshaal yu riidz ni Shuaan den. Mnii dey nu tonaꞌ la nap ricy num mbecy, nunu mi zeꞌ bicy mi nu gud lagy de mbecy nu de riidz nu rnii dey, ndeꞌ coz nu laab ñi. De mbecy gud lagy dey nu riidz zeꞌ rishli, gun Shuaan den briic mi mod nu gyicy dey nusuriidz gal nu de coz nu ricy nu za nu ic mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Orzeꞌ dela mbecy gyedz zeꞌ byac cup shcab ni dey. Tub nac yu guc nuy de mbecy Israeel, tub nacaꞌy guc nuy Bernabee nu Baly. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Orzeꞌ de mbecy nu walab mbecy Israeel, nu de mbecy Israeel, nu de yu nu riib ic ni dey, laab de yu zeꞌ mnii too dey nu shiñ gyicy nu dey Baly nu Bernabee. Orzeꞌ mnii too dey nu goow gyitaꞌy Baly nu Bernabee gashtal gat la dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Na ornu gud lagy Baly nu Bernabee, orzeꞌ bruu chu dey. Zay par lo de yu ni Listra nu Derbe, cyup gyedz nu ri lo de yu nu la Licaonia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Zeꞌ pshaal dey de riidz nu sac ni Jesuuz. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra zu tub mbecy coj. Yu zeꞌ zub ziꞌl yu, gun gaal ziꞌl nu gul yu rila wagac zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Zeꞌ güeñ yu riidz nu rnii Baly. Orzeꞌ Baly gud lagy yu nu ricy cup yu zeꞌ consuel lo Crisht, nunu ndeꞌ nu gac gyac yu. Orzeꞌ Baly mbi la bgüiiy loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Orzeꞌ ye la brish tiy. Orzeꞌ nay: ―¡Wes su nunu li bzu! ―nay. Orzeꞌ rzab lay wes suy. Nunu brugyiꞌ lay rzay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Na ornu de mbecy zigy bzaac dey nu ni bicy Baly, orzeꞌ brugyiꞌ nu rbish ti dey. Orzeꞌ na dey nu riidz yu, riidz Licaonia: ―¡De ñgyoozh gush dem mod nu na mbecy, nunu bet dem gashtal lo la den ii! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mnii dey nu Bernabee nac yu tub ñgyoozh nu la Júpiter. Zeꞌ Baly mnii dey nu nac yu tub ñgyoozh nu la Mercurio, gun yu zeꞌ yu nu rnii. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Orzeꞌ de uz nu zu riiñ nañ yuꞌ ni ñgyoozh Júpiter, yuꞌ nu zub ruꞌ gyedz, orzeꞌ uz zeꞌ gua nuy la be tor nu gyee. Yu zeꞌ nu de mbecy ngulagy dey ñgyuut yu chigud zeꞌ nu cuic dey tub gun lo Baly, gal nu lo Bernabee. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na ornu Baly nu Bernabee güeñ dey de coz nu rlagy de yu zeꞌ nu gyicy yu, orzeꞌ pshaa la dey shab yu, nunu gush dey carer guꞌy lat de mbecy zigy zeꞌ. Orzeꞌ brish ti dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Orzeꞌ nay: ―Der mbecy, ¿lagu ni ricy der? De̱ ya̱ nac de̱ mbecy gal nu naꞌ ziꞌl de ru. Nunu de̱ ya̱ yap de̱ ii par nu rica̱ nu gad lagy der nu laa yaa der de coz nu rila wacyiiñ ii, nunu “O” nii der ni Ñgyoozh mbañ, biñ nu psaꞌ lagy gyibaa, nu gyishlombecy, nu nisyudoo, nu dela coz nu yuꞌ de lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Gulas Ñgyoozh bzaan mi nu gyicy mbecy la ziꞌl coz nu rlagy ub yu gyicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tees dub laa tiem rlyuum cyu nac mi ornu ricy mi coz nap. Ricy mi nu yet gyey, nunu rbic mi cosech. Rbic mi coz nu gow der, nunu ricy mi nu zu cyit lagy der ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mas nu de riidz zeꞌ, tees tonaꞌ la biigy par nu cay ni dey nu cueꞌ cut dey de tor zeꞌ par tub gun nu cha lo dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Orzeꞌ la be mbecy Israeel bruu dey Antioquía ni Pisidia, nunu bruu gaꞌ dey Iconio. Orzeꞌ za dey par Listra. Zeꞌ bduꞌ dey lagy de mbecy zigy nu cha dey contr ni Baly. Orzeꞌ de mbecy pshet dey gyitaꞌ Baly nu ñgyut dey yu. Orzeꞌ bgayu tuñ la dey yu par ruꞌ gyedz, gun psaꞌ lagy dey nu gut yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tees ornu de mbecy nu ricy cup consuel lo Crisht byatublaazh dey lo Baly, orzeꞌ weshtey. Orzeꞌ guꞌ gaꞌy lat gyedz tuubaꞌ tir. Na tuubaꞌ dzi Baly nu Bernabee bruu dey Listra za dey par Derbe. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Orzeꞌ Baly nu Bernabee pshaal dey riidz nu sac ni Crisht Derbe, nunu pshet gras dey lardoo zañ mbecy par nu gyicy cup dey consuel lo Crisht. Orzeꞌ bish cya dey. Bruu dey Derbe zaꞌy par Listra. Orzeꞌ bruu dey Listra. Zay par Iconio. Orzeꞌ bruu dey Iconio. Za dey par Antioquía ni Pisidia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nez nu za dey, gua zaab lo dey de mbecy ni Crisht nu yuꞌ de lugaar zeꞌ. Bicy dey nu byafert dey nu nac de coz ni Crisht, nunu mnii dey nu gyicy paa dey nu de riidz nim nu bi güeñ dey. Blyuu dey ni dey. Orzeꞌ na dey: ―Zañ coz deet rlagy ñi nu zac na par nu chuꞌn lo gyel gubier ni Ñgyoozh ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Baly nu Bernabee bloo su dey yu bel ni tub nac ga de mbecy ni Crisht. Orzeꞌ mnii nu dey Ñgyoozh, nunu pca dey ni ub yu nu cueꞌ goy gyit. Orzeꞌ bzeeñ dey de yu bel zeꞌ yaa Ñgyoozh, biñ nu ricy cup dey consuel lo, par nu güiim dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Na ornu bded dey lo de yu ni Pisidia, orzeꞌ bruꞌña dey lo yu ni Panfilia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Orzeꞌ za dey tub gyedz nu la Perge. Zeꞌ pshaal dey de riidz ni Crisht. Orzeꞌ bruu dey Perge, za dey par Atalia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Zeꞌ gush dey tub barc. Orzeꞌ za dey par Antioquía, zeꞌ nu bguꞌ mbecy dey yaa Ñgyoozh par nu locyuub mi dey nunu par nu güiim dey lat nu gyicy yu riiñ nim, riiñ zeꞌ nu bi bzaꞌ lo dey na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Na ornu bruꞌña dey Antioquía, orzeꞌ bicy tublaazh dey de mbecy ni Crisht. Orzeꞌ pshaal dey lo de mbecy zeꞌ dela coz nu bicy nu Ñgyoozh dey. Pshaal dey nu lac mod bicy Ñgyoozh par nu byaal nez nu cha dey lo de mbecy nu walab mbecy Israeel, gun orzeꞌ de yu zeꞌ gac gyicy cup dey consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Orzeꞌ tuñ tiem byeeñ dey lugaar zeꞌ nu de mbecy ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Orzeꞌ la be mbecy bruu dey lo de yu ni Judea guay Antioquía. Orzeꞌ blyuu dey ni de bicy na. Orzeꞌ na dey: ―Wac ruu mbañ den benu waca beey sircunsision cuerp ni den gal nu rniiñ lo leey nu bzeeñ Moisees ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Orzeꞌ Baly nu Bernabee fert la mnii dey nu walab ni. Orzeꞌ zi ga la bee nu dey yu riidz. Orzeꞌ de mbecy mnii too dey nu Baly nu Bernabee nu la be mbecy nu yuꞌ Antioquía, de yu zeꞌ rlagy ñi cha dey par Jerusaleeng par nu cha güii dey de aposht nu de yu bel, gun orzeꞌ cugyiꞌ dey nu nac de coz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Orzeꞌ de mbecy ni Crisht zeꞌ bzuu nez yu dey zay. Lat nu za dey lo yu ni Fenicia gal nu lo yu ni Samaria, orzeꞌ bdzeel dey de mbecy ni Crisht. Orzeꞌ byoo dey rishlo dey lac mod guc. Orzeꞌ mnii dey nu de mbecy nu walab mbecy Israeel byac dey mbecy ni Ñgyoozh. Ornu güeñ de mbecy nu yuꞌ lugaar zeꞌ ndeꞌ, orzeꞌ tonaꞌ la bet lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Na ornu bri dey Jerusaleeng, orzeꞌ de mbecy ni Crisht, nu de aposht, nu de yu bel, de yu zeꞌ gua nii nu dey yu ñgyoozh. Orzeꞌ Baly nu Bernabee byoo dey rishlo dey nu lac mod bicy nu Ñgyoozh dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Orzeꞌ la be mbecy nu ricy cup consuel lo Crisht, yu nu gunash leey ni de mbecy fariseo, orzeꞌ wes su dey. Orzeꞌ na dey: ―Rlagy ñi caan de mbecy ni Crisht nu walab mbecy Israeel nu caa dey beey sircunsision cuerp ni dey, nunu rlagy ñi caan dey nu gyicy yac yu nu leey nu bzeeñ Moisees ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Orzeꞌ de aposht nu de yu bel byatublaazh dey par nu go dey riidz nu nac de coz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Na ornu blazh bee dey riidz, orzeꞌ wes su Bed. Orzeꞌ nay: ―Der bicy na, de ru rad lagy der nu tonaꞌ la gulas pcui Ñgyoozh ya̱ lat de ru par nu shaala̱ de riidz ni Crisht lo de mbecy nu walab mbecy Israeel, gun orzeꞌ gyeñ dey, nunu gyicy cup dey consuel lom. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ñgyoozh, biñ nu rad lagy la na lardoo mbecy, bicy mi nu rad lagy den nu cyiiñ de mbecy nu walab mbecy Israeel nu gac dey mbecy ni Crisht. Ni bicy mi ornu briic mi Espiriit Yon nim ni dey gal nu bicy nuꞌm de ub na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mod nu bicy num de ub na laab niꞌ ziꞌl mod bicy num dey. Bicy sulagy mi de cyi nu bicy dey, gun ricy cup dey consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Orzeꞌ na ¿lagu rlagy der gyicy ru preb Ñgyoozh ornu ricy der nu deet rzac de mbecy nu ricy cup consuel lo Crisht? Coz nu rnii der nu gyicy dey, ndeꞌ coz nu wagyee den, gal nu de gyitoo bel ni den wangagyee dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Zeꞌ de ub na rzeña lagy den nu gruu mbañ na nu nac faboor nu ricy nu Shuaan den Jesuuz. Niꞌ ziꞌl de yu zeꞌ ―na Bed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Dela mbecy gucua ri dey ornu güeñ dey nu rnii Baly nu Bernabee, ornu bzeed cuen dey lo dey dela coz ily nu bicy Ñgyoozh, nunu dela nusuriidz nu bicy mi lat de mbecy nu walab mbecy Israeel lat de riiñ nu bicy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Na or blazh nu mnii Baly nu Bernabee, orzeꞌ na Santiag rab yu de mbecy: ―Bzuub gyidag der, bicy na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo̱o̱ Bed bi byoo gaꞌy rishlon mod nu bicy Ñgyoozh num de mbecy nu walab mbecy Israeel ornu nap bicy num dey tir loga la. Bloo sum tub nac mbecy nu gac nim lat dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Niꞌ ziꞌl yaruu riidz nu pcaa de yu nu mnii por cuen ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Orzeꞌ na Ñgyoozh: Or lazh ndeꞌ, orzeꞌ ya̱ cush cya̱ locyuuba̱ de nez Dabi, gun mnu nez Dabi, tees ya̱ zu napa̱ ñii. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Gun orzeꞌ dela deꞌ zir mbecy yub dey Shuaan yu. De lo la mbecy nu ya̱ pcui̱ nu gac ne̱ yub dey ya̱. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ni na Ñgyoozh, biñ nu bi gulas briic nu gad lagy de mbecy de ndeꞌ, rniiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Niꞌ ya̱ rsaꞌ lagya̱ nu walagy ñi nu gyicy deet den nu de mbecy nu walab mbecy Israeel, de yu nu yac mbecy ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tees rlagy ñi caan tub gyicy zeed na lo dey. Rlagy ñi niin lo dey nu cueꞌ gow dey de coz nu a̱ꞌ yad ñi nu gow yu. Cueꞌ gow dey de gun nu briic mbecy lo nab. Rlagy ñi niin nu cueꞌ gal dey de mbecy nu wanchelaay, nunu cueꞌ gow dey bañcyug nu psi̱i̱ mbecy yeñ, nunu cueꞌ gow dey reñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gun nese gulas nu gashtal dzi na rlab mbecy leey nu bzeeñ Moisees nañ de yuꞌ nu rsyaꞌ de losaꞌn riidz ni Ñgyoozh. De sab la, dzi nu rzu lagy mbecy, rlab dey riidz nim, nunu dela gyedz rshaal mbecy riidz zeꞌ nim ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Orzeꞌ de aposht, nu de yu bel byatublaazh dey, nu dela mbecy ni Crisht. Orzeꞌ mnii too dey nu co su dey la be mbecy lat dey, par nu cha nu dey Baly nu Bernabee par Antioquía. Orzeꞌ bloo su dey Judas, laab yu zeꞌ yu nu la Barsabás, nunu niꞌ ziꞌl bloo su gaꞌ dey Silas. De yu zeꞌ mbecy nu rca lagy de bicy na lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Orzeꞌ briic dey tub gyicy za nu dey. Gyicy zeꞌ rniiñ: “De̱ ya̱, nu de aposht, nu de yu bel, nu de bicy na, zeed de̱ ñgyoozh ni de ru bicy na nu walab nez de mbecy Israeel. Zeed de̱ ñgyoozh ni de ru mbecy nu yuꞌ Antioquía, nunu niꞌ ziꞌl ni de ru mbecy nu yuꞌ lo yu ni Siria, nunu niꞌ ziꞌl ni de ru mbecy nu yuꞌ lo de yu ni Cilicia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bi güeñ de̱ nu la be mbecy nu bruu lat de̱ bruꞌña dey lat der nu bicy dey nu rac deet nañ shcab ni der nu nac de coz nu rnii dey. Tees de̱ ya̱ wanne̱e̱ de̱ lo dey nu ni gyicy yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ndeꞌ nu na byatublaazh de̱, nunu bicy de̱ tub ziꞌl shcab nu pcui̱ de̱ la be mbecy nu cyid tooy rishlo der. Orzeꞌ bzuu nez de̱ yu cyid yu lo der. Yad nu dey Bernabee nu Baly, de yu nu dzi rca den. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","De yu zeꞌ mas rlagy mbecy cut yu dey, tees ricy paa dey nu coz nu rlagy Shuaan den Jesucrisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Orzeꞌ gzuu nez de̱ Judas, nu Silas nu cyid yu lo der, gun orzeꞌ nii dey lo der par nu gyeñ gyidag la der dela coz nu ca̱a̱ de̱ lo gyicy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gun Espiriit Yon ni Ñgyoozh nu de̱ ya̱ rze̱e̱ nu walagy ñi ca̱a̱ de̱ reñaꞌ coz nu gyicy der, sinu de coz nu rlagy ñi gyicy der, de coz nu zat de̱ lo gyicy ii. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Cueꞌ gow der coz nu rbic mbecy lo nab. Cueꞌ gow der reñ, nunu cueꞌ gow der bañcyug nu gut nu psi̱i̱ mbecy yeñ. Cueꞌ gal der de mbecy nu wanchelaar. Tonaꞌ la nap gyicy der benu cueꞌ la gyicy der de coz zeꞌ. Bi nii gaꞌn.” Ni cañ lo gyicy zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Orzeꞌ bzuu nez dey de mbecy zeꞌ za dey par Antioquía. Na ornu bri dey Antioquía, orzeꞌ byatublaazh dela mbecy nu ricy cup consuel lo Crisht. Orzeꞌ briic dey gyicy zeꞌ nu syaꞌ dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na ornu psyaꞌ de mbecy gyicy zeꞌ, orzeꞌ riidz nu taꞌ loñ bicy ñi nu tonaꞌ la bet lagy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nu Silas, como nac dey mbecy nu rnii por cuen ni Ñgyoozh, chi ñuu mniiy lo de bicy na. Briic yu baloor ni dey, nunu bicy fert yu dey nu nac de coz ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Na ornu bi rac la be tiem nu rcyiiñ dey lugaar zeꞌ, orzeꞌ de bicy na mnii nu dey yu ñgyoozh. Orzeꞌ bruu dey yay lo de mbecy nu bzuu nez yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tees Silas mnii tooy nu gyiyeeñ gay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Niꞌ Baly nu Bernabee byeeñ dey Antioquía. Bicy dey riiñ tublaazh nu zigy deꞌ zir mbecy. Blyuu dey ni de mbecy, nunu pshaal dey riidz ni Shuaan den lo de mbecy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Despuees, or gules, orzeꞌ na Baly rab yu Bernabee: ―Yaa chan cha güiin de bicy na nu yuꞌ dela gyedz zeꞌ nu pshaal na de riidz ni Shuaan na. Cha güiin la ricy dey ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tees Bernabee rlagy yu cha nuy Waa. Laab yu zeꞌ yu nu la Marc. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Zeꞌ Baly psaꞌ lagy yu nu a̱ꞌ nap nu cha nu Waa dey, gun bzeen gay riiñ nu bicy dey ornu pcyiiñ dey Panfilia, nunu wangyicyaꞌy riiñ nuy dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Orzeꞌ bee zi dey riidz nu losaꞌy. Orzeꞌ bicy zet lagy dey lo losaꞌy. Orzeꞌ Bernabee za nuy Marc. Orzeꞌ gush dey tub barc nu za par Chipre. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Zeꞌ Baly bloo suy Silas par nu gac losaꞌy. Orzeꞌ de mbecy bzeeñ dey Baly yaa Ñgyoozh par nu locyuub mi yu, nunu güiim yu. Orzeꞌ bruuy Antioquía zay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Orzeꞌ bded yu lo yu ni Siria, nunu bdedaꞌy lo yu ni Cilicia. Lat nu gua zaab loy de mbecy ni Crisht, orzeꞌ bicy fert yu dey nu nac coz nim. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Orzeꞌ Baly zay par Derbe nu Listra. Zeꞌ bdzeel yu tub mbecy nu ricy cup consuel lo Crisht nu la Timoteo. Yu zeꞌ iꞌñ tub biñ mñaa Israeel. Zeꞌ uz yu nac yu mbecy griego. Ñaay laab mbecy ni Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Orzeꞌ dela bicy na nu yuꞌ Listra, nunu dela bicy na nu yuꞌ Iconio nap mnii dey niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Baly rlagy yu cha nuy Timoteo, ndeꞌ nu pcaay beey sircunsision cuerp niy. Ni bicy Baly, gun dela mbecy Israeel nu yuꞌ de lugaar zeꞌ gud lagy yu nu uz Timoteo nac yu tub mbecy griego. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Orzeꞌ lat nu gusa dey dela gyedz, blyuu dey ni de mbecy gal nu mnii de aposht nu de yu bel nu yuꞌ Jerusaleeng ornu byatublaazh dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Orzeꞌ dela mbecy ni Crisht fert zir guc nu dey de coz nim, nunu tub dzi ga ryañ zir dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Espiriit Yon ni Ñgyoozh wansaan mi nu shaal dey riidz ni Crisht lo de mbecy Asia, ndeꞌ nu bded dey dub tuuñ la zeꞌ nu ñgyiid ruꞌ yu ni Frigia nu Galacia. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Na ornu bri dey ruꞌ bzaa ni Misia, orzeꞌ bicy pee dey ñgyay lo de yu nu la Bitinia. Tees Espiriit ni Jesuuz wansaan mi nu ñgya dey lugaar zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Orzeꞌ bded nez ziꞌl dey lo yu ni Misia. Gazeꞌ nu za dey par Troas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na ornu bri dey Troas, orzeꞌ rel bdeꞌ lo Baly. Bzaac yu tub mbecy Macedonia mod ni pcaal. Orzeꞌ mnishbaay lo Baly. Orzeꞌ nay: “Cyid ru par Macedonia nu locyuub ru de̱ ya̱”, nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Orzeꞌ cuanzir bzaac Baly ndeꞌ, orzeꞌ bzu lily de̱ nu cha̱ de̱ par Macedonia, gun mnii to̱o̱ de̱ nu Ñgyoozh bredz mi de̱ ya̱ par nu shaal de̱ de riidz nap ni Crisht lo de mbecy nu yuꞌ zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Orzeꞌ Troas brush de̱ tub barc. Za̱ de̱ par lo tub nac yu nu ri lo nisyudoo nu la Samotracia. Orzeꞌ bru̱u̱ de̱ zeꞌ. Orzeꞌ tuubaꞌ dzi bri̱ de̱ tub gyedz nu la Neápolis. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Orzeꞌ bru̱u̱ de̱ zeꞌ. Za̱ de̱ gyedz nu la Filipos. Filipos, ndeꞌ tub gyedz nu bzaa de mbecy Rom, nunu ndeꞌ gyedz nu ricy ñi presis ni de lugaar ni Macedonia zeꞌ. Orzeꞌ zeꞌ byeeñ de̱ la be dzi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Orzeꞌ sab, dzi nu rzu lagy mbecy Israeel, orzeꞌ bru̱u̱ de̱ par ruꞌ gyedz. Za̱ de̱ par ruꞌ gyoow, zeꞌ nu psaꞌ lagy de̱ nu gyatublaazh mbecy nu nii nu dey Ñgyoozh. Orzeꞌ gucua̱ de̱ zeꞌ rdo̱ de̱ de riidz nu sac ni Crisht nu de biñ mñaa nu byatublaazh zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Zeꞌ tub biñ mñaa nu güeñ riidz nu rdo̱ de̱, mi zeꞌ lam Lidia. Mi zeꞌ mbecy Tiatira nunu ricy mi dalje̱z nu rut mi negy bizat. Nac mi tub mbecy nu rca Ñgyoozh, nunu Shuaan den pshaal mi shcab nim par nu gyet lag mi cuen de riidz nu mnii Baly. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Orzeꞌ briib nis dey mi, nunu briib nis dey dela famil nim. Orzeꞌ mnishbaam lo de̱. Orzeꞌ nam: ―Yaa gyan cyiiñ der yu̱ꞌ benu rash der shcab nu ya̱ rishli ricy cupa̱ consuel lo Shuaan na ―nam. Orzeꞌ pcuugy mi lardo̱o̱ de̱ nu gya̱ de̱ yuꞌm. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Orzeꞌ tub dzi ornu za̱ de̱ zeꞌ nu ryatublaazh mbecy par nu rnii nu dey Ñgyoozh, orzeꞌ bdzeel de̱ tub fiñ feñ nu nac moz por fers la ni mbecy. Tub nuras bicy niy fiñ zeꞌ, nunu rbooñ cuen par nu nac nuras zeꞌ. Tonaꞌ la sheñ tiñ rad ni patro̱o̱ ñiñ nu nac nu rbooñ cuen. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tees biid cañ ich de̱ nu Baly, orzeꞌ brugyiꞌ ye la rbish tiñ. Orzeꞌ nañ: ―¡De mbecy re ricy mi coz nu rnii Ñgyoozh biñ nu zily zir nac! ¡Rbic mi nu gad lagy der lac mod ruu mbañ ru! ―naañ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Zañ dzi ni bicy ñi gashtal ornu bdzaꞌ Baly niñ. Orzeꞌ bish cyay bgüiiñ loñ. Orzeꞌ nay rab yu nuras zeꞌ: ―Par nu nac rishbeey ni Jesucrisht, ya̱ rne̱e̱ lor nu ruu chur lo fiñ ii ―nay. Orzeꞌ lueg la bruu nuras zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Na ornu de patro̱o̱ ni fiñ feñ zeꞌ gud lagy dey nu wadaꞌ mod nu gyicy dey gan tiñ nu nac ñii, orzeꞌ bduꞌ yaa dey Baly nu Silas. Gua nu dey yu lo de fushtiz loliꞌ zeꞌ nu rgua de yu zu riiñ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na ornu bruꞌña dey lo de fushtiz, orzeꞌ na dey: ―De mbecy ii nac dey mbecy Israeel, nunu ricy dey coz deet ledz na. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Rlyuu dey nu gyicy na coz nu cha contr ni leey. Como de ub na nac na mbecy Rom, ndeꞌ nu wac nii den nu nap de coz nu rnii dey. Ni wac gyicy den gal nu rlagy dey ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Orzeꞌ niꞌ de mbecy zigy bish cya dey ich dey. Orzeꞌ de fushtiz por fers la bloo dey shab dey. Orzeꞌ pcaa dey mbecy nu gaaz dey yu nu laspeed. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Na despuees ornu dzi bi bgaaz dey yu, orzeꞌ mneꞌ dey yu nañ yuꞌ gyiib. Orzeꞌ pcaa dey de yu nu riib ic yuꞌ gyiib zeꞌ nu nap gyicy segur yu dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na ornu bi guꞌ riiñ zeꞌ yaa yu nu riib ic zeꞌ, orzeꞌ mneꞌy de yu zeꞌ gal zeꞌ nu gyi zir ni nañ yuꞌ gyiib zeꞌ. Orzeꞌ briy gyiꞌ de yu zeꞌ nañ gyeegy nu zub gazel cyup ya gyibag. Gazeꞌ nu bicy nicy dey ñi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Orzeꞌ tub guzeel rel, Baly nu Silas rnii nu dey Ñgyoozh, nunu rul dey lom. Nunu reñ dela de pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Orzeꞌ derepent la briib tub duru ily. Orzeꞌ pcueñ yuꞌ gyiib gashtal zeꞌ nu zu laa simient niñ. Orzeꞌ lueg la byaal dela roꞌ, nunu bet lag dela caden nu pcacuuñ dey de pres. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Orzeꞌ yu nu riib ic yuꞌ gyiib zeꞌ brish yu yaa. Na ornu bzaac yu nu naal dela roꞌ ni yuꞌ gyiib, orzeꞌ psaꞌ lagy yu nu briib dze dela pres. Orzeꞌ blooy mandzicy niy nañ gyid yuꞌñ, nunu bicy peey nu ñgyuut yu ub yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Orzeꞌ brish ti Baly. Gazeꞌ nu nay: ―¡Cueꞌ shiñ gyicy nur ub ru gun ii yu̱ꞌ dela de̱! ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Orzeꞌ yu nu riib ic zeꞌ bredz yu mbecy nu cha nuy gyi. Orzeꞌ carer la guꞌy nañ yuꞌ zeꞌ. Nunu rash la bis yu nu tantaꞌ gudzib yu. Orzeꞌ wes saa lay yeñ gyiꞌ Baly nu Silas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Orzeꞌ blooy de yu zeꞌ lugaar zeꞌ. Gazeꞌ nu nay rab yu dey: ―¿La ñuu coz rlagy ñi nu gyicya̱ par nu ruu mbaña̱? ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Orzeꞌ na Baly nu Silas: ―Bicy cup consuel lo Shuaan den, Jesucrisht. Orzeꞌ ruu mbañ ru nu dela famil nir ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Orzeꞌ pshaal dey riidz ni Shuaan den loy nu lo dela mbecy nu rcyiiñ loy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na laab or zeꞌ yu nu riib ic zeꞌ za nuy dey nu bdiib yu zeꞌ nu guud güii ni dey. Orzeꞌ lueg la wi nis yu nu dela famil niy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Orzeꞌ ya nuy Baly nu Silas. Gup yu par nañ yuꞌy nuy dey. Zeꞌ briic yu coz nu gow dey. Orzeꞌ mbecy nu riib ic zeꞌ nu dela famil niy tonaꞌ la gucyit lagy dey gun bi ricy cup dey consuel lo Crisht. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Na tuubaꞌ dzi or napor, orzeꞌ de fushtiz bzuu nez dey ayudant ni dey lo yu nu riib ic zeꞌ. Orzeꞌ na dey rab yuy: ―Blaa de mbecy zeꞌ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Orzeꞌ yu riib ic zeꞌ gua mniiy lo Baly. Orzeꞌ nay: ―De fushtiz bzeed dey raso̱o̱ nu la̱a̱ ru nu Silas. Orzeꞌ na ruu der. Gac gya der dub gusht la ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Orzeꞌ na Baly rab yu ayudant zeꞌ: ―Pshet dey yag ich de̱ lo rgüii la de mbecy zigy, nunu ii nigul ri bee dey de̱. Nunu de̱ ya̱ nac de̱ mbecy Rom. Zeꞌ ii mneꞌ dey de̱ ya̱ nañ yuꞌ gyiib. Orzeꞌ na rlagy dey coy de̱ ya̱ dze ga. Rila wac. Ub la de fushtiz rlagy ñi nu cyid dey coy de̱ ya̱ ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na de ayudant gua niiy lo de fushtiz de riidz nu mnii Baly. Na ornu güeñ de fushtiz nu Baly nu Silas nac dey mbecy Rom, orzeꞌ tonaꞌ la gudzib dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Orzeꞌ za dey lo Baly nu lo Silas, nunu bdiiñ dey rishsulagy lo dey. Orzeꞌ gua nu dey de yu zeꞌ par ich yuꞌ gyiib nunu mnishbaa dey loy nu ruu dey gyedz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Orzeꞌ Baly nu Silas bruuy nañ yuꞌ gyiib zay par yuꞌ Lidia. Zeꞌ bdzeel dey dela bicy na, nunu briic dey consuel ni de yu zeꞌ. Orzeꞌ bruu dey yuꞌ Lidia za dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nez nu za dey bded yu tub gyedz nu la Anfípolis, nunu bded dey tuubaꞌ gyedz nu la Apolonia. Orzeꞌ bruꞌña dey tub gyedz nu la Tesalónica. Orzeꞌ zeꞌ zub tub yuꞌ zeꞌ nu rsyaꞌ mbecy Israeel riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Orzeꞌ Baly zay nañ yuꞌ zeꞌ como nil rzay. Orzeꞌ chon sab, dzi nu rzu lagy mbecy Israeel, orzeꞌ Baly bee nuy de mbecy riidz. Bzat yu de riidz nu bzeeñ Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Orzeꞌ mniiy tub mod par nu gyet gras lardoo de mbecy zeꞌ, nunu pshaal yu lo dey nu Mesías, bin nu ca lo cuen nu co mbañ mbecy, rlagy ñi nu gzac zim, nunu despuees ornu gat mi rlagy ñi nu gyabañ mi, nay. Orzeꞌ na gaꞌy rab yu dey: ―Laab Jesuuz, biñ nu ya̱ rzata̱ lo der, laab mi zeꞌ nac mi Mesías, biñ nu ca lo cuen nu co mbañ mbecy ―nay. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Orzeꞌ guña lagy la be mbecy riidz nu rnii Baly, nunu guc nu dey Baly nu Silas. Niꞌ ziꞌl guña lagy zigy mbecy griego, de yu nu rca Ñgyoozh, nunu guña lagy zigy biñ mñaa zub lo. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Na de mbecy Israeel gusaap lagy dey. Orzeꞌ bicy tublaazh dey la be mbecy a̱ꞌ nap, gal nu mbecy gur rded. Orzeꞌ bicy dey nu pchaꞌ ic dela mbecy gyedz zeꞌ. Orzeꞌ por fers la guꞌ dey nañ yuꞌ Jasón. Byub dey Baly nu Silas nu cha nu dey yu lo de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Na ornu wangyad yu, orzeꞌ bgayu tuñ la dey Jasón nu deꞌ zir de bicy na. Gua nu dey yu lo de fushtiz gyedz zeꞌ. Orzeꞌ rbish ti dey. Orzeꞌ nay: ―¡De yu ii ricy deet dey dutuub la lugaar! ¡Na yadaꞌ dey gyedz ii nin! ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Nunu Jasón briic yu yuꞌ nu rcyiiñ dey! ¡De yu ii za dey contr ni leey ni yu nu riib ic de nasyoong, gun rnii dey nu zu tuubaꞌ mbecy nu riib ic, tub yu nu la Jesuuz! ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Orzeꞌ nu riidz zeꞌ bicy dey nu pchaꞌ ic de mbecy zigy, nunu bicy dey nu pchaꞌ ic de fushtiz nu yuꞌ gyedz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Orzeꞌ de fushtiz pcaa dey Jasón nu deꞌ zir de mbecy zeꞌ nu zeeñ dey ñuu tiñ par nu cueꞌ grib dze dey gyedz zeꞌ. Gazeꞌ nu blaa dey yu. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Na ornu bi becheñ, orzeꞌ lueg la de bicy na bzuu nez dey Baly nu Silas zay Berea. Na ornu bruꞌña dey Berea, orzeꞌ gua dey nañ yuꞌ nu rsyaꞌ mbecy Israeel riidz ni Ñgyoozh. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","De mbecy Israeel nu yuꞌ Berea napaꞌ zir ricy dey gazeꞌ de mbecy Tesalónica. Orzeꞌ tonaꞌ la yet lagy dey de riidz nu rnii Baly nu Silas. Nunu tub dzi ga psyaꞌ zir dey riidz nu bzeeñ Ñgyoozh ben a rishli de coz nu rnii Baly nu Silas. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Orzeꞌ zigy mbecy zeꞌ bicy cup dey consuel lo Crisht gal nu zigy mbecy griego: tant biñ mñaa zub lo, nunu tant yu gyeey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tees ornu de mbecy Israeel nu yuꞌ Tesalónica güeñ dey nu niꞌ ziꞌl Baly rshaal yu riidz ni Ñgyoozh Berea, orzeꞌ za dey zeꞌ. Orzeꞌ brugyiꞌ ricy dey nu rchaꞌ ic de mbecy zigy. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Orzeꞌ lueg la de bicy na bzuu nez dey Baly zay par ruꞌ nisyudoo. Zeꞌ Silas nu Timoteo rup laa dey byeeñ yu Berea. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","De mbecy nu za nu Baly, de yu zeꞌ za nu dey yu gashtal Atenas. Gazeꞌ nu bish cya dey zay par Berea tuubaꞌ tir. Za nu dey raso̱o̱ nu bzeed Baly lo Silas nu Timoteo. Baly mniiy nu cha dey loy lueg lueg la. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lat nu Baly blez yu Silas nu Timoteo Atenas, tonaꞌ la deet guc nañ lardooy ornu bzaac yu nu dzi zañ nab nguaa gyedz zeꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ndeꞌ nu beey riidz nu de mbecy Israeel nu deꞌ zir mbecy nu driib zily Ñgyoozh nañ yuꞌ zeꞌ nu rsyaꞌ dey riidz nu bzeeñ mi. Nunu de dzi la beey riidz nu cyu ziꞌl mbecy nu byap yu lat yagyiꞌ. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Orzeꞌ la be mbecy nu rsyaꞌ leey nu la epicúreos nu la be mbecy nu rsyaꞌ gaꞌ leey nu la estoicos brugyiꞌ nu zi ro nu dey Baly riidz. Orzeꞌ na dey: ―¿La coz rnii mbecy nu dzi zaab ga ruꞌ re? ―na dey. Orzeꞌ tub nacaꞌ mbecy nay: ―Rlyu nu rzat yu ñgyoozh nu walab ñgyoozh guledz ―na dey. Ni rnii dey, gun Baly rshaal yu riidz ni Jesuuz, nunu rshaal yu riidz nu lac byabañ mi despuees nu bi gut mi. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Orzeꞌ gua nu dey yu tub lugaar nu la Areópago, zeꞌ nu ryatublaazh tub nac mbecy nu zu riiñ. Orzeꞌ na dey: ―Rlagy de̱ gad lagya̱ de riidz cub nu rlyuur. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ru rniir reñ ga la riidz lo de̱, ndeꞌ nu rlagy de̱ gad lagya̱ lac yaruu de riidz zeꞌ ―na dey. ");
INSERT INTO zpzNTpp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","2