﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpvNT_vpl;
CREATE TABLE zpvNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpvNT_vpl WRITE;
INSERT INTO zpvNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Deeꞌ naa lah raꞌ bwiinn raꞌ nin guhca raꞌ xtulbaaꞌ Jesucristu, lliiꞌn Davihd, lliiꞌn Abrahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahn guhca xtaada Isaac, Isaac guhca xtaada Jacob, Jacob guhca xtaada Judah cun bwihtsi raꞌ bi, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah guhca xtaada Fares cun Zara, ya xmaah raꞌ bi guhca Tamar. Fares guhca xtaada Esrom, Esrom guhca xtaada Aram, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram guhca xtaada Aminadab, Aminadab guhca xtaada Naasohn, Naasohn guhca xtaada Salmohn, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmohn guhca xtaada Booz ya xmaah bi guhca Rahab. Booz guhca xtaada Obed, ya xmaah bi guhca Rut. Obed guhca xtaada Isaí, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí guhca xtaada rrehyi Davihd, ya rrehyi Davihd guhca xtaada Salmohn ya xmaah bi guhca nin guhca cheꞌhla Urías. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salmohn guhca xtaada Roboam, Roboam guhca xtaada Abías, Abías guhca xtaada Asa, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa guhca xtaada Josafat, Josafat guhca xtaada Joram, Joram guhca xtaada Uzías, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías guhca xtaada Jotam, Jotam guhca xtaada Acaz, Acaz guhca xtaada Ezequías, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías guhca xtaada Manasehs, Manasehs guhca xtaada Amohn, Amohn guhca xtaada Josías, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías guhca xtaada Jeconías cun bwihtsi ru bi nin guyuuꞌ laꞌn dxyih raꞌ nin batiꞌdxiloh raꞌ bwiinn Israel trabahju duxa chin gwah raꞌ ba ziga esclavo loh raꞌ bwiinn Babilonia. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ya chin gudiiꞌdxi raꞌ dxyih nin guhca raꞌ bwiinn chi esclavo loh raꞌ bwiinn Babilonia, chiꞌchi guyuuꞌ lliiꞌn Jeconías nin biriaꞌhlah Salatiel, ya Salatiel guhca xtaada Zorobabel. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel guhca xtaada Abiud, Abiud guhca xtaada Eliaquim, ya Eliaquim guhca xtaada Azor. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor guhca xtaada Sadoc, Sadoc guhca xtaada Aquim, Aquim guhca xtaada Eliud, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud guhca xtaada Eleazar, Eleazar guhca xtaada Matahn, Matahn guhca xtaada Jacob, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob guhca xtaada Joseh nin guhca cheꞌhla María, María nin guhca xmaah Jesuhs, Daada xteenn nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pwihsi guyuuꞌ tsiꞌdah famihyi raꞌ ba desde laꞌn dxyih raꞌ nin gubahan guehtu Abrahn cun hasta laꞌn dxyih za nin gubahanyi guehtu rrehyi Davihd, ya za tsiꞌhdahan desde guehtu Davihd hasta chin gwahyi raꞌ bwiinn Israel prehsu lahdxyi bwiinn Babilonia, ya za tsiꞌhdahan desde laꞌn dxyih raꞌ nin gwah raꞌ ba prehsu loh raꞌ bwiinn Babilonia cun para hasta laꞌn dxyihyi nin guulaa Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Chin guulaa Jesucristu guhca squiiꞌ: María xmaah Ñiꞌh badiꞌhi xchiꞌdxyi bi laꞌh tuhbi biꞌnxtuhbi nin laa Joseh tin guchinaa raꞌ ba, per loh nin nagahdxi guidxiꞌ Joseh laꞌh María laꞌMaría nuꞌa lliiꞌnla pur xcweenta xquelrnabwaꞌ Spíritu Saantu Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ya Joseh xpwiinn ndxiꞌhw María, guhca ba tuhbi bwiinn zaꞌca niꞌchin guluꞌchaꞌyisi ba laꞌn lastoꞌ ba ziga guzahca María, ya chiꞌchi bwiꞌhnn Joseh lligaaba ralaꞌn zi ñusaaꞌn ba laꞌh María tin ayi ñahcabwaꞌ nin tuhbi bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ya lligaaba chi nuu Joseh guunn ba chin bagañiꞌ tuhbi xaanjla Dxiohs loh ba loh nin naꞌllgahsi ba rahbi aanjla chi loh Joseh: ―¡Joseh, llahga guehtu Davihd!, ayi guidxyihbi luꞌh guicaꞌha luꞌh María gaca bi cheꞌhla luꞌh laasii lliiꞌn bi nin gaalaa lliiꞌn Spíritu Saantun, ");
INSERT INTO zpvNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ya badoꞌyiꞌhn nin gaalaa chi cweꞌhelah tu bi Jesuhs, laasii laꞌh Ñiꞌh gutaꞌh Ñiꞌh laꞌh raꞌ nin gaca xpwiinn Ñiꞌh loh xtuhlda raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Garaa raꞌ deeꞌ guhca tin guzohba dxyiꞌdxyi ziga nin baziaꞌñih Dxiohs loh xigaaba bwiinn nin bacaꞌh xchiꞌdxyi Dxiohs chin rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Zuꞌa lliiꞌn tuhbi dxaꞌpa nin nagahdxi guidxiꞌtiiꞌ tuhbi ndxiꞌhw, ya chin gaalaa lliiꞌn bi guiriaꞌlah badoꞌyiꞌhn chi Emanuel (nin rzaꞌloh Dxiohs nabahannee laꞌh nuꞌh). ");
INSERT INTO zpvNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ya chin badiꞌchi bacaꞌlda chi loh Joseh, bwiꞌhnn ba ziga guhdzi aanjla chi loh ba, gucaꞌha ba María ");
INSERT INTO zpvNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ya guhpadaa ba laꞌh María hastayi chin guulaa lliiꞌn María nin guleꞌhelah Joseh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Chin guulaa Jesuhs guihdxyi Belehn xteenn Judea laꞌn dxyih raꞌ chi gunabwaꞌ rrehyi Herodes, nee laꞌn dxyih chi gahcaza badzihn raꞌ rrehyi mago raꞌ nin zeꞌ raꞌ nez hasta rtahn gubihdxyi nez loh guihdxyi Jerusalehn, ya nin guhca xtsiꞌn raꞌ ba naa basiꞌdxi raꞌ ba xcweenta dxih raꞌ nin nuu llaaꞌndxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ya chin badzihn raꞌ ba rahbi raꞌ ba: ―¿Cuun xchiꞌh rrehyi xteenn raꞌ bwiinn Israel, nin gueꞌdu guulaa? Laasii bidiaꞌha nu gutahn dxih xteenn ñiꞌh nez hasta rtahnn gubihdxyi, niꞌchin nin zoꞌpa gazuꞌnllihbi nu nez loh ñiꞌh, ―rahbi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ya chin bihn rrehyi Herodes nin guhdzi raꞌ rrehyi mago raꞌ chi dxyihgah si guhca ziahan loh xigaaba ba; ziꞌchi gahca za guzahca raꞌ garaa raꞌ bwiinn guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ya seguihdu gunabwaꞌ rrehyi Herodes gwacaꞌha raꞌ ba laꞌh raꞌ bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ snuhn bixohza cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, tin gunaabadxyiꞌdxyi rrehyi Herodes loh raꞌ ba caa chiꞌh nahpa gaalaa Crixtu, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","chiꞌchi rahbi raꞌ ba: ―Laꞌn guihdxyi Belehn xteenn Judea, laasii ziꞌchi bacaꞌh tuhbi daada nin guñiꞌ xchiꞌdxyi Dxiohs, squiiꞌ bacaꞌh ba: ");
INSERT INTO zpvNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ya yiꞌh guihdxyi Belehn, yuh xteenn Judea, tayi yiꞌh dxiꞌh naa luꞌh biꞌtuꞌhn ru loh raꞌ guihdxyi liꞌhi, nee nnah yiꞌh gaca luꞌh tuhbi guihdxyi nin gaalaa tuhbi bwiinn nin guinabwaꞌ nin guluuꞌyi neziuh zaꞌca laꞌh guihdxyi Israel xteꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ya chiꞌchi ziga moda ralaꞌn gudihdxyi Herodes laꞌh raꞌ rrehyi mahgu raꞌ chi tin gunaabadxyiꞌdxyi ba loh raꞌ ba cuuca biinnloh dxih nin bwaꞌha raꞌ ba dxih chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ya chin guyaꞌloh gunaabadxyiꞌdxyi ba lwehgu gahca guxeꞌhla ba laꞌh raꞌ ba para guihdxyi Belehn, ya rahbi Herodes loh raꞌ ba: ―Gulcheh riꞌchi, ya chin gadxeela tun, guunn tu bihsi naꞌh tin chegazulliibizahn loh ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ya chin guyaꞌloh guñiꞌ Herodes loh raꞌ ba lwehgu gunaꞌzu nehza raꞌ mahgu chi para guihdxyi Belehn, ya dxih nin bwaꞌha raꞌ ba biinloh chi niꞌchi badiꞌhi sehn guhcabwaꞌ raꞌ ba guulaa Jesuhs ya ñiidxiuu dxih chi delaanta loh raꞌ ba ya pur luulchima guzaꞌbidxyiiꞌhin nez hasta guulaa Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ya chin bwaꞌha raꞌ mahgu chi guzaꞌbidxyii dxih chi nez hasta guulaa Jesuhs biahxi duxa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lwehgu guyuuꞌtii raꞌ ba hasta laꞌn yuuꞌ chi, ya bwaꞌha raꞌ ba badoꞌyiꞌhn cun María xmaah Ñiꞌh, ya lwehgu bazuꞌnllihbi raꞌ ba nez loh Ñiꞌh, ya chiꞌchi guxaala raꞌ ba yihca cohsa zaꞌca nin gwanee raꞌ ba nin naa ohro, yaꞌhla cun mirra, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ya seguihdu bwiꞌhnn xcaꞌlda raꞌ ba bihsi laꞌh raꞌ ba loh naꞌxgahsi raꞌ ba tin ayi guibiaꞌgariinee raꞌ ba dxyiꞌdxyi loh Herodes, ya mas chaꞌyi gubiaꞌgarii raꞌ ba stuhbi neziuh para lahdxyi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pwihsi babii si raꞌ rrehyi mahgu raꞌ chi, baluuꞌyiloh tuhbi xaanjla Dxiohs loh Joseh loh bacaꞌlda rahbi ba: ―Gwastii tin gucaꞌha badoꞌyiꞌhn cun xmaah Ñiꞌh, tin gulchechuulaꞌn para guihdxyi Egiptu, ya biaꞌhan riꞌchi hastayi chin guꞌnnahn bihsi yiꞌh, laasii Herodes nuu ba lligaaba gadxiꞌhyi ba badoꞌyiꞌhn tin gachi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ya lwehgu gwastii gahca Joseh tin gucaꞌha ba badoꞌyiꞌhn cun xmaah Ñiꞌh hohra gueꞌla chi gunaꞌzunehza ba para guihdxyi Egiptu, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ya riꞌchi guyuuꞌ raꞌ ba hastayi chin guhchi Herodes. Squiiꞌ guhca tin guzohba dxyiꞌdxyi raꞌ nin baziaꞌñih Dxiohs loh xigaaba raꞌ bwiinn nin guñiꞌ xcweenta Ñiꞌh chin rahbi Ñiꞌh: “Hasta guihdxyi Egiptuyi gudiidxyihn Lliiꞌnahn.” ");
INSERT INTO zpvNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ya chin guhcabwaꞌ Herodes basaguiꞌhi raꞌ rrehyi mahgu chi laꞌh ba, bidxyiꞌchi duxa ba, ya gunabwaꞌ ba gachi raꞌ garaatiiꞌ raꞌ badoꞌyiꞌhn raꞌ nin nuu chiohpa yihza cun para nin nuu raꞌ la mas paaldaa bweꞌhw. Deeꞌ guhca raꞌn loh guihdxyi Belehn cun garaa raꞌ za guihdxyi raꞌ nin guyuuꞌ gahxu cweeꞌ guihdxyi chi, bwiꞌhnn ban ziga dxyih nin guhdzi rrehyi mahgu raꞌ chi loh ba bwaꞌha raꞌ ba dxih chi llaaꞌndxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ya squiiꞌ guzohba dxyiꞌdxyi raꞌ nin bacaꞌh guehtu profeta Jeremías chin rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rsiaaꞌha nin guyuuꞌ loh guihdxyi Ramah, ñihsabwii naltaa cun guelnalasa duxa niꞌchi naa Raquel, nin ruꞌn duxa pur xcweenta raꞌ lliiꞌn bi, ya ayi guclaaꞌdzi bi ñiaꞌldastoꞌ bi laasii laꞌh raꞌ lliiꞌn bi chi guhchi la. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per ya chin guhchi Herodes, baluuꞌyiloh tuhbi xaanjla Dxiohs loh Joseh loh bacaꞌlda loh guihdxyi Egiptu, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","rahbi aanjla chi: ―Gwastii, tin gucaꞌha biñiꞌn cun xmaah Ñiꞌh tin gwah para lahdxyi raꞌ bwiinn Israel, laasii laꞌh raꞌ nin guclaaꞌdzi ñahchi biñiꞌn laꞌh raꞌ ba barah guhchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ya chiꞌchi gwastii Joseh tin gucaꞌha ba biñiꞌn cun xmaah Ñiꞌh; gunaꞌzunehzanee ba para lahdxyi raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","per chin bihn Joseh canabwaꞌ Arquelau loh guihdxyi Judea xlugahri Herodes xtaada bi, guyuuꞌ guelrzaaꞌ Joseh ñah ba para guihdxyi chi; per guñiꞌ xcaꞌlda ba pur xcweenta Dxiohs tin mahs gwah ba para loh yuh nin rnabwaꞌ guihdxyi Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ya chin badzihn ba riꞌchi guyuuꞌ ba loh guihdxyi nin laa Nazaret. Guhca squiiꞌ tin guzohba dxyiꞌdxyi raꞌ nin guñiꞌ raꞌ bwiinn nin guñiꞌ xcweenta xchiꞌdxyi Dxiohs: “Ziriaꞌhlah Ñiꞌh bwiinn guihdxyi Nazaret.” ");
INSERT INTO zpvNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pwihsi laꞌn dxyih raꞌ chi badzihn Jwahn nin ruroꞌbañihsa loh dahan desiertu xteenn Judea tin baluuꞌyi ba xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ya rahbi Jwahn: ―Gulgasaguuꞌdzi stoꞌ tu nez loh Dxiohs laasii laꞌh xquelrnabwaꞌ Ñiꞌh badzihn gahxu. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Laꞌh Jwahn ruzeꞌta profeta Isaías chin bacaꞌh ba squiiꞌ: Ziuuꞌ tuhbi rsiaaꞌha nin guiñiꞌ jweersi rooꞌ loh dahan desiertu: “Gulguiꞌhnn zaꞌca xneziuh Dxiohs, nee gulgasanchii za xneziuh Ñiꞌh laꞌn lastoꞌ tu.” ");
INSERT INTO zpvNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ya xahba Jwahn guhcachaꞌyi cun dxyihdxilahdxi camehyu neezaa biyiꞌbiduꞌh tuhbi duꞌhdxihdxi laꞌn tihxi Jwahn, ya nin guhca xquelwahw Jwahn guhca bwiꞌtsisuu cun xtsihn bweꞌsehra nin nuu laꞌn dahan. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bwiinn guihdxyi Jerusalehn raꞌ cun garaa raꞌ bwiinn guihdxyi raꞌ xteenn Judea cun bwiinn guihdxyi nin rii gahxu gadiidxi guiꞌw Jordahn biriaꞌh raꞌ ba tin bacaꞌdxiahga raꞌ ba xchiꞌdxyi Dxiohs nin ruluuꞌyi Jwahn, ");
INSERT INTO zpvNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ya guyaꞌlohsi baxoꞌbaduhlda raꞌ ba xtuhlda raꞌ ba chiꞌchi baroꞌbañihsa Jwahn laꞌh raꞌ ba loh guiꞌw Jordahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ya chin bwaꞌha Jwahn ziahan raꞌ bwiinn fariseu cun bwiinn saduceu raꞌ cagadzihn raꞌ tin guroꞌbañihsa Jwahn laꞌh raꞌ ba, chiꞌchi rahbi Jwahn: ―¡Laꞌh tu bwiinn naxihn raꞌ nin naa ziga zi bweꞌlda ñaꞌlaaꞌdzi! ¿Chyuulla gudxixteeꞌ loh tu tin cadxiꞌhyi tu canehza taꞌh tu loh xjwisi Dxiohs nin gueꞌdu gadzihn? ");
INSERT INTO zpvNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gulgachaꞌh ziga nabahan tu tin guluuꞌyi paꞌh tu basaguuꞌdzi stoꞌ tu nez loh Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","nee ayi guunn tu lligaaba lasaca duxa tu pur nin naa tu llahga guehtu Abrahn, laasii rñiꞌn loh tu sidela guiclaaꞌdzi Dxiohs hasta dxiah nin naꞌ riiꞌ zahca guunn Ñiꞌhn llahga guehtu Abrahn, ");
INSERT INTO zpvNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","nee neezaa laꞌh dxiꞌba yahga naꞌsiin la llaaꞌn raꞌ yahga tin garaa yahga raꞌ nin ayi rcah ninahxi zaꞌca loh ñiꞌh, garaa raꞌ yahga chi chyuuga raꞌn tin guicaꞌdxih raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naꞌh guchiin nin cañiꞌn loh tu, naꞌh ruroꞌbañiꞌsahn cun ñihsa pur nin rusaguuꞌdzi stoꞌ raꞌ bwiinn xcweenta xtuhlda raꞌ ba nez loh Dxiohs. Per stuhbi bwiinn nin zeꞌnaꞌhla naꞌh zuroꞌbañihsa ba laꞌh bwiinn raꞌ cun Spíritu Saantu. Bwiinn chi lasahca duxa ru ba que naꞌh, per nin para gutiꞌdxiꞌhn tahba ba ayi lasahcaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nee laꞌh xpahla ba nuu listu la naa ba tin cweꞌhe ba dxihlli dxaaba raꞌ loh trihgu ya chin chaꞌloh gusiaa ba loh trihgu chiꞌchi gutiaaꞌha ban gaguꞌchaꞌyi ban ya dxihlli chi gucaꞌdxih ba per ayi chuu dxyih dxiuꞌyin. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pwihsi biriaꞌh Jesuhs guihdxyi Galilea tin gwah Ñiꞌh hasta rwaaꞌ guiꞌw Jordahn, hasta zuu Jwahn tin baroꞌbañihsa Jwahn laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Galoh nin nagahdxi guroꞌbañihsa Jwahn laꞌh Ñiꞌh rahbi Jwahn loh Ñiꞌh: ―¡Yiꞌh rchiꞌhn guroꞌbañihsa luꞌh naꞌh nee laꞌlaꞌgaꞌh Yiꞌh zeꞌ luꞌh loon tin guroꞌbañiꞌsahn Yiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chiꞌchi rahbi Jesuhs loh Jwahn: ―Nicala basaaꞌn gacan ziꞌchi nnah, laasii nahpa guidiꞌhnn nuꞌh ziga rclaaꞌdzi Dxiohs gaca. ");
INSERT INTO zpvNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ya chin guyaꞌloh guroꞌbañihsa Jesuhs, lwehgu guzuꞌnchii Jesuhs loh ñihsa, hohra chi gahca billaala dxibaaꞌ, ya bwaꞌha Jesuhs zeꞌyehta Spíritu Saantu nez yihca Ñiꞌh ziga zi tuhbi palohmwiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","chiꞌchi bihn raꞌ ba tuhbi rsiaaꞌha nez llaaꞌndxibaaꞌ guñiꞌ Dxiohs rahbi Ñiꞌh: ―Deeꞌ naa Lliiꞌnahn nin nadziiꞌhihn nee riahxi duxaꞌhn pur xcweenta bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ya seguihdu gwanee Spíritu Saantu laꞌh Ñiꞌh loh dahan desiertu tin guiduꞌhun gu ñuhnn bwiinndxaaba gahn ñusaguiꞌhi ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ya guyuuꞌ Ñiꞌh nez chi chywaꞌh dxyih chywaꞌh gueꞌla ya loh dxyih raꞌ chi cun gueꞌla raꞌ chi ayi gudahw Ñiꞌh nin tahyi guehta ya bichiaꞌhan Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","chiꞌchi badzihn bwiinndxaaba hasta zuu Ñiꞌh tin guclaaꞌdzi ba ñusaguiꞌhi ba laꞌh Ñiꞌh, ya rahbi ba loh Ñiꞌh: ―Sidela guchii luꞌh naa luꞌh Lliiꞌn Dxiohs, guhdzi loh dxiah raꞌ ca dxiahcan guehta. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chiꞌchi rahbi Jesuhs: ―Caa loh Xchihtsi Dxiohs: “Ayi guehta si dxiꞌh gahw bwiinn guunn para guibahan raꞌ ba, sino que rchiꞌhn neezaa guzoꞌbadxiahga raꞌ ba xchiꞌdxyi Ñiꞌh nin rreꞌh rwaaꞌ Ñiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ya chiꞌchi gucaꞌha bwiinndxaaba chi gunaꞌzu nehzanee ba laꞌh Ñiꞌh loh guihdxyi Jerusalehn hasta zohba guidoꞌ rooꞌ tin bacaꞌh ba laꞌh Ñiꞌh hasta puntayi xteenn campanariu chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","chiꞌchi rahbi ba loh Ñiꞌh: ―Sidela guchii luꞌh naa luꞌh Lliiꞌn Dxiohs, balaꞌha yiꞌh desde riꞌca hasta loh yuh, laasii caa loh Xchihtsi Dxiohs: “Zixeꞌhla Ñiꞌh xaanjla Ñiꞌh tin gaapaa raꞌ ba yiꞌh, ya cun naa raꞌ aanjla raꞌ chi zinaꞌzu raꞌ ba yiꞌh tin ayi guireꞌlda luꞌh nin tuhbi dxiah.” ");
INSERT INTO zpvNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chiꞌchi rahbi Jesuhs loh bwiinndxaaba chi: ―Neezaa caa loh Xchihtsi Dxiohs: “Ayi guunn tu pwexta laꞌh Dxiohs nin rnabwaꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ya lulchimatiiꞌ gwanee bwiinndxaaba chi laꞌh Jesuhs yihca tuhbi dahan rooꞌ duxa, tin desde yihca dahan chi baluuꞌyi bwiinndxaaba chi laꞌh Ñiꞌh garaatiiꞌ guihdxyi raꞌ cun ciudahd raꞌ nin rii loh guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","chiꞌchi rahbi bwiinndxaaba chi loh Ñiꞌh: ―Naꞌh zuniꞌhihn garaatiiꞌ raꞌ deeꞌ yiꞌh sidela guzuꞌnllihbi luꞌh nez loon nee gaann za luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chiꞌchi rahbi Jesuhs loh bwiinndxaaba chi: ―¡Bwaa bwiinndxaaba!, laasii caa loh Xchihtsi Dxiohs: “Xtaada Dxiohs si luꞌh gaann luꞌh, nee loh si Ñiꞌh chuu luꞌh tin guunn luꞌh xtsiꞌn Ñiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ya bwaꞌha si bwiinndxaaba chi ayi bwiꞌhnn ba gahn ñusaguiꞌhi ba laꞌh Jesuhs, mas chaꞌyi basaaꞌn ba laꞌh Ñiꞌh, ya hohrchigahca badzihn paaldaa raꞌ aanjla nin bieꞌnee nin gudahw Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chin bihn Jesuhs ñieꞌw Jwahn laꞌn lahtsidxiꞌba, chiꞌchi gunaꞌzu nehza Ñiꞌh zee Ñiꞌh para loh yuh nin rnabwaꞌ guihdxyi Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ya chin gudiiꞌdxi Ñiꞌh loh guihdxyi Nazaret nahpa gwazahrutiiꞌ Ñiꞌh hasta badzihn Ñiꞌh loh guihdxyi Capernaum, nez rwaaꞌ laguhn xteenn guihdxyi Zabulohn cun Neftalih. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Guhca squiiꞌ tin guyaꞌloh guzohba dxyiꞌdxyi raꞌ nin badiꞌhi Dxiohs bacaꞌh guehtu profeta Isaías chin bacaꞌh ba squiiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yuh xteenn Zabulohn cun Neftalih, stuhbi lahdu guiꞌw Jordahn, rwaaꞌ ñihsadoꞌ, cun loh yuh nin rnabwaꞌ guihdxyi Galilea, lahdxyi raꞌ bwiinn nin ayi naa raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","cun neezaa guihdxyi nin gucaꞌnzaa loh nacahyi; laꞌraꞌ ba bwaꞌha tuhbi llaꞌñih rooꞌ, tuhbi llaꞌñih nin basiaꞌñih para laꞌh raꞌ bwiinn raꞌ nin gubahan raꞌ loh xpacaala guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pwihsi desde laꞌn dxyih raꞌ chi guzaꞌloh cagaluuꞌyi Jesuhs rahbi Ñiꞌh: ―Gulgasaguuꞌdzi stoꞌ tu nez loh Dxiohs, laasii laꞌh xquelrnabwaꞌ Dxiohs badzihn gahxu. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gaduhbi nin zeezah Jesuhs rwaaꞌ laguhn xteenn guihdxyi Galilea bwaꞌha Ñiꞌh chiohpa bwiinn, bwiinn raꞌ chi naa raꞌ ba tuhsi bwihtsi. Tuhbi ba laa Simohn nin laa za Pehdru, ya stuhbi ba laa Andrehs. Xtsiꞌn raꞌ ba naa riateꞌhe raꞌ ba bwehlda, ya gaduhbi riigalaꞌha raꞌ ba dxihxi bwelda loh ñihsa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","chiꞌchi guñiꞌ Jesuhs loh raꞌ ba rahbi Ñiꞌh: ―Gultanaꞌhla naꞌh, laasii nnah guꞌnnahn laꞌh tu nin guluuꞌyi xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn xlawaaꞌha nin riateꞌhe tu bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ya hohra chi gahca basiaꞌhan raꞌ ba xchihxi bwehlda raꞌ ba ya zenee raꞌ chiꞌh ba Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ya delanta ru, bwaꞌha laꞌgaꞌh Jesuhs laꞌh schiohpa bwiinn raꞌ nin naa tuhsi bwihtsi raꞌ za, tuhbi ba laa Jacobo cun stuhbi ba laa Jwahn, lliiꞌn Zebedeu laꞌh raꞌ ba, ya riꞌchi riinee raꞌ ba xtaada raꞌ ba laꞌn tuhbi laancha riiyuhnn zaꞌca raꞌ ba dxihxi bwehlda. Ya chiꞌchi gudihdxyi Jesuhs laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ya seguihdu basiaꞌhan raꞌ ba laancha chi cun xtaada raꞌ ba ya zenee raꞌ chiꞌh ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ya gucaꞌnzaa Jesuhs gaduhbi loh guihdxyi raꞌ nin rnabwaꞌ Galilea tin baluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn raꞌ garaa raꞌ laꞌn guidoꞌ biꞌtiꞌhn raꞌ, cun neezaa basiaca Ñiꞌh laꞌh raꞌ bwiinn cun xi chiꞌh zi gueldxyihdxyi nin guhca raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ya guzaꞌbi dxyiꞌdxyi pur ziga rusiaca Jesuhs laꞌh raꞌ bwiinn gaduhbitiiꞌ loh guihdxyi xteenn Siria, ya bieꞌnee raꞌ bwiinn chi lasaaꞌ raꞌ ba nin rahcalluꞌhu cun cuun chiꞌh zi gueldxyihdxyi; nin nuu guelnayaan cun nin rahca yihca ñiꞌh, neezaa nin nuu bwiinndxaaba stoꞌ raꞌ ñiꞌh, nin rachiaaꞌ raꞌ, nin ayi guhca ñiñiꞌbi raꞌ, nin badiaaꞌha ñaaꞌ raꞌ ñiꞌh cun naa raꞌ ñiꞌh; garaa raꞌ bwiinn chi basiaca Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ya ziahan duxa raꞌ bwiinn gwanaꞌhla laꞌh Ñiꞌh: bwiinn Galilea raꞌ, bwiinn guihdxyi raꞌ xteenn Decápolis, bwiinn guihdxyi Jerusalehn raꞌ, bwiinn Judea raꞌ, cun bwiinn nin zeꞌ stuhbi lahdu rwaaꞌ guiꞌw Jordahn gwanaꞌhla laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chin bwaꞌha Jesuhs loh raꞌ bwiinn ziahan duxa, gunaꞌzu Ñiꞌh gucah Ñiꞌh yihca tuhbi dahan, ya riꞌchi zohba Ñiꞌh chin badzihn raꞌ bwiinn raꞌ nin gulii Ñiꞌh gaca raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ya riꞌchi guzoꞌbaloh baluuꞌyi Ñiꞌh laꞌh raꞌ ba rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Dichohsa raꞌ bwiinn nin naann chaꞌyi rchiꞌhn duxa raꞌ ba xquelrahcanee Dxiohs, laasii xteenn raꞌ ba naa dxibaaꞌ hasta nuu Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Dichohsa raꞌ bwiinn nin ruꞌn nnah laasii rahcabwaꞌ raꞌ ba nahpa raꞌ duhlda, per zadzihn dxyih nin zaguuꞌnasaa Dxiohs stoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Dichohsa raꞌ bwiinn nin nadoꞌlaaꞌdzi, bwiinn raꞌ nin ruzoꞌbadxiahga ziga xclaaꞌdzi Dxiohs gaca, laasii zahcanee Dxiohs laꞌh raꞌ ba loh guelnabahan nin guibahan raꞌ ba loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dichohsa raꞌ bwiinn nin cachiaꞌhan cun nin cadxahga ñihsa, laasii pur nin saꞌloh guunn raꞌ ba nin xclaaꞌdzi Dxiohs guunn raꞌ ba, pwihsi laꞌh gahca Ñiꞌh zahcanee Ñiꞌh laꞌh raꞌ ba tin guzaꞌloh raꞌ ba ziga xclaaꞌdzi Ñiꞌh guunn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Dichohsa raꞌ bwiinn nin ralahsastoꞌ lasaaꞌ raꞌ ñiꞌh, pwihsi laꞌh Dxiohs zalahsastoꞌ Ñiꞌh laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dichohsa raꞌ bwiinn nin xclaaꞌdzi gaca nayaa stoꞌ raꞌ ñiꞌh nez loh Dxiohs laasii zahcanee Ñiꞌh laꞌh raꞌ ba gaca nayaa stoꞌ raꞌ ba tin ziꞌchi gwaꞌha raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Dichohsa raꞌ bwiinn nin rusacwachidxyiistoꞌ laꞌh bwiinn nin rdxindxinee lasaaꞌ ñiꞌh, laasii laꞌh raꞌ ba ziriaꞌhlah raꞌ ba lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dichohsa raꞌ bwiinn nin cagatiiꞌdxiloh guelrzaꞌcazii pur nin ruzoꞌbadxiahga raꞌ ba xcweenta xchiꞌdxyi Dxiohs, laasii xteenn raꞌ ba naa nin gudiꞌhi Dxiohs laꞌh raꞌ ba nez dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Dichohsa tu chin guiñiꞌyah bwiinn laꞌh tu nee gusaꞌcazii raꞌ ba laꞌh tu pur xcweenta nin riachiistoꞌ tu xchiꞌdxyiꞌhn nee chin guguꞌchi dxixiꞌhw raꞌ ba laꞌh tu cun ziahan raꞌ dxyiꞌdxyi xihn raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","per guldxiahxi cun garaa nin gusaꞌca raꞌ ba laꞌh tu, laasii llaaꞌndxibaaꞌyi zuniꞌhi Dxiohs zirooꞌ ru laꞌh tu pur xcweenta xtsiꞌn tu, pwihsi ziꞌchi gahca za bwiꞌhnnee raꞌ ba laꞌh raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs basaꞌcazii raꞌ ba laꞌh daada raꞌ chi galohyi que laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Laꞌh tu naa tu ziga zihdxi loh guidxyiyuh riiꞌ, per sidela laꞌh zihdxi chi guñihchin xquelnallihin, ayi ru xi galluꞌyitiiꞌhin, ya ziꞌchi ziuuꞌbwihin loh neziuh ya garaa raꞌ bwiinn zuzuꞌnñaaꞌ raꞌ ba yihcan. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Laꞌh tu naa tu ziga tuhbi biaꞌñih loh guidxyiyuh riiꞌ; laasii tuhbi guihdxyi nin riiꞌ yihca tuhbi dahan ayi nuu chuulaꞌnan, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ayi za nuu gucaꞌdxih luꞌh tuhbi biaꞌñih ya gusieꞌw luꞌh tuhbi cajohn yihcan. Mas chaꞌyi saꞌbin guiyaꞌ tin gusiaꞌñinin loh raꞌ nin rii laꞌñuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pwihsi ziꞌchi za laꞌh tu gulguiꞌhnn pur guziaꞌñih xpiaꞌñih tu nez loh raꞌ bwiinn, tin gacabwaꞌ raꞌ ba nee gwaꞌha raꞌ ba dziꞌn zaꞌca nin ruhnn tu, tin guiñiꞌ zaꞌca raꞌ ba pur xcweenta Daada Dxiohs nin nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Rahbi za Jesuhs: ―Ayi guunn tu lligaaba naꞌh zeꞌldahn tin guñihchiloon xlehyi guehtu Moisehs o xcweenta ziga bacaꞌh guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs; aaca ayi par niꞌchi dxiꞌh zeꞌldahn, sino que zeꞌldahn tin guꞌnnahn soobaa garaa dxyiꞌdxyi nin bacaꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pwihsi guchiin nin rñiꞌn loh tu, rguꞌbwaꞌn gaduhbi nin nagahdxi ñichiloh dxibaaꞌ cun guidxyiyuh ayi nuu chapitii lehyi nee ayi za nuu guiraꞌha nin tuhbi lehtra xteenn lehyi hasta que no nahpa gaca garaa raꞌ nin rñiꞌ loh dxihtsi chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","niꞌchin bwiinn nin ayi guzoꞌbadxiahga ziga naa lehyi, nicala naan tuhbi dxyiꞌdxyi biꞌtiꞌhn, ya nin ayi ruluuꞌyi par guzoꞌbadxiahga raꞌ bwiinn xcweenta lehyi, gulliaaꞌ gaca lasahca ba lahdxyi Dxiohs llaaꞌndxibaaꞌ, per bwiinn nin guzoꞌbadxiahga xcweenta lehyi nee guluuꞌyi za ba snuhn bwiinn guzoꞌbadxiahga raꞌ ba lehyi pwihsi bwiinn lasahca duxa gaca ba lahdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","pwihsi cañiꞌn loh tu sidela ayi guunnzaꞌca ru tu xtsiꞌn Dxiohs nee cun ayi guibahan zaꞌca ru za tu loh Dxiohs nee loh xcweenta raꞌ mwehsu nin ruluuꞌyi lehyi cun loh xcweenta raꞌ bwiinn fariseu raꞌ, ayi chuꞌtii tu loh raꞌ xpwiinn Dxiohs nez dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Rahbi za Ñiꞌh: ―Laꞌh tu bihn xa gucahpwehn raꞌ xtaada guldooꞌ raꞌ tu chin bihn raꞌ ba dxyiꞌdxyi raꞌ squiiꞌ: “Ayi chiinn luꞌh bwiinn, laasii nin chiinn bwiinn zahca za guelguxchisi xcweenta ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per naꞌh rñiꞌn cuun chiꞌh zi bwiinn nin guidxyiꞌchinee bwihtsi ñiꞌh zahca ba bwiinn duhlda loh raꞌ guxchisi, ya cuun chiꞌh zi bwiinn nin gahbi loh bwihtsi ñiꞌh: “Bwiinn nahda”, o gusioꞌba ba laꞌh bwihtsi ba zahca ba tuhbi bwiinn duhlda nez loh raꞌ guxchisi nin dziꞌbaloh; ya cuun chiꞌh zi bwiinn nin guiñiꞌ tohnta duxa loh bwihtsi ñiꞌh ziga bwiinn tohnta o bwiinn loh mbah tiiꞌ, bwiinn chi guzee para gabihldxyi. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pwihsi sidela yiꞌh badzihnnee luꞌh tuhbi guhn loh bacuꞌga nee dxiagannastoꞌ luꞌh nahpa bwihtsi luꞌh xiilla cun yiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Mas chaꞌyi gusiaꞌhan luꞌh guhn chi nez loh bacuꞌga bachiꞌh chee luꞌh galoh chegañiꞌnee luꞌh bwihtsi luꞌh tin dxiaꞌlda stoꞌ bi, ya chiꞌchiyi gabiaꞌgarii luꞌh laꞌn guidoꞌ chegasiaꞌhan luꞌh guhn nin zeꞌnee luꞌh loh bacuꞌga xteenn guidoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Sidela chyuulla xclaaꞌdzi guinaaba guxchisi yiꞌh, mas chaꞌyi lwehgu basiaꞌlda dxyiꞌdxyi cun laꞌh ba gaduhbi nin nagahdxi chedxiaaba luꞌh laꞌn naa raꞌ guxchisi, laasii sidela ayi chiꞌhyi luꞌh xa guunn luꞌh galoh, guxchisi dziꞌbaloh raꞌ chi zutiꞌdxi raꞌ ba yiꞌh loh raꞌ guixaꞌga ya guixaꞌga raꞌ chi zulaꞌha raꞌ ba yiꞌh laꞌn lahtsidxiꞌba, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ya naꞌpahn siguhra ayi gabweꞌhe raꞌ ba yiꞌh riꞌchi hasta que no cwachi luꞌh multa nin guinaaba raꞌ ba loh luꞌh chiꞌchiyi gutaꞌh raꞌ ba yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Rahbi za Ñiꞌh: ―Laꞌh tu bihndxiahga desde galohyi zaꞌbi dxyiꞌdxyi: “Ayi gaca luꞌh bwiinn gubwihlli.” ");
INSERT INTO zpvNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per naꞌh rñiꞌn cuun chiꞌh zi bwiinn nin chuuloh si tuhbi gunnaꞌh, bwiinn chi laꞌh ba biaaba la loh duhlda pur nin guzaꞌbi stoꞌ ba laꞌh gunnaꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","pwihsi ziꞌchi, sidela laꞌh bizloh derehchu luꞌh rluuꞌyi gusiaaban yiꞌh loh duhlda, mas chaꞌyi cweꞌhe luꞌhn cuꞌbwih luꞌhn zihtu, laasii mas chaꞌyi guñihchi luꞌh tuhbi bizloh si luꞌh xlawaaꞌha guzee gaduhbi tihxi luꞌh gabihldxyi. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ya sidela laꞌh naa luꞌh nin naa lahdu derehchu rluuꞌyi gusiaaban yiꞌh loh duhlda, bachyuuꞌgan ya balaꞌhan zihtu; mas chaꞌyi guñihchi luꞌh tuhbi naa si luꞌh xlawaaꞌha guzee gaduhbi tihxi luꞌh para gabihldxyi. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Rahbi za Ñiꞌh: ―Neezaa biinloh dxyiꞌdxyi raꞌ riiꞌ desde galohyi: “Cuun chiꞌh zi bwiinn nin taaꞌha cheꞌhla ñiꞌh, nahpa rcaꞌh ba loh dxihtsi pur nin rlaaꞌha ba cheꞌhla ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per naꞌh rñiꞌn loh tu, sidela laꞌh tuhbi ndxiꞌhw taaꞌha ba cheꞌhla ba nicala ayi naa gunnaꞌh chiꞌh bwiinn gubwihlli, ndxiꞌhw chi zuhnn dxiaaba gunnaꞌh chi loh guelgubwihlli chuu xtuꞌh bi, ya nin guchinaa cun tuhbi gunnaꞌh gubwihlli, naa za ba tuhbi bwiinn gubwihlli. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Rahbi za Ñiꞌh: ―Neezaa bihnn tu zaꞌbi dxyiꞌdxyi bihn raꞌ xtaada guldooꞌ tu des galohyi: “Ayi gucweꞌza luꞌh guzaꞌloh luꞌh dxyiꞌdxyi nin guiñiꞌ luꞌh loh Dxiohs.” ");
INSERT INTO zpvNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per naꞌh rñiꞌn ayi cuꞌtii luꞌh lah Dxiohs nee cun lah ziahanru xica raꞌ cohsa chin rudiꞌhi xchiꞌdxyi luꞌh; nin par dxibaaꞌ, laasii dxibaaꞌ naa lahdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nee nin loh guidxyiyuh za, laasii guidxyiyuh naa ziga zi hasta rzuh ñaaꞌ Ñiꞌh, nin guihdxyi Jerusalehn za laasii guihdxyi chi naa xteenn Rehyi nin lasahca ru, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nin laꞌh za tu ayi guchaꞌgarwaaꞌ tu naa gahca tu laasii ayi nuu guunn tu nachitsi o nagasa tuhbi dxiꞌh dxyihchyihca tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sidela gahbi tu “Uuhn”, nahpa gaca uuhn, per sidela gahbi tu “Coh”, nahpa za gacan coh, laasii nin gudziiꞌbaru dxyiꞌdxyi yihca dxyiꞌdxyi raꞌ nin naa xnehza riiꞌ, nadxaaba niꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Rahbi za Ñiꞌh: ―Laꞌh tu bihn dez galohyi guzaꞌbi dxyiꞌdxyi: “Bizloh cun bizloh, nee lahyi cun lahyi.” ");
INSERT INTO zpvNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per naꞌh rñiꞌn, ayi xi guunnee luꞌh nin gusaꞌcazii yiꞌh; mas chaꞌyi sidela niꞌchi chaꞌzi tuhbi lahdu cwahsa derehchu luꞌh, neezaa stuhbi lahdu badiꞌhi. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sidela chyuulla xclaaꞌdzi childxyinee yiꞌh tin cweꞌhelluꞌhu ba xcamiilli luꞌh, neezaa xchiquehta luꞌh basaaꞌn guicaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sidela chyuulla guunn jweersi yiꞌh guꞌa luꞌh tuhbi carga pur tuhbi milla, gwanee si ba chiohpan, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ya cuun chiꞌh zi bwiinn nin guinaaba xiilla loh luꞌh badiꞌhin nee ayi gwaꞌha dxaaba luꞌh loh bwiinn nin rdxiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Rahbi za Ñiꞌh: ―Bihn za tu nuu dxyiꞌdxyi dez galohyi rñiꞌn: “Gaantsiiꞌhi luꞌh xmihgu luꞌh, ya bidxyiꞌchinee laꞌh nin rdxyiꞌchinee yiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per naꞌh rñiꞌn gulgantsiiꞌhi laꞌh nin rdxyiꞌchinee laꞌh tu ya gulcwihdxyi-gulguinaaba loh Dxiohs pur bwiinn nin caꞌhnnaꞌhla guunn mahla laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tin ziꞌchi gaca tu lliiꞌn Xtaada tu nin nuu dxibaaꞌ, pwihsi laꞌh Ñiꞌh rniꞌhi Ñiꞌh gubihdxyi rziaꞌñih yihca raꞌ bwiinn nin rusaguuꞌdzi stoꞌ raꞌ ñiꞌh nez loh Ñiꞌh nee cun neezaa para laꞌh raꞌ bwiinn nin rusahcaloh xchiꞌdxyi Ñiꞌh; nee rusiaaba za Ñiꞌh ñihsadxiah para laꞌh raꞌ bwiinn nin rbwihdxyi-rnaaba laꞌh Ñiꞌh, cun neezaa laꞌh za raꞌ bwiinn nin rusahcaloh xcweenta xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ya sidela yiꞌh gantsiiꞌhi luꞌh nin nadziiꞌhi yiꞌh, ¿cuun xchiꞌh guelnazaꞌca nin guicaꞌha tu? Hasta nin rusadxihlli impwestu para Roma ruhnn raꞌ ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ya sidela gugahpaDxiohs tu laꞌh si nin naa raꞌ bwihtsi tu, ¿cuun xchiꞌh nin naa bwen nin cayuhnn tu? ¿Tayi ziꞌchi gahca dxiꞌh ruhnn raꞌ nin ayi naa raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gulgahca nazaꞌcatiiꞌ, ziga nazaꞌcatiiꞌ za Xtaada tu nin nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Rahbi za Jesuhs: ―Ayi gutiꞌchi tu dxyiꞌdxyi pur dziꞌn zaꞌca si nin ruhnn tu tin sola gwaꞌha raꞌ bwiinn xi ruhnn tu, laasii sidela sola gutiꞌchi tu dxyiꞌdxyi pur xtsiꞌn zaꞌca tu ayi xi guicaꞌha tu loh Xtaada tu nin nuu dxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","niꞌchin chin rudiꞌhi luꞌh guhn laꞌh tuhbi bwiinn prohbi ayi za guuyi luꞌhn loh bwiinn ziahan ziga ruhnn raꞌ bwiinn rusaguiꞌhi raꞌ nez laꞌn guidoꞌ cun loh neziuh raꞌ nezloh raꞌ bwiinn ziahan tin dxiahxinee raꞌ bwiinn chi laꞌh raꞌ ba. Naꞌh rñiꞌn laꞌraꞌ ba gucaꞌha guelnazaꞌca nin ruhn tucahri guicaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chin gudiꞌhi luꞌh guhn laꞌh bwiinn prohbi, ayi gusadxihn luꞌh laꞌh chyuulla nin ruchaꞌga luꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","bwiꞌhnnan per sola yiꞌh si naann luꞌh, ya Xtaada luꞌh nin nuu dxibaaꞌ gwaꞌha Ñiꞌh xa cayuhnn luꞌh cweenta chi cun sola yiꞌh si naann luꞌh, pwihsi zadxihlli Ñiꞌh bwen nin guunn luꞌh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Rahbi za Ñiꞌh: ―Chin cwidxyi-guinaaba tu loh Dxiohs, ayi guunn tu ziga ruhnn raꞌ bwiinn rusaguiꞌhi raꞌ nin riuuꞌstoꞌ raꞌ ñiꞌh gaca lasahca raꞌ nez loh raꞌ bwiinn nee laꞌn guidoꞌ o loh neziuh raꞌ ya rzuꞌnchiigah raꞌ ba rbwihdxyi-rnaaba raꞌ ba loh Dxiohs nicala loh dxiaaꞌ raꞌ laasii riuuꞌstoꞌ raꞌ ba guluuꞌyi raꞌ ba ziga ruhnn raꞌ ba tin guiñiꞌ zaꞌca bwiinn pur laꞌh raꞌ ba, ya guchiin nin rñiꞌn, cun sola ziga ruhnn raꞌ ba riiꞌ laꞌh raꞌ ba bwiꞌhnn gahn nin guicaꞌha raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","per yiꞌh chin cwidxyi-guinaaba luꞌh loh Dxiohs, biuuꞌgarii laꞌñihdzi luꞌh, basieꞌw rwaaꞌ yihdzi luꞌh chihpa ya chiꞌchi gudihdxyi-gunaaba loh Xtaada Dxiohs luꞌh, laasii ziꞌchi laꞌh Ñiꞌh zuunee Ñiꞌh yiꞌh hohra chi, ya gwaꞌha Xtaada luꞌh cayuhnn luꞌh ziga rclaaꞌdzi Ñiꞌh guunn luꞌh zuniꞌhi Ñiꞌh guelnazaꞌca yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nee loh cabwihdxyi-canaaba luꞌh loh Ñiꞌh ayi guunn ziahan xchiꞌdxyi luꞌh ziga ruhn raꞌ bwiinn nin ayi naa raꞌ bwiinn Israel; ruhnn raꞌ ba lligaaba chin rñiꞌ raꞌ ba ziahan dxyiꞌdxyi loh canaaba raꞌ ba loh Dxiohs, mahzi ru cweenta guunn Dxiohs xchiꞌdxyi raꞌ ba per lliaaꞌ zi niꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Niꞌchin ayi gaca tu ziga naa raꞌ ba, laasii laꞌh Xtaada tu nin nuu dxibaaꞌ laꞌh Ñiꞌh naann la cuun nin rchiꞌhn tu galoh nin guinaaba tu loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Laꞌh tu nahpa cwidxyi tu Dxiohs squiiꞌ: Xtaaꞌdahn nin nuu dxibaaꞌ, xclaaꞌdzihn garaa raꞌ bwiinn guiñiꞌ zaꞌca ziga laa luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","xclaaꞌdzizahn gadzihn dxyih dxiꞌ luꞌh guinabwaꞌ luꞌh loh guidxyiyuh ziga rnabwaꞌ luꞌh dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Rnaꞌbaꞌhn guillii-guillii guniꞌhi luꞌh guehta guidaꞌw nu, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","cun basiaꞌlda gahca stoꞌ luꞌh xtuhlda nu nin rañihchi nu loh Yuꞌbiluꞌh ziga rasaguuꞌdzi stoꞌ nu xcweenta bwiinn nin ruñihchi loh nu, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","nee ayi za gusaaꞌn luꞌh coꞌbañuh bwiinndxaaba laꞌh nu chin guiclaaꞌdzi ba sino que guhldaꞌh laꞌh nu loh ba, (laasii xteenn luꞌh naa guelrnabwaꞌ cun gueljweersi, cun llaꞌñih nin naa para tuꞌpazi). ");
INSERT INTO zpvNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Laasii sidela laꞌh tu gusaguuꞌdzi stoꞌ tu cun bwiinn nin ruñihchi xilla ziꞌchi za Xtaada tu nin nuu dxibaaꞌ ziaꞌlda za stoꞌ Ñiꞌh xtuhlda tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","per sidela ayi gusaguuꞌdzi stoꞌ tu pur bwiinn nin ruñihchi xilla loh tu, pwihsi ayi za dxiaꞌldastoꞌ Xtaada tu nin nuu dxibaaꞌ xtuhlda tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Rahbi za Ñiꞌh: ―Chin gucwaaꞌhan tu, ayi guunn nalaasa loh tu ziga ruhnn raꞌ bwiinn nin rusaguiꞌhi bwiinn raꞌ nin ruluuꞌyi nez loh raꞌ bwiinn chin rucwaaꞌhan raꞌ ba ruhnn nalaasa loh raꞌ ba tin gwaꞌha paꞌhcaa bwiinn riigacwaaꞌhan raꞌ ba. Guchiin nin rñiꞌn loh tu cun sola ziga ruhnn raꞌ ba zicaꞌha raꞌ ba nin ruhnn tucahri guicaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Niꞌchin yiꞌh chin gucwaaꞌhan luꞌh, gudxiꞌbi zaꞌca loh luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tin ziꞌchi ayi gacabwaꞌ raꞌ bwiinn nuugacwaaꞌhan luꞌh, tin Xtaada si luꞌh nin nuu dxibaaꞌ gwaꞌha cuun nin cayuhnn luꞌh ya ziꞌchi zuniꞌhi Ñiꞌh guelnazaꞌca yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Rahbi za Ñiꞌh: ―Ayi cwachicwaꞌh tu guelnazaꞌca xteenn tu loh guidxyiyuh riiꞌ, nez rii raꞌ maan nin ruñihchiloh lahdxi cun gubaꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","sino que cwachicwaꞌh luꞌh xixteenn luꞌh dxibaaꞌ nez ayi maan nin guñihchilohon, nez ayi za gubaꞌn cwaanan. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pwihsi nez chuu xquelnazaꞌca luꞌh riꞌchi za chuu stoꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Rahbi za Ñiꞌh: ―Bizloh bwiinn naa ziga biaꞌñih xteenn tihxi ba; pwihsi sidela laꞌh bizloh luꞌh nazaꞌcan, gaduhbi za tihxi luꞌh gahpa biaꞌñih; ");
INSERT INTO zpvNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","per sidela laꞌh bizloh luꞌh rahcan, gaduhbi za tihxi luꞌh nuu loh nacahyi, ¡pwihsi nacahyi duxa guiñah gaduhbi tihxi luꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ayi nin tuhbi bwiinn nin guunn dziꞌn loh chiohpa ballwaaꞌn, laasii zidxyiꞌchinee ba tuhbi ballwaaꞌn chi ya stuhbi ba zahca nadziiꞌhi ba, o gucaꞌstoꞌ ba tuhbi ba ya stuhbi ba zibweꞌhestoꞌ ba. Ya niꞌchin ayi nuu gucaꞌstoꞌ ba laꞌh Dxiohs sidela xquelnazaꞌca si ba cadxiꞌhyi ba loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Niꞌchin nin naꞌh guiñiꞌn loh tu, ayi guunn tu ziahan lligaaba pur nin gahw tu o pur nin guee tu para guibahan tu, nee ayi za chuu tu ziahan lligaaba ca nehza sah xahba tu nin gacu tu. ¿Tayi zirooꞌ ru dxiꞌh lasahca xquelnabahan bwiinn loh ziga nin rahw raꞌ ba, ya neezaa tihxi bwiinn zirooꞌ ru lasahcan loh ziga lahdxi nin rahcu ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gulguiꞌhnn lligaaba maaniꞌhn raꞌ nin rzuh loh bwih xaloh nabahan raꞌ ma ayi raaꞌn raꞌ ma, ayi za rataaꞌha raꞌ ma guiñaꞌh, nee ayi za rguꞌchaꞌyi raꞌ ma ñihza laꞌn yuuꞌ ziga ruhnn tu, per nicala ayi xi nahpa raꞌ ma, Xtaada Dxiohs tu nin nuu dxibaaꞌ rudiꞌhi xi rahw raꞌ ma. Pwihsi laꞌh tu, ¿tayi ruhn tu lligaaba mahzi ru lasahca tu loh maaniꞌhn raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pwihsi nicala riuuꞌ ru tu ziahan lligaaba, ¿xa guunn luꞌh guchiooꞌ ru luꞌh xquelnabahan luꞌh mas tuhbi hohra? ");
INSERT INTO zpvNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Xixnaa chiꞌh riuuꞌ tu lligaaba canehza sah xahba tu? Gulguiꞌhnn lligaaba dxiaꞌ billiiga raꞌ xa rrooꞌ raꞌn loh dahan: ayi xi dziꞌn ruhnn raꞌn, ayi za rdxihba raꞌn lahdxi. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pwihsi rñiꞌn loh tu nin rrehyi Salomohn nicala ziahan rooꞌ guelnazaꞌca raꞌ nin guhpa ba, nicala guhta ba lahdxi zaꞌca per ayi guhldaa ñiñah xahba ba ziga paꞌh dxiaꞌ raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sidela ziꞌchi rzuhchaꞌyi Dxiohs laꞌh raꞌ cwaꞌn nagaa raꞌ nin rñiah joosca raꞌ nin rii loh dahan nee guillii guicaꞌdxihin loh dxih, niꞌchin ¿xilaꞌh xchiꞌh laꞌhtu ayi dxiaꞌn guniꞌhi Ñiꞌh nin rchiꞌhn tu bwiinn nahda raꞌ nin ayi riuuꞌ ayi riaꞌzi dxyiꞌdxyi xcweenta Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pwihsi ayi chuu tu lligaaba guiñiꞌ tu: “¿Xi guidaꞌw chiꞌh nuꞌh?”, o “¿Canehza sah lahdxi guidxiaacu nu?”, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","laasii bwiinn nin ayi nuꞌnbwaꞌ Dxiohs riuuꞌ raꞌ ba lligaaba xa guidxeela raꞌ ba garaa raꞌ cohsa riiꞌ, per laꞌh tu nahpa tu tuhbi Xtaada tu nin nuu dxibaaꞌ ya naann Ñiꞌh cuun nin rchiꞌhn tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","niꞌchin gulgadxiꞌhyi loh xquelrnabwaꞌ Ñiꞌh nee gulgazoꞌbadxiahga gahca xchiꞌdxyi Ñiꞌh, ya ziꞌchi zuniꞌhi Ñiꞌh garaa nin guichiꞌhn tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ayi gusioꞌba yihca tu pur dxyih guillii, laasii guillii ziuuꞌ nin gusioꞌba yihca tu, laasii cada tuhbigah dxyih raꞌ zeꞌnee raꞌn lligaaba nin rusioꞌba yihca bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Rahbi za Ñiꞌh: ―Ayi guluuꞌyi xcwihin tu lasaaꞌ tu tin ayi za guluuꞌyi xcwihin za Dxiohs laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","laasii sidela laꞌh tu guiñiꞌyah tu lasaaꞌ tu pwihsi ziñiꞌyah za Dxiohs laꞌh tu zigapaꞌh guunnee tu lasaaꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Xixnaa rzuu luꞌh rutaꞌtsi luꞌh dxihlli nin nuu laꞌn bizloh bwihtsi luꞌh, nee ayi rwaꞌha xgah luꞌh baltaadxiu nin nuu laꞌn bizloh luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nee sidela yiꞌh nuu tuhbi taaꞌha baltaadxiu laꞌn bizloh luꞌh, ¿xalla guunn chiꞌh luꞌh gahbi luꞌh loh bwihtsi luꞌh: “Daꞌnee loh luꞌh gabweꞌhehn dxihlli nin nuuꞌhun”? ");
INSERT INTO zpvNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Bwiinn nin nihin riaꞌzi dxyiꞌdxyi yihca ñiꞌh! Babweꞌhexgah baltaadxiu nin nuu loh luꞌh, ya tin ziꞌchi dxiin loh luꞌh gabweꞌhe luꞌh dxihlli nin nuu laꞌn bizloh bwihtsi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ayi gudiꞌhi tu xcohsa zaꞌca Dxiohs laꞌh chyuu chiꞌh zi bwiinn raꞌ nin naa raꞌ zigazi bwehcu raꞌ, tin ayi gabiaꞌgariinee raꞌ ba laꞌh tu chindxinee raꞌ ba laꞌh tu hasta dxyigah guzuꞌhyi raꞌ ba laꞌh tu. Ziꞌchi gahca za cohsa raꞌ nin lasahca ru ayi gudiꞌhi tun loh chyuu chiꞌh zi bwiinn laasii nuu raꞌ ba naa raꞌ ba zigazi cuuchi, rbweꞌhestoꞌ raꞌ ba cohsa zaꞌca raꞌ chi ya naa raꞌ ba ziga cuuchi nin guzuꞌñaaꞌ raꞌ ba yihcan. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Rahbi za Ñiꞌh: ―Gulchezah gulguinaaba nin rchiꞌhn tu, pwihsi Dxiohs zuniꞌhi Ñiꞌh nin guinaaba tu; sidela xiilla chezah chiꞌhyi tu zidxeela tun, ziga nin guiclaaꞌdzi tu; sidela chezah gusihdzi tu rwaaꞌ yuuꞌ pwihsi zillaalan, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","laasii bwiinn nin riazah canaaba xiilla rcaꞌha ban; ya bwiinn nin riazah cadxiꞌhyi xiilla rdxeela ban; ya bwiinn nin riazah cagasihdzi rwaaꞌleeꞌ rllaalan tin riuuꞌtii ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Niꞌchin laꞌh tu sidela chyuulla tuhbi tu guinaaba lliiꞌn tu nin gahw bi, ¿ta ziaalla tu gudiꞌhi tu dxiah gahw bi xlaawaaꞌha guehta? ");
INSERT INTO zpvNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o ¿gu gudiꞌhi tu tuhbi bweꞌlda gahw bi chin guinaaba bi bwehlda? ");
INSERT INTO zpvNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pwihsi laꞌh tu nicala naa tu bwiinn nadxaaba raꞌ per naann tu xa gudiꞌhi tu cohsa zaꞌca laꞌh raꞌ lliiꞌn tu; ¡xi laꞌhxchiꞌh Xtaada tu nin nuu dxibaaꞌ ayi dxiaꞌhan gudiꞌhi Ñiꞌh cohsa zaꞌca laꞌh raꞌ bwiinn nin guinaaban loh Ñiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pwihsi, ziꞌchi garaa raꞌ cohsa nin xclaaꞌdzi tu guunnee raꞌ bwiinn laꞌh tu, ziꞌchi za gulguiꞌhnnan laꞌh raꞌ ba, laasii dee raꞌ naa nin rnabwaꞌ xlehyi Moisehs cun neezaa zigapaꞌh nin bacaꞌh raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Rahbi za Ñiꞌh: ―Gulguiꞌhnn jweersi chuꞌtii tu nez rwaaꞌ leeꞌ biꞌtuꞌhn, laasii rwaaꞌ leeꞌ cun loh neziuh nin zee para gabihldxyi nabiꞌhyin, ya ziahan raꞌ bwiinn rnaꞌzu nehz chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","per rwaaꞌ leeꞌ cun loh neziuh nin rianee laꞌh bwiinn loh guelnabahan nacuubi biꞌtiꞌhnan nee nagahnzan; niꞌchin gulliaaꞌhayiꞌhn naa raꞌ bwiinn nin radxeela neziuhyiꞌhn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Gulgahca nasiin pur bwiinn raꞌ nin rclaaꞌdzi gusaguiꞌhi laꞌh raꞌ bwiinn; rñiꞌ si raꞌ ba ruluuꞌyi raꞌ ba xchiꞌdxyi Dxiohs, nee rluuꞌyi si nadoꞌlaaꞌdzi raꞌ ba ziga tuhbi lliꞌhyi, per nez laꞌn lastoꞌ raꞌ ba naa ziga zi tuhbi maan nin laa lohbo nin ñaꞌlaaꞌdzi duxa, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","per xtsiꞌn raꞌ ba zuhnn tin dxiuꞌnbwaꞌ raꞌ tu laꞌh raꞌ ba, pwihsi laꞌh tu naann ayi rcah uhva loh yahguichaaꞌ, ayi za rcah ñiigu loh yaguihchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pwihsi garaa raꞌ yahga zaꞌca rcah raꞌ ñinahxi zaꞌca lohon, ya yahga dxaaba raꞌ rcah za ñinahxi dxaaba loh raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yahga zaꞌca raꞌ ayi nuu guicah ñinahxi dxaaba loh raꞌn, ya nin yahga dxaaba za ayi nuu guicah ñinahxi zaꞌca loh raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ya garaa raꞌ yahga nin ayi rcah ñinahxi zaꞌca loh raꞌ ñiꞌh, chyuuga raꞌn tin guicaꞌdxih raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ziꞌchi gahca za zahca dxiuꞌnbwaꞌ tu bwiinn zaꞌca laasii ruhnn raꞌ ba dziꞌn zaꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ayi garaa raꞌ dxiꞌh nin rñiꞌ loon: “¡Ballwaaꞌn, ballwaaꞌn!”, chuꞌtii loh guelrnabwaꞌ xteenn Dxiohs nin nuu dxibaaꞌ, sino que laꞌh si nin guzoꞌbadxiahga guunn ziga rclaaꞌdzi Xtaaꞌdahn nin nuu dxibaaꞌ gaca. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ziuuꞌ ziahan raꞌ nin guiñiꞌ loon: “¡Ballwaaꞌn, ballwaaꞌn! ¿Tayi laꞌh dxiꞌh nu bachidiꞌyidxyiꞌdxyi nu xchiꞌdxyi luꞌh pur lah Yuꞌbiluꞌh, nee pur lah za Yuꞌbiluꞌh babweꞌhe nu bwiinndxaaba stoꞌ raꞌ bwiinn, nee cun lah za Yuꞌbiluꞌh bachidiꞌhnn nu ziahan dziꞌn rooꞌ raꞌ?” ");
INSERT INTO zpvNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Per chiꞌchi guiñiꞌn loh raꞌ ba: “Ayi nuꞌnbwaꞌtiiꞌhihn laꞌh tu; ¡mas chaꞌyi gulchesuu nez loon laasii laꞌh tu nin ruhnn ganaalla dziꞌn dxaaba raꞌ!” ");
INSERT INTO zpvNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Rahbi za Ñiꞌh: ―Niꞌchin bwiinn nin riuuꞌ-riaꞌzi xchiꞌdxyiꞌhn, bwiinn chi naa ziga tuhbi bwiinn nasiin nin bwiꞌhnn yihdzi ñiꞌh yihca tuhbi dxiahnguihdzi, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","biaaba ñihsadxiah xihn ya biehta ñisyuhdoꞌ guiꞌw raꞌ cun bwih duxa tin ñuhcwihin yuuꞌ chi per ayi bwiꞌhnnan gahn, laasii chihpa bidxiꞌdxiu simientu xteenn yuuꞌ chi yihca dxiah chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per bwiinn raꞌ nin rcaꞌdxiahga si xchiꞌdxyiꞌhn ziga zi xiilla dxyiꞌdxyi si raꞌ nee ayi riuuꞌ ayi riaꞌzi raꞌ ban bwiinn raꞌ chi naa ziga si tuhbi bwiinn paꞌhyi nin bwiꞌhnn yihdzi ñiꞌh loh tuhbi playi yuhlli, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ya biaaba tuhbi ñihsadxiah xihn ya biehta ñisyuhdoꞌ guiꞌw raꞌ cun bwih duxa ya bacwihin yuuꞌ chi nin rraxtra yuuꞌ chi ayi biaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ya chin guyaꞌloh guñiꞌ Jesuhs loh garaa raꞌ bwiinn nin rii riꞌchi, badxyigaaꞌ loh raꞌ ba cwenta ziga ruluuꞌyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","laasii ruluuꞌyi Ñiꞌh zigapaꞌh tuhbi nin nahpa guelrnabwaꞌ, ayi ziga dxiꞌh ruluuꞌyi raꞌ mwehsu nin ruluuꞌyi xlehyi Moisehs. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ya chin biehta Jesuhs yihca dahan chi, ziahan duxa raꞌ bwiinn zieꞌganaꞌhla laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ya loh zeezah Ñiꞌh gwabiiga tuhbi bwiinn nin rahchyi guiiꞌdxiu tihxi ñiꞌh nez loh Jesuhs, lwehgu bazuꞌnllihbi ba loh Ñiꞌh chiꞌchi rahbi ba loh Jesuhs: ―Daada, sidela ziziꞌguehlda luꞌh zuhnn luꞌh gahn gusiaca luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ya chiꞌchi basagaꞌh Jesuhs naa Ñiꞌh tin cun naa Ñiꞌh bidxiꞌ Ñiꞌh tihxi ba, chiꞌchi rahbi Ñiꞌh: ―Xclaaꞌdzihn dxiaa tihxi luꞌh. Ya hohra chi gahca guñihchiloh raꞌ guiiꞌdxiu chi tihxi bwiinn chi ya biaca ba gueldxyihdxyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ya chiꞌchi rahbi Jesuhs loh ba: ―Ayi chyuloo guuyitiiꞌ luꞌh xa biaca luꞌh, sola gwagaluuꞌyi tihxi luꞌh laꞌh si bixohza tin gwaꞌha ba laꞌluꞌh biaca, nee chenee za luꞌh tuhbi guelguhn xcweenta nin biaca luꞌh ziga rnabwaꞌ xlehyi Moisehs tin garaa raꞌ bwiinn gacabwaꞌ raꞌ ba laꞌluꞌh biaca gueldxyihdxyi nin guhca luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ya loh guyuuꞌtii Jesuhs rwaaꞌ guihdxyi Capernaum, badzihn tuhbi capitahn Romanu loh Ñiꞌh tin gudxiꞌhn ba loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","rahbi ba: ―Daada, tuhbi xmooꞌzahn cayahcalluꞌhu rwaaꞌ yiidzihn, ayi nuu guiñiꞌbi bi nee nugasaꞌcazii guelnayaan duxa laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chiꞌchi rahbi Jesuhs: ―Zizaꞌhn tin gusiaꞌcahn laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ya chiꞌchi rahbi capitahn chi: ―Xtaaꞌdahn naꞌh, ayi xi lasahcaꞌhn tin bweꞌzi guzee Yuꞌbiluꞌh rwaaꞌ yiidzihn; cun sola guñiꞌ luꞌh tuhbi xchiꞌdxyi Yuꞌbiluꞌh pur gueldxyihdxyi riiꞌ ya zariaꞌhan tihxi xmooꞌzahn, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","laasii neezaa naꞌh naan xmooza raꞌ bwiinn nin rnabwaꞌ naꞌh, ya ziꞌchi gahca za naꞌh rnabwaꞌn suldahdu, ya chin raꞌpihn loh tuhbi raꞌ ba: “Gwah”, riah ba; ya chin raꞌpihn loh stuhbi ba: “Gudaaꞌ”, riꞌ ba; ya chin raꞌpihn loh xmooꞌzahn: “Bwiꞌhnn deeꞌ”, ruhnn ban. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ya chin bihn Jesuhs dxyiꞌdxyi raꞌ riiꞌ, badxyigaaꞌ duxa loh Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh raꞌ bwiinn nin naꞌhla laꞌh Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, nin loh raꞌ bwiinn Israel nagahdxi guidxeelaꞌhn nin tuhbi bwiinn nin mahzi riachii ru stoꞌ ñiꞌh xchiꞌdxyiꞌhn ziga riachiistoꞌ ndxiꞌhw riiꞌhin, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","nee rñiꞌn loh tu ziahan raꞌ bwiinn dxiꞌ nez lahdu hasta rtahn gubihdxyi cun nez lahdu hasta riaꞌzi gubihdxyi, ya zizohbanee raꞌ ba laꞌh guehtu Abrahn, cun laꞌh guehtu Isaac cun guehtu Jacob loh mweella llaaꞌndxibaaꞌ hasta nuu Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","per bwiinn Israel raꞌ nin ayi guyuuꞌ-guyaꞌzi xchiꞌdxyi Dxiohs, bwiinn raꞌ chi guxeꞌhla Dxiohs loh nacahyi hasta gutiꞌdxiloh raꞌ ba guelrzaꞌcazii duxa, riꞌchi hasta dxigah sihdzi gahw loh lahyi raꞌ ba cun guꞌn nalasa duxa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ya chiꞌchi rahbi Jesuhs loh capitahn chi: ―Gubiaꞌgarii yihdzi luꞌh, laasii nnah gaca ziga gwachiistoꞌ luꞌh naꞌh. Ya hohra chi gahca biaca xmooza capitahn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chiꞌchi gwah Jesuhs yihdzi Pehdru, riꞌchi bwaꞌha Jesuhs cayahcalluꞌhu xnaan swehgra Pehdru jwerta rooꞌ nuu ba lliaꞌh, naꞌ ba loh luꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ya bidxiꞌ si Jesuhs naa naan chi, ya lwehgu bariaꞌh lliaꞌh chi tihxi ba, ya chin gwastii naan chi lwehgu bwiꞌhnn ba tuhbi guelwahw para laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ya hohra nin zeꞌbwih gueꞌla gwanee raꞌ bwiinn laꞌh ziahan raꞌ bwiinn nin guyuuꞌ bwiinndxaaba stoꞌ raꞌ ñiꞌh loh Jesuhs, ya cun tuhbigah si dxyiꞌdxyi guñiꞌ Jesuhs loh raꞌ bwiinndxaaba raꞌ chi lwehgu si bariaꞌh raꞌ bwiinndxaaba raꞌ chi, ya cun neezaa basiaca Ñiꞌh laꞌh garaatiiꞌ raꞌ bwiinn raꞌ nin guhcalluꞌhu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Squiiꞌ guhca tin guzohba dxyiꞌdxyi xcweenta ziga guñiꞌ guehtu Isaías chin guñiꞌ ba: “Laꞌh ba gucaꞌha xqueldxyihdxyi raꞌ nuꞌh, ya zenee za ba xquelnayaan raꞌ nuꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ya chin bwaꞌha Jesuhs ziahan raꞌ bwiinn rii gadiidxi Ñiꞌh, chiꞌchi gunabwaꞌ Ñiꞌh tiidxinee Ñiꞌh xpwiinn raꞌ Ñiꞌh stuhbi lahdu rwaaꞌ laguhn, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ya riꞌchi gwabiiga tuhbi mwehsu nin ruluuꞌyi xlehyi Moisehs loh Jesuhs ya rahbi ba: ―Mwehsu, xclaaꞌdzihn dxieꞌlda naꞌhlaꞌhn Yuꞌbi luꞌh nez hasta chiꞌh zi guzee luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Chiꞌchi rahbi Jesuhs: ―Bweeꞌzu nahpa raꞌ ma guiiꞌdxiu hasta riuuꞌ raꞌ ma, ya maaniꞌhn raꞌ nuu xpichiehza raꞌ ma, per naꞌh ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, nin hasta gucuꞌgaꞌhn ayi naꞌpahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ya chiꞌchi rahbi tuhbi nin naa xpwiinn Ñiꞌh loh Ñiꞌh: ―Daada, mas chaꞌyi basaaꞌn naꞌh guziaaꞌhahn tin chegacaꞌtsixgaaꞌn xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ya chiꞌchi rahbi Jesuhs: ―Gudaꞌnaꞌhla si naꞌh, ya basaaꞌn gucaꞌtsi raꞌ bwiinn guuchi laꞌh raꞌ lasaaꞌ bwiinn guuchi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ya chin guyuuꞌtii Jesuhs laꞌn tuhbi laancha, cun neezaa raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ya loh zeezahnee laancha chi laꞌh Ñiꞌh cun xpwiinn Ñiꞌh guzoꞌbaloh tuhbi bwih rooꞌ loh ñihsadoꞌ chi ya ola xteenn ñihsadoꞌ chi hasta dxyigah rbiꞌhyin yihca laancha chi, ya laꞌh Jesuhs mwersi hohra chi gutaꞌllgahsi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ya chiꞌchi gwagacwaꞌn raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh tin rahbi raꞌ ba loh Ñiꞌh: ―¡Daada, bataꞌh xquelnabahan raꞌ nuꞌh laasii laꞌh nuꞌh cazaꞌbi ñihsa! ");
INSERT INTO zpvNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xixnaa rdxyihbi duxa tu? ¡Lliꞌballa gulliaaꞌha naa ziga riachiistoꞌ tu xchiꞌdxyi Dxiohs! Guyaꞌloh si guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi gwasuꞌnchii Ñiꞌh tin gunabwaꞌ Ñiꞌh laꞌh bwih cun ñihsadoꞌ chi tin guridxyii raꞌn, ya dxyii si babwih raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ya garaa raꞌ xpwiinn raꞌ Ñiꞌh badxyigaaꞌ duxa loh raꞌ ba, chiꞌchi tuhbigah raꞌ ba gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba rahbi raꞌ ba: ―¿Chyuulla naa bwiinn rii? ¡Bwaꞌha hasta bwih cun ñihsadoꞌ ruzoꞌbadxiahga raꞌ xchiꞌdxyi ba! ");
INSERT INTO zpvNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ya chin badzihn Jesuhs nez stuhbi lahdu rwaaꞌ laguhn xteenn Gadara, riꞌchi laꞌh chiohpa raꞌ bwiinn nin nuu bwiinndxaaba stoꞌ raꞌ ñiꞌh bariaꞌh lahda raꞌ baꞌ, ya chiꞌchi gwabiiga raꞌ ba loh Jesuhs, nez chi ñaꞌlaaꞌdzi duxa raꞌ ba nin tuhbi bwiinn ayi nuu sah neziuh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ya lwehgu guzoꞌbaloh rbwihdxyidxiah raꞌ ba rahbi raꞌ ba: ―¿Cuun nin rclaaꞌdzi luꞌh guunnee luꞌh laꞌh nu, Jesuhs Lliiꞌn Dxiohs nin nuu nabahan dziꞌtsi dxibaaꞌ? ¿Ta zeꞌ luꞌh riiꞌ tin gusaꞌcazii luꞌh laꞌh nu galoh nin riaꞌdxi ru guigaꞌha chieempa? ");
INSERT INTO zpvNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nee gahxu riꞌchi riiyahw raꞌ nuhn raꞌ cuuchi loh dahan chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ya gudxiꞌhn raꞌ bwiinndxaaba raꞌ nin nuu stoꞌ raꞌ bwiinn chi loh Jesuhs rahbi raꞌ ba: ―Sidela yiꞌh gabweꞌhe luꞌh laꞌh nu stoꞌ bwiinn raꞌ riiꞌ, basaaꞌn chuꞌtii nu stoꞌ raꞌ cuuchi riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinndxaaba raꞌ chi: ―¡Gulcheh! Ya chiꞌchi bariaꞌh raꞌ bwiinndxaaba raꞌ chi stoꞌ raꞌ ndxiꞌhw raꞌ chi ya chiꞌchi guyuuꞌtii raꞌ ba stoꞌ raꞌ cuuchi, ya hohra gahca chi, garaatiiꞌ raꞌ cuuchi raꞌ chi gwatsiꞌbichii raꞌ ma rwaaꞌ tuhbi gueeꞌla, ya riꞌchi gwaaꞌñihsa raꞌ ma, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ya chin bwaꞌha raꞌ nin cayahpa raꞌ laꞌh cuuchi raꞌ chi ziꞌchi guhca, balluꞌn raꞌ ba ziaa raꞌ ba, ya chin badzihn raꞌ ba lahdxyi raꞌ ba bwiiꞌyidxyiꞌdxyi raꞌ ba garaa ziga guzahca raꞌ ba nee cun neezaa ziga babweꞌhe Jesuhs bwiinndxaaba stoꞌ raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ya chiꞌchi garaa raꞌ bwiinn guihdxyi raꞌ chi biriaꞌh raꞌ ba tin gwah raꞌ ba hasta zuu Jesuhs, ya chin badzihn raꞌ ba hasta zuu Ñiꞌh gunaaba raꞌ ba loh Ñiꞌh tin bareꞌh Ñiꞌh lahdxyi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ya chin guyaꞌloh guhca raꞌ deeꞌ, gucah Jesuhs laꞌn tuhbi laancha tin gudiiꞌdxi Ñiꞌh rwaaꞌ laguhn ya badzihn Ñiꞌh lahdxyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ya riꞌchi gwanee raꞌ bwiinn tuhbi bwiinn nin ayi guhca ñiñiꞌbi, naꞌ ba loh tuhbi luꞌhn, ya chin bwaꞌha Jesuhs ziga riachiistoꞌ raꞌ bwiinn chi laꞌh Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh bwiinn nin rahcalluꞌhu chi: ―Biahxi xiiꞌhihn; laꞌh xtuhlda luꞌh basiaꞌpitiin. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ya chiꞌchi laꞌh paaldaa raꞌ mwehsu nin ruluuꞌyi lehyi Moisehs nin rii riꞌchi bwiꞌhnn raꞌ ba lligaaba: ―¡Dxyiꞌdxyi raꞌ nin guñiꞌ deeꞌ naan dxyiꞌdxyi raꞌ nin rñiꞌyah laꞌh Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per laꞌh Jesuhs laꞌh Ñiꞌh guhcabwaꞌ cuun lligaaba nin riiyuhnn raꞌ ba niꞌchin gunaabadxyiꞌdxyi Ñiꞌh loh raꞌ ba rahbi Ñiꞌh: ―¿Xixnaa nuu tu lligaaba dxaaba raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Cuun nin mahzi ayi guinagahn guiñiꞌn? ¿Ta gaꞌpihn: “Laꞌh xtuhlda luꞌh basiaꞌpitiin”, o gaꞌpihn: “Gwastii tin guzah”? ");
INSERT INTO zpvNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pwihsi riiꞌ guluꞌyiꞌhn nez loh tu tin gwaꞌha tu naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw nee naꞌpahn guelrnabwaꞌ para gusiaꞌpitiin xtuhlda raꞌ bwiinn guidxyiyuh. Ya chiꞌchi rahbi Ñiꞌh loh bwiinn nin ayi guhca ñiñiꞌbi chi: ―Gwastii, tin gucaꞌha xluꞌhn luꞌh batiaaꞌhan tin bwaa yihdzi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ya seguihdu gahca gwastii bwiinn nin ayi guhca ñiñiꞌbi chi chiꞌchi banaꞌzu nehza ba ziaa ba para yihdzi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ya bwiinn raꞌ nin rii riꞌchi chin bwaꞌha raꞌ ba nin bwiꞌhnn Jesuhs, bidxyihbi raꞌ ba ya guzoꞌbaloh cagadiꞌhi raꞌ ba guelzuxchiilli laꞌh Dxiohs pur nin baluuꞌyi Ñiꞌh nahpa Ñiꞌh guelrnabwaꞌ rusiaꞌpitii Ñiꞌh xtuhlda raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ya chin guyaꞌloh niꞌchi, chiꞌchi bariaꞌh Jesuhs riꞌchi, ya delaanta ru bwaꞌha Ñiꞌh laꞌh tuhbi bwiinn nin laa Mateu, zohba ba tuhbi lahta hasta rusadxihlli ba xcweenta impweestu para Roma, ya chiꞌchi rahbi Jesuhs loh ba: ―Gudaꞌnaꞌhla naꞌh. Chiꞌchi gwasuꞌnchii Mateu tin zeenaꞌhla ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ya loh nin zohbayahw Jesuhs tuhbi guelwahw loh mwella rwaaꞌ yihdzi Mateu riꞌchi badzihn za ziahan raꞌ nin rusadxihlli xcweenta impwestu Roma, cun snuhn raꞌ bwiinn nin ayi ruhnn cweenta xlehyi Moisehs, ya guzoꞌbanee raꞌ ba laꞌh Ñiꞌh hasta zuu mwella tuhsi junta cun xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ya chin bwaꞌha raꞌ bwiinn guidoꞌ nin laa fariseu raꞌ zohbanee Jesuhs laꞌh raꞌ bwiinn duhlda raꞌ chi loh mweella, chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh raꞌ xpwiinn Ñiꞌh rahbi raꞌ ba: ―¿Xixnaa rahwnee xmwehsu tu laꞌh raꞌ nin rusadxihlli xcweenta impwestu cun bwiinn duhlda raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ya chin bihn Jesuhs riiñiꞌ raꞌ ba ziꞌchi chiꞌchi rahbi Ñiꞌh: ―Bwiinn raꞌ nin ayi xi rahca ayi rchiꞌhn chee raꞌ ba loh dutohra, niꞌchin mas chaꞌyi radxiꞌhyi dutohra hasta rahcalluꞌhu raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","niꞌchin nnah guldxiaa tin gulgasiꞌdxi xcweenta nin zeꞌ loh Xchiꞌdxyi Dxiohs tin gacabwaꞌ tu nin rñiꞌin: “Naꞌh rclaaꞌdzihn galahsa stoꞌ tu lasaaꞌ tu, ayi rclaaꞌdzihn guniꞌhi tu guhn naꞌh.” Pwihsi naꞌh ayi zeꞌldatiidxi dxiꞌhn laꞌh raꞌ bwiinn nin nazaꞌca sino que zeꞌldahn tin cwiidxihn laꞌh raꞌ bwiinn nin nuu raꞌ xtuhlda ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Xpwiinn raꞌ Jwahn nin ruroꞌbañihsa gwabiiga raꞌ ba loh Jesuhs tin gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―Laꞌh nu cun bwiinn fariseu raꞌ ziahan racwaaꞌhan nu; ¿xixnaa chiꞌh laꞌh raꞌ xpwiinn raꞌ luꞌh ayi rucwaaꞌhan raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chiꞌchi rahbi Jesuhs: ―¿Ta zahca cwih nalaasa bwiinn raꞌ nin biduꞌhun zee raꞌ saaꞌ gaduhbi nin zuunee nuꞌbinbahyi laꞌh raꞌ bwiinn saaꞌ chi? Per ziuuꞌ dxyih chin guiriaꞌcaa nin bachinaa loh raꞌ ba chiꞌchisihn ayi ru cheezah saaꞌ ya zucwaaꞌhan raꞌ bwiinn saaꞌ raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","nee ayi za nin tuhbi bwiinn nin dxiuꞌnzaꞌca tuhbi lahdxi yuꞌxa guunn ban rramieenda cun tuhbi lahdxi cuubi laasii ayi dxiaꞌhan zaꞌcan nahpa lahdxi cuubi chyi rgooꞌbañuhun laꞌh lahdxi yuꞌxa chi ya rdxiꞌllun laꞌh lahdxi yuꞌxa chi ya ziꞌchi riazahtiiꞌ ruzuꞌhyin laꞌh lahdxi yuꞌxa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ya ziꞌchi za vihnnu cuubi ayi guidaꞌh laꞌn dxihdxi yuꞌxa, laasii zichiehzan dxihdxi yuꞌxa chi, ya ziꞌchi ziñihchiloh vihnnu chi cun dxihdxi chi. Niꞌchin nahpa guidaꞌh vihnnu cuubi laꞌn dxyihdxyi cuubi tin ziꞌchi nin tuhbi raꞌn ayi ñichilohon. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ya gaduhbi nin cañiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ, badzihn tuhbi ndxiꞌhw nin lasahca loh raꞌ bwiinn Israel, ya lwehgu bazuꞌnllihbi ba loh Jesuhs, chiꞌchi rahbi ba: ―Laꞌh lliiꞌndxaꞌpaꞌhn guyaꞌloh guhchi nnahpaꞌh, per sidela yiꞌh sah luꞌh ya gudziiꞌba naa luꞌh yihca bi, zibiaꞌgarii xquelnabahan bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ya hohra chi gahca zeenee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh tin zeenee Ñiꞌh laꞌh xtaada dxaꞌpa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ya loh zeezah Jesuhs guyuuꞌ tuhbi gunnaꞌh nin zeenaꞌhla laꞌh Ñiꞌh; gunnaꞌh riiꞌ naa la tsiꞌh bichiohpa yihza canee bi tuhbi gueldxyihdxyi xteenn nin naa bi gunnaꞌh ya hohra chi gwabiiga bi nez dihtsi Jesuhs ya bidxiꞌ bi loh xahba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","laasii bwiꞌhnn bi lligaaba: ―Sidela naꞌh guidxiꞌn loh xahba Jesuhs ziaacaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Per laꞌh Jesuhs lwehgu gubiaꞌgarii Ñiꞌh bwaꞌha-bwaꞌha Ñiꞌh loh gunnaꞌh chi, chiꞌchi rahbi Ñiꞌh: ―Gulahchidxyii stoꞌ luꞌh xiiꞌhihn; pur nin gwachiistoꞌ luꞌh naꞌh niꞌchin nnah laꞌh luꞌh biaca. Ya sequihdu desde hohra chi gahca biaca gunnaꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ya loh zee gahdzihn Jesuhs rwaaꞌ yihdzi bwiinn nin rnabwaꞌ laꞌh raꞌ bwiinn Israel, bwaꞌha Ñiꞌh riiyuꞌlda raꞌ muusca para chegacaꞌtsi raꞌ ba laꞌh dxaꞌpwiꞌhn chi, cun nee raꞌ za bwiinn raꞌ nin rii raꞌ riꞌchi ruꞌn duxa raꞌ ba pur nin guhchi dxaꞌpwiꞌhn chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","chiꞌchi rahbi Jesuhs: ―Gulgariaꞌh laꞌn ca, laasii dxaꞌpwiꞌhn riiꞌ ayi guhchi dxiꞌh bi, sino que naꞌllgahsi si bi. Ya bwiinn raꞌ chi chin bihn raꞌ ba guñiꞌ Jesuhs ziꞌchi, sola ballihdzinee raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","chiꞌchi babweꞌhe Jesuhs laꞌh raꞌ bwiinn chi laꞌñuuꞌ chi, chiꞌchi gunaꞌzu Ñiꞌh naa dxaꞌpwiꞌhn chi, ya hohra chi gahca gwastii bi, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ya bidiꞌchi dxyiꞌdxyi loh garaa raꞌ guihdxyi raꞌ nin rii gadiidxi guihdxyi chi bacwaꞌhn Jesuhs laꞌh dxaꞌpwiꞌhn chi loh guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ya loh nin bariaꞌh Jesuhs nez bacwaꞌhn Ñiꞌh laꞌh dxaꞌpwiꞌhn nin guhchi, gwanaꞌhla chiohpa bwiinn nin ayi riin loh ñiꞌh laꞌh Jesuhs zeebwihdxyidxiah raꞌ ba rahbi raꞌ ba: ―¡Balahsa stoꞌ luꞌh laꞌh nu, lliiꞌn guehtu Davihd! ");
INSERT INTO zpvNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ya chin guyuuꞌtii Jesuhs laꞌn tuhbi yuuꞌ, chiꞌchi gwabiiga raꞌ garoopa bwiinn raꞌ nin rahca loh ñiꞌh chi nez zuu Jesuhs, ya chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh loh raꞌ bwiinn raꞌ chi rahbi Ñiꞌh: ―¿Ta ruhnn tu lligaaba zahca gusiaꞌcahn loh tu? Chiꞌchi rahbi raꞌ ba: ―Zuhnn luꞌh gahn daada. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ya chiꞌchi cun naa Ñiꞌh bidxiꞌ Ñiꞌh loh raꞌ ba, cun rahbi za Ñiꞌh: ―Nahpa zohba gahca ziga riachiistoꞌ tu zahca gusiaꞌcahn loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ya ziꞌchi zi gubiaꞌgarii bwaꞌha raꞌ bwiinn chi, ya guñiꞌ Jesuhs loh raꞌ ba rahbi Ñiꞌh: ―Nee ayi guuyi tu dxyiꞌdxyi tin ayi gariaꞌcaa dxyiꞌdxyi xcweenta ziga gubiaꞌgarii gwaꞌha bizloh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per laꞌh raꞌ bwiinn chi ayi gudxihpa stoꞌ raꞌ ba, lwehgu batiꞌchi raꞌ ba dxyiꞌdxyi gaduhbitiiꞌ guihdxyi chi nin basiaca Jesuhs bizloh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ya loh nin babii raꞌ bwiinn nin biaca loh raꞌ ñiꞌh, paaldaa raꞌ bwiinn badzihnnee raꞌ ba laꞌh tuhbi bwiinn goopa nin nuu tuhbi bwiinndxaaba stoꞌ ñiꞌh loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ya loh nin babweꞌhedxiaꞌhla Jesuhs bwiinndxaaba chi stoꞌ bwiinn goopa chi, lwehgu guzoꞌbaloh cañiꞌ ba, ya bwiinn raꞌ badxyigaaꞌ duxa loh raꞌ ba rahbi raꞌ ba: ―¡Nagahdxi chyu gwaꞌha loh guihdxyi Israel dziꞌn rooꞌ raꞌ ziga nin dxyudiaꞌha nuꞌh nnah! ");
INSERT INTO zpvNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per laꞌh raꞌ bwiinn fariseu raꞌ guñiꞌ raꞌ ba rahbi raꞌ ba: ―Yuꞌpi nin naa ballwaaꞌn loh raꞌ bwiinndxaaba badiꞌhi guelrnabwaꞌ laꞌh niꞌca, niꞌchin rahca rabweꞌhe ba bwiinndxaaba stoꞌ raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ya caꞌnzaa Jesuhs ziahan raꞌ guihdxyi raꞌ cun rraandxu raꞌ, caꞌngaluuꞌyi Ñiꞌh dxyiꞌdxyi cuubi xteenn xquelrnabwaꞌ Dxiohs laꞌn guidoꞌ biꞌtuꞌhn raꞌ cada tuhbigah lahta, nee cun neezaa caꞌngasiaca Ñiꞌh laꞌh raꞌ bwiinn cun garaaloh gueldxyihdxyi nin rahca raꞌ ba, cun guelnayaan nin nuu tihxi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ya chin bwaꞌha Jesuhs loh raꞌ bwiinn, balahsa duxa stoꞌ Ñiꞌh laꞌh raꞌ ba, pur nin ayi gaann raꞌ ba xi guunn raꞌ ba nee bibiin lastoꞌ raꞌ ba, laasii naa raꞌ ba ziga lliꞌhyi raꞌ nin ayi ballwaaꞌn raꞌ ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ya chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Guchii paꞌhcaan nuu ziahan duxa raꞌ bwiinn guidxyiyuh nin ayi nuꞌnbwaꞌ xchiꞌdxyiꞌhn, nee gulliaaꞌyiꞌhn naa raꞌ bwiinn nin guluuꞌyin laꞌh raꞌ ba, nee naa raꞌ ba ziga tuhbi liꞌhn ziahan per sola paaldaa dxiiꞌ mooza, ayi ziahan raꞌ ba; ");
INSERT INTO zpvNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","niꞌchin nin nahpa gulguinaaba loh Daada nin rnabwaꞌ liꞌhn chi tin guixeꞌhla ba mooza raꞌ tin guziaꞌtii raꞌ ba liꞌhn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ya chiꞌchi gudihdxyi Jesuhs laꞌh gadziꞌh bichiohpa bwiinn nin guhca xpooxtla Ñiꞌh tin badiꞌhi Ñiꞌh guelrnabwaꞌ laꞌh raꞌ ba tin gabweꞌhe raꞌ ba bwiinndxaaba stoꞌ raꞌ bwiinn, nee tin gusiaca za raꞌ ba laꞌh raꞌ bwiinn cun cuun chiꞌh zi gueldxyihdxyi cun guelnayaan nin rahca tihxi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Deeꞌ raꞌ naa laꞌh raꞌ gadziꞌh bichiohpa bwiinn raꞌ nin guhca xpooxtla Jesuhs: mwer tuhbi ba naa Simohn nin guleꞌhelah za raꞌ ba Pehdru, cun bwihtsi ba nin laa Andrehs; cun Jacobo neezaa bwihtsi ba nin laa Jwahn, lliiꞌngaꞌn Zebedeu laꞌh raꞌ ba; ");
INSERT INTO zpvNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","cun neezaa Felipe, Bartolomeh, Tomahs, cun Mateu nin basadxihlli xcweenta impwestu para Roma; cun Jacobo lliiꞌn Alfeu, cun Lebeu nin rñiꞌ raꞌ ba Tadeu; ");
INSERT INTO zpvNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","cun neezaa Simohn nin guyuuꞌ lahda raꞌ Cananista, cun Judas Iscariote nin biuꞌntriehgu laꞌh Jesuhs loh raꞌ bwiinn nin gunaaba guhchi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ya chiꞌchi guluꞌnehza Jesuhs laꞌh gadziꞌh bichiohpa xpwiinn Ñiꞌh tin gwagaluuꞌyi raꞌ ba dxyiꞌdxyi cuubi zaꞌca xteenn xquelrnabwaꞌ Dxiohs ya rahbi Ñiꞌh loh raꞌ ba: ―Ayi chee tu loh guihdxyi raꞌ nin rii raꞌ bwiinn ziitu nin ayi naa raꞌ bwiinn Israel, nee ayi za chee tu loh guihdxyi raꞌ nin rnabwaꞌ Samaria. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mas chaꞌyi gulcheh loh guihdxyi raꞌ hasta rii raꞌ bwiinn Israel nin naa raꞌ ziga lliꞌhyi raꞌ nin rii zaꞌbi, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","tin gulgahbi loh raꞌ ba laꞌh hohra bigaꞌha guinabwaꞌ Dxiohs laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nee gulgasiaca gahca laꞌh raꞌ bwiinn dxyihdxyi, neezaa gulgacwaꞌn laꞌh raꞌ bwiinn loh guelguhchi, cun gulgasiaca za tihxi raꞌ bwiinn nin rahchyi guiiꞌdxyu tin dxiaca raꞌ ba, cun neezaa gulgabweꞌhe bwiinndxaaba stoꞌ raꞌ bwiinn. Ziga zi bagaaꞌdahn guelrnabwaꞌ riiꞌ laꞌh tu ziꞌchi za gulgagaaꞌda xtsiꞌn tu laꞌh raꞌ bwiinn nin rii guihdxyi raꞌ hasta gadzihn tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","nee ayi za chenee tu ohro nin plahta nin cohbre laꞌn dxihdxyi mweeyi tu; ");
INSERT INTO zpvNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nin buxa ayi za chenee tu para loh neziuh. Ayi za chenee tu chiohpa nehza xahba tu, sino que nin nahcu si tu chenee tu; nin tahba tu nin buxtohn, laasii bwiinn nin ruhnn dziꞌn rgaꞌha rcaꞌha ba nin gahw ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ya chin gadzihn tu tuhbi guihdxyi o tuhbi rraandxu, riꞌchi gulchiꞌhyi tuhbi bwiinn nin nazaꞌca naa xmohda ñiꞌh ya guldxiaꞌhan yihdzi ba hasta dxyihyi nin gariaꞌh tu riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ya chin chuꞌtii tu rwaaꞌ yuuꞌ chi, gulgagaꞌpaDxiohs laꞌh raꞌ bwiinn nin nuu yuuꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ya sidela laꞌh raꞌ bwiinn nin nuu yuuꞌ chi naa raꞌ bwiinn nin nuꞌnbwaꞌ Dxiohs zicaꞌha raꞌ ba guelrbwihdxyii stoꞌ. Per sidela laꞌh raꞌ ba ayi naa raꞌ ba bwiinn zaꞌca nahpa zabiaꞌgarii guelrbwihdxyiistoꞌ chi loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ya sidela laꞌh raꞌ ba ayi gusaaꞌn raꞌ ba chuu tu rwaaꞌ yihdzi raꞌ ba o ayi guzoꞌbadxiahga raꞌ ba xchiꞌdxyiꞌhn nin guluuꞌyi tu loh raꞌ ba; gulgariaꞌh rwaaꞌ yihdzi raꞌ ba o rwaaꞌ guihdxyi chi ya riꞌchi gultsihbi ñaaꞌ tu ziga tuhbi sehn nanchii guyuuꞌ xtuhlda raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Guchiin nin rñiꞌn loh tu dxyih nin gaca jwisi loh guihdxyiyuh zirooꞌ ru guelrzaꞌcazii dxiaaba loh guihdxyi raꞌ chi que ziga guhca loh guihdxyi xteenn raꞌ bwiinn Sodoma cun loh guihdxyi xteenn raꞌ bwiinn Gomorra. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Rahbi za Ñiꞌh: ―¡Gulguiaꞌhaloh! Naꞌh guixeꞌhlaꞌhn laꞌh tu ziga zi lliꞌhyi raꞌ loh raꞌ bwiinn raꞌ nin naa raꞌ ziga zi bweew; pwihsi gulgahca nasiin ziga zi bweꞌlda per nee gulgahca za nadoꞌlaaꞌdzi ziga palohmwiꞌhn raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","nee gulgahca nasiin pur xcweenta bwiinn raꞌ laasii ziuꞌn raꞌ ba ntriehgu laꞌh tu loh raꞌ guxchisi raꞌ, ya zidxiꞌldxinee za raꞌ ba laꞌh tu laꞌn guidoꞌ biꞌtuꞌhn raꞌ hasta gadiaaꞌha tu chin cwidxyi tu Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","nee hasta zianee raꞌ ba laꞌh tu nez loh raꞌ guxchisi, cun nezloh xpwiinn gubierna raꞌ, pur xcweenta nin riachiistoꞌ tu xchiꞌdxyiꞌhn; ya pur niꞌchin zahca guiñiꞌ tu xchiꞌdxyiꞌhn loh raꞌ ba cun loh za raꞌ bwiinn ziitu nin ayi naa raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","per chin chenee raꞌ ba laꞌh tu loh raꞌ guxchisi ayi guunn tu ziahan lligaaba xa guiñiꞌ tu, o xi gahbi tu loh raꞌ ba laasii chin zoꞌbaloh guiñiꞌ tu Dxiohs gahca guniꞌhi dxyiꞌdxyi raꞌ nin guiñiꞌ tu loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","laasii ayi guunn tu lligaaba laꞌh tu naa tu nin guiñiꞌ, sino que Spíritu Santu xteenn Xtaada tu nin nuu dxibaaꞌ naa nin guiñiꞌ pur xcweenta tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Bwiinn raꞌ nin nuu raꞌ bwihtsi raꞌ ñiꞌh ziuꞌn raꞌ ba ntriehgu bwihtsi raꞌ ba tin gachi raꞌ bi, ya ziꞌchi za guunn raꞌ paah raꞌ cun lliiꞌn raꞌba ya lliiꞌn raꞌ ba ziahsa raꞌ bi tin ziuꞌn raꞌ bi ntriehgu laꞌh raꞌ xcuzahn raꞌ bi tin gachi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","’Ya garaatiiꞌ raꞌ bwiinn guidxyiyuh guidxyiꞌchinee laꞌh tu pur nin riachiistoꞌ tu xchiꞌdxyiꞌhn. Per bwiinn nin chezahnee dziꞌtsi xchiꞌdxyiꞌhn hasta laꞌn dxyih nin guibiaꞌgariin loh guidxyiyuh stuhbi, bwiinn chi gaca xpwiiꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chin guicaꞌhnnaꞌhla raꞌ ba laꞌh tu tuhbi guihdxyi, gulgalluꞌn tin gulchee para stuhbi guihdxyi; pwihsi rñiꞌn loh tu pweda nin nagahdxi garah loh guihdxyi raꞌ xteenn Israel guicaꞌnzaa tu chin laꞌh dxyih ba bazaaꞌ dxiꞌ Lliiꞌn Dxiohs nin naa ndxiꞌhw stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nin tuhbi bwiinn nin rusiꞌdxi ayi lasahca ru ba loh xmwehsu ba, ya ziꞌchi gahca za tuhbi mooza ayi xi guilasahca ba loh daada nin naa xballwaaꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Niꞌchin cun dxiaꞌhan bwiinn nin rusiꞌdxi, gaca ba ziga naa xmwehsu ba, ya mooza gaca ba ziga naa xballwaaꞌn ba, ya sidela guiñiꞌ raꞌ bwiinn laꞌh nin naa ballwaaꞌn xteenn tuhbi yuuꞌ Belzebuu, lliaaꞌ lla bwiinn raꞌ nin nuu rwaaꞌ yihdzi ba, ¿cuunlla nin guiñiꞌ raꞌ ba loh raꞌ bwiinn chi? ");
INSERT INTO zpvNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rahbi za Jesuhs: ―Pwihsi rñiꞌn loh tu ayi guidxyihbi tu laꞌh raꞌ ba laasii ayi nuu xi tiidxi ralaꞌn, nahpa zadxeelan; nee ziꞌchi za xilla nin chuulaꞌn nahpa zariaꞌcaaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dxyiꞌdxyi raꞌ nin rñiꞌn loh tu loh dxyigahsi, gulguiñiꞌn loh raꞌ bwiinn loh biaꞌñih xteenn gubihdxyi radxyii; ya dxyiꞌdxyi raꞌ nin rñiꞌn loh tu dxyigahsi chi, dxyigah gulcwidxyidxiah chin guiñiꞌ tun desde yihca yuuꞌ loh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayi guidxyihbi tu laꞌh raꞌ bwiinn nin chiinn laꞌh bweꞌltihxi tu, laasii laꞌh xaalma tu ayi gaca chiinn raꞌ ban, niꞌchin mas chaꞌyi gulguidxyihbi laꞌh Dxiohs laasii laꞌh Ñiꞌh zahca chiinntiiꞌ Ñiꞌh laꞌh tu nee cun zahca za cuꞌnehza Ñiꞌh laꞌh tu gabihldxyi par tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ya laꞌh tu naann la rdooꞌ chiohpa maaniꞌhn pur tuhbi gaꞌyu, per nin tuhbi raꞌ maaniꞌhn chi ayi riaaba loh yuh sidela laꞌh xtaada tu ayi gusaaꞌn Ñiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ziꞌchi gahca za laꞌh tu, hasta dxyichyihca tu laꞌn nagaabala, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","niꞌchin nin ayi guidxyihbi tu, laasii laꞌh tu zirooꞌ ru lasahca tu loh ziahan raꞌ maaniꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Rahbi za Ñiꞌh: ―Ya cuun chiꞌh zi raꞌ bwiinn nin guzeꞌta xcweeꞌntahn loh raꞌ bwiinn, ziꞌchi za naꞌh ziñiꞌn xcweenta bwiinn chi loh Xtaaꞌdahn nin nuu dxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","per bwiinn raꞌ nin guiñiꞌ ayi naa raꞌ ba xpwiiꞌnn raꞌn, ziꞌchi za naꞌh ziñiꞌn loh Xtaaꞌdahn nin nuu dxibaaꞌ ayi naa raꞌ ba xpwiiꞌnnraꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Rahbi za Ñiꞌh: ―Ayi guunn tu lligaaba guelrbahchidxyiistoꞌ zeꞌldaneꞌhn loh guidxyiyuh riiꞌ, sino que pur naꞌh zilaaꞌha lasaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naꞌh zeꞌldahn tin pur naꞌh zidxyiꞌchinee tuhbi ndxiꞌhw laꞌh xtaada ba, ya dxaꞌpa zidxyiꞌchinee za bi laꞌh xmaah bi, ya guyihdzi zidxyiꞌchinee za bi laꞌh xnanswehgra bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Niꞌchin lasaaꞌ gahca raꞌ tuhbi bwiinn ziga nuu raꞌ ba rwaaꞌ tuhbi yuuꞌ zidxyiꞌchinee lasaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Bwiinn nin rucaꞌh ru stoꞌ ñiꞌh laꞌh xtaada ñiꞌh cun xmaah ñiꞌh, mahziru que ziga naꞌh, bwiinn raꞌ chi ayi galluꞌyi gaca xpwiiꞌnahn; ziꞌchi gahca za bwiinn nin nadziiꞌhi ru lliiꞌngaꞌn raꞌ ñiꞌh o lliiꞌndxaꞌpa raꞌ ñiꞌh que ziga naꞌh bwiinn raꞌ ziꞌchi ayi galluꞌyi gaca raꞌ xpwiiꞌnnahn, ");
INSERT INTO zpvNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ya bwiinn raꞌ nin ayi guꞌa xcruhzi ñiꞌh tin dxieꞌnaꞌhla ba naꞌh bwiinn chi ayi naa ba tuhbi xpwiiꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ya bwiinn nin rdxiꞌhyi si xa taꞌh xquelnabahan ba zuñihchi ban, per bwiinn nin guñihchi xquelnabahan ñiꞌh pur naꞌh zadxeela ban. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Rahbi za Ñiꞌh: ―Bwiinn raꞌ nin guniꞌhi rwaaꞌ yihdzi ñiꞌh dxiaꞌhan tu cun gaduhbi stoꞌ raꞌ ba pwihsi zuniꞌhi za raꞌ ba rwaaꞌ yihdzi ba dxiaꞌhanahn cun gaduhbi stoꞌ raꞌ za ba; ziꞌchi gahca za sidela guunn raꞌ ba ziꞌchi naꞌh cun gaduhbi stoꞌ raꞌ ba zuhnn za raꞌ ba ziꞌchi cun laꞌh Xtaaꞌdahn nin nuu dxibaaꞌ nin guluꞌnehza naꞌh loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bwiinn nin guniꞌhi yihdzi ñiꞌh dxiaꞌhan tuhbi bwiinn nin rñiꞌ xchiꞌdxyi Dxiohs laasii zeꞌ ba pur xcweenta Dxiohs, zicaꞌha za ba laꞌh gahca ziga tuhbi guelnazaꞌca nin rcaꞌha bwiinn nin rñiꞌ xchiꞌdxyi Dxiohs. Ziꞌchi gahca za laꞌh bwiinn nin guniꞌhi yihdzi ñiꞌh dxiaꞌhan tuhbi ndxiꞌhw nin naa zaꞌca xmohda ñiꞌh laasii naa ba bwiinn zaꞌca, zicaꞌha za ba laꞌgahca ziga guelnazaꞌca nin guicaꞌha ndxiꞌhw nin naa zaꞌca xmohda ñiꞌh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya cuun chiꞌh zi za bwiinn nin gudiꞌhi nicala tuhbi llihga ñihsa nagaꞌldiuh laꞌh raꞌ bwiinn gulliaaꞌyiꞌhn raꞌ riiꞌ nin naa raꞌ xpwiꞌnnahn, guchiin nin rñiꞌn zicaꞌha raꞌ ba tuhbi cohsa zaꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ya chin guyaꞌloh bwiiꞌyidxyiꞌdxyi Jesuhs loh raꞌ xpwiinn Ñiꞌh xa guunn raꞌ ba xtsiꞌn Ñiꞌh, chiꞌchi gunaꞌzu nehza Ñiꞌh loh guidxyi raꞌ nin rnabwaꞌ guihdxyi chi tin zee galuuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ya gaduhbi nin nuu Jwahn nin ruroꞌbañihsa laꞌn lahtsi dxiꞌba, bihn ba xcweenta dziꞌn raꞌ nin cayuhnn Jesuhs, niꞌchin nin guxeꞌhla Jwahn paaldaa raꞌ xpwiinn ba ");
INSERT INTO zpvNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tin gwaganaabadxyiꞌdxyi raꞌ ba loh Jesuhs sidela laꞌhpaꞌh Ñiꞌh naa Ñiꞌh Crixtu o ñibweza ru ba dxiꞌ stuhbi bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guldxiaa tin gulgahbi loh Jwahn garaa raꞌ nin caywaꞌha tu cun nin cayihn tu; ");
INSERT INTO zpvNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","gulgahbi laꞌh raꞌ bwiinn nin rahcaloh ñiꞌh, laꞌhloh raꞌ ba biaca, bwiinn raꞌ nin ayi nuu sah laꞌh raꞌ ba rzah, bwiinn raꞌ nin rahchyi guiiꞌdxyu tihxi ñiꞌh laꞌh guiiꞌdxyu chi guñihchiloh tihxi raꞌ ba, bwiinn raꞌ nin rahca dxiahga ñiꞌh laꞌh dxiahga raꞌ ba ballaala, bwiinn raꞌ nin guhchi laꞌh raꞌ ba babahn loh guelguhchi, ya bwiinn prohbi raꞌ nin cabweeza gacanee Dxiohs laꞌh raꞌ ba, laꞌh raꞌ ba cagazoꞌbadxiahga xchiꞌdxyi Dxiohs nin gutaꞌh laꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Dichohsa naa raꞌ bwiinn nin ayi gusaaꞌn xcweenta ziga riachiistoꞌ raꞌ ba naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ya chin babii raꞌ xpwiinn Jwahn loh Jesuhs chiꞌchi guzoꞌbaloh guñiꞌ Ñiꞌh xcweenta Jwahn loh raꞌ bwiinn, rahbi Ñiꞌh: ―¿Chyu niꞌca gwaguiaꞌha tu loh dahan? ¿Ta tuhbi ñihta nin biehla gudzihbi bwih? ");
INSERT INTO zpvNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ya sidela ayi niꞌchi dxiꞌh, ¿xiilla gwaguiaꞌha si chiꞌh tu? ¿Ta gwaguiaꞌha tu tuhbi ndxiꞌhw nin nahcu lahdxi zaꞌca? Laꞌh tu naann tu sola yihdzi tuhbi bwiinn nin rnabwaꞌ duxa nuu bwiinn raꞌ nin nahcu lahdxi zaꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ya nnaha xchiꞌh, ¿xi pur biriaꞌh chiꞌh tu? ¿Ta tin gwaguiaꞌha tu tuhbi bwiinn nin rñiꞌ xchiꞌdxyi Dxiohs? Ziꞌchi pwihsi, tuhbi bwiinn nin naa bwiinn nin mahziru lasahca que ziga daada raꞌ nin guñiꞌ xchiꞌchi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Xcweenta Jwahn niꞌchi ruzeꞌta loh Xchihtsi Dxiohs hasta rahbi squiiꞌ: Zixeꞌhlaꞌhn tuhbi xpwiiꞌnnahn galohtiiꞌ tin laꞌh ba guzuhnayaa neziuh nin guzee luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Guchiin nin rñiꞌn loh tu, garaa raꞌ ziga bwiinn raꞌ nin raalaa raꞌ loh guidxyiyuh riiꞌ pur gunnaꞌh, nagahdxi dxiinloh nin tuhbi bwiinn nin nagahdxi gaca lasahcatiiꞌ ziga Jwahn nin ruroꞌbañihsa, per nin naa biꞌtuꞌhntiiꞌ loh xquelrnabwaꞌ Dxiohs niꞌchi mahzi lasahca loh Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Dez laꞌn dxyih raꞌ nin guzoꞌbaloh ruluuꞌyi Jwahn, cun para hasta nnahyi nuu ziahan duxa raꞌ bwiinn nin xclaaꞌdzi chuu raꞌ loh xquelrnabwaꞌ Dxiohs lajweersi, ya snuhn raꞌ ba lajweersi xclaaꞌdzi raꞌ ba cweꞌhelluꞌhu raꞌ ba loh guelrnabwaꞌ xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Garaa raꞌ bwiinn raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cun ziga naa xlehyi Moisehs guñiꞌxgah raꞌ ba xcweenta ziga cohsa raꞌ nin gaca, cun para laꞌn dxyihyi nin biꞌ Jwahn, ");
INSERT INTO zpvNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ya sidela xclaaꞌdzi tu chechiistoꞌ tu dxyiꞌdxyi riiꞌ, laꞌgahca Jwahn naa Elías ndxiꞌhw xteenn Dxiohs nin nahpa dxiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bwiinn raꞌ nin zohballaala dxiahga raꞌ ñiꞌh, gulchuuꞌ gulchaꞌzi dxyiꞌdxyi riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Cuun nin xñah ziga xñah raꞌ bwiinn nin rii nabahan laꞌn dxyih raꞌ riiꞌ? Rluuꞌyi raꞌ ba ziga zi xñah raꞌ nuhn biñiꞌn nin riidzihta loh dxiaaꞌ hasta rdooꞌ xica, ya cañiꞌ raꞌ bi loh raꞌ lasaaꞌ raꞌ bi jweersi roo: ");
INSERT INTO zpvNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bachidxiꞌlda nu bichiiwuu tin ñudxiaꞌha tu per ayi badxiaꞌha tu; bachidxiꞌlda nalaasa za nu tin ñuꞌn tu, per ayi za biꞌn tu.” ");
INSERT INTO zpvNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Laasii biꞌ Jwahn nin ayi gudahw ba ziahan nin ayi za gwaaꞌ ba vihnnu, nee rahbi tu nuu tuhbi bwiinndxaaba stoꞌ Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ya lwehgu gahca badzihn Lliiꞌn Dxiohs nin naa ndxiꞌhw, rahw ba nee reeꞌ za ba vihnnu, ya rahbi tu naa ba tuhbi nin rahw chiꞌh zi cun reeꞌ chiꞌh zi, cun naa za ba nin rdxaꞌga loh raꞌ bwiinn nin rsadxihlli impwestu cun bwiinn nin ayi ruzoꞌbadxiahga lehyi, per xquelnasiin Dxiohs naa rariaꞌcaa ruluuꞌyi xcweenta bwiinn raꞌ nin ruzoꞌbadxiahga xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ya chiꞌchi guzoꞌbaloh Jesuhs gudxihndxinee dxyiꞌdxyi Ñiꞌh laꞌh raꞌ bwiinn guihdxyi raꞌ nin bwaꞌha dziꞌn rooꞌ raꞌ nin bwiꞌhnn Ñiꞌh, laasii laꞌh raꞌ bwiinn guihdxyi raꞌ chi ayi rusaguuꞌdzi stoꞌ raꞌ ba nez loh Dxiohs, ya chiꞌchi rahbi Jesuhs: ");
INSERT INTO zpvNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Prohbi za laꞌh tu bwiinn guihdxyi Corazihn, cun neezaa laꞌh za tu bwiinn guihdxyi Betsaida prohbi za laꞌh tu!, laasii sidela laꞌh raꞌ bwiinn guihdxyi Tiru cun bwiinn guihdxyi Sidohn ñwaꞌha raꞌ ba dziꞌn rooꞌ raꞌ nin bwiꞌhnnaꞌhn nez loh tu, nahpa ñazah raꞌ ba xneziuh Dxiohs nee ñahcu raꞌ za ba lahdxi lluhn cun ñuroꞌba raꞌ ba cobadeh yihca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Niꞌchin chin guunn Dxiohs jwisi loh guidxyiyuh riiꞌ mahzi ru gusaꞌcazii Ñiꞌh laꞌh tu loh raꞌ bwiinn Tiru cun bwiinn Sidohn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya laꞌh tu bwiinn guihdxyi Capernaum, ¿ta ruhnn chiꞌh tu lligaaba par dxibaaꞌ gacah tu? ¡Sidela nnah mas laꞌn gueeta gabihldxyi dxiehta tu!, laasii sidela loh guihdxyi Sodoma ñuꞌnnahn dziꞌn rooꞌ raꞌ nin bwiꞌhnnaꞌhn loh tu, guihdxyi chi nahpa ñazah zaꞌca hasta laꞌn dxyih raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Niꞌchin nnah rñiꞌn loh tu laꞌn dxyih nin gaca jwisi loh guidxyiyuh, zirooꞌ ru guelrzaꞌcazii guniꞌhi Dxiohs laꞌh tu que ziga guzaꞌca raꞌ bwiinn guihdxyi Sodoma. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ya laꞌn dxyih raꞌ chi rahbi Jesuhs: ―Zuxchiilli luꞌh Xtaaꞌdahn nin rnabwaꞌ dxibaaꞌ cun loh guidxyiyuh, laasii cagaluuꞌyi luꞌh laꞌh raꞌ bwiinn nadoꞌlaadzi nin naa ziga bweezu raꞌ cohsa raꞌ nin guluuꞌlaꞌn luꞌh loh raꞌ bwiinn naann raꞌ, cun loh nin rahcabwaꞌ, ya baluuꞌyi luꞌhn nez loh raꞌ bwiinn raꞌ nin ayi xi dxiuu. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ziꞌchi, Paah, laasii ziꞌchi ruhnn luꞌh lligaaba naa bwen gaca. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Laasii laꞌh Xtaaꞌdahn biuꞌn ntriehgu garaatiiꞌ loon, ya ayi chyu nuꞌnbwaꞌ laꞌh Lliiꞌn Ñiꞌh; sola laꞌh Daada Dxiohs nuꞌnbwaꞌ Ñiꞌh laꞌh Lliiꞌn Ñiꞌh. Ya ayi za chyu nuꞌnbwaꞌ laꞌh Daada Dxiohs, sola Lliiꞌn Ñiꞌh nuꞌnbwaꞌ laꞌh Ñiꞌh, cun neezaa bwiinn raꞌ nin gudihdxyi Lliiꞌn Ñiꞌh dxiuꞌnbwaꞌ laꞌh Xtaada Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Gultaaꞌ nez loon garaa tu nin babadxahga cun nin cagasiꞌnaaꞌha raꞌ duhlda, laasii naꞌh guniꞌhihn guelrziꞌlaaꞌdzi laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","per gulgasiꞌdxi guunn tu dziꞌn nin guluꞌyiꞌhn laꞌh tu, nee gulgasiꞌdxigahca xcweeꞌntahn laasii naan bwiinn naguuꞌdzi stoꞌ cun nahpa zahn paseensi laꞌh tu, ya sidela guunn tu squiiꞌ zidxeela tu hasta gapa xaalma tu guelruziꞌlaaꞌdzi, ");
INSERT INTO zpvNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","laasii dziꞌn nin guluꞌyiꞌhn laꞌh tu cun garaa nin gusagwaꞌhn laꞌh tu, ayi xi guinaaꞌha raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ya dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, zeezah Jesuhs loh yuh raꞌ hasta naꞌ trihgu, pwihsi laꞌn dxyih chi bichiaꞌhn raꞌ xpwiinn Ñiꞌh, ya chiꞌchi guzoꞌbaloh bachywaꞌh raꞌ ba trihgu tin gulloꞌba raꞌ ba bwiiꞌdziꞌhn raꞌ chi gudahw raꞌ ban, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ya chin bwaꞌha raꞌ nuhn bwiinn guidoꞌ nin laa fariseu niꞌchi chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Bwaꞌha cayuhnn raꞌ xpwiinn luꞌh ziga nin ayi rusaaꞌn lehyi gaca dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta nagahdxi guꞌlda tu loh Xchihtsi Dxiohs hasta rñiꞌ cuun nin bwiꞌhnn guehtu Davihd tuhbi dxyih nin bichiaꞌhn ba cun garaa raꞌ xpwiinn ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pwihsi guyuuꞌtii ba laꞌn xquidoꞌ Dxiohs tin gudahw ba pahn nin ayi nuu gahw raꞌ bwiinn ziga xpwiinn ba o ziga laꞌh za ba, laasii laꞌh dxiꞌh raꞌ bixohza rahca rahw pahn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O ¿nagahdxi guꞌlda tu loh xchihtsi lehyi Moisehs xa ruhnn raꞌ bixohza laꞌn guidoꞌ dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, ruhnn raꞌ ba xtsiꞌn raꞌ ba, per ayi xi xtuhlda raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pwihsi rñiꞌn loh tu riiꞌ, zuu tuhbi nin lasahca ru loh ziga lasahca guidoꞌ rooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pwihsi laꞌh tu ayi guhcabwaꞌ tu xi zee loh Xchiꞌdxyi Dxiohs riiꞌ: “Pwihsi nin xclaaꞌdzihn guunn tu galahsastoꞌ tu laꞌh raꞌ bwiinn lasaaꞌ tu xlawaaꞌha guniꞌhi tu guhn naꞌh.” Sidela ñahcabwaꞌ tun ayi ñudziiꞌba tu duhlda yihca bwiinn nin ayi xi xtuhlda ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","laasii laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw naa Daada loh dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ya chin babii Jesuhs riꞌchi, chiꞌchi guyuuꞌtii Ñiꞌh laꞌn tuhbi xquidoꞌ biꞌtuꞌhn raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ya laꞌn guidoꞌ chi zohba tuhbi ndxiꞌhw nin gubihdzi naa ñiꞌh, ya laasii riidxiꞌhyi bwiinn Israel raꞌ chi xa gucaꞌchiah dxixiꞌhw raꞌ ba laꞌh Ñiꞌh, niꞌchin nin rahbi raꞌ ba loh Ñiꞌh: ―¿Ta rusaaꞌn lehyi gusiaca luꞌh tuhbi bwiinn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Chyu tuhbi ndxiꞌhw nin dxaꞌga loh tu nahpa tuhbi lliꞌhyi ya sidela laꞌh ma dxiaaba ma laꞌn tuhbi bizee dxyih nin ruziꞌlaaꞌdzi tu, ¿tayi chiꞌh gabweꞌhe tu ma laꞌn bizee dxyih chi gahca nicala naa dxyih nin ruziꞌlaaꞌdzi tu? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pwihsi ziahan duxa ru lasahca tuhbi bwiinn loh tuhbi lliꞌhyi, pwihsi niꞌchin nin zusaaꞌn lehyi chyu guunn tuhbi bwen laꞌh stuhbi bwiinn dxyih nin rziꞌlaaꞌdzi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ya chiꞌchi rahbi Ñiꞌh loh ndxiꞌhw nin gubihdzi naa ñiꞌh chi: ―Batsiꞌyi naa luꞌh. Ya batsiꞌyi naa ba ya lwehgu gahca biacan, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","per chin bariaꞌh raꞌ bwiinn fariseu raꞌ riꞌchi guzoꞌbaloh canaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba xa guunn raꞌ ba tin chiinn raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ya chin guhcabwaꞌ Jesuhs cuun lligaaba nin riiyuhnn raꞌ bwiinn fariseu raꞌ chi, lwehgu bariaꞌh Ñiꞌh riꞌchi, ya gwanaꞌhla ziahan duxa raꞌ bwiinn laꞌh Ñiꞌh, ya basiaca za Ñiꞌh garaa gueldxyihdxyi nin rahca raꞌ bwiinn raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ya gunabwaꞌ Ñiꞌh ayi guzeꞌta raꞌ ba chyu naa Ñiꞌh ");
INSERT INTO zpvNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tin guzohba dxyiꞌdxyi nin guñiꞌ guehtu profeta Isaías chin rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Riiꞌ laꞌh bwiinn nin guliin zuu, nin riahxineꞌhn cun nin nuguꞌnasaa stoꞌn; ya zudiꞌhihn Spírituhn laꞌh ba nee zuluuꞌyi ba xcweenta xquelguxchisi Dxiohs loh raꞌ bwiinn nin ayi naa raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ayi dxiaala rwaaꞌ ba guiñiꞌ ba, ayi za cwidxyidxiah ba, ayi za chuu nin dxiindxiahga rsiaaꞌha ba loh neziuh raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ayi za chiꞌchi ba ñihta nin guhchii la, nin ayi za gusiuꞌyi ba mwehchi nin gueꞌdu rbweꞌhe guhxa, hastayi dxyih nin gwaꞌha ba gaca guelguxchisi loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Laꞌh si ba chechiistoꞌ raꞌ bwiinn nin ayi naa bwiinn Israel tin gutaꞌh ba laꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ya gwanee raꞌ bwiinn tuhbi lasaaꞌ raꞌ ba nin guyuuꞌ tuhbi bwiinndxaaba stoꞌ ñiꞌh loh Jesuhs, bwiinn chi ayi riin loh ba cun biaꞌhan goopa za ba, ya bwiꞌhnn Jesuhs gahn gubiaꞌgarii bwaꞌha ba cun bañiꞌ za ba ya ziꞌchi zi biaca ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ya garaa raꞌ bwiinn nin rii riꞌchi guzoꞌbaloh canaabadxyiꞌdxyi loh lasaaꞌ gahca raꞌ ba rahbi raꞌ ba: ―¿Tayiga llahga dxiꞌh guehtu Davihd deeꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ya chin bihn raꞌ bwiinn fariseu dxyiꞌdxyi raꞌ riiꞌ, rahbi raꞌ ba: ―Ndxiꞌhw riiꞌ rabweꞌhe bwiinndxaaba stoꞌ raꞌ bwiinn laasii Belzebuu nin rnabwaꞌ laꞌh raꞌ bwiinndxaaba cayahcanee laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ya chin guhcabwaꞌ Jesuhs xa naa lligaaba nin riiyuhnn raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Garaa raꞌ bwiinn nin nuu loh tuhbi guelrnabwaꞌ nin rbahchi xchih tuhbi cwaꞌh bwiinn tin chindxinee lasaaꞌ raꞌ ba pwihsi nahpa ñichiloh guelrnabwaꞌ chi; ya tuhbi guihdxyi hasta rii raꞌ tuhbi jwamihyi bwiinn sidela rlaaꞌha lasaaꞌ raꞌ ba ziahan cwaꞌh tin chindxinee lasaaꞌ raꞌ ba nahpa ziñihchiloh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ya ziꞌchi gahca za sidela laꞌh bwiinndxaaba rabweꞌhe gahca ba laꞌh nin naa za bwiinndxaaba stoꞌ raꞌ bwiinn pwihsi zilaaꞌha lasaaꞌ raꞌ ba, ya pwihsi ¿xaalla cheezah chuu xquelrnabwaꞌ raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ya laꞌh tu rahbi tu rabweꞌhehn bwiinndxaaba stoꞌ raꞌ bwiinn cun xquelrnabwaꞌ bwiinndxaaba, per sidela ziꞌchi ñahca, ¿cuun xchiꞌh nin rudiꞌhi guelrnabwaꞌ laꞌh raꞌ xpwiinn tu tin rabweꞌhe raꞌ ba bwiinndxaaba? Niꞌchin laꞌh gahca raꞌ ba zuluuꞌyi raꞌ ba billiꞌn loh xigaaba tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ya sidela naꞌh rabweꞌhehn bwiinndxaaba stoꞌ raꞌ bwiinn cun xquelrnabwaꞌ Spíritu Saantu xteenn Dxiohs, niꞌchi ruluuꞌyi laꞌh xquelrnabwaꞌ Dxiohs badzihn loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Xa guunn tuhbi bwiinn nin ruhnn gubaꞌn chuꞌtii yihdzi tuhbi ndxiꞌhw nin nahpa tuhbi bwiinn nin rulaloh yihdzi ba tin para ayi cweꞌhelluꞌhu ba nin nahpa ndxiꞌhw chi? Sola nin guunn gubaꞌn chi galoh guchiꞌbiduꞌh ba laꞌh bwiinn chi, ziꞌchi sihn zuhnn ba gahn cweꞌhelluꞌhu ba nin nahpa bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Bwiinn raꞌ nin ayi xclaaꞌdzi naꞌh rdxyiꞌchinee ba naꞌh, ya bwiinn raꞌ nin ayi rahcanee naꞌh guidiaaꞌha raꞌ bwiinn laꞌlaꞌgaꞌh cabweꞌhecaa raꞌ ba bwiinn loon. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Pwihsi niꞌchin nin rñiꞌn loh tu gusiaꞌpitii Dxiohs xtuhlda raꞌ bwiinn cun garaa dxyiꞌdxyi dxaaba nin guiñiꞌ raꞌ ba loh Ñiꞌh, per sidela laꞌhraꞌ ba guiñiꞌyah raꞌ ba laꞌh Spíritu Saantu Dxiohs, ayi gusiaꞌpitii Ñiꞌh xtuhlda raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dxiohs gusiaꞌpitii Ñiꞌh xtuhlda chyu chiꞌh zi nin guiñiꞌyah laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw, per bwiinn nin guiñiꞌyah laꞌh Spíritu Saantu ayi dxiaꞌldatiiꞌ stoꞌ Dxiohs xtuhlda bwiinn chi nin loh guidxyiyuh riiꞌ nee nin loh guidxyiyuh nacuubi nin gueꞌdu dxiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Rahbi za Ñiꞌh: ―Gulgahpaabiñih zaꞌca tuhbi yahga ñinahxi, ya ziꞌchi zicah ñinahxi zaꞌca lohon; per sidela laꞌh tu ayi gaapaabiñih zaꞌca tu tuhbi yahga ñinahxi, pwihsi ziꞌchi za ñinahxi dxaaba guicah lohon. Ya ziꞌchi riuꞌnbwaꞌ bwiinn yahga pur nin rcah lohon. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Laꞌh tu bwiinn nin naa raꞌ ziga zi bweꞌlda ñaꞌlaaꞌdzi! ¿Xa xclaaꞌdzi tu guiñiꞌ tu dxyiꞌdxyi zaꞌca sidela laꞌh gahca tu nadxaaba naa tu? Ya stoꞌ tu rdahla dxyiꞌdxyi dxaaba nin rñiꞌ rwaaꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bwiinn zaꞌca rñiꞌ ba dxyiꞌdxyi zaꞌca laasii dxyiꞌdxyi zaꞌca chi nuu stoꞌ ba, ya bwiinn nadxaaba rñiꞌ za ba dxyiꞌdxyi dxaaba laasii dxyiꞌdxyi dxaaba chi nuu stoꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ya naꞌh rñiꞌn loh tu dxyih nin gaca jwisi loh guidxyiyuh garaa raꞌ bwiinn chixteeꞌ raꞌ ba loh Dxiohs gallee dxyiꞌdxyi dxaaba nin guñiꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pwihsi pur dxyiꞌdxyi nin guiriaꞌh rwaaꞌ tu zuhnn guiñiꞌ Dxiohs bwiinn zaꞌca tu, o pur xchiꞌdxyi za tu chi zuhnn guñihchi tu nez loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ya chiꞌchi rahbi nuhn bwiinn fariseu raꞌ nee cun nuhn raꞌ mwehsu nin ruluuꞌyi xlehyi Moisehs loh Jesuhs: ―Mwehsu, xclaaꞌdzi nu guidiaꞌha nu guunn luꞌh tuhbi dziꞌn rooꞌ ziga tuhbi sehn. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh tu ayi nnaa tu guunn tu nin xclaaꞌdzi Dxiohs sino que sola nin xclaaꞌdzi tu, yannah rnaaba tu guꞌnnahn tuhbi dziꞌn rooꞌ tin gwaꞌha tun, per sola sehn xteenn guehtu Jonahs daada nin guñiꞌ xchiꞌdxyi Dxiohs ca chieempa rooꞌ guniꞌhihn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pwihsi ziga guyuuꞌ guehtu Jonahs stoꞌ bwehlda chohnna dxyih nee chohnna gueꞌla, pwihsi ziꞌchi za laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw ziuuꞌ za ba chohnna dxyih cun chohnna za gueꞌla laꞌn loh yuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ya bwiinn chieempa raꞌ xteenn guihdxyi Nínive ziazuꞌnchii raꞌ ba chin gaca jwisi chin guunn Dxiohs guelguxchisi loh raꞌ bwiinn nin rii nabahan nnah tin gucaꞌchiah raꞌ ba laꞌh tu, laasii laꞌh raꞌ bwiinn guihdxyi Nínive chi biuꞌgarii raꞌ ba loh xquelñaꞌñih Dxiohs chin gwagaluuꞌyi guehtu Jonahs xchiꞌdxyi Dxiohs laꞌh raꞌ ba nee naꞌh nin nuuꞌhuhn lahda tu mahzi lasahcahn loh Jonahs per ayi ruzoꞌbadxiahga tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Neezaa tuhbi naaniꞌhn nin guhca rrehyna loh yuh raꞌ nez lahdu laꞌn gueeta chesuꞌnchii ba tin gucaꞌchiah ba laꞌh raꞌ bwiinn nin rii nabahan loh guidxyiyuh nnah laasii laꞌh ba biriaꞌh ba rwaaꞌ guihdxyiyuhyi tin bacaꞌdxiahga ba guelrahcabwaꞌ duxa xteenn guehtu Salomohn, yannah nuuꞌhuhn lahda tu naan nin mahzi lasahca xchiꞌdxyi ñiꞌh loh Salomohn per ayi ruzoꞌbadxiahga tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Rahbi za Ñiꞌh: ―Ya chin rariaꞌh tuhbi bwiinndxaaba stoꞌ tuhbi bwiinn, chiꞌchi rcaꞌnzaa ba loh dahan desierto tin rdxiꞌhyi ba canehza guziꞌlaaꞌdzi ba, per ayi rdxeelan, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ya chiꞌchi ruhnn ba lligaaba: “Mas chaꞌyi gabiaꞌgariin rwaaꞌ yihdzihn hasta biriaꞌhn.” Ya chin radzihn ba riꞌchi, bwaꞌha ba stoꞌ bwiinn nin bariaꞌh ba galoh chuhla biahcan ziga zi tuhbi yuuꞌ nin biyoꞌba laꞌn ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chiꞌchi riah bwiinndxaaba chi tin riagatiaaꞌha ba zagahdzi bwiinndxaaba nin mahzi rusaꞌcazii que ziga ruhnn bwiinn dxaaba chi, ya ziꞌchi tuhsi juunta riuuꞌtii raꞌ garaa raꞌ bwiinndxaaba raꞌ chi stoꞌ bwiinn chi, ya mahzi nalaasa ru guunnee raꞌ ba laꞌh bwiinn chi que ziga galoh, pwihsi ziꞌchi saca raꞌ bwiinn yaꞌdxi, nin rii nabahan loh guidxyiyuh nnah. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Loh zeezah gahca cañiꞌ Jesuhs loh raꞌ bwiinn chin badzihn xmaah Jesuhs cun bwihtsi raꞌ Ñiꞌh nez dihtsi jwehra, ya guclaaꞌdzi raꞌ ba ñiñiꞌ raꞌ ba loh Jesuhs per ayi guhcan cun rii raꞌ chiꞌh ba nez dihtsi jwehra, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ya guyuuꞌ tuhbi bwiinn nin gwaguihtsi loh Jesuhs rahbi ba loh Ñiꞌh: ―Xmaah luꞌh cun bwihtsi raꞌ luꞌh rii raꞌ dihtsi jwehra riꞌchi, ya xclaaꞌdzi raꞌ ba guiñiꞌ raꞌ ba loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ya sola squiiꞌ rahbi Jesuhs loh bwiinn nin gwagañiꞌ loh Ñiꞌh: ―¿Cuun nin naa xmaaꞌhn, nee cuun raꞌ za nin naa raꞌ bwihtsi raꞌn? ");
INSERT INTO zpvNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chin guyaꞌloh guñiꞌ Ñiꞌh squiiꞌ, chiꞌchi baluuꞌyi Ñiꞌh cun naa Ñiꞌh nez hasta rii raꞌ bwiinn nin naa raꞌ xpwiinn Ñiꞌh, ya chiꞌchi rahbi laꞌgaꞌh Ñiꞌh: ―Bwiinn raꞌ riiꞌ naa xmaaꞌn cun bwihtsi raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","laasii garaa raꞌ nin ruhnn ziga xclaaꞌdzi Xtaaꞌdahn nin nuu dxibaaꞌ gaca, bwiinn raꞌ chi naa bwihtsi raꞌn cun bizaaꞌnahn, cun xmaaꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ya dxyih chi gahca biriaꞌh Jesuhs rwaaꞌ yuuꞌ chi tin gwah Ñiꞌh hasta rwaaꞌ laguhn, ya chin badzihn Ñiꞌh riꞌchi guzohba Ñiꞌh rwaaꞌ laguhn chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ya laasii badiaaꞌha ziahan bwiinn riꞌchi, niꞌchin gucah Ñiꞌh laꞌn tuhbi laancha, ya hasta laꞌnyi laancha chi guzohba Ñiꞌh. Ya garaa raꞌ bwiinn rii raꞌ hasta rwaaꞌyi ñihsa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","bwiiꞌyidxyiꞌdxyinee Ñiꞌh ziahan cweenta si laꞌh raꞌ ba, rahbi Ñiꞌh: ―Gulgacaꞌdxiahga; biriaꞌh tuhbi bwiinn zeetachi ba biñih loh dahan, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ya loh zeezah ba loh neziuh biaaba nuhn xooba ba loh nezyuh, ya lwehgu biaaba raꞌ maaniꞌhn loh neziuh chi tin gudahw raꞌ ma llooba chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ya stuhbi lahta biaaba nuhnan lahda dxiah hasta ayi ziahan yuh, ya lwehgu gutahnan laasii ayi guhca biñihin gueeta loh yuh, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","per chin bigaꞌhan gubihdxyi bacaꞌdxih gubihdxyi laꞌhan laasii ayi guyuuꞌ xcohpa loh yuh chi nee zigala ayi gunaꞌzu xtulbaaꞌhan lahda dxiah chi niꞌchin gubihdzin. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ya snuhn llooba chi biaaba lahda yaguihchi raꞌ, ya yaguihchi raꞌ chi ayi basaaꞌnan ñirooꞌ biñih chi sola guhcan dxihlli bachiidxiah, niꞌchin nin ayi xi guyuuꞌ lohon, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","per biñih nin biaaba loh yuh zaꞌca, niꞌchiyi badiꞌhi jusehchi zaꞌca; ya nuu raꞌ ñihza xteenn lloobwiꞌhn nin biaaba loh yuh guhcan ziahan llooba, ya snuhn raꞌn nalayi gucah llooba tihxi ñihza xteenn tuhbigah raꞌ lloobwiꞌhn nin gurih loh yuh, ya snuhn raꞌn galda bitsiꞌh si lloobwiꞌhn gucah tihxi tuhbigah raꞌ ñihza xteenn lloobwiꞌhn nin gurih loh yuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pwihsi bwiinn nin zohballaala dxiahga ñiꞌh chuu ba chaꞌzi ba dxyiꞌdxyi raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ya chiꞌchi gwabiiga raꞌ xpwiinn Jesuhs loh Ñiꞌh tin rahbi raꞌ ba: ―¿Xixnaa ruuꞌyidxyiꞌdxyi luꞌh puura cwenta si loh raꞌ bwiinn? ");
INSERT INTO zpvNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ya chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Laꞌh tu sihn zuluuꞌyi Dxiohs xcweenta cosa ralaꞌn raꞌ xteenn xquelrnabwaꞌ Ñiꞌh tin gacabwaꞌ tun, per laꞌh raꞌ bwiinn puura cweenta si guluꞌyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pwihsi bwiinn nin nahpa la guelrahcabwaꞌ zicaꞌha ru ban loh guelrahcabwaꞌ nin nahpa la ba, ya ziꞌchi zahpa ba ziahan rooꞌ guelrahcabwaꞌ, per bwiinn nin ayi xi nahpa paꞌh hasta loh gulliaaꞌhyiꞌhn nin nahpa ba ziyapitiiꞌhin loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","pwihsi niꞌchin nin rñiꞌn cweenta si loh raꞌ bwiinn, laasii laꞌh raꞌ ba rwaꞌha raꞌ ba per ayi riin loh raꞌ ba; neezaa rihn dxiahga raꞌ ba per ayi riaꞌzi dxyiꞌdxyi yihca raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","tin pur xcweenta raꞌ ba soobaa dxyiꞌdxyi raꞌ nin guñiꞌ guehtu profeta Isaías chin rahbi ba: Nicala pur mas nin gucaꞌdxiahga dziꞌtsi raꞌ bwiinn, per ayi chaꞌzi raꞌ ba dxyiꞌdxyi, ya ziꞌchi za nicala pur mas nin gutaꞌtsi dziꞌtsi raꞌ ba ayiza dxiin loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","laasii lastoꞌ raꞌ bwiinn raꞌ rii laꞌn biahca dxiipa, ya dxiahga raꞌ ba rihn raꞌ ba naaꞌha duxa, ya loh raꞌ ba ñieꞌwun niꞌchin ayi rwaꞌha loh raꞌ ba, cun ayi rihn za dxiahga raꞌ ba, ya stoꞌ raꞌ ba laꞌn biahca dxiipa, tin ayi dxieꞌnaꞌhla raꞌ ba naꞌh nee tin ayiza gusiaꞌca raꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per laꞌh tu, dichohsa tu laasii rwaꞌha zaꞌca bizloh tu nee rihnn zaꞌca za dxiahga tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","pwihsi guchiin nin rñiꞌn ziahan raꞌ daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cun ziahan za bwiinn zaꞌca raꞌ guclaaꞌdzi raꞌ ba ñwaꞌha raꞌ ba nin riiywaꞌha tu per ayi bwaꞌha raꞌ ban, neezaa guclaaꞌdzi raꞌ ba ñihn raꞌ ba dxyiꞌdxyi raꞌ nin rigacaꞌdxiahga tu nnah per ayi za bihn raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Rahbi za Ñiꞌh: ―Pwihsi gulgacaꞌdxiahga xa naa xcweenta bwiinn nin gulahchi biñih, nee xa naa raꞌ za stoꞌ cada tuhbigah bwiinn ziga cada tuhbigah lahta hasta biaaba llooba chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bwiinn raꞌ nin rihn dxyiꞌdxyi xteenn xquelrnabwaꞌ Dxiohs, nee ayi riaꞌzi dxyiꞌdxyi raꞌ chi laꞌñihca raꞌ ba, bwiinn raꞌ chi naa ziga llooba nin biaaba loh nezyuh, ya lwehgu gahca radzihn bwiinndxaaba ya rabweꞌhe dxiaꞌhla ba xchiꞌdxyi Dxiohs nin guhca biñih stoꞌ bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ya llooba nin biaaba lahda dxiah naa ziga bwiinn raꞌ nin riaꞌzi xcweenta xchiꞌdxyi Dxiohs ya rcaꞌha ban cun riahxi duxa stoꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","per ya laasii ayi nahpa raꞌ ba ziga dulbaaꞌ chaꞌyi, niꞌchin nin ayi riazahnee raꞌ ba xchiꞌdxyi Dxiohs cun gaduhbi xigaaba raꞌ ba, ya balaaquiꞌhn si rzaꞌcazii raꞌ ba o rdxyiꞌchinee raꞌ bwiinn laꞌh raꞌ ba pur xcweenta xchiꞌdxyi Dxiohs niꞌchin rbweꞌhe stoꞌ raꞌ ba xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ya llooba nin biaaba lahda yaguihchi raꞌ, naa ziga bwiinn nin bihn xchiꞌdxyi Dxiohs, per mahzi riuuꞌ ba lligaaba xtsiꞌn ba tin gapa ba cohsa zaꞌca xteenn loh guidxyiyuh riiꞌ, ya guelnazaꞌca chi rusaguiꞌhi laꞌh ba ya deeꞌ naa nin ruziaꞌtii xchiꞌdxyi Dxiohs laꞌn lastoꞌ ba, niꞌchin nin ayi riaꞌhan guelnazaꞌca laꞌn lastoꞌ bwiinn riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ya llooba nin biaaba loh yuh zaꞌca niꞌchi naa ziga bwiinn nin rihn xchiꞌdxyi Dxiohs ya riuuꞌ ba riaꞌzi ban, neezaa naa raꞌ ba ziga guiñaꞌh nin guzohba ñihza nin gucah ziahan llooba pur tuhbi llooba nin biaaba loh yuh zaꞌca chi, ya stuhbi ñihza chi gucah mas garooldallee llooba pur tuhbi za llooba nin biaaba riꞌchi, ya stuhbin ziga ñihza nin gucah galda bitsiꞌh llooba pur tuhbi za llooba nin biaaba stuhbi lahta loh yuh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ya bwiiꞌyidxyiꞌdxyi Jesuhs stuhbi cweenta loh raꞌ bwiinn chi rahbi Ñiꞌh: ―Guelrnabwaꞌ xteenn Dxiohs naa ziga tuhbi ndxiꞌhw nin bwiꞌhnn biñih trihgu zaꞌca loh xtahan ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","per chin naꞌllgahsi raꞌ ba, badzihn tuhbi bwiinn nin rdxiꞌchinee laꞌh bwiinn nin naa xteenn ñiꞌh loh yuh chi ya loh guel llahn bwiꞌhnn biñih ba dxihlldahan loh trihgu ya chin bwiꞌhnn niꞌchi gahn ziaa chiꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ya chin guhca gurooꞌ trihgu badziiꞌban doh, neezaa dxihlldahan chi laꞌgurooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ya chiꞌchi gwaguihtsi raꞌ mooza loh ballwaaꞌn nin naa xteenn ñiꞌh trihgu chi rahbi ba: “Daada, trihgu nin bwiꞌhnn biñih luꞌh loh dahan agaa ganaalladxiꞌhn, nee nnah ¿calla nehza chiꞌh guzaa dxihlldahan nin nuu lohon?” ");
INSERT INTO zpvNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chiꞌchi rahbi daada nin naa xteenn ñiꞌh trihgu chi loh mooza: “Pwehda tuhbi bwiinn nin rdxyiꞌchinee naꞌh bwiꞌhnn niꞌca.” Ya chiꞌchi gunaabadxyiꞌdxyi raꞌ mooza loh daada chi rahbi raꞌ ba: “¿Ta xclaaꞌdzi luꞌh chogataꞌdxu nu dxihlldahan raꞌ chi loh trihgu?” ");
INSERT INTO zpvNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per ballwaaꞌn chi squiiꞌ rahbi ba: “Ayi chegaxu tun laasii nagah nezii trihgu chegaxu tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mas chaꞌyi gusaaꞌn tu chiooꞌhon hasta chin chapitii liꞌhn; ya chiꞌchi cuꞌneezahn mooza raꞌ nin cheteꞌhecaa galoh dxihlldahan chi ya guunn raꞌ ban pur manuhlla tin guicaꞌdxih raꞌn, ya chiꞌchiyi gaguꞌchaꞌyi raꞌ xmoꞌzahn trihgu laꞌn yuuꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Neezaa bwiiꞌyidxyiꞌdxyi Jesuhs cweenta riiꞌ loh raꞌ bwiinn rahbi Ñiꞌh: ―Guelrnabwaꞌ xteenn Dxiohs naa ziga zi tuhbi bwiiꞌdzi biꞌtuꞌhn xteenn mortahsa nin bwiꞌhnn biñih tuhbi bwiinn loh xtahan ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nicala naa bwiiꞌdzi mortahsa bwiiꞌdzi biꞌtuꞌhn ru loh raꞌ garaa raꞌ bwiiꞌdzi raꞌ, per chin rahca gurooꞌhon, rahcan gurooꞌ ru loh raꞌ garaa raꞌ yahga rooꞌ, ya loh lliiꞌdzin ruhnn raꞌ maaniꞌhn xpichiehza raꞌ ma. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Neezaa bwiiꞌyidxyiꞌdxyi Jesuhs stuhbi cweenta ya rahbi Ñiꞌh: ―Guelrnabwaꞌ xteenn Dxiohs naa ziga levaduhra nin guguꞌchinaa tuhbi gunnaꞌh loh chohnna madxihdu harihn, ya levaduhra chi nahpa rusadxihin laꞌh cohba harihn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bwiiꞌyidxyiꞌdxyi Jesuhs garaa raꞌ dxyiꞌdxyi raꞌ riiꞌ loh raꞌ bwiinn cun ganaalla si cweenta raꞌ raꞌ si; ya dela sin ayi cweenta raꞌ ayi xi ruuꞌyidxyiꞌdxyi Ñiꞌh loh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Squiiꞌ guhca tin guzohba dxyiꞌdxyi ziga guñiꞌ tuhbi guehtu daada nin guñiꞌ xchiꞌdxyi Dxiohs chin bacaꞌh ba loh dxihtsi: Zuuꞌyidxyiꞌdxyiꞌhn ganaalla cweenta si raꞌ, nee ziñiꞌn dxyiꞌdxyi ralaꞌn raꞌ nin nuu galohyi galoh nin gulahchixchih Dxiohs guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ya chin guluhlla si bwiiꞌyidxyiꞌdxyi Jesuhs loh raꞌ bwiinn, chiꞌchi guyuuꞌtii Ñiꞌh laꞌñuuꞌ nez rii raꞌ xpwiinn Ñiꞌh, ya chiꞌchi gwabiiga raꞌ xpwiinn Ñiꞌh hasta zuu Ñiꞌh tin gunaaba raꞌ ba loh Ñiꞌh guuyidxyiꞌdxyi Ñiꞌh loh raꞌ ba xi zee loh xcweenta dxihlldahan loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chiꞌchi rahbi Jesuhs: ―Bwiinn nin ruhnn biñih bwiiꞌdzi biñih zaꞌca bwiinn chi naa Lliiꞌn Dxiohs nin naa ndxiꞌhw, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ya loh dahan naa ziga bwiinn guidxyiyuh raꞌ, ya bwiiꞌdzi biñih zaꞌca naa ziga xpwiinn Dxiohs, ya dxihlldahan naa ziga laꞌh raꞌ xpwiinn bwiinndxaaba, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ya bwiinn nin bwiꞌhnn biñih dxihlldahan naa bwiinndxaaba, ya jusehchi naa ziga chin ñichiloh guidxyiyuh, ya nin gutiaaꞌha jusehchi naa raꞌ xaanjla Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ya ziga rdiaaꞌha raꞌ cwaꞌn tin rcaꞌdxihin, ziꞌchi za saca raꞌ bwiinn nin ayi guclaaꞌdzi ñuzoꞌbadxiahga xchiꞌdxyi Dxiohs chin gaca jwisi loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ya Lliiꞌn Dxiohs nin naa ndxiꞌhw zixeꞌhla Ñiꞌh xaanjla Ñiꞌh tin gabwii raꞌ ba garaa raꞌ bwiinn nin bwiꞌhnn dziꞌn dxaaba raꞌ ziga bwiinn nin ruhnn riuuꞌ xtuhlda stuhbi bwiinn, cun nin ayi ruhnn xnehza tin ayi chuu raꞌ ba loh guelrnabwaꞌ xteenn Ñiꞌh, niꞌchin nahpa guicaꞌdxih raꞌ bwiinn raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ya ziꞌchi zi guzee raꞌ ba laꞌn horna xteenn gabihldxi, ya riꞌchi zuꞌn raꞌ ba, hasta loh lahyi raꞌ ba dxiinn guidaꞌw tantu guel nalaasa nin saca raꞌ bwiinn riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ya garaa raꞌ bwiinn nin guzaꞌloh guunn ziga xclaaꞌdzi Dxiohs gaca, zahca raꞌ ba ziga zi tuhbi biaꞌñih xteenn gubihdxyi loh guelrnabwaꞌ xteenn Xtaada raꞌ ba nin nuu dxibaaꞌ. Niꞌchin bwiinn nin zohballaala dxiahga raꞌ ñiꞌh chuu raꞌ ba chaꞌzi raꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Rahbi za Ñiꞌh: ―Guelrnabwaꞌ xteenn Dxiohs naa ziga tuhbi cohsa zaꞌca duxa nin nuulaꞌn taayi loh yuh, ya tuhbi ndxiꞌhw rdxeela cohsa zaꞌca duxa chi, ya loh rdxeela ban rusieꞌwgahca ba yihcan ya riahxi duxa ba rbiaꞌgarii ba tin riagatooꞌ ba garaa nin nahpa ba tin rziꞌ ba loh yuh hasta bidxeela ba cohsa zaꞌca chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Rahbi za Ñiꞌh: ―Guelrnabwaꞌ xteenn Dxiohs naa za zigazi tuhbi bwiinn nin ruhnn guriꞌxi nin rcaꞌnzaa rcaꞌndxiꞌhyi perla nin lasahca mweeyi rooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ya chin rdxeela ba tuhbi perla nin lasahca mweeyi chi, rbiaꞌgarii ba tin riagatooꞌ ba garaa raꞌ nin nahpa ba tin ruzaꞌh ba mweeyi rziꞌ ba perla chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Rahbi za Ñiꞌh: ―Guelrnabwaꞌ xteenn Dxiohs naa za ziga zi tuhbi dxihxi bwehlda, ya rnaꞌzu garaaloh bwehlda laꞌnan, ");
INSERT INTO zpvNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ya chin riadxah laꞌn dxihxi bwehlda, rabweꞌhecaa raꞌ bwiinnan rwaaꞌ ñihsa, ya riꞌchigahca rzohba raꞌ bwiinn nin riateꞌhe bwehlda raꞌ, tin rbwii raꞌ ba bwehlda nin mahzi galluꞌyi; tin riuuꞌchaꞌyi raꞌ ma laꞌn tipi ya riuuꞌbwih raꞌ nin ayi galluꞌyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ziꞌchi za gunnee Dxiohs laꞌh raꞌ bwiinn chin gaduhbi guidxyiyuh, zixeꞌhla Dxiohs xaanjla Ñiꞌh tin gabwii raꞌ ba bwiinn duhlda raꞌ loh raꞌ bwiinn zaꞌca ");
INSERT INTO zpvNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tin gulaꞌh raꞌ aanjla chi laꞌh raꞌ bwiinn yaꞌdxi raꞌ chi loh dxih xteenn gabihldxi, ya riꞌchi guꞌn raꞌ ba hasta dxigah gahwchihpa loh lahyi raꞌ ba, tantu guelnalasa nin saca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Gu rahcabwaꞌ tu garaa raꞌ dxyiꞌdxyi raꞌ rii? Chiꞌchi rahbi raꞌ ba: ―Uhn, Rahcabwaꞌ nun Daada. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ya chiꞌchi rahbi laꞌgaꞌh Jesuhs loh raꞌ ba: ―Chin rusiꞌdxi tuhbi bwiinn nin naann lehyi xcweenta guelrnabwaꞌ Dxiohs nin nuu dxibaaꞌ, naa ba ziga zi tuhbi ballwaaꞌn xteenn tuhbi yuuꞌ nin nahpa ziahan nin nazaꞌca raꞌ, ya rahca rbwii ba nin nacuubi cun nin guyuꞌxa loh raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ya chin guyaꞌloh bwiiꞌyidxyiꞌdxyi Jesuhs dxyiꞌdxyi raꞌ riiꞌ, babii Ñiꞌh nez chi ");
INSERT INTO zpvNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","chiꞌchi gwah Ñiꞌh loh guihdxyi Nazaret nez hasta bieꞌrooꞌ Ñiꞌh, tin guzoꞌbaloh baluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌn xquidoꞌ biꞌtuꞌhn raꞌ bwiinn raꞌ chi, ya bwiinn raꞌ badxyigaaꞌ duxa loh raꞌ ba laꞌh Ñiꞌh, chiꞌchi rahbi raꞌ ba: ―¿Canehza basiꞌdxi deeꞌ garaa raꞌ nin ruluuꞌyi ba? ¿Xi pur rahca ruhnn ba dziꞌn rooꞌ raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Tayi dee dxiꞌh nin naa lliiꞌn carpinteru nee tayi María dxiꞌh laa xmaah ba, nee tayi laꞌh dxiꞌh za ba nin naa bwihtsi Jacobo, Joseh, Simohn, cun Judas? ");
INSERT INTO zpvNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nee ¿tayi rii dxiꞌh nuu raꞌ bizaaꞌn niꞌca tuhsi junta cun laꞌh raꞌ nuꞌh? ¿Calla nehza basiꞌdxi chiꞌh niꞌca garaa raꞌ nin cagaluuꞌyi ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ya pur nin cayuhnn raꞌ ba lligaaba chi, niꞌchin ayi gwachiistoꞌ raꞌ ba xchiꞌdxyi Jesuhs, per chiꞌchi rahbi Ñiꞌh loh raꞌ bwiinn raꞌ chi: ―Garaa lahta ruzoꞌbadxiahga raꞌ bwiinn xchiꞌdxyi tuhbi profeta, per lahdxyi ba cun yihdzi ba ayi ruzoꞌbadxiahga raꞌ bwiinn xchiꞌdxyi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ya ayi bwiꞌhnn Ñiꞌh ziahan dziꞌn rooꞌ raꞌ riꞌchi, laasii ayi gwachiistoꞌ raꞌ bwiinn chi xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Laꞌn dxyih gahca raꞌ chi naa Herodes gobernador loh guihdxyi Galilea, ya bihn ba zaꞌbi dxyiꞌdxyi xcweenta Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","niꞌchin rahbi Herodes loh raꞌ xpwiinn ba nin rii hasta rnabwaꞌ ba: ―Dee naa Jwahn nin ruroꞌbañihsa, pwehda babahn ba loh raꞌ bwiinn guuchi, niꞌchin nin nahpa ba guelrnabwaꞌ tin ruhnn ba dziꞌn roo raꞌ ca. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Laasii laꞌh gahca Herodes gunabwaꞌ birwaꞌh yihca Jwahn, cun basieꞌw za ba laꞌh Jwahn lahtsidxiꞌba, cun bachiꞌbiduꞌh ba laꞌh Jwahn cun cadehn. Bwiꞌhnn Herodes squiiꞌ pur Herodías xcunnaꞌh bwihtsi ba nin biriaꞌhlah Felipe, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","laasii rahbi Jwahn loh Herodes: ―Ayi naa bwen cweꞌhelluꞌhu luꞌh xcunnaꞌh bwihtsi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ya chin bihn Herodes dxyiꞌdxyi raꞌ riiꞌ lwehgu guclaaꞌdzi Herodes ñidxiinn ba laꞌh Jwahn per ayi bwiꞌhnn ban hohra chi gahca laasii bidxyihbi ba laꞌh raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","per dxyihyi nin guhca dxyihlah Herodes, chiꞌchi badxiaꞌha lliiꞌndxaꞌpa Herodías pur nin guhca dxyihlah Herodes galaayi loh raꞌ ba, ya pur nin badxiaꞌha dxaꞌpa chi biahxi duxa Herodes, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","pwihsi pur nin biuuꞌstoꞌ ba badxiaꞌha dxaꞌpa chi niꞌchin biaꞌhandxyiꞌdxyinee ba laꞌh bi zudiꞌhi ba nin chiꞌh zi guinaaba bi loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ya ziga laꞌh dxaꞌpa chi galoh guñiꞌnee xmaah bi laꞌh bi, niꞌchin rahbi bi loh Herodes: ―Xclaaꞌdzihn guniꞌhi luꞌh naꞌh yihca Jwahn nin ruroꞌbañihsa loh tuhbi plahtu. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ya chin bihn Herodes niꞌchi guyuuꞌ nalaasa stoꞌ ba, per pur nin laꞌba badiꞌhi xchiꞌdxyi ba gudiꞌhi ba nin chiꞌh zi guinaaba dxaꞌpa chi loh ba niꞌchin cun ayi xa ñuhnn ba, nee pur cun neezaa bwiinn raꞌ nin zohbanee ba loh mweella niꞌchin ayi ñaca ñuchaꞌh xchiꞌdxyi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ya gunabwaꞌ ba birwaꞌh yihca Jwahn laꞌn lahtsidxiꞌba, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ya lwehgu gwanee raꞌ ba yihca Jwahn loh tuhbi plahtu gucaꞌha dxaꞌpa chi, ya laꞌh bi badiꞌhigah bin laꞌh xmaah bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ya seguihdu badzihn raꞌ bwiinn raꞌ nin guhca xpwiinn Jwahn tin bateesa raꞌ ba bweꞌltihxi Jwahn tin bacaꞌtsi raꞌ ban ya seguihdu gwaguihtsi raꞌ ba loh Jesuhs xa guhchi Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chin guyaꞌloh bihn Jesuhs xa guhchi Jwahn nin baroꞌbañihsa, chiꞌchi bariaꞌh Ñiꞌh riꞌchi tuhbi dxiꞌh Ñiꞌh, tin gucah Ñiꞌh laꞌn tuhbi laancha tin zee Ñiꞌh tuhbi lahta nez hasta ayi bwiinn raꞌ, per laꞌh raꞌ bwiinn chin bihn raꞌ ba canehza zee Jesuhs, chiꞌchi biriaꞌh raꞌ ba lahdxyi raꞌ ba, tin zeenaꞌhla ñaaꞌ raꞌ ba laꞌh Jesuhs nez loh dahan desiertu, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ya loh nin biehta Jesuhs laꞌn laancha chi, bwaꞌha Ñiꞌh loh raꞌ bwiinn chi, chiꞌchi basiaca Ñiꞌh laꞌh raꞌ bwiinn dxyihdxyi raꞌ nin riinee raꞌ bwiinn riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ya chin gurih gueꞌla, chiꞌchi gwabiiga raꞌ xpwiinn Ñiꞌh cweeꞌ Ñiꞌh ya rahbi raꞌ ba loh Ñiꞌh: ―Bwaꞌha laꞌh gudxyih guhca, nee hasta dxuu nuꞌh riiꞌ ayi chyu bwiinn nuutiiꞌ. Mas chaꞌyi guñiꞌ loh raꞌ bwiinn ca guziaa raꞌ ba nez rraandxu raꞌ, tin nez chi siꞌ raꞌ ba nin gahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chiꞌchi rahbi Jesuhs: ―Ayi xchiꞌhn guziaa raꞌ ba; ¡laꞌh tu gulgadiꞌhi nin gahw raꞌ ba! ");
INSERT INTO zpvNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh: ―Ayi chyu nahpa ziahan guelwahw gayaꞌn nu laꞌh raꞌ ba ñaꞌchiꞌca gaꞌyu pahn cun chiohpa bwehlda nuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chiꞌchi rahbi Jesuhs: ―Gultaꞌnee pahn chi cun bwehlda chi riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chiꞌchi gunabwaꞌ Ñiꞌh guzohba raꞌ bwiinn ziahan raꞌ chi loh cwaꞌn nin rii riꞌchi, chiꞌchi gucaꞌha Ñiꞌh pahn chi, cun garoopa bwehlda chi gudziiꞌban loh naa Ñiꞌh, ya bwaꞌha Ñiꞌh nez llaaꞌndxibaaꞌ tin badiꞌhi Ñiꞌh guelzuxchiilli laꞌh Dxiohs nin nuu dxibaaꞌ, ya chiꞌchi gutaaꞌha Ñiꞌh pahn raꞌ chi chiꞌchi badiꞌhi Ñiꞌhn laꞌh raꞌ xpwiinn Ñiꞌh ya laꞌh raꞌ ba gudxiꞌzi raꞌ ban, tin gudahw raꞌ bwiinn ziahan raꞌ chin, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ya garaa raꞌ bwiinn raꞌ chi gudahw raꞌ ba hasta ayi gunnah ru raꞌ ba ñahw raꞌ ba, ya nin bwiꞌhnn sohbra raꞌ chi guhca raꞌn tsiꞌh bichiohpa tipi, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ya bwiinn raꞌ nin gudahw raꞌ chi guhca raꞌ ba ziga chiꞌh gaꞌyu mihyi bwiinn raꞌ nin naa raꞌ si ndxiꞌhw ya ayi guinacwenta raꞌ biñiꞌn cun gunnaꞌh raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ya chin guyaꞌloh dziꞌn rooꞌ nin bwiꞌhnn Ñiꞌh riꞌchi, chiꞌchi gunabwaꞌ Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh tin gucah raꞌ ba laꞌn tuhbi laancha tin zee ñiidxyuu raꞌ ba, ziga nahpa gadzihn raꞌ ba stuhbi lahdu rwaaꞌ ñihsa chi, ya laꞌh Ñiꞌh biaꞌhancah ru Ñiꞌh riꞌchi, laasii gwaꞌha Ñiꞌh dxiuuꞌnehza raꞌ bwiinn ziahan raꞌ chi tin guziaa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ya chin guyaꞌloh guñiꞌ Ñiꞌh loh raꞌ bwiinn ziahan raꞌ chi, chiꞌchi gucah Ñiꞌh tuhbi dahan tin riꞌchi gudihdxyi-gunaaba Ñiꞌh Xtaada Dxiohs Ñiꞌh tuhsi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ya loh nin zeegah laancha zihtu nez galaayi loh ñihsa chi, ya guzoꞌbaloh rteesa bwih ñihsa, ya rcaꞌnchiiꞌhin laꞌh laancha nee neezaa laasii mwehrsi xnehz bwih zeenee raꞌ ba laancha chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ya natehyiꞌhn run gucaꞌha Jesuhs zeezah Ñiꞌh loh ñihsa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ya chin bwaꞌha raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh zezah loh ñihsa, bidxyihbi duxa raꞌ ba, ya hasta gudihdxyidxiah raꞌ ba pur nin bidxyihbi duxa raꞌ ba ya rahbi raꞌ ba: ―¡Pweda tuhbi pantasma niꞌca! ");
INSERT INTO zpvNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¡Gulgadiꞌhi balori stoꞌ tu; naꞌh gahcan, ayi guidxyihbi tu! ");
INSERT INTO zpvNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ya chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Daada, sidela yiꞌhin, gunabwaꞌ dxieꞌldahn hasta zuu Yuꞌbiluꞌh nee saꞌhn loh ñihsa. ");
INSERT INTO zpvNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―¡Gudaaꞌ! ―Rahbi Jesuhs. Ya chiꞌchi biehta Pehdru laꞌn laancha, tin guzoꞌbaloh zeezah ba loh ñihsa chi para hasta zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","per chin bwaꞌha Pehdru balaaca bwih duxa nin zuu loh ñihsa chi, bidxyihbi duxa ba, chiꞌchi guzoꞌbaloh zeezaꞌbi ba loh ñihsa, ya gudihdxyidxiah ba rahbi ba: ―¡Baldaꞌh naꞌh Daada! ");
INSERT INTO zpvNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ya hohra chi gahca gunaꞌzu Jesuhs naa Pehdru, ya rahbi Ñiꞌh loh ba: ―Ndxiꞌhw nin ayi riachiistoꞌ ñiꞌh naꞌh; ¿xixnaa ayi gwachiistoꞌ luꞌh xchiꞌdxyiꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ya chin biuuꞌnee Ñiꞌh laꞌh ba laꞌn laancha chi lwehgu si guleeza bwih chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ya chiꞌchi rahbi raꞌ snuhn raꞌ xpwiinn Ñiꞌh nin nuu laꞌn laancha chi: ―¡Guchiica Yuꞌbiluꞌh naa luꞌh Lliiꞌn Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ya chin guyaꞌloh gudiiꞌdxinee Ñiꞌh laꞌh raꞌ ba loh laguhn, badzihnnee Ñiꞌh laꞌh raꞌ ba guihdxyi Genesaret, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ya chin biuꞌnbwaꞌ raꞌ bwiinn guihdxyi chi laꞌh Jesuhs, batiꞌchi raꞌ ba dxyiꞌdxyi loh guihdxyi raꞌ nin rii gadiidxi guihdxyi Genesaret chi tin gwanee raꞌ ba bwiinn dxyihdxyi raꞌ hasta zuu Jesuhs tin basiaca Ñiꞌh laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ya gudxiꞌhn raꞌ ba bidxiꞌ raꞌ ba mas loh lahdxi nin nahcu Ñiꞌh, ya garaa raꞌ bwiinn nin bidxiꞌ loh xahba Ñiꞌh biaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Seguihdu gwabiiga paaldaa raꞌ bwiinn fariseu cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs hasta zuu Jesuhs; bwiinn raꞌ riiꞌ gueꞌdu badzihn raꞌ ba zeꞌ raꞌ ba nez guihdxyi Jerusalehn, ya rahbi raꞌ ba loh Jesuhs: ");
INSERT INTO zpvNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Xixnaa ayi ruzoꞌbadxiahga raꞌ xpwiinn luꞌh xcweenta costumbre raꞌ nin basiaꞌhannee raꞌ xtaada guldooꞌ raꞌ nuꞌh laꞌh nuꞌh? ¿Xixnaa ayi rdxiꞌbi naa raꞌ ba chin rahw raꞌ ba pahn? ");
INSERT INTO zpvNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Neezaa laꞌh tu xixnaa ayi ruzoꞌbadxiahga tu xchiꞌdxyi Dxiohs tin gaca za chezahnee tu xchiꞌdxyi bwiinn guuhla raꞌ chi? ");
INSERT INTO zpvNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Laasii laꞌh Dxiohs guñiꞌ Ñiꞌh rahbi Ñiꞌh: “Bazoꞌbadxiahga xchiꞌdxyi xpaah luꞌh cun xmaah luꞌh, ya bwiinn nin gusahcaloh laꞌh xpaah ñiꞌh cun xmaah ñiꞌh nahpa gachi bwiinn chi.” ");
INSERT INTO zpvNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per laꞌh tu rusaaꞌn tu rahbi tuhbi bwiinn loh raꞌ xcuzahn ba: “Ayi nuu gacaneꞌhn yiꞌh laasii garaa raꞌ nin naꞌpahn laꞌn badiꞌhiguhnaꞌhn loh Dxiohs”, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ya garaa raꞌ bwiinn nin rñiꞌ squiiꞌ ayi ru nahpa gacanee raꞌ ba laꞌh xcuzahn ba, ya ziꞌchi rbweꞌhestoꞌ tu xchiꞌdxyi Dxiohs, ya ruhnn tu nin naa xigaaba si tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Bwiinn rusaguiꞌhi raꞌ! Nayaa-nayaa guñiꞌ guehtu profeta Isaías xcweenta tu chin bacaꞌh ba squiiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bwiinn raꞌ riiꞌ rbwihdxyi-rnaaba naꞌh cun rwaaꞌ raꞌ ba, per stoꞌ raꞌ ba zihtu riaꞌhanan nez loon. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lliaaꞌha zi naa ziga raann raꞌ ba naꞌh, laasii ruluuꞌyi raꞌ ba xchiꞌdxyi raꞌ bwiinn guidxyiyuh raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ya chiꞌchi gudihdxyi Jesuhs laꞌh raꞌ bwiinn ya rahbi Ñiꞌh loh raꞌ ba: ―Gulgahcaꞌdxiahga nee gulchuuꞌ-gulchaꞌzi dxyiꞌdxyi raꞌ riiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ayi nin rahw dxiꞌh bwiinn rguꞌtii duhlda stoꞌ ba, sino que rwaaꞌ bwiinn rreꞌh dxyiꞌdxyi dxaaba nin rusiaaba laꞌh ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ya chiꞌchi gwabiiga raꞌ xpwiinn Jesuhs hasta zuu Ñiꞌh ya rahbi raꞌ ba loh Ñiꞌh: ―¿Ta naann luꞌh beꞌhe raꞌ bwiinn fariseu bidxyiꞌchi raꞌ ba chin bihn raꞌ raꞌ ba dxyiꞌdxyi raꞌ nin guñiꞌ luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Garaa raꞌ yahga raꞌ nin ayi bwiꞌhnn biñih Xtaaꞌdahn nin nuu dxibaaꞌ, ziyaꞌdxu raꞌn cun gaduhbi xtulbaaꞌ raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gulgasaaꞌn raꞌ ba, laasii bwiinn dxieꞌpa raꞌ ba nee laasii za laꞌh raꞌ ba zeegaluuꞌyi raꞌ ba neziuh laꞌh snuhn raꞌ bwiinn dxieꞌpa, ya sidela ziꞌchi tuhbi dxieꞌpa guluuꞌyi ba neziuh laꞌh stuhbi dxieꞌpa garoopa raꞌ ba ziaaba raꞌ ba laꞌn tuhbi guiiꞌdxiu. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chiꞌchi rahbi Pehdru: ―Bwiiꞌyidxyiꞌdxyi loh nu pur cweenta riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chiꞌchi rahbi Jesuhs: ―¿Ta neezaa tu ayi rahcabwaꞌ tu dxyiꞌdxyi raꞌ riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tayi rahcabwaꞌ tu garaa guelwahw nin rahw bwiinn radzihnan hasta laꞌn buxa stoꞌ ba, ya chin radiiꞌdxin laꞌn ziꞌh ba, chiꞌchiyi riuuꞌbwihin? ");
INSERT INTO zpvNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per dxyiꞌdxyi dxaaba raꞌ nin riaꞌh rwaaꞌ bwiinn, niꞌchi sihn riinlohon stoꞌ ba, ya dxyiꞌdxyi dxaaba raꞌ chi naa nin rguꞌtii laꞌh bwiinn loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","laasii stoꞌ bwiinn riinloh lligaaba dxaaba raꞌ ziga xcweenta nin rdxiin bwiinn lasaaꞌ ba, guelgubwihlli, guelgubaaꞌn, cun ziga bwiinn nin ruuꞌyidxyiꞌdxyi dxyiꞌdxyi dxixiꞌhw raꞌ, cun nin rguꞌdii laꞌh bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ya lligaaba dxaaba raꞌ riiꞌ rusiaaba laꞌh bwiinn loh duhlda; per nin rahw bwiinn nicala ayi guzoꞌbadxiahga ba xchiꞌdxyi bwiinn chiꞌbi naa ba, ayi naa dee ziga dxiaaba bwiinn loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ya chin babii Jesuhs riꞌchi, gunaꞌzu nehza Ñiꞌh zee Ñiꞌh loh guihdxyi xteenn Tiru cun Sidohn, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ya riꞌchi nuu tuhbi gunnaꞌh cananea ya chin bwaꞌha bi laꞌh Jesuhs gwabiiga bi loh Ñiꞌh dxyigah rbwihdxyidxiah bi rahbi bi: ―¡Lliiꞌn guehtu Davihd, balahsa stoꞌ luꞌh naꞌh! ¡Laasii lliiꞌn dxaꞌpaꞌhn nuu tuhbi bwiinndxaaba stoꞌ bi nin cazaꞌcazii duxa laꞌh bi! ");
INSERT INTO zpvNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ya cun ayi guñiꞌtiiꞌ Jesuhs loh bi, ya chiꞌchi gwabiiga raꞌ xpwiinn Ñiꞌh hasta zuu Ñiꞌh tin gunaaba raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―Guhdzi loh gunnaꞌh ca guziaa bi, ¿xixnaa zeꞌbwihdxyidxiah bi gaduhbi nin zeꞌnaꞌhla bi laꞌh nuꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chiꞌchi rahbi Jesuhs: ―Dxiohs guluꞌnehza Ñiꞌh naꞌh para laꞌh raꞌ bwiinn nin naa raꞌ ziga lliꞌhyi nin bizaꞌbi nin rii raꞌ loh guihdxyi Israel. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per gunnaꞌh chin cun bazuꞌnllihbi bi nezloh Jesuhs ya rahbi bi: ―¡Daada, rnaꞌbaꞌhn gacanee luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chiꞌchi rahbi Jesuhs: ―Ayi naa bwen chyu guziaꞌtii guehta loh raꞌ lliiꞌn raꞌn tin guicaꞌha raꞌ bwehcu raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chiꞌchi rahbi gunnaꞌh chi loh Jesuhs: ―Ziꞌchi Daada; per nee bwehcu raꞌ rahw taayi guehta raꞌ nin riaaba llaaꞌnmweella xballwaaꞌn ma. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ya chiꞌchi rahbi Jesuhs: ―Gunnaꞌh, zirooꞌ duxa riachiistoꞌ luꞌh naꞌh; zahca gaca ziga xclaaꞌdzi luꞌh. Ya hohra chi gahca biaca lliiꞌndxaꞌpa gunnaꞌh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ya loh nin babii Jesuhs riꞌchi gwah Ñiꞌh nez rwaaꞌ laguhn xteenn Galilea, ya chin badzihn Ñiꞌh riꞌchi gucah Ñiꞌh yihca tuhbi dahan ya guzohba Ñiꞌh yihca dahan chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","nee seguihdu badiaaꞌha ziahan rooꞌ raꞌ bwiinn yihca dahan hasta zohba Jesuhs, ya bwiinn raꞌ chi zeꞌnee raꞌ bwiinn dxyihdxyi raꞌ nin ayi riin loh raꞌ ñiꞌh, cweeꞌ raꞌ, bwiinn nin rahca ñaaꞌ ñiꞌh, goopa raꞌ, cun bwiinn raꞌ nin rahca raꞌ ziahan ru gueldxyihdxyi raꞌ; ya batsiiga raꞌ ba garaa raꞌ bwiinn raꞌ chi hasta zuu Jesuhs ya basiaca Ñiꞌh laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ya pur nin basiaca Jesuhs laꞌh raꞌ bwiinn dxyihdxyi raꞌ chi badxyigaaꞌ duxa loh snuhn raꞌ bwiinn nin rii riꞌchi laasii bwaꞌha raꞌ ba laꞌh bwiinn cweeꞌ raꞌ cun bwiinn nin rahca raꞌ ñaaꞌ ñiꞌh laꞌh raꞌ biaca ziꞌchi za nin naa raꞌ dxieꞌpa biaca raꞌ za ba, ya ziꞌchi garaa raꞌ ba chin bwaꞌha raꞌ ba garaa nin bwiꞌhnn Jesuhs, guzoꞌbaloh badiꞌhi raꞌ ba guelzuxchiilli loh Xchiohs bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chiꞌchi gudihdxyi Jesuhs xpwiinn Ñiꞌh tin rahbi Ñiꞌh loh raꞌ ba: ―Ralahsa stoꞌn laꞌh raꞌ bwiinn raꞌ ca laasii laꞌh chohnna dxyih guhca la riinee raꞌ ba naꞌh, nee ayi nahpa raꞌ ba nin gahw raꞌ ba. Ayi xclaaꞌdzihn guxeꞌhla raꞌn ba rwaaꞌ yihdzi raꞌ ba ziga nagahdxi gahw raꞌ ba, laasii nagah dxiahgaduhbi raꞌ ba cun guelrchiaꞌhan loh neziuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―¿Per canehza chocaꞌha nuꞌh xi gahw garaa raꞌ bwiinn ca?, laasii nez dxuu nuꞌh rii ayi xi nuutiiꞌhin, nee nin ayiza chyu bwiinn nuu rrandxu. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh raꞌ ba rahbi Ñiꞌh: ―¿Paaldaa pahn nahpa tu riꞌca? ―Gahdzihn ―rahbi raꞌ ba― cun nuhn bwehldiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ya chiꞌchi gunabwaꞌ Ñiꞌh guzohba raꞌ bwiinn raꞌ chi loh yuh, ");
INSERT INTO zpvNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","chiꞌchi gucaꞌha Ñiꞌh gagaadzii pahn chi gunaꞌzu Ñiꞌhn cun naa Ñiꞌh, cun bwehlda raꞌ chi, ya chin guyaꞌloh badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs pur guelwahw chi, badiꞌhi Ñiꞌhn laꞌh raꞌ xpwiinn Ñiꞌh tin gudxiꞌzi raꞌ ban loh raꞌ gadahpa mihyi raꞌ bwiinn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ya garaa raꞌ ba gudahw raꞌ ba hasta ayi ru gunnah raꞌ ba ñahw raꞌ ba, ya chin guyaꞌloh gudahw raꞌ gadahpa mihyi bwiinn raꞌ chi za gahdzi tipi guelwahw biaꞌhancah. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Garaa raꞌ bwiinn nin gudahw raꞌ guhca raꞌ ba ziga tahpa mihyi ndxiꞌhw raꞌ si, ya gunnaꞌh raꞌ cun biñiꞌn raꞌ nin ayi guinagaaba. ");
INSERT INTO zpvNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ya chiꞌchi guñiꞌ Jesuhs loh raꞌ bwiinn raꞌ chi tin biuuꞌnehza raꞌ ba ya bacah chiꞌh Ñiꞌh laꞌn laancha tin zee Ñiꞌh loh guihdxyi nin laa Magdala. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bwiinn fariseu raꞌ cun saduceu raꞌ gwabiiga raꞌ ba hasta zuu Jesuhs, laasii xclaaꞌdzi raꞌ ba guunn raꞌ ba prehba laꞌh Ñiꞌh gu zahca guunn Ñiꞌh tuhbi sehn nin guinaaba raꞌ ba, ziga tuhbi sehn nin dxiinloh nez dxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gudxyih nin rwaꞌha tu rahca naxñaa llaaꞌndxibaaꞌ chiꞌchi rahbi tu: “Bayinnahsihn ayi dxiaaba ñihsadxiah guillii laasii naxñaa dxibaaꞌ”, ");
INSERT INTO zpvNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ya ziga chin rwaꞌha tu naxñaa rñah rsiiyi chiꞌchi rahbi tu: “Nadxyih ziaaba ñihsadxiah, laasii neezaa nuu raꞌ xcahyi llaaꞌndxibaaꞌ.” Pwihsi sidela laꞌh tu chaꞌyi tu rahcabwaꞌ tu sehn raꞌ nin rwaꞌha tu llaaꞌndxibaaꞌ, ¿xixnaa chiꞌh sehn xteenn raꞌ dxyih riiꞌ ayi rahcabwaꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nee ¿xixnaa ayi nnaa tu guunn tu nin xclaaꞌdzi Dxiohs gaca sino que nin xclaaꞌdzi si tu nee nnah canaaba tu tuhbi sehn? Per ayi guniꞌhihn sehn chi laꞌh tu. Sola sehn xteenn guehtu Jonahs guniꞌhihn. Ya chin guyaꞌloh niꞌchi cun basiaꞌhan Ñiꞌh laꞌh si raꞌ ba, ya zee chiꞌh Ñiꞌh stuhbi nehza. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ya chin gudiiꞌdxicaa raꞌ xpwiinn Ñiꞌh stuhbi lahdu rwaaꞌ laguhn biaꞌldastoꞌ raꞌ ba ñahnee raꞌ ba pahn nin ñahw raꞌ ba nez chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulguiaꞌha dziꞌtsi, nee gulgahca nasiin tin ayi gariaꞌcaa tu ziga naa xlevaduhra raꞌ bwiinn fariseu cun bwiinn saduceu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chiꞌchi guzoꞌbaloh raꞌ ba cayuhnn raꞌ ba lligaaba: ―Dee guñiꞌ Jesuhs loh nuꞌh laasii ayi chyu nuꞌa pahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ya chin guhcabwaꞌ Jesuhs cuun lligaaba nin nuu raꞌ ba chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¡Lliꞌballaa gulliaaꞌha riachiistoꞌ tu xchiꞌdxyi Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tayi rahcabwaꞌtiiꞌ tu, nee ta nin ayi za riagannahstoꞌ tu xcweenta gagaꞌyu pahn nin gudxiꞌziꞌhn loh gaꞌyu mihyi raꞌ bwiinn, ya paaldaa tipi guhca nin biaꞌhancah? ");
INSERT INTO zpvNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nee ¿ta nin gagaadzii pahn nin gudxiꞌziꞌhn loh tahpa mihyi raꞌ bwiinn ayi riagannastoꞌ tu, ta nin paaldaa tipi nin biaꞌhancah ayi riagannastoꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Xixnaa chiꞌh ayi rahcabwaꞌ tu dxyiꞌdxyi nin cañiꞌn ayi naan pur pahn? Nin rñiꞌn loh tu naa gulgahca nasiin tin ayi gariaꞌcaa tu ziga naa xlevaduhra raꞌ bwiinn fariseu cun saduceu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chiꞌchi guhcabwaꞌ raꞌ ba ayi levaduhra pahn dxiꞌh bazeꞌta Jesuhs sino que ziga naa dxyiꞌdxyi raꞌ nin ruluuꞌyi raꞌ bwiinn fariseu raꞌ cun saduceu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ya chin badzihn Jesuhs loh guihdxyi Cesarea xteenn Filipu, gunaabadxyiꞌdxyi Jesuhs loh raꞌ xpwiinn Ñiꞌh rahbi Ñiꞌh: ―¿Chyu niꞌca rahbi raꞌ bwiinn naahn? ");
INSERT INTO zpvNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ya chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Nuu raꞌ bwiinn rahbi raꞌ ba yiꞌh naa luꞌh Jwahn nin ruroꞌbañihsa, ya snuhn raꞌ ba rahbi Elías naa luꞌh, ya snuhn raꞌ ba rahbi naa luꞌh Jeremías o chyuulla stuhbi raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chiꞌchi rahbi Ñiꞌh: ―Ya laꞌh xchiꞌh tu, ¿xi nnaa tu chyu naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chiꞌchi rahbi Simohn Pehdru loh Ñiꞌh: ―Yiꞌh naa luꞌh Crixtu Lliiꞌn Dxiohs nin nuu nabahan dziꞌtsi llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ya chiꞌchi rahbi Jesuhs loh Pehdru: ―Dichohsa luꞌh, Simohn lliiꞌn Jonahs, laasii ayi guhca bwiinn zi nin basiaꞌñih loh xigaaba luꞌh cuun ziga guñiꞌ luꞌh, sino que naan Xtaaꞌdahn nin nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya naꞌh rñiꞌn Pehdru laa luꞌh, (ziga laa “Dxiah biꞌtiꞌhn”), per yihca dxiah rooꞌ riiꞌ gunnchaꞌyiꞌhn xquidoꞌn nin naa ziga xpwiinn raꞌn, ya nin guelrnabwaꞌ xteenn gabihldxyi ayi guunn gahn gutsihyi laꞌhan, ");
INSERT INTO zpvNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ya zuniꞌhihn guelrnabwaꞌ yiꞌh tin guluuꞌyi luꞌh laꞌh raꞌ bwiinn nin gwachii stoꞌ ñiꞌh xchiꞌdxyiꞌhn; nee xi chiꞌhzi nin gusaaꞌn luꞌh guunn raꞌ ba, o xi chiꞌhzi nin ayi gusaaꞌn luꞌh guunn raꞌ ba; zuhnn Dxiohs para soobaa xchiꞌdxyi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ya chiꞌchi bacaꞌhpwehn Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh tin ayi chyuloo chixteeꞌ raꞌ ba laꞌh Ñiꞌh naa Ñiꞌh Crixtu. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ya hohra chi gahca guzoꞌbaloh guñiꞌ Jesuhs loh raꞌ xpwiinn Ñiꞌh nahpa chee Ñiꞌh guihdxyi Jerusalehn, laasii riꞌchi nahpa gutiꞌdxiloh Ñiꞌh guelrzaꞌcazii duxa lahtsi naa raꞌ bwiinnguuhla raꞌ, cun bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza, cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs; neezaa rahbi Ñiꞌh: ―Nahpa zidxiinn raꞌ ba naꞌh, per chin dxiohnna dxyih guhchiꞌhn zabahnahn loh guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ya chiꞌchi biriaꞌcaanee Pehdru laꞌh Ñiꞌh tuhbi lahdu chiꞌchi rahbi ba loh Ñiꞌh: ―¡Per laꞌh Dxiohs ayi naa Ñiꞌh saca luꞌh ziꞌchi! ");
INSERT INTO zpvNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ya chiꞌchi gubiaꞌgarii Jesuhs rahbi Ñiꞌh loh Pehdru: ―¡Biriaꞌcaa loon bwiinndxaaba!, laasii rusiin luꞌh naꞌh loh lligaaba dxaaba, laasii yiꞌh ayi nuu luꞌh xigaaba Dxiohs laꞌlaꞌgaꞌh xigaaba bwiinn guidxyiyuh ruhnn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Sidela chyu xclaaꞌdzi gaca xpwiiꞌnnahn, nahpa dxiaꞌldastoꞌ ba xquelnabahan ba tin guicaꞌha ba xcruhzi ba (dxyiꞌdxyi riiꞌ nin ruzeꞌta cruhzi naa gutiꞌdxiloh ba trabahjw); pwihsi dela guunn ba ziꞌchi, zahca dxieꞌnaꞌhla ba naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","laasii bwiinn nin xclaaꞌdzi guhldaꞌh xquelnabahan ñiꞌh zuñihchi ban, per bwiinn nin siꞌguehlda guñihchi xquelnabahan ñiꞌh pur naꞌh zadxeela ban. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Xix galluꞌyi guicaꞌha tuhbi bwiinn gaduhbi loh guidxyiyuh sidela laꞌh ba guñihchi ba xquelnabahan ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Laasii ziꞌ dxyih nin dxiꞌ Lliiꞌn Dxiohs nin naa ndxiꞌhw loh llaꞌñih xteenn Xtaada Ñiꞌh nin nuu dxibaaꞌ cun neezaa xaanjla Ñiꞌh dxieꞌnee Ñiꞌh, ya chiꞌchi zidxihlli Ñiꞌh laꞌh raꞌ cada tuhbigah bwiinn zigachiꞌh zi nin guhca xtsiꞌn ba dela dziꞌn zaꞌca o dela dziꞌn dxaaba. ");
INSERT INTO zpvNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Guchiin nin rñiꞌn loh tu, mas paaldaa raꞌ bwiinn nin rii raꞌ riiꞌ nabahan gahca raꞌ ba chin guibiaꞌgarii Lliiꞌn Dxiohs nin naa ndxiꞌhw, dxiꞌ Ñiꞌh loh guelrnabwaꞌ xteenn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chin gudiiꞌdxi xoꞌpa dxyih, chiꞌchi gucaꞌha Jesuhs laꞌh Pehdru cun Jacobo cun Jwahn bwihtsi Jacobo, zenee Ñiꞌh laꞌh si raꞌ ba yihca tuhbi dahan rooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ya riꞌchi bwaꞌhaloh raꞌ ba bidxaꞌh ziga rñah Jesuhs loh Ñiꞌh guñah ziga biaꞌñih xteenn gubihdxyi, ya xahba Ñiꞌh biahca labwehen ziga zi tuhbi biaꞌñih. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ya hohra chi gahca baluuꞌyiloh guehtu Moisehs cun Elías cañiꞌnee raꞌ ba loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","chiꞌchi rahbi Pehdru loh Jesuhs: ¡Daada, bwenduxa dxuu nuꞌh rii! Sidela yiꞌh nnaa luꞌh guꞌnnahn chohnna yuuꞌ biꞌtuꞌhn: tuhbin par Yuꞌbiluꞌh, stuhbin gaca xteenn Moisehs ya stuhbin gaca xteenn Elías. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ya gaduhbi nin cañiꞌ Pehdru ziꞌchi, guzaꞌbi tuhbi xcahyi nin biduꞌbi laꞌh raꞌ ba ya laꞌn xcahyi chi bihn raꞌ ba guñiꞌ tuhbi rsiaaꞌha nin rahbi: ―Deeꞌ naa Lliiꞌnahn nin nadziiꞌhihn, riahxineꞌhn bi; gulgazoꞌbadxiahga xchiꞌdxyi bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ya chin bihn raꞌ gadxiohnna xpwiinn Ñiꞌh dxyiꞌdxyi raꞌ chi hasta loh yuh guhta gurloh raꞌ ba laasii bidxyihbi duxa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ya chiꞌchi gwabiiga Jesuhs hasta naꞌgurloh raꞌ ba chiꞌchi bidxiꞌ Ñiꞌh laꞌh raꞌ ba ya rahbi Ñiꞌh loh raꞌ ba: ―Gulchestii; ayi guidxyihbi tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ya chin guteesa loh raꞌ ba tin bwaꞌha raꞌ ba loh Ñiꞌh, ya ayi ru bwaꞌha raꞌ ba bwiinn raꞌ nin bwiiꞌdxyiꞌdxyinee Jesuhs riꞌchi, tuhsi Ñiꞌh zuu Ñiꞌh riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ya gaduhbi nin zeeyehtanee Ñiꞌh laꞌh raꞌ ba dahan chi, rahbi Ñiꞌh loh raꞌ ba: ―Ayi chyuloo guuyi tu nin baluuꞌyiloh loh tu hastayi chin gabahan Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Xixnaa rahbi raꞌ mwehsu nin ruluuꞌyi xlehyi Moisehs nahpa galoh Elías dxiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guchiica galoh Elías nahpa dxiꞌ, tin laꞌh ba guunn xnehza ba garaa raꞌ nin ayi naa zaꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per naꞌh rñiꞌn loh tu laꞌh Elías biꞌ la per laꞌh raꞌ ba ayi biuꞌnbwaꞌ raꞌ ba laꞌh ba sino que bwiꞌhnnee raꞌ ba laꞌh ba ziga guclaaꞌdzi raꞌ ba, pwihsi ziꞌchi gahca za laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw zizaꞌcazii Ñiꞌh lahtsinaa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ya chiꞌchi guhcabwaꞌ raꞌ xpwiinn Ñiꞌh cagazeꞌta Ñiꞌh Jwahn nin baroꞌbañihsa. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ya chin badzihn Ñiꞌh hasta rii raꞌ bwiinn, chiꞌchi gwabiiga tuhbi ndxiꞌhw hasta zuu Jesuhs, chiꞌchi bazuꞌnllihbi ba loh Ñiꞌh ya rahbi ba loh Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Daada, balahsastoꞌ luꞌh laꞌh lliiꞌnahn, laasii nalasa duxa rahca bi; ziahan la riaaba bi loh bwehla o loh ñihsa, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","riiꞌ bieꞌldaneꞌhn bi loh raꞌ xpwiinn luꞌh per ayi bwiꞌhnn raꞌ ba gahn ñaca bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chiꞌchi rahbi Jesuhs: ¡Ayi bwiinn raꞌ nin ayi riachiistoꞌ raꞌ ñiꞌh xchiꞌdxyiꞌhn! ¡Bwiinn nahda raꞌ! ¿Hasta balaaca chiꞌh nin chuꞌneꞌhn laꞌh tu? ¿Hasta balaaca chiꞌh gaca guꞌnnahn waanta laꞌh tu? ¡Gudaꞌnee lliiꞌn luꞌh riiꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ya chiꞌchi gunabwaꞌ Jesuhs loh bwiinndxaaba chi tin bariaꞌh ba stoꞌ biꞌnxtuhbi chi ya desde hohra chi gahca biaca bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ya chiꞌchi bwiiꞌyidxyiꞌdxyinee raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh tuhbi lahduꞌhn ya gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Xixnaa ayi chyu bwiꞌhnn gahn ñabweꞌhe bwiinndxaaba chi stoꞌ biꞌnxtuhbi chi laꞌh nu? ");
INSERT INTO zpvNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laasii ayi riachiistoꞌ tu xchiꞌdxyi Dxiohs. Ya sidela laꞌh tu ñachiistoꞌ tu xchiꞌdxyi Dxiohs nicala ziga zi madxihdu ziga chiꞌh tuhbi bwiiꞌdzi mortahsa, ñahca ñahbi tu loh dahan riiꞌ: “Biyaꞌdxu riiꞌ tin gwah stuhbi lahta”, ya ñiyaꞌdxun, ya ayi xi ñuhnn gahn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Per bwiinndxaaba raꞌ squiiꞌ ayi rariaꞌh raꞌ ba stoꞌ bwiinn sidela ayi guinaaba duxa tu loh Dxiohs cun gucwaaꞌhan za tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ya gaduhbi nin caꞌnzanee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh nez guihdxyi xteenn Galilea rahbi Jesuhs loh raꞌ ba: ―Nahpa zutiꞌdxi raꞌ bwiinn duhlda naꞌh loh raꞌ nin rnabwaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nee chiinn raꞌ za ba naꞌh per chin dxiohnna dxyih zabahanahn loh guelguhchi. Ya chin bihn raꞌ xpwiinn Ñiꞌh dxyiꞌdxyi raꞌ chi guyuuꞌ nalaasa duxa stoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ya chin badzihnnee Jesuhs laꞌh gallee raꞌ xpwiinn Ñiꞌh guihdxyi Capernaum, riꞌchi gwagañiꞌ raꞌ nin ruteesa xmweeyi guidoꞌ loh Pehdru, ya gunaabadxyiꞌdxyi raꞌ ba loh Pehdru rahbi raꞌ ba: ―¿Xmwehsu luꞌh tayi rdxihlli ba xmweeyi guidoꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chiꞌchi rahbi Pehdru: ―Rdxihlli ban. Ya loh zeeyuuꞌtii Pehdru rwaaꞌ yuuꞌ mwergaloh guñiꞌ Jesuhs rahbi Ñiꞌh loh ba: ―¿Xi lligaaba ruhn luꞌh pur niꞌca Simohn? ¿Chyuloo rusadxihlli raꞌ rrehyi raꞌ nin riiꞌ loh guidxyiyuh; gu loh raꞌ lliiꞌn ba o loh raꞌ bwiinn ziitu raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chiꞌchi rahbi Pehdru: ―Loh raꞌ bwiinn ziitu raꞌ. Chiꞌchi rahbi Jesuhs: ―Pwihsi ziꞌchi za nin naa raꞌ lliiꞌn raꞌ ba ayi nahpa chilli raꞌ ba mweeyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","per tin ayi gasahcaloh nuꞌh bwiinn raꞌ ca gwah rwaaꞌ laguhn, ya riꞌchi balaꞌha answehlu ya mwerdoꞌtiiꞌ bwehlda nin guinaꞌzu luꞌh loh answehlu, rwaaꞌ ma guireꞌh tuhbi mweeyi; ya laꞌhchin chilli luꞌh para naꞌh nee cun xcweenta za luꞌh, ya chenee luꞌh mweeyi chi tin chilli luꞌh loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ya laꞌn dxyih gahca raꞌ chi gwabiiga raꞌ xpwiinn Ñiꞌh loh Ñiꞌh tin gunaabadxyiꞌdxyi raꞌ ba loh Jesuhs rahbi raꞌ ba: ―¿Chyu mahzi lasahca loh guelrnabwaꞌ xteenn Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ya chiꞌchi gucaꞌha Jesuhs tuhbi biñiꞌn gudiꞌdzi Ñiꞌh ya bazuh Ñiꞌh laꞌh bi galaayi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu sidela laꞌh tu ayi guchaꞌh tu loh xigaaba tu tin dxiaca naguꞌdzi lastoꞌ tu ziga naa lastoꞌ biñiꞌn riiꞌ, pwihsi ayi gaca chuꞌtii tu loh guelrnabwaꞌ xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nin mahzi lasahca loh guelrnabwaꞌ xteenn Dxiohs naa bwiinn nin rusaguuꞌdzi stoꞌ ñiꞌh loh Dxiohs laasii riahca ba ziga zi biñiꞌn riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ya bwiinn nin gucaꞌstoꞌ ñiꞌh laꞌh tuhbi biñiꞌn ziga biñiꞌn riiꞌ pur laan, neezaa naꞌh zucaꞌstoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Neezaa rahbi Ñiꞌh: ―Ya cuun chiꞌh zi nin guunn para dxiaaba tuhbi biñiꞌn biꞌtuꞌhn riiꞌ loh duhlda pur nin riachiistoꞌ raꞌ bi naꞌh, mas chaꞌyi guiyiꞌbi tuhbi dxiah rooꞌ nin rucadzii maan dohba yahnn bwiinn chi tin gulaꞌha raꞌ ba laꞌh ba loh ñihsadoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Gulguiaꞌhagah laꞌh tu bwiinn guidxyiyuh, laasii nuu nin rusiaaba laꞌh bwiinn loh duhlda! Nee Ayi dxiaꞌdxi nin guunn ziꞌca, per ¡prohbi za laꞌh bwiinn nin guunn pur chuu xtuhlda snuhn raꞌ bwiinn! ");
INSERT INTO zpvNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pwihsi niꞌchin sidela laꞌh naa luꞌh, o ñaaꞌ luꞌh gusiaaba yiꞌh loh duhlda, mas chaꞌyi guchyuuꞌga luꞌhn ya cuꞌbwih luꞌhn zihtu; mas chaꞌyi chuꞌtii luꞌh loh guelrnabwaꞌ xteenn Dxiohs nicala ayi tuhbi ñaaꞌ luꞌh o tuhbi llehcu luꞌh xlawaaꞌha zohba llehcu luꞌh cun ñaaꞌ luꞌh nin guunn chee luꞌh loh dxih par tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ya sidela neezaa bizloh luꞌh gusiaaba yiꞌh loh duhlda, mas chaꞌyi guleꞌhen bachiꞌh guluꞌbwihin zihtu nez ayi gwaꞌha ru luꞌhn; mas chaꞌyi chuꞌtii luꞌh loh guelnabahan nacuubi nin guniꞌhi Dxiohs cun tuhbi si bizloh luꞌh xlawaaꞌha cun garoopa bizloh luꞌh nin guunn guzaꞌhla yiꞌh loh bwehla duxa xteenn gabihldxyi. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Rahbi za Ñiꞌh: ―Pwihsi gulguiaꞌha gah tin ayi cweꞌhestoꞌ tu laꞌh raꞌ bwiinn nin naa ziga biñiꞌn biꞌtuꞌhn raꞌ riiꞌ, pwihsi rñiꞌn loh tu xaanjla raꞌ bi guillii-guillii riiꞌ raꞌ ba loh Xtaaꞌdahn nin nuu dxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","laasii laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw zeꞌ loh guidxyiyuh tin gutaꞌh Ñiꞌh laꞌh raꞌ bwiinn duhlda raꞌ nin bizaꞌbi loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Rahbi za Ñiꞌh: ―¿Xa lligaaba ruhnn tu sidela laꞌh tuhbi ndxiꞌhw nahpa tuhbi gaywaꞌh lliꞌhyi ya guizaꞌbi tuhbi ma? ¿Tayi cwachigah dxiꞌh ba za noventa y nueve ma loh dahan, bachiꞌh cheegadxiꞌhyi ba lliꞌhyi nin bizaꞌbi? ");
INSERT INTO zpvNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya sidela laꞌh ma gadxeela ma, rñiꞌn loh tu ¿tayi dxiahxinee ru dxiꞌh ba lliꞌhyi chi loh ziga za noventa y nueve ma? ");
INSERT INTO zpvNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pwihsi ziꞌchi za laꞌh Xtaada tu nin nuu dxibaaꞌ ayi xclaaꞌdzi ba guizaꞌbi nin tuhbi raꞌ nin naa biñiꞌn biꞌtiꞌhn raꞌ riiꞌ loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Rahbi za Ñiꞌh: ―Sidela laꞌh bwihtsi luꞌh ruñihchi loh luꞌh; guñiꞌnee bi yiꞌh si pur nin bwiꞌhnn bi, ya sidela laꞌh bi guzoꞌbadxiahga bi xchiꞌdxyi luꞌh, ba bwiꞌhnn luꞌh gahn bazoꞌbadxiahga bi xchiꞌdxyi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ya sidela laꞌh bi ayi guzoꞌbadxiahga bi xchiꞌdxyi luꞌh, gudihdxyi bi cun nee tuhbi o chiohpa bwiinn tin ziꞌchi garaa nin guiñiꞌ tu dxihn dxiahga raꞌ bwiinn chi tuhbi ba o chiohpa ba hasta chohnna ba, tin laꞌh raꞌ ba gaca ziga nin dxihn dxiahga garaa nin guiñiꞌ loh lasaaꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ya sidela laꞌh bi ayi guzoꞌbadxiahga gahca bi xchiꞌdxyi raꞌ bwiinn chi, gwaguihtsi luꞌh loh raꞌ bwiinn guidoꞌ xteenn Jesucristu; ya sidela laꞌh za bi ayi guzoꞌbadxiahga gahca bi xchiꞌdxyi raꞌ bwiinn guidoꞌ, ya chiꞌchi bwiꞌhnn laꞌhbi ziga zi tuhbi bwiinn ziitu nin ayi nuꞌnbwaꞌ xchiꞌdxyi Dxiohs, ziga tuhbi nin rteesa mweeyi xteenn Roma. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Pwihsi guchiin nin rñiꞌn loh tu garaa raꞌ xtuhlda bwiinn nin gusiaꞌlda stoꞌ tu loh guidxyiyuh riiꞌ, garaa za niꞌchi raꞌ zusiaꞌlda stoꞌ Dxiohs xcweenta raꞌ ba, ya duhlda raꞌ nin ayi dxiaꞌldastoꞌ tu loh guidxyiyuh riiꞌ ayi za chapitii raꞌn nez llaaꞌndxibaaꞌ loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ziꞌchi gahca za rñiꞌn loh tu, sidela laꞌh chiohpa tu cwih guunn tuhsi xigaaba loh guidxyiyuh riiꞌ tin cwidxyi-guinaaba tu nin guiclaaꞌdzi tu loh Xtaaꞌdahn nin nuu dxibaaꞌ zuniꞌhi Ñiꞌh nin guinaaba tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","laasii nez hasta cwih chiohpa o chohnna bwiinn nin riachiistoꞌ raꞌ ñiꞌh naꞌh riꞌchi laꞌn zuꞌh galaayi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ya chiꞌchi gwabiiga Pehdru loh Jesuhs tin gunaabadxyiꞌdxyi ba loh Ñiꞌh rahbi ba: ―Daada, ¿mas paaldaa bweelta guñihchi bwiꞌtsihn loon, ya chiꞌchi gusiaꞌldastoꞌn nin bwiꞌhnnee bi naꞌh? ¿Ta hasta gahdzi? ");
INSERT INTO zpvNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chiꞌchi rahbi Jesuhs loh Pehdru: ―Ayi gahdzi si dxiꞌh sino que hasta setenta bweelta gahdzi. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Laasii guelrnabwaꞌ xteenn Dxiohs naa ziga zi tuhbi rrehyi nin bwiꞌhnn cweenta balaaca nuzaꞌbi raꞌ xmooza ba loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Gueꞌdu guzoꞌbaloh guunn ba cweenta chin badzihnnee raꞌ ba tuhbi nin nuzaꞌbi ziahan miyohn loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ya laasii laꞌh mooza chi ayi nahpa ba mweeyi tin chiilli ba loh rrehyi chi, chiꞌchi gunabwaꞌ rrehyi chi tin gudooꞌ ba ziga zi tuhbi guidxaꞌh, cun nee xcunnaꞌh ba, cun garaa raꞌ lliiꞌn ba nee cun garaa za nin nahpa ba tin ziꞌchi gadxilli ba garaa nin nuzaꞌbi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ya chiꞌchi gwah mooza chi bazuꞌnllihbi ba loh rrehyi chi tin gunaaba duxa ba rahbi ba: “Daada, balahsa stoꞌ luꞌh naꞌh guleeza schiohpa-schoon dxyih zidxiillihn nin nuzaꞌbiꞌhn loh luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ya chiꞌchi balahsa stoꞌ rrehyi laꞌh mooza chi, pwihsi basiaꞌldastoꞌ ba nin nuzaꞌbi bwiinn chi loh ba ya bataꞌh ba laꞌh mooza chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","per chin guyaꞌloh bariaꞌh mooza chi rwaaꞌ yihdzi rrehyi, chiꞌchi badxiꞌloh ba stuhbi xmooza rrehyi, ya bwiinn chi nuzaꞌbi loh ba gulliaaꞌyiꞌhn mweeyi, ya gucaꞌha ba gunaꞌzu ba yahnn bwiinn chi guxiꞌ ban chiꞌchi rahbi ba loh bwiinn chi: “¡Gudxihlli loon nin nuzaꞌbi luꞌh!” ");
INSERT INTO zpvNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chiꞌchi gucaꞌha bwiinn chi bazuꞌnlihbi ba loh mooza chi rahbi ba: “¡Balahsastoꞌ luꞌh naꞌh, guleeza si chiohpa o hasta choon dxyih zidxihllihn loh luꞌh!” ");
INSERT INTO zpvNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ya cun ayi bihn ba dxyiꞌdxyi, cun gunaaba guxchisi ba laꞌh bwiinn chi tin bieꞌw ba laꞌn lahtsidxiꞌba tin gudxihlli ba nin nuzaꞌbi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pwihsi badiꞌhi duxa llahn laꞌh raꞌ snuhn xmooza rrehyi, ya gwaguihtsi raꞌ ba loh rrehyi garaa nin bwiꞌhnn mooza chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ya chiꞌchi gudihdxyi rrehyi laꞌh mooza chi ya rahbi rrehyi loh ba: “¡Mooza nin ayi galluꞌyitiiꞌ! Naꞌh basiaꞌldastoꞌn garaa nin nuzaꞌbi luꞌh loon. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pwihsi ziꞌchi za yiꞌh nahpa ñalahsastoꞌ luꞌh laꞌh bwiinn lasaaꞌ luꞌh ziga za balahsastoꞌn yiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ya loh nin bagaduhbi llahn duxa rrehyi chi lwehgu gunabwaꞌ ba laꞌh raꞌ xpwiinn ba tin basaꞌcazii raꞌ ba laꞌh mooza chi tin chiilli ba garaa nin nuzaꞌbi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chiꞌchi rahbi Jesuhs: ―Ziꞌchi za guunnee Xtaaꞌdahn nin nuu dxibaaꞌ laꞌh tu sidela laꞌh cada tuhbigah tu ayi gusiaꞌldastoꞌ tu xtuhlda raꞌ bwihtsi tu, per desde laꞌn lastoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ya guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi gunaꞌzu nehza Ñiꞌh zee Ñiꞌh loh guihdxyi raꞌ xteenn Galilea ya chin badzihn Ñiꞌh loh guihdxyi raꞌ xteenn Judea nin riaꞌhan nez lahdu rtahn gubihdxyi xteenn guiꞌw Jordahn, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ziahan bwiinn gwanaꞌhla laꞌh Ñiꞌh, riꞌchi basiaca Ñiꞌh laꞌh raꞌ bwiinn dxyihdxyi raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ya chiꞌchi gwabiiga raꞌ paaldaa raꞌ bwiinn fariseu raꞌ hasta zuu Jesuhs, ya ziga nuu raꞌ ba lligaaba gwaꞌha raꞌ ba ta zahca gusiaꞌgarii Ñiꞌh xchiꞌdxyi raꞌ ba, niꞌchin gunaaba dxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Ta rusaaꞌn lehyi taaꞌha bwiinn cheꞌhla ba pur xiilla si tuhbi llahniꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta nagahdxi guꞌlda tu loh Xchihtsi Dxiohs hasta rñiꞌ ziga gulahchixchih Dxiohs laꞌh ndxiꞌhw cun gunnaꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Niꞌchin rahbi Ñiꞌh: “Ndxiꞌhw nahpa rreꞌcaa ba loh xpaah ba cun loh xmaah ba tin ziꞌchi rcaꞌha ba laꞌh gunnaꞌh nin raaca cheꞌhla ba, ya garoopa raꞌ ba naa raꞌ ba tuhbi si bwiinn.” ");
INSERT INTO zpvNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pwihsi ya ziꞌchi ayi ru naa raꞌ ba chiohpa bwiinn sino que tuhbi si bwiinn. Pwihsi niꞌchin nin ayi nuu taaꞌha bwiinn cheꞌhla ba laasii Dxiohs bachiꞌdxiu-bachaꞌga laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chiꞌchi gunaabadxyiꞌdxyi raꞌ ba stuhbi loh Jesuhs rahbi raꞌ ba: ―¿Xixnaa chiꞌh basiaꞌhannee guehtu Moisehs dxihtsi laꞌh nu: “Cun gudiꞌhi ndxiꞌhw tuhbi dxihtsi laꞌh xcunnaꞌh ba, bachiꞌh ziꞌchi ba guruuꞌn lasaaꞌ raꞌ ba”? ");
INSERT INTO zpvNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laasii dxiꞌbi dxiipa stoꞌ tu niꞌchin nin basaaꞌn guehtu Moisehs taaꞌha tu cheꞌhla tu, per galoh ayi guhca ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya naꞌh rñiꞌn loh tu chyu chiꞌh zi bwiinn nin guilaaꞌha cheꞌhla ñiꞌh sidela ayi xi guelgubwihlli bwiꞌhnn cheꞌhla ba, nee guicaꞌha ba stuhbi gunnaꞌh bwiinn chi rguꞌtii ba duhlda, ziꞌchi za ndxiꞌhw nin guicaꞌha gunnaꞌh nin ba bilaaꞌha cheꞌhla ñiꞌh rguꞌtii za ba duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ya chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh: ―Sidela laꞌh deeꞌ naa nin caa loh xchiꞌdxyi Dxiohs pur xcwenta tuhbi ndxiꞌhw cun cheꞌhla ba, ayi naa bwen guicaꞌha lasaaꞌ raꞌ ba tin guchinaa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ayi garaa dxiꞌh tu gacabwaꞌ tu dxyiꞌdxyi raꞌ riiꞌ sino que laꞌh dxiꞌh raꞌ nin badiꞌhi Dxiohs lligaaba zaꞌca yihca raꞌ ñiꞌh niꞌchi si raꞌ naa nin rahcabwaꞌ raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pwihsi nuu raꞌ ziga bwiinn raꞌ nin ayi guchinaa raꞌ, bwiinn chi naa guulaa raꞌ ba, ya nuu raꞌ ba rahca raꞌ ba ziga bwiinn nin ayi rchinaa laasii lasaaꞌ bwiinngahca raꞌ ba ruhnn capohn laꞌh raꞌ ba, ya nuu raꞌ ba ayi rchinaa raꞌ ba laasii xclaaꞌdzi raꞌ ba guunn si raꞌ ba xtsiꞌn Dxiohs; niꞌchin bwiinn nin gaca guunn ziga naa dxyiꞌdxyi raꞌ riiꞌ guunn ban. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ya gwanee raꞌ bwiinn laꞌh raꞌ biñiꞌn tin gudziiꞌba naa Jesuhs yihca raꞌ bi, neezaa tin cwidxyi-guinaaba Ñiꞌh loh Dxiohs pur laꞌh raꞌ bi; ya laꞌh raꞌ xpwiinn Ñiꞌh bwiꞌhnn ñaꞌlaaꞌdzi raꞌ ba loh raꞌ bwiinn raꞌ nin zenee raꞌ biñiꞌn hasta zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ya chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Gulgasaaꞌn dxieꞌbiiga raꞌ biñiꞌn raꞌ ca hasta zuꞌhn, ayi gucweꞌza tu laꞌh raꞌ bi, laasii loh xquelrnabwaꞌ Dxiohs naa xteenn raꞌ bwiinn nadoꞌlaaꞌdzi nin naa ziga laꞌh raꞌ biñiꞌn raꞌ ca. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ya chin guyaꞌloh badziiꞌba naa Ñiꞌh yihca raꞌ biñiꞌn, lwehgu babii Ñiꞌh riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ya chiꞌchi badzihn tuhbi biꞌnxtuhbi hasta zuu Jesuhs ya rahbi bi loh Ñiꞌh: ―Daada, mwehsu chaꞌyi: ¿Xa niꞌca nahpa guꞌnnahn tin guziaaꞌhahn dxibaaꞌ guibahaneꞌhn Dxiohs par tuꞌpazi chin gachiꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chiꞌchi rahbi Jesuhs loh bi: ―¿Xixnaa rñiꞌ luꞌh naꞌh chaꞌyiꞌhn? Ayi nin tuhbi bwiinn nin naa chaꞌyi, sola tuhbi dxiꞌh Dxiohs; ya sidela yiꞌh xclaaꞌdzi luꞌh guibahanee luꞌh Dxiohs llaaꞌndxibaaꞌ, bazoꞌbadxiahga xchiꞌdxyi Dxiohs nin caa loh xlehyi Moisehs. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chiꞌchi rahbi bi: ―¿Ziga cuun raꞌ dxyiꞌdxyi? Ya chiꞌchi rahbi Jesuhs: ―Ayi chiinn luꞌh bwiinn, ayi gaca za luꞌh bwiinn gubwihlli, ayi cwaan luꞌh, ayi chiꞌnlaaꞌdzi luꞌh dxixiꞌhw, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nee gaca nadziiꞌhi za luꞌh xcuzahn luꞌh, nee gaca nadziiꞌhi za luꞌh bwiinn lasaaꞌ raꞌ luꞌh ziga nadziiꞌhi gahca za luꞌh yiꞌh gaca. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chiꞌchi rahbi biꞌnxtuhbi chi: ―Garaatiiꞌ dxyiꞌdxyi raꞌ ca cagazoꞌbadxiaagahñin desde biñiꞌnaꞌhn: ¿Cuunn xchiꞌh niꞌca nin cayaꞌdxi? ―rahbi bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chiꞌchi rahbi Jesuhs: ―Sidela yiꞌh xclaaꞌdzi luꞌh gaca luꞌh bwiinn zaꞌca nin ayi xi xcweenta ñiꞌh dxiaꞌdxi loh Dxiohs, gucaꞌha garaa xixteenn luꞌh nin nahpa luꞌh batooꞌ raꞌn, bachiꞌh chiꞌzi luꞌh mweeyi chi guicaꞌha raꞌ bwiinn prohbi nin ayi xi nahpa, tin ziꞌchi zicaꞌha luꞌh guelnazaꞌca nin nuu llaaꞌndxibaaꞌ, ya chiꞌchi bachiꞌh gudaꞌnaꞌhla naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ya chin bihn biꞌnxtuhbi chi dxyiꞌdxyi raꞌ nin guñiꞌ Jesuhs loh bi, guhca nalaasa stoꞌ bi laasii rricu bi, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, nagahn duxa chuꞌtii tuhbi bwiinn rricu loh xquelrnabwaꞌ Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","pwihsi rñiꞌn loh tu stuhbi, ayi guinagahn ru tiidxi tuhbi camehyu llaaꞌn tuhbi guihchiguulla que ziga tiidxi tuhbi bwiinn rricu loh guelrnabwaꞌ xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ya chin bihn raꞌ xpwiinn Ñiꞌh dxyiꞌdxyi raꞌ nin guñiꞌ Ñiꞌh, badxyigaaꞌ duxa raꞌ ba pur dxyiꞌdxyi raꞌ chi, ya chiꞌchi rahbi raꞌ ba: ―¿Pwihsi chyuulla taꞌh chiꞌh loh duhlda? ");
INSERT INTO zpvNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chiꞌchi bwaꞌha dziꞌtsi Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―Para bwiinn raꞌ, nagahn raꞌ deeꞌ; per ayi nee dxiꞌh para laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Daada, laꞌh nu dxugasaaꞌn garaa nin nadxiapa nu tin dxioꞌpanaꞌhla nu Yuꞌbiluꞌh; ¿cuun xchiꞌh nin gachicaꞌha nu? ");
INSERT INTO zpvNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Chiꞌchi rahbi Jesuhs: ―Pwihsi guchiinn nin rñiꞌn loh tu xpwiiꞌnn raꞌn nin zeꞌnaꞌhla raꞌ naꞌh, chin gusacuubi Lliiꞌn Dxiohs nin naa ndxiꞌhw garaa raꞌ cohsa chin soobaa ba loh yagaxiiyi llaaꞌndxibaaꞌ, neezaa laꞌh tu ziga naa tu xpwiiꞌnahn soobaa za tu loh gadziꞌh bichiohpa yahgaxiiyi nin zuu llaaꞌndxibaaꞌ tin guunn tu guelguxchisi loh gadziꞌh bichiohpa xjwamihyi Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ya garaa raꞌ nin rigasaaꞌn yihdzi raꞌ ñiꞌh pur naꞌh, bwihtsi raꞌ ñiꞌh, bizaaꞌn raꞌ ñiꞌh, xtaada raꞌ ñiꞌh cun xmaah raꞌ ñiꞌh, lliiꞌn raꞌ ñiꞌh, loh xuh raꞌ ñiꞌh; zicaꞌha raꞌ ba garaa raꞌ niꞌchi stuhbi gaywaꞌh bwelta mahzi ru, nee neezaa guicaꞌha raꞌ ba guelnabahan nacuubi nin ayi ñichilohtiiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","per nnah garaa raꞌ bwiinn raꞌ nin ruhnn raꞌ lligaaba lasahca raꞌ ba nnah, niꞌchi raꞌ nin ayi gaca lasahca chiꞌchi, ya nin ayi lasahca nnah niꞌchi raꞌ gaca lasahca chiꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Rahbi za Jesuhs: ―Guelrnabwaꞌ xteenn Dxiohs naa ziga tuhbi ballwaaꞌn nin nahpa taayii loh yuh, ya biriaꞌh ba zee chiꞌhyi ba mooza raꞌ rsiiyi gah tin guunn raꞌ mooza raꞌ chi xtsiꞌn ba hasta nahpa ba yahga uhva raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ya chin biaꞌhannee dxyiꞌdxyi ba laꞌh raꞌ mooza chi balaaca chiilli ba laꞌh raꞌ ba, chiꞌchi guxeꞌhla ba laꞌh mooza raꞌ chi loh xtahan ba tin zeeguiꞌhnn raꞌ ba dziꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ya hohra chi biriaꞌh laꞌgaꞌh ba ziga chiꞌh xcagaꞌ rsiiyi, ya loh dxiaaꞌ chi bwaꞌha ba spaaldaa raꞌ mooza rii zi ayi xi dziꞌn nahpa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","chiꞌchi rahbi ballwaaꞌn chi loh raꞌ mooza raꞌ chi: “Neezaa laꞌh tu gulcheguiꞌhnn xtsiꞌnaꞌhn ya zidxiillihn laꞌh tu ziga naa bwen guunn tu gahn.” Ya chiꞌchi zee raꞌ chi mooza raꞌ chi loh xtahan ballwaaꞌn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ya ziga chiꞌh lahyidxyih biriaꞌh ba stuhbi, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","cun neezaa mahzi ru gudxyih gwah ba, cun neezaa ziga chiꞌh xcagaꞌyu gudxyih gwah ba stuhbi loh dxiaaꞌ chi ya hohra chi bidxeela ba spaaldaa mooza raꞌ nin ayi xi dziꞌn cayuhnn raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","chiꞌchi rahbi ba loh raꞌ mooza raꞌ chi: “¿Xixnaa rii tu riiꞌ laꞌh tu gaduhbi dxyih nee ayi xi dziꞌn riiyuhnn tu?” Chiꞌchi rahbi raꞌ mooza raꞌ chi: “Laasii ayi chyu bwiinn runiꞌhi dziꞌn guidiꞌhnn nu.” Chiꞌchi rahbi ballwaaꞌn chi: “Gulcheh neezaa tu loh xuun tin guunn za tu dziꞌn riꞌchi.” ");
INSERT INTO zpvNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ya chin gurih gueꞌla, chiꞌchi rahbi ballwaaꞌn chi loh xmooza ba nin rnabwaꞌ loh raꞌ snuhn raꞌ mooza: “Babwihdxyi garaa raꞌ mooza, tin gudxihlli laꞌh raꞌ ba, ya guzoꞌbaloh gudxihlli laꞌh raꞌ bwiinn nin luulchima guyuuꞌtii loh dziꞌn cun ya ziꞌchi guzaꞌloh luꞌh chiilli luꞌh laꞌh raꞌ bwiinn raꞌ nin mwer guyuuꞌtii raꞌ loh dziꞌn.” ");
INSERT INTO zpvNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pwihsi lwehgu gwabiiga raꞌ mooza raꞌ nin guyuuꞌtii loh dziꞌn ziga chiꞌh xcagaꞌyu gudxyih ya garaa raꞌ mooza raꞌ chi guhlla raꞌ ba ziga chiꞌh ruhnn mooza gahn tuhbi dxyih, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ya chin bigaꞌha hohra nin gahlla raꞌ mooza raꞌ nin bwiꞌhnn dziꞌn gaduhbi dxyih, bwiꞌhnn raꞌ ba lligaaba guyahlli ru ñahlla raꞌ ba; per neezaa cada tuhbigah raꞌ ba guhlla raꞌ ba ziꞌchi gahca xcweenta nin bwiꞌhnn raꞌ ba dziꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ya chin guzoꞌbaloh cayahlla raꞌ ba chiꞌchi guzoꞌbaloh cadxyiꞌchinee raꞌ ba laꞌh ballwaaꞌn chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","rahbi raꞌ ba: “Mooza raꞌ nin mwer guhlla raꞌ tuhbi si hohra bwiꞌhnn raꞌ ba dziꞌn nee ziga gahca cayahlla nu nnah gudxihlli luꞌh laꞌh raꞌ ba, nee laꞌh nu mahzi ru batiꞌdxiloh nu loh gubihdxyildaꞌh nee bidiꞌhnn ru za nu dziꞌn que laꞌh raꞌ ba loh gaduhbi dxyih.” ");
INSERT INTO zpvNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ya chiꞌchi rahbi ballwaaꞌn chi loh raꞌ ba: “Mihgu raꞌ, ayi xi mweeyi cagasiaꞌpitiiꞌhihn yihca xchiꞌh tu. ¿Tayi ya biaꞌhan dxiꞌh nuꞌh balaaca gahlla tu tuhbi dxyih? ");
INSERT INTO zpvNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pwihsi laꞌh xmweeyi tu chiꞌh deeꞌ tin guldxiaa, laasii naꞌh xclaaꞌdzihn chiillihn laꞌh raꞌ mooza nin luulchima guyuuꞌtii loh dziꞌn ziga gudxiillihn laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","laasii naꞌh rnabwaꞌn xmweeꞌyihn, o ¿gu rdxyiꞌchinee tu naꞌh pur nin naan bwiinn zaꞌca?” ");
INSERT INTO zpvNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Niꞌchin nnah nin naa raꞌ luulchimatiiꞌ gaca nin naa mwergaloh; ya nin naa raꞌ mwergaloh nnah niꞌchi gaca luulchimatiiꞌ raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ya loh nin zeezah Jesuhs loh neziuh para guihdxyi Jerusalehn, gudihdxyi Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh cweeꞌ zi neziuh tin rahbi Ñiꞌh loh raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Pwihsi ziga rwaꞌha tu nnah, zoo nuꞌh par loh guihdxyi Jerusalehn hasta gutiꞌdxi raꞌ bwiinn naꞌh nin naan Lliiꞌn Dxiohs nin naa ndxiꞌhw tin gacaꞌhn ntriehgu loh raꞌ bwiinn nin rnabwaꞌ raꞌ loh raꞌ bixohza raꞌ cun loh raꞌ mwehsu raꞌ nin ruluuꞌyi raꞌ xlehyi Moisehs, niꞌchi raꞌ guinaaba gachiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ya gutiꞌdxi raꞌ ba naꞌh loh raꞌ bwiinn ziitu tin gullihdzinee raꞌ ba naꞌh, nee neezaa gucaꞌyahga raꞌ ba naꞌh cun cwarta, cun gucaꞌh za raꞌ ba naꞌh loh cruhzi; per chin dxiohnna dxyih zabaanahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ya chiꞌchi gwabiiga xnaan lliiꞌn Zebedeu tuhsi junta cun garoopa lliiꞌn ba gwabiiga raꞌ ba hasta zuu Jesuhs, ya bazuꞌnllihbi raꞌ ba loh Ñiꞌh tin gunaaba raꞌ ba tuhbi bweniꞌhn loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","chiꞌchi rahbi Jesuhs loh xnaan raꞌ bi: ―¿Xi niꞌca xclaaꞌdzi luꞌh? Chiꞌchi rahbi naaniꞌhn chi: ―Gunabwaꞌ loh xquelrnabwaꞌ luꞌh tin soobaa tuhbi lliiꞌnahn xlahdu derehchu luꞌh stuhbi bi xlahdu rrabwehsa luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chiꞌchi rahbi Jesuhs: ―Laꞌh tu nin ayi gaann tu xiñin rdxiꞌhn tu; ¿ta ruhnn tu lligaaba zuhnn tu gahn gutiꞌdxiloh tu loh guelrzaꞌcazii nin gutiꞌdxiloon? Chiꞌchi rahbi raꞌ ba: ―Zidiꞌhnn nu gahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh tu zuhnn tu gahn gutiꞌdxiloh tu guelrzaꞌcazii riiꞌ, per ziga rnaaba tu soobaa tu xlahdu derehchuꞌhn o xlahdu rrabwehsaꞌhn, ayi naꞌh dxiꞌh naꞌpahn guelrnabwaꞌ tin guniꞌhiñin laꞌh tu, sino que laꞌh raꞌ bwiinn raꞌ nin guliila Xtaaꞌdahn nin nuu dxibaaꞌ laꞌh raꞌ ba guicaꞌha raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ya chin bihn raꞌ za tsiꞌh xpwiinn Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ bidxyiꞌchinee raꞌ ba laꞌh raꞌ garoopa bwihtsi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ya chiꞌchi gudihdxyi Jesuhs laꞌh raꞌ ba tin rahbi Ñiꞌh loh raꞌ ba: ―Pwihsi laꞌh tu naann tu, loh raꞌ nin rnabwaꞌ raꞌ rnabwaꞌ raꞌ ba ziga chiꞌh zi naa xigaaba raꞌ ba, ya nin naa ziga bwiinn lasahca raꞌ loh raꞌ ba, ruhnnee raꞌ ba laꞌh raꞌ ba ziga chiꞌh zi nin xclaaꞌdzi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","per laꞌh tu ayi ziꞌchi dxiꞌh gaca tu; mas chaꞌyi guunn bwiinn nin xclaaꞌdzi gaca lasahca loh tu, ziga tuhbi mooza zi, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nee bwiinn nin xclaaꞌdzi gaca mwergaloh loh tu nahpa gaca ba ziga mooza nin gulliaꞌyiꞌhn ru lasahca loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","laasii laꞌh Lliiꞌn Dxiohs ayi biꞌ Ñiꞌh tin gaca tu mooza loh Ñiꞌh, sino que laꞌh Ñiꞌh biꞌ Ñiꞌh tin gaca Ñiꞌh mooza loh garaatiiꞌ bwiinn nee tin cun tihxi za Ñiꞌh chiilli Ñiꞌh xtuhlda raꞌ ziahan raꞌ bwiinn nin taꞌh loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ya loh nin bariaꞌh Jesuhs guihdxyi Jericoh, ziahan bwiinn gwanaꞌhla laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ya rwaaꞌ neziuh chi zohba chiohpa bwiinn nin ayi riin loh Ñiꞌh, ya chin bihn raꞌ ba zeediiꞌdxi Jesuhs riꞌchi, chiꞌchi guñiꞌ raꞌ ba jwersirooꞌ rahbi raꞌ ba: ―¡Jesuhs Lliiꞌn guehtu Davihd, balahsastoꞌ luꞌh laꞌh nu! ");
INSERT INTO zpvNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ya bidxyiꞌchi raꞌ bwiinn rahbi raꞌ ba: ―¡Guldxiahcadxyii! Per laꞌh raꞌ ba mahzi ru jweersi rooꞌ rbwihdxyidxiah raꞌ ba: ―¡Lliiꞌn guehtu Davihd, balasastoꞌ luꞌh laꞌh nu! ");
INSERT INTO zpvNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chiꞌchi guzuhdxyiigah Jesuhs, chiꞌchi gunabwaꞌ Ñiꞌh gwacaꞌha raꞌ ba laꞌh raꞌ bwiinn chi, ya chin badzihn raꞌ ba hasta zuu Jesuhs, chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh loh raꞌ ba rahbi Ñiꞌh: ―¿Xiniꞌca xclaaꞌdzi tu guꞌnnahn pur laꞌh tu? ");
INSERT INTO zpvNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chiꞌchi rahbi raꞌ bwiinn nin rahca loh raꞌ ñiꞌh chi: ―Daada, xclaaꞌdzi nu guidiaꞌha nu. ");
INSERT INTO zpvNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chiꞌchi balahsastoꞌ Jesuhs laꞌh raꞌ ba, ya bidxiꞌ Ñiꞌh loh raꞌ ba ya hohra chi gahca ballaala loh raꞌ ba, ya seguihdu zeenaꞌhla raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ya chin zeegadzihn gahxuꞌhn raꞌ ba guihdxyi Jerusalehn, badzihn raꞌ ba tuhbi guihdxyi biꞌtuꞌhn nin laa Betfageh, cweeꞌ dahan nin laa Olivo, riꞌchi guxeꞌhla Jesuhs laꞌh chiohpa xpwiinn Ñiꞌh ");
INSERT INTO zpvNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","rahbi Ñiꞌh loh raꞌ ba: ―Gulcheh loh rrandxu nin naa gahxu neziiꞌ, riꞌchi zwaꞌha tu caduꞌh tuhbi buhrra cun lliiꞌn ma. Ya gulgaxachi ma tin dxieꞌnee tu ma, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ya sidela chyulla guinaabadxyiꞌdxyi loh tu: “¿Xixnaa cagaxachi tu buhrra ca?”, gulgahbi loh ba: “Tuhbi Daada nin mahzi rnabwaꞌ cachiꞌhn laꞌh ma tin tsiiba ba ma”, ya seguihdu gahca zusaaꞌn raꞌ ba dxieꞌnee tu ma. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dee guhcan tin guzohba dxyiꞌdxyi raꞌ nin bacaꞌh tuhbi guehtu daada nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih chin bacaꞌh ba squiiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gulgahbi loh raꞌ bwiinn guihdxyi Siohn: “Bwaꞌha, laꞌh xrrehyi luꞌh zeꞌ nez loh tu ziga zi tuhbi bwiinn nadoꞌlaaꞌdzi, dziꞌba ba tuhbi buhrriꞌhn, lliiꞌn tuhbi maan nin ruhnn dziꞌn.” ");
INSERT INTO zpvNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ya gwah raꞌ xpwiinn Jesuhs tin bwiꞌhnn raꞌ ba ziga guhdzi Jesuhs loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ya gwanee raꞌ ba buhrra chi cun lliiꞌniꞌhn ma hasta zuu Jesuhs, chiꞌchi badziiꞌba raꞌ ba xahba raꞌ ba dihtsi ma tin loh lahdxi chi guzohba Ñiꞌh dihtsi ma, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ya ziahan duxa raꞌ bwiinn rii riꞌchi ya loh neziuh hasta zeediiꞌdxinee buhrriꞌhn chi laꞌh Ñiꞌh gudxyihxi raꞌ ba xahba raꞌ ba, ya snuhn raꞌ ba gudxyihxi lliiꞌdzi yahga raꞌ nez zeediiꞌdxi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ya bwiinn raꞌ nin zee ñiidxiuu loh Jesuhs cun bwiinn raꞌ nin zeꞌnaꞌhla nez dihtsi Ñiꞌh rahbi raꞌ ba: ―¡Bwiꞌhnntaaꞌyi Dxiohs yihca rrehyi lliiꞌn Davihd! ¡Lasahca duxa naa nin zeꞌ pur xcweenta Yuꞌbi Dxiohs! ¡Rachiñiꞌ zaꞌca duxa nuꞌh pur xcweenta Dxiohs nin nuu dxibaaꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ya chin guyuuꞌtii Jesuhs guihdxyi Jerusalehn garaa raꞌ bwiinn Jerusalehn chi badxyigaaꞌ duxa loh raꞌ ba, ya ziahan duxa raꞌ ba rahbi loh lasaaꞌ raꞌ ba: ―¿Chyu niꞌca? ");
INSERT INTO zpvNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ya snuhn raꞌ bwiinn rahbi raꞌ ba: ―Laꞌh ba nin naa Jesuhs, ndxiꞌhw nin ruluuꞌyi xchiꞌdxyi Dxiohs nin zeꞌ nez guihdxyi Nazaret xteenn Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ya chin guyuuꞌtii Jesuhs laꞌn guidoꞌ rooꞌ, babweꞌhedxiaꞌhla Ñiꞌh laꞌh raꞌ garaatiiꞌ raꞌ bwiinn raꞌ nin ruhnn guriꞌxi cun nin riiziꞌ raꞌ xica laꞌn guidoꞌ, cun badiꞌxi za Ñiꞌh xmweella raꞌ bwiinn raꞌ nin ruchaꞌh raꞌ xmweeyi raꞌ bwiinn, cun neezaa babweꞌhe Ñiꞌh laꞌh raꞌ bwiinn raꞌ nin riigatooꞌ palohma raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ya chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Loh Xchihtsi Dxiohs rñiꞌ: “Yiidzihn gaca hasta cwidxyi-guinaaba tu naꞌh”, per laꞌh tu cayuhnn tun ziga zi tuhbi cwehva hasta riuuꞌ raꞌ gubaꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ya neezaa gwabiiga raꞌ bwiinn raꞌ nin rahca ñaaꞌ raꞌ ñiꞌh cun bwiinn raꞌ nin rahca loh raꞌ ñiꞌh hasta zuu Jesuhs ya basiaca Ñiꞌh laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","per chin bwaꞌha raꞌ bwiinn nin rnabwaꞌ laꞌh raꞌ bixohza raꞌ cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs dziꞌn rooꞌ raꞌ nin cayuhnn Jesuhs, nee neezaa bihn raꞌ ba riibwihdxyidxiah raꞌ biñiꞌn laꞌn guidoꞌ squiiꞌ: “¡Bwiꞌhnntaaꞌyi Dxiohs yihca lliiꞌn guehtu Davihd!”, chiꞌchi mahzi ru bidxyiꞌchi duxa raꞌ ba ");
INSERT INTO zpvNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ya rahbi raꞌ ba loh Jesuhs: ―¿Gu rihn luꞌh nin riiñiꞌ raꞌ niꞌca raꞌ? Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌn rihn, per ¿ta nagahdxi guꞌlda tu loh Xchihtsi Dxiohs hasta rñiꞌ squiiꞌ: “Cun xchiꞌdxyi raꞌn nin ruꞌlda raꞌ biñiꞌniꞌhn raꞌ cun bweeꞌzuꞌhn raꞌ nin reeꞌ duuda guluuꞌyi Luꞌh balaaca guelrnabwaꞌ nin nahpa Luꞌh.”? ");
INSERT INTO zpvNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ya chiꞌchi basiaꞌhangah Ñiꞌh laꞌh raꞌ ba riꞌchi, chiꞌchi gunaꞌzu nehza Ñiꞌh para guihdxyi Betania; riꞌchi batiꞌdxi gueꞌla Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ya tuhbi rsiiyi chin gubiaꞌgarii Jesuhs loh guihdxyi Jerusalehn, bieꞌsuh bichiaꞌhan Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ya cweeꞌ neziuh bwaꞌha Ñiꞌh zohba tuhbi llaaꞌn yahga ñiigu ya gwabiigagah Ñiꞌh cweeꞌhen, per ganaalla batahga caa loh yahga chi, ya chiꞌchi rahbi Ñiꞌh loh yahga chi: ―Nin stuhbi ayi ru guibiaꞌgarii guicah ñinahxi loh luꞌh. Ya hohra chi gahca gubihdzi yahga ñiigu chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ya chin bwaꞌha raꞌ xpwiinn Ñiꞌh nin guhca riꞌchi badxyigaaꞌ duxa loh raꞌ ba ya gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Xa guhca xinaa gubihdzi yahga ñiigu ca lwehgu gahca? ");
INSERT INTO zpvNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu sidela laꞌh tu riachiistoꞌ tu xchiꞌdxyi Dxiohs nee ayi guunn chiohpa stoꞌ tu, ayi nin bwiꞌhnn si dxiꞌhn cun yahga ñiigu riiꞌ gaca guunn tu sino que neezaa loh tuhbi dahan gahbi tu: “Biyaꞌdxu riꞌca tin balaꞌha yiꞌh loh ñihsadoꞌ”, zahca gacan, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ya garaa raꞌ nin guinaaba tu loh Dxiohs chin cwidxyi-guinaaba tu Ñiꞌh, gaduhbi stoꞌ tu gulchechii stoꞌ tu, tin ziꞌchi zicaꞌha tu nin guinaaba tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ya chin guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi riiꞌ, chiꞌchi guyuuꞌtii Ñiꞌh laꞌn guidoꞌ rooꞌ, ya gaduhbi nin nuu Ñiꞌh laꞌn guidoꞌ rooꞌ chi chiꞌchi gwabiiga raꞌ bwiinn nin rnabwaꞌ laꞌh raꞌ bixohza cun bwiinn guuhla raꞌ xteenn bwiinn Israel raꞌ hasta zuu Jesuhs, ya gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Cun chyu xquelrnabwaꞌ cayuhnn luꞌh niꞌca raꞌ? ¿Chyu baniꞌhi guelrnabwaꞌ ca yiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Neezaa naꞌh guinaꞌbadxyiꞌdxyiꞌhn tuhbi dxyiꞌdxyi loh tu: ¿Chyu guxeꞌhla laꞌh Jwahn bieꞌgaroꞌbañihsa ba? ¿Ta Dxiohs guxeꞌhla laꞌh ba o tuhbi bwiinn zi? Sidela laꞌh tu chixteeꞌ tu loon guelgunabadxyiꞌdxyi riiꞌ, neezaa naꞌh zidxixteeꞌhehn loh tu cun chyu xquelrnabwaꞌ ruhnn raꞌn garaa raꞌ dziꞌn raꞌ riiꞌ. Ya hohra chi guzoꞌbaloh canaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba rahbi raꞌ ba: ―Sidela laꞌh nuꞌh guidiꞌtsi nuꞌh: “Dxiohs guxeꞌhla laꞌh Jwahn”, chiꞌchi nnaa ba loh nuꞌh: “¿Xixnaa chiꞌh ayi bazoꞌbadxiahga tu xchiꞌdxyi ba?”, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","nee ayi za nuu guidiꞌtsi nuꞌh: “Tuhbi bwiinn zi guxeꞌhla laꞌh Jwahn”, laasii rdxyihbi nuꞌh laꞌh raꞌ bwiinn guihdxyi, laasii garaa raꞌ ba nahpa raꞌ ba laꞌh Jwahn ziga daada nin rñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Niꞌchin rahbi raꞌ ba: ―Ayi chyu gaann chyu guxeꞌhla laꞌh Jwahn. Pwihsi chiꞌchi rahbi za Ñiꞌh: ―Ayi za chixteeꞌhehn loh tu chyu guxeꞌhla naꞌh cayuꞌnnahn dziꞌn raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ya chiꞌchi gunaabadxyiꞌdxyi Jesuhs rahbi Ñiꞌh: ―¿Xi lligaaba ruhnn tu pur dxyiꞌdxyi raꞌ riiꞌ? Tuhbi ndxiꞌhw guyuuꞌ chiohpa lliiꞌngaꞌn ba, ya rahbi ba loh nin naa lliiꞌn galoh ba: “Xiiꞌhihn, gwaguiꞌhnn dziꞌn loh xuun hasta rii raꞌ yahga uhva raꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chiꞌchi rahbi lliiꞌn ba loh ba: “¡Ayi chaaꞌhahn!”, per ya loh zuu gahca bi bwiꞌhnn bi lligaaba gwah bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ya chiꞌchi gwagañiꞌ ba loh stuhbi lliiꞌn ba, ya ziꞌchi gahca rahbi ba loh bi, ya rahbi bi loh ba: “Yoo, daada; laꞌn chaaꞌha”, per ayi gwah bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ya loh garoopa bi, ¿cuun tuhbi bi nin bazoꞌbadxiahga xchiꞌdxyi xpaah raꞌ bi? Chiꞌchi rahbi raꞌ ba: ―Nin mwer guñiꞌ ba loh ñiꞌh. Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, laꞌh raꞌ bwiinn raꞌ nin ruteesa xmweeyi Roma cun gunnaꞌh dxaaba raꞌ laꞌguñiidxiuu raꞌ guyuuꞌtii loh guelrnabwaꞌ xteenn Dxiohs que laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","laasii laꞌh Jwahn nin baroꞌbañihsa bieꞌgaluuꞌyi laꞌh tu xa nahpa guibahan tu, per laꞌh tu ayi gwachiistoꞌ tu laꞌh Jwahn; per laꞌh raꞌ bwiinn nin ruteesa mweeyi cun gunnaꞌh dxaaba raꞌ gwachiistoꞌ raꞌ ba xchiꞌdxyi Jwahn. Per laꞌh tu nicala bihn tu dxyiꞌdxyi raꞌ riiꞌ ayi bachaꞌh tu xigaaba tu tin ñachiistoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Gulgacaꞌdxiahga stuhbi cweenta riiꞌ: Tuhbi ballwaaꞌn xteenn taayii loh yuh bwiꞌhnn biñih ba yahga uhva raꞌ, ya bwiꞌhnn ban leeꞌ neezaa gudaꞌhn ba tuhbi guiiꞌdxyu tin guhcan hasta guxiꞌh ba uhva raꞌ; neezaa bwiꞌhnn ba tuhbi torre loh xuh ba, chiꞌchi badiꞌhi ba loh xuh ba garoolda laꞌh raꞌ bwiinn raꞌ nin ruhnn dziꞌn, zee chiꞌh ba zihtu. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ya chin bigaꞌha dxyih nin gabweꞌhe raꞌ ba xliꞌhn raꞌ ba, chiꞌchi guxeꞌhla ballwaaꞌn chi paaldaa raꞌ xmooza ba tin zeegalliꞌhi raꞌ ba liꞌhn nin guicaꞌha ba loh raꞌ bwiinn raꞌ nin guuꞌn loh xuh ba garoolda, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","per laꞌh raꞌ bwiinn raꞌ chi xlawaaꞌha ñudiꞌhi raꞌ ba liꞌhn nin ñicaꞌha ballwaaꞌn chi laꞌlaꞌgaꞌh gunaꞌzu raꞌ ba laꞌh raꞌ xmooza ba gudxiꞌldxyihdxyi raꞌ ba paaldaa raꞌ ba ya spaaldaa raꞌ ba gudxiinn raꞌ ba, ya spaaldaa raꞌ ba basihdzi dxiah raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ya chiꞌchi guluꞌnehza ballwaaꞌn chi ziahan ru xmooza ba, per laꞌh raꞌ bwiinn raꞌ nin guuꞌn loh xuh ballwaaꞌn chi ziꞌchi gahca bwiꞌhnnee raꞌ ba laꞌh xmooza raꞌ ba chi ziga za bwiꞌhnnee raꞌ ba laꞌh nin naa raꞌ galoh. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ya pur luulchima guluꞌnehza ba laꞌh yuꞌpi lliiꞌn ba laasii bwiꞌhnn ba lligaaba nastoꞌ ba: “Zuzoꞌbadxiahga raꞌ ba xchiꞌdxyi lliiꞌnahn.” ");
INSERT INTO zpvNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per chin bwaꞌha raꞌ bwiinn raꞌ nin guuꞌn loh xuh ballwaaꞌn chi garoolda laꞌh lliiꞌn ba, chiꞌchi rahbi loh lasaaꞌ raꞌ ba: “Bwaꞌha, dee chi sihn naa nin guicaꞌha gaduhbi loh yuh riiꞌ; gulchooꞌho gachidxiinn nuꞌh laꞌh bi tin laꞌh nuꞌh gachicaꞌha nuꞌh gaduhbi loh yuh riiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pwihsi gunaꞌzu raꞌ ba laꞌh bi, chiꞌchi babweꞌhe raꞌ ba laꞌh bi nez rwaaꞌ yuh chi, ya nez chi gudxiinn raꞌ ba laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yannah chin dxieꞌguiaꞌha ballwaaꞌn xteenn loh yuh chi, ¿xiniꞌca gunnee ba laꞌh raꞌ bwiinn nin guuꞌn loh xuh ba garoolda? ");
INSERT INTO zpvNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Zidxiinn ba laꞌh raꞌ bwiinn yaꞌdxi raꞌ chi, ya gudiꞌhi ba loh yuh chi gaan raꞌ spaaldaa raꞌ bwiinn nin rñaloh gudiꞌhi liꞌhn nin guicaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta nagahdxi guꞌlda tu loh Xchihtsi Dxiohs hasta rñiꞌ squiiꞌ?: Dxiah nin ayi biuuꞌstoꞌ raꞌ mwehsu albañihyi, dxiah chi naa dxiah nin rzohba xchihn yuuꞌ nin riaꞌha. Deeꞌ nin bwiꞌhnn Dxiohs, nin naa tuhbi dziꞌn nin gadxyigaaꞌ loh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Pwihsi niꞌchin nin rñiꞌn loh tu ziapitii guelrnabwaꞌ xteenn Dxiohs loh tu ya zidiiꞌdxin loh raꞌ bwiinn nin dxiuꞌn ntriehgu liꞌhn xteenn guelrnabwaꞌ chi loh Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ya chyu chiꞌh zi bwiinn nin dxiaaba yihca dxiah chi zahca ba ziahan taaꞌha, ya sidela laꞌh dxiah chi dxiaaba yihca bwiinn zusiuꞌyin laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ya chin bihn raꞌ bwiinn raꞌ nin rnabwaꞌ loh raꞌ bixohza cun bwiinn fariseu raꞌ dxyiꞌdxyi chi gwasaa raꞌ ban laasii yihca raꞌ ba guñiꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ya guclaaꞌdzi raꞌ ba ñinaꞌzu raꞌ ba laꞌh Jesuhs hohra chi gahca, per bidxyihbi raꞌ ba laꞌh raꞌ bwiinn laasii bwiinn raꞌ ruhnn raꞌ ba lligaaba naa Jesuhs tuhbi bwiinn nin rñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ya guzoꞌbaloh guñiꞌ laꞌgaꞌh Jesuhs stuhbi cweenta rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Guelrnabwaꞌ xteenn Dxiohs naa ziga tuhbi rrehyi nin bwiꞌhnn tuhbi saaꞌ par lliiꞌn ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ya guxeꞌhla ba xmooza ba yihdzi nin biduꞌhun raꞌ chee raꞌ saaꞌ, per ayi gunnah raꞌ ba ñiꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ya chiꞌchi guxeꞌhla laꞌgaꞌh rrehyi chi spaaldaa raꞌ xmooza ba ya rahbi ba loh raꞌ xmooza ba squiiꞌ: “Gulguiñiꞌ loh raꞌ bwiinn nin biduꞌhun: laꞌh guelwahw naa listu la laasii gudxiꞌnnahn xcuuꞌn raꞌn cun xquidxaꞌh raꞌn nin basarooꞌzahn, yannah laꞌh guelwahw naa la, niꞌchin gultaaꞌ saaꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per laꞌh raꞌ bwiinn nin biduꞌhun chi ayi gwah raꞌ ba; tuhbi bwiinn chi sola loh xuh ba gwah ba dxyih chi, ya stuhbi ba loh guelguriꞌxi ba gwah ba dxyih chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ya snuhn raꞌ ba gunaꞌzu raꞌ ba laꞌh raꞌ xmooza rrehyi, gudxiꞌldxyihdxyi raꞌ ba laꞌh xmooza rrehyi chiꞌchi gudxiinn raꞌ ba laꞌh raꞌ mooza raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ya chiꞌchi bidxyiꞌchi duxa rrehyi chi ya gunabwaꞌ ba laꞌh raꞌ suldahdu ba gwachiin laꞌh raꞌ bwiinn yaꞌdxi chi cun neezaa gunabwaꞌ ba gucaꞌdxih raꞌ ba lahdxyi raꞌ bwiinn yaꞌdxi raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ya chiꞌchi rahbi rrehyi chi loh raꞌ xmooza ba: “Laꞌh garaa naa para saaꞌ, per laꞌh raꞌ bwiinn raꞌ nin biduꞌhun raꞌ ayi balluꞌyi raꞌ ba ñah raꞌ ba saaꞌ; ");
INSERT INTO zpvNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","niꞌchin nnah gulcheh loh neziuh rooꞌ raꞌ ya bwiinn chiꞌh zi nin gadxiꞌloh tu gultaꞌnee raꞌ ba loh saaꞌ riiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ya chiꞌchi biriaꞌh raꞌ xmooza ba chi zee raꞌ ba loh neziuh raꞌ ya bwiinn chiꞌh zi raꞌ nin badxiꞌloh raꞌ ba nicala bwiinn nadxaaba raꞌ cun bwiinn zaꞌca raꞌ gwanee raꞌ ba loh saaꞌ, ya ziꞌchi hasta bagadxah raꞌ bwiinn nez bwiꞌhnnchaꞌyi rrehyi chi guelwahw, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ya chin guyuuꞌtii rrehyi chi gwaguiaꞌha ba loh raꞌ bwiinn nin gwacaꞌha raꞌ xmooza ba nez neziuh raꞌ, chiꞌchi bwaꞌha ba loh tuhbi bwiinn nin dxaꞌga loh raꞌ bwiinn chi ayi nahcu ba lahdxi ziga nin nahcu raꞌ bwiinn saaꞌ raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chiꞌchi rahbi ba loh bwiinn chi: “Mihgu, ¿xaloh guyuuꞌtii luꞌh riiꞌ nee ayi nahcu luꞌh lahdxi nin nahcu raꞌ bwiinn saaꞌ raꞌ nin riiꞌ raꞌ riiꞌ?” Ya cun ayi basiaꞌgarii bwiinn chi dxyiꞌdxyi, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ya chiꞌchi rahbi rrehyi chi loh raꞌ xmooza ba: “Gulgachiꞌbiduꞌh ñaaꞌ-naa bwiinn ca tin gulgalaꞌha ba loh nacahyi hasta gutiꞌdxiloh ba guelrzaꞌcazii hasta gahw lahyi ba cun nalasa duxa guꞌn ba”, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","laasii ziahan raꞌ ba gacarihdxyi per gulliaꞌyiꞌhn naa raꞌ nin guibwiꞌhi. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ya chin guyaꞌloh guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ chi, chiꞌchi gwabiiga raꞌ bwiinn fariseu raꞌ hasta zuu Jesuhs laasii biaꞌhan dxyiꞌdxyi raꞌ ba chiꞌhyi raꞌ ba xa guñihchi Jesuhs pur dxyiꞌdxyi nin rñiꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","pwihsi chiꞌchi guxeꞌhla raꞌ ba paaldaa raꞌ xpwiinn raꞌ ba nin guunn ziga zi bwiinn zaꞌca tin gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh cun paaldaa raꞌ za xpwiinn Herodes, tin guiñiꞌ raꞌ ba loh Ñiꞌh squiiꞌ: ―Mwehsu, naann nu xnehza rñiꞌ luꞌh nee ruluuꞌyi za luꞌh zigapaꞌh naa xnehza xcweenta xchiꞌdxyi Dxiohs, nee ayiza rwaꞌha zaꞌca luꞌh loh tuhbi bwiinn ya stuhbigaꞌh ba gwaꞌha dxaaba luꞌh loh ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yannah gunnah loh nu, ¿ta zachidxihlli nu o ayi chyu chiilli mweeyi xcweenta impweestu loh rrehyi César? ");
INSERT INTO zpvNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per Jesuhs laꞌh Ñiꞌh guhcabwaꞌ la xi lligaaba nuu raꞌ ba, niꞌchin rahbi Ñiꞌh loh raꞌ ba: ―Bwiinn dxixiꞌhw raꞌ, ¿xixnaa xclaaꞌdzi tu guunn tu prehba naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gulgaluuꞌyi naꞌh tuhbi xmweeyi tu naꞌh nin rdxihlli tu xcweenta impweestu loh César. Chiꞌchi baluuꞌyi raꞌ ba tuhbi mweeyi nin laa denariu laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ya gunaabadxyiꞌdxyi Jesuhs loh raꞌ ba rahbi Ñiꞌh: ―¿Chyu yihca deeꞌ caa loh mweeyi riiꞌ, nee cun dxyiꞌdxyi nin caa lohon, nee chyu laa deeꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Yihca César. Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Pwihsi gulgadiꞌhi laꞌh César nin naa xteenn ba, nee gulgadiꞌhi za laꞌh Dxiohs nin naa xteenn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ya chin bihn raꞌ ba dxyiꞌdxyi raꞌ riiꞌ, badxyigaaꞌ duxa loh raꞌ ba, ya chiꞌchi basaaꞌn raꞌ ba laꞌh Ñiꞌh ziaa raꞌ chiꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ya laꞌn dxyih chi gahca, badzihn raꞌ nuhn bwiinn saduceu raꞌ loh Jesuhs, ya bwiinn saduceu raꞌ chi ruhnn raꞌ ba lligaaba ayi gabahan raꞌ bwiinn guuchi, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Mwehsu, basiaꞌhannee Moisehs dxihtsi laꞌh nuꞌh loh chi rñiꞌ: “Sidela laꞌh chyuulla tuhbi ndxiꞌhw gachi ba nee ayi chyu lliiꞌn ba guyuuꞌ, nahpa guicaꞌha bwihtsi ba laꞌh xcunnaꞌh ba nin biaꞌhan viuhda tin chuu lliiꞌn ba xcweenta bwihtsi ba nin guhchi.” ");
INSERT INTO zpvNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pwihsi loh nu guyuuꞌ gahdzi bwihtsi bwiinn ndxiꞌhw raꞌ, nin mwergaloh chi bachinaa ba, ya guhchi ba, ya ayi chyu lliiꞌn ba guyuuꞌ. Pwihsi basiaꞌhan ba xcunnaꞌh ba, ya seguihdu gucaꞌha bwihtsiraroopa ba laꞌh gunnaꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","per ayi chyu lliiꞌn bwihtsiroopa ba chi guyuuꞌ, chiꞌchi gucaꞌhalaꞌgaꞌh bwihtsi riohnna ba laꞌh gahca gunnaꞌh chi, ziꞌchi gahca za ayi chyu lliiꞌn ba guyuuꞌ cun gunnaꞌh chi, ya hasta basaaꞌ gagaadzii bwihtsi raꞌ ba gucaꞌha laꞌh gunnaꞌh chi per ayi chyu lliiꞌn raꞌ ba guyuuꞌtiiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ya pur luulchima guhchi garaa raꞌ ndxiꞌhw raꞌ nin gucaꞌha laꞌh gunnaꞌh chi neezaa gunnaꞌh chi guhchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yannah, chin gabahan raꞌ ba loh guelguhchi, ¿cuunpaꞌh xchiꞌh loh gagaadzii raꞌ ndxiꞌhw raꞌ chi naa cheꞌhla gunnaꞌh chi, laasii garaa raꞌ ba gucaꞌha raꞌ ba laꞌh gunnaꞌh chi? ");
INSERT INTO zpvNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh tu rcheꞌh duxa yihca tu laasii ayi nuꞌnbwaꞌ zaꞌca tu loh Xchihtsi Dxiohs nee ayi za nuꞌnbwaꞌ tu xa naa guelrnabwaꞌ xteenn Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","laasii chin gabahan raꞌ bwiinn guuchi nin guhchi, ndxiꞌhw cun gunnaꞌh ayi ru guchinaa raꞌ ba, laasii gaca raꞌ ba ziga zi aanjla raꞌ nin rii dxibaaꞌ nnah, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ya ziga gabahan raꞌ bwiinn loh guelguhchi, ¿ta nagahdxi guꞌlda tu loh dxihtsi hasta caa nin guñiꞌ Dxiohs rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naꞌh naan Xchiohs Abrahn, Xchiohs Isaac, cun Xchiohs Jacob”? ¡Niꞌchin Dxiohs ayi naa Ñiꞌh Xchiohs raꞌ bwiinn guuchi sino que naa Ñiꞌh Xchiohs raꞌ bwiinn raꞌ nin gaca nabahan raꞌ para tuꞌpazi! ");
INSERT INTO zpvNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ya chin bihn raꞌ bwiinn dxyiꞌdxyi raꞌ nin guñiꞌ Jesuhs badxyigaaꞌ duxa loh raꞌ ba pur dxyiꞌdxyi raꞌ nin ruluuꞌyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ya chiꞌchi badiaaꞌha raꞌ bwiinn fariseu riꞌchi laasii bihn raꞌ ba basiahcadxyii Jesuhs laꞌh raꞌ bwiinn saduceu raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ya niꞌchin tuhbi mwehsu nin ruluuꞌyi xlehyi Moisehs, para guunn ba prehba laꞌh Jesuhs, gunaabadxyiꞌdxyi ba rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mwehsu, ¿cuun nin naa dxyiꞌdxyi nin gunabwaꞌ Dxiohs nin naa mahzi lasahca loh lehyi? ");
INSERT INTO zpvNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chiꞌchi rahbi Jesuhs loh ba: ―“Gaca nadziiꞌhi luꞌh Xtaada Dxiohs luꞌh cun gaduhbi stoꞌ luꞌh, cun gaduhbi xaalma luꞌh, nee cun gaduhbi xigaaba za luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dxyiꞌdxyi riiꞌ nin gunabwaꞌ Dxiohs naa dxyiꞌdxyi nin mahzi lasahca loh garaa nin naa xchiꞌdxyi Dxiohs; ");
INSERT INTO zpvNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ya nin raroopan rñiꞌ squiiꞌ: “Gaca nadziiꞌhi luꞌh lasaaꞌ luꞌh ziga nadziiꞌhi za luꞌh yiꞌh gahca.” ");
INSERT INTO zpvNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pwihsi garoopa dxyiꞌdxyi riiꞌ xteenn xlehyi Moisehs naa ziga dulbaaꞌ loh raꞌ snuhn raꞌ dxyiꞌdxyi lehyi, ziga xlehyi guehtu Moisehs o ziga xlehyi raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ya gaduhbi nin rii gahca raꞌ bwiinn fariseu raꞌ riꞌchi, gunaabadxyiꞌdxyi Jesuhs loh raꞌ ba ");
INSERT INTO zpvNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","rahbi Ñiꞌh: ―¿Xi lligaaba ruhnn tu pur Crixtu? ¿Chyu naa lliiꞌn ñiꞌh laꞌh Crixtu? Chiꞌchi rahbi raꞌ ba: ―Lliiꞌn guehtu Davihd. ");
INSERT INTO zpvNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xixnaa chiꞌh bazeꞌta guehtu Davihd, chin basañiꞌ Spíritu Saantu yihca ba? Rahbi ba: “Daada naa Crixtu loh ba”, laasii laꞌhgahca guehtu Davihd rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Daada Dxiohs rahbi loh nin naa Daada loon: “Guzohba xlahdu nanchiin hastayi gadzihn dxyih nin gutsiiꞌgahn garaa bwiinn nin rdxyiꞌchinee yiꞌh hasta zuu ñaaꞌ luꞌh tin gacabwaꞌ raꞌ ba yiꞌh naa luꞌh nin rnabwaꞌ garaatiiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xaalla gaca chiꞌh Crixtu lliiꞌn guehtu Davihd sidela laꞌh gahca guehtu Davihd guñiꞌ Crixtu naa Daada loh ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ya nin tuhbi raꞌ ba ayi guhca ñusiaꞌgarii nin tuhbi dxyiꞌdxyi loh Jesuhs, ya desde dxyihyi chi nin stuhbi raꞌ ba ayi biaalla ñinaabadxyiꞌdxyi xiilla stuhbi dxyiꞌdxyi loh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chiꞌchi guzoꞌbaloh cañiꞌnee Jesuhs laꞌh raꞌ bwiinn cun laꞌh raꞌ xpwiinn Ñiꞌh rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs cun bwiinn fariseu raꞌ ruluuꞌyi raꞌ ba ziga naa xlehyi Moisehs. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pwihsi rñiꞌn loh tu gulgazoꞌbadxiahga xchiꞌdxyi zi raꞌ ba per ayi chezahnee tu xmahn ba, laasii laꞌh raꞌ ba rñiꞌ raꞌ ba tuhbi dxyiꞌdxyi mahzi guriinyi nin rareꞌcaa raꞌ ba ruhnn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","¿Xixnaa rusaguꞌa raꞌ ba nin naaꞌha laꞌh raꞌ bwiinn nin ayi chipa raꞌ bwiinn, ya laꞌh raꞌ ba nin tuhbi bacwihnaa raꞌ ba ayi rñiꞌbi raꞌ ban? ");
INSERT INTO zpvNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ruhnn raꞌ ba squiiꞌ tin rdxiꞌhyi raꞌ ba nez gadxyigaaꞌ loh raꞌ bwiinn nin ruhnn raꞌ ba, nee riuuꞌ za stoꞌ raꞌ ba rcah dxyiꞌdxyi raꞌ nin caa loh Xchiꞌdxyi Dxiohs locah raꞌ ba cun nez rwaaꞌ llehcu raꞌ ba loh xahba raꞌ ba, nee neezaa ruhnn gurooꞌ raꞌ ba luhlla xahba raꞌ ba tin guluuꞌyi raꞌ ba bwiinn zaꞌca duxa raꞌ ba loh snuhn raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","nee rdxiꞌhyi za raꞌ ba nez rzohba raꞌ ba delantatiiꞌ hasta rahca guelwahw zaꞌca nee ziꞌchi gahcaza ruhnn raꞌ ba laꞌn guidoꞌ biꞌtuꞌhn raꞌ hasta radiaaꞌha raꞌ bwiinn Israel puur delantatiiꞌ riasohba raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","nee xclaaꞌdzi za raꞌ ba garaa raꞌ bwiinn chiꞌh zi nin gadxaꞌga laꞌh raꞌ ba loh neziuh gugahpa Dxiohs laꞌh raꞌ ba cun gaduhbi stoꞌ raꞌ ba nee tin guiñiꞌ za raꞌ bwiinn loh raꞌ ba: “Mwehsu”, niꞌchi xclaaꞌdzi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ya rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Per laꞌh tu ayi chiꞌhyi tu canehza guiñiꞌ bwiinn raꞌ loh tu: “Mwehsu”, laasii tuhbi dxiꞌh xmwehsu tu naa Crixtu, ");
INSERT INTO zpvNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","nee ayi za guiñiꞌ tu loh chyuulla: “Paah” loh guidxyiyuh laasii tuhbi dxiꞌh Xtaada tu nuuꞌ; laꞌh Ñiꞌh nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nee nin ayi za chiꞌhyi tu canehza guiñiꞌ bwiinn loh tu: “Ballwaaꞌn”, laasii laꞌh dxiꞌh Crixtu naa Ballwaaꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bwiinn nin mahzi dziꞌbaloh loh tu nahpa gaca ba ziga mooza loh raꞌ snuhn raꞌ bwiinn ");
INSERT INTO zpvNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","laasii bwiinn nin ruhnn lligaaba gaca lasahca ayi gaca lasahca ba, per bwiinn nin gaguuꞌdzi stoꞌ ñiꞌh zahca lasahca ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Chiꞌchi rahbi Ñiꞌh loh raꞌ bwiinn: ―¡Prohbi laꞌh tu, mwehsu raꞌ nin ruluuꞌyi lehyi cun bwiinn fariseu raꞌ, bwiinn dxixiꞌhw raꞌ! Laꞌh tu ayi nnaa tu guixaala tu rwaaꞌ yuuꞌ hasta naa guelrnabwaꞌ xteenn Dxiohs tin chuꞌtii raꞌ snuhn raꞌ bwiinn, nee neezaa laꞌh tu ayi nnaa tu chuꞌtii tu loh xnehza Dxiohs nin ayi za rusaaꞌn tu chuꞌtii raꞌ bwiinn raꞌ nin xclaaꞌdzi chuꞌtii raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Prohbi za laꞌh tu mwehsu raꞌ nin ruluuꞌyi lehyi cun bwiinn fariseu raꞌ, bwiinn dxixiꞌhw duxa raꞌ! ¿Xixnaa rusiaꞌpitii tu yihdzi raꞌ gunnaꞌh viuhda raꞌ ya lwehgu gahca rbwihdxyi-rnaaba tu loh Dxiohs xchihrooꞌ? Per nin cabweeza laꞌh tu zirooꞌ ru guelrzaꞌcazii dxiaaba yihca tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Prohbi za laꞌh tu mwehsu raꞌ nin ruluuꞌyi lehyi cun fariseu raꞌ, bwiinn dxixiꞌhw bwiinn nahda raꞌ! Laꞌh tu caꞌnzaa tu loh guihdxyi raꞌ cun rdiiꞌdxi za tu stuhbi lahdu loh ñihsadoꞌ raꞌ tin cañiꞌnee tu bwiinn raꞌ tin gaann raꞌ ba Dxiohs ziga ruluuꞌyi tu, ya chin ruhnn tu gahn riuuꞌtii ba loh xcweenta ziga ruluuꞌyi tu, ruhnn tu ba ziga naa xigaaba tu mas chiohpa rutsiiga tu laꞌh bwiinn chi gabihldxyi hasta caa tu bwaꞌ laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Prohbi za laꞌh tu mwehsu raꞌ cun fariseu raꞌ nin naa raꞌ ziga bwiinn dxieꞌpa raꞌ! Rñiꞌ tu rahbi tu: “Bwiinn nin rñiꞌ chihpa: Pur lah guidoꞌ rooꞌ zuꞌnnañin, bwiinn chi ayi nahpa guzaꞌloh ba dxyiꞌdxyi nin guñiꞌ ba, per sidela guiñiꞌ chihpa ba: Pur ohro xteenn guidoꞌ rooꞌ zuꞌnnañin, bwiinn chi sihn nahpa guzaꞌloh xchiꞌdxyi ba nin guñiꞌ ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Bwiinn nahda raꞌ bwiinn dxieꞌpa raꞌ! ¿Cuun nin lasahca ru? ¿Ta ohro o guidoꞌ nin ruhnntaaꞌyi yihca ohro? ");
INSERT INTO zpvNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nee neezaa rahbi tu: “Sidela chyulla guiñiꞌ chihpa: Pur lah bacuꞌga xteenn guidoꞌ rooꞌ zuꞌnnañin, bwiinn chi ayi xi guilasahca xchiꞌdxyi ba, per sidela laꞌh bwiinn chi rñiꞌ chihpa ba: Pur lah guhn nin dziꞌba loh bacuꞌga chi zuꞌnnañin, bwiinn chi nahpa guzaꞌloh xchiꞌdxyi ba nin guñiꞌ ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Bwiinn nahda raꞌ bwiinn dxieꞌpa raꞌ! ¿Cuun nin lasahca ru? ¿Ta guhn, o bacuꞌga nin ruhnntaaꞌyi laꞌh guhn? ");
INSERT INTO zpvNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pwihsi bwiinn nin rñiꞌ chihpa pur bacuꞌga nee pur nin dziꞌba yihcan rñiꞌ chihpa raꞌ ba; ");
INSERT INTO zpvNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ya bwiinn raꞌ nin rñiꞌ chihpa pur guidoꞌ ayi rñiꞌ chihpa ba pur guidoꞌ si sino que nee pur laꞌh Dxiohs nin nuu riꞌchi; ");
INSERT INTO zpvNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","nee raꞌ za bwiinn nin rñiꞌchihpa pur llaaꞌndxibaaꞌ, neezaa rñiꞌ chihpa ba pur yahgaxiiyi xteenn Dxiohs cun laꞌh za Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Prohbi za laꞌh tu mwehsu raꞌ nin ruluuꞌyi lehyi cun fariseu raꞌ, bwiinn dxixiꞌhw raꞌ! Laꞌh tu rdxihlli tu tuhbigah tantu yihca tuhbi tsiꞌhgah loh Dxiohs xcweenta menta, anihs, cun cumihn; per ayi ruzoꞌbadxiahga tu dxyiꞌdxyi lehyi raꞌ nin mahzi lasahca ziga guelnabahan nayaa nee ziga guelralahsastoꞌ laꞌh bwiinn, nee cun guelriachiistoꞌ xchiꞌdxyi Dxiohs. Dee raꞌ nahpa guunn tu nee snuhn raꞌ xchiꞌdxyi lehyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Laꞌh tu, nin naa raꞌ ziga bwiinn dxieꞌpa raꞌ nin xclaaꞌdzi guluuꞌyi neziuh! Mahzi riuuꞌ tu dxyiꞌdxyi lehyi nin gulliaaꞌha lasahca per dxyiꞌdxyi nin lasahca duxa ayi riuuꞌ tu ayi riaꞌzi tun, naa tu ziga bwiinn nin rbweꞌhe tuhbi balaaza loh xplahtu ñiꞌh nee ¡chiꞌchi rahbii ba tuhbi camehyu! ");
INSERT INTO zpvNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Prohbi za laꞌh tu mwehsu raꞌ nin ruluuꞌyi lehyi cun fariseu raꞌ, bwiinn nahda bwiinn dxixiꞌhw raꞌ! Pwihsi laꞌh tu rdxiꞌbi tu nez dihtsi xiilla nin guee tu ñihsa laꞌn ñiꞌh cun plahtu, per nez laꞌn lastoꞌ tu gadxah chihpa guelgubaꞌn cun garaaloh lligaaba dxaaba nin ruhnn tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bwiinn fariseu dxieꞌpa raꞌ, galoh chiꞌbi tu nez laꞌn nin guee tu nin gahw tu tin ziꞌchi dxiaa gaduhbin. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Prohbi za laꞌh tu mwehsu raꞌ nin ruluuꞌyi lehyi cun bwiinn fariseu raꞌ, bwiinn dxixiꞌhw duxa raꞌ! Naa tu ziga zi baꞌ raꞌ nin daꞌbi guiiꞌw dihtsi ñiꞌh ya rluuꞌyi zaꞌcan per laꞌn baꞌ chi ganaalla dzihta bwiinn guuchi nuu laꞌnan cun garaaloh nin ayi galluꞌyi raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ziꞌchi naa tu laꞌh tu; nez dihtsi tu rluuꞌyi tu bwiinn zaꞌca tu loh raꞌ bwiinn, per laꞌn lastoꞌ tu mahzi gadxah chihpan dxyiꞌdxyi dxixiꞌhw raꞌ nee sola nuu zaꞌbitiiꞌ tu loh zi raꞌ nin naa xigaaba tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Prohbi za laꞌh tu mwehsu raꞌ nin ruluuꞌyi lehyi cun bwiinn fariseu raꞌ, bwiinn dxixiꞌhw raꞌ! Laꞌh tu ruhnnchaꞌyi tu xpaꞌ raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih neezaa rzuhchaꞌyi tu xpaꞌ raꞌ bwiinn zaꞌca, ");
INSERT INTO zpvNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ya chiꞌchi rñiꞌ tu rahbi tu: “Sidela laꞌh nuꞌh ñuuꞌ raꞌ nuꞌh laꞌn dxyih raꞌ nin guyuuꞌ raꞌ xtaada guldooꞌ raꞌ nuꞌh, ayi chyu ñahcanee laꞌh raꞌ ba tin ñachidxiinn raꞌ nuꞌh laꞌh raꞌ daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs.” ");
INSERT INTO zpvNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ya cun garaa raꞌ dxyiꞌdxyi raꞌ riiꞌ laꞌh gahca tu rahcabwaꞌ tu naa tu llahga raꞌ guehtu xtatitarooꞌ tu nin gudxiinn laꞌh raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih, ");
INSERT INTO zpvNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡niꞌchin neezaa tu gulgazaꞌloh dziꞌn raꞌ nin bwiꞌhnn raꞌ xtatita raꞌ tu nin gudxiinn laꞌh raꞌ bwiinn raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Bwiinn raꞌ nin naa raꞌ ziga zi bweꞌlda raꞌ! ¡Lliiꞌn nin naa ziga bweꞌlda ñaꞌlaaꞌdzi raꞌ! ¿Xa guunn tu tin taꞌh tu tin ayi chee tu gabihldxyi? ");
INSERT INTO zpvNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Laasii naꞌh ziꞌxeꞌhlaꞌhn xpwiinn raꞌn nin guiñiꞌ xchiꞌdxyiꞌhn cun bwiinn nin gapa raꞌ guelnaann raꞌ, cun mwehsu raꞌ, per laꞌh tu zidxiinn tu paaldaa raꞌ ba cun gucaꞌh raꞌ tu ba loh cruhzi, ya snuhn raꞌ ba childxyihdxyi tu laꞌn guidoꞌ biꞌtuꞌhn raꞌ hasta radiaaꞌha tu, nee guicaꞌnaꞌhla za tu laꞌh raꞌ ba guihdxyi cun guihdxyi raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Niꞌchin yihca tu dxiaaba gallee llarihn bwiinn zaꞌca raꞌ nin billiꞌhi loh guidxyiyuh desde llarihn guehtu Abel hastayi llarihn guehtu Zacarías lliiꞌn Berequías nin gudxiinn raꞌ xtaada guldooꞌ tu laꞌn guidoꞌ hasta naa bacuꞌga. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niꞌchin nin guchiin nin rñiꞌn loh tu garaa raꞌ llarihn raꞌ bwiinn raꞌ riiꞌ dxiaaba yihca raꞌ bwiinn nin rii nabahan loh guidxyiyuh nnah. ");
INSERT INTO zpvNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Rahbi za Jesuhs: ―¡Prohbi za laꞌh tu bwiinn guihdxyi Jerusalehn! Rdxiinn tu laꞌh raꞌ daada raꞌ nin zeꞌgaluuꞌyi xchiꞌdxyi Dxiohs laꞌh tu cun, rsiꞌdzi dxiah tu yihca daada raꞌ nin rxeꞌhla Dxiohs guluuꞌyi xchiꞌdxyi Ñiꞌh laꞌh tu. ¡Ziahanla guclaaꞌdzihn ñutiaaꞌhahn laꞌh raꞌ xpwiinn luꞌh Jerusalehn, ziga zi rutiaaꞌha dxiidxi cuꞌca lliiꞌn ma laꞌn xihyi ma, per ayi gunnah raꞌ ba! ");
INSERT INTO zpvNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Niꞌchin nnah nahpa ziaꞌhan daꞌtsi xquidoꞌ rooꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","nee rñiꞌn loh tu ayi ru guibiaꞌgarii gwaꞌha tu naꞌh sola hastayi gadzihn dxyih nin gahbi tu: “Bwiꞌhnntaaꞌyi Dxiohs yihca bwiinn nin zeꞌ pur lah Ñiꞌh nin caꞌha Ñiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ya chin bariaꞌh Jesuhs laꞌn guidoꞌ tin guziaa Ñiꞌh stuhbi nehza, chiꞌchi gwabiiga raꞌ xpwiinn Ñiꞌh loh Ñiꞌh tin rahbi raꞌ ba ziga xñah guidoꞌ rooꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta riiywaꞌha tu xa xñah guidoꞌ ca nnah? Per rñiꞌn loh tu zadzihn dxyih nin cwih garaa raꞌ nin riiywaꞌha tu nnah, nee nin tuhbi dxiah nin dziꞌba yihca lasaaꞌ ca ayi dxiaꞌhancaa. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ya chiꞌchi gwanee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh yihca tuhbi dahan nin laa Olivo, ya loh nin zohba Jesuhs riꞌchi, chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh mwedxi ralaꞌn: ―Xclaaꞌdzi nu nnaa luꞌh loh nu cuuca gaca raꞌ niꞌchi raꞌ; ¿xa naa sehn raꞌ chin gabiaꞌgarii dxiꞌ luꞌh stuhbi chin amwer gaduhbi guidxyiyuh? ");
INSERT INTO zpvNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgahca nasiin tin ayi gusaaꞌn tu gusaguiꞌhi raꞌ bwiinn laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","laasii ziahan raꞌ bwiinn dxiꞌ nee nnaa raꞌ ba loh tu: “Naꞌh naan Crixtu”, nee zusaguiꞌhi raꞌ ba ziahan raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","nee zihn za tu ca chiꞌh zi nehza gaca guehrru nee nez hasta xclaaꞌdzi chuu raꞌ guehrru, per ayi guidxyihbi tu laasii nahpa galoh gaca raꞌ deeꞌ per nagahdxi gadzihn dxyih nin ñichiloh guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","laasii zucaꞌnee tuhbi guihdxyi laꞌh stuhbi guihdxyi neezaa tuhbi guelrnabwaꞌ zucaꞌnee laꞌh stuhbi guelrnabwaꞌ; neezaa chuu gueldxyihdxyi cun gubihn cun gaca za lluh rooꞌ ziahan lahta raꞌ loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Garaa raꞌ deeꞌ dxiꞌ galoh per gaca raꞌn nin gueꞌdu guzoꞌbaloh zi guelrzaꞌcazii nin gaca loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Neezaa zidiiꞌdxi tu loh raꞌ bwiinn raꞌ nin guunn guelguxchisi laꞌh tu, nee zidxiinn za raꞌ ba paaldaa tu, ya neezaa garaa raꞌ bwiinn guidxyiyuh zidxyiꞌchinee raꞌ ba laꞌh tu pur nin riachiistoꞌ tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nee chin gadzihn dxyih raꞌ chi ziahan raꞌ bwiinn zibweꞌhestoꞌ raꞌ ba xchiꞌdxyi Dxiohs, zidxyiꞌchinee lasaaꞌ raꞌ ba cun gutooꞌ lasaaꞌ za raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","neezaa ziahan raꞌ bwiinn nin dxiꞌ nnaa raꞌ ba ruluuꞌyi raꞌ ba xchiꞌdxyi Dxiohs ya ziꞌchi zusaguiꞌhi raꞌ ba ziahan raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","neezaa pur ziahan raꞌ nin saꞌloh, ziahan raꞌ bwiinn ayi ru gaca nadziiꞌhi lasaaꞌ raꞌ ba ziga tuhbi ziga stuhbi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per bwiinn nin cheezahtiiꞌ chechii dziꞌtsi stoꞌ ñiꞌh xchiꞌdxyi Dxiohs, hasta chin gadzihn dxyih nin gaduhbi guidxyiyuh, bwiinn chi taꞌh loh jwisi, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ya dxyiꞌdxyi xteenn xquelrnabwaꞌ Dxiohs nahpa chuu raꞌ bwiinn nin guluuꞌyin loh gaduhbi guidxyiyuh tin guidiꞌchin loh garaa raꞌ guihdxyi raꞌ hasta rii raꞌ bwiinn tin dxiuꞌnbwaꞌ raꞌ ban, ya chin ba bidiꞌchi xchiꞌdxyi Dxiohs loh gaduhbi guidxyiyuh, chiꞌchi gaduhbi guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Pwihsi bacaꞌh guehtu profeta Daniel xcweenta nin rusiaaba laꞌh bwiinn loh duhlda; chin dxihn tu laꞌh deeꞌ cayahca loh yuuꞌ Saantu laꞌn guidoꞌ rooꞌ ―bwiinn nin guꞌlda deeꞌ zahcabwaꞌ ba dxyiꞌdxyi raꞌ riiꞌ―, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pwihsi garaa raꞌ bwiinn raꞌ nin rii guihdxyi Judea nahpa gulluꞌn raꞌ ba chechuu laꞌn raꞌ ba loh dahan, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ya bwiinn raꞌ nin caa raꞌ yihca yuuꞌ ayi dxiehta raꞌ ba tin cheteꞌhe raꞌ ba xixteenn raꞌ ba laꞌn yuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ya bwiinn raꞌ nin zuu raꞌ loh dahan ayi guibiaꞌgarii rwaaꞌ yihdzi ba tin chegalliꞌhi ba xahba ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","nee ¡prohbi za laꞌh raꞌ gunnaꞌh nin nuꞌa lliiꞌn laꞌn dxyih raꞌ chi o gunnaꞌh raꞌ nin caꞌha badoꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gulguinaaba loh Dxiohs ayi gacan bweꞌhw raꞌ nin rahca guelnahlda, nee nin dxyih za nin ruziꞌlaaꞌdzi tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","laasii zutiꞌdxiloh tu ziahan raꞌ yaꞌdxi nin gaca, nin nagahdxi gwaꞌha tu nin guduhbi dxyih dez chin gurihxchih guidxyiyuh, nee nin ayi za gaca run. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ya sidela laꞌh Dxiohs ayi guchyuuꞌga Ñiꞌh yihca raꞌ dxyih chi, ayi chyu bwiinn taꞌhtiiꞌ; per zuchyuuꞌga Ñiꞌh yihca raꞌ dxyih chi pur bwiinn raꞌ nin gulii Ñiꞌh gaca xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ya sidela chyulla bwiinn guiñiꞌ loh tu laꞌn dxyih raꞌ chi: “Gulguiaꞌha riiꞌ; laꞌh Crixtu zuu”, o guiñiꞌ raꞌ ba loh tu: “Riꞌchi laꞌh Crixtu zuu”, ayi chechiistoꞌ tu ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","laasii dxiꞌ ziahan raꞌ bwiinn nin gusaguiꞌhi laꞌh raꞌ bwiinn nee guunn raꞌ ba tiidxi raꞌ ba ziga Crixtu nee guunn za raꞌ ba sehn raꞌ cun dziꞌn rooꞌ raꞌ tin ziꞌchi zusaguiꞌhi raꞌ ba laꞌh raꞌ bwiinn, pwehda hasta nee raꞌ bwiinn nin gulii Dxiohs guiclaaꞌdzi raꞌ ba gusaguiꞌhi raꞌ ba, per ayi guunn raꞌ ba gahn. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pwihsi niꞌchin laꞌguñiꞌxgaaꞌn dxyiꞌdxyi raꞌ riiꞌ loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pwihsi sidela guiñiꞌ raꞌ ba loh tu: “Gulguiaꞌha riꞌchi; laꞌh Ñiꞌh zuu nez loh dahan desiertu”, ayi chee tu riꞌchi, o guiñiꞌ za raꞌ ba loh tu: “Bwaꞌha riiꞌ laꞌh Ñiꞌh zuu laꞌn yuuꞌ riiꞌ”, ayi za chechiistoꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","laasii ziga zi tuhbi duꞌh guziꞌw nin rziaꞌñih nez rtahn gubihdxyi cun nez hasta riaꞌzi gubihdxyi, pwihsi ziꞌchi gaca chin guibiaꞌgarii Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hasta naꞌ tihxi bwiinn guuchi riꞌchi gadiaaꞌha raꞌ bwiichi raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Rahbi za Jesuhs: ―Pwihsi ziga gaca guelrzaꞌcazii laꞌn dxyih raꞌ chi, neezaa loh gubihdxyi gacahyi ya bweꞌhw ayi ru guziaꞌñih bweꞌhw, ya dxih llaaꞌndxibaaꞌ raꞌ zoꞌbaloh dxiaaba raꞌn loh guidxyiyuh, ya hasta gaduhbi llaaꞌndxibaaꞌ ziñiꞌbi duxan, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ya chiꞌchiyi gwaꞌha tu sehn nez llaaꞌndxibaaꞌ xteenn Lliiꞌn Dxiohs nin naa ndxiꞌhw, ya garaa raꞌ guihdxyi raꞌ nin rii loh guidxyiyuh, zuꞌn raꞌ ba, ya gwaꞌha raꞌ ba laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw zeꞌ Ñiꞌh laꞌn xcahyi llaaꞌndxibaaꞌ cun gaduhbi xquelrnabwaꞌ Ñiꞌh cun llaꞌñih rooꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ya ziguꞌnehza Ñiꞌh xaanjla Ñiꞌh tin jweersi rooꞌ gucwidxaaꞌ raꞌ ba trompehta tin gadiaaꞌha raꞌ bwiinn raꞌ nin bibwiꞌhi loh gadahpa xnehza bwih nez tuhbi lahdu rwaaꞌ guidxyiyuh cun para stuhbi lahdun. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Pwihsi gulgasiꞌdxi ziga dxyih raꞌ xteenn yahga ñiigu; chin rbweꞌhe raꞌ yahga ñiigu bwiiꞌn pwihsi ya naann tu laꞌh bweꞌhw nin gaca naldaꞌh bigaꞌha, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","pwihsi ziꞌchi gahca za chin gwaꞌha tu laꞌh garaa raꞌ deeꞌ cayahca, laꞌh gahca tu gacabwaꞌ tu laꞌh dxyih zeꞌgadzihn gahxu gabiaꞌgarii Lliiꞌn Dxiohs; hasta rwaaꞌ leeꞌ zeꞌgadzihn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pwihsi niꞌchin guchiin nin rñiꞌn loh tu, garaa raꞌ deeꞌ gaca galoh, zwaꞌha raꞌ bwiinn nin riinabahan laꞌn dxih raꞌ chi yaꞌdxi raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dxibaaꞌ cun guidxyiyuh ziñihchiloh raꞌn, per xchiꞌdxyiꞌhn ayi ñichilohon, nahpa chaꞌloh xchiꞌdxyiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","per ziga dxyih o hohra nin gacan, ayi nin tuhbi nin gacabwaꞌ xohran nin aanjla raꞌ ayi gaann raꞌ ba xohra gacan, nee ninn Lliiꞌn za Dxiohs ayi gaann Ñiꞌh xohra gacan; sola laꞌh yuꞌpi Dxiohs sihn naann Ñiꞌh xohra gacan. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Rahbi za Ñiꞌh: ―Ziga guhca laꞌn dxyih raꞌ nin guyuuꞌ guehtu Noeh, ziꞌchi gahca za gaca chin gabiaꞌgarii Lliiꞌn Dxiohs nin naa ndxiꞌhw stuhbi loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pwihsi laꞌn dxyih raꞌ chi chin nagahdxi guñihchiloh ñihsa laꞌh raꞌ bwiinn chi, gudahw raꞌ ba gwaaꞌ za raꞌ ba, bachinaa za raꞌ ba cun guleꞌhedxiꞌhn za raꞌ ba lliiꞌndxaꞌpa raꞌ ba tin bachinaa raꞌ bi, cun hasta laꞌn dxyihyi raꞌ nin guyuuꞌtii guehtu Noeh laꞌn barcu rooꞌ nin bwiꞌhnnchaꞌyi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","pwihsi cun ayi guhcabwaꞌ raꞌ bwiinn raꞌ chi hastayi chin bwaꞌha raꞌ ba laꞌh raꞌ ba cañihchiloh loh ñihsa, ya ziꞌchi guñihchiloh garaa raꞌ ba loh ñihsa. Pwihsi ziꞌchi za gaca chin dxiꞌ Lliiꞌn Dxiohs nin naa ndxiꞌhw stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Laꞌn dxyih raꞌ chi riiꞌ raꞌ chiohpa ndxiꞌhw raꞌ loh dahan; tuhbi si ba guzee ya stuhbi ba dxiaꞌhancah. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ziꞌchi gahca za riiyuhta raꞌ chiohpa gunnaꞌh tuhbi si za ba guzee ya stuhbi ba dxiaꞌhancah. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Pwihsi gulcwihnasiin, laasii ayi gaann tu xohra dxiꞌ Daada xteenn tu stuhbi, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","nee neezaa gulgacabwaꞌ dxyiꞌdxyi raꞌ riiꞌ: sidela laꞌh tuhbi bwiinn gacabwaꞌ ba xohra chuꞌtii tuhbi gubaꞌn yihdzi ba gueꞌla, nahpa soobaa nasiin ba ayi gasi ba tin ayi gusaꞌn ba chuꞌtii gubaꞌn chi cwaan xixteenn ba yihdzi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pwihsi niꞌchin neezaa laꞌh tu gulgahca nasiin laasii dxyih nin ayi ruhnn tu lligaaba dxiꞌ Lliiꞌn Dxiohs nin naa ndxiꞌhw pwehda hohra chi dxiꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Rahbi za Ñiꞌh: ―¿Cuun nin naa mooza zaꞌca nin mahzi rahcabwaꞌ? Bwiinn chi naa bwiinn nin gusiaꞌhan xballwaaꞌn ñiꞌh loh raꞌ snuhn xmooza ba, tin gudiꞌhi bwiinn chi guelwahw gahw raꞌ ba gaduhbi dxyih raꞌ nin ayi chunee ba laꞌh raꞌ xmooza ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bwen duxa naa para laꞌh mooza chi sidela chin gabiaꞌgarii xballwaaꞌn ba gwaꞌha ba cayuhnn mooza chi ziga xclaaꞌdzi ba guunn mooza chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","pwihsi guchiin nin rñiꞌn loh tu, laꞌh ballwaaꞌn chi zuhnn ba laꞌh mooza chi nin dziꞌbaloh tin gapa ba garaatiiꞌ raꞌ nin nahpa ballwaaꞌn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per sidela laꞌh mooza chi guunn ba lligaaba dxaaba ayi guibiaꞌgariigah xballwaaꞌn ba ");
INSERT INTO zpvNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya soꞌbaloh ba gusaꞌcazii ba laꞌh raꞌ snuhn raꞌ xmooza xballwaaꞌn ba, ya soꞌbaloh gahw ba guee ba mascahyi cun snuhn raꞌ lasaaꞌ bwiinngwaaꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","pwihsi dxyih nin ayi nuu ba lligaaba gabiaꞌgarii xballwaaꞌn ba dxyih chi guibiaꞌgarii xballwaaꞌn ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ya chiꞌchi gudiꞌhi xballwaaꞌn ba laꞌh ba tuhbi guelrzaꞌcazii duxa tin guzeenee ba laꞌh raꞌ bwiinn raꞌ nin naa raꞌ bwiinn dxixiꞌhw hasta guzee raꞌ bwiinn chi ya riꞌchi hasta zuꞌn duxa raꞌ ba hasta guidaꞌw loh lahyi raꞌ ba riꞌchi tantu nin dxiagaduhbiillahnnee stoꞌ raꞌ ba laꞌhgahca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Guñiꞌ za Jesuhs rahbi Ñiꞌh: ―Pwihsi guelrnabwaꞌ xteenn Dxiohs naa ziga zi tsiꞌh dxaꞌpa raꞌ nin biꞌa raꞌ xlampara raꞌ ñiꞌh nin riuuꞌ nsehchi ya gwah raꞌ bi tuhbi saaꞌ tin gwaguiaꞌha raꞌ bi laꞌh ndxiꞌhw nin bachinaa. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaꞌyu dxaꞌpa raꞌ chi naa bwiinn nin ayi guinasiin ya za gaꞌyu raꞌ bi naa bwiinn nasiin, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ya laꞌh raꞌ dxaꞌpa nin ayi guinasiin, loh zenee raꞌ ba xlampara raꞌ ba biaꞌldastoꞌ raꞌ ba ñanee raꞌ ba nsehchi nin ñuuꞌ laꞌn xlampara raꞌ bi ");
INSERT INTO zpvNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","per laꞌh raꞌ dxaꞌpa raꞌ nin nasiin raꞌ chi gwanee raꞌ bi butehyi nsehchi mahzi de gadxah xlampara raꞌ bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ya guhcataꞌh nin bachinaa ayi bieꞌgah ba, chiꞌchi gunaꞌzu bacaꞌlda laꞌh garaatiiꞌ raꞌ bi ya cun gutaꞌxgahsi raꞌ bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ya ziga chiꞌh garoolda gueꞌla bihn raꞌ bi tuhbi rsiaaꞌha nin guñiꞌ: “¡Laꞌh nin bachinaa zieꞌ! ¡Gulguiriaꞌh, gulchegachiꞌloh laꞌh ba!” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ya hohra chi gwastii galluꞌn garaa raꞌ dxaꞌpa raꞌ chi tin bwiꞌhnnzaꞌca raꞌ bi xlampara raꞌ bi, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ya lwehgu laꞌh raꞌ dxaꞌpa raꞌ nin ayi guinasiin, rahbi raꞌ bi loh dxaꞌpa raꞌ nin nasiin raꞌ: “Gultaꞌnee nuhn nsehchi chuu laꞌn xlampara nu, laasii laꞌh xlampara nu dxiuꞌyi.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ya chiꞌchi rahbi dxaꞌpa raꞌ nin nasiin raꞌ chi loh raꞌ bi: “Pwehda ayi chyu guniꞌhiñin laasii lwehgu nin para laꞌh nu ayi gaaldan; mas chaꞌyi gulcheh hasta rdooꞌhon tin gulsiꞌ nin guichiꞌhn tu.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ya gaduhbi nin zee siꞌ raꞌ dxaꞌpa raꞌ nin ayi guinasiin raꞌ chi xnsehchi raꞌ bi, bieꞌ nin bachinaa, ya laꞌh raꞌ dxaꞌpa raꞌ nin nasiin raꞌ chi biuꞌgariinee raꞌ bi laꞌh nin bachinaa chi laꞌn yuuꞌ ya riinee raꞌ bi laꞌh nin bachinaa chi hasta cayahca saaꞌ, ya cun bieꞌw rwaaꞌ yuuꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ya seguihdu gubiaꞌgarii raꞌ dxaꞌpa raꞌ nin ayi guinasiin raꞌ ya rahbi raꞌ bi: “¡Daada, daada! ¡Guxaala rwaaꞌ yuuꞌ tin gachidxuꞌtii nu!” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ya chiꞌchi rahbi daada chi: “Guchiin nin rñiꞌn loh tu ayi nuꞌnbwaꞌn laꞌh tu.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgahca nasiin laasii ayi gaann tu hohra nin dxyih nin dxiꞌ Lliiꞌn Dxiohs nin naa ndxiꞌhw stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Rahbi za Jesuhs: ―Guelrnabwaꞌ xteenn Dxiohs naa ziga zi tuhbi bwiinn, chin laꞌh ba guiriaꞌh lahdxyi ba guzee ba zihtu, chiꞌchi gudihdxyi ba laꞌh raꞌ xmooza ba ya basiaꞌhannee ba xixteenn ba laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tuhbi ba basiaꞌhannee ba gaꞌyu mihyi xmweeyi ba, ya laꞌh stuhbi xmooza ba basiaꞌhannee ba schiohpa mihyi xmweeyi ba loh ziga guhca xigaaba ba, ya laꞌh stuhbi ba basiaꞌhannee ba tuhbisi mihyi xmweeyi ba, ya chiꞌchi gunaꞌzu nehza ba zee chiꞌh ba zihtu. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pwihsi laꞌh mooza nin gucaꞌha gaꞌyu mihyi chi bwiꞌhnnee ba mweeyi chi guriꞌxi ya bwiꞌhnn ba gahn yihca mweeyi chi za gaꞌyu mihyi yihcan. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pwihsi ziꞌchi gahca za bwiꞌhnn mooza nin gucaꞌha chiohpa mihyi, bwiꞌhnn za ba gahn schiohpa mihyi yihca mweeyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per laꞌh bwiinn nin gucaꞌha tuhbisi mihyi mweeyi, nin bwiꞌhnn ba gucaꞌha ba xmweeyi xballwaaꞌn ba guluuꞌchaꞌyi ban laꞌn tuhbi guiiꞌdxiu nin gudaꞌhn ba loh yuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ya chin guhca xchih chiꞌchi gubiaꞌgarii ballwaaꞌn chi, chiꞌchi gudihdxyi ba laꞌh raꞌ xmooza ba tin balaaba raꞌ ba xmweeyi ba nin biaꞌhannee raꞌ xmooza ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ya mwergaloh za mooza nin gucaꞌha gaꞌyu mihyi mweeyi badzihnnee ba za gaꞌyu mihyi mweeyi, chiꞌchi rahbi ba: “Daada, laꞌh gaꞌyu mihyi xmweeyi luꞌh deeꞌ ya za gaꞌyu mihyi bwiꞌhnnan gahn galoo ziga chiꞌh naan.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chiꞌchi rahbi ballwaaꞌn chi loh mooza chi: “Bwengahca bwiꞌhnn luꞌh; yiꞌh naa luꞌh tuhbi mooza zaꞌca, tuhbi mooza nin rzoꞌbadxiahga xchiꞌdxyiꞌhn laasii yiꞌh bwiꞌhnn luꞌh tuhbi bwen. Guyuuꞌtii gudiiꞌdxi tin gucaꞌbiꞌhn yiꞌh stuhbi dziꞌn roo ru; gudiiꞌdxi tin biahxinee naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ya chiꞌchi badzihn stuhbi mooza nin biaꞌhannee chiohpa mihyi xmweeyi ballwaaꞌn chi ya chiꞌchi rahbi mooza chi loh ba: “Daada, baniꞌhi luꞌh chiohpa mihyi mweeyi naꞌh yannah riiꞌ laꞌh schiohpan nin bwiꞌhnnan gahn deeꞌ”, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","chiꞌchi rahbi ballwaaꞌn chi loh mooza chi: “Bwen gahca za ziga bwiꞌhnn luꞌh, naa luꞌh tuhbi mooza zaꞌca tuhbi mooza nin ruzoꞌbadxiahga xchiꞌdxyiꞌhn pwihsi pur loh gulliaaꞌyiꞌhn nin baniꞌhihn yiꞌh per bwen bwiꞌhnn luꞌh niꞌchin nin guniꞌhihn mahzi ru nin guinabwaꞌ luꞌh, yannah guyuuꞌtii tin biahxinee naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per ya chin badzihn mooza nin biaꞌhannee tuhbi mihyi mweeyi si, rahbi ba loh xballwaaꞌn ba: “Daada naꞌh naꞌnnzahn yiꞌh naa luꞌh tuhbi bwiinn nadxipa dxyiꞌdxyi; rataaꞌha luꞌh guiñaꞌh hasta ayi gulahchi luꞌh biñih nee racaꞌha za luꞌh hasta ayi naa xteenn luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","pwihsi niꞌchin nin bidxyiibihn ya gwatuꞌchaꞌyiꞌhn xmweeyi luꞌh laꞌn tuhbi guiiꞌdxiu loh yuh, per nnah laꞌh xmweeyi luꞌh deeꞌ”, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","chiꞌchi rahbi ballwaaꞌn chi: “¡Mooza dxaaba! ¡Mooza raaꞌlla! Pwihsi ¿ta nnah luꞌh naꞌh racaꞌhahn hasta ayi naa xteꞌnnahn nee rataaꞌha zahn guiñaꞌh hasta ayi gulaꞌchihn biñih? ");
INSERT INTO zpvNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pwihsi ¿xixnaa chiꞌh ayi gwanee luꞌh xmweeꞌyihn ca baancu tin nnah nin gubiaꞌgariin ñuniꞌhi luꞌh xmweeꞌyihn cun lliiꞌnahn?” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ya rahbi ballwaaꞌn chi loh raꞌ bwiinn nin rii raꞌ riꞌchi: “Gulguicaꞌha gulgabweꞌhelluꞌh mweeyi nin gucaꞌha ba tin gulgadiꞌhihn laꞌh mooza nin nahpa tsiꞌhin, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","laasii laꞌh bwiinn nin nahpa mahzi run ziahan run guicaꞌha ba, per laꞌh bwiinn nin ayi xi nahpa hasta nin ruhnn ba lligaaba nahpa ba chapitii loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","yannah gulgalaꞌha ba hasta nacahyi hasta guꞌn ba, hasta loh lahyi ba guidaꞌw riꞌchi.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Rahbi za Ñiꞌh: ―Ya chin dxiꞌ Lliiꞌn Dxiohs nin naa ndxiꞌhw cun loh llaꞌñih Ñiꞌh nee cun garaa za xaanjla Ñiꞌh tin chiꞌchi soobaa Ñiꞌh loh xagaxiiyi Ñiꞌh hasta naa loh llaꞌñih xteenn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ya garaa raꞌ bwiinn gallee guihdxyi raꞌ gadiaaꞌha loh Ñiꞌh, ya riꞌchi gabwii Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh ziga zi rabwiꞌhi lliꞌhyi loh raꞌ chihba, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ya lliꞌhyi raꞌ chi cwih xlahdu derehchu Ñiꞌh, ya nin naa ziga chihva raꞌ niꞌchi raꞌ gadiaaꞌha xlahdu rrabwehsa Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ya chiꞌchi guiñiꞌ Rehyi loh raꞌ nin rii xlahdu derehchu Ñiꞌh: “Gultaaꞌbiiga laꞌh tu laasii laꞌh tu naa tu nin bwiꞌhnntaaꞌyi Xtaaꞌdahn, niꞌchin nnah gulguicaꞌha nin naa guelrnabwaꞌ nin guhcachaꞌyi para laꞌh tu galoh chin nagahdxi cwihxchih guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","laasii chin bichiaꞌhanahn laꞌh tu baniꞌhi tu nin gudaawuhn; bidxahgazahn ñihsa pwihsi baniꞌhi za tu nin gwaaꞌhahn; gucaꞌnzahn ziga zi tuhbi bwiinn ziitu nee baniꞌhi za tu rwaaꞌ yihdzi tu biaꞌhanahn; ");
INSERT INTO zpvNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","biaꞌdxi xaabahn pwihsi baniꞌhi za tu lahdxi guꞌtahn; guhcalluꞌhu zahn nee bieꞌguiaꞌha za tu naꞌh; bieꞌwuꞌhn ya bieꞌguiaꞌha tu naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ya garaa raꞌ nin bwiꞌhnn raꞌ gahn loh guelrnabwaꞌ xteenn Dxiohs ziñiꞌ raꞌ ba squiiꞌ: “Daada Dxiohs, ¿cuuca lla bidiaꞌha nu yiꞌh zuuchiaꞌhan luꞌh nee baniꞌhi nu guelwahw gudahw luꞌh?, nee ¿cuuca za bidiaꞌha nu yiꞌh rdxahga luꞌh ñihsa nee baniꞌhi za nu ñihsa gwaaꞌ luꞌh?, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","neezaa ¿cuuca za bidiaꞌha nu yiꞌh ziga zi tuhbi bwiinn ziitu nee baniꞌhi za nu hasta guyuuꞌ luꞌh?, o ¿cuuca biaꞌdxyi luꞌh lahdxi nee baniꞌhi za nu lahdxi guhta luꞌh?, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","o ¿cuuca bidiaꞌha za nu yiꞌh rahcalluꞌhu luꞌh?, o ¿cuuca bieꞌw luꞌh nee bioꞌpadiaꞌha nu yiꞌh?” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ya squiiꞌ guiñiꞌ Rehyi: “Pwihsi guchiin nin rñiꞌn loh tu, pwihsi loh garaa raꞌ nin bwiꞌhnn raꞌ tu laꞌh tuhbi raꞌ bwihtsi raꞌn riiꞌ nin gulliaaꞌha lasahca pwihsi bwiꞌhnn tun para naꞌh gahca.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ya chiꞌchi guiñiꞌ Rehyi loh raꞌ bwiinn nin rii xlahdu rrabwehsa Ñiꞌh squiiꞌ: “Gulchesuu laꞌh tu bwiinn nin dziꞌba dii raꞌ; mas chaꞌyi gulcheh loh bwehla xteenn gabihldxyi nin ayi dxiuꞌyitiiꞌ nin guhcachaꞌyi para laꞌh bwiinndxaaba cun garaa raꞌ xaanjla ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","laasii chin bichiaꞌhanahn ayi baniꞌhi tu nin ñaawuhn; bidxaagahn ñihsa per ayi baniꞌhi tu ñihsa ñeeꞌhehn; ");
INSERT INTO zpvNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","gucaꞌnzahn ziga zi tuhbi bwiinn ziitu per ayi za baniꞌhi tu hasta ñiaꞌhanahnꞌ; biaꞌdxyi xaabahn pwihsi ayi za baniꞌhi tu xaabahn; guhcalluꞌhuhn cun guyuuꞌzahn laꞌn lahtsidxiꞌba per ayi za bieꞌguiaꞌha tu naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ya chiꞌchi guiñiꞌ raꞌ bwiinn chi squiiꞌ: “Daada, ¿cuca lla bidiaꞌha nu yiꞌh cun guelrchiaꞌhan o rdxahga luꞌh ñihsa o gucaꞌnzaa luꞌh ziga zi tuhbi bwiinn ziitu o chin biaꞌdxyi xahba luꞌh o chin guhcalluꞌhu luꞌh o chin bieꞌw luꞌh nee ayi chyu ñahcanee yiꞌh?” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ya chiꞌchi guiñiꞌ Rehyi loh raꞌ ba: “Guchiin nin rñiꞌn loh tu, pur garaa raꞌ nin ayi ñahcanee tu laꞌh tuhbi raꞌ bwiinn rii nin riachiistoꞌ xchiꞌdxyiꞌhn nin gulliaaꞌha ru lasahca, pwihsi niꞌchin nin para naꞌh ayi bwiꞌhnn tun.” ");
INSERT INTO zpvNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pwihsi laꞌh raꞌ bwiinn raꞌ squiiꞌ guzee raꞌ loh guelrzaꞌcazii par tuꞌpazi ya laꞌh raꞌ bwiinn nin guzoꞌbadxiahga xchiꞌdxyi Dxiohs guzee raꞌ ba loh guelnabahan nacuubi nin ayi ñichilohtiiꞌ nez dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ya chin guyaꞌloh guñiꞌ Jesuhs garaa raꞌ dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Pwihsi laꞌh tu naann tu riaꞌdxi schiohpa dxyih lañih pascu zeꞌgadzihn, ya laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw zahca Ñiꞌh ntriehgu loh raꞌ bwiinn duhlda tin gucaꞌh raꞌ ba laꞌh Ñiꞌh loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pwihsi laꞌn dxyih raꞌ chi bwiinn raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza, cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, cun xpwiinn guuhla raꞌ bwiinn Israel; badiaaꞌha raꞌ ba loh laaꞌyitiaaꞌha xteenn yihdzi Caifahs, nee Caifahs chi naa nin rnabwaꞌ laꞌh raꞌ bixohza laꞌn dxyih raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ya riꞌchi biaꞌhan dxyiꞌdxyi raꞌ ba xa guunn raꞌ ba gusaguiꞌhi raꞌ ba laꞌh Jesuhs tin guinaꞌzu raꞌ ba laꞌÑiꞌh tin chiinn raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ya rahbi raꞌ ba: ―Ayi chyu chiinn laꞌh Jesuhs loh dxyih lañih tin ayi gabihxinee raꞌ bwiinn laꞌh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ya loh guihdxyi Betania zuu Jesuhs rwaaꞌ yihdzi Simohn, tuhbi bwiinn nin guhchyi guiiꞌdxiu tihxi ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ya riꞌchi badzihn tuhbi gunnaꞌh nin nuꞌa tuhbi butehyiꞌhn nsehchi nahxi nin lasahca mweeyi rooꞌ, ya loh zohba Jesuhs hasta zuu mweella, chiꞌchi gudaꞌbi gunnaꞌh chi nsehchi chi yihca Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ya chin bwaꞌha raꞌ xpwiinn Ñiꞌh niꞌchi, bidxyiꞌchi duxa raꞌ ba ya guzoꞌbaloh rahbi raꞌ ba: ―¿Xixnaa calliꞌhi si nsehchi ca? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Laꞌgah dxiꞌh ñutooꞌ gunnaꞌh ca niꞌca ziahan duxa mweeyi lasahcan tin ñahcanee ba laꞌh raꞌ bwiinn prohbi. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ya chin bihn Jesuhs ziꞌchi riiñiꞌ raꞌ ba chiꞌchi rahbi Ñiꞌh: ―¿Xixnaa rusioꞌba tu yihca gunnaꞌh riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pwihsi bwiinn prohbi raꞌ zibahannee tu laꞌh raꞌ ba garaa dxyih, per naꞌh gulliaaꞌyiꞌhn raꞌ dxyih guibahanee tu naꞌh loh guidxyiyuh riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","laasii nin cayuhnn gunnaꞌh riiꞌ cagaꞌbi bi nsehchi tiꞌxihn, naan bwen tin caguihn bi tiꞌxihn pur nin guigaꞌtsin, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","pwihsi guchiin nin rñiꞌn loh tu hasta chiꞌh zi chu saꞌbi xchiꞌdxyi Dxiohs loh gaduhbi guidxyiyuh zizaꞌbi za dxyiꞌdxyi ziga nin bwiꞌhnn gunnaꞌh riiꞌ tin dxiagannastoꞌ tu laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ya chin guhca squiiꞌ, Judas Iscariote nin naagahca tuhbi xpwiinn Jesuhs, gwagañiꞌ loh raꞌ bixohza nin rnabwaꞌ laꞌh raꞌ bixohza, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","rahbi Judas loh raꞌ ba: ―¿Balaaca mweeyi guniꞌhi tu naꞌh sidela naꞌh gutiꞌdxiꞌhn Jesuhs loh tu? Ya laꞌh raꞌ bwiinn chi badiꞌhi raꞌ ba gahlda bitsiꞌh mweeyi plahta laꞌh Judas, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ya hohra chi gahca cadxiꞌhyi ba xa guunn ba gutiꞌdxi ba laꞌh Jesuhs loh raꞌ bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ya mwer dxyih xteenn lañih nin rahw raꞌ bwiinn Israel pahn nin ayi rahcachaꞌyi cun levaduhra, gwabiiga raꞌ xpwiinn Jesuhs loh Ñiꞌh rahbi raꞌ ba loh Ñiꞌh: ―¿Canehza xclaaꞌdzi luꞌh gachidiꞌhnnchaꞌyi nu guelwahw nin naa xchih pascu? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ya chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulcheh lahda guihdxyi yihdzi tuhbi bwiinn, gulgahbi loh ba squiiꞌ: “Nnah Daada Mwehsu: Laꞌh xohraꞌhn zeꞌgadzihn gahxu, ya rwaaꞌ yihdzi luꞌh gahwneꞌhn laꞌh raꞌ xpwiiꞌnn raꞌn xchih pascu.” ");
INSERT INTO zpvNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ya bazoꞌbadxiahga raꞌ ba ziga guñiꞌ Ñiꞌh guunn raꞌ ba, pwihsi gwaguiꞌhnnchaꞌyi raꞌ ba xchih pascu, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ya chin gurih gueꞌla badzihnnee Jesuhs laꞌh raꞌ snuhn xpwiinn Ñiꞌh ya gurihnee raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh hasta zuu mweella, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ya gaduhbi nin riiyahwnee raꞌba laꞌh Ñiꞌh rahbi Ñiꞌh loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, tuhbi gahca tu naa nin gutooꞌ naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ya chiꞌchi guhca nalasa stoꞌ raꞌ ba, ya chiꞌchi guzoꞌbaloh gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh tuhbigah raꞌ ba rahbi raꞌ ba: ―Daada, ¿ta naꞌh guꞌnnahn ziꞌchi? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Bwiinn nin gahw loh xplaaꞌtuhn, bwiinn chi nin gutooꞌ naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw guinaꞌzunehza ziga rñiꞌ loh Xchihtsi Dxiohs, per ¡prohbi za laꞌh bwiinn nin gutooꞌ laꞌh Ñiꞌh! Mas chaꞌyi laꞌh bwiinn chi ayi ñaalaa ba loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ya chiꞌchi rahbi Judas nin cadxiꞌhyi xa gutooꞌ laꞌh Ñiꞌh: ―Mwehsu, ¿ta naꞌhan? Chiꞌchi rahbi Jesuhs loh ba: ―Yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ya gaduhbi nin riiyahw raꞌ ba chiꞌchi gucaꞌha Jesuhs tuhbi pahn tin badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs, ya chin guyaꞌloh badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs xcweenta pahn chi, chiꞌchi gudxiꞌzi Ñiꞌh pahn chi loh raꞌ xpwiinn Ñiꞌh ya rahbi Ñiꞌh loh raꞌ ba: ―Gulgahw pahn riiꞌ, laasii deeꞌ naa ziga bweꞌltiꞌxihn. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ya chiꞌchi gucaꞌha Ñiꞌh tuhbi copa vihnnu ya ziꞌchigahca za badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs pur copa chi, chiꞌchi gudxiꞌzi Ñiꞌh copa chi loh raꞌ xpwiinn Ñiꞌh ya rahbi Ñiꞌh loh raꞌ ba: ―Garaa tu gulguee nin nuu laꞌn copa riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","laasii deeꞌ naa ziga rihn nin nuuꞌhuhn, tin rihn riiꞌ naa nin gaca dxyiꞌdxyi cuubi nin gusiaꞌhanee Dxiohs laꞌh bwiinn raꞌ; pwihsi rihn nin guilliꞌhihn gaca nin gutaꞌh laꞌh raꞌ bwiinn loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","per rñiꞌn loh tu ayi ru guibiaꞌgarii gueeꞌneen ñihsa uhva laꞌh tu stuhbi hastayi gadzihn dxyih nin gueeꞌheñin laꞌh tu loh guelrnabwaꞌ xteenn Xtaaꞌdahn nin nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ya chin guyaꞌloh biꞌldanee raꞌ ba laꞌh Ñiꞌh tuhbi himno, chiꞌchiyi zenee raꞌ ba laꞌh Ñiꞌh yihca tuhbi dahan nin laa Olivo, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Garaatiiꞌ tu zusaaꞌn tu naꞌh nnahgueꞌla, pwihsi ziꞌchi caa loh Xchihtsi Dxiohs: “Zidxiꞌnnahn laꞌh nin rahpa lliꞌhyi ya ziaaꞌhan bizaꞌbi raꞌ lliꞌhyi raꞌ”, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","per naꞌh, chin gabahnaꞌhn loh guelguhchi galooruhn guzaaꞌhahn loh guihdxyi xteenn Galilea que laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chiꞌchi rahbi Pehdru loh Jesuhs: ―Nicala garaa raꞌ xpwiinn luꞌh gusaaꞌn yiꞌh, per naꞌh ayi gusaꞌnaꞌhn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chiꞌchi rahbi Jesuhs: ―Guchiin nin rñiꞌn loh luꞌh nnahgueꞌla gahca guiñiꞌ luꞌh, galoh gucaꞌyahnn dxiidxinguhla, guiñiꞌ luꞌh chohnna bwelta ayi nuꞌnbwaꞌtiiꞌ luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chiꞌchi rahbi Pehdru loh Jesuhs: ―Nicala gachineezahn yiꞌh per ayi gusaꞌnaꞌhn yiꞌh. Nee ziꞌchi gahca za guñiꞌ raꞌ garaa snuhn xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ya chiꞌchi gunaꞌzunehzanee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh tuhbi lahta nin laa Getsemanii, ya rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh riꞌchi: ―Gulsohba riiꞌ gaduhbi nin chaaꞌhahn cwiidxyi-guinaꞌbaꞌhn loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya nez chi hasta gwanee Ñiꞌh laꞌh Pehdru cun garoopa lliiꞌn Zebedeu, guzoꞌbaloh cayahca guerbiin duxa cun guelnalasa duxa laꞌn lastoꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Stoꞌn nuu tuhbi guelnalaasa xteenn guelguhchi; guldxiaꞌhan si riiꞌ nee ayi gasi tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ya gwah Jesuhs stuhbiꞌtuꞌhn ru delanta galoh hasta biaꞌhan raꞌ xpwiinn Ñiꞌh, riꞌchi guhta gurloh Ñiꞌh loh yuh, tin gudihdxyi-gunaaba Ñiꞌh gacanee Xtaada Dxiohs Ñiꞌh laꞌh Ñiꞌh gutiꞌdxiloh Ñiꞌh guelrzaꞌcazii, squiiꞌ guñiꞌ Ñiꞌh: ―Paah, ¿tayi gaca guchaꞌh xigaaba luꞌh tin guhldaꞌh luꞌh naꞌh loh guelrzaꞌcazii nin gutiꞌdxloon? Per sidela ayi nuuꞌhun ayi za xi ruhnn gutiꞌdxilooñin. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ya chin bwaa Ñiꞌh hasta biaꞌhan raꞌ xpwiinn Ñiꞌh, bwaꞌha Niꞌh laꞌh raꞌ ba naꞌxgahsi pur guelnalasa nin nuu stoꞌ raꞌ ba, chiꞌchi rahbi Ñiꞌh loh Pehdru: ―¿Tayi guhca ñizohbanah tu mas tuhbi hohra? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gulchestii tin gulguinaaba loh Dxiohs tin ayi gusaguiꞌhi bwiinndxaaba laꞌh tu; spíritu tu zirooꞌ nadaꞌhnan, per bweꞌltihxi tu casiꞌnaaꞌduxan. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ya nin raroopa zeegañiꞌnee Ñiꞌh Xtaada Dxiohs Ñiꞌh rahbi Ñiꞌh: ―Paah, sidela nahpa gutiꞌdxiloon guelrzaꞌcazii, nicala gaca ziga naa xigaaba luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ya chin bwaa Ñiꞌh hasta biaꞌhan raꞌ xpwiinn Ñiꞌh nin zenee Ñiꞌh nez chi, laꞌh raꞌ ba naꞌxgahsi stuhbi laasii basiꞌnaaꞌha bacaꞌlda laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ya cun basiaꞌhan Ñiꞌh laꞌh raꞌ ba tin gwaganaaba Ñiꞌh loh Xtaada Dxiohs Ñiꞌh tin gacanee Ñiꞌh laꞌh Ñiꞌh, ya nin riohnna pwihsi ziga guñiꞌ Ñiꞌh mwergaloh ziꞌchi gahca guñiꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ya chiꞌchi gubiaꞌgarii Ñiꞌh hasta biaꞌhan raꞌ xpwiinn Ñiꞌh ya rahbi Ñiꞌh loh raꞌ ba: ―Gulgaꞌllgahsi nnah tin gulgaziꞌlaadzi laasii laꞌh hohra bigaꞌha too Lliiꞌn Dxiohs nin naa ndxiꞌhw loh raꞌ bwiinn duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gulchestii tin gulchoꞌho, laasii laꞌh nin gutooꞌ naꞌh zeꞌbiiga gahxu. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pwihsi cañiꞌ gahca Jesuhs ziꞌchi chin badzihn Judas, tuhbi gahca nin naa xpwiinn Ñiꞌh loh gadziꞌh bichiohpa xpwiinn Ñiꞌh, zeꞌnee ba ziahan duxa raꞌ bwiinn nin nuꞌa spahda cun garrohta. Bwiinn raꞌ riiꞌ zeꞌ raꞌ ba pur xquelrnabwaꞌ bixohza raꞌ nin rnabwaꞌ loh raꞌ bixohza cun xcweenta za raꞌ bwiinn guuhla raꞌ xteenn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ya badiꞌhi Judas tuhbi sehn laꞌh raꞌ ba rahbi Judas: ―Bwiinn nin guchaꞌgarwaaꞌhahn loh ñiꞌh bwiinn chi naa laꞌh Jesuhs; lwehgu guinaꞌzu tu laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ya pwihsi chin gwabiiga Judas hasta zuu Jesuhs chiꞌchi rahbi ba loh Ñiꞌh: ―¡Chaan, mwehsu! Chiꞌchi bachaꞌgarwaaꞌ ba loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","chiꞌchi rahbi Jesuhs loh Judas: ―Mihgu, nin xclaaꞌdzi luꞌh guunn luꞌh, bwiꞌhnnan nnah. Ya chiꞌchi gwabiiga raꞌ bwiinn nin zeꞌnee Judas tin gunaꞌzu raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ya chin bwaꞌha tuhbi xpwiinn Jesuhs niꞌchi, guleꞌhe ba spahda ba ya bachyuuꞌga ba tuhbi lahdu dxiahga derehchu tuhbi xmooza bixohza nin rnabwaꞌ loh raꞌ bixohza, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","chiꞌchi rahbi Jesuhs loh xpwiinn Ñiꞌh chi: ―Baguuꞌchaꞌyi spahda luꞌh, ¡cun sol niꞌca!, laasii garaa raꞌ bwiinn nin rbwihdxihndxinee spahda, cun spahda za gahchi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tayi gaann luꞌh sidela naꞌh guinaꞌbaꞌhn loh Xtaaꞌdahn cuꞌnehza ba nnah gahca mas tsiꞌh bichiohpa mihyi aanjla raꞌ zixeꞌhla ba laꞌh raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per ¿xa gaca soobaa dxyiꞌdxyi nin caa loh Xchihtsi Dxiohs rñiꞌn nahpa gaca garaa raꞌ deeꞌ laꞌh gahca ziga nin cayahca? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ya chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh raꞌ bwiinn ziahan chi rahbi Ñiꞌh: ―¿Xixnaa zeꞌ tu nuꞌa tu spahda cun garrohta tin guinaꞌzu tu naꞌh ziga zi tuhbi gubaꞌhn? Garaa dxyih nin baluꞌyiꞌhn xchiꞌdxyi Dxiohs laꞌn guidoꞌ ayi gunaꞌzu tu naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","per garaa raꞌ deeꞌ nahpa gaca tin soobaa dxyiꞌdxyi ziga guñiꞌxgah raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs nin caa loh Xchihtsi Dxiohs. Ya hohra chi gahca garaa raꞌ xpwiinn Ñiꞌh basaaꞌn laꞌh Ñiꞌh cun ziaa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ya garaa raꞌ bwiinn raꞌ nin gunaꞌzu laꞌh Jesuhs gwanee raꞌ ba laꞌh Ñiꞌh rwaaꞌ yihdzi Caifahs, nin naa bixohza rooꞌ loh raꞌ bixohza; riꞌchi badiaaꞌha raꞌ mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs cun bwiinn guuhla raꞌ xteenn bwiinn Israel raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nee Pehdru gwanaꞌhla laꞌh raꞌ bwiinn nin zenee laꞌh Ñiꞌh zihtu-zihtu naꞌhla Pehdru hasta badzihn ba rwaaꞌ yihdzi bixohza nin rnabwaꞌ nin laa Caifahs, ya guyuuꞌtii Pehdru rwaaꞌ yihdzi ba zohba Pehdru lahda raꞌ guixaꞌga raꞌ xteenn guidoꞌ nin rii riꞌchi tin cagaldaꞌtsi ba guidiaꞌhan xa chaꞌloh garaa raꞌ nin cayahca raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bixohza raꞌ nin rnabwaꞌ loh raꞌ snuhn raꞌ bixohza cun garaa raꞌ bwiinn raꞌ nin rnabwaꞌ raꞌ cadxiꞌhyi raꞌ ba xi chiꞌh zi tuhbi dxyiꞌdxyi nicala dxyiꞌdxyi dxixiꞌhw nin gucaꞌchiah raꞌ ba laꞌh Jesuhs tin guinaaba raꞌ ba gachi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","per ayi bidxeela raꞌ ba xa ñuhnn raꞌ ba nicala ziahan raꞌ bwiinn guclaaꞌdzi ñusiaaba laꞌh Ñiꞌh loh xica dxyiꞌdxyi dxixiꞌhw raꞌ per ayi bwiꞌhnn raꞌ ba gahn, ya pur luulchima badzihn schiohpa bwiinn ");
INSERT INTO zpvNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nin guñiꞌ raꞌ rahbi raꞌ: ―Ndxiꞌhw riiꞌ rahbi loh raꞌ bwiinn: “Zahca gutsiiyihn xquidoꞌ Dxiohs ya chohnna si dxyih dxiuꞌnzaꞌcañin.” ");
INSERT INTO zpvNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ya chiꞌchi gwasuꞌnchii bixohza nin rnabwaꞌ loh raꞌ bixohza tin gunaabadxyiꞌdxyi ba loh Jesuhs rahbi ba: ―¿Xixnaa ayi guiñiꞌ luꞌh? ¿Xiniꞌca cañiꞌ raꞌ bwiinn raꞌ riiꞌ ziga nuugacaꞌchiah raꞌ ba yiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per laꞌh Jesuhs cun ayi guñiꞌ Ñiꞌh, chiꞌchi rahbi bixohza chi loh Ñiꞌh stuhbi: ―Pur lah Dxiohs nin nuu nabahan dziꞌtsi dxibaaꞌ, rnabwaꞌn loh luꞌh guñiꞌ dxyiꞌdxyi nin guchii sidela yiꞌh naa luꞌh Crixtu Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chiꞌchi rahbi Jesuhs loh ba: ―Yiꞌh gahca guñiꞌ luꞌhn, nee neezaa naꞌh rñiꞌn loh tu zwaꞌha tu naꞌh soꞌbaꞌhn xlahdu derehchu Xtaada Dxiohsaꞌhn nin nuu dxibaaꞌ, nee cun zwaꞌhaloh za tu naꞌh chin dxieꞌldahn loh xcahyi nez llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ya chiꞌchi gucaꞌha bixohza nin rnabwaꞌ loh raꞌ bixohza chi xahba ba gudxiꞌllu ban ziga tuhbi sehn nin ayi riachiistoꞌ ba laꞌh Ñiꞌh, ya rahbi ba: ―¡Xchiꞌdxyi ndxiꞌhw rii naa raꞌn dxyiꞌdxyi xihn raꞌ loh Dxiohs! ¿Xi xchiꞌhn ru chiꞌh, bweꞌzi chyu xi nnaa ru loh nuꞌh? Laꞌhgahca tu bihndxiahga tu xchiꞌdxyi bwiinn riiꞌ ziga rñiꞌyah ba laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xa rwaꞌha tu bwiinn squiiꞌ? Chiꞌchi rahbi raꞌ bwiinn raꞌ chi: ―Nahpa ba duhlda pur xchiꞌdxyi ba, niꞌchin nahpa gachi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ya chiꞌchi bachahnxihin raꞌ ba loh Jesuhs cun guyaꞌzi raꞌ ba loh Ñiꞌh, ya snuhn raꞌ ba gudahpa loh Ñiꞌh ");
INSERT INTO zpvNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ya rahbi raꞌ ba: ―Pwihsi yiꞌh ziga naa luꞌh Crixtu, guhcabwaꞌ chyuñin nin gudahpa loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ya gaduhbi nin zohba Pehdru laaꞌyitiaaꞌha xteenn rwaaꞌ yihdzi bixohza nin rnabwaꞌ chi, chiꞌchi badzihn tuhbi gunnaꞌh nin ruhnn dziꞌn riꞌchi ziga mooza, ya gwabiiga bi hasta zohba Pehdru chiꞌchi rahbi bi loh ba: ―Neezaa luꞌh gucaꞌnzanee luꞌh Jesuhs nin naa bwiinn guihdxyi Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per Pehdru guñiꞌ ba loh garaatiiꞌ raꞌ bwiinn raꞌ nin rii raꞌ riꞌchi rahbi ba: ―¡Ayi rahcabwaꞌn xiniꞌca cañiꞌ luꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ya lwehgu zee Pehdru nez rwaaꞌ yuuꞌ chi, nez chi bwaꞌha stuhbi bwiinn laꞌh ba ya rahbi bwiinn chi loh raꞌ snuhn raꞌ bwiinn: ―Nee ndxiꞌhw ca gucaꞌnzanee Jesuhs nin zeꞌ guihdxyi Nazaret. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ya chiꞌchi basaguiꞌhi Pehdru stuhbi hasta guñiꞌ chihpa ba rahbi ba: ―¡Ayi nuꞌnbwaꞌn bwiinn ca! ");
INSERT INTO zpvNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ya snuhn si rahca, bwiinn raꞌ nin rii riꞌchi gwabiiga raꞌ hasta zuu Pehdru ya rahbi raꞌ ba loh Pehdru: ―Guchii nee luꞌh naa luꞌh tuhbi xpwiinn Jesuhs, cun sola rluuꞌyi ziga rñiꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ya chiꞌchi guzoꞌbaloh caguꞌdii ba nee cañiꞌ chihpa ba rahbi ba: ―¡Ayi nuꞌnbwaꞌn laꞌh bwiinn ca! Pwihsi hohra chi gahca bacaꞌyahnn dxiidxinguhla, ");
INSERT INTO zpvNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ya chiꞌchi bagannastoꞌ Pehdru dxyiꞌdxyi raꞌ nin guñiꞌ Jesuhs loh ba rahbi Ñiꞌh: “Galoh nin gucaꞌyahnn dxiidxinguhla mas chohnna ziñiꞌ luꞌh ayi nuꞌnbwaꞌtiiꞌ luꞌh naꞌh”, ya hohra chi gahca bariaꞌh Pehdru riꞌchi guzoꞌbaloh cayuꞌn ba nalasa duxa. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ya chin barah gueꞌla, garaa raꞌ bwiinn raꞌ nin rnabwaꞌ raꞌ laꞌh raꞌ bixohza raꞌ cun bwiinn guuhla raꞌ xpwiinn Israel raꞌ bwiꞌhnn raꞌ ba dxyiꞌdxyi tin chiinn raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ya gwanee raꞌ ba laꞌh Ñiꞌh, yiꞌbiduꞌh Ñiꞌh nez loh Pilahtu, nin naa gobernador Romanu. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ya chiꞌchi laꞌh Judas nin batooꞌ laꞌh Jesuhs, chin bwaꞌha ba laꞌh Jesuhs guzee tin gachi Ñiꞌh, chiꞌchi guhca nalasa duxa stoꞌ ba, ya basiaꞌgarii ba gagahlda bitsiꞌh mweeyi plata nin gucaꞌha ba loh raꞌ bixohza raꞌ nin rnabwaꞌ raꞌ loh raꞌ bixohza raꞌ cun bwiinn guuhla raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Squiiꞌ rahbi Judas loh raꞌ ba: ―Guyuuꞌ duxa xtuꞌldahn laasii batooꞌhohn laꞌh tuhbi bwiinn nin ayi xi duhlda nahpa. Ya chiꞌchi rahbi raꞌ ba loh Judas: ―¿Xiilla mpoorta chiꞌh nu pur cweenta chi? ¡Cweenta chi naa xcweenta gahca luꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ya chiꞌchi balaꞌha Judas mweeyi raꞌ chi laꞌn guidoꞌ, ya bariaꞌh chiꞌh ba laꞌn guidoꞌ chiꞌchi gwagaxiꞌh yahnn ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ya chiꞌchi batiaaꞌha raꞌ bixohza raꞌ nin rnabwaꞌ loh raꞌ bixohza mweeyi chi, ya rahbi raꞌ ba: Mweeyi riiꞌ guyuuꞌdxiiman cun rihn; ayi nuu dxiuchaꞌyin hasta riuuꞌchaꞌyi mweeyi guelguhn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pwihsi loh nin guyaꞌloh bwiꞌhnn raꞌ ba lligaaba pur mweeyi chi chiꞌchi guziꞌ raꞌ ban taayii loh yuh xteenn tuhbi daada nin ruhnnchaꞌyi guihsu tin riꞌchi guigaꞌtsi raꞌ bwiinnziitu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pwihsi niꞌchin hasta laꞌn dxyih raꞌ riiꞌ laa yuh chi loh dahan rihn. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pwihsi squiiꞌ bariaꞌcaa dxyiꞌdxyi raꞌ nin guñiꞌ guehtu Jeremías tuhbi daada nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih chin rahbi ba: “Gucaꞌha raꞌ ba gahlda bitsiꞌh mweeyi plata, ziga si bazoꞌba raꞌ bwiinn Israel lasahca bwiinn ca, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ya cun mweeyi chi guziꞌ raꞌ ba yuh loh bwiinn nin ruhnnchaꞌyi guihsu zigapaꞌh nin gunabwaꞌ Dxiohs loon.” ");
INSERT INTO zpvNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pwihsi chin badzihnnee raꞌ ba laꞌh Jesuhs loh Pilahtu nin naa gobernador, gunaabadxyiꞌdxyi ba loh Jesuhs rahbi ba: ―¿Ta yiꞌh naa luꞌh rrehyi loh raꞌ bwiinn Israel? Chiꞌchi rahbi Jesuhs loh ba: ―Yiꞌh gahca guñiꞌ luꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ya loh nin riigacaꞌchiah dxixiꞌhw bixohza raꞌ nin rnabwaꞌ chi cun neezaa bwiinn guuhla raꞌ laꞌh Jesuhs ayi guñiꞌtiiꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ya chiꞌchi gunaabadxyiꞌdxyi Pilahtu loh Ñiꞌh rahbi ba: ―¿Tayi rihn luꞌh balaaca nin cañiꞌ raꞌ bwiinn pur yiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per cun ayi guñiꞌtiiꞌ Jesuhs nin tuhbi dxyiꞌdxyi, ya pur nin bwiꞌhnn Jesuhs squiiꞌ nin ayi rahcabwaꞌ Pilahtu xa ñuhnn ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ya garaa dxyih nin rahca lañih nahpa Pilahtu costumbre rutaꞌh ba tuhbi raꞌ bwiinn nin ñieꞌw laꞌn lahtsidxiꞌba, bwiinn nin rnaaba raꞌ bwiinn rlaꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","pwihsi laꞌn dxyih raꞌ chi ñieꞌw tuhbi bwiinn nin laa Barrabahs nin guzaꞌbi xchiꞌdxyi ñiꞌh pur dziꞌn dxaaba, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ya gunaabadxyiꞌdxyi Pilahtu loh raꞌ bwiinn raꞌ nin rigacaꞌchiah laꞌh Jesuhs rahbi ba loh raꞌ ba: ―¿Cuun bwiinn nin xclaaꞌdzi tu guhldaꞌhn: ta laꞌh Barrabahs o laꞌh Jesuhs nin naa Crixtu? ");
INSERT INTO zpvNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Laasii guhcabwaꞌ za Pilahtu laꞌh raꞌ ba batiꞌdxi raꞌ ba laꞌh Jesuhs loh ba pur nin rwaꞌha raꞌ ba ziahan bwiinn riachiistoꞌ raꞌ ñiꞌh laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ya gaduhbi nin zohba Pilahtu loh yagaxiiyi hasta ruhnn ba guelguxchisi, guxeꞌhla cheꞌhla ba rsohn loh ba rahbi ba squiiꞌ: ―Ayi xi gunnee luꞌh laꞌh bwiinn ca ayi xi xtuhlda ba, tin nabaa gueꞌla guñiꞌ xcaꞌldaꞌhn cohsa rooꞌ pur laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per laꞌh raꞌ bixohza raꞌ nin rnabwaꞌ raꞌ cun bwiinn guuhla raꞌ bachiꞌhyi raꞌ ba laꞌh raꞌ bwiinn raꞌ tin gunaaba raꞌ bwiinn gulaꞌh Barrabahs ya laꞌh Jesuhs gunaaba raꞌ ba gachi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ya chiꞌchi rahbi Pilahtu stuhbi: ―Ziga loh garoopa raꞌ bwiinn raꞌ riiꞌ, ¿cuun nin xclaaꞌdzi tu guhldaꞌhn? Chiꞌchi rahbi raꞌ ba: ―¡Laꞌh Barrabahs! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chiꞌchi gunaabadxyiꞌdxyi Pilahtu loh raꞌ bwiinn chi rahbi ba: ―Ya ¿cuun xchiꞌh nin xclaaꞌdzi tu cun guuneꞌhn Jesuhs, nin laa Crixtu? Chiꞌchi rahbi garaa raꞌ ba: ―¡Bacaꞌh ba loh cruhzi! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ya chiꞌchi rahbi Pilahtu: ―¿Per xi mahla bwiꞌhnn ba? Per ya laꞌh raꞌ ba mahzi ru jwersi rooꞌ gudihdxyidxiah raꞌ ba, rahbi raꞌ ba: ―¡Bacaꞌh ba loh cruhzi! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ya chin bwaꞌha Pilahtu ayi nuu xa guunn ba laasii riichihpa raꞌ bwiinn chi gaca nin xclaaꞌdzi raꞌ ba, hasta chaasa ru raꞌ ba cun dxixiꞌhw, chiꞌchi gunabwaꞌ Pilahtu gwacaꞌh tuhbi xpwiinn ba ñihsa tin gudxiꞌbi naa ba nez delanta loh raꞌ bwiinn ziahan chi ya rahbi ba loh raꞌ ba: ―Ayi xi duhlda naꞌpahn pur nin gachi bwiinn zaꞌca riiꞌ; xtuhlda tun laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chiꞌchi rahbi raꞌ bwiinn ziahan raꞌ chi: ―¡Laꞌh nu cun lliiꞌn raꞌ nu yihca nu tsiiba xquelguhchi bwiinn ca! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ya chiꞌchi bataꞌh Pilahtu laꞌh Barrabahs, lwehgu gunabwaꞌ ba gucaꞌyahga Jesuhs chiꞌchi batiꞌdxi ba laꞌh Ñiꞌh nez loh raꞌ xsuldahdu ba tin gucaꞌh raꞌ ba laꞌh Ñiꞌh loh cruhzi, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","per galoh Pilahtu gwanee raꞌ ba laꞌh Jesuhs hasta naa palasiu ya riꞌchi badiaaꞌha raꞌ ba garaa raꞌ ba gadiidxi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ya chiꞌchi guleꞌhe raꞌ ba xahba Jesuhs chiꞌchi bagahcu raꞌ ba laꞌh Ñiꞌh tuhbi lahdxi murahdu ");
INSERT INTO zpvNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ya yihca Ñiꞌh guluuꞌ raꞌ ba tuhbi curohn guihchi nin bwiꞌhnnchaꞌyi raꞌ ba cun tuhbi taaꞌha ñihta guluuꞌ raꞌ ba naa Ñiꞌh nin naa lahdu derehchu, chiꞌchi bazuꞌnllihbi raꞌ ba loh Ñiꞌh ya guzoꞌbaloh ballihdzinee raꞌ ba laꞌh Ñiꞌh rahbi raꞌ ba loh Ñiꞌh: ―¡Par tuꞌpazi guibahan xrrehyi raꞌ bwiinn Israel! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Neezaa bachahnxihin raꞌ ba loh Ñiꞌh, ya cun ñihta gahca nin nuu naa Ñiꞌh rdxiinn raꞌ ba yihca Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ya chin guyaꞌloh bwiꞌhnnee raꞌ ba laꞌh Ñiꞌh ziꞌchi, guleꞌhe raꞌ ba lahdxi murahdu nin bagahcu raꞌ ba laꞌh Ñiꞌh, chiꞌchi bagahcu gahca raꞌ ba nin naa xahba Ñiꞌh ya chiꞌchiyi zenee raꞌ ba laꞌh Ñiꞌh tin guicah Ñiꞌh loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ya chin zenee raꞌ ba laꞌh Ñiꞌh tin guicah Ñiꞌh loh cruhzi, loh neziuh badxaꞌga raꞌ ba tuhbi bwiinn guihdxyi Cirene nin laa Simohn, gunaꞌzu raꞌ ba laꞌh ba tin basaguꞌa raꞌ ba laꞌh ba xcruhzi Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ya chin badzihnnee raꞌ ba laꞌh Jesuhs tuhbi lahta hasta laa yihca bwiinn guuchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Riꞌchi badiꞌhi raꞌ ba vihnnu nin nuuchi ñihsa cwaꞌn naltaa ziah gwaaꞌ Jesuhs, per chin bwiꞌhnn Ñiꞌh prehban ayi gunnah Ñiꞌh ñeeꞌ Ñiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ya chin guyaꞌloh bacaꞌh raꞌ ba laꞌh Ñiꞌh loh cruhzi, chiꞌchi gudzihta raꞌ suldahdu baraja tin basaaꞌ raꞌ ba sweerta tin bigaꞌzi xahba Jesuhs gucaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ya chiꞌchi gurih raꞌ ba riꞌchi tin guhpa raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ya yihca xcruhzi Ñiꞌh bacaꞌh raꞌ ba dxyiꞌdxyi nin rñiꞌ xi pur guhchi Ñiꞌh, ya dxyiꞌdxyi chi rñiꞌ squiiꞌ: “Deeꞌ naa Jesuhs, xrrehyi raꞌ bwiinn Israel.” ");
INSERT INTO zpvNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Neezaa gucah schiohpa bwiinn gubaꞌn loh stuhbigah cruhzi cweꞌ xcruhzi Ñiꞌh, ya xcruhzi Ñiꞌh guzuh galaayi xcruhzi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ya garaa raꞌ bwiinn raꞌ nin rdiiꞌdxi nez chi rñiꞌbi raꞌ ba yihca raꞌ ba, chiꞌchi rñiꞌyah raꞌ ba laꞌh Ñiꞌh ");
INSERT INTO zpvNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","rahbi raꞌ ba loh Ñiꞌh: ―¿Tayi yiꞌh dxiꞌh nin nnaa luꞌh gucwih luꞌh guidoꞌ ya chohnna si dxyih dxiuꞌn zaꞌca luꞌhn? ¡Biehta loh cruhzi ca sidela guchii luꞌh laa luꞌh Lliiꞌn Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ya ziꞌchi gahca za ballihdzinee raꞌ bixohza raꞌ nin rnabwaꞌ loh raꞌ bixohza laꞌh Ñiꞌh cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs cun bwiinn guuhla raꞌ rahbi raꞌ ba loh Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Baldaꞌh ba paaldaa raꞌ bwiinn loh ziahan xica gueldxyihdxyi galoh, per nnah ayi nuu guhldaꞌh ba laꞌh gahca ba. Pwihsi sidela laꞌh ba naa ba rrehyi loh raꞌ bwiinn Israel, pwihsi ¡dxiehta ba loh cruhzi tin ziꞌchi chechiistoꞌ nuꞌh laꞌh ba! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nnah ba riachiistoꞌ ba Dxiohs, pwihsi ¡guhldaꞌh Dxiohs laꞌh ba sidela nadziiꞌhi Ñiꞌh laꞌh ba, laasii nnah za ba Lliiꞌn Dxiohs laꞌh ba! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nee hasta bwiinn gubaꞌn raꞌ nin caa loh schiohpa cruhzi cweꞌ xcruhzi Ñiꞌh ziꞌchi za guñiꞌ tohnta raꞌ ba loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Desde laaꞌyidxyih hasta xcachohnna gudxyih bacahyi loh gaduhbitiiꞌ guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hohr chi gahca guñiꞌ Jesuhs rahbi Ñiꞌh: ―¡Ayy Paah! ¿Xixnaa guleꞌhestoꞌ luꞌh naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ya paaldaa raꞌ bwiinn nin rii riꞌchi bihn raꞌ ba nin guñiꞌ Ñiꞌh ya rahbi raꞌ ba: ―Pwehda cabwihdxyi niꞌca laꞌh Elías. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ya hohra chi gahca bacaꞌh tuhbi raꞌ ba carrih zetooba ba tuhbi esponja tin guluꞌ ban loh vihnnu naltaa bacaꞌh ban yihca tuhbi ñihta tin bacaꞌh ban rwaaꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","per rahbi snuhn raꞌ ba: ―Basaaꞌn guidiaꞌha nuꞌh ta ziꞌ Elías dxieꞌgaldaꞌh laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ya chiꞌchi guñiꞌ Jesuhs jweersi rooꞌ stuhbi chiꞌchi guhchi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ya hohra chi bigaꞌllu lahdxyi rooꞌ nin zaꞌbi laꞌn guidoꞌ rooꞌ desde guiyaꞌ hasta laꞌn gueeta tin guhcan chiohpa taaꞌha, ya loh guidxyiyuh guhca lluh rooꞌ cun dxiahltah raꞌ gucahraꞌn bwih, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ya baꞌ raꞌ billaala raꞌn, ya ziahan raꞌ nin naa raꞌ xpwiinn Dxiohs babahn raꞌ ba loh guelguhchi hohra chi, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ya bariaꞌh raꞌ ba laꞌn baꞌ dxyih nin babahn za Jesuhs loh guelguhchi tin guyuuꞌtii raꞌ ba loh guihdxyi Jerusalehn nee bwaꞌha ziahan raꞌ bwiinn laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ya chin bwaꞌha capitahn Romanu cun garaa raꞌ nin zuunee ba cayahpa raꞌ ba laꞌh Jesuhs, cayahca lluh, cun garaa raꞌ nin cayahca hohra chi, bidxyihbi duxa raꞌ ba chiꞌchi rahbi raꞌ ba: ―¡Guchii bwiinn ca naa ba Lliiꞌn Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nee ziahan raꞌ za gunnaꞌh nin bachaꞌga xmweeyi ñiꞌh tin bwiꞌhnn raꞌ ba ayuhda laꞌh Jesuhs, bwiinn raꞌ riiꞌ zeꞌnee raꞌ ba laꞌhÑiꞌh desde guihdxyi Galilea rii raꞌ ba zihtu riiywaꞌha raꞌ ba nin cayahca riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Loh raꞌ gunnaꞌh raꞌ chi dxaꞌga María Magdalena cun María xmaah Jacobo cun xmaah Joseh cun xmaah lliiꞌn Zebedeu. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ya chin gurih gueꞌla, badzihn tuhbi ndxiꞌhw rricu nin laa Joseh bwiinn guihdxyi Arimatea ba, naa za ba tuhbi xpwiinn Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joseh riiꞌ gwaguiaꞌha ba loh Pilahtu tin gwaganaaba ba bweꞌltihxi Jesuhs ya lwehgu za gunabwaꞌ Pilahtu gudiꞌhi raꞌ ban laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chiꞌchi batehta Joseh laꞌh Ñiꞌh loh cruhzi, chiꞌchi batuꞌbi ba laꞌh Ñiꞌh tuhbi lahdxi sabna nayaa nin naa lahdxi linu, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","chiꞌchi bacaꞌtsi ba tihxi Jesuhs laꞌn tuhbi baꞌ dxiah cuubi nin naa xteenn ba, baꞌ chi gueꞌdu guyaꞌlohon. Ya chin guyaꞌloh bieꞌw rwaaꞌ baꞌ chi cun tuhbi dxiah rooꞌ, ziaa chiꞌh Joseh, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","per laꞌh María Magdalena cun stuhbi María biaꞌhan raꞌ ba rwaaꞌ baꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ya chin gudiiꞌdxi dxyih nin rahcachaꞌyi nin rahw raꞌ bwiinn Israel loh xlañih raꞌ ba, barah gueꞌla chi gwah raꞌ bixohza raꞌ nin rnabwaꞌ snuhn raꞌ bixohza cun bwiinn fariseu raꞌ loh Pilahtu, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tin rahbi raꞌ ba: ―Daada, riagannastoꞌ nu guñiꞌ bwiinn dxixiꞌhw chi chin nabahan ba nnaa ba: “Chin dxiohnna dxyih guhchiꞌhn zabahanahn loh guelguhchi”, ");
INSERT INTO zpvNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","niꞌchin nnah guxeꞌhla paaldaa xsuldahdu luꞌh chegapa rwaaꞌ baꞌ hasta chin gaca chohnna dxyih, tin ayi chee raꞌ xpwiinn ba gueꞌla chegaleꞌhe laꞌh ba, ya chiꞌchiyi gahbi raꞌ ba loh raꞌ bwiinn laꞌh ba babahan loh guelguhchi, tin ayi nnagah luulchima dxyiꞌdxyi dxixiꞌhw chi guunn gariaꞌcaa xiilla tuhbi yaꞌdxi rooꞌ loh nin guhca galoh. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chiꞌchi rahbi Pilahtu loh raꞌ ba: ―Laꞌh tu nahpa tu tuhbi cwaꞌh suldahdu; gulchenee raꞌ ba tin gulgasieꞌw dziꞌtsi rwaaꞌ baꞌ ziga naa dziꞌn zaꞌca nin ruhnn tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pwihsi gwah raꞌ ba tin basieꞌw dziꞌtsi raꞌ ba rwaaꞌ baꞌ chi cun bacaꞌhza raꞌ ba tuhbi sehyu xteenn gobernador loh dxiah nin bieꞌw rwaaꞌ baꞌ chi; ya basiaꞌhan raꞌ ba suldahdu raꞌ riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chin gudiiꞌdxi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, rsiiyidoꞌ mwer dxyih nin rzoꞌbaloh xmahn gwaguiaꞌha María Magdalena cun stuhbi María rwaaꞌ baꞌ hasta bigaꞌtsi Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","per laꞌtuhbi lluh rooꞌ guhcala hohrachi laasii hohra chi biehta tuhbi xaanjla Dxiohs nez llaaꞌndxibaaꞌ, ya badzihn aanjla chi rwaaꞌ baꞌ chi chiꞌchi gudooꞌba aanjla chi dxiah nin ñieꞌw rwaaꞌ baꞌ, chiꞌchi guzohba ba yihcan. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Xñah ba ziga zi tuhbi duꞌh guziꞌw, ya xahba ba xñah labwehtiiꞌ zigazi guiiꞌga, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ya chin bwaꞌha raꞌ suldahdu nin riiyahpa rwaaꞌ baꞌ chi loh aanjla chi bidxyihbi duxa raꞌ ba hasta biaꞌhan raꞌ ba ziga zi bwiinn guuchi raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ya chiꞌchi guñiꞌ aanjla chi loh raꞌ gunnaꞌh chi rahbi ba: ―Ayi guidxyihbi tu, naꞌh laꞌn guhcabwaꞌ rii gadxiꞌhyi tu laꞌh Jesuhs, nin guhchi loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ayi Ñiꞌh rii laꞌh Ñiꞌh babahn loh guelguhchi ziga gahca guñiꞌ Ñiꞌh. Nicala gultaaꞌguiaꞌha hasta bigaꞌtsi Ñiꞌh ayi la Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Guldxiaa nnahpaꞌh tin gulgahbi loh raꞌ xpwiinn Jesuhs laꞌh Ñiꞌh babahn loh guelguhchi, ya galoh ru Ñiꞌh guzee Ñiꞌh nez guihdxyi raꞌ xteenn Galilea que laꞌhtu; ya riꞌchi zwaꞌha tu loh Ñiꞌh; pwihsi deeꞌ naa dxyiꞌdxyi nin nahpa guiñiꞌn loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ya chiꞌchi ziaa raꞌ gunnaꞌh raꞌ chi carrih neezaa tuhbiꞌtuꞌhn bidxyihbi raꞌ ba cun neezaa riahxi duxa raꞌ ba tin gwaguihtsi galluꞌn raꞌ ba loh raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh nabahan, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ya hohra chi gahca baluuꞌyiloh Jesuhs loh raꞌ gunnaꞌh raꞌ chi, chiꞌchi bagahpaDxiohs Ñiꞌh laꞌh raꞌ ba, ya gwabiiga raꞌ gunnaꞌh chi hasta zuu Jesuhs gudiꞌdzi raꞌ ba ñaaꞌ Ñiꞌh bazuꞌnllihbi raꞌ ba loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Ayi guidxyihbi tu; gulcheguihtsi loh raꞌ bwiitsi raꞌn guzee raꞌ ba nez Galilea ya riꞌchi zwaꞌha raꞌ ba loon. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ya gaduhbi ziaa raꞌ gunnaꞌh raꞌ chi, gubiaꞌgarii raꞌ za paaldaa suldahdu raꞌ loh guihdxyi Jerusalehn tin gwaguihtsi raꞌ ba loh raꞌ bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza garaa raꞌ nin bwaꞌha raꞌ ba guhca rwaaꞌ baꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hohr chi gwah raꞌ bixohza raꞌ chi gwagañiꞌ raꞌ ba loh raꞌ bwiinn guuhla raꞌ xteenn bwiinn Israel raꞌ tin biaꞌhan dxyiꞌdxyi raꞌ ba xa guunn raꞌ ba, ya chiꞌchi badiꞌhi raꞌ ba mweeyi rooꞌ laꞌh raꞌ suldahdu raꞌ chi ");
INSERT INTO zpvNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ya rahbi raꞌ ba loh raꞌ suldahdu raꞌ chi: ―Squiiꞌ gulgahbi loh raꞌ bwiinn: “Bwiinn raꞌ nin naa raꞌ xpwiinn Jesuhs bieꞌgaleꞌhe bweꞌltihxi Jesuhs gaduhbi nin naꞌxgahsi nu”, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ya sidela laꞌh dxyiꞌdxyi gariaꞌca loh Pilahtu, laꞌh nu gachiñiꞌ nu loh ba ayi xi lligaaba guunn tu zachizuꞌhnee nu laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ya chiꞌchi gucaꞌha raꞌ suldahdu raꞌ chi mweeyi, ya bwiꞌhnn raꞌ ba ziga guhdzi raꞌ bwiinn chi loh raꞌ ba, ya ziga bachiꞌhyi raꞌ ba laꞌh raꞌ suldahdu guiñiꞌ raꞌ ba ziꞌchi za rñiꞌ raꞌ bwiinn Israel raꞌ hasta nnadxyih. ");
INSERT INTO zpvNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pwihsi gunaꞌzu nehza gadziꞌh bituhbi raꞌ xpwiinn Jesuhs tin gwah raꞌ ba nez guihdxyi Galilea, loh dahan nin guhdzi Jesuhs gadxaꞌga raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ya chin bwaꞌha raꞌ ba loh Jesuhs, bazuꞌnllihbi raꞌ ba loh Ñiꞌh nicala spaaldaa raꞌ ba ayi riachiistoꞌ raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ya chiꞌchi gwabiiga Jesuhs loh raꞌ ba tin rahbi Ñiꞌh loh raꞌ ba: ―Naꞌh lanaꞌpaa garaatiiꞌ guelrnabwaꞌ llaaꞌndxibaaꞌ cun loh guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","niꞌchin nnah gulchehnee xchiꞌdxyiꞌhn loh garaa raꞌ bwiinn guidxyiyuh tin gulguiꞌhn laꞌh raꞌ ba xpwiinn raꞌn cun gulgaroꞌbañihsa laꞌh raꞌ ba pur lah Daada Dxiohs cun lah Lliiꞌn Ñiꞌh, cun lah Spíritu Santu, ");
INSERT INTO zpvNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nee gulgaluuꞌyi laꞌh raꞌ ba guzoꞌbadxiahga raꞌ ba garaa raꞌ dxyiꞌdxyi raꞌ nin gunaꞌbwaꞌn loh tu, nee gulgacabwaꞌ za naꞌh laꞌn zuꞌnee laꞌh tu hasta chin gadzihn dxyih nin gaduhbi guidxyiyuh. Pwihsi guyaꞌloh dxyiꞌdxyi raꞌ nin bacaꞌh San Mateu pur Jesucristu. Ziꞌchi gaca pwihsi.");
INSERT INTO zpvNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Squiiꞌ guzaꞌloh dxyiꞌdxyi cuubi nin naa xcweenta Jesucristu, Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bacaꞌh guehtu Isaías squiiꞌ: Bwaꞌha ―rahbi Dxiohs loh Lliiꞌn Ñiꞌh― zixeꞌhlaꞌhn mwergaloh nin guiñiꞌ xchiꞌdxyiꞌhn, laꞌh ba guzee ñiidxiuu tin guunn zaꞌca ba xneziuh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ziuuꞌ ba tuhbi lahta loh dahan desiertu, ya jweersi rooꞌ zaꞌbi rsiaaꞌha guiñiꞌ ba rsiaaꞌha loh raꞌ bwiinn: “Gulguiꞌhnn zaꞌca xneziuh Dxiohs, gulguiꞌhnn derehchun.” ");
INSERT INTO zpvNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pwihsi biꞌ Jwahn tin baroꞌbañihsa ba laꞌh raꞌ bwiinn nez loh dahan desiertu, ya rahbi Jwahn: ―Gulgasaguuꞌdzi stoꞌ tu nee cun chioobaañihsa za tu, tin ziꞌchi gusiaꞌpitii Dxiohs xtuhlda tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ya laꞌh raꞌ bwiinn guihdxyi Jerusalehn cun garaa raꞌ bwiinn guihdxyi raꞌ nin rnabwaꞌ Judea biriaꞌh raꞌ ba tin zeegacaꞌdxiahga raꞌ ba dxyiꞌdxyi raꞌ nin rñiꞌ Jwahn, ya cun neezaa baxoꞌbaduhlda raꞌ ba garaa xtuhlda raꞌ ba, chiꞌchi baroꞌbañihsa Jwahn laꞌh raꞌ ba loh guiꞌw Jordahn. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nin guhca xahba Jwahn naa dxihdxi camehyu, neezaa biyiꞌbi duꞌh tuhbi duꞌhdxihdxi laꞌn tihxi Jwahn, ya nin gudahw Jwahn guhca bwiꞌtsisuu cun dzihn laꞌn dahan, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","neezaa rahbi Jwahn loh raꞌ bwiinn: ―Diꞌtsihn ziꞌ stuhbi bwiinn nin lasahcaru loon; ayi lasahcaꞌhn loh bwiinn nin dxiꞌ chi, hasta gacaꞌhn mooza nin cweꞌhe tahba ba ñaaꞌ ba ayi lasahcaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naꞌh ruroꞌbañiꞌsahn laꞌh tu cun ñihsa, per laꞌh ba cuꞌtii ba Spíritu Saantu laꞌn lastoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Laꞌn dxyih chigah raꞌ badzihn Jesuhs zeꞌ Ñiꞌh nez guihdxyi Nazaret distrihtu xteenn guihdxyi Galilea, ya baroꞌbañihsa Jwahn laꞌh Ñiꞌh loh guiꞌw Jordahn, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ya loh nin bariaꞌh Jesuhs loh ñihsa, bwaꞌha Ñiꞌh billaala dxibaaꞌ chiꞌchi biehta Spíritu Saantu yihca Jesuhs zigazi tuhbi palohmwiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hohr chi gahca bihn raꞌ ba tuhbi rsiaaꞌha guñiꞌ Dxiohs nez dxibaaꞌ rahbi Ñiꞌh: ―Yiꞌh naa luꞌh Lliiꞌnahn nin nadziiꞌhihn, nee riahxi duuxaꞌhn pur yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ya seguihdu gahca gwanee Spíritu Saantu laꞌh Jesuhs loh tuhbi dahan desiertu, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ya guyuuꞌ Ñiꞌh nez chi chwaꞌha dxyih chwaꞌha gueꞌla nez lahda raꞌ maan duuxa, ya gudxiꞌhyi bwiinndxaaba xa ñusaguiꞌhi ba laꞌh Jesuhs tin ayi ñuzoꞌbadxiahga Ñiꞌh xchiꞌdxyi Dxiohs, niꞌchin chin guyaꞌloh bwiꞌhnnee bwiinndxaaba laꞌh Ñiꞌh ziꞌchi, chiꞌchi badzihn raꞌ aanjla raꞌ tin gwanee raꞌ ba xlimentu Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yaque guyaꞌloh basieꞌw raꞌ ba laꞌh Jwahn nin ruroꞌbañihsa laꞌn latsidxiꞌba, chiꞌchi zee Jesuhs nez guihdxyi Galilea ya riꞌchi guzoꞌbaloh cagaluuꞌyi Ñiꞌh xchiꞌdxyi guelrnabwaꞌ xteenn Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","rahbi Ñiꞌh loh raꞌ bwiinn: ―Laꞌh dxyih nin bacaꞌhbwaꞌ Dxiohs badzihn, pronta guinabwaꞌ Ñiꞌh, niꞌchin gulgasaguuꞌdzi stoꞌ tu pur xtuhlda tu, ya gulchechiistoꞌ tu xchiꞌdxyi Dxiohs nin gutaꞌh laꞌh tu loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ya guyuuꞌ tuhbi dxyih zeezah Jesuhs rwaaꞌ ñisadoꞌ xteenn Galilea ya riꞌchi bwaꞌha Ñiꞌh chiohpa bwiinn rigalaꞌh raꞌ ba dxihxi bwehlda loh ñihsa; tuhbi ba laa Simohn ya stuhbi ba naa bwihtsi ba nin laa Andrehs, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gultaaꞌnaꞌhla naꞌh, tin desde nnahdxyih cwiidxi tu bwiinn raꞌ xcweenta xquelrnabwaꞌ Dxiohs xlawaaꞌha riateꞌhe tu bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hohrchi gahca basiaꞌhan raꞌ ba xchihxi bwehlda raꞌ ba ya chiꞌchi zeenee raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ya mas delaanta ru bwaꞌha Jesuhs laꞌh Jacobo cun laꞌh Jwahn lliiꞌn Zebedeu, rii raꞌ ba cweeꞌ laancha raꞌ ba cagadxihba raꞌ ba dxihxi bwehlda, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ya gudihdxyi Jesuhs laꞌh raꞌ ba tin chenaꞌhla raꞌ ba laꞌh Ñiꞌh, ya basiaꞌhan raꞌ ba Zebedeu xtaada raꞌ ba hasta zuu xlaancha ba cun xmooza ba, ya chiꞌchiyi zeenee Jacobo cun Jwahn laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chin badzihnnee raꞌ ba laꞌh Jesuhs guihdxyi Capernaum, chiꞌchi badzihn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel raꞌ, nee gwah Jesuhs laꞌn xquidoꞌ biꞌtiꞌhn raꞌ ba tin baluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ya badxyigaaꞌ loh raꞌ bwiinn chi ziga forma nin baluuꞌyi Ñiꞌh laꞌh raꞌ ba zigapaꞌh tuhbi bwiinn nin rnabwaꞌ, ayi ziga dxiꞌh ruhnn raꞌ mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","nee laꞌn guidoꞌ chi zuu tuhbi ndxiꞌhw nin guyuuꞌ tuhbi bwiinndxaaba stoꞌ ñiꞌh, ya gudidxyidxiah bwiinndxaaba nin nuu stoꞌ ndxiꞌhw chi rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¡Ayy, basaaꞌn laꞌh nu ayi xi guunnee luꞌh laꞌh nu, Jesuhs nin zeꞌ guihdxyi Nazaret! ¿Xixnaa zeꞌgañichiloh luꞌh laꞌh nu? ¡Naꞌh nuꞌnbwaꞌn yiꞌh, yiꞌh nin naa luꞌh Bwiinn Saantu nin guluꞌnehza Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chiꞌchi gudxyildxyineedxyiꞌdxyi Jesuhs laꞌh bwiinndxaaba chi rahbi Ñiꞌh: ―¡Bataꞌw rwaaꞌ luꞌh tin bariaꞌh stoꞌ bwiinn ca! ");
INSERT INTO zpvNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chin bihn bwiinndxaaba chi dxyiꞌdxyi raꞌ riiꞌ, gudxiindxiah bwiinndxaaba chi laꞌh ndxiꞌhw chi, chiꞌchi gudidxyidxiah bwiinndxaaba chi chin bariaꞌh ba stoꞌ bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ya garaa raꞌ ba badxyigaaꞌ loh raꞌ ba rahbi raꞌ ba: ―¿Xi niꞌca raꞌ? ¡Pwehda nacuubi raꞌ dxyiꞌdxyi raꞌ riiꞌ nin ruluuꞌyi ba, ya hasta bwiinndxaaba raꞌ ruzoꞌbadxiahga xchiꞌdxyi ba! ");
INSERT INTO zpvNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ya lwehgu bidiꞌchi dxyiꞌdxyi xcweenta nin bwiꞌhnn Jesuhs loh garaa raꞌ bwiinn guihdxyi raꞌ xteenn distrihtu Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chin bariaꞌh Jesuhs laꞌn guidoꞌ biꞌtiꞌhn chi, chiꞌchi zenee Ñiꞌh Jacobo cun Jwahn cun snuhn raꞌ xpwiinn Ñiꞌh yihdzi Simohn cun Andrehs, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ya xnaanswehgra Simohn jweertarooꞌ nuu ba lliaꞌh, ya chin badzihn Jesuhs chiꞌchi rahbi raꞌ ba loh Ñiꞌh nuu naaniꞌhn chi lliaꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","chiꞌchi guyuuꞌtii Ñiꞌh hasta naꞌ ba, ya gunaꞌzu Ñiꞌh naa ba tin gutestii Ñiꞌh laꞌh ba, ya hohra chi gahca bariaꞌh lliaꞌh chi tihxi naaniꞌhn chi, chiꞌchi gwastii ba tin bwiꞌhnnchaꞌyi ba nin gudahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ya hohra nin zohbayaꞌzi gubihdxyi, para cwih gueꞌla la hohra chi gwanee raꞌ bwiinn guihdxyi garaa raꞌ bwiinn nin rahcalluꞌhu cun nin nuu raꞌ bwiinndxaaba stoꞌ raꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ya badiaaꞌha gaduhbi guihdxyi raꞌ ba rwaaꞌ yuuꞌ hasta nuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ya basiaca Jesuhs garaaloh gueldxyihdxyi nin rahca raꞌ ziahan bwiinn, ya laasii nuꞌnbwaꞌ raꞌ bwiinndxaaba raꞌ chi chyu naa Jesuhs, niꞌchin nin ayi basaaꞌn Ñiꞌh ñiñiꞌ raꞌ bwiinndxaaba chi chyu naa Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ya chin barah gueꞌla, rsiiyidoꞌ run biriaꞌh Jesuhs guihdxyi chi tin gwah Ñiꞌh tuhbi lahta hasta ayi chyu bwiinn nuuꞌ tin gudihdxi-gunaaba Ñiꞌh laꞌh Xtaada Dxiohs Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ya seguihdu Simohn cun snuhn raꞌ xpwiinn Ñiꞌh bagadxiꞌhyi raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ya chin badxeela raꞌ ba laꞌh Ñiꞌh rahbi raꞌ ba loh Ñiꞌh: ―Ziahan raꞌ bwiinn xclaaꞌdzi gwaꞌha yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulchooꞌho guihdxyi raꞌ nin riaꞌhan raꞌ gahxu tin nahpa guluꞌyiꞌhn xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn guihdxyi raꞌ chi tin niꞌchin guluꞌnehza Dxiohs naꞌh loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ya ziꞌchi gucaꞌnzaa Jesuhs gaduhbi nehza guihdxyi Galilea tin baluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌn guidoꞌ biꞌtuꞌhn raꞌ xteenn raꞌ guihdxyi raꞌ nin rnabwaꞌ guihdxyi Galilea, neezaa babweꞌhe Ñiꞌh bwiinndxaaba raꞌ stoꞌ raꞌ nuu raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ya tuhbi dxyih, gwah tuhbi ndxiꞌhw nin rahchyi guiiꞌdxiu gaduhbitiiꞌ tihxi ñiꞌh loh Jesuhs, tin bazuꞌnllihbi ba nez loh Jesuhs ya chiꞌchi guñiꞌnalaasa ba loh Ñiꞌh rahbi ba: ―Naꞌh naꞌnnahn zuhnn luꞌh gahn gusiaca luꞌh naꞌh sidela ziziꞌguehlda luꞌh ―rahbi ndxiꞌhw chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ya balahsastoꞌ Jesuhs laꞌh ndxiꞌhw chi, chiꞌchi basagaꞌh Ñiꞌh naa Ñiꞌh tin cun naa Ñiꞌh bidxiꞌ Ñiꞌh tihxi ba chiꞌchi rahbi Ñiꞌh loh bwiinn chi: ―Xclaaꞌdzihn gusiaꞌcahn yiꞌh; laꞌluꞌh biaca. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ya chin guyaꞌloh guñiꞌ Ñiꞌh ziꞌchi lwehgu si guñichiloh gueldxyihdxyi chi tihxi ndxiꞌhw chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ya gunabwaꞌ Jesuhs loh ba ayi xi guuyitiiꞌ ba loh raꞌ bwiinn nin basiaca Ñiꞌh laꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","chiꞌchi rahbi Ñiꞌh loh ba: ―Sola chee luꞌh loh bixohza tin gwaꞌha ba laꞌluꞌh biaca, ya chin chaꞌloh gwaꞌha ba tihxi luꞌh, badiꞌhi tuhbi guelrgaaꞌda ziga rnabwaꞌ xlehyi Moisehs tin gacabwaꞌ raꞌ bwiinn laꞌluꞌh biaca. ");
INSERT INTO zpvNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per laꞌh ndxiꞌhw chi ayi gudxihpa stoꞌ ba, mahzi ru batiꞌchi ba dxyiꞌdxyi xcweenta nin basiaca Jesuhs laꞌh ba. Niꞌchin nin biaꞌhan Jesuhs loh dahan laasii ayi ñahca ñiuꞌgarii Ñiꞌh labwenutiiꞌ, laasii ñutaꞌwnaa raꞌ bwiinn laꞌh Ñiꞌh bwiinn garaa nehza nin zeeguiꞌha laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chin gudiiꞌdxi paaldaa dxyih, gubiaꞌgarii Jesuhs stuhbi loh guihdxyi Capernaum, ya bihn raꞌ bwiinn zuu Jesuhs laꞌn tuhbi yuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ya badiaaꞌha raꞌ ziahan bwiinn riꞌchi, ya hasta ayi ru nuu ñadzihn raꞌ ba rwaaꞌ pweerta xteenn yuuꞌ chi, ya laꞌh Jesuhs cagaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ya hohra paꞌh chi badzihnnee raꞌ tahpa bwiinn laꞌh stuhbi bwiinn naꞌ bwiinn chi loh tuhbi luꞌhn, ayi nuu ñiñiꞌbi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ya ndxiꞌhw raꞌ chi guclaaꞌdzi raꞌ ba ñiuꞌtii raꞌ ba hasta zuu Jesuhs, per ayi bidxeela raꞌ ba canehz ñiuꞌtiinee raꞌ ba laꞌh bwiinn nin rahcalluꞌhu chi laasii ziahan bwiinn rii riꞌchi, niꞌchin mejor gucah raꞌ ba yihca yuuꞌ, chiꞌchi baxaala raꞌ ba yihca yuuꞌ hasta batehta raꞌ ba laꞌh bwiinn nin rahcalluꞌhu chi cun xluꞌhn ba hasta nez loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ya chin bwaꞌha Jesuhs nin bwiꞌhnn raꞌ ba gwachiistoꞌ raꞌ ba laꞌh Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh ndxiꞌhw nin rahcalluꞌhu chi: ―Lliiꞌnahn, laꞌh xtuhlda raꞌ luꞌh basiaꞌpitiilahn. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Riꞌchi zohba raꞌ paaldaa raꞌ mwehsu nin ruluuꞌyi lehyi, ya bwiꞌhnn raꞌ ba lligaaba: ");
INSERT INTO zpvNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Xixnaa rñiꞌ ndxiꞌhw ca ziꞌca? ¡Cañiꞌyah ba laꞌh Dxiohs chin rñiꞌ ba squiiꞌ! ¡Tuhbidxiꞌh Dxiohs rusiaꞌpitii duhlda!” ");
INSERT INTO zpvNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ya laꞌh Jesuhs laꞌÑiꞌh guhcabwaꞌ xi lligaaba riiyuhnn raꞌ ba chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Cayahca naxihn yihca tu cun lligaaba nin riiyuhnn tu naꞌh cañiꞌyaan laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cuun nin ayi guinagahn gaꞌpihn loh ndxiꞌhw riiꞌ: “Laꞌxtuhlda luꞌh basiaꞌpitii Dxiohs”, laasii ayi nin tuhbi nin gwaꞌha gu rahcaꞌhn, per sidela gaꞌpihn: “Gwastii tin batiaaꞌha xluꞌhn luꞌh tin bwaa”, zahca gwaꞌha tu gu biaca bi o ayi biaca bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yannah tin gacabwaꞌ tu naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw nee naꞌpahn guelrnabwaꞌ loh guidxyiyuh tin gusiaꞌpitiin gallee xtuhlda tu, niꞌchin cañiꞌn loh bwiinn rahcalluꞌhu riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","rñiꞌn: “Gwastii tin batiaaꞌha xluꞌhn luꞌh tin bwaa yihdzi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ya hohra chi gahca gwastii ndxiꞌhw chi batiaaꞌha ba xluꞌhn ba ya nez delaanta loh gallee raꞌ bwiinn nin rii riꞌchi, ya bareꞌh ba laꞌn yuuꞌ chi, chiꞌchi badxyigaaꞌ duxa loh raꞌ bwiinn cun neezaa badiꞌhi raꞌ ba guelzuxchiilli laꞌh Dxiohs, rahbi raꞌ ba: ―¡Bayinnahsihn bidiaꞌhan nuꞌh tuhbi dziꞌn rooꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ya seguihdu gwah Jesuhs rwaaꞌ laguhn xteenn Galilea stuhbi, ya riꞌchi badiaaꞌha ziahan bwiinn, ya baluuꞌyi Jesuhs laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ya riꞌchi biriaꞌh Ñiꞌh tin zee Ñiꞌh stuhbi nehza, ya loh nin gudiiꞌdxi Jesuhs gahxu cweeꞌ tuhbi caseta xteenn impweestu bwaꞌha Ñiꞌh laꞌh tuhbi bwiinn nin laa Levih nin rsadxihlli impweestu, lliiꞌn Alfeu; zohba ba loh tuhbi yagaxiiyi, chiꞌchi rahbi Jesuhs loh ba: ―Gudaaꞌnaꞌhla naꞌh. Lwehgu si gwasuꞌnchii Levih ya zeenee ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ya tuhbi dxyih, gwanee Jesuhs laꞌh xpwiinn Ñiꞌh rwaaꞌ yihdzi Levih laasii baguhn ba gwatahw Jesuhs tuhbi guelwahw rwaaꞌ yihdzi ba, ya neezaa ziahan raꞌ nin rusadxihlli impwestu para Roma cun snuhn raꞌ bwiinn nin ayi ruzoꞌbadxiahga xlehyi guehtu Moisehs zohba raꞌ ba loh mweella cun Jesuhs tuhsi juunta cun garaa xpwiinn Ñiꞌh, ziahan za naa xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ya chin bwaꞌha raꞌ mwehsu nin ruluuꞌyi xlehyi Moisehs cun bwiinn fariseu raꞌ cayahwnee Jesuhs laꞌh raꞌ bwiinn chi, chiꞌchi rahbi raꞌ ba loh raꞌ xpwiinn Ñiꞌh: ―¿Xixnaa rahwnee xmwehsu tu laꞌh raꞌ bwiinn nin rusadxihlli impwestu cun bwiinn raꞌ nin ayi ruzoꞌbadxiahga xlehyi Moisehs? ");
INSERT INTO zpvNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chin bihn Jesuhs xi guñiꞌ raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Bwiinn raꞌ nin ayi xi rahca ayi xchiꞌhn raꞌ ba dutohra, mejor chee dutohra hasta rahcalluꞌhu raꞌ bwiinn; naꞌh ayi zeꞌldatiidxyidxiꞌhn laꞌh raꞌ bwiinn zaꞌca sino que zeꞌldahn tin cwiidxyihn laꞌh raꞌ bwiinn nin nuu xtuhlda raꞌ ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Guyuuꞌ tuhbi dxyih cagacwaaꞌhan raꞌ xpwiinn raꞌ Jwahn nin ruroꞌbañihsa cun xpwiinn raꞌ fariseu, niꞌchin gwah raꞌ paaldaa raꞌ bwiinn hasta zuu Jesuhs tin rahbi raꞌ ba loh Ñiꞌh: ―Xpwiinn raꞌ Jwahn cun xpwiinn raꞌ fariseu raꞌ rucwaaꞌhan raꞌ ba, ya xpwiinn raꞌ luꞌh ¿xixnaa ayi rucwaaꞌhan raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta zahca gucwaaꞌhan bioꞌza loh tuhbi saaꞌ gaduhbi nin riinee raꞌ ba laꞌh nuꞌbinbahyi? Ziꞌchilla naꞌh ayi nuu gucwaaꞌhan raꞌ xpwiiꞌnnraꞌn gaduhbi nin nuuneeraꞌn ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","per ziuuꞌ dxyih nin gucwaaꞌhan raꞌ ba chin cweꞌcaa raꞌ ba nin bachinaa. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sidela chezahnee raꞌ ba xcweenta dxyiꞌdxyi cuubi raꞌ nin ruluꞌyiꞌhn laꞌh raꞌ ba tuhsi cun costumbre yuꞌxa raꞌ nin ayi galluꞌyi, naa raꞌ ba ziga tuhbi bwiinn nin ruhnn rramieenda tuhbi lahdxicuubi cun tuhbi lahdxi yuꞌxa, pwihsi ayi nin tuhbi bwiinn nin ruhnn ziꞌchi laasii lahdxicuubi chi rgoꞌbañuhun lahdxiyuꞌxa chi ya mahzi ru rgaꞌllu zirooꞌ run, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","o, neezaa naa raꞌ ba ziga tuhbi dxihdxi yuꞌxa ya guidaꞌh vihnnu cuubi laꞌn dxihdxi chi ya cun bwih jweerta chi zichiezan dxihdxi yuꞌxa chi ya ziñichi vihnnu chi cun dxihdxi, niꞌchin mejor guidaꞌh vihnnu cuubi laꞌn dxihdxi cuubi. ");
INSERT INTO zpvNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nee tuhbi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, zeezahnee Jesuhs laꞌh xpwiinn Ñiꞌh nez loh yuh hasta naꞌ trihgu, ya bachywaꞌh raꞌ xpwiinn Ñiꞌh trihgu, chiꞌchi gulloꞌba raꞌ ban tin bireꞌh bwiiꞌdziꞌhn raꞌ chi gudahw raꞌ ban, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ya nuhn raꞌ bwiinn fariseu raꞌ nin rii nez chi bwaꞌha raꞌ ba nin cayuhnn raꞌ xpwiinn Jesuhs chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―¿Xixnaa ruhnn raꞌ xpwiinn luꞌh nin ayi naa xnehza guunn bwiinn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta nin tuhbi nagahdxi guꞌlda tu loh Xchihtsi Dxiohs hasta rñiꞌ xa bwiꞌhnn guehtu Davihd cun xpwiinn ba chin bichiaꞌhan raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pwihsi guyuuꞌtii Davihd laꞌn xquidoꞌ Dxiohs chin guhca guehtu Abiatar bixohza nin rnabwaꞌ laꞌh raꞌ bixohza, gucaꞌha Davihd pahn nin nuu laꞌn guidoꞌ chi, nee naa raꞌn ziga guhn nez loh Dxiohs ya laꞌh Davihd cun xpwiinn ba gudahw raꞌ ba pahn chi, nee zohba loh xchiꞌdxyi Dxiohs bixohza si gahw pahn chi. Chiꞌchi rahbi Jesuhs loh raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","―Dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn guhcan para bwiinn raꞌ, ayi bwiinn dxiꞌh para dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","niꞌchin naꞌh, ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, hasta nee dxyih nin ruziꞌlaaꞌdzi bwiinn naꞌpahn dxyiꞌdxyi guiñiꞌn cuun nin naa xnehza guunn bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Chin guhca stuhbi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel guyuuꞌtii Jesuhs laꞌn tuhbi guidoꞌ biꞌtiꞌhn, ya laꞌn guidoꞌ chi zohba tuhbi ndxiꞌhw nin gubihdzi naa ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ya cayahpa dziꞌtsi raꞌ bwiinn laꞌh Ñiꞌh gu zusiaca Jesuhs laꞌh bwiinn nin rahcalluꞌhu dxyih chi nin ruziꞌlaaꞌdzi raꞌ bwiinn laasii xclaaꞌdzi raꞌ ba chetachi raꞌ ba xquelchiah Ñiꞌh nezloh raꞌ bwiinn nin rnabwaꞌ laꞌh raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","chiꞌchi rahbi Jesuhs loh ndxiꞌhw nin gubihdzi naa ñiꞌh chi: ―Gwasuꞌnchii, tin gudaaꞌbiiga galaayi riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinn dxixiꞌhw chi: ―¿Cuun nin rusaaꞌn lehyi gaca dxyih nin raziꞌlaaꞌdzi nuꞌh? ¿Ta dziꞌn zaꞌca o dziꞌn dxaaba? ¿Ta zaldaꞌh nuꞌh bwiinn loh guelguhchi o zasaaꞌn nuꞌh gachi ba? Per laꞌh raꞌ bwiinn chi cun ayi guñiꞌtiiꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","chiꞌchi bwaꞌha nadxyiꞌchi Jesuhs loh raꞌ garaa raꞌ bwiinn nin rii gadiidxi Ñiꞌh ya guhca nalaasa stoꞌ Ñiꞌh laasii bwaꞌha Ñiꞌh ayi riaa lasaaꞌ raꞌ ba, chiꞌchi rahbi Ñiꞌh loh ndxiꞌhw nin gubihdzi naa ñiꞌh chi: ―Batsiꞌyi naa luꞌh. Ya chin batsiꞌyi naa ndxiꞌhw chi lwehgu si biaca naa ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ya laꞌh raꞌ bwiinn dxixiꞌhw raꞌ chi o sea bwiinn fariseu raꞌ biahca raꞌ ba tuhsi cun bwiinn raꞌ nin naa raꞌ xpartihdu Herodes tin bwiꞌhnn raꞌ ba lligaaba xa gadxiinn raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ya seguihdu zeenee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh rwaaꞌ laguhn xteenn Galilea, ya zeenaꞌhla raꞌ ziahan bwiinn laꞌh Ñiꞌh laasii rihnn raꞌ ba ruhnn Ñiꞌh ziahan dziꞌn rooꞌ nee xclaaꞌdzi raꞌ ba gwaꞌha raꞌ ba dziꞌn roo raꞌ nin ruhn Ñiꞌh. Bwiinn raꞌ chi guhca raꞌ bwiinn guihdxyi Galilea cun bwiinn guihdxyi Jerusalehn cun ziahan ru raꞌ bwiinn guihdxyi Judea cun bwiinn guihdxyi Idumea, bwiinn stuhbi lahdu guiꞌw Jordahn, cun bwiinn guihdxyi Tiru cun Sidohn. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ya basiaca Jesuhs ziahan raꞌ bwiinn nin rahcalluꞌhu raꞌ, ya tantu guclaaꞌdzi raꞌ ba ñidxiꞌ raꞌ ba tihxi Jesuhs tin dxiaca raꞌ ba niꞌchin hasta bacaꞌhnaa lasaaꞌ raꞌ ba tin ñabiiga raꞌ ba gahxu cweeꞌ Jesuhs, niꞌchin nin rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh tin batsiiga raꞌ ba tuhbi laancha mahs balaaquiꞌhn nez loh ñihsa tin ayi ñidxiꞌ ru raꞌ bwiinn laꞌh Ñiꞌh nee ayiza xa ñuteꞌh raꞌ bwiinn laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ya guyuuꞌ raꞌ paaldaa raꞌ bwiinn nin guyuuꞌ raꞌ bwiinndxaaba stoꞌ raꞌ ñiꞌh, ya chin zeebiiga raꞌ ba nezloh Jesuhs ruzuꞌnllihbi raꞌ ba nezloh Ñiꞌh ya jweersi rooꞌ rbwihdxyidxiah raꞌ ba rahbi raꞌ ba: ―¡Yiꞌh naa luꞌh Lliiꞌn Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per laꞌh Jesuhs gunabwaꞌ Ñiꞌh laꞌh raꞌ bwiinndxaaba raꞌ chi tin ayi ñiñiꞌ raꞌ ba chyu naa Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ya chiꞌchi gucah Jesuhs yihca tuhbi dahan, ya riꞌchi gudihdxyi Ñiꞌh laꞌh raꞌ paaldaa raꞌ bwiinn nin rclaaꞌdzi Ñiꞌh tin gusiꞌdxi Ñiꞌh laꞌh raꞌ ba, ya chin badzihn raꞌ ba hasta zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","gulii Ñiꞌh laꞌh raꞌ gadziꞌh bichiohpa raꞌ bwiinn nin gaca xpooxtla Ñiꞌh tin bwiꞌhnn raꞌ ba cumpahñu laꞌh Ñiꞌh, ya rahbi Ñiꞌh loh raꞌ ba: ―Naꞌh cuꞌneezahn laꞌh tu tin chegaluuꞌyi tu xchiꞌdxyi Dxiohs garaa raꞌ guihdxyi. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nee badiꞌhi za Ñiꞌh guelrnabwaꞌ laꞌh raꞌ ba tin basiaca raꞌ ba laꞌh raꞌ bwiinn raꞌ nin rahcalluꞌhu cun nin basaꞌcazii raꞌ bwiiinndxaaba basiaca raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ya loh gadziꞌh bichiohpa raꞌ xpwiinn Ñiꞌh guhca raꞌ Simohn nin guleꞌhelah Ñiꞌh Pehdru; ");
INSERT INTO zpvNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo cun Jwahn lliiꞌn Zebedeu, nin bireꞌhlah raꞌ ziga apodo Boanerges, ya nin zee dxyiꞌdxyi riiꞌ naa lliiꞌn duꞌh guziꞌw; ");
INSERT INTO zpvNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrehs, Felipe, Bartolomeh, Mateu, Tomahs, Jacobo lliiꞌn Alfeu, Tadeu cun neezaa Simohn nin guyuuꞌ lahda raꞌ cananista, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","cun Judas Iscariote, nin batooꞌ laꞌh Jesuhs loh raꞌ bixohza. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ya chiꞌchi biuꞌgariinee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh tuhbi yuuꞌ, ya stuhbi laꞌgaꞌh badiaaꞌha ziahan rooꞌ bwiinn riꞌchi, ya nin ayi nuu xa ñahwnee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chin bihn raꞌ lasaaꞌ Jesuhs ziꞌchi cazahca Ñiꞌh, gwaguiꞌha raꞌ ba cuun Ñiꞌh laasii bwiꞌhnn raꞌ ba lligaaba cacheꞌh loh xigaaba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","neezaa mwehsu raꞌ nin ruluuꞌyi lehyi nin zeꞌ raꞌ guihdxyi Jerusalehn rahbi raꞌ ba: ―Belzebuu nin rnabwaꞌ laꞌh raꞌ bwiinndxaaba cayahcanee laꞌh ndxiꞌhw riiꞌ niꞌchin rahca rabweꞌhe ba bwiinndxaaba stoꞌ raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chiꞌchi gudihdxyi Jesuhs laꞌh raꞌ ba tin guñiꞌ Ñiꞌh loh raꞌ ba rahbi Ñiꞌh: ―¿Xa guunn Belzebuu gabweꞌhe ba laꞌhgahca lasaaꞌ bwiinndxaaba nin rnabwaꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sidela laꞌh tuhbi gubieerna cwachi raꞌ ba partihdu tin childxinee lasaaꞌ raꞌ ba, pwihsi nahpa ziñichiloh guelrnabwaꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ziꞌchigahca za sidela laꞌh tuhbi famihyi bwiinn childxinee lasaaꞌ raꞌ ba pwihsi laꞌh famihyi chi ayi chuuꞌhun xchih, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ya ziꞌchi za sidela laꞌh Belzebuu rabweꞌhe laꞌh raꞌ bwiinndxaaba, ayiza chuu xchih xquelrnabwaꞌ ba laasii lwehgu chaꞌloh xquelrnabwaꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ayi nuu chyu chuꞌtii yihdzi tuhbi bwiinn nin nuu zirooꞌ xjweersi ñiꞌh tin cwaan ba; sola nin guunn ba galoh guchiꞌbiduꞌh ba laꞌh bwiinn chi ziꞌchisihn zuhnn ba gahn cwaan ba xixteenn bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Gulgacaꞌdxiahga nin guiñiꞌn loh tu: nicala chyulla guiñiꞌyah laꞌh Dxiohs o chuu xtuhlda bwiinn chi, zahca gusiaꞌpitii Ñiꞌh xtuhlda ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","per sidela chyuulla guiñiꞌyah laꞌh Spíritu Saantu Dxiohs zahca ba tuhbi bwiinn duhlda duxa ya nin ayi gusiaꞌpitii Dxiohs xtuhlda bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Squiiꞌ guñiꞌ Jesuhs laasii rahbi raꞌ bwiinn dxixiꞌhw chi cayahcanee bwiinndxaaba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Ya xmah Jesuhs cun bwihtsi raꞌ Ñiꞌh badzihn raꞌ ba hasta cagaluuꞌyi Ñiꞌh, per ayi guhca ñabiiga raꞌ ba hasta zuu Ñiꞌh laasii dxiꞌbi ziahan raꞌ bwiinn rii riꞌchi, niꞌchin guyuuꞌ nin badiꞌhi rsohn laꞌh raꞌ bwiinn nin zohba gadiidxi cweeꞌ Jesuhs rahbi raꞌ ba loh Ñiꞌh: ―Xmah luꞌh cun bwihtsi raꞌ luꞌh rii raꞌ dihtsi jwehra xclaaꞌdzi raꞌ ba guiñiꞌ raꞌ ba loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinn chi: ―¿Cuun nin naa xmaaꞌhn cun bwiꞌtsi raꞌn? ");
INSERT INTO zpvNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chiꞌchi bwaꞌha dziꞌtsi Ñiꞌh loh raꞌ garaa raꞌ bwiinn nin zohba gadiidxi Ñiꞌh, chiꞌchi rahbi Ñiꞌh: ―Rii laꞌh raꞌ nin naa raꞌ ziga xmaaꞌhn cun ziga bwiꞌtsi raꞌn riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","pwihsi chyu chiꞌh zi bwiinn nin guunn nin xclaaꞌdzi Dxiohs gaca, niꞌchi naa ziga bwiꞌtsihn, bizaaꞌnahn, cun xmaaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Stuhbi bweelta guzoꞌbaloh cagaluuꞌyi Jesuhs laꞌh raꞌ bwiinn rwaaꞌ laguhn xteenn Galilea, ya badiaaꞌha ziahan bwiinn riꞌchi, niꞌchin gucah Ñiꞌh laꞌn tuhbi laancha nin zuu rwaaꞌ laguhn chi tin gwabiigan loh ñihsa, ya rwaaꞌ laguhn chi badiaaꞌha raꞌ ba tin bacaꞌdxiahga raꞌ ba nin guñiꞌ Ñiꞌh loh raꞌ ba hasta laꞌn laancha nin zohba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ya bwiiꞌyidxyiꞌdxyi Ñiꞌh ziahan raꞌ dxyiꞌdxyi loh raꞌ ba per cweenta raꞌ zi, ya loh cayuuꞌyidxyiꞌdxyinee Ñiꞌh laꞌh raꞌ ba rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gulgacaꞌdxiahga: tuhbi ndxiꞌhw biriaꞌh ba zeetachi ba biñih, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ya gaduhbi zeezah ba biaaba nuhnan loh nezyuh, ya gudahw raꞌ maaniꞌhn raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ya snuhnan biaaba lahda dxiah hasta nuu gulliaaꞌ yuh, ya chin gutahnan, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","lwehgu gahca bacwihdzi gubihdxyi laꞌhan laasii ayi guyuuꞌ xtulbaaꞌhan gueeta loh yuh niꞌchin gubihdzin, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ya snuhnan biaaba laꞌn dulbaaꞌ xteenn yaguihchi raꞌ, ya chin gurooꞌru yaguihchi raꞌ chi bwiꞌhnn bacaalan niꞌchin ayi xi liꞌhn badiꞌhi bwiiꞌdzi biñih chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ya snuhnan biaaba loh yuh zaꞌca, niꞌchiyi gurooꞌ gucah tuhbin ziga treinta lloobwiꞌhn tihxin ya stuhbin nalayila gucah llooba tihxi ñihza xteenn tuhbigah lloobwiꞌhn nin gurih loh yuh, ya stuhbin gucah ziahan llooba tihxi tuhbigah ñihza nin naa tuhbi llooba biñih chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Sidela riuuꞌ tu riaꞌzi tu dxyiꞌdxyi raꞌ riiꞌ, gulgacaꞌdxiahgan. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ya chin badiꞌchi raꞌ nuhn bwiinn ziahan raꞌ chi, chiꞌchi gwabiiga gadziꞌh bichiohpa xpwiinn Ñiꞌh cun spaaldaa raꞌ bwiinn nin zenaꞌhla laꞌh Ñiꞌh tin gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh xi zee loh dxyiꞌdxyi raꞌ nin baluuꞌyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh tu Dxiohs rñiꞌ loh tu tin gacabwaꞌ tu cohsa raꞌ xteenn xquelrnabwaꞌ Ñiꞌh; per laꞌh raꞌ bwiinn nin ayi xclaaꞌdzi dxieꞌnaꞌhla naꞌh niꞌchin nin rñiꞌn cweenta raꞌ si loh raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","laasii nicala dxihn raꞌ ba nin rñiꞌn nee gwaꞌha raꞌ ba per ayi gacabwaꞌ raꞌ ba nee nin ayi gusiaꞌpitii Dxiohs xtuhlda raꞌ bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Tayi rahcabwaꞌ tu dxyiꞌdxyi raꞌ riiꞌ? ¿Xaalla gacabwaꞌ chiꞌh tu snuhn raꞌn? ");
INSERT INTO zpvNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ndxiꞌhw nin bwiꞌhnn biñih chi naa ziga nin ruluuꞌyi xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ya nuu raꞌ bwiinn nin naa raꞌ ziga biñih nin biaaba loh neziuh rihnn raꞌ ba xchiꞌdxyi Dxiohs, per chin babihnn raꞌ ban chiꞌchi zeꞌ bwiinndxaaba mahziru rusiaꞌpitii ba xchiꞌdxyi Dxiohs nin nabiñih stoꞌ bwiinn chi tin dxiaꞌldastoꞌ ba xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ya snuhn raꞌ bwiinn naa ziga biñih nin biaaba lahda dxiah hasta nuu gulliaaꞌ yuh, niꞌchi raꞌ naa ziga bwiinn raꞌ nin rucaꞌdxiahga raꞌ xchiꞌdxyi Dxiohs ya gucaꞌha raꞌ ban cun guuxta, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per coma naa raꞌ ba zigazi biñih nin ayi ziahan xtulbaaꞌ ñiꞌh, niꞌchin ayi riazah zaꞌca raꞌ ba ziga naa xnehza, niꞌchilan chin rzaꞌcazii raꞌ ba pur xchiꞌdxyi Dxiohs o chin rreꞌgunaꞌhla bwiinn raꞌ laꞌh raꞌ ba, ya cun rbweꞌhestoꞌ raꞌ ba xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ya snuhn raꞌ ba naa ziga biñih nin biaaba lahda raꞌ yaguihchi; niꞌchi raꞌ naa ziga bwiinn raꞌ nin rcaꞌdxiahga zi xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ya mahzi ru riuuꞌ raꞌ ba guelrzaaꞌ xica raꞌ cohsa xteenn guidxyiyuh riiꞌ cun rzaꞌbi stoꞌ raꞌ ba gapa raꞌ ba mweeyi nin rusaguiꞌhi laꞌh raꞌ bwiinn cun rzaꞌbiza stoꞌ raꞌ ba gapa raꞌ ba garaaloh cohsa raꞌ nin rbweꞌhecaa xchiꞌdxyi Dxiohs laꞌn lastoꞌ raꞌ ba ya lliaaꞌ si rahca ziga bihndxiahga raꞌ ba xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ya nuu za raꞌ bwiinn nin ruzoꞌbadxiahga xchiꞌdxyi Dxiohs nee riachiistoꞌ raꞌ ban, naa raꞌ ba ziga tuhbi ñihza nin rcah ziga treinta llooba, o ziga ñihza nin gucah mas garooldallee llooba tihxi ñiꞌh o nin gucah ziahan llooba tihxi ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Rahbi za Jesuhs loh raꞌ ba: ―Ayi nin tuhbi nin gucaꞌdxih tuhbi biaꞌñih ralaꞌn nee chuulaꞌnan laꞌn tuhbi caja o zuuꞌhun llaaꞌn tuhbi luꞌhn; mas chaꞌyi zaꞌbin guiyaꞌ tin guziaꞌñih zaꞌcan. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ziꞌchi gahca za ayi nin tuhbi cohsa nin chuulaꞌn nahpa zadzihn dxyih nin gwaꞌha raꞌ ba xiñin, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","niꞌchin nin zohballaala dxiahga ñiꞌh gulgacaꞌdxiahga. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Neezaa rahbi Jesuhs: ―Gulguiaꞌha loh nin rihn tu, cun madxihdu gahca nin rudiꞌhi tu Dxiohs guniꞌhi mahzirun ziga madxihdu chi laꞌh tu neezaa zuniꞌhi Ñiꞌh ziahanrun laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pwihsi nin nahpan, ziahanrun guicaꞌha, per nin ayi xi nahpa hasta nin ruhnn ba lligaaba naa xteenn ba ziriaꞌhalluꞌhun loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Neezaa rahbi Jesuhs: ―Ziga naa xquelrnabwaꞌ Dxiohs naa ziga biñih nin ruhnn biñih tuhbi bwiinn loh yuh, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","para laꞌh bwiinn chi zeezah chiꞌzi xquelnabahan ba ziga guillii-guillii ruhnn ba dziꞌn cun rahsi ba gaduhbi nin rtahn biñih cun rrooꞌhon nin ayi gaann ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","laasii laꞌh yuh chi ruchiooꞌ laꞌhan; rtahnan ziga tuhbi cwaꞌn nagaa, rrooꞌhon, rahcan doh, ya seguihdu rahcan llooba. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ya chin laꞌn naa llooba para gacan guehta, lwehgu rusiaꞌpitii ba liꞌhn chi laasii laꞌh dxyih badzihn nin chapitiiꞌhin. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Chiꞌchi rahbi Jesuhs: ―¿Cuun nin rñah ziga rñah xquelrnabwaꞌ Dxiohs, o xi tuhbi cweenta nin galuuꞌyi nuꞌh xa naaꞌhan? ");
INSERT INTO zpvNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naan ziga tuhbi bwiiꞌdzi mortahsa nin rahca biñih loh yuh, nee bwiiꞌdzi chi naa biꞌtuꞌhnru loh raꞌ garaa bwiiꞌdzi nin nuu gaduhbi guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","rahca biñihin, rrooꞌhon, ya loh yahga chi ruhnn raꞌ maaniꞌhn xpichieeza raꞌ ma laꞌn xpacaalan. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ya bwiiꞌyidxyiꞌdxyi Jesuhs ziahan cweenta loh raꞌ bwiinn hasta guhcabwaꞌ raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","nee garaa xpwiinn Ñiꞌh chin biaꞌhannee Ñiꞌh laꞌh si raꞌ ba, chiꞌchi bwiiꞌyidxyiꞌdxyi Ñiꞌh loh raꞌ ba; per loh raꞌ bwiinn zi ayi gudxixteeꞌ Ñiꞌh xa naa cweenta raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ya gudxyih dxyih chi gahca, rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Gulchooꞌho choo nuꞌh stuhbi lahdu rwaaꞌ ñihsa ca. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ya guyuuꞌtii raꞌ ba laꞌn laancha hasta zohba Jesuhs, ya basiaꞌhan raꞌ chi ba laꞌh raꞌ bwiinn ziahan raꞌ chi, ya zee raꞌ chiꞌh ba tuhbi loh ñihsa cun neezaa spaaldaa raꞌ laancha zeenee laꞌh raꞌ ba stuhbi lahdu rwaaꞌ ñihsa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ya gaduhbi zeezah raꞌ ba loh ñihsa guzoꞌbaloh tuhbi bwih rooꞌ guteesa bwih chi ñihsa ya guyuuꞌtii ñihsa laꞌn laancha. ");
INSERT INTO zpvNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Gaduhbi naꞌllgahsi Jesuhs laꞌn laancha chi nucuꞌga Ñiꞌh tuhbi almahdu, chiꞌchi bacwaꞌhn raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh, rahbi raꞌ ba: ―¡Mwehsu! ¡Laꞌnuꞌh cazaꞌbi ñihsa nee para yiꞌh zigazi ayi xi cayahcatiiꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chiꞌchi lwehgu gwastii Jesuhs tin guñiꞌ Ñiꞌh loh bwih chi cun loh ñihsa tin guridxyii raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―¿Xixnaa rdxyihbi duxa tu? ¿Xixnaa ayi riachiistoꞌ tu Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ya rdxyihbi duxa raꞌ ba chiꞌchi gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba rahbi raꞌ ba: ―¿Chyuulla naa bwiinn riiꞌ? ¡Hasta bwih cun ñihsa ruzoꞌbadxiahga xchiꞌdxyi ba! ");
INSERT INTO zpvNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ya badzihn raꞌ ba loh yuh xteenn Gadara nin rii stuhbi lahdu rwaaꞌ ñihsa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","bariaꞌh Jesuhs laꞌn barcu, lwehgu badxiꞌloh Ñiꞌh laꞌh tuhbi ndxiꞌhw nin nuu bwiinndxaaba stoꞌ ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ya guyuuꞌ bwiinn chi lahda raꞌ baꞌ. Guhca yoꞌba duxa xigaaba ba ya nin tuhbi ayi chyu bwiꞌhnn gahn ñuchiꞌbiduꞌh laꞌh ba cun cadehn. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ziahan la guhcaduꞌh prohbi bwiinn chi cun cadehn, cun dxiꞌba raꞌ nin rchiꞌbi suldahdu naa bwiinn, per laꞌh ba bachyuuꞌga ban pur xquelnadxipa bwiinndxaaba nin nuu stoꞌ ba, ya ayi chyu bwiꞌhnn gahn ñusacwaꞌchidxyii stoꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ya dxyih nagueꞌla caꞌnzaa ba caꞌnbwihdxyidxiah ba loh dahan cun lahda baꞌ raꞌ, cun neezaa gudxiꞌldxihdxyi ba laꞌh gahca ba cun dxiah, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ya zihturooru bwaꞌha bwiinn nin guyuuꞌ bwiinndxaaba chi stoꞌ ñiꞌh laꞌh Jesuhs, niꞌchin balluꞌn ba gwah ba nez loh Ñiꞌh bazuꞌnllihbi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","chiꞌchi guñiꞌ ba jwersi, rahbi ba: ―¿Xix zeꞌ luꞌh riiꞌ, Jesuhs Lliiꞌn Dxiohs nin nuu nabahan dziꞌtsi dxibaaꞌ? ¡Rdxiꞌnaꞌhn loh luꞌh ayi gusaꞌcazii luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Guñiꞌ bwiinndxaaba chi squiiꞌ laasii guñiꞌ Jesuhs: ―¡Bariaꞌh stoꞌ bwiinn ca bwiinndxaaba! ");
INSERT INTO zpvNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh bwiinndxaaba chi rahbi Ñiꞌh: ―¿Chyu laa luꞌh? Chiꞌchi rahbi ba: ―Legiohn. Rahbi ba ziꞌchi laasii ziahan bwiinndxaaba naa raꞌ ba nuu raꞌ ba stoꞌ bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ya gunaaba raꞌ bwiinndxaaba chi tin ayi guixeꞌhla Jesuhs laꞌh raꞌ ba stuhbi guihdxyi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","niꞌchin nez chi riiyahw nuhn cuuchi loh dahan gahxu nez zuunee Jesuhs laꞌh bwiinn nin nuu bwiinndxaaba chi stoꞌ ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ya gudxiꞌhn raꞌ bwiinndxaaba chi tin gusaaꞌn Jesuhs chuꞌtii raꞌ bwiinndxaaba chi stoꞌ raꞌ cuuchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ya chin guziꞌguehlda Jesuhs chuꞌtii raꞌ bwiinndxaaba chi stoꞌ raꞌ cuuchi, chiꞌchi bariaꞌh raꞌ bwiinndxaaba chi stoꞌ bwiinn chi tin guyuuꞌtii raꞌ ba stoꞌ cuuchi, ya naa raꞌ cuuchi chi ziga chiohpa mihyi, ya gwatsiꞌbichii raꞌ cuuchi chi rwaaꞌ tuhbi gueeꞌla riꞌchi gwaaꞌñihsa raꞌ cuuchi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ya chin bwaꞌha raꞌ nin cayahpa laꞌh raꞌ cuuchi chi niꞌchi lwehgu balluꞌn raꞌ ba gwaguihtsi raꞌ ba loh raꞌ bwiinn guihdxyi cun bwiinn rraandxu raꞌ, biriaꞌh raꞌ bwiinn tin gwaguiaꞌha raꞌ ba nin guhca riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ya chin badzihn raꞌ ba nez zuu Jesuhs, bwaꞌha raꞌ ba laꞌh bwiinn nin bariaꞌh bwiinndxaaba raꞌ stoꞌ ñiꞌh laꞌba zohba, nahcu ba lahdxi ayi xi rahca ru yihca ba, niꞌchin bwiinn raꞌ nin bwaꞌha raꞌ niꞌchi bidxyihbi duxa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ya bwiinn raꞌ nin bwaꞌhaloh xa guhca, bwiiꞌyidxyiꞌdxyi raꞌ ba xa basiaca Jesuhs laꞌh ndxiꞌhw nin guyuuꞌ bwiinndxaaba xtoꞌ ñiꞌh chi cun ziga guzaꞌca raꞌ cuuchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ya garaa raꞌ ba gunaaba raꞌ ba dxiuuꞌnehza Jesuhs guihdxyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ya chin biuuꞌgarii Jesuhs laꞌn laancha, chiꞌchi gunaaba ndxiꞌhw nin bariaꞌh bwiinndxaaba raꞌ stoꞌ ñiꞌh loh Jesuhs tin ñiziꞌguelda Ñiꞌh ñanaꞌhla ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","per laꞌh Ñiꞌh gunabwaꞌ Ñiꞌh dxiaꞌhan si ba, ya rahbi Ñiꞌh loh ba: ―Babiaꞌgarii rwaaꞌ yihdzi luꞌh tin batiꞌchi dxyiꞌdxyi loh raꞌ lasaaꞌ raꞌ luꞌh loh raꞌ xamihgu luꞌh garaa nin bwiꞌhnneen yiꞌh nee neezaa nin balahsastoꞌn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ya ziaachiꞌh ba, tin batiꞌchi ba dxyiꞌdxyi loh guihdxyi Decápolis pur bwen nin bwiꞌhnn Jesuhs laꞌh ba, ya garaa raꞌ bwiinn chi badxyigaaꞌ duxa loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chin babiaꞌgarii Jesuhs stuhbi lahdu rwaaꞌ ñihsa chi, badiaaꞌha raꞌ ziahan raꞌ bwiinn riꞌchi, ya rwaaꞌ ñihsa chi zuu Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","hohr nin badzihn tuhbi ndxiꞌhw nin laa Jairu, bwiinn chi guhca tuhbi nin rnabwaꞌ tuhbi guidoꞌ biꞌtiꞌhn, ya bazuꞌnllihbi ba nezloh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","chiꞌchi guñiꞌ nalaasa ba, tin gunaaba ba chenee ba laꞌh Jesuhs rwaaꞌ yihdzi ba ya rahbi ba: ―Lliiꞌndxaꞌpaꞌhn ya mweerla gachi; bwiꞌhnn tuhbi bwen yoꞌho choo nuꞌh tin gudziiꞌba naa luꞌh yihca bi tin dxiaca bi nee tin gutaꞌh luꞌh xquelnabahan bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ya loh zeenee Jesuhs laꞌh Jairu, neezaa ziahan duxa raꞌ bwiinn zeenaꞌhla laꞌh raꞌ ba, hasta bateꞌh raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ya loh raꞌ bwiinn ziahan chi dxaꞌga tuhbi gunnaꞌh nin rahcalluꞌhu xcweenta hasta naa ba gunnaꞌh cun rihn; guhca la tsiꞌh bichiohpa yihza cayahcalluꞌhu ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","lliaaꞌh zi bañihchi ba xmweeyi ba gucaꞌha raꞌ nin ruhn rramwehdxi laꞌlagaꞌh mahzi guzalluꞌhu ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Niꞌchin chin bihn ba rusiaca Jesuhs laꞌh bwiinn, niꞌchin gwabiiga gunnaꞌh chi nez dihtsi Ñiꞌh bidxiꞌ ba loh xahba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","laasii bwiꞌhnn ba lligaaba: “Sidela naꞌh guidxiꞌn xahba Ñiꞌh ziacaꞌhn.” ");
INSERT INTO zpvNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ya hohra gahca nin bidxiꞌ ba rwaaꞌ xahba Ñiꞌh, guleeza calliꞌhi llarihn ba chiꞌchi biin ba bariaꞌh gueldxyihdxyi chi tihxi ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ya neezaa guhcabwaꞌ Jesuhs basiaca xquelrnabwaꞌ Ñiꞌh laꞌh tuhbi bwiinn, niꞌchin basiaꞌgariiloh Ñiꞌh nezloh raꞌ bwiinn nin naꞌhla laꞌh Ñiꞌh, tin gunaabadxyiꞌdxyi Ñiꞌh, rahbi Ñiꞌh: ―¿Chyu niꞌca bidxiꞌ naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh: ―Bwiinn ziahan raꞌ riiꞌ rcaꞌnaa, nee rnaabadxyiꞌdxyi tiiꞌ luꞌh: “¿Chyuñin bidxiꞌ naꞌh?” ");
INSERT INTO zpvNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per laꞌh Ñiꞌh bwaꞌha dziꞌtsi Ñiꞌh loh raꞌ ba tin gwaꞌha Ñiꞌh loh nin bidxiꞌ rwaaꞌ xahba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ya chin guhcabwaꞌ gunnaꞌh chi laꞌh Jesuhs naann nuu tuhbi nin bidxiꞌ laꞌh Ñiꞌh, chiꞌchi bidxyihbi bi ya lwehgu bazuꞌnllihbi bi nezloh Jesuhs, ya gudxixteeꞌ bi garaa ziga nin guzahca bi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Xiiꞌhihn, laꞌh luꞌh biaca laasii gwachiistoꞌ luꞌh naꞌh. Bwaa nnah, gulahchidxyii stoꞌ luꞌh ayi ru xi gaca luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ya gaduhbi nin cañiꞌ gahca Jesuhs niꞌchi badzihn raꞌ nin zeꞌ rwaaꞌ yihdzi Jairu, ya rahbi raꞌ ba loh Jairu: ―Laꞌh lliiꞌn luꞌh guhchi la; ayiru xi molesta guunn luꞌh laꞌh daada mwehsu ca. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ya chin bihn Jesuhs niꞌchi, chiꞌchi rahbi Ñiꞌh loh Jairu: ―Ayi guidxyihbi luꞌh, cun sola gwachiistoꞌ luꞌh ziaca lliiꞌndxaꞌpa luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ya chiꞌchi zeenee Ñiꞌh laꞌh Jairu, nee cun sola chohnna xpwiinn Ñiꞌh, ziga Pehdru cun Jacobo cun laꞌh Jwahn bwihtsi Jacobo, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ya chin badzihn Ñiꞌh rwaaꞌ yihdzi Jairu bwaꞌha Ñiꞌh riiyuꞌn cun hasta guñihchi cweenta raꞌ ba laasii guhchi lliiꞌndxaꞌpa Jairu, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ya chin guyuuꞌtii Jesuhs rahbi Ñiꞌh loh raꞌ ba: ―Ayi ruꞌn tu; naꞌllgahsi zi bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ya sola ballihdzinee raꞌ ba laꞌh Ñiꞌh laasii para laꞌh raꞌ ba guhchi bi, ya chiꞌchi babweꞌhe Ñiꞌh laꞌh raꞌ bwiinn laꞌn yuuꞌ chi ya xpaah si dxaꞌpa chi cun xmaah bi cun gadxioonna xpwiinn Ñiꞌh guyuuꞌtiinee Ñiꞌh hasta naꞌ dxaꞌpa chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","chiꞌchi gunaꞌzu Ñiꞌh naa bi, ya guñiꞌ Ñiꞌh loh bi, rahbi Ñiꞌh: ―¡Talita cumi! ―Naa dxyiꞌdxyi ziga guiñiꞌ Ñiꞌh rahbi Ñiꞌh: ¡Gwastii dxaꞌpwiꞌhn! ");
INSERT INTO zpvNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ya hohra chi gahca gubiaꞌgarii xquelnabahan dxaꞌpwiꞌhn chi, chiꞌchi gwastii bi tin zuuzaa bi nee guyuuꞌ za bi tsiꞌh bichiohpa yihza, ya bwiinn raꞌ nin bwaꞌha babahn dxaꞌpwiꞌhn riiꞌ badxyigaaꞌ duxa raꞌ ba chin bwaꞌha raꞌ ba niꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ya riꞌchi gahca gunabwaꞌ Jesuhs ayi chyulootiiꞌ guuyi raꞌ ba cohsa raꞌ chi tin ayi chyu gacabwaꞌ, ya chiꞌchi rahbi Ñiꞌh: ―Gulgadiꞌhi xi gahw bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ya chiꞌchi babii Jesuhs riꞌchi tin gwah Ñiꞌh nez guihdxyi nin bieꞌrooꞌ Ñiꞌh, guihdxyi chi laa Nazaret nee zeezahnee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ya chin guhca dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, guzoꞌbaloh baluuꞌyi Jesuhs xchiꞌdxyi Dxiohs laꞌn guidoꞌ biꞌtuꞌhn nin nuu loh guihdxyi chi, ya chin bihn raꞌ bwiinn ziahan chi xcweenta dxyiꞌdxyi raꞌ nin ruluuꞌyi Jesuhs, chiꞌchi gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba nee badxyigaaꞌ duxa za loh raꞌ ba rahbi raꞌ ba: ―¿Ca nehza basiꞌdxi deeꞌ ziahan dxyiꞌdxyi raꞌ riiꞌ? ¿Ca nehza gwacaꞌha ndxiꞌhw ca lligaaba nasiin cun dziꞌn roo raꞌ nin ruhnn ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Tayi niꞌca dxiꞌh nin naa carpinteru, lliiꞌn María cun bwihtsi Jacobo, Joseh, Judas, cun Simohn? ¿Nee tayi lahda guihdxyi dxiꞌh riiꞌ nuu raꞌ bizaaꞌn niꞌca? ");
INSERT INTO zpvNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Bwiinn raꞌ nin ayi ruzoꞌbadxiahga xchiꞌdxyi tuhbi daada nin ruluuꞌyi xchiꞌdxyi Dxiohs naa raꞌ ba bwiinn lahdxyi paꞌh ba, bwiinn lasaaꞌ ba, cun bwiinn xfamihyi gahca ba. Niꞌchin ayi bazoꞌbadxiahga raꞌ ba xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ya ayi nuu ñuhnn Ñiꞌh nin tuhbi dziꞌn rooꞌ riꞌchi, sola basiaca Ñiꞌh mas paaldiꞌhn raꞌ bwiinn dxyihdxyi cun sola badziiꞌba naa Ñiꞌh yihca raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","nee badxyigaaꞌ duxa za loh Ñiꞌh pur nin ayi gwachiistoꞌ raꞌ ba laꞌh Ñiꞌh, ya caꞌngaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs loh guihdxyi biꞌtuꞌhn raꞌ cun rrandxu raꞌ nin riaꞌhan gahxu nez chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ya seguihdu batiaaꞌha Jesuhs gadziꞌh bichiohpa xpwiinn Ñiꞌh ya chiꞌchi guzoꞌbaloh guxeꞌhla Ñiꞌh chiohpagah raꞌ ba cada tuhbigah guihdxyi, nee badiꞌhi za Ñiꞌh guelrnabwaꞌ laꞌh raꞌ ba tin babweꞌhe raꞌ ba bwiinndxaaba stoꞌ raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ya rahbi Ñiꞌh loh raꞌ ba: ―Ayi xi chenee tu loh nehza, nin buxa nin guehta nin mweeyi; cun sola baxtohn chenee tu, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","nee gucaꞌh si tu tahba tu ñaaꞌ cun gacu tu tuhbi si za neezaa xahba tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ya rahbi Ñiꞌh: ―Cuun chiꞌh zi yihdzi bwiinn nin gadzihn tu riꞌchi guldxiaꞌhan hastayi gadzihn dxyih gariaꞌh tu guihdxyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ya guihdxyi nin ayi guunn cweenta raꞌ ba xchiꞌdxyi tu talguꞌnsi gariaꞌh tun, per tsiibixgah tu tahba tu tin niꞌchi gaca tuhbi sehn guyuuꞌ xtuhlda raꞌ ba, laasii guchiin nin rñiꞌn loh tu dxyih nin guunn Dxiohs jwisi mahzi ru gusaꞌcazii Dxiohs laꞌh raꞌ bwiinn loh guihdxyi raꞌ nin ayi xclaaꞌdzi gucaꞌdxiahga xchiꞌdxyi Dxiohs que loh bwiinn chieempa raꞌ nin guyuuꞌ guihdxyi Sodoma cun Gomorra. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ya chiꞌchi gunaꞌzunehza raꞌ ba guriin-guriin guihdxyi, bagaluuꞌyi raꞌ ba xchiꞌdxyi Dxiohs tin gusaguꞌdzi stoꞌ raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ya babweꞌhe raꞌ ba ziahan bwiinndxaaba stoꞌ raꞌ bwiinn, neezaa gudaꞌbi raꞌ ba nsehchi tihxi raꞌ bwiinn raꞌ nin rahcalluꞌhu ya biaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chin gudiiꞌdxi dxiahga rrehyi Herodes nin cayuhnn Jesuhs laasii cagazeꞌta raꞌ ziahan bwiinn nin cayuhnn Ñiꞌh, chiꞌchi rahbi Herodes: ―¿Ta Jwahngah niꞌca babahn loh guelguhchi, niꞌchin nin zeezahnee ba guelrnabwaꞌ raꞌ riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ya snuhn raꞌ ba rahbi: ―Laꞌh laꞌguehtu Elías niꞌca. Ya snuhn raꞌ ba rahbi: ―Niꞌca naa stuhbi guehtu profeta nin guñiꞌ xchiꞌdxyi Dxiohs cachieempa o chyuulla stuhbi profeta. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ya chin bihn Herodes dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi rahbi ba: ―¿Ta laꞌh Jwahn nin gunabwaꞌn birwaꞌha yihca ñiꞌh deeꞌ babahn loh guelguhchi? ");
INSERT INTO zpvNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Laasii laꞌh gahca Herodes gunabwaꞌ binaꞌzu Jwahn cun biyiꞌbiduꞌh ba cun cadehn laꞌn lahtsidxiꞌba pur Herodías xcunnaꞌh Felipe bwihtsi Herodes nin bwiꞌhnn cheꞌhla Herodes, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","nee laasii guñiꞌ Jwahn rahbi ba: ―Ayi naa bwen cweꞌhelluꞌhu luꞌh xcunnaꞌh bwihtsi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ya pur niꞌchi bidxyiꞌchinee Herodías laꞌh Jwahn, niꞌchin guclaaꞌdzi ba gachi Jwahn per ayi rdxeela ba xa gachi Jwahn, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","laasii rdxyihbi Herodes laꞌh Jwahn laasii naann ba Jwahn naa tuhbi ndxiꞌhw zaꞌca tuhbi ndxiꞌhw saantu ya niꞌchin balaꞌhloh Herodes laꞌh Jwahn loh Herodías ya gaduhbi stoꞌ ba rucaꞌdxiahga ba xchiꞌdxyi Jwahn nicala ayi rahcabwaꞌ zaꞌca ban. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per guyuuꞌ xa bwiꞌhnn Herodías nin guclaaꞌdzi bi gaca chin badzihn tuhbi dxyih nin rahca laa Herodes, chiꞌchi gunabwaꞌ Herodes guhcachaꞌyi tuhbi xchih para garaa raꞌ xpwiinn ba tin gudahwnee Herodes laꞌh raꞌ ba cun lasaaꞌ bwiinn rnabwaꞌ ba nin naa raꞌ bwiinn Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ya chin guyuuꞌtii lliiꞌndxaꞌpa gahca Herodías laꞌn hasta rii raꞌ Herodes cun garaa raꞌ xpwiinn ba loh mwella, chiꞌchi badxiaꞌha dxaꞌpa chi, ya biuꞌstoꞌ duxa rrehyi Herodes cun garaa raꞌ nin zohbanee ba loh mweella ziga badxiaꞌha dxaꞌpa chi, chiꞌchi rahbi Herodes loh dxaꞌpa chi: ―Gunaaba nin chiꞌh zi xclaaꞌdzi luꞌh loon, ya naꞌh zuniꞌhiñin ―rahbi Herodes― ");
INSERT INTO zpvNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","nee guchiin, garaa nin chiꞌh zi guinaaba luꞌh loon zuniꞌhiñin ―rahbi Herodes loh dxaꞌpa chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ya bariaꞌh dxaꞌpa chi riꞌchi, chiꞌchi rahbi bi loh xmaah bi: ―¿Xi niꞌca guinaꞌbaꞌhn? Chiꞌchi rahbi xmaah bi: ―Gunaaba yihca Jwahn nin ruroꞌbañihsa. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ya chiꞌchi biuꞌgarii dxaꞌpa chi carrih hasta zohba rrehyi Herodes, ya gunaaba bi rahbi bi: ―Xclaaꞌdzihn nnahgahca guniꞌhi luꞌh yihca Jwahn nin ruroꞌbañihsa naꞌh laꞌn tuhbi plahtu. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ya chiꞌchi guyuuꞌ nalaasa duxa stoꞌ rrehyi Herodes, per pur xchiꞌdxyi ba nin guñiꞌ ba, nee pur bihndxiahga raꞌ nin zohbanee ba loh mweella niꞌchin nin ayi nuu xa ñiñiꞌ ba ñahbi ba: ―Ayi guniꞌhihn yihca Jwahn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ya chiꞌchi guluꞌnehza Herodes tuhbi xpwiinn ba zecaꞌha yihca Jwahn nin ruroꞌbañihsa, ya laꞌn lahtsidxiꞌba bachywaꞌh bwiinn chi yihca Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ya gwanee ba yihca Jwahn laꞌn tuhbi plahtu tin badiꞌhi ban laꞌh dxaꞌpa chi, ya dxaꞌpa chi badiꞌhigah bin laꞌh xmaah bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ya chin bihn raꞌ xpwiinn Jwahn nin ruroꞌbañihsa ziꞌchi guhca, gwagalliꞌhi raꞌ ba tihxi Jwahn bacaꞌtsi raꞌ ban laꞌn tuhbi baꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ya chin babiaꞌgarii raꞌ xpwiinn Jesuhs, chiꞌchi bwiiꞌyidxyiꞌdxyi raꞌ ba loh Jesuhs garaa nin bwiꞌhnn raꞌ ba cun nin bagaluuꞌyi raꞌ ba nez gwah raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn zi Ñiꞌh: ―Gulchoꞌho guidxiaꞌchi nuꞌh riiꞌ tin guziꞌlaaꞌdzi tu. Laasii ziaa-zieꞌ raꞌ bwiinn riꞌchi, ya nin ayi riooba ñahwnee raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ya zeenee raꞌ ba laꞌhsi Ñiꞌh laꞌh si raꞌ ba laꞌn tuhbi laancha nez hasta ayi chyu bwiinn nuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","per ziahan duxa raꞌ bwiinn bwaꞌha raꞌ ba bireꞌh laancha chi zeeꞌhen, nee biuꞌnbwaꞌ za raꞌ ba laꞌh raꞌ ba ya chiꞌchi garaa raꞌ bwiinn guihdxyi raꞌ nin rii riꞌchi balluꞌn raꞌ ba hasta nez chi ya galoh raꞌ ba badzihn raꞌ ba hasta zeenee laancha chi laꞌh Jesuhs cun xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ya chin bariaꞌh Jesuhs laꞌn laancha bwaꞌha Ñiꞌh ziahan duxa naa raꞌ bwiinn nin rii riꞌchi chiꞌchi balahsastoꞌ Ñiꞌh laꞌh raꞌ ba laasii naa raꞌ bwiinn chi zigazi lliꞌhyi nin ayi xballwaꞌn ñiꞌh, ya chiꞌchi guzoꞌbaloh cagaluuꞌyi Ñiꞌh ziahan dxyiꞌdxyi laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ya chin guhca gudxyih gwabiiga raꞌ xpwiinn Ñiꞌh, rahbi raꞌ ba loh Ñiꞌh: ―Ya mwer laꞌh gueꞌla cwih la laasii hasta dxuu nuꞌh riiꞌ ayi xi nuutiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Baxeꞌhla raꞌ ba guziaa raꞌ ba rraandxu raꞌ o lahda guihdxyi raꞌ tin chiꞌhyi raꞌ ba nin gahw raꞌ ba laasii ayi xi nahpa raꞌ ba para gahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―¡Laꞌh tu gulgadiꞌhi nin gahw raꞌ bwiinn ca! Chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―¿Ta xclaaꞌdzi luꞌh chosiꞌn nu chiohpa gaywaꞌha denariu pahn tin gahw raꞌ bwiinn raꞌ ca? (Chiohpa gaywaꞌha denariu naa ziga guunn tuhbi ndxiꞌhw gahn loh xoꞌpa bweꞌhw garoolda.) ");
INSERT INTO zpvNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh loh raꞌ ba rahbi Ñiꞌh: ―¿Spaaldaa pan nahpa tu? Gulcheguiaꞌha spaaldan. Ya chin bwaꞌha raꞌ ba chiꞌchi rahbi raꞌ ba: ―Zagaꞌyu dxiꞌh pahn cun schiohpa dxiꞌh bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chiꞌchi guñiꞌ Ñiꞌh loh raꞌ xpwiinn Ñiꞌh tin gulahchixnehza raꞌ ba laꞌh raꞌ ba loh cwaꞌn nagaa raꞌ nin rii riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ya guriixnehza raꞌ ba cada tuhbigah cwaꞌh, ziga tuhbigah gaywaꞌh raꞌ ba cun chwaꞌha bitsiꞌhgah raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ya seguihdu gucaꞌha Ñiꞌh gagaꞌyu pahn chi cun garoopa bwehlda chi, ya guteesa loh Ñiꞌh nez llaaꞌn dxibaaꞌ tin badiꞌhi Ñiꞌh guel zuxchiilli loh Dxiohs pur guelwahw chi, chiꞌchi gutaaꞌha Ñiꞌh pahn chi, badiꞌhi Ñiꞌhn laꞌh raꞌ xpwiinn Ñiꞌh tin gudxiꞌzi raꞌ ban nez loh raꞌ bwiinn ziahan raꞌ chi. Ziꞌchi gahca za bwiꞌhnn Ñiꞌh cun garoopa bwehlda, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ya garaa raꞌ ba gudahw raꞌ ba hasta que no gwadxah raꞌ ba hasta ayi gunnah ru raꞌ ba ñahw raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ya chin guyaꞌloh gudahw raꞌ ba bidiaaꞌha zatsiꞌbi chiohpa tipi pahn cun bwehlda raꞌ nin biaꞌhancah, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ya bwiinn raꞌ nin gudahw raꞌ chi guhca raꞌ ba ziga gaꞌyu mihyi ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ya seguihdu gunabwaꞌ Jesuhs gucah raꞌ xpwiinn Ñiꞌh laꞌn laancha tin zeeñiidxiuu raꞌ ba stuhbi lahdu rwaaꞌ ñihsa xteenn guihdxyi Betsaida gaduhbi nin cañiꞌnee Ñiꞌh laꞌh raꞌ bwiinn ziahan nin biaꞌhancah riꞌchi tin dxiuuꞌnehza raꞌ ba para lahdxyi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ya chin guyaꞌloh bwaꞌha Ñiꞌh biuuꞌnehza raꞌ bwiinn ziahan raꞌ chi, chiꞌchi gucah Ñiꞌh tuhbi dahan tin riꞌchi gudihdxyi-gunaaba Ñiꞌh loh Xtaada Dxiohs Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ya chin gurih gueꞌla, laꞌh laancha chi zeezahla galaayi loh ñihsa chi, ya laꞌh Ñiꞌh tuhbi dxiꞌh Ñiꞌh zuu Ñiꞌh loh dahan. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Per chin bwaꞌha Ñiꞌh cadiiꞌdxi xpwiinn Ñiꞌh guelrzaꞌcazii laasii zuu bwih rooꞌ nin ayi rusaaꞌn guzee raꞌ ba nez hasta nahpa guzee raꞌ ba loh ñihsa chi, ya nateh rooꞌ run zeezah Jesuhs loh ñihsa chi nez hasta bwaꞌha Ñiꞌh zeezahne laancha chi laꞌh raꞌ xpwiinn Ñiꞌh, per bwiꞌhnn Ñiꞌh zigazi ñidiiꞌdxi Ñiꞌh zihtu rooꞌ galoh hasta zeenee laancha chi laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ya chin bwaꞌha raꞌ ba zeezah Ñiꞌh loh ñihsa chi, bwiꞌhnn raꞌ ba lligaaba naa Ñiꞌh tuhbi aijma niꞌchin gudihdxyidxiah raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","laasii garaa raꞌ ba bwaꞌha raꞌ ba zeezah Ñiꞌh loh ñihsa chi niꞌchin bidxyihbi duxa raꞌ ba, per seguihdu gahca guñiꞌ Ñiꞌh loh raꞌ ba, rahbi Ñiꞌh: ―¡Gulgadiꞌhi balohr stoꞌ tu; naꞌhan ―rahbi Ñiꞌh― ayi guidxyihbi tu! ");
INSERT INTO zpvNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lwehgu gucah Ñiꞌh laꞌn laancha chi, ya hohra chi gahca za guleeza bwih chi, ya biahxi duxa raꞌ xpwiinn Ñiꞌh chi chin bwaꞌha raꞌ ba loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","pwihsi ayi rahcabwaꞌ raꞌ ba xcweenta Ñiꞌh nicala bwaꞌha raꞌ ba milahgru nin bwiꞌhnn Ñiꞌh pur pahn raꞌ, per ayi rahcabwaꞌ raꞌ ba xcweenta xquelrnabwaꞌ Ñiꞌh, zeezah rahca nahda lastoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ya chin guyaꞌloh gudiiꞌdxi raꞌ ba loh ñihsa chi, chiꞌchi badzihn raꞌ ba loh yuh xteenn Genesaret, riꞌchi bacaꞌduꞌh raꞌ ba laancha, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ya gaduhbi nin cagareꞌh raꞌ ba laꞌn laancha biuꞌnbwaꞌ raꞌ bwiinn chi laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ya chiꞌchi gubiaꞌgarii balluꞌn raꞌ bwiinn chi nez loh guihdxyi raꞌ nin rii gadiidxi guihdxyi chi tin bagalliꞌhi raꞌ ba xpwiinn dxyihdxyi raꞌ ba ya nuꞌa raꞌ ba laꞌh raꞌ bwiinn dxyihdxyi raꞌ chi loh luꞌhn raꞌ tin zeenee raꞌ ba laꞌh raꞌ ba hasta chiꞌh zi bihn raꞌ ba zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ya garaa lahta nicala loh dxiaaꞌ raꞌ o nicala lahda guihdxyi raꞌ o loh dahan raꞌ rnaaba raꞌ ba mas xahba zi Ñiꞌh guidxiꞌ raꞌ bwiinn dxyihdxyi raꞌ chi, ya garaa raꞌ bwiinn dxyihdxyi nin bidxiꞌ xahba Ñiꞌh biaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ya tuhbi dxyih, guyuuꞌ paaldaa raꞌ bwiinn fariseu cun paaldaa raꞌ mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, zeꞌ raꞌ ba nez guihdxyi Jerusalehn ya badiaaꞌha raꞌ ba loh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ya loh nin bwaꞌha raꞌ fariseu raꞌ chi ayi bidxiꞌbi naa raꞌ xpwiinn Jesuhs chin gudahw raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","niꞌchin guñiꞌ tohnta raꞌ ba, laasii ayi bwiꞌhnn raꞌ xpwiinn Ñiꞌh ziga naa xcostumbre raꞌ ba nee neezaa snuhn raꞌ bwiinn Israel raꞌ nin zeezahnee xcostumbre raꞌ riiꞌ laasii guehtu xtatita rooꞌ raꞌ ba basiaꞌhaneen laꞌh raꞌ ba, laasii bwiinn Israel raꞌ chi guillii-guillii rdxiꞌbi naa raꞌ ba chin rahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya ziga chin razah bwiinn Israel raꞌ chi loh dxiaaꞌ sidela ayi guidxiꞌbi naa raꞌ ba loh raꞌ ba cun ñaaꞌ raꞌ ba, ayi rahw raꞌ ba, ziꞌchi za gudahla raꞌ ziahan rooꞌ raꞌ costumbre raꞌ nin riazahnee raꞌ ba; ziꞌchi za rusiaa raꞌ ba xqihsu raꞌ ba nee cun xtraxtra raꞌ ba, nee cun xtraxta dxiꞌba raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chiꞌchi rahbi raꞌ bwiinn fariseu cun mwehsu raꞌ xteenn lehyi: ―¿Xixnaa ayi rdxiꞌbi naa raꞌ xpwiinn luꞌh chin rahw raꞌ ba tin guunn raꞌ ba ziga naa costumbre nin basiaꞌhannee raꞌ guehtu xtatita roo raꞌ nuꞌh laꞌh nuꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¡Bwiinn rusaguiꞌhi bwiinn raꞌ! Guchii guehtu Isaías ziga bacaꞌh ba xcweenta ziga ruhnn tu: Rñiꞌ tu ziga zi nin rbwihdxyi-rnaaba laꞌh Dxiohs, per stoꞌ tu zihtu riaꞌhan loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lliaaꞌh naa zi ruzuꞌnllihbi tu nez loon, laasii laꞌh tu ruluuꞌyi tu nin naa gahca xcostumbre tu nee rahbi tu naa raꞌn nin gunabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Nee laꞌh tu ayi ruzoꞌbadxiahga tu xchiꞌdxyi Dxiohs, sino que zeenaꞌhla tu nin naa xigaaba raꞌ bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Rahbi za Ñiꞌh: ―¡Bayilaa ruhnn bwiinn nasiin tu, nee cagasaaꞌn za tu tuhbi lahdu garaa raꞌ xchiꞌdxyi Dxiohs tin zeezahnee tu ziga naa xcostumbre tu nin xigaaba raꞌ bwiinn guidxyiyuh! ");
INSERT INTO zpvNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ziga rahbi guehtu Moisehs: “Guhca nadziiꞌhi laꞌh xpaah luꞌh cun xmaah luꞌh, ya nin cuꞌdii laꞌh xpaah ñiꞌh o xmaah ñiꞌh nahpa chiin tu ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per laꞌh tu ruluuꞌyi tu ayi nahpa guzoꞌbadxiahga bwiinn xchiꞌdxyi xcuzahn raꞌ ba, ruchiꞌhyi tu laꞌh raꞌ ba tin guiñiꞌ raꞌ ba squiiꞌ: “Ayi nuu gacaneꞌhn yiꞌh laasii bwiꞌhnnaꞌhn lligaaba gudiꞌhihn guhn garaa nin naꞌpahn laꞌh Dxiohs.” ");
INSERT INTO zpvNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ya garaa nin rñiꞌ squiiꞌ ayi ru ruhnn raꞌ ba jweersi gacanee raꞌ ba laꞌh xcuzahn raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ya pur xcostumbre tu ruhnn ayi ruzoꞌbadxiahga raꞌ ba xchiꞌdxyi Dxiohs, ya ziahan ru cohsa raꞌ nin naa raꞌ ziꞌchi ruhnn tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chiꞌchi gudihdxyi Jesuhs laꞌh raꞌ bwiinn, tin rahbi Ñiꞌh loh raꞌ ba: ―Gulgacaꞌdxiahga dziꞌtsi garaa tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nin rguꞌtii laꞌh raꞌ bwiinn loh duhlda ayi naan guelwahw nin rahw raꞌ ba, sino que dxyiꞌdxyi dxixiꞌhw nin riinloh stoꞌ raꞌ ba, niꞌchi naa nin rguꞌtii laꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Niꞌchin nin riuuꞌ-riaꞌzi dxyiꞌdxyi gulgacabwaꞌ nin zeꞌ raꞌ loh dxyiꞌdxyi raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ya chin babii Jesuhs lahda raꞌ bwiinn ziahan raꞌ chi, ya biuꞌgarii Ñiꞌh laꞌn yuuꞌ, chiꞌchi gunaabadxyiꞌdxyi raꞌ nin ruluuꞌyi Ñiꞌh tin para gacabwaꞌ raꞌ ban, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Ta neezaa tu ayi rahcabwaꞌ tu? ¿Tayi rahcabwaꞌ tu ayi naa bwiinn bwiinn duhlda pur nin rahw raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nin rahw bwiinn ayi radzihnan tihxi stoꞌ bwiinn sino que radzihnan hasta laꞌn buxa nin nuu cweeꞌ stoꞌ bwiinn, ya rariaꞌhan nez hasta riuuꞌbwihin. Ziꞌchi guñiꞌ Ñiꞌh tin baluuꞌyi Ñiꞌh nayaa naa garaatiiꞌ xica nin rahw bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Neezaa rahbi Ñiꞌh: ―Dxyiꞌdxyi nin rreꞌh rwaaꞌ raꞌ bwiinn, niꞌchi sihn rguꞌtii laꞌh raꞌ ba loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","laasii stoꞌ raꞌ bwiinn rreꞌh raꞌ lligaaba dxaaba raꞌ ziga guelgubwihlli cun guelrbaaꞌn, guelrdxiinn bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","guelrcahnee cheꞌhla stuhbi bwiinn, guelrzaꞌbistoꞌ xixteenn bwiinn, guelnadxaaba, guelrusaguiꞌhi lasaaꞌ ñiꞌh, nin ayi xtuhyitiiꞌ loh ñiꞌh ziga xcweenta dziꞌn dxaaba raꞌ, guelrwaꞌha dxaaba laꞌh stuhbi bwiinn, guelrudziiꞌba dii yihca lasaaꞌ ñiꞌh, guelnayachi, cun luꞌh bwiinn stoꞌ raꞌ nahda. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Garaa raꞌ lligaaba dxaaba raꞌ riiꞌ rreꞌh stoꞌ bwiinn niꞌchi nin rguꞌtii laꞌh raꞌ bwiinn loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ya riꞌchi biriaꞌh Jesuhs zee Ñiꞌh para guihdxyi Tiru cun Sidohn, ya chin badzihn Ñiꞌh riꞌchi, bidxeela Ñiꞌh tuhbi yuuꞌ hasta guyuuꞌ Ñiꞌh laasii ayi guclaaꞌdzi Ñiꞌh ñahcabwaꞌ bwiinn nuu Ñiꞌh riꞌchi, per ayi guhca ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Laasii lwehgu bihn xmaah tuhbi dxaꞌpa nin guyuuꞌ tuhbi bwiinndxaaba stoꞌ ñiꞌh laꞌh Jesuhs nuu riꞌchi, niꞌchin gwah ba hasta nuu Ñiꞌh ya chin bwaꞌha ba loh Jesuhs bazuꞌnllihbi ba nezloh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ya gunnaꞌh chi ayi naa ba bwiinn Israel sino que naa ba tuhbi bwiinn sirofenicia, per loh nin gunaaba ba tin gabweꞌhe Jesuhs bwiinndxaaba chi stoꞌ lliiꞌndxaꞌpa ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","rahbi Jesuhs loh ba: ―Basaaꞌn gahwxgah raꞌ lliiꞌn raꞌn, laasii ayi naa bwen chyu cooba xpahn raꞌ lliiꞌn raꞌn ya chubwihin loh bwehcu. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chiꞌchi rahbi gunnaꞌh chi: ―Guchii luꞌh daada, per hasta bwehcu raꞌ rahw raꞌ guehta biuyiꞌhn nin riaaba llaaꞌn mwella nin rahw raꞌ lliiꞌn raꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chiꞌchi rahbi Ñiꞌh loh gunnaꞌh chi: ―Bwehngahca guñiꞌ luꞌh, zahca guziaa luꞌh, ya laꞌh bwiinndxaaba chi bariaꞌh stoꞌ lliiꞌndxaꞌpa luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ya chin bwaa gunnaꞌh chi yihdzi ba gwaguiaꞌha ba loh luꞌhn laꞌh lliiꞌndxaꞌpa ba bwiinndxaaba chi bariaꞌhala stoꞌ bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ya chin bariaꞌh Jesuhs guihdxyi Tiru, chiꞌchi gudiiꞌdxi Ñiꞌh nez guihdxyi Sidohn cun garaa raꞌ nezloh guihdxyi raꞌ nin rnabwaꞌ Decápolis, ya ziꞌchi zi badzihn Ñiꞌh hasta rwaaꞌ laguhn xteenn Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ya chin guyuuꞌ Ñiꞌh laꞌn guihdxyi xteenn Decápolis, gwanee paaldaa raꞌ bwiinn laꞌh tuhbi ndxiꞌhw nin naa goopa loh Ñiꞌh, ya gudxiꞌhn raꞌ ba gudziiꞌba naa Ñiꞌh yihca bwiinn goopa chi tin dxiaca ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ya chiꞌchi gwanee Ñiꞌh laꞌh bwiinn goopa chi tuhbi lahdu nez hasta ayi chyu bwiinn riiꞌ, riꞌchi guluꞌtee Ñiꞌh bacwihn naa Ñiꞌh laꞌn dxiahga bwiinn goopa chi, neezaa bagahdxyi xihin Ñiꞌh yihca bacwihn naa Ñiꞌh ya bidxiꞌ Ñiꞌh luudxyii ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","chiꞌchi bwaꞌha Ñiꞌh nez llaaꞌndxibaaꞌ guñiꞌ biin lastoꞌ Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh ndxiꞌhw chi: ―¡Efata! ―Naa ziga guiñiꞌ luꞌh: ¡Billaala!. ");
INSERT INTO zpvNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ya hohra chi gahca ballaala dxiahga bwiinn goopa chi, neezaa luudxyi ba guhca bañiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","chiꞌchi rahbi Jesuhs loh ndxiꞌhw chi: ―Ayi chyuloo tiiꞌ chixteeꞌ luꞌh pur nin basiaacahn yiꞌh. Per loh bihnn ba ayi xi guuyi ba mahzi ru batiꞌchi ba dxyiꞌdxyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ya garaa raꞌ bwiinn nin bihn dxyiꞌdxyi chi badxyigaaꞌ loh raꞌ ba neezaa rahbi raꞌ ba: ―¡Garaa nin ruhnn ba naa dziꞌn zaꞌca! ¡Hasta bwiinn gweꞌta rallaala ba dxiahga ñiꞌh ya goopa raꞌ ruhnn ba pur rañiꞌ raꞌ ba! ");
INSERT INTO zpvNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ya laꞌn dxyih raꞌ chi badiaaꞌha ziahan laꞌgaꞌh bwiinn, ya ayi nahpa raꞌ ba xi gahw raꞌ ba, niꞌchin gudihdxyi Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ralahsa duxa stoꞌn laꞌh raꞌ bwiinn riiꞌ laasii laꞌh chohnna dxyih naa nuunee raꞌ ba naꞌh, nee ayi nahpa raꞌ ba nin gahw raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ya sidela naꞌh gaxeꞌhla raꞌn ba rwaaꞌ yihdzi raꞌ ba llahsaa raꞌ ba, zadxahga raꞌ ba loh nezyuh, laasii nuu raꞌ ba zihtu zeꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ya chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Per nez riiꞌ ayi chyu nuutiiꞌ, ayi xa guidiꞌhnn nuꞌh guidxeela xi gahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chiꞌchi rahbi Ñiꞌh: ―¿Paaldaa pahn nahpa tu riꞌca? Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Gahdzin. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chiꞌchi gunabwaꞌ Ñiꞌh guzohba garaa bwiinn chi, ya chiꞌchi gucaꞌha Ñiꞌh gagaadzii pahn chi tin badiꞌhi Ñiꞌh guelzuxchiilli loh Xtaada Dxiohs Ñiꞌh, ya chiꞌchi gudxiꞌzi Ñiꞌhn loh raꞌ xpwiinn Ñiꞌh tin para gudxiꞌzi raꞌ ban loh raꞌ bwiinn ziahan chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ziꞌchi gahca bwiꞌhnn Ñiꞌh cun nuhn bwehlda biꞌtuꞌhn badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs, chiꞌchi gudxiꞌzi gahca raꞌ za xpwiinn Ñiꞌh ma loh raꞌ bwiinn ziahan chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ya garaa raꞌ ba gudahw raꞌ ba hasta gwadxah raꞌ ba, ya chin guyaꞌloh gudahw raꞌ ba bidiaaꞌha za gahdzi tipi taaꞌha pahn cun bwehlda raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ya naa raꞌ bwiinn chi ziga tahpa mihyi, ya seguihdu guhdzi Ñiꞌh tin biuuꞌnehza raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ya lwehgu zeenee Ñiꞌh garaa xpwiinn Ñiꞌh laꞌn tuhbi laancha hasta loh guihdxyi xteenn Dalmanuta. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chin badzihn raꞌ nuhn bwiinn fariseu hasta zuu Jesuhs guzoꞌbaloh biahyi raꞌ ba gadiidxi Ñiꞌh tin canaaba raꞌ ba loh Ñiꞌh guunn Ñiꞌh tuhbi milahgru nin Dxiohs si nin nuu llaaꞌn dxibaaꞌ zahca guunn, tin guluuꞌyi gu guchii Dxiohs guluꞌnehza laꞌh Jesuhs loh guidxyiyuh, ya cagaldaꞌtsi si raꞌ ba guiduꞌhun xi guunn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chiꞌchi bibiin laꞌn lastoꞌ Jesuhs, ya rahbi Ñiꞌh loh raꞌ bwiinn fariseu chi: ―¿Xixnaa chiꞌh rnaaba tu guꞌnnahn milahgru raꞌ? Guchiin nin rñiꞌn loh tu, nin tuhbi dziꞌn rooꞌ ayi guꞌnnahn nezloh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ya cun basaaꞌn Ñiꞌh laꞌh raꞌ ba riꞌchi lwehgu bacah Ñiꞌh laꞌn laancha zeenee chiꞌh Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh stuhbi lahdu rwaaꞌ ñihsa. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ya biaꞌldastoꞌ raꞌ xpwiinn Ñiꞌh ñuꞌa raꞌ ba pahn, per laꞌn laanchayi nuu raꞌ ba chin bwaꞌha raꞌ ba tuhbi dxiꞌh pahn nahpa raꞌ ba, nee loh ñihsa la za niꞌchi zeenee laancha laꞌh raꞌ ba hohrchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","nee hohrachi gahca za rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Gulguiaꞌha cuun xlevaduhra raꞌ bwiinn fariseu cun xpwiinn Herodes. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chiꞌchi rahbi loh lasaaꞌ raꞌ xpwiinn Ñiꞌh chi: ―Guchii nin guñiꞌ mwehsu laasii ayi chyu nahpa pahn. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Per guhcabwaꞌ Jesuhs ayi guhcabwaꞌ raꞌ xpwiinn Ñiꞌh xa naa dxyiꞌdxyi nin guñiꞌ Ñiꞌh loh raꞌ ba niꞌchin rahbi Ñiꞌh: ―¿Xixnaa rahbi tu ayi nahpa tu pahn? ¿Ta nagahdxi gacabwaꞌ tu? ¡Xiꞌballa nahda stoꞌ tu, nee dxiahga tu ñieꞌwun! ");
INSERT INTO zpvNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¡Nuu dxiahga tu cun bizloh tu, per rluuꞌyi ayi riin loh tu cun dxiahga tu ayi rihnan! ¿Tayi riagannastoꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chin gudxiꞌziꞌhn gagaꞌyu pahn loh gaꞌyu mihyi bwiinn, ¿paaldaa tiipin bidiaaꞌha? ―Tsiꞌh bichiohpan ―rahbi raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chiꞌchi rahbi Ñiꞌh: ―Ya chin gudxiꞌziꞌhn gahdzi pahn loh tahpa mihyi bwiinn, ¿paaldaa tiipin bidiaaꞌha chin guyaꞌloh gudahw raꞌ ba? ―Gahdzin ―rahbi raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chiꞌchi rahbi Ñiꞌh: ―¿Ta nagahdxi gacabwaꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ya chin badzihn raꞌ ba tuhbi guihdxyi nin laa Betsaida, riꞌchi gwanee raꞌ bwiinn guihdxyi chi tuhbi bwiinn nin rahca loh ñiꞌh hasta zuu Jesuhs, ya guñiꞌnee raꞌ ba laꞌh Ñiꞌh tin guidxiꞌ Ñiꞌh laꞌh bwiinn nin rahca loh ñiꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","chiꞌchi gunaꞌzu Jesuhs naa bwiinn nin rahca loh ñiꞌh chi, gwanee Ñiꞌh laꞌh ba hasta rwaaꞌ guihdxyi, chiꞌchi bagahdxyi Ñiꞌh rwaaꞌ bizloh ba cun xihin Ñiꞌh, neezaa badziiꞌba naa Ñiꞌh yihca ba chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh loh ba gu rwaꞌha ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ya guzoꞌbaloh caywaꞌha bwiinn nin rahca loh ñiꞌh chi, chiꞌchi rahbi ba: ―Laꞌn rwaꞌha laꞌh raꞌ ndxiꞌhw raꞌ, rñah raꞌ ba zigazi yahga nagaa raꞌ nin rzah raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chiꞌchi bacaꞌh garoopa naa Ñiꞌh loh bwiinn chi stuhbi, ya chiꞌchiyi bwaꞌha zaꞌca ba garaatiiꞌ raꞌ cohsa nayaa-nayaa, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","chiꞌchi gunabwaꞌ Ñiꞌh cun rahbi Ñiꞌh loh ba: ―Ayi guziaa loh guihdxyi; mahzi zigazi duꞌh bwaa yihdzi luꞌh nee ayi chyuloo gahbi luꞌh xa biaca luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ya seguihdu zenee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh nez lahda guihdxyi raꞌ xteenn guihdxyi Cesarea cun Filipu, ya loh neziuh gunaabadxyiꞌdxyi Jesuhs loh raꞌ xpwiinn Ñiꞌh rahbi Ñiꞌh: ―¿Chyu niꞌca rahbi raꞌ bwiinn naan? ");
INSERT INTO zpvNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Nuhn raꞌ bwiinn rahbi yiꞌh naa luꞌh Jwahn nin baroꞌbañihsa, ya snuhn raꞌ ba rahbi yiꞌh naa luꞌh Elías, ya snuhn raꞌ ba rahbi yiꞌh naa luꞌh stuhbi raꞌ guehtu profeta raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chiꞌchi rahbi Ñiꞌh: ―Ya laꞌh xchiꞌh tu, ¿xi nna tu chyu naan? Chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Yiꞌh nin naa luꞌh Crixtu Lliiꞌn Dxiohs nin dxuleꞌza nu. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ya chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh ayi xi guuyi raꞌ ba chyu naa Ñiꞌh loh nin tuhbi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chiꞌchi guzoꞌbaloh Jesuhs cagaluuꞌyi Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh, rahbi Ñiꞌh: ―Nahpa zidiꞌdxiꞌhn trabahjw duxa, ya bwiinn guhla raꞌ xteenn guidoꞌ cun bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza, cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, zusacaloh raꞌ ba naꞌh nee zidxiinn za raꞌ ba naꞌh, per chin dxiohnna dxyih zabanaꞌhn loh raꞌ bwiinnguuchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Garaa dxyiꞌdxyi raꞌ riiꞌ guñiꞌ Ñiꞌh loh raꞌ ba nayaa-nayaa, ya pur niꞌchi gwanee Pehdru laꞌh Ñiꞌh tuhbi lahdu tin guñiꞌnee ba loh Ñiꞌh tin ayi ñizaꞌca Ñiꞌh ziꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","per chiꞌchi basiaꞌgarii loh Jesuhs bwaꞌha Ñiꞌh loh raꞌ xpwiinn Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh Pehdru: ―¡Gwasuu loh xnezyuun Satanahs! ¡Yiꞌh ayi ruhnn luꞌh xigaaba xteenn Dxiohs, pur xigaaba si bwiinn guidxyiyuh cayuhnn luꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chiꞌchi gudihdxyi Ñiꞌh laꞌh raꞌ bwiinn cun garaa xpwiinn Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Sidela chyuulla tuhbi tu xclaaꞌdzi gaca tuhbi xpwiiꞌnnahn, gulgasiaꞌldastoꞌ tu garaa raꞌ nin rzaꞌbistoꞌ tu guunn tu, nee guldxiaꞌ xcruhzi tu (nin zee loh dxyiꞌdxyi riiꞌ naa gusaaꞌn luꞌh gudziiꞌba xquelnabahan luꞌh pur xcweenta Jesucristu) bachiꞌh gultaꞌnaꞌhla naꞌh ―rahbi Ñiꞌh― ");
INSERT INTO zpvNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","laasii bwiinn nin xclaaꞌdzi ayi guñihchi xquelnabahan ñiꞌh zuñihchi ban, per bwiinn nin guñihchi xquelnabahan ñiꞌh pur naꞌh, nee pur xcweenta xchiꞌdxyi Dxiohs, zibahan ba par tuꞌpazi loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Laasii ¿xi galluꞌyi guicaꞌha tuhbi bwiinn gaduhbi loh guidxyiyuh sidela guñihchi ba xquelnabahan ba?, ");
INSERT INTO zpvNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","o neezaa ¿balaaca chiilli tuhbi bwiinn xcweenta xquelnabahan ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Neezaa sidela chyuulla tuhbi bwiinn gatuhyi loh ba naꞌh, o pur xchiꞌdxyiꞌhn nezloh raꞌ bwiinn nin rusahcaloh loh Dxiohs cun nin nuu loh raꞌ bwiinn nin nuu xtuhlda raꞌ ñiꞌh, neezaa naꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw zatuhyi loon pur bwiinn chi chin gabiaꞌgariin stuhbi cun gaduhbi xquelrnabwaꞌ Xtaaꞌdahn cun ziahan xaanjla Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Nee guchiin nin rñiꞌn loh tu, nuu raꞌ bwiinn nin dxaꞌga loh tu zwaꞌha raꞌ ba gadzihn xquelrnabwaꞌ Dxiohs galoh nin gachi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chin gudiiꞌdxi xoꞌpa dxyih, chiꞌchi gwanee Jesuhs laꞌh dxiꞌh raꞌ Pehdru, Jacobo, cun Jwahn yihca tuhbi dahan rooꞌ, nee riꞌchi bwaꞌha raꞌ xpwiinn Ñiꞌh chi bidxaꞌh ziga rñah Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ya xahba Ñiꞌh biahca labwehen dxyiꞌgah guhcabachaꞌhan, ayi nin tuhbi bwiinn nin guunn gahn gaca labweh ziga guhca labweh nachitsi xahba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ya riꞌchi baluuꞌyiloh Elías cun guehtu Moisehs, cayuuꞌyidxyiꞌdxyinee raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","chiꞌchi rahbi Pehdru loh Jesuhs: ―¡Mwehsu, bwen gahca dxuu nuꞌh riiꞌ! ¡Laꞌh nu guidiꞌhnnchaꞌyi chohnna yuuꞌ dxillaaꞌ; tuhbin para Yuꞌbiluꞌh, stuhbin para Moisehs, ya stuhbin para laꞌh Elías! ");
INSERT INTO zpvNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dxyigah ziꞌchi guñiꞌ Pehdru laasii rdxyihbi duxa ba cun schiohpa lasaaꞌ ba niꞌchin guñiꞌ ba ziꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ya hohra chi gahca biꞌ tuhbi xcahyi dxyiꞌgah si biaꞌpa raꞌ ba laꞌn xcahyi chi, ya laꞌn xcahyi chi guñiꞌ tuhbi rsiaaꞌha nin rahbi: ―Dee naa Lliiꞌnahn nin nadziiꞌhihn; gulgazoꞌbadxiahga xchiꞌdxyi bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ya mas balaaquiꞌhn rahca lwehgu bwaꞌha raꞌ ba tuhsi la Jesuhs zuu riꞌchi, ya laꞌn xcahyi chi guñihchiloh Moisehs cun Elías, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ya chin biehtanee Ñiꞌh laꞌh raꞌ ba dahan rooꞌ chi; chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh chi ayi xi guuyi raꞌ ba cuun nin bwaꞌha raꞌ ba hastayi chin gabahan Lliiꞌn Dxiohs nin naa ndxiꞌhw loh bwiinn guuchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ya bazoꞌbadxiahga raꞌ ba xchiꞌdxyi Ñiꞌh ayi gudxixteeꞌ raꞌ ba nin bwaꞌha raꞌ ba, per ziahan bwelta gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba cuun nin naa nin gabahan loh guelguhchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ya gunaabadxyiꞌdxyi raꞌ ba loh Jesuhs rahbi raꞌ ba: ―¿Xixnaa rahbi raꞌ mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs nahpa galoh Elías dxiꞌ que no laꞌh Crixtu? ");
INSERT INTO zpvNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Pwihsi guchii galoh Elías dxiꞌ tin dxiuꞌnzaꞌca ba garaatiiꞌ; neezaa rahbi loh Xchihtsi Dxiohs nahpa gutiꞌdxiloh Lliiꞌn Dxiohs trabahjw duxa nee zusaꞌcaloh za raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","per rñiꞌn loh tu laꞌh Elías biꞌ la ya laꞌh raꞌ bwiinn bwiꞌhnnee raꞌ ba laꞌh ba zigachiꞌzi guclaaꞌdzi raꞌ ba ziga rñiꞌ loh Xchihtsi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ya chin babiaꞌgarii Ñiꞌh hasta rii raꞌ snuhn xpwiinn Ñiꞌh bwaꞌha Ñiꞌh ziahan duxa bwiinn rii gadiidxi raꞌ ba, nee cadxihldxyinee dxyiꞌdxyi paaldaa raꞌ mwehsu nin ruluuꞌyi xlehyi Moisehs laꞌh raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ya chin bwaꞌha raꞌ bwiinn ziahan chi laꞌh Jesuhs, badxyigaaꞌ loh raꞌ ba hasta balluꞌn raꞌ ba bagachiꞌloh raꞌ ba laꞌh Ñiꞌh tin bagaꞌpaDxiohs raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―¿Xi niꞌca ruuꞌyidxyiꞌdxyinee tu laꞌh raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chiꞌchi rahbi tuhbi raꞌ bwiinn chi loh Ñiꞌh: ―Mwehsu, riiꞌ zeꞌldaneꞌhn lliiꞌnahn laasii nuu tuhbi bwiinndxaaba stoꞌ bi nin basiaꞌhan goopa laꞌh bi tin gabweꞌhe luꞌh bwiinndxaaba chi stoꞌ bi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","laasii chin rusaꞌcazii bwiinndxaaba chi laꞌh bi, rdxiindxiah bwiinndxaaba chi laꞌh bi loh yuh, rbweꞌhe ba bitsiꞌhn rwaaꞌ bi, nee hasta dxyigah rsihdzi loh lahyi bi. Squiiꞌ ruhnnee ba laꞌh bi nee cagasiuꞌnga gueldxyihdxyi chi laꞌh bi, niꞌchin nin gunaꞌbaꞌhn loh raꞌ xpwiinn luꞌh tin ñabweꞌhe raꞌ ba bwiinndxaaba chi stoꞌ bi per ayi bwiꞌhnn raꞌ ba gahn. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chiꞌchi rahbi Jesuhs loh raꞌ garaa bwiinn ziahan nin rii riꞌchi: ―¡Ayy, bwiinn raꞌ nin ayi riachiistoꞌ raꞌ ñiꞌh! ¡Bwiinn naxihn raꞌ! ¿Balaaca xchiꞌhla nin guꞌnnahn waanta chuuꞌhuhn loh tu? ¡Gultaaꞌnee lliiꞌngaaꞌn luꞌh riiꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ya chiꞌchi gwanee raꞌ ba laꞌh biꞌnxtuhbi chi loh Jesuhs, per chin bwaꞌha bwiinndxaaba chi laꞌh Jesuhs, chiꞌchi gudxiindxiah bwiinndxaaba chi laꞌh bi loh yuh, dxyigah naꞌduꞌbi bi loh yuh zohba bitsiꞌhn rwaaꞌ bi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","chiꞌchi rahbi Jesuhs loh xpah bi: ―¿Dez cuuca gunaꞌzu gueldxyihdxyi riiꞌ laꞌh bi? Chiꞌchi rahbi xpaah bi loh Ñiꞌh: ―Dez chin naa bi biñiꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","nee ziahan la xclaaꞌdzi bwiinndxaaba ca gadxiinn laꞌh bi; rulaꞌh bwiinndxaaba ca laꞌh bi loh bwehla, loh ñihsa; per sidela zidxeela xa guunn luꞌh balahsastoꞌ luꞌh laꞌh nu nee bwiꞌhnn ayuda laꞌh nu. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chiꞌchi rahbi Ñiꞌh loh bwiinn chi: ―¿Xa mohda rnaabadxyiꞌdxyi luꞌh sidela, zahca gacaneꞌhn yiꞌh? ¡Garaa zahca gacaneꞌhn laꞌh raꞌ bwiinn nin riachiistoꞌ raꞌ ñiꞌh zahca gacanee Dxiohs laꞌh raꞌ ba! ");
INSERT INTO zpvNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chiꞌchi guzoꞌbaloh jweersi cañiꞌ xpaah biꞌnxtuhbi chi loh Ñiꞌh, rahbi ba: ―¡Riachiistoꞌn! ¡Bwiꞌhnn cumpahñu naꞌh tin mahzi ru chechiistoꞌn! ");
INSERT INTO zpvNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ya chin bwaꞌha Jesuhs cagadiaaꞌha ziahan bwiinn chiꞌchi rahbi Ñiꞌh loh bwiinndxaaba chi: ―Bwiinndxaaba nin bwiꞌhnn gweꞌta cun goopa laꞌh biꞌnxtuhbi riiꞌ, naꞌh canabwaꞌn loh luꞌh tin bariaꞌh stoꞌ bi nee ayi dxiuꞌgarii ru luꞌh stoꞌ bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chiꞌchi gudidxyidxiah bwiinndxaaba chi cun dxyigah guidxiindxiah ba laꞌh bi, lwehgu bariaꞌh ba stoꞌ bi, ya basaaꞌn ba laꞌh bi zigazi bwiinn guuchi, ya bwiꞌhnn raꞌ bwiinn ziahan nin rii riꞌchi lligaaba guhchi bi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","per laꞌh Ñiꞌh lwehgu guteesa Ñiꞌh laꞌh bi, ya lwehgu gwasuꞌnchii biꞌnxtuhbi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chiꞌchi biuuꞌgarii Ñiꞌh laꞌñuuꞌ, ya riꞌchi gunaabadxyiꞌdxyi ralaꞌn raꞌ xpwiinn Ñiꞌh loh Ñiꞌh tin ayi chyu bwiinn ñwaꞌha ya rahbi raꞌ ba: ―¿Xixnaa laꞌh nu ayi chyu bidiꞌhnn gahn ñabweꞌhe bwiinndxaaba chi? ");
INSERT INTO zpvNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ziga lasaaꞌ bwiinndxaaba riiꞌ, ayi gaca cweꞌhe tu ba sidela ayi cwidxi-guinaaba tu loh Dxiohs, neezaa sidela ayi gucwaaꞌhan tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chin babii raꞌ ba riꞌchi, badiiꞌdxi raꞌ ba nez loh guihdxyi raꞌ xteenn Galilea, ya guclaaꞌdzi Jesuhs ayi chyu ñahcabwaꞌ canehz nuu Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","niꞌchin baluuꞌyi Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh nee rahbi za Ñiꞌh: ―Nahpa zutiꞌdxi raꞌ bwiinn duhlda naꞌh loh raꞌ nin rnabwaꞌ, ya zidxiinn raꞌ ba naꞌh, per chin dxiohnna dxyih guhchiꞌhn, zabahnaꞌhn loh raꞌ bwiinn guuchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per laꞌh raꞌ xpwiinn Ñiꞌh ayi guhcabwaꞌ raꞌ ba xi zee loh dxyiꞌdxyi raꞌ chi, nee bidxyihbi za raꞌ ba ñinaaba dxyiꞌdxyi raꞌ ba xiñin zee loh raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chin badzihnnee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh loh guihdxyi Capernaum, biuuꞌgarii Jesuhs laꞌn tuhbi yuuꞌ, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Xiñin zeꞌyuuꞌyidxyiꞌdxyi tu chin zoꞌpa nuꞌh loh neziuh? ");
INSERT INTO zpvNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ya ayi guñiꞌtiiꞌ raꞌ xpwiinn Ñiꞌh, laasii laꞌh raꞌ ba zeꞌyuuꞌyidxyiꞌdxyi raꞌ ba chyu tuhbi raꞌ ba naa nin mahzi lasahca, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ya lwehgu guzohbagah Ñiꞌh chiꞌchi gudihdxyi Ñiꞌh laꞌh gadziꞌh bichiohpa raꞌ xpwiinn Ñiꞌh chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Sidela xclaaꞌdzi tuhbi tu gaca lasahca, nahpa gaca tu tuhbi bwiinn nin nadoꞌlaadzi ru loh raꞌ garaa lasaaꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chiꞌchi gucaꞌha Ñiꞌh tuhbi biñiꞌn biꞌtuꞌhn, ya bazuh Ñiꞌh laꞌh bi galaayi raꞌ ba chiꞌchi gudiꞌdzi Ñiꞌh laꞌh biñiꞌniꞌhn chi, chiꞌchi rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Chyu chiꞌzi bwiinn nin gacanee tuhbi biñiꞌn squiiꞌ, zahcanee za ba naꞌh, nee bwiinn nin rahcanee naꞌh, ayi naꞌh dxiꞌhn rahcanee ba sino que nee Xtaada Dxiohsaꞌhn nin guluꞌnehza naꞌh rahcanee ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Seguihdu rahbi Jwahn loh Ñiꞌh: ―Mwehsu, bidiaꞌha nu loh tuhbi bwiinn nin rabweꞌhe bwiinndxaaba stoꞌ raꞌ bwiinn cun xquelrnabwaꞌ lah luꞌh, ya bachidiꞌtsi nu loh ba ayi ru guunn ba ziꞌchi laasii ayi nee dxiꞌh ba caꞌnzahnee ba laꞌh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulgasaaꞌn bwiinn chi laasii bwiinn nin ruhn dziꞌn roo raꞌ cun xquelrnabwaꞌ laan ayi xñiꞌyah ba naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tin bwiinn raꞌ nin ayi xclaaꞌdzi childxinee laꞌh nuꞌh xlahdu gahca nuꞌh nuu raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Guchiin nin rñiꞌn loh tu, bwiinn nin guniꞌhi nicala tuhbi bahsu ñihsa laꞌh tu laasii naa tu xpwiiꞌnn raꞌn, Dxiohs gudiꞌhi prehmiu laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Rahbi za Ñiꞌh: ―Chyu chiꞌh zi nin gusiaaba laꞌh biñiꞌn biꞌtuꞌhn raꞌ rii loh duhlda pur nin riachiistoꞌ raꞌ bi naꞌh, mas chaꞌyi gulaꞌha raꞌ ba laꞌh ba loh ñihsadoꞌ cun guchiꞌbi raꞌ ba tuhbi dxiah rooꞌ yahnn ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","nee sidela naa luꞌh rutsiigan yiꞌh loh duhlda, mas chaꞌyi guchyuuꞌga luꞌhn; tin mas chaꞌyi chuꞌtii luꞌh loh xquelrnabwaꞌ Dxiohs dxuuca luꞌh xlawaaꞌha chee luꞌh gabihldxyi cun garoopa naa luꞌh hasta ayi dxiuuꞌyitiiꞌ dxih, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","hasta tiidxi bwiinn trabahjw duxa para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ya sidela gadzihn dxyih gutsiiga ñaaꞌ luꞌh yiꞌh loh duhlda bachyuuꞌgan; mas chaꞌyi chuꞌtii luꞌh loh xquelrnabwaꞌ Dxiohs dxuuca luꞌh xlawaaꞌha garoopa ñaaꞌ luꞌh, chee luꞌh loh bwehla xteenn gabihldxi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","hasta tiidxi bwiinn trabahjw duxa para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nee sidela laꞌh tuhbi bizloh luꞌh gusiaaban yiꞌh loh duhlda, guleꞌhen; mas chaꞌyi chuꞌtii luꞌh loh xquelrnabwaꞌ Dxiohs nicala cun tuhbi si bizloh luꞌh xlawaaꞌha chenee garoopan yiꞌh loh dxih xteenn gabihldxyi ");
INSERT INTO zpvNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","hasta tiidxi bwiinn trabahjw duxa nin ayi chaꞌloh, nee ayi gariaꞌh raꞌ ba riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","laasii ziga rrohba zihdxi yihca xi chiꞌh zi guelwahw, ziꞌchi za chioobaa bwehla yihca garaa raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Bwen naa zihdxi, per sidela guñihchin guelnallii, ¿xaalla guunn chiꞌh tu dxiaca zaꞌcan? Ziꞌchi gahca laꞌh tu, gulgahca ziga zihdxi nin nallii tin gaca galluꞌyi tu loh raꞌ bwiinn guidxyiyuh, nee gulguibahannee zaꞌca lasaaꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Seguihdu babii Jesuhs loh guihdxyi Capernaum, tin zee Ñiꞌh para guihdxyi xteenn Judea cun loh guihdxyi xteenn yuh nin rii stuhbi lahdu guiꞌw Jordahn, ya riꞌchi badiaaꞌha ziahan bwiinn, chiꞌchi guzoꞌbaloh cagaluuꞌyi Ñiꞌh laꞌh raꞌ bwiinn chi ziga naa xcostumbre Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hohr chi badzihn raꞌ paaldaa bwiinn fariseu riꞌchi, per ya laꞌh raꞌ ba guclaaꞌdzi raꞌ ba guunn raꞌ ba prehba laꞌh Ñiꞌh tin gwaꞌha raꞌ ba zahca gusiaꞌgarii Ñiꞌh dxyiꞌdxyi nin gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh, rahbi raꞌ ba: ―¿Ta naa bwen taaꞌha tuhbi bwiinn laꞌh cheꞌhla ba? ");
INSERT INTO zpvNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Cuun nin ruluuꞌyi xlehyi Moisehs laꞌh tu? ");
INSERT INTO zpvNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Basaaꞌn Moisehs laꞌh raꞌ ndxiꞌhw cun sola tuhbi dxihtsi riahsa xcweenta nin rlaaꞌha raꞌ ba cheꞌhla raꞌ ba, ya bachiꞌh rusaaꞌn raꞌ ba cheꞌhla raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Bacaꞌh Moisehs ziꞌchi, laasii tantu bwiinn dxiipa tu, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","per chin gurihxchih guidxyiyuh: “Ndxiꞌhw cun gunnaꞌh bwiꞌhnn Dxiohs” ziga rñiꞌ loh Xchihtsi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Neezaa rñiꞌ loh Xchihtsi Ñiꞌh: “Niꞌchin chin ruchinaa tuhbi ndxiꞌhw, rreꞌcaa ba loh xtaada ba loh xmaah ba ya rbahannee ba laꞌh gunnaꞌh nin raaca cheꞌhla ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ya garoopa raꞌ ba naa ba zigazi tuhsi bwiinn”; naa raꞌ ba zigazi tuhbi bwiinn xlawaaꞌha chiohpa bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dxiohs bachiꞌdxiu-bachaꞌga laꞌh raꞌ ba, niꞌchin nin ayi nuu taaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ya chin rii raꞌ ba laꞌn stuhbi yuuꞌ, gunaabadxyiꞌdxyi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh xcweenta gahca nin rlaaꞌha lasaaꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Sidela laꞌh tuhbi bwiinn taaꞌha ba cheꞌhla ba ya guicaꞌha ba stuhbi gunnaꞌh, ya ziꞌchi canee lasaaꞌ zi raꞌ ba zigazi xtuꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ya sidela laꞌh tuhbi gunnaꞌh taaꞌha ba laꞌh xpwiinn ndxiꞌhw ba ya guicaꞌha ba stuhbi ndxiꞌhw, bwiinn chi nabahan gubwihlli zi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ya tantu guclaaꞌdzi raꞌ bwiinn chi dxihn raꞌ ba xchiꞌdxyi Jesuhs, hasta xpiñiꞌn raꞌ ba gwanee raꞌ ba loh Ñiꞌh, tin badziiꞌba naa Ñiꞌh yihca raꞌ bi, per chin bwaꞌha raꞌ xpwiinn Ñiꞌh niꞌchi guzoꞌbaloh riidxihldxyinee dxyiꞌdxyi raꞌ ba laꞌh raꞌ bwiinn nin zeꞌnee raꞌ biñiꞌn raꞌ chi loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ya chin bwaꞌha Jesuhs ziꞌchi cayahca, chiꞌchi bidxyiꞌchi Ñiꞌh ya rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh chi: ―Gulgasaaꞌn dxieꞌbiiga raꞌ biñiꞌn hasta zuꞌhn, ayi ru gucweꞌza tu laꞌh raꞌ bi, laasii xquelrnabwaꞌ Dxiohs naa xteenn raꞌ bwiinn nin nadoꞌlaadzi ziga biñiꞌn raꞌ riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","nee guchiin nin rñiꞌn loh tu, bwiinn nin ayi chechiistoꞌ ñiꞌh xchiꞌdxyi Dxiohs zigazi naa tuhbi biñiꞌn nin ruzoꞌbadxiahga xchiꞌdxyi xtaada ñiꞌh, bwiinn chin ayi chuu raꞌ ba loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chiꞌchi gudiꞌdzi Ñiꞌh laꞌh raꞌ biñiꞌn chi, nee tin badziiꞌba naa Ñiꞌh yihca raꞌ bi nee gunaaba gahca Ñiꞌh loh Dxiohs tin gacanee Ñiꞌh laꞌh raꞌ biñiꞌn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ya tuhbi dxyih gaduhbi nin caguꞌguihn Jesuhs guzee Ñiꞌh stuhbi nehza, badzihn galluꞌn tuhbi ndxiꞌhw hasta zuu Jesuhs, ya lwehgu bazuꞌnllihbi bi nezloh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","chiꞌchi rahbi bi loh Ñiꞌh: ―Daada, mwehsu chaꞌyi, ¿xa niꞌca guꞌnnahn tin guziaaꞌhahn dxibaaꞌ guibahaneꞌhn Dxiohs para tuꞌpazi chin gachiꞌhn? Chiꞌchi rahbi Jesuhs loh bi: ―¿Xixnaa rñiꞌ luꞌh naan chaꞌyiꞌhn? Ayi nin tuhbi bwiinn chaꞌyi naa xmohda ñiꞌh sola tuhbi dxiꞌh Dxiohs naa chaꞌyi. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Laꞌluꞌh naann la nin rnabwaꞌ loh Xchihtsi Dxiohs: “Ayi chiinn luꞌh bwiinn, ayi gaca luꞌh bwiinn gubwihlli, ayi cwaan luꞌh, ayi chiꞌnlaaꞌdzi luꞌh dxixiꞌhw, ayi gusaguiꞌhi laꞌh bwiinn, nee gaca nadziiꞌhi luꞌh xcuzahn raꞌ luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chiꞌchi rahbi ndxiꞌhw chi loh Ñiꞌh: ―Mwehsu, garaatiiꞌ raꞌ dxyiꞌdxyi ca cagazoꞌbadxiaagahn dez chin guhcaꞌhn biñiꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chin bwaꞌha Jesuhs loh ndxiꞌhw chi, guhca nadziiꞌhi stoꞌ Ñiꞌh laꞌh bi, chiꞌchi rahbi Ñiꞌh loh bi: ―Stuhbi dxiꞌh cohsa riaꞌdxyi guunn luꞌh; bwaa tin batooꞌ garaa xixteenn luꞌh ya chiꞌchi chiꞌzi luꞌh mweeyi chi guicaꞌha raꞌ bwiinn prohbi nin ayi xi nahpa, ya ziꞌchi zaapa luꞌh guelnazaꞌca llaaꞌndxibaaꞌ, nee lwehgu gahca daꞌnaꞌhla naꞌh tin guꞌa luꞌh xcruhzi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ya chin bihn ndxiꞌhw chi dxyiꞌdxyi raꞌ nin guñiꞌ Ñiꞌh, guhca nalaasa stoꞌ bi laasii ziahan rooꞌ xica nahpa bi, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","chiꞌchi biahyi Jesuhs tin bwaꞌha Ñiꞌh loh raꞌ xpwiinn Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¡Nagahn duxa par chuꞌtii tuhbi bwiinn rricu loh xquelrnabwaꞌ Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ya badxyigaaꞌ duxa loh raꞌ xpwiinn Ñiꞌh chin bihn raꞌ ba nin guñiꞌ Ñiꞌh, chiꞌchi rahbi Ñiꞌh stuhbi: ―Lliiꞌn raꞌ, ¡lliꞌballa nagahn naa para chuꞌtii bwiinn rricu loh xquelrnabwaꞌ Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas ayi guinagahn ru tiidxi tuhbi camehyu llaaꞌn tuhbi guihchi guulla, que no ziga tiidxi tuhbi rricu loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chin bihn raꞌ xpwiinn Ñiꞌh ziꞌchi chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―¿Chyuulla gaca chiꞌh taꞌh loh duhlda? ");
INSERT INTO zpvNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chiꞌchi bwaꞌha Ñiꞌh loh raꞌ ba ya rahbi Ñiꞌh: ―Para bwiinn raꞌ, nagahn raꞌ deeꞌ; per ayi nee dxiꞌh para laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Laꞌh nu laꞌnu dxugasaaꞌn garaa nin nadxiaapa nu, tin zoꞌpanaꞌhla nu yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Nee guchiin nin rñiꞌn loh tu, ziga bwiinn nin nugasaaꞌn yihdzi ñiꞌh, xpaah ñiꞌh, xmaah ñiꞌ, bwihtsi raꞌ ñiꞌh, cheꞌhla ñiꞌh, lliiꞌn ñiꞌh, o xuh raꞌ ñiꞌh pur xcweeꞌntahn cun pur xcweenta xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","zicaꞌha raꞌ ba garaa niꞌchi stuhbi gaywaꞌh bweelta mahzi ru loh guidxyiyuh riiꞌ nicala zidxyiꞌchinee bwiinn laꞌh raꞌ ba, per llaaꞌndxibaaꞌ zicaꞌha raꞌ ba guelnabahan nin ayi ñichilohtiiꞌ chin gachi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","laasii chin gadzihn dxyih nin guunn Dxiohs jwisi loh guidxyiyuh, garaa raꞌ bwiinn nin ruhnn lligaaba lasahcaduxa raꞌ ba nnah ayi gaca lasahcatiiꞌ raꞌ ba chiꞌchi, ya bwiinn raꞌ nin ayi lasahca nnah niꞌchi raꞌ gaca lasahca chiꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ya loh zeezah raꞌ ba loh neziuh para guihdxyi Jerusalehn ñiidxyuu Jesuhs ya dihtsi Ñiꞌh naꞌhla gadziꞌh bichiohpa raꞌ xpwiinn Ñiꞌh laasii rdxyihbi raꞌ ba nee coma guihdxyi chi nahpa chiinn raꞌ ba laꞌh Ñiꞌh, ya neezaa bwiinn raꞌ nin zee naꞌhla laꞌh Ñiꞌh rdxyihbi raꞌ ba, ya chiꞌchi guleꞌcaa Jesuhs gadziꞌh bichiohpa nin naa xpwiinn Ñiꞌh tin rahbi Ñiꞌh loh raꞌ ba cuun nin saca Ñiꞌh, squiiꞌ rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Gulguiaꞌha, rñiꞌn loh tu, laꞌh nuꞌh zoo para guihdxyi Jerusalehn, ya naꞌh ziga naan bwiinn nin guluꞌnehza Dxiohs loh guidxyiyuh, zutiꞌdxi raꞌ bixohza nin rnabwaꞌ laꞌh raꞌ bixohza naꞌh cun mwehsu raꞌ nin ruluuꞌyi lehyi zutiꞌdxi raꞌ ba naꞌh loh nin guunn guelguxchisi naꞌh. Nee guinabwaꞌ raꞌ ba gachiꞌhn cun gutiꞌdxi raꞌ ba naꞌh loh raꞌ bwiinn ziitu, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","niꞌchi raꞌ gusaꞌcazii naꞌh cun gullihdzinee raꞌ ba naꞌh, guchahn xihin raꞌ ba loon cun gadxiinn raꞌ ba naꞌh, per chin dxiohnna dxyih zabahanaꞌhn ―rahbi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo cun Jwahn, lliiꞌn Zebedeu, gwabiiga raꞌ loh Jesuhs ya rahbi raꞌ ba loh Ñiꞌh: ―Mwehsu, xclaaꞌdzi nu guunn luꞌh tuhbi bwen nin gachinaaba nu loh yuꞌbiluꞌh laꞌh nu. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Xiniꞌca bweniꞌhnca xclaaꞌdzi tu guꞌnnahn laꞌh tu? ");
INSERT INTO zpvNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Chin guinabwaꞌ luꞌh loh llaꞌñih xteenn luꞌh, xclaaꞌdzi nu zohbanee nu yiꞌh; tuhbi nu xlahdu derehchu luꞌh stuhbi nu xlahdu rrabwehsa luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Nin ayi gaann tu xiñin nin rnaaba tu. ¿Ta zizaꞌcaziinee tu naꞌh cun gachinee za tu naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chiꞌchi rahbi raꞌ ba: ―Nicala gachinee nu yiꞌh. Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Guchii tu zizaꞌcaziinee tu naꞌh nee zahchinee za tu naꞌh ziga gachiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","per ayi naꞌpahn derechu guiñaan loh tu cuun nin zohba xlahdu derechuꞌhn o xlahdu rrabwehsaꞌhn; sola Dxiohs cwii laꞌh raꞌ bwiinn nin soꞌbaneen llaaꞌn dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ya chin bihn zatsiꞌh xpwiinn Ñiꞌh nin gunaaba Jacobo cun Jwahn, bidxyiꞌchinee raꞌ ba laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","chiꞌchi gudihdxyi Jesuhs laꞌh raꞌ ba ya rahbi Ñiꞌh: ―Ba naann tu nin rnabwaꞌ loh raꞌ bwiinn nin ayi naa raꞌ bwiinn Israel naa raꞌ ba ziga dxiꞌba nin naguihdzi; neezaa cuun chiꞌh zi bwiinn nin lasahca loh raꞌ ba ruhnn ziꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","per cun laꞌh tu ayi gaca tu ziꞌchi, ya nin xclaaꞌdzi gaca nin mahzi lasahca nahpa gacanee ba laꞌh raꞌ lasaaꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ziꞌchi gahca za nin xclaaꞌdzi gaca nin mahzi guinabwaꞌ loh tu, nahpa gaca ba ziga tuhbi mooza loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","laasii naꞌh, Lliiꞌn Dxiohs nin naa ndxiꞌhw, ayi zeꞌlda dxiꞌhn para guunn bwiinn sirba loon, sino que naꞌh zeꞌldahn tin guꞌnnahn sirba, nee gudiꞌhi zan xquelnabahanahn para laꞌh raꞌ ziahan raꞌ bwiinn tin taꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ya chiꞌchi Jesuhs cun garaa za xpwiinn Ñiꞌh gudiiꞌdxinee Ñiꞌh laꞌh raꞌ ba nez guihdxyi nin laa Jericoh, ya zeenaꞌhla za ziahan raꞌ bwiinn laꞌh Ñiꞌh, ya loh neziuh xteenn rwaaꞌ guihdxyi chi zohba tuhbi bwiinn nin rahca loh ñiꞌh nin biriaꞌhlah Bartimeu lliiꞌn Timeu, rzohba ba rbweꞌhe ba cardah, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ya chin gudiiꞌdxidxiahga ba zeediiꞌdxi Jesuhs nin zeꞌ loh guihdxyi Nazaret riꞌchi, chiꞌchi guñiꞌ ba jweersi rooꞌ, rahbi ba: ―¡Jesuhs lliiꞌn guehtu Davihd, balahsastoꞌ luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ya bidxyiꞌchi ziahan raꞌ bwiinn niꞌchin rahbi raꞌ ba loh ba: ―¡Biacadxyii! ¡Ayi rñiꞌ luꞌh ziꞌca! Per laꞌh ba mahzi ru jwersi rooꞌ ru cañiꞌ ba: ―¡Lliiꞌn guehtu Davihd, balahsastoꞌ luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ya guzuhdxyiigah Jesuhs, chiꞌchi gunabwaꞌ Ñiꞌh gwacaꞌha raꞌ ba bwiinn chi ya rahbi raꞌ ba loh ba: ―Bazuhchihpa stoꞌ luꞌh, gwasuꞌnchii; yiꞌh cabwihdxyi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ya lwehgu guleꞌcaa bwiinn chi lahdxi nin caa dihtsi ba tin gudxihxi ban loh yuh, chiꞌchi gwasuꞌnchii galluꞌn ba ya gwah ba hasta zuu Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","chiꞌchi rahbi Jesuhs loh ba: ―¿Xiniꞌca xclaaꞌdzi luꞌh guꞌnnahn pur yiꞌh? Chiꞌchi rahbi bwiinn nin rahca loh ñiꞌh chi: ―Mwehsu, xclaaꞌdzihn guunn luꞌh gwaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chiꞌchi rahbi Ñiꞌh: ―Zahca guziaa luꞌh, laꞌh luꞌh biaca laasii gwachiistoꞌ luꞌh naꞌh. Ya hohra chi gahca biaca bizloh ba, ya zenaꞌhla ba laꞌh Jesuhs loh nehza. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ya chin zeegadzihn Ñiꞌh guihdxyi raꞌ nin laa Betfageh cun guihdxyi Betania nin riaꞌhan gahxu loh guihdxyi Jerusalehn nee gahxu za loh dahan nin laa Olivo, guxeꞌhla Jesuhs chiohpa xpwiinn Ñiꞌh ");
INSERT INTO zpvNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tin rahbi Ñiꞌh loh raꞌ ba: ―Gulcheh loh guihdxyi nin naa gahxu ru, ya chin gadzihn tu riꞌchi, riꞌchi zwaꞌha tu caduꞌh tuhbi buhrra nin nadxyiꞌbi nin nagahdxi gaca nadoꞌtiiꞌ; guxachi tu ma, tin dxieꞌnee tu ma, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ya sidela chyuulla guinaabadxyiꞌdxyi loh tu: “¿Xixnaa rigaxachi tu ma?” squiiꞌ guiñiꞌ tu loh bwiinn chi: “Tuhbi bwiinn nin mahzi rnabwaꞌ cachiꞌhn ma”, per lwehgu gahca gusiaꞌgarii ba ma. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pwihsi gwah raꞌ ba ya badxeela raꞌ ba hasta caduꞌh buhrra chi gahxu rwaaꞌ tuhbi pwerta xteenn tuhbi yuuꞌ, chiꞌchi guxachi raꞌ ba buhrra chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","neezaa gunaabadxyiꞌdxyi nuhn raꞌ bwiinn nin rii riꞌchi loh raꞌ ba, rahbi raꞌ ba: ―¿Xiniꞌca ruhnn tu? ¿Xinaa riigaxachi tu buhrra ca? ");
INSERT INTO zpvNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chiꞌchi rahbi raꞌ ba ziga rahbi Jesuhs guiñiꞌ raꞌ ba, ya cun basaaꞌn raꞌ ndxiꞌhw raꞌ chi zeenee raꞌ xpwiinn Ñiꞌh buhrra chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ya chin baganee raꞌ ba ma hasta zuu Jesuhs, chiꞌchi badziiꞌba raꞌ ba xahba raꞌ ba dihtsi ma, tin guzohba Jesuhs dihtsi ma, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ya ziahan raꞌ bwiinn gudxyihxi raꞌ ba xahba raꞌ ba loh neziuh nez hasta zeediiꞌdxinee ma laꞌh Ñiꞌh, ya snuhn raꞌ ba bachyuuꞌga lliiꞌdzi xteenn raꞌ yahga loh dahan tin gudxyihxi raꞌ ban loh neziuh hasta tiidxi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ya nuhn raꞌ bwiinn nin zeeñiidxiuu nez loh Jesuhs, cun snuhn raꞌ ba nin naꞌhla laꞌh Ñiꞌh, guzaꞌloh cañiꞌ raꞌ ba jweersirooꞌ, rahbi raꞌ ba: ―¡Bwen duxa naa Dxiohs! ¡Bwiꞌhnn taaꞌyi Dxiohs yihca rrehyi nin zeꞌ pura xcweenta Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Bwiꞌhnn taaꞌyi Dxiohs laꞌh guelrnabwaꞌ nin zeꞌ xcweenta xpaah Davihd nuꞌh! ¡Zuxchiilli Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ya loh nin guyuuꞌtii Jesuhs loh guihdxyi Jerusalehn, lwehgu gwah Ñiꞌh laꞌn guidoꞌ rooꞌ ya bwaꞌhasi za Ñiꞌh gadiidxitiiꞌ nee zigala coma gudxyihla niꞌchin lwehgu gahca gubiaꞌgariinee Ñiꞌh xpwiinn Ñiꞌh para guihdxyi Betania. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ya chin barah gueꞌla, babiinee Ñiꞌh xpwiinn Ñiꞌh guihdxyi Betania, bieꞌsuh bichiaꞌhan Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","chiꞌchi bwaꞌha Ñiꞌh tuhbi yahga ñiigu zihtu dxyigah nagaa rñah yahga chi cun batahga, niꞌchin gwaguiaꞌha Ñiꞌh gu nuu xi ñinahxi caa loh yahga chi, per ayi bidxeela Ñiꞌh nin tuhbin laasii ayi chiꞌchi dxiꞌh rcah ñinahxi, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ya delanta loh raꞌ xpwiinn Ñiꞌh rahbi Ñiꞌh loh yahga chi: ―Ayiru chuu dxyih guicah ñinahxi loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Zee chiꞌh Jesuhs para Jerusalehn cun xpwiinn Ñiꞌh, per loh nin guyuuꞌtii Ñiꞌh laꞌn guidoꞌ rooꞌ, guzoꞌbaloh babweꞌhedxiaꞌhla Ñiꞌh laꞌh raꞌ bwiinn nin cayuhnn guriꞌxi raꞌ, garaa nin riigatooꞌ cun nin riiziꞌ xica raꞌ riꞌchi; nee nezii-neziꞌchi guluꞌbwih Ñiꞌh xmweella raꞌ bwiinn nin ruchaꞌh mweeyi cun xagaxiiyi raꞌ nin rutooꞌ palohmma raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ya ayi ru basaaꞌn Ñiꞌh chyu bwiinn ñidiiꞌdxi nez hasta zohba guidoꞌ rooꞌ cun xica cohsa raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","baluuꞌyi Ñiꞌh laꞌh raꞌ bwiinn rahbi Ñiꞌh: ―Laꞌtu naann la xa rñiꞌ Dxiohs ziga caa loh Xchihtsi Dxiohs: “Yiidzihn gaca tuhbi yuuꞌ hasta dxiꞌ raꞌ garaa raꞌ bwiinn guidxyiyuh, tin cwidxyi-guinaaba raꞌ ba naꞌh”, ¡per laꞌh tu cayuhnn tun ziga zi tuhbi cwehva hasta riuuꞌ raꞌ gubaꞌn! ");
INSERT INTO zpvNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ya chin bihnn raꞌ bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza cun mwehsu raꞌ nin ruluuꞌyi lehyi nin bwiꞌhnn Jesuhs, gudxiꞌhyi raꞌ ba xa chiinn raꞌ ba laꞌh Ñiꞌh, per guyuuꞌ raꞌ ba guelnadxyiꞌbi laꞌh raꞌ bwiinn, laasii garaa raꞌ bwiinn badxyigaaꞌ duxa xcweenta ziga ruluuꞌyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ya chin gurih gueꞌla, biriaꞌh Ñiꞌh lahda guihdxyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ya chin barah gueꞌla rsiiyidoꞌ gudiiꞌdxinee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh hasta zohba yahga ñiigu nin guluꞌdii Ñiꞌh, ya yahga chi gubihdzi la hasta cun nee xtulbaaꞌhan, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ya loh nin bagannastoꞌ Pehdru nin guñiꞌ Ñiꞌh, chiꞌchi rahbi ba loh Ñiꞌh: ―Mwehsu, ¡bwaꞌha! ¡Laꞌh yahga ñiigu nin guluꞌdii luꞌh laꞌn gubihdzila! ");
INSERT INTO zpvNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chiꞌchi rahbi Ñiꞌh: ―Gulchechiistoꞌ tu Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","pwihsi naꞌpahn siguhra sidela chyulla gahbi loh dahan riiꞌ: “Biyaꞌdxu riꞌca tin gwah loh ñihsadoꞌ”, zuzoꞌbadxiahgan xchiꞌdxyi ba sidela ayi guunn chiohpa stoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Niꞌchin nin rñiꞌn loh tu sidela xiilla guinaaba tu loh Dxiohs, zuniꞌhi Ñiꞌhn, niꞌchin nin gulchechiistoꞌ tu laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chin cwidxyi-guinaaba tu loh Dxiohs, sidela nuu chyuulla bwiinn rdxyiꞌchinee tu, gulsiaꞌldastoꞌ tu xtuhlda ba, tin para dxiaꞌldaza stoꞌ Xtaada tu nin nuu dxibaaꞌ xtuhlda tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sidela ayi dxiaꞌldastoꞌ tu xtuhlda chyuulla bwiinn, neezaa Xtaada tu nin nuu dxibaaꞌ ayi dxiaꞌldastoꞌ za ba xtuhlda tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ya chin gubiaꞌgariinee Ñiꞌh laꞌh raꞌ ba para guihdxyi Jerusalehn, gwah Ñiꞌh laꞌn guidoꞌ rooꞌ stuhbi, ya riꞌchi zeezah Ñiꞌh chin badzihn raꞌ bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza cun nuhn mwehsu raꞌ nin ruluuꞌyi lehyi, cun nuhn bwiinn guhla raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ya rahbi raꞌ ba loh Ñiꞌh: ―¿Chyu baniꞌhi guelrnabwaꞌ yiꞌh tin ruhnn luꞌh dziꞌn raꞌ nin cayuhnn luꞌh?, o ¿chyu xquelrnabwaꞌ cayuhnn luꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Neezaa naꞌh guinaꞌbadxyiꞌdxyiꞌhn loh tu tuhbi rsohn, ya sidela chixteeꞌ tu, zidxixteeꞌzahn cun chyu xquelrnabwaꞌ ruꞌnnahñin. ");
INSERT INTO zpvNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Guldxixteeꞌ loon: ¿Chyu guxeꞌhla laꞌh Jwahn bieꞌgaroꞌbañihsa ba? ¿Ta Dxiohs guluꞌnehza laꞌh ba o bwiinn zi raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―¿Xa guidiꞌtsi nuꞌh? Sidela laꞌh nuꞌh guidiꞌtsi nuꞌh: “Dxiohs guluꞌnehza laꞌh ba”, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","chiꞌchi nnaa ba loh nuꞌh: “¿Xixnaa chiꞌh ayi gwachiistoꞌ tu xchiꞌdxyi ba?”, ¿o zidiꞌtsi nuꞌh: “Tuhbi bwiinnzi guxeꞌhla laꞌh Jwahn.”? Per ayi guhdzi raꞌ ba ziꞌchi laasii bidxyihbi raꞌ ba laꞌh raꞌ bwiinn, laasii bwiinn raꞌ nin rii nez chi ruhnn lligaaba Dxiohs guxeꞌhla laꞌh Jwahn, ");
INSERT INTO zpvNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","pwihsi cun rahbi raꞌ bwiinn dxixiꞌhw chi loh Ñiꞌh: ―Ayi chyu gaann chyu guxeꞌhla laꞌh Jwahn. Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Pwihsi zigasi za ayi nnaa tu chixteeꞌ tu nin canaabadxyiꞌdxyiꞌhn loh tu, ziꞌchi za naꞌh ayi chixteꞌhn loh tu chyu baniꞌhi guelrnabwaꞌ naꞌh cayuꞌnnahn dziꞌn raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ya gwazah bwiiꞌyidxyiꞌdxyi Jesuhs cweenta riiꞌ, rahbi Ñiꞌh: ―Guyuuꞌ tuhbi bwiinn, bwiꞌhnn biñih ba nuhn yahga uhva raꞌ loh xuh ba, chiꞌchi bwiꞌhnn ba leeꞌ gadiidxi loh yuh chi, neezaa bwiꞌhnn ba tuhbi tanque hasta guixiꞌh uhba raꞌ, cun bwiꞌhnnchaꞌyi za ba tuhbi yuuꞌ rooꞌ nin naa ziga tuhbi torre, ya basiaꞌhannee ba loh yuh chi laꞌh paaldaa bwiinn raꞌ tin gaapa raꞌ ban garoolda, ya chin gabweꞌhecaan liꞌhn nahpa gaca garoolda liꞌhn chi guicaꞌha raꞌ ba, ya zee chiꞌh ba zihtu rooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","per chin badzihn dxyih nin guunn garoolda raꞌ ba liꞌhn, chiꞌchi guxeꞌhla ballwaaꞌn nin naa xteenn ñiꞌh loh yuh tuhbi xmooza ba, tin gwagañiꞌ ba loh raꞌ bwiinn nin biaꞌhannee loh xuh ba tin ñudiꞌhi raꞌ ba liꞌhn nin ruhnn tucahri ñacaꞌha ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","per xlawaaꞌha ñudiꞌhi raꞌ ba nin ruhnn tucahri ñacaꞌha mooza chi, mejor gudxiꞌldxyihdxyi raꞌ ba laꞌh mooza chi ya ayi chiꞌh xi badiꞌhi raꞌ ba ñacaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Seguihdu guxeꞌhla ba stuhbi xmooza ba loh raꞌ ba, ya mooza chi basihdzidxiah raꞌ ba laꞌh ba gutaaꞌha raꞌ ba yihca ba nee biguii za raꞌ ba loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","per guxeꞌhla ba snuhn raꞌ xmooza ba. Nuhn raꞌ ba gudxiꞌldxyihdxyi raꞌ ba, ya snuhn raꞌ mooza chi gudxiinn raꞌ bwiinn nadxaaba raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Per biaꞌdxyi lliiꞌn ba nin nadziiꞌhi duxa ba, ya luulchima guxeꞌhla ba lliiꞌn ba, laasii bwiꞌhnn ba lligaaba: “Pwehda zuzoꞌbadxiahga raꞌ ba xchiꞌdxyi lliiꞌnahn.” ");
INSERT INTO zpvNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per chin badzihn bi, rahbi loh lasaaꞌ raꞌ nin raaꞌn loh xuh ba: “Bwaꞌha niꞌcasihn nin dxiaꞌhannee gaduhbi loh yuh riiꞌ; gulchooꞌho gachidxiinn nuꞌh bi tin laꞌh si nuꞌh gachicaꞌha nuꞌh gaduhbi loh yuh riiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pwihsi gunaꞌzu raꞌ ba laꞌh bi, gudxiinn raꞌ ba laꞌh bi ya chiꞌchi bagalaꞌha raꞌ ba xcweerpu bi rwaaꞌ yuh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chiꞌchi rahbi Jesuhs: ―Pwihsi, ¿xi ruhnn tu lligaaba gunnee daada nin naa xteenn ñiꞌh yahga uhva raꞌ laꞌh raꞌ bwiinn nin gudxiinn laꞌh lliiꞌn ba? Ziꞌ ba tin dxieꞌchiin ba garaa raꞌ bwiinn nin gudxiinn laꞌh lliiꞌn ba, ya chin chaꞌloh gachi raꞌ bwiinn chi, chiꞌchi gudiꞌhi ba loh yuh chi laꞌh raꞌ guriin bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pwehda nagahdxi guꞌlda tu loh Xchiꞌdxyi Dxiohs rahbi: Dxiah nin guleꞌhecaa raꞌ mwehsu albañihyi, dxiah chi bariaꞌcaa naa dxiah zaꞌca nnah. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dxiohs bwiꞌhnn lligaba ziꞌchi gaca, nee naan tuhbi bwen duxa para laꞌh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ya chiꞌchi guclaaꞌdzi bwiinn dxixiꞌhw raꞌ chi ñinaꞌzu raꞌ ba laꞌh Ñiꞌh hohra chi gahca, laasii gwasaa raꞌ ba dxyiꞌdxyi nin guñiꞌ Ñiꞌh loh raꞌ ba, per bidxyihbi raꞌ ba ñuhnn raꞌ ban, laasii rii ziahan rooꞌ bwiinn riꞌchi mejor ziaa raꞌ chiꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chiꞌchi guxeꞌhla raꞌ bwiinn dxixiꞌhw chi paaldaa raꞌ bwiinn fariseu loh Jesuhs cun neezaa raꞌ nin nin naa xpwiinn Herodes tin ñiñiꞌ Ñiꞌh xilla dxyiꞌdxyi raꞌ nin ñuhnn guelguxchisi laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ya chin badzihn raꞌ ba rahbi raꞌ ba loh Ñiꞌh: ―Mwehsu, naann nu xnehza rñiꞌ luꞌh cun ganaalla dxyiꞌdxyi nin guchii, ayi ruhnn luꞌh cweenta chyu chiꞌh zi bwiinn sino que ruluuꞌyi luꞌh cun gaduhbi stoꞌ luꞌh xneziuh zaꞌca Dxiohs; ¿ta naa xnehza gachidxilli nu impwestu loh rrehyi César o ayi chyu chiilli? ");
INSERT INTO zpvNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per lwehgu guhcabwaꞌ Jesuhs xa naa xigaaba raꞌ ba, chiꞌchi rahbi Ñiꞌh: ―¿Xixnaa ruhnn tu lligaaba guunn tu prehba naꞌh cun xchixiꞌhw tu? Gulgaluuꞌyi tuhbi xmweyi tu naꞌh tin gwaꞌhañin. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chiꞌchi badiꞌhi raꞌ ban, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Chyu yihca caa lohon, cun chyu laa caa lohon? Chiꞌchi rahbi raꞌ ba: ―Xteenn emperador. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgadiꞌhi laꞌh César nin naa xteenn ba, nee gulgadiꞌhi za laꞌh Dxiohs nin naa xteenn Ñiꞌh. Ya badxyigaaꞌ duxa loh raꞌ ba nin guñiꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ya chiꞌchi gwah paaldaa raꞌ bwiinn nin laa saduseu raꞌ, tin gwaguiaꞌha raꞌ ba loh Jesuhs, per saduceu raꞌ chi ayi riachiistoꞌ raꞌ ba gabahan raꞌ bwiinn loh guelguhchi, niꞌchin nin gunaabadxyiꞌdxyi raꞌ ba cweenta raꞌ riiꞌ loh Jesuhs, rahbi raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mwehsu, basiaꞌhannee Moisehs dxihtsi laꞌh nuꞌh, loh dxihtsi chi caa: “Sidela chyuulla tuhbi ndxiꞌhw nin bachinaa gachi nen ayi chyu lliiꞌn raꞌ ba guyuuꞌ cun xcunnaꞌh ba, niꞌchin nahpa guicaꞌha bwihtsi ba laꞌh gunnaꞌh chi tin chuu lliiꞌn raꞌ ba xcweenta guehtu guhla bwihtsi ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guidiꞌhnn nuꞌh nuu gahdzi ndxiꞌhw ya garaa raꞌ ba naa tuhsi bwihtsi raꞌ; bwiinn galoh bachinaa ba ya guhchi ba, per ayi chyu lliiꞌn ba guyuuꞌ cun xcunnaꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ya chiꞌchi gucaꞌha bwihtsi raroopa ba laꞌh gunnaꞌh viuhda chi per ayi za chyu lliiꞌn raꞌ ba guyuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ya ziꞌchi gahca za cada tuhbigah raꞌ ba hasta que no bachinaa gagaadzii raꞌ ba laꞌh gunnaꞌh chi, chiꞌchi neezaa gunnaꞌh chi guhchi per ayi chyu lliiꞌ raꞌ ba guyuuꞌ cun gunnaꞌh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yannah, chin gabiaꞌgarii gabahan raꞌ ba, ¿cuun paꞌh xchiꞌh nin naa cheꞌhla gunnaꞌh chi?, laasii gagaadzii raꞌ ba bachinaa laꞌh gunnaꞌh chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Cacheꞌh yihca tu, laasii ayi nuꞌnbwaꞌ tu loh Xchiꞌdxyi Dxiohs cun xcweenta xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chin gabahan raꞌ bwiinn loh guelguhchi, gaca raꞌ ba ziga aanjla raꞌ; ayiru guchinaa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ya loh ziga nin gabahan raꞌ bwiinn nin guchi, ¿ta nagahdxi guꞌlda tu loh dxihtsi nin bacaꞌh guehtu Moisehs xcweenta laꞌn yaguichaaꞌ nin gurih bwehla? Dxiohs rahbi loh Moisehs: “Naꞌh naan Xchiohs Abrahn, Xchiohs Isaac, cun Xchiohs Jacobo.” ");
INSERT INTO zpvNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pwihsi sidela laꞌh Dxiohs naa xpwiinn Ñiꞌh laꞌh raꞌ bwiinn raꞌ riiꞌ, ayi naa raꞌ ba bwiinn guuchi laasii nabahannee raꞌ ba laꞌh Ñiꞌh. Niꞌchin nin cacheꞌh duxa yihca tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ya chin badzihn tuhbi mwehsu nin ruluuꞌyi lehyi, biooba ru bihn dxiahga ba bwengahca basiaꞌgarii dxyiꞌdxyi Jesuhs, niꞌchin nin gwabiiga ba loh Ñiꞌh tin gunaabadxyiꞌdxyi ba squiiꞌ loh Jesuhs: ―¿Cuun xchiꞌdxyi xlehyi Moisehs nin mahzi lasahca loh garaa raꞌ dxyiꞌdxyi lehyi? ");
INSERT INTO zpvNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chiꞌchi rahbi Jesuhs: ―Squiiꞌ rñiꞌ dxyiꞌdxyi nin mahzi lasahca: “Gulgacaꞌdxiahga bwiinn Israel raꞌ, Xtaada Dxiohs nuꞌh naa tuhbi dxiꞌh sola Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gantsiiꞌhi luꞌh laꞌh Xtaada Dxiohs luꞌh cun gaduhbi stoꞌ luꞌh, cun gaduhbitiiꞌ xaalma luꞌh, cun gaduhbi lligaaba luꞌh, nee cun gaduhbi za xjweersi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ziꞌchi gahca za rñiꞌ nin raroopa dxyiꞌdxyi: “Gantsiiꞌhi luꞌh bwiinn raꞌ ziga nadziiꞌhi luꞌh yiꞌh gahca.” Ayi ru dxyiꞌdxyi nin mahzi lasahca loh dxyiꞌdxyi raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chiꞌchi rahbi mwehsu chi loh Jesuhs: ―Bwengahca, mwehsu; guchii dxyiꞌdxyi nin rñiꞌ luꞌh: Tuhbi dxiꞌh Dxiohs nuu, nee ayi stuhbi Ñiꞌh caalla nehza, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","nee nahpa gantsiiꞌhi luꞌh laꞌh Ñiꞌh cun gaduhbi stoꞌ luꞌh, cun gaduhbi xaalma luꞌh, cun gaduhbi xjweersi luꞌh, nee cun gaduhbi xigaaba luꞌh; nee gantsiiꞌhi luꞌh bwiinn raꞌ ziga nadziiꞌhi luꞌh yiꞌh gahca, ya dee raꞌ mahzi lasahcan loh Dxiohs loh ziga xiilla guhn nin gudiꞌhi luꞌh loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chin bwaꞌha Jesuhs xnehza guñiꞌ mwehsu chi chiꞌchi rahbi Ñiꞌh loh ba: ―Ayi zihtu ru dxiꞌh riaꞌhan luꞌh loh xquelrnabwaꞌ Dxiohs. Ya nin stuhbi raꞌ ba ayi biaalla ñinaabadxyiꞌdxyi ru xiilla dxyiꞌdxyi loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chin nuugaluuꞌyi Jesuhs xchiꞌdxyi Dxiohs laꞌn guidoꞌ, chiꞌchi rahbi Ñiꞌh: ―¿Xa mohda rñiꞌ raꞌ mwehsu nin ruluuꞌyi lehyi Crixtu naa lliiꞌn guehtu Davihd? ");
INSERT INTO zpvNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pwihsi guehtu Davihd gahca, pur Spíritu Saantu guñiꞌ ba rahbi ba: Daada Dxiohs rahbi loh Daada nin rnabwaꞌ naꞌh: “Guzohba xlahdu nanchiin hastayi gadzihn dxyih gutsiꞌgahn garaa raꞌ nin rdxyiꞌchinee yiꞌh nez ñaaꞌ luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","’Sidela laꞌh guehtu Davihd rahbi: “Crixtu guinabwaꞌ naꞌh”, ¿xaalla gaca chiꞌh Crixtu lliiꞌn Davihd? Ya ziahan nin rii riꞌchi nasaa bacaꞌdxiahga raꞌ ba nin cañiꞌ Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ya loh nin cagaluuꞌyi Jesuhs rahbi Ñiꞌh: ―Gulgaca nasiin tin ayi gusaguiꞌhi raꞌ mwehsu nin ruluuꞌyi xlehyi Moisehs laꞌh tu, laasii riuuꞌstoꞌ raꞌ ba rahcu raꞌ ba lahdxi nuꞌhla nin riuuꞌ hasta yahnn raꞌ ba, nee xclaaꞌdzi raꞌ ba garaa bwiinn guchaꞌgarwaaꞌ naa raꞌ ba nez loh dxiaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nee rdxiꞌhyi raꞌ ba puur yagaxiiyi zaꞌca nin lasahca rzohba raꞌ ba laꞌn guidoꞌ, nee cun hasta rahca za guelwahw, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","neezaa rbweꞌhelluꞌhu raꞌ ba yihdzi gunnaꞌh viuhda raꞌ, ya hohra chi gahca xchih rbwihdxyi-rnaaba raꞌ ba loh Dxiohs tin guiñah raꞌ ba zigazi bwiinn nazaꞌca duxa, per laꞌh raꞌ ba nalasa ru zuhnnee Dxiohs laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ya tuhbi bweelta zohba Jesuhs nez zuu raꞌ alcansía nin riuuꞌ mweyi guelguhn, caywaꞌha Ñiꞌh xa rulaꞌh raꞌ bwiinn mweeyi laꞌn alcansía raꞌ chi, neezaa ziahan raꞌ bwiinn rricu riigalaꞌha za ziahan mweeyi, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ya hohra chi gahca badzihn tuhbi viuhda prohbi, balaꞌha ba chiohpa mweyi gaꞌyuꞌhn laꞌn alcansía chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, gunnaꞌh viuhda prohbi ca ziahan ru mweeyi balaꞌh ba loh snuhn raꞌ bwiinn nin balaꞌha raꞌ mweeyi laꞌn alcansía ca, ");
INSERT INTO zpvNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","pwihsi garaa raꞌ ba nin riaꞌhancah si rulaꞌha raꞌ ba, per gunnaꞌh ca loh xquelprohbi ba, balaꞌha ba garaa meewyiꞌhn nin nahpa ba, hasta nin ñioꞌh xquehta ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chin bariaꞌh Jesuhs laꞌn guidoꞌ rooꞌ, chiꞌchi guñiꞌ tuhbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh, rahbi ba: ―Mwehsu, ¡bwaꞌha dxiah roo raꞌ ca nee bwaꞌha yuuꞌ rooza raꞌ ca! ");
INSERT INTO zpvNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chiꞌchi rahbi Jesuhs loh ba: ―¿Ta rwaꞌha luꞌh yuuꞌ roo riiꞌ nnah? Per zadzihn dxyih nin ayi dxiaꞌhancah nin tuhbi dxiah nin dziꞌba yihca lasaaꞌ raꞌ, garaa raꞌn zibwih raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Lwehgu zeenee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh tuhbi dahan nin laa Olivo nin riaꞌhan gahxu hasta zohba guidoꞌ, riꞌchi zohba Ñiꞌh, chin gunaabadxyiꞌdxyi raꞌ Pehdru cun Jacobo cun Jwahn neezaa Andrehs loh Jesuhs squiiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Gunnah loh nu, ¿cuuca gaca cohsa raꞌ ca, nee xa naa sehn raꞌ nin gaca chin amweer laꞌn gaca raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chiꞌchi rahbi Jesuhs: ―Gulgahca nasiin tin ayi chyuulla gusaguiꞌhi laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","laasii ziꞌ ziahan raꞌ bwiinn nnaa raꞌ ba: “Naꞌh naan Crixtu”, ya ziꞌchi gusaguiꞌhi raꞌ ba ziahan bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Chin dxiinn tu cayahca guehrru riidxiinn lasaaꞌ raꞌ bwiinn o guelnadxyiꞌbi xteenn guehrru, ayi xi lligaaba guunn tu laasii ziꞌchi nahpa gaca, per nagahdxi gadzihn dxyih nin ñichiloh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tuhbi lahdxyi bwiinn gucaꞌnee laꞌh stuhbi lahdxyi bwiinn, neezaa paaldaa raꞌ gubieerna chindxinee laꞌh spaaldaa raꞌ ba, nee gaca lluh rooꞌ raꞌ ziahan lahta, nee chuu za gubihn ziahan lahta, per galoh gaca garaa raꞌ cohsa raꞌ riiꞌ gueꞌdu soꞌbaloh zi guelrzaꞌcazii niꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Gulgaca nasiin laasii zinaꞌzu raꞌ ba laꞌh tu neezaa zutiꞌdxi raꞌ ba laꞌh tu loh raꞌ guxchisi, nee gucaꞌyahga raꞌ ba laꞌh tu laꞌn xquidoꞌ biꞌtuꞌhn raꞌ ba, cun zutiꞌdxi raꞌ ba laꞌh tu loh raꞌ gobernador raꞌ cun loh raꞌ rrehyi raꞌ tin gaca guiñiꞌ tu xchiꞌdxyiꞌhn loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Galoh nin nagahdxi gaduhbi guidxyiyuh, nahpa guidiꞌchi xchiꞌdxyi Dxiohs loh garaa raꞌ bwiinn guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","nee ayi xi lligaaba guunn tu xa guiñiꞌ tu loh raꞌ ba chin guinaꞌzu raꞌ ba laꞌh tu, chin gutiꞌdxi raꞌ ba laꞌh tu loh raꞌ nin rnabwaꞌ. Gulguiñiꞌ loh raꞌ ba nin guluuꞌyi Dxiohs laꞌn lastoꞌ tu guiñiꞌ tu, laasii ayi laꞌh dxiꞌh tu nin guiñiꞌ sino que Spíritu Saantu nin rbweeza laꞌn lastoꞌ tu gacanee laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndxiꞌhw raꞌ zutiꞌdxi raꞌ ba bwihtsi raꞌ ba loh guelguhchi, cun nee daada raꞌ cun lliiꞌn raꞌ ba ya lliiꞌn raꞌ ba zucaꞌnee raꞌ bi laꞌh raꞌ ba, tin gutiꞌdxi raꞌ bi laꞌh raꞌ ba loh guelguhchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ya garaa raꞌ bwiinn guidxyiyuh guidxyiꞌchinee raꞌ ba laꞌh tu laasii riachiistoꞌ tu xchiꞌdxyiꞌhn, per bwiinn nin ayi cweꞌhestoꞌ ñiꞌh xchiꞌdxyiꞌhn bwiinn chi taꞌh loh duhlda tin guziaa ba dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ya chin gwaꞌha tu nin naa guelrdxyiꞌchinee loh Dxiohs, nin naa guelruñichiloh loh Dxiohs ziga bazeꞌta guehtu profeta Daniel; chin gwaꞌha tu zuu niꞌchi nez ayi ruhnn tucahri suuꞌhun, niꞌchi bwiinn raꞌ nin rii guihdxyi Judea nahpa gulluꞌn raꞌ ba para loh dahan, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ya bwiinn nin caa yihca yihdzi ñiꞌh ayi dxieeta raꞌ ba chegaleꞌhe raꞌ ba xixteenn raꞌ ba laꞌn yihdzi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ya bwiinn raꞌ nin rii raꞌ la loh dahan ayi ru guibiaꞌgarii raꞌ ba chegalliꞌhi raꞌ ba xahba raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Prohbi laꞌh raꞌ gunnaꞌh nin nuꞌa lliiꞌn raꞌ laꞌn dxyih raꞌ chi o gunnaꞌh raꞌ nin caꞌha badoꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gulguinaaba loh Dxiohs ayi gaca cohsa raꞌ riiꞌ loh bweꞌhw nin rahca nahlda, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","laasii guelrzaꞌcazii nin chuu loh guidxyiyuh laꞌn dxyih raꞌ chi gacan guelrzaꞌcazii roo ru loh xichiꞌzi stuhbi guelrzaꞌcazii nin guhca cun nin cayahca dez chin gulahchixchih Dxiohs guidxyiyuh, nee ayi guibiaꞌgarii stuhbi guelrzaꞌcazii ziga niꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","nee sidela laꞌh Dxiohs ayi guchyuuꞌga Ñiꞌh yihca raꞌ dxyih raꞌ chi, ayi chyu taꞌh tiiꞌ; per zuchyuuꞌga Ñiꞌh yihca raꞌ dxyih chi laasii nadziiꞌhi Ñiꞌh laꞌh raꞌ bwiinn raꞌ nin bibwiꞌhi raꞌ la gaca raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Nee chin gadzihn dxyih raꞌ chi, sidela chyuulla nnaa loh tu: “¡Bwaꞌha, laꞌh Crixtu zuu riiꞌ!”, o “¡Bwaꞌha, riꞌchi laꞌh ba zuu!”, ayi chechiistoꞌ tu bwiinn nin nnah ziꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","laasii bwiinn raꞌ nin rñiꞌ si, nnah naa raꞌ ba Crixtu nin rñiꞌ xchiꞌdxyi Dxiohs ya zuhnn raꞌ ba sehn raꞌ cun dziꞌn rooꞌ raꞌ tin ziꞌchi gusaguiꞌhi raꞌ ba laꞌh raꞌ bwiinn, nee sidela ñahca pwehda hasta nee bwiinn raꞌ nin gulii Dxiohs guiclaaꞌdzi raꞌ ba gusaguiꞌhi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Niꞌchin nin gulgaca nasiin. Loh garaa raꞌ cohsa raꞌ riiꞌ laꞌn guñiꞌneen laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Rahbi za Ñiꞌh: ―Per chin chaꞌloh raꞌ dxyih xteenn guelrzaꞌcazii chi, zacahyi loh gubihdxyi neezaa bweꞌhw ayi gudiꞌhi ru biaꞌñih, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","neezaa dxih nin nuu llaaꞌndxibaaꞌ dxiaaba raꞌn hasta nee cohsa raꞌ nin rbahchi xnehza dxih nin nuu llaaꞌndxibaaꞌ guiñiꞌbi, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ya chiꞌchi gwaꞌha raꞌ bwiinn gadzihnaꞌhn ziga bwiinn nin guluꞌnehza Dxiohs, dxieꞌldahn laꞌn xcahyi cun gaduhbi guelrnabwaꞌ cun llaꞌñih, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ya guixeꞌhla raꞌn xaanjlaꞌhn gaduhbitiiꞌ loh guidxyiyuh cun gaduhbitiiꞌ dxibaaꞌ tin gutiaaꞌha raꞌ ba laꞌh raꞌ bwiinn nin gulii Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Gulguiaꞌha loh tuhbi yahga ñiigu; chin gwaꞌha tu laꞌraꞌ yahga cabweꞌhe bwiiꞌniꞌhn, laꞌhgahca tu rahcabwaꞌ tu lwehgu radzihn bweꞌhw nin dxiaaba ñihsadxiah, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ziꞌchi gahca za chin gwaꞌha tu laꞌraꞌ cohsa raꞌ riiꞌ cayahca, laꞌh gahca tu gacabwaꞌ tu lwehgu gahca guibiaꞌgariin tin guinabwaꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Guchiin nin rñiꞌn loh tu, garaa cohsa raꞌ riiꞌ gacan galoh gachi raꞌ bwiinn nin rii nabahan raꞌ laꞌn dxyih raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dxibaaꞌ cun guidxyiyuh ziñichiloh raꞌn per xchiꞌdxyiꞌhn ayi ñichiloh raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","per dxyih cun hohra nin gaca cohsa raꞌ chi ayi chyu gaann; nin xaanjla raꞌ Dxiohs ayi gaann raꞌ, cun naꞌh nin naan Lliiꞌn Dxiohs ayi gaꞌnnahn xohra gaca cohsa raꞌ chi, sino que yuꞌbi Xtaadasihn naann xohra gacan, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","niꞌchin nin gulgaca nasiin laasii ayi chyu gaann xohra gadzihn dxyih raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gacan ziga tuhbi ndxiꞌhw nin rusiaꞌhan yihdzi ñiꞌh, bachiꞌh zee ba zihtu rooꞌ, ya rusiaꞌhannee ba garaatiiꞌ laꞌh xmooza ba, cada tuhbigah raꞌ ba cun dziꞌn nin nahpa guunn raꞌ ba, ya rahbi ba loh mooza nin rahpa rwaaꞌ leeꞌ guhldaꞌtsi ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ziꞌchi za gulcwihsiin laasii laꞌh tu naa tu ziga laꞌh raꞌ ba nin ayi gaann tu cuuca guibiaꞌgarii xballwaꞌn tu; ayi gaann tu gu gudxyih gabiaꞌgarii ba o garoolda gueꞌla, o gucahyi, o rsiiyidoꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","tin ayi darpwenta guibiaꞌgarii ba nee naꞌllgahsi si tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nin rñiꞌn loh tu cañiꞌn loh garaatiiꞌ tu; ¡gulcwih nasiin para hohra chi! ");
INSERT INTO zpvNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Riaꞌdxyi schiohpa dxyih para lañih paascu chin rahw raꞌ ba pahn nin ayi rahcachaꞌyi cun levaduhra, ya bwiinn raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza cun mwehsu raꞌ nin ruluuꞌyi lehyi Moisehs, cadxiꞌhyi raꞌ ba xa guunn raꞌ ba tin chiinn raꞌ ba laꞌh Jesuhs pur guelrusaguiꞌhi nin xclaaꞌdzi raꞌ ba guunn raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","pwihsi nuhn raꞌ ba rahbi: ―Ayi chyu chiinn laꞌh Jesuhs dxyih lañih tin ayi chasa raꞌ bwiinn guihdxyi chindxyinee raꞌ ba laꞌh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Chin nuu Jesuhs tuhbi guihdxyi nin laa Betania, gwah Ñiꞌh yihdzi Simohn nin guhchyi guiiꞌdxiu tihxi ñiꞌh; riꞌchi zohba Jesuhs hasta zuu mweella chin badzihn tuhbi gunnaꞌh nin gwanee tuhbi mwehdxi biꞌtuꞌhn nsehchi nahxi nin lasahcaduxa mweeyi ziahan, seguihdu gutaaꞌha bi yahnn mwehdxi chi, chiꞌchi gudaꞌbi bi nsehchi chi yihca Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ya bidxyiꞌchi nuhn raꞌ nin rii riꞌchi, chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―¿Xixnaa calliꞌn nsehchi nahxi ca? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ñahca ñidooꞌhon mas chohnna gaywaꞌh denariu, tin ñahcaneeꞌhen laꞌh raꞌ bwiinn prohbi. Ya niꞌchin cañiꞌyah raꞌ ba laꞌh gunnaꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ya rahbi Jesuhs loh raꞌ ba: ―Gulgasaaꞌn bi; ¿xixnaa cayuhnn tu llahn laꞌh bi? Naa bwen nin bwiꞌhnn bi, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","pwihsi bwiinn prohbi zwaꞌha tu loh raꞌ ba gaduhbi nin guibahan dxiꞌh tu nee zahca gacanee tu laꞌh raꞌ ba chin xclaaꞌdzi chiꞌh zi tu; per naꞌh ayi gaduhbi nin guibahan tu gwaꞌha tu naꞌh o chuuneen laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Gunnaꞌh riiꞌ bwen gahca bwiꞌhnn bi cun nin guhca bwiꞌhnn bi: gudaꞌbigah bi nsehchi nahxi naꞌh, tin chee xcweeꞌrpuhn laꞌn baꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Guchiin nin rñiꞌn loh tu, ca chiꞌzi lahta xteenn guidxyiyuh hasta gadzihn xchiꞌdxyi Dxiohs ziñiꞌ raꞌ za ba xcweenta nin bwiꞌhnn gunnaꞌh riiꞌ pur naꞌh, tin dxiagannastoꞌ tu laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pwihsi seguihdu gucaꞌha Judas Iscariote, nin naa tuhbi xpwiinn Jesuhs loh gadziꞌh bichiohpa xpwiinn Ñiꞌh, gwaguihtsi ba loh raꞌ bwiinn nin rnabwaꞌ laꞌh raꞌ bixohza tin dxiuuꞌn ntriehgu Judas laꞌh Jesuhs loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ya chin bihn raꞌ ba ziꞌchi guunn Judas biahxi raꞌ ba, niꞌchin guhdzi raꞌ ba gudiꞌhi raꞌ ba nuhn mweeyi laꞌh Judas sidela guunn ban, chiꞌchi guzaꞌloh gudxiꞌhyi Judas xa guunn ba para dxiuꞌn ba ntriehgu laꞌh Jesuhs loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ya mwer dxyih lañih chin rahw raꞌ bwiinn Israel pahn nin ayi rahcachaꞌyi cun levaduhra, chin rdxiinn raꞌ ba lliꞌhyi nin gahw raꞌ ba xchih paascu, pur nin riaganna stoꞌ raꞌ ba dxyih chi nin bareꞌh raꞌ ba loh guihdxyi Egiptu, chiꞌchi gunaabadxyiꞌdxyi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh rahbi raꞌ ba: ―¿Canehza xclaaꞌdzi luꞌh gachidiꞌhnnchaꞌyi nu guelwahw xteenn xchih paascu riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chiꞌchi guxeꞌhla Ñiꞌh chiohpa xpwiinn Ñiꞌh ya rahbi Ñiꞌh loh raꞌ ba: ―Gulcheh lahda guihdxyi. Riꞌchi zadxaꞌga tu tuhbi bwiinn nin nuꞌa tuhbi riiꞌ ñihsa; chenaꞌhla tu laꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ya hasta dxiuꞌgarii ba gulguiñiꞌ loh nin naa yihdzi ñiꞌh riꞌchi: “Nnaa mwehsu: ¿Canehza riaꞌhan cwaartu hasta gahwchihnee ba xpwiinn ba xchih paascu riiꞌ?” ");
INSERT INTO zpvNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya laꞌh bwiinn chi lwehgu si guluuꞌyi ba hasta naa cwaartu rooꞌ nin nuu guiyaꞌ laꞌn naa listu la. Riꞌchi gulguiguihn nin guidaꞌwxchih nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chiꞌchi gunaꞌzu nehza raꞌ xpwiinn Ñiꞌh tin zee raꞌ ba lahda guihdxyi chi, ya guyaa bareꞌcaa garaatiiꞌ nin guhdzi Jesuhs, chiꞌchi bwiꞌhnnchaꞌyi raꞌ ba xchih paascu riꞌchi para garaa raꞌ ba cun laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ya chin guhca guxiin badzihnnee Jesuhs laꞌh raꞌ snuhn raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ya loh riiyahw raꞌ ba rahbi Jesuhs loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, tuhbi gahca tu ziga cayahwnee tu naꞌh riiꞌ zutooꞌ naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chiꞌchi guhca nalaasa stoꞌ raꞌ xpwiinn Ñiꞌh, ya gunaabadxyiꞌdxyi raꞌ ba tuhbigah raꞌ ba loh Ñiꞌh, rahbi raꞌ ba: ―¿Ta naꞌhan? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Bwiinn chi naa tuhbi nin naa tu tsiꞌh bichiohpa xpwiiꞌnnahn, nin nuugagahdxyi xpahn ñiꞌh loh xplahtuhn ziga gahca naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Guchii nahpa ziaaꞌhahn ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, ¡per prohbi za laꞌh bwiinn nin gutooꞌ naꞌh! Mas chaꞌyi ayi ñaalaa ba loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ya loh gaduhbi nin riiyahw raꞌ ba, gucaꞌha Jesuhs tuhbi pahn, tin badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs, hohra chi gutaaꞌha Ñiꞌhn gudxiꞌzi Ñiꞌhn loh raꞌ ba, chiꞌchi rahbi Ñiꞌh: ―Gulguicaꞌhan, laasii dee nin naa ziga tiꞌxihn. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chiꞌchi gucaꞌha Ñiꞌh tuhbi cohpa vihnnu, ya chin guyaꞌloh badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs, chiꞌchi badiꞌhi Ñiꞌhn laꞌh raꞌ ba tin gudxiꞌzi loh lasaaꞌ raꞌ ba vihnnu chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","chiꞌchi rahbi Ñiꞌh: ―Vihnnu riiꞌ naa ziga rihn nin nuuꞌhuhn, nin guilliꞌhihn chin chiinn raꞌ ba naꞌh xcweenta ziahan raꞌ bwiinn guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","nee guchiin nin rñiꞌn loh tu, ayi ru guibiaꞌgarii gueeꞌhehn vihnnu laꞌh tu, hasta que no gueeꞌheñin stuhbi hasta rnabwaꞌ Dxiohs llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ya chin guyaꞌloh biꞌlda raꞌ ba tuhbi himno, chiꞌchi gwah raꞌ ba tuhbi dahan nin laa Olivo, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","riꞌchi rahbi Jesuhs: ―Garaatiiꞌ tu gusaaꞌn tu naꞌh nnagueꞌla, laasii rñiꞌn loh Xchihtsi Dxiohs: “Gusaaꞌn Ñiꞌh chiinn raꞌ ba laꞌh baxtohra, ya lliꞌhyi raꞌ zulluꞌn raꞌ ma.” ");
INSERT INTO zpvNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per chin gabahanaꞌhn, galooruhn guzaaꞌñiidxiuhn nez loh guihdxyi Galilea que laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chiꞌchi rahbi Pehdru: ―Nicala garaa raꞌ ba gusaaꞌn raꞌ ba yiꞌh, per naꞌh ayi gusaꞌnaꞌhn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chiꞌchi rahbi Jesuhs: ―Guchiin nin rñiꞌn loh luꞌh, nnah gueꞌla gahca antes nin gucaꞌhyahn dxiidxinguhla chiohpa bweelta, ziñiꞌ luꞌh chohnna bweelta ayi nuꞌnbwaꞌtiiꞌ luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Chiꞌchi rahbi Pehdru: ―Nicala gachi za nuꞌh, ayi gasaꞌnaꞌhn yiꞌh. Nee ziꞌchi gahca za rahbi raꞌ ru gallee xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ya chin badzihnnee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh tuhbi lahta hasta laa Getsemanii, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulsohba riiꞌ gaduhbi nin cwidxyi-guinaꞌbaꞌhn loh Xtaaꞌdahn nin nuu dxibaaꞌ tin gacanee Ñiꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ya gwanee Ñiꞌh laꞌh Pehdru, Jacobo, cun Jwahn, riꞌchi guhca nalasa duxa stoꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Laꞌn lastoꞌn nuu tuhbi guelnalasa xteenn guelguhchi, guldxiaꞌhan si riiꞌ ayi gasi tu. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ya seguihdu gwah Jesuhs delanta ru, tin riꞌchi baruꞌhn Ñiꞌh hasta loh yuh, tin gudihdxyi-gunaaba Ñiꞌh loh Xtaada Dxiohs Ñiꞌh tin ñuldaꞌh Xtaada Ñiꞌh laꞌh Ñiꞌh loh trabahjw duxa nin nahpa tiidxi Ñiꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ya loh cabwihdxyi-canaaba Ñiꞌh rahbi Ñiꞌh: ―Paah, ¿tayi gaca guchaꞌh xigaaba luꞌh tin guhldaꞌh luꞌh naꞌh loh trabahjw duxa nin tiꞌdxiꞌhn? Per ayi gacan ziga naa xigaaꞌbahn sino que ziga naa xigaaba luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ya seguihdu gwasuꞌnchii Ñiꞌh tin gwaguiaꞌha Ñiꞌh cuun raꞌ xpwiin Ñiꞌh, ya chin badzihn Ñiꞌh nez rii raꞌ ba, bwaꞌha Ñiꞌh laꞌh raꞌ ba naꞌxgahsi, chiꞌchi rahbi Ñiꞌh loh Pehdru: ―Simohn, ¿ta naꞌxgahsi luꞌh? ¿Ta nin tuhbi hohra ayi bwiꞌhnn luꞌh waanta ñiriaꞌxcaꞌlda luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ayi gasiru tu, mas chaꞌyi gulcwihdxyi-gulguinaaba loh Dxiohs tin gacanee Ñiꞌh laꞌh tu tin ayi gusaguiꞌhi bwiinndxaaba laꞌh tu. Lastoꞌ tu xclaaꞌdzi guunn tu xnehza per tihxi tu casiꞌnaaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chiꞌchi biriaꞌcaa Ñiꞌh stuhbi nez rii raꞌ ba tin gudihdxyi-gunaaba laꞌgaꞌh Ñiꞌh loh Xtaada Dxiohs Ñiꞌh cun dxyiꞌdxyi gahca nin guñiꞌ Ñiꞌh galoh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ya chin gubiaꞌgarii Ñiꞌh stuhbi, laꞌh raꞌ ba naꞌxgahsi laasii nuu duxa bacaꞌlda loh raꞌ ba, ya nin ayi gaann raꞌ ba xa ñusiaꞌgarii raꞌ ba dxyiꞌdxyi loh Ñiꞌh hohra chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ya nin riohnna bweelta rbiaꞌgarii Ñiꞌh chiꞌchi rahbi Ñiꞌh: ―¿Ta zezahtiiꞌ naꞌxgahsi tu? Gulchestii tin laꞌh hohra bigaꞌha guinaꞌzu bwiinn duhlda laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gulchestii tin gulchoꞌho, laasii laꞌh nin guunn ntriehgu naꞌh zeꞌgadzihn. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya gaduhbi nin cañiꞌgahca Jesuhs loh raꞌ xpwiinn Ñiꞌh, badzihn Judas nin naa tuhbi gahca xpwiinn Ñiꞌh cun ziahan raꞌ bwiinn nin nuꞌa raꞌ spahda cun garrohta, zee raꞌ ba pur xchiꞌdxyi raꞌ bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza cun pur xchiꞌdxyi raꞌ mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs cun pur xchiꞌdxyi raꞌ bwiinn guuhla raꞌ xteenn raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ya Judas nin biuꞌn ntriehgu laꞌh Ñiꞌh rahbi loh raꞌ bwiinn duhlda chi nin naa tuhbi sehn gaca squiiꞌ: ―Bwiinn nin guchaꞌga rwaaꞌhahn, bwiinn chi naa laꞌh ba; guinaꞌzu tu ba nee gulgahpa dziꞌtsi laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pwihsi seguihdu gwabiiga Judas hasta zuu Jesuhs chiꞌchi rahbi ba loh Ñiꞌh: ―¡Chaan Mwehsu! Chiꞌchi bachaꞌgarwaaꞌ ba loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ya lwehgu gwabiiga raꞌ ba tin gunaꞌzu raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","per tuhbi ndxiꞌhw nin zuu hasta zuu Jesuhs guleꞌhe bi tuhbi spahda tin bachyuuꞌga bi dxiahga xmooza bwiinn nin rnabwaꞌ laꞌh raꞌ bixohza, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","chiꞌchi rahbi Jesuhs loh raꞌ bwiinn chi: ―¿Xixnaa rluuꞌyi nee xpahda cun garrohta nuꞌa tu zeꞌ tu, tin guinaꞌzu tu naꞌh ziga zi tuhbi gubaꞌn? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Xixnaa chin baluꞌyiꞌhn xchiꞌdxyi Dxiohs laꞌh tu laꞌn guidoꞌ rooꞌ garaa dxyih ayi gunaꞌzu tu naꞌh? Per squiiꞌ gaca tin bariaꞌcaa ziga caa loh Xchihtsi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ya chiꞌchi garaa raꞌ xpwiinn Ñiꞌh basaaꞌn laꞌh Ñiꞌh cun biahchi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ya chin zeenee bwiinn duhlda raꞌ chi laꞌh Jesuhs neezaa tuhbi biꞌnxtuhbi naꞌhla laꞌh Ñiꞌh duꞌbi bi tuhbi sahbna; gunaꞌzu raꞌ ba laꞌh bi ");
INSERT INTO zpvNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","per biriaꞌtiiꞌ bi laꞌn sahbna chi ya bwiꞌhnn bi gahn balluꞌn bi ziaa llaꞌteh chiꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ya seguihdu gwanee raꞌ ba laꞌh Ñiꞌh loh bixohza nin mahzi rnabwaꞌ, riꞌchi badiaaꞌhaza snuhn raꞌ bixohza nin nahpa balaaquiꞌhn guelrnabwaꞌ cun neezaa bwiinn guhla raꞌ xteenn raꞌ bwiinn Israel, cun neezaa mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ya Pehdru zihtu-zihtu naꞌhla ba hasta laaꞌyitiaaꞌha xteenn yihdzi bixohza rooꞌ, zohba Pehdru dxaꞌga ba loh raꞌ bwiinn nin rahpa riꞌchi, tin cagabihdxyinee Pehdru laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Laꞌh raꞌ bixohza nin rnabwaꞌ laꞌh raꞌ bixohza, cun garaa raꞌ bwiinn guhla raꞌ cun nin naa raꞌ guxchisi, cadxiꞌhyi xiilla tuhbi xquelchiah Jesuhs tin gachi Ñiꞌh, per ayi bidxeela raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nee ziahan raꞌ ba guñiꞌ raꞌ ba puur dxyiꞌdxyi dxixiꞌhw pur laꞌh Ñiꞌh, per dxyiꞌdxyi nin guñiꞌ raꞌ ba pur laꞌh Ñiꞌh ayi naa raꞌn tuhbiloh sino que guriin-guriin, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","per gwasuꞌnchii snuhn raꞌ ba tin bacaꞌchiah raꞌ ba laꞌh Jesuhs, rahbi raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Garaa nu bihn nu guñiꞌ ba: “Naꞌh gucwiin guidoꞌ riiꞌ nin bwiꞌhnnchaꞌyi raꞌ bwiinn, ya chin dxiohnna dxyih, guunnchaꞌyiꞌhn stuhbin nin ayi gaca chaꞌyi cun naa raꞌ bwiinn.” ");
INSERT INTO zpvNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per nicala squiiꞌ rahbi raꞌ ba per guriin-guriin guhca xchiꞌdxyi cada tuhbigah raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ya chiꞌchi gwasuꞌnchii bixohza rooꞌ nin rnabwaꞌ galaayi raꞌ tin gunaabadxyiꞌdxyi ba loh Jesuhs squiiꞌ: ―¿Tayi chixteeꞌ luꞌh? ¿Xi dee nugacaꞌchiah raꞌ ba yiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per laꞌh Jesuhs ayi guñiꞌtiiꞌ Ñiꞌh, chiꞌchi gunaabadxyiꞌdxyi ba stuhbi loh Ñiꞌh: ―¿Ta yiꞌh naa luꞌh Crixtu, Lliiꞌn Dxiohs nin nabahan dziꞌtsi? ");
INSERT INTO zpvNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chiꞌchi rahbi Jesuhs: ―Naꞌhan, ya laꞌh tu zwaꞌha tu Lliiꞌn Dxiohs nin naa ndxiꞌhw soobaa Ñiꞌh xlahdu derehchu Dxiohs nin rnabwaꞌtiiꞌ, nee zwaꞌha za tu guibiaꞌgariin laꞌn xcahyi llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ya chiꞌchi gucaꞌha bixohza nin rnabwaꞌ chi gudxiꞌllu ba lahdxi nin nahcu ba, ziga tuhbi sehn cañiꞌyah Jesuhs laꞌh Dxiohs, niꞌchin rahbi ba: ―¡Ayi xi xchiꞌhn ru nuꞌh dxihnn nuꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Laꞌhtu bihn la xa guñiꞌyah ba laꞌh Dxiohs. Nnahaxchiꞌh, ¿xi nnaa tu pur niꞌca? Ya garaa raꞌ ba gunaaba raꞌ ba gachi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ya nuu raꞌ ba bachah xihin raꞌ ba loh Ñiꞌh cun neezaa basieꞌw raꞌ ba loh Ñiꞌh chiꞌchi guyaꞌzi raꞌ ba loh Ñiꞌh, ya rahbi raꞌ ba: ―¡Guhcabwaꞌ chyuñin nin guyaꞌzi loh luꞌh! Ya seguihdu gudahpa raꞌ guixaꞌga raꞌ loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ya loh zohba Pehdru laaꞌyitiaaꞌha laꞌn gueeta chi, gudiiꞌdxi tuhbi gunnaꞌh nin ruhnn dziꞌn riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","chiꞌchi bwaꞌha bi laꞌh Pehdru zohba ba gabihdxyi za ba cweeꞌ dxih nin rii riꞌchi, niꞌchin rahbi bi loh Pehdru: ―Nee yiꞌh guyuuꞌnee luꞌh laꞌh Jesuhs nin zeꞌ guihdxyi Nazaret. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Chiꞌchi rahbi Pehdru: ―¡Ayi nuꞌnbwaꞌn ba, nee nin ayiza rahcabwaꞌn xiniꞌca nin cañiꞌ luꞌh! Lwehgu gwasuu ba nez hasta riuuꞌtiiꞌ raꞌ ba, ya hohra chi bacaꞌhyahnn tuhbi dxiidxinguhla. ");
INSERT INTO zpvNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ya chin bwaꞌha gunnaꞌh chi laꞌh Pehdru stuhbi, rahbi bi loh raꞌ nin rii riꞌchi: ―¡Gulguiaꞌha! ¡Bwiinn ca naa tuhbi xpwiinn Jesuhs! ");
INSERT INTO zpvNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per basaguiꞌhi laꞌgaꞌh Pehdru stuhbi, ya mas balaaquiꞌhn rahca rahbi raꞌ nin rii riꞌchi loh Pehdru: ―¡Guchii paꞌcan! ¡Nee luꞌh naa luꞌh tuhbi xpwiinn Jesuhs, laasii naa luꞌh tuhbi bwiinn Galilea! ");
INSERT INTO zpvNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chiꞌchi guzoꞌbaloh guñiꞌ chihpa Pehdru rahbi bi: ―¡Ayi nuꞌnbwaꞌtiiꞌhihn laꞌh ndxiꞌhw ca nin ayi gaꞌnnahn xiñin nin riiñiꞌ tu loon! ");
INSERT INTO zpvNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ya hohra chi gahca bacaꞌhyahnn dxiidxinguhla nin raroopa bweelta, ya hohra chi bagannastoꞌ Pehdru dxyiꞌdxyi raꞌ nin guñiꞌ Jesuhs loh bi: “Galoh nin gucaꞌhyahnn dxiidxinguhla chiohpa bweelta, ya ziñiꞌ luꞌh nin rioonna bweelta ayi nuꞌnbwaꞌtiiꞌ luꞌh naꞌh.” Ya chiꞌchi bwiꞌhnn bi lligaaba xcweenta raꞌ dxyiꞌdxyi raꞌ rii chiꞌchi guzoꞌbaloh cayuꞌn bi nalasa duxa. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ya chin barah gueꞌla, chiꞌchi badiaaꞌha bixohza nin rnabwaꞌ laꞌh garaa raꞌ bixohza cun bwiinnguuhla raꞌ xteenn raꞌ bwiinn Israel cun mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs, cun garaa raꞌ guixaꞌga xteenn guidoꞌ; ya guluhlla si juunta chi chiꞌchi gunaꞌzu raꞌ ba laꞌh Jesuhs bachiꞌbiduꞌh raꞌ ba laꞌh Ñiꞌh, chiꞌchi biuꞌn ntriehgu raꞌ ba laꞌh Ñiꞌh loh Pilahtu, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","chiꞌchi gunaabadxyiꞌdxyi Pilahtu loh Ñiꞌh rahbi ba: ―¿Ta yiꞌh naa luꞌh xrrehyi raꞌ bwiinn Israel? Chiꞌchi rahbi Jesuhs loh Pilahtu: ―Ziꞌchi; yiꞌh gahca guñiꞌ luꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ya laꞌh raꞌ bixohza nin rnabwaꞌ laꞌh raꞌ bixohza bacaꞌchiah dxixiꞌhw raꞌ ba laꞌh Ñiꞌh ziahan cohsa raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","chiꞌchi gunaabadxyiꞌdxyi Pilahtu loh Ñiꞌh stuhbi rahbi ba: ―¿Tayi guiñiꞌ luꞌh? ¡Bwaꞌha ziahan cohsa raꞌ nin cagacaꞌchiah raꞌ ba yiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per cun ayi guñiꞌtiiꞌ Jesuhs, tin mahzi ru badxyigaaꞌ Pilahtu pur xcweenta Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ya ziga garaa yihza nin rahca lañih paascu, rutaꞌh Pilahtu tuhbi bwiinn nin ñieꞌw, ya rutaꞌh ba cuun chiꞌh zi nin rnaaba raꞌ bwiinn rlaꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ya laꞌn dxyih raꞌ chi ñieꞌw tuhbi ndxiꞌhw nin laa Barrabahs, pur gudxiinn ba nuhn raꞌ bwiinn cun garaa nin naa xpwiinn ba ñieꞌwnee ba laasii gudxihndxinee raꞌ ba laꞌh gubieerna César, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ya chin badiaaꞌha raꞌ bwiinn riꞌchi chiꞌchi gunaaba raꞌ ba loh Pilahtu, tin guunn ba ziga naa xcostumbre ba gazohba yihza, rutaꞌh ba tuhbi raꞌ bwiinn nin ñieꞌw, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","chiꞌchi rahbi Pilahtu loh raꞌ bwiinn chi: ―¿Ta xclaaꞌdzi tu gutaꞌhn laꞌh xrrehyi raꞌ bwiinn Israel raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Squiiꞌ guñiꞌ Pilahtu laasii guhcabwaꞌ ba batiꞌdxi bixohza raꞌ nin rnabwaꞌ laꞌh Ñiꞌh loh ba laasii cadxyiꞌchinee raꞌ ba laꞌh Ñiꞌh xixnaa rianaꞌhla ziahan bwiinn laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","per bixohza raꞌ chi, bachiꞌhyi raꞌ ba laꞌh raꞌ bwiinn tin gunaaba raꞌ ba gulaꞌh Barrabahs xlawaaꞌha Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","chiꞌchi rahbi Pilahtu loh raꞌ ba: ―¿Cuun xchiꞌh nin xclaaꞌdzi tu guꞌnnahn cun nin rñiꞌ tu rrehyi raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ya chiꞌchi guñiꞌ raꞌ ba jweersi rooꞌ rahbi raꞌ ba: ―¡Bacaꞌh ba loh cruhzi! ");
INSERT INTO zpvNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chiꞌchi rahbi Pilahtu loh raꞌ ba: ―¿Per xi mahla cayuhnn ba? Per laꞌh raꞌ ba cun mahzi ru jweersi rooꞌ rahbi raꞌ ba stuhbi: ―¡Bacaꞌh ba loh cruhzi! ");
INSERT INTO zpvNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ya laꞌh Pilahtu, coma ayi xclaaꞌdzi ba dxiaꞌhan mahla ba loh raꞌ bwiinn, ya bataꞌh ba laꞌh Barrabahs; ya gunabwaꞌ ba gucaꞌyahga Jesuhs cun cwaarta, chiꞌchi biuꞌn ba ntriehgu laꞌh Ñiꞌh, tin bacaꞌh raꞌ xsuldahdu ba laꞌh Ñiꞌh loh cruhzi, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ya gwanee raꞌ suldahdu laꞌh Jesuhs laaꞌyitiaaꞌha xteenn palahsiu, riꞌchi badiaaꞌha raꞌ gaduhbi batayohn suldahdu, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","chiꞌchi bagahcu raꞌ ba laꞌh Ñiꞌh tuhbi lahdxi murahdu, ya yihca Ñiꞌh guluuꞌ raꞌ ba tuhbi curohnna guihchii, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","chiꞌchi guzoꞌbaloh cabwihdxyidxiah raꞌ ba rahbi raꞌ ba: ―¡Para tuꞌpazi guibahan xrehyi bwiinn Israel raꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chiꞌchi guzoꞌbaloh riigachiehlda raꞌ ba tuhbi ñihta yihca Ñiꞌh, cun bachahnxihin raꞌ za ba loh Ñiꞌh, chiꞌchi riigazuꞌnllihbi raꞌ ba nez loh Ñiꞌh, tin bwiꞌhnn raꞌ ba ziga zi nin cayaann laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ya chin guyaꞌloh basaꞌcazii raꞌ ba laꞌh Ñiꞌh, chiꞌchi babweꞌhe raꞌ ba lahdxi murahdu chi tihxi Ñiꞌh, chiꞌchi gubiaꞌgarii bagahcu raꞌ ba nin naa xahba Ñiꞌh, ya lwehgu zeenee raꞌ ba laꞌh Ñiꞌh tin guicah Ñiꞌh loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chiꞌchi badxiꞌloh raꞌ ba laꞌh tuhbi bwiinn guihdxyi Cirene nin laa Simohn xtaada Alejandru cun Rufu, gueꞌdu zieꞌ ba gwah ba dahan, ya loh bachiꞌhloh raꞌ ba laꞌh ba riꞌchi, bwiꞌhnn raꞌ ba jweersi laꞌh ba tin biꞌa ba xcruhzi Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","chiꞌchi zeenee raꞌ ba laꞌh Jesuhs tuhbi lahta hasta laa Gólgota (nin zee loh xchiꞌdxyi raꞌ ba yihca bwiinn guuchi), ");
INSERT INTO zpvNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","neezaa badiꞌhi raꞌ ba vihnnu nin nuchi mihrra ñeeꞌ Ñiꞌh, per ayi gwaaꞌ Ñiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ya lwehgu bacaꞌh raꞌ ba Ñiꞌh loh cruhzi, ya suldahdu raꞌ, gudzihta raꞌ ba baraja, tin ziꞌchi guyuuꞌ nin gucaꞌha bigaꞌzi xahba xahba Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Xcagaꞌ rsiiyi hohra nin bacaꞌh raꞌ ba laꞌh Ñiꞌh loh cruhzi, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ya dxyiꞌdxyi nin caa yihca xcruhzi Ñiꞌh caaꞌhan xi pur guhchi Ñiꞌh rñiꞌn squiiꞌ: “Dee naa xrrehyi raꞌ bwiinn Israel.” ");
INSERT INTO zpvNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Neezaa chiohpa raꞌ bwiinn gubaꞌn gucah raꞌ loh cruhzi cweꞌ xcruhzi Jesuhs; tuhbi ba lahdu derehchu Ñiꞌh, stuhbi ba xlahdu rrabwehsa Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Squiiꞌ guzohba xchiꞌdxyi Dxiohs hasta rahbi: “Loh raꞌ bwiinn mahla zutiꞌdxi raꞌ ba laꞌh ba.” ");
INSERT INTO zpvNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ya nin gudiiꞌdxi raꞌ riꞌchi guñiꞌ tohnta raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¡Bwehnu yiꞌh! ¿Tayi nnaa dxiꞌh luꞌh gucwih luꞌh guidoꞌ ya chohnna si dxyih nnaa luꞌh guunn luꞌh stuhbin? ");
INSERT INTO zpvNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Yannah baldaꞌh yiꞌh gahca tin biehta loh cruhzi ca! ");
INSERT INTO zpvNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ziꞌchi gahca za bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza ballihdzinee raꞌ ba laꞌh Ñiꞌh cun mwehsu raꞌ nin ruluuꞌyi lehyi ya rahbi raꞌ ba: ―Baldaꞌh ba paaldaa raꞌ bwiinn, per nnah ayi nuu guhldaꞌh gahca ba laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dxiehta ba loh cruhzi ca ziga naa ba Crixtu nin dxuleꞌza nuꞌh, nee ziga naa za ba rrehyi loh raꞌ bwiinn Israel tin guidiaꞌha loh nuꞌh ya ziꞌchi chechiistoꞌ nuꞌh laꞌh ba. Neezaa tuhbi raꞌ nin caa loh stuhbi cruhzi tuhbi cweeꞌ lahdu xcruhzi Ñiꞌh guñiꞌ tohnta loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ya chin guhca ziga chiꞌh laaꞌyidxyih hohra chi biꞌ tuhbi gueꞌla gaduhbitiiꞌ guidxyiyuh hasta xcachohnna gudxyih biaꞌñih, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ya hohra chi gahca guñiꞌ Jesuhs jweersi rooꞌ rahbi Ñiꞌh: ―¡Eloi, Eloi!, ¿lama sabactani? ―Squiiꞌ rñiꞌ dxyiꞌdxyi raꞌ riiꞌ: ¡Xtaada Dxiohsaꞌhn, Xtaada Dxiohsaꞌhn!, ¿xixnaa basaaꞌn luꞌh naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ya nuu raꞌ nin rii riꞌchi bihn raꞌ ba nin guñiꞌ Ñiꞌh ya rahbi raꞌ ba: ―¡Gulgacaꞌdxiahga! ¡Cabwihdxyi ba laꞌh Elías! ");
INSERT INTO zpvNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ya chiꞌchi balluꞌn tuhbi raꞌ ba tin bagahdxyi raꞌ ba tuhbi esponja loh vihnnu naltaa, ya cun yihca tuhbi ñihta bacaꞌh raꞌ ban rwaaꞌ Ñiꞌh, ya chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―Gulgasaaꞌn, guidiaꞌha raꞌ nuꞌh ta ziꞌ Elías dxieꞌgateeta laꞌh ba loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per hohra chi gahca gudihdxyidxiah Ñiꞌh jweersi rooꞌ ya lwehgu si guhchi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ya lahdxi naꞌlda nin zaꞌbi laꞌn guidoꞌ rooꞌ bigaꞌllun desde guiyaꞌ hasta laꞌn gueeta, guhcan chiohpa taaꞌha. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ya chin bwaꞌha capitahn romanu nin rnabwaꞌ nin zuu gahxu hasta caa Jesuhs loh cruhzi xa guhchi Ñiꞌh, chiꞌchi rahbi ba: ―Guchii bwiinn ca, naa ba Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Neezaa guyuuꞌ paaldaa raꞌ gunnaꞌh nin gurih zihtu; loh raꞌ ba dxaꞌga María Magdalena cun María xmaah Jacobo nin biꞌtiꞌhn cun Joseh cun Salomeh. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gunnaꞌh raꞌ riiꞌ naa nin gwanaꞌhla laꞌh Jesuhs nee bwiꞌhnn za raꞌ ba cumpahñu laꞌh Ñiꞌh chin guyuuꞌ Ñiꞌh nez guihdxyi Galilea, nee riꞌchi rii za ziahan ru gunnaꞌh raꞌ nin gwanaꞌhla laꞌh Ñiꞌh hasta guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chin gurih gueꞌla, neezaa guhca dxyih chi bispra xteenn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","niꞌchin biꞌ Joseh tuhbi bwiinn guihdxyi Arimatea, Joseh riiꞌ naa tuhbi nin dxaꞌga loh raꞌ nin rnabwaꞌ laꞌn guidoꞌ rooꞌ xteenn raꞌ bwiinn Israel, cabweeza ba gadzihn xquelrnabwaꞌ Dxiohs. Niꞌchin nin bazuhchihpa stoꞌ ba tin gwah ba loh Pilahtu, tin gwaganaaba ba siꞌguehlda Pilahtu tin batehta Joseh bweꞌltihxi Jesuhs loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Badxyigaaꞌ duxa loh Pilahtu chin bihn ba laꞌh Ñiꞌh guhchi, chiꞌchi gudihdxyi ba capitahn nin cayahpa laꞌh Ñiꞌh, tin gunaabadxyiꞌdxyi Pilahtu gu guchii guhchi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ya chin barah batiꞌdxi cweenta capitahn chi, chiꞌchi guziꞌguehlda Pilahtu tin bagateꞌta Joseh bweꞌltihxi Ñiꞌh loh cruhzi, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ya guziꞌ Joseh tuhbi lahdxi sahbna batuꞌbi ban bweꞌltihxi Ñiꞌh chin batehta ba Ñiꞌh loh cruhzi, chiꞌchi bacaꞌtsi ba bweꞌltihxi Ñiꞌh laꞌn tuhbi baꞌ dxiah, ya lwehgu bataꞌw ba rwaaꞌ baꞌ dxiah chi cun tuhbi dxiah rooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ya laꞌh María Magdalena cun María xmaah Joseh bwaꞌha raꞌ ba ca bigaꞌtsi bweꞌltihxi Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chin gudiiꞌdxi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, chiꞌchi guziꞌ raꞌ María Magdalena cun María xmaah Jacobo, cun Salomeh nsehchi nahxi raꞌ, tin cheetaꞌbi raꞌ ban bweꞌltihxi Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ya mwer dxyih xteenn xmahn chi, gwah raꞌ gunnaꞌh chi rwaaꞌ baꞌ hasta bigaꞌtsi bweꞌltihxi Ñiꞌh, nee rsiiyigah gwah raꞌ ba hohra paꞌh nin zohbatahn gubihdxyi, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ya zeeñiꞌ loh lasaaꞌ raꞌ ba rahbi raꞌ ba: ―¿Chyu niꞌca cooba dxiah rooꞌ chi rwaaꞌ baꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per chin bwaꞌha raꞌ ba rwaaꞌ baꞌ, laꞌh dxiah rooꞌ nin bieꞌw rwaaꞌ baꞌ chi laꞌn bidoꞌba la, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","per chin zeeyuuꞌtii raꞌ ba rwaaꞌ baꞌ chi bwaꞌha raꞌ ba zohba tuhbi ndxiꞌhw lahdu derechu xteenn laꞌn baꞌ chi, nahcu ba tuhbi lahdxi nin rcaꞌbachaꞌh, ya laꞌh raꞌ gunnaꞌh chi bidxyihbi duxa raꞌ ba chin bwaꞌha raꞌ ba loh ndxiꞌhw chi, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","per lwehgu guñiꞌ ndxiꞌhw chi rahbi ba: ―Ayi guidxyihbi tu, laꞌn naann la cagadxiꞌhyi tu laꞌh Jesuhs nin zeꞌ guihdxyi Nazaret nin gucah loh cruhzi. Ayi Ñiꞌh riiꞌ, laꞌh Ñiꞌh babahn. Gulguiaꞌha hasta badziiꞌba tu bweꞌltihxi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Niꞌchin nnah guldxiaa tin gulgahbi loh raꞌ xpwiinn Ñiꞌh cun loh Pehdru: “Galoh Ñiꞌh chee ñiidxiuu Ñiꞌh para guihdxyi Galilea que laꞌh tu; ya riꞌchi zwaꞌha tu Ñiꞌh ziga paꞌh gunah Ñiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chiꞌchi bariaꞌtiiꞌ raꞌ gunnaꞌh chi laꞌn baꞌ cun rdxyihbi duxa raꞌ ba, ayi xi guhdzi raꞌ ba loh nin tuhbi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chin babahan Jesuhs loh guelguhchi tuhbi rsiiyidoꞌ mwer dxyih xteenn xmahn, baluuꞌyiloh Jesuhs mwergaloh loh María Magdalena nin babweꞌhe Jesuhs gahdzi bwiinndxaaba stoꞌ ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Laꞌh ba gwaguihtsi ba loh bwiinn raꞌ nin gucaꞌnzahnee Jesuhs, gaduhbi nuu nalasa stoꞌ raꞌ ba, cun riiyuꞌn raꞌ ba pur laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ya chin bihn raꞌ bwiinn chi nabahan Jesuhs nee bihn raꞌ za ba bwaꞌha María Magdalena laꞌh Ñiꞌh, ayi gwachiistoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gudiiꞌdxi si deeꞌ chin baluuꞌyiloh laꞌgaꞌh Jesuhs loh raꞌ chiohpa xpwiinn Ñiꞌh stuhbi foorma laꞌgaꞌh, loh nin zeezah raꞌ ba loh neziuh para loh dahan, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ya lwehgu gahca gwaguihtsi raꞌ ba loh raꞌ snuhn lasaaꞌ raꞌ ba, per nin laꞌh za raꞌ ba ayi gwachiistoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ya pur lulchima baluuꞌyiloh Jesuhs loh raꞌ gadziꞌh bituhbi raꞌ xpwiinn Ñiꞌh gaduhbi nin zohba raꞌ ba loh mwella, chiꞌchi gudxihndxi Jesuhs laꞌh raꞌ ba, laasii naa raꞌ ba bwiinn nahda duxa ayi gwachiistoꞌ raꞌ ba laꞌh raꞌ bwiinn nin bwaꞌha laꞌh Ñiꞌh nabahan Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulcheh gaduhbitiiꞌ loh guidxyiyuh, tin gulcheh galuuꞌyi xchiꞌdxyi Dxiohs nin guhldaꞌh laꞌh raꞌ bwiinn loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ya bwiinn nin chechiistoꞌ ñiꞌh dxyiꞌdxyi raꞌ riiꞌ nee chioobaañihsa za raꞌ ba bwiinn chi zilaꞌh loh duhlda, ya bwiinn nin ayi chechiistoꞌ raꞌ ñiꞌh bwiinn raꞌ chi ziñihchi loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ya sehn raꞌ riiꞌ guunn raꞌ bwiinn nin chechiistoꞌ raꞌ ñiꞌh: Ya cun laan zahca gabweꞌhe tu bwiinndxaaba raꞌ stoꞌ raꞌ bwiinn, nee guiñiꞌ za tu stuhbi dxyiꞌzah cuubi nin ayi rahcatiiꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ziꞌchiza sidela guinaꞌzu tu bweꞌlda ñalaꞌdzi raꞌ, ayi xi guunnee ma laꞌh tu, ya sidela guee tu xiilla cohsa nin rdxiinn laꞌh bwiinn, ayi za xi guunneeꞌhen laꞌh tu; nee neezaa zahca gudziiꞌba naa tu yihca raꞌ bwiinn dxyihdxyi tin dxiaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ya chin guyaꞌloh guñiꞌ Ñiꞌh loh raꞌ xpwiinn Ñiꞌh lwehgu ziaagacah Ñiꞌh para llaaꞌn dxibaaꞌ tin guzohba Ñiꞌh xlahdu derehchu Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ya seguihdu bidiꞌchi raꞌ ba tin zee galuuꞌyi raꞌ ba xchiꞌdxyi Ñiꞌh ziahan lahta, ya neezaa guhcanee Ñiꞌh laꞌh raꞌ ba tin bwiꞌhnn raꞌ ba sehn raꞌ cun dziꞌn rooꞌ raꞌ. Pwihsi guyaꞌloh dxyiꞌdxyi raꞌ nin bacaꞌh San Marcu pur Jesucristu. Ziꞌchi gaca pwihsi.");
INSERT INTO zpvNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ziahan bwiinn gudxiꞌhyi raꞌ ba xa bacaꞌxnehza raꞌ ba dxyiꞌdxyi xteenn cweenta nin gudiiꞌdxi loh nu garaa nin bwiꞌhnn Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ya basiaꞌhan raꞌ ba dxyiꞌdxyi chi loh nu zigapaꞌh baluuꞌyi raꞌ nin bwaꞌhaloh garaa nin guhca desde guzohbalohon, pwihsi basiaꞌhan za raꞌ ba dxyiꞌdxyi loh nu zigapaꞌ baluuꞌyi raꞌ nin guhcanee bidiꞌchi xchiꞌdxyi Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ziꞌchi gahca naꞌh bwiꞌhnnaꞌhn lligaaba gucaꞌxnehzaꞌhn cweenta riiꞌ para yuꞌbiluꞌh Daada Tiófilo, ziga gunaꞌbadxyiꞌdxyiꞌhn desde guzaꞌlohon, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tin gacabwaꞌ luꞌh xa naa dxyiꞌdxyi nin baluuꞌyi raꞌ ba yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chin guhca Herodes rrehyi distrihtu xteenn Judea laꞌn dxyih raꞌ za chi, guyuuꞌ tuhbi bixohza nin biriaꞌlah Zacarías nee guhca za ba tuhbi xpwiinn guehtu Abías. Ya cheꞌhla ba biriaꞌhlah Elizabet neezaa guhca ba llahga guehtu bixohza Arohn. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nee nayaa gubahan garoopa raꞌ ba nezloh Dxiohs, bazoꞌbadxiahga raꞌ ba xchiꞌdxyi Dxiohs, niꞌchin bwaꞌha zaꞌca Dxiohs laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per ayi guyuuꞌ lliiꞌn raꞌ ba laasii laꞌh Elizabet nagahdxi chyu lliiꞌn ba gudiꞌhi Dxiohs nee ya zigala bwiiñuꞌxa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Guyuuꞌ tuhbi dxyih bigaꞌha xgruhpo Zacarías guunn raꞌ ba dziꞌn xteenn bixohza loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ziꞌchi naa xcostuumbre bixohza raꞌ laꞌn dxyih raꞌ chi. Gwah raꞌ ba tuhbi pweexta diaꞌhan chyu guunn tucahri chuꞌtii guunn guxaꞌhla laꞌn guidoꞌ rooꞌ. Per bwiꞌhnn tucahri laꞌh Zacarías. Guyuꞌtii ba hasta nuu bacuꞌga xteenn Dxiohs tin guunn ba guxaꞌhla. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ya gaduhbi cayuhnn ba guxaꞌhla laꞌn guidoꞌ, ziahan rooꞌ bwiinn rii rwaaꞌ guidoꞌ chi, cabwihdxi-canaaba raꞌ ba loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chiꞌchi baluuꞌyiloh tuhbi xaanjla Dxiohs loh Zacarías, zuꞌnchii aanjla chi lahdu derehchu xteenn bacuꞌga. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chin bwaꞌha Zacarías loh aanjla chi, ayi guhcabwaꞌ ba xa ñuhnn ba taantu bidxyihbi duxa ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chiꞌchi guñiꞌ aanjla chi, rahbi ba loh ba: ―Zacarías, ayi guidxyihbi luꞌh, laasii garaa dxyiꞌdxyi nin gudxiꞌhn-gunaaba luꞌh loh Dxiohs bihnn Ñiꞌhn, laꞌlliiꞌn cheꞌhla luꞌh chuuꞌ ya chin gaalaa bi cweꞌhelah luꞌh bi Jwahn, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ya ziahxi duxa luꞌh chin gaalaa lliiꞌn cheꞌhla luꞌh neezaa bwiinn raꞌ dxiahxi raꞌ ba chin gwaꞌha raꞌ ba laꞌlliiꞌn cheꞌhla luꞌh guulaa, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tin badoꞌ chi gaca bi tuhbi bwiinn nin lasahca duxa loh Dxiohs. Ayi guee bi vihnnu nee nin tuhbiza clahsa ñihsa nin rusuhdzi laꞌh bwiinn, ya zibweeza Spíritu Saantu xteenn Dxiohs lastoꞌ bi dez chin nuu gahca bi stoꞌ xmah bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nee zuhnn bi gusaguꞌdzistoꞌ ziahan bwiinn Israel tin guibiaꞌgarii raꞌ ba loh Yuꞌbi Dxiohs. Rahbiza aanjla chi: ");
INSERT INTO zpvNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","―Guzee lliiꞌn luꞌh nezloh Daada nin guixeꞌhla Dxiohs nee gaca bi ziga guhca tuhbi guehtu daada nin biriaꞌlah Elías, nin guñiꞌ xchiꞌdxyi Dxiohs ca chieempa rooꞌ. Zibweeza Spíritu Saantu xteenn Dxiohs lastoꞌ bi ziga guleeza Ñiꞌh lastoꞌ Elías, tin laꞌh bi gabaꞌchi zaꞌca bi garaa daada raꞌ cun lliiꞌn raꞌ ba, tin guzoꞌbadxiahga garaa raꞌ nin rusahcaloh loh xchiꞌdxyi Dxiohs. Ziꞌchi guunn bi cwii nasiin raꞌ bwiinn para dxyih nin gadzihn Daada Crixtu nin guixeꞌhla Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chiꞌchi gunaabadxyiꞌdxyi Zacarías loh aanjla chi squiiꞌ: ―¿Xa mohda gacabwaꞌn guchii luꞌh chuu lliiꞌn cheꞌhlaꞌhn tin naꞌh bwiñyuꞌhxalahn, ziꞌchiza cheꞌhlaꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chiꞌchi rahbi aanjla chi loh ba: ―Naꞌh naan aanjla Gabriel, nuuꞌuhn loh Dxiohs. Yannah guxeꞌhla Dxiohs naꞌh zeꞌldaneꞌhn tuhbi dxyiꞌdxyi zaꞌca loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per ya ziga ayi gwachiibwen stoꞌ luꞌh niꞌchin nnah ziruuꞌgabwih luꞌh ayi gaca guiñiꞌ luꞌh ziaꞌhan goopa luꞌh laasii ayi gwachiistoꞌ luꞌh nin guñaan loh luꞌh, ya hastayi chin gaalaa lliiꞌn cheꞌhla luꞌh chiꞌchiyi gañiꞌ luꞌh nee dxyiꞌdxyi riiꞌ zizohban nahpa gadzihn dxyih gaalaa lliiꞌn cheꞌhla luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ya gaduhbi cayahca niꞌchi, rii bwiinn nez dihtsi chi, chiꞌchi bwiꞌhnn raꞌ ba lligaaba: ―¿Xixnaa cayahcataꞌh Zacarías laꞌn guidoꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ya chin bariaꞌh Zacarías laꞌn guidoꞌ, ayila guhca ñiñiꞌ ba loh raꞌ bwiinn nin riibweeza laꞌh ba. Chiꞌchi guhcabwaꞌ raꞌ bwiinn chi bwaꞌha ba tuhbi cohsa rooꞌ laꞌn guidoꞌ, ya chiꞌchi puura sehn zi cayuhnn ba loh raꞌ bwiinn cun biaꞌhan goopa ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ya guyaꞌloh si bwiꞌhnn ba dziꞌn laꞌn guidoꞌ, chiꞌchi bariaꞌh ba ziaa ba para yihdzi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chin gudiiꞌdxi dxyih raꞌ riiꞌ, biin nuu lliiꞌn Elizabet cheꞌhla Zacarías, chiꞌchi gaꞌyu bweꞌhw guyuꞌlaꞌn ba, nastoꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Squiiꞌ cayuhnn Daada Dxiohs cumpahñu naꞌh tin ayi cweꞌhestoꞌ bwiinn naꞌh laasii ayi guyuuꞌ lliiꞌnahn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ya chin guhca xoꞌpa bweꞌhw chiꞌchi guxeꞌhlalaꞌgaꞌh Dxiohs xaanjla Ñiꞌh nin laa Gabriel loh tuhbi guihdxyi nin laa Nazaret nin nuu lahda lahda guihdxyi raꞌ nin nuu rregiohn Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tin guñiꞌ aanjla chi loh tuhbi dxaꞌpa nin laa María. Ya dxaꞌpa chi nagahdxi guidxiꞌ ndxiꞌhw laꞌh bi neezaa guyuuꞌ-guyaꞌzi bi dxyiꞌdxyi tin guchinaa bi tuhbi biꞌnxtuhbi nin laa Joseh. Ya Joseh chi naa llahga tuhbi guehtu rrehyi chieempa rooꞌ nin biriaꞌlah Davihd. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chin guyuꞌtii aanjla chi hasta nuu María, chiꞌchi rahbi ba loh María: ―Chaan María, dichohsa duxa luꞌh laasii gulii Dxiohs yiꞌh loh garaatiiꞌ gunnaꞌh nin rii guidxyiyuh, zuhnn Ñiꞌh compahñu yiꞌh, zahcanee Ñiꞌh yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ya chin bwaꞌha María cañiꞌ aanjla chi dxyiꞌdxyi raꞌ chi loh bi, badxyigaaꞌ bi pur nin guhdzi ba loh bi, ya bwiꞌhnn bi lligaaba: “¿Xixniꞌca cañiꞌ ba loon?” ");
INSERT INTO zpvNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chiꞌchi rahbi lagaꞌh aanjla chi loh bi: ―Ayi guidxyihbi luꞌh María, Dxiohs gulii yiꞌh zuhnn Ñiꞌh compahñu yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yannah bacaꞌdxiahga dxyiꞌdxyi riiꞌ María. Laꞌluꞌh guꞌa lliiꞌn, ya chin gaalaa xbadoꞌyiꞌhn luꞌh chi cweꞌhelah luꞌh bi Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Laasii gaca bi tuhbi bwiinn nin mahzi lasahca, neezaa guiñiꞌ bwiinn laꞌh bi naa bi Lliiꞌn Dxiohs nin nuu dxibaaꞌ, nee gacaza bi rrehyi ziga guhca guehtaguhla xtatiitaroo bi nin biriaꞌlah Davihd nin guhca rrehyi ca chieempa rooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tin guinabwaꞌ bi loh garaa raꞌ bwiinn Israel nee tin guinabwaꞌza bi gaduhbitiiꞌ chieempa, ya ayi chuu dxyih gariaꞌh bi guelrnabwaꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chiꞌchi gunaabadxyiꞌdxyi María loh aanjla chi squiiꞌ: ―¿Xa gariaꞌcaa deeꞌ ziga ayi caneꞌhn nin tuhbi ndxiꞌhw? ");
INSERT INTO zpvNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chiꞌchi rahbi aanjla chi: ―Gacan pur gadzihn Spíritu Saantu loh luꞌh; Spíritu Saantu xteenn Dxiohs nin nuu dxibaaꞌ guunn Ñiꞌh yiꞌh zigazi guiduꞌbi luꞌh xcahyi. Niꞌchin lliiꞌn luꞌh nin gaalaa gaca bi tuhbi bwiinn saantu, ya zibweꞌhelah bwiinn laꞌh bi Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Neezaa tuhbi lasaaꞌ luꞌh nin laa Elizabet laꞌba nuꞌa lliiꞌn la ayi xi guunn nicala guyuꞌxa ba. Ziga rahbi raꞌ bwiinn ayi ñuuꞌ lliiꞌn ba nee nnah guhca la xoꞌpa bweꞌhw nuu lliiꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Para Dxiohs garaatiiꞌ rahca; ayi nin tuhbi cohsa nin guunn gahn laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ya chiꞌchi rahbi María: ―Ziga naan xmooza Dxiohs, ¿ta naꞌh chiꞌhn guꞌnnahn ayi soobaa xchiꞌdxyi Dxiohs? Chiꞌchi bariaꞌh aanjla chi ziaa chiꞌh ba par dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ya laꞌn dxyih raꞌ chi carrih biriaꞌh María, zee bi tuhbi guihdxyi bituꞌhn nin rii laꞌn dahan Judea, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ya chin badzihn bi, lwehgu guyuꞌtii bi yihdzi Zacarías, chiꞌchi bagahpaDxiohs bi Elizabet. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ya chin bihn Elizabet xchiꞌdxyi María, biñiꞌbi lliiꞌn ba stoꞌ ba, chiꞌchi gwadxah laꞌn lastoꞌ Elizabet Spíritu Saantu, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","chiꞌchi guñiꞌ ba jweersi, rahbi ba loh María: ―Dxiohs bwiꞌhnntaaꞌyi yihca luꞌh mahziru que gunnaꞌh raꞌ nin rii guidxyiyuh neezaa lliiꞌn luꞌh bwiꞌhnntaaꞌyi Ñiꞌh yihca bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Chyuulla naan niꞌchin nin zeꞌguiaꞌh xmah Xchiohsaꞌhn naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bwaꞌha, chin bihnnaꞌhn xchiꞌdxyi luꞌh, biñiꞌbi lliiꞌnahn stoꞌn taantu riahxi bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Baayi yiꞌh bwiꞌhnntaaꞌyi Dxiohs yihca luꞌh sahca nin gwachiistoꞌ luꞌh xchiꞌdxyi Ñiꞌh, zuhnn Ñiꞌh soobaadxyiꞌdxyi nin gunnah Ñiꞌh loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chiꞌchi rahbi María: Cun gaduhbi xahlmaꞌhn rñiꞌn jweersi roo nahpa Dxiohs ");
INSERT INTO zpvNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ya lastoꞌn riahxin xcweenta Dxiohs nin guhldaꞌh naꞌh loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","laasii Dxiohs gulii naꞌh, nicala ayi gaca lasahcaꞌhn, per zuhnn Ñiꞌh compahñu naꞌh. Desde nnah chyuchiꞌhzi bwiinn nin guibahan loh guidxyiyuh guiñiꞌ ba pur taantu nin bwiꞌnntaaꞌyi Dxiohs naꞌh loh garaa gunnaꞌh nin rii guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","laasii Dxiohs nin nahpa garaa guelrnabwaꞌ laꞌÑiꞌh bwiꞌhnn ziahan cohsa rooꞌ para naꞌh, saantu duxa naa lah Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ya nahpa zalahsastoꞌ Ñiꞌh laꞌh bwiinn nin guidxyihbi xchiꞌdxyi Ñiꞌh tin guzoꞌbadxiahga raꞌ ban. Nicala hasta mahzi bwiinn chieempa nee nicalaza biñiꞌn nin nagahdxi gaalaa zalahsastoꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ya laꞌh Ñiꞌh baluuꞌyi Ñiꞌh rnabwaꞌ Ñiꞌh, bacuꞌdzi Ñiꞌh laꞌh raꞌ bwiinn nin ruhnn lligaaba nayaachi, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ya babweꞌhe Ñiꞌh laꞌh raꞌ bwiinn nin lasahca, nin gunabwaꞌ tin dxiuꞌgarii raꞌ bwiinn nin nadoꞌlaaꞌdzi tin guinabwaꞌ raꞌ ba xlugahri raꞌ bwiinn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","LaꞌÑiꞌh badiꞌhila cohsa zaꞌca laꞌh bwiinn nadoꞌlaaꞌdzi, ya bwiinn nin nuu xi rahw Ñiꞌh nin ruhnn lligaaba ayi xi xchiꞌhnn ba laꞌhÑiꞌh laꞌhza Ñiꞌh guleꞌcaala laꞌh raꞌ ba tuhbi lahdu tin ayi xi guicaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bwiꞌhnn Ñiꞌh cumpahñu laꞌh raꞌ bwiinn Israel nin naa xpwiinn Ñiꞌh, ayi biaꞌldastoꞌ Ñiꞌh nahpa balahsastoꞌ Ñiꞌh laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","laasii guziꞌguehlda Dxiohs gacanee Ñiꞌh laꞌh xtatiita Abrahn nuꞌh cun neezaa garaa llahga ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ya biaꞌhan María chohnna bweꞌhw yihdzi Elizabet, chiꞌchi babiaꞌgarii bi para lahdxyi bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ya chin badzihn dxyih nin guulaa lliiꞌn Elizabet, chiꞌchi guulaa tuhbi ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chiꞌchi gwah garaa xpisihn ba cun lasaaꞌ raꞌ ba gwaguiaꞌh laasii riahxinee raꞌ ba laꞌh ba pur basaaꞌn Dxiohs guyuuꞌ lliiꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ya chin guhca xuhnna dxyih chiꞌchi gwah raꞌ ba tin bacaꞌh raꞌ ba tuhbi bwaꞌ tihxi bi hasta naa bi ndxiꞌhw ziga tuhbi sehn tin para gacabwaꞌ bwiinn naa bi xpwiinn Dxiohs. Ya laꞌh raꞌ ba guclaaꞌdzi raꞌ ba ñuzoꞌba raꞌ ba lah bi ziga laa xpah bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Chiꞌchi rahbi xmah bi: ―Aaca, ayi guiriaꞌlah bi Zacarías, lah bi soobaa guiriaꞌlah bi Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chiꞌchi rahbi garaa lasaaꞌ ba: ―Ayi nin tuhbi lasaaꞌ luꞌh nin laa Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chiꞌchi bwiꞌhnn raꞌ ba sehn loh xpah badoꞌyiꞌhn chi tin guiduꞌhun xa xclaaꞌdzi ba guiriaꞌlah lliiꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chiꞌchi gunaaba xpah bi tuhbi dxihtsi tin bacaꞌh ba: “Lah bi laa Jwahn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ya chin guyaꞌloh bacaꞌh Zacarías loh dxihtsi chi rñiꞌn Jwahn guiriaꞌlah badoꞌyiꞌhn chi, chiꞌchi lwehgusi bañiꞌ ba, ya guzohbaloh cañiꞌ ba jweersirooꞌ nin nahpa Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chin bwaꞌha garaa lasaaꞌ ba nin rii gadiidxi laꞌZacarías bañiꞌ, chiꞌchi badxyigaaꞌ duxa raꞌ ba. Ya garaatiiꞌ cohsa raꞌ riiꞌ bidiꞌchin gaduhbi laꞌn xtahan raꞌ bwiinn Judea. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ya garaa raꞌ nin bihn raꞌn, bwiꞌhnn raꞌ ba lligaaba, neezaa gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Xiilaꞌh guunn biñiꞌn riiꞌ zeꞌ dxyih? Ziꞌchi guñiꞌ raꞌ ba laasii rluuꞌyitii xa cayahpa Dxiohs laꞌh bi, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ya gwadxah lastoꞌ Zacarías Spíritu Saantu xteenn Dxiohs, guzoꞌbaloh cañiꞌ ba dxyiꞌdxyi raꞌ nin badiꞌhi Dxiohs laꞌh ba, rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Zuxchilli Dxiohs nin nuu dxibaaꞌ rahpa Ñiꞌh laꞌh bwiinn Israel saca nin bieꞌguiaꞌha Ñiꞌh cuun raꞌ ba tin bieꞌgataꞌh za Ñiꞌh laꞌh raꞌ ba loh xtuhlda raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nee guxeꞌhla Ñiꞌh tuhbi bwiinn nin zeꞌ galdaꞌh laꞌh nuꞌh loh duhlda, ya gaca bwiinn chi llahga guehtu Davihd nin guhca Ñiꞌh, xpwiinn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dxiꞌ daada chi tin soobaa dxyiꞌdxyi nin guñiꞌ daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs nahpa dxiꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tin gutaꞌh Ñiꞌh laꞌh nuꞌh loh raꞌ nin rdxihldxinee laꞌh nuꞌh, neezaa nin ruhnn ñalaaꞌdzi loh nuꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tin taꞌh nuꞌh ziga guhdzi Ñiꞌh loh raꞌ xtatiita guldooꞌ raꞌ nuꞌh ziga zuzaꞌloh Ñiꞌh xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dxyiꞌdxyi chi nin guyuꞌtii Ñiꞌh guelrziꞌguehlda cun guehtu xtatiita Abrahn nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Zuldaꞌh Ñiꞌh laꞌh nuꞌh loh nin rdxyiꞌchinee laꞌh nuꞌh, tin ayi guidxyihbi nuꞌh guidiꞌhnn nuꞌh xtsiꞌn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tin gazoꞌbadxiahga nuꞌh xchiꞌdxyi Ñiꞌh neezaa gantsiiꞌhi lasaaꞌ nuꞌh gaduhbi chieempa nin guibahan nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ya yiꞌh, xiiꞌhihn ―rahbi Zacarías― ziriaꞌlah luꞌh daada nin rñiꞌ xchiꞌdxyi Dxiohs nin nuu dxibaaꞌ, tin guzee luꞌh cheguiꞌhnn zaꞌca luꞌh xneziuh Daada nin guixeꞌhla Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tin gacabwaꞌ bwiinn lasaaꞌ raꞌ nuꞌh gusiaꞌpitii Dxiohs xtuhlda raꞌ ba, tin taꞌh raꞌ ba lohon. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gaca ziꞌchi laasii galahsastoꞌ Dxiohs laꞌh raꞌ ba. Gacan ziga tuhbi llaꞌñih nin rarah gueꞌla chiꞌchi dxiꞌ gubihdxyi guicah guiyaꞌ ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tin dxiaꞌñih hasta rii raꞌ bwiinn nin zohba loh nacahyi pur xcweenta duhlda, nee cun neezaa nin nuu raꞌ xpacaala guelguhchi, tin guluuꞌyi Daada chi xa guzoo nuꞌh neziuh hasta cwidxyiistoꞌ nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ya chin gurooꞌ Jwahn lliiꞌn Zacarías, guhca nasiin bi laasii nuu dziꞌtsi Spíritu Saantu xteenn Dxiohs lastoꞌ bi, neezaa guyuuꞌ bi loh dahan desiertu hasta chin badzihn dxyih baluuꞌyiloh bi loh raꞌ bwiinn Israel tin guñiꞌ bi xchiꞌdxyi Dxiohs loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ya laꞌn dxyih raꞌ chi gunabwaꞌ rrehyi Augustu César gucahlah garaatiiꞌ bwiinn guidxyiyuh loh xchihtsi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Dee guhca mweer censo nin guhca loh nin naa Cirenio gobernador xteenn Siria. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ya ziga garaatiiꞌ raꞌ bwiinn nahpa chee raꞌ ba nez lahdxyi raꞌ ba ziga nez hasta bieꞌrooꞌ cada tuhbi raꞌ ba tin guicahlah raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","niꞌchin bariaꞌh Joseh guihdxyi Nazaret xteenn Galilea, tin gwah ba guihdxyi Belehn xteenn Judea hasta guulaa guehtu Davihd hasta guulaa za ba, nee naa za ba llahga guehtu Davihd naa Joseh, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","tin gwanee ba María nin guicaꞌha ba tin guicahlah garoopa raꞌ ba riꞌchi, ya María laꞌbi nuꞌa lliiꞌn la. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Gaduhbi nuu raꞌ ba riꞌchi badzihn dxyih nin guulaa lliiꞌn María. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Niꞌchin naa mweer tuhbi lliiꞌn María nin guyuuꞌ. Ya chin guulaa badoꞌyiꞌhn, chiꞌchi batuꞌbi María laꞌh bi lahdxi, chiꞌchi gudxinxi ba laꞌh bi laꞌn canua hasta rahw raꞌ guidxaꞌh laasii baprah yuuꞌ nin rahlla gucaꞌha raꞌ bwiinn, ayi ca ñiaꞌhan raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ya gahxu loh dahan guihdxyi Belehn riiyahpa raꞌ baxtohra lliꞌhyi gueꞌla. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ya tuhsi goolpi baluuꞌyiloh tuhbi xaanjla Dxiohs loh raꞌ ba, baziaꞌñih aanjla chi xpieꞌñih Dxiohs gaduhbi hasta rii raꞌ baxtohra chi ya bidxyihbi duxa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","chiꞌchi rahbi aanjla chi loh raꞌ ba: ―Ayi guidxyihbi tu, laasii naꞌh zeꞌldaneꞌhn tuhbi dxyiꞌdxyi zaꞌca para laꞌh tu, ya cun dxyiꞌdxyi raꞌ riiꞌ ziahxi garaatiiꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","laasii nnadxyih guulaa tuhbi badoꞌ loh guihdxyi xteenn guehtu Davihd ya badoꞌ chi zeꞌgataꞌh laꞌh tu loh duhlda ya laꞌh Ñiꞌh naa Crixtu nin naa Daada. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ya dee naa tuhbi sehn para laꞌh tu, tin gadxeela tu badoꞌyiꞌhn chi laꞌn tuhbi yuuꞌ hasta rii raꞌ guidxaꞌh, duꞌbi bi lahdxi. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ya chiꞌchi tuhsi goolpi baluuꞌyiloh mahzi ziahanroo aanjla nin cañiꞌ xa lasahca duxa Dxiohs, ya rahbi raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Zuxchilli Dxiohs nin nuu dxibaaꞌ neezaa dxyiiriistoꞌ raꞌ bwiinn nin riahxinee laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ya chin bacah raꞌ aanjla chi dxibaaꞌ, chiꞌchi guñiꞌnee lasaaꞌ raꞌ baxtohra, rahbi raꞌ ba: ―Gulchoꞌho guihdxyi Belehn, tin chodiaꞌha nuꞌh nin guhca riꞌchi, nin guñiꞌ xaanjla Dxiohs loh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ya chiꞌchi zee raꞌ ba carrih, seguihdu badxeela raꞌ ba María cun Joseh, cun badoꞌyiꞌhn naꞌ Ñiꞌh laꞌn canua hasta rahw raꞌ guidxaꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ya chin bwaꞌha raꞌ ba laꞌh badoꞌyiꞌhn cun María cun Joseh, chiꞌchi gudxixteeꞌ raꞌ ba nin guhdzi xaanjla raꞌ Dxiohs loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ya garaa bwiinn nin bihn dxyiꞌdxyi nin cañiꞌ raꞌ baxtohra badxyigaaꞌloh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per María guluꞌchaꞌyi dziꞌtsi ba garaatiiꞌ dxyiꞌdxyi raꞌ riiꞌ stoꞌ ba, cayuhnn si ba lligaaba pur xcweenta dxyiꞌdxyi raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ya seguihdu gubiaꞌgarii raꞌ baxtohra stuhbi bweelta hasta riiyahpa raꞌ ba lliꞌhyi. Cagadiꞌhi za raꞌ ba guelzuxchilli laꞌh Dxiohs pur garaa nin bihn raꞌ ba cun garaa za nin bwaꞌha raꞌ ba, tin garaa nin guhdzi aanjla loh raꞌ ba guhcan. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chin guhca xuhnna dxyih, chiꞌchi bacaꞌh raꞌ ba tuhbi bwaꞌ tihxi bi hasta naa bi ndxiꞌhw chiꞌchi bazoꞌba raꞌ ba lah bi Jesuhs, lahgahca nin guhdzi aanjla chi loh María chin nagahdxi gaalaa lliiꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ya chin bazaaꞌ dxyih biaa tihxi gunnaꞌh nin guulaa lliiꞌn ñiꞌh ziga rnabwaꞌ xlehyi Moisehs, chiꞌchi gwanee raꞌ ba badoꞌyiꞌhn chi nez guihdxyi Jerusalehn laꞌn guidoꞌ rooꞌ nin nuu guihdxyi chi tin gunaaba-gudxiꞌhn raꞌ ba gacanee Dxiohs laꞌh Ñiꞌh gaduhbi nin guibahan Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bwiꞌhnn raꞌ ba squiiꞌ laasii ziꞌchi caa loh xlehyi Moisehs: “Garaa lliiꞌn galoh tu nin naa biñiꞌn ndxiꞌhw cwii raꞌ tu bi tin guunn bi xtsiꞌn Dxiohs.” ");
INSERT INTO zpvNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ya neezaa badiꞌhi raꞌ ba loh Dxiohs ziga nin caa loh xlehyi Moisehs; chiohpa gulchieh o chiohpa palohmma. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ya laꞌn dxyih gahca chi guyuuꞌ tuhbi bwiinn nin biriaꞌlah Simeohn loh guihdxyi Jerusalehn. Guhca ba tuhbi bwiinn nayaa, bazoꞌbadxiahga ba garaa xchiꞌdxyi Dxiohs, ya cabweeza ba dxiꞌ Crixtu dxieꞌgataꞌh laꞌh raꞌ bwiinn Israel, neezaa rbweeza Spíritu Saantu xteenn Dxiohs laꞌn lastoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","LaꞌSpíritu Saantu badiꞌhi rsohn gwaꞌhxgah ba loh Crixtu nin guxeꞌhla Dxiohs antes gachi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bwiinn riiꞌ laꞌba badzihn laꞌn guidoꞌ guxeꞌhla Spíritu Saantu laꞌh ba, riꞌchi zuu ba chin badzihn xpah badoꞌyiꞌhn cun xmah Ñiꞌh laꞌn guidoꞌ chi tin guunn raꞌ ba ziga nin caa loh xlehyi Moisehs, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ya riꞌchi cabweeza Simeohn, ya chin bwaꞌha ba loh badoꞌyiꞌhn, chiꞌchi gudiꞌdzi ba laꞌh Ñiꞌh, chiꞌchi guzaꞌloh cañiꞌ ba xa chuhla naa Dxiohs, rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Daada Dxiohs, nicala nnah gusaaꞌn luꞌh naꞌh gariaꞌhan loh guidxyiyuh, tin nnah riahxiꞌhn bazaꞌloh luꞌh dxyiꞌdxyi nin gunah luꞌh loon, ziga naan xmooza luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","laasii nnah caywaꞌhaloon Crixtu nin guxeꞌhla luꞌh zeꞌgataꞌh laꞌh nu loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bazuh luꞌh Ñiꞌh delaanta loh garaa bwiinn guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","laasii laꞌh Ñiꞌh naa biaꞌñih nin guziaꞌñih yihca snuhn raꞌ bwiinn nin ayi naa bwiinn Israel, ya pura xcweenta Ñiꞌh ziñiꞌ bwiinn guidxyiyuh chuhla naa bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ya Joseh cun xmah Jesuhs badxyigaaꞌ raꞌ ba saca dxyiꞌdxyi nin bihn raꞌ ba pura xcweenta Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ya chiꞌchi bwiꞌhnntaaꞌyi Simeohn yihca Joseh cun xmah Jesuhs, chiꞌchi rahbi Simeohn loh María: ―Bwaꞌha, nin zeeguiꞌhnn badoꞌyiꞌhn riiꞌ ziahan bwiinn Israel chebiiga raꞌ ba loh xquelñaꞌñih Dxiohs, ziꞌchi gahca pur laꞌh bi zuñihchi ziahan raꞌ ba. Zahca bi ziga tuhbi sehn, ya ziahan bwiinn childxinee laꞌh bi ayi chechiistoꞌ raꞌ ba xchiꞌdxyi bi, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ya ziꞌchiza zuluuꞌyi ziga ruhnn cada tuhbigah raꞌ ba cuun lligaaba nin nuu lastoꞌ raꞌ ba; garaa deeꞌ gusahcazii yiꞌh, María. Chuu guelnalasa roo laꞌn lastoꞌ luꞌh ziga tuhbi spahda naa nin tiidxilahga stoꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Zuu gahcaza tuhbi naaniꞌhn nin biriaꞌlah Ahnna riꞌchi, rñiꞌ ba xcweenta xchiꞌdxyi Dxiohs nin zeꞌyaalda gaca. Laꞌh ba naa lliiꞌndxaꞌpa Fanuehl nin naa xjwamihyi Ahser. Bwiinn guhla la ba; bachinaa ba chin guhca ba dxaꞌpwiꞌhn, gahdzi yihza gubahnee ba cheꞌhla ba, chiꞌchi biaꞌhan ba viuhda. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Naa ba tuhbi gunnaꞌhviuhda nin nuu ochenta y cuatro yihza, ayi bariaꞌtiiꞌ ba laꞌn guidoꞌ. Dxyih-nagueꞌla gudihdxyi-gunaaba ba gacanee Dxiohs laꞌh ba, nee ziahanza bweelta bacwaaꞌhan ba ayi gudahw ba tin gudihdxyi-gunaaba ba loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ya gwabiiga ba loh Joseh cun xmah Jesuhs, badiꞌhi ba guelzuxchilli loh Dxiohs laasii badzihn Crixtu nin zeꞌgaldaꞌh laꞌh raꞌ bwiinn loh duhlda. Chiꞌchi guzoꞌbaloh cañiꞌ ba loh raꞌ bwiinn nin riiꞌ laꞌn guidoꞌ, rahbi ba: ―LaꞌCrixtu nin zeꞌgataꞌh laꞌh nuꞌh loh duhlda laꞌÑiꞌh badzihn loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ya chin bazaꞌloh raꞌ ba garaa nin caa loh xlehyi Moisehs, chiꞌchi babiaꞌgarii raꞌ ba para nez Galilea, hasta naa loh guihdxyi Nazaret, hasta naa lahdxyi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ya badoꞌyiꞌhn mahzi zeꞌrooꞌ Ñiꞌh mahziza zeꞌyahpa Ñiꞌh jweersi, zeꞌyahca nasiin Ñiꞌh de garaatiiꞌ cohsa zaꞌca, ziga cayahcanee Xtaada Dxiohs Ñiꞌh laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ya Joseh cun María xmah Jesuhs cada tuhbigah yihza riah raꞌ ba loh guihdxyi Jerusalehn chin rahca lañih paascu. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ya chin guyuuꞌ Jesuhs tsiꞌh bichiohpa yihza, chiꞌchi gwah raꞌ ba nez loh guihdxyi Jerusalehn, ziga naa costuumbre lañih chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ya chin guyaꞌloh lañih chi, chiꞌchi gubiaꞌgarii raꞌ ba ya ayi bwaꞌha raꞌ ba biaꞌhancaa Jesuhs guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ya bwiꞌhnn raꞌ ba lligaaba zieꞌ Jesuhs lahda raꞌ bwiinn, nee ziga naa la tuhbi dxyih nehza ziagazah raꞌ ba, chiꞌchiyi badxiꞌhyi raꞌ ba laꞌh Jesuhs loh raꞌ lasaaꞌ raꞌ ba neezaa loh raꞌ nin nuꞌnbwaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Per cun ayi badxeela raꞌ ba laꞌh Jesuhs, nahpa gubiaꞌgarii raꞌ ba para loh guihdxyi Jerusalehn tin bagadxiꞌhyi raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ya chin biohnna dxyih cagadxyiꞌhyi raꞌ ba laꞌh Ñiꞌh, chiꞌchiyi badxeela raꞌ ba laꞌh Jesuhs laꞌn guidoꞌ rooꞌ guihdxyi Jerusalehn, zohba Ñiꞌh lahda nuhn mwehsu nin ruluuꞌyi xlehyi Moisehs, cagacaꞌdxiahga Jesuhs neezaa canaabadxyiꞌdxyi Ñiꞌh loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ya garaa nin bihn xchiꞌdxyi Ñiꞌh badxyigaaꞌ raꞌ ba taantu nasiin Jesuhs neezaa xa rusiaꞌgarii Ñiꞌh dxyiꞌdxyi loh raꞌ mwehsu raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ya chin bwaꞌha Joseh cun xmah Jesuhs laꞌh Ñiꞌh, chiꞌchi badxyigaaꞌ za raꞌ ba, chiꞌchi rahbi xmah Ñiꞌh loh Ñiꞌh: ―Xiiꞌhihn, ¿xixnaa bwiꞌhnnee luꞌh naꞌh ziꞌca? Bwaꞌha, xpah luꞌh neen naꞌh ¡blaaca riacahstoꞌ nu yiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xixnaa ayi gaann tu ca gadxeela tu naꞌh? ¿Tayi gaann tu naꞌpa zuꞌnnahn xtsiꞌn Xpaaꞌn nin nuu dxibaaꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per laꞌh raꞌ ba ayi guhcabwaꞌ raꞌ ba nin guhdzi Jesuhs loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ya seguihdu gubiaꞌgariinee Jesuhs laꞌh raꞌ ba nez guihdxyi Nazaret, bazoꞌbadxiahga Ñiꞌh xchiꞌdxyi raꞌ ba. Nee xmah Ñiꞌh guluꞌchaꞌyi si ba dxyiꞌdxyi raꞌ chi laꞌn lastoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ya despwehsi zezah zeyahca nasiin Jesuhs nee zezah za zerooꞌ ru Ñiꞌh. Riahxinee Dxiohs laꞌh Jesuhs ziꞌchi gahca za riahxinee bwiinn laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Laꞌn dxyih raꞌ chin guhca tsiꞌñu yihza naa Tiberio César rrehyi, Ponciu Pilahtu naa gobernador xteenn Judea; Herodes naa gobernador guihdxyi Galilea; Felipe, bwihtsi Herodes, naa gobernador guihdxyi Iturea cun guihdxyi Traconite; nee neezaa Lisanias naa gobernador guihdxyi Abilinia. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Laꞌn dxyih gahca raꞌ chi naa Anahs neezaa Caifahs bixohza rooꞌ xteenn guidoꞌ rooꞌ guihdxyi Jerusalehn. Laꞌn dxyih gahca raꞌza chi nuu Jwahn, lliiꞌn Zacarías, loh dahan, tin guñiꞌnee Spíritu Saantu xteenn Dxiohs laꞌh Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Niꞌchin gucaꞌnzaa Jwahn garaa raꞌ guihdxyi nin rii gadiidxi guiiꞌw Jordahn. Riꞌchi baluuꞌyi ba nahpa gusaguꞌdzistoꞌ raꞌ bwiinn nee chioobaañihsa za raꞌ ba para gusiaꞌpitii Dxiohs xtuhlda raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ziꞌchi caa loh xchihtsi guehtu Isaías, tuhbi daada nin guñiꞌ xchiꞌdxyi Dxiohs, hasta rñiꞌn: Jweersi rooꞌ zihn raꞌ bwiinn tuhbi rsiaaꞌha loh dahan: “Gulguiꞌhnn zaꞌca xneziuh Dxiohs, nee gulgasanchii za xneziuh Ñiꞌh laꞌn lastoꞌ tu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Garaa raꞌ hasta naa bataaꞌha loh neziuh chi gadxyiiꞌhin, neezaa dahan cun lohmwiꞌhn raꞌ dxiahca tubilohon, neezaa neziuh raꞌ hasta naa liinguu ganchii raꞌn, garaa raꞌ loh neziuh dxaaba dxiahca tubiloh raꞌn; ");
INSERT INTO zpvNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ya garaa bwiinn guidxyiyuh zwaꞌha raꞌ ba laꞌh daada nin guixeꞌhla Dxiohs guhldaꞌh laꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chin bwaꞌha Jwahn cagadiaaꞌha ziahan roo raꞌ bwiinn tin guroꞌbañihsa ba laꞌh raꞌ ba, chiꞌchi rahbi Jwahn loh raꞌ ba: ―¡Laꞌh tu bwiinn naxihn raꞌ, nin naa zigazi bweꞌlda ñalaaꞌdzi! ¿Chyulla gudxixteeꞌ loh tu tin gulluꞌn tu loh xjwiisi Dxiohs nin gueꞌdu gaca? ");
INSERT INTO zpvNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gulgachaꞌh ziga nabahan tu tin gaaldaa tu loh xquelrnabwaꞌ Dxiohs. Ayi guunn tu lligaaba lasahca duxa tu pur naa tu llahga guehtu Abrahn. Rñiꞌn loh tu sidela ziꞌchi ñahca ziꞌchiza ñuhnn Dxiohs lligaaba hasta dxiah raꞌ ñuhnn Ñiꞌh llahga Abrahn, ");
INSERT INTO zpvNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","laasii laꞌh dxiꞌbayahga naꞌ liistu la tin chyuuga garaa yahga nin ayi xcah ñinahxi zaꞌca loh Ñiꞌh, garaa niꞌchi chyuuga tin guicaꞌdxihin. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ya chiꞌchi gunaabadxyiꞌdxyi raꞌ bwiinn loh Jwahn, rahbi raꞌ ba: ―Nahaxchiꞌh, ¿xa niꞌca guidiꞌhnn nuꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chiꞌchi rahbi Jwahn loh raꞌ ba: ―Nin nuu chiohpa nehza xahba ñiꞌh gudiꞌhi ba tuhbi nehzan laꞌh bwiinn nin ayi xi nahpatiiꞌ, tin gacu ban; neezaa bwiinn nin nuu xi rahw ñiꞌh chiꞌhzi ban cun bwiinn nin ayi xi nahpatiiꞌ gahw. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Neezaa nuhn bwiinn nin rusadxihlli impweestu badzihn raꞌ loh Jwahn tin guroꞌbañihsa Jwahn laꞌh raꞌ ba. Chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh Jwahn, rahbi raꞌ ba: ―Mwehsu, ¿xa guidiꞌhnn chiꞌh nu nnah laꞌhnu? ");
INSERT INTO zpvNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chiꞌchi rahbi Jwahn: ―Ayiru gusadxihlli tu guyahlli laꞌh raꞌ bwiinn; sola nahpa guunn tu zigachiꞌh canabwaꞌ lehyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Neezaa nuhn suldahdu gunaabadxyiꞌdxyi raꞌ ba loh Jwahn, rahbi raꞌ ba: ―Ya laꞌhaxchiꞌh nu, ¿xa guidiꞌhnn nu? Chiꞌchi rahbi Jwahn: ―Ayi cweꞌlluꞌh tu mweeyi loh bwiinn lajweersi, neezaa ayi gudziiꞌba tu duhlda yihca bwiinn nin ayi xi ruhnn, neezaa dxiaꞌhan tu cunjoorma cun zigachiꞌh ruhnn tu gahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ya gaduhbi riidxyiistoꞌ raꞌ bwiinn chi cayuhnn raꞌ ba lligaaba pwehda Jwahn naa Crixtu nin guixeꞌhla Dxiohs guidxyiyuh nin guhldaꞌh laꞌh raꞌ nuꞌh loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","chiꞌchi rahbi Jwahn loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, naꞌh ruroꞌbañihsahn bwiinn cun ñihsa, per ziꞌ stuhbi bwiinn nin guunn mas cohsa rooꞌ. Zuroꞌba ñihsa ba laꞌh bwiinn cun Spíritu Saantu nee neezaa cun bwehla. Ayi lasahcaꞌhn para bwiinn nin dxiꞌ chi, hasta para gacaꞌhn mooza nin cweꞌhe tahba ba ñaaꞌ ba ayi lasahcaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","’Laasi laꞌh pahla nuu liistula naa ba tin gahxu ba trihgu tin cweꞌhe ba dxihlli lohon, chiꞌchi gutiaaꞌha ban hasta riuꞌchaꞌyin; ya dxihlli chi gucaꞌdxyih ban ayi dxuꞌyitiiꞌrun. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Cun dxyiꞌdxyi raꞌ riiꞌ neezaa ziahanru guelruuꞌyidxyiꞌdxyi bwiiꞌyidxyiꞌdxyi Jwahn tin baluuꞌyi ba dxyiꞌdxyi cuubi laꞌh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ya neezaa gudxihldxinee dxyiꞌdxyi Jwahn laꞌh Herodes laasii guleꞌlluꞌhu Herodes laꞌh Herodías nin naa cheꞌhla bwihtsi ba nin laa Felipe, neezaa gudxihldxinee dxyiꞌdxyi Jwahn laꞌh Herodes laasii ziahanrooꞌ cosa dxaaba nin bwiꞌhnn Herodes. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Niꞌchin bidxyiꞌchi Herodes basieꞌw ba laꞌh Jwahn. Ya luulchimatiiꞌ bwiꞌhnn ziahan Herodes snuhn raꞌ dziꞌn dxaaba nin bwiꞌhnn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Chin nagahdxi gaca deeꞌ cagaroꞌbañihsa Jwahn ziahan bwiinn, neezaa Jesuhs gurohbañihsa, ya gaduhbi cabwihdxi-canaaba Jesuhs loh Dxiohs, billaala dxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","chiꞌchi biehta Spíritu Saantu yihca Jesuhs zigazi tuhbi palohmmwiꞌhn, bihn raꞌ ba tuhbi rsiaaꞌha guñiꞌ Dxiohs nez dxibaaꞌ: ―Yiꞌh naa luꞌh lliiꞌnahn nin nadziiꞌhihn, nee riahxi duxaꞌhn pur Yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Galda bitsiꞌh yihza nuu Jesuhs chin guzoꞌbaloh Ñiꞌh cayuhnn Ñiꞌh dziꞌn nin badiꞌhi Xtaada Dxiohs Ñiꞌh guunn Ñiꞌh. Garaa raꞌ bwiinn gwachiistoꞌ raꞌ ba naa Jesuhs lliiꞌn Joseh ya Joseh guhca lliiꞌn Elih. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elih guhca lliiꞌn Matat. Matat guhca lliiꞌn Levih. Levih guhca lliiꞌn Melqui. Melqui guhca lliiꞌn Jana. Jana guhca lliiꞌn Joseh. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseh guhca lliiꞌn Matatías. Matatías guhca lliiꞌn Amohs. Amohs guhca lliiꞌn Nahum. Nahum guhca lliiꞌn Esli. Esli guhca lliiꞌn Nagai. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai guhca lliiꞌn Maat. Maat guhca lliiꞌn Matatías. Matatías guhca lliiꞌn Semei. Semei guhca lliiꞌn Joseh. Joseh guhca lliiꞌn Judah. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judah guhca lliiꞌn Joana. Joana guhca lliiꞌn Resa. Resa guhca lliiꞌn Zorobabel. Zorobabel guhca lliiꞌn Salatiel. Salatiel guhca lliiꞌn Neri. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri guhca lliiꞌn Melqui. Melqui guhca lliiꞌn Adi. Adi guhca lliiꞌn Cosam. Cosam guhca lliiꞌn Elmodam. Elmodam guhca lliiꞌn Er. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er guhca lliiꞌn Josueh. Josueh guhca lliiꞌn Eliezer. Eliezer guhca lliiꞌn Jorim. Jorim guhca lliiꞌn Matat. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat guhca lliiꞌn Levih. Levih guhca lliiꞌn Simeohn. Simeohn guhca lliiꞌn Judah. Judah guhca lliiꞌn Joseh. Joseh guhca lliiꞌn Jonahn. Jonahn guhca lliiꞌn Eliaquim. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim guhca lliiꞌn Melea. Melea guhca lliiꞌn Mainahn. Mainahn guhca lliiꞌn Matata. Matata guhca lliiꞌn Natahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natahn guhca lliiꞌn Davihd. Davihd guhca lliiꞌn Isaí. Isaí guhca lliiꞌn Obed. Obed guhca lliiꞌn Booz. Booz guhca lliiꞌn Salmohn. Salmohn guhca lliiꞌn Naasohn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasohn guhca lliiꞌn Aminadab. Aminadab guhca lliiꞌn Admin. Admin guhca lliiꞌn Aram. Aram guhca lliiꞌn Esrom. Esrom guhca lliiꞌn Fares. Fares guhca lliiꞌn Judah. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah guhca lliiꞌn Jacob. Jacob guhca lliiꞌn Isaac. Isaac guhca lliiꞌn Abrahn Abrahnguhca lliiꞌn Tareh. Tareh guhca lliiꞌn Nacor. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor guhca lliiꞌn Serug. Serug guhca lliiꞌn Ragau. Ragau guhca lliiꞌn Peleg. Peleg guhca lliiꞌn Heber. Heber guhca lliiꞌn Sala. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala guhca lliiꞌn Cainahn. Cainahn guhca lliiꞌn Arfaxad. Arfaxad guhca lliiꞌn Sem. Sem guhca lliiꞌn Noeh. Noeh guhca lliiꞌn Lamec. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec guhca lliiꞌn Matusalehn. Matusalehn guhca lliiꞌn Enoc. Enoc guhca lliiꞌn Jared. Jared guhca lliiꞌn Mahaleleel. Mahaleleel guhca lliiꞌn Cainahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainahn guhca lliiꞌn Enohs. Enohs guhca lliiꞌn Set. Set guhca lliiꞌn Adahn. Adahn guhca lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Per ya gadxah stoꞌ nabahan Jesuhs Spíritu Saantu, chiꞌchi bareꞌh Ñiꞌh guiiꞌw Jordahn, tin gwanee Spíritu Saantu laꞌh Ñiꞌh par loh dahan desiertu. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ya guyuuꞌ Ñiꞌh nezchi chywaꞌh dxyih chywaꞌh gueꞌla, ya riꞌchi badzihn bwiinndxaaba tin guclaaꞌdzi ba ñusaguiꞌhi ba laꞌh Jesuhs. Ya ayi xi gudahwtiiꞌ Jesuhs dxyih raꞌ chi ya bichiaꞌhn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ya rahbi bwiinndxaaba loh Jesuhs: ―Sidela guchii luꞌh naa luꞌh Lliiꞌn Dxiohs, guhdzi loh dxiah raꞌ ca dxiahcan guehta. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chiꞌchi rahbi Jesuhs loh bwiinndxaaba chi: ―Caa loh Xchihtsi Dxiohs: “Ayi guehtasi dxiꞌh gahw bwiinn guunn para guibahan raꞌ ba; xchiꞌhn neezaa guzoꞌbadxiahga raꞌ ba garaa xchiꞌdxyi Dxiohs.” ");
INSERT INTO zpvNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ya chiꞌchi gwanee bwiinndxaaba laꞌh Jesuhs tuhbi dahan rooꞌ, chiꞌchi baluuꞌyi ba garaatiiꞌ guihdxyi raꞌ nin rii guidxyiyuh tin gwaꞌha Jesuhs xa chuhla naa raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","chiꞌchi rahbi bwiinndxaaba loh Jesuhs: ―Naꞌh guniꞌhihn garaatiiꞌ deeꞌ yiꞌh tin guinabwaꞌ raꞌ luꞌhn nee tin dxiahxi za luꞌh, laasii xteꞌnnahn naa garaa deeꞌ, nee zahca gudiꞌhihñin laꞌh chyu chiꞌhzi bwiinn nin xclaaꞌdzihn. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sidela guzuꞌnllihbi luꞌh lohon, gaann luꞌh naꞌh, garaatiiꞌ niꞌca guniꞌhihn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chiꞌchi rahbi Jesuhs: ―Caa loh Xchihtsi Dxiohs: “Daada Xchiohs si luꞌh gaann luꞌh, loh si Ñiꞌh chuu luꞌh guunn luꞌh dziꞌn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ya seguihdu gwanee bwiinndxaaba chi laꞌh Jesuhs yihca guidoꞌ rooꞌ nin nuu guihdxyi Jerusalehn, ya riꞌchi rahbi ba loh Jesuhs: ―Sidela guchii luꞌh naa luꞌh Lliiꞌn Dxiohs, balaꞌha yiꞌh desde riꞌca para loh yuh, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","laasii caa loh Xchihtsi Dxiohs: Zixeꞌhla Ñiꞌh xaanjla Ñiꞌh tin gaapa raꞌ ba yiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ya cun naa raꞌ aanjla raꞌ chi zinaꞌzu raꞌ ba yiꞌh tin ayi guraꞌlluudzidxiah ñaaꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chiꞌchi rahbi Jesuhs: ―Neezaa caa loh xchihtsi Dxiohs: “Ayi guunn tu prehba laꞌh Dxiohs nin rnabwaꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ya bwaꞌha si bwiinndxaaba ayi bidxeela ba xa ñusaguiꞌhi ba laꞌh Jesuhs, mejor basaaꞌn ba laꞌh Ñiꞌh tin guleeza ba stuhbi dxyih tin gusahcazii ru ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chiꞌchi gubiaꞌgarii Jesuhs nez guihdxyi Galilea, gadxah chihpa stoꞌ nabahan Ñiꞌh Spíritu Saantu tin guunn Ñiꞌh xtsiꞌn Xtaada Ñiꞌh, ya bidiꞌchi xchiꞌdxyi Ñiꞌh garaa guihdxyi raꞌ chi saca taantu nin nuu nabahan dziꞌtsi Spíritu Saantu stoꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pwihsi guzoꞌbaloh nuugaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs garaa raꞌ laꞌn guidoꞌ biꞌtuꞌhn nin nuu guihdxyi raꞌ chi, nee garaa bwiinn ruzeꞌta raꞌ ba xa na zaꞌca naa Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ya chiꞌchi gwah Jesuhs guihdxyi nez bieꞌrooꞌ Ñiꞌh, guihdxyi chi laa Nazaret. Chin guhca dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, chiꞌchi guyuꞌtii Jesuhs laꞌn guidoꞌ ziga naa xcostuumbre Ñiꞌh, pwihsi guzuꞌnchii Ñiꞌh biꞌlda Ñiꞌh xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Seguihdu badiꞌhi raꞌ ba dxihtsi nin bacaꞌh Isaías; ya chin guxaala Jesuhs loh dxihtsi chi, chiꞌchi badxeela Ñiꞌh hasta rñiꞌ dxyiꞌdxyi raꞌ riiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nuunee Spíritu Saantu xteenn Dxiohs naꞌh laasii gulii Ñiꞌh naꞌh zeꞌldaneꞌhn dxyiꞌdxyi zaꞌca loh raꞌ bwiinn prohbi, neezaa tin guhldaꞌhn laꞌh raꞌ bwiinn nin rnabwaꞌ bwiinndxaaba, neezaa tin guixaaꞌlahn loh raꞌ bwiinn nin rahcaloh Ñiꞌh tin gwaꞌha raꞌ ba, neezaa tin guhldaꞌhn laꞌh raꞌ bwiinn nin cadiiꞌdxi trabahju; ");
INSERT INTO zpvNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","neezaa tin chixteꞌhn loh raꞌ bwiinn laꞌdxyih badzihn galahsastoꞌ Dxiohs laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chiꞌchi bataꞌw Jesuhs loh dxihtsi chi, ya basiaꞌgarii Ñiꞌhn loh bwiinn nin racanee laꞌn guidoꞌ, chiꞌchi guzohba Ñiꞌh. Ya garaa raꞌ bwiinn nin rii laꞌn guidoꞌ chi caywaꞌhadziꞌtsi raꞌ ba loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ya guzoꞌbaloh cañiꞌ Jesuhs, rahbi Ñiꞌh: ―Laꞌdxyiꞌdxyi nin caa loh dxihtsi riiꞌ bariaꞌcaa para laꞌh tu. Naꞌh gahca naan nin ruzeꞌtan. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ya garaa raꞌ ba guñiꞌ zaꞌca raꞌ ba pur Jesuhs, cun badxyigaaꞌza raꞌ ba pur dxyiꞌdxyi zaꞌca nin guñiꞌ Jesuhs, ya rahbi loh lasaaꞌ raꞌ ba: ―¿Per tayi dee dxiꞌh nin naa lliiꞌn Joseh? ");
INSERT INTO zpvNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Naa siguhra ziñiꞌ tu loon: “Dutohra, yiꞌh gahca basiaca yiꞌh”; neezaa guiñiꞌ tu loon: “Neezaa cohsa raꞌ nin bwiꞌhnn luꞌh nez guihdxyi Capernaum, neezaa riiꞌ bwiꞌhnnan hasta naa paꞌh lahdxyi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chiꞌchi zeezah cañiꞌ Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, nicala tuhbi daada nin rñiꞌ xchiꞌdxyi Dxiohs pwehda zibweꞌhestoꞌ bwiinn lahdxyi ba laꞌh ba, niꞌchin pwehda ayi guunn tu cweenta xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rñiꞌn loh tu, chin gubahan guehtu Elías guidxyiyuh ziahan gunnaꞌhviuhda guyuuꞌ lahdxyi bwiinn Israel, ya chin ayi xi ñihsadxiah biaabatiiꞌ loh chohnna yihza garoolda chiꞌchi guyuuꞌ tuhbi gubihn duxa loh gaduhbi guihdxyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","per ayi guxeꞌhla Dxiohs laꞌh Elías nin tuhbi rwaaꞌyihdzi gunaꞌhviuhda loh garaa gunnaꞌhviuhda nin guyuuꞌ guihdxyi chi; mejor guxeꞌhla Dxiohs laꞌh ba loh tuhbi bwinnziitu, rwaaꞌyihdzi tuhbi gunnaꞌhviuhda nin guyuuꞌ guihdxyi Sarepta, gahxu guihdxyi Sidohn. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ziꞌchi gahcaza chin gubahan guehtu Eliseu loh guidxyiyuh, guyuuꞌ ziahan bwiinn guihdxyi Israel nin guhchyi guiiꞌdxyu yuuꞌdxi tihxi raꞌ Ñiꞌh, ya ayi basiaca Eliseu nin tuhbi raꞌ ba; mejor basiaca ba laꞌh tuhbi bwiinnziitu nin biriaꞌlah Naamahn, tuhbi bwiinn guihdxyi ziitu nin laa Siria. Ziꞌchi gahcaza naꞌh, ayi napa guꞌnnahn dziꞌn rooꞌ loh tu laasii naan bwiinn riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ya chin bihn raꞌ ba dxyiꞌdxyi raꞌ chi, garaatiiꞌ ziga rii raꞌ ba laꞌn guidoꞌ bidxyiꞌchi duxa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","chiꞌchi guñiꞌnee lasaaꞌ raꞌ ba tin babweꞌhecaꞌha raꞌ ba laꞌh Jesuhs hasta yihca tuhbi lohmma nin riaꞌhan gahxu rwaaꞌ guihdxyi chi, tin ñulaꞌha raꞌ ba laꞌh Jesuhs laꞌn bataaꞌha rooꞌ nin nuu ñaaꞌ lohmma chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ya nin ayi guhcabwaꞌ raꞌ ba badiiꞌdxi Jesuhs galaayillee raꞌ ba, ziaa chiꞌh Ñiꞌh para stuhbi lahta. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chiꞌchi gwah Jesuhs guihdxyi Capernaum, tuhbi guihdxyi xteenn Galilea. Ya nezchi guzaꞌloh cagasiꞌdxi Ñiꞌh laꞌh raꞌ bwiinn chi chin badzihn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ya badxyigaaꞌ bwiinn raꞌ chi pura xchiꞌdxyi Jesuhs zigazi ruluuꞌyi Ñiꞌh ziga tuhbi bwiinn naann, ziga tuhbi nin rnabwaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laꞌn guidoꞌ chi guyuuꞌ tuhbi ndxiꞌhw nin guyuuꞌ bwiinndxaaba stoꞌ Ñiꞌh. Ya gudidxyidxiah bwiinndxaaba ba, rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Ayy, basaaꞌn laꞌh nu! ¿Xixzeꞌ luꞌh riiꞌ Jesuhs nin zeꞌ guihdxyi Nazaret? ¿Ta zeꞌ luꞌh tin guñihchiloh luꞌh laꞌh nu? ¡Naꞌh nuꞌnbwaꞌn yiꞌh, yiꞌh nin naa luꞌh Lliiꞌn Saantu Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ya chiꞌchi gudxindxinee dxyiꞌdxyi Jesuhs laꞌh bwiinndxaaba chi, rahbi Ñiꞌh: ―¡Bataꞌw rwaaꞌ luꞌh tin bariaꞌh tihxi bwiinn ca! Chiꞌchi gudxihndxiah bwiinndxaaba chi laꞌh bwiinn chi nezloh garaa raꞌ ba, chiꞌchi bariaꞌh ba stoꞌ ba ya ayiru xi guelrzaꞌcazii bwiꞌhnn bwiinndxaaba chi laꞌh bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ya badxyigaaꞌloh garaa raꞌ ba, chiꞌchi guzaꞌloh cañiꞌ loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Xi dxyiꞌdxyi raꞌ riiꞌ rñiꞌ bwiinn riiꞌ? ¡Bwaꞌha xa rnabwaꞌ daada riiꞌ bwiinndxaaba nee nahpa ruzoꞌbadxiahga raꞌ bwiinndxaaba xchiꞌdxyi ba rariaꞌh raꞌ ba stoꞌ raꞌ bwiinn! ");
INSERT INTO zpvNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chiꞌchi bidiꞌchi dxyiꞌdxyi nin bwiꞌhnn Jesuhs loh garaa raꞌ guihdxyi nin rii gadiidxi guihdxyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ya chin bariaꞌh Jesuhs laꞌn guidoꞌ, chiꞌchi gwah Ñiꞌh yihdzi Simohn Pehdru. Ya xnaanswehgra Simohn cayahcalluꞌhu jweertarooꞌ nuu ba lliaꞌh, ya gunaaba raꞌ ba loh Jesuhs tin gusiaca Ñiꞌh laꞌh naan chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chiꞌchi gwabiiga Jesuhs loh naaniꞌhn chi, tin gunabwaꞌ Ñiꞌh loh lliaꞌh chi bariaꞌhan tihxi bwiinn chi ya lwehguza bariaꞌh lliaꞌh chi, chiꞌchi gwastii naan chi, ya biguihn ba tuhbi guelwahw para laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ya hohra nin zohbayaꞌzi gubihdxyi, gwanee raꞌ bwiinn guihdxyi garaa raꞌ bwiinn nin rahcalluꞌhu hasta nuu Jesuhs, tin badziiꞌbanaa Jesuhs yihca raꞌ bwiinn nin rahcalluꞌhu chi tin biaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ya ziahan raꞌ bwiinn nin rahcalluꞌhu chi bariaꞌh bwiinndxaaba stoꞌ raꞌ ba ya chin bariaꞌh raꞌ bwiinndxaaba tihxi raꞌ ba, chiꞌchi gudidxyidxiah raꞌ ba, rahbi raꞌ ba loh Jesuhs: ―¡Yiꞌh naa luꞌh Lliiꞌn Dxiohs! Ya Jesuhs gunabwaꞌ Ñiꞌh laꞌh raꞌ ba tin ayi xi guuyi raꞌ ba ziga naann raꞌ ba naa Jesuhs Crixtu nin cabweeza raꞌ bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ya chin barah gueꞌla, chiꞌchi biriaꞌh Jesuhs rwaaꞌguihdxyi chi tin gwah Ñiꞌh tuhbi lahta hasta ayi bwiinn. Ya ziahan bwiinn badxiꞌhyi laꞌh Ñiꞌh, ya chin badxeela raꞌ ba laꞌh Ñiꞌh ayi guclaaꞌdzi raꞌ ba ñariaꞌh Jesuhs lahdxyi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Nahpa guluuꞌyiꞌhn xchiꞌdxyi xquelrnabwaꞌ Dxiohs ziahan guihdxyi, niꞌchin nin guxeꞌhla Dxiohs naꞌh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ya ziꞌchi gucaꞌnzaa Jesuhs gucaꞌngaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌn guidoꞌ biꞌtuꞌhn raꞌ xteenn guihdxyi raꞌ nin rnabwaꞌ Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ya guyuuꞌ tuhbi dxyih zuu Jesuhs rwaaꞌ tuhbi laguhn nin laa Genesaret. Chin badzihnsuu ziahan bwiinn riꞌchi, bataꞌwnaa raꞌ ba laꞌh Jesuhs taantu xclaaꞌdzi raꞌ ba dxihn raꞌ ba xchiꞌdxyi Dxiohs nin ruluuꞌyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ya riꞌchi bwaꞌha Jesuhs chiohpa laancha nin ayi xi nuu laꞌn ñiꞌh rii raꞌn gahxu rwaaꞌ laguhn chi. Ayi chyu nuu tiiꞌ laꞌn raꞌ laancha chi laasii hohrachi biriaꞌh raꞌ bwiinn chi tin cadxiꞌbi raꞌ ba dxihxi nin rnaꞌzu raꞌ ba bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chiꞌchi guyuꞌtii Jesuhs laꞌn laancha xteenn Simohn ya gunaaba Jesuhs gwanee Pehdru laancha chi mahza za balaaquiꞌhn loh ñihsa laasii tin ayi chyu bwiinn chebiiga gahxu cweeꞌ laancha chi, ya hasta laꞌn laancha chi guzohba Jesuhs chiꞌchi guzaꞌloh cagaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn nin rii rwaaꞌ ñihsa chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ya chin guyaꞌloh baluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs, chiꞌchi rahbi Ñiꞌh loh Simohn: ―Gulchenee laancha ca nez loh ñihsa roo ru cun dxihxi bwehlda tin guinaꞌzu tu bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chiꞌchi rahbi Simohn loh Jesuhs: ―Mwehsu, gaduhbi gueꞌla dxudiꞌhnn nu dziꞌn per nin tuhbi bwehlda ayi chyu gunaꞌzu. Per sidela ziꞌchi rnabwaꞌ yuꞌbiluꞌh, laꞌnu chogalaꞌha dxihxi stuhbweelta. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ya chin balaꞌha raꞌ ba dxihxi bwehlda chi, binaꞌzu ziahanroo bwehlda ya hasta guzohbaloh cagaꞌllu dxihxi taantu ziahan bwehlda gunaꞌzu raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chiꞌchi bwiꞌhnn raꞌ ba sehn loh lasaaꞌ raꞌ ba nin nuu laꞌn stuhbi laancha tin chegacanee raꞌ ba laꞌh raꞌ ba. Ya chin badzihn raꞌ ba riꞌchi, chiꞌchi babweꞌhe raꞌ ba dxihxi bwehlda ya garoopa laancha chi gwadxahan bwehlda ya amweer ñizaꞌbiñihsa raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ya chin bwaꞌha Simohn Pehdru niꞌchi, chiꞌchi bazuꞌnllihbi ba nez loh Jesuhs, chiꞌchi rahbi ba loh Ñiꞌh: ―Basaaꞌn naꞌh, Daada; mejor gwah si tin naꞌh nuu xtuꞌldahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ziꞌchi guñiꞌ Simohn laasii badxyigaaꞌ ba nee cun garaa nin canee ba badxyigaaꞌza laasii gunaꞌzu raꞌ ba bwehlda ziahan chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Neezaa Jacobo cun Jwahn lliiꞌn Zebedeu neezaa raꞌ ba badxyigaaꞌloh raꞌ ba. Per rahbi Jesuhs loh Simohn: ―Ayi guidxyihbi luꞌh. Desde nnah cwiidxyi luꞌh bwiinn raꞌ xcweenta xquelrnabwaꞌ Dxiohs xlawaaꞌha riateꞌhe luꞌh bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ya chin babweꞌhecaa raꞌ ba laancha raꞌ chi rwaaꞌ ñihsa, basiaꞌhan raꞌ ba garaatiiꞌ nin nahpa raꞌ ba ya chiꞌchi zenee raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Chin guyuuꞌ Jesuhs laꞌn tuhbi guihdxyi raꞌ chi, gwah tuhbi bwiinn loh Jesuhs rahchyi guiiꞌdxiu gaduhbitiiꞌ tihxi ba, per chin bwaꞌha ba loh Jesuhs chiꞌchi bazuꞌnllihbi ba baruꞌhn ba hasta loh yuh, ya guñiꞌnalaasa ba loh Jesuhs, rahbi ba: ―Daada, sidela ziziꞌguehlda luꞌh zuhnn luꞌh gahn gusiaca luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ya chiꞌchi basagaꞌh naa Jesuhs tin cun naa Ñiꞌh bidxiꞌ Ñiꞌh tihxi bwiinn chi, chiꞌchi rahbi Jesuhs loh ba: ―Xclaaꞌdzihn dxiaa tihxi luꞌh, laꞌluꞌh biaca nnah. Ya lwehgusi guñiꞌchiloh gueldxyihdxyi chi tihxi bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ya gunabwaꞌ Jesuhs loh ba ayi xi guuyitiiꞌ ba loh raꞌ bwiinn xi bwiꞌhnn Ñiꞌh pur laꞌh ba, chiꞌchi rahbi Jesuhs loh ba: ―Sola chegaluuꞌyi luꞌh tihxi luꞌh laꞌh bixohza tin gwaꞌha ba laꞌluꞌh biaca, neezaa chenee luꞌh tuhbi guelrgaaꞌda nin biaca luꞌh ziga rnabwaꞌ xlehyi Moisehs tin gacabwaꞌ raꞌ bwiinn laꞌluꞌh biaca. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per mahziru bidiꞌchi dxyiꞌdxyi pur garaa nin bwiꞌhnn Jesuhs, nee ziahan bwiinn badiaaꞌha tin dxihn raꞌ ba xchiꞌdxyi Ñiꞌh neezaa tin gusiaca Ñiꞌh laꞌh raꞌ bwiinn nin rahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ya Jesuhs ziahan bweelta biriaꞌcaa Ñiꞌh loh raꞌ bwiinn raꞌ tin riah Ñiꞌh nez hasta ayi chyu bwiinn gwaꞌhatiiꞌ, tin riꞌchi rbwihdxyi-rnaaba Ñiꞌh gacanee Xtaada Dxiohs Ñiꞌh nin nuu dxibaaꞌ laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ya tuhbi dxyih cagaluuꞌyi Jesuhs laꞌh raꞌ bwiinn nee nezachi zohba raꞌ nuhn bwiinn guidoꞌ nin laa fariseu, neezaa nuhn mwehsu nin ruluuꞌyi xlehyi Moisehs. Ya mwehsu raꞌ chi zeꞌ raꞌ ba guriin-guriin guihdxyi raꞌ nin rnabwaꞌ Galilea neezaa rregiohn Judea neezaa guihdxyi Jerusalehn, ya Spíritu Saantu xteenn Dxiohs nuu nabahandziꞌtsi stoꞌ Jesuhs tin gusiaca Ñiꞌh laꞌh raꞌ bwiinn nin rahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ya seguihdu badzihn paaldaa ndxiꞌhw raꞌ nin zeꞌnee tuhbi bwiinn lasaaꞌ raꞌ ba naꞌ bwiinn chi loh tuhbi luꞌhn ayi nuu ñiñiꞌbi ba. Ya ndxiꞌhw raꞌ chi guclaaꞌdzi raꞌ ba ñiguꞌtii raꞌ ba bwiinn nin rahcalluꞌhu chi laꞌñuuꞌ nezloh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","per ayi bidxeela raꞌ ba canehz ñuꞌtiinee raꞌ ba laꞌh bwiinn nin rahcalluꞌhu chi laasii bwiinn ziahan rii riꞌchi, niꞌchin mejor gucah raꞌ ba yihca yuuꞌ, chiꞌchi baxaala raꞌ ba hasta batehta raꞌ ba laꞌh bwiinn nin rahcalluꞌhu chi hasta zuu Jesuhs laꞌñuuꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ya chin bwaꞌha Jesuhs riachiistoꞌ raꞌ ba laꞌh Ñiꞌh ruhnn Ñiꞌh gahn rusiaca Ñiꞌh laꞌh raꞌ bwiinn nin rahcalluꞌhu, chiꞌchi rahbi Ñiꞌh loh nin rahcalluꞌhu chi: ―Mihgu, laꞌxtuhlda luꞌh basiaꞌpitiin nnah. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chiꞌchi guzaꞌloh raꞌ mwehsu nin ruluuꞌyi lehyi cun fariseu raꞌ, riiyuhnn raꞌ ba lligaaba, nastoꞌ raꞌ ba: “¿Chyulla bwiinn riiꞌ nin cañiꞌyah laꞌh Dxiohs? Ayi nin tuhbi bwiinn nin rusiaꞌpitii xtuhlda bwiinn. ¡Tuhbidxiꞌh Dxiohs ruhnnan!” ");
INSERT INTO zpvNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ya Jesuhs laꞌÑiꞌh guhcabwaꞌ xi lligaaba riiyuhnn bwiinn chi, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Xixnaa ruhnn tu lligaaba ziꞌca? ");
INSERT INTO zpvNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw nee naꞌpahn guelrnabwaꞌ para gusiaꞌtiin xtuhlda raꞌ bwiinn loh guidxyiyuh. Mwedxi ayi guinagahn gaꞌpihn loh bwiinn riiꞌ: “Laꞌxtuhlda luꞌh basiaꞌtii Dxiohs”, laasii chyuchiꞌhzi bwiinn zahca guiñiꞌ ziꞌchi. Mahziru nagahn gaꞌpihn loh bwiinn riiꞌ: “Gwastii tin batiaaꞌha xluꞌhn luꞌh bwaa yihdzi luꞌh.” ¡Bayinnah!, tin gacabwaꞌ tu naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, niꞌchin nin cañiꞌn loh bwiinn riiꞌ: “Loh luꞌh rñaan: Gwastii, batiaaꞌha xluꞌhn luꞌh tin bwaa yihdzi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ya guyaꞌlohsi guñiꞌ Jesuhs ziꞌchi lwehgusi gwastii bwiinn chi, batiaaꞌha ba xluꞌhn ba, chiꞌchi ziaa ba badiiꞌdxi ba lahda raꞌ garaa bwiinn chi, cañiꞌ ba xa chuhla naa Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ya chin bwaꞌha raꞌ bwiinn nin rii gadiidxi laꞌn yuuꞌ chi nin guhca, bidxyihbi raꞌ ba laasii guhca basiaꞌtii Jesuhs xtuhlda bwiinn, rahbi raꞌ ba: ―¡Bayinnahsihn bidiaꞌhan nuꞌh tuhbi cohsa rooꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ya chin guyaꞌloh niꞌchi, chiꞌchi bariaꞌh Jesuhs riꞌchi, chiꞌchi bwaꞌha Ñiꞌh loh tuhbi bwiinn nin rsadxihlli impweestu, bwiinn chi laa Levih, zohba ba tuhbi laꞌn hasta rahlla impweestu, chiꞌchi rahbi Jesuhs loh ba: ―Gudaꞌnaꞌhla naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chiꞌchi gwasuꞌnchii Levih, basiaꞌhan ba garaatiiꞌ nin nahpa ba tin gwanaꞌhla ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ya chin badzihnnee Levih laꞌh Jesuhs rwaaꞌ yihdzi ba chiꞌchi bwiꞌhnn ba tuhbi guelwahw rooꞌ, tin gudahwnee ba laꞌh Jesuhs. Ya riꞌchi rii raꞌ ziahan rooꞌ ru raꞌ bwiinn nin rsadxihlli impweestu, cun neezaa snuhn raꞌ bwiinn zi nin rii raꞌ riꞌchi, ya garaa raꞌ ba zohbanee Jesuhs hasta zuu mweella. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chiꞌchi guzohbaloh cañiꞌyah raꞌ bwiinn fariseu cun mwehsu raꞌ nin ruluuꞌyi lehyi laꞌh xpwiinn Jesuhs, rahbi raꞌ ba: ―¿Xixnaa rahwnee tu, cun reeꞌnee tu bwiinn raꞌ nin rsadxihlli impweestu cun neezaa bwiinn nin ayi ruhnn cweenta xlehyi Moisehs? ");
INSERT INTO zpvNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chiꞌchi rahbi Jesuhs: ―Bwiinn raꞌ nin ayi xi rahca ayi xchiꞌhn raꞌ ba dutohra, mejor chee dutohra hasta rahcalluꞌhu raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ziꞌchiza naꞌh, ayi zeꞌldatiidxyidxiꞌhn bwiinn zaꞌca sino que zeꞌldahn tin cwiidxyihn bwiinn raꞌ nin nuu xtuhlda Ñiꞌh tin gusaguuꞌdzi stoꞌ raꞌ ba loh Dxiohs cun chezah raꞌ ba loh xquelñaꞌñih Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ya chiꞌchi gunaabadxyiꞌdxyi bwiinn raꞌ chi loh Jesuhs, rahbi raꞌ ba: ―Xpwiinn raꞌ Jwahn nin rroꞌbañihsa neezaa xpwiinn raꞌ fariseu ziahan bweelta rucwaaꞌhan raꞌ ba tin rbwihdxi-rnaaba raꞌ ba loh Dxiohs, ya xpwiinn luꞌh rahw si raꞌ ba. ¿Xixnaa ayi rucwaaꞌhan raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chiꞌchi rahbi Jesuhs: ―¿Ta zahca gucwaaꞌhan bioꞌza loh tuhbi saaꞌ gaduhbi nin rinee raꞌ ba nuꞌbimbahyi? Agaa guchii dxiꞌh ayi nin tuhbi bwiinn nin guunn ziꞌchi. Ziꞌchilla naꞌh ayi nuu gucwaaꞌhan raꞌ xpwiꞌnnahn gaduhbi nuuneꞌh raꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per ziuuꞌ dxyih cweꞌcaa raꞌ ba nin bachinaa ya ayiru chezah saaꞌ, chiꞌchisihn zucwaaꞌhan raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Guñiꞌza Jesuhs dxyiꞌdxyi raꞌ riiꞌ loh raꞌ ba, rahbi Ñiꞌh: ―Ayi tuhbi bwiinn nin guchyuuꞌga tuhbi lahdxyi cuubi gacan rramieenda cun tuhbi lahdxyi yuꞌxa, laasii sidela guunn ba ziꞌchi zuxiꞌhn ba xaba cuubi ba neezaa tahyi lahdxyi cuubi nin bachyuuꞌga ba ayi dxiaꞌhan zaꞌcan cun lahdxyi yuꞌxa. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ya ayiza nuu guidaꞌh vinnu cuubi laꞌn dxihdxi yuꞌxa, laasii vinnu cuubi chi zichiehzan dxihdxi yuꞌxa cun bwih jweerta nin radziiba lohon ziꞌchi zilliꞌn vinnu cun dxihdxi za chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Niꞌchin mejor guidaꞌh vinnu cuubi laꞌn dxihdxi cuubi ya ziꞌchi garoopan dxiaꞌhan zaꞌcan. ");
INSERT INTO zpvNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Cun neezaa chyuchiꞌhzi bwiinn nin guee galoh vinnu yuꞌxa pwehda ayi guiclaaꞌdzi ba gueeꞌ ba vinnu cuubi laasii guiñiꞌ ba: “Vinnu yuꞌxa mahzi chuhlan pur guyahan nuuꞌun cadxyih.” Ziꞌchi guiñiꞌ ba laasii laꞌba nuu valohri la, ayi biin rwaaꞌ ba xi gwaaꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nee tuhbi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, zeezah Jesuhs cun bwiinn raꞌ nin rusiꞌdxi Ñiꞌh nez loh yuh hasta naꞌ trihgu. Ya guzoꞌbaloh raꞌ xpwiinn Ñiꞌh chi riigachwaꞌha raꞌ ba trihgu tin gulloꞌba raꞌ ban bireꞌh bwiꞌdziꞌhn raꞌ chi gudahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ya nuhn bwiinn fariseu nin rii nezchi gunaabadxyiꞌdxyi raꞌ ba loh Jesuhs, rahbi raꞌ ba: ―¿Xixnaa ayi ruzoꞌbadxiahga tu ziga naa lehyi, ziga ayi guunn tu dziꞌn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta nagahdxi guꞌlda tu loh Xchihtsi Dxiohs cuun nin bwiꞌhnn guehtu Davihd tuhbi dxyih nin bichiaꞌhan ba cun garaa raꞌ xpwiinn ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Guyuꞌtii ba laꞌn xquidoꞌ Dxiohs tin gudahw ba pahn nin ayi nuu gahw raꞌ zuuzi bwiinn raꞌ laꞌn dxyih raꞌ chi laasii guhcan nin gudiiꞌdxi guhn loh Dxiohs. Laꞌh ba cun gudahw ban, neezaa badiꞌhi ban laꞌh raꞌ bwiinn nin canee ba riꞌchi ya ayi xi bwiꞌhnn Dxiohs, nee coma bixohza si rahca rahw pahn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Neezaa rahbi Jesuhs: ―Ziꞌchi gahcaza naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, niꞌchin zahca guiñiꞌn loh raꞌ bwiinn xa naa xnehza guunn raꞌ ba ziga dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chin guhca stuhbi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, guyuꞌtii Jesuhs laꞌn tuhbi guidoꞌ biꞌtuꞌhn, tin guzoꞌbaloh cagaluuꞌyi Ñiꞌh bwiinn raꞌ. Ya riꞌchi zohba tuhbi bwiinn nin gubihdzi tuhbi lahdu derehchu naa ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ya mwehsu raꞌ nin ruluuꞌyi lehyi neezaa bwiinn fariseu riigaldaꞌtsisi raꞌ ba tin gwaꞌha raꞌ ba diaꞌhan zusiaca Jesuhs laꞌh bwiinn nin rahcalluꞌhu chi dxyih nin rziꞌlaaꞌdzi raꞌ ba tin ziꞌchi guidxeela raꞌ ba xa gucaꞌchiah dxixiꞌhw raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ya laꞌh Jesuhs laꞌÑiꞌh naannla cuun lligaaba nin riiyuhnn raꞌ bwiinn chi, chiꞌchi rahbi Ñiꞌh loh bwiinn nin gubihdzi naa ñiꞌh chi: ―Gwasuhnchii, gudaꞌbiiga galaayi riiꞌ. Chiꞌchi gwasuꞌnchii bwiinn chi, guzuh ba galaayi chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinn dxixiꞌhw chi: ―Xclaaꞌdzihn guinaabadxyiꞌdxyiꞌhn deeꞌ loh tu: ¿Cuun nin rusaaꞌn lehyi gaca dxyih nin raziꞌlaaꞌdzi nuꞌh? ¿Ta dziꞌn zaꞌca o dziꞌn dxaaba? ¿Ta zaldaꞌh nuꞌh bwiinn loh guelguhchi o zasaaꞌn nuꞌh gachi ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chiꞌchi bwaꞌha Jesuhs loh garaa bwiinn nin rii gadiidxi Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh ndxiꞌhw chi: ―Batsiꞌyi naa luꞌh. Chin bwiꞌhnn ndxiꞌhw chi ziꞌchi, lwehgugahca biaca naa ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ya bwiinn dxixiꞌhw raꞌ chi bidxyiꞌchi duxa raꞌ ba, chiꞌchi guzaꞌloh canaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba xa guunnee raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ya stuhbi dxyih gucah Jesuhs tuhbi dahan tin para gudihdxyi-gunaaba Ñiꞌh loh Xtaada Dxiohs Ñiꞌh tin gacanee Dxiohs laꞌh Ñiꞌh, batiꞌdxi Ñiꞌh gueꞌla cabwihdxyi-canaaba Ñiꞌh loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ya chin barah gueꞌla, gudihdxyi Jesuhs xpwiinn raꞌ Ñiꞌh, chiꞌchi gulii Ñiꞌh tsiꞌh bichiohpa raꞌ ba nin guleꞌhelah Ñiꞌh pooxtla raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Dee raꞌ naa nin guhca xpooxtla Ñiꞌh: Simohn nin guleꞌhelah Ñiꞌh Pehdru; cun Andrehs bwihtsi Simohn; Jacob cun Jwahn; neezaa Felipe cun Bartolomeh; ");
INSERT INTO zpvNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","neezaa Mateu cun Tomahs; neezaa Jacob lliiꞌn Alfeu; neezaa Simohn nin guyuuꞌ lahda raꞌ cananista; ");
INSERT INTO zpvNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","neezaa Judas bwihtsi Jacobo; cun Judas Iscariote, nin batooꞌ laꞌh Jesuhs loh raꞌ bixohza. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Seguihdu biehtanee Jesuhs laꞌh raꞌ ba dahan chi, tin gurih raꞌ ba hasta nataaꞌ. Neezaa rii ziahan roo raꞌ bwiinn guihdxyi raꞌ nin rnabwaꞌ rregiohn Judea nee guihdxyi Jerusalehn nee raꞌ guihdxyi nin rii gadiidxi ñihsadoꞌ, hasta nuu rregiohn Tiru cun Sidohn. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Laꞌh raꞌ ba zeꞌ tin dxihn raꞌ ba xchiꞌdxyi Jesuhs nee tin dxiaca raꞌ ba gueldxyihdxyi nin rahca raꞌ ba. Cagasiaca Jesuhs laꞌh raꞌ ba, neezaa bwiinn raꞌ nin rdiiꞌdxi trabahju laasii guyuꞌtii bwiinndxaaba raꞌ stoꞌ raꞌ ba, neezaa laꞌh raꞌ ba cagasiaca Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ya guclaaꞌdzi garaa bwiinn ñidxiꞌ raꞌ ba tihxi Jesuhs laasii taantu nin nuu nabahandziꞌtsi Spíritu Saantu stoꞌ Ñiꞌh nee bihn gahca raꞌ ba garaa bwiinn nin rdxiꞌ tihxi Jesuhs cayaaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ya chiꞌchi basiaꞌgarii Jesuhs loh Ñiꞌh loh raꞌ xpwiinn Ñiꞌh, rahbi Ñiꞌh loh raꞌ ba: ―Dichohsa naa tu bwiinn raꞌ nin gaca nadoꞌlaaꞌdzi nezloh Dxiohs laasii xteenn tu naa garaa nin rnabwaꞌ Ñiꞌh nez dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dichohsa tu, bwiinn raꞌ nin rchiaꞌhn nnah laasii zuniꞌhi Dxiohs nin rnaaba tu loh Ñiꞌh. ’Dichohsa tu, bwiinn nin ruꞌn nnah pura rahcabwaꞌ tu nuu xtuhlda tu, laasii zadzihn Dxyih nin gusiahxi Dxiohs stoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Dichohsa tu chin guunn ñaꞌlaaꞌdzi raꞌ bwiinn loh tu, nee chin gabweꞌhecaꞌhaza raꞌ ba laꞌh tu ditsijwehra, cun guiguii raꞌ ba loh tu, neezaa chin cweꞌhestoꞌ raꞌ ba laꞌh tu, ziga tuhbi cohsa xihn laasii riachiistoꞌ tu xchiꞌdxyiꞌhn, ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Guldxiahxi dxyih raꞌ nin saca tu ziꞌchi neezaa guireꞌnchiehsa pur taantu dxiahxi tu. Niꞌchin gapa tu tuhbi guelnazaꞌca rooꞌ llaaꞌndxibaaꞌ. Nee ziꞌchi gahca guehtu xtaada raꞌ bwiinn nin rguii laꞌn dxyih raꞌ riiꞌ, basaꞌcazii raꞌ ba laꞌh daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs ca chieempa. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Per prohbi za laꞌh tu rricu raꞌ laasii nnah si gapa tu cohsa zaꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Prohbi za laꞌh tu nin rahw zaꞌca nnah laasii zibwichiaꞌhan tu despwehsi. ’Prohbi za laꞌh tu nin rullihdzi nnah ya despwehsi zibwiyuꞌn tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Prohbi za laꞌh tu sidela pura cohsa zaꞌca rñiꞌ snuhn bwiinn pur laꞌh tu laasii ziꞌchi gahca guñiꞌ bwiinn chieempa pur bwiinn raꞌ nin bwiiꞌyidxyiꞌdxyi xihn xlawaaꞌha ñuuꞌyidxyiꞌdxyi raꞌ ba xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Rahbiza Jesuhs: ―Laꞌh tu nin riigacaꞌdxiahga xchiꞌdxyiꞌhn, rñiꞌn dxyiꞌdxyi riiꞌ loh tu: gulgantsiiꞌhi laꞌh bwiinn nin rdxihldxinee laꞌh tu, gulguiꞌhnn za bwen laꞌh raꞌ bwiinn nin rdxyiꞌchinee laꞌh tu; ");
INSERT INTO zpvNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","gulguiꞌhnntaaꞌyi yihca raꞌ bwiinn nin rguꞌdii laꞌh tu, neezaa gulguinaaba loh Dxiohs guziaꞌtii Ñiꞌh xtuhlda raꞌ bwiinn nin rguii loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sidela chyuulla chaꞌzi tuhbi lahdu cwahsa tu, neezaa stuhbi lahdu gulgadiꞌhi gulgasaaꞌn chaꞌzi ba laꞌh tu; nee sidela chyuulla cweꞌhe xchiquehta tu, gulgasaaꞌn cweꞌhe ba neezaa xmaanga tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xichiꞌhzi nin guinaaba raꞌ ba loh tu gulgadiꞌhin, nicala cweꞌlluꞌhu raꞌ ba xixteenn tu ayi guunn tu jweersi ganiꞌhi raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gulguiꞌhnnee laꞌh bwiinn ziga xclaaꞌdzi tu guunnee raꞌ ba laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sidela laꞌh tu nadziiꞌhi tu bwiinn raꞌ nin nadziiꞌhi laꞌh tu, lliaaꞌsi niꞌchi, laasii ziꞌchi gahcaza ruhnn raꞌ bwiinn duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sidela guunn tu bwen laꞌhsi raꞌ bwiinn nin ruhnn bwen laꞌh tu, lliaaꞌsi niꞌchi laasii ziꞌchi gahcaza ruhnn raꞌ bwiinn nin nabahan loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sidela rbweꞌdxiꞌhnsi tu mweeyi laꞌh raꞌ bwiinn nin xñah gadxillin, lliaaꞌzi niꞌchi laasii ziꞌchi gahca rbweꞌdxiꞌhn bwiinn duhlda mweeyi ya rbweeza raꞌ ba gadxilli raꞌ bwiinn chin loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ya laꞌh tu gulgantsiiꞌhi bwiinn nin ayi guinadziiꞌhi laꞌh tu, ya guunn tu bwen laꞌh bwiinn nin ayi ruhnn bwen laꞌh tu, neezaa cweꞌhedxiꞌhn tu mweeyi ayi guunn tu lligaaba gadxilli bwiinn chin loh tu. Sidela guunn tu garaa cohsa raꞌ chi, zahpa tu tuhbi guelnazaꞌca rooꞌ nee zahcaza tu lliiꞌn Dxiohs nin nuu nabahandziꞌtsi llaaꞌndxibaaꞌ, laasii ziꞌchi gahca nadziiꞌhi ba laꞌh raꞌ bwiinn nin ayi rñiꞌ: “Zuxchilli luꞌh” pur xiilla nin ruhnn Ñiꞌh pur laꞌh raꞌ ba neezaa bwiinn raꞌ nin ayi ruhnn cweenta xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gulgalahsastoꞌlasaaꞌ tu ziga ralahsastoꞌ Xtaada nuꞌh nin nuu dxibaaꞌ garaa raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Rahbiza Jesuhs: ―Neezaa ayi guluuꞌyi xcwihin tu lasaaꞌ tu tin ayiza guluuꞌyi xcwihin za Dxiohs laꞌh tu, ayiza gudziiꞌba duhlda yihca lasaaꞌ tu tin ayi za gudziiꞌba duhlda Dxiohs yihca tu. Gusiaꞌlda stoꞌ tu garaa nin ruñihchi bwiinn lasaaꞌ tu loh tu, tin gusiaꞌldaza stoꞌ Dxiohs garaa nin ruñihchi tu loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gulgadiꞌhi nin xchiꞌhn raꞌ bwiinn ya ayi xi guelrzaaꞌ chuu tu Dxiohs gahca gadxillin loh tu, nee zutarloo Ñiꞌhn cun hasta guchah chihpa Ñiꞌhn, guiguihdzin, guiriꞌhin hasta tiidxisuuꞌhun rwaaꞌ madxihdu nin badiꞌhi tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rahbiza Jesuhs: ―¿Ta zalluꞌyi tuhbi dxieꞌpa guicah ba naa stuhbi dxieꞌpa tin guluuꞌyi ba neziuh laꞌh stuhbi bwiinn dxieꞌpa? ¿Tayigah dxiaaba raꞌ ba calla laꞌn guiiꞌdxiu garoopagah raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","¿Ta lasahcaru tuhbi nin rusiꞌdxi que no tuhbi nin ruluuꞌyi laꞌh ba? Ya bwiinn nin rusiꞌdxi chi, chin gutuhlla ba scwehyi ba, chiꞌchiyi gaca ba ziga guhca xmwehsu ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Xa guunn luꞌh gwaꞌha luꞌh dxihlliꞌhn nin nuu laꞌn loh bwihtsi luꞌh ziga ayi rusaaꞌn baltaadxiu nin nuu laꞌn loh gahca luꞌh gwaꞌha luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Xixnaachiꞌh rahbi luꞌh loh bwihtsi luꞌh gabweꞌhe luꞌh dxihlli nin nuu loh bi nee ayi rabweꞌhexgah luꞌh baltaadxiu nin nuu laꞌn loh luꞌh? ¡Bwiinn rusaguiꞌhi! Babweꞌhexgah baltaadxiu nin nuu laꞌn loh luꞌh tin ziꞌchi gwaꞌha zaꞌca luꞌh gabweꞌhe luꞌh dxihlli nin nuu laꞌn bizloh bwihtsi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Rahbiza Jesuhs: ―Ayi nin tuhbi yahga zaꞌca nin guicah ñinahxi dxaaba loh Ñiꞌh, nee ayiza yahga dxaaba nin guicah ñinahxi zaꞌca loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","laasii cada yahga riuꞌnbwaꞌ bwiinn ñinahxi nin xcah lohon. Ayi ruchyuaꞌha raꞌ ba ñiigu loh yaguihchi, ayiza ruchyuaꞌha raꞌ ba uhva loh yaguichaaꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bwiinn zaꞌca rñiꞌza cohsa zaꞌca, laasii cohsa zaꞌca naa nin nuu stoꞌ ba, nee bwiinn nadxaaba rñiꞌ ba ganaalla cohsa dxaaba za, laasii niꞌchi nuu stoꞌ ba. Cun rwaaꞌ bwiinn rñiꞌ ba dxyiꞌdxyi nin nuu stoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Rahbi za Jesuhs: ―¿Xixnaa rñiꞌ tu loon: “Ballwaaꞌn, ballwaaꞌn”, nee ayi ruhnn tu cweenta xchiꞌdxyiꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Guiñaan loh tu chyu xñah ziga xñah bwiinn nin ruzoꞌbadxiahga garaa nin rñiꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Xñah ba ziga xñah tuhbi bwiinn nin bazaꞌ tuhbi yuuꞌ. Galoh gudaꞌhn ba gueeta rooꞌ chiꞌchi bwiꞌhnn ba simieentu yihca tuhbi dxiah. Ya chin guyaꞌloh yuuꞌ, chiꞌchi biaaba tuhbi ñihsadxiah xihn, bieꞌta tuhbi ñihsyuhdoꞌ guiꞌw hasta bwiꞌhnn bwiinn chi yuuꞌ. Ya ñihsyuh chi guhcacaaꞌhan tihxi yihdzi ba per nin blaaquiꞌhn ayi bañiꞌbin yuuꞌ chi laasii dziꞌtsi bidxiꞌdxiun yihca dxiah chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ya bwiinn nin ayi rzoꞌbadxiahga xchiꞌdxyiꞌhn nee ayiza ruhnn ba nin raꞌpihn, xñah ba ziga xñah tuhbi bwiinn nin bwiꞌhnn tuhbi yihdzi Ñiꞌh zigachiꞌhzi guhcan, ayi xi simieentu bwiꞌhnn ba. Ya chin bieꞌta ñihsyuhdoꞌ chiꞌchi guhcacaaꞌhan tihxi yuuꞌ chi, ya gurih gaduhbitiiꞌ yuuꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ya chin guyaꞌloh guñiꞌ Jesuhs loh raꞌ bwiinn, chiꞌchi zee Ñiꞌh tuhbi guihdxyi nin laa Capernaum. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Riꞌchi nuu tuhbi bwiinn romano nin rnabwaꞌ ziga rnabwaꞌ tuhbi capitahn, gohpa ba tuhbi mooza guntsiiꞌhi duxa ba laꞌh mooza chi, ya loh nin cayahcalluꞌhu mooza chi amweerla laꞌh ba gachi. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chin bihn capitahn chi ruuꞌyidxyiꞌdxyi raꞌ bwiinn pur dziꞌn roo raꞌ nin cayuhnn Jesuhs, chiꞌchi guxeꞌhla ba paaldaa bwiinnguuhla xteenn Israel tin checaꞌha raꞌ ba laꞌh Jesuhs tin gusiaca Ñiꞌh laꞌh bwiinn nin rahcalluꞌhu chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ya chin badzihn raꞌ ba hasta zuu Jesuhs, chiꞌchi guzaꞌloh cañinee raꞌ ba laꞌh Ñiꞌh tin chegasiaca Ñiꞌh laꞌh xmooza capitahn chi, rahbi raꞌ ba: ―Capitahn riiꞌ rgaꞌha gacanee luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","laasii laꞌh ba nadziiꞌhi duxa ba laꞌh raꞌ bwiinn Israel; laꞌh gahca ba nin guleꞌhe mweeyi guhcachaꞌyi xquidoꞌ biꞌtuꞌhn nu. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ya loh nin zeenee Jesuhs laꞌh raꞌ ba, ya zegadzihn raꞌ ba rwaaꞌyuuꞌ, chin badzihn paaldaa mihgu nin guxeꞌhla capitahn chi tin rahbi raꞌ ba loh Jesuhs: ―Squiiꞌ nnah capitahn: Daada, ayi gucweꞌza luꞌh xtsiꞌn luꞌh pur naꞌh. ¿Chyuulla naan tin chuꞌtii luꞌh rwaaꞌ yihdzihn? ");
INSERT INTO zpvNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pur ayi lasahcaꞌhn niꞌchin ayi bieꞌldagadxyiꞌhyihn yuꞌbiluꞌh. Cun sola guiñiꞌ si luꞌh, nnahncaa xmooꞌzahn dxiaca, ");
INSERT INTO zpvNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","laasii nuu bwiinn nin mahzi lasahca ziga lasahcaꞌhn nee rnabwaꞌ raꞌ ba naꞌh. Ziꞌchi gahcaza naꞌpahn mooza rnabwaꞌraꞌn ba. Chin raꞌpihn loh tuhbi raꞌ ba: “Gwah”, riah ba; ya chin raꞌpihn loh stuhbi raꞌ ba: “Gudaaꞌ”, riꞌ ba; ya chin raꞌpihn loh stuhbi raꞌ ba: “Guunn luꞌh deeꞌ”, ruhnn ban. Ya yuꞌbiluꞌh sidela guinabwaꞌ luꞌh laꞌh lliaꞌh riiꞌ gahbi luꞌh: “Bariaꞌh tihxi bwiinn ca”, nahpa lliaꞌh gariaꞌhan tihxi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ya chin bihn Jesuhs xchiꞌdxyi capitahn chi, badxyigaaꞌ loh Ñiꞌh pur dxyiꞌdxyi raꞌ nin guñiꞌ ba, ya biahyi Ñiꞌh tin guñiꞌ Ñiꞌh loh raꞌ bwiinn nin naꞌhla laꞌh Ñiꞌh, rahbi Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, nin loh raꞌ bwiinn Israel ayi badxeelaꞌhn nin tuhbi bwiinn nin riachiistoꞌ ñiꞌh xchiꞌdxyiꞌhn ziga riachiistoꞌ daada capitahn riiꞌhin. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ya chin babiaꞌgarii raꞌ bwiinn nin guxeꞌhla capitahn chi para yihdzi ba, chiꞌchi bwaꞌha raꞌ ba laꞌxmooza ba chi biaca. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ya laꞌn dxyih raꞌ chi gwah Jesuhs tuhbi guihdxyi nin laa Naihn, gwanee Ñiꞌh xpwiinn raꞌ Ñiꞌh neezaa ziahan raꞌ bwiinn zi gwanaꞌhla laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ya chin zegadzihn raꞌ ba gahxu rwaaꞌ guihdxyi chi bwaꞌha raꞌ ba zeꞌnee raꞌ bwiinn guihdxyi chi tuhbi guetaguhla zegacaꞌtsi raꞌ ba. Ya guetaguhla chi tuhbidxiꞌh bi naa bi lliiꞌngaꞌn tuhbi gunnaꞌhviuhda. Ya ziahan bwiinn guihdxyi chi bwiꞌhnn compahñu laꞌh gunnaꞌhviuhda chi zegacaꞌtsi raꞌ ba lliiꞌngaꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ya chin bwaꞌha Jesuhs niꞌchi, chiꞌchi balahsastoꞌ Ñiꞌh laꞌh gunnaꞌhviuhda chi, rahbi Ñiꞌh: ―Ayiru guꞌn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chiꞌchi gwabiiga Jesuhs cweeꞌ toombra nin naꞌ bwiinnguuchi chi, ya gunaꞌzu Ñiꞌh tihxi toombra chi. Chiꞌchi guleeza raꞌ bwiinn nin nuꞌa laꞌh guetaguhla chi. Chiꞌchi rahbi Jesuhs loh guetaguhla chi: ―Nuꞌbi, ¡gwastii! Naꞌh cañiꞌn loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ya chin gwastii nuꞌbi nin guhchi chi, chiꞌchi guzohba bi, ya bañiꞌ bi, chiꞌchi badiꞌhi Jesuhs laꞌh bi laꞌh xmah bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ya chin bwaꞌha raꞌ bwiinn nin zegacaꞌtsi laꞌh bi bacwaꞌhn Jesuhs laꞌh bi, chiꞌchi bidxyihbi duxa raꞌ ba laasii bwaꞌha raꞌ ba guhca bacwaꞌhn Jesuhs laꞌh nuꞌbi chi loh guelguhchi, ya guzaꞌloh riiñiꞌ raꞌ ba: ―¡Bayi Dxiohs sihn chuhla naa Ñiꞌh! ¡Tuhbi bwiinn nin mahzi lasahca nin rñiꞌ xchiꞌdxyi Dxiohs laꞌba badzihn nezloh nuꞌh! Neezaa rahbi raꞌ ba: ―LaꞌDxiohs badzihn gacanee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nee gaduhbi Judea bidiꞌchi dxyiꞌdxyi nin bwiꞌhnn Jesuhs, neezaa garaa raꞌ guihdxyi nin rii nezchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ya xpwiinn raꞌ Jwahn nin ruroꞌbañihsa bwiiꞌyidxyiꞌdxyi raꞌ ba loh Jwahn garaatiiꞌ nin bwiꞌhnn Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Chiꞌchi gudihdxyi Jwahn chiohpa xpwiinn ba, tin guxeꞌhla Jwahn laꞌh raꞌ ba gwaganaabadxyiꞌdxyi raꞌ ba loh Jesuhs: ―¿Ta yiꞌh naa luꞌh Crixtu nin dxyubweꞌza nu, o zachibweꞌza nu stuhbi bwiinn? ");
INSERT INTO zpvNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ya chin badzihn raꞌ bwiinn chi loh Jesuhs, chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Jwahn nin ruroꞌbañihsa guxeꞌhla laꞌh nu tin zoꞌpaganaabadxyiꞌdxyi nu loh yuꞌbiluꞌh, ¿ta yiꞌh naa luꞌh Crixtu nin dxyuleꞌza nu o nahpa gachileꞌza nu stuhbi ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ya hohragahca nin badzihn raꞌ ba, cagasiaca Jesuhs nuhn raꞌ bwiinn nin rahcalluꞌhu de guriin-guriin gueldxyihdxyi, neezaa nin nuu bwiinndxaaba laꞌn lastoꞌ raꞌ ñiꞌh ya ziahan raꞌ bwiinniꞌhn nin rahca loh ñiꞌh biaca loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ya guhdzi Jesuhs loh raꞌ bwiinn nin guxeꞌhla Jwahn, rahbi Ñiꞌh: ―Gulcheguihtsi loh Jwahn garaa nin bwaꞌha tu nee garaa nin bihn tu. Gulgahbi loh Jwahn: “Bwiinn raꞌ nin rahcaloh ñiꞌh laꞌloh raꞌ ba biaca, bwiinn raꞌ nin ayi nuu sah laꞌraꞌ ba bazah, bwiinn raꞌ nin rahchi guiiꞌdxiu tihxi ñiꞌh laꞌguiiꞌdxiu chi guñihchiloh tihxi raꞌ ba, bwiinn raꞌ nin rahcadxiahga ñiꞌh, laꞌdxiahga raꞌ ba ballaala, bwiinn raꞌ nin guhchi laꞌraꞌ ba babahn loh guelguhchi, ya bwiinn prohbi raꞌ nin cabweeza gacanee Dxiohs laꞌh raꞌ ba cagazoꞌbadxiahga raꞌ ba dxyiꞌdxyi nin guhldaꞌh laꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dichohsa raꞌ bwiinn nin riuꞌnbwaꞌ naꞌh, nin ayi cweꞌhestoꞌ ñiꞌh naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ya chin ziaa raꞌ bwiinn nin guxeꞌhla Jwahn, chiꞌchi guzoꞌbaloh cañiꞌ Jesuhs loh raꞌ bwiinn xcweenta Jwahn, rahbi Ñiꞌh: ―¿Chyu niꞌca gwaguiaꞌha tu nezloh dahan? ¿Ta tuhbi bwiinn nin ziaa-zieꞌ lligaaba ñiꞌh ziga tuhbi ñihta nin bieehla gudzihbi bwih? ");
INSERT INTO zpvNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sidela ayi guhca ziꞌchi, ¿xilla gwaguiaꞌha si chiꞌh tu? ¿Ta gwaguiaꞌha tu tuhbi bwiinn ziga nin nahcu lahdxi zaꞌca? Sola hasta nuu puura yuuꞌ zaꞌca ziga xteenn rrehyi guidxeela bwiinn ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Xi gwaguiaꞌha chiꞌh tu? ¿Ta gwagwiaꞌha tu tuhbi daada nin rñiꞌ xchiꞌdxyi Dxiohs? Guchiin, bwiinn chi mahzi lasahca ziga naa ba tuhbi daada nin rñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Laasii Jwahn naa ndxiꞌhw nin ruzeꞌta Xchihtsi Dxiohs hasta caa dxyiꞌdxyi raꞌ riiꞌ: “Zixeꞌhlaꞌhn tuhbi xpwiiꞌnnahn dxiꞌ loh luꞌh tin laꞌh ba guzuhnayaa neziuh nin chee luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Ñaan loh tu, loh garaa bwiinn nin ayi rahlanee Spíritu Saantu ayi nin tuhbi raꞌ ba naa mahzi bwiinn lasahca loh Dxiohs que Jwahn. Per ya chyuchiꞌhzi bwiinn nin rahlanee Spíritu Saantu chuu ba loh xquelrnabwaꞌ Dxiohs nin gueꞌdu gadzihn, mahziru lasahca ba que Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chin bihn raꞌ bwiinn dxyiꞌdxyi raꞌ riiꞌ, neezaa bwiinn raꞌ nin rsadxihlli impweestu, guhcabwaꞌ raꞌ ba ruhnn Dxiohs guelguxchiisi zaꞌca laasii baroꞌbañihsa Jwahn laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per bwiinn fariseu raꞌ cun mwehsu raꞌ nin ruluuꞌyi xlehyi guehtu Moisehs guleꞌhe stoꞌ raꞌ ba guelnazaꞌca nin ñuhnn Dxiohs para laꞌh raꞌ ba laasii ayi guclaaꞌdzi raꞌ ba ñuroꞌbañihsa Jwahn laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Rahbi za Jesuhs loh raꞌ ba: ―¿Chyu bwiinn xñah ziga xñah bwiinn raꞌ riiꞌ, nee xa naa raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xñah raꞌ ba ziga xñah raꞌ biñiꞌn nin zohbadzihta ziga loh dxiaaꞌ nee rñiꞌ raꞌ bi jweersi loh raꞌ lasaaꞌ raꞌ bi: “Bachidxiꞌlda nu flauta tin ñudxiaꞌha tu per ayi badxiaꞌha tu; neezaa bidxiꞌlda rwaaꞌ nu dxyiꞌdxyi nalaasa tin ñuꞌn tu, per ayi za biꞌn tu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Laasii biꞌ Jwahn nin ayi gudahw ba ziahan nee ayi za gwaaꞌ ba nin tuhbi clahsa vihnnu ya laꞌh tu nnah tu: “Bwaꞌha, pweda nuu tuhbi bwiinndxaaba lastoꞌ Jwahn niꞌchin ruhnn ba ziꞌchi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nee lwehgu badzihnaꞌhn ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, raawuhn nee reeꞌzahn vihnnu ya laꞌh tu nnah tu: “Bwaꞌha xa rahw luꞌh nee bwaꞌha xa reeꞌ za luꞌh vihnnu, nee bwaꞌha xa radxaꞌga luꞌh loh raꞌ bwiinn duhlda nee neezaa loh raꞌ nin rsadxihlli impweestu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ziꞌchi rñiꞌ tu pur garaa nin ruhnn Dxiohs, per bwiinn nin guchii rahcabwaꞌ dxyiꞌdxyi, guuyi raꞌ ba xnehza duxa naa ziga ruhnn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Guñiꞌ tuhbi bwiinn fariseu loh Jesuhs, rahbi ba: ―Dxiꞌ luꞌh rwaaꞌ yiidzihn tin guidaꞌw nuꞌh. Ya gwanee Jesuhs laꞌh ba rwaaꞌ yihdzi ba, chiꞌchi gurih raꞌ ba nez hasta zuu mweella. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ya guyuuꞌ tuhbi bwiinn guihdxyi chi gahca nin naa tuhbi gunnaꞌh dxaaba. Chin bihn bi zeetahwnee Jesuhs laꞌh bwiinn fariseu chi, chiꞌchi gwanee bi tuhbi mwehdxi biꞌtuꞌhn nsehchi nahxi nin lasahca duxa mweeyi ya neezaa mwehdxiꞌhn lasahcazan. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ya chin badzihnnee gunnaꞌh chi mwehdxiꞌhn nsehchiꞌhn chi, bazuꞌnllihbi bi nez dihtsi Jesuhs, ya baruꞌhn bi, guzoꞌbaloh cayuꞌn bi, ya cun ñihsabwii nin cayaaba loh bi gudxiꞌbi bi ñaaꞌ Jesuhs, ya bacwihdzi gahca bi ñaaꞌ Jesuhs cun dxyichyihca bi, chiꞌchi bachaꞌgarwaaꞌ bi ñaaꞌ Ñiꞌh, cun gudaꞌbi bi nsehchi chi ñaaꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ya fariseu nin gunaaba gwatahw Jesuhs tuhbi guelwahw yihdzi ba, chin bwaꞌha ba nin bwiꞌhnn gunnaꞌh chi, bwiꞌhnn ba lligaaba: “Sidela daada riiꞌ guchii ba rñiꞌ ba xchiꞌdxyi Dxiohs, nahpa gacabwaꞌ ba chyu gunnaꞌh riiꞌ nin bieꞌdxiꞌn nez cweeꞌ ba nee xa naa xtuhlda bi, laasii gunnaꞌh riiꞌ gunnaꞌh dxaaba bi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chiꞌchi rahbi Jesuhs loh bwiinn fariseu chi: ―Simohn, naꞌpahn tuhbi dxyiꞌdxyi guiñiꞌn loh luꞌh. Chiꞌchi rahbi bwiinn fariseu chi loh Ñiꞌh: ―Gunnahan loon, mwehsu. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chiꞌchi rahbi Jesuhs loh ba: ―Chiohpa bwiinn nuzaꞌbi mweeyi loh tuhbi bwiinn, ya ruhnn ba lliiꞌnan. Tuhbi ba nuzaꞌbi gaꞌyu gaywaꞌh denario (ziga ruhnn tuhbi bwiinn gahn loh tuhbi yihza garoolda), stuhbi ba nuzaꞌbi chywaꞌh bitsiꞌhsin (zigachiꞌh ruhnn tuhbi bwiinn gahn loh chiohpa bweꞌhw). ");
INSERT INTO zpvNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nee coma ayi nahpa raꞌ ban ñadxihlli raꞌ ban, ya bwiinn chi guridxyiistoꞌ ba pur mweeyi nin nuzaꞌbi raꞌ bwiinn chi loh ba. Yannah gunnah guidiaꞌhan ¿cuun bwiinn nin mahzi gantsiiꞌhi laꞌh bwiinn nin rbweꞌdxiꞌhn mweeyi riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ya chiꞌchi rahbi Simohn loh Jesuhs: ―Pwehda bwiinn nin bazaꞌbi ziahan mweeyi loh ba. Chiꞌchi rahbi Jesuhs: ―Xnehza guñiꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lwehgu bwaꞌha Jesuhs loh gunnaꞌh chi, chiꞌchi rahbi Ñiꞌh loh Simohn: ―Bwaꞌha gunnaꞌh riiꞌ. Chin guyuꞌtiin rwaaꞌ yihdzi luꞌh, ayi guleꞌhe luꞌh nuhn ñihsa ñidxiꞌbi ñaaꞌhahn, ya laꞌh bi gudxiꞌbi bin cun ñihsabwii nin biaaba loh bi, ya bacwihdzi gahca bin cun dxyichyihca bi; ");
INSERT INTO zpvNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ya yiꞌh ayiza bachaꞌgarwaaꞌ luꞌh naꞌh ziga naa costuumbre, ya laꞌh bi dez guyuꞌtiin cagachaꞌgarwaaꞌ bi ñaaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ayiza gudaꞌbi luꞌh nsehchi yiꞌcahn ziga naa costuumbre ya laꞌh bi gudaꞌbi bi nsehchi nahxi ñaaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Niꞌchin cañiꞌn loh luꞌh laꞌgaraatiiꞌ xtuhlda ziahan bi basiaꞌpitiin laasii nadziiꞌhi bi Dxiohs gaduhbistoꞌ bi. Ya bwiinn nin gulliaaꞌ rusiaꞌpitii Dxiohs xtuhlda ñiꞌh, gulliaꞌza nadziiꞌhi raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Laꞌxtuhlda luꞌh basiaꞌpitiilahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ya chin bihn raꞌ garaa bwiinn nin zohbanee Ñiꞌh hasta zuu mweela dxyiꞌdxyi raꞌ chi, guzoꞌbaloh riñiꞌ loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Chyulla Daada riiꞌ? ¡Hasta xtuhlda raꞌ bwiinn rusiaꞌpitii ba! ");
INSERT INTO zpvNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Per gwazahtiiꞌ guñiꞌ Jesuhs loh gunnaꞌh chi, rahbi Ñiꞌh: ―Laꞌluꞌh gulaꞌh loh xtuhlda luꞌh laasii gwachiistoꞌ luꞌh xchiꞌdxyiꞌhn. Bwaa nnah gulahchidxyiistoꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ya chin guhca deeꞌ, gucaꞌnzaa Jesuhs ziahan guihdxyi cun rraandxu raꞌ batiꞌchi Ñiꞌh xchiꞌdxyi Dxiohs tin chuꞌtii raꞌ bwiinn loh xquelñaꞌñih Dxiohs, nee cun tsiꞌh bichiohpaza xpwiinn Ñiꞌh caꞌnzanee Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","neezaa paaldaa raꞌ gunnaꞌh caꞌnzanee Ñiꞌh, ya gunnaꞌh raꞌ chi naa nin basiaca Jesuhs. Babweꞌhe Ñiꞌh bwiinndxaaba stoꞌ paaldaa raꞌ ba ya spaaldaa raꞌ ba basiaca Ñiꞌh gueldxyihdxyi nin guhca raꞌ ba. Loh raꞌ ba zeꞌ María nin laa Magdalena nin bariaꞌh gahdzi bwiinndxaaba stoꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Neezaa Jwahna cheꞌhla Chuza nin rahpa xixteenn Herodes neezaa Susahn, ya ziahanru chyuuca raꞌ gunnaꞌh badxaꞌgalasaaꞌ raꞌ ba tin bwiꞌhnn raꞌ ba cumpahñu laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ya chiꞌchi biriaꞌh raꞌ ziahan bwiinn ziahan guihdxyi raꞌ tin gwaguiaꞌha raꞌ ba hasta zuu Jesuhs, ya chin badiaaꞌha raꞌ ba loh Ñiꞌh, chiꞌchi guleꞌhe Ñiꞌh tuhbi cweenta nin ruluuꞌyi, rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Biriaꞌh tuhbi bwiinn zeegatiꞌchi ba xpiñih ba. Ya gaduhbi cagatiꞌchi ban biaaba nuhnan loh neziuh, lwehgu bazuꞌñaaꞌ bwiinn raꞌ yihcaraꞌn ya gudahw gahcaza maaniꞌhnraꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ya snuhnan biaaba lahda dxiah hasta nuu gulliaꞌ yuh, ya chin gutahnnan, lwehgu gahca gubihdzin laasii ayi guyuuꞌ xcohpa riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ya snuhnan biaaba laꞌn yaguihchi, ya gutahneeꞌhen yaguihchi raꞌ chi ya ayi basaaꞌn yaguihchi raꞌ chi ñirooꞌhon niꞌchin nin ayi xi guyuuꞌ lohon. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ya snuhnan biaaba loh yuh zaꞌca, niꞌchiyi gurooꞌ guhcan, pur tuhbin guhcan tuhbi gaywaꞌh llooba. Ya chin guyaꞌloh guñiꞌ Jesuhs niꞌchi, chiꞌchi guñiꞌ Ñiꞌh jweersi loh raꞌ bwiinn, rahbi Ñiꞌh: ―Sidela riuuꞌ tu riaꞌzi tu dxyiꞌdxyi raꞌ riiꞌ, gulgacaꞌdxiahgan. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ya chiꞌchi gunaabadxyiꞌdxyi xpwiinn Ñiꞌh loh Ñiꞌh xiñin guñiꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Dxiohs gahca rñiꞌ loh tu tin gacabwaꞌ tu cohsa raꞌ xteenn xquelrnabwaꞌ Ñiꞌh. Ya cohsa raꞌ chi ayi guiñiꞌnayaa Ñiꞌhn loh raꞌ bwiinn. Niꞌchin cweenta raꞌ si rñiꞌn loh raꞌ bwiinn tin gwaꞌha raꞌ ba per ayi gacabwaꞌ raꞌ ba; dxihn raꞌ ba per ayi gaann raꞌ ba xiñin. Rahbiza Jesuhs: ");
INSERT INTO zpvNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","―Deeꞌ naa nin rñiꞌ cweenta nin guñiꞌn loh raꞌ bwiinn. Biñih raꞌ chi naa ziga xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ya biñih nin biaaba loh neziuh niꞌchi naa ziga bwiinn nin bacaꞌdxiahga xchiꞌdxyi Dxiohs per ayi guyaꞌzi dxyiꞌdxyi chi lastoꞌ raꞌ ba laasii naguihdzin lwehgu zeꞌ bwiinndxaaba mahziru rusiaꞌpitii ban tin para ayi chechiistoꞌ raꞌ ba dxyiꞌdxyi chi nee ayi taꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya biñih nin biaaba lahda dxiah hasta nuu gulliaꞌ yuh, niꞌchi naa ziga bwiinn nin bacaꞌdxiahga xchiꞌdxyi Dxiohs, gucaꞌha raꞌ ban cun guuxta zezahnee raꞌ ban paaldaa dxyih. Ya chin rzahcazii raꞌ ba saca rianaꞌhla raꞌ ba dxyiꞌdxyi chi, mejor rbweꞌhehestoꞌ raꞌ ban laasii ayi nahpa raꞌ ba dulbaaꞌ chaꞌyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ya biñih nin biaaba laꞌn yaguihchi, niꞌchi naa ziga bwiinn nin bacaꞌdxiahga xchiꞌdxyi Dxiohs, ya chin zee raꞌ ba loh neziuh ruhnnxaꞌta raꞌ ba lligaaba xtsiꞌn raꞌ ba nee cohsa zaꞌca nin xclaaꞌdzi raꞌ ba guicaꞌha raꞌ ba, nee loh nasaa nabahan raꞌ ba. Pur lligaaba raꞌ chi niꞌchin ayiru xclaaꞌdzi raꞌ ba guunn raꞌ ba dziꞌn nin xclaaꞌdzi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ya biñih nin biaaba loh yuh zaꞌca niꞌchi naa ziga bwiinn nin bacaꞌdxiahga xchiꞌdxyi Dxiohs ya bwiinn chi rcaꞌha ban gaduhbi stoꞌ ba. Ayi chuu dxyih gusaaꞌn raꞌ ban. Cun paseensi zezah raꞌ ba xneziuh Dxiohs. Bwiinn raꞌ chi naa ziga tuhbi yahga ninahxi nin rcah tuhbi cwaꞌh ninahxi zaꞌca loh ñiꞌh. Rahbiza Jesuhs: ");
INSERT INTO zpvNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","―Ayi tuhbi nin gucaꞌdxih tuhbi biaꞌñih ralaꞌn o dxieꞌw yihcan, ayiza nin cuꞌtiiꞌhin llaaꞌn tuhbi luꞌhn. Mejor guzaꞌbi luꞌhn guiyaꞌ guziaꞌñihin tin nin chuꞌtii rwaaꞌ yihdzi luꞌh gwaꞌha zaꞌca raꞌ ba biaꞌñih chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ziꞌchi gahcaza garaa nin ñieꞌw loh Ñiꞌh nahpa guillaalan tin gwaꞌha raꞌ ba xiñin, nee garaa nin nuulaꞌn nahpa gwaꞌha raꞌ ba xiñin tin dxiuꞌnbwaꞌ raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ya ziꞌchi gahca gulgacaꞌdxiahga zaꞌca tin garaa bwiinn nin rahcabwaꞌ xchiꞌdxyi Dxiohs, mahziru gudiꞌhi Ñiꞌh guelrahcabwaꞌ laꞌh raꞌ ba. Ya laꞌh raꞌ nin ayi rucaꞌdxiahga xchiꞌdxyi Dxiohs, zusiaꞌpitii Ñiꞌh dxyiꞌdxyi nin nuu stoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chiꞌchi badzihn xmah Jesuhs cun bwihtsi raꞌ Ñiꞌh hasta cagaluuꞌyi Ñiꞌh, per ayi guhca ñabiiga raꞌ ba cweeꞌ Ñiꞌh laasii dxiꞌbi ziahan bwiinn rii riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chiꞌchi gwaguihtsi bwiinn loh Jesuhs, rahbi raꞌ ba: ―Xmah luꞌh cun bwihtsi raꞌ luꞌh rii raꞌ dihtsi yuuꞌ, xclaaꞌdzi raꞌ ba gwaꞌha raꞌ ba yiꞌh tin guiñiꞌ raꞌ ba loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinn chi: ―Ayi laꞌsi dxiꞌh raꞌ ba naa bwiinn lasaaꞌhahn, sino que nee garaa raꞌ bwiinn nin riuuꞌ riaꞌzi xchiꞌdxyiꞌhn nee guzoꞌbadxiahga raꞌ ban bwiinn chi naa xmaaꞌn cun bwiitsiraꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Guyuuꞌ tuhbi dxyih guyuꞌtii Jesuhs laꞌn tuhbi laancha cun xpwiinn Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulchoꞌho choo nuꞌh stuhbi lahdu rwaaꞌ ñihsa ca. Ya chiꞌchi zee raꞌ ba tuhbi loh ñihsa. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ya gaduhbi zeediiꞌdxi raꞌ ba galaayi loh ñihsa chi, guhtaꞌllgahsi Jesuhs. Hohrchi guzoꞌbaloh tuhbi bwih rooꞌ loh ñihsa nez zee raꞌ ba, ya guzoꞌbaloh guteesa ñihsa chi laꞌn laancha amwer ñizaꞌbigueeꞌlan ñihsa. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ya chiꞌchi gwah xpwiinn Jesuhs hasta naꞌllgahsi Ñiꞌh, ya bacwaꞌhn raꞌ ba laꞌh Ñiꞌh, rahbi raꞌ ba: ―¡Mwehsu, Mwehsu, babahn! ¡Amweer laꞌnuꞌh saꞌbigueeꞌla ñihsa! Chiꞌchi lwehgu gwastii Jesuhs, guñiꞌ Ñiꞌh loh bwih chi cun loh ñihsa tin cweezan. Ya lwehgu gahca guridxyii raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ya chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―¿Xixnaa ayi riachiistoꞌ tu Dxiohs tin gacanee Ñiꞌh laꞌh tu? Ya laꞌh raꞌ ba bidxyihbi duxa raꞌ ba neezaa badxyigaaꞌloh raꞌ ba laꞌh Jesuhs, ya gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Chyuulla naa bwiinn riiꞌ? ¡Hasta bwih cun ñihsa rnabwaꞌ ba nee rzohbadxiahga raꞌn xchiꞌdxyi ba! ");
INSERT INTO zpvNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ya chin badzihn raꞌ ba loh yuh xteenn Gadara nin rii stuhbi lahdu rwaaꞌ ñihsa xteenn Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","chiꞌchi bariaꞌh Jesuhs laꞌn laancha tin guzuh Ñiꞌh loh yuh, chiꞌchi gwabiiga tuhbi bwiinn guihdxyi chi. Bwiinn chi guhcala xchih nuu bwiinndxaaba stoꞌ ba. Ayi guhta ba lahdxi ayiza guyuuꞌ ba laꞌñuuꞌ sino que puura lahda raꞌ baꞌ guyuuꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ya chin bwaꞌha ba laꞌh Jesuhs, bazuꞌnllihbi ba nez loh Ñiꞌh guñiꞌ ba jweersi, rahbi ba: ―¿Xix zeꞌchuu luꞌh riiꞌ, Jesuhs Lliiꞌn Dxiohs nin nuu nabahandziꞌtsi dxibaaꞌ? ¡Rdxiꞌhnaꞌhn loh luꞌh ayi gusaꞌcazii luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Guñiꞌ bwiinndxaaba nin nuu stoꞌ bwiinn chi dxyiꞌdxyi riiꞌ laasii canabwaꞌ Jesuhs laꞌh ba, tin gariaꞌh ba tihxi bwiinn chi. Ziahanla behsa rdzihtanee bwiinndxaaba chi laꞌh prohbi bwiinn chi tin mahziru sahcazii ba, ya guhcaduꞌh ba cun cadehn biyiꞌbidziꞌtsi naa ba cun ñaaꞌ ba cun dxiꞌba raꞌ nin rchiꞌbi suldahdu naa bwiinn, per laꞌh ba bachyuuꞌga ban pur xquelnadxipa bwiinndxaaba nin nuu stoꞌ ba ya bwiinndxaaba chi guleꞌcaa laꞌh ba zihtu hasta ayi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh bwiinndxaaba chi, rahbi Ñiꞌh: ―¿Chyu laa luꞌh? Chiꞌchi rahbi ba: ―Legiohn. Squii rahbi ba laasii ziahan bwiinndxaaba guyuꞌtii stoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ya bwiinndxaaba raꞌ chi gunaaba loh Jesuhs ayi guixeꞌhla Ñiꞌh laꞌh raꞌ ba gabihldxyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ya riꞌchi riiyahw ziahan raꞌ cuuchi loh dahan chi gahxu nez rii raꞌ ba, ya gudxiꞌhn raꞌ bwiinndxaaba raꞌ chi tin gusaaꞌn Jesuhs chuꞌtii raꞌ ba laꞌn raꞌ ma. Ya chin guziꞌguehlda Jesuhs guunn raꞌ bwiinndxaaba chi ziꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","chiꞌchi bariaꞌh raꞌ ba stoꞌ bwiinn chi chiꞌchi biuuꞌgarii raꞌ ba laꞌn cuuchi raꞌ chi. Ya chin guyuꞌtii raꞌ bwiinndxaaba chi laꞌn raꞌ ma, chiꞌchi balluꞌn raꞌ ma gwatsiꞌbiloh raꞌ ma rwaaꞌ tuhbi bataaꞌha caa tuhbi gueeꞌla, ya riꞌchi gwaaꞌñihsa raꞌ ma guhchi raꞌ ma. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ya chin bwaꞌha raꞌ nin cayahpa laꞌh raꞌ ma niꞌchi bidxyihbi duxa raꞌ ba lwehgu balluꞌn raꞌ ba tin gwaguihtsi raꞌ ba loh bwiinn guihdxyi cun bwiinn rrandxu raꞌ xcweenta nin guzahca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chiꞌchi biriaꞌh raꞌ bwiinn Gadara neezaa bwiinn guihdxyi raꞌ nin rii nehzchi zeeguiaꞌha raꞌ ba nin guhca loh dahan chi. Ya chin badzihn raꞌ ba nez hasta zuu Jesuhs, bwaꞌha raꞌ ba laꞌbwiinn nin bariaꞌh bwiinndxaaba raꞌ stoꞌ ñiꞌh laꞌba zohba hasta zuu ñaaꞌ Jesuhs, nahcu ba lahdxi ayi xi rahcaru yihca ba, ya bwiinn raꞌ nin bwaꞌha raꞌ niꞌchi bidxyihbiza raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ya bwiinn raꞌ nin bwaꞌhaloh xa guhca, bwiiꞌyidxyiꞌdxyi raꞌ ba xa babweꞌhe Jesuhs bwiinndxaaba raꞌ stoꞌ bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chiꞌchi garaa raꞌ bwiinn Gadara neezaa raꞌ bwiinn guihdxyi nin rii nezchi, gunaaba raꞌ ba dxiuꞌnehza Jesuhs riꞌchi laasii cadxyihbi duxa raꞌ ba. Niꞌchin nin biuꞌgarii Jesuhs laꞌn laancha chi tin gubiaꞌgarii Ñiꞌh nez hasta zeꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Cun nee bwiinn nin bariaꞌh bwiinndxaaba raꞌ stoꞌ ñiꞌh gunaaba ba loh Jesuhs siꞌguehlda Ñiꞌh chenee ba laꞌh Ñiꞌh, per gunabwaꞌ Jesuhs dxiaꞌhansi ba, rahbi Ñiꞌh loh ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Babiaꞌgarii rwaaꞌ yihdzi luꞌh tin batiꞌchi dxyiꞌdxyi loh lasaaꞌ raꞌ luꞌh xcweenta garaa nin bwiꞌhnnaꞌhn pur yiꞌh. Chiꞌchi ziaa ba, batiꞌchi ba dxyiꞌdxyi loh gaduhbi guihdxyi chi pur bwen nin bwiꞌhnn Jesuhs laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ya chin babiaꞌgarii Jesuhs stuhbi lahdu rwaaꞌ ñihsa, chiꞌchi bagahpaDxiohs bwiinn raꞌ nin riibweeza laꞌh Ñiꞌh nez chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chiꞌchi badzihn tuhbi bwiinn nin laa Jairu loh Jesuhs, bwiinn chi rnabwaꞌ tuhbi guidoꞌ biꞌtuꞌhn nin nuu guihdxyi chi, ya bazuꞌnllihbi ba nezloh Jesuhs, bwiꞌhnn nalaasa loh ba gunaaba ba chenee ba Jesuhs yihdzi ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","laasii tuhbidxiꞌh lliiꞌndxaꞌpa ba nuu. Nuu bi tsiꞌh bichiohpa yihza, per cayahcalluꞌhu bi, amwer gachi bi. Ya loh nin zeenee Jesuhs laꞌh Jairu para yihdzi ba, ziahanrooꞌza bwiinn zee gadiidxi Ñiꞌh hasta dxiigah bateꞌhe raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Loh raꞌ ba dxaꞌga tuhbi gunnaꞌh nin rahcalluꞌhu. Guhcala tsiꞌh bichiohpa yihza cagasahcazii gueldxyihdxyi laꞌh bi. Lliaaꞌzi bañihchi bi garaa xmweeyi bi gucaꞌha raꞌ nin ruhnn rramwehdxi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ya gwabiiga gunnaꞌh chi dihtsi Jesuhs tin bidxiꞌ bi loh xahba Ñiꞌh, hohrchigahca lwehgu biaca bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chiꞌchi gunaabadxyiꞌdxyi Jesuhs, rahbi Ñiꞌh: ―¿Chyuniꞌca bidxiꞌ naꞌh? Ya garaa raꞌ ba rahbi raꞌ ba: ―Nin tuhbi nu. Chiꞌchi rahbi Pehdru loh Jesuhs: ―Mwehsu, bwiinn raꞌ rgoꞌbañuh xahba luꞌh, rcaꞌnaa gahca raꞌ ba yiꞌh; ¿xi para guinaabadxyiꞌdxyi luꞌh: “Chyuniꞌca bidxiꞌ naꞌh”? ");
INSERT INTO zpvNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Per rahbilagaꞌh Jesuhs: ―Nuu tuhbi bwiinn nin bidxiꞌ naꞌh laasii guhcabwaꞌn basiaca xquelrnabwaꞌn laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ya chin guhcabwaꞌ gunnaꞌh chi laꞌJesuhs naann bidxiꞌ bi xahba Ñiꞌh, chiꞌchi bidxyihbi bi gwabiiga bi guzaꞌloh xchihchi bi, bazuꞌnllihbi bi nez ñaaꞌ Ñiꞌh, tin guhdzi bi delaanta loh raꞌ bwiinn bidxiꞌ bi laꞌh Ñiꞌh nee hohrachi gahca biaca bi gueldxyihdxyi nin rahca bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chiꞌchi rahbi Jesuhs: ―Xiiꞌhihn, guhca basiaꞌcahn yiꞌh pur gwachiistoꞌ luꞌh naꞌh. Bwaa nnah, gulahchidxyiistoꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Gaduhbi cañiꞌ gahca Jesuhs niꞌchi badzihn tuhbi bwiinn nin zeꞌ rwaaꞌ yihdzi Jairu, rahbi ba loh Jairu: ―Laꞌlliiꞌndxaꞌpa luꞌh guhchila; ayiru gucweꞌza luꞌh xtsiꞌn Daada Mwehsu ca. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ya chin bihn Jesuhs niꞌchi, rahbi Ñiꞌh loh Jairu: ―Ayi guidxyihbi luꞌh todes chechiistoꞌ luꞌh naꞌh ziaca lliiꞌn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ya chin badzihn raꞌ ba rwaaꞌ yihdzi Jairu, ayi basaaꞌn Jesuhs ñuꞌtii garaa raꞌ bwiinn; Pehdru si cun Jacobo cun Jwahn cun xpaah dxaꞌpa chi cun xmaah bi guyuꞌtii raꞌ ba laꞌñuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Garaa raꞌ bwiinn nin rii rwaaꞌ yuuꞌ chi riiyuꞌn raꞌ ba pur laꞌh bi. Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ayi ruꞌn tu; naꞌllgahsizi bi, ayi guhchidxiꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ya sola ballihdzinee raꞌ ba laꞌh Jesuhs laasii naann raꞌ ba guhchi bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chiꞌchi gunaꞌzu Jesuhs naa bi, guñiꞌ Ñiꞌh jweersi, rahbi Ñiꞌh: ―¡Dxaꞌpwiꞌhn, gwastii! ");
INSERT INTO zpvNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hohrchi gahca babiaꞌgarii xquelnabahan bi ya gwastii bi, guzohba bi. Chiꞌchi gunabwaꞌ Jesuhs gudiꞌhi raꞌ ba xi gahw bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ya xpaah bi cun xmaah bi badxyigaaꞌ duxa loh raꞌ ba per gunabwaꞌ Jesuhs ayi chyulootiiꞌ guuyi raꞌ ba cohsa nin guhca riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ya batiaaꞌha Jesuhs gadziꞌh bichiohpa xpwiinn Ñiꞌh tin badiꞌhi Ñiꞌh guelrnabwaꞌ laꞌh raꞌ ba tin gabweꞌhe raꞌ ba bwiinndxaaba raꞌ nin nuu stoꞌ bwiinn raꞌ neezaa gusiaca raꞌ ba bwiinn raꞌ nin rahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Neezaa guxeꞌhla Ñiꞌh laꞌh raꞌ ba tin guluuꞌyi raꞌ ba laꞌh raꞌ bwiinn laꞌh hohra bigaꞌha guinabwaꞌ Dxiohs laꞌh raꞌ ba nee gusiaca gahca raꞌ ba bwiinn raꞌ nin rahcalluꞌhu xichiꞌhzi gueldxyihdxyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Neezaa rahbi Ñiꞌh loh raꞌ ba: ―Ayi xi chenee tu loh nehza, nin buxtohn nin buxa nin guehta nin mweeyi. Ayiza chenee tu chiohpa nehza xahba tu; nin nahcusi tu chenee tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nee cuunchiꞌhzi yihdzi bwiinn nin gadzihn tu riꞌchi guldxiaꞌhan hastayi gadzihn dxyih gariaꞌh tu guihdxyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ya guihdxyi nin ayi guunn cweenta raꞌ ba xchiꞌdxyi tu, talguꞌnsi gariaꞌh tun per tsiibixgah tu tahba tu tin niꞌchi gaca tuhbi sehn guyuuꞌ xtuhlda raꞌ ba pur ayi gunah raꞌ ba ñucaꞌdxiahga raꞌ ba xchiꞌdxyi Dxiohs nin ruluuꞌyi tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chiꞌchi gunaꞌzunehza raꞌ ba guriin-guriinn guihdxyi, tin zegaluuꞌyi raꞌ ba xchiꞌdxyi Dxiohs nee cun zegasiaca gahcaza raꞌ ba bwiinn raꞌ nin rahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chin gudiiꞌdxidxiahga gobernador Herodes garaa nin cayuhnn Jesuhs, bicheꞌh ba ayi guhcabwaꞌ ba xa ñuhnn ba lligaaba laasii riiñiꞌ nuhn bwiinn rahbi laꞌguehtu Jwahn nin baroꞌbañihsa babahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ya snuhn raꞌ ba riiñiꞌ rahbi laꞌguehtu Elías baluuꞌyiloh lagaꞌh, ya snuhn raꞌ ba rahbi niꞌca naa stuhbi guehtu daada nin guñiꞌ xchiꞌdxyi Dxiohs caachieemparooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ya chiꞌchi rahbi Herodes: ―Naꞌh gahca gunabwaꞌn birwaꞌha yihca Jwahn. ¿Chyuulla niꞌca chiꞌh riigazeꞌta raꞌ bwiinn raꞌ ca? Ya zeezah cadxiꞌhyi ba xa guiaꞌha ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ya chin babiaꞌgarii raꞌ xpwiinn Jesuhs, chiꞌchi bwiiꞌyidxyiꞌdxyi raꞌ ba garaa nin bwiꞌhnn raꞌ ba nez gwah raꞌ ba. Chiꞌchi dxyigahsi biahchinee Ñiꞌh laꞌh raꞌ ba nez ayi chyu bwiinn nuuꞌ gahxu nez riaꞌhan guihdxyi nin laa Betsaida. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ya chin gudiiꞌdxidxiahga raꞌ bwiinn zee raꞌ ba nezchi, bagadxiꞌhyi raꞌ ba laꞌh Ñiꞌh hasta que no badxeela raꞌ ba laꞌh Ñiꞌh, ya chiꞌchi bagaꞌpaDxiohs Jesuhs laꞌh raꞌ bwiinn chi, tin guzaꞌloh cayuuꞌyidxyiꞌdxyi Ñiꞌh loh raꞌ ba xcweenta ziga guinabwaꞌ Dxiohs, ya basiaca gahca Ñiꞌh laꞌh raꞌ bwiinn nin rahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ya chin guhca gudxyih, gwabiiga gadziꞌh bichiohpa xpwiinn Ñiꞌh, ya rahbi raꞌ ba loh Ñiꞌh: ―Baxeꞌhla bwiinn raꞌ ca guziaa raꞌ ba rraandxu o laꞌn guihdxyi raꞌ tin nezchi chiꞌhyi raꞌ ba hasta dxiaꞌhan raꞌ ba nee guidxeela gahca raꞌ ba nin gahw raꞌ ba tin hasta dxuu nuꞌh riiꞌ ayi xi nuutiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh chi: ―¡Laꞌh tu gulgadiꞌhi nin gahw raꞌ ba! Ya rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Ayi chyu nahpa xi gahw raꞌ ba, ñaꞌsi zagaꞌyu dxiꞌh pahn cun schiohpa bwehlda nuuꞌ, ¿cayixchiꞌh chosiꞌ nu nin gahw bwiinn ziahan raꞌ ca? ");
INSERT INTO zpvNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ziꞌchi rahbi raꞌ ba laasii bwaꞌha raꞌ ba ziga gaꞌyu mihyi naa raꞌ bwiinn raꞌ chi, chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Gulcwahchixnehza raꞌ ba chywaꞌh bitsiꞌhgah raꞌ ba loh cada tuhbigah cwaꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ya ziꞌchi bwiꞌhnn raꞌ ba tin guzohbaxnehza garaatiiꞌ raꞌ bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ya chiꞌchi gucaꞌha Jesuhs gagaꞌyu pahn chi cun garoopa bwehlda, ya guteesa loh Ñiꞌh nez guiyaꞌ tin badiꞌhi Ñiꞌh guelzuxchilli loh Dxiohs pur guelwahw chi. Ya chiꞌchi gutaaꞌha Ñiꞌhn badiꞌhi Ñiꞌhn laꞌh raꞌ xpwiinn Ñiꞌh tin gudxiꞌzi raꞌ ban loh raꞌ bwiinn ziahan raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ya gudahw garaa raꞌ ba hasta gwadxah raꞌ ba hasta ayi gunahru raꞌ ba ñahw raꞌ ba. Ya chin guyaꞌloh gudahw raꞌ ba, batiaaꞌha raꞌ xpwiinn Jesuhs nin biaꞌhancah chi, ya guhcan tsiꞌh bichiohpa tipi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tuhbi dxyih gaduhbi cabwihdxyi-canaaba Jesuhs loh Dxiohs tuhsi Ñiꞌh badzihn raꞌ xpwiinn Ñiꞌh, chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh loh raꞌ ba, rahbi Ñiꞌh: ―¿Chyuniꞌca rahbi raꞌ bwiinn naan? ");
INSERT INTO zpvNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Nuhn raꞌ bwiinn rahbi yiꞌh naa luꞌh Jwahn nin ruroꞌbañihsa laꞌh raꞌ bwiinn, ya snuhn raꞌ ba rahbi yiꞌh naa luꞌh guehtu Elías nin guñiꞌ xchiꞌdxyi Dxiohs cachieemparooꞌ, ya snuhn raꞌ ba rahbi yiꞌh naa luꞌh stuhbi guehtu daada nin guñiꞌ xchiꞌdxyi Dxiohs cachieempa. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh loh raꞌ ba, rahbi Ñiꞌh: ―Ya laꞌhaxchiꞌh tu, ¿xi nah tu chyu naꞌh? Chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Yiꞌh nin naa luꞌh Crixtu Lliiꞌn Dxiohs nin dxuleꞌza nu. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ya chiꞌchi gunabwaꞌ Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―Nin guiñaan loh tu ayi guuyi tun loh nin tuhbi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ya chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw. Nahpa zutiꞌdxiloon trabahjw duxa; zusahcaloh bwiinnguuhla raꞌ nin rnabwaꞌ guidoꞌ xteenn Jerusalehn loon, neezaa bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza, neezaa bwiinn raꞌ nin ruluuꞌyi xlehyi Moisehs zibweꞌhestoꞌ raꞌ ba naꞌh, guuyi raꞌ ba ayi naꞌh dxiꞌhn naan Crixtu nin cabweeza tu. Zidxiinn raꞌ ba naꞌh per zabahnaꞌhn chin dxiohnna dxyih guhchiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chiꞌchi rahbi Ñiꞌh loh garaa raꞌ bwiinn: ―Sidela chyuulla tuhbi tu xclaaꞌdzi dxieꞌnaꞌhla naꞌh nahpa dxiaꞌldastoꞌ tu garaa xixteenn tu nee xigaaba nin ruhnn tu, tin guillii-guillii nin guiñaansihn guunn tu nee gaca tu zigazi tuhbi bwiinn nin babadzihn hohra gachi, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","laasii nin xclaaꞌdzi xquelnabahan ñiꞌh zuñihchi ban chin gabwihxchih guidxyiyuh stuhbi; ya nin guñihchisi xquelnabahan ñiꞌh xcweenta xchiꞌdxyiꞌhn bwiinn chi zahpa ba guelnabahan nacuubi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nicala garaa cohsa nin lasahca nin nuu loh guidxyiyuh riiꞌ guicaꞌha tuhbi bwiinn per sidela ayi guunn cweenta ba xchiꞌdxyiꞌhn mahs gueeta gabihldxyi guzee ba nee nicala cohsa ziahan chi gohpa ba ayi galluꞌyin laasii ayi bwiꞌhnn ba cweenta xchiꞌdxyi Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","laasii bwiinn nin ratuhyi loh ñiꞌh pur naꞌh nee xcweenta xchiꞌdxyiꞌhn, zatuhyiza loon laꞌh ba chin gabiaꞌgariin stuhbi ziga tuhbi Rehyi cun gaduhbi xquelrnabwaꞌ xteenn xtaaꞌdahn cun ziahan xaanjla Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","nee guchiin nin rñiꞌn loh tu, nuu bwiinn nin dxaꞌga loh tu nahpa zwaꞌha raꞌ ba gadzihn xquelrnabwaꞌ Dxiohs antes que gachi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ziga xuhnna dxyih gudiiꞌdxi chin guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi gwanee Ñiꞌh Pehdru cun Jwahn cun neezaa Jacobo gucah raꞌ ba yihca tuhbi dahan tin cwidxyi-guinaaba Jesuhs Xtaada Dxiohs Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ya gaduhbi cabwihdxyi-canaaba Ñiꞌh laꞌh Xtaada Dxiohs Ñiꞌh, baluuꞌyiloh guriin xñah Ñiꞌh nee xahba Ñiꞌh biahca labwehen ya gucabachaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ya hohrachi gahca baluuꞌyiloh chiohpa Daada raꞌ nin cayuuꞌyidxyiꞌdxyinee laꞌh Ñiꞌh ya daada raꞌ chi naa guehtu Moisehs cun Elías. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ya Daada raꞌ chi guhca bachaꞌhza raꞌ ba, ya rahbi raꞌ ba loh Jesuhs xcweenta nin gachi Ñiꞌh loh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ya Pehdru cun schiohpa lasaaꞌ ba basiꞌnaaꞌhan bacaꞌlda laꞌh raꞌ ba. Ya chin badiꞌchi bacaꞌlda loh raꞌ ba, bwaꞌha raꞌ ba rcaꞌbachaꞌha Jesuhs cun garoopa raꞌ daada nin cayuuꞌyidxyiꞌdxyinee laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ya chin guhlda hohra nin laꞌh daada raꞌ chi dxiuꞌnehza, chiꞌchi rahbi Pehdru: ―Mwehsu, bwen duxa dxuu nuꞌh riiꞌ. Basaaꞌn guidiꞌnnchaꞌyi nu chohnna yuuꞌ biꞌtuꞌhn: tuhbin gaca xteenn yuꞌbiluꞌh, stuhbin gaca xteenn Moisehs, ya stuhbin gaca xteenn Elías. Ziꞌchi guñiꞌ Pehdru laasii ayi gaann ba xiñin guñiꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ya gaduhbi cañiꞌ Pehdru niꞌchi, guzaꞌbi tuhbi xcahyi nez yihca raꞌ xpwiinn Jesuhs chi ya biaꞌpa raꞌ ba laꞌn xcahyi chi hohrchigahca bidxyihbi duxa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ya chiꞌchi bihn raꞌ ba tuhbi rsiaaꞌha nin guñiꞌ laꞌn xcahyi chi: ―Dee naa Lliiꞌnahn nin nadziiꞌhihn; gulgacaꞌdxiahga xchiꞌdxyi bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ya chin guyaꞌloh bihn raꞌ ba dxyiꞌdxyi raꞌ chi, bwaꞌha raꞌzi ba tuhsila Jesuhs zuu riꞌchi. Ya guluꞌchaꞌyisi raꞌ ba dxyiꞌdxyi raꞌ chi laꞌn lastoꞌ raꞌ ba, ya ayi chyulootiiꞌ bwiiꞌyidxyiꞌdxyi raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ya chin barah gueꞌla biehta raꞌ ba rwaaꞌ dahan chi, ya ziahanrooꞌ bwiinn raꞌ riibweeza laꞌh Jesuhs; ");
INSERT INTO zpvNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ya lahda bwiinn raꞌ chi dxaꞌga tuhbi ndxiꞌhw nin guñiꞌ jweersirooꞌ, rahbi ba: ―Mwehsu, balahsastoꞌ luꞌh naꞌh gudaaꞌ guiaꞌha luꞌh lliiꞌnahn laasii tuhbidxiꞌh laꞌh bi naa lliiꞌngaꞌnaꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","tin gwaꞌha luꞌh naꞌzu tuhbi bwiinndxaaba lastoꞌ bi hasta rusacwidxyidxiah ba laꞌh bi, rahca bi ziga gueldxyihdxyirachiaaꞌ rbweꞌhe ba bitsiꞌhn rwaaꞌ bi hasta dxyigah rulluꞌlla ba laꞌh bi nee guillii-guillii ruhnnee ba laꞌh bi ziꞌchi ayi rutaꞌh ba laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Laꞌn gunaꞌbala loh xpwiinn raꞌ luꞌh tin ñabweꞌhe raꞌ ba laꞌh bwiinndxaaba chi stoꞌ bi, per ayi ruhnn raꞌ ba gahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinn chi: ―¡Ayi, bwiinn raꞌ nin ayi riachiistoꞌ ñiꞌh, bwiinn naxihn! ¿Balaaca chiꞌhlla chuꞌneꞌhn laꞌh tu tin gazuhllaꞌñiihn yihca tu? ¿Balaaca chiꞌhlla nin guꞌnnahn waanta loh tu? Chiꞌchi rahbi Ñiꞌh loh xtaada biꞌnxtuhbi chi: ―¡Gudaꞌnee lliiꞌn luꞌh riiꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ya chin zebiiga biꞌnxtuhbi chi loh Jesuhs, gudxindxiah bwiinndxaaba chi laꞌh bi loh yuh guzaꞌloh canaꞌzu gueldxyihdxyirachiaaꞌ chi laꞌh bi chiꞌchi gunabwaꞌ Jesuhs loh bwiinndxaaba chi tin bariaꞌh ba stoꞌ bi, ya lwehgu gahca biaca bi, chiꞌchi badiꞌhi Ñiꞌh laꞌh bi laꞌh xtaada bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ya gallee raꞌ bwiinn nin rii riꞌchi badxyigaaꞌ duxa loh raꞌ ba pur nin bwiꞌhnn Jesuhs, guhca babweꞌhe Ñiꞌh bwiinndxaaba stoꞌ bwiinn chi. Ya gaduhbi nin riiyadxyigaaꞌ raꞌ bwiinn pur dziꞌn rooꞌ nin bwiꞌhnn Jesuhs, rahbi gahca Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gulgacaꞌdxiahga zaꞌca garaa deeꞌ, gulchuuꞌ gulchaꞌzi dxyiꞌdxyi raꞌ riiꞌ. Naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw per ziuuꞌ nin gutooꞌ naꞌh loh raꞌ bwiinn guihdxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per laꞌh raꞌ ba ayi guhcabwaꞌ raꞌ ba xiñin zeꞌ loh dxyiꞌdxyi raꞌ chi laasii ayi basaaꞌn Dxiohs ñahcabwaꞌ raꞌ ba xiñin; ya bidxyihbi za raꞌ ba ñinaabadxyiꞌdxyi raꞌ ba xii zeꞌ loh dxyiꞌdxyi raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ya chiꞌchi guzaꞌloh riiñiꞌ raꞌ xpwiinn Ñiꞌh cuun nin mahzi lasahca loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Per Jesuhs talguꞌnsi guhcabwaꞌ Ñiꞌh lligaaba nin nuu raꞌ ba. Chiꞌchi gucaꞌha Ñiꞌh tuhbi biñiꞌn biꞌtuꞌhn bazuh Ñiꞌh cweeꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Chyuchiꞌhzi bwiinn nin nadziiꞌhi laꞌh biñiꞌn riiꞌ xcweeꞌntahn nadziiꞌhi gahcaza ba naꞌh, ya sidela nadziiꞌhi ba naꞌh, neezaa xtaaꞌdahn nin guxeꞌhla naꞌh nadziiꞌhi ba. Nin mahzi nadoꞌlaaꞌdzi loh tu, niꞌchi mahzi lasahca. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chiꞌchi rahbi Jwahn loh Ñiꞌh: ―Mwehsu, bidiaꞌha nu loh tuhbi bwiinn nin rabweꞌhe bwiinndxaaba stoꞌ raꞌ bwiinn cun xquelrnabwaꞌ lah luꞌh, ya bachidiꞌtsi nu loh ba ayiru guunn ba ziꞌchi laasii ayi needxiꞌh ba caꞌnzaa ba loh nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chiꞌchi rahbi Jesuhs: ―Gulgasaaꞌn bwiinn nin ayi rñiꞌyah laꞌh nuꞌh, tin bwiinn chi xlahdu gahca nuꞌh nuu ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya chin zeꞌgadzihn dxyih gacah Jesuhs dxibaaꞌ, chiꞌchi zee Ñiꞌh guihdxyi Jerusalehn, ya ayi bidxyihbitiiꞌ Ñiꞌh cun nin gutiꞌdxiloh Ñiꞌh riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ya seguihdu guxeꞌhla Ñiꞌh paaldaa xpwiinn Ñiꞌh delaanta tin chee raꞌ ba tuhbi guihdxyiꞌhn xteenn Samaria chechiꞌhyi raꞌ ba canehza dxiaꞌhan raꞌ ba riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ya bwiinn samaritana raꞌ chi ayi guclaaꞌdzi raꞌ ba ñuꞌtinee Jesuhs xpwiinn Ñiꞌh lahda raꞌ ba laasii naann raꞌba guzee Jesuhs cun xpwiinn Ñiꞌh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ya chin bwaꞌha Jacobo cun Jwahn niꞌchi, chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Daada, ¿ta xclaaꞌdzi luꞌh gachinabwaꞌ nu dxiaaba dxih llaaꞌn dxibaaꞌ tin ñihchiloh garaa raꞌ ba zigazi bwiꞌhnn guehtu Elías cachieempa chi? ");
INSERT INTO zpvNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chiꞌchi basiaꞌgariiloh Jesuhs tin bwaꞌha Ñiꞌh loh raꞌ ba tin gudxihldxyi Ñiꞌh laꞌh raꞌ ba, rahbi Ñiꞌh: ―¡Nin ayi gaann tu chyuniꞌca rñiꞌ laꞌn lastoꞌ tu niꞌchin nin rñiꞌ tu ziꞌca! ");
INSERT INTO zpvNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Guxeꞌhla Xtaaꞌdahn naꞌh loh guidxyiyuh, per ayi par guñihchiloodxiꞌhn bwiinn raꞌ sino que zeꞌldahn tin guhldaꞌhn laꞌh raꞌ ba loh duhlda. Chiꞌchi zee raꞌ ba stuhbi guihdxyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ya gaduhbi nin zee raꞌ ba loh neziuh, badzihn tuhbi bwiinn nin guñiꞌ loh Jesuhs, rahbi ba: ―Daada, naꞌh xclaaꞌdzihn dxieꞌldanaꞌhlaꞌhn yuꞌbiluꞌh nez chiꞌhzi guzee luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chiꞌchi rahbi Jesuhs: ―Bweeꞌzu nahpa raꞌ ma guiiꞌdxiu hasta riuuꞌ raꞌ ma, maaniꞌhn raꞌ nuu xpichieꞌza raꞌ ma, per naꞌh ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, nin hasta gucuꞌgaꞌhn ayi naꞌpahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ya chiꞌchi rahbi Jesuhs loh stuhbi bwiinn: ―Gudaꞌnaꞌhlasi naꞌh. Chiꞌchi rahbi bwiinn chi: ―Daada, mejor basaaꞌn guziaaꞌhahn tin chegacaꞌtsixgaꞌhn xpaaꞌhn, chiꞌchiyi dxieꞌldanaꞌhlaꞌhn yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chiꞌchi rahbi Jesuhs: ―Basaaꞌn gucaꞌtsi raꞌ bwiinnguuchi laꞌh raꞌ lasaaꞌ bwiinn guuchi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chiꞌchi rahbi stuhbi ba loh Jesuhs: ―Daada, naꞌh xclaaꞌdzihn dxieꞌnaꞌhlaꞌhn yuꞌbiluꞌh, per galoh gusaaꞌn luꞌh naꞌh guziaaꞌhahn tin cheguiꞌtsihn loh raꞌ lasaaꞌhahn yuꞌbiluꞌh dxieꞌldanaꞌhlaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chiꞌchi rahbi Jesuhs: ―Bwiinn nin rcah naa garradu ya gusiaꞌgariiloh ba nez dihtsi ba bwiinn chi ayi galluꞌyi guunn dziꞌn. Ziꞌchilla bwiinn nin dxieꞌnaꞌhla naꞌh gusiaꞌgariiloh ba nez dihtsi ba ayiza galluꞌyi ba gaca ba xpwiinn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ya chin guluhlla niꞌchi raꞌ, gulii Jesuhs zasetenta bwiinn raꞌ, chiꞌchi guxeꞌhla Ñiꞌh chiohpagah raꞌ ba cada tuhbigah guihdxyi cun lugahri raꞌ nez nahpa tiidxi Ñiꞌh despwehsi. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Guchiipaꞌca ba, cayahca duxa jusehchi per gulliaaꞌ naa raꞌ bwiinn nin guunn dziꞌn para gadiaaꞌha raꞌn raꞌ ban. Niꞌchin nin gulguinaaba loh ballwaaꞌn xteenn liꞌhn chi tin guixeꞌhla ba ziahanru bwiinn nin guunn dziꞌn gutiaaꞌha xliꞌhn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gulchee nnah, gulguiaꞌha xa rxeꞌhlaꞌhn laꞌh tu zigazi lliꞌhyi nin rxeꞌhlaꞌhn loh bweew raꞌ tin guunnee raꞌ ba laꞌh tu zigachiꞌhzi xclaaꞌdzi raꞌba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayi chenee tu manguchi mweeyi, ayiza chenee tu chiohpa nehza xahba tu nin xqueldxihdxyiza tu, nin ayiza guziꞌlaaꞌdzi tu caacazi tin ayi gugahpaDxiohs bwiinn laꞌh tu loh neziuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Chin chuꞌtii tu rwaaꞌ yihdzi tuhbi bwiinn, gahbi tu loh raꞌ ba: “Cwachidxyiistoꞌ bwiinn raꞌ nin rii riiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ya sidela naa ba tuhbi bwiinn nin rdxaꞌgastoꞌ ñiꞌh guelrbwidxyiistoꞌ, gulgasiaꞌhan guelrbwidxyiistoꞌ para bwiinn raꞌ chi per sidela ayi nnah raꞌ ba, zibiaꞌgarii xquelbachidxyiistoꞌ chi loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Guldxiaꞌhan gahca rwaaꞌ yihdzi bwiinn chi. Gulgahw nee gulgueeꞌ xiichiꞌhzi limentu nin guniꞌhi raꞌ ba tin nin ruhnn dziꞌn nahpa ba derehchu gahlla ba, ayi rii, riꞌchi rwaaꞌ yihdzi bwiinn chee tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nee cuunchiꞌhzi guihdxyi nin chuꞌtii tu dxieꞌgachiꞌloh raꞌ ba laꞌh tu, nee gulgahw ninchiꞌhzi guniꞌhi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ya gulgasiaca garaa raꞌ bwiinn nin rahcalluꞌhu riꞌchi gulgahbi gahca: “Bayinnah laꞌdxyih badzihn guinabwaꞌ Dxiohs bwiinn raꞌ nin xclaaꞌdzi chenaꞌhla laꞌh Ñiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ya sidela gadzihn tu tuhbi guihdxyi hasta ayi guiclaaꞌdzi raꞌ ba laꞌh tu, mahz chaꞌyi gariaꞌh tu nez loh neziuh, chiꞌchi gahbi tu: ");
INSERT INTO zpvNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hasta yuh nin gucah ñaaꞌ nu guidzihbi nun tin dxiaabaraꞌn, tin niꞌchi naa tuhbi sehn nin ayi guclaaꞌdzi tu ñihn tu xchiꞌdxyi nu. Gulgahcabwaꞌ deeꞌ, laꞌxquelrnabwaꞌ Dxiohs badzihn gahxu loh tu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Guchiin nin rñiꞌn loh tu, chin gaca xjwiisi Dxiohs mahziru nalaasa gacan loh guihdxyi riiꞌ que stuhbi guihdxyi nin laa Sodoma nin guyuuꞌ cadxyih. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Rahbiza Jesuhs: ―¡Prohbi laꞌh tu bwiinn guihdxyi Corazihn! ¡Prohbiza laꞌh tu bwiinn guihdxyi Betsaida! Sidela ñwaꞌha raꞌ bwiinnziitu nin gubahan guihdxyi Tiru cun Sidohn milahgru raꞌ nin bwiꞌhnnaꞌhn nez loh tu ñahca nalaasastoꞌ raꞌ ba pur xtuhlda raꞌ ba, nen nahpa ñazah raꞌ ba xneziuh Dxiohs. Ñahcu raꞌ ba lahdxilluhn, ñuroꞌba raꞌ ba cobadeh yihca raꞌ ba ziga tuhbi sehn nin ñacanalaasastoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ya chin guunn Dxiohs guelguxchisi pur xtuhlda garaa bwiinn guidxyiyuh, mahziru gusahcazii Ñiꞌh laꞌh tu, bwiinn Corazihn cun bwiinn Betsaida pur ayi gwachiistoꞌ tu milahgru raꞌ chi. Ya bwiinn guihdxyi Tiru cun Sidohn gulliaaꞌ sacazii raꞌ ba laasii ayi bwaꞌha raꞌ ba milahgru raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya ziga laꞌh tu bwiinn guihdxyi Capernaum, ¿ta ruhnn tu lligaaba par dxibaaꞌ gacah tu? Sidela nnah ¡mahziru laꞌn gueeta gabihldxyi dxiehta tu! ");
INSERT INTO zpvNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Rahbiza Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Laꞌh nin gucaꞌdxiahga xchiꞌdxyi tu zucaꞌdxiahgaza ba xchiꞌdxyiꞌhn; ya bwiinn nin ayi gucaꞌdxiahga xchiꞌdxyi tu ayiza gucaꞌdxiahga ba xchiꞌdxyiꞌhn; ya bwiinn nin ayi gucaꞌdxiahga xchiꞌdxyiꞌhn neezaa xchiꞌdxyi Xtaaꞌdahn nin guxeꞌhla naꞌh ayi gucaꞌdxiahga ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ya loh setenta bwiinn raꞌ chi riahxi duxa raꞌ ba chin gubiaꞌgarii raꞌ ba, rahbi raꞌ ba loh Jesuhs: ―Daada, neeraꞌza bwiinndxaaba bazoꞌbadxiahga xchiꞌdxyi nu chin bazeꞌta nu lah luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Uuhn. Chin bañihchi Satanahs xquelrnabwaꞌ ba, chiꞌchi bwaꞌhahn zigazi duꞌh guziꞌw zeꞌyaaba ba nez llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","¡Gulgahcabwaꞌ! Naꞌh baniꞌhihn xquelrnabwaꞌn laꞌh tu, tin guzuꞌñaaꞌ tu yihca bweꞌlda, yihca llohbigwaꞌ per ayi gahw raꞌ ma laꞌh tu, baniꞌhizahn xquelrnabwaꞌn laꞌh tu tin guunn tu gahn loh xquelrnabwaꞌ raꞌ bwiinndxaaba tin ayi chuu nin guunn mahla laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per ayi dxiahxi tu pura ruzoꞌbadxiahga bwiinndxaaba raꞌ xchiꞌdxyi tu; guldxiahxi pur caa lah tu loh xchihtsi Dxiohs nin nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hohrchi gahca biahxinee Spíritu Saantu laꞌh Jesuhs laasii rahbi Ñiꞌh loh Xtaada Ñiꞌh nin nuu dxibaaꞌ: ―Zuxchilli luꞌh Paah nin rnabwaꞌ dxibaaꞌ cun guidxyiyuh laasii cagaluuꞌyi luꞌh bwiinn raꞌ nin ayi rahcabwaꞌtiiꞌ cohsa raꞌ nin guluꞌlaꞌn luꞌh loh raꞌ bwiinn nin rluuꞌyi naann garaatiiꞌ. Yoo Paah, sidela ziꞌchi xclaaꞌdzi luꞌh guunn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Garaa raꞌ cohsa raꞌ riiꞌ laꞌbaniꞌhi luꞌh naꞌh Paah, sola xpaaꞌhn naann cuun nin naa Lliiꞌn ba, ayiru stuhbi nin naann; ya neezaa Lliiꞌn ba sola laꞌh bi naann bi cuun nin naa Xpaah bi, ziꞌchilla Daada nin ruluuꞌyi Lliiꞌn Ñiꞌh sola laꞌh bi naann bi cuun nin naa Xpaah bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chiꞌchi bwaꞌha Jesuhs loh raꞌ xpwiinn Ñiꞌh, rahbi Ñiꞌh loh raꞌsi ba: ―Dichohsa raꞌ nin gwaꞌha raꞌ garaa nin caywaꞌha tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","laasii ziahan daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih cun rrehyi raꞌ guclaaꞌdzi raꞌ ba ñwaꞌha raꞌ ba cohsa raꞌ nin caywaꞌha tu riꞌca nee ayi bwaꞌha raꞌ ban; neezaa guclaaꞌdzi raꞌ ba ñihn raꞌ ba dxyiꞌdxyi raꞌ nin cayihn tu per ayi bihn raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chiꞌchi gwasuꞌnchii tuhbi mwehsu nin ruluuꞌyi xlehyi Moisehs gwagañiꞌ ba loh Jesuhs laasii guclaaꞌdzi ba ñucheꞌh ba laꞌh Jesuhs, rahbi ba: ―Daada, mwehsu; ¿xa niꞌca guꞌnnahn tin guibahneꞌhn Dxiohs llaaꞌn dxibaaꞌ para tuꞌpazi? ");
INSERT INTO zpvNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chiꞌchi rahbi Jesuhs loh mwehsu chi: ―¿Xa cañiꞌ loh dxihtsi xteenn lehyi, xa ruꞌlda luꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chiꞌchi rahbi ba loh Ñiꞌh: ―Gaca nadziiꞌhi luꞌh Dxiohs gaduhbi stoꞌ luꞌh cun gaduhbi xalma luꞌh, neezaa gaca nadziiꞌhi luꞌh garaa lasaaꞌ luꞌh zigazi nadziiꞌhi luꞌh yiꞌh gahca. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chiꞌchi rahbi Jesuhs loh ba: ―Naa xnehza nin guñiꞌ luꞌh; sidela guunn luꞌh ziꞌchi zahpa luꞌh guelnabahan riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per guclaaꞌdzi mwehsu chi ñiñiꞌ zaꞌca bwiinn pur laꞌh ba, niꞌchin nin gunaabadxyiꞌdxyi ba stuhbi loh Jesuhs, rahbi ba: ―¿Chyuucaxchiꞌh niꞌca naa raꞌ lasaaꞌhahn? ");
INSERT INTO zpvNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chiꞌchi rahbi Jesuhs loh ba: ―Tuhbi bwiinn lahdxyi nuꞌh biriaꞌh guihdxyi Jerusalehn zee ba guihdxyi Jericoh. Loh zeezah ba biriaꞌh nuhn gubaꞌn loh ba, guleꞌlluꞌhu raꞌ ba garaatiiꞌ nin zenee ba, hasta lahdxi nin nahcu ba gueleꞌlluꞌhu raꞌ ba, nee badiꞌhi goolpi raꞌ ba laꞌh ba, basiaꞌhan raꞌ ba laꞌh ba zigazi nin guhchi, ziaa raꞌ chiꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ya chiꞌchi gudiiꞌdxi tuhbi bixohza lahdxyi nuꞌh, zee ba neziuh chi. Ya chin bwaꞌha ba naꞌ bwiinn chi, talguꞌnsi bicaꞌn ba gudiiꞌdxi ba stuhbi lahdu rwaaꞌ neziuh chi, zee chiꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ya ziꞌchi gahcaza bwiꞌhnn tuhbi bwiinn levita, nin ruhnn dziꞌn laꞌn guidoꞌ. Chin badzihn ba hasta naꞌ bwiinn chi, talguꞌnsi bicaꞌn gahca ba stuhbi lahdu rwaaꞌ neziuh ziga bwiꞌhnn gahca nin gudiiꞌdxi galoh, zee chiꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’Ya seguihdu naꞌhla gahca tuhbi bwiinnziitu nin naa tuhbi bwiinn Samaria nin rzah biahja nezchi; chin bigaꞌha ba hasta naꞌ bwiinn chi, balahsa duxastoꞌ ba laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chiꞌchi gwabiiga ba hasta naꞌ bwiinn chi ya bwiꞌhnn ba rramwehdxi gudaꞌbi ba arcohl cun nsehchi tihxi bwiinn chi cun batuꞌbi gahca ba veenda tihxi bwiinn chi gaduhbi hasta gudxiꞌldxyihdxyi raꞌ gubaꞌn, chiꞌchi basadziꞌba ba laꞌh ba xpuhrriꞌhn ba ya zeneechiꞌh ba laꞌh ba hasta nuu yuuꞌ nin rahlla, ya chin badzihn raꞌ ba riꞌchi, batehta ba laꞌh ba tin zenee raꞌ ba laꞌh ba laꞌñuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ya chin barah gueꞌla, guleꞌhe ba chiohpa mweeyi badiꞌhi ba laꞌh bwiinn nin rnabwaꞌ yuuꞌ chi, rahbi ba: “Dxiaꞌhannee luꞌh bwiinn riiꞌ gaapa laꞌh luꞌh ba, ya sidela ayi gaaldaa mweeyisi riiꞌ gadxiillihn gaaxtu nin guichiꞌhnru para laꞌh ba chin gabiaꞌgariin.” ");
INSERT INTO zpvNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chiꞌchi rahbi Jesuhs loh mwehsu nin ruluuꞌyi lehyi chi: ―Loh gadxioonn raꞌ bwiinn nin gudiiꞌdxi nez guhta bwiinn prohbi nin badiꞌhi goolpi raꞌ gubaꞌn, ¿cuunn nin guntsiiꞌhi laꞌh ba zigazi nadziiꞌhi ba laꞌh gahca ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chiꞌchi rahbi ba loh Jesuhs: ―Nin balahsastoꞌ ñiꞌh. Chiꞌchi rahbi Jesuhs loh ba: ―Gwah, ziꞌchipaꞌza guunn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ya biriaꞌh Jesuhs zezah Ñiꞌh neziuh nin zee guihdxyi Jerusalehn. Chin badzihn Ñiꞌh tuhbi guihdxyi biꞌtuꞌhn riꞌchi nuu tuhbi gunnaꞌh nin laa Marta, talguꞌnsi gunaaba bi guzee Ñiꞌh yihdzi bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nuuza tuhbi bwehldaa Marta nin laa María. Chin badzihn Jesuhs, talguꞌnsi guzohba María hasta zuu ñaaꞌ Jesuhs tin nuugacaꞌdxiahga bi garaa xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ya Marta xigaaba ziahanchiꞌhzi guelwahw nuu bi bieꞌchiꞌh María zohbasi cagacaꞌdxiahga nin cañiꞌ Jesuhs. Chiꞌchi gwabiiga Marta hasta rii raꞌ ba, chiꞌchi rahbi bi loh Jesuhs: ―Daada, ¿tayi xi lligaaba cayuhnn luꞌh pur nin cayuhnnee bweeldahn naꞌh? Basiaꞌhan bi tuhsihn cayuꞌnnahn guelwahw. Guhdzi loh bi gacanee bi naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chiꞌchi rahbi Jesuhs loh bi: ―¡Ai Marta, Marta; xtsiꞌndxiꞌhsi luꞌh caastoꞌ luꞌh pur ruhnn luꞌh ziahanan! ");
INSERT INTO zpvNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per ayi gaann luꞌh tuhbidxiꞌh sola nin mahzi lasahca nuuꞌ, naan guelrcaꞌdxiahga xchiꞌdxyi Dxiohs. María laꞌbi gulii nin lasahca chi nen ayi chyu nin cweꞌlluꞌhun loh bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ya Tuhbi dxyih gudihdxyi-gunaaba Jesuhs Xtaada Dxiohs Ñiꞌh tuhbi lahta ya chin guyaꞌloh gudihdxi-gunaaba Ñiꞌh chiꞌchi guñiꞌ tuhbi xpwiinn Ñiꞌh loh Ñiꞌh, rahbi ba: ―Daada, baluuꞌyi laꞌh nu xa gachidihdxi-gachinaaba nu Dxiohs ziga baluuꞌyi za Jwahn laꞌh raꞌ xpwiinn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Chin cwidxi-guinaaba tu Dxiohs, squiiꞌ guiñiꞌ tu: Xtaada nu nin rbweeza dxibaaꞌ, xclaaꞌdzi nu garaa raꞌ bwiinn guiñiꞌ zaꞌca ziga lah luꞌh; xclaaꞌdziza nu gadzihn dxyih dxiꞌ luꞌh guinabwaꞌ luꞌh guidxyiyuh ziga rnabwaꞌ luꞌh dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Guillii-guillii guniꞌhi luꞌh guehta guidaꞌw nu, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","gusiaꞌpitii gahca luꞌh xtuhlda nu nin rachiguꞌtii nu loh yuꞌbiluꞌh, ziga naguuꞌdzistoꞌ nu cun nin ruñihchi loh nu. Neen ayi gusaaꞌn luꞌh coꞌbañuh bwiinndxaaba laꞌh nu chin guiclaaꞌdzi ba sino que guhldaꞌh luꞌh laꞌh nu loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Cun neezaa rahbi Jesuhs loh raꞌ ba: ―Sidela chyuulla tuhbi tu nahpa tuhbi amihgu ya gadzihn ba yihdzi tu garoolda gueꞌla, nnah ba loh tu: “¿Tayi cweꞌhedxiꞌhn luꞌh chohnna pahn naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","gahwsi tuhbi xamihguꞌhñin? Laasii zihtu zeꞌ ba niꞌchin ayi naꞌpahn xi gudiꞌhihn gahw ba.” ");
INSERT INTO zpvNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ya coma yiꞌh naꞌxgahsi luꞌh cun lliiꞌn raꞌ luꞌh loh luꞌhn, ya chin dxihn luꞌh cañiꞌ xamihgu luꞌh chi, chiꞌchi gahbi luꞌh: “Xi xclaaꞌdzi luꞌh tin naꞌh laꞌn naꞌxgahsila cun lliiꞌnraꞌn, ayi nuu chestiꞌhn guniꞌhihn nin guicaꞌha luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ñaan loh tu, nicala ayi xi gudiꞌhi tu laꞌh ba pur naa ba xamihgu tu, per mejor chestii tu gudiꞌhi tu garaa nin rchiꞌhn ba tin ayi chezah guunn ba llahn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ziꞌchi gahcaza ñaan loh tu: sidela chezah canaaba tu xiilla, zicaꞌha tun; sidela chezah cachiꞌhyi tu xiila zidxeela tun; sidela chezah cagasihdzi tu rwaaꞌ xleeꞌ bwiinn zixaala raꞌ ban chuꞌtii tun, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","laasii chyuchiꞌhzi nin riazah rdxiꞌhn xiilla rdiꞌhi raꞌ bwiinnan; nee chyuchiꞌhziza nin riazah cadxiꞌhyi xiilla rdxeela ban; nee neezaa chyuchiꞌhziza nin riazah cagasihdzi rwaaꞌ leeꞌ, nahpa guireꞌh nin guixaalan tin chuꞌtii ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Sidela chyulla tuhbi tu guinaaba lliiꞌn tu pan, ¿ta ziaalla tu gudiꞌhi tu tuhbi taaꞌha dxiah gahw bi? Ya sidela guinaaba bi tuhbi bwehlda, ¿ta zialla tu gudiꞌhi tu tuhbi bweꞌlda gahw bi? ");
INSERT INTO zpvNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ya sidela guinaaba bi tuhbi dzihtabwihdxi, ¿ta zialla tu gudiꞌhi tuhbi llohbigwaꞌ gahw bi? Guyaa, ayi bwiinn nin ruhnn ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ya sidela laꞌh tu nin naa bwiinn duhlda rahca rudiꞌhi tu cohsa zaꞌca lliiꞌn tu, ¿xilaꞌhxchiꞌh Xtaada tu nin nuu dxibaaꞌ ayi dxiaꞌhan gudiꞌhi Ñiꞌh Spíritu Saantu laꞌh raꞌ bwiinn nin rnaaba Ñiꞌh ya zibweezaza Ñiꞌh stoꞌ raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ya guyuuꞌ tuhbi bwiinn nin guyuuꞌ bwiinndxaaba stoꞌ ñiꞌh, biaꞌhan goopa ba ayi basaaꞌn bwiinndxaaba chi ñiñiꞌ ba. Ya babweꞌhe Jesuhs bwiinndxaaba chi lastoꞌ ba. Ya chin bariaꞌh bwiinndxaaba chi stoꞌ ba, bañiꞌ ba; garaa bwiinn badxyigaaꞌ pur niꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ya guyuuꞌ nuhn bwiinn nin rahbi: ―Ndxiꞌhw riiꞌ rahca rabweꞌhe bwiinndxaaba stoꞌ raꞌ bwiinn laasii Belzebuu nin rnabwaꞌ laꞌh raꞌ bwiinndxaaba cayahcanee laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ya snuhn raꞌ ba gunaaba guunn Ñiꞌh tuhbi milahgru ziga tuhbi sehn nin zeꞌ llaaꞌndxibaaꞌ tin gwaꞌha raꞌ ba gu guchii Ñiꞌh naa Ñiꞌh Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per Jesuhs laꞌÑiꞌh guhcabwaꞌla xi lligaaba cayuhnn raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Chyuchiꞌhzi gubieerna nin rbahchixchih raꞌ partihdu nahpa rbihyin; ya chyuuchiꞌhzi bwiinn nin rdxihldxyinee lasaaꞌ ñiꞌh nahpa rñihchiloh raꞌ bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ya sidela childxyinee Satanahs laꞌh bwiinndxaaba raꞌ nin rnabwaꞌ ba, ¿xalla guunn ru chiꞌh ba guinabwaꞌ ba laꞌh raꞌ ba? Mejor gariaꞌh ba guelrnabwaꞌ chi. Squiiꞌ rñaan loh tu laasii ruuꞌyi tu rabweꞌhehn bwiinndxaaba raꞌ stoꞌ bwiinn cun guelrahcanee xteenn Belzebuu. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sidela ziꞌchi ñahca, ¿chyu cayahcanee chiꞌh laꞌh raꞌ bwiinn loh tu nin rabweꞌhe bwiinndxaabaraꞌ? ¿Gu Belzebuu? Guyaa, ayi laꞌh dxiꞌh ba. Niꞌchin pwehda guiñiꞌ raꞌ bwiinn chi loh tu billiꞌn loh xigaaba tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per sidela guchiin rabweꞌheraꞌn bwiinndxaaba stoꞌ raꞌ bwiinn laasii cayahcanee Dxiohs naꞌh, niꞌchin nugaluuꞌyiloh niꞌca, laꞌdxyih badzihn guinabwaꞌ Dxiohs guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Chin nuu tuhbi bwiinn nin ayi guinadxyiꞌbitiiꞌ tuhbi yuuꞌ nee nahpa ba blaaquiꞌhn nin rulaloh yihdzi ba tin ayi ñihchin, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","per sidela gadzihn stuhbi nin mahzi ayi guidxyiꞌbi chiꞌchi cweꞌlluꞌhu ba xchiꞌba bwiinn chi cun garaa nin nahpa niꞌchi guicaꞌha ban chiꞌzi ban. Ziꞌchi guunnee xquelrnabwaꞌ Dxiohs laꞌh xquelrnabwaꞌ bwiinndxaaba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nuu bwiinn raꞌ nin ayi xclaaꞌdzi naꞌh mejor rdxyiꞌchinee raꞌ ba naꞌh, ya nin ayi rahcanee naꞌh guidiaaꞌha raꞌ bwiinn nin guinabwaꞌ Dxiohs, laꞌlagaꞌh cabweꞌhecaa raꞌ ba laꞌh raꞌ ba loon tin gacaꞌha bwiinndxaaba laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Rahbiza Jesuhs loh raꞌ ba: ―Chin rariaꞌh bwiinndxaaba stoꞌ tuhbi bwiinn, chiꞌchi rcaꞌnzaa ba lugahri bihdzi tin rdxiꞌhyi ba canehza guziꞌlaaꞌdzi ba, ya rwaꞌhasi ba ayi rdxeelan, ruhnn ba lligaaba: “Mejor gabiaꞌgariin yiidzihn hasta bariaꞌhn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ya chin gubiaꞌgarii ba bwaꞌha ba stoꞌ bwiinn chi chuhla biacan zigazi tuhbi yuuꞌ nin biyoꞌba laꞌn ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chiꞌchi chegalliꞌh ba zagahdzi bwiinndxaaba nin mahzi rusaꞌcazii laꞌh bwiinn que ziga ruhnn ba, tin chuꞌtii raꞌ ba stoꞌ bwiinn chi, ya mahziru nalaasa guunnee raꞌ ba bwiinn chi que ziga guhca ba galoh. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gaduhbi cañiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ, guzoꞌbaloh tuhbi gunnaꞌh nin nuu loh raꞌ bwiinn chi, cañiꞌ ba jweersirooꞌ, rahbi ba: ―Dichohsa gunnaꞌh nin gullahn yiꞌh cun bachiooꞌ ba yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chiꞌchi rahbi Ñiꞌh: ―Radiitsi naa niꞌca; dichohsa naa bwiinn nin rucaꞌdxiahga nin rñiꞌ Dxiohs cun guzoꞌbadxiahga raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ya zeezah cagadiaaꞌha raꞌ bwiinn gadiidxi Jesuhs, chiꞌchi guzaꞌloh cañiꞌ Ñiꞌh, rahbi Ñiꞌh loh raꞌ ba: ―Prohbi laꞌh tu, dxyiꞌbi bwiinn xihn duxa tu, xclaaꞌdzi tu gwaꞌha tu milahgru ziga tuhbi sehn nin guluuꞌyi naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, per sola sehn xteenn guehtu Jonahs daada nin guñiꞌ xchiꞌdxyi Dxiohs caachieempa guniꞌhihn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Laꞌh gahca ziga guhca Jonahs tuhbi sehn par bwiinn guihdxyi Nínive, ziꞌchi gahca naꞌh, ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, gacaꞌhn ziga tuhbi sehn par bwiinn raꞌ nin nabahan nnah. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Chin gadzihn dxyih nin guunn Dxiohs guelguxchisi loh gaduhbi guidxyiyuh, chesuhnchii tuhbi naaniꞌhn nin guhca rreihna loh yuh raꞌ nez lahdu laꞌngueeta tin gucaꞌchiah ba laꞌh raꞌ bwiinn nin rii guidxyiyuh nnah laasii laꞌh ba biriaꞌh ba zihtu duxa tin bacaꞌdxiahga ba guelnaann xteenn Salomohn, ya riiꞌ zuu stuhbi bwiinn nin mahzi lasahca xchiꞌdxyi Ñiꞌh que no Salomohn, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","neezaa bwiinn chieempa xteenn guihdxyi Nínive cun bwiinn raꞌ za nin nabahan nnah, chesuhnchii raꞌ ba chin gaca jwiisi tin gucaꞌchiah raꞌ ba laꞌh tu laasii biuꞌgarii raꞌ ba loh xquelñaꞌñih Dxiohs chin gwanee Jonahs xchiꞌdxyi Dxiohs loh raꞌ ba, ya loh gahca tu zuu stuhbi bwiinn nin mahzi lasahca que no Jonahs. Rahbiza Jesuhs: ");
INSERT INTO zpvNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","―Ayi tuhbi bwiinn nin gucaꞌdxih tuhbi biaꞌñih ya cuꞌlaꞌn ban llaaꞌn xluꞌhn ba, o laꞌn tuhbi caja, sino que guzaꞌbi ban guiyaꞌ tin bwiinn raꞌ nin chuꞌtii ñaꞌñih gwaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bizloh bwiinn naa ziga tuhbi biaꞌñih par gaduhbi tihxi ba, ya sidela bizloh rwaꞌha zaꞌcan, neezaa gaduhbi tihxi ba nuu biaꞌñih; per sidela bizloh ba rahcan, ziꞌchiza tihxi ba nuu loh nacahyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bwaꞌhadziꞌtsi ayi dxiuꞌyi xpiaꞌhañih luꞌh tin ayi dxiaꞌhan luꞌh loh nacahyi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ya sidela gaduhbi tihxi luꞌh riaꞌñih, nin tuhbi lahta ayi nacahyi, zahca gwaꞌha zaꞌca luꞌh garaatiiꞌ ziga laꞌn tuhbi yuuꞌ hasta caadxih tuhbi biaꞌñih rooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chin guluhlla guñiꞌ Jesuhs, guñiꞌ tuhbi fariseu loh Ñiꞌh chetahw Ñiꞌh tuhbi guelwahw rwaaꞌ yihdzi ba. Ya chiꞌchi gwah Ñiꞌh. Ya chin badzihn Ñiꞌh riꞌchi, chiꞌchi gudiiꞌdxi Ñiꞌh hasta zuu mweella. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ya badxyigaaꞌloh fariseu chi laasii ayi gudxiꞌbinaa Jesuhs ziga naa costuumbre guunn raꞌ fariseu chi chin gahw raꞌ ba, neezaa ruhnn gahca raꞌ ba lligaaba bwiinn zaꞌca raꞌ ba loh Dxiohs laasii rdxiꞌbinaa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chiꞌchi rahbi Jesuhs loh ba: ―Laꞌh tu bwiinn fariseu rdxiꞌbi tu nez dihtsisi vahsu cun plahtu ya nez laꞌn lastoꞌ tu gwadxahchihpa guelgubaꞌn cun garaaloh lligaaba nin ruhnn tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Bwiinn nahda raꞌ! ¿Tayi rahcabwaꞌ tu? Bwiinn nin ruhnnchaꞌyi guihsu laꞌba ruhnn ba dihtsin cun laꞌnan, niꞌchin nahpa chiꞌbi tu dihtsin nee cun laꞌnan. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yannah gulcweꞌhe garaa lligaaba gubaꞌn ca cun lligaaba dxaaba nin nuu stoꞌ tu, nee neezaa gulgahcanee laꞌh raꞌ bwiinn nin ayi xi nahpatiiꞌ tin ziꞌchi garaa raꞌ cohsa gaca nayaaraꞌn para laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Prohbi laꞌh tu bwiinn fariseu raꞌ. Cadxihlli tu loh Dxiohs nin ruhnn tucahri guicaꞌha Ñiꞌh, hasta rdxihlli tu xiica raꞌ cwaꞌniꞌhn per pur ayi rahcanee tu laꞌh raꞌ bwiinn prohbi neezaa ayi guinadziiꞌhi tu laꞌh Dxiohs niꞌchin ayi runcweenta tu xchiꞌdxyi lehyi nin mahzi lasahca. Nahpa chilli tu nin ruhnn tucahri guicaꞌha Ñiꞌh neezaa snuhn raꞌ cohsa chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Prohbiza laꞌh tu bwiinn fariseu raꞌ. Xclaaꞌdzi tu puura yahgaxiiyi zaꞌca nin rzohba raꞌ bwiinn lasahca laꞌn guidoꞌ soobaa tu, nee xclaaꞌdzi tu garaa bwiinn gugahpa Dxiohs laꞌh tu loh dxiaaꞌ gaduhbi xquelnadoꞌ laaꞌdzi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Prohbiza laꞌh tu; naa tu zigazi baꞌ raꞌ nin ayiru guidxiin caa naꞌ nin ziaa-zieꞌ bwiinn yihca raꞌ ñiꞌh, ya nin ayi gaann ba cañin rdiiꞌdxi ba, ya guyuuꞌ xtuhlda ba laasii bazuhñaaꞌ ba yihca baꞌ raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chiꞌchi guñiꞌ tuhbi mwehsu nin ruluuꞌyi lehyi, rahbi ba loh Jesuhs: ―Daada mwehsu, chin rñiꞌ luꞌh dxyiꞌdxyi raꞌ ca neegah laꞌh nu rñiꞌyah luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¡Prohbiza laꞌh tu bwiinn nin ruluuꞌyi lehyi!, laasii rnabwaꞌ tu niꞌchin rusaguhnn tu bwiinn raꞌ cohsa raꞌ nin nagahn duxa nin naa ziga tuhbi cohsa naaꞌha nin ayi rdxihpa bwen bwiinn, ya laꞌh tu nin cun tuhbi bacwihnaa tu ayi rdxiꞌ tun. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Prohbiza laꞌh tu laasii ruhnnchaꞌyi tu xpaꞌ raꞌ daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cachieempa, nee laꞌh gahca tu nin naa llahga raꞌ bwiinn nin gudxiinn laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Niꞌchin nin naannpaꞌ tu xi guzahca raꞌ ba, riuuꞌstoꞌ tu dziꞌn raꞌ nin bwiꞌhnn raꞌ guehtu xtatitaroo tu; laꞌh raꞌ ba gudxiinn raꞌ ba bwiinn raꞌ nin guhchi, ya laꞌh tu ruhnchaꞌyi tu xpaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Niꞌchin nin guñiꞌ Dxiohs, laasii rahcabwaꞌ Ñiꞌh garaatiiꞌ ya rahbi Ñiꞌh: “Zixeꞌhlaꞌhn bwiinn raꞌ nin guiñiꞌ xchiꞌdxyiꞌhn cun neezaa pooxtla raꞌ, ya bwiinn raꞌ zidxiinn raꞌ ba paaldaa raꞌ ba ya snuhn raꞌ ba gusahcazii raꞌ ba.” ");
INSERT INTO zpvNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Loh raꞌ bwiinn nin nabahan nnah zinaaba Dxiohs chilli raꞌ ba llerihn garaa daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs nin gudxiinn raꞌ ba chin gurihxchih guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ya rihn nin billiꞌhi raꞌ chi rzohbalohon dez guehtu Abel hasta guehtu Zacarías nin gudxiinn raꞌ ba galaayillee laaꞌyitiaaꞌha xteenn guidoꞌrooꞌ; guchiin nin rñiꞌn loh tu, Dxiohs gusadxihlli llerihn raꞌ ba laꞌh raꞌ bwiinn nin nabahan nnah. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Prohbiza laꞌh tu nin ruluuꞌyi lehyi laasii laꞌhsi tu nahpa tu chiahyi rahcabwaꞌ tu xa taꞌh bwiinn loh duhlda ayiza nnaa tu guixaala tu rwaaꞌ yuuꞌ tin chuꞌtii tu xneziuh Dxiohs ya ayiza nnaa tu gudiꞌhi tu chiahyi chi laꞌh raꞌ bwiinn tin gaca chuꞌtii raꞌ ba loh xneziuh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chin guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ loh raꞌ ba, bidxyiꞌchinee raꞌ mwehsu cun fariseu raꞌ chi laꞌh Ñiꞌh, chiꞌchi guzoꞌbaloh canaabadxyiꞌdxyi raꞌ ba ziahan dxyiꞌdxyi loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ya bwiꞌhnnee raꞌ ba laꞌh Ñiꞌh ziꞌchi tin ñiñiꞌ Ñiꞌh xiica raꞌ cohsa dxaaba tin ñahpa raꞌ ba jweersi ñiñiꞌyah raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gaduhbi cañiꞌ Ñiꞌh guzaꞌloh cagadzihn pur mihyi raꞌ bwiinn hasta rreeldaa lasaaꞌ raꞌ ba tantu ziahan raꞌ ba, chiꞌchi guzaꞌloh cañiꞌ Jesuhs loh raꞌ xpwiinn Ñiꞌh, rahbi Ñiꞌh: ―Gulgahca nasiin tin ayi guicaꞌha tu xmohda raꞌ bwiinn fariseu, ziga ayi rzohbadxiahga raꞌ ba dxyiꞌdxyi gahca nin rñiꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","laasii xiilla tuhbi cohsa nin guunn bwiinn ralaꞌn nahpa rdxeelan ya xiilla dxyiꞌdxyi ralaꞌn nahpa rihn bwiinnan, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","nee garaa dxyiꞌdxyi nin rñiꞌ bwiinn laꞌn gueꞌla nahpa zihn bwiinnan ya nin rñiꞌ ralaꞌn bwiinn ziga tuhbi yuuꞌ ñieꞌw nahpa zibwihdxyidxiahan hasta guiyaꞌ yihca yuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Rahbiza Jesuhs: ―Ñaan loh tu mihgu raꞌ, ayi guidxyihbi tu bwiinn nin xclaaꞌdzi chiinn laꞌh tu tin chin laꞌtu guhchi, ayiru nuu xi gunnee raꞌ ba laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","per guiñaan loh tu chyu mahzi guidxyihbi tu: tuhbidxiꞌh sola Dxiohs mahzi gulguidxyihbi tin laꞌhdxiꞌh Ñiꞌh zaca guzaꞌhla laꞌh tu gabihldxyi chin gahchi tu sidela ayi guzoꞌbadxiahga tu xchiꞌdxyi Ñiꞌh. Nen guchiin nin rñiꞌn, gulchuuꞌ guelrzaaꞌ laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Laꞌtu naannla, rioꞌh chiohpa maaniꞌhn pur chiohpa gaꞌyu, per ayi rbweꞌhestoꞌ Dxiohs laꞌh raꞌ ma nicala ayi guilasahca raꞌ ma guyahlli. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hasta dxyichyihca tu laꞌraꞌn nagaabala ya niꞌchin ayi guidxyihbi tu tin laꞌh tu mahziru lasahca tu loh ziahan raꞌ maaniꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Neezaa rahbi Jesuhs: ―Ñaan loh tu, garaa raꞌ nin guiñiꞌ nez loh raꞌ bwiinn: “Nuꞌbwaꞌn laꞌh Jesuhs laasii naan xpwiinn Ñiꞌh”, naꞌhza nin naan Lliiꞌn Dxiohs nin naa ndxiꞌhw guiñiꞌn loh raꞌ xaanjla Dxiohs: “Nuꞌnbwaꞌn bwiinn ca laasii laꞌh ba naa ba xpwiiꞌnnahn”; ");
INSERT INTO zpvNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ya nin rñiꞌ nez loh raꞌ bwiinn: “Ayi nuꞌnbwaꞌn Jesuhs laasii ayi xclaaꞌdzihn gacaꞌhn xpwiinn ba”, ziꞌchi gahcaza naꞌh guiñiꞌn loh raꞌ xaanjla Dxiohs: “Ayi nuꞌnbwaꞌn bwiinn ca laasii ayi gunnah ba ñahca ba xpwiiꞌnnahn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw ya guxeꞌhla Xpaaꞌn naꞌh loh guidxyiyuh, ya chyuchiꞌhzi nin guiñiꞌyah naꞌh zusiaꞌldastoꞌ Xpaaꞌn xtuhlda bwiinn chi; per sidela niꞌchi guiñiꞌyah laꞌh Spíritu Saantu xteenn Dxiohs, ayi dxiaꞌldatiiꞌ stoꞌ Xpaaꞌn xtuhlda bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Chin chenee raꞌ ba laꞌh tu nezloh raꞌ bwiinn guidoꞌ o nezloh raꞌ guxchiisi nin rnabwaꞌ tin gucaꞌchiah raꞌ ba laꞌh tu saca nin riachiistoꞌ tu xchiꞌdxyiꞌhn, ayi xi lligaaba guunn tu xa gusiaꞌgarii tu dxyiꞌdxyi, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tin chin gadzihn hohra nin guiñiꞌ tu, laꞌSpíritu Saantu guluuꞌyi xa gusiaꞌgarii tu dxyiꞌdxyi loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ya tuhbi bwiinn nin dxaꞌga loh raꞌ bwiinn ziahan chi rahbi loh Jesuhs: ―Mwehsu, guhdzi loh bwiꞌtsihn guniꞌhi bi garoolda bien nin basiaꞌhannee xpaaꞌn laꞌh bi guicaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chiꞌchi rahbi Jesuhs loh bi: ―Per ndxiꞌhw, ¿chyuulla gulii luꞌh naꞌh guꞌnnahn guel guxchiisi xcweenta tu nee chiꞌzi gahcan xixteenn tu? ");
INSERT INTO zpvNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rahbi gahca Jesuhs loh raꞌ ba: ―Laꞌh gahca tu gulgahca nasiin ayi chuꞌguiꞌw tu gaapa tu ziahan raꞌ cohsa zaꞌca nin nuu guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ya seguihdu guleꞌhe Jesuhs tuhbi cweenta loh raꞌ ba, rahbi Ñiꞌh: ―Guyuuꞌ tuhbi bwiinn gohpa ba ziahan cohsa zaꞌca ya guyuuꞌ tuhbi dxyih guhca duxa xquiñaꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chiꞌchi guzaꞌloh ruhnn ba lligaaba nastoꞌ ba: “¡Laaxchimma naꞌh naꞌpahn ziahan xica cohsa!; nnah ayi naꞌpahn canehz cwii xñiizahn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Talguꞌnsi bwiꞌhnnlagaꞌh ba lligaaba: “Laꞌn guhcabwaꞌ xa guꞌnnahn nnah; gutsiiyihn yihdzi biꞌtuꞌhnaꞌhn tin dxyuun gurooꞌñihn ya laꞌn chi cuꞌchaꞌyiꞌhn garaa xliꞌhnaꞌhn cun garaa nin naꞌpahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ya chin guꞌnnahn gahn gaca niꞌchi, zaca guuyidxyiꞌdxyi tuhsihn: Bayinnah laꞌluꞌh nahpa ziahan cohsa para ziahan yihza, guziꞌlaaꞌdzi luꞌh gahw zaꞌca luꞌh guee luꞌh vihnnu dxiahxi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chiꞌchi rahbi Dxiohs loh ba: “¡Bwiinn nahda! Nnahgueꞌla gahca gachi luꞌh gabwiidxyihn xaalma luꞌh ya garaa nin nahpa luꞌh ¿chyuulla guicaꞌha raꞌ chiꞌhn?” ");
INSERT INTO zpvNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ziꞌchichiꞌhzi rzahca bwiinn raꞌ nin rbahchicwaꞌh xquelnazaꞌca Ñiꞌh loh guidxyiyuh riiꞌ ya nin Dxiohs ayi ruhnn cweenta raꞌ ba, per ziꞌchi gahcaza par nez loh Dxiohs ayi guinacweenta raꞌ ba, prohbizii-prohbilaasa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chiꞌchi guñiꞌ Jesuhs loh raꞌ xpwiinn Ñiꞌh rahbi Ñiꞌh: ―Niꞌchin nin rñiꞌn loh tu, ayi xi guelrzaaꞌ chuu tu pur nin gahw tu para guibahan tu cun lahdxi nin gacu tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","tin xquelnabahan bwiinn mahzi lasahca que ziga nin rahw raꞌ ba; ya tihxi ba mahziza lasahca que ziga lahdxi nin rahcu ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gulguiꞌhnn lligaaba biahchi raꞌ xa loh nabahan raꞌ ma ayi raaꞌn raꞌ ma ayiza ruchah raꞌ ma yuuꞌñihza ziga ruhnn tu ayiza nahpa raꞌ ma ca cuꞌchaꞌyi raꞌ ma llooba, per nicala ayi xi nahpa raꞌ ma Dxiohs gahca rudiꞌhi nin rahw raꞌ ma cun nin reeꞌ raꞌ ma; ziꞌchilla laꞌh tu ¿tayi ruhnn tu lligaaba mahziru lasahca tu nez loh Dxiohs que maaniꞌhn raꞌ? Guyaa mahziru lasahca tu que ziga laꞌh raꞌ ma. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ta nastoꞌ tu pur riuuꞌ tu guelrzaaꞌ zahca chyooru tu ziga za garoolda metru? ");
INSERT INTO zpvNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sidela rguꞌbwaꞌ tu nin tuhbi cohsa biꞌtuꞌhn ayi guunn tu gahn gaca, ¿xixnaa chiꞌh riuuꞌ tu guelrzaaꞌ guunn tu tuhbi cohsa rooꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gulguiꞌhnn lligaaba dxiaꞌ billiiga raꞌ xa rrooꞌraꞌn. Ayi ruhnnraꞌn dziꞌn ayiza rdxihba raꞌn lahdxi, niꞌchin rñaan loh tu nin rrehyi Salomohn nicala ziahanrooꞌ cohsa raꞌ gohpa ba per ayi guhtatiiꞌ ba lahdxi zaꞌca ziga rzuchaꞌyi dxiaꞌ raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sidela ziꞌchi ruhnnchaꞌyi Dxiohs dxiaꞌ nagaaꞌ joosca raꞌ nin rii loh dahan nnah ya guillii gwaꞌha ban laꞌngubihdzila chiꞌchi gucaꞌdxih raꞌ ban, niꞌchin nnah gulgahcabwaꞌ laꞌh tu mahzi lasahca tu que dxiaꞌ raꞌ chi niꞌchin nahpa guniꞌhi Ñiꞌh nin gahcu tu, ¡bwiinn raꞌ nin zee-zeꞌ loh xigaaba raꞌ ñiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Niꞌchin nin rñiꞌn ayi ruzuꞌhyi yihca tu cun lligaaba xa guidxeela nin gahw tu nin guee tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","tin bwiinn guidxyiyuh lligaaba chiꞌhzi nin xa guidxeela raꞌ ba nin gahw raꞌ ba nin guee raꞌ ba cun nin gacu raꞌ ba riuuꞌ raꞌ ba, per Xtaada nuꞌh nin nuu dxibaaꞌ laꞌÑiꞌh naannla cuun nin xchiꞌhn tu; ");
INSERT INTO zpvNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","niꞌchin gulgadxiꞌhyisi loh xquel rnabwaꞌ Dxiohs nen gulgacaꞌdxiahga gahca xchiꞌdxyi Ñiꞌh, naannca Ñiꞌh guluuꞌyi Ñiꞌh garaa nin xchiꞌhn tu par guibahannee tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Rahbiza Jesuhs loh raꞌ ba: ―Laꞌh tu nin naa xiꞌhyiraꞌn ayi guidxyihbi tu pur nin naa tu gulliaaꞌ, tin laꞌh tu naa tu nin gulii Dxiohs guunn tu guelguxchiisi pur xquelrnabwaꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gulgatooꞌ xixteenn tu nin nahpa tu, gulgadiꞌhin laꞌh bwiinn nin ayi xi nahpa, tin ziꞌchi guunn tu tuhbi buuxa nin ayi dxiuullatiiꞌ tin chuu guelnazaꞌca laꞌnan llaaꞌndxibaaꞌ hasta ayi chyu gubaꞌn nuu nin maan nin rahw lahdxi ayi chuutiiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","laasii hastasi naann tu chuu xquelnazaꞌca tu, riꞌchisiza naann tu chuu stoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Rahbiza Ñiꞌh loh raꞌ ba: ―Gulgahca nasiin, nee banahcu xahba tu ayi gusaaꞌnza tu dxiuꞌyi xpieꞌñih tu ñaaꞌ tu; ");
INSERT INTO zpvNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","gulguiꞌhnn ziga mooza raꞌ nin cabweeza guibiaꞌgarii xpallwaaꞌn ñiꞌh nin zee tuhbi saaꞌ tin chin gusihdzi ba rwaaꞌleeꞌ talguꞌnsi guillaalan dxiuꞌgarii ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dxiahxi mooza raꞌ chi sidela ziꞌchi guunn raꞌ ba chin guibiaꞌgarii xpallwaaꞌn raꞌ ba nen guchiin nin rñiꞌn loh tu, laꞌh gahca xpalwaaꞌn raꞌ ba chi gacu ba lahdxi ziga xahba gahca xmooza ba, ya laꞌhgahca ba cwachi ba mooza raꞌ chi loh mweella tin gudiꞌhi ba xi gahw raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ya sidela gadzihn ba garoolda gueꞌla o gucahyiroozi gwaꞌha ba laꞌ raꞌ xmooza ba riisiinla cabweeza raꞌ ba laꞌh ba, ya chiꞌchi dxiahxi duxa mooza raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ya laꞌh tu gulgahcabwaꞌ nin rñiꞌn loh tu, sidela ñahcabwaꞌ ballwaaꞌn xteenn tuhbi yuuꞌ xohra ñahdzihn tuhbi nin ruhnn gubaꞌn, pwehda ayi ñusaaꞌn ba ñuꞌtii gubaꞌn chi yihdzi ba ñibaaꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ya ziꞌchi gahca laꞌh tu gulgahca nasiin, laasii hohra nin ayi nuu tu lligaaba gadzihnaꞌhn hohrachi gadzihnaꞌhn ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chiꞌchi gunaabadxyiꞌdxyi Pehdru loh Ñiꞌh, rahbi ba: ―Daada, ¿ta lohsi nu ruuꞌyidxyiꞌdxyi luꞌh cweenta raꞌ ca o nee loh garaa raꞌ bwiinn? ");
INSERT INTO zpvNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chiꞌchi rahbi Jesuhs: ―¿Chyuniꞌca naa tuhbi mooza zaꞌca, tuhbi mooza nasiin nin rusiaꞌhannee xpallwaaꞌn Ñiꞌh nuhn xmooza ba tin gudiꞌhi ba xi gahw raꞌ ba chin rahlda hohra? ");
INSERT INTO zpvNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dxiahxi duxa mooza chi sidela rgaꞌha cayuhnn ba chin gabiaꞌgarii xpallwaaꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Guchiin nin cañiꞌn loh tu, zusiaꞌhannee ballwaaꞌn chi garaa nin nahpa ba laꞌh mooza zaꞌca chi tin guinabwaꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per sidela guunn mooza chi lligaaba laꞌn lastoꞌ ba: “Zahcataꞌh guibiaꞌgarii xpallwaaꞌnaꞌhn”, talguꞌnsi soobaaloh ba gahwxaꞌta ba, guee ba, suhdzi ba; ");
INSERT INTO zpvNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ya ballwaaꞌn chi gabiaꞌgarii ba tuhbi dxih nin ayi cabweeza ba laꞌh ba, hohra nin ayi guunn ba lligaaba gadzihn ba, chiꞌchisihn zuhnn ba tuhbi caxchihgu rooꞌ laꞌh ba zuchielda ba tuhbi duꞌh dihtsi ba chiꞌchi zinabwaꞌ ba gadxaꞌga ba loh raꞌ bwiinn nin ayi ruzoꞌbadxiahga xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ya mooza nin naann xi xclaaꞌdzi xpallwaaꞌn ba gaca per ayi rzuhsiin ba ayiza ruzoꞌbadxiahga ba xchiꞌdxyi ba nahpa guirehlda ba paaldaa cwaarta, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ya mooza nin ayi gaann xi xclaaꞌdzi xpallwaaꞌn ba gaca ya bwiꞌhnn ba cohsa raꞌ nin ayi biuꞌstoꞌ xpallwaaꞌn ba, gulliaaꞌ caxchihgu gaca ba gulliaaꞌ za cwaarta guicahyahga ba. Bwiinn raꞌ nin mahzi rudiꞌhi Dxiohs xiilla cohsa nahpa gusiaꞌgarii raꞌ ban cun lliiꞌnan, ya bwiinn nin rudiꞌhi Ñiꞌh ziahan cohsa ziahanrun nahpa gusiaꞌgarii raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Rahbiza Jesuhs: ―Naꞌh bieꞌldahn tin gucaꞌdxiin guidxyiyuh riiꞌ; ¡ojlaꞌh cayahcalan!, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","tin naꞌh nahpa zachiꞌhn, sacazii duxaꞌhn pur xtuhlda garaa bwiinn guidxyiyuh. Niꞌchi naa ziga tuhbi guelgusacazii xlawaaꞌha guelrrohbañihsa, ya ziahan lligaaba ruꞌnnahn tin chaꞌlohon. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ta ruhnn tu lligaaba guelrbahchidxyiistoꞌ zeꞌldaneꞌhn loh guidxyiyuh? Rñaan loh tu ayi niꞌchidxiꞌhn sino que bieꞌldahn tin gutaaꞌha raꞌn bwiinn loh lasaaꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","laasii deznnah zilaaꞌha lasaaꞌ tuhbi jwamihyi bwiinn; loh gaꞌyu raꞌ ba zidxyiꞌchinee chohnna raꞌ ba laꞌh chiohpa raꞌ ba per laꞌh chiohpa raꞌ ba chi zidxyiꞌchinee za laꞌh chohnna raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Zilaaꞌha lasaaꞌ raꞌ ba; zidxyiꞌchinee daada laꞌh lliiꞌngaꞌn ba ya lliiꞌngaꞌn ba zidxyiꞌchinee za laꞌh ba; ziꞌchi gahcaza naan raꞌ zidxyiꞌchinee ba lliiꞌndxaꞌpa ba ya lliiꞌndxaꞌpa ba zidxyiꞌchineezaa laꞌh ba. Ziꞌchi gahca nanswehgra zidxyiꞌchinee ba xguyihdzi ba neezaa xguyihdzi ba zidxyiꞌchineezaa laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Guñiꞌza Jesuhs loh raꞌ bwiinn ziahan chi, rahbi Ñiꞌh: ―Chin rwaꞌha tu riahsa xcahyi nez lahdu nin riaꞌzi gubihdxyi, chiꞌchi rahbi tu: “Bayinnahsihn laꞌñihsadxiah dxiaaba”, nee ziꞌchi rahca; ");
INSERT INTO zpvNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ya chin riꞌ bwih nez lahdu laꞌngueeta, chiꞌchi rahbi tu: “Bayinnahsihn, naldaꞌh gaca”, nee ziꞌchi rahca. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Bwiinn nahda raꞌ!, laꞌtu naann xa rzaꞌloh sehn raꞌ nin nuu guidxyiyuh cun llaaꞌndxibaaꞌ, ya ¿xixnaa ayi rahcabwaꞌ tu xa rzaꞌloh chieempa raꞌ nin dxuu nuꞌh nnah? ");
INSERT INTO zpvNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Rahbiza Ñiꞌh loh raꞌ ba: ―¿Xixnaa ayi rahcabwaꞌ tu cuun nin guigaꞌha guunn tu?, ");
INSERT INTO zpvNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","laasii sidela chyuulla chetachi xquelchiah tu loh guxchiisi, ya gaduhbi nin zenee ba yiꞌh para rwaaꞌ jusgahdu basiaꞌlda dxyiꞌdxyi cun laꞌh ba loh neziuhgah tin ayi gadzihnnee ba yiꞌh loh raꞌ guxchiisi laasii guxchiisi raꞌ chi zutiꞌdxi raꞌ ba yiꞌh loh raꞌ guixaꞌga, ya guixaꞌga raꞌ chi gusieꞌw raꞌ ba yiꞌh laꞌn lahtsidxiꞌba. ");
INSERT INTO zpvNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Per rñaan loh luꞌh, ayi gariaꞌh luꞌh laꞌn lahtsidxiꞌba chi hasta gusaaꞌ luꞌh chilli luꞌh garaa nin bwiꞌhnn luꞌh, chiꞌchiyi gutaꞌh raꞌ ba yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hohrchi gahca gwabiiga nuhn bwiinn raꞌ loh Jesuhs tin gwaguihtsi raꞌ ba xcweenta paaldaa bwiinn Galilea nin gudxiinn Pilahtu laꞌn guidoꞌ ya baguꞌchi Pilahtu llerihn nin guhchi raꞌ chi cun llerihn raꞌ ñimahla nin gwanee raꞌ ba ziga guhn loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Ta ruhnn tu lligaaba ziꞌchi guzahca bwiinn Galilea raꞌ chi laasii mahzi guyuuꞌ xtuhlda raꞌ ba loh bwiinn lahdxyi raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ñaan loh tu, ayi gaca ziꞌchi. Per sidela ayi gusaguꞌdzi stoꞌ tu loh Dxiohs ziꞌchi gahca saca garaa tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya xcweenta tsiꞌñu bichohnna bwiinn raꞌ nin guhchi chin gubihxi torre nin laa Siloeh yihca raꞌ ba, ¿ta ruhnn tu lligaaba guyuuꞌru xtuhlda raꞌ ba que bwiinn nin rii guihdxyi Jerusalehn? ");
INSERT INTO zpvNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ñaan loh tu, ayiza gaca ziꞌchi, per sidela ayi guchaꞌh tu ziga nabahan tu zuñihchi gahcaza tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chiꞌchi guzaꞌloh bwiiꞌyidxyiꞌdxyinee Jesuhs laꞌh raꞌ ba tuhbi cweenta, rahbi Ñiꞌh: ―Guyuuꞌ tuhbi daada bwiꞌhnnbiñih ba tuhbi llaan yahgañiigu loh xuh ba, ya guyuuꞌ tuhbi dxyih gwaguiaꞌha ba gu nuu xi ñiigu caa lohon, ya chin badzihn ba bwaꞌha ba ayi xi caatiiꞌ lohon, ");
INSERT INTO zpvNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","chiꞌchi rahbi ba loh bwiinn nin rahpa riꞌchi: “Bwaꞌha, guhca chohnna yihza rieꞌldaguiaꞌhan gu nuu xi ñiigu xcah loh yahga riiꞌ, per nin guduhvehsa nagahdxi guidxeelaꞌhn nin tuhbin. Mejor gutaꞌdxuñin, ¿xixgahn cabweꞌhesin xjweersi loh xuun?” ");
INSERT INTO zpvNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chiꞌchi guñiꞌ bwiinn nin rahpa riꞌchi, rahbi ba: “Daada, basaaꞌnan luulchima stuhbi yihza riiꞌ tin laꞌn gusaldaꞌh yuh nin nuu llaaꞌnan cwaachi gahcan xquiiꞌ man ");
INSERT INTO zpvNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tin guidiaꞌha nuꞌh tayi xi ñinahxi guicah lohon yihza zeꞌ ya sidela ayi xi guicah gahca lohon chiꞌchi guitaꞌdxuñin.” ");
INSERT INTO zpvNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ya tuhbi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel cagasiꞌdxi Jesuhs laꞌn tuhbi guidoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Riꞌchi zuu tuhbi gunnaꞌh nin rahcalluꞌhu naala tsiꞌñu bichohnna yihza laasii nuu tuhbi bwiinndxaaba stoꞌ ba nin bwiꞌhnn poompa dihtsi ba ayi nuu ganchiiꞌhin. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chin bwaꞌha Jesuhs loh ba, gudihdxyi Ñiꞌh laꞌh ba, rahbi Ñiꞌh loh ba: ―Gunnaꞌh, laꞌgueldxyihdxyi nin rahca luꞌh basaaꞌn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chin badziiꞌbanaa Ñiꞌh yihca gunnaꞌh chi lwehgusi banchii dihtsi ba, chiꞌchi guzaꞌloh cañiꞌ ba xa chuhla naa Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per daada nin rnabwaꞌ guidoꞌ chi bidxyiꞌchi ba laasii basiaca Jesuhs laꞌh gunnaꞌh chi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn, niꞌchin guzaꞌloh bwiiꞌyidxyiꞌdxyi ba loh raꞌ bwiinn, rahbi ba: ―Xoꞌpa dxyih zahca guunn bwiinn dziꞌn; laꞌn dxyih raꞌ chi dxiꞌ tu tin dxiaca tu, per dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn ayi dxiꞌ tu tin ayi rahca dziꞌn dxyih chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chiꞌchi guñiꞌ Jesuhs loh ba, rahbi Ñiꞌh: ―¡Bwiinn rusaguiꞌhi bwiinn! Sidela chyuulla tuhbi tu nahpa tuhbi guunn o tuhbi buhrra nee rdxahga ma ñihsa, ¿tayichiꞌh guixaachi tu ma chegaguee tu ma ñihsa dxyih nin ruziꞌlaaꞌdzi bwiinn raꞌ?, ");
INSERT INTO zpvNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ya gunnaꞌh riiꞌ naa llahga guehtu Abrahn guhcala tsiꞌñu bichohnna yihza nuuchiꞌbiduꞌh bwiinndxaaba laꞌh ba loh gueldxyihdxyi. ¿Tayi naadxiꞌh bwen taꞌh ba loh bwiinndxaaba nicala dxyih nin ruziꞌlaaꞌdzi bwiinn raꞌ tin guziꞌlaaꞌdziza ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya chin guhdzi Jesuhs ziꞌchi, baziꞌxtuhyi raꞌ nin rdxyiꞌchinee laꞌh Ñiꞌh, ya snuhn raꞌ bwiinn riahxi raꞌ ba pur garaa cohsarooꞌ nin cayuhnn Jesuhs pur laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Neezaa guñiꞌ Jesuhs, rahbi Ñiꞌh: ―¿Cuun nin rñah ziga rñah xquelrnabwaꞌ xteenn Dxiohs nee cun cuun nin guigaꞌha guchaꞌgabwaꞌñin? ");
INSERT INTO zpvNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Naann ziga tubi bwiiꞌdzi mortahsa nin ruhnn biñih tubi ndxiꞌhw loh xtahan ba, ya rtahnan rahcan tubi yahgarooꞌ, ya lliiꞌdzin ruhnn raꞌ maaniꞌhn xpichiehza raꞌ ma. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Neezaa guñiꞌ Jesuhs stuhbi cweenta loh raꞌ ba, rahbi Ñiꞌh: ―¿Xilaꞌh cun guunn garoopa xquelrnabwaꞌ Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Naan ziga levadura nin guguꞌchinaa tuhbi gunnaꞌh loh chohnna madxihdu harihn, ya levadura chi nahpa gusadxihin cohba chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zee Jesuhs tuhbi neziuh nin zee Jerusalehn, ya gaduhbi nin zeediiꞌdxi Ñiꞌh paaldaa guihdxyi raꞌ cun rraandxu raꞌ, baluuꞌyi Ñiꞌh bwiinn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chiꞌchi gunaabadxyiꞌdxyi tuhbi bwiinn chi loh Ñiꞌh, rahbi ba: ―Daada, ¿ta gulliaaꞌyiꞌhn naa raꞌ bwiinn nin calaꞌh loh xtuhlda raꞌ ñiꞌh? Chiꞌchi rahbi Jesuhs loh raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gulguiꞌhnn jweersi chuꞌtii tu nez rwaaꞌ pweerta biꞌtuꞌhn galoh tu tin dxyiꞌbi ziahanrooꞌ bwiinn riclaaꞌdzi chuꞌtii raꞌ ban per ayi guunn raꞌ ba gahn chuꞌtii raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ya snuhnsi rahca gusieꞌw bwiinn nin naa yihdzi Ñiꞌh rwaaꞌ yuuꞌ chi ya ayiru nuu canehz tiidxi tu, ziaꞌhan tu dihtsi yuuꞌ. Chiꞌchi soobaaloh gusihdzi tu rwaaꞌ pweerta guiñiꞌ tu loh ba: “Daada, guxaala rwaaꞌyihdzi luꞌh tin guidxuꞌtii nun”, chiꞌchi guiñiꞌ ba nnaa ba loh tu: “Ayi gaꞌnnahn chyu bwiinn tu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chiꞌchi saꞌloh guiñiꞌ tu, gahbi tu loh ba: “Bidxuunee nu, bidaꞌwnee nu, bidwaanee nu yiꞌh, nee basiꞌdxi gahca luꞌh laꞌh nu nez loh xneziuh raꞌ nu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chiꞌchi ziñiꞌ ba loh tu: “Per ñaan loh tu, ayi nuꞌnbwaꞌtiiꞌhihn laꞌh tu; mejor guldxiaa garaa tu laasii laꞌh tu nin ruhnn ganaalla dziꞌn dxaaba raꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chiꞌchi guꞌn tu cun hasta loh lahyi tu guichihchi taantu nalaasa nin saca tu chin gwaꞌha tu xpwiinn chieemparooꞌ tu ziga guehtu Abrahn, guehtu Isaac, guehtu Jacobo cun garaa guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs nuu gahca raꞌ ba loh xquelrnabwaꞌ Dxiohs llaaꞌndxibaaꞌ per laꞌh tu ayi gaca chuꞌtii tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chiꞌchi gaca gadzihn ziahan bwinziitu raꞌ nin dxiꞌ nez lahdu dahan dxiaaꞌ, nez lahdu ñaaꞌgueeta, nez lahdu rtahn gubihdxyi cun nez lahdu nin riaꞌzi gubihdxyi tin chuꞌtii raꞌ ba loh xquelrnabwaꞌ Dxiohs llaaꞌndxibaaꞌ. Riꞌchi zizohba raꞌ ba loh mweella. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Per nuu raꞌ nin ruhnn lligaaba gulliaaꞌ lasahca raꞌ ba nnah per chiꞌchi zacalasahca duxaru raꞌ ba, nuuza raꞌ nin ruhnn lligaaba lasahca duxa raꞌba nnah ya loh guelrnabwaꞌ chi ayi xi gacalasahcatiiꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dxyih chi gahca rahbi raꞌ nuhn fariseu loh Jesuhs: ―Bariaꞌh riiꞌ, bwaa; tin Herodes xclaaꞌdzi gadxiinn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Guldxiaa tin gulgahbi loh bwiinn rusaguiꞌhi bwiinn chi: “Bwaꞌha, nnadxyih cun guillii gabweꞌhehn bwiinndxaaba raꞌ nin nuu stoꞌ bwiinn raꞌ neezaa nin rahcalluꞌhu raꞌ gusiaꞌcahn hasta yiidxyii guꞌnnahn gahn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per nnah nahpa chezaꞌhn xneziuun nnadxyih cun guillii laasii ayi gaca gachi daada nin rñiꞌ xchiꞌdxyi Dxiohs caachiꞌhzi stuhbi guihdxyi sino que bweꞌzi tuhbidxiꞌh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Prohbiza laꞌh tu bwiinn Jerusalehn raꞌ! Rdxiinn tu daada raꞌ nin zeꞌgañiꞌ xchiꞌdxyi Dxiohs lahdxyi tu neezaa rusihdzidxiah tu yihca bwiinn raꞌ nin rxeꞌhla Dxiohs loh tu, tin gachi raꞌ ba. Ziahan bwelta guclaaꞌdzihn ñutiaaꞌhahn laꞌh tu ziga rutiaaꞌha dxiidxi cuuca lliiꞌniꞌhn ma tin raguuꞌlaꞌnxihyi ma laꞌh raꞌ lliiꞌn ma, per ayi guclaaꞌdzi tu bwen ñuhnn Dxiohs pur laꞌh tu ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gulguiaꞌha nnah dxiaꞌhandaꞌtsizi xquidoꞌroo tu, nen xñaxgaaꞌhn loh tu, ayiru gabiaꞌgarii gwaꞌha tu loon hastayi chin gadzihn dxyih nin gahbi tu: “Zuxchilli Dxiohs guunntaaꞌyi Ñiꞌh yihca bwiinn nin dxiꞌ guinabwaꞌ laꞌh nuꞌh pur xcweenta Dxiohs.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Chin guhlda tuhbi dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, gwatahw Jesuhs guelwahw rwaaꞌ yihdzi tuhbi bwiinn nin rnabwaꞌ loh fariseu raꞌ, cagataꞌtsisi nuhn fariseu guidiaꞌhan xi guunn Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","laasii nezloh Jesuhs zuu tuhbi daada nin nuu dxih gaduhbitiiꞌ tihxi ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh raꞌ bwiinn nin ruluuꞌyi lehyi neezaa loh raꞌ fariseu, rahbi Ñiꞌh loh raꞌ ba: ―¿Ta zaca gusiaꞌcahn tuhbi bwiinn nin rahcalluꞌhu dxyih nin ruziꞌlaaꞌdzi bwiinn o ayi gacan? ");
INSERT INTO zpvNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per laꞌh raꞌ ba dxyiitiiꞌ gurih raꞌ ba cun badaꞌwsi rwaaꞌ raꞌ ba. Chiꞌchi gucaꞌha Jesuhs bwiinn nin rahcalluꞌhu chi, basiaca Ñiꞌh laꞌh ba, gunabwaꞌ gahca Ñiꞌh biuꞌnehza ba ziaa ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chiꞌchi rahbi Ñiꞌh loh raꞌ fariseu: ―Sidela chyuulla tuhbi tu nahpa tuhbi buhrra o tuhbi guun, ya dxiaaba ma laꞌn tuhbi bizee, ¿tayi gabweꞌhechiꞌh tu ma dxyih chi gahca, nicala naan tuhbi dxyih nin rziꞌlaaꞌdzi bwiinn? ");
INSERT INTO zpvNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chiꞌchi ayi guhca ñusiaꞌgarii raꞌ ba dxyiꞌdxyi loh Ñiꞌh, ya cun dxyiitiiꞌ babwih raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Caywaꞌhasi Jesuhs xa riuꞌstoꞌ raꞌ bwiinn rbwii raꞌ ba yagaxiyi zaꞌca tin cwii raꞌ ba cweeꞌ raꞌ bwiinnlasahca, chiꞌchi guleꞌhe Ñiꞌh tuhbi cweenta loh raꞌ ba nin ruluuꞌyi, rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Chin guiduꞌhun luꞌh chee luꞌh tuhbi saaꞌ ayi guunn luꞌh pur soobaa luꞌh loh yagaxiyi zaꞌca, tin ayi nagah snuhnsi laꞌstuhbi nin mahzi lasahca que no yiꞌh laꞌgadzihn; ");
INSERT INTO zpvNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","chiꞌchi dxieꞌbiiga bwiinn nin baguhn yiꞌh zee luꞌh saaꞌ nnaa ba loh luꞌh: “Badiꞌhi yagaxiyi ca soobaa bwiinn riiꞌ”, ya chiꞌchi gaziꞌxtuhyi luꞌh chesoobaa luꞌh luulchima yagaxiyi nin zuu rwaaꞌ jwehra. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mahziru bwen, chin guiduꞌhun luꞌh guzee luꞌh tuhbi saaꞌ, soobaa luꞌh tuhbi yagaxiyi nin zuu luulchimatiiꞌ tin chin gadzihn bwiinn nin gudihdxyi yiꞌh zee luꞌh saaꞌ, nnaa ba loh luꞌh: “Xamihguꞌhn nezii gudiiꞌdxi sobanee luꞌh bwiinn raꞌ riiꞌ tin yagaxiyi riiꞌ nin mahzi lasahca.” Ya ziꞌchi gacalasahca luꞌh loh raꞌ bwiinn nin rii loh mweella, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","tin bwiinn nin rdxiꞌhyi xa gacalasahca ba mejor raziꞌxtuhyi ba delaanta loh raꞌ bwiinn, ya bwiinn nadoꞌlaaꞌdzi nahpa rahcalasahcaru ba nezloh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Rahbiza Ñiꞌh loh bwiinn nin baguhn laꞌh Ñiꞌh zee Ñiꞌh saaꞌ: ―Chin nuu luꞌh lligaaba guunn luꞌh tuhbi guelwahw zaꞌca, ayi gaguhn luꞌh nin rchaꞌga luꞌh nin bwihtsi luꞌh nin lasaaꞌ luꞌh nin xpisihn luꞌh nin rricu tin ayi laꞌraꞌba guibiaꞌgarii cwiidxyi raꞌ ba yiꞌh chetahw luꞌh guelwahw yihdzi raꞌ ba, ya nin bagaaꞌda luꞌh galoh laꞌngahlla gahca. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mahzi bwen chin guunn luꞌh tuhbi guelwahw zaꞌca gaguhn luꞌh bwiinn dxyihdxyi cun bwiinn nin rahca loh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tin ziꞌchi dxiahxi Dxiohs laasii ayi nuu gadxilli bwiinn raꞌ chi nin gudahw raꞌ ba loh luꞌh per Dxiohs gahca gadxillin chin gabiaꞌgarii gabahan bwiinn zaꞌca nin guhchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chin gudiiꞌdxi dxiahga tuhbi nin zohba loh mweella, chiꞌchi rahbi ba loh Jesuhs: ―Dxiahxi duxa raꞌ bwiinn nin cwih raꞌ gahw loh mweella chin gaca lañih hasta rnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chiꞌchi rahbi Jesuhs loh ba: ―Guyuuꞌ tuhbi daada bwiꞌhnn ba tuhbi lañihrooꞌ rwaaꞌ yihdzi ba, chiꞌchi gunabwaꞌ ba biduꞌhun ziahan bwiinn nin ñatahw raꞌ guelwahw rwaaꞌ yihdzi ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ya chin bigaꞌha hohra nin gahw raꞌ ba, chiꞌchi guxeꞌhla daada chi tuhbi xmooza ba gwacaꞌha laꞌh raꞌ bwiinn nin biduꞌhun raꞌ chi tin guzeetahw raꞌ ba, ya chin badzihn ba loh nin biduꞌhun raꞌ chi chetahw chiꞌchi rahbi ba: “Gulchoꞌho laꞌgaraatiiꞌ naaliistula.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chiꞌchi guzaꞌloh guñiꞌ cada tuhbigah raꞌ ba rahbi raꞌ ba ayi nuu chee raꞌ ba, tuhbi ba rahbi: “Gueꞌdu guziꞌn tuhbi taaꞌha loh yuh, nnah nahpa chaguiaꞌhañin rnaꞌbaꞌhn ayi guidxyiꞌchi luꞌh pur ayi saꞌhn”, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ya stuhbi ba rahbi: “Gueꞌdugah guziꞌn gaꞌyu nehza guun yannah nahpa cheguiꞌhnnanma prehba, niꞌchin ayi nuu saꞌhn”, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ya stuhbi ba rahbi: “Gueꞌdugah bachinaaꞌhahn, niꞌchin ayi nuu saꞌhn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ya chin babiaꞌgarii mooza chi, baganee bi rsohn chi loh xpallwaꞌn bi nin guxeꞌhla laꞌh bi, talguꞌnsi bidxyiꞌchi duxa daada nin rnabwaꞌ chi, chiꞌchi rahbilagaꞌh ba loh xmooza ba chi: “Carrih gwalaꞌh nez loh neziuhrooꞌ nez loh neziuh deꞌhe lahda guihdxyi tin dxieꞌnee luꞌh bwiinn prohbi, bwiinn cweeꞌ, bwiinn liinguu, cun bwiinn nin rahca loh ñiꞌh tin dxieꞌtahwnee raꞌ ba laꞌh nuꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Snuhn gudxyihru rahbi mooza chi loh daada chi: “Daada, laꞌnbwiꞌhnn gahn ziga gunabwaꞌ luꞌh per laꞌlugahri nuuru.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chiꞌchi rahbi daada chi loh ba: “Gwah loh raꞌ neziuh nin zeꞌ lahda guihdxyi ziitu raꞌ tin dxieꞌnee luꞌh bwiinn raꞌ nin gadxaꞌgachiꞌhzi luꞌh nezchi tin par chegadxah yihdzihn, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","nee rñaan loh luꞌh, nin tuhbi bwiinn nin biduꞌhun galoh ayi gahw raꞌ ba nin tuhbi rwaaꞌ raꞌ ba xquelwaawuhn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ya gaduhbi nin zeezah Jesuhs loh neziuh, ziahan bwiinn zenaꞌhla laꞌh Ñiꞌh, chiꞌchi gubiaꞌgarii Ñiꞌh guzaꞌloh cañiꞌ Ñiꞌh loh raꞌ ba, rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Sidela chyuulla dxieꞌnaꞌhla naꞌh, nahpa gantsiiꞌhi ba naꞌh, gucaꞌstoꞌ ba naꞌh ziahan taantu ziga nadziiꞌhi ba xpaah ba, xmaah ba, cheꞌhla ba, lliiꞌn ba, bwihtsi ba cun bizaaꞌn ba, nee gahcaza xquelnabahan ba. Sinoon ayi nuu dxieꞌnaꞌhla ba naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sidela nuu nin ayi xclaaꞌdzi gutiꞌdxiloh trabahjw ziꞌchi, ayiza nuu gaca raꞌ ba tuhbi xpwiiꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sidela chyuulla tuhbi tu xclaaꞌdzi guzaꞌ tuhbi yuuꞌrooꞌ ziahan xcwaꞌha, ¿tayi mwehrgalohdxiꞌh soobaa tu guunnxgah tu lligaaba guidiaꞌhan gu zahlda xmweeyi tu par guzaꞌloh tun?, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","laasii sidela simientuzi guzoꞌbaloh tu cayahca dxiaa garaa xmweeyi tu, ya chiꞌchi garaa bwiinn gusiꞌxtuhyi laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","chiꞌchi guuyi raꞌ ba: “Bwaꞌha bwiinn ca, gulahchixchihsi ba yuuꞌ, nee ayi bwiꞌhnn ba gahn ñaꞌlohon.” ");
INSERT INTO zpvNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O sidela tuhbi rrehyi guunn ba lligaaba chegachaꞌgadxihldxi ba stuhbi rrehyi, ¿tayidxiꞌh guunnxgah ba lligaaba guidiaꞌhan ta zahca guunn ba gahn cun loh tsiꞌh mihyisi xsuldahdu ba cun loh stuhbi rrehyi nin nahpa gahlda mihyi suldahdu? ");
INSERT INTO zpvNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ya sidela rguꞌbwaꞌ ba ayi guunn ba gahn chiꞌchi cun antes guixeꞌhla ba rsohn loh stuhbi rrehyi nin nahpa gahlda mihyi suldahdu cwidxyiistoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ya ziꞌchi laꞌh tu nin ayi xclaaꞌdzi gusaaꞌn garaa nin nahpa ñiꞌh mejor ayi dxieꞌnaꞌhla raꞌ niꞌchi naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ya rahbiza Jesuhs: ―Chuhla naa zihdzi, per sidela guñichin xquel nallihin, ¿xa gacaru gunnallihin guelwahw? ");
INSERT INTO zpvNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ayiru galluꞌyin nin para gunchaꞌyin loh yuh, ayiza nuu chuꞌbwihin loh xquiiꞌ ma. Mejor chuꞌbwihin hasta riuꞌbwih dxihlli. Ziꞌchi ruhnn tuhbi bwiinn naxihn; rzohbalohsi ba tuhbi cohsa, ya ayi ruzaꞌloh ban. Niꞌchin nnah nin nuu dxiahga ñiꞌh, gucaꞌdxiahga raꞌ ba xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Garaa raꞌ bwiinn nin rusadxihlli impweestu neezaa bwiinn raꞌ nin ayi ruhnn cweenta xlehyi Moisehs gwabiiga raꞌ ba loh Jesuhs tin bacaꞌdxiahga raꞌ ba dxyiꞌdxyi nin guñiꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Cun bwiinn fariseu raꞌ neezaa mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs guzaꞌloh cañiꞌ tohnta raꞌ ba loh Jesuhs, rahbi raꞌ ba: ―Bwiinn riiꞌ ruchaꞌga ba garaa raꞌ bwiinn nin nahpa duhlda neezaa rahwnee ba laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chiꞌchi guleꞌhe Jesuhs cweenta nin guluuꞌyi Ñiꞌh laꞌh raꞌ ba, rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Sidela chyuchiꞌhzi tuhbi tu nahpa tuhbi gaywaꞌh lliꞌhyi ya guizaꞌbi tuhbi ma, ¿tayi nahpadxiꞌh cwachigah tu za noventa y nueve ma loh dahan tin chegadxiꞌhyi tu nin bizaꞌbi hastayi gadxeela ma?, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ya chin gadxeela ma gudziiꞌba rwaaꞌyahnn tu ma taantu riahxi tu badxeela ma, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ya chin gadzihn tu yihdzi tu, chiꞌchi gutiaaꞌha tu nin ruchaꞌga tu cun xpisihn tu, gahbi tu loh raꞌ ba: “Guldxiahxinee naꞌh tin laꞌnbadxeela xiꞌhyihn nin bizaꞌbi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ziꞌchi naa ziga rucaꞌstoꞌ bwiinn xquidxaꞌh ba loqui nin naa ma. Ziꞌchi gahcaza rucaꞌstoꞌ Dxiohs nin nuu dxibaaꞌ laꞌh chyuchiꞌhzi bwiinn duhlda. Ya sidela rusaguꞌdzistoꞌ bwiinn chi chezah ba xneziuh Dxiohs, mahziru riahxinee duxa xaanjla raꞌ Ñiꞌh laꞌh bwiinn chi que no za noventa y nueve raꞌ ba nin ya zezah zaꞌca xneziuh Ñiꞌh ya naa bwiinn chi xpwiinn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Rahbiza Jesuhs: ―Ziꞌchi gahcaza tuhbi gunnaꞌh nin nahpa tsiꞌh mweeyi nin lasahca ya guizaꞌbi tuhbin, ¿tayi xchiꞌhn gucaꞌdxih ba tuhbi biaꞌñih tin gwaꞌh zaꞌca ba ya gutoꞌba ba garaa laꞌn yuuꞌ hasta que noyii gadxeela ban? ");
INSERT INTO zpvNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ya chin gadxeela ban, chiꞌchi gutiaaꞌha ba nin ruchaꞌga ba cun xpisihn ba, gahbi ba loh raꞌ ba: “Guldxiahxinee naꞌh tin laꞌnbadxeeꞌla xmweeꞌyihn nin bizaꞌbi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Rñaazahn loh tu, ziꞌchi gahcaza riahxinee xaanjla Dxiohs nin rii dxibaaꞌ pur nin rusaguꞌdzistoꞌ tuhbi bwiinn duhlda chezah ba xneziuh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bwiiꞌyidxyiꞌdxyiza Jesuhs cweenta riiꞌ loh raꞌ ba, rahbi Ñiꞌh: ―Guyuuꞌ tuhbi bwiinn guyuuꞌ chiohpa lliiꞌn ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ya guyuuꞌ tuhbi dxyih rahbi tuhbi nin laweelda: “Paah, guniꞌhi luꞌh xpiehn luꞌh nin ruhnn tucahri guicaꞌhahn.” Ya chiꞌchi bwiꞌhnn garoolda xpah raꞌ bi hasta naa xteenn ba tin gucaꞌha raꞌ bi hasta ruhnn tucahri laꞌh raꞌ bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ya chin guhca paaldaa dxyih, talguꞌnsi batooꞌ nin laweelda garaa hereensi nin badiꞌhi xpaah bi gucaꞌha bi, ya mweeyi chi nuꞌa bi zee bi zihtu hasta stuhbi nasiohn, ya chin badzihn bi riꞌchi baxiꞌn bi xmweeyi bi chi loh gunnaꞌh dxaaba cun loh raꞌ xica cohsa dxaaba. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ya chin barah mweeyi chi baxiꞌn bi, badzihn tuhbi gubihn duxa guihdxyi ziitu hasta nuu bi guzohbaloh ayi xi gahw bi cachiaꞌhn duxa bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chiꞌchi gwachiꞌhyi bi dziꞌn loh tuhbi bwiinn guihdxyi chi guunn bi, ya bwiinn chi badiꞌhi ba dziꞌn guunn bi guyaꞌn bi xcuuchi ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ya taantu nin bichiaꞌn duxa bi guclaaꞌdzi bi ñahw bi dxihllilaaꞌ nin cayahw raꞌ cuuchi, laasii ayi guyuuꞌ xi ñahw bi nez chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Ya gaduhbi cadiiꞌdxi bi trabahjw chi biaꞌñih loh xigaaba bi bwiꞌhnn bi lligaaba nastoꞌ bi: Bwaꞌha, paaldaaru mooza nahpa xpaaꞌhn ruhnn xtsiꞌn ba, hasta ruhnnsohbra nin rahw raꞌ ba, nen naꞌh nezriiꞌ cayahchigubihnaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mejor guibiaꞌgariin hasta nuu xpaaꞌhn, chin gadzihnaꞌhn gaꞌpihn loh ba: “Paah, bayinnahsihn bañiꞌchihn loh Dxiohs cun loh yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ayiru ruhnn marehsa guiñiꞌ luꞌh loon ziga lliiꞌn luꞌh sino que guunn luꞌh trahtu naꞌh ziga tuhbi xmoozasi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chiꞌchi banaꞌzu nehza bi ziaa bi yihdzi xpaah bi. Zihturooꞌ ru zegadzihn bi chin bwaꞌha xpaah bi laꞌh bi, balahsastoꞌ ba biaa ba laꞌh bi, chiꞌchi biriaꞌhgalluꞌn ba bagachiꞌloh ba laꞌh bi, chin badzihn ba hasta zieꞌ bi, gudiꞌdzi ba gudahw ba rwaaꞌ bi, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","chiꞌchi rahbi bi loh ba: “Paah, bayinnahsihn laꞌnbañihchi loh luꞌh; ayiru ruhnn tucahri guiñiꞌ luꞌh naꞌh ziga lliiꞌn luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per guñiꞌ xpaah bi loh raꞌ xmooza ba, rahbi ba: “Gulcheteꞌhe lahdxi nin mahzi chuhla gahcu bi, nee ñihyi dxieꞌnee tu cuꞌ tu bacwihnnaa bi dxieꞌnee gahca tu tuhbi nehza gueldxyihdxyi gucaꞌh tu ñaaꞌ bi, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","tin checaꞌha gahca tu tuhbi guunn bweezuꞌhn nin mahzi narooꞌ chiinn tu guidaꞌw nuꞌh tin guidiꞌhnn nuꞌh tuhbi lañihrooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","laasii lliiꞌnahn riiꞌ bwiꞌhnnaꞌhn lligaaba guhchi bi nee nnah gulguiaꞌha laꞌbi bieꞌ; ayi bwiꞌhnnaꞌhn lligaaba ñwaꞌharuhn loh bi per nnah gulguiaꞌha laꞌbi bieꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ya ziꞌchi cayahca, ya stuhbi lliiꞌngaꞌn ba zeguiꞌhnn dziꞌn loh dahan. Ya chin guhlda gubiaꞌgarii bi ziagadzihn gahxu bi rwaaꞌ yihdzi bi chin bihn bi cayuꞌlda raꞌ muusca rigadxiaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chiꞌchi gudihdxyi bi tuhbi mooza nin zuu riꞌchi gunabadxyiꞌdxyi bi loh ba, rahbi bi: “¿Xixniꞌca cayahca rwaaꞌ yuuꞌ?” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chiꞌchi rahbi mooza chi: “¿Tayi rwaꞌha luꞌh bwihtsi luꞌh nin gwarraniichi gubiaꞌgarii? Niꞌchin nin gunabwaꞌ xpaah luꞌh bidxiinn nu tuhbi guun bweezuꞌhn nin mahzi narooꞌ tin gaca tuhbi lañih laasii nazaꞌca bwihtsi luꞌh gubiaꞌgarii.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chin bihn bi garaa niꞌchi ayi nnaa bi dxiuꞌgarii bi yihdzi bi taantu rdxyiꞌchi bi; chiꞌchi biriaꞌ xpaah bi, rahbi ba loh bi: “Xiiꞌhihn, biuꞌgarii.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chiꞌchi rahbi bi loh xpaah bi: “Bwaꞌha, paaldaala yihza cayuꞌnnahn dziꞌn loh luꞌh ruzoꞌbadxiaagahn garaa dxyiꞌdxyi nin rñiꞌ luꞌh loon nen nin tuhbi chihva biꞌtuꞌhn ayi baniꞌhi luꞌh ñahchi ñahcachaꞌyi tuhbi guelwahw para nin ruchaꞌgaꞌhn; ");
INSERT INTO zpvNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","per bayinnahsihn laꞌlliiꞌn luꞌh nin baxiꞌn xmweeyi luꞌh loh raꞌ gunnaꞌh dxaaba bieꞌ yannah gunabwaꞌ luꞌh guhchi tuhbi guun bweezuꞌhn nin mahzi narooꞌ caguihn luꞌh bi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Chiꞌchi rahbi xpaah bi loh bi: “Xiiꞌhihn, loh gahcan zuu luꞌh, nee garaa nin naꞌpahn naa xteenn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per nnah ruhn marehsa guidiꞌhnn nuꞌh lañih dxiahxi nuꞌh laasii bwaꞌha laꞌbwihtsi luꞌh nin bwiꞌhnnaꞌhn lligaaba guhchi ayiru ñwaꞌhan loh ñiꞌh laꞌbi bieꞌ niꞌchin riahxiꞌhn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bwiiꞌyidxyiꞌdxyiza Jesuhs stuhbi cweenta loh raꞌ xpwiinn Ñiꞌh, rahbi Ñiꞌh: ―Guyuuꞌ tuhbi bwiinn rricu nahpa ba tuhbi mooza nin rnabwaꞌ lozdemahzi raꞌ xmooza ba ya guyuuꞌ tuhbi bweelta gwaguihtsi paaldaa xmooza ba loh ba, rahbi raꞌ ba: “Xmooza luꞌh nin rnabwaꞌ laꞌh nu ruxiꞌnzi ba xixteenn luꞌh”, ");
INSERT INTO zpvNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","chiꞌchi gudihdxyi bwiinn rricu chi mooza chi, rahbi ba loh ba: “¿Xi cohsa riiꞌ rñiꞌ raꞌ snuhn mooza pur yiꞌh? Nnah guniꞌhi luꞌh cweenta xteenn xtsiꞌn luꞌh tin mejor ayiru guinabwaꞌ luꞌh xmoozaraꞌhn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chiꞌchi cayuhnn bwiinn nin rnabwaꞌ loh raꞌ mooza chi lligaaba, nastoꞌ ba: “¿Xaxguꞌnchiꞌhn nnah nin gabweꞌhe xpallwaꞌnaꞌhn naꞌh loh dziꞌn? Ayiꞌhn jweersi guꞌnnahn dziꞌn loh yuh, nee xtuhyiza loon cweꞌhen cardah. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aah! Laꞌnnaꞌnnahn xa guꞌnnahn chin ayi gaꞌpahn dziꞌn nahpa zibwihdxyi raꞌ nin ruchaꞌgaꞌhn naꞌh rwaaꞌ yihdzi raꞌ ba.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chiꞌchi gudihdxyi mooza chi tuhbigah raꞌ bwiinn nin nuzaꞌbi loh bwiinn rricu chi, chiꞌchi rahbi ba loh bwiinn nin badzihn galoh: “¿Balaaca nuzaꞌbi luꞌh loh xpallwaꞌnaꞌhn?” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chiꞌchi rahbi bwiinn chi: “Nuzaꞌbiꞌhn tuhbi gaywaꞌh barrihyi nsehchi.” Chiꞌchi rahbi mooza chi: “Dee naa xnohta luꞌh yannah guzohba riꞌca tin bwiꞌhnn stuhbin pur chwaꞌhbitsiꞌhsin.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ya chiꞌchi gunabadxyiꞌdxyi ba loh stuhbi ba: “Ya yiꞌh, ¿balaca nuzaꞌbi luꞌh?” chiꞌchi rahbi ba: “Tuhbi gaywaꞌh manguchi trihgu.” Chiꞌchi rahbi ba: “Dee naa xnohta luꞌh; guzohba riꞌca bwiꞌhnn stuhbin pur ochehntasin.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ya chin bihn xpallwaꞌn mardoommi dxaaba chi xi bwiꞌhnn ba, chiꞌchi guñiꞌ zaꞌca xpallwaꞌn ba pur laꞌh ba laasii bwaꞌha ba balaaca nin rahcabwaꞌ xmooza ba chi. Ziꞌchi gahcaza bwiinn raꞌ nin ayi nuꞌnbwaꞌ xchiꞌdxyi Dxiohs mahzi rahcabwaꞌ raꞌ ba loh xasuunto raꞌ ba tuhbi ba cun stuhbi ba que ziga bwiinn raꞌ nin nuꞌnbwaꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ñaan loh tu gulchiꞌhyi nin guchaꞌga tu cun cohsa raꞌ nin lasahca loh guidxyiyuh dxaaba riiꞌ tin chin garah xixteenn tu chiꞌchi zacaꞌha Dxiohs laꞌh tu para guziaa tu dxibaaꞌ nez hasta gaca yihdzi tu para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Garaa nin ruhnn zaꞌca raꞌ dziꞌn loh tuhbi dziꞌn biꞌtuꞌhn zahcaza guunn zaꞌca raꞌ ba dziꞌn loh tuhbi dziꞌnrooꞌ; per nin ayi gaca guunn zaꞌca dziꞌn loh tuhbi dziꞌn biꞌtuꞌhn ayi gacaza guunn zaꞌca raꞌ ba dziꞌn gurooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Niꞌchin sidela laꞌh tu ayi guunn tu gahn cwinee zaꞌca tu guelnazaꞌca raꞌ xteenn guidxyiyuh dxaaba riiꞌ, ¿xa guniꞌhi chiꞌh Dxiohs guelna zaꞌca xteenn Ñiꞌh laꞌh tu? ");
INSERT INTO zpvNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ya sidela laꞌh tu ayi gaca tu bwiinn zaꞌca cun xixteenn stuhbi bwiinn, ¿ta ruhnn chiꞌh tu lligaaba guniꞌhi Dxiohs xica cohsa raꞌ laꞌh tu nin gaapa tu? ");
INSERT INTO zpvNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ayi nin tuhbi mooza guunn gahn guunn dziꞌn loh chiohpa ballwaaꞌn laasii zidxyiꞌchinee ba tuhbi ba ya stuhbi ba dxiahxinee ba; neezaa guzoꞌbadxiahga ba xchiꞌdxyi tuhbi xpallwaaꞌn ba ya stuhbi xpallwaaꞌn ba ayi guunn ba cweenta laꞌh ba. Niꞌchin ayi tuhbi bwiinn nin guunn xtsiꞌn Dxiohs nee neezaa gucaꞌstoꞌ ba guel lasahca xteenn guidxyiyuh dxaaba riiꞌ; ayi rgaꞌhan ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ya chin bihn raꞌ bwiinn fariseu dxyiꞌdxyi raꞌ chi, guzaꞌloh cagallihdzinee raꞌ ba laꞌh Jesuhs laasii laꞌh raꞌ ba zeenaꞌhla raꞌ ba puura cohsa nin lasahca, ");
INSERT INTO zpvNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Bayi laꞌh tu pur nez guiñiꞌ zaꞌca bwiinn loh tu rdxiꞌhyi tu per Dxiohs nuꞌnbwaꞌdziꞌtsi Ñiꞌh lligaaba dxaaba nin nuu stoꞌ tu laasii garaa nin lasahca par bwiinn niꞌchipaꞌ raꞌ nin rbihxistoꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Rahbiza Jesuhs: ―Hasta dxyih nin biꞌ Jwahn nin ruroꞌbañihsa guyuuꞌ xlehyi Moisehs neezaa xchiꞌdxyi daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs, per chin biꞌ Jwahn guzaꞌloh cadiꞌchi dxyiꞌdxyi xteenn xquelrnabwaꞌ Dxiohs; niꞌchin nin ziahan bwiinn cadxiꞌhyi raꞌ ba xa chuꞌtii raꞌ ba loh xquelrnabwaꞌ Dxiohs cun lajweersi. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Per mahzi ayi guinagahn ñichiloh dxibaaꞌ cun guidxyiyuh que par ñichiloh garaa dxyiꞌdxyi nin bacaꞌh Moisehs; hasta nin tuhbi lehtra dxyiꞌdxyi chi ayi ñichilohon. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Rahbiza Jesuhs: ―Sidela tuhbi bwiinn taaꞌha ba cheꞌhla ba ya guicaꞌha ba stuhbi gunnaꞌh, ya ziꞌchi canee lasaaꞌ raꞌ ba zigazi xtuꞌh raꞌ ba. Neezaa tuhbi bwiinn nin racaꞌha tuhbi gunnaꞌh nin gulaaꞌha cheꞌhla Ñiꞌh, neezaa niꞌchi rguꞌtii duhlda laasii pur caneesi ba cheꞌhla stuhbi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Rahbiza Jesuhs: ―Guyuuꞌ tuhbi bwiinn rricu guhta ba puur lahdxi zaꞌca garaa dxyihtiiꞌ ruhnn ba lañih. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nee guyuuꞌza tuhbi bwiinn prohbi nin biriaꞌhlah Lásaro, guhtacweeꞌ ba rwaaꞌ xleeꞌ bwiinn rricu chi. Guillii-guillii rbweꞌhe ba cardah cun neezaa guyuuꞌ guiiꞌdxiu nin riaa tihxi ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","hasta bwehcu raꞌ riabiiga rlluhpi loh guiiꞌdxiu nin nuu tihxi ba, ya cohsa raꞌsi nin riaaba llaaꞌn mweella rricu chi guclaaꞌdzi ba ñahw ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ya dxyih nin guhchi bwiinn prohbi chi bieꞌgalliꞌhi xaanjla Dxiohs xaalma ba tin ziaganee raꞌ ba ñiꞌh hasta nuu guehtu Abrahn. Chin guhldaza guhchi bwiinnrriicu chi, chiꞌchi bigaꞌtsi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ya bwiꞌhnn tucahri bwaa ba gabihldxyi hasta riaa raꞌ garaa bwiinn nin riuuꞌ xtuhlda raꞌ ñiꞌh. Chiꞌchi guteesaloh ba bwaꞌha ba zihtu hasta nuu Abrahn cun Lásaro, ");
INSERT INTO zpvNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","chiꞌchi gudidxyidxiah ba, rahbi ba loh Abrahn: “¡Paah, paah Abrahn!; balahsastoꞌ luꞌh naꞌh guxeꞌhla Lásaro cuu ba bacwihnnaa ba loh ñihsa tin dxieꞌgasagaꞌldiu ba luudxihn pur taantu trabahjw nin cagatiꞌdxiꞌhn loh bwehla riiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Chiꞌchi rahbi Abrahn: “Xiiꞌhihn, basazaꞌstoꞌ luꞌh chin gubahan luꞌh loh guidxyiyuh gohpa luꞌh garaatiiꞌ cohsa raꞌ badiꞌhi guuxta stoꞌ luꞌh, ya Lásaro ayi xi gohpa ba niꞌchin gubahan guelzii ba, yannah laꞌhba cagaziꞌlaaꞌdzi ba, ya yiꞌh ruhnn tucahri tiidxi luꞌh trabahjw. ");
INSERT INTO zpvNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nen ayiza nuu tiidxi Lásaro riꞌca laasii nuu tuhbi bataaꞌha rooꞌ galaayi hasta dxuu nuꞌh, niꞌchin nin rii lahdu riiꞌ ayi nuu dxiꞌ raꞌ ba lahdu ca ya neezaa nin rii lahdu ca ayi nuuza dxiꞌ raꞌ ba lahdu riiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chiꞌchi rahbi rricu chi loh ba: “Rñiꞌ nalaꞌsahn loh luꞌh paah Abrahn tin guixeꞌhla luꞌh Lásaro yihdzi xpaaꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tin cheguihtsi ba loh raꞌ gaꞌyu bwiꞌtsihn nin nuuꞌ tin guchaꞌh xigaaba raꞌ ba chezah raꞌ ba xneziuh Dxiohs tin ayi dxiꞌ raꞌ bi lugahri riiꞌ hasta rdiiꞌdxi bwiinn trabahjw duxa.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chiꞌchi rahbi Abrahn loh ba: “Laꞌh raꞌ ba nahpa dxihtsi nin caa xlehyi Moisehs neezaa xchiꞌdxyi daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs; mejor guzoꞌbadxiahga raꞌ ba dxyiꞌdxyi raꞌ chi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ya rricu chi guñiꞌ, rahbi ba: “Guchii luꞌh paah Abrahn, per sidela tuhbi bwiinn nin guhchila chegañiꞌ loh raꞌ bi, zuchaꞌh xigaaba raꞌ bi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per Abrahn rahbi: “Per sidela ayi guzoꞌbadxiahga raꞌ ba xchiꞌdxyi Moisehs neezaa xchiꞌdxyi daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs, ¿xilaꞌhxchiꞌh tuhbi bwiinn nin guhchi chechiistoꞌ raꞌ ba?” ");
INSERT INTO zpvNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Nahpa nuu cohsa raꞌ nin ruhnn pur riuuꞌ xtuhlda raꞌ bwiinn, per prohbiza bwiinn nin rguꞌtii laꞌh raꞌ bwiinn loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Xlawaaꞌha chyu gusaaꞌn gusaguiꞌhi stuhbi bwiinn laꞌh biñiꞌn chuu xtuhlda bi, mejor guchiꞌbi raꞌ ba tuhbi dxiahrooꞌ yahnn nin rusaguiꞌhi chi tin gulaꞌha raꞌ ba laꞌh ba loh ñihsadoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gulgahca nasiin. Sidela bwihtsi tu guñihchi loh tu, gulguiñiꞌ loh bi pur nin bwiꞌhnn bi, ya sidela gadxaꞌh xigaaba bi mejor gusiaꞌldastoꞌ tu nin bwiꞌhnn bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nicala gahdzi bweelta guñihchi bi loh tu ya gahdziza bweelta dxiꞌ bi tin nnaa bi: “Ayiru gabiaꞌgarii guꞌnnañin stuhbi”, nahpa gusiaꞌldastoꞌ luꞌh nin bwiꞌhnn bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chiꞌchi rahbi nin naa raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Daada, gacanee luꞌh laꞌh nu tin mahziru chechiistoꞌ nu xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Sidela laꞌh tu ñachiistoꞌ tu xchiꞌdxyi Dxiohs, mahz balaaquiꞌhn ziga tuhbi bwiiꞌdzi biꞌtuhn xteenn mortahsa ñahca ñahbi tu loh yahgaroo ca: “Biyaꞌdxu riꞌca tin bwaa galaayi loh ñihsadoꞌ riꞌchi soobaa luꞌh”, guzoꞌbadxiahgan xchiꞌdxyi tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Rahbiza Ñiꞌh: ―¿Chyu tuhbi tu nahpa tuhbi mooza nin raaꞌn o nin rahpa guidxaꞌh ya gahbi bwiinn chi loh ba chin gabiaꞌgarii ba loh dahan: “Rii gudaaꞌ, soobaa luꞌh tin gahw luꞌh”? ");
INSERT INTO zpvNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pwehda ayi nin tuhbi bwiinn nin guiñiꞌ ziꞌchi. Pwehda gahbi tu: “Bwiꞌhnnchaꞌyi xi gahwxchiin neezaa nin gueeꞌhehn, chiꞌchi gacu luꞌh xahba nayaa luꞌh tin cwaachi luꞌh xi gaawuhn loh mweella, ya chin chaꞌloh gaawuhn chiꞌchi gahwgaꞌh luꞌh yiꞌh neezaa guee luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ya guidiaꞌhan nuꞌh ¿gu nuu tuhbi bwiinn nin rahbi: “Zuxchilli luꞌh saca bwiꞌhnn luꞌh niꞌca”? Guyaa, pwehda ayi nin tuhbi bwiinn nin guiñiꞌ ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ziꞌchi gahcaza laꞌh tu, chin chaꞌloh guunn tu garaa dziꞌn raꞌ nin gunabwaꞌ Dxiohs loh tu, nahpa guiñiꞌ tu loh Dxiohs: “Laꞌhnu naa nu mooza nin ayi xi lasahca laasii bidiꞌhnnzi nu cohsa raꞌ nin nahpa guidiꞌhnn nu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gaduhbi zezah Jesuhs neziuh nin zee guihdxyi Jerusalehn, gudiiꞌdxi Ñiꞌh loh rregiohn Samaria cun loh rregiohn Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ya chin guyuꞌtii Ñiꞌh tuhbi guihdxyi biꞌtuꞌhn chiꞌchi gwagachaꞌloh tsiꞌh bwiinn raꞌ nin rahchyi guiiꞌdxiu tihxi raꞌ Ñiꞌh laꞌh Ñiꞌh, zihturu guchiꞌloh raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","chiꞌchi guñiꞌ raꞌ ba jweersi, rahbi raꞌ ba: ―¡Jesuhs, mwehsu! ¡Balahsastoꞌ luꞌh laꞌh nu! ");
INSERT INTO zpvNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ya chin bwaꞌha Jesuhs laꞌh raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulchee hasta nuu bixohza tin gulgaluuꞌyi laꞌh ba laꞌtu biaca. Ya gaduhbi zee raꞌ ba zegaluuꞌyi tihxi raꞌ ba laꞌh bixohza ziga nanchii laꞌguiiꞌdxiu chi guñihchilohtiiꞌ tihxi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ya tuhbi ba chin bwaꞌha ba laꞌba biaca, talguꞌnsi gubiaꞌgarii ba ziaa ba hasta zuu Jesuhs, gaduhbi ziagazah ba guzaꞌloh rñiꞌ ba jweersi, rahbi ba: ―¡Dxiohssihn chuhla naa! ");
INSERT INTO zpvNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ya chin badzihn ba hasta zuu Jesuhs, bazuꞌnllihbi ba baruꞌhn ba hasta loh yuh nez loh Jesuhs tin cagadiꞌhi ba guelzuxchilli loh Ñiꞌh. Ya coma bwiinn chi bwiinnziitu ba, bwiinn rregiohn Samaria ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","chiꞌchi rahbi Jesuhs loh ba: ―Per ¿tayi tsiꞌdxiꞌh naa tu biaca tu? ¿Cuunxchiꞌh zagaꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ta tuhbidxiꞌh bwiinnziitu riiꞌ gubiaꞌgarii zeꞌganiꞌhi guelzuxchilli saca nin biaca ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chiꞌchi rahbi Jesuhs loh bwiinn chi: ―Gwasuꞌnchii tin bwaa. Laꞌluꞌh biaca nnah laasii gwachiistoꞌ luꞌh xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chiꞌchi gunabadxiꞌdxyi raꞌ bwiinn loh Jesuhs cuuca gadzihn xquelrnabwaꞌ Dxiohs, chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Dxyih nin saꞌloh guinabwaꞌ Dxiohs guidxyiyuh ayi gacan tuhbi sehn nin gacabwaꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","tin par ayi gaca guiñiꞌ tu: “Riiꞌ cayahca niꞌca”, o gahbi tu: “Riꞌchi cayahcan”, laasii dez nnah laꞌDxiohs canabwaꞌla paaldaa bwiinn nin dxaꞌga loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Ziuuꞌ tuhbi dxyih nin guiclaaꞌdzi tu gwaꞌha tu naꞌh, nin naan Lliiꞌn Dxiohs nin naa ndxiꞌhw, gabiaꞌgariin loh guidxyiyuh tin guinabwaꞌn; nicala tuhbidxiꞌh dxyih guiclaaꞌdzi tu gwaꞌha tu naꞌh per ayi gaca gwaꞌha tu naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nee ziuuꞌza tuhbi nin guiñiꞌ loh tu: “Riiꞌ laꞌba nuu”, o “Riꞌchi laꞌba nuu”, per rñaan loh tu ayi chee tu nen ayiza chenaꞌhla tu laꞌh ba ");
INSERT INTO zpvNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","tin zahca ziga rahca chin rdxiñaaꞌh llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per galoh gaca raꞌ cohsa chi nahpa gutiꞌdxilohxgah ba trabahjw. Ya garaa bwiinn raꞌ nin rii guidxyiyuh nnah, guidxyiꞌchinee raꞌ ba cun gusaꞌcazii raꞌ ba laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ziga nin guhca chin guyuuꞌ tuhbi bwiinn chieemparooꞌ nin biriaꞌlah Noeh, ziꞌchi gahcaza gaca chin guibiaꞌgariin, ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Laꞌn dxyih raꞌ nin gubahan guehtu Noeh chi, garaa bwiinn gudahw raꞌ ba gwaaꞌ raꞌ ba, bachinaa raꞌ ba guleꞌdxiꞌhn lliiꞌndxaꞌpa raꞌ ba gucaꞌha biꞌnxtuhbi raꞌ tin bachinaa raꞌ bi hasta badzihn dxyih chin guyuuꞌtii Noeh laꞌn barcurooꞌ nin bwiꞌhnnchaꞌyi gahca ba. Chiꞌchi badzihn tuhbi ñihsadxiahxihn gudxiinnan laꞌh garaa raꞌ bwiinn nin ayi bwiꞌhnn cweenta xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ziꞌchi gahcaza guhca laꞌn dxyih raꞌ chin gubahan guehtu Lot: Snuhn raꞌ bwiinn gudahw gwaaꞌ raꞌ ba, guziꞌ raꞌ ba nee batooꞌ raꞌ ba, gulahchi raꞌ ba biñih bwiꞌhnnchaꞌyi raꞌza ba yuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ya chin bariaꞌh Lot loh guihdxyi Sodoma, guzaꞌloh biaaba dxih llaaꞌndxibaaꞌ cun cobadehldaꞌh, bañihchilohon garaa raꞌ bwiinn duhlda nin ayi bwiꞌhnn cweenta xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ziꞌchi gahcaza gaca laꞌn dxyih raꞌ chin guibiaꞌgarii Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ya laꞌn dxyih raꞌ chi sidela chyuulla caa yihca yihdzi Ñiꞌh nen nahpa ba xilla laꞌn yuuꞌ mejor ayi guunn ba pur chegaleꞌhe ban, mahzi lwehgu guzee ba. Ya sidela chyuulla zuu loh dahan, mejor ayi guibiaꞌgariiru yihdzi ba; talguꞌnsi guzee ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¿Tayi riagannastoꞌ tu xi guhca cheꞌhla guehtu Lot? ");
INSERT INTO zpvNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ya nin guiclaaꞌdzi gaapa xquelnabahan ñiꞌh loh guidxyiyuh riiꞌ, zuñihchi ban; per nin gudziꞌba xquelnabahan ñiꞌh loh guidxyiyuh riiꞌ xcweenta xchiꞌdxyi raꞌn, zahpa ba guelnabahan llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ñaan loh tu, dxyih nin gabiaꞌgarii Lliiꞌn Dxiohs nin naa ndxiꞌhw gaca ziga naꞌ chiohpa bwiinn loh tuhbi daaꞌ, tuhbisi ba guzee ya stuhbi ba dxiaꞌncah; ");
INSERT INTO zpvNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","o loh chiohpa gunnaꞌh nin riiyuhta, tuhbisi ba guzee ya stuhbi ba dxiaꞌhan; ");
INSERT INTO zpvNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","neezaa chiohpa bwiinn raꞌ nin rii loh dahan, tuhbisi ba guzee ya stuhbi ba dxiaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ya chin bihn raꞌ ba dxyiꞌdxyi raꞌ chi, chiꞌchi gunabadxyiꞌdxyi raꞌ ba loh Ñiꞌh, rahbi raꞌ ba: ―Daada, ¿canehz gaca raꞌ cohsa riiꞌ? Chiꞌchi rahbi Jesuhs: ―Hasta naꞌ raꞌ bwiinnguuchi, riꞌchi gadiaaꞌha raꞌ bwiichi. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bwiiꞌyidxyiꞌdxyiza Jesuhs stuhbi cweenta loh raꞌ ba tin gacabwaꞌ raꞌ ba nahpa cwiidxyi-guinaaba raꞌ ba Dxiohs gaduhbi chieempa nee ayi guiriaꞌhgahnza raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ya rahbi Ñiꞌh loh raꞌ ba: ―Guyuuꞌ tuhbi guihdxyi hasta guyuuꞌ tuhbi jwehsi nin ayi gwachiistoꞌ ñiꞌh xchiꞌdxyi Dxiohs cun neezaa ayi bwiꞌhnn cweenta ba bwiinn lasaaꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Guihdxyi chi gahca guyuuꞌ tuhbi gunnaꞌhviuhda, guillii-guillii riah ba loh jwehsi chi riaganaaba guxchiisi ba bwiinn nin rdxyiꞌchinee laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Per jwehsi chi ayi gunnah ba ñuhnn ba guelguxchiisi par ñahcanee ba gunnaꞌhviuhda chi, per pur taantu guillii-guillii riah ba, chiꞌchiyi bwiꞌhnn jwehsi chi lligaaba: “Ayi xi ruhnn nicala ayi riachiistoꞌn xchiꞌdxyi Dxiohs nee nicalaza ayi ruhnncweeꞌntahn bwiinn raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mahzi guꞌnncahn guelguxchiisi nin xclaaꞌdzi gunnaꞌh riiꞌ tin ayiru guunn ba llahn naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgacaꞌdxiahga xi rñiꞌ jwehsi dxaaba rii. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ya Dxiohs, ganaalla dziꞌn zaꞌca ruhnn Ñiꞌh. Sidela ziꞌchi ruhnn Ñiꞌh, ¿caxdxiaꞌn ayi gacanee Ñiꞌh laꞌh raꞌ bwiinn nin gulii Ñiꞌh cun nin nadziiꞌhi Ñiꞌh sidela dxyih-nagueꞌla rnaaba raꞌ ba loh Ñiꞌh guunn Ñiꞌh guelguxchiisi para laꞌh raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rñaan loh tu, lwehgu gahca zuhnn ba guelguxchiisi para laꞌh raꞌ ba. Per chin gabiaꞌgariin, ziga naan Lliiꞌn Dxiohs nin naa ndxiꞌhw guidxyiyuh stuhbi, diaꞌhan ¿gu zidxeelaꞌhn bwiinn nin riachiistoꞌ ñiꞌh xchiꞌdxyiꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bwiiꞌyidxyiꞌdxyiza Jesuhs stuhbi cweenta loh raꞌ ba laasii paaldaa raꞌ ba ruhnn lligaaba nayaachi, rahbi raꞌ ba bwiinn nayaa raꞌ ba ya snuhn raꞌ ba pur bwiinn duhlda raꞌ ba rucaꞌchiah raꞌ ba. Niꞌchin rahbi Jesuhs loh raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Guyuuꞌ chiohpa bwiinn, gwah raꞌ ba laꞌn guidoꞌ tin guiñiꞌnee raꞌ ba Dxiohs. Tuhbi ba naa fariseu ya stuhbi ba naa nin rusadxihlli impweestu. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nin naa fariseu chi guzuꞌnchii ba tin guñiꞌ ba loh Dxiohs: “Daada, Dxiohs; caganiꞌhihn guelzuxchilli loh luꞌh saca ayi guhcaꞌhn ziga snuhn raꞌ bwiinn ziga nin rbaaꞌn, nin nadxiipadxyiꞌdxyi, nin nuu xtuꞌh ñiꞌh, neezaa saca ayi guhcaꞌhn ziga bwiinn nin rusadxihlli xcweenta impweestu nin zuu nez ca. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naꞌh rucwaaꞌhahn ayi raawuhn ziga chiohpa dxyih laꞌn tuhbi xmahn, rudiꞌhizahn tsiꞌgah bwihllu yihca tuhbigah gaywaꞌh laꞌn guidoꞌ ziga ruꞌnnahn gahn.” ");
INSERT INTO zpvNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ya bwiinn nin rusadxihlli impweestu, zihturooꞌ guzuh ba, ayi guteesaloh ba llaaꞌndxibaaꞌ mejor guzaꞌloh gudxiinnaa ba lastoꞌ ba, chiꞌchi guñiꞌ ba loh Dxiohs, rahbi ba: “Daada, Dxiohs; balahsastoꞌ luꞌh naꞌh, naan tuhbi bwiinn duhlda.” ");
INSERT INTO zpvNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chiꞌchi rahbi Jesuhs: ―Naꞌh rñiꞌn loh tu, laꞌxtuhlda bwiinn nin rusadxihlli impweestu chi basiaꞌpitii la Dxiohs, ya fariseu chi ayi xi cweenta bwiꞌhnn Dxiohs dxyiꞌdxyi nin guñiꞌ ba laasii tuhbisi nin rusadxihlli impweestu chi baguuꞌdzistoꞌ ñiꞌh. Loh garaa raꞌ bwiinn nin ruhnn jweersi gaca lasahca raꞌ, zusiꞌxtuhyi Dxiohs laꞌh raꞌ ba; ya bwiinn raꞌ nin rucuꞌdzistoꞌ raꞌ ñiꞌh zuhnn Dxiohs jweersi gacalasahca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ya tantu guclaaꞌdzi raꞌ bwiinn chi dxihnn raꞌ ba xchiꞌdxyi Jesuhs hasta xpiñiꞌn raꞌ ba gwanee raꞌ ba loh Ñiꞌh tin gudziiꞌbanaa Ñiꞌh yihca raꞌ bi, per chin bwaꞌha raꞌ xpwiinn Ñiꞌh niꞌchi guzaꞌloh ridxihldxyi dxyiꞌdxyinee raꞌ ba bwiinn raꞌ nin gwanee biñiꞌn raꞌ chi loh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Per chin bwaꞌha Jesuhs niꞌchi, gudihdxyi Ñiꞌh biñiꞌn raꞌ chi, chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Gulgasaaꞌn dxieꞌbiiga raꞌ biñiꞌn hasta zuꞌhn ayi gucweꞌza tu laꞌh raꞌ bi laasii xquelrnabwaꞌ Dxiohs naa xteenn bwiinn nadoꞌlaaꞌdzi ziga biñiꞌn raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nee guchiin nin rñiꞌn loh tu, chyuchiꞌhzi nin ayi chechiistoꞌ ñiꞌh xchiꞌdxyi Dxiohs zigazi naa tuhbi biñiꞌn nin ruzoꞌbadxiahga xchiꞌdxyi xtaada ñiꞌh, bwiinn nin ayi chechiistoꞌ ñiꞌh chi ayi chuu raꞌ ba loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chiꞌchi gunabadxyiꞌdxyi tuhbi biꞌnxtuhbi nin rnabwaꞌ, rahbi bi loh Jesuhs: ―Daada, mwehsu chaꞌyi; ¿xaniꞌca nahpa guꞌnnahn tin guziaaꞌhahn dxibaaꞌ guibahneꞌhn Dxiohs para tuꞌpazi chin gachiꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chiꞌchi rahbi Jesuhs loh bi: ―¿Xixnaa rñiꞌ luꞌh chaꞌyiꞌhn? Ayi nin tuhbi bwiinn chaꞌyi, tuhbidxiꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Laꞌluꞌh naannla dxyiꞌdxyi raꞌ nin caa loh xchihtsi Moisehs ziga rñiꞌ lehyi chi: “Ayi gaca luꞌh bwiinn gubwihlli; ayi chiinn luꞌh bwiinn; ayi cwaan luꞌh; ayi chiꞌnlaaꞌdzi luꞌh dxixiꞌhw loh stuhbi bwiinn; nee gaca nadziiꞌhi luꞌh xtaada luꞌh cun xnaan luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chiꞌchi rahbi biꞌnxtuhbi chi loh Ñiꞌh: ―Garaatiiꞌ raꞌ dxyiꞌdxyi ca cagazoꞌbadxiaagahn dez chin guhcaꞌhn biñiꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ya chin bihn Jesuhs xchiꞌdxyi bi, chiꞌchi rahbi Ñiꞌh loh bi: ―Stuhbidxiꞌh cohsa riaꞌdxyi guunn luꞌh: batooꞌ garaa xixteenn luꞌh nee chiꞌzi gahca luꞌh mweeyi chi guicaꞌha raꞌ bwiinn prohbi nin ayi xi nahpa, chiꞌchi gaapa luꞌh guelnazaꞌca llaaꞌn dxibaaꞌ, bachiꞌh dxieꞌnaꞌhla gahca luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chin bihn biꞌnxtuhbi chi dxyiꞌdxyi raꞌ chi, chiꞌchi guhca nalaasa stoꞌ bi laasii ziahahrooꞌ xica nahpa bi. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ya bwaꞌhasi Jesuhs taantu ruhnn nalaasa loh bi, chiꞌchi rahbi Ñiꞌh: ―Nagahn duxa par chuꞌtii tuhbi bwiinn rricu loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ayi guinagahnru tiidxi tuhbi camehyu llaaꞌn guihchiguulla que ziga chuꞌtii tuhbi rricu loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chin bihn raꞌ xpwiinn Ñiꞌh dxyiꞌdxyi raꞌ chi, chiꞌchi rahbi raꞌ ba: ―Sidela ziꞌca gaca, ¿chyuulla gacachiꞌh taꞌh loh duhlda? ");
INSERT INTO zpvNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Para bwiinn raꞌ nagahn raꞌ deeꞌ; per ayi nee dxiꞌh para laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Daada, laꞌh nu laꞌnu dxugasaaꞌn garaa nin nadxiahpa nu, tin zioꞌpanaꞌhla nu Yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Nen guchiin nin ñaan loh tu, ziga bwiinn nin gusaaꞌn yihdzi ñiꞌh, xpaah ñiꞌh, xmaah ñiꞌh, bwihtsi raꞌ ñiꞌh, cheꞌhla ñiꞌh, lliiꞌn ñiꞌh pur xcweenta xquelrnabwaꞌ Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","zicaꞌharu ba zirooꞌ loh guidxyiyuh riiꞌ nen zicaꞌhaza ba guelnabahan nin ayi ñichilohtiiꞌ chin gachi ba guziaa ba dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ya guleꞌcaa Jesuhs laꞌh gadziꞌh bichiohpa nin naa xpooxtla Ñiꞌh tin rahbi Ñiꞌh loh raꞌ ba: ―Yannah guzoo nuꞌh guihdxyi Jerusalehn tin riꞌchi nahpa saca Lliiꞌn Dxiohs nin naa ndxiꞌhw ziga bacaꞌh daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cachiempa. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Zutiꞌdxi raꞌ ba laꞌh ba loh raꞌ bwiinn ziitu nin ayi naa bwiinn Israel nee gullihdzinee raꞌ ba laꞌh ba, gusaꞌcazii raꞌ ba laꞌh ba cun guchahn xihin raꞌ ba loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ya chin chaꞌloh gucaꞌyahga raꞌ ba laꞌh ba cun cwaarta, chiꞌchi chiinn raꞌ ba laꞌh ba nahpa gachitiiꞌ ba, ya chin dxiohnna gubihdxyi guhchi ba chiꞌchi gabiaꞌgarii gabahan ba stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ya laꞌh raꞌ ba ayi guhcabwaꞌ raꞌ ba niꞌchi, coma dxyiꞌdxyi raꞌ chi guhcan ziga nagaꞌtsi par laꞌh raꞌ ba, niꞌchin ayi guhcabwaꞌ raꞌ ba xi guñiꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chin zegadzihn gahxu raꞌ ba tuhbi guihdxyi nin laa Jericoh, zohba tuhbi bwiinn nin rahca loh ñiꞌh rbweꞌhe ba cardah rwaaꞌ neziuh chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ya chin gudiiꞌdxidxiahga bwiinn chi ziahan bwiinn zeediiꞌdxi, chiꞌchi gunabadxyiꞌdxyi ba, rahbi ba: ―¿Xiniꞌca cayahca? ");
INSERT INTO zpvNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chiꞌchi rahbi raꞌ ba: ―Jesuhs nin zeꞌ nez guihdxyi Nazaret laꞌh ban zediiꞌdxi riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chiꞌchi guñiꞌ ba jweersi, rahbi ba: ―¡Jesuhs, Lliiꞌn guehtu Davihd, balahsastoꞌ luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ya chiꞌchi bidxyiꞌchi bwiinn raꞌ nin zee delaanta guzohbaloh zeeñiꞌ raꞌ ba, rahbi raꞌ ba: ―¡Biacadxyii!, ¡ayi rñiꞌ luꞌh ziꞌca! Per laꞌh ba mahziru cañiꞌ ba jweersirooru: ―¡Lliiꞌn guehtu Davihd, balahsastoꞌ luꞌh naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ya guzuhdxyiigah Jesuhs, chiꞌchi gunabwaꞌ Ñiꞌh gwacaꞌha raꞌ ba bwiinn chi, ya chin badzihn ba hasta zuu Jesuhs, chiꞌchi gunabadxyiꞌdxyi Jesuhs loh ba, rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Xiniꞌca xclaaꞌdzi luꞌh guꞌnnahn para yiꞌh? Chiꞌchi rahbi bwiinn nin rahca loh Ñiꞌh chi: ―Daada, xclaaꞌdzihn gwaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chiꞌchi rahbi Jesuhs loh ba: ―Zwaꞌha luꞌh nnah laꞌluꞌh biaca pur nin gwachiistoꞌ luꞌh guhca basiaꞌcahn yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ya hohrachi gahca ballaala bizloh bwiinn nin ayi biinn loh ñiꞌh chi, chiꞌchi gubiaꞌgarii bwaꞌha ba, chiꞌchi zenee ba Jesuhs, cañiꞌ ba xcweenta zirooꞌ jweersi nin nahpa Dxiohs, neezaa bwiinn raꞌ badxyigaaꞌloh raꞌ ba pur bwaꞌha raꞌ ba biaca loh bwiinn chi, neezaa raꞌ ba guzaꞌloh cañiꞌ raꞌ ba xcweenta jweersirooꞌ nin nahpa Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ya chin badzihn Jesuhs rwaaꞌ guihdxyi Jericoh, gudiiꞌdxi Ñiꞌh galaayi guihdxyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Guihdxyi chi gahca nuu tuhbi bwiinn nin laa Zaqueu; rricu duxa ba, rnabwaꞌ ba bwiinn raꞌ nin rusadxihlli impweestu. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ya guclaaꞌdzi ba dxiuꞌnbwaꞌ ba laꞌh Jesuhs, per ayi guhca ñwaꞌha ba laꞌh Jesuhs laasii rii ziahanrooꞌ bwiinn gadiidxi coma Zaqueu bwiinnllaꞌta ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lwehgu balluꞌn ba gwah ba delaanta hasta zohba tuhbi llaaꞌn yahga gurooꞌ nin laa sicohmoro nez tiidxi Jesuhs, chiꞌchi gucah ba lohon tin guhca bwaꞌha ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ya chin guyaꞌloh gudiiꞌdxi Jesuhs riꞌchi bwaꞌha Ñiꞌh nez guiyaꞌ, chiꞌchi rahbi Ñiꞌh loh Zaqueu: ―Zaqueu, basiooba bieꞌta riꞌca tin nnadxyih gahca nahpa chadxiaꞌhnahn yihdzi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chiꞌchi bieꞌtagalluꞌn Zaqueu loh yahga chi tin zenee ba laꞌh Jesuhs par yihdzi ba, riahxi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ya chin bwaꞌha snuhn bwiinn niꞌchi guzaꞌloh cañiꞌ tohnta raꞌ ba, rahbi raꞌ ba: ―Bwaꞌha laꞌJesuhs zedxiaꞌhan rwaaꞌ yihdzi bwiinn nin mahzi nahpa duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chiꞌchi guzuꞌnchii Zaqueu delaanta loh Jesuhs, rahbi ba: ―Bwaꞌha Daada; gudiꞌhihn garoolda nin naꞌpahn guicaꞌha raꞌ bwiinn prohbi, ya sidela gulaꞌnaꞌhn laꞌh chyuulla cun guelrsaguiꞌhi nnah gusiaꞌgariin xmweeyi ba tahpa taantu pur nin basaguiꞌhihn laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chiꞌchi rahbi Jesuhs loh ba: ―Nnadxyih gahca laꞌxtuhlda luꞌh basiaꞌpitiin neezaa xtuhlda bwiinn raꞌ nin nuu yihdzi luꞌh gusiaꞌpitiiñin laasii guchii luꞌh naa luꞌh xpwiinn guehtu Abrahn, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","laasii naꞌh naan Lliiꞌn Dxiohs nin naa ndxiꞌhw tin chiꞌhyihn bwiinn raꞌ nin cagañihchi pur xtuhlda raꞌ ba tin naꞌh guhldaꞌhraꞌn ba loh xtuhlda raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ya gaduhbi rigacaꞌdxiahga raꞌ bwiinn dxyiꞌdxyi raꞌ nin cañiꞌ Jesuhs, bwiiꞌyidxyiꞌdxyi lagaꞌh Ñiꞌh stuhbi cweenta loh raꞌ ba laasii laꞌ raꞌ ba zeegadzihn gahxula guihdxyi Jerusalehn nen coma laꞌh raꞌ ba ruhnn raꞌ ba lligaaba lwehgu saꞌloh guinabwaꞌ Jesuhs laasii laꞌ raꞌ ba gadzihnla guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Guyuuꞌ tuhbi bwiinn, guyuuꞌ ba lahda tuhbi jwamihyi lasahca, ya biriaꞌh ba gwah ba stuhbi guihdxyi ziitu tin gaca ba rrehyi, ya chin guibiaꞌgarii ba chiꞌchi guinabwaꞌ ba guihdxyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ya nnaaru guiriaꞌh ba yihdzi ba, gudihdxyixgah ba tsiꞌh xmooza ba tin gudiꞌhi ba tuhbigah mweeyi nin lasahca guicaꞌha raꞌ ba, chiꞌchi rahbi bwiinn chi loh raꞌ ba: “Gulguiꞌhnnee mweeyi riiꞌ guriꞌxi hasta chin gabiaꞌgariin stuhbi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ya bwiinn lahdxyi ba ayi guclaaꞌdzi raꞌ ba laꞌh ba, niꞌchin guxeꞌhla raꞌ ba paaldaa bwiinn nin zeguihtsi raꞌ: “Ayi xclaaꞌdzi nu gaca ba xrrehyi nu.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per nahpa guhca ba rrehyi, chiꞌchi gubiaꞌgarii ba lahdxyi ba. Ya chin gubiaꞌgarii ba, chiꞌchi gudihdxyi ba mooza raꞌ nin basiaꞌhannee ba mweeyi tin gacabwaꞌ ba blaacala cayuhnn raꞌn gahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ya galoh bwiinn nin badiꞌhi ba mweeyi badzihn loh ba, chiꞌchi rahbi mooza chi: “Daada, laꞌxmweeyi luꞌh cayuhnn gahn tsiꞌh bwelta ziga naan.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chiꞌchi rahbi rrehyi chi loh ba: “Bwen gahca; yiꞌh naa luꞌh tuhbi mooza bwen pur bwiꞌhnn luꞌh dziꞌn zaꞌca nee gulliaꞌyiꞌhn nin baniꞌhihn. Yannah guniꞌhihn dziꞌn guunn luꞌh, guinabwaꞌ luꞌh tsiꞌh guihdxyi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chiꞌchi badzihn stuhbi mooza loh ba, chiꞌchi rahbi mooza chi: “Daada, xmweeyi luꞌh cayuhnn gahn gaꞌyu bwelta mahzi ziga naan.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chiꞌchi rahbi ba loh ba: “Yiꞌh guniꞌhihn dziꞌn guunn luꞌh guinabwaꞌ luꞌh gaꞌyu guihdxyi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chiꞌchi badzihn stuhbi mooza loh ba, chiꞌchi rahbi mooza chi: “Daada, laꞌxmweeyi luꞌh deeꞌ; guluꞌchaꞌyisiñin laꞌn tuhbi baschihn ");
INSERT INTO zpvNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","laasii bidxyihbihn yiꞌh pur naa luꞌh tuhbi bwiinn nadxiipa dxyiꞌdxyi. Racaꞌha luꞌh cohsa raꞌ nin ayi naa xteenn luꞌh, neezaa rataaꞌha luꞌh guiñaꞌh hasta ayi gulahchi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chiꞌchi rahbi rrehyi chi loh ba: “¡Mooza xihn mooza dxaaba! Cun sola dxyiꞌdxyi nin guñiꞌ luꞌh ca guꞌnnahn guelguxchiisi yiꞌh. Sidela nnah luꞌh naan tuhbi bwiinn nin nadxiipadxyiꞌdxyi nen nahgahca luꞌh racaꞌhahn nin ayi naa xteꞌnnahn nen nnaaza luꞌh rataaꞌhahn guiñaꞌh nin ayi naaza xteꞌnnahn, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿xixnaa ayi bagasiaꞌhan luꞌh xmweeꞌyihnca baancu tin chin ñabiaꞌgariin ñacaꞌhañin cun garaa lliiꞌnan?” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chiꞌchi rahbi ba loh raꞌ nin rii riꞌchi: “Gulgacaꞌha mweeyi ca tin gulgadiꞌhin laꞌh bwiinn nin bwiꞌhnn gahn tsiꞌh taantu mahzi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chiꞌchi rahbi raꞌ ba loh ba: “Daada, per laꞌba nahpala tsiꞌh mweeyi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chiꞌchi rahbilagaꞌh rrehyi chi: “Niꞌchin nin ñaan loh tu, nin nahpa ziahanan niꞌchi gaca guicaꞌharun, ya nin nahpa gulliaꞌhan hasta nin ruhnn ba lligaaba nahpa ba gacaꞌhañin loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ya garaa bwiinn nin bidxyiꞌchinee naꞌh nin ayi guclaaꞌdzi ñahcaꞌhn rrehyi loh raꞌ ñiꞌh, gultaꞌnee raꞌ ba riiꞌ tin gadxiinn tu laꞌh raꞌ ba delanta loon.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ya chin guyaꞌloh bwiiꞌyidxyiꞌdxyi Ñiꞌh dxyiꞌdxyi raꞌ chi, chiꞌchi biriaꞌh Ñiꞌh tin zee Ñiꞌh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ya chin zegadzihn Ñiꞌh tuhbi guihdxyi nin laa Betfageh cun guihdxyi nin laa Betania, gahxu loh dahan nin laa Olivo chiꞌchi guxeꞌhla Ñiꞌh chiohpa xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulchee loh guihdxyi nin naa gahxuru, ya chin gadzihn tu riꞌchi, chiꞌchi gwaꞌha tu caduꞌh tuhbi buhrra nin nadxyiꞌbi nin nagahdxi gaca nadoꞌtiiꞌ. Gulgaxachi ma tin dxieꞌnee tu ma. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ya sidela chyuulla guinaꞌbadxyiꞌdxyi loh tu: “¿Xixnaa guxachi tu buhrra ca?”, chiꞌchi gahbi tu loh ba: “Tuhbi bwiinn nin mahzi rnabwaꞌ cachiꞌhn ma tin tsiiba ba ma.” ");
INSERT INTO zpvNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ya seguihdu ziaganee raꞌ chiꞌh ba ma, ya zigapaꞌ guñiꞌ Jesuhs guzohba xchiꞌdxyi Ñiꞌh guzahca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ya chin rigaxachi raꞌ ba buhrra chi, chiꞌchi gunabadxyiꞌdxyi raꞌ bwiinn nin naa xteenn ñiꞌh laꞌh ma, rahbi raꞌ ba: ―¿Xixnaa rigaxachi tu buhrra ca? ");
INSERT INTO zpvNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chiꞌchi rahbi raꞌ ba: ―Dxugaxachi nu ma laasii tuhbi bwiinn nin mahzi rnabwaꞌ cachiꞌhn ba ma tin tsiiba ba ma. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chiꞌchi baganee raꞌ ba ma hasta zuu Jesuhs, chiꞌchi badziiꞌba raꞌ ba xahba raꞌ ba dihtsi ma tin guzohba Jesuhs dihtsi ma. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ya chin zeezah Jesuhs loh neziuh nin zee Jerusalehn, zeedziꞌba Ñiꞌh buhrra chi, chiꞌchi gudxyihxi raꞌ ba xahba raꞌ ba loh neziuh tin gudiiꞌdxinee buhrriꞌhn chi laꞌh Ñiꞌh loh lahdxi raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ya chin zegadzihn gahxuru Ñiꞌh loh dahan nin laa Olivo, zenaꞌhla paaldaa bwiinn laꞌh Jesuhs nin riachiistoꞌ Ñiꞌh laꞌh Ñiꞌh, chiꞌchi guzaꞌloh cañiꞌ raꞌ ba jweersi pur jweersirooꞌ nin nahpa Dxiohs. Ziꞌchi cañiꞌ raꞌ ba pur ziahan dziꞌn rooꞌ raꞌ nin bwaꞌha raꞌ ba bwiꞌhnn Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","neezaa cañiꞌ raꞌ ba: ―¡Bwiꞌnntaaꞌyi Dxiohs yihca rrehyi nin zeꞌ pura xcweenta Dxiohs; nnah dxyiiriistoꞌ Dxiohs nin nuu dxibaaꞌ laasii nnah laꞌJesuhs zeꞌ tin guinabwaꞌ Ñiꞌh pura xcweenta Dxiohs; yannah gachidiꞌtsi nu zuxchilli Dxiohs pur garaa nin bwiꞌhnn Ñiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ya lahda raꞌ bwiinn chi rii nuhn bwiinn fariseu, ya chin bihn raꞌ ba xi riñiꞌ raꞌ bwiinn chi, chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Mwehsu, guñiꞌ loh raꞌ bwiinn nin zeꞌnaꞌhla yiꞌh tin ayiru guiñiꞌ raꞌ ba ziꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Sidela laꞌh raꞌ bwiinn riiꞌ cwidxyii raꞌ ba, zibwidxaaꞌyoꞌba dxiah raꞌ nin zaa loh yuh xcweenta raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ya chin zegadzihn gahxuru Jesuhs guihdxyi Jerusalehn, chin bwaꞌha Ñiꞌh guihdxyi chi, chiꞌchi guzaꞌloh biꞌn Ñiꞌh pur guihdxyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","chiꞌchi rahbi Ñiꞌh: ―¡Xixlaaxchimmatiiꞌ ayi gaann tu xi cohsa guunn tu tin cwidxyiistoꞌ tu! Per nnah nuulaꞌn cohsa chi par laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","laasii zadzihn dxyih raꞌ chin gadzihn bwiinn raꞌ nin rdxyiꞌchinee laꞌh tu nee zuhnn raꞌ ba ziga tuhbi leeꞌ gadiidxi rwaaꞌ guihdxyi tin ayi gusaaꞌn raꞌ ba guiriaꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","nen cun nee chuꞌtii raꞌ ba lahda guihdxyi tin gucwih raꞌ ba garaa yuuꞌ cun garaa muhru nin nuu gadiidxi rwaaꞌ guihdxyi; ziꞌchi gunnee raꞌ ba laꞌh tu pur nin ayi biuꞌnbwaꞌ tu dxyih nin bieꞌguiaꞌha Dxiohs laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ya chin badzihn Jesuhs loh guihdxyi Jerusalehn, chiꞌchi guyuꞌtii Ñiꞌh laꞌn guidoꞌrooꞌ ya bwaꞌha Ñiꞌh rii raꞌ bwiinn laꞌn guidoꞌ chi nin ruhnn raꞌ guriꞌxi, nee ayi rbwihdxyi-rnaaba raꞌ ba Dxiohs. Chiꞌchi guzohbaloh babweꞌhedxiaꞌhla Ñiꞌh laꞌh raꞌ ba nez dihtsijwehra, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ya gaduhbi cagabweꞌhe Ñiꞌh laꞌh raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Loh Xchihtsi Dxiohs caa raꞌ dxyiꞌdxyi raꞌ riiꞌ: “Yiidzihn gaca tuhbi yuuꞌ hasta dxiꞌ tu tin cwidxyi-guinaaba tu naꞌh”, ¡ya laꞌh tu ruhnn tun zigazi tuhbi cwehva hasta riuuꞌ raꞌ gubaꞌn! ");
INSERT INTO zpvNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ya guillii-guillii cagaluuꞌyi Jesuhs laꞌn guidoꞌrooꞌ chi per bwiinn raꞌ nin rnabwaꞌ loh raꞌ bixohza neezaa bwiinn raꞌ nin ruluuꞌyi xlehyi Moisehs, neezaa bwiinnguuhla raꞌ cadxiꞌhyi raꞌ ba mohda tin chiinn raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","per ayi bidxeela xa ñuhnn raꞌ ban laasii garaa raꞌ bwiinn rigacaꞌdxyiahga dziꞌtsi raꞌ ba xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Guyuuꞌ tuhbi dxyih cagaluuꞌyi Jesuhs laꞌh raꞌ bwiinn laꞌn guidoꞌ rooꞌ, ya gaduhbi cagaluuꞌyi Ñiꞌh laꞌh raꞌ bwiinn xa guunn raꞌ ba tin taꞌh raꞌ ba loh duhlda chin badzihn raꞌ bwiinn nin rnabwaꞌ laꞌh bixohza, neezaa mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs neezaa bwiinnguuhla raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Gudxixteeꞌ loh nu chyu naa luꞌh tin gaca guunn luꞌh garaa niꞌca o chyu gunnah loh luꞌh guunn luꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Neezaa naꞌh guinabadxyiꞌdxyiꞌhn loh tu tuhbi rsohn, gulchixteeꞌ loon: ");
INSERT INTO zpvNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Chyu guxeꞌhla laꞌh Jwahn bieꞌgaroꞌbañihsa ba? ¿Ta Dxiohs guxeꞌhla laꞌh ba o tuhbi bwiinnzi? ");
INSERT INTO zpvNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chiꞌchi guzaꞌloh riiyuuꞌyidxyiꞌdxyi loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Xa guidiꞌtsi nuꞌh? Sidela laꞌh nuꞌh guidiꞌtsi nuꞌh: “Dxiohs guxeꞌhla laꞌh ba”, chiꞌchi nnaa ba: “¿Xixnaachiꞌh ayi gwachiistoꞌ tu xchiꞌdxyi ba?”, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ya sidela guidiꞌtsi nuꞌh: “Tuhbi bwiinnzi guxeꞌhla laꞌh Jwahn”, chiꞌchi zusihdzidxiah garaa bwiinn laꞌh nuꞌh tin gachi nuꞌh laasii ruhnn raꞌ ba lligaaba Jwahn naa tuhbi bwiinn nin guñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chiꞌchi guñiꞌ raꞌ ba dxyiꞌdxyi riiꞌ, rahbi raꞌ ba loh Ñiꞌh: ―Ayi gaann nu chyu guxeꞌhla laꞌh Jwahn bieꞌgaroꞌbañihsa ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ya ayiza chixteeꞌhehn loh tu chyu guxeꞌhla naꞌh cayuꞌnnahn cohsa raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chiꞌchi guzaꞌloh bwiiꞌyidxyiꞌdxyi Ñiꞌh cweenta riiꞌ loh raꞌ bwiinn, rahbi Ñiꞌh: ―Guyuuꞌ tuhbi bwiinn, bwiꞌhnn biñih ba nuhn yahga uhva raꞌ loh xuh ba, chiꞌchi bireꞌh ba zee ba stuhbi guihdxyi, ya basiaꞌhannee ba loh xuh ba chi laꞌh paaldaa bwiinn raꞌ tin gaapa raꞌ ban ya chin gabweꞌhecaan liꞌhn nahpa gusiaꞌhan raꞌ ba nuhn liꞌhn chi nin ruhnn tucahri guicaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ya chin badzihn dxyih gabweꞌhe raꞌ ba xliꞌhn raꞌ ba, chiꞌchi guxeꞌhla nin naaꞌhan xteenn ñiꞌh chi tuhbi xmooza ba gwagañiꞌ loh raꞌ bwiinn nin biaꞌhannee loh xuh ba tin gudiꞌhi raꞌ ba nin ruhnn tucahri gacaꞌha ba. Ya xlawaaꞌha ñudiꞌhi raꞌ ba nin ruhnn tucahri gacaꞌha ba, mejor badiꞌhi goolpi raꞌ ba laꞌh mooza chi ayichiꞌh xi badiꞌhi raꞌ ba ñicaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chiꞌchi guxeꞌhla ba stuhbi mooza loh raꞌ ba, ya chin badzihn ba riꞌchi, ziꞌchi gahcaza badiꞌhi goolpi raꞌ ba laꞌh ba ya ayi xi badiꞌhi gahca raꞌ ba ñicaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ya nin riohnna bweelta guxeꞌhla ba stuhbi mooza loh raꞌ bwiinn chi per ziꞌchi gahcaza badiꞌhi goolpi raꞌ ba laꞌh ba chiꞌchi babweꞌhe dxiaꞌhla raꞌ ba laꞌh ba nez rwaaꞌjwehra. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Chiꞌchi bwiꞌhnn bwiinn nin naan xteenn ñiꞌh lligaaba, nastoꞌ ba: “¿Xaalla guꞌnnchiꞌhn nnah? Mejor guixeꞌhlaꞌhn yuꞌpi lliiꞌnahn nin rucaꞌhstoꞌn tin chin gwaꞌha raꞌ ba laꞌh bi pwehda zuhnn cweenta raꞌ ba laꞌh bi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ya chin bwaꞌha raꞌ bwiinn chi laꞌh bi, chiꞌchi rahbi loh lasaaꞌ raꞌ ba: “Bwaꞌha, dehchisihn guicaꞌha gaduhbi loh yuh riiꞌ. Gulchoꞌho gachidxiinn nuꞌh bi tin gachicaꞌha nuꞌh yuh riiꞌ gacan xteenn nuꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ya chin badzihn bi, gunaꞌzu raꞌ ba laꞌh bi, chiꞌchi babweꞌhe dxiaꞌhla raꞌ ba laꞌh bi rwaaꞌ yuh chi, gudxiinn raꞌ ba laꞌh bi. Chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―¿Xiniꞌca gunnee bwiinn nin naa xteenn ñiꞌh loh yuh ca laꞌh raꞌ bwiinn ca? ");
INSERT INTO zpvNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ziꞌ ba, dxieꞌchiinn ba garaa raꞌ ba; ya chin chaꞌloh gachi raꞌ ba, chiꞌchi gudiꞌhi ba loh yuh chi gaan raꞌ guriin bwiinn. Ya chin bihn raꞌ ba dxyiꞌdxyi raꞌ chi, chiꞌchi rahbi raꞌ ba: ―¡Per Dxiohs ayi nnaa Ñiꞌh gaca ziꞌca! ");
INSERT INTO zpvNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ya chin guñiꞌ raꞌ ba loh Jesuhs ziꞌchi, chiꞌchi bwaꞌha Ñiꞌh loh raꞌ ba, rahbi Ñiꞌh: ―Ya ¿xalla rñiꞌ chiꞌh nin caa loh dxihtsi nin bacaꞌh daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs cadxyih? Riꞌchi caa: “Nee dxiah nin guleꞌhecaa raꞌ mwehsu albañihyi gaca yuuꞌ, dxiah chi guhca dxiah zaꞌca nin guzuh galoh tuhbi schihn yuuꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chyuchiꞌhzi bwiinn nin dxiaaba yihca dxiah chi zahca ba ziahan taaꞌha, ya sidela dxiah dxiaaban yihca bwiinn zusiuꞌyitiiꞌhin laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ya bwiinn raꞌ nin rnabwaꞌ loh bixohza raꞌ neezaa bwiinn raꞌ nin ruluuꞌyi lehyi guclaaꞌdzi raꞌ ba ñinaꞌzu raꞌ ba laꞌh Jesuhs hohrachi gahca laasii gwasaa raꞌ ba cweenta nin guñiꞌ Ñiꞌh yihca raꞌ ba, per ayiza biaalla raꞌ ba ñinaꞌzu raꞌ ba laꞌh Ñiꞌh laasii rdxyihbi raꞌ ba bwiinn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chiꞌchi cagataꞌtsi raꞌ ba ya guxeꞌhla raꞌ ba paaldaa bwiinn raꞌ zee tin guunn raꞌ ba ziga bwiinn zaꞌca tin gunabadxyiꞌdxyi raꞌ ba loh Ñiꞌh xilla dxyiꞌdxyi raꞌ nin ñiñiꞌ Ñiꞌh per mejor cadxiꞌhyi raꞌ ba xa gutiꞌdxi raꞌ ba laꞌh Ñiꞌh loh gubieerna tin gachi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chiꞌchi gunabadxyiꞌdxyi raꞌ ba loh Ñiꞌh, rahbi raꞌ ba: ―Daada, mwehsu; naann nu xnehza rñiꞌ luꞌh nee naannza nu xnehza rusiꞌdxi luꞌh. Ayi rwaꞌhazaꞌca luꞌh loh tuhbi bwiinn ya stuhbigaꞌh ba gwaꞌhadxaaba luꞌh loh ñiꞌh, laasii rusiꞌdxi luꞌh mohdapaꞌ nin ruhnn Dxiohs guelguxchiisi, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","yannah gunnah loh nu, ¿ta zachidxihlli nu o ayi chyu chiilli impweestu loh rrehyi César? ");
INSERT INTO zpvNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per lwehgu guhcabwaꞌ Jesuhs xi lligaaba nuu raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Xixnaa ruhnnee tu naꞌh ziꞌca? ");
INSERT INTO zpvNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Gulgaluuꞌyi tuhbi xmweeyi tu naꞌh. Guidiaꞌhan nuꞌh ¿chyu yihca caa lohon? Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Xteenn César. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulgadiꞌhi laꞌh César nin naa xteenn ba, nee gulgadiꞌhiza laꞌh Dxiohs nin naa xteenn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ya nin ayi bwiꞌhnn raꞌ ba gahn ñusaguiꞌhi raꞌ ba laꞌh Ñiꞌh pur dxyiꞌdxyi nin guñiꞌ Ñiꞌh nezloh raꞌ bwiinn, niꞌchin nin badxyigaaꞌloh raꞌ ba pur xchiꞌdxyi Ñiꞌh mejor bataꞌwrwaaꞌ raꞌ ba dxyiitiiꞌ babwii raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chiꞌchi gwah paaldaa raꞌ bwiinn nin laa saduceu raꞌ, gwaguiaꞌha raꞌ ba loh Jesuhs. Ya saduceu raꞌ chi ayi riachiistoꞌ raꞌ ba gabahan bwiinn raꞌ nin guhchi, niꞌchin gunabadxyiꞌdxyi raꞌ ba loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","rahbi raꞌ ba: ―Daada, mwehsu; basiaꞌhan Moisehs dxihtsi loh nuꞌh, loh chi caa: “Sidela chyuulla ndxiꞌhw gachi gusiaꞌhan ba viuhda xcunnaꞌh ba nen ayi chyu lliiꞌn raꞌ ba guyuuꞌ, nahpa guicaꞌha bwihtsi ba gunnaꞌh chi tin chuu lliiꞌn raꞌ ba xcweenta bwihtsi ba nin guhchi.” ");
INSERT INTO zpvNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sidela ziꞌca guidiꞌhnn nuꞌh nuu gahdzi ndxiꞌhw ya garaa raꞌ ba naa tuhsi bwihtsi, ya guidiꞌhnn nuꞌh nin naa bwiinngaloh bachinaa ba ya guhchi ba, per ayi chyu lliiꞌn raꞌ ba guyuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chiꞌchi gucaꞌha bwihtsi raroopa ba laꞌh gunnaꞌh viuhda chi per ayi chyu lliiꞌn raꞌ ba guyuuꞌ ya guhchi gahca ndxiꞌhw chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chiꞌchi lwehgu gucaꞌhalagaꞌh stuhbi bwihtsi ba nin riohnna laꞌh gahca gunnaꞌh chi nee lwehgu gahca guhchi ba, ayi chyu lliiꞌn raꞌ ba guyuuꞌ gahcaza, ya ziꞌchi gahca bwiꞌhnn snuhn raꞌ ba hasta que no guhchi garaa raꞌ ba ayi nin tuhbi lliiꞌn raꞌ ba guyuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ya luulchimma neezaa gunnaꞌh chi guhchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yannah, chin gabahan raꞌ ba, ¿cuunpaꞌxchiꞌh nin naa cheꞌhla viuhda chi? Laasii gagaadzi raꞌ ba bachinaa laꞌh gunnaꞌh chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Nnah loh guidxyiyuh riiꞌ ruchinaa raꞌ bwiinn nee rudiꞌhiraꞌza ba lliiꞌndxaꞌpa raꞌ ba rcaꞌha stuhbi ndxiꞌhw, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","per bwiinn raꞌ nin gulii Dxiohs guziaa raꞌ par dxibaaꞌ, gabiaꞌgarii gabahan raꞌ ba stuhbi per ayi guchinaaru raꞌ ba nee ayiza cweꞌdxiꞌhnru raꞌ ba lliiꞌndxaꞌpa raꞌ ba guicaꞌha ndxiꞌhw ziga ruhnn raꞌ bwiinn nin rii loh guidxyiyuh nnah, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ya pur nin ayiru gachi raꞌ ba, niꞌchin gaca raꞌ ba ziga aanjla raꞌ. Gaca raꞌ ba lliiꞌn Dxiohs laasii bacwaꞌhn Dxiohs laꞌh raꞌ ba loh guelguhchi, ");
INSERT INTO zpvNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ya tin dxihn tu gabiaꞌgarii gabahan raꞌ bwiinn nin guhchi, ¿ta nagahdxi guꞌlda tu nin bacaꞌh guehtu Moisehs xcweenta laꞌn yaguichaaꞌh nin gurih bwehla? Riꞌchi gudihdxyi Dxiohs laꞌh ba, rahbi Ñiꞌh loh ba: “Naꞌh naan Xchiohs Abrahn, neezaa Xchiohs Isaac, neezaa Xchiohs Jacobo.” ");
INSERT INTO zpvNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Niꞌchin nin ayi gaca Dxiohs xchiohsa bwiinnguuchi raꞌ, mejor naa Ñiꞌh Xchiohs bwiinn nabahan raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chiꞌchi rahbi raꞌ paaldaa mwehsu nin ruluuꞌyi xcweenta lehyi, rahbi raꞌ ba: ―Mwehsu, bwen gahca guñiꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ziꞌchi guñiꞌ raꞌ ba laasii ayiru guhca ñinabadxyiꞌdxyi raꞌ ba xiicaru loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xamohda rñiꞌ raꞌ ba Crixtu naa lliiꞌn guehtu Davihd? ");
INSERT INTO zpvNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Laasii laꞌh gahca guehtu Davihd bacaꞌh loh dxihtsi raꞌ nin laa Salmu: Daada Dxiohs rahbi loh Daada nin rnabwaꞌ naꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Guzohba xlahdu nanchiin hastayi gadzihn dxyih nin gutsiiꞌgahn garaa bwiinn nin rdxyiꞌchinee yiꞌh tin gacabwaꞌ raꞌ ba yiꞌh naa luꞌh nin rnabwaꞌ garaatiiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nee sidela laꞌh Crixtu naa Ñiꞌh lliiꞌn Davihd, ¿xixnaa rahbi Davihd: “Crixtu guinabwaꞌ naꞌh”? ");
INSERT INTO zpvNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ya garaa raꞌ bwiinn cagacaꞌdxiahga raꞌ ba chin guñiꞌ Jesuhs loh raꞌ xpwiinn Ñiꞌh, rahbi Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gulgahcanasiin tin ayi gusaguiꞌhi mwehsu raꞌ nin ruluuꞌyi lehyi laꞌh tu. Riuuꞌstoꞌ raꞌ ba rahcu raꞌ ba lahdxi nuꞌhla nin riuuꞌ hasta yahnn raꞌ ba nee hasta ñaaꞌ raꞌ ba tin para guluuꞌyi bwiinn lasahca raꞌ ba nee xclaaꞌdzi raꞌza ba garaa bwiinn raꞌ nin gadxaꞌga laꞌh raꞌ ba guchaꞌgarwaaꞌ naa raꞌ ba tin gahbi snuhn bwiinn: “Bwiinnlasahca raꞌ ba”, ya laꞌh raꞌ ba rdxiꞌhyi raꞌ ba pur yagaxiyi zaꞌca nin mahzi lasahca rzohba raꞌ ba laꞌn guidoꞌ, nee gahcaza hasta rahca guelwahw. ");
INSERT INTO zpvNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Neezaa rbweꞌhelluꞌhu raꞌ ba yihdzi gunnaꞌh viuhda raꞌ ya hohrachi gahca rñiꞌnee raꞌ ba Dxiohs xchih tin guluuꞌyi bwiinn zaꞌca raꞌ ba. Per laꞌh raꞌ ba naa nin guixeꞌhla Dxiohs zirooꞌru guelrzahcazii yihca raꞌ ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Gaduhbi nuu Jesuhs laꞌn guidoꞌ, basiaꞌgarii loh Ñiꞌh nez stuhbi lahdu, bwaꞌha Ñiꞌh cagalaꞌha raꞌ bwiinn rricu mweeyi laꞌn alcansía raꞌ hasta rguuꞌ bwiinn mweeyi guelguhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Neezaa tuhbi gunnaꞌh viuhda bwaꞌha Ñiꞌh, balaꞌha chiohpa mweeyi gaꞌyuꞌhn laꞌn alcansía, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, gunnaꞌh viuhda prohbi ca ziahanru mweeyi balaꞌha que snuhn raꞌ bwiinn nin balaꞌha raꞌ mweeyi, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","laasii bwiinn rricu raꞌ chi mweeyizi nin riaꞌhancah balaꞌha raꞌ ba laꞌn alcansia ya gunnaꞌh ca garaa mweeyi nin nahpa ba balaꞌha ba hasta nin ñioꞌh xquehta ba balaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ya nuu nuhn bwiinn nin cayuuꞌyidxyiꞌdxyi joosca xñah guidoꞌrooꞌ chi pur dxiah joosca raꞌ nin nuu tihxin neezaa cohsa lasahca raꞌ nin bagaaꞌda raꞌ bwiinn pur dziꞌn nin rahca riꞌchi, chiꞌchi rahbi Jesuhs loh raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Zadzihn dxyih nin cwih garaa cohsa raꞌ nin caywaꞌha tu. Nin tuhbi dxiah nin dziꞌba yihca lasaaꞌ ayi dxiaꞌhancaa. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chiꞌchi gunabadxyiꞌdxyi xpwiinn raꞌ Ñiꞌh loh Ñiꞌh, rahbi raꞌ ba: ―Daada, mwehsu; ¿cuuca gaca niꞌca? ¿Xa naa sehn nin dxiꞌ chin gaca cohsa raꞌ chi? ");
INSERT INTO zpvNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgahca nasiin tin ayi gusaaꞌn tu gusaguiꞌhi bwiinn laꞌh tu, tin ziahan raꞌ bwiinn dxiꞌ, nnaa raꞌ ba: “Naꞌh naan Crixtu”, per ayi chechiistoꞌ tu xchiꞌdxyi raꞌ ba nee ayiza chenaꞌhla tu laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","nee chin dxihn tu cayahca guehrru ridxiinn lasaaꞌ bwiinn raꞌ, ayiza guidxyihbi tu laasii nahpa gaca deeꞌ per nagahdxi gadzihn dxyih nin guiñihchiloh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ya zeezah cañiꞌ Ñiꞌh loh raꞌ ba, rahbi Ñiꞌh: ―Nee zucaꞌnee tuhbi nasiohn laꞌh stuhbi nasiohn, neezaa tuhbi guihdxyi bwiinn chindxinee raꞌ ba stuhbi guihdxyi, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","neezaa gaca lluhrooꞌ neezaa chuu gubihn neezaa gueldxyihdxyi, cun llaaꞌndxibaaꞌ guluuꞌyiloh raꞌ cohsa nin guchihbi laꞌh raꞌ bwiinn, zwaꞌha raꞌ ba sehnrooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Per galoh gaca garaa raꞌ cohsa raꞌ riiꞌ, ya zinaꞌzu raꞌ ba laꞌh tu gusaꞌcazii raꞌ ba, neezaa zutiꞌdxi raꞌ ba laꞌh tu nez loh raꞌ bwiinn nin rnabwaꞌ laꞌn guidoꞌ tin guunn bwiinn raꞌ chi guelguxchiisi laꞌh tu nee gusieꞌw raꞌ ba laꞌh tu laꞌn lahtsidxiꞌba nee zutiiꞌdxi raꞌ ba laꞌh tu loh raꞌ rrehyi cun loh raꞌ gubieerna pura riachiistoꞌ tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yaca zahca tu garaa deeꞌ chiꞌchi gaca guiñiꞌ tu xchiꞌdxyiꞌhn loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ayi guunn tu ziahan lligaaba nastoꞌ tu xa guiñiꞌ tu loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","naꞌh gahca guꞌnnasiinahn laꞌh tu cun dxyiꞌdxyi nin guiñiꞌ tu, nee guniꞌhihn guelrahcabwaꞌ laꞌh tu tin gusieꞌw tu rwaaꞌ chyuuchiꞌhzi nin guiñiꞌ tohnta loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","per hasta bwiinn xjwamihyi tu neezaa lasaaꞌ tu, cun nin ruchaꞌga tu guiclaaꞌdzi chiinn raꞌ laꞌh tu nee zidxiinn raꞌ ba paaldaa tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Neezaa garaa raꞌ bwiinn guidxyiyuh guidxyiꞌchinee raꞌ laꞌh tu laasii riachiistoꞌ tu xchiꞌdxyiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","per ayi ñichloh nin tuhbi dxyichyihca tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","nee sidela ayi cweꞌhestoꞌ tu xchiꞌdxyi Dxiohs zilaꞌh tu loh duhlda tin guziaa tu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ya chin gwaꞌha tu ziahanrooꞌ suldahdu rii gadiidxi guihdxyi Jerusalehn, chiꞌchi gacabwaꞌ tu laꞌdxyih badzihn ñichilohon. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ya chin gwaꞌha bwiinn raꞌ gaca niꞌchi, chiꞌchi nahpa guiriaꞌh raꞌ bwiinn guihdxyi Judea yihdzi raꞌ ba guzee raꞌ ba loh dahan; ya bwiinn nin rii raꞌla loh dahan ayiru guibiaꞌgarii raꞌ ba chegalliꞌhi raꞌ ba xixteenn raꞌ ba yihdzi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","tin laꞌn dxyih raꞌ chi guunn Dxiohs jwiisi loh guidxyiyuh tin gaca ziga rñiꞌ dxyiꞌdxyi nin caa loh xchihtsi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Prohbi gunnaꞌh raꞌ nin nuꞌa lliiꞌn, prohbiza gunnaꞌh raꞌ nin caꞌha badoꞌ laꞌn dxyih raꞌ chi. Zwaꞌha raꞌ ba guelnadxyiꞌbi duxa nin gaca cun bwiinn raꞌ nin rii Israel. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nuu raꞌ ba gachi raꞌ ba loh guehrru, snuhn raꞌ ba guzee prehsu, guzee raꞌ ba garaa guihdxyi ziitu raꞌ, ya bwiinnziitu raꞌ chuunaa raꞌ ba gaduhbi guihdxyi Jerusalehn hastayi gazaaꞌ dxyih nin gabiaꞌgarii bwiinn Israel, chiꞌchi gareꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Rahbiza Ñiꞌh: ―Chiꞌchi gaca raꞌ sehn loh gubihdxyi cun loh bweꞌhw neezaa dxih nin nuu llaaꞌndxibaaꞌ; ya loh guidxyiyuh garaa raꞌ bwiinn guidxyihbi raꞌ ba laasii nin ayi gacabwaꞌ raꞌ ba xa guunn raꞌ ba chin dxihn raꞌ ba cayuuꞌbwih taaꞌha ñihsadoꞌ nee taantu jweersi nin rzihdzi cwidxyidxiah ñihsadoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ya bwiinn raꞌ zicahyi raꞌ ba saca nin gwaꞌha raꞌ ba gaca loh guidxyiyuh neezaa saca nin gwaꞌha raꞌ ba guiñiꞌbi garaa nin nuu llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ya chiꞌchi gwaꞌha raꞌ ba gadzihnaꞌhn ziga Lliiꞌn Dxiohs nin naa ndxiꞌhw, dxieꞌldahn laꞌn xcahyi cun gaduhbi guelrnabwaꞌ nee cun tuhbi bachaꞌha rooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chin saꞌloh gaca raꞌ cohsa raꞌ riiꞌ, ayi guidxyihbi tu; gulcwihsi, gulguiaꞌha nez guiyaꞌ tin lwehgusi gadzihn dxyih nin guziꞌlaaꞌdzi tu, taꞌh tu loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bwiiꞌydxyiꞌdxyi za Ñiꞌh stuhbi cweenta loh raꞌ ba, rahbi Ñiꞌh: ―Gulguiaꞌha loh tuhbi yahga ñiigu, neezaa loh garaa raꞌ yahga. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chin gwaꞌha tu laꞌ raꞌ yahga cabweꞌhe bwiiꞌniꞌhn, laꞌh gahca tu gacabwaꞌ tu lwehgusi gadzihn bweꞌhw nin dxiaaba ñihsadxiah. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ziꞌchi gahcaza chin gwaꞌha tu laꞌ raꞌ cohsa raꞌ riiꞌ cayahca laꞌh gahca tu gacabwaꞌ tu amweer gadzihn xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Guchiin nin rñiꞌn loh tu, garaa raꞌ cohsa riiꞌ gacan antes gachi raꞌ bwiinn nin nabahan raꞌ chieempa chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dxibaaꞌ cun guidxyiyuh ziñihchilohraꞌn, per xchiꞌdxyiꞌhn ayi ñichilohon. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Gulgaca nasiin tin ayi guunn tu lligaaba ayi guxiꞌhn tu xjweersi tu loh guelreeꞌ, loh guelrahw zaꞌca, neezaa lligaaba ziahan xteenn xica nin rchiꞌhn tu laasii sidela guunn tu squiiꞌ zinaꞌzu dxyih chi laꞌh tu nee guunnan mahla laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","laasii ziꞌchi gariaꞌcaa dxyih chi loh garaa raꞌ bwiinn guidxyiyuh, ziga tuhbi traampa nin rieꞌw goolpi. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Niꞌchin rñaan loh tu gulgaca nasiin. Ayi gucweꞌza tu cwidxyi-guinaaba loh Dxiohs tin taꞌh tu loh garaa nin gaca tin gacaza suh tu loh Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Radxyii ruluuꞌyi Jesuhs laꞌh raꞌ bwiinn laꞌn guidoꞌrooꞌ, ya gueꞌla riadxiaꞌhan Ñiꞌh hasta rwaaꞌ dahan nin laa de los Olivo. ");
INSERT INTO zpvNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ya guillii-guillii riah raꞌ bwiinn rsiiyigah rwaaꞌ guidoꞌ chi tin rucaꞌdxiahga raꞌ ba nin ruluuꞌyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ya laꞌh lañih paascu zeꞌgadzihn chin rahw raꞌ bwiinn Israel pahn nin ayi rahcachaꞌyi cun levadura, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ya bwiinn raꞌ nin rnabwaꞌ raꞌ laꞌh bixohza neezaa bwiinn raꞌ nin ruluuꞌyi xlehyi Moisehs cadxiꞌhyi raꞌ ba xa guunn raꞌ ba tin chiinn raꞌ ba laꞌh Jesuhs laasii rdxyihbi raꞌ ba bwiinn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ya chiꞌchi guyuuꞌtii bwiinndxaaba nin laa Satanahs stoꞌ Judas nin laa gahca Iscariote, nee gahca laꞌh ba naa ba xpwiinn Jesuhs nin naa gadziꞌh bichiohpa xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ya bwiinn chi gwaguihtsi loh raꞌ bixohza raꞌ nin rnabwaꞌ loh raꞌ bixohza cun loh raꞌ daada nin rnabwaꞌ laꞌh guixaꞌga raꞌ nin rahpa guidoꞌ. Guñiꞌnee Judas laꞌh raꞌ ba xa guunn ba tin gutiꞌdxi ba laꞌh Jesuhs loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chiꞌchi biahxi raꞌ ba ya guhdzi raꞌ ba loh Judas guicaꞌha ba nuhn mweeyi sidela dxiuꞌn ba ntriehgu laꞌh Ñiꞌh pur mweeyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chiꞌchi guziꞌguehlda Judas ya guzaꞌloh cadxiꞌhyi ba xa guunn ba gutiꞌdxi ba laꞌh Jesuhs loh raꞌ bwiinn chi mwedxi ralaꞌn tin ayi gacabwaꞌ raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Badzihn dxyihlañih chin rahw raꞌ ba pahn nin ayi rahcachaꞌyi cun levadura bieꞌ rdxiinn raꞌ ba tuhbi lliꞌhyi ziga caa loh xchihtsi guehtu Moisehs, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","chiꞌchi guxeꞌhla Jesuhs Pehdru cun Jwahn, rahbi Ñiꞌh loh raꞌ ba: ―Gulcheguiꞌhnnchaꞌyi xi guidaꞌwxchih nuꞌh nin naa xchih pascu. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chiꞌchi gunabadxyiꞌdxyi raꞌ ba loh Ñiꞌh, rahbi raꞌ ba: ―¿Canehza xclaaꞌdzi luꞌh gachidiꞌhnnchaꞌyi nu guelwahw? ");
INSERT INTO zpvNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chiꞌchi rahbi Jesuhs: ―Chin chuꞌtii tu lahda guihdxyi, zadxaꞌga tu tuhbi bwiinn nin nuꞌa tuhbi riiꞌ ñihsa; chiꞌchi chenaꞌhla tu ba hasta dxiuꞌgarii ba yihdzi ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","chiꞌchi guinabadxyiꞌdxyi tu loh nin naan yihdzi Ñiꞌh, squii gahbi tu: “Nnaa Daada Mwehsu: ¿Canehza riaꞌhan cwaartu hasta gahwchihnee ba xpwiinn ba xchih pascu?” ");
INSERT INTO zpvNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ya bwiinn chi lwehgusi guluuꞌyi ba hasta naa cwarturooꞌ nin nuu guiyaꞌ laꞌn naa liistula. Riꞌchi guiguihn tu nin guidaꞌwxchih nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ya chin badzihn raꞌ ba riꞌchi, guyaa bareꞌcaa garaatiiꞌ nin guhdzi Jesuhs laꞌnriila. Chiꞌchi bwiꞌhnnchaꞌyi raꞌ ba xchih pascu. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ya chin badzihn hohra, badzihnnee Jesuhs spaaldaa xpwiinn Ñiꞌh chiꞌchi gurih raꞌ ba gadiidxi mweella, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Blaaca nasaa cayahwxchihneen laꞌh tu xchih pascu antes que naꞌh sacaziin cun gachiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","nen xñaxgaaꞌhn loh tu ayiru gabiaꞌgarii gahwneꞌhn laꞌh tu xchih pascu galoh gadzihn dxyih gacan loh xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chiꞌchi gucaꞌha Ñiꞌh tuhbi copa vihnnu, badiꞌhi Ñiꞌh guelzuxchilli loh Dxiohs, chiꞌchi rahbi Ñiꞌh: ―Gulgueeꞌ deeꞌ gulchiꞌzi gahcan loh lasaaꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","nen ñaan loh tu ayiru gabiaꞌgarii gueeꞌneen laꞌh tu ñihsa uhva stuhbi galoh nin gadzihn xquel rnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chiꞌchi gucaꞌha gahca Ñiꞌh tuhbi pahn, badiꞌhi Ñiꞌh guelzuxchilli loh Dxiohs, hohrachi gutaaꞌha Ñiꞌhn, gudxiꞌzi Ñiꞌhn loh raꞌ ba, chiꞌchi rahbi Ñiꞌh: ―Deeꞌ naa ziga tiꞌxihn nin gutiꞌdxiꞌhn loh guelguhchi xcweenta tu, ya squiiꞌ gahca guunn tu tin dxiagannastoꞌ tu naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ziꞌchi gahcaza bwiꞌhnnee Ñiꞌh copa chin guluhlla gudahwxchihnee Ñiꞌh laꞌh raꞌ ba, rahbi Ñiꞌh loh raꞌ ba: ―Vihnnu nin nuu laꞌn copa riiꞌ naa ziga rihn nin nuuꞌhuhn, nin guixiꞌhihn chin chiinn raꞌ ba naꞌh xcweenta tu, tin ziꞌchi gaca dxyiꞌdxyicuubi nin gusiaꞌhan Dxiohs cun bwiinn raꞌ nin bibwiꞌhiraꞌla. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yannah gulguiaꞌha laꞌnaa bwiinn nin gutooꞌ naꞌh dziꞌbanee naaꞌhahn loh mweella riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","nee guchii nahpa gutiꞌdxiloon trabahjw duxa, laasii naan Bwiinn nin guxeꞌhla Dxiohs nahpa zareꞌcaa garaa nin caa loh xchihtsi Dxiohs, ¡per prohbiza bwiinn nin gutooꞌ naꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chiꞌchi guzoꞌbaloh canabadxyiꞌdxyi loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Chyuniꞌca guunn ziꞌca? ");
INSERT INTO zpvNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Neezaa guzaꞌloh cayuuꞌyidxyiꞌdxyi raꞌ ba xcweenta chyu mahzi lasahca loh raꞌ ba; ");
INSERT INTO zpvNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Rehyi raꞌ nin rnabwaꞌ loh raꞌ bwiinn nin ayi naa bwiinn Israel ruhnn nayaachi raꞌ ba nee xclaaꞌdzi raꞌ ba guiñiꞌ xpwiinn raꞌ ba loh raꞌ ba: “Bwiinn zaꞌca luꞌh”, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","per laꞌh tu ayi gaca tu ziꞌchi, sino que nin mahzi lasahca loh tu ayi chiꞌhyi ba guiñiꞌ zaꞌca bwiinn xcweenta ba; mejor gusaꞌn ba zigachiꞌhzi guiñiꞌ bwiinn loh ba, nee nin mahzi rnabwaꞌ nahpa gaca ba ziga mooza tin mahziru gacanee ba lasaaꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Cuunn nin mahzi lasahca; ta bwiinn nin rzohba loh mweella rahw o bwiinn nin raziꞌlaaꞌdzi guelwahw? ¿Tayigah guchiidxiꞌh bwiinn nin rzohba loh mweella? Per naꞌh nicala rnabwaꞌn loh tu per laꞌndxaꞌga zigazi tuhbi bwiinn nin rniꞌhi xi rahw tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Laꞌh tu naa tu bwiinn raꞌ nin biaꞌhanee naꞌh gaduhbi gudiꞌdxiꞌhn trabahjw nin gudiꞌdxiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","niꞌchin nin guniꞌhihn guelrnabwaꞌ laꞌh tu ziga baniꞌhi Xpaaꞌnñin naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tin gahw tu guee tu cwih tu loh xmweeꞌllahn llaaꞌn dxibaaꞌ, soobaa gahca tu loh yagaxiiyi bwiinn nin rnabwaꞌ tin guunn tu guelguxchiisi loh gadziꞌh bichiohpa cwaꞌh xjwamihyi Israel. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chiꞌchi rahbi Jesuhs loh Simohn: ―Simohn, Simohn; laꞌbwiinndxaaba nin laa Satanahs gunaaba yiꞌh tin tsiibi ba yiꞌh zigazi rbiꞌbi llooba chin nuuꞌhun deh, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","per naꞌh laꞌn gunaaba loh Dxiohs pur yiꞌh tin ayi cweꞌhestoꞌ luꞌh xchiꞌdxyi Dxiohs, ya chin gabiaꞌgarii luꞌh loh Dxiohs, chiꞌchi gacanee raꞌ luꞌh lasaaꞌ luꞌh tin dxiaꞌhannee raꞌ ba xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chiꞌchi rahbi Pehdru loh Ñiꞌh: ―Daada, laꞌnzuu liistula tin dxieꞌwneꞌhn yiꞌh, nicala gachiza nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chiꞌchi rahbi Jesuhs loh ba: ―Pehdru, nnah gahca ñaan loh luꞌh galoh gucaꞌyahnn dxiidxinguhla, guiñiꞌ luꞌh mas chohnna bweelta ayi nuꞌmbwaꞌtiiꞌ luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chiꞌchi gunabadxyiꞌdxyi Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―Chin guxeꞌhlaꞌhn laꞌh tu bagaluuꞌyi tu laꞌh raꞌ bwiinn xchiꞌdxyi Dxiohs, ayi gwanee tu buxa, nin dxihdximweeyi nin tuhbi tahgaza tahba tu, ¿ta guyuuꞌ xiilla biaꞌdxyi tu? Chiꞌchi rahbi raꞌ ba: ―Lliitiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chiꞌchi rahbi Ñiꞌh: ―Per nnah ñaan loh tu, nin nahpa buxa, chenee ban; nin nahpa dxihdximweeyi, cheneezaa ban; nin ayi nahpa spahda, gutooꞌ ba xchiquehta ba tin siꞌ ba tuhbin; ");
INSERT INTO zpvNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","tin rñaan loh tu nahpa gaca ziga caa loh Xchihtsi Dxiohs pur naꞌh; rñiꞌ dxyiꞌdxyi raꞌ chi: “Batiꞌdxi raꞌ ba laꞌh ba hasta nuu raꞌ bwiinn mahla.” Garaa nin caa loh xchihtsi Dxiohs pur naꞌh nahpa gacan. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Daada, riiꞌ laꞌchiohpa spahda nuuꞌ. Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Cun sola niꞌcasi zahlda, ayi xchiꞌhn ziahan. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chiꞌchi biriaꞌh Jesuhs zee Ñiꞌh loh dahan nin laa Olivo laasii ziꞌchi naa xcostumbre Ñiꞌh zenaꞌhlagah xpooxtla Ñiꞌh laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ya chin badzihn raꞌ ba riꞌchi, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Gulguinaaba loh Dxiohs tin ayi gusaguiꞌhi bwiinndxaaba laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chiꞌchi biriaꞌcaa Jesuhs tuhbi lahdu hasta rii raꞌ ba, zigachiꞌh hasta radzihn tuhbi dxiah nin rucaꞌh bwiinn, chiꞌchi bazuꞌnllihbi Ñiꞌh riꞌchi tin gudihdxyi-gunaaba Ñiꞌh loh Xtaada Ñiꞌh nin naa Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","squiiꞌ: ―Paah, ¿tayi gaca guchaꞌh xigaaba luꞌh tin guhldaꞌh luꞌh naꞌh loh trabahjw duxa nin gutiꞌdxiloon? Per sidela ayi nuuꞌhun, ayiza xi ruhnn tiꞌdxiꞌhñin. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chiꞌchi baluuꞌyiloh tuhbi aanjla nin guxeꞌhla Xtaada Ñiꞌh tin gacanee Ñiꞌh laꞌh Jesuhs guunn Ñiꞌh waanta gutiꞌdxiloh Ñiꞌh trabahjw chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ya pur taantu nin cadiiꞌdxi Ñiꞌh trabahjw, niꞌchin nin mahzi cabwihdxyi Ñiꞌh loh Xtaada Ñiꞌh nee taantu nin cayahcanaꞌyi Ñiꞌh pur gota ñihsa cayaaba loh yuh gota chi rñahan ziga rihn. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ya chin guyaꞌloh gudihdxyi-gunaaba Ñiꞌh loh Xtaada Ñiꞌh, chiꞌchi gwasuꞌnchii Ñiꞌh tin gwaguiaꞌha Ñiꞌh cuun raꞌ xpwiinn Ñiꞌh, ya chin badzihn Ñiꞌh riꞌchi bwaꞌha Ñiꞌh laꞌ raꞌ ba naꞌxgahsi pur guelnalaasa nin nuu stoꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xixnaa naꞌxgahsi tu? Gulchestii gulguinaaba loh Dxiohs tin ayi gusaguiꞌhi bwiinndxaaba laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Gaduhbi cañiꞌ gahca Jesuhs loh raꞌ xpwiinn Ñiꞌh, badzihn ziahan bwiinn hasta rii raꞌ ba, delanta loh raꞌ ba ñiidxiuu tuhbi bwiinn nin laa Judas xpwiinn gahca Jesuhs laꞌh ba, chiꞌchi gwabiiga ba hasta zuu Jesuhs tin bachaꞌgarwaꞌ ba loh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chiꞌchi rahbi Jesuhs loh ba: ―Judas, ¿ta pur tuhbi behsu riiꞌ riuꞌn luꞌh ntriehgu Lliiꞌn Dxiohs nin naa ndxiꞌhw loh raꞌ bwiinn riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ya chin bwaꞌha raꞌ xpwiinn Ñiꞌh nin rii gadiidxi Ñiꞌh nin cayahca riꞌchi, chiꞌchi gunabadxyiꞌdxyi raꞌ ba loh Jesuhs, rahbi raꞌ ba: ―Daada, ¿ta zadiꞌhigoolpi nu laꞌh raꞌ bwiinn ca cun spahda? ");
INSERT INTO zpvNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chiꞌchi bachyuuꞌga tuhbi xpwiinn Jesuhs dxiahga tuhbi xmooza bwiinn nin rnabwaꞌ loh raꞌ bixohza, bachwaꞌha ba tuhbi lahdu dxiahga derehchu bi, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―¡Gulgasaaꞌn ba! ¡Cun sol niꞌca! Chiꞌchi badxiꞌhyi Jesuhs dxiahga mooza chi bachiꞌdxu Ñiꞌhn talguꞌnsi biaca zaꞌcan, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","chiꞌchi guñiꞌ gahca Jesuhs loh raꞌ bwiinn nin rnabwaꞌ loh raꞌ bixohza neezaa bwiinn raꞌ nin naa guixaꞌga xteenn guidoꞌ neezaa bwiinnguuhla raꞌ nin zeꞌ tin chenee raꞌ ba laꞌh Ñiꞌh, rahbi Ñiꞌh: ―Xluuꞌyi nee spahda cun garrohta nuꞌa tu zeꞌ tu ziga chin guinaꞌzu tu tuhbi gubaꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","¿xixnaa chin guyuꞌneꞌhn laꞌh tu laꞌn guidoꞌ garaa dxyih ayi gunaꞌzu tu naꞌh?, per nnahyi bigaꞌha xohra tu guunn tu nin xclaaꞌdzi bwiinndxaaba gaca. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chiꞌchi gunaꞌzu raꞌ ba laꞌh Jesuhs tin zenee raꞌ ba laꞌh Ñiꞌh yihdzi bixohza nin rnabwaꞌ loh garaa raꞌ bixohza, cun nee Pehdru naꞌhlazihtu laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ya chin badzihn raꞌ ba riꞌchi, chiꞌchi gulahchi raꞌ ba dxih gadiidxin tin babihdxyi raꞌ ba; nee Pehdru dxaꞌga loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ya chin bwaꞌha tuhbi gunnaꞌh nin ruhnn dziꞌn riꞌchi zohba gabihdxyi Pehdru, chiꞌchi bwaꞌha-bwaꞌha bi loh Pehdru, chiꞌchi rahbi bi: ―¡Nee ndxiꞌhw riiꞌ naa xpwiinn Jesuhs! ");
INSERT INTO zpvNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per Pehdru ayi gudxixteeꞌ bi nuꞌnbwaꞌ bi Jesuhs, rahbi bi: ―Gunnaꞌh, ayi nuꞌnbwaꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ya snuhnsi rahca, guriin bwiinn lagaꞌh nin bwaꞌha laꞌh Pehdru, chiꞌchi rahbi ba: ―¡Cun neezaa luꞌh naa tuhbi raꞌ xpwiinn Jesuhs! Per Pehdru rahbilagaꞌh ba: ―Ñaan loh luꞌh daada, ayi needxiꞌhn naan xpwiinn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ya guhca mahs tuhbi hohra badzihn stuhbi bwiinn guzaꞌloh cañiꞌ ba, rahbi ba: ―¡Guchiin, nee bwiinn riiꞌ guyuꞌnee ba nen cun neezaa laasii naa ba tuhbi bwiinn Galilea! ");
INSERT INTO zpvNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chiꞌchi rahbi Pehdru loh ba: ―Per daada, ¡ayi rahcabwaꞌn xiniꞌca nugazeꞌta luꞌh! Ya hohra gahca nin cañiꞌ Pehdru bacaꞌyahnn tuhbi dxiidxinguhla, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","chiꞌchi basiaꞌgarii loh Jesuhs bwaꞌha Ñiꞌh loh Pehdru, chiꞌchi bagannastoꞌ Pehdru dxyiꞌdxyi nin guñiꞌ Jesuhs loh ba: “Galoh nin gucaꞌyahnn dxiidxinguhla nnadxyih, guiñiꞌ luꞌh loh raꞌ bwiinn chohnna bweelta gahbi luꞌh ayi nuꞌnbwaꞌtiiꞌ luꞌh naꞌh”, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","chiꞌchi bariaꞌh Pehdru guzaꞌloh cayuꞌn bi nalaasa duxa. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ya bwiinn raꞌ nin canee laꞌh Jesuhs guzaꞌloh cagallihdzinee raꞌ ba laꞌh Ñiꞌh neezaa cagadiꞌhigoolpi raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","neezaa basieꞌw raꞌ ba loh Ñiꞌh chiꞌchi gudahpa raꞌ ban, rahbi raꞌ ba: ―Pwihsi yiꞌh ziga naa luꞌh Crixtu, ¡guhcabwaꞌ chyuñin nin gudahpa loh luꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Neezaa caguii xaꞌta raꞌ ba loh Ñiꞌh cañiꞌyah duxa raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ya chin barah gueꞌla, badiaaꞌha raꞌ bwiinnguuhla nin rnabwaꞌ neezaa bwiinn raꞌ nin rnabwaꞌ loh bixohza raꞌ neezaa bwiinn raꞌ nin ruluuꞌyi xlehyi Moisehs; gwanee raꞌ ba laꞌh Jesuhs, chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Sidela guchii luꞌh naa luꞌh Crixtu, chixteeꞌ luꞌh loh nu. Chiꞌchi guñiꞌ Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―Sidela guiñaan, “Uhn”, ayi chechiistoꞌ tu naꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ya sidela guinaꞌbadxyiꞌdxyiꞌhn loh tu, ayi gusiaꞌgarii tu dxyiꞌdxyi, ");
INSERT INTO zpvNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","per deznnah laꞌLliiꞌn Dxiohs nin naa ndxiꞌhw soobaa nehz lahdu derehchu cweeꞌ Dxiohs nin nuu llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chiꞌchi gunaabadxyiꞌdxyi garaa raꞌ ba, rahbi raꞌ ba loh Ñiꞌh: ―¿Tayichiꞌh naa luꞌh Lliiꞌn Dxiohs? Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh gahca tu nnah tu naan ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chiꞌchi laꞌ gahca raꞌ ba rahbi loh lasaaꞌ raꞌ ba: ―¿Xi xclaaꞌdzi tu nnah? Ayiru xchiꞌhn guiñiꞌru bwiinn ca laasii laꞌh gahca nuꞌh bihn nuꞌh dxyiꞌdxyi raꞌ nin guñiꞌ ba, ¡ya dxyiꞌdxyi chi gahca guunn guelguxchiisi laꞌh ba! ");
INSERT INTO zpvNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chiꞌchi gwasuꞌnchii garaa raꞌ ba tin gwanee raꞌ ba Jesuhs loh Pilahtu. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ya chin badzihnnee raꞌ ba Jesuhs riꞌchi, guzaꞌloh cagacaꞌchiah raꞌ ba laꞌh Jesuhs, rahbi raꞌ ba: ―Bwiinn riiꞌ bachinaꞌzu nu laasii cagasaguiꞌhi ba ziahanrooꞌ raꞌ bwiinn, nee rahbi ba ayi nahparu chyu gachidxihlli mweeyi xteenn impweestu loh Rehyi César, nee rahbiza ba naa ba Crixtu zigazi Rehyi loh raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chiꞌchi gunaabadxyiꞌdxyi Pilahtu loh Jesuhs, rahbi ba: ―¿Ta yiꞌh naa luꞌh xrrehyi raꞌ bwiinn Israel? Chiꞌchi rahbi Jesuhs: ―Ziꞌchi, yiꞌh gahca guñiꞌ luꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chiꞌchi rahbi Pilahtu loh raꞌ bwiinn nin rnabwaꞌ laꞌh raꞌ bixohza cun loh raꞌ garaa raꞌ bwiinn nin rii riꞌchi: ―Ayi rdxeelaꞌhn nin tuhbi xtuhlda bwiinn riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per laꞌh raꞌ ba cun mahziru jweersirooꞌ rahbi raꞌ ba: ―Garaa raꞌ bwiinn Judea cayuuꞌyitii loh dxyiꞌdxyi dxixiꞌhw nin rluuꞌyi ndxiꞌhw riiꞌ. Guzohbaloh cagaluuꞌyi ba dxyiꞌdxyi xihn raꞌ loh guihdxyi Galilea, nee nnah laꞌba zeꞌlagaꞌh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ya chin bihn Pilahtu garaa deeꞌ, chiꞌchi gunaabadxyiꞌdxyi ba rahbi ba: ―¿Ta bwiinn Galilea bwiinn riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chiꞌchi rahbi raꞌ ba: ―Uhn, bwiinn Galilea ba. Ya chin bihn Pilahtu bwiinn Galilea Ñiꞌh, chiꞌchi guxeꞌhla Pilahtu laꞌh Jesuhs loh Herodes tin guunn ba guelguxchisi xcweenta Jesuhs, laasii Herodes naa gobernador guihdxyi Galilea, nee laꞌn dxyih raꞌ chi gahca badzihn Herodes guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ya seguihdu badzihnnee raꞌ ba Jesuhs hasta badzihn Herodes loh guihdxyi Jerusalehn, ya chin bwaꞌha Herodes laꞌh Jesuhs, biahxi Herodes laasii dez cadxyih xclaaꞌdzi ba gwaꞌha ba laꞌh Jesuhs laasii bihn ba ruhnn Jesuhs ziahan milahgru raꞌ, ya xclaaꞌdzi duxa ba gwaꞌha ba guunn Jesuhs milahgru raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ya ziahanrooꞌ dxyiꞌdxyi gunaabadxyiꞌdxyi Herodes loh Jesuhs ya nin tuhbi dxyiꞌdxyi raꞌ chi ayi guñiꞌ Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Neezaa jefe raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza rii riꞌchi cun mwehsu raꞌ nin ruluuꞌyi lehyi, dee raꞌ nin cagacaꞌchiah laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ya seguihdu Herodes cun xsuldahdu ba bwiꞌhnn raꞌ ba buhrla laꞌh Jesuhs gudzihtanee raꞌ ba laꞌh Ñiꞌh chiꞌchi bagahcu raꞌ ba laꞌh Jesuhs tuhbi lahdxi zaꞌca ziga nin rahcu tuhbi rrehyi, ya seguihdu gahca guxeꞌhla lagaꞌh Herodes laꞌh Jesuhs loh xquelguxchiisi Pilahtu stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dxyih gahca chi biahca Pilahtu xamihgu Herodes nee galoh bidxyiꞌchinee lasaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chiꞌchi batiaaꞌha Pilahtu jefe raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza cun guxchiisi raꞌ nin rnabwaꞌ cun garaa raꞌ bwiinn guihdxyi Jerusalehn chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","chiꞌchi rahbi Pilahtu loh raꞌ ba: ―Laꞌh tu bieꞌnee tu bwiinn riiꞌ loon, nnaa tu ziahanrooꞌ bwiinn cagaluuꞌyi ba dxyiꞌdxyi xihn raꞌ; per bwaꞌhalohza tu delaanta loh tu gunaabadxyiꞌdxyiꞌhn cohsa raꞌ nin nnaa tu cayuhnn ba, per nnah bwaꞌha tu ayi xi duhlda nahpa ba cun xcweenta raꞌ cohsa nin rcaꞌchiah tu laꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","nin Herodes ayi bidxeela xtuhlda bwiinn riiꞌ, niꞌchin nin rñiꞌn loh tu ayi xi duhlda nahpa ba para gachi ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Niꞌchin nin mejor guinabwaꞌn guicahyahgazi ba cun cwaarta, chiꞌchi guhldaꞌhn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ya garaa yihza nin rahca lañih pascu rutaꞌh Pilahtu tuhbi bwiinn nin ñeꞌw. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per laꞌh raꞌ ba tuhbisi guñiꞌ garaa raꞌ ba jweersi, rahbi raꞌ ba: ―¡Gudxiinn laꞌh Jesuhs bachiꞌh baldaꞌh Barrabahs! ");
INSERT INTO zpvNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabahs riiꞌ bieꞌw ba laꞌn lahtsidxiꞌba laasii gudxihndxinee ba suldahdu romanu raꞌ nin rii guihdxyi chi nee naaza ba tuhbi bwiinn nin rdxiinn bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ya guclaaꞌdzi Pilahtu ñuldaꞌh ba laꞌh Jesuhs, niꞌchin guñiꞌ ba stuhbi, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","per laꞌh raꞌ bwiinn ziahan chi mahziru jweersirooꞌ rahbi raꞌ ba: ―¡Bacaꞌh ba loh cruhzi!, ¡bacaꞌh ba loh cruhzi! ");
INSERT INTO zpvNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ya chin biohnna bweelta rñiꞌ Pilahtu loh raꞌ ba, rahbi ba: ―¿Per xi mahla cayuhnn ba? Ayi xi xtuhlda ba rdxeelaꞌhn para gachi ba loh dxyiꞌdxyi raꞌ nin rnaꞌbadxyiꞌdxyiꞌhn loh ba, niꞌchin nin guinabwaꞌn guicahyahgasi ba cun cwaarta, chiꞌchi guhldaꞌhn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per laꞌh raꞌ ba mahziru jweersirooꞌ cabwihdxyidxiah raꞌ ba tin canaaba raꞌ ba guicah Ñiꞌh loh cruhzi, ya taantu nin rbwihdxyidxiah raꞌ ba hasta que no bwiꞌhnn raꞌ ba gahn nin guclaaꞌdzi raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","chiꞌchi bidxaꞌh xigaaba Pilahtu ya gunabwaꞌ ba gucah Jesuhs loh cruhzi ziga gunaaba raꞌ bwiinn Israel chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ya mejor baldaꞌh ba laꞌh Barrabahs laꞌn lahtsidxiꞌba, ya chiꞌchi bwiꞌhnn Pilahtu ziga guclaaꞌdzi raꞌ bwiinn Israel raꞌ chi basaꞌcazii ba laꞌh Jesuhs gudxiinn ba laꞌh Ñiꞌh loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chin zenee raꞌ ba Jesuhs guicah loh cruhzi, chiꞌchi gunaꞌzu raꞌ ba tuhbi bwiinn Cirene nin laa Simohn, gueꞌdu zieꞌ ba gwah ba dahan, ya basaguꞌa raꞌ ba laꞌh ba cruhzi ya naꞌhla ba laꞌh Jesuhs ");
INSERT INTO zpvNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","cun neezaa ziahan bwiinn. Ya lahdaa raꞌ bwiinn ziahan chi guyuuꞌ paaldaa raꞌ gunnaꞌh nin ruꞌn raꞌ laasii riaa raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","chiꞌchi basiaꞌgariiloh Jesuhs bwaꞌha Ñiꞌh loh raꞌ ba, chiꞌchi rahbi Ñiꞌh: ―Gunnaꞌh Jerusalehn raꞌ, ayi ruꞌn tu pur naꞌh; guldxiꞌn pur laꞌh gahca tu neezaa pur lliiꞌn raꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","laasii ziꞌ dxyih nin guiñiꞌ raꞌ bwiinn: “Riahxi raꞌ gunnaꞌh raꞌ nin ayi riuuꞌ lliiꞌn Ñiꞌh, nee riahxiza gunnaꞌh raꞌ nin ayi rudiꞌhi duuda guee lliiꞌn Ñiꞌh”, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ya zizaꞌloh guiñiꞌ raꞌ bwiinn loh dahan raꞌ: “Guldxiaaba yihca nu”, ya loh raꞌ lohmma gahbi raꞌ ba: “Guluꞌlaꞌn laꞌh nu”, ");
INSERT INTO zpvNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","laasii sidela squiiꞌ ruhnnee raꞌ ba naꞌh nin naa ziga tuhbi yahga nabahan, ¿xallachiꞌh laꞌh tu xa gunnee raꞌ ba naa tu ziga tuhbi yahgabihdzi? ");
INSERT INTO zpvNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Neezaa chiohpa bwiinn mahla zenee raꞌ ba tin gachi raꞌ ba tuhbisi cun Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ya chin badzihnnee raꞌ ba Jesuhs tuhbi lahta nin laa yihca bwiinnguuchi, riꞌchi bacaꞌh raꞌ ba laꞌh Ñiꞌh loh cruhzi cun schiohpa bwiinn mahla chi; tuhbi ba lahdu derehchu stuhbi ba lahdu rrabwehsa. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ya chin cagacaꞌh raꞌ ba Jesuhs loh cruhzi, chiꞌchi guñiꞌ Jesuhs rahbi Ñiꞌh: ―Paah, basiaꞌpitii xtuhlda bwiinn raꞌ riiꞌ laasii ayi gaann raꞌ ba xiñin cayuhnn raꞌ ba. Ya loh xahba Jesuhs gudzihta raꞌ suldahdu chi baraja tin basaaꞌ raꞌ ba sweerta tin guigaꞌzi xahba Jesuhs guicaꞌha raꞌ ba ");
INSERT INTO zpvNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ya ziahan raꞌ bwiinn rii riꞌchi riiywaꞌha cacaa Jesuhs loh cruhzi, ya hasta bwiinn raꞌ nin rnabwaꞌ laꞌh raꞌ ba cagallihdzinee raꞌ ba laꞌh Jesuhs, rahbi raꞌ ba: ―Baldaꞌh ba paaldaa bwiinn loh ziahan cohsa galoh yannah ¡guhldaꞌh ba laꞌh gahca ba sidela guchii ba naa ba Crixtu nin guxeꞌhla Dxiohs! ");
INSERT INTO zpvNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Neezaa raꞌ suldahdu bwiꞌhnn buhrla laꞌh Ñiꞌh yaque caa Ñiꞌh loh cruhzi badiꞌhi raꞌ ba vihnnu naltaa gwaaꞌ Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Sidela guchii luꞌh naa luꞌh xrrehyi raꞌ bwiinn Israel, ¡baldaꞌh yiꞌh gahca! ");
INSERT INTO zpvNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ya letra nin gu cah yihca xcruhzi Jesuhs caaꞌhan cun dxyiꞌdxyi griegu, dxyiꞌdxyi latihn, cun neezaa dxyiꞌdxyi hebreu ya rñiꞌn squii: “Deeꞌ naa xrrehyi bwiinn Israel.” ");
INSERT INTO zpvNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ya tuhbi bwiinn mahla nin caa loh stuhbi cruhzi guñiꞌ tohnta ba loh Jesuhs, rahbi ba: ―Sidela guchii luꞌh naa luꞌh Crixtu, baldaꞌh yiꞌh gahca nee guhldaꞌhza luꞌh laꞌh nu. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chiꞌchi guñiꞌ stuhbi bwiinn mahla nin caa stuhbi lahdu cweeꞌ Jesuhs, rahbi ba loh xcompañeru mahla ba chi: ―¿Tayi rdxyihbi luꞌh Dxiohs nee gu rwaꞌha luꞌh amweerla gachi luꞌh pur xtuhlda luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bayi laꞌh nuꞌh rgaꞌha cayahca nuꞌh caxchihgu ruhnn merehsan laꞌh nuꞌh tin gachidxihlli nuꞌh garaa nin bidiꞌhnn nuꞌh; per bwiinn rii ayi xi cohsa dxaaba bwiꞌhnn ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chiꞌchi rahbi ba loh Jesuhs: ―Jesuhs, bazaꞌstoꞌ luꞌh naꞌh dxyih nin soꞌbaloh guinabwaꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chiꞌchi rahbi Jesuhs loh ba: ―Guchiin nin ñaan loh luꞌh, desde nnadxyih gahca cheneꞌhn yiꞌh para llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Guhcan zigachiꞌh laaꞌyidxyih, hohrachi gahca biꞌ tuhbi gueꞌla gaduhbitiiꞌ guidxyiyuh hasta xcachohnna gudxyih biaꞌñih. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bacahyi loh gubihdxyi ya lahdxi rooꞌ nin zaꞌbi laꞌn guidoꞌrooꞌ galaayi laꞌn hasta nadaa cun hasta naa nadaa duxa bigaꞌllun desde guiyaꞌ hasta laꞌn gueeta ya guhcan chiohpa taaꞌha. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chiꞌchi guñiꞌ Jesuhs jweersirooꞌ rahbi Ñiꞌh: ―¡Paah, loh naa si luꞌh rutiꞌdxiꞌhn xaaꞌlmahn! Guyaꞌlohsi guñiꞌ Ñiꞌh ziꞌchi, lwehgusi guhchi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ya chin bwaꞌha capitahn nin rnabwaꞌ laꞌh raꞌ suldahdu nin zuu riꞌchi xi guhca, chiꞌchi guzaꞌloh cañiꞌ zaꞌca ba pur Dxiohs, rahbi ba: ―Guchii bwiinn ca, ayi xtuhlda ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ya garaa raꞌ bwiinn nin rii riꞌchi, chiꞌn bwaꞌha raꞌ ba xi guhca lwehgu gubiaꞌgarii raꞌ ba para yihdzi raꞌ ba ziaadxinnaa stoꞌ raꞌ ba laasii taantu balaasa duxastoꞌ raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ya garaa raꞌ bwiinn nin biuꞌnbwaꞌ laꞌh Jesuhs cun gunnaꞌh raꞌ nin gwanaꞌhla laꞌh Jesuhs desde chin guzoꞌbaloh cagaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs nez Galilea, ya zihturooꞌ riiꞌ raꞌ ba tin riiywaꞌha raꞌ ba garaa cohsa raꞌ nin cayahca. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nee guyuuꞌ tuhbi bwiinn zaꞌca nin laa Joseh, xnehza nabahan ba loh xquelrnabwaꞌ Dxiohs, bwiinn guihdxyi Arimatea ba, neezaa dxaꞌga ba loh raꞌ bwiinn nin rnabwaꞌ laꞌn guidoꞌrooꞌ xteenn raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Joseh riiꞌ cabweeza ba gadzihn xquelrnabwaꞌ Dxiohs, niꞌchin nin ayi guhca xigaaba ba tuhsi cun loh xigaaba snuhn raꞌ bwiinn dziꞌbaloh chi nin gunabwaꞌ guhchi Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chiꞌchi gwah Joseh loh Pilahtu tin gwaganaaba ba siꞌguehlda Pilahtu gutehta raꞌ ba bweꞌltihxi Jesuhs loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ya chin guyaꞌloh batehta ba bweꞌltihxi Ñiꞌh loh cruhzi, chiꞌchi batuꞌbi ban laꞌn tuhbi sabna ya bacaꞌtsi ban laꞌn tuhbi baꞌ dxiah hasta nagahdxi chyu bwiinn guigaꞌtsi. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Deeꞌ guhca hohrapaꞌ nin zohbayaꞌzi gubihdxyi, ya dxyih chi naa dxyih nin rguꞌguihn raꞌ bwiinn Israel para dxyih nin ruziꞌlaaꞌdzi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ya gunnaꞌh raꞌ nin zeꞌnee Jesuhs desde Galilea, bwaꞌha raꞌ ba rwaaꞌ baꞌ hasta bigaꞌtsi Jesuhs tin bwaꞌha raꞌ ba xa forma guhta bweꞌltihxi Ñiꞌh laꞌn baꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ya chin gubiaꞌgarii raꞌ gunnaꞌh chi para yihdzi raꞌ ba chiꞌchi bwiꞌhnnchaꞌyi raꞌ ba cwaꞌn raꞌ nin xchiaꞌha nahxi neezaa nin naa ziga zah nin xchiaꞌha nahxi tin ñigaꞌbi raꞌ ban tihxi guetaguhla. Ya chin guyaꞌloh bwiꞌhnn raꞌ ba gahn bwiꞌnnchaꞌyi raꞌ ba perfume raꞌ chi, chiꞌchi baziꞌlaaꞌdzi raꞌ ba ziga caa loh xlehyi Moisehs guunn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ya dumingu rsiyidoꞌ gwah raꞌ gunnaꞌh chi rwaaꞌ baꞌ hasta bigaꞌtsi Jesuhs, ya zenee raꞌ ba cwaꞌn nahxi nin bwiꞌhnnchaꞌyi raꞌ ba tin ñidaꞌbin tihxi Jesuhs laꞌn baꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nee chin badzihn raꞌ ba rwaaꞌ baꞌ chi, bwaꞌha raꞌ ba laꞌdxiah nin ñeꞌw rwaaꞌ baꞌ zuucaa tuhbi lahdu; ");
INSERT INTO zpvNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ya chiꞌchi gudxihxiloh raꞌ ba laꞌn baꞌ, per ayila xi bweꞌltihxi Jesuhs bwaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ya bidxyihbi duxa raꞌ ba hasta guñihchi cweenta raꞌ ba nin ayi rahcabwaꞌ raꞌ ba xa guunn raꞌ ba, ya tuhbisi goolpi baluuꞌyiloh chiohpa ndxiꞌhw nin nahcu lahdxi nin rcaꞌbachaꞌha zunchii raꞌ ba gahxu loh raꞌ gunnaꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ya laꞌh raꞌ gunnaꞌh chi de taantu bidxyihbi duxa raꞌ ba hasta loh yuh guhtagurloh raꞌ ba taantu guelnadxyihbi duxa, chiꞌchi rahbi raꞌ ndxiꞌhw raꞌ chi: ―¿Xixnaa radxiꞌhyi tu bwiinn nabahan loh bwiinn guuchi? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ayi Ñiꞌh riiꞌ, laꞌÑiꞌh babahn loh bwiinnguuchi. Gulgasahnnastoꞌ tu dxyiꞌdxyi nin guñiꞌ Ñiꞌh loh tu chin nuu gahca tu guihdxyi Galilea; ");
INSERT INTO zpvNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","gunnah Ñiꞌh loh tu nahpa zidxiinn raꞌ bwiinnduhlda laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw, ya chin dxiohnna dxyih guhchi Ñiꞌh zabahn Ñiꞌh loh raꞌ bwiinnguuchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chiꞌchi bagannastoꞌ raꞌ gunnaꞌh chi dxyiꞌdxyi nin guñiꞌ Jesuhs loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ya chiꞌchi babii raꞌ ba rwaaꞌ baꞌ, ya chin bwaa raꞌ ba hasta nuu zatsiꞌh bituhbi xpooxtla Jesuhs cun snuhn lasaaꞌ raꞌ ba guhdzi raꞌ gunnaꞌh chi garaa nin guñiꞌ ndxiꞌhw raꞌ chi loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ya gunnaꞌh raꞌ nin baganee dxyiꞌdxyi raꞌ chi loh raꞌ pooxtla naa María Magdalena cun Jwahna cun neezaa María xnaan Jacobo cun spaaldaa raꞌ gunnaꞌh nin gwanee raꞌba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per bwiinn raꞌ nin naa xpooxtla Jesuhs bwiꞌhnn raꞌ ba lligaaba rñiꞌxihnraꞌzi gunnaꞌh raꞌ chi, ya ayi gwachiistoꞌ raꞌ ba xchiꞌdxyi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ya seguihdu chin bihn Pehdru dxyiꞌdxyi raꞌ chi biriaꞌhgalluꞌn ba zeguiaꞌha ba hasta bigaꞌtsi Jesuhs, ya chin badzihn Pehdru rwaaꞌ baꞌ chi, guyuꞌtii ba, chiꞌchi bwaꞌha ba laꞌlahdxi raꞌ chi naꞌ tuhbi lahdu, chiꞌchi ziaa ba para hasta nuu ba cun lligaaba xcweenta nin bwaꞌhaloh ba riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nee dxyih chi gahca zee raꞌ chiohpa xpwiinn Jesuhs tuhbi guihdxyi nin laa Emaús, ya guihdxyi chi riaꞌhan ziga tsiꞌh bituhbi kilómetru para loh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ya gaduhbi nin zeezah raꞌ ba loh nehza zeeyuuꞌyidxyiꞌdxyinee lasaaꞌ raꞌ ba pur xcweenta garaa raꞌ cohsa raꞌ nin gueꞌdu guhca loh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ya gaduhbi zeyuuꞌyidxyiꞌdxyi raꞌ ba, laꞌh gahca Jesuhs gwabiiga cweeꞌ raꞌ ba hasta zezah raꞌ ba, chiꞌchi zenee Ñiꞌh laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ya nicala bwaꞌha raꞌ ba laꞌh Ñiꞌh per ayi biuꞌnbwaꞌ raꞌ ba laꞌh Jesuhs laasii ayi guclaaꞌdzi Ñiꞌh ñahcabwaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chiꞌchi gunabadxyiꞌdxyi Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―¿Xiniꞌca zeyuuꞌyidxyiꞌdxyi tu gaduhbi nin zezah tu loh neziuh? ¿Xinaa ruhnn triixta loh tu? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chiꞌchi rahbi tuhbi raꞌ ba nin laa Cleofahs: ―Garaa bwiinn naann raꞌ ba xi guhca guihdxyi Jerusalehn. ¿Ta tuhbidxiꞌh yiꞌh nuu luꞌh zihtu duxa niꞌchin nin ayi gaann luꞌh xi guhca guihdxyi Jerusalehn? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xiniꞌca guhca riꞌchi? Chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Xcweenta Jesuhs nin zeꞌ guihdxyi Nazaret. Laꞌh ba guhca tuhbi profeta poderoso nezloh Dxiohs cun dxyiꞌdxyi nin baluuꞌyi ba laꞌh raꞌ bwiinn, ya lasahca duxa ba loh Dxiohs neezaa loh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","’Per bwiinn raꞌ nin rnabwaꞌ laꞌh raꞌ bixohza cun guxchiisi raꞌ nin rnabwaꞌ laꞌh raꞌ nuꞌh gunaꞌzu raꞌ ba laꞌh Jesuhs tin basaꞌcazii raꞌ ba laꞌh ba, batiꞌdxi raꞌ ba Jesuhs loh Pilahtu tin gunaaba raꞌ ba bacaꞌh Pilahtu laꞌh Ñiꞌh loh cruhzi, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","nee laꞌh nu bidiꞌhnn nu lligaaba laꞌh ba ñahca nin ñuldaꞌh laꞌh raꞌ bwiinn Israel laꞌn naa raꞌ bwiinnziitu raꞌ nin rnabwaꞌ raꞌ laꞌh nuꞌh. Yannah guhcala chohnna dxyih guhca cohsa raꞌ riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ya rsiyidoꞌ gwah paaldaa raꞌ gunnaꞌh rwaaꞌ baꞌ hasta bigaꞌtsi Jesuhs, ya chin gubiaꞌgarii raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nah raꞌ ba ayi badxeela raꞌ ba bweꞌltihxi Jesuhs rwaaꞌ baꞌ, ya chiꞌchi baluuꞌyiloh chiohpa aanjla loh raꞌ ba ya aanjla raꞌ chi rahbi loh raꞌ ba laꞌh Jesuhs nabahan, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ya seguihdu gwaguiaꞌha paaldaa lasaaꞌ nu rwaaꞌ baꞌ chi, nee chin badzihn raꞌ ba riꞌchi neezaa raꞌ ba bwaꞌha raꞌ ba nin guhdzi raꞌ gunnaꞌh chi, per ayiza bwaꞌha raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¡Aii bwiinnraꞌ! ¡Lliballanihin riuuꞌtii dxyiꞌdxyi laꞌn yihca tu; balaacachiꞌh rahcataꞌh tu tin riasaa tu garaa dxyiꞌdxyi nin bacaꞌh raꞌ profeta, daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs caadxyih! ");
INSERT INTO zpvNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Tayi rahcabwaꞌ tu nahpa gutiꞌdxiloh Crixtu garaa trabahjw duxa raꞌ loh guidxyiyuh, chiꞌchiyi gacah Ñiꞌh para llaaꞌndxibaaꞌ tin gudiꞌhi Dxiohs guelrnabwaꞌ laꞌh Ñiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chiꞌchi guzaꞌloh cagaluuꞌyi Jesuhs laꞌh raꞌ ba loh dxyiꞌdxyi raꞌ nin caa loh xchihtsi Dxiohs xcweenta Jesuhs, ya guzaꞌloh Ñiꞌh cun dxyiꞌdxyi raꞌ nin caa loh xchihtsi Moisehs ya gwazah guñiꞌ Ñiꞌh cun dxyiꞌdxyi raꞌ nin caa raꞌ garaa loh xchihtsi raꞌ daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ya chin zeegadzihn raꞌ ba guihdxyi hasta zee raꞌ chiohpa raꞌ bwiinn chi, ya bwiꞌhnn Jesuhs zigazi nin ñuhn ñazahru loh neziuh chi, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ya guñiꞌnee raꞌ ba laꞌh Jesuhs tin biaꞌhannee Ñiꞌh laꞌh la raꞌ ba, rahbi raꞌ ba loh Jesuhs: ―Biaꞌhannee laꞌh nu laasii laꞌh gudxyih guhca amweerla laꞌh cwiih gueꞌla. Ya chiꞌchi guyuuꞌtiinee Jesuhs laꞌh raꞌ ba hasta biaꞌhan raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nee chin guzohbanee Jesuhs laꞌh raꞌ ba hasta zuu mweella, chiꞌchi gucaꞌha Ñiꞌh pahn, bwiꞌhnntaaꞌyi Ñiꞌh yihcan, chiꞌchi gutaaꞌha Ñiꞌhn, gudxiꞌzi Ñiꞌhn tin gudahw raꞌ ba pahn chi. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ya hohrachi gahca baxaala Dxiohs loh raꞌ ba tin biuꞌnbwaꞌ raꞌ ba laꞌh Jesuhs, ya dxyigahsi guñihchiloh Ñiꞌh loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ya rahbi loh lasaaꞌ raꞌ ba: ―¿Gu nee luꞌh guzahcariinn stoꞌ luꞌh gaduhbi zeꞌnee Ñiꞌh laꞌh nuꞌh loh neziuh chin zeꞌyuuꞌyidxyiꞌdxyi Ñiꞌh nin caa loh Xchihtsi Dxiohs xcweenta Ñiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ya chiꞌchi ayiru guleezaru raꞌ ba riꞌchi, lwehgu banaꞌzunehza raꞌ ba ziaa raꞌ ba para guihdxyi Jerusalehn hasta biaꞌhan raꞌza tsiꞌbituhbi pooxtla cun snuhn raꞌ lasaaꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ya chiꞌchi rahbi raꞌ pooxtla loh raꞌ ba chin bwaa raꞌ ba hasta nuu raꞌ ba: ―Guchii, babahn Jesucristu baluuꞌyiloh Ñiꞌh loh Simohn. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ya seguihdu gahcaza bwiiꞌyidxyiꞌdxyi garoopa raꞌ ba ziga guzahca raꞌ ba loh neziuh, nee cun biuꞌnbwaꞌ raꞌ ba laꞌh Daada Jesucristu chin gutaaꞌha Ñiꞌh pahn. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gaduhbi nin zezah cañiꞌ raꞌ ba xcweenta nin guzahca raꞌ ba loh neziuh tuhbisi goolpi baluuꞌyiloh Jesuhs galaayi raꞌ ba, chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Chaan, gulcwachidxyiistoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Per laꞌh raꞌ ba bidxyihbiyaaꞌ raꞌ ba nastoꞌ raꞌ ba caywaꞌha raꞌ ba tuhbi spíritu, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xixnaa rdxyihbi tu nee ruhnn chiohpa stoꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gulguiaꞌha naaꞌhahn cun ñaaꞌhahn hasta guzohba clahva; naꞌh gahcan; gulguidxiꞌ naꞌh nee gulguiaꞌha zaꞌca naꞌh, laasii laꞌh tu naann tu tuhbi spíritu ayi caa ba bweꞌhla nee ayiza ba dzihta ziga nin nuu gaduhbi xcweeꞌrpuhn ―rahbi Jesuhs loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ya chin guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi raꞌ chi, chiꞌchi baluuꞌyi Ñiꞌh naa Ñiꞌh cun ñaaꞌ Ñiꞌh hasta guzohba raꞌ clahva, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","nee laꞌh raꞌ ba nagahdxi chechiistoꞌ raꞌ ba pur taantu riahxi raꞌ ba nee taantu radxyigaaꞌloh raꞌ ba, ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Tayi xi nahpa tu riꞌca guidaꞌw nuꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chiꞌchi badiꞌhi raꞌ ba tuhbi taaꞌha bwehldadxieeꞌ cun tahyi guehtadzihn laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ya gunaꞌzu Ñiꞌhn gudahw Ñiꞌhn nezloh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Deeꞌ naa xchiꞌdxyiꞌhn nin guñaan loh tu chin guyuuꞌneꞌhn laꞌh tu, guñaan loh tu nahpa zizohba gaca garaa dxyiꞌdxyi nin caa loh xlehyi Moisehs pur naꞌh, neezaa ziga caa loh xchihtsi daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs, cun neezaa ziga caa loh chihbru nin laa Salmu. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chiꞌchi baziaꞌñih Jesuhs loh xigaaba raꞌ ba tin guhcabwaꞌ raꞌ ba nin caa loh Xchihtsi Dxiohs xcweenta Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Squiiꞌ caa loh Xchihtsi Dxiohs: “Napa gachi Crixtu, per chin dxiohnna dxyih zabahn Ñiꞌh loh guelguhchi”; ");
INSERT INTO zpvNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ya zidiꞌchi dxyiꞌdxyi xcweenta ziga guhldaꞌh Jesucristu laꞌh raꞌ bwiinn loh duhlda chin chechiistoꞌ raꞌ ba xchiꞌdxyi Ñiꞌh, ya mweru guihdxyi Jerusalehn zoꞌbalohon, bachiꞌh zezahan para gaduhbi guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Laꞌh tu naa tu taxchihgu nin gutiꞌchi raꞌ xchiꞌdxyiꞌhn laasii bwaꞌhaloh tu xa guhca dez guzohbalohon, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","yannah guldxiaꞌhan si riiꞌ tin guicaꞌha tu Spíritu Saantu nin guixeꞌhlaꞌhn tin guniꞌhihn guelrnabwaꞌ nin zeꞌ dez llaaꞌndxibaaꞌ laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chiꞌchi gwanee Jesuhs laꞌh raꞌ ba stuhbi guihdxyi nin laa Betania ya riꞌchi batesanaa Jesuhs bwiꞌntaaꞌyi Ñiꞌh yihca raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ya gaduhbi nin cayuhntaaꞌyi Jesuhs yihca raꞌ ba, ziaagacah Ñiꞌh para dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nee chin guyaꞌloh guñiꞌ raꞌ ba pur chuhla naa Dxiohs, ya riahxi duxa raꞌ ba gubiaꞌgarii raꞌ ba para guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ya guihdxyi Jerusalehn diahrutiiꞌ gurih raꞌ ba laꞌn guidoꞌ tin guñiꞌ raꞌ ba milagrosa duxa naa Dxiohs. Ziꞌchizi guyaꞌloh dxyiꞌdxyi nin bacaꞌh Lucas xcweenta Jesucristu. Ziꞌchi gaca pwihsi.");
INSERT INTO zpvNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Desde galoh nin nagahdxi cwixchih guihdxyiyuh laꞌh dxyiꞌdxyi nuu la; ya nuunee dxyiꞌdxyi chi laꞌh Dxiohs, nee dxyiꞌdxyi chi naa Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ya desde chin gurihxchih guihdxyiyuh laꞌh Ñiꞌh nuunee la laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ya pur laꞌh Ñiꞌh bwiꞌhnn Dxiohs garaatiiꞌ raꞌ cohsa; ya nin tuhbi nin gurihxchih ayi guhcan sin laꞌh Ñiꞌh sino que bweꞌzii pur laꞌh Ñiꞌh guhca raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pur laꞌh Ñiꞌh nuu guelnabahan, ya guelnabahan chi naa biaꞌñih para laꞌh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Biaꞌñih riiꞌ rziaꞌñih loh nacahyi, ya loh nacahyi ayi guunnan gahn gusiuꞌyin laꞌh biaꞌñih chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Guyuuꞌ tuhbi bwiinn nin guxeꞌhla Dxiohs, lah ba guhca Jwahn. Bwiinn riiꞌ biꞌ ba ");
INSERT INTO zpvNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tin guluuꞌyi ba dxyiꞌdxyi xcweenta biaꞌñih xteenn Dxiohs, nee tin garaa za bwiinn chechiistoꞌ raꞌ ba xcweenta dxyiꞌdxyi raꞌ nin guluuꞌyi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Per ayi Jwahn dxiꞌh naa biaꞌñih, sino que biꞌ Jwahn tin guñiꞌ ba xcweenta nin naa biaꞌñih loh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Biaꞌñih nin naa guchii paꞌh nin ruziaꞌñih hasta rii raꞌ garaatiiꞌ raꞌ bwiinn, biaꞌñih chi biꞌ loh guihdxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ya nin naa dxyiꞌdxyi naa laꞌh Ñiꞌh nin biꞌ loh guihdxyiyuh, ya pur laꞌh Ñiꞌh guhca guihdxyiyuh; per laꞌh raꞌ bwiinn guihdxyiyuh ayi bwiꞌhnn cweenta raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Biꞌ Ñiꞌh hasta rii raꞌ nin naa raꞌ xpwiinn Ñiꞌh, per laꞌh raꞌ ba ayi bwiꞌhnn cweenta raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ya garaa raꞌ bwiinn raꞌ nin gwachiistoꞌ raꞌ ñiꞌh xchiꞌdxyi Ñiꞌh, badiꞌhi Ñiꞌh guelrnabwaꞌ laꞌh bwiinn raꞌ chi tin gaca raꞌ ba lliiꞌn Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ayi pur nin naa raꞌ dxiꞌh ba lliiꞌn bwiinn guidxyiyuh, nee ayiza pur xigaaba raꞌ dxiꞌh xcuzahn raꞌ ba o pur chyulla stuhbi bwiinn, sino que guhcan pur xigaaba Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pwihsi laꞌh nin naa dxyiꞌdxyi guhca Ñiꞌh tuhbi bwiinn guidxyiyuh nee guyuuꞌnee za Ñiꞌh laꞌhnu; nee nadziiꞌhi paꞌcaa Ñiꞌh laꞌh nu, cun rñiꞌ za Ñiꞌh dxyiꞌdxyi nanchii loh nu, nee bidiaꞌhaloh za nu llaꞌñih xteenn Ñiꞌh, nin naa llaꞌñih yuꞌpi Lliiꞌn Xtaada Dxiohs nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jwahn bwiiꞌyidxyiꞌdxyi pur xcweenta Jesuhs, ya guñiꞌ Jwahn squiiꞌ, jweersi rooꞌ rahbi ba: ―Bwiinn riiꞌ naa nin ruzeꞌtaꞌhn loh tu, chin guñiꞌn loh tu: “Bwiinn nin dxiꞌ nehz diꞌtsihn bwiinn chi mahzi lasahca que naꞌh nee laasii za nuu ba galohtiiꞌ que naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ya garaa raꞌ nu, bachicaꞌha raꞌ nu xquelnazaꞌcaduxa Ñiꞌh, nee cun neezaa guelnadziiꞌhi dihtsi lasaaꞌ guelnadziiꞌhi. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lehyi xteenn Dxiohs biꞌ pur xcweenta Moisehs; per ya ziga guelnadziiꞌhi xteenn Dxiohs cun dxyiꞌdxyi nin ruluuꞌyi xa paꞌcaa naa Dxiohs, bieꞌnee Jesucristun. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nin tuhbi bwiinn nagahdxi gwaꞌha yuꞌpi laꞌh Dxiohs; sohla tuhbi dxiꞌh yuꞌpi Lliiꞌn Ñiꞌh nin nuu stoꞌ Daada Dxiohs; laꞌchiꞌhzi Ñiꞌh baluuꞌyi Ñiꞌh dxyiꞌdxyi xcweenta Dxiohs laꞌhnuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bwiinn Israel raꞌ nin naa raꞌ bwiinn guihdxyi Jerusalehn guxeꞌhla raꞌ ba paaldaa bixohza raꞌ cun levita raꞌ loh Jwahn, tin gwah ganabadxyiꞌdxyi raꞌ ba chyu naa Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chiꞌchi nayaa-nayaa gudxixteeꞌ Jwahn, rahbi ba: ―Ayi naꞌh dxiꞌhn naan Crixtu nin dxiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ya chiꞌchi rahbi raꞌ ba loh Jwahn: ―¿Chyuulla naa chiꞌh luꞌh, pwihsi? ¿Ta yiꞌh naa luꞌh profeta Elías? Chiꞌchi rahbi Jwahn loh raꞌ ba: ―Ayi naꞌh dxiꞌhn. Ya chiꞌchi rahbi raꞌ ba: ―¿Pwihsi yiꞌh chiꞌh niꞌchi nin naa luꞌh Daada nin rñiꞌ xchiꞌdxyi Dxiohs dxiꞌ? Chiꞌchi rahbi Jwahn: ―Ayi naꞌh dxiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chiꞌchi rahbi raꞌ ba loh Jwahn: ―¿Chyu naa chiꞌh luꞌh, pwihsi? Laasii laꞌhnu nahpa dxioꞌganee nu rsohn loh raꞌ bwiinn nin guxeꞌhla laꞌhnu, niꞌchin yiꞌh gahca guñiꞌ ziga naa xcweenta luꞌh loh nu. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chiꞌchi rahbi Jwahn loh raꞌ ba: ―Naꞌh naan tuhbi bwiinn nin rñiꞌ jweersi nez loh dahan desiertu squiiꞌ: “Gulgasanchii xneziuh Dxiohs lastoꞌ tu”, ziga guñiꞌ guehtu profeta Isaías. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ya bwiinn raꞌ nin bagañiꞌ loh Jwahn naa raꞌ xpwiinn raꞌ bwiinn fariseu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Chiꞌchi rahbi raꞌ ba loh Jwahn: ―Pwihsi sidela yiꞌh ayi naa luꞌh Crixtu nin dxiꞌ, nin ayi za naa luꞌh laꞌh Elías, nin ayi za naa luꞌh Daada nin rñiꞌ xchiꞌdxyi Dxiohs dxiꞌ, ¿xixnaa chiꞌh ruroꞌbañihsa luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ya chiꞌchi rahbi Jwahn loh raꞌ ba: ―Naꞌh ruroꞌbañiꞌsahn cun ñihsa zi, per nez loh tu dxaꞌga tuhbi nin ayi nuꞌnbwaꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ya bwiinn chi naa nin gueꞌdu dxiꞌ nez diꞌtsihn, ya naꞌh nin ayi xi lasahcaꞌhn para laꞌh bwiinn chi; nin para cweꞌhehn tahba ba ñaaꞌ ba ayi lasahcaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Garaa raꞌ deeꞌ guhca loh guihdxyi nin laa Betania, hasta naa rwaaꞌ guiꞌw Jordahn nez lahdu nin rtahn gubihdxyi, hasta baroꞌbañihsa Jwahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ya chin barah gueꞌla, bwaꞌha Jwahn loh Jesuhs zeegadzihn Ñiꞌh hasta zuu Jwahn, chiꞌchi rahbi Jwahn: ―¡Gulguiaꞌha! Riiꞌ laꞌh Xiꞌhyi Dxiohs nin rusiaꞌpitii xtuhlda raꞌ bwiinn guihdxyiyuh badzihn. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Laꞌh ba nin guñiꞌn loh tu: “Nez diꞌtsihn ziꞌ stuhbi nin mahzi lasahca que naꞌh, laasii laꞌh ba nuu ba desde galohyi que ziga naꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neezaa naꞌh ayi biuꞌnbwaꞌn cuun nin naa laꞌh ba; per naꞌh zeꞌldahn tin cagaroꞌbañiꞌsahn laꞌh raꞌ bwiinn Israel raꞌ tin dxiuꞌnbwaꞌ raꞌ ba laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Neezaa rahbi Jwahn: ―Naꞌh bwaꞌhan biehta Spíritu Saantu nez llaaꞌndxibaaꞌ yihca Jesuhs zigazi tuhbi palohmwiꞌhn ya guzuhdxyii palomwiꞌhn chi yihca ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naꞌh ayi za biuꞌnbwaꞌn laꞌh ba, per Daada nin guluꞌnehza naꞌh zeꞌldagaroꞌbañihsahn cun ñihsa nnah Ñiꞌh loon: “Chin gwaꞌha luꞌh laꞌh Spíritu Saantu nin dxiehta nez llaaꞌndxibaaꞌ guleezaa yihca tuhbi bwiinn, bwiinn chi naa nin guroꞌbañihsa laꞌh raꞌ bwiinn cun Spíritu Saantu”, ");
INSERT INTO zpvNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","yannah laꞌh ba bwaꞌhaloon niꞌchin nin ruluꞌyiꞌhn naa ba Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ya barah stuhbi gueꞌla zuunee Jwahn laꞌh chiohpa xpwiinn ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ya nez chi bwaꞌhalaꞌgaꞌh ba laꞌh Jesuhs zuuzah Ñiꞌh nez chi, chiꞌchi rahbi Jwahn: ―¡Gulguiaꞌha! Laꞌh Xiꞌhyi Dxiohs dee chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ya chin bihn raꞌ garoopa xpwiinn Jwahn, guñiꞌ ba ziꞌchi, lwehgu zeenaꞌhla raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ya chin bwaꞌha Jesuhs zeenaꞌhla raꞌ ba laꞌh Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Xi radxiꞌhyi tu? Chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Mwehsu, ¿callaa nuu luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chiꞌchi rahbi Jesuhs: ―Gultaꞌguiaꞌha. Ya chiꞌchi gwah guiaꞌha raꞌ ba hasta nuu Ñiꞌh, ya riꞌchi biaꞌhannee raꞌ ba laꞌh Ñiꞌh, laasii hohra chi naa zigachiꞌh rcatahpa gudxyih. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrehs bwihtsi Simohn Pehdru naa tuhbi raꞌ ba loh garoopa raꞌ ba nin bihn xchiꞌdxyi Jwahn ya gwanaꞌhla raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ya seguihdu nin bwiꞌhnn Andrehs, lwehgu bagadxiꞌhyi ba bwihtsi ba nin laa Simohn, ya rahbi ba loh ba: ―Laꞌhnu badxeela laꞌh Crixtu. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ya chiꞌchi gwahnee Andrehs laꞌh Simohn hasta zuu Jesuhs; ya chin bwaꞌha Jesuhs loh Simohn, chiꞌchi rahbi Ñiꞌh loh ba: ―¿Ta yiꞌh nin naa luꞌh Simohn, lliiꞌn Jonahs?; per nnah laa luꞌh gaca Cefas (nin laa za Pehdru). ");
INSERT INTO zpvNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ya chin barah gueꞌla, bwiꞌhnn Jesuhs lligaaba chee Ñiꞌh para guihdxyi Galilea; dxyih chi badxiꞌloh Ñiꞌh laꞌh Felipe ya rahbi Ñiꞌh loh ba: ―Gudaꞌnaꞌhla naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ya Felipe rii naa ba tuhbi bwiinn guihdxyi Betsaida, hasta naa za lahdxyi Andrehs cun Pehdru. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ya chin badxiꞌlohgaꞌh Felipe laꞌh Natanael, rahbi ba loh Natanael: ―Laꞌhnu bidiaꞌha loh bwiinn nin rñiꞌ xcweenta Ñiꞌh loh dxihtsi raꞌ xteenn lehyi nin bacaꞌh guehtu Moisehs, laꞌhgahcaza Ñiꞌh naa nin ruzeꞌta raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs; laa Ñiꞌh naa Jesuhs, lliiꞌn Joseh nin naa bwiinn guihdxyi Nazaret. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chiꞌchi rahbi Natanael: ―¿Ta nez Nazaret chi zahca dxiꞌ tuhbi bwiinn zaꞌca? Chiꞌchi rahbi Felipe: ―Gudaaꞌ tin gwaꞌha luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ya chin bwaꞌha Jesuhs loh Natanael, chiꞌchi rahbi Ñiꞌh loh ba: ―Riiꞌ laꞌh tuhbi bwiinn Israel paꞌh badzihn, nin ayi tuhbi dxyiꞌdxyi rusaguiꞌhi rwaaꞌ ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chiꞌchi rahbi Natanael loh Jesuhs: ―¿Xaloh nuꞌnbwaꞌ luꞌh naꞌh? Chiꞌchi rahbi Jesuhs loh ba: ―Bwaꞌhahn loh luꞌh desde galohyi galoh nin guñiꞌ Felipe loh luꞌh, chin guñiꞌ ba loh luꞌh llaaꞌn tuhbi yahga ñiigu. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chiꞌchi rahbi Natanael loh Ñiꞌh: ―Mwehsu, ¡yiꞌh naa luꞌh Lliiꞌn Dxiohs, nee naa za luꞌh Rehyi loh raꞌ bwiinn Israel raꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chiꞌchi rahbi Jesuhs: ―¿Ta pur nin guñiꞌn loh luꞌh bwaꞌhahn yiꞌh llaaꞌn yahga ñiigu, niꞌchin nin riachiistoꞌ luꞌh naꞌh? Pwihsi desde nnah par delaanta zwaꞌha luꞌh mahziru cohsa rooꞌ raꞌ ziga cohsa raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Neezaa rahbi Jesuhs loh raꞌ ba: ―Guchiin dxyiꞌdxyi nin rñiꞌn loh tu, zwaꞌha tu llaaꞌndxibaaꞌ soobaallaalan ya gwaꞌha tu laꞌh raꞌ xaanjla Dxiohs dxiehta, gacah raꞌ ba yihca Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ya chin guhca chohnna dxyih, guyuuꞌ tuhbi saaꞌ loh guihdxyi Canah, xteenn guihdxyi nin laa Galilea. Neezaa xmah Jesuhs zuu riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ya Jesuhs cun xpwiinn Ñiꞌh biduꞌhun Ñiꞌh tin gwah Ñiꞌh saaꞌ riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ya chin gubihdzi vihnnu nin cayuhnn saaꞌ, chiꞌchi rahbi xmah Jesuhs loh Ñiꞌh: ―Ayiru nahpa raꞌ bwiinn raꞌ riiꞌ vihnnu, laꞌn gubihdzi. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chiꞌchi rahbi Jesuhs: ―Gunnaꞌh, ¿xixnaa rñiꞌ luꞌh loon ziꞌca? Nagahdxi guigaꞌha xohraꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chiꞌchi rahbi xmah Jesuhs loh raꞌ bwiinn raꞌ nin guzuh gutiꞌdxi nin guichiꞌhn raꞌ bwiinn raꞌ nin rii raꞌ loh mweella: ―Gulguiꞌhnn garaa nin nnaa Jesuhs loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Riꞌchi zuu xoꞌpa riiꞌdxiah, nin riuuꞌ ñihsa nin rdxiꞌbinaa raꞌ bwiinn Israel raꞌ tin rahca nayaa raꞌ ba tin ziꞌchi rzohba dxyiꞌdxyi ruzaꞌloh raꞌ ba xlehyi guehtu Moisehs. Ya laꞌn tuhbi raꞌ riiꞌdxiah raꞌ chi rdaꞌh ziga chywaꞌh o chwaꞌhbitsiꞌh lihtru ñihsa. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chiꞌchi rahbi Jesuhs loh raꞌ mooza raꞌ chi: ―Gulgachah ñihsa laꞌn raꞌ riiꞌdxiah raꞌ ca. Ya bachah raꞌ ba ñihsa laꞌn raꞌ riiꞌdxiah chi hasta que no gwadxah raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Yannah gulcweꞌhe nuhnan gulchenee guicaꞌha bwiinn nin cayuhnn saaꞌ riiꞌ. Ya bwiꞌhnn mooza raꞌ chi ziga guhdzi Jesuhs guunn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chiꞌchi gwaaꞌ bwiinn nin cayuhnn saaꞌ chi nuhn ñihsa nin biahca vihnnu (ya nin ayi gaann ba canehza guzah vihnnu chi, sola laꞌh raꞌ mooza raꞌ chi naann raꞌ ba canehza guzah vihnnu chi). Chiꞌchi gudihdxyi bwiinn nin cayuhnn saaꞌ laꞌh nuꞌbi nbahyi, ");
INSERT INTO zpvNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","chiꞌchi rahbi ba: ―Garaatiiꞌ raꞌ bwiinn guee raꞌ mwehrgaloh vihnnu zaꞌca, ya chin laꞌh raꞌ ba gwaaꞌ ziꞌyi vihnnu zaꞌca, chiꞌchi guee raꞌ gaꞌh ba nuhn vihnnu corrienta, per yiꞌh nuu guꞌchaꞌyi luꞌh vihnnu zaꞌca chi hasta nnah. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mwer dziꞌn rooꞌ riiꞌ naa nin bwiꞌhnn Jesuhs loh guihdxyi Canah xteenn Galilea, tin baluuꞌyi Ñiꞌh xa naa guelrnabwaꞌ xteenn Ñiꞌh; pwihsi neezaa raꞌ xpwiinn Ñiꞌh gwachiistoꞌ raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ya chin guyaꞌloh bwiꞌhnn Jesuhs deeꞌ, chiꞌchi gunaꞌzunehza Ñiꞌh zee Ñiꞌh para guihdxyi Capernaum, cun xmah Ñiꞌh, cun bwiinn raꞌ nin naa bwihtsi Ñiꞌh, cun xpwiinn za Ñiꞌh; ya loh guihdxyi raꞌ chi biaꞌhannee Ñiꞌh laꞌh raꞌ ba paaldaa dxyih raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ya ziga laꞌh xlañih paascu raꞌ bwiinn Israel raꞌ zeꞌgadzihn chin riagannastoꞌ raꞌ ba gueꞌla nin gudiiꞌdxi aanjla guelguhchi loh guihdxyi Egiptu, niꞌchin gunaꞌzunehza Jesuhs, zee Ñiꞌh para loh guihdxyi Jerusalehn. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ya chin badzihn Ñiꞌh riꞌchi, bwaꞌha Ñiꞌh rii raꞌ bwiinn raꞌ nin ruhnn raꞌ guriꞌxi laꞌn guidoꞌ rooꞌ; bwiinn raꞌ nin rutooꞌ raꞌ guidxaꞌh cun palohmma raꞌ, bwiinn raꞌ nin zohba raꞌ hasta zuu raꞌ mwehlla raꞌ hasta ruchaꞌh raꞌ bwiinn mweeyi. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chin bwaꞌha Ñiꞌh garaa raꞌ cohsa raꞌ riiꞌ, chiꞌchi bwiꞌhnnchaꞌyi Jesuhs tuhbi cwaarta duꞌh ya babweꞌhedxiaꞌhla Ñiꞌh laꞌh raꞌ ba hasta nez dihtsi guidoꞌrooꞌ, cun xiꞌhyi raꞌ ba cun ziahan ru raꞌ guidxaꞌh raꞌ. Ya bwiinn raꞌ nin ruchaꞌh mweeyi, bazaꞌh Ñiꞌh xmweeyi raꞌ ba loh yuh, ya xmweella raꞌ ba nezii-nezichi balaꞌha Ñiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ya rahbi Ñiꞌh loh raꞌ bwiinn raꞌ nin rutooꞌ palohmma: ―¡Gulgabweꞌhe niꞌca raꞌ riiꞌ! ¡Ayi guunn tu yihdzi Xtaaꞌdahn ziga tuhbi loh dxiaaꞌ! ");
INSERT INTO zpvNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ya chiꞌchi bagannaastoꞌ raꞌ xpwiinn Ñiꞌh nin caa loh Xchihtsi Dxiohs squiiꞌ: “Rdiꞌhillahn stoꞌn xcweenta nin ruhnnee raꞌ ba yihdzi luꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ya chiꞌchi gunaabadxyiꞌdxyi raꞌ bwiinn Israel loh Jesuhs, rahbi raꞌ ba: ―¿Xi sehn guluuꞌyi luꞌh laꞌhnu tin guidiaꞌha nu nahpa luꞌh guelrnabwaꞌ cayuhnn luꞌh dziꞌn raꞌ ca? ");
INSERT INTO zpvNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgacwih guidoꞌ riiꞌ, ya chin dxiohnna dxyih ziuꞌn nacuubiñin stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi loh Ñiꞌh: ―Chwaꞌhabi xoꞌpa yihza guhcachaꞌyi guidoꞌ riiꞌ, ¿nee yiꞌh nnaa luꞌh chohnna si dxyih dxiuꞌn zaꞌca luꞌhn? ");
INSERT INTO zpvNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per xcweenta guidoꞌ nin guñiꞌ Jesuhs loh raꞌ bwiinn raꞌ chi naa bweꞌltihxi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pwihsi niꞌchin chin babahn Ñiꞌh loh guelguhchi, bagannastoꞌ raꞌ xpwiinn Ñiꞌh xcweenta dxyiꞌdxyi raꞌ riiꞌ, ya ziꞌchi gwachiistoꞌ raꞌ ba ziga caa loh Xchihtsi Dxiohs cun ziga guñiꞌ Jesuhs xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ya gaduhbi nin zuu Jesuhs loh lañih nin cayahca loh guihdxyi Jerusalehn nin naa xlañih paascu raꞌ bwiinn Israel, ziahan raꞌ bwiinn raꞌ gwachiistoꞌ raꞌ ba xchiꞌdxyi Ñiꞌh laasii bwaꞌha raꞌ ba sehn raꞌ cun dziꞌn roo raꞌ nin bwiꞌhnn Jesuhs riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per ayi xi guerzaaꞌ guyuuꞌ Ñiꞌh pur laꞌh raꞌ bwiinn, laasii ya nuꞌnbwaꞌ Ñiꞌh lastoꞌ garaatiiꞌ raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ayi xchiꞌhn Ñiꞌh bweꞌzi chyu ñahbi xcweenta raꞌ bwiinn loh Ñiꞌh, laasii laꞌh gahca Ñiꞌh nuꞌnbwaꞌ Ñiꞌh xa naa lastoꞌ cada tuhbigah raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Guyuuꞌ tuhbi bwiinn fariseu nin biriaꞌlah Nicodemu, guhca ba tuhbi bwiinn nin rnabwaꞌ loh raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ndxiꞌhw riiꞌ gwah ba gueꞌla hasta guyuuꞌ Jesuhs paaldaa dxyih raꞌ ya rahbi ba loh Ñiꞌh: ―Mwehsu, naann nu Dxiohs guluꞌnehza yiꞌh tin guluuꞌyi luꞌh laꞌh nu, laasii ayi nin tuhbi bwiinn nin guunn milahgru raꞌ nin ruhnn yuꞌbiluꞌh, sidela ayi nabahannee Dxiohs laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chiꞌchi rahbi Jesuhs loh ba: ―Guchiin nin rñiꞌn loh luꞌh, bwiinn nin ayi gaalaa nacuubi (nin zeꞌ loh deeꞌ naa chechiistoꞌ luꞌh xchiꞌdxyi Dxiohs) ayi nuu gwaꞌha ba loh guelrnabwaꞌ xteenn Dxiohs llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chiꞌchi rahbi Nicodemu loh Ñiꞌh: ―Per, ¿xa gaca gaalaa nacuubi tuhbi ndxiꞌhw nin ba guyuꞌxa? ¿Ta zahca gabiaꞌgarii dxiuuꞌ ba stoꞌ xmaah ba stuhbi tin gaalaa nacuubi ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chiꞌchi rahbi Jesuhs: ―Guchiin nin rñiꞌn loh luꞌh, bwiinn nin ayi gaalaa cun ñihsa cun Spíritu Saantu ayi gaca chuꞌtii ba loh guelrnabwaꞌ xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bwiinn raꞌ nin raalaa raꞌ pur guzahn raꞌ naa raꞌ ba bwiinn guidxyiyuh, per nin raalaa raꞌ pur Spíritu Saantu, cabwaꞌ raꞌ ba pur xcweenta Spíritu. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ayi guzuꞌhyi yihca luꞌh cun lligaaba pur dxyiꞌdxyi raꞌ nin guñiꞌn loh luꞌh: “Garaa tu nahpa gaalaa nacuubi tu stuhbi.” ");
INSERT INTO zpvNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bwih rzuhun cachiꞌzi nehza rihn luꞌhn, per nin ayi gaann luꞌh canehzan zeꞌen, nee nin ayi za gaann luꞌh canehza guzeeꞌhehn; pwihsi ziꞌchi naa raꞌ bwiinn raꞌ nin rahlaa cun Spíritu Santu. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chiꞌchi rahbi Nicodemu: ―Per, ¿xa gaca dee raꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chiꞌchi rahbi Jesuhs loh Nicodemu: ―Per ziga yiꞌh, mwehsu dxiꞌh naa luꞌh loh raꞌ bwiinn Israel raꞌ, nee ayi rahcabwaꞌ luꞌh dxyiꞌdxyi raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pwihsi naꞌh guchiin nin rñiꞌn loh luꞌh laꞌh nu rachiñiꞌ nu nin naann nu, nee rachiñiꞌ nu nin bidiaꞌhaloh nu, per laꞌh tu ayi riachiistoꞌ tu nin rachiñiꞌ nu. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sidela laꞌh tu ayi riachiistoꞌ tu naꞌh, chin ruzeꞌtaꞌhn loh tu nin nuu loh guidxyiyuh riiꞌ, ¿xaalla chechii chiꞌh stoꞌ tu naꞌh chin guzeꞌtaꞌhn nin nuu dxibaaꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nagahdxi chyu guicah nez dxibaaꞌ, sola tuhbi dxiꞌh bwiinn nin biehta nez dxibaaꞌ nee bwiinn chi naa Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ya ziga guteesa guehtu Moisehs bweꞌlda loh dahan desiertu, pwihsi ziꞌchi za laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw nahpa ziahsa Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tin garaa raꞌ bwiinn nin chechiistoꞌ raꞌ ñiꞌh laꞌh Ñiꞌh zahpa raꞌ ba guelnabahan nin ayi ñichilohtiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Laasii guhca nadziiꞌhi stoꞌ Dxiohs laꞌh raꞌ bwiinn guidxyiyuh, niꞌchin guxeꞌhla Ñiꞌh yuꞌpi Lliiꞌn Ñiꞌh loh guidxyiyuh, tin garaa raꞌ bwiinn raꞌ nin chechiistoꞌ raꞌ ñiꞌh xchiꞌdxyi Ñiꞌh ayi ñichiloh raꞌ ba loh Dxiohs, sino que gapa raꞌ ba tuhbi guelnabahan nacuubi nin ayi ñichilohtiiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","laasii Dxiohs ayi guluꞌnehza dxiꞌh Ñiꞌh laꞌh Lliiꞌn Ñiꞌh loh guidxyiyuh tin gudziiꞌba Ñiꞌh duhlda yihca raꞌ bwiinn guidxyiyuh, sino que guhldaꞌh Ñiꞌh laꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bwiinn nin chechiistoꞌ ñiꞌh xchiꞌdxyi Lliiꞌn Dxiohs nin naa ndxiꞌhw ayi gaca guelguxchisi xtuhlda ba, per laꞌh bwiinn nin ayi riachiistoꞌ ñiꞌh xchiꞌdxyi Lliiꞌn Dxiohs bireꞌnchii rsohn naa ba bwiinn duhlda, laasii ayi gwachiistoꞌ ba xchiꞌdxyi yuꞌpi Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pwihsi bwiinn raꞌ chi ya bireꞌnchii rsohn naa raꞌ ba bwiinn duhlda laasii dziꞌn dxaaba ruhnn raꞌ ba; chin biꞌ biaꞌñih loh guidxyiyuh mahziru biuꞌstoꞌ raꞌ ba loh nacahyi laasii dziꞌn dxaaba ruhnn raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","laasii garaa raꞌ bwiinn nin ruhnn dziꞌn dxaaba rbweꞌhestoꞌ raꞌ ba biaꞌñih, nee ayi riabiiga raꞌ ba loh biaꞌñih laasii biaꞌñih zuluuꞌyin xtsiꞌn dxaaba raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","per laꞌh raꞌ bwiinn nin ruzoꞌbadxiahga dxyiꞌdxyi raꞌ nin guchii riabiiga raꞌ ba loh biaꞌñih tin guluuꞌyi dziꞌn raꞌ nin cayuhnn raꞌ ba naa raꞌn dziꞌn zaꞌca nin xclaaꞌdzi Dxiohs gaca. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ya chin guyaꞌloh deeꞌ, chiꞌchi zenee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh nez loh guihdxyi xteenn Judea, nez guyuuꞌnee Ñiꞌh laꞌh raꞌ ba paaldaa dxyih chin baroꞌbañihsa za raꞌ xpwiinn Ñiꞌh laꞌh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Neezaa Jwahn baroꞌbañihsa gaꞌh za nez guihdxyi Enohn, gahxu guihdxyi Salim, laasii nez chi nuu ziꞌyi rooꞌ ñihsa, ya bwiinn raꞌ gwah raꞌ ba tin guroꞌbañihsa raꞌ ba nez chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dee raꞌ guhca galoh nin nnagahdxi dxieꞌw Jwahn, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","per laꞌh raꞌ xpwiinn Jwahn guzoꞌbaloh cayuuꞌyidxyiꞌdxyinee raꞌ ba laꞌh paaldaa raꞌ bwiinn Israel pur xcweenta xquelrdxiꞌbinaa raꞌ ba ziga naa xcostumbre raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ya gwaguihtsi raꞌ ban loh Jwahn, rahbi raꞌ ba: ―Mwehsu, bwiinn nin guzuhnee luꞌh nez hasta rtahn gubihdxyi rwaaꞌ guiꞌw Jordahn; bwiinn nin bwiiꞌyidxyiꞌdxyi luꞌh xcweenta ñiꞌh loh nu, bwiinn chi nin nuugaroꞌbañihsa nee ziahanru bwiinn naꞌhla laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chiꞌchi rahbi Jwahn: ―Ayi xi guelrnabwaꞌ nahpa bwiinn sidela Dxiohs ayi gudiꞌhin. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Laꞌh gahca tu bihn tu guñiꞌn loh tu ayi naꞌh dxiꞌh naan Crixtu sino que naꞌh naan tuhbi bwiinn zi nin zeꞌ ñiidxiuu, ya ziꞌ stuhbi bwiinn galoo naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Laasii loh tuhbi saaꞌ bwiinn nin nahpa laꞌh dxaꞌpa mbahyi, bwiinn chi naa nuꞌbinbahyi, ya laꞌh xamihgu nuꞌbinbahyi nin zuu riꞌchi nee rihn ba nin cañiꞌ nuꞌbinbahyi, riahxi duxa ba chin rihn ba rñiꞌ ba, pwihsi ziꞌchi za naꞌh riahxi duuxaꞌhn laasii laꞌh ba badzihn la. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Laꞌh ba nahpa gaca lasahca ru ba loon ya naꞌh nahpa gulliaaꞌyiꞌhn ru gaca lasahcaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Rahbi za Jwahn: ―Bwiinn nin zeꞌ nez guiyaꞌ lasahca ru ba loh garaa raꞌ bwiinn, ya bwiinn nin naa bwiinn loh guidxyiyuh rñiꞌ za ba pur nin nuu raꞌ loh guidxyiyuh, per bwiinn nin zeꞌ nez llaaꞌndxibaaꞌ lasahca ru ba loh raꞌ garaa raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","nee rñiꞌ za ba nin bwaꞌhaloh ba cun nin bihndxiahgaza ba, per ayi chyu bwiinn riachiistoꞌ ñiꞌh xchiꞌdxyi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per bwiinn nin riachiistoꞌ raꞌ ñiꞌh xchiꞌdxyi ba, bwiinn chi ruluuꞌyi guchiipaꞌca naa dxyiꞌdxyi nin rñiꞌ Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","laasii bwiinn nin guluꞌnehza Dxiohs loh guidxyiyuh ganaalla xchiꞌdxyi Dxiohs rñiꞌ ba, laasii pur Dxiohs gwadxahtiiꞌ stoꞌ nabahan ba cun Spíritu Saantu. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Daada Dxiohs nadziiꞌhi Ñiꞌh laꞌh Lliiꞌn Ñiꞌh nee badiꞌhi za Ñiꞌh guelrnabwaꞌ laꞌh Lliiꞌn Ñiꞌh loh garaatiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Niꞌchin bwiinn raꞌ nin riachiistoꞌ raꞌ ñiꞌh xchiꞌdxyi Lliiꞌn Dxiohs, zahpa raꞌ ba guelnabahan nin ayi ñichilohtiiꞌ, per laꞌh raꞌ bwiinn raꞌ nin ayi nnaa chechiistoꞌ raꞌ ñiꞌh xchiꞌdxyi Dxiohs ayi gapa raꞌ ba guelnabahan chi, sino que nin guicaꞌha raꞌ ba naa guelrzaꞌcazii nin banaa para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chin bihn Jesuhs nin rñiꞌ raꞌ bwiinn fariseu raꞌ rahbi raꞌ ba: “Jesuhs ruroꞌbañihsa laꞌh raꞌ mahziru bwiinn que laꞌh Jwahn”, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","mas nicala ayi laꞌh dxiꞌh Jesuhs baroꞌbañihsa sino que laꞌh raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","chin guhcabwaꞌ Jesuhs ziꞌchi, chiꞌchi biriaꞌh Ñiꞌh loh guihdxyi Judea tin gubiaꞌgarii Ñiꞌh loh guihdxyi Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ya loh nin ziaa Ñiꞌh Galilea nahpa badiiꞌdxi Ñiꞌh loh yuh nin rnabwaꞌ Samaria, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ya chin badzihn Ñiꞌh loh guihdxyi xteenn Samaria nin laa Sicar, gahxu loh yuh nin badiꞌhi guehtu Jacob ziga herensi laꞌh lliiꞌn ba nin biriaꞌhlah Joseh, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","riꞌchi zohba bizee nin rñiꞌ raꞌ bwiinn raꞌ chi: “Xpizee Jacob.” Ya Jesuhs badxahga Ñiꞌh zeꞌzah Ñiꞌh niꞌchin guzohba Ñiꞌh rwaaꞌ bizee chi, nee ziga chiꞌh laaꞌyidxyih hohra nin guzohba Ñiꞌh rwaaꞌ bizee chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ya laꞌh raꞌ xpwiinn Ñiꞌh gunaꞌzunehza raꞌ ba zee raꞌ ba loh guihdxyi chi tin zeesiꞌ raꞌ ba nin gahwnee raꞌ ba Jesuhs, ya gaduhbi nin zee raꞌ ba badzihn tuhbi gunnaꞌh rwaaꞌ bizee hasta zohba Jesuhs, gunnaꞌh chi naa tuhbi bwiinn Samaria zeꞌcaꞌha ba ñihsa, chiꞌchi rahbi Jesuhs loh ba: ―Daꞌnee nuhn ñihsa gueeꞌhehn. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nee ziga laꞌh raꞌ bwiinn Israel raꞌ nahpa llahn raꞌ ba laꞌh raꞌ bwiinn Samaria raꞌ niꞌchin rahbi gunnaꞌh chi: ―¿Xaloh yiꞌh nin naa luꞌh tuhbi bwiinn Israel canaaba luꞌh ñihsa loon guee luꞌh, naꞌh ziga naan tuhbi bwiinn Samaria? ");
INSERT INTO zpvNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Sidela yiꞌh gacabwaꞌ luꞌh xa naa guelralahsa stoꞌ xteenn Dxiohs nee chyu naa nin canaaba ñihsa loh luꞌh, yiꞌh guinaaba luꞌh loh ba ya laꞌh ba zuniꞌhi ba ñihsa nabahan guee luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chiꞌchi rahbi gunnaꞌh chi loh Jesuhs: ―Daada, nin ayi nahpa luꞌh xi cun cweꞌhe luꞌh ñihsa, nee bizee ca gueetan; ¿calla nehza checaꞌha chiꞌh luꞌh ñihsa nabahan guniꞌhi luꞌh gueeꞌhehn? ");
INSERT INTO zpvNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ta lasahcaru chiꞌh luꞌh que laꞌh xpaah Jacobo nu? Laasii laꞌh ba basiaꞌhannee bizee riiꞌ laꞌh nu, bizee riiꞌ gwaaꞌ ba ñihsa cun xquidxaꞌh ba chin gubahan ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Garaa raꞌ bwiinn nin reeꞌ raꞌ ñihsa bizee riiꞌ zibwihdxahga gahca raꞌ ba ñihsa, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","per bwiinn raꞌ nin guee ñihsa nin gudiꞌhihn, ayi chuu dxyih nin guidxahga raꞌ ba ñihsa, laasii ñihsa nin gudiꞌhihn guee raꞌ ba, gacan stoꞌ raꞌ ba ziga zi tuhbi hasta rtahnn ñihsa nee gacazan guelnabahan nin ayi ñichilohtiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chiꞌchi rahbi gunnaꞌh Samaritana chi loh Jesuhs: ―Daada, daꞌnee ñihsa chi gueeꞌhehn tin ayiru guidxahgahn ñihsa, nee nin ayiza rchiꞌhn dxieꞌldacaꞌhahn ñihsa riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chiꞌchi rahbi Jesuhs loh ba: ―Gwatiidxi cheꞌhla luꞌh tin gudaꞌnee bi riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chiꞌchi rahbi gunnaꞌh chi loh Ñiꞌh: ―Ayi chyu cheꞌhlaꞌhn nuuꞌ. Chiꞌchi rahbi Jesuhs loh ba: ―Guchii paꞌca rñiꞌ luꞌh ayi cheꞌhla luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","nee bazaaꞌ gaꞌyu cheꞌhla luꞌh, nee ndxiꞌhw nin canee luꞌh nnah ayi cheꞌhla dxiꞌh luꞌh niꞌchi; ya guchii paꞌ luꞌh ziga guñiꞌ luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ya chin bihn gunnaꞌh chi dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi rahbi gunnaꞌh chi loh Jesuhs: ―Daada, nnahyi rwaꞌhahn yuꞌbiluꞌh naa luꞌh tuhbi bwiinn nin rñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Laꞌh guehtu xtatitarooꞌ nu bazuꞌnllihbi raꞌ ba loh Dxiohs loh dahan riiꞌ, per laꞌh tu ziga naa tu bwiinn Israel rahbi tu loh guihdxyi Jerusalehnsi naa nez hasta nahpa guzuꞌnllihbi raꞌ bwiinn loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Gwachiistoꞌ luꞌh naꞌh, gunnaꞌh; laasii laꞌh dxyih gadzihn guzuꞌnllihbi tu loh Dxiohs nin ayiru nahpa dxiꞌ tu loh dahan riiꞌ, nin ayiru za nahpa chee tu hasta guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","laasii laꞌh tu nin naa bwiinn Samaria nin ayi gaann tu chyuñin raann tu per laꞌh nu nin naa nu bwiinn Israel naann nu chyu raann nu laasii lahda raꞌ bwiinn Israel zeꞌ xcweenta dxyiꞌdxyi raꞌ xa rutaꞌh Dxiohs laꞌh raꞌ bwiinn loh duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","per laꞌh hohra guigaꞌha nee nnahgahca bigaꞌhan chin laꞌh raꞌ bwiinn nin guchii raꞌ raann laꞌh Dxiohs laꞌn lastoꞌ raꞌ ba nee neezaa cun Spíritu Saantu Dxiohs zaann raꞌ ba laꞌh Dxiohs laasii bwiinn raꞌ squiiꞌ rdxiꞌhyi Dxiohs gaann laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dxiohs naa spíritu, nee pur Spíritu Saantu si xteenn Ñiꞌh gaca gaann bwiinn laꞌh Ñiꞌh laasii pur Spíritu Saantu chi ziuuꞌnbwaꞌ paꞌca raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chiꞌchi rahbi gunnaꞌh chi: ―Naꞌh naꞌnnahn ziꞌ Mesías nin laa za Crixtu, ya chin dxiꞌ Ñiꞌh laꞌh Ñiꞌh zuziaꞌñih Ñiꞌh loh xigaaba nuꞌh loh garaatiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Naꞌh naañin, naꞌh gahca nin cañiꞌn loh luꞌh naan Crixtu. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ya hohra chi gubiaꞌgarii raꞌ za xpwiinn Ñiꞌh riꞌchi, ya badxyigaaꞌ duxa loh raꞌ ba laasii bwaꞌha raꞌ ba cayuuꞌyidxyiꞌdxyinee Jesuhs laꞌh gunnaꞌh Samaritana chi, per nin tuhbi raꞌ ba ayi gunaabadxyiꞌdxyi xi xclaaꞌdzi gunnaꞌh chi o xi cayuuꞌyidxyiꞌdxyinee Jesuhs laꞌh gunnaꞌh chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ya chiꞌchi basiaꞌhangah gunnaꞌh chi xchyiiꞌ ñihsa ba tin ziaa ba loh guihdxyi chi tin gwagañiꞌ ba loh raꞌ bwiinn guihdxyi chi: ");
INSERT INTO zpvNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―¡Gultaꞌguiaꞌha laꞌh tuhbi ndxiꞌhw nin guñiꞌ garaatiiꞌ raꞌ nin cayuꞌnnahn! ¿Tayi laꞌh dxiꞌh ba nin naa Crixtu? ");
INSERT INTO zpvNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ya chiꞌchi biriaꞌh raꞌ bwiinn guihdxyi raꞌ chi tin gwah raꞌ ba hasta zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ya gaduhbi nin zeꞌ raꞌ bwiinn chi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Mwehsu, gudahw. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Naꞌh laꞌn nahpa nin gaawuhn, guelwahw nin ayi nuꞌnbwaꞌ tu laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ya chiꞌchi guzoꞌbaloh canaabadxyiꞌdxyi loh lasaaꞌ raꞌ xpwiinn Ñiꞌh rahbi raꞌ ba: ―¿Ta nuugaa nin bieꞌnee nin gahw mwehsu? ");
INSERT INTO zpvNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Xquelwaawuhn naa guzaꞌloon guꞌnnahn nin xclaaꞌdzi Bwiinn nin guluꞌnehza naꞌh gaca tin guzaꞌloon xtsiꞌn ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Laꞌh tu rahbi tu riaꞌdxyi ru stapa bweꞌhw tin chaꞌloh jusehchi, per naꞌh rñiꞌn loh tu gulguiaꞌha loh yuh hasta naꞌ xliꞌn tu, laꞌn guhla la tin chapitii jusehchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bwiinn nin rusiaꞌpitii jusehchi, rcaꞌha ba mweeyi nin rgaꞌha guicaꞌha ba, ya jusehchi nin rusiaꞌpitii ba gacan guelnabahan nin ayi ñichilohtiiꞌ tin ziꞌchi dxiahxinee bwiinn nin rbahchi biñih laꞌh bwiinn nin ruziaꞌtii liꞌhn chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","laasii guchii ziga rñiꞌ bwiinn: “Bwiinn nin rbahchi biñih naa tuhbi bwiinn, ya stuhbi ba naa bwiinn nin ruziaꞌtii liꞌhn.” ");
INSERT INTO zpvNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naꞌh guxeꞌhlaꞌhn laꞌh tu tin gusiaꞌpitii tu jusehchi nin ayi bwiꞌhnn biñih tu, pwihsi guriin bwiinn nin bwiꞌhnn biñihin ya laꞌh tu riahxi tu pur xtsiꞌn raꞌ bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pwihsi ziahan duxa raꞌ bwiinn Samaria chi gwachiistoꞌ raꞌ ba xchiꞌdxyi Jesuhs pur nin guhdzi gunnaꞌh chi loh raꞌ bwiinn: “Guñiꞌ ba garaa raꞌ nin cayuꞌnnahn.” ");
INSERT INTO zpvNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pwihsi chin badzihn raꞌ bwiinn Samaria raꞌ chi hasta zuu Jesuhs, guñiꞌ raꞌ ba loh Jesuhs tin dxiaꞌhannee Ñiꞌh laꞌh raꞌ ba. Biaꞌhan Ñiꞌh riꞌchi chiohpa dxyih, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ya ziahan ru raꞌ bwiinn chi gwachiistoꞌ raꞌ ba nin bihn raꞌ ba guñiꞌ Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","chiꞌchi rahbi raꞌ ba loh gunnaꞌh chi: ―Pwihsi nnah riachiistoꞌ nu, per ayi pur dxyiꞌdxyi raꞌ dxiꞌh nin gunnah luꞌh loh nu sino que neezaa pur nin bihn dxiahga nu, yannah naann nu laꞌh Ñiꞌh naa nin gutaꞌh laꞌh raꞌ bwiinn guidxyiyuh loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chin gudiiꞌdxi chiohpa dxyih, bariaꞌh Jesuhs guihdxyi Samaria ya zee Ñiꞌh nez guihdxyi Galilea, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","laasii laꞌhgahca Ñiꞌh rahbi Ñiꞌh: ―Tuhbi bwiinn nin rñiꞌ xchiꞌdxyi Dxiohs ayi ruzoꞌbadxiahga raꞌ bwiinn lahdxyi ba xchiꞌdxyi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ya chin badzihn Ñiꞌh loh guihdxyi Galilea, bagachiꞌloh bwiinn Galilea raꞌ chi laꞌh Ñiꞌh gaduhbistoꞌ raꞌ ba laasii chin gwah Ñiꞌh lañih paascu nin rahca loh guihdxyi Jerusalehn neezaa laꞌh raꞌ ba gwah raꞌ ba ya bwaꞌha raꞌ ba garaa dziꞌn raꞌ nin bwiꞌhnn Ñiꞌh riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ya chiꞌchi gubiaꞌgarii Jesuhs nez guihdxyi Canah xteenn Galilea hasta bwiꞌhnn Ñiꞌh ñihsa vihnnu, guyuuꞌ tuhbi daada nin ruhnn xtsiꞌn gubieerna, guhcalluꞌhu lliiꞌn daada chi loh guihdxyi Capernaum. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ya chin bihn daada chi bariaꞌh Jesuhs loh guihdxyi Judea tin badzihn Ñiꞌh loh guihdxyi Galilea, chiꞌchi gwagañiꞌ ba loh Ñiꞌh ya guñiꞌnee ba laꞌh Ñiꞌh tin chee Ñiꞌh yihdzi ba tin chegasiaca Ñiꞌh laꞌh lliiꞌn ba, laasii lamweerla laꞌh bi gachi, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","chiꞌchi rahbi Jesuhs: ―Laꞌh tu ayi riachiistoꞌ tu ziꞌchi zi sidela ayi gwaꞌha tu sehn raꞌ cun milahgru raꞌ chiꞌchi riachii stoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ya chiꞌchi rahbi daada chi: ―Daada, too nnah galoh nin naꞌnabahan ru lliiꞌnahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chiꞌchi rahbi Jesuhs: ―Gubiaꞌgarii yihdzi luꞌh nnah, laꞌh lliiꞌn luꞌh nabahan. Pwihsi lwehgu gwachiistoꞌ ndxiꞌhw chi nin guñiꞌ Jesuhs loh ba, ya ziaa ba yihdzi ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ya gaduhbi nin ziaa ba yihdzi ba, biriaꞌh raꞌ xmooza ba bagachiꞌloh laꞌh ba ya rahbi raꞌ mooza raꞌ chi loh ba: ―¡Laꞌh lliiꞌn luꞌh nabahan! ");
INSERT INTO zpvNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ya gunaabadxyiꞌdxyi ba loh raꞌ mooza chi xohra paꞌh guzoꞌbaloh biacazaꞌca lliiꞌn ba, ya rahbi raꞌ mooza: ―Nnaꞌyi ziga chiꞌh rcatuhbi gudxyih bariaꞌh bi lliaꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ya chiꞌchi guhcabwaꞌ xtaada biñiꞌn chi hohra chi gahcan nin guñiꞌ Jesuhs loh ba: “Laꞌh lliiꞌn luꞌh nabahan”, ya ziꞌchi laꞌh ba cun garaa raꞌ bwiinn nin nuu rwaaꞌ yihdzi ba gwachiistoꞌ raꞌ ba naa Jesuhs Crixtu nin cabweeza raꞌ ba dxiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dee naa nin raroopa sehn rooꞌ nin bwiꞌhnn Jesuhs chin bariaꞌh Ñiꞌh loh guihdxyi Judea tin gubiaꞌgarii Ñiꞌh nez Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pwihsi chin gudiiꞌdxi guhca raꞌ deeꞌ, laꞌn dxyih gahca raꞌ chi guyuuꞌ tuhbi lañih xteenn raꞌ bwiinn Israel, ya chiꞌchi za gwah Jesuhs loh guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ya loh guihdxyi Jerusalehn gahxu rwaaꞌ guihdxyi chi nin laa xteenn lliꞌhyi raꞌ, riꞌchi nuu ziga tuhbi pihyi nin rñiꞌ raꞌ ba loh dxyiꞌdxyi hebreu Betzata; gaꞌyu curdohra nuu rwaaꞌ pihyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ya rwaaꞌ pihyi chi rii raꞌ ziahan bwiinn dxyihdxyi raꞌ ziga bwiinn nin ayi riin loh ñiꞌh, bwiinn cweeꞌ raꞌ, cun bwiinn raꞌ nin gubihdzi tihxi raꞌ ñiꞌh, naꞌ raꞌ ba loh yuh riꞌchi cabweeza raꞌ ba riꞌchi cuuca guiñiꞌbi loh ñihsa nin nuu laꞌn pihyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","laasii cuuca-cuuca riehta tuhbi aanjla loh pihyi chi ya ruñiꞌbi aanjla chi ñihsa nin nuu laꞌn pihyi chi, ya mwer bwiinn nin riuuꞌtii loh ñihsa chi riaca ba cuun chiꞌzi gueldxyihdxyi nin rahca ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ya riꞌchi naꞌ tuhbi bwiinn nin naa la galda bitsiꞌh bixunna yihza rahcalluꞌhu ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chin bwaꞌha Jesuhs loh ba, naꞌ ba riꞌchi, guhcabwaꞌ Jesuhs xchih la rahcalluꞌhu ba, chiꞌchi rahbi Ñiꞌh loh ba: ―¿Ta xclaaꞌdzi luꞌh dxiaca luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chiꞌchi rahbi ba: ―Daada, ayi nin tuhbi bwiinn nin gacanee naꞌh cuꞌtii ba naꞌh loh pihyi ca chin rñiꞌbi loh ñihsa ca, ya naꞌh chin xclaaꞌdzihn chuꞌtiin pwihsi galoh la stuhbi bwiinn riuuꞌtii. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chiꞌchi rahbi Jesuhs loh ba: ―Gwastii tin batiaaꞌha xluꞌhn luꞌh tin guzah. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ya hohra chi gahca biaca ndxiꞌhw chi batiaaꞌha ba xluꞌhn ba ya bacaꞌh ba rzah ba, per ziga dxyih chi naa dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","chiꞌchi rahbi raꞌ ba loh bwiinn nin biaca chi: ―Nnahdxyih naa dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, ayi naa xnehza guicaꞌnnuꞌa luꞌh xluꞌhn luꞌh nnadxyih. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chiꞌchi rahbi bwiinn chi loh raꞌ ba: ―Bwiinn nin basiaca naꞌh, nah loon: “Batiaaꞌha xluꞌhn luꞌh tin bazah.” ");
INSERT INTO zpvNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh bwiinn chi, rahbi raꞌ ba: ―¿Cuunlla bwiinn nin guñiꞌ loh luꞌh nah: “Batiaaꞌha xluꞌhn luꞌh tin guzah?” ");
INSERT INTO zpvNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per laꞌh bwiinn chi cun ayi gaann ba chyuñin basiaca laꞌh ba laasii gaduhbi nin rii ziahan bwiinn dxyigahsi basaꞌbi Jesuhs nez lahda raꞌ bwiinn ziahan nin rii riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ya snuhniꞌhnsi rahca bwaꞌha Jesuhs laꞌh bwiinn nin biaca chi laꞌn guidoꞌ, chiꞌchi rahbi Ñiꞌh loh ba: ―Bwaꞌha nnah tin ayi chuu xtuhlda luꞌh tin ayi nagah nalaasa ru saca luꞌh loh ziga guzahca luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ya chiꞌchi gwaguihtsi ndxiꞌhw chi loh raꞌ bwiinn Israel laꞌh Jesuhs basiaca laꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","pwihsi pur niꞌchin gucaꞌnnaꞌhla raꞌ bwiinn Israel raꞌ chi laꞌh Jesuhs tin guclaaꞌdzi raꞌ ba ñidxiinn raꞌ ba laꞌh Ñiꞌh, laasii rusiaca Ñiꞌh bwiinn raꞌ dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","per laꞌh Jesuhs rahbi Ñiꞌh lohsi raꞌ ba: ―Laꞌh Xtaaꞌdahn zeezah cayuhnn ba dziꞌn, nee cun neezaa naꞌh ruꞌnnahn dziꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ya pur dxyiꞌdxyi raꞌ riiꞌ mahzi ru guclaaꞌdzi raꞌ bwiinn Israel raꞌ chi ñidxiinn raꞌ ba laꞌh Jesuhs, per ayi pur nin ayi rahpadaa dxiꞌh Ñiꞌh dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, sino que laasii neezaa rahbi Ñiꞌh naa Ñiꞌh Dxiohs, nee rahbi za Ñiꞌh Dxiohs naa Xpaah Ñiꞌh, niꞌchin. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ya chiꞌchi rahbi Jesuhs: ―Guchiin nin rñiꞌn loh tu, laꞌh Lliiꞌn Dxiohs ayi nuu guunn Ñiꞌh tuhbi dziꞌn xcweenta si Ñiꞌh; sola rahca ruhnn Ñiꞌh nin rwaꞌha Ñiꞌh ruhnn Xtaada Ñiꞌh, nee garaa nin ruhnn Daada rahca ruhnn Lliiꞌn ban, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pwihsi laꞌh Xpaaꞌn nadziiꞌhi ba laꞌh Lliiꞌn ba nee ruluuꞌyi ba laꞌh Lliiꞌn ba garaa nin ruhnn ba, nee zuluuꞌyi za ba laꞌh Lliiꞌn ba dziꞌn roo ru raꞌ, dziꞌn raꞌ nin guunn gadxyigaaꞌ duxa loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","laasii ziga rucwaꞌhn Xtaaꞌdahn laꞌh raꞌ bwiinn loh guelguhchi nee gudiꞌhi ba guelnabahan laꞌh bwiinn, ziꞌchi za laꞌh Lliiꞌn Ñiꞌh rudiꞌhi Ñiꞌh guelnabahan laꞌh bwiinn chiꞌh zi nin xclaaꞌdzi Ñiꞌh gudiꞌhi Ñiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ya laꞌh Xpaaꞌn ayi ruhnn Ñiꞌh guelguxchisi laꞌh chyu chiꞌh zi, laꞌh Lliiꞌn si Ñiꞌh badiꞌhi Ñiꞌh guelrnabwaꞌ, tin guunn Lliiꞌn Ñiꞌh guelguxchisi xcweenta raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tin gaann za raꞌ bwiinn laꞌh nin naa Lliiꞌn Ñiꞌh ziga za raann raꞌ ba laꞌh Xtaada Dxiohs Ñiꞌh. Bwiinn nin ayi ruzoꞌbadxiahga xchiꞌdxyi Lliiꞌn Dxiohs, ayi za ruzoꞌbadxiahga bwiinn chi xchiꞌdxyi Xtaada Dxiohs Ñiꞌh nin guluꞌnehza laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Rahbi za Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, bwiinn nin rucaꞌdxiahga dxyiꞌdxyi raꞌ nin rñiꞌn loh tu nee riachii za stoꞌ ba laꞌh bwiinn nin guluꞌnehza naꞌh, zahpa ba guelnabahan nin ayi ñichilohtiiꞌ, nee ayi tiidxi ba loh guelguxchisi, laasii ba badiiꞌdxi ba xcweenta guelguhchi pur xcweenta guelnabahan. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pwihsi guchiin nin rñiꞌn loh tu zadzihn hohra nee naan hohra gahca nin dxihnn raꞌ bwiinnguuchi xchiꞌdxyi Lliiꞌn Dxiohs; ya bwiinn raꞌ nin guzoꞌbadxiahga xchiꞌdxyi Ñiꞌh zibahan raꞌ ba ");
INSERT INTO zpvNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","laasii laꞌh gahca ziga nahpa Xtaaꞌdahn guelnabahan para laꞌh Ñiꞌh, neezaa badiꞌhi Ñiꞌh guelnabahan laꞌh Lliiꞌn Ñiꞌh zigagahca nahpa Ñiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","nee badiꞌhi za Ñiꞌh guelrnabwaꞌ laꞌh Lliiꞌn Ñiꞌh, tin guunn Lliiꞌn Ñiꞌh guelguxchisi, laasii naa Ñiꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ayi gadxyigaaꞌ loh tu pur dxyiꞌdxyi raꞌ riiꞌ, laasii zadzihn hohra nin dxihn raꞌ garaa raꞌ bwiinn guuchi xchiꞌdxyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ya gariaꞌh raꞌ bwiinn nin bwiꞌhnn dziꞌn zaꞌca laꞌn baꞌ, tin gabiaꞌgarii gabahan raꞌ ba stuhbi, per laꞌh raꞌ bwiinn raꞌ nin bwiꞌhnn raꞌ dziꞌn dxaaba gabahan raꞌ ba hohra chi tin chiꞌchiyi tiidxi raꞌ ba loh guelguxchisi xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Rahbi za Jesuhs: ―Naꞌh si ayi nuu guꞌnnahn xilla dziꞌn xcweenta sihn; naꞌh ruꞌnnahn guelguxchisi ziga gahca nin rihndxiaagahn nee xquelguxchiisihn nanchii naan, ayi ruꞌnnahn nin xclaaꞌdzi sihn sino que nin xclaaꞌdzi Xtaaꞌdahn nin guluꞌnehza naꞌh gahca. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sidela naꞌh rñiꞌn xcweenta gahcahn, nin rñiꞌn ayi xi guilasahcan, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","per nuu stuhbi nin rñiꞌ pur xcweeꞌntahn, nee naꞌh naꞌnnahn nin rñiꞌ bwiinn chi xcweeꞌntahn lasahcan ziga dxyiꞌdxyi nanchii paꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Laꞌh tu guxeꞌhla tu nin baganaabadxyiꞌdxyi loh Jwahn, ya nin guñiꞌ Jwahn guchii dxyiꞌdxyi raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","per naꞌh ayi rchiꞌnaꞌhn guiñiꞌ tuhbi bwiinn zi xcweeꞌntahn, laasii rñiꞌ sihn dxyiꞌdxyi riiꞌ loh tu tin gaca taꞌh tu loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jwahn naa ziga tuhbi lámpara nin rcaꞌh biaꞌñih, ya laꞌh tu guclaaꞌdzi tu ñahxi tu loh xpiaꞌñih ba chiohpa-choonn dxyih, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","per naꞌh naꞌpahn nin ruluuꞌyiloh ru chyu naan nin lasahca ru loh nin guñiꞌ Jwahn: dziꞌn gahca raꞌ nin ruꞌnnahn naan tuhsi gahca cun dziꞌn nin baniꞌhi Xpaaꞌn naꞌh guꞌnnahn, pwihsi dee raꞌ ruluuꞌyi Xtaada nin guluꞌnehza naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Neezaa Xtaaꞌdahn nin guluꞌnehza naꞌh laꞌh ba guñiꞌ nanchii la chyu naan nicala laꞌh tu nagahdxi gwaꞌha tu laꞌh ba nee nicala za nagahdxi dxihn tu guiñiꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","per xchiꞌdxyi ba ayi riaꞌzi tun laasii ayi riachiistoꞌ tu naꞌh, ziga naan Lliiꞌn Ñiꞌh nin guluꞌnehza Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Laꞌh tu cun paseensi duxa rusiꞌdxi tu loh Xchihtsi Dxiohs, laasii radxiꞌhyi tu lohon guelnabahan nin ayi ñichilohtiiꞌ, pwihsi Xchihtsi Dxiohs ruzeꞌtan naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","per laꞌh tu ayi nnaa tu dxieꞌbiiga tu loon tin guicaꞌha tu guelnabahan chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Rahbi za Ñiꞌh: ―Naꞌh ayi chiꞌhyihn chyu bwiinn guiñiꞌ zaꞌca xcweeꞌntahn, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","laasii naꞌh nayaa-nayaa nuꞌnbwaꞌn laꞌh tu nee naann zahn ayi rahca nadziiꞌhi lastoꞌ tu laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naꞌh zeꞌldahn pur lah Xtaaꞌdahn, ya laꞌh tu ayi rucaꞌdxiahga tu xchiꞌdxyiꞌhn, per sidela dxiꞌ stuhbi bwiinn zi pur xcweenta gahca ba niꞌchisihn zucaꞌdxiahga tu xchiꞌdxyi bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xa chechiistoꞌ tu sidela rñiꞌ zaꞌca tu ziga xcweenta tuhbi tu, cun ziga stuhbi tu, nee ayi rdxiꞌhyi tu guiñiꞌ zaꞌca Dxiohs gahca pur xcweenta tu; Dxiohs nin nabahan dziꞌtsi dxibaaꞌ, Dxiohs nin naa tuhbi dxiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ayi guunn tu lligaaba naꞌh gudziiꞌbaꞌhn duhlda yihca tu nez loh Xtaaꞌdahn, laasii bwiinn nin gudziiꞌba duhlda yihca tu naa guehtu Moisehs gahca nin riachiistoꞌ tu xlehyi ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pwihsi sidela laꞌh tu ñiachiistoꞌ tu dxyiꞌdxyi raꞌ nin guñiꞌ guehtu Moisehs, neezaa ñiachiistoꞌ tu xchiꞌdxyiꞌhn laasii bazeꞌta guehtu Moisehs naꞌh loh raꞌ dxyiꞌdxyi nin bacaꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","per sidela ayi riachiistoꞌ tu dxyiꞌdxyi raꞌ nin bacaꞌh guehtu Moisehs, ¿xalla chechiistoꞌ chiꞌh tu dxyiꞌdxyi raꞌ nin rñiꞌn loh tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ya chin guyaꞌloh garaa raꞌ deeꞌ, chiꞌchi gunaꞌzu nehza Jesuhs tin gwah Ñiꞌh stuhbi lahdu rwaaꞌ laguhn xteenn Galilea nin rñiꞌ za raꞌ ba ñihsadoꞌ xteenn Tiberias. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ziahan duxa raꞌ bwiinn zeꞌnee laꞌh Ñiꞌh laasii bwaꞌha raꞌ ba milahgru raꞌ cun sehn rooꞌ raꞌ nin bwiꞌhnn Ñiꞌh chin basiaca Ñiꞌh laꞌh bwiinn dxyihdxyi raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ya chiꞌchi gucah Jesuhs tuhbi dahan, tin guzohbanee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","nee ziga zalliaaꞌ riaꞌdxi gadzihn lañih pascu raꞌ bwiinn Israel chin rudiꞌhi raꞌ ba guelzuxchiilli loh Dxiohs pur dxyih nin bariaꞌh raꞌ ba guihdxyi Egiptu. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chin bwaꞌha Jesuhs loh raꞌ bwiinn ziahan raꞌ nin zenaꞌhla laꞌh Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh Felipe: ―¿Canehza chosiꞌ nuꞌh guelwahw tin gahw raꞌ bwiinn ziahan raꞌ riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ loh Felipe tin gwaꞌha Ñiꞌh cuun nin ñiñiꞌ ba, laasii laꞌh Jesuhs bwen-bwen naannla Ñiꞌh xa guunn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","chiꞌchi rahbi Felipe loh Jesuhs: ―Nin chiohpa gaywaꞌh mweeyi denariu pahn ayi gaaldaa gahw raꞌ bwiinn ca per nin yahnn raꞌ ba ayi dxiehtan. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ya tuhbi xpwiinn Jesuhs nin laa Andrehs bwihtsi Simohn Pehdru guñiꞌ ba, rahbi ba loh Jesuhs: ");
INSERT INTO zpvNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Riiꞌ laꞌh tuhbi biꞌnxtuhbi zuu laꞌh bi nuꞌa gaꞌyu pahn nin guhcachaꞌyi cun sebada cun chiohpa bwehlda, per ¿calla gaaldaa dee dxiꞌh loh bwiinn ziahan duxa raꞌ ca? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chiꞌchi rahbi Jesuhs: ―Gulgahbi loh raꞌ bwiinn raꞌ ca soobaa raꞌ ba. Ya nez chi ziahan rooꞌ dxillaaꞌ rii riꞌchi, ya guzohba raꞌ bwiinn raꞌ chi ziga gaꞌyu mihyi ndxiꞌhw si raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ya chiꞌchi gucaꞌha Jesuhs pahn chi ya chin guyaꞌloh badiꞌhi Ñiꞌh guelzuxchiilli loh Xtaada Dxiohs Ñiꞌh, chiꞌchi badiꞌhi Ñiꞌh pahn chi laꞌh raꞌ xpwiinn Ñiꞌh tin gudxiꞌzi raꞌ ban loh raꞌ bwiinn ziahan raꞌ chi, nee ziꞌchi gahca za bwiꞌhnnee Ñiꞌh bwehlda raꞌ hastayi gwadxah raꞌ bwiinn ziahan raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ya chin guyaꞌloh gudahw raꞌ ba hasta ayi gunnah ru raꞌ ba ñahw raꞌ ba, chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Gulgatiaaꞌha garaa raꞌ nin biaꞌhancah tin ayi xi ñichiloh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ya batiaaꞌha raꞌ ba nin biaꞌhancah chi niꞌchi guhca ziga zatsiꞌh bichiohpa tiipi pahn chi cun bwehlda chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ya bwiinn raꞌ chi chin bwaꞌha raꞌ ba sehn rooꞌ nin bwiꞌhnn Jesuhs, chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―Guchiica, laꞌh ba naa ndxiꞌhw nin rñiꞌ loh Xchihtsi Dxiohs nahpa dxiꞌ loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per laꞌh Jesuhs laꞌh Ñiꞌh guhcabwaꞌla xclaaꞌdzi raꞌ bwiinn raꞌ chi chenee raꞌ ba laꞌh Ñiꞌh lajweersi tin guunn raꞌ ba laꞌh Ñiꞌh rrehyi, niꞌchin biahchi Ñiꞌh loh raꞌ ba tin gunaꞌzu Ñiꞌh zee Ñiꞌh hasta naa guiyaꞌ ru loh dahan chi tin riꞌchi laꞌhsi Ñiꞌh gwah Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ya chin gurih gueꞌla, biehta raꞌ xpwiinn Jesuhs rwaaꞌ ñihsa ");
INSERT INTO zpvNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tin gucah raꞌ ba laꞌn tuhbi laancha ya zeenee laancha chi laꞌh raꞌ ba guihdxyi Capernaum, per laꞌh gueꞌla gurih chihpa la hohra chi, nee laꞌh Jesuhs nagahdxi gabiaꞌgarii Ñiꞌh hohra chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ya seguihdu guyahsa tuhbi bwih rooꞌ loh ñihsa chi hasta zezahnee laancha chi laꞌh raꞌ xpwiinn Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","zigachiꞌh gaꞌyu o xoꞌpa kilómetru zeezahnee laancha chi laꞌh raꞌ ba loh ñihsa chin bwaꞌha raꞌ ba laꞌh Jesuhs, zeezah Ñiꞌh loh ñihsa nez zenee laancha laꞌh raꞌ ba, chiꞌchi bidxyihbi duxa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","per lwehgu guñiꞌ Ñiꞌh loh raꞌ ba rahbi Ñiꞌh: ―¡Naꞌhan, ayi guidxyihbi tu! ");
INSERT INTO zpvNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ya chiꞌchi loh gaduhbistoꞌ raꞌ ba basaaꞌn raꞌ ba gucah Jesuhs laꞌn laancha chi, ya seguihdu badzihnnee Ñiꞌh laꞌh raꞌ ba loh yuh xteenn guihdxyi hasta zee raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ya chin barah gueꞌla stuhbi dxyih, guhcabwaꞌ raꞌ bwiinn raꞌ nin rii raꞌ stuhbi lahdu rwaaꞌ ñihsa hasta biriaꞌhnee laancha laꞌh raꞌ xpwiinn Jesuhs, zee raꞌ xpwiinn Jesuhs laꞌn tuhbi dxiꞌh laancha nin zuu rwaaꞌ ñihsa per ayi zeenee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh tuhsi, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ya balaaquiꞌhn si rahca laꞌh raꞌ paaldaa raꞌ laancha raꞌ nin zieꞌ raꞌ nez loh guihdxyi Tiberias bieꞌ raꞌ, nee guihdxyi Tiberias chi riaꞌhan gahxu nez badiꞌhi Jesuhs pahn gudahw raꞌ bwiinn ziahan, chin badiꞌhi Ñiꞌh guelzuxchiilli loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ya chin bwaꞌha raꞌ ba nin Jesuhs nin xpwiinn Ñiꞌh ayi riꞌchi, chiꞌchi gucah raꞌ bwiinn ziahan raꞌ chi laꞌn laancha raꞌ tin zeegadxiꞌhyi raꞌ ba laꞌh Jesuhs nez guihdxyi Capernaum. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ya chin badzihn raꞌ ba stuhbi lahdu rwaaꞌ ñihsadoꞌ chi, badxeela raꞌ ba laꞌh Jesuhs riꞌchi, chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Mwehsu, ¿cuuca badzihn luꞌh neziiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, radxiꞌhyi tu naꞌh laasii gudahw tu hastayi gwadxah tu; ayi radxiꞌhyi dxiꞌh tu naꞌh pur guhcabwaꞌ tu xi zee loh sehn rooꞌ raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayi guunn tu dziꞌn pur guelwahw nin rñihchiloh sino que gulguiꞌhnn dziꞌn pur guelwahw nin ayi ñichiloh cun nin rudiꞌhi za guelnabahan nacuubi nin ayi ñichilohtiiꞌ laꞌh raꞌ bwiinn. Dee naa guelwahw nin guniꞌhi Lliiꞌn Dxiohs nin naa ndxiꞌhw, laasii laꞌh Daada Dxiohs baluuꞌyi Ñiꞌh loh raꞌ bwiinn cuun nin naa Lliiꞌn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh: ―¿Xa niꞌca guidiꞌhnn nu tin gachidiꞌhnn nu ziga xclaaꞌdzi Dxiohs gachidiꞌhnn nu? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Nin xclaaꞌdzi Dxiohs guunn tu naa chechiistoꞌ tu xchiꞌdxyi Lliiꞌn Ñiꞌh nin guluꞌnehza Ñiꞌh loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ya chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Cuun nin naa sehn nin guniꞌhi luꞌh laꞌh nu tin chin guidiaꞌha nu sehn chi chechiistoꞌ nu yiꞌh? ¿Cuun dziꞌn rooꞌ nin ruhnn luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xtaada guldooꞌ raꞌ nuꞌh gudahw raꞌ ba tuhbi lasaaꞌ pahn nin laa manah loh dahan desiertu ziga caa loh Xchihtsi Dxiohs: “Badiꞌhi Ñiꞌh pahn nin zeꞌ nez llaaꞌndxibaaꞌ gudahw raꞌ ba.” ");
INSERT INTO zpvNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, ayi Moisehs dxiꞌh baniꞌhi pahn nin zeꞌ llaaꞌndxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","laasii pahn nin runiꞌhi Dxiohs pahn chi zeꞌ nez llaaꞌndxibaaꞌ ya rudiꞌhin guelnabahan laꞌh raꞌ bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―Daada, guniꞌhi luꞌh pahn chi guidaꞌw nu garaa dxyih. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Naꞌh naan pahn nin runiꞌhi guelnabahan; bwiinn nin dxiꞌ loon ayi chuu dxyih nin guichiaꞌhan bwiinn chi, ziꞌchiza bwiinn raꞌ nin chechiiza stoꞌ raꞌ ñiꞌh naꞌh ayiza guidxahga raꞌ ba ñihsa, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","per naꞌh ziga rñiꞌn loh tu, laꞌh tu ayi riachiistoꞌ tu xchiꞌdxyiꞌhn nicala ba bwaꞌha tu naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Garaa raꞌ bwiinn nin rutiꞌdxi Xtaaꞌdahn loon, zeꞌ raꞌ ba loon; ya bwiinn raꞌ nin zeꞌ loon ayi cweꞌhestoꞌraꞌn ba ");
INSERT INTO zpvNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","laasii naꞌh ayi zeꞌldadxiꞌhn nez llaaꞌndxibaaꞌ tin guꞌnnahn nin naa xigaabasihn loh guidxyiyuh riiꞌ sino que naꞌh zeꞌldahn tin guꞌnnahn nin xclaaꞌdzi Xtaaꞌdahn nin nuu dxibaaꞌ gaca, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ya dee naa xigaaba Xtaaꞌdahn nin guluꞌnehza naꞌh gaca: Garaa nin baniꞌhi Ñiꞌh naꞌh ayi ñichi nin tuhbi raꞌ ba sino que gucwaꞌnaꞌhn laꞌh raꞌ ba loh dxyih nin gaduhbi guidxyiyuh, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","laasii ziga naa xigaaba Xtaaꞌdahn nin nuu dxibaaꞌ garaa raꞌ bwiinn raꞌ nin gwaꞌha laꞌh Lliiꞌn Ñiꞌh nee chechiizastoꞌ raꞌ ba laꞌh Ñiꞌh, zahpa raꞌ ba guelnabahan nin ayi ñichilohtiiꞌ, ya naꞌh gucwaꞌnraꞌn ba loh guelguhchi chin guigaꞌha hohra nin guibiaꞌgariin. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pwihsi niꞌchin guzoꞌbaloh bidxyiꞌchinee bwiinn Israel raꞌ chi laꞌh Jesuhs, laasii rahbi Ñiꞌh laꞌh Ñiꞌh naa Ñiꞌh pahn nin biehta dxibaaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","neezaa guñiꞌ raꞌ ba rahbi raꞌ ba: ―¿Tayi niꞌca dxiꞌhn nin naa lliiꞌn Joseh? Laꞌh nuꞌh nuꞌnbwaꞌ nuꞌh xpaah bwiinn ca cun xmaah ba. ¿Xaalla cañiꞌ chiꞌh ba loh nuꞌh nnah naa ba biehta ba nez llaaꞌndxibaaꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Xixnaa rwaꞌha dxaaba tu loon? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nin tuhbi tu ayi dxieꞌbiiga nez loon sidela laꞌh Xtaaꞌdahn nin guluꞌnehza naꞌh ayi dxieꞌnee laꞌh tu; ya naꞌh gucwaꞌnaꞌhn laꞌh tu loh guelguhchi dxyih nin gadzihn hohra guibiaꞌgariin. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Loh dxihtsi nin bacaꞌh raꞌ guehtu profeta raꞌ rñiꞌ: “Zuluuꞌyi Dxiohs laꞌh garaa raꞌ ba.” Niꞌchin garaa raꞌ bwiinn nin rucaꞌdxiahga xchiꞌdxyi Xtaaꞌdahn nee nin rusiꞌdxi loh Ñiꞌh niꞌchi raꞌ nin dxieꞌbiiga nez loon. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pwihsi ayi nin tuhbi bwiinn nin bwaꞌha la laꞌh Xtaada Dxiohsaꞌhn; sola tuhbi dxiꞌh Lliiꞌn Ñiꞌh nin zeꞌ nez llaaꞌndxibaaꞌ nuꞌnbwaꞌ laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Guchiin nin rñiꞌn loh tu, bwiinn nin riachiistoꞌ ñiꞌh xchiꞌdxyiꞌhn nahpa za ba guelnabahan nin ayi ñichilohtiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Pwihsi naꞌh naan pahn nin runiꞌhi guelnabahan laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xtaada guldooꞌ raꞌ tu gudahw raꞌ tuhbi lasaaꞌ guelwahw nin laa manah loh dahan desiertu, riꞌchi badiꞌhi Dxiohs guelwahw chi gudahw raꞌ ba, per guhchi raꞌ ba; ");
INSERT INTO zpvNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","per naꞌh ruzeꞌtaꞌhn pahn nin biehta nez dxibaaꞌ nee bwiinn nin gahw pahn chi ayi gachi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naꞌh naan pahn nabahan nin biehta nez dxibaaꞌ; bwiinn nin gahw pahn riiꞌ zibahan ba par tuꞌpazi, nee pahn nin gudiꞌhihn laꞌh raꞌ bwiinn naa bweꞌltiꞌxihn par laꞌh raꞌ bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chiꞌchi rahbi loh lasaaꞌ raꞌ bwiinn Israel raꞌ chi: ―¿Xa guunn niꞌca guniꞌhi bweꞌltihxi niꞌca guidaꞌw nuꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Guchiin nin rñiꞌn loh tu, sidela laꞌh tu ayi gahw tu bweꞌltihxi Lliiꞌn Dxiohs nin naa ndxiꞌhw cun guee za tu llarihn Ñiꞌh ayi gapa tu guelnabahan nacuubi. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bwiinn raꞌ nin gahw bweꞌltiꞌxihn cun guee raꞌ ba llarinahn, bwiinn raꞌ chi gapa guelnabahan nin ayi ñichilohtiiꞌ; ya naꞌh gucwaꞌnraꞌn ba loh guelguhchi dxyih nin gadzihn hohra guibiaꞌgariin, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","laasii bweꞌltiꞌxihn naa guelwahw zaꞌcapaꞌca nee llarihnahn naa nin guchii nahpa guee raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bwiinn nin gahw bweꞌltiꞌxihn cun guee za ba llarihnahn bwiinn chi nuuneepaꞌca ba naꞌh nee naꞌh nuꞌneezahn laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Xtaaꞌdahn nin guluꞌnehza naꞌh loh guidxyiyuh, nahpa za ba guelnabahan, nee naꞌh nabahanahn pur laꞌh ba; pwihsi ziꞌchi gahca za laꞌh bwiinn nin gucaꞌstoꞌ ñiꞌh naꞌh zibahan za ba pur naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ruzeꞌtaꞌhn pahn nin biehta nez dxibaaꞌ; pahn riiꞌ ayi naan ziga pahn nin laa manah nin gudahw raꞌ guehtu xtaadaguldooꞌ tu, niꞌchin nicala gudahw raꞌ ban per guhchi raꞌ ba; per bwiinn raꞌ nin gahw pahn nin biehta nez dxibaaꞌ zibahan raꞌ ba par tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesuhs baluuꞌyi dxyiꞌdxyi raꞌ riiꞌ loh tuhbi cwaꞌha bwiinn laꞌn xquidoꞌ biꞌtuꞌhn raꞌ bwiinn Israel loh guihdxyi Capernaum. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ya chin bihn raꞌ ziahan raꞌ xpwiinn Jesuhs dxyiꞌdxyi nin guñiꞌ Ñiꞌh, rahbi raꞌ ba: ―Dxyiꞌdxyi nin rñiꞌ ba nagahn duxa raꞌn; ¿chyu niꞌca guunn waanta guzoꞌbadxiahga dxyiꞌdxyi raꞌ riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ya chin guhcabwaꞌ Jesuhs xi lligaaba nin cayuhnn raꞌ ba, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―¿Ta pur dxyiꞌdxyi raꞌ riiꞌ ruhnn chiohpa stoꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xa gaca sidela laꞌh tu gwaꞌha tu laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw gacah hasta nuu Ñiꞌh desde galohtiiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spíritu naa nin runiꞌhi guelnabahan, ya bweꞌltihxi bwiinn ayi lliitiiꞌ ruhnnan gahn, ya dxyiꞌdxyi raꞌ nin cañiꞌn loh tu naa dxyiꞌdxyi nanchii xteenn Spíritu, nee dxyiꞌdxyi raꞌ chi rudiꞌhi guelnabahan par tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per loh ziga rii tu riꞌca nuu mas paaldaa tu nin ayi riachiistoꞌ tu dxyiꞌdxyi nin rñiꞌn loh tu. Pwihsi Jesuhs desde galohyi naann Ñiꞌh cuun raꞌ bwiinn raꞌ nin riachiistoꞌ laꞌh Ñiꞌh nee cuun za nin naa bwiinn nin gutooꞌ laꞌh Ñiꞌh loh raꞌ bwiinn duhlda, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ya rahbi Ñiꞌh loh raꞌ ba: ―Niꞌchin nin rñiꞌn loh tu ayi chyu dxieꞌbiiga nez loon ziꞌchizi sidela laꞌh Xtaaꞌdahn ayi dxieꞌnee laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ya desde hohra chi ziahan raꞌ xpwiinn Jesuhs basaaꞌn raꞌ ba laꞌh Ñiꞌh, ya ayi ru guzahnee raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh raꞌ xpwiinn paꞌca Ñiꞌh, rahbi Ñiꞌh: ―¿Gu neezaa laꞌh tu xclaaꞌdzi tu dxiahchi tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chiꞌchi rahbi Simohn Pehdru: ―Daada, ¿chyuloo chiꞌh choo nu? Xchiꞌdxyi luꞌh naa guelnabahan nin ayi ñichilohtiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Laꞌh nu ba riachiistoꞌ nu xchiꞌdxyi luꞌh, nee naann za nu yiꞌh naa luꞌh Crixtu Lliiꞌn Dxiohs nin nabahan. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chiꞌchi rahbi Jesuhs: ―¿Tayi naꞌh dxiꞌh guliin laꞌh tu ziga naa tu gadziꞌh bichiohpa xpwiiꞌnnraꞌn? Pwihsi rñiꞌn loh tu, tuhbi tu naa bwiinndxaaba. ");
INSERT INTO zpvNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ya loh guñiꞌ Jesuhs squiiꞌ bazeꞌta Ñiꞌh laꞌh Judas, lliiꞌn Simohn Iscariote, laasii Judas naa nin gutooꞌ laꞌh Ñiꞌh loh raꞌ bwiinn duhlda, laꞌh ba nin naa tuhbi bwiinn loh gadziꞌh bichiohpa xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ya chin guyaꞌloh raꞌ deeꞌ, gucaꞌnzaa Jesuhs loh guihdxyi Galilea; per nin ayi guclaaꞌdzi Ñiꞌh ñuuꞌ Ñiꞌh loh guihdxyi Judea laasii riꞌchi badxiꞌhyi raꞌ bwiinn Israel raꞌ laꞌh Jesuhs tin ñidxiinn raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ya ziga badzihn gahxu dxyih lañih nin rahcachaꞌyi yuuꞌyiꞌhn nin riaꞌhan raꞌ bwiinn laꞌn ñiꞌh; lañih riiꞌ naa tuhbi xlañih raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","chiꞌchi rahbi raꞌ nin naa raꞌ bwihtsi Jesuhs loh Ñiꞌh: ―Ayi dxiaꞌhan luꞌh riiꞌ; gwah para guihdxyi Judea tin riꞌchi neezaa raꞌ xpwiinn raꞌ luꞌh nin caꞌnzanee luꞌh gwaꞌha raꞌ ba garaa raꞌ dziꞌn raꞌ nin ruhnn luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","laasii chin xclaaꞌdzi bwiinn guluuꞌyi zaꞌca ba laꞌh raꞌ bwiinn, ayi ruhnn ba xtsiꞌn ba ralaꞌn; niꞌchin sidela yiꞌh ruhnn luꞌh dziꞌn raꞌ riiꞌ, bwiꞌhnnan loh raꞌ garaatiiꞌ raꞌ bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pwihsi nin bwiꞌhnn raꞌ bwihtsi Ñiꞌh nin laꞌh raꞌ ba ayi gwachiistoꞌ raꞌ ba xchiꞌdxyi Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Pwihsi naꞌh xohraꞌhn nagahdxi gadzihnan, per para laꞌh tu xohra chiꞌzi naa bwen para laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bwiinn raꞌ nin naa raꞌ bwiinn guidxyiyuh raꞌ ayi nuu gwaꞌha dxaaba raꞌ ba loh tu, per naꞌh rwaꞌha dxaaba raꞌ ba loon laasii naꞌh ruluuꞌyiꞌhn loh dziꞌn dxaaba nin ruhnn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gulcheh lañih laꞌh tu, per naꞌh ayi chaaꞌhahn laasii nagahdxi guigaꞌha xohraꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ya chin guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ loh raꞌ ba, biaꞌhan chiꞌh Ñiꞌh loh guihdxyi Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ya loh nin zeeñiidxiuu raꞌ bwihtsi Jesuhs para lañih, neezaa Jesuhs gwah lañih chi nicala ayi nez ñihn raꞌ paꞌh bwiinn sino que ralaꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ya laꞌh raꞌ bwiinn Israel raꞌ badxiꞌhyi raꞌ ba laꞌh Jesuhs loh lañih chi, squiiꞌ rahbi raꞌ ba: ―¿Cuun laꞌh ndxiꞌhw chi? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nez lahda raꞌ bwiinn riigazeꞌta duxa raꞌ ba laꞌh Jesuhs; nuu raꞌ bwiinn chi rahbi raꞌ ba: ―Jesuhs naa tuhbi ndxiꞌhw nin ruhnn dziꞌn zaꞌca. Ya nuu raꞌ ba rahbi raꞌ ba: ―Ayi guinazaꞌca naa dziꞌn nin ruhnn ndxiꞌhw chi, rusaguiꞌhi ba laꞌh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ya nin tuhbi bwiinn ayi biaalla ñuuꞌyidxyiꞌdxyipaꞌh nez loh raꞌ bwiinn xcweenta Jesuhs laasii rdxyihbi raꞌ ba laꞌh raꞌ bwiinn Israel raꞌ nin rnabwaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ya laꞌh lañih zeezah la mas garoolda la chin guyuuꞌtiiꞌ Jesuhs laꞌn guidoꞌ ya chiꞌchi guzoꞌbaloh cagaluuꞌyi Ñiꞌh xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ya laꞌh raꞌ bwiinn Israel raꞌ nin rnabwaꞌ chi badxyigaaꞌ duxa loh raꞌ ba ya rahbi raꞌ ba: ―¿Xaloh naann niꞌca ziahan raꞌ dxyiꞌdxyi nee nin ayi ca basiꞌdxi niꞌca? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chiꞌchi rahbi Jesuhs: ―Dxyiꞌdxyi raꞌ nin ruluꞌyiꞌhn laꞌh tu ayi naan pur naꞌh gahca sino que pur Dxiohs nin guluꞌnehza naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sidela chyuulla tuhbi bwiinn xclaaꞌdzi guunn ziga nin xclaaꞌdzi Dxiohs gaca, zahcabwaꞌ ba sidela laꞌh dxyiꞌdxyi raꞌ nin ruluꞌyiꞌhn zeꞌ pur Dxiohs o naan xchiꞌdxyi gahcahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bwiinn nin rñiꞌ pur laꞌh gahca ba, rñiꞌ ba tin guiñiꞌ zaꞌca bwiinn laꞌh ba, per nin rdxiꞌhyi guiñiꞌ zaꞌca bwiinn pur nin guluꞌnehza laꞌh ba loh guidxyiyuh riiꞌ niꞌchi rñiꞌ dxyiꞌdxyi raꞌ nin guchii, nee ayi xi guelrusaguiꞌhi nuu laꞌn lastoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Tayi guchii dxiꞌhn, Moisehs baniꞌhi lehyi laꞌh tu?, nee nnah nin tuhbi tu ayi ruzoꞌbadxiahga tu lehyi chi. ¿Xixnaa xclaaꞌdzi tu chiinn tu naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chiꞌchi rahbi raꞌ bwiinn raꞌ loh Ñiꞌh: ―¡Nuu tuhbi bwiinndxaaba stoꞌ luꞌh! ¿Chyu xclaaꞌdzi chiinn yiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chiꞌchi rahbi Jesuhs: ―Pur tuhbi dziꞌn nin bwiꞌhnnaꞌhn dxyih nin ruziꞌlaaꞌdzi tu, niꞌchin nin garaa tu radxyigaaꞌ loh tu; ");
INSERT INTO zpvNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","pwihsi Moisehs guleꞌhe lehyi nin riuuꞌ bwaꞌ tihxi bwiinn ndxiꞌhw (nicala ayi laꞌh dxiꞌh Moisehs gudxiꞌnlaaꞌdzin sino que laꞌh raꞌ xtaada guldooꞌ raꞌ tu gudxiꞌnlaaꞌdzin) ya laꞌh tu rguꞌ tu bwaꞌ laꞌh tuhbi biñiꞌn nicala naan dxyih nin ruziꞌlaaꞌdzi tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pwihsi sidela rahca rguꞌ tu bwaꞌ tihxi tuhbi biñiꞌn nee nicala dxyih nin ruziꞌlaaꞌdzi tu tin ayi ñichi lehyi Moisehs, ¿xixnaa chiꞌh naꞌh ayi nnaa tu gusiaꞌcahn tuhbi bwiinn nin rahcalluꞌhu dxyih nin ruziꞌlaaꞌdzi tu lwehgu rdxyiꞌchinee tu naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ayi ruhnn tu guelguxchisi pur nin rwaꞌha si tu, sino que chin ruhn tu guelguxchisi, gulguiꞌnnan per ziga naa xnehza. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ya chiꞌchi guzoꞌbaloh gunaabadxyiꞌdxyi raꞌ paaldaa raꞌ bwiinn guihdxyi Jerusalehn raꞌ rahbi raꞌ ba: ―¿Tayi niꞌca dxiꞌhn nin radxiꞌhyi raꞌ ba tin chiinn raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nee nnah ¿tayi laꞌh dxiꞌh ba niꞌca nin cañiꞌ riꞌca loh raꞌ bwiinn?, nee nin tuhbi bwiinn ayi xi rñiꞌ loh ba, o ¿gu nee raꞌ za guxchisi riachiistoꞌ raꞌ ba laꞌh ndxiꞌhw ca naa Crixtu? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per dela nnah laꞌhnuꞌh naann nuꞌh canehza zeꞌ niꞌca; nee ziga chin dxiꞌ Crixtu nin ayi chyu gaann canehza dxiꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ya chin bihn Jesuhs dxyiꞌdxyi raꞌ riiꞌ chin cagaluuꞌyi Ñiꞌh laꞌn guidoꞌ, chiꞌchi jweersi rooꞌ guñiꞌ Ñiꞌh, rahbi Ñiꞌh loh raꞌ ba: ―¿Ta ruhnn chiꞌh tu lligaaba nuꞌnbwaꞌ tu naꞌh, nee naann za tu canehza zeꞌldahn? Per ayi zeꞌlda dxiꞌhn pur xcweenta gahcahn, sino que nuu chyu guluꞌnehza naꞌh nee laꞌh ba nanchii paꞌca nabahan ba; laꞌh tu ayi nuꞌnbwaꞌ tu laꞌh bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","per naꞌh nuꞌnbwaꞌn laꞌh ba laasii naꞌh zeꞌldahn hasta nuu ba, nee laꞌh ba guluꞌnehza ba naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ya chiꞌchi guclaaꞌdzi raꞌ bwiinn raꞌ chi ñinaꞌzu raꞌ ba laꞌh Ñiꞌh, per nin tuhbi raꞌ ba ayi biaalla ñinaꞌzu laꞌh Ñiꞌh laasii nagahdxi guigaꞌha xohra Ñiꞌh para gusaꞌcazii raꞌ bwiinn nadxaaba raꞌ chi laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","per bwiinn ziahan duxa za gwachii stoꞌ raꞌ ñiꞌh laꞌh Jesuhs, ya rahbi raꞌ ba: ―Chin dxiꞌ Crixtu, ¿ta mahzi ru sehn roo ru chiꞌh guunn Crixtu chi ziga laꞌh bwiinn riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ya bihn raꞌ bwiinn fariseu raꞌ nin bazeꞌta raꞌ bwiinn laꞌh Jesuhs, chiꞌchi bwiinn fariseu raꞌ chi cun nin rnabwaꞌ laꞌh raꞌ bixohza raꞌ guxeꞌhla raꞌ ba guixaꞌga raꞌ xteenn guidoꞌ tin chenee raꞌ ba laꞌh Jesuhs tin dxieꞌw Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ya chiꞌchi rahbi Jesuhs: ―Spaaldaa si dxyih ziuuꞌhuhn lahda tu, chiꞌchi zabiaꞌgariin hasta nuu nin guluꞌnehza naꞌh loh guidxyiyuh riiꞌ; ");
INSERT INTO zpvNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","laꞌh tu gadxiꞌhyi tu naꞌh per ayi gadxeela tu naꞌh laasii ayi nuu chee tu hasta guzaaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ya chiꞌchi guzoꞌbaloh canaabadxyiꞌdxyi loh lasaaꞌ raꞌ bwiinn Israel raꞌ chi, rahbi raꞌ ba: ―¿Canehza chee chiꞌh niꞌca? ¿Tayi chyu guunn gahn gadxeela niꞌca? o ¿gu guzee niꞌca hasta rii raꞌ bwiinn Israel raꞌ nin rii raꞌ nez lahdxyi raꞌ bwiinn griehgu raꞌ tin guluuꞌyi ba laꞌh raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Xi zee loh xchiꞌdxyi ba nin guñiꞌ ba loh nuꞌh: “Gadxiꞌhyi tu naꞌh per ayi gadxeela tu naꞌh laasii ayi nuu guzee tu hasta guzaaꞌhahn?” ");
INSERT INTO zpvNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ya luulchima dxyih xteenn lañih chi naa dxyih lañihroo ru, ya dxyih chi guñiꞌ Jesuhs loh raꞌ bwiinn Israel raꞌ chi jweersirooꞌ, rahbi Ñiꞌh: ―¡Sidela chyuulla tuhbi bwiinn rdxahga ba ñihsa, dxiꞌ bwiinn chi nez loon tin guee ban! ");
INSERT INTO zpvNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ziga caa loh Xchihtsi Dxiohs, stoꞌ bwiinn nin riachiistoꞌ ñiꞌh naꞌh rtahn guiꞌw raꞌ xteenn ñihsa nabahan. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ya cun dxyiꞌdxyi raꞌ riiꞌ bazeꞌta Jesuhs bwiinn raꞌ nin chechiistoꞌ raꞌ ñiꞌh laꞌh Ñiꞌh zicaꞌha raꞌ ba Spíritu Saantu; pwihsi nagahdxi gaaldaa dxiꞌ Spíritu Saantu laasii nagahdxi gacah Jesuhs dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ya paaldaa raꞌ bwiinn nin rii riꞌchi, chin bihn raꞌ ba dxyiꞌdxyi raꞌ nin guñiꞌ Jesuhs, chiꞌchi rahbi raꞌ ba squiiꞌ: ―Guchiica ndxiꞌhw ca naa ba daada nin nahpa dxiꞌ ziga caa loh Xchihtsi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ya snuhn raꞌ ba rahbi: ―Bwiinn ca naa Crixtu nin dxuleꞌza nuꞌh. Per spaaldaa raꞌ ba rahbi: ―¿Xa gaca tuhbi bwiinn guihdxyi Galilea Crixtu? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Laasii loh Xchihtsi Dxiohs rñiꞌ nahpa xtulbaaꞌ guehtu Davihd gaca Crixtu, nee dxiꞌ Ñiꞌh nez guihdxyi Belehn lahdxyi gahca guehtu rrehyi Davihd. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ya ziꞌchi gulaaꞌha loh lasaaꞌ raꞌ bwiinn pur Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nuu raꞌ bwiinn nin guclaaꞌdzi ñanee laꞌh Jesuhs tin ñieꞌw Ñiꞌh, per nin tuhbi za raꞌ ba ayi biaalla ñuhnn ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ya gubiaꞌgarii raꞌ guixaꞌga raꞌ xteenn guidoꞌ hasta rii raꞌ bwiinn fariseu raꞌ cun nin rnabwaꞌ laꞌh raꞌ bixohza, ya rahbi raꞌ ba loh raꞌ guixaꞌga raꞌ chi: ―¿Xixnaa ayi gunaꞌzu tu laꞌh ndxiꞌhw chi? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ya chiꞌchi rahbi raꞌ guixaꞌga chi loh raꞌ ba: ―¡Ayi chyu gunaꞌzu laꞌh ba laasii ayi nin tuhbi bwiinn nin guiñiꞌ ziga rñiꞌ bwiinn chi! ");
INSERT INTO zpvNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ya chiꞌchi rahbi raꞌ bwiinn fariseu raꞌ chi: ―¿Ta nee laꞌh tu basaꞌn tu bisaguiꞌhi tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ayi nin tuhbi nin rnabwaꞌ laꞌh nuꞌh o tuhbi raꞌ bwiinn fariseu nin riachiistoꞌ ñiꞌh laꞌh ndxiꞌhw chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Per laꞌh raꞌ bwiinn riiꞌ nin ayi gaann raꞌ ba lehyi, bwiinn dii raꞌ ba! ");
INSERT INTO zpvNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ya Nicodemu, nin gwah hasta nuu Jesuhs gueꞌla, naa ba tuhbi bwiinn fariseu; ya rahbi ba: ");
INSERT INTO zpvNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ziga naa xlehyi nuꞌh, ayi nuu chyu gudziiꞌba duhlda yihca bwiinn galoh nin nagahdxi dxihn nuꞌh mwer galoh cuun nin bwiꞌhnn ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ya chiꞌchi rahbi raꞌ ba loh Nicodemu: ―¿Ta nee luꞌh naa luꞌh tuhbi bwiinn guihdxyi Galilea? Basiꞌdxi loh Xchihtsi Dxiohs tin gwaꞌha luꞌh xa rñiꞌ lohon: nin tuhbi daada nin rñiꞌ xchiꞌdxyi Dxiohs ayi naa bwiinn guihdxyi Galilea. ");
INSERT INTO zpvNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ya chiꞌchi tuhbigah raꞌ ba ziaa raꞌ ba yihdzi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ya laꞌh Jesuhs zee Ñiꞌh para dahan nin laa Olivo, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ya chin barah gueꞌla, rsiiyidoꞌ gubiaꞌgarii Ñiꞌh laꞌn guidoꞌ stuhbi, ya garaa raꞌ bwiinn gwabiiga nez loh Ñiꞌh, ya lwehgu guzohba Jesuhs riꞌchi tin guzoꞌbaloh cagaluuꞌyi Ñiꞌh laꞌh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ya chiꞌchi gutantiinee raꞌ nuhn mwehsu raꞌ nin ruluuꞌyi xlehyi Moisehs cun nun bwiinn fariseu raꞌ tuhbi gunnaꞌh nin badxeelanee tuhbi ndxiꞌhw, ya bazuh raꞌ ba laꞌh gunnaꞌh chi galaayi loh raꞌ snuhn raꞌ bwiinn nin rii raꞌ riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ya chiꞌchi rahbi raꞌ ba loh Jesuhs: ―Mwehsu, gunnaꞌh riiꞌ binaꞌzunee bi xtuꞌh bi, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","yannah ziga caa loh lehyi nin baniꞌhi guehtu Moisehs laꞌh nuꞌh nahpa gasiꞌdzi dxiah nuꞌh yihca gunnaꞌh raꞌ ziga deeꞌ tin gachi bi; ya yiꞌh ¿xi nnaa luꞌh xa gaca? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Laꞌh raꞌ ba guñiꞌ raꞌ ba squiiꞌ tin gwaꞌha raꞌ ba zidxeela xa gusiaꞌgarii Jesuhs dxyiꞌdxyi pur gunnaꞌh chi, tin ziꞌchi gaca gucaꞌhchiah dxixiꞌhw raꞌ ba laꞌh Ñiꞌh, chiꞌchi lwehgu baruꞌhn Jesuhs tin bacaꞌh Ñiꞌh loh yuh cun bacwihn naa Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ya ziga zeezah canaabadxyiꞌdxyi raꞌ ba loh Jesuhs, chiꞌchi guyahsa Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh raꞌ ba: ―Mwer bwiinn nin ayi xi duhlda nahpa, gucaꞌh dxiah yihca gunnaꞌh ca. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ya chiꞌchi baruꞌhn gahca Jesuhs loh yuh stuhbi tin gwazah bacaꞌh Ñiꞌh rrahyiꞌhn loh yuh, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","per laꞌh raꞌ ba chin bihn raꞌ ba dxyiꞌdxyi nin guñiꞌ Jesuhs loh raꞌ ba, chiꞌchi guzaꞌloh bareꞌh raꞌ bwiinn chi tuhbigah raꞌ ba desde nin guyuꞌxa ru hasta nin biiꞌhin ru, tin naann raꞌ ba nahpa raꞌ ba duhlda, ya chin barah raꞌ ba bareꞌh raꞌ ba tuhbi dxiꞌh gunnaꞌh chi bareꞌh gadxiaꞌhan, zunchii ba nez loh Jesuhs riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ya chin guzuꞌnchii Jesuhs bwaꞌha Ñiꞌh loh gunnaꞌh chi ayi bwaꞌha Ñiꞌh nin stuhbi raꞌ bwiinn dxixiꞌhw chi, chiꞌchi rahbi Ñiꞌh loh gunnaꞌh chi: ―Gunnaꞌh, ¿cuun raꞌ bwiinn raꞌ nin bieꞌnee yiꞌh nez loon? ¿Tayi guyuuꞌ nin tuhbi raꞌ ba nin ñudziiꞌba duhlda yihca luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chiꞌchi rahbi gunnaꞌh chi loh Jesuhs: ―Daada, nin tuhbi raꞌ ba. Ya chiꞌchi rahbi Jesuhs loh gunnaꞌh chi: ―Nin naꞌh za ayi xi duhlda gudziiꞌbaꞌhn yihca luꞌh; pwihsi nnah gwah, ayiru cheezah luꞌh loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesuhs guñiꞌ loh raꞌ bwiinn stuhbi rahbi Ñiꞌh: ―Naꞌh naan biaꞌñih xteenn guidxyiyuh; bwiinn nin dxieꞌnaꞌhla naꞌh zahpa ba biaꞌñih nin rudiꞌhi guelnabahan ya ayi chuu dxyih sah ba loh nacahyi. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ya chiꞌchi rahbi raꞌ bwiinn fariseu raꞌ: ―Yiꞌh ziga rñiꞌ luꞌh xcweenta gahca luꞌh ayi guilasahcan. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Xcweenta ziga rñiꞌn loh tu lasahcan, nicala naꞌh rñiꞌn xcweenta gahcahn, per xchiꞌdxyiꞌhn lasahcan laasii naꞌnnahn canehza zeꞌldahn nee naꞌnnzahn canehza guzaaꞌhahn; per laꞌh tu ayi gaann tu canehza zeꞌldahn nee ayiza gaann tu canehza guzaaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Laꞌh tu ruhnn tu guelguxchisi ziga na chiꞌzi xigaaba bwiinn guidxyiyuh, per naꞌh ayi ruꞌnnahn guelguxchisi laꞌh nin tuhbi bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","per sidela naꞌh ruꞌnnahn guelguxchisi, guelguxchisi xteꞌnnahn naa guchii laasii ayi naꞌh si dxiꞌh ruꞌnnahn guelguxchisi sino que nee Xtaaꞌdahn nin guluꞌnehza naꞌh tuhsi junta ridiꞌhnn nun. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Hasta nee loh xlehyi tu caa, chin laꞌh chiohpa bwiinn rñiꞌ tuhsi gahca dxyiꞌdxyi, nahpa chechiistoꞌ tu laꞌh raꞌ bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pwihsi naꞌh guchiin nin rñiꞌn pur xcweenta gacahn, ya Xtaaꞌdahn nin guxeꞌhla naꞌh ziꞌchigahcaza rñiꞌ ba pur xcweeꞌntahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ya chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh Jesuhs, rahbi raꞌ ba: ―¿Ca nuu chiꞌh za xtaada luꞌh? Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh tu nin ayi nuꞌnbwaꞌ tu naꞌh, nin laꞌh za Xtaaꞌdahn ayi nuꞌnbwaꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dxyiꞌdxyi raꞌ riiꞌ guñiꞌ Jesuhs nez hasta zuu raꞌ alcansia nin riuuꞌ mweeyi guelguhn, per ayi chyu gunaꞌzu laꞌh Ñiꞌh tin ñieꞌw Ñiꞌh, laasii nagahdxi gadzihn hohra chiinn raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chiꞌchi rahbi laꞌgaꞌh Jesuhs: ―Naꞌh guzaaꞌhahn, ya laꞌh tu gadxiꞌhyi tu naꞌh per zahchi tu loh xtuhlda tu; pwihsi naꞌh hasta guzaaꞌhahn laꞌh tu ayi nuu guzee tun. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ya chiꞌchi rahbi loh lasaaꞌ raꞌ bwiinn Israel raꞌ chi: ―¿Ta zidxiinn gaca chiꞌh ba laꞌh ba, xinaa nnaa ba ayi gaca choo nuꞌh hasta guzee ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ya chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌh tu naa tu bwiinn loh guidxyiyuh riiꞌ, per naꞌh naan bwiinn nin zeꞌ nez llaaꞌndxibaaꞌ, niꞌchin rñiꞌn laꞌh tu naa tu bwiinn guidxyiyuh per naꞌh ayi nee dxiꞌhn naan bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pwihsi niꞌchin nin guñiꞌn loh tu zahchi tu loh xtuhlda tu, pwihsi sidela laꞌh tu ayi riachiistoꞌ tu xchiꞌdxyiꞌhn, naan nin naan, zahchi tu loh xtuhlda tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ya chiꞌchi gunaabadxyiꞌdxyi raꞌ ba rahbi raꞌ ba: ―¿Chyu naa luꞌh yiꞌh? Ya chiꞌchi rahbi Jesuhs: ―Laꞌn guñiꞌ loh tu desde galoh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Naꞌpahn ziahan dxyiꞌdxyi nin guiñiꞌn pur laꞌh tu nee guꞌnnahn guelguxchisi za laꞌh tu, pwihsi nin guluꞌnehza naꞌh guchii naa xchiꞌdxyi ba, ya dxyiꞌdxyi raꞌ nin rñiꞌn loh raꞌ bwiinn guidxyiyuh bihn raꞌñin loh nin guluꞌnehza naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per laꞌh raꞌ ba ayi guhcabwaꞌ raꞌ ba guñiꞌ Jesuhs xcweenta Daada Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","pwihsi niꞌchin rahbi Ñiꞌh: ―Chin laꞌh tu guiteesa tu laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw, chiꞌchi gacabwaꞌ tu naꞌh naan nin naan, nee ayi ruꞌnnahn dziꞌn raꞌ rii pur xcweenta gahcahn; rñiꞌsihn loh tu nin baluuꞌyi Xtaaꞌdahn naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","laasii nin guluꞌnehza naꞌh nuu Ñiꞌh tuhsi cun naꞌh, ―rahbi Jesuhs―; Xtaaꞌdahn ayi basiaꞌhan ba naꞌh tuhbidxiꞌhn laasii naꞌh guillii-guillii ruꞌnnahn nin xclaaꞌdzi ba gaca nin riuuꞌstoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ya chin guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ loh raꞌ ba, ziahan raꞌ ba gwachiistoꞌ raꞌ ba xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chiꞌchi rahbi Jesuhs loh raꞌ bwiinn Israel raꞌ nin gwachiistoꞌ raꞌ Ñiꞌh laꞌh Jesuhs: ―Sidela laꞌh tu chezahnee tu xchiꞌdxyiꞌhn gaduhbistoꞌ tu, zahca tu xpwiinn raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","tin gacabwaꞌ tu cuun nin naa dxyiꞌdxyi guchii ya dxyiꞌdxyi guchii chi gutaꞌh laꞌh tu loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi: ―Laꞌh nu naa llahga guehtu Abrahn, ya nin guduhbi nagahdxi gaca nu ziga mooza nin gudooꞌ loh nin tuhbi bwiinn; ¿xaalla rñiꞌ chiꞌh luꞌh yiꞌh gutaꞌh luꞌh laꞌh nu loh duhlda? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Pwihsi guchiin nin rñiꞌn loh tu, garaa raꞌ bwiinn raꞌ nin rguꞌtii duhlda naa raꞌ ba ziga mooza raꞌ nin gudooꞌ loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tuhbi bwiinn nin naa mooza ayi dxiaꞌhan ba rwaaꞌyihdzi xballwaaꞌn ba gaduhbi nin guibahan ba, per nin naa lliiꞌn ballwaaꞌn chi niꞌchi sihn ziaꞌhan bi rwaaꞌ yihdzi xtaada bi gaduhbi nin guibahan bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pwihsi ziꞌchi sidela laꞌh Lliiꞌn Dxiohs rutaꞌh laꞌh tu loh duhlda, pwihsi laꞌh tu guchii paꞌhca taꞌh tu loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Pwihsi naꞌh naꞌnnahn naa tu llahga guehtu Abrahn, per laꞌh tu xclaaꞌdzi tu gadxiinn tu naꞌh laasii ayi riuuꞌ tu ayi riaꞌzi tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naꞌh rñiꞌn loh tu dxyiꞌdxyi raꞌ nin baniꞌhi Xtaaꞌdahn guiñiꞌn loh tu, ya laꞌh tu ruhnn tu ziga guñiꞌ xtaada tu loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chiꞌchi rahbi raꞌ ba loh Jesuhs: ―¡Xtaada nu naa guehtu Abrahn! Ya chiꞌchi rahbi Jesuhs: ―Sidela laꞌh tu guchii tu naa tu lliiꞌn guehtu Abrahn, ñuhnn tu ziga bwiꞌhnn guehtu Abrahn, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","pwihsi naꞌh nicala guñiꞌn loh tu dxyiꞌdxyi guchii nin baniꞌhi Dxiohs guiñiꞌn loh tu, ya laꞌh tu xclaaꞌdzi tu gadxiinn tu naꞌh, ¡nee guehtu Abrahn ayi guyuuꞌ ba lligaaba ziga lligaaba nin nuu tu! ");
INSERT INTO zpvNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Laꞌh tu ruhnn tu ziga ruhnn xtaada tu. Ya chiꞌchi rahbi raꞌ ba loh Ñiꞌh: ―¡Ayi nee dxiꞌh nu naa nu lliiꞌn loh nehza bwiinn, sino que tuhbi dxiꞌh Daada Dxiohs naa Xtaada nu! ");
INSERT INTO zpvNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Sidela guchii tu naa Dxiohs Xtaada tu, pwihsi ñantsiiꞌhi tu naꞌh, laasii naꞌh zeꞌldahn pur xcweenta Dxiohs nee laꞌn zuuꞌhu loh tu riiꞌ; naꞌh ayi zeꞌldahn pur xcweenta gahcahn, sino que Dxiohs guluꞌnehza naꞌh loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Xixnaa ayi rahcabwaꞌ tu xchiꞌdxyiꞌhn? Pwihsi pweda pur nin ayi xclaaꞌdzi tu gucaꞌdxiahga tu xchiꞌdxyiꞌhn niꞌchin. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nin naa xtaada tu laꞌhtu naa bwiinndxaaba, laasii ruhnn tu ziga xclaaꞌdzi ba gaca. Bwiinndxaaba naa tuhbi nin rdxiinn bwiinn desde chin gurihxchih guidxyiyuh, ya nin nagahdxi guidxeela dxyiꞌdxyi nin guchii rwaaꞌ ba. Chin rñiꞌ ba dxyiꞌdxyi nin ayi guiguchii rñiꞌ ba pur laꞌh gahca ba laasii naa ba bwiinn nin ruuꞌyi dxyiꞌdxyi dxixiꞌhw ya naa ba xtaada dxyiꞌdxyi dxixiꞌhw, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","per ziga naꞌh rñiꞌn dxyiꞌdxyi nin guchii, laꞌh tu ayi riachii stoꞌ tu naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Chyu tuhbi tu zahca guluuꞌyi xtuꞌldahn? Sidela rñiꞌn dxyiꞌdxyi nin guchii, ¿xixnaa chiꞌh ayi riachiistoꞌ tu naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bwiinn nin naa xpwiinn Dxiohs ruzoꞌbadxiahga ba xchiꞌdxyi Dxiohs, per ziga laꞌh tu ayi naa tu xpwiinn Dxiohs niꞌchin nin ayi rucaꞌdxiahga tu xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ: ―¡Nachidxiaapaa nu rsohn chin rachiñiꞌ nu yiꞌh naa luꞌh tuhbi bwiinn Samaritano nee nuu tuhbi bwiinndxaaba stoꞌ luꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ayi nin tuhbi bwiinndxaaba stoꞌn; nin ruꞌnnahnsihn naa ruhnlasahcaꞌhn xcweenta Xtaaꞌdahn nin naa Dxiohs; ya laꞌh tu rbweꞌhestoꞌ tu naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naꞌh ayi chiꞌhyihn chyu guiñiꞌzaꞌca naꞌh nicala nuu chyuulla nin rdxiꞌhyi guiñiꞌzaꞌca bwiinn naꞌh, ya laꞌh ba naa nin guunn guelguxchisi. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pwihsi guchiin nin rñiꞌn loh tu bwiinn nin guzoꞌbadxiahga xchiꞌdxyiꞌhn ayi paꞌca gachi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi: ―¡Yannah naann dziꞌtsi nu nuu tuhbi bwiinndxaaba stoꞌ luꞌh! Guehtu Abrahn cun garaa raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs guhchi raꞌ ba, nee yiꞌh nnaa luꞌh: “¡Bwiinn nin guzoꞌbadxiahga xchiꞌdxyiꞌhn ayi gachi ba!” ");
INSERT INTO zpvNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ta mahziru chiꞌh lasahca luꞌh yiꞌh loh guehtu xpaah Abrahn nu? Laꞌh ba guhchi ba neezaa guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs guhchi za raꞌ ba, nee yiꞌh ¿chyu ruhnn luꞌh lligaaba naa luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Sidela naꞌh rñiꞌzaꞌcaꞌhn pur xcweenta gahcahn, pwihsi ayi xi guilasahca xcweeꞌntahn, per nin rñiꞌzaꞌca xcweeꞌntahn naa Xtaada Dxiohsaꞌhn; laꞌhgahca Ñiꞌh nin nnaa tu naa Xchiohs tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","per laꞌh tu ayi nuꞌnbwaꞌ tu laꞌh Ñiꞌh. Naꞌhsihn nuꞌnbwaꞌn laꞌh Ñiꞌh, ya sidela naꞌh guiñiꞌn loh tu ayi nuꞌnbwaꞌn laꞌh Ñiꞌh zahcaꞌhn tuhbi bwiinn dxixiꞌhw ziga laꞌh tu, per ziga rñiꞌn loh tu guchiin nuꞌnbwaꞌn laꞌh Ñiꞌh, nee ruzoꞌbadxiaagahn xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Guehtu Abrahn nin naa xtaada guldooꞌ tu biahxi ba laasii bihn ba gadzihn dxyih nin dxieꞌldahn, nee biahxi duxa ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi loh Jesuhs: ―Nagahdxi chuu luꞌh chywaꞌh bitsiꞌh yihza, ¿nee nnah luꞌh bwaꞌha luꞌh laꞌh guehtu Abrahn? ");
INSERT INTO zpvNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Pwihsi guchiin nin rñiꞌn loh tu, chin nagahdxi dxiꞌ guehtu Abrahn loh guidxyiyuh, naꞌh laꞌn nabahan la desde chiꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ya chiꞌchi gucaꞌha raꞌ ba dxiah ñah raꞌ ba yihca Jesuhs, per laꞌh Ñiꞌh lwehgu guyuuꞌlaꞌn Ñiꞌh loh raꞌ ba ya bariaꞌh Ñiꞌh laꞌn guidoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ya loh nin zeediiꞌdxi Jesuhs tuhbi lahta, bwaꞌha Ñiꞌh laꞌh tuhbi ndxiꞌhw nin ayi riin loh ñiꞌh desde chin guulaa ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ya chiꞌchi gunaabadxyiꞌdxyi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh, rahbi raꞌ ba: ―Mwehsu, ¿xixnaa guulaa bwiinn riiꞌ ayi riin loh ba? ¿Ta pur xtuhlda xcuzahn ba or pur xtuhlda gahca ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ayi pur xtuhlda dxiꞌ ba nin ayiza pur xtuhlda dxiꞌh xcuzahn ba; guulaa ba ziꞌca tin pur laꞌh ba guluuꞌyi Dxiohs nin gaca guunn Ñiꞌh pur laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ya gaduhbi nin naa radxyii nahpa guidiꞌhnn nuꞌh xtsiꞌn Bwiinn nin guluꞌnehza naꞌh laasii laꞌh gueꞌla zeꞌ chin ayi chyu gaca guunn dziꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ya gaduhbi nin nuuꞌhuhn loh guidxyiyuh riiꞌ naꞌh naan biaꞌñih loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ya chin guyaꞌloh guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi bachahn xihin Ñiꞌh loh yuh, ya cun xihin Jesuhs bwiꞌhnn Ñiꞌh nuhn bwen ya gudaꞌbi Ñiꞌhn loh bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ya chiꞌchi rahbi Ñiꞌh loh bwiinn nin ayi biin loh ñiꞌh chi: ―Gwachiꞌbi loh luꞌh loh estanque nin laa Siloeh. Ya riꞌchi gwachiꞌbi loh bwiinn chi, ya chin gubiaꞌgarii ba hasta zuu Jesuhs, laꞌh ba rahca la rwaꞌha. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ya xbisihn ba cun garaa raꞌ bwiinn raꞌ nin nuꞌnbwaꞌ laꞌh ba chin ayi biin loh ba cun chin guleꞌhe gahca za ba guhn, rahbi loh lasaaꞌ raꞌ bwiinn chi: ―¿Tayi dee dxiꞌh nin rzohba bweꞌhe guhn? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nuu raꞌ ba rahbi raꞌ ba: “Laꞌh ban”, ya snuhn raꞌ ba rahbi: “Ayi laꞌh dxiꞌh ban, nicala ziꞌchi rñah ba”, ya laꞌhgahca bwiinn nin ayi biin loh ñiꞌh chi rahbi: “Naꞌhan.” ");
INSERT INTO zpvNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ya chiꞌchi rahbi raꞌ bwiinn chi loh ba: ―¿Xaalla guhca chiꞌh nnah rwaꞌha luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chiꞌchi rahbi bwiinn chi: ―Laꞌh bwiinn nin laa Jesuhs, laꞌh ba bwiꞌhnn ba nuhn bwen gudaꞌbi ban loon, chiꞌchi nah ba loon: “Gwachiꞌbi loh luꞌh loh estanque nin laa Siloeh.” Ya guyaaꞌhahn, ya chin guyaꞌloh gudxiꞌbiꞌhn loon lwehgu guhca bwaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ya chiꞌchi rahbi raꞌ ba: ―¿Ca nuu ndxiꞌhw chi? Ya chiꞌchi rahbi bwiinn nin biaca loh ñiꞌh: ―Ayi gaꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chiꞌchi gwanee raꞌ ba laꞌh bwiinn nin biaca loh ñiꞌh chi loh raꞌ bwiinn fariseu, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ya dxyih nin basiaca Jesuhs loh bwiinn chi naa dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel, gudaꞌbi Ñiꞌh bwen loh ba, ya lwehgu ballaala loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ya chiꞌchi gunaabadxyiꞌdxyi raꞌ bwiinn fariseu loh bwiinn nin biaca loh ñiꞌh xa guhca biaca loh ba, ya chiꞌchi rahbi ba: ―Gudaꞌbi Jesuhs bwen loon ya chiꞌchi gudxiꞌbiꞌhn loon yannah laꞌn rwaꞌha. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ya chiꞌchi rahbi raꞌ paaldaa raꞌ bwiinn fariseu raꞌ chi: ―Nin bwiꞌhnn deeꞌ ayi naa ba xpwiinn Dxiohs, laasii ayi rahpadaa ba dxyih nin raziꞌlaaꞌdzi raꞌ nuꞌh. Ya snuhn raꞌ ba rahbi: ―Per ¿caalla gaca chiꞌh guunn ba dziꞌn rooꞌ sidela laꞌh ba naa ba tuhbi bwiinn duhlda? Ya ziꞌchi guhca chiohpa stoꞌ bwiinn raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ya chiꞌchi gunaabadxyiꞌdxyi laꞌgaꞌh raꞌ ba loh bwiinn nin biaca loh ñiꞌh chi: ―Pwihsi ziga biaca loh luꞌh, ¿xa rñiꞌ luꞌh pur bwiinn chi? Chiꞌchi rahbi bwiinn nin biaca loh ñiꞌh chi: ―Naꞌh rñiꞌn naa bwiinn chi tuhbi daada nin rñiꞌ xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per laꞌh raꞌ bwiinn Israel raꞌ chi ayi riachiistoꞌ raꞌ ba dxieꞌpa bwiinn nin ayi biin loh ñiꞌh desde chin guulaa ba nee nnah rwaꞌha ba, ya hasta que no gudihdxyi raꞌ ba xcuzahn bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh raꞌ xcuzahn ba squiiꞌ: ―¿Ta lliiꞌn tu deeꞌ? ¿Ta rñiꞌ tu ayi riin loh bi desde chin guulaa bi? ¿Xaloh chiꞌh nnah rwaꞌha bi? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chiꞌchi rahbi raꞌ xcuzahn bi: ―Laꞌh nu riuꞌnbwaꞌ nu lliiꞌn nu laꞌh bi desde guulaa bi ayi biin loh bi, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per nnah ayi chyu gaann xa guhca biaca loh bi nee nin ayiza chyu gaann chyu basiaca loh bi. Gulguinaabadxyiꞌdxyi loh bi; baniin ca zuu bi, ya laꞌh bi guiñiꞌ bi loh tu chyu basiaca loh bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Squiiꞌ guñiꞌ raꞌ xcuzahn bi laasii rdxyihbi raꞌ ba zahca raꞌ ba ziga biaꞌhan dxyiꞌdxyi bwiinn Israel raꞌ chi gabweꞌhedxiaꞌhla raꞌ ba laꞌn guidoꞌ chyu chiꞌzi bwiinn raꞌ nin guiñiꞌ Jesuhs naa Crixtu, ");
INSERT INTO zpvNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","pwihsi pur niꞌchin rahbi raꞌ xcuzahn bwiinn chi: “Gulguinaabadxyiꞌdxyi loh bi, baniin ca zuu bi.” ");
INSERT INTO zpvNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ya chiꞌchi gubiaꞌgarii gudihdxyi raꞌ ba bwiinn nin ayi biin loh ñiꞌh chi stuhbi tin rahbi raꞌ ba loh bi: ―Guñiꞌ loh nu dxyiꞌdxyi nin guchii paꞌh nez loh Dxiohs, laasii laꞌh nu naann nu laꞌh ndxiꞌhw chi naa ba tuhbi bwiinn duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chiꞌchi rahbi bwiinn nin ayi bihn loh ñiꞌh chi: ―Naꞌh ayi gaꞌnnahn gu naa ba bwiinn duhlda o ayi naa ban, pwihsi nin naann dxiꞌhn ayi riin loon nee nnah laꞌn rwaꞌha. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chiꞌchi rahbi raꞌ ba stuhbi: ―¿Xa bwiꞌhnnee ba yiꞌh? ¿Xa bwiꞌhnnee ba yiꞌh tin rwaꞌha luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chiꞌchi rahbi bwiinn nin ayi biin loh ñiꞌh chi: ―Laꞌn guñiꞌ la loh tu, per ayi riachiistoꞌ tu xchiꞌdxyiꞌhn. ¿Xixnaa xclaaꞌdzi tu guiñiꞌñin stuhbi? ¿Ta nee laꞌh tu xclaaꞌdzi tu gaca tu xpwiinn ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chiꞌchi guñiꞌ tohnta raꞌ ba loh bwiinn chi rahbi raꞌ ba: ―¡Yiꞌh dela gaca luꞌh xpwiinn ndxiꞌhw chi, per laꞌh nu xpwiinn Moisehs naa nu! ");
INSERT INTO zpvNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Laasii laꞌh nu naann nu guñiꞌ Dxiohs loh Moisehs, per ziga niꞌchi, ¡nin ayi chyu gaann canehza biinloh niꞌchi! ");
INSERT INTO zpvNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ya chiꞌchi rahbi bwiinn nin ayi biin loh ñiꞌh chi: ―¿Xiilla deeꞌ? ¡Laꞌh tu ayi gaann tu canehza biinloh ba, per naꞌh laꞌh ba basiaca loon! ");
INSERT INTO zpvNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pwihsi naann nuꞌh Dxiohs ayi rucaꞌdxiahga Ñiꞌh xchiꞌdxyi bwiinn nin naa raꞌ bwiinn duhlda; rucaꞌdxiahga si Ñiꞌh laꞌh raꞌ bwiinn nin riachiistoꞌ raꞌ ñiꞌh xchiꞌdxyi Ñiꞌh cun nin ruzoꞌbadxiahga raꞌ xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nin tuhbi nagahdxi saꞌbi dxyiꞌdxyi chyu bwiinn basiaca la loh tuhbi bwiinn nin guulaa dxieꞌpa. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sidela laꞌh ndxiꞌhw riiꞌ ayi zeꞌ ba pur xcweenta Dxiohs, ayi nuu ñuhnn ba nin tuhbi dziꞌn raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chiꞌchi rahbi raꞌ ba loh bwiinn chi: ―Yiꞌh desde guulaa luꞌh naa luꞌh bwiinn duhlda; ¿ta xclaaꞌdzi chiꞌh luꞌh guluuꞌyi luꞌh laꞌh nu? Chiꞌchi babweꞌhedxiaꞌhla raꞌ ba laꞌh bwiinn chi laꞌn guidoꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ya chin bihn Jesuhs babweꞌhedxiaꞌhla raꞌ ba laꞌh bwiinn nin ayi biin loh ñiꞌh chi laꞌn guidoꞌ, niꞌchin chin badxiꞌloh Ñiꞌh laꞌh ba, chiꞌchi rahbi Ñiꞌh loh ba: ―¿Ta riachiistoꞌ luꞌh laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chiꞌchi rahbi bwiinn chi: ―Daada, gudxixteeꞌ loon cuun nin naa laꞌh ba tin chechiistoꞌn laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chiꞌchi rahbi Jesuhs loh ba: ―Laꞌh luꞌh bwaꞌha la; naꞌh naan laꞌh ba, naꞌh nin cañiꞌ loh luꞌh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ya chiꞌchi bazuꞌnllihbi bwiinn chi loh Jesuhs, ya rahbi ba loh Ñiꞌh: ―Riachiistoꞌn yiꞌh, Daada. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lwehgu rahbi Jesuhs: ―Naꞌh zeꞌldahn loh guidxyiyuh riiꞌ tin guꞌnnahn guelguxchisi, tin garaa raꞌ bwiinn raꞌ nin ayi riin raꞌ loh ñiꞌh gwaꞌha raꞌ ba, nee tin laꞌh za raꞌ bwiinn nin riin raꞌ loh raꞌ ñiꞌh dxiaꞌhan dxieꞌpa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ya paaldaa raꞌ bwiinn fariseu raꞌ nin zuunee Ñiꞌh riꞌchi, chin bihn raꞌ ba dxyiꞌdxyi raꞌ riiꞌ, gunaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¿Ta zee loh xchiꞌdxyi chiꞌh luꞌh nee laꞌh nu naa nu dxieꞌpa? ");
INSERT INTO zpvNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Sidela laꞌh tu ñahca tu dxieꞌpa ayi xi duhlda ñahpa tu pur xtuhlda tu; per ziga rñiꞌ tu rahbi tu rwaꞌha tu, nahpa tu duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ya chiꞌchi rahbi Jesuhs: ―Pwihsi guchiin nin rñiꞌn loh tu; bwiinn nin ayi chuꞌtii rwaaꞌ leeꞌ hasta chuꞌtii raꞌ nin naa raꞌ ziga xiꞌhyi raꞌn, mas chuꞌtii raꞌ ba nez stuhbi lahdu, bwiinn chi naa gubaꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","per laꞌh bwiinn nin riuꞌtii rwaaꞌ leeꞌ bwiinn chi naa baxtohra nin rahpa laꞌh lliꞌhyi raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ya bwiinn nin rahpa rwaaꞌ leeꞌ zixaala ba rwaaꞌ leeꞌ tin chuꞌtii baxtohra ya lliꞌhyi raꞌ chi nuꞌnbwaꞌ raꞌ ma rsiaaꞌha baxtohr chi, chiꞌchiyi cwidxi ba lliꞌhyi raꞌ chi tuhbigah raꞌ ma, laasii tuhbigah raꞌ ma nuu lah ma, laꞌh ba cweꞌhe ba laꞌh raꞌ lliꞌhyi chi laꞌn leeꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ya chin laꞌh ba bwiꞌhnn gahn biriaꞌh garaa raꞌ lliꞌhyi raꞌ chi, chiꞌchi ñiidxiuu ba loh raꞌ ma ya lliꞌhyi raꞌ chi zianaꞌhla raꞌ ma laasii nuꞌnbwaꞌ raꞌ ma rsiaaꞌha ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pwihsi ayi chenaꞌhla raꞌ lliꞌhyi raꞌ chi nin ayi nuꞌnbwaꞌ raꞌ ma; nahpa zulluꞌn raꞌ ma loh niꞌchi laasii ayi nuꞌnbwaꞌ raꞌ ma rsiaaꞌha raꞌ snuhn raꞌ bwiinn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Bwiiꞌyidxyiꞌdxyi Jesuhs dxyiꞌdxyi raꞌ riiꞌ tin guiduꞌhun gu ñahcabwaꞌ raꞌ ban, per laꞌh raꞌ ba ayi guhcabwaꞌ raꞌ ba nin zee loh dxyiꞌdxyi raꞌ rii. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chiꞌchi rahbi laꞌgah Jesuhs stuhbi: ―Guchiin nin rñiꞌn loh tu, naꞌh naan ziga rwaaꞌ leeꞌ nez chuꞌtii raꞌ bwiinn raꞌ nin naa raꞌ ziga xiꞌhyihn. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Garaa raꞌ nin biꞌ raꞌ galoh loon guhca raꞌ ba gubaꞌn raꞌ, per laꞌh raꞌ nin naa raꞌ ziga lliꞌhyi ayi bazoꞌbadxiahga raꞌ ba xchiꞌdxyi raꞌ bwiinn gubaꞌn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naꞌh naan rwaaꞌ leeꞌ, ya bwiinn raꞌ nin chuꞌtii pur naꞌh, zilaꞌh raꞌ ba loh duhlda nee gaca raꞌ ba ziga tuhbi lliꞌhyi nin riuuꞌtii nee rariaꞌgaꞌh ma tin radxeela ma dxillaaꞌ zaꞌca rahw ma, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ya gubaꞌn zeꞌ si ba tin cwaan si ba cun chiinn ba nee tin gutsihyi ba; per naꞌh zeꞌldahn tin gapa tu guelnabahan zaꞌca nee tin gapa za tu zirooꞌ duxan. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naꞌh naan baxtohra zaꞌca, ya baxtohra zaꞌca zudiꞌhi ba xquelnabahan gahca ba xcweenta raꞌ xiꞌhyi ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","per nin ruhnn dziꞌn ruhnn ban tin gahlla si ba, nee chin rwaꞌha ba zeꞌ bweew rusiaꞌhangah ba lliꞌhyi bachiꞌh rulluꞌn ba, laasii ayi naa ba baxtohra nee laasii ayi za naa lliꞌhyi xteenn ba; ya bweew rutiꞌchibwih ma laꞌh raꞌ lliꞌhyi nezii-neziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bwiinn chi rulluꞌn ba laasii nin xclaaꞌdzi si ba naa gahlla ba; ayi ruhnn ba lligaaba pur laꞌh raꞌ lliꞌhyi. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Rahbi za Jesuhs: ―Naꞌh naan baxtohra zaꞌca, nee nuꞌnbwaꞌhn nin naa raꞌ xiꞌhyiraꞌn nee nin naa raꞌ xteꞌnnahn nuꞌnbwaꞌ za raꞌ ba naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ziga nuꞌnbwaꞌ Xtaaꞌdahn naꞌh nee naꞌh nuꞌnbwaꞌzahn laꞌh Xtaaꞌdahn, ya zudiꞌhihn xquelnabanahn pur laꞌh raꞌ bwiinn raꞌ nin naa raꞌ ziga xiꞌhyi raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","nee neezaa naꞌpahn spaaldaa raꞌ lliꞌhyi nin ayi naa xleeꞌ raꞌ ñiꞌh riiꞌ, pwihsi nee raꞌ za niꞌchi raꞌ dxieꞌldaganeꞌhn nee zuzoꞌbadxiahga raꞌ ba xchiꞌdxyiꞌhn ya ziꞌchi chuu tuhsi lliꞌhyi cun tuhbisi za baxtohra. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Daada Dxiohs nadziiꞌhi naꞌh laasii naꞌh gudiꞌhihn xquelnabahanahn tin gabiaꞌgarii xquelnabanahn stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ayi nin tuhbi nin gusiaꞌpitii xquelnabahanahn sino que naꞌh rudiꞌhihn xquelnabahanahn pur xquelrnabwaꞌ gahcahn; naꞌpahn guelrnabwaꞌ tin gudiꞌhihn xquelnabahanahn nee gabiaꞌgarii gabahnaꞌhn stuhbi. Dee naa guelrnabwaꞌ nin baniꞌhi Xtaada Dxiohsaꞌhn naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ya chin bihn raꞌ bwiinn Israel raꞌ chi dxyiꞌdxyi raꞌ riiꞌ, guhca chiohpa stoꞌ raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ya ziahan raꞌ ba rahbi: ―¿Xixnaa rucaꞌdxiahga tu xchiꞌdxyi ba? ¿Tayi rwaꞌha tu nuu tuhbi bwiinndxaaba stoꞌ ba nee neezaa cayahca yihca ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Per snuhn raꞌ ba rahbi: ―Ayi nin tuhbi bwiinn nin nuu bwiinndxaaba stoꞌ ñiꞌh guunn para dxiaca loh tuhbi bwiinn dxieꞌpa. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Loh bweꞌhw nahlda raꞌ, chin cayahca lañih xteenn guidoꞌ loh guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","pwihsi nez chi caꞌnzaa Jesuhs nez rwaaꞌ pweerta xteenn Salomohn, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ya riꞌchi bataꞌwnaa raꞌ bwiinn Israel laꞌh Jesuhs ya rahbi raꞌ ba loh Ñiꞌh: ―¿Hasta cuucayi chixteeꞌ luꞌh loh nu sidela yiꞌh naa luꞌh Crixtu? Gudxixteeꞌ loh nu nnah. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chiꞌchi rahbi Jesuhs: ―Laꞌn guñiꞌlahn loh tu per ayi gwachiistoꞌ tu; dziꞌn raꞌ nin ruꞌnnahn cun xquelrnabwaꞌ Xtaaꞌdahn ruluuꞌyin nayaa-nayaa chyu naan, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","per laꞌh tu ayi riachiistoꞌ tu laasii ayi naa tu ziga xiꞌhyihn. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nin naa raꞌ ziga xiꞌhyihn nuꞌnbwaꞌ raꞌ ba rsiaaꞌhahn ya naꞌh nuꞌnbwaꞌzahn laꞌh raꞌ ba nee naꞌhla raꞌ ba naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naꞌh gudiꞌhihn guelnabahan nin ayi ñichilohtiiꞌ laꞌh raꞌ bwiinn nin naa ziga xiꞌhyiraꞌn nee ayi chuu dxyih nin guizaꞌbi raꞌ ba, nee ayiza nin tuhbi nin cweꞌhelluꞌhu laꞌh raꞌ ba loon. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xtaaꞌdahn nin baniꞌhi raꞌn naꞌh mahzi lasahca duxa ba nee rnabwaꞌ ru ba loh garaatiiꞌ, nee ayi chyu cweꞌhelluꞌhu laꞌh raꞌ ba loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","laꞌh Daada Dxiohs tuhsi naa nu. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ya gucaꞌha raꞌ bwiinn Israel raꞌ chi dxiah ñucaꞌh raꞌ ba yihca Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","per laꞌh Jesuhs rahbi Ñiꞌh loh raꞌ ba: ―Pur xquelrnabwaꞌ Xtaada Dxiohsaꞌhn cayuꞌnnahn ziahan dziꞌn zaꞌca loh tu; ¿ya cuun tuhbi dziꞌn nin ayi naa zaꞌca niꞌchin nin xclaaꞌdzi tu gucaꞌhdxiah tu naꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi: ―Ayi chyu gucaꞌhdxiah yiꞌh sidela cayuhnn luꞌh dziꞌn zaꞌca, sidela nnah xclaaꞌdzi luꞌh tiidxi luꞌh pur Dxiohs niꞌchin, pwihsi yiꞌh ayi naa luꞌh Dxiohs, yiꞌh naa luꞌh tuhbi bwiinn zi per cañiꞌ luꞌh yiꞌh naa luꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Per, ¿tayi loh xlehyi dxiꞌh tu caa squiiꞌ: “Naꞌh guñiꞌn naa tu dxiohsa raꞌ”? ");
INSERT INTO zpvNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Naann nuꞌh nin rñiꞌ loh Xchihtsi Dxiohs ayi chyu guunn guchaꞌh; Dxiohs guñiꞌ dxiohsa laꞌh raꞌ bwiinn raꞌ nin badiꞌhi Ñiꞌh xchiꞌdxyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ya sidela laꞌh Dxiohs gulii naꞌh tin guluꞌnehza Ñiꞌh naꞌh loh guidxyiyuh riiꞌ, ¿xaalla rñiꞌ chiꞌh tu laꞌhtu cañiꞌyaan laꞌh Dxiohs laasii cañiꞌn naan Lliiꞌn Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sidela naꞌh ayi ruꞌnnahn ziga xclaaꞌdzi Xtaaꞌdahn gaca ayi riachiistoꞌ tu naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","per sidela naꞌh guꞌnnañin nicala ayi chechiistoꞌ tu xchiꞌdxyiꞌhn, gulchechiistoꞌ tu pur nin ruꞌnnahn tin gacabwaꞌ tu garaa raꞌ nin nuunee Daada Dxiohs stoꞌn, ya naꞌh nuuneen laꞌh Xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ya guclaaꞌdzi raꞌ ba ñinaꞌzu raꞌ ba laꞌh Jesuhs stuhbi, per lwehgu bariaꞌh Ñiꞌh loh lahtsinaa raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ya gubiaꞌgarii Jesuhs nez stuhbi lahdu rwaaꞌ guiꞌw Jordahn nez hasta guyuuꞌ Jwahn nin baroꞌbañihsa galoh chin baroꞌbañihsa ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ya ziahan raꞌ bwiinn gwah raꞌ ba hasta guyuuꞌ Jesuhs ya rahbi raꞌ ba: ―Guchii, nicala laꞌh Jwahn ayi bwiꞌhnn ba nin tuhbi sehn rooꞌ, garaa nin guñiꞌ ba pur bwiinn riiꞌ guchiiꞌhin. ");
INSERT INTO zpvNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pwihsi ziahan raꞌ ba gwachiistoꞌ raꞌ ba laꞌh Jesuhs riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Guyuuꞌ tuhbi ndxiꞌhw nin biriaꞌlah Lásaro guhcalluꞌhu ba, guhca ba tuhbi bwiinn guihdxyi Betania, lahdxyi María cun stuhbi bwehldaa bi nin laa Marta. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María riiꞌ naa bizaaꞌn Lásaro, laꞌh bi nin gudaꞌbi nsehchi ñaaꞌ Jesuhs ya bacwihdzi bin cun dxyichyihca bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pwihsi garoopa raꞌ gunnaꞌh raꞌ riiꞌ nin naa bizaaꞌn Lásaro guxeꞌhla rsohn loh Jesuhs rahbi raꞌ bi: ―Daada, laꞌh xamihgu luꞌh nin nadziiꞌhi luꞌh cayahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ya laꞌh Jesuhs chin bihn Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ rahbi Ñiꞌh: ―Gueldxyihdxyi riiꞌ ayi guunnan gachitiiꞌ Lásaro para tuꞌpazi, sino que nahpa zalluꞌyin tin guluuꞌyin xa naa xquelrnabwaꞌ Dxiohs, nee cun xcweenta za xquelrnabwaꞌ Lliiꞌn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nicala laꞌh Jesuhs nadziiꞌhi duxa Ñiꞌh laꞌh Marta cun bwehldaa bi cun laꞌh Lásaro, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","chin rahbi raꞌ bi Lásaro cayahcalluꞌhu ayi gwah Jesuhs biaꞌhanru Ñiꞌh schiohpa dxyih nez hasta nuu Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ya seguihdu chin gudiiꞌdxi dxyih raꞌ chi chiꞌchi rahbi Ñiꞌh loh raꞌ xpwiinn Ñiꞌh: ―Gulchooꞌho stuhbi para guihdxyi Judea. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ya chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Mwehsu, gueꞌdugah guclaaꞌdzi raꞌ bwiinn Israel raꞌ nin rii raꞌ riꞌchi ñucaꞌh dxiah yiꞌh tin ñidxiinn raꞌ ba yiꞌh, ¿nee nnah xclaaꞌdzi laꞌgaꞌh luꞌh chee luꞌh riꞌchi stuhbi? ");
INSERT INTO zpvNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―¿Tayi guchiidxiꞌhn tsiꞌh bichiohpa hohra nuu tuhbi dxyih? Pwihsi sidela naꞌh rzaꞌhn radxyii ayi chyu nahpa gugaꞌhla naꞌh laasii rwaꞌha raꞌ ba biaꞌñih nin nuu loh guidxyiyuh riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per ziga bwiinn nin rzah loh nacahyi, zireꞌlda ba chyuulla, laasii ayi nahpa ba biaꞌñih. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chiꞌchi rahbilaꞌgaꞌh Ñiꞌh: ―Laꞌh xamihgu nuꞌh Lásaro guhtaꞌxgahsi, per nahpa guzoo nuꞌh tin gucwaꞌnaꞌhn bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ya chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh: ―Daada, sidela guhtaꞌxgahsi si bi, ziaaca bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Per nin guñiꞌ Jesuhs naa guhchi Lásaro gaduhbi nin riiyuhnn raꞌ xpwiinn Ñiꞌh lligaaba nastoꞌ raꞌ ba guhtaꞌxgahsi si Lásaro, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ya chiꞌchi rahbi Jesuhs loh raꞌ ba nayaa-nayaa: ―Laꞌh Lásaro guhchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","riahxiꞌhn laasii ayi guyuuꞌhuhn riꞌchi, laasii ziꞌchi naa bwen para laꞌh tu, tin ziꞌchi chechiistoꞌ tu. Yannah gulchooꞌho tin chodiaꞌhan nuꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ya chiꞌchi laꞌh Tomahs, nin guñiꞌ raꞌ ba badoꞌ cwaachi, rahbi loh spaaldaa raꞌ xpwiinn Ñiꞌh: ―Gulchooꞌho choo nuꞌh nee raꞌ nuꞌh tin gachinee nuꞌh laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ya chin badzihn Ñiꞌh riꞌchi, laꞌh tahpa dxyih naala guhchi Lásaro laꞌh ba bigaꞌtsi la. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Guihdxyi Betania riaꞌhan ziga chiꞌh chohnna kilómetru gahxu para guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ya ziahan raꞌ bwiinn Israel raꞌ gwaguiaꞌha cuun Marta cun María tin dxiaꞌlda stoꞌ raꞌ bi pur nin guhchi Lásaro, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ya chin bihn Marta laꞌh Jesuhs zeegadzihn riꞌchi, bireꞌh bi tin bagachiꞌloh bi laꞌh Jesuhs ya María biaꞌhan bi rwaaꞌ yuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","chiꞌchi rahbi Marta loh Jesuhs: ―Daada, sidela yiꞌh nuu luꞌh riiꞌ, ayi ñahchi bizaaꞌnahn, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","per naꞌh naꞌnnahn Dxiohs guniꞌhi yiꞌh garaa raꞌ nin guinaaba luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chiꞌchi rahbi Jesuhs: ―Zabiaꞌgarii gabahan bizaaꞌn luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chiꞌchi rahbi Marta: ―Pwihsi, naꞌh naꞌnnahn nahpa gabahan raꞌ bwiinn raꞌ nin guhchi dxyih nin gaduhbi guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ya chiꞌchi rahbi Jesuhs: ―Naꞌh naan guelnabahan nin gabahan raꞌ bwiinn loh guelguhchi dxyih chi, ya bwiinn nin chechiistoꞌ ñiꞌh naꞌh, nicala gachi ba per zabahan ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ya garaa raꞌ bwiinn nin nabahan raꞌ nee riachiistoꞌ raꞌ ba naꞌh, pwihsi ayi ñichiloh raꞌ ba par tuꞌpazi. ¿Ta riachiistoꞌ luꞌh dee raꞌ? ―rahbi Jesuhs loh Marta. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chiꞌchi rahbi Marta: ―Riachiistoꞌn Daada, naꞌh riachiistoꞌn yuꞌbiluꞌh naa luꞌh Crixtu, Lliiꞌn Dxiohs, Crixtu nin nahpa dxiꞌ loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ya chin guyaꞌloh guñiꞌ Marta dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi gwagañiꞌ bi loh bwehldaa bi María, ya guñiꞌ bi loh María dxigah si rahbi bi: ―Laꞌh mwehsu zuu riiꞌ, cabwihdxyi za ba yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ya chin bihn María dxyiꞌdxyi raꞌ riiꞌ lwehgu gwaguiaꞌha bi hasta zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ya laꞌh Jesuhs nagahdxi chuꞌtii Ñiꞌh lahda guihdxyi chi hohra chi sino que zuu Ñiꞌh nez hasta badxiꞌloh Marta laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ya bwiinn Israel raꞌ nin riinee laꞌh María tin dxiaꞌldastoꞌ bi bizaaꞌn bi Lásaro, chin bwaꞌha raꞌ ba gwasuꞌnchii María, zenaꞌhla raꞌ ba laꞌh María bwiꞌhnn raꞌ ba lligaaba zee bi rwaaꞌ baꞌ zeedxiꞌn bi, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ya chin badzihn María hasta zuu Jesuhs, bazuꞌnllihbi bi loh Jesuhs chiꞌchi rahbi bi loh Ñiꞌh: ―Daada, sidela yiꞌh nuu luꞌh riiꞌ, ayi ñahchi bizaaꞌnahn Lásaro. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ya chin bwaꞌha Jesuhs cayuꞌn María cun bwiinn Israel raꞌ nin zeꞌnee bi cayuꞌn za raꞌ ba, guhca nalaasa stoꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ya chiꞌchi gunaabadxyiꞌdxyi Ñiꞌh rahbi Ñiꞌh: ―¿Canehza bacaꞌtsi tu xcweerpu Lásaro? Ya rahbi raꞌ ba: ―Daada, gudaaꞌguiaꞌha. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chiꞌchi biꞌn Jesuhs riꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ya rahbi raꞌ bwiinn Israel raꞌ chi: ―Gulguiaꞌha balaaca riaa ba laꞌh Lásaro. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per paaldaa raꞌ ba rahbi: ―Niꞌca dxiꞌh nin basiaca loh bwiinn nin guulaa dxieꞌpa; ¿tayi xiilla ñuhnn ba laꞌh Lásaro tin ayi ñahchi ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Gubiaꞌgarii guhca nalaasastoꞌ Jesuhs, chiꞌchi gwabiiga Ñiꞌh hasta bigaꞌtsi Lásaro. Riꞌchi naa tuhbi cwehva dxiah, ya ñieꞌw tuhbi dxiah rooꞌ rwaaꞌ baꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chiꞌchi rahbi Jesuhs: ―Gulcooꞌba dxiah ca. Ya chiꞌchi rahbi Marta bizaaꞌn Lásaro loh Jesuhs: ―Daada, xchiaꞌ nadxaaba la tihxi Lásaro, laasii laꞌh tahpa dxyih guhca la guhchi bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chiꞌchi rahbi Jesuhs: ―¿Tayi guñiꞌdxiꞌhn loh luꞌh sidela yiꞌh chechiistoꞌ luꞌh xchiꞌdxyiꞌhn, zwaꞌha luꞌh xquelrnabwaꞌ Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ya chiꞌchi gudooꞌba raꞌ ba dxiah chi, chiꞌchi bwaꞌha Jesuhs nez llaaꞌndxibaaꞌ chiꞌchi rahbi Ñiꞌh: ―Paah, runiꞌhihn guelzuxchiilli loh yuꞌbiluꞌh laasii bihn luꞌh xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naꞌh naꞌnnahn ayi chuu dxyih nin ayi dxihn luꞌh chin rñiꞌn loh yuꞌbiluꞌh, pwihsi rñiꞌñin pur bwiinn raꞌ nin rii riiꞌ, tin chechiistoꞌ raꞌ ba yiꞌh guluꞌnehza luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ya chin guyaꞌloh guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ, guñiꞌ Ñiꞌh jweersi rooꞌ rahbi Ñiꞌh: ―¡Lásaro! ¡Bareꞌh riꞌca! ");
INSERT INTO zpvNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ya lwehgu bariaꞌh bwiinn guuchi chi riꞌchi, yiꞌbi naa ba cun ñaaꞌ ba cun lahdxi ya loh ba ñieꞌw tuhbi taaꞌha lahdxi, chiꞌchi rahbi Jesuhs: ―Gulgabweꞌhe lahdxi ca tihxi ba tin gulgasaaꞌn ba guziaa ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ya chiꞌchi ziahan raꞌ bwiinn Israel raꞌ chi nin bieꞌnee laꞌh María gwachiistoꞌ raꞌ ba laꞌh Jesuhs pur nin bwaꞌha raꞌ ba bwiꞌhnn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","per snuhn raꞌ ba gwah loh raꞌ bwiinn fariseu tin gwagañiꞌ raꞌ ba loh raꞌ bwiinn raꞌ chi cuun nin bwiꞌhnn Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ya chiꞌchi badiaaꞌha raꞌ bixohza raꞌ nin rnabwaꞌ loh raꞌ bixohza cun bwiinn fariseu raꞌ ya rahbi raꞌ ba: ―¿Xa niꞌca guidiꞌhnn nuꞌh? Ndxiꞌhw riiꞌ zeezah cayuhnn ziahan ru sehn roo raꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ya sidela laꞌh nuꞌh gasaaꞌn nuꞌh, garaa raꞌ bwiinn chechiistoꞌ ñiꞌh laꞌh ba, ya laꞌh raꞌ guxchisi romano ziꞌ raꞌ ba riiꞌ ya zucwih raꞌ ba xquidoꞌ nuꞌh cun gaduhbi lahdxyi nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Per tuhbi raꞌ ba nin laa Caifahs, laꞌn dxyih raꞌ chi rnabwaꞌ ba loh garaatiiꞌ raꞌ bixohza, naa ba nin naa bixohza rooꞌ loh raꞌ ba laꞌn dxyih raꞌ chi, ya rahbi ba: ―Laꞌh tu nin ayi xi rdxeela yihca tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nin ayi rahcabwaꞌ tu naa bwen para laꞌh nuꞌh gachi tuhbi dxiꞌ bwiinn xlawaaꞌha ñichiloh garaa raꞌ bwiinn lahdxyi raꞌ nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per laꞌh Caifahs ayi biinloh dxyiꞌdxyi riiꞌ yihca ba pur xcweenta gahca ba, sino que guñiꞌ ban laasii Dxiohs basiin lohon rwaaꞌ ba, nee pur nin naa za ba bixohzarooꞌ yihza chi niꞌchin guñiꞌxgah ba gachi Jesuhs que no ñahchi garaa raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","nee ayi sola laꞌh si dxiꞌh bwiinn Israel, sino que tin nee gadiaaꞌha raꞌ garaa raꞌ xpwiinn Dxiohs nin rii raꞌ nezii-neziꞌchi loh gaduhbi guidxyiyuh tin dxiahca raꞌ ba tuhsi guihdxyi xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pwihsi desde dxyih chi guzoꞌbaloh cadxiꞌhyi raꞌ bwiinn Israel raꞌ chi xa chiinn raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ya pur deeꞌ niꞌchin ayi ru gwazah Jesuhs labwehnutiiꞌ lahda raꞌ bwiinn Israel raꞌ, sino que biriaꞌh Ñiꞌh zee Ñiꞌh loh guihdxyi Judea, tin zee Ñiꞌh loh dahan desiertu, loh tuhbi guihdxyi nin laa Efraín; riꞌchi biaꞌhannee Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ya zalliaaꞌyiꞌhn riaꞌdxyi para gadzihn lañih paascu xteenn raꞌ bwiinn Israel raꞌ, niꞌchin ziahan bwiinn raꞌ xteenn raꞌ guihdxyi raꞌ chi zee raꞌ ba guihdxyi Jerusalehn, tin zee gasiaa raꞌ ba lastoꞌ raꞌ ba riꞌchi galoh nin gaca lañih paascu, ");
INSERT INTO zpvNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ya caꞌngadxiꞌhyi raꞌ ba laꞌh Jesuhs, niꞌchin chin rii raꞌ ba laꞌn guidoꞌ gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Ta ruhnn tu lligaaba ziꞌ Jesuhs lañih o ayi dxiꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ya laꞌh raꞌ bwiinn fariseu raꞌ cun nin rnabwaꞌ loh raꞌ bixohza guñiꞌ raꞌ ba loh raꞌ bwiinn sidela chyuulla tuhbi bwiinn gwaꞌha laꞌh Jesuhs, guiñiꞌ raꞌ ba ca zuu Jesuhs tin guinaꞌzu raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Za xoꞌpa dxyih riaꞌdxyi lañih pascu chin gwah Jesuhs guihdxyi nin laa Betania, hasta nuu yihdzi Lásaro nin bacwaꞌhn Jesuhs loh guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ya riꞌchi gudahwxchihnee raꞌ ba laꞌh Jesuhs; Marta gudxiꞌzi guelwahw chi, ya Lásaro naa tuhbi bwiinn nin zohbayahwnee Jesuhs loh mweella, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ya chiꞌchi gucaꞌha María garoolda lihtru nsehchi nin xchiaꞌ nahxi, ya nsehchi chi rahca chaꞌyin cun nardu, nee lasahca duxan mweeyi rooꞌ, ya gudaꞌbi bin ñaaꞌ Jesuhs, ya seguihdu bacwihdzi bi ñaaꞌ Ñiꞌh cun dxyichyihca bi, ya hasta gaduhbi laꞌñuuꞌ chi guzaꞌbi bwih nahxi xteenn nsehchi zaꞌca chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ya chiꞌchi laꞌh Judas Iscariote lliiꞌn Simohn, naa tuhbi xpwiinn Ñiꞌh nee nin naa gahcaza nin dxiuꞌn ntriehgu laꞌh Jesuhs; rahbi ba squiiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Xixnaa ayi gudooꞌ perfume ca chohnna gaywaꞌh denariu tin ñicaꞌha raꞌ bwiinn prohbi mweeyi chi? (Chohnna gaywaꞌh chi naa ziga rahlla tuhbi bwiinn guunn ba dziꞌn tsiꞌh bituhbi bweꞌhw.) ");
INSERT INTO zpvNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per laꞌh Judas ayi guñiꞌ dxiꞌh ba dxyiꞌdxyi raꞌ riiꞌ, laasii ralahsa stoꞌ ba laꞌh raꞌ bwiinn prohbi, sino que naa ba tuhbi bwiinn gubaꞌn niꞌchin guñiꞌ ba ziꞌchi, nee pur nin nahpa ba cargu rwaꞌ ba buuxa nin riuuꞌchaꞌyi xmweeyi garaa raꞌ ba, ya laꞌh ba rbaaꞌn ba balaaquiꞌhn yihca mweeyi nin riuuꞌ laꞌn buuxa chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","niꞌchin nin rahbi Jesuhs: ―Basaaꞌn si bi, laasii nin cayuhnn bi naa xnehzan cagaꞌbi xgah bi nsehchi riiꞌ naꞌh par laꞌn dxyih nin guigaꞌtsiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ya ziga bwiinn prohbi raꞌ zibahannee tu laꞌh raꞌ ba par tuꞌpazi, ya naꞌh ayi para tuꞌpazi dxiꞌh sino que dxyih nagaaba si zeꞌldahn loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ya ziahan raꞌ bwiinn Israel bihn raꞌ ba nuu Jesuhs guihdxyi Betania, ya gwah raꞌ ba riꞌchi ayi tin zeguiaꞌha raꞌ dxiꞌh ba laꞌh Jesuhs, sino que nee gwaguiaꞌha raꞌ ba laꞌh Lásaro nin bacwaꞌhn Jesuhs loh guelguhchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ya chiꞌchi bwiꞌhnn raꞌ bixohza raꞌ nin rnabwaꞌ raꞌ lligaaba chiinn raꞌ ba nee laꞌh Lásaro, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","laasii pur laꞌh Lásaro ziahan raꞌ bwiinn Israel raꞌ cabweꞌhestoꞌ raꞌ ba laꞌh raꞌ bixohza nin rnabwaꞌ raꞌ mahs riachiistoꞌ raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ziahan raꞌ bwiinn raꞌ gwah para guihdxyi Jerusalehn tin gwah raꞌ ba lañih nin rahca riꞌchi, ya chin barah gueꞌla bihn raꞌ ba chee Jesuhs loh guihdxyi Jerusalehn, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","niꞌchin bachyuuꞌga raꞌ ba batahga raꞌ xteenn yahga zihn tin biriaꞌh raꞌ ba bagachiꞌloh raꞌ ba laꞌh Jesuhs, ya rahbi raꞌ ba jweersi rooꞌ: ―¡Gulguiñiꞌzaꞌca pur lah Dxiohs! ¡Bwiꞌhnntaaꞌyi Ñiꞌh yihca bwiinn nin zeꞌ pur xcweenta Ñiꞌh! ¡Bwiꞌhnntaaꞌyi Dxiohs yihca rrehyi raꞌ bwiinn Israel! ");
INSERT INTO zpvNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ya chiꞌchi bidxeela Jesuhs tuhbi buhrra bweezuꞌhn gudziiꞌba Ñiꞌh ziga caa loh Xchihtsi Dxiohs: ");
INSERT INTO zpvNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ayi guidxyihbi tu bwiinn nin nuu loh guihdxyi Siohn; gulguiaꞌha laꞌh xrrehyi tu zeꞌ dziꞌba tuhbi buhrra bweezu. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ya desde guzoꞌbalohon, ayi guhcabwaꞌ raꞌ xpwiinn Jesuhs dxyiꞌdxyi raꞌ riiꞌ, per chin babahn Ñiꞌh loh raꞌ bwiinnguuchi, chiꞌchi bagannahstoꞌ raꞌ ba garaa raꞌ dxyiꞌdxyi nin caa loh Xchihtsi Dxiohs pur laꞌh Ñiꞌh cun neezaa garaa raꞌ nin bwiꞌhnnee raꞌ bwiinn laꞌh Ñiꞌh tin guzohba raꞌ dxyiꞌdxyi chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ya bwiinn raꞌ nin zuunee laꞌh Jesuhs chin bacwaꞌhn Ñiꞌh laꞌh Lásaro loh guelguhchi, bwiiꞌyidxyiꞌdxyi raꞌ ba nin bwaꞌha raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","niꞌchin nin biriaꞌh raꞌ bwiinn tin bagadxiꞌhyi raꞌ ba laꞌh Jesuhs, laasii bihn raꞌ ba bwiꞌhnn Jesuhs tuhbi sehn rooꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ya chiꞌchi rahbi loh lasaaꞌ raꞌ bwiinn fariseu raꞌ: ―¿Gu rwaꞌha tu nnah ayi nuu xa guidiꞌhnn nuꞌh? Garaa raꞌ bwiinn zeenaꞌhla laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Loh raꞌ bwiinn nin zee raꞌ para guihdxyi Jerusalehn nin zee raꞌ lañih dxaꞌga raꞌ paaldaa raꞌ bwiinn griehgu raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bwiinn raꞌ riiꞌ gwabiiga raꞌ hasta zeꞌ Felipe, nin naa tuhbi bwiinn Betsaida loh guihdxyi Galilea, ya gunaaba raꞌ ba loh Felipe rahbi raꞌ ba: ―Daada, xclaaꞌdzi nu guidiaꞌha nu laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ya gwahguihtsi Felipen loh Andrehs, ya garoopa raꞌ ba gwahguihtsi raꞌ ban loh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ya chiꞌchi rahbi Jesuhs: ―Laꞌh hohra bigaꞌha tin guunn lasahca Dxiohs laꞌh Lliiꞌn Ñiꞌh nin naa Lliiꞌn ndxiꞌhw Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","pwihsi rñiꞌn loh tu, sidela laꞌh tuhbi bwiiꞌdzi trihgu dxiaaba loh yuh ya sidela ayi ñichilohon zeezah naan tuhbi dxiꞌh bwiiꞌdzi, per sidela laꞌhan ñichilohon loh yuh ya guitahnan rudiꞌhin jusehchi rooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bwiinn raꞌ nin rcaꞌhstoꞌ ru ñiꞌh xquelnabahan raꞌ ñiꞌh zuñihchi raꞌ ban, per laꞌh raꞌ bwiinn raꞌ nin rbweꞌhestoꞌ ñiꞌh xquelnabahan ñiꞌh loh guihdxyiyuh riiꞌ zicaꞌha ba guelnabahan nin ayi ñichilohtiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sidela chyuulla bwiinn xclaaꞌdzi dxieꞌnaꞌhla naꞌh, dxieꞌnaꞌhla ba naꞌh; ya hasta chuuꞌhuhn riꞌchi za chuu raꞌ bwiinn raꞌ nin dxieꞌnaꞌhla naꞌh, nee sidela laꞌh chyuulla bwiinn xclaaꞌdzi guunn xtsiꞌnaꞌhn, ziahxinee Xtaada Dxiohsaꞌhn laꞌh bwiinn chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Rahbi za Ñiꞌh: ―Yannah ziahan lligaaba nuuꞌhuhn; ¿xa gaꞌpihn? ¿Ta gaꞌpihn: “Paah, bataꞌh naꞌh loh raꞌ cohsa riiꞌ nnah”? Per naꞌh para niꞌchi zeꞌldahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Paah, bwiꞌhnn nin guunn lasahca ziga naa lah luꞌh. Ya chiꞌchi bihn raꞌ ba tuhbi rsiaaꞌha nez llaaꞌndxibaaꞌ nin rahbi: ―Laꞌn bwiꞌhnn lasahca la laan, per nicala guunn lasahcañin stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ya garaa raꞌ bwiinn raꞌ nin rii raꞌ riꞌchi rahbi raꞌ ba guziꞌw niꞌchi guñiꞌ, ya snuhn raꞌ ba rahbi: ―Guñiꞌ tuhbi xaanjla Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ya chiꞌchi rahbi Jesuhs: ―Ayi guhca dxyiꞌdxyi nin bihn tu pur xcweeꞌntahn, sino que pur xcweenta tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","yannah laꞌh hohra bigaꞌha dxiꞌh xquelguxchiisi Dxiohs loh guidxyiyuh riiꞌ, niꞌchin nnah zareꞌdxiaꞌhla bwiinn nin rnabwaꞌ loh guidxyiyuh riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","per naꞌh chin guiteesa raꞌ ba naꞌh loh guidxyiyuh riiꞌ, zutiaaꞌha gahcahn garaa raꞌ bwiinn loon. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ya cun garaa raꞌ dxyiꞌdxyi raꞌ riiꞌ guñiꞌ Ñiꞌh loh raꞌ ba xa gachi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ya chiꞌchi raꞌbi raꞌ bwiinn: ―Pwihsi loh lehyi bihn nu xa rñiꞌn laꞌh Crixtu ayi nahpa gachi Ñiꞌh nahpa zibahan Ñiꞌh para tuꞌpazi. ¿Xaalla rñiꞌ chiꞌh luꞌh, laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw nahpa guiteesa raꞌ ba laꞌh ba loh guidxyiyuh riiꞌ? ¿Cuun nin naa laꞌh Lliiꞌn Dxiohs nin naa ndxiꞌhw nin ruzeꞌta luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ya chiꞌchi rahbi Jesuhs: ―Laꞌh bwiinn nin naa biaꞌñih loh tu laꞌh ba nuu gahca loh tu, per za balaaquiꞌhn si nahpa tu biaꞌñih riiꞌ, niꞌchin gulsah loh biaꞌñih gaduhbi nin rziaꞌñihrun tin ayi sah tu loh nacahyi, laasii laꞌh bwiinn nin rzah loh nacahyi nin ayi gaann ba canehza guzee ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gulchechiistoꞌ tu biaꞌñih gaduhbi nin nuu gahca Ñiꞌh loh tu, tin gaca tu bwiinn nin luꞌh cwih loh biaꞌñih. Ya chin guyaꞌloh guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ loh raꞌ ba, zee chiꞌh Jesuhs stuhbi nehza tin guyuuꞌlaꞌn Ñiꞌh loh raꞌ bwiinn Israel raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ya nicala bwiꞌhnn Jesuhs ziahan sehn rooꞌ raꞌ loh raꞌ bwiinn Israel raꞌ per ayi gwachiistoꞌ raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","laasii nahpa guzohba dxyiꞌdxyi nin bacaꞌh guehtu Isaías chin bacaꞌh ba squiiꞌ: Daada, ¿chyu bwiinn gwachiistoꞌ ñiꞌh xchiꞌdxyi nuꞌh, nee chyuloo baluuꞌyiloh xquelrnabwaꞌ Daada Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pwihsi ayi guhcabwaꞌ raꞌ ba tin ñachiistoꞌ raꞌ ba, pwihsi neezaa bacaꞌh guehtu Isaías squiiꞌ: ");
INSERT INTO zpvNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dxiohs bwiꞌhnn dxieꞌpa laꞌh tu, nee cun bwiꞌhnn dxiipa za Ñiꞌh stoꞌ tu tin ayi dxiinn loh tu nee nin ayi za gacabwaꞌ stoꞌ tu, nee nin ayi za guibiaꞌgarii tu loon tin gusiaꞌcahn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Guñiꞌ Isaías dxyiꞌdxyi raꞌ riiꞌ laasii bwaꞌha ba llaꞌñih xteenn Jesuhs, nee guñiꞌ za ba pur laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ya ziꞌchi ziahan raꞌ za bwiinn Israel raꞌ gwachiistoꞌ raꞌ ba laꞌh Jesuhs, hasta bwiinn raꞌ nin lasahca loh raꞌ ba gwachiistoꞌ raꞌ ba laꞌhÑiꞌh, per ayi guñiꞌ raꞌ ban loh raꞌ bwiinn laasii pur laꞌh raꞌ bwiinn fariseu raꞌ tin ayi ñabweꞌhedxiaꞌhla raꞌ ba laꞌh raꞌ ba laꞌn guidoꞌ biꞌtuꞌhn raꞌ bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","nee neezaa pur mahzi riuuꞌstoꞌ raꞌ ba guiñiꞌ zaꞌca raꞌ bwiinn pur xcweenta raꞌ ba xlawaaꞌha ñidxiꞌhyi raꞌ ba guiñiꞌ zaꞌca Dxiohs gahca pur laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ya chiꞌchi guñiꞌ Jesuhs jweersirooꞌ, rahbi Ñiꞌh: ―Bwiinn nin riachiistoꞌ raꞌ ñiꞌh naꞌh, ayi naꞌh si dxiꞌh riachiistoꞌ raꞌ ba sino que nee laꞌh Daada Dxiohs nin guluꞌnehza naꞌh riachiistoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ziꞌchi bwiinn raꞌ nin rwaꞌha raꞌ naꞌh rwaꞌha za raꞌ ba laꞌh Daada Dxiohs nin guluꞌnehza naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","pwihsi naꞌh ziga naan biaꞌñih loh guidxyiyuh riiꞌ, zeꞌldahn tin garaa raꞌ bwiinn raꞌ nin chechiistoꞌ raꞌ ñiꞌh naꞌh ayi dxiaꞌhan raꞌ ba loh nacahyi, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","per sidela nuu raꞌ bwiinn nin rihn raꞌ xchiꞌdxyiꞌhn nee ayi ruzoꞌbadxiahga raꞌ ban, ayi naꞌh dxiꞌhn nin gusiaꞌhbaꞌhn laꞌh ba loh duhlda, laasii naꞌh ayi zeꞌldahn tin gusiaꞌbaꞌhn bwiinn loh duhlda sino que tin gutaꞌhn laꞌh raꞌ bwiinn loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bwiinn nin ayi ruzoꞌbadxiahga xchiꞌdxyi raꞌn, nahpa ba nin guunn guelguxchisi xtuhlda ba; dxyiꞌdxyi gahca raꞌ nin cañiꞌn riiꞌ naa nin guunn guelguxchisi xtuhlda raꞌ ba loh dxyih nin gaca jwisi, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","laasii naꞌh ayi rñiꞌn pur xcweenta gahcahn; Daada Dxiohs nin guluꞌnehza naꞌh gunabwaꞌ ba naꞌh xa guiñiꞌn nee xa guluꞌyiꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","nee naꞌnnahn dxyiꞌdxyi nin rnabwaꞌ Xtaada Dxiohsaꞌhn zeꞌneen guelnabahan nin ayi ñichilohtiiꞌ para laꞌh raꞌ bwiinn nin riachiistoꞌñin, pwihsi ziga rñiꞌn loh tu, rñiꞌñin loh tu ziga gunabwaꞌ Daada Dxiohs guiñiꞌñin loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Chin nagahdxi gadzihn dxyih nin gaca lañih paascu, laꞌh Jesuhs guhcabwaꞌ laꞌh hohra bigaꞌha gusaaꞌn Ñiꞌh loh guidxyiyuh tin gacah Ñiꞌh llaaꞌndxibaaꞌ nez loh Xtaada Ñiꞌh. LaꞌhÑiꞌh gwazah bacaꞌhstoꞌ Ñiꞌh laꞌh raꞌ xpwiinn Ñiꞌh nin rii loh guidxyiyuh, bacaꞌhstoꞌ Ñiꞌh laꞌh raꞌ ba para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ya loh cayahw xchihnee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh, neezaa Judas Iscariote lliiꞌn Simohn zohba riꞌchi, ya Judas laꞌh bwiinndxaaba guyuuꞌtii la stoꞌ Judas nuu ba lligaaba guunn ba ntriehgu laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ya ziga naann Jesuhs ya batiꞌdxi Xtaada Dxiohs Ñiꞌh guelrnabwaꞌ xteenn garaa raꞌ cohsa loh naa Ñiꞌh; laasii zeꞌ Ñiꞌh nez nuu Dxiohs nee hasta nuu za Dxiohs guziaa Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ya chiꞌchi gwasuꞌnchii Ñiꞌh hasta riiyahw xchihnee raꞌ xpwiinn Ñiꞌh laꞌh Ñiꞌh, ya chiꞌchi guleꞌhe Ñiꞌh lahdxi maanta nin naa xcahpa Ñiꞌh, chiꞌchi gucaꞌha Ñiꞌh tuhbi twahlli bazaꞌbi Ñiꞌh loh duꞌh nin nuu laꞌn tihxi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","chiꞌchi gudaꞌh Ñiꞌh nuhn ñihsa laꞌn tuhbi bandeja, ya chiꞌchi guzohbaloh cadxiꞌbi Ñiꞌh ñaaꞌ raꞌ xpwiinn Ñiꞌh, ya cun twahlli chi bacwihdzi Ñiꞌh ñaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ya loh ñidxiꞌbi Jesuhs ñaaꞌ Simohn Pehdru, rahbi ba squiiꞌ: ―Daada, ¿ta yiꞌh chiꞌbi luꞌh ñaaꞌhahn? ");
INSERT INTO zpvNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chiꞌchi rahbi Jesuhs: ―Nnah ayi rahcabwaꞌ luꞌh cuun nin cayuꞌnnahn, per guillii-yihdxyii zahcabwaꞌ luꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chiꞌchi rahbi Pehdru: ―¡Lliaaꞌhzi ayi guniꞌhihn ñaaꞌhahn chiꞌbi luꞌh! Chiꞌchi rahbi Jesuhs: ―Sidela naꞌh ayi chiꞌbiꞌhn ñaaꞌ luꞌh ayi naa luꞌh xpwiiꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chiꞌchi rahbi Simohn Pehdru loh Jesuhs: ―¡Pwihsi Daada, ayi chiꞌbi luꞌh ñaaꞌ sihn sino que nee yiꞌcahn cun naaꞌhahn! ");
INSERT INTO zpvNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ya chiꞌchi rahbi Jesuhs: ―Bwiinn nin gueꞌdu guhza ayi xchiꞌhn dxiaa gaduhbi tihxi ba, sola dxiaa ñaaꞌ si ba, laasii gaduhbi tihxi ba nayaa. Ya laꞌh tu nayaa tu, nicala ayi garaa dxiꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Guñiꞌ Ñiꞌh ayi guinayaa garaa raꞌ ba, laasii ba naann Ñiꞌh cuun nin guun ntriehgu laꞌh Ñiꞌh loh raꞌ bwiinn duhlda raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ya chin guyaꞌloh gudxiꞌbi Jesuhs ñaaꞌ raꞌ xpwiinn Ñiꞌh, chiꞌchi guhta gahca Ñiꞌh xahba Ñiꞌh nin naa xcahpa Ñiꞌh, ya tin guzohba laꞌgah Ñiꞌh hasta zuu mwella, chiꞌchi rahbi Ñiꞌh: ―¿Gu rahcabwaꞌ tu nin bwiꞌhnnaꞌhn riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Laꞌh tu rñiꞌ tu naꞌh “Mwehsu” cun “Daada”, nee xnehza rñiꞌ tu, laasii naan ziꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pwihsi sidela naꞌh nicala naan Mwehsu cun Daada, per gudxiꞌbiꞌhn ñaaꞌ tu; neezaa laꞌh tu rgaꞌha chiꞌbi tu ñaaꞌ lasaaꞌ tu ziga tuhbi ziga stuhbi tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naꞌh cagaluꞌyiꞌhn laꞌh tu xa guunn tu, tin guunn za tu ziga bwiꞌhnnaꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nee guchiin nin rñiꞌn loh tu, nin tuhbi mooza ayi lasahca ru ba loh nin naa xballwaꞌn ba, nee nin tuhbi za bwiinn nin riah mandahdu ayi lasahca ru ba loh nin rguꞌnehza laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sidela laꞌh tu naann tu dxyiꞌdxyi raꞌ riiꞌ nee guunn tun, dichohsa tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ayi cañiꞌn xcweenta garaa tu; cañiꞌn loh si raꞌ nin guliin, per nahpa soobaa dxyiꞌdxyi nin caa loh Xchihtsi Dxiohs: “Bwiinn nin rahwnee naꞌh pahn, laꞌh bwiinn chi rwaꞌha llahn loon.” ");
INSERT INTO zpvNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Deeꞌ rñiꞌn loh tu tin chin gaca raꞌ cohsa raꞌ riiꞌ, laꞌh tu chechiistoꞌ tu naꞌh naan nin naan. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Guchiin nin rñiꞌn loh tu bwiinn nin riuuꞌ-riaꞌzi xchiꞌdxyi bwiinn nin cuꞌneezahn, neezaa xchiꞌdxyiꞌhn riuuꞌ ba riaꞌzi ba, cun riuuꞌ za ba riaꞌzi za ba xchiꞌdxyi bwiinn nin guluꞌnehza naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ya chin guyaꞌloh guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ, guhca nalasa duxa stoꞌ Jesuhs, ya gudxixteeꞌ Ñiꞌh rahbi Ñiꞌh: ―Guchiin nin rñiꞌn loh tu, tuhbi gahca tu dxiuꞌn ntriehgu naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ya chiꞌchi guzoꞌbaloh rwaꞌha loh lasaaꞌ raꞌ xpwiinn Ñiꞌh, ya nin ayi rahcabwaꞌ raꞌ ba chyu tuhbi raꞌ ba cazeꞌta Jesuhs xcweenta ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ya tuhbi xpwiinn Ñiꞌh nin nadziiꞌhi ru Ñiꞌh zohbayahw xchih gahxu hasta zohba Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ya bwiꞌhnn Simohn Pehdru sehn loh niꞌchi tin guinaabadxyiꞌdxyi niꞌchi chyu tuhbi raꞌ ba naa nin cazeꞌta Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ya chiꞌchi gwabiiga ru xpwiinn Ñiꞌh chi, tin rahbi ba loh Jesuhs: ―Daada, ¿chyuñin? ");
INSERT INTO zpvNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chiꞌchi rahbi Jesuhs: ―Laꞌn gugaadxyii tahyi pahn, ya nin gudiꞌhihn pahn riiꞌ niꞌchin. Ya seguihdu bagahdxyi Ñiꞌh pahn chi chiꞌchi badiꞌhi Ñiꞌhn laꞌh Judas, lliiꞌn Simohn Iscariote. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ya loh nin gudahw Judas pahn chi, hohrachi guyuuꞌtii bwiinndxaaba stoꞌ Judas, chiꞌchi rahbi Jesuhs loh Judas: ―Nin xclaaꞌdzi luꞌh guunn luꞌh bwiꞌhnnan lwehgu gahca. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per nin tuhbi raꞌ xpwiinn Ñiꞌh nin cayahw xchih raꞌ loh mweella ayi guhcabwaꞌ raꞌ ba xinaa guñiꞌ Ñiꞌh ziꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ya coma laꞌh Judas ruꞌa xpuhxa mweeyi raꞌ ba, niꞌchin bwiꞌhnn raꞌ ba lligaaba rahbi Jesuhs siꞌ ru Judas guelwahw para dxyih lañih, o gudiꞌhi ba mweeyi guhn laꞌh raꞌ bwiinn prohbi, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ya loh nin guyaꞌloh gudahw Judas pahn chi, hohrachi gahca biriaꞌh ba, ya gueꞌla la hohra chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Biriaꞌh si Judas, chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh: ―Nnahyi ziinloh xa gaca lasahca Lliiꞌn Dxiohs nin naa ndxiꞌhw, ya ziinloh za xa gaca lasahca Dxiohs pur xcweenta Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ya sidela laꞌh Lliiꞌn Dxiohs guunn lasahca lah Dxiohs, neezaa Dxiohs zuhnn lasahca Ñiꞌh lah Lliiꞌn Ñiꞌh; nee zuhnn Ñiꞌhn lwehgu. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Lliiꞌn raꞌn ayi chuuneeruhn laꞌh tu xchih ru; laꞌh tu zadxiꞌhyi tu naꞌh per ziga gahca guñiꞌn loh raꞌ bwiinn Israel raꞌ rñiꞌn loh tu nnah: ayi nuu chee tu hasta chaaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Rñiꞌn dxyiꞌdxyi cuubi nin rnabwaꞌn guunn tu: Gantsiiꞌhi lasaaꞌ tu ziga tuhbi ziga stuhbi tu. Ziga nadziiꞌhizahn laꞌh tu, ziꞌchi za gantsiiꞌhi lasaaꞌ tu ziga tuhbi tu ziga stuhbi tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sidela gantsiiꞌhi tu lasaaꞌ tu ziga tuhbi ziga stuhbi tu, garaa raꞌ bwiinn guidxyiyuh gudiꞌhi cweenta naa tu xpwiiꞌnraꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simohn Pehdru gunaabadxyiꞌdxyi loh Jesuhs, rahbi ba: ―¿Ca nehza guzee luꞌh? ―Hasta guzaaꞌhahn, ―rahbi Jesuhs― ayi dxieꞌnaꞌhla luꞌh naꞌh, per zadzihn dxyih zieꞌnaꞌhla luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chiꞌchi rahbi Pehdru: ―Daada, ¿xixnaa ayi dxieꞌldanaꞌhlaꞌhn yiꞌh nnah? ¡Nicala gudiꞌhihn xquelnabahnahn pur yuꞌbiluꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chiꞌchi rahbi Jesuhs: ―¿Ta guchii luꞌh zudiꞌhi xquelnabahan luꞌh pur naꞌh? Pwihsi rñiꞌn loh luꞌh galoh nin gucaꞌhyahn dxiidxinguhla, ziñiꞌ luꞌh chohnna bweelta ayi nuꞌnbwaꞌtiiꞌ luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Ayi guunn chiohpa stoꞌ tu; gulchechistoꞌ tu xchiꞌdxyi Dxiohs nee gulchechii za stoꞌ tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nez hasta naa yihdzi xtaaꞌdahn ziahan yuuꞌ nuu riꞌchi para chuu tu, laasii sidela ayi ñahca ziꞌchi ayi ñiñiꞌn loh tu laꞌn guzaaꞌha tin guunn chaꞌyi yuuꞌ raꞌ hasta chuu tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ya galoo nin baguziaaꞌhahn nez nuu Xtaaꞌdahn nee chin baguyaꞌloh bwiꞌhnnchaꞌyiꞌhn nez chuu tu zieꞌldahn stuhbi tin cheneꞌhn laꞌh tu riꞌchi, tin chuu tu nez chuuꞌhuhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Laꞌh tu ya naann tu neziuh nin zee nez guzaaꞌhahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chiꞌchi rahbi Tomahs loh Jesuhs: ―Daada, ayi chyu gaann canehza guzee luꞌh; ¿xa gacabwaꞌ nu cuun nin naa neziuh chi? ");
INSERT INTO zpvNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chiꞌchi rahbi Jesuhs: ―Naꞌh naan neziuh, cun dxyiꞌdxyi nin naa guchii nee cun neezaa guelnabahan; niꞌchin pur naꞌh dxiꞌh zahca gadzihn tu nez nuu Daada Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sidela laꞌh tu nuꞌnbwaꞌ tu naꞌh, neezaa laꞌh Xtaaꞌdahn ziuꞌnbwaꞌ za tu; ya laꞌh tu biuꞌnbwaꞌ laꞌh Ñiꞌh desde nnah, pwihsi laꞌhtu ba bwaꞌha tu laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ya chiꞌchi rahbi Felipe loh Ñiꞌh: ―Daada, basaaꞌn guidiaꞌha nu laꞌh Daada Dxiohs, ya cun niꞌchi ayi xi rchiꞌhn ru. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chiꞌchi rahbi Jesuhs: ―Felipe, guhca cadxyihrooꞌ dxaꞌgaꞌhn loh tu, nee ¿ta nagahdxi dxiuꞌnbwaꞌ luꞌh naꞌh? Bwiinn nin rwaꞌha naꞌh rwaꞌha za ba laꞌh Xtaaꞌdahn. ¿Xixnaa rnaaba luꞌh gusaꞌnaꞌhn gwaꞌha luꞌh laꞌh Daada Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tayi riachiistoꞌ luꞌh naꞌh nuuꞌhuhn tuhsi cun laꞌh Daada Dxiohs ya laꞌh Daada Dxiohs nuu tuhsi cun naꞌh? Dxyiꞌdxyi raꞌ nin rñiꞌn loh tu ayi rñiꞌñin pur xcweenta gahcan, sino que Daada Dxiohs nin nuu tuhsi cun naꞌh laꞌh Ñiꞌh ruhnn Ñiꞌh xcweenta xtsiꞌn gahca Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gulchechiistoꞌ tu xchiꞌdxyiꞌhn nuuꞌhuhn tuhsi cun laꞌh Dxiohs ya laꞌh Daada Dxiohs nuu za Ñiꞌh tuhsi cun naꞌh; niꞌchin gulchechiistoꞌ tu xcweenta nin ruhnn raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","pwihsi guchiin nin rñiꞌn loh tu naꞌpahn siguhra bwiinn nin riachiistoꞌ ñiꞌh naꞌh zuhnn za ba dziꞌn raꞌ nin ruꞌnnahn; nee zuhnn za ba dziꞌn roo ru raꞌ laasii naꞌh guzaaꞌhahn nez nuu Xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ya garaa nin guinaaba tu pur laan, naꞌh zuniꞌhiñin laꞌh tu tin ziꞌchi gaca lasahca lah Xtaaꞌdahn pur Lliiꞌn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Naꞌh zuꞌnnahn xiꞌchiꞌzi nin guinaaba tu pur laan. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Rahbi za Ñiꞌh: ―Sidela laꞌh tu rucaꞌhstoꞌ tu naꞌh, guzoꞌbadxiahga tu xchiꞌdxyiraꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ya naꞌh zinaꞌbaꞌhn loh Xtaaꞌdahn tin cuꞌnehza ba stuhbi nin gacanee cun nin gusiahxi laꞌh tu, tin chuunee Spíritu chi laꞌh tu para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Naꞌh cagazeꞌtaꞌhn Spíritu nin rñiꞌ ganaalla dxyiꞌdxyi guchii, nee naa Ñiꞌh Spíritu Saantu Dxiohs, ya nin naa raꞌ bwiinn guidxyiyuh ayi nuu guicaꞌha raꞌ ba Ñiꞌh laasii ayi rwaꞌha raꞌ ba niꞌchi nee ayiza nuꞌnbwaꞌ raꞌ ba laꞌh Ñiꞌh; per laꞌh tu nuꞌnbwaꞌ tu Ñiꞌh laasii nuunee Ñiꞌh laꞌh tu nee rbweeza Ñiꞌh laꞌn lastoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ayi gusiaꞌnaꞌhn laꞌh tu zigazi bizahbi raꞌ, sino que zibiaꞌgariin tin chuuneen laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yannah za balaaquiꞌhn bwiinn nin naa raꞌ xteenn loh guidxyiyuh ayi ru gwaꞌha raꞌ ba naꞌh; per laꞌh tu zwaꞌha gahca tu naꞌh nee zibahan za tu laasii naꞌh banabahanzahn, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ya laꞌn dxyih raꞌ chi laꞌh tu zudiꞌhi tu cweenta naꞌh nuuꞌhuhn tuhsi cun laꞌh Xtaaꞌdahn, ya laꞌh tu nuu tu tuhsi cun naꞌh, ya naꞌh tuhsi nuuꞌhuhn cun laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bwiinn nin nahpa xchiꞌdxyiraꞌn, nee ruzoꞌbadxiahga raꞌ ban, pwihsi guchii bwiinn chi rucaꞌhstoꞌ ba naꞌh; ya laꞌh Xtaaꞌdahn zucaꞌh za stoꞌ ba laꞌh bwiinn nin gucaꞌhstoꞌ ñiꞌh naꞌh, nee naꞌh za zucaꞌhstoꞌn laꞌh ba nee zuluuꞌyilohzahn loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (ayi Judas Iscariote dxiꞌh sino que stuhbi Judas) gunaabadxyiꞌdxyi loh Jesuhs, rahbi ba: ―Daada, ¿xixnaa guluuꞌyiloh luꞌh loh nu nee ayi loh raꞌ dxiꞌh bwiinn guidxyiyuh? ");
INSERT INTO zpvNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chiꞌchi rahbi Jesuhs: ―Bwiinn nin rucaꞌhstoꞌ ñiꞌh naꞌh, bwiinn chi ruzoꞌbadxiahga xchiꞌdxyiꞌhn, nee zucaꞌhstoꞌ Xtaaꞌdahn laꞌh ba. Ya Xtaaꞌdahn cun naꞌh zibahannee nu laꞌh bwiinn chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ya bwiinn nin ayi rucaꞌhstoꞌ ñiꞌh naꞌh ayiza ruzoꞌbadxiahga ba xchiꞌdxyiꞌhn. Dxyiꞌdxyi raꞌ nin cañiꞌn loh tu riiꞌ, ayi naa raꞌn xchiꞌdxyi gahcahn, sino que xchiꞌdxyi Xtaaꞌdahn nin guluꞌnehza naꞌh loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cañiꞌn garaa raꞌ dxyiꞌdxyi raꞌ riiꞌ loh tu gaduhbi nin nuuneen laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per laꞌh nin rahcanee, o sea Spíritu Saantu nin cuꞌnehza Xtaaꞌdahn pura laꞌh tu pur laan, zuluuꞌyi Ñiꞌh laꞌh tu garaa raꞌ cohsa cun zusazaꞌza Spíritu Saantu chi stoꞌ tu garaa raꞌ dxyiꞌdxyi nin cañiꞌn loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ya loh nin guziaaꞌhahn rusiaꞌhanahn guelrbwihdxyii stoꞌ para laꞌh tu; runiꞌhihn guelrbwihdxyii stoꞌ riiꞌ nin naa xteꞌnnahn laꞌh tu, per nin guniꞌhihn laꞌh tu ayi naan ziga nin rudiꞌhi raꞌ bwiinn guidxyiyuh. Ayi guunn tu ziahan lligaaba, nee ayiza guidxyihbi tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ba bihn tu laꞌn guñiꞌn ziaaꞌhahn per zieꞌldahn tin chuuneen laꞌh tu. Sidela guchii tu rucaꞌhstoꞌ tu naꞌh, ziahxi tu chin dxihn tu guziaaꞌhahn nez nuu Xtaaꞌdahn dxibaaꞌ, laasii laꞌh Ñiꞌh lasahcaru Ñiꞌh loon. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Rñiꞌn dxyiꞌdxyi raꞌ rii loh tu tin chin gariaꞌhcaaꞌhan, chiꞌchi chechiistoꞌ tu xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ayiru guiñiꞌn ziahan dxyiꞌdxyi loh tu, laasii laꞌh nin rnabwaꞌ loh guidxyiyuh rii zeꞌ, nicala ayi xi guelrnabwaꞌ nahpa ba cun naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Per nahpa ziꞌchi gaca, tin ziꞌchi gacabwaꞌ raꞌ bwiinn guidxyiyuh rucaꞌhstoꞌn laꞌh Xtaaꞌdahn nee ruzoꞌbadxiahgahn garaa raꞌ xchiꞌdxyi Ñiꞌh nin nahpa guꞌnnahn. Gulchesuꞌnchii tin gulchoꞌho gabii nuꞌh riiꞌ ―rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ya chiꞌchi rahbi Jesuhs: ―Naꞌh naan yahga uhva nin guchii, ya laꞌh Xtaaꞌdahn naa ziga nin ruhnn biñih yahga uhva chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ya xpwiꞌnnraꞌn naa raꞌ ba ziga lliiꞌdzi yahga chi, ya sidela laꞌh tuhbi lliiꞌdzihn ayi guicah uhva, zuchyuuꞌga Xtaaꞌdañin; per sidela guicah uhvan zusiaa ban tin guicahru ziahan uhva lohon. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ya laꞌh tu banayaa tu pur dxyiꞌdxyi raꞌ nin laꞌnguñiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Guldxiaꞌhannee naꞌh tuhsi juunta, ziga riaꞌhaneen laꞌh tu tuhsi. Tuhbi lliiꞌdzi yahga ayi nuu gudiꞌhin uhva pur laꞌhgahcan, sino que dxiꞌdxiun tihxi yahga truunga nin naa llaaꞌnan. Pwihsi ziꞌchi za laꞌh tu ayi nuu guunn tu xtsiꞌnaꞌhn sidela ayi nuunee tu naꞌh tuhsi. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Rahbi za Ñiꞌh: ―Naꞌh naan llaaꞌn ziga yahga uhva, ya laꞌh tu naa tu ziga lliiꞌdzi yahga uhva chi. Bwiinn nin dxiaꞌhannee naꞌh tuhsi, dxiaꞌhannee zahn laꞌh bwiinn chi, ya ziꞌchi ruhnn duxa ba xtsiꞌnaꞌhn, laasii sidela guiriaꞌhcaa tu nez loon ayi nuu za xa guunn tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bwiinn nin ayi dxiaꞌhannee naꞌh tuhsi, ziriaꞌcaa ba tuhbi lahdu, ya zibihdzi ba ziga rbihdzi tuhbi lliiꞌdzi yahga ya lwehgu rcaꞌdxih raꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ya sidela laꞌh tu dxiaꞌhannee tu naꞌh gaduhbistoꞌ tu, nee sidela chuu paꞌca tu chaꞌzi tu xchiꞌdxyiꞌhn, gulguinaaba nin chiꞌh zi xclaaꞌdzi tu nee zicaꞌha tun. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chin ruhnn paꞌca tu xtsiꞌn Dxiohs, chiꞌchi gwaꞌha raꞌ bwiinn naa tu xpwiiꞌnraꞌn, nee ziñiꞌ zaꞌca raꞌ ba lah Xtaaꞌdahn nin nuu dxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Naꞌh rucaꞌstoꞌn laꞌh tu ziga rucaꞌstoꞌ Xtaaꞌdahn naꞌh, pwihsi gulchezahnee xcweenta ziga nadziiꞌhihn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sidela laꞌh tu ruzoꞌbadxiahga tu xchiꞌdxyiꞌhn, ziazah gucaꞌstoꞌn laꞌh tu zigaza ruzoꞌbadxiaagahn xchiꞌdxyi Xtaaꞌdahn, nee cun zigaza zeezah rucaꞌstoꞌ Ñiꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Rñiꞌn squiiꞌ loh tu tin dxiahxinee tu naꞌh, tin ziꞌchi ayi xi dxiaꞌdxi loh guelriahxi nin gaapa tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nin rñiꞌn loh tu guunn tu: Gantsiiꞌhi lasaaꞌ tu ziga tuhbi tu cun ziga stuhbi tu; ziga nadziiꞌhizahn laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Guelnadziiꞌhi nin mahzi lasahca naa gudiꞌhi bwiinn xquelnabahan ba pur nin naa raꞌ xamihgu ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Laꞌh tu naa tu xamihgu raꞌn sidela guunn tu nin rnabwaꞌn guunn tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayiru guiñiꞌn loh tu mooza raꞌ, laasii mooza nin ayi gaann xi ruhnn xballwaꞌn ba. Niꞌchin mahs guiñiꞌn loh tu mihgu raꞌ, laasii baluꞌyiꞌhn laꞌh tu garaa nin guñiꞌ Xtaaꞌdahn loon. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ayi laꞌh dxiꞌh tu gulii tu naꞌh sino que naꞌh guliin laꞌh tu nee rñiꞌn loh tu nahpa chee tu tin guunn duxa tu xtsiꞌn Xtaaꞌdahn, nee ayi ñichiloh dziꞌn chi, ya ziꞌchi zuniꞌhi Xtaaꞌdahn garaa nin guinaaba tu pur laan. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pwihsi dxyiꞌdxyi raꞌ riiꞌ nin rñiꞌn loh tu guunn tun: Gantsiiꞌhi lasaaꞌ tu ziga tuhbi, ziga stuhbi tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Sidela laꞌh raꞌ bwiinn guidxyiyuh guidxyiꞌchinee laꞌh tu, gulgacabwaꞌ galoh naꞌh bidxyiꞌchinee raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sidela laꞌh tu ñahca tu tuhsi cun bwiinn guidxyiyuh, ñantsiiꞌhi raꞌ ba laꞌh tu ziga nadziiꞌhi raꞌ ba nin naa raꞌ xpwiinn raꞌ ba, per nnah naꞌh guliin laꞌh tu loh raꞌ bwiinn raꞌ nin naa raꞌ bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gulgasannah stoꞌ tu dxyiꞌdxyi raꞌ nin guñiꞌn loh tu: “Nin tuhbi mooza ayi lasahca ru ba loh xballwaꞌn ba.” Sidela naꞌh caꞌhnaꞌhla raꞌ ba tin chiinn raꞌ ba naꞌh, neezaa laꞌh tu guicaꞌhnaꞌhla raꞌ ba; ya sidela laꞌh raꞌ ba bazoꞌbadxiahga raꞌ ba xchiꞌdxyiꞌhn, neezaa xchiꞌdxyi tu zuzoꞌbadxiahga raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Garaa raꞌ deeꞌ zuhnnee raꞌ ban laꞌh tu pur xcweeꞌntahn, laasii ayi nuꞌnbwaꞌ raꞌ ba nin guluꞌnehza naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ayi ñahpa raꞌ ba nin tuhbi duhlda sidela naꞌh ayi ñieꞌldagañiꞌn loh raꞌ ba, per nnah ayi nuu guiñiꞌ raꞌ ba ayi guhcabwaꞌ raꞌ ba nuu xtuhlda raꞌ ba; ");
INSERT INTO zpvNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","pwihsi garaa raꞌ bwiinn raꞌ nin rdxyiꞌchinee naꞌh, rdxyiꞌchinee za raꞌ ba laꞌh Xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ayi xi duhlda ñahpa raꞌ ba sidela naꞌh ayi ñuꞌnnahn dziꞌn raꞌ nin ayi nin tuhbi bwiinn nin gaca guunn raꞌ dziꞌn raꞌ chi. Per laꞌh raꞌ ba bwaꞌha raꞌ ba dziꞌn raꞌ riiꞌ, ya pur dziꞌn raꞌ riiꞌ rdxyiꞌchinee raꞌ ba naꞌh nee rdxyiꞌchinee za raꞌ ba laꞌh Xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cayahca raꞌ deeꞌ tin soobaa dxyiꞌdxyi nin caa loh xlehyi raꞌ ba: “Bidxyiꞌchinee raꞌ ba naꞌh nicala ayi xi xtuꞌldahn.” ");
INSERT INTO zpvNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Per chin dxiꞌ Spíritu Saantu nin gacanee laꞌh tu, laꞌh Ñiꞌh ziñiꞌ pur xcweeꞌntahn chyu naan. Laꞌh Ñiꞌh naa nin nuu loh Xtaaꞌdahn, nee ziñiꞌ Ñiꞌh dxyiꞌdxyi nanchii, nee naꞌh zuxeꞌhlaꞌhn Ñiꞌh loh tu ya loh Xtaaꞌdahn guiriaꞌha Ñiꞌh dxiꞌ Ñiꞌh loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ya neezaa laꞌh tu ziñiꞌ tu dxyiꞌdxyi xcweeꞌntahn laasii nee tu caywaꞌha tu nee nuunee tu naꞌh desde chin guzoꞌbalohyin cagaluꞌyiꞌhn dxyiꞌdxyi raꞌ riiꞌ. Rahbi za Ñiꞌh: ");
INSERT INTO zpvNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","―Rñiꞌxgaꞌhn dxyiꞌdxyi raꞌ riiꞌ loh tu tin luꞌh ayi guñihchi tu ziga riachiistoꞌ tu naꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","laasii zadzihn dxyih nin zibweꞌhedxiaꞌhla raꞌ ba laꞌh tu laꞌn guidoꞌrooꞌ guihdxyi Jerusalehn nee zadzihn za hohra chin luꞌh, chyuchiꞌzi bwiinn nin chiinn laꞌh tu, zuhnn raꞌ ba lligaaba nalluꞌyi ziga guunn raꞌ ba chi nez loh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ziꞌchi guunnee raꞌ ba laꞌh tu laasii ayi nuꞌnbwaꞌ raꞌ ba laꞌh Xtaaꞌdahn nee nin naꞌh za ayi nuꞌnbwaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Rñiꞌn dxyiꞌdxyi raꞌ riiꞌ loh tu tin luꞌh chin gadzihn hohra chi dxiagannastoꞌ tu laꞌn guñiꞌla dxyiꞌdxyi raꞌ riiꞌ loh tu. Rahbi za Ñiꞌh: ―Ayi guñiꞌn dxyiꞌdxyi raꞌ riiꞌ loh tu desde galoh laasii naꞌh nuuneen laꞌh tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","per nnah ziaaꞌhahn dxibaaꞌ tin chuneen laꞌh Xtaaꞌdahn nin guluꞌnehza naꞌh loh guidxyiyuh riiꞌ, ya nin tuhbi tu ayi guinaabadxyiꞌdxyi ca nehza guzaaꞌhahn, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","laasii nuu guelnalaasa stoꞌ tu nee laasii guñiꞌn dxyiꞌdxyi raꞌ riiꞌ loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","per guchii dxyiꞌdxyi raꞌ riiꞌ nin cañiꞌn loh tu naa bwen para laꞌh tu guzaaꞌhahn, laasii sidela naꞌh ayi guzaaꞌhahn, ayi dxiꞌ Spíritu Saantu para laꞌh tu, per sidela naꞌh guzaaꞌhahn ziguꞌneehzahn Spíritu Saantu para laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chin dxiꞌ Spíritu Saantu, zuluuꞌyi Ñiꞌh laꞌh raꞌ bwiinn guidxyiyuh cuun nin naa duhlda, nee cuun nin naa guelnabahan nayaa, nee neezaa cuun xa naa xquelguxchisi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ya ziga xcweenta duhlda chi guluuꞌyi Ñiꞌh ayi riachiistoꞌ raꞌ ba naꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ya ziga xcweenta guelnabahan nayaa guluuꞌyi Ñiꞌh ayi xi xtuꞌldahn niꞌchin nin guzaaꞌhahn nez nuu Xtaada Dxiohsaꞌhn ya ayi gwaꞌha tu naꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ya ziga xcweenta guelguxchisi guluuꞌyi Spíritu Saantu laꞌXtaaꞌdahn bwiꞌhnn guelguxchisi laꞌh bwiinndxaaba nin rnabwaꞌ loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Rahbi za Ñiꞌh: ―Ziahanru dxyiꞌdxyi raꞌ nin naꞌpa guiñiꞌn loh tu per ayi gacabwaꞌ tun, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","per chin dxiꞌ Spíritu Saantu, zuluuꞌyi Ñiꞌh laꞌh tu garaa raꞌ nin naa ganaalla dxyiꞌdxyi guchii, laasii ayi guiñiꞌ Spíritu Saantu pur xcwenta gahca Ñiꞌh, sino que ziñiꞌ Ñiꞌh nin dxihn Ñiꞌh nee zusadxihn za Ñiꞌh laꞌh tu, tin gacabwaꞌ tu cohsa raꞌ nin gueꞌdu gaca. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Laꞌh Spíritu Saantu chi guunn lasahca naꞌh, laasii zicaꞌha Ñiꞌh nin naa xteꞌnnahn tin guluuꞌyi Ñiꞌh cweenta raꞌ chi laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Garaa raꞌ nin nahpa Xtaaꞌdahn naa xteꞌnnahn; pwihsi niꞌchin nin guñiꞌn loh tu laꞌh Spíritu Saantu guicaꞌha nin naa xteꞌnnahn tin guluuꞌyi Ñiꞌh xa naa cweenta raꞌ chi laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ya za balaquiꞌhn dxiꞌh riaꞌdxi ayi gwaꞌharu tu naꞌh, per mas chiꞌchi zwaꞌha ru tu naꞌh stuhbi. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ya chiꞌchi gunaabadxyiꞌdxyi loh lasaaꞌ raꞌ paaldaa nin naa raꞌ xpwiinn Ñiꞌh rahbi raꞌ ba: ―¿Xi zee loh dxyiꞌdxyi raꞌ riiꞌ? Nnah Jesuhs loh nuꞌh zalliaaꞌyiꞌhn riaꞌdxyi ayiru chyu gwaꞌha loh Ñiꞌh, ya mahs chiꞌchi zachidiaꞌha raꞌ nuꞌh loh Ñiꞌh stuhbi, ¿xi naa chiꞌh guzee Ñiꞌh nez nuu Daada Dxiohs?, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ya ¿xi zee loh dxyiꞌdxyi nin naa zalliaaꞌyiꞌhn riaꞌdxyi? Ayi chyu rahcabwaꞌ nin rñiꞌ Jesuhs loh dxyiꞌdxyi raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ya guhcabwaꞌ Jesuhs ñinaabadxyiꞌdxyi raꞌ ba loh Ñiꞌh, niꞌchin rahbi Ñiꞌh loh raꞌ ba: ―Naꞌh rñiꞌn loh tu zalliaaꞌyiꞌhn riaꞌdxyi ayiru gwaꞌha tu loon, ya mahs chiꞌchiyi zwaꞌha tu loon stuhbi; ¿ta deeꞌ raꞌ nin canaabadxyiꞌdxyi loh lasaaꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Naꞌpahn siguhra laꞌh tu zuꞌn tu, nee ziuuꞌ nalaasa stoꞌ tu gaduhbi nin cwih yahxi raꞌ bwiinn guidxyiyuh, ya nicala chuu nalaasa stoꞌ tu, ya xquelnalaasa tu chi ziahcan guelnasaa. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Laasii tuhbi gunnaꞌh chin raalaa lliiꞌn ba riuuꞌ ba guelnazihdzi, laasii bigaꞌha xohra ba; per chin riaꞌloh raalaa lliiꞌn ba, riaꞌldastoꞌ ba guelnayaan chi pur xcweenta nin riahxi ba rwaꞌha ba loh lliiꞌn ba nin guulaa loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ziꞌchilla laꞌh tu nnah nuu guelnalaasa stoꞌ tu, per zabiaꞌgarii dxieꞌldaguiaꞌhahn cuun tu ya chiꞌchi ziahxi tu chin gwaꞌha tu naꞌh ya guelriahxi chi ayi chuu nin tuhbi chyu guziaꞌtiiꞌhin loh tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ya laꞌn dxyih raꞌ chi ayiru xi guinaabadxyiꞌdxyi tu loon. Rñiꞌn loh tu laꞌh Daada Dxiohs guniꞌhi garaa raꞌ cohsa raꞌ nin guinaaba tu pur laan, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","yannah nagahdxi xi guinaaba tu pur laan; guinaaba tu nee zicaꞌha tu, tin ziꞌchi dxiahxi tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Rahbi za Jesuhs: ―Laꞌnguñiꞌ dxyiꞌdxyi raꞌ riiꞌ loh tu ziga dxyiꞌdxyi ralaꞌn, per zadzihn dxih nin ayiru guiñiꞌn loh dxyiꞌdxyi ralaꞌn raꞌ, sino que guiñiꞌn loh tu nayaa-nayaa xcweenta Xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Laꞌn dxyih raꞌ chi zinaaba tu pur laan, nee ayi rñiꞌn loh tu naꞌh guiñiꞌn loh Xtaaꞌdahn pur xcweenta tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","laasii laꞌhgahca Daada Dxiohs rucaꞌh stoꞌ Ñiꞌh laꞌh tu laasii rucaꞌh stoꞌ za tu naꞌh, nee laasii za gwachiistoꞌ tu naꞌh zeꞌldahn pur xcweenta Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Zeꞌldahn nez loh Dxiohs tin guluꞌnehza Ñiꞌh naꞌh loh guidxyiyuh riiꞌ yannah laꞌn gabiiꞌhi loh guidxyiyuh riiꞌ tin gabiaꞌgariin nez nuu Xtaaꞌdahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ya chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Nnahsihn cañiꞌ luꞌh nayaa-nayaa nin tuhbi dxyiꞌdxyi ralaꞌn ayi cañiꞌ luꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","yannah ridiaꞌha loh nu naann luꞌh garaa raꞌ cohsa nee nin ayi xchiꞌhnru chyu guinaabadxyiꞌdxyi xica loh Yuꞌbiluꞌh, ya pur deeꞌ raꞌ riachiistoꞌ nu zeꞌ luꞌh pur xcweenta Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chiꞌchi rahbi Jesuhs: ―¿Ta nnayi riachiistoꞌ tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pwihsi laꞌh hohra bigaꞌha nee nnah gahcan chin cada tuhbigah tu ganaꞌzu nezii-neziꞌchi ya zusaaꞌn tu tuhbidxiꞌh naꞌh, per ayi dxiaꞌhanahn tuhsi laasii laꞌh Xtaaꞌdahn zuunee naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Laꞌn guñiꞌ dee raꞌ loh tu tin cwidxyii stoꞌ tu pur nuunee tu naꞌh tuhsi. Loh guidxyiyuh nahpa zizahcazii tu, per guldxiahxi laasii naꞌh laꞌn bwiꞌhnn gahn loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ya chin guyaꞌloh guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi bwaꞌha Jesuhs nez dxibaaꞌ ya rahbi Ñiꞌh: ―Paah, laꞌh hohra bigaꞌha: bwiꞌhnn lasahca laꞌh Lliiꞌn luꞌh tin ziꞌchiza laꞌh Lliiꞌn luꞌh guunn lasahca lah Yuꞌbiluꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","pwihsi yiꞌh badiꞌhi luꞌh guelrnabwaꞌ laꞌh Lliiꞌn luꞌh loh raꞌ garaa raꞌ bwiinn guidxyiyuh, tin gudiꞌhi Lliiꞌn luꞌh guelnabahan nin ayi ñichilohtiiꞌ laꞌh raꞌ bwiinn raꞌ nin badiꞌhi luꞌh laꞌh bi. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dee si raꞌ nahpa guelnabahan nin ayi ñichilohtiiꞌ; bwiinn raꞌ nin nuꞌnbwaꞌ Yuꞌbiluꞌh, nin naa tuhbi dxiꞌh Yuꞌbi Dxiohs, nee cun neezaa naꞌh, Jesucristu, nin guluꞌnehza luꞌh loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Naꞌh laꞌn bwiꞌhnn lasahca lah luꞌh loh guidxyiyuh riiꞌ, pwihsi laꞌn batuꞌlla dziꞌn nin guñiꞌ luꞌh guꞌnnahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pwihsi nnah, Paah, bwiꞌhnn lasahca laan nez hasta nuu luꞌh cun guel lasahca nee neezaa cun llaꞌñih nin naꞌpahn desde chin nagahdxi cwihxchih guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Bwiinn raꞌ nin gulii luꞌh loh guidxyiyuh tin guniꞌhi raꞌ luꞌh ba naꞌh; laꞌn rwaꞌha chyu naa luꞌh, nee naa za raꞌ ba xteenn Yuꞌbiluꞌh, ya yiꞌh baniꞌhi raꞌ luꞌh ba naꞌh, nee cagazoꞌbadxiahga raꞌ ba xchiꞌdxyi Yuꞌbiluꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","yannah naann raꞌ ba garaa nin baniꞌhi luꞌh naꞌh, zeꞌ raꞌn pur xcweenta Yuꞌbiluꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","pwihsi baluꞌyiꞌhn dxyiꞌdxyi raꞌ nin baniꞌhi luꞌh guiñiꞌn loh raꞌ ba, ya laꞌh raꞌ ba riachiistoꞌ raꞌ ban, nee neezaa cagadiꞌhi raꞌ ba cweenta naꞌh zeꞌldahn loh guidxyiyuh pur xcweenta Yuꞌbiluꞌh, nee riachii za stoꞌ raꞌ ba Yuꞌbiluꞌh guluꞌnehza luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Naꞌh rnaꞌbaꞌhn xcweenta raꞌ ba loh Yuꞌbiluꞌh; ayi rnaꞌbaꞌhn xcweenta raꞌ bwiinn raꞌ nin naa raꞌ bwiinn guidxyiyuh, sino que pur xcweenta raꞌ bwiinn raꞌ nin baniꞌhi luꞌh naꞌh, laasii naa raꞌ ba xpwiinn Yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Garaa tiiꞌ raꞌ nin naa xteꞌnnahn naa xteenn Yuꞌbiluꞌh, ya nin naa xteenn luꞌh naa za raꞌ xteꞌnnahn; ya guhca lasahca laan pur xcweenta raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Naꞌh ayiru gacataꞌhn loh guidxyiyuh riiꞌ, per laꞌh raꞌ ba ziaꞌhan raꞌ ba loh guidxyiyuh riiꞌ, ya gaduhbi nin naꞌh dxieꞌldahn nez nuu Yuꞌbiluꞌh, Xtaaꞌdahn nin naa saantu rooꞌ, gacanee luꞌh laꞌh raꞌ ba cun guelrnabwaꞌ nin nahpa luꞌh ziga naa lah Yuꞌbiluꞌh, ziga lah nin baniꞌhi luꞌh naꞌh, tin cwih raꞌ ba tuhsi juunta ziga dxuu nuꞌh cun Yuꞌbiluꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nnah gaduhbi nin guyuuꞌnee raꞌn ba loh guidxyiyuh riiꞌ balaloh raꞌn ba cun guelrnabwaꞌ nin naa lah Yuꞌbiluꞌh, ziga naa lah nin baniꞌhi luꞌh naꞌh, ya nin tuhbi raꞌ ba ayi ñiñichiloh sino que nin guñichiloh gahca, tin ziꞌchi guzohba dxyiꞌdxyi bariaꞌcaa ziga rñiꞌ loh Xchihtsi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Nnah dxieꞌldahn nez nuu luꞌh, rñiꞌn dxyiꞌdxyi raꞌ riiꞌ nnah gaduhbi nin nuuꞌhuhn loh guidxyiyuh riiꞌ, tin ziꞌchi chuu nasaa stoꞌ raꞌ ba ziga nuu nasaa stoꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naꞌh baluꞌyiꞌhn xchiꞌdxyi Yuꞌbiluꞌh, per laꞌh raꞌ bwiinn guidxyiyuh raꞌ rdxyiꞌchinee raꞌ ba laꞌh raꞌ nin naa raꞌ xpwiinn luꞌh laasii ayi naa raꞌ ba bwiinn guidxyiyuh, ziga naꞌh za ayi naan bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ayi rnaꞌbaꞌhn loh yuꞌbiluꞌh gabweꞌhe luꞌh ba loh guidxyiyuh, sino que gulaloh raꞌ luꞌh laꞌh raꞌ ba loh bwiinndxaaba. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ziga naꞌh ayiza naan bwiinn guidxyiyuh, ziꞌchiza laꞌh raꞌ ba ayiza naa raꞌ ba bwiinn guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bazuhnayaa laꞌh raꞌ ba cun xchiꞌdxyi luꞌh, laasii xchiꞌdxyi luꞌh guchii paꞌhcan. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ziga guluꞌnehza luꞌh naꞌh loh raꞌ nin naa raꞌ bwiinn guidxyiyuh, ziꞌchi za naꞌh ziguꞌneeza raꞌn ba tin chee raꞌ ba loh gaduhbi guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ya pur xcweenta raꞌ ba rudiꞌhihn naꞌhgahca, tin ziꞌchi za nee raꞌ ba gaca nayaa raꞌ ba pur ziga naa xcweenta dxyiꞌdxyi nin guchii. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ayi rnaꞌbaꞌhn loh Yuꞌbiluꞌh pur cweenta si raꞌ riiꞌ, sino que nee nin gueꞌdu chechiistoꞌ raꞌ ñiꞌh naꞌh chin dxihn raꞌ ba xchiꞌdxyiꞌhn nin gutiꞌchi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rdxiꞌhnaꞌhn loh Yuꞌbiluꞌh garaa raꞌ ba cwih raꞌ ba tuhsi juunta, nee gaca raꞌ ba tuhsi cun laꞌh raꞌ nuꞌh, Xtaaꞌdahn ziga nuunee luꞌh naꞌh, ziꞌchiza nuuneen yiꞌh, pwihsi nahpa cwih raꞌ ba tuhsi juunta, tin ziꞌchi chechiistoꞌ raꞌ bwiinn guidxyiyuh Yuꞌbiluꞌh guluꞌnehza luꞌh naꞌh loh guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Naꞌh badiꞌhihn laꞌh raꞌ ba guelrnabwaꞌ gahca nin baniꞌhi luꞌh naꞌh, tin ziꞌchi gaca lastoꞌ raꞌ ba tuhsii lastoꞌ ñiꞌh ziga naa nuꞌh tuhsi; ");
INSERT INTO zpvNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","naꞌh cun laꞌh raꞌ ba ya yiꞌh cun naꞌh, tin ziꞌchi gaca raꞌ ba tuhsi, ya ziꞌchi zahcabwaꞌ raꞌ bwiinn guidxyiyuh Yuꞌbiluꞌh guluꞌnehza luꞌh naꞌh loh guidxyiyuh, nee rucaꞌha za stoꞌ luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Paah, yiꞌh baniꞌhi luꞌh laꞌh raꞌ ba naꞌh, nee rnaꞌbaꞌhn loh Yuꞌbiluꞌh nee raꞌ ba chuunee raꞌ ba naꞌh nez chuuꞌhuhn, tin gwaꞌha raꞌ ba guel lasahca xteꞌnnahn nin baniꞌhi luꞌh naꞌh, laasii rucaꞌh stoꞌ luꞌh naꞌh galoh nin nagahdxi cwihxchyih guidxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xtaaꞌdahn nin ruhnn ganaalla dziꞌn zaꞌca, bwiinn raꞌ nin naa bwiinn guidxyiyuh ayi nuꞌnbwaꞌ raꞌ ba Yuꞌbiluꞌh, per naꞌh nuꞌnbwaꞌn yiꞌh nee bwiinn raꞌ riiꞌ ya laꞌh raꞌ ba guhcabwaꞌ Yiꞌh guluꞌnehza luꞌh naꞌh ");
INSERT INTO zpvNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ya naꞌh laꞌn guñiꞌ loh raꞌ ba nee ziahzahrutiꞌh guiñiꞌn chyu naa Yuꞌbiluꞌh tin ziꞌchi gapachaꞌyi raꞌ ba naꞌh laꞌn lastoꞌ raꞌ ba tin gantsiiꞌhi lasaaꞌ raꞌ ba ziga nadziiꞌhi luꞌh naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ya chin guyaꞌloh guñiꞌ Ñiꞌh dxyiꞌdxyi raꞌ chi, chiꞌchi biriaꞌhnee Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh tin zenee Ñiꞌh laꞌh raꞌ ba stuhbi lahdu guiꞌw xteenn Cedrohn. Riꞌchi nuu tuhbi huerta nez guyuuꞌtiinee Ñiꞌh xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Neezaa Judas nin dxiuꞌn ntriehgu laꞌh Jesuhs, nuꞌnbwaꞌ nez nuu huerta chi, laasii riꞌchi naannloh ba radzihnnee Jesuhs xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Niꞌchin lwehgusi riꞌchi badzihnnee Judas nuhn suldahdu Romanu cun paaldaa raꞌ guixaꞌga xteenn guidoꞌrooꞌ, ya bwiinn raꞌ riiꞌ gwah raꞌ ba riꞌchi pur xquelrnabwaꞌ raꞌ bixohza raꞌ nin rnabwaꞌ laꞌh raꞌ garaa bixohza nee cun xquelrnabwaꞌ za raꞌ bwiinn fariseu raꞌ. Nuꞌa raꞌ ba spahda nee cun lahnsa, nee nuꞌa za raꞌ ba lámpara raꞌ cun atorcha raꞌ nin ruhnn biaꞌñih. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ya laꞌh Jesuhs laꞌh Ñiꞌh guhcabwaꞌla garaa raꞌ nin gaca, chiꞌchi gunabadxyiꞌdxyi Ñiꞌh loh raꞌ bwiinn ziahan raꞌ chi, rahbi Ñiꞌh: ―¿Chyu radxiꞌhyi tu? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chiꞌchi rahbi bwiinn raꞌ chi: ―Laꞌh Jesuhs nin zeꞌ guihdxyi Nazaret. Chiꞌchi rahbi Jesuhs: ―Naꞌhan. Ya neezaa Judas nin cayuhnn ntriehgu laꞌh Jesuhs dxaꞌga loh raꞌ bwiinn raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ya chin guñiꞌ Jesuhs rahbi Ñiꞌh: “Naꞌhan”, dxyihgah biehtagueeta raꞌ ba hasta loh yuh biaaba raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chiꞌchi rahbi Jesuhs loh raꞌ ba stuhbi: ―¿Chyu radxiꞌhyi tu? Chiꞌchi rahbi raꞌ ba stuhbi: ―Laꞌh Jesuhs nin zeꞌ guihdxyi Nazaret. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Laꞌn guñiꞌ la loh tu naꞌhan. Sidela naꞌh radxiꞌhyi tu, gulgasaaꞌn guziaa raꞌ spaaldaa raꞌ bwiinn raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Dee raꞌ guhca tin guzohba dxyiꞌdxyi nin guñiꞌ Jesuhs chin rahbi Ñiꞌh: “Paah, bwiinn raꞌ nin baniꞌhi luꞌh naꞌh ayi ñichiloh nin tuhbi raꞌ ba.” ");
INSERT INTO zpvNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ya chiꞌchi laꞌh Simohn Pehdru nuꞌa tuhbi spahda, chiꞌchi guleꞌhe ba spahda chi chiꞌchi bachyuuꞌga ba tuhbi lahdu dxiahga derehchu tuhbi bwiinn nin laa Malco, nin naa xmooza tuhbi bixohza nin naa bixohzarooꞌ laꞌn dxyih raꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","chiꞌchi rahbi Jesuhs loh Pehdru: ―Gucaꞌha spahda ca baguꞌchaꞌyin; sidela laꞌh Xpaaꞌn ya naa xigaaba ba tiꞌdxiꞌhn trabahjw riiꞌ nicala tiꞌdxiꞌhñin, ¿taayi nahpadxiꞌh naꞌh tiidxiꞌhñin? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Suldahdu raꞌ cun nin naa comandante loh raꞌ ba cun guixaꞌga raꞌ xteenn xquidoꞌ rooꞌ bwiinn Israel, gunaꞌzu raꞌ laꞌh Jesuhs bachiꞌbiduꞌh raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","chiꞌchi gwanee raꞌ ba laꞌh Ñiꞌh mwergaloh rwaaꞌ yihdzi Anahs, laasii laꞌh Anahs chi naa xtaswehgra Caifahs ");
INSERT INTO zpvNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","laꞌhgahca ba nin rahbi loh raꞌ bwiinn Israel naa bwen para laꞌh raꞌ ba gachi tuhbisi ndxiꞌhw xlawaaꞌha gaduhbi guihdxyi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Laꞌh Simohn Pehdru cun stuhbi xpwiinn Ñiꞌh zee naꞌhla raꞌ ba laꞌh Jesuhs chin zenee raꞌ bwiinn chi laꞌh Ñiꞌh yiꞌbiduꞌh Ñiꞌh, ya laꞌh stuhbi xpwiinn Ñiꞌh chi naa ba tuhbi bwiinn nin nuꞌnbwaꞌ bixohza rooꞌ, niꞌchin nin guyuuꞌtii ba rwaaꞌ leeꞌ nez hasta guyuuꞌtiinee raꞌ ba laꞌh Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ya laꞌh Simohn Pehdru biaꞌhan ba dihtsi jwehra rwaaꞌ leeꞌ chi, per guñiꞌ stuhbi bwiinn chi nin zenee laꞌh Pehdru loh nin rahpa rwaaꞌ leeꞌ tin guyuuꞌtii Pehdru, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ya chiꞌchi gunaabadxyiꞌdxyi tuhbi mooza gunnaꞌh nin rahpa rwaaꞌ leeꞌ chi loh Pehdru rahbi ba: ―¿Taayi nee dxiꞌh luꞌh naa luꞌh tuhbi raꞌ xpwiinn ndxiꞌhw ca? Chiꞌchi rahbi Pehdru: ―Ayi nee dxiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ya ziga cayahca nahlda, niꞌchin nin laꞌh raꞌ mooza raꞌ nin ruhnn dziꞌn riꞌchi cun guixaꞌga raꞌ xteenn guidoꞌ, gulahchi raꞌ ba dxih riꞌchi, ya gwabiigagah Pehdru cagabihdxyinee ba laꞌh raꞌ bwiinn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ya chiꞌchi guzohbaloh gunaabadxyiꞌdxyi nin naa bixohza rooꞌ loh Jesuhs xcweenta xpwiinn Ñiꞌh cun nee ziga dxyiꞌdxyi raꞌ nin ruluuꞌyi Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Naꞌh guñiꞌn nez delaanta loh garaatiiꞌ raꞌ bwiinn nee guillii-guillii baluꞌyiꞌhn laꞌn guidoꞌ biꞌtiꞌhn raꞌ nin naa ziga capihyiꞌhn raꞌ nee cun laꞌn guidoꞌrooꞌ nez hasta radiaaꞌha raꞌ garaa raꞌ bwiinn Israel raꞌ; pwihsi nin tuhbi dxyiꞌdxyi ayi baluꞌyiꞌhñin ralaꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Xixnaa rnaabadxyiꞌdxyi tu loon? Gulguinaabadxyiꞌdxyi loh raꞌ bwiinn nin bihn raꞌ dxyiꞌdxyi raꞌ nin baluꞌyiꞌhn, ya laꞌh raꞌ ba guiñiꞌ raꞌ ba dxyiꞌdxyi raꞌ nin baluꞌyiꞌhn laasii laꞌh raꞌ ba bihn raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ya chin guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ, chiꞌchi gudahpa tuhbi guixaꞌga xteenn guidoꞌ loh Jesuhs rahbi ba: ―¿Ta ziꞌca rusiaꞌgarii luꞌh dxyiꞌdxyi loh bixohza nin rnabwaꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chiꞌchi rahbi Jesuhs: ―Sidela naꞌh guñiꞌn xiilla tuhbi dxyiꞌdxyi nin ayi naa xnehza, guñiꞌ cuun nin naa dxyiꞌdxyi nin ayi naa xnehza chi; per sidela laꞌh dxyiꞌdxyi nin guñiꞌn naan xnehzan, ¿xixnaa chiꞌh rgahpa luꞌh loon? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ya chiꞌchi guxeꞌhla Anahs laꞌh Ñiꞌh yiꞌbiduꞌh Ñiꞌh loh Caifahs, nin naa bixohza rooꞌ loh raꞌ bixohza. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ya zuu gahca Pehdru riꞌchi zuu gabihdxyi ba, ya chiꞌchi gunaabadxyiꞌdxyi raꞌ ba loh Pehdru rahbi raꞌ ba: ―¿Taayi nee dxiꞌh luꞌh naa luꞌh tuhbi raꞌ xpwiinn ndxiꞌhw ca? Chiꞌchi rahbi Pehdru: ―Ayi nee dxiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Lwehgu gunaabadxyiꞌdxyi tuhbi gahca xmooza bixohza nin rnabwaꞌ loh nin naa lasaaꞌ ñiꞌh laꞌh Malcu nin bachyuuꞌga Pehdru dxiahga ñiꞌh, rahbi ba: ―¿Taagah nee dxiꞌh yiꞌh nin bwaꞌhahn laꞌn huerta cun laꞌh ndxiꞌhw ca? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chiꞌchi rahbi laꞌgaꞌh Pehdru: ―¡Ayi nee dxiꞌh naꞌh! Ya hohrachi gahca bacaꞌhyahnn dxiidxinguhla. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pwihsi gwanee raꞌ ba laꞌh Jesuhs yihdzi Caifahs nez naa xpalaciu gobernador, ya hohra chi laꞌh zeꞌgarah gueꞌla, ya ayi guyuuꞌtii bwiinn Israel raꞌ chi laꞌn palahsiu tin ayi ñuuꞌ xtuhlda raꞌ ba xcweenta ziga ruluuꞌyi xlehyi raꞌ ba loh lañih, sinolaꞌn ayi ñahca ñahw raꞌ ba xchih paascu. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pwihsi niꞌchin biriaꞌh Pilahtu guñiꞌ ba loh raꞌ ba, rahbi ba: ―¿Xi guelchiah rbahchi tu xcweenta bwiinn riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chiꞌchi rahbi raꞌ ba: ―Sidela laꞌh ba ayi ñahca ba tuhbi bwiinn duhlda ayi chyu ñieꞌnee ba loh luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Chiꞌchi rahbi Pilahtu loh raꞌ ba: ―Gulchenee ba laꞌhgahca tu gulguiꞌhnn guelguxchisi xcweenta ba ziga naa xlehyi tu. Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi: ―Per laꞌhnu ziga naa nu bwiinn Israel ayi rusaaꞌn xlehyi tu gachidxiinn nu nin tuhbi bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Squiiꞌ guzohba dxyiꞌdxyi nin guñiꞌ Jesuhs ziga gachi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chiꞌchi biuꞌgarii Pilahtu laꞌn palahsiu stuhbi chiꞌchi gudihdxyi ba laꞌh Jesuhs rahbi ba loh Ñiꞌh: ―¿Ta yiꞌh naa luꞌh xrrehyi raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chiꞌchi rahbi Jesuhs: ―¿Ta niꞌca rnaabadxyiꞌdxyi luꞌh pur xcweenta gahca luꞌh, o gu guyuuꞌ chyuulla gunahan loh luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chiꞌchi rahbi Pilahtu loh Ñiꞌh: ―¿Ta nee chiꞌh naꞌh naan bwiinn Israel? Bwiinn raꞌ nin naa raꞌ bwiinn lahdxyi luꞌh cun bixohza nin rnabwaꞌ raꞌ loh snuhn bixohza biuꞌn ntriehgu yiꞌh loon. ¿Xi bwiꞌhnn luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ya chiꞌchi rahbi Jesuhs: ―Ayi naa xquelrnabwaꞌn loh guidxyiyuh riiꞌ; sidela ñahcan, chiꞌchi garaa raꞌ xpwiꞌnnahn ñidxildxi pur naꞌh tin ayi ñinaꞌzu raꞌ bwiinn Israel raꞌ naꞌh, per xquelrnabwaꞌn ayi naan loh guidxyiyuh riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ya chiꞌchi rahbi Pilahtu: ―¿Ta yiꞌh chiꞌh naa luꞌh rrehyi? Chiꞌchi rahbi Jesuhs: ―Naꞌh naan rrehyi ziga guñiꞌ luꞌh; naꞌh guulahn nee zeꞌldahn loh guihdxyiyuh tin guiñiꞌn dxyiꞌdxyi nin guchii. Garaa raꞌ bwiinn nin rzoꞌbadxiahga xcweenta nin guchii, rzoꞌbadxiahga raꞌ ba nin rñiꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chiꞌchi rahbi Pilahtu: ―¿Cuun xchiꞌh za nin naa dxyiꞌdxyi guchii? Ya chin guyaꞌloh gunaabadxyiꞌdxyi Pilahtu dxyiꞌdxyi raꞌ riiꞌ, biriaꞌh ba stuhbi tin guñiꞌ ba loh raꞌ bwiinn Israel stuhbi rahbi ba: ―Naꞌh ayi rdxeelaꞌhn nin tuhbi xtuhlda bwiinn riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","per laꞌh tu nahpa tu costumbre rnaaba tu rlaꞌh tuhbi bwiinn nin ñieꞌw chin rahca dxyih lañih pascu. ¿Xi nna tu? ¿Zuldaꞌhn laꞌh xrrehyi raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ya chiꞌchi guñiꞌ garaatiiꞌ raꞌ ba: ―¡Ayi gutaꞌh luꞌh niꞌca! ¡Mas chaꞌyi bataꞌh laꞌh Barrabahs! Ya Barrabahs riiꞌ guhca ba tuhbi gubaꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ya chiꞌchi gucaꞌha Pilahtu laꞌh Jesuhs tin gwanee raꞌ xpwiinn ba laꞌh Ñiꞌh tin bacaꞌyahga raꞌ ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ya laꞌh raꞌ suldahdu raꞌ chi bwiꞌhnnchaꞌyi raꞌ ba tuhbi curohn guihchii, guluuꞌ raꞌ ban yihca Jesuhs cun bagahcu za raꞌ ba laꞌh Ñiꞌh tuhbi cahpa naxñaa nagaasa nin rahcu tuhbi rrehyi, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ya chiꞌchi gwabiiga raꞌ ba loh Ñiꞌh rahbi raꞌ ba: ―¡Gubahan par tuꞌpazi Rehyi raꞌ bwiinn Israel! Chiꞌchi riaꞌzi raꞌ ba loh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ya chiꞌchi biriaꞌh laꞌgaꞌh Pilahtu stuhbi, chiꞌchi rahbi ba: ―Gulguiaꞌha, laꞌn cabweꞌhe bwiinn riiꞌ nezloh tu tin gacabwaꞌ tu ayi rdxeelaꞌhn nin tuhbi xtuhlda bwiinn riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ya chiꞌchi guleꞌhe ba laꞌh Jesuhs, nuu curohn guihchii chi yihca Ñiꞌh cun nahcu za Ñiꞌh cahpa naxñaa nagaasa, ya rahbi Pilahtu: ―¡Gulguiaꞌha! ¡Laꞌh bwiinn chi niꞌca! ");
INSERT INTO zpvNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ya chin bwaꞌha raꞌ bixohza nin rnabwaꞌ laꞌh raꞌ bixohza cun guixaꞌga raꞌ xteenn guidoꞌ laꞌh Jesuhs ziꞌchi, mahziru gudihdxyidxiahyoꞌba raꞌ ba rahbi raꞌ ba: ―¡Bacaꞌh ba loh cruhzi! ¡Bacaꞌh ba loh cruhzi! Chiꞌchi rahbi Pilahtu: ―Pwihsi gulchenee ba laꞌhtu, ya laꞌgahca tu gulgacaꞌh ba loh cruhzi, laasii naꞌh ayi rdxeelaꞌhn nin tuhbi xtuhlda bwiinn ca. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ya chiꞌchi rahbi raꞌ bwiinn Israel raꞌ chi loh Pilahtu: ―Laꞌhnu nidxiaapa nu tuhbi lehyi, ya ziga xlehyi nu nahpa gachi ba, laasii cagatiiꞌdxi ba laꞌh ba ziga Lliiꞌn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ya chin bihn Pilahtu dxyiꞌdxyi nin guñiꞌ raꞌ ba, mahziru bidxyihbi ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ya chiꞌchi guyuuꞌtii ba stuhbi laꞌn palahsiu chiꞌchi gunaabadxyiꞌdxyi ba loh Jesuhs stuhbi rahbi ba: ―¿Chyu bwiinn luꞌh? Ya laꞌh Jesuhs ayi guñiꞌtiiꞌ Ñiꞌh loh ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","chiꞌchi rahbi Pilahtu loh Jesuhs: ―¿Taayi guiñiꞌ luꞌh loon? ¿Taayi gaann luꞌh naꞌpahn guelrnabwaꞌ tin gucaꞌhn yiꞌh loh cruhzi nee naꞌpazahn guelrnabwaꞌ tin gutaꞌhzahn yiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ya chiꞌchi rahbi Jesuhs loh Pilahtu: ―Ayi ñahpa luꞌh nin tuhbi guelrnabwaꞌ para naꞌh sidela Dxiohs ayi ñuniꞌhi guelrnabwaꞌ yiꞌh; pwihsi niꞌchin nnah, bwiinn raꞌ nin biuꞌntriehgu naꞌh loh luꞌh bwiinn chi nahpa zirooꞌru duhlda que ziga yiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ya desde hohra chi gahca, gudxiꞌhyi Pilahtu xa ñutaꞌh ba laꞌh Jesuhs, per laꞌh raꞌ bwiinn Israel raꞌ chi mahziru jweersirooꞌ gudihdxyidxiah raꞌ ba rahbi raꞌ ba: ―¡Sidela yiꞌh gutaꞌh luꞌh laꞌh ndxiꞌhw ca, ayi naa luꞌh xamihgu emperador, laasii cuunchiꞌzi bwiinn nin xclaaꞌdzi tiidxi ziga rrehyi, naa bwiinn chi nin rdxindxinee laꞌh emperador! ");
INSERT INTO zpvNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ya chin bihn Pilahtu dxyiꞌdxyi raꞌ riiꞌ, biriaꞌhnee ba laꞌh Jesuhs tin guzohba ba loh yagaxiiyi hasta ruhn ba guelguxchisi, hasta laa cun dxyiꞌdxyi griehgu hasta naꞌ dxiah zaꞌca (nin zee loh dxyiꞌdxyi hebreu Gabata). ");
INSERT INTO zpvNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dxyih chi naa dxyih bispra lañih paascu, ya zigachiꞌh laaꞌyidxyih biꞌ Pilahtu loh raꞌ bwiinn Israel raꞌ chi, rahbi ba: ―¡Gulguiaꞌha, laꞌh xrrehyi tu niꞌca! ");
INSERT INTO zpvNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Chiꞌchi rahbi raꞌ ba jweersirooꞌ: ―¡Gachi ba! ¡Gachi ba! ¡Bacaꞌh ba loh cruhzi! Chiꞌchi rahbi Pilahtu loh raꞌ ba: ―¿Ta naꞌh gucaꞌhn laꞌh xrrehyi tu loh cruhzi? Ya chiꞌchi rahbi raꞌ bixohza raꞌ nin rnabwaꞌ raꞌ laꞌh raꞌ bixohza loh Pilahtu: ―¡Laꞌhnu ayiru chyu nahpa rrehyi, sola tuhbidxiꞌh laꞌh emperador! ");
INSERT INTO zpvNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ya chiꞌchi biuꞌn Pilahtu ntriehgu laꞌh Jesuhs tin gucaꞌh raꞌ ba laꞌh Ñiꞌh loh cruhzi, ya chiꞌchi zenee raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ya tin basaguꞌa raꞌ ba laꞌh Jesuhs xcruhzi Ñiꞌh, ya zenee raꞌ ba laꞌh Ñiꞌh nez hasta laa yihca bwiinnguuchi (ya cun dxyiꞌdxyi hebreu lahan Gólgota), ");
INSERT INTO zpvNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ya riꞌchi bacaꞌh raꞌ ba laꞌh Jesuhs loh cruhzi, neezaa bacaꞌh raꞌ ba schiohpa bwiinn cweꞌ Jesuhs cada lahdu cweꞌ Ñiꞌh tuhbigah raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ya yihca xcruhzi Ñiꞌh gunabwaꞌ Pilahtu gucah dxyiꞌdxyi raꞌ nin rñiꞌ squiiꞌ: “Jesuhs nin zeꞌ guihdxyi Nazaret, Xrrehyi raꞌ bwiinn Israel.” ");
INSERT INTO zpvNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ziahan raꞌ bwiinn Israel biꞌlda raꞌ ba dxyiꞌdxyi raꞌ chi, laasii nez hasta bacaꞌh raꞌ ba laꞌh Jesuhs loh cruhzi, gaxuhgahan para loh guihdxyi Jerusalehn, ya dxyiꞌdxyi raꞌ chi caaꞌhan cun dxyiꞌdxyi hebreu, cun dxyiꞌdxyi latin, cun neezaa dxyiꞌdxyi griehgu. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ya pur niꞌchin rahbi raꞌ bixohza raꞌ nin rnabwaꞌ loh raꞌ bixohza loh Pilahtu: ―Ayi gucaꞌh luꞌh: “Xrrehyi raꞌ bwiinn Israel”, sino que bacaꞌh: “Nin guñiꞌ ñahca Rehyi raꞌ bwiinn Israel.” ");
INSERT INTO zpvNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chiꞌchi rahbi Pilahtu loh raꞌ ba: ―Nin bacaꞌhn, bacahan ziꞌca. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ya chin guyaꞌloh bacaꞌh raꞌ suldahdu laꞌh Jesuhs loh cruhzi, chiꞌchi gucaꞌha raꞌ ba xahba Jesuhs bwiꞌhnn raꞌ ban tahpa taaꞌha tin bigaꞌzin gucaꞌha raꞌ ban; neezaa xahba Ñiꞌh nin laa tunica gucaꞌha raꞌ ba, ya lahdxi chi tuhsi taaꞌha naa lahdxi chi zigazi tuhbi buuxa ya dxiꞌban nez laꞌn gueeta cun para nez guiyaꞌ tuhbi dxiꞌh taaꞌha naa lahdxi chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ya chiꞌchi rahbi loh lasaaꞌ raꞌ suldahdu raꞌ chi: ―Ayi chyu chiꞌllu lahdxi ca, mas chaꞌyi guidzihta nuꞌh pur lahdxi ca guidiaꞌha raꞌ nuꞌh chyu naan xsweerta ñiꞌh. Pwihsi ziꞌchi guzohba dxyiꞌdxyi nin caa loh Xchihtsi Dxiohs hasta rahbi: Bigaꞌzi xaabahn gucaꞌha raꞌ ba, ya basaaꞌ raꞌ ba sweerta cun xtunicahn. Deeꞌ bwiꞌhnn raꞌ suldahdu. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ya nez caa Jesuhs loh cruhzi zuu xmaah Ñiꞌh cun bwehldaa xmaah Ñiꞌh zuu riꞌchi, cun María cheꞌhla Cleofahs, cun María Magdalena. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ya chin bwaꞌha Jesuhs loh xmaah Ñiꞌh, nee bwaꞌha za Ñiꞌh gahxu cweꞌ xmaah Ñiꞌh zuu xpwiinn Ñiꞌh nin mahzi nadziiꞌhi Ñiꞌh, chiꞌchi rahbi Ñiꞌh loh xmaah Ñiꞌh: ―Gunnaꞌh, laꞌh lliiꞌn luꞌh niꞌca, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ya chiꞌchi rahbi Ñiꞌh loh xpwiinn Ñiꞌh chi: ―Laꞌh xmaah luꞌh niꞌca. Ya desde hohra chi bacaꞌha xpwiinn Ñiꞌh chi laꞌh xmaah Jesuhs zigazi xmaah ba tin baganee ba laꞌh María rwaaꞌ yihdzi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ya chin guyaꞌloh garaa raꞌ deeꞌ, ya naann Jesuhs laꞌhgahn guhca garaa raꞌ cohsa raꞌ nin nahpa gaca, tin guzohba raꞌ xchiꞌdxyi Dxiohs nin caa pur xcweenta Ñiꞌh, niꞌchin rahbi Jesuhs: ―Rdxaagahn ñihsa. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ya riꞌchi zuu tuhbi ploorii ñihsa uhva naltaa ya guluuꞌ raꞌ ba ziga tuhbi taaꞌha lahdxi loh ñihsa uhva naltaa chi bacaꞌh raꞌ ban rwaaꞌ Jesuhs cun tuhbi lliꞌdzi yahga nin laa hisopo, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ya chin gwaaꞌ Jesuhs ñihsa uhva naltaa chi, chiꞌchi rahbi Ñiꞌh: ―Laꞌn guluhlla. Ya lwehgu basiaaba loh Ñiꞌh nezloh yuh ya batiꞌdxi Ñiꞌh xaalma Ñiꞌh loh naa Xtaada Dxiohs Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Dxyih chi naa bispra xteenn lañih paascu, ya laꞌh raꞌ bwiinn Israel raꞌ ayi gunah raꞌ ba ñiaꞌhan bweꞌltihxi Jesuhs cun bweꞌltihxi schiohpa raꞌ bwiinn chi loh cruhzi dxyih lañih paꞌ chi, laasii dxyih chi naa dxyih lañihrooꞌ nin rahpadaa raꞌ bwiinn Israel raꞌ. Pwihsi niꞌchin gunaaba raꞌ ba loh Pilahtu guinabwaꞌ ba cheechiꞌchii raꞌ ba ñaaꞌ raꞌ bwiinn raꞌ nin caa loh cruhzi cun ñaaꞌ za Jesuhs tin guenagah gachi raꞌ ba tin dxiehta bweꞌltihxi raꞌ ba loh cruhzi dxyih chi gahca. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ya chiꞌchi gwah raꞌ suldahdu riꞌchi ya gudxyiꞌchii raꞌ ba ñaaꞌ mwer tuhbi bwiinn nin caa loh cruhzi cweꞌ Jesuhs, ziꞌchi za stuhbi ba nin caa cweꞌ Ñiꞌh stuhbi lahdu, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","per ya chin gwabiiga raꞌ ba hasta caa Jesuhs loh cruhzi, bwaꞌha raꞌ ba laꞌh Jesuhs guhchi la. Pwihsi pur niꞌchin ayi gudxyiꞌchii raꞌ ba ñaaꞌ Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ya chiꞌchi gucaꞌha tuhbi suldahdu chi tuhbi lahnsa guxaala ba loh baldiꞌh tihxi Jesuhs, ya loh billaala tihxi Ñiꞌh biriaꞌh rihn cun ñihsan. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bwiinn nin ruuꞌyidxyiꞌdxyi cweenta riiꞌ bwaꞌhaloh ba garaa raꞌ cohsa raꞌ riiꞌ, nee rñiꞌ ba dxyiꞌdxyi nin guchii. Laꞌhba naann ba guchii naa xchiꞌdxyi ba, tin ziꞌchi za laꞌhtu chechiistoꞌ tu, ");
INSERT INTO zpvNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","laasii cohsa raꞌ riiꞌ guhcan tin guzohba dxyiꞌdxyi nin caa loh Xchihtsi Dxiohs nin rñiꞌ squiiꞌ: “Ayi chiꞌchii raꞌ ba nin tuhbi dzihta.” ");
INSERT INTO zpvNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ya stuhbi lahta loh Xchihtsi Dxiohs caa squiiꞌ: “Zwaꞌha raꞌ ba loh nin gudzihbi raꞌ ba lahnsa tihxi ñiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ya chin guyaꞌloh guhca garaa raꞌ deeꞌ, chiꞌchi gwah Joseh nin naa tuhbi bwiinn guihdxyi Arimatea loh Pilahtu tin baganaaba ba loh Pilahtu tin gutehta ba bweꞌltihxi Jesuhs loh cruhzi, ya Joseh riiꞌ naa za tuhbi xpwiinn Jesuhs, ya nicala rdxyihbi ba laꞌh raꞌ bwiinn Israel per cun ayi basaaꞌn ba ñuuꞌ guelnadxyiꞌbi lastoꞌ ba tin gunaaba ba loh Pilahtu batehta ba bweꞌltihxi Jesuhs loh cruhzi. Ya chin guziꞌguehlda Pilahtu lwehgu batehta ba bweꞌltihxi Ñiꞌh loh cruhzi. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Cun neezaa laꞌh Nicodemu nin gwahguiiꞌyidxyiꞌdxyinee laꞌh Jesuhs tuhbi gueꞌla gwahnee Nicodemu ziga chywaꞌh kihlu perfume nin nuuchi tuhbi clahsa cohsa nin laa mirra cun stuhbi clahsa cohsa nin laa áloe. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pwihsi gucaꞌha Joseh cun Nicodemu bweꞌltihxi Jesuhs batehta raꞌ ba loh cruhzi ya batuꞌbi raꞌ ba bweꞌltihxi Ñiꞌh lahdxi cun perfume chi, nee segun ziga naa raꞌ xcostumbre raꞌ bwiinn Israel raꞌ chin rucaꞌtsi lasaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ya nez hasta bacaꞌtsi raꞌ ba laꞌh Jesuhs nuu tuhbi huerta, ya laꞌn huerta chi guhca tuhbi baꞌ dxiah nacuubi, nin nagahdxi chyu bwiinn guigaꞌtsitiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Riꞌchi bacaꞌtsi raꞌ ba bweꞌltihxi Jesuhs laasii gahxu riaꞌhan baꞌ chi, nee laasii za pur laꞌh xlañih bwiinn Israel bagadzihntiiꞌ la niꞌchin basiooba raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ya mwer dxyih xteenn xmahn raꞌ bwiinn Israel, gwah María Magdalena rwaaꞌ baꞌ nez hasta bigaꞌtsi Jesuhs, nee nateyiꞌhnruzan gwah ba rwaaꞌ baꞌ; ya chin badzihn ba riꞌchi bwaꞌha ba bidoꞌba dxiah nin bieꞌw rwaaꞌ baꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ya chiꞌchi gubiaꞌgarii galluꞌhn ba bwaa ba hasta nuu Simohn Pehdru cun stuhbi xpwiinn Jesuhs nin guhcanadziiꞌhi Jesuhs, chiꞌchi rahbi gunnaꞌh chi: ―¡Pweda bagaleꞌhe raꞌ ba bweꞌltihxi Jesuhs laꞌn baꞌ, per ayi chyu gaann canehza gwanee raꞌ ba laꞌh Ñiꞌh! ");
INSERT INTO zpvNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ya chiꞌchi biriaꞌh Pehdru cun stuhbi bwiinn chi nin naa xpwiinn Jesuhs gwaguiaꞌha raꞌ ba rwaaꞌ baꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Garoopa raꞌ ba zee raꞌ ba carrih, per stuhbi ba mahzi carrih que laꞌh Pehdru ya galoh ba badzihn ba rwaaꞌ baꞌ hasta bigaꞌtsi Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chiꞌchi biaꞌchyu ba gudxihxiloh ba laꞌn baꞌ, ya sola bwaꞌha ba lahdxi raꞌ nin biduꞌbi Jesuhs, per ayi guyuuꞌtii ba laꞌn baꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ya hasta dihtsiyi ba badzihngaꞌh Pehdru, ya Simohn Pehdru guyuuꞌtii laꞌn baꞌ chi, chiꞌchi bwaꞌhaza ba lahdxi nin naꞌ laꞌn baꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nee bwaꞌhaza ba tuhbi lahdxi nin biyiꞌbiduꞌh yihca Jesuhs per ayi naꞌan tuhsi juunta cun veenda raꞌ, sino que guriin lahta naꞌan diaꞌhan. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chiꞌchiyi guyuuꞌtii neezaa stuhbi xpwiinn Jesuhs laꞌn baꞌ, bwaꞌhaza ba nin guhca, nee gwachiistoꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pwihsi nagahdxi gacabwaꞌ ba nin rñiꞌ loh Xchihtsi Dxiohs; laꞌh Jesuhs nahpa gabahan Ñiꞌh loh guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ya chiꞌchi lwehgu gubiaꞌgarii raꞌ xpwiinn raꞌ chi para yihdzi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ya laꞌh María biaꞌhan ba rwaaꞌ baꞌ chi, zohbayuꞌn ba; ya loh zohbayuꞌn ba chi biaꞌchyu ba bwaꞌha ba laꞌn baꞌ chi, ");
INSERT INTO zpvNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ya bwaꞌha ba chiohpa aanjla nin nahcu lahdxi labweh, zohba raꞌ aanjla raꞌ chi hasta guhta bweꞌltihxi Jesuhs; ya tuhbi aanjla chi zohba nez hasta guhta yihca Jesuhs, ya stuhbi aanjla chi zohba nez hasta guhta ñaaꞌ Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ya chiꞌchi gunaaba dxyiꞌdxyi raꞌ aanjla raꞌ chi loh María, rahbi raꞌ ba: ―Gunnaꞌh, ¿xixnaa ruꞌn luꞌh? Chiꞌchi rahbi María: ―Ruꞌnaꞌhn laasii zeenee raꞌ ba bweꞌltihxi Jesuhs, yannah nin ayi rahcabwaꞌn canehza zeenee raꞌ ban. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ya gueꞌdu guyaꞌloh guñiꞌ ba dxyiꞌdxyi raꞌ riiꞌ chin luꞌh basiaꞌgariiloh ba nehz dihtsi ba, ya hohrchigahca bwaꞌha ba laꞌh Jesuhs zuu riꞌchi, per ayi guhcabwaꞌ ba laꞌh Jesuhs niꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","chiꞌchi rahbi Jesuhs loh ba: ―Gunnaꞌh, ¿xixnaa ruꞌn luꞌh? ¿Chyu radxiꞌhyi luꞌh? Ya laꞌh gunnaꞌh chi bwiꞌhnn ba lligaaba naa Jesuhs tuhbi bwiinn nin rahpa weerta nin nuu riꞌchi, ya rahbi ba loh Ñiꞌh: ―Daada, sidela yiꞌh canehza gwanee luꞌh bweꞌltihxi Jesuhs, gunah canehz gwanee luꞌhn tin chegadxiꞌhyiñin riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chiꞌchi rahbi Jesuhs: ―¡María! Chiꞌchi basiaꞌgariiloh bi bwaꞌha bi ya guñiꞌ bi cun dxyiꞌdxyi hebreu, rahbi bi: ―¡Rabuni! (Nin naa gahca ziga guiñiꞌ luꞌh “Mwehsu”.) ");
INSERT INTO zpvNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chiꞌchi rahbi Jesuhs: ―Ayi guinaꞌzu luꞌh naꞌh, laasii nagahdxi guziaaꞌhahn nez hasta nuu Xpaaꞌn, per bwaa tin guhdzi loh raꞌ bwiꞌtsihn laꞌn gueꞌdu zuziaaꞌha nez hasta nuu Xpaaꞌn nin naa za Xpaah tu; nee Dxiohs xteꞌnnahn, cun nin naa za Xchiohs tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pwihsi chiꞌchi bwaa María Magdalena nez hasta nuu raꞌ xpwiinn Jesuhs ya rahbi ba loh raꞌ bwiinn chi bwaꞌha ba laꞌh Jesuhs, nee guhdzi za ba garaa nin guñiꞌ Jesuhs loh ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ya chin gurih gueꞌla dxyih chi gahca, mwer dxyih xteenn xmahn, badiaaꞌha raꞌ xpwiinn Jesuhs laꞌn tuhbi yuuꞌ, ya rwaaꞌ pweerta raꞌ chihpa ñeꞌw raꞌn laasii rdxyihbi raꞌ ba laꞌh raꞌ bwiinn Israel raꞌ. Chiꞌchi guyuuꞌtii Jesuhs hasta rii raꞌ ba, tin guzuh Ñiꞌh galaayi raꞌ xpwiinn Ñiꞌh, chiꞌchi guñiꞌ Ñiꞌh loh raꞌ ba, nee cun bagahpaDxiohs Ñiꞌh laꞌh raꞌ ba squiiꞌ: ―¡Gulcwahchidxyii stoꞌ tu! ");
INSERT INTO zpvNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ya chin guyaꞌloh guñiꞌ Ñiꞌh squiiꞌ, chiꞌchi baluuꞌyi Ñiꞌh naa Ñiꞌh hasta guzohba raꞌ clahva cun loh batiꞌ tihxi Ñiꞌh hasta bigaꞌha lahnsa, ya laꞌh raꞌ xpwiinn Ñiꞌh biahxi duxa raꞌ ba chin bwaꞌha raꞌ ba laꞌh Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chiꞌchi rahbi Jesuhs stuhbi: ―¡Gulcwahchidxyii stoꞌ tu! Ziga guluꞌnehza Xtaaꞌdahn naꞌh, ziꞌchiza rguꞌneezahn laꞌhtu. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chiꞌchi bwiꞌhnn Ñiꞌh bwih yihca raꞌ ba, ya rahbi Ñiꞌh: ―Gulguicaꞌha Spíritu Saantu. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bwiinn raꞌ nin gusiaꞌldastoꞌ tu xtuhlda raꞌ ñiꞌh, zibiaꞌcaa xtuhlda raꞌ ba; ya bwiinn raꞌ nin ayi gusiaꞌldastoꞌ tu xtuhlda ñiꞌh, ziaꞌhannee raꞌ ba xtuhlda raꞌ ba chi. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomahs, tuhbi bwiinn nin naa gadziꞌh bichiohpa xpwiinn Jesuhs, nin rñiꞌh raꞌ ba “Gemelu”, ayi ba loh snuhn raꞌ xpwiinn Jesuhs chin biꞌ Ñiꞌh loh raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ya chiꞌchi rahbi raꞌ snuhn raꞌ xpwiinn Jesuhs chi loh Tomahs: ―Laꞌhnu bidiaꞌha loh Jesuhs. Ya chiꞌchi rahbi Tomahs: ―Sidela naꞌh ayi cuꞌtiin bacwiin naaꞌhahn loh naa Ñiꞌh hasta guzohba clahva, cun cuꞌtii naaꞌhahn hasta bigaꞌha Ñiꞌh lahnsa, ayi chechiistoꞌn ziꞌchizi sola gwaꞌhan chiꞌchiyi chechii stoꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ya chin guhca xuhnna dxyih, badiaaꞌha raꞌ xpwiinn Jesuhs stuhbi laꞌn tuhbi yuuꞌ, ya chiꞌchiyi nee Tomahs dxaꞌga loh raꞌ ba chiꞌchi; nee rwaaꞌ yuuꞌ chihpa ñieꞌwun per laꞌh Jesuhs guyuuꞌtii Ñiꞌh, guzuh Ñiꞌh galaayi raꞌ ba ya bagahpaDxiohs Ñiꞌh laꞌh raꞌ ba, chiꞌchi rahbi Ñiꞌh: ―¡Gulcwahchidxyii stoꞌ tu! ");
INSERT INTO zpvNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ya lwehgu rahbi Ñiꞌh loh Tomahs: ―Guluuꞌtii bacwihn naa luꞌh rii, nee bwaꞌha gahca za naaꞌhahn, nee daꞌnee naa luꞌh rii tin guluuꞌtiiꞌhin tiꞌxihn hasta bigaꞌha lahnsa. Ayi rahca luꞌh ziga nin ayi riachii stoꞌ ñiꞌh sino que guhca bwiinn nin riachiistoꞌ ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ya chiꞌchi rahbi Tomahs: ―¡Daada Dxiohs xteꞌnnahn! ");
INSERT INTO zpvNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ya chiꞌchi rahbi Jesuhs loh Tomahs: ―¿Ta riachiistoꞌ luꞌh nnah laasii bwaꞌha luꞌh naꞌh nnah? Per dichohsa raꞌ bwiinn raꞌ nin riachiistoꞌ ñiꞌh nicla ayi bwaꞌha raꞌ ba naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ya ziahan ru sehn milagrosa raꞌ nin bwiꞌhnn Jesuhs nez delaanta loh raꞌ xpwiinn Ñiꞌh aayin loh chihbru riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","per dee raꞌ gucah raꞌn tin chechiistoꞌ tu laꞌh Jesuhs naa Crixtu, Lliiꞌn Dxiohs, ya tin ziga chechiistoꞌ tu laꞌh Ñiꞌh gaapa tu guelnabahan nin ayi ñichilohtiiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ya chin guyaꞌloh raꞌ deeꞌ, chiꞌchi baluuꞌyiloh Jesuhs stuhbi loh raꞌ xpwiinn Ñiꞌh rwaaꞌ laguhn xteenn Tiberias. Squiiꞌ guhcan: ");
INSERT INTO zpvNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Riꞌchi rii raꞌ ba tuhsi juunta; Simohn Pehdru, Tomahs nin laaza Gemelu, Natanael nin naa tuhbi bwiinn Canah xteenn guihdxyi Galilea, nee neezaa raꞌ lliiꞌn Zebedeu cun schiohpa raꞌ xpwiinn Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simohn Pehdru guñiꞌ loh raꞌ ba, rahbi ba: ―Laꞌn cheteꞌhe bwehlda. Chiꞌchi rahbi snuhn raꞌ ba: ―Neezaa laꞌhnu chonee nu yiꞌh. Ya zee raꞌ ba, seguihdu gucah raꞌ ba laꞌn tuhbi laancha; per gueꞌla chi ayi chyu bwehlda guleꞌhe raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ya chin zeꞌyaꞌñih loh yuh, chiꞌchi baluuꞌyiloh Jesuhs rwaaꞌ laguhn chi, per laꞌh raꞌ xpwiinn Ñiꞌh ayi guhcabwaꞌ raꞌ ba laꞌh Ñiꞌh nin naa Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh raꞌ ba, rahbi Ñiꞌh: ―Lliiꞌnraꞌn, ¿ta nin tuhbi bwehlda nagahdxi guinaꞌzu tu? Chiꞌchi rahbi raꞌ xpwiinn Ñiꞌh loh Ñiꞌh: ―Nin tuhbi ma. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulgalaꞌha xchihxi bwehlda tu lahdu derechu cweꞌ laancha ca, ya zibweꞌhe tu ziahan bwehlda. Ya bwiꞌhnn raꞌ ba ziꞌchi, ya seguihdu hasta nin ayi ruhnn raꞌ ba gahn gabweꞌhecaa raꞌ ba dxihxi bwehlda tantu ziahan bwehlda binaꞌzu laꞌnan. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ya chiꞌchi rahbi xpwiinn Ñiꞌh nin mahzi guhca nadziiꞌhi Jesuhs, rahbi ba loh Pehdru: ―¡Laꞌn biuꞌnbwaꞌ laꞌh Daada Jesuhs niꞌca! Balaaquiꞌhnsi bihn Simohn Pehdru laꞌh Jesuhs niꞌchi, lwehgu guhta ba xahba ba laasii ayi nahcu ba xahba ba hohra chi, ya balaꞌha ba laꞌhgahca ba loh ñihsa tin dxiooba bariaꞌcaa ba rwaaꞌ ñihsa hasta zuu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","gaduhbi zieꞌganee spaaldaa raꞌ xpwiinn Ñiꞌh laancha rwaaꞌ ñihsa cun dxihxi bwehlda gadxah bwehlda laꞌnan, ya nin gariaꞌcaaꞌhan rwaaꞌ ñihsa chi guhcan ziga tuhbi gaywaꞌh mehtru. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ya chin bariaꞌh raꞌ ba laꞌn laancha chi rwaaꞌ ñihsa, bwaꞌha raꞌba cayahca tuhbi bwehla riꞌchi cun tuhbi bwehlda dziꞌba loh bwehla chi cun neezaa pahn. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gulchecaꞌha paaldaa bwehlda nin gueꞌdu guleꞌhe tu. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chiꞌchi gucah Simohn Pehdru laꞌn laancha chi ya gudoꞌbañuh ba dxihxi bwehlda chi hasta rwaaꞌ ñihsa babweꞌhecaa ban, ya laꞌn dxihxi chi gadxah ziahan raꞌ bwehlda liꞌhi raꞌ naa raꞌ ma ziga tuhbi gaywaꞌha chywaꞌh bitsiꞌh cun chohnna ma; ya nicala ziꞌchi ziahan raꞌ ma per ayi bigaꞌllu dxihxi bwehlda nin guyuuꞌ raꞌ ma laꞌn ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chiꞌchi rahbi Jesuhs loh raꞌ ba: ―Gultaaꞌ tin guxirihn tu. Ya nin tuhbi raꞌ ba ziga naa raꞌ ba xpwiinn Ñiꞌh ayi biaalla raꞌ ba ñinaabadxyiꞌdxyi raꞌ ba chyu naa Ñiꞌh, laasii laꞌraꞌba naann la laꞌh Ñiꞌh naa Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ya lwehgu gwabiiga Jesuhs nezloh raꞌ ba, chiꞌchi gucaꞌha Ñiꞌh pahn gudxiꞌzi Ñiꞌhn nezloh raꞌ ba tin gudahw raꞌ ban, ya ziꞌchigahca bwiꞌhnn Ñiꞌh cun bwehlda. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dee biohnna bweelta nin baluuꞌyiloh Jesuhs loh raꞌ xpwiinn Ñiꞌh galoo nin babahn Ñiꞌh loh guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ya chin guyaꞌloh xirihn, chiꞌchi gunaabadxyiꞌdxyi Jesuhs loh Simohn Pehdru, rahbi Ñiꞌh: ―Simohn, lliiꞌn Jonahs, ¿ta rucaꞌstoꞌ luꞌh naꞌh mahziru que laꞌh raꞌ bwiinn raꞌ riiꞌ? Chiꞌchi rahbi Pehdru: ―Ziꞌchi Daada; Yiꞌh nin riahxiꞌhn xcweenta luꞌh. Chiꞌchi rahbi Jesuhs: ―Guhpa xpwiiꞌnnraꞌn nin naa ziga lliꞌyi bweezuꞌhn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chiꞌchi rahbilaꞌgaꞌh Jesuhs: ―Simohn, lliiꞌn Jonahs, ¿ta nadziiꞌhi luꞌh naꞌh? Chiꞌchi rahbi Pehdru: ―Ziꞌchi Daada; yiꞌh naann luꞌh nin riahxiꞌhn xcweenta ñiꞌh. Chiꞌchi rahbi Jesuhs: ―Guhpa laꞌh raꞌ xpwiiꞌnnraꞌn nin naa ziga xiꞌyiraꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ya nin riohnna bweelta gunaabadxyiꞌdxyi Jesuhs loh Pehdru, rahbi Ñiꞌh: ―Simohn, lliiꞌn Jonahs, ¿ta guchii luꞌh riahxi luꞌh pur xcweeꞌntahn? Ya chiꞌchi mwedxi bwiꞌhnn nalaasa loh Pehdru laasii nin biohnna bweelta gunaabadxyiꞌdxyi Ñiꞌh loh Pehdru sidela laꞌh Pehdru guchiipaꞌh rucaꞌstoꞌ bi laꞌh Ñiꞌh, chiꞌchi rahbi Pehdru: ―Ziꞌchi Daada; Yuꞌbiluꞌh naann luꞌh garaatiiꞌ, naannza luꞌh riahxiꞌhn pur xcweenta luꞌh. Chiꞌchi rahbi Jesuhs; ―Guhpa laꞌh raꞌ xpwiiꞌnnraꞌn nin naa raꞌ ziga xiꞌhyiraꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Guchii nin rñiꞌn loh luꞌh chin guhca luꞌh biiꞌhin, guhta luꞌh xahba luꞌh tin gwah luꞌh hastachiꞌzi badiꞌhi gahn yiꞌh, per chin gaca luꞌh mahzi bwiinn ñuꞌxa ziuuꞌ nin gugahcu yiꞌh xahba luꞌh ya chenee bwiinn chi yiꞌh hasta ayi guiclaaꞌdzi luꞌh chee luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ya xcweenta dxyiꞌdxyi raꞌ rii cañiꞌ Jesuhs loh Pehdru gahcan tin guiduꞌhun zacabwaꞌ ba xa gachi ba tin ziꞌchi guiñiꞌ zaꞌca raꞌ bwiinn xcweenta Dxiohs, ya chiꞌchi rahbi Ñiꞌh loh bi: ―Gudaꞌnaꞌhla naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ya chin basiaꞌgariiloh Pehdru, bwaꞌha ba nez dihtsi ba zeꞌnaꞌhla xpwiinn Jesuhs nin mahzi nadziiꞌhi Ñiꞌh, laꞌgahca ba nin gudxihxi yihca ñiꞌh nez loh stoꞌ Jesuhs chin gudahwchyinee Ñiꞌh xpwiinn Ñiꞌh, ya laꞌgahca za ba nin gunaabadxyiꞌdxyi loh Jesuhs, rahbi: “Chyuniꞌca guunn ntriehgu yiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ya chin bwaꞌha Pehdru loh ba, chiꞌchi rahbi Pehdru loh Jesuhs: ―Daada, ¿ya laꞌhaxchiꞌh bwiinn riiꞌ, cuun nin saca ba? ");
INSERT INTO zpvNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chiꞌchi rahbi Jesuhs loh Pehdru: ―Sidela naꞌh guiclaaꞌdzihn banabahan ba hasta chin guibiaꞌgariin stuhbi, ¿ya yiꞌh xiillampoorta luꞌhn? Nomahzi cun gudaꞌnaꞌhla naꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ya dxyiꞌdxyi riiꞌ bidiꞌchin loh raꞌ xpwiinn Jesucristu pur xpwiinn Ñiꞌh chi ayi ñahchi ba, per laꞌh Jesuhs ayi guñiꞌ dxiꞌh Ñiꞌh ayi ñahchi ba sino que rahbi Ñiꞌh: “Sidela naꞌh guiclaaꞌdzihn ba nabahan ba chin guibiaꞌgariin stuhbi, ya yiꞌh ¿xiillampoortan luꞌh?” ");
INSERT INTO zpvNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ya dee gahca naa xpwiinn Ñiꞌh chi nin bacaꞌh dxyiꞌdxyi raꞌ riiꞌ, naann nuꞌh guchii naa xchiꞌdxyi ba. ");
INSERT INTO zpvNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ya bwiꞌhnn Jesuhs ziahan ru sehn raꞌ cun dziꞌn roo raꞌ nin ayi caa loh dxihtsi riiꞌ, ya sidela ñicah garaa raꞌn, pwehda nin ayi ñahldaa gaduhbi loh guihdxyiyuh ñibwih chihbru raꞌ nin ñicah xcweenta dxyiꞌdxyi ru raꞌ chi.");
INSERT INTO zpvNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ya loh mwer xchihbruꞌhn, mihgu Tiófilo, laꞌn bacaꞌh loh luꞌh xcweenta garaa raꞌ dziꞌn nin bwiꞌhnn Jesucristu cun nin baluuꞌyi Ñiꞌh dez chin guzaꞌloh cayuhnn Ñiꞌh dziꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","cun para hasta dxyihyi nin bacah Ñiꞌh llaaꞌndxibaaꞌ. Ya antes nin nagahdxi gacah Ñiꞌh llaaꞌndxibaaꞌ; gulii Ñiꞌh xpooxtla Ñiꞌh. Ya pur Spíritu Saantu baluuꞌyi Jesuhs laꞌh raꞌ xpwiinn Ñiꞌh cuun dziꞌn nin nahpa guunn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ya que gudiiꞌdxi batiꞌdxiloh Jesuhs trabahju duxa, chiꞌchi gudxiinn raꞌ ba laꞌh Ñiꞌh, per lwehgu gahca babahn Ñiꞌh loh guelguhchi. Ya loh chywaꞌh gubihdxyi ziahanla bwelta baluuꞌyiloh Jesucristu loh raꞌ xpwiinn Ñiꞌh tin cagaluuꞌyi Ñiꞌh laꞌh raꞌ ba guchii paꞌh nabahan Ñiꞌh, neezaa bwiiꞌyidxyiꞌdxyi Ñiꞌh loh raꞌ ba xa naa guelrnabwaꞌ xteenn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Niꞌchin chin gudiiꞌdxi chywaꞌh dxyih raꞌ chi, chiꞌchi batiaaꞌha Jesucristu garaa xpwiinn ñiꞌ, tin gunabwaꞌ Ñiꞌh ayi gareꞌh raꞌ ba guidxyi Jerusalehn laasii nahpa cweeza raꞌ ba Spíritu Saantu nin guziꞌguehlda Dxiohs dxiꞌ guicaꞌha raꞌ ba. Chiꞌchi rahbi Ñiꞌh: ―Laꞌtu babihn nin guñiꞌn loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jwahn baroꞌbañihsa cun ñihsa si, per nnah zalliaaꞌyiꞌhn dxyih cayaꞌdxyi para dxiꞌ Spíritu Saantu tin cweezaa Ñiꞌh stoꞌ tu. Ya ziꞌchi chioobaañihsa tu cun Spíritu Saantu Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ya dxyih chi gahca badiaaꞌha raꞌ ba nez loh Jesuhs, rahbi raꞌ ba: ―Daada, ¿ta nnah gudiꞌhi za luꞌh guelrrnaabwaꞌ laꞌh raꞌ bwiinn Israel? ");
INSERT INTO zpvNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chiꞌchi rahbi Jesuhs loh raꞌ xpwiinn Ñiꞌh chi: ―Ayi ruhnn tucahri gacabwaꞌ tu xcweenta dxyih raꞌ, nee chieempa raꞌ nin sola laꞌ Dxiohs babwiꞌhnn Ñiꞌh lligaaba cuun nin guunn Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","per zicaꞌha tu Spíritu Saantu, tin cweezaa Ñiꞌh laꞌn lastoꞌ tu. Tin laꞌh Ñiꞌh guniꞌhi Ñiꞌh guelrnabwaꞌ laꞌh tu, tin chegatiꞌchi tu xchiꞌdxyiꞌhn tantu guihdxyi Jerusalehn coma ziga garaa raꞌ guihdxyi nin xnaabwaꞌ Judea, cun Samaria, neezaa gaduhbi guihdxyiyuh. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Guyaꞌloh si guñiꞌ Jesuhs dxyiꞌdxyi raꞌ riiꞌ bacah chiꞌh Ñiꞌh para llaaꞌndxibaaꞌ, ya gaduhbi nin riigataꞌtsi raꞌ ba laꞌh Ñiꞌh biduꞌbi tuhbi xcahyi laꞌh Ñiꞌh, ya ziꞌchi si biaꞌpa Ñiꞌh laꞌn xcahyi chi, ya ayi ru bwaꞌhatiiꞌ raꞌ ba laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ya gaduhbi nin riigataꞌtsi dziꞌtsi raꞌ ba llaaꞌndxibaaꞌ hasta biaꞌpa Jesuhs, dxyigahsi baluuꞌyiloh chiohpa xaanjla Dxiohs, nahcu raꞌ ba lahdxyi labweh, ya zuu raꞌ aanjla chi gahxu cweeꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Chiꞌchi rahbi aanjla raꞌ chi loh raꞌ ba: ―Bwiinn Galilea raꞌ, ¿xixnaa riigataꞌtsitiiꞌ tu llaaꞌndxibaaꞌ? Jesuhs nin bacah dxibaaꞌ nez delanta loh tu, ziga bwaꞌh tu bacah Ñiꞌh nnah ziꞌchi gahca za gwaꞌh tu chin dxiꞌ Ñiꞌh loh xcahyi stuhbi bwelta. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ya seguihdu babii raꞌ ba yihca tuhbi dahaniꞌhn nin laa dahan Olivo, dahaniꞌhn chi riaꞌhanan gahxu rwaaꞌ guihdxyi Jerusalehn. Gwah raꞌ ba nez dahan gahxu chigah, laasii tuhbi distancia chiꞌhzi rñiꞌ loh xlehyi Moisehs rahca rzah raꞌ bwiinn dxyih nin ruziꞌlaaꞌdzi raꞌ bwiinn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chin badzihn raꞌ ba para guihdxyi Jerusalehn bwaa raꞌ ba cwartu nin riaꞌhan yihca yuuꞌ chiohpa pihsu chi. Riꞌchi riaꞌhan Pehdru, Jacobo, Jwahn, Andrehs, Felipe, Tomahs, Bartolomeh, Mateu, Jacobo lliiꞌn Alfeu, Simohn nin guyuuꞌ lahda raꞌ Cananista, neezaa Judas bwihtsi Jacobo. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Riꞌchi guyuuꞌ raꞌ ba cun bwihtsi raꞌ Ñiꞌh, cun neezaa gunnaꞌh raꞌ, cun neezaa María xnaan Jesuhs. Ya garaa raꞌ ba tuhsi junta rbwihdxyi-rnaaba raꞌ ba Dxiohs tin gacanee Ñiꞌh laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ya laꞌn dxyih chi gahca badiaaꞌha raꞌ tuhbi gaywaꞌh gahlda xpwiinn Jesuhs, chiꞌchi gusuhnchii Pehdru galaayi raꞌ ba. Chiꞌchi rahbi Pehdru loh raꞌ bwiinn chi: ");
INSERT INTO zpvNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Cañiꞌn loh tu bwihtsi raꞌ, nahpa soobaa xchiꞌdxyi Spíritu Saantu xteenn Dxiohs nin bacaꞌh guehtu Davihd loh dxihtsi xcweenta Judas nin biuꞌn ntriehgu laꞌh Jesuhs loh raꞌ nin gunaꞌzu laꞌh Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Guhca Judas lasaaꞌ nuꞌh, bwiꞌhnn za ba laꞌh gahca dziꞌn nin dxudiꞌhnn nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Per nin bwiꞌhnn Judas gucaꞌha ba mweeyi chin biuꞌn ba ntriehgu laꞌh Jesuhs, ya chin guluhlla bwiꞌhnn ba dziꞌn dxaaba chi, chiꞌchi basiaꞌgarii ba mweeyi chi loh raꞌ nin bwiꞌhnn ba xtsiꞌn ñiꞌh, ya mweeyi chi bioꞌh tahyi loh yuh pur lah Judas. Laasii seguihdu laꞌh gahca ba baxiꞌh ba yahnn ba cun tuhbi duꞌh, ya chin guruuꞌgayaaꞌ duꞌh chi biaaba ba loh yuh guzuh yihca ba loh yuh ya guchixquiiꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ya chin gudiiꞌdxi dxiahga raꞌ bwiinn guihdxyi Jerusalehn ziꞌchi guhca, niꞌchin guleꞌhelah raꞌ ba yuh chi Haceldama, laazan yuh rihn. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Loh raꞌ dxihtsi nin laa Saalmos bacaꞌh guehtu Davihd dxyiꞌdxyi raꞌ riiꞌ: Dxiaꞌhan daꞌtsi yihdzi ba; nee ayi nin chuuꞌhun. Neezaa rahbi loh dxihtsi chi: Mejor chiꞌhyi raꞌ ba stuhbi bwiinn dxiuꞌgarii hasta naa ba dziꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Yannah nahpa cwii nuꞌh stuhbi ndxiꞌhw, nee nahpa gaca ba tuhbi bwiinn nin guzahnee laꞌh nuꞌh garaa dxyih raꞌ nin guyuuꞌnee Daada Jesucristu laꞌh nuꞌh ");
INSERT INTO zpvNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde dxyih nin guzoꞌbaloh baroꞌbañihsa Jwahn hasta dxyih nin bacah Jesuhs dxibaaꞌ tin bwiinn riiꞌ gacanee ba laꞌh nuꞌh gatiꞌdxi nuꞌh dxyiꞌdxyi raꞌ nin babahn Jesuhs loh raꞌ bwiinn guhchi. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chiꞌchi gulii raꞌ ba chiohpa ndxiꞌhw nin dxaꞌga loh raꞌ ba, tuhbi ba laa Joseh Barsabahs nin rñiꞌ raꞌ ba Justu cun stuhbi ba nin laa Matías. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pwihsi chiꞌchi gudihdxyi-gunaaba raꞌ ba laꞌh Dxiohs, squiiꞌ rahbi raꞌ ba: ―Daada Dxiohs nin rahcabwaꞌ lastoꞌ garaatiiꞌ nu, baluuꞌyi laꞌh nu cuun nin naa ndxiꞌhw nin laꞌluꞌh gulii loh garoopa ndxiꞌhw raꞌ riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tin dxiuꞌgarii ba guunn ba dziꞌn nin basaaꞌn Judas pur nin guyuuꞌ xtuhlda ba, laasii laꞌh Judas ba ziaa hasta bwiꞌhnn tucahri laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ya chiꞌchi gudzihta raꞌ ba dado tin gwaꞌha raꞌ ba cuun nin dxiuꞌgarii xlugahri Judas. Ya chin biaaba dado bigaꞌhanee Matías swerta tin biuꞌgarii ba xlugahri Judas, tin gubiaꞌgarii guhca raꞌ ba tsiꞌh bichiohpa xpooxtla Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chin badzihn dxyih nin rahca lañih xteenn Pentecostehs, rii garaa raꞌ xpwiinn Jesucristu tuhsi lahta laꞌn tuhbi yuuꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","chin guzoꞌbaloh cayuuꞌ bwih llaaꞌndxibaaꞌ zigazi tuhbi biduhn, ya guyuuꞌtii bwih duxa chi gaduhbi laꞌn yuuꞌ hasta zohba raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","chiꞌchi baluuꞌyiloh ziahan bwehliꞌhn nin xñah ziga luhdxyi bwiinn nez guiyaꞌ, ya bigaaꞌzi bwehliꞌhn raꞌ chi yihca cada tuhbigah raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ya garaa raꞌ ba guyuuꞌtii Spíritu Saantu Dxiohs laꞌn lastoꞌ raꞌ ba. Chiꞌchi guzoꞌbaloh cañiꞌ raꞌ ba guriin-guriin dxyiꞌzah ziga badꞌhi Spíritu Saantu xteenn Dxiohs guelrnabwaꞌ guiñiꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ya laꞌn dxyih raꞌ chi ziahan bwiinn Israel raꞌ nin zezahnee ziga baluuꞌyi Moisehs guunn raꞌ ba, badzihn raꞌ ba Jerusalehn nee zeꞌ raꞌ ba guriinn-guriin guihdxyi. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chin bihndxiahga raꞌ ba guyuuꞌ bwih duxa chi, badiaaꞌha raꞌ ziahanroo raꞌ bwiinn chi, nee badxyigaaꞌ duxa raꞌ ba laasii bwaꞌha raꞌ ba cañiꞌ raꞌ pooxtla dxyiꞌzah nin xñiꞌ cada tuhbi raꞌ bwiinn nin rii riꞌchii, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ya loh riiyadxyigaaꞌ bwiinn raꞌ chi, chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―¿Ta bwiinn Galilea raꞌgaa deeꞌ nin riiñiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xaxmohda naann raꞌ ba xchiꞌzah cada tuhbi raꞌ nuꞌh nin gulaanee nuꞌh?, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","nee laꞌhnuꞌh naa nuꞌh bwiinn ziitu nin zeꞌ cada stuhbi lahta raꞌ; ziga bwiinn Paartia, bwiinn Media, bwiinn regiohn Elahm, bwiinn Mesapotamia, bwiinn Judea, bwiinn estadu Capadocia, bwiinn regiohn Pontu, bwiinn Asia, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bwiinn Frigia cun bwiinn Panfilia, cun bwiinn Egiptu cun neezaa bwiinn distrihtu xteenn Africa. Loh raꞌ bwiinn nin zeꞌ Roma, nuu raꞌ nin riachiizistoꞌ raꞌñiꞌh xcweenta zigazi riachiistoꞌ raꞌ bwiinn Israel xreligiohn raꞌ ba, ya nuu za raꞌ ba desde guulaa raꞌ ba naa raꞌ ba bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","neezaa bwiinn Creta rii riiꞌ cun bwiinn Arabia. Yannah rihn nuꞌh cañiꞌ raꞌ bwiinn ca dxyiꞌzah nin rñiꞌ cada tuhbigah raꞌ guihdxyi raꞌ riiꞌ. Neezaa cun xchiꞌzah nuꞌh cañiꞌ raꞌ ba xcweenta dziꞌn roo raꞌ nin cayuhnn Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Garaa raꞌ ba riiyadxyigaaꞌ raꞌ ba, nin ayi gaann raꞌ ba xi lligaaba guunn raꞌ ba, chiꞌchi canaabadxyiꞌdxyi loh lasaaꞌ raꞌ ba, rahbi raꞌ ba: ―¿Xixniꞌca cayahca? ¿Xixnaa ayi rahcabwaꞌ nuꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Chiꞌchi guñiꞌ nuhn bwiinn raꞌ chi squiiꞌ loh raꞌ pooxtla: ―Pwehda riizuhdzii bwiinn raꞌ ca. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chiꞌchi gwasuꞌnchii Pehdru cun zatsiꞌh bituhbi pooxtla raꞌ, tin guñiꞌ Pehdru jweersiroo, rahbi ba: ―Yuꞌbitu bwiinn Judea raꞌ neezaa garaa raꞌ nin nuu raꞌ guihdxyi Jerusalehn, gulgahcaꞌdxiahga dxyiꞌdxyi nin guiñiꞌn loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ayi rzuhdzi dxiꞌh nu ziga ruhnn tu lligaaba. ¿Tayi rwaꞌha tu rsiiyiru ñiꞌ gueꞌdu xcagaꞌ ñiꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Deeꞌ cayahcan tin guzohba dxyiꞌdxyi ziga guñiꞌ profeta Joel xchiꞌdxyi Dxiohs cadxyih roo. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Rahbi Dxiohs: Zadzihn dxyih nin guixeꞌhlaꞌhn Spíritu Saantuhn tin cweezaa Ñiꞌh laꞌn lastoꞌ garaatiiꞌ bwiinn, nee lliiꞌngaꞌn tu lliiꞌndxaꞌpa tu ziñiꞌ za raꞌ bi xchiꞌdxyiꞌhn. Lliiꞌngaꞌn tu zwaꞌhaloh raꞌ bi mahziru cohsaroo, ya xtatitaguhla tu ziñiꞌ xcaꞌlda raꞌ ba cohsa raꞌ nin guluuꞌyiꞌhn laꞌhraꞌba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Guixeꞌhlaꞌhn Spíritu Saantuhn para garaa raꞌ nin chechiistoꞌ raꞌ ñiꞌh xchiꞌdxyiꞌhn ndxiꞌhw gunnaꞌh raꞌ, ya ziñiꞌ raꞌ ba xchiꞌdxyiꞌhn. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Guiyaꞌ llaaꞌndxibaaꞌ zwaꞌha tu cohsa roo nin gaca neezaa loh guidxyiyuh zwaꞌha tu ziꞌchi gahca sehn roo raꞌ nin gaca ziga rihn, bwehla, neezaa xcahyi gaca ziga guhxa. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ya loh gubihdxyi gacahyin, ya loh bweꞌhw gañahan zigazi rihn. Nahpaa gaca garaa raꞌ cohsa rii chiꞌchiyi gadzihn dxyih duxa nin dxieꞌldahn ziga naann Xtaada Dxiohs tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ya garaa bwiinn nin rbwihdxyilah Naꞌh zilaꞌh raꞌ ba loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Rahbiza Pehdru: ―Bwiinn Israel raꞌ, gulgahcaꞌdxiahga dxyiꞌdxyi raꞌ nin guiñiꞌn. Dxiohs baluuꞌyi laꞌh tu chyu naa Jesucristu nin zeꞌ Nazaret pur dziꞌn roo raꞌ, milahgru raꞌ, sehn raꞌ nin luꞌh bwiꞌhnn Ñiꞌh nezloh tu. Laꞌh gahca Dxiohs badiꞌhi guelrnabwaꞌ laꞌh Jesucristu niꞌchin bwiꞌhnn Ñiꞌh dziꞌn roo raꞌ chi. Laꞌtu naann la deeꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Per galohtiiꞌ laꞌh Dxiohs naann la xa guunnee tu laꞌh Jesucristu nin naa Lliiꞌn Ñiꞌh. Pura xigaaba gahca Ñiꞌh biuꞌn Ñiꞌh ntriehgu Lliiꞌn Ñiꞌh loh tu tin batiꞌdxi tu Ñiꞌh loh raꞌ bwiinn nadxaaba nin bacaꞌh laꞌh Ñiꞌh loh cruhzi tin guhchi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per lwehgu bacwaꞌhn Dxiohs laꞌh Jesucristu loh guelguhchi laasii ayi guyuuꞌ xtuhlda Ñiꞌh. Nee ayi ñahca ñicaꞌha guelguhchi laꞌh Jesuhs laasii rnabwaꞌ Ñiꞌh laꞌh guelguhchi. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chin babahn Jesuhs, guzohba dxyiꞌdxyi nin bacaꞌh guehtu rrehyi Davihd loh dxihtsi xcweenta Ñiꞌh; squiiꞌ guñiꞌ Davihd loh Dxiohs: Garaa dxyih rwaꞌhahn loh luꞌh Dxiohs, zuu luꞌh xlahdu derehchuꞌhn cayahcanee luꞌh naꞌh tin ayi guidxyihbi lastoꞌn. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Niꞌchin guñaazahn loh luꞌh pura taantu riahxiꞌhn laasii zucwaꞌhn luꞌh naꞌh chin gachiꞌhn; ");
INSERT INTO zpvNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nee ayiza gusaaꞌn luꞌh dxiaꞌhan xalmaꞌhn laꞌn baꞌ; ayiza gusaaꞌn luꞌh guudxyi tihxi Lliiꞌn luꞌh nin nadziiꞌhi luꞌh; ");
INSERT INTO zpvNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","laꞌluꞌh baluuꞌyi la naꞌh xa guibahanahn para tuꞌpazi, nee zusiahxi luꞌh naꞌh laasii guibahannee luꞌh naꞌh llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Rahbiza Pehdru: ―Bwihtsi raꞌ, guyaa guiñaan loh tu, nee naannza tu baaguhca cadxyihrooꞌ guhchi guehtu Davihd nee zee rañihchi gahca ba, baaguyuuꞌdziꞌtsi ba laꞌn baꞌ, per zahca guidiaꞌha nuꞌh xpaꞌ guehtu rrehyi Davihd. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Per guñiꞌ guehtu Davihd xchiꞌdxyi Dxiohs chin gubahan ba, ya biaꞌhandxyiꞌdxyinee paꞌh Dxiohs laꞌh Davihd nahpaa gudiꞌhi Dxiohs tuhbi llahga ba nin guiriaꞌhlah Crixtu, ya llahga rrehyi Davihd laꞌh Daada Jesucristu nin bwiꞌhnn gahn xlahdu derehchu Dxiohs, yannah naa Ñiꞌh rrehyi ziga guhca xtatita Davihd Ñiꞌh rrehyi, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","pwihsi baluuꞌyixgah Dxiohs cohsa raꞌ riiꞌ laꞌh rrehyi Davihd, niꞌchin guñiꞌ guehtu Davihd taꞌh Jesucristu loh raꞌ bwiinnguuchi laasii ayi gunnah Dxiohs ñiaꞌhan xahlma Jesucristu laꞌn gabihldxyi, nee ayiza gunnah Dxiohs ñuuꞌdxyi bweꞌhltihxi Jesucristu laꞌn baꞌ hasta bigaꞌtsi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Niꞌchin bacwaꞌhn Dxiohs laꞌh Jesucristu loh raꞌ bwiinnguuchi, laꞌhnu ziga xpwiinn Ñiꞌh bidiaꞌhaloh nu guhchi Ñiꞌh nee seguihdu gahca babahn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ya ziga babwihdxyi Dxiohs laꞌh Jesucristu ziaa Ñiꞌh llaaꞌndxibaaꞌ tin chuu Ñiꞌh xlahdu derehchu Xtaada Dxiohs Ñiꞌh ya badiꞌhi Dxiohs guelrnabwaꞌ laꞌh Jesucristu cun Spíritu Saantu tin gutiꞌdxi Ñiꞌh Spíritu Saantu para laꞌh raꞌ bwiinn guidxyiyuh, ya nin riiywaꞌha tu cun neezaa nin cayihn tu niꞌchipaꞌhn naa nin cayuhnn Spíritu Saantu. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Laasii ayi guehtu Davihd dxiꞌh naa nin bwaa llaaꞌndxibaaꞌ sino que Jesucristu bwaa xlawaaꞌha guehtu Davihd laasii laꞌh gahca guehtu Davihd rahbi: Guñiꞌ Dxiohs loh Daada nin rnabwaꞌ loon; rahbi Ñiꞌh: “Guzohba xlahdu derehchuꞌhn, ");
INSERT INTO zpvNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ya hasta que no gadzihn dxyih nin gutsiiꞌgaraꞌn bwiinn raꞌ nin rdxyiꞌchinee yiꞌh loh luꞌh tin gacabwaꞌ raꞌ ba yiꞌh rnabwaꞌ luꞌh garaatiiꞌ.” ");
INSERT INTO zpvNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Niꞌchin rñiꞌn loh tu ―rahbi Pehdru―, laꞌhtu nin bacaꞌh laꞌh Jesucristu loh cruhzi, bwiinn Israel raꞌ gulgahcabwaꞌ, laꞌDxiohs bazuh laꞌh Daada Jesucristu tin guinabwaꞌ Ñiꞌh laꞌhnuꞌh neezaa gutaꞌh Ñiꞌh laꞌhnuꞌh loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chin bihn raꞌ ba guñiꞌ Pehdru yihca raꞌba ziga naa raꞌ ba bwiinn nin bacaꞌh laꞌh Jesuhs loh cruhzi, bieꞌsuh guhca nalasastoꞌ raꞌ ba, chiꞌchi rahbi raꞌ ba loh Pehdru cun spaaldaa raꞌ pooxtla nin canee Pehdru riꞌchi: ―¡Ahyi bwihtsi raꞌ!, ¿xa niꞌcachiꞌh gachidiꞌhnn nu nnah? ");
INSERT INTO zpvNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Chiꞌchi rahbi Pehdru loh raꞌ ba: ―Gulgasaguꞌdzistoꞌ tu loh Dxiohs cun neezaa chioobaañihsa cada tuhbigah tu pur lah Jesucristu laasii ziꞌchi naa tuhbi sehn guzoꞌbadxiahga tu xchiꞌdxyi Jesucristu, nee tin ziꞌchiza zuhnn Dxiohs pardohn xtuhlda tu, ya chiꞌchiyi zuniꞌhi Dxiohs Spíritu Saantu laꞌhtu tin cweezaa Ñiꞌh laꞌn lastoꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Laasii xclaaꞌdzi Dxiohs guniꞌhi Ñiꞌh Spíritu Saantu Ñiꞌh laꞌhtu, neezaa lliiꞌn tu cun neezaa bwiinnziitu raꞌ, o sea garaa raꞌ bwiinn nin guntaaꞌyi Ñiꞌh gaca raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ya seguihdu gwazah ru guñiꞌ Pehdru ziahan roo ru dxyiꞌdxyi loh raꞌ bwiinn Israel raꞌ chi squiiꞌ: ―Gulguiriaꞌcaa loh raꞌ bwiinn nin rusahcaloh nin rii raꞌ loh guidxyiyuh nnah tin taꞌh tu loh jwiisi nin gaca. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ya guroꞌbañihsa garaa raꞌ bwiinn nin gwachiistoꞌ raꞌ ñiꞌh dxyiꞌdxyi raꞌ nin guñiꞌ Pehdru, ya dxyih chi gwabiiga ziga chohnna mihyi bwiinn tin biahca raꞌ ba tuhsi cun xpwiinn JesuCristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ya garaa raꞌ ba gwazahnee dziꞌtsi raꞌ ba dxyiꞌdxyi nayaa nin baluuꞌyi raꞌ pooxtla laꞌh raꞌ ba, cun biahxi duxa raꞌ ba nee, laasii tuhsi biahca raꞌ ba cun xpwiinn Jesucristu, cun tuhsi gudahw raꞌ ba cun xpwiinn Jesucristu, zigazi gudahwnee Jesucristu laꞌh raꞌ xpwiinn Ñiꞌh chin guyuuꞌnee Ñiꞌh laꞌh raꞌ ba, ya ziꞌchi badiaaꞌha raꞌ ba tuhsi lahta tin gudihdxyi-gunaaba raꞌ ba loh Dxiohs tin gacanee Ñiꞌh laꞌh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Badxyigaaꞌ duxa loh raꞌ bwiinn pur dziꞌn roo raꞌ nin bwiꞌhnn pooxtla raꞌ cun milahgru raꞌ nin bwiꞌhnn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ya garaa ziga gwachiistoꞌ raꞌ ba xchiꞌdxyi Dxiohs tuhsi nabahan raꞌ ba nee tuhsiza rnabwaꞌ raꞌ ba xixteenn lasaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ya guzaꞌloh batooꞌ raꞌ ba xixteenn raꞌ ba chiꞌchi bwiꞌhnn cumpahñu lasaaꞌ raꞌ ba segun bichiꞌhnn cada tuhbigah raꞌ ba mweeyi. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nee diahrutiiꞌ badiaaꞌha raꞌ ba laꞌn guidoꞌ cun tuhsi guhca xigaaba raꞌ ba. Ya de taantu riahxinee lasaaꞌ raꞌ ba, niꞌchin cada tuhbigah raꞌ ba baguhn lasaaꞌ raꞌ ba yihdzi cada tuhbigah raꞌ ba tin gudahwnee lasaaꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ya ziꞌchi mahziru gwazah guñiꞌ raꞌ ba chuhla naa Dxiohs, garaa raꞌ bwiinn guñiꞌ raꞌ ba xpwiinn Jesucristu naa raꞌ bwiinn zaꞌca. Ya niꞌchin dxyih cun dxyih gwazah gudahla raꞌ bwiinn nin riachiistoꞌ raꞌñiꞌh xchiꞌdxyi Jesucristu laasii cayahcanee Dxiohs cayahca ziahan raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tuhbi dxyih zee Pehdru cun Jwahn hasta zohba guidoꞌ rooꞌ zigachiꞌh xcachohnna gudxyih hohrachi naa hohra nin rbwihdxyi-rnaaba raꞌ bwiinn Israel laꞌh Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nee rwaaꞌ pweerta rooꞌ guidoꞌ nin lasahcaru riꞌchi rzohba tuhbi ndxiꞌhw nin ayi rzah desde chin guulaa ba, ya diahrutiiꞌ ruꞌa raꞌ lasaaꞌ ba laꞌh ba tin rianee raꞌ ba laꞌh bwiinn nin ralluuꞌn ñaaꞌ ñiꞌh rwaaꞌ guidoꞌ rooꞌ, tin rnaaba ba guhn loh raꞌ bwiinn nin riuuꞌtiiꞌ laꞌn guidoꞌ rooꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Per chin bwaꞌha ndxiꞌhw nin rahca ñaaꞌ ñiꞌh chi o sea ndxiꞌhw nin rbweꞌhe guhn zeyuuꞌtii Pehdru cun Jwahn rwaaꞌ guidoꞌ roo chi, chiꞌchi gunaaba ndxiꞌhw chi tuhbi guhn loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chiꞌchi bwaꞌhadziꞌtsi raꞌ chiꞌh Pehdru cun Jwahn loh ndxiꞌhw chi, chiꞌchi rahbi Pehdru loh ba: ―Bwaꞌha loh nu. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ya cagaldaꞌtsi ndxiꞌhw chi xohra ñudiꞌhi raꞌ ba guhn laꞌh ba, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","chiꞌchi rahbi Pehdru loh ba: ―Ayi naꞌpahn ohro ni plahta, per nin naꞌpahn zuniꞌhiñin yiꞌh; pur lah Jesucristu nin zeꞌ guihdxyi Nazaret, ¡gwazuꞌnchii, tin guzah! ");
INSERT INTO zpvNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ya chiꞌchi cun naa derehchu Pehdru gutesa ba laꞌh ndxiꞌhw nin rahca ñaaꞌ Ñiꞌh chi, ya lwehgu biaca ñaaꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ya loh tuhbidxiꞌh nin bwiꞌhnn ba pur bireꞌnchiehsa ba, lwehgu guzah ba, ya guyuuꞌtenee ba Pehdru cun Jwahn laꞌn guidoꞌ rooꞌ chi. Ya loh zeezah ba rreꞌnchiehsa ba nee neezaa cañiꞌ ba xa chuhla nin naa xquelrnabwaꞌ Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ya garaa raꞌ bwiinn nin rii laꞌn guidoꞌ bwaꞌha raꞌ ba rzah ndxiꞌhw chi nee cañiꞌ za ba pur chuhla nin naa Dxiohs, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ya bwiinn raꞌ nin rii laꞌn guidoꞌ badxyigaaꞌloh raꞌ ba nee neezaa bidxyihbi raꞌ ba pur nin guhca hohrchi, laasii nuꞌnbwaꞌ raꞌ ba laꞌh ba nin rzohba rwaaꞌ guidoꞌrooꞌ rbweꞌhe guhn. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ya ayi rusaaꞌn ndxiꞌhw nin biaca ñaaꞌ ñiꞌh laꞌh Pehdru cun Jwahn, niꞌchin garaa raꞌ bwiinn gwabiiga-galluꞌhn raꞌ ba hasta zuunee Pehdru cun Jwahn laꞌh ndxiꞌhw nin biaca ñaaꞌ ñiꞌh, ya badxyigaaꞌ duxa raꞌ bwiinn pur nin bwaꞌha raꞌ ba biaca ñaaꞌ bwiinn chi. Guhca deeꞌ rwaaꞌ curdohra xteenn Salomohn. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ya chin bwaꞌha Pehdru niꞌchi, chiꞌchi rahbi ba loh raꞌ bwiinn: ―Bwiinn Israel raꞌ, ¿xixnaa radxyigaaꞌtiiꞌ tu loh nu zigazi laꞌh nu bachidiꞌhnn nu para bazah bwiinn riiꞌ pur xquelrnabwaꞌ nu, o pur taantu nin nadziiꞌhi nu Dxiohs? ");
INSERT INTO zpvNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Xchiohs nuꞌh nin naa Xchiohs guehtu Abrahn, guehtu Isaac, neezaa guehtu Jacobo; laꞌh gahca Dxiohs riiꞌ badiꞌhi guelrnabwaꞌ rooꞌ laꞌh Lliiꞌn Ñiꞌh nin laa Jesuhs. Xlawaaꞌha ñuhnn cweenta tu laꞌh Ñiꞌh, laꞌhlaa mahziru gunaaba tu gudxiinn Pilahtu Ñiꞌh loh Pilahtu. Chin guclaaꞌdzi ba ñuldaꞌh ba laꞌh Ñiꞌh, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","laꞌh gahca tu ayi guclaaꞌdzi tu ñilaꞌh Ñiꞌh cun guñiꞌ tu ayi nuꞌnbwaꞌ tu Lliiꞌn saantu Dxiohs nin ruhnn ganaalla dziꞌn zaꞌca. Mejor gunaaba tu gulaꞌh Barrabahs, ndxiꞌhw nin gudxiinn bwiinn, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ya mahzi gudxiinn tu Bwiinn nin rniꞌhi guelnabahan, per lwehgu gahca bacwaꞌhn Dxiohs laꞌh Ñiꞌh loh raꞌ bwiinnguuchi, niꞌchin laꞌh nu naann nu laꞌÑiꞌh nabahan. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nin bwiꞌhnn para biuuꞌrihn ñaaꞌ bwiinn riiꞌ nin nuꞌnbwaꞌ tu, naan pur xquelrnabwaꞌ Jesucristu niꞌchin laꞌñaaꞌ ba biaca laasii gwachiistoꞌ ba dxyiꞌdxyi nin bachiñiꞌ nu loh ba, ziga riiywaꞌhaloh tu ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Rahbiza Pehdru: ―Bwiitsi raꞌ, laꞌn naannlaa ayi guhcabwaꞌ tu nin bwiꞌhnn tu, cun bwiinn raꞌ nin dziꞌbaloh ru loh tu, niꞌchin gudxiinn tu Jesuhs, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","per nahpaa guhca ziꞌchi laasii ziꞌchi caa loh xchihtsi Dxiohs nin bacaꞌh garaa raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs desde cadxyih rooꞌ. Nahpaa gutiꞌdxiloh Xcrixtu Dxiohs trabahjw duxa, tin guzohba dxyiꞌdxyi nin bwiꞌhnn Dxiohs lligaaba gaca. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Niꞌchin nnah gulgacuꞌdzi stoꞌ tu nee gulgabiaꞌgarii nez loh Dxiohs, nee tin gusiaꞌpitii Ñiꞌh xtuhlda tu, ");
INSERT INTO zpvNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nee tin cuꞌnehza za Dxiohs tuhbi lligaaba nasaa para laꞌn yihca tu, laasii zixeꞌhla Dxiohs Jesucristu nin bazuh Ñiꞌh desde cadxyihrooꞌ tin guinabwaꞌ Ñiꞌh laꞌh tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Per nnah ya nuu Jesucristu llaaꞌndxibaaꞌ, hasta gadzihn dxyih nin gusacuubi Dxiohs garaatiiꞌ raꞌ cohsa ziga biaꞌhan dxyiꞌdxyinee Ñiꞌh laꞌh raꞌ guehtu daada raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs desde cadxyih rooꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Laasii squiiꞌ guñiꞌ guehtu Moisehs loh raꞌ guehtaguhla xtatita roo raꞌ nuꞌh, rahbi ba: Xtaada Dxiohs nuꞌh zixeꞌhla Ñiꞌh tuhbi ndxiꞌhw ziga naꞌh nin cwii Ñiꞌh loh lasaaꞌ tu. Ziñiꞌ ba xchiꞌdxyi Dxiohs. Gulgazoꞌbadxiahga garaatiiꞌ dxyiꞌdxyi nin guiñiꞌ ba loh tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Laasii garaa raꞌ nin ayi guzoꞌbadxiahga xchiꞌdxyi ba ziñihchilohtiiꞌ raꞌ ba para tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Rahbiza Pehdru: ―Rzaꞌlohon desde guehtu Samwehl, cun garaatiiꞌ ndxiꞌhw nin zeenaꞌhla laꞌhba ziga guñiꞌ raꞌ ba xchiꞌdxyi Dxiohs, guñiꞌ raꞌ ba xcweenta raꞌ cohsa nin cayahca raꞌ laꞌn dxyih raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Laꞌhtu naa tu llahga raꞌ ndxiꞌhw raꞌ nin guñiꞌ xchiꞌdxyi Dxiohs, nee naa za tu llahga raꞌ ba laasii ziꞌchi biaꞌhannee dxyiꞌdxyi Dxiohs laꞌh raꞌ xtatita roo raꞌ nuꞌh chin rahbi Ñiꞌh loh guehtu xtatita Abrahn nuꞌh: “Pur tuhbi llahga luꞌh nin dxieꞌdxiahlda dxiꞌh zacataaꞌyi garaa raꞌ bwiinn guidxyiyuh, laasii zutaꞌh ba laꞌh raꞌ bwiinn loh duhlda.” ");
INSERT INTO zpvNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nee baxeꞌhla Dxiohs laꞌh Jesucristu mweergaloh loh tu, nee tin bwiꞌhnntaaꞌyi Ñiꞌh laꞌh tu, nee tin ayiru chezah tu xneziuh dxaaba tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Gaduhbi nin cañiꞌ gahca raꞌ ba loh raꞌ bwiinn raꞌ chi, badzihn raꞌ bixohza xteenn Israel cun ninluꞌh rnabwaꞌ laꞌh raꞌ guixaꞌga xteenn guidoꞌ rooꞌ cun nuhn bwiinn guidoꞌ nin laa Saduseu. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Rdxyiꞌchi duxa raꞌ ba laasii cagaluuꞌyi Pehdru cun Jwahn zabahan bwiinn loh guelguhchi pur nin babahn Jesuhs. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Niꞌchin gunaꞌzu raꞌ guxchiisi laꞌh raꞌ ba, per ziga gudxyihlan, nee ziga laꞌjusgahdu bieꞌwlaza hohrchi, niꞌchin bieꞌw raꞌ ba. Laꞌn lahtsi dxiꞌba riꞌchi basarah raꞌ ba gueꞌla. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ya loh bwiinn ziahan roo raꞌ ninluꞌh bihn xchiꞌdxyi raꞌ ba gwachiistoꞌ raꞌ bwiinn chi xchiꞌdxyi Dxiohs. Guhca raꞌ ba ziga gaꞌyu mihyi ndxiꞌhw. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ya seguihdu chin barah gueꞌla, badxaꞌgalasaaꞌ garaa raꞌ bwiinnguuhla cun nee raꞌ nin rnabwaꞌ raꞌ nez loh guihdxyi Jerusalehn, cun bwiinn raꞌ nin ruluuꞌyi lehyi, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","neezaa Anahs nin rnabwaꞌ laꞌh garaa raꞌ bixohza, neezaa Caifahs, Jwahn, Alejandru, nee neezaa garaa nin naa lasaaꞌ raꞌ bixohza rooꞌ raꞌ nin rnabwaꞌ rii raꞌ niꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chiꞌchi gunabwaꞌ raꞌ ba bieꞌ Pehdru cun Jwahn gurih galaayi raꞌ ba tin gunabadxyiꞌdxyi raꞌ ba loh Pehdru cun Jwahn squiiꞌ: ―¿Chyu xquelrnabwaꞌ nahpaa tu? ¿Chyu laa bazeꞌta tu tin basiaca tu ndxiꞌhw riiꞌ? ");
INSERT INTO zpvNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Per Pehdru, ziga ya gadxah lastoꞌ ba Spíritu Saantu xteenn Dxiohs, niꞌchin rahbi ba loh raꞌ ba: ―Daada guxchiisi raꞌ, cun bwiinn guhla raꞌ xteenn bwiinn Israel, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","laꞌh tu rnabadxyiꞌdxyi tu xa mohda bidxiacanee nu laꞌh ndxiꞌhw riiꞌ o xa pur biaca ba, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","yaque laꞌh tu rnabadxyiꞌdxyi tu niꞌchin nnah gachiñiꞌ xnehza nu loh tu nee neezaa loh garaa raꞌ bwiinn guihdxyi Israel, Jesucristu nin bacaꞌh tu loh cruhzi, laꞌDxiohs bacwaꞌhn laꞌh Ñiꞌh loh guelguhchi ya pur lah Ñiꞌh basiaca nu laꞌh bwiinn nin zuu nez loh tu riiꞌ nazaꞌca nnah, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ya laꞌhtu ayi gwachiistoꞌ tu xchꞌdxyi Jesucristu. LaꞌhÑiꞌh naa ziga tuhbi dxiah nin luꞌh rbweꞌcaa tu chin ruhnnchaꞌyi tu tuhbi yuuꞌ, per Dxiohs laꞌÑiꞌh bwiꞌhnn naa Jesucristu ziga dxiah ninluꞌh mahziru nazaꞌca nin guyuuꞌ xchihn xteenn yuuꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ayi xa taꞌh bwiinn loh duhlda xcweenta zuu zi bwiinn, laasii ayi stuhbi lah bwiinn loh guidxyiyuh riiꞌ ziga nin caꞌha Jesucristu nin gulaꞌloh laꞌh raꞌ bwiinn guidxyiyuh tin para gaca taꞌh nuꞌh loh duhlda. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chin bihn raꞌ ba dxyiꞌdxyi nin guñiꞌ Pehdru, badxyigaaꞌloh raꞌ ba laasii ayi bidxyihbi Pehdru cun Jwahn, nee ayiza batuhyi loh raꞌ ba guñiꞌ raꞌ ba dxyiꞌdxyi raꞌ chi. Chiꞌchi rahbi loh lasaaꞌ raꞌ bixohza nin lasahcaru: ―Per naꞌnncabwaꞌ ayi gwah raꞌ ba scwehyi, bwiinnzi raꞌ ba. Chiꞌchi guhcabwaꞌ raꞌ ba guzahnee Pehdru cun Jwahn laꞌh Jesucristu, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ya niꞌchin ayi xi guñiꞌtiiꞌ raꞌ ru ba laasii bwaꞌhaloh raꞌ ba laꞌbwiinn nin zunee Pehdru cun Jwahn biaca ñaaꞌ ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chiꞌchi gunabwaꞌ raꞌ bixohza biriaꞌh raꞌ Pehdru cun Jwahn cun nin biaaca ñaaꞌ ñiꞌh chi tuhbi lahdu nez dihtsi yuuꞌ tin bwiiꞌyidxyiꞌdxyi raꞌ bixohza laꞌhsi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chiꞌchi rahbi loh lasaaꞌ raꞌ ba: ―¿Xa niꞌca gachidiꞌhnnee nuꞌh ndxiꞌhw raꞌ ca? Garaa raꞌ bwiinn Jerusalehn naann xcweenta dziꞌn roo duxa nin bwiꞌhnn raꞌ ba. Aadxi nuu gaziaꞌtii nu xtsiꞌn raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","per tin ayi guidiꞌchii xchiꞌdxyi Jesucristu caallaa stuhbi guihdxyi, mejor gachidiꞌtsi nu loh gadxiohnna raꞌ ba ayiru cheezah guiñiꞌ raꞌ ba xchiꞌdxyi Jesucristu loh cuun chiꞌh zi bwiinn raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chiꞌchi gudihdxyi raꞌ bixohza chi laꞌh Pehdru cun Jwahn tin guñiꞌ ba, rahbi raꞌ ba: ―Ayi cheezah ru tu guluuꞌyi tu xchiꞌdxyi Jesucristu, nee ayiru za guzeꞌta tu lah Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Chiꞌchi guñiꞌ Pehdru cun Jwahn, rahbi raꞌ ba loh raꞌ bixohza chi: ―Gulguiñiꞌ loh nu chyu xchiꞌdxyi mahzi gacaꞌdxiahga nu; ¿ta xchiꞌdxyi tu, o xchiꞌdxyi Dxiohs?, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","tin laꞌhnu ayi chyu gucweꞌza guiñiꞌ nin bidiaꞌha nu cun nin bihn dxiahga nu. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ya bwaꞌha si bixohza raꞌ chi ayi bidxeela raꞌ ba xa ñuhnnee ru raꞌ ba laꞌh Pehdru cun Jwahn, chiꞌchi guñiꞌchihpa raꞌ ba ayiru cheezah guluuꞌyi raꞌ Jwahn cun Pehdru xchiꞌdxyi Jesucristu laꞌh raꞌ bwiinn, chiꞌchi bataꞌh raꞌ bixohza chi laꞌh raꞌ ba laasii cañiꞌ raꞌ bwiinn bwiꞌhnn raꞌ ba tuhbi dziꞌn zaꞌca. Ziahan raꞌ bwiinn cañiꞌ chuhla naa Dxiohs laasii pur nin guhca riꞌchi. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ya ndxiꞌhw nin biaca pur xquel milahgru Dxiohs nuu ba chywaꞌh yihza. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yaque gulaꞌh Pehdru cun Jwahn cun neezaa bwiinn nin biaca ñaaꞌ ñiꞌh, gwaguiaꞌha raꞌ ba cuun lasaaꞌ raꞌ ba nin naa xpwiinn Jesucristu, riꞌchi bwiiꞌyidxyiꞌdxyi raꞌ ba garaa nin guñiꞌ raꞌ guxchiisi xteenn raꞌ bixohza cun nin naa raꞌ bwiinn guhla loh raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chin bihn raꞌ xpwiinn Jesucristu dxyiꞌdxyi raꞌ chi, chiꞌchi tuhsi junta cun tuhsi lligaaba bwiꞌhnn raꞌ ba tin gudihdxyi-gunaaba raꞌ ba loh Dxiohs, rahbi raꞌ ba: ―Xtaada Dxiohs nu nin bwiꞌhnnchaꞌyi llaaꞌndxibaaꞌ cun guidxyiyuh, cun ñiꞌhsadoꞌ nee cun nin rii nabahan loh raꞌn, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yuꞌbiluꞌh bwiꞌhnn luꞌh bazoꞌbadxiahga guehtu Davihd xchiꞌdxyi Spíritu Saantu niꞌchin nin bacaꞌh ba xchiꞌdxyi luꞌh riiꞌ: ¿Xinaa riuuꞌ duxa raꞌ bwiinn guidxyiyuh guelrzaaꞌ xcweenta nin ayi naa siguhra guunn raꞌ ba gahn guunn raꞌ ba? ");
INSERT INTO zpvNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nee badxaꞌgalasaaꞌ raꞌ rrehyi raꞌ loh guidxyiyuh cun guxchiisi xteenn raꞌ guihdxyi tin guziaꞌtee raꞌ ba xtsiꞌn Luꞌh tin ayiru za dxihn raꞌ ba xchiꞌdxyi Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Laꞌdxyiꞌdxyi riiꞌ guzohba, laasii loh guihdxyi riiꞌ laꞌh Herodes cun Ponciu Pilahtu cun neezaa bwiinn Israel cun bwiinn ziitu nin ayi naa bwiinn Israel laꞌh raꞌ ba badxaꞌgalasaaꞌ riiꞌ, tin bidxyiꞌchinee raꞌ ba Lliiꞌn luꞌh nin naa Crixtu nin guxeꞌhla luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Niꞌchin nnah babwiꞌhnn raꞌ ba dziꞌndxaaba ziga nin galoh guñiꞌ luꞌh gaca. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yannah, bwaꞌha Daada Dxiohs cuun raꞌ cohsadxaaba nin cañiꞌ raꞌ ba gusaꞌcazii raꞌ ba laꞌh nu, per bwiꞌhnn cumpahñu laꞌh nu, tin gacanadxipalaaꞌdzi nu tin ayi guidxyihbi nu gachiñiꞌ nu xchiꞌdxyi luꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Daꞌnee xquel rnabwaꞌ luꞌh laꞌh nu tin gasiaca nu bwiinn raꞌ tin guidiꞌhnn zaꞌca nu dziꞌn roo raꞌ, milahgru raꞌ cun xquelrnabwaꞌ Lliiꞌn saantu luꞌh nin laa Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chin guluhlla gunaaba raꞌ ba gacanee Dxiohs laꞌh raꞌ ba, guzoꞌbaloh cañiꞌbi raꞌ yuuꞌ hasta rii raꞌ ba, cayahca ziga tuhbi lluh. Chiꞌchi badzihn Spíritu Saantu xteenn Dxiohs tin guyuuꞌchihpa ru Ñiꞌh lastoꞌ raꞌ ba tin ayiru bidxyihbi raꞌ ba guñiꞌ raꞌ ba xchiꞌdxyi Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Garaa raꞌ nin luꞌh gwachiistoꞌ raꞌ ñiꞌh xchiꞌdxyi Dxiohs, tuhsi lligaaba bwiꞌhnn raꞌ ba. Ayiru nin tuhbi raꞌ ba nin ñuhnn ñinabwaꞌ xixteenn raꞌ ñiꞌh. Mas bachaꞌga lasaaꞌ raꞌ ba xixteenn raꞌ ba ya nin xchiꞌhnn si raꞌ ba xcaꞌha raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Guhcanee Dxiohs laꞌh raꞌ pooxtla tin baluuꞌyi raꞌ ba guchiipaꞌhcaa babahn Jesucristu loh guelguhchi nee neezaa cayahcanee duxa Dxiohs laꞌh garaa raꞌ xpwiinn Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nin tuhbi raꞌ ba ayi biaꞌdxyi xixteenn raꞌ ñiꞌh laasii nin gohpaa loh yuh batooꞌ raꞌ ban, chiꞌchi gwanee raꞌ ba mweeyi, ");
INSERT INTO zpvNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tin badiꞌhi raꞌ ba mweeyi chi laꞌh raꞌ pooxtla, ya pooxtla raꞌ gudxiꞌzi mweeyi chi loh garaa raꞌ nin luꞌh xchiꞌhnnan. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ya guyuuꞌ tuhbi ndxiꞌhw nin laa Joseh, lahdxyi ba naa Chipre, nin rii loh ñihsadoꞌ. Naa ba lasaaꞌ raꞌ xjwamiyi Levita, ya pooxtla raꞌ guleꞌhelah laꞌh ba Bernabeh nin zee loh xchiꞌdxyi raꞌ ba bwiinn nin rbahchidxyiistoꞌ lasaaꞌ raꞌñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ya laꞌh Bernabeh batooꞌ ba tuhbi taaꞌha loh xuh ba, chiꞌchi badiꞌhi ba mweeyi nin gucaꞌha ba laꞌh raꞌ pooxtla. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per neezaa guyuuꞌ tuhbi ndxiꞌhw nin laa Ananías. Cheꞌhla ba biriaꞌlah Safihra, ya batooꞌ raꞌ ba tuhbi taaꞌha loh yuh. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías riiꞌ biaꞌhanee ba nuhn mweeyi, ya snuhnan badiꞌhi ba laꞌh raꞌ pooxtla laasii xigaaba garoopa raꞌ ba guhca niꞌchi, ya lwehgu guhcabwaꞌ pooxtla garoolda si mweeyi yuh chi niꞌchi, ");
INSERT INTO zpvNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","chiꞌchi rahbi Pehdru loh ba: ―Ananías, ¿xi naa bazoꞌbadxiahga luꞌh xchiꞌdxyi Satanahs nin rnabwaꞌ loh raꞌ bwiinndxaaba? Ayi Dxiohs si dxiꞌh guclaaꞌdzi luꞌh gusaguiꞌhi luꞌh sino que nee Spíritu Saantu xteenn Dxiohs, laasii biaꞌhannee luꞌh garoolda mweeyi nin batooꞌ luꞌh loh yuh. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Chin gueꞌdu cayuhnn luꞌh lligaaba gutooꞌ luꞌh yuh chi ¿tayi xteenn dxiꞌh luꞌhn?, neezaa chin gucaꞌha luꞌh mweeyi nin gudooꞌ loh yuh chi, ¿tayi xteenn dxiꞌh luꞌhn? ¿Xi naa chiꞌh bwiꞌhnn luꞌh lligaaba laꞌn lastoꞌ luꞌh guñiꞌ luꞌh dxyiꞌdxyi xihn chi loh Dxiohs ayi loh dxiꞌh tuhbi ndxiꞌhw? ");
INSERT INTO zpvNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chin guyaꞌloh bihn Ananías dxyiꞌdxyi raꞌ nin guñiꞌ Pehdru, biaaba ba loh yuh guhchi ba. Ya garaa bwiinn nin bihn dxyiꞌdxyi raꞌ chi bidxyihbi duxa raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lwehgu gwabiiga nuhn biꞌnxtuhbi batuꞌbi raꞌ bi laꞌh Ananías lahdxi, chiꞌchi bagacaꞌtsi raꞌ bi laꞌh Ananías. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pwehda guhca la chohnna hohra guhchi Ananías chin badzihn cheꞌhla ba nin laa Safihra, nin ayi gaann ba xi guzahca cheꞌhla ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chiꞌchi rahbi Pehdru loh Safihra: ―Guñiꞌ, ¿ta batooꞌ tu xuh tu ziga prehsiu nin gunah tu gurihin? ―Uhn, ziga prehsiu nin gurihin batooꞌ nun ―rahbi Safihra loh Pehdru. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chiꞌchi rahbi Pehdru loh Safihra: ―¿Xi naa bwiꞌhnn tu lligaaba ñusaguiꞌhi tu Spíritu Saantu xteenn Dxiohs? Rwaaꞌ leeꞌ laꞌh raꞌ nin bagacaꞌtsi laꞌh cheꞌhla luꞌh zieꞌ raꞌ. Nnah neezaa yiꞌh chegacaꞌtsi raꞌ bi. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lwehgu biaaba Safihra loh yuh guhchi za ba. Ya chin badzihn raꞌ biꞌnxtuhbi raꞌ chi stuhbi bwaꞌha raꞌ bi guhchi Safihra, chiꞌchi lwehgu gahca bagacaꞌtsi raꞌ bi laꞌh ba cweeꞌ hasta bigaꞌtsi cheꞌhla ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ya garaa xpwiinn Jesucristu bidxyihbi duxa raꞌ ba, cun neezaa bwiinn raꞌ nin luꞌh bihn cohsa raꞌ riiꞌ bidxyihbi za raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ziahan raꞌ dziꞌn rooꞌ cun milahgru raꞌ bwiꞌhnn raꞌ pooxtla nezloh raꞌ bwiinn guihdxyi. Ya badxaꞌgalasaaꞌ raꞌ xpwiinn Jesucristu laꞌn curdohra xteenn Salomohn, per tuhsi naa xigaaba raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Guyuuꞌ ziahan bwiinn nin adxi bachaꞌga loh raꞌ xpwiinn Jesucristu laasii bidxyihbi raꞌ ba guchaꞌga raꞌ ba laꞌh raꞌ ba. Ya bwiinn guihdxyi raꞌ chi guñiꞌ zaꞌca duxa raꞌ ba laꞌh xpwiinn Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nee laꞌn dxyih gahca raꞌ chi gudahla duxa raꞌ bwiinn nin riachiistoꞌ ñiꞌh xchiꞌdxyi Jesucristu, ndxiꞌhw gunnaꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ya hasta guleꞌhe raꞌ ba bwiinn nin rahcalluꞌhu raꞌ loh neziuh, tin chin tiidxi Pehdru gahxu hasta naꞌ raꞌ bwiinn nin rahcalluꞌhu chi mas xpacaala Pehdru tiidxi yihca raꞌ ba, tin dxiaca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ziahan bwiinn raꞌ nin zeꞌ stuhbi guihdxyi badzihn raꞌ ba guihdxyi Jerusalehn, zeꞌnee raꞌ ba bwiinn raꞌ nin cayahca lluꞌhu cun bwiinn raꞌ nin nuu bwiinndxaaba laꞌn lastoꞌ ñiꞌh, ya cun xquelrnabwaꞌ Jesucristu basiaca raꞌ pooxtla laꞌh raꞌ bwiinn nin rahcalluꞌhu babweꞌheza raꞌ ba bwiinndxaaba laꞌn lastoꞌ raꞌ bwiinn raꞌ chi. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chiꞌchi bidxyiꞌchi bixohza nin rnabwaꞌ cun lasaaꞌ ba nin laa Saduseu raꞌ, laasii cayantsiiꞌhi bwiinn guihdxyi laꞌh pooxtla raꞌ chi pur nin cagasiaca raꞌ ba bwiinn raꞌ nin rahcalluꞌhu. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Niꞌchin gunaꞌzu raꞌ ba pooxtla raꞌ tin basieꞌw raꞌ ba laꞌh raꞌ ba laꞌn lahtsi dxiꞌba, ");
INSERT INTO zpvNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","per gueꞌla chi gahca gwah tuhbi aanjla Dxiohs rwaaꞌ lahtsi dxiꞌba chi tin babweꞌhe ba laꞌh raꞌ pooxtla laꞌn lahtsi dxiꞌba chi, chiꞌchi rahbi aanjla chi loh raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gulcheh guidoꞌ rooꞌ tin riꞌchi gulguiñiꞌ loh raꞌ bwiinn xa gaca guibahannee raꞌ ba Dxiohs par tuꞌpazi. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chin bihn raꞌ ba xchiꞌdxyi aanjla chi, chin barah gueꞌla rsiiyidoꞌ guyuuꞌnehza raꞌ ba zee raꞌ ba laꞌn guidoꞌ rooꞌ tin riꞌchi baluuꞌyi raꞌ ba xchiꞌdxyi Dxiohs laꞌh raꞌ bwiinn. Ya bixohza ninluꞌh rnabwaꞌ cun bwiinn guhla raꞌ badxaꞌga lasaaꞌ raꞌ ba cun guxchiisi xteenn guidoꞌ, neezaa garaa raꞌ guxchiisi xteenn raꞌ bwiinn Israel. Chiꞌchi gunabwaꞌ raꞌ ba zeecaꞌha raꞌ guixaꞌga laꞌh raꞌ pooxtla ninluꞌh ñieꞌw laꞌn lahtsi dxiꞌba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Chin badzihn raꞌ guixaꞌga rwaaꞌ lahtsi dxiꞌba, bwaꞌha raꞌ ba laꞌn lahtsi dxiꞌba chi, ayila chyu nuu laꞌn lahtsi dxiꞌba chi, chiꞌchi gubiaꞌgarii raꞌ ba baganee raꞌ ba dxyiꞌdxyi loh raꞌ guxchiisi nin rnabwaꞌ, rahbi raꞌ ba: ");
INSERT INTO zpvNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Chin badzihn nu rwaaꞌ lahtsi dxiꞌba laꞌn ñeꞌwdziꞌtsi gahca neezaa suldahdu raꞌ nin riiyahpaa rwaaꞌ lahtsi dxiꞌba chi laꞌh raꞌ ba rii gahca raꞌza, chiꞌchi baxaala nu rwaaꞌ chi per ayi chyu nuula laꞌn chi. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chin bihn bixohza nin rnabwaꞌ cun capitahn nin luꞌh rnabwaꞌ laꞌh raꞌ guixaꞌga xteenn guidoꞌ rooꞌ, neezaa raꞌ bixohza, bwiꞌhnn chiohpa stoꞌ raꞌ ba, rahbi loh lasaaꞌ raꞌ ba: ―¿Xi niꞌca guhca? ¿Xa niꞌca gaca nnah? ―rahbi raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chiꞌchi badzihn tuhbi ndxiꞌhw, rahbi ba loh raꞌ ba: ―Ndxiꞌhw raꞌ nin basieꞌw tu laꞌn lahtsi dxiꞌba, laꞌraꞌba rii laꞌn guidoꞌ rooꞌ, cagaluuꞌyi raꞌ ba bwiinn ―rahbi ndxiꞌhw chi. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chiꞌchi zeenee capitahn nin rnabwaꞌ laꞌh raꞌ guixaꞌga xteenn guidoꞌ rooꞌ tin bagalliꞌhi raꞌ ba pooxtla raꞌ chi, per ayi basaꞌcazii raꞌ ba pooxtla raꞌ chi laasii rdxyihbi raꞌ ba ñucaꞌh raꞌ bwiinn dxiah yihca raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chin badzihnnee raꞌ ba pooxtla raꞌ chi, guhdzi raꞌ ba cwiih raꞌ ba nezloh raꞌ guxchiisi xteenn Israel, chiꞌchi guñiꞌ bixohza nin rnabwaꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","rahbi ba loh raꞌ pooxtla: ―¿Tayi ba banabwaꞌdxiꞌh nu laꞌhtu tin ayiru guiñiꞌ tu xchiꞌdxyi Jesucristu? ¿Xixnaa chiꞌh nnah zeezahtiiꞌ tu cagaluuꞌyi tun laꞌh raꞌ bwiinn guihdxyi Jerusalehn laasii laꞌhtu xclaaꞌdzi tu gucaꞌchiah tu laꞌhnu bachidxiinn nu Jesucristu? ");
INSERT INTO zpvNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chiꞌchi rahbi Pehdru cun pooxtla raꞌ loh raꞌ ba: ―Nnah nahpaa gazoꞌbadxiahga nu xchiꞌdxyi Dxiohs xlawaaꞌha gazoꞌbadxiahga nu xchiꞌdxyi raꞌ tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Laꞌhtu gudxiinn tu Jesucristu laasii bacaꞌh tu Ñiꞌh loh cruhzi. Ya Xchiohs xtatita roo nuꞌh bataꞌh laꞌh Ñiꞌh loh raꞌ bwiinnguuchi. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nnah laꞌh Ñiꞌh bazuh xlahdu derehchu Xtaada Dxiohs Ñiꞌh nin rnabwaꞌ llaaꞌndxibaaꞌ tin gucaꞌha Ñiꞌh guelrnabwaꞌ laasii guinabwaꞌza Ñiꞌh nee cun neezaa xclaaꞌdzi Ñiꞌh guibiaꞌcaa xtuhlda garaa raꞌ bwiinn Israel cun xclaaꞌdziza Ñiꞌh gusaguꞌdzi lastoꞌ raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bidiaꞌhaloh nu xi bwiꞌhnn Dxiohs, niꞌchin zeezah cagaluuꞌyi nu xchiꞌdxyi Jesucristu, nee Spíritu Saantu xteenn Dxiohs cagaluuꞌyi laꞌhnu guchiipaꞌcaa xcweenta dxyiꞌdxyi raꞌ nin raluuꞌyi nu cun neezaa cohsa nin bidiaꞌhaloh nu, nee bwiinn nin gaguuꞌdzistoꞌ raꞌñiꞌh zudiꞌhi Dxiohs Spíritu Saantu laꞌh raꞌ garaa bwiinn nin guzoꞌbadxiahga xchiꞌdxyi Ñiꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chin bihn raꞌ guxchiisi dxyiꞌdxyi raꞌ chi, bidxyiꞌchi duxa raꞌ ba laasii badiꞌhi raꞌ ba cweenta duhlda roo nahpaa raꞌ ba, ya xclaaꞌdzi raꞌ ba ñidxiinn raꞌ ba pooxtla raꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Chiꞌchi gwasuꞌnchii tuhbi ndxiꞌhw nin laa Gamaliel nin luꞌh naa tuhbi fariseu nin ruluuꞌyi lehyi xteenn Moisehs, ya ziahan bwiinn rucaꞌdxiahga xchiꞌdxyi ba. Chiꞌchi gunabwaꞌ Gamaliel bariaꞌh raꞌ pooxtla laꞌn yuuꞌ chi tuhbi carrih. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chiꞌchi rahbi Gamaliel loh raꞌ bixohza cun bwiinn raꞌ nin rii riꞌchi: ―Yuꞌbitu bwiinn Israel raꞌ, gulguiꞌhnn zaꞌca lligaaba xa niꞌca xclaaꞌdzi tu guunnee tu ndxiꞌhw raꞌ riiꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gulgazaꞌstoꞌ tu nagahdxi gaca xchih guyuuꞌ tuhbi ndxiꞌhw nin laa Teudas, rahbi ba rnabwaꞌ duxa ba, gwanaꞌhla za tahpa gaywaꞌh bwiinn laꞌhba, nee guhchi si ba nezii nee ziꞌchi bidiꞌchii garaa raꞌ xpwiinn ba ya ayiru xi bwiꞌhnn raꞌ xpwiinn ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ya laꞌn yihza nin guyuuꞌ seensu, biriaꞌhza Judas nin zeꞌ Galilea. Ya ziahan za bwiinn nin gwanaꞌhla laꞌhba, nee guhchiza ba ya ziꞌchi gahca nezii nee ziꞌchi za bidiꞌchi za xpwiinn ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nnah rñiꞌn gulguiriaꞌhcaa, gulgasaaꞌn ndxiꞌhw raꞌ riiꞌ, laasii sidelaa xcweenta si raꞌ ba rñiꞌ raꞌ ba zahca ñichilohon, ");
INSERT INTO zpvNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","per sidelaa xtsiꞌn Dxiohsan cayuhnn raꞌ ba, adxi guunn tu gahn gucweꞌza tu xtsiꞌn Dxiohs niꞌchin rñiꞌn gulguiꞌhnn lligaaba tin ayi guidxiꞌhyi nuꞌh xa guidxyihldxinee nuꞌh yuꞌbi Dxiohs nin rnabwaꞌ llaaꞌndxibaaꞌ. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ya garaa raꞌ ba gwasaa raꞌ ba dxyiꞌdxyi raꞌ nin guñiꞌ Gamaliel, niꞌchin mejor gudihdxyi si raꞌ ba laꞌh raꞌ pooxtla gunaaba raꞌ ba gucaꞌyahga raꞌ pooxtla neezaa gunabwaꞌ raꞌ ba ayiru cheezah guiñiꞌ raꞌ pooxtla xchiꞌdxyi Jesucristu, chiꞌchi bataꞌh raꞌ ba laꞌh raꞌ pooxtla. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ya seguihdu gulaꞌh raꞌ ba loh raꞌ guxchiisi neezaa riahxi duxa raꞌ ba laasii bwiꞌhnn lasahca Dxiohs laꞌh raꞌ ba pur nin batiꞌdxiloh raꞌ ba trabahjw xcweenta Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ya guillii-guillii xchiꞌdxyi chiꞌhsi Jesucristu baluuꞌyi raꞌ ba laꞌn guidoꞌ rooꞌ neezaa rwaaꞌ yihdzi raꞌ bwiinn bagaluuꞌyi raꞌ ba xchiꞌdxyi Dxiohs cun rahbiza raꞌ ba loh raꞌ bwiinn: ―Jesuhs naa Crixtu nin cabweeza tu. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Laꞌn dxyih chi gahca, ziahan roo duxa la naa raꞌ xpwiinn Jesucristu. Ya bwiinn raꞌ nin rñiꞌ dxyiꞌdxyi griehgu cadxyiꞌchi raꞌ ba laasii mahzi xcaꞌha raꞌ ru viuhda raꞌ nin rñiꞌ dxyiꞌdxyi hebreu xi gahw raꞌ ba chin rgaꞌzin, ya laꞌh raꞌ ba ayi rcaꞌha zaꞌca raꞌ ba xi gahw raꞌ ba chin rgaꞌzin garaa dxyih. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chiꞌchi gucaꞌha gadziꞌh bichiohpa raꞌ pooxtla batiaaꞌha raꞌ ba garaa xpwiinn Jesucristu, ya chiꞌchi rahbi raꞌ pooxtla loh raꞌ xpwiinn Jesucristu: ―Ayi naa xnehza gasaaꞌn nu guel ruluuꞌyi xchiꞌdxyi Dxiohs laasii ayi xchiempa nu chiꞌzi nu xi gahw raꞌ bwiinn loh mweella. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Niꞌchin nnah nahpaa cwii tu loh lasaaꞌ tu gahdzi ndxiꞌhw nin luꞌh naann tu naa bwiinn zaꞌca nin nuu Spíritu Saantu xteenn Dxiohs laꞌn lastoꞌ raꞌ ñiꞌh ya ndxiꞌhw raꞌ chi chiꞌzi xi gahw raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ya laꞌhnu choozah nu cwidxi-guinaaba nu loh Dxiohs, nee choozah nu galuuꞌyi nu xchiꞌdxyi Ñiꞌh laꞌh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ya garaatiiꞌ bwiinn raꞌ chi biuuꞌstoꞌ raꞌ ba dxyiꞌdxyi raꞌ chi, chiꞌchi gulii raꞌ ba tuhbi ndxiꞌhw nin laa Esteban ndxiꞌhw riiꞌ riachii duxa stoꞌ ba xchiꞌdxyi Dxiohs nee nuu chihpa za Spíritu Saantu stoꞌ ba. Neezaa Felipe, Prócoro, Nicanor, Timohn, Parmenahs, cun neezaa Nicolahs. Ndxiꞌhw riiꞌ bwiinn Antioquía ba nee naa za ba tuhbi proselite naa ba tuhbi bwiinn nin ayi naa bwiinn Israel per guzoꞌbaloh bazoꞌbadxiahga ba xlehyi guehtu Moisehs antes nin nagahdxi dxihn ba xchiꞌdxyi Jesucristu. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ya lwehgu gwanee raꞌ xpwiinn Crixtu gagahdzi ndxiꞌhw raꞌ chi loh raꞌ pooxtla tin gudihdxyi-gunaaba raꞌ pooxtla loh Dxiohs xcweenta ndxiꞌhw raꞌ chi neezaa badziiꞌba naa raꞌ ba yihca raꞌ ndxiꞌhw raꞌ chi ziga tuhbi sehn laꞌraꞌba guyuꞌtii loh xtsiꞌn raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bidiꞌchi duxa xchiꞌdxyi Dxiohs. Ziahan bwiinn guihdxyi Jerusalehn bazoꞌbadxiahga xcweenta ziga rnabwaꞌ xchiꞌdxyi Dxiohs cun neezaa ziahan bixohza. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gwachii duxa stoꞌ Esteban xchiꞌdxyi Dxiohs, niꞌchin badiꞌhi Spíritu Saantu jweersi rooꞌ laꞌh ba cun lligaaba nasiin tin bwiꞌhnn ba dziꞌn rooꞌ raꞌ, milahgru raꞌ nezloh raꞌ bwiinn. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ya bwiinn guidoꞌ raꞌ nin laa libertidos cun bwiinn Cirene, bwiinn Alejandria, bwiinn Cilicia, nee neezaa bwiinn Asia guzoꞌbaloh raꞌ ba cadxihldxinee dxyiꞌdxyi raꞌ ba laꞌh Esteban. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ndxiꞌhw raꞌ riiꞌ ayi guhca ñusiaꞌgarii raꞌ ba dxyiꞌdxyi loh Esteban laasii cayahcanee Spíritu Saantu xteenn Dxiohs laꞌh ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chiꞌchi badiꞌhi raꞌ ba mweeyi laꞌh snuhn raꞌ ndxiꞌhw nin ayi naa xpwiinn Jesuhs tin bachiꞌhyi raꞌ ba laꞌh raꞌ ndxiꞌhw raꞌ chi guiñiꞌ ba loh raꞌ bwiinn: ―Bihn dxiahga nu cañiꞌyah Esteban laꞌh guehtu Moisehs cun Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Squiiꞌ bachiꞌhyi raꞌ ndxiꞌhw raꞌ chi laꞌh gaduhbi guihdxyi bwiinn cun neezaa mwehsu nin ruluuꞌyi lehyi cun neezaa bwiinn guhla raꞌ tin gunaꞌzu raꞌ ba Esteban. Ya chiꞌchi gwanee raꞌ ba laꞌh ba loh raꞌ guxchiisi xteenn Israel. ");
INSERT INTO zpvNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ya gudxiꞌhyi raꞌ ba spaaldaa ndxiꞌhw nin guñiꞌ dxyiꞌdxyi xihn, rahbi raꞌ niꞌchi: ―Uhn, guchii rñiꞌyah Esteban lehyi xteenn guehtu Moisehs cun neezaa xquidoꞌ rooꞌ saanta riiꞌ, ");
INSERT INTO zpvNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","neezaa bihndxiahga nu guñiꞌ Esteban: “Jesuhs nin zeꞌ Nazaret gutsihyi guidoꞌ rooꞌ, zuchaꞌhza ba lehyi nin luꞌh baniꞌhi guehtu Moisehs laꞌhnu.” ");
INSERT INTO zpvNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chiꞌchi bwaꞌha raꞌ nin rnabwaꞌ cun bwiinn raꞌ loh Esteban, bwaꞌha raꞌ ba ruhnn loh ba ziga ruhnn loh tuhbi xaanjla Dxiohs. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chiꞌchi gunaaba dxyiꞌdxyi bixohza nin luꞌh rnabwaꞌ, rahbi ba loh Esteban: ―¿Ta guchii ziꞌchi guñiꞌ luꞌh? ");
INSERT INTO zpvNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Chiꞌchi rahbi Esteban loh raꞌ ba: ―Gulgahcaꞌdxiahga dxyiꞌdxyi nin guiñiꞌn loh tu daada, bwihtsi lasaaꞌ raꞌn; Xchiohs nuꞌh nin lasahca duxa nin rnabwaꞌ, baluuꞌyi laꞌh guehtu xtatita Abrahn nuꞌh chin guyuuꞌ ba lahdxyi raꞌ bwiinn Mesapotamia chin nagahdxi chuu ba laꞌn guihdxyi Harahn. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chiꞌchi rahbi Dxiohs loh guehtu Abrahn: “Biriaꞌh lahdxyi luꞌh basaaꞌn garaa raꞌ lasaaꞌ luꞌh tin gwah hasta chiꞌh zi guluuꞌyiꞌhn yiꞌh.” ");
INSERT INTO zpvNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chiꞌchi biriaꞌh guehtu Abrahn lahdxyi bwiinn Caldea, tin gwah chuu ba loh guihdxyi Harahn. Ya chin guhchi xtaada ba, bieꞌganee Dxiohs laꞌh guehtu Abrahn loh yuh hasta rii guihdxyi riiꞌ hasta dxuu nuꞌh nnah ―rahbi Esteban loh raꞌ ba―. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ayi gunnah Dxiohs ñusaaꞌnlaaꞌdzi Ñiꞌh nin tahyi loh yuh hasta guzuh tuhbi ñaaꞌ guehtu Abrahn tin luꞌh rahbi Dxiohs yuh chi zudiꞌhi Ñiꞌhn laꞌh raꞌ llahga guehtu Abrahn. Nee laꞌh guehtu Abrahn ayi lliiꞌn ba chieempa chi. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Rahbiza Dxiohs loh guehtu Abrahn: “Lliiꞌn raꞌ luꞌh llahga raꞌ luꞌh zibwih raꞌ bi zigazi bwiinnziitu, lahdxyi bwiinn gaca raꞌ bi mooza, riꞌchi zusaꞌcazii bwiinn laꞌh raꞌ bi zigachiꞌh tahpa gaywaꞌh yihza.” ");
INSERT INTO zpvNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Neezaa rahbi Dxiohs: “Zuꞌnnahn caxchihgu laꞌh raꞌ bwiinn nin gusaꞌcazii laꞌh raꞌ bi, per naꞌh gabweꞌhehn llahga raꞌ luꞌh riꞌchi tin guzuꞌnllihbi raꞌ bi loon loh guihdxyi riiꞌ” ―rahbi Dxiohs. Chiꞌchi rahbi Esteban loh garaa bwiinn nin rii riꞌchi: ");
INSERT INTO zpvNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","―Ziꞌchi biaꞌhannee dxyiꞌdxyi Dxiohs laꞌh guehtu Abrahn gunabwaꞌ Dxiohs guchiuuꞌga Abrahn laꞌh gahca ba hasta naa ba ndxiꞌhw tin chuu ba bwaꞌ, niꞌchi naa tuhbi sehn xteenn dxyiꞌdxyi nin biaꞌhannee dxyiiꞌdxyi Dxiohs laꞌh Abrahn. Ya seguihdu guyuuꞌ tuhbi lliiꞌn guehtu Abrahn nin biriaꞌhlah guehtu Isaac, ya chin guyuuꞌ bi xuhnnaa dxyih, guluuꞌ za guehtu Abrahn laꞌh bi bwaꞌ ziga tuhbi sehnza. Ziꞌchi gahca za bwiꞌhnnee Isaac lliiꞌn ba nin biriaꞌhlah Jacob. Ziꞌchi gahca za bwiꞌhnnee guehtu Jacob laꞌh raꞌ lliiꞌn ba nin guhca raꞌ xpwiinn guldooꞌ bwiinn Israel ―rahbi Esteban―. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Loh raꞌ lliiꞌn Jacob nin guhca xpwiinn guldooꞌ nuꞌh cadxyih rooꞌ, biriaꞌh tuhbi bwihtsi raꞌ ba nin biriaꞌhlah Joseh, ya guzahca llahn stoꞌ raꞌ ba laꞌh Joseh tin batooꞌ raꞌ ba Joseh laꞌh tuhbi bwiinn nin gwanee laꞌhbi guihdxyi Egiptu, per Dxiohs bwiꞌhnn cumpahñu laꞌh Joseh. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Chin batiꞌdxiloh ba trabahjw duxa badiꞌhi Ñiꞌh guelnasiinn laꞌh ba, ya cun guelnasiinn nin badiꞌhi Dxiohs laꞌh Joseh biuꞌstoꞌ rrehyi Faraohn guhca Joseh gobernadohr xteenn guihdxyi Egiptu, neezaa gunabwaꞌ Joseh garaatiiꞌ xixteenn rrehyi chi. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ya badzihn tuhbi gubihn, garaa raꞌ laꞌn guidxyi nin rnabwaꞌ Egiptu, neezaa laꞌn guihdxyi raꞌ nin rnabwaꞌ Canaan, ya guehtu xtaada guldooꞌ raꞌ nuꞌh trabahjw duxa batiiꞌdxi raꞌ ban loh guelrchiaꞌhan ayi guyuuꞌtiiꞌ xi ñahw raꞌ ba, ");
INSERT INTO zpvNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","per chin gudiiꞌdxidxiahga guehtu Jacob nuu xi gahw raꞌ ba laꞌn guihdxyi Egiptu chiꞌchi guxeꞌhla ba lliiꞌn ba tin gwacaꞌha raꞌ bi xi gudahw raꞌ ba tuhbi bweelta hasta guihdxyi Egiptu. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ya chin baroopa bweelta riah raꞌ bi, chiꞌchi rahbi Joseh loh raꞌ bi: “Bwiꞌtsihn laꞌh tu”, chiꞌchiyi guhcabwaꞌza Faraohn cuun nin naa raꞌ bwihtsi Joseh. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chiꞌchi guxeꞌhla Joseh dxyiꞌdxyi tin gwah guehtu Jacob xtaada Joseh guihdxyi Egiptu, ya garaa raꞌ ba naa ziga setenta y cinco raꞌ ba. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ziꞌchi guhca tin gwah guehtu Jacob guihdxyi Egiptu, ya riꞌchi guhchi guehtu Jacobo cun guehtu xtaada guldooꞌ raꞌ nuꞌh. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ya seguihdu gwanee raꞌ ba xtsihta raꞌ ba loh yuh Siquehn tin bacaꞌtsi raꞌ ban laꞌn baꞌ nin nuu loh yuh raꞌ hasta guziꞌ guehtu xpaah Abrahn nuꞌh, loh raꞌ lliiꞌn Hamohr laꞌn guihdxyi Siquehn. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ya chin badzihn gahxu dxyih, ziga biaꞌhannee dxyiꞌdxyi Dxiohs laꞌh guehtu xpaah Abrahn nuꞌh, chiꞌchi gudahla duxa raꞌ xpwiinn Israel laꞌn guihdxyi Egiptu. ");
INSERT INTO zpvNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chiꞌchi guyuuꞌ tuhbi rrehyi Egiptu nin ayi biuꞌnbwaꞌ laꞌh guehtu Jos