﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpuNT_vpl;
CREATE TABLE zpuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpuNT_vpl WRITE;
INSERT INTO zpuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ganni nyoj ra beꞌnn kaꞌ gok xozxtaꞌo Jesucristonꞌ, beꞌnnenꞌ gok Xhiꞌnn dialla David, naꞌ Davidenꞌ gokeꞌ xhiꞌnn dialla Abraham. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham naꞌ gokeꞌ xa Isaac, naꞌ Isaakenꞌ gokeꞌ xa Jacob, naꞌ Jacobenꞌ gokeꞌ xa Judá ren yezikre biꞌcheꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Naꞌ Judánꞌ ren Tamar naꞌ, gok akeꞌ xaxhnaꞌ Fares ren Zara. Naꞌ Fares naꞌ gokeꞌ xa Esrom, naꞌ Esrom naꞌ gokeꞌ xa Aram. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Naꞌ Aram naꞌ gokeꞌ xa Aminadab, naꞌ Aminadab naꞌ gokeꞌ xa Naasón, naꞌ Naasón naꞌ gokeꞌ xa Salmón. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón naꞌ, ren Rahab gok akeꞌ xaxhnaꞌ Booz. Naꞌ Booz naꞌ, ren Rut gok akeꞌ xaxhnaꞌ Obed. Naꞌ Obed naꞌ gokeꞌ xa Isaí. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Naꞌ Isaínꞌ gokeꞌ xa rey David, naꞌ rey Davidenꞌ gokeꞌ xa Salomón. Naꞌ xhnaꞌ Salomón naꞌ gokeꞌ xhoꞌr Urías. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Naꞌ Salomón naꞌ gokeꞌ xa Roboam, naꞌ Roboam naꞌ gokeꞌ xa Abías, naꞌ Abías naꞌ gokeꞌ xa Asa. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Naꞌ Asa naꞌ gokeꞌ xa Josafat, naꞌ Josafat naꞌ gokeꞌ xa Joram, naꞌ Joram naꞌ gokeꞌ xa Uzías. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasenꞌ gokeꞌ xa Jotam, naꞌ Jotam naꞌ gokeꞌ xa Acaz, naꞌ Acazenꞌ gokeꞌ xa Ezequías. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Naꞌll Ezequíasenꞌ gokeꞌ xa Manasés, naꞌ Manasésenꞌ gokeꞌ xa Amón, naꞌ Amón naꞌ gokeꞌ xa Josías. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasenꞌ gokeꞌ xa Jeconías ren yelaꞌ biꞌcheꞌ kaꞌ bniꞌt, ka llanꞌ bcheꞌe beꞌnn Babilonia kaꞌ beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bde gok kaꞌ, naꞌll gorje Salatiel xhiꞌnn Jeconías. Naꞌ Salatielenꞌ gokeꞌ xa Zorobabel. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Naꞌ Zorobabelenꞌ gokeꞌ xa Abiud, naꞌ Abiud naꞌ gokeꞌ xa Eliaquim. Naꞌ Eliaquim naꞌ gokeꞌ xa Azor. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Naꞌ Azor naꞌ gokeꞌ xa Sadoc, naꞌ Sadoc naꞌ gokeꞌ xa Aquim, naꞌ Aquim naꞌ gokeꞌ xa Eliud. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Naꞌ Eliud naꞌ gokeꞌ xa Eleazar, naꞌ Eleazar naꞌ gokeꞌ xa Matán. Naꞌ Matán naꞌ gokeꞌ xa Jacob. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Naꞌll Jacobenꞌ gokeꞌ xa José beꞌnnenꞌ gok xhyio María. Naꞌ María naꞌ gok xhnaꞌ Jesús beꞌnnenꞌ nziꞌi Cristo, lleꞌnen nen beꞌnn brej Diosenꞌ sorén yel llnebiaꞌ keꞌen lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Naꞌ bzorao kanꞌ bllaꞌa xhiꞌnn dialla da Abraham naꞌ, bllinte kanꞌ bllaꞌa xhiꞌnn dialla da David, zaꞌa chdaꞌ (14) kwen dialla keꞌe kaꞌ, naꞌ xhiꞌnn dialla da Davidenꞌ bllinte ka lla beꞌx akeꞌ beꞌnn Israel kaꞌ, bcheꞌe akeꞌ leakeꞌ Babilonianꞌ, bllaꞌa ye chdaꞌ kwen dialla keꞌe kaꞌ. Kanaꞌ bllinte ka llanꞌ gorje Cristonꞌ, bllaꞌa ye chdaꞌ kwen dialla keꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kinꞌ gok kanꞌ gorj Jesucristonꞌ. Maríanꞌ ba nak diꞌll siꞌi Josénꞌ leꞌe wchaynaꞌa akeꞌ. Bixha ka gokbeꞌe Josénꞌ, ba noaꞌ Maríanꞌ bdaꞌo kone Spíritu ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naꞌ Josénꞌ beꞌnnenꞌ ba nak diꞌll siꞌi Maríanꞌ, gokeꞌ beꞌnn wen rao Dios. Naꞌll beneꞌ xhbab chaꞌ kwej yichjeꞌ Maríanꞌ llillize, naꞌ bi wsieꞌ Maríanꞌ zdoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nna llonteꞌ xhbab kaꞌ, bdekze bichgal keꞌe, kate to angl beꞌnn bseꞌl Xanllo Dios, broeꞌraweꞌ leꞌe rao bichgal keꞌen, naꞌll lleꞌe leꞌe: —José, rweꞌ gorjoꞌ rao dialla ke rey David. Bi lleboꞌ siꞌo Maríanꞌ xhoꞌroꞌ, ka nak bidaꞌon so naꞌ, bidaꞌo ke Spíritu ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Naꞌ bidaꞌon so naꞌ gakbeꞌ to bidaꞌo byio, naꞌ wsiꞌo rabeꞌ Jesús, le Lebeꞌn yekaꞌbeꞌ doꞌl ke beꞌnn yell kebeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gok yeolol da kaꞌ nench gok kanꞌ bne Diosenꞌ, kanꞌ bzoj to beꞌnn beꞌe xtiꞌlleꞌn kanaꞌ, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","To noꞌr weꞌo noꞌr nna napchiꞌi kwineꞌ, weꞌe to bidaꞌo byio. Naꞌ kat sobeꞌ naꞌ, wsiꞌi akebeꞌ Emanuel. Naꞌ Emanuelenꞌ lleꞌnen nen: Diosenꞌ zorenkzeꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naꞌll babando Josénꞌ, bayoll bnereꞌ yerenꞌ, beneꞌ kanꞌ goll angl ke Diosenꞌ leꞌe, naꞌll jaxieꞌ Maríanꞌ rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Naꞌ bi bzoreneꞌ leꞌe ka to beꞌnn zo ren xhoꞌreꞌ, to bzoazeꞌ leꞌe bdapeꞌ leꞌe baraꞌnne, bllinte lla bzo bidaꞌo byio keꞌen. Naꞌ bsieꞌbeꞌ Jesús. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ka llanꞌ llnebiaꞌ rey Herodes, gorj Jesúsenꞌ ganꞌ nziꞌi Belén, to yell ganꞌ nbane Judea. Naꞌ Jerusalén naꞌ bllin to chop beꞌnn siꞌn beꞌnn nziꞌi magos, zaꞌk akeꞌ do ganꞌ llraꞌ willre. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Naꞌ bnnab akreꞌ beꞌnn rao yell kaꞌ, lle akeꞌ leakeꞌ: —¿Gann rey ke beꞌnn Israel kaꞌ, beꞌnnenꞌ ne akeꞌ ba braꞌ? Nnézetoꞌ ba gorjeꞌ, le breꞌtoꞌ berj keꞌen ganꞌ llraꞌ willre, naꞌllenꞌ zaꞌtoꞌ zadyeꞌraotoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ka bene rey Herodesenꞌ kaꞌ, to bitkraꞌn gokreꞌ, leskaꞌ yeolol beꞌnn Jerusalén kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Naꞌll batop reyenꞌ yeolol bxoz wnebiaꞌ ke beꞌnn Israel kaꞌ, naꞌ leskaꞌ yeolol beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ. Naꞌ bnnabreꞌ leakeꞌ, garenꞌ ne akeꞌ garj Cristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Naꞌll goll beꞌnn kaꞌ Herodesenꞌ: —Belén naꞌ garjeꞌ ganꞌ nbane Judea, le kaꞌn llia danꞌ bzoj to beꞌnn beꞌe xtiꞌll Diosenꞌ kanaꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ka nak yell Belén ganꞌ llaꞌa dialla ke da Judánꞌ, naksen yell da zaꞌke rao yell wnebiaꞌ kaꞌ zjalliꞌ ganꞌ nbane Judeanꞌ. Le to beꞌnn Belén naꞌ gakeꞌ beꞌnn wnebiaꞌ, naꞌ Leꞌe gakeꞌ beꞌnn braonꞌ rao yeololte beꞌnn Israel, le leakeꞌn nak beꞌnn kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Naꞌll goxh Herodesenꞌ beꞌnn siꞌn kaꞌ nziꞌi magos llillize nench jakeꞌ raweꞌn, naꞌll bnnabreꞌ leakeꞌ batyaꞌnnenꞌ breꞌe akreꞌ braꞌ berjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naꞌll bseꞌleꞌ leakeꞌ Belén naꞌ, lleꞌe leakeꞌ: —Lechejchk, lelljawiá, lelljadirj bidaꞌon to lloaꞌ. Naꞌ kate yellélerebeꞌn, yeddixjweꞌre nadaꞌ, nench naꞌ chaꞌa lljeꞌrawabeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bayoll bene beꞌnn siꞌn kaꞌ nziꞌi magos kanꞌ goll reyenꞌ leakeꞌn, naꞌll broꞌ akeꞌ nez. Naꞌll berj danꞌ breꞌe akreꞌ ganꞌ llraꞌ willenꞌ, zejen leꞌ yebánꞌ lliaraon rao akeꞌn, bllinten yoꞌ ganꞌ zo bidaꞌo naꞌ, naꞌ jasén. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Naꞌll llawé beꞌnn siꞌn kaꞌ kwis ka breꞌe akreꞌ berjenꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Naꞌll ka bllin akeꞌ yoꞌ ganꞌ zo bidaꞌon ren xhnaꞌbeꞌ Maríanꞌ, naꞌll bcheꞌk xhib akeꞌ, ben akebeꞌ xhen. Naꞌll bsarj akeꞌ danꞌ noꞌx akeꞌn, naꞌ brej akeꞌ ya chaꞌo danꞌ nziꞌi oro, naꞌ yare, naꞌ to da laꞌ xhix da nziꞌi mirra, naꞌ beꞌe akeꞌn kebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Naꞌ ka nna niꞌt beꞌnn siꞌn kaꞌ Belén naꞌ, bdixjweꞌ Diosenꞌ leakeꞌ rao bichgale, bill yedé akeꞌ ganꞌ zo Herodesenꞌ. Naꞌll bakaꞌa akeꞌ ye to nez yobre, ballín akteꞌ rall akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Naꞌ ka ba zayej beꞌnn siꞌn kaꞌ, to angl ke Xanllo Dios broeꞌraweꞌ Josénꞌ rao bichgale, naꞌ lleꞌe leꞌe: —Byas, bcheꞌe bidaꞌon ren xhnaꞌbeꞌn, lelljak ganꞌ nziꞌi Egipto, naꞌ gannaꞌ sore, naꞌ kate netellaꞌ, kanaꞌll wak wayedre, le Herodes naꞌ llayirjebeꞌ nench gotebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Naꞌll le byaste Josénꞌ, bcheꞌe bidaꞌon ren xhnaꞌbeꞌ, naꞌ zjakeꞌ Egiptonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naꞌll bzo akeꞌ Egipto naꞌze chak bllin lla got Herodesenꞌ, naꞌ kaꞌ gok kanꞌ bne Diosenꞌ danꞌ bzoj to beꞌnn beꞌe xtiꞌll Diosenꞌ kanaꞌ, bneꞌe: “Ganꞌ nziꞌi Egipto naꞌ, bayaxhaꞌ xhiꞌnnaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Naꞌll ka gokbeꞌe rey Herodes kanꞌ bene beꞌnn siꞌn kaꞌ leꞌe, ka nak bill badé akeꞌ ganꞌ zoeꞌn, naꞌll goklleꞌe kwis. Naꞌ bseꞌleꞌ beꞌnn wakaꞌa ya keꞌe kaꞌ nench jet akeꞌ yeolol bidaꞌo byio zerao bi de chop ize, le kaꞌt byi bsaꞌke nak bidaꞌon llayirjeꞌ. Naꞌ jet akeꞌ bi kaꞌ gorj ak Belén naꞌ, naꞌ yezikre yell daꞌo kaꞌ nechj Belén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naꞌ danꞌ bet akeꞌ bidaꞌo kaꞌ, bzoa diꞌll kanꞌ bzoj da Jeremías, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ llian: ");
INSERT INTO zpuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nente chiꞌi beꞌnn Ramá, ka llasbell akeꞌ niꞌt akeꞌ yel wan. Noꞌr kaꞌ nake xhiꞌnn dialla da Raquel llayaꞌchraꞌll akeꞌ, llak akreꞌ ke xhiꞌnn akeꞌ daꞌo kaꞌ, naꞌ bi lleꞌn akreꞌ no yeyoeꞌ leakeꞌ yel llxhenraꞌlle, le ba wasaꞌt akbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ka bde got Herodesenꞌ, to beꞌnn nak angl ke Xanllo Dios broeꞌraweꞌ Josénꞌ rao bichgale ka nna zoeꞌ Egiptonꞌ, naꞌ lleꞌe leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Nnaꞌ byas bacheꞌe bidaꞌon ren xhnaꞌbeꞌ naꞌ, naꞌ lelljayak Israel naꞌ. Ba got beꞌnn kaꞌ llayirj bidaꞌon nench yesoꞌtebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naꞌll bayas Josénꞌ, bacheꞌe bidaꞌon naꞌ ren xhnaꞌbeꞌ, naꞌ jayakeꞌ yell ke akeꞌ Israelenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bixha ka bene Josénꞌ ba zo Arquelaonꞌ llnebieꞌ roraz da xeꞌe Herodes naꞌ, naꞌll bllebeꞌ wayejeꞌ do ganꞌ nbane Judea. Naꞌll bdixjweꞌ Diosenꞌ leꞌe rao bichgale, bi llayaꞌleꞌ lljayakeꞌ Judeanꞌ, naꞌ lljayakeꞌ ganꞌ nziꞌi Galilea naꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naꞌ ke len naꞌ ballín akeꞌ Nazaretenꞌ, naꞌ jazó akeꞌ gannaꞌ. Naꞌ kaꞌ bzoa diꞌll kanꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, bne akeꞌ: “Wsiꞌi akeꞌ Leꞌe beꞌnn Nazaret.” ");
INSERT INTO zpuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bde zan iz, kate Juan beꞌnnenꞌ bchoa nisenꞌ byejeꞌ latj dachenꞌ do ganꞌ nbane Judea. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Naꞌll bllin beꞌnn kaꞌ ganꞌ zoeꞌn, naꞌ bdixjweꞌreꞌ leakeꞌ, lleꞌe leakeꞌ: —Lewayate ke da xhinnj ba benre, le ba bllin lla nnebiaꞌ Dios beꞌnnenꞌ zo yebánꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ke Juan naꞌ bzoj da Isaías beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, naꞌ bneꞌe: Beꞌnnenꞌ nne zillj latj dachenꞌ, neꞌe: “¡Legón xhnid, legonchaꞌo nez ganꞌ te Xanllonꞌ, lewsarj yichjraꞌlldaꞌore ka llon to beꞌnn llsarj to nez li!” ");
INSERT INTO zpuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Naꞌ xha Juan naꞌ goken de yich xha camello, naꞌ bchej lloaꞌ leꞌen to yid, naꞌ bdaweꞌ bichsoa ren blliꞌndaꞌo ke beser yiꞌxe. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Beꞌnn llaꞌa yell Jerusalén naꞌ, naꞌ beꞌnn llaꞌa yeolol yell kaꞌ ganꞌ nbane Judea, naꞌ leskaꞌ beꞌnn kaꞌ zjallaꞌa yell kaꞌ nechj yeo Jordán naꞌ, bazaꞌa akeꞌ jak akeꞌ ganꞌ zo Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Naꞌ bxoarap akeꞌ bi da xhinnj kaꞌ non akeꞌn, naꞌll bchoa Juan naꞌ leakeꞌ nis lo yeo Jordán naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Leskaꞌ jak zan beꞌnn Israel kaꞌ beꞌnn kaꞌ nziꞌi fariseo, naꞌ beꞌnn kaꞌ nziꞌi saduceo. Jakeꞌ nench bchoa Juan naꞌ leakeꞌ nis. Naꞌ ka breꞌe Juan naꞌ leakeꞌn, naꞌll lleꞌe leakeꞌ: —¡Reꞌ nakre beꞌnn zban beꞌnn wxhiyeꞌe, llonre ka bele! ¿No bzejnieꞌ reꞌ, wak warare rao danꞌ wseꞌl Diosenꞌ katenꞌ goneꞌ yel koxchis ke beꞌnnachenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chaꞌ rennere ba bayátere ke da xhinnjenꞌ nonre naꞌ, llayaꞌl gonre da wen nench gakbeꞌe beꞌnne ba ballaꞌa yichjraꞌlldaꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bi gonzre xhbab nnere: “Xhiꞌnn dia lla Abraham netoꞌ.” Yej kaꞌ niꞌt nga, wakte gon Diosenꞌ wayaken xhiꞌnn dialla Abraham. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Leskaꞌ ba noꞌxteꞌ banchenꞌ xhnid, yeolol yay da bi llbia daxhix wen, wchoyeꞌ do roe, gaken waye da wzeyeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nadaꞌ da li llchoaꞌ reꞌ nis chaꞌ wayátere ke da xhinnjenꞌ nonre, zan za zaꞌre ye to beꞌnne goneꞌ nench choꞌ Spíritu ke Diosenꞌ lo yichjraꞌlldaꞌorenꞌ, da llon ka llon yiꞌ. Naꞌ beꞌnnenꞌ za zaꞌa koꞌllraꞌ zaꞌklleꞌ ka nadaꞌ, ni jeze da yelaꞌ xhereꞌn bi gak gonaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Katenꞌ yedeꞌn, goneꞌ ka llon beꞌnn kate llsoeꞌ trigo, llazieꞌ trigonꞌ, naꞌ llzeyeꞌ yixh bebe ken. Leꞌe napeꞌ to yiꞌ da bi wayorkze. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naꞌ bzaꞌa Jesúsenꞌ ganꞌ nbane Galilea, naꞌ byejeꞌ ganꞌ zo Juan naꞌ lloaꞌ yeo Jordán naꞌ, nench choeꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Naꞌ Juan naꞌ bi goꞌnreꞌ wchoeꞌ Jesúsenꞌ nis, lleꞌe Leꞌe: —Nadraꞌn llayaꞌl wchoaꞌo nis, naꞌ rweꞌroꞌ zaꞌzoꞌ wchoaꞌ rweꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Naꞌll lle Jesúsenꞌ Juan naꞌ: —Bchoa nadaꞌ nis. Da naꞌn llayaꞌl gonllo nench gak yeolol danꞌ ne Diosenꞌ gak. Naꞌtell bcheb Juan naꞌ bchoeꞌ Leꞌe nis. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naꞌ ka bayoll blloa Jesúsenꞌ nis, naꞌll ballojeꞌ lo nisenꞌ, le byarjte yebánꞌ ganꞌ llia Diosenꞌ, naꞌ breꞌreꞌ Spíritu ke Diosenꞌ, betjen ka to plom daꞌo, bllinen jasorenen Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naꞌ ben akreꞌ bnne Diosenꞌ beꞌnnenꞌ zo yebánꞌ, bneꞌe: —Beꞌnn ninꞌ nak xhiꞌnnaꞌ nllieꞌraꞌ, llaweraꞌ llayazraꞌllaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naꞌ Spíritu ke Diosenꞌ benen nench byej Jesúsenꞌ latj dachenꞌ ganꞌ gokraꞌll daxiꞌon wkoꞌyelen Leꞌe goneꞌ da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Naꞌ bi bdaokzeꞌ rao choa (40) lla choa yere, naꞌ ka bde choa lla naꞌ, bdoneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Naꞌ jabiꞌy daxiꞌon ganꞌ ze Jesúsenꞌ, llen Leꞌe: —Chaꞌ rennroꞌ nakoꞌ dogarje Xhiꞌnn Dios, benchk yej ki yeyak aken yet xtir. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Naꞌll lle Jesúsenꞌ len: —Nyoj xtiꞌll Diosenꞌ: “Kere toze yet xtir danꞌ gaollo naꞌ, llonn yel nban ke lliꞌo beꞌnnach, renkze diꞌll danꞌ ll-lloj lloaꞌ Diosenꞌ nbanrenllo.” ");
INSERT INTO zpuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naꞌll bcheꞌe daxiꞌon Leꞌe Jerusalén naꞌ, ganꞌ nak yell ke Dios. Naꞌ bcheꞌn Leꞌe yichjo yodaꞌo ganꞌ nak zeraoze sibe, ");
INSERT INTO zpuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","naꞌll llen Leꞌe: —Chaꞌ rennroꞌ nakoꞌ dogarje Xhiꞌnn Dios, bxhiꞌtchek ganni, lljasoteꞌo lleꞌle, le nyoj xtiꞌll Diosenꞌ: Diosenꞌ wseꞌleꞌ beꞌnn kaꞌ nak angl keꞌe gakrén akeꞌ rweꞌ, naꞌ goꞌx akeꞌ rweꞌ nench ke lljacheꞌo yej. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Naꞌll lle Jesúsenꞌ len: —Leskaꞌ nyoj xtiꞌll Diosenꞌ: “Bi llayaꞌl nnabroꞌ Diosenꞌ chaꞌ rennreꞌ kanꞌ neꞌen.” ");
INSERT INTO zpuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Da yobre bcheꞌe daxiꞌon Leꞌe to rao yaꞌ da nak sib kwis, naꞌ broeꞌn Leꞌe yeolol yell da zjalliꞌ doxhen yellrio, naꞌ ren yel zaꞌk yel nbaraz ke kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Naꞌ gollen Leꞌe da yobre: —Yeolol da ki llreꞌroꞌ ganni, gonaꞌn rallnaꞌo chaꞌ rweꞌ wcheꞌk xhiboꞌ rawaꞌ, naꞌ gonoꞌ nadaꞌ xhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Naꞌll lle Jesúsenꞌ len: —Bayej kaꞌle, daxiꞌo, nyojkze leꞌ xtiꞌll Diosenꞌ: “Llayaꞌl gonliraꞌlloꞌ Dios, naꞌ toze Leꞌen weꞌraꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Naꞌll bakwas daxiꞌon kaꞌle, naꞌ le bllinte angl ke Diosenꞌ jakrén akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Naꞌ bazaꞌa Jesúsenꞌ ganꞌ nbane Judeanꞌ, naꞌ bayejeꞌ ganꞌ nbane Galilea, ka benreꞌ ba yoꞌ Juan naꞌ lo rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naꞌ bzeꞌe yell Nazaretenꞌ, jasoeꞌ yellenꞌ nziꞌi Capernaum, danꞌ lliꞌ lloaꞌ nisdaꞌon awllo ganꞌ nziꞌi Zabulón, naꞌ ganꞌ nziꞌi Neftalí. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Naꞌ gok kanꞌ bne da Isaías beꞌnn beꞌe xtiꞌll Diosenꞌ kanaꞌ, ka bzojeꞌ danꞌ llia: ");
INSERT INTO zpuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ka nak ganꞌ ne Galileanꞌ ganꞌ llaꞌa zan beꞌnn bi nak beꞌnn Israel, ganꞌ nziꞌi Zabulón, naꞌ Neftalí ganꞌ nban akreꞌ lloaꞌ nisdaꞌo ye chlaꞌ yeo Jordán naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nchole yichjraꞌlldaꞌo beꞌnn kaꞌ llaꞌa gannaꞌ. Bixha Diosenꞌ bseꞌleꞌ to beniꞌ xhen lo yichjraꞌlldaꞌo beꞌnn kaꞌ, gok akeꞌ ka beꞌnn wat, naꞌ Diosenꞌ ba bacheꞌe lo yichjraꞌlldaꞌo akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kanaꞌ bzorao Jesúsenꞌ bdixjweꞌreꞌ, naꞌ bneꞌe: —Lewayate ke da xhinnj ba benre, le ba zo rez nnebiaꞌ Dios beꞌnnenꞌ zo yebánꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesúsenꞌ zejeꞌ lloaꞌ nisdaꞌo ke Galilea, ka breꞌreꞌ chop beꞌnn wxhen bel nziꞌi Simón Pedro, naꞌ ren biꞌcheꞌ Andrés, llzaꞌl akeꞌ yixj danꞌ zenrén akeꞌ bel kaꞌ lo nisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Naꞌll lleꞌe leakeꞌ: —Ledá gonre nadaꞌ txhen, naꞌ gonaꞌ nench reꞌ wtopre beꞌnne, naꞌ yelloj akeꞌ rao da xhinnj ke akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Naꞌll le bsanraꞌllte yixj bel ke akeꞌn, jannao akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Naꞌ Jesúsenꞌ bzeꞌe ye raꞌt, naꞌ breꞌreꞌ Jacobo xhiꞌnn Zebedeo, naꞌ ren biꞌcheꞌ Juan, yoꞌ akeꞌ to lo barco ren xa akeꞌn, llayonchaꞌo akeꞌ yixj ke akeꞌn. Naꞌ leskaꞌ goxh Jesúsenꞌ leakeꞌ, lljannao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Naꞌll le ben akteꞌ barconꞌ rallnaꞌa xa akeꞌn, naꞌ jannao akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesúsenꞌ byejeꞌ yeolol yell kaꞌ zjalliꞌ do ganꞌ nbane Galilea, broeꞌ bsedreꞌ beꞌnn kaꞌ zjallaꞌa toto yodaꞌo ke beꞌnn Israel kaꞌ. Naꞌ bdixjweꞌreꞌ Diꞌll Wen naꞌ, kanꞌ nnebiaꞌ Diosenꞌ. Naꞌ bayoneꞌ beꞌnn kaꞌ llak biteze yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naꞌ doxhente yellrio ganꞌ nbane Siria bllirj diꞌllenꞌ, yeolol ke da wen kaꞌ beneꞌn. Naꞌ beꞌnn Siria kaꞌ jwaꞌa akeꞌ yeolol beꞌnn weꞌe kaꞌ raweꞌn, beꞌnn llak biteze yillweꞌ, beꞌnn lley llra, beꞌnn yoꞌ daxiꞌo yichjraꞌlldaꞌo akeꞌ ren beꞌnn llak xhgot, naꞌ beꞌnn bi dá niaꞌnaꞌa ak, naꞌ bayoneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Naꞌ zan beꞌnne bnao Leꞌe, beꞌnn llaꞌa ganꞌ nbane Galilea, naꞌ ren beꞌnn yell kaꞌ nziꞌi Decápolis, naꞌ beꞌnn zaꞌk Jerusalén, naꞌ beꞌnn zaꞌk yezikre yell daꞌo kaꞌ zjalliꞌ do Judea, naꞌ beꞌnn zaꞌk do chlaꞌ yeo Jordán. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ka breꞌe Jesúsenꞌ beꞌnn zan ba ndop rao yaꞌn, naꞌ bllieꞌ naꞌze, naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, jabiꞌy akeꞌ ganꞌ llieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Naꞌll bzoraweꞌ bzejnieꞌreꞌ leakeꞌ, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Nbaraz ke beꞌnn kaꞌ llakbeꞌe akreꞌ yallj akreꞌ gakrén Diosenꞌ leakeꞌ, le leakeꞌn nak Diosenꞌ txhen beꞌnn llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Nbaraz ke beꞌnn kaꞌ llakyaꞌch akreꞌ, le leakeꞌn weꞌe Diosenꞌ yel llxhenraꞌll ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Nbaraz ke beꞌnn kaꞌ llexjraꞌll akeꞌ, le leakeꞌn gon Diosenꞌ rallnaꞌa akeꞌ doxhen danꞌ bchebeꞌ goneꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Nbaraz ke beꞌnn kaꞌ llon ka beꞌnn llbil don, nench gak akeꞌ beꞌnn wen rao Diosenꞌ, le Dios naꞌn gon kanꞌ zeraꞌll akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Nbaraz ke beꞌnn kaꞌ llayaꞌchraꞌll akeꞌ beꞌnne, kaꞌkze gon Diosenꞌ ke leakeꞌ yeyaꞌchraꞌlleꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Nbaraz ke beꞌnn kaꞌ ba bayib lo raꞌlldaꞌo akeꞌ, le leakeꞌn yereꞌe akreꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Nbaraz ke beꞌnn kaꞌ llabeklli akeꞌ beꞌnn dile, le Diosenꞌ wazaꞌkreꞌ leakeꞌ ka xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Nbaraz ke beꞌnn kaꞌ chaꞌ llallayrao akeꞌ, naꞌ llsaꞌkziꞌ akeꞌ leakeꞌ ni ke da wen naꞌ llon akeꞌ rao Diosenꞌ, leakeꞌn gak Diosenꞌ txhen beꞌnnenꞌ llnebiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Nbaraz ke reꞌ chaꞌ danꞌ llonliraꞌllre nadaꞌn ziꞌchiꞌll beꞌnne reꞌ, naꞌ wsaꞌkziꞌ akeꞌ reꞌ, chirjlaꞌll akeꞌ diꞌll wenraꞌll keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Leyewé lesó nbaraz, le Dios naꞌkze goneꞌ da wen keré kate yellinre ganꞌ llieꞌn. Kanꞌ llon aksreꞌ reꞌ naꞌ, kaꞌkze ben xozxtaꞌo akeꞌ kaꞌ ren beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Reꞌ nakre ka zeꞌde rao beꞌnn kaꞌ llaꞌa yellrionꞌ. Zeꞌdenꞌ naken wen, bixha chaꞌ zeꞌd naꞌ ba bde ke bill naken znaꞌ, ¿akxha gonllon nench yeyaken znaꞌ da yobre? Billbi de gónellon, naꞌ choꞌnnllon wrej wchekw beꞌnn len. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Naꞌ reꞌ nakre ka beniꞌ da llseniꞌ ke yeolol beꞌnne. Naꞌ nakre ka to yell da lliꞌ to rao yaꞌ, naꞌ yeololte beꞌnne llreꞌe akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Notno waꞌl to da wseniꞌ, naꞌ siꞌzeꞌ to da wdoꞌseꞌn, zan wzeꞌen sibe nench wseniꞌn ke yeolol beꞌnn llaꞌa lo yoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Naꞌ ka nak reꞌ llayaꞌl soteze sore gonre da wen nench reꞌe beꞌnne, naꞌ kaꞌ weꞌrao akeꞌ Xallo Dios beꞌnn zo yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Bi gákere chaꞌ nadaꞌ zaꞌa walanaꞌ ley danꞌ bzoj da Moisésenꞌ, naꞌ danꞌ bzoj yezikre beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. Zaꞌa nench gok kanꞌ llia yeolol xtiꞌll Diosenꞌ danꞌ bzoj beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da likzenꞌ te ke yellrio ni, ren da kaꞌ llreꞌllo leꞌ yebá naꞌ, naꞌ niaꞌ, ni raꞌt danꞌ nyoj leꞌ ley naꞌ, bi gak yeranen, gaktelle yeolol danꞌ nllia Diosenꞌ biaꞌa gak. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ke len naꞌ notezre chaꞌ bi gonre kanꞌ llian naꞌ, laꞌkze chaꞌ naken le zerao da daꞌo, naꞌ leskaꞌ chaꞌ wroeꞌre beꞌnn yobre bi chejleꞌ ke leyenꞌ, bi nakre beꞌnn brao ke ganꞌ llia Diosenꞌ llnebieꞌ. Naꞌ notezre chaꞌ gonre kon kanꞌ llian naꞌ, lekze kaꞌ chaꞌ wroeꞌre beꞌnn yobre gon akeꞌ kanꞌ nen naꞌ, Dios beꞌnnenꞌ zo yebá naꞌ llnebieꞌ, nneꞌe nakrenre beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Niaꞌ reꞌ, chaꞌ bi wchaꞌa yichjraꞌlldaꞌorenꞌ nench gakllen wen rao Diosenꞌ, kerke kanꞌ nak ke beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, bi yellinre yebá ganꞌ llia Diosenꞌ llnebieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Bakze nnézere kanꞌ bzejnieꞌ da Moisésenꞌ beꞌnn kaꞌ bllaꞌa kanaꞌ, bneꞌe: “Nono gotre. Naꞌ chaꞌ no gote lwellj beꞌnnache, koxchis kaꞌ wchoy akeꞌ akre gon akeꞌ keꞌe.” ");
INSERT INTO zpuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naꞌ nadaꞌ llepaꞌ reꞌ, chaꞌ llakllaꞌre lwellj beꞌnnachre, Diosenꞌ goneꞌ yel koxchis keré. Naꞌ notezeꞌ chaꞌ ziꞌchiꞌll lwelljeꞌ, llayaꞌl gon beꞌnn kaꞌ llnebiaꞌn yel koxchis ke akeꞌ. Naꞌ notezeꞌ chaꞌ llaꞌd diꞌll lwelljeꞌ, waseꞌl Diosenꞌ leꞌe lo yiꞌ gabil. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Naꞌ chaꞌ kat zere lo yodaꞌon nench weꞌre bi danꞌ lleꞌnere weꞌre weꞌraore Diosenꞌ, naꞌ lljadinraꞌllre bdilrenre to beꞌnn lwelljre, ");
INSERT INTO zpuNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naꞌze llayaꞌle wkwaꞌnnre choll danꞌ noꞌxre, naꞌll lljayeꞌxhenre beꞌnnenꞌ. Yeyoll naꞌ wak lljwaꞌre danꞌ llayaꞌl weꞌre Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Kate to beꞌnne gaweꞌ xhia keré rao koxchis, chak yoꞌre nez naꞌ, lewiá akre koꞌre xhnneze, naꞌ yezorenreꞌ wen nench bi lljweꞌe reꞌ yoraꞌo. Chaꞌ bi broꞌre xhnneze rao nezenꞌ zejrenꞌ, ka llinre rao koxchisenꞌ, goneꞌ reꞌ rao naꞌa xaꞌy kaꞌ, naꞌ koꞌ akeꞌ reꞌ lo rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Diꞌll li llepaꞌ reꞌ, kere wabejeꞌ reꞌ chaꞌ bi chixhjre doxhen danꞌ llbaꞌyre. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ba breꞌkzere ley danꞌ bzoj da Moisésenꞌ nen: “Bi tarenre noꞌr yobre beꞌnn bi nak noꞌr keré.” ");
INSERT INTO zpuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naꞌ nadaꞌ llepaꞌ reꞌ, noteze beꞌnne chaꞌ llwieꞌ to noꞌre, naꞌ llzeraꞌlleꞌ leꞌe, ba llonkzeꞌ da xhinnjenꞌ lo raꞌlldaꞌweꞌ, rebze ba llonkzeꞌ ka beꞌnn kaꞌ llzoa xto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Naꞌ chaꞌ yejraore chaꞌwenꞌ llonen nench gonre da xhinnje, wenre chenak kwejre yejraorenꞌ naꞌ lljachoꞌnnren, kerke da gonre da xhinnjenꞌ. Wenre chenak kweyiꞌ to yejraorenꞌ, kerke da kweyiꞌ doxhenre lo yiꞌ gabilenꞌ ni ke len. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Naꞌ chaꞌ naꞌrenꞌ chaꞌwenꞌ lleꞌnen xoben reꞌ gonre da xhinnje, wenre chenak wchoyren naꞌ lljachoꞌnnren, kerke da gonre da xhinnjenꞌ. Wenre chenak kweyiꞌ to naꞌrenꞌ, kerke da kweyiꞌ doxhenre lo yiꞌ gabilenꞌ ni ke len. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Lekze nnézere ley danꞌ bzoj da Moisésenꞌ nen: “Noteze beꞌnn yeraꞌa ren noꞌr keꞌe, llayaꞌl chas to da weꞌe diꞌll baraꞌ akeꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naꞌ nadaꞌ llepaꞌ reꞌ noteze beꞌnn llaraꞌreneꞌ noꞌr keꞌen, naꞌ chaꞌ bibi doꞌl de ke noꞌrenꞌ dareneꞌ beꞌnn yobre, rao da nxhollenꞌ llzoeꞌ leꞌe, lloneꞌ nench sorén noꞌrenꞌ ye to beꞌnn bi nak xhyiweꞌ. Naꞌ noteze beꞌnn yechaynaꞌreneꞌ to noꞌre beꞌnn baraꞌa ren beꞌnn keꞌe, rebze da xhinnjenꞌ gonkzeꞌ ka danꞌ llonkze beꞌnnenꞌ darén xhoꞌr beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Naꞌ leskaꞌ ba nnézkzere ka danꞌ bzejnieꞌ da Moisésenꞌ da xozxtaꞌollo kaꞌ kanꞌ golleꞌ leakeꞌ: “Góntere chaꞌ bi danꞌ bchebre gonre rao Xanllo Diosenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naꞌ nadaꞌ niaꞌ reꞌ, bi waꞌlrizre Diosenꞌ nere: “Yebá naꞌ llzoaꞌ diꞌll linꞌ lloaꞌa”, kat bi da gonre, le yebá naꞌn zo Diosenꞌ llnebieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Naꞌ bi nnerizre: “Yellrio ninꞌ llzoaꞌn diꞌll linꞌ lloaꞌa”, le yellrionꞌ ke Dios naꞌkzenꞌ. Naꞌ bi nnere: “Jerusalén naꞌ llzoaꞌn diꞌll linꞌ lloaꞌa”, le naken yell ke Dios beꞌnn nake le zerawe beꞌnne llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naꞌ bi nnere: “Yichjaꞌ ni llzoaꞌn diꞌll linꞌ lloaꞌa”, le bi gak gonre nench yich yichjrenꞌ yeyaken da lliche o chaꞌ yeyaken da gasje. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kat nnere waken, waksen naꞌ; naꞌ chaꞌ nere bi gaken, bi gaksen naꞌ. Le billre diꞌll da nnere nench chejleꞌ akeꞌ ke reꞌ bi naken wen. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Nnézere ley danꞌ bzoj da Moisésenꞌ nen: “Chaꞌ to beꞌnn goneꞌ ziꞌ yejraorenꞌ, wak wayonre ziꞌ yejraweꞌn, naꞌ chaꞌ to beꞌnne wxoꞌpeꞌ to layrenꞌ, wakse yexoꞌpre to layeꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naꞌ nadaꞌ niaꞌ reꞌ: Bi wllonre wsaꞌkziꞌ beꞌnne reꞌ. Chaꞌ to beꞌnne kapeꞌ xaꞌyre, lewzé da ye chlaꞌn kapeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chaꞌ to beꞌnne llakyollreneꞌ reꞌ, naꞌ lleꞌnreꞌ wkeꞌe xhare, leweꞌe latje wkaꞌrenteꞌ xhadon kerénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Naꞌ chaꞌ to beꞌnn goneꞌ bien chejrenreꞌ waꞌre no yoaꞌ keꞌen do achj hor, lechejreneꞌ lewaꞌn chop ka ton neꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Naꞌ chaꞌ bi danꞌ llnnabe beꞌnne reꞌ, chaꞌ naken zi da weꞌre, leweꞌn; lekwej chaꞌ bi danꞌ llnnabeꞌ kwejreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Naꞌ lekze ba nnézere ley kerénꞌ llian: “Llayaꞌl llieꞌre beꞌnn lwelljre, naꞌ wiere beꞌnn llwie reꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naꞌ nadaꞌ niaꞌ reꞌ, llayaꞌl llieꞌre beꞌnnenꞌ llwie reꞌ, naꞌ llayaꞌle nnabre rao Dios gak wen ke no beꞌnne ziꞌchiꞌll reꞌ. Legón wen ke beꞌnne llwie reꞌ, leyelwill Dios nench gak wen ke no beꞌnn llsaꞌkziꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chaꞌ kaꞌ gonre, llroeꞌkzere nakre xhiꞌnn Dios beꞌnnenꞌ llia yebá. Le Leꞌen lloneꞌ llraꞌ will nench llseniꞌn ke beꞌnn wen ak, naꞌ ren ke beꞌnn wen da xhinnj ak. Naꞌ leskaꞌ lloneꞌ llak yejw ke beꞌnn wen ren ke beꞌnn wen da xhinnj ak. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Naꞌ chaꞌ reꞌ llieꞌre chraoze beꞌnne llieꞌ reꞌ, naꞌ bi llieꞌre beꞌnn yobre, ¿bixha da wen gon Diosenꞌ kerénꞌ? Le kaꞌkze llon beꞌnn wachixhj kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Naꞌ chaꞌ no biꞌch lwelljre kaꞌze llwapre lliox, ¿llákere chaꞌ wen naꞌ llonre kaꞌ? Bi naken wen kaꞌ, le kaꞌn llon beꞌnn kaꞌ bi nombiaꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Zan llayaꞌl gakre beꞌnn wen beꞌnn chaꞌo kon noteze beꞌnne, kanꞌ nak Xallo Dios beꞌnn zo yebá nakeꞌ beꞌnn wen beꞌnn chaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Kat gonre to da wen, bi gonren nench reꞌe beꞌnn kaꞌ reꞌ, naꞌ yeyoeꞌrao akeꞌ reꞌ. Chaꞌ kaꞌ llonre, bibi da wen gon Xallo Diosenꞌ keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ke len naꞌ kat weꞌre beꞌnne chaꞌ bi da yalljreꞌ, bi weꞌren nench nneze beꞌnn kaꞌ. Le kaꞌkzenꞌ llon beꞌnn chop rao kaꞌ, lloeꞌ akeꞌ bi da lloeꞌ akeꞌ do lo yodaꞌo, naꞌ do tnez nench nneze beꞌnn ake, naꞌ llayoeꞌrao akeꞌ leakeꞌ. Da li niaꞌ reꞌ, kone kaꞌ llaxhj danꞌ llon akeꞌ, naꞌ Diosenꞌ bibi da wen de goneꞌ ke akeꞌ chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Zan reꞌ, chaꞌ bi da weꞌre to beꞌnne, leweꞌn llillize. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Leweꞌn ga bi gakbeꞌe beꞌnne, naꞌ bi yeyoeꞌrao akeꞌ reꞌ, naꞌll Xallo Dios beꞌnnenꞌ llreꞌe yeolol da kaꞌ llonllonꞌ, goneꞌ nench gak wen keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Kat yelwillre Diosenꞌ, bi gonre kanꞌ llon beꞌnn chop rao kaꞌ, llawé akreꞌ sellá akeꞌ yelwill akeꞌ Diosenꞌ lo yodaꞌo ke akeꞌn, naꞌ do skin do tnez, nench reꞌe beꞌnne kanꞌ llon akeꞌn. Da li niaꞌ reꞌ, ba bxhiꞌte raxhj beꞌnn kaꞌ rao yellrio naꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Zan reꞌ katenꞌ yelwillre Diosenꞌ, leyeyoꞌ lo yoꞌ keré to wrazre, leyesejte ganꞌ yoꞌrenꞌ, naꞌll weꞌrenre Xallo Diosenꞌ diꞌll, laꞌkze bi llreꞌlloeꞌ, zorenkzeꞌ lliꞌo, Lekzeꞌn llwieꞌ yeolol danꞌ llnnabrenꞌ, naꞌ goneꞌ da wen keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Naꞌ kat yelwillre Diosenꞌ, bi weꞌre toz ka diꞌll weꞌre kanꞌ llon beꞌnn kaꞌ bi nombiaꞌ Diosenꞌ. Le leakeꞌn llak akreꞌ chaꞌ diꞌll zan naꞌ lloeꞌ akeꞌ naꞌzenꞌ, siꞌte Diosenꞌ xtiꞌll akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bi gonre kanꞌ llon akeꞌn, le Xallo Diosenꞌ, ka za nnábtere, ba nnéztereꞌ binꞌ yálljere naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kinꞌ yelwillre Diosenꞌ: Xa, rweꞌ lliaꞌo yebá, nak laꞌy raꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yedchga yel llnebiaꞌ koꞌon. Gakchga kanꞌ lleꞌnroꞌ rao yellrionꞌ kanꞌ llak yebá naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Danꞌ gaotoꞌ tlla tlla bennchgan nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Naꞌ baziꞌxhen ketoꞌ kanꞌ llon netoꞌ, llaziꞌxhentoꞌ ke beꞌnne biteze da llon akreꞌ netoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Naꞌ bi wsanraꞌlloꞌ netoꞌ yexjtoꞌ rao da xhinnjenꞌ, bkwas brekyiꞌll netoꞌ rao da xhinnjenꞌ. Le rweꞌn llnebiaꞌo, naꞌ napoꞌ yel wak, nakoꞌ beꞌnn zaꞌk xhen zejlikane. Kaꞌn gakchga. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Naꞌ chaꞌ llaziꞌxhenre ke lwellj beꞌnnachre biteze da llon akreꞌ reꞌ, Xallo Dios beꞌnnenꞌ zo yebá, leskaꞌ yeziꞌxheneꞌ yeolol da xhinnj keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Naꞌ chaꞌ reꞌ bi llaziꞌxhen ke lwelljre, leskaꞌkze bi yeziꞌxhenkze Xallo Diosenꞌ keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Kat gonre was, bi gon lloaꞌraorenꞌ ka beꞌnn zoyaꞌche, kanꞌ llon beꞌnn chop rao kaꞌ. Llon akeꞌ nench reꞌe beꞌnn chaꞌ bi danꞌ llon akeꞌ, naꞌ wayoeꞌrao beꞌnn leakeꞌ. Da li niaꞌ reꞌ, ba bxhiꞌte raxhj beꞌnn kaꞌ rao yellrio naꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Zan reꞌ, kat gonre wasenꞌ, lewapaꞌ yichjraore, lechib lloaꞌraore. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kaꞌn gonre nench ke gakbeꞌe beꞌnne chaꞌ wasenꞌ nonre, le toze Xallo Dios naꞌn llayaꞌl gakbeꞌreꞌ, le Leꞌen zoreneꞌ reꞌ, laꞌkze chaꞌ bi llreꞌlloeꞌ. Xallo Dios naꞌn llreꞌreꞌ yeolol da llonrenꞌ, naꞌ goneꞌ da wen keré. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Bi koꞌchaꞌore da nak yel wniaꞌ rao yellrio ni, le weyiꞌn. Le balen le lltetebaꞌ, naꞌ ye balen llbia re, naꞌ leskaꞌ llaz beꞌnn wan, naꞌ kwan akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Zan Dios naꞌ lewxenraꞌlleꞌ nench gonneꞌ da wen da chaꞌo keré da bi te ke, kat yellinre yebá ganꞌ zoeꞌn, naken da bi wtebaꞌ, ni ke kwiaze re, ni beꞌnn wan bi gak kwanen. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Le ganꞌ ngoꞌchaꞌore danꞌ llazraꞌllre naꞌn, gannaꞌn zokze yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Yejraore llian naken ka to beniꞌ nench reꞌre. Chaꞌ bibi llaken, llreꞌkzere kwasro. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Zan chaꞌ yejraorenꞌ bi naken wen, doxhenre ncholen chet kaꞌ. Naꞌ chet kaꞌ beniꞌ ke Dios danꞌ nere zorén reꞌ naken xchole, xchol kwisenꞌ nak yichjraꞌlldaꞌore chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nono gak gon llin ren chopre xaneꞌ to chiꞌze, le chaꞌ kaꞌ goneꞌ, wiereꞌ to xan llin naꞌ, naꞌ llieꞌreꞌ beꞌnnenꞌ ye to; naꞌ goneꞌ llin ke toeꞌ do yichj do raꞌlleꞌ, naꞌ ke beꞌnnenꞌ ye to, goneꞌn kaze raꞌlleꞌ. Kaꞌkze ke reꞌ bi gak gonre xchin Diosenꞌ, naꞌ waráltere gonre llin, seraꞌllre gakre beꞌnn wniaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ke len naꞌ llepaꞌ reꞌ, bi kwek yichjre chraoze bi da yeꞌj gaore chak nbanre, leskaꞌ bi kwek yichjre chraoze ke xharaꞌnre. Le zaꞌkll yel nban kerénꞌ ker ka yel waonꞌ. Lekze kaꞌ kwerp kerénꞌ, zaꞌkllen ker ka xharaꞌnrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lewiá ke ba kaꞌ zo xir llasdá rao lla, ni ke llaz llarap akzbaꞌ, naꞌ ni daꞌ xhoaꞌ ke akbaꞌ bi zo, naꞌ Xallo Dios beꞌnnenꞌ zo yebá naꞌ llwaokzebaꞌ. ¿Kere zaꞌkllre ker ka ba kaꞌ zo xirenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Naꞌ ni tore kere wak yesdón kwinre ye tchit, chaꞌ kweꞌ yichjzre gakre beꞌnn tonne. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Naꞌ ¿bixchen lliꞌ yichjzre kwis ke xharaꞌnre? Lewiá ke yej daꞌo zjallaꞌa lyiꞌxe, llazochaꞌo aksen laꞌkze bibi llin llon aken, ni ke llab akzen yere. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Da li niaꞌ reꞌ, rey Salomón naꞌ, gokeꞌ raꞌll wen kwis, naꞌ ni kaꞌ bi ballinkze xharaꞌneꞌn katk yel nbaraz ke yej daꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diosenꞌ noneꞌ nbaraz da zjadé lyiꞌxe laꞌkze to chop llaze so aken, naꞌ llzey akeꞌn. Bixha reꞌ, ¿bi llákere gonlle Diosenꞌ wen keré chaꞌ reꞌ nxenraꞌllreꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ke len naꞌ bi kweꞌ yichjre ke bi danꞌ yálljere, nere: “¿Bi yeꞌj gaollo, naꞌ bi gakllo?” ");
INSERT INTO zpuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ke nak beꞌnn kaꞌ bi nxenraꞌll Dios, kon lloeꞌlaꞌll akeꞌ llayirj akeꞌ da ki. Zan lliꞌo, nnézkze Xallo Dios beꞌnnenꞌ zo yebá naꞌ binꞌ yálljello. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Llayaꞌle kweꞌ yichjre, naꞌ wzenayre ke Diosenꞌ nench nnebieꞌ yichjraꞌlldaꞌore, naꞌ gakre beꞌnn wen raweꞌn. Naꞌ yeolol da kaꞌ yálljerenꞌ, Dios naꞌkze gonneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bi kweꞌ yichjre bi gak wxe willje, le dekze latj wxe, kweꞌ yichjllo da za zaꞌa. Le tlla tlla nsaꞌkzen da zed ke. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Bi wlliayiꞌllre beꞌnne, nench ke wlliayiꞌll Diosenꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kon kanꞌ llonre llchoybiaꞌre ke beꞌnne, kaꞌkze gon Diosenꞌ wchoybieꞌ keré. Naꞌ kanꞌ llónere beꞌnne, kaꞌ gonkze Diosenꞌ ke reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bixchen llwiazoꞌ beb daꞌon yoꞌ lo rao beꞌnn biꞌchoꞌn, naꞌ bi llwiaꞌo beb xhen naꞌ, yoꞌ lo rao rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Bixchen yezoꞌ bibiꞌchoꞌn: “Anchk wabejkeraꞌ beb daꞌon yoꞌ lo raoꞌn?” ¿Bixha danꞌ yoꞌ lo rao rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Beꞌnn chop rao! Zgaꞌtek babej beb xhen naꞌ, yoꞌ lo rao rweꞌ, naꞌllenꞌ yereꞌroꞌ kwasro, naꞌ gak wabejoꞌ yixh bebenꞌ yoꞌ lo rao beꞌnn biꞌchoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Naꞌ bi weꞌrentezre xtiꞌll Diosenꞌ beꞌnn kaꞌ bi llazraꞌll len naꞌ, nxholl gon akreꞌ reꞌ znia ka llon beꞌkw wxhoxhjtinbaꞌ beꞌnne. Bi gonre ka beꞌnn wzaꞌlzeꞌ da chaꞌo ak rao kuch ak, nxholl wrejchekw akbaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Lewnnab, chaꞌ bi wnnabre, gonnkze Diosenꞌ len; lechirj, chaꞌ bi chirjre, wllelkzen; lewseꞌkw, naꞌ wyarjkze choꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Le noteze beꞌnne bi da llnnabeꞌ, wziꞌkzeꞌn; naꞌ beꞌnn llyirjeꞌ, wllelkzereꞌn; naꞌ beꞌnn llnneꞌe, llsarj akseꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Kaꞌ reꞌ, chaꞌ xhiꞌnnre nnábebeꞌ reꞌ to yet xtir, kere weꞌrebeꞌ to yej. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naꞌ chaꞌ nnábebeꞌ reꞌ to bel gaobeꞌ, kere lloeꞌrebeꞌ to bele znia. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Laꞌkze naktere beꞌnn wen da xhinnj ak, nnézkzere lloeꞌre xhiꞌnnre kaꞌ to da wen. Naꞌ bixha Xallo Diosenꞌ zo yebá naꞌ, gonlleꞌ wen ke beꞌnn llnnabe Leꞌe bi danꞌ yalljreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Naꞌ yeolol danꞌ lleꞌnere gon beꞌnnach keré, kaꞌkze llayaꞌle gonre ke akeꞌ, le kaꞌn llak ka nyoj leꞌ leyenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Lechoꞌo nez danꞌ nak choꞌpze, le da raꞌy nak nez danꞌ lljasán beꞌnn kaꞌ ganꞌ kweyiꞌ akeꞌ. Naꞌ beꞌnn zan lljak nez raꞌyenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Le choꞌpze nak nezenꞌ danꞌ lljasán lliꞌo ganꞌ de yel nban zejlikanenꞌ, naꞌ to chopze beꞌnn ake zaꞌk akreꞌ lljakeꞌ nez choꞌpenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Llayaꞌl wiare nench ke chejleꞌre xtiꞌll beꞌnn wenraꞌll kaꞌ, beꞌnn kaꞌ ne lloeꞌ akeꞌ xtiꞌll Dios, non akeꞌ ka xhiꞌr maxh daꞌo, naꞌ loere nak akeꞌ ka beꞌkw yiꞌo, ba llao xhiꞌr daꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka nak da llbia toto yay nnézello bi yayenꞌ. Ka nak yay yeꞌchenꞌ bi llbian uvas, naꞌ ni yay yixenꞌ bi llbian higo. Kaꞌn llayaꞌl gakbeꞌre ke beꞌnn kaꞌ ziyeꞌe reꞌ, kat reꞌre bi danꞌ llon akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yay danꞌ nak yay wen naꞌ, daxhix wenkze llbian. Naꞌ yay danꞌ bi nak wen naꞌ, lekze daxhix bi nak wen kwian. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Le bi gak to yay xhix wen kwiazen daxhix bi nak wen, leskaꞌ yayenꞌ bi nak wen naꞌ, bi gak kwiarizen daxhix wen. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yeololte yay da bi llbia daxhix wen, llchoy xane len naꞌ llzeyeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Naꞌ ka nak danꞌ llon toto beꞌnne, nnézello chaꞌ nakeꞌ beꞌnn wen o chaꞌ nakeꞌ beꞌnn wen da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Kere yeolol beꞌnn kaꞌ llalwill nadaꞌn, ne akeꞌ: “Xantoꞌ, Xantoꞌ”, yellín yebánꞌ ganꞌ llia Diosenꞌ llnebieꞌ. Kon beꞌnne gon kanꞌ lleꞌne Xaꞌ Dios beꞌnne llia yebá naꞌ, leakzeꞌ yellín ganꞌ llieꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kat llin lla gonaꞌ yel koxchis ke beꞌnn kaꞌ, beꞌnn zan ye akeꞌ nadaꞌ: “Xantoꞌ, ba beꞌtoꞌ xtiꞌlloꞌn, naꞌ kone raꞌon, babejtoꞌ daxiꞌo kaꞌ zjallaꞌa yichjraꞌlldaꞌo beꞌnne, naꞌ leskaꞌ kone raꞌo naꞌ, bentoꞌ da zan yel wak ake.” ");
INSERT INTO zpuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Naꞌ kanaꞌ yep akeꞌ: “Bi nombiaꞌ reꞌ, kaꞌle lelljayak, reꞌ beꞌnn wen da xhinnje.” ");
INSERT INTO zpuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Beꞌnnenꞌ llzenay xtiꞌllaꞌn, naꞌ lloneꞌ kanꞌ niaꞌ naꞌ, lloneꞌ ka to ke beꞌnn siꞌn beꞌnn ben rill, naꞌ bxieꞌ ranenꞌ to rao yej war. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Naꞌ ka gok yejsiꞌo xhen, naꞌ bda to beꞌ war, naꞌ blloj yeo da xhen bayechjte ganꞌ zo rilleꞌn. Naꞌ bi bzoen wzalen len, le lliꞌ ranen to rao yej war. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Naꞌ beꞌnn llenreꞌ xtiꞌllaꞌ ni, naꞌ bi lloneꞌ kanꞌ niaꞌ naꞌ, lloneꞌ rebze ka to beꞌnn bi bwia ganꞌ gon rilleꞌn, naꞌ beneꞌn to rao yoxh. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka gok yejsiꞌo xhen naꞌ, blloj yeonꞌ bayechjten ganꞌ zo yoꞌ keꞌen, naꞌ bda beꞌ, naꞌ bzoen bzalen len blleyiꞌtekazen. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Naꞌ ka bayoll beꞌe Jesúsenꞌ diꞌll kaꞌ, naꞌll llabane beꞌnn kaꞌ llaꞌa naꞌ, kanꞌ broeꞌ bsedreꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Le kanꞌ bzejnieꞌreꞌn, nakbieꞌkze napeꞌ yel llnebiaꞌ, kere bzejnieꞌreꞌ kanꞌ llzejnieꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Beꞌnn zan zanao Jesúsenꞌ kanꞌ bayetjeꞌ rao yaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Naꞌ to beꞌnn llak yillweꞌ danꞌ ne lepra jabiꞌyeꞌ raweꞌn, naꞌ bcheꞌk xhibeꞌ, naꞌll lleꞌe Leꞌe: —Xanaꞌ, chaꞌ lleꞌnroꞌ, wakse wakaꞌo yillweꞌ kiaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Naꞌll le blite naꞌa Jesúsenꞌ bdaneꞌ leꞌe, lleꞌe leꞌe: —Lleꞌnkzraꞌ, bayak. Naꞌll le bayakte ka nak yillweꞌn llakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Naꞌll lle Jesúsenꞌ leꞌe: —Notno yeꞌo kaꞌ. Byej jawiá bxozenꞌ nench reꞌreꞌ ba bayakoꞌ. Naꞌ beꞌe danꞌ llayaꞌl weꞌweꞌ danꞌ bne da Moisésenꞌ kaꞌ, nench naꞌ yeyakoꞌ yall rao ley naꞌ. Kaꞌ ben nench yeolol beꞌnne nnez akreꞌ ba bayakoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka bllin Jesúsenꞌ ganꞌ nziꞌi Capernaum, le bllinte to xan beꞌnn wakaꞌa ya beꞌnn Roma, jatileꞌ Leꞌe, naꞌ goꞌtyoereꞌ Leꞌe, ");
INSERT INTO zpuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","lleꞌe Leꞌe: —Xantoꞌ, beꞌnn wen llin kiaꞌn deꞌe rillaꞌn llakeꞌ yillweꞌ, nat niaꞌneꞌe, naꞌ ll-llayraweꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Naꞌll lle Jesúsenꞌ leꞌe: —Saꞌrenaꞌ rweꞌ yeyoneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Naꞌ xan wakaꞌa yanꞌ lleꞌe Leꞌe: —Xantoꞌ, bi nakaꞌ beꞌnn zaꞌk saꞌrenoꞌ nadaꞌ rillaꞌn, ganniteze bnne, naꞌ wayakte beꞌnn wen llin kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nadaꞌ zo beꞌnn llnebiaꞌ nadaꞌ, naꞌ lekze niꞌt beꞌnn wakaꞌa ya kiaꞌ llnebiaꞌ akeꞌ. Kate llepaꞌ toeꞌ: “Byej”, naꞌ llejteꞌ, naꞌ kate llepaꞌ ye toeꞌ: “Da”, naꞌ le lledteꞌ, naꞌ kate llepaꞌ beꞌnn wen llin kiaꞌn: “Da ni gonoꞌ”, naꞌ le llonteꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Naꞌ ka bene Jesúsenꞌ xtiꞌll xan wakaꞌa yanꞌ, naꞌll babanreꞌ, naꞌll lleꞌe beꞌnn kaꞌ nao Leꞌen: —Da linꞌ niaꞌ reꞌ, ni to beꞌnn Israel bi nna gonliraꞌll akeꞌ nadaꞌ ka beꞌnn ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Naꞌ ni niaꞌ reꞌ, beꞌnn zan beꞌnn zaꞌk doxhen yellrio, lljalleꞌrén akeꞌ txhen xozxtaꞌollo Abraham naꞌ, Isaakenꞌ ren Jacobenꞌ ganꞌ llia Diosenꞌ llnebieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Zan ka nak beꞌnn kaꞌ llayaꞌl so ren Diosenꞌ chenake, leakeꞌn yeseꞌleꞌ lo gabil ganꞌ nake xchole, yesbell akeꞌ to gaoxoxj lay akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naꞌll lle Jesúsenꞌ xan wakaꞌa ya kaꞌ: —Ba gok wayejoꞌ, ba bayakte beꞌnn wen llin koꞌon kon kanꞌ benliraꞌlloꞌn ba gok. Naꞌ le bayakte beꞌnn wen llin ke xan wakaꞌa ya kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Naꞌll byej Jesúsenꞌ rill Pedronꞌ, naꞌ breꞌreꞌ xhnaꞌ noꞌr ke Pedronꞌ deꞌe yoeꞌ da la res. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesúsenꞌ bdaneꞌ taꞌk beꞌnn weꞌen, le ballachte da lanꞌ. Naꞌll le bayaste noꞌrenꞌ bsinieꞌ da bdao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naꞌ betj lleꞌ naꞌ, bllin beꞌnn zan ganꞌ zo Jesúsenꞌ, naꞌ ncheꞌe akeꞌ beꞌnn zan beꞌnn yoꞌ daxiꞌo yichjraꞌlldaꞌo akeꞌ. Naꞌll to bnneze Jesúsenꞌ, le ballojte daxiꞌo kaꞌ, naꞌ leskaꞌ bayoneꞌ yeolol beꞌnn llak billre yillweꞌ daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kaꞌn beneꞌ nench gok kanꞌ llia xtiꞌll Diosenꞌ danꞌ bzoj da Isaíasenꞌ kanaꞌ, nen: “Leꞌen yekeꞌe yel ll-llayrao kello, naꞌ yekeꞌe yeolol yillweꞌ kellonꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesúsenꞌ breꞌreꞌ ba bllin beꞌnn zan nechj akeꞌ Leꞌe, naꞌll golleꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ nench laꞌy akeꞌ ye chlaꞌre nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Naꞌ blloj to beꞌnn llsedre ke ley danꞌ bzoj da Moisésenꞌ, le jabiꞌyteꞌ rao Jesúsenꞌ lleꞌe Leꞌe: —Maestro, wzaꞌrenaꞌ rweꞌ kon gateze chejoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Naꞌll lle Jesúsenꞌ Leꞌe: —Beꞌz kaꞌ zo ga llallín akbaꞌ lltas akbaꞌ, naꞌ ba kaꞌ zo xir dá rao lla, llia xoꞌnn akbaꞌ, zan nadaꞌ, nakaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, bitbi zo ga yeziꞌraꞌllaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Naꞌll blloj ye to beꞌnn zejrén Jesúsenꞌ txhen, naꞌ lleꞌe Leꞌe: —Xanaꞌ, zgaꞌtek benn latj wkwaꞌchaꞌ xaꞌn kate gateꞌ, naꞌll nnawaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Naꞌll lle Jesúsenꞌ leꞌe: —Da nnao nadaꞌ, bkwaꞌnn beꞌnn wat kaꞌ, wkwaꞌchze lwellj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naꞌll Jesúsenꞌ, le byoꞌteꞌ lo barconꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Naꞌt ka zejen lo nisenꞌ, bzorao dá to beꞌ xhen, naꞌ ren nisdaꞌon bzorao yitjen, naꞌ ba llayoll nis lo barconꞌ, naꞌ ba tas Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Naꞌll basbán akeꞌ Leꞌe, lle akeꞌ Leꞌe: —¡Xantoꞌ, basrá lliꞌo, ba llbeyiꞌllo! ");
INSERT INTO zpuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Bixchen llebrizre? ¿Bi llonliraꞌllre nadaꞌ? Naꞌll byaseꞌ balwilleꞌ beꞌn ren nisdaꞌon, naꞌll le blleꞌlliten. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen naꞌ, babán akreꞌ kanꞌ beneꞌn. Naꞌll lle lwellj akeꞌ: —¿Noxha beꞌnnenꞌ lla? Rente kaze beꞌ, naꞌ ren nisdaꞌo naꞌ llzenayen keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Naꞌ ballineꞌ ye chlaꞌ nisdaꞌon ganꞌ lliꞌ rall beꞌnn Gadara kaꞌ. Naꞌ jatil chop beꞌnne Leꞌe, beꞌnn yoꞌ daxiꞌo yichjraꞌlldaꞌo akeꞌ. Beꞌnn ki ba zo aktekzeꞌ latj ganꞌ lljakwaꞌch akeꞌ beꞌnn wat kaꞌ, naꞌ ba llraydo akeꞌ kon no lldeze gannaꞌ, nollno llakse te do tnezenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Naꞌll besiaꞌ akeꞌ, lle akeꞌ Jesúsenꞌ: —¿Bi de koꞌo kone netoꞌ? Rweꞌ Xhiꞌnn Dios dogarje. ¿Zaꞌo zadsaꞌkziꞌo netoꞌ, renchaꞌ bi nna llin lla ketoꞌ yellayraotoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naꞌ kwitze llasdá zan kuch ak, llao akbaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Naꞌll goꞌtyoe daxiꞌo kaꞌ Jesúsenꞌ, lle aken Leꞌe: —Chaꞌ kaꞌ yebejoꞌ netoꞌ yichjraꞌlldaꞌo beꞌnn ki, benn latj wayejtoꞌ ganꞌ zjallaꞌa kuch kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naꞌll lle Jesúsenꞌ leaken: —Wakse, lewayej. Naꞌll balloj aken yichjraꞌlldaꞌo beꞌnn kaꞌ, naꞌ zjayakdon ganꞌ llaꞌa kuch kaꞌ. Naꞌll bayetjnninn kuch kaꞌ leꞌ yaꞌ ganꞌ llaꞌa akbaꞌn, naꞌ jallaꞌa akbaꞌ lo nisdaꞌon, naꞌ got akbaꞌ weꞌj akbaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Naꞌ beꞌnn kaꞌ llap kuch kaꞌ, breꞌe akreꞌ kanꞌ goken, baxhonnj akeꞌ, naꞌ jayell akeꞌ beꞌnn rao yell kaꞌ kanꞌ goken, naꞌ kanꞌ ba bayak beꞌnn kaꞌ byoꞌ daxiꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naꞌll yeolol beꞌnn kaꞌ llaꞌa yellenꞌ jatil akeꞌ Jesúsenꞌ, naꞌll ka breꞌe akreꞌ Leꞌen, goꞌtyoe akreꞌ Leꞌe wazeꞌe rall akenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesúsenꞌ bayoeꞌ lo barconꞌ, balaꞌyeꞌ ye chlaꞌre nisdaꞌon, naꞌ ballineꞌ rao ralleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naꞌ bllin txhonnj beꞌnn nlen akeꞌ to beꞌnn, bi dá niaꞌneꞌe, nxoa akeꞌ leꞌe to rao bray. Ka gokbeꞌe Jesúsenꞌ kanꞌ nxenraꞌll akeꞌ Leꞌe, naꞌll lleꞌe beꞌnn weꞌen: —Bawé xhiꞌnnaꞌ, ni llaziꞌxhenaꞌ ke da xhinnj koꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naꞌll bale beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, ben akreꞌ kanꞌ goll Jesúsenꞌ beꞌnn weꞌen, bzaꞌraꞌll akeꞌ to lo yichjraꞌlldaꞌo akeꞌ, naꞌll bne akeꞌ: “Beꞌnn ni llkadieꞌ ke Diosenꞌ neꞌe kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesúsenꞌ gokbeꞌreꞌ ka danꞌ zaꞌraꞌll beꞌnn kaꞌ, naꞌll golleꞌ leakeꞌ: —¿Bixchen llzaꞌraꞌllrizre da xhinnj lo raꞌlldaꞌore? ");
INSERT INTO zpuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Llákere bi napaꞌ yel llnebiaꞌ naꞌ yepeꞌ: “Ni llaziꞌxhenaꞌ da xhinnj koꞌon.” ¿Bixha chaꞌ yepeꞌ: “Bayas naꞌ bayej”? ");
INSERT INTO zpuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nadaꞌ nakaꞌ Beꞌnn Gorj Radj Beꞌnnach wroeꞌraꞌ reꞌ, naꞌ zoaꞌ yellrio ni, napaꞌ yel llnebiaꞌ nench yeziꞌxhenaꞌ da xhinnj ke beꞌnnachenꞌ. Naꞌll golleꞌ beꞌnn xhinnjenꞌ: —Bayas, bayoaꞌ ganꞌ bxhoaꞌo, naꞌ bayej rilloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Naꞌll bayas beꞌnnenꞌ zayejeꞌ rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Naꞌ beꞌnn kaꞌ breꞌe kanꞌ goken blleb akeꞌ kwis, naꞌll beꞌrao akeꞌ Diosenꞌ kanꞌ beneꞌ beꞌe yel wak keꞌen Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka bde Jesúsenꞌ ganꞌ lliꞌ Mateonꞌ llchixhjeꞌ danꞌ llayaꞌl wayej yell ganꞌ llnebiaꞌ leakeꞌn, naꞌ breꞌe Jesúsenꞌ leꞌen, naꞌll lleꞌe leꞌe: —Da nnao nadaꞌ. Naꞌll bzollaꞌa Mateonꞌ zejreneꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka goken bllin Jesúsenꞌ rill Mateonꞌ, naꞌ lliꞌ akeꞌ llao akeꞌ txhen ren ye zan beꞌnn wachixhj ak, naꞌ ren yelaꞌ beꞌnn wen da xhinnje, naꞌ renkze beꞌnn kaꞌ non Leꞌe txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ka breꞌe beꞌnn fariseo kaꞌ lliꞌ ren Jesúsenꞌ leakeꞌ txhen, naꞌll lle akeꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —¿Bixchen beꞌnnenꞌ llroeꞌ llsede reꞌn llaoreneꞌ txhen beꞌnn wachixhj kaꞌ, naꞌ ren beꞌnn wen da xhinnj kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Naꞌ ka bene Jesúsenꞌ xtiꞌll akeꞌn, naꞌll lleꞌe leakeꞌ: —Beꞌnn bibi yillweꞌ llake, bi yalljreꞌ beꞌnn wen rmell, zan beꞌnnenꞌ llak yillweꞌn, leꞌen yalljreꞌ beꞌnn wen rmellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lelljased bi zej xtiꞌll Diosenꞌ danꞌ nyoj: “Lleꞌnraꞌ yeyaꞌchraꞌllre beꞌnne, kere kon gotre bayiꞌx gákere nadaꞌ nxenraꞌllre.” Kere zaꞌa zadyexhaꞌ beꞌnn wen akenꞌ, zan zaꞌa zadwiaꞌ beꞌnn wayatre ke da xhinnj ba ben akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naꞌll beꞌnn kaꞌ nao Juan beꞌnnenꞌ bchoa nis, jabiꞌy akeꞌ rao Jesúsenꞌ, lle akeꞌ Leꞌe: —¿Bixchen bi llon beꞌnn kaꞌ was beꞌnn kaꞌ nao rweꞌn, naꞌt netoꞌ llontoꞌ was, leskaꞌ beꞌnn fariseo kaꞌ llon akeꞌ was? ");
INSERT INTO zpuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Bixha wak so beꞌnn ak yel wan, beꞌnn llon akeꞌ yexh ga llak yel wachaynaꞌa chak lliꞌrén wachaynaꞌn leakeꞌ? Bi gak soreneꞌ leakeꞌ yel wan. Zan wllin lla wagaꞌa beꞌnn byionꞌ, kanaꞌllenꞌ gon akeꞌ was. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Gaga zo beꞌnne gonreneꞌ llin raꞌll kobe, yedeꞌen xheꞌe gore, le raꞌll kobenꞌ, yebeꞌn kat chiben, naꞌ wcheꞌzen xheꞌe gorenꞌ, yezikre yarj ganꞌ nlleꞌzen. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naꞌ leskaꞌ nono zo beꞌnn kaꞌchaꞌorizeꞌ xis uva kobenꞌ to lo blloy yid gore, le xis uva kobenꞌ wcheꞌzen blloy yid gorenꞌ, naꞌ llopten kweyiꞌ. Zan kaꞌchaꞌweꞌ xis uva kobenꞌ lo blloy yid kobe, nench bi kweyiꞌ xis uvanꞌ, naꞌ kaꞌ llopten bi kweyiꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nna lloeꞌte Jesúsenꞌ diꞌll naꞌ, bllindokze to beꞌnn wnebiaꞌ, bcheꞌk xhibeꞌ rao Jesúsenꞌ, lleꞌe Leꞌe: —Le bayollte got to xhiꞌnnaꞌ noꞌre. Choꞌdo naꞌ wxoa naoꞌn yichjbeꞌ nench yebanbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naꞌll bzollaꞌa Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ byejrén akeꞌ beꞌnn wnebiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naꞌ ka zjakeꞌ naꞌn, bnao to noꞌre leakeꞌ, ba gok chllinn (12) iz llzoeꞌ waꞌa, naꞌ beneꞌ bien jabiꞌyeꞌ awllo koꞌll Jesúsenꞌ, jataneꞌ xheꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Le kanꞌ bzaꞌraꞌlleꞌ to lo raꞌlldaꞌweꞌ, bneꞌe: “Kon chaꞌ ba bdanaꞌ xheꞌen, wayaksaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Naꞌ bayechj Jesúsenꞌ bwieꞌ noꞌrenꞌ, naꞌll lleꞌe leꞌe: —Bendipraꞌlloꞌ xhiꞌnnaꞌ. Ba bayaksoꞌ danꞌ llonliraꞌlloꞌ nadaꞌ. Naꞌ le bayakte noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ka bllin Jesúsenꞌ rill beꞌnn wnebiaꞌn, naꞌ breꞌreꞌ ba zjallaꞌa beꞌnn zan, llon akeꞌ txhen, naꞌ llasbell akeꞌ, naꞌ ba llaꞌa beꞌnn llkwell bllej. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naꞌll lleꞌe leakeꞌ: —Lelljayak. Kere got bidaꞌo noꞌr ninꞌ, taszbeꞌn. Naꞌll beꞌnn kaꞌ lltitj akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Naꞌll bayoll bachacheꞌ yeolol beꞌnn kaꞌ, naꞌll byoeꞌ beꞌxeꞌ taꞌk bidaꞌo watenꞌ, naꞌll le bayástebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naꞌ yel wakenꞌ beneꞌn goslas diꞌllenꞌ yeolol yell kaꞌ zjalliꞌ do naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Naꞌ ka badé Jesúsenꞌ, bnaodo chop beꞌnn lchol Leꞌe, naꞌ besiaꞌ akeꞌ zillje, goll akeꞌ Leꞌe: —¡Rweꞌn nakoꞌ xhiꞌnn dialla da rey David, bayaꞌchraꞌll netoꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Naꞌ ka bayoꞌ Jesúsenꞌ lo yoꞌn, naꞌ byoꞌ beꞌnn lchol kaꞌ, naꞌll lle Jesúsenꞌ leakeꞌ: —¿Llonliraꞌllre nadaꞌ gak gonaꞌ nench yereꞌre? Naꞌll lle akeꞌ Leꞌe: —Awaꞌ xantoꞌ, llejleꞌtoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Naꞌll bdan Jesúsenꞌ yej rao akeꞌn, lleꞌe leakeꞌ: —Yereꞌchgare kon kanꞌ nxenraꞌllre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naꞌll le bayakte yej rao akeꞌn, bareꞌe aktereꞌ. Naꞌll goll Jesúsenꞌ leakeꞌ: —Bi weꞌre diꞌll kanꞌ gok bayak yejraorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bixha kate bazaꞌa akeꞌ naꞌ, jadá akeꞌ doxhen ganꞌ nziꞌi Galilea, lloeꞌ akeꞌ diꞌll ka danꞌ ben Jesúsenꞌ ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Naꞌ ka ballach beꞌnn kaꞌ, le bllinte beꞌnn yob akreꞌ, ncheꞌe akeꞌ ye to beꞌnn blloje yoꞌ daxiꞌo yichjraꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Naꞌll Jesúsenꞌ le babejteꞌ daxiꞌon, le bannete beꞌnnenꞌ. Naꞌ beꞌnn zan breꞌe kanꞌ goken, naꞌll babán akreꞌ kwis, naꞌll ne akeꞌ: —Lliꞌo beꞌnn Israel, da nellenꞌ breꞌllo yel wakenꞌ nak kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Naꞌ beꞌnn fariseo kaꞌ ne akeꞌ: —Xan daxiꞌo kaꞌn llakrenen leꞌe, nench llabejeꞌ daxiꞌon zjayoꞌ yichjraꞌlldaꞌo beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesúsenꞌ jateꞌe toto yell, naꞌ toto yell daꞌo zjalliꞌ do naꞌ, jazejnieꞌreꞌ beꞌnn Israel kaꞌ lo yodaꞌo ke akeꞌn, naꞌ bdixjweꞌreꞌ leakeꞌ Diꞌll Wen kanꞌ nnebiaꞌ Diosenꞌ, naꞌ bayoneꞌ beꞌnn kaꞌ llak biteze yillweꞌ, naꞌ biteze da llak ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Naꞌ ka breꞌreꞌ ba bllay beꞌnn zan, naꞌ bayaꞌchraꞌlleꞌ leakeꞌ. Ka gokbeꞌreꞌ llakllejlaꞌll akeꞌ, akre gon akeꞌ, naꞌ nono llraꞌ gakrén leakeꞌ ka danꞌ llallayrao akeꞌn. Niꞌt akeꞌ ka xhiꞌr daꞌo, ba nono llraꞌ gap leakbaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Naꞌll lleꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Da li niaꞌ reꞌ, ka beꞌnn gon wrapenꞌ gonllo, da xhen llin naꞌ de, naꞌ to chopze beꞌnn wrap kaꞌ nak. ");
INSERT INTO zpuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lennabe Dios beꞌnnenꞌ nak xan llin naꞌ, wseꞌleꞌ yezikre beꞌnn wen llin rao llin naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesúsenꞌ btopeꞌ beꞌnn chllinn kaꞌ non Leꞌe txhen, naꞌ beꞌe leakeꞌ yel wak nench wabej akeꞌ daxiꞌo zjayoꞌ lo yichjraꞌlldaꞌo beꞌnne, naꞌ wayón akeꞌ biteze yillweꞌ da llak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ki re beꞌnn chllinn kaꞌ: Simón lekze leꞌen reꞌe Pedronꞌ, beꞌnnenꞌ gok beꞌnn nell, naꞌ Andrés biꞌch Pedro naꞌ, naꞌ Jacobo ren Juan xhiꞌnn Zebedeo, ");
INSERT INTO zpuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","naꞌ Felipe, naꞌ Bartolomé, naꞌ Tomás, naꞌ Mateo beꞌnnenꞌ gok wachixhje, naꞌ Jacobo xhiꞌnn Alfeo, naꞌ Lebeo beꞌnnenꞌ goll akseꞌ Tadeo, ");
INSERT INTO zpuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","naꞌ Simón beꞌnnenꞌ ben txhen beꞌnn kaꞌ nziꞌi cananistas, naꞌ ren Judas Iscariote beꞌnnenꞌ ben Jesúsenꞌ rallnaꞌa beꞌnn kaꞌ llwie Leꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesúsenꞌ bseꞌleꞌ beꞌnn chllinn kaꞌ, jatixjweꞌ akreꞌ xtiꞌlleꞌn, lleꞌe leakeꞌ: —Bi chejre rall beꞌnn kaꞌ bi nak beꞌnn Israel, leskaꞌ bi chejre yell kaꞌ zjalliꞌ Samaria. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lelljak ganꞌ llaꞌa beꞌnn Israel kaꞌ, le leakeꞌn nak akeꞌ ka xhiꞌr daꞌo ba bnit. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lelljak lelljatixjweꞌ ba zo rez llin lla nnebiaꞌ Dios beꞌnnenꞌ zo yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lewayón beꞌnn llak bi yillweꞌ, naꞌ lewayón beꞌnn kaꞌ llak yillweꞌ danꞌ ne lepra, leyesbán beꞌnn wat ak, naꞌ leyebej daxiꞌo kaꞌ yoꞌ lo yichjraꞌlldaꞌo beꞌnne. Bibi bchixhj Diosenꞌ reꞌ, benneꞌ reꞌ yel wak keꞌen nench gonre da ki, ke len naꞌ legakrén beꞌnne, naꞌ bi wchixhjre. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Naꞌ bi waꞌre mell da nak oro, naꞌ mell plat naꞌ mell kobr chak koꞌre nez. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Naꞌ bi goꞌxre bzod, naꞌ bi goꞌxre ye to xhare, ni ye to xher-re, ni xhis da wchiꞌchre, le ka nak reꞌ nakre beꞌnn wen llin ke Dios, llayaꞌlkze gonn akeꞌ reꞌ da yeꞌj gaore, ganꞌ llseꞌlaꞌ reꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Naꞌ gateze yell ga llinre, zgaꞌtek lennab chaꞌ zo to beꞌnn wen, beꞌnn yewere wrebe reꞌ rilleꞌn. Naꞌ chaꞌ ba brebeꞌ reꞌ rilleꞌn, gannaꞌze lesó. Kat saꞌllre chejre ga yobre, kanaꞌll yezaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Naꞌ kat llinre rill to beꞌnne, lewape lliox, naꞌ lennab so akeꞌ wen. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Naꞌ chaꞌ zjaniꞌt beꞌnn nak yichjraꞌlldaꞌo akeꞌn wen, gak ka danꞌ nnabrenꞌ, naꞌ so akeꞌ wen. Naꞌ chaꞌ nono llraꞌ beꞌnn nak yichjraꞌlldaꞌo akeꞌn wen, naꞌ bi gak ka danꞌ nnabrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Naꞌ chaꞌ zo ga bi wreb akeꞌ reꞌ, naꞌ bi wzenay akeꞌ keré, leyelloj yoꞌn o yell ganꞌ bllinre, naꞌ leyebibte yo bichte llia lo labre. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Da xhinnj xhen naꞌ, ben beꞌnn Sodoma kaꞌ ren beꞌnn Gomorra kaꞌ kanaꞌ, zan ni llepaꞌ reꞌ, kat llin lla gak yel koxchis ke yeolol beꞌnne, kanaꞌ beꞌnn kaꞌ bi breb reꞌ rilleꞌn, da xhenll gak ke beꞌnn kaꞌ kerke kanꞌ gok ke beꞌnne Sodoma kaꞌ, ren Gomorra kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Nadaꞌ wseꞌlaꞌ reꞌ ka llseꞌleꞌ xhiꞌr daꞌo radj beꞌkw yiꞌo, lesó xhnid ka llon to bele, naꞌ maxhze legón ka llon to byinn daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Legap kwinre rao beꞌnn kaꞌ llwie reꞌn. Zjaniꞌt beꞌnn gon akeꞌ reꞌ rao naꞌa beꞌnn wnebiaꞌ kaꞌ, nench bi gon bi ne akreꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Naꞌ lekze kaꞌ danꞌ llonliraꞌllre nadaꞌ naꞌ, zjaniꞌt beꞌnn wcheꞌe reꞌ do rao rey, do rao nollre beꞌnn llnebiaꞌ nench weꞌrén akreꞌ xtiꞌllaꞌn, leskaꞌ rao beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Naꞌ kat goꞌx akeꞌ reꞌ, wcheꞌe akeꞌ reꞌ rao beꞌnn kaꞌ, bi weꞌlaꞌllre akre nnere yelliꞌre xtiꞌll akeꞌn. Rawe ganꞌ zere naꞌkze wzejnieꞌ Diosenꞌ reꞌ, akrenꞌ nnere. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Le kere reꞌn nnere, Spíritu ke Xallo Dios naꞌkzenꞌ gonnen bixhanꞌ llayaꞌl nnere. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Kanaꞌ bale beꞌnnache, yeyechj akeꞌ gon akeꞌ no biꞌch gorj akeꞌ rao naꞌa beꞌnne, naꞌ yesoꞌte leakeꞌ, naꞌ niꞌt beꞌnn gon akeꞌ xhiꞌnn akeꞌ kaꞌ, rao naꞌa beꞌnn yesoꞌtebeꞌ, naꞌ zjaniꞌt beꞌnne gon akeꞌ xaxhnaꞌ akeꞌ kaꞌ, rao naꞌa beꞌnne yesoꞌte leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Naꞌ ka yeololze beꞌnn wie akreꞌ reꞌ, danꞌ llonliraꞌllre nadaꞌ, naꞌ noteze beꞌnn se war wxenraꞌlleꞌ nadaꞌ llinte lla gateꞌ, leꞌen yerá. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chaꞌ beꞌnn llaꞌa to yell lloje yeraye reꞌ, lelljazó ga yobre. Da li niaꞌ reꞌ, bi nna wayoll tare yell kaꞌ ganꞌ nbane beꞌnn Israel kaꞌ, kat yedaꞌ nadaꞌ da yobre Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Kat to beꞌnn za wsede, bi nello naklleꞌ beꞌnn braoll ka beꞌnnenꞌ llsede leꞌen, naꞌ to beꞌnn wen llin bi nello naklleꞌ braoll ka xaneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kon llayaꞌle yewé beꞌnnenꞌ llsedenꞌ, chaꞌ yedoꞌlreꞌ gakeꞌ kanꞌ llon beꞌnnenꞌ broeꞌ leꞌe naꞌ, naꞌ llayaꞌle yewé beꞌnn wen llin naꞌ, chaꞌ yedoꞌlreꞌ gakeꞌ ka xaneꞌ naꞌ. Naꞌ nadaꞌ nakaꞌ xanre, naꞌ beꞌnn kaꞌ llwie nadaꞌn, llasné akeꞌ llonaꞌ txhen Beelzebú, danꞌ nak xan yeolol daxiꞌo ak, wasné aklleꞌ ke reꞌ nakre nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Bi llebre beꞌnn biteze da gon akreꞌ reꞌ, le bibi de da ngaꞌche da nello bi wroeꞌrawe, naꞌ bi de da nello nono yenneze len. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Da zan da broeꞌraꞌ reꞌ ganꞌ ngaꞌchre, lennén ganꞌ llaꞌa beꞌnn zan. Naꞌ yeolol da kaꞌ ba bénerenꞌ, lechixjweꞌn, legón ka to beꞌnn ze yichjo llosieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bi llayaꞌle llebre beꞌnn kaꞌ got reꞌn. Bitbi gak gon akreꞌ yichjraꞌlldaꞌore. Zan llayaꞌle llebre Diosenꞌ, le Leꞌen napeꞌ yel llnebiaꞌ, wlleyieꞌ kwerp kerénꞌ ren yichjraꞌlldaꞌorenꞌ lo yiꞌ gabilenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Nnézello byinn daꞌo kaꞌ bibi zaꞌk aktekbaꞌ, naꞌ Xallo Diosenꞌ llakbeꞌreꞌ kate llbeyiꞌ tobaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Rente yich yichjre kaꞌ nrab Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Naꞌllenꞌ niaꞌ bi llebre, zaꞌkll reꞌ kerke txhonnj byinn daꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Naꞌ noteze beꞌnne chaꞌ wchebeꞌ nnaweꞌ nadaꞌ, lekze kaꞌ nadaꞌ wachebaꞌ rao Xaꞌ Diosenꞌ llia yebá, yepeꞌ nak beꞌnnenꞌ nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Naꞌ notezeꞌ chaꞌ lloeꞌreneꞌ beꞌnnach diꞌll, naꞌ bi llchebeꞌ chaꞌ nombieꞌ nadaꞌ, lekze kaꞌ nadaꞌ weꞌrenaꞌ Xaꞌ beꞌnn zo yebá diꞌll, yepeꞌ bi nombiaꞌ beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Bi gákere bedaꞌ nench nniꞌt ren lwellj beꞌnn kaꞌ wen naꞌ. Bi nniꞌt akeꞌ wen, le yesdil akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ni ke danꞌ ba bedaꞌ naꞌ, yesdile beꞌnn byio ren xa akeꞌ, naꞌ noꞌrenꞌ kone xhneꞌe, naꞌ noꞌrenꞌ yedil ren xhorille leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Do lo yoꞌ rill akeꞌ naꞌze llaꞌa beꞌnn wie lwellj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Naꞌ noteze beꞌnne chaꞌ llakllreꞌ xeꞌe naꞌ xhneꞌen ka nadaꞌ, bi saꞌkeꞌ goneꞌ nadaꞌ txhen. Leskaꞌ chaꞌ llakllreꞌ xhiꞌnneꞌ, ka nadaꞌ bi saꞌkeꞌ goneꞌ nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Naꞌ beꞌnn bi wsanraꞌll kwineꞌ naꞌ naweꞌ nadaꞌ, naꞌ goneꞌ ka to beꞌnn noaꞌ cruz keꞌe, bibi zaꞌkeꞌ goneꞌ nadaꞌ txhen chaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Beꞌnnenꞌ llon bien yesrá yel nban ke kwineꞌ yellrio ni, leꞌen wniteꞌn, zan beꞌnnenꞌ llnit yel nban keꞌen ni kiaꞌ nadaꞌ, leꞌen gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Noteze beꞌnn llrebe reꞌ nadkzaꞌn llrebeꞌ, naꞌ beꞌnn llreb nadaꞌ renkze Dios beꞌnnenꞌ bseꞌl nadaꞌn llrebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Naꞌ noteze beꞌnne wrebeꞌ beꞌnn lloeꞌ xtiꞌll Diosenꞌ, ka da nbarazenꞌ siꞌi beꞌnnenꞌ lloeꞌ xtiꞌll Diosenꞌ, kaꞌ lekzen sieꞌ. Naꞌ beꞌnnenꞌ wrebe to beꞌnn wen, ni ke danꞌ wrebeꞌ beꞌnnenꞌ nak beꞌnn wen naꞌ, ka danꞌ nbarazenꞌ siꞌi beꞌnn wen naꞌ, kaꞌ lekzen sieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naꞌ noteze beꞌnne weꞌe la txhiꞌyze nis yeꞌj beꞌnn llonliraꞌll nadaꞌ, ni ke danꞌ beꞌe akeꞌ beꞌnnenꞌ nxenraꞌll nadaꞌ nis weꞌjeꞌ, da li niaꞌ reꞌ, bi nnitrao ka nake danꞌ ben akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ka bayoll bzejnieꞌ Jesúsenꞌ beꞌnn chllinn kaꞌ non Leꞌe txhen naꞌ, bazeꞌe gannaꞌ, naꞌ byejeꞌ yell kaꞌ zjalliꞌ do naꞌ, jaroeꞌ jasedreꞌ xtiꞌll Diosenꞌ beꞌnn kaꞌ zjallaꞌa gannaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bixha Juan beꞌnnenꞌ bchoa nis, ba yoeꞌ lo rill yanꞌ. Benreꞌ diꞌll, ka yeolol danꞌ llon Cristonꞌ. Naꞌll bseꞌl Juan naꞌ chop beꞌnn kaꞌ non leꞌe txhen naꞌ, ganꞌ zo Jesúsenꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jannab akreꞌ Leꞌe: —¿Rweꞌn nakoꞌ beꞌnnenꞌ bexhtoꞌ wseꞌl Diosenꞌ, chaꞌ ye to beꞌnn yobrenꞌ kwexhtoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Naꞌll lle Jesúsenꞌ leakeꞌ: —Lelljayak, naꞌ lelljayell Juan naꞌ doxhen danꞌ ba breꞌre naꞌ, naꞌ da kaꞌ ba bénere naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Beꞌnn lchol llareꞌe akreꞌ, beꞌnn xhinnj lladá akeꞌ, beꞌnn llak yillweꞌ danꞌ ne lepra llayak akeꞌ, beꞌnn kwell ba llayén akreꞌ, naꞌ beꞌnn wat ba babán akeꞌ, naꞌ beꞌnn yaꞌch daꞌo kaꞌ llzenay akeꞌ Diꞌll Wen ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Nbaraz ke beꞌnnenꞌ bi llakganreꞌ, naꞌ yezikre llejleꞌ kiaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Naꞌ ka ba zjayak beꞌnn kaꞌ bseꞌl Juan naꞌ, naꞌll beꞌrén Jesúsenꞌ beꞌnn kaꞌ ndopenꞌ xtiꞌll Juan naꞌ, lleꞌe leakeꞌ: —¿No beꞌnnenꞌ jawiare latj dachenꞌ? ¿To beꞌnn nak ka yia da zo lleꞌ da le llta beꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Akre nakeꞌ kanꞌ jawiare? ¿Nakeꞌ raꞌll chaꞌo? Ka beꞌnn kaꞌ zjanak raꞌll chaꞌo, zo akeꞌ yoꞌ wen kwis, ka no rill beꞌnn wnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Noxhanꞌ jawiakzre chaꞌ? ¿To beꞌnn lloeꞌ xtiꞌll Diosenꞌ? Da li lloeꞌ xtiꞌll Diosenꞌ, naꞌ ni yepaꞌ reꞌ, zaꞌklleꞌ ka noteze beꞌnn lloeꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ke beꞌnn ni nyoj leꞌ xtiꞌll Diosenꞌ, llian: Nadaꞌ Dios, wseꞌlaꞌ to beꞌnn kwiaraweꞌ raoꞌ, weꞌe xtiꞌlloꞌn nench yeweꞌ xhnneze ganꞌ teꞌo naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Da li niaꞌ reꞌ, nollre no beꞌnnach nna chas, beꞌnn nakll beꞌnn brao ka Juan naꞌ, beꞌnnenꞌ bchoa beꞌnne nis. Naꞌ nnaꞌ noteze beꞌnn llzenay ke Dios, nench nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌn, laꞌkze nakeꞌ beꞌnne le zeraoze beꞌnne bibi zaꞌke, gaklleꞌ beꞌnn braoll ka Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Kanꞌ bzorao Juan naꞌ bdixjweꞌreꞌ xtiꞌll Diosenꞌ, naꞌ bchoeꞌ beꞌnne nis bllinte nnaꞌ, beꞌnn zan llon akeꞌn ga zerao zaꞌk akreꞌ, nench yedoꞌl akreꞌ yel llnebiaꞌ ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kanaꞌtenꞌ bzoraon bllinte kanꞌ braꞌ Juan naꞌ, ley danꞌ bzoj da Moisésenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ, bzejnieꞌn lliꞌo ka nak yel llnebiaꞌ ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Naꞌ xtiꞌll Diosenꞌ danꞌ nyoj llian yed ye to beꞌnn yedyén kanꞌ ben Elías, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. Kaꞌ llian ke Juan naꞌ, kon chaꞌ chejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Reꞌ zo nayre, lewzenay xtiꞌllaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Notek ka wsaꞌkraꞌ reꞌ llaꞌa nnaꞌ lla? Wsaꞌkraꞌ reꞌ ka bidaꞌo ak zjallaꞌa lao yaꞌa, naꞌ lle lwellj akbeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ba bkwelltoꞌ bllej, naꞌ bi byaꞌre, naꞌ ba beltoꞌ da llon nyaꞌchraz, naꞌ ni ke bllellzre.” ");
INSERT INTO zpuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan beꞌnnenꞌ bchoa nis, bi weꞌj bdaochaꞌweꞌ ka lleꞌj llao nollre beꞌnne, naꞌ bnere keꞌe: “Daxiꞌo yoꞌ beꞌnnenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Naꞌ ka nak nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, naꞌ llreꞌre lleꞌj llawaꞌ kwasro, naꞌ nere kiaꞌ: “Le lleꞌj llaoxen beꞌnnenꞌ, naꞌ lloneꞌ txhen beꞌnn wachixhj kaꞌ, ren yezikre beꞌnn wen da xhinnj kaꞌ.” Zan zjallaꞌa akse beꞌnn llzenay ke Diosenꞌ. Leakeꞌn llroeꞌ akreꞌ kanꞌ nak yel siꞌn ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Naꞌll beꞌe Jesúsenꞌ xtiꞌll beꞌnn kaꞌ llaꞌa yell kaꞌ, ganꞌ beneꞌ zan da yebán akreꞌn, naꞌ bdileꞌ leakeꞌ danꞌ bi llayat akreꞌ ke da xhinnjenꞌ non akeꞌn, naꞌll bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Nyaꞌchraz ke reꞌ beꞌnn Corazín! ¡Naꞌ nyaꞌchraz ke reꞌ beꞌnn Betsaida! Chenake broeꞌraꞌ beꞌnn kaꞌ niꞌt yell kaꞌ nziꞌi Tiro, naꞌ Sidón yel wak kiaꞌn ka danꞌ ba broeꞌraꞌ reꞌ, batnaꞌ ba bayechj akeꞌ banao akeꞌ Diosenꞌ chenake, naꞌ llak akeꞌ to raꞌll gasj da nak zeꞌch, naꞌ llwazj kwin akeꞌ no de da llroeꞌn ba bayat akreꞌ chenake. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Naꞌ niaꞌ reꞌ, kate llin lla gak yel koxchis ke yeolol beꞌnne, da xhenll yellayraore kerke beꞌnn Tiro, naꞌ beꞌnn Sidón kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Naꞌ reꞌ beꞌnn Capernaum, llákere ba zekzre yebá, ga lleꞌle gor wazaꞌleꞌ reꞌ, ga yellayraore. Chenak benaꞌ da yebane beꞌnn kaꞌ bllaꞌa ganꞌ nziꞌi Sodomanꞌ kanꞌ ba benaꞌ raore ni, bayat akreꞌ xtoꞌl akeꞌn chenake, naꞌ bi blleyiꞌ yell ke akeꞌn chenake. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Niaꞌ reꞌ, gakll keré ye raꞌt ka ke beꞌnn Sodoma kaꞌ, katenꞌ llin lla gak yel koxchis ke yeolol beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naꞌll balwill Jesúsenꞌ Diosenꞌ, bneꞌe: —Lloeꞌrawaꞌ rweꞌ Dios Xa, rweꞌn llnebiaꞌo yebá naꞌ yellrionꞌ, bkwaꞌchoꞌ da ki, bi byejnieꞌ beꞌnn siꞌn kaꞌ len, naꞌ broeꞌroꞌn beꞌnn yaꞌch beꞌnn nak nexjraꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Benoꞌ kaꞌ Xa, le kaꞌn gokraꞌlloꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Naꞌ golleꞌ beꞌnn kaꞌ llaꞌa naꞌ: —Yeololte da de, Xaꞌn ba beneꞌn rallnaꞌ, naꞌ nono nombiaꞌ Xhiꞌnneꞌn, toz Xaꞌ naꞌn nombieꞌ Leꞌe, naꞌ nono nombiaꞌ Xaꞌn, toz nadaꞌ nak Xhiꞌnneꞌ nombieꞌ, naꞌ kon no llbejaꞌ nadaꞌ llroeꞌreꞌ kanꞌ nak Xaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ledá ganꞌ ziaꞌ ni, yeololtere ba lljaxaꞌkraꞌlle, naꞌ noaꞌre danꞌ nak ka to yoaꞌ ziꞌ. Naꞌ nadaꞌ gonnaꞌ ka yeziꞌraꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Legón nadaꞌ txhen, lewsed kanꞌ niaꞌ ni, le nadaꞌ nakaꞌ beꞌnn xate beꞌnn nexjraꞌlle, naꞌ kaꞌ yeziꞌraꞌll yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Danꞌ niaꞌ gonre naꞌ, bi naken bniꞌ, naken ka to yoaꞌ da bi naktek ziꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","To lla nbaꞌnn ke beꞌnn Israel kaꞌ bde Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen to rao yellrio ga de trigo. Naꞌ bdon beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ bzorao ll-lechj akeꞌ dao ke trigonꞌ, naꞌ bdao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Naꞌ breꞌe beꞌnn fariseo kaꞌ kanꞌ ben akeꞌn, naꞌ lle akeꞌ Jesúsenꞌ: —¿Bixchen llon beꞌnn kaꞌ llin, beꞌnn kaꞌ non rweꞌ txhen naꞌ, llon akeꞌ to da bi llayaꞌl gonllo lla nbaꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Bi nna golre kanꞌ ben da rey Davidenꞌ to lla ka bdon akeꞌ ren beꞌnn lwelljeꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Byoeꞌ ganꞌ nak rill Diosenꞌ, naꞌ bdaweꞌ yet xtir danꞌ nak laꞌy da bi llayaꞌl gao beꞌnn bi nak bxoz, naꞌ leskaꞌ bdaorén beꞌnn kaꞌ zej ren Leꞌe txhen naꞌ len. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Leskaꞌ bi nna golre leꞌ ley danꞌ bzoj da Moisésenꞌ ganꞌ llian, bxoz kaꞌ bi llaziꞌraꞌll akeꞌ lo yodaꞌo braonꞌ lla kaꞌ nak lla nbaꞌnne? Naꞌ nono ll-lliayiꞌll leakeꞌ danꞌ llon akeꞌ llin naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ni llepaꞌ reꞌ, nadaꞌ zoaꞌ ganni zaꞌkllaꞌ ye raꞌt ka yodaꞌo braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xtiꞌll Dios danꞌ nyoj nen: “Lleꞌnraꞌ yeyaꞌchraꞌllre beꞌnne kerke da gotzre no bayiꞌx, gákere nadaꞌn lloeꞌraore.” Chenak llejnieꞌre kanꞌ naken naꞌ, bi wxoare doꞌl koꞌll beꞌnn bibi doꞌl nape. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Niaꞌ reꞌ, nadaꞌn nakaꞌ Beꞌnn Gorj Radj Beꞌnnach, nakaꞌ xan llanꞌ llapre baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesúsenꞌ bazeꞌe gannaꞌ, naꞌ byoeꞌ to lo yodaꞌo ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naꞌ lo yodaꞌo naꞌ, zo to beꞌnn nxhoꞌn chlaꞌ neꞌe, naꞌll lle beꞌnn fariseo kaꞌ Jesúsenꞌ: —¿De latj wayonllo beꞌnn xhinnj to lla nbaꞌnne? Lle akeꞌ Leꞌe kaꞌ nench kone len wlliayiꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bixha chaꞌ reꞌ nniꞌt xhiꞌr daꞌo keré, naꞌ chaꞌ tobaꞌ lljachoꞌbaꞌ to lo yell zitj lla nbaꞌnne, ¿wsanraꞌllrebaꞌ, bi yebejrebaꞌ rao lla naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ke len naꞌ niaꞌ, dekze latj gakrenllo beꞌnne, llanꞌ nak lla llapllo baraꞌnne, le zaꞌklle to beꞌnne kerke to xhiꞌr daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naꞌll lleꞌe beꞌnnenꞌ nxhoꞌn taꞌkeꞌn: —Bli naꞌon. Naꞌ le blite naꞌa beꞌnnenꞌ, bayakten wen ka danꞌ ye chlaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naꞌll ka ballach beꞌnn fariseo kaꞌ yodaꞌon, naꞌ llayirjlaꞌll akeꞌ akre ka gon akeꞌ got akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ka gokbeꞌe Jesúsenꞌ kaꞌ, naꞌ babeꞌyiꞌlleꞌ bayejeꞌ ga yobre. Beꞌnn zan jannao Leꞌe, naꞌll bayoneꞌ yeolol beꞌnn kaꞌ llak yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naꞌll goꞌtyoereꞌ leakeꞌ, bi weꞌrén akeꞌ beꞌnn diꞌll nonꞌ bayón leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Beneꞌ kaꞌ nench bzoa xtiꞌll Diosenꞌ danꞌ bzoj da Isaíasenꞌ, kanꞌ bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Beꞌnn ninꞌ nakeꞌ beꞌnn wen llin kiaꞌ, beꞌnn brejaꞌ, naꞌ beꞌnn nllieꞌraꞌ. Naꞌ llaweraꞌ danꞌ lloneꞌn. Naꞌ nadaꞌ wseꞌlaꞌ Spíritu kiaꞌn sorenteze sorenen Leꞌe. Naꞌ chixjweꞌreꞌ yeolol beꞌnn kaꞌ zjallaꞌa doxhen yellrio da nak da li llazraꞌllaꞌ gon akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naꞌ bi gakyollreneꞌ beꞌnn kaꞌ, ni ke gosiaꞌzeꞌ, nono yene ka nak chieꞌ do tnez kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bi wzoꞌye da nak lleꞌne. Bi wasoreꞌ to yiꞌ daꞌo, da za bzorao llaꞌle, llinte lla goneꞌ gak kon ka da zjazé lilla rao yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Naꞌ beꞌnn llaꞌa yeolol yell, so akeꞌ kwexh akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naꞌ zo to beꞌnne lchole, naꞌ nakteꞌ blloje, yoꞌnyaz daxiꞌo yichjraꞌlldaꞌweꞌ, naꞌll jwaꞌa akeꞌ leꞌe rao Jesúsenꞌ. Naꞌ babejeꞌ daxiꞌon yoeꞌn, naꞌll le bareꞌtereꞌ, naꞌ le banneteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naꞌll yeolol beꞌnn kaꞌ breꞌe kanꞌ beneꞌn, babán akreꞌ kwis. Naꞌll lle lwellj akeꞌ: —¿Kere beꞌnn ninꞌ bezllo yedeꞌ rao dialla ke rey Davidenꞌ lla? ");
INSERT INTO zpuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Naꞌ ka bene beꞌnn fariseo kaꞌ diꞌll ki, naꞌll ne akeꞌ: —Bitbi yel wak nap beꞌnnenꞌ. Xan daxiꞌo kaꞌ nziꞌi Beelzebú naꞌn llakrén leꞌe, llabejeꞌ daxiꞌo kaꞌ yoꞌ yichjraꞌlldaꞌo beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naꞌ ka gokbeꞌe Jesúsenꞌ kanꞌ zaꞌraꞌll lo raꞌlldaꞌo beꞌnn fariseo kaꞌ, naꞌll lleꞌe leakeꞌ: —Yeololte da llnebiaꞌ chaꞌ gaken chopre, kweyiꞌn, naꞌ leskaꞌ to yell o to yoꞌ rill beꞌnnenꞌ, chaꞌ gaken chopre, bi sibian. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Leskaꞌ chaꞌ daxiꞌon yebejen ye to daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne, weyiꞌ yel llnebiaꞌ ken, le kwinzen ba lladilrenen. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Naꞌ chaꞌ reꞌ nere xan daxiꞌo kaꞌ llakrén nadaꞌ llabejaꞌ daxiꞌon, chaꞌ naken kanꞌ nere naꞌ, ¿noxha llakrén beꞌnn kaꞌ nao reꞌn nench yebej akeꞌ daxiꞌo kaꞌ yoꞌ yichjraꞌlldaꞌo beꞌnne? Naꞌ danꞌ llon akeꞌ naꞌ, llroeꞌn reꞌ bi naken kanꞌ nere naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Zan ke nak nadaꞌ, Spíritu ke Dios naꞌn llonnen nadaꞌ yel wak nench llabejaꞌ daxiꞌo kaꞌ, naꞌ ka danꞌ llonaꞌ naꞌ, llroeꞌn reꞌ ba bllin lla nnebiaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Akre gak choꞌ to beꞌnn wan lo yoꞌ ke to beꞌnn war nench sieꞌ bi da de keꞌe, chaꞌ bi wchejeꞌ leꞌe? Zan kaꞌn goneꞌ, naꞌll gak sieꞌ bi da de ke beꞌnnenꞌ lo yoꞌ rilleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Beꞌnn bi lloneꞌ nadaꞌ txhen, llwiereꞌ nadaꞌn. Naꞌ beꞌnn bi llakreneꞌ nench wzenay beꞌnn kaꞌ kiaꞌ, yezikre lloneꞌ nench nono wzenaykze kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ke len naꞌ llepaꞌ reꞌ, yeolol da xhinnj da llon beꞌnnach, naꞌ yeolol diꞌll yaꞌ, danꞌ llach lloaꞌ akeꞌn, Dios naꞌ yeziꞌxheneꞌ ke akeꞌ, zan nollre beꞌnne, chaꞌ nneꞌe ke Spíritu ke Diosenꞌ, ni ke yeziꞌxhenze Diosenꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Naꞌ chaꞌ no beꞌnne llnneꞌe kiaꞌ nadaꞌ, nakaꞌ Beꞌnn Gorj Radj Beꞌnnach, waziꞌxhenkze Diosenꞌ keꞌe; zan chaꞌ no beꞌnne nneꞌe ke Spíritu ke Diosenꞌ, kbatlle yeziꞌxhen Diosenꞌ keꞌe, ni nnaꞌ ni batteze. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ka nak no yay xhix kaꞌ, danꞌ nak yay wen naꞌ, daxhix wenkze llbian, naꞌ yay danꞌ bi nak yay wen lekze daxhix bi nak wen llbian. Naꞌ kaꞌ llnnézello akrenꞌ nake danꞌ llbia toto yay kaꞌ, naꞌ llnnézello kanꞌ nak yayenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Kanꞌ nakse reꞌ, nakre beꞌnn zban, beꞌnn wxhiyeꞌe, llonre ka bele! Bibi diꞌll wen gak weꞌre ka nak yoꞌ da xhinnjenꞌ lo raꞌlldaꞌore. Le yeololte diꞌllenꞌ ll-lloj lloaꞌllonꞌ da zaꞌkze lo raꞌlldaꞌollo naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","To beꞌnn wen lloeꞌkzeꞌ diꞌll wen, le kon kanꞌ nake lo raꞌlldaꞌweꞌ naꞌn lloeꞌ diꞌllenꞌ; naꞌ to beꞌnn wen da xhinnj lloeꞌ diꞌll da ke zaꞌke, le kaꞌn nakse raꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naꞌ ni niaꞌ reꞌ, kate llin lla gon Diosenꞌ yel koxchis ke yeolol beꞌnne, kanaꞌ yeolol beꞌnne wadé akeꞌ yeolol diꞌll danꞌ ba beꞌe akeꞌ da bibi zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Naꞌ kone diꞌll danꞌ weꞌre, Dios naꞌ choyraweꞌ keré chaꞌ napre doꞌle, naꞌ chaꞌ bibi doꞌl napre. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ beꞌnn fariseo kaꞌ lle akeꞌ Jesúsenꞌ: —Maestro, lleꞌnetoꞌ gonoꞌ to yel wak da reꞌtetoꞌ nench nnézetoꞌ chaꞌ da linꞌ bseꞌl Diosenꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naꞌll goll Jesúsenꞌ leakeꞌ: —Reꞌ yoꞌ da xhinnj lo raꞌlldaꞌore, naꞌ ba bsanraꞌllre Dios. Naꞌ llnnabre gonaꞌ ye to yel wak da reꞌtere, zan bi gonaꞌ ka danꞌ llnnabrenꞌ, zeraoze ka danꞌ broeꞌ Diosenꞌ reꞌ, ka danꞌ benreneꞌ da Jonás, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonásenꞌ byoeꞌ lo leꞌ bel xhen naꞌ chonn lla chonn yere. Naꞌ kaꞌkze nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach gataꞌ, naꞌ choaꞌ lo banꞌ chonn lla chonn yere. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Naꞌ kat llin lla gon Diosenꞌ yel koxchis ke yeolol beꞌnne, kanaꞌ beꞌnn Nínive kaꞌ wabanrén akeꞌ beꞌnn ki llaꞌa nnaꞌ, naꞌ wchoybiaꞌ akeꞌ ke akeꞌ, le leakeꞌn, ka ben akreꞌ xtiꞌll da Jonásenꞌ, bayat akreꞌ ke da xhinnj ke akeꞌn, naꞌ nadaꞌ zaꞌktellaꞌ kerke Jonásenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Naꞌ lekze lla naꞌ kat gon Diosenꞌ yel koxchis ke yeolol beꞌnne, noꞌrenꞌ bnebiaꞌ yellenꞌ re Sabá, wabanreneꞌ txhen beꞌnn ki llaꞌa nnaꞌ, naꞌ wchoybieꞌ ke akeꞌ, le leꞌen ziꞌt kwis bedeꞌ badzenayeꞌ yel siꞌn ke da Salomón naꞌ, naꞌ nadaꞌ zaꞌktellaꞌ kerke Salomón naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Kate to daxiꞌo llallojen yichjraꞌlldaꞌo beꞌnnenꞌ, naꞌ dan llayirjen ga lljachoꞌn ga yobre. Naꞌ chaꞌ bi ll-llelen to latj ga yeziꞌraꞌllen, ");
INSERT INTO zpuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","naꞌll nnen: “Wayaꞌchkaꞌ lljawiaꞌ ganꞌ ballojaꞌn, chaꞌ gak lljalloaꞌ da yobre.” Naꞌll llayejen lljawian ganꞌ zo beꞌnnenꞌ, naꞌ kate reꞌren raꞌlldaꞌo beꞌnnenꞌ, naken ka to yoꞌ da nxhi nloa, naꞌ ndachen. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naꞌll lljatopen ye gall daxiꞌo da llonll ka len, naꞌll yellaꞌa aken txhen lo raꞌlldaꞌo beꞌnnenꞌ. Naꞌ chaꞌ kaꞌ ba ben akeꞌn, naꞌll yezikre gakll ke beꞌnnenꞌ, kere kanꞌ gok keꞌe kanaꞌ. Naꞌ kaꞌ yaꞌnnkzenꞌ gak ke beꞌnn wen da xhinnj kaꞌ, llaꞌa nnaꞌ lla. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nna lloeꞌte Jesúsenꞌ diꞌll ren beꞌnn kaꞌ, ka bllin xhneꞌe ren biꞌcheꞌ kaꞌ, naꞌ gokraꞌll akeꞌ weꞌrén akeꞌ Leꞌe diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Naꞌ to beꞌnn ze ren gannaꞌ golleꞌ Jesúsenꞌ: —Xhnaꞌo ren beꞌnn biꞌchoꞌ kaꞌ ze akteꞌ koꞌlle naꞌ, lleꞌn akreꞌ weꞌrén akeꞌ rweꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Naꞌll lle Jesúsenꞌ leꞌe: —¿Noxhanꞌ nak xhnaꞌ, naꞌ noxha nak biꞌch lwelljaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Naꞌll bli neꞌen ganꞌ llaꞌa beꞌnn kaꞌ nak Leꞌe txhen naꞌ, naꞌll bneꞌe: —Beꞌnn kinꞌ nak xhnaꞌ, naꞌ biꞌch lwelljaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Le noteze beꞌnne llone kanꞌ llazraꞌll Xaꞌ Dios beꞌnnenꞌ zo yebá naꞌ, leꞌen nak beꞌnn biꞌchaꞌ, beꞌnn zanaꞌ naꞌ xhnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Rao lla naꞌ, bzaꞌa Jesúsenꞌ yoꞌ ganꞌ zoeꞌ naꞌ jachieꞌ lloaꞌ nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Naꞌll bdop beꞌnn zan kwis ganꞌ llieꞌn, naꞌll byepeꞌ lo barconꞌ jachieꞌ. Yeolol beꞌnn kaꞌ bdopenꞌ zellá akeꞌ lloaꞌ nisdaꞌon ga nak yo bill. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Naꞌll da zan da broeꞌ bsedreꞌ leakeꞌ bsaꞌkrebreꞌ bi da kaꞌ, bneꞌe: —To beꞌnn wen llin jezeꞌ nbaz, ");
INSERT INTO zpuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","naꞌ ka zejeꞌ lloseꞌ nbazenꞌ, raꞌt danꞌ llazeꞌ naꞌ, jeꞌten lloaꞌ nez, naꞌ byinn kaꞌ llasdá leꞌ yebánꞌ betj akbaꞌ jatao akbaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Naꞌ ye raꞌtenꞌ jachaꞌn ga nake rao yej ga lliꞌ chdeꞌjze yo, naꞌ da naꞌ, byob braꞌn le raꞌtze yo lliꞌ ganꞌ jeꞌten naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Naꞌ ka braꞌ will naꞌ, bzeyen len, naꞌ byechen le bi nyintek roe zitj. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ye raꞌtenꞌ jagoꞌnnen ga nak lo yay yeꞌche, ka blliꞌo yay yeꞌchenꞌ, naꞌ benen len roe. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Naꞌ ye raꞌtenꞌ jagoꞌnnen ga nak yo chaꞌo, naꞌ braꞌ aken, naꞌ balen bllia to gayoa (100) weje toton, naꞌ ye balen bllian wyon (60) weje, naꞌ ye balen chi lloa (30) weje. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Reꞌ zo nayre, lewzenay kaꞌn niaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naꞌll beꞌnn kaꞌ non Jesúsenꞌ txhen jabiꞌy akeꞌ awllo, lle akeꞌ Leꞌe: —¿Bixchen llsaꞌkrebroꞌ bi da kaꞌ katenꞌ llroeꞌ llsedroꞌ beꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naꞌll lle Jesúsenꞌ leakeꞌ: —Nono nna nneze kanꞌ nak yel llnebiaꞌ ke Diosenꞌ, zan nnaꞌ ba lloneꞌ nench reꞌ ba llonliraꞌllre nnézeren. Zan beꞌnn yobre bi wroeꞌ Diosenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Le noteze beꞌnn llzenay xtiꞌll Diosenꞌ wzejnieꞌlle Diosenꞌ leakeꞌ, nench chanll danꞌ chejnieꞌ akreꞌn, naꞌ noteze beꞌnne bi llzenay, da daꞌon ba nnez akreꞌ raꞌten, yekaꞌa Diosenꞌ len. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ke len naꞌ llroeꞌ llsedraꞌ beꞌnn ki kone da kaꞌ llsaꞌkrebraꞌ, le llreꞌe aktereꞌ danꞌ llonaꞌn, naꞌ bi llakbeꞌe akreꞌ bi zejen naꞌ, llen aktereꞌ xtiꞌllaꞌn, naꞌ bi llejnieꞌ akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ke len naꞌ beꞌnn ki ba llzoa akeꞌ diꞌll kanꞌ bzoj da Isaíasenꞌ, kanꞌ bneꞌe: Da li yénere, naꞌ bi chejnieꞌre akre zejen daꞌn yénerenꞌ. Naꞌ reꞌtere, naꞌ bi wayakbeꞌre bi zejen danꞌ llreꞌre naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nak akeꞌ beꞌnn bi llzenay, ba natkze yichjraꞌlldaꞌo beꞌnn ki. Bi llen akreꞌ kwasro, naꞌ nchod rao akeꞌn, le bill lleꞌn akreꞌ reꞌe akreꞌ kone rao akeꞌ naꞌ, naꞌ yen akreꞌ kone nay akeꞌ naꞌ, naꞌ chejnieꞌ akreꞌ lo raꞌlldaꞌo akeꞌ naꞌ, naꞌ yeyat akreꞌ, naꞌll gak yebej akeꞌ lo da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Naꞌ reꞌ nakre nadaꞌ txhen, nbaraz keré danꞌ llwiare da kaꞌ llonaꞌn, naꞌ llzenayre xtiꞌllaꞌn, naꞌ llejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Da li niaꞌ reꞌ, zan beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, naꞌ zan beꞌnn kaꞌ yezikre bzenay ke Diosenꞌ kanaꞌ, gokraꞌll akeꞌ kwis reꞌe akreꞌ danꞌ llreꞌre nnaꞌ, naꞌ bill goꞌle reꞌe akreꞌn. Naꞌ gokraꞌll akeꞌ kwis yen akreꞌ danꞌ llénere naꞌ, naꞌ leskaꞌ bill goꞌle yen akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Lewzenay ke, kinꞌ chejnieꞌllo diꞌll ke beꞌnn wen llin naꞌ, jez nbazenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Noteze beꞌnn llene xtiꞌll Diosenꞌ danꞌ llzejnieꞌ ke yel llnebiaꞌ keꞌen, naꞌ chaꞌ bi llejnieꞌreꞌn, le llinte daxiꞌon llabejen len lo raꞌlldaꞌweꞌn; naꞌ nakeꞌ ka nbaz danꞌ jeꞌt lloaꞌ nezenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Naꞌ nbaz danꞌ jachaꞌa ganꞌ nak lo yejenꞌ, naꞌ bi bdin roe, naken ka beꞌnn kaꞌ le llawete xtiꞌll Diosenꞌ kat llen akreꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","leakeꞌn nak ka da bi nyin roe zitj, chollze llejleꞌ akeꞌ ke xtiꞌll Diosenꞌ, naꞌ kat bi da daꞌo llak ke akeꞌ, naꞌ kat llwie beꞌnne leakeꞌ danꞌ llzenay akeꞌ xtiꞌll Diosenꞌ, le llbej yichj akteꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Naꞌ nbaz danꞌ jagoꞌnn ganꞌ nak lo yay yeꞌche danꞌ bi blliꞌo naꞌ, zejen ka beꞌnn kaꞌ ba bene xtiꞌll Diosenꞌ, naꞌ da zed kaꞌ da de rao yellrio ni, naꞌ yel wniaꞌ danꞌ ziyeꞌe lliꞌo, bi lloeꞌn latje yegaꞌnn xtiꞌll Diosenꞌ lo raꞌlldaꞌweꞌn, naꞌ nak akeꞌ ka nbaz danꞌ bibi llbia. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Naꞌ nbaz danꞌ jagoꞌnn rao yo chaꞌo naꞌ, zejen ka beꞌnnenꞌ llene xtiꞌll Diosenꞌ, naꞌ llejnieꞌreꞌn naꞌ llzenayeꞌn. Nak akeꞌ ka danꞌ bllia to gayoa (100) weje, naꞌ ye balen bllia wyon (60) weje, naꞌ ye balen chi lloa (30) weje. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Naꞌll beꞌrén Jesúsenꞌ beꞌnn kaꞌ ye to diꞌll, lleꞌe leakeꞌ: —Yel llnebiaꞌ ke Dios beꞌnnenꞌ zo yebánꞌ llonen rebze ka gok ke to beꞌnnenꞌ jez nbaz wen rao yellrio keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Naꞌ do llere ka tas akeꞌ, byej to beꞌnn llwie leꞌe, naꞌ jazaꞌleꞌ nbaz yiꞌx ganꞌ ba naz beꞌnnenꞌ trigonꞌ, bayoll naꞌ naꞌll bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naꞌ to chiꞌze braꞌ nbaz yiꞌxenꞌ ren trigonꞌ, naꞌ ka bzorao trigonꞌ llbian. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Naꞌ gokbeꞌe beꞌnn wen llin ke xan yellrionꞌ, naꞌll jayakeꞌ jayell akeꞌ xan akeꞌn: “Ke beꞌnne, ¿kere nbaz wen ke trigonꞌ gozoꞌ rao yellrio koꞌon? ¿Bixchen nchixzen yiꞌxe da bibi llbia?” ");
INSERT INTO zpuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Naꞌll lle xan akeꞌn leakeꞌ: “To beꞌnn llwie nadaꞌn jen kaꞌ.” Naꞌll lle beꞌnn wen llin kaꞌ leꞌe: “¿Akxha gontoꞌ? ¿Wlaꞌlltoꞌ yiꞌxenꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naꞌ lleꞌe leakeꞌ: “Bi wlaꞌllren nench ke wlaꞌllrentere trigo naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Waljezen naꞌ chiꞌo akllen txhen. Naꞌ kat llin lla yeziꞌre danꞌ gozre naꞌ, kanaꞌ niaꞌ zgaꞌtek yiꞌx naꞌ, laꞌllre gonren to bnok weje, naꞌ cheyen, naꞌtelle yetopre trigonꞌ wllaꞌchaꞌoren.” ");
INSERT INTO zpuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Naꞌll beꞌe diꞌll kanꞌ nak yel llnebiaꞌ ke Diosenꞌ, bneꞌe: —Yel llnebiaꞌ ke Dios beꞌnnenꞌ zo yebánꞌ rebze naken ka to nbaz ke mostaz, ka danꞌ goz to beꞌnn rao yellrio keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Laꞌkze nbaz ke mostazenꞌ nakllen da daꞌo ka nbaz kaꞌ yelaꞌ, naꞌ kate llraꞌn naꞌ, leren ll-lliꞌoll ka billre yay, llakllen to yay xhenlle, naꞌll lljallia no xoꞌnn byinn daꞌo kaꞌ rao xhoꞌze naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Naꞌll bsaꞌkrebe Jesúsenꞌ ye to da yobre, lleꞌe leakeꞌ: —Yel llnebiaꞌ ke Dios beꞌnnenꞌ zo yebánꞌ, naken ka kwa binn da bxhiꞌi to noꞌre, naꞌ bchixeꞌn trob yezj, naꞌ baslliꞌon kwa ke yet xtir naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeolol da ki broeꞌ bsede Jesúsenꞌ rao beꞌnn zan kaꞌ bzenay keꞌen ganꞌ zeꞌe naꞌ. Broeꞌ bsedreꞌ leakeꞌ, bsaꞌkrebreꞌ bi da kaꞌ, bibi bzejnieꞌreꞌ leakeꞌ billre. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Beneꞌ kaꞌ nench gok kanꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ: Wroeꞌ wsed akreꞌ, wsaꞌkrebraꞌ bi da kaꞌ, naꞌ yep akeꞌ da nono nna nneze, da ngaꞌch ka bxhete yellrio. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Bayoll broeꞌ bsedreꞌ beꞌnn kaꞌ zjallaꞌa naꞌ, baseꞌl Jesúsenꞌ leakeꞌ lljayakeꞌ. Naꞌ byoeꞌ lo yoꞌ ganꞌ zo akeꞌ naꞌ, naꞌll jabiꞌy beꞌnn kaꞌ non Leꞌe txhen naꞌ, awllo kwiteꞌn lle akeꞌ Leꞌe: —Bzejnieꞌcheke netoꞌ akre zeje diꞌllenꞌ beꞌon ke trigonꞌ ren nbaz yiꞌx naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Naꞌll lleꞌe leakeꞌ: —Kinꞌ naken: ka nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, nakaꞌ ka beꞌnnenꞌ goz nbaz wen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Naꞌ doxhente yellrio ni, naken ka latj ganꞌ gozeꞌ trigo naꞌ. Naꞌ beꞌnn kaꞌ llzenay ke Diosenꞌ nak akeꞌ ka nbaz wen naꞌ. Naꞌ beꞌnn kaꞌ nxenraꞌll daxiꞌon leakeꞌn nak ka nbaz yiꞌx naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Daxiꞌon naken beꞌnnenꞌ goz nbaz yiꞌx naꞌ. Naꞌ llanꞌ gak yel koxchis ke yeolol beꞌnn kaꞌ naken ka llanꞌ llon akeꞌ wrape, naꞌ angl kaꞌ nak akeꞌ ka beꞌnn kaꞌ llon wrapenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Naꞌ kanꞌ llatop akeꞌ yiꞌx kaꞌ, naꞌ llzey akenꞌ, kaꞌn gak ke beꞌnn kaꞌ llnnerén daxiꞌon kat llin lla gak yel koxchis ke yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach wseꞌlaꞌ angl kiaꞌ kaꞌ kat llin lla naꞌ, nench yetop akeꞌ yeolol beꞌnn kaꞌ, llkoꞌyele beꞌnne yobre gon akeꞌ da xhinnj, naꞌ yezikre beꞌnn llon da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Naꞌ yeseꞌleꞌ leakeꞌ lo yiꞌ gabil ga chaꞌa akeꞌ ke chnare chey akeꞌ, gannaꞌ kwell akeꞌ, to gaoxoxj lay akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kanaꞌllenꞌ Xallo Diosenꞌ goneꞌ nench beꞌnn kaꞌ llon da wen naꞌ, nniꞌtrén akeꞌ Leꞌe txhen, le leakeꞌn nak xhiꞌnneꞌ, naꞌ yeyak akeꞌ ka beniꞌ ke will kat yellín akeꞌ yebá ganꞌ llia Diosenꞌ llnebieꞌ. Reꞌ zo nayre lewzenay xtiꞌllaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Naꞌ Yel llnebiaꞌ ke Dios beꞌnnenꞌ zo yebánꞌ naken ka to mell xhen da ngaꞌche to rao yellrio. Naꞌ to beꞌnne ballelreꞌn, naꞌll bakwaꞌcheꞌn da yobre lekze rao yellrio naꞌkze, naꞌ llawereꞌ kwis zayejeꞌ, naꞌll jayeꞌte yeolol bi da de keꞌe nench bazieꞌ yellrio ganꞌ ngaꞌch mellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Naꞌ yel llnebiaꞌ ke Dios beꞌnnenꞌ zo yebánꞌ llonen ka ke to beꞌnn dá lloꞌt biteze, naꞌ deꞌe yirjeꞌ yej chaꞌo danꞌ nziꞌi perla. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Naꞌ kat ll-llelreꞌ to yej chaꞌo da zaꞌk, naꞌ llayoꞌteꞌ yeolol bi da de keꞌe nench wayaꞌweꞌ yej chaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Naꞌ yel llnebiaꞌ ke Dios beꞌnnenꞌ zo yebánꞌ zaꞌkrebren ka to yixj bel. Naꞌ bal beꞌnn wxhen bel kaꞌ bzaꞌl akeꞌ yixj ke akeꞌn lo nisdaꞌon, naꞌ bxhenen zan kwen ba llaꞌa lo nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Naꞌ ka ba ballaꞌn naꞌ, babej akeꞌn lloaꞌ nisdaꞌon, naꞌll llabé akebaꞌ, naꞌ ba nak wen, llallaꞌa akebaꞌ lo llom. Naꞌ ba kaꞌ bi nak wen naꞌ, lloꞌnn akebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kanꞌ gak katenꞌ llin lla, te ke yellrio ni. Angl kaꞌ yebej akeꞌ beꞌnn wen da xhinnj kaꞌ zjarén radj beꞌnn kaꞌ nake beꞌnn wen rao Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Naꞌll wazaꞌleꞌ leakeꞌ lo yiꞌ gabil ganꞌ lljallell akeꞌ ga zeraoze to gaoxoxj lay akeꞌ yel llallayrao ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesúsenꞌ lleꞌe leakeꞌ: —¿Zyejnieꞌre yeolol da ki ba broeꞌraꞌ reꞌn? Naꞌll lle akeꞌ Leꞌe: —Zyejnieꞌkzetoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naꞌll lleꞌe leakeꞌ: —Noteze beꞌnne chaꞌ llak llroeꞌ llsedreꞌ ley ke Diosenꞌ danꞌ byoj kanaꞌ, naꞌ chaꞌ llzenaykzeꞌ kanꞌ llroeꞌ llsedraꞌ ke yel llnebiaꞌ ke Diosenꞌ, naꞌllenꞌ nakeꞌ ka to xan yoꞌ beꞌnne napeꞌ yeolol da zaꞌke da yalljreꞌ llonreneꞌ llin, balen nak da kobe, naꞌ balen nak da gore. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka bayoll beꞌe Jesúsenꞌ diꞌll ki, naꞌll bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Naꞌ bayejeꞌ ralleꞌn, naꞌ jaroeꞌ jasedreꞌ beꞌnn wrall keꞌe kaꞌ lo yodaꞌo ke akeꞌn. Naꞌ babán akreꞌ kwis ke diꞌllenꞌ lloeꞌn, naꞌ lle lwellj akeꞌ: —¿Ga jasedeꞌ yel siꞌn naꞌ? ¿Naꞌ gaxha jaxieꞌ yel wak ki lloneꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Kere leꞌen xhiꞌnn beꞌnn wenchaꞌo yayenꞌ, naꞌ xhneꞌen reꞌe María? Naꞌ biꞌcheꞌ kaꞌ re Jacobo, José, Simón naꞌ Judas. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naꞌ lekze niꞌt zaneꞌ kaꞌ rall-llo ni. ¿Akxha llaken lloeꞌ diꞌll ki, naꞌ llakteꞌ lloneꞌ yel wak ki? ");
INSERT INTO zpuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naꞌ bi gokraꞌll akeꞌ chejleꞌ akeꞌ keꞌe, naꞌll lleꞌe leakeꞌ: —Yeololze beꞌnne lloeꞌrao akeꞌ beꞌnn lloeꞌ xtiꞌll Dios, zan ka nak beꞌnn wrall keꞌe kaꞌ, naꞌ beꞌnn lo yoꞌ keꞌe bi llap akeꞌ leꞌe baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naꞌll to chopze yel wak beneꞌ Nazaretenꞌ le nono byejleꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka llanꞌ llnebiaꞌ beꞌnnenꞌ re Herodesenꞌ ganꞌ nbane Galileanꞌ benreꞌ diꞌll kanꞌ llze ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naꞌll golleꞌ beꞌnn wen llin keꞌe kaꞌ: —Beꞌnn ninꞌ Juan beꞌnnenꞌ bchoa nis babaneꞌ radj beꞌnn wat kaꞌ, naꞌllenꞌ llak lloneꞌ yel wak ki. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bne Herodesenꞌ kaꞌ le leꞌen golleꞌ beꞌnn kaꞌ beꞌx akeꞌ Juan naꞌ, naꞌ bchej akeꞌ niaꞌneꞌe, naꞌ broꞌ akeꞌ leꞌe lo rill yanꞌ. Beneꞌ kaꞌ, xtoꞌl Herodías beꞌnnenꞌ nak xhoꞌr biꞌcheꞌ beꞌnnenꞌ re Felipe. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Le goll Juan naꞌ leꞌe: —Bi llayaꞌle sorenoꞌ xhoꞌr biꞌchoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes naꞌ, gokraꞌlleꞌ goteꞌ Juan naꞌ, naꞌ bi bayaxhjreꞌ, bllebeꞌ beꞌnn kaꞌ, le beꞌnn zan beꞌnn yell llejleꞌ akeꞌ ke Juan naꞌ, lloeꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naꞌ ka btil Herodesenꞌ iz, ben akeꞌ lnni, naꞌll xhiꞌnn Herodíasenꞌ bi noꞌre bllojbeꞌ byaꞌbeꞌ rao beꞌnn zan kaꞌ. Naꞌll bayazraꞌll Herodesenꞌ kwis kanꞌ byaꞌ bi noꞌr weꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Naꞌll bzoeꞌ Diosenꞌ wieꞌ bi da goneꞌ keꞌe, chaꞌ bi weꞌe bi noꞌr weꞌon kon biteze nnábebeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naꞌll bkoꞌyele xhnaꞌbeꞌn lebeꞌ nench yebeꞌ Herodesenꞌ: —Yichj Juan beꞌnnenꞌ llchoa nis naꞌ, bennen ganni, naꞌ wlliaꞌon to lo yeꞌnn nllirje. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Naꞌ reyenꞌ gokreꞌ kwis kanꞌ goll bi noꞌr weꞌon leꞌen, le ba bzoeꞌ Diosenꞌ rao beꞌnn zan kaꞌ weꞌebeꞌ kon biteze da nnábebeꞌ leꞌe, naꞌllenꞌ benchazeꞌ danꞌ bnnabbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Naꞌll golleꞌ beꞌnn kaꞌ wchoy akeꞌ yen Juan naꞌ, lo rill ya ganꞌ yoeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Naꞌ bllia akeꞌ yichjeꞌn to lo yeꞌnn nllirje, naꞌ beꞌe akeꞌn bi noꞌr weꞌon, naꞌ jayeꞌbeꞌn xhnaꞌbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Naꞌll beꞌnn kaꞌ non Juan naꞌ txhen jaxhiꞌi akeꞌ kwerp keꞌen, naꞌ jakwaꞌch akeꞌn. Naꞌtelle jayakeꞌ ganꞌ zo Jesúsenꞌ jayell akeꞌ Leꞌe kanꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ka bene Jesúsenꞌ kanꞌ gok ke da Juan naꞌ, naꞌll le bazaꞌteꞌ, bayoeꞌ to lo barco zayejeꞌ to latj dach ga nollno lljannao Leꞌe. Bixha beꞌnn kaꞌ zjallaꞌa yell kaꞌ zjalliꞌ lloaꞌ nisdaꞌon, ka bnnez akreꞌ kaꞌ, naꞌll bzaꞌa akeꞌ rall akeꞌn zjak kon niaꞌ akeꞌ jatil akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ka ballín Jesúsenꞌ lloaꞌ nisdaꞌon, breꞌreꞌ llaꞌa beꞌnn zan, naꞌll bayaꞌchraꞌlleꞌ leakeꞌ. Naꞌ bayoneꞌ beꞌnn weꞌe ke akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Naꞌll ka ba llen will, jak beꞌnn kaꞌ non Leꞌe txhen raweꞌn, lle akeꞌ leꞌe: —Zello to latj ga bibi de, naꞌ ba nak ba wlleꞌ. Baseꞌlchaz beꞌnn ki nench lljayakeꞌ yell daꞌo kaꞌ lliꞌ awlloze lljadirj akeꞌ da yeꞌj gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bi llayaꞌl lljayakeꞌ kaꞌze, reꞌ leweꞌe akeꞌ da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naꞌll lle akeꞌ Leꞌe: —Gaꞌyze yet xtir kellonꞌ de, naꞌ ye chop belyaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naꞌll lleꞌe leakeꞌ: —Lelljaxiꞌn ganni. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naꞌ le gollteꞌ beꞌnn kaꞌ blleꞌ akeꞌ rao yiꞌxenꞌ. Le bxhiꞌteꞌ yet xtir gaꞌy kaꞌ ren belyaꞌ kaꞌ ye chope, naꞌ le bwiateꞌ leꞌ yebáre beꞌe yel llioxken ke Dios, naꞌll bxhoxhjen beꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ, nench bdislas akeꞌn bdao beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yeololeꞌ bdao berj aktereꞌ. Bayoll naꞌ batop akeꞌ danꞌ bagaꞌnnen, naꞌ goken ye chllinn llom da kaꞌ bagaꞌnnen da goxhj kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Naꞌ beꞌnn kaꞌ bdaonꞌ nak akeꞌ ka do gaꞌy mir beꞌnne byio, llakze kere noꞌr kaꞌ ren bidaꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bayoll naꞌ, le gollteꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, wllaꞌa akeꞌ lo barconꞌ nench kwiarao akeꞌ wlaꞌy akeꞌ ye chlaꞌre nisdaꞌon, chak bagaꞌnn Leꞌen, baseꞌleꞌ beꞌnn zan kaꞌ zjayakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bayoll baseꞌleꞌ beꞌnn kaꞌ, bayepeꞌ to rao yaꞌ ga balwilleꞌ Diosenꞌ to wraze, naꞌ ka golenꞌ, tozeꞌ zeꞌe rao yaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naꞌ barconꞌ danꞌ zjallaꞌa beꞌnn kaꞌ bseꞌlen, ba zjazén ka do kllol nisdaꞌon, le zebraz ll-lliꞌy nisenꞌ len, llas lljataꞌ nisdaꞌon, ka naken dá beꞌn zban. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Naꞌ ka do bal-llen bayetj Jesúsenꞌ yaꞌn, naꞌll zejeꞌ ganꞌ zjak beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ zejeꞌ kon nieꞌ to rao nisdaꞌoze. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Naꞌ ka breꞌe akreꞌ Leꞌen, le blleb akeꞌ, besiaꞌ akeꞌ ka zejeꞌ rao nisdaꞌon. Naꞌll ne akeꞌ: —¡Da yaꞌjenꞌ llreꞌllo! ");
INSERT INTO zpuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Naꞌll le balwillte Jesúsenꞌ leakeꞌ, bneꞌe: —¡Leyewé, nadaꞌn, bi llebre! ");
INSERT INTO zpuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Naꞌll le gollte Pedronꞌ Leꞌe: —Xantoꞌ, chaꞌ rennroꞌ rweꞌn, bne yedaꞌ ganꞌ zeꞌo rao nisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Naꞌll lle Jesúsenꞌ leꞌe: —Da chaꞌ. Naꞌ le bllojte Pedronꞌ lo barconꞌ zejzeꞌ ganꞌ ze Jesúsenꞌ rao nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bixha ka breꞌreꞌ dá beꞌn res, naꞌ bllebeꞌ naꞌ bzorao llazeꞌ lo nisenꞌ. Naꞌll besieꞌ lleꞌe Jesúsenꞌ: —¡Xanaꞌ, basrá nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Naꞌ le bzete taꞌk Jesúsenꞌ bayoꞌxeꞌ leꞌe, naꞌll lleꞌe leꞌe: —¿Bixchen bi benliraꞌlloꞌ, naꞌ gokganroꞌ nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Naꞌ kate bayoꞌ Jesúsenꞌ ren Pedronꞌ lo barconꞌ, le blleꞌllite beꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Beꞌnn kaꞌ zjallaꞌa lo barconꞌ bcheꞌk xhib akeꞌ rao Jesúsenꞌ ben akeꞌ Leꞌe xhen, ne akeꞌ: —Dogarjkze Xhiꞌnn Dios rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bayoll naꞌ blaꞌy akeꞌ nisdaꞌon, naꞌll bllin akeꞌ ganꞌ nziꞌi Genesaret. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kate bayombiaꞌ beꞌnn Genesaret kaꞌ Jesúsenꞌ, bdislas akeꞌ diꞌllenꞌ yeolol yell daꞌo kaꞌ zjalliꞌ awlloze nench bnnez akereꞌ ba bllin Jesúsenꞌ rall akeꞌn. Naꞌ beꞌnn kaꞌ llaꞌa yell kaꞌ, bcheꞌe akeꞌ yeolol beꞌnn weꞌe kaꞌ raweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Naꞌ goꞌtyoe akreꞌ Leꞌe weꞌe latj goꞌx akeꞌ la raꞌtze xhnieꞌ xheꞌen, naꞌ yeolol beꞌnn kaꞌ beꞌx len le bayak akteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bal beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ bzaꞌa akeꞌ Jerusalén naꞌ, bllin akeꞌ ganꞌ zo Jesúsenꞌ, llnnab akreꞌ Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Bixchen bi llon beꞌnn kaꞌ non rweꞌ txhen kanꞌ ben xozxtaꞌollo kaꞌ, bi llnaꞌa akeꞌ weltze toto kweꞌ akeꞌ gao akeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Naꞌll lle Jesúsenꞌ leakeꞌ: —Leskaꞌ reꞌ, ¿bixchen bi ngoꞌ yichjre gonre kanꞌ ne Diosenꞌ llayaꞌl gonllo, naꞌ llonre xhen ka danꞌ ben beꞌnn gor kaꞌ ba bde? ");
INSERT INTO zpuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosenꞌ ba bneꞌe kanꞌ gonllonꞌ, danꞌ bneꞌe: “Legap baraꞌnn xaxhnaꞌre”, naꞌ “Noteze beꞌnne chaꞌ yellieꞌ diꞌll xaxhneꞌe llayaꞌl gateꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Naꞌ reꞌ llákere wak to beꞌnn yeꞌe xaxhneꞌe: “Bitbi de gonnaꞌ gakrenaꞌ rweꞌ, yeolol da de kiaꞌ ba biaꞌa Diosenꞌ len.” ");
INSERT INTO zpuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Naꞌll nere billbi llayaꞌl weꞌe xaxhneꞌen chaꞌ kaꞌ. Danꞌ nere kaꞌ, llbekre kaꞌle danꞌ ne Diosenꞌ, naꞌ naore llonre ka danꞌ ben beꞌnn gor kaꞌ ba bde kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Reꞌ beꞌnn chop rao ba llonyaꞌnnre kanꞌ bzoj da Isaíasenꞌ keré, ganꞌ nen: ");
INSERT INTO zpuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Beꞌnn ki llon akeꞌ nadaꞌ xhen kon lloaꞌ akeꞌ nazeꞌ, kere lloeꞌrao akeꞌ nadaꞌ do yichj do raꞌll akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bibi zaꞌk danꞌ lloeꞌrao akeꞌ nadaꞌn, ka nak llroeꞌ llsed akreꞌ da bayirjlaꞌll beꞌnnachzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Naꞌll goxheꞌ beꞌnn kaꞌ ndop gannaꞌ, naꞌ lleꞌe leakeꞌ: —Lewzenay danꞌ yepaꞌ reꞌ ni, naꞌ lechejnieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kere da lleꞌj llao beꞌnnachenꞌ llonen leꞌe gakeꞌ beꞌnn wen da xhinnj rao Diosenꞌ. Diꞌll danꞌ ll-lloj lloeꞌ naꞌ, len naꞌ llon leꞌe bi gakeꞌ yall rao Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Naꞌll jabiꞌy beꞌnn kaꞌ awllo, beꞌnn kaꞌ non Leꞌe txhen naꞌ, lle akeꞌ Leꞌe: —¿Zakbeꞌroꞌ gokllaꞌa beꞌnn fariseo kaꞌ, kanꞌ ben akreꞌ xtiꞌlloꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naꞌll lle Jesúsenꞌ leakeꞌ: —Wllin lla kate Xaꞌ beꞌnnenꞌ llia yebá naꞌ, goneꞌ ka llon to beꞌnn kat ll-laꞌlleꞌ no yay da bi gozeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Waljechaze beꞌnn fariseo kaꞌ, le ka to beꞌnn lcholenꞌ nak akeꞌ, le to beꞌnn lchol kere wak koꞌreneꞌ nez ye to lwellj lchole, wa lljabix akeꞌ do lo broj chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Naꞌll lle Pedronꞌ Leꞌe: —Bzejnieꞌcheke netoꞌ akxha zejen kanꞌ bneꞌo naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naꞌll lleꞌe leakeꞌ: —¿Rente reꞌ bi nna chejnieꞌre ka da ki ba bniaꞌ ni? ");
INSERT INTO zpuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Bi llejnieꞌre yeolol danꞌ lleꞌj llao beꞌnnache lloꞌn lo leꞌe, naꞌ ll-llin lla lladen? ");
INSERT INTO zpuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Zan yeolol diꞌll da lloeꞌ beꞌnnach, lo raꞌlldaꞌweꞌn ll-llojen. Naꞌ chaꞌ naken no diꞌll zban, len naꞌ llonen nench raꞌlldaꞌweꞌn bi naken yall rao Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Le lo raꞌlldaꞌo akeꞌ naꞌn llarjlaꞌll akeꞌ llon akeꞌ da xhinnj, naꞌ llasoꞌte beꞌnne, naꞌ llzoa xto akeꞌ, naꞌ llzorén lwellj akeꞌ laꞌkze bi nchaynaꞌa akeꞌ, naꞌ llban akeꞌ, naꞌ llyirjlaꞌll akeꞌ xtiꞌll lwellj akeꞌ, naꞌ llasnné akeꞌ ke beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da kinꞌ ll-llonen nench bi gak beꞌnne yall rao Dios, kere danꞌ bi llnaꞌa akeꞌ kat gao akeꞌ naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bazaꞌa Jesúsenꞌ gannaꞌ, naꞌ bayejeꞌ do ganꞌ lliꞌ yell kaꞌ nziꞌi Tiro ren Sidón. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Naꞌ to noꞌr beꞌnn yellenꞌ nziꞌi Canaán beꞌnn bi nake beꞌnn Israel, bzeꞌe ralleꞌn, naꞌ bllineꞌ ganꞌ zo Jesúsenꞌ, naꞌ jatileꞌ Leꞌe, naꞌll besieꞌ lleꞌe Leꞌe: —¡Xanaꞌ, rweꞌ nakoꞌ xhiꞌnn dialla da rey David, bayaꞌchraꞌllchga nadaꞌ! To xhiꞌnnaꞌ noꞌrenꞌ yoꞌ daxiꞌo yichjraꞌlldaꞌobeꞌ, nnaꞌstek ll-llayraobeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Naꞌ Jesúsenꞌ bi beꞌlaꞌlleꞌ ke noꞌrenꞌ. Naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, zjakeꞌ awllo, goꞌtyoe akreꞌ Jesúsenꞌ lle akeꞌ Leꞌe: —Balliꞌi noꞌrenꞌ, le llakia lloneꞌ naweꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Naꞌll lleꞌe leakeꞌ: —Diosenꞌ bseꞌleꞌ nadaꞌ nench llakrenaꞌ beꞌnn Israel kaꞌ, le leakeꞌn nak akeꞌ ka xhiꞌr daꞌo ba llakllejlaꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naꞌll zej noꞌrenꞌ jacheꞌk xhibeꞌ rao Jesúsenꞌ, naꞌ lleꞌe Leꞌe: —¡Xanaꞌ, gokrenchga nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Naꞌll lle Jesúsenꞌ leꞌe: —Bi naken wen yekaꞌrizllo yel wao ke xhiꞌnnllo kaꞌ, naꞌ weꞌrizllo beꞌkw gaobaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Naꞌll lle noꞌrenꞌ Leꞌe: —Laꞌkze naken kaꞌ, Xanaꞌ, beꞌkw kaꞌ wak yetopbaꞌ blaꞌa daꞌo kaꞌ, llexj xhan ganꞌ llbeꞌ xanbaꞌ llaweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Naꞌll bayechj Jesúsenꞌ lleꞌe leꞌe: —¡Da xhen gore nxenraꞌlloꞌ, noꞌre! Gakchga kanꞌ lleꞌnroꞌn. Naꞌll le bayakte xhiꞌnn noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bazaꞌa Jesúsenꞌ gannaꞌ, naꞌ byejeꞌ nez danꞌ llde awlloze lloaꞌ nisdaꞌo Galilea naꞌ, naꞌll byepeꞌ to rao yaꞌ jachieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Naꞌ beꞌnn zan bllin rao yaꞌn ganꞌ lliꞌ Jesúsenꞌ, ncheꞌe akeꞌ no beꞌnn nxhinnje, beꞌnn bi llak saꞌa, beꞌnn lchole ake, naꞌ beꞌnn blloj ake, naꞌ beꞌnn bi zo niaꞌnaꞌa, naꞌ ren beꞌnn llak wde wdere yillweꞌ, naꞌ bniꞌt akeꞌ leakeꞌ xhniaꞌ Jesúsenꞌ, naꞌll bayoneꞌ yeololteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Naꞌll babane beꞌnn kaꞌ kwis ka breꞌe akreꞌ banné beꞌnn blloj kaꞌ, naꞌ bayak beꞌnn kaꞌ bi zjazó niaꞌnaꞌa, naꞌ badá beꞌnn xhinnj kaꞌ, naꞌ bareꞌe beꞌnn lchol kaꞌ. Naꞌll bzorao lloeꞌxhen akeꞌ Dios ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesúsenꞌ le goxhteꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, lleꞌe leakeꞌ: —Wa llayaꞌchraꞌllaꞌ beꞌnn ki, le ba gok chonn lla llaꞌrén akeꞌ nadaꞌ ganni, naꞌ bibi de da gao akeꞌ. Naꞌ bi lleꞌnraꞌ yesán akeꞌ kaꞌze, le kere ba bdao akeꞌn, nench ke chaz akeꞌ da xchol do tnez. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naꞌll lle akeꞌ Leꞌe: —Ganꞌ zollo ni naken to latj dach, ga bibi dekze chras. ¿Ga llélello da gao yeolol beꞌnn ki? ");
INSERT INTO zpuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Balxha yet xtir de keré? Naꞌll lle akeꞌ Leꞌe: —Gallze yet xtir daꞌo de, naꞌ ye to chop belyaꞌ daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naꞌll golleꞌ beꞌnn zan kaꞌ kweꞌ akeꞌ rao yonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naꞌll beꞌxeꞌ gall yet xtir kaꞌ, naꞌ ren belyaꞌ daꞌo kaꞌ, naꞌll beꞌe yel llioxken ke Dios, naꞌll bxhoxhjeꞌn beꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ bdislas akeꞌn rao yeolol beꞌnn kaꞌ llaꞌa naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yeolol akteꞌ bdao berj aktereꞌ. Bayoll naꞌ batop akeꞌ da kaꞌ bagaꞌnne, naꞌ bayaken ye gall llom. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Naꞌ beꞌnn kaꞌ bdaonꞌ nak akeꞌ ka do tap mir beꞌnn byio, llakze kere noꞌr kaꞌ ren bidaꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Naꞌ bayoll naꞌ, baseꞌleꞌ beꞌnn zan kaꞌ zjayak akeꞌ, naꞌ le bayoꞌteꞌ to lo barco, naꞌ zayejeꞌ yell kaꞌ ganꞌ nbane Magdala. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Le jabiꞌyte bal beꞌnn fariseo kaꞌ, naꞌ ren beꞌnn saduceo kaꞌ ganꞌ ze Jesúsenꞌ, gokraꞌll akeꞌ kwej akeꞌ Leꞌe diꞌll, nench naꞌ gaꞌt da wakw akeꞌ Leꞌe xhia chole. Naꞌ bnnab akeꞌ goneꞌ to yel wak da reꞌe akreꞌ da zaꞌa yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Naꞌll lle Jesúsenꞌ leakeꞌ: —Kat llwiare leꞌ yebánꞌ do ba wlleꞌ, naꞌll nere: “Wallaꞌa wxe, le ba llaxhná leꞌ yebánꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Naꞌ kate llreꞌre llazé bej xhna leꞌ yebánꞌ kat lleniꞌ, naꞌll nere: “Wak yejw zay, le ba ze bej xhna leꞌ yebánꞌ.” Beꞌnn chop rao ake, reꞌ nnézkzere chaꞌ wak yejw zay, naꞌ chaꞌ wak zeꞌye katenꞌ llreꞌre akre nak leꞌ yebánꞌ, naꞌ bi llayakbeꞌre bi zejen da kaꞌ llon Diosenꞌ ka llanꞌ ba zollo nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Reꞌ yoꞌ da xhinnj lo raꞌlldaꞌore, naꞌ ba bsanraꞌllre Diosenꞌ. Naꞌ llnnabre gonaꞌ ye to yel wak da reꞌtere, zan bi gonaꞌ ka danꞌ llnnabrenꞌ, zeraoze ka danꞌ broeꞌ Diosenꞌ reꞌ, ka danꞌ benreneꞌ da Jonás, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. Naꞌll bayoll bneꞌe kaꞌ, bazeꞌe ganꞌ ze akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naꞌll ka ballín akeꞌ ye chlaꞌre nisdaꞌo Galileanꞌ, beꞌnn kaꞌ non Leꞌe txhen naꞌ, bi jadinraꞌll akeꞌ yeyoꞌx akeꞌ yet xtir da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Naꞌll lle Jesúsenꞌ leakeꞌ: —Lewiayaꞌnn ke kwa binn ke beꞌnn fariseo kaꞌ, naꞌ ke beꞌnn saduceo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Naꞌll lle lwellj akeꞌ: —Danꞌ bibi yet xtir noꞌxllo naꞌn, naꞌllenꞌ neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesúsenꞌ gokbeꞌreꞌ ka diꞌllenꞌ lloeꞌrén lwellj akeꞌn, naꞌll lleꞌe leakeꞌ: —¿Bixchen llakrizere danꞌ bi noꞌxre yet xtir naꞌ? ¿Bi llonliraꞌllre nadaꞌ napaꞌ yel wak wawaꞌ reꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Bi nna chejnieꞌren? ¿Bi lljadinraꞌllre kanꞌ bwawaꞌ gaꞌy mir beꞌnne kone gaꞌyze yet xtir daꞌo? Naꞌ lekze, ¿bi zaꞌraꞌllre ye bale llomenꞌ bagaꞌnn danꞌ batoprenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Leskaꞌ ¿bi zaraꞌllre bwawaꞌ ye tap mir beꞌnne, kone gallze yet xtir daꞌo? ¿Zaꞌraꞌllre ye bale llom da goxhj batopre da bagaꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bixchen llákere danꞌ bi noꞌxre yet xtir naꞌn, llepaꞌ reꞌ kaꞌ, lewiayaꞌnn kanꞌ nak kwa binn ke beꞌnn fariseo kaꞌ, naꞌ ke beꞌnn saduceo kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naꞌll bayakbeꞌe akreꞌ, kere beꞌe diꞌll ke kwa danꞌ llonrén akeꞌ llin danꞌ llaslliꞌo yet xtir naꞌ, beꞌe diꞌllenꞌ kaꞌ, nench ke gakchixe lo yichjraꞌlldaꞌo akeꞌn ka nak danꞌ llroeꞌ llsed beꞌnn fariseo kaꞌ ren beꞌnn saduceo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ka bllin Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen, ganꞌ nziꞌi Cesarea de Filipo, naꞌll golleꞌ leakeꞌ: —¿Bixha llasné beꞌnn kaꞌ noxha nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Naꞌll lle akeꞌ Leꞌe: —Bal akeꞌ ne akeꞌ nakoꞌ da Juan beꞌnnenꞌ bchoa nis. Naꞌ ye baleꞌ ne akeꞌ da Elías rweꞌ, beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ. Naꞌ ye bal akeꞌ ne akeꞌ da Jeremíasenꞌ, naꞌ ye baleꞌ ne, kon to beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌtenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naꞌll lleꞌe leakeꞌ: —¿Bixha reꞌ? ¿No nere nakaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Naꞌll Simón Pedronꞌ lleꞌe Leꞌe: —Rweꞌn nakoꞌ Cristo beꞌnnenꞌ brej Diosenꞌ nnebieꞌ, naꞌ nakoꞌ dogarje Xhiꞌnn Dios beꞌnn zo ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Naꞌll lle Jesúsenꞌ leꞌe: —Simón, xhiꞌnn Jonás, nbaraz koꞌo rweꞌ danꞌ bneꞌo kaꞌ, notno beꞌnnach bzejnieꞌ rweꞌ kanꞌ bneꞌon. Toze Xaꞌ beꞌnnenꞌ llia yebá, Leꞌen bzejnieꞌreꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Naꞌ nadaꞌ niaꞌ, rweꞌn reꞌo Pedro, naꞌ raꞌo naꞌ, lleꞌnen nen to yej war. Ka to beꞌnn llon yoꞌ llbieꞌ da nak yej war, nench gonreneꞌn llin kat kwekeꞌ ran yoꞌ keꞌen, kaꞌkzenꞌ llbejaꞌ rweꞌ gonoꞌ xchinaꞌ, gakoꞌ beꞌnn lliarao lljatopoꞌ beꞌnn gon akeꞌ nadaꞌ txhen. Ni ke bi deze gon yel wak ke yel gotenꞌ, nench gonen leakeꞌ gan. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Naꞌ gonaꞌ rallnaꞌo yel llnebiaꞌ danꞌ zaꞌa yebá. Yeololte da wchejoꞌ rao yellrionꞌ, llejten yebá, naꞌ yeololte da yeselloꞌ rao yellrionꞌ, wayellten yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naꞌll lleꞌe leakeꞌ nono ye akeꞌ chaꞌ Leꞌen nakeꞌ Cristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kanaꞌ bzorao Jesúsenꞌ bzejnieꞌreꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, llayaꞌl chejeꞌ Jerusalén naꞌ. Naꞌ neꞌe beꞌnn gor brao kaꞌ, naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ wsaꞌkziꞌ akeꞌ Leꞌe, naꞌ yesoꞌte Leꞌe, naꞌ yeyónn lla naꞌ, yebaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naꞌll bcheꞌe Pedronꞌ Leꞌe ga yobre to wraze, naꞌll bzorao lloeꞌreneꞌ Leꞌe diꞌll, bdileꞌ Leꞌe, lleꞌe Leꞌe: —Xanaꞌ, Dios gakreneꞌ rweꞌ bi gak koꞌo ka diꞌllenꞌ lloeꞌo ganni. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naꞌ Jesúsenꞌ bayechjeꞌ bwieꞌ Pedronꞌ, naꞌll lleꞌe leꞌe: —¡Kwas kaꞌle, daxiꞌo! Llkoꞌyelroꞌ nadaꞌ nench bi gonaꞌ kanꞌ nllia Diosenꞌ biaꞌa gonaꞌn, kere xhbab ke Diosenꞌ nsaꞌo, xhbab ke beꞌnnachenꞌ nsaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Naꞌll lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Noteze beꞌnn chaꞌ lleꞌnreꞌ gakeꞌ nadaꞌ txhen, llayaꞌl wsanraꞌll kwineꞌ, naꞌ goneꞌ ka to beꞌnn noaꞌ cruz keꞌe, naꞌ nnaweꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Noteze beꞌnn lleꞌnreꞌ yesrá yel nban ke kwineꞌ yellrio ni, wniteꞌn, naꞌ noteze wnit yel nban keꞌen ni kiaꞌ nadaꞌ, leꞌen gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Bixha zaꞌken naꞌ, chaꞌ to beꞌnne goneꞌ gan doxhente da de rao yellrio, naꞌ kweyieꞌ, bi gaꞌt yel nban zejlikane keꞌe? ¿Bi kone gaꞌweꞌ yel nban naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach kat yedaꞌ da yobre yellrio ni nsaꞌa yel zaꞌk xhen ke Xaꞌ Diosenꞌ, naꞌ wchiaꞌ angl kiaꞌ kaꞌ, kanaꞌ gonaꞌ ke toto beꞌnnach so akeꞌ nbaraz o chaꞌ wsaꞌkziꞌ akeꞌ, kon da ben totoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Da li niaꞌ reꞌ, balre llaꞌre ganni bi nna gatre, kat llin lla reꞌre nadaꞌ yedrenaꞌ yel llnebiaꞌ kiaꞌn, nadaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bde gok xop lla bcheꞌe Jesúsenꞌ Pedronꞌ ren Jacobo, naꞌ ren Juan, biꞌch Jacobo naꞌ, naꞌ zre akzeꞌ jakeꞌ to rao yaꞌ sibe. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Naꞌ llwia akteꞌ kat bllaꞌa yichjrao Jesúsenꞌ, gok llaktit kwis lloaꞌraweꞌn kanꞌ nak will naꞌ, naꞌ xharaꞌneꞌn goken llich kwis, goken ka beniꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Rawe naꞌ breꞌe akreꞌ da Moisés ren da Elías lloeꞌrén akeꞌ Jesúsenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naꞌll lle Pedronꞌ Jesúsenꞌ: —Xantoꞌ, le wen zollo ganni. Chaꞌ lleꞌnroꞌ, naꞌ gontoꞌ chonn yoꞌ, to koꞌo, naꞌ to ke Moisés, naꞌ ye to ke Elías naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nna lloeꞌte Pedronꞌ diꞌll kaꞌ, kat byechjze to bej llaktit leakeꞌ, naꞌ lo bej naꞌ ben akreꞌ bne Diosenꞌ: “Beꞌnn ninꞌ nak xhiꞌnnaꞌ nllieꞌraꞌ llayazraꞌllaꞌ, llaweraꞌ kwis keꞌe. Ke Leꞌen wzenayre.” ");
INSERT INTO zpuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ka bene beꞌnn kaꞌ ncheꞌe Jesúsenꞌ kaꞌ, to blleb akzeꞌ, naꞌ byal akeꞌ slloaꞌre rao yonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Naꞌll jabiꞌy Jesúsenꞌ jaxoa neꞌen yichj akeꞌ, naꞌ lleꞌe leakeꞌ: —Lewayas. Bi llebre. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naꞌ ka balis yichj akeꞌn, nollno llraꞌ ye toze Jesúsenꞌ zeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bayoll naꞌ, ka llayetj akeꞌ leꞌ yaꞌ naꞌ, lle Jesúsenꞌ leakeꞌ: —Ka nak danꞌ breꞌre ni, bi weꞌre diꞌll kaꞌ. Kat nadaꞌ Beꞌnn Gorj Radj Beꞌnnach yebanaꞌ radj beꞌnn wat kaꞌ, kanaꞌll wak weꞌre diꞌll kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Naꞌll beꞌnn kaꞌ non Leꞌe txhen naꞌ, lle akeꞌ Leꞌe: —¿Bixchen beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, lle akeꞌ netoꞌ zgaꞌtek da Elías beꞌnn bzo kanaꞌn llayaꞌl yedeꞌ da yobre? ");
INSERT INTO zpuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Naꞌll lle Jesúsenꞌ leakeꞌ: —Da likzenꞌ zgaꞌtek da Elías naꞌn yedeꞌ, naꞌll yeyonchaꞌweꞌ yeololte. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Zan ni llepaꞌ reꞌ, ba bedkze Elíasenꞌ, naꞌ nono bayombiaꞌ chaꞌ leꞌen, naꞌ ben akreꞌ leꞌe ka lleꞌn akreꞌ; naꞌ kaꞌkzenꞌ wsaꞌkziꞌ akeꞌ nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naꞌll gokbeꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ, lloeꞌ diꞌll ke da Juan beꞌnnenꞌ bchoa beꞌnne nis. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Naꞌ ka bllin akeꞌ ganꞌ llaꞌa beꞌnn zan kwis, to beꞌnn jatileꞌ Jesúsenꞌ, jacheꞌk xhibeꞌ raweꞌn, naꞌ lleꞌe Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Xantoꞌ, bayaꞌchraꞌllchga xhiꞌnnaꞌ ni, le llazbeꞌ xhgot, naꞌ llallayraobeꞌ, naꞌ da zan ras ba byalbeꞌ do lo yiꞌ leskaꞌ lo nis. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naꞌ ba badwaꞌbeꞌ rao beꞌnn koꞌo kaꞌ non rweꞌ txhen naꞌ, naꞌ bi gok akeꞌ yeyón akebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Naꞌll lle Jesúsenꞌ leakeꞌ: —¡Reꞌ, beꞌnn bi llonliraꞌlle, naꞌ llonre ka nen keré! ¿Ye art serenaꞌ reꞌ? Lla ledá waꞌa bidaꞌon ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naꞌll Jesúsenꞌ bdileꞌ daxiꞌon, naꞌ ballojen lo yichjraꞌlldaꞌo bidaꞌon. Naꞌll le bayaktebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bayoll gok kaꞌ, naꞌll jak beꞌnn kaꞌ non Leꞌe txhen naꞌ awllo, goll akeꞌ Leꞌe: —¿Bixchen bi goktoꞌ yebejtoꞌ daxiꞌon? ");
INSERT INTO zpuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bi gokre yebejren le bi byejleꞌre ke Diosenꞌ wak goneꞌ yellojen. Da li niaꞌ reꞌ, chenak danꞌ llejleꞌrenꞌ naken ka to nak nbaz ke mostaz, naꞌ yere yaꞌ ni: “Bakwas ganni, naꞌ jazó gannaꞌte”, naꞌll gakte kanꞌ nerenꞌ. Gaga de da bi gak gonre kon chaꞌ llejleꞌre ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nench saꞌke yebejre daxiꞌo kaꞌ, ka da kaꞌ babejaꞌ yichjraꞌlldaꞌo bidaꞌon, llayaꞌl gonre was, naꞌ yelwilltezre Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Naꞌll ka zayej Jesúsenꞌ Galilea naꞌ, ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, golleꞌ leakeꞌ: —Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, dekz de gakaꞌ rallnaꞌa beꞌnne kaꞌ llwie nadaꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","got akeꞌ nadaꞌ, naꞌ yeyoll got akeꞌ nadaꞌ naꞌ yeyónn lla yebanaꞌ radj beꞌnn wat kaꞌ. Naꞌ gokyaꞌche beꞌnn keꞌe kaꞌ, ka ben akreꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ka ballín akeꞌ Capernaum naꞌ, jak beꞌnn kaꞌ llchixhj ke gaxt ke yodaꞌo braonꞌ rao Pedronꞌ, naꞌ goll akeꞌ leꞌe: —¿Bi yixhj maestro kerénꞌ da llayaꞌl chixhjeꞌ ke yodaꞌo brao ni? ");
INSERT INTO zpuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naꞌll lle Pedronꞌ leakeꞌ: —Llyixhjkzeꞌn. Naꞌll Pedronꞌ kanꞌ byoeꞌ lo yoꞌn, le gollte Jesúsenꞌ leꞌe: —¿Akre llakroꞌ Simón? Ka nak beꞌnn wnebiaꞌ kaꞌ zjallaꞌa yellrio ni, ¿noxhanꞌ llakroꞌ llchixhj akeꞌ? ¿Beꞌnn wrall ke akeꞌn o chaꞌ beꞌnn ziꞌtenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Naꞌll lle Pedronꞌ Leꞌe: —Beꞌnn ziꞌtenꞌ llchixhj akeꞌ. Naꞌll lle Jesúsenꞌ leꞌe: —Naꞌ lliꞌo naktello beꞌnn wrall ke akeꞌ bi llayaꞌl chixhjllo ke yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Zan nench nono bi nne kello, byej lloaꞌ nisdaꞌon, naꞌ bzaꞌl yixj koꞌon, naꞌ bel nellenꞌ senoꞌ naꞌ, lo lloaꞌbaꞌ naꞌ llelroꞌ to mell. Naꞌ yeyoꞌxoꞌn, naꞌ lljatixhjoꞌ ke lloptello. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naꞌll jak beꞌnn kaꞌ non Jesúsenꞌ txhen jabiꞌy akeꞌ kwiteꞌn, lle akeꞌ Leꞌe: —¿Nore netoꞌ gaklltoꞌ beꞌnn brao kat gon Dios beꞌnnenꞌ llia yebánꞌ nnebiaꞌo? ");
INSERT INTO zpuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naꞌll goxh Jesúsenꞌ to bidaꞌo, naꞌ bzeꞌebeꞌ kllol akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Naꞌll lleꞌe leakeꞌ: —Da li niaꞌ reꞌ, notezre chaꞌ bi wchaꞌa yichjraꞌlldaꞌore, naꞌ wayakre ka to bidaꞌo, kbat gakre Diosenꞌ txhen beꞌnnenꞌ llnebiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Noteze beꞌnne chaꞌ yeyakeꞌ ka bidaꞌo ni, naꞌ waxhexjraꞌlleꞌ rao Diosenꞌ, naꞌllenꞌ gakeꞌ beꞌnn brao ke Diosenꞌ beꞌnnenꞌ llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Naꞌ noteze beꞌnne gonreꞌ bidaꞌo ak wen ka bidaꞌo ni, danꞌ llonliraꞌllbeꞌ nadaꞌ, nadkzaꞌn llonreꞌ wen. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Noteze beꞌnne goneꞌ bix to bidaꞌo ki nxenraꞌll nadaꞌ gonbeꞌ da xhinnj, nakteren wen naꞌ, wchej akeꞌ yeneꞌ to yej yiche, naꞌ wzaꞌl akeꞌ leꞌe lo nisdaꞌo, kerke da goneꞌ nench gon to bidaꞌo ki da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nyaꞌchraz naken ke beꞌnnach danꞌ de da zan yellrio ni, da llkoꞌyelen beꞌnnachenꞌ gon akeꞌ da xhinnj, zan nyaꞌchraz ke beꞌnn llkoꞌyeleꞌ beꞌnne nench goneꞌ da xhinnje. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ke len naꞌ, chaꞌ niaꞌnaꞌrenꞌ llxhoben reꞌ, gonre da xhinnj, wenre chenak wchoyren, kerke da gonre da xhinnjenꞌ. Wenre yellinre ganꞌ de yel nban naꞌ, yallje chlaꞌ taꞌkre, naꞌ nlloy chlaꞌ niaꞌre, kerke da yeyejre lo yiꞌ gabilenꞌ nyaꞌtezre. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naꞌ chaꞌ yejraorenꞌ llxhoben reꞌ, gonre da xhinnj, wenre chenak kwejre raorenꞌ kerke da gonre da xhinnjenꞌ. Wenre yellinre ganꞌ de yel nban naꞌ, yallje chlaꞌ yejraorenꞌ, kerke yeyejre lo yiꞌ gabilenꞌ zo chop laꞌte yejraorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Lewiachga bi gónere bidaꞌo ki nxenraꞌll nadaꞌ kaze. Ni niaꞌ reꞌ, angl kaꞌ llap aksebeꞌ, naꞌ niꞌt akseꞌ llwia akeꞌ rao Xaꞌ Diosenꞌ llia yebánꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Le nadaꞌ Beꞌnn Gorj Radj Beꞌnnach, zaꞌa nench wasraꞌa beꞌnn kaꞌ ba nbeyiꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Akxha gákere? Chaꞌ zo to beꞌnn nape to gayoa (100) xhiꞌr daꞌo, naꞌ chaꞌ nnit tobaꞌ, ¿bi wkwaꞌnneꞌ ba tapralj twalj kaꞌ (99), naꞌ lljadirjeꞌ badaꞌon bnit do radj yaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Da li niaꞌ re, kat yellélerebaꞌn, yewereꞌ kwis ba ballelebaꞌ, kerke ba tapralj twalj kaꞌ, nna niꞌt naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kaꞌkzenꞌ naken ke bidaꞌo ki. Xallo Dios beꞌnnenꞌ llia yebá naꞌ, bi lleꞌnreꞌ kweyiꞌ ni tobeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Chaꞌ to beꞌnn lwelljre goneꞌ to da xhinnj keré, lechej lelljeꞌreneꞌ diꞌll llopzre. Naꞌ chaꞌ wayakbeꞌreꞌ da xhinnjenꞌ beneꞌ, naꞌ wzenayeꞌ keré, ba bayonoꞌ beꞌnn biꞌchoꞌn gan naꞌ, chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Naꞌ chaꞌ bi llejleꞌ diꞌllenꞌ lljeꞌrenreꞌn, wenre lewcheꞌe ye to chop beꞌnn lwelljre nench naꞌ reꞌe akreꞌ ba goꞌtyoere beꞌnnenꞌ yechaꞌa yel kanꞌ llon keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Naꞌ chaꞌ bi wzenaykzeꞌ keré, naꞌ leweꞌe diꞌll kanꞌ lloneꞌn rao yeololre kanꞌ nakre lldop ll-llayre lloeꞌraore Diosenꞌ. Naꞌ chaꞌ bi wzenaykzeꞌ ke yeololre, bill gonreꞌ txhen. Wenre legoneꞌ ka to beꞌnn bi nxenraꞌll Dios, ka no beꞌnn wachixhje beꞌnn llon da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Da li niaꞌ reꞌ, yeololte da wchejre rao yellrio, wllejten yebá, naꞌ yeololte da yesellre rao yellrionꞌ, wayellten yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Naꞌ da yobre niaꞌ reꞌ, chaꞌ ntil chopre rao yellrio ni, naꞌ gonre toze diꞌll bi danꞌ nnábere Diosenꞌ, Xaꞌ Dios beꞌnnenꞌ zo yebánꞌ gonnkzeꞌ danꞌ nnáberenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Le ganꞌ nllay chop chonnre llonre nadaꞌ xhen, gannaꞌ zorenkzaꞌ reꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Naꞌll jabiꞌy Pedronꞌ lleꞌe Jesúsenꞌ: —Xantoꞌ, bixha chaꞌ to beꞌnn lwelljaꞌ bi da goneꞌ kiaꞌ da wlleyiꞌ nadaꞌ, ¿bale ras llayaꞌl yeziꞌxhenaꞌ keꞌe? ¿Zerao gall ras? ");
INSERT INTO zpuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Naꞌll lle Jesúsenꞌ leꞌe: —Kere niaꞌ zerao gall ras yeziꞌxhen ke lwelljrenꞌ, ni niaꞌ reꞌ wyon chi (70) ras de gall ras wejenꞌ, yeziꞌxhenreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Yel llnebiaꞌ ke Dios beꞌnnenꞌ llia yebánꞌ zaꞌkreben ka ben to beꞌnn wnebiaꞌ, naꞌ llbaꞌy beꞌnn wen llin keꞌe kaꞌ xhmelleꞌ, naꞌ gokraꞌlleꞌ weꞌreneꞌ leakeꞌ diꞌll arkenꞌ llbaꞌy akeꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ka bzorao llwieꞌ arkenꞌ llbaꞌy totoeꞌ, naꞌ bllin beꞌnn nell beꞌnnenꞌ nak beꞌnn wen llin keꞌen llbaꞌyeꞌ chi mir mell danꞌ nziꞌi talento, naꞌ naken mell xhen kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Naꞌ beꞌnn naꞌ bibi xhmelleꞌ de da yeyixhjeꞌn. Naꞌll beꞌnn wnebiaꞌn golleꞌ beꞌnn wen llin keꞌe kaꞌ lljeꞌt akeꞌ leꞌe ren xhoꞌreꞌ naꞌ, naꞌ ren xhiꞌnneꞌ kaꞌ, naꞌ ren yeolol da zjadé ke akeꞌ nench yeyaxhj danꞌ llbaꞌy akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Naꞌll bcheꞌk xhib beꞌnn wen llin keꞌen raweꞌ, goꞌtyoereꞌ leꞌe lleꞌe leꞌe: “Xanaꞌ, bdapchga yel llxhenraꞌll kiaꞌ, wayonnkzaꞌ doxhente danꞌ llbaꞌyaꞌ koꞌon.” ");
INSERT INTO zpuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naꞌll bayaꞌchraꞌll beꞌnn wnebiaꞌn leꞌe, baziꞌxheneꞌ danꞌ llbaꞌyeꞌ keꞌen, naꞌll bsaneꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bixha ka ballojeꞌ rill xaneꞌ naꞌ, le balláytereꞌ ye to beꞌnn lwelljeꞌ, beꞌnn llbaꞌy keꞌe raꞌte. Naꞌll le beꞌxteꞌ leꞌe, beꞌxeꞌ yeneꞌ, lleꞌe leꞌe: “Bayónn danꞌ llbaꞌyoꞌ kiaꞌn nnaꞌsteke.” ");
INSERT INTO zpuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Naꞌll beꞌnn lwelljeꞌn leskaꞌ le bcheꞌkte xhibeꞌ raweꞌ, lleꞌe leꞌe: “Bdapchga yel llxhenraꞌll kiaꞌ, wayonnkzaꞌ doxhen danꞌ llbaꞌyaꞌ koꞌon.” ");
INSERT INTO zpuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bixha leꞌen bi bxhiꞌxheneꞌ ke beꞌnn lwelljeꞌn, le gollteꞌ beꞌnn kaꞌ goꞌx akeꞌ leꞌe koꞌ akeꞌ leꞌe rill ya, naꞌ golleꞌ beꞌnn kaꞌ bi yebej akeꞌ leꞌe chaꞌ bi nna yeyixhjeꞌ keꞌen danꞌ llbaꞌyeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Naꞌll beꞌnn wen llin kaꞌ yelaꞌ, ka breꞌe akreꞌ kanꞌ benreꞌ beꞌnnenꞌ, naꞌ gok akreꞌ kwis. Naꞌll byej akeꞌ rao xan akeꞌn, jell akeꞌ leꞌe kanꞌ benreꞌ beꞌnn lwelljeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naꞌll goxh beꞌnn wnebiaꞌn leꞌe da yobre, naꞌll lleꞌe leꞌe: “¡Beꞌnn wen da xhinnj kwis nakkazoꞌ! Nadaꞌ baziꞌxhenaꞌ koꞌo doxhente danꞌ llbaꞌyoꞌ kiaꞌn, le goꞌtyoeroꞌ nadaꞌ yeziꞌxhenaꞌn koꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Bixchen bi bayaꞌchraꞌlloꞌ beꞌnn lwelljoꞌn llbaꞌy koꞌon kanꞌ benaꞌ nadaꞌ bayaꞌchraꞌllaꞌ rweꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naꞌll gokllaꞌa beꞌnn wnebiaꞌn kwis, naꞌll golleꞌ beꞌnn kaꞌ broꞌ akeꞌ leꞌe lo rill ya ga yellayraweꞌ, naꞌ bi yellojkzeꞌ chaꞌ bi nna wayixhjeꞌ doxhen danꞌ llbaꞌyeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Naꞌll goll Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Kanꞌ gon Xaꞌ beꞌnnenꞌ llia yebánꞌ keré, chaꞌ bi llaziꞌxhenre ke lwelljre do yichj do raꞌllre biteze da gon akreꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bayoll bne Jesúsenꞌ yeolol da ki, naꞌll bazeꞌe ganꞌ nbane Galileanꞌ, naꞌ balaꞌyeꞌ ye chlaꞌre yeo Jordán naꞌ, byejeꞌ ganꞌ nbane Judea. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Naꞌll beꞌnn zan zanao Leꞌe, naꞌ bayoneꞌ beꞌnn weꞌe ak. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Naꞌll bale beꞌnn fariseo kaꞌ jakeꞌ ganꞌ zoeꞌ naꞌ, gokraꞌll akeꞌ kwej akeꞌ Leꞌe diꞌll nench naꞌ gaꞌt da wakw akeꞌ Leꞌe xhia chole, naꞌll lle akeꞌ Leꞌe: —¿Wak yeraꞌa to beꞌnn ren noꞌr keꞌen, beꞌnn nchaynaꞌreneꞌ, chaꞌ bi llazraꞌlleꞌ kanꞌ llon noꞌr keꞌen? ");
INSERT INTO zpuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Naꞌll lleꞌe leakeꞌ: —¿Bi nna wrabre kanꞌ nyoj xtiꞌll Diosenꞌ? Llian kanꞌ bxhe yellrionꞌ, naꞌ ben Diosenꞌ beꞌnn nelle to beꞌnn byio naꞌ ye to noꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Naꞌll bneꞌe: “Beꞌnn byio naꞌ, wsanraꞌll xaxhneꞌe nench soreneꞌ noꞌr keꞌe naꞌ, naꞌ llop akeꞌ gak akeꞌ ka toze beꞌnne.” ");
INSERT INTO zpuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naꞌ kaꞌ bill nak akeꞌ chopeꞌ, ba nak akeꞌ toz beꞌnne. Ke len naꞌ beꞌnn ba bkoꞌd Dios bi gak yelaꞌa beꞌnnach leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Naꞌll goll akeꞌ Leꞌe: —Chaꞌ kaꞌ naken chaꞌ, ¿bixchen bne da Moisésenꞌ, kat to beꞌnne yeraꞌrén noꞌr keꞌen, llayaꞌl chas to yich da weꞌe noꞌr keꞌen nench weꞌn diꞌll ba baraꞌa akeꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Naꞌll lle Jesúsenꞌ leakeꞌ: —Benn da Moisésenꞌ latj yeraꞌrén noꞌr kerénꞌ, le llwieꞌ yel kanꞌ nak yichjraꞌlldaꞌo war keré naꞌn, naꞌllenꞌ bneꞌe kaꞌ. Le kanꞌ ben Diosenꞌ beꞌnn nell kaꞌ, bi nnello gokraꞌlleꞌ yeraꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naꞌ nadaꞌ llepaꞌ reꞌ, noteze beꞌnn llaraꞌreneꞌ noꞌr keꞌen, naꞌ chaꞌ bibi doꞌl de ke noꞌrenꞌ dareneꞌ beꞌnn yobre, naꞌ llchaynaꞌreneꞌ ye to noꞌr yobre, rebze lloneꞌ ka beꞌnn llzoa xto. Naꞌ noteze beꞌnn byio yechaynaꞌreneꞌ noꞌre beꞌnn bsanraꞌll beꞌnn keꞌen, rebze da xhinnjenꞌ llonkzeꞌ ka danꞌ llonkze beꞌnnenꞌ darén xhoꞌr beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naꞌll beꞌnn kaꞌ non Jesúsenꞌ txhen lle akeꞌ Leꞌe: —Chaꞌ kaꞌ naken ke beꞌnn byio ren noꞌr keꞌen, wenkre chenak bi wchaynaꞌa akseꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Naꞌll lleꞌe leakeꞌ: —Kere yeolol beꞌnne chejnieꞌ da ni, toze beꞌnn kaꞌ ba bzejnieꞌ Diosenꞌ bi zejen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Zjaniꞌt beꞌnn kaꞌ, ka llarj akteꞌ bi lleꞌn akreꞌ wchaynaꞌa akeꞌ. Naꞌ niꞌt ye bal beꞌnn llagaꞌnn kaꞌze, ni ke beꞌnn yobre. Leskaꞌ niꞌt ye bal beꞌnn bi llchaynaꞌa akeꞌ, lleꞌn akreꞌ gon akeꞌ xchin Diosenꞌ beꞌnnenꞌ zo yebá llnebieꞌ. Lewzenay ka danꞌ ba bniaꞌn chaꞌ Diosenꞌ ba beneꞌ chejnieꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naꞌll jwaꞌa akeꞌ bidaꞌo ak rao Jesúsenꞌ nench wxoa neꞌen yichj akbeꞌ, naꞌ nnabeꞌ rao Dios gakreneꞌ leakbeꞌ. Bixha beꞌnn kaꞌ non Leꞌe txhen naꞌ, bdil akeꞌ beꞌnn kaꞌ ncheꞌe bidaꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Naꞌll lle Jesúsenꞌ leakeꞌ: —Leweꞌe latj yed bidaꞌo kaꞌ rawaꞌ ni, bi wllonre, le beꞌnn kaꞌ nak ka bidaꞌo kinꞌ, leakeꞌn nak Diosenꞌ txhen beꞌnnenꞌ llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naꞌll bayoll bxoa neꞌen yichj bidaꞌo kaꞌ, benlaꞌye leakbeꞌ, naꞌll bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Naꞌ bllin to beꞌnn weꞌo ganꞌ zo Jesúsenꞌ, naꞌ lleꞌe Leꞌe: —Maestro, rweꞌ nakoꞌ beꞌnn wen, ¿Bi da wen llayaꞌl gonaꞌ nench gaꞌt yel nban zejlikane kiaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Naꞌll lle Jesúsenꞌ leꞌe: —¿Bixchen lleꞌo nadaꞌ beꞌnn wen? Toze beꞌnn wen naꞌ zo, Leꞌen nak Dios. Chaꞌ lleꞌnroꞌ gaꞌt yel nban zejlikane koꞌo, llayaꞌl gonoꞌ kanꞌ ne Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naꞌll bneꞌe: —¿Bixha da kaꞌ? Naꞌ Jesúsenꞌ golleꞌ leꞌe: —Bi gotoꞌ beꞌnne, bi tarenoꞌ xhoꞌr beꞌnne, naꞌ bi kwanoꞌ, bi chirjoꞌ diꞌll wenraꞌll ke lwelljoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bdap baraꞌnn xaxhnaꞌo, naꞌ bllieꞌ beꞌnn lwelljoꞌ kanꞌ nllieꞌre kwinoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naꞌll lle beꞌnn weꞌon Jesúsenꞌ: —Yeololte da ki ba benaꞌ, ka nna nakaꞌ bidaꞌote. ¿Bixha nna yallj gonaꞌ nnaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Naꞌll goll Jesúsenꞌ leꞌe: —Chaꞌ lleꞌnroꞌ gakoꞌ kanꞌ lleꞌne Diosenꞌ, jayeꞌt yeolol da de koꞌo, naꞌ mell danꞌ goꞌtoꞌn naꞌ, beꞌen beꞌnn yaꞌch, naꞌll gaꞌt yel wniaꞌ koꞌo yebá, naꞌtell yedoꞌ nnaoꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Naꞌ ka bene beꞌnn wniaꞌn kanꞌ goll Jesúsenꞌ leꞌen, gokreꞌ kwis, zayejeꞌ le yel wniaꞌ xhen naꞌ napeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naꞌll lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Da li llepaꞌ reꞌ, bniꞌ kwis naken ke to beꞌnn wniaꞌ, weꞌe latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ni yepaꞌ reꞌ da yobre, sétere te to bayiꞌxe banꞌ nziꞌi camello lo nay yeꞌchich, kerke to beꞌnn wniaꞌ weꞌe latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Naꞌll beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ, llabán akreꞌ kanꞌ bneꞌen, naꞌ lle akeꞌ Leꞌe: —¿Noxha yerakzenꞌ chaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesúsenꞌ bwieꞌ leakeꞌ, naꞌll golleꞌ leakeꞌ: —Beꞌnnachenꞌ bi gak goneꞌn, zan Dios naꞌ wak goneꞌ yeololte. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Naꞌll lle Pedronꞌ Leꞌe: —Netoꞌ ba bsanraꞌlltoꞌ yeolol da de ketoꞌ nench naotoꞌ rweꞌ. ¿Bixha da wen gaꞌt ketoꞌ nnaꞌ chaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Naꞌll goll Jesúsenꞌ leakeꞌ: —Da li niaꞌ reꞌ, nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, kat yekob Diosenꞌ yellrio ni, naꞌ nadaꞌ kwiaꞌ nnebiaꞌ kanꞌ llnebiaꞌ Dios beꞌnnenꞌ llia yebánꞌ. Naꞌ reꞌ chllinn naꞌ, kweꞌre kwitaꞌn nnebiaꞌre, naꞌ gonre yel koxchis ke chllinn kwen beꞌnn kaꞌ nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Naꞌ noteze beꞌnne ba bsanraꞌll rilleꞌ, biꞌcheꞌ, zaneꞌ, xaxhneꞌe, xhoꞌreꞌ, xhiꞌnneꞌ, naꞌ yellrio keꞌe danꞌ llzenayeꞌ kiaꞌn, Diosenꞌ wayoeꞌ leꞌe ka do to gayoa (100) ras, ka yeolol da kaꞌ bsanraꞌlleꞌ naꞌ. Naꞌ leskaꞌ gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Naꞌ beꞌnn zan, nak akeꞌ ka beꞌnn lliarao nnaꞌ, wllin lla kat yeyak akeꞌ ka beꞌnn zaꞌa xhante, naꞌ beꞌnn kaꞌ nak akeꞌ ka beꞌnn zaꞌa xhante nnaꞌ, leakeꞌn yeyak akeꞌ ka beꞌnn lliarao. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesúsenꞌ bneꞌe: —Yel llnebiaꞌ ke Diosenꞌ llia yebánꞌ llsaꞌkrebraꞌn ka ke to beꞌnn napeꞌ to yellrio ga nazeꞌ lba uvas. Naꞌ bzeꞌe rillenꞌ to tzir daꞌo byejeꞌ jatirjeꞌ beꞌnn wen llin gon akeꞌ llin rao yellrio keꞌen lla naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naꞌ bgaꞌnnreneꞌ diꞌll beꞌnn wen llin kaꞌ, to denario chixhjeꞌ totoeꞌ, kon ka llak tlla llin. Naꞌll bseꞌleꞌ leakeꞌ ganꞌ de llin naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Naꞌ ka do lladá ga, byejeꞌ ganꞌ llak yaꞌan, naꞌ breꞌreꞌ nna llaꞌll beꞌnn bi de xchin. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Naꞌ lleꞌe leakeꞌ: “Lechejrén ganꞌ nazaꞌ lba uvas kiaꞌn, lelljén llin, naꞌ wyixhjkzaꞌ reꞌ ka llayaꞌle.” Naꞌll jak beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Da yobre byejeꞌ ka do wawill, naꞌ ka do lladá chonne. Breꞌreꞌ nna llaꞌll beꞌnne bibi llin de ke akeꞌ, naꞌll bseꞌleꞌ leakeꞌ nench lljen akeꞌ llin ganꞌ nazeꞌ lba uvas keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Naꞌ ka do lladá gaꞌy tlleꞌlre byejeꞌ da yobre, naꞌ breꞌllreꞌ nna niꞌtll beꞌnne bibi llin llon akeꞌ. Naꞌll lleꞌe leakeꞌ: “¿Bixchen bi byejre llin?” ");
INSERT INTO zpuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Naꞌll lle akeꞌ leꞌe: “Notno bne netoꞌ lljentoꞌ llin.” Naꞌll lleꞌe leakeꞌ: “Lechejrén chaꞌ, lelljén llin ganꞌ nazaꞌ lba uvas kiaꞌn. Naꞌ chixhjkzaꞌ reꞌ ka llayaꞌlkze.” Naꞌll jak beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Naꞌ ka gol naꞌ, xan lba uvas naꞌ, lleꞌe beꞌnn wen llin brao keꞌen: “Bayaxh beꞌnn wen llin kaꞌ nench chixhj akoeꞌ, beꞌnn kaꞌ braꞌ kanꞌ ba llayoll llin naꞌ, soraoꞌ chixhjoꞌ, naꞌtellre chixhjoꞌ beꞌnn kaꞌ braꞌ da nelle.” ");
INSERT INTO zpuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Naꞌll bzorao beꞌnn wen llin braonꞌ yixhjeꞌ zgaꞌtek beꞌnn kaꞌ bllin lladá gaꞌye ba wlleꞌn, bdixhjeꞌ leakeꞌ twej denario totoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Naꞌ ka bzorao bdixhjeꞌ beꞌnn kaꞌ bzorao tzir naꞌ, naꞌ llak akreꞌ chaꞌ chixhjlleꞌ leakeꞌ da xhenllenꞌ. Naꞌ tozkze ka bdixhjeꞌ yeolol akteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Naꞌ ka bayoll bxhiꞌi raxhj beꞌnn kaꞌ, bzorao tzir naꞌ, gokllaꞌa akeꞌ, bi byazraꞌll akeꞌ kanꞌ ben xan llin naꞌ, naꞌ bchachrén akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne akeꞌ: “Do lla bllayrao netoꞌ rao zeꞌyenꞌ bentoꞌ llin koꞌon, naꞌ rebze ka bdixhjoꞌ netoꞌ ren beꞌnn kaꞌ ben llin to hor wejze.” ");
INSERT INTO zpuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Naꞌ xan llin naꞌ golleꞌ toeꞌ: “Beꞌnn nllieꞌraꞌ, bitbi da xhinnj llonaꞌ keré. ¿Kere bnetello to denario chixhjaꞌ reꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ba bxhiꞌi raxhjoꞌ, wak wayejoꞌ, lleꞌnraꞌ waꞌa beꞌnn ki kon kanꞌ ba bennaꞌ rweꞌ, laꞌkze braꞌ akeꞌ ba wlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nadaꞌ gonaꞌ kon ka lleꞌnraꞌ ren da de kiaꞌ. ¿Chaꞌ llakxheꞌroꞌ danꞌ nakaꞌ beꞌnn wen naꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kanꞌ naken naꞌ, beꞌnn zan nak akeꞌ ka beꞌnn lliarao, naꞌ wllin lla kat yeyak akeꞌ ka beꞌnn zaꞌa xhante, naꞌ beꞌnn kaꞌ nak akeꞌ ka beꞌnn zaꞌa xhante nnaꞌ, leakeꞌn yeyak akeꞌ ka beꞌnn lliarao. Le beꞌnn zan naꞌ llayaxheꞌ, naꞌ txhonnjzeꞌn llalloj. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka bzaꞌa Jesúsenꞌ chejeꞌ Jerusalén naꞌ, naꞌ brejeꞌ kere beꞌnn chllinn kaꞌ non Leꞌe txhen naꞌ, naꞌll golleꞌ leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Nnaꞌ ba zejllo Jerusalén naꞌ, ganꞌ gon akeꞌ nadaꞌ rao naꞌa bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ wchoy akeꞌ kiaꞌ gataꞌ, nadaꞌ nakaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Naꞌ gon akeꞌ nadaꞌ rao naꞌa beꞌnn bi nak beꞌnn Israel nench wtitj akreꞌ nadaꞌ, naꞌ chintat akeꞌ nadaꞌ, naꞌ got akeꞌ nadaꞌ, wdaꞌa akeꞌ nadaꞌ leꞌ yay cruz, naꞌ yeyónn lla naꞌ, yebanaꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naꞌll byej xhiꞌnn Zebedeo beꞌnn kaꞌ nziꞌi Jacobo ren Juan, naꞌ ren xhnaꞌ akeꞌ naꞌ, naꞌ bcheꞌk xhib xhnaꞌ akeꞌn rao Jesúsenꞌ. Naꞌ lleꞌe Leꞌe: —Llnnabraꞌ rweꞌ to okré. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Naꞌll goll Jesúsenꞌ leꞌe: —¿Bixha okrénꞌ lleꞌnroꞌ gonaꞌ? Naꞌll lleꞌe Leꞌe: —Lleꞌnraꞌ llopte xhiꞌnnaꞌ ki, kweꞌ akbeꞌ chlaꞌ weje kwitoꞌn kate llin lla nnebiaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesúsenꞌ lleꞌe Jacobonꞌ ren Juan naꞌ: —Reꞌ ni ke nnézzere ka danꞌ llnnabrenꞌ. ¿Wchoyraꞌllre tere yel ziꞌ yel yaꞌ ka danꞌ tiaꞌ nadaꞌ, gak keré kanꞌ gak kiaꞌ naꞌ? Naꞌll lle akeꞌ Leꞌe: —Wzoekzetoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naꞌll lle Jesúsenꞌ leakeꞌ: —Da likze tere yel ziꞌ yel yaꞌ ka danꞌ tiaꞌ nadaꞌ, naꞌ gak keré kanꞌ gak kiaꞌn, zan bi naken rallnaꞌ nniaꞌ noxhanꞌ kweꞌ kwitaꞌn kat llin lla nnebiaꞌ naꞌ, beꞌnn kaꞌ ba brej Xaꞌ Dios naꞌn, leakeꞌn gak kweꞌ akeꞌ kwitaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Naꞌll ka bene beꞌnn ye chi keꞌe kaꞌ, kanꞌ bne beꞌnn kaꞌ chop naꞌ, gokllaꞌa akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Naꞌll goxh Jesúsenꞌ yeololeꞌ, naꞌ lleꞌe leakeꞌ: —Ba nnézkzere beꞌnnenꞌ llnebiaꞌ toto yell, llon akeꞌ wzenay beꞌnn kaꞌ nak rallnaꞌa akeꞌ, naꞌ beꞌnn kaꞌ nak beꞌnn brao llnebiaꞌ akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Zan bi naken kaꞌ ke reꞌ, chaꞌ notezre lleꞌnere gakre beꞌnn brao, llayaꞌl wxhexjraꞌllre gakrenre lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Naꞌ chaꞌ notezre lleꞌnere gakre beꞌnn lliarao, zgaꞌtek llayaꞌle gakre ka to beꞌnn wen llin ke beꞌnn lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ka nakzen kiaꞌ nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, kere zaꞌa nench wzeniaꞌnaꞌa beꞌnne nadaꞌn, zaꞌa nench wzeniaꞌnaꞌ beꞌnnach, naꞌ llsanraꞌll kwinaꞌ got akeꞌ nadaꞌ ni ke xtoꞌl beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Naꞌ ka bazaꞌa akeꞌ yell Jericónꞌ beꞌnn zan ba nao Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naꞌ chop beꞌnn lchol zjalliꞌ lloaꞌ nez ganꞌ zayejeꞌ naꞌ, naꞌll ka gokbeꞌe akreꞌ ba zayej Jesúsenꞌ ganꞌ zjalliꞌ akeꞌn, naꞌll besiaꞌ akeꞌ ne akeꞌ: —¡Xantoꞌ, rweꞌn nakoꞌ xhiꞌnn dialla rey David! ¡Bayaꞌchraꞌllchga netoꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Naꞌ beꞌnn zan kaꞌ zanao Leꞌen bdil akeꞌ leakeꞌ nench kweꞌ akeꞌ llize. Naꞌ leakeꞌn yezikre bnne akeꞌ zilljlle: —¡Xantoꞌ, rweꞌ nakoꞌ xhiꞌnn dialla rey David! ¡Bayaꞌchraꞌllchga netoꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Naꞌll brexh Jesúsenꞌ, naꞌ goxheꞌ leakeꞌ jakeꞌ raweꞌn, naꞌll lleꞌe leakeꞌ: —¿Bixhanꞌ lleꞌnere gonaꞌ ke reꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Naꞌll lle akeꞌ Leꞌe: —Xantoꞌ, lleꞌnetoꞌ yereꞌtoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesúsenꞌ bayaꞌchraꞌlleꞌ leakeꞌ, naꞌ bdaneꞌ yejrao akeꞌn, naꞌll le bareꞌe aktereꞌ, naꞌll bnao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ka ba ll-llin akeꞌ Jerusalén naꞌ, naꞌ byej akeꞌ yell danꞌ nziꞌi Betfagé, ganꞌ zo yaꞌ ganꞌ nziꞌi Yaꞌ Olivos. Naꞌll bseꞌl Jesúsenꞌ chop beꞌnn kaꞌ non Leꞌe txhen naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","lleꞌe leakeꞌ: —Lechej yell danꞌ lliꞌ kwite kaꞌle, naꞌ kat llinre naꞌ, naꞌ reꞌre to burr noꞌre daꞌbaꞌ yay, naꞌ rente to xhiꞌnnbaꞌ. Naꞌ lewsell akbaꞌ, naꞌ lewcheꞌe akbaꞌ ganni. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Naꞌ chet kaꞌ no bi ye reꞌ, naꞌ leyé akeꞌ: “Xantoꞌ naꞌn yalljreꞌ leakbaꞌ. Kat yeyoll naꞌ le yedsán aktetobaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gok da ki nench bzoa diꞌll kanꞌ bzoj beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Goll beꞌnn kaꞌ niꞌt ganꞌ nziꞌi Sión naꞌ: “Lewiakeroꞌ, ba zaꞌa rey kerénꞌ, beꞌnn maxh daꞌo nakeꞌ, naꞌ llieꞌ koꞌll to burr daꞌo, xhiꞌnn bayiꞌx banꞌ lloaꞌ yoaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naꞌll byej beꞌnn kaꞌ yell daꞌon, naꞌ ben akeꞌ kanꞌ goll Jesúsenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Naꞌll bacheꞌe akeꞌ burrenꞌ rente xhiꞌnnbaꞌ daꞌon ganꞌ ze Jesúsenꞌ, naꞌll bxoa no xha akeꞌ koꞌllbaꞌn, naꞌll bllia Jesúsenꞌ koꞌllbaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Beꞌnn zan kwis ben akeꞌ Jesúsenꞌ xhen, naꞌ bchirj no xha akeꞌ tnezenꞌ, nench brej burrenꞌ len, naꞌ ye baleꞌ bchoy akeꞌ no xhoꞌz yay, naꞌ bniꞌt akeꞌn tnezenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Naꞌ beꞌnn kaꞌ lliarao, ren beꞌnn kaꞌ nao koꞌllre, llosiaꞌ akeꞌ ne akeꞌ: —¡Beꞌnn zaꞌk beꞌnn ni, nakeꞌ xhiꞌnn dialla rey David! ¡Nak laꞌy beꞌnnenꞌ zaꞌa ganni, beꞌnn bseꞌl Xanllo Dios! ¡Doweꞌrao Diosenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Naꞌ ka byoꞌ Jesúsenꞌ Jerusalén naꞌ, yeolol beꞌnn kaꞌ llaꞌa yellenꞌ llabán akreꞌ, naꞌll ne akeꞌ: —¿Noxha beꞌnnenꞌ braꞌ ni lla? ");
INSERT INTO zpuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Naꞌll beꞌnn kaꞌ zaꞌrén Jesúsenꞌ, balliꞌi akeꞌ xtiꞌll akeꞌn, goll akeꞌ leakeꞌ: —Beꞌnn ninꞌ Jesús, beꞌnn zaꞌa yell Nazaret ganꞌ nbane Galilea, naꞌ lloeꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesúsenꞌ byoeꞌ liaꞌ yodaꞌo braonꞌ, naꞌll bachacheꞌ yeolol beꞌnn kaꞌ lloꞌt, naꞌ beꞌnn kaꞌ llaꞌo. Naꞌll bllixeꞌ ganꞌ nkwaꞌa beꞌnn kaꞌ mell danꞌ llchaꞌa akeꞌn, naꞌ blloꞌnneꞌ ganꞌ llbeꞌ beꞌnn kaꞌ lloꞌt plom daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naꞌll lleꞌe leakeꞌ: —Nyoj xtiꞌll Diosenꞌ: “Rillaꞌn, naken yoꞌ ga llayaꞌl yelwill beꞌnn nadaꞌ”, naꞌ reꞌ ba nonren ka broj ke beꞌnn wan. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Naꞌll zjak beꞌnn lchol kaꞌ, naꞌ ren beꞌnn xhinnj kaꞌ raweꞌn, naꞌll bayoneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bixha bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, ka breꞌe akreꞌ yel wak danꞌ llon Jesúsenꞌ, gokllaꞌa akeꞌ kwis, naꞌ leskaꞌ bllaꞌa akeꞌ ka ben akreꞌ besiaꞌ bidaꞌo kaꞌ llaꞌa do liaꞌ yodaꞌo ne akbeꞌ: “¡Beꞌnn zaꞌk beꞌnn ni, nakeꞌ xhiꞌnn dialla rey David!” ");
INSERT INTO zpuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Naꞌll lle akeꞌ Jesúsenꞌ: —¿Zenroꞌ binꞌ bne bidaꞌo kaꞌ? Jesúsenꞌ ballieꞌ xtiꞌll akeꞌn, golleꞌ leakeꞌ: —Bénkzeraꞌ. ¿Bi nna wrabre kanꞌ nyoj xtiꞌll Diosenꞌ? Nen: Ba benoꞌ nench xkwiꞌd kaꞌ, ren bdaꞌon nna llaꞌll, llon akbeꞌ rweꞌ xhen kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naꞌll ballojeꞌ ganꞌ llaꞌa beꞌnn kaꞌ, naꞌ bazeꞌe yellenꞌ. Naꞌ lleꞌ naꞌ, goꞌyeꞌ ganꞌ nziꞌi Betania. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Naꞌ tzir bateyó, bagoꞌ akeꞌ nez zjayakeꞌ Jerusalén naꞌ da yobre. Naꞌ bdon Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naꞌ breꞌreꞌ to yay higo zon lloaꞌ nezenꞌ, naꞌ jawieꞌ chaꞌ llian daxhix. Naꞌ bibi llian, xhlaꞌyzenꞌ llia. Naꞌ golleꞌ yayenꞌ: —Billbi daxhix kwiakzoꞌ. Naꞌll le byechte yayenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naꞌll babane beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ, ka breꞌe akreꞌ kanꞌ goken, naꞌll ne akeꞌ: —¿Akre goken le byechte kaze yayenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Naꞌllenꞌ lle Jesúsenꞌ leakeꞌ: —Da li niaꞌ reꞌ, chaꞌ gonliraꞌllre Diosenꞌ, naꞌ bi gakgánere, wakse gonre kanꞌ benaꞌ naꞌ, naꞌ yech yayenꞌ, naꞌ lekze wak yere yaꞌ ni: “Kwas ganni, naꞌ jasó lo nisdaꞌo naꞌle”, naꞌ wakse kanꞌ nnerenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Naꞌ chaꞌ gonliraꞌllre Diosenꞌ, biteze da nnábere Diosenꞌ kat yelwillrenꞌ, gonnkzeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Naꞌll Jesúsenꞌ byejeꞌ yodaꞌo braonꞌ da yobre. Naꞌ ka llroeꞌ llsedreꞌ beꞌnn kaꞌ llaꞌa naꞌ, le jabiꞌyte bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn gor brao kaꞌ, llnebiaꞌ yell Israelenꞌ, bnnab akreꞌ Leꞌe: —¿Bi yel llnebiaꞌ napoꞌ llonoꞌ da ki? ¿No benn yel llnebiaꞌn llonoꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —Leskaꞌ nadaꞌ dekze to da nnabraꞌ reꞌ. Chaꞌ yelliꞌre xtiꞌllaꞌn, naꞌll nniaꞌ bi yel llnebiaꞌn llonaꞌ da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lennechk, ¿noxha bseꞌl da Juan beꞌnnenꞌ bchoa beꞌnne nis? ¿Diosenꞌ bseꞌl leꞌe, o chaꞌ beꞌnnachenꞌ? Naꞌll lle lwellj akeꞌ: —Chaꞌ yelloeꞌ Diosenꞌ bseꞌl leꞌe, naꞌ yeꞌe lliꞌo: “¿Bixchen ke byejleꞌre keꞌe chaꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Naꞌ bi gak yelloeꞌ beꞌnnachenꞌ bseꞌl leꞌe, le yeololte beꞌnne llaꞌa do ganni llejleꞌ akeꞌ Diosenꞌ bseꞌl da Juan naꞌ, beꞌe xtiꞌlleꞌn, naꞌ nxholl bi gon akreꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Naꞌll balliꞌi akeꞌ xtiꞌlleꞌn lle akeꞌ Leꞌe: —Bi nnézetoꞌ. Naꞌll lle Jesúsenꞌ leakeꞌ: —Leskaꞌ nadaꞌ bi yepaꞌ reꞌ bi yel llnebiaꞌn llonaꞌ da kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Naꞌ Jesúsenꞌ lleꞌe leakeꞌ: —Lewayakbeꞌchk bi zejen danꞌ yepaꞌ reꞌ ni: To beꞌnne bzo chop xhiꞌnneꞌ, naꞌ golleꞌ tobeꞌ: “Xhiꞌnnaꞌ, lleꞌnraꞌ chejoꞌ nnaꞌ lla, lljenoꞌ llin ganꞌ nazllo lba uvas kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naꞌll llebeꞌ leꞌe: “Kaꞌa, bi chaꞌa.” Naꞌ bdere bayátebeꞌ, naꞌll byejbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Naꞌll byejeꞌ ganꞌ zo xhiꞌnneꞌn ye to, naꞌll lleꞌebeꞌ kanꞌ gollkzeꞌ bi biꞌchbeꞌ naꞌ. Bi naꞌ le bchebtebeꞌ llebeꞌ leꞌe: “Wakse, naꞌ chaꞌa.” Naꞌ bi byejbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lennechk, ¿norbeꞌ bi ki chop ben kanꞌ gokraꞌll xabeꞌn? Naꞌll lle akeꞌ leꞌe: —Bi nell naꞌ. Naꞌll lle Jesúsenꞌ leakeꞌ: —Ka naksen. Diꞌll likze niaꞌ reꞌ, beꞌnn wachixhj kaꞌ, naꞌ noꞌr reꞌe kaꞌ, wyobll wzenay akeꞌ ke Diosenꞌ nnebieꞌ lo raꞌlldaꞌo akeꞌ kerke reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ka nak da Juan beꞌnnenꞌ bchoa beꞌnne nis, badsoreneꞌ reꞌ ganni, naꞌ bdixjweꞌreꞌ reꞌ kanꞌ llayaꞌl gonre. Naꞌ bi byejleꞌre keꞌe. Naꞌ beꞌnn wachixhj kaꞌ, naꞌ ren noꞌre reꞌe kaꞌ byejleꞌ akeꞌ keꞌe. Bixha reꞌ, kate gokbeꞌre kanꞌ ben beꞌnn kaꞌ ba byejleꞌ akeꞌ keꞌe, naꞌ bi bayátere da xhinnj kerénꞌ chejleꞌre keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Lewzenay ke ye to diꞌll weꞌrenaꞌ reꞌ ni. Bzo to beꞌnn gozeꞌ chkweꞌ xhen lba uvas rao yellrio keꞌen, naꞌ bzechjeꞌn reꞌje. Naꞌ benchaꞌweꞌ to ga wsieꞌ uvas kaꞌ. Naꞌll beneꞌ ye to da nak sibe ga lljakwaꞌa beꞌnn kaꞌ gap akeꞌ lba uvas kaꞌ. ’Naꞌ bkwaꞌnneꞌ yellrionꞌ rao naꞌa beꞌnn yezieꞌ bi danꞌ weꞌen naꞌ, naꞌll bzeꞌe zejeꞌ ziꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ka bllin lla yeziꞌi akeꞌ danꞌ goz akeꞌ naꞌ, bseꞌleꞌ beꞌnn wen llin keꞌe kaꞌ ganꞌ llaꞌa beꞌnn kaꞌ noneꞌ rallnaꞌa lba uvas kaꞌ, nench yeziꞌi akeꞌ raꞌt ka to danꞌ llayaꞌl yezieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bixha beꞌnn kaꞌ nak rao naꞌa len naꞌ, beꞌx akeꞌ beꞌnn kaꞌ bseꞌleꞌn, toeꞌ bdin akeꞌ yay, ye toeꞌ bet akeꞌ, naꞌ ye toeꞌ bchekw akeꞌ leꞌe yej. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Naꞌll bseꞌl xan akeꞌn beꞌnn zanll ka beꞌnn nell kaꞌ, naꞌ lekze kaꞌ ben akreꞌ beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Naꞌll bseꞌleꞌ xhiꞌnnkzeꞌ, llakreꞌ xhiꞌnneꞌ naꞌ, wap akebeꞌ baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bixha beꞌnn kaꞌ nak rallnaꞌa lba uvas kaꞌ, ka breꞌe akreꞌ xhiꞌnneꞌn, naꞌll lle lwellj akeꞌ: “Beꞌnn ni yegaꞌnn ren yellrio ke xeꞌen kat gateꞌ. Lechoꞌo lljetlloeꞌ nench yegaꞌnnrenllon lliꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naꞌll beꞌx akeꞌ leꞌe, babej akeꞌ leꞌe ganꞌ llaꞌa lba uvas kaꞌ, naꞌll bet akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Bayoll beꞌe Jesúsenꞌ diꞌll kaꞌ, bneꞌe: —¿Akxha llákere gon xan yellrionꞌ ke beꞌnn kaꞌ, bkwaꞌnnreneꞌ lba uvas keꞌe kaꞌ kat yellinkze kwineꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Naꞌll balliꞌi akeꞌ xtiꞌlleꞌn ne akeꞌ: —Beꞌnn wen da xhinnj kaꞌ goteꞌ, naꞌ bi yeyaꞌchraꞌlleꞌ leakeꞌ, naꞌ yeyoneꞌ yellrionꞌ rallnaꞌa beꞌnn yobre beꞌnn gon wen, yeyoeꞌ akeꞌ leꞌe ka to da llayaꞌleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Bi nna wrabre kanꞌ nyoj xtiꞌll Diosenꞌ? Nen: Yej danꞌ bi byoꞌraꞌll beꞌnn wen yoꞌ kaꞌ, gonrén akeꞌ llin, len naꞌ ba naken yej skin. Da nanꞌ ben Xanllo Diosenꞌ, naꞌ naken da yebánello kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ke len naꞌ llepaꞌ reꞌ, reꞌ bi llzenayre ke Dios, kwej yichjeꞌ reꞌ, naꞌ kwejeꞌ beꞌnn yobre beꞌnn wzenay keꞌe, nench nnebieꞌ yichjraꞌlldaꞌo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ka nak yejenꞌ, noteze beꞌnn yaleꞌ rawen wachjeꞌ, naꞌ chet kaꞌ bix yejenꞌ koꞌlleꞌ, wchochjten leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Naꞌ ka bene bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn fariseo kaꞌ diꞌllenꞌ beꞌe Jesúsenꞌ, gokbeꞌe akreꞌ ke leakseꞌn bneꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Naꞌll gokraꞌll akeꞌ goꞌx akeꞌ Leꞌe, naꞌ blleb akeꞌ bi gone beꞌnn kaꞌ leakeꞌ, le beꞌnn llaꞌa rao yell naꞌn, ba byejleꞌ akeꞌ keꞌe, nakeꞌ beꞌnn lloeꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Da yobre beꞌrén Jesúsenꞌ beꞌnn kaꞌ diꞌll lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Yel llnebiaꞌ ke Diosenꞌ, llonen rebe ka danꞌ gok ke beꞌnn ni. Bzo to beꞌnn wnebiaꞌ beneꞌ gaxt ka bchaynaꞌa xhiꞌnneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naꞌ bllin lla sorao lnninꞌ, naꞌ bseꞌleꞌ beꞌnn wen llin keꞌe kaꞌ, jalwill akeꞌ beꞌnn kaꞌ beneꞌ yexh chej akeꞌ lnni naꞌ, bixha nono gokraꞌll chej lnni keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naꞌll golleꞌ ye txhonnj beꞌnn wen llin keꞌe kaꞌ: “Lelljell beꞌnn kaꞌ ba benaꞌ yexhenꞌ yed akeꞌ, ba bsiniaꞌ da gaollo. Ba betaꞌ bayiꞌx ak ba zerao nak ba xhen. Naꞌ ye akreꞌ yed akeꞌ gaollo danꞌ ba bsiniaꞌ naꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Naꞌ beꞌnn kaꞌ beneꞌ yexhenꞌ ben akeꞌ kaze. Toeꞌ byejeꞌ jawieꞌ yellrio keꞌe, naꞌ ye toeꞌ byejeꞌ jaxinnjeꞌ bi da goꞌteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Naꞌ ye bal akeꞌ beꞌx akeꞌ beꞌnn wen llin ke beꞌnn wnebiaꞌn, basoꞌn akeꞌ ziꞌ ke akeꞌ, naꞌ bet akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Naꞌll ka bene beꞌnn wnebiaꞌn kanꞌ goken, naꞌ goklleꞌe. Naꞌ bseꞌleꞌ wakaꞌa ya keꞌe kaꞌ jet akeꞌ beꞌnn kaꞌ basoꞌt beꞌnn wen llin keꞌe kaꞌ, naꞌ bzey akeꞌ rall akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Naꞌll golleꞌ beꞌnn wen llin keꞌe kaꞌ: “Ba bsiniaꞌ danꞌ gaollo rao lnninꞌ, naꞌ ka nak beꞌnn kaꞌ benaꞌ yexhenꞌ nakbieꞌ bi zaꞌk akeꞌ yed akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lechej lelljatá yeolol nez, naꞌ leyé yeolol beꞌnn yellayre yed akeꞌ lnninꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naꞌll byej beꞌnn wen llin kaꞌ yeolol nez kaꞌ, naꞌll jatop akeꞌ kon yeolol beꞌnne badil akreꞌ, no beꞌnn wen, naꞌ ren beꞌnn wen da xhinnj, nench ballaꞌa lo yoꞌ ganꞌ llak lnni naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Bixha ka byoꞌ beꞌnn wnebiaꞌn jawieꞌ beꞌnn kaꞌ llaꞌa naꞌ, naꞌ breꞌreꞌ to beꞌnne bi nakeꞌ raꞌll danꞌ llayaꞌl gakeꞌ rao lnni naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naꞌll lleꞌe leꞌe: “Beꞌnn nllieꞌraꞌ, ¿akre gok byoꞌ ganni, le bi nakoꞌ raꞌll danꞌ llayaꞌl gakoꞌ?” Beꞌnn naꞌ bibi ballelreꞌ akre yeꞌe leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Naꞌll goll beꞌnn wnebiaꞌn beꞌnn wen llin keꞌe kaꞌ, wchej akeꞌ niaꞌneꞌe nench yebej akeꞌ leꞌe, lljalek akeꞌ leꞌe ganꞌ nak xchol, naꞌ kwelleꞌ gaoxoxj layeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Le beꞌnn zan naꞌ llayaxheꞌ, naꞌ txhonnjzeꞌn llalloj. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naꞌ beꞌnn fariseo kaꞌ bdop akeꞌ, naꞌ llayirj akeꞌ akrenꞌ gon akeꞌ, nench kwej akeꞌ Jesúsenꞌ diꞌll da wdeꞌ akreꞌ, naꞌ gao akeꞌ xhia keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Naꞌ beꞌnn fariseo kaꞌ, bseꞌl akeꞌ beꞌnne nak akeꞌ txhen, naꞌ ren ye bale beꞌnn llon Herodes txhen, nench jell akeꞌ Jesúsenꞌ: —Maestro, nnézetoꞌ zotezoꞌ lloeꞌo diꞌll li, naꞌ llzejnieꞌroꞌ beꞌnne danꞌ llazraꞌll Diosenꞌ gonllo, naꞌ bi llwiaꞌo chaꞌ bi ne beꞌnn kaꞌ, le kere llwiaꞌo ka nak yichjrao beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ke len naꞌ zadnnábetoꞌ rweꞌ. ¿Naken wen no chixhj da llayaꞌl chixhjllo rao beꞌnnenꞌ nak le zeraoze wnebiaꞌ, beꞌnnenꞌ llia Roma, chaꞌ bi naken wen? ");
INSERT INTO zpuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Naꞌ Jesúsenꞌ bayakbeꞌreꞌ ka da xhinnjenꞌ yoꞌ lo yichjraꞌlldaꞌo akeꞌ naꞌ, naꞌll lleꞌe leakeꞌ: —Reꞌ beꞌnn chop rao. ¿Bixchen lleꞌnere wllixre nadaꞌ ren xtiꞌllaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lewroeꞌchek nadaꞌ to mell danꞌ yixhjrenꞌ. Naꞌll beꞌe akeꞌ Leꞌe to mell danꞌ nziꞌi denario. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Naꞌll bnnabe Jesúsenꞌ leakeꞌ: —¿Noxha raonꞌ daꞌa leꞌ mell ni? ¿No ranꞌ nyoj leꞌ ni? ");
INSERT INTO zpuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Naꞌll lle akeꞌ Leꞌe: —Ke César beꞌnnenꞌ nak beꞌnn wnebiaꞌn lliꞌ Romanꞌ. Naꞌll lleꞌe leakeꞌ: —Da nak ke César lewayoeꞌn leꞌe; naꞌ da llayaꞌl weꞌre Dios, leweꞌn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naꞌll ka ben akreꞌ kaꞌ, babán akreꞌ naꞌ bsan akeꞌ, naꞌll zjayakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naꞌ rao lla naꞌ, ballín beꞌnn saduceo kaꞌ ganꞌ zo Jesúsenꞌ. Beꞌnn kaꞌ ne bi yebán beꞌnn wat kaꞌ, naꞌll bnnab akreꞌ Jesúsenꞌ, lle akeꞌ Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, da Moisésenꞌ bneꞌe, chaꞌ to beꞌnn byio nchayneꞌe, naꞌ chaꞌ gateꞌ, naꞌ nono xhiꞌnneꞌ so, naꞌ no beꞌnn biꞌcheꞌ llayaꞌl yechayneꞌe ren noꞌr wazebenꞌ, nench nniꞌt xhiꞌnn dialla ke biꞌcheꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naꞌ radjtoꞌ ni bzo beꞌnn gok gall biꞌcheꞌ, beꞌnn nellenꞌ bchayneꞌe, naꞌ goteꞌ nono xhiꞌnneꞌ bzo. Naꞌll beꞌnn wllope naꞌ, bachaynaꞌreneꞌ noꞌr wazeb naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Naꞌ leskaꞌ goteꞌ, naꞌ nono xhiꞌnneꞌ bzo. Naꞌ leskaꞌ gok ke beꞌnn wyonne naꞌ, bllinte yeolol beꞌnn gall kaꞌ, toz kaꞌ gok ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Naꞌ bayoll got yeolol beꞌnn kaꞌ, naꞌll gotrén noꞌr naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naꞌ kat yebán akeꞌ radj beꞌnn wat kaꞌ, ¿noxhare beꞌnn gall kaꞌ gak xhoꞌre leꞌe? Le yeololteꞌn bchaynaꞌrén akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Naꞌll lle Jesúsenꞌ leakeꞌ: —Krerenꞌ llonre danꞌ nere kaꞌ, bi nnézere kanꞌ llia xtiꞌll Diosenꞌ danꞌ nyojen, bi nombiaꞌre yel wak keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Katenꞌ yebán beꞌnn wat kaꞌ, billbi wchaynaꞌa gak, le gak akeꞌ ka angl beꞌnn zjazó yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Naꞌ ka nak danꞌ yebán beꞌnn wat kaꞌ, ¿bi nna wrabre da ni, kanꞌ nyoj xtiꞌll Diosenꞌ? Nen: ");
INSERT INTO zpuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nadaꞌ nakaꞌ Dios ke Abraham, naꞌ Dios ke Isaac, naꞌ Dios ke Jacob.” Le Diosenꞌ bi nakeꞌ Dios ke beꞌnn wat, nakseꞌ Dios ke beꞌnn ban. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Beꞌnn kaꞌ ndopenꞌ babán akreꞌ, ka ben akreꞌ diꞌll danꞌ bzejnieꞌreꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ka bnneze beꞌnn fariseo kaꞌ, bzoalli Jesúsenꞌ beꞌnn saduceo kaꞌ, naꞌll badop akeꞌ jakeꞌ raweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Naꞌ to beꞌnn nsed ley danꞌ bzoj da Moisésenꞌ, gokraꞌlleꞌ kwejeꞌ Jesúsenꞌ diꞌll, naꞌ lleꞌe Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, ¿norenꞌ nakll da brao danꞌ nllia Diosenꞌ biaꞌa gonllo? ");
INSERT INTO zpuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Naꞌll goll Jesúsenꞌ leꞌe: —“Llieꞌroꞌ Dios do yichj do raꞌlloꞌ ga zeraoze.” ");
INSERT INTO zpuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Da ninꞌ nak da nell da lliarao gonllo. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Naꞌ da wllope naꞌ, ka rebze naksen ren da nell naꞌ: “Llieꞌroꞌ beꞌnn lwelljoꞌ, kanꞌ nllieꞌroꞌ kwinoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chop da kinꞌ nllia Diosenꞌ biaꞌa gonllo, noꞌxeꞌn doxhen danꞌ bzoj da Moisésenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naꞌ ndop bllay beꞌnn fariseo kaꞌ, naꞌ bnnabe Jesúsenꞌ leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Bi xhbab llonre ke Cristonꞌ beꞌnnenꞌ brej Diosenꞌ yednnebiaꞌn? ¿No xhiꞌnn dialla nakeꞌ? Naꞌll lle akeꞌ Leꞌe: —Xhiꞌnn dialla da rey Davidenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Naꞌll lle Jesúsenꞌ leakeꞌ: —Chaꞌ kaꞌ naken chaꞌ, ¿bixchen kanꞌ broeꞌ Spíritu ke Diosenꞌ Davidenꞌ, bneꞌe Cristo naꞌn nak Xaneꞌ? Naꞌllenꞌ bzojeꞌ bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xanllo Diosenꞌ golleꞌ Xanaꞌn: “Blleꞌ kwitaꞌ ni nnebiaꞌrenoꞌ nadaꞌ, naꞌll gonaꞌ yeolol beꞌnn llwie rweꞌ, wxhexj yichj akeꞌ wzenay akeꞌ koꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Naꞌ chaꞌ Davidenꞌ golleꞌ leꞌe “Xanaꞌ”, akxha gak nnello nak Cristonꞌ xhiꞌnn dialla da rey David? ");
INSERT INTO zpuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Naꞌll nollno gokse yelliꞌi xtiꞌlleꞌn. Naꞌ lla naꞌte, nollno bayaxhjkze billre nnab akreꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesúsenꞌ bzoraweꞌ beꞌreneꞌ beꞌnn keꞌe kaꞌ diꞌll, beꞌnn kaꞌ non Leꞌe txhen naꞌ, ren beꞌnn kaꞌ bllay ganꞌ zoeꞌ naꞌ, naꞌ bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Beꞌnn kaꞌ llsedre ke leyenꞌ naꞌ, ren beꞌnn fariseo kaꞌ, ba zjalan akeꞌ latj ke da Moisésenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Naꞌ wzenayre kat weꞌe akeꞌ diꞌll, kanꞌ ne xtiꞌll Dios naꞌ, naꞌ gonre kanꞌ ne akeꞌn. Zan bi gonre kanꞌ llon leakeꞌn, le bi llon akeꞌ kanꞌ ne akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Le ley ke akeꞌn naken ka to yoaꞌ ziꞌ, da nono soe waꞌa, len naꞌ lleꞌn akreꞌ waꞌa beꞌnn yobre len, naꞌ bi llwaꞌa akeꞌn leakeꞌ, naꞌ ni ke lldaꞌbaꞌy akzeꞌ gon akeꞌ kanꞌ ne akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ka nak beꞌnn ki yeolol danꞌ llon akeꞌn, llon akeꞌn ga reꞌe beꞌnne leakeꞌ, nench gon akeꞌ leakeꞌ xhen. Da xhen non akeꞌ yich kaꞌ, nchej akeꞌ do naꞌa akeꞌ, do roxhga akeꞌ ganꞌ llia xtiꞌll Diosenꞌ. Naꞌ da tonn xhen non xha akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Naꞌ llawé akreꞌ lljacheꞌ akeꞌ ga lljacheꞌ beꞌnn brao kaꞌ, katenꞌ lljakeꞌ ga llak no lnni, naꞌ kat llej akeꞌ yodaꞌo ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Llawé akreꞌ gap beꞌnne leakeꞌ baraꞌnne kate llallay akreꞌ leakeꞌ do lao yaꞌa. Naꞌ llawé akreꞌ ye beꞌnne leakeꞌ: “Rabí, Rabí” (da ni lleꞌnen nen beꞌnn llzejnieꞌ beꞌnne). ");
INSERT INTO zpuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Zan reꞌ bi yewere ye beꞌnne reꞌ Rabí, le toze nadaꞌ Cristonꞌ nakaꞌ beꞌnn llzejnieꞌ beꞌnne. Naꞌ yeololre nakre ka biꞌch lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naꞌ leskaꞌ bi yezreꞌ noteze beꞌnne: “Xa”, le toze Dios beꞌnnenꞌ zo yebánꞌ nak Xallo. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naꞌ bi yewere chaꞌ ye beꞌnne reꞌ: “Xanaꞌ”, le toz nadaꞌ Cristonꞌ nakaꞌ ka beꞌnn lliarao raore. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Chaꞌ nol reꞌ nakre beꞌnn brao, llayaꞌl wxhexjraꞌllre gakrén lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Le noteze beꞌnne llayoneꞌ xhen kwineꞌ, Dios naꞌ goneꞌ sieꞌ to zdoꞌ, naꞌ beꞌnne llxhexjraꞌll raweꞌ, Dios naꞌ goneꞌ gakeꞌ xhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Zan ¡nyaꞌchraz naken keré llroeꞌ llsedre ke leyenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Llonre kaꞌkze beꞌnn llsej yebá ke Xanllo Diosenꞌ. Naꞌ ni ke lldez reꞌ, naꞌ ni ke lloeꞌzre latj te beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Naꞌ ¡nyaꞌchraz gak keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Llkaꞌre no yoꞌ ke noꞌr wazeb kaꞌ, naꞌ da lldeꞌre kat llalwillre Diosenꞌ, scha llzere lloeꞌre diꞌll. Wallayraollre kerke nollre beꞌnn llon da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Naꞌ ¡nyaꞌchraz gak keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Llejteze llejre, lljatirjre beꞌnn ziꞌte, beꞌnn gonrén reꞌ txhen; ke chop rasre wallayrao akeꞌ, ka nak baziꞌi akeꞌ danꞌ llroeꞌ llsédere naꞌ, naꞌ llak aklleꞌ beꞌnn wen da xhinnj ka reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Nyaꞌchraz gak keré! ¡Nakre ka beꞌnn lchol, beꞌnn llgoꞌ ye to beꞌnn yobre nez! Nere noteze beꞌnne chaꞌ neꞌe: “Yodaꞌo braonꞌ llzoaꞌn, diꞌll linꞌ lloaꞌa”, naꞌ nere kere bi zejen kanꞌ bneꞌen. Zan chaꞌ neꞌe: “Yeolol bi da nak de ya chaꞌo nziꞌi oro danꞌ de lo yodaꞌon llzoaꞌn, diꞌll linꞌ lloaꞌa”, naꞌll nere llayaꞌl goneꞌ kanꞌ bneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Reꞌ nakreꞌ ka to beꞌnn lchol bi llejnieꞌre! ¿Llákere chaꞌ danꞌ nak de ya chaꞌo danꞌ nziꞌi oro, zaꞌkllen kerke yodaꞌo ganꞌ xhoan nak laꞌyenꞌ naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naꞌ leskaꞌ nere chaꞌ to beꞌnn neꞌe: “Rao bkoy ganꞌ llxoa akeꞌ danꞌ lloeꞌrao akeꞌ Dios llzoaꞌn, diꞌll linꞌ lloaꞌa”, naꞌ nere bi zejen kanꞌ bneꞌen. Zan chaꞌ neꞌe: “Danꞌ xhoa rao bkoy lo yodaꞌo naꞌ, llzoaꞌn, diꞌll linꞌ lloaꞌa”, naꞌllenꞌ nere llayaꞌl goneꞌ kanꞌ bneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Reꞌ nakre ka beꞌnn lchole bi llejnieꞌre! ¿Llákere chaꞌ zaꞌkll danꞌ xhoa rao bkoyenꞌ, kerke bkoy ke Diosenꞌ ganꞌ xhoan nak laꞌyenꞌ naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Le chaꞌ to beꞌnne neꞌe: “Rao bkoy danꞌ zo lo yodaꞌon llzoaꞌn, diꞌll linꞌ lloaꞌa”, renkze danꞌ xhoa rao bkoy naꞌ, ba llzoeꞌ chet kaꞌ neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Naꞌ chaꞌ beꞌnne neꞌe: “Yodaꞌon llzoaꞌn, diꞌll linꞌ lloaꞌa”, lekze kaꞌ Diosenꞌ llzoeꞌ chet kaꞌ, le naꞌkzenꞌ zo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naꞌ chaꞌ to beꞌnn neꞌe: “Yebánꞌ llzoaꞌn, diꞌll linꞌ lloaꞌa”, Dios naꞌkzenꞌ llzoeꞌ chet kaꞌ, le naꞌn zo Diosenꞌ llnebieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Nyaꞌchraz gak keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Laꞌkze lloeꞌtere Diosenꞌ raꞌt wej toto kwen yiꞌx da llazre, da kaꞌ nziꞌi anis, naꞌ comino, naꞌ menta, naꞌ billre yiꞌxe, naꞌ llsanraꞌllre, bill llzenayre ke da kaꞌ nak da lliaraoll gonllo, kanꞌ ne xtiꞌll Diosenꞌ ganꞌ nen llayaꞌl gonre da nak wen rao Dios, naꞌ llayaꞌl yeyaꞌchraꞌllre lwellj beꞌnnachre, naꞌ llayaꞌl gonre danꞌ ba bnere gonre. Naꞌ da kinꞌ nakll da llia biaꞌll gonre, naꞌ bi kwej yichjre bi weꞌre da kaꞌ lloeꞌkzre Dios naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Nakre ka beꞌnn lchol, beꞌnn llgoꞌ ye to beꞌnn yobre nez! Rebze llonre ka to beꞌnne llabej bebe daꞌo riz yoꞌ loe danꞌ lleꞌjeꞌn, naꞌ bi llakbeꞌreꞌ chaꞌ lleꞌjeꞌn, naꞌ llebeꞌ da xhenll. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Nyaꞌchraz naken keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Nakre ka yeꞌnn da to koꞌllze llyibeꞌ, bi llyibeꞌ loe. Naꞌ llake beꞌnne reꞌ nakre beꞌnn wen, renchaꞌ lo yichjraꞌlldaꞌorenꞌ zeraꞌllre bi da de ke beꞌnne, naꞌ llawere llakaꞌren. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Reꞌ beꞌnn fariseo, nchol yichjraꞌlldaꞌore! Leyeyate da xhinnj kerénꞌ, nench gakre beꞌnn wen. Naꞌll gakre ka to yeꞌnn danꞌ yibe koꞌlle ren loe. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Nyaꞌchraz naken keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Nakre ka to ba, da noneꞌ nbaraz koꞌllre, naꞌ loere llaꞌn llit ke beꞌnn wat, naꞌ yeolol da bi nak yall. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kaꞌn llonrenꞌ, naꞌ llake beꞌnn reꞌ, nakre beꞌnn wen, renchaꞌ lo raꞌlldaꞌorenꞌ nakre beꞌnn chop rao, naꞌ beꞌnn wen da xhinnj kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Nyaꞌchraz naken keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Llonchaꞌore lloaꞌ ba ke beꞌnn kaꞌ beꞌe xtiꞌll Dios kanaꞌ, naꞌ llonchaꞌore lloaꞌ ba ke yezikre beꞌnn gok beꞌnn wen. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naꞌ nere: “Chenak lliꞌo ba zollo kanꞌ bzo xozxtaꞌollo kaꞌ, bi benrén aklloeꞌ txhen, got akeꞌ beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naꞌ danꞌ llonrenꞌ llroeꞌn toz ka naksrenꞌ kanꞌ gok da xozxtaꞌore kaꞌ, bet beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Lewzeraochaze legón bi ka da zban kaꞌ, bill goꞌle gon da xozxtaꞌore kaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Reꞌ nakre beꞌnn zban, naꞌ beꞌnn wxhiyeꞌe, llonre ka bele! ¿Akre gonre nench gak yerare lo yiꞌ gabil, ganꞌ ba nwia Diosenꞌ waseꞌleꞌ reꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ke len naꞌ, wseꞌlaꞌ beꞌnn weꞌreneꞌ reꞌ xtiꞌllaꞌn, naꞌ no beꞌnn siꞌn, naꞌ nollre beꞌnn wzejnieꞌre reꞌ xtiꞌllaꞌn. Naꞌ reꞌ gotre baleꞌ, wdaꞌa akreꞌ leꞌ yay cruz, naꞌ ye baleꞌ chintatre do lo yodaꞌo keré naꞌ, naꞌ ye baleꞌ wrayre, lljakeꞌ gateze yell. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Naꞌ danꞌ gonre kaꞌ, gapre doꞌl ke yel got ke beꞌnn wen kaꞌ, ba got rao yellrio ni, bxhiꞌzen kanꞌ brarj xchen da Abel, beꞌnnenꞌ gok beꞌnn wen rao Dios, naꞌ bayollten ke da Zacarías xhiꞌnn da Berequías. Le Zacaríasenꞌ bet xozxtaꞌore kaꞌ leꞌe radj yodaꞌo za llinl-llo ganꞌ zo bkoyenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diꞌll li niaꞌ reꞌ, reꞌ nbanre nnaꞌ, koꞌllre xhoa yel got ke yeolol beꞌnn kaꞌ basoꞌt xozxtaꞌore kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Reꞌ beꞌnn Jerusalén, llotre beꞌnn kaꞌ ba bseꞌl Diosenꞌ lladzejnieꞌre reꞌ xtiꞌlleꞌn, naꞌ ba bchekwre leakeꞌ yej. Da zan ras gokraꞌllaꞌ yetopaꞌ reꞌ, ka llon to bellj ba ncheꞌe xhiꞌnne, llatobbaꞌ leakbaꞌ lo xirbaꞌn, naꞌ bi gokraꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Naꞌ yell kerénꞌ yegaꞌnnchgan ka to danꞌ nzanraꞌll. ");
INSERT INTO zpuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Naꞌ ni llepaꞌ reꞌ, bill reꞌre nadaꞌ llinte lla nnereꞌ: “Nbaraz ba zaꞌa beꞌnnenꞌ nseꞌl Xanllo Diosenꞌ ganni nnebieꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Naꞌ ka ba llazaꞌa Jesúsenꞌ yodaꞌo braonꞌ, zayejeꞌ ga yobre, jabiꞌy beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ ganꞌ zeꞌen, naꞌ bzorao llroeꞌ akreꞌ Leꞌe yodaꞌon katkenꞌ naken naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn, bneꞌe: —¿Llreꞌre katkenꞌ naken naꞌ? Da li niaꞌ reꞌ, ni to yej ki zjankwaꞌa ganni, noꞌx lwellje bi yegaꞌnnen. Yeololen yeyinnj aken. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Naꞌ lliꞌ Jesúsenꞌ rao yaꞌ ganꞌ nziꞌi Yaꞌ Olivos, jabiꞌy beꞌnn kaꞌ non Leꞌe txhen naꞌ kwiteꞌn, naꞌ lle akeꞌ Leꞌe: —Lleꞌnetoꞌ nnézetoꞌ batenꞌ gak da kaꞌ. Naꞌ ¿akre gak nnézetoꞌ katenꞌ ba zo bawze yedoꞌ, naꞌ ba rez yeyoll yellrionꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn: —Lewiá kwasro nono siyeꞌe reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Le zan beꞌnne llach yellrio ni, beꞌnn yeꞌne wlan akeꞌ latj kiaꞌ ni, naꞌ nne akeꞌ: “Nadaꞌn Cristo.” Naꞌ beꞌnn zan gore siyeꞌe akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Naꞌ sorao yénere llak wdile do gateze, naꞌ yénere wak wdile, naꞌ bi llebre, le kaꞌ llayaꞌlkze gaken. Naꞌ kere le wayollte yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Le til toto yell, yell xhen ren ye to yell xhen, naꞌ kweꞌ yillweꞌ, naꞌ gaꞌt win, naꞌ xoꞌ do gateze. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yeolol da ki gaken, naꞌ naken ka ga zorao yel lley llra. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Naꞌ beꞌnn kaꞌ llaꞌa gateze yell, wie akreꞌ reꞌ danꞌ llonliraꞌllre nadaꞌn, naꞌ gon akeꞌ reꞌ rao naꞌa beꞌnn kaꞌ llwie reꞌ, naꞌ wsaꞌkziꞌ akeꞌ reꞌ, naꞌ got akeꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Naꞌ kanaꞌ beꞌnn zan beꞌnn ba llonliraꞌll akeꞌ nadaꞌ, kwej yichj akeꞌ bill gonliraꞌll akeꞌ nadaꞌ. Naꞌ leskaꞌ wayechj akeꞌ gon lwellj akeꞌ rao naꞌa beꞌnn kaꞌ llwie leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Naꞌ beꞌnn zan siyeꞌe akeꞌ ne akeꞌ: “Xtiꞌll Diosenꞌ llyixjweꞌraꞌ”, nench siyeꞌe akeꞌ beꞌnn zan. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Naꞌ ka naken ba llak da ke nxhia naꞌ, beꞌnn zanll beꞌnn kaꞌ yesoꞌn da xhinnjenꞌ, naꞌ wsan akeꞌ bill llieꞌ lwellj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Naꞌ noteze gonzidraꞌlle, naꞌ bi kwej yichjeꞌ danꞌ llonliraꞌlleꞌ nadaꞌn llinte gateꞌ, leꞌen yerá. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Naꞌ lljak beꞌnne doxhen yellrionꞌ, lljatixjweꞌ akreꞌ Diꞌll Wen naꞌ, nench nneze beꞌnnachenꞌ llayaꞌle wzenayeꞌ ke Dios, nench nnebieꞌ lo raꞌlldaꞌo akeꞌn, naꞌ kate ba bnneze beꞌnne llaꞌa do gateze, kanaꞌllenꞌ yeyoll yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Daniel beꞌnnenꞌ bdixjweꞌre xtiꞌll Diosenꞌ kanaꞌ, bzojeꞌ ke da zban kwis, danꞌ wxinnj latjenꞌ ganꞌ llonliraꞌll-llo Diosenꞌ. Naꞌ kat reꞌre ba bllin danꞌ ganꞌ zo yodaꞌo braonꞌ (beꞌnne llrabe da ni llayaꞌle chejnieꞌreꞌn), ");
INSERT INTO zpuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kanaꞌ beꞌnn llaꞌa ganꞌ nbane Judea, llayaꞌl wxhonnj akeꞌ lljakeꞌ do yaꞌ daꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Naꞌ beꞌnn dá do yichjo keꞌe, bi yeyetjeꞌ yetop xchinraze da de lo yoꞌ rilleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Naꞌ beꞌnn dá yiꞌxe, bi yeyeje rilleꞌ lljaxhieꞌ xharaꞌne. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Nyaꞌchraz naken ke noꞌr kaꞌ nna noaꞌ bdaꞌo, naꞌ noꞌr kaꞌ llwaꞌll bdaꞌo lo lla naꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lennabe rao Dios bi wxhonnjre kat llak zay, naꞌ rao lla nbaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Le waꞌt yel ziꞌ yel yaꞌ, ka bi nna gaꞌten rao yellrio ni, naꞌ yeyoll naꞌ, billbi gaꞌte ye to ka len. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Naꞌ chenak Xanllo Diosenꞌ bi yezaꞌcheꞌ llanꞌ gak kaꞌ, nono yerakze; zan wazaꞌcheꞌn, ni ke danꞌ nllieꞌreꞌ beꞌnn kaꞌ ba brejeꞌ llonliraꞌll Leꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Kanaꞌ chaꞌ no ye reꞌ: “Lewiá, ni zo Cristonꞌ beꞌnnenꞌ brej Diosenꞌ nnebieꞌ”, naꞌ “Lewiá, naꞌ zoeꞌ”, bi chejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Le chas beꞌnn wxhiyeꞌe, beꞌnn gakraꞌll akeꞌ wlan akeꞌ latj kiaꞌ ni, naꞌ gon akeꞌ ka beꞌnn lloeꞌ xtiꞌll Dios. Naꞌ gon akteꞌ yel wak da reꞌe beꞌnne, naꞌ billre da yebán akreꞌ, nench siyeꞌe akeꞌ leakeꞌ. Naꞌ rente beꞌnn kaꞌ ba brej Diosenꞌ nak Xhiꞌnneꞌ, yeꞌne beꞌnn wxhiyeꞌe kaꞌ siyeꞌe akeꞌ, chaꞌ gak siyeꞌe akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ba nnézere kanꞌ gaken, le bakze bdixjweꞌraꞌ reꞌ yeolol danꞌ gaken. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Naꞌ chaꞌ no ye reꞌ: “Latj dach naꞌ zo Cristonꞌ”, bi chejleꞌre, naꞌ chaꞌ ye akeꞌ reꞌ: “Zot Cristonꞌ lo yoꞌ naꞌ”, bi chejleꞌre ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kanꞌ llak kat llep yes llseniꞌn doxhen leꞌ yebánꞌ, lekze kaꞌn gak kat llin lla yedaꞌ da yobre, nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach yedaꞌ da yobre, naꞌ yeolol beꞌnne reꞌe akreꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ni llonen ka ke beꞌnnenꞌ ne: “Ganꞌ de ba wat naꞌn ll-llay chod kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Naꞌ kat yeyoll yel llzaꞌkziꞌ ke beꞌnnachenꞌ, willenꞌ yeyaken xchole, naꞌ beonꞌ bill wseniꞌn, naꞌ berj kaꞌ raꞌll aken leꞌ yebánꞌ, naꞌ yeolol da llreꞌllo leꞌ yebánꞌ, gak aken ka llak yellrionꞌ kat llxhoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kanaꞌll beꞌnn llaꞌa yellrionꞌ reꞌe akreꞌ nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, lliaꞌ radj bej ren yel wak xhen kiaꞌn ren yel beꞌnn zaꞌk kiaꞌn, naꞌ beꞌnn llaꞌa gateze yell kaꞌ zjallaꞌa rao yellrionꞌ kwell akeꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naꞌ katenꞌ yedaꞌn, kwell to trompet zillje, naꞌ llach angl kiaꞌ kaꞌ, yetop akeꞌ beꞌnn kaꞌ doxhente yellrio, beꞌnn kaꞌ ba brejaꞌ nak akeꞌ nadaꞌ txhen doxhente yellrio, naꞌ ga zeraoze nak ziꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Lewzenay ke wsaꞌkrebraꞌn ka to yay higo: Kate llagaꞌ xhlaꞌyenꞌ, llagaꞌn laꞌy lleꞌne, ba nnézere ba zo nez yeraꞌ yej. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Naꞌ leskaꞌ kat reꞌre ba llak da ke nxhia, kaꞌn ba bniaꞌ naꞌ, kanaꞌll nnézere ba zo rez yedaꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Da li niaꞌ reꞌ, beꞌnn kaꞌ llaꞌa nnaꞌ, nna nban akteꞌ kate sorao gak da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ka nak yebánꞌ ren yellrionꞌ wllin lla kat te ke, zan ka nak xtiꞌllaꞌn kere da te ke kaꞌzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Zan nono nneze bi llanꞌ, bi horenꞌ gak kaꞌ, ni angl kaꞌ niꞌt yebá naꞌ, ni nadaꞌ. Toze Xaꞌ Dios naꞌ nnezreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Kanꞌ gok ka llanꞌ bzo da Noénꞌ, kanꞌ gakse katenꞌ yedaꞌ nadaꞌ da yobre, nakaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Le kanꞌ gok kanꞌ za yerabj akeꞌ nisenꞌ, kanꞌ bzo da Noénꞌ, llaꞌa akeꞌ lleꞌj llao akeꞌ, naꞌ llchaynaꞌa akeꞌ lloeꞌ akeꞌ yel wachaynaꞌa ke no xhiꞌnn akeꞌ, nna llon akteꞌ kaꞌn bllin lla byoꞌ da Noénꞌ lo barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ni ke gokbeꞌe akzreꞌ binꞌ gak, ka gokll yejsiꞌo xhen naꞌ, naꞌ babia nisenꞌ, kanaꞌll gokbeꞌe akreꞌ. Lekze kaꞌn gakze kat yedaꞌ da yobre, kanaꞌllenꞌ yeyakbeꞌe akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kanaꞌn chop beꞌnn niꞌt yiꞌxe, toeꞌ yeziaꞌ naꞌ ye toeꞌ yekwaꞌnnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Naꞌ chop noꞌre ze llot akeꞌ, toeꞌ yeziaꞌ naꞌ ye toeꞌ yekwaꞌnnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ke len naꞌ lesó lekweze, le bi nnézere bi lla yaꞌnne yedaꞌ da yobre, nadaꞌn nakaꞌ Xanre. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Legón xhbab ke da ni, chaꞌ nneze xan yoꞌn do bi hor yaꞌnnenꞌ llin beꞌnn wan naꞌ rilleꞌn, naꞌ bi taskzeꞌ nench bi weꞌe latj choꞌ beꞌnnenꞌ rilleꞌn kwaneꞌ xchinrazeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ke len naꞌ, lesó lekweze batkrenꞌ yedaꞌ da yobre, le katenꞌ bi llonre xhbab yedaꞌ, kanaꞌn yedaꞌ nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Notezre chaꞌ zore rez batteze, nakre ka to beꞌnn wen llin beꞌnn nak beꞌnn siꞌn, naꞌ beꞌnn llon da llayaꞌl goneꞌ. Naꞌ chaꞌ to beꞌnn wen llin lloneꞌ wen kwis, naꞌll gon xaneꞌn rallneꞌe rilleꞌn, naꞌ weꞌe da yesaꞌo beꞌnn wen llin kaꞌ, kat llayaꞌl gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naꞌ chaꞌ beꞌnn wen llin keꞌen, llontezeꞌ kon kanꞌ goll xaneꞌn leꞌe, nbaraz soeꞌ kat yellín xaneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Diꞌll li niaꞌ reꞌ, xaneꞌn goneꞌ rallneꞌe yeolol da de keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Zan chaꞌ nakeꞌ beꞌnn wen llin xhawatraz, naꞌ goneꞌ xhbab neꞌe: “Ba ll-llere xanaꞌn, bi yeyedzeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Naꞌll soraweꞌ tilreneꞌ beꞌnn lwelljeꞌ kaꞌ, naꞌ yeꞌj gaoxeneꞌ ren nollre beꞌnn wazó. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Naꞌll yellín xaneꞌn to lla bi nnezreꞌ, naꞌ yedoꞌlreꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naꞌ danꞌ bi lloneꞌ wen naꞌ, xaneꞌn chintateꞌ leꞌe, naꞌ lljazoeꞌ leꞌe radj beꞌnn chop rao kaꞌ, gannaꞌ lljallell akeꞌ to gaoxoxj lay akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Leskaꞌ bne Jesúsenꞌ: —Nnaꞌ waꞌa diꞌll kanꞌ gak kat nnebiaꞌ Dios, beꞌnnenꞌ zo yebánꞌ, llonen rebze kanꞌ gok ke chi noꞌr weꞌo. Naꞌ zjanoꞌx akeꞌ twej da llseniꞌ ke akeꞌ, jakeꞌ jalexh akeꞌ yelloj beꞌnn byionꞌ llchaynaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naꞌ gaꞌy noꞌr kaꞌ bzaꞌa nak akeꞌ beꞌnn llejnieꞌ, naꞌ ye gaꞌye nak akeꞌ beꞌnn xhawatraz. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Noꞌr xhawatraz kaꞌ bi beꞌx akeꞌ lmet ceit da gonrén akeꞌ llin, kat yebill danꞌ yoll lo danꞌ llseniꞌ ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Naꞌ noꞌr kaꞌ llejnieꞌn, noꞌx akeꞌ da wseniꞌ ke akeꞌn, rente lmet ceit da gonrén akeꞌ llin, kat yebill danꞌ yoll lo danꞌ llseniꞌ ke akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Naꞌt blle wachaynaꞌn, naꞌ noꞌr kaꞌ brezenꞌ btas akeꞌ chak bez akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Naꞌ to beꞌnn bnneꞌe zillj, ka do llere lleꞌe leakeꞌ: “Ba llalloj wachaynaꞌn, lechoꞌo lljenrenlloeꞌ txhen.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ka golleꞌ leakeꞌ kaꞌ, yeolol noꞌr kaꞌ bazellaꞌ, naꞌll bayonchaꞌo akeꞌ danꞌ llseniꞌ ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Naꞌ noꞌr xhawatraz kaꞌ, lle akeꞌ beꞌnn ye gaꞌy kaꞌ: “¿Bi gonn raꞌt ceit kerénꞌ netoꞌ? Le ba llabill ketoꞌ ni.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Naꞌ noꞌr kaꞌ lle akeꞌ leakeꞌ: “Bi gak gonntoꞌn, le nxholl bi gaken ke yeolol-llo. Zan lelljaxiꞌn ganꞌ lloꞌteꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bixha noꞌr xhawatraz kaꞌ, jakeꞌ jaxiꞌi akeꞌ ceitenꞌ. Naꞌ chak zjakeꞌ naꞌle, ballín beꞌnn wachaynaꞌn, naꞌ noꞌr kaꞌ non xhnidenꞌ, bayoꞌrén akeꞌ leꞌe txhen ganꞌ llak lnninꞌ, naꞌ beꞌnn wen llin kaꞌ basej akteꞌ yoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ka ballín noꞌr kaꞌ bi ben xhnidenꞌ, jazé akeꞌ lloaꞌ yoꞌn, naꞌ llnne akeꞌ beꞌnn kaꞌ llaꞌa lo yoꞌn: “¡Beꞌnne, bsarje ganni choꞌtoꞌ!” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naꞌ leꞌen lleꞌe leakeꞌ: “Diꞌll li niaꞌ, bi wsarjaꞌ choꞌre le bi nombiaꞌ reꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Naꞌll lle Jesúsenꞌ beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ: —Kanꞌ llayaꞌl sore rez batenꞌ yednnebiaꞌ, le bi nnézere bi llanꞌ, naꞌ batenꞌ yedaꞌ yellrio ni da yobre, nadaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Yel llnebiaꞌ ke Diosenꞌ beꞌnnenꞌ zo yebánꞌ, llonen ka ke to beꞌnne byejeꞌ to yell ziꞌte. Naꞌ llanꞌ bzeꞌe naꞌ, goxheꞌ beꞌnn wen llin keꞌe kaꞌ, naꞌ bkwaꞌnneꞌ rallnaꞌa akeꞌ xhmelleꞌ da napeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Toeꞌ bkwaꞌnnreneꞌ leꞌe gaꞌy mellenꞌ nziꞌi talento. Naꞌ ye toeꞌ bkwaꞌnnreneꞌ leꞌe chop mellenꞌ. Naꞌ beꞌnnenꞌ ye to bkwaꞌnnreneꞌ leꞌe to mellenꞌ. Kon kanꞌ llwieꞌ llon totoeꞌ beꞌe leakeꞌ. Bayoll naꞌ bzeꞌe broeꞌ nez. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Naꞌ beꞌnnenꞌ bkwaꞌnnreneꞌ gaꞌy mell naꞌ, le bzoraoteꞌ llonreneꞌn llin, naꞌ beneꞌ gan lekze ye gaꞌyen. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lekze kaꞌ beꞌnnenꞌ bkwaꞌnnreneꞌ chop mellenꞌ, naꞌ beneꞌn gan ye chopen. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Naꞌ beꞌnnenꞌ beꞌe ye to mellenꞌ, byejeꞌ jakwaꞌcheꞌ xhmell xaneꞌn ga bcheꞌnneꞌ lo yo. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Gok scha kat ballín xan akeꞌn, naꞌll goxheꞌ leakeꞌ, nench naꞌ wannabeꞌ danꞌ bkwaꞌnneꞌ rallnaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naꞌ bllin beꞌnn wen llin keꞌe beꞌnnenꞌ bkwaꞌnnreneꞌ gaꞌy mellenꞌ, naꞌll lleꞌe leꞌe: “Xanaꞌ, ni de gaꞌy mellenꞌ bennoꞌ nadaꞌ, naꞌ ba benaꞌ gan ye gaꞌyen.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Naꞌ xaneꞌ naꞌ, lleꞌe leꞌe: “Ba benoꞌ da wen. Nakoꞌ beꞌnn wen llin wen, ba benoꞌ ka llayaꞌl gonoꞌ kone da daꞌon bkwaꞌnnrenaꞌ rweꞌn, ke len naꞌ, gonaꞌ rallnaꞌo da xhenlle. Byoꞌ nench sorenoꞌ nadaꞌ nbaraz.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Naꞌll ka bllin beꞌnnenꞌ bkwaꞌnnreneꞌ chop mellenꞌ, naꞌll lleꞌe leꞌe: “Xanaꞌ, ni de da chop mell danꞌ bkwaꞌnnoꞌn, naꞌ benaꞌ gan ye chopen.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naꞌll lleꞌe leꞌe: “Da wen benoꞌ nakoꞌ beꞌnn wen llin wen. Ba benoꞌ ka llayaꞌl gonoꞌ kone da daꞌon bkwaꞌnnrenaꞌ rweꞌn. Naꞌ nnaꞌ gonaꞌ rallnaꞌo da xhenlle, byoꞌ nench sorenoꞌ nadaꞌ nbaraz.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Naꞌ ka bllin beꞌnnenꞌ bkwaꞌnnreneꞌ to mellenꞌ, naꞌll lleꞌe xaneꞌn: “Ni de xhmelloꞌn bkwaꞌnnrenoꞌ nadaꞌn. Nnezraꞌ nakoꞌ to beꞌnn znia, naꞌ llarapoꞌ to ga goz beꞌnn yobre, naꞌ llatopoꞌ ga goz beꞌnn yob akre. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ke len naꞌ, jacheꞌnnaꞌ lo yo, naꞌ bkwaꞌchaꞌ xhmelloꞌn, le bllebaꞌ wnitaꞌn. Ganni de xhmelloꞌn, baziꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Naꞌll lle xaneꞌn leꞌe: “¡Beꞌnn wen llin ke nxhia, beꞌnn ria! Nnézteroꞌ llarapaꞌ ga goz beꞌnn yobre, naꞌ llatopaꞌ ga goz beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Naꞌ chaꞌ nnézteroꞌ kaꞌ, ¿bixchen ke brejoꞌ xhmellaꞌn beꞌnn yobre, nench yeziaꞌn, naꞌ ren yichje da gonen gan?” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Naꞌll golleꞌ beꞌnn wen llin kaꞌ yelaꞌ: “Leyekaꞌa mell danꞌ bkwaꞌnnrenaꞌ beꞌnn ni, naꞌ weꞌrén beꞌnnenꞌ ba noꞌx chi mell naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Le noteze beꞌnn gon wen kone danꞌ weꞌe xaneꞌn leꞌe, naꞌ xaneꞌn weꞌlleꞌ leꞌe da xhenlle. Naꞌ noteze beꞌnne bi llonreneꞌ llin danꞌ weꞌe xaneꞌn leꞌe naꞌ, xaneꞌn yekeꞌe da daꞌon beꞌe leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naꞌ ka nak beꞌnn wen llin ria ni, leyebejeꞌ lewzaꞌleꞌ ganꞌ nak xchole, naꞌ lljachelleꞌ naꞌ gaoxoxj layeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Katenꞌ yedaꞌ da yobre nadaꞌn Beꞌnnenꞌ Gorj Radj Beꞌnnach, nsaꞌa yel zaꞌk xhen kiaꞌn, naꞌ nchiaꞌ yeolol angl kiaꞌ kaꞌ, naꞌ kwiaꞌ gapaꞌ yel llnebiaꞌ xhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Naꞌ beꞌnn ke yeolol yell, yedop akeꞌ rawaꞌn. Naꞌ kat ba niꞌt yeololeꞌn, naꞌ sorao yelaꞌ akeꞌ, ka llon to beꞌnn gop xhiꞌre, kat llabejeꞌ to kere xhiꞌr kaꞌ, naꞌ kere chib kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Naꞌ beꞌnn kaꞌ nak ka xhiꞌr daꞌo, wniꞌt akeꞌ kwitaꞌn chlaꞌ chaꞌwe, naꞌ beꞌnn kaꞌ nak ka chiv, wniꞌt akeꞌ kwitaꞌn ye chlaꞌ rbese. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Naꞌ nadaꞌ nakaꞌ rey yepaꞌ beꞌnn kaꞌ niꞌt chlaꞌ chaꞌwenꞌ: “Ba ben Xaꞌ Diosenꞌ sore nbaraz, ledá ganni nench nnebiaꞌrenre nadaꞌ, kanꞌ ba nllia Diosenꞌ biaꞌa, kanꞌ bxhe yellrio naꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Le ka bdonaꞌ, bennre da bdawaꞌ; naꞌ wilraꞌ nis, naꞌ bennre da weꞌjaꞌ; naꞌ ka gokaꞌ beꞌnn ziꞌte, naꞌ brebre nadaꞌ rillre. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naꞌ ka bi de xharaꞌnaꞌ, naꞌ bennre da gokaꞌ; naꞌ ka gokaꞌ yillweꞌ, naꞌ badraꞌnnre nadaꞌ; naꞌ ka byoaꞌ rill ya, naꞌ badwiare nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Naꞌ beꞌnn wen kaꞌ ye akeꞌ nadaꞌ: “Xantoꞌ, ¿bat breꞌtoꞌ rweꞌ donoꞌ, naꞌ benntoꞌ da bdaoꞌ? Naꞌ ¿batenꞌ wilroꞌ naꞌ benntoꞌ da weꞌjoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naꞌ ¿batenꞌ gokoꞌ ka beꞌnn ziꞌte naꞌ brebtoꞌ rweꞌ rilltoꞌ? Naꞌ ¿batenꞌ breꞌtoꞌ rweꞌ bi de xharaꞌnoꞌ naꞌ benntoꞌ da gokoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naꞌ ¿batenꞌ gokoꞌ yillweꞌ naꞌ byoꞌ rill ya, naꞌ badwiatoꞌ rweꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Naꞌll yep akeꞌ: “Da li niaꞌ re, ka nak bayaꞌchraꞌllre beꞌnn lwelljre kaꞌ, le leakeꞌn nak akeꞌ ka biꞌchaꞌ, ka zanaꞌ, laꞌkze bibi zaꞌk aktekeꞌ rao beꞌnnach, nadkzaꞌn bayaꞌchraꞌllre.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Naꞌ beꞌnn kaꞌ niꞌt ye chlaꞌ rbesre, yep akeꞌ: “Lekwas kaꞌle, ba llia biaꞌa keré kweyiꞌre, lelljayak lo yiꞌ gabil, danꞌ bi llayolkze ganꞌ ba nak xhnid ke daxiꞌon ren angl ke kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Le ka bdonaꞌ, bi bennre da gawaꞌ, ka wilraꞌ, naꞌ bi bennre da yeꞌjaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka gokaꞌ beꞌnn ziꞌte, bi bennre ga tasaꞌ; ka bi de xharaꞌnaꞌ, bi bennre da gakaꞌ; ka gokaꞌ yillweꞌ, naꞌ ka byoaꞌ rill ya, bi badraꞌnnre nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Naꞌll nne akeꞌ: “Xantoꞌ, ¿batenꞌ bi bayaꞌchraꞌlltoꞌ rweꞌ, ka bdonoꞌ, naꞌ wilroꞌ, naꞌ gokoꞌ beꞌnn ziꞌt, naꞌ bi de xharaꞌnoꞌ naꞌ gokoꞌ yillweꞌ, naꞌ byoꞌ rill ya?” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naꞌll yep akeꞌ: “Da li niaꞌ reꞌ, danꞌ bi bayaꞌchraꞌllre beꞌnn lwelljre kaꞌ, laꞌkze bibi zaꞌk akeꞌ rao beꞌnnach, renkze nadaꞌn bi bayaꞌchraꞌllre.” ");
INSERT INTO zpuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Naꞌll saꞌkziꞌ beꞌnn wen da xhinnj kaꞌ ke chnare, naꞌ beꞌnn wen kaꞌ so akseꞌ nbaraz ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bayoll beꞌe Jesúsenꞌ diꞌll kaꞌ, golleꞌ beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ba nnézere ye chop llazenꞌ, llin gaꞌle lnni Paskw kellonꞌ. Naꞌ kanaꞌ gakaꞌ rao naꞌa beꞌnn kaꞌ, naꞌ wdaꞌa akeꞌ nadaꞌ leꞌ yay cruzenꞌ, nadaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naꞌll badop yeolol bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ ren beꞌnn gor brao kaꞌ llnebiaꞌ yell Israelenꞌ, ganꞌ zo rill bxoz braonꞌ, beꞌnnenꞌ re Caifás. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Llayirjlaꞌll akeꞌ akre gon akeꞌ siyeꞌe akeꞌ Jesúsenꞌ, nench goꞌx akeꞌ Leꞌe, naꞌ got akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Naꞌ llasné akeꞌ: —Bi goꞌxlloeꞌ rao lnni naꞌ, nench ke gakbeꞌe beꞌnn zan, naꞌ gon akeꞌ dá nne. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Naꞌ zo Jesúsenꞌ ganꞌ nziꞌi Betania, rill Simón beꞌnnenꞌ gok yillweꞌ danꞌ ne lepra. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Naꞌ chak lliꞌ Jesúsenꞌ llaweꞌ naꞌ, bllin to noꞌr noꞌxeꞌ to lmet da yoll ceit da laꞌ xhix, naꞌ zaꞌken da xhen. Naꞌ bwazjtiteꞌn yichj Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Naꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen, breꞌe akreꞌ kanꞌ ben noꞌrenꞌ, naꞌll gokllaꞌa akeꞌ bne akeꞌ: —¿Bixchen kon benditjereꞌ ceit xhix ni? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chenak beꞌtllon, naꞌ gaꞌt mell xhen chenake, naꞌ weꞌllon gakrenen beꞌnn yaꞌch. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesúsenꞌ benreꞌ kanꞌ bne beꞌnn kaꞌ, naꞌll lleꞌe leakeꞌ: —¿Bixchen nere kaꞌ ke noꞌrenꞌ? Da wen naꞌ beneꞌ kiaꞌ ganni. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Beꞌnn yaꞌch kaꞌ, niꞌt akseꞌ batteze niꞌtrén akeꞌ reꞌ, zan nadaꞌ bill zorenaꞌ reꞌ ye scha. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bwazjeꞌ nadaꞌ ceit xhixenꞌ, nench kat gaꞌchaꞌn, ba naktiaꞌ xhnid. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Diꞌll li niaꞌ reꞌ, doxhen yellrio do gateze lljatixjweꞌ beꞌnn Diꞌll Wen danꞌ llzejnieꞌ kiaꞌn, dekz de yene beꞌnn kaꞌ, kanꞌ ben noꞌr ni, nench lljadinraꞌll akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Naꞌ to beꞌnn chllinn kaꞌ, beꞌnnenꞌ nziꞌi Judas Iscariotenꞌ, byejeꞌ jawieꞌ bxoz wnebiaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naꞌ jelleꞌ leakeꞌ: —¿Bi gonnre nadaꞌ nench wdiaꞌ Jesúsenꞌ rao naꞌre? Naꞌll le beꞌe akteꞌ leꞌe chilloa (30) mell plat. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naꞌllenꞌ le bzoraote Judasenꞌ bayirjlaꞌlleꞌ akre goneꞌ, wdieꞌ Jesúsenꞌ rao naꞌa beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bllin lla nell llaꞌl lnni, katenꞌ llao akeꞌ yet xtir danꞌ bi nchix kwa binn, naꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen, jakeꞌ ganꞌ zoeꞌ, naꞌ lle akeꞌ Leꞌe: —¿Garenꞌ lleꞌnroꞌ lljasiniaꞌtoꞌ ganꞌ gaollo xcheꞌ ke Paskwnꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Naꞌll lle Jesúsenꞌ leakeꞌ: —Lelljak yellenꞌ, naꞌ leyé to beꞌnnenꞌ: “Maestronꞌ neꞌe, ba rez llin lla gak danꞌ llayaꞌl gak keꞌen, naꞌ rilloꞌ ni, lleꞌnreꞌ gaorentoeꞌ xcheꞌ lnni Paskwnꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Naꞌll ben beꞌnn kaꞌ kanꞌ goll Jesúsenꞌ leakeꞌn, naꞌ jasiniaꞌ akeꞌ ke lnni Paskwnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naꞌ ka ba llen willenꞌ, blleꞌrén Jesúsenꞌ beꞌnn chllinn kaꞌ non Leꞌe txhen naꞌ, naꞌ bdao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka lliꞌ akeꞌ llao akeꞌ naꞌ, lle Jesúsenꞌ leakeꞌ: —Diꞌll li niaꞌ reꞌ, to reꞌ wdere nadaꞌ rao naꞌa beꞌnn kaꞌ llwie nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Naꞌll gokyaꞌch akreꞌ ga zeraoze, naꞌ bzorao twej twej akeꞌ llnnab akreꞌ Leꞌe: —Xantoꞌ, ¿nadaꞌn gonaꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Naꞌll lleꞌe leakeꞌ: —To beꞌnnenꞌ llaorén nadaꞌ txhen toze yeꞌnne, leꞌen wde nadaꞌ rao naꞌa beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka nak nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, ka nyojkze kiaꞌn got akeꞌ nadaꞌ, zan ¡nyaꞌchraz naken ke beꞌnnenꞌ gon nadaꞌ rallnaꞌa beꞌnn kaꞌ! Wenre chenak bi bzokzeꞌ yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Naꞌ Judas beꞌnnenꞌ wde Jesúsenꞌ rao naꞌa beꞌnn kaꞌ, lleꞌe Leꞌe: —Maestro, ¿nadaꞌn wdiaꞌ rweꞌ rao naꞌa beꞌnn kaꞌ? Naꞌll lle Jesúsenꞌ leꞌe: —Awaꞌ, rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Naꞌ ka llao akeꞌ naꞌ, bxhiꞌi Jesúsenꞌ to yet xtir naꞌ, naꞌ bayoll beꞌe yel llioxken ke Dios naꞌ, bxhoxhjeꞌn, naꞌ beꞌen beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ, naꞌ lleꞌe leakeꞌ: —Lesiꞌn, legaon, da ninꞌ nake kwerp kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Naꞌll bxhieꞌ to leo daꞌo ganꞌ yoll xis uva, naꞌll beꞌe yel llioxken ke Dios, naꞌ beꞌen leakeꞌ, lleꞌe leakeꞌ: —Yeololre, leyeꞌj raꞌt weje danꞌ yoll lo leo ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Da ninꞌ xchenaꞌ, naꞌ larjen ni ke doꞌl xhia ke beꞌnnach. Naꞌ larjen nench sorao gak da kobenꞌ, danꞌ bcheb Diosenꞌ goneꞌ gakreneꞌ beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Naꞌ niaꞌ reꞌ, bill yeꞌjaꞌ xis uvanꞌ, llinte lla kat ba zollo txhen ganꞌ zo Xaꞌ Diosenꞌ llnebieꞌ, kanaꞌll yeyeꞌjaꞌn da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bayoll bel akeꞌ ben akeꞌ xhen Diosenꞌ, naꞌll bzaꞌa akeꞌ jakeꞌ rao yaꞌ ganꞌ nziꞌi Yaꞌ Olivos. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Naꞌ lle Jesúsenꞌ leakeꞌ: —Nnaꞌ lleꞌ, yeololre gakgánere kanꞌ gak kiaꞌn. Le nyojkzen leꞌ xtiꞌll Diosenꞌ llian: “Gotaꞌ beꞌnn gop xhiꞌrenꞌ, naꞌ xhiꞌr kaꞌ gaslas akbaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Naꞌ kate yesbán Diosenꞌ nadaꞌ radj beꞌnn wat kaꞌ, wyobll yellinaꞌ nadaꞌ Galileanꞌ ka reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naꞌll lle Pedronꞌ Leꞌe: —Laꞌkze yeolol beꞌnn ki wsanraꞌll akeꞌ rweꞌ, zan nadaꞌ bi wsanraꞌllkzaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Naꞌ lle Jesúsenꞌ leꞌe: —Diꞌll li kwis niaꞌ rweꞌ, ka za kwellre lekwnꞌ nnaꞌ lleꞌ, chonn ras ba gok bi wcheboꞌ chaꞌ nombiaꞌo nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naꞌll Pedronꞌ lleꞌe Leꞌe: —Laꞌkze chaꞌ gatrenaꞌ rweꞌ, kbat nniaꞌ bi nombiaꞌ rweꞌ. Naꞌ lekze kaꞌ goll beꞌnn kaꞌ yelaꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Naꞌll bllin akeꞌ ganꞌ nziꞌi Getsemaní, naꞌ lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Gannize lekweꞌ, chak chaꞌa nadaꞌ gannaꞌte, yelwillaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Naꞌll bcheꞌe Pedronꞌ ren ye chop xhiꞌnn Zebedeo, bi kaꞌ nziꞌi Jacobo ren Juan. Naꞌ Jesúsenꞌ bzorao llakyaꞌchreꞌ kwis. Naꞌll billbi wen bzokzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Naꞌll lleꞌe leakeꞌ: —Lo yichjraꞌlldaꞌwaꞌ ni, llakyaꞌchraꞌ kwis, llakraꞌ kon gatkzaꞌ katekenꞌ llallayrawaꞌ ni. Naꞌ nize leyegaꞌnne, lewnnaꞌ ren nadaꞌ yere bi tasre. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naꞌll blliaraweꞌ ye raꞌte, naꞌll jeꞌteꞌ rao yonꞌ slloaꞌre, naꞌll balwilleꞌ Diosenꞌ, bneꞌe: —Xa, chaꞌ wak ten kaꞌze, benchga bi saꞌkziaꞌ, naꞌ bi gak kiaꞌ kanꞌ ba zo gak naꞌ. Zan bi llnnabaꞌ gak da nniaꞌ nadaꞌ, kon kaꞌ neꞌo rweꞌn gakchga. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Naꞌll bayejeꞌ ganꞌ zjalliꞌ beꞌnn kaꞌ chonne, naꞌ jadiꞌreꞌ tas beꞌnn kaꞌ. Naꞌ lleꞌe Pedronꞌ: —¿Ni choll daꞌo bi gok wnnaꞌrenre nadaꞌ yere? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bi tasre, lewalwill Dios nench ke gon da xhinnjenꞌ reꞌ gan. Nnezraꞌ lo yichjraꞌlldaꞌorenꞌ lleꞌnere wnnaꞌrenre nadaꞌ yere, naꞌ kwerp kerénꞌ bi zoen. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naꞌll bzeꞌe da wllop ras ganꞌ zjalliꞌ akeꞌn naꞌ jalwilleꞌ Diosenꞌ, bneꞌe: —Xa, chaꞌ gak ten kaꞌze, benchga nench bi saꞌkziaꞌ, naꞌ gakchga kon kanꞌ neꞌo rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Naꞌll bayejeꞌ ganꞌ lliꞌ beꞌnn kaꞌ da yobre, naꞌ jadiꞌreꞌ tas akeꞌ lliachaꞌ bichgalenꞌ koꞌll rao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naꞌ bzeꞌe da yobre ganꞌ lliꞌ akeꞌn jalwilleꞌ Dios da wyonn ras, naꞌ bneꞌe kanꞌ ba bnekzeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Naꞌll ballineꞌ da yobre ganꞌ zjalliꞌ beꞌnn chonn kaꞌ, naꞌll lleꞌe leakeꞌ: —¡Letas, lewaziꞌraꞌll! Ba bllin lla, nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, gakaꞌ rallnaꞌa beꞌnn wen da xhinnj kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Lewayas, lewayoꞌo! Ba zaꞌa beꞌnnenꞌ gon nadaꞌ rao naꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nna lloeꞌte Jesúsenꞌ diꞌll kaꞌ, kat bllinkze Judasenꞌ, beꞌnnenꞌ gok txhen ren beꞌnn chllinn kaꞌ. Naꞌ ncheꞌe beꞌnn zan kwis zjanoꞌx akeꞌ no yay, no spad, beꞌnn bseꞌl bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn gor brao kaꞌ llnebiaꞌ yell Israelenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Naꞌ Judas beꞌnnenꞌ bde Leꞌe rao naꞌa beꞌnn kaꞌ, golleꞌ leakeꞌ akrenꞌ goneꞌ wroeꞌreꞌ nonꞌ goꞌx akeꞌ, naꞌ bneꞌe: —Beꞌnnenꞌ wnoꞌpaꞌ naꞌ, lekzeꞌn Jesúsenꞌ, naꞌ le goꞌxtereꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Naꞌll le jabiꞌyteꞌ kwit Jesúsenꞌ, lleꞌe Leꞌe: —Padiox, Maestro. Naꞌ le bnoꞌpteꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Naꞌ Jesúsenꞌ lleꞌe Leꞌe: —Beꞌnn nllieꞌraꞌ, ¿bi ken zaꞌo ganni? Naꞌll le jabiꞌyte beꞌnn zan kaꞌ, beꞌx akeꞌ Jesúsenꞌ, naꞌll le bcheꞌe akteꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Naꞌ to beꞌnn nak Jesúsenꞌ txhen, le brejte spad keꞌen, bdineꞌn beꞌnnenꞌ nak beꞌnn wen llin ke bxoz braonꞌ, bchoyteꞌ chlaꞌ nayeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naꞌll lle Jesúsenꞌ leꞌe: —Bagoꞌ spad koꞌon lo rille, le beꞌnn goteꞌ beꞌnn kone spad naꞌ, lekze len goten leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Bi nnezroꞌ wakse nnabraꞌ Xaꞌn, wseꞌleꞌ angl zan kwis beꞌnn gakrén nadaꞌ chenake? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Zan chaꞌ kaꞌ gonaꞌ, ¿akxha gak danꞌ llayaꞌl gaken danꞌ nyoj xtiꞌll Diosenꞌ nen kinꞌ gak? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naꞌll lle Jesúsenꞌ beꞌnn kaꞌ zjeꞌx Leꞌen: —¿Bixchen nonre nadaꞌ ka to beꞌnn wan, naꞌ zaꞌre zadxiꞌre nadaꞌ kone spad naꞌ ren yay? Renchaꞌ yeo lla blleꞌkzaꞌ lo yodaꞌo braonꞌ, bzejnieꞌraꞌ beꞌnne llaꞌa naꞌ, naꞌ bi beꞌxre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naꞌ danꞌ llak ki, llzoa diꞌll kanꞌ nyoj xtiꞌll Diosenꞌ, danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Dios kanaꞌ. Naꞌll yeolol beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ, bxhonnj akeꞌ brej yichj akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Naꞌ beꞌnn kaꞌ beꞌx Jesúsenꞌ, bcheꞌe akeꞌ Leꞌe rao Caifás, beꞌnnenꞌ nake bxoz brao, ganꞌ ba ndop beꞌnn gor brao kaꞌ llnebiaꞌ yell naꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Naꞌ Pedronꞌ naweꞌ ziꞌt ziꞌtre, bllinteꞌ rill bxoz brao naꞌ, naꞌ byoeꞌ naꞌ bllieꞌ liaꞌ naꞌze ren beꞌnn kaꞌ llap yodaꞌo brao naꞌ, le gokraꞌlleꞌ reꞌreꞌ akrenꞌ gak ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Naꞌ yeolol bxoz wnebiaꞌ kaꞌ, naꞌ yezikre beꞌnn gor brao kaꞌ llnebiaꞌ yell naꞌ, llayirjlaꞌll akeꞌ bi diꞌll wenraꞌllenꞌ wxoa akeꞌ koꞌll Jesúsenꞌ, nench got beꞌnn kaꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Naꞌ gok scha, bi ballel akereꞌ billre wlliayiꞌll akeꞌ Leꞌe, laꞌkze beꞌnn zan llaꞌa lloeꞌ akeꞌ diꞌll wenraꞌllenꞌ. Llakte kaꞌn bllin chop beꞌnn wxhiyeꞌe ake, bxoa akeꞌ doꞌl koꞌll Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Naꞌ bne akeꞌ: —Beꞌnn ni bneꞌe: “Nadaꞌ wachinnjaꞌ yodaꞌo brao ke Diosenꞌ, naꞌ chonn llaze wayontiaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Naꞌll bzollaꞌa bxoz braonꞌ, lleꞌe Jesúsenꞌ: —¿Bibi de nneꞌo, ka nak danꞌ ll-lliayiꞌll beꞌnn ki rweꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bibi bnekze Jesúsenꞌ. Naꞌll lle bxoz braonꞌ Leꞌe: —Dios naꞌ llzoaꞌ, bnne netoꞌ, chaꞌ da linꞌ nakoꞌ Cristo beꞌnnenꞌ nak Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsenꞌ lleꞌe leꞌe: —Naksen kanꞌ nere, leskaꞌ niaꞌ reꞌ, wllin lla reꞌre nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, lliaꞌ kwit Diosenꞌ beꞌnnenꞌ nape le zerawe yel wak xhen, naꞌ nnebiaꞌreneꞌ, naꞌ reꞌre yetjaꞌ leꞌ yebánꞌ radj bejenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ka bene bxoz braonꞌ xtiꞌll Jesúsenꞌ, le bcheꞌzte xheꞌen, nench broeꞌreꞌ da xhinnj kwisenꞌ bne Jesúsenꞌ kaꞌ. Naꞌll bneꞌe: —Nnaꞌ ba bénere kanꞌ bnneꞌe ke Diosenꞌ, nnaꞌ nollno yálljello gao xhia keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Akxha nere keꞌe nnaꞌ? Naꞌll balliꞌi beꞌnn kaꞌ xtiꞌlleꞌn ne akeꞌ: —Llayaꞌl gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naꞌll blliꞌ akeꞌ xheꞌn lloaꞌ raweꞌn, naꞌ braꞌll akeꞌ Leꞌe, naꞌ baleꞌ broꞌ akeꞌ ke xaꞌye. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Naꞌll lle akeꞌ Leꞌe: —Chaꞌ rweꞌn nakoꞌ Cristo, banneyaꞌchk, ¿nonꞌ braꞌll rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Naꞌ lliꞌ Pedronꞌ liaꞌre, ka bllinkze to noꞌr wen llin ke Caifásenꞌ, naꞌ golleꞌ leꞌe: —Renkze rweꞌn nakoꞌ Jesúsenꞌ txhen, beꞌnn Galilea naꞌ, ke. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Naꞌll bi bcheb Pedronꞌ rao yeolol beꞌnn kaꞌ zjallaꞌa naꞌ, chaꞌ nakeꞌ Jesúsenꞌ txhen, naꞌll lleꞌe noꞌrenꞌ: —Bi nnezraꞌ bi diꞌllenꞌ lloeꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Naꞌll le llallojte Pedronꞌ lloaꞌ yoꞌn, ka breꞌe ye to noꞌr wen llin naꞌ leꞌe, naꞌll lleꞌe beꞌnn kaꞌ llaꞌa naꞌ: —Renkze beꞌnn ninꞌ nakeꞌ txhen Jesús beꞌnn Nazaretenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Naꞌ da yobre bi bchebeꞌ chaꞌ nakeꞌ txhen Jesúsenꞌ. Naꞌll bneꞌe: —Dios naꞌ llzoaꞌ, gak bi da gak kiaꞌ, chaꞌ ziyaꞌ danꞌ niaꞌ bi nombiaꞌ beꞌnnenꞌ neꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Naꞌll gokse ye choll, ka zjak beꞌnn kaꞌ llaꞌa naꞌ, lle akeꞌ Pedronꞌ: —Da lijekzenꞌ, nakoꞌ beꞌnn kaꞌ txhen, le nakbieꞌze nneꞌo kanꞌ nne beꞌnn Galilea kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Naꞌ Pedronꞌ bzorao biteze bneꞌe, naꞌ leskaꞌ bneꞌe: —Diosenꞌ goneꞌ ga saꞌkziaꞌ chaꞌ ziyaꞌ danꞌ niaꞌ bi nombiaꞌ beꞌnn naꞌ. Kat le bllellte lekwnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Naꞌll jadinraꞌll Pedronꞌ kanꞌ goll Jesúsenꞌ leꞌe: “Ka za kwellre lekwnꞌ, chonn ras ba gok bi wcheboꞌ chaꞌ nombiaꞌo nadaꞌ.” Naꞌll bazeꞌe, naꞌ jallell-loljeꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ka byeniꞌ naꞌ, badope yeolol bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn gor wnebiaꞌ kaꞌ llnebiaꞌ yell Israelenꞌ, naꞌ bchoy akeꞌn got akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Naꞌ bchej akeꞌ Leꞌe, naꞌll jwaꞌa akeꞌ Leꞌe rao beꞌnnenꞌ llnebiaꞌn nziꞌi Poncio Pilato. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas beꞌnnenꞌ ben Jesúsenꞌ rao naꞌa beꞌnn kaꞌ, ka gokbeꞌreꞌ ba bchoybiaꞌ akeꞌ ke Jesúsenꞌ got akeꞌ Leꞌe, naꞌll bayatreꞌ kwis danꞌ beneꞌ Leꞌe rao naꞌa bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn gor brao kaꞌ. Naꞌll byejeꞌ rao akeꞌn, naꞌ bayoeꞌ leakeꞌ chilloa (30) mell platenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Naꞌ lleꞌe leakeꞌ: —Da xhinnjenꞌ benaꞌ, benaꞌ rallnaꞌre to beꞌnn bibi doꞌl napeꞌ. Naꞌll lle akeꞌ leꞌe: —Bibi doꞌl nap netoꞌ kanꞌ benoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naꞌll le bzaꞌlte Judasenꞌ mell kaꞌ lo yodaꞌo braonꞌ, le bazaꞌteꞌ zayejeꞌ, naꞌ jaroꞌ do yeneꞌ bayot kwineꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Naꞌll bxoz wnebiaꞌ kaꞌ le batop akteꞌ mellenꞌ, naꞌll lle lwellj akeꞌ: —Bi gak koꞌllonꞌ ganꞌ yoꞌ mell ke yodaꞌon, le naken mell danꞌ bdixhjllo yegaꞌa yel nban ke to beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Naꞌll ben akeꞌ diꞌll yeziꞌi akeꞌ to yellrio ke to beꞌnn wen yeꞌse ren mell naꞌ, naꞌ gaken to latj ga wkwaꞌch akeꞌ beꞌnn ziꞌt ake. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ke len naꞌ yellrio naꞌ, nziꞌi Yellrio Llen, naꞌ nna nziꞌten kaꞌ nnaꞌ lla. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kanꞌ gok nench gok kanꞌ bzoj da Jeremías, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, ganꞌ nen: “Bxhiꞌi akeꞌ chilloa mell plat, danꞌ ne beꞌnn Israel kaꞌ, zaꞌk to beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Naꞌ baziꞌi akeꞌ yellrio ke to beꞌnn wen yeꞌse, kanꞌ bne Xanllo Diosenꞌ nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ka bllin Jesúsenꞌ rao beꞌnnenꞌ llnebiaꞌn, naꞌll lleꞌe Leꞌe: —¿Rweꞌn nakoꞌ rey ke beꞌnn Israel kaꞌ? Naꞌll balliꞌi Jesúsenꞌ xtiꞌlleꞌn, bneꞌe: —Kanꞌ bnekzoꞌ naꞌ nakaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Naꞌll ll-lliayiꞌll bxoz wnebiaꞌ kaꞌ Leꞌe, ren beꞌnn gor brao kaꞌ llnebiaꞌ naꞌ. Naꞌ bibi bnekzeꞌ chras. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Naꞌll lle Pilatonꞌ Leꞌe: —¿Bi llenroꞌ katek xhia zan naꞌ, llwakw akeꞌ koꞌlloꞌ ni? ");
INSERT INTO zpuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Naꞌ ni to xtiꞌlleꞌn bi balliꞌkze Jesúsenꞌ, naꞌll babane Pilatonꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naꞌ de to da llon beꞌnn kaꞌ, katenꞌ llaꞌl lnni paskwnꞌ, yesán beꞌnnenꞌ llnebiaꞌn to beꞌnn yoꞌ rill ya, kat llaꞌl lnni Paskwnꞌ, kon beꞌnn nnab beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naꞌ lo rill ya naꞌ, yoꞌ to beꞌnne llze ke kwis, nakeꞌ beꞌnn wen da xhinnj, naꞌ reꞌe Barrabás. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naꞌ lle Pilatonꞌ beꞌnn kaꞌ ndopenꞌ: —¿Nore beꞌnn ki lleꞌnere wasanaꞌ? ¿Wasanaꞌ Barrabás naꞌ, chaꞌ Jesús naꞌ, beꞌnnenꞌ ne akeꞌ nakeꞌ Cristo? ");
INSERT INTO zpuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Le gokbeꞌe Pilatonꞌ llaxhéꞌ bxoz wnebiaꞌ kaꞌ Jesúsenꞌ, naꞌllenꞌ ben akeꞌ Leꞌe rao neꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Naꞌ ka lliꞌ Pilatonꞌ ganꞌ lloneꞌ yel koxchis naꞌ, le bllinte to rson da bseꞌl noꞌr keꞌen, lleꞌe leꞌe: “Bitbi gonroꞌ beꞌnnenꞌ, le bibi doꞌl napeꞌ. Le bllayrawaꞌ ncheꞌe, naꞌ rao bichgal kiaꞌn breꞌdaꞌoraꞌ Leꞌe.” ");
INSERT INTO zpuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn gor brao kaꞌ llnebiaꞌ naꞌ, ba bkoꞌyel akreꞌ beꞌnn kaꞌ llaꞌa naꞌ, nench nnab akeꞌ wsaneꞌ Barrabás naꞌ, naꞌ nnab akeꞌ gat Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Naꞌll lle Pilatonꞌ leakeꞌ da yobre: —¿Nore beꞌnn ki chop lleꞌnere wasanaꞌ? Naꞌll ne akeꞌ: —Barrabás naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatonꞌ lleꞌe leakeꞌ: —¿Akxha gonaꞌ Jesúsenꞌ beꞌnnenꞌ ne akeꞌ Cristonꞌ? Naꞌ yeololeꞌ bne akeꞌ: —¡Bdeꞌe leꞌ yay cruz! ");
INSERT INTO zpuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naꞌll lle Pilatonꞌ leakeꞌ: —¿Bixha da xhinnj ba beneꞌ naꞌ? Naꞌll besiaꞌ akeꞌ da yobre ne akeꞌ: —¡Bdeꞌe leꞌ yay cruz! ");
INSERT INTO zpuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gokbeꞌe Pilatonꞌ bikzbi de goneꞌ. Ba llaꞌa beꞌnn kaꞌ llakia kwis, naꞌll bseꞌleꞌ to beꞌnn jaxieꞌ nis, baneꞌe rao beꞌnn kaꞌ llaꞌa naꞌ, lleꞌe leakeꞌ: —Beꞌnn ni bibi da xhinnj noneꞌ. Bi naken xhbaꞌyaꞌ chaꞌ ba betreꞌ, xhbaꞌy reꞌ naken chaꞌ ba betreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yeolol beꞌnn zan kaꞌ bne akeꞌ: —Kere bi gon danꞌ gaken xhbaꞌytoꞌ, naꞌ xhbaꞌy no xhiꞌnntoꞌ ke nake yel got ke beꞌnn ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Naꞌll basán Pilatonꞌ Barrabásenꞌ kanꞌ bnnab beꞌnn kaꞌ. Bayoll naꞌ, naꞌll golleꞌ beꞌnn wakaꞌa ya kaꞌ, bdintat akeꞌ Jesúsenꞌ, naꞌll beneꞌ Leꞌe rao naꞌa akeꞌn, nench wdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naꞌll bcheꞌe wakaꞌa ya kaꞌ Leꞌe lo yoꞌ ke beꞌnnenꞌ llnebiaꞌn, naꞌ batop akeꞌ yeolol wakaꞌa ya kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naꞌll bdinn akeꞌ xharaꞌneꞌn, naꞌ bwakw akeꞌ Leꞌe to raꞌll xhna, ka danꞌ llak rey kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Naꞌll ben akeꞌ to da nak de lba yeꞌche, naꞌ bliz akeꞌn yichjeꞌn, naꞌ neꞌe chaꞌwenꞌ bgoꞌx akeꞌ Leꞌe to xhis. Naꞌll bcheꞌk xhib akeꞌ raweꞌn, nench btitj akreꞌ Leꞌe, naꞌ ne akeꞌ: —¡Sechga ke beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Naꞌll blliꞌ akeꞌ Leꞌe xheꞌn, naꞌll bakaꞌa akeꞌ xhisenꞌ noꞌxeꞌn, naꞌll bdin akeꞌn yichjeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bayoll btitj akreꞌ Leꞌen, bakaꞌa akeꞌ raꞌll xhnanꞌ danꞌ bwakw akeꞌ Leꞌen, naꞌll bawakw akeꞌ Leꞌe xhakzeꞌ. Naꞌll bcheꞌe akeꞌ Leꞌe jadaꞌa akeꞌ Leꞌe leꞌ yay cruz. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Naꞌll ka blloj akeꞌ yell naꞌ, le badil akteꞌ to beꞌnn Cirene re Simón, naꞌ bchieꞌ akreꞌ leꞌe weꞌe cruz ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naꞌ bllin akeꞌ to latj ganꞌ nziꞌi Gólgota, lleꞌnen nen latj ke llit wat. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Naꞌll beꞌe akeꞌ Jesúsenꞌ zo zichj da nchixe to da zlaꞌ yeꞌjeꞌn, naꞌ ka gokbeꞌreꞌ kanꞌ naken naꞌ, naꞌ bi weꞌjeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naꞌ ka bayoll bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ, naꞌll bditjen akeꞌ xharaꞌneꞌn, llwia akeꞌ naraꞌchk norenꞌ llayaꞌl toto akeꞌ. Naꞌ danꞌ ben akeꞌ kaꞌ, bzoa diꞌll kanꞌ bzoj beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, bneꞌe: “Wlaꞌa akeꞌ xharaꞌneꞌn, naꞌ siꞌi ke ke akeꞌ chitje akreꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Naꞌll blleꞌ akeꞌ bdap akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naꞌ yichj cruzenꞌ ganꞌ deꞌe naꞌ, bzoj akeꞌ danꞌ blliayiꞌll akeꞌ Leꞌe, naꞌ llian: “Beꞌnn ni Jesúsenꞌ rey ke beꞌnn Israel kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Naꞌ lekze kaꞌ, bdaꞌa akeꞌ ye chop beꞌnn wan chlaꞌ weje kwiteꞌn, toeꞌ chaꞌwe ye toeꞌ rbese. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Naꞌ beꞌnn kaꞌ bde ganꞌ deꞌe naꞌ, llta yichj akeꞌ goll akeꞌ Leꞌe diꞌll yel yaꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bne akeꞌ: —Rweꞌn bneꞌo yechinnjoꞌ yodaꞌo braonꞌ, naꞌ chonn llaze yeyonteꞌon. Naꞌ basrachk kwinoꞌ chaꞌ rweꞌn nakoꞌ dogarje Xhiꞌnn Dios, bayetjchek leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ ren beꞌnn fariseo kaꞌ, naꞌ beꞌnn gor brao kaꞌ llnebiaꞌ, yeololeꞌ bne akeꞌ diꞌll yel yaꞌ bne akeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—¡Beꞌnn zan basreꞌe, naꞌ nnaꞌ bi llak yesrá kwineꞌ! Chaꞌ nakeꞌ rey ke lliꞌo beꞌnn Israel, yeyetjeꞌ leꞌ yay cruz ganꞌ deꞌe naꞌ, naꞌll chejleꞌllo keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Leꞌe llonliraꞌlleꞌ Dios, le bneꞌe: “Dogarje Xhiꞌnn Dios nadaꞌ.” ¡Naꞌ reꞌchekello yesrá Diosenꞌ Leꞌe nnaꞌ, chaꞌ llakreꞌ Leꞌe! ");
INSERT INTO zpuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naꞌ beꞌnn wan kaꞌ zjadaꞌa leꞌ yay cruzenꞌ chlaꞌ weje kwiteꞌn, leskaꞌ bchachrén akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Naꞌ ka do wawill, doxhente yellrionꞌ bachole bllinte lladá chonne. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naꞌ ka lladá chonne naꞌ, besiaꞌ Jesúsenꞌ zillje bneꞌe: —Elí Elí, ¿lama sabactani? (Lleꞌnen nen: Dios kiaꞌ, Dios kiaꞌ, ¿bixchen ba bsanraꞌlloꞌ nadaꞌ?) ");
INSERT INTO zpuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Naꞌ bal beꞌnn kaꞌ zjazé naꞌ, ne akeꞌ: —Lewzenay keꞌe, beꞌnn ni llalwilleꞌ da Elías beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Naꞌll le bllojte to beꞌnn zejdoeꞌ jaxieꞌ to xhiꞌre, naꞌ bzaꞌlleꞌn zo zichjenꞌ da nak zlaꞌn, naꞌ bzoeꞌn to rao xhis tonne, naꞌll jazoeꞌn lloaꞌ Jesúsenꞌ nench xoꞌpeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Naꞌ ye baleꞌ lle lwellj akeꞌ: —Dokwezchek, chaꞌ ke yed Elíasenꞌ yedsreꞌe Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Naꞌll le besiaꞌte Jesúsenꞌ da yobre zillj kwis, naꞌ le bayonteꞌ spíritu keꞌen rallnaꞌa Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naꞌ ka hor naꞌ, blleꞌz kllole raꞌll danꞌ ze lo yodaꞌo braonꞌ, bxhiꞌzen yichje ballinte lleꞌle, naꞌ llebraz bxhoꞌ, goxhjte yej ake. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naꞌ leskaꞌ byarj ba ke beꞌnn ba got. Naꞌ zan beꞌnn kaꞌ benliraꞌll Diosenꞌ, babán akeꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Naꞌ bde naꞌ, ka babán Jesúsenꞌ radj beꞌnn wat kaꞌ, balloj akeꞌ lo ba ke akeꞌn, naꞌll jayakeꞌ jaroeꞌrao akeꞌ Jerusalén. Naꞌ zan beꞌnn breꞌe leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Naꞌ xan wakaꞌa ya kaꞌ, naꞌ ren beꞌnn kaꞌ llaꞌa llap Jesúsenꞌ, ka nak breꞌe akreꞌ bxhoꞌn, naꞌ biteze gok, naꞌ blleb akeꞌ kwis, naꞌ ne akeꞌ: —Da likze beꞌnn ni, nakeꞌ dogarj Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Leskaꞌ naꞌ zjallaꞌa zan noꞌr ak, zjazé akeꞌ ziꞌtre llwia akeꞌ. Beꞌnn kaꞌ bnao Jesúsenꞌ, ka bazeꞌe Galilea naꞌte llakrén akeꞌ Leꞌe bi da byalljreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Naꞌ ren María Magdalena, naꞌ ren María beꞌnnenꞌ nak xhnaꞌ Jacobo, naꞌ José, naꞌ ren María xhoꞌr Zebedeo. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ka betj lleꞌ naꞌ, bed to beꞌnn wniaꞌ beꞌnn Arimatea re José, naꞌ leskaꞌ bzenayeꞌ ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josénꞌ byejeꞌ rao Pilatonꞌ jannabeꞌ kwerp ke Jesúsenꞌ, naꞌ Pilatonꞌ bayoeꞌ kwerp ke Jesúsenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Naꞌll baziꞌi Josénꞌ kwerp ke Jesúsenꞌ, naꞌll baraꞌlleꞌ Leꞌe to raꞌll xhen raꞌll yalle. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Naꞌ broeꞌ kwerp keꞌen to lo broj keꞌe, da bcheꞌnneꞌ leꞌ yej. Naꞌll btoleꞌ to yej xhen lloaꞌ brojenꞌ, nench basejen len, naꞌll bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Naꞌ María Magdalenanꞌ, naꞌ ye to María beꞌnn yobre, jacheꞌ akeꞌ lloaꞌ brojenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Naꞌ bateyó, bde lla kanꞌ llsiniaꞌ akeꞌ ke lla nbaꞌnn, badop bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn fariseo kaꞌ jakeꞌ ganꞌ zo Pilatonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Naꞌ lle akeꞌ leꞌe: —Ba jadinraꞌlltoꞌ kanꞌ bne da beꞌnn wxhiyeꞌn gotenꞌ, kanꞌ nna nbaneꞌ: “Yeyónn lla naꞌ, yebanaꞌ radj beꞌnn wat kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ke len naꞌ bseꞌlchek beꞌnn lljatap akeꞌ lloaꞌ brojenꞌ ganꞌ jakwaꞌch akeꞌ Leꞌe naꞌ, nench ke lljak beꞌnn kaꞌ gok leꞌe txhen tlleꞌlre lljarej akeꞌ kwerp keꞌen, naꞌ ye akeꞌ beꞌnn ak, babaneꞌ radj beꞌnn wat kaꞌ, naꞌ da ke nxhiall gak, kerke diꞌll danꞌ bdise da nell, kanꞌ bneꞌe Diosenꞌ bseꞌle Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naꞌll goll Pilatonꞌ beꞌnn kaꞌ: —Gonnaꞌ reꞌ wakaꞌa ya ak, lewcheꞌe akeꞌ nench gap akeꞌ ga zeraoze yezoe akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naꞌll byej akeꞌ ren wakaꞌa ya kaꞌ, naꞌ bchiꞌch akeꞌ sey leꞌ yej, danꞌ daꞌa lloaꞌ brojenꞌ, naꞌ bkwaꞌnn akeꞌ wakaꞌa ya kaꞌ bdap akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ka bde lla nbaꞌnne, bal dmionꞌ María Magdalena ren María beꞌnnenꞌ ye to, byej akeꞌ jawiá akeꞌ ganꞌ bkwaꞌch akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naꞌ le bxhoꞌte, le to angl ke Xanllonꞌ betjeꞌ yebánꞌ, naꞌ bllineꞌ bkeꞌe yej danꞌ nsej lloaꞌ brojenꞌ, naꞌ bllieꞌ rao yejenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Llaktit kwis nake lloaꞌraweꞌn, kaꞌkze ga llep yes, naꞌ xharaꞌneꞌn naken llich kwis ka beye. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naꞌ ka breꞌe beꞌnn kaꞌ llapenꞌ, to bxhiz akzeꞌ blleb akeꞌ bacholraꞌll akteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naꞌ anglenꞌ lleꞌe noꞌr kaꞌ: —Bi llebre, nadaꞌ nnezraꞌ llayirjre Jesúsenꞌ, beꞌnnenꞌ bdaꞌa akeꞌ leꞌ yay cruz naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nollno llraꞌ ganni, ba babaneꞌ radj beꞌnn wat kaꞌ kanꞌ bnekzeꞌ. Ledá ke, lewiá ganꞌ broꞌ akeꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sete lelljayak, lelljadixjweꞌ beꞌnn kaꞌ nak Jesúsenꞌ txhen, ye akreꞌ ba babaneꞌ radj beꞌnn wat kaꞌ. Naꞌ ye akreꞌ wyoblle yellín Jesúsenꞌ Galileanꞌ, kerke leakeꞌ, naꞌ Galilea naꞌ reꞌe akreꞌ Leꞌe. Kanꞌ bne Dios naꞌ badtixjweꞌraꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naꞌll le bazaꞌte noꞌr kaꞌ lloaꞌ brojenꞌ, do lleb akzeꞌ naꞌ llawé akreꞌ, zjayakdoeꞌ jadixjweꞌ akreꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen kanꞌ gok naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Naꞌ ka zjayakeꞌ naꞌ, ballay akreꞌ Jesúsenꞌ tnez. Naꞌll bwapeꞌ leakeꞌ lliox. Naꞌll bcheꞌk xhib akeꞌ raweꞌn, naꞌ bdeꞌl akeꞌ nieꞌn, naꞌll beꞌrao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bi llebre lelljadixjweꞌ beꞌnn lwelljllo kaꞌ, llayaꞌl lljakeꞌ Galileanꞌ nench reꞌe akreꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Naꞌ chak zjayak noꞌr kaꞌ yellenꞌ, bal wakaꞌa ya kaꞌ, beꞌnn kaꞌ bdap ganꞌ bkwaꞌch akeꞌ Jesúsenꞌ, jayakeꞌ yellenꞌ, naꞌ jadixjweꞌ akreꞌ bxoz wnebiaꞌ kaꞌ doxhen kanꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naꞌll badop bxoz wnebiaꞌ kaꞌ, ren beꞌnn gor brao kaꞌ llnebiaꞌ yell Israelenꞌ, naꞌ beꞌe akeꞌ diꞌll akre gon akeꞌ, kanꞌ lloeꞌ wakaꞌa ya kaꞌ diꞌll gok naꞌ. Naꞌll beꞌe akeꞌ wakaꞌa ya kaꞌ mell xhen. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Lle akeꞌ leakeꞌ: —Chaꞌ no nnab akrenꞌ gok, naꞌ ye aktezreꞌ tlleꞌlre ka tasre naꞌ, badrej beꞌnn kaꞌ non leꞌe txhen naꞌ kwerp keꞌen lo broj naꞌ, naꞌ jaroꞌ akeꞌ Leꞌe ga yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Naꞌ chaꞌ ba bene beꞌnnenꞌ llnebiaꞌn diꞌll ki, netoꞌ lljeꞌrentoeꞌ diꞌll nench bibi gon akreꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naꞌ bxhiꞌi wakaꞌa ya kaꞌ mell danꞌ beꞌe akeꞌ leakeꞌn, nench ben akeꞌ kon kanꞌ goll akeꞌ leakeꞌ naꞌ. Naꞌ to nnaꞌ lla, nna ne akeꞌ yeolol ka bne wakaꞌa ya kaꞌ, doxhen ganꞌ llaꞌa beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Naꞌ beꞌnn chnej kaꞌ nak Jesúsenꞌ txhen, jakeꞌ Galileanꞌ rao yaꞌ ganꞌ golleꞌ leakeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Naꞌ ka breꞌe akreꞌ Jesúsenꞌ, beꞌrao akeꞌ Leꞌe kwis. Naꞌ ye baleꞌ bi llejleꞌ akeꞌ chaꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naꞌll zej Jesúsenꞌ ganꞌ ze akeꞌ naꞌ, naꞌ lleꞌe leakeꞌ: —Ba ben Diosenꞌ rao naꞌ, doxhen yel llnebiaꞌ danꞌ de yebá naꞌ, naꞌ yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ke len naꞌ lechej, lelljased lelljaroeꞌ beꞌnn kaꞌ, yeolol yell nench gonliraꞌll akeꞌ nadaꞌ. Naꞌ lewchoa akeꞌ nis, nench wroeꞌn ba llonliraꞌll akeꞌ Xallo Diosenꞌ, naꞌ Xhiꞌnneꞌ Jesucristo naꞌ, naꞌ ren Spíritu keꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Naꞌ lewroeꞌ lewsed akreꞌ, nench gon akeꞌ yeolol danꞌ ba gollaꞌ reꞌ naꞌ. Nadaꞌ zorenkzaꞌ reꞌ yeo lla, naꞌ kaꞌkze sorenkzaꞌ reꞌ yeyollte yellrio ni. Kaꞌn gakchga.");
INSERT INTO zpuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ki bzorao Diꞌll Wen ke Jesucristo, beꞌnnenꞌ nak Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kanaꞌ bzo to beꞌnn golle Isaías, beꞌe xtiꞌll Diosenꞌ, naꞌ ki bzojeꞌ: Wseꞌlaꞌ to beꞌnn kwiaraweꞌ raoꞌn, weꞌe xtiꞌlloꞌn, nench yeweꞌ xhnneze ganꞌ teꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Leꞌe nneꞌe zillj latj dachenꞌ nneꞌe: “¡Legón xhnid, legonchaꞌo nez ganꞌ te Xanllonꞌ, lewsarj yichjraꞌlldaꞌore ka llon to beꞌnn llsarj to nez li!” ");
INSERT INTO zpuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Naꞌ kaꞌn gok kat bllin Juan naꞌ latj dachenꞌ, naꞌ bchoeꞌ beꞌnn nis, naꞌ bdixjweꞌreꞌ beꞌnne llayaꞌl wayat akreꞌ ke da xhinnj ke akeꞌn, naꞌ choaꞌ akeꞌ nis nench waziꞌxhen Diosenꞌ ke da xhinnj ke akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Beꞌnn zan beꞌnn zaꞌk doxhen ganꞌ nbane Judea, naꞌ beꞌnn zaꞌk Jerusalén lljakeꞌ lljazenay akeꞌ xtiꞌlleꞌn, naꞌ ka nak llxoarap akeꞌ da xhinnj ke akeꞌn, naꞌ llchoeꞌ leakeꞌ nis lo yeo ganꞌ nziꞌi Jordán. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Naꞌ Juan naꞌ gokeꞌ raꞌll da nak de yich xha camello, naꞌ bchej lloaꞌ leꞌen to yid, naꞌ bdaweꞌ bichsoa ren blliꞌndaꞌo ke beser yiꞌxe. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naꞌ llyixjweꞌreꞌ beꞌnne neꞌe: —Za zaꞌa ye to beꞌnne naplle yel llnebiaꞌ ka nadaꞌ, ni jeze da lleꞌkaꞌ yeyaljaꞌ xhereꞌn bi zaꞌkaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Da li nadaꞌ llchoaꞌ reꞌ nis, zan Leꞌe goneꞌ ka yedsó Spíritu ke Diosenꞌ yichjraꞌlldaꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naꞌ ka llanꞌ llchoaꞌ Juan naꞌ beꞌnn nis, Jesúsenꞌ bzeꞌe ganꞌ nziꞌi Nazaret ganꞌ nbane Galileanꞌ, naꞌ byejeꞌ lloaꞌ yeo ganꞌ nziꞌi Jordán, naꞌ bchoaꞌ Juan naꞌ Leꞌe nis. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bixha chak llalloj Jesúsenꞌ lo nisenꞌ, byarj yebánꞌ, naꞌ betj Spíritu ke Diosenꞌ, naken ka to plom daꞌo jasorenen Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Naꞌ blloj chiꞌi Diosenꞌ yebánꞌ, bneꞌe: —Rweꞌ nakoꞌ xhiꞌnnaꞌ nllieꞌraꞌ, llaweraꞌ llayazraꞌllaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Naꞌll Spíritu ke Diosenꞌ, le benten nench byej Jesúsenꞌ ganꞌ nak latj dachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Gannaꞌ bzoeꞌ choa (40) lla radj bayiꞌx znia ake. Naꞌ danꞌ llnebiaꞌ daxiꞌo kaꞌ bkoꞌyelen Leꞌe, gokraꞌllen gon Jesúsenꞌ da xhinnj. Naꞌll angl kaꞌ bllin akeꞌ gokrén akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bayoll broꞌ akeꞌ Juan naꞌ rill ya, Jesúsenꞌ ballineꞌ ganꞌ nbane Galileanꞌ llyixjweꞌreꞌ Diꞌll Wen, ka nak yel llnebiaꞌ ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Lleꞌe beꞌnn kaꞌ: —Ba bllin lla gak danꞌ nwia Diosenꞌ goneꞌ, naꞌ sorao nnebieꞌ, lewayate ke da xhinnj keré kaꞌ, naꞌ lechejleꞌ Diꞌll Wen ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesúsenꞌ deꞌe lloaꞌ nisdaꞌo Galileanꞌ, naꞌ breꞌreꞌ chop beꞌnn wxhen bel, beꞌnn re Simón ren biꞌcheꞌn re Andrés, naꞌ llzaꞌl yixj bel ke akeꞌn lo nisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naꞌll lle Jesúsenꞌ leakeꞌ: —Ledá gonre nadaꞌ txhen, naꞌ gonaꞌ nench reꞌ wtopre beꞌnne, naꞌ yelloj akeꞌ rao da xhinnj ke akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Naꞌll le bsanraꞌllte yixj bel ke akeꞌn, naꞌ le bnao akteꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Naꞌ bzaꞌa Jesúsenꞌ ye raꞌte, naꞌ breꞌreꞌ Jacobo ren Juan, xhiꞌnn Zebedeo, lliꞌ akeꞌ lo barco ke akeꞌn llatiꞌx yixj bel ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Leskaꞌ le goxhteꞌ leakeꞌ, naꞌ bkwaꞌnnrén akeꞌ xa akeꞌn beꞌnn wen llin kaꞌ, naꞌ bnao akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Naꞌ bllin Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen yellenꞌ re Capernaum, naꞌ ka bllin to lla nbaꞌnne ke beꞌnn Israel kaꞌ, byejeꞌ lo yodaꞌo, naꞌ bzorao llroeꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naꞌ llabane beꞌnn kaꞌ ke diꞌllenꞌ lloeꞌn, le nneꞌe ka beꞌnn nap yel llnebiaꞌ, le bi llon beꞌnn kaꞌ llsedre ke leyenꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bixha lo yodaꞌo naꞌ, lliꞌ to beꞌnn yoꞌ daxiꞌo yichjraꞌlldaꞌweꞌ, naꞌ bzorao llosieꞌ neꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Bixchen zadchixkoꞌ ren netoꞌ, Jesús beꞌnn Nazaret? ¿Zaꞌo zadlleyiꞌo netoꞌn? Nnézkzeraꞌ no rweꞌ, rweꞌn Beꞌnn Nak Laꞌy bseꞌl Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesúsenꞌ benreꞌ daxiꞌon znia lleꞌen: —¡Llakia llonoꞌ, balloj yichjraꞌlldaꞌo beꞌnnenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Naꞌll daxiꞌon bnnibchachen beꞌnnenꞌ, naꞌ besiaꞌn zillj kwis, naꞌll ballojen yichjraꞌlldaꞌo beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yeolol beꞌnn kaꞌ llabán akreꞌ kwis, naꞌll lle lwellj akeꞌ: —¿Akre chejnieꞌllo danꞌ? ¿Bi da kobenꞌ llroeꞌ llsede beꞌnnenꞌ? Ka naken ren yel wak keꞌen llalwilleꞌ daxiꞌon naꞌ llzenayten. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sete bnneze beꞌnn zan kanꞌ goken, doxhen ganꞌ nziꞌi Galileanꞌ bze ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ka balloj Jesúsenꞌ lo yodaꞌon, naꞌ zjayakeꞌ txhen ren Jacobo, naꞌ Juan naꞌ, jakeꞌ rill Simón naꞌ, ren Andrés. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bixha xhnaꞌ noꞌr ke Simón naꞌ, deꞌe yoeꞌ da la res, le beꞌrén akteꞌ Jesúsenꞌ diꞌll kanꞌ llaken. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Naꞌ jabiꞌyeꞌ, beꞌxeꞌ taꞌkeꞌn, naꞌ baliseꞌ leꞌe, le ballachte da lanꞌ, le bzoraote llsinieꞌ da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka ba zaꞌa llen willenꞌ, naꞌ ba llze yere, jwaꞌa akeꞌ beꞌnn zan rao Jesúsenꞌ beꞌnn llak yillweꞌ, naꞌ beꞌnn yoꞌ daxiꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yeolol beꞌnn yell bdop akeꞌ lloaꞌ yoꞌ ganꞌ zoeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Beꞌnn zan bayoneꞌ, beꞌnn llak wde wdere yillweꞌ, naꞌ babejeꞌ daxiꞌo yichjraꞌlldaꞌo beꞌnne, naꞌ bi beꞌe latj nne daxiꞌo kaꞌ, le nnez akseren noxhanꞌ nakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Naꞌ nakte nnaxte byas Jesúsenꞌ, naꞌ bllojeꞌ zejeꞌ to latj dach, naꞌ lloeꞌreneꞌ Diosenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Naꞌ Simón Pedro ren beꞌnn kaꞌ non leꞌe txhen naꞌ, jakeꞌ jadirj akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ka ballel akreꞌ Leꞌen, lle akeꞌ Leꞌe: —Yeolol beꞌnn kaꞌ dá akeꞌ llayirj akeꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naꞌll lleꞌe leakeꞌ: —Lechoꞌo yell wrill kaꞌ nench chixjweꞌ akreꞌ xtiꞌll Diosenꞌ, le ke len naꞌ ba bedaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Doxhen ganꞌ nbane Galileanꞌ bda Jesúsenꞌ llyixjweꞌreꞌ xtiꞌll Diosenꞌ toto yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ llabejeꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Naꞌ to beꞌnn llen yillweꞌ danꞌ ne lepra, byejeꞌ rao Jesúsenꞌ, goꞌtyoereꞌ Leꞌe, naꞌ bcheꞌk xhibeꞌ lleꞌe Leꞌe: —Chaꞌ lleꞌnroꞌ, wakse wakaꞌo yillweꞌ kiaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naꞌ Jesúsenꞌ bayaꞌchraꞌlleꞌ leꞌe, naꞌ bli taꞌkeꞌn bdaneꞌ leꞌe, naꞌ golleꞌ leꞌe: —Lleꞌnkzraꞌ, bayak. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bayoll bneꞌe kaꞌn, le bayakte beꞌnnenꞌ, naꞌ bagaꞌnnteꞌ yall kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Naꞌll Jesúsenꞌ baseꞌleꞌ leꞌe, naꞌ goꞌtyoereꞌ leꞌe, ");
INSERT INTO zpuNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","lleꞌe leꞌe: —Notno yeꞌo bayonaꞌ rweꞌ, kon byej rao bxozenꞌ nench reꞌreꞌ ba bayakoꞌ, naꞌ beꞌe danꞌ nllia da Moisésenꞌ biaꞌa weꞌllo, nench yeyakoꞌ yall rao leyenꞌ. Kaꞌ ben nench yeolol beꞌnne nnez akreꞌ ba bayakoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bixha beꞌnnenꞌ ka bazeꞌe naꞌ, bzorao lloeꞌ diꞌll kanꞌ gok bayakeꞌn. Ke len naꞌ bill gokse choꞌ Jesúsenꞌ yell kaꞌ, naꞌ bdeꞌe llillize do ga ndach, naꞌ dekz de beꞌnn zan lljakse raweꞌn beꞌnn zaꞌk do gateze. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gok chop chonn lla bzaꞌa Jesúsenꞌ Capernaum naꞌ, kat ballineꞌ da yobre, naꞌ bnneze beꞌnn kaꞌ zoeꞌ yoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Le bdopte beꞌnn zan kwis bllinte lloaꞌ yoꞌn bayichochjten to nollno llakse choꞌ. Naꞌ bdixjweꞌreꞌ leakeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kat le bllinte tap beꞌnn nlen akeꞌ to beꞌnn bi dá niaꞌneꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Naꞌ bi gok choꞌrén akeꞌ leꞌe, llin akeꞌ raweꞌn le llaꞌa beꞌnn zan kwis. Naꞌll blep akeꞌ leꞌe yichjore, naꞌ bsarj akeꞌ to latj ga bletj akeꞌ leꞌe do ka nak ganꞌ xhoeꞌn, naꞌ bllineꞌ rao Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Naꞌ gokbeꞌe Jesúsenꞌ nxenraꞌll akeꞌ Leꞌe, naꞌll golleꞌ beꞌnn xhinnjenꞌ: —Xhiꞌnnaꞌ, ni llaziꞌxhenaꞌ da xhinnj koꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lo yoꞌ naꞌ zjalliꞌ bal beꞌnn llsedre ke ley danꞌ bzoj da Moisésenꞌ, kate ben akreꞌ kanꞌ bne Jesúsenꞌ, ben akeꞌ xhbab: ");
INSERT INTO zpuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Bixchen nez beꞌnnenꞌ kaꞌ? Wakadiꞌ ke Diosenꞌ lloneꞌ. Nollno gak yeziꞌxhen da xhinnj ke beꞌnne, le zeraoze Dios.” ");
INSERT INTO zpuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Naꞌ Jesúsenꞌ bayakbeꞌreꞌ kanꞌ llon akeꞌ xhbabenꞌ, naꞌll lleꞌe leakeꞌ: —¿Bixchen llonre xhbabenꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Llákere bi napaꞌ yel llnebiaꞌ naꞌ yepeꞌ: “Ni llaziꞌxhenaꞌ da xhinnj koꞌo”, naꞌ bi zaꞌk xtiꞌllaꞌn. ¿Bixha chaꞌ yepeꞌ: “Bayas, baziꞌi ganꞌ xhoaꞌo naꞌ bayej”? ");
INSERT INTO zpuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ni nnézere, nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach napaꞌ yel llnebiaꞌ rao yellrio nench yeziꞌxhenaꞌ da xhinnj ke beꞌnne. Naꞌll golleꞌ beꞌnn xhinnjenꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ni llepaꞌ rweꞌ, bayas, baziꞌi ganꞌ bxhoaꞌon naꞌ bayej rilloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Le bayasdote beꞌnnenꞌ, zanleneꞌ ganꞌ bxhoeꞌn, llwiate beꞌnn kaꞌ ballojeꞌ. Naꞌ llabane beꞌnn kaꞌ, naꞌ lloeꞌrao akeꞌ Dios ne akeꞌ: —Gatga nna reꞌllo ka danꞌ gok nnaꞌ lla. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bde naꞌ, byej Jesúsenꞌ lloaꞌ nisdaꞌon da yobre, naꞌ beꞌnn zan bdop, naꞌ broeꞌ bsedreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Naꞌ bdieꞌ ga lliꞌ to beꞌnn re Leví, nakeꞌ xhiꞌnn beꞌnnenꞌ re Alfeo, llieꞌ ganꞌ llchixhjeꞌ danꞌ llayaꞌl wayej yell ganꞌ llnebiaꞌ leakeꞌ. Naꞌll lle Jesúsenꞌ leꞌe: —Da nao nadaꞌ. Naꞌll bzolleꞌe, naꞌ bnaweꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Naꞌ bde naꞌ, lliꞌ Jesúsenꞌ llaoreneꞌ leakeꞌ txhen rill Levínꞌ, naꞌ ren beꞌnn zan beꞌnn wachixhj, naꞌ yezikre no beꞌnn wen da xhinnj, naꞌ ren beꞌnn kaꞌ non Leꞌe txhen, le beꞌnn zan naꞌ nao Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ beꞌnn fariseo kaꞌ, breꞌe akreꞌ Jesúsenꞌ llaoreneꞌ beꞌnn wachixhj kaꞌ txhen, naꞌ beꞌnn wen da xhinnj kaꞌ yelaꞌ, goll akeꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen: —¿Bixchen llaoreneꞌ wachixhj kaꞌ, naꞌ ren beꞌnn wen da xhinnj kaꞌ txhen? ");
INSERT INTO zpuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ka bene Jesúsenꞌ kaꞌ, naꞌll golleꞌ leakeꞌ: —Beꞌnn bibi yillweꞌ llake, bi yalljreꞌ beꞌnn wen rmell, zan beꞌnnenꞌ llak yillweꞌn, leꞌen yalljreꞌ beꞌnn wen rmellenꞌ. Kanꞌ naken kiaꞌ nadaꞌ, kere zaꞌa zadyexhaꞌ beꞌnn wen akenꞌ, zan zaꞌa zadwiaꞌ beꞌnn wen da xhinnj akenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bixha gok to lla beꞌnn kaꞌ non Juan naꞌ txhen, naꞌ beꞌnn kaꞌ non beꞌnn fariseo kaꞌ txhen non akeꞌ was, naꞌ bal beꞌnn kaꞌ jak akeꞌ rao Jesúsenꞌ, naꞌ lle akeꞌ Leꞌe: —¿Bixchen beꞌnn kaꞌ non Juan naꞌ txhen, naꞌ beꞌnn kaꞌ nao beꞌnn fariseo kaꞌ llon akeꞌ was, naꞌ beꞌnn kaꞌ non rweꞌ txhen naꞌ, bi llon akeꞌ was? ");
INSERT INTO zpuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Bixha wak gon beꞌnn kaꞌ was, beꞌnn kaꞌ llon akeꞌ yexh ga llak yel wachaynaꞌa chak lliꞌrén beꞌnnenꞌ llchaynaꞌn leakeꞌ? Chak nna zo beꞌnn byionꞌ, llon akeꞌ leꞌe txhen, ker wak gon akeꞌ was. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Zan wllin lla kat wagaꞌa beꞌnn byionꞌ, kanaꞌllenꞌ gon akeꞌ was. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ni to beꞌnn kat wadeꞌe raꞌll, siꞌzeꞌ to raꞌll kobe wadeꞌen da gorenꞌ. Chaꞌ kaꞌ goneꞌ, raꞌll kobenꞌ, kat chiben, wabeꞌn, naꞌ da gorenꞌ yezikre cheꞌzen. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Leskaꞌ nono kaꞌchaꞌoze xis uva kobenꞌ to lo blloy yid gore, le xis uva kobenꞌ wcheꞌzen blloy yid gorenꞌ naꞌ larjen. Ke nak xis uva kobenꞌ llayaꞌl kaꞌchaꞌweꞌn lo blloy yid kobe. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bixha gok to lla nbaꞌnne ke beꞌnn Israel kaꞌ, bde Jesúsenꞌ ga naz akeꞌ trigo, naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, bzorao ll-lechj akeꞌ dao ke trigonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naꞌ beꞌnn fariseo kaꞌ lle akeꞌ Leꞌe: —Bwiake kanꞌ llon beꞌnn kaꞌ non rweꞌ txhen naꞌ, ¿bixchen llon akzeꞌ kaꞌ? Llon akeꞌ da bi llayaꞌl gonllo lla nbaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Naꞌ Jesúsenꞌ golleꞌ leakeꞌ: —¿Bixha bi nna golre kanꞌ ben da rey Davidenꞌ kanaꞌ? Ka bdoneꞌ ren beꞌnn kaꞌ zejreneꞌ txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kanꞌ byoeꞌ ganꞌ nak rill Diosenꞌ, naꞌ beꞌnnenꞌ re Abiatar nakeꞌ bxoz, Davidenꞌ bdaweꞌ yet xtir ke Diosenꞌ da bi de latj gao noteze beꞌnne, toze bxoz kaꞌ gak gao len; Davidenꞌ bdaweꞌn, naꞌ leskaꞌ bdaorén beꞌnn kaꞌ zejrén leꞌe txhen naꞌ len. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Leskaꞌ lleꞌe leakeꞌ: —Ni ke beꞌnnachenꞌ brej Diosenꞌ lla nbaꞌnne nench sieꞌn banez, kere brejeꞌ beꞌnnachenꞌ nench gonchieꞌ lla naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Llayaꞌl nnézere nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, nakaꞌ xan llanꞌ llapre baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gok ye to ka byoꞌ Jesúsenꞌ to lo yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ lliꞌ to beꞌnn nxhoꞌn chlaꞌ neꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bal beꞌnn kaꞌ lliꞌnao akeꞌ chaꞌ wayón Jesúsenꞌ leꞌe to rao lla nbaꞌnne, nench gaꞌt da lljatao akeꞌ xhia rao koxchis kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naꞌll lle Jesúsenꞌ beꞌnnenꞌ nat taꞌkeꞌn: —Bzollá, naꞌ bze radjllo ni. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Naꞌll lleꞌe beꞌnn kaꞌ: —Lennechk, ¿de latj gonllo da wen o chaꞌ gonllo da xhinnj rao lla nbaꞌnne? ¿Wak yesrallo beꞌnne o chaꞌ weꞌllo latj kwiayieꞌ? Naꞌ beꞌnn kaꞌ ka ben akreꞌ kaꞌ, to blleꞌ akzeꞌ llize, billbi bne akseꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesúsenꞌ bwieꞌ leakeꞌ znia, le gokyaꞌchreꞌ ka nak bi llejleꞌ akeꞌ keꞌe. Naꞌll lleꞌe beꞌnnenꞌ: —Bli naꞌon. Naꞌ bli naꞌa beꞌnnenꞌ, le bayakten. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Naꞌ ka ballach beꞌnn fariseo kaꞌ, bzorao lloeꞌ akeꞌ diꞌll ren beꞌnn kaꞌ non txhen Herodes naꞌ, akre gon akeꞌ got akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, broꞌ akeꞌ nez jakeꞌ lloaꞌ nisdaꞌo, naꞌ beꞌnn zan beꞌnn Galilea kaꞌ bnao Leꞌe, naꞌ ren beꞌnn Judea. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Naꞌ beꞌnn zaꞌk Jerusalén, naꞌ beꞌnn zaꞌk ganꞌ nziꞌi Idumea, naꞌ beꞌnn zaꞌk chlaꞌ yeo Jordán, ren beꞌnn zaꞌk ganꞌ nziꞌi Tiro, naꞌ ganꞌ nziꞌi Sidón, ka nak bnnez akreꞌ yel wak kaꞌ lloneꞌn, beꞌnn zan jakeꞌ ganꞌ zoeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Naꞌll goll Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, gon akeꞌ xhnid to barco ga choeꞌ nench ke wchiꞌd beꞌnn zan kaꞌ Leꞌe, ");
INSERT INTO zpuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","le beꞌnn zan kwisenꞌ bayoneꞌ, naꞌ yeolol beꞌnn yoꞌ yillweꞌ jabiꞌy akeꞌ to llbiachaꞌ akeꞌ Leꞌe, ka nak lleꞌn akreꞌ kan akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Naꞌ beꞌnn kaꞌ yoꞌ daxiꞌon, ka llreꞌe akreꞌ Leꞌen, llcheꞌk xhib akeꞌ naꞌ daxiꞌo kaꞌ llosiaꞌ aken ne aken: —Rweꞌn nakoꞌ Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Naꞌ Jesúsenꞌ benreꞌ daxiꞌo kaꞌ znia nench bi weꞌe aken diꞌll nonꞌ nakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bde naꞌ, byejeꞌ to rao yaꞌ, naꞌ goxheꞌ bal beꞌnn jakeꞌ ganꞌ llieꞌn. Ka bllin akeꞌ raweꞌ naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","brejeꞌ chllinn (12) beꞌnne nench gon akeꞌ Leꞌe txhen, naꞌ wseꞌleꞌ leakeꞌ chixjweꞌ akreꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Naꞌ beꞌe leakeꞌ yel llnebiaꞌ nench wayón akeꞌ beꞌnn weꞌe, naꞌ wabej akeꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnn ak. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ki re beꞌnn chllinn kaꞌ: Simón beꞌnnenꞌ bsieꞌ Pedro. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo ren Juan beꞌnn biꞌcheꞌn, nak akeꞌ xhiꞌnn Zebedeo, naꞌ bsieꞌ leakeꞌ Boanerges, da ni lleꞌnen nen beꞌnn llon ka yiꞌ bziꞌo kat llachjen; ");
INSERT INTO zpuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","naꞌll Andrés, Felipe, Bartolomé, Mateo naꞌ Tomás, Jacobo xhiꞌnn Alfeo, Tadeo, naꞌ Simón, beꞌnnenꞌ ben txhen beꞌnn kaꞌ nziꞌi cananista, ");
INSERT INTO zpuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","naꞌll Judas Iscariote, beꞌnnenꞌ, ka bllin lla, beneꞌ Jesúsenꞌ rallnaꞌa beꞌnn kaꞌ llwie Leꞌe. Bayoll naꞌ ballín akeꞌ yoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yoꞌ naꞌ bdop beꞌnn zan kwis da yobre, ni ke llakze kweꞌ akeꞌ gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ka bene biꞌch lwelljeꞌ kaꞌ kanꞌ llaken, jakeꞌ gokraꞌll akeꞌ wacheꞌe akeꞌ Leꞌe, le llak akreꞌ bije zo yichjraꞌlldaꞌweꞌ wen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, beꞌnn kaꞌ zaꞌk Jerusalén naꞌ, bne akeꞌ: —Beelzebú danꞌ llnebiaꞌ daxiꞌo kaꞌ, noeꞌn Leꞌe yel wak, naꞌllenꞌ llabejeꞌ daxiꞌo kaꞌ yichjraꞌlldaꞌo beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naꞌll goxh Jesúsenꞌ leakeꞌ, naꞌ lleꞌe leakeꞌ: —¿Akxha gon danꞌ llnebiaꞌ daxiꞌo kaꞌ wabej kwine? ");
INSERT INTO zpuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chaꞌ to yell naken chopre, lldilrén lwellj akeꞌ, wllin lla kwiayiꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chaꞌ to lo yoꞌ dil akeꞌ nak akeꞌ chopre bi sibia akeꞌ, wllin lla waraꞌ lwellj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Naꞌ chaꞌ daxiꞌon dil ren lwellje naken chopre, sete wlliayiꞌ kwine chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nono gak choꞌ lo yoꞌ ke to beꞌnn war, naꞌ sieꞌ bi da de keꞌe. Zgaꞌtek lleꞌnen wchejeꞌ leꞌe, naꞌllenꞌ gak sieꞌ bi da de keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Da li niaꞌ reꞌ, biteze bi da xhinnj gon beꞌnn kaꞌ, naꞌ bi da zban ne akeꞌ, de yel llaziꞌxhen ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Zan chaꞌ nne akeꞌ ke Spíritu ke Diosenꞌ, bi waziꞌxhenkze Diosenꞌ ke akeꞌ, xhia xhen llia beꞌnn kaꞌ gon kaꞌ ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bneꞌe kaꞌ le leakeꞌn bne akeꞌ, daxiꞌon yoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naꞌ llakte kaꞌn, kat bllin xhneꞌe ren biꞌcheꞌ kaꞌ, naꞌ bze akteꞌ liaꞌte, naꞌ bseꞌl akeꞌ beꞌnne gaxheꞌ Jesúsenꞌ chejeꞌ ganꞌ ze akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Naꞌ beꞌnn kaꞌ nechj Leꞌen, goll akeꞌ Leꞌe: —Xhnaꞌo ren biꞌchoꞌ kaꞌ ze akeꞌ ganni, llayirj akeꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Naꞌ ballieꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —¿Noxhanꞌ nak xhnaꞌ? ¿Nonꞌ nak biꞌchaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naꞌll bwieꞌ beꞌnn kaꞌ lliꞌ nechj Leꞌen, naꞌ bneꞌe: —Beꞌnn kinꞌ xhnaꞌ, naꞌ biꞌchaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Le yeolol beꞌnn kaꞌ llon kanꞌ lleꞌne Diosenꞌ, leakeꞌn nak biꞌchaꞌ, zanaꞌ naꞌ xhnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Da yobre byej Jesúsenꞌ lloaꞌ nisdaꞌon, naꞌ bzorao llroeꞌ llsedreꞌ beꞌnne, naꞌ beꞌnn zan kwis bdop, to benen bien byoeꞌ to lo barco da xhoa rao nis, naꞌ bllieꞌ loenꞌ naꞌ beꞌnn zan kaꞌ, ze akteꞌ rao yo billre. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Naꞌ llroeꞌ llsedreꞌ leakeꞌ bsaꞌkrebreꞌ bi da kaꞌ, naꞌ beꞌreneꞌ leakeꞌ to diꞌll ke to beꞌnn llaz. Naꞌ lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Lewzenay ke, to beꞌnn wen llin jezeꞌ trigo. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bixha ka nak zejeꞌ lloseꞌ nbaz kaꞌ, balen jeꞌten lloaꞌ nez, naꞌ betj byinn daꞌo, banꞌ dá rao lla, naꞌ bdaobaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Naꞌ ye balen jagoꞌnnen rao yej ga bibi yo detek, sete braꞌ aken. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Naꞌ ka nak bi nyin roe zitj, ka bnnaꞌ willenꞌ naꞌ byechen. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Naꞌ balen jachaꞌa radj yay yeꞌche, naꞌ blliꞌo yay yeꞌchenꞌ, naꞌ benen len roeꞌ, naꞌ bibi bllian. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Naꞌ ye balen jeꞌten rao yo chaꞌo, naꞌ braꞌ akeꞌn, naꞌ blliꞌon, naꞌ balen bllian chilloa (30) wej, balen bllian wyon (60) wej, naꞌ balen bllian do to gayoa (100) wej. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naꞌll lleꞌe leakeꞌ: —Reꞌ zo nayre, lewzenay xtiꞌllaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ka ballach beꞌnn zan kaꞌ, naꞌ bagaꞌnn beꞌnn chllinn kaꞌze, naꞌ ye bal beꞌnn kaꞌ nak leakeꞌ txhen, bnnab akreꞌ Leꞌe akre zejen naꞌ, ke diꞌllenꞌ beꞌreneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naꞌ lleꞌe leakeꞌ: —Reꞌ ba brej Diosenꞌ nench nnézere kanꞌ lloneꞌ llnebieꞌn, zan beꞌnn kaꞌ yelaꞌ bi llejleꞌ kiaꞌ, kone da ki llsaꞌkrebraꞌ lloeꞌrén akeꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Llonaꞌ kaꞌ nench gak kanꞌ ne xtiꞌll Diosenꞌ: laꞌkze wia akeꞌ bi gakbeꞌe akreꞌ bi danꞌ, laꞌkze yen akreꞌ bi chejnieꞌ akreꞌn, naꞌ bi wayat akreꞌ, naꞌ bi yeziꞌxhen Dios ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Bi llejnieꞌre diꞌll kaꞌ lloeꞌrenaꞌ reꞌ? Chaꞌ bi llejnieꞌre diꞌll ki, ¿akxha gak chejnieꞌre da kaꞌ llsaꞌkrebraꞌ yelaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Beꞌnnenꞌ llazenꞌ nakeꞌ ka beꞌnn lloeꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nbaz kaꞌ jeꞌt lloaꞌ nezenꞌ naken ka beꞌnn kaꞌ llene xtiꞌll Diosenꞌ, naꞌ le ll-llinte daxiꞌon llabejen danꞌ yoꞌ lo raꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Naꞌ bal beꞌnne llak ke akeꞌ ka nbaz danꞌ jeꞌt rao yejenꞌ, kate llen akreꞌ xtiꞌll Diosenꞌ llawé akreꞌ ziꞌi akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Naꞌ bi nyin roe zitj, chollze llejleꞌ akeꞌ. Kate bi llak ke akeꞌ, naꞌ llaꞌdyiꞌ beꞌnn leakeꞌ ke danꞌ nao akeꞌ xtiꞌll Diosenꞌ, le llabiꞌ akteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Naꞌ ye bale llak ke akeꞌ ka nbaz danꞌ jeꞌt radj yay yeꞌchenꞌ. Llen akreꞌ xtiꞌll Diosenꞌ naꞌ ziꞌi akeꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bixha da zed kaꞌ da de rao yellrio ni, naꞌ yel wniaꞌ danꞌ ziyeꞌe lliꞌo, naꞌ yel llzeraꞌll billre da yobre, ll-llonen chejleꞌ akeꞌ kwasro, naꞌ bi llak gon akeꞌ kanꞌ lleꞌne Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Naꞌ leskaꞌ niꞌt beꞌnn llak ke akeꞌ ka nbaz danꞌ jeꞌt rao yo chaꞌon. Beꞌnn kaꞌ, ka llen akreꞌ xtiꞌll Diosenꞌ, llejleꞌ akeꞌ do yichj do raꞌll akeꞌ, naꞌ llon akeꞌ kanꞌ lleꞌne Diosenꞌ, llon akeꞌ kanꞌ llak ke nbaz danꞌ braꞌn, naꞌ blliꞌon, naꞌ balen bllia chilloa, naꞌ wyon, naꞌ do to gayoa wej toton. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Leskaꞌ lle Jesúsenꞌ leakeꞌ: —Kat llwaꞌlre yiꞌ, ¿akre llonre? ¿Lldoꞌsren to llom o chaꞌ llzoren xhanre ganꞌ llxhoare lltasre? ¿Bi lldaꞌren sib nench llseniꞌn doxhen? ");
INSERT INTO zpuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bibi de da ngaꞌch da bi wroeꞌrawe, naꞌ to da llak llillize da bi nneze beꞌnne len. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Reꞌ zo nayre da llene, lewzenay xtiꞌllaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Leskaꞌ lleꞌe leakeꞌ: —Lewiayaꞌnn kanꞌ niaꞌ ni. Le kon kanꞌ llonre naꞌ, kaꞌn gon Diosenꞌ ke reꞌ. Naꞌ yezikre goneꞌ danꞌ ba bénere xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Beꞌnn de keꞌe, weꞌlleꞌ leꞌe ye raꞌte, naꞌ beꞌnnenꞌ bi de keꞌe, to wakeꞌe da daꞌo napeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Leskaꞌ lle Jesúsenꞌ leakeꞌ: —Kanꞌ gon Diosenꞌ nnebieꞌ, wsaꞌkrebaꞌn ka llon to beꞌnn llazeꞌ xhoaꞌ rao yellrio keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Naꞌ xhoaꞌ binnenꞌ llraꞌn naꞌ ll-lliꞌon, naꞌ beꞌnnenꞌ kon lltaseꞌ, naꞌ llaseꞌ yeo lla, ni ke llakbeꞌzreꞌ akrenꞌ llak ll-lliꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yellrio naꞌn llonen nench llraꞌn, naꞌ llakten yer, naꞌll llraꞌn dao, naꞌ lldaꞌn zaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Naꞌ kat ba naken yez, le llrapteꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Leskaꞌ lle Jesúsenꞌ leakeꞌ: —¿Akre ka chejnieꞌllo kanꞌ llon Diosenꞌ llnebieꞌn, akre ke wsaꞌkrébellon? ");
INSERT INTO zpuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wsaꞌkrebraꞌn ka nbaz ke mostaz, kat llazeꞌn, laꞌkze nakten da daꞌo rize kerke no nbaz yobre, ");
INSERT INTO zpuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ka llazeꞌn naꞌ, llraꞌn naꞌ ll-lliꞌon, llakten da xhenll kerke yay daꞌo ake, naꞌ llon xhoꞌze, naꞌ lletj byinn kaꞌ dá rao lla, llon xoꞌn akbaꞌ rao xoꞌzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kone danꞌ bsaꞌkrebre Jesúsenꞌ broeꞌreꞌ beꞌnn kaꞌ lldop llzenay xtiꞌlleꞌn kon ka to llejnieꞌ akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naꞌ kone danꞌ bsaꞌkrebreꞌ bzejnieꞌreꞌ leakeꞌ, naꞌll kat bill llaꞌa beꞌnn zan kaꞌ, bzejnieꞌreꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, kanꞌ zejen da kaꞌ bsaꞌkrebreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lekze lla naꞌ, ka betj lleꞌ, lleꞌe leakeꞌ: —Wlaꞌyllo chlaꞌre nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Beꞌnn kaꞌ non Leꞌe txhen naꞌ, bkwaꞌnn akeꞌ beꞌnn kaꞌ llaꞌa llzenayenꞌ, naꞌ bsaꞌa akeꞌ barco ganꞌ ba yoꞌ Jesúsenꞌ, naꞌ leskaꞌ bnao ye bal beꞌnn nsaꞌa to chop barco yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bixha kat bzorao dá to beꞌ xhen rao nisdaꞌon, naꞌ bzorao lloll nis lo barconꞌ, naꞌ ba llonen da yiꞌchen. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Naꞌ de Jesúsenꞌ taseꞌ xhniaꞌ barconꞌ nkoyeꞌ to ga nxoa yichjeꞌn, naꞌ jasbán akeꞌ Leꞌe, lle akeꞌ Leꞌe: —¡Maestro! ¿Bi llakbeꞌroꞌ ka nak ba llbeyiꞌllo? ");
INSERT INTO zpuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Naꞌll byaseꞌ, naꞌ babekllieꞌ beꞌn, naꞌ golleꞌ nisdaꞌon: —¡Babeꞌ lli! Le brexhte beꞌn ren nisdaꞌon, bayakte lli. ");
INSERT INTO zpuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Naꞌll lleꞌe leakeꞌ: —¿Bixchen llebre? ¿Bi de yel llonliraꞌll ke reꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naꞌll blleb akeꞌ kwis, naꞌ lle lwellj akeꞌ: —¿Noxha beꞌnnenꞌ? Rente kaze beꞌ, naꞌ ren nisdaꞌo naꞌ llzenayen keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Naꞌ bllin Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, chlaꞌ nisdaꞌo ganꞌ nak rall beꞌnn Gadara kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bixha ka ballojeꞌ lo barconꞌ, le bllinte to beꞌnn jatileꞌ Leꞌe, beꞌnn blloj latj ganꞌ lljakwaꞌch akeꞌ beꞌnn wat kaꞌ, beꞌnn yoꞌ daxiꞌo yichjraꞌlldaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Beꞌnn naꞌ ba zotekzeꞌ latj ganꞌ lljakwaꞌch akeꞌ beꞌnn wat kaꞌ, naꞌ nono llakse wchej leꞌe, ni kon no gden. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Da zan ras ba bchej akeꞌ niaꞌneꞌe kone gden, naꞌ ka bize llaleꞌe gden naꞌ, naꞌ llxhoxhjteꞌn, ni to nono zoekze leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Do lla do yere deꞌe llosieꞌ do rao yaꞌ kaꞌ, naꞌ do radj ba ke beꞌnn wat kaꞌ, llayón ziꞌ kwineꞌ kone yej. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kate breꞌreꞌ Jesúsenꞌ ziꞌtre, naꞌll zejdoeꞌ jacheꞌk xhibeꞌ raweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Naꞌll besieꞌ zillj, lleꞌe Jesúsenꞌ: —¿Bi de koꞌo kone nadaꞌ, Jesús? Rweꞌ Xhiꞌnn Dios zo yebá. ¡Ni ke Dios llaꞌtyoeraꞌ rweꞌ, bi wsaꞌkziꞌo nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Neꞌe kaꞌ, le Jesúsenꞌ ba golleꞌ daxiꞌon: —¡Balloj yichjraꞌlldaꞌo beꞌnnenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Naꞌll bnnab Jesúsenꞌ lleꞌen: —¿Bi reꞌo? Naꞌll llen Leꞌe: —Da Zan naꞌ riaꞌ, le nyantoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Naꞌll goꞌtyoereꞌ Jesúsenꞌ bi wrayeꞌ daxiꞌo kaꞌ ziꞌt ganꞌ llaꞌa aken naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naꞌ awlloze gannaꞌ zo to yaꞌ ga zjallaꞌa kuch zan ake, llao akbaꞌ yiꞌxe. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Daxiꞌo kaꞌ llaꞌa beꞌnnenꞌ, goꞌtyoe aken Jesúsenꞌ lle aken Leꞌe: —Bseꞌl netoꞌ ganꞌ zjallaꞌa kuch kaꞌ, naꞌ benn latje lljallaꞌtoꞌ lo yichjraꞌlldaꞌo akbaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naꞌll beꞌe Jesúsenꞌ latj. Ka ballach daxiꞌo kaꞌ yichjraꞌlldaꞌo beꞌnnenꞌ, jallaꞌa aken lo kuch kaꞌ. Naꞌ nake ka chop mir akbaꞌ. To gokllejlaꞌllze kuch kaꞌ, naꞌ bzorao bix dol akbaꞌ to le bdinnj, jabix aktebaꞌ lo nisdaꞌon, naꞌ wasaꞌtbaꞌ, weꞌj akbaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Naꞌ beꞌnn kaꞌ llap kuch kaꞌ, baxhonnjdo akeꞌ zayejdo akeꞌ, jadixjweꞌ akreꞌ beꞌnn llaꞌa lyell, naꞌ beꞌnn llaꞌa lyiꞌxe kanꞌ goken. Naꞌ bllach beꞌnn kaꞌ jawiá akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ka bllin akeꞌ ganꞌ ze Jesúsenꞌ, naꞌ breꞌe akreꞌ beꞌnnenꞌ bllaꞌa daxiꞌo kaꞌ, ba babieꞌ wen, ba bayak xharaꞌneꞌ. Naꞌ blleb akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Naꞌ beꞌnn kaꞌ breꞌe kanꞌ goken, beꞌrén akeꞌ beꞌnn kaꞌ bdop naꞌ diꞌlle, kanꞌ gok bayak beꞌnnenꞌ bllaꞌa daxiꞌo kaꞌ, naꞌ kanꞌ gok ke kuch kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Naꞌ bzorao beꞌnn kaꞌ llaꞌtyoe akreꞌ Jesúsenꞌ wayejeꞌ ga yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Naꞌ ka bayoeꞌ lo barconꞌ, beꞌnnenꞌ byoꞌ daxiꞌon bnnabeꞌ weꞌe Jesúsenꞌ latjeꞌ lljannaweꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Naꞌ bi beꞌe Jesúsenꞌ latjeꞌ, naꞌ golleꞌ leꞌe: —Bayej rilloꞌ ga llaꞌa biꞌch lwelljoꞌ, naꞌ beꞌrén akeꞌ diꞌll ka yel wak xhen naꞌ, ba broeꞌ Xanllo Diosenꞌ rweꞌ, naꞌ kanꞌ bayaꞌchraꞌlleꞌ rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naꞌ zayej beꞌnnenꞌ, naꞌ yell kaꞌ ganꞌ nbane Decápolis bzoraweꞌ lloeꞌreneꞌ beꞌnn kaꞌ diꞌll kanꞌ ben Jesúsenꞌ broeꞌreꞌ leꞌe yel wak xhen keꞌen; naꞌ yeolol beꞌnn kaꞌ llabán akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ka ballín Jesúsenꞌ ye chlaꞌ nisdaꞌon zayoeꞌ lo barconꞌ, naꞌ jazeꞌe lloaꞌ nisdaꞌon, naꞌ bdope beꞌnn zan kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Naꞌ bllin to beꞌnn re Jairo, nakeꞌ beꞌnn wnebiaꞌ ke yodaꞌo ke yellenꞌ. Ka breꞌreꞌ Jesúsenꞌ le bcheꞌkte xhibeꞌ raweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naꞌ goꞌtyoereꞌ Leꞌe, lleꞌe Leꞌe: —Zo to xhiꞌnnaꞌ noꞌre, ba llak watbeꞌ; chenak saꞌo wxoa taꞌkoꞌn yichjbeꞌ naꞌ wayakbeꞌ, bi gatbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naꞌll zejreneꞌ leꞌe, leskaꞌ beꞌnn zan kwis nao, to llchiꞌd akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bixha radj beꞌnn kaꞌ ren to noꞌre, ba gok chllinn (12) iz llzoeꞌ waꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naꞌ da xhen ba ballayraweꞌ ba bdeꞌe rao wen rmell kaꞌ, gaxt xhen ba beneꞌ bi llayakseꞌ, yezikre llak yillweꞌ keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bixha ka bénkzereꞌ lloeꞌ akeꞌ xtiꞌll Jesúsenꞌ, naꞌll zejeꞌ jannaweꞌ radj beꞌnn zan kaꞌ, naꞌ jataneꞌ xha Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Le kanꞌ bzaꞌraꞌlleꞌ lo raꞌlldaꞌweꞌn bneꞌe: “Laꞌ xheꞌe naꞌze lljatanaꞌ wayaktiaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bixha ka jataneꞌ xheꞌen, le brexhte waꞌan llzoeꞌn, naꞌ le gokbeꞌtereꞌ ba bayakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Naꞌ Jesúsenꞌ le gokbeꞌtereꞌ ka ben yel wak keꞌen llin, naꞌll bayechjeꞌ llnnabreꞌ beꞌnn zan kaꞌ: —¿Nonꞌ bdan xhaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Naꞌ beꞌnn kaꞌ nak Leꞌe txhen naꞌ, lle akeꞌ Leꞌe: —Ba breꞌkzeroꞌ kanꞌ nao beꞌnn llchiꞌd akeꞌ rweꞌ. ¿Bixchen nnabrizoꞌ nonꞌ bdan xhaꞌon? ");
INSERT INTO zpuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naꞌll bayechjeꞌ llwieꞌ noxhanꞌ bdankze xheꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naꞌll lleb noꞌrenꞌ do xhiztiteꞌ, le ba bayakbeꞌreꞌ bayakeꞌ kwasro, naꞌll zejeꞌ jacheꞌk xhibeꞌ rao Jesúsenꞌ, naꞌ beꞌe diꞌll doxhente kanꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Naꞌll lle Jesúsenꞌ leꞌe: —Xhiꞌnnaꞌ, danꞌ nxenraꞌlloꞌ naꞌn, ba basrá rweꞌ, ka nake nnaꞌ ba bayakoꞌ, bayejchga wen. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Naꞌ zete Jesúsenꞌ lloeꞌ diꞌllenꞌ, ka bllindokze bal beꞌnn zaꞌa rill Jaironꞌ, beꞌnnenꞌ nak beꞌnn wnebiaꞌ ke yodaꞌon, naꞌll lle akeꞌ Jaironꞌ: —Ba gotte xhiꞌnnoꞌn, ¿bixchen nna llonllroꞌ Maestronꞌ zede? ");
INSERT INTO zpuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bixha Jesúsenꞌ, ka benreꞌ kanꞌ bne beꞌnn kaꞌ, naꞌ lleꞌe Jaironꞌ: —Bi lleboꞌ, kon benliraꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Naꞌ bi beꞌe latj no nnao Leꞌe, Pedro naꞌze, naꞌ Jacobo, naꞌ Juan, beꞌnnenꞌ nak biꞌch Jacobo. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naꞌ byej akeꞌ rill beꞌnnenꞌ; ka bllineꞌn, benreꞌ llak llakia, llaꞌa beꞌnn llasbell akeꞌ llak akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ka byoeꞌ lo yoꞌn lleꞌe leakeꞌ: —¿Bixchen llonre llakia bellre? Kere got bidaꞌo noꞌr ninꞌ, taszbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Naꞌll lltitje beꞌnn kaꞌ Leꞌe. Naꞌll bachacheꞌ leakeꞌ liaꞌre, naꞌ bcheꞌe xaxhnaꞌ bidaꞌon, naꞌ ren beꞌnn kaꞌ nao Leꞌe naꞌ, naꞌll byoeꞌ ganꞌ xhoa bidaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naꞌ beꞌxeꞌ taꞌkbeꞌ, naꞌ lleꞌebeꞌ: —Talita, cumi —da ni lleꞌnen nen: Bidaꞌo noꞌre ni llepaꞌ rweꞌ, bayas. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Le bayaste bidaꞌo noꞌrenꞌ, naꞌ le badatebeꞌ, naꞌ bidaꞌo noꞌrenꞌ nakebeꞌ chllinn (12) iz. Naꞌ beꞌnn kaꞌ llabán akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Naꞌ Jesúsenꞌ goꞌtyoereꞌ leakeꞌ notno ye akeꞌ kaꞌ, naꞌ golleꞌ leakeꞌ weꞌe akeꞌ da gao bidaꞌo noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Naꞌ bazaꞌa Jesúsenꞌ ballineꞌ ralleꞌ, naꞌ nao beꞌnn kaꞌ non Leꞌe txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Naꞌ ka bllin lla nbaꞌnne ke beꞌnn Israel kaꞌ, byejeꞌ lo yodaꞌon naꞌ llroeꞌreꞌ leakeꞌ. Beꞌnn zan bzenay xtiꞌlleꞌn, naꞌ llabán akreꞌ kwis, naꞌll ne akeꞌ: —¿Ga jaxiꞌrizeꞌ danꞌ nnezreꞌn? ¿No beꞌrize leꞌe yel siꞌn ni? ¿Gaxha jaxieꞌ yel wakenꞌ llayoneꞌ beꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Kere beꞌnn ninꞌ nakeꞌ beꞌnn waxhí yay, xhiꞌnn María? Nombiaꞌllo biꞌcheꞌ kaꞌ, re Jacobo, naꞌ José, naꞌ Judas, naꞌ Simón, naꞌ ganni niꞌt zaneꞌ kaꞌ. Ke len naꞌ bi gokraꞌll akeꞌ wzenay akeꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Naꞌll lle Jesúsenꞌ le akeꞌ: —To beꞌnn lloeꞌ xtiꞌll Dios, gateze llap akeꞌ leꞌe baraꞌnne, zan ralleꞌ ker no llejleꞌ keꞌe, ni biꞌch lwelljeꞌ, ni lo yoꞌ rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naꞌ bi gok wroeꞌreꞌ yel wak keꞌen, le bi byejleꞌ akeꞌ keꞌen. To chopze beꞌnn kaꞌ bayak, ka naken bxoa taꞌkeꞌn yichj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Naꞌ llabane Jesúsenꞌ kwis ka naken chras bi byejleꞌ akeꞌ. Naꞌ jateꞌe yell kaꞌ yelaꞌ jaroeꞌreꞌ beꞌnn ake. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naꞌll goxh Jesúsenꞌ beꞌnn chllinn kaꞌ, naꞌ bseꞌleꞌ chop wej akeꞌ, beꞌe leakeꞌ yel llnebiaꞌ keꞌen nench wabej akeꞌ no daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Naꞌ golleꞌ leakeꞌ bibi goꞌx akeꞌ ke tnez, kon toze yay da wchiꞌch akeꞌ, naꞌ bibi bzod goꞌx akeꞌ, ni yet xtir, ni mell. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kon xher akeꞌ naꞌze wrej akeꞌ, naꞌ chkweꞌze xharaꞌn akeꞌ danꞌ nak akeꞌ naꞌze, naꞌ bi goꞌx akeꞌ ye to da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Naꞌll lleꞌe leakeꞌ: —Chaꞌ to yoꞌ ga llinre, gannaꞌze sore llinte yezaꞌre rao yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chaꞌ to yell ga llinre bi wreb akeꞌ reꞌ, naꞌ bi yeꞌn akre wzenay akeꞌ xtiꞌllrenꞌ, lewalloj rao yellenꞌ, naꞌ le wabibte bichte lo labre, nench naꞌ wayakbeꞌe akreꞌ da xhinnjenꞌ llon akeꞌ. Da li ganni niaꞌ reꞌ, katenꞌ llin lla gak yel koxchis ke yeolol beꞌnne, da xhen da saꞌkziꞌ beꞌnn ki kerke beꞌnn kaꞌ bllaꞌa yell kaꞌ re Sodoma ren Gomorra. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Naꞌll bllach akeꞌ llyixjweꞌ akreꞌ beꞌnne, llayaꞌl wayat akreꞌ ke da xhinnj kaꞌ llon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Naꞌ llabej akeꞌ daxiꞌo kaꞌ yoꞌ yichjraꞌlldaꞌo beꞌnne, naꞌ beꞌnn llak yillweꞌ llwat akeꞌ leakeꞌ ceit, naꞌ llayón akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes beꞌnnenꞌ llnebiaꞌ Galileanꞌ, benreꞌ kanꞌ llon Jesúsenꞌ, le doxhen gannaꞌ ba lloeꞌ akeꞌ xtiꞌlleꞌn. Naꞌll bne Herodesenꞌ: —Juan, beꞌnnenꞌ bchoa beꞌnn kaꞌ nis, leꞌen ba babán radj beꞌnn wat kaꞌ, leꞌe napeꞌ yel wak xhen, naꞌllenꞌ llak lloneꞌ da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Naꞌ zjallaꞌa ye bal beꞌnn ne akeꞌ: —Beꞌnn naꞌn re Elías, beꞌnn beꞌe xtiꞌll Diosenꞌ kanaꞌn. Naꞌ ye bal akeꞌ ne akeꞌ: —To beꞌnn kaꞌ lloeꞌje xtiꞌll Diosenꞌ, o chaꞌ kon to beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ babán. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Naꞌ Herodes naꞌ, ka nak llenreꞌ kanꞌ ne beꞌnn kaꞌ, naꞌll bneꞌe: —Juan naꞌkzenꞌ, beꞌnnenꞌ gollaꞌ beꞌnn kaꞌ wchoy akeꞌ yen naꞌ, leꞌen babán radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes naꞌ, goklleꞌe Juan naꞌ, naꞌ bseꞌleꞌ beꞌnn kaꞌ beꞌx akeꞌ leꞌe, naꞌ bchej akeꞌ leꞌe gden, naꞌ broeꞌ leꞌe rill ya. Beneꞌ kaꞌ xtoꞌl danꞌ bakaꞌa Herodesenꞌ to noꞌrenꞌ re Herodías, noꞌr ke Felipe biꞌcheꞌ naꞌ, nench bazoreneꞌ leꞌe, gokeꞌ xhoꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Le Juan naꞌ lleꞌe leꞌe: —Da xhinnjenꞌ benoꞌ bakaꞌo xhoꞌr biꞌchoꞌn zorenoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Naꞌll Herodías naꞌ, bwiereꞌ Juan naꞌ, naꞌ blleꞌnaweꞌ leꞌe kat gaꞌt latj goteꞌ leꞌe, naꞌ bi zaꞌkereꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes naꞌ, bllebeꞌ goteꞌ Juan naꞌ, le nnezreꞌ nakeꞌ beꞌnn llon da li, nakeꞌ beꞌnn ke Dios, naꞌ bdapeꞌ leꞌe nench ke lljet Herodíasenꞌ leꞌe ganꞌ yoeꞌ naꞌ. Laꞌkze bi llejnieꞌreꞌ kanꞌ ne Juan naꞌ, llawereꞌ llzenayeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bixha ka bllin lla ka btil Herodesenꞌ iz, naꞌ beneꞌ to lnni, beneꞌ wao nench bdaoreneꞌ beꞌnn kaꞌ llnebiaꞌ ren leꞌen, naꞌ ren beꞌnnenꞌ nak xan wakaꞌa ya keꞌe kaꞌ, naꞌ beꞌnn brao kaꞌ llaꞌa Galilea naꞌ; naꞌ gok latj ke Herodíasenꞌ kanꞌ lleꞌnreꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bixha xhiꞌnn Herodías naꞌ, nakbeꞌ to bi noꞌre byoꞌbeꞌ ganꞌ llak lnninꞌ, naꞌ jayaꞌbeꞌ; naꞌ Herodesenꞌ bayazraꞌlleꞌ kwis kanꞌ byaꞌbeꞌn, leskaꞌ beꞌnn kaꞌ llaꞌreneꞌn, llawé akreꞌ kanꞌ byaꞌbeꞌn. Naꞌll lle reyenꞌ bi noꞌrenꞌ: —Naꞌ bnnab bitteze lleꞌnroꞌ, naꞌ gonnaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naꞌ bchebeꞌ, lleꞌebeꞌ: —Kon da nnaboꞌ gonnaꞌn, laꞌkze chaꞌ nneꞌo achj da kaꞌ ganꞌ llnebiaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naꞌll ballojdobeꞌ jayeꞌrenbeꞌ xhnaꞌbeꞌn diꞌlle llebe leꞌe: —¿Bi ka wnnabraꞌ Herodesenꞌ? Naꞌll lle xhnaꞌbeꞌn lebeꞌ: —Bnnab yichj Juan naꞌ, beꞌnnenꞌ llchoa beꞌnn kaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naꞌll bayoꞌdobeꞌ ganꞌ lliꞌ reyenꞌ, llebeꞌ leꞌe: —Lleꞌnraꞌ yichj Juan naꞌ, beꞌnnenꞌ llchoa beꞌnn kaꞌ nis nnaꞌstek, naꞌ bxoan to lo yeꞌnne nllirj. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodesenꞌ gokreꞌ kwis ka benreꞌ bne bi noꞌrenꞌ kaꞌ, naꞌ lleꞌn ke lleꞌnreꞌ bzoeꞌ diꞌll kanꞌ gollebeꞌ, le ba bchebeꞌ rao yeolol beꞌnn kaꞌ llaꞌa ren leꞌe txhen naꞌ, weꞌebeꞌ danꞌ bnnabbeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Le baseꞌlte reyenꞌ to wakaꞌa ya nench jachoyeꞌ yen Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ka bllin wakaꞌa yanꞌ lo rill yanꞌ, naꞌ bchoyeꞌ yen Juan naꞌ, naꞌ baxoeꞌn to lo yeꞌnn nllirj, naꞌ zanoꞌxeꞌn, naꞌ beꞌen bi noꞌr naꞌ; naꞌ bi noꞌr naꞌ bayoeꞌtebeꞌn xhnaꞌbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ka bene beꞌnn kaꞌ non Juan naꞌ txhen kanꞌ ba gok naꞌ, naꞌll byej akeꞌ jaxhiꞌi akeꞌ kwerp keꞌen jakwaꞌch akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bde naꞌ, ballín postl kaꞌ ganꞌ zo Jesúsenꞌ, naꞌ beꞌrén akeꞌ Leꞌe diꞌll kanꞌ jen akeꞌn, naꞌ kanꞌ jazejnieꞌ akreꞌ beꞌnne xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Naꞌll lleꞌe leakeꞌ: —Ledá, lechoꞌo to latj dach gannaꞌ yeziꞌraꞌll-llo choll. Bneꞌe kaꞌ, le beꞌnn zan naꞌ, llediꞌ leakeꞌ to ni ke llakze latj gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Naꞌll byoꞌ akeꞌ to lo barco zjak leakzeꞌ bllin akteꞌ to latj ga nono llraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Naꞌt beꞌnn zan breꞌe kanꞌ bzaꞌa akeꞌn, bayombiaꞌ akeꞌ Jesúsenꞌ. Naꞌ yell kaꞌ zjalliꞌ awlloze, beꞌnn zan bllach zjakdo akeꞌ kon niaꞌ akeꞌ, ba llaꞌa akreꞌ ka bllin ren Jesúsenꞌ beꞌnn kaꞌ ncheꞌn, naꞌ badil akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ka balloj Jesúsenꞌ lo barconꞌ, breꞌreꞌ beꞌnn zan kwis ba llaꞌa akreꞌ gannaꞌ, naꞌ bayaꞌchraꞌlleꞌ leakeꞌ, le llaꞌa akeꞌ ka llaꞌa xhiꞌr daꞌo ba nono llraꞌ xan, naꞌll bzoraweꞌ da zan broeꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bixha ka ba llonen ba wlleꞌ, jabiꞌy beꞌnn kaꞌ non Leꞌe txhen naꞌ, lle akeꞌ Leꞌe: —Letek gale naꞌt ganni naken ga nollno llraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Goll beꞌnn kaꞌ lljayakeꞌ nench lljakeꞌ ganꞌ llaꞌa beꞌnn kaꞌ llen lyiꞌxe, naꞌ yell daꞌo kaꞌ zjalliꞌ do naꞌze, lljaxiꞌi akeꞌ da gao akeꞌ, le bibi noꞌx akeꞌ da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naꞌll ballieꞌ xtiꞌll akeꞌn lleꞌe leakeꞌ: —Reꞌ, leweꞌe akeꞌ da gao akeꞌ. Naꞌll lle akeꞌ Leꞌe: —¿Ga lljaxiꞌtoꞌ mell ke chop gayoa (200) lla llin, naꞌ lljaxiꞌtoꞌ da gao beꞌnn ki? ");
INSERT INTO zpuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naꞌll lleꞌe leakeꞌ: —¿Bale yet xtir noꞌxre? Lewiachke. Naꞌll bwia akeꞌ, naꞌll lle akeꞌ Leꞌe: —De gaꞌy yet xtir, naꞌ ye chop belyaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Naꞌll golleꞌ leakeꞌ kweꞌ akeꞌ kwen kwen rao yiꞌxenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naꞌll brekw akeꞌ to gayoa (100) wej akeꞌ, naꞌ do chiyon (50) wej akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Naꞌll bxhieꞌ gaꞌy yet xtir kaꞌ, naꞌ bel kaꞌ ye chope. Naꞌll blis raweꞌn llwieꞌ yebáre benlaꞌyeꞌn, naꞌll bxhoxhjen beꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ bdislas akeꞌn. Leskaꞌ bdislas akeꞌ bel kaꞌ chop, rao yeolol beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Naꞌ ka badao yeolol akteꞌ, naꞌ berj aktereꞌ kwasro. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naꞌ batop akeꞌ da laꞌo kaꞌ, naꞌ goken ke do chllinn (12) llom, ren bel kaꞌ bagaꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Naꞌ beꞌnn kaꞌ bdaonꞌ nak akeꞌ ka do gaꞌy mir beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Naꞌll le gollte Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, wayoꞌ akeꞌ lo barconꞌ wabiarao akeꞌ, lljayakeꞌ Betsaida yellenꞌ lliꞌ chlaꞌ nisdaꞌon, chak nna naꞌy Leꞌen llaweꞌ beꞌnn kaꞌ nez. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bixha ka bayoll baweꞌ beꞌnn kaꞌ nezenꞌ, byejeꞌ rao yaꞌ jeꞌreneꞌ Diosenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Naꞌ ka golen, barconꞌ zayoꞌ beꞌnn kaꞌ, ba dan kllol nisdaꞌon, naꞌ Jesúsenꞌ ye toze deꞌe rao yo billenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Naꞌ breꞌreꞌ ka llakdil ren beꞌnn kaꞌ llsaꞌa akeꞌ barconꞌ, le beꞌn zaꞌn krere; ba llonten balze kate zayejeꞌ ganꞌ llaꞌa akeꞌn, zayejeꞌ to rao nisenꞌ, lleꞌnreꞌ yedieꞌ rao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bixha ka breꞌe akreꞌ Leꞌen zayejeꞌ rao nisdaꞌo naꞌn, gok akreꞌ chaꞌ bxen naꞌ, naꞌll besiaꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Le yeolol akeꞌ, ka ba breꞌe akreꞌ Leꞌen blleb akeꞌ. Naꞌll balwilleꞌ leakeꞌ lleꞌe leakeꞌ: —¡Legón war, nadaꞌn, bi llebre! ");
INSERT INTO zpuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naꞌll bayepeꞌ lo barconꞌ ganꞌ llaꞌa akeꞌn, naꞌll le brexhte beꞌn, naꞌll llabán akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Le nna llon akeꞌ yel wan danꞌ bwaweꞌ beꞌnn gaꞌy mir kaꞌ, bi llejnieꞌ akyaꞌnnreꞌ, le nna nchole yichjraꞌlldaꞌo akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ka bayoll blaꞌy akeꞌ nisdaꞌon, bllin akeꞌ ganꞌ nbane Genesaretenꞌ, naꞌ balloj akeꞌ lo barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ka balloj akeꞌ lo barconꞌ, le bayombiaꞌ akteꞌ kaze Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naꞌll bllachdo yeolol beꞌnn yell kaꞌ ganꞌ nbane Genesaretenꞌ, zaꞌkrén akeꞌ beꞌnn weꞌe kaꞌ, nlen akeꞌ leakeꞌ do ka nak ganꞌ xhoa akeꞌ naꞌ. Naꞌ jwaꞌa akeꞌ leakeꞌ kon ga nnez akreꞌ zo Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Naꞌ kon ganꞌ ll-llineꞌ do yell daꞌo kaꞌ, do yell xhen kaꞌ, do lyiꞌxe llniꞌt akeꞌ beꞌnn weꞌe kaꞌ do tnez; naꞌll llaꞌtyoe akreꞌ Leꞌe, weꞌe latj laꞌ kan akzeꞌ lloaꞌ xheꞌe, naꞌ yeolol beꞌnn kaꞌ llgan Leꞌen llayak akteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bal beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ley danꞌ bzoj da Moisésenꞌ beꞌnn kaꞌ zaꞌk Jerusalén naꞌ, jabiꞌy akeꞌ ganꞌ ze Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ka breꞌe akreꞌ bal beꞌnn kaꞌ non Jesúsenꞌ txhen bi bnaꞌa akeꞌ zan ras kanꞌ llon leakeꞌ kat gao akeꞌ, naꞌll bdao akeꞌ xhia. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Le beꞌnn fariseo kaꞌ, naꞌ yeolol beꞌnn Israel kaꞌ, nao akeꞌ klleꞌllo danꞌ bsed xozxtaꞌo akeꞌ kaꞌ, llayaꞌl wnaꞌa akeꞌ zan ras to kwen to kwen kat gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Leskaꞌ kat llallín akeꞌ lljakeꞌ lao yaꞌa, chaꞌ bi wnaꞌa akeꞌ kwasro bi gao akeꞌ. Leskaꞌ llayiblolj akeꞌ no xchinraz akeꞌ de ya, llayib akeꞌ no tas, no leo, no yeꞌse de ya, naꞌ ren ga llxhoa akeꞌ lltas akeꞌ, da zan da kaꞌ nao akeꞌn.) ");
INSERT INTO zpuNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Naꞌll beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ bnnab akreꞌ Leꞌe: —¿Bixchen bi llon beꞌnn kaꞌ non rweꞌ txhen kanꞌ ben xozxtaꞌollo kaꞌ, bi llnaꞌa akeꞌ weltze toto kweꞌ akeꞌ gao akeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Naꞌll lle Jesúsenꞌ leakeꞌ: —¡Reꞌ beꞌnn chop rao nakre! Da likzenꞌ bzoj da Isaíasenꞌ ke reꞌ kanaꞌ, kanꞌ bneꞌe: Beꞌnn ki llon akeꞌ nadaꞌ xhen kon lloaꞌ akeꞌ nazeꞌ, kere lloeꞌrao akeꞌ nadaꞌ do yichj do raꞌll akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bibi zaꞌk danꞌ lloeꞌrao akeꞌ nadaꞌn, ka nak llroeꞌ llsed akreꞌ da bayirjlaꞌll beꞌnnachzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kaꞌn llonre llkwasre diꞌll biaꞌa ke Xanllo Diosenꞌ kaꞌle, naꞌ lloeꞌlaꞌllre llonre da bayirj beꞌnnach, ka nak llayibre zan ras no leo, no tas keré, naꞌ lliꞌ yichjre llonre da zan ka da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Leskaꞌ lleꞌe leakeꞌ: —Llbej yichjre danꞌ ne Diosenꞌ gonre nench nnaore danꞌ bayirjlaꞌll beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Zan ka nak da Moisésenꞌ, ki bzojeꞌ xtiꞌll Diosenꞌ: “Llayaꞌl gap xaxhnaꞌre baraꞌnne”, naꞌ “Beꞌnnenꞌ yichjbieꞌ ke xaxhneꞌe llayaꞌl gateꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Zan reꞌ nere: “Kon danꞌ ye akeꞌ xaxhnaꞌ akeꞌ: Bibi de gonnaꞌ gakrenaꞌ reꞌ, le yeolol da de kiaꞌ naken danꞌ nziꞌi Corbán” (lleꞌnen nen ba benaꞌn rallnaꞌa Diosenꞌ). ");
INSERT INTO zpuNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kone kaꞌ lloeꞌre latj bi gakrén beꞌnn kaꞌ xaxhnaꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kone kaꞌ llbekre kaꞌle danꞌ ne Diosenꞌ, naꞌ naore danꞌ bkwaꞌnn da xozxtaꞌore kaꞌ, naꞌ llonre yelaꞌ ka nak da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naꞌll goxh Jesúsenꞌ beꞌnn zan kaꞌ, naꞌ lleꞌe leakeꞌ: —Lewzenay ke kanꞌ niaꞌ ni yeololre, naꞌ lechejnieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kere da kaꞌ lleꞌj llao beꞌnn kaꞌ, llon leakeꞌ gak akeꞌ beꞌnn wen da xhinnj rao Diosenꞌ. Da xhinnj kaꞌ ll-lloj lo yichjraꞌlldaꞌo akeꞌ naꞌn, len naꞌ llonen leakeꞌ beꞌnn wen da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Reꞌ zo nay da yénere, lewzenay. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ka bazaꞌa Jesúsenꞌ ganꞌ llaꞌa beꞌnn zan kaꞌ, naꞌ byoeꞌ yoꞌ, naꞌll bnnab beꞌnn kaꞌ non Leꞌe txhen naꞌ, akre zejen danꞌ bayoll bneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Naꞌll lleꞌe leakeꞌ: —¿Leskaꞌ reꞌ bi llejnieꞌre danꞌ niaꞌ? ¿Bi llejnieꞌre kere danꞌ lleꞌj llao beꞌnn kaꞌ llon leakeꞌ beꞌnn wen da xhinnj rao Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Le danꞌ lleꞌj llao akeꞌn kere lloꞌn lo yichjraꞌlldaꞌollo, llejen lo leꞌllo choll, naꞌ lladeten. Bneꞌe kaꞌ, nench broeꞌreꞌ yeolol yel wao naken wen gaollon. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Naꞌll bneꞌe da yobre: —Danꞌ ll-lloj yichjraꞌlldaꞌo beꞌnn kaꞌ, len naꞌ llon leakeꞌ beꞌnn wen da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Le lo yichjraꞌlldaꞌo akeꞌ naꞌn, ll-llach da xhinnjenꞌ llwia akeꞌ gon akeꞌn, naꞌ llzoa xto akeꞌ, naꞌ llzorén lwellj akeꞌ laꞌkze bi nchaynaꞌa akeꞌ, naꞌ llasoꞌt akeꞌ beꞌnne; ");
INSERT INTO zpuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naꞌ llban akeꞌ, naꞌ llzeraꞌll akeꞌ mell ke beꞌnn yobre, naꞌ llon akeꞌ da xhinnj, naꞌ lloeꞌ akeꞌ diꞌll wenraꞌlle, naꞌ llon akeꞌ da nak zdoꞌ, naꞌ llaxheꞌ akreꞌ beꞌnne, naꞌ llyirj akeꞌ xtiꞌll beꞌnne, naꞌ nak akeꞌ beꞌnn yaꞌraꞌlle, llon akeꞌ da ke llayaꞌl gon akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yeolol ka nak da xhinnj ki, ll-llach lo yichjraꞌlldaꞌo beꞌnnachenꞌ, naꞌ llonen leꞌe beꞌnn wen da xhinnj rao Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Naꞌ bazaꞌa Jesúsenꞌ zayejeꞌ ganꞌ nbane yell kaꞌ re Tiro naꞌ Sidón. Naꞌ byoeꞌ to lo yoꞌ bi gokraꞌlleꞌ nneze beꞌnne chaꞌ gannaꞌ bllineꞌ, bixha bi gok kwaꞌcheꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Le bnnezte to noꞌre, to beꞌnn zo to xhiꞌnneꞌ noꞌre, binꞌ yoꞌ daxiꞌo. Naꞌll zejdoeꞌ jacheꞌk xhibeꞌ raweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Naꞌ noꞌr naꞌ, bi nakeꞌ beꞌnn Israel, nakeꞌ beꞌnn yell ganꞌ nziꞌi Sirofenicia; goꞌtyoereꞌ Jesúsenꞌ yebejeꞌ daxiꞌon yoꞌ xhiꞌnneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bixha Jesúsenꞌ lleꞌe leꞌe: —Zgaꞌtek llayaꞌl weꞌllo latj yerje xhiꞌnnllo kaꞌ, le bi naken wen siꞌrizllo danꞌ llao akbeꞌn, wzaꞌl-llon rao beꞌkw ak. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naꞌll balliꞌi noꞌrenꞌ xtiꞌlleꞌn, lleꞌe Leꞌe: —Kaꞌ naksen, Xa, zan wakse gao akbaꞌ blaꞌ daꞌo kaꞌ, llexj ganꞌ llbeꞌ xhiꞌnnllo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naꞌll lle Jesúsenꞌ noꞌrenꞌ: —Da li kwis kanꞌ neꞌon. Bayej naꞌ, ba ballojte daxiꞌon yoꞌ yichjraꞌlldaꞌo xhiꞌnnoꞌ noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bixha ka ballineꞌ rilleꞌn, ba ballojteꞌ daxiꞌon yoꞌ xhiꞌnneꞌn, naꞌ ba xhoatebeꞌ wen ganꞌ lltasbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bde naꞌ bazaꞌa Jesúsenꞌ ganꞌ nbane Tironꞌ, badeteꞌ ganꞌ nbane Sidón, naꞌ ganꞌ nbane Decápolis ballinteꞌ lloaꞌ nisdaꞌo Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Naꞌ jwaꞌa akeꞌ to beꞌnn kwell, naꞌ beꞌnn ni bi llak nneꞌe, naꞌll llaꞌtyoe akreꞌ Jesúsenꞌ laꞌ wxoaze taꞌkeꞌn yichjeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Naꞌll brej Jesúsenꞌ leꞌe tozeꞌ radj beꞌnn kaꞌ, naꞌ bcheꞌe leꞌe ga yobre, naꞌll bzeb xhbeneꞌ lo nay beꞌnnenꞌ, naꞌll bxhejeꞌ xheꞌn, naꞌ bdaneꞌ roll beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naꞌll blis raweꞌn llwieꞌ yebáre, llabanreꞌ, naꞌ lleꞌe beꞌnnenꞌ: —¡Efata! —Lleꞌnen nen: ¡Bayarje! ");
INSERT INTO zpuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Naꞌ le bayarjte nay beꞌnnenꞌ, leskaꞌ bayak rolleꞌn, naꞌ gok banneꞌe kwasro. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Naꞌll goll Jesúsenꞌ leakeꞌ notno ye akeꞌ kanꞌ bayoneꞌ beꞌnnenꞌ. Naꞌ laꞌkze golleꞌ leakeꞌ kaꞌ, yezikre lloeꞌ beꞌnn kaꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Naꞌ le llabane beꞌnn kaꞌ, ne akeꞌ: —Le wen ba beneꞌ, llakteꞌ lloneꞌ nench yeyene beꞌnn kwell, naꞌ beꞌnn kaꞌ bi llak nneꞌe, llanné akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","To lla ka badop beꞌnn zan kwis, naꞌ beꞌnn kaꞌ bi de da gao akeꞌ, naꞌ Jesúsenꞌ goxheꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Llayaꞌchraꞌllaꞌ beꞌnn ki, ba gok chonn lla llaꞌrén akeꞌ lliꞌo, naꞌ bibi de gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naꞌ chaꞌ yeseꞌl akeꞌ kaꞌze, nxholl chaz akeꞌ da xchol do tnez, le bal akeꞌ zaꞌa akeꞌ ziꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Naꞌll lle beꞌnn kaꞌ Leꞌe: —¿Ga llélello da gao yeolol beꞌnn ki? Ganꞌ zollo ni naken to latj dach ga bibi dekze chras. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naꞌll bnnabreꞌ leakeꞌ: —¿Bale yet xtir noꞌxre? Naꞌll lle akeꞌ Leꞌe: —Gallen. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Naꞌll golleꞌ beꞌnn zan kaꞌ kweꞌ akeꞌ rao yo, naꞌll bxhieꞌ gall yet xtir kaꞌ, naꞌ beꞌe yel llioxken ke Dios; naꞌll bzoraweꞌ llxhoxhjen, naꞌll beꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ leakeꞌ jalek akeꞌ gaꞌa yet xtir kaꞌ rao beꞌnn zan kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Leskaꞌ de ye to chop bel daꞌo ak, naꞌ benlaꞌyebaꞌ, naꞌ beꞌebaꞌ leakeꞌ nench bdis akebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ka gok bdao akeꞌ, berj aktereꞌ kwasro, naꞌ batop akeꞌ da laꞌo kaꞌ bagaꞌnne, naꞌ goken ye gall llom. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Naꞌ beꞌnn kaꞌ bdaonꞌ, nak akeꞌ ka do tap mire. Bayoll naꞌ, naꞌll baseꞌe leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Naꞌ bayoeꞌ lo barco ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, ballín akteꞌ ganꞌ nbane Dalmanuta. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Naꞌ beꞌnn kaꞌ nziꞌi fariseo bzorao akeꞌ llaꞌdyiꞌ akeꞌ Leꞌe diꞌlle, llnnab akeꞌ goneꞌ to yel wak da yebán akreꞌ, naꞌll reꞌe akreꞌ chaꞌ da li zerén Diosenꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Naꞌ Jesúsenꞌ gokreꞌ to lo raꞌlldaꞌweꞌ, bneꞌe: —¿Bixchen llnnabre to da reꞌtere nench nnézere chaꞌ Diosenꞌ bseꞌl nadaꞌ? Diꞌll li niaꞌ, bi wroeꞌraꞌ reꞌ danꞌ llnnabrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Naꞌ bkwaꞌnneꞌ leakeꞌ, naꞌ bayoeꞌ lo barconꞌ zayejeꞌ ye chlaꞌre nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Beꞌnn kaꞌ non Jesúsenꞌ txhen gonraꞌll akeꞌ goꞌx akeꞌ da gao akeꞌ, tiꞌchga yet xtir noꞌx akeꞌ lo barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Naꞌll lle Jesúsenꞌ leakeꞌ: —Lewiá ke siꞌrizre kwa binn ke beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llon txhen Herodes naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Naꞌll bzorao lloeꞌrén lwellj akeꞌ diꞌll, ne akeꞌ: —Danꞌ bi noꞌxllo yet xtir naꞌn neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naꞌ Jesúsenꞌ gokbeꞌreꞌ ka diꞌllenꞌ lloeꞌrén lwellj akeꞌn, naꞌ lleꞌe leakeꞌ: —¿Bixchen lloeꞌre diꞌll ke danꞌ bi noꞌxre yet xtir naꞌ? ¿Bi nna chejnieꞌre bi zejen danꞌ niaꞌ kaꞌ? ¿Nchole yichjraꞌlldaꞌorenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Zote raore, naꞌ bi llreꞌre? ¿Zote nayre, naꞌ bi llénere? ¿Bi lljadinraꞌllre kanꞌ ba broeꞌraꞌ reꞌ yel wak kiaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kanꞌ bwawaꞌ gaꞌy mir beꞌnne ren gaꞌyze yet xtir, ¿bale llom da laꞌo batopre? Naꞌll lle akeꞌ Leꞌe: —Chllinnen (12). ");
INSERT INTO zpuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Leskaꞌn kone gall yet xtir naꞌ, bwawaꞌ tap mir beꞌnne. ¿Bale llom da laꞌo batopre? Naꞌll ne akeꞌ: —Gallen. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Naꞌll lleꞌe leakeꞌ: —¿Bi nna chejnieꞌre kanꞌ niaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ka bllin akeꞌ ganꞌ nziꞌi Betsaida naꞌ, le jwaꞌa akteꞌ to beꞌnn lchole raweꞌn, naꞌ goꞌtyoe akreꞌ Jesúsenꞌ chaꞌ kaneꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Naꞌll le beꞌxteꞌ taꞌk beꞌnn lcholenꞌ, naꞌ brejeꞌ leꞌe yell. Naꞌ btopeꞌ xheꞌn raweꞌn, naꞌll bxoa taꞌkeꞌn yichjeꞌ, naꞌ llnnabreꞌ leꞌe chaꞌ llreꞌreꞌ raꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Naꞌ beꞌnnenꞌ nak beꞌnn lcholenꞌ lleꞌe Leꞌe: —Llreꞌraꞌ beꞌnn kaꞌ nak akeꞌ ka yay, naꞌ zaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Naꞌll bdaꞌa taꞌk Jesúsenꞌ raweꞌn da yobre, naꞌ beneꞌ nench bareꞌreꞌ, naꞌ gok bareꞌreꞌ kwasro. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Naꞌ baseꞌleꞌ leꞌe rilleꞌ, lleꞌe leꞌe: —Bi lljadaꞌo lyell, naꞌ notno weꞌrenoꞌ diꞌll kanꞌ bayonaꞌ rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Naꞌ le byejte Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen yell daꞌo kaꞌ zjalliꞌ do ganꞌ nbane Cesarea de Filipo. Ka zjakeꞌ tnez naꞌn, bnnabreꞌ beꞌnn kaꞌ nao Leꞌen: —¿Bi ne beꞌnn kaꞌ noxha nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Naꞌll balliꞌi akeꞌ xtiꞌlleꞌn lle akeꞌ Leꞌe: —Bal akeꞌ ne akeꞌ rweꞌn Juan beꞌnnenꞌ bchoa nis. Naꞌ ye bal akeꞌ ne akeꞌ Elíasenꞌ. Ye baleꞌ ne akeꞌ nakoꞌ to beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naꞌll lleꞌe leakeꞌ: —¿Bixha ne reꞌ? ¿Noxha nadaꞌ? Naꞌll lle Pedronꞌ Leꞌe: —Rweꞌn Cristo beꞌnn bseꞌl Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Naꞌll golleꞌ leakeꞌ, nono weꞌrén akeꞌ diꞌll chat Leꞌen Cristo. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ka bzorao Jesúsenꞌ bzejnieꞌreꞌ leakeꞌ kanꞌ gak keꞌen, lleꞌe leakeꞌ: —Dekz de wsaꞌkziꞌ akeꞌ nadaꞌ, nakaꞌ Beꞌnn Gorj Radj Beꞌnnach. Beꞌnn gor brao ke beꞌnn Israel kaꞌ, naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, bi choꞌraꞌll akeꞌ nadaꞌ, naꞌ got akeꞌ nadaꞌ, naꞌ wayón lla naꞌ, wabanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kwasro llzejnieꞌreꞌ leakeꞌ kanꞌ gak keꞌen. Naꞌll brej Pedronꞌ Leꞌe radj beꞌnn kaꞌ, bzoraweꞌ dileꞌ Leꞌe danꞌ neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Naꞌ Jesúsenꞌ bayechjeꞌ llwiatezeꞌ beꞌnn kaꞌ, benreꞌ Pedronꞌ znia lleꞌe leꞌe: —¡Babiꞌy kaꞌle, llonzoꞌ ka llon daxiꞌore! Bi llbek yichjoꞌ danꞌ lleꞌne Dios, llbek yichjzoꞌ danꞌ lleꞌne beꞌnnachre. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naꞌll goxheꞌ beꞌnn kaꞌ non Leꞌe txhen, naꞌ yezikre beꞌnn kaꞌ nao Leꞌen, naꞌ lleꞌe leakeꞌ: —Noteze beꞌnne chaꞌ lleꞌnreꞌ gakeꞌ nadaꞌ txhen, llayaꞌl wsanraꞌll kwineꞌ, naꞌ goneꞌ ka to beꞌnn noaꞌ cruz keꞌe, naꞌ naweꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Noteze beꞌnn lleꞌnreꞌ yesrá yel nban ke kwineꞌ yellrio ni, wniteꞌn, naꞌ noteze wnit yel nban keꞌen ni kiaꞌ nadaꞌ, naꞌ ni ke xtiꞌllaꞌ naꞌ, leꞌen gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Bixha zaꞌken naꞌ, chaꞌ to beꞌnne goneꞌ gan doxhente da de rao yellrio, naꞌ kweyieꞌ, bi gaꞌt yel nban zejlikane keꞌe? ");
INSERT INTO zpuNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Bi kone gaꞌweꞌ yel nban naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Noteze beꞌnne chaꞌ wayeꞌreꞌ ni kiaꞌ nadaꞌ, leskaꞌ ke xtiꞌllaꞌn rao beꞌnn wen da xhinnj kaꞌ llaꞌa nnaꞌ, beꞌnn kaꞌ ba bsanraꞌll Dios, leskaꞌ nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, wayeꞌraꞌ ke beꞌnn kaꞌ katenꞌ yedaꞌ nsaꞌa yel banez ke Xaꞌ Diosenꞌ kate yedrenaꞌ angl keꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Leskaꞌ lle Jesúsenꞌ leakeꞌ: —Diꞌll li niaꞌ reꞌ, balre llaꞌa ganni nnaꞌ, nna nbanre kate llin lla reꞌre Diosenꞌ, wroeꞌ yel wak xhen keꞌen kanꞌ llnebieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bde xop lla, goxh Jesúsenꞌ Pedronꞌ, naꞌ Jacobonꞌ, naꞌ ren Juan naꞌ, naꞌ bcheꞌe leakeꞌ to rao yaꞌ sibe, naꞌ nollre no bcheꞌe akeꞌ. Naꞌ llwia akteꞌ naꞌ, kate bllaꞌa yichjrao Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naꞌ xharaꞌneꞌn goken llaktit, goken llich kwis kaꞌkze beye, ni to nono gakse gon len kanꞌ goken naꞌ, laꞌkze llebraz chiben. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Naꞌ breꞌe akreꞌ da Elías ren da Moisés lloeꞌrén akeꞌ Jesúsenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Naꞌll Pedronꞌ lleꞌe Jesúsenꞌ: —Maestro, le wen zollo ganni. Naꞌ gontoꞌ chonn yoꞌ de yixh, to koꞌo rweꞌ, naꞌ to ke Moisés, naꞌ ye to ke Elías naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Naꞌ ni ke llakbeꞌzreꞌ binꞌ neꞌe, do llebtit akeꞌ danꞌ llreꞌe akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kat blleꞌ to bej ganꞌ llaꞌa akeꞌn byechjen leakeꞌ, naꞌ lo bej naꞌ, ben akreꞌ bne Diosenꞌ: —Beꞌnn ninꞌ, xhiꞌnnaꞌ nllieꞌraꞌ, llayaꞌl wzenayre keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ka bwiado akeꞌ da yobre nollno breꞌe akreꞌ. Ye toze Jesúsenꞌ ze. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ka llayetj akeꞌ leꞌ yaꞌ naꞌ, golleꞌ leakeꞌ bi weꞌe akeꞌ diꞌll ka danꞌ breꞌe akreꞌn, lleꞌe leakeꞌ: —Kat yebanaꞌ radj beꞌnn wat kaꞌ, nadaꞌ nakaꞌ Beꞌnn Gorj Radj Beꞌnnach, kanaꞌll wak weꞌre diꞌll kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Naꞌ kaꞌ ben akeꞌ, bi beꞌe akeꞌ diꞌll, naꞌ bi byejnieꞌ akreꞌ danꞌ golleꞌ leakeꞌ danꞌ yebaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Naꞌll bnnab akreꞌ Leꞌe: —¿Bixchen nerize beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, zgaꞌtek da Elías naꞌn de yedeꞌ yellrionꞌ ka za yedre Cristonꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Naꞌllenꞌ ballieꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —Da likzenꞌ zgaꞌtek da Elías naꞌkze yedeꞌ nench yeweꞌ xhnneze danꞌ llak rao yellrio; leskaꞌ nyojen ka nak Beꞌnnenꞌ Gorj Radj Beꞌnnachenꞌ wsaꞌkziꞌ akeꞌ Leꞌe, naꞌ gon akeꞌ Leꞌe kaze. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ni niaꞌ reꞌ, ba bedkze da Elíasenꞌ, naꞌ ben akreꞌ leꞌe kon ka nen ke akeꞌ, le kanꞌ ba nyojkzen gak keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bixha ka ballín Jesúsenꞌ ganꞌ llaꞌa beꞌnn kaꞌ yelaꞌ non Leꞌe txhen naꞌ, breꞌreꞌ beꞌnn zan nechj leakeꞌ, naꞌ zjazé beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ llakyollrén akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kate breꞌe akreꞌ Leꞌen llabán akreꞌ, naꞌll jakdoeꞌ jawap akeꞌ Leꞌe lliox. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Naꞌll bnnabreꞌ leakeꞌ: —¿Bi ken llakdilrenre beꞌnn kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Naꞌ blloj to beꞌnne radj beꞌnn zan kaꞌ, lleꞌe Jesúsenꞌ: —Maestro, ganni nchiaꞌ to xhiꞌnnaꞌ yoꞌbeꞌ daxiꞌo, naꞌ nonen lebeꞌ blloj. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kon ka zezbeꞌ lloꞌxen lebeꞌ llxizen lebeꞌ, llarj pep blliꞌn lloaꞌbeꞌ, naꞌ llaoxoxj laybeꞌ, naꞌ zjazé llyechbeꞌ. Naꞌ gollaꞌ beꞌnn kaꞌ non rweꞌ txhen naꞌ, chaꞌ yebej akeꞌ daxiꞌon, naꞌ bi gok akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Naꞌll lle Jesúsenꞌ leakeꞌ: —¡Reꞌ nakre beꞌnn zid bi llejleꞌre! ¿Bate zerenaꞌ reꞌ? Naꞌ naraꞌchk ye arte soeraꞌ serenaꞌ reꞌ. Ledá waꞌa bidaꞌon ganni. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naꞌll jwaꞌa akeꞌ bidaꞌon, bixha daxiꞌon yoꞌ bidaꞌon, ka breꞌen Jesúsenꞌ bxizen bidaꞌon res kwis, bzalen lebeꞌ lltolen lebeꞌ, llalj pep blliꞌn lloaꞌbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Naꞌll llnnabeꞌ Jesúsenꞌ xabeꞌn: —¿Artxha ba gok llonen lebeꞌ ki? Naꞌll lleꞌe Leꞌe: —Ka nakbeꞌ bidaꞌote. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Naꞌ da zan ras ba bzalen lebeꞌ do lo yiꞌ do lo nis, to lleꞌnen wlleyiꞌn lebeꞌ. Chaꞌ rweꞌ wak wayonobeꞌ, naꞌ bayaꞌchraꞌll netoꞌ bayonbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Naꞌll lle Jesúsenꞌ leꞌe: —Wakse kon chaꞌ llonliraꞌlloꞌ, beꞌnnenꞌ llejleꞌn wakse danꞌ llnnabeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Le balliꞌte xa bidaꞌon xtiꞌlleꞌn, lleꞌe Leꞌe: —¡Llejliaꞌ; gokrén nadaꞌ gonliraꞌllaꞌ yezikre! ");
INSERT INTO zpuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ka breꞌe Jesúsenꞌ ba llaꞌll beꞌnn zanlle, naꞌll bdileꞌ daxiꞌon yoꞌ bidaꞌon lleꞌen: —Daxiꞌo, rweꞌn nonoꞌ bidaꞌon blloje naꞌ nkwellbeꞌ, naꞌ llepaꞌ rweꞌ yellojoꞌ chras lo yichjraꞌlldaꞌo bidaꞌon. Bsanbeꞌ, naꞌ bill wayoꞌ yichjraꞌlldaꞌobeꞌn da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Daxiꞌon besiaꞌn, naꞌ ye to bxizen bidaꞌon ziꞌllo, naꞌll ballojen; kaꞌkze bi wat bkwaꞌnnen lebeꞌ. Ka breꞌe beꞌnn kaꞌ llaꞌa naꞌ, naꞌll ne akeꞌ: —Baje gotbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naꞌ Jesúsenꞌ beꞌxeꞌ taꞌkbeꞌn balisebeꞌ, bazollaꞌtebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Naꞌll ka byoꞌ Jesúsenꞌ lo yoꞌ, beꞌnn kaꞌ non Leꞌe txhen naꞌ, jannab akreꞌ Leꞌe to wrazeꞌ, lle akeꞌ Leꞌe: —¿Bixchen bi gok netztoꞌ yebejtoꞌ daxiꞌon? ");
INSERT INTO zpuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Naꞌll lleꞌe leakeꞌ: —Nench gak yebejre ka daxiꞌon llon ki, llayaꞌl weꞌlaꞌllre yelwillre Diosenꞌ naꞌ gonre was. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ka bazaꞌa akeꞌ gannaꞌ, badé akeꞌ ganꞌ nbane Galilea, naꞌ Jesúsenꞌ bi gokraꞌlleꞌ no nneze chaꞌ deꞌe gannaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Le llzejnieꞌreꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, lleꞌe leakeꞌ: —Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, dekz de gakaꞌ rallnaꞌa beꞌnne kaꞌ llwie nadaꞌ got akeꞌ nadaꞌ, naꞌ yeyoll got akeꞌ nadaꞌ, naꞌ yeyónn lla yebanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naꞌ beꞌnn kaꞌ chras bi byejnieꞌ aksereꞌ bi ken neꞌe kaꞌ, to lleb akzeꞌ wnnab akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Naꞌ bllin akeꞌ Capernaum, ka ba zo akeꞌ yoꞌ naꞌ, bnnabe Jesúsenꞌ leakeꞌ: —¿Bi diꞌllenꞌ lloeꞌzre beche? ");
INSERT INTO zpuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Leakeꞌn bibi bne akseꞌ, to bze akeꞌ llize llak zban akreꞌ, le ka bechre zaꞌke tnez naꞌn, llakdil akeꞌ norenꞌ nakll beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Naꞌll blleꞌ Jesúsenꞌ, naꞌ goxheꞌ beꞌnn chllinn kaꞌ, naꞌ lleꞌe leakeꞌ: —Kon to reꞌ chaꞌ lleꞌnere gakre beꞌnn brao, llayaꞌl gakre ka to beꞌnn bibi zaꞌke ga zeraoze, naꞌ gakre beꞌnn wzeniaꞌnaꞌa lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naꞌll goxheꞌ to bidaꞌo, bzeꞌebeꞌ kllol akeꞌn, naꞌ bdeꞌlebeꞌ lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Noteze beꞌnne gonre bidaꞌo wen, ni kiaꞌ nadaꞌ, nadkzaꞌn llonreꞌ wen chet kaꞌ, naꞌ beꞌnne lloneꞌ wen ren nadaꞌ, kere nadaꞌn llonreꞌ wen, beꞌnnenꞌ bseꞌl nadaꞌn llonreꞌ wen. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Naꞌll Juan naꞌ, lleꞌe Jesúsenꞌ: —Maestro, breꞌtoꞌ to beꞌnn llabejeꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne kone raꞌo rweꞌ, naꞌ bi noneꞌ lliꞌo txhen, naꞌ golltoeꞌ bi goneꞌ kaꞌ, le bi naweꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bi wllonre goneꞌ kaꞌ, chaꞌ to beꞌnne lloneꞌ yel wak llwaꞌleꞌ raꞌa, zeje diꞌll txhen naꞌ lloneꞌ nadaꞌ, bi gak nneꞌe krere kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chaꞌ to beꞌnne bi llwiereꞌ lliꞌo, txhenkzenꞌ nakeꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Noteze beꞌnne chaꞌ gonneꞌ laꞌ txhiꞌyze nis yeꞌjre, ni ke danꞌ nonre nadaꞌ txhen, da li niaꞌ reꞌ, bi nnitrao ka nake danꞌ gon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Leskaꞌ bne Jesúsenꞌ: —Noteze beꞌnn goneꞌ bix to bidaꞌo ki nxenraꞌll nadaꞌ gonbeꞌ da xhinnjenꞌ, naktere wen wchej akeꞌ yeneꞌ to yej yich, naꞌ lljazaꞌl akeꞌ leꞌe lo nisdaꞌo, kerke da goneꞌ bix to bidaꞌo ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chaꞌ to taꞌkre llxhoben reꞌ gonre da xhinnjenꞌ, wenre chenak wchoyren, kerke da gonre da xhinnjenꞌ, wenre yellinre ganꞌ de yel nban naꞌ, yallj chlaꞌ taꞌkrenꞌ, kerke da zo llopten wayejre lo gabil ga llaꞌlnninn yiꞌ da nono soekze yesor len. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gannaꞌ llaꞌa waraꞌo ba bi llat, leskaꞌ yiꞌ da bi llayore. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chaꞌ niaꞌrenꞌ llxhoben reꞌ gonre da xhinnjenꞌ, wenre chenak wchoyren, kerke da gonre da xhinnjenꞌ, wenre yellinre ganꞌ de yel nban naꞌ, yallj chlaꞌ niaꞌre, kerke da zo llopten wayejre gabil ga llaꞌlnninn yiꞌ da nono soekze yesor len. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gannaꞌ llaꞌa waraꞌo ba bi llat, naꞌ yiꞌ da bi llayorkze. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chaꞌ danꞌ llreꞌe raorenꞌ llxhoben reꞌ nench gonre da xhinnjenꞌ, wenre chenak kwejre yejraorenꞌ, kerke da gonre da xhinnjenꞌ, wenre yedoꞌlere ganꞌ llnebiaꞌ Diosenꞌ kon ren chlaꞌze raorenꞌ, kerke da zo llopten yeseꞌleꞌ reꞌ gabil. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gannaꞌ llaꞌa waraꞌo ba bi llat, naꞌ yiꞌ da bi llayore. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Yeolol beꞌnne te akeꞌ gak akeꞌ prueb, naꞌ yeololte beꞌnn wayón kwineꞌ rallnaꞌa Dios, gak akeꞌ ka da nweꞌe zeꞌde. ");
INSERT INTO zpuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Da wen zeꞌdenꞌ, zan chaꞌ nit yel znaꞌ ken, billbi de gonre nench wayaken zich. Naꞌ legón reꞌ ka zeꞌd naꞌ, legón da wen, naꞌ lesorén lwelljre wen. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bde naꞌ, bzaꞌa Jesúsenꞌ Capernaum, naꞌ byejeꞌ ganꞌ nbane Judea, balaꞌyeꞌ ye chlaꞌ yeo Jordán naꞌ. Naꞌ da yobre bllay beꞌnn zan kwis ganꞌ zoeꞌn, naꞌ bzoraweꞌ llzejnieꞌreꞌ leakeꞌ kanꞌ llonkzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Naꞌ bal beꞌnn fariseo kaꞌ jabiꞌy akeꞌ, naꞌ llnnab akreꞌ Leꞌe chaꞌ naken wen beꞌnn kaꞌ nchaynaꞌa wsan noꞌr ke akeꞌ. Lle akeꞌ Leꞌe kaꞌ, le lleꞌn akreꞌ kwej akeꞌ Leꞌe diꞌll nench akre nneꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesúsenꞌ lleꞌe leakeꞌ: —¿Akxha ne ley danꞌ bzoj da Moisésenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Naꞌll bne akeꞌ: —Da Moisésenꞌ beꞌe latj wsanraꞌll lwellj akeꞌ, naꞌ chaste to yich weꞌn diꞌll baraꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesúsenꞌ ballieꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —Yel yichjraꞌlldaꞌo zid keré naꞌn, beꞌe da Moisésenꞌ latj gonre kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Zan da nell ka bxhe yellrionꞌ, “Diosenꞌ beneꞌ beꞌnn byio ren noꞌre.” ");
INSERT INTO zpuNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ke len naꞌ bneꞌe: “Beꞌnn byio yereꞌe kwit xaxhneꞌe, naꞌ sieꞌ noꞌre, ");
INSERT INTO zpuNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","naꞌ chop akeꞌ gak akeꞌ ka toze beꞌnn.” Naꞌllenꞌ bill nak ke ke akeꞌ, ba nak akeꞌ toze beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ke len naꞌ, beꞌnn ba bkoꞌd Diosenꞌ, bi gak yelaꞌa beꞌnnach leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ka ballín akeꞌ yoꞌ naꞌ, beꞌnn kaꞌ non Leꞌe txhen naꞌ, bnnab akeꞌ da yobre kanꞌ goll beꞌnn kaꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naꞌll lleꞌe leakeꞌ: —Noteze beꞌnn chaꞌ wsanraꞌll xhoꞌreꞌ, naꞌ sieꞌ ye to noꞌr yobre, da xhinnj xhen naꞌ lloneꞌ ke xhoꞌreꞌ, llonkzeꞌ ka beꞌnn zo xto. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Leskaꞌ noꞌrenꞌ chaꞌ wsanraꞌll xhyiweꞌ, naꞌ sieꞌ ye to beꞌnn yobre, leskaꞌ llonkzeꞌ ka beꞌnn zo xto. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Naꞌll jwaꞌa akeꞌ bidaꞌo ak rao Jesúsenꞌ nench kaneꞌ yichj akbeꞌ, naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, ben akreꞌ beꞌnn kaꞌ znia. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka breꞌe Jesúsenꞌ kanꞌ llon akeꞌn, goklleꞌe leakeꞌ, naꞌ golleꞌ leakeꞌ: —Leweꞌe latj yed bidaꞌo kaꞌ rawaꞌ ni, bi wllonre; le beꞌnn kaꞌ nak ka bidaꞌo ki, leakeꞌn nak Diosenꞌ txhen beꞌnn llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da li niaꞌ reꞌ, noteze beꞌnne chaꞌ bi goneꞌ ka llon bidaꞌo ki nxenraꞌll akbeꞌ nadaꞌ, ni ke gakzeꞌ gakeꞌ Diosenꞌ txhen beꞌnnenꞌ llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naꞌll bdeꞌleꞌ toto bidaꞌo kaꞌ, bxoa taꞌkeꞌn yichj akbeꞌn, naꞌ benlaꞌyeꞌ leakbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ka broꞌ Jesúsenꞌ nez, zejdo to beꞌnn weꞌo jacheꞌk xhibeꞌ raweꞌn, naꞌ llnnabreꞌ Leꞌe: —Maestro, nakoꞌ beꞌnn wen kwis, ¿akre gonaꞌ nench gaꞌt yel nban zejlikane kiaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsenꞌ golleꞌ Leꞌe: —¿Bixchen llezoꞌ nadaꞌ beꞌnn wen? Nono beꞌnn wen llraꞌ, toze Diosenꞌ nak beꞌnn wen. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Rweꞌ nnezkzroꞌ binꞌ ne Diosenꞌ gonllo: “Bi tarenoꞌ wde wdere noꞌre, bi gakoꞌ beꞌnn wen xhia, bi kwanoꞌ, bi wxoaꞌo da xhinnj koꞌll beꞌnne da bi beneꞌ, bi siyeꞌo, bdap baraꞌnn xaxhnaꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Naꞌll lleꞌe Leꞌe: —Maestro, yeolol da ki llonaꞌ ka nna naktiaꞌ xkwiꞌdte. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Naꞌll Jesúsenꞌ bwieꞌ leꞌe, llakreꞌ leꞌe, lleꞌe leꞌe: —Ye toze da yallj gonoꞌ; bayej jayeꞌt yeolol da de koꞌo, naꞌ mell danꞌ goꞌtoꞌn naꞌ, beꞌen beꞌnn yaꞌch, naꞌll gaꞌt yel wniaꞌ koꞌo yebá, naꞌtell yedoꞌ nnaoꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bixha ka benreꞌ kaꞌ, gokreꞌ kwis, zayejeꞌ llakreꞌ, le nakeꞌ beꞌnn wniaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Naꞌll bayechj Jesúsenꞌ bwieꞌ beꞌnn kaꞌ nechj Leꞌen, naꞌ lleꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ: —¡Bniꞌ kwis naken ke to beꞌnn wniaꞌ, weꞌe latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen naꞌ, llabán akreꞌ kwis kanꞌ bneꞌen, naꞌ bne Jesúsenꞌ ye to, lleꞌe leakeꞌ: —Reꞌ, xhiꞌnnaꞌ, bniꞌ kwis naken ke beꞌnn kaꞌ nxenraꞌll yel wniaꞌ ke akeꞌn, weꞌe akeꞌ latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sétere te to bayiꞌxe banꞌ nziꞌi camello lo nay yeꞌchich, kerke to beꞌnn wniaꞌ weꞌe latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naꞌ llabán akreꞌ kwis kanꞌ ben akreꞌ bneꞌen, naꞌll lle lwellj akeꞌ: —¿Noxha gakze yerá chaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesúsenꞌ llwieꞌ leakeꞌ, naꞌll bneꞌe: —Da li beꞌnnachenꞌ bibi gak goneꞌ, zan ka nak Diosenꞌ, yeololte llak lloneꞌ, bibi de da gakreꞌ bniꞌ goneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naꞌll Pedronꞌ lleꞌe Leꞌe: —Netoꞌ ba bsanraꞌlltoꞌ yeolol da de ketoꞌ nench naotoꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesúsenꞌ bneꞌe: —Diꞌll li llepaꞌ reꞌ, chaꞌ to beꞌnne bsanraꞌlleꞌ rilleꞌ, biꞌcheꞌ, zaneꞌ, xaxhneꞌe, noꞌr keꞌe, xhiꞌnneꞌ, yellrio keꞌe, ni kiaꞌ nadaꞌ nench wzenayeꞌ xtiꞌllaꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","zaꞌklle da wayoeꞌ Diosenꞌ leꞌe, da xhenll wayoeꞌ Diosenꞌ leꞌe, kerke da kaꞌ bsanraꞌlleꞌn, to gayoa (100) ras ke to danꞌ bnitenꞌ wayoeꞌ leꞌe, laꞌkze chaꞌ bllayraweꞌ, naꞌ kate llin lla naꞌ, weꞌe yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Naꞌ llepaꞌ reꞌ, beꞌnn zan nak akeꞌ ka beꞌnn lliarao nnaꞌ, wllin lla kat yeyak akeꞌ ka beꞌnn zaꞌa xhante, naꞌ beꞌnn kaꞌ nak akeꞌ ka beꞌnn zaꞌa xhante nnaꞌ, leakeꞌn yeyak akeꞌ ka beꞌnn lliarao. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ka yoꞌ akeꞌ nez, llep akeꞌ llin akeꞌ ganꞌ nziꞌi Jerusalén naꞌ, Jesúsenꞌ lliaraweꞌ rao beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌll llon akeꞌ yel wan nao akeꞌ lleb akeꞌ. Naꞌll da yobre Jesúsenꞌ goxheꞌ beꞌnn chllinn kaꞌ ga yobre, naꞌ bzorao lloeꞌreneꞌ leakeꞌ diꞌll kanꞌ gak keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Lleꞌe leakeꞌ: —Lewiake nnaꞌ, zejllo Jerusalén naꞌ, nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, gakaꞌ rao naꞌa bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ wchoy akeꞌ kiaꞌ gataꞌ, naꞌ gon akeꞌ nadaꞌ rao naꞌa beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Naꞌ wtitj akreꞌ nadaꞌ, chintat akeꞌ nadaꞌ, wxiꞌt akeꞌ xheꞌn yichjrawaꞌ, naꞌ got akeꞌ nadaꞌ. Naꞌ wayónn lla naꞌ yebanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobonꞌ ren Juan naꞌ, xhiꞌnn Zebedeonꞌ, jabiꞌy akeꞌ kwit Jesúsenꞌ, naꞌ lle akeꞌ Leꞌe: —Maestro, lleꞌnetoꞌ gonoꞌ to okré ketoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naꞌll lleꞌe leakeꞌ: —¿Bixhanꞌ lleꞌnere gonaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Naꞌll lle akeꞌ Leꞌe: —Lleꞌnetoꞌ kat ba llnebiaꞌo naꞌ, gonnoꞌ latj yedlleꞌtoꞌ chlaꞌ wej kwitoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesúsenꞌ lleꞌe leakeꞌ: —Bi llejnieꞌre bi danꞌ llnnabre. ¿Wchoyraꞌllre tere yel ziꞌ yel yaꞌ, ka danꞌ tiaꞌ nadaꞌ, gak keré kanꞌ gak kiaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Naꞌ bne akeꞌ: —Waktoꞌ. Naꞌll lleꞌe leakeꞌ: —Da likze tere yel ziꞌ yel yaꞌ, ka danꞌ tiaꞌ nadaꞌ, naꞌ gak keré kanꞌ gak kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Zan ka nak danꞌ kweꞌre chlaꞌ wej kwitaꞌn, kere nadaꞌ nniaꞌ no kweꞌ kwitaꞌn, Dios naꞌn ba brejeꞌ beꞌnn kaꞌ kweꞌ kwitaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ka bene beꞌnn ye chi kaꞌ yelaꞌ kanꞌ goll akeꞌ Leꞌen, gokllaꞌa akeꞌ Jacobonꞌ ren Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Naꞌ Jesúsenꞌ goxheꞌ leakeꞌ, naꞌ lleꞌe leakeꞌ: —Reꞌ nnézere ka beꞌnn kaꞌ llnebiaꞌ toto yell, llon akeꞌ wzenay beꞌnn kaꞌ nak rallnaꞌa akeꞌn, leskaꞌ beꞌnn kaꞌ nak beꞌnn brao, llnebiaꞌ akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Zan reꞌ bi gonre kaꞌ, chaꞌ reꞌ lleꞌnere gakre beꞌnn brao, llayaꞌl wxhexjraꞌllre gakrenre beꞌnn lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Naꞌ chaꞌ notezre lleꞌnere gakre beꞌnn lliarao, zgaꞌtek llayaꞌle gakre ka to beꞌnn wen llin ke beꞌnn lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Le nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, kere zaꞌa nench gakrén beꞌnn nadaꞌn, zaꞌa nench gakrenaꞌ beꞌnn kaꞌ, naꞌ llsanraꞌll kwinaꞌ got akeꞌ nadaꞌ, ni ke xtoꞌl beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naꞌ bllin akeꞌ yellenꞌ re Jericó. Naꞌ ka ba llalloj Jesúsenꞌ yell naꞌn ren beꞌnn kaꞌ non Leꞌe txhen, naꞌ yezikre beꞌnn zan, tnez naꞌ lliꞌ to beꞌnn lchole llnnabeꞌ lmoxh. Beꞌnn naꞌ re Bartimeo, naꞌ nakeꞌ xhiꞌnn to beꞌnn re Timeo. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ka gokbeꞌreꞌ badé Jesús beꞌnn Nazaretenꞌ tnezenꞌ, naꞌ bzoraweꞌ llosieꞌ neꞌe: —¡Jesús, xhiꞌnn dialla ke rey David, bayaꞌchraꞌll nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Naꞌll bene beꞌnn zan kaꞌ leꞌe znia nench kweꞌe llize, bixha beꞌnn lcholenꞌ yezikre besieꞌ bneꞌe: —¡Xhiꞌnn dialla ke rey David, bayaꞌchraꞌll nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Naꞌll brexh Jesúsenꞌ, naꞌ lleꞌe beꞌnn kaꞌ: —Legaxheꞌ nile. Naꞌ goxh beꞌnn kaꞌ leꞌe, lle akeꞌ leꞌe: —Bxenraꞌlle, bzollaꞌa, le llaxheꞌ rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Naꞌll bkwas beꞌnn lcholenꞌ raꞌllenꞌ xhoa koꞌlleꞌn, naꞌll zejdoeꞌ ganꞌ ze Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Naꞌll lleꞌe leꞌe: —¿Bixhanꞌ lleꞌnroꞌ gonaꞌ koꞌo? Naꞌll bne beꞌnn lcholenꞌ: —Maestro, lleꞌnraꞌ yereꞌraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Naꞌll lle Jesúsenꞌ leꞌe: —Bayej nnaꞌ, danꞌ nxenraꞌlloꞌ naꞌn ba basrá rweꞌ. Le bareꞌtereꞌ, naꞌll bnaweꞌ Jesúsenꞌ ganꞌ zejeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ka ba zjakeꞌ awlloze Jerusalén naꞌ, naꞌ bllin akeꞌ yell kaꞌ nziꞌi Betfagé, naꞌ Betania ganꞌ zo yaꞌ ganꞌ nziꞌi Yaꞌ Olivos. Naꞌ bseꞌl Jesúsenꞌ chop beꞌnn kaꞌ non Leꞌe txhen naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","lleꞌe leakeꞌ: —Lechejchk yell daꞌon lliꞌ chlaꞌ naꞌ, naꞌ kate choꞌre yellenꞌ, naꞌ lljatiꞌre to burr daꞌa yay, ni to nono nna kwia lebaꞌ, naꞌ wsellrebaꞌ, naꞌ yedsanterebaꞌ ganni. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chaꞌ lloj to beꞌnn nneꞌe: “¿Bixchen llonzre kaꞌ?”, naꞌ leyeꞌe: “Xantoꞌ naꞌ yálljrebaꞌ choll, le wadsántetobaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naꞌll byej akeꞌ, naꞌ le jatiꞌ aktereꞌ to burrenꞌ daꞌbaꞌ yay lloaꞌ yoꞌ da zo lloaꞌ nez, le bsell aktebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Naꞌ bal beꞌnn kaꞌ zjazé gannaꞌ, lle akeꞌ leakeꞌ: —¿Bixhanꞌ llonre? ¿Bixchen llsellrebaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Naꞌ goll akeꞌ leakeꞌ kanꞌ goll Jesúsenꞌ leakeꞌ naꞌ. Naꞌ beꞌe akeꞌ latj bcheꞌe akebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Naꞌll le bacheꞌe akteꞌ burrenꞌ ganꞌ ze Jesúsenꞌ, naꞌll bxoa akeꞌ no xha akeꞌ koꞌll burrenꞌ, naꞌll bllieꞌbaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Leskaꞌ beꞌnn zan zjakeꞌ llchirj akeꞌ no xha akeꞌ tnezenꞌ, naꞌ ye bal akeꞌ bchoy akeꞌ no xhoꞌz yay, naꞌ llyixj akeꞌn tnezenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Naꞌ beꞌnn kaꞌ lliarao, naꞌ beꞌnn kaꞌ nao Leꞌen, yeolol akeꞌ llosiaꞌ akeꞌ ne akeꞌ: —¡Doweꞌrao Dios! ¡Nak laꞌy beꞌnnenꞌ zaꞌa ganni beꞌnn bseꞌl Xanllo Diosenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Zeꞌe nnebieꞌ kanꞌ bnebiaꞌ xozxtaꞌollo David! ¡Doweꞌrao Dios zo yebá! ");
INSERT INTO zpuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Naꞌ bllin Jesúsenꞌ Jerusalén, naꞌ byoeꞌ liaꞌ yodaꞌo braonꞌ. Naꞌ bayoll bwieꞌ bayechjteꞌ, naꞌ le zayejteꞌ ganꞌ ne Betania ren beꞌnn chllinn kaꞌ, le ba nak ba wlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bateyó ka bazaꞌa akeꞌ Betanianꞌ bdon Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naꞌ ziꞌtre breꞌreꞌ to yay higo da llia laꞌye, naꞌll zejeꞌ llwieꞌ chaꞌ llian higo, bixha ka bllineꞌn kere bi llia danꞌ, laꞌyze llian le bi nna llin lla kwian. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naꞌll lle Jesúsenꞌ yay higonꞌ: —Chras nollno gaokze da xhixenꞌ llbiaꞌo. Naꞌ beꞌnn kaꞌ nao Leꞌen ben akreꞌ kanꞌ bneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bde naꞌ, bllin akeꞌ ganꞌ nziꞌi Jerusalén. Naꞌ ka byoꞌ Jesúsenꞌ liaꞌ yodaꞌo braonꞌ, naꞌ bzoraweꞌ llaraydoeꞌ beꞌnn kaꞌ llon yaꞌa, beꞌnn kaꞌ lloꞌt, naꞌ beꞌnn kaꞌ llaꞌo. Bzaleꞌ ganꞌ nkwaꞌa mell danꞌ llchaꞌa akeꞌ, leskaꞌ blloꞌnneꞌ ganꞌ llbeꞌ beꞌnn weꞌt plom kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nollno beꞌe latj te liaꞌ yodaꞌon, chaꞌ bi da noeꞌ goꞌteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naꞌll bzejnieꞌreꞌ leakeꞌ, lleꞌe leakeꞌ: —Kinꞌ nyoj xtiꞌll Diosenꞌ: “Rillaꞌn, naken ga lljak beꞌnn zaꞌa yeolol yell yelwill akeꞌ nadaꞌ”; naꞌ reꞌ, ba nonren ka to lo broj ke beꞌnn wan. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Beꞌnn kaꞌ nak bxoz wnebiaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, ben akreꞌ kanꞌ bneꞌe naꞌ, naꞌll llayirjlaꞌll akeꞌ akre ka gon akeꞌ nench got akeꞌ Leꞌe, le lleb akeꞌ Leꞌe, ka nak doxhente yell, llabán akreꞌ kanꞌ llzejnieꞌreꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naꞌ kate golenꞌ, le bazaꞌte Jesúsenꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tzir bateyó badé akeꞌ ganꞌ zo yay higonꞌ, naꞌ breꞌe akreꞌ byechte do roe. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedronꞌ jadinraꞌlleꞌ kanꞌ goll Jesúsenꞌ yayenꞌ, naꞌ lleꞌe Leꞌe: —Maestro, bwiakeroꞌ yay higonꞌ danꞌ benoꞌ deꞌen byechte kaꞌzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsenꞌ ballieꞌ xtiꞌlleꞌn lleꞌe leꞌe: —Lewxenraꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Diꞌll likze llniaꞌ reꞌ, notezre chaꞌ yere yaꞌn zo gannaꞌ: “Bkwas naꞌ jasó lo nisdaꞌo”, naꞌ bi gakgánere naꞌ wxenraꞌllre, wakte kanꞌ nerenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ke len naꞌ niaꞌ reꞌ, biteze da wnnabre ka yelwillre Diosenꞌ, chaꞌ wxenraꞌllre do yichj do raꞌllre, gonteꞌ danꞌ nnabrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Naꞌ katenꞌ yelwillre Diosenꞌ, leyeziꞌxhen ke no beꞌnne chaꞌ bi benreꞌ reꞌ nench lekze kaꞌ, Xallo Diosenꞌ beꞌnn zo yebá yeziꞌxheneꞌ da xhinnj ke reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Zan chaꞌ reꞌ bi yeziꞌxhenre ke beꞌnne, Xallo Dios zo yebá bi yeziꞌxheneꞌ ka da xhinnj ke reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Naꞌll ballín akeꞌ Jerusalén naꞌ da yobre, naꞌ chak dá Jesúsenꞌ liaꞌ yodaꞌo braonꞌ, jabiꞌy bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke leyenꞌ, naꞌ ren beꞌnn gor brao ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Naꞌll lle akeꞌ Leꞌe: —¿Bi yel llnebiaꞌ napoꞌ llonoꞌ da ki? ¿No benn yel llnebiaꞌ llonoꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsenꞌ ballieꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —Leze de to da nnabraꞌ reꞌ, naꞌ chaꞌ yelliꞌre xtiꞌllaꞌn, naꞌll yepaꞌ reꞌ bi yel llnebiaꞌn llonaꞌ da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Noxhanꞌ bseꞌl Juan naꞌ, beꞌnnenꞌ bchoa beꞌnn nis? ¿Diosenꞌ bseꞌl leꞌe o chaꞌ beꞌnnachenꞌ? Leyelliꞌi xtiꞌllaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Naꞌll lloeꞌrén lwellj akeꞌ diꞌll, ne akeꞌ: —Chaꞌ nnello Dios bseꞌl leꞌe, naꞌ yeꞌe lliꞌo: “¿Bixchen ke byejleꞌre ke leꞌe chaꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naꞌ leskaꞌ chaꞌ nnello beꞌnnachenꞌ bseꞌl leꞌe, bi gak. Kaꞌ bne akeꞌ, le lleb akeꞌ beꞌnn yell, le yeolol akeꞌ byejleꞌ akeꞌ da li Diosenꞌ bseꞌl Juan naꞌ, nench beꞌe xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Naꞌll lle akeꞌ Jesúsenꞌ: —Bi nnézetoꞌ. Naꞌll Jesúsenꞌ lleꞌe leakeꞌ: —Leskaꞌ nadaꞌ bi yepaꞌ reꞌ no benn nadaꞌ yel llnebiaꞌn da llonrenaꞌ ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesúsenꞌ bzorao llzejnieꞌreꞌ leakeꞌ, llsaꞌkrebreꞌ da kaꞌ neꞌe: —To beꞌnn gozeꞌ lba uvas, naꞌ bzechjeꞌn reꞌje, naꞌ beneꞌ to ga wsieꞌ uvas kaꞌ, naꞌ beneꞌ to yoꞌ sib ga lljasé beꞌnn gap len. ’Naꞌll bkwaꞌnneꞌ yellrionꞌ lo naꞌa beꞌnn wia akeꞌn de achj wej, naꞌll broeꞌ nez zejeꞌ ziꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kate bllin lla wachib akeꞌ uvas kaꞌ, baseꞌleꞌ to beꞌnn wen llin keꞌen nench lljaxhieꞌ ka to da llayaꞌleꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Naꞌ beꞌnn wen llin kaꞌ beꞌx akeꞌ leꞌe, ben akeꞌ ziꞌ keꞌe, naꞌ baseꞌl akeꞌ leꞌe bibi bayoeꞌ akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naꞌll xan yellrionꞌ bseꞌleꞌ beꞌnn yobre; leskaꞌ bdaꞌa akeꞌ leꞌe yej, ben akteꞌ weꞌe yichjeꞌ, ye to chiꞌi bchachrén akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Naꞌll baseꞌlkzeꞌ beꞌnn yobre, naꞌ leskaꞌ bet akteꞌ leꞌe. Naꞌll baseꞌleꞌ beꞌnn zan, leskaꞌ bal beꞌnn kaꞌ ben akeꞌ ziꞌ ke akeꞌ, naꞌ ye baleꞌ basoꞌt akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Naꞌ zo ye to xhiꞌnn kwineꞌ bi tiꞌche nllieꞌreꞌ kwis, naꞌ bayoll naꞌ, lleꞌn ke lleꞌnreꞌ bseꞌlebeꞌ neꞌe: “Xhiꞌnnaꞌ ni wap akjebeꞌ baraꞌnne.” ");
INSERT INTO zpuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bixha beꞌnn kaꞌ nlan lba uvas kaꞌ, ka breꞌe akreꞌ xhiꞌnneꞌn, naꞌll lle lwellj akeꞌ: “Beꞌnn ninꞌ xhiꞌnn xan reꞌjenꞌ, lebeꞌ yegaꞌnn ren danꞌ de ke xabeꞌn, ledá gotllobeꞌ naꞌ gak danꞌ kello.” ");
INSERT INTO zpuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Naꞌll bzap akebeꞌ, bet akebeꞌ, brej akebeꞌ lo reꞌjenꞌ jazaꞌl aktebeꞌ koꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Naꞌll Jesúsenꞌ bnnabreꞌ leakeꞌ: —¿Akre ka llákere? ¿Akre gon xan yellrionꞌ ke beꞌnn kaꞌ? Chej kwineꞌ wlleyieꞌ ke beꞌnn wen llin kaꞌ, naꞌ yeyoneꞌ yellrionꞌ rallnaꞌa beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Bi nna wrabre kanꞌ nyoj xtiꞌll Diosenꞌ? Nen: Yej danꞌ bi byoꞌraꞌll beꞌnn wen yoꞌ kaꞌ, gonrén akeꞌ llin, len naꞌ ba naken yej skin. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Da ni ben Xanllo Diosenꞌ, naꞌ naken zi yebánello. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naꞌll gokraꞌll akeꞌ goꞌx akeꞌ Leꞌe, ka bayejnieꞌ akreꞌ ke leakeꞌn beꞌe diꞌllenꞌ nak kaꞌ; naꞌ blleb akeꞌ beꞌnn yell, naꞌ bsan akeꞌ bibi ben akreꞌ Leꞌe, naꞌ zjayakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Naꞌ bseꞌl akeꞌ bal beꞌnn fariseo kaꞌ, naꞌ ye bal beꞌnn kaꞌ non txhen Herodes naꞌ, nench lljalej akeꞌ diꞌll lloaꞌ Jesúsenꞌ, naꞌ gaꞌt da lljataorén akeꞌ xhia. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka bllin akeꞌ ganꞌ zoeꞌn, naꞌll lle akeꞌ Leꞌe: —Maestro, nnézetoꞌ nakoꞌ beꞌnn lloeꞌ diꞌll li, bi llziꞌo lloaꞌ xtiꞌll beꞌnnach, naꞌ toz ka llonroꞌ yeolol beꞌnne, naꞌ llroeꞌroꞌ lixhej kanꞌ zej xhnnez Diosenꞌ. ¿Llonen bien chixhjtoꞌ da llnnab beꞌnnenꞌ nak le zeraoze wnebiaꞌ, beꞌnnenꞌ llia Roma? ¿Wyixhjtoꞌn o chaꞌ bi chixhjtoꞌn? ¿Bi ka nezoꞌ rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Naꞌ le bayakbeꞌtereꞌ kere do raꞌll akeꞌn llnnab akreꞌ Leꞌe, naꞌll lleꞌe leakeꞌ: —¿Bixchen lleꞌnere kwejre nadaꞌ diꞌlle? Lewroeꞌchk nadaꞌ to xhmellrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Naꞌll broeꞌ akreꞌ Leꞌe ton, ka breꞌreꞌ mellenꞌ, naꞌll lleꞌe leakeꞌ: —¿Noxha raonꞌ daꞌa leꞌ mell ni? ¿No ranꞌ nyoj leꞌ ni? Naꞌll lle akeꞌ Leꞌe: —Ke César, beꞌnnenꞌ llnebiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Naꞌll lle Jesúsenꞌ leakeꞌ: —Da nak ke César lewayoeꞌn leꞌe; naꞌ da llayaꞌl weꞌre Dios, leweꞌn Dios. Naꞌ llabán akreꞌ kanꞌ ballieꞌ xtiꞌll akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Naꞌll beꞌnn saduceo kaꞌ jakeꞌ raweꞌn. Naꞌ beꞌnn ki ne akeꞌ bi de yebán beꞌnn watenꞌ, naꞌll bnnab akreꞌ Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, da Moisésenꞌ bzojeꞌ chaꞌ to beꞌnn byio gateꞌ, naꞌ bagaꞌnn noꞌr keꞌe, naꞌ nono xhiꞌnn akeꞌ bzo, naꞌ beꞌnn biꞌch beꞌnn wat naꞌ, llayaꞌl yezieꞌ noꞌr wazeb naꞌ, nench nniꞌt xhiꞌnn dialla ke biꞌcheꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Naꞌ bzo gall biꞌch ake, beꞌnn nelle bchayneꞌe, naꞌ le gotteꞌ nono xhiꞌnneꞌ bzo. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Beꞌnn wllope naꞌ, le baziꞌteꞌ noꞌrenꞌ, naꞌ leskaꞌ le gotteꞌ nono xhiꞌnneꞌ bzo. Naꞌll baziꞌi beꞌnn wyonne naꞌ leꞌe, lekze kaꞌ gok keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Naꞌ kaꞌ gok ke toto beꞌnn kaꞌ bzorén noꞌrenꞌ bayate beꞌnn gall kaꞌ, naꞌ ni toeꞌ bi bzo xhiꞌnn akeꞌ wasaꞌt akeꞌ, bayoll naꞌ gotrén noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bixha kat yebán beꞌnn wat kaꞌ, ¿noreꞌ gak xhyio noꞌrenꞌ, le yeolol beꞌnn gall kaꞌn bzoreneꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesúsenꞌ ballieꞌ xtiꞌll akeꞌn: —Llakchíxere le bi llejnieꞌre kanꞌ ne xtiꞌll Diosenꞌ, naꞌ bi nnézere akrenꞌ nake yel wak ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kat yebán beꞌnn wat kaꞌ, bill wchaynaꞌa akeꞌ, ni ke weꞌe akzeꞌ xhiꞌnn akeꞌ wchaynaꞌa akbeꞌ, le gak akeꞌ ka angl beꞌnn llaꞌa yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ka nak danꞌ nnabre chaꞌ yebán beꞌnn wat kaꞌ, ¿bi nna golre danꞌ bzoj da Moisésenꞌ ganꞌ llian kanꞌ balwill Diosenꞌ leꞌe to lo yay yeꞌche da lleye? Lleꞌe leꞌe: “Nadaꞌ nakaꞌ Dios beꞌnn lloeꞌrao Abraham, naꞌ Dios beꞌnn lloeꞌrao Isaac, naꞌ Dios beꞌnn lloeꞌrao Jacob.” ");
INSERT INTO zpuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Le Diosenꞌ bi nakeꞌ Dios ke beꞌnn wat, nakseꞌ Dios ke beꞌnn ban. Naꞌllenꞌ niaꞌ, ni ke llejnieꞌzere danꞌ nerenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","To beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ zeꞌe llzenayeꞌ ka lloeꞌrén Jesúsenꞌ beꞌnn kaꞌ diꞌlle, naꞌ gokbeꞌreꞌ kwasro balliꞌi Jesúsenꞌ xtiꞌll akeꞌn, naꞌ bnnabreꞌ Leꞌe: —¿Norenꞌ nakll da brao danꞌ nllia Diosenꞌ biaꞌa gonllo rao yeololten? ");
INSERT INTO zpuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Naꞌll goll Jesúsenꞌ leꞌe: —Da ninꞌ da nak da lliarao rao yeololte danꞌ nllia Diosenꞌ biaꞌa gonllo: “Reꞌ beꞌnn Israel, lewzenay, toze Xanllo Diosenꞌ nakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Naꞌ llieꞌroꞌ Xanllo Diosenꞌ do yichj do raꞌlloꞌ.” Da naꞌn da nakll lliarao gonllo. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Naꞌ da wllopenꞌ ka rebze naksen: “Llieꞌroꞌ beꞌnn lwelljoꞌ kanꞌ nllieꞌ kwinoꞌ.” Billre bi de da nakll lliarao ka da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naꞌll ne beꞌnnenꞌ llsedre ke leyenꞌ: —Wakse, maestro, da wen kwis kanꞌ neꞌon. Toze Diosenꞌ nakse, nollno llraꞌ ye to ka Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Naꞌ llieꞌlloeꞌ do yichj do raꞌll-llo, naꞌ llieꞌllo lwelljllo ka nllieꞌ kwinllo, zaꞌkllen kerke da gotllo no bayiꞌx, naꞌ wzeyllobaꞌ weꞌraollo Dios. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesúsenꞌ gokbeꞌreꞌ ballieꞌ xtiꞌlleꞌn kwasro, naꞌll lleꞌe leꞌe: —Kere da xhen yalljen nench Diosenꞌ nnebieꞌ yichjraꞌlldaꞌon. Naꞌ nollno bayaxhjkze billre da nnab akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesúsenꞌ llzejnieꞌreꞌ beꞌnn kaꞌ llaꞌa llyoꞌ yodaꞌon, lleꞌe leakeꞌ: —¿Bixchen neze beꞌnn kaꞌ llsedre ke leyenꞌ, Cristonꞌ nakeꞌ xhiꞌnn dialla ke rey David? ");
INSERT INTO zpuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Renchaꞌ kwinkze Davidenꞌ bneꞌe kon ka bzejnieꞌ Spíritu ke Diosenꞌ leꞌe: Xanllo Dios golleꞌ Xanaꞌn: “Blleꞌ kwitaꞌn ni, naꞌ gonaꞌ yeolol beꞌnn kaꞌ llwieꞌ rweꞌn, wxhexj yichj akeꞌ wzenay akeꞌ koꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Chaꞌ kwinkze Davidenꞌ neꞌe nakeꞌ Xaneꞌ, ¿akxha gak nello Cristonꞌ nakeꞌ xhiꞌnn dialla ke Davidenꞌ? Le kwin Davidenꞌ golleꞌ leꞌe: “Xanaꞌ.” Beꞌnn zan beꞌnn yell llazraꞌll akeꞌ llzenay akeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Rawe llzejnieꞌ Jesúsenꞌ beꞌnn kaꞌ, naꞌll lleꞌe leakeꞌ: —Lewiayaꞌnn kanꞌ llon beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, llawé akreꞌ llak akeꞌ to raꞌll tonne da chaꞌo, naꞌ gap beꞌnne leakeꞌ baraꞌnne do lao yaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Naꞌ leakeꞌ ll-lan akeꞌ kweꞌ akeꞌ ga llbeꞌ beꞌnn brao lo yodaꞌo kaꞌ, naꞌ leskaꞌ llon akeꞌ do ga llak wao. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Naꞌ llkaꞌa akeꞌ rill noꞌr wazebe, naꞌ da lldeꞌ akreꞌ, scha llze akeꞌ kate llalwill akeꞌ Diosenꞌ nechkze ten kaꞌze. Da xhen da de saꞌkziꞌ beꞌnn kaꞌ kanꞌ llon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ka lliꞌ Jesúsenꞌ kwite ga llia ganꞌ llgoꞌ akeꞌ mell ke yodaꞌon, naꞌ llwieꞌ ka llgoꞌ beꞌnn kaꞌ mell, beꞌnn zan beꞌnn wniaꞌ kaꞌ llgoꞌ akeꞌ da xhen. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka bllin to noꞌr wazebe, naꞌ nakeꞌ noꞌr yaꞌche, broeꞌ chop mell daꞌo da bibi zaꞌktek. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Naꞌll goxh Jesúsenꞌ beꞌnn kaꞌ non Leꞌen txhen naꞌ, lleꞌe leakeꞌ: —Diꞌll li llepaꞌ reꞌ, ka noꞌr wazeb ni, nakeꞌ beꞌnn yaꞌch daꞌo, da xhenll zaꞌk danꞌ broeꞌn kerke da broꞌ beꞌnn kaꞌ yelaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Le beꞌnn kaꞌ broꞌ akeꞌ da ba bagoꞌnne, zan ka nak noꞌrenꞌ, rao yel yaꞌch keꞌen beꞌe ka da lallibe de keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ka ba llazaꞌa Jesúsenꞌ yodaꞌo braonꞌ, to beꞌnn nonꞌ Leꞌe txhen golleꞌ Leꞌe: —¡Maestro, bwia ke da xhen nak yodaꞌon, naꞌ leskaꞌ da xhen nak yej kaꞌ naken naꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesúsenꞌ ballieꞌ xtiꞌlleꞌn, lleꞌe leꞌe: —Ka nak yoꞌ xhen ki llwiare, wllin lla wayinnj akeꞌn, ni to yej ngoꞌd lwellje bi yegaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Naꞌ jakeꞌ yaꞌ ganꞌ nziꞌi Yaꞌ Olivos, naꞌ llgaꞌnnen chlaꞌ ganꞌ zo yodaꞌo braonꞌ, naꞌ bllieꞌ, naꞌll Pedronꞌ naꞌ Jacobo, naꞌ Juan, naꞌ Andrés naꞌ, jannab akreꞌ Leꞌe to wraze: ");
INSERT INTO zpuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Bnechk netoꞌ, ¿batxhanꞌ gak kanꞌ ba bneꞌon? ¿Akxha gakze nnézello katenꞌ ba zo rez gak yeolol da ki bneꞌo ni? ");
INSERT INTO zpuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesúsenꞌ ballieꞌ xtiꞌll akeꞌn: —Lewiayaꞌnn kwasro, notno siyeꞌe reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Beꞌnn zan yednné akeꞌ nak akeꞌ Cristo. Naꞌ siyeꞌe akeꞌ beꞌnn zan. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Kate yénere ba zaꞌa wdile, ba llak wdile, bi llebre, le kaꞌn dekz de gak, naꞌ kere le wayollte yellrio naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Naꞌll tile toto yell, naꞌll yell xhen ren ye to yell xhen, naꞌ xoꞌ do gateze, naꞌ gak win, naꞌ bi gak bi nne, kone kaꞌ sorao yellayrao beꞌnne llaꞌa yellrio. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Lewiake, lljwaꞌa akeꞌ reꞌ do rao koxchis, naꞌ do lo yodaꞌo kaꞌ, naꞌ chintat akeꞌ reꞌ, lljwaꞌa akeꞌ reꞌ no rao rey, no rao beꞌnn wnebiaꞌ kaꞌ ni kiaꞌ nadaꞌ, naꞌ kaꞌn weꞌrén akreꞌ xtiꞌllaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Naꞌ llonen bien nneze beꞌnn llaꞌa doxhen yellrio Diꞌll Wen ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Katenꞌ lljwaꞌa akeꞌ reꞌ rao beꞌnn wnebiaꞌ kaꞌ, bitbi gákere choꞌrizre da zed akre nnere. Kat ba zere rawe naꞌ, gonn Diosenꞌ diꞌll yelliꞌre xtiꞌll akeꞌn, naꞌ kere reꞌkzenꞌ nnere, Spíritu ke Dios naꞌkzenꞌ wzejnieꞌn reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kanaꞌ bal beꞌnn wayechj akeꞌ gon akeꞌ beꞌnn biꞌch akeꞌ kaꞌ, rao naꞌa beꞌnn got leakeꞌ, naꞌ nniꞌt beꞌnn gon akeꞌ xhiꞌnn akeꞌ kaꞌ, rao naꞌa beꞌnn got akeꞌ leakbeꞌ, naꞌ nniꞌt beꞌnn wayechj akeꞌ gon akeꞌ xaxhnaꞌ akeꞌ kaꞌ, rao naꞌa beꞌnn got leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Naꞌ yeololte beꞌnn wie akreꞌ reꞌ ni kiaꞌ nadaꞌ, naꞌ noteze beꞌnn se war wxenraꞌlleꞌ nadaꞌ llinte lla gateꞌ, leꞌen yerá. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Daniel beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ bzojeꞌ, wllin lla so da zban da ke wayazraꞌll Dios. (Beꞌnn llol diꞌll ni llayaꞌl chejnieꞌreꞌ.) Naꞌ kat reꞌre ba zo danꞌ ganꞌ bi llayaꞌl son, kanaꞌ beꞌnn llaꞌa Judeanꞌ llayaꞌl wxhonnj akeꞌ lljakeꞌ do yaꞌ daꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Beꞌnn dá yichjo rilleꞌ, bi llayaꞌl wayetjeꞌ wayoeꞌ lo yoꞌ, lljaxhieꞌ no xchinrazeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Naꞌ beꞌnn dá lyiꞌxe, bi llayaꞌl wabieꞌ lljaxhiꞌi xharaꞌneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naken nyaꞌchraz ke noꞌr noaꞌ xhiꞌnne, naꞌ noꞌr kaꞌ nkaꞌ bdaꞌo ka lla naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lennab rao Dios katenꞌ gak da ki bi gaken beꞌo zay. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Da xhen yellayrao beꞌnne kate llin llanꞌ, kanꞌ bxe Diosenꞌ yellrio nono nna yellayrao katekenꞌ yellayrao akeꞌ kanaꞌ, naꞌ yeyoll naꞌ, billbi gaꞌte ye to ka len. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chenak Diosenꞌ bi goneꞌ kwexhen kanꞌ llaken, ni to nono yerakze, zan ni ke beꞌnn kaꞌ ba brejeꞌ naꞌ, ni ke leakeꞌn goneꞌ kwexhen. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Naꞌ chaꞌ kanaꞌ, no yerize reꞌ: “Ledá, zote Cristonꞌ ganni”, naꞌ “Lechej gannaꞌ zoeꞌ”, bi chejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Beꞌnn zan beꞌnn wxhiyeꞌe chaꞌa yellrionꞌ, nne akeꞌ leakeꞌn nak Cristonꞌ, naꞌ leakeꞌn lloeꞌ xtiꞌll Diosenꞌ. Gon akteꞌ yel wak, naꞌ billre da yebane beꞌnn kaꞌ kon ka siyeꞌe akeꞌ, nxhollte wxoayay akeꞌ beꞌnn kaꞌ ba brej Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Naꞌ lesó xhnid ka nak ba llepaꞌ reꞌ yeolol kanꞌ gonen nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Naꞌ ka nake lla ka yeyoll yellayrao beꞌnn kaꞌ, kanaꞌ willenꞌ yecholen, leskaꞌ beꞌon bill wseniꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Berj kaꞌ llia leꞌ yebánꞌ yexj aken, naꞌ yel wak ke yebánꞌ danꞌ ngaꞌchen, gaken ka llak yellrionꞌ kat llxhoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kanaꞌll reꞌe beꞌnn kaꞌ llaꞌa yellrionꞌ nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnachenꞌ, zaꞌa radj bej kaꞌ nsaꞌa yel wak xhen ren yel beniꞌ xhen kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naꞌll wseꞌlaꞌ angl kiaꞌ kaꞌ, yetop akeꞌ beꞌnn kaꞌ ba brejaꞌ doxhente yellrio, ga zeraoze llayollen, naꞌ ga zeraoze llayoll yebá. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Lechejnieꞌ ka diꞌllenꞌ weꞌrenaꞌ reꞌ ke yay higo naꞌ: Kat ba llagaꞌ xhlaꞌye naꞌ, llnnézere ba rez llin lla yeyoꞌllo rinne. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Naꞌ lekze kate reꞌre ba llak da ke nxhia kanꞌ ba bniaꞌ naꞌ, kanaꞌll nnézere ba zo rez yedaꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Da li llniaꞌ reꞌ, beꞌnn kaꞌ llaꞌa nnaꞌ, nna nban akteꞌ kate sorao gak da ki. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ka nak yebánꞌ ren yellrionꞌ wllin lla kat te ke, zan ka nak xtiꞌllaꞌn kere da te ke kaꞌzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Zan nono nneze bi llanꞌ, bi horenꞌ gak kaꞌ, ni angl kaꞌ niꞌt yebá naꞌ, ni nadaꞌ. Toze Xaꞌ Dios naꞌ nnezreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ke len naꞌ, lewiá, lesó xhnid, leyelwill Dios, le bi nnézere batenꞌ yedaꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gonen rebze ka ke to beꞌnne broꞌ nez zejeꞌ, naꞌ bkwaꞌnn rilleꞌ, naꞌ bkwaꞌnneꞌ da gon toto beꞌnn wen llin keꞌe kaꞌ, naꞌ beꞌnnenꞌ bze llapenꞌ, lleꞌe leꞌe bi taseꞌ, naꞌ wnneꞌe yere. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Leskaꞌ reꞌ, lesó xhnid, le bi nnézere bi llanꞌ waraꞌ xan yoꞌn, chaꞌ ba llze yere o chaꞌ do llere o kat ba bell lekw o chaꞌ do ba lleniꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Le nxholl kate wareꞌen, yeddiꞌreꞌ reꞌ tasre kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Da ni llniaꞌ reꞌ, naꞌ lekze kaꞌ niaꞌ yeolol beꞌnne; lesó xhnid. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ye chop llare llin lnni paskwnꞌ, katenꞌ llao akeꞌ yet xtir da bi nchix kwa binn; naꞌ beꞌnn kaꞌ nak bxoz wnebiaꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, lloeꞌ akeꞌ diꞌll akre ka gon akeꞌ siyeꞌe akeꞌ Jesúsenꞌ, naꞌ goꞌx akeꞌ Leꞌe, naꞌ yesoꞌt akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naꞌ ne akeꞌ: —Bi goꞌxlloeꞌ rao lnninꞌ nench ke gakbeꞌe beꞌnn yell, naꞌ gon akeꞌ dá nne. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Naꞌ zo Jesúsenꞌ Betania rill beꞌnnenꞌ re Simón, beꞌnnenꞌ goke yillweꞌ danꞌ ne lepra. Naꞌ ka llieꞌ llaweꞌ naꞌ, bllin to noꞌre noꞌxeꞌ to lmet de yej chaꞌo, naꞌ yollen ceit da laꞌ xhix nziꞌi nardo, naꞌ zaꞌken da xhen; le blaꞌteꞌ lmetenꞌ le bwazjteꞌn yichj Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Naꞌ bale beꞌnn kaꞌ zjallaꞌa gannaꞌ gokllaꞌa akeꞌ, naꞌll lle lwellj akeꞌ: —¿Bixchen benditjerize noꞌrenꞌ ceit xhixenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wenre chenak beꞌteꞌn ke to da llon beꞌnn gan chonn gayoa (300) lla llin, naꞌ gakreneꞌn beꞌnn yaꞌche. Naꞌll bi ne bi zill akeꞌ, lle akeꞌ noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naꞌ Jesúsenꞌ lleꞌe leakeꞌ: —Waljezen. ¿Bixchen llereꞌ kaꞌ? Da wen naꞌ beneꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ka nak beꞌnn yaꞌch kaꞌ llaꞌa akseꞌ radjrenꞌ, naꞌ wakse gakrén akreꞌ batteze, zan ka nak nadaꞌ, nnaꞌzenꞌ zorenaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ka nak danꞌ bwazj noꞌrenꞌ ceit xhixenꞌ yichjaꞌn, ba bentegueꞌ ke da llayaꞌlkze gon akeꞌ kat gaꞌchaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Diꞌll li niaꞌ reꞌ, doxhen yellrio do gateze lljatixjweꞌ beꞌnn Diꞌll Wen danꞌ llzejnieꞌ kiaꞌn, dekz de yene beꞌnn kaꞌ, kanꞌ ben noꞌr ni, nench lljadinraꞌll akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Naꞌll Judas Iscariotenꞌ beꞌnnenꞌ ren radj beꞌnn chllinn kaꞌ, byejeꞌ rao bxoz wnebiaꞌ kaꞌ, naꞌ bchebeꞌ goneꞌ Jesúsenꞌ rallnaꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ka ben akreꞌ kaꞌ, bawé akreꞌ kwis, naꞌll bcheb akeꞌ weꞌe akeꞌ leꞌe mell. Naꞌll Judasenꞌ bzoraweꞌ llayirjlaꞌlleꞌ akre goneꞌ gak latjeꞌ goneꞌ Jesúsenꞌ rallnaꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bllin lla nell lnni kat llao akeꞌ yet xtir danꞌ bi nchix kwa binn, leskaꞌ llot akeꞌ xhiꞌre nench lljasaꞌraꞌll akeꞌ kanꞌ babej Diosenꞌ xozxtaꞌo akeꞌ kaꞌ ganꞌ nziꞌi Egipto. Beꞌnn kaꞌ nao Leꞌen lle akeꞌ Leꞌe: —¿Gaxha lleꞌnroꞌ lljasiniaꞌllo da gaollo ke lnni paskwnꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naꞌll bseꞌleꞌ chop beꞌnn kaꞌ non Leꞌe txhen, lleꞌe leakeꞌ: —Lechej yellenꞌ, naꞌ kat choꞌre naꞌ, le walláytere to beꞌnn zanzoa leo nis xhichjeꞌ, naꞌ le nnaotereꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Naꞌ ganꞌ wayoeꞌ naꞌ, naꞌ choꞌre, naꞌ yere xan yoꞌn: “Maestronꞌ neꞌe ki: ¿Ganꞌ zo yoꞌ ganꞌ gaorenaꞌ beꞌnn kaꞌ non nadaꞌ txhen ke lnni paskwnꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naꞌll le wroeꞌtereꞌ reꞌ to yoꞌ da zo ye to kwia yichje ba zon xhnid. Gannaꞌ le wsiniaꞌtere danꞌ gaollonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naꞌll byej chop beꞌnn kaꞌ, ka byoꞌ akeꞌ yellenꞌ gokte doxhen kanꞌ golleꞌ leakeꞌn, naꞌ bsiniaꞌ akeꞌ ke lnni paskwnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ka betj lleꞌ naꞌ, bllin ren Jesúsenꞌ beꞌnn chllinn kaꞌ ganꞌ zo yoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Naꞌ bllieꞌ ganꞌ gao akeꞌn, naꞌ lleꞌe leakeꞌ: —Diꞌll likze niaꞌ reꞌ, to reꞌ llaorenre nadaꞌ txhen, gonre nadaꞌ rallnaꞌa beꞌnn kaꞌ llwie nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Naꞌll bzorao gok akreꞌ, naꞌ twej twej akeꞌ llnnab akreꞌ Leꞌe: —¿Kere nadaꞌn gonrizaꞌ kaꞌ lla? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Naꞌll lleꞌe leakeꞌ: —To reꞌ rao beꞌnn chllinn ki, llrabjrenre nadaꞌ yet xtir kerénꞌ lo yeꞌnnenꞌ, leꞌen gonreꞌ nadaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ka nak nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, ka nyojkze kiaꞌn got akeꞌ nadaꞌ, zan ¡nyaꞌchraz naken ke beꞌnnenꞌ gon nadaꞌ rallnaꞌa beꞌnn kaꞌ! Wenre chenak bi bzokzeꞌ yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Naꞌll ka ba llao akeꞌ naꞌ, bxhieꞌ yet xtirenꞌ, naꞌ benlaꞌyeꞌn, naꞌ bxhoxhjeꞌn beꞌen leakeꞌ, naꞌ bneꞌe: —Lesiꞌn, len naꞌ naken kwerp kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Naꞌll bxhieꞌ leo daꞌon, naꞌ beꞌe yel llioxken ke Dios, naꞌll beꞌe leakeꞌ xis uvanꞌ weꞌe yeolol akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naꞌ lleꞌe leakeꞌ: —Da ni naken xchenaꞌ, naꞌ larjen ni ke beꞌnnach, naꞌ llroeꞌn sorao to da kobe danꞌ bcheb Diosenꞌ goneꞌ gakreneꞌ beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Diꞌll likze niaꞌ, bill yeꞌjaꞌ xis uvanꞌ llinte lla kat yeyeꞌjaꞌn da yobre ganꞌ llnebiaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bayoll bel akeꞌ da beꞌrao akeꞌ Diosenꞌ, naꞌll bllach akeꞌ zjakeꞌ ganꞌ zo yaꞌ ganꞌ nziꞌi Yaꞌ Olivos. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naꞌll lle Jesúsenꞌ leakeꞌ: —Nnaꞌ lleꞌ yeololre gakgánere, naꞌ wkwaꞌnnre nadaꞌ, gak kanꞌ nyoj xtiꞌll Diosenꞌ nen: “Gotaꞌ beꞌnnenꞌ llap xhiꞌr kaꞌ, naꞌ gaslas xhiꞌr kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Naꞌ kat wasbán Diosenꞌ nadaꞌ radj beꞌnn wat kaꞌ, wabiarawaꞌ raore wayaꞌa Galileanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naꞌll lle Pedronꞌ Leꞌe: —Laꞌkze chaꞌ yeolol beꞌnn ki wkwaꞌnn akeꞌ rweꞌ, nadaꞌ bi wsanraꞌllaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Naꞌll lle Jesúsenꞌ leꞌe: —Da li kwis llepaꞌ rweꞌ, za kwellre lekwnꞌ da wllope nnaꞌ lleꞌ, kat gak chonn ras, ni ke wchebzoꞌ chaꞌ nombiaꞌo nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naꞌ Pedronꞌ yezikre lleꞌe Leꞌe: —Laꞌkze chaꞌ gatrenaꞌ rweꞌ, kbat nniaꞌ bi nombiaꞌ rweꞌ. Naꞌll toz kaꞌ bne yeolol akteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bllin akeꞌ ganꞌ nziꞌi Getsemaní, naꞌ lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Gannize lekweꞌ, chak lljeꞌrenaꞌ Diosenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Naꞌ bcheꞌe Pedronꞌ, ren Jacobo ren Juan naꞌ, naꞌ ba bzorao llakyaꞌchreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Naꞌ lleꞌe leakeꞌ: —Wa ba llakyaꞌch raꞌlldaꞌwaꞌn kwis, llakaꞌ ka beꞌnn le gatte, naꞌ gannize legaꞌye, lewnnaꞌ yere. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naꞌll bdieꞌ ye raꞌte, naꞌ bcheꞌk xhibeꞌ, blleꞌkeꞌ janoꞌpteꞌ rao yo, naꞌ bzoraweꞌ llalwilleꞌ Dios bnnabeꞌ chaꞌ wak ten kaꞌze, bi gak keꞌe kanꞌ ba zo gak keꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ka llalwilleꞌ Dios naꞌn, bneꞌe: —Xa Dios, rweꞌ llak llonoꞌ yeololte, benchga bi saꞌkziaꞌ kanꞌ ba zo gak naꞌ, zan bi gak ka lleꞌnraꞌ nadaꞌ, kon ka nnekzoꞌ rweꞌ gak. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naꞌll le zayejteꞌ jawieꞌ beꞌnn kaꞌ nkwaꞌnneꞌn, naꞌ jadiꞌreꞌ leakeꞌ tas akeꞌ kwis. Naꞌll lleꞌe Pedronꞌ: —Simón, ¿bixchen le tasoꞌ kwis? ¿Bi gok wchachoꞌ bichgalenꞌ choll daꞌozenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bi tasre, lewalwill Dios nench ke gon da xhinnjenꞌ reꞌ gan. Nnezraꞌ lo yichjraꞌlldaꞌorenꞌ lleꞌnere wnnaꞌrenre nadaꞌ yere, naꞌ kwerp kerénꞌ bi zoen. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naꞌll zejeꞌ da yobre, jeꞌreneꞌ Diosenꞌ diꞌlle kanꞌ ba bnekzeꞌ da nell naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ka ballineꞌ da yobre, leskaꞌ tas akeꞌ, le lliachaꞌ bichgalenꞌ koꞌll rao akeꞌn, ni ke bi llallel akzreꞌ bi ye akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Da wyonn rase zayejeꞌ, naꞌ jadiꞌreꞌ leakeꞌ tas akeꞌ, naꞌll lleꞌe leakeꞌ: —¡Letas, lewaziꞌraꞌll! Ba gok to kat, ba bllin lla, nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, gakaꞌ rallnaꞌa beꞌnn wen da xhinnj kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Lewayas, lewayoꞌo! Gannize ba ze beꞌnnenꞌ gon nadaꞌ rallnaꞌa beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Naꞌ zete Jesúsenꞌ lloeꞌ diꞌll naꞌ, kat bllindo Judas beꞌnnenꞌ ren rao beꞌnn chllinn kaꞌ, ncheꞌe beꞌnn zan beꞌnn noꞌx no spad no yay, beꞌnn bseꞌl bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ beꞌnn gor brao kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Naꞌ Judasenꞌ beꞌnnenꞌ bde Leꞌe rao naꞌa beꞌnn kaꞌ, golleꞌ leakeꞌ akrenꞌ goneꞌ wroeꞌreꞌ nonꞌ goꞌx akeꞌ. Naꞌll lleꞌe leakeꞌ: —Kon beꞌnnenꞌ wnoꞌpaꞌ naꞌ, lekzeꞌn. Naꞌ legoꞌxeꞌ, lewchejeꞌ, naꞌ lewacheꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Naꞌll kate bllineꞌn, le jabiꞌyteꞌ ganꞌ ze Jesúsenꞌ lleꞌe Leꞌe: —Maestro. Naꞌ le bnoꞌpteꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Naꞌ beꞌnn kaꞌ ncheꞌe Judasenꞌ, le beꞌx akteꞌ Leꞌe, naꞌll bchej akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naꞌ to beꞌnn kaꞌ ze gannaꞌ, le brejteꞌ spad keꞌen bdineꞌn beꞌnnenꞌ nak beꞌnn wen llin ke bxoz braonꞌ, bchoyteꞌ chlaꞌ nayeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Naꞌ bne Jesúsenꞌ, lleꞌe beꞌnn kaꞌ: —¿Bixchen llonre nadaꞌ ka to beꞌnn wan, zaꞌre zadxiꞌre nadaꞌ kone spad, naꞌ ren yay? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Renchaꞌ yeo lla bzorenaꞌ reꞌ, broeꞌraꞌ reꞌ lo yodaꞌo braonꞌ, naꞌ bi beꞌxre nadaꞌ kanaꞌ. Naꞌ ka nak llak da ki, llak kaꞌ nench llak kanꞌ nyoj xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kanaꞌ yeolol beꞌnn kaꞌ nao Leꞌen, baxhonnj akeꞌ bsanraꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naꞌ to bi weꞌo naobeꞌ Jesúsenꞌ, naꞌ llelbeꞌ toze xchan, naꞌ beꞌxrén akebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bixha to ballojzbeꞌ lo xchan, naꞌ bsanraꞌllbeꞌn baxhonnjbeꞌ gal yidzbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naꞌll jwaꞌa akeꞌ Jesúsenꞌ rao bxoz braonꞌ, naꞌll badopeꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn gor brao ke beꞌnn Israel kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedronꞌ naweꞌ ziꞌt ziꞌte, ka byoꞌ akeꞌ rill bxoz braonꞌ, naꞌ reneꞌ byoꞌ, naꞌ blleꞌreneꞌ txhen beꞌnn kaꞌ llap yodaꞌo braonꞌ, balleꞌreꞌ lloaꞌ yiꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Naꞌ bxoz brao kaꞌ ren beꞌnn wnebiaꞌ kaꞌ, llayirjlaꞌll akeꞌ bi da gao akeꞌ xhia ke Jesúsenꞌ, naꞌ chan diꞌll keꞌe, naꞌ got akeꞌ Leꞌe. Naꞌ bibi ballel akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bal akeꞌ ziyeꞌe akeꞌ ll-lliayiꞌll akeꞌ Leꞌe, naꞌ bill dile xtiꞌll akeꞌ ka ne akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Naꞌll bzollaꞌa beꞌnn lloeꞌ ak diꞌll wxhiyeꞌe, ne akeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Netoꞌ ba bénetoꞌ bneꞌe: “Nadaꞌ yechinnjaꞌ yodaꞌon danꞌ ben beꞌnnache, naꞌ chonn llaze wayontiaꞌ ye to yodaꞌo da bi gon beꞌnnach.” ");
INSERT INTO zpuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Naꞌ bi llakse toz diꞌlle ka ne yeololeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naꞌll bzollaꞌa bxoz braonꞌ rao beꞌnn zan kaꞌ, naꞌll lleꞌe Jesúsenꞌ: —¿Bibi nnekzoꞌ ka nak danꞌ ll-lliayiꞌll beꞌnn ki rweꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Naꞌ Jesúsenꞌ bi balliꞌkzeꞌ xtiꞌlleꞌn, zeteze lliteze, naꞌll lekze bxoz braonꞌ da yobre lleꞌe Leꞌe: —¿Bixha rweꞌn nakoꞌ Cristonꞌ, Xhiꞌnn Dios beꞌnn le zeraoze nak laꞌye? ");
INSERT INTO zpuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Naꞌll lle Jesúsenꞌ bxozenꞌ: —Nadaꞌn, naꞌ reꞌre nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, lljalliaꞌ kwit Xanllo Dios beꞌnnenꞌ nap yel wak xhen, naꞌll reꞌreꞌ katenꞌ yedaꞌ yetjaꞌ leꞌ yebánꞌ radj bejenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naꞌll bxoz braonꞌ bcheꞌz xharaꞌneꞌ nench wroeꞌreꞌ da xhinnj kwisenꞌ bne Jesúsenꞌ, naꞌll lleꞌe beꞌnn kaꞌ: —Bill yálljello beꞌnn se gaweꞌ xhia ke beꞌnn ni. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ba bénere kanꞌ bnneꞌe ke Diosenꞌ. ¿Akre ka llákere? ¿Akre gonllo keꞌe? Naꞌ yeolol beꞌnn kaꞌ bchoy akeꞌ keꞌe gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Naꞌ bal akeꞌ bzorao akeꞌ llxiꞌt akeꞌ xheꞌn yichjraweꞌ, llsej akeꞌ raweꞌn, naꞌ llbaꞌll akeꞌ Leꞌe, naꞌll lle akeꞌ Leꞌe: —¡Bnneyaꞌchk noxhanꞌ braꞌll rweꞌ! Naꞌll beꞌnn kaꞌ llap yodaꞌon llgap akeꞌ lloaꞌraweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Naꞌ Pedronꞌ llieꞌ liaꞌte radj beꞌnn kaꞌ, ka bllinkze to noꞌr wet ke bxoz braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ka breꞌreꞌ Pedronꞌ lliꞌreneꞌ beꞌnn kaꞌ lloaꞌ yiꞌn llayayeꞌ, naꞌll llwiayaꞌnneꞌ leꞌe, naꞌ lleꞌe leꞌe: —Ren rweꞌn nakrenoꞌ Jesúsenꞌ txhen beꞌnn Nazaretenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naꞌ Pedronꞌ bi bchebeꞌ, naꞌ bneꞌe: —Bi nombieꞌ, ni ke nnezzraꞌ binꞌ neꞌo. Naꞌll jazedoeꞌ lloaꞌ yoꞌ naꞌ, naꞌ le bllellte lekw. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naꞌll noꞌr wetenꞌ llwiayaꞌnnkzeꞌ leꞌe da yobre, naꞌ lleꞌe beꞌnn kaꞌ llaꞌa naꞌ: —Ren beꞌnnenꞌ ze gannaꞌ nakeꞌ beꞌnn kaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Naꞌ da yobre bi bchebkze Pedronꞌ. Gok ye choll kat beꞌnn kaꞌ zjallaꞌa gannaꞌ da yobre lle akeꞌ leꞌe: —Li nakrenoꞌ beꞌnn kaꞌ txhen, da lijenꞌ, le lekze beꞌnn Galilea rweꞌ, nakbieꞌze nneꞌo kanꞌ nne beꞌnn Galilea kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Naꞌ le bzoraote bnneꞌe znia, lleꞌe beꞌnn kaꞌ: —Da li rao Dios bi nombiaꞌ no beꞌnnenꞌ nere kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naꞌ le bllellte lekwnꞌ da wllop rase. Kanaꞌll jadinraꞌll Pedronꞌ kanꞌ goll Jesúsenꞌ leꞌe: “Za kwellre lekwnꞌ da wllope, gak chonn ras bi wcheboꞌ chaꞌ nombiaꞌo nadaꞌ.” Kanaꞌll jadinraꞌlleꞌ, naꞌll bllelleꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kate byeniꞌ naꞌ badop bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn gor brao ke beꞌnn Israel kaꞌ, naꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ yeololte beꞌnn kaꞌ llnebiaꞌ Israel, naꞌ bchej akeꞌ Jesúsenꞌ, naꞌll jwaꞌa akeꞌ Leꞌe rao Pilatonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato naꞌ bnnabreꞌ Leꞌe: —¿Rweꞌn nakoꞌ Rey ke beꞌnn Israel kaꞌ? Naꞌll ballieꞌ xtiꞌll beꞌnnenꞌ, bneꞌe: —Kanꞌ ba bnekzoꞌ naꞌ nakaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Naꞌ bxoz wnebiaꞌ kaꞌ, llaral akreꞌ ll-lliayiꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Naꞌll da yobre llnnabe Pilatonꞌ Leꞌe: —¿Bibi nekzoꞌ? Bwiake da zan danꞌ ll-lliayiꞌll akeꞌ rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Naꞌ Jesúsenꞌ chras billbi bnekzeꞌ. Naꞌll llabane Pilatonꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naꞌ de to da llon akeꞌ yeo iz, yesán Pilatonꞌ to beꞌnn yoꞌ rill ya kat llaꞌl lnni Paskwnꞌ, kon beꞌnn nnab beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naꞌ to beꞌnn re Barrabás yoeꞌ rill yanꞌ, llaꞌreneꞌ beꞌnn yob akreꞌ le bxe akeꞌ to wdile, naꞌ basoꞌt akteꞌ beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Beꞌnn zan badope, naꞌ jakeꞌ jannab akeꞌ wasán Pilatonꞌ to beꞌnne kanꞌ llonkzeꞌ yeo iz. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Naꞌll lle Pilatonꞌ leakeꞌ: —¿Weꞌnere wasanaꞌ Rey kerénꞌ, reꞌ nakre beꞌnn Israel? ");
INSERT INTO zpuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatonꞌ bneꞌe kaꞌ le gokbeꞌreꞌ danꞌ llaxhéꞌ bxoz wnebiaꞌ kaꞌ Jesúsenꞌ, naꞌllenꞌ bde akeꞌ Leꞌe rao neꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Naꞌ bxoz wnebiaꞌ kaꞌ, llkoꞌyel akreꞌ beꞌnn zan kaꞌ nench bnnab akeꞌ wasaneꞌ Barrabás naꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Naꞌll lle Pilatonꞌ leakeꞌ da yobre: —¿Akxha gonaꞌ ke beꞌnnenꞌ nere Rey ke beꞌnn Israel kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Naꞌll llosiaꞌ akeꞌ ne akeꞌ: —¡Bdeꞌe leꞌ yay cruz! ");
INSERT INTO zpuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Naꞌll lle Pilatonꞌ leakeꞌ: —¿Bixha da xhinnj ba beneꞌ naꞌn? Naꞌ leakeꞌn llosiaꞌ akeꞌ yezikre zillj kwis, ne akeꞌ: —¡Bdeꞌe leꞌ yay cruz! ");
INSERT INTO zpuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Naꞌll basán Pilatonꞌ Barrabásenꞌ nench bagaꞌnneꞌ wen rao beꞌnn kaꞌ. Naꞌ golleꞌ beꞌnn kaꞌ bdintat akeꞌ Jesúsenꞌ, naꞌll beneꞌ Leꞌe rallnaꞌa akeꞌ wdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naꞌll wakaꞌa ya kaꞌ, le bcheꞌe akteꞌ Leꞌe llyoꞌ yoraꞌon ganꞌ lliꞌ Pilatonꞌ, naꞌ goxh akeꞌ wakaꞌa ya kaꞌ yelaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Naꞌll bwakw akeꞌ Leꞌe to raꞌll morad, naꞌ btiꞌx akeꞌ ye to de lba yeꞌche, naꞌ bliz akeꞌn yichjeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Naꞌll bzorao akeꞌ lltitj akreꞌ Leꞌe, ne akeꞌ: —¡Sechga ke beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Naꞌ bdin akeꞌ yichjeꞌn to xhis, naꞌll llxiꞌt akeꞌ xheꞌn raweꞌ, naꞌ llcheꞌk xhib akeꞌ raweꞌn lltitj akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bayoll btitj akreꞌ Leꞌen, naꞌll bayalj akeꞌ raꞌll tonnenꞌ, naꞌll bawakw akseꞌ Leꞌe xhakzeꞌ, naꞌll bcheꞌe akeꞌ Leꞌe ganꞌ wdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ka zjakeꞌ naꞌ, to beꞌnn zazaꞌa lyiꞌxe beꞌnn Cirene beꞌnn re Simón xa Alejandro ren Rufo, naꞌ bchieꞌ akreꞌ leꞌe nench bleneꞌ cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naꞌll ncheꞌe akeꞌ Jesúsenꞌ latjenꞌ nziꞌi Gólgota lleꞌnen nen Latj ke Yichj Llit Wat. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Naꞌll beꞌe akeꞌ Leꞌe xis uva da nchix nell danꞌ nziꞌi mirra, naꞌ bi weꞌjeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Naꞌll bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. Naꞌ wakaꞌa ya kaꞌ, bditjen akeꞌ xharaꞌneꞌn, llwia akeꞌ naraꞌchk norenꞌ llayaꞌl toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ka lladá ganꞌ bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Naꞌ yichj yay cruz naꞌ, bllia akeꞌ bi ken deꞌe gannaꞌ, naꞌ llian: “Rey ke Beꞌnn Israel kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Leskaꞌ kwiteꞌ naꞌ, bzo akeꞌ ye chop cruz, naꞌ bdaꞌa akeꞌ chop beꞌnn wan ake chlaꞌ wejeꞌ, toeꞌ chaꞌwe ye toeꞌ rbese. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Naꞌ danꞌ ben akeꞌ kaꞌ, bzoa diꞌll kanꞌ nyoj xtiꞌll Diosenꞌ ganꞌ nen: “Ben akeꞌ Leꞌe ka beꞌnn wen da xhinnj.” ");
INSERT INTO zpuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Naꞌ beꞌnn kaꞌ llde ganꞌ ndaꞌa akeꞌ Leꞌen, ll-lol yichj akeꞌ llchachrén akeꞌ Leꞌe, lle akeꞌ Leꞌe: —Rweꞌn neꞌo yechinnjoꞌ yodaꞌon, naꞌ chonn llaze wayonteꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Basrachk kwinoꞌ, naꞌ bayetjchk leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Naꞌ leskaꞌ bxoz wnebiaꞌ kaꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, lltitj akreꞌ Leꞌe, naꞌll lle lwellj akeꞌ: —Basreꞌe beꞌnn yobre, naꞌ bi llasrá kwineꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chaꞌ leꞌen Cristo, rey ke lliꞌo beꞌnn Israel, wayetjchkeꞌ leꞌ yay cruzenꞌ nench reꞌllo, naꞌll chejleꞌllo. Leskaꞌ beꞌnn kaꞌ zjadaꞌa chlaꞌ wej kwiteꞌn lltitj akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ka bllin wa willenꞌ, bachol doxhen yellrio bllinte lladá chonne. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ka bllin lladá chonn naꞌn, besiaꞌ Jesúsenꞌ zillje bneꞌe: —Eloi, Eloi, ¿lama sabactani? —da ni lleꞌnen nen: Dios kiaꞌ, Dios kiaꞌ, ¿bixchen ba bsanraꞌlloꞌ nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Naꞌ bal beꞌnn kaꞌ zjallaꞌa gannaꞌ, ben akreꞌ kanꞌ bneꞌen, naꞌll ne akeꞌ: —Lewiake llalwilleꞌ Elías, beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Naꞌll zejdo to beꞌnnenꞌ, jaxieꞌ to da bzaꞌllen zo zichje, bzoeꞌn to rao yia naꞌ jazeꞌen lloaꞌ Jesúsenꞌ, naꞌll bneꞌe: —Ledachk wiallo chaꞌ yed Elíasenꞌ yedletjeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Naꞌll besiaꞌ Jesúsenꞌ zillj kwis, naꞌ goteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naꞌ raꞌllenꞌ ze lo yodaꞌon blleꞌzen goken chopre, bxhiꞌzen yichjte bllinte xhnieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Naꞌ xan wakaꞌa yanꞌ zeꞌe rao Jesúsenꞌ, breꞌreꞌ doxhen kanꞌ besieꞌ goteꞌn, naꞌll bneꞌe: —Da likze Xhiꞌnn Dios beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Leskaꞌ zjazé noꞌr ak llwia akeꞌ ziꞌtre, naꞌ zerén María Magdalena, naꞌ María xhnaꞌ Jacobo beꞌnnenꞌ nak beꞌnn naꞌch, naꞌ José naꞌ ren Salomé. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Noꞌr ki bnao akeꞌ Jesúsenꞌ ka nna zoteꞌ Galileanꞌ, naꞌ llakrén akeꞌ Leꞌe kat bi da yalljreꞌ, ren noꞌr yob akreꞌ bnao akeꞌ Leꞌe bzeꞌe Galileanꞌ zejeꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ka ba wlleꞌ naꞌ, naꞌ naken lla llsiniaꞌ akeꞌ, zeje diꞌll lla vispr ke lla nbaꞌnne ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Naꞌ to beꞌnn re José beꞌnn Arimatea, nakeꞌ beꞌnn brao radj beꞌnn kaꞌ llnebiaꞌ Israel naꞌ; leskaꞌ ba lloneꞌ rez batenꞌ sorao nnebiaꞌ beꞌnnenꞌ wseꞌl Diosenꞌ. Leꞌe beneꞌ raꞌll-lloy byejeꞌ rao Pilatonꞌ, naꞌ bnnabeꞌ kwerp ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ka bene Pilatonꞌ ba got Jesúsenꞌ, naꞌll llabanreꞌ, naꞌll goxheꞌ beꞌnn xan wakaꞌa ya kaꞌ nench bnnabreꞌ leꞌe chaꞌ da li yaꞌnnenꞌ ba goteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Naꞌ beꞌnn wakaꞌa yanꞌ lleꞌe leꞌe, da likzenꞌ ba goteꞌ, naꞌll beꞌe Pilatonꞌ latjeꞌ waletj Josénꞌ kwerp ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josénꞌ weꞌweꞌ to xchan, da baraꞌlleꞌ Leꞌe, ka baletjeꞌ Leꞌe leꞌ yay cruzenꞌ; naꞌll jakwaꞌch akeꞌ Leꞌe to lo ba da bcheꞌnneꞌ leꞌ yej. Naꞌll btoleꞌ to yej xhen lloaꞌ brojenꞌ nench bsejen len. ");
INSERT INTO zpuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena naꞌ ren María xhnaꞌ Josénꞌ, ze akeꞌ llwia akeꞌ ganꞌ broꞌ akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ka bde lla nbaꞌnne María Magdalena naꞌ ren María xhnaꞌ Jacobo naꞌ ren Salomé, weꞌo akeꞌ da laꞌ xhix nench lljawat akeꞌn kwerp ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Naꞌ nna nakte nnaxte lla dmionꞌ zjakeꞌ lloaꞌ banꞌ, le llraꞌte will bllin akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Naꞌ zjakeꞌ tnez lle lwellj akeꞌ: —¿Noxha wakaꞌa yejenꞌ danꞌ daꞌa lloaꞌ ba naꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bixha ka bllin akeꞌ naꞌn, breꞌe akreꞌ ba lliꞌ yej xhen naꞌ kaꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ka byoꞌ akeꞌ lo ba naꞌn, breꞌe akreꞌ to beꞌnn llaban llieꞌ chlaꞌ chaꞌore, naꞌ nakeꞌ to raꞌll tonne llichenꞌ kwis, naꞌll to blleb akzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naꞌll lleꞌe leakeꞌ: —Bi llebre, Jesús beꞌnn Nazaret naꞌn llayirjre, beꞌnnenꞌ bdaꞌa akeꞌ leꞌ yay cruzenꞌ. Ba babán beꞌnnenꞌ, nollno xhoa ganni, lewiá ke ganꞌ bxhoeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lelljayell beꞌnn kaꞌ non Leꞌe txhen naꞌ kaꞌ, ren Pedro naꞌ, ba za lliarao Jesúsenꞌ zayejeꞌ Galilea, gannaꞌ reꞌreꞌ kanꞌ bnekzeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naꞌll bazaꞌdo akeꞌ lloaꞌ banꞌ blleb akeꞌ kwis, notno llalwill akseꞌ le zebraz lleb akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ka nak babán Jesúsenꞌ zir dmio naꞌ, zgaꞌtek María Magdalena naꞌ, broeꞌraweꞌ, noꞌrenꞌ babejeꞌ gall daxiꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naꞌ leꞌe le jatixjweꞌtereꞌ beꞌnn kaꞌ yelaꞌ bnao Jesúsenꞌ, le llaꞌa akeꞌ llakyaꞌch akreꞌ bell akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ka nak ben akreꞌ nbaneꞌ, naꞌ ba breꞌe noꞌr kaꞌ Leꞌe, naꞌ bi byejleꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bde gok ki, chop beꞌnn kaꞌ non Jesúsenꞌ txhen zjakeꞌ lyiꞌxe, naꞌ Jesúsenꞌ broeꞌraweꞌ leakeꞌ, nllaꞌre kanꞌ broeꞌraweꞌ beꞌnn kaꞌ to kwen. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naꞌ leakeꞌ jatixjweꞌ akreꞌ beꞌnn kaꞌ yelaꞌ, naꞌ ni ke byejleꞌze beꞌnn kaꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ka bde gok kaꞌ, naꞌll broeꞌraweꞌ yeolol beꞌnn chnej kaꞌ, ka lliꞌ akeꞌ llao akeꞌ. Naꞌll benreꞌ leakeꞌ znia yel yichjraꞌlldaꞌo war ke akeꞌn, le bi llejleꞌ akeꞌ ke beꞌnn kaꞌ breꞌe Leꞌen kanꞌ babaneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naꞌll lleꞌe leakeꞌ: —Nnaꞌ chejre doxhen yellrio lelljatixjweꞌ xtiꞌllaꞌn rao yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Beꞌnn kaꞌ wxenraꞌll akeꞌ nadaꞌ, naꞌ choa akeꞌ nis, leakeꞌn yerá. Zan beꞌnn kaꞌ bi wxenraꞌll akeꞌ nadaꞌ kweyiꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Beꞌnn kaꞌ wxenraꞌll nadaꞌ, wroeꞌ akreꞌ yel wak kiaꞌn, da ki gon akeꞌ: kone raꞌa nadaꞌ, yebej akeꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne, naꞌ nne akeꞌ to diꞌll kobe. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Laꞌkze chaꞌ goꞌx akeꞌ bel znia, bibi gónebaꞌ leakeꞌ, laꞌkze yeꞌj akeꞌ da nak zi got leakeꞌ, bibi gak akreꞌ, wxoa taꞌk akeꞌ yichj beꞌnn weꞌe, naꞌ wayakte beꞌnn weꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Xanllo Jesúsenꞌ, bayoll beꞌreneꞌ leakeꞌ diꞌll ki, zayejeꞌ yebá, naꞌ jallieꞌ kwit Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, bllach akeꞌ jatixjweꞌ akreꞌ xtiꞌlleꞌn do gateze. Naꞌ Xanllonꞌ gokreneꞌ leakeꞌ, ben akeꞌ yel wak nench byejleꞌ beꞌnn kaꞌ nakse xtiꞌlleꞌn da li. Kaꞌn gakchga.");
INSERT INTO zpuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Beꞌnn zan ba gokraꞌll akeꞌ wllia akeꞌ yich danꞌ gok radjtoꞌ ni, le naken to da li, ");
INSERT INTO zpuNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","naꞌ llonen bien wayojen kon kanꞌ bzejnieꞌ beꞌnn kaꞌ, breꞌe da nellte kanꞌ goken. Leakeꞌn gok rallnaꞌa akeꞌ wzejnieꞌ akreꞌn beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nadaꞌ leskaꞌ ba bnnabyollaꞌ kwasro, akrenꞌ gok ka bxhen da nellte. Ke len naꞌ, nnaꞌ llzojaꞌn koꞌo rweꞌ, Teófilo, llapaꞌ rweꞌ baraꞌnne, ");
INSERT INTO zpuNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nench wayoll nnezroꞌ ka nak da linꞌ ba nnézkzeroꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kanꞌ llnebiaꞌ beꞌnnenꞌ golle Herodes ganꞌ nziꞌi Judea, bzo to bxoz re Zacarías. Zacaríasenꞌ nakeꞌ txhen bxoz kaꞌ nziꞌi Abías. Naꞌ noꞌr ke Zacaríasenꞌ re Elisabet, naꞌ nakeꞌ xhiꞌnn dialla ke da Aarón, beꞌnnenꞌ gok bxoz nelle. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Llon akeꞌ doxhen kanꞌ ne ley ke Diosenꞌ, naꞌ beꞌnn wen kwis nak akeꞌ, to nono bi ne ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nono xhiꞌnn akeꞌ niꞌte, le Elisabetenꞌ nakeꞌ beꞌnn will, naꞌ ba nak akeꞌ beꞌnn gore. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kate bllin lla bayaꞌl Zacaríasenꞌ ren beꞌnn lwelljeꞌ kaꞌ, choꞌ akeꞌ yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Naꞌ kanꞌ llonkze bxoz kaꞌ, llbej twej twej akeꞌ nench lloeꞌ lljazeyeꞌ yar rao bkoy yodaꞌon. Naꞌ bayaꞌlkze Zacaríasenꞌ goneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chak lley yarenꞌ rao bkoy yodaꞌon, beꞌnn zan llaꞌa liaꞌre llalwill akeꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bixha bllinkze to angl ke Xanllo Dios ganꞌ ze Zacaríasenꞌ, naꞌ jasé anglenꞌ kwit bkoy ganꞌ llzeyeꞌ yarenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ka breꞌe Zacaríasenꞌ anglenꞌ, to gokllejlaꞌllzeꞌ, le llebrazenꞌ bllebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naꞌll anglenꞌ golleꞌ leꞌe: —Bi lleboꞌ Zacarías, Diosenꞌ ba bzenayeꞌ ke danꞌ llnnaboꞌn, naꞌ nnaꞌ noꞌr koꞌo Elisabetenꞌ so to xhiꞌnneꞌ, naꞌ wsiꞌobeꞌ Juan. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Naꞌ soꞌo nbaraz, yeweroꞌ, naꞌ beꞌnn zan yewerén akreꞌ reꞌ katenꞌ ba gorjbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bidaꞌon gakbeꞌ bi zaꞌk rao Dios, bi yeꞌjbeꞌ xis uva, naꞌ billre da llsolle beꞌnne, naꞌ sorén Spíritu ke Diosenꞌ lebeꞌ ka za garjterbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naꞌ gonbeꞌ nench beꞌnn zan beꞌnn Israel kaꞌ, wayechj akeꞌ weꞌrao akeꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Naꞌ kwiaraobeꞌ rao Xanllonꞌ, naꞌ Diosenꞌ weꞌebeꞌ Spíritu keꞌen, naꞌ gonbeꞌ kanꞌ ben Elías, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. Beꞌnn dilrén xhiꞌnneꞌ, gonbeꞌ waniꞌt akeꞌ wen; beꞌnn bi llzenay, gonbeꞌ nench wzenayeꞌ. Naꞌ gonbeꞌ nench beꞌnn kaꞌ nniꞌt akeꞌ xhnid, weꞌrao akeꞌ Xanllonꞌ katenꞌ yedeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Naꞌll Zacaríasenꞌ lleꞌe anglenꞌ: —¿Akxha gak nnezraꞌ chaꞌ da li gak kanꞌ ba bneꞌo nga? Le ba nakaꞌ beꞌnn gore, leskaꞌ noꞌr kiaꞌn ba ngoreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Naꞌll lle anglenꞌ leꞌe: —Nadaꞌn nakaꞌ angl Gabriel, naꞌ llonaꞌ xchin Dios, Leꞌen bseꞌleꞌ nadaꞌ nench zadtixjweꞌraꞌ rweꞌ diꞌll wen nga. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naꞌ nnaꞌ gaꞌnnoꞌ blloje, bi gak nneꞌo llinte katenꞌ garj xhiꞌnnoꞌn, le bi byejleꞌo kanꞌ bniaꞌn, le da li da gakten. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Beꞌnn zan kaꞌ llaꞌa liaꞌre, llbexh akeꞌ Zacaríasenꞌ, naꞌ llabán akreꞌ danꞌ bi llallojzeꞌ lo yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bixha kate ballojeꞌn, kere gokll nneꞌe, naꞌ lloneꞌ zre senze, naꞌ bayakbeꞌe beꞌnn kaꞌ, breꞌdaꞌoreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ka bayoll xhman keꞌen naꞌ zayejeꞌ rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bde naꞌ, biaꞌa xhiꞌnn Elisabet noꞌr ke Zacaríasenꞌ. Gaꞌy beꞌo bzozeꞌ yoꞌ keꞌe, bi bllojkzeꞌ, naꞌll lloeꞌrén kwineꞌ diꞌll neꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nnaꞌll ba ben Diosenꞌ wen kiaꞌ, ba bakeꞌe yel zdoꞌ kiaꞌn, nollno nne kiaꞌ nna nakllaꞌ beꞌnn will.” ");
INSERT INTO zpuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ba gok xop beꞌo noaꞌ Elisabetenꞌ bdaꞌo keꞌen, kate bseꞌl Diosenꞌ anglenꞌ re Gabriel to yell da nziꞌi Nazaret ganꞌ nbane Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bseꞌleꞌ leꞌe ga zo to noꞌr daꞌo, re María, ba naken siꞌi to beꞌnn re José leꞌe, naꞌ Josénꞌ nakeꞌ xhiꞌnn dialla rey David. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka byoꞌ anglenꞌ lo yoꞌ ganꞌ zo Maríanꞌ, lleꞌe leꞌe: —¡Padiox, Dios zoreneꞌ rweꞌ, nnaꞌ goneꞌ wen koꞌo, gonlaꞌyeꞌ rweꞌ wdetere ka noꞌr kaꞌ yelaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maríanꞌ bllebeꞌ kwis, naꞌ llakreꞌ bixchen lleze anglenꞌ leꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Naꞌ anglenꞌ lleꞌe leꞌe: —María, bi lleboꞌ, Diosenꞌ ba brejeꞌ rweꞌ, naꞌ goneꞌ wen koꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Goꞌo bdaꞌo, so to xhiꞌnnoꞌ, naꞌ wsiꞌobeꞌ Jesús. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Naꞌ Jesúsenꞌ gakeꞌ to beꞌnn brao, wsiꞌi akeꞌ Leꞌe Xhiꞌnn Dios beꞌnn zo yebá. Naꞌ Xanllo Diosenꞌ goneꞌ nench nnebieꞌ kanꞌ bnebiaꞌ David xozxtaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nnebieꞌ ganꞌ nziꞌi Israel ke chnare, naꞌ bi te yel llnebiaꞌ keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Naꞌll lle Maríanꞌ anglenꞌ: —¿Akxha gakrizen le bi nna wchaynaꞌa? ");
INSERT INTO zpuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Naꞌll goll anglenꞌ leꞌe: —Yed Spíritu ke Diosenꞌ choꞌn yichjraꞌlldaꞌon, naꞌ yel wak ke Dios beꞌnn zo yebá son kweꞌjen rweꞌ, ke len naꞌ bidaꞌon garjenꞌ gakbeꞌ bi ke Dios, naꞌ wsiꞌi akebeꞌ Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Leskaꞌ noꞌr biroꞌ, Elisabetenꞌ, noꞌrenꞌ nak noꞌr will batnaꞌ, ba gok xop beꞌo nnaꞌ, noeꞌ bdaꞌo laꞌkze ba nakeꞌ beꞌnn gore. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Le bibi de da nak bniꞌ, da bi gak gon Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Naꞌll lle Maríanꞌ anglenꞌ: —Ni zoaꞌ nakaꞌ beꞌnn wen llin keꞌe, wakse gon Diosenꞌ kiaꞌ kanꞌ ba bneꞌo nga. Kaꞌ gok, naꞌ bazaꞌa anglenꞌ zayejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bde chop chonn lla, le byejte Maríanꞌ to yell da llia rao yaꞌ ganꞌ nbane Judea. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Naꞌ bllineꞌ rill Zacaríasenꞌ, naꞌ byoeꞌ bwapeꞌ Elisabetenꞌ lliox. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bixha kate bene Elisabetenꞌ balwill Maríanꞌ leꞌe, le bxhiꞌtte bdaꞌo keꞌen lo leꞌen, naꞌ Spíritu ke Diosenꞌ byoꞌn yichjraꞌlldaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naꞌ bawereꞌ kwis bnneꞌe zillj, lleꞌe Maríanꞌ: —Dios ba benlaꞌyeꞌ rweꞌ rao yeololte noꞌre, leskaꞌ bdaꞌo koꞌon nak laꞌybeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Xhnaꞌ Xanllo ba nakoꞌ, ker bi zaꞌkandaꞌ. ¿Bixchen zadraꞌnnzoꞌ nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kate bnneꞌon, le bxhiꞌtte bdaꞌo kiaꞌn lo liaꞌn bawebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nbaraz koꞌo rweꞌ ba byejleꞌo, da li gonte Diosenꞌ kanꞌ ba golleꞌ rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Naꞌll bne Maríanꞌ lloeꞌraweꞌ Dios: Lloeꞌrawaꞌ Diosenꞌ do yichj do raꞌllaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Naꞌ lo yichjraꞌlldaꞌwaꞌ llaweraꞌ, le Diosenꞌ nakeꞌ wasrá kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Laꞌkze nakaꞌ ka to beꞌnn wen llin, bibi zaꞌkaꞌ, Diosenꞌ bayaꞌchraꞌlleꞌ nadaꞌ. Naꞌ beꞌnn zan beꞌnn llaꞌa nnaꞌ, naꞌ beꞌnn za chaꞌa yellrio ni, nne akeꞌ kiaꞌ: “Nbaraz ke noꞌrenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diosenꞌ nakeꞌ beꞌnn wen, napeꞌ yel wak xhen, ba beneꞌ da wen kwis kiaꞌ. ¡Leꞌe nak laꞌye kwis! ");
INSERT INTO zpuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Noteze beꞌnn llape Diosenꞌ baraꞌnne, leskaꞌ Diosenꞌ wayaꞌchraꞌlleꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Naꞌll ba broeꞌreꞌ yel wak xhen keꞌen, naꞌ bachinnjeꞌ xhbab ke beꞌnn yaꞌraꞌll kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Beꞌnn llnebiaꞌ, beꞌnn llon ka beꞌnn brao, ba blliꞌyeꞌ beꞌnn kaꞌ kaꞌle, naꞌ blepeꞌ beꞌnn yaꞌch, beꞌnn nexjraꞌll kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Beꞌnn yaꞌche, beꞌnn don, ba beꞌe leakeꞌ ka yerj akreꞌ, zan beꞌnn wniaꞌ kaꞌ, laꞌkze bze taꞌk akeꞌ, bibi beꞌe leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ba gokreneꞌ Israelenꞌ, le yell keꞌen, le jadinraꞌlleꞌ wayaꞌchraꞌlleꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ka diꞌll beꞌreneꞌ xozxtaꞌollo Abraham, bneꞌe gonlaꞌyeꞌ yeolol xhiꞌnneꞌ za chaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Chonn beꞌo bzorén Maríanꞌ Elisabetenꞌ, naꞌll bazeꞌe zayej rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bixha kate bllin lla garj bdaꞌo ke Elisabetenꞌ, bzo to bidaꞌo byio. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ka gokbeꞌe biꞌch lwelljeꞌ kaꞌ, naꞌ beꞌnn wrill ke akeꞌ, kanꞌ ba gokrén Diosenꞌ Elisabetenꞌ, ren akeꞌ bawerén akreꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gok xoꞌn lla naꞌ, jweꞌebeꞌ bzobeꞌ sen danꞌ nziꞌi circuncisión. Naꞌ gokraꞌll akeꞌ wsiꞌi akebeꞌ kanꞌ re xabeꞌn, Zacarías. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Naꞌ xhnaꞌbeꞌn bneꞌe: —Kaꞌa, bi siꞌbeꞌ kaꞌ, Juan, siꞌbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Naꞌ lle akeꞌ leꞌe: —¿Bixchen? Nono biꞌch lwelljre llraꞌ beꞌnn re kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naꞌll ben akeꞌ sen rao xabeꞌn, llnnab akreꞌ leꞌe akre lleꞌnreꞌ siꞌi bdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naꞌ bnnabeꞌ to bray daꞌo, naꞌ bzojeꞌn bllieꞌn: “Juan, siꞌbeꞌ.” Yeolol beꞌnn kaꞌ llabán akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Naꞌ le gokte banné Zacaríasenꞌ, le bzoraote lloeꞌraweꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yeolol beꞌnn wrill ke akeꞌ kaꞌ, blleb akeꞌ kwis, naꞌ yeolol yell kaꞌ zjalliꞌ radj yaꞌ kaꞌ, doxhen yaꞌn ganꞌ nbane Judeanꞌ, goslas diꞌll kanꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Naꞌ yeolol beꞌnn kaꞌ llene diꞌllenꞌ, da xhen llayón akeꞌ xhbab lo yichjraꞌlldaꞌo akeꞌ, ne akeꞌ: —¿Notek gak bidaꞌon? Le nakbieꞌtekze llonlaꞌy Diosenꞌ lebeꞌ tlla tlla. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Spíritu ke Diosenꞌ byoꞌn yichjraꞌlldaꞌo Zacaríasenꞌ, naꞌ benen nench beꞌe diꞌll ki: ");
INSERT INTO zpuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nak laꞌy kwis Xanllo Diosenꞌ ke lliꞌo beꞌnn Israel, le ba breꞌe nench yesreꞌe lliꞌo nakllo yell keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Rao dialla David beꞌnn ben xchin Dios batnaꞌ, ba bliseꞌ to beꞌnn nap yel wak nench yesreꞌe lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ka diꞌllenꞌ beꞌrén Diosenꞌ beꞌnn kaꞌ, beꞌe xtiꞌlleꞌn kanaꞌ, le leakeꞌn bzejnieꞌ akreꞌ beꞌnn xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bchebeꞌ yesreꞌe lliꞌo rao naꞌa beꞌnn kaꞌ, bi zorén lliꞌo wen, naꞌ rao naꞌa beꞌnn kaꞌ, llwie lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Naꞌ bchebeꞌ wayaꞌchraꞌlleꞌ xozxtaꞌollo kaꞌ, naꞌ bi kwej yichjeꞌ ka diꞌllenꞌ beꞌreneꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Leskaꞌ golleꞌ xozxtaꞌollo Abraham naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wllin lla kate yesreꞌe lliꞌo rao naꞌa beꞌnn kaꞌ llwie lliꞌon, nench gak weꞌraolloeꞌ, billbi nxholl sollo chaꞌ gonllo xchineꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Naꞌllenꞌ gonllo da wen, gakllo rallneꞌe ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naꞌ rweꞌ, xhiꞌnnaꞌ, beꞌnn lloeꞌ xtiꞌll Dios beꞌnn zo yebá, nne akeꞌ koꞌo, rweꞌ kwiarao rao Xanllonꞌ, gonchaꞌo gonoꞌ xhnid ganꞌ tieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Rweꞌ wzejnieꞌroꞌ beꞌnn Israel kaꞌ, kanꞌ lleꞌne Diosenꞌ yeziꞌxheneꞌ da xhinnj ke akeꞌn, naꞌ kanꞌ lleꞌnreꞌ yesreꞌe leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios kellonꞌ, yel llayaꞌchraꞌll keꞌen ba beneꞌ, nnaꞌ reꞌllo beniꞌn zaꞌa yebá. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Beꞌnn llaꞌa xchole, ka ga de yel got, reꞌe akreꞌ beniꞌ keꞌen, naꞌllenꞌ reꞌllo garenꞌ kaꞌllo, naꞌ chejnieꞌllo ka gonllo nench chaꞌllo wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bixha bidaꞌon zjaze ll-lliꞌobeꞌ, llejnieꞌtebeꞌ doxhen kanꞌ lleꞌne Diosenꞌ, naꞌ bzoteze bzobeꞌ yiꞌxe ga nak latj dach, bllinte lla broeꞌraobeꞌ beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gok kanꞌ llnebiaꞌ beꞌnnenꞌ re Augusto César ganꞌ nziꞌi Roma, bdixjweꞌreꞌ llayaꞌl kwia yich, yeolol beꞌnn kaꞌ llaꞌa doxhen ganꞌ nbanreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Naꞌ naken da nell kwia beꞌnn yiche. Le kanaꞌ beꞌnnenꞌ re Cirenio, llnebieꞌ ganꞌ nziꞌi Siria. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Naꞌ beneꞌn bien yeolol beꞌnn bayej rall akeꞌ, jallia akeꞌ yiche. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Naꞌ Josénꞌ bzeꞌe Nazaret ga nbane Galilea, naꞌ bayejeꞌ Belén ga nbane Judea yell ke David, le xhiꞌnn dialla David naꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Zancheꞌteꞌ Maríanꞌ nench kwia akeꞌ yiche, ba naken siꞌi lwellj akeꞌ. Naꞌ ba noaꞌ Maríanꞌ bdaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Naꞌ zo akteꞌ Belén naꞌ, bllin lla saneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Naꞌ gorj bdaꞌo keꞌen, gokbeꞌ bidaꞌo byio, bi nelle, naꞌ braꞌllebeꞌ to raꞌlle, naꞌ jaxoeꞌbeꞌ ganꞌ ll-llaꞌa akeꞌ da llao bayiꞌxe, le bibi latj bllel akreꞌ ga weꞌe akeꞌ waziꞌraꞌll akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Rao yer naꞌ, awllo Belén naꞌ, llaꞌa bal beꞌnn llnnaꞌ akeꞌ yer, llap xhiꞌr ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kate to angl ke Xanllonꞌ bllineꞌ ganꞌ llaꞌa akeꞌn, to yiꞌ xhen bseniꞌn ganꞌ llaꞌa akeꞌn, naꞌ blleb akeꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Naꞌ anglenꞌ golleꞌ leakeꞌ: —Bi llebre, naꞌ llyixjweꞌraꞌ reꞌ to da wen, da wayoꞌraꞌll yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nnaꞌ gorj to wasrá, gorjeꞌ rao yell ke David, naꞌ reꞌe Cristo beꞌnn nak Xanllo. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chaꞌ chejre, ki nak nench yellélere bdaꞌon: llelbeꞌ to raꞌll, naꞌ xhoabeꞌ ga ll-llaꞌa akeꞌ da llao bayiꞌx ake. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nna nete anglenꞌ kaꞌ, kate bllinkze angl zanll ganꞌ ze anglenꞌ to, naꞌ angl zan kaꞌ, lloeꞌrao akeꞌ Dios ne akeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Doweꞌrao Dios beꞌnn zo yebá! ¡Naꞌ beꞌnn kaꞌ llaꞌa rao yellrionꞌ, chaꞌa akchgueꞌ xhbab wen, naꞌ kaꞌ bibi wdil kweꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ka bazaꞌa angl kaꞌ zayej akeꞌ yebá, gop xhiꞌr kaꞌ lle lwellj akeꞌ: —Chejkello Belén naꞌ, lljawiallo bixhanꞌ gokse, ka danꞌ bdixjweꞌ Xanllonꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Naꞌ broꞌdo akeꞌ nez, ka bllin akeꞌn, naꞌ jadiꞌ akreꞌ Maríanꞌ ren Josénꞌ ren bdaꞌon, xhoabeꞌ ganꞌ ll-llaꞌa akeꞌ da llao bayiꞌx kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ka breꞌe gop xhiꞌr kaꞌ bdaꞌon, bzorao lloeꞌ akeꞌ diꞌll doxhen kanꞌ goll anglenꞌ leakeꞌ ke bdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yeolol beꞌnn kaꞌ bene diꞌllenꞌ lloeꞌ akeꞌn, llabán akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríanꞌ broꞌ yichjeꞌ kanꞌ bne beꞌnn kaꞌ, naꞌ lloneꞌ xhbab lo raꞌlldaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bde naꞌ, zayej gop xhiꞌr kaꞌ, lloeꞌrao akeꞌ Dios kon ba jawiá akeꞌ, naꞌ ba ben aktereꞌ kanꞌ goll anglenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ka gok xoꞌn lla naꞌ, bzoeꞌ bdaꞌon sen danꞌ nziꞌi circuncisión, naꞌ bsiꞌi akebeꞌ Jesús, kanꞌ goll anglenꞌ leakeꞌ ka za garjterbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bde ba bayak Maríanꞌ ren bdaꞌon yall kon kanꞌ ne ley danꞌ bzoj da Moisésenꞌ, naꞌ jweꞌebeꞌ yodaꞌo Jerusalén naꞌ, ga gakbeꞌ rallnaꞌa Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Le kanꞌ ne ley ke Xanllo Diosenꞌ: “Noteze bidaꞌo byio garj bi nelle, da bien naꞌ gakbeꞌ rallnaꞌa Dios.” ");
INSERT INTO zpuNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naꞌ byej akeꞌ beꞌrao akeꞌ Dios, ben akeꞌ kanꞌ ne ley keꞌen, ganꞌ nen ki: “Llayaꞌl gotre chop plom xtir o chaꞌ chop plom yiꞌx daꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naꞌ Jerusalén naꞌ, zo to beꞌnn re Simeón, naꞌ nakeꞌ to beꞌnn wen, naꞌ nxenraꞌlleꞌ Dios, bzoteze bzoeꞌ brexheꞌ katenꞌ llin lla gakrén Diosenꞌ beꞌnn Israel kaꞌ, naꞌ zorén Spíritu ke Diosenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Spíritu ke Diosenꞌ bdixjweꞌn leꞌe ke za gattereꞌ, dekz de reꞌreꞌ Cristo beꞌnnenꞌ wseꞌl Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Leskaꞌ Spíritu naꞌ, benen nench byejeꞌ yodaꞌo braonꞌ. Yodaꞌo naꞌ zoeꞌ kate bllin xaxhnaꞌ Jesúsenꞌ gon akeꞌ kanꞌ ne ley ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón naꞌ bnnabeꞌ bidaꞌon bdeꞌlebeꞌ, naꞌ beꞌraweꞌ Diosenꞌ bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ba gokse nnaꞌ Dios kiaꞌ, baziꞌchga nadaꞌ wen, nakaꞌ beꞌnn wen llin koꞌo, kon ka diꞌllenꞌ beꞌrenoꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Rawaꞌ ki nnaꞌ llreꞌren beꞌnnenꞌ yesrá netoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Naꞌ ba benoꞌ to da reꞌte beꞌnn zan. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bidaꞌon gakbeꞌ beniꞌ, nench chejnieꞌ beꞌnn bi nak beꞌnn Israel, naꞌ Lebeꞌ gon nench siꞌi yell koꞌo Israelenꞌ yel baraꞌnn xhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naꞌll xaxhnaꞌ Jesúsenꞌ llabán akreꞌ, ka llen akreꞌ diꞌllenꞌ lloeꞌ Simeón naꞌ ke bdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón naꞌ, bnnabeꞌ rao Dios gonlaꞌyeꞌ leakeꞌ. Naꞌll lleꞌe Maríanꞌ: —Ni ke bidaꞌon beꞌnn zan beꞌnn Israel kaꞌ kweyiꞌ akeꞌ, naꞌ beꞌnn zan yerá akeꞌ. Lebeꞌ gakbeꞌ to da wroeꞌn danꞌ bseꞌl Diosenꞌ Lebeꞌ, naꞌ beꞌnn zan bi choꞌraꞌll akeꞌ danꞌ ben Diosenꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Leskaꞌ gonbeꞌ nench gaꞌtbiaꞌ nore beꞌnn llaꞌa xhbab wen, naꞌ nore llaꞌa xhbab da bi nak wen. Naꞌ rweꞌ, kaꞌkze to da látit chaz lo raꞌlldaꞌon, katek wallayraoꞌ ke bidaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Leskaꞌ bzo to noꞌr re Ana, Jerusalén naꞌ. Naꞌ Ananꞌ lloeꞌ xtiꞌll Dios, nakeꞌ xhiꞌnn Fanuel, beꞌnn nak xhiꞌnn dialla beꞌnnenꞌ re Aser. Naꞌ ba nakeꞌ beꞌnn gor, gall iz bzorén xhyiweꞌn leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Naꞌ bgaꞌnneꞌ wazeb got xhyiweꞌn, ba gok tapralj tap (84) iz. Naꞌ yeo lla bzoteze bzoeꞌ yodaꞌo braonꞌ, lloeꞌraweꞌ Dios, llalwilleꞌ Dios do lla do yere, naꞌ lloneꞌ was. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naꞌ goken jabiꞌyeꞌ ganꞌ ze Josénꞌ ren Maríanꞌ, naꞌ lloeꞌ yel llioxken ke Dios, naꞌ bzorao lloeꞌ xtiꞌll bidaꞌon rao yeolol beꞌnn kaꞌ llaꞌa, lloeꞌreneꞌ diꞌllenꞌ yeololte beꞌnn llbexh, batenꞌ wseꞌl Diosenꞌ beꞌnnenꞌ gakrén leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ka bayoll ben Maríanꞌ ren Josénꞌ yeolol kanꞌ ne ley ke Diosenꞌ, naꞌ zayej akeꞌ Nazaret ganꞌ nbane Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naꞌ Jesúsenꞌ zejze ll-lliꞌweꞌ, naꞌ zejzell llejnieꞌreꞌ tlla tlla, naꞌ kaꞌ llakrente Diosenꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Naꞌ ganꞌ nziꞌi Jerusalén naꞌ llon beꞌnn Israel kaꞌ lnni danꞌ ne paskw, naꞌ xaxhnaꞌ Jesúsenꞌ yeo iz lljakeꞌ lnninꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ka goke Jesúsenꞌ chllinn (12) iz, bcheꞌe akeꞌ Leꞌe lnni Jerusalén naꞌ, kanꞌ llon akseꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ka bde lnninꞌ bazaꞌa akeꞌ, naꞌ bi gokbeꞌe Josénꞌ ren Maríanꞌ, bagaꞌnn Jesúsenꞌ Jerusalén naꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Llak akreꞌ chaꞌ zazaꞌreneꞌ beꞌnn kaꞌ yelaꞌ. Ba gokte tlla bagoꞌ akeꞌ nezenꞌ ka gokbeꞌe akreꞌ, naꞌ bzorao llayirj akeꞌ Leꞌe radj biꞌch lwellj akeꞌ kaꞌ, naꞌ beꞌnn nombiaꞌ akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Naꞌ bi llallel akreꞌ Leꞌe, naꞌ babiꞌ akeꞌ Jerusalén naꞌ, da yobre llayirj akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bixha bayónn lla kate ballel akreꞌ Leꞌe lo yodaꞌo braonꞌ, naꞌ llieꞌ radj beꞌnn siꞌn kaꞌ, llroeꞌ xtiꞌll Diosenꞌ, llzenayeꞌ xtiꞌll akeꞌn, naꞌ llnnabyollreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Beꞌnn kaꞌ llaꞌa llzenayenꞌ, llabán akreꞌ katkenꞌ llejnieꞌreꞌn, naꞌ kanꞌ llallieꞌ xtiꞌll beꞌnn siꞌn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bixha ka breꞌe xaxhneꞌe kaꞌ Leꞌen, llabán akreꞌ, naꞌ goll xhneꞌen Leꞌe: —Xhiꞌnnaꞌ, ¿bixchen ba benzroꞌ netoꞌ kaꞌ? Xaꞌon naꞌ ren nadaꞌ, le ba bdatoꞌ bayirjtoꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naꞌll Jesúsenꞌ lleꞌe leakeꞌ: —¿Bixchen llayirjzre nadaꞌ? ¿Bi nnézere xchin Xaꞌ naꞌn llayaꞌl gonaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bixha xaxhneꞌe kaꞌ, bi byejnieꞌ akreꞌ bixchen golleꞌ leakeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naꞌ kaꞌ, zayej akeꞌ Nazaretenꞌ zancheꞌe akteꞌ Jesúsenꞌ, naꞌ bzenayteze bzenayeꞌ ke akeꞌ. Naꞌ Maríanꞌ kon lloneꞌ xhbab lo yichjraꞌlldaꞌweꞌ kanꞌ llaken. ");
INSERT INTO zpuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naꞌ kaꞌ, blliꞌo Jesúsenꞌ llejnieꞌreꞌ, Diosenꞌ naꞌ ren beꞌnn ak, llayoꞌraꞌll akeꞌ kanꞌ lloneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kanꞌ ba gok chiꞌno (15) iz llia beꞌnnenꞌ re Tiberio César, beꞌnnenꞌ nak zerao wnebiaꞌ ganꞌ nbane Roma, Poncio Pilatonꞌ leskaꞌ llnebieꞌ ganꞌ nziꞌi Judea, naꞌ Herodesenꞌ llnebieꞌ ganꞌ nziꞌi Galilea, naꞌ biꞌch Herodes beꞌnnenꞌ re Felipe nakeꞌ beꞌnnenꞌ llnebiaꞌ ganꞌ nziꞌi Iturea, naꞌ ganꞌ nziꞌi Traconite, naꞌ beꞌnnenꞌ re Lisanias nakeꞌ beꞌnnenꞌ llnebiaꞌ ganꞌ nziꞌi Abilinia. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Naꞌll Anás naꞌ, naꞌ Caifás naꞌ, nak akeꞌ bxoz brao ke beꞌnn Israel kaꞌ. Iz naꞌ, beꞌrén Diosenꞌ Juan xhiꞌnn Zacaríasenꞌ diꞌlle ganꞌ zoeꞌ yiꞌxenꞌ, ganꞌ nak latj dachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Naꞌll byejeꞌ toto yell kaꞌ lliꞌ to lloaꞌ yeo Jordán naꞌ, llyixjweꞌreꞌ beꞌnne llayaꞌl wayat akreꞌ ke da xhinnj non akeꞌ, naꞌ choa akeꞌ nis nench waziꞌxhen Diosenꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Llak kanꞌ bzoj Isaías beꞌnn beꞌe xtiꞌll Diosenꞌ kanaꞌ, bneꞌe ke Juan naꞌ: To beꞌnn llosiaꞌ lyiꞌxenꞌ neꞌe: “Legón xhnid, legonchaꞌo nez ganꞌ te Xanllonꞌ, lewsarj yichjraꞌlldaꞌore ka llon to beꞌnn llsarj to nez li. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ga nak lotj, llayaꞌl wallaꞌn yo, ga de nez da llep llaze, llayaꞌl wayaꞌten li. Ga bi nak lixheje, wayaꞌt linꞌ, naꞌ nez da niꞌt yej, llayaꞌl wayej lben. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yeolol beꞌnn llaꞌa yellrio ni, reꞌe akreꞌ kanꞌ yesrá Diosenꞌ beꞌnne.” ");
INSERT INTO zpuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Beꞌnn zan jakeꞌ rao Juan naꞌ, nench wchoeꞌ leakeꞌ nis, naꞌll benreꞌ leakeꞌ znia bneꞌe: —¡Reꞌ nakre beꞌnn zban beꞌnn wxhiyeꞌe, llonre ka bele! ¿No bzejnieꞌ reꞌ, wak warare rao danꞌ wseꞌl Diosenꞌ katenꞌ goneꞌ yel koxchis ke beꞌnnachenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Chaꞌ rennere ba bayátere ke da xhinnjenꞌ nonre naꞌ, llayaꞌl gonre da wen nench gakbeꞌe beꞌnne ba ballaꞌa yichjraꞌlldaꞌore. Bi gonzre xhbab nnere: “Xhiꞌnn dia lla Abraham netoꞌ.” Yej kaꞌ niꞌt nga, wakte gon Diosenꞌ wayaken xhiꞌnn dialla Abraham. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Leskaꞌ ba noꞌxteꞌ banchenꞌ xhnid, yeolol yay da bi llbia daxhix wen, wchoyeꞌ do roe, gaken waye da wzeyeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Naꞌll beꞌnn kaꞌ llaꞌa naꞌ, lle akeꞌ leꞌe: —¿Akxha llayaꞌl gontoꞌ nnaꞌ chaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Naꞌll Juan naꞌ, lleꞌe leakeꞌ: —Chaꞌ de chop xherk kere, leweꞌe to xherk ke beꞌnn bibi de keꞌe. Naꞌ beꞌnn de da llaweꞌ, leskaꞌ weꞌe ke beꞌnn bi de da gaweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Naꞌ beꞌnn kaꞌ nak wachixhj, jabiꞌy akeꞌ lleꞌn akreꞌ choa akeꞌ nis, naꞌ lle akeꞌ leꞌe: —Maestro, ¿Bixha gon netoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naꞌll lle Juan naꞌ leakeꞌ: —Bi llayaꞌl wchixhjre da xhenll. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Leskaꞌ beꞌnn wakaꞌa ya kaꞌ bnnab akeꞌ, lle akeꞌ Leꞌe: —¿Bi llayaꞌl gon netoꞌ? Naꞌ lleꞌe leakeꞌ: —Bi wxoare koꞌll beꞌnne da wxhiyeꞌe, naꞌ bi wkaꞌre bi da de ke beꞌnne. Legón banez ka to da llonre gan. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Naꞌ beꞌnn zan beꞌnn Israel kaꞌ, ba llaꞌa akeꞌ dá nne, llon akeꞌ xhbab chaꞌ Juan naꞌ nak Cristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Naꞌll Juan naꞌ, lleꞌe beꞌnn zan kaꞌ llaꞌn: —Da li nadaꞌ llchoaꞌ beꞌnn nis, naꞌ za yed to beꞌnn naplle yel wak ka nadaꞌ, bi zaꞌkaꞌ nadaꞌ ka Leꞌe, ni gaz da wadiaꞌ xhereꞌ bi zaꞌkaꞌ. Leꞌe wchoeꞌ beꞌnn nis kon ren Spíritu ke Diosenꞌ, da gon ka llon yiꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Katenꞌ yedeꞌn, goneꞌ ka llon beꞌnn kate llsoeꞌ trigo, llazieꞌ trigonꞌ, naꞌ llzeyeꞌ yixh bebe ken. Leꞌe napeꞌ to yiꞌ da bi wayorkze. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Naꞌ kaꞌ, diꞌll zan da beꞌe Juan naꞌ, llyixjweꞌreꞌ Diꞌll Wen ke Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan naꞌ, leskaꞌ lleꞌe Herodes beꞌnnenꞌ llnebiaꞌ Judeanꞌ, ka da xhinnj xhen naꞌ noneꞌ, zoreneꞌ Herodías noꞌr ke biꞌcheꞌn re Felipe. Leskaꞌ lleteꞌ leꞌe ka nak billre da xhinnj lloneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naꞌ Herodes naꞌ, basyolleꞌ beneꞌ ye to da xhinnj xhen, broeꞌ Juan naꞌ rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bixha chak nna llchoa Juan naꞌ beꞌnn kaꞌ nis, leskaꞌ bllin Jesúsenꞌ, naꞌ bchoa Juan naꞌ Leꞌe nis. Bixha chak llalwill Jesúsenꞌ Dios naꞌn, byarj yebánꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","naꞌ Spíritu ke Diosenꞌ betjen bzorenen Leꞌe, naꞌ nak Spíritunꞌ ka to plom daꞌo, naꞌ ben akreꞌ be xhnne ke Diosenꞌ bneꞌe: —Rweꞌ nakoꞌ xhiꞌnnaꞌ nllieꞌraꞌ, llaweraꞌ llazraꞌllaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chilloa (30) ize Jesúsenꞌ, kanꞌ bzoraweꞌ lloneꞌ xchineꞌ danꞌ zadyeneꞌ rao yellrionꞌ, kon kanꞌ bne akeꞌ, gokeꞌ xhiꞌnn José, naꞌ Josénꞌ gokeꞌ xhiꞌnn Elí, ");
INSERT INTO zpuNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí naꞌ gokeꞌ xhiꞌnn Matat, Matat naꞌ gokeꞌ xhiꞌnn Leví, Levínꞌ naꞌ gokeꞌ xhiꞌnn Melqui, naꞌ Melqui naꞌ gokeꞌ xhiꞌnn Jana, Jana naꞌ gokeꞌ xhiꞌnn José. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José naꞌ gokeꞌ xhiꞌnn Matatías, naꞌ Matatías naꞌ gokeꞌ xhiꞌnn Amós, Amós naꞌ gokeꞌ xhiꞌnn Nahum, Nahum naꞌ gokeꞌ xhiꞌnn Esli, naꞌ Esli naꞌ gokeꞌ xhiꞌnn Nagai, ");
INSERT INTO zpuNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai naꞌ gokeꞌ xhiꞌnn Maat, naꞌ Maat naꞌ gokeꞌ xhiꞌnn Matatías, Matatías naꞌ gokeꞌ xhiꞌnn Semei, Semei naꞌ gokeꞌ xhiꞌnn José, naꞌ José naꞌ gokeꞌ xhiꞌnn Judá. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá naꞌ gokeꞌ xhiꞌnn Joana, Joana naꞌ gokeꞌ xhiꞌnn Resa, naꞌ Resa naꞌ gokeꞌ xhiꞌnn Zorobabel, Zorobabel naꞌ gokeꞌ xhiꞌnn Salatiel, Salatiel naꞌ gokeꞌ xhiꞌnn Neri. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Naꞌ Neri naꞌ gokeꞌ xhiꞌnn Melqui, Melqui naꞌ gokeꞌ xhiꞌnn Adi, Adi naꞌ gokeꞌ xhiꞌnn Cosam, naꞌ Cosam naꞌ gokeꞌ xhiꞌnn Elmodam, Elmodam naꞌ gokeꞌ xhiꞌnn Er. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er naꞌ gokeꞌ xhiꞌnn Josué, naꞌ Josué naꞌ gokeꞌ xhiꞌnn Eliezer, Eliezer naꞌ gokeꞌ xhiꞌnn Jorim, Jorim naꞌ gokeꞌ xhiꞌnn Matat. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Naꞌ Matat naꞌ gokeꞌ xhiꞌnn Leví, Leví naꞌ gokeꞌ xhiꞌnn Simeón, Simeón naꞌ gokeꞌ xhiꞌnn Judá, naꞌ Judá naꞌ gokeꞌ xhiꞌnn José, José naꞌ gokeꞌ xhiꞌnn Jonán, Jonán naꞌ gokeꞌ xhiꞌnn Eliaquim. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Naꞌ Eliaquim naꞌ gokeꞌ xhiꞌnn Melea, Melea naꞌ gokeꞌ xhiꞌnn Mainán, Mainán naꞌ gokeꞌ xhiꞌnn Matata, naꞌ Matata naꞌ gokeꞌ xhiꞌnn Natán. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán naꞌ gokeꞌ xhiꞌnn David, David naꞌ gokeꞌ xhiꞌnn Isaí, naꞌ Isaí naꞌ gokeꞌ xhiꞌnn Obed, Obed naꞌ gokeꞌ xhiꞌnn Booz, Booz naꞌ gokeꞌ xhiꞌnn Salmón, naꞌ Salmón naꞌ gokeꞌ xhiꞌnn Naasón. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón naꞌ gokeꞌ xhiꞌnn Aminadab, Aminadab nanꞌ gokeꞌ xhiꞌnn Aram, naꞌ Aram naꞌ gokeꞌ xhiꞌnn Esrom, Esrom naꞌ gokeꞌ xhiꞌnn Fares, Fares naꞌ gokeꞌ xhiꞌnn Judá. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Naꞌ Judá naꞌ gokeꞌ xhiꞌnn Jacob, Jacob naꞌ gokeꞌ xhiꞌnn Isaac, Isaac naꞌ gokeꞌ xhiꞌnn Abraham, naꞌ Abraham naꞌ gokeꞌ xhiꞌnn Taré, Taré naꞌ gokeꞌ xhiꞌnn Nacor. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor naꞌ gokeꞌ xhiꞌnn Serug, naꞌ Serug naꞌ gokeꞌ xhiꞌnn Ragau, Ragau naꞌ gokeꞌ xhiꞌnn Peleg, Peleg naꞌ gokeꞌ xhiꞌnn Heber, naꞌ Heber naꞌ gokeꞌ xhiꞌnn Sala. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala naꞌ gokeꞌ xhiꞌnn Cainán, Cainán naꞌ gokeꞌ xhiꞌnn Arfaxad, naꞌ Arfaxad naꞌ gokeꞌ xhiꞌnn Sem, Sem naꞌ gokeꞌ xhiꞌnn Noé, Noé naꞌ gokeꞌ xhiꞌnn Lamec. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Naꞌ Lamec naꞌ gokeꞌ xhiꞌnn Matusalén, Matusalén naꞌ gokeꞌ xhiꞌnn Enoc, Enoc naꞌ gokeꞌ xhiꞌnn Jared, naꞌ Jared naꞌ gokeꞌ xhiꞌnn Mahalaleel, Mahalaleel naꞌ gokeꞌ xhiꞌnn Cainán. ");
INSERT INTO zpuNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán naꞌ gokeꞌ xhiꞌnn Enós, naꞌ Enós naꞌ gokeꞌ xhiꞌnn Set, Set naꞌ gokeꞌ xhiꞌnn Adán, naꞌ Adán naꞌ gokeꞌ xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Naꞌ Jesúsenꞌ kon ren Spíritu ke Diosenꞌ llnebiaꞌtezen yichjraꞌlldaꞌweꞌn, bazeꞌe yeo Jordán naꞌ, naꞌ Spíritunꞌ benen nench byej Jesúsenꞌ latj dachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Choa (40) lla bzoeꞌ naꞌ, naꞌ rao choa lla naꞌ, daxiꞌon bkoꞌyelen Leꞌe goneꞌ da xhinnj. Naꞌ beneꞌ was, bi bdaokzeꞌ da choa lla naꞌ, bde naꞌ bdoneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Naꞌ jabiꞌy daxiꞌon llen Leꞌe: —Chaꞌ da li nakoꞌ Xhiꞌnn Dios, bayonchk yej ki yet xtir. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll daxiꞌon, lleꞌen: —Ki nyoj xtiꞌll Diosenꞌ: “Kere toze yet xtir danꞌ gaollo naꞌn, llonn yel nban ke lliꞌo beꞌnnach, renkze diꞌll danꞌ ll-lloj lloaꞌ Diosenꞌ nbanrenllo.” ");
INSERT INTO zpuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Naꞌll bcheꞌe daxiꞌon Leꞌe to rao yaꞌ sibe, naꞌ broeꞌn Leꞌe yeolol yell zjalliꞌ rao yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Naꞌ llen Leꞌe: —Doxhen yel banez yel llnebiaꞌ ke yell ki, gonnaꞌ rweꞌ, le kiaꞌn naken, naꞌ kon no llazraꞌllaꞌ waꞌan. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chaꞌ rweꞌ wcheꞌk xhiboꞌ weꞌraoꞌ nadaꞌ, doxhenen gonnaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naꞌll lle Jesúsenꞌ daxiꞌon: —Byej kaꞌle daxiꞌo, ki nyoj xtiꞌll Diosenꞌ: “Llayaꞌl gonliraꞌlloꞌ Diosenꞌ, naꞌ toze Leꞌen weꞌraꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Naꞌ bcheꞌn Leꞌe yichjo yodaꞌo brao Jerusalén naꞌ, jasé akteꞌ ga zerao nak sib, naꞌ llen Leꞌe: —Chaꞌ da li nakoꞌ Xhiꞌnn Dios, bxhiꞌtchke ganni lljasoteꞌo lleꞌle, ");
INSERT INTO zpuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","le ki nyoj xtiꞌll Diosenꞌ: Diosenꞌ wseꞌleꞌ beꞌnn kaꞌ nak angl keꞌe, gakrén akeꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Naꞌ goꞌx akeꞌ rweꞌ, nench ke lljacheꞌo yej. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Naꞌll goll Jesúsenꞌ len: —Leskaꞌ nyojen: “Bi llayaꞌl nnabroꞌ Diosenꞌ chaꞌ rennreꞌ kanꞌ neꞌen.” ");
INSERT INTO zpuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bayoll kate billbi ballele daxiꞌon, akre ka wkoꞌyelen Leꞌe, naꞌ blleꞌyiꞌllen to chiꞌi. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Naꞌ ka llnebiaꞌteze Spíritu ke Diosenꞌ yichjraꞌlldaꞌo Jesúsenꞌ, bayejeꞌ ganꞌ nbane Galileanꞌ, yeolol yell kaꞌ zjalliꞌ do naꞌ, bze ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naꞌ llzejnieꞌreꞌ beꞌnn toto yell ga zo yodaꞌo ga lladop beꞌnn Israel kaꞌ, naꞌ yeolol beꞌnn kaꞌ lloeꞌrao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Naꞌ ballineꞌ Nazaret ganꞌ blliꞌweꞌ. To lla llap beꞌnn Israel kaꞌ baraꞌnne, byejeꞌ yodaꞌo ganꞌ lladop beꞌnn Israel kaꞌ kanꞌ llonkzeꞌ, naꞌ bzolleꞌe beleꞌ yichenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Naꞌ bgoꞌx akeꞌ Leꞌe danꞌ bzoj da Isaías beꞌnn beꞌe xtiꞌll Dios kanaꞌ, naꞌ bsarjeꞌn, naꞌ jadiꞌreꞌ ganꞌ nen ki: ");
INSERT INTO zpuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Spíritu ke Xanllonꞌ zorenen nadaꞌ, brejeꞌ nadaꞌ nench chixjweꞌraꞌ Diꞌll Wen keꞌen beꞌnn yaꞌch; bseꞌleꞌ nadaꞌ nench wayonaꞌ beꞌnn bi zo wen, naꞌ beꞌnn zo yaꞌche. Chixjweꞌraꞌ beꞌnn kaꞌ nzap daxiꞌon, Diosenꞌ yesreꞌe leakeꞌ, waxaꞌ rao beꞌnn lchole, wasraꞌ beꞌnn llsaꞌkziꞌ da xhinnjenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Chixjweꞌraꞌ ba bllin lla gakrén Diosenꞌ beꞌnnachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Naꞌ batobeꞌ yichenꞌ, naꞌ bayoeꞌn beꞌnnenꞌ nak rallnaꞌa len naꞌ, naꞌ jallieꞌ. Yeolol beꞌnn kaꞌ llaꞌa lo yodaꞌon, llwiachich akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naꞌll lleꞌe leakeꞌ: —Nnaꞌ llak kanꞌ llia leꞌ yichenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Beꞌnn kaꞌ bene xtiꞌlleꞌn, llabán akreꞌ katek nbaraz nak xtiꞌlleꞌn, naꞌ bnne akeꞌ wen keꞌe. Naꞌ lle lwellj akeꞌ: —¿Kere beꞌnn ninꞌ xhiꞌnn José? ");
INSERT INTO zpuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naꞌll lle Jesúsenꞌ leakeꞌ: —Cheke nnaꞌ yere nadaꞌ diꞌllenꞌ ne ki: “Wen rmell rweꞌ, bayonchk rmell kwinoꞌ”. Naꞌ leskaꞌ yere nadaꞌ: “Da kaꞌ ba bénetoꞌ benoꞌ Capernaum naꞌ, gonchkoꞌn ralloꞌ ni nnaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Naꞌll bneꞌe da yobre: —Da li llniaꞌ, ni to beꞌnn lloeꞌ xtiꞌll Diosenꞌ, bi choꞌraꞌll akeꞌ leꞌe ralleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Da li llniaꞌ, zan noꞌr wazeb llaꞌa Israelenꞌ, kanꞌ bzo Elías beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. Kanaꞌn chonn iz xop beꞌo bi gok yej, naꞌ gok win rao yellrionꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","naꞌ Diosenꞌ bi bseꞌleꞌ Elíasenꞌ ganꞌ zjazó noꞌr wazeb Israel kaꞌ, zan bseꞌleꞌ leꞌe to yell da nziꞌi Sarepta ga nbane Sidón, gannaꞌte bzo to noꞌr wazeb gokreneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Leskaꞌ beꞌnn zan beꞌnn llen yillweꞌ danꞌ ne lepra, bllaꞌa Israelenꞌ kanꞌ bzo Eliseo, ni toeꞌ bi bayak, toze beꞌnnenꞌ re Naamán beꞌnn Siria, lezeꞌ bayak. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ka ben akreꞌ diꞌll ki, yeolol beꞌnn kaꞌ llaꞌa lo yodaꞌon, gokllaꞌa akeꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naꞌ bzollaꞌdo akeꞌ, naꞌ brej akeꞌ Leꞌe yell, bcheꞌe akeꞌ Leꞌe to rao yaꞌ awllo ganꞌ lliꞌ yellenꞌ, gokraꞌll akeꞌ wllix akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Naꞌ bi gok, llwia akteꞌ badieꞌ radj akeꞌn zayejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Naꞌ jasoeꞌ yell danꞌ re Capernaum ga nbane Galilea, naꞌ toto lla llap beꞌnn Israel kaꞌ baraꞌnne, llzejnieꞌreꞌ beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naꞌ llabán akreꞌ kanꞌ llzejnieꞌreꞌn, le nakbieꞌze nnezreꞌ kwasro, naꞌ nseꞌe yel llnebiaꞌ ke Diosenꞌ ka nak lloeꞌ diꞌllenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bixha lo yodaꞌo ganꞌ lladop akeꞌ naꞌ, lliꞌ to beꞌnn yoꞌ daxiꞌo yichjraꞌlldaꞌweꞌ, naꞌ bzorao llosieꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","bneꞌe: —Byej kaꞌle, ¿bixchen zadchixkoꞌ ren netoꞌ, Jesús beꞌnn Nazaret? ¿Zaꞌo zadlleyiꞌo netoꞌn? Nnézkzeraꞌ no rweꞌ, rweꞌn Beꞌnn Nak Laꞌy bseꞌl Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Naꞌ benreꞌ daxiꞌon znia, golleꞌn: —¡Llakia llonoꞌ! ¡Lla balloj yichjraꞌlldaꞌo beꞌnnenꞌ! Naꞌll bllixtolen beꞌnnenꞌ, naꞌ ballojen, naꞌ bibi goke beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yeolol beꞌnn kaꞌ llaꞌn, llabán akreꞌ, lle lwellj akeꞌ: —¿Bitk diꞌllenꞌ ne beꞌnnenꞌ? Napeꞌ yel llnebiaꞌ, naꞌ yel wak, naꞌllenꞌ lleꞌe daxiꞌo kaꞌ yelloj aken, naꞌ llalloj akten. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yeolol yell kaꞌ zjalliꞌ do naꞌ, bze ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesúsenꞌ bazolleꞌe zayejeꞌ, naꞌ byejeꞌ rill to beꞌnn re Simón. Naꞌ xhnaꞌ noꞌr ke Simón naꞌ, yoeꞌ da la, naꞌ goll akeꞌ Jesúsenꞌ wayoneꞌ noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Naꞌ Jesúsenꞌ jabiꞌyeꞌ ganꞌ xhoa beꞌnn weꞌen, naꞌ blleꞌkeꞌ, naꞌ balwilleꞌ da lanꞌ. Naꞌ le bayakte noꞌrenꞌ, le bayasteꞌ llsinieꞌ da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ka ba llen willenꞌ, jwaꞌa akeꞌ beꞌnn zan llak biteze yillweꞌ rao Jesúsenꞌ, naꞌ bxoa taꞌkeꞌn yichj toto akeꞌ, naꞌ bayoneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Leskaꞌ balloj daxiꞌo kaꞌ lo yichjraꞌlldaꞌo beꞌnn zan ak, llosiaꞌ aken, nen: —¡Rweꞌ nakoꞌ Xhiꞌnn Dios! Naꞌ benreꞌ daxiꞌo kaꞌ znia, bi beꞌe latj nne aken, le nnez akren Leꞌen Cristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bateyó ka byeniꞌ, bllojeꞌ byejeꞌ to latj dach. Naꞌ beꞌnn kaꞌ llayirj akeꞌ Leꞌe, ka ballel akreꞌ Leꞌen, bzaꞌy akeꞌ Leꞌe, bi gokraꞌll akeꞌ chejeꞌ ga yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naꞌll golleꞌ leakeꞌ: —Llonen bien chaꞌa yell kaꞌ yelaꞌ, lljatixjweꞌraꞌ Diꞌll Wen ke Diosenꞌ, le ke len naꞌ bseꞌleꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naꞌ kaꞌ toto ga zo yodaꞌo ganꞌ lladop beꞌnn Israel kaꞌ doxhen ganꞌ nbane Galileanꞌ, llejeꞌ llzejnieꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gok ka ze Jesúsenꞌ lloaꞌ nisdaꞌo da nziꞌi Genesaret, naꞌ beꞌnn zan kwis llaꞌa, to llchiꞌd akeꞌ Leꞌe, lleꞌn akreꞌ wzenay akeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naꞌ breꞌreꞌ awlloze lloaꞌ nisenꞌ, lliꞌ chop barco, naꞌ wxhen belyaꞌ kaꞌ, ba balloj akeꞌ loenꞌ, llayib yixj bel ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Naꞌ byoeꞌ to lo barco ke Simón naꞌ, naꞌ golleꞌ leꞌe, wlliꞌyeꞌn raꞌt kaꞌle lo nisenꞌ. Naꞌ bllieꞌ bzejnieꞌreꞌ beꞌnn kaꞌ llaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ka bayoll broeꞌreꞌ beꞌnn kaꞌ, lleꞌe Simón naꞌ: —Blliꞌy barconꞌ lo nis ganꞌ nak zitj naꞌ, naꞌ lewzaꞌl yixj bel kerénꞌ nench senre bel. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Naꞌll goll Simón naꞌ Leꞌe: —Maestro, do yer ba bentoꞌ llin, ni to gaz bel bi bdoꞌletoꞌ, nnaꞌ kone xtiꞌlloꞌ ni wzaꞌlchektoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Naꞌ bzaꞌl yixj bel ke akeꞌn lo nisenꞌ, ba zan belyaꞌ kaꞌ bzapen, to lleꞌne yixjenꞌ cheꞌzen. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Naꞌll goxh akeꞌ beꞌnn lwellj akeꞌ kaꞌ, llaꞌa lo barconꞌ ye to nench lljakrén akeꞌ leakeꞌ, naꞌ byej akeꞌ, naꞌ basllaꞌchochj akteꞌ barco kaꞌ, to llon aken da yiꞌch aken lo nisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ka breꞌe Simón Pedronꞌ kanꞌ goken, bcheꞌk xhibeꞌn rao Jesúsenꞌ lleꞌe Leꞌe: —¡Blleꞌyiꞌll kaꞌle Xanaꞌ, beꞌnn wen da xhinnjze nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bne Simón naꞌ kaꞌ, le bllebeꞌ kwis ren beꞌnn kaꞌ yelaꞌ, ke nak danꞌ bxhen akeꞌ belyaꞌ zan kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Leskaꞌ Jacobo, naꞌ Juan xhiꞌnn beꞌnnenꞌ re Zebedeo, llabán akreꞌ kwis, le nak akeꞌ txhen toz ka llin llon akeꞌ ren Simón naꞌ. Naꞌll goll Jesúsenꞌ Simón naꞌ: —Bi lleboꞌ, nnaꞌ soraoꞌ weꞌo xtiꞌllaꞌn; kanꞌ llonoꞌ daꞌo wxhen belenꞌ, kaꞌ gonoꞌ taꞌo wtopoꞌ beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ka jalek akeꞌ barco kaꞌ yo billenꞌ, naꞌ bsanraꞌll xchinraz akeꞌn, naꞌ bnao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bixha gok ka dá Jesúsenꞌ to rao yell, byej to beꞌnn llen yillweꞌ danꞌ ne lepra raweꞌn. Ka breꞌe beꞌnnenꞌ Jesúsenꞌ, bcheꞌk xhibeꞌ, blleꞌktekzeꞌ rao yonꞌ, goꞌtyoereꞌ Leꞌe, lleꞌe Leꞌe: —Xanaꞌ, chaꞌ lleꞌnroꞌ, wakse wakaꞌo yillweꞌ kiaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Naꞌll Jesúsenꞌ bli neꞌen, naꞌ bdaneꞌ leꞌe, naꞌ bneꞌe: —Lleꞌnkzraꞌ, bayak. Sete le bagaꞌte yillweꞌ ke beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesúsenꞌ goꞌtyoereꞌ leꞌe, ni to beꞌnn bi weꞌreneꞌ diꞌll kanꞌ bayoneꞌ leꞌen, lleꞌe leꞌe: —Byej rao bxozenꞌ, naꞌ beꞌe danꞌ nllia da Moisésenꞌ biaꞌa, nench yeyakoꞌ yall rao leyenꞌ. Kaꞌ ben nench yeolol beꞌnne nnez akreꞌ ba bayakoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yeolol yell kaꞌ, yezikre bze ke Jesúsenꞌ. Naꞌ beꞌnn zan kwis lldop llzenay akeꞌ xtiꞌlleꞌn, naꞌ lljakeꞌ nench wakeꞌe biteze yillweꞌ llak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Naꞌ Leꞌen ka llonkzeꞌ, llbeꞌyiꞌlleꞌ beꞌnn zan kaꞌ, llejeꞌ to latj dach, naꞌ lloeꞌreneꞌ Diosenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gok to lla ka llzejnieꞌ Jesúsenꞌ beꞌnne, naꞌ lliꞌ beꞌnn kaꞌ nziꞌi fariseo, naꞌ ren beꞌnn kaꞌ llroeꞌ ley danꞌ bzoj da Moisésenꞌ, beꞌnn zaꞌk doxhen yell kaꞌ ganꞌ nbane Galilea, naꞌ Judea, naꞌ beꞌnn zaꞌk Jerusalén. Naꞌ yel wak ke Xanllo Dios zorenen Leꞌe nench llayoneꞌ beꞌnn llak yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bixha ka bllinkze txhonnj beꞌnn, noaꞌ akeꞌ to beꞌnn bi dá niaꞌneꞌe, nxoa akeꞌ leꞌe to rao bray. Lleꞌn akreꞌ choꞌ akeꞌ lo yoꞌn, lljwaꞌa akeꞌ beꞌnn weꞌen rao Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Naꞌ ziꞌtere beꞌnn zan llaꞌa, kere llak choꞌ akeꞌ, naꞌ byep akeꞌ yichjore, bkaꞌa akeꞌ dex kaꞌ, naꞌ bletj akeꞌ beꞌnn weꞌen do ka nakeꞌ, naꞌ bdixj akeꞌ leꞌe rao Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ka breꞌe Jesúsenꞌ kanꞌ ben akeꞌn, gokbeꞌreꞌ nxenraꞌll akeꞌ Leꞌe, naꞌll lleꞌe beꞌnn weꞌen: —Beꞌnne, ni llaziꞌxhenaꞌ da xhinnj koꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Naꞌll beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ beꞌnn fariseo kaꞌ, ka ben akreꞌ kanꞌ bne Jesúsenꞌ, ben akeꞌ xhbab, bne akeꞌ: “¿No beꞌnnenꞌ nezeꞌ kaꞌ? Llkadieꞌ ke Diosenꞌ, neꞌe kaꞌ. Nollno gak yeziꞌxhen da xhinnj ke beꞌnne, le zeraoze Dios.” ");
INSERT INTO zpuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naꞌ Jesúsenꞌ gokbeꞌreꞌ kanꞌ llake lo yichjraꞌlldaꞌo akeꞌn, naꞌll lleꞌe leakeꞌ: —¿Bixchen llake lo yichjraꞌlldaꞌorenꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Llákere chaꞌ bi zaꞌk xtiꞌllaꞌ danꞌ llepaꞌ beꞌnnenꞌ: “Ni llaziꞌxhenaꞌ da xhinnj koꞌo naꞌn.” ¿Akxha gonre xhbab chaꞌ yepeꞌ: “Bayas naꞌ bayej”? ");
INSERT INTO zpuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Zan ni wroeꞌraꞌ reꞌ, nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, napaꞌ yel wak nench wayonaꞌ beꞌnne, naꞌ leskaꞌ naptiaꞌ yel llnebiaꞌ nench yeziꞌxhenaꞌ da xhinnj ke beꞌnne. Naꞌll goll Jesúsenꞌ beꞌnn xhinnjenꞌ: —Ni llepaꞌ rweꞌ, bayas, baziꞌi ganꞌ bxhoaꞌon, naꞌ bayej rilloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Le bayaste beꞌnn xhinnjenꞌ, llwiate beꞌnn kaꞌ bazieꞌ ganꞌ bxhoeꞌn, naꞌ zayejeꞌ rilleꞌ lloeꞌraweꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yeolol beꞌnn kaꞌ llabán akreꞌ kwis, naꞌ lloeꞌrao akeꞌ Dios, do llebtit akeꞌ ne akeꞌ: —Nnaꞌ lla breꞌllo to da yel wan kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bde naꞌ, blloj Jesúsenꞌ, naꞌ breꞌreꞌ to beꞌnn wachixhj beꞌnn re Leví. Llieꞌ ganꞌ llchixhjeꞌn, naꞌ goll Jesúsenꞌ leꞌe: —Da nnao nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naꞌ le bzollaꞌteꞌ bsanraꞌlleꞌ yeolol xchinrazeꞌ, naꞌ bnaweꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naꞌll ben Levínꞌ to lnni xhen, naꞌ jak beꞌnn zan beꞌnn wachixhje, naꞌ ren yezikre beꞌnne. Naꞌ blleꞌ akeꞌ llao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ fariseo kaꞌ, llaꞌdyiꞌ akeꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, lle akeꞌ leakeꞌ: —¿Bixchen llaorenre beꞌnn wachixhj, naꞌ ren yezikre beꞌnn wen da xhinnj kaꞌ txhen? ");
INSERT INTO zpuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Naꞌll goll Jesúsenꞌ leakeꞌ: —Beꞌnn bibi yillweꞌ llake, bi yalljreꞌ beꞌnn wen rmell, zan beꞌnnenꞌ llak yillweꞌn, leꞌen yalljreꞌ beꞌnn wen rmellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kere zaꞌa zadyexhaꞌ beꞌnn wen akenꞌ, zan zaꞌa zadwiaꞌ beꞌnn wayatre ke da xhinnj ba ben akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naꞌll bal beꞌnn goll akeꞌ Jesúsenꞌ: —¿Bixchen beꞌnn kaꞌ nao Juan beꞌnnenꞌ bchoa beꞌnn nis, naꞌ beꞌnn kaꞌ nao beꞌnn fariseo kaꞌ, llonteze llon akeꞌ was, naꞌ llalwill akeꞌ Dios, naꞌ beꞌnn kaꞌ nao rweꞌn lleꞌj llao akseꞌ kwasro? ");
INSERT INTO zpuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Naꞌll lleꞌe leakeꞌ: —¿Bixha wak gon beꞌnn kaꞌ was, beꞌnn kaꞌ llon akeꞌ yexh ga llak yel wachaynaꞌa chak lliꞌrén wachaynaꞌn leakeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Zan wllin lla kate wagaꞌa beꞌnn byionꞌ, kanaꞌllenꞌ gon akeꞌ was. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Naꞌ beꞌreneꞌ leakeꞌ to diꞌll, bneꞌe: —Ni to beꞌnne, kate wadeꞌe to raꞌll xha da gor, wxhoxhjeꞌ to raꞌll kob wadeꞌen. Chaꞌ kaꞌ goneꞌ, wlleyiꞌ raꞌll raꞌn kobenꞌ. Naꞌ leskaꞌ bi watilen to raꞌll kob ren to raꞌll gore. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni to beꞌnn leskaꞌ bi kaꞌchaꞌozeꞌ xis uva kobenꞌ to lo blloy yid gore. Chaꞌ kaꞌ goneꞌ, wcheꞌz xis uva kobenꞌ blloy yid gorenꞌ, naꞌ kaꞌ larj xis uva keꞌen, naꞌ kweyiꞌte blloy yidenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Zan xis uva kobenꞌ kaꞌchaꞌweꞌn lo blloy yid kobe, naꞌllenꞌ bibi gaken. ");
INSERT INTO zpuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naꞌ beꞌnnenꞌ bayoꞌraweꞌ lleꞌjeꞌ xis uva gorenꞌ, bill yeꞌnreꞌ yeꞌjeꞌ xis uva kobenꞌ, naꞌ nneꞌe: “Nakll xis uva gorenꞌ sia.” ");
INSERT INTO zpuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gok to lla nbaꞌnne ke beꞌnn Israel kaꞌ, ka yoꞌ akeꞌ nez, bde akeꞌ ga naz akeꞌ trigo, naꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen naꞌ, bzorao ll-lechj akeꞌ dao ke trigonꞌ, naꞌ bxhoꞌb akeꞌn, naꞌ bdao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Naꞌ breꞌe beꞌnn fariseo kaꞌ kanꞌ llon akeꞌn, naꞌll lle akeꞌ leakeꞌ: —¿Bixchen llonre kaꞌ? Llonre da bi llayaꞌl gonllo lla nbaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Naꞌll lle Jesúsenꞌ beꞌnn fariseo kaꞌ: —¿Bixha bi nna golre ganꞌ llian, ka ben da Davidenꞌ ren beꞌnn lwelljeꞌ kaꞌ ka bdon akeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kanꞌ byoeꞌ lo yodaꞌon, naꞌ bxhieꞌ yet xtir da ba nak laꞌy, da bi de latj gao noteze beꞌnne, toze bxoz kaꞌ gak gao len, naꞌ Davidenꞌ bdaweꞌn, naꞌ leskaꞌ bdaorén beꞌnn kaꞌ zejrén leꞌe txhen naꞌ len. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naꞌ leskaꞌ golleꞌ leakeꞌ: —Nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, leskaꞌ nakaꞌ xan llanꞌ llapre baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gok ye to lla nbaꞌnne, ka byoꞌ Jesúsenꞌ to lo yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ llzejnieꞌreꞌ leakeꞌ. Naꞌ lliꞌ to beꞌnn nxhoꞌn neꞌe chaꞌwe. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Naꞌ beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, lliꞌ akeꞌ lliꞌnao akeꞌ chaꞌ wayoneꞌ beꞌnnenꞌ rao lla llap akeꞌ baraꞌnne, naꞌ kaꞌ gaꞌt da lljatao akeꞌ xhia nench wlliayiꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesúsenꞌ llakbeꞌtereꞌ kanꞌ llon akeꞌ xhbabenꞌ, naꞌll golleꞌ beꞌnnenꞌ nat chlaꞌ taꞌkeꞌn: —Bazollaꞌa, naꞌ jasé kllole naꞌ. Naꞌ bzollaꞌa beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Naꞌll goll Jesúsenꞌ beꞌnn kaꞌ: —Ni wnnabkeraꞌ reꞌ: ¿Bi llayaꞌl gonllo lla nbaꞌnnenꞌ, gonllo da wen o chaꞌ gonllo da xhinnj? ¿Wak yesrallo beꞌnn o chaꞌ weꞌllo latj kwiayieꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Llwiateze yeolol beꞌnn kaꞌ, golleꞌ beꞌnnenꞌ: —Bli naꞌon. Naꞌ bli naꞌa beꞌnnenꞌ, le bayakte neꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gokllaꞌa beꞌnn kaꞌ kwis, naꞌ lloeꞌrén lwellj akeꞌ diꞌll akre gon akeꞌ ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","To lla byej Jesúsenꞌ to rao yaꞌ jalwilleꞌ Diosenꞌ, naꞌ do yer beꞌreneꞌ Leꞌe diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kate byeniꞌ naꞌ, batopeꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ brejeꞌ chllinn (12) beꞌnn nne lo razeꞌ, naꞌ bsieꞌ leakeꞌ postl. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ki re beꞌnn chllinn kaꞌ: Simón beꞌnnenꞌ bsieꞌ Pedronꞌ, naꞌ biꞌcheꞌn re Andrés, Jacobo, naꞌ Juan, Felipe, naꞌ Bartolomé, ");
INSERT INTO zpuNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo xhiꞌnn beꞌnnenꞌ re Alfeo, Simón beꞌnnenꞌ ben txhen beꞌnn kaꞌ nziꞌi Zelote, ");
INSERT INTO zpuNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas biꞌch Jacobo, naꞌll Judas Iscariote beꞌnnenꞌ, kanꞌ bllin lla, beneꞌ Jesúsenꞌ rallnaꞌa beꞌnn kaꞌ llwie Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ka llayetjreneꞌ leakeꞌ leꞌ yaꞌn, naꞌ ballín akeꞌ ganꞌ nak raꞌche, naꞌ bze Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌen txhen naꞌ, le ba llaꞌa beꞌnn zan zaꞌk doxhen ga nbane Judea, naꞌ Jerusalén, naꞌ yell kaꞌ re Tiro, naꞌ Sidón danꞌ lliꞌ lloaꞌ nisdaꞌo. Llaꞌa akeꞌ wzenay akeꞌ xtiꞌlleꞌn, leskaꞌ wayoneꞌ yillweꞌ llak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ren beꞌnn yoꞌ akeꞌ daxiꞌo, bayoneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yeolol beꞌnn kaꞌ, lleꞌn akreꞌ lljatan akeꞌ Leꞌe, le ne ka lljatan akeꞌ Leꞌen, ll-lloj yel wak keꞌen, naꞌ llayak akteꞌ biteze yillweꞌ llak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesúsenꞌ blis raweꞌn bwieꞌ beꞌnn kaꞌ non Leꞌe txhen, naꞌll golleꞌ leakeꞌ: —Nbaraz ke reꞌ beꞌnn yaꞌche, reꞌ gonre Diosenꞌ txhen katenꞌ nnebieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Nbaraz ke reꞌ nnaꞌ bil donre, reꞌ gon Diosenꞌ ka yérjere kwasro. ’Nbaraz ke reꞌ nnaꞌ bellre, wllin lla kate yewere. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Nbaraz ke reꞌ kate beꞌnn llwie akreꞌ reꞌ, naꞌ waraꞌa akeꞌ reꞌ, naꞌ ziꞌchiꞌll akeꞌ reꞌ, naꞌ llreꞌe akreꞌ reꞌ ka beꞌnn wen da xhinnj, ni ke danꞌ naore nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Katenꞌ gon akreꞌ reꞌ kaꞌ, leyewé, yel banez xhen de keré kate wallinre ganꞌ zo Diosenꞌ. Kaꞌkzenꞌ ben akreꞌ beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ bllaꞌa kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Zan nyaꞌchraz naken ke reꞌ, beꞌnn wniaꞌ, le nnaꞌzenꞌ ziꞌre banez. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nyaꞌchraz naken ke reꞌ, nnaꞌ nérjere kwasro, za llin lla tonrenꞌ. ’Nyaꞌchraz naken ke reꞌ, llawere nnaꞌ, za wallayraorenꞌ, za llin lla gosiaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nyaꞌchraz naken ke reꞌ, chaꞌ llon beꞌnn kaꞌ reꞌ xhen, leskaꞌ ben xozxtaꞌo akeꞌ kaꞌ, ben akeꞌ xhen beꞌnn kaꞌ bxhiyeꞌe batnaꞌ, beꞌnn kaꞌ bne lloeꞌ akeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Naꞌ reꞌ llzenay, ni llniaꞌ reꞌ: Lellieꞌ beꞌnn ll-lliayiꞌll reꞌ, legón wen ke beꞌnn llwie reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lewnnab gak wen ke beꞌnn yichjbieꞌ keré, naꞌ lewnnab gakrén Diosenꞌ beꞌnn llxoa da xhinnj koꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Beꞌnn kape chlaꞌ xaꞌyoꞌn, bze danꞌ ye chlaꞌ naꞌ kapeꞌn. Chaꞌ beꞌnn yeꞌnzreꞌ wkeꞌe xherk koꞌon, beꞌe latj wkaꞌa rente xhaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chaꞌ beꞌnn bi da nnabre reꞌ, leweꞌn, naꞌ chaꞌ beꞌnn wkeꞌe bi da de keré, bi yennabren. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kon yeolol da wen da lleꞌnere gon beꞌnn kaꞌ ke reꞌ, kaꞌkze legón ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Chaꞌ reꞌ nllieꞌre beꞌnn nllieꞌzre reꞌ, ¿bixha zaꞌken naꞌ kaꞌ? Leskaꞌ llon beꞌnn wen da xhinnj kaꞌ, nllieꞌ akreꞌ beꞌnn nllieꞌre leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chaꞌ llonre wen ke beꞌnn llone reꞌ wen, ¿bixha zaꞌken naꞌ kaꞌ? Leskaꞌ llon beꞌnn wen da xhinnj kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Reꞌ kate bi da llbejre, naꞌ kat bi lloeꞌre beꞌnne, nnézere wayonneꞌn, naꞌllenꞌ lloeꞌren, ¿bixha zaꞌken naꞌ kaꞌ? Leskaꞌ llon beꞌnn wen da xhinnj kaꞌ, llakrén akeꞌ beꞌnn wagoꞌ wzon ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lellieꞌ beꞌnn kaꞌ llwie reꞌ, legón da wen, leweꞌe beꞌnne bi da de keré, bi kwexhzre wayónn akeꞌn, naꞌllenꞌ gakre xhiꞌnn Dios beꞌnnenꞌ zo yebá, Leꞌe gonneꞌ reꞌ yel baraꞌnn xhen kate wallinre ganꞌ zoeꞌn. Leꞌe lloneꞌ wen ke yeolol beꞌnne, laꞌkze nak akeꞌ beꞌnn wen da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lewayaꞌchraꞌll, kanꞌ llon Xallo Diosenꞌ llayaꞌchraꞌlleꞌ noteze beꞌnn. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Bi wlliayiꞌllre beꞌnne nench ke wlliayiꞌll Diosenꞌ reꞌ, naꞌ bi wchoybiaꞌre ke beꞌnne nench ke wchoybiaꞌ Diosenꞌ ke reꞌ. Lewaziꞌxhen ke beꞌnne, naꞌ kaꞌ waziꞌxhen Diosenꞌ keré. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Leweꞌe, chaꞌ bi weꞌre beꞌnne, ker da nnitrao kaꞌzenꞌ, da wayonnte Xanllo Diosenꞌ, wa llaꞌchochjte wayonneꞌ, kon ka weꞌllo, kon ka zánello weꞌllo, leskaꞌn wayónn Diosenꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Naꞌll beꞌreneꞌ leakeꞌ to diꞌll, bneꞌe: —¿Wak to beꞌnn lchol wseꞌe ye to beꞌnn lchol yobre? Chaꞌ kaꞌ goneꞌ, llop akeꞌ lljabix. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ka to bidaꞌo llsede, kere zaꞌkll lebeꞌ kerke beꞌnnenꞌ llsede lebeꞌn, zan chaꞌ lebeꞌ weꞌlaꞌllbeꞌ wsedbeꞌ, gonkzbeꞌ ka beꞌnnenꞌ llsede lebeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bixchen llwiazoꞌ beb daꞌon yoꞌ lo rao beꞌnn biꞌchoꞌn, naꞌ bi llwiaꞌo beb xhen naꞌ, yoꞌ lo rao rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Bixchen yezoꞌ bibiꞌchoꞌn: “Anchk wabejkeraꞌ beb daꞌon yoꞌ lo raoꞌn?” ¿Bixha danꞌ yoꞌ lo rao rweꞌ, beꞌnn chop rao? Zgaꞌtek babej beb xhen naꞌ, yoꞌ lo rao rweꞌ, naꞌllenꞌ yereꞌroꞌ kwasro, naꞌ gak wabejoꞌ yixh bebenꞌ yoꞌ lo rao beꞌnn biꞌchoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Gaga zo yay wen da llbia daxhix da bi nak wen, leskaꞌ yay da bi nak wen, bi llbian daxhix wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kon da xhixenꞌ llbia yay naꞌn, nnézello ka nak yayenꞌ. Bi llbia higo rao yay yeꞌche, leskaꞌ bi llbia yay yeꞌche uvas. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Beꞌnnenꞌ nak beꞌnn wen, yichjraꞌlldaꞌweꞌn naken ka to ga llaꞌa da chaꞌo, naꞌn llchacheꞌ da wen kaꞌ lloneꞌn. Naꞌ beꞌnnenꞌ nak beꞌnn wen da xhinnj, lo yichjraꞌlldaꞌweꞌ naꞌn, llchacheꞌ da ke nxhia kaꞌ lloneꞌn. Kon ke danꞌ llaꞌa yichjraꞌlldaꞌollo naꞌn, len naꞌn ll-llach lloaꞌllonꞌ kate nnello. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Bixchen llezre nadaꞌ: “Xantoꞌ” naꞌ bi llonre kanꞌ niaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ni wzejnieꞌkeraꞌ reꞌ, ka llon beꞌnnenꞌ llzenay xtiꞌllaꞌn, naꞌ lloneꞌ kaꞌn niaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wsaꞌkrebeꞌ ka beꞌnn llon rilleꞌ, naꞌ brekweꞌ ranen to rao yej war. Naꞌ gok yejsiꞌo, babia nis, blloj yeo waꞌa byechjen ganꞌ zo yoꞌn, naꞌ bibi goke yoꞌn, le llian rao yej war. ");
INSERT INTO zpuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naꞌ beꞌnnenꞌ kon llenreꞌ, naꞌ bi lloneꞌ kanꞌ niaꞌn, wsaꞌkrebeꞌ ka beꞌnnenꞌ ben rilleꞌ rao yo cholj, naꞌ bi bcheꞌnneꞌ ranen zitj, naꞌ ke blloj yeo waꞌa xhen naꞌ, bzalen yoꞌn kaꞌle, naꞌ blleyiꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bayoll beꞌrén Jesúsenꞌ beꞌnn kaꞌ diꞌll ki, naꞌ bayoeꞌ yell Capernaum naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rao yell naꞌ zo to beꞌnn nak xan beꞌnn kaꞌ, nak wakaꞌa ya, naꞌ zo to beꞌnn wen llin keꞌe beꞌnn nllieꞌreꞌ kwis, naꞌ llak beꞌnnenꞌ yillweꞌ, ba llontekzen zi goten leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Naꞌ xaneꞌn benreꞌ ke Jesúsenꞌ, naꞌ bseꞌleꞌ chop chonn beꞌnn gor brao ke beꞌnn Israel kaꞌ, nench lljalwill akeꞌ Jesúsenꞌ, chejeꞌ wayoneꞌ beꞌnnenꞌ llak yillweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ka bllin beꞌnn kaꞌ rao Jesúsenꞌ, goꞌtyoe akreꞌ Leꞌe nench chejeꞌ wayoneꞌ beꞌnn weꞌen, lle akeꞌ Leꞌe: —Beꞌnnenꞌ bseꞌl netoꞌ nakeꞌ to beꞌnn wen, naꞌ llayaꞌl gakrenoeꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","le nllieꞌreꞌ yell kellonꞌ, naꞌ kone xhmelleꞌ beneꞌ to yodaꞌo ketoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesúsenꞌ byejreneꞌ leakeꞌ, ba zejteꞌ awlloze, kate bseꞌl beꞌnnenꞌ nak xan wakaꞌa yanꞌ, beꞌnn yobre beꞌnn nakeꞌ txhen, naꞌ jatil akeꞌ Jesúsenꞌ, lle akeꞌ Leꞌe: —Xantoꞌ, ne beꞌnnenꞌ: “Bi weꞌlaꞌlltkoꞌ, le bi zaꞌkaꞌ choꞌo lo yoꞌ rillaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ke len naꞌ bi bayaxhjraꞌ yed kwinaꞌ yedtilaꞌ rweꞌ. To bneze diꞌllenꞌ, naꞌ wayakte beꞌnn wen llin kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nadaꞌ zo beꞌnn llnebiaꞌ nadaꞌ, naꞌ lekze niꞌt beꞌnn wakaꞌa ya kiaꞌ llnebiaꞌ akeꞌ. Kate llepaꞌ toeꞌ: Byej, naꞌ llejteꞌ, naꞌ kate llepaꞌ ye toeꞌ: Da, naꞌ le lledteꞌ, naꞌ kate llepaꞌ beꞌnn wen llin kiaꞌn: Da ni gonoꞌ, naꞌ le llonteꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ka bene Jesúsenꞌ diꞌll ki, llabanreꞌ kwis ke beꞌnnenꞌ, naꞌ bayechjeꞌ, lleꞌe beꞌnn kaꞌ nao Leꞌen: —Chak daꞌa radj beꞌnn Israel ki, gatga nna lljadiꞌraꞌ to beꞌnn wxenraꞌlle katkenꞌ nxenraꞌll beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Naꞌ zayej beꞌnn kaꞌ, ka ballín akeꞌ yoꞌn, ba bayakte beꞌnn wen llin ke beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bde naꞌ, byej Jesúsenꞌ to yell da nziꞌi Naín ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, ren beꞌnn zan beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ka le choꞌteꞌ yellenꞌ, kate zaꞌk beꞌnn zan beꞌnn bllach yellenꞌ, nlen akeꞌ to beꞌnn wat, beꞌnn watenꞌ nakbeꞌ bi tiꞌch rao xhnaꞌbeꞌ, naꞌ xhnaꞌbeꞌ naꞌ nakeꞌ noꞌr wazeb. Beꞌnn zan beꞌnn rao yellenꞌ, non akeꞌ leꞌe txhen zjakeꞌ zjakwaꞌch akebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ka breꞌe Xanllonꞌ noꞌrenꞌ, bayaꞌchraꞌlleꞌ leꞌe, naꞌ golleꞌ leꞌe: —Bi kwelloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naꞌll jabiꞌy Jesúsenꞌ jataneꞌ yiꞌnn ke bi watenꞌ, naꞌ beꞌnn kaꞌ nlen yiꞌnnenꞌ brexh akeꞌ. Naꞌ bneꞌe: —Beꞌnn weꞌo, bayas. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Naꞌ bi watenꞌ bayasbeꞌ, blleꞌbeꞌ, naꞌ bzorao llannebeꞌ, naꞌ Jesúsenꞌ bayoeꞌbeꞌ beꞌnnenꞌ nak xhnaꞌbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yeolol beꞌnn kaꞌ blleb akeꞌ kwis, naꞌ lloeꞌrao akeꞌ Dios ne akeꞌ: —Ba braꞌ to beꞌnn brao xhen, beꞌnn lloeꞌ xtiꞌll Diosenꞌ rao rall-llonꞌ, nnaꞌll ba jadinraꞌll Diosenꞌ lliꞌo, naꞌ ba zadraꞌnneꞌ yell keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Doxhen ganꞌ nbane Judeanꞌ ben akreꞌ kanꞌ beneꞌn, naꞌ yeolol yell kaꞌ lliꞌ do naꞌ, bze ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Beꞌnn kaꞌ nao Juan naꞌ, jazén akreꞌ leꞌe yeolol ke da kaꞌ llon Jesúsenꞌ. Naꞌ goxh Juan naꞌ, chop beꞌnn kaꞌ non leꞌe txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Naꞌ lleꞌe leakeꞌ: —Lechej ganꞌ zo Jesúsenꞌ, naꞌ yereꞌ: “¿Rweꞌn beꞌnnenꞌ ne Diosenꞌ wseꞌleꞌ o chaꞌ kwexhtoꞌ beꞌnn yobre?” ");
INSERT INTO zpuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kate bllin akeꞌ ganꞌ zo Jesúsenꞌ, lle akeꞌ Leꞌe: —Juan beꞌnnenꞌ llchoaꞌ nis, bseꞌleꞌ netoꞌ, le lleꞌnreꞌ nnezreꞌ chaꞌ rweꞌn beꞌnnenꞌ wseꞌl Diosenꞌ o chaꞌ kwexhtoꞌ beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Rao lla naꞌ, bayón Jesúsenꞌ beꞌnn zan beꞌnn llak biteze yillweꞌ. Bayoneꞌ beꞌnn yoꞌ daxiꞌo, naꞌ leskaꞌ beꞌnn lchol bayoneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll beꞌnn kaꞌ bseꞌl Juan naꞌ, lleꞌe leakeꞌ: —Lewayej, naꞌ lelljayell Juan naꞌ, yeolol da kaꞌ ba bénere, naꞌ ba breꞌre ganni: beꞌnn lchol llareꞌe akreꞌ, beꞌnn xhinnj lladá akeꞌ, beꞌnn llen yillweꞌ danꞌ ne lepra llayak akeꞌ, beꞌnn bi llene ba llayén akreꞌ, beꞌnn wat llabán akeꞌ, naꞌ beꞌnn yaꞌch llzenay akeꞌ Diꞌll Wen ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Nbaraz ke beꞌnnenꞌ bi llakganreꞌ, naꞌ yezikre llejleꞌ kiaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ka ba zayej beꞌnn kaꞌ bseꞌl Juan naꞌ, Jesúsenꞌ bzorao lloeꞌ xtiꞌll Juan naꞌ, ren beꞌnn kaꞌ zjallaꞌn, lleꞌe leakeꞌ: —¿No beꞌnnenꞌ jawiare latj dachenꞌ? ¿To beꞌnn nak ka yia da zo lleꞌ da le llta beꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Bixha jawiakzre? ¿To beꞌnn nakeꞌ raꞌll chaꞌo? Kaꞌa, beꞌnn nakeꞌ raꞌll chaꞌon, yoꞌ wen zo akeꞌ, naꞌ rill beꞌnn llnebiaꞌ zjallaꞌa akeꞌ lleꞌj llao akeꞌ kwasro. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Bixha jawiakzre chaꞌ? ¿To beꞌnn lloeꞌ xtiꞌll Dios? Awaꞌ, ni llepaꞌ reꞌ, wdetere ka beꞌnn lloeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ke beꞌnn ninꞌ nyoj xtiꞌll Diosenꞌ ganꞌ nen: Wseꞌlaꞌ to beꞌnn kwiaraweꞌ raoꞌn, weꞌe xtiꞌlloꞌn, nench yeweꞌ xhnneze ganꞌ teꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ni llniaꞌ, gatga nna so to beꞌnn nak beꞌnn braoll, ka Juan beꞌnnenꞌ bchoa nisenꞌ. Naꞌ nnaꞌ noteze beꞌnn llzenay ke Dios, nench nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌn, laꞌkze nakeꞌ beꞌnne le zeraoze beꞌnne bibi zaꞌke, gaklleꞌ beꞌnn braoll ka Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Beꞌnn zan beꞌnn yell, naꞌ ren wachixhj kaꞌ, ka ben akreꞌ xtiꞌll Juan naꞌ, blloa akeꞌ nis le byejnieꞌ akreꞌ nak akeꞌ beꞌnn wen da xhinnj rao Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Zan beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsed llroeꞌ ley danꞌ bzoj da Moisésenꞌ, bi gokraꞌll akeꞌ wchoa Juan naꞌ leakeꞌ nis, bi beꞌe akeꞌ latj gon Diosenꞌ da wen naꞌ llwieꞌ goneꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Naꞌ bne Jesúsenꞌ da yobre: —¿Akre ka wsaꞌkrebaꞌ beꞌnn ki llaꞌa nnaꞌ? ¿Akre nak akeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ka bidaꞌo kate yitj akbeꞌ do lao yaꞌa, naꞌ lle lwellj akbeꞌ: “Ba bkwelltoꞌ bllej, naꞌ bi byaꞌre, naꞌ ba beltoꞌ da llon nyaꞌchraz, naꞌ ni ke bllellzre.” ");
INSERT INTO zpuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ka nak ba bed Juan naꞌ, bi weꞌe bdaochaꞌweꞌ, naꞌ bnere keꞌe: “Daxiꞌon yoꞌ beꞌnnenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Naꞌ nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, ba bedaꞌ rao yellrionꞌ, naꞌ lleꞌj llawaꞌ kwasro, naꞌ nere kiaꞌ: “Le lleꞌj llaoxen beꞌnnenꞌ, naꞌ lloneꞌ txhen beꞌnn wachixhj kaꞌ, ren yezikre beꞌnn wen da xhinnj kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Zan zjallaꞌa akse beꞌnn llzenay ke Diosenꞌ. Leakeꞌ llroeꞌ akreꞌ kanꞌ nak yel siꞌn ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","To beꞌnn fariseo re Simón, beneꞌ Jesúsenꞌ yexh nench chejeꞌ rilleꞌn lljataweꞌ, naꞌ ka bllin Jesúsenꞌ rill beꞌnn fariseonꞌ, bllieꞌ ganꞌ gao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naꞌ rao yell naꞌ, zo to noꞌr wen da xhinnj, naꞌ bnnezreꞌ ka bllin Jesúsenꞌ rill beꞌnnenꞌ. Ka ba lliꞌ Jesúsenꞌ ren beꞌnn kaꞌ yelaꞌ llao akeꞌ, jabiꞌy noꞌrenꞌ noꞌxeꞌ to lmet da yoll nis da laꞌ xhix. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Naꞌ blleꞌk noꞌrenꞌ xhniaꞌ Jesúsenꞌ, bzorao belleꞌ kwis, naꞌ kone nis raweꞌn, llasbiseꞌ niaꞌ Jesúsenꞌ, naꞌ llachechteꞌn ren yich yichjeꞌ, naꞌ llnoꞌpeꞌ nieꞌn, naꞌll lltopteꞌn nis danꞌ la xhixenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ka breꞌe Simón naꞌ, beꞌnnenꞌ ben Jesúsenꞌ yexhenꞌ, beneꞌ xhbab: “Chenak beꞌnn ni nakeꞌ beꞌnn lloeꞌ xtiꞌll Dios, wayakbeꞌreꞌ noꞌr wen da xhinnjze, noꞌrenꞌ llone leꞌe kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Naꞌll goll Jesúsenꞌ leꞌe: —Simón, de to da lleꞌnraꞌ nniaꞌ rweꞌ. Naꞌll bne Simón naꞌ: —Bne, maestro. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naꞌll lle Jesúsenꞌ leꞌe: —To beꞌnne llbej mell, bzo chop beꞌnn llbaꞌy xhmelleꞌ. To beꞌnnenꞌ llbaꞌyeꞌ gaꞌy gayoa (500) mell da nziꞌi denario, naꞌ beꞌnnenꞌ ye to llbaꞌyeꞌ chiyon (50) denario. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Llopte beꞌnn kaꞌ bibi de ke akeꞌ wayixhj akeꞌ xhianꞌ, naꞌ beꞌnnenꞌ brej leakeꞌ mellenꞌ, bnitraweꞌn kaꞌze. Bnechk nadaꞌ, ¿nore beꞌnn ki chop bllieꞌllreꞌ xan mellenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Naꞌ bne Simón naꞌ: —Cheke beꞌnnenꞌ baziꞌxheneꞌ ke da xhenll. Naꞌll bne Jesúsenꞌ: —Da li kwis kanꞌ bneꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Naꞌll bayechjeꞌ bwieꞌ noꞌrenꞌ, naꞌ lleꞌe Simón naꞌ: —¿Llreꞌroꞌ noꞌrenꞌ? Byoaꞌ rilloꞌn, bi bennoꞌ nis chib niaꞌ, naꞌ noꞌrenꞌ, kone nis raweꞌ naꞌ, ba bdibeꞌ niaꞌn, naꞌ llachechteꞌn ren yich yichjeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bi bnoꞌpoꞌ nadaꞌ, naꞌ noꞌrenꞌ, ka braꞌtiaꞌ llnoꞌpeꞌ niaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bi btopoꞌ nadaꞌ ceit, zan noꞌrenꞌ ba btopeꞌ niaꞌn to nis da laꞌ xhix. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ni llniaꞌ rweꞌ, laꞌkze nakeꞌ noꞌr wen da xhinnj, de yel llaziꞌxhen keꞌe, le da xhen naꞌ nllieꞌreꞌ. Beꞌnn llbaꞌyeꞌ raꞌtze, raꞌtze de waziꞌxhenllo keꞌe, kaꞌ raꞌtze nllieꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Naꞌll lleꞌe noꞌrenꞌ: —Ba baziꞌxhenaꞌ yeolol da xhinnj koꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Beꞌnn kaꞌ lliꞌ llaoreneꞌ txhen naꞌ, bzorao lle lwellj akeꞌ: —¿Noxha beꞌnnenꞌ llaziꞌxhenzeꞌ da xhinnj ke beꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naꞌll Jesúsenꞌ golleꞌ noꞌrenꞌ da yobre: —Danꞌ nxenraꞌlloꞌ naꞌn ba basrá rweꞌ, bayejchga wen nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bde naꞌ, byej Jesúsenꞌ toto yell, yell xhen, naꞌ yell daꞌo, jateꞌe jatixjweꞌreꞌ Diꞌll Wen ke Diosenꞌ ren beꞌnn chllinn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Leskaꞌ txhonnj noꞌr nao Leꞌe, beꞌnn kaꞌ bakeꞌe yillweꞌ llak akeꞌ, naꞌ noꞌr babejeꞌ daxiꞌo yoꞌ akeꞌ. Naꞌ ren to noꞌr re María beꞌnn Magdala, babej Jesúsenꞌ gall daxiꞌo yoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Naꞌ ren ye to noꞌr re Xhuan, noꞌr ke to beꞌnn re Chuza, naꞌ Chuzanꞌ nak rallneꞌe yoꞌ ke Herodes, naꞌ ren to beꞌnn re Susana, naꞌ ye to chop noꞌr yobre. Noꞌr ki gokrén akeꞌ Jesúsenꞌ kon da de ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Naꞌll badop beꞌnn zan, beꞌnn zak toto yell kaꞌ, naꞌ kone da bsaꞌkrebreꞌ bi da kaꞌ bzejnieꞌreꞌ leakeꞌ, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—To beꞌnn bllojeꞌ zejeꞌ goz trigo, naꞌ rawe zejeꞌ lloseꞌ nbaz kaꞌ, balen jeꞌten lloaꞌ nez, naꞌ brejchekw beꞌnn len, naꞌ byinn kaꞌ dá rao lla, bdao akbaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Naꞌ balen jeꞌten rao yej, braꞌ akten, naꞌ byechen le bibi goꞌp detek rao yejenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Naꞌ balen jagoꞌnnen lo yay yeꞌche; naꞌ ka braꞌn naꞌ, bagaꞌrente yeꞌch kaꞌ, naꞌ benen len roe. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Naꞌ balen jeꞌten rao yo chaꞌo, naꞌ nbaraz braꞌn, naꞌ bayoeꞌkazen nbaz kaꞌ to gayoa (100) wej toton. Bayoll beꞌe diꞌll ki, bneꞌe zillj: —Reꞌ zo nayre, lewzenay xtiꞌllaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Naꞌll beꞌnn kaꞌ non Leꞌe txhen naꞌ, bnnab akreꞌ Leꞌe, lle akeꞌ Leꞌe: —¿Akre chejnieꞌllo ka diꞌllenꞌ bayoll bneꞌon? ");
INSERT INTO zpuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naꞌ Jesúsenꞌ lleꞌe leakeꞌ: —Reꞌ, ba brej Diosenꞌ nench nnézere da bi bnneze beꞌnn bllaꞌa kanaꞌ, kanꞌ llnebiaꞌ Diosenꞌ, zan yezikre beꞌnn bi llejleꞌ, wsaꞌkrebraꞌ bi da kaꞌ weꞌrén akeꞌ diꞌlle. Laꞌkze wia akeꞌ, bi gakbeꞌe akreꞌ bi da kaꞌ; laꞌkze yen akreꞌ, naꞌ bi chejnieꞌ akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ni wzejnieꞌraꞌ reꞌ ka diꞌllenꞌ beꞌrenaꞌ reꞌ: nbaz danꞌ bes beꞌnnenꞌ, xtiꞌll Dios naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Naꞌ da kaꞌ jeꞌt lloaꞌ nezenꞌ, naken ka beꞌnnenꞌ kon llenreꞌ xtiꞌll Diosenꞌ; naꞌll ll-llin daxiꞌon llabejen xtiꞌll Diosenꞌ danꞌ ba yoꞌ lo yichjraꞌlldaꞌweꞌn, naꞌ kaꞌ bi llejleꞌ nench naꞌ yereꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Naꞌ da kaꞌ jeꞌt rao yejenꞌ, naken ka beꞌnnenꞌ llawereꞌ kwis llzenayeꞌ xtiꞌll Diosenꞌ; naꞌ bi nyin roe zitj, chollze llejleꞌ, naꞌ kate llak bi da llak keꞌe, le llsanteꞌ bill llnaweꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Naꞌ da kaꞌ jeꞌt radj yay yeꞌchenꞌ, naken ka beꞌnn kaꞌ llzenay xtiꞌll Diosenꞌ, naꞌ da zed, naꞌ yel llawé danꞌ de rao yellrionꞌ, naꞌ yel llzeraꞌll mell, bi lloeꞌn latj chiꞌweꞌ rao xhnnez Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Naꞌ da kaꞌ jeꞌt rao yo wen naꞌ, naken ka beꞌnn kaꞌ nak raꞌlldaꞌo wen; ka llzenay akeꞌ xtiꞌll Diosenꞌ, ziꞌi akeꞌn, naꞌ llon akeꞌ kanꞌ lleꞌne Diosenꞌ, laꞌkze biteze llak ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ni to beꞌnne kate wxhenzeꞌ to yiꞌ, wdoꞌszeꞌn to yeꞌs leo, naꞌ ni ke wkwaꞌchzeꞌn xhanre ganꞌ llxhoeꞌ lltaseꞌ, zan lldeꞌen sibe, naꞌllenꞌ wseniꞌn ke yeolol beꞌnn llaꞌa lo yoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Le gatga de to da ngaꞌche da bi wroeꞌrawe, naꞌ to da llon beꞌnn llillize da bi nneze beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Lewiayaꞌnn kanꞌ niaꞌ ni, le chaꞌ to beꞌnn llejnieꞌreꞌ, yezikre chejnieꞌllreꞌ; zan beꞌnnenꞌ bi lleꞌnreꞌ chejnieꞌreꞌ, ka to da daꞌo raꞌtenꞌ ba llejnieꞌreꞌn wagaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xhnaꞌ Jesúsenꞌ ren biꞌcheꞌ kaꞌ, bllin akeꞌ ganꞌ zoeꞌn, naꞌ gokraꞌll akeꞌ choꞌ akeꞌ lo yoꞌn, kere gok, le ziꞌtere beꞌnn zan llaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Naꞌ goll akeꞌ Leꞌe: —Xhnaꞌo ren beꞌnn biꞌchoꞌ kaꞌ, ze akteꞌ liaꞌ naꞌ, naꞌ lleꞌn akreꞌ reꞌe akreꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Naꞌ Jesúsenꞌ golleꞌ leakeꞌ: —Beꞌnn kaꞌ llzenay xtiꞌll Diosenꞌ, naꞌ llon akeꞌ kanꞌ niaꞌn, leakeꞌn nak xhnaꞌ, leakeꞌn biꞌchaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bixha gok to lla Jesúsenꞌ byoeꞌ to lo barco, ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌll golleꞌ leakeꞌ: —Laꞌyllo ye chlaꞌre nisdaꞌon. Naꞌll bsaꞌa akeꞌ barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Rawe zjakeꞌ rao nis naꞌn, btas Jesúsenꞌ. Naꞌ bzorao dá to beꞌ xhen rao nisenꞌ, naꞌ bzorao lloll nis lo barconꞌ, ba llontekzen nxholl kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Naꞌll basbando akeꞌ Jesúsenꞌ, lle akeꞌ Leꞌe: —¡Maestro! ¡Maestro, ba llbeyiꞌllo! Naꞌll byaseꞌ balwilleꞌ beꞌn ren nisdaꞌon; chollze babeꞌlli akten. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Naꞌll lleꞌe leakeꞌ: —¿Ganꞌ danꞌ nere nxenraꞌllre Dios? To lleb akeꞌ, naꞌ llabán akreꞌ kwis, lle lwellj akeꞌ: —¿Noxha beꞌnnenꞌ? Rente kaze beꞌ, naꞌ ren nisdaꞌo naꞌ llzenayen keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Naꞌ bllin akeꞌ to yell da re Gadara, naꞌ lliꞌ Gadaranꞌ chlaꞌ nisdaꞌo ganꞌ nbane Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ka balloj Jesúsenꞌ lo barconꞌ, to beꞌnn rao yellenꞌ jatileꞌ Leꞌe, naꞌ beꞌnnenꞌ ba gok scha yoꞌ daxiꞌo yichjraꞌlldaꞌweꞌ. Naꞌ kon ba dazeꞌ bill llakze xharaꞌneꞌ; bill llzokzeꞌ rilleꞌ, naꞌ ba zotekzeꞌ do ganꞌ lljakwaꞌch akeꞌ beꞌnn wat ake. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ka breꞌreꞌ Jesúsenꞌ, zillj kwis besieꞌ; naꞌ bcheꞌk xhibeꞌ raweꞌn bneꞌe: —¿Bi de koꞌo kone nadaꞌ, Jesús? Rweꞌ Xhiꞌnn Dios zo yebá. Bi wsaꞌkziꞌo nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Neꞌe kaꞌ le Jesúsenꞌ llchieꞌreꞌ daxiꞌon yellojen, le ba gok scha llnebiaꞌn yichjraꞌlldaꞌo beꞌnnenꞌ. Laꞌkze ba bchej akeꞌ leꞌe kon gden, llchoyyaꞌnneꞌ gden naꞌ, naꞌ llxhonnjeꞌ llgoꞌ daxiꞌon leꞌe yiꞌxre. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naꞌ Jesúsenꞌ golleꞌ beꞌnnenꞌ: —¿Bi reꞌo? Naꞌ bneꞌe: —Nyantoꞌ. Bneꞌe kaꞌ le da zan daxiꞌo kaꞌn llaꞌa yichjraꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Naꞌ goꞌtyoe daxiꞌo kaꞌ Jesúsenꞌ, bi wseꞌleꞌn gabil. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naꞌ awlloze gannaꞌ zo to leꞌ yaꞌ, llaꞌa kuch zan llao akbaꞌ yiꞌxe, naꞌ daxiꞌo kaꞌ, lle aken Jesúsenꞌ weꞌe latj lljachoꞌ aken lo kuch kaꞌ, naꞌ beꞌe latj. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ka balloj daxiꞌo kaꞌ yichjraꞌlldaꞌo beꞌnnenꞌ, jachoꞌ aken lo kuch kaꞌ. Naꞌll to gokllejlaꞌllze kuch kaꞌ, bdol akbaꞌ to leꞌ bdinnj, naꞌ wix akbaꞌ lo nisdaꞌon, naꞌ got akbaꞌ weꞌj akbaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Beꞌnn kaꞌ llap kuch kaꞌ, ka breꞌe akreꞌ kanꞌ goken, baxhonnjdo akeꞌ jatixjweꞌ akreꞌ beꞌnn, do lyell do lyiꞌxe kanꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Naꞌ ka bene beꞌnn kaꞌ xtiꞌll gop kuch kaꞌ, byej akeꞌ jawiá akeꞌ kanꞌ goken. Naꞌ jadiꞌ akreꞌ beꞌnnenꞌ byoꞌ daxiꞌo kaꞌ yichjraꞌlldaꞌon, ba llieꞌ xhniaꞌ Jesúsenꞌ ba bayak xharaꞌneꞌ, naꞌ ba bazoeꞌ wen. Naꞌ blleb beꞌnn kaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Beꞌnn kaꞌ breꞌen, beꞌrén akeꞌ beꞌnn kaꞌ bllin naꞌ diꞌll, kanꞌ bayak beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yeolol beꞌnn kaꞌ llaꞌa doxhen ganꞌ nbane Gadaranꞌ, goꞌtyoe akreꞌ Jesúsenꞌ yezeꞌe rall akeꞌn, le lleb akeꞌ kwis. Jesúsenꞌ bayoeꞌ lo barconꞌ, naꞌ bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Naꞌ ka za wayoeꞌ lo barconꞌ, beꞌnnenꞌ balloj daxiꞌo kaꞌ yichjraꞌlldaꞌon, goꞌtyoereꞌ Jesúsenꞌ weꞌe latj nnaweꞌ Leꞌe. Bixha Jesúsenꞌ bi beꞌe latj, naꞌ golleꞌ beꞌnnenꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Bayej rilloꞌ, naꞌ jazene beꞌnne katek wen naꞌ ba ben Diosenꞌ koꞌo. Naꞌ zayej beꞌnnenꞌ, jateꞌe doxhen yell jazenreꞌ beꞌnne, katek da xhen naꞌ gokrén Jesúsenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka ballín Jesúsenꞌ Capernaum naꞌ, beꞌnn zan ba llaꞌa llbexh Leꞌe, llawé akreꞌ ballineꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naꞌ bllin to beꞌnn re Jairo, beꞌnn nak rallneꞌe yodaꞌo ke yellenꞌ, naꞌ bcheꞌk xhibeꞌ goꞌtyoereꞌ Leꞌe chejeꞌ rilleꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","le zo tiꞌch xhiꞌnneꞌ noꞌre bi de chllinn (12) iz llakbeꞌ yillweꞌ, naꞌ ba llatbeꞌ. Chak zejeꞌ rill Jaironꞌ, beꞌnn zan kwis nao Leꞌe, to llchiꞌd akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bixha to noꞌre, leskaꞌ ba gok chllinn (12) iz llakeꞌ yillweꞌ, bzoeꞌ waꞌa, ba beneꞌ gaxt doxhen xhmelleꞌ, llejeꞌ rao wen rmell, naꞌ bi llayakseꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naꞌ jabiꞌyeꞌ koꞌllre Jesúsenꞌ jataneꞌ xharaꞌneꞌn. Ka bdaneꞌ xharaꞌneꞌn, le brexhte yillweꞌ keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Naꞌll le bnete Jesúsenꞌ: —¿Nonꞌ bdan nadaꞌ? Ni toeꞌ bi bachebeꞌ, naꞌll Pedronꞌ ren beꞌnn kaꞌ zjakrén leꞌe txhen naꞌ, bne akeꞌ: —Maestro, beꞌnn zan beꞌnn kaꞌ llchiꞌd rweꞌ, naꞌ nechkoꞌ: “¿No bdan nadaꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naꞌll bnekzeꞌ da yobre: —Zo to beꞌnn bdan nadaꞌ; gokbeꞌteraꞌ ben yel wak kiaꞌn llin. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ka breꞌe noꞌrenꞌ gokbeꞌte Jesúsenꞌ kanꞌ jataneꞌ Leꞌen, to xhizeꞌ, to llebeꞌ jabiꞌyeꞌ raweꞌn, bcheꞌk xhibeꞌ, naꞌ beꞌe diꞌll rao yeolol beꞌnn kaꞌ kanꞌ gok bdaneꞌ xharaꞌneꞌn, naꞌ bagaꞌte yillweꞌ keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Naꞌ lle Jesúsenꞌ leꞌe: —Xhiꞌnnaꞌ, danꞌ nxenraꞌlloꞌ naꞌn, ba basrá rweꞌ. Bayejchga wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naꞌ lloeꞌteꞌ diꞌllenꞌ, kate bllin to beꞌnn bzaꞌa rill Jaironꞌ, naꞌ lleꞌe Jaironꞌ: —Bill wchieꞌroꞌ Maestronꞌ, ba gotte xhiꞌnnoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ka bene Jesúsenꞌ kanꞌ bne beꞌnnenꞌ, naꞌll golleꞌ Jaironꞌ: —Bi lleboꞌ, kon bxenraꞌlle, naꞌ wayakse xhiꞌnnoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ka byoeꞌ lo yoꞌn, nono beꞌkzeꞌ latj choꞌ ren Leꞌe lete Pedro naꞌze, naꞌ Jacobo, naꞌ Juan, naꞌ ren xaxhnaꞌ bidaꞌo noꞌr naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yeolol beꞌnn kaꞌ llaꞌn, bell akeꞌ llak akreꞌ bidaꞌon, naꞌll lle Jesúsenꞌ leakeꞌ: —Bi kwellre, kere gotbeꞌn, taszbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Naꞌ bxhill akeꞌ keꞌe, le nnez akreꞌ kwasro ba gotbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naꞌll beꞌxeꞌ naꞌa bidaꞌo noꞌr watenꞌ, naꞌ bneꞌe: —Bidaꞌo noꞌre, bayas. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naꞌ babán bidaꞌo noꞌrenꞌ, le bayástebeꞌ, naꞌ goll Jesúsenꞌ leakeꞌ, weꞌe akeꞌ da gaobeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naꞌll xaxhnaꞌ bidaꞌon llabán akreꞌ kwis, naꞌ Jesúsenꞌ golleꞌ leakeꞌ nono weꞌrén akeꞌ diꞌll danꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naꞌ batop Jesúsenꞌ beꞌnn chllinn kaꞌ, beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ beꞌe leakeꞌ yel wak, naꞌ yel llnebiaꞌ nench yebej akeꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne, naꞌ wayón akeꞌ beꞌnn llak yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Naꞌll bseꞌleꞌ leakeꞌ chixjweꞌ akreꞌ beꞌnne kanꞌ nak yel llnebiaꞌ ke Diosenꞌ, naꞌ wayón akeꞌ beꞌnn llak yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naꞌll golleꞌ leakeꞌ: —Bitbi goꞌxzre ke tnez, bi wayirjzre yay wchiꞌchre, ni bzod, ni yet, ni mell, ni ye chkweꞌ xharaꞌnre bi goꞌxre. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yell ga llinre, toz yoꞌ sore chak sore rao yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Chaꞌ to yell ga llinre bi siꞌi akeꞌ xtiꞌllrenꞌ, lewalloj yellenꞌ, lewabibte niaꞌre nench wallib bichtenꞌ blliare naꞌ, naꞌ gakbeꞌe akreꞌ da xhinnj xhen naꞌ llon akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Naꞌll bzaꞌa beꞌnn kaꞌ, byej akeꞌ toto yell, llyixjweꞌ akreꞌ Diꞌll Wen ke Diosenꞌ, naꞌ llayón akeꞌ beꞌnn llak yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes, beꞌnnenꞌ llnebiaꞌ Galileanꞌ to llakeꞌ tore, ka llenreꞌ yeolol da kaꞌ llon Jesúsenꞌ, naꞌ da xhen llakganreꞌ ka nak llenreꞌ ne beꞌnn kaꞌ: “Cheke Juan naꞌ babanrizeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ye bal akeꞌ ne: “Cheke Elíasenꞌ, ba baraꞌ rao yellrionꞌ da yobre.” Naꞌ llaꞌa beꞌnn ne akeꞌ: “To beꞌnn kaꞌ beꞌe xtiꞌll Dios, beꞌnn bzo kanaꞌn ba babán, naꞌllenꞌ lloneꞌ kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Naꞌll Herodesenꞌ bneꞌe: —Nadaꞌ bseꞌlaꞌ beꞌnn ak bchoy akeꞌ yen Juan naꞌ, ¿noxha beꞌnnenꞌ ne akeꞌ kaꞌ? Naꞌ le lleꞌne Herodesenꞌ reꞌreꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ka ballín postl kaꞌ ganꞌ zo Jesúsenꞌ, beꞌrén akeꞌ Leꞌe diꞌll kanꞌ jen akeꞌn. Naꞌ bcheꞌe leakeꞌ to latj dach ganꞌ nbane yellenꞌ re Betsaida. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ka gokbeꞌe beꞌnn yell kaꞌ ba broeꞌ nez, naꞌ bnao akeꞌ Leꞌe. Ka breꞌe Jesúsenꞌ leakeꞌ goxheꞌ leakeꞌ, naꞌll bzejnieꞌreꞌ leakeꞌ kanꞌ llnebiaꞌ Diosenꞌ, naꞌ bayoneꞌ beꞌnn llak yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Naꞌ ba llonen ba wlleꞌ, naꞌ beꞌnn chllinn kaꞌ jabiꞌy akeꞌ, lle akeꞌ Leꞌe: —Bseꞌl beꞌnn ki lljakeꞌ yell kaꞌ lliꞌ do naꞌ, nench chirj akeꞌ ga tas akeꞌ, naꞌ llel da gao akeꞌ, le ker bi de ganni, naken to latj dach. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naꞌ lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Reꞌ llayaꞌl weꞌre da gao akeꞌ. Naꞌll bne akeꞌ: —Gaꞌy ze yet xtir, naꞌ ye chopze belyaꞌ daꞌo de kello, lete chaꞌ lliꞌo lljeꞌollo da gao beꞌnn ki. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Naꞌ nak ka do gaꞌy mir zre beꞌnn byio. Naꞌ goll Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Leyé akeꞌ kweꞌ chiyon (50) wej akeꞌ, kwen kwenze. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naꞌ kaꞌ ben akeꞌ, naꞌ blleꞌ yeolol beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naꞌ bxhieꞌ yet xtir gaꞌy kaꞌ, naꞌ belyaꞌ kaꞌ ye chop, naꞌ le bwiateꞌ leꞌ yebáre, benlaꞌyeꞌn, naꞌ beꞌe yel llioxken ke Dios, naꞌll bxhoxhjeꞌn beꞌe beꞌnn kaꞌ non Leꞌen txhen naꞌ, naꞌ leakeꞌn le beꞌe akteꞌn beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yeolol akeꞌ bdao to berj aktereꞌ, naꞌ batop akeꞌ da laꞌo kaꞌ bagoꞌnnenꞌ, naꞌ goken ye chllinn (12) llom. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gok ye to ka niꞌt beꞌnn kaꞌ non Jesúsenꞌ txhen ren Leꞌe, naꞌ Leꞌe lloeꞌreneꞌ Diosenꞌ diꞌlle to wraze. Naꞌll golleꞌ leakeꞌ: —¿Bi ne beꞌnn kaꞌ no nakaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Naꞌ lle akeꞌ Leꞌe: —Llaꞌa beꞌnn ne akeꞌ Juan beꞌnnenꞌ bchoa nis rweꞌ, naꞌ ye baleꞌ ne akeꞌ Elías rweꞌ, naꞌ ye baleꞌ neꞌe, kon to beꞌnn kaꞌ beꞌe xtiꞌll Dios kanaꞌ babán. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naꞌll lleꞌe leakeꞌ: —¿Bixha ne reꞌ, nonꞌ nakaꞌ? Naꞌll ne Pedronꞌ: —Rweꞌn Cristo beꞌnn bseꞌl Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Naꞌ Jesúsenꞌ goꞌtyoereꞌ leakeꞌ, ni to beꞌnn bi weꞌrén akeꞌ diꞌll chaꞌ Leꞌen Cristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naꞌll lleꞌe leakeꞌ: —Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, da xhen za wallayrawaꞌ, kaꞌn llayaꞌl gak. Ka nak beꞌnn gor kaꞌ llnebiaꞌ Israelenꞌ, naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, bi choꞌraꞌll akeꞌ xtiꞌllaꞌn, naꞌ got akeꞌ nadaꞌ, naꞌ wayónn lla wabanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naꞌtell lleꞌe beꞌnn kaꞌ llaꞌn: —Noteze beꞌnne chaꞌ lleꞌnreꞌ gakeꞌ nadaꞌ txhen, llayaꞌl wsanraꞌll kwineꞌ, naꞌ goneꞌ ka to beꞌnn noaꞌ cruz keꞌe, naꞌ naweꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Noteze beꞌnn lleꞌnreꞌ yesrá yel nban ke kwineꞌ yellrio ni, wniteꞌn, naꞌ noteze wnit yel nban keꞌen ni kiaꞌ nadaꞌ, leꞌen gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Bixha zaꞌken naꞌ, chaꞌ to beꞌnne goneꞌ gan doxhente da de rao yellrio, naꞌ kweyieꞌ, bi gaꞌt yel nban zejlikane keꞌe? ");
INSERT INTO zpuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chaꞌ noteze beꞌnn wayeꞌreꞌ nadaꞌ, naꞌ ke xtiꞌllaꞌn, leskaꞌ nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, wayeꞌraꞌ nniaꞌ nakeꞌ nadaꞌ txhen, katenꞌ yedaꞌ da yobre nsaꞌa yel beniꞌ xhen kiaꞌn, naꞌ yel beniꞌ ke Xaꞌn ren ke angl kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Da li niaꞌ reꞌ, balre llaꞌa ganni, bire nna llin lla gatre kate reꞌre nnebiaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Gok ka to xhman ka beꞌe diꞌll ki, byejeꞌ to rao yaꞌ jeꞌreneꞌ Diosenꞌ diꞌlle, naꞌ ncheꞌe Pedronꞌ ren Jacobo, ren Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Chak lloeꞌreneꞌ Diosenꞌ diꞌllenꞌ, bllaꞌa yichjraweꞌn, naꞌ gok xharaꞌneꞌn llich kwis, to llaktiten. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Le bllinte da Moisés, naꞌ da Elías, beꞌnn kaꞌ bzo kanaꞌ, naꞌ lloeꞌrén akeꞌ Jesúsenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Naꞌ nechj beniꞌ xhen ke Diosenꞌ leakeꞌ, naꞌ lloeꞌ akeꞌ diꞌll ke nak chej Jesúsenꞌ Jerusalén, naꞌ wallayraweꞌ naꞌ gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedronꞌ ren beꞌnn kaꞌ ye chop, le nen btas ke akeꞌ; bixha bi btas akeꞌ, naꞌ breꞌe akreꞌ Jesúsenꞌ ren beniꞌ xhen keꞌen, naꞌ ren beꞌnn kaꞌ chop zerén Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Naꞌ ka ba llazaꞌ da Moisésenꞌ ren da Elíasenꞌ, Pedronꞌ golleꞌ Jesúsenꞌ: —Maestro, le wen zollo ganni, naꞌ gonllo chonn yoꞌ de yixh, to koꞌo rweꞌ, to Moisés naꞌ, naꞌ ye to Elías. Bneꞌe kaꞌ le ker llakbeꞌreꞌ binꞌ neꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Naꞌ neteꞌ kaꞌn, kate to bej byechjen leakeꞌ, naꞌll blleb Pedronꞌ kwis ren beꞌnn lwelljeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kate ben akreꞌ bnne Diosenꞌ lo bejenꞌ, bneꞌe: —Beꞌnn ninꞌ Xhiꞌnnaꞌ, beꞌnn nllieꞌraꞌ; Leꞌen wzenayre keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka bayoll ben akreꞌ be xhnne ke Diosenꞌ, naꞌ breꞌe akreꞌ ye toze Jesúsenꞌ zeꞌe. Nono beꞌrén akzeꞌ diꞌll ke danꞌ breꞌe akreꞌn, bzo akeꞌ llize. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bateyó ka llayetj akeꞌ leꞌ yaꞌn, beꞌnn zan jatil leakeꞌ ganꞌ llayetj akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Naꞌ blloj to beꞌnn radj beꞌnn zan kaꞌ, bnneꞌe zillj lleꞌe Jesúsenꞌ: —Maestro, ben okré bwia xhiꞌnnaꞌn, tiꞌchze lebeꞌn nak. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Llzap daxiꞌon lebeꞌ, naꞌ to ka zezbeꞌ llosiaꞌbeꞌ, naꞌ llxizen lebeꞌ, naꞌ llonen llarj pep blliꞌn lloaꞌbeꞌ; lltolen lebeꞌ, naꞌ ni ke llallojzen. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba gollaꞌ beꞌnn kaꞌ non rweꞌ txhen naꞌ, wabej akeꞌ daxiꞌon, naꞌ bi gok akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Naꞌll bne Jesúsenꞌ: —Reꞌ nakre beꞌnn wen da xhinnj, naꞌ bi llejleꞌre, ¿battenꞌ naꞌ zerenaꞌ reꞌ? Naꞌll lleꞌe beꞌnnenꞌ: —Da waꞌa xhiꞌnnoꞌn ni. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chak zej bidaꞌon raweꞌ naꞌn, bllixtol daxiꞌon lebeꞌ ziꞌllo, naꞌ Jesúsenꞌ bdileꞌ daxiꞌon, naꞌ ballojen, naꞌ bayak bidaꞌon, naꞌ bayoeꞌbeꞌ xabeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yeolol beꞌnn kaꞌ llabán akreꞌ, kanꞌ llreꞌe akreꞌ yel wak ke Diosenꞌ. Nna zete beꞌnn kaꞌ, llabán akreꞌ danꞌ llon Jesúsenꞌ, kate golleꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Legón bien nench diꞌll ki choꞌn yichjraꞌlldaꞌore, le nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, wllin lla gakaꞌ rallnaꞌa beꞌnn kaꞌ llwie nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Naꞌ beꞌnn kaꞌ nao Leꞌen, bi byejnieꞌ akreꞌ bixchen neꞌe kaꞌ, le nna ngaꞌchen rao akeꞌn, naꞌ leskaꞌ bi llayaxhj akreꞌ wnnab akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Beꞌnn kaꞌ nao Jesúsenꞌ bzorao lloeꞌrén lwellj akeꞌ diꞌll, norenꞌ gakll beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesúsenꞌ gokbeꞌreꞌ kanꞌ llon akeꞌ xhbabenꞌ, naꞌ goxheꞌ to bidaꞌo bzebeꞌ kwiteꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Naꞌll lleꞌe leakeꞌ: —Notezre chaꞌ gakrenre ka bidaꞌon gonre wen kebeꞌ, danꞌ llonliraꞌllbeꞌ nadaꞌ, nadkzaꞌn gonre wen kiaꞌ chet kaꞌ. Naꞌ beꞌnnenꞌ llakren nadaꞌ, Diosenꞌ, beꞌnnenꞌ bseꞌl nadaꞌn, llakreneꞌ chet kaꞌ. Naꞌ beꞌnnenꞌ bi llonxhen kwineꞌ, leꞌen nak beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Naꞌll Juan naꞌ golleꞌ Leꞌe: —Maestro, breꞌtoꞌ to beꞌnn llabejeꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne kone raꞌo naꞌ. Naꞌ golltoeꞌ bill goneꞌ kaꞌ, le bi nakeꞌ lliꞌo txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Naꞌll Jesúsenꞌ lleꞌe leꞌe: —Bi wllonre goneꞌ kaꞌ. Chaꞌ to beꞌnne bi llwiereꞌ lliꞌo, txhenkzenꞌ nakeꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bixha ka ba zo llin lla, wayejeꞌ waziꞌi Diosenꞌ Leꞌe, naꞌ bchoyraꞌlleꞌ chejeꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naꞌ bseꞌleꞌ to chop beꞌnn blliarao raweꞌn, lljen akeꞌ xhnid ganꞌ llineꞌn. Beꞌnn kaꞌ bseꞌleꞌn, byoꞌ akeꞌ to yell ga nbane Samaria. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Naꞌ beꞌnn Samaria kaꞌ, bi gokraꞌll akeꞌ choeꞌ yell ke akeꞌn, ni ke danꞌ llwia akeꞌ lloneꞌ ka beꞌnn zej Jerusalénre. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Naꞌ Juan naꞌ, ren Jacobonꞌ, ka breꞌe akreꞌ kanꞌ bene beꞌnn kaꞌ Jesúsenꞌ, goll akeꞌ Leꞌe: —Xantoꞌ, ¿Lleꞌnroꞌ, gontoꞌ kanꞌ ben da Elías beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ, wnnabtoꞌ yetj yiꞌ zaꞌa yebá, wzeyen beꞌnn ki? ");
INSERT INTO zpuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Naꞌ bayechjeꞌ bdileꞌ leakeꞌ, bneꞌe: —Bi llakbeꞌre bi Spíritu xhinnje llnebiaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Le nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, kere bedaꞌ nench wlleyiaꞌ beꞌnnenꞌ, bedaꞌ nench yesrá akreꞌn. Bayoll bneꞌe kaꞌ, naꞌll zjakeꞌ yell yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chak zjakeꞌ naꞌn, to beꞌnn golleꞌ Jesúsenꞌ: —Xanaꞌ, wnawaꞌ rweꞌ gateze chejoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Naꞌll lle Jesúsenꞌ leꞌe: —Beꞌz kaꞌ zo ga llallín akbaꞌ lltas akbaꞌ, naꞌ ba kaꞌ zo xir dá rao lla, llia xoꞌnn akbaꞌ, zan nadaꞌ, nakaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, bitbi zo ga yeziꞌraꞌllaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naꞌ Jesúsenꞌ golleꞌ ye to beꞌnn yobre: —Da nnao nadaꞌ. Naꞌ beꞌnnenꞌ golleꞌ Leꞌe: —Xanaꞌ, zgaꞌtek benn latj wkwaꞌchaꞌ xaꞌn kate gateꞌ, naꞌll nnawaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Naꞌll lle Jesúsenꞌ leꞌe: —Bkwaꞌnn beꞌnn wat kaꞌ, wkwaꞌchze lwellj beꞌnn wat kaꞌ, zan rweꞌ byej jatixjweꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Naꞌll to beꞌnn yobre golleꞌ Jesúsenꞌ: —Wnawaꞌ rweꞌ Xanaꞌ, zgaꞌtek ben latj lljayeꞌrenaꞌ biꞌch lwelljaꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Naꞌ Jesúsenꞌ golleꞌ leꞌe: —Chaꞌ to beꞌnn llwaꞌnneꞌ belle, naꞌ nchiꞌcheꞌ radenꞌ nawebaꞌ; kere wayechjeꞌ, naꞌ llwiazeꞌ ganꞌ ba bdeꞌe naꞌ, beꞌnnenꞌ gon kaꞌ rao xhnnez Diosenꞌ bi gakeꞌ nnaweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bde naꞌ, Xanllonꞌ brejeꞌ wyon chi beꞌnne, naꞌ golleꞌ leakeꞌ kwiarao akeꞌ raweꞌn, naꞌ chej chop wej akeꞌ toto yell ganꞌ za tieꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naꞌ lleꞌe leakeꞌ: —Da li niaꞌ reꞌ, ka beꞌnn gon wrapenꞌ gonllo, da xhen llin naꞌ de, naꞌ to chopze beꞌnn wrap kaꞌ nak. Lennabe Dios beꞌnnenꞌ nak xan llin naꞌ, wseꞌleꞌ yezikre beꞌnn wen llin rao llin naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lechej, ni llseꞌlaꞌ reꞌ, ka llseꞌleꞌ xhiꞌr daꞌo radj beꞌkw yiꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bi goꞌxre bzod ni mell, ni ye chkweꞌ xher-re, naꞌ bi sezre scha wapre beꞌnn lliox tnez. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yoꞌ ganꞌ llinre, ka choꞌrenꞌ zgaꞌtek nnere: “Sochgare wen.” ");
INSERT INTO zpuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chaꞌ lo yoꞌ naꞌ zo to beꞌnn nak raꞌlldaꞌo wen, gonkze Diosenꞌ gak wen keꞌe. Chaꞌ nono llraꞌ beꞌnn nak raꞌlldaꞌo wen, bi gak kanꞌ yerenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yoꞌ ga llinre, gannaꞌze sore, yeꞌj gaotezre kon da gonn akeꞌ. Ka to beꞌnn wen llin llayaꞌl siꞌkze raxhjeꞌ, kaꞌkze ke reꞌ; bi tasre toto yoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chaꞌ to yell ga llinre, kon da gonn akeꞌ llayaꞌl gaore. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lennab yeyak chaꞌ beꞌnn llak yillweꞌ, naꞌ leyé akeꞌ: “Ba bllin lla reꞌllo kanꞌ llnebiaꞌ Diosenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Chaꞌ to yell ga llinre bi wreb akeꞌ reꞌ, lechej do lyell, leyé akeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bichte danꞌ bllia lo niaꞌtoꞌn rao yell keré naꞌ, llabibtoꞌn nench waxhoan koꞌllre, naꞌ llayaꞌl nnézere ke yel llnebiaꞌ ke Diosenꞌ, ba braꞌ rao rallrenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ni llniaꞌ reꞌ, kate llin lla gon Diosenꞌ yel koxchis ke yeolol beꞌnne, da xhenll yellayrao beꞌnn ki, kerke beꞌnn Sodoma kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Nyaꞌchraz ke reꞌ beꞌnn Corazín! ¡Naꞌ nyaꞌchraz ke reꞌ beꞌnn Betsaida! Chenake broeꞌraꞌ beꞌnn kaꞌ niꞌt yell kaꞌ nziꞌi Tiro, naꞌ Sidón yel wak kiaꞌn ka danꞌ ba broeꞌraꞌ reꞌ, batnaꞌ ba bayechj akeꞌ banao akeꞌ Diosenꞌ chenake, naꞌ llak akeꞌ to raꞌll gasj da nak zeꞌch, naꞌ llwazj kwin akeꞌ no de da llroeꞌn ba bayat akreꞌ chenake. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kate llin lla gak yel koxchis ke yeolol beꞌnne, da xhenll yellayraore kerke beꞌnn Tiro, naꞌ beꞌnn Sidón kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Naꞌ reꞌ beꞌnn Capernaum, llákere ba zekzre yebá, ga lleꞌle gor wazaꞌleꞌ reꞌ, ga yellayraore. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Naꞌll lleꞌe beꞌnn kaꞌ non Leꞌe txhen: —Beꞌnn wzenayeꞌ xtiꞌllrenꞌ, kiaꞌ nadkzaꞌn wzenayeꞌ chet kaꞌ; naꞌ beꞌnnenꞌ bi wzenayeꞌ xtiꞌllrenꞌ, kiaꞌ nadkzaꞌn bi wzenayeꞌ. Naꞌ beꞌnnenꞌ bi wzenayeꞌ kiaꞌ nadaꞌ, ke Dios beꞌnnenꞌ bseꞌl nadaꞌn, bi wzenayeꞌ ke chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bixha gok kate ballín beꞌnn wyon chi kaꞌ, llawé akreꞌ ballín akeꞌ, lle akeꞌ Jesúsenꞌ: —¡Xantoꞌ, rente daxiꞌo kaꞌ, llzenay aken ketoꞌ kate llwaꞌltoꞌ raꞌon! ");
INSERT INTO zpuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Naꞌll lle Jesúsenꞌ leakeꞌ: —To breꞌkazraꞌ llaz daxiꞌon lleꞌle, ka llaz yiꞌ bziꞌo ka nak llnit yel llnebiaꞌ ken. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ganni llonnaꞌ reꞌ yel wak, nench wrejchekwre no bele, no xhban leo, naꞌ wrejchekwre doxhen yel wak ke da lleꞌne wlliayiꞌ lliꞌo, naꞌ reꞌ bibi gákere. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naꞌ bi wawétekere, ni ke danꞌ llzenay daxiꞌon keré, zan leyewé le ba nllia Diosenꞌ rarenꞌ leꞌ libr keꞌen yebá. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Rawe naꞌ bawé Jesúsenꞌ, ka nak zorén Spíritu ke Diosenꞌ Leꞌen, naꞌ bneꞌe: —Lloeꞌrawaꞌ rweꞌ Dios Xa, rweꞌn llnebiaꞌo yebá naꞌ yellrionꞌ, bkwaꞌchoꞌ da ki, bi byejnieꞌ beꞌnn siꞌn kaꞌ len, naꞌ broeꞌroꞌn beꞌnn nak nexjraꞌlle. Benoꞌ kaꞌ Xa, le kaꞌn byoꞌraꞌlloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Yeololte da de, Xaꞌn ba beneꞌn rallnaꞌ, naꞌ nono nombiaꞌ Xhiꞌnneꞌn, toz Xaꞌ naꞌ nombieꞌ Leꞌe, naꞌ nono nombiaꞌ Xaꞌn, toz nadaꞌ nak Xhiꞌnneꞌ nombieꞌ, naꞌ kon no llbejaꞌ nadaꞌ llroeꞌreꞌ kanꞌ nak Xaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Naꞌ bayechjeꞌ golleꞌ beꞌnn kaꞌ non Leꞌe txhen to wraz akzeꞌ: —Nbaraz ke reꞌ llreꞌre nadaꞌ, naꞌ da kaꞌ llonaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Le beꞌnn zan beꞌnn beꞌe xtiꞌll Diosenꞌ, naꞌ beꞌnn llnebiaꞌ bllaꞌa kanaꞌ, le gokraꞌll akeꞌ reꞌe akreꞌ ka da kaꞌ llreꞌre nnaꞌ, naꞌ bi breꞌe akreꞌn; naꞌ le gokraꞌll akeꞌ yen akreꞌ ke danꞌ llénere nnaꞌ, naꞌ bi ben akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Naꞌ bzollaꞌa to beꞌnn llsed llroeꞌ ley danꞌ bzoj da Moisésenꞌ, gokraꞌlleꞌ kwejeꞌ Jesúsenꞌ diꞌlle, lleꞌe Leꞌe: —Maestro, ¿Bi llayaꞌl gonaꞌ nench gaꞌt yel nban zejlikane kiaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Naꞌll lle Jesúsenꞌ leꞌe: —¿Akxha nyoj leꞌ leyenꞌ? ¿Akre nen? ");
INSERT INTO zpuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naꞌll beꞌnnenꞌ llejnieꞌ leyenꞌ kwasro bneꞌe: —“Llieꞌroꞌ Dios do yichj do raꞌlloꞌ, naꞌ llieꞌroꞌ beꞌnn lwelljoꞌ, kaꞌkze nllieꞌroꞌ kwinoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Naꞌll Jesúsenꞌ lleꞌe leꞌe: —Da li kanꞌ bneꞌon, kaꞌn ben, naꞌll banoꞌ zejlikane. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Naꞌ beꞌnnenꞌ, gokraꞌlleꞌ wroeꞌreꞌ dakze lixheje, naꞌ lleꞌe Jesúsenꞌ: —¿Ka noxha beꞌnnenꞌ nak beꞌnn lwelljaꞌn, naꞌ llieꞌreꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Naꞌll bne Jesúsenꞌ: —To beꞌnn bzeꞌe Jerusalén, naꞌ zejeꞌ Jericó, bixha gok bllayreꞌ beꞌnn wan, naꞌ bkaꞌa akeꞌ bi keꞌe da nseꞌe, ben akeꞌ ziꞌ keꞌe, naꞌ bkwaꞌnn akeꞌ leꞌe tnezenꞌ ye zre ke bet akzeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kaꞌ goken, kate bde to bxoz tnezenꞌ, ka breꞌreꞌ beꞌnn weꞌen, naꞌ bdieꞌ ye chlaꞌre nezenꞌ zejzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Naꞌll bde ye to beꞌnn kaꞌ nziꞌi levita, lleꞌnen nen beꞌnn llakrén lo yodaꞌo, leskaꞌ ka breꞌreꞌ beꞌnn weꞌen, le bdeteꞌ ye chlaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bixha to beꞌnn Samaria, bdieꞌ tnezenꞌ; ka breꞌreꞌ beꞌnn weꞌen, bayaꞌchraꞌlleꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naꞌ jabiꞌyeꞌ kwiteꞌ, naꞌ bdibeꞌ weꞌe keꞌen, btopeꞌn ceit, naꞌ blloneꞌn xis uva, naꞌ beneꞌn rmell, naꞌ bchejeꞌn to raꞌlle. Naꞌ bleneꞌ leꞌe bllieꞌ leꞌe koꞌll burr keꞌen, naꞌ bcheꞌe leꞌe ga zo to yoꞌ ga lltas beꞌnn yoꞌ nez. Gannaꞌ basyolleꞌ bwieꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bateyó ka yeweꞌ nezenꞌ, brejeꞌ chop mell danꞌ nziꞌi denario, naꞌ beꞌen xan yoꞌn, lleꞌe leꞌe: “Ben gokre bwia beꞌnnenꞌ, chaꞌ billre da gonoꞌ gaxt, naꞌ wayixhjaꞌn kate zazaꞌa naꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naꞌll goll Jesúsenꞌ beꞌnnenꞌ: —Bnechk rweꞌ, ¿nore beꞌnn ki chonne, gokreꞌ ke beꞌnnenꞌ bran akeꞌn nakeꞌ beꞌnn lwelljeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naꞌ bne beꞌnnenꞌ llsed llroeꞌ leyenꞌ: —Beꞌnnenꞌ bayaꞌchraꞌll beꞌnn weꞌen bran akeꞌn. Naꞌll lle Jesúsenꞌ leꞌe: —Lekze kaꞌn llayaꞌl gonoꞌ rweꞌ, wayaꞌchraꞌlloꞌ yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naꞌ Jesúsenꞌ baweꞌ nez da yobre, naꞌ bllin akeꞌ to yell, naꞌ rao yell naꞌ, zo to noꞌr re Marta, naꞌ beneꞌ Jesúsenꞌ yexh chejeꞌ rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naꞌ zo to bir Martanꞌ, naꞌ re María, naꞌ Maríanꞌ le blleꞌteꞌ xhniaꞌ Jesúsenꞌ llzenayeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Naꞌ Martanꞌ llaral-llreꞌ llsinieꞌ da gao akeꞌ, kate jabiꞌyeꞌ kwit Jesúsenꞌ, lleꞌe Leꞌe: —Xanaꞌ, ¿bi llakbeꞌroꞌ bi biraꞌn tozaꞌ bkwaꞌnnbeꞌ, llsiniaꞌ ganni? Gollbeꞌ gakrenbeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Naꞌll Jesúsenꞌ lleꞌe Martanꞌ: —Marta, Marta, le lliꞌ yichjoꞌ danꞌ llsiniaꞌon, naꞌ llakllejlaꞌlloꞌ danꞌ nyan da zed koꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Zan toze da de da nak lliarao gonllo, len naꞌ ba brej Maríanꞌ lloneꞌ, naꞌ nono gak wakaꞌa len. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gok ka zo Jesúsenꞌ to latj ga lloeꞌreneꞌ Diosenꞌ diꞌlle, bayoll naꞌ to beꞌnn kaꞌ non Leꞌe txhen, golleꞌ Leꞌe: —Xantoꞌ, bsede netoꞌ akrenꞌ weꞌrentoꞌ Diosenꞌ diꞌll, kanꞌ ben Juan beꞌnnenꞌ bchoa nis, broeꞌreꞌ beꞌnn kaꞌ bnao leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naꞌll lleꞌe leakeꞌ: —Kate weꞌrenre Diosenꞌ diꞌll, ki nnere: Xa, rweꞌ lliaꞌo yebá, nak laꞌy raꞌon. Yedchga yel llnebiaꞌ koꞌon. Gakchga kanꞌ lleꞌnroꞌ rao yellrionꞌ, kanꞌ llak yebá naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Naꞌ danꞌ gaotoꞌ tlla tlla, bennchgan nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Naꞌ baziꞌxhen ketoꞌ, kanꞌ llon netoꞌ, llaziꞌxhentoꞌ ke beꞌnn biteze da llon akreꞌ netoꞌ. Bi wsanraꞌlloꞌ netoꞌ, yexjtoꞌ rao da xhinnjenꞌ, bkwas brekyiꞌll netoꞌ rao da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Naꞌll leskaꞌ lleꞌe leakeꞌ: —Bixha chaꞌ reꞌ, zo to beꞌnn nombiaꞌre kwasro, naꞌ chejre rilleꞌn llere, naꞌ yereꞌ: “Beꞌnn nllieꞌraꞌ, ben gokre brej nadaꞌ chonn yet xtir; ");
INSERT INTO zpuNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","braꞌ to beꞌnn nllieꞌraꞌ beꞌnn zaꞌa ziꞌte, naꞌ bikzbi de kiaꞌ waꞌa gaweꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naꞌ beꞌnnenꞌ walliꞌ kerénꞌ ganꞌ deꞌe naꞌ, yeꞌe reꞌ: “Bi gonroꞌ nadaꞌ zede, ¿bi llwiaꞌo ba neyj yoꞌn, naꞌ ren xhiꞌnnaꞌ ki ba tastoꞌ, naꞌ bi gak chasaꞌ gonnaꞌn?” ");
INSERT INTO zpuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ni niaꞌ reꞌ, laꞌkze bi nnen ke chaseꞌ gonneꞌn, naꞌ danꞌ zere llchieꞌre naꞌ, wyaskzeꞌ gonneꞌ danꞌ llnnabrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ke len naꞌ niaꞌ reꞌ: Lewnnab, chaꞌ bi wnnabre, gonnkze Diosenꞌ len; lechirj, chaꞌ bi chirjre, wllelkzen; lewseꞌkw, naꞌ wyarjkze choꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Le noteze beꞌnne bi da llnnabeꞌ, wziꞌkzeꞌn; naꞌ beꞌnn llyirjeꞌ, wllelkzereꞌn; naꞌ beꞌnn llnneꞌe, llsarj akseꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Chaꞌ reꞌ zo to xhiꞌnnre, naꞌ wnnábebeꞌ reꞌ to yet xtir, kere weꞌzrebeꞌ to yej. Chaꞌ wnnábebeꞌ reꞌ to belyaꞌ, kere weꞌzrebeꞌ to bele. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naꞌ chaꞌ wnnábebeꞌ reꞌ to xchit bellj, kere weꞌzrebeꞌ to xhban leo. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chaꞌ reꞌ naktere beꞌnn wen da xhinnj, nnézere llayaꞌl weꞌe xhiꞌnnre da wen, gonntell Xare beꞌnnenꞌ zo yebá, gonneꞌ reꞌ Spíritu keꞌen kon chaꞌ wnnabren. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Bixha gok ka llabej Jesúsenꞌ to daxiꞌo yoꞌ to beꞌnn blloj; ka balloj daxiꞌon, le bannete beꞌnn bllojenꞌ. Naꞌll llabanre beꞌnn kaꞌ llaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Naꞌ bal beꞌnn kaꞌ bne akeꞌ: —Llabejeꞌ daxiꞌo kaꞌ kone yel wak ke Beelzebú danꞌ llnebiaꞌ daxiꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naꞌ ye baleꞌ, kon llnnab akeꞌ wroeꞌreꞌ yel wak keꞌen, goneꞌ to da goneꞌ leꞌ yebá, nench gaꞌt da wxoa akeꞌ doꞌl koꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesúsenꞌ llakbeꞌtereꞌ kanꞌ nak xhbab ke akeꞌn, naꞌll lleꞌe leakeꞌ: —Chaꞌ beꞌnn llaꞌa to yell gak akeꞌ chopre, wllin lla kate kwiayiꞌ yellenꞌ. Naꞌ chaꞌ beꞌnn llaꞌa to lo yoꞌ, nak akeꞌ chopre, leskaꞌ wllin lla kate waran akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Leskaꞌ daxiꞌo kaꞌ, chaꞌ nak aken chopre, les bi gak soyib aken scha chet kaꞌ. Le kanꞌ nere llabejaꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne kone yel wak ke Beelzebúnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chaꞌ naken kanꞌ nerenꞌ, ¿bixha xhiꞌnnre kaꞌ, bi kone llabej akeꞌ daxiꞌo kaꞌ yichjraꞌlldaꞌo beꞌnne? ¿Kone yel wak ke Beelzebú naꞌn llon akeꞌ kaꞌ? Leakeꞌ wroeꞌ akreꞌ, krerenꞌ nak xhbab kerénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Zan chaꞌ llabejaꞌ daxiꞌo kaꞌ kone yel wak ke Dios, len naken to da llroeꞌ ba bzorao llroeꞌ Diosenꞌ yel llnebiaꞌ keꞌen ganꞌ llaꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Kate to beꞌnn war, llapeꞌ rilleꞌn kon ren ya, notno gak choꞌ rilleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Zan chaꞌ llin to beꞌnn nak beꞌnn warlle tilreneꞌ leꞌe, naꞌ goneꞌ leꞌe gan, naꞌ wkeꞌe ya keꞌen danꞌ nxenraꞌlleꞌn, naꞌ wkaꞌteꞌ yeolol da de keꞌe, naꞌ chisen weꞌe beꞌnn kaꞌ nakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Beꞌnn bi lloneꞌ nadaꞌ txhen, llwiereꞌ nadaꞌn. Naꞌ beꞌnn bi llakreneꞌ nench wzenay beꞌnn kaꞌ kiaꞌ, yezikre lloneꞌ nench nono wzenaykze kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Kate to daxiꞌo llallojen yichjraꞌlldaꞌo beꞌnnenꞌ, naꞌ dan llayirjen ga lljachoꞌn ga yobre. Naꞌ chaꞌ bi ll-llelen to latj ga yeziꞌraꞌllen, naꞌll nnen: “Wayaꞌchkaꞌ lljawiaꞌ ganꞌ ballojaꞌn, chaꞌ gak lljalloaꞌ da yobre.” ");
INSERT INTO zpuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Naꞌll llayejen lljawian ganꞌ zo beꞌnnenꞌ, naꞌ kate reꞌren raꞌlldaꞌo beꞌnnenꞌ, naken ka to yoꞌ da nxhi nloa, naꞌ ndachen. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naꞌll lljatopen ye gall daxiꞌo da llonll ka len, naꞌll yellaꞌa aken txhen lo raꞌlldaꞌo beꞌnnenꞌ. Naꞌ chaꞌ kaꞌ ba ben akeꞌn, naꞌll yezikre gakll ke beꞌnnenꞌ, kere kanꞌ gok keꞌe kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chak lloeꞌ Jesúsenꞌ diꞌll ki, to noꞌr ren radj beꞌnn kaꞌ llaꞌa llzenay xtiꞌlleꞌn, bnneꞌe lleꞌe Jesúsenꞌ: —Nbaraz ke noꞌrenꞌ bxhan rweꞌ, naꞌ bwaꞌlleꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naꞌ bne Jesúsenꞌ: —Nakllen nbaraz ke beꞌnnenꞌ llzenay xtiꞌll Diosenꞌ, naꞌ lloneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Naꞌ ka badop beꞌnn zanll kwit Jesúsenꞌ, naꞌll lleꞌe leakeꞌ: —Beꞌnn kaꞌ llaꞌa nnaꞌ, nak akeꞌ beꞌnn wen da xhinnj kwis, llnnab akeꞌ to da gonaꞌ nench wroeꞌraꞌ yel wak kiaꞌn, naꞌ chejleꞌ akeꞌ kiaꞌ; zan bi gak kanꞌ llnnab akeꞌn, toze kanꞌ gok ke da Jonás beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, kaꞌkzenꞌ gak kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ka danꞌ gok ke Jonásenꞌ, len naꞌ breꞌe beꞌnn Nínive kaꞌ, naꞌ bayakbeꞌe akreꞌ Diosenꞌ bseꞌl leꞌe. Kaꞌn gok keꞌe naꞌ, kaꞌkzenꞌ gak kiaꞌ nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, naꞌ gaken to da reꞌe beꞌnn kaꞌ llaꞌa nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Noꞌrenꞌ bnebiaꞌ yellenꞌ re Sabá, kate llin lla gak yel koxchis ke yeolol beꞌnne, wabanreneꞌ txhen beꞌnn ki llaꞌa nnaꞌ, naꞌ wchoybieꞌ ke akeꞌ, le leꞌen ziꞌt kwis bedeꞌ badzenayeꞌ yel siꞌn ke da Salomón naꞌ, naꞌ nadaꞌ zaꞌktellaꞌ kerke Salomón naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Beꞌnn Nínive kaꞌ, kate llin lla gak yel koxchis ke yeolol beꞌnne, wabanrén akeꞌ beꞌnn ki llaꞌa nnaꞌ, naꞌ wchoybiaꞌ akeꞌ ke akeꞌ, le leakeꞌn ka ben akreꞌ xtiꞌll da Jonásenꞌ, bayat akreꞌ ke da xhinnj ke akeꞌn, naꞌ nadaꞌ zaꞌktellaꞌ kerke da Jonásenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ni to beꞌnne kate wxhenzeꞌ to yiꞌ, wkwaꞌchzeꞌn o chaꞌ wdoꞌszeꞌn to llom, zan lldeꞌen sibe nench llseniꞌn ke yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yejraore llian naken ka to beniꞌ nench reꞌre. Chaꞌ bibi llaken, llreꞌkzere kwasro. Zan chaꞌ yejraorenꞌ bi naken wen, doxhenre ncholen chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lewiayaꞌnn ke nnebiaꞌ da xcholenꞌ reꞌ, leweꞌe latj choꞌ beniꞌ ke Diosenꞌ yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chaꞌ bill yoꞌllo ni raꞌt da xcholenꞌ, naꞌ doxhen yichjraꞌlldaꞌollo yoꞌn beniꞌn ke Dios, kanaꞌllenꞌ chejnieꞌllo kanꞌ nak xhnnez Diosenꞌ, gonen kaꞌkze ga llseniꞌ to yiꞌ xhen rao nezenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka bayoll beꞌe Jesúsenꞌ diꞌll ki, to beꞌnn fariseonꞌ beneꞌ Leꞌe yexh rilleꞌ lljataweꞌ. Ka byoꞌ Jesúsenꞌ rill beꞌnnenꞌ, naꞌ bllieꞌ ganꞌ gao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Beꞌnn fariseonꞌ llabanreꞌ ka breꞌreꞌ kere bnaꞌa taꞌk Jesúsenꞌ zan ras, kanꞌ llon leakeꞌn ka nak gaweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naꞌll goll Xanllonꞌ leꞌe: —Reꞌ beꞌnn fariseo ake, ka beꞌnn llayib to koꞌllze tas yeꞌnnenꞌ llonre. Yichjraozrenꞌ nak yall, zan lo yichjraꞌlldaꞌorenꞌ llaꞌn da ke nxhia, llzeraꞌllre bi da de ke beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Beꞌnn ke llejnieꞌn nakre! ¿Kere Diosenꞌ beꞌnnenꞌ ben yichjraorenꞌ, lekze Leꞌen beneꞌ yichjraꞌlldaꞌorenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Leweꞌe lmoxh, legakrén beꞌnne, naꞌllenꞌ gakre yall doxhenre. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Nyaꞌchraz ke reꞌ beꞌnn fariseo! Lloeꞌre Diosenꞌ to raꞌt wej rao chi kwen ke yeolol da daꞌo bixhj, ke nak no yixh kwan da llaziꞌre lo reꞌj keré, da kaꞌ nziꞌi menta naꞌ rud, naꞌ llbej yichjrenꞌ gonre da nak lliarao, ka nak danꞌ llieꞌllo Diosenꞌ, naꞌ gonllo da wen. Da li da llayaꞌl weꞌre da ki, naꞌ bi wsanre yel nllieꞌ ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Nyaꞌchraz ke reꞌ, beꞌnn fariseo! Reꞌ ll-lanre siy nell kaꞌ niꞌt lo yodaꞌon, naꞌ do lao yaꞌa, llawere weꞌrao beꞌnn reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Nyaꞌchraz naken keré llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ reꞌ beꞌnn fariseo! ¡Nakre beꞌnn chop rao! Reꞌ nakre ka ba ke beꞌnn wat, da bi nlaꞌ; beꞌnn dá rawenꞌ, ni ke llakbeꞌe akzreꞌ akre nak loe. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naꞌll to beꞌnn kaꞌ llsedre ke leyenꞌ golleꞌ Jesúsenꞌ: —Maestro, rente netoꞌ llaꞌdyiꞌo neꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naꞌll lle Jesúsenꞌ leꞌe: —Leskaꞌ reꞌ llsedre ke leyenꞌ, nyaꞌchraz ke reꞌ, ka nak llroeꞌre leyenꞌ beꞌnn yobre, llonrenꞌ ka to yoaꞌ ziꞌ da bi llzoe akreꞌ, naꞌ reꞌ, ni ke lldaꞌbaꞌyzre la kanzeren. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Nyaꞌchraz ke reꞌ, ka nak llayonchaꞌore rao ba ke beꞌnn beꞌe xtiꞌll Diosenꞌ kanaꞌ, le xozxtaꞌore kaꞌn bet leakeꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kone kaꞌ llroeꞌre naksre xozxtaꞌore kaꞌ txhen, le leakeꞌn bet akeꞌ beꞌnn kaꞌ, naꞌ reꞌ llayonchaꞌore ba ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ke len naꞌ, rao yel siꞌn ke Diosenꞌ bneꞌe kaꞌn batnaꞌte: “Wseꞌlaꞌ beꞌnn chixjweꞌ xtiꞌllaꞌn, naꞌ beꞌnn nne lo razaꞌ, bal akeꞌ got akeꞌ, naꞌ ye baleꞌ koꞌ akeꞌ rill ya.” ");
INSERT INTO zpuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Reꞌ llonre kanꞌ bneꞌen, naꞌ reꞌ llaꞌa nnaꞌ yellayraore, ni ke xchen beꞌnn kaꞌ bet akeꞌn, kanꞌ bxhe yellrio llinte nnaꞌ lla. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Da bzoraozen kanꞌ bet beꞌnnenꞌ re Caín biꞌcheꞌn re Abel, bllinte kanꞌ gok ke Zacarías, beꞌnnenꞌ bet akeꞌ radj yodaꞌo za llinl-llo ganꞌ zo bkoyenꞌ, reꞌ llaꞌa nnaꞌ yellayraore ke yeolol beꞌnn ki gotenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Nyaꞌchraz ke reꞌ llsed llroeꞌ leyenꞌ! Reꞌ ll-lanre nnézere yel siꞌn ke Diosenꞌ, ni reꞌ bi nnézeren kwasro, naꞌ beꞌnn llazraꞌlleꞌ nnezreꞌn, bi lloeꞌre latj nnezreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ka bayoll beꞌe Jesúsenꞌ diꞌll ki, beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, bzorao ziꞌchiꞌll akeꞌ Leꞌe, naꞌ llbej akeꞌ Leꞌe diꞌll. ");
INSERT INTO zpuNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Naꞌ kaꞌ lliꞌnao akeꞌ bi diꞌllenꞌ lloj lloeꞌ, nench saꞌke gao akeꞌ xhia keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Naꞌ gok, beꞌnn zan kwis badop, naꞌ ka nak badop beꞌnn zan naꞌ, to llrejchekw niaꞌ lwellj akeꞌ, naꞌll Jesúsenꞌ golleꞌ zgaꞌtek beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Lewiayaꞌnn kanꞌ llon beꞌnn fariseo kaꞌ, llon akeꞌ ka kwa binn danꞌ llchixeꞌ yezj yet xtirenꞌ, nench llonen yet xtirenꞌ nbaraz. To koꞌllzen nlaꞌ akeꞌ beꞌnn wen, naꞌ llaꞌa da xhinnj lo raꞌlldaꞌo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Le bibi de da ngaꞌche da nello bi wroeꞌrawe, naꞌ bi de da nello nono yenneze len. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Naꞌllenꞌ biteze da nnere ga ngaꞌche, beꞌnn zan yene len, naꞌ diꞌll da weꞌre lo yoꞌ keré, leskaꞌ beꞌnn yell nneze len. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ni llniaꞌ reꞌ beꞌnn nllieꞌraꞌ, bi llebre chaꞌ beꞌnn got akeꞌ reꞌ, kwerp naꞌzenꞌ got akeꞌ chet kaꞌ, te naꞌ billbi gak gon akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ni llniaꞌ reꞌ, nonꞌ llayaꞌl llebre, lelleb Dios, Leꞌen kate ba bakeꞌe yel nban kerénꞌ, ye to chiꞌi waseꞌleꞌ reꞌ lo yiꞌ gabil, Leꞌen llayaꞌl llebre. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Lewiake byinn daꞌo kaꞌ, chop chonnze mell llaꞌollo tap gaꞌybaꞌ, le bi zaꞌkbaꞌ da xhen. Naꞌ Diosenꞌ ni tobaꞌ bi nsanraꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rente yich yichjre kaꞌ nrab Diosenꞌ. Naꞌllenꞌ niaꞌ bi llebre, zaꞌkll reꞌ kerke txhonnj byinn daꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ni llniaꞌ reꞌ, noteze beꞌnn chaꞌ wchebeꞌ nnaweꞌ nadaꞌ, leskaꞌ nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, wachebaꞌ nakeꞌ nadaꞌ txhen rao angl ke Dios llaꞌa yebá. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Naꞌ beꞌnnenꞌ bi wchebeꞌ nnaweꞌ nadaꞌ, leskaꞌ nadaꞌ bi wachebaꞌ nakeꞌ nadaꞌ txhen rao angl ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Noteze beꞌnne chaꞌ bi nne bi zille kiaꞌ nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, de yel llaziꞌxhen keꞌe; zan chaꞌ to beꞌnn nne ke Spíritu ke Diosenꞌ, kbat yeziꞌxhen Diosenꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Kate wcheꞌe akzeꞌ reꞌ rao beꞌnn kaꞌ llnebiaꞌ yodaꞌon, naꞌ rao koxchis, bi weꞌlaꞌllre akre ka gonre, naꞌ akre ka nnere, ");
INSERT INTO zpuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","wzerenkze Spíritu ke Diosenꞌ reꞌ, naꞌ wroeꞌren reꞌ kanꞌ gonre, naꞌ akre nnere. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Radj beꞌnn zan kaꞌ llaꞌa rao Jesúsenꞌ, blloj to beꞌnn golleꞌ Leꞌe: —Maestro, goll bi biꞌchaꞌn wlaꞌtoꞌ bien danꞌ bkwaꞌnn xaxhnaꞌtoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Naꞌ Jesúsenꞌ lleꞌe leꞌe: —¿No goll reꞌ, nadaꞌ llonaꞌ yel koxchis, naꞌ ll-laꞌ bi da de ke beꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naꞌll lleꞌe leakeꞌ: —Lewiá bi seraꞌllre bi gaꞌt keré, le kere kon ka da dérellonꞌ, kaꞌ gaꞌtte yel nban kellonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naꞌ beꞌreneꞌ leakeꞌ to diꞌll, bneꞌe: —Bzo to beꞌnn wniaꞌ, de yellrionꞌ ga gozeꞌ, naꞌ barapeꞌ da xhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Naꞌ beneꞌ xhbab bneꞌe: “¿Akxha gonaꞌ? Billbi latj de ga wllaꞌchaꞌwaꞌ danꞌ barapaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naꞌll bneꞌe da yobre: “To da gonaꞌ, yechinnjaꞌ yoꞌ ganꞌ nllaꞌchaꞌwaꞌ kiaꞌn, naꞌ gonaꞌn da xhenll, naꞌ wllaꞌchaꞌwaꞌ danꞌ barapaꞌn, naꞌ ren yeolol da de kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Naꞌllenꞌ yeyep kwinaꞌ: Lla nnaꞌ biꞌchaꞌ, bxhiꞌi banez, weꞌe bdao, bzo nbaraz, da xhen da yoꞌchaꞌo koꞌ rweꞌ de da gaoꞌ zan iz.” ");
INSERT INTO zpuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Naꞌ Diosenꞌ golleꞌ leꞌe: “Beꞌnn ke llejnieꞌ, nnaꞌ lleꞌ gatoꞌ, ¿no gao danꞌ nllaꞌchaꞌon?” ");
INSERT INTO zpuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Naꞌ kanꞌ naken ke beꞌnnenꞌ zeraꞌlleꞌ chraoze bi gaꞌt keꞌe yellrio ni, naꞌ bibi yel wniaꞌ keꞌe de rao Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Naꞌll goll Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen: —Llniaꞌ reꞌ, bi kwek yichjre chraoze da yeꞌj gaore chak nbanrenꞌ, leskaꞌ bi kwek yichjre chraoze xharaꞌnre. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Zaꞌkll yel nban kellonꞌ kerke danꞌ yeꞌj gaollonꞌ, naꞌ zaꞌkll kwerp kellonꞌ kerke raꞌll danꞌ llakllo naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lewiake bechj kaꞌ, ni ke llaz llarap akzbaꞌ, ni ke zoze daꞌ xhoaꞌ kebaꞌ, naꞌ Diosenꞌ llwaokzebaꞌ. Zaꞌkll reꞌ kerke bechj kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni to reꞌ bi gak yesdón kwinre ye tchit, chaꞌ kon kwek yichjzre gakre beꞌnn tonne. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naꞌ chaꞌ da daꞌo naꞌ, nakten da ke nxhia bi llak gonre, ¿bixchen choꞌzre billre da zed yobre? ");
INSERT INTO zpuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Lewiake yej tiꞌl kaꞌ, bibi llin llon aken, ni ke llabzen yere, naꞌ ni llniaꞌ reꞌ, ni gaz beꞌnnenꞌ golle Salomón, ren yel wniaꞌ xhen keꞌen, bi gok xharaꞌneꞌ nbaraz kanꞌ nak yej daꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chaꞌ kaꞌ llone Diosenꞌ yej daꞌo kaꞌ, nench llzon nbaraz, laꞌkze nnaꞌzenꞌ zon, wxe ba byechen, naꞌ cheyen, gontell Diosenꞌ ke reꞌ nench zore nbaraz chenak wxenraꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Reꞌ, bi choꞌre da zed, ni ke danꞌ yeꞌj gaore naꞌze, leskaꞌ bi gakllejlaꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Le beꞌnn ki llaꞌa yellrionꞌ, lezen naꞌ yoꞌ yichj akeꞌ, zan reꞌ, Xare beꞌnn zo yebá, ba nnézkzereꞌ kanꞌ yálljere da ki. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Llayaꞌl kweꞌ yichjre naꞌ wzenayre ke Diosenꞌ, nench nnebieꞌ yichjraꞌlldaꞌorenꞌ, naꞌ yeolol da kaꞌ yálljerenꞌ, Dios naꞌkze gonneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Bi llebre laꞌkze nak to chopzre, Xallo Diosenꞌ ba brejeꞌ reꞌ, nench nnebiaꞌ renre Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lewayoꞌte bi da de kere, leweꞌe beꞌnn chaꞌ bi yalljreꞌ, chaꞌ gonre kaꞌ, naꞌllenꞌ gaꞌt yel wniaꞌ xhen keré yebá da bi te ke, naꞌ da bi kwiayiꞌ. Gannaꞌ nono beꞌnn wan llraꞌ, nono badaꞌo llaꞌa wtebaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Le ganꞌ ngoꞌchaꞌore danꞌ llazraꞌllre naꞌn, gannaꞌn zokze yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Lesoteze xhnid ka beꞌnn llbexh sorao gon llin, ba nkaꞌchoch leꞌe, naꞌ danꞌ llseniꞌ keꞌen llaꞌltezen. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Llayaꞌl gonre ka beꞌnn wen llin, llaꞌa akeꞌ llbexh akeꞌ xan akeꞌn, zejeꞌ ga llak to wchaynaꞌa. Kate yellineꞌn, naꞌ nneꞌe, le ze akteꞌ xhnid wsarj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nbaraz ke beꞌnn wen llin kaꞌ, katenꞌ yellín xan akeꞌn, lljadiꞌreꞌ leakeꞌ llnnaꞌ akeꞌ yere; da li llniaꞌ reꞌ, kanaꞌll gonchieꞌ leakeꞌ, kwineꞌ wsinieꞌ da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nbaraz ke beꞌnn kaꞌ katenꞌ, laꞌkze llinte llere, naꞌ llinte bale, chaꞌa akeꞌ xhnid, llnnaꞌ akeꞌ yere. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Leskaꞌ, lewayón ke xhbab, chenak to xan yoꞌ, nnezreꞌ batkrenꞌ chej beꞌnn wan kaꞌ rilleꞌn, da li, ni ke taszeꞌ do yere, le kere weꞌe latj choꞌ beꞌnn wan kaꞌ rilleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Leskaꞌ reꞌ, lesó xhnid, le katenꞌ llonrenꞌ xhbab bi yedaꞌ, kanaꞌn yedaꞌ da yobre, nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Naꞌ Pedronꞌ lleꞌe Leꞌe: —Xantoꞌ, ¿danꞌ llsaꞌkrebroꞌ da ki naken ke netoꞌn o chaꞌ ke yeolol beꞌnnenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Naꞌll bne Jesúsenꞌ: —Naksen ke noteze beꞌnne, chaꞌ goneꞌ ka to beꞌnn wen llin beꞌnn llejnieꞌ; xaneꞌn, beneꞌ rallneꞌe yoꞌ keꞌen, naꞌ beneꞌ rallneꞌe beꞌnn wen llin kaꞌ yelaꞌ, naꞌ kweꞌe xhnneze bi llin da llak, naꞌ kate llin hor gao akeꞌ naꞌ, waweꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nbaraz ke beꞌnnenꞌ, chaꞌ kate yellín xaneꞌn, lljadiꞌreꞌ leꞌe lloneꞌ ka danꞌ bkwaꞌnneꞌ rallneꞌe goneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da li llniaꞌ, kanaꞌ goneꞌ rallneꞌe yeolol da de keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Zan chaꞌ beꞌnn wen llin naꞌ, nneꞌe lo yichjraꞌlldaꞌweꞌ: “Cheke wlleje xanaꞌn”, naꞌ sorao chineꞌ beꞌnn kaꞌ yelaꞌ, naꞌ yeꞌj gaoxeneꞌ, naꞌ sollreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bixha yellinkze xaneꞌ kat lla ke llwieꞌ yellineꞌ, kanaꞌ wzap xaneꞌn leꞌe, chintateꞌ leꞌe, naꞌ wseꞌleꞌ leꞌe ga yellayraweꞌ ga llaꞌa beꞌnn kaꞌ bi llzenay ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Naꞌ beꞌnn wen llin naꞌ, chaꞌ nnezreꞌ kwasro bi danꞌ llayaꞌl goneꞌ, naꞌ bi lloneꞌn, bi soeꞌ xhnid kate yellín xaneꞌn, naꞌ chintateꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Naꞌ beꞌnnenꞌ bi nnezreꞌ binꞌ nllia xaneꞌn biaꞌa goneꞌ, naꞌ gonkzeꞌ ke da llayaꞌl chineꞌ leꞌe, raꞌtze chineꞌ leꞌe, le bi nnezreꞌn. Le beꞌnnenꞌ beꞌe Diosenꞌ leꞌe da xhen, leskaꞌ da xhen wannabreꞌ leꞌe, naꞌ beꞌnnenꞌ bxenraꞌll Diosenꞌ leꞌe, beneꞌ rallneꞌe da xhen, leze da xhenll wannabreꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ka beꞌnn badxhen to yiꞌ da wzey da de rao yellrio ninꞌ badyenaꞌ, le lleꞌnkazraꞌ sorao gaꞌlnninnen. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","De to da war da gak kiaꞌ, naꞌ llakraꞌ kwis, llbexhaꞌ kate llin lla gak kiaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Llákere chaꞌ bedaꞌ nench beꞌnn kaꞌ llaꞌa yellrionꞌ gak akeꞌ tozeꞌn? Kaꞌa, choprenꞌ gak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Soraozen nnaꞌ, chaꞌ to lo yoꞌ nak gaꞌy akeꞌ, gak akeꞌ chopre, naꞌ chonneꞌ gakyollrene chopeꞌ, chopeꞌ gakyollrene chonneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Beꞌnn byionꞌ tilreneꞌ xhiꞌnneꞌ byionꞌ, naꞌ xhiꞌnneꞌ byionꞌ tilreneꞌ xeꞌen; noꞌrenꞌ tilreneꞌ xhiꞌnneꞌ noꞌrenꞌ, naꞌ xhiꞌnneꞌ noꞌrenꞌ tilreneꞌ xhneꞌen; noꞌrenꞌ tilreneꞌ xhorilleꞌ, naꞌ xhorilleꞌn tilreneꞌ tawxhiꞌnneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Naꞌll goll Jesúsenꞌ beꞌnn zan kaꞌ llaꞌn: —Kate llreꞌre ba ze bej ganꞌ llen willenꞌ, naꞌ nere: “Wak yejw.” Naꞌ llakte yej. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Naꞌ kate llénere dá beꞌ da zaꞌa lleꞌle, naꞌ nere: “Wak zeꞌye nnaꞌ.” Naꞌ llakte zeꞌye. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Beꞌnn chop rao ak! Llwiare yebánꞌ, naꞌ yellrionꞌ, naꞌ llakbeꞌre chaꞌ gak zay o chaꞌ gak zeꞌye, naꞌ bi llakbeꞌre binꞌ ba llak ganꞌ ba zore nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Bixchen ke llayonre xhbab, akre ka gonre da wen? ");
INSERT INTO zpuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kate beꞌnn lljataweꞌ xhia rao koxchis, llxoa akeꞌ doꞌl koꞌllre, lekoꞌ xhnneze ka za llinre rao koxchisenꞌ, laꞌkze ba yoꞌtere nez, leweꞌlaꞌll lekoꞌ xhnneze, le chaꞌ llinre rao koxchisenꞌ, naꞌ koxchisenꞌ goneꞌ reꞌ rao naꞌ xaꞌy kaꞌ, naꞌ koꞌ akeꞌ reꞌ lo rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ni llniaꞌ reꞌ, kere wabejeꞌ reꞌ chaꞌ bi chixhjre doxhen danꞌ llbaꞌyre. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Rao lla naꞌ, bal beꞌnn kaꞌ llaꞌa ganꞌ llroeꞌ Jesúsenꞌ, beꞌrén akeꞌ Leꞌe diꞌlle kanꞌ ben Pilatonꞌ, bseꞌleꞌ beꞌnn bet akeꞌ txhonnj beꞌnn Galilea kaꞌ, kanꞌ llaꞌa akeꞌ lo yodaꞌo llot akeꞌ bayiꞌx lloeꞌrao akeꞌ Dios, naꞌ bchixeꞌ xchen akeꞌn ren ke bayiꞌx kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —Llákere chaꞌ danꞌ gok ke beꞌnn kaꞌ kaꞌn, nak aklleꞌ beꞌnn wen da xhinnjll, kerke beꞌnn Galilea kaꞌ yelaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kere kaꞌn; ni llepaꞌ reꞌ, chaꞌ reꞌ bi wayátere ke da xhinnj kerénꞌ, wllin lla kwiayiꞌre kanꞌ gok ke beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Beꞌnn kaꞌ chiꞌn chonne (18), got akeꞌ bdekw akeꞌ to zeꞌe sibe ganꞌ nziꞌi Siloé, ¿leskaꞌ llákere nak aklleꞌ beꞌnn wen da xhinnjll, kerke beꞌnn kaꞌ yelaꞌ llaꞌa Jerusalén naꞌ, naꞌllenꞌ gok ke akeꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kere kaꞌn; ni llniaꞌ reꞌ, chaꞌ reꞌ bi wayátere ke da xhinnj kerénꞌ, wllin lla leskaꞌ kwiayiꞌre kanꞌ gok ke beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Naꞌll Jesúsenꞌ bsaꞌkrebreꞌ bneꞌe: —Bzo to beꞌnne, naꞌ lo reꞌj keꞌe ga nazeꞌ uvas, zo to yay higo; naꞌ jawieꞌ chaꞌ llian daxhix, naꞌ bibi llian. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Naꞌ golleꞌ beꞌnnenꞌ llap reꞌjenꞌ: “Ba gok chonn iz lladwiaꞌ yayenꞌ chaꞌ llian daxhix, naꞌ bikzbi llbian; wenkre bchoyen, ke da zozen nlanen yellrionꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naꞌ goll beꞌnnenꞌ leꞌe: “Xanaꞌ kwexhkello ye choll, la ye twiz rize; wcheꞌnnkeraꞌ xhane, naꞌ wllaꞌn beꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chaꞌ kwian daxhix, naꞌ wkwaꞌnnllon, naꞌ chaꞌ bi kwiakzen, naꞌll wchoyllon.” ");
INSERT INTO zpuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gok to lla, lla llap beꞌnn Israel kaꞌ baraꞌnne, byej Jesúsenꞌ lo yodaꞌon, naꞌ jazejnieꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Naꞌ lliꞌ to noꞌre lo yoꞌn; ba gok chiꞌn chonn (18) iz nleo koꞌlleꞌ, le byoꞌ to daxiꞌo kwerp keꞌen, naꞌ kere gokll wazeꞌe lilla. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ka breꞌe Jesúsenꞌ noꞌrenꞌ, goxheꞌ leꞌe, naꞌ lleꞌe leꞌe: —Noꞌre, nnaꞌ wayakoꞌ ke yillweꞌ koꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naꞌll bxoa taꞌk Jesúsenꞌ koꞌll noꞌrenꞌ, naꞌ le bazete noꞌrenꞌ lilla barí koꞌlleꞌn. Naꞌ bzorao lloeꞌraweꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Naꞌ beꞌnnenꞌ llnebiaꞌ yoꞌn, goklleꞌe kwis danꞌ bayón Jesúsenꞌ noꞌrenꞌ to rao lla llap akeꞌ baraꞌnne. Naꞌll beꞌnnenꞌ golleꞌ beꞌnn kaꞌ niꞌt lo yoꞌn: —Xop lla llayaꞌl gonllo llin; rao xop lla kaꞌ yedre, chaꞌ lleꞌnere wayakre, zan bi yedre lla llapllo baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Naꞌll Xanllonꞌ golleꞌ beꞌnnenꞌ: —¡Beꞌnn chop rao ake! Laꞌkze nak lla llapre baraꞌnne, dekz de llsellre bell keré, burr keré, lljaweꞌjrebaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naꞌ noꞌrenꞌ naktekeꞌ xhiꞌnn dialla ke xozxtaꞌollo, Abraham, ¿kere leskaꞌ llayaꞌl wayelle ke danꞌ nchej daxiꞌon leꞌe ba gok chiꞌn chonn iz? ");
INSERT INTO zpuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ka bayoll bne Jesúsenꞌ kaꞌ, le llakzbane beꞌnn kaꞌ llwie Leꞌen. Naꞌ beꞌnn kaꞌ yelaꞌ llayoꞌraꞌll akeꞌ kwis kanꞌ lloneꞌn, le naken da wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Naꞌ bne Jesúsenꞌ: —¿Akre ka wsaꞌkrebaꞌ kanꞌ llnebiaꞌ Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wsaꞌkrebaꞌn ka nbaz ke mostaz da goz beꞌnn lo reꞌj keꞌen, naꞌ ke braꞌn naꞌ, blliꞌon gokten to yay xhen, naꞌ byinn daꞌo kaꞌ jachia akbaꞌ rawen, ben xoꞌnn akbaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Naꞌll bne Jesúsenꞌ da yobre: —¿Akre ka wsaꞌkrebaꞌ kanꞌ llnebiaꞌ Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wsaꞌkrebaꞌn ka kwa binn da bxhiꞌi to noꞌre, naꞌ bchixeꞌn trob yezj, naꞌ baslliꞌon kwa ke yet xtir naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesúsenꞌ bzejnieꞌreꞌ beꞌnne toto yell ganꞌ bdieꞌn, ka nak zejeꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","To beꞌnn golleꞌ Leꞌe: —Xantoꞌ, ¿to chopze beꞌnn kaꞌ yeránꞌ? Naꞌll golleꞌ beꞌnnenꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Leweꞌlaꞌll, lechoꞌo gan zo reyj yoꞌ danꞌ nchoꞌpen, le llniaꞌ reꞌ, beꞌnn zan yeꞌn akreꞌ choꞌ akeꞌ, naꞌ bi saꞌk akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Naꞌ gonen kate te naꞌ, xan yoꞌn wsejeꞌ reyj yoꞌn, naꞌ sorao gosiaꞌre leꞌ reyj yoꞌn, nnere: “Xantoꞌ, bsarj choꞌtoꞌ.” Naꞌll yeꞌe reꞌ: “Bi nombiaꞌ reꞌ, bi nnezraꞌ ga beꞌnne reꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Naꞌll sorao nnere: “Weꞌe bdaorentetoꞌ rweꞌ, naꞌ bdateꞌo broeꞌroꞌ xtiꞌlloꞌn do lao yaꞌa ralltoꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Naꞌ da yobre yeꞌe reꞌ: “¿Kere ba bnetiaꞌ, bi nnezraꞌ ga zaꞌre? Lewayej kaꞌle, reꞌ beꞌnn wen da xhinnj.” ");
INSERT INTO zpuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kanaꞌ kwellyaꞌchre, gaoxoxj layre kate reꞌre Abraham naꞌ, naꞌ Isaac, naꞌ Jacob, naꞌ yeolol beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, llaꞌa akeꞌ ganꞌ llnebiaꞌ Diosenꞌ yebánꞌ; naꞌ reꞌ bi renre. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Beꞌnn zan beꞌnn zaꞌk doxhen yellrio, yellín akeꞌ yebá ganꞌ llnebiaꞌ Diosenꞌ, naꞌ kweꞌrén akeꞌ Leꞌe lloaꞌ mes keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Naꞌ ganni niaꞌ reꞌ, beꞌnn zan nak akeꞌ ka beꞌnn lliarao nnaꞌ, wllin lla kat yeyak akeꞌ ka beꞌnn zaꞌa xhante, naꞌ beꞌnn kaꞌ nak akeꞌ ka beꞌnn zaꞌa xhante nnaꞌ, leakeꞌn yeyak akeꞌ ka beꞌnn lliarao. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naꞌ llak rao lla naꞌ, bllin bal beꞌnn fariseo kaꞌ raweꞌn, lle akeꞌ Leꞌe: —Baxhonnj, bayej do ga yobre, le Herodes naꞌ, lleꞌnreꞌ goteꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naꞌ lleꞌe leakeꞌ: —Lelljayell beꞌzenꞌ: “Ye chop chonn llazenꞌ nna dakzaꞌ llabejaꞌ daxiꞌo yoꞌ yichjraꞌlldaꞌo beꞌnne, naꞌ llayonaꞌ beꞌnn llak yillweꞌ, naꞌtell wayoll xchinaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dekz de wasyollkzaꞌ gonaꞌ danꞌ llonaꞌn nnaꞌ, wxe, willj la llintekzaꞌ Jerusalén naꞌ, le chaꞌ to beꞌnn lloeꞌ xtiꞌll Diosenꞌ gateꞌ, Jerusalén naꞌkze llayaꞌl gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Reꞌ beꞌnn Jerusalén, llotre beꞌnn kaꞌ ba bseꞌl Diosenꞌ lladzejnieꞌre reꞌ xtiꞌlleꞌn, naꞌ ba bchekwre leakeꞌ yej. Da zan ras gokraꞌllaꞌ yetopaꞌ reꞌ, ka llon to bellj ba ncheꞌe xhiꞌnne, llatobbaꞌ leakbaꞌ lo xirbaꞌn, naꞌ bi gokraꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Naꞌ nnaꞌ tach rillrenꞌ, gaꞌnnen ka ga nono llraꞌkze. Ni llniaꞌ reꞌ, bill reꞌkzere nadaꞌ llinte lla nnere: “Nbaraz ba zaꞌa beꞌnnenꞌ nseꞌl Xanllo Diosenꞌ ganni nnebieꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gok to lla llap beꞌnn Israel kaꞌ baraꞌnne, Jesúsenꞌ byejeꞌ rill to beꞌnn fariseo beꞌnn llnebiaꞌ, naꞌ jataweꞌ, naꞌ bal beꞌnn fariseo kaꞌ bdop rill beꞌnnenꞌ, lliꞌnao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naꞌ rawe naꞌ, lliꞌ to beꞌnn yoeꞌ yi. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Naꞌ goll Jesúsenꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ beꞌnn fariseo kaꞌ: —¿Bi ne leyenꞌ? ¿De latj wayonllo beꞌnn lla nbaꞌnne o chaꞌ bi de latj? ");
INSERT INTO zpuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Naꞌ ni to akeꞌ bi balliꞌi xtiꞌlleꞌn. Naꞌll Jesúsenꞌ beꞌxeꞌ taꞌk beꞌnnenꞌ, naꞌ bayoneꞌ leꞌe, naꞌll lleꞌe leꞌe: —Bayej nnaꞌ, ba bayakoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Naꞌll lle Jesúsenꞌ beꞌnn kaꞌ llaꞌa rill beꞌnn fariseonꞌ: —Nekxha reꞌ, chaꞌ to burr keré o chaꞌ bell keré lljabixbaꞌ to lo yelle, ¿kere sete lljarejrebaꞌ, laꞌkze nak lla nbaꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Naꞌ billkze bi llallel akreꞌ ka ye akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chak lliꞌ Jesúsenꞌ rill beꞌnn fariseonꞌ, llwieꞌ kanꞌ llon bal beꞌnn kaꞌ, ll-lan akeꞌ lljacheꞌ akeꞌ raote ga ba nak kweꞌ beꞌnn brao, naꞌll beꞌreneꞌ leakeꞌ to diꞌll, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Kate gon akeꞌ reꞌ yexh chejre ga llak yel wchaynaꞌa, bi lljacheꞌre raote ga lljacheꞌ beꞌnn brao, ke gonzen llin beꞌnnenꞌ nak beꞌnn braoll. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Naꞌll xan lnni yeꞌe reꞌ: “Leyezollaꞌa, leweꞌe latj kweꞌ beꞌnn ni.” Naꞌ yesolleꞌe reꞌ, lljalekwteꞌ reꞌ xhante, naꞌ siꞌre zdoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Zan kate gon akeꞌ reꞌ yexh, wenre lelljacheꞌ xhante, naꞌ kate reꞌe xan lnninꞌ reꞌ, naꞌllenꞌ chaꞌ yeꞌe reꞌ: “Da nile blleꞌ.” Naꞌ lljalekweꞌ reꞌ raote, naꞌllenꞌ siꞌre yel baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Le beꞌnnenꞌ chaꞌ lleꞌnreꞌ gakeꞌ beꞌnn brao, yezikre wayexjeꞌ yegaꞌnnteꞌ xhane, naꞌ beꞌnnenꞌ llakreꞌ bi zaꞌke, leꞌen gak beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Naꞌ golleꞌ beꞌnnenꞌ ben Leꞌe yexhenꞌ: —Kate gonoꞌ wao, bi gonoꞌ yexh toze beꞌnn nllieꞌroꞌ, no biꞌch lwelljoꞌ, no beꞌnn wrill koꞌo beꞌnn nak beꞌnn wniaꞌ, le leskaꞌ wayón akeꞌ rweꞌ yexhe, naꞌ kaꞌ wayoꞌteꞌ wzon koꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Zan kate gonoꞌ wao, goxh beꞌnn yaꞌche, beꞌnn nxhinnj niaꞌnaꞌa, naꞌ beꞌnn lchole. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Naꞌ kaꞌ soꞌo nbaraz, le leakeꞌn bi gak wayón akeꞌ rweꞌ yexhe. Naꞌ kate llin lla wasbán Diosenꞌ beꞌnn wat, kanaꞌ gon Diosenꞌ wen koꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","To beꞌnn lliꞌrén Jesúsenꞌ txhen ganꞌ llao akeꞌn, ka benreꞌ xtiꞌlleꞌn, bneꞌe: —Nbaraz ke beꞌnnenꞌ kwieꞌ gaoreneꞌ Diosenꞌ txhen, katenꞌ ba llnebieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Naꞌ goll Jesúsenꞌ leꞌe: —Bzo to beꞌnne, beneꞌ to wao xhen, naꞌ beꞌnn zan beneꞌ yexhe. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ka bllin lla gao akeꞌn, bseꞌl xan waonꞌ to beꞌnn wen llin keꞌen, lljatixjweꞌreꞌ beꞌnn kaꞌ beneꞌ yexhenꞌ, naꞌ lleꞌe leakeꞌ: “Ledá nnaꞌ, ba bsiniaꞌte danꞌ gaollonꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Naꞌ beꞌnn kaꞌ, dete da lldeꞌ akreꞌ nechkze bi lljakeꞌ waonꞌ. Toeꞌ bneꞌe: “Za bxhiaꞌ to yellrio, naꞌ len chaꞌa lljawiaꞌ. Yeꞌo xanoꞌn bi gak yedaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Naꞌ ye toeꞌ bneꞌe: “Bxhiꞌzaꞌ gaꞌy kweꞌ belle, naꞌ za lljawiachkaꞌ akre llon akbaꞌ. Yechgoꞌ xanoꞌn, siꞌxheneꞌ bi gak yedaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Naꞌ ye toeꞌ bneꞌe: “Za bchaynaꞌ, naꞌ bi gak yedaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Beꞌnn wen llin naꞌ, zayejeꞌ jayelleꞌ xaneꞌn kanꞌ bne beꞌnn kaꞌ, naꞌ gokllaꞌa xan yoꞌn kwis, naꞌll golleꞌ beꞌnn wen llin keꞌen: “Byej do lao yaꞌa, jatateze do lyell, jaxiꞌi beꞌnn yaꞌch, beꞌnn xhinnj, beꞌnn lchole.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bayoll beneꞌ kaꞌ, naꞌll golleꞌ xaneꞌn: “Xanaꞌ, ba benaꞌ kanꞌ bneꞌon, naꞌ nna dellkze latj.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Naꞌll beꞌnnenꞌ golleꞌ leꞌe: “Byejkze da yobre kon ga xhoa nez, naꞌ jaxiꞌi yezikre beꞌnne, ben bien choꞌ akeꞌ, le lleꞌnraꞌ yellaꞌte yoꞌ kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Le ni to beꞌnn kaꞌ benaꞌ yexh da nellenꞌ, bill gak gao akeꞌ danꞌ bsiniaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Beꞌnn zan kwis nao Jesúsenꞌ, naꞌll bayechjeꞌ lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Chaꞌ reꞌ nllieꞌllre xare, xhnaꞌre, noꞌr keré, xhiꞌnnre, biꞌchre, zanre, naꞌ nllieꞌllre kwinre kerke nadaꞌ, bi gak gonre nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Naꞌ beꞌnnenꞌ bi lloneꞌ ka to beꞌnn noaꞌ cruz keꞌe, naꞌ nnaweꞌ nadaꞌ, bi gak goneꞌ nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chaꞌ notezre lleꞌnere gonre to yoꞌ, ¿kere zgaꞌtek kwejbiaꞌre ka to gaxt gonen, naꞌllenꞌ gonren? ");
INSERT INTO zpuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ke gonrizen kon wxere rane naꞌze, naꞌ bi soere yesyollren; naꞌ reꞌe beꞌnne, naꞌ wtitj akreꞌ reꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ne akeꞌ: “Kon bxe beꞌnnenꞌ yoꞌ keꞌen; kere bzoereꞌ yesyolleꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chaꞌ to rey llwieꞌ chejeꞌ rao wdil, zgaꞌtek wyi wsaꞌkeꞌ chaꞌ gak soyibeꞌ; leꞌen napeꞌ chi mir wakaꞌa ya, naꞌ beꞌnnenꞌ tilreneꞌn napeꞌ galj mireꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Naꞌ chaꞌ llwieꞌ bi soereꞌ, ka nna zaꞌte beꞌnnenꞌ tilreneꞌn ziꞌte, wseꞌleꞌ to beꞌnn lljadieꞌ xtiꞌlleꞌn, naꞌ wnnabeꞌ yeniꞌt akeꞌ wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kaꞌn naken, chaꞌ reꞌ bi kwej yichjre yeolol da de keré, bi gak gonre nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Naꞌll bne Jesúsenꞌ da yobre: —Da wen kwis zeꞌdenꞌ, zan chaꞌ wnit yel zich keꞌen, bikzbi de gónellon nench yeyaken zich da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kate bill naken zichenꞌ, bill gak gonen llin, ni ke gakze gakrenen yellrionꞌ gaken beꞌn, naꞌll lljachoꞌnnllon yeo. Reꞌ zo nayre yénere lewzenay. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Naꞌ bdop no beꞌnn wachixhj, naꞌ yezikre no beꞌnn wen da xhinnj rao Jesúsenꞌ, naꞌ llzenay akeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Naꞌ beꞌnn fariseo kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, ka breꞌe akreꞌ kaꞌ, naꞌll bne akeꞌ: —Beꞌnnenꞌ llontezeꞌ beꞌnn wen da xhinnj kaꞌ txhen, naꞌ llaorenteꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naꞌll Jesúsenꞌ beꞌe to diꞌll, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Chaꞌ reꞌ niꞌt to gayoa (100) xhiꞌr keré, naꞌ nnit tobaꞌ, ¿kere kwaꞌnnre ba tapralj twalj kaꞌ (99) lo reꞌj ke akbaꞌn, naꞌ chejre lljadirjre ba tiꞌchenꞌ kon ka wallélerebaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kate yellélerebaꞌn, yewere kwis waxoadorebaꞌ xhichjre. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ka yellinre rillrenꞌ, yetopre beꞌnn wrill keré, ye akreꞌ: “Leyewé ren nadaꞌ, le ba ballélteraꞌ xhiꞌr kiaꞌn bnitenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ni niaꞌ reꞌ, leskaꞌ llawelle Diosenꞌ, naꞌ angl kaꞌ llaꞌa yebánꞌ, kate to beꞌnn wen da xhinnj llayatreꞌ ke da xhinnj ba beneꞌ, naꞌ llanaweꞌ Diosenꞌ, kerke tapralj twalj beꞌnn wen, beꞌnn bibi doꞌl ke akeꞌ de da wayat akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Naꞌ chaꞌ to noꞌr de chi mell plat keꞌe, naꞌ nnit ton, ¿kere naꞌ waꞌleꞌ to yiꞌ, naꞌ wloeꞌ kwasro lo yoꞌ keꞌen to walléltereꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kate yellelen naꞌ, yetopeꞌ noꞌre nakeꞌ txhen, naꞌ no beꞌnn wrill keꞌe, naꞌ yeꞌe leakeꞌ: “Leyewé ren nadaꞌ, ba ballélteraꞌ mell kiaꞌn bnitenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ni niaꞌ reꞌ, leskaꞌ llawé angl ke Diosenꞌ kate to beꞌnn wen da xhinnj, llayatreꞌ bi da xhinnj beneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Leskaꞌ bne Jesúsenꞌ: —Bzo to beꞌnn, naꞌ bzo chop xhiꞌnneꞌ byio. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naꞌ binꞌ naꞌchenꞌ gollbeꞌ xabeꞌn: “Xa, benntega nadaꞌ danꞌ llayaꞌlaꞌ siaꞌn.” Naꞌll xa akbeꞌn bleꞌe da de keꞌe beꞌen leakbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ker gok scha kate binꞌ naꞌchenꞌ, batopbeꞌ yeolol da nake kebeꞌ, naꞌll broꞌbeꞌ nez byejbeꞌ to yell ziꞌte. Naꞌ benditjebeꞌ xhmellbeꞌn, benbeꞌ da ke nxhia. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bixha kate bllin lla bayá xhmellbeꞌn, naꞌ le gokte to win xhen doxhen do ganꞌ zobeꞌn. Naꞌ billbi mell kebeꞌ de, siꞌbeꞌ da gaobeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naꞌ bdirjbeꞌ llin gonbeꞌ, naꞌ bllinbeꞌ ga zo to beꞌnn beꞌe xchinbeꞌ, naꞌ bseꞌlebeꞌ lyiꞌxe ga llaꞌa kuch zan keꞌe, naꞌ benbeꞌ gop kuch. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naꞌ llebraz donbeꞌ, to lleꞌnebeꞌ gaobeꞌ danꞌ llao kuch kaꞌ, ni len nono lloeꞌ lebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kate jadinraꞌllbeꞌ naꞌ bnebeꞌ: “Beꞌnn zan beꞌnn wen llin ke xaꞌ zjallaꞌa, deteze de da llao akeꞌ, naꞌ nadaꞌ lliꞌchkaꞌ ganni donaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","To da gonaꞌ nnaꞌ, wayaꞌllaꞌ ganꞌ zo xaꞌn, naꞌ yepeꞌ: Xa, ba benaꞌ da xhinnj rao Dios, naꞌ rao rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bill zaꞌkaꞌ nench naꞌ nneꞌo nakaꞌ ka xhiꞌnnoꞌ, ben nadaꞌ ka to beꞌnn wen llin koꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naꞌ netebeꞌ kaꞌn, bazollaꞌbeꞌ bagoꞌbeꞌ nez, zayejbeꞌ ganꞌ zo xabeꞌn. ’Ka za yellinterbeꞌ, breꞌe xabeꞌn lebeꞌ, naꞌ bayaꞌchraꞌllebeꞌ, naꞌ bzollaꞌdoeꞌ jatileꞌ xhiꞌnneꞌn bdeꞌlchochjebeꞌ, naꞌ bnoꞌpebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naꞌll gollbeꞌ xabeꞌn: “Xa, ba benaꞌ da xhinnj rao Dios, naꞌ rao rweꞌ, bill zaꞌkaꞌ gonlloꞌ nadaꞌ ka xhiꞌnnoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Naꞌ xabeꞌn le gollteꞌ beꞌnn wen llin keꞌe kaꞌ: “Lekwej chkweꞌ raꞌll chaꞌo lewakbeꞌ, lekoꞌ to da chaꞌo xhbenbeꞌ, naꞌ lewdé chkweꞌ xherbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naꞌ lelljaxhiꞌi to bell banꞌ zerao llaꞌraꞌll, naꞌ legotbaꞌ gaollobaꞌ, gonllo lnni. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Le xhiꞌnnaꞌn llakraꞌ chaꞌ ba gotbeꞌn, zan nbanbeꞌ; llakraꞌ chaꞌ ba bnitbeꞌn, naꞌ ba ballerbeꞌ.” Naꞌ bzorao llon akeꞌ lnni. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Xhiꞌnneꞌ bi wakenꞌ, datebeꞌ lyiꞌxe ke naken llak kaꞌ, naꞌ ka zazaꞌbeꞌ lyiꞌxenꞌ, ka le yellintebeꞌ yoꞌ naꞌn, bénebeꞌ llak llakia, llak wakwell, naꞌ llak wayaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naꞌ goxhbeꞌ to beꞌnn wen llin kaꞌ, naꞌ bnnabbeꞌ bixchen llak lnni. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Naꞌ beꞌnnenꞌ lleꞌebeꞌ: “Bi biꞌchoꞌn baraꞌ, naꞌ xaꞌon ba beteꞌ to bell ba zerao llaꞌraꞌll, danꞌ baraꞌbeꞌ wen naꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Naꞌ gokllaꞌbeꞌ kwis, naꞌ bi gokraꞌllbeꞌ wayoꞌbeꞌ yoꞌ, naꞌ blloj xabeꞌn, goꞌtyoerebeꞌ wayoꞌbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naꞌ bi ni gollbeꞌ xabeꞌn: “Ba gok scha zorenaꞌ rweꞌ, llonaꞌ xchinoꞌn, naꞌ llzenayaꞌ koꞌo, naꞌ ni to gaz to chiv daꞌo bi nna gonnoꞌ nadaꞌ, nench gonaꞌ lnni gaorenaꞌ beꞌnn kaꞌ nakaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naꞌ kate baraꞌ xhiꞌnnoꞌn binꞌ benditja da de koꞌo, naꞌ bdarenbeꞌ noꞌr wen da xhinnj ak, betteꞌo to bell ba llaꞌraꞌll kebeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Naꞌll lle xabeꞌn lebeꞌ: “Xhiꞌnnaꞌ, zorenkzoꞌ rweꞌ nadaꞌ, yeolol da de kiaꞌ koꞌkzoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Zan llayaꞌl yewello ke bibiꞌchoꞌn, le za baraꞌbeꞌn, gokraꞌ chaꞌ ba gotbeꞌn, zan nbanbeꞌ, llakraꞌ chaꞌ ba bnitkzbeꞌn, naꞌ nnaꞌ ba ballerbeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Naꞌll leskaꞌ goll Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen: —Bzo to beꞌnn wniaꞌ, naꞌ bzo to beꞌnn wen llin keꞌe, beꞌnn nak rallneꞌe yeolol da de keꞌe; bllin lla kate jatao akeꞌ xhia rao beꞌnn wniaꞌn, goll akeꞌ leꞌe, beꞌnn wen llin keꞌen le ll-lleyieꞌ da kaꞌ nak rallneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naꞌ beꞌnn wniaꞌn goxheꞌ beꞌnnenꞌ, naꞌ lleꞌe leꞌe: “Ba benraꞌ doxhen kanꞌ llonoꞌn. Llayaꞌl wiaꞌ bixhanꞌ llonkzoꞌ, zerao nnaꞌ gonnaꞌ xchinoꞌ chet kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Naꞌll beꞌnnenꞌ bayoneꞌ xhbab, naꞌ bneꞌe: “¿Akxha gonaꞌ nnaꞌ, ba bne xanaꞌn bill gonneꞌ xchinaꞌ? Naꞌ kere llak gonaꞌ llin war, naꞌ llayeꞌraꞌ wnnabaꞌ lmoxh. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ba nnezraꞌ to da gonaꞌ nench kate xanaꞌn bill gonneꞌ xchinaꞌn, ba zjallaꞌa beꞌnn wreb akeꞌ nadaꞌ rill akeꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naꞌ goxheꞌ toto beꞌnn kaꞌ llbaꞌy xhmell xaneꞌn, naꞌll lleꞌe beꞌnn nellenꞌ bllin naꞌ: “¿Arke llbaꞌyoꞌ ke xanaꞌn?” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naꞌ bne beꞌnnenꞌ: “To gayoa (100) yeꞌs ceitenꞌ llbaꞌyaꞌ.” Naꞌll bne beꞌnn wen llin naꞌ, nak rallnaꞌa da kaꞌ: “Blleꞌkeroꞌ, naꞌ de yich koꞌon, bzoj da yobre ke chiyonzen naꞌ (50), llbaꞌyoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Naꞌll lleꞌe beꞌnn wllope: “¿Bixha rweꞌ, arkenꞌ llbaꞌyoꞌ ke xanaꞌn?” Naꞌ bne beꞌnnenꞌ: “To gayoa (100) rrob trigonꞌ llbaꞌyaꞌ.” Le bnete beꞌnnenꞌ nak rallnaꞌa da kaꞌ: “Naꞌ de yich koꞌon, bzoj ganni tapraljzen naꞌ (80), llbaꞌyoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Naꞌ beꞌnn wniaꞌn, ka gokbeꞌreꞌ kanꞌ ben beꞌnn wen llin keꞌen, llabanreꞌ kwis katek llejnieꞌreꞌ, laꞌkze nake to beꞌnn wen llin ke nxhia, lleꞌe xhbab beneꞌ kaꞌ. Naꞌll bne Jesúsenꞌ: —Naꞌ kaꞌ, beꞌnn kaꞌ lloꞌraꞌll danꞌ de rao yellrio nize, llayirjlaꞌll aklleꞌ, akre ka gon akeꞌ gan beꞌnne, kerke beꞌnn kaꞌ ba dá rao beniꞌ ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Naꞌ llniaꞌ reꞌ, legonrenteze llin mell danꞌ de rao yellrionꞌ, nench gakrenre beꞌnne, naꞌ kate llin lla bill gon mellenꞌ llin, ba nllaꞌre beꞌnn wreb akeꞌ reꞌ yebá ga sore ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Beꞌnnenꞌ lloneꞌ da lixhej kone da daꞌo raꞌt da de keꞌe, naꞌ llroeꞌn kaꞌkze goneꞌ chaꞌ de da xhen keꞌe. Naꞌ beꞌnnenꞌ bi goneꞌ da lixhej kon ren da daꞌo raꞌten, kaꞌkze goneꞌ chaꞌ gaꞌt da xhen keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Naꞌ chaꞌ reꞌ, bi gonre da nak lixhej kon ren da de kere rao yellrionꞌ da te chelteze, ¿akxha gon Diosenꞌ rallnaꞌre da zaꞌkll da bi te ke? ");
INSERT INTO zpuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Naꞌ chaꞌ ke nollre beꞌnn yobre, bi gaprenꞌ baraꞌnn, ¿akxha wxenraꞌll no beꞌnne gonneꞌ reꞌ da nak keré? ");
INSERT INTO zpuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nono gak gon llin ren chopre xaneꞌ to chiꞌze, le chaꞌ kaꞌ goneꞌ, wiereꞌ to xan llin naꞌ, naꞌ llieꞌreꞌ beꞌnnenꞌ ye to; naꞌ goneꞌ llin ke toeꞌ do yichj do raꞌlleꞌ, naꞌ ke beꞌnnenꞌ ye to, goneꞌn kaꞌze raꞌlleꞌ. Kaꞌkze ke reꞌ bi gak gonre xchin Diosenꞌ, naꞌ waráltere gonre llin seraꞌllre gakre beꞌnn wniaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Beꞌnn fariseo kaꞌ, nak akeꞌ beꞌnn llzeraꞌll mell, ka ben akreꞌ kanꞌ bne Jesúsenꞌ, bzorao lltitj akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Naꞌll goll Jesúsenꞌ leakeꞌ: —To wrazrenꞌ llonxhen kwinre, naꞌ llonre ka beꞌnn wen tegar nechkze reꞌe beꞌnne, zan Dios nnezreꞌ kwasro ka nak yichjraꞌlldaꞌorenꞌ. Le de da llake beꞌnne, naken da wen, zan rao Diosenꞌ naken da zban. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ley danꞌ bzoj da Moisésenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, benen llin zerao ka braꞌ Juan beꞌnnenꞌ bchoa nis. Bzoraozen kanꞌ braꞌ Juan naꞌ, ba llnneze beꞌnne kanꞌ nak yel llnebiaꞌ ke Diosenꞌ, naꞌ beꞌnn zan llon akeꞌn ga zerao zaꞌk akreꞌ, nench nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ka nak yellrionꞌ, naꞌ da kaꞌ llia leꞌ yebánꞌ, wllin lla kwiayiꞌ aken, zan ke nak doxhen kanꞌ ne ley ke Diosenꞌ, dekz de gak kanꞌ nen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Noteze beꞌnn chaꞌ wsanraꞌll xhoꞌreꞌ, naꞌ sieꞌ ye to noꞌr yobre, llonkzeꞌ ka beꞌnn zo xto. Naꞌ noteze beꞌnn yechaynaꞌreneꞌ to noꞌre beꞌnn bsan xhyiweꞌn leꞌe, rebze llonkzeꞌ ka llon beꞌnnenꞌ darén xhoꞌr beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Bzo to beꞌnn wniaꞌ zre raꞌll chaꞌo llakeꞌ, naꞌ yeo lla llontekzeꞌ ka to lnnire danꞌ llaochaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naꞌ leskaꞌ bzo to beꞌnn yaꞌch re Lázaro, naꞌ blleꞌtezeꞌ bllieꞌ lloaꞌ yoꞌ ke beꞌnn wniaꞌn, naꞌ le llieꞌ yeꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","To lleꞌne Lázaronꞌ lljatopeꞌ blaꞌa kaꞌ, llexj ganꞌ lliꞌ beꞌnn wniaꞌn llaweꞌ, naꞌ beꞌkw ake lljaleꞌ akbaꞌ weꞌe keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bixha kate got beꞌnn yaꞌchenꞌ, naꞌ angl kaꞌ bacheꞌe akeꞌ leꞌe ganꞌ nak to latj wen ganꞌ zo Abraham naꞌ. Naꞌ leskaꞌ got beꞌnn wniaꞌn, naꞌ bkwaꞌch akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lo gabil ganꞌ ballín beꞌnn wniaꞌn llallayraweꞌ, kate blis raweꞌn, naꞌ breꞌreꞌ Abraham naꞌ, ren Lázaronꞌ, llaꞌa akeꞌ to latj naꞌ naken ziꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Naꞌll besiaꞌ beꞌnn wniaꞌn zillj bneꞌe: “Xa Abraham, bayaꞌchraꞌll nadaꞌ, bseꞌl Lázaronꞌ wasbis xhbeneꞌn, naꞌ wakoleꞌ raꞌt rollaꞌn, le llallayrawaꞌ lo yiꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Naꞌll Abraham naꞌ, golleꞌ leꞌe: “Xhiꞌnnaꞌ, jadinraꞌlle, bxhiꞌo rweꞌ banez bzoꞌo yellrionꞌ, naꞌ Lázaronꞌ ballayraweꞌ bxhaꞌkzieꞌ, naꞌ nnaꞌ llazieꞌ banez, naꞌ rweꞌ llallayraoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naꞌ leskaꞌ to bdinnj xhen, nlaꞌn lliꞌo, naꞌ ni ke gakze yedtoꞌ ganꞌ llaꞌrenꞌ, ni reꞌ bi gak yedre ganꞌ llaꞌtoꞌ ni.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Naꞌll bne beꞌnnenꞌ: “Ben gokre chaꞌ, xa Abraham, baseꞌleꞌ rill xaꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Le nna zo gaꞌy beꞌnn biꞌchaꞌ, naꞌ chixjweꞌreꞌ leakeꞌ nench ke wayed akeꞌ ganni yellayrao akeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Naꞌll lle Abraham naꞌ leꞌe: “Naꞌ dekze yich danꞌ bzoj da Moisésenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, len wzenay akeꞌ ke chet kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Naꞌll bne beꞌnnenꞌ: “Bi wzenay akeꞌ kaꞌ, xa Abraham, zan chaꞌ to beꞌnn yebaneꞌ radj beꞌnn wat kaꞌ, naꞌ weꞌreneꞌ leakeꞌ diꞌlle, naꞌll chejleꞌ akeꞌ, naꞌ wayechj akeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naꞌll goll Abraham naꞌ leꞌe: “Chaꞌ bi chejleꞌ akeꞌ xtiꞌll Dios danꞌ ba dekze, leskaꞌ ni ke chejleꞌ akzeꞌ, laꞌkze yebán to beꞌnn wat.” ");
INSERT INTO zpuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Naꞌll lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen: —Dekz de chaz da xhinnjenꞌ radjrenꞌ, zan nyaꞌchraz ke beꞌnnenꞌ wchizeꞌ da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nakteren wen wchej akeꞌ yeneꞌn to yej xhen, naꞌ wzaꞌl akeꞌ leꞌe lo nisdaꞌo, kerke da goneꞌ bix to bidaꞌo ki nxenraꞌll nadaꞌ gonbeꞌ da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Lewiá, chaꞌ to beꞌnn lwelljoꞌ, bi gonzreꞌ rweꞌ, byej beꞌreneꞌ diꞌll nench wayakbeꞌreꞌ binꞌ beneꞌ, naꞌ chaꞌ wayatreꞌ, baziꞌxhen keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Naꞌ chaꞌ gall ras goneꞌ bi da goneꞌ koꞌo rao tlla, naꞌ gall ras zaꞌteꞌ yeꞌe rweꞌ: “Llayatraꞌ kanꞌ benaꞌn, baziꞌxhen kiaꞌ”, llayaꞌl yeziꞌxhenoꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naꞌll postl kaꞌ, goll akeꞌ Xanllonꞌ: —Gokrén netoꞌ nench yezikre wxenraꞌlltoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naꞌ lle Xanllonꞌ leakeꞌ: —Chenak danꞌ llejleꞌre naken ka to nak nbaz ke mostaz, gakte yere yayenꞌ zo ganni: “Bkwas ganni, naꞌ jasó lo nisdaꞌo naꞌle,” wzenayten keré. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Leskaꞌ bne Jesúsenꞌ: —Reꞌ yoꞌraore llonre, kate beꞌnn wen llin keré llejeꞌ wawaꞌnn belle o chaꞌ gop belle, kate llareꞌe yoꞌ kerénꞌ, kere naꞌ llereꞌ: “Blleꞌdo gaoꞌ xcheꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yezikre llereꞌ: “Bsiniaꞌkeroꞌ da gawaꞌ; yedawaꞌ naꞌ, naꞌll gaoꞌ rweꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Leskaꞌ kere llereꞌ: “Llioxkenoꞌ”, kate ba bayoll bsinieꞌ danꞌ bdaorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Leskaꞌ naken ke reꞌ, naore nadaꞌ, kate ba benre doxhen kanꞌ ba bniaꞌ gonre, kanaꞌ nnere: “Beꞌnn wen llin ke nxhia naktoꞌ, gannenꞌ ba bentoꞌ danꞌ bneꞌo gontoꞌ naꞌze.” ");
INSERT INTO zpuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bixha chak zej Jesúsenꞌ Jerusalén naꞌ, bdieꞌ ga zerao nbane Galileanꞌ ren Samaria. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ka bllineꞌ to lloaꞌ yell daꞌo, naꞌ blloj chi beꞌnn llak yillweꞌ danꞌ ne lepra, naꞌ jatil akeꞌ Leꞌe, bze akteꞌ ziꞌtre, ");
INSERT INTO zpuNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","besiaꞌ akeꞌ lle akeꞌ Leꞌe: —¡Jesús, Maestro, bayaꞌchraꞌll netoꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ka breꞌe Jesúsenꞌ leakeꞌn, golleꞌ leakeꞌ: —Lechej rao bxoz kaꞌ, naꞌ wia akeꞌ reꞌ. Bixha chak zjakeꞌ naꞌn, bayak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Toeꞌ, ka gokbeꞌreꞌ ba bayakeꞌn, naꞌ babieꞌ llosieꞌ zillj lloeꞌraweꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ka ballineꞌ rao Jesúsenꞌ, bcheꞌk xhibeꞌ lloeꞌ yel llioxken keꞌe, beꞌnnenꞌ ben kaꞌ nakeꞌ beꞌnn Samaria. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ka breꞌe Jesúsenꞌ beꞌnn tiꞌchenꞌ, bneꞌe: —¿Kere chi beꞌnn kinꞌ bayak? ¿Gannxha beꞌnn ga kaꞌ yelaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Tiꞌchga beꞌnn ziꞌt ni, babieꞌ lloeꞌraweꞌ Dios? ");
INSERT INTO zpuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naꞌ lleꞌe beꞌnnenꞌ: —Bayas, naꞌ bayej, danꞌ nxenraꞌlloꞌ naꞌn, ba basrá rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gok ka bnnabe beꞌnn fariseo kaꞌ Jesúsenꞌ, batenꞌ sorao nnebiaꞌ Diosenꞌ. Naꞌll lleꞌe leakeꞌ: —Ke nake sorao nnebiaꞌ Diosenꞌ, ni ke no gakbeꞌze katenꞌ sorawen. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni ke no nneze: “Ganni ba llnebieꞌ”, naꞌ “Gannaꞌ ba llnebieꞌ”. Ba llnebiaꞌkze Diosenꞌ do radjrenꞌ nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Naꞌll lleꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Wllin lla kate le yeꞌnere reꞌre la tllaze kanꞌ gon Beꞌnnenꞌ Gorj Radj Beꞌnnachenꞌ, naꞌ reꞌ bi gak kanꞌ lleꞌnerenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Laꞌkze ye akeꞌ reꞌ: “Ba zoteꞌ ganni”, o “Gannaꞌ ba zoeꞌ”; bi chejleꞌre ke beꞌnn kaꞌ, naꞌ bi nnao akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kanꞌ llak kate llep yes, lloꞌnnte beniꞌ ken ye chlaꞌre yellrio to sete, kanꞌ gakse katenꞌ yedaꞌ nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, katenꞌ llin llanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Naꞌ zgaꞌtek llayaꞌl wallayrawaꞌ, naꞌ beꞌnn kaꞌ llaꞌa nnaꞌ, bi chejleꞌ akeꞌ kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kanꞌ gokse ka bzo da Noé, kanꞌ gakse katenꞌ llin lla yed Beꞌnnenꞌ Gorj Radj Beꞌnnachenꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kanꞌ bzo da Noénꞌ, llao akeꞌ, lleꞌj akeꞌ, llak wchaynaꞌa nile naꞌle, bllinte lla byoꞌ da Noénꞌ lo barco xhen naꞌ, naꞌll gok yejsiꞌo xhen, naꞌ blleyiꞌ beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Leskaꞌ gok kanꞌ bzo beꞌnnenꞌ golle Lot, llao akeꞌ, lleꞌj akeꞌ, lloꞌt akeꞌ, llaꞌo akeꞌ, goz akeꞌ, baral akllreꞌ benchaꞌo rill akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bixha ka balloj da Lotenꞌ yell Sodomanꞌ, naꞌ bzorao llyinnj yiꞌ barje, bexj da nak ka yoran, naꞌ bzeyen yeolol beꞌnn kaꞌ llaꞌa rao yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kaꞌkzenꞌ gak katenꞌ yed Beꞌnnenꞌ Gorj Radj Beꞌnnach da yobre rao yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Naꞌ katenꞌ llin llanꞌ, chaꞌ to beꞌnn deꞌe yichjore, naꞌ llaꞌa xchinraze lo yoꞌn, bi llayaꞌl wayetjeꞌ lljaxhiꞌi xchinrazeꞌ kaꞌ. Naꞌ chaꞌ to beꞌnn zejeꞌ lyiꞌxe, leskaꞌ bi llayaꞌl wabieꞌ wayej rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lelljadinraꞌll kanꞌ gok ke noꞌr ke da Lot. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Beꞌnnenꞌ yeꞌnreꞌ yesrá yel nban ke kwineꞌ, leꞌen wniteꞌn, naꞌ beꞌnnenꞌ wsanraꞌlleꞌ yel nban keꞌen ni kiaꞌ nadaꞌ, leꞌen yerá. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ni llniaꞌ reꞌ, lleꞌ naꞌ chaꞌ chop beꞌnn de akeꞌ txhen, toeꞌn yeziꞌi Diosenꞌ naꞌ ye toeꞌ gaꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chop noꞌr lliꞌ akeꞌ llot akeꞌ, toeꞌn yeziꞌi Diosenꞌ, naꞌ ye toeꞌ gaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chop beꞌnn chaꞌ da akeꞌ txhen lyiꞌxe, toeꞌn yeziꞌi Diosenꞌ, naꞌ ye toeꞌ gaꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Naꞌll goll beꞌnn kaꞌ non Leꞌe txhen naꞌ Leꞌe: —¿Gaxhanꞌ gak kaꞌ, Xantoꞌ? Naꞌll lleꞌe leakeꞌ: —Naꞌ gonen ka ke beꞌnnenꞌ neꞌe: “Ganꞌ de ba wat naꞌ, gannaꞌn wadopkze chod kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Naꞌ beꞌrén Jesúsenꞌ leakeꞌ diꞌll, bsaꞌkrebreꞌ ka gok ke to noꞌr, nench broeꞌreꞌ leakeꞌ da lliarao xhen naꞌ, weꞌrén akeꞌ Diosenꞌ diꞌll, naꞌ bi gatraꞌll akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naꞌ bneꞌe: —Rao yell naꞌ bzo to beꞌnn llon yel koxchis, nono llapkzeꞌ baraꞌnne, ni Dios, ni lwellj beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Naꞌ leskaꞌ rao yell naꞌ zo to noꞌr wazeb, naꞌ weltze llej noꞌrenꞌ rao beꞌnn wen yel koxchisenꞌ, lleꞌe leꞌe: “Ben yel koxchis kiaꞌ, zo to beꞌnn le llsaꞌkzieꞌ nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naꞌ gokte scha, bi broꞌkzeꞌ xhnneze kanꞌ llak ke noꞌrenꞌ. Bixha kate bllin lla bneꞌe: “Laꞌkze bi llapaꞌ baraꞌnne Dios ni beꞌnne, ");
INSERT INTO zpuNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gonllaꞌ yel koxchis keꞌen, nench ke yesdó noꞌrenꞌ yel llxhenraꞌll kiaꞌn, le ziꞌte zed lloneꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naꞌll bne Xanllonꞌ: —Lewayón ke xhbab kanꞌ bne beꞌnn wen yel koxchisenꞌ, nakteꞌ beꞌnn llon da bi zej lixheje. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Kere leskaꞌ gon Diosenꞌ yel koxchis ke beꞌnn kaꞌ ba brejeꞌ llonliraꞌll Leꞌen, chaꞌ llalwill akeꞌ Leꞌe do lla do yere? ¿O chaꞌ wllereꞌ bi gakrenzeꞌ leakeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ni llniaꞌ reꞌ, sete goneꞌ yel koxchis ke akeꞌ. Zan katenꞌ llin lla yedaꞌ nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach, da yobre, ¿llaꞌrize beꞌnn nna nxenraꞌll Dios? ");
INSERT INTO zpuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Naꞌ llaꞌa bal beꞌnn le nxenraꞌll kwin akeꞌ, naꞌ llak akreꞌ nak akseꞌ beꞌnn wen, naꞌ llon akeꞌ kaze nollre beꞌnn yobre, naꞌ beꞌe Jesúsenꞌ diꞌll bsaꞌkrebreꞌ bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Chop beꞌnn zjakeꞌ yodaꞌo brao, lljeꞌrén akeꞌ Diosenꞌ diꞌlle, toeꞌ nakeꞌ beꞌnn fariseo, naꞌ ye toeꞌ nakeꞌ beꞌnn wachixhj. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Beꞌnn fariseonꞌ zellatezeꞌ llalwilleꞌ Diosenꞌ, lloeꞌrao kwineꞌ neꞌe: “Dios, llioxkenoꞌ, le bi nakaꞌ beꞌnn wen da xhinnj, ka beꞌnn kaꞌ yelaꞌ, beꞌnn wan, beꞌnn laꞌkze zo noꞌr ke akeꞌ, darén akeꞌ noꞌr yobre, naꞌ ni ke nakzaꞌ kanꞌ nak wachixhj ni. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naꞌ chop ras rao to xhman llonaꞌ was, naꞌ da llonaꞌ gan, llbejaꞌ to kwenen rao chi kwen, naꞌ lljwaꞌan yodaꞌon.” ");
INSERT INTO zpuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Naꞌ beꞌnn wachixhjenꞌ bzeteꞌ ziꞌtre, to ni ke llayaxhjzreꞌ wlis raweꞌ yebá, naꞌ llbaꞌll lchoeꞌ neꞌe: “¡Dios bayaꞌchraꞌll nadaꞌ, nakaꞌ beꞌnn wen da xhinnj!” ");
INSERT INTO zpuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ni llniaꞌ reꞌ, beꞌnn wachixhjenꞌ, baziꞌxhente Diosenꞌ keꞌe, naꞌ zayejteꞌ rilleꞌ nbaraz kerke beꞌnn fariseonꞌ. Le beꞌnnenꞌ lloeꞌrao kwineꞌ, Diosenꞌ goneꞌ ka sieꞌ yel zdoꞌ, naꞌ gakbeꞌreꞌ bi zaꞌke, naꞌ beꞌnnenꞌ llakreꞌ bibi zaꞌke, Diosenꞌ goneꞌ ka sieꞌ yel baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Naꞌ jwaꞌa akeꞌ bidaꞌo rao Jesúsenꞌ nench wxoa taꞌkeꞌn yichj akbeꞌ. Naꞌ breꞌe beꞌnn kaꞌ non Leꞌe txhen kanꞌ llon akeꞌn, naꞌ bdil akeꞌ beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Naꞌ Jesúsenꞌ goxheꞌ bidaꞌo kaꞌ, naꞌll bneꞌe: —Leweꞌe latj yed bidaꞌo kaꞌ rawaꞌn, bi wllonre, le beꞌnn kaꞌ nak ka bidaꞌo ki, leakeꞌn nak Diosenꞌ txhen beꞌnn llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Da li niaꞌ reꞌ, noteze beꞌnne chaꞌ bi goneꞌ ka llon bidaꞌo ki nxenraꞌll akbeꞌ nadaꞌ, ni ke gakzeꞌ gakeꞌ Diosenꞌ txhen beꞌnnenꞌ llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","To beꞌnn brao beꞌnn wniaꞌ, golleꞌ Jesúsenꞌ: —Maestro, rweꞌ nakoꞌ beꞌnn wen; bne nadaꞌ, ¿bi llayaꞌl gonaꞌ nench gaꞌt yel nban zejlikane kiaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesúsenꞌ lleꞌe leꞌe: —¿Bixchen llezoꞌ nadaꞌ beꞌnn wen? Nono llraꞌ beꞌnn nak beꞌnn wen, toze Dios naꞌn nak beꞌnn wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Rweꞌ nnezroꞌ binꞌ ne Diosenꞌ gonllo: “Bi tarenoꞌ noꞌr yobre, bi gotoꞌ beꞌnne, bi kwanoꞌ, bi wtobroꞌ beꞌnn bi da ke beneꞌ, bdap baraꞌnn xaxhnaꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naꞌll bne beꞌnn weꞌon: —Yeolol da kaꞌ ba benaꞌ ka nna naktiaꞌ xkwiꞌde. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ka bene Jesúsenꞌ kanꞌ bne beꞌnnenꞌ, naꞌll lleꞌe leꞌe: —De ye to da llayaꞌl gonoꞌ, jayeꞌt yeolol da de koꞌo, naꞌ mell danꞌ goꞌtoꞌn naꞌ, beꞌen beꞌnn yaꞌch, naꞌll gaꞌt yel wniaꞌ koꞌo yebá, naꞌtell yedoꞌ nnaoꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ka bene beꞌnnenꞌ kanꞌ bne Jesúsenꞌ, le gokreꞌ, bzoyaꞌcheꞌ le nakeꞌ beꞌnn wniaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ka breꞌe Jesúsenꞌ gokyaꞌche beꞌnnenꞌ kwis, naꞌll bneꞌe: —¡Bniꞌ kwis naken ke to beꞌnn wniaꞌ, weꞌe latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sétere te to bayiꞌxe banꞌ nziꞌi camello lo nay yeꞌchich, kerke to beꞌnn wniaꞌ weꞌe latj nnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Beꞌnn kaꞌ ka ben akreꞌ kanꞌ bne Jesúsenꞌ, ben akeꞌ yel wan kwis, ne akeꞌ: —¿Ka noxha yerakzenꞌ chaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Naꞌll lleꞌe leakeꞌ: —Da li de da bi gak gon beꞌnnachenꞌ to wrazeꞌ, zan wak gon Diosenꞌ len. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Naꞌll bne Pedronꞌ: —Netoꞌ ba bsanraꞌlltoꞌ yeolol da de ketoꞌ, naꞌ ba naotoꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Naꞌ lleꞌe leakeꞌ: —Da li niaꞌ reꞌ, noteze beꞌnne, chaꞌ bsanraꞌlleꞌ rilleꞌ, xaxhneꞌe, biꞌcheꞌ, noꞌr keꞌe, xhiꞌnneꞌ, ni ke danꞌ ba llnebiaꞌ Diosenꞌ yichjraꞌlldaꞌweꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","da zaꞌktell weꞌe Diosenꞌ leꞌe nnaꞌ, rao yellrionꞌ, naꞌ kate llin lla naꞌ, weꞌe yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesúsenꞌ goxheꞌ beꞌnn chllinn kaꞌ chlaꞌre, naꞌ lleꞌe leakeꞌ: —Naꞌ chejllo Jerusalén naꞌ, gannaꞌ soaꞌ diꞌll doxhen kanꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ batnaꞌ kanꞌ gak kiaꞌ nadaꞌ, Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gannaꞌ gon akeꞌ nadaꞌ rallnaꞌa beꞌnn ziꞌt kaꞌ, naꞌ wtitj akreꞌ nadaꞌ, gaꞌdyiꞌ akeꞌ nadaꞌ, naꞌ wxiꞌt akeꞌ xheꞌn rawaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naꞌll chintat akeꞌ nadaꞌ, naꞌ got akeꞌ nadaꞌ, naꞌ wayónn lla wabanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Naꞌ beꞌnn kaꞌ nao Leꞌen, ni ke byejnieꞌ akzreꞌ bixchen bneꞌe kaꞌ, nna nchol yichjraꞌlldaꞌo akeꞌn, naꞌllenꞌ bi llejnieꞌ akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bixha gok ka le choꞌte Jesúsenꞌ yell danꞌ re Jericó, to beꞌnn lchol llieꞌ lloaꞌ nezenꞌ, llnnabeꞌ lmoxh. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ka benreꞌ llde beꞌnn zan tnezenꞌ, bnnabeꞌ binꞌ llak. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naꞌ goll akeꞌ leꞌe: —Jesús beꞌnn Nazaretenꞌ lldieꞌ ganni nnaꞌsteke. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naꞌll besieꞌ zillj, bneꞌe: —¡Jesús, Xhiꞌnn dia lla David, bayaꞌchraꞌll nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Beꞌnn kaꞌ lliarao rao Jesúsenꞌ, ben akreꞌ leꞌe znia nench bi goneꞌ llakia, naꞌ leꞌen yezikre besieꞌ zillj, bneꞌe da yobre: —¡Xhiꞌnn dia lla David, bayaꞌchraꞌll nadaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Naꞌ Jesúsenꞌ brexheꞌ, naꞌ golleꞌ beꞌnn kaꞌ lljwaꞌa akeꞌ leꞌe raweꞌn. Ka bllin beꞌnn lcholenꞌ raweꞌn, lleꞌe leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Bnechk, ¿bixhanꞌ lleꞌnroꞌ gonaꞌ? Naꞌll bneꞌe: —Xanaꞌ, lleꞌnraꞌ yereꞌraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Naꞌ goll Jesúsenꞌ leꞌe: —Bareꞌe, danꞌ bxenraꞌlloꞌ naꞌn, ba basrá rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Naꞌ le bareꞌte beꞌnnenꞌ, naꞌ bnaweꞌ Jesúsenꞌ lloeꞌraweꞌ Dios. Ka breꞌe yeolol beꞌnn yell kanꞌ bayakeꞌn, naꞌ beꞌrao akeꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ka byoꞌ Jesúsenꞌ yellenꞌ re Jericó, naꞌ bdieꞌ kllol yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jericó, naꞌ zo to beꞌnn re Zaqueo, naꞌ nakeꞌ beꞌnn llnebiaꞌ wachixhj kaꞌ, naꞌ nakeꞌ beꞌnn wniaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naꞌ le lleꞌnreꞌ reꞌreꞌ Jesúsenꞌ, naꞌ kize llak le beꞌnn zan naꞌ nao Jesúsenꞌ; naꞌ bi gok wieꞌ Leꞌe, le Zaqueonꞌ nakeꞌ to beꞌnn bcheko daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naꞌll bzaꞌdoeꞌ blliaraweꞌ rao beꞌnn zan kaꞌ, naꞌ byepeꞌ to rao yay ganꞌ le tete Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka bllin Jesúsenꞌ xhan yayenꞌ, blis raweꞌn, naꞌ breꞌreꞌ Zaqueonꞌ, naꞌ lleꞌe leꞌe: —Zaqueo, sete bayetj, rilloꞌ naꞌ tasaꞌ nnaꞌ lleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Naꞌ bayetjdoeꞌ, llawereꞌ kwis bacheꞌe Leꞌe rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ka breꞌe beꞌnn kaꞌ kaꞌ, bzorao nne akeꞌ ke Jesúsenꞌ danꞌ bllineꞌ byoeꞌ rill to beꞌnn wen da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Naꞌ Zaqueonꞌ bzelleꞌe, naꞌ lleꞌe Jesúsenꞌ: —Xanaꞌ, achj da deraꞌ waꞌan beꞌnn yaꞌche, naꞌ chaꞌ no beꞌnn bxoayayaꞌ bchixhjeꞌ da xhenll, wakse wayoaꞌ keꞌen laꞌkze tap rasre ke to danꞌ bkaꞌan. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesúsenꞌ lleꞌe leꞌe: —Naꞌ bllin lla yerá beꞌnn kaꞌ, llaꞌa lo yoꞌ ni, le leskaꞌ beꞌnn ni nakeꞌ xhiꞌnn Abraham. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Le nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach zaddirjaꞌ, naꞌ yesraꞌa yeolol beꞌnn ba bnit. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Naꞌ chak llen akreꞌ diꞌll ki, Jesúsenꞌ beꞌe diꞌll ka nak ba zjakeꞌ awlloze Jerusalén naꞌ, le beꞌnn kaꞌ nao Leꞌen, llak akreꞌ le llnebiaꞌte Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naꞌ bneꞌe: —To beꞌnn nak beꞌnn brao, bllojeꞌ zejeꞌ to yell ziꞌte ga weꞌe akeꞌ leꞌe yel llnebiaꞌ, naꞌtell wabieꞌ nnebieꞌ yell keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka za koꞌtereꞌ nez, goxheꞌ chi beꞌnn wen llin keꞌe, naꞌ beꞌe toto akeꞌ mell, naꞌ golleꞌ leakeꞌ: “Legonrén mellenꞌ llin chak zazaꞌa naꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Naꞌll beꞌnn wrall keꞌe kaꞌ llwie leꞌe, ka breꞌe akreꞌ ba broeꞌ nezenꞌ, bseꞌl akeꞌ beꞌnn bnao leꞌe, nench lljayell akeꞌ beꞌnnenꞌ weꞌe leꞌe yel llnebiaꞌn: “Bi lleꞌnetoꞌ nnebiaꞌ beꞌnnenꞌ netoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bixha kate bllin lla ballín beꞌnnenꞌ ralleꞌn, ba nakeꞌ beꞌnn wnebiaꞌ, naꞌ goxheꞌ beꞌnn wen llin kaꞌ beꞌe mellenꞌ, le lleꞌnreꞌ nnezreꞌ akre ben akeꞌ mellenꞌ bkwaꞌnnreneꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Beꞌnn nellenꞌ bllineꞌ raweꞌn, lleꞌe leꞌe: “Xanaꞌ, xhmelloꞌn benen gan ye chi rasre ke to danꞌ bkwaꞌnnoꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naꞌll golleꞌ beꞌnnenꞌ: “Da wen benoꞌ, nakoꞌ beꞌnn wen llin wen, ren da daꞌo raꞌt naꞌ, ba broeꞌroꞌ nakoꞌ beꞌnn wen. Naꞌ nnaꞌ nnebiaꞌo chi yell.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Naꞌll bllin beꞌnn yobre bneꞌe: “Xanaꞌ, xhmelloꞌn benen gan gaꞌy rasre ke to danꞌ bkwaꞌnnoꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Leskaꞌ golleꞌ leꞌe: “Leskaꞌ rweꞌ nnebiaꞌo gaꞌy yell.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Naꞌ bllin ye toeꞌ, bneꞌe: “Xanaꞌ, nna de xhmelloꞌn danꞌ bennoꞌn, broꞌchaꞌozaꞌn braꞌlltiaꞌn to bay, ");
INSERT INTO zpuNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","bllebaꞌ rweꞌ, le nakoꞌ to beꞌnn znia, llaziꞌo da bi benoꞌ, naꞌ llrapoꞌ ga ke llazoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naꞌ bne beꞌnn wnebiaꞌn: “Beꞌnn wen llin mellian, ka diꞌllenꞌ ll-lloj lloaꞌon, kaꞌ gonkzaꞌ koꞌo. Chaꞌ nnezroꞌ nakaꞌ beꞌnn znia, naꞌ llaziaꞌ da bi benaꞌ, naꞌ llrapaꞌ ga ke llazaꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿bixchen ke jaloꞌ xhmellaꞌn ga choꞌchaꞌon naꞌ gonen gan chak zazaꞌa naꞌ, naꞌ nna yeziaꞌn ba xhoa la raꞌtze yichje?” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Naꞌll golleꞌ beꞌnn kaꞌ zjallaꞌa kwiteꞌn: “Lewakaꞌa mellenꞌ noꞌxeꞌn, naꞌ leweꞌn beꞌnnenꞌ ben gan ye chi ke to danꞌ bieꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Naꞌ goll beꞌnn kaꞌ leꞌe: “¡Xantoꞌ, ba napkzeꞌ danꞌ beneꞌ gan naꞌ!” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naꞌ goll beꞌnn wnebiaꞌn leakeꞌ: “Llniaꞌ reꞌ, beꞌnnenꞌ ba napkzeꞌ da napeꞌ, yezikre weꞌe da yobre, naꞌ beꞌnnenꞌ bibi de keꞌe, rente da daꞌo raꞌt, chaꞌ de keꞌe, yekaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Naꞌ ka nak beꞌnn kaꞌ llwie nadaꞌ naꞌ, bi gokraꞌll akeꞌ gakaꞌ beꞌnn wnebiaꞌ, lelljaxiꞌi akeꞌ, naꞌ lewchoy yen akeꞌ rawaꞌ nga.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ka bayoll beꞌe Jesúsenꞌ diꞌll ki, naꞌ broeꞌ nez zejeꞌ Jerusalén. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ka ba zejeꞌ kwit yellenꞌ re Betfagé naꞌ Betania, ganꞌ zo yaꞌn ganꞌ nziꞌi Yaꞌ Olivos, bseꞌleꞌ chop beꞌnn kaꞌ non Leꞌe txhen, ");
INSERT INTO zpuNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","lleꞌe leakeꞌ: —Lechej yellenꞌ lliꞌ chlaꞌ naꞌ, kate choꞌre yellenꞌ reꞌre to burr daꞌbaꞌ yay, ba nono nna kwia, lewsellbaꞌ, naꞌ wcheꞌterebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Naꞌ chaꞌ lloj beꞌnn yeꞌe reꞌ: “¿Bixchen llsellre burrenꞌ?”, leyeꞌe: “Xantoꞌ naꞌn yallje lebaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naꞌ broꞌ beꞌnn kaꞌ nez, naꞌ gokte kanꞌ golleꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ka llsell akeꞌ burrenꞌ, bllin xanbaꞌn lleꞌe leakeꞌ: —¿Bixchen llsellre burrenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naꞌ goll beꞌnn kaꞌ chopenꞌ leꞌe: —Xantoꞌ naꞌn yallje lebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Naꞌ le bacheꞌe aktebaꞌ ganꞌ ze Jesúsenꞌ, naꞌ bxoa akeꞌ raꞌll da nak akeꞌ koꞌll burrenꞌ, naꞌ bllia akeꞌ Jesúsenꞌ koꞌllbaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ka nak zjakeꞌ naꞌn, llchirj akeꞌ no sab ke akeꞌ tnezenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Naꞌ ka le llin akteꞌ letj leꞌ yaꞌ ganꞌ nziꞌi Yaꞌ Olivos, naꞌ ba naken awlloze Jerusalén naꞌ, bzorao beꞌnn kaꞌ non Leꞌe txhen naꞌ, llosiaꞌ akeꞌ zillj llawé akreꞌ, lloeꞌrao akeꞌ Dios, ka nak breꞌe akreꞌ yel wak ke Jesúsenꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ne akeꞌ: —¡Nak laꞌy Rey beꞌnnenꞌ zaꞌa nnaꞌ, beꞌnn bseꞌl Xanllo Dios! ¡Doweꞌrao Diosenꞌ txhen ren beꞌnn kaꞌ llaꞌa yebánꞌ, nnaꞌ ba bllin lla yeniꞌtrenlloeꞌ wen! ");
INSERT INTO zpuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Radj beꞌnn zan kaꞌ nao Jesúsenꞌ, ren beꞌnn kaꞌ nak beꞌnn fariseo, naꞌ goll akeꞌ Jesúsenꞌ: —Maestro, bdil beꞌnn kaꞌ nao rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn: —Llniaꞌ reꞌ, chaꞌ beꞌnn ki so akeꞌ llize, yej ki le gosiaꞌn weꞌrao akeꞌn nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ka bllin Jesúsenꞌ awlloze Jerusalén naꞌ, breꞌreꞌ yell Jerusalén naꞌ, naꞌ bllelleꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","naꞌ bneꞌe: —¡Chenak reꞌ llayakbeꞌre, nnaꞌtek de latj nench wazore wen ren Diosenꞌ! Zan bi llakbeꞌre, le nna ngaꞌchen rao reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wllin lla kate beꞌnn kaꞌ llwie reꞌ, yedchaꞌa akeꞌ wayechjte ganꞌ llaꞌrenꞌ, nono gakse lloje. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Naꞌ yechinnj akeꞌ yellenꞌ, got akeꞌ yeolol reꞌ llaꞌa rao yellenꞌ. Ni to yej da ndil lwellje bi yegaꞌnne, kaꞌn gak keré, le bi byejnieꞌre bi llanꞌ bed Diosenꞌ, zadyakreneꞌ reꞌ chenake. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ka bllin Jesúsenꞌ Jerusalén naꞌ, byoeꞌ yodaꞌo braonꞌ, naꞌ bachacheꞌ yeolol beꞌnn kaꞌ llon yaꞌa liaꞌ yodaꞌon, ");
INSERT INTO zpuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","naꞌ lleꞌe leakeꞌ: —Ki nyoj xtiꞌll Diosenꞌ: “Rillaꞌn, naken yoꞌ ga llayaꞌl yelwill beꞌnn nadaꞌ”, naꞌ reꞌ ba nonren ka broj ke beꞌnn wan. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yeo lla llzejnieꞌ Jesúsenꞌ leakeꞌ do liaꞌ yodaꞌo braonꞌ, naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke leyenꞌ, naꞌ ye bal beꞌnn brao ke beꞌnn Israel kaꞌ, llayirjlaꞌll akeꞌ akre ka gon akeꞌ got akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Naꞌ ni ke llallel akzreꞌ akre ka gon akeꞌ, le beꞌnn yell yel wan xhen llon akeꞌ, ka nak llzenay akeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gok to lla ka llzejnieꞌ Jesúsenꞌ beꞌnn kaꞌ yodaꞌo braonꞌ, llroeꞌreꞌ Diꞌll Wen ke Xanllo Diosenꞌ, kate bllin bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ beꞌnn gor brao ke beꞌnn Israel kaꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","lle akeꞌ Leꞌe: —Bnechk netoꞌ, ¿bi yel llnebiaꞌ napoꞌ llonoꞌ da ki? ¿No benn yel llnebiaꞌn llonoꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn, bneꞌe: —Leskaꞌ nadaꞌ wnnabraꞌ reꞌ, lennechk, ");
INSERT INTO zpuNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿nonꞌ bseꞌl Juan beꞌnnenꞌ bchoa nis? ¿Diosenꞌ bseꞌl leꞌe o chaꞌ nollre beꞌnnachenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Naꞌ bzorao lloeꞌrén lwellj akeꞌ diꞌll, ne akeꞌ: —¿Akxha nnello? Chaꞌ nnello Diosenꞌ bseꞌl leꞌe, naꞌ yeꞌe lliꞌo: “¿Bixchen bi byejleꞌre keꞌe chaꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chaꞌ nnello lwellj beꞌnnkzllonꞌ bseꞌl leꞌe, nxholl wchekw beꞌnn ki lliꞌo yej, le ne akeꞌ Juan naꞌn gokeꞌ to beꞌnn bseꞌl Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Naꞌll goll akeꞌ Jesúsenꞌ bi nnez akreꞌ no bseꞌl Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Naꞌll lle Jesúsenꞌ leakeꞌ: —Leskaꞌ nadaꞌ, bi nniaꞌ non benn nadaꞌ yel llnebiaꞌn nench llonaꞌ da ki. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Naꞌ bne Jesúsenꞌ to diꞌll llzejnieꞌreꞌ beꞌnn kaꞌ llaꞌa llzenay xtiꞌlleꞌn: —To beꞌnne, gozeꞌ lba uvas rao yellrio xhen keꞌen, naꞌ beneꞌn rallnaꞌa beꞌnne, naꞌ broeꞌ nez zejeꞌ ga yobre ga jasoeꞌ scha. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ka bllin lla llalis beꞌnn kaꞌ da kaꞌ llaz akeꞌn, beꞌnnenꞌ nak xaneꞌn bseꞌleꞌ to beꞌnn wen llin keꞌen, nench wazieꞌ ke to da llayaꞌleꞌ. Naꞌ ka bllin beꞌnnenꞌ, ben akeꞌ ziꞌ keꞌe, naꞌ bibi beꞌe akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Naꞌll beꞌnnenꞌ bseꞌleꞌ ye to beꞌnn wen llin keꞌe beꞌnn yobre, leskaꞌ goꞌdyiꞌ akeꞌ leꞌe, naꞌ ben akeꞌ ziꞌ keꞌe, naꞌ bibi beꞌe akseꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Naꞌll bseꞌlkzeꞌ beꞌnn yobre, naꞌ bentat akeꞌ ziꞌ keꞌe, ben akteꞌ leꞌe weꞌe, jazaꞌl akteꞌ leꞌe latj yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Naꞌll xan yellrionꞌ bneꞌe: “¿Akxha gonaꞌ nnaꞌ? Wseꞌlchekaꞌ xhiꞌnnaꞌ binꞌ nllieꞌraꞌ naꞌ, cheke gap akebeꞌ baraꞌnne.” ");
INSERT INTO zpuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bixha beꞌnn wen llin kaꞌ, ka breꞌe akreꞌ xhiꞌnn beꞌnnenꞌ, lle lwellj akeꞌ: “Beꞌnn ninꞌ xhiꞌnn xan yellrionꞌ, leꞌen llayaꞌl siꞌi bien naꞌ, ledá gotlloeꞌ, naꞌ gak danꞌ kello.” ");
INSERT INTO zpuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naꞌ brej akeꞌ leꞌe lo reꞌjenꞌ, naꞌ bet akeꞌ leꞌe. Naꞌll bne Jesúsenꞌ: —¿Akre llákere, akre gon xan yellrionꞌ ke beꞌnn kaꞌ llon llin rao yellrionꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chejeꞌ, naꞌ lljeteꞌ leakeꞌ, naꞌ goneꞌ yellrionꞌ rallnaꞌa beꞌnn yobre. Ka bayoll bene beꞌnn kaꞌ ka diꞌllenꞌ, bne akeꞌ: —¡Dios gakreneꞌ lliꞌo bi gonllo kaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naꞌll Jesúsenꞌ llwiatezeꞌ leakeꞌ, bneꞌe: —¿Ka akxha chejnieꞌllo ganꞌ nyoj xtiꞌll Diosenꞌ, nen ki?: Yej danꞌ bi byoꞌraꞌll beꞌnn wen yoꞌ kaꞌ, gonrén akeꞌ llin, len naꞌ ba naken yej skin. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Beꞌnn bixe, naꞌ lljagoꞌnneꞌ rao yejenꞌ, gachjtineꞌ, naꞌ beꞌnnenꞌ chaꞌ yej naꞌ bixen wxejen leꞌe, wxhoxhjtinten leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bayoll bne Jesúsenꞌ kaꞌ, bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke leyenꞌ, le gokraꞌll akteꞌ goꞌx akeꞌ Leꞌe, le byejnieꞌ akreꞌ ni ke leakeꞌn beꞌe diꞌllenꞌ kaꞌ, naꞌ blleb akeꞌ beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Naꞌ bseꞌl akeꞌ beꞌnn blleꞌnao Leꞌe, beꞌnn ben ka llon Leꞌe txhenre, nench naꞌ kweꞌnao akeꞌ chaꞌ bi diꞌll lloj lloeꞌ, naꞌ saꞌke gon akeꞌ Leꞌe rallnaꞌa beꞌnn wnebiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Naꞌ beꞌnn kaꞌ goll akeꞌ Jesúsenꞌ: —Maestro, nnézetoꞌ lloeꞌo diꞌll li llroeꞌroꞌ lixheje, naꞌ toz ka llonoꞌ ren noteze beꞌnne, naꞌ llzejnieꞌroꞌ kanꞌ nak xhnnez Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lleꞌnetoꞌ nnézetoꞌ, ¿naken wen chixhjtoꞌ danꞌ llnnab beꞌnnenꞌ le zeraoze nak wnebiaꞌ, beꞌnnenꞌ llia Roma o chaꞌ bi naken wen? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Naꞌ Jesúsenꞌ bayakbeꞌreꞌ kere do raꞌll akeꞌn llnnab akeꞌ, naꞌll lleꞌe leakeꞌ: —¿Bixchen lleꞌnzere gonreꞌre nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Lewroeꞌ nadaꞌ to xhmellrenꞌ. Ka beꞌe akeꞌ Leꞌe mellenꞌ, naꞌ bneꞌe: —¿Noxha raonꞌ daꞌa leꞌ mell ni? ¿No ranꞌ nyoj le ni? Naꞌll bne akeꞌ: —César beꞌnnenꞌ llnebiaꞌ Roma naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Naꞌll lleꞌe leakeꞌ: —Da nake ke César lewayoeꞌn leꞌe; naꞌ da llayaꞌl weꞌre Dios, leweꞌn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naꞌ bi llakse gon akeꞌ lloj to diꞌll krere lloaꞌ Jesúsenꞌ rao beꞌnn kaꞌ llaꞌn, naꞌ llabán akreꞌ kanꞌ llallieꞌ xtiꞌll akeꞌn, llazé akteꞌ llize. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Naꞌll bllin bal beꞌnn kaꞌ nziꞌi saduceo, beꞌnn kaꞌ bi llejleꞌ yebán beꞌnn wat kaꞌ. Naꞌ goll akeꞌ Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, danꞌ bzoj da Moisésenꞌ, gannaꞌ nllian biaꞌa, chaꞌ to beꞌnn wchayneꞌe, naꞌ gateꞌ, naꞌ nono xhiꞌnneꞌ bzo, to beꞌnn biꞌcheꞌ wazieꞌ noꞌrenꞌ nench wazó lo raz beꞌnn watenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ki gok bzo gall beꞌnne, beꞌnn nellenꞌ bxhieꞌ noꞌrenꞌ, naꞌ goteꞌ bi bzo xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Naꞌll biꞌcheꞌ, beꞌnn wllopenꞌ bazieꞌ noꞌrenꞌ, naꞌ leskaꞌ goteꞌ nono xhiꞌnn akeꞌ bzokze. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Naꞌll beꞌnn wyonne bazieꞌ noꞌrenꞌ, leskaꞌ goteꞌ, naꞌ kaꞌ yeolol akeꞌ bzorén noꞌrenꞌ, naꞌ yeolol akeꞌ got, ni to xhiꞌnn akeꞌ bi bzo. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Naꞌll got ren noꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kate llin lla yebán beꞌnn wat kaꞌ, ¿nore beꞌnn ki gakse beꞌnn ke noꞌrenꞌ, le yeololeꞌn bzorén leꞌe? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Naꞌ goll Jesúsenꞌ leakeꞌ: —Beꞌnn kaꞌ llaꞌa rao yellrio ni, llchaynaꞌa akeꞌ, naꞌ llchaynaꞌa no xhiꞌnn akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Zan ka nak beꞌnn kaꞌ ba nbej Diosenꞌ nench yebán akeꞌ, naꞌ yellín akeꞌ yebánꞌ, kere wchaynaꞌll beꞌnn kaꞌ, naꞌ nollno wchaynaꞌkze. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Le kere naꞌ gat akeꞌ da yobrenꞌ, ka angl ke Diosenꞌ wayak akeꞌ, gak akeꞌ xhiꞌnn Dios dogarje, le ke len naꞌ ba basbaneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ka nak danꞌ de yebán beꞌnn wat kaꞌ, kwin da Moisésenꞌ bzejnieꞌreꞌn ka nak bzojeꞌ kanꞌ balwill Diosenꞌ leꞌe to lo xhis yeꞌche, naꞌ bne Diosenꞌ nakeꞌ Dios ke Abraham, Dios ke Isaac naꞌ Dios ke Jacob, le nban beꞌnn kinꞌ, naꞌllenꞌ bneꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ka nak Diosenꞌ, bi nakeꞌ Dios ke beꞌnn wat, Dios ke beꞌnn ban naꞌ nakeꞌ, naꞌ yeolol beꞌnn nxenraꞌlleꞌ Diosenꞌ, laꞌkze ba got akeꞌ, nban akseꞌ rao Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Naꞌ bal beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, goll akeꞌ Leꞌe: —Da li kanꞌ bneꞌon, Maestro. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Naꞌ bill bayaxhj akreꞌ wnnab akllreꞌ Leꞌe billre da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Naꞌ lle Jesúsenꞌ leakeꞌ: —¿Bixchen ne akzeꞌ, Cristonꞌ nakeꞌ xhiꞌnn da rey Davidenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Renchaꞌ kwin Davidenꞌ bzojeꞌ leꞌ yich ke Salmos ki: Xanllo Diosenꞌ golleꞌ Xanaꞌn: “Blleꞌ kwitaꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","llinte lla ka gonaꞌ yeolol beꞌnn kaꞌ llwie rweꞌn, nniꞌt akeꞌ xhniaꞌon.” ");
INSERT INTO zpuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chaꞌ Davidenꞌ bneꞌe Cristonꞌ nakeꞌ Xaneꞌ, ¿akxha gakze Cristonꞌ xhiꞌnn dialla ke Davidenꞌ chet kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Beꞌnn zan llaꞌa llzenay xtiꞌll Jesúsenꞌ, naꞌll golleꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Lewiayaꞌnn kanꞌ llon beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, llawé akreꞌ llak akeꞌ to raꞌll tonn, naꞌ llawé akreꞌ gap beꞌnn leakeꞌ baraꞌnne do tnez, do lao yaꞌa, naꞌ do lo yodaꞌo. Leskaꞌ ga llak no wao, ll-lan akeꞌ ga ba nak kweꞌ beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naꞌ llkaꞌa akeꞌ rill noꞌr wazebe, naꞌ da lldeꞌ akreꞌ, scha llze akeꞌ kate llalwill akeꞌ Diosenꞌ nechkze ten kaꞌze. Da xhen da de saꞌkziꞌ beꞌnn kaꞌ kanꞌ llon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ka zo Jesúsenꞌ yodaꞌon, breꞌreꞌ ka llgoꞌ beꞌnn wniaꞌ kaꞌ mell danꞌ lldop lo yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Leskaꞌ breꞌreꞌ ka bllin to noꞌr yaꞌch noꞌr wazeb, broeꞌ chop mell daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Naꞌll bne Jesúsenꞌ: —Da li llniaꞌ, noꞌr wazeb yaꞌch ni, da xhenll ba broeꞌ kerke yeolol beꞌnn kaꞌ yelaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Le broꞌ akeꞌ da ba bgoꞌnn billbi de gon akreꞌn, zan ka nak noꞌrenꞌ, rao yel yaꞌch keꞌen beꞌe ka da lallibe de keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Naꞌ bal beꞌnn kaꞌ llaꞌn, lloeꞌ akeꞌ diꞌll katek nbaraz nak yodaꞌo braonꞌ, naꞌ ka wallajllo nak yej kaꞌ naken naꞌ, naꞌ billre da non len nbaraz da lloeꞌ akeꞌ ke yodaꞌon. Naꞌ bne Jesúsenꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ka nak da kaꞌ llreꞌre nga, wllin lla kat ni to yej ki zjankwaꞌa ganni, noꞌx lwellje bi yegaꞌnnen. Yeololen yeyinnj aken. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Naꞌll bzorao llnnab akreꞌ Jesúsenꞌ, lle akeꞌ Leꞌe: —Maestro, ¿batenꞌ gak kaꞌ? ¿Bixha gak katenꞌ ba zo rez gak kanꞌ bneꞌon? ");
INSERT INTO zpuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Naꞌll lleꞌe leakeꞌ: —Lewiá ke nench ke no siyeꞌz reꞌ, naꞌ kaꞌre nez yobre, le beꞌnn zan beꞌnn wxhiyeꞌe raꞌ, naꞌ nne akeꞌ: “Nadaꞌn Cristonꞌ”, naꞌ “Ye chollze le yellayraote beꞌnn llaꞌa yellrionꞌ.” Bi chejleꞌre ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kate yénere gak wdile, naꞌ yénere do ga yobre ba llak wdil, bi llebre, da llayaꞌl gakse da ki, naꞌ ker le wayollte yellrio naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Naꞌll bneꞌe: —Naꞌ til to yell ren ye to yell, naꞌ yell xhen ren ye to yell xhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Naꞌll xoꞌ gateze, naꞌ gak win, naꞌ raꞌ yillweꞌ, naꞌ beꞌnn kaꞌ lleb akeꞌ kwis kanꞌ gaken, naꞌll biteze gak leꞌ yebánꞌ da yebán akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Naꞌ ka za gaktere da ki, goꞌx akeꞌ reꞌ, naꞌ siꞌchiꞌll akeꞌ reꞌ, naꞌ xobxexj akeꞌ reꞌ, wcheꞌe akeꞌ reꞌ ga zo no yodaꞌo ga lladop akeꞌ, naꞌ koꞌ akeꞌ reꞌ rill ya, naꞌ lljwaꞌa akeꞌ reꞌ no rao rey, rao koxchis, ni ke danꞌ nxenraꞌllre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka nake gon akeꞌ kaꞌ, naꞌ gaꞌt latj weꞌre xtiꞌllaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bi gonre xhbab akre ka nnere, kate llinre rao beꞌnn wnebiaꞌ kaꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nadaꞌ gonnaꞌ diꞌll, naꞌ gonnaꞌ reꞌ yel siꞌn nench gak walliꞌre xtiꞌll akeꞌn, ni ke no soeze reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Naꞌ danꞌ llebraz wie akreꞌ reꞌn, kwin xaxhnaꞌre, biꞌchre, biꞌch lwelljre, naꞌ beꞌnn kaꞌ nonre txhen, gon akeꞌ reꞌ rallnaꞌa beꞌnn kaꞌ llwie reꞌn, naꞌ balre got akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yeolol beꞌnn wie akreꞌ reꞌ, ni ke danꞌ nxenraꞌllre nadaꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","zan ni to yich yichjre bi kwiayiꞌ rao Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lesé war, naꞌ legap yel llxhenraꞌlle, naꞌ gonre gan. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Kate reꞌre ba llaꞌa wakaꞌa ya ba nechj akeꞌ Jerusalén naꞌ, nnézello ba zo rez kwiayiꞌn naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Reꞌ llaꞌa ganꞌ nbane Judeanꞌ, lewxhonnj lechej yaꞌ xhen, naꞌ reꞌ llaꞌa Jerusalén naꞌ, lellache; reꞌ zej lyiꞌxe, bi yeꞌnzere wayoꞌre yell. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Le ba bllin lla yellayrao beꞌnn kaꞌ, naꞌ soa diꞌll kanꞌ nyoj xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Nyaꞌchraz ke noꞌr noaꞌ bdaꞌo, naꞌ noꞌr nkaꞌ bdaꞌo kanaꞌ! Doxhen rao yellrionꞌ wallayrao beꞌnne, naꞌ yeolol beꞌnn kaꞌ llaꞌa ganꞌ nbane Judeanꞌ, Diosenꞌ goneꞌ yellayrao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Beꞌnn zan gat rao wdilenꞌ, naꞌ beꞌnn zan wchach akeꞌ, naꞌ wcheꞌe akteꞌ leakeꞌ rao yeolol yell xhen kaꞌ zjalliꞌ rao yellrionꞌ, naꞌ beꞌnn ziꞌt bi nak beꞌnn Israel, chaꞌa akeꞌ wrejchekw akeꞌ Jerusalén naꞌ, llinte lla bill nnebiaꞌ beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Naꞌ bi gak bi nne leꞌ yebánꞌ, willenꞌ, beꞌon naꞌ berj kaꞌ, naꞌ beꞌnn kaꞌ llaꞌa rao yellrionꞌ, to gak akeꞌ tore le llebraz lleb akeꞌ ka yen akreꞌ gon nisdaꞌon llakia, ka nak wlis beꞌn len. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Naꞌ danꞌ lleb akeꞌn, to gatzi akeꞌ kanꞌ gak rao yellrionꞌ, le kanaꞌ wroeꞌrao doxhen yel wak da bi naꞌ reꞌllo leꞌ yebánꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Naꞌtellenꞌ reꞌe akreꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnachenꞌ, zeꞌe to lo bej nseꞌe yel wak xhen keꞌen, naꞌ beniꞌ xhen keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kate ba bzorao llak da ki, legondipraꞌlle, naꞌ leyewé le ba zo rez yesrá Diosenꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Naꞌll bsaꞌkrebreꞌ llroeꞌreꞌ leakeꞌ: —Lewiá ke yay higo, naꞌ biteze yay, ");
INSERT INTO zpuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","kate ba llagaꞌ xhlaꞌyen, naꞌ llakbeꞌre ba zo rez choꞌre rao ba. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Leskaꞌkzenꞌ, katenꞌ ba llreꞌre llak da kaꞌ ba bniaꞌ ni, ba nnézere ba zo rez nnebiaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Da li llniaꞌ reꞌ, beꞌnn kaꞌ llaꞌa nnaꞌ, nna nban akteꞌ kate sorao gak da ki. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ka nak yebánꞌ ren yellrionꞌ wllin lla kat te ke, zan ka nake xtiꞌllaꞌn kere da te ke kaꞌzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Naꞌ lewiá, ke yeꞌj gaoxenre, sollere, naꞌ kwiare ria, naꞌ choꞌ yichjre chraoze da de rao yellrionꞌ, naꞌ bi gakbeꞌre katenꞌ llin llanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka llak ke to bayiꞌx daꞌo, ni ke llakbeꞌzebaꞌ lljabixbaꞌ ga lldoꞌlbaꞌ, kanꞌ gak ke beꞌnn kaꞌ llaꞌa rao yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lewnnaꞌ yere, lewalwill Diosenꞌ nench gakreneꞌ reꞌ katenꞌ llin lla naꞌ, naꞌ gak wallinre lljazere rao Beꞌnnenꞌ Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kaꞌ, yeo lla, Jesúsenꞌ llzejnieꞌreꞌ beꞌnn kaꞌ do liaꞌ yodaꞌo braonꞌ, naꞌ yeo lleꞌ llayejteꞌ yaꞌ ganꞌ nziꞌi Yaꞌ Olivos. ");
INSERT INTO zpuNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Naꞌ kate lleniꞌ beꞌnn zan lladop yodaꞌo braonꞌ, naꞌ lljazejnieꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bixha ba zo rez gaꞌl lnni danꞌ ne paskw Jerusalén naꞌ, katenꞌ llao akeꞌ yet xtir danꞌ bi nchix kwa binn. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, bzorao llyirjlaꞌll akeꞌ akre gon akeꞌ nench got akeꞌ Jesúsenꞌ, le lleb akeꞌ beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naꞌ daxiꞌon byoꞌn yichjraꞌlldaꞌo Judas, beꞌnnenꞌ nsiꞌi akeꞌ Iscariote, beꞌnnenꞌ nak txhen beꞌnn chllinn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Naꞌll byejeꞌ jeꞌreneꞌ bxoz wnebiaꞌ kaꞌ diꞌlle, naꞌ ren beꞌnn kaꞌ nak xan beꞌnn kaꞌ llap yodaꞌon, kanꞌ goneꞌ Jesúsenꞌ rallnaꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bawé beꞌnn kaꞌ kwis, naꞌ beꞌe akeꞌ diꞌll weꞌe akeꞌ leꞌe mell. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas naꞌ bchebeꞌ wdieꞌ Jesúsenꞌ rao naꞌa akeꞌ, naꞌ bzorao lliꞌnaweꞌ gaꞌt latj goneꞌ Leꞌe rao naꞌa beꞌnn kaꞌ, kate bi gakbeꞌe beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Naꞌ ka bllin lla, ka llao akeꞌ yet xtir danꞌ bi nchix kwa binn, naꞌ leskaꞌ llot akeꞌ xhiꞌr kanꞌ llaꞌl lnni Paskw. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesúsenꞌ bseꞌleꞌ Pedronꞌ ren Juan naꞌ, lleꞌe leakeꞌ: —Lechej lelljén xhnid, lelljasiniaꞌ danꞌ gaollo lnni paskwnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naꞌll goll akeꞌ Leꞌe: —¿Gaxha lleꞌnroꞌ lljasiniaꞌtoꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Naꞌ lleꞌe leakeꞌ: —Kate choꞌre yellenꞌ, naꞌ walláyere to beꞌnne zanzoeꞌ to lleꞌ nis xhichjeꞌ, lennaweꞌ, kon ga choꞌ leꞌe, gannaꞌ choꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kate choꞌrenꞌ, leyé xan yoꞌn: “Maestronꞌ, neꞌe: ¿Ga zo yoꞌ ganꞌ gaotoꞌ xcheꞌ, ren beꞌnn kaꞌ non nadaꞌ txhen lnni paskw ni?” ");
INSERT INTO zpuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naꞌ wroeꞌreꞌ reꞌ to yoꞌ da zo chkwia, naꞌ ba de yeolol da kaꞌ yálljellonꞌ, gannaꞌ wsiniaꞌre danꞌ gaollonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Naꞌ bzaꞌa akeꞌ, gokte kanꞌ golleꞌ leakeꞌn, naꞌ bsiniaꞌ akeꞌ danꞌ gao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ka bllin gao akeꞌ xcheꞌn, blleꞌ Jesúsenꞌ ren postl keꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naꞌ golleꞌ leakeꞌ: —¡Le ba bzeraꞌllkazaꞌ gaorenaꞌ reꞌ, lnni paskwnꞌ ka za gataꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ni llniaꞌ reꞌ, zerao nnaꞌ llaorenaꞌn reꞌ. Kate ba gok doxhen danꞌ llroeꞌraꞌ ni, naꞌ ba llnebiaꞌ Diosenꞌ, kanaꞌll gaorenaꞌ reꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naꞌ beꞌxeꞌ leo daꞌon, beꞌe yel llioxken ke Dios, bneꞌe: —Lesiꞌi da ni, naꞌ leyeꞌj raꞌt wejen yeololre. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Llniaꞌ reꞌ, zerao nnaꞌ lleꞌjaꞌ xis uvanꞌ, llinte lla kate ba llnebiaꞌ Diosenꞌ; kanaꞌll yeyeꞌjaꞌn da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naꞌll bxhieꞌ yet xtirenꞌ, naꞌ beꞌe yel llioxken ke Diosenꞌ, naꞌll bxhoxhjeꞌn beꞌen leakeꞌ, naꞌ bneꞌe: —Da ninꞌ naken kwerp kiaꞌ, ke nak nnaꞌ llsanraꞌllaꞌn ni ke reꞌ, kaꞌ gonre gaoren nench lljasaꞌraꞌllre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naꞌ ka badaweꞌ xcheꞌn, beꞌxeꞌ leo daꞌon bneꞌe: —Danꞌ yoll lo leo daꞌo ni, naken to da llroeꞌn, nnaꞌ sorao to da kob, danꞌ bcheb Diosenꞌ gakreneꞌ reꞌ, ke len naꞌ, larj xchenaꞌn nench gaken da li. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Beꞌnnenꞌ gon nadaꞌ rallnaꞌa beꞌnn kaꞌ got nadaꞌ, leskaꞌ rawe ganꞌ lliꞌllo ni, nxoa taꞌkeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Da li, nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, ba naksen gak kiaꞌ kaꞌ, zan nyaꞌchraz ke beꞌnnenꞌ gon nadaꞌ rao naꞌa beꞌnn kaꞌ got nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, bzorao llnnabe lwellj akeꞌ, nor akeꞌn gon Leꞌe rallnaꞌa beꞌnn kaꞌ llwie Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Leskaꞌ bzorao lloeꞌrén lwellj akeꞌ diꞌll, norenꞌ gakll beꞌnn brao. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Naꞌll lle Jesúsenꞌ leakeꞌ: —Beꞌnn kaꞌ llnebiaꞌ toto yell xhen, llawé akreꞌ gon beꞌnn kaꞌ kon da nez leakeꞌ, naꞌ leskaꞌ llawé akreꞌ nne beꞌnne, nak akeꞌ beꞌnn wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Zan reꞌ, bi gonre kaꞌ, beꞌnnenꞌ yeꞌnzreꞌ gakeꞌ beꞌnn brao, llayaꞌl gakeꞌ ka beꞌnn bibi nneze, naꞌ beꞌnnenꞌ yeꞌnzreꞌ nnebieꞌ radjrenꞌ, llayaꞌl gakeꞌ ka to beꞌnn wen llin keré. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lennechk, ¿nore beꞌnnenꞌ nak beꞌnn brao, beꞌnnenꞌ lliꞌ llao naꞌ, o chaꞌ beꞌnnenꞌ llsiniaꞌ danꞌ gaweꞌ naꞌn? Nakbieꞌkze beꞌnnenꞌ lliꞌ llao naꞌ, nak beꞌnn brao. Zan nadaꞌ ziaꞌ ganni ka beꞌnn wen llin keré, naꞌ ziaꞌ nench gakrenaꞌ reꞌ biteze da gak keré. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Laꞌkze biteze da ba gok kiaꞌ, reꞌ ba bzerenre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Leskaꞌ gonaꞌ nench nnebiaꞌre katenꞌ gonn Xaꞌn yel llnebiaꞌ keꞌen nadaꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nench kweꞌrenre nadaꞌ, naꞌ yeꞌj gaollo txhen katenꞌ ba llnebiaꞌn, leskaꞌ gonaꞌ to latj ga kweꞌre nench gonre yel koxchis, naꞌ wchoybiaꞌre ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Leskaꞌ goll Xanllonꞌ Simón Pedronꞌ: —Simón, Simón ba bnnab daxiꞌon nench gonreꞌren reꞌ, gonen reꞌ ka llon beꞌnn llrobe trigo. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nadaꞌ ba bnnabaꞌ rao Dios gakreneꞌ rweꞌ nench bi gakganroꞌ, naꞌ kate ba benoꞌ gan naꞌ, gakrenchgoꞌ beꞌnn biꞌchoꞌ ki. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naꞌll Pedronꞌ lleꞌe Leꞌe: —Xanaꞌ, ba bchoyraꞌllaꞌ kere lo rill yaze saꞌrenaꞌ rweꞌ, gatrentekzaꞌ rweꞌ chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Naꞌll lleꞌe Pedronꞌ: —Pedro, llniaꞌ rweꞌ, bire nne kwell lekwnꞌ nnaꞌ lleꞌ, llinte gak chonn ras bi weꞌo diꞌll nombiaꞌo nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Naꞌ lle Jesúsenꞌ beꞌnn kaꞌ non Leꞌe txhen: —Kanꞌ bseꞌlaꞌ reꞌ, kaꞌn bibi beꞌxkzre, ni mell, ni bzod, ni ye chkweꞌ xher-re; lennechk, ¿bi byálljere? Naꞌ lle akeꞌ Leꞌe: —Bitbi byálljetoꞌ. Naꞌll bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Zan nnaꞌ, chaꞌ reꞌ de mell keré, lewaꞌn; leskaꞌ chaꞌ napre bzod, legoꞌxen; naꞌ reꞌ bi napre spad, legoꞌt no xherk keré, naꞌ lesiꞌi ton. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Le llniaꞌ reꞌ, dekz de gak kiaꞌ kanꞌ nyoj xtiꞌll Diosenꞌ ganꞌ nen ki: “Ben akreꞌ leꞌe ka llon akreꞌ beꞌnn wen da xhinnj.” Le danꞌ nyoj gak kiaꞌn dekz de gaken. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Naꞌll bne beꞌnn kaꞌ nao Leꞌen: —Xantoꞌ, naꞌ de chop spad. Naꞌ lleꞌe leakeꞌ: —Ba gokse to kate. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Naꞌ blloj Jesúsenꞌ zejeꞌ yaꞌn ganꞌ nziꞌi Yaꞌ Olivos, ka llonkzeꞌ, naꞌ beꞌnn kaꞌ non Leꞌe txhen bnao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ka bllin akeꞌ latjenꞌ, lleꞌe leakeꞌ: —Lewalwill Diosenꞌ nench ke gon da xhinnjenꞌ reꞌ gan. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naꞌll Leꞌen bdeteꞌ zejeꞌ, ke to ga llin to yej da llzaꞌl-llo, naꞌ bcheꞌk xhibeꞌ balwilleꞌ Diosenꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","bneꞌe: —Xa, chaꞌ rweꞌ lleꞌnroꞌ, benchga bi wallayrawaꞌ, zan bi gak kon ka nniaꞌ nadaꞌ, gak kanꞌ nnekzoꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Naꞌ betj to angl zaꞌa yebánꞌ bllineꞌ ganꞌ ncheꞌk xhibeꞌn, naꞌ btipraꞌlle Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Naꞌ llallayraweꞌ kwis llake yichjraꞌlldaꞌweꞌn, naꞌ llalwilleꞌ Diosenꞌ, kate bzorao llayakloljeꞌ, naꞌ nis yes keꞌen naktekzen llen ll-llonen rao yonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bixha ka bayoll beꞌreneꞌ Diosenꞌ diꞌllenꞌ, bazolleꞌe. Ka ballineꞌ ganꞌ niꞌt beꞌnn kaꞌ non Leꞌe txhen naꞌ, jadiꞌreꞌ leakeꞌ tas akeꞌ danꞌ llak akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naꞌll lleꞌe leakeꞌ: —¿Bixchen tasre? Lechas, naꞌ lewalwill Dios nench ke gon da xhinnjenꞌ reꞌ gan. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Naꞌ zete Jesúsenꞌ lloeꞌ diꞌllenꞌ, kate bllin Judas beꞌnnenꞌ nak txhen ren beꞌnn chllinn kaꞌ, ncheꞌteꞌ beꞌnn zan, naꞌ jabiꞌyeꞌ kwit Jesúsenꞌ bnoꞌpeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesúsenꞌ golleꞌ Judasenꞌ: —Judas, ¿llnoꞌpteꞌo nadaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach, nechkze gonoꞌ nadaꞌ rallnaꞌa beꞌnn kaꞌ llwie nadaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bixha ka breꞌe beꞌnn kaꞌ nao Leꞌen, goꞌx akeꞌ Leꞌen, bne akeꞌ: —Xantoꞌ, naꞌ de spad, ¿wzoyibllo? ");
INSERT INTO zpuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Toeꞌ bdineꞌ spad keꞌen, bchoyteꞌ yid nay chaꞌwe beꞌnn wen llin ke bxoz braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Naꞌ goll Jesúsenꞌ leꞌe: —Bi gonoꞌ kaꞌ. Naꞌll bdaneꞌ nay beꞌnnenꞌ, naꞌ bayakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Naꞌll goll Jesúsenꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnnenꞌ nak xan beꞌnn kaꞌ llap yodaꞌo braonꞌ, naꞌ beꞌnn gor brao ke beꞌnn Israel kaꞌ, zjake lljeꞌx Leꞌen: —Ka beꞌnn lljeꞌx to beꞌnn wan, zaꞌre noꞌxre yay naꞌ spad. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yeo lla blleꞌrenaꞌ reꞌ yodaꞌo braonꞌ, naꞌ bi beꞌxre nadaꞌ, zan nnaꞌ bllin lla gak kanꞌ lleꞌnerenꞌ, nnaꞌ nnebiaꞌ da xcholenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Naꞌ beꞌx akeꞌ Jesúsenꞌ, naꞌ bcheꞌe akeꞌ Leꞌe rill bxoz braonꞌ, Pedronꞌ bnaweꞌ Leꞌe ziꞌt ziꞌt. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Beꞌnn kaꞌ bxhen akeꞌ to yiꞌ xhen liaꞌ ke bxozenꞌ, naꞌ blleꞌrén Pedronꞌ leakeꞌ lloaꞌ yiꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","To noꞌr nak wete, ka breꞌreꞌ Pedronꞌ llieꞌ lloaꞌ yiꞌn, naꞌ bwieꞌ leꞌe, naꞌ bneꞌe: —Beꞌnn ni leskaꞌ nakeꞌ txhen Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Naꞌ Pedronꞌ bi bchebeꞌ, naꞌ bneꞌe: —Noꞌre, bi nombiaꞌ beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gok choll kate beꞌnn yobre breꞌreꞌ leꞌe, naꞌ bneꞌe: —Renkze rweꞌn nakoꞌ beꞌnn kaꞌ txhen. Naꞌll bne Pedronꞌ: —Beꞌnne, bi nak akeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bixha ka gok choll kate beꞌnn yobre bneꞌe: —Da likze, beꞌnn ninꞌ nakeꞌ txhen ren Jesúsenꞌ, le nakeꞌ beꞌnn Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Naꞌ Pedronꞌ golleꞌ beꞌnnenꞌ: —Beꞌnne, bi nnezraꞌ bi diꞌllenꞌ lloeꞌo. Naꞌ neteꞌ kaꞌn, kate le bllellte lekwnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Xanllonꞌ le bayechjteꞌ bwieꞌ Pedronꞌ, naꞌ jadinraꞌll Pedronꞌ kanꞌ goll Jesúsenꞌ leꞌe: “Bire nne kwell lekwnꞌ nnaꞌ lleꞌ, llinte gak chonn ras, bi weꞌo diꞌll nombiaꞌo nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedronꞌ ballojeꞌ ganꞌ llaꞌa beꞌnn kaꞌ, da xhen gokreꞌ, naꞌ bllelleꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Beꞌnn kaꞌ llap Jesúsenꞌ, bzorao lltitj akreꞌ Leꞌe, naꞌ llon akeꞌ ziꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bchej akeꞌ to raꞌll raweꞌn, naꞌ llbaꞌll akeꞌ yichjraweꞌn, naꞌ lle akeꞌ Leꞌe: —Banneyaꞌchk, ¿nonꞌ braꞌll rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Naꞌ da zan da lle akeꞌ Leꞌe, llaꞌdyiꞌ akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka byeniꞌn, badop beꞌnn gor brao ke beꞌnn Israel kaꞌ, naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌll goxh akeꞌ Jesúsenꞌ ganꞌ ze akeꞌn, le leakeꞌn llon yel koxchisenꞌ. Ka bllineꞌn lle akeꞌ Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Bne chaꞌ, ¿rweꞌn Cristonꞌ? Chaꞌ rweꞌn, bne netoꞌ kwasro. Naꞌ lleꞌe leakeꞌ: —Chenak nniaꞌ reꞌ, ni ke chejleꞌzre. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Chenak nadaꞌ wnnabraꞌ reꞌ, ni ke yelliꞌzre xtiꞌllaꞌn, ni ke yesanzre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naꞌ soraozen nnaꞌ, Beꞌnnenꞌ Gorj Radj Beꞌnnach lljachieꞌ kwit Diosenꞌ, beꞌnn nak yel wak xhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yeolol akeꞌ goll akeꞌ Leꞌe: —¿Rweꞌn Xhiꞌnn Diosenꞌ chaꞌ? Naꞌll bneꞌe: —Reꞌn nere kaꞌ, naꞌ kaꞌn naksen. ");
INSERT INTO zpuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Naꞌll bne akeꞌ: —Nollno beꞌnn yálljello gao xhia keꞌe; kwinllo ba bénello kanꞌ bneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yeolol beꞌnn kaꞌ llaꞌn bzollaꞌa akeꞌ, naꞌ bcheꞌe akeꞌ Jesúsenꞌ jwaꞌa akeꞌ Leꞌe rao Poncio Pilato, beꞌnnenꞌ llnebiaꞌ Judea. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Naꞌ bzorao llao akeꞌ xhia, llxoa akeꞌ doꞌl koꞌll Jesúsenꞌ rao Pilatonꞌ, ne akeꞌ: —Beꞌnn ni deꞌe llonchixreꞌ beꞌnne, naꞌ ll-lloneꞌ chixhjtoꞌ danꞌ llnnab Césarenꞌ, neꞌe leꞌen Cristonꞌ, naꞌ nakeꞌ to beꞌnn wnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Naꞌll Pilatonꞌ bnnabreꞌ Leꞌe: —¿Rweꞌn nakoꞌ Rey ke beꞌnn Israel kaꞌ? Naꞌll ballieꞌ xtiꞌll Pilatonꞌ, bneꞌe: —Kanꞌ bnekzoꞌ naꞌ nakaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Naꞌll Pilatonꞌ lleꞌe bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llaꞌa naꞌ: —Ni to da xhinnj bi non beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Naꞌ yezikre llchieꞌ akreꞌ, ne akeꞌ: —Llonchixreꞌ beꞌnne doxhen ganꞌ nbane Judea, bzoraozeꞌ Galilea naꞌte, naꞌ ba braꞌte ganni. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ka bene Pilatonꞌ bwaꞌl akeꞌ Galilea, naꞌ bnnabeꞌ chaꞌ beꞌnn Galilea Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ka bnnezreꞌ beꞌnn Galilea Jesúsenꞌ, naꞌll bseꞌleꞌ Leꞌe rao Herodes naꞌ, le leꞌen llnebiaꞌ Galileanꞌ, naꞌ rao lla naꞌ zo Herodes, Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodesenꞌ ka breꞌreꞌ Jesúsenꞌ, le bawereꞌ, le batnaꞌte llenreꞌ lloeꞌ akeꞌ xtiꞌll Jesúsenꞌ, naꞌ le lleꞌnreꞌ reꞌreꞌ yel wak danꞌ lloneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Da zan da bnnabreꞌ Leꞌe, naꞌ bi balliꞌkze Jesúsenꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Naꞌ le zete bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, llao akeꞌ xhia llchieꞌ aktekzreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Naꞌ Herodesenꞌ ren wakaꞌa ya keꞌe kaꞌ, bzorao ziꞌchiꞌll akeꞌ Jesúsenꞌ, lltitj akreꞌ Leꞌe. Naꞌ bwakw akeꞌ Leꞌe to raꞌll da llaktit, naꞌ baseꞌleꞌ Leꞌe rao Pilatonꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lla naꞌ, Pilatonꞌ ren Herodes baniꞌt akeꞌ wen, le kere zo akeꞌ wen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Naꞌll Pilatonꞌ batopeꞌ bxoz kaꞌ, naꞌ beꞌnn wnebiaꞌ kaꞌ, naꞌ bal beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Naꞌ lleꞌe leakeꞌ: —Reꞌ badwaꞌre beꞌnnenꞌ rawaꞌ, naꞌ nere llonchixreꞌ beꞌnne. Llwiátere nga ba bnnabyollreꞌ, bibi da xhinnj non beꞌnnenꞌ ka danꞌ lltóberenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ba bseꞌleꞌ rao Herodesenꞌ, leskaꞌ bibi da xhinnj breꞌreꞌ noneꞌ, bibi doꞌl keꞌe de, da llayaꞌl gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Naꞌ wkwaꞌnneꞌ rallnaꞌa beꞌnn kaꞌ chintat akeꞌ Leꞌe, naꞌll yesaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Naꞌ llonen bien wsaneꞌ to beꞌnne yoꞌ rill ya lla naꞌ, kanꞌ llak toto lla lnni paskw. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Naꞌ beꞌnn zan kaꞌ llaꞌn, bzorao llosiaꞌ akeꞌ ne akeꞌ: —¡Gat beꞌnnenꞌ, naꞌ basán Barrabásenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabásenꞌ yoeꞌ rill ya, le bwiereꞌ beꞌnn kaꞌ llnebiaꞌ, bxieꞌ to wdil rao yell, naꞌ beneꞌ xhia. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatonꞌ lleꞌnreꞌ wsaneꞌ Jesúsenꞌ, naꞌ golleꞌ leakeꞌ chaꞌ wsaneꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Naꞌ beꞌnn kaꞌ, yezikre besiaꞌ akeꞌ, ne akeꞌ: —¡Bdeꞌe leꞌ yay cruz! ¡Bdeꞌe leꞌ yay cruz! ");
INSERT INTO zpuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Da wyonn ras golleꞌ leakeꞌ: —¿Bixha da xhinnj beneꞌ naꞌn? Bi nna lljadiꞌraꞌ chaꞌ bi da xhinnj beneꞌ da llayaꞌl gateꞌ. Wsaꞌkzieꞌ, naꞌll yesaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Naꞌ beꞌnn kaꞌ ze akeꞌ llchieꞌ akreꞌ, naꞌ llosiaꞌ akeꞌ llnnab akeꞌ gat Jesúsenꞌ leꞌ yay cruzenꞌ, naꞌ kaꞌ da bnez leakeꞌ gok. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatonꞌ bchoyraꞌlleꞌ gak kanꞌ lleꞌn akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naꞌ bsaneꞌ beꞌnnenꞌ llnnab akeꞌn, Barrabásenꞌ, beꞌnnenꞌ bxe wdil, naꞌ beneꞌ xhia. Naꞌ beneꞌ Jesúsenꞌ rallnaꞌa akeꞌ, nench gon akreꞌ Leꞌe kanꞌ lleꞌn akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Naꞌ bcheꞌe akeꞌ Leꞌe, brej akeꞌ Leꞌe yell Jerusalén naꞌ, naꞌ tnez naꞌ, ballay akreꞌ to beꞌnn re Simón beꞌnn Cirene zazeꞌe lyiꞌxe, naꞌ bdaꞌa akeꞌ yay cruzenꞌ koꞌlleꞌ, naꞌ noeꞌn bnaweꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Beꞌnn zan beꞌnn yell nao Leꞌe, naꞌ ren bal noꞌre. Naꞌ bell noꞌr kaꞌ, llak akreꞌ ke nak llwia akeꞌ kanꞌ llon akreꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Naꞌ Jesúsenꞌ bayechjeꞌ, lleꞌe leakeꞌ: —Reꞌ noꞌr Jerusalén, bi kwellre kiaꞌ, lekwell ke kwinre, naꞌ ke xhiꞌnnre. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Le wllin lla kate nne akeꞌ: “Nbaraz ke noꞌr will, naꞌ noꞌr bi bxhan, naꞌ bi zo xhiꞌnneꞌ llwaꞌlleꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kanaꞌ to nnab akeꞌ bix yaꞌ kaꞌ kwenen leakeꞌ, naꞌ to nnab akeꞌ kaꞌ bdinnj nench kwaꞌchen leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chaꞌ ki llon akreꞌ nadaꞌ, nakaꞌ ka yay yaꞌ, gon aktellreꞌ reꞌ, nakre ka yay yeche. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Leskaꞌ ncheꞌe akeꞌ ye chop beꞌnn wen da xhinnj got akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ka bllin akeꞌ latj ganꞌ nziꞌi Llit Yichj Beꞌnn Wat, naꞌ bdaꞌa akeꞌ Jesúsenꞌ leꞌ yay cruzenꞌ, ren beꞌnn wen da xhinnj kaꞌ ye chope, bdaꞌa akeꞌ leakeꞌ chlaꞌ weje. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kate bne Jesúsenꞌ: —Xa, bxhiꞌxhen ke beꞌnn ki, le bi nnez akreꞌ binꞌ llon akeꞌ. Naꞌ bditjen akeꞌ xharaꞌneꞌn, llwia akeꞌ naraꞌchk norenꞌ llayaꞌl toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Beꞌnn zan kaꞌ, ze akeꞌ ziꞌtre llwia akeꞌ, naꞌ beꞌnn kaꞌ llnebiaꞌ Israelenꞌ, leskaꞌ ren akeꞌ lltitj akreꞌ Leꞌe, ne akeꞌ: —Beꞌnn yobre basreꞌe, yesrachke kwineꞌ nnaꞌ, chaꞌ leꞌen nak Cristonꞌ bseꞌl Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Leskaꞌ wakaꞌa ya kaꞌ, lltitj akreꞌ Leꞌe, lljabiꞌy akeꞌ lljazé akeꞌ zo zichj lloeꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","naꞌ lleꞌ akeꞌ Leꞌe: —¡Chaꞌ rweꞌn Rey ke beꞌnn Israel kaꞌ, basrachk kwinoꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Naꞌ bllia akeꞌ diꞌll yichj cruzenꞌ, nen: “Beꞌnn ninꞌ Rey ke beꞌnn Israel kaꞌ.” Llian diꞌll griego, naꞌ diꞌll latín, naꞌ diꞌll hebreo. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","To beꞌnn wen da xhinnj kaꞌ, daꞌa leꞌ yay cruzenꞌ, leskaꞌ llaꞌdyieꞌ Jesúsenꞌ, neꞌe: —¡Chaꞌ rweꞌn Cristonꞌ basrá kwinoꞌ, naꞌ basrá ren netoꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Naꞌ beꞌnn lwelljeꞌn ye to, benreꞌ leꞌe znia, lleꞌe leꞌe: —Rennriz rweꞌ nneꞌo, naꞌ bi llapoꞌ Diosenꞌ baraꞌnne, llwiateꞌo leskaꞌn ba daꞌllo ganni gatllo. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lliꞌo daꞌllo ganni llallayraollo, le kaꞌ llayaꞌl gakse kellonꞌ, le da xhinnjenꞌ benllo, zan beꞌnn ni, bibi da xhinnj beneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naꞌll golleꞌ Jesúsenꞌ: —Lljadinraꞌllchgoꞌ nadaꞌ katenꞌ zaꞌo nnebiaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Naꞌll Jesúsenꞌ golleꞌ leꞌe: —Da li llniaꞌ rweꞌ, nnaꞌ llate serenoꞌ nadaꞌ latj wen ganꞌ zo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kanꞌ bllin wawillenꞌ, gok xchol rao yellrionꞌ bllinte do lladá chonne. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bill bnnaꞌ willenꞌ, naꞌ raꞌll danꞌ ze lo yodaꞌo Jerusalén naꞌ, blleꞌzen goken chopre. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Naꞌll Jesúsenꞌ besieꞌ zillj, bneꞌe: —Xa, llonaꞌ rallnaꞌo Spíritu kiaꞌn. Ka bayoll bneꞌe kaꞌn, goteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naꞌ ze beꞌnnenꞌ nak xan wakaꞌa ya kaꞌ, ka breꞌreꞌ kanꞌ goken, beꞌraweꞌ Dios bneꞌe: —Da likze beꞌnn wen beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Beꞌnn zan kaꞌ llaꞌa llwianꞌ, ka breꞌe akreꞌ danꞌ goken, bazaꞌa akeꞌ llbaꞌll lchoꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Naꞌll beꞌnn kaꞌ nombiaꞌ Jesúsenꞌ, ren noꞌr kaꞌ nao Leꞌen Galileate, ze akteꞌ ziꞌtre llwia akeꞌ kanꞌ llaken. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","To beꞌnn re José beꞌnn Arimatea, yell ga nbane Judea, nakeꞌ txhen beꞌnn kaꞌ llnebiaꞌ Israelenꞌ, naꞌ nakeꞌ beꞌnn wen, beꞌnn wen da zej lixheje. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Bzotezeꞌ brexheꞌ katenꞌ wroeꞌ Diosenꞌ yel llnebiaꞌ keꞌen, naꞌ bi beneꞌ txhen lwelljeꞌ kaꞌ, ke nak danꞌ ben akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Byejeꞌ rao Pilatonꞌ jannabeꞌ kwerp ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Naꞌ baletjeꞌ Jesúsenꞌ leꞌ yay cruzenꞌ, naꞌ braꞌlleꞌ Leꞌe to xchan, naꞌ bkwaꞌcheꞌ Leꞌe. Broeꞌ Leꞌe to lo ba kob, to broj da beneꞌ leꞌ yej ga nono nna lljachoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naken lla llsiniaꞌ akeꞌ ke lnninꞌ, naꞌ le llinte lla nbaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Naꞌ noꞌr kaꞌ zaꞌa ren Jesúsenꞌ Galileate, bnaorén akeꞌ beꞌnn kaꞌ nlen Jesúsenꞌ, naꞌ breꞌe aktereꞌ ganꞌ broꞌ akeꞌ Leꞌen, naꞌ kanꞌ bxoa akeꞌ kwerp keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bde naꞌ, bazaꞌa akeꞌ jenchaꞌo akeꞌ za da la xhix, naꞌ nis da la xhix da wtop akeꞌ kwerp ke Jesúsenꞌ. Naꞌ le byoꞌ akteꞌ lla nbane ke beꞌnn Israel kaꞌ, naꞌ baziꞌraꞌll akeꞌ kanꞌ ne leyenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ka bllin lla nell ke xhman naꞌ, ka le zaꞌte cheniꞌ, txhonnj noꞌr kaꞌ, jakeꞌ ganꞌ zo broj danꞌ nak banꞌ, noꞌx akeꞌ danꞌ benchaꞌo akeꞌ, danꞌ la xhix. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ka bllin akeꞌ naꞌ, breꞌe akreꞌ bill daꞌa yejenꞌ lloaꞌ banꞌ, ba daꞌten chlaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka byoꞌ akeꞌ lo banꞌ, bill ballel akreꞌ kwerp ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bixha naꞌ ze akeꞌ llon akeꞌ yel wan ke danꞌ bill xhoa kwerp ke Jesúsenꞌ, kate bllin chop beꞌnn jasé akeꞌ kwit akeꞌn, llaktit xharaꞌn beꞌnn kaꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Blleb noꞌr kaꞌ, naꞌ bcheꞌk xhib akeꞌ llwia akteꞌ rao yore, naꞌll goll beꞌnn kaꞌ leakeꞌ: —To beꞌnn ban, ¿bixchen llayirjzreꞌ radj beꞌnn wat kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nollno xhoa ganni, ba babaneꞌ. Lelljadinraꞌll kanꞌ nna zorenteꞌ reꞌ ganꞌ nziꞌi Galilea naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","bneꞌe dekz de gakeꞌ rallnaꞌa beꞌnn kaꞌ llwie Leꞌen, naꞌ got akeꞌ Leꞌe leꞌ yay cruzenꞌ, naꞌ wayónn lla yebaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Naꞌll jadinraꞌll noꞌr kaꞌ xtiꞌll Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Naꞌ bazaꞌa akeꞌ lloaꞌ banꞌ, jatixjweꞌ akreꞌ beꞌnn chnej kaꞌ, naꞌ ren beꞌnn kaꞌ nak leakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ki re noꞌr kaꞌ: María beꞌnn Magdala, Xhuan, naꞌll María xhnaꞌ Jacobo, naꞌ ye to chop noꞌr yobre, leakeꞌn bdixjweꞌ akreꞌ postl kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Naꞌ beꞌnn chnej kaꞌ, llak akreꞌ bi diꞌll ke nxhianꞌ lloeꞌ noꞌr kaꞌ, naꞌ bi byejleꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Naꞌ Pedronꞌ bzollaꞌdoeꞌ byejeꞌ jawieꞌ banꞌ, naꞌ ka bllineꞌn, raꞌllenꞌ bchel akeꞌ Jesúsenꞌ, naꞌze xhoan, naꞌ bazeꞌe llabanreꞌ ka danꞌ breꞌreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lekze lla naꞌ, chop beꞌnn kaꞌ bnao Leꞌen, zjakeꞌ to yell re Emaús, naꞌ Emaúsenꞌ llgoꞌnnen ka chonn hor nez saꞌllo Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Zjakeꞌ lloeꞌ akeꞌ diꞌll ke da kaꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chak zjak akeꞌ lloeꞌ akeꞌ diꞌllenꞌ kaꞌ, kate bllin Jesúsenꞌ jabiꞌyeꞌ kwit akeꞌn, naꞌ zejreneꞌ leakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naꞌ chaokze ben Diosenꞌ nench bi wayombiaꞌ akreꞌ Leꞌe, laꞌkze llwia akteꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Naꞌll lleꞌe leakeꞌ: —¿Bi diꞌllenꞌ lloeꞌre chak yoꞌre nezenꞌ? ¿Bixchen zoyaꞌchre? ");
INSERT INTO zpuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","To beꞌnnenꞌ re Cleofas, lleꞌe Leꞌe: —¿Bixha tozoꞌ rweꞌ nakoꞌ beꞌnn ziꞌt zoꞌo Jerusalén naꞌ, bi bnnezroꞌ bi gok do nej nnase? ");
INSERT INTO zpuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naꞌll lleꞌe leakeꞌ: —¿Bixha gok? Naꞌ bne akeꞌ: —Danꞌ gok ke Jesús beꞌnn Nazaretenꞌ, gokeꞌ to beꞌnn beꞌe xtiꞌll Dios. Beꞌnn yell bayakbeꞌe akreꞌ xtiꞌlleꞌn nsaꞌn yel wak, naꞌ yeolol danꞌ beneꞌn, beneꞌn kon ren yel wak ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Naꞌ bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn kaꞌ llnebiaꞌ netoꞌ, ben akeꞌ Leꞌe rao naꞌa beꞌnn kaꞌ llwie Leꞌen, naꞌ bchoybiaꞌ akeꞌ llayaꞌl gateꞌ, naꞌll bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Netoꞌ lláketoꞌ Leꞌen gakreneꞌ Israelenꞌ, nench bill nnebiaꞌ beꞌnn ziꞌt kaꞌ len. Naꞌ nnaꞌ ba zejzen da wyonn lla gok kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naꞌ leskaꞌ llabánetoꞌ ka diꞌllenꞌ lloeꞌ noꞌr kaꞌ non netoꞌ txhen naꞌ, byej akeꞌ beꞌe bale, ka za cheniꞌ ganꞌ bkwaꞌch akeꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Naꞌ bill breꞌe akreꞌ kwerp keꞌen, naꞌ ne akeꞌ breꞌe akreꞌ angl ak, naꞌ goll angl kaꞌ leakeꞌ nbankzeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naꞌll bal beꞌnn byio kaꞌ naktoꞌ txhen naꞌ, byej akeꞌ lloaꞌ banꞌ, naꞌ doxhen kanꞌ ne noꞌr kaꞌ, kaꞌ nakten nono Jesúsenꞌ breꞌe akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Naꞌll goll Jesúsenꞌ leakeꞌ: —¡Yichj war kwis nakre, bi llejleꞌre danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Kere llian, zgaꞌtek wallayrao Cristonꞌ, naꞌtellenꞌ wroeꞌreꞌ yel llnebiaꞌ keꞌen? ");
INSERT INTO zpuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Naꞌ bzorao llroeꞌreꞌ leakeꞌ xtiꞌll Diosenꞌ ganꞌ llian lloeꞌn diꞌll ke Leꞌe. Bxhiꞌzen yich danꞌ bzoj da Moisésenꞌ, naꞌll danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, bzorao llroeꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Naꞌ llakte kaꞌn, kate bllin akeꞌ yellenꞌ ganꞌ zjakeꞌn, naꞌ Leꞌen beneꞌ ka beꞌnn zej ye raꞌte ziꞌtre. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Naꞌ goꞌtyoe akreꞌ Leꞌe, nench gaꞌyreneꞌ leakeꞌ, lle akeꞌ Leꞌe: —Goꞌyrén netoꞌ, ba wlleꞌ nnaꞌ, la galte. Naꞌll goꞌyreneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bixha gok, ka blleꞌ akeꞌ ganꞌ gao akeꞌ naꞌ, bxhieꞌ yet xtirenꞌ, naꞌ beꞌe yel llioxken ke Dios, naꞌ bxhoxhjeꞌn beꞌen leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kanaꞌll gok akeꞌ ka beꞌnn baxhaꞌ rao, bayombiaꞌ akreꞌ Leꞌe. Naꞌ Leꞌen to baranzeꞌ rao akeꞌn, bill breꞌe akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naꞌll lle lwellj akeꞌ: —To llawé raꞌlldaꞌollonꞌ ke nak zaꞌllo tnezenꞌ, llroeꞌreꞌ lliꞌo kwasro xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naꞌ ne akteꞌ kaꞌ bazaꞌdo akeꞌ zayej akeꞌ Jerusalén naꞌ, kaꞌ ballín akeꞌ ganꞌ llaꞌa beꞌnn chnej kaꞌ, ren beꞌnn kaꞌ yelaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Naꞌ goll beꞌnn chnej kaꞌ leakeꞌ: —Da likzenꞌ babán Xanllonꞌ, ba broeꞌraweꞌ Simón naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Naꞌ beꞌnn kaꞌ chop, leskaꞌ beꞌe akeꞌ diꞌll kanꞌ gok zjakeꞌ tnezenꞌ, naꞌ kanꞌ gok ka bxhoxhjeꞌ yet xtir naꞌ, bayombiaꞌ akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Naꞌ llaꞌa akteꞌ lloeꞌ akeꞌ diꞌllenꞌ, kate bllinkze Jesúsenꞌ jaseꞌe kllol akeꞌn, naꞌ bwapeꞌ leakeꞌ lliox, bneꞌe: —Chaꞌchga reꞌ wen. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Blleb akeꞌ kwis, naꞌ llabán akreꞌ, llak akreꞌ chaꞌ llreꞌdaꞌo akreꞌn o chaꞌ bxen naꞌ llreꞌe akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naꞌ lleꞌe leakeꞌ: —¿Bixchen llebre? ¿Bixchen llakgánere? ");
INSERT INTO zpuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lewiá taꞌkaꞌ ni, naꞌ niaꞌn, nadkzaꞌn. Lekán nadaꞌ, ke nak to bxen, bill naken de llit, naꞌ beꞌre kanꞌ nakaꞌ nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ka neꞌe kaꞌn, llroeꞌtereꞌ leakeꞌ nieꞌn naꞌ taꞌkeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Naꞌll bawé akreꞌ kwis, to llon akeꞌ ka beꞌnn bi llejleꞌ, naꞌ llabán akreꞌ kwis, naꞌll Jesúsenꞌ lleꞌe leakeꞌ: —¿Bi de raꞌt da gawaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Naꞌll beꞌe akeꞌ Leꞌe raꞌt belyaꞌ, naꞌ raꞌt chiꞌxh beser. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Llwia akteꞌ bdaweꞌ da kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Naꞌll lleꞌe leakeꞌ da yobre: —Kaꞌ bnetekzaꞌ kanꞌ nna zorenaꞌ reꞌ, dekz de gak kiaꞌ kanꞌ nyoj leꞌ ley danꞌ bzoj da Moisésenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, naꞌ danꞌ llia leꞌ yich ke Salmos kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naꞌll beneꞌ nench byejnieꞌ akreꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naꞌ bneꞌe: —Gok kanꞌ nyojkze gak ke Cristonꞌ, yellayraweꞌ, naꞌ gateꞌ, naꞌ yebaneꞌ wayónn lla. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Naꞌtellenꞌ llayaꞌl nneze beꞌnne xtiꞌlleꞌn, siꞌzen Jerusalén naꞌ, llinte doxhen yellrio nnez akreꞌ llayaꞌl wayat akreꞌ, yebiꞌraꞌll akeꞌ nench yeziꞌxhen Diosenꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Naꞌ reꞌ llayaꞌl weꞌre diꞌll ke doxhen da ki ba goken. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naꞌ wseꞌlaꞌ Spíritu ke Diosenꞌ, choꞌn lo yichjraꞌlldaꞌore, le kaꞌn bcheb Xaꞌn. Jerusalén naꞌze chaꞌre, kwexhre llinte lla siꞌre yel wak da zaꞌa yebá. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Naꞌ bchach Jesúsenꞌ leakeꞌ Jerusalén naꞌ, bllin akteꞌ Betania, naꞌ blis taꞌkeꞌn benlaꞌyeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bayoll benlaꞌyeꞌ leakeꞌn, naꞌ bayepeꞌ zayejteꞌ yebá, baziꞌi Diosenꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Naꞌ beꞌrao akeꞌ Leꞌe. Bayoll naꞌ, zayej akeꞌ Jerusalén naꞌ, llawé akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Naꞌ bzeteze bze akeꞌ yodaꞌo braonꞌ lloeꞌrao akeꞌ Diosenꞌ. Kaꞌn gakchga.");
INSERT INTO zpuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kanꞌ bxhete yellrionꞌ, ba zokze beꞌnnenꞌ nziꞌi Diꞌlle, naꞌ zorenkzeꞌ Dios naꞌ, naꞌ Lekzeꞌn Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ba zorenkzeꞌ Diosenꞌ kanꞌ bxhe yellriote. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Leꞌen beneꞌ yeolol da de. Bibi de, da bxhe to wrazze da bi ben beꞌnnenꞌ nziꞌi Diꞌll. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Leꞌen nseꞌe yel nban, naꞌ yel nban keꞌe naꞌ, naken ka to beniꞌ danꞌ nseniꞌ yichjraꞌlldaꞌo yeolol beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Beniꞌn nseniꞌn ganꞌ nak xchole, naꞌ da xcholenꞌ bi bzoen wkweꞌjen beniꞌ keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bzo to beꞌnn re Juan, naꞌ bseꞌl Diosenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan naꞌ beꞌe diꞌll ke beꞌnnenꞌ nsaꞌa beniꞌ naꞌ, nench byejleꞌ yeolol beꞌnnach keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kere Juan naꞌn nak beꞌnnenꞌ nsaꞌa beniꞌn, badezeꞌ diꞌll ke beꞌnnenꞌ nsaꞌa beniꞌ ke yichjraꞌlldaꞌo beꞌnnachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ba bllin lla braꞌ beniꞌ danꞌ nak dogarje, ba braꞌn yellrio ni, nench wseniꞌn yichjraꞌlldaꞌo noteze beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Beꞌnnenꞌ nziꞌi Diꞌll ba zokzeꞌ yellrio ni. Laꞌkze Leꞌen beneꞌ yellrionꞌ, beꞌnn kaꞌ llaꞌa yellrio ni, bi gokbeꞌe akreꞌ noxhanꞌ nakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Gorjeꞌ radj beꞌnn wrall keꞌe kaꞌ, naꞌ zan beꞌnn wrall keꞌe kaꞌ, bi byejleꞌ akeꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bal akzeꞌ byejleꞌ akeꞌ keꞌe, naꞌ beꞌnn kaꞌ llonliraꞌll Leꞌen, beneꞌ nench nak akeꞌ xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naꞌ kere nnello nak akeꞌ xhiꞌnn Dios danꞌ gorj akeꞌ niꞌt xaxhnaꞌ akeꞌ naꞌzenꞌ. Naꞌ lekze kere nak akeꞌ xhiꞌnn Dios, danꞌ bzorén to beꞌnn byio to noꞌre naꞌ bzo xhiꞌnn akeꞌn, naꞌ leskaꞌ kere danꞌ goꞌne beꞌnn byio so xhiꞌnneꞌ naꞌn; zan danꞌ benliraꞌll akeꞌ Leꞌe naꞌ, naꞌllenꞌ non Diosenꞌ leakeꞌ ka xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Naꞌ beꞌnnenꞌ nziꞌi Diꞌll gorjeꞌ gokeꞌ beꞌnnach, naꞌ bzoreneꞌ netoꞌ. Naꞌ breꞌtoꞌ nakeꞌ to beꞌnn zaꞌk xhen kwis, le toze Leꞌen nakeꞌ dogarje Xhiꞌnn Diosenꞌ, nllieꞌreꞌ lliꞌo beꞌnnach, badzejnieꞌreꞌ lliꞌo diꞌll li ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan naꞌ beꞌe diꞌll keꞌe, bneꞌe: —Diꞌll ke beꞌnn ninꞌ badiaꞌ kanꞌ bniaꞌn: “Beꞌnnenꞌ za zaꞌa, zaꞌklleꞌ ka nadaꞌ, le ba zokze Leꞌen kanꞌ bi nna soaꞌ nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Leꞌen nllieꞌreꞌ lliꞌo kwis yeolol lliꞌo llonliraꞌll Leꞌe, zokzeꞌ llakreneꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Le da Moisésenꞌ bzejnieꞌreꞌ ley ke Diosenꞌ da xozxtaꞌollo beꞌnn Israel kaꞌ, naꞌ Jesucristonꞌ beꞌnnenꞌ bed naꞌ, badroeꞌre nllieꞌ Diosenꞌ lliꞌo beꞌnnach, naꞌ badzejnieꞌreꞌ lliꞌo diꞌll li ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nono zo beꞌnn ba breꞌreꞌ Diosenꞌ, toze Xhiꞌnneꞌ tiꞌch naꞌ, beꞌnnenꞌ nak dogarje Xhiꞌnn Dios beꞌnnenꞌ zeteze zeꞌe kwiteꞌ, Leꞌen ba bzejnieꞌreꞌ lliꞌo beꞌnnach, kanꞌ nak yichjraꞌlldaꞌo Xallo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Naꞌ beꞌnn kaꞌ llnebiaꞌ beꞌnn Israel kaꞌ llaꞌa Jerusalén naꞌ, bseꞌl akeꞌ to chop bxoz kaꞌ, naꞌ ye bale beꞌnn gorje rao dialla da Leví, beꞌnn llakrén bxoz kaꞌ, nench jannab akreꞌ Juan naꞌ noxha leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Naꞌ golleꞌ leakeꞌ lixheje: —Kere nadaꞌn Cristonꞌ beꞌnnenꞌ bexhllo yedenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Naꞌll lle akeꞌ leꞌe: —¿Noxha rweꞌ chaꞌ? ¿Rweꞌn Elías beꞌnnenꞌ beꞌe xtiꞌll Dios kanaꞌ chaꞌ? Naꞌll lleꞌe leakeꞌ: —Kere nadkzaꞌn. Naꞌll bnnab akreꞌ leꞌe da yobre: —¿Rweꞌn nakoꞌ beꞌnnenꞌ yedtixjweꞌ netoꞌ xtiꞌll Dios chaꞌ? Naꞌll golleꞌ leakeꞌ: —Kere nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Naꞌll bnnab akreꞌ leꞌe da yobre: —¿Noxha rweꞌ chaꞌ? Nench yetoꞌ beꞌnn kaꞌ bseꞌl netoꞌ kaꞌ. ¿Bixha nekzoꞌ ke kwinoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Naꞌll goll Juan naꞌ leakeꞌ: —Nadaꞌn nakaꞌ beꞌnn nne zillj to latj dach, niaꞌ: “Lewasarj to nez li ganꞌ te Xanllonꞌ”, kanꞌ bne da Isaías beꞌnnenꞌ bdixjweꞌ xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Naꞌ beꞌnn kaꞌ jak rao Juan naꞌ, beꞌnn fariseo akeꞌn bseꞌl leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Naꞌll lle akeꞌ leꞌe: —¿Bixchen llchoaꞌo beꞌnne nis, chaꞌ bi nakoꞌ Cristo, naꞌ ni ke nakzoꞌ Elías, naꞌ ni beꞌnnenꞌ bexhtoꞌ yed yedyeꞌe xtiꞌll Dios naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Naꞌll lle Juan naꞌ leakeꞌ: —Nadaꞌ llchoaꞌ beꞌnne nis, zan radjre naꞌ, ba zo to beꞌnne bi nna gombiaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Leꞌen za wroeꞌraweꞌ reꞌ, naꞌ zaꞌklleꞌ ka nadaꞌ, naꞌ danꞌ nakeꞌ beꞌnn zaꞌk naꞌ, ni ke zaꞌkzaꞌ nadaꞌ, ni jeze xhereꞌ ke gak wlechjaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yeolol da kinꞌ gok ganꞌ nziꞌi Betábara, danꞌ lliꞌ chlaꞌ yeo Jordán ganꞌ llchoa Juan naꞌ beꞌnn kaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Naꞌ bateyó breꞌe Juan naꞌ, zej Jesúsenꞌ ganꞌ zeꞌe naꞌ, naꞌll lle Juan naꞌ beꞌnn kaꞌ nao leꞌen: —Lewiá ke ganni zaꞌa beꞌnnenꞌ ba brej Diosenꞌ, nench yedkeꞌe xtoꞌl beꞌnnach. Beꞌnn ninꞌ nakeꞌ ka xhiꞌr daꞌo ba llot lliꞌo beꞌnn Israel, nench llaziꞌxhen Diosenꞌ ke xtoꞌl-llo. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ke Leꞌen biaꞌa diꞌll, bniaꞌ: “Beꞌnnenꞌ za zaꞌa zaꞌklleꞌ ka nadaꞌ, naꞌ Leꞌen ba zokzeꞌ ka bi nna soaꞌ nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naꞌ bi bnnezraꞌ noxhanꞌ nakeꞌ, bixha Dios naꞌ bzejnieꞌreꞌ nadaꞌ, ke len naꞌ zaꞌa zadchoaꞌ beꞌnne nis, nench nneze yeolol beꞌnn Israel kaꞌ noxhanꞌ nakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Leskaꞌ bne Juan naꞌ: —Breꞌraꞌ betj Spíritu ke Diosenꞌ yebánꞌ, bllinen ganꞌ zo Jesúsenꞌ. Bllinen naken ka to plom daꞌo, naꞌ bagaꞌnnrenen Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nadaꞌ bi gokbeꞌraꞌ chaꞌ nakeꞌ beꞌnnenꞌ bseꞌl Dios, Dios beꞌnnenꞌ bseꞌl nadaꞌ llchoaꞌ beꞌnne nis golleꞌ nadaꞌ: “Nnaꞌ reꞌkeroꞌ ka yetj Spíritu kiaꞌn, naꞌ yegaꞌnnrenen beꞌnnenꞌ ba nbejaꞌ naꞌ. Le leꞌen nakeꞌ beꞌnnenꞌ wzo Spíritu kiaꞌn lo yichjraꞌlldaꞌo beꞌnne.” ");
INSERT INTO zpuNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naꞌ ba breꞌraꞌ ba gok kanꞌ bneꞌe naꞌ, naꞌllenꞌ lloaꞌ diꞌll, beꞌnn ninꞌ Xhiꞌnn Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bateyó da yobre zerén Juan naꞌ ye chop beꞌnn kaꞌ nao Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ka breꞌreꞌ bde Jesúsenꞌ, naꞌll lleꞌe beꞌnn kaꞌ: —Lewiá ke beꞌnnenꞌ bseꞌl Diosenꞌ, beꞌnn naꞌn nakeꞌ ka xhiꞌr daꞌo banꞌ llot lliꞌo beꞌnn Israel, nench llaziꞌxhen Diosenꞌ da xhinnj kaꞌ nonllo. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Naꞌ beꞌnn chop kaꞌ nao Juan naꞌ, ka ben akreꞌ kanꞌ bneꞌen, naꞌll zjakdoeꞌ jannao akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ka bayechj Jesúsenꞌ llwieꞌ nao akeꞌ Leꞌen, naꞌll lleꞌe leakeꞌ: —¿Bixhanꞌ lleꞌnere? Naꞌll lle akeꞌ Leꞌe: —Rabí (lleꞌnen nen beꞌnn llzejnieꞌ beꞌnne), ¿gaxhanꞌ zoꞌo? ");
INSERT INTO zpuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Naꞌll golleꞌ leakeꞌ: —Lechoꞌo naꞌ reꞌkere. Naꞌll byejrén akeꞌ Leꞌe, naꞌll breꞌe akreꞌ ganꞌ zoeꞌn, naꞌll bagaꞌnnrén akeꞌ Leꞌe rao lla naꞌ, le ba nak ba wlleꞌ, ba llonen ka do lladá tap. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Naꞌ beꞌnn chop kaꞌ bzenay xtiꞌll Juan naꞌ, bnao akeꞌ Jesúsenꞌ, toeꞌ re Andrés, biꞌch Simón Pedronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Naꞌll Andrés naꞌ, le jadirjteꞌ bi biꞌcheꞌn re Simón naꞌ. Naꞌll lleꞌe leꞌe: —Ba ballaytoꞌ beꞌnnenꞌ ne akeꞌ Mesías. (Naꞌ Mesías naꞌ lleꞌnen nen Cristo.) ");
INSERT INTO zpuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naꞌll bcheꞌe Andrésenꞌ beꞌnn biꞌcheꞌn ganꞌ zo Jesúsenꞌ. Naꞌ ka breꞌe Jesúsenꞌ Simón naꞌ, naꞌll lleꞌe leꞌe: —Rweꞌn Simón xhiꞌnn Jonás, rweꞌ wsiꞌtoꞌ Cefas. (Naꞌ Cefas naꞌ lleꞌnen nen Pedro.) ");
INSERT INTO zpuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bateyó bayej Jesúsenꞌ Galileanꞌ, naꞌ jadiꞌreꞌ Felipenꞌ, naꞌ lleꞌe leꞌe: —Choꞌ ren nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipenꞌ nakeꞌ beꞌnn yellenꞌ nziꞌi Betsaida ganꞌ nak rall Andrésenꞌ, ren Pedro naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Naꞌ Felipenꞌ jawieꞌ Natanaelenꞌ, naꞌll lleꞌe leꞌe: —Ba breꞌtoꞌ beꞌnnenꞌ bzoj da Moisésenꞌ xtiꞌlleꞌ leꞌ leyenꞌ kanaꞌ, naꞌ lekze xtiꞌll Leꞌen bzoj beꞌnn kaꞌ bdixjweꞌ xtiꞌll Diosenꞌ kanaꞌ. Leꞌen Jesús beꞌnn Nazaret, xhiꞌnn José. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naꞌll Natanaelenꞌ bneꞌe: —¿Wllojrize da wen Nazaretenꞌ lla? Naꞌll lle Felipenꞌ leꞌe: —Choꞌ ke reꞌroꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka breꞌe Jesúsenꞌ ba zej Natanaelenꞌ ganꞌ zeꞌe naꞌ, naꞌll bneꞌe: —Gannaꞌ zaꞌa to beꞌnn nak dogarje beꞌnn Israel, ni raꞌt bi nakeꞌ beꞌnn wxhiyeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ka bene Natanaelenꞌ kanꞌ ne Jesúsenꞌ, naꞌll lleꞌe Leꞌe: —¿Akxha gok nombiaꞌo nadaꞌ? Naꞌll lle Jesúsenꞌ leꞌe: —Breꞌraꞌ rweꞌ kanꞌ zeꞌo xhan yay higonꞌ, kanꞌ za nne Felipenꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naꞌll ne Natanaelenꞌ: —Maestro, rweꞌn nakoꞌ dogarje Xhiꞌnn Dios. Rweꞌn nakoꞌ beꞌnnenꞌ bexhtoꞌ yednnebiaꞌ rall-llo Israelenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Naꞌll lle Jesúsenꞌ leꞌe: —¿Danꞌ niaꞌ breꞌraꞌ rweꞌ xhan yay higo naꞌn, naꞌllenꞌ llejleꞌo kiaꞌ? Za reꞌllroꞌ da zaꞌkll ye raꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Leskaꞌ bneꞌe: —Diꞌll li, diꞌll li niaꞌ reꞌ: Nnaꞌ reꞌre leꞌ yebánꞌ ganꞌ zo Diosenꞌ gaken ka to da yarje, naꞌ beꞌnn kaꞌ nak angl keꞌe kaꞌ, chep chetj akeꞌ ganꞌ zoaꞌ nadaꞌn Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bayónn lla goꞌt to yel wachaynaꞌa yell ganꞌ nziꞌi Caná ganꞌ nbane Galilea. Naꞌ xhnaꞌ Jesúsenꞌ byejeꞌ ganꞌ gok yel wachaynaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Naꞌ leskaꞌ goxh akeꞌ Jesúsenꞌ, naꞌ ren beꞌnn kaꞌ non Leꞌen txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naꞌt babillkze xis uvanꞌ lleꞌj akeꞌ ganꞌ llak lnninꞌ, naꞌll xhnaꞌ Jesúsenꞌ golleꞌ Leꞌe: —Billbi xis uva ke beꞌnn kaꞌ de. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Naꞌll lle Jesúsenꞌ leꞌe: —¿Bixchen neꞌo kaꞌ? Renchaꞌ bi nna llin lla wroeꞌrawaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naꞌll lle xhneꞌen beꞌnn kaꞌ dá llwia bi da yallj rao lnni naꞌ: —Legón kon binꞌ neꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naꞌ zjazó xop yeꞌs de yej, ga llgaꞌa akeꞌ nis da llonrén beꞌnn Israel kaꞌ llin da llayib kwin akeꞌ kon kanꞌ llia leꞌ ley naꞌ. Naꞌ toto yeꞌs kaꞌ lloll aken do chop chonn lleꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Naꞌll goll Jesúsenꞌ beꞌnn kaꞌ dá llwia bi da yallj rao lnni naꞌ: —Leyesllaꞌa nis lo yeꞌs kaꞌ. Naꞌll bdaꞌa akeꞌn nis ballaꞌa akten. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Naꞌll lleꞌe leakeꞌ: —Legaꞌch raꞌtenꞌ, naꞌ leweꞌn beꞌnnenꞌ nak rallnaꞌa lnni naꞌ. Naꞌll ben akeꞌ kanꞌ bneꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Naꞌ beꞌnnenꞌ nak rallnaꞌa lnninꞌ kon bnixeꞌn, naꞌ bi nnezreꞌ ga zaꞌn, kon beꞌnn kaꞌ dá llwia bi da kaꞌ yallj rao lnni naꞌze, nnez akreꞌ nisenꞌ bayak xis uvanꞌ, le leakeꞌn goꞌch akeꞌ nisenꞌ. Naꞌ beꞌnnenꞌ bnix len naꞌ, goxheꞌ beꞌnn byionꞌ llchaynaꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","naꞌll lleꞌe leꞌe: —Yeololte beꞌnn kaꞌ llon lnninꞌ, llde akeꞌ xis uva chaꞌon ka zorao lnni naꞌ, naꞌ kat ba weꞌj akeꞌ da xhen, naꞌll zorao akeꞌ llde akeꞌ xis uva da bi naktek wen naꞌ. Naꞌt rweꞌ nzaꞌyoꞌ xis uva chaꞌon, lldeꞌon nnaꞌll ba llayoll lnninꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kaꞌn ben Jesúsenꞌ yell Canánꞌ ganꞌ nbane Galileanꞌ, goken yel wak nell danꞌ beneꞌ nench broeꞌreꞌ nakeꞌ beꞌnn zaꞌk xhen, naꞌ benliraꞌll beꞌnn kaꞌ non Leꞌe txhen naꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bde naꞌ, byejeꞌ ganꞌ nziꞌi Capernaum ren xhneꞌe naꞌ, ren biꞌcheꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ naꞌze goꞌy akeꞌ to chop chonn lla. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naꞌ ba zo gaꞌl lnni Paskw ke beꞌnn Israel kaꞌ, naꞌ byej Jesúsenꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ka bllineꞌ liaꞌ yodaꞌo braonꞌ, beꞌnn zan zjallaꞌa lloꞌt akeꞌ no bell, no xhiꞌre, no plom, ba llonrén akeꞌ llin kat llayoeꞌxhen akeꞌ Dios, naꞌ zjalliꞌ beꞌnn llchaꞌa ak mell. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ka breꞌe Jesúsenꞌ kanꞌ llaken, naꞌ beneꞌ to sot nench bachacheꞌ yeolol beꞌnn kaꞌ zjallaꞌa liaꞌ yodaꞌon, yeolol no bell kaꞌ lloꞌt akeꞌn, no xhiꞌr kaꞌ ren beꞌnn kaꞌ llchaꞌa mell kaꞌ, beseꞌ xhmell akeꞌn rao yo, naꞌ blloꞌnneꞌ ganꞌ nkwaꞌa akeꞌ xhmell akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Naꞌll golleꞌ beꞌnn kaꞌ lloꞌt plomenꞌ: —Leyechach yeolol ba ki ganni. Bi gonre yaꞌa rill Xaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Naꞌll jadinraꞌll beꞌnn kaꞌ non Leꞌe txhen naꞌ, kanꞌ nyoj xtiꞌll Diosenꞌ ganꞌ nen: “Danꞌ lliꞌ yichjaꞌ kwis ke rilloꞌn zaꞌkziaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Naꞌ beꞌnn Israel kaꞌ llasné akeꞌ: —¿Bi yel wak wroeꞌroꞌ netoꞌ, nench chejleꞌtoꞌ koꞌo zaꞌkoꞌ bachachoꞌ beꞌnn kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naꞌll balliꞌi Jesúsenꞌ xtiꞌll akeꞌn, lleꞌe leakeꞌ: —Leyechinnjchek yodaꞌo ni, naꞌ chonn llaze wayontiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Naꞌll beꞌnn Israel kaꞌ, goll akeꞌ Leꞌe: —Xopayon (46) iz blle akreꞌ, ka ben akeꞌ yodaꞌon. ¿Naꞌ rweꞌ wayonchkoꞌn chonn llaze? ");
INSERT INTO zpuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bixha Jesúsenꞌ kwineꞌn bsaꞌkreꞌ yodaꞌon bneꞌe kaꞌ, naꞌ llake leakeꞌn chaꞌ yodaꞌo naꞌkzenꞌ neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Naꞌ ka bllin lla babaneꞌ radj beꞌnn wat kaꞌ, beꞌnn kaꞌ non Leꞌe txhen naꞌ, jadinraꞌll akeꞌ kanꞌ bneꞌen, naꞌll byejleꞌ akeꞌ xtiꞌll Diosenꞌ danꞌ nyoj keꞌe naꞌ, leskaꞌ benliraꞌll akeꞌ xtiꞌll Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Naꞌ chak zo Jesúsenꞌ lnni Paskwnꞌ Jerusalén naꞌ, beꞌnn zan breꞌe akreꞌ yel wak kaꞌ beneꞌn, naꞌll byejleꞌ akeꞌ keꞌe, nakseꞌ beꞌnn bseꞌl Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bixha Jesúsenꞌ bi gotraꞌlltekeꞌ radj beꞌnn kaꞌ, le nombieꞌ yichjraꞌlldaꞌo akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bi byalljreꞌ no ye Leꞌe bi xhbab yoꞌ lo yichjraꞌlldaꞌo beꞌnn kaꞌ. Kwinkzeꞌ nnezreꞌ binꞌ yoꞌ lo yichjraꞌlldaꞌo toto beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bzo to beꞌnn fariseo beꞌnn golle Nicodemo. Gokeꞌ to beꞌnne wnebiaꞌ ke yell Israelenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Byejeꞌ rao Jesúsenꞌ tlleꞌlre, naꞌ lleꞌe Leꞌe: —Maestro, nnézetoꞌ bseꞌl Diosenꞌ rweꞌ nench wzejnieꞌroꞌ netoꞌ, le nono gak gon ka yel wak kaꞌ llonoꞌn, chaꞌ bi zorén Diosenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Naꞌll lle Jesúsenꞌ leꞌe: —Diꞌll li, diꞌll li niaꞌ rweꞌ, chaꞌ nonꞌ bi yeyarjeꞌ ye to, bi gak reꞌreꞌ Diosenꞌ ganꞌ llnebieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Naꞌll lle Nicodemonꞌ leꞌe: —¿Akxha gon to beꞌnne yeyarjeꞌ ye to, chaꞌ ba nakeꞌ beꞌnn gore? ¿Waklle yeyoeꞌ lo leꞌe xhneꞌen, naꞌ yeyarjeꞌ ye to? ");
INSERT INTO zpuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Naꞌll goll Jesúsenꞌ leꞌe: —Diꞌll li, diꞌll li niaꞌ rweꞌ, chaꞌ nonꞌ bi yeyarjeꞌ ren nis, naꞌ ren Spíritu ke Diosenꞌ, bi gak lljazoeꞌ ganꞌ zo Diosenꞌ llnebieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Beꞌnn llarjeꞌ rao dialla beꞌnnach, lekze beꞌnnachkze leꞌe. Naꞌ beꞌnn llarjeꞌ rao Spíritu ke Diosenꞌ, leꞌen de yel nban danꞌ lloeꞌ Spíritunꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bi yebanroꞌ danꞌ bniaꞌ: “Llonen bien yeolol beꞌnne de yeyarjeꞌ ye to.” ");
INSERT INTO zpuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kat llechj beꞌ, llechjen gateze, naꞌ llenroꞌ llolyoyen, naꞌ bi nnezroꞌ ga zaꞌn, naꞌ ni ke nnézzeroꞌ ga zejen. Kaꞌkzenꞌ naken ke yeolol beꞌnn kaꞌ llon Spíritu ke Diosenꞌ nench llayarj akeꞌ ye to da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naꞌll lle Nicodemonꞌ Leꞌe: —¿Akxha gak kanꞌ neꞌo ni? ");
INSERT INTO zpuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Naꞌll lle Jesúsenꞌ leꞌe: —Rweꞌ llzejnieꞌroꞌ beꞌnn Israel kaꞌ xtiꞌll Dios, ¿bi llejnieꞌroꞌ da ki? ");
INSERT INTO zpuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Da li netoꞌ llyixjweꞌtoꞌ da nnézetoꞌ, naꞌ lloeꞌtoꞌ diꞌll ke da ba breꞌtoꞌ, naꞌ bi llejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ba biaꞌa diꞌll danꞌ llak yellrio ni, naꞌ bi llejleꞌre. ¿Akxha gakrize chejleꞌre chenak niaꞌ reꞌ danꞌ llak yebá naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Notno nna wayep yebánꞌ, toze nadaꞌ zaꞌa yebánꞌ nakaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kanꞌ gok latj dachenꞌ kanaꞌ, kanꞌ ben da Moisésenꞌ to bel de ya chaꞌon nziꞌi bronce, naꞌ bdeꞌebaꞌ to leꞌ yay, kaꞌn llayaꞌl gak wdaꞌa akeꞌ nadaꞌ to leꞌ yay, nadaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kaꞌn gak kiaꞌ nench noteze beꞌnn gonliraꞌlle nadaꞌ bi kwiayieꞌ, naꞌ gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Kaꞌn nllieꞌ Diosenꞌ lliꞌo beꞌnnach, naꞌllenꞌ bseꞌleꞌ Xhiꞌnneꞌ tiꞌchenꞌ nench noteze beꞌnne gonliraꞌlle Leꞌe bi kwiayieꞌ, naꞌ gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diosenꞌ bi bseꞌleꞌ Xhiꞌnneꞌn yellrio ni, nench goneꞌ da wsaꞌkziꞌ beꞌnnach, zan bseꞌleꞌ Leꞌe nench yesreꞌe leakeꞌ rao da xhinnj ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Noteze beꞌnne gonliraꞌll akeꞌ Xhiꞌnn Dios beꞌnn tiꞌch naꞌ, bi yellayrao akeꞌ ke doꞌl ke akeꞌn, naꞌ beꞌnn kaꞌ bi gonliraꞌll akeꞌ Leꞌe, ba nlloyen ke akeꞌ saꞌkziꞌ akeꞌ ke chnare, le bi llonliraꞌll akeꞌ Xhiꞌnn Dios beꞌnn tiꞌch naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kanꞌ naken, ke beꞌnn kaꞌ bi llonliraꞌll Xhiꞌnn Diosenꞌ, ba nlloyen ke akeꞌ, saꞌkziꞌ akeꞌ ke chnare, le ba bed Xhiꞌnn Diosenꞌ, nseꞌe beniꞌ ke yichjraꞌlldaꞌo beꞌnnach, bixha leakeꞌ naꞌn, llawé akllereꞌ danꞌ nak da xcholenꞌ kerke beniꞌn, le da kaꞌ llon akeꞌ naꞌ, naken da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yeololte beꞌnn kaꞌ llon da xhinnjenꞌ, llwie akreꞌ beniꞌ keꞌen, naꞌ bi llazraꞌll akeꞌ wzenay akeꞌ keꞌe, nench ke wroeꞌrawe da xhinnj kaꞌ llon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Zan beꞌnn kaꞌ llon kanꞌ llia diꞌll li ke Diosenꞌ, llawé akreꞌ lljabiꞌy akeꞌ ganꞌ nseniꞌ beniꞌ ke Diosenꞌ, len llroeꞌn zokze Diosenꞌ llakreneꞌ leakeꞌ, nench llon akeꞌ kanꞌ llia diꞌll li keꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bde naꞌ byej Jesúsenꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, yell daꞌo kaꞌ zjalliꞌ do ganꞌ nbane Judeanꞌ, naꞌ chak zo akeꞌ naꞌ, bchoeꞌ beꞌnne nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Naꞌ leskaꞌ bchoa Juan naꞌ beꞌnn ak nis yell ganꞌ nziꞌi Enón danꞌ lliꞌ kwitze Salim, le naꞌ de nis xhen, naꞌ jak beꞌnn kaꞌ ganꞌ bzoeꞌn nench bchoeꞌ leakeꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kaꞌn gok ka bi nna koꞌ akeꞌ Juan naꞌ rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Naꞌ beꞌnn kaꞌ nao Juan naꞌ, goꞌd diꞌll lwellj akeꞌ ren beꞌnn Israel kaꞌ, akrenꞌ llayaꞌl gon beꞌnne nench yeyak akeꞌ xhiraꞌll rao Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Naꞌll byej akeꞌ rao Juan naꞌ, naꞌ lle akeꞌ leꞌe: —Maestro, beꞌnnenꞌ bzo ren rweꞌ ye chlaꞌ yeo Jordán naꞌ, beꞌnnenꞌ lloeꞌo xtiꞌll naꞌ, ba llchoeꞌ beꞌnne nis, naꞌ yeololze beꞌnne lljakeꞌ ganꞌ zoeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Naꞌll lle Juan naꞌ leakeꞌ: —Bibi yedoꞌl beꞌnnachenꞌ chaꞌ bi weꞌe Diosenꞌ len. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nnézkzere kanꞌ ba bniaꞌn, kere Cristo naꞌ, nadaꞌ, beꞌnnenꞌ bseꞌl Diosenꞌ yednnebieꞌ lliꞌo. Zan nadaꞌ nakaꞌ beꞌnn bseꞌl Dios nench blliarawaꞌ badiaꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kat llak to yel wachaynaꞌa, toze beꞌnn byio naꞌ ziꞌi noꞌrenꞌ. Naꞌ beꞌnnenꞌ nak txhen beꞌnn byionꞌ llchaynaꞌn zereneꞌ leꞌe, llawereꞌ ka nak llzenayeꞌ kanꞌ ne beꞌnnenꞌ llchaynaꞌn. Kanꞌ llakraꞌ nadaꞌ, llaweraꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Le Leꞌen llayaꞌl chejlleꞌ gon beꞌnne Leꞌe xhen, naꞌ nadaꞌ llayaꞌl yeyexjaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Leskaꞌ bne Juan naꞌ: —Ka nak Cristonꞌ beꞌnnenꞌ zaꞌa ganꞌ llia Diosenꞌ, Leꞌen nakeꞌ beꞌnn zaklle ka yeolol beꞌnne. Naꞌ beꞌnnach nak beꞌnn ke yellrio nize, diꞌll da de yellrio ni lloeꞌ. Naꞌ beꞌnnenꞌ zaꞌa ganꞌ llia Dios naꞌ, zaꞌklleꞌ ka yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Leꞌen lloeꞌ diꞌll ke danꞌ ba breꞌreꞌn, naꞌ diꞌll ke danꞌ ba benreꞌ ganꞌ llia Diosenꞌ, naꞌ nono llzenay xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Naꞌ beꞌnnenꞌ llzenay xtiꞌll beꞌnnenꞌ zaꞌa yebá naꞌ, leꞌen llroeꞌreꞌ lloeꞌ Diosenꞌ diꞌll li. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Beꞌnnenꞌ bseꞌl Diosenꞌ, lekzeꞌn lloeꞌ xtiꞌll Diosenꞌ, le Spíritu ke Dios naꞌ zerenen Leꞌe, naꞌ kat Diosenꞌ weꞌe Spíritu keꞌen, bi llyiseꞌ raꞌt wejen. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Diosenꞌ nllieꞌreꞌ Xhiꞌnneꞌ Cristonꞌ, naꞌ ba beneꞌ rallneꞌe yeolol bi da de keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Naꞌ beꞌnn kaꞌ llonliraꞌll Xhiꞌnn Diosenꞌ, de yel nban zejlikane ke akeꞌ, zan beꞌnn kaꞌ bi llzenay ke Diosenꞌ, bibi yel nban ke beꞌnn kaꞌ gaꞌte, le Dios naꞌ goneꞌ saꞌkziꞌ akeꞌ ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Naꞌll Jesúsenꞌ gokbeꞌreꞌ ba bnneze beꞌnn fariseo kaꞌ, naꞌ ne akeꞌ: beꞌnn zanll nao Jesúsenꞌ, naꞌ beꞌnn zanlle llchoeꞌ nis ka beꞌnn kaꞌ llchoa Juan naꞌ nis, ");
INSERT INTO zpuNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(laꞌkze kere kwin Jesúsenꞌ bchoeꞌ beꞌnn nis, beꞌnn kaꞌ non Leꞌe txhen naꞌ, llchoaꞌ akeꞌ nis). ");
INSERT INTO zpuNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Naꞌll ka bnneze Jesúsenꞌ kaꞌ, bazeꞌe Judeanꞌ bayejeꞌ Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Naꞌ dekze de yedieꞌ Samaria naꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ka goken ballineꞌ to yell da nziꞌi Sicar ga nbane Samaria, to yell da lliꞌ kwitze ganꞌ de yellrio danꞌ beꞌe da Jacobenꞌ xhiꞌnneꞌ Josénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Gannaꞌ llia to bej da nake zitj kwis, danꞌ nziꞌi Bej ke da Jacob. Ka do wawillenꞌ ba lljaxaꞌke Jesúsenꞌ zayoeꞌ nez, naꞌ jallieꞌ lloaꞌ bejenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ka bllin to noꞌr Samarianꞌ lloaꞌ bejenꞌ zjaxieꞌ nis. Naꞌll lle Jesúsenꞌ leꞌe: —Benn raꞌt nis yeꞌjaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, zjakeꞌ lyell zjaxiꞌi akeꞌ da gaorén akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naꞌll lle noꞌr Samarianꞌ Leꞌe: —¿Bixchen llnnabzeroꞌ nadaꞌ nis yeꞌjoꞌ, le beꞌnn Israel rweꞌ, naꞌ noꞌr Samaria nadaꞌ? (Le beꞌnn Israel kaꞌ, bi llalwill lwellj akeꞌ ren beꞌnn Samaria kaꞌ.) ");
INSERT INTO zpuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Naꞌll lle Jesúsenꞌ Leꞌe: —Nadaꞌ niaꞌ kaꞌ: “Benn raꞌt nis yeꞌjaꞌ”, naꞌ chenak llayakbeꞌroꞌ danꞌ lleꞌne Diosenꞌ gonneꞌ rweꞌ, naꞌ wayakbeꞌroꞌ noxha nadaꞌ, naꞌ ba bnnabroꞌ nadaꞌ, naꞌ bennaꞌ rweꞌ nis danꞌ llonn yel nban zejlikane chenake. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naꞌ noꞌrenꞌ lleꞌe Leꞌe: —Beꞌnne, bi noꞌxoꞌ da gaꞌchoꞌn le nak bejenꞌ zitj. ¿Gaxha siꞌo nis danꞌ llonn yel nban naꞌ, neꞌo kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Llakroꞌ zaꞌklloꞌ ka da xozxtaꞌollo Jacobenꞌ, beꞌnnenꞌ bkwaꞌnnrén netoꞌ bej ni, ganꞌ weꞌjrén xhiꞌnneꞌ kaꞌ nis, naꞌ ren no bayiꞌx keꞌe kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesúsenꞌ lleꞌe leꞌe: —Noteze beꞌnne yeꞌj nis ke bej ni, dekze bilreꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Naꞌ noteze beꞌnne yeꞌjeꞌ nis danꞌ weꞌe nadaꞌ, chras bill bilkzereꞌ, le danꞌ weꞌe nadaꞌn gaken lo raꞌlldaꞌweꞌ ka to latje ga llraꞌ nis, nench gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naꞌll lle noꞌrenꞌ Leꞌe: —Beꞌnne, bennchek nadaꞌ nisenꞌ neꞌo kaꞌ nench bill yedaꞌ yedxiaꞌn gannite. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Naꞌll lle Jesúsenꞌ leꞌe: —Jalwill xhyiꞌo, naꞌ dareneꞌ ganni. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naꞌll lleꞌe Jesúsenꞌ: —Notno xhyiwaꞌ zo. Naꞌll lle Jesúsenꞌ leꞌe: —Rennkzroꞌ kanꞌ bneꞌon nono xhyiꞌo zo, ");
INSERT INTO zpuNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","le gaꞌy beꞌnn ba bzorenoꞌ, naꞌ beꞌnnenꞌ zorenoꞌ nnaꞌ, kere xhyiꞌon. Da li kanꞌ bneꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Naꞌll lle noꞌrenꞌ Leꞌe: —Beꞌnne, llakzraꞌ nakjeꞌo to beꞌnne llayixjweꞌ bi da ne Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Da xozxtaꞌo netoꞌ beꞌnne Samaria, bxenraꞌll akeꞌ Diosenꞌ rao yaꞌn zo ganni, naꞌ reꞌ nakre beꞌnn Israel, nere Jerusalén naꞌn llayaꞌl gonxhenlloeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesúsenꞌ lleꞌe leꞌe: —Noꞌre, byejleꞌ kiaꞌ, wllin lla kat bill yedre rao yaꞌ nite, yedyeꞌraore Xallo Diosenꞌ, ni Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Reꞌ nakre beꞌnn Samaria bi nombiaꞌyaꞌnnre Dios beꞌnnenꞌ lloeꞌraorenꞌ. Zan netoꞌ beꞌnn Israel, nombiaꞌtoꞌ Dios beꞌnnenꞌ nxenraꞌlltoꞌn, naꞌ radjtoꞌ ni lloj to beꞌnn yebejeꞌ beꞌnnach rao da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wllin lla, naꞌ nnaꞌ ba bllinen, kat beꞌnn gon Xallo Diosenꞌ xhen dogarje, naꞌ weꞌrao akeꞌ Leꞌe kone yel wak ke Spíritu keꞌen, naꞌ weꞌrao akeꞌ Leꞌe kanꞌ llayaꞌle, le Xallo Diosenꞌ llayirjeꞌ beꞌnne weꞌrao Leꞌe ki. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosenꞌ nakeꞌ Spíritu, naꞌllenꞌ beꞌnn kaꞌ weꞌrao Leꞌen, llayaꞌl weꞌrao akeꞌ Leꞌe kanꞌ llayaꞌle kone Spíritu keꞌe naꞌkze. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Naꞌll lle noꞌrenꞌ Leꞌe: —Nnezraꞌ wed beꞌnn ba brej Diosenꞌ beꞌnnenꞌ nziꞌi Mesías, Leꞌen Cristo, naꞌ kate yedeꞌ naꞌ, yedzejnieꞌreꞌ lliꞌo yeolol da ki. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naꞌll lle Jesúsenꞌ leꞌe: —Nadaꞌ nakaꞌ beꞌnnenꞌ neꞌo kaꞌ, naꞌ lloeꞌrenaꞌ rweꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nna lloeꞌrente Jesúsenꞌ noꞌrenꞌ diꞌll kaꞌ, ka ballindo beꞌnn kaꞌ non Leꞌe txhen naꞌ lloaꞌ bejenꞌ. Naꞌ babán akreꞌ lloeꞌreneꞌ to noꞌre diꞌlle, naꞌ bitbi goll akseꞌ Leꞌe bi diꞌllenꞌ lloeꞌreneꞌ noꞌrenꞌ, naꞌ bixchen lloeꞌrenzeꞌ leꞌe diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Naꞌll bkwaꞌnn lleꞌ nis ke noꞌrenꞌ naꞌze, naꞌ bayejeꞌ yellenꞌ jayelleꞌ beꞌnn wrall keꞌe kaꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Lechoꞌke wiare to beꞌnn ba golleꞌ nadaꞌ yeolol da ba benaꞌ. ¿Kere Leꞌen Cristonꞌ lla, beꞌnnenꞌ ne akeꞌ yedenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naꞌll bllachdo akeꞌ yellenꞌ zjakeꞌ ganꞌ lliꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Naꞌ chak zayej noꞌrenꞌ, beꞌnn kaꞌ non Jesúsenꞌ txhen naꞌ, llaꞌtyoe akreꞌ Leꞌe, lle akeꞌ Leꞌe: —Maestro, bdao. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naꞌll lleꞌe leakeꞌ: —De to yel wao kiaꞌ da bi nna gombiaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Naꞌll lle lwellj akeꞌ: —¿Kere no ba badwaꞌrize da bdaweꞌn lla? ");
INSERT INTO zpuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Naꞌll lle Jesúsenꞌ leakeꞌ: —Yel wao kiaꞌn naken gonaꞌ kanꞌ llazraꞌll Diosenꞌ, beꞌnnenꞌ bseꞌl nadaꞌ nench gak yeolol da zeraꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Reꞌ nere: “Nna dell ye tap beꞌo yedop danꞌ gozllonꞌ.” Naꞌ nadaꞌ niaꞌ, lewiá ke danꞌ naz akeꞌ rao yellrio, ba byechen ba lleꞌnen yedopen. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Beꞌnn llon ka beꞌnn llon wrap, ba lloneꞌ llin nench gaꞌt yel nban zejlikane ke beꞌnn llzenay xtiꞌll Diosenꞌ. Naꞌ beꞌnn kaꞌ llyixjweꞌ xtiꞌll Diosenꞌ, naꞌ rente beꞌnn kaꞌ llon nench wzenay beꞌnn xtiꞌlleꞌ naꞌ, nniꞌt akeꞌ txhen nbaraz. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Diꞌll ni naken da li nen: “Beꞌnn yobre llaz naꞌ, naꞌ beꞌnn yobre llarape.” ");
INSERT INTO zpuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ba llseꞌlaꞌ reꞌ lljarapre ganꞌ bi gozre, le reꞌ gonre wzenay beꞌnne xtiꞌll Diosenꞌ danꞌ ba bdixjweꞌ beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Naꞌ beꞌnn Samaria kaꞌ, zaneꞌ benliraꞌll Jesúsenꞌ danꞌ ben akreꞌ bne noꞌrenꞌ: “Ba golleꞌ nadaꞌ yeolol da ba benaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Naꞌllenꞌ bllin beꞌnn Samaria kaꞌ ganꞌ lliꞌ Jesúsenꞌ, naꞌ goꞌtyoe akreꞌ Leꞌe yegaꞌnnreneꞌ leakeꞌ, naꞌll bagaꞌnnreneꞌ leakeꞌ chop lla. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Naꞌ beꞌnn zanlle benliraꞌll Jesúsenꞌ ka ben akreꞌ diꞌll da kaꞌ beꞌreneꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Naꞌll lle akeꞌ noꞌrenꞌ: —Ba byejleꞌtoꞌ naꞌ, kere danꞌ bénetoꞌ xtiꞌlloꞌ naꞌzenꞌ, ba bénkzetoꞌ lloeꞌ kwineꞌ diꞌlle, naꞌ ba bnnézetoꞌ Leꞌen Cristonꞌ beꞌnnenꞌ yesrá beꞌnn kaꞌ llaꞌa yellrio. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka gok chop lla naꞌ, bazaꞌa Jesúsenꞌ Samarianꞌ zjayakeꞌ Galileanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwinkze Jesúsenꞌ ba beꞌe diꞌll neꞌe, noteze beꞌnne llyixjweꞌ bi da ne Diosenꞌ, bi llap beꞌnn wrall keꞌe kaꞌ leꞌe baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ka ballín akeꞌ Galileanꞌ, beꞌnn yell kaꞌ bareb akeꞌ Jesúsenꞌ, le ba breꞌe akreꞌ yeolol da wen naꞌ beneꞌ rao lnni Jerusalén naꞌ, le renkze leakeꞌn jakeꞌ lnninꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Naꞌ bayej Jesúsenꞌ da yobre yell Caná, danꞌ lliꞌ ganꞌ nbane Galileanꞌ ganꞌ beneꞌ bayak nisenꞌ xis uva, naꞌ yell Capernaum naꞌ, bzo to beꞌnn non reyenꞌ rallneꞌe yel llnebiaꞌ, naꞌ llak xhiꞌnneꞌn yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ka benreꞌ ba bllin Jesúsenꞌ Galileanꞌ zazeꞌe Judea, naꞌll byejeꞌ jelleꞌ Jesúsenꞌ chejeꞌ lljayeneꞌ xhiꞌnneꞌn, le ba lleꞌnen goten lebeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Naꞌll lle Jesúsenꞌ leꞌe: —Chenak bi llreꞌre yel wak kiaꞌn, bi chejleꞌre kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naꞌll lle beꞌnnenꞌ Leꞌe: —Beꞌnne, yoꞌkeroꞌ chaga bi nna gat xhiꞌnnaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Naꞌll lle Jesúsenꞌ leꞌe: —Bayejdo, bi gat xhiꞌnnoꞌn. Naꞌll byejleꞌ kanꞌ goll Jesúsenꞌ leꞌe, naꞌll bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ye raꞌtz yellineꞌ naꞌn, kat jatil beꞌnn wen llin keꞌe kaꞌ leꞌe, naꞌll lle akeꞌ leꞌe: —Ba bayakte xhiꞌnnoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naꞌll bnnabreꞌ leakeꞌ ka do bi hor bzorao bacheꞌbeꞌ, naꞌll lle akeꞌ leꞌe: —Neje lladá to bde wawill, ballachbeꞌ da lanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naꞌll llakreꞌ ka hor naꞌkzenꞌ goll Jesúsenꞌ leꞌe bi gatbeꞌ. Naꞌll benliraꞌlleꞌ Jesúsenꞌ, leꞌe naꞌ, ren yeolol beꞌnn kaꞌ llaꞌa rilleꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Da ni yel wak wllopenꞌ ben Jesúsenꞌ kanꞌ zazeꞌe Judeanꞌ, naꞌ ballineꞌ Galileanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bde naꞌ gok ye to lnni ke beꞌnn Israel kaꞌ, naꞌ byej Jesúsenꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kwitze ganꞌ zo reyj ke zeꞌe danꞌ nechj yell naꞌ, danꞌ nziꞌi Reyj ke Xhiꞌre, ga llia to ga yoll nis da nziꞌi Betesda, naꞌ zjazé gaꞌy lchir nkweꞌj kwite ganꞌ yoll nis naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Naꞌ beꞌnn zan beꞌnn weꞌe, zjadé akeꞌ lo lchir kaꞌ, no beꞌnn lchol, no beꞌnn nxhinnj niaꞌ, no beꞌnn nat niaꞌnaꞌa akeꞌ, zjadé akeꞌ bexh akeꞌ batkrenꞌ chas nisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Le twej twejze kat lletj to angl, naꞌ llteꞌe nisenꞌ, naꞌ beꞌnn nellenꞌ lladoꞌl choꞌ lo nisenꞌ llayoll llta anglenꞌ len naꞌ, llayakteꞌ biteze yillweꞌ da llakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Naꞌ de to beꞌnn ba gok chiꞌnchonnalloa (38) iz llakeꞌ yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Naꞌ breꞌe Jesúsenꞌ leꞌe, naꞌ gokbeꞌreꞌ ba gok scha deꞌe kaꞌ, naꞌll lleꞌe leꞌe: —¿Lleꞌnroꞌ wayakoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Naꞌll lleꞌe Jesúsenꞌ: —Nono llraꞌ koꞌ nadaꞌ lo nisenꞌ katenꞌ dan naꞌ. Naꞌ chak zyaꞌ naꞌ, le lldedote beꞌnn yobre lletjeꞌ lo nisenꞌ llagaꞌnntiaꞌ kaꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Naꞌll lle Jesúsenꞌ leꞌe: —Byas naꞌ batob ganꞌ xhoaꞌon, naꞌ badá. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Naꞌll le bayakte beꞌnnenꞌ, naꞌ bazieꞌ ganꞌ bxhoeꞌn, naꞌ bzorao badeꞌe. Naꞌ goken to lla nbaꞌnne ka bi de latj gon beꞌnn Israel kaꞌ llin. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Naꞌ beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ, lle akeꞌ beꞌnnenꞌ bayakenꞌ: —Lla nbaꞌnn nnaꞌ, bi de lsens yeyoaꞌo ganꞌ bxhoaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naꞌll lle beꞌnnenꞌ leakeꞌ: —Beꞌnnenꞌ bayón nadaꞌ Leꞌen goll nadaꞌ: “Batob ganꞌ xhoaꞌo naꞌ badá.” ");
INSERT INTO zpuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naꞌll lle akeꞌ leꞌe: —¿Noxhanꞌ gollze rweꞌ kaꞌ: “Batob ganꞌ xhoaꞌo, naꞌ badá”? ");
INSERT INTO zpuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naꞌ beꞌnnenꞌ bayakenꞌ, bi nnezreꞌ nonꞌ bayón leꞌe, le Jesúsenꞌ to banitzeꞌ radj beꞌnn zan kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bdere badil Jesúsenꞌ beꞌnnenꞌ bayak lo lchir yodaꞌo braonꞌ, naꞌ lleꞌe leꞌe: —Ba bayakoꞌ nnaꞌ, llayaꞌl kwej yichjoꞌ bill gonoꞌ da xhinnj, nench ke gak ye to da ziꞌllore koꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Naꞌll bazaꞌdoeꞌ jayelleꞌ beꞌnn Israel kaꞌ, Jesús naꞌn bayón leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Naꞌll beꞌnn Israel kaꞌ, bzorao blleꞌnao akeꞌ Jesúsenꞌ, naꞌ llayirjlaꞌll akeꞌ akre gon akeꞌ got akeꞌ Leꞌe danꞌ lloneꞌ yel wak kaꞌ lla nbaꞌnne, kat bi de lsens gon beꞌnn Israel kaꞌ llin. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Naꞌll lle Jesúsenꞌ leakeꞌ: —Xaꞌn zokzeꞌ llaraltezreꞌ, leskaꞌkze nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Naꞌll llayirjlaꞌll akeꞌ akre gon akeꞌ nench got akeꞌ Jesúsenꞌ, kere ni ke danꞌ bi lloneꞌ kanꞌ ne ley naꞌ, ganꞌ llwaꞌlen ke lla nbaꞌnne naꞌzenꞌ; danꞌ bneꞌe Diosenꞌ nakeꞌ Xeꞌe, danꞌ zejen toze ka zaꞌkeꞌ ren Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesúsenꞌ lleꞌe leakeꞌ: —Diꞌll li, diꞌll li niaꞌ reꞌ: Bibi llak gonaꞌ to wrazzaꞌ, kon da llreꞌraꞌ llon Xaꞌ naꞌn, len naꞌ llonaꞌ le nakaꞌ Xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Le Xaꞌn nllieꞌreꞌ Xhiꞌnneꞌ, naꞌllenꞌ llroeꞌreꞌ nadaꞌ yeolol danꞌ lloneꞌn, naꞌ wroeꞌreꞌ nadaꞌ da zaꞌklle ka da ki goneꞌ nench yebánere. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kanꞌ llon Xaꞌ Diosenꞌ llasbaneꞌ beꞌnne radj beꞌnn wat kaꞌ, kaꞌkzenꞌ llonaꞌ nadaꞌ nakaꞌ Xhiꞌnneꞌ, lloaꞌ yel nban ke noteze beꞌnne llbejaꞌ nench gaꞌt yel nban ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Naꞌ Xaꞌn bi llchoybieꞌ ke to beꞌnn napeꞌ doꞌle, zan ba beneꞌ rallnaꞌ wchoybiaꞌ ke yeolol beꞌnnach chaꞌ nonꞌ nap doꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Xaꞌn lleꞌnreꞌ yeolol beꞌnne goneꞌ nadaꞌ xhen, naꞌ lekze kaꞌn llonaꞌ Leꞌe xhen, naꞌ beꞌnn bi lloneꞌ nadaꞌ xhen, Xaꞌ Dios naꞌkzenꞌ bi lloneꞌ xhen le Leꞌen bseꞌl nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Diꞌll li, diꞌll li niaꞌ reꞌ, kanꞌ zjazén naꞌ: Beꞌnn llzenay xtiꞌllaꞌn, naꞌ llonliraꞌlleꞌ Dios beꞌnnenꞌ bseꞌl nadaꞌ, de yel nban zejlikane keꞌe, naꞌ bi saꞌkziꞌ akeꞌ chras. Naꞌ bill nak akeꞌ ka beꞌnn wat lo yichjraꞌlldaꞌo akeꞌn, le ba bakobeꞌ yichjraꞌlldaꞌo akeꞌn danꞌ ba llonliraꞌll akeꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Diꞌll li, diꞌll li niaꞌ reꞌ: Wllin lla kat beꞌnn kaꞌ nat yichjraꞌlldaꞌo akeꞌn, yen akreꞌ xtiꞌllaꞌn nakaꞌ Xhiꞌnn Dios, naꞌ beꞌnn wzenay kiaꞌ, waꞌt yel nban zejlikane ke akeꞌ, naꞌ kaꞌn ba bzorao llak nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Xaꞌ Diosenꞌ nseꞌe yel nban zejlikane, naꞌ leskaꞌ beneꞌ nench nadaꞌ nsaꞌa yel nban zejlikane, le Xhiꞌnneꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naꞌ leskaꞌ ba benneꞌ nadaꞌ yel llnebiaꞌ nench nnezraꞌ nonꞌ nap doꞌle, le Leꞌen bseꞌleꞌ nadaꞌ nakaꞌ Beꞌnn Gorj Radj Beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Naꞌ bi yebánere kanꞌ niaꞌ ni, le wllin lla kat yeolol beꞌnn wat llaꞌa lo ba, yen akreꞌ katenꞌ yelwill akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Naꞌ beꞌnn kaꞌ ben da wen chak bzo akeꞌ yellrio ni, yebán akeꞌ, naꞌ ban akeꞌ ke chnare, naꞌ beꞌnn kaꞌ ben da xhinnj chak bzo akeꞌ yellrio ni, yebán akeꞌ saꞌkziꞌ akeꞌ ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Bibi gak gonaꞌ to wrazaꞌ. Le llzenayaꞌ bi danꞌ ne Xaꞌn, nench kaꞌ llonaꞌ yel koxchis ke beꞌnnach. Naꞌ danꞌ niaꞌ gak ke toto beꞌnne lekze da llayaꞌl gaken, le kere niaꞌ kon da lleꞌnraꞌ nadaꞌ gaken, kon ka danꞌ ne Xaꞌ naꞌn gak, beꞌnnenꞌ bseꞌl nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chaꞌ to wrazaꞌ lloaꞌ xtiꞌll kwinaꞌ, bi naken to da chejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Zan beꞌnn yobre lloeꞌ diꞌll li noxhanꞌ nakaꞌ, naꞌ nnezraꞌ danꞌ lloeꞌ kiaꞌn naken da li. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Naꞌ ba bseꞌlre beꞌnne rao Juan naꞌ, nench jannabreꞌ leꞌe akrenꞌ nak kiaꞌn, naꞌ beꞌrén Juan naꞌ reꞌ diꞌll li noxha nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Zan nadaꞌ bi yalljraꞌ ni to diꞌll da weꞌe beꞌnnach kiaꞌ, kon da kizenꞌ niaꞌ reꞌ nench chejleꞌre kiaꞌ nench yesrá Diosenꞌ reꞌ rao da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan naꞌ gokeꞌ ka to yiꞌ da llseniꞌ da xhen danꞌ bzejnieꞌreꞌ reꞌ ke Diosenꞌ, naꞌ choll daꞌon bawere danꞌ bzejnieꞌreꞌ reꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Naꞌ de to da lloeꞌ xtiꞌllaꞌn da zaꞌklle ka diꞌll danꞌ lloeꞌ Juan naꞌ kiaꞌ: llonaꞌ yeolol da ba broꞌ Xaꞌn rallnaꞌ gonaꞌ, naꞌ da kaꞌ llonaꞌn lloeꞌn diꞌll, le Xaꞌ naꞌn bseꞌl nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naꞌ Xaꞌ, beꞌnnenꞌ bseꞌl nadaꞌn leskaꞌ lloeꞌ xtiꞌllaꞌ, laꞌkze bi nna yénere kanꞌ neꞌen, naꞌ bi nna reꞌre kanꞌ nakeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Naꞌ bi nna choꞌ xtiꞌlleꞌn lo yichjraꞌlldaꞌore, le bi llonliraꞌllre nadaꞌ nakaꞌ beꞌnn bseꞌl Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lewsedyaꞌnn xtiꞌll Diosenꞌ, le nnézere nsaꞌn yel nban zejlikane. Naꞌ len naꞌ lloeꞌn diꞌll li kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Naꞌ reꞌ bi lleꞌnere gonliraꞌllre nadaꞌ nench gaꞌt yel nban zejlikane keré. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ka nak nadaꞌ bi llyalljraꞌ nne beꞌnnach kiaꞌ nakaꞌ beꞌnn zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Naꞌ nadaꞌ nombiaꞌ reꞌ, naꞌ nnezraꞌ bi nllieꞌre Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Xaꞌn bseꞌl nadaꞌ llonaꞌ kon da neꞌe, naꞌ bi llejleꞌre kiaꞌ. Naꞌ kat zaꞌk beꞌnn llon akeꞌ ka da llarjlaꞌll akzeꞌ, lereꞌn llejleꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Akxha gak chejleꞌre kiaꞌ nadaꞌn? Le llawere yeyoeꞌrao beꞌnne reꞌ, bi llazraꞌllre gonre nench toze Dios naꞌ nneꞌe llonre wen. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Naꞌ bi gonre xhbab chaꞌ nadaꞌn ll-lliayiꞌllaꞌ reꞌ rao Xaꞌn. Da Moisés naꞌn ll-lliayiꞌlleꞌ reꞌ raweꞌn, le llsedre kwis danꞌ bzojeꞌn llákere zore wen rao Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chenak reꞌ llejleꞌre xtiꞌll da Moisésenꞌ, kiaꞌ nadkzaꞌn llejleꞌre chet kaꞌ, le xtiꞌllaꞌ nadaꞌn bzojeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Naꞌ chaꞌ bi llejleꞌre danꞌ bzojeꞌ naꞌ, ¿akxha gonre chejleꞌre danꞌ llepaꞌ reꞌ naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bde gok kaꞌ, byej Jesúsenꞌ ye chlaꞌ nisdaꞌo Galileanꞌ. Naꞌ nisdaꞌon leskaꞌ nziꞌn nisdaꞌo Tiberias. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Naꞌ beꞌnn zan nao Jesúsenꞌ danꞌ ba breꞌe akreꞌ yel wak danꞌ lloneꞌ llayoneꞌ beꞌnn weꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Naꞌ byep Jesúsenꞌ to rao yaꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, jacheꞌreneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Naꞌ ba zo rez gaꞌle lnni paskw ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Naꞌ ka bwia Jesúsenꞌ beꞌnn zan ba nao ak Leꞌe, naꞌll golleꞌ Felipenꞌ: —¿Gaxha siꞌllo da gao yeolol beꞌnn ki? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bneꞌe kaꞌ naraꞌchek bi ne Felipenꞌ, le nnezkze Leꞌen akrenꞌ goneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Naꞌll lle Felipenꞌ Leꞌe: —Chop gayoa (200) mell danꞌ nziꞌi denario yet xtir, kere waken ni raꞌt wejen bi yellel akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naꞌ ye to beꞌnn non Jesúsenꞌ txhen reꞌe Andrés, nakeꞌ beꞌnn biꞌch Simón Pedro. Naꞌ Andrés naꞌ lleꞌe Leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ganni ze to bidaꞌo, noꞌxbeꞌ gaꞌy yet xtir kebeꞌ da nak de yezj danꞌ nziꞌi cebada, naꞌ ye chop belyaꞌ. Kere bi de gon da ki ke beꞌnn zan ki llaꞌa ganni. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Naꞌll lle Jesúsenꞌ beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ: —Leyé yeolol beꞌnn kaꞌ kweꞌ akeꞌ. Naꞌ gannaꞌ de yix dak, naꞌll blleꞌ beꞌnn kaꞌ rao yixenꞌ, nak akeꞌ ka do gaꞌy mir beꞌnn byio. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Naꞌll bxhiꞌi Jesúsenꞌ yet xtir kaꞌ, beꞌe yel llioxken ke Dios. Bayoll naꞌ, beꞌen beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌ beꞌnn kaꞌ bdislas akeꞌn rao beꞌnn kaꞌ zjalliꞌ naꞌ. Naꞌ leskaꞌ beneꞌ kone belyaꞌ kaꞌ, naꞌ beꞌe totoeꞌ kon ka berj akreꞌ bdao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Naꞌ bayoll badao akeꞌ naꞌ, naꞌll lleꞌe beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Leyetop da kaꞌ bagaꞌnn ye raꞌt wejen nench bitbi kwiayiꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Naꞌll batop beꞌnn kaꞌ da laꞌo kaꞌ bagaꞌnnenꞌ, naꞌ goken ye chllinn (12) llom danꞌ bagaꞌnn rao yet xtir gaꞌy kaꞌ, danꞌ ben akeꞌ de yezj danꞌ nziꞌi cebada. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ka breꞌe beꞌnn kaꞌ yel wak danꞌ beneꞌn, naꞌll ne akeꞌ: —Da li yaꞌnne beꞌnn ninꞌ nak beꞌnnenꞌ bexhllo yedtixjweꞌ lliꞌo xtiꞌll Diosenꞌ yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ka gokbeꞌe Jesúsenꞌ ba ze beꞌnn kaꞌ wcheꞌe akeꞌ Leꞌe nench gon akeꞌ Leꞌe rey ke akeꞌ, naꞌll bazeꞌe, naꞌ byejeꞌ yaꞌ daꞌon tozeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka gol naꞌ, jayak beꞌnn kaꞌ non Leꞌe txhen lloaꞌ nisdaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Naꞌll bayoꞌ akeꞌ to lo barco lljayakeꞌ ganꞌ nziꞌi Capernaum. Ba nak ba gol, naꞌ bi nna yellín Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Naꞌ bzorao llechj beꞌ rao nisdaꞌon, naꞌll llas yitjen. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Naꞌ ka bexte zjayakeꞌn ba bagoꞌ akeꞌ nez lo barconꞌ rao nisdaꞌon, ka breꞌe akreꞌ ba zazaꞌa Jesúsenꞌ zazeꞌe rao nisenꞌ to kwit barconꞌ, naꞌll blleb akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Naꞌll lleꞌe leakeꞌ: —Nadaꞌn, bi llebre. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Naꞌll llawé akreꞌ kwis, bagoꞌ akeꞌ Leꞌe lo barconꞌ. Ye chollze le ballín akteꞌ rao yo bill lloaꞌ nisdaꞌon ganꞌ zjayakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Naꞌ bateyó naꞌ, beꞌnn zan bagaꞌnn chlaꞌ lloaꞌ nisdaꞌo naꞌze, gokbeꞌe akreꞌ nono Jesúsenꞌ zejrén, naꞌ gokbeꞌe akreꞌ billbi barco yobre llasdá, toze danꞌ zayoꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌze, naꞌ bnnez akreꞌ bi zayoꞌ ren Jesúsenꞌ leakeꞌ lo barco naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kat le ballinte barco da zayaꞌk yellenꞌ nziꞌi Tiberias kwitze ganꞌ bdao akeꞌ yet xtir, danꞌ ganꞌ bayoll beꞌe Xanllo Jesúsenꞌ yel llioxken ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Naꞌ ka gokbeꞌe akreꞌ nono Jesúsenꞌ zerén leakeꞌ ganꞌ llaꞌa akeꞌ naꞌ, naꞌll ballaꞌa akeꞌ lo barconꞌ jayakeꞌ Capernaum nench bayirj akeꞌ Jesúsenꞌ do naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Naꞌll ka ballele beꞌnn zan kaꞌ Jesúsenꞌ ye chlaꞌ nisdaꞌon, naꞌll lle akeꞌ Leꞌe: —Maestro, ¿batkre bayedoꞌ ganni? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Naꞌll lle Jesúsenꞌ leakeꞌ: —Diꞌll li, diꞌll li niaꞌ reꞌ, llayirjre nadaꞌ le danꞌ bdaore kon ka bérjere naꞌn, kere llayirjre nadaꞌ ni ke da kaꞌ breꞌre yel wak kaꞌ danꞌ llonaꞌ naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bi llayaꞌl koꞌ yichjre gaꞌt da yeꞌj gaore, lekoꞌ yichjre gaꞌt da gonn yel nban zejlikane keré. Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, gonnaꞌ to da yeꞌj gaore, nench gaꞌt yel nban zejlikane keré. Le len naꞌ, ba broꞌ Xaꞌ Diosenꞌ lo naꞌ gonnaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Naꞌll lle akeꞌ Leꞌe: —¿Bixhanꞌ llayaꞌl gontoꞌ naꞌ, nench gontoꞌ danꞌ llazraꞌll Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Naꞌll lle Jesúsenꞌ leakeꞌ: —Da ninꞌ llayaꞌl gonre, naꞌllenꞌ yewé Diosenꞌ, gonliraꞌllre nadaꞌ nakaꞌ beꞌnn bseꞌl Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Naꞌll lle akeꞌ Jesúsenꞌ: —¿Bixha yel wak gonkzoꞌ chet kaꞌ, naꞌll gonliraꞌlltoꞌ rweꞌ? ¿Bi gonoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Le da xozxtaꞌollo kaꞌ, bdao akeꞌ yet daꞌo danꞌ nziꞌi maná, chak bzo akeꞌ latj dachenꞌ, naꞌ nyoj xtiꞌll Diosenꞌ ke akeꞌ llian: “Yet xtir da zaꞌa yebánꞌ beꞌe leakeꞌ bdao akeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Naꞌll lle Jesúsenꞌ leakeꞌ: —Diꞌll li, diꞌll li niaꞌ reꞌ: Kere da Moisés naꞌn beꞌe da xozxtaꞌollo kaꞌ yet xtirenꞌ, Xaꞌ Dios naꞌkzenꞌ beꞌen leakeꞌ. Naꞌ Leꞌen llonneꞌ reꞌ yet xtirenꞌ danꞌ zaꞌa yebá ganꞌ zoeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Naꞌ danꞌ zaꞌa yebá naꞌ, betjen yellrio ni, naꞌ lloeꞌn yel nban ke noteze beꞌnn gao len. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Naꞌll lle akeꞌ Leꞌe: —Xantoꞌ, bennchga netoꞌ yeo lla yet xtirenꞌ neꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Naꞌll lle Jesúsenꞌ leakeꞌ: —Nadaꞌn nakaꞌ yet xtir danꞌ lloeꞌ beꞌnn yel nban zejlikane. Naꞌ noteze beꞌnn wzenay kiaꞌ bill toneꞌ, naꞌ beꞌnn gonliraꞌll nadaꞌ, bill bilreꞌ nis chras. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Naꞌ ba bnekzaꞌ reꞌ, laꞌkze ba breꞌre nadaꞌ, naꞌ bi llonliraꞌllre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yeololte beꞌnn kwej Xaꞌn nench gak akeꞌ nadaꞌ txhen, ll-llin lla gonliraꞌll akeꞌ nadaꞌ, naꞌ noteze beꞌnne yeꞌnreꞌ gonliraꞌlleꞌ nadaꞌ, bi wkwaseꞌ kaꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nadaꞌ betjaꞌ yebá zaꞌa yellrio ni, kere nench gonaꞌ ka nen kiaꞌ nadaꞌn, kon kanꞌ ne Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ naꞌn gonaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Leꞌen lleꞌnreꞌ bi waꞌa latje kweyiꞌ ni to beꞌnn ba brejeꞌ, nench gak akeꞌ nadaꞌ txhen. Naꞌ kat llin lla te ke yellrio ni, kanaꞌ yesbán akeꞌ radj beꞌnn wat kaꞌ, chaꞌ ba got akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Xaꞌn lleꞌnreꞌ yeolol beꞌnn kaꞌ gonliraꞌll akeꞌ nadaꞌ, weꞌe akeꞌ yel nban zejlikane, naꞌ nadaꞌ yesbán akeꞌ radj beꞌnn wat kaꞌ, chaꞌ ba got akeꞌ kat llin lla te ke yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Beꞌnn zan beꞌnn Israel kaꞌ, bchach akeꞌ danꞌ bne Jesúsenꞌ kaꞌ: “Nadaꞌ nakaꞌ yet xtir danꞌ betj yebá.” ");
INSERT INTO zpuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Naꞌ wasné akeꞌ: —¿Kere beꞌnn ninꞌ Jesús, xhiꞌnn José lla? Nombiaꞌkzllo xaxhnaꞌ beꞌnnenꞌ. ¿Bi diꞌllenꞌ lloeꞌ neꞌe, zeꞌe yebá, naꞌ betjeꞌ yellrio? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bi wchachre kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Notno gak gonliraꞌll nadaꞌ, chaꞌ Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ, bi gakreneꞌ leakeꞌ gonliraꞌll akeꞌ nadaꞌ, naꞌ kat llin lla te ke yellrio ni, yesbanaꞌ leakeꞌ chaꞌ ba got akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Le ganꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ nen: “Yeololeꞌ, Diosenꞌ wroeꞌ wsedreꞌ leakeꞌ.” Naꞌ yeololeꞌ nneze kanꞌ ne Xaꞌn, naꞌ wzenay akeꞌ nench gon akeꞌ kanꞌ neꞌe naꞌ, leskaꞌ gonliraꞌll akeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nono beꞌnn nna reꞌe Xaꞌn. Toze nadaꞌ ba breꞌreꞌ le ganꞌ zoeꞌ naꞌn zaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Diꞌll li, diꞌll li niaꞌ reꞌ: Beꞌnn gonliraꞌll nadaꞌ, de yel nban zejlikane ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nadaꞌ nakaꞌ yet xtir danꞌ lloeꞌ beꞌnne yel nban zejlikane ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Da xozxtaꞌollo kaꞌ, laꞌkze bdao akeꞌ yel wao da nziꞌi maná chak bzo akeꞌ latj dachenꞌ, naꞌ yeololteꞌ dekz de wasaꞌte ka bllin lla ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nadaꞌ lloaꞌ diꞌll ke to yet xtir da zaꞌa yebá, naꞌ beꞌnn gao len bi gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nadaꞌn nakaꞌ yet xtir da zaꞌa yebánꞌ danꞌ nsaꞌa yel nban zejlikane. Beꞌnn gao yet xtirenꞌ, wbaneꞌ ke chnare. Naꞌ yet xtir danꞌ weꞌe akeꞌn nench gaꞌt yel nban ke beꞌnnach, naken kwerp kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naꞌll llaschach beꞌnn Israel kaꞌ llasné akeꞌ: —¿Akxha goneꞌ gonneꞌ kwerp keꞌen gaollon, nezeꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Naꞌll lle Jesúsenꞌ leakeꞌ: —Diꞌll li, diꞌll li niaꞌ reꞌ: Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, chaꞌ bi gaore kwerp kiaꞌn, naꞌ chaꞌ bi yeꞌjre xchenaꞌn, bibi yel nban zejlikane de keré chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Beꞌnn kaꞌ gao akeꞌ kwerp kiaꞌn, naꞌ yeꞌj akeꞌ xchenaꞌn, ke chnare de yel nban ke beꞌnn kaꞌ, laꞌkze chaꞌ ba wasaꞌt akeꞌ, kat te ke yellrio ni, wasbanaꞌ leakeꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Le kwerp kiaꞌn naken dogarje yel wao, naꞌ xchenaꞌn naken dogarje da yeꞌjre. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Beꞌnn kaꞌ llasaꞌo akeꞌ kwerp kiaꞌn, naꞌ llaseꞌjeꞌ xchenaꞌn, de yel nban zejlikane ke beꞌnn kaꞌ, naꞌ nak akeꞌ nadaꞌ txhen, leskaꞌ nadaꞌ nak akseꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Xaꞌ Diosenꞌ bseꞌleꞌ nadaꞌ, naꞌ Leꞌen napeꞌ yel nban naꞌ, naꞌ de yel nban kiaꞌ danꞌ nakaꞌ toze ren Leꞌe. Naꞌ kaꞌkze gak ke beꞌnn gao kwerp kiaꞌn, so akeꞌ ke chnare, le gak akeꞌ nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kwerp kiaꞌn naken yet xtir da zaꞌa yebá, bi naken ka danꞌ bdao da xozxtaꞌollo kaꞌ kanaꞌ latj dachenꞌ, le beꞌnn bdao len dekze de got akeꞌ. Naꞌ beꞌnn gao yet xtir danꞌ niaꞌ nadaꞌ kaꞌ, ke chnare so akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesúsenꞌ broeꞌ bsedreꞌ da ki lo yodaꞌo ke beꞌnn Israel kaꞌ ganꞌ nziꞌi Capernaum. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Naꞌ zan beꞌnn kaꞌ zjanao Jesúsenꞌ, ka ben akreꞌ da kaꞌ llzejnieꞌreꞌ leakeꞌn, naꞌll ne akeꞌ: —Bniꞌ xhen naken gonllo danꞌ llzejnieꞌreꞌn. ¿Noxha gakrize gon kanꞌ neꞌe naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gokbeꞌe Jesúsenꞌ llasnné akeꞌ ke danꞌ bzejnieꞌreꞌ leakeꞌ da kaꞌ, naꞌll lleꞌe leakeꞌ: —¿Bi llazraꞌllre da kaꞌ gollaꞌ reꞌ naꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Akxha nnere kat reꞌre nadaꞌ yeyepaꞌ yebá ganꞌ bzoaꞌ kanaꞌ, nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spíritu ke Diosenꞌ lloeꞌn yel nban ke beꞌnnach, naꞌ kwerpenꞌ bi gak gonen kaꞌ. Diꞌll danꞌ ba beꞌrenaꞌ reꞌ, naken diꞌll da lloeꞌ Spíritunꞌ, naꞌ nsaꞌn yel nban. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bixha nna niꞌt bale reꞌ, bi llejleꞌre kiaꞌ. Kaꞌ bne Jesúsenꞌ le kate naꞌ, gokbeꞌreꞌ nore beꞌnn kaꞌ llejleꞌ keꞌen, naꞌ norenꞌ wde Leꞌe rao beꞌnn kaꞌ llwie Leꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Naꞌll bne Jesúsenꞌ: —Ke len naꞌ, ba bniaꞌ nono gak gonliraꞌlle nadaꞌ, chaꞌ bi gakrén Xaꞌ Diosenꞌ leꞌe nench gonliraꞌlleꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bayoll bzejnieꞌ Jesúsenꞌ leakeꞌ da kaꞌ, zan beꞌnn kaꞌ llzenay xtiꞌlleꞌn, brej yichj akeꞌ bill bnao akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Naꞌll bnnabe Jesúsenꞌ beꞌnn chllinn kaꞌ (12) brejeꞌ nao Leꞌen: —¿Ren reꞌ lleꞌnere wayejre? ");
INSERT INTO zpuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Naꞌll lle Simón Pedronꞌ Leꞌe: —Xantoꞌ, nollno zaꞌk wzenaytoꞌ keꞌe. Tozoꞌ rweꞌn lloeꞌo diꞌll da lloeꞌ yel nban ke beꞌnn llzenay len. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Netoꞌ llonliraꞌlltoꞌ rweꞌ, naꞌ nnézetoꞌ nakoꞌ Cristo, naꞌ nakoꞌ dogarje Xhiꞌnn Dios beꞌnnenꞌ zo ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Naꞌll lle Jesúsenꞌ leakeꞌ: —Ba brejaꞌ reꞌ chllinnre nnaore nadaꞌ, naꞌ to reꞌ rao chllinn naꞌ, llzenayre ke daxiꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kanꞌ bneꞌe ke Judas Iscariotenꞌ xhiꞌnn beꞌnnenꞌ re Simón, le ba nnezreꞌ, leꞌen wdieꞌ Leꞌe rao naꞌa beꞌnn kaꞌ llwie Leꞌen, laꞌkze nakeꞌ beꞌnn ren rao beꞌnn chllinn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bde naꞌ, bdakze Jesúsenꞌ broeꞌ bsedreꞌ beꞌnn kaꞌ do ganꞌ nbane Galileanꞌ. Bill gokraꞌlleꞌ chejlleꞌ ganꞌ nziꞌi Judeanꞌ, le beꞌnn Israel kaꞌ llaꞌa naꞌ, llayirj akeꞌ akre gon akeꞌ got akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Naꞌ ba zo rez gaꞌle lnni ke beꞌnn Israel kaꞌ, danꞌ llon akeꞌ nench lljadinraꞌll akeꞌ kanꞌ bzo akeꞌ yoꞌ de yixh kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Naꞌ beꞌnn kaꞌ nak beꞌnn biꞌch Jesúsenꞌ, lle akeꞌ Leꞌe: —Bi yegaꞌnnoꞌ ganni, byej Judea naꞌle nench beꞌnn kaꞌ llzenay koꞌon, reꞌe akreꞌ yel wak kaꞌ llonoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Noteze beꞌnn chaꞌ lleꞌnreꞌ gombiaꞌ beꞌnn kaꞌ leꞌe nakeꞌ to beꞌnn zaꞌk, bi goneꞌ yel wak ngaꞌchze. Chaꞌ da li llonoꞌ yel wak, benen rao yeolol beꞌnne, naꞌll reꞌe akreꞌ danꞌ llonoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kaꞌn bne beꞌnn kaꞌ nak beꞌnn biꞌch Jesúsenꞌ, le ni leakeꞌ bi llejleꞌ akeꞌ ke Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Naꞌll lle Jesúsenꞌ leakeꞌ: —Bi nna llin lla chaꞌa, zan reꞌ wakse batteze chejre. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Beꞌnn kaꞌ bi nombiaꞌ Dios bi gak wie akreꞌ reꞌ, zan llwie akreꞌ nadaꞌ, le llroeꞌraꞌ da xhinnj kaꞌ llon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lechej lnninꞌ. Zan bi saꞌa nadaꞌ, le bi nna llin lla kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bayoll golleꞌ leakeꞌ kaꞌ, naꞌ goꞌyeꞌ Galilea naꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bde bzaꞌa biꞌcheꞌ kaꞌ zjakeꞌ lnninꞌ, naꞌll bzaꞌa Jesúsenꞌ, de ngaꞌchze byejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Naꞌ beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ llaꞌa naꞌ, llayirj akeꞌ Leꞌe rao lnninꞌ llasné akeꞌ: —¿Gaxha dá beꞌnnenꞌ do ni? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Naꞌ beꞌnn kaꞌ bllay rao lnninꞌ, lloeꞌ akeꞌ diꞌll llillize keꞌe, naꞌ biteze bne totoeꞌ. Bale ne: “Wa beꞌnn wen nakeꞌ”, naꞌ ye bale ne: “Bi nakeꞌ beꞌnn wen, ziyeꞌze beꞌnnenꞌ deꞌe.” ");
INSERT INTO zpuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Naꞌll llillize lloeꞌ akeꞌ diꞌllenꞌ, le yeololze beꞌnne lleb akeꞌ bi gone beꞌnn wnebiaꞌ kaꞌ leakeꞌ, chaꞌ yen akreꞌ lloeꞌ akeꞌ xtiꞌll Jesús naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Naꞌ ka do achje lnni naꞌn, kate byej Jesúsenꞌ lo lchir yodaꞌo brao ke beꞌnn Israel kaꞌ, naꞌ bzoraweꞌ llroeꞌ llsedreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Naꞌll babane beꞌnn wnebiaꞌ kaꞌ, llasné akeꞌ: —¿Akxha llaken da zan da nneze beꞌnnenꞌ? Renchaꞌ kere bi nzedeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Naꞌll lle Jesúsenꞌ leakeꞌ: —Danꞌ llroeꞌ llsedraꞌ ni, kere xhbab kiaꞌn, xhbab ke beꞌnnenꞌ bseꞌl nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Noteze beꞌnne gakraꞌlle goneꞌ kanꞌ lleꞌne Dios beꞌnnenꞌ bseꞌl nadaꞌn, wayakbeꞌkzereꞌ chaꞌ danꞌ llroeꞌ llsedraꞌn naken ke Dios o chaꞌ naken da llarjlaꞌllaꞌ nadzaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kate to beꞌnn llroeꞌ llsedreꞌ xhbab kekzeꞌ, llayirjlaꞌlleꞌ akre goneꞌ nench gakeꞌ xhen. Zan beꞌnn gakraꞌlle gon akeꞌ xhen beꞌnnenꞌ bseꞌl leꞌen, nnézkzello nak xtiꞌlleꞌn da li, bi naken da wxhiyeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Da Moisés naꞌ, benneꞌ reꞌ ley danꞌ nsedre, naꞌ ni tore bi llonre kanꞌ nen naꞌ. ¿Bixchen llayirjzre akre gonre gotre nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Beꞌnn kaꞌ zjallaꞌa naꞌ, bne akeꞌ: —Daxiꞌon yoꞌ. ¿Noxhanꞌ lleꞌne got rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Naꞌll lle Jesúsenꞌ leakeꞌ: —Toze yel wak da benaꞌ, naꞌ yeololre babánere. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Da Moisésenꞌ bllieꞌ biaꞌa sollo sen danꞌ nziꞌi circuncisión (laꞌkze kere leꞌen bllieꞌ biaꞌan, le da bkwaꞌnn xozxtaꞌollo kaꞌ bllaꞌa kanaꞌn), naꞌ ke len naꞌ, llzoare bidaꞌo byio kaꞌ sen, laꞌkze lla nbaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Naꞌ kanꞌ naken, laꞌkze chaꞌ naken lla nbaꞌnne, llzoare bidaꞌo byio kaꞌ sen, kat llákebeꞌ xoꞌn lla nench naꞌ llonre kanꞌ ne ley danꞌ bzoj da Moisésenꞌ, naꞌ ¿bixchen llakllaꞌre nadaꞌ danꞌ bayonaꞌ to beꞌnn weꞌe lla nbaꞌnne? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bi wlliayiꞌllre beꞌnne chaꞌ bi da daꞌo llreꞌreꞌ lloneꞌ, legón yel koxchisenꞌ lixheje kanꞌ llayaꞌl gaken naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Naꞌll bne to chop beꞌnn Jerusalén kaꞌ: —¿Kere beꞌnn ninꞌ llayirj akeꞌ nench yesoꞌte Leꞌe? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lewiá kanꞌ lloneꞌn, lloeꞌ diꞌll rao beꞌnn yell, naꞌ nono bi llekze Leꞌe. ¿Kere ba llasoꞌn beꞌnn wnebiaꞌ kaꞌ xhbab, Leꞌen nakeꞌ Cristonꞌ beꞌnnenꞌ bexhllo? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nnézello ga beꞌnn beꞌnn ni, zan kat yed Cristonꞌ, nono nneze gaxha zeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesúsenꞌ llroeꞌ llsedreꞌ llyoꞌ yodaꞌo braonꞌ, ka bne akeꞌ kaꞌ. Naꞌll bneꞌe zillje, lleꞌe leakeꞌ: —Llákere nombiaꞌre nadaꞌ, naꞌ nnézere gaxha beꞌnne nadaꞌ. Bixha kere to wrazzaꞌn zaꞌa. Da li zo beꞌnn bseꞌl nadaꞌn, reꞌ ni ke nombiaꞌzreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nadaꞌ nombieꞌ, le ganꞌ zoeꞌ naꞌn zaꞌa, le Leꞌen bseꞌleꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Naꞌ danꞌ bneꞌe kaꞌ, bale beꞌnn kaꞌ gokraꞌll akeꞌ goꞌx akeꞌ Leꞌe, zan nono beꞌx Leꞌe, le bi nna llin lla keꞌe, gakeꞌ rao naꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Beꞌnn zan byejleꞌ ke Jesúsenꞌ, nakeꞌ beꞌnn bseꞌl Dios, naꞌll bne akeꞌ: —¿Gonlle Cristonꞌ ye raꞌt yel wak da zaꞌklle ka danꞌ ba ben beꞌnn ni, kat yedeꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Naꞌ beꞌnn fariseo kaꞌ, ben akreꞌ diꞌllenꞌ lloeꞌ akeꞌ ke Jesúsenꞌ. Naꞌ beꞌrén akeꞌ bxoz wnebiaꞌ ke Israel kaꞌ diꞌlle, naꞌ bseꞌl akeꞌ beꞌnn kaꞌ llap yodaꞌo braonꞌ, nench naꞌ lljeꞌx akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Naꞌll goll Jesúsenꞌ leakeꞌ: —Ye chollze sorenaꞌ reꞌ, naꞌll wayaꞌa ganꞌ zo beꞌnnenꞌ bseꞌl nadaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Naꞌll wayirjre nadaꞌ, naꞌ bi yellélere nadaꞌ, le bi gak yedre ganꞌ zoaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Naꞌll lle lwellj beꞌnn Israel kaꞌ: —¿Gaxhanꞌ neꞌe wayejeꞌ ga bi yellélelloeꞌ? ¿Yeyejeꞌ ganꞌ naslas beꞌnn wrall kaꞌ radj beꞌnn griego kaꞌ, naꞌ wroeꞌ wsedreꞌ leakeꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Akxha zejen danꞌ bneꞌe kaꞌ: “Yeyirjre nadaꞌ, naꞌ bi yellélere nadaꞌ, naꞌ bi gak yedre ganꞌ zoaꞌn”? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lla zerao llon akeꞌ lnni naꞌ, naken lla xhenlle, naꞌ bzellá Jesúsenꞌ llroeꞌ llsedreꞌ leakeꞌ, naꞌ bneꞌe zillje, bneꞌe: —Noteze reꞌ, chaꞌ lo yichjraꞌlldaꞌorenꞌ nakre ka beꞌnne llbilraꞌlle, llayaꞌl gonliraꞌllre nadaꞌ, naꞌ gonnaꞌ da yeꞌjre. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Naꞌ beꞌnnenꞌ nxenraꞌll nadaꞌ, gak keꞌe kanꞌ ne xtiꞌll Dios danꞌ nyojen, to da wen kwis gak lo yichjraꞌlldaꞌweꞌ, gaken ka to yellrio ga llartit nis da lloeꞌ yel nban. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Naꞌ danꞌ bne Jesúsenꞌ kaꞌ, beꞌe diꞌll ke Spíritu ke Dios danꞌ yedsó lo yichjraꞌlldaꞌo noteze gonliraꞌll Leꞌen. Naꞌ kanꞌ bneꞌe kaꞌ, bi nna yedsó Spíritunꞌ lo yichjraꞌlldaꞌo beꞌnne, le bi nna gak yeolol da kaꞌ llayaꞌl gak, nench wroeꞌn Jesúsenꞌ nakeꞌ beꞌn zaꞌk xhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Beꞌnn kaꞌ llzenay xtiꞌll Jesúsenꞌ bal akeꞌ bne: —Da li beꞌnn ninꞌ beꞌnn llyixjweꞌ xtiꞌll Dios, beꞌnnenꞌ ba naksen yedeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Naꞌ ye bal akeꞌ ne: —Beꞌnn ninꞌ Cristonꞌ beꞌnnenꞌ ba naken yednnebiaꞌ. Bixha ye baleꞌn llasneꞌe: —¿Bixha nello beꞌnn Galilea naꞌ, kwej Diosenꞌ gakeꞌ Cristonꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Xtiꞌll Diosenꞌ danꞌ nyojen nen, Cristo beꞌnnenꞌ yedenꞌ, llojeꞌ rao dialla ke rey David, naꞌ nakeꞌ beꞌnn zaꞌa Belén ganꞌ nak rall David naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Naꞌ gok beꞌnn kaꞌ chop kweꞌre, ni ke Jesús naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Naꞌ baleꞌ gokraꞌll akeꞌ goꞌx akeꞌ Leꞌe, naꞌ bi gok goꞌx akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Beꞌnn kaꞌ llape yodaꞌo braonꞌ, jayakeꞌ ganꞌ zjazó bxoz wnebiaꞌ kaꞌ, ren beꞌnn fariseo kaꞌ, le beꞌnn kaꞌn bseꞌl leakeꞌ nench goꞌx akeꞌ Jesús naꞌ, naꞌll beꞌnn kaꞌ lle akeꞌ leakeꞌ: —¿Bixchen bi bcheꞌreꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Naꞌ beꞌnn kaꞌ llap yodaꞌon braonꞌ, llasné akeꞌ: —Bi nna yénetoꞌ beꞌnn weꞌe diꞌll wen, ka danꞌ lloeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Naꞌll lle beꞌnn fariseo kaꞌ leakeꞌ: —¿Rente reꞌ ba bxhiyeꞌreneꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni to netoꞌ beꞌnn fariseo, bi nna chejleꞌtoꞌ xtiꞌlleꞌn, ni beꞌnn wnebiaꞌ kello kaꞌ, ni toeꞌ bi nna chejleꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Zan beꞌnn ki zjallaꞌa ni, bi nombiaꞌ akeꞌ ley danꞌ bzoj da Moisésenꞌ, naꞌ ba nbeyiꞌ akeꞌ, danꞌ llejleꞌ akeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Naꞌ Nicodemo beꞌnnenꞌ byej rao Jesúsenꞌ tlleꞌlre beꞌnnenꞌ nak txhen fariseo kaꞌ, golleꞌ leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ley kellonꞌ nen bi gak wchoybiaꞌllo ke to beꞌnne ba ben da xhinnj, chaꞌ bi nna weꞌe diꞌll akrenꞌ gok, naꞌ chaꞌ bi nna nnézello bixhanꞌ beneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Naꞌll lle akeꞌ leꞌe: —¿Renoꞌ rweꞌ ba bayakoꞌ beꞌnn Galilea? Bsed xtiꞌll Diosenꞌ kwasro danꞌ nyojen, naꞌ nnezroꞌ ni to beꞌnn bdixjweꞌ xtiꞌll Diosenꞌ kanaꞌ bllojeꞌ Galilea. ");
INSERT INTO zpuNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Naꞌll bazaꞌa totoeꞌ, jayak akeꞌ rill akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesúsenꞌ byejeꞌ rao yaꞌ ganꞌ nziꞌi Yaꞌ Olivos. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Naꞌ bateyó kate byeniꞌ, byejeꞌ lo yodaꞌo braonꞌ da yobre, naꞌ yeolol beꞌnn kaꞌ llaꞌa naꞌ, jabiꞌy akeꞌ raweꞌn. Naꞌ bllieꞌ naꞌ bzoraweꞌ llroeꞌ llsedreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisés naꞌ, naꞌ beꞌnn fariseo kaꞌ, jwaꞌa akeꞌ to noꞌre, badoꞌl akreꞌ leꞌe ren xtoeꞌ. Naꞌ jazé akeꞌ leꞌe kllol beꞌnn kaꞌ llzenay xtiꞌll Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naꞌll lle akeꞌ Jesúsenꞌ: —Maestro, noꞌr ni badoꞌletoeꞌ lloneꞌ da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ka nak ley danꞌ bzoj da Moisésenꞌ, nllian biaꞌa wchekw aklloeꞌ yej got aktelloeꞌ. ¿Bixha neꞌo rweꞌ, akre gonllo keꞌe? ");
INSERT INTO zpuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Lle akeꞌ Jesúsenꞌ kaꞌ, nench wkwej akeꞌ Leꞌe diꞌll, naꞌ gaꞌt da gao akeꞌ xhia keꞌe. Bixha Jesúsenꞌ kanꞌ lliꞌteze naꞌ, to bxhexjze yichjeꞌn bzoraweꞌ llzojeꞌ rao yo ren xhbeneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Naꞌll llchieꞌ akreꞌ Leꞌe, akre neꞌe. Naꞌll kat babeꞌchaꞌweꞌ, naꞌll lleꞌe leakeꞌ: —Noteze reꞌ bibi da xhinnj nonre nakre yalle, reꞌ lesorao lewchekweꞌ yejenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Le babeꞌteꞌ syichjre da yobre, llzojeꞌ rao yonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ka golleꞌ leakeꞌ kaꞌ, naꞌll bayakbeꞌe akreꞌ, lekze beꞌnn wen da xhinnj leakeꞌ, naꞌll chbaꞌ chbaꞌ balloj twej twej akeꞌ, zgaꞌtek beꞌnn gore kaꞌ, naꞌll zanao beꞌnn llaban kaꞌ, bagaꞌnnte noꞌr naꞌze ganꞌ lliꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ka bakos yichjeꞌn da yobre, nollno beꞌnn kaꞌ llraꞌ, ni ye toeꞌ, naꞌll lleꞌe noꞌrenꞌ: —Noꞌre, ¿gannxha beꞌnn kaꞌ lleꞌne got rweꞌn? ¿Ni toeꞌ billbi ll-lliayiꞌll rweꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naꞌll ne noꞌrenꞌ: —Ni toeꞌ, Xanaꞌ. Naꞌll lle Jesúsenꞌ leꞌe: —Ni nadaꞌ bi wlliayiꞌllaꞌ rweꞌ. Bayej, naꞌ bill nnaoꞌ gonoꞌ da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesúsenꞌ beꞌe diꞌll da yobre, lleꞌe beꞌnn kaꞌ: —Nadaꞌ nakaꞌ beniꞌ ke yichjraꞌlldaꞌo beꞌnnach. Beꞌnn goneꞌ nadaꞌ txhen, bill nchole yichjraꞌlldaꞌo akeꞌn, naꞌ lo yichjraꞌlldaꞌo akeꞌ naꞌ, ba naken ka to da yoꞌ beniꞌ. Leakeꞌn ba de yel nban zejlikane ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Naꞌll lle beꞌnn fariseo kaꞌ Leꞌe: —Kwinzoꞌ lloeꞌo diꞌll koꞌo, neꞌo nakoꞌ beꞌnn zaꞌke, bi nak danꞌ da li. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Naꞌll lle Jesúsenꞌ leakeꞌn: —Laꞌkze chaꞌ lloaꞌa diꞌll ke kwinzaꞌ, xtiꞌllaꞌn naken da zaꞌke, naꞌ da li. Nadaꞌ nnezraꞌ ganꞌ bzaꞌa naꞌ, naꞌ ganꞌ wayaꞌa, zan reꞌ ni ke nnézzere gaxhanꞌ zaꞌa, naꞌ gaxhanꞌ wayaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Reꞌ ll-lliayiꞌllre nadaꞌ kon ka llaraꞌn lo yichjraꞌlldaꞌore, zan nadaꞌ notno ll-lliayiꞌllaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Naꞌ chet kaꞌ llonaꞌ yel koxchis ke beꞌnn kaꞌ, llonaꞌn ka llayaꞌl gaken, le bibi de da llonaꞌ to wrazzaꞌ, llonaꞌ kanꞌ ne Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ley kellonꞌ danꞌ llsedrenꞌ nen, llayaꞌl chejleꞌllo kat chope beꞌnn breꞌe kanꞌ goken, naꞌ toze ka diꞌll weꞌe akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nadaꞌ lloaꞌa diꞌll kiaꞌ kwinaꞌ, naꞌ Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ, lekze diꞌll kiaꞌ nadaꞌn lloeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Naꞌll lle akeꞌ Leꞌe: —¿Gaxhanꞌ zo xaꞌo? Naꞌll ne Jesúsenꞌ: —Ni nadaꞌ ni Xaꞌ naꞌ, bi nombiaꞌre. Chenak nombiaꞌre nadaꞌ, renkze Xaꞌ naꞌ, ba nombiaꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Diꞌll kaꞌ broeꞌ bsede Jesúsenꞌ, kanꞌ llaꞌa akeꞌ kwitze ganꞌ lloeꞌ akeꞌ mell ke yodaꞌo brao ke beꞌnn Israel kaꞌ. Naꞌ notno beꞌx Leꞌe, le bi nna llin lla keꞌe goꞌx akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesúsenꞌ lleꞌe leakeꞌ: —Nadaꞌ yeyaꞌa, naꞌ yeyirjre nadaꞌ, zan bi gak yezaꞌrenre ganꞌ yeyaꞌan, naꞌ rao da xhinnj keré kaꞌ kwiayiꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Naꞌ danꞌ bneꞌe kaꞌn, bne beꞌnn Israel kaꞌ: —¿Yeyotje kwineꞌn, naꞌllenꞌ neꞌe nono gak yeyej ganꞌ wayejeꞌ naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Naꞌll lle Jesúsenꞌ leakeꞌ: —Reꞌ nakre beꞌnn ke yellrio ni, naꞌ llzenayre ke danꞌ llnebiaꞌ yellrio ni, zan ke nak nadaꞌ, zaꞌa yebá bi llzenayaꞌ ke danꞌ llak yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ke len naꞌ, gollaꞌ reꞌ kwiayiꞌre rao da xhinnj keré kaꞌ. Le chaꞌ bi chejleꞌre nadaꞌn nakaꞌ doxhen kanꞌ ba bniaꞌ naꞌ, kwiayiꞌre rao da xhinnj keré kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Naꞌll lle akeꞌ Leꞌe: —¿Noxha rweꞌ? Naꞌll lle Jesúsenꞌ leakeꞌ: —Da zan ras ba gollaꞌ reꞌ noxha nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Da zanlle de da nniaꞌ reꞌ, naꞌ wzejnieꞌraꞌ reꞌ napre doꞌle. Naꞌ beꞌnnenꞌ bseꞌl nadaꞌ, lloeꞌ diꞌll li, naꞌ nadaꞌ lloeꞌrenaꞌ beꞌnnach diꞌll da ba benraꞌ bneꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Beꞌnn wnebiaꞌ kaꞌ, bi byejnieꞌ akreꞌ lloeꞌreneꞌ leakeꞌ diꞌll ke Xeꞌe Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Naꞌll lle Jesúsenꞌ leakeꞌ: —Kat wlisre nadaꞌ to leꞌ yay, nadaꞌ nakaꞌ Beꞌnn Gorj Radj Beꞌnnach, kanaꞌll nnézere nakaꞌ beꞌnnenꞌ ba bniaꞌ nakaꞌ, naꞌ nnézere bibi llonaꞌ to wrazaꞌ, kon da ba bzejnieꞌ Xaꞌn nadaꞌ, len naꞌ niaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ, zerenkzeꞌ nadaꞌ. Bi llbej yichjeꞌ nadaꞌ, le zoteze zoaꞌ llonaꞌ da llayoꞌraꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Naꞌ ka lloeꞌrén Jesúsenꞌ beꞌnn kaꞌ diꞌll kaꞌ, beꞌnn zan bzorao llonliraꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Naꞌll lle Jesúsenꞌ beꞌnn Israel kaꞌ ba bzorao llonliraꞌll Leꞌe: —Chaꞌ sotezre gonre kanꞌ ba bniaꞌ naꞌ, naꞌll wroeꞌn da likzenꞌ llonre nadaꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gombiaꞌre diꞌll li kiaꞌn, naꞌll gakrenen reꞌ, naꞌll yellojre rao naꞌa danꞌ llnebiaꞌ reꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bale beꞌnn kaꞌ, goll akeꞌ Jesúsenꞌ: —Netoꞌn naktoꞌ dialla da Abraham naꞌ, naꞌ nono nna so beꞌnn nnebiaꞌ netoꞌ. ¿Bixchen nezoꞌ yellojtoꞌ danꞌ llnebiaꞌ netoꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Naꞌ lle Jesúsenꞌ leakeꞌ: —Diꞌll li niaꞌ reꞌ, yeololte beꞌnn llon da xhinnje, nak akeꞌ rallnaꞌa da xhinnj danꞌ llnebiaꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Beꞌnn zo rill xan llin keꞌen, choll wejze llzoreneꞌ xan yoꞌn txhen, zan beꞌnn nak xhiꞌnn xan yoꞌn zorentezeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nadaꞌ nakaꞌ dogarje Xhiꞌnn Dios, naꞌ wak gonaꞌ nench yelloj da xhinnj kaꞌ yichjraꞌlldaꞌorenꞌ, bill nnebiaꞌn reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nnezraꞌ nakre dialla da Abraham naꞌ, naꞌ llayirjlaꞌllre akre gonre gotre nadaꞌ, le bi lloeꞌre latj so xtiꞌllaꞌn yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nadaꞌ lloaꞌa diꞌll ke da kaꞌ ba breꞌraꞌ kanꞌ zoaꞌ kwit Xaꞌn, naꞌ reꞌ leskaꞌ llonkzre da ba bénere bne xarenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Naꞌll lle beꞌnn kaꞌ Jesúsenꞌ: —Netoꞌ naktoꞌ dialla da Abraham. Naꞌll lle Jesúsenꞌ leakeꞌ: —Chenak nakre dogarje dialla da Abraham naꞌ, gonre kanꞌ beneꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Laꞌkze ba bzejnieꞌraꞌ reꞌ diꞌll li danꞌ benraꞌ bne Diosenꞌ, naꞌ lleꞌnkzere gotre nadaꞌ. Da Abraham naꞌ, bi beneꞌ kanꞌ llonre naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Toz kaꞌ llonre ren xarenꞌ. Naꞌll lle beꞌnn kaꞌ Leꞌe: —Toze Dios naꞌn nak xatoꞌ, naꞌ bi llzenaytoꞌ ke nollre beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesúsenꞌ lleꞌe leakeꞌ: —Chaꞌ Dios naꞌ nak xare, llieꞌre nadaꞌ chenake, le nadaꞌn bzaꞌa ganꞌ zo Diosenꞌ. Kere to wrazzaꞌn zaꞌa, Dios naꞌn bseꞌl nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bi llejnieꞌre danꞌ llepaꞌ reꞌn, le bi lleꞌnere wzenayre kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Daxiꞌo naꞌ, nak xare, naꞌllenꞌ llawere llonre kanꞌ lleꞌnen naꞌ. Le len naꞌ naken wet beꞌnne, kanꞌ bxhe yellrio naꞌte. Naꞌ bi llejleꞌn diꞌll li, le bibi diꞌll li yoꞌ lo raꞌlldaꞌwe. Naꞌ kat nen diꞌll wenraꞌlle, nen kon kanꞌ naken naꞌ, le len naꞌ nak wenraꞌlle, naken xa yeolol diꞌll wenraꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naꞌ nadaꞌ, lloeꞌtiaꞌ diꞌll li, naꞌ bi llejleꞌre kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Noxha reꞌ gak wroeꞌ chaꞌ bi da xhinnj nonaꞌ? Nadaꞌ zoteze zoaꞌ lloaꞌa diꞌll li. ¿Bixchen bi llejleꞌre kiaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Beꞌnn kaꞌ nak xhiꞌnn Diosenꞌ, llzenay akeꞌ xtiꞌlleꞌn. Naꞌ reꞌ bi llzenayre keꞌe, le bi nakre xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Naꞌll beꞌnn wnebiaꞌ ke Israel kaꞌ, lle akeꞌ Jesúsenꞌ: —Kanꞌ ba bnekztoꞌ naꞌ, nakbieꞌkze nakoꞌ txhen beꞌnn Samaria kaꞌ, naꞌ yoꞌ daxiꞌo lo yichjraꞌlldaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesúsenꞌ lleꞌe leakeꞌ: —Bitbi daxiꞌo yoꞌ lo yichjraꞌlldaꞌwaꞌn, Xaꞌ naꞌ lloeꞌxhenaꞌ, naꞌ reꞌ bi llapre nadaꞌ baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kere llyirjaꞌ beꞌnn gon nadaꞌ xhen naꞌ, Xaꞌ naꞌn zoeꞌ lleꞌnreꞌ beꞌnnache goneꞌ nadaꞌ xhen, le Leꞌen lloneꞌ yel koxchis. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Diꞌll li, diꞌll li niaꞌ reꞌ: Noteze beꞌnn llzenay xtiꞌllaꞌn, gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Naꞌll lle beꞌnn wnebiaꞌ kaꞌ Leꞌe da yobre: —Naꞌ bayoll bnnézetoꞌ yoꞌ daxiꞌon lo yichjraꞌlldaꞌon. Ba got xozxtaꞌollo Abraham naꞌ, ren yelaꞌ beꞌnn kaꞌ bdixjweꞌ xtiꞌll Dios kanaꞌ, naꞌ rweꞌ nechkoꞌ beꞌnn wzenay koꞌo, gaꞌt yel nban zejlikane keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Llakroꞌ zaꞌklloꞌ ka da xozxtaꞌollo Abraham naꞌn? Leꞌen ba goteꞌ, naꞌ ren beꞌnn kaꞌ bdixjweꞌ xtiꞌll Diosenꞌ kanaꞌ, leakeꞌn ba got akeꞌ. ¿Noxha llakroꞌ nakoꞌ rweꞌ naꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Naꞌll lle Jesúsenꞌ leakeꞌ: —Chaꞌ llon kwinaꞌ xhen, bibi zaꞌken, zan Xaꞌn llon nadaꞌ xhen beꞌnnenꞌ nere llonre xhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Naꞌ ni ke nombiaꞌzreꞌ, zan nadaꞌ nombieꞌ. Chaꞌ niaꞌ bi nombieꞌ, naꞌ gakaꞌ beꞌnn wenraꞌll kanꞌ nak reꞌ. Zan nadaꞌ nombieꞌ, naꞌ llzenayaꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Da Abraham naꞌ, beꞌnnenꞌ gok xozxtaꞌore, bawereꞌ kwis bnnezreꞌ wreꞌreꞌ llanꞌ yedaꞌ rao yellrio ni, naꞌ zoeꞌ nbaraz ba breꞌreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Naꞌll lle beꞌnn Israel kaꞌ Leꞌe: —Ni ke nna gákzeroꞌ chiyon (50) iz, naꞌ nechkoꞌ ba breꞌroꞌ Abraham naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesúsenꞌ lleꞌe leakeꞌ: —Diꞌll li, diꞌll li niaꞌ reꞌ: Ba zokzaꞌ nadaꞌ ka bi nna so Abraham naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Naꞌ bxhiꞌi akeꞌ yej wchekw akeꞌ Leꞌe, cheꞌr ke bkwaꞌchdoeꞌ, naꞌ ballojeꞌ yodaꞌon. Ni ke gokbeꞌe akzreꞌ, badieꞌ radj akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesúsenꞌ zejreneꞌ beꞌnn kaꞌ non Leꞌe txhen, naꞌ breꞌe akreꞌ to beꞌnn nchole ka gorjteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Naꞌll lle akeꞌ Leꞌe: —Maestro, ¿noxha nap doꞌlenꞌ, gorj beꞌnnenꞌ beꞌnn lchole, leꞌen o chaꞌ xaxhneꞌen? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Naꞌll lle Jesúsenꞌ leakeꞌ: —Beꞌnn ni gorjeꞌ nchole kere da napeꞌ doꞌlenꞌ, naꞌ ni kere da nap xaxhneꞌe doꞌlenꞌ, gorjeꞌ kaꞌ nench wroeꞌrawe bi danꞌ gon Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Llayaꞌl gonllo xchin Dios beꞌnnenꞌ bseꞌl nadaꞌ, chak nna de latje. Le wllin lla kat bill gaꞌl gonllon. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Naꞌ chak nna zoaꞌ yellrio ni, llgoaꞌ beniꞌ lo yichjraꞌlldaꞌo beꞌnnache. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bayoll bneꞌe kaꞌn, blloꞌnn xheꞌn keꞌen rao yonꞌ, naꞌll beneꞌ raꞌt bennj kone xheꞌn keꞌe naꞌ, naꞌll bdebeꞌ bennjenꞌ rao beꞌnn lcholenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Naꞌll golleꞌ leꞌe: —Byej jadib raoꞌn ganꞌ llia nisenꞌ ganꞌ nziꞌi Siloé. (Siloé naꞌ lleꞌnen nen Nseꞌlaꞌ.) Naꞌ kaꞌ gok byejeꞌ, naꞌ jadib raweꞌn, ka ballineꞌ, naꞌ ba llareꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naꞌ beꞌnn wrill keꞌe kaꞌ, naꞌ nollre beꞌnne breꞌe akreꞌ leꞌe yeo lla, kanꞌ nna nakeꞌ beꞌnn nchole naꞌ, ne akeꞌ: —¿Kere beꞌnn ninꞌ llbeꞌ llnnabeꞌ lmoxh lla? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Naꞌ baleꞌ ne: —Leꞌen. Naꞌ ye baleꞌ llasné: —Kere leꞌen, beꞌnn yobrenꞌ, zan toz ka nakeꞌ ren beꞌnn ni. Naꞌll bne beꞌnnenꞌ: —Nadkzaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Naꞌll lle akeꞌ leꞌe: —¿Akxha gok bzorao llareꞌroꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naꞌll lleꞌe leakeꞌ: —To beꞌnn re Jesús beneꞌ raꞌt bennj, naꞌ bdebeꞌn rawaꞌn, naꞌll lleꞌe nadaꞌ: “Byej ganꞌ llia nis ganꞌ nziꞌi Siloé, naꞌ jadib raoꞌn.” Naꞌll byaꞌa jadibaꞌn, naꞌll bzorao llareꞌraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Naꞌll lle akeꞌ Leꞌe: —¿Gannxha beꞌnnenꞌ naꞌ? Naꞌ lleꞌe leakeꞌ: —Bi nnezraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Naꞌll bcheꞌe akeꞌ beꞌnnenꞌ gok beꞌnn lcholenꞌ ganꞌ llaꞌa beꞌnn fariseo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Naꞌ nak to lla nbaꞌnne, kanꞌ ben Jesúsenꞌ bennj danꞌ bdebeꞌ rao beꞌnnenꞌ nench bareꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Naꞌ leskaꞌ bnnabe beꞌnn fariseo kaꞌ leꞌe, akre goken ba llareꞌreꞌ, naꞌ lleꞌe leakeꞌ: —Bdebeꞌ bennj yejrawaꞌn naꞌll jadibaꞌn, naꞌ nnaꞌ ba llareꞌteraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Naꞌ bale beꞌnn fariseo kaꞌ, bne akeꞌ: —Nnézello bi zorén Diosenꞌ beꞌnnenꞌ bayón beꞌnn lcholenꞌ, le lloneꞌ da bi llayaꞌl goneꞌ lla nbaꞌnne. Naꞌ ye baleꞌ ne akeꞌ: —¿Akxha gon to beꞌnn wen da xhinnj, gonchekeꞌ yel wak ka danꞌ llon beꞌnn ni? Naꞌll gok akeꞌ chop kweꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Naꞌll lle akeꞌ beꞌnnenꞌ bayakenꞌ: —¿Bixha neꞌo rweꞌ ke beꞌnnenꞌ bayón raoꞌn? Naꞌll ne beꞌnnenꞌ: —Nakeꞌ to beꞌnn llyixjweꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naꞌ beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ, bi byejleꞌ akeꞌ ke beꞌnnenꞌ gok beꞌnn lcholenꞌ, naꞌ ba llareꞌreꞌ. Naꞌll goxh akeꞌ xaxhneꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Naꞌll bnnab akreꞌ xaxhnaꞌ beꞌnnenꞌ gok lcholenꞌ, lle akeꞌ leakeꞌ: —¿Xhiꞌnnre beꞌnn ni, beꞌnnenꞌ nere gorjeꞌ nchole? ¿Akxha goken ba llareꞌreꞌ nnaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Naꞌ xaxhneꞌe naꞌ, goll akeꞌ leakeꞌ: —Xhiꞌnntoꞌn, naꞌllenꞌ nnézetoꞌ ka gorjtebeꞌn ncholbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Zan bi nnézetoꞌ akrenꞌ gok ba llareꞌbeꞌ, naꞌ ni ke nnézzetoꞌ nonꞌ bayón raobeꞌn. Ba naksbeꞌ bi wak, lennabteze kwinbeꞌ, nench weꞌbeꞌ diꞌll akrenꞌ gok. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kaꞌ bne xaxhneꞌe kaꞌ, le lleb akeꞌ beꞌnn Israel kaꞌ, le leakeꞌn bchoy akeꞌn nono wreb akeꞌ lo yodaꞌon, noteze beꞌnn weꞌe diꞌll llejleꞌ ke Jesúsenꞌ nakeꞌ Cristo. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Naꞌllenꞌ bne xaxhnaꞌbeꞌn kaꞌ: “Ba nwaksbeꞌ, lennabteze kwinbeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Naꞌll goxh akeꞌ beꞌnnenꞌ gok beꞌnn lcholenꞌ da yobre, lle akeꞌ leꞌe: —Beꞌe diꞌll li rao Dios. Beꞌnnenꞌ neꞌo bayón rweꞌn, nakeꞌ beꞌnn wen da xhinnje. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naꞌll lle beꞌnnenꞌ leakeꞌ: —Bi nnezraꞌ chaꞌ nakeꞌ beꞌnn wen da xhinnje. Kon toz da nnezraꞌ, gokaꞌ beꞌnn lchole, naꞌ nnaꞌ ba llareꞌraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Naꞌll da yobre lle akeꞌ leꞌe: —¿Bixha benreꞌ rweꞌ? ¿Akre beneꞌn nench bareꞌroꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naꞌll lleꞌe leakeꞌ: —Ba bnekzaꞌ reꞌ, naꞌ bi llejleꞌre. ¿Bixchen lleꞌnzere nniaꞌ weltze? ¿Lleꞌnere nnaore gonreꞌ txhen naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naꞌll bchachrén akeꞌ leꞌe, lle akeꞌ leꞌe: —Rweꞌn nakoeꞌ txhen, zan netoꞌ da Moisés naꞌ, naktoꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Le nnézetoꞌ Dios naꞌ, beꞌrén da Moisésenꞌ diꞌlle, naꞌ beꞌnn ni, bi nnézetoꞌ ga zeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naꞌll lle beꞌnnenꞌ bayakenꞌ leakeꞌ: —Da ninꞌ nak zi yebánello, le bi nnézere ga zaꞌa beꞌnn ni, naꞌ ba bayoneꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nnézello Diosenꞌ bi llzenayeꞌ ke beꞌnn llon da xhinnje, zan llzenayeꞌ ke noteze beꞌnn llonliraꞌll Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka bxhe yellriote, gaga nna yénello zo beꞌnne llayoneꞌ rao beꞌnn nchol ka gorjteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Beꞌnn ni, bibi gak goneꞌ chenak bi zeꞌe ga zo Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Naꞌ balliꞌi beꞌnn fariseo kaꞌ xtiꞌlleꞌn: —Rweꞌn ka gorjteꞌo nakoꞌ beꞌnn wen da xhinnj kwis. ¿Llakroꞌ chaꞌ rweꞌ za wsedroꞌ netoꞌn? Naꞌll babej akeꞌ leꞌe lo yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesúsenꞌ benreꞌ kanꞌ ben akeꞌ babej akeꞌ beꞌnnenꞌ lo yodaꞌon, beꞌnnenꞌ bayoneꞌ yejraonꞌ, naꞌll ka badileꞌ leꞌen, lleꞌe leꞌe: —¿Llonliraꞌlloꞌ Xhiꞌnn Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naꞌll ne beꞌnnenꞌ: —Xanaꞌ, bne nadaꞌ noxhanꞌ, nench gonliraꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesúsenꞌ lleꞌe leꞌe: —Ba breꞌkzeroꞌ nadaꞌ, nadkzaꞌn lloeꞌrenoꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naꞌll bzoa xhib beꞌnnenꞌ raweꞌ lloeꞌraweꞌ Leꞌe, bneꞌe: —Xanaꞌ, llonliraꞌllaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Naꞌll lle Jesúsenꞌ leꞌe: —Zaꞌa yellrio ni, nench wroeꞌn nonꞌ nap doꞌle, naꞌ nonꞌ bi nap doꞌle, naꞌ zadyenaꞌ nench beꞌnn kaꞌ bi llejnieꞌ, bill gak akeꞌ ka beꞌnn lchole, naꞌ zadyenaꞌ nench beꞌnn kaꞌ llak akreꞌ llejnieꞌ akreꞌ, gak akeꞌ ka beꞌnn nchole lo yichjraꞌlldaꞌo akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Naꞌll bal beꞌnn kaꞌ zjazé kaꞌle, beꞌnn fariseo kaꞌ, ben akreꞌ kanꞌ ne Jesúsenꞌ, naꞌll lle akeꞌ Leꞌe: —¿Llakroꞌ chaꞌ ren netoꞌn naktoꞌ beꞌnn lcholenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Naꞌll lle Jesúsenꞌ leakeꞌ: —Chenak nakre beꞌnn lchole, bibi doꞌl keré de, zan danꞌ nere llejnieꞌre naꞌ, naꞌllenꞌ dekze doꞌl keré. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Diꞌll li, diꞌll li niaꞌ reꞌ: Beꞌnne bi choeꞌ ganꞌ nake lloaꞌ reꞌj ke xhiꞌrenꞌ, naꞌ choeꞌ ga yobre, leꞌen nakeꞌ beꞌnn wan. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Beꞌnn wsarjeꞌ choeꞌ lixhej lloaꞌ reꞌjenꞌ, leꞌen llap xhiꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Naꞌ beꞌnnenꞌ llape lloaꞌ reꞌjenꞌ wsarjeꞌ, naꞌ choꞌ gop xhiꞌrenꞌ. Naꞌ llzenay xhiꞌr kaꞌ xtiꞌll beꞌnnenꞌ llwia leakbaꞌn, nombiaꞌ akbaꞌ chieꞌn kat llaxhebaꞌ, lloeꞌ ra akbaꞌ kat llbejebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Naꞌ kate ba bchacheꞌ yeololtebaꞌ lo reꞌjenꞌ, llbiaraweꞌ rao akbaꞌn, naꞌll nao xhiꞌr keꞌe kaꞌ leꞌe, le nombiaꞌ akbaꞌ chieꞌ naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bill nnao akbaꞌ no beꞌnn yobre, to llxhonnj akzbaꞌ le bi nombiaꞌ akbaꞌ chieꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesúsenꞌ beꞌe diꞌll ke beꞌnn gop xhiꞌrenꞌ, nench bzejnieꞌreꞌ beꞌnn kaꞌ llaꞌa naꞌ, naꞌ bi byejnieꞌ beꞌnn kaꞌ, akre zejeꞌn danꞌ golleꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Naꞌ lle Jesúsenꞌ leakeꞌ da yobre: —Diꞌll li, diꞌll li niaꞌ reꞌ: Nadaꞌ nakaꞌ ka to lloaꞌ reꞌj ganꞌ llallaꞌa xhiꞌr kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yeololte nollre beꞌnn ba bedeꞌ ka za yedaꞌ nadaꞌ, nello nak akeꞌ beꞌnn wan. Naꞌ beꞌnn kaꞌ nak ka xhiꞌr daꞌo kiaꞌ, bi bzenay akeꞌ xtiꞌll beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nadaꞌn nakaꞌ ka lloaꞌ reꞌj ke xhiꞌr kaꞌ, naꞌ noteze beꞌnne gonliraꞌll nadaꞌ, yerá akeꞌ rao da xhinnjenꞌ, naꞌ gak akeꞌ ka xhiꞌr daꞌo ba lloꞌ lo reꞌj, naꞌll llalloj akbaꞌ, naꞌ llel da llao akbaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Le beꞌnn wan naꞌ, zeꞌe nench kwaneꞌ xhiꞌr daꞌo kaꞌ, naꞌ gotebaꞌ, naꞌ wlleyieꞌbaꞌ. Zan nadaꞌ zaꞌa lloaꞌa yel nban zejlikane ke beꞌnn kaꞌ llonliraꞌlle nadaꞌ, nench nniꞌt akeꞌ wen kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naꞌ nadaꞌ llonaꞌ ka to beꞌnne llap xhiꞌr keꞌen kwasro. Naꞌ beꞌnn llap xhiꞌr keꞌen kwasro llsanraꞌll yel nban keꞌen, ni ke danꞌ nllieꞌreꞌ xhiꞌr keꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Naꞌ beꞌnn ziꞌi raxhjeꞌ gapeꞌ xhiꞌr ke beꞌnnenꞌ, to wxhonnjzeꞌ wsanraꞌllebaꞌ ka reꞌreꞌ zaꞌa beꞌkw yiꞌon, le bi nak xhiꞌr kaꞌ ba keꞌe. Naꞌllenꞌ lloeꞌ latj lljeꞌx beꞌkw yiꞌon leakbaꞌ, naꞌ lloslasbaꞌ xhiꞌr daꞌo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Naꞌ beꞌnn bi nak xan xhiꞌr kaꞌ, llxhonnjeꞌ le bi nllieꞌreꞌ xhiꞌr kaꞌ, le bi nak xhiꞌr kaꞌ ba keꞌe. Danꞌ ziꞌi raxhjeꞌ naꞌzenꞌ llwiebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Nadaꞌ llonaꞌ ka llon to beꞌnn llape xhiꞌr keꞌen kwasro, naꞌ nombiaꞌ beꞌnn kaꞌ nak akeꞌ ka xhiꞌr daꞌo kiaꞌ, naꞌ leakeꞌ nombiaꞌ akeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kaꞌn nombiaꞌ Xaꞌn nadaꞌ, naꞌ kaꞌ nombiaꞌ Leꞌe, naꞌ llsanraꞌll kwinaꞌ gataꞌ ni ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Naꞌ zjaniꞌt beꞌnn yobre beꞌnn bi nak ak beꞌnn Israel. Beꞌnn kinꞌ llayaꞌle lljatop akeꞌ nench wzenay akeꞌ kiaꞌ, naꞌll gak akeꞌ ka xhiꞌr daꞌo kaꞌ llaꞌa toze reꞌj, naꞌ toze beꞌnn llap leakbaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Llsanraꞌll kwinaꞌ yesoꞌt beꞌnn kaꞌ nadaꞌ, naꞌ te naꞌ, yebanaꞌ da yobre, naꞌ Xaꞌn nllieꞌreꞌ nadaꞌ, le llazraꞌlleꞌ kanꞌ llonaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nono llakaꞌa yel nban kiaꞌn. Nadkzaꞌn llsanraꞌll kwinaꞌ gataꞌ. Wak wsanraꞌll kwinaꞌ got akeꞌ nadaꞌ, naꞌ leskaꞌ wak yeyas yebanaꞌ radj beꞌnn wat kaꞌ, kanꞌ nllia Xaꞌn biaꞌa gonaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Da yobre gok beꞌnn Israel kaꞌ chopre, ni ke xtiꞌll Jesús naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zan akeꞌ bne: —Daxiꞌon yoꞌ yichjraꞌlldaꞌweꞌn, bi ne bi zilleꞌ. ¿Bixchen llzenayrizre xtiꞌlleꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Naꞌ ye baleꞌ ne akeꞌ: —Ni to beꞌnn yoꞌ daxiꞌo bi gak nneꞌe kaꞌ. ¿Bixha wak gon daxiꞌon yeyak beꞌnn lchol yereꞌreꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ka bllin lla byoꞌ lnni danꞌ llon akeꞌ ka nak lljadinraꞌll akeꞌ llanꞌ benlaꞌy akeꞌ yodaꞌo brao ke Diosenꞌ, naꞌ ba bllin lla llak zay Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naꞌ dá Jesúsenꞌ lo lchir ke Salomón naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Naꞌ beꞌnn wnebiaꞌ ke Israelenꞌ, byechj akeꞌ Jesúsenꞌ ne akeꞌ: —¿Bixchen llonllejlaꞌlloꞌ netoꞌ, chaꞌ rweꞌn nakoꞌ Cristo? Bnetega netoꞌ chet kaꞌ rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Naꞌll lle Jesúsenꞌ leakeꞌ: —Ba bnekzaꞌ, naꞌ reꞌ bi llejleꞌre. Da kaꞌ ba benaꞌn kone yel wak ke Xaꞌ naꞌn, llroeꞌn nakaꞌ beꞌnn bseꞌl Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Naꞌ bi llejleꞌre kiaꞌ, le bi llonre txhen beꞌnn kaꞌ llonliraꞌll nadaꞌ, kanꞌ ba bnekzaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Beꞌnn kaꞌ nak ka xhiꞌr daꞌo kiaꞌ kaꞌ, nombiaꞌ akeꞌ chiaꞌn. Naꞌ nadaꞌ nombiaꞌ akeꞌ, naꞌ nao akeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naꞌ lloeꞌ akeꞌ yel nban zejlikane, naꞌ kbat kweyiꞌ akeꞌ, naꞌ nono gak yekaꞌa leakeꞌ rao naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xaꞌ naꞌ, ba brejeꞌ beꞌnn kaꞌ llonliraꞌll nadaꞌ, nench llwia akeꞌ, naꞌ notno gak yekaꞌa leakeꞌ rao naꞌa Xaꞌn, le napeꞌ yel llnebiaꞌ ga zeraoze. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nadaꞌ ren Xaꞌ naꞌ, naktoꞌ ka toze beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bayoll bneꞌe kaꞌ, le bxhiꞌte beꞌnn wnebiaꞌ kaꞌ yej, gokraꞌll akeꞌ wchekw akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Naꞌll lle Jesúsenꞌ leakeꞌ: —Da zan da wen ba breꞌre benaꞌ kone yel wak ke Xaꞌn. ¿Bixha ken lleꞌnere wchekwre nadaꞌ yej? ");
INSERT INTO zpuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Naꞌll lle beꞌnn wnebiaꞌ kaꞌ Leꞌe: —Kere ke da wen kaꞌ benoꞌ naꞌn, wchekwtoꞌ rweꞌ yejenꞌ, danꞌ llkadiꞌo ke Dios naꞌ, le beꞌnnachze rweꞌ, naꞌ llon kwinoꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Naꞌll lle Jesúsenꞌ leakeꞌ: —Nnézkzere kanꞌ nyoj xtiꞌll Diosenꞌ danꞌ nzedrenꞌ ganꞌ nen: “Nadaꞌ ba bniaꞌ reꞌ, nakre ka dios kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Naꞌ xtiꞌll Dios danꞌ nyojen kere da te ken, naꞌ len naꞌ nen Diosenꞌ bneꞌe ke beꞌnn kaꞌ bzenay xtiꞌlleꞌn kanaꞌ, gok akeꞌ ka Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Diosenꞌ brejeꞌ nadaꞌ nench gakrenaꞌ beꞌnnach llaꞌa yellrio ni, naꞌ ¿bixchen nere llkwasaꞌ Diosenꞌ kaꞌle, danꞌ niaꞌ nakaꞌ Xhiꞌnneꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Chaꞌ bi llonaꞌ yel wak ke Xaꞌ Diosenꞌ, bi llayaꞌl chejleꞌre kiaꞌ chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Zan chaꞌ llakbeꞌre llonaꞌ da zaꞌk kone yel wak ke Diosenꞌ, llayaꞌl chejleꞌre, Leꞌen bseꞌleꞌ nadaꞌ, laꞌkze bi lleꞌnere chejleꞌre xtiꞌllaꞌn. Naꞌ chaꞌ chejleꞌre ke da kaꞌ ba llonaꞌ naꞌ, naꞌllenꞌ nnézere zerenkze Xaꞌn nadaꞌ, naꞌ leskaꞌ nadaꞌ zerenaꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Naꞌll gokraꞌll akeꞌ goꞌx akeꞌ Jesúsenꞌ da yobre, naꞌ bi bdoꞌleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesúsenꞌ bayejeꞌ ganꞌ zoeꞌ ye chlaꞌ yeo Jordán naꞌ, latje ganꞌ bzo da Juan naꞌ, chak bchoeꞌ beꞌnne nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Naꞌ beꞌnn zan jak ganꞌ zoeꞌn nench bzenay akeꞌ xtiꞌlleꞌn, naꞌ bne akeꞌ: —Da Juan naꞌ, ni to yel wak bibi beneꞌ, zan yeolol danꞌ bneꞌe ke beꞌnn ni, naken da li. ");
INSERT INTO zpuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naꞌ beꞌnn zan benliraꞌll Jesúsenꞌ latj naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","To beꞌnne gokeꞌ yillweꞌ, golle Lázaro bzoeꞌ ganꞌ nziꞌi Betania, ren ye chop zaneꞌ kaꞌ nziꞌi María ren bireꞌ, beꞌnnenꞌ re Marta. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(María, zan Lázaro naꞌ, leꞌen bwazj to ceit danꞌ laꞌ xhix niaꞌ Xanllo Jesúsenꞌ, bayoll naꞌ, bachechteꞌn kone yich yichjeꞌ.) ");
INSERT INTO zpuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Naꞌ kaꞌ gok llop bir noꞌr ki, bseꞌl akeꞌ rson ke Jesúsenꞌ, lle akeꞌ Leꞌe: —Xantoꞌ, beꞌnnenꞌ nllieꞌroꞌ, re Lázaronꞌ ba llakeꞌ yillweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ka bnneze Jesúsenꞌ llak Lázaronꞌ yillweꞌ, naꞌll bneꞌe: —Ka nak yillweꞌ llak beꞌnnenꞌ bi kwiayiꞌreneꞌn, llakeꞌ kaꞌ nench gakbeꞌre katek beꞌnn zaꞌk nak Diosenꞌ, naꞌ gakbeꞌre nakaꞌ nadaꞌ beꞌn zaꞌk kwis, nadaꞌ nakaꞌ dogarj Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Naꞌ nllieꞌ Jesúsenꞌ Martanꞌ ren bireꞌ naꞌ, naꞌ ren Lázaronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ka bnnezreꞌ llak Lázaronꞌ yillweꞌ, naꞌ bzoeꞌ ye to chop lla ganꞌ zoeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Naꞌll golleꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ: —Lechoꞌo, chejllo ganꞌ nbane Judeanꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Naꞌ lle akeꞌ Leꞌe: —Maestro, bi lla naꞌze gokraꞌll beꞌnn kaꞌ llaꞌa gannaꞌ, got akeꞌ rweꞌ, wchekw akeꞌ rweꞌ yej. ¿Naꞌ lleꞌnchkeroꞌ chejlloꞌ gannaꞌ da yobre? ");
INSERT INTO zpuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesúsenꞌ lleꞌe leakeꞌ: —Rao lla nsaꞌn chllinn (12) hor, naꞌ beꞌnn dá te lla bi lljacheꞌweꞌ le zo willenꞌ nseniꞌn rao yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Naꞌ beꞌnn dá ba gole lljacheꞌweꞌ, le ba nak xchole. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bayoll bneꞌe kaꞌ, naꞌll lleꞌe leakeꞌ: —Beꞌnnenꞌ nllieꞌllo nziꞌi Lázaronꞌ ba lltaseꞌ, naꞌ chaꞌa lljasbaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Naꞌll lle akeꞌ Leꞌe: —Xantoꞌ, chaꞌ ba lltaseꞌ, wayakzereꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kaꞌ bne Jesúsenꞌ, le ba bnnezreꞌ ba got Lázaronꞌ, naꞌ beꞌnn kaꞌ nao Jesúsenꞌ, llak akreꞌ chaꞌ taszeꞌ llaziꞌraꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naꞌll goll Jesúsenꞌ leakeꞌ lixheje: —Ba got Lázaronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Naꞌ llaweraꞌ bi bzoaꞌ gannaꞌ kanꞌ gokeꞌ yillweꞌn, nench naꞌ chejleꞌre kiaꞌ. Lechoꞌo chejllo ganꞌ deꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Naꞌll beꞌnnenꞌ re Tomás, beꞌnnenꞌ bsiꞌi akeꞌ Tomás Dídimo golleꞌ yezikre beꞌnn kaꞌ non Jesúsenꞌ txhen: —Lechoꞌo nench gatrenllo Jesúsenꞌ txhen, chaꞌ ba llot akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Naꞌ ka bllin Jesúsenꞌ Betanianꞌ ren beꞌnn kaꞌ non Leꞌe txhen naꞌ, lle akeꞌ Leꞌe ba gok tap lla nnaꞌ, bkwaꞌch akeꞌ Lázaronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania naꞌ, lliꞌn awlloze Jerusalén ka do choll daꞌoze llgoꞌllo nez. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Beꞌnn zan beꞌnn Israel kaꞌ, bllin akeꞌ ganꞌ zo Martanꞌ ren Maríanꞌ, lloeꞌ akeꞌ leakeꞌ yel llxhenraꞌlle danꞌ got zan akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ka bnneze Martanꞌ ba bllin Jesúsenꞌ lloaꞌ yellenꞌ, naꞌll bzaꞌdoeꞌ jatileꞌ Leꞌe, naꞌ María naꞌ bagaꞌnneꞌ yoꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Naꞌll lle Martanꞌ Jesúsenꞌ: —Xanaꞌ, chenak zoꞌo ganni kanꞌ gok beꞌnn zanaꞌn yillweꞌ, bije goteꞌ chenake. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Naꞌ nnezraꞌ laꞌkze ba goteꞌ, biteze bi da nnabroꞌ Diosenꞌ gonkzeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Naꞌll lle Jesúsenꞌ leꞌe: —Wabán bi zanoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naꞌll lle Martanꞌ Leꞌe: —Nnézkzeraꞌ wabaneꞌ kat yebán beꞌnn wat kaꞌ, kat llin lla wayoll yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Naꞌll lle Jesúsenꞌ leꞌe: —Nadaꞌ napaꞌ yel wak yesbanaꞌ beꞌnn wat kaꞌ, naꞌ weꞌe akeꞌ yel nban zejlikane. Naꞌllenꞌ beꞌnn kaꞌ gonliraꞌll nadaꞌ, laꞌkze gat akeꞌ, waꞌt yel nban zejlikane ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Naꞌ noteze beꞌnn niꞌt gonliraꞌlle nadaꞌ, kbat gat beꞌnn kaꞌ, naꞌ bi kweyiꞌ akeꞌ. ¿Llejleꞌo danꞌ llepaꞌ rweꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naꞌll lle Martanꞌ Leꞌe: —Xanaꞌ, llejliaꞌ nakoꞌ dogarje Xhiꞌnn Dios, llejliaꞌ nakoꞌ Cristo beꞌnnenꞌ ba breztoꞌ wseꞌl Diosenꞌ yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bayoll goll Martanꞌ Leꞌe kaꞌ, bayejeꞌ jayelleꞌ María bireꞌn kaꞌ llillize: —Ba braꞌ Maestronꞌ lloaꞌ yell naꞌ, naꞌ llaxheꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naꞌll kate bene Maríanꞌ kanꞌ goll Martanꞌ leꞌe naꞌ, le bzaꞌdoteꞌ byejeꞌ ganꞌ zo Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bi nna choꞌ Jesúsenꞌ lyellenꞌ, naꞌ zeꞌe lloaꞌ yellre ganꞌ jatil Martanꞌ Leꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Naꞌ beꞌnn Israel kaꞌ, zjallaꞌa rill Maríanꞌ, lloeꞌ akeꞌ leꞌe yel llxhenraꞌll danꞌ got zaneꞌ naꞌ. Ka breꞌe akreꞌ bzaꞌdoeꞌn, naꞌll naodo akeꞌ leꞌe, llak akreꞌ chaꞌ zejeꞌ lloaꞌ ba naꞌ zjachelleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Naꞌ Maríanꞌ, kate bllineꞌ ganꞌ ze Jesúsenꞌ, le bzoate xhibeꞌ raweꞌ ka breꞌreꞌ Leꞌen, naꞌ lleꞌe Leꞌe: —Xanaꞌ, chenak zoꞌo ganni kanꞌ gok beꞌnn zanaꞌn yillweꞌ, bije gotjeꞌ chenake. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Naꞌ ka breꞌe Jesúsenꞌ bell Maríanꞌ, naꞌ ren beꞌnn Israel kaꞌ zaꞌrén leꞌe naꞌ, naꞌ gokyaꞌchreꞌ kwis naꞌ gokeꞌ lo yichjraꞌlldaꞌweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Naꞌ lleꞌe leakeꞌ: —¿Gaxha jakwaꞌchreꞌ? Naꞌll lle akeꞌ Leꞌe: —Xantoꞌ, choꞌke lljawiaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Naꞌ bllell Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Naꞌ beꞌnn Israel kaꞌ, bne akeꞌ: —Lewiake katekenꞌ llákereꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Naꞌ baleꞌ bne: —Beꞌnn ni bayoneꞌ rao beꞌnn lcholenꞌ bareꞌreꞌ, chenak zoeꞌ ni, kanꞌ gok Lázaronꞌ yillweꞌn, bije goteꞌ chenake. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesúsenꞌ gokeꞌ lo raꞌlldaꞌweꞌn da yobre. Ka byejeꞌ ganꞌ jakwaꞌch akeꞌ Lázaronꞌ, naken to broj, naꞌ daꞌa to yej lloaꞌ banꞌ da nsej lloeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Naꞌll lle Jesúsenꞌ leakeꞌ: —Lewkaꞌa yejenꞌ. Naꞌ Marta zan da Lázaronꞌ, lleꞌe Leꞌe: —Xanaꞌ, ba laꞌ beꞌnnenꞌ zban, le ba gokte tap llanꞌ goteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naꞌll lle Jesúsenꞌ leꞌe: —¿Bixha kere ba bnetiaꞌ, chaꞌ gonliraꞌlloꞌ nadaꞌ, naꞌ reꞌroꞌ nak Diosenꞌ beꞌnn zaꞌk xhen? ");
INSERT INTO zpuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Naꞌll bkaꞌa beꞌnn kaꞌ yejenꞌ, naꞌll le bwiate Jesúsenꞌ yebáre, naꞌ bneꞌe: —Xa, llioxkenoꞌ ba bzenayoꞌ kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nnezraꞌ yeo ras llzenayoꞌ kiaꞌ, niaꞌ kaꞌ nench chejleꞌ beꞌnn kaꞌ, rweꞌkzoꞌn bseꞌloꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bayoll balwilleꞌ Diosenꞌ, naꞌll bnneꞌe zillje, bneꞌe: —¡Lázaro, balloje! ");
INSERT INTO zpuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Naꞌll le ballojte Lázaronꞌ ndob do niaꞌneꞌe to raꞌlle, naꞌ lloaꞌ raweꞌn ndoben to bay. Naꞌll lle Jesúsenꞌ leakeꞌ: —Leyesell raꞌllenꞌ, naꞌ leyesaneꞌ wayejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Naꞌ zan beꞌnn Israel kaꞌ, beꞌnn kaꞌ byej ren Maríanꞌ, breꞌe akreꞌ ka yel wakenꞌ ben Jesúsenꞌ, naꞌll benliraꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Naꞌ bal beꞌnn Israel kaꞌ, jakeꞌ rao beꞌnn fariseo kaꞌ, naꞌ jayell akeꞌ leakeꞌ kanꞌ ben Jesúsenꞌ basbaneꞌ Lázaronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Naꞌll bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn fariseo kaꞌ, batop akeꞌ beꞌnn kaꞌ nak koxchis llnebiaꞌ Israelenꞌ. Naꞌ bzorao akeꞌ ne akeꞌ: —¿Akxha gonllo nnaꞌ? Le yel wak zan naꞌ, llon beꞌnn ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chaꞌ nnello waljezen, yeololze beꞌnn gonliraꞌll akeꞌ Leꞌe, naꞌ yed beꞌnn Roma kaꞌ yedlan akeꞌ yodaꞌo brao kellonꞌ, naꞌ yedlleyiꞌ akeꞌ rall-llonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Naꞌ to beꞌnn wnebiaꞌ zo kanaꞌ reꞌe Caifás. Leꞌe nakeꞌ bxoz brao iz naꞌ, naꞌ lleꞌe leakeꞌ: —Reꞌ ni ke bi nnézzere. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bi llakbeꞌre naken wen kello gat toze beꞌnne, kerke da kweyiꞌ yeolol-llo, naꞌ rente yell kello ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kere dogarjenꞌ bne Caifásenꞌ kaꞌ, danꞌ nakeꞌ bxoz brao iz naꞌn, naꞌllenꞌ bneꞌe kaꞌ, Diosenꞌ beneꞌ bneꞌe kaꞌ, nench naꞌ bdixjweꞌreꞌ gat Jesúsenꞌ, ni ke yell Israel naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Naꞌ danꞌ gateꞌ naꞌ, kere ke beꞌnn Israel kaꞌze, renkze ke yeolol beꞌnn ba brej Diosenꞌ gak xhiꞌnneꞌ doxhente, gak akeꞌ Leꞌe txhen gonliraꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaꞌ gok, naꞌ lla naꞌte bzorao beꞌnn wnebiaꞌ kaꞌ, ben akeꞌ diꞌll akre gon akeꞌ nench yesoꞌte Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ke len naꞌ, bill bda Jesúsenꞌ ganꞌ llaꞌa beꞌnn wnebiaꞌ ke Israelenꞌ, naꞌ bzeꞌe Judeanꞌ, naꞌ byejeꞌ to yell da nziꞌi Efraín danꞌ lliꞌ awlloze latj dachenꞌ, naꞌ bagaꞌnnreneꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Naꞌ ba zo rez gaꞌle lnni paskw ke beꞌnn Israel kaꞌ. Naꞌ beꞌnn zan zaꞌk toto yell jakeꞌ Jerusalén naꞌ, kanꞌ za gaꞌl lnni naꞌ, nench wayón kwin akeꞌ yall rao Diosenꞌ kanꞌ ne ley ke akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Naꞌll dá akeꞌ llayirj akeꞌ Jesúsenꞌ do ganꞌ zo yodaꞌo brao naꞌ, naꞌll lle lwellj akeꞌ: —¿Bi ka nere? ¿Bi yedeꞌ lnninꞌ lla? ");
INSERT INTO zpuNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bne akeꞌ kaꞌ le bxoz wnebiaꞌ kaꞌ, naꞌ beꞌnn fariseo kaꞌ, ba bchoy akeꞌn chaꞌ noteze beꞌnn nnezreꞌ ganꞌ zo Jesúsenꞌ, llayaꞌl wzenreꞌ leakeꞌ nench naꞌ lljeꞌx akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Naꞌ ka ye xop llare gaꞌle lnni paskwnꞌ, byej Jesúsenꞌ yell Betania naꞌ, ganꞌ zo Lázaro beꞌnnenꞌ basbaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Naꞌ bsiniaꞌ akeꞌ da bdao Jesúsenꞌ xcheꞌ, nench ben akeꞌ Leꞌe xhen. Naꞌ Marta naꞌ, bdieꞌ yel wao ke akeꞌn, naꞌ Lázaronꞌ blleꞌreneꞌ beꞌnn kaꞌ txhen, bdaoreneꞌ leakeꞌ ren Jesús naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Naꞌ Maríanꞌ noꞌxeꞌ ka do tya ceit xhix keꞌe da zaꞌk da xhen, naꞌ naken dogarje da blloj yay yej xhix danꞌ nziꞌi nardo. Naꞌ jabiꞌyeꞌ awllo xhniaꞌ Jesúsenꞌ, naꞌll broeꞌ ceit xhixenꞌ nieꞌn. Naꞌll bayoll naꞌ, bachechteꞌn kone yich yichjeꞌn. Naꞌ doxhen lo yoꞌn, blaꞌ xhix kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Naꞌ Judas Iscariote xhiꞌnn to beꞌnn re Simón, beꞌnnenꞌ nak txhen beꞌnn chllinn kaꞌ, beꞌnnenꞌ ba naken wdieꞌ Jesúsenꞌ rao naꞌa beꞌnn kaꞌ llwietate Leꞌen, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Bixchen bi beꞌteꞌ ceitenꞌ, naꞌ gaꞌt mell nench gakrenen beꞌnn yaꞌche? Le ceitenꞌ zaꞌken ka chonn gayoa (300) mell danꞌ nziꞌi denario. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kaꞌ bne Judasenꞌ, naꞌ kere danꞌ llayaꞌchraꞌlleꞌ beꞌnn yaꞌch kaꞌn bneꞌe kaꞌ, danꞌ gokeꞌ beꞌnn wan naꞌ. Le leꞌen noꞌxeꞌ mell danꞌ benrén yeololeꞌ llin, naꞌ brejraneꞌ mellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Naꞌll lle Jesúsenꞌ leꞌe: —Bitbi yeꞌweꞌ, le ba beneꞌ da non goneꞌ kiaꞌ kat gaꞌchaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Beꞌnn yaꞌch kaꞌ, llaꞌrenkzre beꞌnn kaꞌ batteze, zan nadaꞌ bill sorenaꞌ reꞌ ye scha. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Beꞌnn zan beꞌnn Israel kaꞌ, bnnez akreꞌ zo Jesúsenꞌ yell Betanianꞌ, naꞌ byej akeꞌ, naꞌ kere danꞌ reꞌe akreꞌ toze Jesús naꞌn, lleꞌn akzereꞌ reꞌe akreꞌ Lázaro beꞌnnenꞌ basbaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Naꞌ bxoz wnebiaꞌ ke Israel kaꞌ, leskaꞌ ben akeꞌ diꞌll gotrén akeꞌ Lázaronꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","le beꞌnn zan beꞌnn Israel kaꞌ, ba llaraꞌll akeꞌ leakeꞌ, naꞌ ba llonliraꞌll akeꞌ Jesúsenꞌ danꞌ bnnez akreꞌ basbaneꞌ Lázaronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Naꞌ ka bateyó, bazaꞌa Jesúsenꞌ Betanianꞌ zayejeꞌ Jerusalén naꞌ, naꞌ beꞌnn zan llay Jerusalén naꞌ, danꞌ ba zo rez gaꞌle lnni naꞌ. Naꞌ beꞌnn zan ba bnnez akreꞌ llin Jesúsenꞌ Jerusalén naꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","bllach akeꞌ jalexh akeꞌ Leꞌe noꞌx akeꞌ no ziꞌn, naꞌ llosiaꞌ akeꞌ llasné akeꞌ: —¡Nbaraz, beꞌnn nak laꞌy beꞌnn ni! ¡Nbaraz beꞌnnenꞌ zaꞌa, nseꞌl Xanllo Diosenꞌ le Leꞌen nnebieꞌ! ¡Nbaraz beꞌnnenꞌ nak Rey ke Israelenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Naꞌ bllele Jesúsenꞌ to burr daꞌo ba bllieꞌ, naꞌ gok kanꞌ nyoj xtiꞌll Diosenꞌ nen: ");
INSERT INTO zpuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Reꞌ llonre Diosenꞌ xhen ganꞌ nziꞌi Sión naꞌ, bi llebre naꞌ, ba zaꞌa Rey kerénꞌ llieꞌ to burr daꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naꞌ beꞌnn kaꞌ non Jesúsenꞌ txhen bi byejnieꞌ akzereꞌn. Bayoll got Jesúsenꞌ, naꞌ broeꞌrao Jesúsenꞌ nakeꞌ beꞌnn zaꞌk xhen, kanaꞌll jadinraꞌll akeꞌ diꞌll kaꞌ nyoj ke Jesúsenꞌ, naꞌll byejnieꞌ akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Beꞌnn kaꞌ breꞌe kanꞌ balwill Jesúsenꞌ Lázaronꞌ, basbaneꞌ leꞌe nench ballojeꞌ lo ba naꞌ, beꞌrén akeꞌ beꞌnn kaꞌ llaꞌa yellenꞌ diꞌll kanꞌ goken. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Naꞌllenꞌ jalez beꞌnn zan kwis Jesúsenꞌ, danꞌ ba ben akreꞌ diꞌll ke yel wak danꞌ basbaneꞌ Lázaronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Naꞌll lle lwellj beꞌnn fariseo kaꞌ: —Ba breꞌre bikze bi llak gonllo. Yeololze beꞌnne ba llzenay akeꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","To chop beꞌnn griego ak jen akeꞌ Diosenꞌ xhen rao lnni naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Naꞌ beꞌnn ki ballín akeꞌ ganꞌ zo Felipenꞌ, beꞌnnenꞌ nak beꞌnn Betsaida ganꞌ nbane Galilea, naꞌ lle akeꞌ leꞌe: —Siꞌxhenchgoꞌ, lleꞌnetoꞌ weꞌrentoꞌ Jesúsenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Naꞌll byej Felipenꞌ jawieꞌ Andrésenꞌ, naꞌll llop akteꞌ jell akeꞌ Jesúsenꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Naꞌll lle Jesúsenꞌ leakeꞌ: —Nnaꞌ ba bllin lla gak yeolol da llayaꞌl gak, nench naꞌ wroeꞌrawaꞌ nakaꞌ beꞌnn zaꞌk xhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Diꞌll li, diꞌll li niaꞌ reꞌ: Chaꞌ to nbaz trigonꞌ bi chazen lo yo, naꞌ yexhinnjen, naksen toze nbaz; zan chaꞌ yexhinnjen, naꞌ raꞌn, da zan trigo yeyaken. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Noteze beꞌnn kon lliꞌ yichj akeꞌ gak wen ke akeꞌ yellrio nize, beꞌnn kaꞌn kwiayiꞌ akeꞌ. Naꞌ noteze beꞌnne llsanraꞌll kwineꞌ, biteze da llak ke yellrio ni, waꞌt yel nban zejlikane ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Naꞌ noteze beꞌnne lleꞌn akreꞌ gon akeꞌ xchinaꞌn, llayaꞌle gon akeꞌ nadaꞌ txhen. Naꞌ ganꞌ soaꞌ nadaꞌ, lekze naꞌ so beꞌnn kaꞌ yesoꞌn xchinaꞌn. Noteze beꞌnne gon xchinaꞌn, Xaꞌ naꞌ goneꞌ gak akeꞌ xhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ba llak zozeze lo yichjraꞌlldaꞌwaꞌn. ¿Akxha yepaꞌ Xaꞌn? ¿Llákere nnabreꞌ yesreꞌe nadaꞌ danꞌ ba zo gak kiaꞌ naꞌn? Bi gonaꞌ kaꞌ, le ke len naꞌ zaꞌa gak kiaꞌ yeolol da ki. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Naꞌll balwilleꞌ Dios, bneꞌe: —Xa, ben nadaꞌ nench gakbeꞌe beꞌnne nakoꞌ beꞌnn zaꞌk kwis. Bayoll bneꞌe kaꞌn, blloj to be xhnne yebánꞌ: —Nadaꞌ ba benkzaꞌ nench gakbeꞌe beꞌnn nakaꞌ beꞌnn zaꞌk, naꞌ gonllkzaꞌ kaꞌ ye to, nench yeyakbeꞌe akreꞌ nakaꞌ beꞌnn zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Naꞌ beꞌnn zan kaꞌ llaꞌa naꞌ, ben akreꞌ kanꞌ bne Diosenꞌ, naꞌ baleꞌ llasné yiꞌwziꞌon gochj. Naꞌ ye baleꞌ llasné akeꞌ: —To anglenꞌ bneꞌe leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Naꞌ Jesúsenꞌ bneꞌe: —Diosenꞌ bnneꞌe nadaꞌ zillje, kere nench yenraꞌ nadaꞌn, bnneꞌe zillje nench yene reꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ba bllin lla wchoybiaꞌ Diosenꞌ ke beꞌnn kaꞌ bi llejleꞌ kiaꞌ. Naꞌ ba bllin lla yelloj daxiꞌon kaꞌle, danꞌ llnebiaꞌ beꞌnn kaꞌ llaꞌa yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Naꞌ kate wlis akeꞌ nadaꞌ rao yellrionꞌ, kanaꞌll gonaꞌ nench gonliraꞌll beꞌnn llaꞌa doxhente yellrio nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Bneꞌe kaꞌ nench bnnez akreꞌ akrenꞌ got beꞌnn kaꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Naꞌ beꞌnn kaꞌ zjallaꞌa naꞌ, lle akeꞌ leꞌe: —Netoꞌ ba bénetoꞌ kanꞌ ne xtiꞌll Dios danꞌ nyojen, Cristonꞌ soeꞌ ke chnare. Naꞌ rweꞌ, ¿bixchen nezoꞌ nakoꞌ Beꞌnn Gorj Radj Beꞌnnach, naꞌ neꞌo got akeꞌ rweꞌ to leꞌ yay cruze? ¿Noxha nakoꞌ naꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Naꞌll goll Jesúsenꞌ leakeꞌ: —Ye chollzenꞌ zorenaꞌ reꞌ, naꞌ nsaꞌa beniꞌ ke yichjraꞌlldaꞌorenꞌ. Lewzenay kiaꞌ chaga nna de latje choꞌ beniꞌ kiaꞌn lo yichjraꞌlldaꞌorenꞌ, nench bi kweyiꞌrenre da xhinnjenꞌ danꞌ llnebiaꞌ reꞌn. Le beꞌnn dá ga nak xchole bi llakbeꞌreꞌ ganꞌ zejeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Legonliraꞌll nadaꞌ chak nna zorenaꞌ reꞌ, nench choꞌ beniꞌ kiaꞌn lo yichjraꞌlldaꞌore. Bayoll bne Jesúsenꞌ kaꞌ, le bazaꞌteꞌ jakwaꞌchreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Naꞌ laꞌkze breꞌe beꞌnn Israel kaꞌ, ben Jesúsenꞌ zan yel wak, bi byejleꞌ akzeꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","nench bzoa diꞌll kanꞌ bzoj da Isaías beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, bneꞌe: Xanaꞌ, nono llejleꞌ diꞌll danꞌ chixjweꞌtoꞌn, naꞌ nono ba bayakbeꞌe yel wak kaꞌ ba benoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bi gok chejleꞌ akeꞌ, le kaꞌkzenꞌ bzoj da Isaíasenꞌ, bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diosenꞌ beneꞌ nench nak akeꞌ ka beꞌnn lchole, naꞌ beneꞌ nench nak akeꞌ beꞌnn nak yichjraꞌlldaꞌo war. Naꞌ beneꞌ kaꞌ nench bi reꞌe akreꞌ, naꞌ bi llayakbeꞌe lo yichjraꞌlldaꞌo akeꞌn bi zejen danꞌ llroeꞌreꞌ leakeꞌn, naꞌ bi wayat akreꞌ, naꞌ bi wayoneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kaꞌ bne Isaíasenꞌ, le breꞌreꞌ batnaꞌte Jesúsenꞌ nakeꞌ beꞌnn zaꞌk kwis, naꞌllenꞌ beꞌe diꞌll keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Naꞌ laꞌkze naken kaꞌ, beꞌnn zan byejleꞌ keꞌe, ren no beꞌnn wnebiaꞌ kaꞌ, benliraꞌll akeꞌ Leꞌe, naꞌ bi beꞌe akeꞌ diꞌll chaꞌ llonliraꞌll akeꞌ Leꞌe, le lleb akeꞌ bill wreb beꞌnn fariseo kaꞌ leakeꞌ lo yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lleꞌn akllreꞌ sorén beꞌnnach leakeꞌ wen, kerke da sorén akeꞌ Diosenꞌ wen. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Naꞌll bne Jesúsenꞌ zillje, golleꞌ beꞌnn kaꞌ zjallaꞌa naꞌ: —Beꞌnn gonliraꞌlle nadaꞌ, kere toze nadaꞌn gonliraꞌlleꞌ, renkze Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ naꞌn llonliraꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Naꞌ beꞌnnenꞌ llreꞌe nadaꞌn, llreꞌreꞌ beꞌnnenꞌ bseꞌl nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nadaꞌ zaꞌa yellrio ni, llgoaꞌ beniꞌ lo yichjraꞌlldaꞌo beꞌnn kaꞌ llonliraꞌll nadaꞌ, nench bill so aklleꞌ rao da xcholenꞌ, naꞌ bill gon aklleꞌ da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Naꞌ noteze beꞌnne nnezreꞌ kanꞌ ba bniaꞌn, naꞌ chaꞌ bi llzenayeꞌ kiaꞌ, kere nadaꞌn waꞌa yel llzaꞌkziꞌ ke doꞌl keꞌen, le kere zaꞌa yellrionꞌ waꞌa yel llzaꞌkziꞌ ke doꞌl ke beꞌnnachenꞌ, zaꞌa nench yesraꞌa beꞌnn gonliraꞌll nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Naꞌ de da wchoybiaꞌ ke beꞌnn kaꞌ bi llonliraꞌll nadaꞌn, le bi llzenay akeꞌ ke danꞌ ba bniaꞌ naꞌ, xtiꞌllaꞌ danꞌ ba bniaꞌ naꞌ, len naꞌ choybiaꞌn ke beꞌnn kaꞌ nap akeꞌ doꞌle, kat llin lla yeyoll yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kere to wrazzaꞌn niaꞌ kaꞌ, Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ naꞌn, golleꞌ nadaꞌ bi da kaꞌ llayaꞌl nniaꞌn, naꞌ bi da llayaꞌl wroeꞌ wsedraꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nnezraꞌ danꞌ nllieꞌ biaꞌa, nsaꞌn yel nban zejlikane ke beꞌnn wzenay len, naꞌ da li kon kanꞌ ne Xaꞌ naꞌn, kaꞌn lloeꞌrenaꞌ reꞌ diꞌll. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ka za gaꞌl lnni paskwnꞌ Jesúsenꞌ ba nnezreꞌ ba bllin lla yezeꞌe yellrionꞌ, naꞌ yeyejeꞌ ganꞌ zo Xeꞌe Diosenꞌ, naꞌ kanꞌ nllieꞌkzreꞌ yeolol beꞌnn kaꞌ llonliraꞌll Leꞌen yellrio ni, naꞌ kaꞌkze bllieꞌreꞌ leakeꞌ bayollte. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Naꞌ ka nak ba llaꞌa akeꞌ llao akeꞌ xcheꞌn, naꞌ ba byoꞌ daxiꞌon lo yichjraꞌlldaꞌo Judas Iscariotenꞌ, beꞌnnenꞌ nak xhiꞌnn beꞌnnenꞌ re Simón, nench naꞌ wdieꞌ Jesúsenꞌ rao naꞌa beꞌnn kaꞌ llwietate Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Naꞌ nneze Jesúsenꞌ ba ben Xeꞌen Leꞌe napeꞌ le zeraoze yel llnebiaꞌ, naꞌ nnezreꞌ ganꞌ zo Diosenꞌ bzeꞌe, naꞌ naꞌkzenꞌ wayejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Naꞌ bzolleꞌe ganꞌ llaꞌa akeꞌ llao akeꞌ xcheꞌn, naꞌ golje xheꞌe danꞌ nakeꞌ koꞌllreꞌ, naꞌll bxhieꞌ to raꞌll da broꞌ lsiꞌneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Naꞌll bxhieꞌ nis, naꞌ bdeꞌen to lo chaꞌ, naꞌll bzoraweꞌ bdibeꞌ niaꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, naꞌll bachechteꞌ niaꞌ akeꞌn kone raꞌll danꞌ ngoꞌ lsiꞌneꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Naꞌ ka bayaꞌl chibeꞌ niaꞌ Simón Pedro naꞌn, naꞌll lle Pedronꞌ Leꞌe: —Xanaꞌ, ¿rweꞌ chiboꞌ niaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Naꞌll lle Jesúsenꞌ leꞌe: —Danꞌ llonaꞌ ni bi llejnieꞌroꞌn nnaꞌ, zan wllin lla kat chejnieꞌroꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Naꞌll lle Pedronꞌ Leꞌe: —Ni ke gonnzaꞌ latj chiboꞌ niaꞌn. Jesúsenꞌ lleꞌe leꞌe: —Chet kaꞌ bi chibaꞌ niaꞌon, bill gak gakoꞌ nadaꞌ txhen chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Naꞌll lle Pedronꞌ Leꞌe: —Xanaꞌ, kere to niaꞌnaꞌzenꞌ chiboꞌ, doxhenkzaꞌn chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Naꞌll goll Jesúsenꞌ leꞌe: —Beꞌnn noꞌch nazjeꞌ, nieꞌ naꞌzeꞌn lleꞌnen chall, le doxheneꞌ nakeꞌ yalle. Kanꞌ nak reꞌ, nak yichjraꞌlldaꞌorenꞌ yalle, laꞌkze kere yeololre. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Le Jesúsenꞌ bnnezreꞌ nonꞌ wde Leꞌe rao naꞌa beꞌnn kaꞌ llwietate Leꞌe. Naꞌllenꞌ bneꞌe: “Kere yeololrenꞌ nak raꞌlldaꞌorenꞌ yalle.” ");
INSERT INTO zpuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Naꞌll ka bayoll bdibeꞌ niaꞌ yeololteꞌn, naꞌll bayakweꞌ xheꞌe danꞌ nakeꞌ koꞌllre, naꞌll babieꞌ ganꞌ lliꞌ akeꞌ llao akeꞌn da yobre. Naꞌ lleꞌe leakeꞌ: —¿Llejnieꞌre akre zejen danꞌ benrenaꞌ reꞌ ganni? ");
INSERT INTO zpuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Reꞌ nsiꞌre nadaꞌ Maestro naꞌ xanre, wenkzenꞌ nere kaꞌ, le kaꞌn naksaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nadaꞌ laꞌkze nakaꞌ maestro keré naꞌ xanre, ba bdibaꞌ niaꞌrenꞌ ka llon to beꞌnn wen llin, naꞌ kaꞌn llayaꞌl gakrén lwelljre, gakre ka to beꞌnn wen llin ke beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ba bdibaꞌ niaꞌrenꞌ nench broeꞌraꞌ reꞌ, llayaꞌl gonre kanꞌ ba benaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Diꞌll li, diꞌll li niaꞌ reꞌ: Noteze no beꞌnn nak beꞌnn wen llin, bi nakeꞌ beꞌnn llonlle ka xaneꞌn, naꞌ to beꞌnn zej ga zejeꞌ, bi zaꞌklleꞌ ka beꞌnnenꞌ bseꞌl leꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chaꞌ chejnieꞌre da ki, naꞌ gonre kanꞌ bniaꞌn, naꞌllenꞌ sore nbaraz. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Bi niaꞌ kaꞌ ke yeololre. Nombiaꞌ yichjraꞌlldaꞌo toto reꞌ ba brejaꞌ nench sorenre nadaꞌ txhen. Naꞌ nnezraꞌ gak kanꞌ ne xtiꞌll Diosenꞌ danꞌ nyojen nen: “Beꞌnnenꞌ bdaorén nadaꞌ txhen, ba brej bchekweꞌ nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Llepaꞌ reꞌ da ki za gak, nench kat ba goken naꞌ, naꞌll chejleꞌre nakaꞌ beꞌnn bseꞌl Dios, kanꞌ ba bnekzaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Diꞌll li, diꞌll li niaꞌ reꞌ: Beꞌnn wrebe noteze beꞌnn llseꞌlaꞌ, nadkzaꞌn llreb akeꞌ chet kaꞌ, naꞌ beꞌnn wrebe nadaꞌ, leskaꞌ Dios naꞌkzenꞌ, llreb akeꞌ, beꞌnnenꞌ bseꞌl nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bayoll bne Jesúsenꞌ kaꞌ, bzorao llakyaꞌcheꞌ lo raꞌlldaꞌweꞌn, naꞌ golleꞌ leakeꞌ lixheje: —Diꞌll li, diꞌll li niaꞌ reꞌ: To reꞌ wdere nadaꞌ rao naꞌa beꞌnn kaꞌ llwie nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Naꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, kon llaswia rao lwellj akeꞌ, llon akeꞌ xhbab chaꞌ nore keꞌen bneꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Naꞌ to beꞌnnenꞌ lliꞌ kwiteꞌn, le nllieꞌ Jesúsenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Naꞌll ben Pedronꞌ sen rao beꞌnn naꞌ, nench bnnabreꞌ Leꞌe no keꞌen neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naꞌll jabiꞌyeꞌ awllo, lleꞌe Jesúsenꞌ: —¿Noxhanꞌ gon kaꞌ, Xanaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Naꞌll lleꞌe leꞌe: —Beꞌnnenꞌ waꞌa yet xtir naꞌ kat ba blabjaꞌn lo yel wao naꞌ, leꞌen gon kaꞌ. Naꞌll blabjeꞌ raꞌt yet xtirenꞌ lo yeꞌnnenꞌ, naꞌ le beꞌteꞌn Judas Iscariote, beꞌnnenꞌ nakeꞌ xhiꞌnn beꞌnnenꞌ re Simón. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Naꞌ ka bayoll beꞌe Judasenꞌ yet xtirenꞌ, le byazte daxiꞌon lo yichjraꞌlldaꞌo Judasenꞌ. Naꞌll lle Jesúsenꞌ leꞌe: —Danꞌ ba zo gonoꞌ naꞌ, le benten. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naꞌ ni to beꞌnn kaꞌ zjalliꞌreneꞌ txhen naꞌ, bi byejnieꞌ akreꞌ bixchen golleꞌ leꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Baleꞌ llak akreꞌ danꞌ noꞌx Judasenꞌ ganꞌ llaꞌa mell naꞌn, lleꞌe leꞌe kaꞌ, naꞌ lljaxieꞌ da yallj rao lnni naꞌn o chaꞌ weꞌe mell da yallje no beꞌnn yaꞌch akenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ka bayoll bdao Judasenꞌ yet xtir danꞌ beꞌe Jesúsenꞌ leꞌe, le bllojteꞌ. Naꞌ ba nak ba gol kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bayoll blloj Judasenꞌ, bne Jesúsenꞌ: —Nadaꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, naꞌ ba broeꞌrawaꞌ nakaꞌ beꞌnn zaꞌke, naꞌ leskaꞌ ba llroeꞌraꞌ nak Diosenꞌ beꞌnn zaꞌk kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Naꞌ danꞌ llroeꞌraꞌ nakeꞌ beꞌnn zaꞌk naꞌ, naꞌ lekze Leꞌen wroeꞌreꞌ nakaꞌ nadaꞌ beꞌnn zaꞌke, naꞌ le gonteꞌn nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xhiꞌnnaꞌ daꞌo ak, ye chollzenꞌ zorenaꞌ reꞌ. Naꞌ yeyirjre nadaꞌ, naꞌ niaꞌ reꞌ kanꞌ gollaꞌ beꞌnn Israel kaꞌ, bi gak yezaꞌrenre nadaꞌ ganꞌ yeyaꞌa naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","To da kobe lliaꞌ biaꞌa gonre, llieꞌ lwelljre. Kanꞌ ba bllieꞌraꞌ reꞌ, naꞌ kaꞌkze reꞌ llieꞌre lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Naꞌ chaꞌ soteze sore llieꞌ lwelljre, kone kaꞌ nneze beꞌnn ak, da likzenꞌ nxenraꞌllre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Naꞌ Simón Pedronꞌ bnnabreꞌ Leꞌe: —Xa, ¿gaxhanꞌ wayejoꞌ? Naꞌll lle Jesúsenꞌ leꞌe: —Ganꞌ yeyaꞌa naꞌ, bi gak yezaꞌrenoꞌ nadaꞌ nnaꞌ, zan tere wayedoꞌ yenaoꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naꞌll lle Pedronꞌ Leꞌe: —Xa, ¿bixchen bi gak yezaꞌrenaꞌ rweꞌ nnaꞌ? Wsanraꞌll kwinaꞌ kere bi gonen chaꞌ gataꞌ, ni koꞌo rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Naꞌll lle Jesúsenꞌ leꞌe: —¿Da bare lleꞌnroꞌ wsanraꞌll kwinoꞌ gatoꞌ ni kiaꞌ nadaꞌ? Diꞌll li, diꞌll li niaꞌ rweꞌ: Ka za kwellre lekwnꞌ ba gok chonn ras bi wcheboꞌ chaꞌ nombiaꞌo nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Leskaꞌ bne Jesúsenꞌ: —Bi gakllejlaꞌllre, legonliraꞌll Dios, naꞌ leskaꞌ legonliraꞌll nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Da zan yoꞌ llaꞌa ganꞌ zo Xaꞌ Diosenꞌ. Chenak bi naken kaꞌ, bi gollaꞌ reꞌ kaꞌ. Naꞌ nnaꞌ yeyaꞌa, naꞌ lljayenchaꞌwaꞌ yoꞌ ke keré. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Naꞌ kat yeyoll lljayenchaꞌwaꞌ yoꞌ keré kaꞌ, kanaꞌ yedaꞌ da yobre yechiaꞌ reꞌ, nench yedzore ganꞌ lljazoaꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ba nnézkzere ganꞌ yeyaꞌa naꞌ, naꞌ ba nombiaꞌre nezenꞌ nench yellinre naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Naꞌll lle Tomásenꞌ Leꞌe: —Xanaꞌ, bi nnézetoꞌ gaxhanꞌ wayejoꞌ. ¿Akxha gontoꞌ, naꞌ nnézetoꞌ, naꞌ yellintoꞌ to li? ");
INSERT INTO zpuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Naꞌll lle Jesúsenꞌ leꞌe: —Nadaꞌn nakaꞌ nezenꞌ, naꞌ nsaꞌa diꞌll li, naꞌ toz nadaꞌ llak lloaꞌ beꞌnne yel nban zejlikane. Ni to beꞌnne bi yellín ganꞌ zo Xaꞌn, chaꞌ bi gonliraꞌlleꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Chaꞌ nombiaꞌre nadaꞌ, renkze Xaꞌ naꞌn nombiaꞌrenre. Naꞌ nnaꞌ ba nombiaꞌreꞌ, naꞌ ba breꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Naꞌll lle Felipenꞌ Leꞌe: —Bennchek latje reꞌtoꞌ Xaꞌon, naꞌ kone len chejleꞌtoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesúsenꞌ lleꞌe leꞌe: —Felipe, da xhen naꞌ, ba bzorenaꞌ reꞌ. ¿Naꞌ bi nna gombiaꞌo nadaꞌ? Noteze beꞌnne ba breꞌe nadaꞌ, Xaꞌ naꞌkzenꞌ ba breꞌreꞌ. ¿Bixchen llnnabzeroꞌ nadaꞌ reꞌroꞌ Xaꞌ naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Bi llejleꞌo Xaꞌ naꞌkzenꞌ zerén nadaꞌ, naꞌ nadaꞌ zerenaꞌ Leꞌe? Diꞌll danꞌ lloeꞌrenaꞌ reꞌ, kere da lloaꞌa to wrazzaꞌn. Xaꞌ naꞌn zereneꞌ nadaꞌ, Leꞌen lloneꞌ nench lloaꞌa diꞌllenꞌ danꞌ lleꞌnreꞌ waꞌa naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lechejleꞌ kiaꞌ zerenaꞌ Xaꞌ naꞌ, naꞌ Leꞌen zereneꞌ nadaꞌ. Naꞌ chaꞌ bi llejleꞌre xtiꞌllaꞌ naꞌ, lechejleꞌ kiaꞌ danꞌ ba breꞌre yel wak kaꞌ ba benaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Diꞌll li, diꞌll li niaꞌ reꞌ: Beꞌnn kaꞌ llonliraꞌll nadaꞌ, da kaꞌ llonaꞌn wakte gon akeꞌn. Naꞌ da zaꞌkll gon akeꞌ, le wayaꞌa ganꞌ zo Xaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Naꞌ biteze da nnábere Xaꞌn, danꞌ llonliraꞌllre nadaꞌn nakaꞌ Xhiꞌnneꞌ, gonaꞌn, nench wroeꞌraꞌ nak Xaꞌn beꞌnn zaꞌk kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Naꞌ biteze da nnabre, danꞌ llonliraꞌllre nadaꞌn, nadaꞌ gonnaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Chaꞌ nllieꞌre nadaꞌ, legón kanꞌ nlliaꞌ biaꞌa naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Naꞌ nnabraꞌ Xaꞌn nench wseꞌleꞌ Spíritu keꞌen sorenen reꞌ ke chnare, naꞌ gakrenen reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Naꞌ Spíritu ke Dios naꞌ, wzejnieꞌn reꞌ da nak da li. Naꞌ beꞌnn bi llonliraꞌll ak Diosenꞌ, bi gak sorén Spíritu keꞌen leakeꞌ, le bi llreꞌe akreꞌn, naꞌ ni ke llejleꞌ akzeꞌ chaꞌ zon. Zan reꞌ nombiaꞌren, le zerenkzen reꞌ, naꞌ son lo yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Bi yekwaꞌnnaꞌ reꞌ ka xkwiꞌd wazebe. Wedkzaꞌ ye to ganꞌ zore ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ye chollze naꞌ bill reꞌe beꞌnn kaꞌ nadaꞌ, beꞌnn kaꞌ bi llonliraꞌll Dios, zan reꞌ wreꞌllkzere nadaꞌ, le nadaꞌ nbanaꞌ, kaꞌkze reꞌ banre ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naꞌ kat llin lla yedsó Spíritu ke Diosenꞌ lo yichjraꞌlldaꞌore, kanaꞌllenꞌ gakbeꞌre nadaꞌn zorenaꞌ Xaꞌn, naꞌ reꞌ zorenre nadaꞌ, naꞌ nadaꞌ zerenaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Beꞌnn nnez akreꞌ danꞌ nlliaꞌ biaꞌa gon akeꞌn, naꞌ llon akeꞌn, beꞌnn kaꞌn ba nllieꞌ akreꞌ nadaꞌ. Naꞌ beꞌnn kaꞌ nllieꞌ nadaꞌ, lekze kaꞌ llieꞌ Xaꞌn leakeꞌ, naꞌ nadaꞌ lekze llieꞌ akreꞌ, naꞌ gonaꞌ ka gombiaꞌ akllreꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Naꞌ Judas naꞌ (kere Judas Iscariote) lleꞌe Leꞌe: —Xantoꞌ, ¿bixchen wroeꞌraozoꞌ chraoze netoꞌ, naꞌ bi wroeꞌraoꞌ beꞌnn kaꞌ bi llonliraꞌll Dios naꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Naꞌ goll Jesúsenꞌ leꞌe: —Beꞌnn nllieꞌ akreꞌ nadaꞌ, llzenay akeꞌ xtiꞌllaꞌn, naꞌ Xaꞌn lekze llieꞌreꞌ leakeꞌ, naꞌ nadaꞌ ren Xaꞌ naꞌ, yedsorén aktoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Beꞌnn bi nllieꞌ nadaꞌ, bi llzoa akeꞌ xtiꞌllaꞌn. Naꞌ diꞌll danꞌ lloaꞌa naꞌ, kere kiaꞌ to wrazaꞌn, kon da ne Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ naꞌn ba bniaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Da ki ba bniaꞌ chak nna zorenaꞌ reꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Zan Xaꞌn wseꞌleꞌ Spíritu keꞌen son lo yichjraꞌlldaꞌore gonliraꞌllre nadaꞌ nench gakrenen reꞌ. Naꞌ Spíritunꞌ wzejnieꞌn yeolol da llayaꞌl nnézere, naꞌ lljasaꞌralleꞌn reꞌ yeolol da kaꞌ ba bniaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yel nbaraz kiaꞌn llkwaꞌnnaꞌn, yel nbaraz kiaꞌn gonnaꞌ reꞌ. Bi llonnaꞌn kanꞌ llonn beꞌnn kaꞌ llaꞌa yellrio ni len. Bit gakgane raꞌlldaꞌore, naꞌ bi llebre. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ba bénere bniaꞌ yeyaꞌa ganꞌ zo Xaꞌ naꞌ, naꞌ wadzorenkzaꞌ reꞌ da yobre. Naꞌ chaꞌ do raꞌllre nllieꞌre nadaꞌ, naꞌ yewere danꞌ yeyaꞌa ganꞌ zo Xaꞌn, le Xaꞌ naꞌ zaꞌklleꞌ ka nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Naꞌ ba beꞌrenaꞌ reꞌ diꞌll kaꞌ, chaga bi nna gaken nench naꞌ, katenꞌ gaken naꞌ, gonliraꞌllre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Bill weꞌrenaꞌ reꞌ diꞌll zan, le ba zaꞌa daxiꞌon danꞌ llnebiaꞌ beꞌnn kaꞌ bi llonliraꞌll nadaꞌ, zan bibi de gon ren nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Llonaꞌ kon kanꞌ nllia Xaꞌn biaꞌa, nench nneze beꞌnnachenꞌ nllieꞌraꞌ Xaꞌn. Leyezollaꞌa, leyeyoꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Nadaꞌ llonen kiaꞌ ka ke to yay da llbia uvas, naꞌ Xaꞌ naꞌ, nakeꞌ ka to beꞌnn llonchiꞌi len. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naꞌ reꞌ llonliraꞌllre nadaꞌ, nakre ka to xhoꞌz yay naꞌ. Naꞌ xhoꞌze kaꞌ danꞌ bibi llbianꞌ, wchoyeꞌn. Naꞌ xhoꞌze danꞌ llbia uvas naꞌ, llonchieꞌn nench llbiallen ye raꞌt da zanlle. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Naꞌ reꞌ ba nakre ka to xhoꞌze danꞌ ba nonchieꞌ, le ba llzenayre xtiꞌllaꞌ danꞌ ba beꞌrenaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lesechichrén nadaꞌ nench kaꞌ sechichrenaꞌ reꞌ. Kanꞌ nak xhoꞌz yayenꞌ, bibi llbian to wraze chaꞌ bi nkaꞌn leꞌ yayenꞌ, kaꞌn naken ke reꞌ, bi gakre gonre kanꞌ lleꞌne Diosenꞌ, chaꞌ bi serenre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nadaꞌ zaꞌkrebraꞌ ka to yay da llbia uvas, naꞌ reꞌ nakre ka xhoꞌze. Notezre chaꞌ sechichrenre nadaꞌ, lekze kaꞌ sechichrenaꞌ reꞌ, naꞌ gakre kanꞌ llazraꞌll Diosenꞌ, kaꞌkzenꞌ naken ke yay uvas danꞌ llbiachachen, le bibi gak gonre to wrazzre. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Beꞌnn bi sechichreneꞌ nadaꞌ, naꞌ gak keꞌe kanꞌ llak ke xhoꞌz yay danꞌ bi llbia, llchoyeꞌn naꞌ llyechen, naꞌ ll-llin lla llatopeꞌn, naꞌ llaꞌden yiꞌ nench lleyen. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Naꞌ reꞌ chaꞌ sechichrenre nadaꞌ, naꞌ zechichre wzenayre xtiꞌllaꞌn, biteze da lleꞌnere nnábere Diosenꞌ, gonnkzeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Llaziꞌi Xaꞌn baraꞌnn xhen kate zore llonre kanꞌ llazraꞌlleꞌn, naꞌ chaꞌ llonre kaꞌ, naꞌ gakbeꞌe beꞌnne da likzenꞌ llonliraꞌllre nadaꞌ, naꞌ llzenayre kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kanꞌ llon Xaꞌn nllieꞌreꞌ nadaꞌ, leskaꞌ nadaꞌ ba nllieꞌraꞌ reꞌ. Lesó legón kanꞌ niaꞌ naꞌ, nench gakbeꞌre nllieꞌraꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chaꞌ gonre kanꞌ nlliaꞌ biaꞌa gonre, naꞌllenꞌ gakbeꞌre nllieꞌraꞌ reꞌ, le nadaꞌ llonaꞌ danꞌ nllia Xaꞌn biaꞌa gonaꞌ, naꞌ llakbeꞌraꞌ nllieꞌreꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Kaꞌn ba bniaꞌ reꞌ, nench sore nbaraz ka nbarazenꞌ zoaꞌ nadaꞌ. Zeraꞌllaꞌ sore nbaraz kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Naꞌ da ni nlliaꞌ biaꞌa gonrenꞌ, llieꞌ lwelljre kanꞌ nllieꞌraꞌ nadaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nono zo beꞌnne nllieꞌllre lwelljeꞌ goneꞌ ka da ni, wsanraꞌll kwineꞌ gateꞌ, ni ke beꞌnn lwelljeꞌ kaꞌ nllieꞌreꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Naꞌ reꞌ nakre beꞌnn nllieꞌraꞌ chaꞌ llonre kanꞌ nlliaꞌ biaꞌa naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Naꞌ bill niaꞌ nakre beꞌnn wen llin kiaꞌ, le to beꞌnn wen llin, bi nnezreꞌ yeolol danꞌ llon xaneꞌn, zan niaꞌ nakre beꞌnn nllieꞌraꞌ, le yeolol danꞌ ba benraꞌ bne Xaꞌn, ba bzejnieꞌraꞌn reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kere reꞌn brejre nadaꞌ, nadaꞌn brejaꞌ reꞌ, naꞌ nakaꞌ xanrenꞌ. Naꞌ llseꞌlaꞌ reꞌ nench lljenre kanꞌ llazraꞌll Xaꞌ naꞌ, naꞌ kere da te ke da kaꞌ gonrenꞌ. Naꞌ yeolol da wnnábere Xaꞌn, gonkzeꞌn danꞌ llonliraꞌllre nadaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Naꞌ da ni nlliaꞌ biaꞌa gonre, llieꞌ lwelljre. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Chaꞌ beꞌnn bi llonliraꞌlle Diosenꞌ, llwie akreꞌ reꞌ, lenneze zgaꞌtek nadaꞌn bwie akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chenak reꞌ llonre txhen beꞌnn kaꞌ bi llonliraꞌll Diosenꞌ, naꞌllenꞌ llieꞌ akreꞌ reꞌ, kanꞌ nllieꞌ lwellj akeꞌ chenake. Zan ba brejaꞌ reꞌ nench llzenayre kiaꞌ, naꞌllenꞌ llwie akreꞌ reꞌ, danꞌ bi llonrén akreꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lelljasaꞌraꞌll kanꞌ bniaꞌ reꞌn: “Noteze beꞌnn nak ka to beꞌnn wen llin, bi nakeꞌ beꞌnn llonlle ka xaneꞌn.” Chet kaꞌ nadaꞌ ba bsaꞌkziꞌ beꞌnn, leskaꞌ gon akreꞌ reꞌ. Naꞌ chaꞌ ba bzenay akeꞌ xtiꞌllaꞌn, leskaꞌ wzenay akeꞌ xtiꞌll reꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Naꞌ danꞌ bi nombiaꞌ akeꞌ Dios beꞌnnenꞌ bseꞌl nadaꞌn, len naꞌ llon akreꞌ reꞌ kaꞌ, le llwie akreꞌ reꞌ, danꞌ llzenayre kiaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Chenak nadaꞌ bi bedaꞌ yedzejnieꞌ akreꞌ, bibi doꞌl nap akeꞌ chenake. Zan nnaꞌ bibi de wde akreꞌ, ne akeꞌ bibi doꞌl nap akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Beꞌnn llwiere nadaꞌ renkze Xaꞌ naꞌn llwiereꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ba benaꞌ yel wak da nono nna gon, naꞌ chenak bi breꞌe akreꞌn, bibi doꞌl nap akeꞌ. Zan ka naken ba breꞌe akreꞌ da ki, llia biaꞌkze llwie akreꞌ nadaꞌ ren Xaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Naꞌ llak kanꞌ nyoj xtiꞌll Diosenꞌ danꞌ llsed akeꞌ ganꞌ nen: “Bwie akreꞌ nadaꞌ, laꞌkze bibi da xhinnj benaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Naꞌ katenꞌ yed Spíritu danꞌ wayonxhenraꞌll reꞌ, danꞌ zaꞌa ganꞌ zo Xaꞌ naꞌ, Spíritu danꞌ lloeꞌ diꞌll li, len weꞌe diꞌll li akre nak kiaꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Leskaꞌ reꞌ llayaꞌle weꞌre xtiꞌllaꞌn, le ba bzerenre nadaꞌ chak ba bdixjweꞌraꞌ xtiꞌll Xaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ba bniaꞌ reꞌ yeolol da ki nench bi gakllejlaꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Le wabej akeꞌ reꞌ lo yodaꞌo ke akeꞌ kaꞌ, naꞌ wllin lla kat noteze beꞌnn got akeꞌ reꞌ, gak akreꞌ llawé Dios kanꞌ llon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gon akreꞌ reꞌ yeolol da kaꞌ, le bi nombiaꞌ akeꞌ Xaꞌn, ni nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Niaꞌ reꞌ da ki nench kat llin lla gak kanꞌ bniaꞌn, lljadinraꞌllre. ’Bi bniaꞌ reꞌ yeolol da kaꞌ gak kerénꞌ, ka llanꞌ bzorawaꞌ bzejnieꞌraꞌ reꞌ xtiꞌll Diosenꞌ, le nna zokzaꞌ llakrenaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Naꞌ nnaꞌ wayaꞌa ganꞌ zo Xaꞌ beꞌnnenꞌ bseꞌl nadaꞌ naꞌ, ¿naꞌ ni tore bi llnnábere nadaꞌ gaxhanꞌ wayaꞌa? ");
INSERT INTO zpuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Naꞌ danꞌ bniaꞌ kaꞌ ba llakyaꞌchere. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Diꞌll linꞌ ba bniaꞌ, llonen bien wayaꞌa, le chaꞌ bi wayaꞌa, bi yedsó Spíritu ke Xaꞌ Diosenꞌ lo yichjraꞌlldaꞌorenꞌ gakrenen reꞌ. Wayaꞌa naꞌllenꞌ wseꞌlaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Naꞌ kat yed Spíritunꞌ, wzejnieꞌn beꞌnnach nap akeꞌ doꞌle, naꞌ wzejnieꞌn nonꞌ nak beꞌnn wen rao Dios, naꞌ wzejnieꞌn gaꞌt yel llzaꞌkziꞌ ke chnare ke beꞌnn bi wzenay kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Spíritunꞌ wzejnieꞌn leakeꞌ, nap akeꞌ doꞌl danꞌ bi llonliraꞌll akeꞌ nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Naꞌ wzejnieꞌn leakeꞌ nonꞌ nak beꞌnn wen rao Dios, le wayaꞌa ganꞌ zo Xaꞌ Diosenꞌ, naꞌ reꞌ bill reꞌre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Naꞌ wzejnieꞌn leakeꞌ, gaꞌt yel llzaꞌkziꞌ ke doꞌl ke akeꞌn ke chnare, le daxiꞌon danꞌ llnebiaꞌ rao yellrio ni, ba nlloybiaꞌn saꞌkziꞌn ke chnare. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nnaꞌ dell da zan da nniaꞌ reꞌ, zan naken bniꞌ chejnieꞌren nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Naꞌ kat yedsó Spíritu ke Diosenꞌ danꞌ lloeꞌ diꞌll linꞌ, len koꞌ reꞌ nez rao yeololte da nak da li, le kere weꞌn diꞌll to wrazzen, kon weꞌn diꞌll da llzene Xaꞌ naꞌ len naꞌ, naꞌ chixjweꞌn reꞌ bi da kaꞌ za gak. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Spíritunꞌ gonen nench wroeꞌrawe, nakaꞌ beꞌnn zaꞌke kwis, le yeolol kanꞌ nakaꞌ nadaꞌ wroeꞌn reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yeololte bi da de ke Xaꞌn naken kiaꞌ, ke len naꞌ gollaꞌ reꞌ, Spíritunꞌ wroeꞌn reꞌ yel nbaraz kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ye chollze naꞌ, bi reꞌre nadaꞌ, naꞌll te naꞌ, yereꞌre nadaꞌ da yobre, le wayaꞌa ganꞌ zo Xaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Naꞌ bal beꞌnn kaꞌ non Jesúsenꞌ txhen, lle lwellj akeꞌ: —¿Akre zejen danꞌ llezeꞌ lliꞌo, ye chollze naꞌ, bill reꞌlloeꞌ, naꞌ te naꞌ, yereꞌlloeꞌ da yobre? Naꞌ ¿akre zejen danꞌ neꞌe, wayejeꞌ ganꞌ zo Xeꞌen? ");
INSERT INTO zpuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Bi zejen danꞌ neꞌe ye chollzenꞌ? Bi llejnieꞌllo danꞌ neꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesúsenꞌ gokbeꞌreꞌ lleꞌne beꞌnn kaꞌ nnab akreꞌ Leꞌe, akre zejen ka diꞌll kaꞌ, naꞌll golleꞌ leakeꞌn: —¿Ba llnnabe lwelljre danꞌ bniaꞌn: “Ye chollze naꞌ bill reꞌre nadaꞌ, naꞌ te naꞌ, yereꞌre nadaꞌ da yobre”? ");
INSERT INTO zpuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Diꞌll li, diꞌll li niaꞌ reꞌ: Kwellre naꞌ gákere, chak yewé beꞌnn kaꞌ bi llonliraꞌll Diosenꞌ. Gakyaꞌchere, zan chollze gakyaꞌchere, te naꞌ naꞌll yewere. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ka ke to noꞌre zan, ll-llayraweꞌ chak llake bes yel zan naꞌ. Naꞌ kat ba gorj bdaꞌo keꞌe naꞌ, bill lloneꞌ xhbab danꞌ bllayraweꞌn, ba llawereꞌ ba gorj ye to beꞌnnach yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kaꞌkzenꞌ ke reꞌ, ba llakyaꞌchere nnaꞌ, zan kat yellayllo da yobre sore nbarazlle, naꞌ nono gak yekaꞌa yel llawé ke lo yichjraꞌlldaꞌorenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Naꞌ kate ba bllin lla lljazoaꞌ da yobre ganꞌ zo Xaꞌn, kanaꞌ billbi nnábere wzejnieꞌraꞌ reꞌ. Diꞌll li, diꞌll li niaꞌ reꞌ: Danꞌ llonliraꞌllre nadaꞌn, biteze da nnábere Xaꞌn, gonnkzeꞌn reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Xte nnaꞌ bibi nna nnábere Xaꞌn, ni ke danꞌ llonliraꞌllre nadaꞌn. Naꞌ nnaꞌ lennabe Xaꞌn, naꞌ gonneꞌn nench sore nbaraz kwis. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Da zan ba bniaꞌ reꞌ kanꞌ bsaꞌkrebraꞌ bi da kaꞌ. Wllin lla kate bill wzejnieꞌraꞌ reꞌ, wsaꞌkrebraꞌ bi da kaꞌ llzejnieꞌraꞌ reꞌn. Naꞌ waꞌa diꞌll da chejnieꞌre kat wzejnieꞌraꞌ reꞌ ke Xaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Naꞌ kat llin lla naꞌ, kanaꞌ nnábere Xaꞌn bi da nnábere, ni ke danꞌ llonliraꞌllre nadaꞌ. Bi yalljen nnabraꞌ Xaꞌn gakreneꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Le kwinkze Xaꞌ naꞌn nllieꞌreꞌ reꞌ, danꞌ nllieꞌre nadaꞌn, naꞌ chejleꞌre Leꞌen bseꞌl nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ganꞌ zo Xaꞌ Dios naꞌn, bzaꞌa bedaꞌ yellrio ni, naꞌ nnaꞌ yezaꞌa yellrio ni. Naꞌ wayaꞌa ganꞌ zo Xaꞌn da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Naꞌll goll akeꞌ Leꞌe: —Ba lloeꞌo diꞌll da ba llejnieꞌtoꞌ, naꞌ bill llsaꞌkrebroꞌ bi da kaꞌ llzejnieꞌroꞌ netoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naꞌ ba gokbeꞌtoꞌ nombiaꞌo yeolol xhbab ke beꞌnnach. Ba nnezroꞌ binꞌ lleꞌne beꞌnne nnezreꞌ kat za nnabtereꞌn. Ke len naꞌ ba llejleꞌtoꞌ zaꞌo ganꞌ zo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Naꞌll lle Jesúsenꞌ leakeꞌ: —¿Ba llejleꞌre nnaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ba bllin lla nnaꞌ, naꞌ ba goꞌl gaslasre. Totore wkaꞌa xhnnez ke keré, naꞌ wkwaꞌnnre tozaꞌ. Zan bi zoaꞌ tozaꞌ, Xaꞌ naꞌn zorenkzeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ba bniaꞌ reꞌ kaꞌ, nench naꞌ nniꞌtre nbaraz, legonliraꞌll nadaꞌ. Yellrio ni saꞌkziꞌre, bi gakllejlaꞌllre, nadaꞌ ba benaꞌ yenit yel llnebiaꞌ ke daxiꞌon, danꞌ zo llnebiaꞌn yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bayoll bne Jesúsenꞌ da ki, naꞌll bwieꞌ yebáre bneꞌe: —Xa, ba bllin lla gak kiaꞌ, danꞌ ba blliaꞌo biaꞌa gak kiaꞌn. Ben nench nakbieꞌ nadaꞌn, nakaꞌ xhiꞌnnoꞌ, nakaꞌ beꞌnn zaꞌk xhen, nench gonaꞌ reꞌe akreꞌ, nakoꞌ beꞌnn zaꞌk xhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ba bennoꞌ nadaꞌ yel llnebiaꞌ rao beꞌnnach, nench lloaꞌa yel nban zejlikane ke yeolol beꞌnn kaꞌ ba brejoꞌ llonliraꞌll nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Da ni naken yel nban zejlikane: gombiaꞌ akreꞌ rweꞌ, le tozoꞌ rweꞌn nakoꞌ Dios li, naꞌ leskaꞌ gombiaꞌ akreꞌ nadaꞌn, Jesucristo, beꞌnnenꞌ bseꞌloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Rao yellrio ni, ba benaꞌ nench nakbieꞌ nakoꞌ beꞌnn zaꞌk, naꞌ ba bayoll benaꞌ yeolol da broꞌ rao naꞌ gonaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naꞌ nnaꞌ Xa, ben nench naꞌ wroeꞌn nakaꞌ beꞌnn zaꞌk, kat yeyedaꞌ gan zoꞌo naꞌ, doxhen kanꞌ broeꞌn kanꞌ bzoaꞌ ganꞌ lliaꞌo naꞌ, kanꞌ za xete yellrio. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Beꞌnn kaꞌ ba brejoꞌ rao yellrionꞌ, nench naꞌ benoꞌ leakeꞌ rallnaꞌ, ba broeꞌraꞌ leakeꞌ noxhanꞌ nakoꞌ. Beꞌnn koꞌon nak akeꞌ, naꞌ ba benoꞌ leakeꞌ rallnaꞌ, naꞌ ba bzenay akeꞌ xtiꞌlloꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naꞌ ba nnez akreꞌ yeolol danꞌ llonaꞌ, naꞌ yeolol diꞌll danꞌ lloaꞌan, naken koꞌo rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Le ba beꞌrén akeꞌ diꞌll danꞌ ba bzejnieꞌroꞌ nadaꞌ, naꞌ ba bzenay akeꞌn, naꞌ ba llakbeꞌe akreꞌ, da likzenꞌ bzaꞌa ganꞌ zoꞌo naꞌ, naꞌ llejleꞌ akeꞌ rweꞌkzoꞌn bseꞌloꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Naꞌ llnnabaꞌ gakrén akoeꞌ. Bi llnnabaꞌ gakrenoꞌ yeolol beꞌnnach, kon beꞌnn kaꞌ ba brejoꞌ naꞌn, gakrenoꞌ le ba llonliraꞌll akeꞌ nadaꞌ, naꞌ ba nak akeꞌ rallnaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Naꞌ yeolol beꞌnn llonliraꞌlle nadaꞌ, leskaꞌ llonliraꞌll akeꞌ rweꞌ. Naꞌ kaꞌ noteze beꞌnne nak rallnaꞌo, leskaꞌkze nak akeꞌ rallnaꞌ nadaꞌ, naꞌ beꞌnn kaꞌ llonliraꞌll nadaꞌn, llroeꞌ akreꞌ nakaꞌ beꞌnn zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Naꞌ nnaꞌ bill soaꞌ yellrio ni, zan beꞌnn ki llonliraꞌll nadaꞌn, nna zjaniꞌt akseꞌ rao yellrio ni, naꞌ nadaꞌ ba zazaꞌa ganꞌ zoꞌo naꞌ. Xa, nakoꞌ le zeraoze beꞌnn raꞌlldaꞌo yalle, naꞌ llnnabaꞌ gakrén akoeꞌ, wkwasoꞌ da xhinnjenꞌ kaꞌle, nench nniꞌt akeꞌ gak akeꞌ toze ren no lwellj akeꞌ, kanꞌ nak lliꞌo toze. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Chak bzorén akeꞌ, benrenaꞌ yel llnebiaꞌ koꞌon llin, nench bkwasaꞌ da xhinnjenꞌ kaꞌle. Ke len naꞌ, ni toeꞌ bi blleyiꞌ, kon toze beꞌnne ba naken kweyiꞌ, nench gak doxhen kanꞌ ne xtiꞌlloꞌ danꞌ nyoj naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Naꞌ nnaꞌ ba zazaꞌa ganꞌ zoꞌo naꞌ, naꞌ chak nna zoaꞌ yellrio ni, lloaꞌa diꞌll ki nench nniꞌt beꞌnn ki nbaraz, ka nbarazenꞌ zoaꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nadaꞌ ba beꞌrén akeꞌ xtiꞌlloꞌn. Naꞌ beꞌnn kaꞌ bi llonliraꞌll rweꞌn, llwie akreꞌ beꞌnn kaꞌ llonliraꞌll nadaꞌn, danꞌ bi llonrén akeꞌ leakeꞌ txhen, kaꞌn ben akzreꞌ nadaꞌ, le bi benrenaꞌ leakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Naꞌ ka nak beꞌnn kaꞌ llonliraꞌll nadaꞌn, bi llnnabaꞌ yekaꞌa akoeꞌ rao yellrio ni, llnnabaꞌ gakrén akoeꞌ naꞌ wkweꞌjoꞌ leakeꞌ rao biteze da xhinnj da de rao yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Leakeꞌ bi nak akeꞌ txhen beꞌnn kaꞌ llon da xhinnj, danꞌ de rao yellrio ni, ka nadaꞌ bi llonaꞌ txhen da xhinnjenꞌ, da de rao yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ben nench yichjraꞌlldaꞌo beꞌnn kaꞌ llonliraꞌll nadaꞌ, gaken yall kone diꞌll li koꞌo naꞌ. Le diꞌll koꞌon naken da li. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Rweꞌn bseꞌloꞌ nadaꞌ yellrio ni, nench baddiaꞌ xtiꞌlloꞌn, leskaꞌ nadaꞌ llseꞌlaꞌ leakeꞌ, weꞌe akeꞌ xtiꞌllaꞌn rao yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Non kwinaꞌ rallnaꞌo, nench naꞌ leakeꞌ gak akeꞌ yall kone diꞌll li koꞌo naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Naꞌ bi llnnabaꞌ gakrenoꞌ to leakzeꞌ, leskaꞌkze gakrenoꞌ beꞌnn kaꞌ za gonliraꞌll nadaꞌ, kat yen akreꞌ diꞌll danꞌ lloeꞌ beꞌnn ki. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xa, ben nench yeololeꞌ gak akeꞌ toze ren lwellj akeꞌ, naꞌ gak akeꞌ lliꞌo txhen, ka rweꞌ nakoꞌ toze ren nadaꞌ, naꞌ nadaꞌ nakaꞌ rweꞌ toze. Ben nench yeyoll gak akeꞌ lliꞌo toze, nench gakbeꞌe beꞌnn kaꞌ bi llonliraꞌll rweꞌn, rweꞌkzoꞌn bseꞌloꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Naꞌ yel baraꞌnn danꞌ bennoꞌ nadaꞌ, ba beꞌe akeꞌn nench nak akeꞌ toze ren beꞌnn lwellj akeꞌ, kanꞌ nak lliꞌo toze. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Leakeꞌn nak akeꞌ nadaꞌ txhen, naꞌ nadaꞌ nakaꞌ rweꞌ txhen, nench yeolol-llo gakllo toze. Gakllo toze nench gakbeꞌe beꞌnn kaꞌ bi llonliraꞌll rweꞌn, rweꞌkzoꞌn bseꞌloꞌ nadaꞌ, naꞌ gakbeꞌe akreꞌ nllieꞌkzroꞌ beꞌnn kaꞌ, kanꞌ nllieꞌroꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xa, nllieꞌroꞌ nadaꞌ ka bi nna xe yellrio naꞌte, naꞌ nonoꞌ nadaꞌ beꞌnn zaꞌke. Naꞌ lleꞌnraꞌ beꞌnn ki brejoꞌ, llonliraꞌll akeꞌ nadaꞌ, yedzorén akeꞌ nadaꞌ ganꞌ yedzoaꞌn, nench reꞌe akreꞌ nakaꞌ beꞌnn zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xa, nakoꞌ beꞌnn llon da zej to lilla. Naꞌ ka nak beꞌnn kaꞌ bi llonliraꞌll nadaꞌn, leskaꞌ bi nombiaꞌ akeꞌ rweꞌ, zan nadaꞌ nombiaꞌ rweꞌ, naꞌ beꞌnn kaꞌ ba brejoꞌ gonliraꞌll akeꞌ nadaꞌ, nnez akreꞌ rweꞌn bseꞌloꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Naꞌ ba bzejnieꞌ akreꞌ kanꞌ nakoꞌn, naꞌ kanꞌ llonoꞌ, naꞌ za wzejnieꞌ akllereꞌ, nench gakbeꞌe akreꞌ nllieꞌ akroeꞌ kanꞌ nllieꞌroꞌ nadaꞌ, naꞌ sorenaꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bayoll beꞌrén Jesúsenꞌ beꞌnn keꞌe kaꞌ non Leꞌe txhen naꞌ diꞌll, naꞌ bzaꞌreneꞌ leakeꞌ, naꞌ jakeꞌ chlaꞌ yeo ganꞌ nziꞌi Cedrón, ganꞌ de to reꞌj ga naz akeꞌ zan yay danꞌ nziꞌi olivos. Naꞌ bllaꞌa akeꞌ lo reꞌjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Naꞌ Judas beꞌnnenꞌ ba naken goneꞌ Jesúsenꞌ rallnaꞌa beꞌnn kaꞌ llwie Leꞌen, leskaꞌ nombieꞌ latjenꞌ, le da zan ras ba badop beꞌnn kaꞌ non Jesúsenꞌ txhen gannaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ka goken bllin Judasenꞌ, naꞌ ncheꞌe zan wakaꞌa ya kaꞌ, naꞌ ye txhonnj beꞌnn kaꞌ llap yodaꞌo braonꞌ, beꞌnn bseꞌl bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn fariseo kaꞌ, nench goꞌx akeꞌ Jesúsenꞌ. Zjanoꞌx akeꞌ no da llseniꞌ, naꞌ zjanoꞌx akeꞌ no yiꞌ yell yay, naꞌ zjanaꞌl akeꞌ spad. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Naꞌ Jesúsenꞌ ba nnezreꞌ yeolol ka da kaꞌ gak keꞌen, naꞌll bllojeꞌ jatileꞌ leakeꞌ, naꞌll golleꞌ leakeꞌ: —¿No llayirjre? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Naꞌll lle akeꞌ Leꞌe: —Jesús beꞌnn Nazaret. Naꞌll goll Jesúsenꞌ leakeꞌ: —Nadaꞌn. Naꞌ Judas beꞌnnenꞌ wde Leꞌe rao naꞌa beꞌnn kaꞌ, llwie Leꞌen, zereneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kate goll Jesúsenꞌ leakeꞌ: “Nadaꞌn”, le babiꞌ akteꞌ skoꞌllre, byal akeꞌ rao yonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Naꞌll da yobre goll Jesúsenꞌ leakeꞌ: —¿Nonꞌ llayirjre? Naꞌll bne akeꞌ: —Jesús beꞌnn Nazaretenꞌ llayirjtoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Naꞌ bne Jesúsenꞌ: —Ba bnetiaꞌ. Chaꞌ nadaꞌn llayirjre, leweꞌe latje wayej beꞌnn ki. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kaꞌ bneꞌe nench gok kanꞌ ba bdixjweꞌreꞌ, kanꞌ bneꞌe: “Ni to beꞌnn kaꞌ ba brej Diosenꞌ gonliraꞌlle nadaꞌ, bi kweyiꞌ akeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Naꞌ Simón Pedronꞌ naꞌle to spad, naꞌ le blechjteꞌn bdineꞌn beꞌnn wen llin ke bxoz braonꞌ, bchoyteꞌ nayeꞌ chaꞌwenꞌ. Naꞌ beꞌnnenꞌ benreꞌ kaꞌ, reꞌe Malco. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Naꞌll lle Jesúsenꞌ Pedronꞌ: —Bagoꞌ spad koꞌon lo rille. ¿Llakroꞌ bi llayaꞌl gak danꞌ ba nllia Xaꞌ Diosenꞌ biaꞌa gak kiaꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Naꞌ wakaꞌa ya kaꞌ ren xan akeꞌn, naꞌ beꞌnn kaꞌ llape yodaꞌo brao ke beꞌnn Israel kaꞌ, beꞌx akeꞌ Jesúsenꞌ, naꞌ bchej akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Naꞌ bcheꞌe akeꞌ Leꞌe da nell rao beꞌnnenꞌ nziꞌi Anás, xa noꞌr ke beꞌnnenꞌ nziꞌi Caifás. Naꞌ Caifás naꞌ gokeꞌ bxoz brao ke beꞌnn Israel kaꞌ, ka iz naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Naꞌ Caifás naꞌn golleꞌ beꞌnn wnebiaꞌ kaꞌ, naksen wen ke akeꞌ, toze beꞌnne gat ker ke da kweyiꞌ yeololeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedronꞌ ren ye to beꞌnn non Jesúsenꞌ txhen, bnao akeꞌ Leꞌe. Naꞌ bxoz braonꞌ nombieꞌ beꞌnnenꞌ ye to, naꞌllenꞌ gok byoꞌreneꞌ Jesúsenꞌ liaꞌ ke bxoz braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Naꞌ Pedronꞌ bagaꞌnneꞌ lloaꞌ yoꞌze. Naꞌ beꞌnnenꞌ ye to, danꞌ nombieꞌ bxoz wnebiaꞌ naꞌn, beꞌreneꞌ noꞌrenꞌ diꞌlle, beꞌnnenꞌ lliꞌ llapeꞌ lloaꞌ yoꞌ naꞌ, nench broeꞌ Pedronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Naꞌ noꞌrenꞌ llap lloaꞌ yoꞌ naꞌ, golleꞌ Pedronꞌ: —¿Kere renoꞌ rweꞌn llzenayoꞌ danꞌ llroeꞌ llsed beꞌnn ni? Naꞌll bne Pedronꞌ: —Kaꞌa, bi renaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Naꞌ llak zay, naꞌ nbek beꞌnn wen llin kaꞌ to yiꞌ barje, naꞌ zjazellá akeꞌ lloaꞌ yiꞌn, llachaꞌa kwin akeꞌ. Naꞌ Pedronꞌ le jaserenteꞌ leakeꞌ lloaꞌ yiꞌn, llachaꞌa kwineꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Naꞌ beꞌnnenꞌ nak bxoz braonꞌ, bnnabreꞌ Jesúsenꞌ nonꞌ llzenay danꞌ llroeꞌ llsedreꞌn, naꞌ danꞌ llzejnieꞌreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Naꞌ lle Jesúsenꞌ leakeꞌ: —Ba biaꞌa diꞌll doxhente, naꞌ da zan ras broeꞌ bsedraꞌ lo yodaꞌo kellonꞌ, naꞌ liaꞌ yodaꞌo brao, ganꞌ ll-llay yeolol beꞌnn wrall kello kaꞌ. Naꞌ bi biaꞌan ga ngaꞌch. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bixchen llnnabzroꞌ nadaꞌ? Bnnabe beꞌnn kaꞌ badzenay danꞌ broeꞌ bsedraꞌ naꞌ. Leakeꞌn nneze bi diꞌllenꞌ biaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bayoll bne Jesúsenꞌ kaꞌ, naꞌ to beꞌnnenꞌ llape yodaꞌo brao naꞌ, zereneꞌ gannaꞌ, le broꞌteꞌ to ke xaꞌyeꞌ, lleꞌe Leꞌe: —¿Kaꞌ llayaꞌl yelliꞌo diꞌll ke beꞌnnenꞌ nak bxoz braonꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Naꞌll goll Jesúsenꞌ leꞌe: —Chaꞌ bi da xhinnj ba bniaꞌ, bne chet kaꞌ, naꞌ chaꞌ bniaꞌ da wen, ¿bixchen llgapoꞌ nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Naꞌ Anásenꞌ bdieꞌ Jesúsenꞌ nllejtezeꞌ taꞌkeꞌ rao Caifásenꞌ, beꞌnnenꞌ nakeꞌ bxoz braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Naꞌ lliꞌ Pedronꞌ lloaꞌ yiꞌn nench llalleꞌreꞌ, naꞌll lle beꞌnn kaꞌ zjallaꞌa naꞌ leꞌe: —¿Kere renkzoꞌ rweꞌn nakoꞌ beꞌnn ke beꞌnn ni? Naꞌ bi bchebeꞌ, bneꞌe: —Kaꞌa, bi renaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Naꞌ to beꞌnn wen llin ke bxoz braonꞌ, nakeꞌ biꞌch lwellj beꞌnnenꞌ bchoy Pedronꞌ nay naꞌ, naꞌ golleꞌ leꞌe: —¿Kere rweꞌn breꞌraꞌ renoꞌ Jesúsenꞌ lo reꞌj, ganꞌ llaꞌa yay olivos kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Naꞌll Pedronꞌ da yobre kere bchebeꞌ, naꞌ le bllellte lekwnꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ka ba lleniꞌ naꞌ, brej akeꞌ Jesúsenꞌ ganꞌ zo Caifásenꞌ, naꞌ bcheꞌe akeꞌ Leꞌe rao beꞌnnenꞌ llon yel koxchisenꞌ. Naꞌ bi byoꞌrén beꞌnn kaꞌ ll-lliayiꞌll Jesúsenꞌ, ganꞌ zo beꞌnnenꞌ llon yel koxchisenꞌ, le kanꞌ nak danꞌ nao beꞌnn Israel kaꞌ, bi gak gao akeꞌ katenꞌ gaꞌl lnni paskwnꞌ, chaꞌ choꞌ akeꞌ ganꞌ zjallaꞌa beꞌnn bi nake beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Naꞌllenꞌ blloj Pilatonꞌ lleꞌe leakeꞌ: —¿Bixha ben beꞌnn ninꞌ? ¿Bi ken llaore xhia keꞌe? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Naꞌll bne beꞌnn wnebiaꞌ kaꞌ: —Chenak beꞌnn ni bi nakeꞌ beꞌnn wen da xhinnj, bi yedwaꞌtoeꞌ rao naꞌo chenake. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Naꞌll lle Pilatonꞌ leakeꞌ: —Leyecheꞌe chaꞌ, naꞌ legón yel koxchis keꞌen kanꞌ ne ley keré naꞌ. Naꞌll ne beꞌnn wnebiaꞌ ke Israel kaꞌ: —Bi de latj gottoꞌ no beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Naꞌ bzoa diꞌll kanꞌ bne Jesúsenꞌ kanꞌ bzejnieꞌreꞌ, akre gon akeꞌ got akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Naꞌll bayoꞌ Pilatonꞌ lo yoꞌn da yobre, naꞌll goxheꞌ Jesúsenꞌ, lleꞌe Leꞌen: —¿Rweꞌn nakoꞌ Rey ke beꞌnn Israel kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Naꞌll lle Jesúsenꞌ leꞌe: —¿Da gorjlaꞌllzoꞌn llnnaboꞌ, chaꞌ nollrenꞌ goll rweꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Naꞌll lle Pilatonꞌ Leꞌe: —¿Llakroꞌ chaꞌ beꞌnn Israel nadaꞌn? Beꞌnn Israel wrall koꞌo kaꞌn, naꞌ bxoz wnebiaꞌ keré kaꞌn, bde akeꞌ rweꞌ ganni. ¿Bixha da xhinnj benoꞌ naꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Naꞌll lle Jesúsenꞌ leꞌe: —Nllaꞌre nak yel llnebiaꞌ kiaꞌn, ka ke beꞌnn llnebiaꞌ yellrio ni. Chenak yel llnebiaꞌ kiaꞌn naken ke yellrio ni, wdil beꞌnn kaꞌ llzenay kiaꞌn chenak, naꞌ bi gakaꞌ rao naꞌa beꞌnn wnebiaꞌ ke Israel kaꞌ chenake. Zan yel llnebiaꞌ kiaꞌn bi naken ke yellrio ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Naꞌll lle Pilatonꞌ Leꞌe: —¿Rweꞌn nakoꞌ rey chaꞌ? Naꞌll goll Jesúsenꞌ leꞌe: —Da li kanꞌ neꞌo naꞌ, nakaꞌ rey, naꞌ ba bedaꞌ yellrio ni, nench wzejnieꞌraꞌ beꞌnnach diꞌll linꞌ, naꞌ yeolol beꞌnn llon ak txhen diꞌll linꞌ, llzenay akeꞌ kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Naꞌll lle Pilatonꞌ Leꞌe: —¿Bi danꞌ nak diꞌll linꞌ? Bayoll bne Pilatonꞌ kaꞌ, naꞌ bllojeꞌ ye to chiꞌi, ganꞌ zjallaꞌa beꞌnn Israel kaꞌ, naꞌ lleꞌe leakeꞌ: —Bibi da xhinnj nroeꞌn ke beꞌnnenꞌ chaꞌ bi lloneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Naꞌ ka nak danꞌ llonre yeo iz, de wsanaꞌ to beꞌnn yoꞌ rill ya rao lnni Paskwnꞌ. ¿Lleꞌnere wsanaꞌ beꞌnnenꞌ nak rey keré, beꞌnn Israel? ");
INSERT INTO zpuNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Naꞌll besiaꞌ akeꞌ, ne akeꞌ: —¡Bi wasanoꞌ beꞌnn naꞌ! ¡Barrabás naꞌ basán! Naꞌ Barrabásenꞌ nakeꞌ to beꞌnn wan. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Naꞌll goll Pilatonꞌ beꞌnn kaꞌ, bdin akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Naꞌ wakaꞌa ya kaꞌ, ben akeꞌ to da broꞌ akeꞌ yichjeꞌ de lba yeꞌche. Bayoll naꞌ, bwakw akeꞌ Leꞌe to raꞌll morad, ka da kaꞌ llonrén no beꞌnn wnebiaꞌ kaꞌ llin. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Naꞌll lltitj akreꞌ Leꞌe, naꞌ broꞌ akeꞌ ke xaꞌyeꞌ, naꞌ llasné akeꞌ: —¡Sechga ke beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Naꞌll blloj Pilatonꞌ da yobre lleꞌe leakeꞌ: —Kwejaꞌ beꞌnnenꞌ da yobre, nench nnézere bibi da xhinnj llallelraꞌ, chaꞌ bi noneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Naꞌ blloj Jesúsenꞌ yoꞌte danꞌ yichjeꞌ, danꞌ nak de lba yeꞌch naꞌ, naꞌ nakteꞌ raꞌll moradenꞌ. Naꞌ bne Pilatonꞌ: —Ganni ba ze beꞌnnenꞌ nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Naꞌ xan bxoz kaꞌ, naꞌ ren beꞌnn kaꞌ llape yodaꞌo braonꞌ, ka breꞌe akreꞌ Jesúsenꞌ, naꞌll besiaꞌ akeꞌ da zan ras bne akeꞌ: —¡Bdeꞌe leꞌ yay cruz! ¡Bdeꞌe leꞌ yay cruz! Naꞌll lle Pilatonꞌ leakeꞌ: —Lewcheꞌe chet kaꞌ, naꞌ lewdeꞌe reꞌ leꞌ yay cruzenꞌ, le bibi da xhinnj llallelraꞌ chaꞌ bi noneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Naꞌ beꞌnn Israel kaꞌ, lle akeꞌ leꞌe: —De to ley ketoꞌ da nen, llayaꞌl gateꞌ danꞌ neꞌe nakeꞌ Xhiꞌnn Dios, le beꞌnnachze Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Naꞌ ba llalleb Pilatonꞌ kanꞌ ba llaken, naꞌ ka benreꞌ xtiꞌll akeꞌn, blleblleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Naꞌ bayoeꞌ da yobre ganꞌ llieꞌ llnebieꞌn, zancheꞌe Jesúsenꞌ, naꞌ llnnabreꞌ Leꞌe: —¿Gaxha beꞌnne rweꞌ? Naꞌ bi balliꞌkze Jesúsenꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Naꞌll lle Pilatonꞌ Leꞌe: —¿Bi llalliꞌo xtiꞌllaꞌn? ¿Bi nnezroꞌ nadaꞌ napaꞌ yel llnebiaꞌ da yesanaꞌ rweꞌ, naꞌ napaꞌ yel llnebiaꞌ wchoybiaꞌ koꞌo, wdaꞌa akeꞌ rweꞌ leꞌ yay cruzenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Naꞌ balliꞌi Jesúsenꞌ xtiꞌlleꞌ, golleꞌ leꞌe: —Bibi yel llnebiaꞌ napoꞌ chenak bibi nonn Diosenꞌ rweꞌ. Zan beꞌnnenꞌ bde nadaꞌ rao naꞌon, naplleꞌ doꞌl ka rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Naꞌll bayirjlaꞌll Pilatonꞌ akre goneꞌ wasaneꞌ Jesúsenꞌ. Naꞌ beꞌnn Israel kaꞌ, besiaꞌ akeꞌ ne akeꞌ: —Chaꞌ ba llasanoꞌ beꞌnn ni, bi llonoꞌ kanꞌ ne beꞌnn wnebiaꞌ ke Romanꞌ, le noteze beꞌnn chaꞌ lloneꞌ kwineꞌ ka to beꞌnn llnebiaꞌ, naꞌ llkwaseꞌ beꞌnn wnebiaꞌn nziꞌi César kaꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Naꞌll ka bayoll bene Pilatonꞌ xtiꞌll akeꞌn, brejeꞌ Jesúsenꞌ liaꞌre, naꞌ renkze leꞌe bllojreneꞌ, naꞌ bllieꞌ ganꞌ lloneꞌ yel koxchisenꞌ, to latje danꞌ nziꞌi Ganꞌ Nak Rao Yej, diꞌll hebreo nziꞌn Gábata. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ka do wawill, ka wxere za sorao lnni Paskwnꞌ goll Pilatonꞌ beꞌnn Israel kaꞌ: —Ganni zo Rey kerénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Naꞌll bzorao akeꞌ llosiaꞌ akeꞌ da yobre, llasné akeꞌ: —¡Llayaꞌl gateꞌ! ¡Bdeꞌe leꞌ yay cruz! Naꞌll lle Pilatonꞌ leakeꞌ: —¿Rey keré ninꞌ, wdaꞌa Leꞌe leꞌ yay cruz? Naꞌll bne bxoz wnebiaꞌ kaꞌ: —Kere rey ketoꞌ beꞌnnenꞌ, toze César naꞌn nak beꞌnn llnebiaꞌ netoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Naꞌll bde Pilatonꞌ Jesúsenꞌ rao naꞌa akeꞌ, nench wdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. Naꞌll bzaꞌa akeꞌ Jerusalén naꞌ, bcheꞌe akteꞌ Jesúsenꞌ lloaꞌ yellre. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Naꞌ zej Jesúsenꞌ noeꞌ yay cruz keꞌen, naꞌ bllineꞌ to latje ganꞌ nziꞌi Latj ke Llit Wat, diꞌll hebreo nziꞌn Gólgota. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Naꞌ bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ, naꞌ leskaꞌ bdaꞌa akeꞌ ye chope beꞌnne leꞌ yay cruzenꞌ chlaꞌ weje kwit Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Naꞌ Pilatonꞌ bzojeꞌ yichj yay cruz keꞌen. Diꞌllenꞌ bzojenꞌ nen: “Jesús beꞌnn Nazaret, Rey ke beꞌnn Israel kaꞌ”. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bzojeꞌn diꞌll hebreo, naꞌ diꞌll griego, naꞌ diꞌll latín. Naꞌ zan beꞌnn Israel kaꞌ bel akeꞌn, le ganꞌ bdaꞌa Jesúsenꞌ leꞌ yay cruzenꞌ, naken awlloze Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Naꞌ bxoz wnebiaꞌ kaꞌ ke Israelenꞌ, goll akeꞌ Pilatonꞌ: —Bi wzojoꞌn: “Rey ke beꞌnn Israel kaꞌ”, wenre bzojen: “Leꞌen bneꞌe nakeꞌ rey ke beꞌnn Israel kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Naꞌll bne Pilatonꞌ: —Da ba nzojaꞌ ba nyojkzen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ka bayoll bdaꞌa beꞌnn wakaꞌa ya kaꞌ Jesúsenꞌ leꞌ yay cruzenꞌ, naꞌll bxhiꞌi akeꞌ xharaꞌneꞌn, naꞌ ben akeꞌn tapre, naꞌ bxhiꞌi akeꞌ twejeꞌn. Naꞌ leskaꞌ bxhiꞌi akeꞌ ye to xheꞌe danꞌ nak to chewalize, bibi dia zon. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Naꞌll lle lwellj akeꞌ: —Bi wcheꞌzllon, wenre chitjenllon, naꞌ norllo yedoꞌle len. Naꞌ kanꞌ ben akeꞌ naꞌ, bzoa diꞌll kanꞌ nyoj xtiꞌll Diosenꞌ nen: “Blaꞌ akeꞌ xharaꞌnaꞌn, naꞌ raꞌll danꞌ llakaꞌ naꞌ, bditj akeꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Naꞌ kaꞌlze ganꞌ zo cruz ke Jesúsenꞌ, ze María beꞌnnenꞌ nak xhneꞌe naꞌ, ren bir xhnaꞌ Jesús naꞌ, naꞌ María beꞌnnenꞌ nakeꞌ noꞌr ke Cleofas, naꞌ María Magdalena. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ka breꞌe Jesúsenꞌ ze xhneꞌen kaꞌlze, naꞌ ren ye to beꞌnnenꞌ nak leꞌe txhen, beꞌnnenꞌ nllieꞌ Jesúsenꞌ kwis, naꞌll lleꞌe xhneꞌen: —Beꞌnn naꞌ gakeꞌ ka xhiꞌnnoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Naꞌll lleꞌe beꞌnnenꞌ non Leꞌe txhen naꞌ: —Beꞌnn ni gakeꞌ ka xhnaꞌo. Naꞌ lla naꞌte beꞌnnenꞌ non Leꞌe txhen naꞌ, bxhieꞌ leꞌe, beneꞌ leꞌe ka xhneꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bde naꞌ, ba nneze Jesúsenꞌ ba gok yeolol da kaꞌ llayaꞌl gak keꞌen, kanꞌ ne xtiꞌll Diosenꞌ danꞌ nyoj naꞌ, bneꞌe: —Bilraꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Naꞌ de raꞌt zo zichj da yoll to lo leo daꞌo. Naꞌ to beꞌnnenꞌ bzaꞌlleꞌ zo zichjenꞌ to da nak ka xhiꞌre, bzoeꞌn to rao xhis ke yay danꞌ nziꞌi hisopo, naꞌ bliseꞌn llaꞌre, naꞌ bzoeꞌn lloaꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Naꞌ bayoll bxhoꞌp Jesúsenꞌ da zichjenꞌ, bneꞌe: —Ba gok yeolol da llayaꞌl gak, naꞌll le baxhexjte yichjeꞌn, naꞌ bayoneꞌ spíritu keꞌen rallnaꞌa Diosenꞌ, naꞌ goteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Naꞌllenꞌ beꞌnn wnebiaꞌ ke Israel kaꞌ, ba llseniaꞌ akeꞌ gaꞌl lnni Paskw ke akeꞌn, naꞌ jannab akeꞌ rao Pilatonꞌ, weꞌe latj lljatichj wakaꞌa ya keꞌe kaꞌ niaꞌ beꞌnn kaꞌ zjadaꞌa leꞌ yay cruzenꞌ, nench yob gat akeꞌ, naꞌ yeletj akeꞌ leakeꞌ leꞌ yay cruz kaꞌ, le bill lleꞌn akreꞌ taꞌlle beꞌnn kaꞌ leꞌ yay cruzenꞌ lla nbaꞌnne ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Naꞌll jak wakaꞌa ya kaꞌ, jatichj akeꞌ llop laꞌte niaꞌ beꞌnnenꞌ daꞌa kwit Jesúsenꞌ chlaꞌ. Naꞌ leskaꞌ ben akreꞌ beꞌnnenꞌ bdaꞌa ye chlaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Naꞌ ka bllin akeꞌ ganꞌ daꞌa Jesúsenꞌ, naꞌ breꞌe akereꞌ ba goteꞌ. Naꞌll bill bdichj akeꞌ nieꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Naꞌ to wakaꞌa yanꞌ goꞌdeꞌ to da látit lwit Jesúsenꞌ, naꞌ braꞌn llen ren nis. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nadaꞌ breꞌraꞌ kanꞌ goken, naꞌ nnezraꞌ lloaꞌa diꞌll li, nench chejleꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Naꞌ da kaꞌn gok ke Jesúsenꞌ, nench gok kanꞌ ne xtiꞌll Diosenꞌ danꞌ nyoj keꞌe, nen: “Ni to llit yoeꞌ bi chichj akeꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Naꞌ ye to ganꞌ nen: “Yeswia akeꞌ beꞌnnenꞌ ba bllia akeꞌ weꞌe.” ");
INSERT INTO zpuNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bayoll gok yeolol da kaꞌ, José beꞌnnenꞌ nak beꞌnn yell ganꞌ nziꞌi Arimatea, jannabreꞌ Pilatonꞌ weꞌe latj yeletjeꞌ Jesúsenꞌ. Naꞌ beꞌe Pilatonꞌ latj. Naꞌll byej Josénꞌ jaletjeꞌ Jesúsenꞌ. Josénꞌ ba llejleꞌ ka nak danꞌ broeꞌ bsede Jesúsenꞌ, naꞌ ba llonliraꞌlleꞌ Leꞌe llillize, le llebeꞌ beꞌnn wnebiaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naꞌ leskaꞌ byej Nicodemonꞌ beꞌnnenꞌ ba byej ganꞌ zo Jesúsenꞌ ba gole, naꞌ noꞌxe to da laꞌ xhix, da nchix nell danꞌ nziꞌi mirra, naꞌ ren to yezj danꞌ nziꞌi áloes, ka do chonn rrobenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Naꞌll bchel akeꞌ kwerp ke Jesúsenꞌ to raꞌll xhen, naꞌ ren danꞌ laꞌ xhix naꞌ, le kaꞌ llon beꞌnn Israel kaꞌ, llkwaꞌch akeꞌ beꞌnn wat ke akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kwitze ganꞌ bdaꞌa akeꞌ Jesúsenꞌ leꞌ yay cruzenꞌ, de to reꞌj ga naz akeꞌ yay ak. Naꞌ gannaꞌ ben akeꞌ to bloj, nench ben akeꞌn ka to ba, naꞌ nono nna choꞌ beꞌnn wat rao yellrionꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ka llanꞌ got Jesúsenꞌ naken llanꞌ llsiniaꞌ akeꞌ ke lla nbaꞌnne, naꞌllenꞌ llyen akreꞌ wkwaꞌch akeꞌ Leꞌe awlloze. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Naꞌ bal dmio naꞌ, nna nakte xchole, byej María Magdalena lloaꞌ broj ganꞌ broꞌ akeꞌ Jesúsenꞌ. Naꞌ breꞌreꞌ ganꞌ bgaꞌch Jesúsenꞌ, ba bagaꞌa yejenꞌ danꞌ bdaꞌa akeꞌ lloaꞌ ba naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Naꞌll bazaꞌdoeꞌ bayejeꞌ ganꞌ zo Simón Pedronꞌ, naꞌ ren ye to beꞌnn nak Jesúsenꞌ txhen, beꞌnnenꞌ nllieꞌ Jesúsenꞌ kwis, naꞌll lleꞌe leakeꞌ: —Ba babej akeꞌ Xanllonꞌ lo banꞌ, naꞌ bi nnézetoꞌ ga jaloꞌ akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Naꞌll bzaꞌa Pedronꞌ ren beꞌnnenꞌ ye to, jakeꞌ lloaꞌ brojenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Llopteꞌ bzaꞌdo akeꞌ, bixha beꞌnnenꞌ ye to bzaꞌdolleꞌ ye raꞌte res ka Simón Pedronꞌ, naꞌ byoblleꞌ bllineꞌ lloaꞌ banꞌ ka leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Naꞌll blleꞌkeꞌ bwieꞌ lo banꞌ, naꞌ breꞌreꞌ raꞌll kaꞌ, zjalliꞌn lo ba naꞌ, naꞌ bi byoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Le bllinte Simón Pedronꞌ, le byoꞌteꞌ lo brojenꞌ, naꞌ breꞌreꞌ raꞌll kaꞌ zjalliꞌn loe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Naꞌ bay danꞌ bchel akeꞌ yichjeꞌn, bi lliꞌn ganꞌ lliꞌ raꞌll kaꞌ, lliꞌten chlaꞌre ndoben. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naꞌ byoꞌrén beꞌnnenꞌ ye to, le bi nna choeꞌ, laꞌkze byoblleꞌ bllineꞌ lloaꞌ ba naꞌ. Naꞌll breꞌreꞌ kanꞌ naken naꞌ, naꞌtelle byejleꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Le bi nna chejnieꞌ akreꞌ xtiꞌll Diosenꞌ danꞌ nyoj nen, llayaꞌleꞌ yebaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Naꞌll bazaꞌa akeꞌ, naꞌ jayakeꞌ yoꞌ ganꞌ zo akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Naꞌ Maríanꞌ bagaꞌnneꞌ kaꞌlte lloaꞌ banꞌ, bzeꞌe belleꞌ. Nna bellteꞌ naꞌn, blleꞌkeꞌ naꞌ bwieꞌ lo ba naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Naꞌ breꞌreꞌ chop angl beꞌnn nak akeꞌ raꞌll lliche, zjalliꞌ akeꞌ lo ba naꞌ, toeꞌ lliꞌ yichjre ganꞌ bxhoa Jesúsenꞌ, naꞌ ye toeꞌ lliꞌ xhnieꞌre ganꞌ bxhoeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Naꞌll lle akeꞌ noꞌrenꞌ: —¿Bixchen belloꞌ noꞌre? Naꞌll ballieꞌ xtiꞌll akeꞌn, bneꞌe: —Ba badrej akeꞌ Xanllonꞌ, naꞌ gara jaroꞌ akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bayoll bne Maríanꞌ kaꞌ, ka bayechjkzereꞌ zellá Jesúsenꞌ koꞌllre; naꞌ bi gokbeꞌreꞌ chet kaꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Naꞌll lle Jesúsenꞌ leꞌe: —¿Bixchen belloꞌ noꞌre? ¿Noxhanꞌ llayirjoꞌ? Maríanꞌ llakreꞌ chaꞌ beꞌnne llap reꞌj naꞌn, naꞌll balwilleꞌ leꞌe, lleꞌe Leꞌe: —Bne, chaꞌ rweꞌn jasanoeꞌ ga yobre, bne nadaꞌ ga jasanoeꞌ nench lljaxhieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Naꞌll lle Jesúsenꞌ leꞌe: —¡María! Naꞌll byechj Maríanꞌ da yobre, naꞌ lleꞌe Leꞌe: —¡Raboni! —diꞌll hebreo lleꞌnen nen beꞌnn llzejnieꞌ beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesúsenꞌ lleꞌe leꞌe: —Bi goꞌxoꞌ nadaꞌ, le bi nna yeyepaꞌ yebá ganꞌ zo Xaꞌ naꞌ. Bayejrén beꞌnn kaꞌ ba bzenay xtiꞌllaꞌn, beꞌnn kaꞌ nak ka biꞌchaꞌ, ka zanaꞌ, naꞌ goll akeꞌ yeyepaꞌ ganꞌ zo Xaꞌn, beꞌnnenꞌ nakrenkze Xare. Nakeꞌ Dios beꞌnnenꞌ llonaꞌ nadaꞌ xhen, leskaꞌ nakeꞌ Dios beꞌnnenꞌ llonre xhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Naꞌll bazaꞌa María Magdalenanꞌ, jadixjweꞌreꞌ yezikre beꞌnn kaꞌ llzenay xtiꞌll Jesúsenꞌ, le ba breꞌreꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Naꞌ gol lleꞌ dmio naꞌ, nna ndop beꞌnn kaꞌ non Jesúsenꞌ txhen lo yoꞌn neyjchochten, le lleb akeꞌ beꞌnn wnebiaꞌ ke beꞌnn Israel kaꞌ. Naꞌ byoꞌ Jesúsenꞌ, naꞌ jaseꞌe kllol beꞌnn kaꞌ, naꞌ lleꞌe leakeꞌ: —Lesó nbaraz lo yichjraꞌlldaꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bayoll bneꞌe kaꞌ, le broeꞌtereꞌ leakeꞌ lo taꞌkeꞌn, naꞌ ren lwiteꞌ naꞌ. Naꞌll bawé akreꞌ kwis, ka breꞌe akreꞌ Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Naꞌ lleꞌe leakeꞌ da yobre: —Lesó nbaraz lo yichjraꞌlldaꞌore. Kanꞌ bseꞌl Xaꞌn nadaꞌ yellrio ni, baddiaꞌ xtiꞌlleꞌn, leskaꞌ nadaꞌ llseꞌlaꞌ reꞌ weꞌre xtiꞌllaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bayoll bneꞌe kaꞌ, naꞌll brobeꞌ leakeꞌ, naꞌ golleꞌ leakeꞌ: —Lesiꞌi Spíritu ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Beꞌnn kaꞌ yereꞌ: “Ba banit barán da xhinnj keré kaꞌ”, ba bnitraokzen naꞌ, naꞌ beꞌnn yereꞌ: “Bi nna yenitrao da xhinnj keré kaꞌ”, bi nna yenitraokzen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naꞌ Tomás beꞌnnenꞌ bsiꞌi akeꞌ Tomás Dídimo, beꞌnn ren rao beꞌnn chllinn kaꞌ, bi zoeꞌ kanꞌ jaroeꞌrao Jesúsenꞌ leakeꞌ lleꞌ dmio naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Naꞌ beꞌnn kaꞌ yelaꞌ goll akeꞌ leꞌe: —Ba breꞌtoꞌ Xanllonꞌ. Naꞌll lle Tomásenꞌ leakeꞌ: —Bi chejliaꞌ chaꞌ nbaneꞌ, chaꞌ bi reꞌraꞌ lo taꞌkeꞌn ganꞌ bzo akeꞌ klav kaꞌ, naꞌ wzeb xhbenaꞌ ganꞌ bdeb klav kaꞌ, naꞌ ren leꞌ lwiteꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ka bde to xhman naꞌ, badop akeꞌ lo yoꞌn da yobre, naꞌ zerén Tomásenꞌ leakeꞌ. Naꞌ laꞌkze neyjte yoꞌn, byoꞌ Jesúsenꞌ da yobre, naꞌ jaseꞌe radj akeꞌn, naꞌ bneꞌe: —Lesó nbaraz lo yichjraꞌlldaꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Naꞌll golleꞌ Tomásenꞌ: —Bwia lo taꞌkaꞌ ki, naꞌ bzeb xhbenoꞌn. Naꞌ bzeb naꞌon lwitaꞌ ni, nench chejleꞌo. Bi gakoꞌ beꞌnn bi llejleꞌ, byejleꞌchga. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Naꞌll bne Tomásenꞌ: —¡Xanaꞌ, naꞌ Dios kiaꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Naꞌll bne Jesúsenꞌ, lleꞌe Tomásenꞌ: —Tomás, ba byejleꞌo danꞌ ba breꞌroꞌ nadaꞌn. Nbaraz ke beꞌnn kaꞌ ba llejleꞌ akeꞌ, laꞌkze bi nna reꞌe akreꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Da zan yel wakenꞌ ben Jesúsenꞌ, da breꞌe beꞌnn kaꞌ non Leꞌe txhen, da bi nyoj leꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Naꞌ da ki nyojen nench chejleꞌre ke Jesúsenꞌ nakeꞌ Cristo, beꞌnnenꞌ nak Xhiꞌnn Dios, naꞌ gonneꞌ yel nban zejlikane keré danꞌ llonliraꞌllreꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bde ye to lla yobre, broeꞌrao Jesúsenꞌ beꞌnn keꞌe kaꞌ non Leꞌe txhen, lloaꞌ nisdaꞌo danꞌ nziꞌi Nisdaꞌo Tiberias, ki gok: ");
INSERT INTO zpuNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ze akeꞌ txhen Simón Pedronꞌ ren Tomás beꞌnnenꞌ nsiꞌi akeꞌ Dídimo, naꞌ ren Natanael beꞌnn yell Caná ganꞌ nbane Galilea, naꞌ llop xhiꞌnn Zebedeonꞌ, naꞌ ye chop beꞌnn kaꞌ non Jesúsenꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Naꞌ lle Simón Pedronꞌ leakeꞌ: —Chaꞌa wxhen bel. Naꞌll lle akeꞌ leꞌe: —Leskaꞌ wzaꞌrén netoꞌ. Naꞌll bzaꞌa akeꞌ jakeꞌ lloaꞌ nisdaꞌon, naꞌ byoꞌ akeꞌ to lo barco. Naꞌt nokze no bel bllel akreꞌ lleꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Naꞌ kanꞌ ba zaꞌa lleniꞌ naꞌn, breꞌe akreꞌ ze Jesúsenꞌ lloaꞌ nisdaꞌon, naꞌ bi gok akreꞌ chaꞌ Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Naꞌll lleꞌe leakeꞌ: —Xhiꞌnnaꞌ daꞌo ak, ¿de bel gaollo? Naꞌll lle akeꞌ Leꞌe: —Kaꞌa, nokz no lldoꞌletoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Naꞌll lleꞌe leakeꞌ: —Lewzaꞌl yixj bel kerénꞌ kwit barconꞌ chaꞌore, naꞌll doꞌl akbaꞌ. Naꞌll bzaꞌl yixj bel ke akeꞌn. Naꞌ bel zan kwis bdoꞌl akreꞌ, to bi zoe akreꞌ yegoꞌ akeꞌn lo barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naꞌ to beꞌnnenꞌ nllieꞌ Jesúsenꞌ, lleꞌe Pedronꞌ: —Xanllo naꞌn. Naꞌ kate golleꞌ Simón Pedronꞌ, Xanllo naꞌn, le bayakdote Pedro xharaꞌneꞌn, le kere bi nakeꞌn lloneꞌ llin naꞌ, naꞌ le bxhiꞌtteꞌ lo nisenꞌ, nench byob bllineꞌ ganꞌ ze Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Naꞌ zjakdo ren beꞌnn kaꞌ yelaꞌ ren barconꞌ, nxhob akeꞌ yixj ganꞌ llaꞌa belyaꞌ kaꞌ, le ka do ye chop gayoa (200) wakaꞌa niaꞌ, lloaꞌ nisdaꞌo naꞌn ze akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ka bayetj akeꞌ lloaꞌ nisdaꞌon, jadiꞌ akreꞌ ga lliꞌ yiꞌ barje, naꞌ xhoa to belyaꞌ rawenꞌ, naꞌ ye to yet xtir. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Naꞌ lle Jesúsenꞌ leakeꞌ: —Leyeyoꞌx to chop belyaꞌ kaꞌ nile, ba kaꞌ za bxhenre naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Naꞌll byej Simón Pedronꞌ, jaxhieꞌ yixj belenꞌ ganꞌ lliꞌ barconꞌ, naꞌ baxhobeꞌn ganꞌ nak yo bill. Llaꞌn to gayoa chiꞌnnayon (153) bel xhen kaꞌ, naꞌ laꞌkze llaꞌa bel zan loe naꞌ, bi blleꞌzen. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Naꞌll lle Jesúsenꞌ leakeꞌ: —Ledá gaore. Naꞌ ni toeꞌ bi bayaxhje, ye akeꞌ Leꞌe: “¿Noxha rweꞌ?”, le ba gokbeꞌe aksreꞌ Xanllo naꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Naꞌll jabiꞌy Jesúsenꞌ, naꞌ bxhieꞌ yet xtirenꞌ, naꞌll beꞌe ke ke beꞌnn kaꞌ, naꞌ leskaꞌ beneꞌ belyaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kanꞌ gok da wyonn rase, broeꞌraweꞌ beꞌnn kaꞌ non Leꞌe txhen naꞌ, bde ka nak babaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Naꞌ ka bayoll badao akeꞌn, naꞌ lle Jesúsenꞌ Simón Pedronꞌ: —Simón xhiꞌnn Jonás, ¿nllieꞌllroꞌ rweꞌ nadaꞌ, kerke kanꞌ nllieꞌ beꞌnn ki nadaꞌ? Naꞌ balliꞌi Pedronꞌ xtiꞌlleꞌn, lleꞌe Leꞌe: —Awaꞌ Xanaꞌ, nnezkzroꞌ nllieꞌraꞌ rweꞌ. Naꞌll lle Jesúsenꞌ leꞌe: —Bdap bwia beꞌnn kaꞌ nak ka xhiꞌr daꞌo kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Naꞌ golleꞌ leꞌe da wllop ras: —Simón xhiꞌnn Jonás, ¿nllieꞌroꞌ nadaꞌ? Naꞌll da yobre bne Pedronꞌ: —Xanaꞌ, rweꞌkzoꞌ nnezroꞌ nllieꞌraꞌ rweꞌ. Jesúsenꞌ golleꞌ leꞌe: —Bwia beꞌnn kaꞌ nak ka xhiꞌr daꞌo kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Naꞌ da wyonn ras goll Jesúsenꞌ Leꞌe: —Simón xhiꞌnn Jonás, ¿nllieꞌroꞌ nadaꞌ? Naꞌ gokyaꞌche Pedronꞌ danꞌ goll Jesúsenꞌ leꞌe kaꞌ da wyonne ras, naꞌll lleꞌe Leꞌe: —Xanaꞌ, rweꞌkzoꞌ nnezroꞌ yeololten, naꞌ rweꞌ nnézkzeroꞌ nllieꞌraꞌ rweꞌ. Naꞌll lle Jesúsenꞌ leꞌe: —Bdap bwia beꞌnn kaꞌ nak ka xhiꞌr kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Diꞌll li, diꞌll li llepaꞌ rweꞌ: Ka gokoꞌ bi weꞌo, kwinoꞌ gokoꞌ xharaꞌnoꞌn, naꞌ byejoꞌ kon ga nen koꞌo. Naꞌ kat gakoꞌ beꞌnn gore, wli naꞌon, naꞌ beꞌnn yobre wakweꞌ xharaꞌnoꞌn, naꞌ yecheꞌe rweꞌ ga bi llazraꞌlloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Golleꞌ leꞌe kaꞌ nench broeꞌreꞌ Pedronꞌ, kanꞌ gak keꞌe kat llin lla gateꞌ, naꞌ kone len weꞌraweꞌ Diosenꞌ. Naꞌll goll Jesúsenꞌ leꞌe: —Kon benliraꞌll, naꞌ bnao nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Naꞌ ye to beꞌnn non Jesúsenꞌ txhen naweꞌ leakeꞌ. Naꞌ bayechj Pedronꞌ breꞌreꞌ leꞌe. Naꞌ nakeꞌ beꞌnnenꞌ nllieꞌ Jesúsenꞌ, beꞌnnenꞌ blleꞌ kwiteꞌ, kanꞌ bdao akeꞌ xcheꞌ, ka za gak Jesúsenꞌ rallnaꞌa beꞌnn kaꞌ llwietate Leꞌen, beꞌnnenꞌ bnnabeꞌ Leꞌe: “Xanaꞌ, ¿noxhanꞌ wde rweꞌ rao naꞌa beꞌnn kaꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ka breꞌe Pedronꞌ leꞌen, lleꞌe Jesúsenꞌ: —Xanaꞌ, ¿akxha gak ke beꞌnn ni? ");
INSERT INTO zpuNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Naꞌll lle Jesúsenꞌ leꞌe: —Chaꞌ lleꞌnraꞌ nna zokzeꞌ kat yedaꞌ da yobre, ¿bi zed llakroꞌ? Rweꞌn bzoteze benliraꞌll nadaꞌ, naꞌ bzenay kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Naꞌll biteze bne beꞌnn kaꞌ llonliraꞌll Cristonꞌ, ne akeꞌ bi gat beꞌnnenꞌ. Zan kere bne Jesúsenꞌ bi gateꞌn, bneꞌe: “Chaꞌ lleꞌnraꞌ nna zokzeꞌ kat yedaꞌ da yobre, ¿bi zed llakroꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Beꞌnn ninꞌ nnezreꞌ kanꞌ gok yeolol da ki, ke len naꞌ ba beꞌe diꞌll ki, naꞌ ba bzojeꞌn. Naꞌ nnézkzello lloeꞌ diꞌll li. ");
INSERT INTO zpuNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Naꞌ da zanll da ben Jesúsenꞌ da bi nyoj, le chenak nyoj yeololen, ni rao yellrio ni, bi gaken chaꞌn, le yich zan kwis gaken chenake. Kaꞌn gakchga.");
INSERT INTO zpuNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ke nak yich nellenꞌ bzojaꞌ rweꞌ Teófilo, gannaꞌ nlliaꞌ yeolol da kaꞌ ben Jesúsenꞌ, naꞌ danꞌ broeꞌreꞌ ");
INSERT INTO zpuNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","bllinte lla bazeꞌe baziꞌi Diosenꞌ Leꞌe yebá da yobre. Ka za wazaꞌtereꞌ, beꞌreneꞌ postl keꞌe kaꞌ diꞌll binꞌ llayaꞌl gon akeꞌ, beꞌe diꞌll kon kaꞌ bzejnieꞌ Spíritu ke Diosenꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Broeꞌraweꞌ leakeꞌ, naꞌ da zan da beneꞌ nench byejleꞌ akeꞌ, da likzenꞌ babaneꞌ radj beꞌnn wat kaꞌ. Bdareneꞌ leakeꞌ rao choa (40) lla, naꞌ ye to chiꞌi bzejnieꞌreꞌ leakeꞌ kanꞌ nak yel llnebiaꞌ ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nna zorenteꞌ leakeꞌ txhen, golleꞌ leakeꞌ bi llayaꞌl yellach akeꞌ Jerusalén naꞌ, bneꞌe: —Kwexhre nize llinte kat wseꞌl Xaꞌn danꞌ bchebeꞌ, kanꞌ ba gollkzaꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Da li Juan naꞌ bchoeꞌ beꞌnn nis, naꞌ tere wakll wen ke reꞌ, ke nak ba zo rez yedsó Spíritu ke Diosenꞌ yichjraꞌlldaꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Naꞌ gok ka badop akeꞌ rao Jesúsenꞌ, naꞌ goll akeꞌ Leꞌe: —Xantoꞌ, ¿kere ba bllin lla gonoꞌ nench yelloj beꞌnn Israel kaꞌ rao naꞌa beꞌnn ziꞌt kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Naꞌll lleꞌe leakeꞌ: —Bi llayaꞌl nnézere bi llanꞌ gon Xallo Diosenꞌ da llwieꞌ goneꞌ rao rall-llo ni. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Zan katenꞌ yed Spíritu keꞌen yedsorenen reꞌ, kanaꞌ gapre yel wak keꞌe, naꞌ chislasre xtiꞌllaꞌn, soraozre Jerusalén naꞌ, naꞌll yell kaꞌ ganꞌ nziꞌi Judea, naꞌ ganꞌ nziꞌi Samaria, naꞌtell doxhen yellrio. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bayoll bneꞌe kaꞌ, naꞌ llwia akteꞌ Leꞌe naꞌ, kat bayepeꞌ yebánꞌ, le zete to bej bkwaꞌchen Leꞌe rao akeꞌn, naꞌ bill breꞌe akreꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bixha nna ze akteꞌ llwia akeꞌ yebá ganꞌ bayepeꞌ naꞌ, kat bllinkze chop beꞌnn kwit akeꞌn, naꞌ nak xharaꞌn akeꞌ llich kwis. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Naꞌll lle beꞌnn kaꞌ leakeꞌ: —Reꞌ beꞌnn Galilea, ¿bixchen nna zezre llwiare yebánꞌ? Kanꞌ breꞌkzere zayej Jesúsenꞌ yebánꞌ, baziꞌi Diosenꞌ Leꞌe radjre naꞌ, kaꞌkze gak katenꞌ yedeꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Naꞌ bazaꞌa akeꞌ rao yaꞌ ganꞌ llaꞌa akeꞌn, yaꞌ ganꞌ nziꞌi Yaꞌ Olivos, zayej akeꞌ Jerusalén naꞌ. Naꞌ naken awlloze, ke to de latj saꞌa akeꞌ rao lla nbaꞌnne ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Naꞌ ballín akeꞌ latj ganꞌ lljaxhiꞌraꞌll postl kaꞌ, to yoꞌ da zo chkwia. Gannaꞌ ren Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo xhiꞌnn Alfeo, Simón beꞌnn ben txhen beꞌnn kaꞌ nziꞌi Zelote, naꞌ Judas biꞌch Jacobo. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yeolol akeꞌ llaꞌa nak akeꞌ toze, llalwill akeꞌ Diosenꞌ yeo lla. Gannaꞌ ren María xhnaꞌ Jesúsenꞌ ren biꞌcheꞌ kaꞌ, naꞌ ye bal noꞌr non leakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ka bllin to lla, bzollaꞌa Pedronꞌ radj akeꞌn, naꞌ nak to gayoa galj akeꞌ (120), naꞌ bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Reꞌ beꞌnn biꞌche, dekz de gok kanꞌ nyoj xtiꞌll Diosenꞌ. Batnaꞌte Spíritu ke Diosenꞌ bzejnieꞌn rey Davidenꞌ, nench beꞌe diꞌll ke Judas beꞌnnenꞌ bcheꞌe beꞌnn kaꞌ beꞌx akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas naꞌ gokeꞌ netoꞌ txhen bentoꞌ xchin Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Naꞌ ka nak da xhinnjenꞌ beneꞌn, bxhiꞌi raxhjeꞌ, naꞌ bayaꞌweꞌ to yellrio. Naꞌ ka goteꞌn bayexjeꞌ jatin yichjeꞌ, blleꞌzte leꞌen, naꞌ blloj doxhen xhojloeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yeolol beꞌnn Jerusalén kaꞌ, bnnez akreꞌ kanꞌ goken, naꞌ bsiꞌi akeꞌ yellrionꞌ Acéldama, naꞌ Acéldama naꞌ lleꞌnen nen Yellrio Llen. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ke nak da ni, ba nyojkzen leꞌ yich ke Salmos ganꞌ nen ki: Gakchga rilleꞌn to da dach, naꞌ nono sokze len. Leskaꞌ nen: Naꞌ te to beꞌnn yobre wlaneꞌ xchineꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Ke nak ganni llaꞌa bal beꞌnn non lliꞌo txhen, chak bda Xanllo Jesucristo radjllo ni, ");
INSERT INTO zpuNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","beꞌnn ki llon lliꞌo txhen, bzoraozen kanꞌ bchoa Juan naꞌ Leꞌe nis, bllinte ka baziꞌi Diosenꞌ Leꞌe yebá. Naꞌ llayaꞌl kwejllo toeꞌ, nench goneꞌ netoꞌ txhen, weꞌtoꞌ diꞌll ke Jesucristonꞌ kanꞌ gok babaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Naꞌ brej akeꞌ chopeꞌ, toeꞌ re José beꞌnn nsiꞌi akeꞌ Barsabás, leskaꞌ re Justo, naꞌ ye toeꞌ re Matías. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Naꞌll balwill akeꞌ Diosenꞌ bne akeꞌ: —Xantoꞌ, rweꞌ nombiaꞌo ke nak yichjraꞌlldaꞌo yeolol beꞌnne, broeꞌ netoꞌ nore beꞌnn ki chop, ba brejoꞌ ");
INSERT INTO zpuNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","gakeꞌ netoꞌ txhen gontoꞌ xchinoꞌn. Ke nak Judas naꞌ, bsanraꞌlleꞌ danꞌ benoꞌ rallneꞌe goneꞌn, naꞌ ba zayejeꞌ ganꞌ llayaꞌl wayejkzeꞌ yel beꞌnn wen da xhinnj keꞌe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Naꞌll bzaꞌl akeꞌ yej daꞌo ak, nench nore lljataꞌn, naꞌ blloj toeꞌ, naꞌ beꞌnnenꞌ re Matías bdoꞌlen leꞌe, naꞌ gokeꞌ txhen ren postl kaꞌ ye chnej. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ka bllin lla lnni danꞌ ne Pentecostés, yeolol beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, nak akeꞌ toze ganꞌ llaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kat gokse llakia yebánꞌ ke ga zaꞌa to beꞌ xhen, bllinte lo yoꞌ ganꞌ llaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Naꞌ breꞌe akreꞌ da nak ka bel yiꞌ, llalnninnen jasó raꞌt wejen yichj toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yeolol akeꞌ byoꞌ Spíritu ke Diosenꞌ yichjraꞌlldaꞌo akeꞌ, naꞌ bzorao llnne akeꞌ wde wdere diꞌll, kon ka llzejnieꞌ Spíritunꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naꞌ beꞌnn zan beꞌnn Israel kaꞌ lloeꞌrao Diosenꞌ ba ndop akeꞌ Jerusalén naꞌ, naꞌ gateze yell zaꞌk toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ka ben akreꞌ gok llakianꞌ, beꞌnn zan bdop ganꞌ llaꞌa postl kaꞌ, naꞌll to nnaꞌl-llej akzeꞌ, ka nak llen akreꞌ llnne beꞌnn kaꞌ xtiꞌll toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Naꞌ llaꞌa akeꞌ llabán akreꞌ, ne akeꞌ: —¿Kere beꞌnn Galilea beꞌnn ki? ");
INSERT INTO zpuNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Akre llakze llnne akeꞌ xtiꞌll-llo da gorjrén totollo? ");
INSERT INTO zpuNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ganni llaꞌa bal-llo nakllo beꞌnn Partia, naꞌ beꞌnn Media, naꞌ beꞌnn Elam. Naꞌ bal-llo nakllo beꞌnn Mesopotamia, naꞌ beꞌnn Judea, naꞌ beꞌnn Capadocia, naꞌll beꞌnn Ponto, naꞌ Asia. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Naꞌ beꞌnn Frigia, naꞌ beꞌnn Panfilia, naꞌ beꞌnn Egipto, naꞌ rente beꞌnn zaꞌa yell kaꞌ zjalliꞌ África, ziꞌtre ka ganꞌ nziꞌi Cirene, bixha ren beꞌnn Roma zo ganni, beꞌnn nakse beꞌnn Israel, naꞌ beꞌnn za bayak txhen beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Naꞌtell beꞌnn Creta, naꞌ beꞌnn Arabia. ¡Naꞌ ka nak beꞌnn Galilea ki, lloeꞌrén akeꞌ lliꞌo diꞌll ren xtiꞌll totollo, kanꞌ nak yel wak ke Diosenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yeolol akeꞌ llaꞌa llakgan akreꞌ, naꞌ llabán akreꞌ lle lwellj akeꞌ: —¿Akre ka chejnieꞌre kanꞌ llaken? ");
INSERT INTO zpuNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Naꞌ ye bal akeꞌ lltitj akreꞌ, ne akeꞌ: —Zoll akreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Naꞌ bzollaꞌa Pedronꞌ ren beꞌnn chnej kaꞌ, naꞌ bnneꞌe zillj, lleꞌe leakeꞌ: —Reꞌ beꞌnn Israel, naꞌ yeolol reꞌ llaꞌa Jerusalén ni nnaꞌ lla, lewzenay, llonen bien nnézere diꞌllenꞌ weꞌrenaꞌ reꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kere zolle beꞌnn ki kanꞌ nere naꞌ, le nna nak tzire. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ganni llak kanꞌ bzoj da Joel, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, bzojeꞌ kanꞌ bne Diosenꞌ ki: ");
INSERT INTO zpuNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kate ba zo rez wayoll yellrio, nadaꞌ Dios wseꞌlaꞌ Spíritu kiaꞌn, naꞌ sorenen yeolol beꞌnne, naꞌ gonaꞌ nench xhiꞌnnre byio, naꞌ xhiꞌnnre noꞌr, weꞌe akbeꞌ xtiꞌllaꞌn. Naꞌ bi weꞌo kaꞌ, reꞌdaꞌo akebeꞌ, naꞌ beꞌnn gor kaꞌ, nne akreꞌ yere. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Beꞌnn kaꞌ llon xchinaꞌn beꞌnn byio ren noꞌre, sorén Spíritu kiaꞌn leakeꞌ, nench weꞌe akeꞌ xtiꞌllaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gonaꞌ leꞌ yebánꞌ da yebane beꞌnne, naꞌ rao yellrio wroeꞌraꞌ yel wak kiaꞌn, naꞌ larj llen, naꞌ xhen yiꞌ, naꞌ kweꞌ llén da nak ka bej. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Willenꞌ wayaken da xchole, naꞌ beꞌon wayaken xhna ka llen, katenꞌ ba zon llin lla yedaꞌ da yobre, nadaꞌ nakaꞌ Xanre. Kanaꞌ gaken to lla lliarao xhen, naꞌ wroeꞌraꞌ yel wak kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ka nak nadaꞌ nakaꞌ Xanre, noteze beꞌnn yelwille nadaꞌ, nadaꞌ yesreꞌe rao da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Naꞌ reꞌ beꞌnn Israel, lewzenay xtiꞌllaꞌn. Ke nak Jesús beꞌnn Nazaretenꞌ, Diosenꞌ broeꞌreꞌ nakeꞌ beꞌnn zaꞌke. Diosenꞌ beneꞌ nench Jesúsenꞌ beneꞌ yel wak, naꞌ billre da yebánello kanꞌ ba nnézkzere naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bixha gok Jesúsenꞌ rallnaꞌre kanꞌ ba nwiakze Diosenꞌ, naꞌll benreꞌ rao naꞌa beꞌnn wen da xhinnj kaꞌ, naꞌ bet akeꞌ Leꞌe bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bixha nnaꞌ Diosenꞌ basbaneꞌ Leꞌe radj beꞌnn wat kaꞌ, yel gotenꞌ bi bzoen wzaꞌyen Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Le kaꞌkzenꞌ bne rey Davidenꞌ batnaꞌ, beꞌe xtiꞌll Jesúsenꞌ bneꞌe: Llreꞌteze llreꞌraꞌ Xanllonꞌ, zeꞌe kwitaꞌ, ke len naꞌ notno soe wta wnne nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Naꞌll llawé raꞌlldaꞌwaꞌ, naꞌ llolaꞌ nench lloeꞌraweꞌ. Naꞌ leskaꞌ nnezraꞌ katenꞌ gataꞌ, kere ke chnarenꞌ gataꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Le nnézkzeraꞌ bi wsanraꞌlloꞌ nadaꞌ ganꞌ llaꞌa beꞌnn wat kaꞌ. Bi weꞌo latj goꞌll xpeꞌraꞌn, nadaꞌ nakaꞌ rallnaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Broeꞌroꞌ nadaꞌ ka nak nez danꞌ zej rao yel nban naꞌ, naꞌ yeweraꞌ kwis ke naken zerenoꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Reꞌ beꞌnn biꞌche, nnézello xozxtaꞌollo Davidenꞌ goteꞌ, naꞌ bkwaꞌch akeꞌ leꞌe, naꞌ llreꞌtello ba keꞌen nnaꞌ lla. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Naꞌ rey Davidenꞌ gokeꞌ to beꞌnn beꞌe xtiꞌll Dios, beꞌe diꞌll kanꞌ bzejnieꞌ Diosenꞌ leꞌe, naꞌllenꞌ bnnezreꞌ kwasro kanꞌ gaken, le kwin Diosenꞌ bchebeꞌ bneꞌe, Cristonꞌ garjeꞌ rao xhiꞌnn dialla keꞌe, naꞌ nnebieꞌ rorazeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ke len naꞌ gokbeꞌe Davidenꞌ kanꞌ yebán Cristonꞌ, bneꞌe bi gaꞌyeꞌ ganꞌ llaꞌa beꞌnn wat kaꞌ, naꞌ bi goꞌll xpeꞌreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Naꞌ ba gok kanꞌ bneꞌen, ke nak Diosenꞌ basbaneꞌ Jesúsenꞌ radj beꞌnn wat kaꞌ, naꞌ netoꞌ lloeꞌtoꞌ xtiꞌlleꞌn, breꞌtoꞌ kwasro kanꞌ babaneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Naꞌ nnaꞌ Diosenꞌ ba baliseꞌ Leꞌe, bazieꞌ Leꞌe kwiteꞌ, naꞌ ba llnebiaꞌreneꞌ Leꞌe txhen. Naꞌ Diosenꞌ beneꞌ rallneꞌe Spíritu keꞌen, kanꞌ ba bchebeꞌ naꞌ. Jesús naꞌn ba beneꞌ yel wak ni, kanꞌ ba bénere, naꞌ kanꞌ ba breꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ka nak rey Davidenꞌ kere bayepeꞌ yebánꞌ, le kwineꞌn bneꞌe ki: Xanllo Dios naꞌ, lleꞌe Xanaꞌn: “Blleꞌkeroꞌ kwitaꞌ ni, ");
INSERT INTO zpuNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","llinte lla kat gonaꞌ nniꞌt beꞌnn kaꞌ xhniaꞌo, beꞌnn kaꞌ llwie rweꞌ naꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Naꞌ nnaꞌ llayaꞌl nneze yeolol beꞌnn Israel kaꞌ, Jesús beꞌnnenꞌ betre bdaꞌre leꞌ yay cruzenꞌ, Leꞌen ba brej Diosenꞌ nakeꞌ Xanllo, naꞌ leskaꞌ Leꞌen Cristo beꞌnn brej Dios nnebieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ka bayoll ben akreꞌ diꞌll ki, da xhen gok akreꞌ, naꞌll lle akeꞌ Pedronꞌ ren beꞌnn kaꞌ non leꞌe txhen naꞌ: —¿Akxha gontoꞌ nnaꞌ chaꞌ, biꞌchaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Naꞌll lle Pedronꞌ leakeꞌ: —Lewayate ke da xhinnjenꞌ nonre naꞌ, naꞌ choare nis, nench wroeꞌn llonliraꞌllre Jesucristonꞌ. Naꞌllenꞌ yeziꞌxhen Diosenꞌ keré, naꞌll gonneꞌ reꞌ Spíritu keꞌen son yichjraꞌlldaꞌore. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Le ke reꞌn ba bchebeꞌ gonneꞌn, ke xhiꞌnnre, ke beꞌnn llaꞌa ziꞌte, naꞌ ke yeolol beꞌnn gaxh Xanllo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Naꞌ kaꞌ diꞌll zan da lloeꞌrén Pedronꞌ leakeꞌ, llaweꞌ leakeꞌ nez, lleꞌe leakeꞌ: —Bi gonre beꞌnn wen da xhinnj ki txhen, nench ke gak keré kanꞌ gak ke akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Naꞌ ka nak beꞌnn kaꞌ bxhiꞌi xtiꞌlleꞌn, blloa akeꞌ nis. Naꞌ byan akeꞌ, ke lla naꞌ badil akeꞌ ka do chonn mireꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Naꞌ bniꞌtteze bniꞌt akeꞌ, bzenay akeꞌ danꞌ llroeꞌ llsede postl kaꞌ. Naꞌ toze ka llon yichjraꞌlldaꞌo akeꞌ, naꞌ llao akeꞌ txhen, naꞌ llalwill akeꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yeolol beꞌnne llon akeꞌ yel wan kwis kanꞌ llon postl kaꞌ, da zan da yebánello llon akeꞌ, da llroeꞌ yel wak ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yeolol beꞌnn kaꞌ, ba byejleꞌ ke Jesucristonꞌ, llaꞌa akeꞌ toze, naꞌ toze non bi da de ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bayoꞌt akeꞌ no yellrio, naꞌ bi da de ke akeꞌ, naꞌ mellenꞌ bdaꞌon naꞌ, llyis akeꞌn kon ka yallje totoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Naꞌ yeo lla lldop akeꞌ yodaꞌo braonꞌ, naꞌ weꞌj bdao akeꞌ txhen rill toto akeꞌ, naꞌ nbaraz kwis bllaꞌa akeꞌ txhen bawé akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lloeꞌrao akeꞌ Diosenꞌ, naꞌ yeolol beꞌnn yell llayoꞌraꞌll kanꞌ llon akeꞌn. Naꞌ Xanllo Diosenꞌ lloneꞌ tlla tlla llren yezikre beꞌnn llonliraꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gok to lla zej Pedronꞌ ren Juan naꞌ yodaꞌo braonꞌ, ka do lladá chonne, hor naꞌ llalwill beꞌnn Israel kaꞌ Diosenꞌ yeo lla. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Naꞌ to beꞌnn bi llak saꞌa ka gorjteꞌ, yeo lla lljalek akeꞌ leꞌe lloaꞌ yodaꞌon, puert danꞌ nziꞌi Da Nbaraz. Naꞌ llbieꞌ llnnabeꞌ lmoxh rao beꞌnn kaꞌ lloꞌ yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bixha kate breꞌreꞌ Pedronꞌ ren Juan naꞌ, ka za choꞌ akeꞌ yodaꞌon, le bzete taꞌkeꞌ llnnabeꞌ lmoxh. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Naꞌll bwiachich akeꞌ leꞌe, naꞌ lle Pedronꞌ leꞌe: —Bwiake netoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Naꞌll bwieꞌ leakeꞌ, llakreꞌ chaꞌ weꞌe akeꞌ leꞌe mellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bixha Pedronꞌ lleꞌe leꞌe: —Bibi mell kiaꞌ de, ni plat ni oro, zan ka da napaꞌ gonnaꞌ rweꞌ, kone yel wak ke Jesucristo beꞌnn Nazaretenꞌ, bayas naꞌ badá. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Le beꞌxte Pedronꞌ taꞌkeꞌ chaꞌwe, le gokte bazelleꞌe, balí nieꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naꞌll bxhiꞌteꞌ naꞌ bzorao deꞌe, naꞌ byoꞌreneꞌ leakeꞌ yodaꞌon, xhiꞌteꞌ llawereꞌ lloeꞌraweꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yeolol beꞌnn yell breꞌe akreꞌ kanꞌ deꞌen, naꞌ kanꞌ lloneꞌ lloeꞌraweꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Naꞌ bayombiaꞌ akreꞌ leꞌe, nakeꞌ beꞌnnenꞌ llbeꞌ llnnab lmoxh lloaꞌ puertenꞌ nziꞌi Da Nbaraz. Naꞌll llabán akreꞌ, nnaꞌl-llej akteꞌ danꞌ breꞌe akreꞌ bayak beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naꞌ beꞌnnenꞌ bayakenꞌ, noꞌxeꞌ Pedronꞌ ren Juan naꞌ, bi llsankzeꞌ leakeꞌ. Naꞌll yeolol beꞌnn kaꞌ llaꞌa yodaꞌon, llabán akreꞌ kwis zjakdo akeꞌ ganꞌ ze Pedronꞌ ren Juan naꞌ, ren beꞌnn xhinnjenꞌ bayak naꞌ, ze akeꞌ ganꞌ ze to lchir kwit yodaꞌon da nziꞌi Lchir ke Salomón. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ka breꞌe Pedronꞌ beꞌnn zan kaꞌ, naꞌ lleꞌe leakeꞌ: —Reꞌ beꞌnn Israel, ¿bixchen llabánzere, naꞌ llwiachichre netoꞌ? ¿Llákere kone yel wak ke netoꞌn bayak beꞌnnenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios ke xozxtaꞌollo Abraham naꞌ, naꞌ Isaac naꞌ Jacob, ba beꞌe Xhiꞌnneꞌ Jesúsenꞌ doxhen yel baraꞌnnenꞌ, beꞌnnenꞌ benre rallnaꞌa koxchis, laꞌkze Pilatonꞌ gokraꞌlleꞌ yesaneꞌ Leꞌe, naꞌ reꞌ bi beꞌre latje. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Latje da bnnabre yesán Pilatonꞌ beꞌnnenꞌ nak raꞌlldaꞌo yall beꞌnnenꞌ llon da li naꞌ, bnnabzre yesaneꞌ to beꞌnn wen xhiare. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Naꞌ betre beꞌnnenꞌ nak xan yel nban naꞌ. Bixha Diosenꞌ baliseꞌ Leꞌe radj beꞌnn wat kaꞌ, naꞌ netoꞌ breꞌtoꞌ da likzenꞌ babaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Naꞌ llreꞌre beꞌnn ni, bi gok seꞌe, naꞌ nombiaꞌreꞌ, naꞌ nnaꞌ ba bayak nieꞌn kone yel wak ke Jesúsenꞌ, beꞌnnenꞌ nxenraꞌlltoꞌ naꞌ. Le danꞌ llonliraꞌlltoꞌ Jesúsenꞌ, ke len naꞌ bayoneꞌ niaꞌ beꞌnn ni, naꞌ ba llreꞌre kanꞌ bayakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Naꞌ nnaꞌ biꞌchaꞌ, nnézkzeraꞌ, reꞌ ren beꞌnn gor brao keré kaꞌ, betre Jesúsenꞌ le bi nnezyaꞌnnere bixhanꞌ benre. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Naꞌ danꞌ benre kaꞌ, gok kanꞌ bne Diosenꞌ gak, kanꞌ bdixjweꞌ beꞌnn kaꞌ beꞌe xtiꞌlleꞌn kanaꞌ, bzoj akeꞌ ke Cristonꞌ yellayraweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Naꞌ nnaꞌ lewayate ke da xhinnjenꞌ nonrenꞌ, nench yeziꞌxhen Diosenꞌ keré, naꞌllenꞌ wzoeꞌ reꞌ nbaraz. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wseꞌl Xanllo Diosenꞌ Jesúsenꞌ da yobre rao yellrionꞌ, beꞌnnenꞌ brejeꞌ kanaꞌte, nench naꞌ yednnebieꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Naꞌ dekz de yegaꞌnn Jesúsenꞌ yebánꞌ, llinte kat Diosenꞌ yeweꞌ xhnneze doxhen kanꞌ llak rao yellrionꞌ. Kanaꞌllenꞌ yedeꞌ, le kaꞌn bne beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Da Moisésenꞌ golleꞌ xozxtaꞌollo kaꞌ: “Wllin lla kat Xanllo Diosenꞌ kwejeꞌ to beꞌnn radjrenꞌ, naꞌ weꞌe xtiꞌll Diosenꞌ kanꞌ beneꞌ brejeꞌ nadaꞌ, naꞌ llayaꞌl wzenayre keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Naꞌ noteze beꞌnn chaꞌ bi wzenayeꞌ keꞌe, llayaꞌl biꞌy beꞌnnenꞌ kaꞌle, naꞌ kweyieꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Yeolol beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, bzoraozen beꞌnnenꞌ re Samuel, bdixjweꞌ akreꞌ gak danꞌ llreꞌllo llak nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Reꞌ nakre xhiꞌnn dialla ke beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ, naꞌ danꞌ goll Diosenꞌ xozxtaꞌollo kaꞌ goneꞌ, lekze naken ke reꞌ. Ka diꞌllenꞌ beꞌrenkzeꞌ xozxtaꞌollo Abraham naꞌ, kanꞌ golleꞌ leꞌe: “To xhiꞌnn dialla koꞌon zazaꞌa, goneꞌ gak laꞌy beꞌnn llaꞌa rao yellrio.” ");
INSERT INTO zpuNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ke nak Diosenꞌ ba baliseꞌ Xhiꞌnneꞌn, zgaꞌtek bseꞌleꞌ Leꞌe radj lliꞌo beꞌnn Israelenꞌ, badyenlaꞌyeꞌ lliꞌo, nench wayakbeꞌllo da xhinnj kellonꞌ, naꞌ wayátello. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nna zete Pedronꞌ ren Juan naꞌ, lloeꞌrén akeꞌ beꞌnn kaꞌ diꞌll kat bllin bxoz kaꞌ ren beꞌnnenꞌ nak xan beꞌnn kaꞌ llap yodaꞌo braonꞌ, naꞌ ren beꞌnn kaꞌ nziꞌi saduceo. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Llakllaꞌa akeꞌ danꞌ llroeꞌ postl kaꞌ beꞌnn yell kanꞌ gok babán Jesúsenꞌ, kaꞌkzenꞌ yebán yeolol beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Naꞌll beꞌx akeꞌ leakeꞌ, broꞌ akeꞌ leakeꞌ rill ya bllinte bateyó, le ba llonen ba wlleꞌ kanꞌ beꞌx akeꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Naꞌ beꞌnn zan kaꞌ bzenay xtiꞌll Diosenꞌ benliraꞌll akeꞌn, naꞌ beꞌnn byio kaꞌ ba nonliraꞌll Jesucristonꞌ, nak akeꞌ do gaꞌy mire. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bateyó badop beꞌnn wnebiaꞌ kaꞌ ganꞌ nziꞌi Jerusalén naꞌ, naꞌ beꞌnn gor brao kaꞌ, naꞌ beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","naꞌ beꞌnnenꞌ nak bxoz brao, beꞌnnenꞌ re Anás, naꞌ Caifás, naꞌ to beꞌnn re Juan, naꞌ Alejandro, naꞌ ren no biꞌch lwellj bxoz brao kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Naꞌll jaxhiꞌi akeꞌ Pedronꞌ ren Juan naꞌ, bze akeꞌ leakeꞌ kllol akeꞌn, naꞌll bnnab akreꞌ leakeꞌ: —Lennechk netoꞌ, ¿no bseꞌl rweꞌ danꞌ llonre ki? ¿No ben latj bayonre beꞌnnenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bixha llnebiaꞌteze Spíritu ke Diosenꞌ yichjraꞌlldaꞌo Pedronꞌ, lleꞌe leakeꞌ: —Reꞌ beꞌnn llnebiaꞌ rao yell, naꞌ reꞌ beꞌnn gor brao ke Israelenꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ka nak nnaꞌ llnnábere netoꞌ akre goken bayak to beꞌnn xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Llayaꞌl nnézere, naꞌ llayaꞌl nneze yeolol beꞌnn Israel, beꞌnnenꞌ ze nga, bayakeꞌ kone yel wak ke Jesús beꞌnn Nazaret naꞌ, beꞌnnenꞌ betre bdaꞌre leꞌ yay cruzenꞌ, bixha Diosenꞌ basbaneꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesúsenꞌ wsaꞌkrébelloeꞌ ka to yej, naꞌ reꞌ beꞌnn wnebiaꞌ nakre ka beꞌnn llon to yoꞌ. Reꞌ bi byoꞌraꞌllre yejenꞌ, naꞌ yejenꞌ bi byoꞌraꞌllrenꞌ, ba naken to yej da zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Gatga zo to beꞌnn gak yesrá lliꞌo rao da xhinnjenꞌ, nono noeꞌ Diosenꞌ yel wak rao yellrio, beꞌnn gak yesrá lliꞌo, zeraoze Jesucristo naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bixha beꞌnn wnebiaꞌ kaꞌ, llwia akeꞌ kanꞌ llon Pedronꞌ ren Juan naꞌ, bi lleb akeꞌ llalliꞌi akeꞌ xtiꞌll akeꞌn. Naꞌ llabán akreꞌ, le nak akeꞌ beꞌnn bi nsedtek. Naꞌll bayakbeꞌe akreꞌ leakeꞌn bdarén akeꞌ Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Naꞌ llwia akteꞌ ze beꞌnn xhinnjenꞌ bayakenꞌ kwit Pedronꞌ ren Juan naꞌ, naꞌ bi llallel akreꞌ, akre ye akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Naꞌll bchach akeꞌ leakeꞌ liaꞌre choll, chak beꞌrén lwellj akeꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Naꞌ lle lwellj akeꞌ: —¿Akre gonllo ke beꞌnn ki? Yeolol beꞌnn Jerusalén kaꞌ, nneze da yel wan naꞌ ben akeꞌn, bikzbi de nnello ke beꞌnn ki. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lete to da gonllo wcheb aklloeꞌ, nench ni ye to nollno weꞌrén aklleꞌ xtiꞌll Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Naꞌll goxh akeꞌ Pedronꞌ ren Juan naꞌ, naꞌ goll akeꞌ leakeꞌ, chras bill weꞌe akeꞌ xtiꞌll Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bixha Pedronꞌ ren Juan naꞌ, lle akeꞌ leakeꞌ: —Lennechk reꞌ chaꞌ nakllen wen wzenaytoꞌ ke reꞌ beꞌnnach, naꞌ bi wzenaytoꞌ ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bi gak sotoꞌ lli, dekz de llayaꞌl nneze beꞌnn kaꞌ da kaꞌ ba breꞌtoꞌn, naꞌ da kaꞌ ba bénetoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Naꞌll da zan da goll akeꞌ leakeꞌ, ben akreꞌ leakeꞌ znia nench lleb akeꞌ. Naꞌll basán akeꞌ leakeꞌ, le billbi llallel akreꞌ ka gon akreꞌ leakeꞌ, le yeolol beꞌnn yell lloeꞌrao akeꞌ Dios danꞌ bayak beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ka nak beꞌnnenꞌ bayakenꞌ, ba lloneꞌ ka do choa (40) iz wde. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Naꞌ Pedronꞌ ren Juan naꞌ, kate basán akeꞌ leakeꞌn, jayakeꞌ ganꞌ llaꞌa beꞌnn kaꞌ non akeꞌ txhen naꞌ, beꞌrén akeꞌ leakeꞌ diꞌll, kanꞌ goll bxoz wnebiaꞌ kaꞌ ren beꞌnn gor brao kaꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ka ben akreꞌ kaꞌ, gok akeꞌ toze, naꞌ balwill akeꞌ Diosenꞌ, bne akeꞌ: —Xantoꞌ Dios, rweꞌ benoꞌ yebá ren yellrio, naꞌ nisdaꞌo, naꞌ yeolol da de rawe naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Naꞌ rey da David naꞌ, beꞌe xtiꞌlloꞌ kanꞌ bzejnieꞌroeꞌn, bneꞌe: ¿Bixchen llach beꞌnn kaꞌ nench gon akeꞌ da xhinnj? ¿Bixchen beꞌnn kaꞌ llaꞌa yellrionꞌ llon akzeꞌ xhbab da bibi zaꞌke? ");
INSERT INTO zpuNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Naꞌ badop yeolol beꞌnn kaꞌ llnebiaꞌ rao yellrionꞌ, gok akeꞌ toze nench blliayiꞌll akeꞌ Xanllo Diosenꞌ, naꞌ blliayiꞌll akeꞌ Cristonꞌ beꞌnnenꞌ bseꞌleꞌ nnebiaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Naꞌ da li da gokte rao yell nga, rey Herodes, naꞌ Poncio Pilato, naꞌ ren beꞌnn bi nak beꞌnn Israel, gok akeꞌ txhen beꞌnn Israel kaꞌ, nench bet akeꞌ xhiꞌnnoꞌn, Jesúsenꞌ beꞌnnenꞌ nak laꞌy, naꞌ beꞌnnenꞌ brejoꞌ nnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gok kaꞌ nenchk gok da ba nwiakzoꞌ rweꞌ gak. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naꞌ nnaꞌ Xantoꞌ Dios, bwia kanꞌ llon akeꞌn llcheb akeꞌ netoꞌ, naꞌ gokrén netoꞌ beꞌnn wen llin koꞌo, nench bi llebtoꞌ weꞌtoꞌ xtiꞌlloꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Naꞌ rweꞌ wroeꞌroꞌ yel wak ke xhiꞌnnoꞌ Jesús, beꞌnnenꞌ nak laꞌyenꞌ, wayak beꞌnn llak yillweꞌ, naꞌ gak billre da yebane beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bixha ke bayoll balwill akeꞌ Diosenꞌ, bxhoꞌ naꞌ bxhiz ganꞌ llaꞌa akeꞌn, naꞌ Spíritu ke Diosenꞌ byoꞌn yichjraꞌlldaꞌo yeolol akeꞌ, naꞌ gok beꞌe akeꞌ xtiꞌll Diosenꞌ, ni ke lleb akzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Naꞌ beꞌnn zan kaꞌ llonliraꞌll Jesucristonꞌ, toze ka gok yichjraꞌlldaꞌo akeꞌ. Bi da zjadé ke akeꞌ, toze ben akeꞌn, nono bne: “Kiaꞌ da ni”, naꞌ “Kiaꞌ da naꞌ”. Yeolol bi da zjadé ke akeꞌ non akeꞌn toze. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Naꞌll postl kaꞌ, kone yel wak ke Dios, lloeꞌ akeꞌ diꞌll kanꞌ babán Jesúsenꞌ, naꞌ llonlaꞌyte Diosenꞌ yeolol akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ni to beꞌnn ren radj akeꞌn bibi byalljreꞌ, le ren beꞌnn zjadé yellrio ke akeꞌ, naꞌ no yoꞌ ke akeꞌ llayoꞌt akeꞌn, naꞌ lljwaꞌa akeꞌ mellenꞌ ganꞌ llaꞌa akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Naꞌ ben akeꞌn rallnaꞌa postl kaꞌ, naꞌ leakeꞌ llyis akeꞌn kon ka yallje toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ka ben to beꞌnn Chipre beꞌnn re José, nakeꞌ xhiꞌnn dialla ke Leví, naꞌ postl kaꞌ bsiꞌi akeꞌ leꞌe Bernabé, lleꞌnen nen Beꞌnn Llayoeꞌxhen. ");
INSERT INTO zpuNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Leꞌe de to yellrio keꞌe, naꞌ bayoꞌteꞌn, naꞌ beneꞌ mellenꞌ rallnaꞌa postl kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Naꞌ bzo to beꞌnn re Ananías, naꞌ noꞌr keꞌe re Safira, naꞌ bayoꞌt akeꞌ to yellrio da de ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Naꞌ ka jwaꞌa Ananíasenꞌ mellenꞌ rao naꞌa postl kaꞌ, lleꞌe leakeꞌ: —Doxhenkzen naꞌ noꞌxaꞌ. Renchaꞌ ba beꞌe akeꞌ diꞌll wkwaꞌch akeꞌ raꞌten. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Naꞌll Pedronꞌ lleꞌe leꞌe: —Ananías, ¿bixchen beꞌzoꞌ latj byoꞌ daxiꞌon yichjraꞌlldaꞌon, naꞌ ziyeꞌo Spíritu ke Diosenꞌ ke nak bkwaꞌchoꞌ mell ke yellrionꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Kere yellrio koꞌkzoꞌn? Leskaꞌ rweꞌkzoꞌ bxhiꞌo mellenꞌ bayoꞌtoꞌn naꞌ. Da xhinnjenꞌ llonoꞌ ziyeꞌo. Kere beꞌnnachenꞌ ziyeꞌo, kwinkze Diosenꞌ ziyeꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ka bayoll bene Ananíasenꞌ kanꞌ goll Pedronꞌ leꞌen, to byalzeꞌ gotteꞌ. Yeolol beꞌnn kaꞌ bene kanꞌ goken, blleb akeꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Naꞌ bzollaꞌa bal beꞌnn llabán kaꞌ, babej akeꞌ leꞌe, naꞌ jakwaꞌch akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bixha gok ka chonn hor, bllin Safira noꞌr ke da Ananíasenꞌ, naꞌ bi nnezreꞌ chaꞌ bi ba gok. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Naꞌll lle Pedronꞌ leꞌe: —Bnechk nadaꞌ, ¿da linꞌ bayoꞌtre yellrionꞌ to kaꞌte? Naꞌll bne Safiranꞌ: —Awaꞌ, to katenꞌ bayoꞌttoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Naꞌll lle Pedronꞌ leꞌe: —¿Bixchen gokoꞌ toze ren xhyiꞌon, naꞌ gokraꞌllre siyeꞌre Spíritu ke Diosenꞌ? Lloaꞌ yoꞌ naꞌ, ba ze beꞌnn kaꞌ jakwaꞌch xhyiꞌon, naꞌ leskaꞌ lljakwaꞌch akeꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ka bayoll bne Pedronꞌ kaꞌ, le byalteꞌ xhniaꞌ Pedronꞌ gotteꞌ. Ka bayoꞌ beꞌnn kaꞌ jakwaꞌch Ananíasenꞌ, breꞌe akreꞌ noꞌrenꞌ ba deꞌe goteꞌ, naꞌ blen akeꞌ leꞌe, naꞌ jakwaꞌch akeꞌ leꞌe kwit xhyiweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yeolol beꞌnn kaꞌ llonliraꞌll Cristonꞌ, blleb akeꞌ ka breꞌe akreꞌ kanꞌ goken, naꞌ nollre beꞌnn yobre leskaꞌ blleb akeꞌ kwis ka ben akreꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Naꞌ postl kaꞌ da zan da yebánello llon akeꞌ, naꞌ llroeꞌ akeꞌ yel wak ke Diosenꞌ. Naꞌ yeolol akeꞌ lladopteze lladop akeꞌ lchir yodaꞌo braonꞌ, danꞌ nziꞌi Lchir ke Salomón. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yeolol beꞌnn yell llayoꞌraꞌll kanꞌ llon akeꞌn, naꞌ bdap akeꞌ leakeꞌ baraꞌnne, laꞌkze lleb akeꞌ gon akeꞌ leakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Beꞌnn kaꞌ llxenraꞌll Xanllonꞌ, byan akeꞌ ka beꞌnn byio ren noꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Naꞌ to llbej akeꞌ beꞌnn weꞌe ke akeꞌ kaꞌ, llniꞌt akeꞌ leakeꞌ tnez. Naꞌ llxoa akeꞌ leakeꞌ no rao daꞌ, nench kat te Pedronꞌ, laꞌ bxen keꞌe naz llel beꞌnn weꞌe kaꞌ, naꞌ wayak akseꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Leskaꞌ beꞌnn kaꞌ zjalliꞌ awlloze lljakeꞌ Jerusalén naꞌ, lljwaꞌa akeꞌ no beꞌnn llak yillweꞌ, no beꞌnn yoꞌ daxiꞌo, yeolol akeꞌ llayak. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Naꞌll beꞌnnenꞌ llnebiaꞌ bxoz kaꞌ, ren beꞌnn kaꞌ llon txhen beꞌnn kaꞌ nziꞌi saduceo, gok akreꞌ postl kaꞌ ziꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Naꞌ bzap akeꞌ leakeꞌ broꞌ akeꞌ leakeꞌ rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Naꞌ to angl ke Xanllo Dios bllineꞌ tlleꞌle, bsarjeꞌ rill yanꞌ, naꞌ babejeꞌ postl kaꞌ, lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Lechej yodaꞌo braonꞌ da yobre, naꞌ lelljeꞌrén beꞌnn yell xtiꞌll Dios da nsaꞌa yel nban naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ka bayoll ben akreꞌ kaꞌ, kate byeniꞌ, byej akeꞌ yodaꞌo braonꞌ, jazejnieꞌ akreꞌ beꞌnn kaꞌ xtiꞌll Diosenꞌ. Bixha beꞌnnenꞌ nak bxoz brao, ren beꞌnn kaꞌ nakeꞌ txhen naꞌ, batop akeꞌ beꞌnn gor brao kaꞌ llnebiaꞌ beꞌnn Israel kaꞌ, naꞌll bseꞌl akeꞌ beꞌnn ak lljaxhiꞌi akeꞌ postl kaꞌ, ganꞌ niꞌt akeꞌ rill yanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ka bllin policía kaꞌ lloaꞌ rill yanꞌ, ker no beꞌnn kaꞌ da nne. Naꞌ zayej akeꞌ jadixjweꞌ akreꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","lle akeꞌ beꞌnn wnebiaꞌ kaꞌ: —Neyjchochte rill yanꞌ, naꞌ llaꞌa akteꞌ llap akeꞌn, bixha ke bsarjtoꞌn naꞌ, ker no beꞌnn kaꞌ da nne. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Beꞌnnenꞌ nak bxoz brao, naꞌ beꞌnnenꞌ nak xan beꞌnn kaꞌ llap yodaꞌon, naꞌ bxoz wnebiaꞌ kaꞌ, ka ben akreꞌ kaꞌ, llayón akeꞌ xhbab akre wayoll ke danꞌ llaken. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Bixha le bllinte to beꞌnn, lleꞌe leakeꞌ: —Beꞌnn kaꞌ broꞌre rill yanꞌ, ba ze akteꞌ da yobre yodaꞌon llroeꞌ akreꞌ beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Naꞌll beꞌnn kaꞌ llap yodaꞌon ren xan akeꞌ naꞌ, jakeꞌ jaxhiꞌi akeꞌ leakeꞌ, naꞌ kone diꞌll wen zancheꞌe akeꞌ leakeꞌ, le lleb akeꞌ wchekw beꞌnn yell kaꞌ leakeꞌ yej. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ka ballín akeꞌ rao beꞌnn wnebiaꞌ kaꞌ, naꞌll beꞌnnenꞌ nak bxoz brao lleꞌe postl kaꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Kere golltetoꞌ reꞌ, bill wroeꞌre xtiꞌll beꞌnnenꞌ? Naꞌ yezikre llonre, doxhen Jerusalén naꞌ, ba bzénere xtiꞌlleꞌn, naꞌ lltóbere netoꞌ bettoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Naꞌll Pedronꞌ ren postl kaꞌ yelaꞌ, lle akeꞌ beꞌnn kaꞌ: —Nakllen lliarao wzenaytoꞌ ke Diosenꞌ kerke ke beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dios ke xozxtaꞌollo kaꞌ baliseꞌ Jesúsenꞌ, beꞌnnenꞌ betre bdaꞌre leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Naꞌ Diosenꞌ ba beꞌe Jesúsenꞌ doxhen yel baraꞌnn keꞌen, naꞌ ba bazieꞌ Leꞌe raweꞌ, nench nnebieꞌ, naꞌ yesreꞌe lliꞌo beꞌnn Israel. Naꞌ kone Leꞌen yeziꞌxhen Diosenꞌ ke da xhinnjenꞌ benllo, chaꞌ lliꞌo wayátello. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Netoꞌ nnézetoꞌ kanꞌ ben Diosenꞌ, naꞌ lloeꞌtoꞌ diꞌll keꞌen, naꞌ lekze Spíritu ke Diosenꞌ lloeꞌn diꞌll lo raꞌlldaꞌotoꞌn, le Diosenꞌ bseꞌleꞌ Spíritu keꞌen lo yichjraꞌlldaꞌo beꞌnn llzenay keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ka llen akreꞌ kanꞌ ne postl kaꞌ, to llakllaꞌa akeꞌ kwis, to lleꞌn akreꞌ got akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Radj beꞌnn kaꞌ llaꞌa naꞌ, ren to beꞌnn fariseo re Gamaliel, naꞌ llroeꞌ llsedreꞌ ley danꞌ bzoj da Moisés, naꞌ le llap beꞌnn kaꞌ leꞌe baraꞌnne. Bzolleꞌe naꞌ golleꞌ beꞌnn kaꞌ, bachach akeꞌ postl kaꞌ choll koꞌllre. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Naꞌ lleꞌe leakeꞌ: —Reꞌ, beꞌnn Israel, lewiachek akre gonre ke beꞌnn ki. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lelljadinraꞌll ka ben beꞌnnenꞌ re Teudas kanaꞌ, bneꞌe nakeꞌ to beꞌnn zaꞌke, naꞌ tap gayoa (400) beꞌnn bzenay keꞌe. Bixha kat bet akseꞌ leꞌe, naꞌll beꞌnn kaꞌ bnao leꞌen bayaslas akeꞌ, naꞌ kaꞌ gok barán akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bixha gok da yobre blloj beꞌnnenꞌ re Judas, beꞌnn Galilea, kanꞌ bllia beꞌnn yiche, naꞌ beꞌnn zan bnao leꞌe, leskaꞌ goteꞌ, naꞌ bayaslas beꞌnn kaꞌ bnao leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Naꞌllenꞌ ni llniaꞌ reꞌ, waljé beꞌnn ki, bibi gon akereꞌ. Chaꞌ danꞌ llon akeꞌn naken ke lwellj beꞌnnachllo, to wrazzen yeranen. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Zan chaꞌ naken ke Dios, kere da soere yelanren, lewiayaꞌnn ke gonzre tilrenre Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bayoꞌraꞌll beꞌnn wnebiaꞌ kaꞌ kanꞌ bne Gamalielenꞌ. Bde naꞌ, goxh akeꞌ postl kaꞌ, naꞌ bdintat akeꞌ leakeꞌ, naꞌll bllon akeꞌ bill wsed akreꞌ beꞌnn xtiꞌll Jesucristonꞌ, naꞌll basán akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ka balloj akeꞌ ganꞌ llaꞌa beꞌnn wnebiaꞌ kaꞌ, llawé akreꞌ kwis, le nnez akreꞌ Diosenꞌ lloeꞌkzeꞌ latj llallayrao akeꞌ, ni ke Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Naꞌ yeo lla, do ga zo yodaꞌo, naꞌ do lo yoꞌ rill akeꞌ, llroeꞌ akreꞌ beꞌnn xtiꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka gok ka lla naꞌ, llan beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ beꞌnn kaꞌ nne diꞌll griego, bnne akeꞌ ke beꞌnn kaꞌ nne diꞌll Hebreo. Ne akeꞌ noꞌr wazeb ke akeꞌ kaꞌ, bi ziꞌi akeꞌ da lleꞌj llao akeꞌ ke to da llayaꞌl siꞌi akeꞌ tlla tlla. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Naꞌll beꞌnn chllinn kaꞌ (12), batop akeꞌ yeolol beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ lle akeꞌ leakeꞌ: —Bi naken wen wsanraꞌlltoꞌ xtiꞌll Diosenꞌ, naꞌ setoꞌ chislastoꞌ da yeꞌj da gao beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Naꞌ nnaꞌ beꞌnn biꞌche, lekwej gall beꞌnn lwelljre, beꞌnn nak beꞌnn siꞌn, beꞌnn llzenay ke Dios, naꞌ beꞌnn yoꞌ Spíritu ke Diosenꞌ yichjraꞌlldaꞌo akeꞌ, naꞌll gak rallnaꞌa akeꞌ chis akeꞌ danꞌ gao beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naꞌ netoꞌ weꞌlaꞌll-lltoꞌ yelwilltoꞌ Dios, naꞌ wroeꞌtoꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yeolol beꞌnn kaꞌ bayoꞌraꞌll kanꞌ bne postl kaꞌ, naꞌ brej akeꞌ to beꞌnn re Esteban, beꞌnn le nxenraꞌll Dios, naꞌ yoꞌyaꞌnn Spíritu ke Diosenꞌ yichjraꞌlldaꞌweꞌ. Naꞌ brej akeꞌ ye to beꞌnn re Felipe, naꞌ Prócoro, naꞌ Nicanor, naꞌ Timón, naꞌ Parmenas, naꞌll Nicolás beꞌnn yellenꞌ re Antioquía beneꞌ txhen ren beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Naꞌ jwaꞌa akeꞌ beꞌnn ki rao postl kaꞌ, naꞌ bxoa taꞌk akeꞌn yichj akeꞌ, naꞌ balwill akeꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Beꞌnn zan llnnez akreꞌ xtiꞌll Diosenꞌ, naꞌ Jerusalén naꞌ, zejze llan beꞌnn kaꞌ llxenraꞌll Jesucristonꞌ, leskaꞌ zan bxoz kaꞌ, ba llxenraꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Naꞌ beꞌnnenꞌ re Esteban, napyaꞌnneꞌ yel wak ke Dios, naꞌ Diosenꞌ llakreneꞌ leꞌe lloneꞌ da llabane beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bixha gok to lla, txhonnj beꞌnn kaꞌ lladop ganꞌ zo yodaꞌo danꞌ nziꞌi Yoꞌ ke Beꞌnn Bill Zo Xan, naꞌ ren beꞌnn Israel zayaꞌk yell kaꞌ nziꞌi Cirene, naꞌ Alejandría, naꞌ do ganꞌ nziꞌi Cilicia, naꞌ ganꞌ nziꞌi Asia, naꞌ bzorao llaꞌdyiꞌ akeꞌ Esteban. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Naꞌ bi llzoe akreꞌ yelliꞌi akeꞌ xtiꞌll Esteban, le Spíritu ke Diosenꞌ beꞌn yel siꞌn keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Naꞌ beꞌnn kaꞌ bkoꞌyel akreꞌ bal beꞌnn, nench btob akreꞌ, dá Esteban llnneꞌe ke da Moisés, naꞌ leskaꞌ llnneꞌe ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Naꞌ bta bnne akeꞌ beꞌnn yell, leskaꞌ bta bnne akeꞌ beꞌnn gor brao ke yell Israelenꞌ ren beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, naꞌ bzap akeꞌ Esteban, naꞌ jwaꞌa akeꞌ leꞌe rao koxchis kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Leskaꞌ bdirj akeꞌ beꞌnn beꞌe diꞌll wenraꞌll, nench bne akeꞌ: —Beꞌnn ni, dateze deꞌe lloeꞌ diꞌlle, naꞌ llnneꞌe ke yodaꞌo braonꞌ, naꞌ rente ke ley ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Leskaꞌ bénetoꞌ neꞌe, Jesús beꞌnn Nazaretenꞌ yechinnjeꞌ yodaꞌo kellonꞌ, naꞌ wacheꞌe danꞌ bkwaꞌnn da Moisésenꞌ gonllo. ");
INSERT INTO zpuNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Naꞌll koxchis kaꞌ, naꞌ ren beꞌnn kaꞌ zjalliꞌ ren leakeꞌn, ka bwia akeꞌ rao Esteban, naꞌ breꞌe akreꞌ kaꞌkze rao angl ke Dios nak raweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Naꞌll beꞌnnenꞌ nak bxoz braonꞌ, lleꞌe Esteban: —¿Renne beꞌnn ki kanꞌ ne akeꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Naꞌll bne Esteban: —Reꞌ beꞌnn gor xa, naꞌ reꞌ beꞌnn biꞌchaꞌ, le wzenay kiaꞌ choll. Xanllo Dios beꞌnnenꞌ nak le zerao beꞌnn zaꞌk, broeꞌraweꞌ da xozxtaꞌollo Abraham naꞌ, kanꞌ zoeꞌ ganꞌ nziꞌi Mesopotamia, ka za lljasoeꞌ yellenꞌ nziꞌi Harán. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Goll Diosenꞌ leꞌe: “Blloj yell koꞌon, bsanraꞌll biꞌch lwelljoꞌ, naꞌ chejoꞌ ga de to yellrio da wroeꞌraꞌ rweꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kaꞌ goken bllojeꞌ bkwaꞌnneꞌ yellrio ganꞌ nbane beꞌnn Caldeo kaꞌ, naꞌ jasoeꞌ Harán. Harán naꞌ got xeꞌe. Bde got xeꞌe naꞌn, badwaꞌa Diosenꞌ leꞌe ganꞌ llaꞌllo ganni nnaꞌ lla. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bixha Diosenꞌ bi gokraꞌlleꞌ gak yellrionꞌ keꞌe kate naꞌ, ni raꞌten bi gok keꞌe, zan bchebeꞌ weꞌen xhiꞌnn dialla keꞌe kate ba goteꞌ, laꞌkze nono xhiꞌnneꞌ nna so, katenꞌ golleꞌ leꞌe kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naꞌ goll Diosenꞌ leꞌe: “Wllin lla kat lljachaꞌa xhiꞌnn dialla koꞌo kaꞌ to yell ziꞌte, ga gak akeꞌ beꞌnn wen llin ke beꞌnn kaꞌ ganꞌ lljasó akeꞌ naꞌ, wsaꞌkziꞌ akeꞌ leakeꞌ tap gayoa (400) iz.” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Naꞌ leskaꞌ goll Diosenꞌ leꞌe: “Nadaꞌ wsaꞌkziaꞌ yellenꞌ gone leakeꞌ kaꞌ, naꞌll wallach akeꞌ, naꞌ wayed akeꞌ ganni nench weꞌrao akeꞌ nadaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Diosenꞌ beꞌreneꞌ Abraham naꞌ diꞌlle, ke yeolol no xhiꞌnn dialla keꞌe bi byio za so, so akbeꞌ sen danꞌ nziꞌi circuncisión nench gak akbeꞌ txhen rao yell ke Diosenꞌ. Naꞌ ka gok gorj xhiꞌnneꞌ Isaac, ka gókebeꞌ xoꞌn lla, bzoebeꞌ sen, leskaꞌ ben Jacobenꞌ ke xhiꞌnneꞌ kaꞌ, beꞌnn chllinn kaꞌ (12) gok xozxtaꞌollo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Bixha beꞌnn kaꞌ gok xozxtaꞌollo, baxhéꞌ akreꞌ to biꞌch akeꞌ beꞌnnenꞌ le José, naꞌ beꞌt akeꞌ leꞌe, bxhiꞌi beꞌnn Egipto kaꞌ leꞌe, bixha Diosenꞌ zerenkzeꞌ Josénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Diosenꞌ gokreneꞌ leꞌe laꞌkze ballayraweꞌ, naꞌ beꞌe leꞌe yel siꞌn. Naꞌ ka bllin lla byej Josénꞌ rao Faraón naꞌ, beꞌnnenꞌ llnebiaꞌ beꞌnn Egipto kaꞌ, byoꞌraꞌll beꞌnnenꞌ leꞌe, naꞌ beneꞌ rallneꞌe doxhen Egiptonꞌ. Naꞌ gok rallnaꞌa Josénꞌ rente yoꞌ ganꞌ llia beꞌnn wnebiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Kanaꞌ gokse to win doxhen Egiptonꞌ ren Canaán naꞌ, naꞌ ballayrao beꞌnn kaꞌ kwis, ren xozxtaꞌollo kaꞌ, byallj da gao akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ka bene Jacobenꞌ, Egipto naꞌ de trigo, naꞌ bseꞌleꞌ xozxtaꞌollo kaꞌ jaxiꞌi akeꞌn, ka gok byej akeꞌ da nelle. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka zjaklleꞌ da wllop ras naꞌ, broeꞌrao Josénꞌ biꞌche kaꞌ. Kanaꞌll bnneze Faraón naꞌ, no beꞌnn kaꞌ nak dialla Josénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Naꞌ baseꞌl Josénꞌ leakeꞌ, jaxhiꞌi akeꞌ xa akeꞌn, naꞌ yeolol biꞌch lwelljeꞌ kaꞌ, naꞌ nak wyon chiꞌno akeꞌ (75), to katenꞌ bllin Egiptonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kaꞌ goken bllin Jacobenꞌ Egiptonꞌ, gannaꞌ goteꞌ; leskaꞌ Egipto naꞌ, got xozxtaꞌollo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bde got akeꞌ naꞌ, jakwaꞌch akteꞌ leakeꞌ yell ganꞌ nziꞌi Siquem ganꞌ zo ba danꞌ weꞌo Abraham naꞌ, ke xhiꞌnn beꞌnnenꞌ le Hamor beꞌnn Siquem naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Bixha ka ba zo llin lla weꞌe Diosenꞌ leakeꞌ yellrio danꞌ bchebeꞌ ren da Abraham naꞌ, ba bzorao llan no xhiꞌnn dialla da Abraham naꞌ, rall beꞌnn Egipto kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naꞌ bzorao llnebiaꞌ to beꞌnn yobre, beꞌnn bi bnnezreꞌ chaꞌ bi da wen ben da Josénꞌ rao ralleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Beꞌnn wnebiaꞌn bayirjlaꞌlleꞌ ka beneꞌ nench bsaꞌkzieꞌ xozxtaꞌollo kaꞌ, naꞌ golleꞌ leakeꞌ lljachoꞌnn akeꞌ bdaꞌo ke akeꞌ kaꞌ za llarje, nench bill chan akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kanꞌ llak kaꞌ, gorj da Moisésenꞌ, naꞌ byazraꞌll Diosenꞌ leꞌe, blliꞌweꞌ chonn beꞌo ganꞌ zo xeꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bllin lla bill bzoe akreꞌ wkwaꞌch akeꞌ bdaꞌon, naꞌll bsanraꞌll akebeꞌ. Kat ballelkze noꞌrenꞌ nak xhiꞌnn beꞌnn wnebiaꞌ naꞌ lebeꞌ, naꞌ bazieꞌbeꞌ bénebeꞌ ka xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kaꞌ gok bsed da Moisésenꞌ yel siꞌn ke beꞌnn Egipto kaꞌ, naꞌ gok beꞌe diꞌll da zaꞌke, naꞌll leskaꞌ beneꞌ da zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ka goke Moisésenꞌ choa (40) iz, bzo lo raꞌlldaꞌweꞌn lljaraꞌnneꞌ beꞌnn wrall keꞌe, beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ka bllineꞌ ganꞌ llaꞌa akeꞌn, jadiꞌreꞌ to beꞌnn Egiptonꞌ lloneꞌ ziꞌ ke to beꞌnn wrall keꞌen, naꞌ gokreneꞌ beꞌnn wrall keꞌen, betteꞌ beꞌnn Egiptonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisésenꞌ llakreꞌ wayakbeꞌe beꞌnn wrall keꞌe kaꞌ, gonrén Diosenꞌ leꞌe llin yechacheꞌ leakeꞌ Egiptonꞌ, naꞌ bi bayakbeꞌe beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bixha bateyore breꞌreꞌ chop beꞌnn Israel kaꞌ dil akeꞌ, naꞌ byejeꞌ jaleꞌe leakeꞌ, lleꞌe leakeꞌ: “¿Kere llopteze beꞌnn Israel reꞌ, bixchen dilzre?” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Naꞌ beꞌnnenꞌ ze lloneꞌ ziꞌ ke lwelljeꞌn, blliꞌyeꞌ Moisésenꞌ, naꞌ lleꞌe leꞌe: “¿Nonꞌ bseꞌl rweꞌ nench yedyenoꞌ yel koxchis ketoꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Chaꞌ leskaꞌ lleꞌnroꞌ gotoꞌ nadaꞌ kanꞌ benoꞌ betoꞌ beꞌnn Egiptonꞌ neje?” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ka bene Moisésenꞌ kanꞌ bne beꞌnnenꞌ, le bllebeꞌ naꞌ bxhonnjeꞌ, jasoteꞌ to yell ziꞌte nziꞌi Madián. Gannaꞌ bchayneꞌe, naꞌ bzo chop xhiꞌnneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ka gok choa iz zoeꞌ Madián naꞌ, broeꞌrao to angl ke Diosenꞌ leꞌe ganꞌ nak latj dach, yoeꞌ to lo xhis yeꞌche da llaꞌlnninnen ganꞌ zo yaꞌ nziꞌi Sinaí. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ka breꞌe Moisésenꞌ kanꞌ llaken, llabanreꞌ kwis, naꞌ jabiꞌyeꞌ jawieꞌ, naꞌ bne Diosenꞌ, lleꞌe leꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nadaꞌ nakaꞌ Dios ke xozxtaꞌo Abraham, naꞌ Isaac, naꞌ Jacob.” Moisésenꞌ bllebeꞌ, naꞌ bi bayaxhjreꞌ lljawieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Naꞌll goll Xanllo Diosenꞌ leꞌe: “Golje xheroꞌn le nak laꞌy latj ganꞌ zeꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ba breꞌraꞌ kanꞌ llsaꞌkziꞌ akeꞌ beꞌnn kaꞌ nak yell kiaꞌn llaꞌa Egipto naꞌ, ba benraꞌ kanꞌ llosiaꞌ akeꞌn, naꞌ ba bllin lla yesrá akeꞌ. Nnaꞌ wseꞌlaꞌ rweꞌ Egiptonꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Moisés, beꞌnnenꞌ bi byoꞌraꞌll beꞌnn Israel kaꞌ da nell, ka nak goll akeꞌ leꞌe: “¿No bseꞌl rweꞌ nench yedyenoꞌ yel koxchis ketoꞌ?” Leꞌe baseꞌl Diosenꞌ da yobre nench nnebieꞌ, naꞌ yechacheꞌ leakeꞌ lo naꞌ beꞌnn Egipto kaꞌ, le kaꞌn goll angl ke Diosenꞌ leꞌe kanꞌ bneꞌe lo yay yeꞌchenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Naꞌ bachacheꞌ leakeꞌ, broeꞌreꞌ yel wak ke Diosenꞌ, beneꞌ da yebane beꞌnn Egipto kaꞌ, leskaꞌ beneꞌ ka bllineꞌ lloaꞌ Nisdaꞌo Xhnaꞌn, naꞌll ganꞌ bllaꞌa akeꞌ ganꞌ nak latj dachenꞌ, kaꞌ gokte choa iz. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Naꞌ da Moisésenꞌ golleꞌ xozxtaꞌollo kaꞌ: “Radjre beꞌnn Israel, kwej Xanllo Diosenꞌ to beꞌnn weꞌe xtiꞌlleꞌn, kanꞌ beneꞌ brejeꞌ nadaꞌ, llayaꞌl wzenayre keꞌe.” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisésenꞌ bzoreneꞌ xozxtaꞌollo kaꞌ ganꞌ nak latj dachenꞌ, naꞌ beꞌrén angl ke Diosenꞌ leꞌe diꞌll, ganꞌ zo yaꞌ da nziꞌi Sinaí, beꞌe leꞌe diꞌll da nsaꞌa yel nban, len naꞌ broeꞌreꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Bixha xozxtaꞌollo kaꞌ, bi bzenay akeꞌ ke da Moisésenꞌ, bi ben akeꞌ leꞌe bare, naꞌ gokraꞌll akeꞌ wayej akeꞌ Egiptonꞌ da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Naꞌ goll akeꞌ da Aarón naꞌ, beꞌnn biꞌch da Moisésenꞌ: “Ben to dios kello, beꞌnn wabiarao raollo tnezenꞌ. Ka nak Moisésenꞌ beꞌnnenꞌ babej lliꞌo Egiptonꞌ, nono nneze binꞌ ba gok keꞌe.” ");
INSERT INTO zpuNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Naꞌ ben akeꞌ to bell daꞌo, naꞌ bet akeꞌ no bayiꞌx, ben akeꞌ lnni, beꞌrao akeꞌ danꞌ bayoll ben ren niaꞌnaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Diosenꞌ bsanraꞌlleꞌ leakeꞌ, beꞌe latj beꞌrao akeꞌ no will, beꞌo naꞌ berj kaꞌ llia leꞌ yebá. Leꞌ yich danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ naꞌ, llian ganꞌ bne Diosenꞌ ki: Reꞌ beꞌnn Israel, ni ke beꞌraozre nadaꞌ, kanꞌ betre bayiꞌx kaꞌ, kanꞌ bzore latj dachenꞌ rao choa iz. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Da yobre beꞌraore, biaꞌre lwaꞌa lsaꞌkenꞌ nziꞌi Moloc, naꞌ biaꞌre berj ke lwaꞌa lsaꞌken nziꞌi Refán dios ben kwinre. Ke len wachachaꞌ reꞌ ganꞌ llaꞌrenꞌ, naꞌ wseꞌlaꞌ reꞌ ziꞌt ganꞌ nziꞌi Babilonia. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Chak bllaꞌa xozxtaꞌollo kaꞌ ganꞌ nak latj dachenꞌ, ben akeꞌ to yodaꞌo da lladobte ga broꞌchaꞌo akeꞌ bray de yej, ganꞌ llia ley ke Diosenꞌ. Diosenꞌ broeꞌreꞌ da Moisésenꞌ doxhen kanꞌ beneꞌ yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Xozxtaꞌollo kaꞌ bgaꞌnnrén akeꞌ yodaꞌon. Kanꞌ bzo Josuénꞌ, Diosenꞌ bchacheꞌ beꞌnn kaꞌ llaꞌa yell kaꞌ, nench gok blan akeꞌ yellrio danꞌ bchebeꞌ weꞌe leakeꞌ. Bsaꞌrén akteꞌ yodaꞌo danꞌ lladobte, ka nak bllin akeꞌ rao yellrionꞌ, naꞌ kaꞌ bdap akeꞌn bllinte bzo rey Davidenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Diosenꞌ byoꞌraꞌlleꞌ kanꞌ ben Davidenꞌ, Davidenꞌ gokraꞌlleꞌ goneꞌ yodaꞌo ke Diosenꞌ, beꞌnnenꞌ beꞌrao Jacobenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bixha xhiꞌnneꞌ Salomón naꞌ, beneꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Laꞌkze nnézello Diosenꞌ ker beꞌnn zo yodaꞌo da llon beꞌnnachenꞌ, le kanꞌ bzoj beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nadaꞌ zoaꞌ yebá, naꞌ nzoate niaꞌ rao yellrionꞌ. ¿Akxhanꞌ nezre gonre to yoꞌ ga soaꞌ? ¿Akxhanꞌ nezre gonre to ga waziꞌraꞌllaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Kere nadaꞌ benaꞌ yeolol da zjadé rao yellrionꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Naꞌ nnaꞌ reꞌ, leskaꞌ llonre war yichjraꞌlldaꞌorenꞌ, bi llzenayre ke Spíritu ke Diosenꞌ, doxhen kanꞌ ben xozxtaꞌore kaꞌ, kaꞌn llonre. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Xozxtaꞌore kaꞌ bsaꞌkziꞌ akeꞌ yeolol beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. Bet akeꞌ beꞌnn kaꞌ bdixjweꞌ, wllin lla yed beꞌnnenꞌ zerao nak beꞌnn wen. Naꞌ Leꞌen ba bedeꞌ nnaꞌ, naꞌ reꞌ benreꞌ rallnaꞌa beꞌnn kaꞌ bwie Leꞌe, naꞌ kone kaꞌ betreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Naꞌ reꞌ nnéztere ley ke Dios danꞌ bseꞌleꞌ kone angl kaꞌ, naꞌ bi bzenayre ke. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ka llene beꞌnn kaꞌ kanꞌ ne Esteban, to llrok akeꞌ leꞌe, naꞌ llaoxoxj lay akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Naꞌ Esteban yoꞌyaꞌnn Spíritu ke Diosenꞌ yichjraꞌlldaꞌweꞌ, ka blis raweꞌn bwieꞌ yebánꞌ, naꞌ breꞌreꞌ beniꞌ ke Diosenꞌ, naꞌ breꞌreꞌ Jesucristonꞌ zeꞌe kwit Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Naꞌll bneꞌe: —Nnaꞌstek llreꞌraꞌ nyarj yebánꞌ, naꞌ ze Jesúsenꞌ Beꞌnnenꞌ Gorj Radj Beꞌnnach, zeꞌe kwit Diosenꞌ ganꞌ llnebieꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ka bayoll bne Esteban kaꞌ, bsejdo nay akeꞌ besiaꞌ akeꞌ, yeololeꞌ zejdo, byechj akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Naꞌ brej akeꞌ leꞌe yell, bchekw akeꞌ leꞌe yej. Naꞌll beꞌnn kaꞌ bchekw leꞌe yejenꞌ, blechj xha akeꞌn, naꞌ bniꞌt akeꞌn xhniaꞌ to beꞌnn llabán re Saulo. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ka llaral llchekw akeꞌ Esteban yejenꞌ, balwilleꞌ Diosenꞌ bneꞌe: —Xa Jesús, baziꞌchga spíritu kiaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Naꞌll bcheꞌk xhibeꞌ, bneꞌe zillj: —Xanaꞌ, bi lljadinraꞌllchgoꞌ da xhinnjenꞌ llon akeꞌn. Bayoll bneꞌe kaꞌ goteꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Beꞌnnenꞌ re Saulo byazraꞌlleꞌ kanꞌ ben akeꞌ bet akeꞌ Esteban. Naꞌll beꞌnn kaꞌ llnebiaꞌn, bzorao llsaꞌkziꞌ akeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ llaꞌa Jerusalén naꞌ. Beꞌnn zan bxhonnje jakeꞌ do ganꞌ nziꞌi Judea, naꞌ Samaria, naꞌ postl kaꞌ goꞌy akseꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bal beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, jakwaꞌch akeꞌ Esteban, naꞌ bllell akeꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Naꞌ Saulonꞌ le llwiereꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ lloeꞌ toto yoꞌ llxhobxexjeꞌ no beꞌnn byio, no noꞌre, llgoeꞌ leakeꞌ rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Beꞌnn kaꞌ bxhonnjenꞌ, toto yell ga ll-llin akeꞌ llyixjweꞌ aktereꞌ beꞌnn kaꞌ, kanꞌ nak Diꞌll Wen ke Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Beꞌnnenꞌ re Felipe bllineꞌ yellenꞌ re Samaria, naꞌ bzorao llroeꞌreꞌ beꞌnn kaꞌ xtiꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Beꞌnn Samaria kaꞌ, lldop akeꞌ llzenay akyaꞌnneꞌ kanꞌ ne Felipenꞌ, naꞌ llwia akteꞌ yel wak kaꞌ lloneꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Le beꞌnn zan beꞌnn yoꞌ daxiꞌo llayak akeꞌ, llalloj daxiꞌo kaꞌ llosiaꞌ akeꞌn, naꞌ beꞌnn zan beꞌnn nat chlaꞌ niaꞌnaꞌa akeꞌ, naꞌ beꞌnn xhinnj beꞌnn bi llak saꞌa, llayak akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Naꞌ beꞌnn Samaria kaꞌ, llawé akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Leskaꞌ Samaria naꞌ, zo to beꞌnn wallaꞌa re Simón, batnaꞌte ziyeꞌe leakeꞌ kone yel wallaꞌa naꞌ, lleꞌe leakeꞌ nakeꞌ to beꞌnn zaꞌke. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yeolol akeꞌ bzenay keꞌe, ka beꞌnn gor rente xkwiꞌde, naꞌ ne akeꞌ: —Beꞌnn ni napeꞌ yel wak xhen ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Naꞌ llaꞌa akeꞌ llzenay akeꞌ, naꞌ llwia akteꞌ ka yel wallaꞌan lloneꞌ naꞌ, le kone len naꞌ, ba bxhiyeꞌe leakeꞌ scha. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bixha ka bllin Felipenꞌ llyixjweꞌreꞌ Diꞌll Wen ke Jesucristonꞌ, llroeꞌreꞌ leakeꞌ kanꞌ lleꞌne Diosenꞌ nnebieꞌ yichjraꞌlldaꞌo akeꞌn. Naꞌ byejleꞌ akeꞌ, naꞌ blloa akeꞌ nis ka beꞌnn byio ren noꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ren Simón naꞌ byejleꞌ, naꞌ blloareneꞌ nis, naꞌ bdarenteze Felipenꞌ txhen, llwieꞌ yel wak danꞌ lloneꞌ naꞌ, naꞌ llabanreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Naꞌ postl kaꞌ llaꞌa Jerusalén naꞌ, ka ben akreꞌ ke beꞌnn Samaria kaꞌ, ba bxhiꞌi akeꞌ xtiꞌll Diosenꞌ, naꞌ bseꞌl akeꞌ Pedronꞌ ren Juan naꞌ, Samarianꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ka bllin akeꞌn, balwill akeꞌ Dios nench betj Spíritu keꞌen jasón yichjraꞌlldaꞌo beꞌnn Samaria kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Le nono nna siꞌi Spíritu ke Diosenꞌ, laꞌkze ba byejleꞌ akeꞌ ke Xanllo Jesucristonꞌ, naꞌ ba blloa akteꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Naꞌll bxoa taꞌk postl kaꞌ yichj toto akeꞌ, naꞌ kaꞌ jasó Spíritu ke Diosenꞌ lo yichjraꞌlldaꞌo akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ka breꞌe Simón naꞌ kanꞌ ben postl kaꞌ, bxoa taꞌk akeꞌn yichj beꞌnn kaꞌ, nench bxhiꞌi akeꞌ Spíritunꞌ, naꞌ bchabreꞌ postl kaꞌ mell, ");
INSERT INTO zpuNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","lleꞌe leakeꞌ: —Legónn nadaꞌ yel wakenꞌ naprenꞌ, nench noteze beꞌnn wxoa taꞌkaꞌn yichjeꞌ, leskaꞌ so Spíritu ke Diosenꞌ lo yichjraꞌlldaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Naꞌ lle Pedronꞌ leꞌe: —Kweyiꞌrenchgoꞌ xhmelloꞌn, ¿llakroꞌ chaꞌ da gak gaꞌo yel wak ke Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bibi latj koꞌo rweꞌ de gonoꞌ ka nak danꞌ llontoꞌ ni, le bi nak yichjraꞌlldaꞌon wen rao Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Naꞌ Llayaꞌl wayatroꞌ ka danꞌ bneꞌo, naꞌ bnnabe Diosenꞌ chaꞌ yeziꞌxheneꞌ koꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nakbieꞌze nna nchej da xhinnjenꞌ rweꞌ, naꞌ nna llaꞌa yel xheꞌ lo raꞌlldaꞌo, bi lloeꞌn latj gonoꞌ da wen. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Naꞌll bne Simón naꞌ: —Lennab okré rao Xanllonꞌ, bi gakchga kiaꞌ ka danꞌ bnere nga. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedronꞌ ren Juan naꞌ, ka bayoll bzejnieꞌ akreꞌ xtiꞌll Diosenꞌ, naꞌ bazaꞌa akeꞌ zayej akeꞌ Jerusalén naꞌ. Naꞌ ka badé akeꞌ yell kaꞌ ganꞌ nbane Samarianꞌ, bdixjweꞌ akreꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bixha gok, kat to angl ke Xanllonꞌ balwilleꞌ Felipenꞌ, lleꞌe leꞌe: —Byej ganꞌ xhoa nez danꞌ zaꞌa Jerusalén naꞌ, danꞌ zej yellenꞌ re Gaza ganꞌ nak latj dachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Naꞌll broꞌ Felipenꞌ nez zejeꞌ, naꞌ breꞌreꞌ to beꞌnn weꞌo gore, beꞌnn nak beꞌnn brao ganꞌ nziꞌi Etiopía, zazeꞌe byejeꞌ Jerusalén naꞌ, jeꞌraweꞌ Dios. Naꞌ nakeꞌ beꞌnn wex mell ke noꞌrenꞌ re Candace beꞌnn llnebiaꞌ Etiopía. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Naꞌ ka zazeꞌe zayoeꞌ to lo karret, lloleꞌ yich danꞌ bzoj da Isaías beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Naꞌll goll Spíritu ke Diosenꞌ Felipenꞌ: —Byej jabiꞌy kwit beꞌnnenꞌ, naꞌ byejreneꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Naꞌll byej Felipenꞌ jabiꞌyeꞌ kwiteꞌn, naꞌ benreꞌ llol beꞌnnenꞌ yich danꞌ bzoj da Isaíasenꞌ beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, naꞌ lle Felipenꞌ leꞌe: —¿Llejnieꞌroꞌ danꞌ lloloꞌn? ");
INSERT INTO zpuNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Naꞌll bne beꞌnnenꞌ: —¿Akxha chejnieꞌraꞌn naꞌ, chaꞌ nono llraꞌ wzejnieꞌ nadaꞌ? Naꞌll golleꞌ Felipenꞌ choeꞌ lo karretenꞌ, naꞌ zjakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Naꞌ ganꞌ llol beꞌnnenꞌ nen: Ka xhiꞌr daꞌo ba nxhobeꞌ, zejbaꞌ rao yel got, ka xhiꞌr daꞌo bi llosiaꞌ kat llchipeꞌ xhabaꞌ, kaꞌ beneꞌ, bi ballieꞌ xtiꞌll akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Naꞌ ben akeꞌ Leꞌe ka to beꞌnn bibi zaꞌke, bi ben akeꞌ yel koxchis keꞌen ka llayaꞌl gaken. Nono xhiꞌnn dialla keꞌe niꞌt, le bakaꞌa akeꞌ yel nban keꞌen rao yellrio nga. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Naꞌ wex mellenꞌ lleꞌe Felipenꞌ: —Ben okré bne nadaꞌ, ¿bixchen ne beꞌnnenꞌ kaꞌ, ke kwineꞌn neꞌe kaꞌ o chaꞌ ke beꞌnn yobrenꞌ neꞌe kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Naꞌll Felipenꞌ, bxhiꞌzen ganꞌ bel beꞌnnenꞌ, bzorao lloeꞌreneꞌ leꞌe Diꞌll Wen ke Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Naꞌ chak yoꞌ akeꞌ nezenꞌ ka bllin akeꞌ ga de nis, naꞌll lleꞌe Felipenꞌ: —Ganni llia nis, ¿bi gak choategaꞌ nis nnaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipenꞌ lleꞌe leꞌe: —Chaꞌ wxenraꞌlloꞌ Jesucristonꞌ do yichj do raꞌlldaꞌo, wakse. Naꞌll ne beꞌnnenꞌ: —Ba byejliaꞌ Jesucristonꞌ nakeꞌ Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Naꞌll golleꞌ beꞌnnenꞌ wzaꞌyeꞌ karretenꞌ, naꞌ llop akeꞌ betj akeꞌ lo nisenꞌ, naꞌ bchoa Felipenꞌ leꞌe nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ka balloj akeꞌ lo nisenꞌ, Spíritu ke Diosenꞌ bacheꞌen Felipenꞌ ga yobre, bill breꞌe beꞌnnenꞌ leꞌe. Naꞌ bagoꞌ beꞌnnenꞌ nez llawereꞌ kwis zayejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ka gokbeꞌe Felipenꞌ ba bllinteꞌ yellenꞌ nziꞌi Azoto, naꞌ zejzeꞌ toto yell llyixjweꞌreꞌ Diꞌll Wen ke Jesucristonꞌ, bllinteꞌ yellenꞌ re Cesarea. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naꞌ Saulonꞌ zokze yichjraꞌlldaꞌweꞌ goꞌxeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, nench goteꞌ leakeꞌ. Naꞌ byejeꞌ rao bxoz braonꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","naꞌ bnnabeꞌ yich da weꞌe latj chejeꞌ yellenꞌ re Damasco, naꞌ choeꞌ toto yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ goꞌxeꞌ beꞌnn kaꞌ nao nez kob ke Diosenꞌ, ka beꞌnn byio ren noꞌre, naꞌ wacheꞌe leakeꞌ Jerusalén choꞌ akeꞌ rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ka gok broꞌ Saulonꞌ nez zejeꞌ, bixha ka le llinteꞌ Damasconꞌ, to beniꞌ da zaꞌa yebá byechjen leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Naꞌ wixeꞌ jeꞌtteꞌ rao yo, naꞌll benreꞌ bne to beꞌnn lleꞌe leꞌe: —Saulo, Saulo, ¿bixchen llwieroꞌ nadaꞌ, naꞌ daꞌo llrayoꞌ nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naꞌll bne Saulonꞌ: —¿No rweꞌ, Xanaꞌ? Naꞌll bne beꞌnnenꞌ: —Nadaꞌn Jesús, nadaꞌn daꞌo llonroꞌ kaꞌ, llonze ziꞌ kwinoꞌn llonoꞌ kaꞌ, ka llon to bell llcheꞌobaꞌ rao to da la, da llaꞌdebaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Naꞌll Saulonꞌ do xhizeꞌ, llebeꞌ bneꞌe: —Xanaꞌ, ¿Bixha lleꞌnroꞌ gonaꞌ? Naꞌll lle Xanllo leꞌe: —Byejkze Damasconꞌ, gannaꞌ nne akeꞌ akre gonoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Beꞌnn kaꞌ zejrén Saulonꞌ txhen blleb akeꞌ kwis, ka nak ben akreꞌ chiꞌi beꞌnnenꞌ, naꞌ nono breꞌe akreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Naꞌ bayas Saulonꞌ, ka gokraꞌlleꞌ yexaꞌ raweꞌn bill breꞌreꞌ. Naꞌ beꞌnn kaꞌ zejreneꞌ txhen naꞌ, beꞌx akeꞌ taꞌkeꞌ, bcheꞌe akeꞌ leꞌe ganꞌ nziꞌi Damasconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chonn lla bzoeꞌ bi breꞌreꞌ, naꞌ bi weꞌj bdaokzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco naꞌ, zo to beꞌnn llonliraꞌll Xanllo Jesucristonꞌ beꞌnn re Ananías, naꞌ Ananíasenꞌ breꞌdaꞌoreꞌ Xanllonꞌ, lleꞌe leꞌe: —¡Ananías! Naꞌll bne Ananíasenꞌ: —Bi naꞌ, Xanaꞌ, ganni zoaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Naꞌll lle Xanllonꞌ leꞌe: —Bzollaꞌa, naꞌ byej rill beꞌnnenꞌ re Judas, beꞌnnenꞌ zo ganꞌ nziꞌi Nez Li, naꞌ bayirj to beꞌnne re Saulo beꞌnn Tarso, nnaꞌstek llieꞌ llalwilleꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Naꞌ ba benaꞌ nench breꞌdaꞌoreꞌ rweꞌ, bllinoꞌ wxoa taꞌkoꞌn yichjeꞌ, nench yereꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Naꞌll bne Ananíasenꞌ: —Xanaꞌ, beꞌnn zan kwis lloeꞌ xtiꞌll beꞌnnenꞌ, katek da xhinnj kwis ba beneꞌ, bsaꞌkzieꞌ beꞌnn kaꞌ llonliraꞌll rweꞌn llaꞌa Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naꞌ ke len naꞌ, bedeꞌ ganni noꞌxteꞌ to yich danꞌ beꞌe bxoz wnebiaꞌ kaꞌ, nench goꞌxeꞌ beꞌnn kaꞌ llalwill rweꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Naꞌll Xanllonꞌ lleꞌe Ananíasenꞌ: —Lla byej, nadaꞌ ba brejaꞌ beꞌnnenꞌ, nench chejeꞌ weꞌe xtiꞌllaꞌn rao beꞌnn kaꞌ bi nak beꞌnn Israel, naꞌ chejeꞌ no rao beꞌnn wnebiaꞌ ke toto yell kaꞌ, naꞌ renkze beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nadaꞌ wroeꞌreꞌ katek yellayraweꞌ danꞌ wzenayeꞌ kiaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Naꞌ byej Ananíasenꞌ ganꞌ zo Saulonꞌ, ka bllineꞌn bxoa taꞌkeꞌn yichjeꞌ, lleꞌe leꞌe: —Saulo biꞌchaꞌ, Xanllo Jesús beꞌnnenꞌ broeꞌrao rweꞌ kanꞌ zaꞌo tnezenꞌ, bseꞌleꞌ nadaꞌ nench yereꞌroꞌ, naꞌ so Spíritu ke Diosenꞌ lo yichjraꞌlldaꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Naꞌll le ballachte da nak ka yid bdeꞌj lo raweꞌn, naꞌll bareꞌreꞌ. Naꞌll bayaseꞌ, naꞌ blloeꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bde naꞌ, bayaweꞌ, naꞌ bayakraꞌlleꞌ. Naꞌ bagaꞌnneꞌ Damasconꞌ chop chonn lla ren beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Le bzoraote Saulonꞌ llejeꞌ ga zo toto yodaꞌo ganꞌ lladop beꞌnn Israel kaꞌ, naꞌ lloeꞌ xtiꞌll Diosenꞌ, neꞌe Jesucristonꞌ nakeꞌ Xhiꞌnn Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yeolol beꞌnn kaꞌ llzenay xtiꞌlleꞌn, llabán akreꞌ kwis, naꞌ lle lwellj akeꞌ: —¿Kere beꞌnn ninꞌ dá lliꞌnaweꞌ, naꞌ lloꞌxeꞌ beꞌnn kaꞌ llalwill Jesucristonꞌ, beꞌnn kaꞌ llaꞌa Jerusalén naꞌ? ¿Naꞌ kere ke len naꞌ ba bedeꞌ ganni nench goꞌxeꞌ beꞌnn kaꞌ, naꞌ lljasaneꞌ leakeꞌ rao bxoz wnebiaꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Naꞌll Saulonꞌ yezikre llaralreꞌ llroeꞌreꞌ neꞌe, Jesúsenꞌ nakeꞌ Cristo beꞌnn bseꞌl Dios nench nnebieꞌ. Naꞌ beꞌnn Israel kaꞌ llaꞌa Damasconꞌ, bi ballel akreꞌ akre ye akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bixha ba gok zan lla, lloeꞌ Saulonꞌ xtiꞌll Jesucristonꞌ, naꞌll beꞌnn Israel kaꞌ, beꞌe akeꞌ diꞌll got akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ka nak yellenꞌ nechjen zeꞌe, naꞌ blleꞌnao akeꞌ toto ganꞌ ll-lloj akeꞌ yellenꞌ. Bixha Saulonꞌ gokbeꞌreꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, broꞌ akeꞌ leꞌe to lo wit, naꞌ baletj akeꞌ leꞌe tlleꞌle koꞌll zeꞌen, naꞌ baxhonnjeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ka ballín Saulonꞌ Jerusalén naꞌ, gokraꞌlleꞌ gakeꞌ txhen ren beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ yeolol akeꞌ blleb akeꞌ, bi llejleꞌ akeꞌ chaꞌ da linꞌ ba llonliraꞌlleꞌ Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Naꞌ beꞌnnenꞌ re Bernabé bcheꞌe leꞌe ganꞌ llaꞌa postl kaꞌ, naꞌ beꞌreneꞌ leakeꞌ diꞌll, kanꞌ gok breꞌe Saulonꞌ Xanllonꞌ, kanꞌ yoeꞌ nez zejeꞌ Damasconꞌ, naꞌ kanꞌ beꞌreneꞌ leꞌe diꞌll. Naꞌ gollteꞌ leakeꞌ kanꞌ ben Saulonꞌ, bi bllebeꞌ beꞌe xtiꞌll Jesucristonꞌ Damasconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulonꞌ bzoeꞌ Jerusalén naꞌ, naꞌ bdateze bnaweꞌ beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naꞌ bi llebeꞌ weꞌreneꞌ beꞌnn griego kaꞌ xtiꞌll Jesucristonꞌ, naꞌ beꞌnn kaꞌ, lleꞌn akreꞌ got akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ka gokbeꞌe beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ danꞌ lleꞌn akreꞌ got akeꞌ leꞌen, naꞌll bcheꞌe akeꞌ Saulonꞌ yellenꞌ nziꞌi Cesarea, naꞌll baseꞌl akeꞌ leꞌe Tarso. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yeolol beꞌnn kaꞌ ba lldop ll-llay llonliraꞌll Jesucristonꞌ toto ganꞌ nbane Judeanꞌ, naꞌ Galilea, naꞌ Samaria llaꞌa akeꞌ wen, naꞌ zejzell llejnieꞌ akreꞌ xtiꞌll Jesucristonꞌ, naꞌ llonliraꞌll aklleꞌ Leꞌe. Naꞌ Spíritu ke Diosenꞌ lltipraꞌllen leakeꞌ, naꞌ zejze llan beꞌnn kaꞌ tlla tlla. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bixha gok ka dá Pedronꞌ llraꞌnneꞌ yeolol beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ. Naꞌ bllineꞌ yellenꞌ nziꞌi Lida. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Naꞌ jadiꞌreꞌ to beꞌnn re Eneas. Ba gok xoꞌn iz deꞌe nat nieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedronꞌ lleꞌe leꞌe: —Eneas, Jesucristonꞌ wayoneꞌ rweꞌ nnaꞌsteke, bayas batob xtaꞌon. Le bayaste beꞌnnenꞌ bayakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yeolol beꞌnn kaꞌ llaꞌa Lidanꞌ, naꞌ beꞌnn kaꞌ llaꞌa yellenꞌ re Sarón breꞌe akreꞌ kanꞌ bayak beꞌnnenꞌ, naꞌ bsanraꞌll akeꞌ billre da llxenraꞌll akeꞌ, naꞌ baxenraꞌll akeꞌ toze Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bixha gok to lla yellenꞌ nziꞌi Jope, zo to noꞌr nxenraꞌll Dios, naꞌ nzieꞌ Tabita, diꞌll griego lleꞌnen nen Dorcas. Dorcas naꞌ zoteze zoeꞌ lloneꞌ da wen llakreneꞌ beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bixha goksereꞌ yillweꞌ, naꞌ goteꞌ. Naꞌ bayoll bwazj akeꞌ leꞌe naꞌ, bxoa akeꞌ leꞌe to lo yoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yell Lida naꞌ, naken awlloze Jope, naꞌ bnneze beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ, yell Lida naꞌ zo Pedronꞌ, naꞌ bseꞌl akeꞌ chop beꞌnn nench gaꞌtyoe akreꞌ leꞌe, naꞌ lle akeꞌ leꞌe: —Ben okré choꞌrén netoꞌ nnastek. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Le byejrente Pedronꞌ leakeꞌ. Ka bllin akeꞌ naꞌ, jwaꞌa akeꞌ leꞌe ganꞌ de beꞌnn watenꞌ, naꞌ jabiꞌy noꞌr wazeb kaꞌ, bell akeꞌ, naꞌ llroeꞌ akreꞌ leꞌe raꞌll xha kaꞌ da ben Dorcas ka nna nbaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Naꞌ Pedronꞌ bchacheꞌ yeolol beꞌnn kaꞌ llaꞌa lo yoꞌn, naꞌll bcheꞌk xhibeꞌ balwilleꞌ Dios. Naꞌtell bayechjeꞌ bwieꞌ beꞌnn watenꞌ, naꞌ lleꞌe leꞌe: —¡Tabita, bayas! Le baxaꞌte rao Tabitanꞌ. Ka breꞌreꞌ Pedronꞌ, le bayasteꞌ babieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Naꞌll beꞌx Pedronꞌ taꞌkeꞌ basolleꞌe leꞌe, naꞌll goxheꞌ noꞌr wazeb kaꞌ, naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, broeꞌreꞌ leakeꞌ ba babaneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yeolol beꞌnn Jope kaꞌ, bnnez akreꞌ kanꞌ goken, naꞌ beꞌnn zan byejleꞌ ke Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedronꞌ goꞌyeꞌ zan lla Jopenꞌ, bzoeꞌ rill to beꞌnn re Simón beꞌnn wazoꞌll yid. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Naꞌ yellenꞌ re Cesarea, zo to beꞌnn re Cornelio, naꞌ nakeꞌ xan wakaꞌa ya kaꞌ, nziꞌi Beꞌnn Italia. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Llapeꞌ Diosenꞌ baraꞌnne, laꞌkze bi nakeꞌ beꞌnn Israel, lloeꞌraweꞌ Dios ren beꞌnn kaꞌ llaꞌa lo yoꞌ keꞌen, naꞌ lloeꞌ mell da llakreneꞌ beꞌnn Israel kaꞌ, naꞌ zoteze zoeꞌ llalwilleꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gok to lla, lladá chonne breꞌdaꞌoreꞌ, breꞌreꞌ to angl ke Dios byoeꞌ ganꞌ zoeꞌn, naꞌ lle anglenꞌ leꞌe: —¡Cornelio! ");
INSERT INTO zpuNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio naꞌ bwiachicheꞌ anglenꞌ, naꞌ do llebeꞌ lleꞌe leꞌe: —¿Bi naꞌ, xanaꞌ? Naꞌll lle anglenꞌ leꞌe: —Diosenꞌ ba benreꞌ kanꞌ llalwilloeꞌn, naꞌ ba breꞌreꞌ kanꞌ llakrenoꞌ beꞌnn yaꞌch kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Naꞌ bseꞌl beꞌnn lljakeꞌ yellenꞌ re Jope, naꞌ lljaxiꞌi akeꞌ to beꞌnn re Simón Pedro. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zoeꞌ rill beꞌnn leskaꞌ reꞌe Simón, beꞌnn wazoꞌll yid, naꞌ zoeꞌ lloaꞌ nisdaꞌo, leꞌe yeꞌe rweꞌ da llayaꞌl gonoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ka bazaꞌa anglenꞌ, goxh Cornelionꞌ chop beꞌnn wen llin keꞌe, naꞌ goxhteꞌ ye to wakaꞌa ya, beꞌnn llakrén leꞌe, leskaꞌ wakaꞌa yanꞌ nxenraꞌlleꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Naꞌ beꞌreneꞌ leakeꞌ diꞌll kanꞌ goll anglenꞌ leꞌe, naꞌll bseꞌleꞌ leakeꞌ Jopenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bateyó ka ba zo rez llin beꞌnn kaꞌ Jopenꞌ, Pedronꞌ byepeꞌ yichjo ganꞌ zoeꞌn, nench balwilleꞌ Dios, llonen ka do wawill. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Naꞌ doneꞌ kwis, naꞌ gokraꞌlleꞌ gaweꞌ. Chak llon akeꞌ da gaweꞌn, breꞌdaꞌoreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Breꞌreꞌ byarj yebánꞌ, naꞌ breꞌreꞌ to xchan xhen, nllej toto xhiꞌne lletjen. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naꞌ loe naꞌ llaꞌa yoꞌy kwen bayiꞌxe ba llia tap niaꞌnaꞌa, naꞌ ba llxhob leꞌ, naꞌ ba llia xire. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Naꞌll benreꞌ bne Diosenꞌ: —Byas Pedro, bet ba ki naꞌ bdao. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Naꞌll Pedronꞌ lleꞌe Diosenꞌ: —Kaꞌa, Xanaꞌ, bi nna gawaꞌ ba zban kaꞌ, nllon leyenꞌ gaotoꞌ ka ba kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Naꞌll bne Diosenꞌ da yobre, lleꞌe leꞌe: —To da ba bayib Dios, bi nneꞌo nakllen da zban. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gokte chonn ras lleꞌe leꞌe kaꞌ, naꞌll bayep xchan naꞌ yebá. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Chak llon Pedronꞌ xhbab kwis, bi zejen danꞌ breꞌdaꞌoreꞌn, kat bllinkze beꞌnn kaꞌ bseꞌl Cornelionꞌ lloaꞌ yoꞌn, llnnab akeꞌ ganꞌ zo beꞌnnenꞌ re Simón, beꞌnn wazoꞌll yid naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ka bllin beꞌnn kaꞌ lloaꞌ yoꞌn, bnne akeꞌ zillje, llnnab akeꞌ chaꞌ gannaꞌn zo to beꞌnn re Simón Pedro. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Naꞌ nna ze Pedronꞌ lloneꞌ xhbab ke danꞌ breꞌdaꞌoreꞌn, kat goll Spíritu ke Diosenꞌ leꞌe: —Rweꞌn llayirj beꞌnn ki chonne. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lla bzollaꞌa, naꞌ bayetj, naꞌ byejrén akeꞌ, bi gakganroꞌ, nadkzaꞌn bseꞌl akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Naꞌll bayetj Pedronꞌ, jatileꞌ beꞌnn kaꞌ bseꞌl Cornelionꞌ, lleꞌe leakeꞌ: —Nadaꞌn riaꞌ Simón Pedro, ¿bi ken llayirjre nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Naꞌll bne beꞌnn kaꞌ: —To xan wakaꞌa ya kaꞌ re Cornelio bseꞌleꞌ netoꞌ, nakeꞌ to beꞌnn lloeꞌrao Dios, naꞌ yeolol beꞌnn Israel kaꞌ, lloeꞌ akeꞌ xtiꞌlleꞌ nakeꞌ beꞌnn wen. To angl ke Diosenꞌ broeꞌraweꞌ leꞌe, naꞌ golleꞌ leꞌe yedxiꞌtoꞌ rweꞌ chejoꞌ rilleꞌn, nench yeꞌweꞌ binꞌ llayaꞌl goneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Naꞌ broeꞌ leakeꞌ yoꞌ, naꞌ btas akeꞌ lleꞌ naꞌ. Bateyó byas Pedronꞌ zejreneꞌ beꞌnn kaꞌ, naꞌ ren ye bal beꞌnn nxenraꞌll Jesucristonꞌ, beꞌnn llaꞌa Jope naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ballop lla bllin akeꞌ Cesareanꞌ. Cornelionꞌ ba llbexheꞌ leakeꞌ, ba btopeꞌ no biꞌch lwelljeꞌ, no beꞌnn nakeꞌ txhen. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ka bllin Pedronꞌ yoꞌn, le bllojdote Cornelionꞌ, jatileꞌ leꞌe, bcheꞌk xhibeꞌ gokraꞌlleꞌ weꞌraweꞌ Pedronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedronꞌ basolleꞌe leꞌe, naꞌ lleꞌe leꞌe: —Bazollaꞌa, lekze beꞌnnach nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nna lloeꞌrenteꞌ leꞌe diꞌllenꞌ, byoꞌ akeꞌ lo yoꞌn, naꞌ breꞌreꞌ beꞌnn zan ba llaꞌa. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Naꞌll Pedronꞌ lleꞌe leakeꞌ: —Reꞌ nnézere, ley ke netoꞌ beꞌnn Israel, ll-llonen choꞌtoꞌ lo yoꞌ rill beꞌnn bi nak beꞌnn Israel gon aktoeꞌ txhen, zan Diosenꞌ ba broeꞌreꞌ nadaꞌ gonaꞌ beꞌnn kaꞌ txhen, laꞌkze bi nak akeꞌ beꞌnn ketoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ke len naꞌ, kate braꞌ beꞌnn ki badxiꞌi akeꞌ nadaꞌn, le zaꞌtiaꞌ. Naꞌ lleꞌnraꞌ nnere bi ken goxhre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Naꞌll bne Cornelionꞌ: —Nnaꞌ llak tap lla, hor kite lladá chonne, nonaꞌ was, naꞌ llalwillaꞌ Dios, ka breꞌraꞌ to beꞌnn badseꞌe rawaꞌn llaktit xharaꞌneꞌn kwis. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Naꞌ bneꞌe: “Cornelio, ba bzenay Diosenꞌ kanꞌ llalwilloeꞌn, naꞌ ba breꞌreꞌ kanꞌ llonoꞌ llakrenoꞌ beꞌnn yaꞌche. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bseꞌl beꞌnn lljakeꞌ Jope, naꞌ lljaxiꞌi akeꞌ to beꞌnn re Simón Pedro, zoeꞌ rill beꞌnn re Simón, beꞌnn wazoꞌll yid. Zoeꞌ lloaꞌ nisdaꞌo. Naꞌ kate raꞌ Pedronꞌ rilloꞌ, naꞌll weꞌreneꞌ rweꞌ diꞌlle.” ");
INSERT INTO zpuNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Naꞌllenꞌ le bseꞌltiaꞌ beꞌnn kaꞌ badxiꞌi rweꞌn, naꞌ ba benoꞌ wen bedoꞌ. Ni llaꞌtoꞌ nnaꞌ, naꞌ lleꞌnetoꞌ wzenaytoꞌ binꞌ lleꞌne Diosenꞌ gontoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedronꞌ bzorao lloeꞌ diꞌll, naꞌ bneꞌe: —Nnaꞌll ba byejnieꞌraꞌ ke Diosenꞌ bi llaleꞌe ke ke beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Beꞌnn llaꞌa gateze yellrio, chaꞌ llap akeꞌ Diosenꞌ baraꞌnne, naꞌ llon akeꞌ da wen, lloꞌraꞌllkze Diosenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosenꞌ bdixjweꞌreꞌ beꞌnn Israel kaꞌ, wak wazorenllo Diosenꞌ wen, chaꞌ wxenraꞌll-llo Jesucristonꞌ, le Leꞌen nak Xan yeolol-llo. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Reꞌ nnézkzere ka danꞌ gok doxhen ganꞌ nziꞌi Judeanꞌ, danꞌ bzorao ganꞌ nziꞌi Galilea naꞌ, bde kanꞌ bdixjweꞌ Juan naꞌ xtiꞌll Diosenꞌ, naꞌ bchoeꞌ beꞌnn kaꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nnézkzere, Dios naꞌn beꞌe Jesús beꞌnn Nazaretenꞌ yel wak, naꞌ beꞌe Leꞌe Spíritu keꞌen. Naꞌllenꞌ bda Jesúsenꞌ beneꞌ da wen, bayoneꞌ yeolol beꞌnn llsaꞌkziꞌ daxiꞌon, le Diosenꞌ bzorén Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Naꞌ netoꞌ breꞌtoꞌ, naꞌ lloeꞌtoꞌ diꞌll ke da kaꞌ ben Jesúsenꞌ do Judea naꞌ Jerusalén, naꞌ breꞌtetoꞌ kanꞌ gok bet akeꞌ Leꞌe, bdaꞌa akeꞌ Leꞌe leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bixha Diosenꞌ basbaneꞌ Leꞌe bayónn lla, naꞌ beneꞌ nench broeꞌraweꞌ netoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kere broeꞌraweꞌ yeolol beꞌnnenꞌ, netoꞌ brejeꞌ da nellte nench weꞌtoꞌ xtiꞌlleꞌn broeꞌraweꞌ netoꞌ. Netoꞌ weꞌj bdaorentoeꞌ txhen, kanꞌ babaneꞌ radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Naꞌll ba bseꞌleꞌ netoꞌ chixjweꞌtoꞌ yeolol beꞌnne, ba brej Diosenꞌ Leꞌe goneꞌ yel koxchis ke beꞌnn ban, naꞌ beꞌnn ba got. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yeolol beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, beꞌe akeꞌ xtiꞌll Jesucristonꞌ, bne akeꞌ noteze chejleꞌ keꞌe, Dios naꞌ yeziꞌxheneꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nna lloeꞌte Pedronꞌ diꞌllenꞌ, kat byoꞌ Spíritu ke Diosenꞌ yichjraꞌlldaꞌo beꞌnn kaꞌ llaꞌa llzenayenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Beꞌnn Israel kaꞌ nxenraꞌll Jesucristonꞌ, beꞌnn kaꞌ bnao Pedronꞌ, llabán akreꞌ kwis ka nak rente beꞌnn bi zjanak beꞌnn Israel, ba byoꞌ Spíritu ke Diosenꞌ yichjraꞌlldaꞌo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gokbeꞌe akreꞌ kanꞌ bxhiꞌi beꞌnn kaꞌ Spíritu ke Diosenꞌ, le bzoraote lloeꞌrao akeꞌ Dios, llnne akeꞌ to diꞌll yobre. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Naꞌll bne Pedronꞌ: —Bibi de wllon choa beꞌnn ki nis nnaꞌ, ka nak Spíritu ke Diosenꞌ ba byoꞌn lo yichjraꞌlldaꞌo akeꞌn, kanꞌ ba byoꞌn lo yichjraꞌlldaꞌo lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Naꞌ golleꞌ leakeꞌ choa akeꞌ nis, le ba nxenraꞌll akeꞌ Jesucristonꞌ. Bde naꞌ goꞌtyoe akreꞌ Pedronꞌ, nench goꞌyreneꞌ leakeꞌ ye chop chonn lla. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Postl kaꞌ, naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ llaꞌa do ganꞌ nziꞌi Judeanꞌ, bnnez akreꞌ ke nak beꞌnn kaꞌ bi nak beꞌnn Israel, ba bxhiꞌi akeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ka ballín Pedronꞌ Jerusalén naꞌ, beꞌnn Israel kaꞌ, beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ, bdil akeꞌ leꞌe, ");
INSERT INTO zpuNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","lle akeꞌ leꞌe: —¿Bixchen jachoꞌzoꞌ rill beꞌnn kaꞌ bi nak beꞌnn Israel, naꞌ jataorén akteꞌweꞌ txhen? ");
INSERT INTO zpuNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Naꞌll beꞌrén Pedronꞌ leakeꞌ diꞌll kwasro doxhen kanꞌ goken, lleꞌe leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Chak zoaꞌ yellenꞌ re Jope, ka llalwillaꞌ Diosenꞌ breꞌdaꞌoraꞌ, breꞌraꞌ to xchan xhen nllejten dapte xhiꞌne, lletjen yebá, naꞌ zaꞌn ganꞌ ziaꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Naꞌ bwiayaꞌnnaꞌ bixhanꞌ llaꞌa loenꞌ, naꞌ breꞌraꞌ llaꞌa bayiꞌx ba llia tap niaꞌnaꞌa, ba llxhob leꞌe, naꞌ ba llia xire. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Naꞌ benraꞌ bne Diosenꞌ lleꞌe nadaꞌ: “Bzollaꞌa Pedro, bet ba ki, naꞌ bdao akbaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Naꞌll balliaꞌ xtiꞌlleꞌn: “Kaꞌa, Xanaꞌ, bi nna gawaꞌ ba zban kaꞌ, nllon leyenꞌ gaotoꞌ ka ba kaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Naꞌll bneꞌe da yobre, lleꞌe nadaꞌ: “Da ba bayib Dios, bill nneꞌo nakllen zban.” ");
INSERT INTO zpuNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chonn ras gok kaꞌ, naꞌll bayep xchan naꞌ yebá. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nnaꞌ llakte kaꞌn, le braꞌte chonn beꞌnn ganꞌ zoaꞌn, beꞌnn zaꞌk yellenꞌ re Cesarea. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Naꞌll Spíritu ke Diosenꞌ gollen nadaꞌ llayaꞌl chaꞌrén akeꞌ, naꞌ bi gakganraꞌ. Naꞌ bzaꞌrente beꞌnn biꞌchllo ki xope, bllintetoꞌ rill to beꞌnn re Cornelio, naꞌ byoꞌtoꞌ rilleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cornelionꞌ beꞌreneꞌ netoꞌ diꞌll ka gok broeꞌrao to anglenꞌ leꞌe, naꞌ goll anglenꞌ leꞌe: “Bseꞌl beꞌnn lljakeꞌ Jope, naꞌ lljaxiꞌi akeꞌ to beꞌnn re Simón Pedro. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Beꞌnn naꞌ weꞌreneꞌ rweꞌ xtiꞌll Diosenꞌ akre gonoꞌ, nench yeraꞌo rao da xhinnjenꞌ ren beꞌnn llaꞌa lo yoꞌ rilloꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Naꞌ ka bzorawaꞌ lloeꞌrén akeꞌ diꞌllenꞌ, Spíritu ke Diosenꞌ byoꞌn yichjraꞌlldaꞌo akeꞌ, kanꞌ byoꞌn lo yichjraꞌlldaꞌollonꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Naꞌ jadinraꞌllaꞌ xtiꞌll Xanllo Jesucristonꞌ, kanꞌ bneꞌe: “Da li Juan naꞌ bchoeꞌ beꞌnn kaꞌ nis, zan to da zaꞌkll gak keré yedsó Spíritu ke Diosenꞌ yichjraꞌlldaꞌore.” ");
INSERT INTO zpuNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Chaꞌ kwin Diosenꞌ ba beꞌe leakeꞌ Spíritu keꞌen kanꞌ benneꞌn lliꞌo nxenraꞌll-llo Jesucristonꞌ, ¿noxha nakaꞌ nadaꞌn yepaꞌ Diosenꞌ bi goneꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ka bayoll ben akreꞌ kanꞌ bne Pedronꞌ, bzo akeꞌ llize naꞌ beꞌrao akeꞌ Dios, bne akeꞌ: —¿Bixha ren beꞌnn kaꞌ bi nak beꞌnn Israelenꞌ, ba lloeꞌ Diosenꞌ latj yeyat akreꞌ nench yeziꞌxheneꞌ ke akeꞌ, naꞌ weꞌe yel nban zejlikane ke akeꞌn chaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Beꞌnn kaꞌ bxhonnj goslas kanꞌ bde bet akeꞌ Esteban naꞌ, bal akeꞌ bllin akteꞌ ganꞌ nziꞌi Fenicia, naꞌ yell kaꞌ zjalliꞌ to yellrio da lliꞌ lo nisdaꞌo ganꞌ nziꞌi Chipre, naꞌ yellenꞌ re Antioquía ganꞌ nbane Siria. Naꞌ bi lloeꞌrén akeꞌ no beꞌnn yobre xtiꞌll Diosenꞌ, zre beꞌnn Israel kaꞌze lloeꞌrén akeꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Naꞌ bal beꞌnn yellenꞌ nziꞌi Chipre, naꞌ beꞌnn Cirene bllin akeꞌ Antioquía, naꞌ bzorao llroeꞌ akreꞌ Diꞌll Wen ke Xanllo Jesucristonꞌ, ren beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Naꞌ yel wak ke Xanllonꞌ zerenen leakeꞌ. Naꞌ beꞌnn zan llsanraꞌll da nao akeꞌ, naꞌ baxenraꞌll akeꞌ Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Naꞌ beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ llaꞌa Jerusalén naꞌ, ben akreꞌ kanꞌ llaken, naꞌ bseꞌl akeꞌ beꞌnnenꞌ re Bernabé Antioquía naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ka bllin Bernabénꞌ, breꞌreꞌ kanꞌ llakrén Diosenꞌ leakeꞌ bawereꞌ kwis, naꞌ golleꞌ leakeꞌ do yichj do raꞌll akeꞌ nnao akeꞌ Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ka nak Bernabénꞌ nakeꞌ to beꞌnn wen kwis, naꞌ yoꞌyaꞌnneꞌ Spíritu ke Diosenꞌ, naꞌ le nxenraꞌlleꞌ Dios, naꞌll yezikre beꞌnn zanll bxenraꞌll Xanllonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Naꞌtell byej Bernabénꞌ yellenꞌ re Tarso jadirjeꞌ Saulonꞌ, ka balleleꞌ leꞌen, bcheꞌe leꞌe Antioquíanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","To iz bzo akeꞌ Antioquíanꞌ, ben akeꞌ txhen beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ, naꞌ beꞌnn zan broeꞌ akreꞌ xtiꞌll Diosenꞌ. Antioquía naꞌ bsiꞌi akeꞌ beꞌnn kaꞌ llonliraꞌll Xanllonꞌ, Cristiano da nelle. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ka gok kaꞌ, bal beꞌnn kaꞌ llaꞌa Jerusalén, beꞌnn kaꞌ lloeꞌ xtiꞌll Diosenꞌ kon ka llzejnieꞌ Spíritu ke Diosenꞌ leakeꞌ, naꞌ byej akeꞌ Antioquíanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Toeꞌ beꞌnn re Agabo bzolleꞌe radj beꞌnn kaꞌ llaꞌa lloeꞌrao Diosenꞌ, naꞌ bneꞌe kon kanꞌ bzejnieꞌ Spíritunꞌ leꞌe, bdixjweꞌreꞌ gak to win xhen doxhen yellrio. Naꞌ ka bllin lla bnebiaꞌ beꞌnnenꞌ re Claudio doxhen ganꞌ nbane Roma, kanaꞌ gok win kanꞌ bne Agabonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Naꞌ beꞌnn Antioquía kaꞌ llonliraꞌll Jesucristonꞌ, beꞌe akeꞌ diꞌll gakrén akeꞌ beꞌnn lwellj akeꞌ kaꞌ llaꞌa yell kaꞌ do ganꞌ nziꞌi Judea, kon ka yezaꞌraꞌll toto akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Naꞌ ka bayoll bdopen naꞌ, bseꞌl akeꞌ Bernabénꞌ ren Saulonꞌ jwaꞌa akeꞌ mellenꞌ rao beꞌnn gor brao kaꞌ, nak rallnaꞌa beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ llaꞌa Judeanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Leskaꞌ kanaꞌ bchoybiaꞌ rey Herodes, beꞌx akeꞌ bal beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, nench wsaꞌkzieꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Naꞌ bchoybieꞌ bet akeꞌ Jacobo, bchoy akeꞌ yeneꞌ, beꞌnnenꞌ nak beꞌnn biꞌch Juan naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Gokbeꞌe Herodesenꞌ bayoꞌraꞌll beꞌnn Israel kaꞌ kanꞌ beneꞌn, naꞌll bseꞌleꞌ beꞌnn kaꞌ, beꞌx akeꞌ Pedronꞌ rao lnninꞌ, katenꞌ llao akeꞌ yet xtir danꞌ bi nchix kwa binn. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herodes naꞌ, broeꞌ Pedronꞌ rill ya, naꞌ bseꞌleꞌ tap kwen wakaꞌa ya, beꞌnn nak tap wej, nench bdap akeꞌ rill yanꞌ. Llakreꞌ ka te lnni naꞌ, kwejeꞌ leꞌe rao beꞌnn yell, goneꞌ yel koxchis keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bixha chak yoꞌ Pedronꞌ rill yanꞌ, naꞌ llaꞌa wakaꞌa ya kaꞌ llap akeꞌ leꞌe, naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, llaral llalwill akeꞌ Diosenꞌ gakreneꞌ Pedronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bixha tlleꞌle naꞌ, ka wxere llwia Herodesenꞌ kwejeꞌ Pedronꞌ. Naꞌ Pedronꞌ deꞌe taseꞌ radj chop wakaꞌa ya, naꞌ nllej taꞌkeꞌn chop gden, naꞌ llaꞌte ye to kwen wakaꞌa ya, llap akeꞌ lloaꞌ rill yanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kat bllinkze to angl ke Xanllo Dios lo rill yanꞌ, to beniꞌ xhen goꞌte, naꞌ anglenꞌ jataneꞌ Pedronꞌ basbaneꞌ leꞌe, lleꞌe leꞌe: —¡Sete byase! Ka bneꞌe kaꞌn, le ballojte gden kaꞌ taꞌk Pedronꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Naꞌll lle anglenꞌ leꞌe: —Bachej leꞌon, naꞌ barejdo xheroꞌn. Naꞌll bayoll naꞌ, lleꞌe leꞌe: —Balleldo xhalleroꞌn, naꞌ banao nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Naꞌ balloj anglenꞌ, naꞌ zanao Pedronꞌ, naꞌ bi llakbeꞌreꞌ chaꞌ da linꞌ llabej anglenꞌ leꞌe rill yanꞌ, kon llakreꞌ chaꞌ llreꞌdaꞌozreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Badé akteꞌ ganꞌ llaꞌa to kwen wakaꞌa ya kaꞌ, naꞌll badé akeꞌ ga llaꞌa beꞌnn wllope kaꞌ. Kat ballín akteꞌ ga zo reyj de ya danꞌ llwia tnezre, to wrazzen byarjen, naꞌ balloj akeꞌ. Bzaꞌa akeꞌ ye raꞌt, naꞌll bazaꞌa anglenꞌ, naꞌ bakwaꞌnneꞌ Pedronꞌ toze. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kanaꞌll gokbeꞌe Pedronꞌ da likzenꞌ ballojeꞌ rill yanꞌ, naꞌll bneꞌe: —Nnaꞌll llreꞌraꞌ da likzenꞌ bseꞌl Diosenꞌ angl keꞌen, nench basreꞌe nadaꞌ rao naꞌa Herodes naꞌ, naꞌ rao yeolol da kaꞌ lleꞌne beꞌnn Israel kaꞌ gon akreꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Llontezeꞌ xhbab kanꞌ goken, ballinteꞌ rill María xhnaꞌ Juan Marcos, naꞌ llaꞌa beꞌnn zan llalwill akeꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ka bnne Pedronꞌ leꞌ zaguan naꞌ, byejdo to bi noꞌr re Rode jawiabeꞌ nonꞌ nne. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ka bayombiaꞌbeꞌ chiꞌi Pedronꞌ, bawebeꞌ kwis, naꞌ bi bsarjbeꞌ, zayejdobeꞌ jatixjweꞌbeꞌ beꞌnn kaꞌ yelaꞌ, ba ze Pedronꞌ lloaꞌ yoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Naꞌll lle beꞌnn kaꞌ bi noꞌrenꞌ: —¿Binꞌ ba llakroꞌ? Naꞌ zekzbeꞌ llebeꞌ leakeꞌ, Pedro naꞌn ze gannaꞌ. Naꞌll bne akeꞌ: —¿Kere angl ke Pedro naꞌn lla? ");
INSERT INTO zpuNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Naꞌll Pedronꞌ zekzeꞌ llnneꞌe lloaꞌ yoꞌn, naꞌll jasarj akeꞌ. Ka breꞌe akreꞌ leꞌen, llabán akreꞌ kwis. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Naꞌll Pedronꞌ beneꞌ sen ren taꞌkeꞌ nench bzo akeꞌ lli, naꞌ beꞌreneꞌ leakeꞌ diꞌll kanꞌ gok babej Xanllonꞌ leꞌe rill yanꞌ, leskaꞌ lleꞌe leakeꞌ: —Lechixjweꞌ Jacobonꞌ, naꞌ beꞌnn lwelljllo kaꞌ yelaꞌ kanꞌ ba goken. Naꞌll ballojeꞌ zayejeꞌ ga yobre. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bixha ka byeniꞌ, da xhen gokllejlaꞌll wakaꞌa ya kaꞌ, ke nak nollno Pedronꞌ yoꞌ lo rill yanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Naꞌll Herodes naꞌ, bseꞌleꞌ beꞌnne bayirj akeꞌ Pedronꞌ, naꞌ bi ballel akreꞌ leꞌe, naꞌll bnnabyollreꞌ wakaꞌa ya kaꞌ, akre gok ballojeꞌ, naꞌ wakaꞌa ya kaꞌ bibi gokse nne akeꞌ. Naꞌ bchoybieꞌ bet akeꞌ wakaꞌa ya kaꞌ gop rill yanꞌ. Naꞌll bzaꞌa Herodesenꞌ Judeanꞌ, naꞌ byejeꞌ jasoeꞌ yellenꞌ re Cesarea. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Rey Herodes naꞌ, llaklleꞌe beꞌnn yell kaꞌ nziꞌi Tiro, naꞌ Sidón. Naꞌll beꞌnn kaꞌ beꞌe akeꞌ diꞌll lljakeꞌ raweꞌn, naꞌ beꞌrén akeꞌ to beꞌnne diꞌll, beꞌnn nak rallnaꞌa ganꞌ nbane Herodes, beꞌnn re Blasto. Beꞌe akeꞌ leꞌe mell nench wdieꞌ xtiꞌll akeꞌ, naꞌ bnnabeꞌ yeniꞌt akeꞌ wen ren reyenꞌ, le yallj akreꞌ da yeꞌj gao akeꞌ ganꞌ nbane Herodes. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes naꞌ bzoeꞌ to lla lljak beꞌnn kaꞌ raweꞌn. Ka bllin llanꞌ, Herodes gokeꞌ xharaꞌneꞌ da chaꞌo, naꞌ bllieꞌ ganꞌ lloneꞌ yel koxchis, naꞌ broeꞌ lban rao beꞌnn Tiro, naꞌ beꞌnn Sidón kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ka bayoll broeꞌ lban naꞌ, besiaꞌ beꞌnn kaꞌ bne akeꞌ: —¡Kere beꞌnnachenꞌ bnne, Dioskzenꞌ ba bnne! ");
INSERT INTO zpuNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Rawe llak kaꞌn, to angl ke Xanllo Dios beneꞌ nench Herodes naꞌ, biaꞌzeꞌ to yillweꞌ, le bi beꞌraweꞌ Dios, beꞌe latj beꞌrao beꞌnn kaꞌ leꞌe. Naꞌ goteꞌ, naꞌ bdao bel daꞌo kaꞌ xpeꞌreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Zan ka nak xtiꞌll Xanllonꞌ, zejzell goslasen, naꞌ gateze ba lloeꞌ akeꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé ren Saulonꞌ, bayoll bi danꞌ ben akeꞌ Jerusalén naꞌ, naꞌ bazaꞌa akeꞌ zayej akeꞌ yellenꞌ nziꞌi Antioquíanꞌ, ncheꞌe akteꞌ beꞌnnenꞌ re Juan Marcos. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Radj beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ llaꞌa yellenꞌ nziꞌi Antioquíanꞌ, zjarén beꞌnn lloeꞌ xtiꞌll Diosenꞌ kon ka llzejnieꞌ Spíritu ke Diosenꞌ leakeꞌ. Naꞌ zjarén beꞌnn llak llroeꞌ llsede xtiꞌll Diosenꞌ, ki re bal akeꞌ: Bernabé, naꞌ Simón (beꞌnnenꞌ nsiꞌi akeꞌ Beꞌnn Gasj), Lucio beꞌnn Cirene, naꞌ Manaén (beꞌnn blliꞌorén Herodesenꞌ txhen, beꞌnnenꞌ llnebiaꞌ Galileanꞌ), naꞌ Saulo. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","To lla ka non akeꞌ was, naꞌ lloeꞌrao akeꞌ Dios, naꞌ llalwill akeꞌ Leꞌe, naꞌ bnne Spíritu keꞌen llen leakeꞌ: —Lekwej Bernabénꞌ ren Saulonꞌ, le ba bayaxh akeꞌ gon akeꞌ xchinaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Naꞌll bayoll ben akeꞌ was naꞌ, balwill akeꞌ Diosenꞌ, naꞌ bxoa taꞌk akeꞌ yichj Bernabénꞌ ren Saulonꞌ, naꞌll bsaꞌa akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Spíritu ke Diosenꞌ bseꞌlen Bernabénꞌ ren Saulonꞌ yellenꞌ re Seleucia, gannaꞌ byoꞌ akeꞌ barco bllin akteꞌ to yellrio, da lliꞌ radj nisdaꞌo ganꞌ nziꞌi Chipre. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ka bllin akeꞌ yellenꞌ nziꞌi Salamina, bzorao lljakeꞌ yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ lloeꞌrén akeꞌ leakeꞌ xtiꞌll Diosenꞌ. Naꞌ nao Juan Marcos naꞌ llakreneꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Naꞌ kaꞌ bde akeꞌ doxhen yellrionꞌ lliꞌ radj nisenꞌ, bllin akteꞌ yellenꞌ nziꞌi Pafos. Gannaꞌ jadiꞌ akreꞌ to beꞌnn Israel beꞌnn wallaꞌa re Barjesús, naꞌ ziyeꞌe beꞌnn kaꞌ neꞌe nakeꞌ beꞌnn lloeꞌ xtiꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Zoteze zoreneꞌ to beꞌnn wnebiaꞌ, to beꞌnn siꞌn re Sergio Paulo. Naꞌ beꞌnnenꞌ goxheꞌ Bernabénꞌ ren Saulonꞌ, lleꞌnreꞌ wzenayeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Naꞌ Barjesúsenꞌ, lekze nsiꞌi akeꞌ leꞌe Elimas, (diꞌll griego lleꞌnen nen beꞌnn wallaꞌa), ll-lloneꞌ wzenay beꞌnnenꞌ llnebiaꞌn bi lloeꞌ latj chejleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Naꞌll Saulonꞌ, lekze leꞌen re Pablonꞌ, ka nak yoeꞌ Spíritu ke Diosenꞌ, bwiachicheꞌ beꞌnn wallaꞌan. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Naꞌll lleꞌe leꞌe: —Beꞌnn wxhiyeꞌe, beꞌnn wen da xhinnj, xhiꞌnn daxiꞌo bi lloꞌraꞌlloꞌ da nak da wen. ¿Bat wsanoꞌ bill gonchixroꞌ yichjraꞌlldaꞌo beꞌnn kaꞌ, nench bi nnao akeꞌ diꞌll li ke Diosenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Naꞌ nnaꞌ Xantoꞌ Diosenꞌ wsaꞌkzieꞌ rweꞌ, wcholoꞌ to chiꞌi bi reꞌroꞌ beniꞌ. Le bcholte beꞌnnenꞌ, bxhoa bej raweꞌ, naꞌ deꞌe llganeꞌ no goꞌx taꞌkeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ka breꞌe beꞌnnenꞌ llnebiaꞌn kanꞌ goken naꞌ byejleꞌ, llabanreꞌ kwis kanꞌ nak xtiꞌll Xanllo Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Naꞌll Pablonꞌ ren beꞌnn lwelljeꞌ kaꞌ, bazaꞌa akeꞌ yellenꞌ re Pafos, byoꞌ akeꞌ barco bllin akteꞌ yellenꞌ nziꞌi Perge ganꞌ nbane Panfilia. Gannaꞌ bsanraꞌll Juan Marcos leakeꞌ, zayejeꞌ Jerusalén. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","To bde akzeꞌ Pergenꞌ, bllin akteꞌ yellenꞌ nziꞌi Antioquía ga nbane Pisidia. Ka bllin to lla nbaꞌnne, naꞌ jakeꞌ yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ jacheꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ka bayoll bel beꞌnn kaꞌ yich ganꞌ llia ley, danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, naꞌll beꞌnn kaꞌ llnebiaꞌ lo yodaꞌon, bseꞌl akeꞌ beꞌnn, jell akeꞌ Pablonꞌ ren Bernabénꞌ: —Beꞌnn biꞌch ake, chaꞌ bi diꞌll de weꞌrenre beꞌnn ki wak nnere nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Naꞌll bzollaꞌa Pablonꞌ, beneꞌ sen ren taꞌkeꞌn, nench bzo akeꞌ lli, naꞌ bneꞌe: —Reꞌ, beꞌnn Israel, naꞌ notezre llapre Diosenꞌ baraꞌnne lewzenay kanꞌ niaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios beꞌnnenꞌ lloeꞌraollo lliꞌo beꞌnn Israel, brejeꞌ xozxtaꞌollo kaꞌ, beneꞌ leakeꞌ to yell xhen kanꞌ bllaꞌa akeꞌ gok akeꞌ beꞌnn ziꞌt ganꞌ nziꞌi Egiptonꞌ. Naꞌ Diosenꞌ broeꞌreꞌ yel wak keꞌen ka nak bachacheꞌ leakeꞌ Egiptonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Diosenꞌ gokxhenreꞌ kanꞌ ben akeꞌ bllaꞌa akeꞌ latj dachenꞌ choa (40) iz. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Diosenꞌ banit balaneꞌ beꞌnn kaꞌ llaꞌa gall yellrio kaꞌ, nench beꞌe yellrionꞌ xozxtaꞌollo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","’Naꞌ rao tap gayoa chiyon (450) iz, Diosenꞌ brejeꞌ beꞌnn ben yel koxchis ke akeꞌ, nench bnebieꞌ leakeꞌ, ka gok bllinte lla bzo beꞌnnenꞌ re Samuel, beꞌnnenꞌ beꞌe xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Naꞌll bnnab akeꞌ so rey beꞌnn bnebiaꞌ leakeꞌ, naꞌ Diosenꞌ brejeꞌ beꞌnnenꞌ re Saúl, nench gokeꞌ rey choa iz. Saúlenꞌ gokeꞌ xhiꞌnn Cis, naꞌ gokeꞌ xhiꞌnn dialla ke Benjamín. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kat bllin lla bkwas Diosenꞌ Saúlenꞌ kaꞌle, naꞌ brejeꞌ David gokeꞌ rey, naꞌ bne Diosenꞌ ke Davidenꞌ: “David xhiꞌnn Isaínꞌ, leꞌe lloꞌraꞌllaꞌ, leꞌe goneꞌ danꞌ lleꞌnraꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Naꞌ rao dialla ke rey David naꞌ, gorj Jesús beꞌnnenꞌ yesrá lliꞌo beꞌnn Israel, kanꞌ bcheb Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka zayedtere Jesúsenꞌ, Juan naꞌ bdixjweꞌreꞌ beꞌnn Israel kaꞌ, llayaꞌl wayat akreꞌ ke da xhinnjenꞌ non akeꞌ, naꞌ choa akeꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ka ba zo rez wayoll xchin Juan naꞌ, bneꞌe: “Beꞌnnenꞌ bexhrenꞌ kere nadaꞌ, za zaꞌa to beꞌnn zaꞌkll ka nadaꞌ, bi zaꞌkaꞌ nadaꞌ ka Leꞌe, ni da wadechaꞌwaꞌ xhereꞌn nieꞌ, bi zaꞌkaꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Beꞌnn biꞌche, nakllo xhiꞌnn dialla da Abraham, naꞌ notezre llapre Diosenꞌ baraꞌnne, ke lliꞌon ba bseꞌl Diosenꞌ lloaꞌ xtiꞌlleꞌ danꞌ nsaꞌa yel wasrá. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ka nak beꞌnn kaꞌ llaꞌa Jerusalén naꞌ, naꞌ beꞌnn kaꞌ llnebiaꞌ leakeꞌ, bi bayakbeꞌe akreꞌ chaꞌ Diosenꞌ bseꞌl Jesúsenꞌ, naꞌ ni ke llejnieꞌ akzreꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, laꞌkze llaꞌa akeꞌ llol akeꞌn yeo lla nbaꞌnne. Naꞌ kaꞌ gok bzoa lloaꞌ xtiꞌll Diosenꞌ ka nak bchoybiaꞌ akeꞌ llayaꞌl gat Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Llwia akteꞌ bibi da xhinnj beneꞌ nench gateꞌ, naꞌ goll akseꞌ Pilatonꞌ llayaꞌl gat beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gok kaꞌ nench gok doxhen kanꞌ nyoj xtiꞌll Diosenꞌ gak ke Jesúsenꞌ. Naꞌ bayoll goteꞌ naꞌ, baletj akeꞌ Leꞌe leꞌ yay cruzenꞌ, naꞌ bkwaꞌch akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bixha Diosenꞌ basbaneꞌ Leꞌe radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naꞌ broeꞌraweꞌ beꞌnn kaꞌ ben Leꞌe txhen kanꞌ bzeꞌe Galileanꞌ bllinteꞌ Jerusalén naꞌ, zan lla bdareneꞌ leakeꞌ kanꞌ babaneꞌn. Naꞌ leakeꞌn lloeꞌ xtiꞌll Jesucristonꞌ rao beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Naꞌ nnaꞌ netoꞌ leskaꞌ llyixjweꞌtoꞌ reꞌ kanꞌ nak Diꞌll Wen ke Jesucristonꞌ, diꞌll danꞌ bcheb Diosenꞌ ren xozxtaꞌollo kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lliꞌo nakllo xhiꞌnn dialla ke akeꞌ, naꞌ lliꞌo llreꞌllo ba llon Diosenꞌ ka danꞌ golleꞌ leakeꞌn, danꞌ basbaneꞌ Jesúsenꞌ. Kanꞌ nyojkze salmo wllopenꞌ nen: “Xhiꞌnnkzaꞌ rweꞌ, nadaꞌ gonnaꞌ rweꞌ yel nban.” ");
INSERT INTO zpuNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Danꞌ basbaneꞌ Jesúsenꞌ, bill weꞌe latj gateꞌ da yobre, leskaꞌ nen: “Naꞌ gonnaꞌ rweꞌ yel nak laꞌye danꞌ bchebaꞌ waꞌa Davidenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ke len naꞌ leskaꞌ ne leꞌ yich ke to salmo yobre: “Bi weꞌo latj goꞌll xpeꞌraꞌn, nadaꞌ nakaꞌ rallnaꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Da li naken, Davidenꞌ bzoeꞌ gokreneꞌ xozxtaꞌollo kaꞌ kon ka broeꞌ Diosenꞌ leꞌe. Bde naꞌ, goteꞌ jayeneꞌ txhen xozxtaꞌollo kaꞌ ba got, naꞌ goꞌll xpeꞌr Davidenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Zan ka nak beꞌnnenꞌ basbán Diosenꞌ, bi goꞌll xpeꞌreꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Naꞌ llayaꞌl nnézere, beꞌnn biꞌchaꞌ, Jesucristonꞌ beꞌnnenꞌ lloeꞌtoꞌ xtiꞌlleꞌn, Leꞌe yeziꞌxheneꞌ ke yeolol beꞌnne chaꞌ gonliraꞌll akeꞌ Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ka nak ley danꞌ bzoj da Moisésenꞌ, bi llzoen yelanen da xhinnj kellonꞌ, zan Jesucristonꞌ Leꞌen yenit yelaneꞌ da xhinnj kellonꞌ, chaꞌ lliꞌo wxenraꞌll-lloeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lewiá, ke gak keré kanꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, ganꞌ nen: ");
INSERT INTO zpuNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Lewayón xhbab beꞌnn lltitje, Legón yel wan, naꞌ lewxhonnje. Nadaꞌ Dios gonaꞌ to da yebánere chak nbanre, naꞌ laꞌkze weꞌrén akteꞌ reꞌ diꞌll, ni ke chejleꞌzre. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ka balloj Pablonꞌ ren beꞌnn lwelljeꞌ kaꞌ lo yodaꞌon, beꞌnn kaꞌ bi nak beꞌnn Israel goꞌtyoe akreꞌ leakeꞌ, nench kat wazó xhman naꞌ, lljakeꞌ da yobre lljazejnieꞌ akreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ka ballach akeꞌn, beꞌnn zan beꞌnn Israel kaꞌ, naꞌ leskaꞌ beꞌnn kaꞌ ba nao llon kanꞌ ne ley ke beꞌnn Israel kaꞌ, bnao akeꞌ Pablonꞌ ren Bernabénꞌ. Naꞌ basyoll Pablonꞌ ren Bernabénꞌ broeꞌ akreꞌ leakeꞌ, naꞌ goll akeꞌ leakeꞌ seteze se akeꞌ wxenraꞌll akeꞌ Dios, beꞌnnenꞌ nllieꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bixha ka bazó xhman lla nbaꞌnne, yeolol kaze beꞌnn yell badop bzenay akeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bixha beꞌnn Israel kaꞌ, ka breꞌe akreꞌ beꞌnn zan kaꞌ, baxhéꞌ akreꞌ postl kaꞌ, naꞌ ka nne Pablonꞌ, llalliꞌi akteꞌ xtiꞌlleꞌn, naꞌ llaꞌdyiꞌ akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bixha Pablonꞌ ren Bernabénꞌ bi lleb akeꞌ lloeꞌ akeꞌ diꞌllenꞌ, naꞌ lle akeꞌ beꞌnn kaꞌ: —Ba bentoꞌ bien ba bzejnieꞌtoꞌ zgaꞌtek reꞌ beꞌnn Israel xtiꞌll Diosenꞌ, naꞌ ka nak ll-llon yichjraꞌlldaꞌore, bi lloꞌraꞌllre xtiꞌlleꞌ danꞌ nsaꞌa yel nban zejlikane, naꞌ wayejlltoꞌ ganꞌ llaꞌa beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Le kaꞌkzenꞌ bne Xantoꞌ Diosenꞌ golleꞌ netoꞌ: Ni nzoaꞌ rweꞌ gakoꞌ beniꞌ ke beꞌnn kaꞌ bi nak beꞌnn Israel, nench beꞌnn kaꞌ llaꞌa doxhen yellrio, gakbeꞌe akreꞌ wak yerá akeꞌ rao da xhinnj ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Naꞌll beꞌnn kaꞌ bi nak beꞌnn Israel, ka ben akreꞌ kaꞌ, llawé akreꞌ kwis, naꞌ ne akeꞌ wen kwis nak xtiꞌll Xanllo. Naꞌ byejleꞌ yeolol beꞌnn kaꞌ ba brej Diosenꞌ gaꞌt yel nban zejlikane ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kaꞌ gok, doxhen ganꞌ nziꞌi Pisidia, bnnez akreꞌ xtiꞌll Xanllo Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bixha beꞌnn Israel kaꞌ, bkoꞌyel akreꞌ bal noꞌr brao kaꞌ, nench ben akeꞌ txhen koxchis kaꞌ, naꞌ bzorao bdilrén akeꞌ Pablonꞌ ren Bernabénꞌ, ben akteꞌ gan babej akeꞌ leakeꞌ yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Naꞌll postl kaꞌ balloj akeꞌ yellenꞌ, babib akteꞌ no bichte bllia niaꞌ akeꞌ, nench bayakbeꞌe beꞌnn kaꞌ krerenꞌ ben akeꞌ. Naꞌ bazaꞌa akeꞌ ballín akteꞌ yellenꞌ re Iconio. ");
INSERT INTO zpuNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yeolol beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ, llaꞌa akeꞌ llawé akreꞌ kwis, naꞌ Spíritu ke Diosenꞌ llnebiaꞌn yichjraꞌlldaꞌo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Naꞌ gok ka bllin Pablonꞌ ren Bernabénꞌ yellenꞌ nziꞌi Iconio, jakeꞌ yodaꞌo ke beꞌnn Israel kaꞌ. Naꞌ jazejnieꞌ akreꞌ xtiꞌll Diosenꞌ kwasro, naꞌ beꞌnn zan benliraꞌll Jesucristonꞌ ka beꞌnn Israel naꞌ ren beꞌnn griego kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Naꞌ beꞌnn Israel kaꞌ bi nxenraꞌll Jesucristonꞌ, bkoꞌyel akreꞌ beꞌnn kaꞌ bi nak beꞌnn Israel, nench gok akreꞌ Pablo ren Bernabénꞌ beꞌnn wen da xhinnj ak. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ni ke len naꞌ bagaꞌnn akeꞌ scha Iconionꞌ, lloeꞌ akeꞌ xtiꞌll Xanllonꞌ, ni ke lleb akzeꞌ, llroeꞌ akreꞌ kanꞌ nllieꞌ Diosenꞌ beꞌnn kaꞌ. Naꞌ Diosenꞌ llroeꞌreꞌ diꞌll likzenꞌ lloeꞌ akeꞌ, ke nak beꞌe leakeꞌ yel wak, naꞌ llon akeꞌ da yebánello. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Naꞌ beꞌnn Iconio kaꞌ gok akeꞌ chopre, bal akeꞌ bdaꞌa beꞌnn Israel kaꞌ, naꞌ ye bal akeꞌ bdaꞌa postl kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Naꞌ beꞌnn Israel kaꞌ, naꞌ ren beꞌnn kaꞌ bi nak beꞌnn Israel, gok akeꞌ toze ren koxchis kaꞌ, naꞌ bziꞌchiꞌll akeꞌ Pablonꞌ ren Bernabénꞌ, naꞌ lleꞌn akreꞌ wchekw akeꞌ leakeꞌ yej. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ka gokbeꞌe Pablonꞌ ren Bernabénꞌ kaꞌ, naꞌll bazaꞌa akeꞌ jakeꞌ yell kaꞌ nziꞌi Listra, naꞌ Derbe ga nbane Licaonia. Naꞌ jatá akeꞌ yell kaꞌ lliꞌ do kwite, ");
INSERT INTO zpuNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","naꞌ gannaꞌ jatixjweꞌ akreꞌ Diꞌll Wen ke Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ganꞌ ne Listra jadiꞌ akreꞌ to beꞌnn nxhinnj niaꞌ ka gorjte, naꞌ bi llak seꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Bixha ka llzenayeꞌ diꞌllenꞌ lloeꞌ Pablonꞌ ren Bernabénꞌ, Pablonꞌ bwiayaꞌnneꞌ leꞌe, naꞌ gokbeꞌreꞌ nxenraꞌlleꞌ wayakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Naꞌ goll Pablonꞌ leꞌe zillj: —¡Balí niaꞌon, naꞌ bazollaꞌa! Naꞌ le bazollaꞌte beꞌnnenꞌ, bxhiꞌteꞌ naꞌ le gokte bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Beꞌnn Listra kaꞌ, ka breꞌe akreꞌ kanꞌ ben Pablonꞌ, bzorao llosiaꞌ akeꞌ nne xtiꞌll akeꞌ, ne akeꞌ: —¡Dios aksenꞌ ba betj radjllonꞌ, nak akeꞌ ka beꞌnne! ");
INSERT INTO zpuNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Naꞌ bne akeꞌ Bernabénꞌ nakeꞌ dios ke akeꞌ, beꞌnn re Júpiter, naꞌ Pablonꞌ nakeꞌ dios beꞌnn re Mercurio, le leꞌen lloeꞌ diꞌllenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Naꞌ bxoz ke Júpiter naꞌ, ke nak yodaꞌo keꞌen zon lloaꞌ yellre, jaxieꞌ bal bell, naꞌ benchaꞌweꞌ yeje, naꞌ jwaꞌa akeꞌn ganꞌ llaꞌa akeꞌ ren beꞌnn zan kaꞌ, gokraꞌll akeꞌ got akeꞌ bell, nench weꞌrao akeꞌ postl kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ka gokbeꞌe Bernabénꞌ ren Pablonꞌ kanꞌ lleꞌne beꞌnn kaꞌ gon akeꞌn, naꞌll bcheꞌz xharaꞌn akeꞌ, nench broeꞌ akreꞌ beꞌnn kaꞌ, krerenꞌ llon akeꞌ, naꞌ bde akeꞌ radj beꞌnn zan kaꞌ llosiaꞌ akeꞌ, lle akeꞌ leakeꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Reꞌ, beꞌnne, ¿bixchen llonre kaꞌ? Lekze beꞌnnachkze netoꞌ, zaꞌtoꞌ llzejnieꞌtoꞌ reꞌ, llayaꞌl wsanraꞌllre danꞌ naore naꞌ, da bi zaꞌke, naꞌ wayoeꞌraore Dios beꞌnn nban zejlikane, beꞌnn ben yebá, yellrio naꞌ nisdaꞌo, naꞌ beneꞌ yeolol da zjadé. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Do batnaꞌ beꞌe latj ben beꞌnn kaꞌ ka nezen ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Naꞌ bzekzeꞌ gokreneꞌ yeolol beꞌnne, nench bnnez akreꞌ zokzeꞌ, naꞌ Lekzeꞌn lloneꞌ llak yejw nench llak bi da llaz llaꞌnnllo, naꞌ de da lleꞌj llaollo, naꞌ zollo nbaraz. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Da zan da goll akeꞌ beꞌnn kaꞌ, ganne bzoe akreꞌ bi bet beꞌnn Listra kaꞌ bell kaꞌ, weꞌrao akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nna llakte kaꞌn, bllin beꞌnn Israel kaꞌ zaꞌk yell kaꞌ nziꞌi Antioquía ren Iconio, naꞌ benchix akreꞌ beꞌnn kaꞌ, nench bill byejleꞌ akeꞌ ke postl kaꞌ. Naꞌ bchekw akeꞌ Pablonꞌ yej. Naꞌ llak akreꞌ chaꞌ ba goteꞌn, naꞌll bxhob akeꞌ leꞌe brej akteꞌ leꞌe yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ bdop akeꞌ byechj akeꞌ Pablonꞌ ganꞌ deꞌen, naꞌll bayaseꞌ naꞌ bayoeꞌ yell. Bateyó bagoꞌ Pablonꞌ ren Bernabénꞌ nez, jayakeꞌ ganꞌ nziꞌi Derbe. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ka ballín akeꞌ naꞌ, bdixjweꞌ akreꞌ beꞌnne kanꞌ nak Diꞌll Wen ke Jesucristonꞌ, naꞌ beꞌnn zan benliraꞌll akeꞌ Xanllonꞌ. Bde naꞌ, bzaꞌa akeꞌ ballín akteꞌ Listra, naꞌll Iconio, naꞌtell ballín akeꞌ Antioquía. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Toto yell ga badé akeꞌ, beꞌltipraꞌll akeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, lle akeꞌ leakeꞌ: —Yezikre lesé war ka naken ba nxenraꞌllre Jesucristonꞌ, dekz de yellayraollo chak bexhllo yeyejllo ganꞌ llnebiaꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Leskaꞌ toto yell ganꞌ badé akeꞌn, brej akeꞌ beꞌnn gor llejnieꞌ, nench se akeꞌ wia akeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ. Naꞌ bayoll ben akeꞌ was, balwill akeꞌ Diosenꞌ, naꞌ ben akeꞌ leakeꞌ rallnaꞌa Xanllonꞌ, beꞌnnenꞌ bakze llonliraꞌll akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ka zayoꞌ Pablonꞌ ren Bernabénꞌ nezenꞌ, bde akeꞌ ga nziꞌi Pisidia, naꞌll ballín akteꞌ ganꞌ nziꞌi Panfilia. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ka bayoll beꞌe akeꞌ xtiꞌll Diosenꞌ yellenꞌ re Perge, naꞌll bazaꞌa akeꞌ ballín akteꞌ yellenꞌ re Atalia. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Gannaꞌ byoꞌ akeꞌ barco, naꞌ ballín akteꞌ Antioquía ganꞌ nbane Siria, le kanaꞌ ben beꞌnn Antioquía kaꞌ leakeꞌ rallnaꞌa Dios, kanꞌ blloj akeꞌ jatixjweꞌ akreꞌ xtiꞌlleꞌn danꞌ ballín akteꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ka ballín akeꞌn, batop akeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ beꞌrén akeꞌ leakeꞌ diꞌll kanꞌ gokrén Diosenꞌ leakeꞌ, broeꞌreꞌ da zan da yebánello ganꞌ jatá akeꞌn, naꞌ kanꞌ ben Xanllonꞌ bsarjeꞌ yichjraꞌlldaꞌo beꞌnn kaꞌ bi nak beꞌnn Israel nench byejleꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naꞌ goꞌy akeꞌ scha ren beꞌnn kaꞌ ba llonliraꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kanꞌ llak kaꞌ, bal beꞌnn bzaꞌa yell kaꞌ ganꞌ nbane Judeanꞌ, bllin akeꞌ Antioquía naꞌ, naꞌ bzorao llsed akreꞌ beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ, ne akeꞌ: —Chaꞌ bi sore sen danꞌ nziꞌi circuncisión kanꞌ ne ley danꞌ bzoj da Moisésenꞌ, bi gak yerare rao da xhinnjenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablonꞌ ren Bernabénꞌ llakdilrén akeꞌ beꞌnn kaꞌ, bixchen llroeꞌ akreꞌ leakeꞌ kaꞌ. Naꞌll beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ llaꞌa Antioquíanꞌ, beꞌe akeꞌ diꞌll lljak Pablonꞌ ren Bernabénꞌ ren ye bal beꞌnn lwellj akeꞌ kaꞌ Jerusalén naꞌ, nench lljaraꞌnn akeꞌ postl kaꞌ, naꞌ beꞌnn gor brao ke beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ lljeꞌrén akeꞌ leakeꞌ diꞌlle, akre gak ke danꞌ llroeꞌ beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ke len naꞌ, beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ llaꞌa Antioquíanꞌ, bseꞌl akeꞌ leakeꞌ Jerusalén naꞌ. Ka zjakeꞌn bde akeꞌ yell kaꞌ ganꞌ nziꞌi Fenicia, naꞌll ganꞌ nziꞌi Samaria. Lloeꞌrén akeꞌ beꞌnn kaꞌ diꞌll kanꞌ ba bachaꞌa yichjraꞌlldaꞌo beꞌnn kaꞌ bi nak beꞌnn Israel, ba llzenay akeꞌ ke Dios. Naꞌ beꞌnn kaꞌ nak leakeꞌ txhen naꞌ, llawé akreꞌ kwis ka llen akreꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ka bllin akeꞌ Jerusalén naꞌ, beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ, naꞌ beꞌnn gor brao ke akeꞌ kaꞌ, naꞌ postl kaꞌ, bwap akeꞌ leakeꞌ lliox. Naꞌ Pablonꞌ ren Bernabénꞌ beꞌrén akeꞌ leakeꞌ diꞌll kanꞌ ba gokrén Diosenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bixha bal beꞌnn fariseo kaꞌ ba llejleꞌ ke Jesucristonꞌ, bzollaꞌa akeꞌ, naꞌ bne akeꞌ: —Llonen bien noteze beꞌnn byio wxenraꞌll Jesucristonꞌ, llayaꞌl soeꞌ sen danꞌ nziꞌi circuncisión, naꞌ llayaꞌl gon akeꞌ kanꞌ ne ley danꞌ bzoj da Moisésenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Naꞌll badop postl kaꞌ, naꞌ beꞌnn gor brao kaꞌ, nench wayej diꞌll akre gaksen. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bixha ba gokte scha llayej diꞌllenꞌ, kat bzollaꞌa Pedronꞌ, naꞌ bneꞌe: —Reꞌ, beꞌnn biꞌchaꞌ, nnézkzere kwasro kanꞌ gok batnaꞌ, Diosenꞌ brejeꞌ nadaꞌ jazejnieꞌraꞌ xtiꞌll Jesucristonꞌ beꞌnn kaꞌ bi zjanak beꞌnn Israel, nench chejleꞌ akeꞌ keꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Diosenꞌ nnezreꞌ ka nak yichjraꞌlldaꞌo yeolol beꞌnne, leskaꞌ broeꞌreꞌ nllieꞌreꞌ leakeꞌ, ka nak beꞌe leakeꞌ Spíritu keꞌen kanꞌ beneꞌ ke lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Toz ka ben Diosenꞌ kello, naꞌ ren leakeꞌ, lekze ba bayibeꞌ yichjraꞌlldaꞌo akeꞌ, ni ke danꞌ nxenraꞌll akeꞌ Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Naꞌ nnaꞌ, ¿bixchen bikze llejleꞌre, ba llwiátere danꞌ llon Diosenꞌ? Bi llayaꞌl wchieꞌllo beꞌnn kaꞌ bi nak beꞌnn Israel, gon akeꞌ ke danꞌ llon lliꞌo beꞌnn Israel, nnéztello ni lliꞌo, ni xozxtaꞌollo kaꞌ, bi gok gon akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nnéztello kere ni ke danꞌ gonllo kanꞌ ne ley naꞌn, yesrá Diosenꞌ lliꞌo, le ni ke danꞌ nllieꞌreꞌ lliꞌon, naꞌllenꞌ yesreꞌe lliꞌo, naꞌ kaꞌkze yesreꞌe noteze beꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Naꞌll billbi bnekze beꞌnn zan kaꞌ, naꞌll bllaꞌa akeꞌ lli chak bzenay akeꞌ lloeꞌ Pablonꞌ ren Bernabénꞌ diꞌll kanꞌ gokrén Diosenꞌ leakeꞌ, ben akeꞌ da zan da yebánello radj beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ka bayoll bnne akeꞌ naꞌ, bzollaꞌa Jacobonꞌ bneꞌe: —Beꞌnn biꞌchaꞌ, lewzenay kiaꞌ choll. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedronꞌ ba beꞌe diꞌll kanꞌ bzorao broeꞌ Diosenꞌ yel wak keꞌen ren beꞌnn kaꞌ bi nak beꞌnn Israel, naꞌ brejeꞌ baleꞌ nench gok akeꞌ to yell ke Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Danꞌ llak kaꞌ, llatilen ke danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Te naꞌ yedaꞌ da yobre, kanaꞌ gonaꞌ nench nnebiaꞌ xhiꞌnn dialla ke rey Davidenꞌ, laꞌkze ba nak akeꞌ ka to yoꞌ da ba bayinnje, naꞌ nadaꞌ wayonaꞌn, walisaꞌn wayontiaꞌn ka wazón war, ");
INSERT INTO zpuNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","gonaꞌ kaꞌ nench beꞌnn kaꞌ bi zjanak beꞌnn Israel, wayirj akeꞌ nadaꞌ nakaꞌ Xan akeꞌ, naꞌ noteze beꞌnn yellrio wak walwilleꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kanꞌ ne Xanllo Diosenꞌ llyixjweꞌreꞌ lliꞌo da ki kanꞌ batnaꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Ke len naꞌ, niaꞌ beꞌnn kaꞌ bi nak beꞌnn Israel, bi llayaꞌl gon akelloeꞌ zed, chaꞌ ba llayechj akeꞌ llonliraꞌll akeꞌ Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","To da gonllo, wzojllo to yich, naꞌ ye aklloeꞌ bi gao akeꞌ no yel wao da ba bxhoa no rao lwaꞌa lsaꞌke, naꞌ chaꞌ bi nchaynaꞌa akeꞌ, bi gak sorén lwellj akeꞌ, naꞌ bi gao akeꞌ bayiꞌx ba llchok akeꞌ yen, naꞌ leskaꞌ bi gao akeꞌ llen naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ka nak ley danꞌ bzoj da Moisésenꞌ kanaꞌte, llaꞌkze beꞌnn toto yell llzejnieꞌ akreꞌn, katenꞌ lladop akeꞌ lla nbaꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Naꞌ postl kaꞌ, naꞌ beꞌnn gor brao kaꞌ, naꞌ yeolol beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ, bayazraꞌll akeꞌ kanꞌ bne Jacobonꞌ. Naꞌ beꞌe akeꞌ diꞌll kwej akeꞌ chop beꞌnn lwellj akeꞌ kaꞌ, naꞌ wseꞌlrén akeꞌ leakeꞌ Antioquíanꞌ ren Pablonꞌ naꞌ Bernabénꞌ. Naꞌ brej akeꞌ Judas lekze nzieꞌ Barsabás, naꞌ Silas, beꞌnn kaꞌn nak beꞌnn brao radj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Naꞌ bzoj akeꞌ to yich beꞌx beꞌnn kaꞌ, yichenꞌ nen: “Netoꞌ postl, naꞌ ren beꞌnn gor brao kaꞌ, naꞌ ren beꞌnn biꞌchllo kaꞌ, llwaptoꞌ reꞌ lliox, reꞌ llaꞌre Antioquía, naꞌ Siria, naꞌ Cilicia. Nakllo txhen llonliraꞌll-llo Jesucristonꞌ, laꞌkze bi nakre beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ba bnnézetoꞌ bal beꞌnn blloj radjtoꞌ ni, braꞌ akeꞌ ganꞌ llaꞌrenꞌ lloeꞌ akeꞌ diꞌll wenraꞌll, naꞌ llonchix akreꞌ reꞌ, ne akeꞌ llayaꞌl sore sen danꞌ nziꞌi circuncisión, naꞌ gonre yeolol billre kanꞌ ne ley danꞌ bzoj da Moisésenꞌ. Kere netoꞌ bseꞌltoꞌ beꞌnn ki, byaꞌzeraꞌll akeꞌn llon akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ni ke len naꞌ, ba beꞌtoꞌ toze diꞌlle, naꞌ ba brejtoꞌ chop beꞌnn nench yedwia akeꞌ reꞌ, naꞌ llseꞌl aktoeꞌ ren beꞌnn biꞌchllo ki nllieꞌtoꞌ kwis, Pablo naꞌ ren Bernabénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ke nak beꞌnn ki ba bzoa yel nban ke akeꞌn rao da nxholl, ni ke Xanllo Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ganni llseꞌltoꞌ Judas ren Silas, leakeꞌ weꞌrén akseꞌ reꞌ diꞌll lloaꞌ akeꞌ, danꞌ ba nlliatoꞌ leꞌ yich nga. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Llawetoꞌ ka nak Spíritu ke Diosenꞌ ba bzejnieꞌn netoꞌ, akre nnetoꞌ nench bi wchieꞌtoꞌ reꞌ gonre billre, lete ka nak da brao ki: ");
INSERT INTO zpuNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bi gaore yel wao da ba bllia akeꞌ rao lwaꞌa lsaꞌk Dios, bi gaore llen, naꞌ bi gaore no bayiꞌx ba llchoke yen, leskaꞌ chaꞌ bi nchaynaꞌre, bi gak sorén lwelljre. Chaꞌ wzenayre da ki, da wen kwis gonre. Chaꞌchgare wen.” ");
INSERT INTO zpuNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kaꞌ gok, naꞌ bzaꞌa beꞌnn kaꞌ, zjakeꞌ Antioquíanꞌ, ka bllin akeꞌ naꞌ, batop akeꞌ yeolol beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, naꞌ bayoeꞌ akeꞌ leakeꞌ yichenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ka bayoll bel akeꞌ yichenꞌ, llawé beꞌnn kaꞌ kwis, le da xhen llayoeꞌxhenen leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Naꞌll ka nak Judasenꞌ ren Silas naꞌ, llak lloeꞌ akeꞌ xtiꞌll Diosenꞌ kon ka llzejnieꞌ Spíritu ke Diosenꞌ leakeꞌ, ye to chiꞌi bayonxhenraꞌll akeꞌ leakeꞌ, beꞌrén akeꞌ leakeꞌ diꞌll nniꞌtteze nniꞌt akeꞌ gonliraꞌll akeꞌ Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ka gok scha daꞌo bzorén akeꞌ leakeꞌ, bllin lla yezaꞌa akeꞌ, naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, bagoꞌ akeꞌ leakeꞌ nez, lle akeꞌ leakeꞌ: —Wallinchgare wen ganꞌ bzaꞌrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bixha Silas naꞌ, byazraꞌlleꞌ gaꞌyeꞌ gannaꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Leskaꞌ Pablo ren Bernabénꞌ goꞌy akeꞌ ren ye txhonnj beꞌnn zej ren leakeꞌ txhen Antioquíanꞌ, broeꞌ bsed akreꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ka bde zan lla, Pablonꞌ lleꞌe Bernabénꞌ: —Chejllo da yobre ganꞌ ba jatallo jatixjweꞌllo xtiꞌll Xanllo Jesucristonꞌ, lljawiallo akre llaꞌa beꞌnn biꞌchllo kaꞌ ba nxenraꞌll Leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Naꞌll Bernabénꞌ lleꞌnreꞌ wcheꞌe akeꞌ beꞌnnenꞌ re Juan Marcos. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Naꞌ Pablonꞌ llakreꞌ bi gonen wen wcheꞌe akeꞌ leꞌe, le bsanraꞌlleꞌ leakeꞌ ganꞌ nziꞌi Panfilia, bill bnaweꞌ gakreneꞌ gon akeꞌ xchin Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ni ke len naꞌ, bi gokse gon akeꞌ toze diꞌlle, naꞌ braꞌa lwellj akeꞌ. Naꞌ bzaꞌa Bernabénꞌ ncheꞌe Juan Marcos, naꞌ byoꞌ akeꞌ barco zjakeꞌ yellrio danꞌ lliꞌ lo nisdaꞌo ganꞌ nziꞌi Chipre. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Leskaꞌ Pablonꞌ bzeꞌe ncheꞌe beꞌnnenꞌ re Silas, naꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ llaꞌa Antioquíanꞌ, ben akeꞌ leakeꞌ rallnaꞌa Dios, ka nak bzaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Naꞌll Pablonꞌ ren Silas naꞌ, ka zjakeꞌn, bde akteꞌ yell kaꞌ ganꞌ nziꞌi Siria, naꞌ ganꞌ nziꞌi Cilicia, naꞌ llgoꞌltip akeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ toto yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Naꞌ bllin Pablonꞌ ren Silas yell kaꞌ re Derbe naꞌ Listra. Gannaꞌ jadiꞌ akreꞌ to beꞌnn re Timoteo, naꞌ nxenraꞌlleꞌ Jesucristonꞌ, xhnaꞌ Timoteonꞌ nakeꞌ beꞌnn Israel, leskaꞌ nxenraꞌlleꞌ Jesucristonꞌ, naꞌ xeꞌe nakeꞌ beꞌnn griego. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ llaꞌa Listra, naꞌ Iconio, lloeꞌ akeꞌ diꞌll nak Timoteonꞌ beꞌnn wen. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablonꞌ byazraꞌlleꞌ wcheꞌe leꞌe, naꞌ zgaꞌtek bzoeꞌ leꞌe sen danꞌ nziꞌi circuncisión, nench bibi de nne beꞌnn Israel kaꞌ llaꞌa do gannaꞌ, le nnez akreꞌ xeꞌen bi nakeꞌ beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Naꞌ yeololte yell ganꞌ bde akeꞌn, bdixjweꞌ akreꞌ beꞌnn kaꞌ ba nxenraꞌll Jesucristonꞌ kanꞌ llayaꞌl gon akeꞌ, kanꞌ bne postl kaꞌ, naꞌ ren beꞌnn gor brao kaꞌ llaꞌa Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Naꞌ Beꞌnn kaꞌ ba lldop ll-llay llonliraꞌll Jesucristonꞌ, toto yell yezikre llxenraꞌll akeꞌ Leꞌe, naꞌ tlla tlla zjazell llan akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Spíritu ke Diosenꞌ bi beꞌn latj weꞌe akeꞌ xtiꞌll Diosenꞌ yell kaꞌ ganꞌ nziꞌi Asia, naꞌll to bde akzeꞌ yell kaꞌ ganꞌ nziꞌi Frigia naꞌ Galacia. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bllin akteꞌ ganꞌ nziꞌi Misia, naꞌ gokraꞌll akeꞌ lljakeꞌ yell kaꞌ do ganꞌ nziꞌi Bitinia, leskaꞌ bi beꞌe Spíritu ke Diosenꞌ latj. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Naꞌll to bde akzeꞌ Misia, bllin akteꞌ yellenꞌ re Troas. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Rao lleꞌ naꞌ, breꞌdaꞌwe Pablonꞌ, breꞌreꞌ to beꞌnn Macedonianꞌ llaꞌtyoereꞌ leꞌe, lleꞌe leꞌe: “Yoꞌo Macedonianꞌ nench gakrenoꞌ netoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kate bde gok kaꞌ, le bsiniaꞌte ketoꞌ chejtoꞌ yell kaꞌ do ganꞌ nziꞌi Macedonianꞌ, le byejnieꞌtoꞌ Dios naꞌkzenꞌ llseꞌleꞌ netoꞌ chixjweꞌtoꞌ Diꞌll Wen ke Jesucristonꞌ gannaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas naꞌ byoꞌtoꞌ barco da zej lixhej ganꞌ ne Samotracia, to yellrio da lliꞌ kllol nis, naꞌ bateyó naꞌ bllintoꞌ yellenꞌ re Neápolis. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Neápolis naꞌ bzaꞌtoꞌ, naꞌ bllintoꞌ yellenꞌ re Filipos ganꞌ nbane Macedonia, Filipos naꞌ naken to yell brao ga llaꞌa beꞌnn Roma, naꞌ bzotoꞌ to chiꞌi gannaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","To lla nbaꞌnne ke beꞌnn Israel kaꞌ, bllojtoꞌ yellenꞌ byejtoꞌ lloaꞌ yeo ga lladop akeꞌ llalwill akeꞌ Diosenꞌ, naꞌ blleꞌtoꞌ beꞌrentoꞌ bal noꞌr kaꞌ bllayenꞌ diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Radj noꞌr kaꞌ ren to noꞌr re Lidia, beꞌnn yellenꞌ re Tiatira, naꞌ non xchineꞌ lloꞌteꞌ raꞌll chaꞌo da morad. Lidianꞌ lloeꞌraweꞌ Dios, naꞌ llieꞌ llzenayeꞌ, naꞌ Xanllo Diosenꞌ bsarjeꞌ yichjraꞌlldaꞌweꞌ nench bzenayeꞌ kanꞌ ne Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Naꞌ kaꞌ blloeꞌ nis ren beꞌnn kaꞌ llaꞌa rilleꞌn, naꞌ goꞌtyoereꞌ netoꞌ neꞌe: —Chaꞌ ba llakliere danꞌ ba llonliraꞌllaꞌ Xanllonꞌ, lechoꞌo rillaꞌ, naꞌ sore. Naꞌll bchieꞌreꞌ netoꞌ nench byejtoꞌ rilleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gok ye to lla chak zejtoꞌ lljeꞌrentoꞌ Diosenꞌ diꞌlle, balláyetoꞌ to bi noꞌre, yoꞌbeꞌ daxiꞌo da llanneyaꞌ. Da xhen llon xanbeꞌ gan ke danꞌ llanneyaꞌbeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naꞌll badnnaobeꞌ netoꞌ ren Pablo naꞌ, llosiaꞌbeꞌ nebeꞌ: —¡Beꞌnn kinꞌ llon akeꞌ xchin Dios, beꞌnn zo yebá, naꞌ llyixjweꞌ akreꞌ akre nak nez ke Diosenꞌ danꞌ nsaꞌa yel wasrá! ");
INSERT INTO zpuNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Naꞌ kaꞌ llonbeꞌ naobeꞌ netoꞌ gokte zan lla, naꞌ bi byazraꞌll Pablonꞌ kanꞌ llonbeꞌ, naꞌ bayechjeꞌ, lleꞌe daxiꞌon yoꞌ yichjraꞌlldaꞌo bi noꞌrenꞌ: —Kone yel wak ke Jesucristo, llepaꞌ rweꞌ yellojoꞌ yichjraꞌlldaꞌo bi noꞌrenꞌ. Naꞌll le ballojten. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bixha ka gokbeꞌe beꞌnn kaꞌ nak xan bi noꞌrenꞌ, naꞌ zerao yel wniaꞌ ke akeꞌn, ka nak ba balloj yel llnneyaꞌ ke bi noꞌrenꞌ, naꞌ beꞌx akeꞌ Pablonꞌ ren Silas, naꞌ jwaꞌa akeꞌ leakeꞌ lao yaꞌa ganꞌ llaꞌa beꞌnn kaꞌ llnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ka bllin akeꞌ rao koxchis kaꞌ, lle akeꞌ leakeꞌ: —Beꞌnn Israel ki da akeꞌ llta llnne akeꞌ beꞌnn rao yell kellonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Llroeꞌ akreꞌ leakeꞌ to da yobre da bi gak nnao lliꞌo, naꞌ bi llayaꞌl gonllon nakllo beꞌnn Roma. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Naꞌll bdop beꞌnn zan goꞌdyiꞌ akeꞌ Pablonꞌ ren Silas, naꞌ golj akeꞌ xharaꞌn akeꞌn, naꞌ koxchis kaꞌ goll akeꞌ beꞌnn kaꞌ bdin akeꞌ leakeꞌ xhis. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bayoll bdintat akeꞌ leakeꞌ, naꞌll broꞌ akeꞌ leakeꞌ rill ya, naꞌ goll akeꞌ beꞌnnenꞌ llap rill yanꞌ wsejeꞌn da war. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ka bene beꞌnnenꞌ llap rill yanꞌ kaꞌ, naꞌ jaloeꞌ leakeꞌ lo rill ya da zo loete. Naꞌll ye to chiꞌi, broeꞌ yen niaꞌ akeꞌn to lo yay da nziꞌi cepo. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Do llere naꞌ, Pablo ren Silas lloeꞌrén akeꞌ Diosenꞌ diꞌlle, naꞌ llol akeꞌ lloeꞌrao akeꞌ Dios, naꞌ beꞌnn kaꞌ yelaꞌ llaꞌa rill yanꞌ, llzenay akeꞌ kanꞌ llol akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bixha kate bxhoꞌkze da xhen, naꞌ bnniben rill yanꞌ, yeololte ganꞌ nsej akeꞌ warenꞌ, byarj aken naꞌ gden kaꞌ yoꞌ yen taꞌk beꞌnn kaꞌ llaꞌa lo rill yanꞌ, to wrazze bayell akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ka babán beꞌnnenꞌ llap rill yanꞌ, gokbeꞌreꞌ ba nyarj rill yanꞌ, naꞌ blechj spad keꞌen gokraꞌlleꞌ wayot kwineꞌ, llakreꞌ chaꞌ yeolol beꞌnn kaꞌ llaꞌa lo rill ya naꞌ, ba baxhonnj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Naꞌ Pablonꞌ bnneꞌe zillj, lleꞌe leꞌe: —Bi gonoꞌ kaꞌ, ni llaꞌa yeololtoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Naꞌll beꞌnnenꞌ bnnabeꞌ to yiꞌ, naꞌ byoꞌdoeꞌ lo rill yanꞌ, bllinte ganꞌ ze Pablo ren Silas naꞌ, to xhiztiteꞌ bcheꞌk xhibeꞌ rao akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Naꞌll le babejteꞌ leakeꞌ, naꞌ lleꞌe leakeꞌ: —¿Bi llayaꞌl gonaꞌ nench yeraꞌ rao da xhinnjenꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Naꞌll lle akeꞌ leꞌe: —Gonliraꞌlloꞌ Xanllo Jesucristonꞌ, naꞌll yesreꞌe rweꞌ rao da xhinnjenꞌ ren beꞌnn llaꞌa lo yoꞌ rilloꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Naꞌll le broeꞌ aktereꞌ leꞌe xtiꞌll Xanllonꞌ rente beꞌnn kaꞌ llaꞌa lo yoꞌ rilleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Leskaꞌ rao yer naꞌ, bdib beꞌnnenꞌ llap rill yanꞌ rao weꞌe ke akeꞌn, naꞌll le blloateꞌ nis ren yeolol beꞌnn kaꞌ llaꞌa lo yoꞌ rilleꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Le bacheꞌteꞌ leakeꞌ rilleꞌ, beꞌe da bdao akeꞌ, llawereꞌ kwis ka nak yeolol akeꞌ ba nxenraꞌll Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ka byeniꞌn bseꞌl koxchis kaꞌ policía kaꞌ, naꞌ goll akeꞌ beꞌnnenꞌ llap rill yanꞌ: —Basán beꞌnn kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Naꞌll beꞌnnenꞌ llap rill yanꞌ lleꞌe Pablonꞌ: —Ba bseꞌl koxchis kaꞌ rson ba gok yesanaꞌ reꞌ, naꞌ nnaꞌ lewalloje, lewayejchga wen nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Naꞌ Pablonꞌ lleꞌe policía kaꞌ: —Zgaꞌtek bdintat akeꞌ netoꞌ rao lkweꞌ beꞌnn zan kaꞌ latj gon akeꞌ yel koxchis ketoꞌ, naꞌtell broꞌ akeꞌ netoꞌ rill ya, naꞌ nnaꞌ lleꞌn akchekreꞌ yesán akeꞌ netoꞌ llillize, renchaꞌ ndetetoꞌ leꞌ yich naktoꞌ beꞌnn Roma. Naꞌ bi yellojtoꞌ, dekz de yed kwin akeꞌ yedrej akeꞌ netoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Policía kaꞌ le jayell akteꞌ koxchis kaꞌ kanꞌ bne Pablonꞌ, naꞌll blleb akeꞌ kwis, ka ben akreꞌ nak beꞌnn kaꞌ beꞌnn Roma. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Naꞌll jak koxchis kaꞌ rao Pablonꞌ ren Silas, naꞌ bnnab akeꞌ siꞌxhen akeꞌ kanꞌ goken, naꞌ babej akeꞌ leakeꞌ rill yanꞌ. Naꞌ goꞌtyoe akreꞌ leakeꞌ gon akeꞌ okré yelloj akeꞌ yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kaꞌ balloj akeꞌ rill yanꞌ, naꞌ jayakeꞌ rill Lidianꞌ, naꞌ beꞌrén akeꞌ beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ diꞌlle, beꞌltip akeꞌ leakeꞌ, naꞌll bazaꞌa akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ka bazaꞌa akeꞌ yellenꞌ nziꞌi Filipos, bde akteꞌ yell danꞌ nziꞌi Anfípolis, naꞌ yell da nziꞌi Apolonia, naꞌll bllin akeꞌ yellenꞌ nziꞌi Tesalónica. Gannaꞌ llaꞌa beꞌnn Israel, naꞌ zo to yodaꞌo ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablonꞌ kanꞌ llonkzeꞌ, byejeꞌ yodaꞌon, chonn xhman toto lla nbaꞌnne, jeꞌreneꞌ leakeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Llroeꞌreꞌ leakeꞌ xtiꞌll Dios danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, ganꞌ llian katenꞌ yed Cristo beꞌnnenꞌ wseꞌl Diosenꞌ dekz de zgaꞌtek yellayraweꞌ, naꞌtellenꞌ gateꞌ, naꞌ leskaꞌ llian yebaneꞌ. Naꞌ lle Pablonꞌ leakeꞌ: —Ni lloaꞌ xtiꞌll Jesús, Leꞌen Cristonꞌ bseꞌl Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bal akeꞌ byejleꞌ, naꞌ benrén akeꞌ Pablonꞌ txhen ren Silas, naꞌ beꞌnn zan beꞌnn griego kaꞌ, lloeꞌrao Dios, leskaꞌ byejleꞌ akeꞌ, naꞌ leskaꞌ zan noꞌr kaꞌ nak noꞌr brao rao yellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bixha beꞌnn Israel kaꞌ bi llejleꞌ gok akreꞌ ziꞌ, naꞌll btop akeꞌ beꞌnn ria ak, naꞌ beꞌnn wen da xhinnj ak, naꞌ bta bnne akeꞌ beꞌnn yell. Naꞌ ben akeꞌ bien byoꞌ akeꞌ rill beꞌnn re Jasón naꞌ, llayirj akeꞌ Pablo ren Silas naꞌ, lleꞌn akreꞌ kwej akeꞌ leakeꞌ rao beꞌnn yell kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bixha ker no ballel akreꞌ, naꞌ bcheꞌe akeꞌ Jasón naꞌ, ren ye bal beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ rao koxchis kaꞌ, naꞌ llosiaꞌ akeꞌ ne akeꞌ: —Beꞌnn kinꞌ llonchix akreꞌ beꞌnn llaꞌa doxhen yellrio, ba braꞌ akeꞌ yell kello ni. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Naꞌ Jasón naꞌ, ba brebeꞌ leakeꞌ lo yoꞌ rilleꞌ, naꞌ dá akeꞌ lle akeꞌ beꞌnn bibi zaꞌk ley danꞌ non Césarenꞌ gonllo, naꞌ dá akeꞌ ne akeꞌ zo to rey yobre beꞌnn re Jesús. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kone diꞌll ki bta bnne akeꞌ beꞌnn, naꞌ ren koxchis kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasón naꞌ ren beꞌnn lwelljeꞌ kaꞌ, bllia akeꞌ mell, naꞌll basán akeꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Naꞌll beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, rao lleꞌ naꞌ, basaꞌa akeꞌ Pablo ren Silas jakeꞌ yell danꞌ nziꞌi Berea. Ka bllin akeꞌ naꞌ, byej akeꞌ yodaꞌo ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beꞌnn Berea kaꞌ nak aklleꞌ beꞌnn raꞌlldaꞌo wen kerke beꞌnn kaꞌ llaꞌa Tesalónicanꞌ, le llaꞌteze llaꞌa akeꞌ llzenay akeꞌ xtiꞌll Diosenꞌ yeo lla, naꞌ llseꞌs akteꞌ leꞌ yich danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ, chaꞌ da li danꞌ lle akeꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Beꞌnn zan byejleꞌ ke Jesucristonꞌ, leskaꞌ bal noꞌr griego beꞌnn nak noꞌr brao byejleꞌ akeꞌ, leskaꞌ zan beꞌnn byio. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Naꞌ beꞌnn Israel kaꞌ llaꞌa Tesalónica, ka ben akreꞌ ba zo Pablonꞌ ganꞌ nziꞌi Berea llyixjweꞌreꞌ xtiꞌll Diosenꞌ, naꞌ jakeꞌ Bereanꞌ leskaꞌ jatá nne akeꞌ beꞌnn zan, nench bi byejleꞌ akeꞌ ke Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Naꞌ beꞌnn kaꞌ ba non txhen llonliraꞌll Jesucristonꞌ, le bseꞌl akteꞌ Pablonꞌ lloaꞌ nisdaꞌore, naꞌ Silas ren Timoteonꞌ goꞌy akeꞌ Berea naꞌze. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Beꞌnn kaꞌ zejrén Pablonꞌ txhen, jwaꞌa akteꞌ leꞌe yellenꞌ nziꞌi Atenas. Ka bazaꞌa beꞌnn kaꞌ, le gollte Pablonꞌ leakeꞌ chej Silas ren Timoteo ganꞌ zoeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Chak zo Pablonꞌ Atenas naꞌ, bexheꞌ beꞌnn lwelljeꞌ kaꞌ, da xhen llakreꞌ ka nak llwieꞌ beꞌnn Atenas kaꞌ, nize naꞌze lloeꞌrao akeꞌ beꞌnn non akeꞌ lwaꞌa lsaꞌk diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ni ke len naꞌ, llej Pablonꞌ yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ lloeꞌreneꞌ leakeꞌ diꞌll, naꞌ ren yezikre no beꞌnn llap Diosenꞌ baraꞌnne. Leskaꞌ yeo lla byejeꞌ lao yaꞌa ganꞌ lladop beꞌnn kaꞌ, naꞌ jeꞌreneꞌ leakeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Gannaꞌ llaꞌa beꞌnn llsed da llroeꞌ to beꞌnn re Epicuro, naꞌ llaꞌa ye bal beꞌnn llsed da llroeꞌ beꞌnn kaꞌ nziꞌi estoico, lloeꞌrén akeꞌ Pablonꞌ diꞌlle. Naꞌ bal beꞌnn kaꞌ ne akeꞌ: —¿Binꞌ ne beꞌnn llaljenꞌ gannaꞌ? Naꞌ ye bale ne: —Cheke diꞌll kob ke diosjenꞌ lloeꞌ. Ne akeꞌ kaꞌ, le lloeꞌreneꞌ leakeꞌ xtiꞌll Jesucristonꞌ, naꞌ kanꞌ gok babaneꞌn radj beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Naꞌ bcheꞌe akeꞌ Pablonꞌ to latj nziꞌi Areópago ga lladop akeꞌ llgoꞌ akeꞌ lban, naꞌ lle akeꞌ leꞌe: —¿Wak nnézetoꞌ bi da kobenꞌ nsaꞌo? ");
INSERT INTO zpuNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Diꞌll da bi nna yénetoꞌn lloeꞌo, naꞌ lleꞌnetoꞌ nnézetoꞌ bi lleꞌnen nnen. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bne akeꞌ kaꞌ, le beꞌnn Atenas kaꞌ, naꞌ noteze beꞌnn zo Atenas naꞌ, le llawé akreꞌ no wchaljrén leakeꞌ, naꞌ no weꞌrén leakeꞌ diꞌll bi da kobe. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Naꞌll bzollaꞌa Pablonꞌ radj beꞌnn kaꞌ llaꞌa ganꞌ ne Areópago, naꞌ bneꞌe: —Reꞌ beꞌnn Atenas, ba breꞌyaꞌnnraꞌ kanꞌ llonre yell ni, wa lloeꞌraore kon biteze. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ka nak bdiaꞌ bwiaꞌ ganꞌ niꞌt da kaꞌ lloeꞌraore naꞌ, jadiꞌraꞌ to rao bkoy nyojen ki: “To dios nono nombiaꞌ.” Xtiꞌll Leꞌen lloeꞌrenaꞌ reꞌ nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios beꞌnnenꞌ ben yellrio, naꞌ beneꞌ yeolol da zjadé rawe naꞌ, Leꞌen nakeꞌ xan yebá, naꞌ yellrio ni, ker beꞌnn gak wzoallo to lo yodaꞌo da llon beꞌnnachenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nono llyalljreꞌ no bi gon keꞌe, le Leꞌen llonneꞌ lliꞌo yel nban, naꞌ llonneꞌ bich yoꞌllo, naꞌ llonneꞌ yeolol da napllo. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Rao toze llen naꞌ, beneꞌ yeololtello, naꞌ beneꞌ to latj ga chaꞌa to kwen to kwenllo, naꞌ bzoateꞌ ke toto ga sollo. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Diosenꞌ beneꞌ kaꞌ nench wayirjlloeꞌ, ka llon beꞌnn dá llgan lltobeꞌ, wallelreꞌ kanꞌ nakse Diosenꞌ, naꞌ da li bi zoeꞌ ziꞌte ganꞌ zollonꞌ, zorenkzeꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ni ke Leꞌen naꞌ, zollo, naꞌ dallo, naꞌ nbanllo, kanꞌ bzojkze beꞌnn siꞌn keré kaꞌ, bne akeꞌ: “Dialla ke Lekzeꞌn nakllo.” ");
INSERT INTO zpuNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Naꞌ ka nak nakllo beꞌnn zaꞌa rao dialla ke Diosenꞌ, bi gonllo xhbab Diosenꞌ nakeꞌ to beꞌnn de yej chaꞌo danꞌ nziꞌi oro, beꞌnn de plat, beꞌnn de yej, beꞌnnenꞌ ben beꞌnnachenꞌ kon ka baraꞌn yichjraꞌlldaꞌweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Naꞌ ba bwiaraoze Diosenꞌ beꞌnn kaꞌ bllaꞌa batnaꞌ ben akeꞌ kaꞌ, le bi byejnieꞌ akreꞌn. Naꞌ nnaꞌ ne Diosenꞌ yeolol beꞌnne llayaꞌl wayat akreꞌ ke danꞌ ben akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Le ba nzoeꞌ to lla kat goneꞌ yel koxchis ke yeolol beꞌnne, naꞌ ba brejteꞌ beꞌnnenꞌ gonreneꞌ yel koxchisenꞌ, ke len naꞌ basbaneꞌ Jesucristonꞌ nench nnézello Leꞌen goneꞌ yel koxchisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ka ben akreꞌ bne Pablonꞌ yebán beꞌnn wat kaꞌ, baleꞌ bzorao lltitj akreꞌ, naꞌ ye baleꞌ bne: —Nnaꞌ wzenaytoꞌ xtiꞌlloꞌn kat ye to. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Bde naꞌ, balloj Pablonꞌ radj akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Naꞌ bal akeꞌ byejleꞌ akseꞌ, naꞌ bdop akeꞌ kwit Pablonꞌ. Radj beꞌnn kaꞌ byejleꞌn ren to beꞌnn re Dionisio, nakeꞌ txhen beꞌnn siꞌn kaꞌ nlan llnebiaꞌ Areópago, naꞌ ye to noꞌr re Dámaris, naꞌ ye bal beꞌnn yobre. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bde naꞌ, bazaꞌa Pablonꞌ yellenꞌ nziꞌi Atenas, naꞌ byejeꞌ yellenꞌ nziꞌi Corinto. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Corinto naꞌ ballayreꞌ to beꞌnn Israel re Aquila, naꞌ noꞌr keꞌen reꞌe Priscila, nak akeꞌ beꞌnn zaꞌk ganꞌ nziꞌi Ponto. Chin ballín akzeꞌ Corintonꞌ zayaꞌk akeꞌ ganꞌ nziꞌi Italia, le Claudio beꞌnnenꞌ llnebiaꞌ Italia, bachacheꞌ yeolol beꞌnn Israel kaꞌ llaꞌa yellenꞌ nziꞌi Roma. Naꞌ byej Pablonꞌ ganꞌ zo akeꞌn, ");
INSERT INTO zpuNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","naꞌ bzoreneꞌ leakeꞌ, le lekze llakeꞌ lloneꞌ ka llin naꞌ llon akeꞌn, llia akeꞌ raꞌll llej da llchirj akeꞌ ga llzo akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Toto lla nbaꞌnne ke beꞌnn Israel kaꞌ, Pablonꞌ llejeꞌ yodaꞌo ke akeꞌn, naꞌ llzejnieꞌreꞌ leakeꞌ kanꞌ nak xtiꞌll Jesucristonꞌ ka beꞌnn Israel, naꞌ beꞌnn griego, llroeꞌreꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ka bllin Silas ren Timoteonꞌ, zayaꞌk akeꞌ Macedonia, Pablonꞌ llaral-llreꞌ llroeꞌreꞌ xtiꞌll Diosenꞌ, lleꞌe beꞌnn Israel kaꞌ, Jesús naꞌn nak Cristonꞌ beꞌnnenꞌ llbexh akeꞌ wseꞌl Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bixha beꞌnn Israel kaꞌ, bi lloꞌraꞌll xtiꞌll Diosenꞌ, bzorao ne akeꞌ diꞌll zban ke Pablonꞌ. Naꞌ Pablonꞌ babibeꞌ xharaꞌneꞌn nench broeꞌreꞌ da xhinnjenꞌ llon akeꞌ, naꞌ lleꞌe leakeꞌ: —Bi naken xhia kiaꞌ, xhia ke reꞌ naken, naꞌ nnaꞌ wzejnieꞌllraꞌ xtiꞌll Diosenꞌ beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Naꞌ bazeꞌe, naꞌ ballineꞌ rill to beꞌnn re Justo beꞌnn lloeꞌrao Dios, zoeꞌ awllo ganꞌ zo yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","To beꞌnn re Crispo beꞌnn llnebiaꞌ lo yodaꞌon, benliraꞌlleꞌ Xanllonꞌ ren beꞌnn llaꞌa lo yoꞌ rilleꞌ, leskaꞌ beꞌnn zan beꞌnn Corinto kaꞌ byejleꞌ, naꞌ blloa akeꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Naꞌ gok to lleꞌ, Xanllonꞌ broeꞌraweꞌ Pablonꞌ, lleꞌe leꞌe: —Bi lleboꞌ, beꞌkze xtiꞌllaꞌn, bi soꞌo lli. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ni zerenkzaꞌ rweꞌ nono bi gak gone rweꞌ, le rao yell ni llaꞌa beꞌnn zan za wxenraꞌll nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Naꞌll bzo Pablonꞌ yellenꞌ nziꞌi Corintonꞌ twiz xop beꞌo, llroeꞌreꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Bixha ka lla llia beꞌnne re Galión, nakeꞌ beꞌnn llnebiaꞌ ganꞌ nziꞌi Acaya, beꞌnn Israel kaꞌ gok akeꞌ toze, beꞌe akeꞌ diꞌll nench blliayiꞌll akeꞌ Pablonꞌ, naꞌ jwaꞌa akeꞌ leꞌe ganꞌ llon beꞌnn wnebiaꞌ kaꞌ yel koxchis. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ne akeꞌ: —Beꞌnn ni deꞌe llpereꞌ beꞌnne, nench weꞌrao akeꞌ Diosenꞌ krere kanꞌ ne leyenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ka gokraꞌll Pablonꞌ weꞌreneꞌ leakeꞌ diꞌllenꞌ, naꞌ Galión naꞌ golleꞌ beꞌnn Israel kaꞌ: —Chenak naken billre da yobre, naꞌ chaꞌ beneꞌ no xhia, gonaꞌ yel koxchis kerénꞌ, beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Zan naken zre diꞌllze, naꞌ ra beꞌnne, naꞌ da nak da naore, lekoꞌ xhnneze reꞌ, bi lleꞌnraꞌ gakaꞌ beꞌnn wchoybiaꞌ bi danꞌ llak kerénꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Naꞌ bachacheꞌ leakeꞌ ganꞌ llieꞌ lloneꞌ yel koxchisenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Naꞌll yeololte beꞌnn griego kaꞌ, beꞌx akeꞌ Sóstenes beꞌnnenꞌ llnebiaꞌ yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ ben akeꞌ ziꞌ keꞌe ganꞌ llaꞌa beꞌnn kaꞌ llon yel koxchisenꞌ, bixha Galión naꞌ, bi bwiakzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bde gok kaꞌ, ye to chiꞌi bzo Pablonꞌ zan lla Corintonꞌ. Naꞌll ka bazeꞌe naꞌ, beꞌreneꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ diꞌlle, naꞌll baweꞌ nez bayoeꞌ lo barco ren Priscila, naꞌ Aquilanꞌ, zjakeꞌ ganꞌ nziꞌi Siria. Bixha ka za wagoꞌtere Pablonꞌ nez yellenꞌ re Cencrea, bchip yichjeꞌ le kanꞌ bchebeꞌ goneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Naꞌ bllin akeꞌ yellenꞌ nziꞌi Éfeso, naꞌ bkwaꞌnneꞌ Aquila ren Priscilanꞌ, naꞌ byej leꞌen yodaꞌo ke beꞌnn Israel kaꞌ, naꞌ jeꞌreneꞌ leakeꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Beꞌnn kaꞌ lladopenꞌ goꞌtyoe akreꞌ leꞌe gaꞌyeꞌ wroeꞌreꞌ leakeꞌ zan lla, naꞌ bi bcheb Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Naꞌll bazeꞌe lleꞌe leakeꞌ: —Llonen bien chaꞌa Jerusalén naꞌ, gannaꞌ lljadiaꞌ lnni danꞌ zaꞌa. Te naꞌ yedaꞌ yedraꞌnnaꞌ reꞌ, chaꞌ Dios gonneꞌ latj. Naꞌ bayoeꞌ lo barconꞌ, bazeꞌe Éfesonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bllinteꞌ yellenꞌ nziꞌi Cesarea, naꞌll byejeꞌ Jerusalén naꞌ, jawapeꞌ beꞌnn kaꞌ lldop ll-llay llonliraꞌll Cristonꞌ lliox, naꞌll bazeꞌe zayejeꞌ Antioquía. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Naꞌ bzoeꞌ to chiꞌi daꞌo, naꞌll bllojeꞌ da yobre jateꞌe toto yell kaꞌ ganꞌ nbane Galacia, naꞌ Frigia, naꞌ lloeꞌltipeꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Katenꞌ llak kaꞌ, bllin to beꞌnn Israel Éfesonꞌ beꞌnnenꞌ re Apolos, nakeꞌ beꞌnn yellenꞌ nziꞌi Alejandría, naꞌ llejnieꞌreꞌ llroeꞌ llsedreꞌ Diꞌll Wen, naꞌ leskaꞌ nnezreꞌ kwasro kanꞌ ne xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolos naꞌ bnnezreꞌ kanꞌ nak xhnnez Jesucristonꞌ. Naꞌ do yichj do raꞌlleꞌ lloeꞌreneꞌ beꞌnn kaꞌ xtiꞌll Jesucristonꞌ, laꞌkze bi nnezyaꞌnnreꞌn, le danꞌ broeꞌ Juan beꞌnnenꞌ bchoa nis, lezen naꞌ nnezreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bi llebeꞌ llroeꞌreꞌ beꞌnn Israel kaꞌ xtiꞌll Jesucristonꞌ lo yodaꞌon. Ka bene Priscilanꞌ naꞌ Aquilanꞌ kanꞌ lloneꞌ llroeꞌreꞌ beꞌnn kaꞌ, naꞌ goxh akeꞌ leꞌe to ga yobre, naꞌ bsed akreꞌ leꞌe xhnnez Diosenꞌ da bi nna nnezreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Naꞌ lleꞌne beꞌnnenꞌ nziꞌi Apolos chejeꞌ yell kaꞌ ganꞌ nziꞌi Acaya, naꞌ beꞌnn kaꞌ lldop ll-llay llonliraꞌll Jesucristonꞌ, bayoꞌraꞌll akeꞌ ka naken llwieꞌ chejeꞌn. Naꞌ bzoj akeꞌ to yich beꞌxeꞌ, nench wreb beꞌnn kaꞌ llaꞌa ganꞌ nziꞌi Acayanꞌ leꞌe. Ka bllineꞌ gannaꞌ, da xhen gokreneꞌ beꞌnn kaꞌ ba brej Xanllo Diosenꞌ nxenraꞌll Leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Llroeꞌ llsedreꞌ beꞌnn Israel kaꞌ, lleꞌe leakeꞌ, krerenꞌ llejnieꞌ akreꞌ ke Jesucristonꞌ, naꞌ llroeꞌreꞌ leakeꞌ xtiꞌll Diosenꞌ, nen ke Jesúsenꞌ nakeꞌ Cristo beꞌnnenꞌ bexh akeꞌ yednnebiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Bixha chak zo Apolos yellenꞌ nziꞌi Corinto naꞌ, Pablonꞌ jateꞌe yell kaꞌ lliꞌ radj yaꞌ kaꞌ. Naꞌll bllineꞌ Éfeso, naꞌ jadiꞌreꞌ bal beꞌnn llejleꞌ ke Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pablonꞌ bnnabreꞌ leakeꞌ: —¿Badsó Spíritu ke Diosenꞌ yichjraꞌlldaꞌore llanꞌ byejleꞌre ke Jesucristonꞌ? Naꞌll bne akeꞌ: —Ni ke nnézzetoꞌ chaꞌ de da nziꞌi Spíritu ke Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Naꞌll lleꞌe leakeꞌ: —¿Akxha gok blloare nis? Naꞌ bne akeꞌ: —Kon ka bchoa Juan naꞌ beꞌnn kaꞌ nis naꞌ, blloatoꞌ nis. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Naꞌll bne Pablonꞌ: —Da li Juan naꞌ bchoeꞌ beꞌnn kaꞌ nis, beꞌnn ba bayate ke da xhinnj ke akeꞌ, naꞌ leskaꞌ bne Juan naꞌ, llayaꞌl chejleꞌ akeꞌ ke to beꞌnn za yed, zeje diꞌll Jesús beꞌnnenꞌ nak Cristonꞌ bseꞌl Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ka ben akreꞌ kaꞌ, naꞌll blloa akeꞌ nis ke danꞌ ba nxenraꞌll akeꞌ Xanllo Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Naꞌll bxoa taꞌk Pablonꞌ yichj toto akeꞌ, nench bllin Spíritu ke Diosenꞌ byoꞌn yichjraꞌlldaꞌo akeꞌ. Naꞌ bzorao lloeꞌ akeꞌ diꞌll yobre, naꞌ llne akeꞌ xtiꞌll Diosenꞌ kon kanꞌ llzejnieꞌ Spíritunꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ka do chllinn (12) beꞌnn byio nak yeolol akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Naꞌ Pablonꞌ byoeꞌ lo yodaꞌo ke beꞌnn Israel kaꞌ llroeꞌreꞌ leakeꞌ, bi llebeꞌ ke nak llaꞌtyoereꞌ leakeꞌ, naꞌ llzejnieꞌreꞌ kanꞌ nak yel llnebiaꞌ ke Diosenꞌ. Ka llejteze llejeꞌ gokte chonn beꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Naꞌ bal akeꞌ llonchoch yichjraꞌlldaꞌo akeꞌn, bi llejleꞌ akeꞌ, naꞌ bzorao llnne akeꞌ no diꞌll zban rao beꞌnn kaꞌ ke xhnnez Diosenꞌ. Ka llaken braꞌa Pablonꞌ leakeꞌ, naꞌll babieꞌ beꞌnn kaꞌ ba nxenraꞌll Jesucristonꞌ radj akeꞌn, naꞌ bcheꞌe leakeꞌ to lo yoꞌ xkwel ke to beꞌnn re Tirano, naꞌ broeꞌ bsedreꞌ leakeꞌ yeo lla. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ka beneꞌ gokte chop iz, naꞌ kaꞌ doxhen ganꞌ nziꞌi Asia ben akreꞌ xtiꞌll Xanllo Jesucristonꞌ, ka beꞌnn Israel, naꞌ ren beꞌnn bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Diosenꞌ llakreneꞌ Pablonꞌ lloneꞌ da zan da yebánello. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Naꞌ no raꞌll no bay da ll-llel kwerp keꞌen, lljadaꞌa akeꞌn beꞌnn kaꞌ llak yillweꞌn llayak akteꞌ, leskaꞌ beꞌnn yoꞌ daxiꞌo llalloj akten. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Naꞌ bal beꞌnn Israel beꞌnn llon rmell ren yel wallaꞌa, leskaꞌ gokraꞌll akeꞌ gonrén akeꞌ ra Xanllo Jesúsenꞌ llin, nench yebej akeꞌ daxiꞌo yoꞌ beꞌnne, naꞌ lle akeꞌ daxiꞌo kaꞌ: —Kon ren yel wak ke Jesús beꞌnnenꞌ dá Pablonꞌ lloeꞌ xtiꞌll, llalwilltoꞌ reꞌ yellojre. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kaꞌ ben gall xhiꞌnn to beꞌnn re Esceva beꞌnn nak xan bxoz. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bixha bayechjkze daxiꞌon, llen leakeꞌ: —Nombieꞌraꞌ Jesúsenꞌ, naꞌ nnezraꞌ no beꞌnnenꞌ re Pablo, zan reꞌ, ¿noxha nak reꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Naꞌ beꞌnnenꞌ yoꞌ daxiꞌon, bxhiꞌteꞌ bzapeꞌ leakeꞌ, ka bize beꞌxeꞌ leakeꞌ benteꞌ leakeꞌ weꞌe, naꞌ baxhonnj beꞌnn kaꞌ gal yid akzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yeolol beꞌnn Éfesonꞌ bnnez akreꞌ kanꞌ goken, ka beꞌnn Israel naꞌ beꞌnn griego, blleb akeꞌ kwis, naꞌ ben akeꞌ xhen Xanllo Jesúsenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Naꞌ zan beꞌnn kaꞌ ba byejleꞌ akeꞌ ke xtiꞌll Jesucristonꞌ, naꞌ bllin akeꞌ rao beꞌnn kaꞌ yelaꞌ, naꞌ llxoarap akeꞌ bi da xhinnj ba ben akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Leskaꞌ beꞌnn zan ba ben xchin akeꞌ yel wallaꞌan, naꞌll jaxhiꞌi libr ke akeꞌn, bzey akeꞌn rao yeolol beꞌnn kaꞌ. Naꞌ bwia akeꞌ ka to zaꞌk yich kaꞌ, naꞌ gokbeꞌe akreꞌ zaꞌken ka chiyon mir (50,000) mell plat. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Naꞌ ka zejze llaslas xtiꞌll Xanllonꞌ, naꞌ llroeꞌtereꞌ yel wak keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bde naꞌ, Pablonꞌ bene xhbab wayejeꞌ Jerusalén naꞌ, kat te wadieꞌ yell kaꞌ ganꞌ nziꞌi Macedonia naꞌ Acaya, bneꞌe: —Zgaꞌtek wayaꞌa Jerusalén naꞌ, naꞌtell chaꞌa Roma. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Naꞌll bseꞌleꞌ chop beꞌnn lwelljeꞌ kaꞌ Macedonia, Timoteo ren Erasto, naꞌ leꞌen goꞌyeꞌ ye to chiꞌi Asianꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Naꞌ beꞌnn kaꞌ bi llazraꞌll xtiꞌll Jesucristonꞌ, to da zed xhen bdixj akeꞌ yellenꞌ re Éfeso. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Naꞌ beꞌnnenꞌ ben kaꞌ re Demetrio, beꞌnnenꞌ non xchineꞌ no bi da daꞌo de ya chaꞌo nziꞌi plat, naꞌ lloneꞌ no yodaꞌo riz kanꞌ nak yodaꞌo ke Diana lwaꞌa lsaꞌk dios. Beꞌnn kaꞌ llonreneꞌ llin naꞌ, da xhen llon akeꞌ gan kone llin naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Naꞌll Demetrionꞌ batopeꞌ beꞌnn kaꞌ llonreneꞌ llin naꞌ, naꞌ ren yezikre beꞌnn llon ka llin keꞌe naꞌ, lleꞌe leakeꞌ: —Reꞌ beꞌnne, nnézkzere kone xchinllonꞌ, da xhen llonllo gan. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Naꞌ kanꞌ ba llwiare, naꞌ llénere kanꞌ ne Pablonꞌ, deꞌe neꞌe, naꞌ beꞌnn zan ba beneꞌ gan, kere Éfeso nize, doxhente Asia, lleꞌe beꞌnn kaꞌ: “Kere dios da zaꞌk ke nak da ki llon niaꞌnaꞌa beꞌnnachenꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Naꞌ nxholl billbi xchinllo gaꞌte, naꞌ leskaꞌ yodaꞌo ke dios kello Diananꞌ, nxholl bill wxenraꞌll akeꞌn, naꞌ sorao nnit yel baraꞌnn keꞌen, le nnézello doxhen ganꞌ nziꞌi Asia, naꞌ doxhenkze yellrio, llap akeꞌ Diananꞌ baraꞌnne. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ka bene beꞌnn kaꞌ kaꞌ, naꞌll gokllaꞌa akeꞌ, naꞌ besiaꞌ akeꞌ bne akeꞌ: —¡Beꞌnn yel wak xhen nak Diana ke lliꞌo beꞌnn Éfeso! ");
INSERT INTO zpuNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Naꞌ da nne xhen gok rao yellenꞌ, naꞌ le bllachte beꞌnn zan kaꞌ, naꞌ bzap akeꞌ chop beꞌnn lwellj Pablonꞌ, toeꞌ reꞌe Gayo, naꞌ ye toeꞌ reꞌe Aristarco beꞌnn Macedonia ake. Naꞌ bxhoblleꞌo akeꞌ leakeꞌ, bcheꞌe akteꞌ leakeꞌ ga zo yoꞌ ganꞌ lladop akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablonꞌ gokraꞌlleꞌ chejeꞌ lljeꞌreneꞌ beꞌnn kaꞌ diꞌlle, naꞌ beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ bi beꞌe akeꞌ latj chejeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Leskaꞌ bal beꞌnn kaꞌ nak beꞌnn llnebiaꞌ nak akeꞌ Pablonꞌ txhen naꞌ, bseꞌl akeꞌ rson bi chejeꞌ lljatileꞌ beꞌnn kaꞌ ganꞌ ndop akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Naꞌ beꞌnn kaꞌ bdopenꞌ, wde wdere da ne toto akeꞌ kon llak da nne xhen, naꞌ beꞌnn zan, ni ke nnez akzreꞌ bi ken bdop akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Naꞌ brej akeꞌ to beꞌnn re Alejandro radj beꞌnn zan kaꞌ, naꞌll blliꞌy beꞌnn Israel kaꞌ leꞌe rao lkweꞌ beꞌnn yell. Naꞌll Alejandro blis taꞌkeꞌ bnnabeꞌ chaꞌa akeꞌ lli, gokraꞌlleꞌ wneꞌe, wayoꞌxeꞌ beꞌnn kaꞌ rao lkweꞌ beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bixha ka bayombiaꞌ akreꞌ lekze beꞌnn Israelenꞌ, naꞌ bzorao llosiaꞌ akeꞌ ka chop hor, bne akeꞌ: —¡Beꞌnn yel wak xhen nak Diana ke lliꞌo beꞌnn Éfeso! ");
INSERT INTO zpuNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Naꞌ beꞌnnenꞌ nake wazoje rao yellenꞌ, ka gok babekllieꞌ beꞌnn kaꞌ, naꞌll lleꞌe leakeꞌ: —Reꞌ beꞌnn Éfeso, yeolol beꞌnn llaꞌa doxhen yellrionꞌ, nnez aksereꞌ rao yell kello ni zo yodaꞌo ke Diana, naꞌ lliꞌo llapllon, naꞌ ren lwaꞌa lsaꞌk keꞌen da zaꞌa yebá. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nono te nneꞌe bi naken kaꞌ, naꞌ nnaꞌ lesó lli, naꞌ lewayonyaꞌnn xhbab kanꞌ llonrenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Le beꞌnn ki badwaꞌre ganni, bibi nna siꞌi akeꞌ lo yodaꞌo, leskaꞌ bi nne akeꞌ zban ke dios kello Diananꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Zan ka nak Demetrionꞌ naꞌ ren beꞌnn kaꞌ llonreneꞌ llin naꞌ, chaꞌ bi de ke akeꞌ kon ren beꞌnn ki, ke len naꞌ zo beꞌnn llnebiaꞌ, naꞌ lljatao akeꞌ xhia chet kaꞌ, nench choꞌ xhnneze ke akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Naꞌ chaꞌ billre da yobrenꞌ lleꞌnere, wakse wadopllo, naꞌ wayej diꞌll kwasro chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bixha ka nak da nne xhen naꞌ, ba gok nnaꞌ, nxholl wtob akreꞌ lliꞌo llonllo da wlliayiꞌll beꞌnn wnebiaꞌ kello, naꞌ ke len naꞌ ba lldopllo. Chaꞌ wnnab akeꞌ binꞌ llonllo, ni ke bi dez nnello ke da zban naꞌ ba gok nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bayoll bneꞌe kaꞌ, naꞌll golleꞌ leakeꞌ wayaslas akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ka bde da nne xhen naꞌ Éfesonꞌ, Pablonꞌ goxheꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ, beꞌreneꞌ leakeꞌ diꞌll bi wsan akeꞌ danꞌ ba nxenraꞌll akeꞌ Jesucristonꞌ. Naꞌll bdeꞌleꞌ toto akeꞌ, naꞌ baweꞌ nez zayejeꞌ ganꞌ nziꞌi Macedonia. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Naꞌ jateꞌe yell kaꞌ lliꞌ ganꞌ nziꞌi Macedonia, beꞌreneꞌ beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ diꞌlle, nniꞌtteze nniꞌt akeꞌ gonliraꞌll akeꞌ Leꞌe. Kaꞌ gok bllinteꞌ ganꞌ nziꞌi Grecia. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Chonn beꞌo bzoeꞌ Grecianꞌ. Naꞌll gokraꞌlleꞌ choeꞌ lo barco wayejeꞌ ganꞌ nziꞌi Siria, bixha gokbeꞌreꞌ beꞌnn Israel kaꞌ lliꞌnao akeꞌ leꞌe, lleꞌn akreꞌ goꞌx akeꞌ leꞌe. Naꞌll baweꞌ nez kon nieꞌ, naꞌ babieꞌ Macedonia naꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bal beꞌnn kaꞌ byejrén akeꞌ Pablonꞌ, to beꞌnn re Sópater beꞌnn Berea, naꞌ Aristarco, naꞌ ren ye to beꞌnn re Segundo llopteze beꞌnn Tesalónica, naꞌll beꞌnnenꞌ re Gayo, beꞌnn zaꞌa yellenꞌ nziꞌi Derbe, naꞌ Timoteo, naꞌ chop beꞌnn zaꞌk ganꞌ nziꞌi Asia, toeꞌ reꞌe Tíquico, naꞌ ye toeꞌ reꞌe Trófimo. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Beꞌnn ki blliarao akeꞌ raotoꞌ, naꞌ brexh akeꞌ netoꞌ yellenꞌ nziꞌi Troas. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Naꞌ netoꞌ, ka bde lnni danꞌ kate llao akeꞌ yet xtir danꞌ bi nchixe kwa binn, naꞌll byoꞌtoꞌ lo barconꞌ, naꞌ bzaꞌtoꞌ yellenꞌ nziꞌi Filipos. Gok gaꞌy lla bllintoꞌ yellenꞌ nziꞌi Troas ganꞌ llbexh beꞌnn kaꞌ yelaꞌ netoꞌ, naꞌ bzotoꞌ to xhman. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Bixha ka bllin lla dmio, badop yeolol beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ llaꞌa yellenꞌ nziꞌi Troas, naꞌ bdaotoꞌ txhen. Naꞌ Pablonꞌ ka wxere yeweꞌ nez, broeꞌreꞌ leakeꞌ xtiꞌll Diosenꞌ bllinte llere. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Naꞌ llaꞌtoꞌ to yoꞌ da zo chkwia, zan yiꞌn zjazó akeꞌn llaꞌlen. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Naꞌ to bi llabán re Eutico, lliꞌbeꞌ lloaꞌ ventan naꞌ, naꞌ Pablonꞌ da xhen zejze diꞌllenꞌ lloeꞌn, bdekze bichgal kebeꞌ, wixbeꞌ lloaꞌ ventan naꞌ, naꞌ naken chonn kwia, naꞌ ka jalis akebeꞌn, ba gotbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Naꞌll betjdo Pablonꞌ, ka bllineꞌ ganꞌ debeꞌn, goꞌtteze bdeꞌlebeꞌ, naꞌll lleꞌe beꞌnn kaꞌ: —Bibi gákere, nbankzbeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Naꞌtell bayepeꞌ lo yoꞌn, naꞌ bxhoxhjeꞌ yet xtirenꞌ, naꞌ bdao akeꞌn, naꞌ ye to chiꞌi beꞌreneꞌ leakeꞌ diꞌll bllinte bale, naꞌll bazeꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ka ballach akeꞌn, llawé akreꞌ kwis ka nak binꞌ wixenꞌ, zancheꞌe akebeꞌ nbanbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Netoꞌ blliaraotoꞌ byoꞌtoꞌ barco byejtoꞌ yellenꞌ nziꞌi Asón, le beꞌtoꞌ diꞌll gannaꞌ kwexhtoꞌ Pablonꞌ, le leꞌen gokraꞌlleꞌ chejeꞌ kon nieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kaꞌ bllintoꞌ yellenꞌ nziꞌi Asón, naꞌ byepeꞌ lo barconꞌ, kaꞌ gok bllintoꞌ yellenꞌ nziꞌi Mitilene. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","To bdeztoꞌ Mitilenenꞌ, bateyó bdetoꞌ chlaꞌ yellrionꞌ lliꞌ lo nisdaꞌon danꞌ nziꞌi Quío. Tlla gok zejtoꞌ lo barconꞌ, naꞌ bllintoꞌ ye to yellrionꞌ lliꞌ lo nisdaꞌon re Samos. Gannaꞌ ballojtoꞌ barconꞌ, naꞌ byejtoꞌ yellenꞌ nziꞌi Trogilio, naꞌ goꞌytoꞌ baziꞌraꞌlltoꞌ. Naꞌ bayoꞌtoꞌ lo barco da yobre, naꞌ bateyó bllintoꞌ yellenꞌ re Mileto. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bi byejtoꞌ yellenꞌ nziꞌi Éfesonꞌ, le Pablonꞌ bi lleꞌnreꞌ gaꞌyeꞌ scha ganꞌ nziꞌi Asianꞌ, le ne lleꞌnreꞌ yobdo yellineꞌ Jerusalén naꞌ, chaꞌ gaꞌle yellineꞌ lnni Pentecostés. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Chak zo Pablonꞌ yellenꞌ re Mileto, goxheꞌ beꞌnn Éfeso kaꞌ, beꞌnn kaꞌ nak beꞌnn gor brao ke beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ka bllin akeꞌn, naꞌ lleꞌe leakeꞌ: —Reꞌ nnézere kanꞌ benaꞌ chak bzorenaꞌ reꞌ, bxhiꞌzen lla nell kanꞌ bedaꞌ Asianꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kanꞌ bzoaꞌ, benaꞌ xchin Diosenꞌ, bi benxhen kwinaꞌ, zan ras bllellaꞌ, naꞌ ballayrawaꞌ ni ke beꞌnn Israel kaꞌ, kanꞌ blleꞌnao akeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Naꞌ bi bsanaꞌ wroeꞌraꞌ reꞌ da kaꞌ llayaꞌl nnézeren, broeꞌraꞌ reꞌ ganꞌ lladop llallayllo, naꞌ leskaꞌ rill totore. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ka beꞌnn Israel, naꞌ beꞌnn bi nak beꞌnn Israel, goll akeꞌ llayaꞌl wayat akreꞌ ke da xhinnj ke akeꞌn, naꞌ gonliraꞌll akeꞌ Xanllo Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Naꞌ nnaꞌ, Spíritu ke Diosenꞌ llchieꞌreꞌ nadaꞌ wayaꞌa Jerusalén naꞌ, naꞌ bi nnezraꞌ bi gak kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Lete toto yell ga lldiaꞌ, Spíritu ke Diosenꞌ llyixjweꞌn goꞌx akeꞌ nadaꞌ, naꞌ wallayrawaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Naꞌ ker bi gon danꞌ, ba nsanraꞌllkzaꞌ yel nban kiaꞌn, le lleꞌnraꞌ wasyollaꞌ yeolol da llayaꞌl gonaꞌ. Naꞌ llaweraꞌ kwis ke llin naꞌ, benn Xanllo Jesúsenꞌ gonaꞌ. Brejeꞌ nadaꞌ nench taꞌa weꞌrenaꞌ beꞌnn kaꞌ diꞌll kanꞌ nllieꞌ Diosenꞌ lliꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Naꞌ nnezraꞌ reꞌ llaꞌa yell ganꞌ ba bdiaꞌ llyixjweꞌraꞌ yel llnebiaꞌ ke Diosenꞌ, ni tore bill reꞌre nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ke len ni niaꞌ reꞌ, bibi xhia naken kiaꞌ, chaꞌ no reꞌ kwiayiꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Doxhen kanꞌ nak xtiꞌll Diosenꞌ ba broeꞌraꞌ reꞌ, bibi nello bkwaꞌchraꞌ reꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Naꞌ nnaꞌ, legap kwinre, naꞌ legap yeolol beꞌnn kaꞌ nakre txhen naꞌ. Spíritu ke Diosenꞌ brejen reꞌ, nench gap wiare beꞌnn kaꞌ lldop ll-llay llonliraꞌll Xanllo Jesucristonꞌ, le weꞌweꞌ lliꞌo kon ren xcheneꞌ danꞌ brarje leꞌ yay cruzenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nadaꞌ nnezraꞌ, ka nak nnaꞌ wayaꞌa bill sorenaꞌ reꞌ. Chaz beꞌnn wxhiyeꞌe ak radjrenꞌ, gon akeꞌ kaꞌkze beꞌkw yiꞌo, le gonchix akreꞌ beꞌnn kaꞌ nench laꞌa akeꞌ nez li ke Xanllo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Radjre nize llojkze beꞌnn weꞌe diꞌll wenraꞌll da bi zej lixheje, nench beꞌnn kaꞌ llejleꞌ ke Jesucristonꞌ, wzenay akeꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Lewiayaꞌnn nench nono siyeꞌe reꞌ, lelljadinraꞌll kanꞌ benaꞌ bzorenaꞌ reꞌ chonn iz, tella naꞌ tlleꞌle, to bllellaꞌ ke totore ka nak llzejnieꞌraꞌ reꞌ xtiꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Naꞌ reꞌ beꞌnn biꞌchaꞌ, llonaꞌ reꞌ rallnaꞌa Dios, xtiꞌlleꞌn napkzen yel wak gakrenen reꞌ, nench sere war llinte lla gonneꞌ reꞌ danꞌ bchebeꞌ weꞌe yeolol beꞌnn kaꞌ brejeꞌ, nench wxenraꞌll akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Bi bzeraꞌllaꞌ bi da de keré, ni mell keré, ni xharaꞌnre. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Reꞌ nnézkzere chaꞌ bi byalljraꞌ, leskaꞌ bi byalljre beꞌnn kaꞌ bzorenaꞌ txhen naꞌ, niaꞌnaꞌ ki ben llin. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kone kaꞌ broeꞌraꞌ reꞌ kanꞌ llayaꞌl gonllo llin, nench gakrenllo beꞌnn chaꞌ bi yalljreꞌ. Lelljadinraꞌll kanꞌ bne Xanllo Jesucristonꞌ, kanꞌ bneꞌe: “Nbarazre naken chaꞌ bi weꞌllo beꞌnn, kerke siꞌllo chaꞌ bi da gonn akeꞌ lliꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ka bayoll beꞌrén Pablonꞌ leakeꞌ diꞌll ki, naꞌll bcheꞌk xhibeꞌ balwillreneꞌ leakeꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Yeolol akeꞌ bzorao bell akeꞌ kwis, naꞌ llyeꞌl akeꞌ Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Da xhen llak akreꞌ ka nak danꞌ lleꞌe leakeꞌ: “Nnaꞌze llreꞌre nadaꞌ.” Naꞌ ben akeꞌ leꞌe txhen ganꞌ bayoeꞌ barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bde bkwaꞌnntoꞌ beꞌnn kaꞌ, naꞌ byoꞌtoꞌ barconꞌ zejtoꞌ lilla ganꞌ lliꞌ to yellrio danꞌ lliꞌ lo nisdaꞌon danꞌ nziꞌi Cos. Naꞌ bateyó bllintoꞌ ye to yellrio danꞌ lliꞌ lo nisdaꞌo danꞌ nziꞌi Rodas, naꞌ bzaꞌtoꞌ, naꞌ bllintoꞌ to yell nziꞌi Pátara. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pátara naꞌ, jadiꞌtoꞌ to barco da le llzaꞌte chej ganꞌ nziꞌi Fenicia, naꞌ byoꞌtoꞌ zejtoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ka zejtoꞌ naꞌn, breꞌtoꞌ yellenꞌ lliꞌ lo nisdaꞌon danꞌ nziꞌi Chipre, naꞌ bkwaꞌnntoꞌn taꞌkllo rbese zejzetoꞌ Siria. Kat bllintoꞌ Tiro naꞌ bletj akeꞌ yoaꞌ noaꞌ barconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tiro naꞌ jadiꞌtoꞌ beꞌnn nxenraꞌll Jesucristonꞌ, naꞌ bzotoꞌ to xhman ren leakeꞌ. Naꞌ lle akeꞌ Pablonꞌ bi chejeꞌ Jerusalén naꞌ, kaꞌ llzejnieꞌ Spíritu ke Diosenꞌ leakeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Gok to xhman naꞌ bagoꞌtoꞌ nez. Yeolol beꞌnn kaꞌ llonliraꞌll Jesucristonꞌ ren noꞌr ren xkwiꞌd, bzaꞌrén akeꞌ netoꞌ txhen lloaꞌ nisdaꞌon, naꞌ bcheꞌk xhibtoꞌ balwilltoꞌ Dios. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Naꞌll bdeꞌl lwelljtoꞌ, naꞌ netoꞌ byoꞌtoꞌ lo barconꞌ, naꞌ leakeꞌn zayej rill akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Naꞌ bzaꞌtoꞌ Tiro, naꞌ bllintoꞌ yellenꞌ nziꞌi Tolemaida, naꞌ ballojtoꞌ barconꞌ, naꞌ jawaptoꞌ lliox beꞌnn kaꞌ nxenraꞌll Jesucristonꞌ llaꞌa Tolemaidanꞌ, naꞌ bzorén aktoeꞌ tlla. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Naꞌ bateyó bzaꞌrentoꞌ Pablonꞌ bllintetoꞌ Cesarea, naꞌ byejtoꞌ rill beꞌnnenꞌ re Felipe beꞌnn lloeꞌ xtiꞌll Jesucristonꞌ, leskaꞌ nakeꞌ txhen beꞌnn gall kaꞌ llakrén postl kaꞌ, rilleꞌ naꞌ bzotoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipenꞌ zo tap xhiꞌnneꞌ noꞌr weꞌo, naꞌ nne akbeꞌ xtiꞌll Diosenꞌ kon ka llzejnieꞌ Spíritu ke Diosenꞌ leakbeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Naꞌ bzotoꞌ zan lla, kat braꞌ to beꞌnn Judea beꞌnn re Agabo, lloeꞌ xtiꞌll Dios kon ka llzejnieꞌ Spíritu ke Diosenꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Naꞌ badraꞌnneꞌ netoꞌ, naꞌ bnnabeꞌ xpaydon Pablonꞌ, naꞌ bchejeꞌn niaꞌneꞌe, naꞌll bneꞌe: —Spíritu ke Diosenꞌ ne, ki gone beꞌnn Israel kaꞌ xan baydon ni, goꞌx akeꞌ leꞌe gon akeꞌ leꞌe rallnaꞌa beꞌnn ziꞌte. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ka bayoll bénetoꞌ kaꞌ, netoꞌ naꞌ ren beꞌnn Cesarea kaꞌ, goꞌtyoetoꞌ Pablonꞌ zanakzen chejeꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Naꞌll Pablonꞌ lleꞌe netoꞌ: —¿Bixchen bellre, naꞌ llzoayaꞌchre nadaꞌ? Ba bchoyraꞌllkzaꞌ kere wchej akzeꞌ nadaꞌ, wakse gataꞌ Jerusalén naꞌ, ni ke Xanllo Jesucristonꞌ chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Laꞌkze da zan da golltoeꞌ, bi bzoekzetoꞌ wzaꞌytoeꞌ, naꞌll lletoeꞌ: —Gakchaz kon kanꞌ ne Xanllo Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bde gok kaꞌ, bentoꞌ xhnid, naꞌll zejtoꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Naꞌ bal beꞌnn Cesarea kaꞌ nxenraꞌll Jesucristonꞌ, bzaꞌrén netoꞌ ncheꞌe akteꞌ to beꞌnn re Mnasón beꞌnn Chipre, ba gok scha naweꞌ Jesucristonꞌ, rill leꞌe llintoꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ka bllintoꞌ Jerusalén naꞌ, llawé beꞌnn kaꞌ nakllo txhen llonliraꞌll Jesucristonꞌ, ka breꞌe akreꞌ netoꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bateyó byejrentoꞌ Pablonꞌ, jaraꞌnntoꞌ Jacobo naꞌ, ganꞌ zoeꞌ naꞌ, leskaꞌ balláyetoꞌ yeolol beꞌnn gor brao kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Naꞌ bwap Pablonꞌ leakeꞌ lliox, naꞌll beꞌreneꞌ leakeꞌ diꞌll toto kanꞌ gokrén Diosenꞌ leꞌe, ka nak deꞌe llroeꞌreꞌ xtiꞌll Diosenꞌ beꞌnn kaꞌ bi nak beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ka ben akreꞌ diꞌllenꞌ beꞌe Pablonꞌ, beꞌrao akeꞌ Dios, naꞌll goll akeꞌ leꞌe: —Rweꞌ nnézkzeroꞌ beꞌnn zan beꞌnn Israel kaꞌ, ba llejleꞌ ke Jesucristonꞌ, naꞌ yeolol akeꞌ ne akeꞌ llonen bien gonllo kanꞌ ne ley danꞌ bzoj da Moisésenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Naꞌ ba ben akreꞌ, rweꞌn daꞌo llroeꞌroꞌ beꞌnn Israel wrall kello niꞌt rall beꞌnn ziꞌt kaꞌ, bill gon akeꞌ kanꞌ ne ley danꞌ bzoj da Moisésenꞌ, naꞌ bi wzoa xhiꞌnn akeꞌ sen danꞌ nziꞌi circuncisión naꞌ, naꞌ bi gon akeꞌ billre da kaꞌ nao lliꞌo beꞌnn Israel. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Akxha gonllo nnaꞌ? Nnez akreꞌ ba bayedoꞌ, naꞌ wadop beꞌnn yell. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","To da ben, ganni zo tap beꞌnne ncheb akeꞌ weꞌe akeꞌ Diosenꞌ to da weꞌe akeꞌ Leꞌe, naꞌ ba bllin lla weꞌe akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Byejrén akeꞌ yodaꞌo braonꞌ, jadib kwinoꞌ ren leakeꞌ, naꞌ bdixhj danꞌ llayaꞌl chixhj akeꞌ naꞌ, nench gak wchip yichj akeꞌ. Kaꞌ ben nench reꞌe beꞌnn kaꞌ llonkzoꞌ kanꞌ ne leyenꞌ, naꞌ gakbeꞌe akreꞌ kere da li kanꞌ goll akeꞌ leakeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ka nak beꞌnn kaꞌ bi nak beꞌnn Israel, ba bzoj akstoeꞌ, bi gon akeꞌ da kaꞌ nao lliꞌo. Lete to da gon akeꞌ, bi gao akeꞌ yel wao da bxoa akeꞌ rao lwaꞌa lsaꞌk dios, bi gao akeꞌ llen, naꞌ bi gao akeꞌ no bayiꞌx ba llchok akeꞌ yen, naꞌ chaꞌ bi nchaynaꞌa akeꞌ, bi gak sorén lwellj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Naꞌ bcheꞌe Pablonꞌ beꞌnn tap kaꞌ, naꞌ bateyó bayib kwin akeꞌ ren leꞌe. Naꞌll byoꞌ akeꞌ yodaꞌo braonꞌ, nench bdixjweꞌ akreꞌ bxozenꞌ ba bllin lla yeyib kwin akeꞌ, naꞌ yeraꞌ danꞌ bcheb akeꞌ weꞌe akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Bixha ka le gakte gall lla, naꞌ wayoll yeraꞌ danꞌ bcheb akeꞌn, bal beꞌnn Israel zayaꞌk Asia, breꞌe akreꞌ Pablonꞌ lo yodaꞌo braonꞌ, naꞌ bta bnne akeꞌ beꞌnn, naꞌ beꞌx akeꞌ Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Naꞌ llosiaꞌ akeꞌ ne akeꞌ: —¡Reꞌ beꞌnn wrall, legakrén goꞌxllo beꞌnnenꞌ! Leꞌe doxhente deꞌe llroeꞌreꞌ beꞌnne, wiello yell kellonꞌ, naꞌ rente yodaꞌo braonꞌ, naꞌ bi gonllo kanꞌ ne ley danꞌ bzoj da Moisésenꞌ. Naꞌ ye to da xhinnj xhen ba beneꞌ, ba broeꞌ beꞌnn bi nak beꞌnn Israel lo yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ne akeꞌ kaꞌ, le breꞌe akreꞌ Pablonꞌ deꞌe lyell ren to beꞌnn re Trófimo beꞌnn Éfeso, naꞌ llak akreꞌ chaꞌ broeꞌ leꞌe lo yodaꞌo braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Yeolol beꞌnn llaꞌa rao yell Jerusalén naꞌ, ben akeꞌ da nne xhen, naꞌ bdop akeꞌ beꞌx akeꞌ Pablonꞌ. Naꞌ bxhobxexj akeꞌ leꞌe, babej akeꞌ leꞌe lo yodaꞌo braonꞌ, naꞌll le basej akteꞌ yeololte kon ga nyarjkze ke yodaꞌon. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Naꞌ ba llot akseꞌ leꞌen, kat bllin diꞌll rao beꞌnnenꞌ nak xan yeolol wakaꞌa ya kaꞌ, naꞌ bnnezreꞌ llak da nne xhen Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Naꞌll bzaꞌdo beꞌnnenꞌ ncheꞌteꞌ txhonnj wakaꞌa ya rente xan akeꞌ. Ka breꞌe akreꞌ beꞌnn wakaꞌa ya kaꞌ, bsan akeꞌ bill ben akeꞌ ziꞌ ke Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ka bllin beꞌnnenꞌ ganꞌ llaꞌa beꞌnn kaꞌ, naꞌ golleꞌ wakaꞌa ya kaꞌ beꞌx akeꞌ Pablonꞌ, naꞌ bchej akeꞌ leꞌe chop gden. Naꞌll bnnabeꞌ no beꞌnnenꞌ, naꞌ bixha beneꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bixha beꞌnn zan kaꞌ kon llosiaꞌ akeꞌ, wde wdere da ne toto akeꞌ, naꞌ beꞌnnenꞌ ni ke llejnieꞌzreꞌ bixhanꞌ ne akeꞌ, kon llak llakia. Naꞌ golleꞌ wakaꞌa ya kaꞌ bacheꞌe akeꞌ Pablonꞌ ganꞌ llaꞌa akeꞌ naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ka bllin akeꞌ ganꞌ xhoa neꞌp ke ganꞌ llaꞌa wakaꞌa ya kaꞌ, naꞌ blen wakaꞌa ya kaꞌ Pablonꞌ rao llaze, le beꞌnn zan kaꞌ llon akeꞌ zban, lleꞌn akreꞌ wzap akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Le ne nao akeꞌ llosiaꞌ akeꞌ ne akeꞌ: —¡Llayaꞌl gat beꞌnnenꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ka ba llgoꞌ akeꞌ leꞌe ganꞌ llaꞌa wakaꞌa ya kaꞌ, Pablonꞌ lleꞌe xan wakaꞌa ya kaꞌ: —¿Bi gonnre latj nniaꞌ to chop diꞌlle? Naꞌ lle beꞌnnenꞌ leꞌe: —¿Bixha llakse nneꞌo diꞌll griegonꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Kere rweꞌn beꞌnn Egipto beꞌnn bwie beꞌnn wnebiaꞌ kaꞌ kanꞌ batnaꞌ, naꞌ byejoꞌ latj dachenꞌ bcheꞌo tap mir beꞌnn wen xhia ake? ");
INSERT INTO zpuNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Naꞌll bne Pablonꞌ: —Kere nadaꞌn, beꞌnn Israel nadaꞌ, naꞌ nakaꞌ beꞌnn Tarso to yell zaꞌk ganꞌ nbane Cilicia, ben okré benn latj weꞌrenaꞌ beꞌnn ki diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Naꞌ beꞌe beꞌnnenꞌ latj. Naꞌll bze Pablonꞌ rao neꞌp kaꞌ, naꞌ beneꞌ sen ren taꞌkeꞌ nench bllaꞌa beꞌnn kaꞌ lli, naꞌll bnneꞌe diꞌll hebreo bneꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Reꞌ beꞌnn biꞌchaꞌ, reꞌ beꞌnn gor xa, le wzenay diꞌllenꞌ niaꞌ ni. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ka ben akreꞌ nneꞌe diꞌll hebreonꞌ, yezikre bllaꞌa akeꞌ lli. Naꞌll bne Pablonꞌ: ");
INSERT INTO zpuNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Lekze beꞌnn Israel nadaꞌ, gorjaꞌ yellenꞌ re Tarso ganꞌ nbane Cilicia, naꞌ Jerusalén ni blliꞌwaꞌ, beꞌnnenꞌ re Gamaliel broeꞌ bsedreꞌ nadaꞌ, naꞌ bsedaꞌ kanꞌ nak ley danꞌ bzoj da xozxtaꞌollo kaꞌ. Do yichj do raꞌllaꞌ benaꞌ da llakraꞌ lloꞌraꞌll Dios, kanꞌ llonkze reꞌ nnaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Bdaꞌa blleꞌnawaꞌ beꞌnn kaꞌ nao nez kobenꞌ, gokraꞌllaꞌ got akeꞌ, naꞌ beꞌx akseꞌ broꞌ akeꞌ rill ya ka beꞌnn byio ren noꞌre. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Beꞌnnenꞌ nak bxoz brao, naꞌ beꞌnn gor brao kaꞌ, nnez akreꞌ kwasro kanꞌ benaꞌ. Leakeꞌ benn yich da llonn nadaꞌ latj chaꞌa ganꞌ llaꞌa beꞌnn wrall kello kaꞌ Damasco. Naꞌ byaꞌa lljeꞌxaꞌ beꞌnn kaꞌ llejleꞌ ke Jesucristonꞌ, naꞌ wacheꞌe akeꞌ Jerusalén ni, nench saꞌkziꞌ akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Bixha gok ka zyaꞌ Damasco, llonen ka do wawill byechjkze to beniꞌ da zaꞌa yebá nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Naꞌ wixaꞌ jeꞌttiaꞌ rao yo, naꞌ benraꞌ chiꞌi to beꞌnn bneꞌe: “Saulo, Saulo, ¿bixchen daꞌo llrayoꞌ nadaꞌ?” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Naꞌll balliaꞌ xtiꞌlleꞌn, llepeꞌ: “¿Noxha rweꞌ Xanaꞌ?” Naꞌ bneꞌe: “Nadaꞌn Jesús beꞌnn Nazaret, nadaꞌn daꞌo llrayoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Naꞌ beꞌnn kaꞌ zaꞌrén nadaꞌ txhen naꞌ breꞌe akreꞌ beniꞌn, naꞌ blleb akeꞌ, naꞌ bi byejnieꞌ akreꞌ kanꞌ bne beꞌnnenꞌ balwill nadaꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Naꞌll llepeꞌ: “¿Bixha gonaꞌ, Xanaꞌ?” Naꞌll bneꞌe: “Bayas, naꞌ byejkze Damasconꞌ. Gannaꞌ nne akeꞌ bi llayaꞌl gonoꞌ.” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bacholtiaꞌ ka nak byoꞌ beniꞌn rawaꞌ. Beꞌnn kaꞌ zyaꞌrenaꞌ txhen naꞌ, beꞌx akeꞌ taꞌkaꞌ, kaꞌ gok bllinaꞌ Damasconꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Naꞌ zo to beꞌnn lloeꞌrao Dios re Ananías, lloneꞌ kanꞌ ne ley kellonꞌ. Yeolol beꞌnn Israel kaꞌ llaꞌa Damasconꞌ, ne akeꞌ nakeꞌ beꞌnn wen. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bedeꞌ ganꞌ zoaꞌn, naꞌ lleꞌe nadaꞌ: “Saulo biꞌchaꞌ, nnaꞌ yereꞌroꞌ da yobre.” Naꞌ le bareꞌteraꞌ, naꞌll gok breꞌreꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Naꞌll bneꞌe: “Dios ke xozxtaꞌollo kaꞌ, ba brejeꞌ rweꞌ nench nnezroꞌ bixhanꞌ lleꞌnreꞌ gonoꞌ, naꞌ ba breꞌroꞌ Xhiꞌnneꞌ beꞌnn zerao nak beꞌnn wen, naꞌ ba benroꞌ xtiꞌlleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Naꞌll weꞌo xtiꞌlleꞌn rao yeolol beꞌnne, naꞌ weꞌo diꞌll ke da ki ba breꞌroꞌ, naꞌ ba benroꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Naꞌ nnaꞌ, ¿bi llbexhoꞌ? Le bayasteꞌ blloa nis, naꞌ balwill Xanllo Jesucristonꞌ nench yeziꞌxheneꞌ koꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Naꞌ gok ka bayedaꞌ Jerusalén ni, ka llalwillaꞌ Dios lo yodaꞌo braonꞌ breꞌdaꞌoraꞌ, broeꞌrao Jesúsenꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Naꞌ bneꞌe: “Beꞌlaꞌll blloj Jerusalén naꞌ, le bi chejleꞌ akeꞌ diꞌllenꞌ weꞌo kiaꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Naꞌ nadaꞌ llepeꞌ: “Xanaꞌ, leakeꞌ nnez akreꞌ kanꞌ benaꞌ jataꞌa toto ganꞌ zo yodaꞌo, llayirjaꞌ beꞌnn kaꞌ nxenraꞌll rweꞌn, naꞌ llgoꞌ akeꞌ rill ya, naꞌ lloaꞌ latj llon akeꞌ ziꞌ ke akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kanꞌ bet akeꞌ Esteban beꞌnnenꞌ beꞌe xtiꞌlloꞌn, nadaꞌ ziaꞌ gokaꞌ txhen beꞌnn kaꞌ bet leꞌen, nadaꞌ bdapaꞌ xharaꞌn akeꞌn.” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bixha Jesúsenꞌ bneꞌe: “Lla blloje, nadaꞌ wseꞌlaꞌ rweꞌ ziꞌte ga llaꞌa beꞌnn kaꞌ bi nak beꞌnn Israel.” ");
INSERT INTO zpuNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Zerao to kat bzenay akeꞌ xtiꞌll Pablonꞌ, naꞌll bzorao llosiaꞌ akeꞌ da yobre ne akeꞌ: —¡Bill llayaꞌl so beꞌnnenꞌ yellrio, llayaꞌl gateꞌ! ");
INSERT INTO zpuNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Yezikre llosiaꞌ akeꞌ, llzaꞌl xharaꞌn akeꞌ, naꞌ llzaꞌl akeꞌ bichte yo rao lla. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Naꞌ xan wakaꞌa yanꞌ golleꞌ beꞌnn kaꞌ broꞌ akeꞌ Pablonꞌ ganꞌ llaꞌa wakaꞌa ya kaꞌ, leskaꞌ golleꞌ leakeꞌ chintat akeꞌ leꞌe, nench nneꞌe bixchen llosiaꞌ beꞌnn kaꞌ llwie leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bixha ba nllejteꞌ sorao chintat akeꞌ leꞌen, Pablonꞌ lleꞌe to beꞌnn kaꞌ ze kwiteꞌn: —¿Bixha de latj to beꞌnn nde leꞌ yich nakeꞌ beꞌnn Roma chin akeꞌ leꞌe, ka za gaktere yel koxchis keꞌen? ");
INSERT INTO zpuNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ka bene beꞌnnenꞌ kaꞌ, naꞌ byejeꞌ jelleꞌ xan wakaꞌa ya kaꞌ: —Bwiayaꞌnn kanꞌ gonoꞌn, nde beꞌnnenꞌ leꞌ yich nakeꞌ beꞌnn Roma. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Naꞌll byejdo xan wakaꞌa ya kaꞌ ganꞌ ze Pablonꞌ, naꞌ lleꞌe leꞌe: —¿Da li de xhlichoꞌ nakoꞌ beꞌnn Roma? Naꞌll bne Pablonꞌ: —Awaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Naꞌll bne beꞌnnenꞌ: —Da xhen mell bxhaꞌkraꞌn nadaꞌ nench gokaꞌ beꞌnn Roma. Naꞌll bne Pablonꞌ: —Ka gorjtiaꞌ nakaꞌ beꞌnn Roma. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Beꞌnn kaꞌ gokraꞌll chin leꞌen blleꞌyiꞌll akeꞌ, leskaꞌ xan wakaꞌa ya kaꞌ, ka bnnezreꞌ Pablonꞌ ndieꞌ yich nakeꞌ beꞌnn Roma, bllebeꞌ kwis ke naken beꞌe latj bchej akeꞌ leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Bateyó xan wakaꞌa ya kaꞌ, lleꞌnreꞌ nnezreꞌ kwasro bixchen llao beꞌnn Israel kaꞌ xhia ke Pablonꞌ. Naꞌ bakeꞌe gden naꞌ, nllej taꞌk Pablonꞌ, naꞌll batopeꞌ bxoz wnebiaꞌ kaꞌ, naꞌ yeolol beꞌnn gor brao kaꞌ llnebiaꞌ Israelenꞌ, naꞌ brejeꞌ Pablonꞌ bzeꞌe leꞌe kllol akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Naꞌ Pablonꞌ, ka breꞌreꞌ beꞌnn wnebiaꞌ kaꞌ, lleꞌe leakeꞌ: —Reꞌ beꞌnn biꞌchaꞌ, chak ba bzorenaꞌ reꞌ bllinte nnaꞌ lla, nbaraz zo yichjraꞌlldaꞌwaꞌ llonaꞌ kanꞌ llazraꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Naꞌ bxoz braonꞌ re Ananías golleꞌ beꞌnn kaꞌ ze kwit Pablonꞌ, bdap akeꞌ lloeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pablonꞌ lleꞌe leꞌe: —Dios kapeꞌ rweꞌ, beꞌnn wxhiyeꞌe, lliaꞌo gannaꞌ, gonoꞌ yel koxchis kanꞌ ne leyenꞌ, naꞌ llxinnjoꞌ, bi llonoꞌ kanꞌ ne leyenꞌ ke naken beꞌo latj bdap akeꞌ nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Beꞌnn kaꞌ llaꞌa gannaꞌ, lle akeꞌ Pablonꞌ: —¿Bixchen lleꞌo bxoz brao ke Diosenꞌ kaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Naꞌll bne Pablonꞌ: —Beꞌnn biꞌchaꞌ ak, kere llakraꞌ chaꞌ bxoz braonꞌ, le ki nyoj xtiꞌll Diosenꞌ: “Bi nneꞌo zban ke beꞌnnenꞌ llnebiaꞌ rao yell koꞌo.” ");
INSERT INTO zpuNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pablonꞌ breꞌreꞌ beꞌnn kaꞌ llaꞌn, baleꞌ nak beꞌnn fariseo, naꞌ ye baleꞌ nak beꞌnn saduceo, naꞌll bnneꞌe zillje: —Lewzenay ke biꞌchaꞌ, nadaꞌ nakaꞌ beꞌnn fariseo, leskaꞌ biꞌch lwelljaꞌ nak akeꞌ beꞌnn fariseo. Naꞌ zoaꞌ ni, llonre yel koxchis kiaꞌ, ni ke danꞌ llejliaꞌ yebán beꞌnn wat kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ka bne Pablonꞌ kaꞌ, gok beꞌnn kaꞌ chopre, beꞌnn fariseo kaꞌ, naꞌ beꞌnn saduceo kaꞌ, bzorao llaꞌdyiꞌ lwellj akeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Le beꞌnn saduceo kaꞌ, bi llejleꞌ akeꞌ chaꞌ yebán beꞌnn wat kaꞌ, naꞌ ne akeꞌ nono angl, naꞌ bibi spíritu zo. Naꞌ beꞌnn fariseo kaꞌ llejleꞌ akeꞌ yeolol da ki. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Llakia kwis llak llchachrén lwellj akeꞌ. Naꞌ bzollaꞌa beꞌnn kaꞌ llsedre ke ley danꞌ bzoj da Moisésenꞌ, llon akeꞌ txhen beꞌnn fariseo kaꞌ, bne akeꞌ: —Bibi doꞌl ke beꞌnnenꞌ de, bixha chaꞌ to alm o chaꞌ to angl balwill leꞌe, bi gonllo kaꞌ, nxholl gonllo da bi lloꞌraꞌll Diosenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Naꞌ blleꞌ to wdil xhen radj akeꞌn, to blleb xan wakaꞌa ya kaꞌ wxhoxhjtin akeꞌ Pablonꞌ. Naꞌ golleꞌ beꞌnn wakaꞌa ya kaꞌ, jaxhob akeꞌ leꞌe radj akeꞌn, naꞌ bacheꞌe akeꞌ leꞌe ganꞌ llaꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Bateyó, tlleꞌle broeꞌrao Xanllo Jesucristonꞌ, Pablonꞌ, lleꞌe leꞌe: —Bendipraꞌll Pablo, kanꞌ benoꞌ beꞌo xtiꞌllaꞌn Jerusalén ni, kaꞌkze gonoꞌ kat llinoꞌ Roma. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Naꞌ bateyó bal beꞌnn Israel kaꞌ, beꞌe akeꞌ diꞌll got akeꞌ Pablonꞌ, naꞌ bcheb akeꞌ bne akeꞌ: —Bi yeꞌj gaokzllo llinte kat gotllo Pablonꞌ, Dios wlleyieꞌ kon to lliꞌo chaꞌ bi gonllo danꞌ ba bnello gonllo. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nak ka choa (40) wde beꞌnn kaꞌ beꞌe diꞌllenꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Naꞌll byej akeꞌ rao bxoz wnebiaꞌ kaꞌ, naꞌ rao beꞌnn gor brao ke beꞌnn Israel kaꞌ, naꞌ goll akeꞌ leakeꞌ: —Ba bentoꞌ diꞌll bi yeꞌj gaotoꞌ llinte kat gottoꞌ Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Naꞌ lleꞌnetoꞌ reꞌ beꞌnn wnebiaꞌ yere xan wakaꞌa ya kaꞌ, yedweꞌe Pablonꞌ raorenꞌ, yereꞌ lleꞌnere nnézere ye to chop binꞌ lloneꞌ, naꞌ netoꞌ kweꞌnaotoꞌ tnez gottoeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bixha to bi nak xhiꞌnn noꞌr zan Pablonꞌ, bénebeꞌ kanꞌ llwia akeꞌ gon akeꞌn, naꞌ byejbeꞌ ganꞌ llaꞌa wakaꞌa ya kaꞌ, naꞌ gollbeꞌ Pablonꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pablonꞌ goxheꞌ to beꞌnn nak xan wakaꞌa ya kaꞌ, lleꞌe leꞌe: —Jwaꞌa bi ni rao xanrenꞌ, de to diꞌll weꞌrenbeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Naꞌ bcheꞌe beꞌnnenꞌ lebeꞌ, jweꞌebeꞌ rao xan akeꞌn, naꞌ lleꞌe leꞌe: —Pablonꞌ beꞌnnenꞌ yoꞌ rill yanꞌ bnnabeꞌ okré yedwaꞌa bi ni raoꞌn, de to diꞌll weꞌrenbeꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Beꞌnnenꞌ llnebiaꞌn beꞌxeꞌ taꞌkbeꞌ, bcheꞌebeꞌ ga yobre, naꞌ bnnabrebeꞌ: —¿Bi diꞌllenꞌ lleꞌnroꞌ weꞌrenoꞌ nadaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Naꞌll llebeꞌ leꞌe: —Beꞌnn wrall ketoꞌ kaꞌ, ba beꞌe akeꞌ diꞌll, ye akeꞌ rweꞌ, wxe lljwaꞌo Pablonꞌ rao beꞌnn wnebiaꞌ ke akeꞌ kaꞌ, nne akeꞌ lleꞌn akreꞌ nnez akreꞌ ye to chop diꞌll binꞌ lloneꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bi chejleꞌo ke akeꞌ, ke do choa beꞌnn kaꞌ kweꞌnao akeꞌ leꞌe tnez, ba beꞌe akeꞌ diꞌll, bi yeꞌj gao akeꞌ llinte kat got akeꞌ Pablonꞌ. Naꞌ nnaꞌ to llbexh akzeꞌ bi nneꞌo rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ka bazaꞌbeꞌ naꞌ, xan wakaꞌa ya kaꞌ lleꞌebeꞌ, nono yebeꞌ ka diꞌllenꞌ beꞌe akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Naꞌll xan wakaꞌa ya kaꞌ goxheꞌ chop beꞌnn kaꞌ nlan to gayoa (100) wej wakaꞌa ya, naꞌ golleꞌ leakeꞌ gon akeꞌ xhnid chop gayoa (200) wakaꞌa ya, ye wyon chi (70) beꞌnn llbia kabay, naꞌll chop gayoa (200) beꞌnn llak yitjen yay da nak da rao la nench lljakeꞌ Cesarea lladá ga tlleꞌle. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Leskaꞌ lleꞌe leakeꞌ gon akeꞌ xhnid to kabay kwia Pablonꞌ nench llineꞌ wen ka nak lljwaꞌa akeꞌ leꞌe rao beꞌnnenꞌ llnebiaꞌn re Félix. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Naꞌll bzojeꞌ to yich da bseꞌleꞌ rao beꞌnnenꞌ llnebiaꞌn nen ki: ");
INSERT INTO zpuNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nadaꞌ Claudio Lisias, llzojaꞌ rweꞌ beꞌnn llnebiaꞌ, rweꞌ Félix, nakoꞌ beꞌnn brao, llwapaꞌ rweꞌ lliox. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Beꞌnn Israel kaꞌ beꞌx akeꞌ beꞌnnenꞌ gokraꞌll akeꞌ got akeꞌ leꞌe. Bixha bnnezraꞌ ndieꞌ yich nakeꞌ beꞌnn Roma, naꞌ bakeꞌe rao naꞌa akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Gokraꞌllaꞌ nnezraꞌ bi ken llao akeꞌ xhia keꞌe, naꞌ jweꞌe rao beꞌnn wnebiaꞌ ke akeꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Naꞌ benraꞌ llao akeꞌ xhia bi lloneꞌ ka ne ley ke akeꞌn. Bixha ke nak da ni, bi naken zi gotlloeꞌ, naꞌ bi naken zi choeꞌ rill yanꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bixha bnnézkzeraꞌ beꞌnn Israel kaꞌ beꞌe akeꞌ diꞌll kweꞌnao akeꞌ leꞌe nench got akeꞌ leꞌe. Ke len naꞌ llseꞌleꞌ raoꞌn, naꞌ leskaꞌ ba gollaꞌ beꞌnn kaꞌ llao xhianꞌ yed akeꞌ raoꞌn, naꞌ nne akeꞌ binꞌ de ke akeꞌ ren leꞌe. Sochgoꞌ wen.” ");
INSERT INTO zpuNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bllin tlleꞌle, naꞌ ben wakaꞌa ya kaꞌ kon kanꞌ bne xan akeꞌ, bcheꞌe akeꞌ Pablonꞌ, jwaꞌa akeꞌ leꞌe ganꞌ ne Antípatris. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bateyó wakaꞌa ya kaꞌ jak kon niaꞌ babiꞌ akeꞌ ganꞌ llaꞌa akeꞌn naꞌ zjak zreze beꞌnn kaꞌ llia kabayenꞌ ren Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ka bllin akeꞌ ganꞌ nziꞌi Cesareanꞌ, naꞌ beꞌe akeꞌ beꞌnnenꞌ llnebiaꞌn yichenꞌ, leskaꞌ ben akteꞌ Pablonꞌ rallneꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Bayoll beleꞌ yichenꞌ naꞌ bnnabeꞌ ga beꞌnne Pablonꞌ, naꞌ ka bnnezreꞌ zeꞌe ganꞌ nziꞌi Cilicia, ");
INSERT INTO zpuNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","naꞌll lleꞌe Pablonꞌ: —Nnaꞌ weꞌllo diꞌll katenꞌ yed beꞌnn kaꞌ llao xhianꞌ. Naꞌ golleꞌ leakeꞌ jaloꞌ akeꞌ leꞌe lo yoꞌ ganꞌ llon Herodes yel koxchis. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Gok gaꞌy lla zo Pablonꞌ Cesareanꞌ, naꞌll bllin Ananías beꞌnnenꞌ nak bxoz brao, ncheꞌteꞌ beꞌnn gor brao ke beꞌnn Israel kaꞌ, leskaꞌ ncheꞌe akteꞌ to beꞌnn re Tértulo beꞌnn llak lloeꞌ diꞌll rao lkweꞌ beꞌnne. Naꞌll jakeꞌ rao beꞌnnenꞌ llnebiaꞌn, llao akeꞌ xhia ke Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bixha ka jaxiꞌi akeꞌ Pablonꞌ, Tértulonꞌ bzorao llaweꞌ xhia, neꞌe: —Ni koꞌo rweꞌ, beꞌnn llnebiaꞌ netoꞌ, llaꞌtoꞌ wen, llioxkenoꞌn llak llgoꞌ xhnnez danꞌ llak rao rall-llo, le nakoꞌ beꞌnn llejnieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Llazraꞌlltoꞌ yeolol da kaꞌ llonoꞌn, naꞌ gateze llaꞌa beꞌnn llonn akeꞌ yel llioxken koꞌo. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Naꞌ bi lleꞌnetoꞌ gontoꞌ zan diꞌll chaꞌ de billre da gonoꞌ, llnnabtoꞌ gonoꞌ okré wzenayoꞌ ketoꞌ chollteze. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Zaꞌtoꞌ zadtaotoꞌ xhia ke beꞌnnenꞌ ze raoꞌ ni, nakeꞌ to beꞌnn wen da xhinnj, deꞌe llyixjeꞌ da zed doxhen, kon ga llaꞌa beꞌnn Israel llejeꞌ, naꞌ lloneꞌ leakeꞌ chopre. Nakeꞌ beꞌnn brao rao beꞌnn kaꞌ nziꞌi Nazareno. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Naꞌ gokraꞌlleꞌ goneꞌ da xhinnj kwis lo yodaꞌo ketoꞌn. Naꞌllenꞌ beꞌxtoeꞌ gokraꞌlltoꞌ gontoꞌ yel koxchis keꞌe kon kanꞌ ne ley ketoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Bixha xan wakaꞌa yanꞌ beꞌnnenꞌ re Lisias, da bien byoeꞌ radjtoꞌn, bakeꞌe leꞌe rao naꞌtoꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Leꞌen bseꞌleꞌ netoꞌ yedtoꞌ ganni, yedtaotoꞌ xhia rao rweꞌ ni. Naꞌ ka nak gonoꞌ yel koxchisenꞌ, wnnabke rweꞌ, naꞌ nnezroꞌ diꞌll linꞌ lloeꞌrentoꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ren beꞌnn Israel kaꞌ ze akeꞌ, ne akeꞌ kaꞌn naken. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Naꞌll beꞌnnenꞌ llnebiaꞌn beneꞌ sen rao Pablonꞌ nench nneꞌe. Naꞌll bne Pablonꞌ: —Nnezraꞌ ba gok zan iz rweꞌ llonoꞌ yel koxchis ke yell kellonꞌ, ke len naꞌ llaweraꞌ niaꞌ to chop diꞌll ke danꞌ llao beꞌnn ki xhia kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Chinze gok chllinn (12) lla byaꞌa Jerusalén naꞌ, jeꞌrawaꞌ Diosenꞌ. Wakse wnnab akroeꞌ nench nnezroꞌ diꞌll linꞌ lloaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kere breꞌe akreꞌ nadaꞌ llakyollrenaꞌ beꞌnne, ni ker llta llnniaꞌ beꞌnne do lo yodaꞌo braonꞌ, ni lo yodaꞌo yobre, naꞌ do lyellenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ni ke deze da lloeꞌ diꞌll chaꞌ da li danꞌ llao akeꞌ xhianꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Naꞌ ni llniaꞌ rweꞌ, llonaꞌ xchin Diosenꞌ beꞌnn beꞌrao xozxtaꞌotoꞌ kaꞌ, naꞌ laꞌkze nawaꞌ nez kob danꞌ ne leakeꞌn da xhinnj, naꞌ llejliaꞌ doxhen da kaꞌ llia leꞌ leyenꞌ, naꞌ danꞌ bzoj beꞌnn kaꞌ beꞌe xtiꞌll Diosenꞌ kanaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nadaꞌ llonaꞌ rez, leskaꞌ leakeꞌn llon akeꞌ rez yesbán Diosenꞌ beꞌnn wat kaꞌ, yesbaneꞌ beꞌnn ben da wen naꞌ beꞌnn ben da xhinnj. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ke len llonaꞌ bien llonaꞌ da wen nench kaꞌ bibi de gao xhia kiaꞌ rao Xanllo Dios, naꞌ rao beꞌnnach. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Ba gokte zan iz daꞌa gateze, naꞌ bayedaꞌ rallaꞌ, badsanaꞌ mell btopaꞌ nench gakrenaꞌ beꞌnn yaꞌche, leskaꞌ jasanaꞌ ye raꞌtenꞌ lo yodaꞌo braonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ka goken zoaꞌ yodaꞌo braonꞌ llonaꞌ kanꞌ ne leyenꞌ, naꞌ ba naksaꞌ yall, kat to chop beꞌnn Israel zaꞌk Asia breꞌe akreꞌ nadaꞌ, kere nello llta llnniaꞌ beꞌnn zan ake, kanꞌ ne akeꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Leakeꞌn llayaꞌl yedsé akeꞌ ganni gao akeꞌ xhia, chaꞌ bi de ke akeꞌ kone nadaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Naꞌ chaꞌ beꞌnn kaꞌ ze gannizenꞌ wak nne akeꞌ chaꞌ wroeꞌrao bi da xhinnj benaꞌ kanꞌ jasiaꞌ rao bxoz wnebiaꞌ kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Lete to da bniaꞌ kanꞌ jesiaꞌ radj akeꞌn, besiaꞌ goll akeꞌ: “Ka nak yel koxchis kiaꞌn llonre nnaꞌ lla, llonren danꞌ llejliaꞌ wllin lla yebán beꞌnn kaꞌ ba got.” ");
INSERT INTO zpuNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Naꞌ Félixenꞌ ba nnezreꞌ kanꞌ nak nez kob ke Jesucristonꞌ, naꞌ kate benreꞌ kanꞌ bne Pablonꞌ, naꞌll bkwaꞌnneꞌn gaken ye to lla yobre, lleꞌe leakeꞌ: —Kat yed xan wakaꞌa ya kaꞌ re Lisias, wnnabyollyaꞌnnaꞌ akrenꞌ nak kerénꞌ, kanaꞌ wayej diꞌll da yobre. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Naꞌ golleꞌ to beꞌnnenꞌ nak xan wakaꞌa ya kaꞌ, za yoꞌz Pablonꞌ rill yanꞌ, naꞌ gaꞌt latj chaꞌ bi lleꞌnreꞌ goneꞌ, naꞌ weꞌe latj yedraꞌnn beꞌnn kaꞌ nllieꞌ leꞌen, naꞌ gakrén akeꞌ leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Naꞌ bazaꞌa Félixenꞌ, naꞌ kat gok chop chonn lla ballineꞌ ren noꞌr keꞌe, naꞌ noꞌr keꞌen nakeꞌ beꞌnn Israel naꞌ re Drusila. Goxheꞌ Pablonꞌ, naꞌ bzenayeꞌ kanꞌ llayaꞌl wxenraꞌll-llo Jesucristonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bixha goll Pablonꞌ leꞌe, llayaꞌl gonllo da nak lixheje, naꞌ bi gontekllo danꞌ zeraꞌll lo yichjraꞌlldaꞌollonꞌ, naꞌ lleꞌe leꞌe wllin lla gon Diosenꞌ yel koxchis kello. Naꞌll blleb Félixenꞌ kwis, naꞌll lleꞌe Pablonꞌ: —Ba gokse wayejoꞌ. Kat gaꞌt latj kiaꞌ, naꞌ gaxhaꞌ rweꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Le leskaꞌ gokraꞌlleꞌ weꞌe Pablonꞌ leꞌe mell nench yesaneꞌ leꞌe, ke len weltze llaxheꞌ Pablonꞌ lloeꞌreneꞌ leꞌe diꞌlle. ");
INSERT INTO zpuNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kaꞌ gokte chop iz, kat bill bnebiaꞌ Félixenꞌ, naꞌ bnebiaꞌ beꞌnn yobre beꞌnn re Porcio Festo. Naꞌ Félixenꞌ bkwaꞌnneꞌ Pablonꞌ lo rill yanꞌ, nechkze bgaꞌnneꞌ wen rao beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Naꞌ bllin beꞌnnenꞌ re Festo, gok chonn lla bzeꞌe Cesareanꞌ byejeꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Naꞌ jak bxoz wnebiaꞌ kaꞌ, naꞌ ren beꞌnn kaꞌ nak beꞌnn gor brao ke beꞌnn Israel kaꞌ, jak akeꞌ rao Festonꞌ llao akeꞌ xhia danꞌ llon Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Llnnab akeꞌ goneꞌ okré lljasaneꞌ Pablonꞌ Jerusalén naꞌ. Naꞌ leakeꞌn ba noeꞌ akeꞌ diꞌll got akeꞌ leꞌe tnez. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festonꞌ lleꞌe beꞌnn kaꞌ ka nak Pablonꞌ yoeꞌ rill ya Cesareanꞌ, naꞌ leꞌen le wayejteꞌ Cesareanꞌ, ");
INSERT INTO zpuNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","naꞌ lleꞌe leakeꞌ: —Lelloj balre nak beꞌnn wnebiaꞌ, saꞌrenre nadaꞌ chejllo Cesareanꞌ, chaꞌ bi da xhinnj ben beꞌnnenꞌ naꞌ gaore xhia. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festonꞌ bzoeꞌ Jerusalén naꞌ, ye xoꞌn ga chi lla, naꞌll bazeꞌe zayejeꞌ Cesareanꞌ. Naꞌ bateyó ka ballineꞌn, bllieꞌ ganꞌ lloneꞌ yel koxchisenꞌ, naꞌ bseꞌleꞌ beꞌnn kaꞌ jaxiꞌi akeꞌ Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ka bllin Pablonꞌ raweꞌn naꞌ, jabiꞌy beꞌnn Israel kaꞌ zaꞌk Jerusalén. Naꞌ bzorao akeꞌ llao akeꞌ xhia ke Pablonꞌ, lltob akreꞌ leꞌe da zan da ne akeꞌ beneꞌ, bixha ni to da ki bi broeꞌn chaꞌ naken da li. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Leskaꞌ Pablonꞌ llakrén kwineꞌ, bneꞌe: —Bibi nna gonaꞌ da wkwaꞌnn nadaꞌ tore rao ley ke beꞌnn Israel kaꞌ, ni kon ren yodaꞌo braonꞌ, ni kone César beꞌnnenꞌ llnebiaꞌ doxhen Roma bibi da xhinnj nna gonaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Naꞌ Festonꞌ gokraꞌlleꞌ yegaꞌnneꞌ wen rao beꞌnn Israel kaꞌ, naꞌll lleꞌe Pablonꞌ: —¿Lleꞌnroꞌ wayejoꞌ Jerusalén naꞌ gonaꞌ yel koxchis koꞌo gannaꞌ? ");
INSERT INTO zpuNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Naꞌ bne Pablonꞌ: —Ba zekzaꞌ raoꞌ ni, le nzoa rey Césarenꞌ rweꞌ gonoꞌ yel koxchis, ganni llayaꞌl gak yel koxchis kiaꞌn. Rweꞌ nnézkzeroꞌ, bibi benaꞌ ke beꞌnn Israel kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Chaꞌ bi da xhinnj benaꞌ da llayaꞌl gataꞌ, wakse gataꞌ, kere llebaꞌn. Zan ke danꞌ lltob akreꞌ nadaꞌn, ni ton bi nak da li, naꞌ bi gak kwaꞌnnre nadaꞌ rallnaꞌa beꞌnn kaꞌ. Lleꞌnkzraꞌ kwin rey Césarenꞌ goneꞌ yel koxchis kiaꞌn chet kaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festonꞌ, bayoll beꞌreneꞌ diꞌll beꞌnn kaꞌ llnebiaꞌreneꞌ naꞌ, naꞌll lleꞌe Pablonꞌ: —Ka naken lleꞌnroꞌ kwin Césarenꞌ goneꞌ yel koxchis koꞌon, dekz de chejoꞌ rao leꞌe. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Bde chop chonn lla, reyenꞌ re Agripa ren bi zaneꞌ noꞌrenꞌ re Berenice, bllin akeꞌ Cesareanꞌ jaraꞌnn akeꞌ Festonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ka nak bzo akeꞌ zan lla naꞌ, beꞌrén Festonꞌ leꞌe diꞌll ke Pablonꞌ, bneꞌe: —Zo to beꞌnn bkwaꞌnn Félixenꞌ rill ya. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ka byaꞌa Jerusalén naꞌ, bed beꞌnn kaꞌ nak bxoz wnebiaꞌ ak, naꞌ beꞌnn gor brao ke beꞌnn Israel kaꞌ rawaꞌn, llao akeꞌ xhia, lleꞌn akreꞌ wsaꞌkzieꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Naꞌll goll akeꞌ, lliꞌo beꞌnn Roma bi gak wchoyllo ke beꞌnne gateꞌ, chaꞌ bi nna gaꞌt latj nneꞌe gakrén kwineꞌ rao beꞌnn kaꞌ llao xhia keꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Naꞌ kate braꞌ akeꞌ ganni, bi brexhaꞌ; bateyoze le byaꞌtiaꞌ ganꞌ llak yel koxchisenꞌ, naꞌ goll akeꞌ lljaxhiꞌi akeꞌ beꞌnnenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Naꞌll bed beꞌnn kaꞌ llao xhianꞌ, naꞌ llakraꞌ chaꞌ billre da xhinnj yobre wtob akreꞌ leꞌen. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Renchaꞌ da llak ke danꞌ nao akeꞌ naꞌzenꞌ, naꞌ ke ye to beꞌnn ba got re Jesús, bixha Pablonꞌ deꞌe neꞌe nbankzeꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nadaꞌ bi nnezraꞌ ke da kaꞌ, naꞌll bnnabreꞌ chaꞌ lleꞌnreꞌ wayejeꞌ Jerusalén naꞌ, gak yel koxchis keꞌen gannaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Naꞌ Pablonꞌ bnnabeꞌ tieꞌ rao kwin Césarenꞌ, nench gak yel koxchis keꞌen. Ke len naꞌ bkwaꞌnneꞌ lo rill yanꞌ, llinte katenꞌ wseꞌleꞌ rao rey César naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Naꞌll Agripanꞌ lleꞌe Festonꞌ: —Leskaꞌ nadaꞌ lleꞌnraꞌ wzenayaꞌ diꞌllenꞌ lloeꞌ beꞌnnenꞌ. Naꞌll bne Festonꞌ: —Wxe wzenayoꞌ xtiꞌlleꞌn. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bixha bateyó ka bllin rey Agripanꞌ ren Berenicenꞌ, da nne xhen gok ka bllin akeꞌn, naꞌ blleꞌ akeꞌ ganꞌ llbeꞌ Festonꞌ lloneꞌ yel koxchisenꞌ, naꞌ ren beꞌnn nak xan wakaꞌa ya, naꞌ bal beꞌnn nak beꞌnn brao rao yellenꞌ. Naꞌ bseꞌl Festonꞌ beꞌnn kaꞌ jaxhiꞌi akeꞌ Pablonꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Naꞌll bne Festonꞌ: —Rey Agripa, naꞌ yeololre llaꞌllo txhen ganni, ni ze beꞌnnenꞌ, yeolol beꞌnn Israel kaꞌ llao akeꞌ xhia keꞌe, ka beꞌnn llaꞌa Jerusalén, naꞌll beꞌnn kaꞌ llaꞌa Cesarea, naꞌ llchieꞌ akreꞌ kwis, llnnab akeꞌ llayaꞌl gateꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Naꞌ kon kaꞌ llakraꞌ nadaꞌ, bibi da xhinnj beneꞌ da nnello llayaꞌl gateꞌ. Lete to da bnnabeꞌ tieꞌ rao Césarenꞌ goneꞌ yel koxchis keꞌen. Naꞌ llwiaꞌ wseꞌleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bixha ka nak bibi de wzojaꞌ chixjweꞌraꞌ Césarenꞌ bi yaꞌnnenꞌ beneꞌ; ke len ba brejeꞌ, ba nzieꞌ raore ni, naꞌ rao rweꞌ rey Agripa, naꞌ wakse wnnabyoll rweꞌ, naꞌ gaꞌt da wzojaꞌ Césarenꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","To da ke nxhia gonaꞌ chaꞌ wseꞌleꞌ, naꞌ bi yepaꞌ Césarenꞌ bi ken llseꞌleꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Naꞌll Agripanꞌ lleꞌe Pablonꞌ: —Bnechk nnaꞌ bixhanꞌ lleꞌnroꞌ nneꞌo. Naꞌll blis naꞌa Pablonꞌ, bzorao lloeꞌ diꞌllenꞌ, neꞌe: ");
INSERT INTO zpuNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Da wen kwis ba gok kiaꞌ ka nak bziaꞌ raoꞌn, rey Agripa, nench waꞌa diꞌll ke da kaꞌ llao beꞌnn Israel kaꞌ xhia kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Rweꞌ nnezkzroꞌ kanꞌ nak danꞌ nao netoꞌ, beꞌnn Israel, naꞌ da kaꞌ llakyollrentoꞌ. Ke len lleꞌnraꞌ gakxhenraꞌlloꞌ nadaꞌ wzenayoꞌ kiaꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Yeolol beꞌnn Israel kaꞌ nnez akreꞌ kwasro, ka benaꞌ ka nna naktiaꞌ xkwiꞌde chak bzoaꞌ rallaꞌ, leskaꞌ ka bzoaꞌ Jerusalén naꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Leskaꞌ nnez akreꞌ, naꞌ wakse ne akeꞌ chaꞌ lleꞌn akreꞌ, nna naktiaꞌ xkwiꞌde gokaꞌ txhen ren beꞌnn kaꞌ nziꞌi fariseo, leakeꞌn nao leyenꞌ klleꞌllo. ");
INSERT INTO zpuNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Danꞌ llejliaꞌ ke Diosenꞌ yesbaneꞌ beꞌnn wat kaꞌ kanꞌ bchebeꞌ ren da xozxtaꞌotoꞌ kaꞌ, llakllaꞌa akeꞌ nadaꞌ, ke len naꞌ llao akeꞌ xhianꞌ. ");
INSERT INTO zpuNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Chllinn (12) kwen ka nak yeolol beꞌnn Israel kaꞌ, llon akeꞌ rez yesbán Diosenꞌ beꞌnn wat kaꞌ. Ni ke len naꞌ