﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpt_vpl;
CREATE TABLE zpt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpt_vpl WRITE;
INSERT INTO zpt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Leꞌa bexa ndee bexa ngok usan gox polta ten Jesucristo, dub xa ras David no xa ras Abraham. ");
INSERT INTO zpt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Leꞌa Abraham ngop Isaac, Isaac ngop Jacob, Jacob ngop Judá no stapla be wit xa. ");
INSERT INTO zpt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá cha ngop Fares no Zara, leꞌa xnaꞌa bexa usaleaꞌ Tamar. Fares ngop Esrom, Esrom ngop Aram, ");
INSERT INTO zpt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ngop Aminadab, Aminadab ngop Naasón, Naasón ngop Salmón. ");
INSERT INTO zpt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ngop Booz, leꞌa xnaꞌa Booz usaleaꞌ Rahab. Booz ngop Obed, leꞌa xnaꞌa Obed usaleaꞌ Rut. Obed ngop Isaí, ");
INSERT INTO zpt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ngop David xa nibeꞌe, David ngop Salomón, leꞌa xnaꞌa Salomón xa ngok xagots ten Urías. ");
INSERT INTO zpt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ngop Roboam, Roboam ngop Abías, Abías ngop Asa, ");
INSERT INTO zpt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngop Josafat, Josafat ngop Joram, Joram ngop Uzías. ");
INSERT INTO zpt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ngop Jotam, Jotam ngop Acaz, Acaz ngop Ezequías. ");
INSERT INTO zpt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ngop Manasés, Manasés ngop Amón, Amón ngop Josías. ");
INSERT INTO zpt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ngop Jeconías no be wit xa, zha na lajuers mbiꞌi bexa Babilonia bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tsoꞌo na li ngwaꞌa bexa Israel gast Babilonia wa, leꞌa Jeconías ngop Salatiel, Salatiel ngop Zorobabel. ");
INSERT INTO zpt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ngop Abiud, Abiud ngop Eliaquim, Eliaquim ngop Azor. ");
INSERT INTO zpt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ngop Sadoc, Sadoc ngop Aquim, Aquim ngop Eliud. ");
INSERT INTO zpt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ngop Eleazar, Eleazar ngop Matán, Matán ngop Jacob. ");
INSERT INTO zpt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ngop Kosé. Leꞌa xagots ten Kosé usaleaꞌ Marí, xa ngop Jesús, xa nak Cristo, xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Li leꞌa Abraham no gast David leꞌa ta wa dub tidaꞌ bexa. Leꞌa David no gast zha na ngwaꞌyoꞌo bexa Israel gast Babilonia wa, leꞌa zha weꞌe uyoꞌo stub stidaꞌgal bexa. No zha na ngwaꞌa bexa Babilonia no gast zha na ngol Jesucristo wa uyoꞌo stub stidaꞌgal bexa. ");
INSERT INTO zpt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lndeꞌe ngol Jesús xa nak Cristo: Leꞌa dub xagots nsaleaꞌ Marí yá msaꞌala diꞌizh uchilyaꞌano xa dub xabgiꞌi nsaleaꞌ Kosé. Parea zha biseata ikaꞌa xa Kosé, leꞌa xa nsoꞌnola dub meꞌed, leꞌa meꞌed wa meꞌed msaꞌa Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Leꞌa Kosé wa mbinbeꞌe ulaꞌa xa Marí, ná leꞌa ta na wen nak xa ta weꞌe xagaꞌtsa ndiꞌizh ulaꞌa xa Marí, ndontsa naꞌanpa ido ladna Marí. ");
INSERT INTO zpt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Leꞌa zha na mbinbeꞌela Kosé li gun, leꞌa dub angel ten Dios mlundoꞌla ndoꞌ xa cuent dub ta mcheꞌa ladna xa, ndab angel ndoꞌ xa: —Kosé xin David, lá yuꞌ ladna lu ikaꞌa lu Marí gak xagots ten lu, leꞌa meꞌed nsoꞌno Marí leꞌa meꞌed wa meꞌed msaꞌa Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Leꞌa Marí gap dub meꞌed bgiꞌi, cha usaleaꞌ lu meꞌed wa Jesús, geal leꞌa meꞌed wa koꞌo be xmen Dios ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Leꞌa ta wa li ngok lak ndab dub xabgiꞌi mbidiꞌizh sakndoꞌ Dios tiemp polta, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Blaꞌach bego, leꞌa dub xagots ben gol ugal xabgiꞌi isoꞌno dub meꞌed. Cha gap xa dub meꞌed bgiꞌi, cha isaleaꞌ meꞌed Emanuel. (Leꞌa Emanuel dub diꞌizh hebreo gab: Dios nsoꞌ wats beuna.) ");
INSERT INTO zpt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Leꞌa gor uban Kosé ndoꞌ ta mcheꞌa ladna xa wa, cha mbin xa lak unibeꞌe angel ten Dios, ukaꞌa xa Marí gak xagots ten xa. ");
INSERT INTO zpt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ná leꞌa xa naꞌanpa ugal Marí zha biseata gap Marí meꞌed ned ten xa wa. Cha msaleaꞌ Kosé meꞌed wa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Leꞌa Jesús ngol gezh Belén ten distrit Judea, zha na nak Herodes xa nibeꞌe Judea. Weꞌe leꞌa lad nlen wizh utoꞌo pla bexa ndák, ulayaꞌ bexa gezh Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Cha unabdiꞌizh bexa ndoꞌ be men, ndab bexa: —¿Ma meꞌed ngol gak xa nibeꞌe ten bega xa judio zha? Leꞌa besa uniꞌí ulen mbeal ten xa lad nlen wizh. Ta weꞌe nseabe besa yankea besa xa. ");
INSERT INTO zpt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Leꞌa Herodes nsea itea bexa ndencho Jerusalén wa ni ko lá iniꞌí xteꞌe gun gor na mbiꞌín bexa ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Cha mchealte Herodes itea be uleꞌay nibeꞌe no be mech ten ley ten bexa judio. Cha unabdiꞌizh Herodes ndoꞌ bexa ná pa nsabndoꞌ gal Cristo xa na ndiꞌizh ga utuꞌubka Dios. ");
INSERT INTO zpt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Leꞌa bexa wa cha ukaꞌab ndab: —Leꞌa xa wa gal gezh Belén ten Judea, lak mkeꞌa dub xa mbidiꞌizh sakndoꞌ Dios tiemp polta, ndab Dios: ");
INSERT INTO zpt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lu Belén, gezh ten Judá, nsakka lu ndoꞌ itea be gezh ten Judá, geal leꞌa Belén itoꞌo dub xa nibeꞌe, xa ulaꞌach be xmen naꞌ bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Leꞌa Herodes cha xgaꞌach utezh bexa ndák wa, cha unabdiꞌizh Herodes ná xá wizh na ned uniꞌí bexa mbeal wa. ");
INSERT INTO zpt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cha mtuꞌub Herodes bexa wa gezh Belén, ndab xa: —Waꞌbe bego, cha bkwaꞌan bega pa ncho meꞌed wa. Leꞌa gor mzheal bega meꞌed, cha gidyab bega‑yá ndoꞌ naꞌ, ndontsa no naꞌ gaa sa wa, cha gankeꞌa naꞌ meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Leꞌa gor na mbiꞌín bexa ta li ndab Herodes wa, leꞌa bexa cha utoꞌo nchaꞌbe. Leꞌa mbeal na li uniꞌí bexa lad nlen wizh wa cha nchaꞌa ned ndoꞌ bexa, cha ngwaꞌisaꞌab‑a sa ncho meꞌed wa. ");
INSERT INTO zpt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Leꞌa gor na uniꞌí bexa wa mbeal nsob sa wa, leꞌa bexa uzhebpa mten ladna. ");
INSERT INTO zpt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cha uyote bexa len niꞌi wa, cha uniꞌí bexa meꞌed nsea Marí xnaꞌa meꞌed. Cha msaxib bexa ngwankea bexa meꞌed wa. Cha mxaꞌal bexa be caj noꞌo bexa, cha uloꞌo bexa pla be taꞌa uzhebpa uyap: be ta oro, no dub ta uxeꞌe ta nyolꞌ, no mirra. Cha msaꞌa bexa be ta wa ukaꞌa meꞌed‑a. ");
INSERT INTO zpt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsoꞌo wa leꞌa Dios ndab ndoꞌ bexa wa gor ndeyats bexa lá yach bexa ndoꞌ Herodes. Ta weꞌe cha nseaꞌ bexa lazh bexa ndi stub nes xaꞌaga. ");
INSERT INTO zpt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Leꞌa gor na nseaꞌla bexa ndák wa, leꞌa dub angel ten Dios mlundoꞌ ndoꞌ Kosé gor naxyats xa, ndab angel: —Goste, cha biꞌi meꞌed baꞌ no xnaꞌa meꞌed. Bxoꞌon waꞌ nacion Egipto. Cha weꞌetsa uyoꞌo bega gast zha na gáp naꞌ yach bega, leꞌa Herodes ukwaꞌan meꞌed baꞌ gut xa meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bi leꞌa teꞌal wa leꞌa Kosé cha utoꞌo no meꞌed no xnaꞌa meꞌed, nchaꞌbe bexa Egipto. ");
INSERT INTO zpt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Cha kwen uyoꞌo bexa sa wa gast ngut Herodes. Leꞌa be ta wa li ngok lak nkeaniꞌi diꞌizh ten Dios ta ndab dub xa sakndoꞌ Dios: “Uteꞌezh naꞌ xiꞌín naꞌ itoꞌo xa Egipto.” ");
INSERT INTO zpt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Leꞌa gor uniꞌí Herodes leꞌa bexa ndák wa yá lá yachtabe, cha uzhebpa ngokloo xa. Cha unibeꞌe xa ndoꞌ be soldad, ndab xa yaꞌyut bexa itea be meꞌed ncho top liꞌin, no gast be medoꞌo gezh Belén no be gezh nde gax sa wa. Li unibeꞌe xa geal leꞌa bexa ndák wa ndab mtopla liꞌin ulen mbeal wa. ");
INSERT INTO zpt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Li ngok ta wa lak mbidiꞌizh Jeremías sakndoꞌ Dios, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mgen dub ruid siꞌil gezh Ramá, Uzhebpa nbezhat bexa no ndoꞌon bexa. Leꞌa Raquel ndoꞌonno be xin na. Yá lá kaꞌabta xa itayoꞌon, geal leꞌa be xin xa ngutbe. ");
INSERT INTO zpt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngol tsoꞌo wa leꞌa Herodes ngut. Weꞌe leꞌa dub angel ten Dios mlundoꞌ ndoꞌ Kosé nacion Egipto gor naxyats xa, ");
INSERT INTO zpt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","cha ndab angel: —Goste, cha byoꞌo meꞌed baꞌ no xnaꞌa meꞌed leꞌaka nacion Israel, leꞌa bexa na nlad gut meꞌed baꞌ wa ngutlabe. ");
INSERT INTO zpt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Leꞌa Kosé cha ngwaste, cha myoꞌo xa meꞌed no xnaꞌa meꞌed leꞌaka Israel. ");
INSERT INTO zpt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ná leꞌa gor na mbiꞌín Kosé leꞌa Arquelao xin Herodes myatsoꞌgal nibeꞌe Judea, cha mzheb xa yaꞌ xa sa wa. Leꞌa Dios cha uníꞌigal gor naxyats Kosé, ndab Dios lá yaꞌ xa Judea. Ta weꞌe cha nchaꞌa xa ndi distrit Galilea. ");
INSERT INTO zpt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ngwaꞌ bexa yoo bexa gezh Nazaret, lak ndab bexa uyoꞌo polta sakndoꞌ Dios, ndab xa: “Leꞌa be men gab leꞌa xa dub xa Nazaret.” ");
INSERT INTO zpt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ngol tsoꞌo wa leꞌa Juan xa ulaleaꞌ be men ngwaꞌyoꞌo geꞌe sa bid sa uxee ncho men, dub sa ten Judea. Ndadiꞌizh xa ndoꞌ be men, ");
INSERT INTO zpt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ndab xa: —Blaꞌa bego be ta ugap nak bega, leꞌa zha inibeꞌe Dios ladoꞌo be men yá gaxla nak. ");
INSERT INTO zpt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Polta leꞌa Isaías mbidiꞌizh sakndoꞌ Dios cuent ten Juan, ndab Isaías: Leꞌa xa wa ikeseyadiꞌizh geꞌe sa bid, ugeꞌ gab xa: “Bin parej bega nes ilen Xa Nibeꞌe. Bkeasoꞌ bega nes ten xa.” ");
INSERT INTO zpt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Leꞌa xab Juan nakchaꞌaw gich las came, no dub sinch gid nde len xa. Leꞌa xa ndaw mbit, nsea mzhin ser ndo xa. ");
INSERT INTO zpt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Leꞌa kwaꞌad bexa Jerusalén no bexa idub distrit Judea no bexa ncho gax toꞌo yowbeꞌe Jordán utoꞌo, ndabeyoꞌón bexa xtaꞌan ndadiꞌizh Juan. ");
INSERT INTO zpt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mgondoꞌ bexa be ke ten bexa, cha ulaleaꞌ Juan bexa len nits yowbeꞌe Jordán. ");
INSERT INTO zpt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ná leꞌa gor na uniꞌí Juan leꞌa kwaꞌad bexa fariseo nsea bexa saduceo nseabe italeaꞌ, cha ndab Juan ndoꞌ bexa wa: —¡Bego bexa ugap cuent be mbeꞌal! ¿Ton ndab ndoꞌ bega italeaꞌtsa bega, cha naꞌanpa utsaksi Dios bega zha? ");
INSERT INTO zpt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bin bega ta wen, ta uluu leꞌa bega mlaꞌaka ta ugap nak bega. ");
INSERT INTO zpt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","No ni lá gunbeꞌe bega gab bega leꞌa bega xin Abraham, ta weꞌe leꞌa Dios naꞌanpa utsaksi bega. Leꞌa naꞌ gáp leꞌa Dios syoꞌo gan gunno be geꞌ ndee be xin Abraham. ");
INSERT INTO zpt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Leꞌa Dios listla nsoꞌ utsaksi xa bexa ndun ta ugap, cuent dub xa nsoꞌnsén dub gibya, kabtoꞌog xa itea be ya lá nsaꞌa ngus wen, cha utsaꞌab xa ta wa ndoꞌ giꞌ yolꞌ‑a. ");
INSERT INTO zpt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Leꞌa naꞌ ndee nits‑tsa ngoleaꞌ be men, ta nluu leꞌa bexa mlaꞌaka be ta ugap nak bexa. Parea tsoꞌo naꞌ ilen stub xa koleaꞌ be men no Espíritu ten Dios no giꞌ. Leꞌa xa wa mas nsak ndoꞌ naꞌ gast ni lá isaya naꞌ goo naꞌ ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Leꞌa xa wa listla nsoꞌ uti be men wen lat bexa ugap, cuent dub men nti bid ten trig lat be gix xab‑a. Cha kochaꞌaw xa trig wa len niꞌi, nsea utsoꞌol xa xab‑a wa ndoꞌ giꞌ nunk lá yuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Leꞌa Jesús cha utoꞌo Galilea, nchaꞌa xa yowbeꞌe Jordán sa nsoꞌ Juan, ndontsa koleaꞌ Juan xa. ");
INSERT INTO zpt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ná leꞌa Juan lá kaꞌab, ndab xa: —Nkiꞌin naꞌ leꞌa go koleaꞌ naꞌ, ná nat leꞌa go ndi nsea koleaꞌ naꞌ go. ");
INSERT INTO zpt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Leꞌa Jesús cha ukaꞌab ndab: —Litsa gun una nat, leꞌa una nsabndoꞌ gun lak nlad Dios. Leꞌa Juan cha ulaleaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Leꞌa tsoꞌo na utaleaꞌ Jesús leꞌa gor na utoꞌo Jesús len nits, leꞌa gibeꞌa baꞌ cha myaꞌal. No mnaꞌ Jesús Espíritu ten Dios cuent dub palom nchaꞌlaꞌ sa nsoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cha ulen ti Dios gibeꞌa ndab: —Ta ndee Xiꞌín naꞌ. Leꞌa naꞌ nkweaꞌ ladna xa, no ntenno lad naꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Leꞌa Espíritu ten Dios cha mbiꞌi Jesús geꞌe sa bid sa naꞌan men, sa gun maxuꞌu juers utsabgix Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Leꞌa dub top gaꞌal wizh leꞌa Jesús lá ngaw, cha ngol gor leꞌa xa uzhebpa ndanna. ");
INSERT INTO zpt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Weꞌe leꞌa maxuꞌu cha ulen gun preb Jesús, ndab maxuꞌu ndoꞌ xa: —Tal leꞌa lu nak Xin Dios, nat gud ndoꞌ be geꞌ baꞌ yak‑a pan. ");
INSERT INTO zpt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa diꞌizh ten Dios nkeaniꞌi: “Naꞌanpa nabtsa ta ndaw men nban bexa. Mas nsak nxobgek men ndoꞌ diꞌizh ten Dios, leꞌa ta wa ndun nban xa.” ");
INSERT INTO zpt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Leꞌa maxuꞌu cha mbiꞌigal Jesús gezh Jerusalén gek niꞌi ten Dios, sa ndon leꞌa gaꞌap. ");
INSERT INTO zpt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Cha ndab maxuꞌu: —Tal leꞌa lu Xin Dios, nat btsaꞌab dub brink gast ndoꞌ yo baꞌ, leꞌa diꞌizh ten Dios nkeaniꞌi ndab‑a: Leꞌa Dios utuꞌub be angel ten na ulaꞌach lu. Leꞌa bexa wa goꞌo lu ndoꞌ yaꞌa na, ndontsa ni lá ikateꞌeb lu ndoꞌ ni dub geꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Leꞌa Jesús cha ukaꞌab ndab: —No ndab diꞌizh ten Dios: “Lá gun lu preb Dios Xa Nibeꞌe.” ");
INSERT INTO zpt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Leꞌa maxuꞌu cha mbiꞌi Jesús gek dub geꞌe gaꞌappa, cha mluu maxuꞌu itea be gezh nde ndoꞌ gizhliyo no be ta nsak ncho be gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Cha ndab maxuꞌu: —Itea be ta baꞌ usa naꞌ ikaꞌa lu tal leꞌa lu isaxib ndoꞌ naꞌ, yankea lu naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Leꞌa Jesús cha ndab ndoꞌ maxuꞌu: —Bxoꞌon wats naꞌ, maxuꞌu. Leꞌa diꞌizh ten Dios nkeaniꞌi ndab‑a: “Wankea Dios Xa Nibeꞌe, no bin ta nladtsa xa.” ");
INSERT INTO zpt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Leꞌa maxuꞌu cha mlaꞌa Jesús, cha ulen be angel ten Dios mlaꞌach bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngol dub wizh leꞌa Jesús mbiꞌín leꞌa Juan nkea litgiꞌib, cha nseaꞌ Jesús leꞌaka Galilea. ");
INSERT INTO zpt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Parea lá ngaꞌyoꞌo xa Nazaret, ndi ngwaꞌyoꞌo xa gezh Capernaum toꞌo lagun siꞌil, yo ten bexa ras ten Zabulón no ras ten Neftalí. ");
INSERT INTO zpt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Li ngok‑a lak nkeaniꞌi diꞌizh ten Dios, ta mas polta mkeꞌa Isaías sakndoꞌ Dios, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Bego ncho ndoꞌ yo ten Zabulón no yo ten Neftalí, sa ntid nes toꞌo lagun, lad ndaꞌas wizh sa nax yowbeꞌe Jordán; Bego ncho Galilea, sa ncho no bexa naꞌanpa xa judio: ");
INSERT INTO zpt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Leꞌa bego nde sa ukaw, parea leꞌa nat uniꞌí bega dub xeꞌa siꞌil. Leꞌa bega nde sa wa cuent dub xa ngut, parea nat mgondoꞌ bega xeꞌa ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Leꞌa zha weꞌe cha usaxan Jesús ndadiꞌizh diꞌizh ten Dios ndoꞌ be men, ndab xa: —Blaꞌa bego be ta ugap nak bega, leꞌa zha na inibeꞌe Dios ladoꞌo be men yá gaxla nak. ");
INSERT INTO zpt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Leꞌa dub gor nchasea Jesús toꞌo lagun siꞌil nsaleaꞌ Galilea, cha uniꞌí xa top xabgiꞌi ndeutsaꞌab red ten na len nits, leꞌa bexa wa xa nsen mbeal. Leꞌa dub xa wa Simón, xa no nsaleaꞌga Pedr. Leꞌa stub xa wa Ndres wit Simón Pedr wa. ");
INSERT INTO zpt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Cha ndab Jesús ndoꞌ bexa: —Usankea bega tsoꞌo naꞌ, leꞌa naꞌ uluu xteꞌe yunjunt bega be men ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Leꞌa bexa wa cha uxax mlaꞌa be red ten na, cha usankea bexa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Leꞌa gor usea bexa stub tuzh sa, cha uniꞌí Jesús stop xabgiꞌi, dub xa nsaleaꞌ Jacob nsea stub xa nsaleaꞌ Juan. Leꞌa bexa wa ndeno Zebedeo xus bexa ndoꞌ dub barco, ndego bexa ramient be red ten bexa. Leꞌa Jesús cha utezh itop wit bexa. ");
INSERT INTO zpt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Leꞌa itop bexa cha uxax mchansoꞌ xus na ndoꞌ barco wa, cha usankea bexa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Leꞌa Jesús cha nchasea idub distrit Galilea, nluu xa be men len be niꞌi sa nzhealbe bexa judio sa wa. Mbidiꞌizh xa diꞌizh wen ten Dios ná xteꞌe nibeꞌe Dios be men, no myunyakna xa be men nsén guniꞌi xá gealgizh ná, no bexa kweaꞌ nsak. ");
INSERT INTO zpt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Leꞌa ta li ndun Jesús wa mgen idub distrit Siria. Ta weꞌe leꞌa kwaꞌad be men ulenno bexa nsén isandoꞌ be gealgizh, no bexa gizh ncho mbi bxin len ladoꞌo na, no bexa nsak gizhkaw, no bexa lá yoo gan isea. Cha myunyakna Jesús bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cha usankea kwaꞌad be men tsoꞌo Jesús: bexa distrit Galilea, no distrit Decápolis, no gezh Jerusalén, no idub distrit Judea, no bexa ncho stub toꞌo yowbeꞌe Jordán. ");
INSERT INTO zpt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Leꞌa gor uniꞌí Jesús be men kwaꞌad wa, cha ukea xa dub bet, cha usob xa. Leꞌa be xmen xa cha ulayaꞌ wats xa. ");
INSERT INTO zpt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Cha usaxan nluu xa bexa wa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Uzheꞌeb wen yoo ladna bexa ngondoꞌ leꞌa bexa nkiꞌin Dios, leꞌa Dios nibeꞌe ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’No uzheꞌeb wen yoo ladna bexa ndoꞌon, leꞌa Dios gal gor gun iten ladna bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’No uzheꞌeb wen yoo ladna bexa bchaꞌan nak, leꞌa Dios usaꞌa gizhliyo ikaꞌa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’No uzheꞌeb wen yoo ladna bexa nkwaꞌan gun lak nlad Dios, leꞌa Dios saꞌa ta nlad bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’No uzheꞌeb wen yoo ladna bexa nlats ladna be men, leꞌa Dios ilats ladna bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’No uzheꞌeb wen yoo ladna bexa umbiꞌi nak ladoꞌo na, leꞌa bexa wa igondoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’No uzheꞌeb wen yoo ladna bexa nkwaꞌan xteꞌe lá kuyo be men, leꞌa bexa wa isaleaꞌ xin Dios. ");
INSERT INTO zpt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’No uzheꞌeb wen yoo ladna bexa ntid be gealkweaꞌ ta na ndun bexa ta nsak ladna Dios, leꞌa Dios nibeꞌe ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’No uzheꞌeb wen yoo ladna bego gor na ugap ndanno be men bega, ta na ndangea ladna bega naꞌ. Leꞌa bexa wa xela iníꞌi ndoꞌ bega, no ukwiꞌin bexa gab bexa leꞌa bega sian ta ugap ndun. ");
INSERT INTO zpt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Uzhebpa bten ladna bego be zha li wa, leꞌa Dios uzhebpa usaꞌa be ta wen ndoꞌ bega gibeꞌa. Leꞌa polta likaga ugap mbinno be men bexa mbidiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Leꞌa bega nak cuentta sed lat be men ndoꞌ gizhliyo ndee. Parea tal leꞌa sed itoꞌo ta utix ten na, ¿xteꞌema yak utix‑a stub biaj zha? Leꞌa‑yá naꞌanta xtiꞌin, ta weꞌe yabitsa‑yá tsoꞌo juer sa ulako be men‑a. ");
INSERT INTO zpt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Leꞌa bego nak cuent xeꞌa ndoꞌ be men gizhliyo ndee, cuent dub gezh nde gaꞌap gek dub geꞌe lá yoo gan xgaꞌach kwe. ");
INSERT INTO zpt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Leꞌa naꞌan ton usobgiꞌ dub xeꞌa, cha usob xa‑yá len dub caj. Ndi usob xa xeꞌa dub sa gaꞌap, ndontsa usu‑yá xeꞌa ndoꞌ itea bexa ncho len niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","No liga usu bego xeꞌa ten bega ndoꞌ be men, ndontsa inaꞌ bexa be ta wen ndun bega, cha no gab bexa siꞌil nak Tad Dios nsob gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Lá gunbeꞌe bega leꞌa naꞌ ndal unitndoꞌ ley mkeꞌa Moisés no be ta mkeꞌa bexa sakndoꞌ Dios tiemp polta. Leꞌa naꞌ ndi ndal gun cumplir be ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Leꞌa naꞌ gáp ndoꞌ bego leꞌa nat na bi nde gizhliyo no gibeꞌa leꞌa ni dub letr ten ley ten Dios naꞌanpa initndoꞌ, gast itea‑yá gak cumplir. ");
INSERT INTO zpt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ta weꞌe tal ton lá uxobgek ndoꞌ dub taꞌa ndon leꞌa tuzh ndoꞌ ley wa, no liga nluu xa stubga men li gun, leꞌa xa wa ndon leꞌa lá nsak lat bexa nibeꞌe Dios. Ná leꞌa xa na nxobgekka ndoꞌ ta ndab ley ten Dios, no liga nluu xa be men, leꞌa xa wa nsakka lat bexa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Leꞌa naꞌ gáp ndoꞌ bega tal leꞌa bega naꞌanpa mas uxobgek ndoꞌ Dios ndoꞌ lak ndun bexa fariseo no be mech ten ley, leꞌa bega lá yoo gan gak bexa leꞌa Dios nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Leꞌa bego mbiꞌínla ta ndab Dios ndoꞌ be men polta, ndab xa: “Lá gut bega men, leꞌa tal ton gut men leꞌa be men utsaksi xa wa.” ");
INSERT INTO zpt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Parea leꞌa naꞌ ndi gáp leꞌa tal ton gakloo ndoꞌ stub men, leꞌa Dios utsaksi xa wa. No tal ton inisi stub men, leꞌa xa wa isoꞌ ndoꞌ bexa nibeꞌe. No tal ton gab “tont” ndoꞌ stub men, leꞌa xa wa yaꞌ ndoꞌ giꞌ infierno. ");
INSERT INTO zpt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’No tal leꞌa bega nchaꞌlo med sa nsaꞌa men taꞌa ndoꞌ Dios, ná sa weꞌe utseꞌa ladna bega leꞌa stub ltsaꞌa bega ndakloo ndoꞌ bega, ");
INSERT INTO zpt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","blaꞌa bega sa weꞌetsa ndiꞌib‑a. Cha waꞌ bega ndoꞌ ltsaꞌa bega wa, bin bega ta gun wen yaꞌan bega ndoꞌ xa. Cha weꞌe byach bega bsaꞌa bega ta wa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’No tal ton nlad usake bega, waꞌyadiꞌizhno bega xa gor biseata isoꞌ xa ndoꞌ juez. Leꞌa tal xa usake bega ndoꞌ juez, leꞌa juez cha yun cuent bega ndoꞌ bexa nlaꞌach litgiꞌib, cha ukeꞌa xa bega litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Leꞌa naꞌ gáp leꞌa bego naꞌanpa itoꞌo sa wa gast kixka bega itea ta nsaꞌab bega wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Leꞌa bego mbiꞌínla ta ndab diꞌizh ten Dios: “Lá ugal bega dub xagots naꞌanpa xagots ten bega.” ");
INSERT INTO zpt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Parea leꞌa naꞌ ndi gáp ndoꞌ bega leꞌa tal ton iwiꞌi ndoꞌ dub xagots ndanbeꞌe xa ugal xa xagots wa, leꞌa xa wa ndap ke ndoꞌ Dios cuent mgal‑la xa xagots wa. ");
INSERT INTO zpt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ta weꞌe tal leꞌa bega ndun dub ta ugap ta naꞌ dub ngusndoꞌ bega, mas wen itoꞌo‑yá. Ndi mas wen naꞌan dub ngusndoꞌ bega nat, ni ka idub bega yaꞌ infierno. ");
INSERT INTO zpt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No liga tal leꞌa bega ndun dub ta ugap nsea yaꞌa bega, mas wen yabtoꞌog‑a. Ndi mas wen naꞌan dub yaꞌa bega nat, ni ka idub bega yaꞌ infierno. ");
INSERT INTO zpt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’No ndab diꞌizh ten Dios: “Leꞌa tal ton dub xabgiꞌi nlad ulaꞌa xagots ten na, leꞌa xa syoꞌo gan usaꞌatsa dub git ndoꞌ xagots wa, gab git leꞌa xa mlaꞌa xagots.” ");
INSERT INTO zpt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Parea leꞌa naꞌ ndi gáp ndoꞌ bega leꞌa tal ton dub xabgiꞌi ulaꞌa xagots ten na, cha ikaꞌa xagots wa stubga xabgiꞌi, leꞌa xabgiꞌi ned wa ndun leꞌa xagots wa ndap ke ndoꞌ Dios. No liga leꞌa stub xabgiꞌi na ikaꞌaga xagots wa noga ndap ke ndoꞌ Dios. Ná tal ton dub xagots ugal stubga xabgiꞌi, leꞌa xabgiꞌi ten xa wa sak ulaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’No mbiꞌínla bega stub taꞌa ndab Dios ndoꞌ bexa polta, ndab xa: “Tal leꞌa bega ndab Dios nsobwiꞌi sunka bega dub taꞌa, weꞌe leꞌa bega juerska li gun. Naꞌanpa ulaꞌa bega lá gun bega ta wa.” ");
INSERT INTO zpt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Parea leꞌa naꞌ ndi gáp ndoꞌ bega, leꞌa gor na ndab bega gun bega dub taꞌa, naꞌanpa useꞌat bega Dios, ndi gabtsa bega gun bega ta wa. No naꞌanpa useꞌat bega gibeꞌa, leꞌa gibeꞌa baꞌ sa nsob Dios. ");
INSERT INTO zpt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","No ni naꞌanpa useꞌat bega gizhliyo, leꞌa gizhliyo ndee sa nibeꞌe Dios. No ni lá useꞌat bega Jerusalén, leꞌa Jerusalén gezh ten Dios xa ndon leꞌa nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","No ni lá useꞌat bega gek bega, leꞌa bega lá yoo gan ucheꞌa ni dub gichgek bega xaꞌaga color. ");
INSERT INTO zpt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ndi gor na gun bega dub taꞌa, litsa gud bega. No tal naꞌanpa gun bega dub taꞌa, litsa gud bega. Leꞌa itea taꞌa na kota bega ndoꞌ ta ndee wa, leꞌa ta wa ta ten maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’No mbiꞌínla bega ta ndab diꞌizh ten Dios: “Tal ton guzhaꞌa ngusndoꞌ dub men, leꞌa men wa noga li gunno xa wa. No tal ton koꞌoga dub ndeay dub men, leꞌa men wa noga li gunno xa wa.” ");
INSERT INTO zpt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Parea leꞌa naꞌ ndi gáp naꞌanpa ukixke bega ta ugap mbinno dub men bega. Tal ton kichyaꞌa ndoꞌ bega lad gaꞌal, blaꞌa bega kichyaꞌa xa no stubga lad. ");
INSERT INTO zpt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No tal ton usake bega ulat xa dub xab bega, blaꞌa bega gast no stub‑a goꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No tal ton gab juerska goꞌo bega dub taꞌa noꞌo xa dub kilómetro nes nsea xa, ndi top li sa biꞌi bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No tal ton inab dub taꞌa ndoꞌ bega, usaꞌa bega‑yá. No tal ton inab dub ta ikiꞌin xa, lá gab bega leꞌa bega lá usaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’No mbiꞌínla bega stubga taꞌa ndab be men: “Bkweaꞌ ladna bega be ltsaꞌa bega, no bxee ladna bega ndoꞌ bexa ugap ndanno bega.” ");
INSERT INTO zpt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Parea leꞌa naꞌ ndi gáp ndoꞌ bega bkweaꞌ ladna bega bexa ugap ndanno bega. No utsin bidiꞌizh bega ndoꞌ bexa xela níꞌi ndoꞌ bega. No utsin gok bega ndoꞌ bexa nxee ladna ndoꞌ bega. No unab bega ndoꞌ Dios gakno Dios bexa na kweaꞌ níꞌi ndoꞌ bega no bexa na ugap ndanno bega. ");
INSERT INTO zpt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Li nsabndoꞌ gun bega ta na nak bega xinka Dios Xus beuna, xa nsob gibeꞌa. Leꞌa xa ndun leꞌa wizh nsu xeꞌa ndoꞌ itea be men, bexa wen no bexa ugap. No nlaꞌ xa gi ndantiꞌin itea be men, bexa wen no bexa ugap. ");
INSERT INTO zpt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tal leꞌa bega nkweaꞌ ladna sbeꞌen bexa nkweaꞌ ladna bego, ¿xteꞌe nsak bega leꞌa Dios usaꞌa ta wen ndoꞌ bega zha? ¿Lá iniꞌí bega zha leꞌa gast bexa nsen med ten gobier Roma liga nkweaꞌ ladna be ltsaꞌa na? ");
INSERT INTO zpt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","No tal leꞌa bega utsin nidiꞌizh ndoꞌ be ltsaꞌatsa bega, ¿xteꞌe nsak bega zha leꞌa bega wen ndun? ¿Lid no bexa lá nchandoꞌ Dios li ndun? ");
INSERT INTO zpt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ta weꞌe sbeꞌen ta wen bin bega, lak sbeꞌen ta wen ndun Tad Dios xa nsob gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Blaꞌach bega leꞌaka bega leꞌa gor na ndun bega ta wen ndoꞌ stub men, naꞌanpa gun bega‑yá dub mod na iniꞌí be men ta ndun bega wa. Tal leꞌa bega li gun, leꞌa Tad Dios xa nsob gibeꞌa lá kix ta li mbin bega wa. ");
INSERT INTO zpt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Leꞌa gor na nsaꞌa bega ta nkiꞌin dub men uban nak, naꞌanpa gudiꞌizh bega‑yá ndoꞌ be men, lak ndun bexa nluu cuentta xa wen ná xa xa ugap. Leꞌa bexa wa ndadiꞌizh‑a len be niꞌi sa nzhealbe beuna xa judio no ndadiꞌizh bexa‑yá be nes, ndontsa gab be men leꞌa bexa xa wenka. Leꞌa naꞌ gáp leꞌa ta wen iníꞌi be men ndoꞌ bexa wa, leꞌa ta weꞌetsa gun bexa gan. ");
INSERT INTO zpt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ná leꞌa gor nsaꞌa bega ta nkiꞌin dub men, naꞌanpa gab bega ta wa ndoꞌ ni dub men. ");
INSERT INTO zpt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tal leꞌa bega li xagaꞌtsa gakno stub men, weꞌe leꞌa Tad Dios iniꞌí ta wa, cha gaꞌalka usaꞌa xa ta ikaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Leꞌa gor gudiꞌizhno bega Dios, lá gak bega lak nak bexa nluu cuentta xa wen ná xa xa ugap. Leꞌa bexa wa ndal ladna nsoꞌyadiꞌizh ndoꞌ Dios sbeꞌen len niꞌi sa nzhealbe beuna xa judio no be sa skin nes ndontsa iniꞌí be men‑a. Ná leꞌa naꞌ gáp ndoꞌ bego leꞌa ta wen níꞌi be men ndoꞌ bexa wa, leꞌa ta weꞌetsa gun bexa gan. ");
INSERT INTO zpt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ná leꞌa bego gor gudiꞌizhno bega Dios, uyoꞌo bega len lid bega, cha btsaw bega toꞌo puert, cha bidiꞌizhno bega Tad Dios dub mod na ni dub men lá iniꞌí‑yá. Leꞌa ta na li xagaꞌtsa ndun bega, leꞌa Dios iniꞌí ta wa cha gaꞌalka usaꞌa xa ta ikaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Leꞌa gor na ndadiꞌizhno bega Dios, naꞌanpa gab bega dubtsa diꞌizh ngi sian biaj, lak ndun bexa lá nchandoꞌ Dios, ndanbeꞌe bexa leꞌa ta na uzhebpa ndadiꞌizh bexa, ta weꞌe mas goꞌón Dios ta ndab bexa. ");
INSERT INTO zpt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lá gak bega lak nak bexa wa, leꞌa Tad Dios xa nsob gibeꞌa yá uniꞌíla xtaꞌan nkiꞌin bega gor na biseata inab bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ta weꞌe lndeꞌe bidiꞌizhno bega Dios: Go Dios Xus besa, go nsob gibeꞌa, yankea be men leaꞌ go. ");
INSERT INTO zpt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","No uxax ilen tiemp inibeꞌe go be men. Gak ta nlad go ndoꞌ gizhliyo, lak ndak‑a gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nab besa usaꞌa go ta gaw besa wizh nat, lak nkiꞌin besa‑yá itea wizh. ");
INSERT INTO zpt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","No bingeꞌ ladna go be ke ten besa, lak ndangeꞌ ladna besa ndoꞌ be men ugap ndanno besa. ");
INSERT INTO zpt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Lá ulaꞌa go gailaꞌ besa ndoꞌ be ta ugap, ndi uloꞌo go besa ndoꞌ itea be ta ugap. Leꞌa idub tiemp leꞌa go xa ndon leꞌa nibeꞌe no xa ndon leꞌa juert no xa ndon leꞌa nsak. Lika nak‑a. ");
INSERT INTO zpt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Leꞌa tal bega gungeꞌ ladna be ta ugap ndanno be men bega, weꞌe leꞌa Tad Dios xa nsob gibeꞌa noga sungeꞌ ladna be ke ten bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Parea tal leꞌa bega lá gungeꞌ ladna ndoꞌ be men ugap ndanno bega, weꞌe leꞌa Tad Dios noga lá gungeꞌ ladna ndoꞌ bego. ");
INSERT INTO zpt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Leꞌa zha na lá ndaw bega dub tiemp, naꞌanpa gun bega uban inaꞌ ndoꞌ bega, lak ndun bexa ndab leꞌa xmen Dios parea naꞌanpa ta ugea‑yá. Leꞌa bexa li ndun ndontsa iniꞌí be men leꞌa bexa lá ndaw wizh wa. Ná leꞌa naꞌ gáp leꞌa ta wen níꞌi be men ndoꞌ bexa wa, leꞌa ta weꞌetsa gun bexa gan. ");
INSERT INTO zpt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Naꞌ leꞌa bego zha na li lá gaw bega, ndi ulo bega ta uxeꞌe gek bega, no udaꞌab bega ndoꞌ bega, ");
INSERT INTO zpt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ndontsa naꞌanpa inaꞌ be men ti lá ngaw bega wizh wa. Nabtsa Dios inaꞌ ta li xagaꞌtsa ndun bega, cha gaꞌalka usaꞌa Dios ta ikaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Lá yunjunt bega be ta sian ndoꞌ gizhliyo ndee, leꞌa mbes sazhaꞌa‑yá, no slen yasoꞌo‑yá, no ncho waꞌan sgowaꞌan‑a. ");
INSERT INTO zpt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ndi bin bega be ta nsak ndoꞌ Dios, li kochaꞌaw bega sian taꞌa gibeꞌa, sa na ni mbes lá guzhaꞌa‑yá, no ni yasoꞌo lá gaw‑a, no ni waꞌan lá kowaꞌan‑a. ");
INSERT INTO zpt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Leꞌa sa kochaꞌaw bega be ta mas nsak cuent ten bega, leꞌa sa wa mas ncho tseꞌe gek bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Leꞌa ngusndoꞌ dub men leꞌa nak xeꞌa ten xa. Tal leꞌa ngusndoꞌ bega ta wen, leꞌa bega nkesea ndoꞌ xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ná tal ngusndoꞌ bega naꞌanpa ta wen, leꞌa bega nkesea ndi sa ukaw. No tal xeꞌa ncho len ladoꞌo bega ndi nyak sa ukaw, ¡uzhebpa dub sa ukaw nkesea bega! ");
INSERT INTO zpt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Naꞌan ton yoo gan gun tiꞌin ten top xa nibeꞌe xa. Leꞌa gal gor leꞌa xa ixee ladna ndoꞌ dub xa nsea ikweaꞌ ladna xa stub xa, no uxobgek xa ndoꞌ dubtsa xa nsea lá uxobgek xa ndoꞌ stub xa wa. Liga tal leꞌa bega nkwaꞌan sian med, leꞌa bega lá yoo gan gun tiꞌin ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ta weꞌe gáp naꞌ ndoꞌ bega, lá yuꞌ ladna bega xtaꞌan gaw bega no xtaꞌan goo bega ndontsa iban bega. No ni lad gak bega lá yuꞌ ladna bega. ¿Lá iniꞌí bega zha leꞌa gealnaban ten bega mas nsak ndoꞌ be ta gaw bega, no leꞌa bega mas nsak ndoꞌ xab bega? ");
INSERT INTO zpt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Binbeꞌe bega lak nak be migin ni lá ndas ma bid, no ni lá nteleꞌe ma ta gaw ma, no ni lá ndap ma sa nyochaꞌaw ta gaw ma. Ná leꞌa Dios Xus beuna nsob gibeꞌa ngawka bema. ¿Lá iniꞌí bega zha leꞌa ndoꞌ Dios leꞌa bega uzhebpa mas nsak ndoꞌ be migin? ");
INSERT INTO zpt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","’¿Ton bega gun gan tal uzhebpa yuꞌ ladna bega gaꞌal bega stol metr? ");
INSERT INTO zpt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿No xtaꞌan nyuꞌ ladna bega lad gak bega zha? Bwiꞌi bega ndoꞌ be géꞌe, ná xteꞌe ndiꞌibyaꞌal‑a, ná ni lá ndun‑a tiꞌin, no ni lá ndandeꞌe‑yá lad. ");
INSERT INTO zpt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ná leꞌa naꞌ gáp ndoꞌ bego leꞌa lat itea be lad uzhebpa wen ngok Salomón naꞌan dub lad chul lakta dub géꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Leꞌa Dios lita chul ndanno be géꞌe ndiꞌib geꞌe, ná ta gal geꞌa yabtoꞌog‑a cha yolꞌ‑a. ¿Lid mas uzheꞌeb gakno Dios bega, maska ndidotsa ndangea ladna bega xa? ");
INSERT INTO zpt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lá yuꞌ ladna bega xtaꞌan gaw bega no xtaꞌan goo bega no lad gak bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Leꞌa be men lá nchandoꞌ Dios itea be ta ndee nkwaꞌan bexa, ná leꞌa Tad Dios xa ncho gibeꞌa uniꞌíla xtaꞌan nkiꞌin bega. ");
INSERT INTO zpt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndi bkwaꞌan bega xteꞌe uxobgek bega ndoꞌ Dios, no xteꞌe gun bega ta nlad xa. Weꞌe leꞌa Dios saꞌaka itea ta nkiꞌin bega wa. ");
INSERT INTO zpt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ta weꞌe lá yuꞌ ladna bega xteꞌe itid bega wizh geꞌa, leꞌa itea be wizh ncho ta itid bega. Leꞌa kadga wizh binbeꞌetsa bega be ta nsatid bega wizh wa. ");
INSERT INTO zpt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Lá gab bega leꞌa be men lid leꞌa ndun, ndontsa naꞌanpa no Dios gab leꞌa bega lid leꞌa ndun. ");
INSERT INTO zpt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Leꞌa lak ndab bego ndoꞌ be men, no liga gab Dios ndoꞌ bego. No lak ndanno bega be men, no liga gunno Dios bega. ");
INSERT INTO zpt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Xtaꞌan nwiꞌi bega gix tuzh ncho ndoꞌ ltsaꞌa bega zha, ná ni lá naꞌ bega leꞌa ndoꞌ bega ntsaw dub bleꞌa ya siꞌil? ");
INSERT INTO zpt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Xteꞌema yoo gan gab bega ndoꞌ ltsaꞌa bega: “Bsaꞌa ndoꞌ lu ko naꞌ gix tuzh ncho ndoꞌ lu”, ná leꞌa ndoꞌ bega ntsaw dub bleꞌa ya siꞌil? ");
INSERT INTO zpt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ndab bega ugap nak stubga men, ná leꞌa bega ndi mas ugap nak. Ned udob bega ya siꞌil ntsaw ndoꞌ bega, weꞌeta sun bega gan koꞌo bega gix tuzh ncho ndoꞌ ltsaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Lá uluu bega diꞌizh ten Dios ndoꞌ bexa lá nsakyoꞌón‑a. Leꞌa bexa ndun lak ndun dub kuch, tal leꞌa dub men nchaꞌano dub ngusnik uyap ndoꞌ ma, leꞌa ma slako tsoꞌo‑yá, ni lá iniꞌí ma xtaꞌan‑a. No ta ndun bexa wa cuent ta ndun dub mbek ndawkeꞌa yaꞌa men gor ngaw xa ma. ");
INSERT INTO zpt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Unab bega ta nkiꞌin bega ndoꞌ Dios, leꞌa Dios saꞌaka ta wa. Bkwaꞌan bega Dios, leꞌa bega szhealka xa. Utezh bega Dios, leꞌa Dios saknoka bega. ");
INSERT INTO zpt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Leꞌa itea bexa na nab ta nkiꞌin na, leꞌa xa nkaꞌaka‑yá; leꞌa itea bexa nkwaꞌan Dios, leꞌa bexa nzhealka xa; leꞌa itea bexa nbezh Dios, leꞌa Dios ndaknoka. ");
INSERT INTO zpt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Leꞌa bego na ndap meꞌed, tal leꞌa dub xmeꞌed bega inab dub pan, ¿cha saꞌa bega ndi dub geꞌ ndoꞌ meꞌed zha? ");
INSERT INTO zpt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","No tal leꞌa xmeꞌed bega inab dub mbeal, ¿cha saꞌa bega ndi dub mbeꞌal ndoꞌ meꞌed zha? ");
INSERT INTO zpt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Leꞌa bego bexa ugap, ná sbeꞌen be ta wen nsaꞌa bega ndoꞌ be xin bega. Mata Dios Xus beuna nsob gibeꞌa saꞌa sbeꞌen be ta wen ndoꞌ bexa inab‑a. ");
INSERT INTO zpt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ta weꞌe utsin bin bega ndoꞌ be men lak nlad bego utsin gun be men ndoꞌ bega. Leꞌa ta ndee nak xan itea be ta unibeꞌe Dios, no be ta mluu bexa mbidiꞌizh sakndoꞌ Dios tiemp polta. ");
INSERT INTO zpt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Bin bega juers yate bega toꞌo puert uyaꞌa. Ncho dub nes uxen nchaꞌa sa nsob dub puert uxen. Kwaꞌadpa men yate puert wa, ná leꞌa bexa wa yaꞌ ndoꞌ giꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","No ncho dub nes uyaꞌa nchaꞌa sa nsob dub puert uyaꞌa. Uxee men izheal yate puert wa, ná leꞌa bexa wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Lá ulaꞌach bega be men nkwiꞌin ndab leꞌa ndadiꞌizh sakndoꞌ Dios. Bchaꞌan nluꞌu bexa cuent borreg, ná leꞌa len ladoꞌo bexa leꞌa bexa ugiꞌi cuent dub mbee. ");
INSERT INTO zpt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Leꞌa be ta ndun bexa wa, ta weꞌe sgondoꞌ bega ná xteꞌe nak xa, lak dub yagich naꞌanpa usaꞌa uv no ni ngus laꞌaw lá usaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Liga itea be ya wen sbeꞌen ngus wentsa nsaꞌa. Ná leꞌa itea be ya na nsaꞌa ngus lá isuꞌu gaw be men, leꞌa ta wa sbeꞌen ngus weꞌetsaga nsaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Leꞌa dub ya wen naꞌanpa nsaꞌa ngus lá isuꞌu gaw be men. No liga dub ya nsaꞌa ngus lá ndaw men lá yoo gan usaꞌaga ngus wen. ");
INSERT INTO zpt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Leꞌa itea ya na lá nsaꞌa ngus wen, gal gor yabtoꞌog‑a cha yolꞌ‑a. ");
INSERT INTO zpt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Liga nak bexa ukwiꞌin wa, leꞌa ta nduntsa xa sgondoꞌ bega xteꞌe nak xa. ");
INSERT INTO zpt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Leꞌa kwaꞌad be men ndab leꞌa xa nak xmen naꞌ, parea naꞌanpa itea bexa wa yate sa nibeꞌe Dios gibeꞌa. Leꞌa sa wa yate bexa nxobgektsa ndoꞌ Dios Xus naꞌ xa nsob gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gal wizh wa leꞌa kwaꞌad bexa gab ndoꞌ naꞌ: “Tad, ¿lá iniꞌí go zha leꞌa besa juers ten ga mbidiꞌizh sakndoꞌ Dios, no juers ten ga ulantuꞌub besa mbi bxin, nsea sian be uyon mbin besa?” ");
INSERT INTO zpt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cha ndi gáp naꞌ ndoꞌ bexa wa: “Leꞌa naꞌ lá nchandoꞌ bega. Nat bxoꞌon bega wats naꞌ, bego xa ndun ta ugap.” ");
INSERT INTO zpt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Leꞌa tal ton goꞌón ta ndáp naꞌ ndee, cha liga gun xa, leꞌa naꞌ gáp leꞌa xa wa nak cuent dub xabgiꞌi list, dub xa mbindeꞌe lid na ndoꞌ geꞌdaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngol gor ulen gi, ngopyoꞌo nits yoꞌow, no ulen mbi siꞌil sa nde niꞌi wa, no ukeꞌa nits niꞌi wa, ná niꞌi wa naꞌankapa ilate, leꞌa xan‑a nsob ndoꞌ geꞌdaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ná leꞌa tal ton goꞌón ta ndáp naꞌ ndee, ná lá uxobgek bexa ndoꞌ‑yá, leꞌa xa wa cuent dub xa lá ndanbeꞌe, dub xa mbindeꞌe lid na ndoꞌ yux. ");
INSERT INTO zpt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngol gor ulen gi, no ngopyoꞌo nits yoꞌow, no ulen mbi siꞌil sa nde niꞌi wa, no ukeꞌa nits niꞌi wa, cha ulate idub niꞌi. ");
INSERT INTO zpt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Leꞌa gor mtayadiꞌizh Jesús ta ndee, leꞌa be men ndanseana xteꞌe ndadiꞌizh xa, ");
INSERT INTO zpt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","geal leꞌa ta ndadiꞌizh xa wa nluu leꞌa xa uzheꞌeb ndap juers, naꞌanpa lak ndadiꞌizh be mech ten ley. ");
INSERT INTO zpt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Leꞌa gor nchaꞌlaꞌ Jesús bet wa, leꞌa kwaꞌad be men usankea tsoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Cha ulen dub xabgiꞌi nsaꞌgea las na, leꞌa ta wa dub gealgizh nsaleaꞌ lepra. Cha msaxib xa ndoꞌ Jesús gast ndoꞌ yo ngol xtuzh xa, ndab xa: —Señor, tal go nlad yunyakna go naꞌ, leꞌa naꞌ uní leꞌa ga sunka gan. ");
INSERT INTO zpt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Leꞌa Jesús cha mxoꞌob yaꞌa na tsoꞌo xa wa, cha ndab Jesús: —Nladka naꞌ yakna lu. ¡Nat myakna lu! Cha bi leꞌa gor wa leꞌa gealgizh wa cha mnitndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Leꞌa Jesús cha ndab ndoꞌ xa: —Blaꞌach, naꞌan ton ndoꞌ ná gudiꞌizh lu xteꞌe myakna lu. Ndi waꞌ ndoꞌ uleꞌay iniꞌí xa leꞌa lu myaklana. No biꞌi be man xnab lak unibeꞌe ley mkeꞌa Moisés usaꞌa be men zha nyakna bexa, ndontsa iniꞌí be men leꞌa lu myaklana. ");
INSERT INTO zpt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Leꞌa gor na ulayaꞌ Jesús gezh Capernaum, leꞌa wats Jesús ulen dub soldad, dub xa Roma nibeꞌe dub gayoꞌoga be soldad. Cha unab xa ndoꞌ Jesús, ");
INSERT INTO zpt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ndab xa: —Señor, leꞌa dub xa ndun tiꞌin ndoꞌ naꞌ uzheꞌeb kweaꞌ nsak. Leꞌa xa lá yoota gan isea, uzhebpa gealkweaꞌ nax niꞌí xa ta lid naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Leꞌa Jesús cha ndab: —Naꞌ gaa yunyakna xa. ");
INSERT INTO zpt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ná leꞌa soldad wa cha ndab: —Señor, leꞌa naꞌ naꞌanpa isayaꞌ yate go len lid naꞌ. Nat gudtsa go yakna xa, leꞌa xa syakkana. ");
INSERT INTO zpt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Leꞌa naꞌ ndee nxobgek ndoꞌ xa mas nibeꞌe ndoꞌ naꞌ. No ncho be soldad nibeꞌe naꞌ ndoꞌ na. Leꞌa gor na ndáp naꞌ ndoꞌ dub xa yaꞌ xa, leꞌa xa cha ndaꞌkaga. No gor na ndáp naꞌ giꞌid stub xa, leꞌa xa cha ndiꞌidkaga. No gor na nibeꞌe naꞌ ndoꞌ xa ndun tiꞌin ndoꞌ naꞌ, leꞌa xa wa cha ndunkaga ta li ndáp naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Leꞌa gor na mbiꞌín Jesús ta wa, cha ngwanseana xa, ndab xa ndoꞌ be men nchankea tsoꞌo xa: —Leꞌa naꞌ gáp ndoꞌ bego, naꞌanpa izheal naꞌ ni dub xa Israel lndeꞌeta ngeꞌ ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No gáp naꞌ ndoꞌ bega leꞌa gal dub wizh leꞌa kwaꞌad be men itoꞌo lad nlen wizh no lad ndaꞌas wizh, cha kwe bexa wats Abraham no Isaac no Jacob sa nibeꞌe Dios gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Naꞌ leꞌa bexa Israel, bexa na ndiꞌizh nsabndoꞌ yaꞌbe sa nibeꞌe Dios, leꞌa bexa wa ndi itatebe tsoꞌo juer sa ukaw. Cha goꞌon bexa gast ndeay bexa gaw bexa tant dub gealkweaꞌ siꞌil iniꞌí bexa. ");
INSERT INTO zpt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cha ndab Jesús ndoꞌ soldad nibeꞌe wa: —Nat byaꞌ ga, leꞌa lak mgeꞌ ladna go naꞌ, li gak‑a. Cha bi leꞌa gor wa leꞌa xa ndun tiꞌin ndoꞌ soldad wa cha myakna. ");
INSERT INTO zpt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cha nchaꞌa Jesús ta lid Pedr, cha uniꞌí Jesús xnazhaꞌap Pedr nax ndoꞌ loꞌon uzhebpa ncho xlea. ");
INSERT INTO zpt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Cha mgal Jesús yaꞌa xa, cha mtoꞌo xlea xa. Leꞌa xagots wa cha ngwaste msaꞌa ta gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Leꞌa gor uyoꞌo teꞌal, leꞌa be men ulenno kwaꞌadpa bexa ncho mbi bxin ladoꞌo na. Leꞌa Jesús cha ulantuꞌub be mbi bxin nsea sbeꞌen diꞌizhtsa, no myunyakna xa itea bexa gizh. ");
INSERT INTO zpt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Li ngok‑a lak ta polta ndab Isaías, xa mbidiꞌizh sakndoꞌ Dios: “Leꞌa xa leꞌa uloꞌo beuna ndoꞌ be gealgizh nsén beuna no be gealkweaꞌ nchono beuna.” ");
INSERT INTO zpt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Leꞌa gor uniꞌí Jesús idub gangeak wats xa nde be men kwaꞌad, cha ndab xa ndoꞌ be xmen xa itakea bexa stub toꞌo lagun Galilea. ");
INSERT INTO zpt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Weꞌe leꞌa dub mech ten ley cha ulen wats Jesús, ndab xa: —Mech, leꞌa naꞌ no isankea tsoꞌo go guniꞌi pa yaꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Leꞌa Jesús cha ndab: —Leꞌa be mbeas ndap geꞌed nyoꞌo na, no leꞌa be migin ndap be xuꞌun ten na, parea leꞌa Xa Myak Men Ndoꞌ Gizhliyo lá ndap sa uneꞌe xa. ");
INSERT INTO zpt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Leꞌa stub xa na no nkeseano Jesús cha ndab: —Señor, blaꞌa ga ned yaꞌukaꞌach naꞌ xus naꞌ. Cha weꞌeta isankea naꞌ tsoꞌo ga. ");
INSERT INTO zpt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Leꞌa Jesús cha ndab ndoꞌ xa wa: —Usankea tsoꞌo naꞌ. Blaꞌa leꞌa bexa lá ndap gealnaban ndoꞌ Dios ukaꞌach ltsaꞌa ngut na. ");
INSERT INTO zpt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Leꞌa Jesús cha ukea ndoꞌ barco no be xmen xa, cha nchaꞌbe bexa ndoꞌ nits. ");
INSERT INTO zpt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Leꞌa sa wa cha ulen dub mbi siꞌil gast nyoꞌo nits wa len barco. Ná leꞌa Jesús ndi naxyats. ");
INSERT INTO zpt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Leꞌa be xmen xa cha mkwaꞌan xa, ndab bexa: —¡Señor, lá ulaꞌa ga gat beuna, leꞌa beuna ngi slaꞌyoꞌo len nits! ");
INSERT INTO zpt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Leꞌa Jesús cha ndab: —¿Xtaꞌan lbaꞌata nzheb bega zha? ¿Lid ndangea ladna bega naꞌ zha? Weꞌe cha ngwaste xa, uteyo xa mbi no nits, cha uleas mbi no ndon xe ute nits. ");
INSERT INTO zpt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Leꞌa bexa wa cha ngwanseana, ndab bexa ndoꞌ be ltsaꞌa xa: —Wen, ¿tonxá xa ndee zhaga, gast mbi nsea nits nxobgek ndoꞌ diꞌizh ten xa? ");
INSERT INTO zpt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Leꞌa gor ulayaꞌ bexa stub toꞌo lagun sa nibeꞌe gezh Gadara, weꞌe cha ulen top xabgiꞌi wats Jesús, utoꞌo bexa lat be geꞌloꞌo sa ngaꞌach be men ngut. Leꞌa bexa wa ncho mbi bxin len ladoꞌo bexa, no uzhebpa ugiꞌi bexa, gast ni dub men lá yoo gan itid nes nax sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Cha ugeꞌ ndab bexa ndoꞌ Jesús: —¿Xtaꞌan ngi besa nsea ugal lu zha, Jesús Xin Dios? ¿Nsea utsaksi lu besa, zha biseata gal wizh li gun lu? ");
INSERT INTO zpt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Leꞌa gax sa wa ndeseayaw kwaꞌadpa kuch. ");
INSERT INTO zpt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Cha ndab be mbi bxin wa ndoꞌ Jesús: —Tal leꞌa lu kontuꞌub besa, blaꞌa yate besa len be kuch baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Leꞌa Jesús cha ndab: —Waꞌbe bega. Leꞌa be mbi bxin wa cha utoꞌo ladoꞌo be xabgiꞌi wa, cha uyoꞌo beya len be kuch wa. Leꞌa itea be kuch wa cha karrel nchaꞌa gek dub weꞌa toꞌo nits. Cha ubix bema gast len nits ulaꞌyoꞌo bema, cha ngut bema. ");
INSERT INTO zpt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Leꞌa bexa nkeno kuch wa cha mxoꞌon. Ngol gezh wa cha mbidiꞌizh bexa itea be ta uyoꞌo wa, gast xteꞌe myakna bexa ncho mbi bxin len ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Leꞌa kwaꞌadpa bexa gezh wa cha utoꞌo nchaꞌbe sa nsoꞌ Jesús. Leꞌa gor uniꞌí bexa Jesús, cha unab bexa ikaꞌan xa sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Leꞌa Jesús cha ukeagal ndoꞌ barco wa, cha utakea xa stub toꞌo lagun, nseaꞌ xa gezh Capernaum sa ncho xa. ");
INSERT INTO zpt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Leꞌa sa wa cha ulenno pla be men dub xabgiꞌi gizh lá yoo gan isea, nax ndoꞌ dub yaloꞌon. Leꞌa Jesús cha mnaꞌla leꞌa bexa ngeꞌ ladna leꞌa Jesús sun gan yunyakna xa gizh wa, cha ndab Jesús ndoꞌ xa gizh wa: —Amig, bten ladna lu, leꞌa ke ten lu myuꞌula. ");
INSERT INTO zpt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Weꞌe leꞌa pla be mech ten ley nde sa wa cha mbinbeꞌebe: “Leꞌa ta ndab xa baꞌ uzheꞌeb dub taꞌa lá nsak ladna Dios.” ");
INSERT INTO zpt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ná leꞌa Jesús mgenna xteꞌe ndanbeꞌe bexa wa, cha ndab Jesús: —¿Xtaꞌan lbaꞌa ugap ndanbeꞌe bega len ladoꞌo bega zha? ");
INSERT INTO zpt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Xtaꞌan mas lid bid gáp naꞌ leꞌa ke ten xa ndee myuꞌula, nati gáp naꞌ gaste xa, cha isea xa? ");
INSERT INTO zpt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Leꞌa nat iniꞌí bego leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, no syoꞌo gan utsuꞌu ke ten be men. Cha ndab Jesús ndoꞌ xa gizh wa: —Goste, cha udob yaloꞌon ten lu baꞌ, cha byaꞌ ta lid lu. ");
INSERT INTO zpt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Leꞌa xa cha ngwaste, cha nseaꞌ xa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Leꞌa gor uniꞌí be men ta wa, cha uzhebpa ngwanseana bexa, no ndab bexa leꞌa Dios uzheꞌeb dub Dios siꞌil ta na li msaꞌa xa juers ndoꞌ men. ");
INSERT INTO zpt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Leꞌa gor nchaꞌa Jesús cha uniꞌí xa dub xa nsaleaꞌ Mateo nsobyun tiꞌin nsen xa med nkix be men ndoꞌ gobier Roma. Cha ndab Jesús ndoꞌ xa: —¡Utsea! ¡Usankea tsoꞌo naꞌ! Leꞌa Mateo cha ngwasoꞌ, cha usankea xa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ngol tsoꞌo wa leꞌa Jesús nsea be xmen xa ngwaꞌdaw ta lid Mateo. Leꞌa sa wa no kwaꞌad bexa ndun ltsaꞌa tiꞌin ndun Mateo wa ngwaꞌbe, no kwaꞌadta bexa na ndab be men ugap nak bexa. ");
INSERT INTO zpt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Leꞌa gor uniꞌí bexa fariseo ta wa, cha ndab bexa ndoꞌ be xmen Jesús: —¿Xtaꞌan lbaꞌa ndawno mech ten bega bexa nsen med no bexa ugap baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ná leꞌa Jesús mbiꞌín ta ndab bexa wa, cha ndab Jesús: —Leꞌa bexa naꞌanpa gizh lá nkiꞌin doctor, ndi leꞌa bexa gizh nkiꞌinka xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Waꞌutsid bega ná xteꞌe gab diꞌizh ten Dios, sa ndab Dios: “Leꞌa naꞌ mas nlad ikweaꞌ ladna bega men, ndoꞌ lak nlad naꞌ usaꞌa bega man xnab ndoꞌ naꞌ.” Leꞌa naꞌ naꞌanpa ndaltezh bexa ndanbeꞌe leꞌa lá ndap ke. Leꞌa naꞌ ndi ndaltezh bexa ngondoꞌ leꞌa ndapka ke, ndontsa yach bexa wats Dios. ");
INSERT INTO zpt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Weꞌe leꞌa pla be xmen Juan xa ulaleaꞌ be men wa cha ulen ndabbe ndoꞌ Jesús: —Leꞌa besa ndee no bexa fariseo ncho sian be wizh lá ndaw besa. Ná leꞌa be xmen ga zha, ¿xtaꞌan lid no bexa li ndun ta wa? ");
INSERT INTO zpt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Leꞌa Jesús cha ukaꞌab ndab: —¿Nsak bega zha leꞌa dub sa nchilyaꞌa men leꞌa bexa nde sa wa nsabndoꞌ uban yoo ladna, zha bi ncho xabgiꞌi nchilyaꞌa wa? Parea gal dub wizh leꞌa be men goꞌo xabgiꞌi mchilyaꞌa wa. Leꞌa zha weꞌe leꞌa be men nde sa wa lá gaw dub tiemp. ");
INSERT INTO zpt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Naꞌan ton ngo ramient dub lad gox nsea dub bleꞌa lad kub, leꞌa lad kub wa syaꞌad, cha ndi mas stsaw‑a lad gox wa. ");
INSERT INTO zpt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","No naꞌan ton ngo vin kub len dub bols gid gox, leꞌa bich ten vin kub wa stsaw bols gid gox wa. Leꞌa vin wa cha ibid stsiꞌi no sazhaꞌa bols gox wa. Leꞌa vin kub wa nsabndoꞌ yoꞌo len bols gid kubga, ndontsa ni dub‑a lá gazhaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ndalen li nsoꞌyadiꞌizh Jesús, leꞌa dub xabgiꞌi nsak ten bexa judio ulen, cha usaxib xa ndoꞌ Jesús, ndab xa: —Leꞌa meꞌed gots ten naꞌ tiꞌi ngutma. Waꞌ una uxoꞌob ga yaꞌa ga tsoꞌo meꞌed, ndontsa iban meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Weꞌe leꞌa Jesús no be xmen xa cha nchaꞌano xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Leꞌa toꞌo nes wa nsoꞌ dub xagots nsak gealgizh nleꞌa xa ten idub dub tibtopla liꞌin. Leꞌa xa ubii ndi tsoꞌo Jesús, cha mgal xa ndats xab Jesús, ");
INSERT INTO zpt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","leꞌa xa mbinbeꞌe tal leꞌa xa ugal masa xab Jesús, leꞌa xa syakkana. ");
INSERT INTO zpt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ná leꞌa Jesús cha mgeaksoꞌ mwiꞌi ndoꞌ xa, cha ndab Jesús: —Xagots, bten ladna lu, leꞌa ta na mgeꞌ ladna lu naꞌ, ta weꞌe mbin myakna lu. Cha bi leꞌa gor wa myakna xa. ");
INSERT INTO zpt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ngol gor ulayaꞌ Jesús ta lid xabgiꞌi nsak wa, leꞌa Jesús cha uniꞌí bexa ndoꞌol bzhee, no xteꞌeta ugeꞌ ndeyoꞌon be men. ");
INSERT INTO zpt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Cha ndab Jesús ndoꞌ bexa wa: —Utate bega, leꞌa meꞌed baꞌ naꞌanpa ngut, leꞌa meꞌed ga naxyats. Leꞌa be men wa cha ndi mxiꞌidno Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ná leꞌa gor utatela bexa, cha uyoꞌo Jesús len niꞌi, cha usen xa yaꞌa meꞌed, cha ngwaste meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Leꞌa ta li mbin Jesús wa mgen itea be gezh nde gax sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Leꞌa gor utoꞌo Jesús sa wa leꞌa top xabgiꞌi lá naꞌ nseabenkea tsoꞌo Jesús, ugeꞌ ndab bexa: —¡Xin David! ¡Blats ladna go besa! ");
INSERT INTO zpt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Leꞌa gor uyoꞌo Jesús len niꞌi, cha ulen bexa wa wats Jesús. Leꞌa Jesús cha ndab ndoꞌ bexa: —¿Ndangea ladna bega leꞌa naꞌ sun gan yakna bega zha? Leꞌa bexa cha ndab: —Señor, leꞌa besa ndangeaka ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Leꞌa Jesús cha mgal ngusndoꞌ bexa, ndab Jesús: —Nat yakna bega lak ndangea ladna bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Cha mnaꞌla bexa. Leꞌa Jesús cha uzhebpa ndab lá gudiꞌizh bexa‑yá ndoꞌ ni dub men. ");
INSERT INTO zpt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ná leꞌa gor nseaꞌbe bexa, cha mbidiꞌizh bexa ta li mbin Jesús wa ndoꞌ itea be men ncho gax sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Leꞌa gor utoꞌo itop be xabgiꞌi sa wa, weꞌe leꞌa stapla be men ulenno dub xabgiꞌi mud, ncho mbi bxin len ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Leꞌa Jesús cha ulantuꞌub mbi bxin len ladoꞌo xa wa, cha usaxan ndadiꞌizh xabgiꞌi wa. Leꞌa be men uzhebpa ndanseana, ndab bexa: —¡Ta ndee dub ta nunk beuna gol niꞌí idub Israel ndee! ");
INSERT INTO zpt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ná leꞌa bexa fariseo ndabbe: —Leꞌa juers ten maxuꞌu na nibeꞌe be mbi bxin ngontuꞌub Jesús be mbi bxin len ladoꞌo be men. ");
INSERT INTO zpt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tsoꞌo wa leꞌa Jesús ukesea itea be gezh ubiꞌi no be gezh byux sa wa, mluu xa be men len be niꞌi sa nzhealbe bexa judio be gezh wa. Mbidiꞌizh xa diꞌizh wen ten Dios ná xteꞌe gak bexa dub xa leꞌa Dios nibeꞌe, no myunyakna xa be men nsén isandoꞌ gealgizh no be gealkweaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Leꞌa gor uniꞌí Jesús be men kwaꞌad, cha mlats ladna Jesús bexa, leꞌa bexa nyuꞌ ladna no ni lá iniꞌí bexa xteꞌe gun bexa, cuent be borreg ni lá ndap ton ulaꞌach ma. ");
INSERT INTO zpt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Cha ndab Jesús ndoꞌ be xmen na: —Ncho kwaꞌad be men gol goꞌón diꞌizh wen ten Dios, nak bexa cuent sianpa be taꞌa iganleꞌe, parea leꞌa bexa gun tiꞌin wa platsa. ");
INSERT INTO zpt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ta weꞌe unab bega ndoꞌ Dios Xwan tiꞌin utuꞌubta xa bexa gun tiꞌin ndee. ");
INSERT INTO zpt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Weꞌe leꞌa Jesús cha utezh isatibtop be xmen xa, cha msaꞌa xa juers ndoꞌ bexa kontuꞌub bexa be mbi bxin, no yunyakna bexa be men nsén isandoꞌ gealgizh no be gealkweaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Leꞌa bexa wa bexa mtuꞌub Jesús, gun bexa tiꞌin ten Dios. Leꞌa ta wa Simón Pedr, no Ndres wit xa; nsea Jacob no Juan wit Jacob be xin Zebedeo. ");
INSERT INTO zpt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nsea Julip no Bartol no Tomás no Mateo xa nsen med nkaꞌa gobier Roma, no Jacob xin Alfeo, no Lebeo xa no nsaleaꞌ Tadeo. ");
INSERT INTO zpt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","No Simón xa partid Caná, nsea Judas Iscariot, xa na leꞌa myun cuent Jesús tsoꞌo wa. ");
INSERT INTO zpt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Leꞌa isatibtop bexa wa mtuꞌub Jesús, ndab Jesús xteꞌe gun bexa, ndab xa: —Lá yaꞌbe bega sa ndencho bexa naꞌanpa xa judio, ni lá yaꞌ bega be gezh ten bexa Samaria. ");
INSERT INTO zpt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ndi waꞌbe bega sa ndencho bexa Israel, bexa nak cuent be borreg ulaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cha bidiꞌizh bega ndoꞌ bexa wa leꞌa zha inibeꞌe Dios ladoꞌo be men yá gaxla nak. ");
INSERT INTO zpt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","No byunyakna bega bexa gizh, no bexa nsén gealgizh lepra. No uxiste bega bexa tiꞌi ngut. No ulantuꞌub bega be mbi bxin len ladoꞌo be men. Lak naꞌanpa ikix bega nsa naꞌ juers ndee ndoꞌ bega, no liga gaꞌbin bega be ta wa naꞌanpa kix bexa ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Lá goꞌo bega ni med oro, ni plata, ni cobre, ");
INSERT INTO zpt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","no ni bols goꞌo bega nes. No ni lá goꞌo bega top nes xab bega, no ni stub nes ndab bega, ni bordón lá goꞌo bega. Leꞌa dub xa ndun tiꞌin nsabndoꞌ yax ten na. ");
INSERT INTO zpt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Leꞌa guniꞌi xá gezh ná ilayaꞌ bega, tal gezh siꞌil‑a natal gezh tuzh‑a, bkwaꞌan bega dub men utsin nak, cha uyoꞌo bega ta lid xa gast zha ikaꞌan bega gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Leꞌa gor na yoo bega len dub niꞌi, cha utsin unidiꞌizh bega ndoꞌ xa ncho sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Leꞌa tal xa utsin ndanno bega, weꞌe leꞌa xa wen yoo ladna. Ná tal leꞌa xa naꞌanpa utsin ndun, leꞌa xa wa naꞌanpa wen yoo ladna. ");
INSERT INTO zpt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","’Ná tal be men wa lá utsin ndanno bega no ni lá ulaꞌach xa ta gudiꞌizh bega, bkaꞌan bega sa wa guniꞌi tal ta lid dub men‑a no tal dub gezh‑a. Cha blate bega gast yakol ngwaꞌal xoꞌo bega, ta uluu leꞌa Dios lá nsak ladna lak nak bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Leꞌa naꞌ gáp ndoꞌ bega leꞌa gal wizh gab Dios ná ton ndap ke, leꞌa bexa gezh wa mas gealkweaꞌ iniꞌí ndoꞌ bexa uyoꞌo gezh Sodoma nsea gezh Gomorra. ");
INSERT INTO zpt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Blaꞌach bega leꞌa naꞌ ntuꞌub bega yaꞌbe bega cuentta be borreg nde lat be mbee. Ta weꞌe list gok bega cuentta list be uzhib. No bchaꞌan gok bega lakta bchaꞌan nak be palom. ");
INSERT INTO zpt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","No gop bega cuent ndoꞌ be men, bexa na yun cuent bega ndoꞌ bexa naktiꞌin, no kin bexa bega len be niꞌi sa nzhealbe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Leꞌa bexa gast ndoꞌ bexa naktiꞌin ubiꞌi no ndoꞌ bexa mas leꞌa nibeꞌe goꞌo bega ke na nak bega xmen naꞌ. Leꞌa gor weꞌe sak gudiꞌizh bega cuent ten naꞌ ndoꞌ bexa wa no ndoꞌ kwaꞌadta bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Parea leꞌa gor na yun bexa cuent bega, lá yuꞌ ladna bega xteꞌe ikaꞌab bega, leꞌa gal gor wa leꞌa Dios leꞌa usaꞌa diꞌizh ikaꞌab bega. ");
INSERT INTO zpt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Leꞌa ta gudiꞌizh bega wa naꞌanpa ta ndanbeꞌetsa bega, leꞌa ta wa ndi ta usaꞌa Espíritu ten Dios Xus beuna gudiꞌizh bega. ");
INSERT INTO zpt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Leꞌa ncho be men leꞌaka wit na yun cuent gat xa ke ndangea ladna xa naꞌ. No nchoga bexa liga yun cuent leꞌaka xin na. No ncho bexa leꞌakaga gaklono xus na gast gab bexa gat xus bexa. ");
INSERT INTO zpt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","No itea be men ixeeno ladna bega ke na ndangea ladna bega naꞌ. Ná leꞌa tal ton bega uxik ndoꞌ be gealkweaꞌ wa, leꞌa bega gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Leꞌa zha na ugap gunno bexa bega dub gezh, bxoꞌon bega, waꞌ bega stubga gezh. Leꞌa naꞌ gáp ndoꞌ bega leꞌa zha biseata itid bega itea be gezh Israel, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilengal. ");
INSERT INTO zpt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Leꞌa dub xin utsid dub mech naꞌanpa mas nsak ndoꞌ mech ten na. No liga leꞌa dub mos naꞌanpa mas nsak ndoꞌ xa nibeꞌe ten xa. ");
INSERT INTO zpt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Leꞌa xin utsid dub mech itid lak ntid mech wa. No liga dub mos itid lak ntid xa nibeꞌe ten xa. Tal leꞌa be men níꞌi ndoꞌ naꞌ ndee maxuꞌu Beelzebú, matagal ndoꞌ bega nak be xmen naꞌ, ¿xteꞌema ugap gab bexa wa? ");
INSERT INTO zpt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Lá izheb bega ndoꞌ be men, leꞌa itea be ta ugaꞌach, leꞌa gal gor leꞌa be ta wa uluꞌukabe. No itea be taꞌa ngachyoꞌo, leꞌa gal gor leꞌa be men iniꞌíka ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Leꞌa be ta ndáp naꞌ ndoꞌ bega gor teꞌal, gud bega‑yá gor tezhea ndoꞌ be men. Leꞌa be ta xgaꞌach ndoꞌón bega, gast gek niꞌi usoꞌ bega ugeꞌ gudiꞌizh bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lá izheb bega ndoꞌ be men. Leꞌa bexa sun gan gut bexa bega, ná leꞌa gealnaban ncho len ladoꞌo bega leꞌa bexa wa lá gun gan gut. Ndi mas bzheb bega ndoꞌ Dios xa na sun gan gut be men, cha utsaꞌab xa gealnaban ten bexa infierno. ");
INSERT INTO zpt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Leꞌa top migin nzheꞌa dub med tuzh, parea ni dub bema lá gat tal Dios lá ulaꞌa gat ma. ");
INSERT INTO zpt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Leꞌa Dios uzhebpa nlaꞌach bega gast uniꞌí xa plo gichgek bega ncho. ");
INSERT INTO zpt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ta weꞌe lá izheb bega, leꞌa bega mas nsak ndoꞌ be migin. ");
INSERT INTO zpt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Leꞌa tal ton gab ndoꞌ gaꞌal be men leꞌa xa xmen naꞌ, leꞌa naꞌ noga gáp ndoꞌ Xus naꞌ xa nsob gibeꞌa leꞌa xa wa xmenka naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ná leꞌa tal ton gab ndoꞌ be men leꞌa xa naꞌanpa xmen naꞌ, leꞌa naꞌ noga gáp ndoꞌ Xus naꞌ xa nsob gibeꞌa leꞌa xa wa naꞌanpa xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Lá gunbeꞌe bega leꞌa naꞌ ndal por na uzheꞌeb wen kwe be men ndoꞌ gizhliyo. Leꞌa naꞌ ndi ndal leꞌa be men iteltsaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Leꞌa naꞌ ndal leꞌa be xabgiꞌi kuyono leꞌaka xus na, leꞌa be xagots kuyono leꞌaka xnaꞌa na, leꞌa xinxix xa kuyono leꞌaka xnazhaꞌap xa. ");
INSERT INTO zpt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Leꞌa bexa na mas gakloo ndoꞌ dub men, leꞌa ta wa leꞌaka bexa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Leꞌa tal ton mas ndankea xus na no xnaꞌa na ndoꞌ lak ndankea xa naꞌ, leꞌa xa wa naꞌanpa isayaꞌ gak xmen naꞌ. Liga tal ton mas nkweaꞌ ladna be xmeꞌed na ndoꞌ naꞌ, leꞌa xa wa naꞌanpa isayaꞌ gak xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tal leꞌa bego lá goꞌo cruz ten na, cha lá isankea bega tsoꞌo naꞌ, leꞌa bega lá isayaꞌ gak xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Leꞌa tal ton ukwaꞌan xteꞌe wen yoo xa, leꞌa xa wa ndi gun perdid gealnaban ten na ndoꞌ Dios. Ná tal ton gat geal ndangea ladna xa naꞌ, leꞌa xa wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Leꞌa tal ton utsin gak ndoꞌ bega, leꞌa ta wa cuentkata ndoꞌ naꞌ utsin nak xa. No liga leꞌa tal ton utsin nak ndoꞌ naꞌ, leꞌa xa wa utsinga nak ndoꞌ Dios xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Leꞌa tal ton utsin gak ndoꞌ dub profet geal profet xa, leꞌa Dios no ndoꞌ xa wa usaꞌa ltsaꞌa ta usaꞌa Dios ndoꞌ be profet. No liga tal ton utsin gak ndoꞌ dub xa wen geal wen xa, leꞌa Dios no ndoꞌ xa wa usaꞌa ltsaꞌa ta usaꞌa Dios ndoꞌ bexa wen. ");
INSERT INTO zpt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Leꞌa tal ton usaꞌa masa dub vas nits myalꞌ goo dub xmen naꞌ, geal leꞌa xa xmen naꞌ, leꞌa naꞌ gáp ndoꞌ bega leꞌa Dios usaꞌaka ta wen nsabndoꞌ ikaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Leꞌa gor na mtayadiꞌizh Jesús ndoꞌ isatibtop be xmen xa ná xteꞌe nsabndoꞌ gun bexa, cha utoꞌo xa nchaꞌuluu xa be men be gezh nde gax wa. ");
INSERT INTO zpt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Leꞌa zha wa leꞌa Juan xa na ulaleaꞌ be men wa nkea litgiꞌib. Leꞌa gor na mbiꞌín xa be taꞌa ndun Jesucristo, cha mtuꞌub xa top xmen xa, ");
INSERT INTO zpt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ngwaꞌ inabdiꞌizh bexa ndoꞌ Jesús, ndab bexa: —¿Go nak xa na ndab Dios ilen wa zha? ¿Nati kweas besa ilen stubga xa? ");
INSERT INTO zpt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Leꞌa Jesús cha ukaꞌab ndab: —Byaꞌbe bega, cha gud bega ndoꞌ Juan ta naꞌ bega no ta ndoꞌón bega. ");
INSERT INTO zpt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Leꞌa bexa lá yoo gan iwiꞌibe, nat leꞌa bexa naꞌla. Leꞌa bexa lá yoo gan isea, nat leꞌa bexa nseala. Leꞌa bexa nsén gealgizh lepra, nat leꞌa bexa myaklana. Leꞌa bexa ngwaꞌad, nat leꞌa bexa ndoꞌónla. Leꞌa bexa ngut, nat leꞌa bexa nbanla. No bexa uban nak ndoꞌón diꞌizh wen ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Uzhebpa wen yoo ladna tal ton igondoꞌ ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Leꞌa gor nseaꞌbe itop be xmen Juan, leꞌa Jesús cha usaxan mbidiꞌizh ndoꞌ be men cuent ten Juan, ndab xa: —Leꞌa gor na ngwaꞌbe bega geꞌe sa uxee ncho men, ¿xtaꞌan ngwaꞌiwiꞌi bega zha? ¿Dub yalod nkwiꞌin mbi? ");
INSERT INTO zpt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nati, ¿xtaꞌan ngwaꞌiwiꞌi bega zha? ¿Dub xabgiꞌi nak dub lad uzhebpa uyap nsak? Leꞌa bega uniꞌíka leꞌa bexa ndak lad uyap wa, leꞌa bexa wa ncho ta lid bexa nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Xtaꞌan ngwaꞌiwiꞌi bega zha? ¿Ngwaꞌiwiꞌi bega dub xa ndadiꞌizh sakndoꞌ Dios zha? Leꞌa naꞌ gáp ndoꞌ bega leꞌa Juan ta ugeaka ndadiꞌizh sakndoꞌ Dios, parea leꞌa xa mas nsak ndoꞌ iteata bexa li ndun wa. ");
INSERT INTO zpt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Leꞌa diꞌizh ten Dios nkeaniꞌi ndab Dios cuent ten Juan: Bwiꞌi, leꞌa naꞌ utuꞌub dub xa yaꞌ ned ndoꞌ lu, uxaꞌal xa nes isea lu. ");
INSERT INTO zpt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","No gáp naꞌ ndoꞌ bega leꞌa lat be men ngol ndoꞌ gizhliyo naꞌan ni stub xa mas nsak ndoꞌ Juan xa ulaleaꞌ be men. Ná leꞌa tal ton uxee nsak lat bexa nibeꞌe Dios, leꞌa cuent ten Dios leꞌa xa wa mas nsak ndoꞌ Juan. ");
INSERT INTO zpt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Leꞌa zha ulen Juan xa ulaleaꞌ be men wa no gast nat, leꞌa ncho bexa ngiꞌi nka inibeꞌe Dios be men, nlad bexa initndoꞌ ta nibeꞌe Dios be men. ");
INSERT INTO zpt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Leꞌa ta mkeꞌa itea bexa mbidiꞌizh sakndoꞌ Dios no ley mkeꞌa Moisés wa mbidiꞌizh xteꞌe nibeꞌe Dios be men gast zha ulen Juan. ");
INSERT INTO zpt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Leꞌa tal bega nlad gungea ladna‑yá, leꞌa Juan leꞌa nak Elí, xa na ndab be profet giꞌidka. ");
INSERT INTO zpt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bego na ndap nchaꞌ na, blaꞌach bega ta ndáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Xtaꞌanma dub ta nak cuent ta ndun be men ncho nat? Leꞌa bexa wa nak cuent be meꞌed nde ndoꞌ xgeꞌe, ugeꞌ ndab be meꞌed ndoꞌ ltsaꞌa meꞌed: ");
INSERT INTO zpt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mbiꞌil besa bzhee, ná leꞌa bega lá ngolndatsbe. No mbiltoꞌoga besa be cant uban nsea, ná leꞌa bega lá ngoꞌonga.” ");
INSERT INTO zpt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Leꞌa zha ulen Juan ncho wizh lá ngaw xa, no ni lá ndo xa vin. Cha ndab bega leꞌa xa ncho mbi bxin len ladoꞌo na, ta weꞌe li ndun xa. ");
INSERT INTO zpt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ná leꞌa nat ndalga naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. Leꞌa naꞌ ndaw, no ndoꞌo naꞌ, ná leꞌa bega ndab leꞌa naꞌ uzhebpa ndaw, no uzhebpa ndoꞌo naꞌ vin. Ndab bega leꞌa naꞌ nchealtsaꞌa bexa ugap nak, no bexa nsen med nkix be men ndoꞌ gobier Roma. Parea leꞌa bexa ndák lak nsaꞌa Dios, leꞌa be ta wen ndun bexa wa nluu leꞌa bexa ndákka. ");
INSERT INTO zpt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Weꞌe cha usaxan uteyo Jesús bexa na ncho be gezh na mas sian be uyon mbin xa, geal leꞌa bexa wa ni lá ulaꞌa be ta ugap nak bexa. Ndab Jesús: ");
INSERT INTO zpt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Proꞌob bego xa gezh Corazín no gezh Betsaida! Tal be uyon mbin naꞌ lat bega wa ndi ngun naꞌ gezh Tiro no gezh Sidón, polta ngokla bexa lad nagats, no usobla bexa ndoꞌ diꞌ, ta uluu leꞌa bexa uban myoꞌo ladna no mlaꞌala bexa be ta ugap nak bexa. ");
INSERT INTO zpt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ta weꞌe gáp naꞌ leꞌa gal wizh gab Dios ná ton ndap ke, leꞌa bego xa gezh Corazín no gezh Betsaida mas uzheꞌeb iniꞌí gealkweaꞌ ndoꞌ bexa Tiro no Sidón wa. ");
INSERT INTO zpt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","No bego bexa gezh Capernaum, ¿ndanbeꞌe bega zha gibeꞌa yaꞌ bega? Leꞌa Dios ndi utsaꞌab bega infierno. Tal be uyon mbin naꞌ lat bega wa ndi ngak gezh Sodoma, nal gast gor nat bi nde gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Leꞌa naꞌ gáp leꞌa gal wizh gab Dios ná ton ndap ke, leꞌa bega xa Capernaum wa mas uzheꞌeb iniꞌí gealkweaꞌ ndoꞌ bexa uyoꞌo gezh Sodoma. ");
INSERT INTO zpt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Leꞌa zha wa cha ndab Jesús ndoꞌ Dios: —Nsa naꞌ xno ndoꞌ go, Xus naꞌ, go Xa Nibeꞌe gibeꞌa no gizhliyo, leꞌa go lá ulaꞌa leꞌa bexa ndák wa no bexa ntsid wa yakbeꞌena be ta ndee. Ndi mluu ga‑yá ndoꞌ bexa naꞌanpa ndák, bexa nak cuent be meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Li ngok‑a, Xus naꞌ, geal leꞌa go li nlad gak‑a. ");
INSERT INTO zpt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cha ndab Jesús ndoꞌ be men nde sa wa: —Leꞌa Dios Xus naꞌ msaꞌa itea be taꞌa ndoꞌ naꞌ. No naꞌan ton nchandoꞌ naꞌ, nabtsa Dios nchandoꞌ naꞌ. No naꞌan ton nchandoꞌ Dios Xus naꞌ, nabtsa naꞌ xa nak Xin xa nchandoꞌ xa, no bexa na nlad naꞌ uluꞌu naꞌ ná ton nak Dios ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Utseabe itea bego na noꞌo be yoꞌo kweꞌa no mzhannabe, leꞌa naꞌ gakno bega uneꞌe ladoꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bin bega lak nluu naꞌ bega, no btsid bega ndoꞌ naꞌ, leꞌa naꞌ bchaꞌan nak, no naꞌanpa zhin nak naꞌ. Li ndontsa uneꞌe ladoꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Leꞌa ta ndáp naꞌ ndoꞌ bego wa dub ta naꞌanpa bid gun bega, cuent dub yoꞌo ta uxaxtsa. ");
INSERT INTO zpt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Leꞌa ngol dub wizh neꞌe be men, leꞌa Jesús nchaꞌtid sa nax dub bleꞌa yo ncho trig. Leꞌa be xmen Jesús ndannabe, ta weꞌe cha uxeꞌe bexa pla be bid ten trig, cha udaw bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Leꞌa ncho bexa fariseo uniꞌí ta wa, cha ndab bexa ndoꞌ Jesús: —Bwiꞌi go ná xtaꞌan ndun be xmen go, ta lá nsabndoꞌ gun bexa wizh neꞌe beuna. ");
INSERT INTO zpt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ná leꞌa Jesús cha ukaꞌab ndab: —¿Ni lá ndoꞌol bega sa ndab diꞌizh ten Dios ta mbin David dub biaj zha na uzhebpa ndanna xa no bexa ndeseano xa zha? ");
INSERT INTO zpt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Leꞌa David uyoꞌo len niꞌilad ten Dios, cha udaw xa be pan leꞌay, ta lá nsabndoꞌ gaw xa no bexa ndeno xa, nab be uleꞌay ndaw‑a. ");
INSERT INTO zpt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿No ni lá ndoꞌol bega ndoꞌ ley ten Dios leꞌa be uleꞌay wa ndun tiꞌin len niꞌi ten Dios wizh neꞌe be men, ná leꞌa ta wa naꞌanpa dub ke? ");
INSERT INTO zpt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Leꞌa naꞌ gáp ndoꞌ bega leꞌa sa ndee nat nchola dub xa mas nsak ndoꞌ niꞌi ten Dios wa. ");
INSERT INTO zpt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Leꞌa diꞌizh ten Dios nkeaniꞌi ndab Dios: “Leꞌa naꞌ mas nlad ikweaꞌ ladna bega men, ndoꞌ lak nlad naꞌ usaꞌa bega xnab ndoꞌ naꞌ.” Tal leꞌa bega yakbeꞌena ta ndee wa, leꞌa bega lá gab ugap ndun bexa ndee, dub ta naꞌanpa dub ke. ");
INSERT INTO zpt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, noga nibeꞌe wizh neꞌe be men. ");
INSERT INTO zpt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cha nchaꞌa Jesús uyoꞌo xa len niꞌi sa nzhealbe bexa judio gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Leꞌa sa wa nsob dub xabgiꞌi ubidya dub yaꞌa na. Leꞌa bexa fariseo nkwaꞌan ná xteꞌe usake bexa Jesús, cha unabdiꞌizh bexa ndoꞌ Jesús, ndab bexa: —¿Syoꞌo gan yunyakna men dub xa gizh wizh neꞌe beuna zha? ");
INSERT INTO zpt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Leꞌa Jesús cha ukaꞌab ndab: —Tal leꞌa dub bega ndap dub borreg, cha ulaꞌyoꞌo ma len dub geꞌed wat wizh neꞌe beuna, ¿lid yaꞌloꞌo bega ma leꞌaka wizh wa zha? ");
INSERT INTO zpt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Lá iniꞌí bega zha leꞌa dub men uzhebpa mas nsak ndoꞌ dub borreg? Ta weꞌe leꞌa beuna syoꞌoka gan gakno stub xa be wizh neꞌe beuna. ");
INSERT INTO zpt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cha ndab Jesús ndoꞌ xa gizh dub yaꞌa na wa: —Bkea yaꞌa lu. Leꞌa xa wa cha mkea yaꞌa na, cha uxax myakna‑yá lak nak stub‑a. ");
INSERT INTO zpt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Cha nseaꞌbe bexa fariseo, mzhealbe bexa mbidiꞌizh bexa xteꞌe gun bexa gan gat Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Leꞌa Jesús mgenna ta li nlad bexa gun bexa wa, ta weꞌe cha mkaꞌan xa sa wa. No kwaꞌad be men usankea tsoꞌo xa, cha myunyakna xa itea bexa gizh wa. ");
INSERT INTO zpt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","No uzhebpa ndab Jesús ndoꞌ bexa lá gudiꞌizh bexa ton myunyakna bexa. ");
INSERT INTO zpt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Leꞌa ta wa ngok lak ndab profet Isaías polta, ndab Dios: ");
INSERT INTO zpt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Bwiꞌi bego leꞌa xa ndee xa ndun tiꞌin ndoꞌ naꞌ, leꞌa naꞌ mti xa no nkweaꞌ lad naꞌ xa no ntenno lad naꞌ xa. Usa naꞌ Espíritu ten naꞌ yoo len ladoꞌo xa, leꞌa xa gudiꞌizh ndoꞌ be men, gab xa xteꞌe wen yaꞌan bexa ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Leꞌa xa ni lá kuyotoꞌo, no ni lá kwezhat xa; No ni naꞌanpa igen ti xa be nes. ");
INSERT INTO zpt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Leꞌa xa wa bchaꞌan gak ndoꞌ bexa kweaꞌ ncho ladna, bexa nak cuent dub xos ya yamer gach, no cuent nak dub bealꞌ ndidotsa nsayolꞌ. Li utsin gak xa ndoꞌ bexa wa gast gal wizh gun xa gan leꞌa be men wa wen yaꞌan ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","No idub ndoꞌ gizhliyo igeꞌ ladna be men xa. ");
INSERT INTO zpt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Weꞌe leꞌa be men cha ulenno dub xabgiꞌi gizh wats Jesús. Leꞌa mbi bxin ncho len ladoꞌo xa wa mbin mud xa no lá naꞌ xa. Leꞌa Jesús cha myunyakna xa ndontsa naꞌ xa no níꞌi xa. ");
INSERT INTO zpt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Leꞌa be men wa ngwatenaꞌbe, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Syoꞌo gan gak xa ndee xin David xa ndiꞌizh utuꞌubka Dios zha? ");
INSERT INTO zpt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ná leꞌa gor na mbiꞌín bexa fariseo ta wa, cha ndab bexa ndoꞌ be ltsaꞌa xa: —Leꞌa Jesús ngontuꞌub be mbi bxin len ladoꞌo be men juers ten Beelzebú, maxuꞌu nibeꞌe be mbi bxin. ");
INSERT INTO zpt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Leꞌa Jesús cha mgenna xteꞌe ndanbeꞌe bexa, cha ndab Jesús: —Tal leꞌa be xmen dub xa nibeꞌe iteltsaꞌabe, cha bi leꞌakaga bexa kuyo, weꞌe leꞌa bexa wa yá naꞌantapa gak juertbe. No tal leꞌa be men ncho dub gezh natal dubtsa niꞌi bi leꞌaka kuyobe, leꞌa juers ten bexa idub. ");
INSERT INTO zpt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","No liga tal leꞌa maxuꞌu kuyono leꞌaka be mbi bxin ten na, weꞌe leꞌa maxuꞌu wa no be mbi bxin wa iteltsaꞌabe, cha idub juers ten maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ndab bega leꞌa naꞌ ngontuꞌub be mbi bxin juers ten Beelzebú. ¿Ná ton nsaꞌa juers ngontuꞌub be xmen bega be mbi bxin wa zha? Ta weꞌe leꞌa ta na ndun be xmen bega wa leꞌa nluu leꞌa bega naꞌanpa utsin ndanbeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ná leꞌa naꞌ ngontuꞌub be mbi bxin juers ten Espíritu ten Dios, ta na nluu leꞌa Dios yá ngol tiemp inibeꞌe len ladoꞌo be men. ");
INSERT INTO zpt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿No xteꞌema yoo gan yate dub men len lid dub xabgiꞌi juert, kowaꞌan xa be ta ncho sa wa, tal men wa lid ned uxi xa juert wa zha? Lima syoꞌo gan kowaꞌan xa be taꞌa len lid xa juert wa. ");
INSERT INTO zpt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Leꞌa tal ton lá nsak ladna be ta ndun naꞌ, leꞌa xa wa ndakloo ndoꞌ naꞌ. No liga leꞌa tal ton naꞌanpa ndakno naꞌ nyakjunt be men ndoꞌ Dios, leꞌa xa wa ndi ndun nsasit be men wats Dios. ");
INSERT INTO zpt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Leꞌa naꞌ gáp ndoꞌ bego leꞌa itea be ta ugap ndun be men no itea be ta kweaꞌ níꞌi bexa, leꞌa ta wa dub ke syoꞌoka gan gungeꞌ ladna Dios. Ná leꞌa tal ton inisi Espíritu ten Dios, weꞌe leꞌa Dios lá gungeꞌ ladna ke wa. ");
INSERT INTO zpt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Leꞌa tal ton inisi naꞌ ndee, Xa Myak Men Ndoꞌ Gizhliyo, leꞌa ke weꞌe syoꞌoka gan yuꞌu. Ná leꞌa tal ton inisi Espíritu ten Dios, leꞌa ke weꞌe yá lá yuꞌuta, ni tiemp ndee no ni tiemp ilen wa. ");
INSERT INTO zpt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Leꞌa dub ya wen nsaꞌa sbeꞌen ngus wen. No dub ya naꞌanpa wen nsaꞌa sbeꞌen ngus lá yoo gan gaw men. Leꞌa be ngus ten dub ya nluu xá ya na‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Leꞌa bego xa ugap cuent be uzhib! ¿Xteꞌema yoo gan gudiꞌizh bega be ta wen zha, ná bega bexa ugap? Leꞌa ta na ncho ladoꞌo dub men, ta weꞌetsa ndadiꞌizh xa. ");
INSERT INTO zpt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Leꞌa be men wen wa ndadiꞌizh ta wen, lak ta wen ncho ladoꞌo xa. No liga leꞌa bexa ugap ndadiꞌizh be ta ugap, lak ta ugap ncho ladoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Leꞌa naꞌ gáp leꞌa gal wizh gab Dios ná ton ndap ke, leꞌa itea be men isoꞌ ndoꞌ Dios gab bexa ná xtaꞌan mbidiꞌizh bexa itea be diꞌizh ugap. ");
INSERT INTO zpt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tal leꞌa bega ndadiꞌizh ta wen, weꞌe leꞌa Dios gab leꞌa bega naꞌanpa ndap ke. Ná tal leꞌa bega ndadiꞌizh ta ugap, weꞌe leꞌa Dios gab leꞌa bega ndapka ke. ");
INSERT INTO zpt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Weꞌe ncho bexa fariseo no be mech ten ley ukaꞌab ndab ndoꞌ Jesús: —Mech, leꞌa besa nlad gun go dub ta uluu leꞌa go Dioska mtuꞌub. ");
INSERT INTO zpt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa be men ncho nat uzhebpa be men ugap no ndankea bexa be ta naꞌanpa ta ugeapa nak Dios. Unab bega gun naꞌ dub ta uluu na ton nak naꞌ, parea leꞌa naꞌ lá gun ta unab bega wa. Ndi iniꞌítsa bega leꞌa naꞌ itiꞌid ltsaꞌa ta utid Jonás, xa mbidiꞌizh sakndoꞌ Dios tiemp polta. ");
INSERT INTO zpt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Lak uyoꞌo Jonás len dub mbeal siꞌil chon wizh no chon teꞌal, no liga leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yoo len yo chon wizh no chon teꞌal. ");
INSERT INTO zpt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","’Leꞌa gal wizh na gab Dios ná ton ndap ke, weꞌe leꞌa bexa uyoꞌo gezh Nínive wa gab leꞌa be men ncho nat ndee ugap nak. Leꞌa bexa Nínive mlaꞌa be ta ugap nak bexa, gor na mbiꞌín bexa diꞌizh ten Dios ta mbidiꞌizh Jonás. Ná leꞌa sa ndee nsoꞌ dub xa mas nsak ndoꞌ Jonás. ");
INSERT INTO zpt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No gal wizh wa leꞌa xagots unibeꞌe be men lad sur isoꞌ, gab xa leꞌa bega ndee ndapka ke. Leꞌa xa wa uzhebpa sit utoꞌo ndontsa mbidyoꞌón xa ta mbidiꞌizh Salomón, be ta uzheꞌeb ngók xa. Leꞌa sa ndee nsoꞌ dub xa mas nsak ndoꞌ Salomón wa, ná leꞌa bega lá nsakyoꞌón ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Leꞌa gor na ntoꞌo dub mbi bxin len ladoꞌo dub men, leꞌa ta wa cha nchaꞌa sa naꞌan men, nchaꞌkwaꞌan ná pa yoo na. Ná leꞌa gor na lá izheal pa yoo mbi bxin wa, ");
INSERT INTO zpt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","cha ndab mbi bxin wa: “Nsea naꞌ leꞌaka ta lid naꞌ sa utoꞌo naꞌ.” Leꞌa gor mtanseaꞌ mbi bxin wa, leꞌa ladoꞌo men wa cuent dub niꞌi tach, ndon umbiꞌi nak‑a no chul nsaxkwaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Weꞌe leꞌa mbi bxin wa cha nchaꞌgiꞌi stub sgaꞌad be mbi bxin mas ugap nak, cha yoo be mbi bxin wa ladoꞌo men wa. Cha mas kweaꞌ yoo xa ndoꞌ lak zha ned wa. No liga yasea be men ugap ncho tiemp nat. ");
INSERT INTO zpt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bi li nsoꞌyadiꞌizh Jesús ndoꞌ be men, leꞌa xnaꞌa Jesús no be wit xa ulayaꞌ sa wa. Ndebe bexa tsoꞌo juer, nlad bexa gudiꞌizhno bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Leꞌa dub men cha ndab ndoꞌ Jesús: —Unaꞌ go leꞌa xnaꞌa go no be wit ga ndebe tsoꞌo juer ndee nlad gudiꞌizhno ga. ");
INSERT INTO zpt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Leꞌa Jesús cha ukaꞌab ndab ndoꞌ xa wa: —Leꞌa naꞌ gáp ndoꞌ go ná ton xa na ta ugeaka nak xnaꞌa naꞌ nsea be wit naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Cha mluyaꞌa Jesús be xmen xa ndab xa: —Leꞌa bexa nde ndee nak xnaꞌa naꞌ no be wit naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Leꞌa itea bexa ndun lak nlad Xus naꞌ xa nsob gibeꞌa, bexa weꞌe nak wit naꞌ no bsan naꞌ no xnaꞌa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bi leꞌa wizh wa leꞌa Jesús utoꞌo len niꞌi wa, cha nchaꞌa xa toꞌo lagun Galilea, cha usob xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Weꞌe leꞌa kwaꞌad be men mzhealbe wats xa, cha ukea xa ndoꞌ dub barco, cha usob xa. Leꞌa itea be men wa utebe ndoꞌ yo bid toꞌotsa nits. ");
INSERT INTO zpt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Leꞌa Jesús cha mluu sian taꞌa, msaktabeꞌe xa be taꞌa, ndab xa: —Blaꞌach bego leꞌa dub xa ndun tiꞌin geꞌe utoꞌo nchaꞌutob xa bid ten trig ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Leꞌa gor na mteꞌach xa‑yá, ncho‑yá ulate toꞌo nes. Leꞌa be migin cha ulen cha udaw‑a. ");
INSERT INTO zpt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","No ncho‑yá ulate ndoꞌ yo geꞌ, sa uxee yo. Leꞌa ná wa uxax ulen, ");
INSERT INTO zpt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","parea ngol gor mnaꞌ bea leꞌa‑yá cha mgoꞌol cha ubid‑a, geal leꞌa‑yá naꞌanpa wat ndiꞌib loꞌ na. ");
INSERT INTO zpt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","No ncho‑yá ulate lat be gix nsoꞌ gich. Ngol gor leꞌa gix wa ngoꞌol, cha ulo xleaꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Parea leꞌa ncho‑yá ulate sa utaꞌa yo, cha msaꞌa‑yá sian bid. Ncho be trig wa msaꞌa dub gayoꞌoga bid. No ncho‑yá msaꞌa dub chon gaꞌal bid. No ncho‑yá msaꞌa dub galntiꞌi bid. ");
INSERT INTO zpt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bego na ndap nchaꞌ na, blaꞌach bego ta ndáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Leꞌa be xmen Jesús cha ulen wats xa, cha ndab bexa: —¿Xtaꞌan sbeꞌen nsaktabeꞌe ga be taꞌa no be ta nluu ga? ");
INSERT INTO zpt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa Dios nsaꞌa ta yakbeꞌena bega be ta ugaꞌach cuent ten xteꞌe nibeꞌe Dios. Ná leꞌa ndoꞌ bexa xaꞌaga naꞌanpa nsaꞌa Dios yakbeꞌena bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Leꞌa tal ton isakyoꞌón ta ndáp naꞌ, leꞌa Dios usaꞌa mas yakbeꞌena xa. Ná leꞌa tal ton lá isakyoꞌón, leꞌa Dios slat gast ta tuzh nyakbeꞌena xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ta weꞌe li sbeꞌen be taꞌa nsaktabeꞌe naꞌ be ta nluu naꞌ ndoꞌ be men. Leꞌa bexa nwiꞌi, ná lá nyakbeꞌena bexa ta naꞌ bexa. No ndoꞌón bexa ta ndáp naꞌ, ná ni lá isakyoꞌón bexa‑yá no ni lá yakbeꞌena bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Leꞌa ta ndun bexa wa nak lak ta mkeꞌa Isaías sakndoꞌ Dios, ndab Dios: Ndoꞌón bega‑yá, parea lá nyakbeꞌena bega‑yá. No nwiꞌi bega‑yá, parea lá iniꞌí bega xtaꞌan‑a. ");
INSERT INTO zpt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Leꞌa be men ndee uzhebpa myak ngud ladoꞌo na. No lá ndoꞌón bexa, no nsaꞌnyaw ndoꞌ bexa. Ta weꞌe lá inaꞌ bexa, no ni lá goꞌón bexa, no ni lá yakbeꞌena bexa. No ni naꞌanpa ilen bexa wats naꞌ utsuꞌu naꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Cha no ndab Jesús: —Ná leꞌa Dios ndun wen nyoꞌo ladna bego, geal leꞌa bega naꞌ be ta ndee no ndoꞌón bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Leꞌa naꞌ gáp leꞌa kwaꞌad bexa mbidiꞌizh sakndoꞌ Dios no bexa wen nak uyoꞌo polta, nlad bexa iniꞌí bexa ltsaꞌa ta naꞌ bega nat, ná leꞌa bexa lá iniꞌí ta wa. No nlad bexa goꞌón bexa ltsaꞌa ta ndoꞌón bega nat, ná leꞌa bexa lá ngoꞌón ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Blaꞌach bega nat ná xtaꞌan gab ta mbidiꞌizh naꞌ cuent ten xa na ngwaꞌyas trig. ");
INSERT INTO zpt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Leꞌa toꞌo nes sa ulate bid ten trig wa nak cuent bexa na ndoꞌón diꞌizh ten Dios ná xteꞌe nibeꞌe Dios be men, parea lá nyakbeꞌena bexa‑yá. Cha nlen maxuꞌu, cha ngoꞌo maxuꞌu diꞌizh wa len ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Leꞌa yo geꞌ wa nak cuent bexa nten ladna ndoꞌón diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ná leꞌa bexa wa nak cuent dub ya trig lá ndap sian loꞌ na. Ndangea ladna bexa diꞌizh ten Dios dub ndeꞌep, ná leꞌa gor na juert ncho bexa geal ndangea ladna bexa diꞌizh wa, cha nlaꞌa xa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Leꞌa yo ncho gix nsoꞌ gich wa nak cuent bexa na ndoꞌón diꞌizh ten Dios, ná leꞌa bexa nyuꞌ ladna be taꞌa ndoꞌ gizhliyo ndee, no ngeꞌ ladna bexa be ta siantsa ndap xa. Leꞌa bexa wa nak cuent dub trig naꞌan xtaꞌan usaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Parea leꞌa sa utaꞌa yo wa nak cuent bexa na ndoꞌón diꞌizh ten Dios no nyakbeꞌena bexa‑yá. Leꞌa bexa wa wen nak cuentta be trig nsaꞌa dub gayoꞌo bid no dub chon gaꞌal bid no dub galntiꞌi bid. ");
INSERT INTO zpt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Leꞌa Jesús cha msaktabeꞌe stub taꞌa, ndab xa ndoꞌ be men: —Leꞌa lak nibeꞌe Dios be men nak cuent ta ngwasea dub men ngos sbeꞌen bni wen ten trig ndoꞌ dub bleꞌa yo ten xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Parea ngol dub teꞌal gor ndeyats be men, cha ulen dub xa ndakloo ndoꞌ xa. Cha ngos xa be gix lá isuꞌu lat be bni ten trig wa, cha nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Leꞌa zha ulen trig no ulenga be bid ndoꞌ‑yá, cha no gix wa ulen lat‑a. ");
INSERT INTO zpt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Weꞌe leꞌa bexa ndun tiꞌin sa wa cha ngwaꞌyab‑a ndoꞌ xwan yo wa, ndab bexa: “Señor, ¿lid ngos ga sbeꞌen bni wen geꞌe ten ga baꞌ zha? ¿Ná nat pa utoꞌo be gix ncho lat‑a zha?” ");
INSERT INTO zpt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Leꞌa xa cha ndab: “Dub xa ndakloo ndoꞌ naꞌ ngos‑a.” Leꞌa bexa wa cha unabdiꞌizh ndab: “¿Nlad go yaꞌbedib besa be gix baꞌ zha?” ");
INSERT INTO zpt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Leꞌa xa cha ndab: “Lá yaꞌdib bega‑yá. Leꞌa tal bega kiꞌib be gix baꞌ, leꞌa be trig baꞌ no sgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Blaꞌa bego li junt gaꞌal‑a gast gal zha ibeleꞌe be bid ten trig. Zha weꞌe leꞌa naꞌ gáp ndoꞌ bexa gun tiꞌin wa uteleꞌe bexa ned lak be gix, cha uxi bexa gen‑a, cha utsoꞌol bexa‑yá. Weꞌe uteleꞌe bexa be bid ten trig wa, cha kochaꞌaw bexa‑yá ta lid naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Weꞌe msaktabeꞌe Jesús stub taꞌa, ndab xa: —Leꞌa lak nibeꞌe Dios be men nak lak ta ngwasea dub bid ten mostas, ta ngos dub xabgiꞌi ndoꞌ dub bleꞌa yo ten xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Leꞌa ta wa dub bid ndon leꞌa tuzh ndoꞌ itea be bid, parea ngoꞌol‑a cuent dub ya siꞌil, mas siꞌil ndoꞌ itea be ta xgeꞌa ndas be men, gast be migin ndandeꞌe xuꞌun ten na ndoꞌ be xos‑a. ");
INSERT INTO zpt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Cha msaktabeꞌe xa stub taꞌa, ndab xa: —Leꞌa lak nibeꞌe Dios be men nak lak nyak levadur. Leꞌa dub xagots mgoch dub tuzh‑a top gaꞌal kil arin. Ngol tsoꞌo wa leꞌa idub koꞌob arin wa usabich. ");
INSERT INTO zpt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Itea be ta ndee msaktabeꞌe Jesús be taꞌa ndoꞌ be men, leꞌa xa sbeꞌen li mbidiꞌizh ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Li ngok‑a lak ndab dub xa uyoꞌo polta sakndoꞌ Dios, ndab xa: Sbeꞌen usaktabeꞌe naꞌ be taꞌa, gor na gudiꞌizh naꞌ ndoꞌ be men. Gáp naꞌ be ta ugaꞌach nak, be taꞌa ni dub men gol iniꞌí idub ncho gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Cha mlaꞌa Jesús be men wa, cha uyoꞌo xa len dub niꞌi. Leꞌa be xmen xa cha no ulen wats xa, ndab bexa: —Bidiꞌizh ga ná xteꞌe nak ta msaktabeꞌe ga wa cuent ten gix ncho geꞌe wa. ");
INSERT INTO zpt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Leꞌa Jesús cha ndab: —Leꞌa xa ndas bni wen wa, leꞌa ta wa Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Leꞌa geꞌe wa leꞌa ta wa ndoꞌ gizhliyo ndee. Leꞌa bni wen wa leꞌa ta wa bexa nibeꞌe Dios. Leꞌa be gix wa, leꞌa ta wa bexa nibeꞌe maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Leꞌa xa ugap wa xa ngos gix wa, leꞌa ta wa maxuꞌu. Leꞌa gor uteleꞌe bexa trig wa, leꞌa ta wa zha idub tiemp ndee. Leꞌa bexa uteleꞌe be ta wa, leꞌa bexa wa be angel ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Leꞌa lak igiꞌib be gix no yolꞌ‑a, liga gak‑a gal zha idub tiemp ndee. ");
INSERT INTO zpt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Leꞌa gal zha wa leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, utuꞌub be angel ten naꞌ uteleꞌe itea bexa ugap nak no bexa nkiꞌil be men gun ta ugap. ");
INSERT INTO zpt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Leꞌa be angel wa cha utsaꞌab bexa ndoꞌ giꞌ, sa goꞌon bexa no gast ndeay bexa gaw bexa tant dub gealkweaꞌ siꞌil iniꞌí bexa. ");
INSERT INTO zpt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Weꞌe leꞌa bexa wen wa iluu cuent xeꞌa wizh sa nibeꞌe Dios Xus beuna. Bego na ndap nchaꞌ na, ¡blaꞌach bego ta ndáp naꞌ ndee! ");
INSERT INTO zpt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’No lak nibeꞌe Dios nak cuentta dub ta uzhebpa nsak ngachyoꞌo ndoꞌ dub yo. Leꞌa gor mzheꞌal dub men‑a, cha mkachko xa‑yá leꞌaka sa wa. Cha nten ladna xa nseaꞌ xa, ngwaꞌudoꞌo xa iteanak ta ndap xa, cha usiꞌi xa yo wa. ");
INSERT INTO zpt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’No leꞌa lak nibeꞌe Dios nak cuent ta ngwasea dub xa nsiꞌi utiꞌix be taꞌa, nkeseakwaꞌan xa be perla wen isiꞌi xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Leꞌa gor na mzheal xa dub ná ndon leꞌa nsak, cha ngwaꞌudoꞌo xa iteanak be ta ndap xa, cha usiꞌi xa perla wa. ");
INSERT INTO zpt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’No leꞌa lak nibeꞌe Dios nak lak ndanno be men dub red ntsaꞌab bexa ndoꞌ nits, nsen‑a isandoꞌ mbeal. ");
INSERT INTO zpt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Leꞌa gor nzhea‑yá cha ngoꞌo bexa‑yá toꞌo nits. Cha nsob bexa sa wa nti xa be mbeal wen wa ngochaꞌaw xa len zhum. Leꞌa bema lá isuꞌu wa ngote bexa dub lad. ");
INSERT INTO zpt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","No liga gak‑a gal zha idub tiemp ndee. Leꞌa be angel ten Dios ilen koꞌo bexa ugap lat bexa wen. ");
INSERT INTO zpt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Cha utsaꞌab be angel bexa ugap wa ndoꞌ giꞌ. Cha goꞌon bexa no gast ndeay bexa gaw bexa, tant dub gealkweaꞌ siꞌil iniꞌí bexa. ");
INSERT INTO zpt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Leꞌa Jesús cha unabdiꞌizh ndoꞌ be xmen na ndab xa: —¿Nyakbeꞌena bega iteanak ta ndáp naꞌ ndee zha? Leꞌa bexa cha ukaꞌab ndab: —Besa nyakbeꞌekana‑yá, Señor. ");
INSERT INTO zpt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Leꞌa Jesús cha ndab: —Leꞌa bexa ntsid ley ten Dios leꞌa gor na nyakbeꞌena bexa lak nibeꞌe Dios be men, leꞌa bexa wa nak cuent dub xwan niꞌi ngote be ta nsak ten xa sa nchochaꞌaw‑a, be ta kub no be ta gox. ");
INSERT INTO zpt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Leꞌa gor na mtayadiꞌizh Jesús be ta na li msaktabeꞌe xa be taꞌa wa, cha nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Leꞌa zha ulayaꞌ xa gezh Nazaret sa ngoꞌol xa, cha usaxan nluu xa be men len niꞌi sa nzhealbe bexa judio. Leꞌa be men cha ngwanseana xteꞌe ndadiꞌizh xa, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Pa mtsid xa baꞌ be ta ndák xa zha? ¿No xteꞌema ndun xa be uyon wa? ");
INSERT INTO zpt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Naꞌanpa xa ndee xin carpinter wa zha? ¿Naꞌanpa Marí nak xnaꞌa xa zha? ¿No naꞌanpa wit xa Jacob no Kosé no Simón no Judas? ");
INSERT INTO zpt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Naꞌanpa be bsan xa ncho lat beuna gezh ndee zha? ¿Xteꞌema ndák xa ta wa zha? ");
INSERT INTO zpt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Weꞌe naꞌanpa isakyoꞌón bexa ta ndab Jesús, ná leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa be men ndap mod ndoꞌ dub xa ndadiꞌizh sakndoꞌ Dios. Parea leꞌa bexa lazh xa no bexa ncho ta lid xa naꞌanpa ndap mod ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta weꞌe lá ngun Jesús sian uyon sa wa ke na lá ngungea ladna bexa ta ndadiꞌizh Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Leꞌa tiemp weꞌe leꞌa Herodes xa nibeꞌe sa wa mbiꞌín be ta ndun Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Cha ndab Herodes ndoꞌ bexa ndun tiꞌin ndoꞌ xa: —Leꞌa Jesús wa leꞌa nak Juan xa ulaleaꞌ be men wa mbangal ndoꞌ gealgut. Ta weꞌe ndap xa juers ndun xa be uyon wa. ");
INSERT INTO zpt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Leꞌa mas polta leꞌa Herodes unibeꞌe ndoꞌ be xmen na isen bexa Juan, cha uxi bexa Juan caden, no ukeꞌa bexa Juan litgiꞌib. Li mbin xa ke ten Herodías xagots ten Julip wit Herodes, ");
INSERT INTO zpt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","geal leꞌa Juan ndabla ndoꞌ Herodes: —Naꞌanpa utsin nak‑a ukaꞌa lu Herodías. ");
INSERT INTO zpt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ta weꞌe leꞌa Herodes nlad gut Juan, parea leꞌa xa nzheb ndoꞌ be men leꞌa bexa itea ndab leꞌa Juan dub xa ndadiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Leꞌa ngol dub wizh ngol leaꞌ Herodes, leꞌa xa ulo dub gast. Leꞌa sa wa utoꞌo xingots Herodías mbilndats xa ndoꞌ gaꞌal bexa nde ndoꞌ gast wa. Leꞌa Herodes cha uzhebpa ngol ladna xteꞌe mbilndats nagots wa, ");
INSERT INTO zpt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","cha ndab Herodes ndoꞌ xa: —Nsobwiꞌi Dios usa naꞌ guniꞌi xtaꞌan inab lu. ");
INSERT INTO zpt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Leꞌa nagots wa cha ndab ndoꞌ Herodes lak ndabla xnaꞌa na wa: —Nat bsaꞌa ga gek Juan xa ulaleaꞌ be men, ixoꞌob‑a ndoꞌ dub plat. ");
INSERT INTO zpt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Weꞌe leꞌa Herodes cha uban myoꞌo ladna. Parea ke na ndab xa leꞌa Dios nsobwiꞌi no ke na mbiꞌín be men nde ndoꞌ mes ta ndab xa wa, ta weꞌe unibeꞌe xa ndoꞌ be xmen xa usaꞌa bexa gek Juan, ");
INSERT INTO zpt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ndab xa yaꞌlabtoꞌog bexa gen Juan len litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Cha myoꞌo bexa gek Juan uxoꞌob‑a ndoꞌ dub plat, cha msaꞌa xa‑yá ndoꞌ nagots wa. Leꞌa xa wa cha ngwaꞌusaꞌa‑yá ndoꞌ xnaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Leꞌa be xmen Juan cha ulen, cha mbiꞌi bexa Juan mkaꞌach bexa xa. Cha ngwaꞌyab bexa‑yá ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Leꞌa gor na mbiꞌín Jesús ta wa, cha ukea xa ndoꞌ dub barco nchaꞌa xa dub sa naꞌan men. Ná leꞌa gor na mbiꞌín be men pa nchaꞌa Jesús, cha utoꞌo bexa be gezh nchaꞌa ndats bexa sa nchaꞌa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Leꞌa sa wa leꞌa gor ulaꞌ Jesús ndoꞌ barco wa cha uniꞌí xa kwaꞌad be men wa, cha mlats ladna xa bexa. Cha myunyakna xa be men gizh nde lat bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Leꞌa ngol gor uzhelapa leꞌa be xmen Jesús cha ubii wats Jesús, cha ndab bexa: —Leꞌa sa ndee dub sa naꞌanpa ncho men, no nat yá uzhela. Gud go ndoꞌ bexa kwaꞌad baꞌ yaꞌisiꞌi bexa ta gaw bexa be gezh baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Leꞌa Jesús cha ndab: —Naꞌanpa juerska yaꞌbe bexa. Ndi bsaꞌa bego ta gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Leꞌa be xmen Jesús cha ndab: —Leꞌa besa ndap sgaꞌaytsa pan no stoptsa mbeal. ");
INSERT INTO zpt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Leꞌa Jesús cha ndab: —Utseano bega‑yá sa ndee. ");
INSERT INTO zpt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cha ndab xa ndoꞌ be men kwaꞌad wa kwe bexa ndoꞌ gixgi. Cha usen xa isagaꞌay pan wa no itop mbeal wa, cha mwiꞌi xa gibeꞌa msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa be pan sian bleꞌa, cha msaꞌa xa‑yá ndoꞌ be xmen xa. Leꞌa bexa cha mtseꞌa‑yá ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Leꞌa itea bexa wa udaw gast plo mzhea bexa. Leꞌa be xmen Jesús cha mteleꞌe stibtop zhum byux be ta myaꞌan sobr wa. ");
INSERT INTO zpt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Leꞌa lat bexa li udaw wa pa dub gaꞌay mil xabgiꞌi, parea naꞌanpa igaꞌab be xagots no be meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cha ndab Jesús ndoꞌ be xmen na: —Bkea bega leꞌaka ndoꞌ barco baꞌ, cha waꞌned bega ndoꞌ naꞌ stub toꞌo nits baꞌ. Ndalen wa leꞌa Jesús ndab ndoꞌ be men kwaꞌad wa yaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Leꞌa gor na yá nseaꞌbe be men wa, leꞌa Jesús nab ukea dub bet ngwaꞌyadiꞌizhno Dios. Leꞌa gor na nseala teꞌal leꞌa Jesús nab nsoꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Leꞌa gor weꞌe leꞌa barco sitla nchaꞌa tol‑la ndoꞌ nits. Leꞌa be golp ten nits uzhebpa nkeꞌa las barco, no leꞌa mbi uzhebpa nlen ndoꞌ nits lad ndoꞌ barco. ");
INSERT INTO zpt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngol gor yamer gat xeꞌa, leꞌa Jesús nchasea ndats ndoꞌ nits, nchaꞌbii xa sa nchaꞌbe bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Leꞌa be xmen Jesús cha uniꞌí xa nsea xa ndoꞌ nits, cha mzheb bexa no ugeꞌ ndab bexa: —¡Leꞌa ta baꞌ dub ta uxin! ");
INSERT INTO zpt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ná leꞌa Jesús cha ndab ndoꞌ bexa: —¡Gop bega valor! ¡No lá izheb bega! Leꞌa ta ndee naꞌka. ");
INSERT INTO zpt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Leꞌa Pedr cha ukaꞌab ndab: —Señor, tal leꞌa go Jesús, unibeꞌe ga gal naꞌ wats ga ndoꞌ nits baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Leꞌa Jesús cha ndab ndoꞌ xa: —¡Utsea! Leꞌa Pedr cha ulaꞌ ndoꞌ barco nchasea ndats ndoꞌ nits, nchaꞌa xa wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Parea ngol gor uniꞌí Pedr lita nsoꞌ mbi siꞌil wa, cha mzheb xa. Cha usaxan nchaꞌlayoꞌo xa len nits. Cha utezhat xa ndab xa ndoꞌ Jesús: —¡Señor, utsealoꞌo ga naꞌ! ");
INSERT INTO zpt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Cha bi leꞌa gor wa leꞌa Jesús cha mkea yaꞌa na, cha usen xa yaꞌa Pedr. Cha ndab Jesús ndoꞌ xa: —¡Ndidotsa ngeꞌ ladna lu naꞌ! ¿Xtaꞌan lá ndangea ladna lu naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Leꞌa gor na ukea Jesús no Pedr ndoꞌ barco wa, leꞌa mbi wa cha uleas. ");
INSERT INTO zpt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Weꞌe leꞌa bexa nde ndoꞌ barco cha ngwankea Jesús, ndab bexa: —Ta ugeaka leꞌa go nak Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Leꞌa bexa cha utakea ndoꞌ nits wa, ulayaꞌ bexa sa nsaleaꞌ Genesaret. ");
INSERT INTO zpt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Leꞌa gor uniꞌí be men leꞌa Jesús nkesea sa wa, cha mtuꞌub bexa men ngwaꞌyab‑a ndoꞌ bexa ncho idub gangeak sa wa. Weꞌe cha ulenno be men itea bexa gizh wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Cha unab bexa ulaꞌa xa masa ndats xab xa ugal bexa gizh wa. Leꞌa itea bexa na li ngal xab Jesús wa cha myaknabe. ");
INSERT INTO zpt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tsoꞌo wa leꞌa pla be mech ten ley nsea bexa fariseo utoꞌo gezh Jerusalén nchaꞌbe wats Jesús. Cha ndab bexa ndoꞌ Jesús: ");
INSERT INTO zpt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Xtaꞌan ni lá ndankea be xmen lu be costumbr mchaꞌan be usan gox polta? Lbaꞌatsa naꞌa bexa gor ndaw bexa parea naꞌanpa naꞌa bexa lak nibeꞌe costumbr wa. ");
INSERT INTO zpt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Leꞌa Jesús cha ukaꞌab ndab: —¿Xtaꞌan lá ndun bega lak nibeꞌe ley ten Dios, ndi ndankeatsa bega be costumbr ten leꞌaka bega? ");
INSERT INTO zpt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Leꞌa Dios unibeꞌe ndab: “Wankea bega xus bega nsea xnaꞌa bega.” No ndab xa: “Leꞌa tal ton kweaꞌ iníꞌi ndoꞌ xus na natal ndoꞌ xnaꞌa na, leꞌa xa wa nsabndoꞌ gat.” ");
INSERT INTO zpt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ná leꞌa bego ndi ndab leꞌa tal ton gab ndoꞌ xus na natal ndoꞌ xnaꞌa na “leꞌa itea ta ndiꞌizh gakno naꞌ bega wa, leꞌa ta wa ndi usa naꞌ ndoꞌ Dios”, ");
INSERT INTO zpt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","weꞌe leꞌa xa wa yá naꞌantapa juerska gakno xus na no xnaꞌa na. Li nlaꞌa bega ta unibeꞌe Dios, ndankea bega ndi sbeꞌen costumbr ten bega. ");
INSERT INTO zpt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Leꞌa bega nluu cuentta xa wen, ná bega ugap nak. Ugeaka ndab Isaías sakndoꞌ Dios tiemp polta, ndab xa lak nak bego: ");
INSERT INTO zpt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Leꞌa be men ndee diꞌizhtsa ndankea naꞌ, parea leꞌa ladoꞌo xa sit nak ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Naꞌan xtiꞌin ta ndankea bexa naꞌ, leꞌa cuent diꞌizh ten naꞌ nluu bexa, parea diꞌizh ten be mentsa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Weꞌe leꞌa Jesús cha utezh be men kwaꞌad wa, ndab xa: —Blaꞌach bego ta gáp naꞌ ndee. No byakbeꞌena bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Leꞌa be ta ndaw be men naꞌanpa leꞌa ndun bzhiꞌik ladoꞌo be men. Ndi ta ugap ndadiꞌizh be men leꞌa ndun bzhiꞌik bexa. ");
INSERT INTO zpt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Cha ulen be xmen Jesús wats xa, ndab bexa: —¿Uniꞌí go leꞌa bexa fariseo ngokloo gor na mbiꞌín bexa ta li ndab go wa? ");
INSERT INTO zpt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa bexa nak cuent dub ya naꞌanpa ngas Xus naꞌ xa nsob gibeꞌa, leꞌa gal dub wizh leꞌa xa kib‑a. ");
INSERT INTO zpt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Blaꞌa bega bexa, leꞌa bexa cuent dub xa lá naꞌ nchaꞌano stub xa lá naꞌ. Leꞌa tal li goꞌo dub xa lá naꞌ stubga xa lá naꞌ, leꞌa bexa itop slaꞌyoꞌo len dub geꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Leꞌa Pedr cha ndab: —Bluu ga xteꞌe nak ta msaktabeꞌe ga wa ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Leꞌa Jesús cha ndab: —¿Noga bego ni lá nyakbeꞌena ta ndáp naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Lá nyakbeꞌena bega zha leꞌa ta ndaw dub men nchaꞌa len xa, cha nchaꞌaga‑yá len letrina? ");
INSERT INTO zpt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ná leꞌa ta ugap ndadiꞌizh be men wa ladoꞌoka xa ntoꞌo. Cha ndun bzhiꞌik‑a xa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Leꞌa len ladoꞌo be men ntoꞌo be ta ugap ndanbeꞌe bexa. Ta weꞌe ncho xa ndut men. No ngal xa xa ten stubga men. No ndun xa ta ugap ltsaꞌa ta li nak wa. No ndun xa gealwaꞌan no gealkwiꞌin. No nisi xa be ltsaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Leꞌa itea be ta ugap ndee ndun bzhiꞌik bexa cuent ten Dios. Parea ta na lá unaꞌa dub xa lak nibeꞌe bexa wa cha gaw xa, leꞌa ta wa naꞌanpa gun bzhiꞌik xa cuent ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Cha utoꞌo Jesús nchaꞌa xa dub sa gax gezh Tiro no gezh Sidón. ");
INSERT INTO zpt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Weꞌe leꞌa dub xagots ncho sa wa dub xa Canaán ulen wats Jesús, ugeꞌ ndab xa: —¡Señor, xin David! ¡Blats ladna go naꞌ! Leꞌa xiꞌín gots naꞌ ncho mbi bxin len ladoꞌo na uzhebpa kweaꞌ nsak xa. ");
INSERT INTO zpt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ná leꞌa Jesús ni lá ikaꞌab ndoꞌ xa. Leꞌa be xmen Jesús cha ulen wats xa, cha ndab bexa: —Gud go ndoꞌ xa baꞌ yaꞌ xa, leꞌa xa uzhebpa ndun ruid nsenkea xa tsoꞌo beuna. ");
INSERT INTO zpt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Leꞌa Jesús cha ndab: —Leꞌa Dios mtuꞌub naꞌ gakno naꞌ bexa Israeltsa, bexa nak cuent be borreg ulaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Parea leꞌa xagots wa ubii, cha usaxib xa ndoꞌ Jesús, ndab xa: —¡Señor, gokno ga naꞌ! ");
INSERT INTO zpt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Leꞌa Jesús cha ndab: —Naꞌanpa utsin nak ulat besa pan ndoꞌ be meꞌed, cha usaꞌab besa‑yá ndoꞌ be mbek. ");
INSERT INTO zpt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Leꞌa xagots wa cha ndab: —Ta ugeaka ta wa, Señor, parea leꞌa be mbek ndaw be taꞌa nlate xan mes ten xwan ma. ");
INSERT INTO zpt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Leꞌa Jesús cha ndab: —Xagots, uzheꞌeb ngeꞌ ladna lu naꞌ. Nat gak ta nlad lu. Bi leꞌa gor wa leꞌa xingots xa wa cha myakna. ");
INSERT INTO zpt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Leꞌa Jesús cha utoꞌo sa wa nchaꞌagal xa toꞌo lagun Galilea. Cha ukea xa dub bet, cha usob xa. ");
INSERT INTO zpt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Weꞌe leꞌa kwaꞌadpa men ulen wats xa, nseano bexa bexa lá yoo gan isea, no bexa lá naꞌ, no bexa lá yoo gan gudiꞌizh, no bexa moch, nsea kwaꞌadta bexa gizh. Cha mte bexa bexa gizh wa ndoꞌ Jesús, cha myunyakna Jesús bexa. ");
INSERT INTO zpt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Leꞌa be men wa ngwanseanabe gor uniꞌí bexa leꞌa bexa lá yoo gan gudiꞌizh wa ndadiꞌizhla, no bexa moch wa myaklana, no bexa lá yoo gan isea wa utsinla nsea, no bexa lá naꞌ wa nwiꞌila. No ndab be men leꞌa Dios ten bexa Israel uzheꞌeb dub Dios juert. ");
INSERT INTO zpt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cha utezh Jesús be xmen na, cha ndab xa: —Leꞌa naꞌ nlats ladna be men kwaꞌad ndee, leꞌa bexa wizh nyonla nde wats naꞌ, parea lá ndapta bexa ta gaw na. Leꞌa naꞌ lá nlad utuꞌub naꞌ bexa lbaꞌatsa lá gaw bexa, nchaꞌa bexa lá uxik ilanseaꞌ ta lid na. ");
INSERT INTO zpt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Leꞌa be xmen Jesús cha ndab ndoꞌ xa: —¿Pa izheal beuna pan gaw dub lbaꞌata men kwaꞌad baꞌ? Leꞌa sa ndee sit nde be gezh. ");
INSERT INTO zpt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Leꞌa Jesús cha unabdiꞌizh ndab: —¿Plo pan ndap bega zha? Leꞌa bexa cha ndab: —Sgaꞌad pan nsea stapla mbeal byux. ");
INSERT INTO zpt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Cha ndab Jesús ndoꞌ be men kwaꞌad wa kwe bexa ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cha usen xa isagaꞌad pan nsea be mbeal wa, cha msaꞌa xa xno ndoꞌ Dios, no uleꞌa xa be ta wa sian bleꞌa. Weꞌe msaꞌa xa‑yá ndoꞌ be xmen xa, utseꞌa bexa‑yá ndoꞌ be men wa. ");
INSERT INTO zpt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Leꞌa be men wa itea udaw gast plo mzhea bexa. Cha mteleꞌe be xmen Jesús sgaꞌad zhum byux be ta myaꞌan sobr. ");
INSERT INTO zpt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Leꞌa lat bexa udaw wa ncho pa dap mil xabgiꞌitsa, parea naꞌanpa igaꞌab be xagots no be meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Cha ndab Jesús ndoꞌ be men yaꞌbe bexa. Cha ukea xa ndoꞌ barco wa nchaꞌa xa dub sa gax gezh nsaleaꞌ Magdala. ");
INSERT INTO zpt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Leꞌa pla bexa fariseo no bexa saduceo ulen wats Jesús, nlad bexa gun bexa preb Jesús, ndab bexa ndoꞌ Jesús: —Leꞌa besa nlad gun ga dub ta uluu leꞌa ga Dioska mtuꞌub. ");
INSERT INTO zpt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ncho uzhe leꞌa gibeꞌa baꞌ nane naꞌ, cha ndab bego leꞌa geꞌa naꞌanpa ilaꞌ gi. ");
INSERT INTO zpt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","No ncho tempran leꞌa gibeꞌa baꞌ nane naꞌ no nde xkaw, cha ndab bega nat ilaꞌ gi. ¡Bego nluu cuentta xa wen ná bega ugap nak! Nyakbeꞌena bega xteꞌe nak be ta naꞌ bega gibeꞌa baꞌ, ná ni lá nyakbeꞌena bega ta ndun Dios tiemp nat. ");
INSERT INTO zpt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Leꞌa be men ncho nat uzhebpa be men ugap no nkwaꞌan bexa be ta naꞌanpa ta ugeapa nak Dios. Ndab bega gun naꞌ dub ta uluu na ton nak naꞌ, parea leꞌa naꞌ lá gun ta ndab bega. Ndi iniꞌítsa bega leꞌa naꞌ itiꞌid ltsaꞌa ta utid Jonás, xa mbidiꞌizh sakndoꞌ Dios tiemp polta. Cha mlaꞌa Jesús bexa, cha nchaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Weꞌe leꞌa Jesús nsea be xmen xa utakea stub toꞌo nits, parea myalad bexa ngoꞌo bexa pan gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Leꞌa Jesús cha ndab ndoꞌ bexa: —Blaꞌach bego, uzhebpa gop bega cuent nsea levadur ten bexa fariseo no levadur ten bexa saduceo. ");
INSERT INTO zpt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Leꞌa bexa cha ndabbe ndoꞌ ltsaꞌa na: —Li ndab xa baꞌ geal leꞌa beuna lá ngoꞌo pan. ");
INSERT INTO zpt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Leꞌa Jesús cha mgenna ta li ndanbeꞌe bexa wa, cha ndab xa: —¿Xtaꞌan lbaꞌa nyuꞌ ladna bega leꞌa bega lá noꞌo pan zha? ¡Ndidotsa ngeꞌ ladna bega naꞌ! ");
INSERT INTO zpt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Bi lá nyakbeꞌena bega be ta uniꞌí bega uyoꞌo wa zha? ¿Ni lá ntseꞌa ladna bega xteꞌe msa naꞌ gaꞌay pan udaw gaꞌay mil xabgiꞌi wa, no plo zhum ta myaꞌan sobr mteleꞌe bega zha weꞌe zha? ");
INSERT INTO zpt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿No ni lá ntseꞌa ladna bega xteꞌe msa naꞌ dub gaꞌad pan udaw dub dap mil xabgiꞌi zha, no plo zhum ta myaꞌan sobr mteleꞌe bega zha? ");
INSERT INTO zpt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Xtaꞌan lá nyakbeꞌena bega leꞌa naꞌ naꞌanpa ndadiꞌizh cuent ten pan gor ndáp naꞌ gop bega cuent nsea levadur ten bexa fariseo no levadur ten bexa saduceo zha? ");
INSERT INTO zpt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Leꞌa bexa wa cha myakbeꞌena leꞌa Jesús naꞌanpa ngab gap bexa cuent nsea levadur ten pan. Leꞌa xa ndi ndab gap bexa cuent nsea ta nluu bexa fariseo nsea bexa saduceo. ");
INSERT INTO zpt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Leꞌa gor na ulayaꞌ bexa gax dub gezh nsaleaꞌ Cesarea Filipo, leꞌa Jesús cha unabdiꞌizh ndoꞌ be xmen na, ndab xa: —¿Xteꞌe ndab be men ton nak Xa Myak Men Ndoꞌ Gizhliyo zha? ");
INSERT INTO zpt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Leꞌa bexa cha ukaꞌab ndab: —Leꞌa ncho be men ndab leꞌa go nak Juan xa ulaleaꞌ be men. No ncho bexa ndab leꞌa go nak Elí. No nchoga bexa ndab leꞌa go Jeremías, natal stubga xa mbidiꞌizh sakndoꞌ Dios tiemp polta. ");
INSERT INTO zpt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Leꞌa Jesús cha ndab: —¿Leꞌa bego zha xteꞌe gab ton nak naꞌ? ");
INSERT INTO zpt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Leꞌa Simón Pedr cha ukaꞌab ndab: —Leꞌa go nak Cristo Xin Dios nban. ");
INSERT INTO zpt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Weꞌe leꞌa Jesús cha ndab ndoꞌ xa wa: —Simón xin Jonás, uzhebpa wen yoo ladna lu, leꞌa ta ndab lu naꞌanpa men mluu ndoꞌ lu, ndi Xus naꞌ xa ncho gibeꞌa mluu‑yá ndoꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Leꞌa lu nsaleaꞌ Pedr. Leꞌa ndoꞌ geꞌdaꞌa ndee kwe dub xkwaꞌa men gungea ladna naꞌ. Leꞌa juers ten gealgut naꞌanpa gun gan ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Leꞌa naꞌ leꞌa usoꞌ lu gak lu xa yansu bexa leꞌa Dios nibeꞌe. Leꞌa itea be ta inibeꞌe lu ta lá gun bexa, leꞌa ta wa nokaga Dios lá ulaꞌa. No liga itea be ta inibeꞌe lu gun bexa, leꞌa ta wa ta na nokaga Dios inibeꞌe li gak. ");
INSERT INTO zpt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Leꞌa Jesús cha unibeꞌe ndoꞌ be xmen na naꞌanpa gab bexa ndoꞌ ni dub men leꞌa Jesús nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Leꞌa zha weꞌe usaxan Jesús ndadiꞌizh ndoꞌ be xmen na leꞌa xa juerska yaꞌ Jerusalén, ndab xa: —Leꞌa Jerusalén wa leꞌa bexa gox nsak nsea be uleꞌay nibeꞌe nsea be mech ten ley ugap gunno naꞌ. No gut bexa naꞌ, parea leꞌa wizh yon leꞌa naꞌ iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Weꞌe leꞌa Pedr cha mbiꞌi Jesús dub lad, cha uteyo Pedr xa, ndab Pedr: —¡Naꞌanpa li gak‑a, Señor! ¡Leꞌa Dios lá ulaꞌa li yasea ga! ");
INSERT INTO zpt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ná leꞌa Jesús cha myach mwiꞌi ndoꞌ Pedr, ndab xa: —Utatsoꞌ wats naꞌ, leꞌa lu ndadiꞌizh cuent maxuꞌu, lá nlad lu gun naꞌ ta nlad Dios. Leꞌa lu lá ndanbeꞌe lak ndanbeꞌe Dios, leꞌa lu ndi ndanbeꞌe lak ndanbeꞌe be mentsa. ");
INSERT INTO zpt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Cha ndab Jesús ndoꞌ be xmen na: —Tal ton nlad isankea tsoꞌo naꞌ, nsabndoꞌ ulaꞌa xa iteanak ta nlad xa, cha goꞌo xa cruz ten xa, cha isankea xa tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Leꞌa tal ton ukwaꞌan xteꞌe wen yoo xa, leꞌa xa wa ndi gun perdid gealnaban ten na ndoꞌ Dios. Ná leꞌa tal ton gat geal ndangea ladna xa naꞌ, leꞌa xa wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tal leꞌa dub men ndap iteanak be ta ncho ndoꞌ gizhliyo ndee, cha gak perdid gealnaban ten xa ndoꞌ Dios, ¿xtiꞌin iteanak be ta ndap xa wa zha? Leꞌa be ta wa naꞌanpa ugal isiꞌi xa gealnaban ten xa. ");
INSERT INTO zpt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilenno xeꞌa siꞌil ten Dios Xus naꞌ no be angel. Cha kixga naꞌ ikaꞌa kad dub men be ta mbin xa. ");
INSERT INTO zpt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Leꞌa naꞌ gáp ndoꞌ bego leꞌa ncho bega nde ndee naꞌanpa gat gast iniꞌí bega leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilen inibeꞌegal. ");
INSERT INTO zpt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ngol sxoꞌop wizh leꞌa Jesús mbiꞌi Pedr no Jacob no Juan wit Jacob, ukea bexa dub bet gaꞌap sa naꞌan men. ");
INSERT INTO zpt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Leꞌa sa wa leꞌa Jesús mtixndoꞌ ndoꞌ gaꞌal bexa wa, leꞌa ndoꞌ Jesús myak cuent xeꞌa wizh no xab xa ndon mbe mnaꞌ cuent xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Zha leꞌa sa wa mlundoꞌ Moisés no Elí ndeyadiꞌizhno Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Weꞌe leꞌa Pedr cha ndab ndoꞌ Jesús: —Señor, uzhebpa wen nde beuna sa ndee. Tal go nlad gundeꞌe besa chon ramad: dub‑a ná ten go, leꞌa stub‑a ná ten Moisés, nsea stub‑a ná ten Elí. ");
INSERT INTO zpt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ndalen li nsoꞌyadiꞌizh Pedr, cha ulen dub xkaw msu xeꞌa idub sa ndebe bexa. Leꞌa lat xkaw wa mgen ti Dios ndab: —Leꞌa ta ndee Xiꞌín naꞌ. Leꞌa naꞌ nkweaꞌ ladna xa no ntenno lad naꞌ xa. Bsakyoꞌón bega ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Leꞌa gor na mbiꞌín be xmen Jesús ta wa, cha msaxib bexa gast ndoꞌ yo ngol xtuzh bexa, no uzhebpa mzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Leꞌa Jesús cha ubii gax wats bexa, cha mgal Jesús gek bexa, cha ndab xa: —Gosoꞌ bega, lá izhebta bega. ");
INSERT INTO zpt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Leꞌa gor na mwiꞌi bexa yá naꞌanla ton ndebe sa wa. Leꞌa Jesús nabla nsoꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Leꞌa gor na nchaꞌlayoꞌo bexa bet wa, leꞌa Jesús ndab ndoꞌ bexa: —Naꞌan ton ndoꞌ ná gudiꞌizh bega ta li uniꞌí bega wa, gast gor ibangal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Leꞌa bexa wa cha unabdiꞌizh ndoꞌ Jesús ndab: —¿Xtaꞌan ndab be mech ten ley leꞌa Elí ned ilen, weꞌeta ilen Cristo xa utuꞌub Dios zha? ");
INSERT INTO zpt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Leꞌa Jesús cha ukaꞌab ndab: —Ta ugeaka leꞌa Elí nedka ilen ndontsa list kwe be men. ");
INSERT INTO zpt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Leꞌa naꞌ gáp ndoꞌ bego, leꞌa Elí wa mbiꞌidla. Ná leꞌa be men lá igondoꞌ xa, ndi ugap mbinno bexa xa lakta nlad bexa. No liga gunno bexa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Weꞌe leꞌa be xmen Jesús myakbeꞌena leꞌa Jesús mbidiꞌizh cuent ten Juan xa ulaleaꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Leꞌa gor na mlaꞌnchaꞌ bexa sa nde be men kwaꞌad, leꞌa dub xabgiꞌi cha ulen wats Jesús, cha msaxib xa ndoꞌ Jesús ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, blats ladna go xiꞌín naꞌ, leꞌa meꞌed uzhebpa kweaꞌ nsak gizhkaw. Sian biaj nlayat meꞌed ndoꞌ giꞌ no ndoꞌ nits. ");
INSERT INTO zpt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Leꞌa naꞌ ngwaꞌnola meꞌed ndoꞌ be xmen ga, ná leꞌa bexa lá ngun gan yakna meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Leꞌa Jesús cha ndab ndoꞌ be men: —Uzheꞌeb ngud nak bega no ndidotsa ngeꞌ ladna bega Dios. ¿Ploxá tiemp yoꞌo naꞌ lat bega zhaga? ¿Sta ploxá tiemp uxik naꞌ ndoꞌ bega zhaga? Utseano bega meꞌed baꞌ sa ndee. ");
INSERT INTO zpt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Leꞌa Jesús cha uteyo mbi bxin ncho ladoꞌo meꞌed bgiꞌi wa. Leꞌa mbi bxin wa cha utoꞌo, cha bi leꞌa gor wa myakna meꞌed wa. ");
INSERT INTO zpt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsoꞌo wa leꞌa be xmen Jesús ulen wats Jesús, unabdiꞌizh bexa ndoꞌ Jesús, ndab bexa: —¿Xtaꞌan lá ngun besa gan igontuꞌub besa mbi bxin wa zha? ");
INSERT INTO zpt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Leꞌa Jesús cha ndab: —Leꞌa bega ndidotsa ngeꞌ ladna Dios. Leꞌa naꞌ gáp ndoꞌ bega tal leꞌa bega ngeꞌ ladna Dios lak tuzh dub bid ten ya mostas, leꞌa bega sunka gan gab ndoꞌ bet ndee: “Bxoꞌon sa ndee, waꞌ sa baꞌ”; leꞌa bet cha uxoꞌon. Tal leꞌa bega li igeꞌ ladna Dios, leꞌa bega itea taꞌa sunka gan. ");
INSERT INTO zpt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Parea leꞌa be ltsaꞌa mbi bxin ndee lá yoo gan itoꞌo xagaꞌ. Nkiꞌin lá gaw bega dub tiemp no mas gudiꞌizhno bega Dios ndontsa slaꞌa be mbi bxin wa be men. ");
INSERT INTO zpt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Leꞌa dub wizh zha ndencho bexa wa Galilea, leꞌa Jesús ndabgal ndoꞌ be xmen na: —Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa be men. ");
INSERT INTO zpt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Leꞌa bexa wa cha gut naꞌ, parea leꞌa wizh yon leꞌa naꞌ ibangal. Leꞌa bexa wa cha uzhebpa uban myoꞌo ladna. ");
INSERT INTO zpt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Leꞌa bexa wa cha nchaꞌagal gezh Capernaum. Weꞌe leꞌa bexa na nkaꞌa med ten niꞌi ten Dios ulen ndoꞌ Pedr, ndab bexa: —¿Nkix mech ten bega med ndantiꞌin bexa niꞌi ten Dios zha? ");
INSERT INTO zpt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Leꞌa Pedr cha ukaꞌab ndab: —Leꞌa xa nkixka‑yá. Ngol gor uyoꞌo Pedr len niꞌi, leꞌa Jesús ned uníꞌi ndoꞌ Pedr, ndab xa: —¿Xteꞌe nsak lu, Simón? Leꞌa bexa ndon leꞌa nibeꞌe ndoꞌ gizhliyo, ¿ton ndoꞌ ná ndun bexa cobr be med zha? ¿Ndoꞌ bexa lazh xa nate ndoꞌ bexa ntoꞌo sit? ");
INSERT INTO zpt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Leꞌa Pedr cha ukaꞌab ndab: —Ndoꞌ bexa ntoꞌo sit ndun bexa cobr. Leꞌa Jesús cha ndab: —Ta ugeaka leꞌa bexa lazh xa nibeꞌe wa naꞌanpa juerska kix ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Parea ndontsa lá gakloo bexa, waꞌ toꞌo lagun, cha btsaꞌab gibganch ndoꞌ nits wa. Leꞌa mbeal ned isen‑a, leꞌa toꞌo ma wa izheal lu dub med. Cha biꞌi‑yá waꞌtix ta ten itop beuna. ");
INSERT INTO zpt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tsoꞌo wa leꞌa be xmen Jesús ulen ndoꞌ Jesús ndab bexa: —¿Ton mas nsak lat bexa nibeꞌe Dios? ");
INSERT INTO zpt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Leꞌa Jesús cha utezh dub meꞌed, cha msoꞌ Jesús meꞌed tlaw bexa. ");
INSERT INTO zpt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Cha ndab xa ndoꞌ bexa: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa tal bega lá yak lak nak be meꞌed, leꞌa bega lá yoo gan yate lat bexa leꞌa Dios nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ta weꞌe leꞌa tal ton yak tuzh ndoꞌ Dios lak nak dub meꞌed ndee, leꞌa xa wa mas nsak lat bexa leꞌa Dios nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Leꞌa tal ton dub xmen naꞌ utsin gak xa ndoꞌ dub meꞌed nak cuent meꞌed ndee, leꞌa xa wa cuentkata ndoꞌ naꞌ utsin nak. ");
INSERT INTO zpt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Leꞌa tal ton utsabgix dub xa ndangea ladna naꞌ ndoꞌ ta ugap, leꞌa xa wa mas dub gealkweaꞌ siꞌil iniꞌí ndoꞌ dub xa nkea dub geꞌ siꞌil gen na, cha utsaꞌab be men xa sa mas wat len nitsdoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Proꞌob be men nde ndoꞌ gizhliyo isabgix ndoꞌ ta ugap. Idub tiemp ncho ta ntsabgix be men ndoꞌ ta ugap, parea uzhebpa proꞌob bexa leꞌa utsabgix stubga men. ");
INSERT INTO zpt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ta weꞌe tal leꞌa dub yaꞌa bega natal dub xoꞌo bega utsabgix bega, ulobtoꞌog bega‑yá cha udabi bega‑yá. Mas wen yoo bega wats Dios moch bega, ndoꞌ ndap bega itop yaꞌa bega nsea itop xoꞌo bega yaꞌ bega ndoꞌ giꞌ nunk lá yuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No tal leꞌa dub ngusndoꞌ bega utsabgix bega, uloꞌo bega‑yá cha udabi bega‑yá. Mas wen yoo bega wats Dios dubtsa ngusndoꞌ bega, ndoꞌ itop ngusndoꞌ bega yaꞌ bega ndoꞌ giꞌ infierno. ");
INSERT INTO zpt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Blaꞌach bega lá uxelad bega ni dub men ndangea ladna naꞌ lak dub meꞌed. Leꞌa naꞌ gáp ndoꞌ bego leꞌa be angel ndesoꞌ ulaꞌach bexa wa idub tiemp nde wats Xus naꞌ, xa nsob gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ndalteꞌezh naꞌ bexa ulaꞌ, bexa sit nak wats Dios, ndontsa gap bexa gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Xá nsak bega zha? Tal leꞌa dub xabgiꞌi ndap dub gayoꞌo borreg, cha ilaꞌ dub ma, ¿lid ulaꞌa xa isadap gaꞌal ncho tiꞌin bdap ma, cha ndi yaꞌ xa be geꞌe yaꞌkwaꞌan xa ma li ulaꞌ wa? ");
INSERT INTO zpt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Leꞌa naꞌ gáp ndoꞌ bega, leꞌa gor mzheal xa ma, leꞌa xa mas itenno ladna ma ulaꞌ wa ndoꞌ isadap gaꞌal ncho tiꞌin bdap bema naꞌanpa ilaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","No liga leꞌa Dios Xus beuna xa nsob gibeꞌa lá nlad isabgix ni dub bexa ndangea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tal dub ltsaꞌa ga ugap gunno ga, cha waꞌyadiꞌizhno ga nab xa. Tal xa nsakyoꞌón ta ndab ga wa, leꞌa ga mbinka gan mchealtsaꞌa xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ná tal leꞌa xa lá isakyoꞌón ta ndab ga, biꞌi ga stub xa natal stop xa ndontsa no bexa gab ndoꞌ xa ná xtaꞌan ta ugap mbin xa. ");
INSERT INTO zpt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tal leꞌa xa wa lá isakyoꞌón ta ndab bexa wa, cha gab ga‑yá sa nzhealbe bexa nak xmen naꞌ. No binno bega xa cuent dub xa lá nchandoꞌ Dios natal cuent dub xa ugap nsen med nkix be men ndoꞌ Roma. ");
INSERT INTO zpt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Leꞌa naꞌ gáp ndoꞌ bego leꞌa ta na lá nlaꞌa bega gun be men ndoꞌ gizhliyo ndee, leꞌa ta wa no Dios lá ulaꞌa gun bexa wa. No liga ta na nsaꞌa bega diꞌizh gun be men ndoꞌ gizhliyo, leꞌa ta wa no Dios usaꞌa diꞌizh gun bexa. ");
INSERT INTO zpt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’No gáp naꞌ stub biaj, tal leꞌa top bega dubtsa gudiꞌizh inab dub taꞌa ndoꞌ Xus naꞌ xa nsob gibeꞌa, leꞌa xa saꞌaka ta inab bega wa. ");
INSERT INTO zpt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Leꞌa sa nde top xa natal chon xa nak xmen naꞌ, leꞌa naꞌ no nsoꞌ tlaw bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Leꞌa Pedr cha ulen wats Jesús cha unabdiꞌizh Pedr, ndab xa: —Señor, ¿plo biaj nsabndoꞌ gungeꞌ lad naꞌ ndoꞌ dub ltsaꞌa naꞌ tal xa ugap gunno naꞌ zha? ¿Nati gaꞌad biaj? ");
INSERT INTO zpt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Leꞌa Jesús cha ukaꞌab ndab: —Naꞌanpa gáp naꞌ gaꞌadtsa biaj gungeꞌ ladna lu ndoꞌ xa, leꞌa naꞌ ndi gáp gast chon gaꞌal ncho tiꞌi gaꞌad biaj gungeꞌ ladna lu ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Leꞌa lak nibeꞌe Dios be men nak lak ndun dub rey nibeꞌe, gor na nlad xa iniꞌí xa ná plo med nsaꞌab be xmen xa ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Leꞌa gor na tiꞌi usaxan rey ndun ta wa, cha nseano bexa dub xmen rey uzhebpa sian mil med nsaꞌab ndoꞌ rey. ");
INSERT INTO zpt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Leꞌa xa wa naꞌanpa ndap xtaꞌan kix xa, ta weꞌe leꞌa rey wa unibeꞌe ndoꞌ be xmen na udoꞌo bexa xa nsaꞌab med wa no xagots ten xa no be xin xa no iteanak be ta ndap xa wa, ndontsa kix xa med wa. ");
INSERT INTO zpt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Weꞌe leꞌa xa wa cha msaxib ndoꞌ rey, ndab xa: “Señor, kweas go dub ndeꞌep leꞌa naꞌ skixka itea med wa.” ");
INSERT INTO zpt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Leꞌa rey cha mlats ladna xa wa, mbingeꞌ ladna rey ta li nsaꞌab xa wa, cha mxaꞌak rey xa. ");
INSERT INTO zpt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Parea leꞌa gor utoꞌo xmen rey sa wa, mzheꞌal xa stubga xmen rey nsaꞌab dub tuzh med ndoꞌ xa. Cha usen xa gen xa wa nkeutsebe xa‑yá, cha ndab xa: “¡Utix ta nsaꞌab lu ndoꞌ naꞌ!” ");
INSERT INTO zpt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Leꞌa xa nsaꞌabga wa cha usaxib, ndab xa: “Kweas ga dub ndeꞌep leꞌa naꞌ skixka itea‑yá.” ");
INSERT INTO zpt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ná leꞌa xa wa lá ngungeꞌ ladna, cha ndi ngwaꞌukeꞌa xa xa nsaꞌab med wa litgiꞌib gast kix xa ta nsaꞌab xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Leꞌa gor na uniꞌí stapla be xmen rey ta li mbin xa wa, cha uzheꞌeb uban myoꞌo ladna bexa. Cha nseaꞌbeyab bexa ndoꞌ rey ta li ngok wa. ");
INSERT INTO zpt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Leꞌa rey cha utezh xa na li mbin wa, cha ndab xa ndoꞌ xa: “¡Uzhebpa ugap nak lu! Leꞌa naꞌ mbingeꞌ ladna iteanak be ta nsaꞌab lu ndoꞌ naꞌ naꞌanpa ikix lu‑yá, geal leꞌa lu li unab ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Lid no lu nsabndoꞌ ilats ladna ltsaꞌa lu wa zha, lak mlats lad naꞌ lu?” ");
INSERT INTO zpt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Leꞌa rey cha ngokloo cha unibeꞌe xa ndoꞌ be soldad ten xa utsaksi bexa xa wa gast kix xa itea be med nsaꞌab xa. ");
INSERT INTO zpt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","No ndab Jesús: —Leꞌa Xus naꞌ xa nsob gibeꞌa noga li gunno bego tal leꞌa bega lá gungeꞌ ladna ndoꞌ be ltsaꞌa bega idub ncho ladna bega be ta ugap ndanno bexa bega. ");
INSERT INTO zpt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Leꞌa gor mtayadiꞌizh Jesús ta wa, cha mkaꞌan xa Galilea nchaꞌa xa Judea stub toꞌo yowbeꞌe Jordán. ");
INSERT INTO zpt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Leꞌa sa wa leꞌa kwaꞌadpa men usankea tsoꞌo xa, cha myunyakna Jesús bexa gizh sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Weꞌe leꞌa pla bexa fariseo ulen wats Jesús, nlad bexa gab Jesús dub ta lid leꞌa nak, ndab bexa ndoꞌ Jesús: —¿Utsin nak ulaꞌa dub xabgiꞌi xagots ten na, tal xa lá nsak ladna xtaꞌanla dub ta ndun xa zha? ");
INSERT INTO zpt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Leꞌa Jesús cha ukaꞌab ndab: —¿Lá ndoꞌol bega zha sa nkeaniꞌi diꞌizh ten Dios, leꞌa Dios leꞌa mbindeꞌe xabgiꞌi no xagots zha ned wa? ");
INSERT INTO zpt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Cha ndab Dios: “Ta weꞌe ulaꞌa xabgiꞌi xus na no xnaꞌa na zha na ikaꞌa xa xagots ten xa. Leꞌa cuent ten Dios leꞌa itop xa wa yak dubtsa men.” ");
INSERT INTO zpt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Leꞌa bexa wa dubtsa men myak, yá lid topta xa. Ta weꞌe gáp naꞌ leꞌa bexa mchealte Dios, lá nsabndoꞌ dub men uteltsaꞌa bexa. ");
INSERT INTO zpt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Leꞌa bexa fariseo wa cha unabdiꞌizhgal ndab: —¿Xtaꞌan ndab ley mkeꞌa Moisés zha leꞌa dub xabgiꞌi syoꞌo gan ulaꞌa xagots ten na, tal ned usaꞌa xa dub git ndoꞌ xagots, gab‑a leꞌa xa ulaꞌa xa wa? ");
INSERT INTO zpt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Leꞌa Jesús cha ndab: —Geal ngud nak ladoꞌo bega, ta weꞌe mkeꞌa Moisés syoꞌo gan li ulaꞌa bega xagots ten bega. Ná leꞌa zha ned naꞌanpa li ngak‑a. ");
INSERT INTO zpt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Leꞌa naꞌ gáp ndoꞌ bego leꞌa tal ton dub xabgiꞌi ulaꞌa xagots ten na, cha ikaꞌa xa stubga xagots, leꞌa xabgiꞌi wa ndapka ke ndoꞌ Dios. No liga tal stub xabgiꞌi ikaꞌaga xagots wa, leꞌa xa wa no ndap ke ndoꞌ Dios. Ná leꞌa tal ton dub xagots ndap xabgiꞌi ugal stubga xabgiꞌi, leꞌa xabgiꞌi ten xa wa sak ulaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Leꞌa be xmen Jesús cha ndab ndoꞌ Jesús: —Tal li nsabndoꞌ lá ulaꞌa xabgiꞌi xagots ten na, mas wen naꞌanpa ukwaꞌan xa xagots. ");
INSERT INTO zpt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Leꞌa Jesús cha ndab: —Naꞌanpa itea xabgiꞌi uxik lá ukwaꞌan xagots, ndi ncho bexa li msaꞌa Dios nak bexa. ");
INSERT INTO zpt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","No ncho be xabgiꞌi lá ukwaꞌan xagots geal leꞌa zha ndalkata xa lá yoo gan gap xa xin xa leꞌa xa lá utsin nak. No ncho be xabgiꞌi leꞌaka be men li ndazhaꞌa xa. No ncho be xabgiꞌi lá ukwaꞌan xagots ndontsa mas gun xa tiꞌin ten Dios. Leꞌa tal ton bexa na syoꞌo gan li gun, leꞌa bexa nsabndoꞌka li gun ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Weꞌe leꞌa be men ulenno be meꞌed ten na wats Jesús, ndontsa uxoꞌob Jesús yaꞌa na gek be meꞌed, inab xa ulaꞌach Dios be meꞌed. Leꞌa be xmen Jesús cha uteyo bexa nseano be meꞌed wa. ");
INSERT INTO zpt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ná leꞌa Jesús cha ndab ndoꞌ be xmen na: —Blaꞌa bego giꞌid be meꞌed baꞌ wats naꞌ. Lá uka bega giꞌid be meꞌed, leꞌa sa nibeꞌe Dios wa yate bexa yak lak nak be meꞌed ndee. ");
INSERT INTO zpt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cha mxoꞌob xa yaꞌa xa gek be meꞌed wa, weꞌe cha nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Leꞌa dub xabgiꞌi cha ulen wats Jesús unabdiꞌizh xa ndoꞌ xa ndab xa: —Mech wen, ¿xtaꞌan dub ta wen gun naꞌ ndontsa no naꞌ gap gealnaban ndoꞌ Dios, ta nunk lá idub zha? ");
INSERT INTO zpt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Leꞌa Jesús cha ukaꞌab ndab: —¿Xtaꞌan ngi wen ndab lu ndoꞌ naꞌ zha? Naꞌan ton wen ndoꞌ gizhliyo, ndon nabtsa Dios wen nak. Parea tal leꞌa lu nlad gap gealnaban ta nunk lá idub, bxobgek ndoꞌ be ta nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Leꞌa xabgiꞌi wa cha ndab: —¿Xtaꞌanma be ta unibeꞌe Dios gun naꞌ zha? Leꞌa Jesús cha ndab: —Lá gut lu men. Lá ugal lu xa ten stubga men. Lá gun lu gealwaꞌan. Lá gun lu gealkwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wankea xus lu nsea xnaꞌa lu. Bkweaꞌ ladna lu be ltsaꞌa lu lakkata lu. ");
INSERT INTO zpt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Leꞌa xabgiꞌi wa cha ndab: —Iteanak ta ndab go wa ndunka naꞌ idub zha tuzhta naꞌ. ¿Xtaꞌan ndun jwalt gun naꞌ? ");
INSERT INTO zpt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Leꞌa Jesús cha ndab: —Tal lu nlad gak lak nlad Dios, byaꞌ cha bdoꞌo itea be ta ndap lu, cha btseꞌa med wa ndoꞌ bexa uban nak. Weꞌe gap lu sian taꞌa ndoꞌ Dios. Cha utsea usankea tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Leꞌa gor na mbiꞌín xabgiꞌi wa ta wa, cha uban myoꞌo ladna xa, cha nseaꞌ xa, leꞌa xa uzhebpa sian taꞌa ndap. ");
INSERT INTO zpt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Leꞌa Jesús cha ndab ndoꞌ be xmen na: —Leꞌa naꞌ gáp ndoꞌ bega uzheꞌeb ugan yate dub xa rik sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Stub biaj gáp naꞌ‑yá: ndi mas lid bid itid dub came geꞌed xan dub yagux, ndoꞌ yak dub xa rik dub xa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Leꞌa gor na mbiꞌín be xmen Jesús ta wa, cha uzhebpa ngwanseana bexa, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Tonxá syoꞌo gan yate sa nibeꞌe Dios zhaga? ");
INSERT INTO zpt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Leꞌa Jesús cha mwiꞌi ndoꞌ bexa ndab xa: —Leꞌa cuent ten nabtsa be men leꞌa‑yá lá yoo gan. Ná leꞌa cuent ten Dios itea taꞌa syoꞌoka gan. ");
INSERT INTO zpt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Leꞌa Pedr cha ndab ndoꞌ Jesús: —Unaꞌ go, leꞌa besa mlaꞌa itea be taꞌa ndap besa, cha ndi usankea besa tsoꞌo ga. ¿Ta weꞌe xtaꞌan ikaꞌa besa zha? ");
INSERT INTO zpt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Leꞌa Jesús cha ndab ndoꞌ bexa wa: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa gal dub wizh yunchaꞌaw Dios iteanak be taꞌa, zha na leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, isoꞌob wats Dios sa inibeꞌe naꞌ. Leꞌa gal zha wa leꞌa bego nsankea tsoꞌo naꞌ nat noga gap tibtop sa isob bega inibeꞌe bega ndoꞌ isatibtop xkwaꞌa bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Leꞌa tal ton ulaꞌa lid na no wit na no bsan na no xus na no xnaꞌa na no xagots ten na no xmeꞌed na no be yo ten na ndontsa gun xa tiꞌin ten naꞌ, leꞌa xa wa ikayaꞌa stub gayoꞌo biaj mas be ta mlaꞌa xa wa. No gap xa gealnaban ta nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ná kwaꞌad bexa nsak nat wa, yak bexa naꞌanpa nsak; no leꞌa bexa naꞌanpa nsak nat wa, yak bexa nsak. ");
INSERT INTO zpt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Leꞌa lak nibeꞌe Dios nak lak mbin dub xabgiꞌi ndap dub bleꞌa yo ncho ya uv. Utoꞌo xa dub tempran gor nseayat xeꞌa nchaꞌkwaꞌan xa bexa gun tiꞌin ten uv. ");
INSERT INTO zpt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ndab xa ndoꞌ bexa gun tiꞌin wa leꞌa xa kix dub med denario dub wizh, cha unika bexa. Cha mtuꞌub xa bexa ndoꞌ tiꞌin wa. ");
INSERT INTO zpt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cha utoꞌogal xa gor nkea ugeꞌa gor tempran, nchaꞌa xa ndoꞌ xgeꞌe. Weꞌe uniꞌí xa pla xabgiꞌi naꞌan xtiꞌin ndap gun. ");
INSERT INTO zpt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cha ndab xa ndoꞌ bexa wa: “No bega waꞌyun tiꞌin ndoꞌ ya uv ten naꞌ. Leꞌa naꞌ kix dub lak taꞌa nsabndoꞌ ikaꞌa bega.” Leꞌa bexa wa cha nchaꞌaga. ");
INSERT INTO zpt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cha liga utoꞌogal xa gor gawizh no gor nkea yon uzhe, no ligal ndab xa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","No utoꞌogal xa pa gor nkea ugaꞌay uzhe, cha mzheal xa stapla bexa lá ndap tiꞌin gun na. Cha unabdiꞌizh xa ndab xa: “¿Xtaꞌan lndeꞌe nde bega sa ndee idub wizh, ni lá ndun bega tiꞌin?” ");
INSERT INTO zpt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Leꞌa bexa wa cha ndabbe: “Naꞌan ton nsaꞌa tiꞌin gun besa.” Leꞌa xwan geꞌe wa cha ndab: “Waꞌyun bega tiꞌin ndoꞌ ya uv ten naꞌ. Leꞌa naꞌ kix dub lak ta nsabndoꞌ ikaꞌa bega.” ");
INSERT INTO zpt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Leꞌa gor na yá ngwaꞌas wizh, leꞌa xwan tiꞌin wa cha ndab ndoꞌ xa nchansu ndoꞌ tiꞌin wa: “Utezh bexa ndun tiꞌin baꞌ. Cha ndon ned bexa tsoꞌo uyote baꞌ utix ikaꞌa bexa, weꞌeta utix ikaꞌa bexa ned uyote baꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Leꞌa gor nseabe bexa uyote gor nkea ugaꞌay gor uzhe, cha utix xa dub med denario ukaꞌa kadga dub bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Leꞌa tsoꞌo wa gor nseabe bexa ned uyote gor tempran wa, mbinbeꞌe bexa mas sian med ikaꞌa bexa. Ná leꞌa bexa no ukaꞌa dubtsa denario kadga dub bexa. ");
INSERT INTO zpt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Leꞌa gor usen bexa med wa, cha ngokloo bexa ndoꞌ xwan tiꞌin wa, ");
INSERT INTO zpt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ndab bexa ndoꞌ xa: “Leꞌa bexa tsoꞌo uyote mbin tiꞌin baꞌ dub gortsa mbin tiꞌin. Ná go dubtsa utix ukaꞌa bexa baꞌ no besa na mxik uzheꞌeb utii mbin tiꞌin idub wizh.” ");
INSERT INTO zpt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Leꞌa xwan tiꞌin wa cha ndab ndoꞌ dub bexa wa: “Amig, naꞌ naꞌanpa dub ta ugap ndanno lu. ¿Cha lid uni lu ikaꞌa lu dub denario dub wizh zha? ");
INSERT INTO zpt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nat byaꞌ, cha byoꞌo ta ukaꞌa lu baꞌ. Leꞌa naꞌ nlad usa dub lak ta ukaꞌa lu ndoꞌ bexa tsoꞌo uyote baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Lid syoꞌo gan gunno naꞌ med ten naꞌ guniꞌi xteꞌe nlad naꞌ zha? ¿Xtaꞌan ndaklono lu stub xa baꞌ geal leꞌa naꞌ utsin nak ndoꞌ xa?” ");
INSERT INTO zpt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Cha no ndab Jesús: —Li leꞌa kwaꞌad bexa nsak nat wa, yak bexa naꞌanpa nsak; leꞌa bexa naꞌanpa nsak nat wa, yak bexa nsak. Leꞌa Dios nbezh kwaꞌad men, parea naꞌanpa nti Dios kwaꞌad xa. ");
INSERT INTO zpt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Leꞌa gor na nsoꞌ bexa nes nchaꞌa bexa gezh Jerusalén, leꞌa Jesús mbiꞌi isatibtop be xmen na dub lad, cha ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Blaꞌach bego leꞌa beuna nchaꞌbe Jerusalén, leꞌa sa wa leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa be uleꞌay nibeꞌe no be mech ten ley. Leꞌa bexa wa gab nsabndoꞌ gat naꞌ, ");
INSERT INTO zpt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","cha yun bexa cuent naꞌ ndoꞌ bexa naꞌanpa xa judio. Leꞌa bexa wa inisi naꞌ no kin bexa naꞌ no gut bexa naꞌ ndoꞌ cruz. Parea leꞌa gal wizh yon leꞌa naꞌ ibangal ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Weꞌe leꞌa Jacob nsea Juan be xin Zebedeo ulenno xnaꞌa na wats Jesús. Leꞌa xagots wa cha msaxib ndoꞌ Jesús, inab xa dub taꞌa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Leꞌa Jesús cha ndab ndoꞌ xa: —¿Xtaꞌan nlad lu gun naꞌ zha? Leꞌa xa wa cha ndab: —Nlad naꞌ gab go kwe itop xiꞌín naꞌ ndee sa inibeꞌe go, dub xa wats ga lad gaꞌal no stub xa wats ga lad raves. ");
INSERT INTO zpt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Leꞌa Jesús cha ndab ndoꞌ itop bexa wa: —Leꞌa bego ni lá iniꞌí xtaꞌan unab bega. ¿Sxik bega itid bega gealkweaꞌ cuent gealkweaꞌ itiꞌid naꞌ zha? ¿No sni bega gat bega lak gat naꞌ zha? Leꞌa bexa cha ndab: —Snika besa. ");
INSERT INTO zpt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp leꞌa bego stidka be gealkweaꞌ cuent gealkweaꞌ itiꞌid naꞌ, no sat bega lak gat naꞌ. Parea leꞌa sa kwe bega, dub bega wats naꞌ lad gaꞌal no stub bega lad raves wa, leꞌa sa wa naꞌanpa naꞌ inibeꞌe. Leꞌa Dios Xus naꞌ leꞌa gab ná ton kwe sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Leꞌa gor na mbiꞌín isatiꞌi xmen Jesús ta li unab Jacob nsea Juan wa, cha ngokloo bexa. ");
INSERT INTO zpt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Leꞌa Jesús cha utezh bexa wa, cha ndab xa: —Leꞌa bego uniꞌíka leꞌa bexa nibeꞌe be nacion naꞌanpa ulaꞌa gun be men dub taꞌa naꞌanpa nibeꞌe bexa, no bexa mas nsak ten bexa uzhebpa nibeꞌe ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ná leꞌa bego ndee naꞌanpa li nsabndoꞌ gak. Ndi tal ton bega nlad gak dub xa nsak lat bega, leꞌa xa wa nsabndoꞌ gakno iteata bega. ");
INSERT INTO zpt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","No tal ton bega nlad yansu lat bega, leꞌa xa wa nsabndoꞌ gun tiꞌin ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, naꞌanpa ndal por na gun be men tiꞌin ndoꞌ naꞌ. Leꞌa naꞌ ndi ndalyun tiꞌin ndoꞌ be men, no usa naꞌ gealnaban ten naꞌ gat naꞌ kix naꞌ ke ten kwaꞌad men. ");
INSERT INTO zpt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Leꞌa gor nseaꞌ Jesús nsea be xmen na utoꞌo bexa gezh Jericó wa, leꞌa kwaꞌadpa be men nchabenkea tsoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Leꞌa toꞌo nes wa ndebe top xabgiꞌi lá naꞌ. Leꞌa gor na mbiꞌín bexa leꞌa Jesús nseatid sa wa, cha ugeꞌ ndab bexa: —¡Señor, xin David! ¡Blats ladna go besa! ");
INSERT INTO zpt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Leꞌa be men cha uteyo bexa ndontsa naꞌan xteꞌe gab bexa. Ná leꞌa bexa ndi mas ugeꞌ ndab: —¡Señor, xin David! ¡Blats ladna go besa! ");
INSERT INTO zpt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Leꞌa Jesús ngwaꞌisoꞌ utezh itop xa lá naꞌ wa. Cha unabdiꞌizh Jesús ndoꞌ bexa ndab xa: —¿Xtaꞌan nlad bega gunno naꞌ bega? ");
INSERT INTO zpt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Leꞌa bexa wa cha ndab: —Señor, leꞌa besa nlad inaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Weꞌe leꞌa Jesús cha mlats ladna bexa, cha mgal Jesús ngusndoꞌ bexa. Cha bi leꞌa gor wa leꞌa bexa wa mnaꞌlabe. Cha no bexa usankea tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Leꞌa ngol gor na yá nchaꞌlayaꞌ gax Jesús no be xmen xa Jerusalén, ulayaꞌ bexa gezh Betfagé sa nsob Bet Olivo. Leꞌa Jesús cha mtuꞌub top xmen na, ");
INSERT INTO zpt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ndab xa: —Waꞌ bega len gezh nde mas ndoꞌ ndee, cha izheal bega dub burr gots nsoꞌ nchii, no dub xin ma. Cha uxaꞌak bega bema, goꞌo bega ma sa ndee. ");
INSERT INTO zpt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No tal ton uka ma ndoꞌ bega, gud bega leꞌa mech guntiꞌin ma. Cha ulaꞌa xa goꞌo bega ma. ");
INSERT INTO zpt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Li ndab Jesús ndontsa gak‑a lak ndab dub profet sakndoꞌ Dios, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gud bego ndoꞌ bexa gezh Sion: “Bwiꞌi bega, leꞌa xa nibeꞌe ten bega nsea sa ndee. Bchaꞌan nak xa nsob xa tsoꞌo dub burr, tsoꞌo dub burr tuzh, xin dub man yoꞌo.” ");
INSERT INTO zpt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Leꞌa be xmen Jesús wa cha nchaꞌbe, cha mbin bexa lakka unibeꞌe Jesús ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Cha mbiꞌi bexa burr wa nsea burr tuzh wa, cha mtiꞌib bexa dubga xab bexa tsoꞌo ma. Cha usob Jesús tsoꞌo ma. ");
INSERT INTO zpt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Leꞌa kwaꞌad be men cha mte be lad nbix bexa ndoꞌ nes sa itid Jesús, no ncho bexa ulobtoꞌog be xos ya gin, cha mte bexa‑yá nes wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Leꞌa be men nchaꞌbe ned ndoꞌ Jesús no be men nseabenkea tsoꞌo Jesús ugeꞌ ndab: —¡Siꞌil nak xin David! ¡Dios uzhebpa nlaꞌach xa baꞌ, xa na mtuꞌub Dios Xa Nibeꞌe! ¡Siꞌil nak Dios nsob gaꞌap! ");
INSERT INTO zpt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Leꞌa gor na uyote Jesús len gezh Jerusalén, leꞌa iteanak be men usaxan ndeseyoch, unabdiꞌizh bexa ndab bexa: —¿Ton xa baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Leꞌa be men ndeseano Jesús wa cha ndab: —Leꞌa xa ndee Jesús, xa ndadiꞌizh sakndoꞌ Dios, xa gezh Nazaret ten Galilea. ");
INSERT INTO zpt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Leꞌa Jesús cha nchaꞌa len niꞌi ten Dios, cha ulantuꞌub xa bexa nadoꞌotiꞌix taꞌa sa wa. No mtixte xa be mes ten bexa ntil be med, no be yaxil ten bexa ndiꞌibudoꞌo be palom. ");
INSERT INTO zpt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cha ndab xa ndoꞌ bexa wa: —Leꞌa diꞌizh ten Dios nkeaniꞌi ndab Dios: “Leꞌa lid naꞌ isaleaꞌ dub sa ndadiꞌizhno be men naꞌ.” Ná leꞌa bego ndi ndanno‑yá cuent dub geꞌloꞌo ten be waꞌan. ");
INSERT INTO zpt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Weꞌe leꞌa pla bexa lá naꞌ no bexa coj cha ulen wats Jesús tale ten niꞌi ten Dios wa, cha myunyakna Jesús bexa. ");
INSERT INTO zpt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Parea leꞌa be uleꞌay nibeꞌe no be mech ten ley uzheꞌeb ngokloo gor uniꞌí bexa be uyon ndun Jesús wa, no mbiꞌín bexa ta ugeꞌ ndab be meꞌed tale ten niꞌi ten Dios, ndab meꞌed: “¡Siꞌil nak xin David!” ");
INSERT INTO zpt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Cha ndab bexa ndoꞌ Jesús: —¿Lid ndoꞌón lu xtaꞌan ndab be meꞌed baꞌ zha? Leꞌa Jesús cha ukaꞌab ndab: —Naꞌ ndónka‑yá. ¿Parea lá ndoꞌol bega zha sa nkeaniꞌi diꞌizh ten Dios cuent ten ta ndee? Ndab‑a: Leꞌa go Dios gun leꞌa be meꞌed nsea be medoꞌo gab xteꞌe siꞌil nak go. ");
INSERT INTO zpt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Leꞌa Jesús cha mlaꞌa bexa mkaꞌan xa gezh Jerusalén. Cha nchaꞌa xa gezh Betania, sa uyoꞌo xa teꞌal wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Leꞌa stub wizh gor tempran myach xa nchaꞌa xa Jerusalén. Leꞌa nes wa leꞌa Jesús ndanna. ");
INSERT INTO zpt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Weꞌe uniꞌí xa dub ya higo gax toꞌo nes wa, cha nchaꞌkwaꞌan xa ngus gaw xa ndoꞌ ya wa. Parea naꞌanpa izheal xa ngus ndoꞌ‑yá, ndi latsa nsoꞌ ndoꞌ‑yá. Cha ndab Jesús ndoꞌ ya wa: —Idub isob lu naꞌantapa isoꞌ ngus ndoꞌ lu. Leꞌa ya higo wa cha ubid. ");
INSERT INTO zpt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Leꞌa gor uniꞌí be xmen Jesús ta wa cha ngwanseana bexa, unabdiꞌizh bexa ndoꞌ Jesús, ndab bexa: —¿Xteꞌe uxax ubid ya higo baꞌ? ");
INSERT INTO zpt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa tal bega idub ncho ladna ngeꞌ ladna Dios, leꞌa bega sun gan gun lak mbinno naꞌ ya higo ndee, no sun bega gan gab bega ndoꞌ bet ndee: “Utatsob, waꞌ len nitsdoꞌo”, leꞌa‑yá cha lika gak. ");
INSERT INTO zpt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Leꞌa itea be ta inab bega ndoꞌ Dios tal ngeꞌka ladna bega xa, leꞌa Dios saꞌaka‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Leꞌa gor na mlanseagal Jesús wats niꞌi ten Dios, cha usaxan xa nluu xa be men. Weꞌe leꞌa be uleꞌay nibeꞌe no bexa gox nsak ten bexa judio ulen wats Jesús, ndab bexa: —¿Ton ulaxoꞌob lu gun lu be ta wa zha? ¿Nati ton mtuꞌub lu gun lu ta wa? ");
INSERT INTO zpt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ no inabdiꞌizh dub taꞌa ndoꞌ bego. Tal leꞌa bega ikaꞌab, weꞌe no naꞌ gáp ná ton ulaxoꞌob naꞌ li gun naꞌ ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ton mtuꞌub Juan ulaleaꞌ Juan be men zha? ¿Dios nati dub men? Leꞌa bexa wa cha ndabbe ndoꞌ ltsaꞌa na: —Tal leꞌa beuna gab leꞌa Dios leꞌaka mtuꞌub Juan, leꞌa Jesús inabdiꞌizh ná xtaꞌan lá ngungea ladna beuna xa. ");
INSERT INTO zpt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ná tal leꞌa beuna gab leꞌa Juan dub men mtuꞌub, leꞌa be men ndee sakloo ndoꞌ beuna, leꞌa bexa itea mbingea ladna leꞌa Juan dub xa mbidiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Cha ndab bexa ndoꞌ Jesús: —Leꞌa besa lá iniꞌí ton mtuꞌub Juan. Leꞌa Jesús cha noga ndab: —Ni naꞌga lá gáp ton ulaxoꞌob naꞌ gun naꞌ be ta ndee. ");
INSERT INTO zpt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Leꞌa Jesús cha unabdiꞌizh ndoꞌ bexa wa ndab xa: —¿Xteꞌe nyakbeꞌena bega ta gáp naꞌ ndee wa? Uyoꞌo dub xabgiꞌi ndap top xin na. Cha ngwaꞌ xa ndoꞌ xin ned xa, ndab xa: “Xiꞌín naꞌ, waꞌyun tiꞌin ndoꞌ yo ten naꞌ sa ncho ya uv.” ");
INSERT INTO zpt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Leꞌa xin xa wa cha ukaꞌab ndab: “Naꞌ lá nlad gaa.” Parea tsoꞌo wa leꞌa xa mgondoꞌ leꞌa xa ugap ndab, cha nchaꞌaka xa ndoꞌ tiꞌin wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Leꞌa xabgiꞌi wa no ngwaꞌ ndoꞌ stubga xin na wa, cha leꞌakagal li ndab xa ndoꞌ xin xa. Leꞌa xin xa wa cha ukaꞌab ndab: “Leꞌa naꞌ saaka, tad.” Ná leꞌa xa ndi ni lá nga. ");
INSERT INTO zpt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ton ndoꞌ itop xa wa mbin ta nlad xus na zha? Leꞌa bexa wa cha ndab: —Xin ned xa. Leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa bexa nsen med nkaꞌa gobier Roma no be xagots ndun juis mgiꞌi nadoꞌo bexa las bexa, leꞌa ncho bexa wa syoteka sa nibeꞌe Dios. Ná leꞌa bego lá yate sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Leꞌa Juan xa ulaleaꞌ men mbidyadiꞌizh xteꞌe nsabndoꞌ wen gun bega, ná leꞌa bega ni lá ngungea ladna xa. Ná leꞌa bexa nsen med wa no be xagots ndun juis mgiꞌi wa mbingea ladna Juan. Leꞌa bego uniꞌí leꞌa bexa wa mbingea ladna Juan, ná leꞌa bega ni lá igondoꞌ ti no bega nsabndoꞌ gungea ladna xa. ");
INSERT INTO zpt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Blaꞌach bega stub taꞌa usaktabeꞌe naꞌ: Uyoꞌo dub xabgiꞌi ndap dub bleꞌa siꞌil yo. Cha ngos xa ya uv ndoꞌ‑yá, cha ulo xa lo idub gangeak wats‑a. No mbindeꞌe xa dub sa kichkeꞌe xa uv wa, koꞌo xa nits ten uv. No mbindeꞌe xa dub sa gaꞌap isob xa ulaꞌach sa wa. Cha mkwaꞌan xa pla men gun tiꞌin sa wa. Cha nchaꞌa xa sit. ");
INSERT INTO zpt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Leꞌa zha na yamer ngol tiemp ten uv wa, cha mtuꞌub xa pla xmos xa yaꞌ ndoꞌ be men wa, yaꞌyoꞌo bexa ta na ndal xwan yo wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ná leꞌa be men wa ndi usen be mos wa, udin bexa dub xa, cha mbit bexa stub xa, cha mlaꞌgeꞌ bexa stub xa. ");
INSERT INTO zpt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Leꞌa xwan yo wa cha mtuꞌubgal mas kwaꞌad mos ndoꞌ zha ned wa. Ná leꞌa be men wa ligal mbinno bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tsoꞌo wa leꞌa xwan yo wa mtuꞌub xin na, mbinbeꞌe xa leꞌa be men gap mod ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ná leꞌa gor uniꞌí be men wa xin xwan yo wa, cha ndi ndab bexa ndoꞌ ltsaꞌa na: “Leꞌa xa baꞌ leꞌa yaꞌanno yo ndee. Nchaꞌyut beuna xa, cha yaꞌanno beuna‑yá.” ");
INSERT INTO zpt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Cha usen bexa xa, cha uloꞌo bexa xa dub lad toꞌo yo wa, cha mbit bexa xa. ");
INSERT INTO zpt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cha unabdiꞌizh Jesús ndoꞌ be men nde wats xa ndab xa: —¿Xteꞌe nsak bega zha? ¿Leꞌa gor giꞌid xwan yo wa xteꞌe gunno xa bexa mlaꞌach yo wa? ");
INSERT INTO zpt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Leꞌa bexa cha ndab: —Leꞌa xa utsaksika bexa ugap wa gast gat bexa. Cha usaꞌa xa yo wa ndoꞌ be men xaꞌaga ulaꞌach‑a, bexa na usaꞌa be ta ndal xwan yo wa gal tiemp ten uv wa. ");
INSERT INTO zpt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Weꞌe leꞌa Jesús cha ndab ndoꞌ bexa: —¿Ni lá ndoꞌol bega diꞌizh ten Dios zha? Ndab‑a: Leꞌa geꞌ na mxelad bexa ndandeꞌe niꞌi, leꞌa ta wa nat nak geꞌ ndon leꞌa nsak nbexan niꞌi. Leꞌa Dios leꞌa mbin ta ndee, dub ta ndanseana beuna. ");
INSERT INTO zpt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ta weꞌe leꞌa naꞌ gáp leꞌa Dios ulat ta na nak bega xmen xa, cha ndi usaꞌa Dios ta wa ndoꞌ bexa nxobgek ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Leꞌa bexa na ilayat tsoꞌo geꞌ wa, leꞌa bexa wa syuꞌbe. Leꞌa bexa ilaꞌ geꞌ wa tsoꞌo na wa, leꞌa bexa wa sachkeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Leꞌa gor na mbiꞌín be uleꞌay nibeꞌe nsea bexa fariseo wa be ta li msaktabeꞌe Jesús wa, cha myakbeꞌena bexa leꞌa Jesús li ndab cuent ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Cha nlad bexa isen bexa Jesús, parea leꞌa bexa nzheb ndoꞌ be men kwaꞌad, leꞌa be men ndangea ladna leꞌa Jesús ndadiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Cha msaktabeꞌe Jesús stub taꞌa, ndab xa ndoꞌ bexa wa: ");
INSERT INTO zpt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Leꞌa lak nibeꞌe Dios be men nak lak mbin dub rey ngo dub ujest nchilyaꞌa dub xin xa. ");
INSERT INTO zpt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Cha mtuꞌub xa be mos ten xa nchaꞌyab ndoꞌ be men ulola rey kombid ndoꞌ bexa wa giꞌid bexa ujest wa. Ná leꞌa be men lá kaꞌab yaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Weꞌe cha mtuꞌubgal xa stapla mos ten xa, ndab xa ndoꞌ bexa: “Waꞌyab bega ndoꞌ bexa wa, leꞌa be ta gaw beuna yá listla nak. Leꞌa be ngon nsea be bser ndaꞌal ten naꞌ yá ngutla. No iteata be taꞌa listla nak. Nat giꞌid bexa ujest nchilyaꞌa xiꞌín naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ná leꞌa bexa wa ni lá isakyoꞌón be ta ndab be mos wa. Ncho bexa nchaꞌa geꞌe ten na, no ncho xa nchaꞌbe ndoꞌ tiꞌin ten na. ");
INSERT INTO zpt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","No ncho bexa usen be mos ten rey wa, mtsawiꞌi bexa be mos wa gast ngut bexa. ");
INSERT INTO zpt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Leꞌa gor na mbiꞌín rey ta wa cha ngokloo xa, cha mtuꞌub xa be soldad ten xa yaꞌyut bexa be men na li mbit be mos wa no utsoꞌol be soldad gezh ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Cha ndab rey ndoꞌ be mos ten na: “Leꞌa ujest uchilyaꞌa xiꞌín naꞌ yá listla nak. Parea leꞌa bexa uyoꞌo kombid ndoꞌ na wa lá nsabndoꞌ giꞌid. ");
INSERT INTO zpt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nat waꞌ bega be nes, cha gab bega ndoꞌ guniꞌi ton izheꞌal bega giꞌid xa ujest.” ");
INSERT INTO zpt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Leꞌa be mos cha utoꞌo ngwaꞌkesea be nes, cha myunjunt bexa iteanak be men mzheꞌal bexa, bexa wen no bexa ugap. Weꞌe leꞌa sa ncho ujest wa mzhea nde be men wa. ");
INSERT INTO zpt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Leꞌa rey cha nsea iwiꞌi ndoꞌ bexa nde sa wa. Cha uniꞌí xa dub xabgiꞌi naꞌanpa nak lad nsabndoꞌ gak bexa dub sa nchilyaꞌa men. ");
INSERT INTO zpt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Leꞌa rey wa cha ndab ndoꞌ xa: “Amig, ¿xteꞌe uyoꞌo lu sa ndee, ná lu naꞌanpa nak lad ndak bexa nde sa ndee, sa nchilyaꞌa men zha?” Ná leꞌa xabgiꞌi wa ni lá ikaꞌab ndoꞌ rey. ");
INSERT INTO zpt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Leꞌa rey cha ndab ndoꞌ be mos ten na: “Bxi bega xoꞌo xa ndee no yaꞌa xa, cha btsaꞌab bega xa tsoꞌo juer sa ukaw, sa goꞌon xa no gast ndeay xa gaw xa tant dub gealkweaꞌ siꞌil iniꞌí xa.” ");
INSERT INTO zpt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Cha no ndab Jesús: —Liga leꞌa Dios nbezh kwaꞌad men, parea naꞌanpa uti Dios itea be men. ");
INSERT INTO zpt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Leꞌa bexa fariseo cha nseaꞌbe, cha mbidiꞌizh bexa ná xteꞌe ukwiꞌinno bexa Jesús gab Jesús dub ta lid leꞌa nak. ");
INSERT INTO zpt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Cha mtuꞌub bexa pla be xmen bexa no stapla be xmen Herodes wats Jesús. Leꞌa bexa cha unabdiꞌizh ndoꞌ Jesús, ndab bexa: —Mech, leꞌa besa uniꞌí leꞌa go ndadiꞌizh sbeꞌen gealngea no wen nluu ga lak nlad Dios gak be men, ni lá nlaꞌach ga ta ndab be men no ni tal xteꞌe nak bexa. ");
INSERT INTO zpt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nat gud ga ná xteꞌe nsak ga: ¿Nsabndoꞌ kix beuna med nab César xa nibeꞌe Roma nate naꞌanpa kix beuna‑yá? ");
INSERT INTO zpt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ná leꞌa Jesús mgenna ta ugap ndanbeꞌe bexa, cha ndab Jesús: —Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. ¿Xtaꞌan li ndun bega preb naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bluu bega dub med nkix be men ndoꞌ xa nibeꞌe wa. Weꞌe cha msaꞌa bexa dub med denario. ");
INSERT INTO zpt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Leꞌa Jesús cha unabdiꞌizh ndoꞌ bexa: —¿Ton gek ná no leaꞌ ná nkea las med ndee zha? ");
INSERT INTO zpt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Leꞌa bexa cha ukaꞌab ndab: —Gek César no leaꞌ César. Leꞌa Jesús cha ndab: —Bsaꞌa bega be ta ten César ndoꞌ César. Leꞌa ndoꞌ Dios bsaꞌa bega be ta ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Leꞌa gor na mbiꞌín bexa ta wa, cha ngwanseana bexa xteꞌe ukaꞌab Jesús, cha nchaꞌa bexa mlaꞌa bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bi leꞌa wizh wa leꞌa pla bexa saduceo ulen wats Jesús. Leꞌa bexa saduceo ndangea ladna leꞌa bexa ngut wa lá ibantabe. Cha unabdiꞌizh bexa ndoꞌ Jesús, ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mech, leꞌa ta mkeꞌa Moisés ndab leꞌa tal ton dub xabgiꞌi gat, ná lá ngap xa xin xa, leꞌa wit xa wa nsabndoꞌ uchilyaꞌano xagots ten xa ngut wa, ndontsa tal gap bexa dub meꞌed leꞌa meꞌed wa gak cuent xin xa ngut wa. ");
INSERT INTO zpt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Leꞌa sa ndee uyoꞌo dub gaꞌad wit xa. Leꞌa xa ned wa mchilyaꞌano dub xagots, cha tsoꞌo wa ngut xa, ni lá ngap xagots wa xin xa. Weꞌe leꞌa stubga wit xa cha mchilyaꞌano xagots wa. ");
INSERT INTO zpt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cha li ngwasea wit itop xa no xa yon wa no gast isagaꞌad bexa. ");
INSERT INTO zpt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Leꞌa tsoꞌo na ngut itea be xabgiꞌi wa leꞌa xagots wa noga ngut. ");
INSERT INTO zpt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Leꞌa zha na iban bexa ngut wa, leꞌa lat isagaꞌad bexa wa ¿ton gak xabgiꞌi ten xagots wa, xa na li mchilyaꞌano itea be xabgiꞌi wa? ");
INSERT INTO zpt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Leꞌa Jesús cha ukaꞌab ndab: —Uzhebpa lid leꞌa ndanbeꞌe bega, geal leꞌa bega lá nyakbeꞌena xteꞌe ndab diꞌizh ten Dios, no ni lá nchandoꞌ bega juers ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Leꞌa gal zha na iban bexa ngut, leꞌa be men naꞌantapa uchilyaꞌano be ltsaꞌa na zha wa. Leꞌa bexa ndi yak cuent be angel ten Dios ncho gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Parea leꞌa cuent ten ta iban bexa ngut wa, ¿lá ndoꞌol bega diꞌizh ten Dios ta ndab Dios zha? Ndab xa, ");
INSERT INTO zpt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","leꞌa xa nak Dios ndankea Abraham no Isaac no Jacob. Leꞌa Dios naꞌanpa Dios ten bexa ngut, leꞌa xa ndi Dios ten bexa nban, ta weꞌe uniꞌí beuna leꞌa bexa wa bi nbanka maska ngut bexa ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Leꞌa gor na mbiꞌín be men ta wa, cha ngwanseana bexa xteꞌe ndadiꞌizh Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Leꞌa bexa fariseo, gor na mbiꞌín bexa leꞌa Jesús mbin gan yá lá utsakndoꞌta bexa saduceo wa, cha mzhealbe bexa wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Leꞌa dub bexa wa xa nak mech ten ley mbin preb Jesús, unabdiꞌizh xa ndab xa ndoꞌ Jesús: ");
INSERT INTO zpt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mech, ¿ma ta na mas nsak lat be ta unibeꞌe Dios zha? ");
INSERT INTO zpt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Leꞌa Jesús cha ukaꞌab ndab: —Wankea Dios Xa Nibeꞌe idub ncho ladna ladoꞌo lu no idub gealnaban ten lu no idub lak ndanbeꞌe lu. ");
INSERT INTO zpt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Leꞌa ná ndee wa mas nsak ndoꞌ iteanak be taꞌa unibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Leꞌa ná itop ndee lakkaga nak ná ned wa: Bkweaꞌ ladna lu be ltsaꞌa lu lakkata lu. ");
INSERT INTO zpt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Leꞌa itop be ná ndee wa nak xan iteanak be ta unibeꞌe Dios, ley mkeꞌa Moisés nsea ta mkeꞌa be profet. ");
INSERT INTO zpt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndalen li ndebe bexa fariseo sa wa, leꞌa Jesús unabdiꞌizh ndoꞌ bexa, ");
INSERT INTO zpt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ndab xa: —¿Xteꞌe ndanbeꞌe bega zha ton nak Cristo xa utuꞌub Dios, xá ras ná xa? Leꞌa bexa wa cha ukaꞌab ndab: —Leꞌa xa wa gak dub xa ras ten David. ");
INSERT INTO zpt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Weꞌe leꞌa Jesús cha ndab: —Ta ugeaka ta wa, ná leꞌa David leꞌaka ndab sakndoꞌ Espíritu ten Dios leꞌa Cristo nak xa nibeꞌe ten xa. Ndab David: ");
INSERT INTO zpt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Leꞌa Dios Xa Nibeꞌe ndab ndoꞌ Xa Nibeꞌe ten naꞌ: “Usob wats naꞌ lad gaꞌal ndee, gast gal gor ute naꞌ bexa ndaklono lu xan ndats lu.” ");
INSERT INTO zpt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Leꞌa David ndab leꞌa Cristo nak Xa Nibeꞌe ten xa. ¿Ná xteꞌe yoo gan gak Cristo wa xin David zha? ");
INSERT INTO zpt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Leꞌa ni dub bexa wa lá ikaꞌab ni stub diꞌizh. No idub tsoꞌo wa ni lá ngun bexa rages inabdiꞌizhta bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Leꞌa Jesús cha mbidiꞌizh ndoꞌ be men no ndoꞌ be xmenka xa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Leꞌa be mech ten ley no bexa fariseo nak bexa nsabndoꞌ leꞌa uluu xteꞌe gab ley mkeꞌa Moisés. ");
INSERT INTO zpt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ta weꞌe blaꞌach bega xtaꞌan ndab bexa no bxobgek bega ndoꞌ be ta nluu bexa. Parea lá gun bega lak ndun bexa wa, leꞌa bexa naꞌanpa ndun ta ndab bexa gun bega. ");
INSERT INTO zpt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Leꞌa be ta sian nluu bexa wa nak cuent dub yoꞌo uzheꞌeb kweꞌa nsaꞌa bexa goꞌo bega. Parea ni dub ngutsyaꞌa xa lá ndakno bexa bega goꞌo bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Leꞌa iteanak ta wen ndun bexa, li ndun bexa ndontsa iniꞌí be men‑a. Ndal ladna bexa nkeꞌa be caj byux xtuzh bexa no yaꞌa bexa, ta ncho git tuzh nkea diꞌizh ten Dios len‑a. No ndal ladna bexa ndak bexa be lad nsob be ta koꞌol toꞌo‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","No nti bexa be sa mas nsak isob bexa sa ndaꞌdaw bexa ndoꞌ dub gast, no len be niꞌi nzhealbe beuna xa judio. ");
INSERT INTO zpt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","No nlad bexa utsin inidiꞌizh be men ndoꞌ bexa be ndoꞌ xgeꞌe, gab be men “mech” ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ná leꞌa bega naꞌanpa ukwaꞌan xteꞌe gab be men “mech” ndoꞌ bega, leꞌa bega dubkama mech ndap leꞌa ta wa xa nak Cristo. No leꞌa itea bega dubtsa nak. ");
INSERT INTO zpt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","No naꞌan ton ndoꞌ ná gab bega “tad” ndoꞌ gizhliyo ndee, leꞌa bega dubtsa tad ndap leꞌa ta wa Dios nsob gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","No lá ulaꞌa bega gab be men leꞌa bega xa nibeꞌe, leꞌa xa nibeꞌe dubtsa ncho, leꞌa ta wa xa nak Cristo. ");
INSERT INTO zpt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Leꞌa tal ton mas nsak lat bega, leꞌa xa wa nsabndoꞌ gun tiꞌin ndoꞌ iteanak bega. ");
INSERT INTO zpt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Leꞌa tal ton gunbeꞌe leꞌa mas nsak, leꞌa gal gor leꞌa xa ido ladna. No liga leꞌa tal ton yak tuzh ndoꞌ be men, leꞌa gal gor leꞌa be men iniꞌí leꞌa xa wa nsakka. ");
INSERT INTO zpt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Nka bega yak be men bexa leꞌa Dios nibeꞌe. Ni leꞌa bego nak bexa leꞌa Dios nibeꞌe, no ni lá nlaꞌa bega gak be men xa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Nlat bega itea be ta ndap be xagots ngut xabgiꞌi ten na. No kwenpa ndadiꞌizh bega ndoꞌ Dios ndontsa gab be men leꞌa bega ndankeaka Dios. Leꞌa bego na li ndun wa mas uzheꞌeb gealkweaꞌ iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Leꞌa bega ndesea itea lad ndoꞌ gizhliyo no ndoꞌ nitsdoꞌo, ndeseakwaꞌan bega be men gungea ladna be ta nluu bega. Ná leꞌa gor mbin bega gan ndangea ladna dub xa ta wa, leꞌa ke ten ta mluu bega ndoꞌ xa wa leꞌa xa mas nsabndoꞌ yaꞌ infierno ndoꞌ lak nsabndoꞌ yaꞌ bego. ");
INSERT INTO zpt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Proꞌob bego, leꞌa bego cuent dub xa lá naꞌ nlad goꞌo stubga men! Leꞌa bega ndab leꞌa tal ton gab lak ta ugeakapa ncho niꞌi ten Dios no liga ta ugeakapa gun xa dub taꞌa, leꞌa xa wa naꞌanpa juerska li gun. Parea no ndab bega tal xa gab lak ta ugeakapa ncho ta oro len niꞌi ten Dios, weꞌe leꞌa xa wa juerska li gun ta ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ugap ndanbeꞌe bego, nak bego cuent dub xa lá naꞌ! ¿Xtaꞌan mas nsak zha? ¿Be ta oro wa nate niꞌi ten Dios, ta na ndun umbiꞌi nak oro wa ndoꞌ Dios? ");
INSERT INTO zpt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","No ndab bega leꞌa tal ton gab lak ta ugeakapa ncho altar wa, no liga ta ugeakapa gun xa dub taꞌa, leꞌa xa wa naꞌanpa juerska li gun. Parea no ndab bega tal xa gab lak ta ugeakapa ncho be xnab, weꞌe leꞌa xa wa juerska li gun ta ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ugap ndanbeꞌe bega no nak bega cuent dub xa lá naꞌ! ¿Xtaꞌan mas nsak zha? ¿Xnab wa nate altar wa, ta na ndun umbiꞌi nak xnab wa ndoꞌ Dios? ");
INSERT INTO zpt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Leꞌa tal ton nseꞌat altar wa gor na ndab xa gun xa dub taꞌa, leꞌa ta wa cuent no be xnab ndiꞌib ndoꞌ altar wa nseꞌat xa. ");
INSERT INTO zpt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","No tal ton nseꞌat niꞌi ten Dios gor na ndab xa gun xa dub taꞌa, leꞌa ta wa cuent no Dios xa ncho sa wa nseꞌat xa. ");
INSERT INTO zpt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","No tal ton nseꞌat gibeꞌa gor na ndab xa gun xa dub taꞌa, leꞌa ta wa cuent no sa nsob Dios nsea Dios nseꞌat xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Leꞌaka nak nsaꞌa bega dub gen byonxtil lat dub tiꞌi gen‑a uxen bega, no liga ndanno bega eneldo no komin. Parea leꞌa bega lá ndun be ta mas nsak nibeꞌe ley ten Dios, ta na ndab utsin gunno bega be men lak nsabndoꞌ‑yá no ilats ladna bega be men, no igeꞌ ladna bega Dios. Be ta wen ndee nsabndoꞌ gun bega no usaꞌaka bega be ta wa lakka ndun bega nat. ");
INSERT INTO zpt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Leꞌa bega cuent dub xa lá naꞌ nlad goꞌo stubga men. Nyuꞌ ladna bega be ta byuxtsa, ná leꞌa ta mas nsak nlaꞌa bega, cuent dub men ngoꞌo dub mlat ncho len tas, parea ndi ngab xa dub came. ");
INSERT INTO zpt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Leꞌa bega uzhebpa nyuꞌ ladna nyat tsoꞌo vas nsea plat, parea leꞌa len ladoꞌo bega uzhebpa ugap nak, no uzhebpa nsaꞌab ladna bega be taꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Bego xa fariseo nak cuent dub xa lá naꞌ! Ndi ned isambiꞌi len ladoꞌo bega, weꞌeta umbiꞌi gak idub bega. ");
INSERT INTO zpt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Leꞌa bega nak cuent dub baꞌa nagud chulpa nluꞌu tsoꞌo‑yá. Ná leꞌa len‑a ndi ncho tit men ngut no uzhebpa ta bzhiꞌik. ");
INSERT INTO zpt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Li nak bego, ndab be men leꞌa bega xa wen, parea leꞌa len ladoꞌo bega uzhebpa ncho gealkwiꞌin no sianta be ta ugap. ");
INSERT INTO zpt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Proꞌob bego, mech ten ley no xa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap nak. Leꞌa bega ndanchaꞌaw ta chul nsob sa mgaꞌach bexa mbidiꞌizh sakndoꞌ Dios tiemp polta no nsaxkwaꞌa bega be baꞌa ten bexa mxobgek ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","No ndab bega tal leꞌa bega yoꞌo zha uyoꞌo bexa polta wa, naꞌanpa no bega ngakno be men wa gor na mbit bexa be profet. ");
INSERT INTO zpt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Parea leꞌa ta li ndab bega wa nluu leꞌa bega dubtsa nakka no bexa na li mbit bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Bego usandoꞌ be ta ugap mbin be usan gox ten bega polta! ");
INSERT INTO zpt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Leꞌa bego xa ugap cuent be mbeꞌal! ¿Xteꞌe ni bega naꞌanpa utsaksi Dios bega, utsaꞌab xa bega ndoꞌ infierno sa nde giꞌ? ");
INSERT INTO zpt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Leꞌa naꞌ utuꞌubkata bexa gudiꞌizh sakndoꞌ Dios, no bexa ndák, no be mech uluu bega. Ná leꞌa bega ndi gut ncho bexa ukeꞌa bega bexa wa ndoꞌ cruz. No kin bega ncho bexa len be niꞌi sa nzhealbe beuna xa judio. No isankea bega tsoꞌo bexa guniꞌi tal pa gezh na nchaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta weꞌe leꞌa bega gap ke ten itea bexa ugap li ndut be men wen. Leꞌa ta wa gast zha ngut Abel no gast zha ngut Zacarías xin Berequías, gor na mbit usan gox polta ten bega xa wats altar dub lad wats niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Leꞌa naꞌ gáp ndoꞌ bega leꞌa Dios utsaksi bego ncho nat ke ten iteanak be ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Leꞌa bego ndencho Jerusalén, leꞌa bega ndut bexa ndadiꞌizh sakndoꞌ Dios no nlaꞌgeꞌ bega bexa na ntuꞌub Dios ndoꞌ bega. Sian biaj nlad naꞌ yunjunt naꞌ bega lak nyunjunt dub ngidtsan be ngid ben ten ma len xkwag ma, parea leꞌa bega nunk lá kaꞌab. ");
INSERT INTO zpt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Blaꞌach bego, leꞌa nat leꞌa Dios ulaꞌalad bega. ");
INSERT INTO zpt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","No gáp naꞌ ndoꞌ bega leꞌa bega yá naꞌantapa iniꞌí naꞌ gast gal wizh gab bega: “Dios uzhebpa nlaꞌach xa baꞌ, xa na mtuꞌub Dios Xa Nibeꞌe.” ");
INSERT INTO zpt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Leꞌa Jesús cha utoꞌo tale ten niꞌi ten Dios, cha nseaꞌ xa. Leꞌa be xmen xa cha ubii wats xa mluu bexa ndoꞌ xa xteꞌe ta chul nakchaꞌaw niꞌi ten Dios wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Leꞌa Jesús cha ukaꞌab ndab: —¿Naꞌ bego itea ta ndee zha? Leꞌa naꞌ gáp ndoꞌ bega leꞌa gal dub wizh ilate iteanak be ta baꞌ, gast ni stub geꞌ baꞌ lá kwiꞌibta tsoꞌo ltsaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cha nchaꞌbe bexa Bet Olivo, cha usob Jesús sa wa. Leꞌa be xmen xa cha nabtsa ubii wats xa, cha unabdiꞌizh bexa ndab bexa: —Gud ga, ¿pol gak be ta ndab go wa zha? ¿No xteꞌe iniꞌí besa zha na yamer ilengal ga, no zha yamer idub tiemp ndee? ");
INSERT INTO zpt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Leꞌa Jesús cha ukaꞌab ndab: —Blaꞌach bego naꞌan ton ukwiꞌinno bega. ");
INSERT INTO zpt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Leꞌa kwaꞌad be men ilen gab leꞌa xa leꞌa nak naꞌ. Gab xa leꞌa xa leꞌa nak Cristo xa na mtuꞌub Dios; cha ukedino bexa kwaꞌad be men. ");
INSERT INTO zpt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Leꞌa gor na goꞌón bega ncho guerr be sa sit no sa gax, lá yuꞌ ladna bega. Leꞌa ta wa nsabndoꞌka yoo, ná leꞌa zha wa biseata gal be wizh lult. ");
INSERT INTO zpt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Leꞌa gal zha wa kuyo be nacion no stubga nacion. Leꞌa be xmen dub xa nibeꞌe kuyono be xmen stubga xa nibeꞌe. No yoo gealgizh ugiꞌi no win no be xoꞌo ubiꞌi. ");
INSERT INTO zpt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Parea leꞌa itea be ta ndee wa pen isobxanma be gealkweaꞌ ilen wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Leꞌa be men yun cuent bega ndoꞌ bexa nibeꞌe. Leꞌa bexa wa kin bega no gast gut bexa ncho bega. No iteanak be men ixeeno ladna bega ke na nak bega xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Leꞌa kwaꞌad bexa ulaꞌa ta na ndangea ladna bexa naꞌ. No yun bexa cuent be ltsaꞌa xa ndoꞌ men utsaksi bexa. No ixeeno ladna bexa be ltsaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","No ilen kwaꞌad bexa ukwiꞌin gab leꞌa xa ndadiꞌizh sakndoꞌ Dios. Leꞌa bexa wa gun gan ukedino kwaꞌadpa be men. ");
INSERT INTO zpt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","No gun be men sianpa be ta ugap, gast kwaꞌadpa bexa yá lá ikweaꞌta ladna be ltsaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ná leꞌa tal ton uxik ndoꞌ be gealkweaꞌ wa no bi ngeꞌ ladna xa naꞌ, leꞌa xa wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Leꞌa diꞌizh wen ten Dios ná xteꞌe nibeꞌe Dios be men wa iteꞌachso idub nax ndoꞌ gizhliyo, ndontsa leꞌa iteanak be men goꞌón‑a. Weꞌeta ilen be wizh lult. ");
INSERT INTO zpt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Leꞌa Daniel xa mbidiꞌizh sakndoꞌ Dios ndab leꞌa yoo dub ta uzhebpa ugap no bzhiꞌik len sa umbiꞌi ten niꞌi ten Dios (leꞌa xa ndoꞌol ta ndee nsabndoꞌ yakbeꞌena‑yá). Leꞌa gal zha iniꞌí bega ta wa, ");
INSERT INTO zpt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","weꞌe leꞌa bexa ndencho Judea ndee nsabndoꞌ uxoꞌonbe yaꞌbe bexa be geꞌe ubiꞌi. ");
INSERT INTO zpt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Leꞌa be men ndiꞌib gek lid na wa no nsabndoꞌ uxoꞌonbe, ni lá koꞌo xa be taꞌa len lid xa. ");
INSERT INTO zpt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Leꞌa bexa ndeyun tiꞌin geꞌe ni lá nsabndoꞌ yachta ilenyoꞌo be xab na. ");
INSERT INTO zpt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Leꞌa gal be wizh wa uzhebpa kweaꞌ itid be xagots nsoꞌno meꞌed no be xagots ndap medoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Unab bega ndoꞌ Dios natsa leꞌa tiemp uxoꞌon bega wa naꞌanpa gal tiemp kwal natal dub wizh neꞌe be men. ");
INSERT INTO zpt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Leꞌa be wizh weꞌe yoo dub gealkweaꞌ siꞌil, dub ta nunk gol yoꞌo zha mbindeꞌeta Dios gizhliyo ndee, no ni lá yoota‑yá stub biaj. ");
INSERT INTO zpt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tal leꞌa Dios ulaꞌa sian wizh yoo ta uzheꞌeb wa, leꞌa be men stea gat. Parea lá ulaꞌa Dios yoo sian wizh wa, geal leꞌa xa nlats ladna bexa mti xa. ");
INSERT INTO zpt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Weꞌe leꞌa tal ton gab ndoꞌ bega: “Bwiꞌi bego, leꞌa xa ndee Cristo”, natal gab xa: “Unaꞌ bego, leꞌa sa baꞌ nsoꞌ Cristo”, lá gungea ladna bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yoo bexa ukwiꞌin gab leꞌa nak Cristo, no ncho bexa ukwiꞌin gab leꞌa ndadiꞌizh sakndoꞌ Dios. Leꞌa bexa wa no gun sian taꞌa yanseana be men ndontsa ukedino xa bexa. No gun xa juers ukedino bexa wa gast bexa mti Dios. ");
INSERT INTO zpt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Blaꞌach bego leꞌa naꞌ yá ndáp nedla ta ndee ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ta weꞌe tal ton gab ndoꞌ bega: “Waꞌwiꞌi bega, leꞌa xa nak Cristo nkesea geꞌe”, naꞌanpa yaꞌ bega sa wa. No tal ton gab: “Utseawiꞌi bega, leꞌa Cristo ncho len niꞌi baꞌ”, lá gungea ladna bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Leꞌa lak nlaꞌ bealꞌ usiꞌi nsu‑yá xeꞌa lad nlen wizh no gast lad ndaꞌas wizh, no liga gak‑a zha ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Leꞌa lak sa nyakjunt be bech nluu leꞌa sa wa nax dub man ngut, no liga leꞌa zha ilengal naꞌ leꞌa itea be men iniꞌí‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Leꞌa gor utidla tiemp ncho be gealkweaꞌ wa, leꞌa ndoꞌ wizh ikaw, leꞌa mbeꞌe yá lá usuta xeꞌa, leꞌa be mbeal ndiꞌib gaꞌap baꞌ ilate, no gast idub gibeꞌa iwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Leꞌa gor ulundoꞌ be ta gibeꞌa wa leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yamer ilengal. Cha goꞌon be men itea be ras ncho ndoꞌ gizhliyo, no iniꞌí bexa leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilenno juers ten Dios lat xkaw no dub xeꞌa siꞌil. ");
INSERT INTO zpt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cha kwezh dub trompet, cha utuꞌub naꞌ be angel ten naꞌ, yunjunt bexa wa bexa mti Dios idub ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Bwiꞌi bego lak nak be ya laꞌaw. Leꞌa zha na nsaxan‑a nxich‑a, leꞌa zha wa uniꞌíka bega leꞌa tiemp bigi yá gal. ");
INSERT INTO zpt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","No liga leꞌa zha na naꞌ bego ncho itea be ta mbidiꞌizh naꞌ ndee, weꞌe iniꞌí bega leꞌa be wizh lult wa yamer ilen. ");
INSERT INTO zpt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Leꞌa naꞌ gáp ndoꞌ bega leꞌa itea be ta ndee itid zha biseata gat be men ncho gal zha wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Leꞌa gibeꞌa no gizhliyo initndoꞌ, parea leꞌa be ta ndáp naꞌ ndee yooka. ");
INSERT INTO zpt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Parea naꞌan ton iniꞌí xá wizh ná no xá gor yoo be ta ndee. Ni be angel ncho gibeꞌa lá iniꞌí ta wa. Nabtsa Dios Xus naꞌ uniꞌí‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Leꞌa lak ngok‑a zha uyoꞌo Noé, no liga gak‑a zha ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Leꞌa tiemp uyoꞌo Noé zha biseata ilen gilog wa leꞌa be men ndeyaw, no ndo bexa no ndeuchilyaꞌa bexa, no ngodiꞌin bexa xin xa, gast wizh uyoꞌo Noé len barco wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Leꞌa be men wa lá iniꞌí xtaꞌan yoo gast gor ulen gilog wa cha mbit‑a itea bexa. No liga gak‑a gor ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Leꞌa zha wa leꞌa top xabgiꞌi junt ndeyun tiꞌin geꞌe, cha yoꞌo Dios dubtsa xa, leꞌa stub xa wa yaꞌan. ");
INSERT INTO zpt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","No liga leꞌa top xagots junt ndeyajw, cha yoꞌo Dios dubtsa xa, leꞌa stub xa wa yaꞌan. ");
INSERT INTO zpt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ta weꞌe list ute bega, leꞌa bega lá iniꞌí xá wizh na ilengal naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Parea nsabndoꞌ yakbeꞌena bega ta ndee: tal leꞌa xwan dub niꞌi iniꞌí xá gor giꞌid waꞌan ta lid xa, leꞌa xa isob ulaꞌach ndontsa naꞌan ton yoo len lid xa kowaꞌan ta ncho sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ta weꞌe no bega list ute, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilengal dub gor ni lá ndanbeꞌe bega ti ilen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Ton bega nak cuent dub mos ndák ndun lak ndab dub xwan niꞌi? Leꞌa xwan niꞌi wa uchaꞌan mos wa inibeꞌe xa stapla bexa ndun tiꞌin ten xa, no usaꞌa mos ta gaw bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Leꞌa gor ilaꞌnchaꞌ xwan niꞌi wa uzhebpa wen yoo ladna mos ndun lak ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Leꞌa naꞌ gáp ndoꞌ bega leꞌa xwan niꞌi wa usoꞌ mos wen wa, yansu xa itea be ta ndap xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ná tal leꞌa mos wa dub xa ugap, gunbeꞌe xa gab xa leꞌa xa nibeꞌe ten xa nleꞌata ilen. ");
INSERT INTO zpt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Cha ndi isaxan xa kin xa iteata be mos wa. No nchealtsaꞌa xa bexa gu, gaw bexa no goo bexa. ");
INSERT INTO zpt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Weꞌe leꞌa xwan niꞌi wa ilaꞌnchaꞌ dub wizh no dub gor ni lá ndanbeꞌe mos ti ilen xa. ");
INSERT INTO zpt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Leꞌa xa wa cha uzheꞌeb utsaksi mos wa, cha utsaꞌab xa mos wa wats bexa nluu cuentta xa wen ná bexa xa ugap nak. Leꞌa sa wa goꞌon xa no gast ndeay xa gaw xa tant gealkweaꞌ siꞌil iniꞌí xa. ");
INSERT INTO zpt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Leꞌa zha weꞌe leꞌa lak nibeꞌe Dios be men wa nak cuent ta ngwasea dub tiꞌi xagots ben usen be xeꞌa aceit ten na, cha nchaꞌikanes bexa dub xabgiꞌi uchilyaꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Leꞌa gaꞌay bexa wa xa list nak, parea leꞌa stub sgaꞌay bexa wa naꞌanpa xa list nak. ");
INSERT INTO zpt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Leꞌa bexa naꞌanpa list nak wa mbiꞌi be xeꞌa ten na, parea naꞌanpa ngoꞌota xa aceit. ");
INSERT INTO zpt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ná leꞌa bexa list nak wa mbiꞌi be xeꞌa ten na no stubga bot aceit. ");
INSERT INTO zpt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Leꞌa xabgiꞌi uchilyaꞌa wa naꞌanpa ilayaꞌ gor mbinbeꞌe bexa wa, weꞌe ulen xkaꞌal itea bexa, cha ngwadgats bexa. ");
INSERT INTO zpt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Leꞌa utol teꞌal cha mgen dub ti men ugeꞌ ndab: “¡Yá nseala xabgiꞌi uchilyaꞌa wa! ¡Utoꞌo bega, waꞌikanes bega xa!” ");
INSERT INTO zpt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Weꞌe cha itea be xagots wa ngwastebe, cha usaxan bexa ndeusaxkwaꞌa bexa xeꞌa ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Leꞌa bexa naꞌanpa list nak wa ndab ndoꞌ bexa list nak wa: “Bsaꞌa bega dub tuzh aceit ten bega ikaꞌa besa, leꞌa xeꞌa ten besa yamer yuꞌu.” ");
INSERT INTO zpt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ná leꞌa bexa list nak wa cha ndab: “Tal leꞌa besa usaꞌa‑yá leꞌa‑yá lá ugal gun tiꞌin beuna. Mas wen waꞌ bega sa ndaꞌad‑a, cha usiꞌi bega ná gun tiꞌin bega.” ");
INSERT INTO zpt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Parea ndalen nchaꞌisiꞌi sgaꞌay xagots wa aceit, leꞌa xabgiꞌi uchilyaꞌa wa ulansea. Leꞌa be xagots list nde wa uyoꞌo len niꞌi no xabgiꞌi wa sa uchilyaꞌa xa, cha myaw toꞌo niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsoꞌo wa mlaꞌnchaꞌ be xagots naꞌanpa list nak wa, ndab bexa: “¡Señor, señor, bxaꞌal ga toꞌo niꞌi yoꞌo besa!” ");
INSERT INTO zpt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ná leꞌa xabgiꞌi wa cha ndi ukaꞌab ndab: “Leꞌa naꞌ gáp ndoꞌ bega leꞌa naꞌ lá nchandoꞌ bega.” ");
INSERT INTO zpt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Cha no ndab Jesús: —No bega list ute, leꞌa bega lá iniꞌí xá wizh ná no xá gor ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Leꞌa lak nibeꞌe Dios nak lak mbin dub xabgiꞌi ikaꞌan sit, utezh xa be mos ten xa. Cha msaꞌa xa be med ten xa gunno bexa‑yá tiꞌin. ");
INSERT INTO zpt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Leꞌa ndoꞌ dub mos msaꞌa xa gaꞌay med uzhebpa nsak. Leꞌa ndoꞌ stub xa msaꞌa xa top‑a, no ndoꞌ stub xa msaꞌa xa dub‑a. Lak ndák bexa wa, liga sian‑a msaꞌa xabgiꞌi wa. Cha ukaꞌan xa nchaꞌa xa sit. ");
INSERT INTO zpt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Weꞌe leꞌa xa usen dub gaꞌay med wa mbintiꞌin ta wa, cha mbin xa gan stub sgaꞌayga med ndoꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","No liga mbin xa usen top‑a wa, cha mbin xa gan stopga‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ná leꞌa xa usen dub‑a wa, cha ndi utoꞌo ngwaꞌdan xa dub geꞌed len yo, cha mkachko xa med ten xa nibeꞌe wa. ");
INSERT INTO zpt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Tsoꞌo wa kwenla leꞌa xa nibeꞌe wa mtanseaꞌ, cha nlad xa iniꞌí xa ná xteꞌe mbinno bexa med wa. ");
INSERT INTO zpt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ned ulen xa li usen gaꞌay med wa, cha myun xa cuent ta wa no sgaꞌayga‑yá ndoꞌ xa nibeꞌe wa. Ndab xa: “Señor, leꞌa go msaꞌa gaꞌay med ndee. Leꞌa ná ndee sgaꞌay ná mbin naꞌ gan.” ");
INSERT INTO zpt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Leꞌa xa nibeꞌe wa cha ndab: “Uzhebpa wen lu mos. Wen mbin lu tiꞌin nsea dub tuzh med ndee. Nat leꞌa naꞌ usa sian taꞌa inibeꞌe lu. Uyoꞌo, cha junt iten ladna beuna.” ");
INSERT INTO zpt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsoꞌo wa ulen xa li usen top med wa, cha ndab xa: “Señor, leꞌa go msaꞌa top med ndee. Leꞌa ná ndee stop ná mbin naꞌ gan.” ");
INSERT INTO zpt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Leꞌa xa nibeꞌe wa cha ndab: “Uzhebpa wen lu mos. Wen mbin lu tiꞌin nsea dub tuzh med ndee. Nat leꞌa naꞌ usa sian taꞌa inibeꞌe lu. Uyoꞌo, cha junt iten ladna beuna.” ");
INSERT INTO zpt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Ná leꞌa gor ulen xa usen dubtsa med wa, cha ndab xa ndoꞌ xa nibeꞌe wa: “Señor, leꞌa naꞌ uní leꞌa go uzhebpa dub xa nibeꞌe. Nsen go be taꞌa ni lid ta ten ga, no nteleꞌe ga be taꞌa ni lid ta ngas ga. ");
INSERT INTO zpt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ta weꞌe mzheb naꞌ, cha ngwaꞌukachkoꞌo naꞌ med ten ga len yo. Bwiꞌi ga leꞌa med ten ga ndee.” ");
INSERT INTO zpt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Leꞌa xa nibeꞌe wa cha ndab: “Leꞌa lu dub mos ugap no zhaꞌab. Tal leꞌa lu uniꞌí leꞌa naꞌ nsen be taꞌa ni lid ta ten naꞌ, no nteleꞌe naꞌ be taꞌa ni lid ta ngas naꞌ, ");
INSERT INTO zpt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿xtaꞌan lid ngaꞌulaꞌa lu med ten naꞌ banco, ndontsa nat nseal naꞌ isen naꞌ be xin med wa?” ");
INSERT INTO zpt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cha ndab xa ndoꞌ bexa nde sa wa: “Blat bega med nsén xa baꞌ, cha bsaꞌa bega‑yá ndoꞌ xa nsén dub tiꞌi med baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Leꞌa bexa utsin ndun wa, leꞌa bexa wa mas sian ta ikaꞌa. Ná leꞌa xa na naꞌanpa utsin ndun wa, leꞌa bexa slat be ta ndido ndap xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Leꞌa mos ugap ndee xa lá isuꞌu. Btsaꞌab bega xa tsoꞌo juer sa ukaw baꞌ, sa goꞌon xa no gast ndeay xa gaw xa, tant dub gealkweaꞌ siꞌil iniꞌí xa.” ");
INSERT INTO zpt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Leꞌa zha leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilengal no xeꞌa siꞌil ten Dios no itea be angel ten naꞌ, cha isoꞌob naꞌ sa nibeꞌe naꞌ no juers siꞌil ten naꞌ, ");
INSERT INTO zpt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","weꞌe leꞌa itea be men nde ndoꞌ gizhliyo ndee yakjunt ndoꞌ naꞌ. Cha uteltsaꞌa naꞌ bexa lak nteltsaꞌa dub xa nlaꞌach man be borreg lat be chiv. ");
INSERT INTO zpt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Leꞌa bexa cuent nak borreg kwe lad gaꞌal wats naꞌ, leꞌa bexa cuent nak chiv kwe lad raves. ");
INSERT INTO zpt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Weꞌe leꞌa naꞌ nak xa nibeꞌe cha gáp ndoꞌ bexa nde lad gaꞌal wa: “Utsea bega leꞌa Dios Xus naꞌ gun wen yoo ladna bega. Uyote bega sa nibeꞌe naꞌ, sa na ngokndeꞌe yoo bega zha ngokndeꞌekata gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Li ndáp naꞌ geal leꞌa gor na ndanna naꞌ, leꞌa bega msaꞌa ta udaw naꞌ. Leꞌa gor ndak lad naꞌ, leꞌa bega msaꞌa nits nguꞌu naꞌ. Leꞌa gor ukesea naꞌ sit, leꞌa bega msaꞌa sa ngot naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Leꞌa gor lá ndap naꞌ xab naꞌ, leꞌa bega msaꞌa lad ngok naꞌ. Leꞌa gor kweaꞌ usak naꞌ no zha ukea naꞌ litgiꞌib, leꞌa bega mbiꞌid inaꞌ naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Leꞌa bexa wen wa cha inabdiꞌizh gab: “Señor, ¿Pol uniꞌí besa ndanna ga, cha msaꞌa besa ta udaw ga? ¿No pol ndak ladna ga, cha msaꞌa besa nits ngu ga? ");
INSERT INTO zpt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿No pol ukesea ga sit, cha msaꞌa besa sa ngot ga? ¿No pol lá ndap ga xab ga, cha msaꞌa besa lad ngok ga? ");
INSERT INTO zpt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿No pol uniꞌí besa kweaꞌ usak ga no ukea ga litgiꞌib, cha ngwaꞌinaꞌ besa ga?” ");
INSERT INTO zpt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Weꞌe leꞌa naꞌ cha gáp ndoꞌ bexa: “Leꞌa naꞌ gáp ndoꞌ bego leꞌa gor li utsin mbinno bega dub xa naꞌanpa nsak, dub xa cuentta nak wit naꞌ no bsan naꞌ, leꞌa bega no ndoꞌ naꞌ ndee li utsin mbin.” ");
INSERT INTO zpt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Leꞌa naꞌ cha gáp ndoꞌ bexa nde lad wats raves naꞌ: “Utate bega wats naꞌ, bego na ndap ke ndoꞌ Dios. Waꞌbe bega ndoꞌ giꞌ nunk lá yuꞌu, sa msaxkwaꞌa Dios yaꞌbe maxuꞌu no be mbi bxin ten maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Li ndáp naꞌ geal leꞌa gor na ndanna naꞌ, leꞌa bega ni lá usaꞌa ta ngaw naꞌ. No gor ndak lad naꞌ, leꞌa bega ni lá usaꞌa nits ngoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Leꞌa gor ukesea naꞌ sa sit, leꞌa bega ni lá usaꞌa sa ngat naꞌ. Leꞌa gor lá ndap naꞌ xab naꞌ, leꞌa bega ni lá usaꞌa lad ngak naꞌ. Leꞌa gor kweaꞌ usak naꞌ no gor ukea naꞌ litgiꞌib, leꞌa bega ni lá ngiꞌid inaꞌ naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Weꞌe leꞌa bexa wa cha inabdiꞌizh gab bexa: “Señor, ¿pol uniꞌí besa ndanna ga, no ndak ladna ga, no sa sit ukesea ga, no ni lá ndap ga xab ga, no kweaꞌ usak ga, no ukea ga litgiꞌib, ná leꞌa besa ni lá ngakno ga?” ");
INSERT INTO zpt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Leꞌa naꞌ cha ikaꞌab ndáp: “Leꞌa naꞌ gáp ndoꞌ bego leꞌa gor na naꞌanpa li utsin ngun bega ndoꞌ dub xa naꞌanpa nsak, dub xa cuentta nak wit naꞌ no bsan naꞌ, leꞌa bega no ndoꞌ naꞌ li naꞌanpa utsin ngun.” ");
INSERT INTO zpt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Leꞌa bexa ugap wa cha yaꞌbe sa iniꞌí bexa gealkweaꞌ nunk lá idub. Ná leꞌa bexa wen wa yaꞌbe sa gap bexa gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Leꞌa gor mtayadiꞌizh Jesús itea be ta wa, cha ndab xa ndoꞌ be xmen xa: ");
INSERT INTO zpt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Leꞌa bego uniꞌíka leꞌa stop wizh ndun jwalt yoo ujest Pascua, zha na leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa be men, cha ukeꞌa bexa naꞌ ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Weꞌe leꞌa be uleꞌay nibeꞌe no be mech ten ley no bexa gox nsak ten bexa judio mzhealbe tale ten niꞌi ten Caifás, xa nak uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cha dubtsa mbidiꞌizh bexa isen bexa Jesús dub mod na lá iniꞌí be men‑a, cha gut bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Parea ndab bexa: —Naꞌanpa isen beuna xa len ujest, ndontsa lá ixaꞌach be men gakloo ndoꞌ beuna. ");
INSERT INTO zpt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Leꞌa dub wizh nsob Jesús ta lid Simón xa Betania, xa na polta usak gealgizh lepra. ");
INSERT INTO zpt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Weꞌe ulen dub xagots sa nsob Jesús ndoꞌ mes, nsea dub bot tuzh nakchaꞌaw geꞌ alabastro ncho ta uxeꞌe len‑a, dub ta uyappa nsak. Cha ulo xa ta uxeꞌe wa gek Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Leꞌa gor uniꞌí be xmen Jesús ta wa cha ngokloo bexa, ndab bexa ndoꞌ ltsaꞌa xa: —¿Xtaꞌan ngi mbizhaꞌa xagots ndee ta baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tal leꞌa xa ndi udoꞌo‑yá, leꞌa xa yoꞌo gan utseꞌa med wa ndoꞌ bexa uban nak, leꞌa‑yá uzhebpa dub ta nsak. ");
INSERT INTO zpt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Leꞌa gor na mbiꞌín Jesús ta wa, cha ndab xa ndoꞌ bexa: —¿Xtaꞌan ngi li nisi bega xagots ndee zha? Leꞌa xa dub ta wen mbinno naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Leꞌa bexa uban nak wa guniꞌi polga nchoka lat bega, parea leꞌa naꞌ ndee naꞌanpa kwenta nchoꞌono bega. ");
INSERT INTO zpt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Leꞌa ta na li mbin xagots ndee ulo xa ta uxeꞌe gek naꞌ, leꞌa ta wa li mbin xa ndontsa listla nak naꞌ zha igaꞌach naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Leꞌa naꞌ gáp ndoꞌ bega guniꞌi pa ndoꞌ gizhliyo gudiꞌizh be men diꞌizh wen ten Dios, no ta li mbin xagots ndee gudiꞌizh bexa, ndontsa iniꞌí be men ta wen mbin xa. ");
INSERT INTO zpt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Leꞌa Judas Iscariot, dub xa nak isatibtop xmen Jesús, cha ngwaꞌ ndoꞌ be uleꞌay nibeꞌe, ");
INSERT INTO zpt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","cha unabdiꞌizh xa ndab xa: —¿Plo med usaꞌa bego ika naꞌ yun naꞌ cuent Jesús ndoꞌ bega? Cha msaꞌa bexa galntiꞌi med plata ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Zha weꞌe leꞌa Judas cha usaxan nkwaꞌan ná xteꞌe yun xa cuent Jesús ndoꞌ yaꞌa bexa. ");
INSERT INTO zpt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Leꞌa ngol wizh ned ten ujest zha ndaw bexa judio pan naꞌan levadur, leꞌa be xmen Jesús ulen wats Jesús, cha ndab bexa: —¿Pa nlad go yaꞌyundeꞌe besa ta gaw beuna ujest Pascua? ");
INSERT INTO zpt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Leꞌa Jesús cha ndab: —Waꞌ bega gezh Jerusalén baꞌ ta lid xa na lika ndáp naꞌ ndoꞌ bega wa, cha gud bega ndoꞌ xa leꞌa Mech ten bega ndab: “Leꞌa tiemp wa yá ngol. Leꞌa ta lid ga gaw naꞌ ta ten ujest Pascua no be xmen naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Weꞌe leꞌa be xmen Jesús cha mbin lak ndab Jesús, cha mbinchaꞌaw bexa ta gaw xcheꞌe bexa ujest Pascua. ");
INSERT INTO zpt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Leꞌa ngol gor uyoꞌo teꞌal leꞌa Jesús nsea isatibtop be xmen xa mzhealbe sa wa, cha usaxan bexa gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ndalen li ndeyaw bexa wa, leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa dub bega na no nsob sa ndee yun cuent naꞌ ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Leꞌa bexa cha uzheꞌeb uban myoꞌo ladna, usaxan nabdiꞌizh dub gaꞌga bexa ndoꞌ Jesús: —¿Lid naꞌ ta wa zha, Señor? ");
INSERT INTO zpt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa dub bego na nsobyawno naꞌ plat ndee yun cuent naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta ugeaka leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, itiꞌidka lak nkeaniꞌi diꞌizh ten Dios. Parea proꞌob xabgiꞌi na yun cuent naꞌ ndoꞌ bexa wa. Mas wen lá yoꞌo xabgiꞌi wa ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Leꞌa Judas, xa na yun cuent Jesús, cha unabdiꞌizh ndab: —¿Lid naꞌ ta wa zha, Mech? Leꞌa Jesús cha ndab: —Luka ta wa lak ndab lu. ");
INSERT INTO zpt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Leꞌa gor na li ndeyaw bexa, leꞌa Jesús cha usen dub pan, cha msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa‑yá, no mtseꞌa xa‑yá ndoꞌ be xmen xa, ndab xa: —Usen bega pan ndee, cha udaw bega‑yá, leꞌa ta ndee beꞌal las naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Cha liga usen Jesús dub vas ncho vin, cha msaꞌa xa xno ndoꞌ Dios. Cha msaꞌa xa‑yá ndoꞌ bexa, ndab xa: —Iteanak bega gu ta ncho len vas ndee, ");
INSERT INTO zpt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","leꞌa ta ndee ten ten naꞌ usa naꞌ ndontsa utsuꞌu Dios ke ten be men. Leꞌa ta ndee nluu leꞌa nat leꞌa Dios mbinno be men dub trat kub ná xteꞌe wen yaꞌan bexa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","No gáp naꞌ ndoꞌ bega leꞌa naꞌ yá naꞌantapa goꞌo vin ten uv, gast gal wizh goꞌono naꞌ bega‑yá stub biaj sa nibeꞌe Dios Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cha mbiltoꞌo bexa dub cant ndoꞌ Dios. Cha utoꞌo bexa nchaꞌbe bexa Bet Olivo. ");
INSERT INTO zpt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Weꞌe leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa teꞌal ndee leꞌa iteanak bega ulaꞌa naꞌ, lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Leꞌa naꞌ gut xa nlaꞌach be borreg, cha iteꞌachso bema.” ");
INSERT INTO zpt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ná leꞌa tsoꞌo na iban naꞌ leꞌa naꞌ ned ilayaa ndoꞌ bega Galilea. ");
INSERT INTO zpt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Leꞌa Pedr cha ndab: —Maska itea be men ulaꞌa ga, ná leꞌa naꞌ nunk lá ula ga. ");
INSERT INTO zpt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Leꞌa Jesús cha ndab ndoꞌ Pedr: —Leꞌa naꞌ gáp ndoꞌ lu leꞌa teꞌal ndee gor biseata kwezh boy, leꞌa lu ta ugeaka mkwiꞌinla chon biaj, ndab lu leꞌa lu lá nchandoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ná leꞌa Pedr cha ndab: —Maska gat naꞌ gor na gat go, leꞌa naꞌ nunk lá gáp leꞌa naꞌ lá nchandoꞌ ga. Leꞌa iteata be xmen Jesús ndab lak ndab Pedr. ");
INSERT INTO zpt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Weꞌe leꞌa Jesús cha ulayaꞌ sa nsaleaꞌ Getsemaní nsea be xmen xa. Cha ndab Jesús ndoꞌ bexa: —Ndeꞌetsa ute bega, ndalen ndaꞌyadiꞌizhno naꞌ Dios sa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Cha mbiꞌi Jesús chon bexa stub tuzh sa, leꞌa ta wa Pedr no itop xin Zebedeo. Leꞌa Jesús cha uzhebpa uban myoꞌo ladna no kweaꞌ myoꞌo ladna xa. ");
INSERT INTO zpt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cha ndab Jesús ndoꞌ yon bexa wa: —Uzhebpa uban ncho lad naꞌ gast ngi sat naꞌ. Ndeꞌetsa ute bega, cha utenaꞌno bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cha usea Jesús stub tuzh sa, cha usaxib xa gast ndoꞌ yo ngol xtuzh xa, cha uníꞌi xa ndoꞌ Dios, ndab xa: —Tad, tal syoꞌo gan, lá ulaꞌa ga itiꞌid naꞌ ndoꞌ be gealkweaꞌ uzheꞌeb ndee. Parea lá gak‑a lak nlad naꞌ, ndi gak‑a lak nlad go. ");
INSERT INTO zpt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Weꞌe leꞌa gor na nseaꞌ Jesús sa na nde yon xmen xa, leꞌa bexa ndeyats. Cha ndab xa ndoꞌ Pedr: —¿Ni dub gor lá uxik bega kwenaꞌno bega naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Utenaꞌ bega no bidiꞌizhno bega Dios, ndontsa naꞌanpa utsabgix maxuꞌu bega. Leꞌa ladoꞌo bega nlad gun ta wen, ná leꞌa idub bega lá uxik. ");
INSERT INTO zpt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cha nchaꞌagal Jesús nchaꞌyadiꞌizhno xa Dios, ndab xa: —Tad, tal naꞌ juerska itiꞌid ndoꞌ be gealkweaꞌ ndee, gak‑a lak nlad go. ");
INSERT INTO zpt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Leꞌa gor nseaꞌgal Jesús sa nde bexa wa, leꞌa bexa ndeyatsgal, geal leꞌa bexa uzhebpa nyoꞌo xkaꞌalna. ");
INSERT INTO zpt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Cha mlaꞌagal xa bexa, nchaꞌyadiꞌizhnogal xa Dios biaj yon, cha ndabgal xa lakka ndabla xa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cha nseaꞌgal xa sa nde bexa, cha ndab xa: —¿Galka bi ndeyats bega zha, no bi ndeuneꞌe bega zha? Nat bwiꞌi bega yá ngol gor leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa bexa ugap. ");
INSERT INTO zpt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Goste bega, nchaꞌbe beuna. Bwiꞌi bega leꞌa xa yun cuent naꞌ yá nseala baꞌa. ");
INSERT INTO zpt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bi li nsoꞌyadiꞌizh Jesús leꞌa Judas, xa no nak dub tibtop xmen Jesús, ulennola be men kwaꞌad noꞌo be spad nsea garrot. Leꞌa ta wa bexa mtuꞌub uleꞌay nibeꞌe no bexa gox nsak isen bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Leꞌa Judas, xa li yun cuent Jesús, nedla ndab ndoꞌ be men wa: “Leꞌa xa na gaw naꞌ chit beꞌal ndoꞌ na wa, xa weꞌe isen bega.” ");
INSERT INTO zpt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Leꞌa gor ulayaꞌ Judas sa wa, cha uxax ubii xa wats Jesús, cha ndab xa: —Tiux ga, Mech. Cha mchealtoꞌo xa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Leꞌa Jesús cha ndab: —Amig, ¿xtiꞌin nsea lu? Weꞌe leꞌa bexa kwaꞌad wa cha ubii gax, cha usen bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ná leꞌa dub xa nsoꞌ wats Jesús uloꞌo spad tuzh ten na, cha ulobtoꞌog xa nchaꞌ dub xmen uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Leꞌa Jesús cha ndab ndoꞌ xa ten spad wa: —Ulochaꞌaw spad ten lu len lid‑a. Leꞌa itea bexa ndantiꞌin spad, leꞌa xa wa ndoꞌ spadka gat. ");
INSERT INTO zpt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Lá iniꞌí lu leꞌa naꞌ syoꞌo gan inaꞌab ndoꞌ Xus naꞌ bi leꞌa nat, cha utuꞌub xa masla dub tibtop xkwaꞌa siꞌil be angel gakno naꞌ? ");
INSERT INTO zpt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Parea tal naꞌ li gun, weꞌe naꞌanpa gak‑a lak nkeaniꞌi diꞌizh ten Dios be ta nsabndoꞌ itiꞌid naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Cha ndab Jesús ndoꞌ be men wa: —¿Xtaꞌan nseano bega spad nsea garrot isen bega naꞌ cuent dub waꞌan? Itea wizh nluu naꞌ be men wats niꞌi ten Dios lat bega, ná lá isen bega naꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Parea leꞌa iteanak be ta ndee nsatid ndontsa gak‑a lak nkeaniꞌi diꞌizh ten Dios, ta ndab bexa mbidiꞌizh sakndoꞌ Dios. Weꞌe leꞌa itea be xmen Jesús cha mxoꞌon, mlaꞌa bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Leꞌa bexa na li usen Jesús wa cha mbiꞌi xa ta lid Caifás uleꞌay ndon leꞌa nsak, sa mzhealbela be mech ten ley no bexa gox nsak. ");
INSERT INTO zpt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Leꞌa Pedr sittsa nchankea tsoꞌo Jesús, gast uyoꞌo Pedr len tale ten niꞌi wa. Cha usob Pedr gax wats bexa nlaꞌach sa wa, natsa iniꞌí xa ná xtaꞌan yasea Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Leꞌa be uleꞌay nibeꞌe no bexa gox nsak no iteata bexa nsak wa nkwaꞌan be men ukwiꞌin gab leꞌa Jesús ndapka ke, ta nsabndoꞌ gat xa. ");
INSERT INTO zpt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Leꞌa kwaꞌad be men mkwiꞌin nsake Jesús, ná lá izheal bexa nibeꞌe wa ni dub ke nsabndoꞌ gat Jesús. Weꞌe ulen stop bexa, ");
INSERT INTO zpt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","cha mkwiꞌin bexa ndab: —Leꞌa xa baꞌ ndab leꞌa xa sun gan ulate niꞌi ten Dios, cha gal wizh yon leꞌa xa gundeꞌegal‑a. ");
INSERT INTO zpt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Weꞌe leꞌa uleꞌay ndon leꞌa nsak wa ngwasoꞌ, ndab ndoꞌ Jesús: —¿Ni lá utsakndoꞌ lu zha? ¿Ta ugeaka ta ndab bexa ndee leꞌa lu li ndab zha? ");
INSERT INTO zpt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ná leꞌa Jesús naꞌan xteꞌe ngab. Weꞌe leꞌa uleꞌay wa cha ndabgal ndoꞌ Jesús: —Leꞌa Dios nban nsobwiꞌi, leꞌa naꞌ nibeꞌe ndoꞌ lu gud ndoꞌ besa naga lu nak Cristo Xin Dios zha. ");
INSERT INTO zpt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Leꞌa Jesús cha ndab: —Goka ndab‑a. No gáp naꞌ leꞌa nat idub nchaꞌa ndoꞌ ndee leꞌa bega iniꞌíka leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, isob wats Dios lad gaꞌal xa ndon leꞌa nibeꞌe, no ilengal naꞌ ndoꞌ xkaw. ");
INSERT INTO zpt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Leꞌa uleꞌay ndon leꞌa nsak wa cha utsaw xab na tant ndakloo xa, cha ugeꞌ ndab xa ndoꞌ bexa nde sa wa: —¡Leꞌa xa ndee unisi Dios! ¿Xtaꞌanta nkiꞌin beuna kwaꞌadta xa usake xa? Leꞌa bega mbiꞌín xteꞌe ugap uníꞌi xa. ");
INSERT INTO zpt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nat zha xteꞌe gab bega, xteꞌe gunno beuna xa? Leꞌa bexa wa cha ukaꞌab ndab: —¡Leꞌa xa ndapka ke nsabndoꞌ gat xa! ");
INSERT INTO zpt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Cha mchukko bexa ndoꞌ Jesús, no udin bexa Jesús. No ncho bexa utichyaꞌa ndoꞌ Jesús, ");
INSERT INTO zpt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ndab bexa ndoꞌ Jesús: —Tal lu ta ugeaka nak Cristo, ¡gud ná ton udin lu! ");
INSERT INTO zpt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ndalen wa leꞌa Pedr nsob tsoꞌo juer tale wa. Cha ubii dub xagots ndun tiꞌin sa wa wats Pedr, ndab xa: —Go no ukeseano Jesús xa Galilea, ¿la? ");
INSERT INTO zpt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ná leꞌa Pedr cha mkwiꞌin ndoꞌ gaꞌal itea bexa wa ndab: —Naꞌ lá iní xtaꞌan ndab go ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cha nchaꞌa Pedr mas gax toꞌo puert. Weꞌe cha uniꞌí stubgal xagots Pedr, ndab xa ndoꞌ bexa nde sa wa: —Leꞌa xa ndee no ukeseano Jesús xa Nazaret. ");
INSERT INTO zpt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ná leꞌa Pedr cha mkwiꞌingal ndab xa: —Leꞌa Dios nsobwiꞌi leꞌa naꞌ lá nchandoꞌ xabgiꞌi baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tsoꞌoma wa leꞌa bexa nde sa wa ubii wats Pedr ndab bexa: —Ta ugeaka leꞌa go no nak dub xmen xa baꞌ, leꞌa go ndadiꞌizh lak ndadiꞌizh bexa Galilea. ");
INSERT INTO zpt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Leꞌa Pedr cha ngokloo ndab ndoꞌ bexa: —¡Nsobwiꞌi Dios leꞌa naꞌ lá nchandoꞌ xa baꞌ! Zha leꞌa dub boy utezh. ");
INSERT INTO zpt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Weꞌe leꞌa Pedr cha mtseꞌa ladna ta ndab Jesús: “Leꞌa teꞌal ndee gor biseata kwezh boy, leꞌa lu mkwiꞌinla chon biaj ndab lu leꞌa lu lá nchandoꞌ naꞌ.” Cha utoꞌo Pedr tsoꞌo juer, cha uzhebpa mbiꞌin xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Leꞌa ngol gor ngot xeꞌa, leꞌa itea be uleꞌay nibeꞌe no bexa gox nsak ten bexa judio dubtsa mbidiꞌizh xteꞌe gun bexa gan gat Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Cha mxi bexa Jesús cha mbiꞌi bexa xa ndoꞌ Poncio Pilat, xa nibeꞌe idub región wa. ");
INSERT INTO zpt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Leꞌa Judas xa na li myun cuent Jesús wa, gor uniꞌí xa leꞌa bexa wa dubtsa mbidiꞌizh gat Jesús, cha mgondoꞌ xa leꞌa xa ugap mbin. Cha mbiꞌi xa isagalntiꞌi med plata wa sa nde be uleꞌay nibeꞌe no bexa gox nsak wa. ");
INSERT INTO zpt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cha ndab Judas ndoꞌ bexa: —Leꞌa naꞌ mbin dub ta ugap, myun naꞌ cuent dub xa gat, mas ni lá ndap xa ke. Ná leꞌa bexa wa cha ndab: —Leꞌa besa naꞌan xá gealnyuꞌ ná ta li mbin lu wa. Leꞌa ta wa cuent ten lu nak. ");
INSERT INTO zpt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Weꞌe leꞌa Judas cha udabi be med wa len niꞌi ten Dios. Cha utoꞌo xa sa wa, cha ulo xa doꞌo gen xa, mtsebe xa gen xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Leꞌa be uleꞌay nibeꞌe cha mkanleꞌe be med wa, cha ndab bexa: —Lá nsabndoꞌ guntiꞌin beuna med ndee cuent be med gon, leꞌa‑yá ngoktiꞌin ndontsa gat dub men. ");
INSERT INTO zpt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cha mbidiꞌizh bexa isiꞌi bexa dub bleꞌa yo ten dub xa ndandeꞌe be ta btsiꞌin, ndontsa sa weꞌe igaꞌach tal ton bexa sit gat gezh Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ta weꞌe gast nat leꞌa yo wa nsaleaꞌ Yo Ten. ");
INSERT INTO zpt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Li ngok‑a lak ndab Jeremías xa mbidiꞌizh sakndoꞌ Dios tiemp polta, ndab xa: “Usen bexa galntiꞌi med plata, lak mbidiꞌizh bexa Israel kix bexa. ");
INSERT INTO zpt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Leꞌa med wa cha usiꞌi bexa yo ten xa ndandeꞌe be ta btsiꞌin. Leꞌa ta wa ta ndab Dios ndoꞌ naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Leꞌa gor nsoꞌ Jesús ndoꞌ Pilat xa nibeꞌe wa, leꞌa Pilat cha unabdiꞌizh ndab ndoꞌ Jesús: —¿Lu nak xa nibeꞌe ten bexa judio zha? Leꞌa Jesús cha ndab: —Goka ndab‑a. ");
INSERT INTO zpt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Weꞌe leꞌa be uleꞌay nibeꞌe no bexa gox nsak wa sian taꞌa msake Jesús, ná leꞌa Jesús ni lá utsakndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Leꞌa Pilat cha ndabgal ndoꞌ Jesús: —¿Lá ndoꞌón lu be ta sian li nsake bexa baꞌ lu zha? ");
INSERT INTO zpt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Parea leꞌa Jesús ni dub diꞌizh lá ikaꞌab, cha uzheꞌeb ngwanseana Pilat. ");
INSERT INTO zpt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Leꞌa itea liꞌin zha ndal ujest Pascua wa, leꞌa Pilat ngoꞌo dub men nkea litgiꞌib, tal ton nlad be men itoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Leꞌa zha wa uyoꞌo dub xabgiꞌi nsaleaꞌ Barrabás nkea litgiꞌib, dub xa uniꞌí itea be men xtaꞌan ta ugap mbin xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Leꞌa gor mzhealbe be men ta lid Pilat, leꞌa Pilat cha ndab ndoꞌ bexa: —¿Ton nlad bega ula naꞌ, Barrabás nate Jesús xa ndab be men nak Cristo? ");
INSERT INTO zpt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Leꞌa Pilat uniꞌí leꞌa be uleꞌay nibeꞌe nxee ladna ndoꞌ Jesús ta na mas kwaꞌad men ndeseano Jesús, ta weꞌe myun bexa cuent Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Leꞌa gor na li nsob Pilat sa nibeꞌe Pilat wa, leꞌa xagots ten xa mtuꞌub dub xa gab ndoꞌ xa: “Naꞌan xteꞌe gunno lu xabgiꞌi wen wa, leꞌa naꞌ uzhebpa mzheb dub ta mcheꞌano lad naꞌ xa teꞌal.” ");
INSERT INTO zpt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Parea leꞌa be uleꞌay nibeꞌe no bexa gox nsak mkiꞌil be men wa inab bexa igoꞌo Pilat Barrabás litgiꞌib, cha gat Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ta weꞌe leꞌa gor na unabdiꞌizhgal Pilat ndoꞌ be men ná ton ndoꞌ itop bexa wa nlad bexa igoꞌo Pilat, leꞌa be men wa cha ndab: —¡Bgoꞌo ga Barrabás! ");
INSERT INTO zpt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Leꞌa Pilat cha ndab: —¿Xteꞌe gunno naꞌ Jesús xa ndab be men nak Cristo zha? Leꞌa iteanak bexa wa cha ugeꞌ ndabbe: —¡Ikea xa ndoꞌ cruz! ");
INSERT INTO zpt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Leꞌa Pilat cha ndab: —¿Xtaꞌan dub ta ugap mbin xa zhaga? Parea leꞌa be men wa ndi mas ugeꞌ ndab: —¡Ikea xa ndoꞌ cruz! ");
INSERT INTO zpt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Leꞌa gor uniꞌí Pilat leꞌa Pilat lá gun gan ndoꞌ bexa leꞌa bexa ndi mas ndakloobe, cha usen Pilat dub ta ncho nits. Cha mnaꞌa Pilat ndoꞌ gaꞌal be men wa, ndab xa: —Leꞌa naꞌ naꞌanpa leꞌa ndap ke gat xa wen ndee. Leꞌa ta wa cuent ten bega nak. ");
INSERT INTO zpt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Weꞌe leꞌa iteanak be men wa cha ndabbe: —Leꞌa besa ndee no be xin besa leꞌa ndap ke gat xa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Weꞌe leꞌa Pilat cha mgoꞌo Barrabás litgiꞌib. Cha ndab Pilat ndoꞌ be soldad kin bexa Jesús, cha ukeꞌa bexa Jesús ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Leꞌa be soldad ten Pilat cha mbiꞌi Jesús len lid Pilat sa nsaleaꞌ pretorio. Cha mzhealbe kwaꞌadta be soldad gangeak wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Cha ulate bexa xab Jesús, no mgak bexa Jesús dub lad koꞌol ta nane. ");
INSERT INTO zpt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","No msob bexa dub ta rued xos yagich gek Jesús cuent coron. Cha msob bexa dub bar yaꞌa Jesús lad gaꞌal. Cha msaxib bexa ndoꞌ Jesús mbin usaladno bexa Jesús, ndab bexa: —¡Siꞌil nak xa nibeꞌe ten bexa judio! ");
INSERT INTO zpt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Cha mchukko bexa ndoꞌ Jesús, cha ute bexa bar nsén Jesús, cha leꞌaka bar wa nlaꞌ bexa gek Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Leꞌa gor na mtayun usaladno bexa Jesús, cha ulate bexa lad nane nak Jesús. Cha mgak bexa Jesús leꞌaka xab Jesús, cha nchaꞌano bexa Jesús sa ikea xa ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Leꞌa gor utoꞌo be soldad sa wa, cha mzheꞌal bexa dub xabgiꞌi nsaleaꞌ Simón xa gezh Cirene. Cha mbin bexa juers goꞌo xa cruz ten Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Cha ngol gor ulayaꞌ bexa sa nsaleaꞌ Gólgota, dub diꞌizh gab tit gek men. ");
INSERT INTO zpt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Cha msaꞌa bexa vin kwi mbich ta ulaꞌpa goo Jesús. Ná leꞌa gor na mbin xa preb‑a, cha lá kaꞌabta xa goo xa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cha mkeꞌa be soldad Jesús ndoꞌ cruz, cha uloꞌo bexa dub suert ndontsa iniꞌí bexa ná ton ikaꞌa be xab Jesús. Li ngok‑a lak ndab dub xa mbidiꞌizh sakndoꞌ Dios tiemp polta, ndab xa: “Uloꞌo bexa dub suert ndontsa iniꞌí bexa ná ton ikaꞌa be xab naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Cha ndeulaꞌach be soldad xa sa wa. ");
INSERT INTO zpt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Leꞌa gek cruz ten Jesús wa mkeꞌa bexa dub letr ndab ná xtaꞌan li nkea xa ndoꞌ cruz, ndab‑a: “TA NDEE JESÚS, XA NIBEꞌE TEN BEXA JUDIO.” ");
INSERT INTO zpt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nsea top waꞌan mkeꞌa bexa ndoꞌ cruz wats Jesús, dub xa wats lad gaꞌal Jesús, nsea stub xa wats lad raves. ");
INSERT INTO zpt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Leꞌa be men nseabetid sa wa xela uníꞌi ndoꞌ Jesús, nkwiꞌin bexa gek bexa, ");
INSERT INTO zpt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ndab bexa ndoꞌ Jesús: —Lu ndab leꞌa lu ulate niꞌi ten Dios, cha ixiste lu‑yá wizh yontsa. Nat byun libr leꞌaka lu. ¡Tal lu Xin Dios, ulaꞌ ndoꞌ cruz baꞌ! ");
INSERT INTO zpt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","No liga leꞌa be uleꞌay nibeꞌe no be mech ten ley no bexa fariseo no bexa gox nsak wa ndun usaladno Jesús, ndab bexa ndoꞌ ltsaꞌa bexa: ");
INSERT INTO zpt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Leꞌa xa baꞌ leꞌa ngokno be men, ná lá gun xa gan ulat xa leꞌaka xa ndoꞌ gealgut. Tal leꞌa xa baꞌ xa nibeꞌe ten beuna xa Israel, ilaꞌ xa ndoꞌ cruz, cha gungea ladna beuna xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Leꞌa xa baꞌ ndab leꞌa ngeꞌ ladna Dios. Nat gakno Dios xa tal leꞌa Dios nlad, leꞌa xa baꞌ ndab leꞌa xa Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","No liga leꞌa itop waꞌan nkea ndoꞌ be cruz wats Jesús wa xela uníꞌi ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Leꞌa ngol gor gawizh leꞌa idub ndoꞌ gizhliyo mkaw gast gor nkea uyon gor uzhe. ");
INSERT INTO zpt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Leꞌa ngol gor nkea uyon wa leꞌa Jesús ugeꞌ ndab: —Elí, Elí, ¿lama sabactani? —leꞌa ta wa dub diꞌizh gab: Dios ten naꞌ, Dios ten naꞌ, ¿xtaꞌanxá mlalad go naꞌ zhaga? ");
INSERT INTO zpt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Leꞌa ncho bexa nde sa wa gor na mbiꞌín bexa ta li ndab Jesús wa, cha ndab bexa: —Leꞌa xa baꞌ nbezh Elí. ");
INSERT INTO zpt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Zha leꞌa dub bexa wa utoꞌo karrel, nchaꞌdob dub lad xiꞌil, cha ulo xa‑yá ndoꞌ vinagr. Cha msob xa‑yá gek dub yalod ndontsa goo Jesús ta wa. ");
INSERT INTO zpt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Parea leꞌa iteata bexa wa ndab ndoꞌ xa wa: —Kweas go, leꞌa beuna iniꞌí naga siꞌid yakno Elí xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Weꞌe leꞌa Jesús cha ugeꞌgal utezhat, cha ngut xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Zha leꞌa lad utaꞌa ncho bseꞌa len niꞌi ten Dios cha usaw gast gaꞌap no gast ilaꞌ, ngok top bleꞌa‑yá. No ngok xoꞌo gast uleꞌa be geꞌ ubiꞌi, ");
INSERT INTO zpt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","no myaꞌal be geꞌloꞌo sa mgaꞌach be men ngut. Cha myaste kwaꞌad bexa ngut, bexa nak xmen Dios. ");
INSERT INTO zpt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Cha utoꞌo bexa wa len baꞌa wa. Leꞌa tsoꞌo na mbangal Jesús, cha uyote bexa wa Jerusalén cha uniꞌí kwaꞌad be men bexa. ");
INSERT INTO zpt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Leꞌa gor ngok xoꞌo nsea iteata be taꞌa wa, leꞌa xa nibeꞌe ten soldad no iteata be soldad ndeulaꞌach Jesús wa cha uzhebpa mzheb, ndab bexa: —Ta ugeaka leꞌa xabgiꞌi ndee Xinka Dios. ");
INSERT INTO zpt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Leꞌa sa wa sittsa ndewiꞌi kwaꞌad be xagots, bexa na utoꞌo Galilea usankea bexa tsoꞌo Jesús, no ngokno bexa Jesús nes nchaꞌa xa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Leꞌa lat bexa wa no Marí xa gezh Magdala nsoꞌ, no Marí xnaꞌa Jacob nsea Kosé, no xnaꞌa be xin Zebedeo. ");
INSERT INTO zpt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Leꞌa ngol gor uzhe cha ulen dub xabgiꞌi rik nsaleaꞌ Kosé, xa gezh Arimatea, dub xa no ndangea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Leꞌa xa wa ngwaꞌ ndoꞌ Pilat, cha unab xa Jesús. Leꞌa Pilat cha unibeꞌe ulaꞌa be soldad goꞌo Kosé Jesús. ");
INSERT INTO zpt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Cha uxeꞌe Kosé Jesús ndoꞌ cruz wa, cha mtixko xa Jesús dub lad koꞌol ta umbiꞌi. ");
INSERT INTO zpt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Cha ulo xa Jesús len dub baꞌa cuent geꞌloꞌo, dub ta tlaw myan ndoꞌ geꞌdaꞌa. Cha mtixte xa dub geꞌ siꞌil toꞌo baꞌa wa, cha nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Leꞌa sa wa nde Marí xa Magdala no stubga Marí lad toꞌo baꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Leꞌa ngot xeꞌa stubga wizh dub wizh neꞌe bexa judio, leꞌa be uleꞌay nibeꞌe no bexa fariseo ngwaꞌ ndoꞌ Pilat, ");
INSERT INTO zpt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ndab bexa: —Señor, leꞌa besa ntseꞌa ladna leꞌa Jesús xa ukwiꞌin wa ndab gor na bi nban xa leꞌa xa wizh yontsa iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ta weꞌe nab besa ndoꞌ go inibeꞌe ga yaꞌulaꞌach be soldad toꞌo baꞌa gast wizh yon. Tal naꞌanpa li gun ga leꞌa be xmen xa giꞌid gor teꞌal, cha goꞌo bexa wa xa. Cha ukwiꞌin bexa gab bexa ndoꞌ be men leꞌa xa wa mbanla ndoꞌ gealgut. Tal leꞌa bexa li ukwiꞌin leꞌa ta wa mas ugap ndoꞌ lak mkwiꞌin Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Weꞌe leꞌa Pilat cha ndab ndoꞌ bexa: —Ulaꞌachka be soldad sa wa. Waꞌ bega cha btsaw chá bega toꞌo baꞌa wa lak ndák bega. ");
INSERT INTO zpt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Weꞌe leꞌa bexa wa cha nchaꞌbe, cha ulo bexa dub taꞌa toꞌo baꞌa wa, natsa iniꞌí bexa tal ton uxaꞌal‑a. Cha myanbe be soldad sa wa ulaꞌach bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngol utid wizh neꞌe bexa wa, gor ngot xeꞌa wizh ned ten sman, leꞌa Marí xa Magdala no stubga Marí nchaꞌwiꞌi baꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Weꞌe cha ngok dub xoꞌo siꞌil. Leꞌa dub angel ten Dios utoꞌo gibeꞌa ulaꞌ sa wa, cha udob xa geꞌ toꞌo baꞌa wa, cha usob xa tsoꞌo‑yá. ");
INSERT INTO zpt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Leꞌa angel wa ndon nduꞌu naꞌ cuent bealꞌ usiꞌi. No xab xa ndon mbe xiꞌil naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Leꞌa gor uniꞌí be soldad ta wa, uzheꞌeb nzheb bexa gast nxis bexa, cha ulayat bexa ndoꞌ yo cuent bexa ngut. ");
INSERT INTO zpt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Leꞌa angel ndab ndoꞌ be xagots wa: —Lá izheb bego, leꞌa naꞌ uníka leꞌa bego nkwaꞌan Jesús, xa ngut ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Leꞌa xa naꞌan sa ndee, leꞌa xa ndi mbanla lakka ndab xa. Utseawiꞌi bega sa mkaꞌach bexa xa. ");
INSERT INTO zpt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cha uxax byaꞌ bega, cha gud bega ndoꞌ be xmen Jesús leꞌa xa mbanla ndoꞌ gealgut. No nchaꞌa nedla xa ndoꞌ bexa wa Galilea, leꞌa sa wa iniꞌígal bexa xa. Leꞌa naꞌ ta ndeekama nsabndoꞌ gáp ndoꞌ bego. ");
INSERT INTO zpt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Weꞌe leꞌa be xagots wa nzheb, parea uzhebpa nten ladna bexa. Cha uxax mkaꞌan bexa wats baꞌa wa, karrel nseaꞌbeyab bexa‑yá ndoꞌ be xmen Jesús. Leꞌa nes nseaꞌbe be xagots wa, ");
INSERT INTO zpt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ngi zha uniꞌí bexa leꞌa Jesús nseala nes, cha unidiꞌizh Jesús ndoꞌ bexa. Cha ubii bexa wats Jesús, msaxib bexa ndoꞌ xa. Cha udiꞌid bexa xoꞌo Jesús, ndankea bexa xa. ");
INSERT INTO zpt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Weꞌe leꞌa Jesús cha ndab ndoꞌ bexa: —Lá izheb bega. Byaꞌyab bega ndoꞌ be xmen naꞌ, bexa cuent nak wit naꞌ, yaꞌbe bexa Galilea, leꞌa sa wa iniꞌígal bexa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ndalen li nchaꞌbe be xagots nes wa, leꞌa pla be soldad nlaꞌach toꞌo baꞌa wa uyote gezh wa, cha mbidiꞌizh bexa ndoꞌ be uleꞌay nibeꞌe wa iteanak be ta li uyoꞌo wa. ");
INSERT INTO zpt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Leꞌa bexa nibeꞌe ten uleꞌay wa cha ngwaꞌyadiꞌizhno bexa gox nsak ten bexa judio ná xteꞌe gun bexa. Weꞌe cha msaꞌa bexa sian med ndoꞌ be soldad wa, ");
INSERT INTO zpt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ndab bexa: —Gud bega leꞌa be xmen Jesús mbiꞌid gor teꞌal cha mbiwaꞌan bexa Jesús gor ndeyats bega. ");
INSERT INTO zpt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tal leꞌa xa nibeꞌe wa goꞌón‑a, leꞌa besa leꞌa ikaꞌab sakndoꞌ bega, ndontsa naꞌan xtaꞌan gunno xa bega. ");
INSERT INTO zpt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Weꞌe leꞌa be soldad wa cha usen be med wa, cha mbidiꞌizh bexa lak ndab be uleꞌay wa. Leꞌa ta wa gast wizh nat li ndadiꞌizh bexa judio lak mkwiꞌin be soldad wa. ");
INSERT INTO zpt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Weꞌe leꞌa isatibdub be xmen Jesús nchaꞌbe Galilea, gast bet sa ndabka Jesús yaꞌbe bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Leꞌa gor uniꞌí bexa Jesús, cha ngwankea bexa xa, parea ncho bexa bi lá ndangea ladna ti leꞌa Jesús xa wa. ");
INSERT INTO zpt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Leꞌa Jesús cha ubii wats bexa, ndab xa: —Leꞌa Dios msaꞌa juers nibeꞌe naꞌ iteanak be ta ncho gibeꞌa no ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ta weꞌe waꞌ bega idub nax ndoꞌ gizhliyo ndoꞌ be men itea be nacion, bluu bega bexa xteꞌe gak bexa xmen naꞌ. Cha ulaleaꞌ bega bexa, guntiꞌin bega leaꞌ Dios Xus naꞌ, no lea naꞌ xa nak Xin Dios, no leaꞌ Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bluu bega bexa uxobgek bexa iteanak ta unibeꞌe naꞌ ndoꞌ bega. Lá yalad bega leꞌa naꞌ nkeseano tseꞌe bega gast initndoꞌ gizhliyo ndee. Lika nak‑a.");
INSERT INTO zpt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Lndeꞌe usaxan diꞌizh wen ten Jesucristo, Xin Dios, ");
INSERT INTO zpt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","lak mkeꞌa profet Isaías sakndoꞌ Dios ndab xa: Unaꞌ, leꞌa naꞌ utuꞌub dub xa yaꞌ ned ndoꞌ lu gudiꞌizh diꞌizh ten naꞌ, ndontsa listla kwe be men gal zha ilen lu. ");
INSERT INTO zpt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Leꞌa xa wa ikeseyadiꞌizh geꞌe sa bid, ugeꞌ gab xa: “Bin parej bega nes ilen Xa Nibeꞌe. Bkeasoꞌ bega nes ten xa.” ");
INSERT INTO zpt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Leꞌa xa wa Juan, xa uyoꞌo geꞌe sa bid. Ulaleaꞌ xa be men len nits, no ndab xa ulaꞌa bexa be ta ugap nak bexa, no italeaꞌ bexa, ndontsa utsuꞌu Dios be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Leꞌa kwaꞌad bexa Jerusalén no bexa idub distrit Judea utoꞌo nchaꞌyoꞌón diꞌizh ten Juan. Leꞌa gor na mgondoꞌ bexa be ke ten bexa, leꞌa Juan cha ulaleaꞌ bexa len nits yowbeꞌe Jordán. ");
INSERT INTO zpt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Leꞌa xab Juan nakndeꞌe gich las came, nsea dub sinch gid nde len xa. Leꞌa xa ndaw mbit, nsea mzhin ser ndo xa. ");
INSERT INTO zpt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndadiꞌizh Juan, ndab xa ndoꞌ be men: —Leꞌa tsoꞌo naꞌ ndee ilen stub xa mas nsak ndoꞌ naꞌ. Leꞌa naꞌ ni lá isayaꞌ kote ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Leꞌa naꞌ nits‑tsa ngoleaꞌ bega, ná leꞌa xa ilen tsoꞌo naꞌ ndee koleaꞌ be men no Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ngol dub wizh leꞌa Jesús utoꞌo gezh Nazaret ten distrit Galilea. Nchaꞌa Jesús sa nsoꞌ Juan, cha ulaleaꞌ Juan Jesús len nits yowbeꞌe Jordán. ");
INSERT INTO zpt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Leꞌa gor na utoꞌo Jesús len nits wa, leꞌa Jesús uniꞌí myaꞌal gibeꞌa. Leꞌa Espíritu ten Dios cuent dub palom nchaꞌlaꞌ sa nsoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","No ulen ti Dios gibeꞌa ndab ndoꞌ Jesús: —Lu nak Xiꞌín naꞌ. Leꞌa naꞌ nkweaꞌ ladna lu, no ntenno lad naꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Leꞌa Espíritu ten Dios cha mbiꞌi Jesús geꞌe bid sa naꞌan men. ");
INSERT INTO zpt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Leꞌa sa wa uyoꞌo Jesús dub top gaꞌal wizh lat be man geꞌe wa. Weꞌe ulen maxuꞌu uzheꞌeb mbin preb Jesús nlad maxuꞌu utsabgix Jesús. Tsoꞌo wa cha ulen be angel ten Dios mlaꞌach bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tsoꞌo na mkeꞌa be men Juan litgiꞌib, leꞌa Jesús cha nseaꞌ leꞌaka Galilea, ukesea uluu xa be men diꞌizh wen ten Dios ná xteꞌe nibeꞌe Dios be men. ");
INSERT INTO zpt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ndab xa: —Leꞌa tiemp yá ngol. Leꞌa zha inibeꞌe Dios ladoꞌo be men yá gax nak. Blaꞌa bego be ta ugap nak bega, no bingea ladna bega diꞌizh wen ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Leꞌa dub gor nchasea Jesús toꞌo lagun siꞌil nsaleaꞌ Galilea, cha uniꞌí xa Simón nsea Ndres wit Simón, ndeutsaꞌab red ten na len nits, leꞌa bexa wa xa nsen mbeal. ");
INSERT INTO zpt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Cha ndab Jesús: —Usankea bega tsoꞌo naꞌ, leꞌa naꞌ uluu xteꞌe yunjunt bega be men ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bi leꞌa gor wa cha mlaꞌa bexa be red ten bexa, cha nchaꞌano bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Weꞌe cha usea bexa stub tuzh sa. Cha uniꞌí Jesús dub xa nsaleaꞌ Jacob nsea stub xa nsaleaꞌ Juan wit Jacob. Leꞌa bexa wa ndiꞌib ndoꞌ dub barco ndego ramient be red ten na. ");
INSERT INTO zpt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cha utezh Jesús itop wit bexa. Leꞌa bexa wa cha mchansoꞌ xus na Zebedeo ndoꞌ barco wa no be mos ten bexa. Leꞌa Jacob no Juan cha nchaꞌano Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Cha uyote bexa len gezh Capernaum. Leꞌa ngol wizh neꞌe be men, leꞌa Jesús cha nchaꞌuluu be men len niꞌi sa nzhealbe bexa judio gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Leꞌa be men wa ndanseana xteꞌe ndadiꞌizh xa, leꞌa ta ndadiꞌizh xa wa nluu leꞌa xa uzheꞌeb ndap juers, naꞌanpa lak nluu be mech ten ley. ");
INSERT INTO zpt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Leꞌa len niꞌi wa nsob dub xabgiꞌi nsak gizh tont ncho mbi bxin len ladoꞌo na. Leꞌa ta wa ugeꞌ ndab ndoꞌ Jesús: ");
INSERT INTO zpt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Xtaꞌan nsea ugal lu besa, Jesús xa Nazaret? ¿Nati nsea unitndoꞌ lu besa zha? Naꞌ uní ton nak lu, leꞌa lu xa umbiꞌi mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Leꞌa Jesús uteyo mbi bxin wa, ndab xa: —¡Kexga lu! ¡Utoꞌo len ladoꞌo xa baꞌ! ");
INSERT INTO zpt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Weꞌe leꞌa mbi bxin wa udabi xabgiꞌi wa, cha utezhat xa, cha utoꞌo mbi bxin wa len ladoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Weꞌe leꞌa itea be men wa ngwanseana, nabdiꞌizh bexa ndoꞌ be ltsaꞌa xa, ndab bexa: —¿Xteꞌe nak ta ndee zha? Leꞌa xa nluu dub taꞌa ni gol goꞌón beuna, no uzheꞌeb ndap xa juers, gast be mbi bxin nxobgek ndoꞌ ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Leꞌa ta li mbin Jesús wa cha uxax mgen idub Galilea. ");
INSERT INTO zpt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Leꞌa gor na utoꞌo bexa len niꞌi wa, leꞌa Jesús nchaꞌano Jacob nsea Juan ta lid Simón nsea Ndres. ");
INSERT INTO zpt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Leꞌa xnazhaꞌap Simón nax ncho xlea. Leꞌa gor na ndab bexa‑yá ndoꞌ Jesús, ");
INSERT INTO zpt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","leꞌa Jesús cha ubii sa nax xa wa, usen xa yaꞌa xa, cha uxiste Jesús xa. Cha bi leꞌa gor wa mtoꞌo xlea xa, cha msaꞌa xa ta gaw bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Leꞌa gor na ngwaꞌasla wizh cha nsea teꞌal, leꞌa be men ulenno kwaꞌadpa bexa gizh nsea bexa nsak gizh tont ncho mbi bxin len ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Leꞌa idub gezh men myakjunt toꞌo niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Leꞌa Jesús myunyakna kwaꞌadpa be men nsén isandoꞌ gealgizh, nsea ulantuꞌub Jesús be mbi bxin ncho len ladoꞌo be men wa. Lá ulaꞌa xa ngudiꞌizh be mbi bxin, geal leꞌa be ta wa uniꞌí ton nak Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ngol gor bi teꞌalta leꞌa Jesús ngwaste, cha nchaꞌa xa dub sa naꞌan men, sa na ngwaꞌyadiꞌizhno xa Dios. ");
INSERT INTO zpt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Leꞌa Simón no stapla bexa utoꞌo nchaꞌkwaꞌan Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ná gor na mzheal bexa Jesús, cha ndab bexa ndoꞌ xa: —Leꞌa be men weꞌe itea nkwaꞌan ga. ");
INSERT INTO zpt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Leꞌa Jesús cha ndab: —Nchaꞌbe beuna be gezh gax ndee. Uluꞌu naꞌ be men, leꞌa naꞌ tiꞌin weꞌe ndal ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Weꞌe leꞌa Jesús cha nchasea be gezh idub distrit Galilea, nluu xa be men len be niꞌi sa nzhealbe bexa judio, nsea ulantuꞌub Jesús be mbi bxin ncho len ladoꞌo be men. ");
INSERT INTO zpt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Leꞌa dub wizh ulen dub xabgiꞌi wats Jesús, dub xa nsaꞌgea las na, leꞌa ta wa dub gealgizh nsaleaꞌ lepra. Cha msaxib xa ndoꞌ Jesús, ndab xa: —Tal go nlad yunyakna go naꞌ, leꞌa naꞌ uní leꞌa ga sunka gan. ");
INSERT INTO zpt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Leꞌa Jesús cha mlats ladna xa wa, cha mxoꞌob Jesús yaꞌa na tsoꞌo xa wa. Cha ndab Jesús: —Nladka naꞌ yakna lu. Nat myakna lu. ");
INSERT INTO zpt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bi leꞌa gor wa leꞌa gealgizh wa cha unitndoꞌ, cha myakna las xa. ");
INSERT INTO zpt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Weꞌe leꞌa Jesús cha unibeꞌe ndoꞌ xa, ndab Jesús: —Nat syoꞌo gan yaꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Naꞌan ton ndoꞌ ná gudiꞌizh lu xteꞌe myakna lu. Dubgaꞌal ndoꞌ uleꞌay waꞌ uluu las lu, leꞌa lu myaklana. Nsea biꞌi be man xnab lak nibeꞌe ley mkeꞌa Moisés usaꞌa be men zha nyakna bexa, ndontsa iniꞌí be men leꞌa lu myaklana. ");
INSERT INTO zpt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ná leꞌa nes nseaꞌ xabgiꞌi wa, usaxan ndadiꞌizh xa ndoꞌ be men xteꞌe myunyakna Jesús xa. Ta weꞌe leꞌa Jesús lá yoota gan gaꞌal yate ni dub len gezh wa. Sbeꞌen dub lad sa naꞌan men ukesea xa, ná leꞌa be men itea lad utoꞌo nchaꞌbeka wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngok stapla wizh mtanchaꞌgal Jesús gezh Capernaum. Weꞌe mbiꞌín be men pa niꞌi na ncho Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Cha uxax mzhealbe kwaꞌad men sa wa, gast ni toꞌo niꞌi wa lá ugalta kwe be men. Cha mluu Jesús bexa diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Leꞌa gor wa ulayaꞌ dap men nchaꞌano dub xabgiꞌi gizh lá yoo gan isea. ");
INSERT INTO zpt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ná leꞌa tant kwaꞌad be men nde sa wa, leꞌa bexa lá yoꞌo gan ibii wats Jesús. Cha ndi ukea bexa gek niꞌi wa, mxaꞌal bexa‑yá gaꞌal‑la sa nsoꞌ Jesús. Cha mlaꞌko bexa yaloꞌon nax xa gizh wa ndoꞌ na. ");
INSERT INTO zpt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Leꞌa Jesús mnaꞌla leꞌa bexa mgeꞌ ladna leꞌa Jesús sun gan yunyakna xa gizh wa. Cha ndab Jesús ndoꞌ xa: —Amig, leꞌa be ke ten lu myuꞌula. ");
INSERT INTO zpt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ná leꞌa be mech ten ley ndebe sa wa cha mbinbeꞌebe: ");
INSERT INTO zpt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Xtaꞌan ngi li ndab xa ndee zhaga? Leꞌa ta ndab xa uzheꞌeb dub ta lá nsak ladna Dios. ¿Ton isuꞌu utsuꞌu be ke ten be men zha? Nabtsa Dios suꞌu.” ");
INSERT INTO zpt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ná leꞌa Jesús cha mgenna xteꞌe ndanbeꞌe bexa wa. Cha ndab Jesús: —¿Xtaꞌan lbaꞌa ndanbeꞌe bega zha? ");
INSERT INTO zpt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Xtaꞌan mas lid bid gáp naꞌ ndoꞌ xa gizh ndee, leꞌa ke ten xa myuꞌula, nati gáp naꞌ gaste xa, cha kob xa yaloꞌon ten xa, cha isea xa? ");
INSERT INTO zpt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Leꞌa nat iniꞌí bega leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, no syoꞌo gan utsuꞌu be ke ten be men. Cha ndab Jesús ndoꞌ xa gizh wa: ");
INSERT INTO zpt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Gáp naꞌ ndoꞌ lu goste, cha udob yaloꞌon ten lu baꞌ, cha byaꞌ ta lid lu. ");
INSERT INTO zpt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Leꞌa xa wa uxax ngwaste, cha udob xa yaloꞌon ten xa. Cha utoꞌo xa sa wa ndoꞌ gaꞌal iteanak be men. Leꞌa itea bexa nde sa wa ngwanseana, ndab bexa leꞌa Dios uzheꞌeb dub Dios juert, no ndab bexa: —Ta ndee dub ta nunk beuna gol niꞌí. ");
INSERT INTO zpt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsoꞌo wa nchaꞌagal Jesús toꞌo lagun wa. Leꞌa kwaꞌad men ulen wats Jesús, cha mluu Jesús bexa diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Leꞌa sa nchaꞌtid Jesús wa uniꞌí Jesús dub xabgiꞌi nsaleaꞌ Leví xin Alfeo. Leꞌa Leví wa nsobyun tiꞌin nsen xa med nkix be men ndoꞌ gobier Roma. Cha ndab Jesús: —¡Utsea! ¡Usankea tsoꞌo naꞌ! Leꞌa Leví cha ngwasoꞌ, cha usankea xa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ngol tsoꞌo wa leꞌa Jesús nsea be xmen xa ngwaꞌdaw ta lid Leví. No kwaꞌad be men nchaꞌano Jesús sa wa, bexa ndun ltsaꞌa tiꞌin mbin Leví, nsea kwaꞌadta bexa na ndab be men ugap nak bexa. ");
INSERT INTO zpt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Leꞌa gor uniꞌí be mech ten ley no bexa fariseo leꞌa Jesús nsobyawno bexa ugap no bexa nsen med, cha weꞌe unabdiꞌizh bexa ndoꞌ be xmen Jesús, ndab bexa: —¿Xtaꞌan ndawno Jesús bexa nsen med baꞌ no iteata bexa ugap baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Leꞌa gor na mbiꞌín Jesús ta wa, cha ndab Jesús ndoꞌ bexa wa: —Leꞌa be men naꞌanpa gizh lá nkiꞌin doctor, ndi leꞌa xa gizh nkiꞌinka xa wa. Leꞌa naꞌ naꞌanpa ndalteꞌezh bexa ndanbeꞌe leꞌa lá ndap ke; naꞌ ndi ndalteꞌezh bexa ngondoꞌ leꞌa ndap ke. ");
INSERT INTO zpt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Leꞌa be xmen Juan nsea be xmen bexa fariseo ncho be wizh lá ndaw bexa ndontsa mas yankea bexa Dios. Weꞌe ngol dub wizh leꞌa pla be men ndab ndoꞌ Jesús: —Leꞌa be xmen Juan nsea be xmen bexa fariseo ncho wizh lá ndaw bexa. Ná leꞌa be xmen ga zha, ¿xtaꞌan lid no bexa li ndun ta wa? ");
INSERT INTO zpt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Leꞌa Jesús cha ukaꞌab ndab: —¿Nsak bega zha leꞌa dub sa nchilyaꞌa men leꞌa bexa nde sa wa lá nsabndoꞌ gaw, zha bi ncho xabgiꞌi mchilyaꞌa wa? ");
INSERT INTO zpt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Parea gal dub wizh leꞌa be men goꞌo xabgiꞌi mchilyaꞌa wa. Weꞌe leꞌa bexa nde sa wa lá gaw dub tiemp. ");
INSERT INTO zpt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Naꞌan ton ngo ramient lad gox nsea dub bleꞌa lad kub. Tal leꞌa xa li gun, leꞌa lad kub wa syaꞌad, cha ndi mas stsaw‑a lad gox wa. ");
INSERT INTO zpt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","No naꞌan ton ngo vin kub len dub bols gid gox. Tal leꞌa xa li gun leꞌa bich ten vin kub stsaw bols gid gox wa. Leꞌa vin wa cha ibid stsiꞌi no sazhaꞌa bols gox wa. Leꞌa vin kub wa nsabndoꞌ yoo len bols gid kubga. ");
INSERT INTO zpt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Leꞌa ngol dub wizh neꞌe be men leꞌa Jesús nchaꞌtid sa nax dub bleꞌa yo ncho trig. Leꞌa be xmen Jesús cha uxeꞌe pla be bid ten trig. ");
INSERT INTO zpt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Leꞌa ncho bexa fariseo cha ndab ndoꞌ Jesús: —Unaꞌ go, ¿xtaꞌan lbaꞌa ndun bexa baꞌ, ta na lá nsabndoꞌ gun bexa wizh neꞌe beuna zha? ");
INSERT INTO zpt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ná leꞌa Jesús cha ndab: —¿Ni lá ndoꞌol bega sa ndab diꞌizh ten Dios ta na mbin David dub biaj, zha na uzhebpa ndanna xa no bexa ndeseano xa zha? ");
INSERT INTO zpt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Leꞌa David uyoꞌo len niꞌilad ten Dios, zha na ngok Abiatar uleꞌay ndon leꞌa nsak, cha udaw xa be pan leꞌay, ta lá nsabndoꞌ gaw dub men naꞌanpa nak uleꞌay. No msaꞌa xa‑yá ndoꞌ bexa ndeno xa. ");
INSERT INTO zpt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","No ndab Jesús ndoꞌ bexa: —Leꞌa Dios msaꞌa wizh neꞌe be men ndontsa gakno‑yá be men. Naꞌanpa mbindeꞌe Dios be men yankea bexa wizh wa. ");
INSERT INTO zpt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ta weꞌe leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, noga nibeꞌe wizh neꞌe beuna. ");
INSERT INTO zpt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Leꞌa stub wizh uyoꞌo Jesús len niꞌi sa nzhealbe bexa judio gezh wa. Leꞌa sa wa nsob dub xabgiꞌi ubidya dub yaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Weꞌe leꞌa ncho bexa ndeulaꞌach naga syunyakna Jesús xa gizh wa wizh neꞌe be men, ndontsa ta weꞌetsa usake bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Leꞌa Jesús cha ndab ndoꞌ xa gizh yaꞌa na wa: —Gosoꞌ, cha usoꞌ tlaw ndee. ");
INSERT INTO zpt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Leꞌa Jesús cha ndab ndoꞌ be men wa: —¿Leꞌa wizh neꞌe beuna nsabndoꞌ gun beuna ta wen nati gun beuna ta ugap? ¿Gakno beuna dub xa nati ulaꞌa beuna gat xa? Ná leꞌa be men wa ni lá ikaꞌabbe. ");
INSERT INTO zpt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Weꞌe leꞌa Jesús ndakloo mwiꞌi ndoꞌ be men nde gangeak, cha uban myoꞌo ladna Jesús tant ngud nak ladoꞌo bexa. Cha ndab Jesús ndoꞌ xa na gizh yaꞌa na wa: —Bkea yaꞌa lu. Leꞌa xa wa cha mkea yaꞌa na, cha uxax myakna‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Leꞌa bexa fariseo cha nseaꞌbe, cha mzhealbe bexa nsea be xmen Herodes, mbidiꞌizh bexa ná xteꞌe gun bexa gan gat Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Leꞌa Jesús cha nchaꞌagal toꞌo lagun nsea be xmen xa. Weꞌe kwaꞌad bexa Galilea usankea tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Leꞌa gor na mbiꞌín be men xteꞌe mbidiꞌizh Jesús nsea xteꞌe myunyakna Jesús be men, weꞌe kwaꞌadpa bexa ulayaꞌ wats Jesús, bexa utoꞌo Jerusalén nsea distrit Judea nsea distrit Idumea nsea stub toꞌo yowbeꞌe Jordán nsea gezh Tiro no gezh Sidón. ");
INSERT INTO zpt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cha ndab Jesús ndoꞌ be xmen na: —List uteno bega dub barco, ndontsa lá kidko be men naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Leꞌa Jesús myunyaklana kwaꞌad be men, ta weꞌe itea bexa gizh nsiꞌi be ltsaꞌa na, ndontsa ugal bexa masa xab Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Leꞌa be men ncho mbi bxin len ladoꞌo na wa, gor uniꞌí bexa Jesús cha msaxib bexa ndoꞌ Jesús, ugeꞌ ndab be mbi bxin wa: —¡Go nak Xin Dios! ");
INSERT INTO zpt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ná leꞌa Jesús cha uzheꞌeb uteyo be mbi bxin, ndontsa lá gab be mbi bxin ton nak Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsoꞌo wa leꞌa Jesús ukea dub bet, cha utezh xa bexa mti xa. Leꞌa bexa wa cha ulayaꞌ wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cha ndab Jesús ndoꞌ isatibtop bexa wa: —Leꞌa bega gak xa ikeseano naꞌ nsea bexa utuꞌub naꞌ yaꞌbe uluu be diꞌizh ten Dios ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nat leꞌa bega gap diꞌizh yunyakna men gizh no kontuꞌub bega be mbi bxin. ");
INSERT INTO zpt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Leꞌa bexa wa lndeꞌe nsaleaꞌ: Simón xa msaleaꞌ Jesús Pedr, ");
INSERT INTO zpt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nsea Jacob no Juan wit Jacob be xin Zebedeo (Jesús msaleaꞌ itop wit xa wa “Boanerges”, dub diꞌizh gab: cuent níꞌi usiꞌi). ");
INSERT INTO zpt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nsea Ndres, nsea Julip, nsea Bartol, nsea Mateo, nsea Tomás, nsea Jacob xin Alfeo, nsea Tadeo, nsea Simón xa partid Caná, ");
INSERT INTO zpt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nsea Judas Iscariot, xa na leꞌa myun cuent Jesús tsoꞌo wa. Leꞌa bexa wa cha uyoꞌo len dub niꞌi. ");
INSERT INTO zpt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Weꞌe leꞌa kwaꞌad be men ulen gast ni lá yoo gan gaw Jesús nsea be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Leꞌa gor na mbiꞌín xnaꞌa Jesús nsea be wit Jesús leꞌa be men ndadiꞌizh leꞌa Jesús myak tont, weꞌe cha utoꞌo bexa nchaꞌyoꞌo bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Leꞌa sa wa ndebe pla mech ten ley utoꞌo Jerusalén. Leꞌa bexa wa ndab: —Leꞌa Jesús ndap Beelzebú maxuꞌu na nibeꞌe be mbi bxin. Juers weꞌe ngontuꞌub Jesús be mbi bxin wa. ");
INSERT INTO zpt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Leꞌa Jesús cha utezh bexa wa, cha ndab xa: —¿Syoꞌo gan kontuꞌub dub maxuꞌu leꞌaka maxuꞌu zha? ");
INSERT INTO zpt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tal be xmen dub xa nibeꞌe yak top partid, cha bi leꞌakaga bexa kuyo, leꞌa bexa wa yá naꞌantapa gak juertbe. ");
INSERT INTO zpt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","No tal be men ncho dub niꞌi bi leꞌakaga kuyobe, leꞌa bexa wa iteltsaꞌabe. ");
INSERT INTO zpt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","No liga tal leꞌa maxuꞌu kuyono leꞌaka be mbi bxin ten na, leꞌa maxuꞌu wa lá yoota gan gak juert, no cha snitndoꞌ maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’No naꞌan ton gun gan yate len lid dub xabgiꞌi juert kowaꞌan be taꞌa len niꞌi, tal leꞌa xa lid ned uxi xabgiꞌi wa. Lima syoꞌo gan kowaꞌan xa be taꞌa len lid xa juert wa. ");
INSERT INTO zpt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Leꞌa naꞌ gáp ndoꞌ bega leꞌa itea be ta kweaꞌ níꞌi be men no iteata be ta ugap ndun bexa, leꞌa Dios sungeꞌka ladna ta wa. ");
INSERT INTO zpt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ná leꞌa tal ton inisi Espíritu ten Dios, leꞌa Dios lá gungeꞌ ladna ke wa, leꞌa ta wa dub ke nunk lá yuꞌuta. ");
INSERT INTO zpt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Leꞌa ta wa ndab Jesús geal leꞌa be mech ten ley ndab leꞌa Jesús ndap dub mbi bxin. ");
INSERT INTO zpt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Weꞌe leꞌa xnaꞌa Jesús nsea be wit Jesús ulen, cha ute bexa tsoꞌo juertsa. Cha mtuꞌub bexa dub men nchaꞌtezh Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Leꞌa bexa nde wats Jesús cha ndab ndoꞌ xa: —Leꞌa xnaꞌa go nsea be wit go nde tsoꞌo juer ndee, nkwaꞌan bexa go. ");
INSERT INTO zpt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp ndoꞌ bego ná ton xa na ta ugeaka nak xnaꞌa naꞌ nsea be wit naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Weꞌe cha mwiꞌi Jesús ndoꞌ bexa ndebe sa wa. Cha ndab xa: —Leꞌa bega nde ndee nak xnaꞌa naꞌ no wit naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Leꞌa itea bexa ndun lak nlad Dios, leꞌa bexa wa nak cuent wit naꞌ no bsan naꞌ no xnaꞌa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Leꞌa stub biaj usaxan nluu Jesús be men toꞌo lagun Galilea. Weꞌe leꞌa kwaꞌadpa be men ulen wats xa, cha ukea xa ndoꞌ dub barco nde ndoꞌ nits, cha usob xa. Leꞌa itea be men wa utebe ndoꞌ yo bid toꞌotsa nits wa. ");
INSERT INTO zpt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cha sian taꞌa mluu xa msaktabeꞌe xa be taꞌa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Blaꞌach bego, leꞌa dub xabgiꞌi ndun tiꞌin geꞌe utoꞌo nchaꞌutob bid ten trig ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Leꞌa gor na mteꞌach xa‑yá, ncho‑yá ulate toꞌo nes. Leꞌa be migin cha ulen cha udaw‑a. ");
INSERT INTO zpt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","No ncho‑yá ulate ndoꞌ yo geꞌ, sa uxee yo. Leꞌa ná wa uxax ulen, ");
INSERT INTO zpt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","parea ngol gor na mnaꞌ bea, leꞌa ná wa cha mgoꞌol, cha ubid‑a geal leꞌa‑yá naꞌanpa wat ndiꞌib loꞌ na. ");
INSERT INTO zpt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","No ncho‑yá ulate lat be gix nsoꞌ gich. Ngol gor leꞌa gix wa uzheꞌeb ngoꞌol, cha ulo xleaꞌ‑yá. Cha naꞌanpa usaꞌa‑yá bid. ");
INSERT INTO zpt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Parea ncho‑yá ulate sa utaꞌa yo. Leꞌa be ná wa ulen cha ngoꞌol‑a, cha msaꞌa‑yá sian bid. Ncho be trig wa msaꞌa dub galntiꞌi bid. No ncho‑yá msaꞌa dub chon gaꞌal bid. No ncho‑yá msaꞌa dub gayoꞌoga bid. ");
INSERT INTO zpt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bego na ndap nchaꞌ na, blaꞌach bega ta ndáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Leꞌa gor na myanbe isatibtop xmen Jesús nsea stapla bexa, weꞌe unabdiꞌizh bexa ndoꞌ Jesús ndab bexa: —¿Xtaꞌan gab ta msaktabeꞌe go cuent ten xa ndas trig wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Leꞌa Jesús cha ndab: —Leꞌa Dios nsaꞌa ta yakbeꞌena bega be ta ugaꞌach cuent ten xteꞌe nibeꞌe Dios. Parea ndoꞌ bexa xaꞌaga, sbeꞌen nsaktabeꞌe naꞌ be taꞌa gor ndadiꞌizh naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Leꞌa bexa nwiꞌi, ná leꞌa bexa lá iniꞌí xtaꞌan‑a. No ndoꞌón bexa ta ndáp naꞌ, ná leꞌa bexa ni lá yakbeꞌena‑yá. Weꞌe lá yach bexa wats Dios, no lá utsuꞌu Dios be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","No ndab Jesús: —¿Lá nyakbeꞌena bega ta msaktabeꞌe naꞌ wa zha? ¿Xteꞌexá yakbeꞌena bega itea be ta uluu naꞌ zhaga? ");
INSERT INTO zpt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Leꞌa xa nteꞌach trig wa nak cuent xa ndadiꞌizh diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Leꞌa toꞌo nes sa ulate bid ten trig wa nak cuent be men ndoꞌón diꞌizh ten Dios, parea cha nlen maxuꞌu cha ngoꞌo maxuꞌu diꞌizh wa len ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Leꞌa yo geꞌ sa ulate bid wa nak cuent bexa nten ladna ndoꞌón diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ná leꞌa bexa wa nak cuent dub ya trig lá ndap sian loꞌ na. Ndangea ladna bexa diꞌizh ten Dios dub ndeꞌep, ná leꞌa gor na juert ncho bexa geal ndangea ladna bexa diꞌizh wa, cha nlaꞌa bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Leꞌa yo ncho gix nsoꞌ gich wa nak cuent bexa na ndoꞌón diꞌizh ten Dios, ");
INSERT INTO zpt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ná leꞌa bexa nyuꞌ ladna be taꞌa ndoꞌ gizhliyo ndee, no ngeꞌ ladna bexa be taꞌa siantsa ndap xa, no nsaꞌab ladna bexa sianta taꞌa gap bexa. Ta weꞌe leꞌa bexa wa cuent dub ya trig naꞌan xtaꞌan usaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ná leꞌa sa utaꞌa yo wa nak cuent bexa ndoꞌón diꞌizh ten Dios, cha ndangea ladna xa‑yá idub ncho ladna xa. Leꞌa bexa wa wen nak cuentla be ya trig nsaꞌa dub galntiꞌi bid no dub chon gaꞌal bid no dub gayoꞌoga bid. ");
INSERT INTO zpt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","No ndab Jesús: —¿Ncho ton nsob dub xeꞌa len dub caj zha? ¿Nati ncho xa nsob‑a xan dub loꞌon? ¿Lid nsob xa xeꞌa dub sa gaꞌap, ndontsa usu‑yá xeꞌa itea lad? ");
INSERT INTO zpt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Leꞌa itea be ta ugaꞌach, leꞌa gal gor leꞌa be ta wa uluukabe. No iteanak be ta ngachyoꞌo, leꞌa gal gor itoꞌo‑yá ndoꞌ xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bego na ndap nchaꞌ na, blaꞌach bega ta ndáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","No ndab Jesús: —Blaꞌach bega ta ndáp naꞌ ndee. Bi lak ulaꞌach bega‑yá, bi liga mas yakbeꞌena bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Leꞌa bexa nyakbeꞌena, leꞌa Dios gun mas yakbeꞌena bexa. Ná leꞌa bexa na lá nyakbeꞌena, leꞌa Dios slat ta na nsak bexa nyakbeꞌena bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nsea ndab Jesús ndoꞌ be men: —Leꞌa lak nibeꞌe Dios be men nak cuent dub xabgiꞌi ndas trig ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Guniꞌi tal naxyats xa natal nsobnaꞌ xa leꞌa trig wa teꞌal tezhea ndiꞌibyaꞌalka. ");
INSERT INTO zpt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leꞌa trig wa juers ten yotsa nsaꞌa bid. Ndon ned lak ya wa nlen, weꞌe cha ndach ta ben ndoꞌ ya wa, cha nyak‑a bid ten trig. ");
INSERT INTO zpt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Leꞌa zha na ngugal trig wa, cha ixen xa trig no dub os, geal leꞌa zha ibeleꞌe trig wa yá ngol. ");
INSERT INTO zpt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","No ndab Jesús: —¿Xtaꞌan dub taꞌa nak lak nibeꞌe Dios be men? ¿Xtaꞌanma dub taꞌa usaktabeꞌe beuna‑yá? ");
INSERT INTO zpt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Leꞌa ta wa nak cuent ta ndasea dub bid ten mostas. Leꞌa gor na ndas dub men‑a leꞌa‑yá dub bid ndon leꞌa tuzh ndoꞌ itea be bid ncho ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ná leꞌa tsoꞌo na ndas xa‑yá, leꞌa‑yá ndaꞌal cuent dub ya siꞌil, mas siꞌil ndoꞌ itea be ta xgeꞌa ndas be men, gast be migin syoꞌo gan ukal lat be xos‑a. ");
INSERT INTO zpt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Leꞌa Jesús li msaktabeꞌe sian taꞌa gor nluu xa diꞌizh ten Dios, lak yakbeꞌena bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sbeꞌen msaktabeꞌe xa be taꞌa gor ndadiꞌizh xa ndoꞌ be men, parea ndal gor nyak nab Jesús no be xmen xa, weꞌe uyaꞌal ndadiꞌizh xa ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Leꞌa ngol gor na nsea teꞌal, leꞌa Jesús ndab ndoꞌ be xmen na: —Nchaꞌbe beuna stub toꞌo lagun ndee. ");
INSERT INTO zpt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Cha mlaute bexa be men ndebe sa wa. Cha nchaꞌbe bexa bi laktsa ndiꞌib bexa ndoꞌ barco wa. Nsea stapla barco junt nchaꞌano bexa. ");
INSERT INTO zpt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ngol gor leꞌa ndoꞌ nits wa ulen dub mbi siꞌil. Leꞌa golp ten nits wa gast len barco nyoꞌola, ngi slaꞌko‑yá barco len nits. ");
INSERT INTO zpt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ná leꞌa Jesús ndi naxyats dub xan len barco wa, nsea dub lad ncho xan gen xa. Weꞌe leꞌa be xmen xa mkwaꞌan xa, ndab bexa: —¡Mech! ¿Lá nyuꞌ ladna go leꞌa beuna ngi sat? ");
INSERT INTO zpt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Leꞌa Jesús cha ngwaste, cha uteyo xa mbi wa, ndab xa ndoꞌ nits wa: —¡Kexga lu! ¡No xe ute! Leꞌa mbi wa cha uleas, cha ndon xe ute nits wa. ");
INSERT INTO zpt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Weꞌe leꞌa Jesús cha ndab ndoꞌ be xmen na: —¿Xtaꞌan lbaꞌa nzheb bega zha? ¿Xtaꞌan lá ndangea ladna bega naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Leꞌa bexa wa mzhebbe, ndabbe ndoꞌ ltsaꞌa na: —¿Tonxá xa ndee zhaga, gast mbi nsea nits nxobgek ndoꞌ diꞌizh ten xa? ");
INSERT INTO zpt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Cha ulayaꞌ bexa stub toꞌo lagun wa ndoꞌ yo sa nibeꞌe gezh Gadara. ");
INSERT INTO zpt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Leꞌa gor ulaꞌ Jesús ndoꞌ barco wa, leꞌa dub xabgiꞌi ncho mbi bxin len ladoꞌo xa utoꞌo lat be geꞌloꞌo sa ngaꞌach be men ngut. ");
INSERT INTO zpt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Leꞌa xabgiꞌi wa len geꞌloꞌo ten kampeon wa nak lid na. Ni caden lá ndun bexa gan uxi bexa xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sianla biaj mxi bexa yaꞌa xa nsea caden, no giꞌib nkeꞌanchii bexa xoꞌo xa. Ná xa nkixka caden wa nsea nsuka xa giꞌib wa. Ta weꞌe naꞌan ton ndun gan uxi xa. ");
INSERT INTO zpt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Teꞌal tezhea nkeseabezhat xa be geꞌe no sa ngaꞌach be men wa. No geꞌ nkeꞌa xa leꞌaka las xa. ");
INSERT INTO zpt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gor na bi sitta uniꞌí xa Jesús leꞌa xa wa utoꞌola karrel gast ndoꞌ Jesús msaxib xa. ");
INSERT INTO zpt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Cha ugeꞌ ndab mbi bxin wa ndoꞌ Jesús: —¿Xtaꞌan ngi naꞌ nsea ugal lu zha Jesús, Xin Dios siꞌil? ¡Leꞌa Dios nsobwiꞌi leꞌa naꞌ naꞌab naꞌanpa utsaksi lu naꞌ! ");
INSERT INTO zpt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Leꞌa mbi bxin wa leꞌa li ndab, geal leꞌa Jesús unibeꞌela ndoꞌ mbi bxin itoꞌo len ladoꞌo xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Leꞌa Jesús cha unabdiꞌizh ndab: —¿Xteꞌe nsaleaꞌ lu zha? Leꞌa mbi bxin wa cha ndab: —Naꞌ nsaleaꞌ Uzheꞌeb Kwaꞌad Xa, geal leꞌa besa kwaꞌadpa. ");
INSERT INTO zpt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Weꞌe cha uzhebpa unab mbi bxin wa ndoꞌ Jesús ndab ta wa: —Lá kontuꞌub lu besa sa ndencho besa ndee. ");
INSERT INTO zpt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Leꞌa gax geꞌe wa kwaꞌad kuch ndeseayawbe. ");
INSERT INTO zpt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Leꞌa be mbi bxin wa cha ndab ndoꞌ Jesús: —Btuꞌub besa yate besa len be kuch baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Weꞌe leꞌa Jesús cha msaꞌa diꞌizh li gun be mbi bxin. Leꞌa be ta wa cha utoꞌo len ladoꞌo xabgiꞌi wa, cha uyoꞌo be ta wa len be kuch wa. Cha ubix bema gek dub weꞌa gast len nits ulaꞌyoꞌo ma, cha ngut bema. Leꞌa ndoꞌ itea be kuch wa pa top mil ma. ");
INSERT INTO zpt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Weꞌe leꞌa be men nkeno be kuch wa cha utoꞌo karrel nchaꞌyab‑a ndoꞌ be men ndesea geꞌe nsea be men gezh. Leꞌa kwaꞌad be men cha utoꞌo nchaꞌbewiꞌi ná xtaꞌan uyoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Leꞌa gor ulayaꞌ bexa wats Jesús, leꞌa bexa cha uniꞌí xa na li utoꞌo mbi bxin len ladoꞌo na wa myaklana nsob wats Jesús, nakla xa xab xa. Cha mzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Leꞌa bexa na uniꞌí ta uyoꞌo wa cha mbidiꞌizh ndoꞌ be men wa xteꞌe myakna xa wa, nsea xteꞌe ngut be kuch wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Leꞌa bexa wa cha unab ndoꞌ Jesús ikaꞌan Jesús ndoꞌ yo ten bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Leꞌa gor na ukeagal Jesús ndoꞌ barco, leꞌa xa li myakna wa cha unab ndoꞌ Jesús no yaꞌno Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ná leꞌa Jesús lá kaꞌab goꞌo xa, ndi ndab Jesús ndoꞌ xa: —Byaꞌ ndoꞌ bexa ta lid lu. Cha bidiꞌizh ná xteꞌe myunyakna Dios lu, no xteꞌe mlats ladna Dios lu. ");
INSERT INTO zpt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Leꞌa xa wa cha nseaꞌ, cha usaxan ndadiꞌizh xa ndoꞌ bexa idub distrit Decápolis xteꞌe myunyakna Jesús xa. Weꞌe leꞌa itea be men wa ngwanseanabe. ");
INSERT INTO zpt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Leꞌa gor na myach Jesús len barco wa nseaꞌ xa stub toꞌo lagun wa, leꞌa uzhebpa kwaꞌad men ulen wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cha no ulen dub xabgiꞌi nsaleaꞌ Jairo, xa nchansu niꞌi sa nzhealbe bexa judio gezh wa. Leꞌa gor na uniꞌí xa Jesús, cha msaxib xa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Cha unab xa ndoꞌ Jesús, ndab xa: —Leꞌa meꞌed gots ten naꞌ yamer gat. Waꞌ una uxoꞌob ga yaꞌa ga tsoꞌo meꞌed wa, ndontsa yakna meꞌed, lá gat meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Leꞌa Jesús cha nchaꞌano xa, nsea kwaꞌad be men usankea tsoꞌo bexa gast ngidko bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Leꞌa lat be men wa nchaꞌa dub xagots nsén gealgizh nleꞌa xa ten idub dub tibtopla liꞌin. ");
INSERT INTO zpt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Leꞌa xa wa uzheꞌeb ukesea ndoꞌ kwaꞌad be doctor, gast mteꞌa xa iteanak med ndap xa. Ná leꞌa xa ni lá yakna, ndi mas kweaꞌ nsak xa. ");
INSERT INTO zpt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Leꞌa gor na mbiꞌín xa ndadiꞌizh be men xteꞌe ndun Jesús, weꞌe cha ubii xa ndi tsoꞌo Jesús lat be men wa. Cha mgal xa xab Jesús, ");
INSERT INTO zpt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","geal leꞌa xa mbinbeꞌe tal xa ugal masa xab Jesús, leꞌa xa syakkana. ");
INSERT INTO zpt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cha bi leꞌa gor wa uleaslaꞌ ten wa, cha mgenna xa leꞌa xa myaklana ndoꞌ gealgizh wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Weꞌe leꞌa Jesús mgenna utoꞌo dub tuzh juers ten na, cha mgeak Jesús mwiꞌi ndoꞌ be men, ndab xa: —¿Ton xa mgal xab naꞌ? ");
INSERT INTO zpt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Leꞌa be xmen Jesús ndab: —Unaꞌ go leꞌa be men kwaꞌad baꞌ leꞌa ngidko ga, ¿ná xtaꞌan ndab go ná ton mgal xab ga zha? ");
INSERT INTO zpt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ná leꞌa Jesús nwiꞌika gangeak ná ton mgal xab xa. ");
INSERT INTO zpt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Leꞌa xagots wa nxis tant nzheb xa, geal leꞌa xa uniꞌí xtaꞌan mbin xa. Cha ubii xa msaxib xa ndoꞌ Jesús, cha ndab xa idub gealngea xtaꞌan mbin xa. ");
INSERT INTO zpt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Leꞌa Jesús cha ndab ndoꞌ xa: —Xagots, leꞌa ta na mgeꞌ ladna lu naꞌ wa, ta weꞌe myakna lu. Nat byaꞌ cha bten ladna lu, leꞌa lu myaklana ndoꞌ gealgizh wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ndalen li nsoꞌyadiꞌizh Jesús, ulen pla bexa utoꞌo ta lid Jairo, ndab dub xa wa ndoꞌ Jairo: —Leꞌa xingots ga ngutla. Yá naꞌantapa goꞌo ga mech baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ná leꞌa gor na mbiꞌín Jesús ta li ndab xa wa, cha ndab Jesús ndoꞌ Jairo: —Lá izheb lu. Bingeatsa ladna lu naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Weꞌe leꞌa Jesús lá ngoꞌo itea be men wa. Nabtsa Pedr no Jacob no Juan wit Jacob mbiꞌi Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gor na ulayaꞌ bexa ta lid Jairo, leꞌa Jesús uniꞌí xteꞌe nbezhat bexa no ndeyoꞌon bexa. ");
INSERT INTO zpt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Cha uyoꞌo Jesús len niꞌi wa, cha ndab xa: —¿Xtaꞌan lbaꞌa ndun bega ruid nsea ndeyoꞌon bega zha? Leꞌa meꞌed baꞌ naꞌanpa ngut, leꞌa meꞌed baꞌ ga naxyats‑tsa. ");
INSERT INTO zpt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Leꞌa be men wa ndi nxiꞌidno Jesús. Leꞌa Jesús cha ndab ndoꞌ bexa: —¡Utate itea bega sa ndee! Cha mbiꞌi Jesús xustsa meꞌed no xnaꞌatsa meꞌed nsea yontsa be xmen Jesús wa. Cha uyoꞌo bexa len sa nchoꞌob meꞌed wa. ");
INSERT INTO zpt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Weꞌe leꞌa Jesús cha usen yaꞌa meꞌed, cha ndab xa: —Talita kumi —leꞌa ta wa dub diꞌizh gab: Meꞌed gots, naꞌ gáp ndoꞌ lu, goste. ");
INSERT INTO zpt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Leꞌa meꞌed wa cha mban no usaxan nkesea meꞌed. Leꞌa be men ndebe sa wa ngwanseanabe. Leꞌa meꞌed wa ncho dub tibtop liꞌin. ");
INSERT INTO zpt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Weꞌe leꞌa Jesús cha ndab ndoꞌ bexa: —Naꞌanpa gudiꞌizh bega ta ndee. Nat bsaꞌa bega ta gaw meꞌed gots baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Leꞌa Jesús nsea be xmen xa cha utoꞌo sa wa, nseaꞌ xa Nazaret sa ngoꞌol xa. ");
INSERT INTO zpt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ngol dub wizh neꞌe be men leꞌa Jesús cha nluu bexa len niꞌi sa nzhealbe bexa wa. Weꞌe kwaꞌad be men ndanseana xteꞌe ndadiꞌizh Jesús, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Pama ngwaꞌloꞌo xa ndee be diꞌizh lbaꞌata nluu xa baꞌ zha? ¿Pa mtsid xa be ta ndák xa baꞌ zha? ¿No xteꞌema ndun xa be uyon wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Naꞌanpa xa ndee xa carpinter, xin Marí wa zha? ¿No naꞌanpa wit xa Jacob no Kosé no Judas no Simón zha? ¿No naꞌanpa be bsan xa ncho lat beuna gezh ndee zha? Ta weꞌe naꞌanpa isakyoꞌón bexa ta ndab Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ná leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa be men ndap mod ndoꞌ dub xa ndadiꞌizh sakndoꞌ Dios. Parea leꞌa bexa ncho lazh xa no be ltsaꞌa xa no bexa ncho ta lid xa naꞌanpa ndap bexa mod ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta weꞌe lá ngun Jesús sian uyon sa wa. Platsa xa gizh mxoꞌob Jesús yaꞌa na gek xa, cha myakna bexa. ");
INSERT INTO zpt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Leꞌa Jesús ngwanseana xteꞌe lá ndangea ladna bexa Jesús. Cha ndi ukesea uluu xa be men ndencho be gezh gax sa wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsoꞌo wa utezh Jesús isatibtop be xmen xa, cha msaꞌa xa juers kontuꞌub bexa be mbi bxin. Cha mtuꞌub xa top gaꞌga bexa, ");
INSERT INTO zpt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ndab xa ndoꞌ bexa: —Ni dub taꞌa guntiꞌin bega nes lá goꞌo bega, ni bols, no ni pan, no ni med. Biꞌi bega dub bordóntsa. ");
INSERT INTO zpt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bkeꞌatsa bega ndab bega, parea ni stub nes xab bega lá goꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Leꞌa sa na ilayaꞌ bega len dub niꞌi usaꞌa bexa, weꞌetsa yoo bega gast gal wizh ikaꞌan bega gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No tal ncho gezh lá ulaꞌa bexa yoo bega, ni lá nlad bexa goꞌón bexa ta gudiꞌizh bega, bkaꞌan bega gezh wa. Cha blate bega gast yakol ngwaꞌal xoꞌo bega, ta nluu leꞌa Dios lá nsak ladna lak nak bexa wa. Leꞌa naꞌ gáp ndoꞌ bega leꞌa gal wizh gab Dios ná ton ndap ke, leꞌa bexa gezh wa mas gealkweaꞌ iniꞌí ndoꞌ bexa uyoꞌo gezh Sodoma nsea gezh Gomorra. ");
INSERT INTO zpt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Weꞌe cha utoꞌo be xmen Jesús nchaꞌbeyadiꞌizh ndoꞌ be men ulaꞌa bexa be ta ugap nak bexa, cha yach bexa wats Dios. ");
INSERT INTO zpt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","No ngontuꞌub bexa sian be mbi bxin ncho len ladoꞌo be men, nsea ngaꞌab bexa aceit gek kwaꞌad bexa gizh, cha nyakna bexa gizh wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Leꞌa be ta mbin Jesús wa uzheꞌeb mgen itea lad, gast no Herodes xa nibeꞌe idub región wa mbiꞌín be ta wa. Cha ndab Herodes: —Leꞌa Jesús leꞌa nak Juan xa ulaleaꞌ be men wa mbangal ndoꞌ gealgut. Ta weꞌe ndap xa juers ndun xa be uyon wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","No ncho be men ndab: —Leꞌa Jesús nak Elí. No ncho bexa ndab: —Leꞌa Jesús leꞌa stub profet cuent bexa mbidiꞌizh sakndoꞌ Dios tiemp polta. ");
INSERT INTO zpt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ná leꞌa gor na mbiꞌín Herodes xteꞌe ndab be men wa, cha ndab Herodes: —Leꞌa xa wa leꞌa Juan xa unibeꞌe naꞌ ulobtoꞌog bexa gen na wa. Xa wa leꞌa xa mbangal. ");
INSERT INTO zpt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Leꞌa mas polta leꞌa Herodes ukaꞌa Herodías, xagots ten Julip witka Herodes. Leꞌa Herodes mtuꞌub be xmen na isen bexa Juan, cha uxi bexa Juan caden, ukeꞌa bexa Juan litgiꞌib, lak nlad Herodías. ");
INSERT INTO zpt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Li mbin Herodes geal leꞌa Juan ndab ndoꞌ xa: —Naꞌanpa utsin nak‑a ukaꞌa lu xagots ten wit lu. ");
INSERT INTO zpt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ta weꞌe leꞌa Herodías nxeeno ladna Juan, gast nlad xa gut xa Juan. Ná xa lá gunga gan, ");
INSERT INTO zpt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","geal leꞌa Herodes lá ulaꞌa gat Juan. Leꞌa Herodes ndap mod ndoꞌ Juan, geal leꞌa Juan dub xa wen ten Dios. No ndal ladna Herodes ndoꞌón xa ta ndadiꞌizh Juan, ná leꞌa xa gast ni lá iniꞌí xteꞌe gun gor ndoꞌón xa ta ndadiꞌizh Juan. ");
INSERT INTO zpt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Leꞌa ngol dub wizh leꞌa Herodías mzhealka dub mod xteꞌe gat Juan. Leꞌa wizh ngol leaꞌ Herodes, leꞌa xa ulo dub gast siꞌil. Mgaw Herodes be men nsak ten xa, no bexa nibeꞌe ten soldad, no leꞌaka bexa nsak ncho distrit Galilea. ");
INSERT INTO zpt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Cha utoꞌo xingots Herodías mbilndats xa ndoꞌ gaꞌal bexa nde ndoꞌ gast wa. Weꞌe leꞌa Herodes nsea bexa nde sa wa ngol ladna xteꞌe mbilndats nagots wa, cha ndab Herodes ndoꞌ xa: —Unab guniꞌi xtaꞌan nlad lu, leꞌa naꞌ usa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Gast Dios nsobwiꞌi gáp naꞌ ndoꞌ lu: itea ta inab lu usa naꞌ, gast itol ta nibeꞌe naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Leꞌa nagots wa cha utoꞌo nseaꞌ ndoꞌ xnaꞌa na, cha ndab xa: —¿Xtaꞌan inaꞌab naꞌ ndoꞌ Herodes? Leꞌa xnaꞌa nagots wa cha ukaꞌab ndab: —Unab gek Juan xa ulaleaꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Leꞌa nagots wa cha uxax ubii sa nsob Herodes ndab: —Leꞌa naꞌ nlad usaꞌa go gek Juan xa ulaleaꞌ be men, ixoꞌob‑a ndoꞌ dub plat. ");
INSERT INTO zpt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Leꞌa Herodes cha uban myoꞌo ladna. Parea ke na ndab xa Dios nsobwiꞌi no ke na mbiꞌín be men nde ndoꞌ mes ta ndab xa wa, ta weꞌe usaꞌaka Herodes ta unab nagots wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Weꞌe leꞌa xa cha mtuꞌub dub soldad yaꞌlabtoꞌog gen Juan len litgiꞌib wa, cha yoꞌo xa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Leꞌa soldad wa cha ngwaꞌlabtoꞌog gen Juan len litgiꞌib, cha myoꞌo xa‑yá uxoꞌob‑a ndoꞌ dub plat. Cha msaꞌa xa‑yá ndoꞌ nagots wa. Leꞌa nagots wa cha ngwaꞌusaꞌa‑yá ndoꞌ xnaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Leꞌa gor na mbiꞌín be xmen Juan leꞌa Juan ngut, cha ngwaꞌdob bexa Juan. Cha mkaꞌach bexa Juan. ");
INSERT INTO zpt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Weꞌe leꞌa be xmen Jesús cha mlaꞌnchaꞌ wats Jesús, cha mbidiꞌizh bexa itea be taꞌa mbin bexa nsea ta mluu bexa be men. ");
INSERT INTO zpt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ná leꞌa sa nsoꞌ Jesús wa tant nyoꞌo ntoꞌo be men, gast ni lá yoo gan gaw bexa. Ta weꞌe leꞌa Jesús cha ndab ndoꞌ be xmen na: —Nchaꞌbe beuna dub sa naꞌan men, ndontsa uneꞌe bega dub xlaꞌal. ");
INSERT INTO zpt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Weꞌe cha nab Jesús nsea be xmentsa xa utoꞌo, ukea bexa ndoꞌ dub barco, nchaꞌbe bexa dub sa naꞌan men. ");
INSERT INTO zpt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ná leꞌa kwaꞌad be men uniꞌí nchaꞌbe bexa no mgondoꞌ bexa Jesús. Ta weꞌe cha utoꞌo bexa be gezh wa, uxax nchaꞌbe ndats bexa, cha nedla bexa ulayaꞌ sa ilayaꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Leꞌa gor na ulaꞌ Jesús ndoꞌ barco wa, cha mnaꞌla xa be men kwaꞌad nde toꞌo nits, cuent be borreg lá ndap ton ulaꞌach ma. Cha mlats ladna Jesús bexa, cha usaxan xa mbidiꞌizh xa sian taꞌa ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ngol gor mas uzhela, leꞌa be xmen Jesús ubii wats Jesús, ndab bexa: —Leꞌa sa ndee dub sa sit naꞌanpa ncho be men, ná nat yá uzhelapa. ");
INSERT INTO zpt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gud go ndoꞌ be men baꞌ yaꞌisiꞌi bexa ta gaw bexa be ranch no be gezh nde gax ndee, leꞌa bexa lá noꞌo ta gaw na. ");
INSERT INTO zpt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Leꞌa Jesús cha ukaꞌab ndab: —Bsaꞌa bego ta gaw bexa baꞌ. Leꞌa be xmen Jesús cha ndab: —¿Nlad ga yaꞌisiꞌi besa be ta gaw bexa baꞌ zha? Leꞌa ta wa itatsoꞌ ta ndun dub men gan dub xoꞌon mbeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Leꞌa Jesús cha unabdiꞌizh ndab: —¿Plo pan ndap bega zha? Waꞌiwiꞌi bega‑yá. Weꞌe leꞌa gor mlen bexa, cha ndab bexa ndoꞌ Jesús: —Leꞌa besa ndap sgaꞌaytsa pan nsea stoptsa mbeal. ");
INSERT INTO zpt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Weꞌe leꞌa Jesús cha ndab ndoꞌ be xmen na gab ndoꞌ be men wa kwe plagaga xa ndoꞌ gixgi ugeꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Weꞌe leꞌa kadga dub sa wa ute dub gayoꞌoga bexa no itol gayoꞌoga xa. ");
INSERT INTO zpt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Leꞌa Jesús cha usen isagaꞌay pan nsea itop mbeal wa. Cha mwiꞌi xa gibeꞌa, msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa Jesús be pan wa sian bleꞌa, weꞌe msaꞌa xa‑yá ndoꞌ be xmen xa. Leꞌa bexa wa mtseꞌa‑yá ndoꞌ be men wa. Cha liga mtseꞌa bexa be mbeal wa ndoꞌ iteanak be men. ");
INSERT INTO zpt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Leꞌa itea be men wa udaw gast plo mzhea bexa. ");
INSERT INTO zpt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ná leꞌa gor mteleꞌe bexa be pan no be mbeal ta myaꞌan yaw be men wa, leꞌa ta wa stibtop zhum byux‑a. ");
INSERT INTO zpt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Leꞌa lat bexa li udaw wa pa dub gaꞌay mil be xabgiꞌi. ");
INSERT INTO zpt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cha ndab Jesús ndoꞌ be xmen na: —Bkea bega leꞌaka ndoꞌ barco baꞌ. Cha waꞌ bega stub toꞌo lagun gast gezh Betsaida. Ndalen wa ndab Jesús ndoꞌ be men kwaꞌad wa yaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Leꞌa gor na yá nseaꞌbe be men wa, leꞌa Jesús nab ukea dub bet ngwaꞌyadiꞌizhno xa Dios. ");
INSERT INTO zpt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ngol gor ulaꞌ teꞌal leꞌa barco ncho be xmen Jesús wa nchaseala itol nes ndoꞌ nits wa. Leꞌa Jesús nab myansoꞌ ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Weꞌe leꞌa Jesús mnaꞌla leꞌa barco wa uzhebpa juers nseala, geal leꞌa mbi uzhebpa nlen ndoꞌ nits wa lad ndoꞌ barco. Ngol gor yamer nsayat xeꞌa, leꞌa Jesús nchasea ndats ndoꞌ nits gax wats barco wa. ");
INSERT INTO zpt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Leꞌa gor uniꞌí bexa Jesús nseandats xa ndoꞌ nits wa, cha utezhat bexa leꞌa bexa mbinbeꞌe leꞌa‑yá dub ta uxin. ");
INSERT INTO zpt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Leꞌa bexa iteanak naꞌ ta wa, no uzheꞌeb mzheb bexa. Ná leꞌa Jesús cha ndab ndoꞌ bexa: —¡Gop bega valor! ¡No lá izheb bega! Leꞌa ta ndee naꞌka. ");
INSERT INTO zpt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Leꞌa gor ukea Jesús ndoꞌ barco wa, leꞌa mbi wa cha uleas. Leꞌa be xmen Jesús uzhebpa mzheb, no ngwanseana bexa, ");
INSERT INTO zpt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","geal leꞌa bexa lá yakbeꞌena ta na li mbinno Jesús be pan wa, leꞌa bexa bi lika ngud nak ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Leꞌa bexa wa utakea ndoꞌ nits wa, ulayaꞌ bexa sa nsaleaꞌ Genesaret, cha mxi bexa barco wa ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Leꞌa gor ulaꞌ bexa ndoꞌ barco, leꞌa be men nde sa wa mgondoꞌla Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Weꞌe leꞌa be men ncho be gezh nde gax wa ulenno be men gizh ndoꞌ yaloꞌon gast sa mbiꞌín bexa nsoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Leꞌa itea sa ndaꞌ Jesús len be gezh byux no be gezh ubiꞌi no be ranch, ngoteka be men bexa gizh wa toꞌo nes sa nsatid Jesús. Cha unab bexa ulaꞌa Jesús masa ndats xab Jesús ugal bexa gizh. Leꞌa itea bexa na li mgal xab Jesús wa cha myaknabe. ");
INSERT INTO zpt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tsoꞌo wa leꞌa pla bexa fariseo nsea be mech ten ley utoꞌo Jerusalén ulen wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cha uniꞌí bexa leꞌa pla be xmen Jesús ndeyaw ni lá unaꞌa bexa lak nibeꞌe costumbr ten bexa. Ta weꞌe unisi bexa be xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Leꞌa bexa fariseo nsea iteata be men judio uzhebpa ndankea be costumbr ten be usan gox polta ten bexa. Tal leꞌa bexa lid ned unaꞌa sian biaj lak nak costumbr wa, leꞌa bexa lá yoo gan gaw. ");
INSERT INTO zpt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No tal bexa ngwaꞌ ndoꞌ xgeꞌe, leꞌa bexa wa lá yoo gan gaw tal leꞌa bexa lá unaꞌa. Nsea sianta be costumbr ndankea bexa, lak nsat bexa be vas no be kamplor no be ta giꞌib. Nsea iteata be taꞌa ndantiꞌin bexa sa ndaw bexa juerska yat‑a lak nibeꞌe costumbr ten bexa. ");
INSERT INTO zpt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ta weꞌe leꞌa bexa fariseo nsea be mech ten ley unabdiꞌizh ndoꞌ Jesús ndab bexa: —¿Xtaꞌan ni lá ndankea be xmen lu be costumbr mchaꞌan be usan gox polta ten beuna zha? Lbaꞌatsa naꞌa bexa gor ndaw bexa parea naꞌanpa naꞌa bexa lak nsabndoꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa bega nluu cuentta xa wen ná bega xa ugap nak. Ugeaka mkeꞌa Isaías sakndoꞌ Dios tiemp polta, ndab xa lak nak bego: Leꞌa be men ndee diꞌizhtsa ndankea naꞌ, parea leꞌa ladoꞌo xa sit nak ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naꞌan xtiꞌin ta ndankea bexa naꞌ, leꞌa cuent diꞌizh ten naꞌ nluu bexa, parea diꞌizh ten be mentsa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mlaꞌa bega ta unibeꞌe Dios gun bega, ndankea bega ndi sbeꞌen costumbr ten men, lak nsat bega kamplor no be vas, no sianta be taꞌa cuent ta ndee ndun bega. ");
INSERT INTO zpt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","No ndab Jesús ndoꞌ bexa: —Leꞌa bega nlaꞌa be ta unibeꞌe Dios, cha ndi ndankeatsa bega be costumbr ten leꞌaka bega. ");
INSERT INTO zpt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Leꞌa ta na mkeꞌa Moisés ndab: “Wankea bega xus bega nsea xnaꞌa bega.” No ndab‑a: “Leꞌa tal ton kweaꞌ iníꞌi ndoꞌ xus na natal ndoꞌ xnaꞌa na, leꞌa xa wa nsabndoꞌ gat.” ");
INSERT INTO zpt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ná leꞌa bego ndi ndab leꞌa tal ton gab ndoꞌ xus na no ndoꞌ xnaꞌa na leꞌa iteanak be taꞌa ndiꞌizh gakno xa bexa wa, leꞌa ta wa ndi usaꞌa xa ndoꞌ Dios, ");
INSERT INTO zpt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","weꞌe leꞌa xa wa yá naꞌantapa juerska gakno xus na no xnaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Li nlaꞌa bega ta unibeꞌe Dios, ndankea bega ndi sbeꞌen costumbr ten bega. No sianta be taꞌa cuent nak ta ndee ndun bega. ");
INSERT INTO zpt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Weꞌe leꞌa Jesús cha utezh itea be men kwaꞌad wa, cha ndab xa: —¡Blaꞌach bega ta gáp naꞌ ndee! ¡No byakbeꞌena bega‑yá! ");
INSERT INTO zpt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Leꞌa ta ndaw be men naꞌanpa leꞌa ndun bzhiꞌik bexa ndoꞌ Dios. Ndi leꞌa ta ntoꞌo ladoꞌo be men ndun bzhiꞌik bexa cuent ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Leꞌa bego na ndap nchaꞌ na, blaꞌach bega ta ndáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Leꞌa gor na mlaꞌa Jesús be men wa, cha nseaꞌ xa len niꞌi. Weꞌe leꞌa be xmen xa unabdiꞌizh ná xteꞌe nak ta msaktabeꞌe xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Leꞌa Jesús cha ndab: —¿Noga bego ni lá nyakbeꞌena ta ndáp naꞌ zha? ¿Lá nyakbeꞌena bega zha leꞌa ta ndaw dub men, leꞌa ta wa lá gun bzhiꞌik xa ndoꞌ Dios? ");
INSERT INTO zpt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Leꞌa ta wa naꞌanpa nyoꞌo ladoꞌo xa, ndi len xa nchaꞌa‑yá, cha tsoꞌo wa nchaꞌa‑yá len letrina. Leꞌa ta li ndab Jesús wa gab leꞌa itea ta ndaw bexa umbiꞌika ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Weꞌe ndab Jesús: —Leꞌa ta ntoꞌo ladoꞌo dub men, leꞌa ta wa ndun bzhiꞌik xa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Leꞌa len ladoꞌo xa ntoꞌo be ta ugap ndanbeꞌe xa. Ta weꞌe ncho bexa ngalga xa ten stubga men. No ncho xa ndun ta ugap ltsaꞌa ta li nak wa. No ncho xa ndut men. ");
INSERT INTO zpt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","No ncho xa ndun gealwaꞌan. No ncho xa sbeꞌen nlad mas sian taꞌa gap. No ncho xa ugap ndanno be men. No ncho xa ndun gealkwiꞌin. No ncho xa ndun itea ta nladtsa xa. No ncho xa ndaklono stub xa ndap taꞌa. No ncho xa nisi be ltsaꞌa na. No ncho xa nzhinna. No ncho xa ni lá nsakyoꞌón. ");
INSERT INTO zpt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Leꞌa itea be ta ugap ndee ntoꞌo len ladoꞌo be men, cha ndun bzhiꞌik‑a gealnaban ten xa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Cha utoꞌo Jesús distrit Galilea nchaꞌa xa dub sa gax gezh Tiro no gezh Sidón. Cha uyoꞌo xa len lid dub men sa wa. Leꞌa Jesús lá nlad igen pa ncho xa, ná leꞌa‑yá mgenka. ");
INSERT INTO zpt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Weꞌe leꞌa dub xagots mbiꞌín pa ncho Jesús cha ulen xa wats Jesús, leꞌa xa ndap dub meꞌed gots gizh ncho mbi bxin len ladoꞌo na. Cha usaxib xagots wa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Leꞌa xa wa xa Sirofenicia, naꞌanpa xa judio. Leꞌa xa wa unab kontuꞌub Jesús mbi bxin ncho len ladoꞌo xin xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ná leꞌa Jesús ndi ndab: —Blaꞌa ned be meꞌed itayaw. Naꞌanpa utsin nak ulat besa ta gaw be meꞌed, cha usaꞌab besa‑yá ndoꞌ be mbek. ");
INSERT INTO zpt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Leꞌa xagots wa ukaꞌab ndab: —Ta ugeaka ta wa, Señor, parea leꞌa be mbek ndaw be taꞌa nlate toꞌo be meꞌed xan mes. ");
INSERT INTO zpt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Leꞌa Jesús cha ndab: —Leꞌa lu utsin ukaꞌab. Nat byaꞌ ta lid lu, leꞌa mbi bxin wa utoꞌola len ladoꞌo xmeꞌed lu. ");
INSERT INTO zpt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Leꞌa gor na mtanseaꞌ xagots wa ta lid xa, leꞌa mbi bxin wa utoꞌola len ladoꞌo meꞌed gots wa. Leꞌa meꞌed wa nax ndoꞌ loꞌon myaklana. ");
INSERT INTO zpt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Leꞌa Jesús cha mkaꞌan sa nibeꞌe Tiro wa, nchaꞌtid xa Sidón nsea distrit nsaleaꞌ Decápolis, ulayaꞌ xa toꞌo lagun Galilea. ");
INSERT INTO zpt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Leꞌa be men kwaꞌad cha ulayaꞌno dub xa mud no ngwaꞌad xa. Cha unab bexa uxoꞌob Jesús yaꞌa na gek xa mud wa, ndontsa yakna xa. ");
INSERT INTO zpt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Leꞌa Jesús cha mbiꞌi nabtsa xa mud wa dub lad wats be men wa. Cha mkiko Jesús ngutsyaꞌa na be len nchaꞌ xa mud wa. Cha mchukko Jesús dub ngutsyaꞌa na, cha mgal Jesús luzh xa mud wa. ");
INSERT INTO zpt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Weꞌe mwiꞌi Jesús gibeꞌa, cha mgaꞌa ladna xa, ndab xa: —¡Efata! —leꞌa ta wa gab: ¡Byaꞌal lu! ");
INSERT INTO zpt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bi leꞌa gor wa cha myaꞌal nchaꞌ xa, cha myakna luzh xa nsea usaxan utsin ndadiꞌizh xa. ");
INSERT INTO zpt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Weꞌe cha ndab Jesús ndoꞌ bexa: —Naꞌan ton ndoꞌ ná gudiꞌizh bega ta ndee. Parea lakta pla biaj ndab Jesús lá gudiꞌizh bexa‑yá, ná leꞌa bexa ndi mas mbidiꞌizh‑a. ");
INSERT INTO zpt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Leꞌa itea be men uzhebpa ngwanseana, ndab bexa: —Wenka ndun xa itea be taꞌa, gast nyunyakna xa bexa mud no ngwaꞌad. ");
INSERT INTO zpt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ngol dub wizh leꞌa be men kwaꞌadpa mzhealbe wats Jesús, ná leꞌa bexa lá ndap ta gaw na. Ngol gor leꞌa Jesús cha utezh be xmen na, cha ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Naꞌ nlats ladna be men ndee, leꞌa bexa wizh nyonla nde wats naꞌ, ná leꞌa bexa lá ndapta ta gaw na. ");
INSERT INTO zpt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tal naꞌ utuꞌub bexa lbaꞌatsa lá gaw bexa, nchaꞌa bexa lá uxik ilanseaꞌ ta lid na, leꞌa ncho xa baꞌ sit utoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Leꞌa be xmen Jesús cha ndab: —¿Pa izheal beuna pan gaw dub lbaꞌata men baꞌ zha? Leꞌa sa ndee sit nde be gezh. ");
INSERT INTO zpt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Leꞌa Jesús cha unabdiꞌizh ndab ndoꞌ bexa: —¿Plo pan noꞌo bega zha? Leꞌa bexa cha ndab: —Sgaꞌad pan. ");
INSERT INTO zpt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Weꞌe leꞌa Jesús cha ndab ndoꞌ be men kwaꞌad wa kwe bexa ndoꞌ yo. Cha usen xa isagaꞌad pan wa, cha msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa be pan wa sian bleꞌa, cha msaꞌa xa‑yá ndoꞌ be xmen xa, utseꞌa bexa‑yá ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","No stapla be mbeal byux ndap bexa usen Jesús, msaꞌa Jesús xno ndoꞌ Dios. Cha unibeꞌe xa ndoꞌ be xmen xa utseꞌa‑yá ndoꞌ be men wa. ");
INSERT INTO zpt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Leꞌa be men wa udaw gast plo mzhea bexa. Cha mteleꞌe bexa sgaꞌad zhum byux be ta myaꞌan sobr. ");
INSERT INTO zpt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Leꞌa bexa udaw wa pa dap mil. Leꞌa Jesús cha ndab ndoꞌ bexa wa yaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cha ukea xa ndoꞌ dub barco nsea be xmen xa nchaꞌa bexa distrit Dalmanuta. ");
INSERT INTO zpt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Leꞌa sa wa ulen pla bexa fariseo wats Jesús. Cha usaxan bexa ndadiꞌizhno bexa Jesús, nlad bexa gun bexa preb Jesús, ndab bexa ndoꞌ Jesús: —Leꞌa besa nlad gun ga dub ta uluu leꞌa ga Dioska mtuꞌub. ");
INSERT INTO zpt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Leꞌa Jesús cha mgaꞌa ladna, cha ndab xa: —¿Xtaꞌan nlad be men ncho nat dub ta uluu ton nak naꞌ? Leꞌa naꞌ gáp leꞌa bega naꞌanpa iniꞌí ta nab bega wa. ");
INSERT INTO zpt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Weꞌe leꞌa Jesús cha mlaꞌa bexa. Cha ukea Jesús ndoꞌ barco wa nsea be xmen xa, nchaꞌbe bexa stub toꞌo nits. ");
INSERT INTO zpt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Leꞌa be xmen Jesús myalad ngoꞌo pan gaw bexa. Dubtsa pan noꞌo bexa len barco wa. ");
INSERT INTO zpt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Leꞌa Jesús ndab ndoꞌ bexa: —Blaꞌach bego, uzhebpa gop bega cuent nsea levadur ten bexa fariseo no levadur ten Herodes. ");
INSERT INTO zpt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Leꞌa bexa wa cha ndabbe ndoꞌ be ltsaꞌa na: —Li ndab xa geal leꞌa beuna lá ngoꞌo pan. ");
INSERT INTO zpt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Leꞌa Jesús cha mgenna ta li ndab bexa wa, cha ndab Jesús: —¿Xtaꞌan ndeyadiꞌizh bega leꞌa bega lá noꞌo pan zha? ¿Bi lá nyakbeꞌena bega ta nluu naꞌ zha? ¿No bi ngud nak ladoꞌo bega zha? ");
INSERT INTO zpt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Lá naꞌ ngusndoꞌ bega zha? ¿No ni lá ndoꞌón nchaꞌ bega zha? ¿No ni lá ntseꞌa ladna bega ta li mbin naꞌ wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Leꞌa zha na msa naꞌ gaꞌaytsa pan udaw dub gaꞌay mil xabgiꞌi wa, ¿plo zhum ta myaꞌan sobr mteleꞌe bega zha? Cha ndab bexa: —Stibtop zhum‑a. ");
INSERT INTO zpt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Leꞌa Jesús cha ndab: —No gor na msa naꞌ dub gaꞌadtsa pan udaw dub dap mil men, ¿plo zhum ta myaꞌan sobr mteleꞌe bega zha weꞌe zha? Cha ndab bexa: —Sgaꞌad zhum‑a. ");
INSERT INTO zpt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Cha ndab Jesús: —¿Ni bi lá nyakbeꞌena bega zha? ");
INSERT INTO zpt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Leꞌa gor ulayaꞌ Jesús gezh Betsaida, weꞌe leꞌa pla be men ulenno dub xabgiꞌi lá naꞌ. Cha unab bexa ndoꞌ Jesús ugal Jesús ngusndoꞌ xa ndontsa yakna xa. ");
INSERT INTO zpt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Leꞌa Jesús cha usen yaꞌa xa lá naꞌ wa, uloꞌo Jesús xa dub lad toꞌo gezh. Cha mchukko Jesús ngusndoꞌ xa no mxoꞌob Jesús yaꞌa na tsoꞌo ngusndoꞌ xa wa. Cha ndab Jesús: —¿Naꞌla lu nat zha? ");
INSERT INTO zpt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Leꞌa xa wa cha mwiꞌi ndab: —Naꞌ naꞌla be men cuenttsa be ya ndesea. ");
INSERT INTO zpt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Leꞌa Jesús cha mxoꞌob yaꞌa na tsoꞌo ngusndoꞌ xa stub biaj, cha myakna‑yá. No ndon wenla mnaꞌ xa itea be taꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Weꞌe leꞌa Jesús cha mtuꞌub xa yaꞌ xa ta lid xa, ndab Jesús: —Lá itid lu len gezh baꞌ, no ni naꞌan ton ndoꞌ ná gudiꞌizh lu‑yá toꞌo gezh baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsoꞌo wa leꞌa Jesús utoꞌo sa wa nsea be xmen xa. Nchaꞌbe bexa be gezh nde gax Cesarea Filipo. Leꞌa nes nchaꞌbe bexa leꞌa Jesús unabdiꞌizh ndoꞌ be xmen xa, ndab xa: —¿Xteꞌe ndab be men ton nak naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Leꞌa bexa cha ukaꞌab ndab bexa: —Leꞌa ncho be men ndab leꞌa go nak Juan xa ulaleaꞌ be men. No ncho bexa ndab leꞌa go nak profet Elí. No nchoga bexa ndab leꞌa ga nak stub profet xaꞌaga. ");
INSERT INTO zpt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Weꞌe leꞌa Jesús cha ndab: —¿Bego zha xteꞌe gab ton nak naꞌ? Leꞌa Pedr cha ukaꞌab ndab: —Leꞌa go nak Cristo, xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Parea leꞌa Jesús cha ndab ndoꞌ bexa: —Lá gudiꞌizh bega ton nak naꞌ ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Weꞌe leꞌa Jesús cha usaxan nluu bexa, ndab xa: —Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, nsabndoꞌka iní naꞌ sian gealkweaꞌ. Leꞌa bexa gox nsak no be uleꞌay nibeꞌe no be mech ten ley uxelad naꞌ. No gut bexa naꞌ, ná leꞌa gal wizh yon leꞌa naꞌ iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Li uyaꞌal mbidiꞌizh Jesús leꞌa xa gat. Weꞌe leꞌa Pedr cha mbiꞌi Jesús dub lad, cha uteyo Pedr xa, ndab Pedr: —¡Naꞌanpa li gak ta wa! ");
INSERT INTO zpt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Leꞌa Jesús cha mgeaksoꞌ mwiꞌi ndoꞌ be xmen na, cha uteyo xa Pedr, ndab xa: —Utatsoꞌ wats naꞌ, leꞌa lu ndadiꞌizh cuent maxuꞌu. Leꞌa lu lá ndanbeꞌe lak ndanbeꞌe Dios, leꞌa lu ndi ndanbeꞌe lak ndanbeꞌe be mentsa. ");
INSERT INTO zpt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Weꞌe leꞌa Jesús cha utezh be xmen na nsea kwaꞌad be men xaꞌaga. Cha ndab Jesús: —Tal ton nlad isankea tsoꞌo naꞌ, nsabndoꞌ ulaꞌa xa iteanak be ta nlad xa, cha goꞌo xa cruz ten xa, cha isankea xa tsoꞌo naꞌ, guniꞌi xtaꞌan gunno be men xa. ");
INSERT INTO zpt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Leꞌa tal ton ukwaꞌan xteꞌe wen yoo xa, leꞌa xa wa ndi gun perdid gealnaban ten na ndoꞌ Dios. Ná leꞌa tal ton gat ta na nak xa xmen naꞌ no ta na ndangea ladna xa diꞌizh wen ten Dios, leꞌa xa wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Leꞌa tal dub men ndap iteanak be ta ncho ndoꞌ gizhliyo ndee, cha gak perdid gealnaban ten xa ndoꞌ Dios, ¿xtiꞌin be ta sian ndap xa wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Leꞌa ta wa naꞌanpa ugal isiꞌi xa gealnaban ten xa. ");
INSERT INTO zpt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tal ton idono ladna naꞌ nsea diꞌizh ten naꞌ ndoꞌ be men ugap ncho tiemp nat, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, noga idono ladna xa wa, gal wizh ilenno naꞌ xeꞌa siꞌil ten Dios Xus naꞌ no be angel ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","No ndab Jesús: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa ncho bexa nde ndee naꞌanpa cha gat gast iniꞌí bexa gal tiemp inibeꞌe Dios ndoꞌ gizhliyo no juers siꞌil ten xa. ");
INSERT INTO zpt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ngol sxoꞌop wizh leꞌa Jesús mbiꞌi Pedr no Jacob no Juan, ukea bexa dub bet gaꞌap sa naꞌan men. Leꞌa sa wa leꞌa Jesús cha mtixndoꞌ ndoꞌ gaꞌal bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Leꞌa xab Jesús ndon nlaꞌbealꞌ no ndon mbe xiꞌil mnaꞌ‑yá, ni dub bexa nsat lad lá ndun gan lita mbe inaꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Zha leꞌa sa wa mlundoꞌ Elí no Moisés ndeyadiꞌizhno Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Weꞌe leꞌa Pedr cha ndab ndoꞌ Jesús: —Mech, uzhebpa wen nde beuna sa ndee. Gundeꞌe besa chon ramad: dub‑a ná ten go, leꞌa stub‑a ná ten Moisés, nsea stub‑a ná ten Elí. ");
INSERT INTO zpt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Leꞌa be xmen Jesús wa uzhebpa mzheb, ta weꞌe ngi li ndab Pedr. ");
INSERT INTO zpt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Weꞌe leꞌa dub xkaw cha ulen sa nde bexa. Leꞌa lat xkaw wa ulen ti Dios ndab: —Leꞌa ta ndee Xiꞌín naꞌ. Naꞌ nkweaꞌ ladna xa. Bsakyoꞌón bega ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cha uxax mwiꞌi be xmen Jesús gangeak, parea leꞌa sa wa yá naꞌanla ton ndebe, nabtsa Jesús nsoꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Leꞌa ngol gor na nchaꞌlayoꞌo bexa bet wa, leꞌa Jesús ndab ndoꞌ bexa: —Naꞌan ton ndoꞌ ná gudiꞌizh bega ta na li uniꞌí bega wa, gast gal gor na leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Weꞌe leꞌa bexa wa lá ngudiꞌizh‑a, nabtsa yon bexa ndadiꞌizh, ndab bexa: —¿Xteꞌe nak ta ndab xa leꞌa xa iban ndoꞌ gealgut zha? ");
INSERT INTO zpt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Leꞌa bexa wa cha unabdiꞌizh ndab bexa ndoꞌ Jesús: —¿Xtaꞌan ndab be mech ten ley leꞌa Elí ned ilen, weꞌeta ilen Cristo xa utuꞌub Dios zha? ");
INSERT INTO zpt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Leꞌa Jesús cha ukaꞌab ndab: —Ta ugeaka leꞌa Elí nedka ilen ndontsa list kwe be men. Leꞌa lak nkeaniꞌi diꞌizh ten Dios, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, sianpa gealkweaꞌ iní, no uxelad be men naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Leꞌa naꞌ gáp ndoꞌ bega, leꞌa Elí wa mbiꞌidla. Ná leꞌa be men ugap mbinno xa lakta nlad bexa, lakka nkeaniꞌi diꞌizh ten Dios cuent ten xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Leꞌa gor na myach Jesús no schon xmen xa sa nde staplaga xmen xa wa, weꞌe leꞌa bexa uniꞌíla leꞌa be men kwaꞌad ndela wats bexa wa. Leꞌa be mech ten ley ndeyotoꞌono stapla be xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Leꞌa gor uniꞌí be men wa Jesús cha ngwanseana bexa, cha uxax ngwaꞌinidiꞌizh bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Leꞌa Jesús cha unabdiꞌizh ndab: —¿Xtaꞌan ndeyotoꞌo bega zha? ");
INSERT INTO zpt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Leꞌa dub xabgiꞌi ukaꞌab ndab: —Mech, leꞌa naꞌ ndee ndalno dub meꞌed bgiꞌi ten naꞌ ncho mbi bxin len ladoꞌo na. Leꞌa mbi bxin wa leꞌa mbin mud meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Leꞌa gor na nsen mbi bxin meꞌed baꞌ, leꞌa meꞌed nlayat, nsea nlen bchiꞌin toꞌo meꞌed, no ndaw meꞌed ndeay meꞌed, cha lá nteꞌalta meꞌed. Leꞌa naꞌ unaꞌab ndoꞌ be xmen ga kontuꞌub mbi bxin wa, ná leꞌa bexa lá ngun gan. ");
INSERT INTO zpt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Leꞌa Jesús cha ndab ndoꞌ be men wa: —¡Ndidotsa ngeꞌ ladna bega Dios! ¿Ploxá tiemp yoꞌo naꞌ lat bega zhaga? ¿Sta ploxá tiemp uxik naꞌ ndoꞌ bega zhaga? Utseano bega meꞌed bgiꞌi baꞌ sa ndee. ");
INSERT INTO zpt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Weꞌe cha mbiꞌi bexa meꞌed wa wats Jesús. Leꞌa gor na uniꞌí mbi bxin wa Jesús, leꞌa ta wa cha udingeꞌ meꞌed wa ndoꞌ yo, naxbixte meꞌed, nsea toꞌo meꞌed cha ulen bchiꞌin. ");
INSERT INTO zpt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Leꞌa Jesús cha unabdiꞌizh ndoꞌ xus meꞌed ndab xa: —¿Polta ulen‑a zha? Leꞌa xus meꞌed cha ndab: —Zha tuzhta meꞌed baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sian biaj leꞌa mbi bxin ntsaꞌab meꞌed baꞌ ndoꞌ giꞌ no len nits, ndontsa gat meꞌed. Ná tal leꞌa ga sun gan, blats ladna go besa gokno ga besa. ");
INSERT INTO zpt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Leꞌa Jesús cha ndab: —¿Xteꞌe ndab lu “tal leꞌa ga sun gan”? Leꞌa xa na ndangea ladna Dios, itea taꞌa syoꞌo gan. ");
INSERT INTO zpt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Weꞌe leꞌa xus meꞌed wa cha ugeꞌ ndab: —Naꞌ ndangeaka ladna Dios. Gokno ga naꞌ, ndontsa mas gungea lad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Leꞌa gor na uniꞌí Jesús kwaꞌadpa be men nseabewiꞌi, weꞌe cha uteyo Jesús mbi bxin wa ndab xa: —Lu nak mbi bxin ndun ngwaꞌad no mud meꞌed ndee, gáp naꞌ ndoꞌ lu utoꞌo. Ni lá yachta lu len ladoꞌo meꞌed ndee. ");
INSERT INTO zpt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Leꞌa mbi bxin wa cha uzheꞌeb utezhat, no mas ngotbixte meꞌed. Cha utoꞌo mbi bxin len ladoꞌo meꞌed wa. Leꞌa meꞌed wa cuent meꞌed ngut nax, gast kwaꞌad be men ndab leꞌa meꞌed wa ngutka. ");
INSERT INTO zpt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ná leꞌa Jesús cha usen yaꞌa meꞌed, cha ngwaste meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsoꞌo wa uyoꞌo Jesús len dub niꞌi sa wa, cha unabdiꞌizh be xmen Jesús, ndab bexa ndoꞌ Jesús: —¿Xtaꞌan lá ngun besa gan igontuꞌub besa mbi bxin baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Leꞌa Jesús cha ndab: —Leꞌa be ltsaꞌa mbi bxin wa lá yoo gan itoꞌo xagaꞌ, nkiꞌin lá gaw bega dub tiemp no mas gudiꞌizhno bega Dios ndontsa sun bega gan kontuꞌub bega be mbi bxin wa. ");
INSERT INTO zpt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Leꞌa gor na mkaꞌan bexa sa wa, cha nchaꞌtid bexa distrit Galilea. Ná leꞌa Jesús lá nlad iniꞌí be men leꞌa bexa ndesea sa wa, ");
INSERT INTO zpt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","geal leꞌa Jesús nluu be xmen na, ndab xa: —Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa be men. Leꞌa bexa wa gut naꞌ, parea gal wizh yon leꞌa naꞌ iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Leꞌa bexa wa ni lá yakbeꞌena ta ndab xa wa, ná leꞌa bexa nzheb inabdiꞌizhta xteꞌe gab ta wa. ");
INSERT INTO zpt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cha ulayaꞌ bexa Capernaum mlanseaꞌ bexa ta niꞌi. Cha unabdiꞌizh Jesús ndoꞌ be xmen xa, ndab xa: —¿Xtaꞌan nseabe yadiꞌizh bega nes wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Leꞌa bexa cha xetsa ute, geal leꞌa bexa nseaꞌbe yadiꞌizh ná ton mas nsak. ");
INSERT INTO zpt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Leꞌa Jesús cha usob, cha utezh xa isatibtop bexa wa, cha ndab xa: —Tal leꞌa dub bega nlad gak xa mas nsak, leꞌa xa wa nsabndoꞌ yak xa lult, no gun xa tiꞌin lat bega. ");
INSERT INTO zpt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Cha usen Jesús dub meꞌed, cha msoꞌ xa meꞌed tlaw bexa, cha udiꞌid xa meꞌed wa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Leꞌa tal ton dub xmen naꞌ utsin gak xa ndoꞌ dub meꞌed nak cuent meꞌed ndee, leꞌa xa wa cuentkata ndoꞌ naꞌ utsin nak. Leꞌa xa na utsin nak ndoꞌ naꞌ wa, leꞌa xa wa utsinga nak ndoꞌ xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Leꞌa Juan cha ndab ndoꞌ Jesús: —Mech, leꞌa besa uniꞌí dub men ndantiꞌin leaꞌ go gor na ngontuꞌub xa be mbi bxin. Ná leꞌa besa cha mka guntiꞌinta xa leaꞌ go, geal leꞌa xa naꞌanpa no nkeseano beuna. ");
INSERT INTO zpt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Leꞌa Jesús cha ndab: —Lá uka bega gun xa ta wa. Leꞌa tal ton dub xa ndantiꞌin lea naꞌ gun dub uyon, leꞌa xa wa naꞌanpa cha inisi naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Leꞌa tal ton naꞌanpa ndakloo ndoꞌ beuna, leꞌa xa wa dubtsa nak no beuna. ");
INSERT INTO zpt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No tal ton guntiꞌin lea naꞌ usaꞌa xa masa dub vas nits goo bega ta na nak bega xmen naꞌ, leꞌa naꞌ gáp ndoꞌ bega leꞌa Dios usaꞌaka ta wen nsabndoꞌ ikaꞌa xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Leꞌa tal ton utsabgix dub xa ndangea ladna naꞌ ndoꞌ ta ugap, leꞌa xa wa mas dub gealkweaꞌ siꞌil iniꞌí ndoꞌ dub xa nkea dub geꞌ siꞌil gen na, cha utsaꞌab be men xa len nitsdoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tal leꞌa dub yaꞌa bega utsabgix bega, ndi ulobtoꞌog bega‑yá. Mas wen yoo bega wats Dios moch bega, ndoꞌ itop yaꞌa bega yaꞌ bega infierno ndoꞌ giꞌ lá nyuꞌu, ");
INSERT INTO zpt_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","sa na nde mgeas lá ndat, nsea giꞌ nunk lá nyuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ná tal leꞌa dub xoꞌo bega utsabgix bega, ndi ulobtoꞌog bega‑yá. Mas wen yoo bega wats Dios nsea dubtsa xoꞌo bega, ndoꞌ itop xoꞌo bega yaꞌ bega infierno ndoꞌ giꞌ naꞌanpa nyuꞌu, ");
INSERT INTO zpt_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","sa na nde mgeas lá ndat, nsea giꞌ nunk lá nyuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No tal leꞌa dub ngusndoꞌ bega utsabgix bega, uloꞌo bega‑yá. Mas wen yoo bega wats Dios nsea dubtsa ngusndoꞌ bega, ndoꞌ itop ngusndoꞌ bega cha yaꞌ bega infierno, ");
INSERT INTO zpt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","sa na nde mgeas lá ndat nsea giꞌ nunk lá nyuꞌu. ");
INSERT INTO zpt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Leꞌa Dios guntiꞌin giꞌ ndontsa umbiꞌi gak bega ndoꞌ Dios, lak ndantiꞌin men sed gor na nsaꞌa xa man xnab ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Leꞌa sed dub ta wen, parea tal leꞌa sed itoꞌo ta utix ten na, ¿xteꞌema yak utix‑a stub biaj zha? Gok bega cuent sed utix, nsea utsin gok bega ndoꞌ be men ltsaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Leꞌa Jesús cha utoꞌo gezh wa nchaꞌa xa distrit Judea no stub toꞌo yowbeꞌe Jordán lad nlen wizh. Cha usaxangal mzhealbe kwaꞌad be men wats Jesús. Leꞌa Jesús cha mluugal bexa lakka ndun xa. ");
INSERT INTO zpt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Weꞌe leꞌa pla bexa fariseo ulen wats Jesús, nlad bexa gab Jesús dub ta lid leꞌa nak. Ta weꞌe unabdiꞌizh bexa ndoꞌ Jesús ndab bexa: —¿Utsin nak ulaꞌa dub xabgiꞌi xagots ten na zha? ");
INSERT INTO zpt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Leꞌa Jesús cha ukaꞌab ndab xa: —¿Xteꞌe ndab ley mkeꞌa Moisés, ta unibeꞌe Dios wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Leꞌa bexa cha ukaꞌab ndab: —Leꞌa ley mkeꞌa Moisés ndab syoꞌo gan ulaꞌa dub xa xagots ten xa, tal ned usaꞌa xa dub git ndoꞌ xagots wa, gab‑a leꞌa xa ulaꞌa xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Cha ukaꞌab Jesús ndab xa: —Geal ngud nak ladoꞌo bega, ta weꞌe mkeꞌa Moisés ta wa. ");
INSERT INTO zpt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ná leꞌa zha utexan gizhliyo leꞌa Dios mbindeꞌe xabgiꞌi nsea xagots. ");
INSERT INTO zpt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ta weꞌe ulaꞌa xabgiꞌi xus na nsea xnaꞌa na, zha na nkaꞌa xa xagots ten xa. ");
INSERT INTO zpt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Leꞌa cuent ten Dios leꞌa itop xa wa yak dubtsa men, yá lid topta xa. Weꞌe leꞌa bexa wa dubtsa men myak. ");
INSERT INTO zpt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ta weꞌe gáp naꞌ leꞌa bexa na mchealte Dios, lá nsabndoꞌ dub men uteltsaꞌa bexa. ");
INSERT INTO zpt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Leꞌa gor na mlanseaꞌ bexa ta lid bexa, leꞌa be xmen Jesús cha unabdiꞌizh stub biaj cuent ten ta mbidiꞌizh Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Leꞌa Jesús cha ndab: —Leꞌa tal ton dub xabgiꞌi ulaꞌa xagots ten na, cha ikaꞌa xa stubga xagots, leꞌa xabgiꞌi wa ugap ndanno xagots ned ten na wa, no ndap xa ke ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No liga tal leꞌa dub xagots ulaꞌa xabgiꞌi ten na, cha ikaꞌa xa stubga xabgiꞌi, leꞌa xagots wa ugap ndanno xabgiꞌi ned ten na wa, no ndap xa ke ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Weꞌe leꞌa be men ulanseano be meꞌed ten na wats Jesús, uxoꞌob Jesús yaꞌa na gek be meꞌed wa, inab xa ulaꞌach Dios be meꞌed. Ná leꞌa be xmen Jesús uteyo bexa na nseabeno be meꞌed wa. ");
INSERT INTO zpt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Leꞌa Jesús cha uniꞌí ta wa, cha ngokloo xa ndoꞌ be xmen xa, cha ndab xa: —Blaꞌa bego giꞌid be meꞌed baꞌ wats naꞌ. Lá uka bega giꞌid be meꞌed, leꞌa Dios nibeꞌe len ladoꞌo be men nak lak be meꞌed ndee. ");
INSERT INTO zpt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Leꞌa naꞌ gáp ndoꞌ bego, leꞌa tal ton lá ulaꞌa inibeꞌe Dios xa lak dub meꞌed, leꞌa xa wa nunk lá yate sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Cha udiꞌid Jesús be meꞌed wa, nsea mxoꞌob xa yaꞌa xa gek be meꞌed. Cha unab xa ndoꞌ Dios ulaꞌach Dios be meꞌed. ");
INSERT INTO zpt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Leꞌa gor na yaꞌikanes Jesús, leꞌa dub xabgiꞌi karrel ulen cha usaxib ndoꞌ Jesús, unabdiꞌizh xa ndab xa: —Mech wen, ¿xtaꞌan nsabndoꞌ gun naꞌ ndontsa no naꞌ gap gealnaban ndoꞌ Dios, ta nunk lá idub zha? ");
INSERT INTO zpt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Leꞌa Jesús cha ukaꞌab ndab: —¿Xtaꞌan ngi wen ndab lu ndoꞌ naꞌ zha? Naꞌan ton wen, ndon nab Dios nak wen. ");
INSERT INTO zpt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yá nchandoꞌ lu ley ten Dios ndab‑a: “Lá ugal lu xa ten stubga men. Lá gut lu men. Lá gun lu gealwaꞌan. Lá gun lu gealkwiꞌin. Lá ukedino lu men. Wankea xus lu nsea xnaꞌa lu.” ");
INSERT INTO zpt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Leꞌa xabgiꞌi wa cha ukaꞌab ndab: —Mech, itea ta ndab go baꞌ ndunka naꞌ idub zha tuzhta naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Weꞌe leꞌa Jesús mwiꞌi ndoꞌ xa, cha mkweaꞌ ladna Jesús xa, cha ndab Jesús ndoꞌ xa: —Stubtsa taꞌa ndun jwalt gun lu: nat byaꞌ, cha bdoꞌo iteanak ta ndap lu, cha btseꞌa med wa ndoꞌ bexa uban nak. Weꞌe gap lu sian taꞌa gibeꞌa. Cha utsea usankea tsoꞌo naꞌ, guniꞌi tal men xteꞌe gunno lu. ");
INSERT INTO zpt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Leꞌa xabgiꞌi wa kweaꞌ myoꞌo ladna gor na mbiꞌín xa ta wa. Ndon uban myoꞌo ladna xa nseaꞌ xa, geal leꞌa xa uzhebpa sian taꞌa ndap. ");
INSERT INTO zpt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Weꞌe leꞌa Jesús mwiꞌila gangeak, cha ndab xa ndoꞌ be xmen xa: —Uzheꞌeb ugan ulaꞌa dub men rik inibeꞌe Dios xa, bexa na li ndap sianpa be taꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Leꞌa be xmen Jesús ngwanseana be diꞌizh ndab Jesús wa, ná leꞌa Jesús cha ndabgal: —Bego bexa nak xiꞌín utsid naꞌ, uzhebpa ugan ulaꞌa dub xa rik inibeꞌe Dios xa, bexa na ngeꞌ ladna be ta sian ndap na. ");
INSERT INTO zpt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ndi mas lid bid itid dub came geꞌed xan dub yagux, ndoꞌ yate dub xa rik sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cha mas ngwanseana bexa, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Tonxá syoꞌo gan yate sa nibeꞌe Dios zhaga? ");
INSERT INTO zpt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Leꞌa Jesús mwiꞌi ndoꞌ bexa, ndab xa: —Leꞌa cuent ten nabtsa be men leꞌa‑yá lá yoo gan, ná leꞌa cuent ten Dios itea taꞌa syoꞌoka gan. ");
INSERT INTO zpt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Weꞌe leꞌa Pedr cha ndab: —Unaꞌ go, leꞌa besa mlaꞌa itea ta ndap besa, cha ndi usankea besa tsoꞌo ga. ");
INSERT INTO zpt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Cha ukaꞌab Jesús ndab xa: —Leꞌa naꞌ gáp ndoꞌ bego, leꞌa tal ton ulaꞌa lid na no wit na no bsan na no xus na no xnaꞌa na no xagots ten na no xmeꞌed na no be yo ten na ta na ndangea ladna xa naꞌ no diꞌizh ten naꞌ, ");
INSERT INTO zpt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","leꞌa xa wa ikayaꞌa dub gayoꞌo biaj mas sian be ta wa tiemp ndee. Leꞌa bexa wa gap lid na, wit na, bsan na, xnaꞌa na, xmeꞌed na, nsea yo. No kweaꞌ itid bexa, parea gal tiemp tiꞌi ilen leꞌa bexa gap gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ná kwaꞌad bexa nsak nat wa yak bexa naꞌanpa nsak; leꞌa bexa naꞌanpa nsak nat wa yak bexa nsak. ");
INSERT INTO zpt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Leꞌa gor na nsoꞌ bexa nes ikea bexa Jerusalén, leꞌa Jesús nchaꞌa ned. Leꞌa be xmen Jesús nchankea tsoꞌo Jesús, leꞌa bexa ndanseana no nzheb bexa. Weꞌe leꞌa Jesús cha mbiꞌi bexa wa dub lad, cha mbidiꞌizhgal xa be gealkweaꞌ iniꞌí xa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Blaꞌach bego leꞌa beuna nchaꞌbe Jerusalén, sa leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa be uleꞌay nibeꞌe no ndoꞌ be mech ten ley. Leꞌa bexa wa gab nsabndoꞌ gat naꞌ, cha yun bexa cuent naꞌ ndoꞌ be men naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Leꞌa bexa wa inisi naꞌ, nsea kin bexa naꞌ, nsea uchukko bexa ndoꞌ naꞌ, no gut bexa naꞌ. Parea gal wizh yon leꞌa naꞌ iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Weꞌe leꞌa Jacob nsea Juan be xin Zebedeo ubii wats Jesús ndab bexa: —Mech, leꞌa besa nlad usaꞌa go dub ta inab besa. ");
INSERT INTO zpt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Cha ndab Jesús: —¿Xtaꞌan nlad bega usa naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Leꞌa bexa cha ndab: —Usaꞌa go wats go sa inibeꞌe go kwe besa, dub besa wats ga lad gaꞌal, leꞌa stub besa lad raves. ");
INSERT INTO zpt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Leꞌa Jesús cha ndab ndoꞌ bexa: —Bego ni lá iniꞌí xtaꞌan unab bega. ¿Sxik bega itid bega gealkweaꞌ lakta gealkweaꞌ itiꞌid naꞌ zha? ¿No sni bega gat bega lak gat naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Leꞌa bexa cha ndab: —Leꞌa besa sxikka. Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp leꞌa bega stidka be gealkweaꞌ lakta gealkweaꞌ itiꞌid naꞌ, no sat bega lak gat naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Parea leꞌa sa kwe bega, dub bega wats naꞌ lad gaꞌal, no stub bega wats naꞌ lad raves, leꞌa sa wa naꞌanpa naꞌ inibeꞌe. Leꞌa Dios leꞌa gab ná ton kwe sa wa. ");
INSERT INTO zpt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Leꞌa gor na mbiꞌín isatiꞌi be xmen Jesús ta unab Jacob no Juan wa, cha ngokloo bexa. ");
INSERT INTO zpt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ná leꞌa Jesús cha utezh itea be xmen xa, ndab xa: —Leꞌa bego uniꞌíka leꞌa bexa nibeꞌe be nacion naꞌanpa ulaꞌa gun be men dub taꞌa naꞌanpa nibeꞌe bexa, no bexa mas nsak ten bexa uzhebpa nibeꞌe ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ná leꞌa bego ndee naꞌanpa li nsabndoꞌ gak. Ndi tal ton bega nlad gak dub xa nsak lat bega, leꞌa xa wa nsabndoꞌ gakno itea bega. ");
INSERT INTO zpt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","No tal ton bega nlad yansu lat bega, leꞌa xa wa nsabndoꞌ gun tiꞌin ndoꞌ iteanak bega. ");
INSERT INTO zpt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, naꞌanpa ndal gun be men tiꞌin ndoꞌ naꞌ. Leꞌa naꞌ ndi ndalyun tiꞌin ndoꞌ be men, no usa naꞌ gealnaban ten naꞌ gat naꞌ, kix naꞌ ke ten kwaꞌad be men. ");
INSERT INTO zpt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Leꞌa Jesús no be xmen xa cha nchaꞌtid gezh Jericó. Cha gor na nseatoꞌo bexa toꞌo gezh wa no kwaꞌad be men, leꞌa dub xabgiꞌi lá naꞌ nsobnab med toꞌo nes sa nchaꞌtid Jesús. Leꞌa xa wa nsaleaꞌ Bartimeo, xin Timeo. ");
INSERT INTO zpt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Leꞌa gor na mbiꞌín Bartimeo leꞌa xa nchaꞌtid wa nsaleaꞌ Jesús xa Nazaret, cha usaxan xa ugeꞌ ndab xa: —¡Jesús, xin David, blats ladna go naꞌ! ");
INSERT INTO zpt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cha kwaꞌad bexa uteyo xa wa ndab bexa ndoꞌ xa yá naꞌanta xteꞌe gab xa. Ná leꞌa xa wa ndi mas ugeꞌ ndab: —¡Xin David, blats ladna go naꞌ! ");
INSERT INTO zpt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Weꞌe leꞌa Jesús cha ngwaꞌisoꞌ ndab xa: —Utezh bega xa na li ugeꞌ níꞌi wa. Cha ngwaꞌtezh bexa Bartimeo, ndab bexa: —Bten ladna lu, gosoꞌ, leꞌa Jesús nbezh lu. ");
INSERT INTO zpt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Leꞌa xa wa cha ngwasoꞌ, udabi xa lad nbix xa, cha ubii xa wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Leꞌa Jesús cha ndab ndoꞌ xa: —¿Xtaꞌan nlad lu gunno naꞌ lu zha? Leꞌa xa wa cha ndab: —Mech, leꞌa naꞌ nlad inaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Leꞌa Jesús cha ndab: —Nat syoꞌo gan yaꞌ lu, leꞌa lu myaklana ta na mgeꞌ ladna lu naꞌ. Cha bi leꞌa gor wa leꞌa xa cha mnaꞌla. Weꞌe cha no xa usankea tsoꞌo Jesús nes wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Leꞌa ngol gor nsalayaꞌ gax bexa wa Jerusalén, gax sa nde gezh Betfagé nsea gezh Betania, sa nsob Bet Olivo, leꞌa Jesús cha mtuꞌub top be xmen na, ");
INSERT INTO zpt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ndab xa: —Waꞌ bega len gezh nde ndoꞌ ndee. Leꞌa toꞌo gezh baꞌ iniꞌí bega nsoꞌ nchii dub burr tuzh naꞌan ton gol sob tsoꞌo na. Cha bxaꞌak bega ma, goꞌo bega ma sa ndee. ");
INSERT INTO zpt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Leꞌa tal ton inabdiꞌizh ná xtaꞌan ngi nxaꞌak bega ma, cha gab bega: “Leꞌa Mech guntiꞌin ma dub xlaꞌal, cha yakka cuent ma.” ");
INSERT INTO zpt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Weꞌe leꞌa be xmen Jesús wa cha nchaꞌbe. Cha mzheal bexa burr tuzh wa nsoꞌ nchii toꞌo nes sa wa, cha mxaꞌak bexa ma. ");
INSERT INTO zpt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Leꞌa pla bexa nde sa wa unabdiꞌizh ndoꞌ bexa, ndab xa: —¿Xtaꞌan ngi nxaꞌak bega burr baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Weꞌe leꞌa be xmen Jesús ukaꞌab ndab ndoꞌ bexa wa laktsa ndab Jesús gab bexa. Leꞌa bexa cha naꞌanta xteꞌe ngabbe. ");
INSERT INTO zpt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cha mbiꞌi bexa burr wa wats Jesús. Cha mxoꞌob bexa dubga xab bexa tsoꞌo ma, cha usob Jesús tsoꞌo ma. ");
INSERT INTO zpt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","No kwaꞌad be men mte be lad nbix bexa ndoꞌ nes sa isea ma. No ncho bexa ulobtoꞌog be xos ya gin, cha mte bexa‑yá nes wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Leꞌa be men nchaꞌbe ned ndoꞌ Jesús no be men nseabenkea tsoꞌo Jesús ugeꞌ ndab: —¡Siꞌil nak xa baꞌ! ¡Dios uzhebpa nlaꞌach xa baꞌ, xa na mtuꞌub Dios Xa Nibeꞌe! ");
INSERT INTO zpt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡No nkeseano Dios xa baꞌ, leꞌa xa inibeꞌe lak unibeꞌe David xus beuna! ¡Siꞌil nak Dios nsob gaꞌap! ");
INSERT INTO zpt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Leꞌa gor na uyote Jesús len gezh Jerusalén, cha nchaꞌa xa sa nde niꞌi ten Dios. Cha mwiꞌi Jesús gangeak ndoꞌ itea be ta ncho sa wa. Leꞌa gor wa yá uzhela, ta weꞌe nseaꞌ Jesús gezh Betania no isatibtop be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngol stubtsa wizh leꞌa bexa wa utoꞌo gezh Betania nchaꞌagal bexa Jerusalén. Leꞌa nes wa leꞌa Jesús ndanna. ");
INSERT INTO zpt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Cha sitta naꞌ xa nsob dub ya higo nsoꞌ la. Cha utoꞌo Jesús nchaꞌwiꞌi naga lid no ngus nsoꞌ ndoꞌ ya wa. Parea naꞌanpa izheal xa ngus, ndi latsa nsoꞌ ndoꞌ‑yá, leꞌa ta wa naꞌanpa tiemp ten ngus higo wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cha ndab Jesús ndoꞌ ya wa: —Idub isob lu naꞌantapa isoꞌ ngus gaw men ndoꞌ lu. Leꞌa be xmen Jesús mbiꞌín ta li ndab Jesús ndoꞌ ya wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Leꞌa gor na ulayaꞌ bexa Jerusalén, cha nchaꞌa Jesús sa nde niꞌi ten Dios. Cha usaxan ngontuꞌub xa bexa nadoꞌotiꞌix taꞌa sa wa. No mtixte xa be mes ten bexa ntil be med, no be yaxil ten bexa ndiꞌibudoꞌo be palom. ");
INSERT INTO zpt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Cha lá ulaꞌata Jesús itidno be men be taꞌa tale ten niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Weꞌe usaxan xa nluu xa be men, ndab xa: —¿Lá iniꞌí bega zha xteꞌe nkeaniꞌi diꞌizh ten Dios? Ndab Dios: “Leꞌa lid naꞌ isaleaꞌ dub sa ndadiꞌizhno be men naꞌ, bexa ncho idub ndoꞌ gizhliyo.” Ná leꞌa bego ndi ndanno‑yá cuent dub geꞌloꞌo ten waꞌan. ");
INSERT INTO zpt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Leꞌa gor na mbiꞌín be mech ten ley no be uleꞌay nibeꞌe ta li ndab Jesús, cha usaxan nkwaꞌan bexa ná xteꞌe gut bexa Jesús. Ná leꞌa iteata be men ndanseana be ta nluu Jesús, ta weꞌe mzheb bexa nsak wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Leꞌa ngol gor yá uzhe, leꞌa Jesús cha utoꞌo gezh wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngok stubtsa wizh tempran nsatidgal Jesús no be xmen xa gax sa nsob ya higo wa. Weꞌe uniꞌí bexa leꞌa ta wa ubidla gast itea loꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Weꞌe leꞌa Pedr mtseꞌa ladna ta ndab Jesús ndoꞌ ya wa. Cha ndab Pedr ndoꞌ Jesús: —Mech, bwiꞌi ga leꞌa ya higo na ndab go ndoꞌ na yá naꞌantapa usaꞌa ngus wa, yá ubidla. ");
INSERT INTO zpt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Leꞌa Jesús cha ndab: —Bgeꞌ ladna bega Dios. ");
INSERT INTO zpt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Leꞌa naꞌ gáp ndoꞌ bega leꞌa tal ton gab ndoꞌ bet ndee: “Utatsob, waꞌ len nitsdoꞌo”, cha naꞌanpa igan ladna xa ta wa, ndi gungea ladna xa ta li ndab xa wa, leꞌa ta wa sakka. ");
INSERT INTO zpt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ta weꞌe ndáp naꞌ ndoꞌ bego, leꞌa itea ta inab bega ndoꞌ Dios, bingeatsa ladna bega‑yá, leꞌa Dios saꞌaka ta wa. ");
INSERT INTO zpt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Leꞌa gor na ndadiꞌizhno bega Dios, bingeꞌ ladna bega ndoꞌ tal ton xteꞌe mbinno bega, ndontsa no Dios Xus beuna nsob gibeꞌa sungeꞌ ladna ke ten bega. ");
INSERT INTO zpt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ná tal leꞌa bega lá gungeꞌ ladna ndoꞌ be men ugap ndanno bega wa, leꞌa Dios Xus beuna nsob gibeꞌa noga naꞌanpa gungeꞌ ladna be ke ten bega. ");
INSERT INTO zpt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Leꞌa gor na mlanseagal bexa Jerusalén, cha nchaꞌa Jesús sa nde niꞌi ten Dios. Weꞌe leꞌa be mech ten ley no be uleꞌay nibeꞌe no bexa gox nsak ulen wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Leꞌa bexa wa cha unabdiꞌizh ndoꞌ Jesús ndab bexa: —¿Ton ulaxoꞌob lu gun lu be ta wa zha? ¿Nati ton mtuꞌub lu gun lu ta wa? ");
INSERT INTO zpt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ no inabdiꞌizh dub taꞌa ndoꞌ bega. Tal leꞌa bega ikaꞌab, weꞌe no naꞌ gáp ná ton ulaxoꞌob naꞌ li gun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ton mtuꞌub Juan ulaleaꞌ Juan be men zha? ¿Dios nati dub men? ¡Gud bega‑yá! ");
INSERT INTO zpt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Leꞌa bexa cha ndab ndoꞌ be ltsaꞌa na: —Tal leꞌa beuna gab leꞌa Dios leꞌaka mtuꞌub Juan, leꞌa Jesús inabdiꞌizh ná xtaꞌan lá ngungea ladna beuna xa. ");
INSERT INTO zpt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Parea lá yoo gan gab beuna leꞌa Juan dub men mtuꞌub. Nzheb bexa gab bexa ta wa, geal leꞌa itea be men mbingea ladna leꞌa Juan dub profet mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ta weꞌe ndab bexa ndoꞌ Jesús: —Leꞌa besa lá iniꞌí ton mtuꞌub Juan. Leꞌa Jesús cha noga ndab: —Naꞌ noga lá gáp ton ulaxoꞌob naꞌ gun naꞌ be ta ndee. ");
INSERT INTO zpt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Weꞌe leꞌa Jesús usaxan mbidiꞌizh xa dub taꞌa msaktabeꞌe xa, ndab xa: —Uyoꞌo dub xabgiꞌi ngos ya uv ndoꞌ dub bleꞌa yo ten xa. Cha ulo xa lo idub gangeak wats‑a. No mbindeꞌe xa dub sa gachkeꞌe uv wa, koꞌo xa nits ten‑a. Cha mbindeꞌe xa dub sa gaꞌap isob xa ulaꞌach sa wa. Cha mkwaꞌan xa pla men gun tiꞌin. Cha nchaꞌa xa sit. ");
INSERT INTO zpt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Leꞌa zha na ngol tiemp ten uv, cha mtuꞌub xa dub xmos xa yaꞌ ndoꞌ be men nlaꞌach uv, yaꞌyoꞌo xa ta na ndal xwan yo wa. ");
INSERT INTO zpt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ná leꞌa be men wa ndi usen mos wa, cha udin bexa xa. Cha naꞌan xtaꞌan usaꞌa bexa yoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Leꞌa xwan yo wa cha mtuꞌubgal stub mos. Ná leꞌa be men wa ndi mlaꞌgeꞌ gek mos, no xela mbinno bexa xa. ");
INSERT INTO zpt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Weꞌe leꞌa xwan yo wa mtuꞌubgal stub mos, ná leꞌa be men wa mbit xa wa. Cha mtuꞌub xa stapla be xmos xa, parea ncho xa wa udin bexa, no ncho xa wa mbit bexa. ");
INSERT INTO zpt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Weꞌe cha mtea be xmos xwan yo wa. Lulttsa ndap xa dubtsa xin xa, xa nkweaꞌ ladna xa. Cha mtuꞌub xa xin xa wa, mbinbeꞌe xa leꞌa be men wa gap mod ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ná leꞌa be men wa ndi ndabbe ndoꞌ ltsaꞌa na: “Leꞌa xa baꞌ leꞌa yaꞌanno yo ndee. Nchaꞌyut beuna xa, cha yaꞌanno beuna‑yá.” ");
INSERT INTO zpt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cha usen bexa xa, cha mbit bexa xa, cha udabi bexa xa dub lad toꞌo yo wa. ");
INSERT INTO zpt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Cha unabdiꞌizh Jesús ndab xa: —¿Xteꞌe nsak bega zha? ¿Xteꞌe gun xwan yo wa nat? Leꞌa xa wa ilen gut be men mlaꞌach yo wa. Cha usaꞌa xa yo wa ndoꞌ bexa xaꞌaga ulaꞌach‑a. ");
INSERT INTO zpt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Lá iniꞌí bega xteꞌe nkeaniꞌi diꞌizh ten Dios zha? Ndab‑a: Leꞌa geꞌ na mxelad bexa ndandeꞌe niꞌi, leꞌa ta wa nat nak geꞌ ndon leꞌa nsak nbexan niꞌi. ");
INSERT INTO zpt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Leꞌa Dios leꞌa mbin ta ndee, dub ta ndanseana beuna. ");
INSERT INTO zpt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Weꞌe leꞌa bexa nsak wa cha nlad isen Jesús, geal leꞌa bexa myakbeꞌenabe leꞌa Jesús li ndab cuent ten bexa. Parea leꞌa bexa nzheb ndoꞌ be men kwaꞌad wa, ta weꞌe mlaꞌa bexa Jesús, cha nseaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cha mtuꞌub bexa pla bexa fariseo no pla be xmen Herodes yaꞌbe yun preb Jesús, ndontsa gab Jesús dub taꞌa usake bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Leꞌa bexa cha ulayaꞌ wats Jesús ndab bexa: —Mech, leꞌa besa uniꞌí leꞌa go ndadiꞌizh gealngea. No ni lá nlaꞌach ga ta ndab be men, no ni tal xteꞌe nak be men, leꞌa go ndi wen nluu lak nlad Dios gak be men. Ta weꞌe nabdiꞌizh besa ndoꞌ ga, ¿nsabndoꞌ kix beuna med nab César xa nibeꞌe Roma nate naꞌanpa kix beuna‑yá? ¿Saꞌa beuna‑yá nate naꞌan? ");
INSERT INTO zpt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ná leꞌa Jesús mgenna ta ugap ndanbeꞌe bexa, cha ndab Jesús: —¿Xtaꞌan ndun bega preb naꞌ zha? Bsaꞌa bega dub med iwiꞌi naꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Leꞌa bexa wa cha msaꞌa dub med ndoꞌ Jesús. Leꞌa Jesús cha ndab ndoꞌ bexa: —¿Ton gek na no leaꞌ na nkea las med ndee zha? Leꞌa bexa wa cha ndab: —Gek César no leaꞌ César. ");
INSERT INTO zpt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Cha ndab Jesús: —Bsaꞌa bega ta ten César ndoꞌ César. Leꞌa ndoꞌ Dios bsaꞌa bega ta ten Dios. Cha ngwanseana bexa xteꞌe ukaꞌab Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Weꞌe ulen pla bexa saduceo wats Jesús. Leꞌa bexa saduceo ndangea ladna leꞌa bexa ngut wa lá ibantabe. Cha unabdiꞌizh bexa ndoꞌ Jesús, ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mech, leꞌa ley mkeꞌa Moisés ndab leꞌa tal ton dub xabgiꞌi gat, ná lá ngap xa xin xa, leꞌa wit xa wa nsabndoꞌ uchilyaꞌano xagots ten xa ngut wa, ndontsa tal gap bexa dub meꞌed leꞌa meꞌed wa gak cuent xin xa ngut wa. ");
INSERT INTO zpt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uyoꞌo dub gaꞌad wit xa. Leꞌa xa ned wa mchilyaꞌano dub xagots, cha tsoꞌo wa ngut xa ni lá ngap xagots wa xin xa. ");
INSERT INTO zpt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Weꞌe cha mchilyaꞌano wit itop xa wa xagots wa. Leꞌa xabgiꞌi wa cha noga ngut, ni lá ngapgal xa xin xa. Leꞌa wit yon bexa wa litsagal ngwasea. ");
INSERT INTO zpt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cha li ngwasea isagaꞌad wit bexa, ná ni dub xa lá ngap xagots wa xin na. Tsoꞌo wa leꞌa xagots wa noga ngut. ");
INSERT INTO zpt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Leꞌa gal zha iban bexa ngut wa, lat bexa wa ¿ton gak xabgiꞌi ten xagots wa, xa na li mchilyaꞌano isagaꞌad xabgiꞌi wa? ");
INSERT INTO zpt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Leꞌa Jesús cha ukaꞌab ndab: —Uzhebpa lid leꞌa ndanbeꞌe bega, geal leꞌa bega lá nyakbeꞌena xteꞌe gab diꞌizh ten Dios, no ni lá nchandoꞌ bega juers ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Leꞌa gal zha na iban bexa ngut, leꞌa be men yá naꞌantapa uchilyaꞌano be ltsaꞌa na zha wa. Leꞌa bexa ndi gak cuent be angel ten Dios ncho gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Parea leꞌa cuent ten ta iban bexa ngut wa, ¿lá ndoꞌol bega libr mkeꞌa Moisés, xteꞌe uníꞌi Dios lat dub yagich zha? Ndab Dios leꞌa xa leꞌa nak Dios ndankea Abraham, no Isaac, no Jacob. ");
INSERT INTO zpt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Leꞌa Dios naꞌanpa Dios ten bexa ngut, leꞌa xa ndi Dios ten bexa nban, ta nluu leꞌa bexa wa nbanka. Ta weꞌe ndáp naꞌ leꞌa bega uzhebpa lid leꞌa ndanbeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Leꞌa gor na mbiꞌín dub mech ten ley ta nsoꞌyadiꞌizhno Jesús bexa saduceo wa, leꞌa xa wa uniꞌí leꞌa Jesús leꞌaka ukaꞌab ndoꞌ bexa. Weꞌe cha ubii xa wats Jesús, cha unabdiꞌizh xa ndab xa: —¿Ma ta na mas nsak lat be ta unibeꞌe Dios zha? ");
INSERT INTO zpt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ná mas nsak wa nkeaniꞌi ndab‑a: “Blaꞌach bega xa Israel, leꞌa Dios Xa Nibeꞌe ten beuna dubkama nak Dios. ");
INSERT INTO zpt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wankea Dios Xa Nibeꞌe idub ncho ladna ladoꞌo lu no idub gealnaban ten lu no idub lak ndanbeꞌe lu no idub juers ten lu.” Leꞌa ná ndee wa mas nsak ndoꞌ iteanak be ta unibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Leꞌa ná itop ndee lakkaga nak ná ned wa: “Bkweaꞌ ladna lu be ltsaꞌa lu lakkata lu.” Yá naꞌan stub taꞌa nibeꞌe Dios mas nsak ndoꞌ itop ta ndee. ");
INSERT INTO zpt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Weꞌe leꞌa mech ten ley wa cha ndab: —Leꞌaka ndab go, mech. Ugeaka ta ndab go leꞌa Dios dubtsa, yá naꞌan stub dios xaꞌaga. ");
INSERT INTO zpt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Leꞌa ta na yankea be men Dios idub ncho ladna ladoꞌo xa, no idub lak ndanbeꞌe xa, no idub juers ten xa, no ikweaꞌ ladna xa be ltsaꞌa xa lakkata leꞌa xa, leꞌa be ta wa mas nsak ndoꞌ xnab ten be man no ndoꞌ iteata be taꞌa nsaꞌa be men ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Leꞌa gor na mnaꞌla Jesús leꞌa mech wa leꞌaka ukaꞌab, cha ndab Jesús ndoꞌ xa: —Leꞌa lu gaxla nak ulaꞌa lu inibeꞌe Dios lu. Weꞌe ni stub xa wa ni lá ngun rages inabdiꞌizhta xa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Leꞌa Jesús ndadiꞌizh ndoꞌ be men nde gax wats niꞌi ten Dios, ndab xa: —¿Xtaꞌan ndab be mech ten ley leꞌa zha ilen Cristo leꞌa xa wa nak xin David zha? ");
INSERT INTO zpt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ná leꞌa David leꞌaka ndab sakndoꞌ Espíritu ten Dios, ndab xa: Leꞌa Dios Xa Nibeꞌe ndab ndoꞌ Xa Nibeꞌe ten naꞌ: “Usob wats naꞌ lad gaꞌal ndee, gast gal gor ute naꞌ bexa ndaklono lu xan ndats lu.” ");
INSERT INTO zpt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Leꞌa David ndab leꞌa Cristo nak Xa Nibeꞌe ten xa. ¿Ná xteꞌe yoo gan gak Cristo wa xin David zha? Leꞌa bexa kwaꞌad wa cha mten ladna mbiꞌín ta ndab Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Leꞌa Jesús cha nluu bexa, ndab Jesús: —Blaꞌach bego lá gak bega lak nak be mech ten ley, leꞌa bexa ndal ladna ndesea nak lad koꞌol. No nlad bexa utsin inidiꞌizh be men ndoꞌ xa be ndoꞌ xgeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","No nti bexa be sa mas nsak isob bexa len be niꞌi sa nzhealbe beuna xa judio, no liga ndun bexa sa ndaꞌdaw bexa sa nyoꞌo dub gast. ");
INSERT INTO zpt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nsea nlat bexa be ta ndap be xagots ngut xabgiꞌi ten na. No kwenpa ndadiꞌizh bexa ndoꞌ Dios ndontsa gab be men leꞌa xa uzheꞌeb ndankea Dios. Leꞌa naꞌ gáp leꞌa bexa li ndun wa mas uzheꞌeb gealkweaꞌ iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cha ngwatsob Jesús gax wats sa nsaꞌa be men med gon tale ten niꞌi ten Dios. Cha mwiꞌi xa xteꞌe nsaꞌa be men med wa. Leꞌa kwaꞌad men rik ulen, msaꞌa bexa sian med. ");
INSERT INTO zpt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Leꞌa dub xagots prob ngut xabgiꞌi ten na no ulen, cha msaꞌa xa top med byux uxee nsak. ");
INSERT INTO zpt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Weꞌe cha utezh Jesús be xmen na, cha ndab xa: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa xagots prob ndee msaꞌa mas sian med ndoꞌ iteanak bexa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Leꞌa bexa msaꞌa sbeꞌen ta myaꞌan sobrtsa, ná leꞌa xagots ndee msaꞌa iteanak be med isiꞌi xa be taꞌa nkiꞌin xa. ");
INSERT INTO zpt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Leꞌa gor utoꞌo Jesús tale ten niꞌi ten Dios, leꞌa dub xmen xa ndab: —Mech, bwiꞌi go be niꞌi chul ndee no be geꞌ ubiꞌi nakchaꞌaw niꞌi ten Dios ndee. ");
INSERT INTO zpt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Leꞌa Jesús cha ndab: —Leꞌa gal dub wizh leꞌa be niꞌi lbaꞌa naꞌ lu baꞌ ilate, gast ni stub geꞌ baꞌ lá kwiꞌibta tsoꞌo ltsaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cha nchaꞌa bexa Bet Olivo, sa nluxeꞌa niꞌi ten Dios, cha usob Jesús. Weꞌe leꞌa nabtsa Pedr no Jacob no Juan no Ndres unabdiꞌizh ndoꞌ Jesús, ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Gud ga, ¿pol gak be ta li ndab go wa zha? ¿No xteꞌe iniꞌí besa zha na yamer gak‑a? ");
INSERT INTO zpt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Leꞌa Jesús cha ukaꞌab ndab: —Gop bega cuent ndontsa naꞌan ton ukwiꞌinno bega. ");
INSERT INTO zpt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Leꞌa kwaꞌad be men ilen gab leꞌa xa nak Cristo xa mtuꞌub Dios, ukwiꞌinno bexa kwaꞌad be men. ");
INSERT INTO zpt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Leꞌa gor na goꞌón bega ncho guerr be sa sit no be sa gax, lá yuꞌ ladna bega. Leꞌa ta wa nsabndoꞌka yoo, ná leꞌa zha wa biseata gal be wizh lult. ");
INSERT INTO zpt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Leꞌa gal zha wa kuyo nacion no stubga nacion. No leꞌa xmen dub xa nibeꞌe kuyono be xmen stubga xa nibeꞌe. No sian sa gak be xoꞌo ubiꞌi. No yoo win nsea uzheꞌeb kwesaxaꞌach be men. Leꞌa be ta ndee wa pen isobxanma be gealkweaꞌ ilen wa. ");
INSERT INTO zpt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’No blaꞌach bega leꞌaka bega, leꞌa be men yun cuent bega ndoꞌ bexa nibeꞌe ten bexa, no kin bexa bega len be niꞌi sa nzhealbe bexa judio. Leꞌa bexa yun cuent bega ndoꞌ bexa naktiꞌin ubiꞌi no ndoꞌ bexa nibeꞌe, cha usake xa bega ke na nak bega xmen naꞌ. Leꞌa gor weꞌe sak gudiꞌizh bega cuent ten naꞌ ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Parea leꞌa diꞌizh wen ten Dios nsabndoꞌ nedka iteꞌachso idub nax ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Leꞌa zha na isen bexa bega no yun bexa cuent bega, lá yuꞌ ladna bega xteꞌe ikaꞌab bega, leꞌa gor wa leꞌa Dios saꞌaka diꞌizh iníꞌi bega. Leꞌa ta wa naꞌanpa bego iníꞌi, leꞌa ta wa Espíritu ten Dios iníꞌi. ");
INSERT INTO zpt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Leꞌa zha wa ncho be men leꞌaka wit na yun cuent gat xa ke ndangea ladna xa naꞌ. No nchoga bexa liga yun cuent leꞌaka xin na. No ncho bexa gakloo ndoꞌ leꞌaka xus xa gast gut bexa xus xa. ");
INSERT INTO zpt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","No itea men ixeeno ladna bega ke na nak bega xmen naꞌ. Parea leꞌa tal ton bega uxik ndoꞌ be gealkweaꞌ wa no bi ngeꞌka ladna bega naꞌ, leꞌa bega wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Leꞌa profet Daniel mkeꞌa leꞌa gal zha yoo dub ta uzhebpa ugap no bzhiꞌik len niꞌi ten Dios, sa lá nsabndoꞌ yoo‑yá (leꞌa xa ndoꞌol ta ndee nsabndoꞌ yakbeꞌena‑yá). Leꞌa gal zha iniꞌí bega ta wa, weꞌe leꞌa bexa ndencho Judea ndee nsabndoꞌ uxoꞌonbe yaꞌbe bexa be geꞌe ubiꞌi. ");
INSERT INTO zpt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Leꞌa be men ndiꞌib gek lid na wa ni lá igen koꞌo be ta ten na len lid na. ");
INSERT INTO zpt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Leꞌa bexa ndeyun tiꞌin geꞌe ni lá nsabndoꞌ yachta ilenyoꞌo be xab na. ");
INSERT INTO zpt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Leꞌa gal zha wa uzhebpa kweaꞌ itid be xagots nsoꞌno meꞌed no be xagots ndap medoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Unab bega ndoꞌ Dios, ndontsa leꞌa tiemp uxoꞌon bega wa naꞌanpa gal tiemp kwal. ");
INSERT INTO zpt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Leꞌa be wizh weꞌe yoo dub gealkweaꞌ siꞌil, dub ta nunk gol yoꞌo zha mbindeꞌeta Dios gizhliyo, no ni lá yoota‑yá stub biaj. ");
INSERT INTO zpt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tal leꞌa Dios ulaꞌa sian wizh yoo ta uzheꞌeb wa, leꞌa be men stea gat. Parea lá ulaꞌa Dios yoo sian wizh wa, geal leꞌa xa nlats ladna bexa mti xa. ");
INSERT INTO zpt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Weꞌe leꞌa tal ton gab ndoꞌ bega: “Bwiꞌi bego, leꞌa xa ndee Cristo”, no tal gab xa: “Unaꞌ bego, leꞌa xa baꞌ Cristo”, lá gungea ladna bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Leꞌa kwaꞌad bexa ukwiꞌin ilen gab leꞌa nak Cristo, no ilen bexa ukwiꞌin gab leꞌa ndadiꞌizh sakndoꞌ Dios. Leꞌa bexa wa no gun sian taꞌa yanseana be men, ndontsa ukwiꞌinno bexa be men. No ukwaꞌan bexa xteꞌe ukwiꞌinno bexa bexa mti Dios. ");
INSERT INTO zpt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Blaꞌach bega, leꞌa naꞌ yá ndáp nedla ta ndee ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Parea leꞌa be wizh wa, zha na yá mtea be gealkweaꞌ wa, leꞌa ndoꞌ wizh ikaw, leꞌa mbeꞌe yá lá usuta xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Leꞌa be mbeal ndiꞌib gaꞌap baꞌ ilate, no gast idub gibeꞌa iwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Leꞌa zha weꞌe iniꞌí be men leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilennogal juers ten Dios lat xkaw no dub xeꞌa siꞌil. ");
INSERT INTO zpt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cha utuꞌub naꞌ be angel ten naꞌ yunjunt bexa mti Dios itea lad ndoꞌ gizhliyo, gast sa mas sit ndoꞌ gizhliyo no sa mas sit gibeꞌa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Bwiꞌi bego lak nak be ya higo. Leꞌa zha na nxich be ya wa, leꞌa bego uniꞌíka leꞌa tiemp bigi yá gal. ");
INSERT INTO zpt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","No liga leꞌa zha na naꞌ bega ncho be ta mbidiꞌizh naꞌ ndee wa, weꞌe iniꞌí bega leꞌa naꞌ ndee yamer ilengal. ");
INSERT INTO zpt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Leꞌa naꞌ gáp ndoꞌ bega leꞌa itea be ta ndee itid zha na biseata gat be men ncho gal zha wa. ");
INSERT INTO zpt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Leꞌa gibeꞌa no gizhliyo initndoꞌ, parea leꞌa ta ndáp naꞌ ndee naꞌanpa initndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Parea naꞌan ton iniꞌí xá wizh na‑yá no xá gor yoo be ta ndee. Ni be angel ncho gibeꞌa ni naꞌ xa nak Xin Dios lá iní ta wa. Nabtsa Tad Dios uniꞌí ná pol yoo‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ta weꞌe list ute bega no blaꞌach bega no bidiꞌizhno bega Dios, leꞌa bega lá iniꞌí pol yoo be ta ndee. ");
INSERT INTO zpt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Leꞌa ta wa cuent dub xabgiꞌi ikaꞌan yaꞌ sit. Leꞌa gor na nlaꞌa xa lid xa, ndab xa ndoꞌ be xmos xa: “Kadga dub bega bin bega tiꞌin ndáp naꞌ.” No ndab xa ndoꞌ xa nlaꞌach toꞌo puert wa uzheꞌeb list isoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Li list ute bega leꞌa bega lá iniꞌí xá gor ilen xwan niꞌi wa, ga ilen xa gor uzhe, nate utol teꞌal, nate gor nbezh boy, nate gor ngotla xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Li gak bega ndontsa guniꞌi xá gor itanchaꞌ xa, lá gaꞌigaꞌa bega ndeyats bega. ");
INSERT INTO zpt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Leꞌa ta ndáp naꞌ ndoꞌ bego wa, leꞌa ta wa ndáp naꞌ ndoꞌ itea be men: list ute bega. ");
INSERT INTO zpt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Leꞌa zha na nsob stop wizh gal ujest Pascua, zha ndaw bexa judio pan naꞌan levadur, leꞌa be uleꞌay nibeꞌe no be mech ten ley nkwaꞌan ná xteꞌe isen bexa Jesús dub mod na lá iniꞌí be men‑a, cha gut bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Parea ndab bexa naꞌanpa isen bexa Jesús len ujest, ndontsa lá ixaꞌach be men gakloo ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Leꞌa dub wizh nsob Jesús ta lid Simón xa Betania, xa na mas polta usak gealgizh lepra. Weꞌe ulen dub xagots sa nsob Jesús ndoꞌ mes, nsea dub bot tuzh nakchaꞌaw geꞌ alabastro ncho sbeꞌen nardo ta uxeꞌe, dub ta uyappa nsak. Cha utiꞌich xa gen bot wa ndontsa myaꞌal‑a, cha ulo xa ta uxeꞌe wa gek Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Leꞌa ncho bexa nde sa wa ngokloo ndab bexa ndoꞌ be ltsaꞌa xa: —¿Xtaꞌan ngi mbizhaꞌa xagots ndee ta uxeꞌe baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tal leꞌa xa ndi udoꞌo‑yá, leꞌa xa yoꞌo gan utseꞌa med wa ndoꞌ bexa uban nak. Leꞌa ta baꞌ nsak masa chon gayoꞌo denario. Cha kweaꞌ uníꞌi bexa ndoꞌ xagots wa. ");
INSERT INTO zpt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naꞌ leꞌa Jesús ndab ndoꞌ bexa: —Blaꞌa bega xagots baꞌ. ¿Xtaꞌan ngi li nisi bega xa zha? Leꞌa xa dub ta wen mbin ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Leꞌa bexa uban nak guniꞌi polga nchoka lat bega. No guniꞌi pol nlad bega, sak usaꞌa bega ta nkiꞌin bexa. Parea leꞌa naꞌ ndee naꞌanpa kwenta nchoꞌono bega. ");
INSERT INTO zpt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Leꞌa xagots ndee mbin laktsa msuꞌu xa. Leꞌa xa ulo ned ta uxeꞌe gek naꞌ, gor biseata gal zha igaꞌach naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Leꞌa naꞌ gáp ndoꞌ bega guniꞌi pa ndoꞌ gizhliyo gudiꞌizh be men diꞌizh wen ten Dios, no ta mbin xagots ndee gudiꞌizh bexa, ndontsa iniꞌí be men ta wen mbin xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Weꞌe leꞌa Judas Iscariot, dub xa nak isatibtop xmen Jesús, ngwaꞌ ndoꞌ be uleꞌay nibeꞌe, ndab xa leꞌa xa syun cuent Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Leꞌa gor na mbiꞌín bexa ta wa, cha mten ladna bexa, ndab bexa ndoꞌ Judas leꞌa bexa usaꞌa med. Leꞌa Judas cha usaxan mkwaꞌan ná xteꞌe yun xa cuent Jesús ndoꞌ yaꞌa bexa. ");
INSERT INTO zpt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Leꞌa ngol wizh ned ten ujest zha ndaw bexa pan naꞌan levadur, wizh ndut bexa dub borreg ndaw bexa cuent ten ujest Pascua, leꞌa be xmen Jesús ndab ndoꞌ Jesús: —¿Pa nlad go yaꞌyundeꞌe besa ta gaw beuna ujest Pascua? ");
INSERT INTO zpt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Leꞌa Jesús cha mtuꞌub top xmen xa, ndab xa: —Waꞌ bega gezh Jerusalén baꞌ, leꞌa gal sa izheꞌal bega dub xabgiꞌi noꞌo dub te ncho nits, cha usankea bega tsoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Leꞌa sa na ilanseaꞌ xa, cha gud bega ndoꞌ xwan niꞌi wa: “Leꞌa mech nabdiꞌizh ná xá cuart ná usaꞌa ga gawno mech be xmen xa ta ten ujest Pascua.” ");
INSERT INTO zpt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Leꞌa xwan niꞌi wa cha uluu dub cuart siꞌil ndoꞌ bega, ta nde gek niꞌi wa. Leꞌa sa wa listla nde be taꞌa guntiꞌin bega. Cha binchaꞌaw bega be ta gaw beuna sa wa. ");
INSERT INTO zpt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Leꞌa be xmen Jesús cha utoꞌo nchaꞌbe len gezh wa. Weꞌe cha mzheꞌalka bexa men wa no be ta ndab Jesús. Cha mbindeꞌe bexa be ta gaw bexa ujest Pascua. ");
INSERT INTO zpt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Leꞌa ngol gor uyoꞌo teꞌal, leꞌa Jesús ulayaꞌno isatibtop be xmen na len niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Leꞌa gor na ndeyaw bexa ndoꞌ mes, leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa dub bega na ndeyaw beuna ndee leꞌa yun cuent naꞌ ndoꞌ bexa ndakloo ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Weꞌe leꞌa be xmen xa cha uban myoꞌo ladnabe, usaxan nabdiꞌizh dub gaꞌga bexa ndoꞌ Jesús, ndab bexa: —¿Lid naꞌ ta wa zha, Mech? ");
INSERT INTO zpt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Leꞌa Jesús cha ndab: —Leꞌa ta wa leꞌaka dub isatibtop bega nsobyawno naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, itiꞌidka lak nkeaniꞌi diꞌizh ten Dios. Parea proꞌob xabgiꞌi na yun cuent naꞌ ndoꞌ bexa wa. ¡Mas wen lá yoꞌo xabgiꞌi wa ndoꞌ gizhliyo! ");
INSERT INTO zpt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Leꞌa gor na li ndeyaw bexa, leꞌa Jesús cha usen dub pan, cha msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa‑yá, no mtseꞌa xa‑yá ndoꞌ be xmen xa, ndab xa: —Udaw bega pan ndee, leꞌa‑yá beꞌal las naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Cha liga usen Jesús dub vas ncho vin, cha msaꞌa xa xno ndoꞌ Dios. Weꞌe cha msaꞌa xa‑yá ndoꞌ bexa, cha ngu itea bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Cha ndab Jesús: —Leꞌa ta ndee ten ten naꞌ usa naꞌ por bego. Leꞌa ta ndee nluu leꞌa nat leꞌa Dios mbinno be men dub trat kub ná xteꞌe wen yaꞌan bexa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Leꞌa naꞌ gáp ndoꞌ bego leꞌa naꞌ yá naꞌantapa goꞌo vin ten uv, gast gal wizh na goꞌo naꞌ vin kub sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cha mbiltoꞌo bexa dub cant ndoꞌ Dios; cha utoꞌo bexa, nchaꞌbe bexa Bet Olivo. ");
INSERT INTO zpt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Weꞌe leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa iteanak bego ulaꞌa naꞌ teꞌal ndee, lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Leꞌa naꞌ gut xa nlaꞌach be borreg, cha iteꞌachso bema.” ");
INSERT INTO zpt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ná leꞌa tsoꞌo na iban naꞌ leꞌa naꞌ ned ilaya ndoꞌ bega Galilea. ");
INSERT INTO zpt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Leꞌa Pedr cha ndab ndoꞌ Jesús: —Maska itea bexa baꞌ ulaꞌa ga, ná leꞌa naꞌ naꞌanpa ula ga. ");
INSERT INTO zpt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Leꞌa Jesús cha ndab ndoꞌ Pedr: —Leꞌa naꞌ gáp ndoꞌ lu, leꞌa teꞌal ndee gor biseata kwezh boy top biaj, leꞌa lu mkwiꞌinla chon biaj ndab lu leꞌa lu lá nchandoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ná leꞌa Pedr bi ndabkata: —Maska gat naꞌ gor gat go, leꞌa naꞌ naꞌanpa gáp leꞌa naꞌ lá nchandoꞌ ga. Weꞌe leꞌa iteata be xmen Jesús ndab lak ndab Pedr. ");
INSERT INTO zpt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Cha ulayaꞌ bexa sa nsaleaꞌ Getsemaní, cha ndab Jesús ndoꞌ be xmen na: —Ndeꞌetsa ute bega ndalen ndaꞌyadiꞌizhno naꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cha mbiꞌi Jesús Pedr no Jacob no Juan stub tuzh sa. Cha uzhebpa uban myoꞌo ladna Jesús no kweaꞌ myoꞌo ladna xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Cha ndab xa ndoꞌ yon bexa wa: —Uzhebpa uban ncho lad naꞌ gast ngi sat naꞌ. Ndeꞌetsa utenaꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cha usea Jesús stub tuzh sa, cha usaxib xa gast ndoꞌ yo ngol xtuzh xa. Cha ndadiꞌizhno xa Dios, ndab xa tal syoꞌo gan lá itid xa be gealkweaꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Lndeꞌe ndab Jesús ndoꞌ Dios: —Tad Xus naꞌ, leꞌa go itea taꞌa sun gan. Lá nlad naꞌ itiꞌid naꞌ ndoꞌ be gealkweaꞌ uzheꞌeb ndee. Parea lá gak‑a lak nlad naꞌ, ndi gak‑a lak nlad go. ");
INSERT INTO zpt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Leꞌa gor nseaꞌ Jesús sa nde yon be xmen xa, leꞌa bexa ndeyats. Cha ndab xa ndoꞌ Simón Pedr: —Simón, ¿naxyats lu zha? ¿Ni lá uxik lu isobnaꞌ lu ni stub gor zha? ");
INSERT INTO zpt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Utenaꞌ bega no bidiꞌizhno bega Dios, ndontsa naꞌanpa utsabgix maxuꞌu bega. Leꞌa ladoꞌo bega nlad gun ta wen, ná leꞌa idub bega lá uxik. ");
INSERT INTO zpt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cha nchaꞌagal Jesús nchaꞌyadiꞌizhno xa Dios lakkagal gor ned wa. ");
INSERT INTO zpt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Leꞌa gor na nseaꞌgal Jesús sa nde yon be xmen xa leꞌa bexa ndeyatsgal, geal leꞌa bexa uzhebpa nyoꞌo xkaꞌalna. No ni lá iniꞌí bexa xteꞌe ikaꞌab bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngol biaj yon ngwaꞌyadiꞌizhno Jesús Dios. Leꞌa gor nseaꞌgal xa sa nde bexa wa, cha ndab xa: —¿Bi ndeyats bega zha, no ndeuneꞌe bega zha? Yá unika‑yá, leꞌa nat yá ngol gor leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa bexa ugap. ");
INSERT INTO zpt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Goste bega, nchaꞌbe beuna. Bwiꞌi bega leꞌa xa yun cuent naꞌ yá nseala baꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bi li nsoꞌyadiꞌizh Jesús leꞌa Judas, xa no nak dub tibtop xmen Jesús, ulennola be men kwaꞌad noꞌo be spad nsea garrot. Leꞌa ta wa bexa mtuꞌub be uleꞌay nibeꞌe no be mech ten ley no bexa gox nsak isen bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Leꞌa Judas, xa li yun cuent Jesús, ndabla ndoꞌ be men wa: —Leꞌa xa na gaw naꞌ chit beꞌal ndoꞌ na, xa weꞌe isen bega, no gun segur bega xa, goꞌo bega xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Leꞌa gor na ulenno Judas be men wa, cha ubii Judas wats Jesús ndab xa: —Mech, mech. Cha mchealtoꞌo Judas ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Weꞌe leꞌa be men wa cha usen Jesús, cha yá lá ulaꞌata bexa xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Zha leꞌa dub xmen Jesús cha uloꞌo spad ten na, cha ulobtoꞌog xa nchaꞌ dub xa ndun tiꞌin ndoꞌ uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Cha ndab Jesús ndoꞌ be men wa: —¿Xtaꞌan nseano bega spad nsea garrot isen bega naꞌ cuent dub waꞌan zha? ");
INSERT INTO zpt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Itea wizh mluu naꞌ be men tale ten niꞌi ten Dios lat bega, ná lá isen bega naꞌ sa wa. Parea leꞌa ta ndee li ngok ndontsa gak‑a lak nkeaniꞌi diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Weꞌe leꞌa itea be xmen Jesús cha mxoꞌon, mlaꞌa bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Parea leꞌa dub xabgiꞌi ben nbix nabtsa dub bleꞌa lad siꞌil usankea tsoꞌo Jesús. Leꞌa gor na ndiꞌizh isen bexa no xabgiꞌi ben wa, ");
INSERT INTO zpt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","leꞌa xa wa cha mlaꞌa lad nbix na, mxoꞌon xa litsa naꞌanpa nak xa xab xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Leꞌa be men wa cha mbiꞌi Jesús ta lid uleꞌay ndon leꞌa nsak. Leꞌa sa wa leꞌa itea be uleꞌay nibeꞌe no bexa gox nsak no be mech ten ley cha mzhealbe. ");
INSERT INTO zpt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Leꞌa Pedr sittsa nchankea tsoꞌo Jesús, cha no Pedr uyoꞌo len tale ten niꞌi wa. Weꞌe cha usob ubizhno Pedr bexa nlaꞌach sa wa sa nde giꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Leꞌa be uleꞌay nibeꞌe no iteata bexa nsak wa nkwaꞌanbe ná xteꞌe usake bexa Jesús, dub ta nsabndoꞌ gat Jesús. Parea leꞌa bexa ni lá izheal xteꞌe‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Leꞌa kwaꞌad be men mkwiꞌin nsake Jesús, ná leꞌa bexa wa naꞌanpa dubtsa ngudiꞌizhbe. ");
INSERT INTO zpt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Weꞌe ngwasoꞌ pla bexa msake bexa Jesús, mkwiꞌin bexa ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Leꞌa besa mbiꞌín leꞌa Jesús baꞌ ndab leꞌa xa ulate niꞌi ten Dios, ta mbindeꞌe men. Cha gal wizh yon leꞌa xa ixiste stub niꞌi ten Dios ta naꞌanpa men gundeꞌe. ");
INSERT INTO zpt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ni lika naꞌanpa dubtsa ngudiꞌizh bexa. ");
INSERT INTO zpt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Weꞌe leꞌa uleꞌay ndon leꞌa nsak cha ngwasoꞌ ndoꞌ be men wa, unabdiꞌizh xa ndab xa ndoꞌ Jesús: —¿Ni lá utsakndoꞌ lu zha? ¿Ta ugeaka ta ndab bexa ndee leꞌa lu li ndab zha? ");
INSERT INTO zpt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ná leꞌa Jesús naꞌan xteꞌe ngab, ni lá ikaꞌab xa. Weꞌe leꞌa uleꞌay wa cha unabdiꞌizhgal ndoꞌ Jesús ndab: —¿Lu nak Cristo Xin Dios wen wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ta wa naꞌka. Leꞌa bego gal gor iniꞌí leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, isob wats Dios lad gaꞌal, xa ndon leꞌa nibeꞌe, no ilen naꞌ lat xkaw nde gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Weꞌe leꞌa uleꞌay ndon leꞌa nsak wa cha utsaw xab na tant ndakloo xa, cha ugeꞌ ndab xa: —¿Xtaꞌanta nkiꞌin beuna kwaꞌadta xa usake xa ndee zha? ");
INSERT INTO zpt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Leꞌa bega mbiꞌín xteꞌe unisi xa Dios. ¿Nat xteꞌe gab bega, xteꞌe gunno beuna xa? Leꞌa iteanak bexa wa ndab leꞌa Jesús ndapka ke nsabndoꞌ gat xa. ");
INSERT INTO zpt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ncho bexa usaxan mchukko ndoꞌ Jesús. No mtsaw bexa ndoꞌ Jesús, udin bexa Jesús. Cha ndab bexa ndoꞌ Jesús: —¡Gud ná ton udin lu! Leꞌa bexa nlaꞌach sa wa cha utichyaꞌa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ndalen wa leꞌa Pedr nsob tale wa. Cha ulen dub xagots ndun tiꞌin ta lid uleꞌay wa. ");
INSERT INTO zpt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Leꞌa gor na uniꞌí xagots wa nsob ubizh Pedr, cha mwiꞌi xa ndoꞌ Pedr, ndab xa: —Go no ukeseano Jesús xa Nazaret baꞌ, ¿la? ");
INSERT INTO zpt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Leꞌa Pedr cha mkwiꞌin ndab: —Leꞌa naꞌ lá nchandoꞌ xa baꞌ, no ni lá iní naꞌ xtaꞌan ndab ga. Cha nchaꞌa Pedr mas gax toꞌo puert. Leꞌa gor wa cha utezh dub boy. ");
INSERT INTO zpt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Parea leꞌa xagots wa uniꞌígal Pedr, cha usaxan xa ndab xa ndoꞌ bexa nde sa wa: —Leꞌa xa ndee no nak dub xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ná leꞌa Pedr cha mkwiꞌingal ndab leꞌa xa naꞌanpa xa wa. Tsoꞌoma wa leꞌa bexa nde sa wa stub biaj ndabgal ndoꞌ Pedr: —Ta ugeaka leꞌa go no nak dub xmen Jesús, leꞌa go xa Galilea no ndadiꞌizh ga lak ndadiꞌizh bexa Galilea. ");
INSERT INTO zpt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Leꞌa Pedr cha kweaꞌ uníꞌi, ndab xa: —¡Nsobwiꞌi Dios leꞌa naꞌ lá nchandoꞌ xabgiꞌi nseꞌat bego baꞌ! ");
INSERT INTO zpt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bi leꞌa gor wa leꞌa boy cha utezh biaj itop. Weꞌe mtseꞌa ladna Pedr ta ndab Jesús ndoꞌ Pedr: “Leꞌa teꞌal ndee gor biseata kwezh boy top biaj, leꞌa lu mkwiꞌinla chon biaj ndab lu leꞌa lu lá nchandoꞌ naꞌ.” Cha usaxan Pedr ndoꞌon. ");
INSERT INTO zpt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Leꞌa ngol gor ngot xeꞌa leꞌa be uleꞌay nibeꞌe no bexa gox nsak no be mech ten ley no iteata bexa nsak wa dubtsa mbidiꞌizh bexa xteꞌe gunno bexa Jesús. Cha mxi bexa Jesús, cha mbiꞌi bexa xa ndoꞌ Pilat. ");
INSERT INTO zpt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Leꞌa Pilat cha unabdiꞌizh ndoꞌ Jesús, ndab xa: —¿Lu nak xa nibeꞌe ten bexa judio zha? Leꞌa Jesús cha ndab: —Goka ndab‑a. ");
INSERT INTO zpt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Leꞌa be uleꞌay nibeꞌe wa cha sian taꞌa msake Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Leꞌa Pilat unabdiꞌizhgal ndab: —¿Ni lá utsakndoꞌ lu zha? Unaꞌ plota taꞌa nsake bexa baꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Parea leꞌa Jesús ni lika lá ikaꞌab. Cha ngwanseana Pilat. ");
INSERT INTO zpt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Leꞌa itea liꞌin zha ndal ujest Pascua, leꞌa Pilat ngoꞌo dub men nkea litgiꞌib, tal ton gab be men itoꞌo. ");
INSERT INTO zpt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Leꞌa zha wa uyoꞌo dub xa nsaleaꞌ Barrabás nkea litgiꞌib no be ltsaꞌa na, ke na ngokloo bexa ndoꞌ bexa nibeꞌe sa wa no mbit bexa dub men. ");
INSERT INTO zpt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Leꞌa be men kwaꞌad wa ulayaꞌ ndoꞌ Pilat, cha unab bexa igoꞌo Pilat dub men litgiꞌib, lakka ndun Pilat itea liꞌin. ");
INSERT INTO zpt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Leꞌa Pilat cha ndab: —¿Nlad bega ula naꞌ xa nibeꞌe ten bega xa judio zha? ");
INSERT INTO zpt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Li ndab Pilat leꞌa Pilat uniꞌí leꞌa be uleꞌay nibeꞌe wa nxee ladna ndoꞌ Jesús ta na mas kwaꞌad men ndeseano Jesús, ta weꞌe myun bexa cuent Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Parea leꞌa be uleꞌay nibeꞌe wa mkiꞌil be men wa inab bexa ndi igoꞌo Pilat Barrabás litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Leꞌa Pilat cha unabdiꞌizhgal ndoꞌ be men: —¿Xtaꞌan nlad bega gunno naꞌ xa ndab bega xa nibeꞌe ten bega xa judio? ");
INSERT INTO zpt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Leꞌa be men wa ugeꞌ ukaꞌab, ndab bexa: —¡Ikea xa ndoꞌ cruz! ");
INSERT INTO zpt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Weꞌe leꞌa Pilat ndab: —¿Xtaꞌan ta ugap mbin xa zhaga? Ná leꞌa be men wa ndi mas ugeꞌ ndab: —¡Ikea xa ndoꞌ cruz! ");
INSERT INTO zpt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Leꞌa Pilat nlad wen yaꞌan ndoꞌ be men wa, ta weꞌe mgoꞌo Pilat xa nsaleaꞌ Barrabás. Cha ndab Pilat ndoꞌ be soldad kin bexa Jesús, cha ukeꞌa bexa xa ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Weꞌe leꞌa be soldad cha mbiꞌi Jesús tale ten niꞌilaw, sa nsaleaꞌ pretorio. Cha mzhealbe iteanak be soldad sa wa. ");
INSERT INTO zpt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cha mgak bexa Jesús dub lad koꞌol, ta konch ugats. No msob bexa dub ta rued cuent coron gek Jesús ta nakndeꞌe xos yagich. ");
INSERT INTO zpt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Cha usaxan be soldad ndun usaladno Jesús, ugeꞌ ndab bexa: —¡Siꞌil nak xa nibeꞌe ten bexa judio! ");
INSERT INTO zpt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Cha nlaꞌ bexa dub bar gek Jesús, no mchukko bexa ndoꞌ Jesús, no msaxib bexa ndoꞌ Jesús cuent ndankea bexa xa. ");
INSERT INTO zpt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Leꞌa gor na mtayun usaladno bexa Jesús, cha ulate bexa lad konch ugats nak Jesús. Cha mgak bexa Jesús leꞌaka xab xa. Cha nchaꞌano bexa Jesús sa ikea xa ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Leꞌa gor weꞌe leꞌa dub xabgiꞌi nsaleaꞌ Simón nchaꞌlayaꞌ Jerusalén, dub xa gezh Cirene xus Alejandro no Rufo. Leꞌa gor na mzheꞌal be soldad xa wa, cha mbin bexa juers goꞌo Simón wa cruz ten Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Cha mbiꞌi bexa Jesús dub sa nsaleaꞌ Gólgota, dub diꞌizh gab tit gek men. ");
INSERT INTO zpt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Weꞌe msaꞌa bexa vin ten uv noch xup ten ya mirra goo Jesús, parea leꞌa xa lá ngo‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cha mkeꞌa be soldad Jesús ndoꞌ cruz, cha uloꞌo bexa dub suert, ndontsa iniꞌí bexa ná tonpa ikaꞌa be xab Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Leꞌa gor na mkeꞌa bexa Jesús ndoꞌ cruz, leꞌa ta wa gor nkea ugeꞌa tempran. ");
INSERT INTO zpt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Leꞌa gek cruz ten Jesús mkeꞌa bexa dub letr, ndab‑a ná xtaꞌan li nkea xa ndoꞌ cruz, ndab‑a: “TA NDEE XA NIBEꞌE TEN BEXA JUDIO.” ");
INSERT INTO zpt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","No top waꞌan mkeꞌa bexa ndoꞌ stop cruz wats Jesús, dub xa wats Jesús lad gaꞌal, leꞌa stub xa wats lad raves. ");
INSERT INTO zpt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Li ngok‑a lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Mbinno bexa xa cuent dub xa ugap.” ");
INSERT INTO zpt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Leꞌa be men nseabetid sa wa xela uníꞌi ndoꞌ Jesús, nkwiꞌin bexa gek bexa, ndab bexa ndoꞌ Jesús: —Lu ndab slate niꞌi ten Dios, cha ixiste lu‑yá wizh yontsa. ");
INSERT INTO zpt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Nat byun libr leꞌaka leꞌa lu, ulaꞌ ndoꞌ cruz baꞌ! ");
INSERT INTO zpt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","No liga leꞌa be uleꞌay nibeꞌe no be mech ten ley nisi Jesús, ndab bexa ndoꞌ be ltsaꞌa xa: —Leꞌa xa baꞌ leꞌa ngokno be men, ná lá gun xa gan ulat xa leꞌaka xa ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Xa baꞌ ndab leꞌa nak Cristo xa nibeꞌe ten beuna xa Israel. ¡Nat ilaꞌ xa ndoꞌ cruz, ndontsa iniꞌí beuna‑yá, cha gungea ladna beuna xa! No liga leꞌa bexa nkea ndoꞌ cruz wats Jesús kweaꞌ uníꞌi ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Leꞌa ngol gor gawizh leꞌa idub ndoꞌ gizhliyo mkaw gast gor nkea uyon uzhe. ");
INSERT INTO zpt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Leꞌa ngol gor wa leꞌa Jesús uzheꞌeb ugeꞌ uníꞌi ndab: —Eloi, Eloi, ¿lama sabactani? —leꞌa ta wa dub diꞌizh gab: Dios ten naꞌ, Dios ten naꞌ, ¿xtaꞌanxá mlalad go naꞌ zhaga? ");
INSERT INTO zpt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Leꞌa ncho bexa nde sa wa gor na mbiꞌín bexa ta li ndab Jesús wa, cha ndab bexa: —Blaꞌach bega, leꞌa xa baꞌ nbezh profet Elí. ");
INSERT INTO zpt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Weꞌe leꞌa dub bexa wa cha utoꞌo karrel, cha mgazh xa dub bleꞌa lad xiꞌil ndoꞌ vinagr, cha msob xa‑yá gek dub yalod. Cha msaꞌa xa‑yá goo Jesús‑a, ndab xa: —Kweas beuna naga siꞌid Elí ixeꞌe xa ndee ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ná leꞌa Jesús ugeꞌ utezhat, cha ngut xa. ");
INSERT INTO zpt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Weꞌe leꞌa lad utaꞌa nak bseꞌa len niꞌi ten Dios cha usaw gast gaꞌap no gast ilaꞌ, ngok top bleꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Leꞌa dub xa nibeꞌe ten soldad nsoꞌ lad ndoꞌ Jesús uniꞌí xteꞌe utezhat Jesús no xteꞌe ngut xa. Cha ndab soldad wa: —Ta ugeaka leꞌa xabgiꞌi ndee Xinka Dios. ");
INSERT INTO zpt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Leꞌa sa wa sittsa ndewiꞌi kwaꞌad be xagots. Leꞌa lat bexa wa nsoꞌ Marí xa gezh Magdala no Salomé no Marí xnaꞌa Kosé xa wit Jacob tuzh wa. ");
INSERT INTO zpt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Leꞌa be xagots wa bexa na utoꞌo Galilea usankea tsoꞌo Jesús, no ngokno bexa Jesús nes nchaꞌa xa Jerusalén. No kwaꞌadta be xagots nchaꞌano Jesús Jerusalén nde sa wa. ");
INSERT INTO zpt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Leꞌa ta wa dub gor uzhe wizh nsaxkwaꞌa bexa judio ta guntiꞌin bexa gat xeꞌa wizh neꞌe bexa. ");
INSERT INTO zpt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Weꞌe leꞌa dub xa nsaleaꞌ Kosé xa gezh Arimatea ngop valor ulen ndoꞌ Pilat unab xa Jesús. Leꞌa Kosé wa dub xa nsak ten bexa judio, no nkenkeaꞌ xa tiemp inibeꞌe Dios ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Leꞌa Pilat ngwanseana ná xteꞌe uxax ngut Jesús. Cha utezh Pilat dub soldad nibeꞌe, cha unabdiꞌizh Pilat naga ngutla Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Leꞌa gor na ndab soldad wa leꞌa Jesús ngutka, cha ndab Pilat goꞌo Kosé Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Weꞌe leꞌa Kosé ngwaꞌisiꞌi dub lad kub, cha uxeꞌe xa Jesús ndoꞌ cruz, cha mtixko xa Jesús lad wa. Cha ulo xa Jesús len dub baꞌa cuent geꞌloꞌo, dub geꞌed udan men ndoꞌ geꞌdaꞌa. Cha mtixte xa dub geꞌ siꞌil mtsaw toꞌo baꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Leꞌa Marí xa gezh Magdala no Marí xnaꞌa stubga Kosé ndewiꞌi pa ulo bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ngol utid wizh neꞌe bexa judio, leꞌa Marí xa Magdala no Marí xnaꞌa Jacob no Salomé usiꞌi bexa ta uxeꞌe koo bexa las Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Leꞌa ngol tempran wizh ned ten sman nsobla dub tuzh wizh, nchaꞌbe bexa sa nde baꞌa mgaꞌach Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Leꞌa gor nchaꞌa bexa nes wa ndab bexa ndoꞌ be ltsaꞌa xa: —¿Cha ton kob geꞌ siꞌil toꞌo baꞌa wa zha? ");
INSERT INTO zpt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ná leꞌa gor ulayaꞌ bexa sa wa, mnaꞌla bexa leꞌa geꞌ wa myoꞌobla toꞌo baꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Cha uyoꞌo be xagots wa len baꞌa wa, cha mnaꞌ bexa dub xabgiꞌi ben nsob lad gaꞌal len baꞌa nak dub lad nagud ta koꞌol, cha mzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ná leꞌa xabgiꞌi wa cha ndab ndoꞌ bexa: —¡Lá izheb bego! Naꞌ uní leꞌa bego nkwaꞌan Jesús xa Nazaret, xa na ukea ndoꞌ cruz. Ná leꞌa Jesús ubanla, leꞌa xa wa naꞌanla sa ndee. Bwiꞌi bega sa mxoꞌob be men xa. ");
INSERT INTO zpt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nat waꞌ bega ndoꞌ be xmen Jesús no ndoꞌ Pedr, gud bega ndoꞌ bexa leꞌa Jesús nchaꞌa nedla ndoꞌ bexa Galilea, leꞌa sa wa izheꞌal bexa xa lakka ndab xa. ");
INSERT INTO zpt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Weꞌe leꞌa be xagots wa nxis tant nzheb bexa, cha utoꞌo bexa len baꞌa wa mxoꞌon bexa. Ná ni naꞌan ton ndoꞌ ná ngab bexa ta wa nes nseaꞌ bexa, tant nzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tsoꞌo na mban Jesús gor tempran wizh ned ten sman wa, ned mlundoꞌ xa ndoꞌ Marí xa Magdala, xa na uloꞌo Jesús dub gaꞌad mbi bxin len ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Leꞌa Marí wa cha ngwaꞌ ndoꞌ bexa uteseano Jesús. Leꞌa bexa wa uzhebpa uban ndencho ladna no ndeyoꞌon bexa. Cha ndab Marí leꞌa Jesús mbanla. ");
INSERT INTO zpt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Parea leꞌa bexa wa lá ngungea ladna leꞌa Jesús nban, no ni lá ngungea ladna bexa leꞌa Marí wa uniꞌí Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsoꞌo wa leꞌa Jesús mlundoꞌ ndoꞌ top be xabgiꞌi nes nchaꞌbe bexa geꞌe, parea xaꞌaga nluu xa. Leꞌa bexa wa bexa no ukeseano Jesús. ");
INSERT INTO zpt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Weꞌe cha ngwaꞌyab bexa‑yá ndoꞌ iteata be ltsaꞌa bexa. Parea leꞌa bexa ni weꞌeka lá ngungea ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsoꞌo wa mlundoꞌ Jesús ndoꞌ isatibdub be xmen xa dub sa junt ndeyaw bexa. Leꞌa Jesús cha uteyo bexa ke na lá ngungea ladna bexa leꞌa Jesús nbanla, no ke ngud nak ladoꞌo bexa, geal leꞌa bexa wa lá ngungea ladna ta ndab bexa uniꞌíla leꞌa Jesús mbanla. ");
INSERT INTO zpt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cha ndab Jesús ndoꞌ bexa wa: —Waꞌ bego idub nax ndoꞌ gizhliyo. Bidiꞌizh bega diꞌizh wen ten Dios ndoꞌ iteanak be men. ");
INSERT INTO zpt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Leꞌa tal ton gungea ladna naꞌ no italeaꞌ xa, leꞌa xa wa sap gealnaban ndoꞌ Dios. Leꞌa tal ton naꞌanpa gungea ladna naꞌ, leꞌa xa wa iniꞌí gealkweaꞌ. ");
INSERT INTO zpt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Leꞌa bexa ndangea ladna naꞌ sun be ta nluu leꞌa bexa ndap juers ten Dios. Guntiꞌin bexa lea naꞌ kontuꞌub bexa be mbi bxin ncho len ladoꞌo be men, no gudiꞌizh bexa stubga diꞌizh. ");
INSERT INTO zpt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","No tal bexa lá iniꞌí isen bexa mbeꞌal no goo bexa venen, leꞌa ta wa naꞌan xtaꞌan gun. No uxoꞌob bexa yaꞌa bexa gek bexa gizh, leꞌa bexa wa cha syakna. ");
INSERT INTO zpt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tsoꞌo na li ndab Jesús, weꞌe cha mkea xa gibeꞌa, cha usob xa wats Dios lad gaꞌal. ");
INSERT INTO zpt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Leꞌa be xmen Jesús cha utoꞌo nchaꞌbeyadiꞌizh diꞌizh ten Jesús ndoꞌ be men ncho itea lad. Leꞌa Jesús ndakno bexa, no nsaꞌa xa juers ndun bexa sian taꞌa, ta na nluu leꞌa ta ndadiꞌizh bexa wa diꞌizh tenka Dios.");
INSERT INTO zpt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Leꞌa kwaꞌad be men mbin juers ndon xkwaꞌa mkeꞌa bexa ta na ta ugeakapa mbin Jesús lat besa. ");
INSERT INTO zpt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Leꞌa bexa na ukeseano Jesús ndon leꞌa ned uniꞌí be ta wa no mbidiꞌizh bexa‑yá ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ta weꞌe no naꞌ uzhebpa uloxnes gast xan itea be ta ndee. Cha mbinbe naꞌ leꞌa naꞌ nsabndoꞌ ndon xkwaꞌa ukeꞌa be ta ndee ndoꞌ go, Teófilo, ");
INSERT INTO zpt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ndontsa wen igondoꞌ go gealngea, be ta na mbidiꞌizh bexa ndoꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Leꞌa zha na ngok Herodes xa nibeꞌe Judea, uyoꞌo dub uleꞌay judio nsaleaꞌ Zacarías, dub xa no nak partid Abías ten be uleꞌay. Leꞌa xagots ten Zacarías wa nsaleaꞌ Elisabet, dub xa ras ten Aarón. ");
INSERT INTO zpt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Leꞌa Zacarías nsea Elisabet uzhebpa bexa wen ngok ndoꞌ Dios. No uzheꞌeb mxobgek bexa ndoꞌ itea be taꞌa unibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ná leꞌa bexa wa lá ndap xin na, geal leꞌa Elisabet wa dub xagots lá yoꞌo gan gap meꞌed. No goxlapa itop bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ngol zha na leꞌa partid ten uleꞌay Zacarías wa leꞌa ngol gun tiꞌin ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lak nak costumbr ten be uleꞌay uloꞌo bexa suert, cha leꞌa Zacarías ngol leꞌa yaꞌlo zhen len niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngol gor na ngo xa zhen len wa, leꞌa itea be men ndebe tsoꞌo juer ndadiꞌizhno Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cha mlundoꞌ dub angel ten Dios ndoꞌ Zacarías, nsoꞌ angel lad gaꞌal wats mes, sa ngo uleꞌay zhen. ");
INSERT INTO zpt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Leꞌa gor na uniꞌí Zacarías angel wa, leꞌa xa ni lá iniꞌí xteꞌe gun, no mzheb xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Leꞌa angel wa cha ndab: —Zacarías, lá izheb lu, leꞌa Dios ndoꞌón ta nab lu ndoꞌ xa. Leꞌa Elisabet xagots ten lu gap dub meꞌed bgiꞌi, cha usaleaꞌ lu meꞌed wa Juan. ");
INSERT INTO zpt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Leꞌa zha na gal meꞌed, leꞌa lu uzhebpa iten ladna, no kwaꞌadpa be men iten ladnabe, ");
INSERT INTO zpt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","geal leꞌa xin lu wa gak dub xa uzhebpa nsak cuent ten Dios. Leꞌa xa ni lá goo vin no ni stub taꞌa nsudna be men. No uzhebpa gap xa juers ten Espíritu ten Dios, gor na bi leꞌa xnaꞌa xa nsoꞌno xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Leꞌa xa gun gan leꞌa kwaꞌadpa bexa Israel yach yankea bexa Dios Xa Nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Leꞌa Juan leꞌa yaꞌ ned ndoꞌ Xa Nibeꞌe wa. Leꞌa xa wa juert gudiꞌizh sakndoꞌ Dios lak juert mbidiꞌizh Elí, ndontsa gun xa gan lá kuyota be men nsea leꞌaka be xin xa, no leꞌa bexa lá nxobgek wa uxobgek ndoꞌ Dios. Li gun xa ndontsa list kwe be men gungea ladna bexa xa nak Xa Nibeꞌe wa zha na ilen xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Leꞌa Zacarías cha unabdiꞌizh ndoꞌ angel, ndab xa: —¿Xteꞌexá iní naꞌ syoꞌo gan gak ta ndee zhaga? Leꞌa naꞌ no xagots ten naꞌ yá goxlapa besa. ");
INSERT INTO zpt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Leꞌa angel cha ukaꞌab ndab: —Leꞌa naꞌ nsaleaꞌ Gabriel, naꞌ ndun tiꞌin ndoꞌ Dios. Leꞌa Dios mtuꞌub naꞌ ndalyáp naꞌ ndoꞌ lu be diꞌizh wen mbidiꞌizh naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Leꞌa nat leꞌa lu yak mud, yá lá gudiꞌizhta lu gast gal wizh yoo be ta ndáp naꞌ ndee wa, ke na lá ngungea ladna lu ta ndee. Nat leꞌa ta wa gakka gal zha nsabndoꞌka li gak‑a. ");
INSERT INTO zpt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndalen wa leꞌa be men ndenkeaꞌ ná xá gor itoꞌo Zacarías len niꞌi ten Dios. Ndanseana bexa xtaꞌan ngi lita kwen nchaꞌa xa len wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ná leꞌa gor na utoꞌo xa leꞌa xa lá yoolata gan iníꞌi. Weꞌe uniꞌí be men leꞌa xa uniꞌí dub ta mluu Dios len wa. Leꞌa xa sbeꞌen seintsa ndun, leꞌa xa lá yoolata gan gudiꞌizh. ");
INSERT INTO zpt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Leꞌa ngol zha ngwaꞌa be wizh mbin Zacarías tiꞌin wa, cha nseaꞌ xa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Leꞌa tsoꞌo wa leꞌa Elisabet xagots ten xa cha nsoꞌnola dub meꞌed. Leꞌa xagots wa cha lá itoꞌota ta lid na dub gaꞌay mbeꞌe. Mbinbeꞌe xa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Lndeꞌe ngokno Dios naꞌ gap naꞌ meꞌed, ndontsa naꞌantapa ido lad naꞌ ndoꞌ be men.” ");
INSERT INTO zpt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Leꞌa ngol sxoꞌop mbeꞌe tsoꞌo wa, leꞌa Dios mtuꞌubgal angel Gabriel gezh Nazaret ten distrit Galilea, ");
INSERT INTO zpt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","sa ncho dub xagots ben, dub xa ni gol ugal xabgiꞌi. Leꞌa xa wa nsaleaꞌ Marí, xa na ikaꞌaka dub xa na nsaleaꞌ Kosé, xa ras ten David. ");
INSERT INTO zpt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Leꞌa angel wa uyoꞌo len lid xagots wa, cha ndab angel ndoꞌ xa: —Tiux ga Marí, leꞌa Dios nsak ladna lak nak lu, no nsoꞌ Dios wats lu. Leꞌa xa mas ndakno lu ndoꞌ itea be xagots. ");
INSERT INTO zpt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ná leꞌa Marí ni ko lá iniꞌí xteꞌe gun gor na mbiꞌín xa ta li ndab angel wa. Ni lá iniꞌí xa xtaꞌan ngi li ndab angel ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Leꞌa angel cha ndab: —Marí, lá izheb lu leꞌa Dios nsak ladna lak nak lu. ");
INSERT INTO zpt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Leꞌa nat leꞌa lu yoxinna dub meꞌed bgiꞌi, cha usaleaꞌ lu meꞌed wa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Leꞌa meꞌed wa gak dub xa nsakpa, geal leꞌa xa Xin Dios siꞌil. Leꞌa Dios Xa Nibeꞌe leꞌa gun leꞌa Jesús inibeꞌe lak unibeꞌe David usan gox polta ten xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Leꞌa Jesús wa inibeꞌe bexa ras ten Jacob idub tiemp. Leꞌa tiemp inibeꞌe xa nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Weꞌe leꞌa Marí cha unabdiꞌizh ndab ndoꞌ angel: —¿Xteꞌe yoo gan gak ta li ndab go wa zha? Leꞌa naꞌ ndee dub xagots nab, ni dub xabgiꞌi gol ugal naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Leꞌa angel cha ukaꞌab ndab: —Leꞌa Espíritu ten Dios siꞌil ilen cuent dub xgal tsoꞌo lu. Leꞌa Espíritu wa leꞌa gun gap lu meꞌed wa. Ta weꞌe leꞌa meꞌed gap lu wa ni dub ke lá gap, no isaleaꞌ meꞌed Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Leꞌa Elisabet ltsaꞌa lu wa no gap dub meꞌed maska yá goxlapa xa. Leꞌa be men ndab leꞌa xa wa lá yoo gan gap meꞌed, parea leꞌa xa nsoꞌnola meꞌed dub xoꞌop mbeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Leꞌa cuent ten Dios naꞌan xtaꞌan dub ta lá yoo gan. ");
INSERT INTO zpt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Leꞌa Marí cha ndab: —Leꞌa naꞌ ndee dub xa ndun tiꞌin ndoꞌ Dios Xa Nibeꞌe. Gun Dios lak ndab go ndoꞌ naꞌ wa. Leꞌa angel wa cha mkaꞌan sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ngol tsoꞌo wa leꞌa Marí cha uxax nchaꞌa dub gezh nde lat be bet distrit Judea. ");
INSERT INTO zpt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cha uyoꞌo xa len lid Zacarías, cha unidiꞌizh xa ndoꞌ Elisabet. ");
INSERT INTO zpt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Leꞌa gor na mbiꞌín Elisabet unidiꞌizh Marí ndoꞌ xa, leꞌa meꞌed nsoꞌno Elisabet wa cha uteꞌal len xa. Leꞌa Espíritu ten Dios cha mas uyoꞌo len ladoꞌo Elisabet, ");
INSERT INTO zpt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","cha ugeꞌ ndab xa: —¡Leꞌa Dios uzhebpa ndakno lu ndoꞌ iteata be xagots! ¡No uzheꞌeb gakno Dios xin lu! ");
INSERT INTO zpt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tonxá nak naꞌ nsea inaꞌ lu naꞌ zhaga, ná lu leꞌa nak xnaꞌa xa gak Xa Nibeꞌe naꞌ? ");
INSERT INTO zpt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Leꞌa gor na mbín naꞌ unidiꞌizh lu, leꞌa meꞌed nsoꞌno naꞌ ndee uteꞌal‑la len naꞌ tant nten ladna meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Uzhebpa wen ncho ladna lu ta na mbingea ladna lu ta ndab Dios ndoꞌ lu, leꞌa ta wa gakka lak ndab xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Leꞌa Marí cha ndab: Leꞌa naꞌ idub ncho ladna ndáp leꞌa Dios uzheꞌeb dub Dios wen. ");
INSERT INTO zpt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Leꞌa ladoꞌo naꞌ nten ladna ndoꞌ Dios xa nsaꞌa gealnaban ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Leꞌa Dios nlaꞌach naꞌ, xa ndun tiꞌin ndoꞌ xa, maska naꞌanpa nak naꞌ dub xa nsak. Leꞌa idub ndoꞌ ndee gab be men leꞌa naꞌ uzhebpa wen ncho lad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Leꞌa Dios siꞌil uzhebpa ndakno naꞌ; leꞌa xa dubkama nak Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Idub tiemp nkweaꞌ ladna xa be men, bexa nxobgek ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Leꞌa juers ten Dios mbin xa be ta ndanseana beuna; Mteꞌachso xa bexa zhin nak. ");
INSERT INTO zpt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","No ulatsob xa bexa nsak sa nibeꞌe bexa, Cha myunno Dios bexa uban nak cuent bexa nsak. ");
INSERT INTO zpt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nsea bexa lá ndap ta gaw na, msaꞌa Dios sian taꞌa ndoꞌ bexa. No ulantuꞌub xa bexa rik ni naꞌanta xtaꞌan ndap bexa. ");
INSERT INTO zpt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ndakno Dios bexa Israel, bexa ndun tiꞌin ndoꞌ xa, leꞌa xa lá nyalad ta nkweaꞌ ladna xa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Leꞌa ta wa ta ndabka Dios ndoꞌ bexa gox polta ten beuna, ta gunno Dios Abraham no bexa ras ten xa idub tiemp. ");
INSERT INTO zpt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Weꞌe leꞌa Marí cha uyoꞌo ta lid Elisabet pa chon mbeꞌe. Cha weꞌeta nseaꞌ xa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Leꞌa ngol wizh na gap Elisabet meꞌed, leꞌa xa cha ngop dub meꞌed bgiꞌi. ");
INSERT INTO zpt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Leꞌa bexa ncho gax wa no be ltsaꞌa xa cha mbiꞌín xteꞌe li utsin mbinno Dios Elisabet, cha no bexa mten ladna. ");
INSERT INTO zpt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Leꞌa ngol zha na ngok xoꞌon wizh ngol meꞌed wa, cha ulo bexa beꞌe meꞌed lakka ndun bexa judio. No cha nlad bexa usaleaꞌ bexa meꞌed wa Zacarías lak nsaleaꞌ xus meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ná leꞌa xnaꞌa meꞌed lá kaꞌab li isaleaꞌ meꞌed. Ndab xa: —Leꞌa meꞌed isaleaꞌ Juan. ");
INSERT INTO zpt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Leꞌa bexa wa cha ndab: —¿Xtaꞌan ngi li isaleaꞌ meꞌed baꞌ zha? Leꞌa ni dub ltsaꞌa lu naꞌanpa li nsaleaꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Weꞌe cha unabdiꞌizh bexa sbeꞌen sein ndoꞌ xus meꞌed xteꞌe nlad xa isaleaꞌ meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Leꞌa xa cha unab dub bleꞌa tabl, cha mkeꞌa xa ndoꞌ tabl wa: “Leꞌa meꞌed isaleaꞌ Juan.” Leꞌa itea be men wa cha ngwanseanabe. ");
INSERT INTO zpt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cha bi leꞌa gor wa cha uyoꞌo gan uníꞌi Zacarías, cha usaxan xa nsaꞌa xa xno ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Leꞌa itea be men ncho gax ta lid Zacarías cha ngwanseana bexa no mzheb bexa. Leꞌa ta li ngok wa mgen itea be gezh ndebe lat be bet distrit Judea. ");
INSERT INTO zpt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Leꞌa itea bexa na li mbiꞌín ta wa cha mbinbeꞌe bexa, ndab bexa: —¿Xteꞌema gak meꞌed wa zha? Leꞌa bexa wa uniꞌí leꞌa meꞌed wa ncho ndoꞌ yaꞌa Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Leꞌa Zacarías xus meꞌed wa mas uyoꞌo juers ten Espíritu ten Dios len ladoꞌo na, cha mbidiꞌizh xa sakndoꞌ Dios, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Uzhebpa wen Dios Xa Nibeꞌe bexa Israel, geal leꞌa xa mbiꞌid yakno be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Leꞌa Dios mtuꞌub dub xa juertpa usaꞌa gealnaban, dub xa ras David, xa mbin tiꞌin ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Leꞌa ta wa ta ndab Dios ndoꞌ be profet ten na polta, cha mbidiꞌizh bexa‑yá ndoꞌ be men sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Leꞌa Dios ndab leꞌa xa lá ulaꞌa beuna ndoꞌ be men ndakloo ndoꞌ beuna, no bexa nxee ladna ndoꞌ beuna. ");
INSERT INTO zpt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Leꞌa Dios nkweaꞌ ladna be usan gox ten beuna, no ndunka xa lakka ndab trat mbinno xa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Leꞌa trat wa ta ndab Dios ndoꞌ Abraham usan gox ten beuna leꞌa Dios sunka ta wa: ");
INSERT INTO zpt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","leꞌa xa gakno beuna ndoꞌ be men ndakloo ndoꞌ beuna, ndontsa naꞌanpa izheb beuna gun beuna tiꞌin ndoꞌ Dios, ");
INSERT INTO zpt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","no umbiꞌi gak ladoꞌo beuna ndoꞌ Dios, no uzhebpa wen gak beuna ndoꞌ xa idub tiemp nban beuna. ");
INSERT INTO zpt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Leꞌa lu, chuu, isaleaꞌ dub profet ten Dios Siꞌil, leꞌa lu yaꞌ ned ndoꞌ xa gak Xa Nibeꞌe, ndontsa list kwe be men Israel gal zha ilen xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Weꞌe iniꞌí bexa leꞌa Dios stsuꞌu be ke ten bexa, no usaꞌa xa gealnaban ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Leꞌa Dios ten beuna uzhebpa nkweaꞌ ladna be men, ta weꞌe utuꞌub xa xa nak cuent xeꞌa wizh gor tempran ndoꞌ beuna, ");
INSERT INTO zpt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ndontsa usu xa xeꞌa ladoꞌo bexa ndencho sa ukaw, bexa nzheb gat. Li uluu Dios beuna nes ten xa, ná xteꞌe wen yoono beuna xa. ");
INSERT INTO zpt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Leꞌa Juan ngoꞌol, no mas juert ngok ladoꞌo xa. Ngol zha goxla xa ngwaꞌ xa uyoꞌo xa geꞌe sa bid sa naꞌan men, gast ngol zha na usaxan mbidiꞌizh xa ndoꞌ bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Leꞌa tiemp weꞌe leꞌa xa nsaleaꞌ Augusto César xa nibeꞌe Roma unibeꞌe gats dub censo ten itea be men. ");
INSERT INTO zpt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Leꞌa censo ned wa ngwats zha nak Cirenio xa nibeꞌe sa nsaleaꞌ Siria. ");
INSERT INTO zpt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Leꞌa itea be men cha nseaꞌbe be sa nak lazh bexa, ndontsa sa weꞌe gak punt bexa ndoꞌ censo wa. ");
INSERT INTO zpt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ta weꞌe leꞌa Kosé utoꞌo gezh Nazaret ten distrit Galilea. Cha nseaꞌ xa gezh Belén ten distrit Judea, lazh David usan gox polta ten Kosé, ");
INSERT INTO zpt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ndontsa sa weꞌe gak punt xa no Marí xagots ikaꞌa xa. Leꞌa zha wa leꞌa Marí yá nsoꞌnola meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ná leꞌa zha na ncho bexa Belén, leꞌa Marí ngol wizh gap meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cha ngop xa meꞌed ned ten xa. Cha mtixko xa meꞌed dub bleꞌa lad, nsea ulo xa meꞌed len dub caj, ta nyoꞌo gix ndaw man, geal leꞌa bexa yá lá ngalta cuart uteꞌe bexa yoo bexa. ");
INSERT INTO zpt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Leꞌa gax Belén nde pla be xabgiꞌi nkeno be borreg ten na teꞌal wa. ");
INSERT INTO zpt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Zha leꞌaka dub angel ten Dios mlundoꞌla sa wa. Leꞌa xeꞌa siꞌil ten Dios msula idub sa nde bexa. Cha uzhebpa mzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ná leꞌa angel wa cha ndab: —Lá izheb bega, leꞌa naꞌ ndalyáp ndoꞌ bega dub ta uzhebpa iten ladna itea be men. ");
INSERT INTO zpt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Leꞌa teꞌal ndee leꞌa gezh Belén lazh David ngol dub meꞌed mtuꞌub Dios usaꞌa gealnaban, leꞌa ta wa Cristo Xa Nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lndeꞌe igondoꞌ bega ná ta meꞌed na‑yá: leꞌa meꞌed wa izheal bega nbixyoꞌo dub bleꞌa lad, naxncho meꞌed len dub caj ta nyoꞌo gix ndaw be man. ");
INSERT INTO zpt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Leꞌa gor wa leꞌa kwaꞌadta be angel ten Dios mlundoꞌ sa wa. Ndaltoꞌo bexa ndoꞌ Dios, ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Siꞌil nak Dios ncho gaꞌap, no ndoꞌ gizhliyo wen kwe be men ndun ta nsak ladna Dios! ");
INSERT INTO zpt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Weꞌe leꞌa be angel wa nseaꞌbe gibeꞌa, cha ndab bexa nkeno be man wa ndoꞌ be ltsaꞌa na: —Nchaꞌbe beuna Belén, iniꞌí beuna ta ncho sa wa, ta mbidiꞌizh angel ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cha uxax nchaꞌbe bexa Belén. Cha mzheal bexa Marí no Kosé, cha uniꞌí bexa meꞌed wa naxncho meꞌed len ta nyoꞌo gix ndaw be man. ");
INSERT INTO zpt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Leꞌa gor na uniꞌí bexa meꞌed, cha mbidiꞌizh bexa ta ndab angel cuent ten meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Leꞌa itea be men na mbiꞌín ta ndab bexa nlaꞌach borreg wa cha ngwanseanabe. ");
INSERT INTO zpt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ná leꞌa Marí cha lá yalad ta ndab bexa wa, cha uzhebpa nten ladna xa ndanbeꞌe xa ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Leꞌa bexa nkeno be borreg wa cha nseaꞌbe, ndab bexa leꞌa Dios uzheꞌeb dub Dios siꞌil. No nsaꞌa bexa xno ndoꞌ Dios por itea be taꞌa mbiꞌín bexa no ta uniꞌí bexa lak ndab angel. ");
INSERT INTO zpt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Leꞌa ngol zha ncho meꞌed wa dub xoꞌon wizh, leꞌa bexa cha ulo beꞌe meꞌed wa. Cha msaleaꞌ bexa meꞌed Jesús, lakka ndab angel isaleaꞌ meꞌed, zha na biseata isoꞌno Marí meꞌed. ");
INSERT INTO zpt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Leꞌa ngol zha na ngwaꞌa be wizh nsambiꞌi dub xagots ndap meꞌed, lak nibeꞌe ley ten Moisés, weꞌe leꞌa Kosé no Marí cha mbiꞌi Jesús gezh Jerusalén sa nde niꞌi ten Dios, yun bexa cuent Jesús ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Li mbin bexa lak nkeaniꞌi ley ten Dios, ndab‑a: “Leꞌa xinbgiꞌi ned dub xagots wa gak meꞌed ten Dios.” ");
INSERT INTO zpt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","No msaꞌa bexa man xnab lak nibeꞌe ley ten Dios, ndab‑a usaꞌa bexa top ngog natal top palom. ");
INSERT INTO zpt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Leꞌa gezh Jerusalén uyoꞌo dub xa nsaleaꞌ Simeón, dub xa wen nak ndoꞌ Dios no ndankea xa Dios. No nkenkeaꞌ xa zha ilen xa na koꞌo bexa Israel ndoꞌ be gealkweaꞌ. Leꞌa Espíritu ten Dios uzhebpa ncho len ladoꞌo Simeón. ");
INSERT INTO zpt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Leꞌa Espíritu wa ndabka ndoꞌ Simeón leꞌa Simeón naꞌanpa gat gast iniꞌíka xa Cristo xa na utuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta weꞌe ngol dub wizh leꞌa Espíritu ten Dios leꞌa ulogek Simeón yaꞌ xa sa nde niꞌi ten Dios. Leꞌa wizh wa leꞌa be usan ten Jesús no nchaꞌano Jesús sa wa, gunno bexa Jesús lak nibeꞌe ley ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Weꞌe leꞌa Simeón cha udiꞌid Jesús, cha msaꞌa xa xno ndoꞌ Dios, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dios Xa Nibeꞌe, nat leꞌa naꞌ yá syoꞌo gan gat, leꞌa go yá mbinka ta ndab ga gak wa. ");
INSERT INTO zpt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Leꞌa naꞌ yá uní meꞌed gak xa usaꞌa gealnaban wa, ");
INSERT INTO zpt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","xa na mtuꞌub ga iniꞌí itea be men xa. ");
INSERT INTO zpt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Leꞌa meꞌed ndee gak xa usu xeꞌa ndoꞌ be men naꞌanpa xa Israel; cha gab bexa leꞌa besa xa Israel xmenka go Dios. ");
INSERT INTO zpt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Leꞌa Kosé nsea Marí xnaꞌa Jesús ndanseana ta ndadiꞌizh Simeón xteꞌe gak Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Leꞌa Simeón cha unab ndoꞌ Dios ulaꞌach Dios bexa wa, cha ndab xa ndoꞌ Marí xnaꞌa Jesús: —Leꞌa kwaꞌad bexa Israel lá gungea ladna Jesús ndee, weꞌe gak perdid bexa. No leꞌa kwaꞌad bexa Israel gungea ladna Jesús ndee, weꞌe gap bexa gealnaban ndoꞌ Dios. Leꞌa meꞌed ndee gak dub sein ten Dios, ná leꞌa kwaꞌad be men gakloo ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Leꞌa ta wa uluu ta ndanbeꞌe bexa len ladoꞌo bexa. Parea leꞌa cuent ten lu leꞌa ta wa gak dub gealkweaꞌ siꞌil iniꞌí lu, cuent dub spad gaꞌas ladoꞌo lu. ");
INSERT INTO zpt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Leꞌa sa wa no dub profet nsoꞌ, dub xagots nsaleaꞌ Ana xin Fanuel, xa ras ten Aser. Leꞌa Ana wa dub xa goxlapa. Leꞌa xa wa uyoꞌono xabgiꞌi ten na dub gaꞌadtsa liꞌin, ");
INSERT INTO zpt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","cha ngut xabgiꞌi wa. Leꞌa xa wa ncho dap gaꞌal ncho dap liꞌin. Idub tiemp ncho xa tale ten niꞌi ten Dios, teꞌal tezhea ndun xa tiꞌin ndoꞌ Dios, gast ncho wizh lá ndaw xa tant ndadiꞌizhno xa Dios. ");
INSERT INTO zpt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Leꞌa gor na bi li nsoꞌyadiꞌizh Simeón ndoꞌ Marí, leꞌa Ana cha ulen wats bexa, cha msaꞌa xa xno ndoꞌ Dios. Cha mbidiꞌizh xa cuent ten meꞌed Jesús ndoꞌ itea be men nde sa wa, bexa na ndenkeaꞌ zha koꞌo Dios bexa Jerusalén ndoꞌ be gealkweaꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Leꞌa gor na yá mbin bexa lak nibeꞌe ley ten Dios gun bexa, cha myach bexa Galilea nseaꞌ bexa Nazaret lazh bexa. ");
INSERT INTO zpt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cha mas nsayaꞌal Jesús, no nsayoꞌo juers xa, no mas uzheꞌeb nsayák xa. No uzheꞌeb ndakno Dios xa. ");
INSERT INTO zpt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Leꞌa be usan ten Jesús itea liꞌin ndaꞌbe gezh Jerusalén ujest Pascua ten bexa judio. ");
INSERT INTO zpt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Leꞌa zha ncho Jesús tibtop liꞌin cha ngwaꞌbe bexa Jerusalén lakka ndun bexa. ");
INSERT INTO zpt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Leꞌa ngol wizh myandoꞌ ujest wa, cha nseaꞌbe bexa ta lid bexa, parea lá iniꞌí bexa leꞌa Jesús myansoꞌ Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cha usoꞌla bexa idub dub wizh nes, ni bexa gol noka Jesús nchaꞌ lat bexa kwaꞌad wa. Cha usaxan nkwaꞌan bexa Jesús lat be ltsaꞌa bexa no lat bexa nchandoꞌ bexa, ");
INSERT INTO zpt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","parea lá izheal bexa Jesús. Cha myach bexa leꞌaka Jerusalén myaꞌkwaꞌan bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Leꞌa ngol wizh yon cha mzheal bexa Jesús tale ten niꞌi ten Dios. Leꞌa Jesús nsob lat be mech ten ley nsobyoꞌón Jesús ta ndadiꞌizh bexa, nsea nabdiꞌizh Jesús ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Leꞌa itea bexa na ndeyoꞌón ta li ndab Jesús wa ndanseana xteꞌe ndák Jesús no xteꞌe nkaꞌab Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Leꞌa gor na uniꞌí be usan ten Jesús ta wa, cha ngwanseana bexa. Cha ndab Marí ndoꞌ Jesús: —Chuu, ¿xtaꞌanxá lbaꞌa mbinno lu besa zhaga? Leꞌa naꞌ nsea xus lu baꞌ nyuꞌpa ladna besa, nseakwaꞌan besa lu. ");
INSERT INTO zpt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ná leꞌa Jesús cha ukaꞌab ndab: —¿Xtaꞌan nkwaꞌan bega naꞌ zha? ¿Ná lá iniꞌí bega zha leꞌa naꞌ nsabndoꞌka gun tiꞌin ten Dios Xus naꞌ? ");
INSERT INTO zpt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ná leꞌa be usan ten Jesús lá yakbeꞌena ta ndab Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Leꞌa Jesús cha nseaꞌno bexa gezh Nazaret, nxobgek meꞌed ndoꞌ bexa. Leꞌa xnaꞌa Jesús lá yalad be ta utid wa. ");
INSERT INTO zpt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Leꞌa Jesús cha mas nsayaꞌal no mas nsayák meꞌed. No mas nsak ladna Dios no be men lak nak Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Leꞌa zha na nchasea dub tiꞌinla liꞌin nak Tiberio xa nibeꞌe Roma, leꞌa Poncio Pilat nak xa nibeꞌe idub distrit Judea. Leꞌa Herodes nibeꞌe Galilea. Leꞌa wit xa Julip nibeꞌe Iturea no Traconite. Leꞌa Lisanias nak xa nibeꞌe Abilinia. ");
INSERT INTO zpt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Leꞌa Anás no Caifás nak be uleꞌay ndon leꞌa nsak lat bexa judio. Zha weꞌe leꞌa Dios uníꞌi ndoꞌ Juan xin Zacarías, zha ncho xa geꞌe sa bid sa uxee ncho men. ");
INSERT INTO zpt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Leꞌa Juan cha nchasea idub gax toꞌo yowbeꞌe Jordán, mbidiꞌizh xa ndoꞌ be men, ndab xa ulaꞌa bexa be ta ugap nak bexa no italeaꞌ bexa, ndontsa utsuꞌu Dios be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Leꞌa ta wa ngok lak mkeꞌa profet Isaías polta cuent ten Juan, ndab‑a: Leꞌa xa wa ikeseyadiꞌizh geꞌe sa bid, ugeꞌ gab xa: “Bin parej bega nes ilen Xa Nibeꞌe, bkeasoꞌ bega nes ten xa. ");
INSERT INTO zpt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Itea be sa wat nak izheayobe, itea be geꞌe ubiꞌi no be bet byux yak lat sa wa. Leꞌa be nes naꞌanpa bgea nak wa igeasoꞌbe; leꞌa be nes ngwap ulaꞌ nak wa yakchaꞌawbe. ");
INSERT INTO zpt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Leꞌa itea be men iniꞌí xteꞌe koꞌo Dios bexa ndoꞌ be ke ten bexa.” Li mkeꞌa Isaías sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Leꞌa zha wa leꞌa kwaꞌad be men ulen wats Juan koleaꞌ Juan bexa. Leꞌa Juan cha ndab ndoꞌ bexa: —¡Bego xa ugap cuent be mbeꞌal! ¿Ton ndab ndoꞌ bego italeaꞌtsa bega, cha naꞌanpa utsaksi Dios bega zha? ");
INSERT INTO zpt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bin bega ta wen, ta uluu leꞌa bega mlaꞌaka be ta ugap. No ni lá gunbeꞌe bega gab bega leꞌa bega ras ten Abraham, ta weꞌe leꞌa Dios naꞌanpa utsaksi bega. Leꞌa naꞌ gáp leꞌa Dios syoꞌo gan gunno be geꞌ ndee bexa ras Abraham. ");
INSERT INTO zpt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Leꞌa Dios listla nsoꞌ utsaksi xa bexa ndun ta ugap, cuent dub xa nsoꞌnsén dub gibya kabtoꞌog xa itea be ya lá nsaꞌa ngus wen, cha utsaꞌab xa ta wa ndoꞌ giꞌ yolꞌ‑a. ");
INSERT INTO zpt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Leꞌa be men wa cha unabdiꞌizh ndab bexa ndoꞌ Juan: —¿Xtaꞌan nsabndoꞌ gun besa zha? ");
INSERT INTO zpt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Leꞌa Juan cha ndab: —Leꞌa bego na ndap top gamix, bsaꞌa bega dub‑a ndoꞌ xa lá ndap‑a. Liga bego na ndap sian ta ndaw na, bsaꞌa bego ta gaw bexa lá ndap‑a. ");
INSERT INTO zpt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Leꞌa pla bexa nsen med nkix be men ndoꞌ xa nibeꞌe Roma cha ulayaꞌ wats Juan. Leꞌa bexa wa no nlad italeaꞌ, ndab bexa ndoꞌ Juan: —Mech, ¿xtaꞌan nsabndoꞌ gun besa zha? ");
INSERT INTO zpt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Leꞌa Juan cha ndab: —Lá inab bega mas sian med ndoꞌ dub lak nsabndoꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Weꞌe no stapla soldad unabdiꞌizh ndab: —¿Besa zha xtaꞌan nsabndoꞌ gun? Leꞌa Juan cha ndab: —Naꞌanpa ucheb bega be men, no lá ulat bega med ten bexa. No lá usake bega dub men dub taꞌa naꞌanpa ngun xa. Bten ladna bego nsea tal plo ta nkix xa nkaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Leꞌa be men wa ndenkeaꞌ zha ilen Cristo, no ndanbeꞌe bexa naga lid leꞌa Juan nak xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ta weꞌe leꞌa Juan cha ndab ndoꞌ itea bexa: —Leꞌa naꞌ ndee nits‑tsa ngoleaꞌ bega, ná leꞌa tsoꞌo naꞌ ilen stub xa koleaꞌ be men no Espíritu ten Dios no giꞌ. Leꞌa xa wa mas nsak ndoꞌ naꞌ gast ni lá isaya naꞌ kote naꞌ ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Leꞌa xa wa listla nsoꞌ uti be men wen lat bexa ugap, cuent dub men nti bid ten trig lat be gix xab‑a. Cha kochaꞌaw xa trig wa len niꞌi, nsea utsoꞌol xa xab‑a wa ndoꞌ giꞌ nunk lá yuꞌu. ");
INSERT INTO zpt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Leꞌa be ta ndee no sianta be taꞌa mtenxeꞌa Juan be men, mbidiꞌizh xa diꞌizh wen ten Dios ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Leꞌa tsoꞌo wa leꞌa Juan ndab ndoꞌ Herodes xa nibeꞌe Galilea leꞌa ta mbin Herodes naꞌanpa leꞌa nak ndoꞌ Dios, geal leꞌa xa ukaꞌa Herodías xagots ten Julip wit xa no sianta be ta ugap mbin xa. ");
INSERT INTO zpt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Weꞌe leꞌa Herodes mbin stub ta mas ugap, unibeꞌe xa ikea Juan litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Leꞌa zha na bi li ngoleaꞌ Juan kwaꞌad be men, leꞌa xa no Jesús ulaleaꞌ zha wa. Leꞌa gor weꞌe uníꞌi Jesús ndoꞌ Dios, cha myaꞌal gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Weꞌe leꞌa Espíritu ten Dios cha ulen gibeꞌa cuent dub palom nchaꞌlaꞌ sa nsoꞌ Jesús. No ulen ti Dios gibeꞌa ndab ndoꞌ Jesús: —Lu nak Xiꞌín naꞌ. Leꞌa naꞌ nkweaꞌ ladna lu, no ntenno lad naꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Leꞌa Jesús ncho pa dub galntiꞌila liꞌin zha na usaxan xa ndun xa tiꞌin mtuꞌub Dios xa gun xa. Leꞌa be men ndab leꞌa Jesús xin Kosé. Leꞌa Kosé xin Elí. ");
INSERT INTO zpt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí xin Matat, Matat xin Leví, Leví xin Melqui, Melqui xin Jana, Jana xin Kosé, ");
INSERT INTO zpt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Kosé xin Matatías, Matatías xin Amós, Amós xin Nahum, Nahum xin Esli, Esli xin Nagai, ");
INSERT INTO zpt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai xin Maat, Maat xin Matatías, Matatías xin Semei, Semei xin Kosé, Kosé xin Judá, ");
INSERT INTO zpt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá xin Joana, Joana xin Resa, Resa xin Zorobabel, Zorobabel xin Salatiel, Salatiel xin Neri, ");
INSERT INTO zpt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri xin Melqui, Melqui xin Adi, Adi xin Cosam, Cosam xin Elmodam, Elmodam xin Er, ");
INSERT INTO zpt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er xin Josué, Josué xin Eliezer, Eliezer xin Jorim, Jorim xin Matat, ");
INSERT INTO zpt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat xin Leví, Leví xin Simeón, Simeón xin Judá, Judá xin Kosé, Kosé xin Jonán, Jonán xin Eliaquim, ");
INSERT INTO zpt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim xin Melea, Melea xin Mainán, Mainán xin Matata, Matata xin Natán, ");
INSERT INTO zpt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán xin David, David xin Isaí, Isaí xin Obed, Obed xin Booz, Booz xin Salmón, Salmón xin Naasón, ");
INSERT INTO zpt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón xin Aminadab, Aminadab xin Aram, Aram xin Esrom, Esrom xin Fares, Fares xin Judá, ");
INSERT INTO zpt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá xin Jacob, Jacob xin Isaac, Isaac xin Abraham, Abraham xin Taré, Taré xin Nacor, ");
INSERT INTO zpt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor xin Serug, Serug xin Ragau, Ragau xin Peleg, Peleg xin Heber, Heber xin Sala, ");
INSERT INTO zpt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala xin Cainán, Cainán xin Arfaxad, Arfaxad xin Sem, Sem xin Noé, Noé xin Lamec, ");
INSERT INTO zpt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec xin Matusalén, Matusalén xin Enoc, Enoc xin Jared, Jared xin Mahalaleel, Mahalaleel xin Cainán, ");
INSERT INTO zpt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán xin Enós, Enós xin Set, Set xin Adán, Adán xin Dios. ");
INSERT INTO zpt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Leꞌa Espíritu ten Dios cha msaꞌa juers ndoꞌ Jesús, cha utoꞌo Jesús toꞌo yowbeꞌe Jordán. Cha mbiꞌi Espíritu ten Dios xa geꞌe sa bid sa naꞌan men. ");
INSERT INTO zpt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Leꞌa Jesús uyoꞌo dub top gaꞌal wizh sa wa. Leꞌa maxuꞌu mbin preb Jesús, nlad maxuꞌu utsabgix maxuꞌu Jesús. Leꞌa be wizh wa leꞌa Jesús lá ngaw, ta weꞌe zha utid be wizh wa leꞌa xa uzhebpa ndanna. ");
INSERT INTO zpt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Weꞌe leꞌa maxuꞌu cha ndab ndoꞌ xa: —Tal leꞌa lu Xin Dios, nat gud ndoꞌ geꞌ baꞌ yak‑a pan. ");
INSERT INTO zpt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa diꞌizh ten Dios nkeaniꞌi: “Naꞌanpa nabtsa ta ndaw men nban bexa. Mas nsak nxobgek men ndoꞌ diꞌizh ten Dios, leꞌa ta wa ndun nban xa.” ");
INSERT INTO zpt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Weꞌe leꞌa maxuꞌu cha mbiꞌi Jesús gek dub geꞌe gaꞌappa. Cha uxax mluu maxuꞌu itea be gezh nde ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Cha ndab maxuꞌu ndoꞌ Jesús: —Leꞌa itea be gezh baꞌ no itea be ta nsak ncho ndoꞌ be gezh baꞌ, leꞌa ta wa usa naꞌ ndoꞌ lu inibeꞌe lu‑yá. Leꞌa ta baꞌ ta nibeꞌe naꞌ, no sak usa naꞌ‑yá ndoꞌ bexa nlad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tal leꞌa lu isaxib ndoꞌ naꞌ yankea lu naꞌ, leꞌa naꞌ usa itea be ta baꞌ ikaꞌa lu. ");
INSERT INTO zpt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Leꞌa Jesús cha ndab ndoꞌ maxuꞌu: —Bxoꞌon wats naꞌ, maxuꞌu. Leꞌa diꞌizh ten Dios nkeaniꞌi ndab‑a: “Wankea Dios Xa Nibeꞌe, no bin ta nladtsa xa.” ");
INSERT INTO zpt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Weꞌe leꞌa maxuꞌu cha mbiꞌigal Jesús gezh Jerusalén gek niꞌi ten Dios sa ndon leꞌa gaꞌap. Cha ndab maxuꞌu: —Tal leꞌa lu Xin Dios, nat btsaꞌab brink gast ndoꞌ yo baꞌ, ");
INSERT INTO zpt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","geal leꞌa diꞌizh ten Dios nkeaniꞌi ndab‑a: Leꞌa Dios utuꞌub be angel ten na ulaꞌach lu. ");
INSERT INTO zpt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Leꞌa bexa wa goꞌo lu ndoꞌ yaꞌa na, ndontsa ni lá ikateꞌeb lu ndoꞌ ni dub geꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Leꞌa Jesús cha ukaꞌab ndab: —No ndab diꞌizh ten Dios: “Lá gun lu preb Dios Xa Nibeꞌe.” ");
INSERT INTO zpt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cha li mteꞌa maxuꞌu be ta mbin maxuꞌu preb Jesús wa, cha mlaꞌa maxuꞌu xa dub ndeꞌep. ");
INSERT INTO zpt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Leꞌa Jesús cha mlanseaꞌ distrit Galilea, cha mas uyoꞌo juers ten Espíritu ten Dios xa. Leꞌa be ta mbin Jesús cha mgen itea be sa gax sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","No mluu Jesús be men len be niꞌi sa nzhealbe bexa judio. Cha ndab bexa leꞌa Jesús leꞌaka ndadiꞌizh. ");
INSERT INTO zpt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsoꞌo wa leꞌa Jesús cha nseaꞌ Nazaret sa na ngoꞌol xa. Leꞌa ngol dub wizh neꞌe bexa judio, leꞌa xa cha no uyoꞌo len niꞌi sa nzhealbe bexa wa, lakka ndun xa. Cha ngwasoꞌ xa goꞌol xa diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Cha msaꞌa bexa dub libr nyuꞌud ndoꞌ Jesús, ta nsoꞌ diꞌizh mkeꞌa Isaías, xa mbidiꞌizh sakndoꞌ Dios tiemp polta. Leꞌa gor na mxaꞌal xa git wa, cha mzheal xa sa ndab‑a: ");
INSERT INTO zpt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Leꞌa Espíritu ten Dios Xa Nibeꞌe ncho ladoꞌo naꞌ, leꞌa Dios mti naꞌ gudiꞌizh naꞌ ndoꞌ be men uban nak leꞌa Dios gakno bexa. No gun naꞌ wen yoo ladna bexa kweaꞌ ncho ladna, no itoꞌo bexa nkea litgiꞌib, no inaꞌ bexa lá naꞌ. No ko naꞌ bexa kweaꞌ ndencho ndoꞌ yaꞌa be men, ");
INSERT INTO zpt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","no ndalyáp naꞌ leꞌa Dios Xa Nibeꞌe yá ngol tiemp gakno be xmen na. ");
INSERT INTO zpt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cha mtsaw Jesús git wa, cha msaꞌa xa‑yá ndoꞌ xa nchansu sa wa, cha usob xa. Leꞌa itea be men nde len niꞌi wa cha nwiꞌi ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Leꞌa Jesús cha ndab ndoꞌ bexa: —Nat ngok cumplir be diꞌizh ndee ndoꞌ gaꞌal bega. ");
INSERT INTO zpt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Leꞌa itea be men wa ndab leꞌa Jesús dub xa wenka. No ngwanseana bexa ndoꞌ be ta li mbidiꞌizh Jesús wa, ndab bexa: —¿Lid xin Kosé xa baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Leꞌa Jesús cha ndab: —Ta ugeapa leꞌa bego gab dub diꞌizh ndee ndoꞌ naꞌ: “Doctor, byunyakna go leꞌaka go. Bin ga be uyon lazh ga ndee, lak ndoꞌón besa mbin go be uyon gezh Capernaum.” ");
INSERT INTO zpt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Cha no ndab Jesús: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa ni dub profet lá gungea ladna bexa lazh xa ti profet xa. ");
INSERT INTO zpt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","No gáp naꞌ leꞌa tiemp uyoꞌo profet Elí, lá ilaꞌ gi chon liꞌin ncho xoꞌop mbeꞌe, cha uzhebpa uyoꞌo win idub Israel. Leꞌa zha wa leꞌa kwaꞌad be xagots nab ngut xabgiꞌi ten na uyoꞌo Israel. ");
INSERT INTO zpt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Parea leꞌa Dios ni dub ndoꞌ be xagots Israel wa lá utuꞌub Elí. Leꞌa xa wa ndi ngwaꞌyakno dub xagots ncho gezh Sarepta sa nibeꞌe Sidón. ");
INSERT INTO zpt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","No liga leꞌa tiemp uyoꞌo profet Eliseo, leꞌa kwaꞌad bexa Israel nsén gealgizh lepra, parea ni dub bexa wa lá yunyakna xa. Leꞌa xa ndi myunyakna dub xa nsaleaꞌ Naamán, xa nacion Siria. ");
INSERT INTO zpt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Leꞌa gor na mbiꞌín bexa ta ndab Jesús, cha uzhebpa ngokloo itea bexa. ");
INSERT INTO zpt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Cha ngwasoꞌ bexa, mbiꞌi juers bexa Jesús toꞌo gezh sa mas gaꞌap gek bet wa, ndiꞌizh utsuꞌub bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Parea leꞌa Jesús cha myach, mtid xa tlaw bexa wa, cha nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Leꞌa Jesús cha nchaꞌa Capernaum dub gezh ten distrit Galilea. Leꞌa ngol be wizh neꞌe bexa judio, leꞌa Jesús cha mluu be men len niꞌi sa nzhealbe bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Leꞌa bexa wa ndanseana xteꞌe ndadiꞌizh xa, geal leꞌa ta ndadiꞌizh xa wa nluu leꞌa xa uzheꞌeb ndap juers. ");
INSERT INTO zpt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ngol dub wizh leꞌa dub xabgiꞌi nsak gizh tont ncho mbi bxin len ladoꞌo na no nsob sa wa. Leꞌa mbi bxin wa cha ugeꞌ ndab ndoꞌ Jesús: ");
INSERT INTO zpt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Blaꞌa besa. ¿Xtaꞌan nsea ugal lu besa, Jesús xa Nazaret? ¿Nsea unitndoꞌ lu besa zha? Leꞌa naꞌ nchandoꞌ lu, leꞌa lu xa umbiꞌi mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Leꞌa Jesús cha uteyo mbi bxin wa, ndab xa: —¡Kexga lu! ¡Utoꞌo ladoꞌo xa baꞌ! Weꞌe leꞌa mbi bxin wa cha udabi xabgiꞌi wa ndoꞌ yo lat be men, cha utoꞌo mbi bxin wa len ladoꞌo xa, naꞌanta xtaꞌan ngunno ta wa xa. ");
INSERT INTO zpt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Weꞌe leꞌa itea be men wa ngwanseana, ndab bexa ndoꞌ ltsaꞌa bexa: —¿Xteꞌe nak diꞌizh ten xa ndee zha? Leꞌa xa ndee ndap juers nibeꞌe xa ndoꞌ be mbi bxin, cha ntoꞌo be mbi bxin wa len ladoꞌo be men. ");
INSERT INTO zpt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Leꞌa ta li mbin Jesús wa cha mgen itea be gezh ndebe gax sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Weꞌe leꞌa Jesús cha utoꞌo len niꞌi wa, cha nchaꞌa xa ta lid Simón. Leꞌa xnazhaꞌap Simón uzhebpa kweaꞌ nsak, ncho xlea xa. Cha unab bexa ndoꞌ Jesús yunyakna Jesús xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Leꞌa Jesús cha ubii sa nax xa wa, cha uteyo Jesús xlea wa, cha mtoꞌo xlea wa xa. Cha bi leꞌa gor wa ngwaste xa, msaꞌa xa ta gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Leꞌa gor na yá ngwaꞌasla wizh leꞌa be men ulenno kwaꞌadpa bexa gizh ndoꞌ Jesús, bexa nsén isandoꞌ gealgizh. Leꞌa Jesús cha mxoꞌob yaꞌa na las kadga dub bexa gizh wa, cha myakna bexa. ");
INSERT INTO zpt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No ulantuꞌub Jesús be mbi bxin ncho ladoꞌo kwaꞌad bexa. Leꞌa be mbi bxin wa ugeꞌ ndab ndoꞌ Jesús: —¡Lu nak Xin Dios! Leꞌa Jesús cha uteyo be mbi bxin wa, no lá ulaꞌata Jesús iníꞌi bena wa, geal leꞌa be mbi bxin wa uniꞌí leꞌa Jesús leꞌa nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngol stubtsa wizh leꞌa Jesús cha mkaꞌan sa wa, nchaꞌa xa dub sa naꞌan men. Ná leꞌa be men cha mkwaꞌan xa. Leꞌa ngol gor na mzheal bexa Jesús, ndab bexa ndoꞌ xa lá ikaꞌan xa gezh ten bexa. ");
INSERT INTO zpt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ no be gezh xaꞌaga nsabndoꞌ gudiꞌizh diꞌizh wen, ná xteꞌe nibeꞌe Dios be men. Leꞌa Dios tiꞌin weꞌe mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cha nchasea Jesús be gezh nibeꞌe Galilea, nluu xa be men len be niꞌi sa nzhealbe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Leꞌa dub wizh nsoꞌ Jesús toꞌo lagun nsaleaꞌ Genesaret. Leꞌa sa wa nde kwaꞌad be men nlad goꞌón diꞌizh wen ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Leꞌa Jesús cha uniꞌí top barco nde toꞌo nits wa. Leꞌa bexa nsen mbeal ndeusat be red ten na. ");
INSERT INTO zpt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Weꞌe leꞌa Jesús cha ukea ndoꞌ barco ten xa na nsaleaꞌ Simón, ndab xa ndoꞌ Simón: —Bsiꞌi barco ndee isasitxá‑yá toꞌo nits. Cha usob Jesús, cha usaxan xa nluugal xa be men kwaꞌad nde toꞌo nits wa. ");
INSERT INTO zpt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Leꞌa gor na mtayadiꞌizh xa ndoꞌ be men wa, cha ndab xa ndoꞌ Simón: —Btseꞌa barco ndee sa mas wat, cha btsaꞌab bego be red ten bega ndontsa igaꞌa mbeal. ");
INSERT INTO zpt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Leꞌa Simón ukaꞌab ndab: —Mech, leꞌa besa idub teꞌal mbin tiꞌin, ná ni dub man lá isen besa. Parea nat leꞌa naꞌ utsaꞌab red ndee leꞌa go leꞌa li ndab. ");
INSERT INTO zpt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Leꞌa gor na li mbin bexa wa, leꞌa red wa cha mzhea uyoꞌo be mbeal gast usaxan nsasaw‑a. ");
INSERT INTO zpt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Cha mbin bexa sein ndoꞌ be ltsaꞌa xa ndiꞌib ndoꞌ stub barco wa, ndontsa giꞌid yakno bexa. Leꞌa bexa wa cha ulenno stub barco, cha mchea bexa itop barco wa uyoꞌo be mbeal gast ngi slaꞌyoꞌo be barco len nits. ");
INSERT INTO zpt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Leꞌa gor na uniꞌí Simón Pedr ta wa, cha msaxib xa ndoꞌ Jesús, ndab xa: —Bxoꞌon ga wats naꞌ, Señor. Leꞌa naꞌ lá nsabndoꞌ isoꞌ wats ga, leꞌa naꞌ dub xa ndap ke ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Li ndab Simón geal leꞌa xa nsea be ltsaꞌa xa ndanseana no nzheb bexa gor na uniꞌí bexa ta na li mgaꞌa sian mbeal wa. ");
INSERT INTO zpt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","No liga ngwanseana Jacob nsea Juan, be xin Zebedeo, bexa ltsaꞌa ndunno Simón tiꞌin. Leꞌa Jesús cha ndab ndoꞌ Simón: —Lá izheb lu, nat leꞌa lu gak xa yunjunt be men ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Leꞌa bexa wa cha myoꞌo be barco wa toꞌo nits ndoꞌ yo, cha mlaute bexa itea be taꞌa ten bexa, cha nchaꞌano bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Leꞌa dub biaj zha uyoꞌo Jesús dub gezh, cha ulen dub xabgiꞌi wats Jesús, dub xa nsaꞌgea las na, nsén gealgizh lepra xa. Leꞌa gor uniꞌí xa Jesús, cha msaxib xa ndoꞌ Jesús gast ndoꞌ yo ngol xtuzh xa. Cha ndab xa ndoꞌ Jesús: —Señor, tal go nlad yunyakna go naꞌ, leꞌa naꞌ uní leꞌa go sunka gan. ");
INSERT INTO zpt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Leꞌa Jesús cha mxoꞌob yaꞌa na tsoꞌo xa wa, cha ndab Jesús: —Nladka naꞌ yakna lu. Nat myakna lu. Cha bi leꞌa gor wa leꞌa gealgizh wa cha unitndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Weꞌe leꞌa Jesús cha unibeꞌe ndoꞌ xa, ndab Jesús: —Naꞌan ton ndoꞌ ná gudiꞌizh lu xteꞌe myakna lu. Ndi waꞌ ndoꞌ uleꞌay iniꞌí xa leꞌa lu myaklana. No biꞌi be man xnab lak unibeꞌe ley mkeꞌa Moisés usaꞌa be men zha na myakna bexa, ndontsa iniꞌí be men leꞌa lu myaklana. ");
INSERT INTO zpt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ná leꞌa be ta li mbin Jesús wa uzhebpa mgen. Weꞌe leꞌa kwaꞌad be men ulansea wats Jesús, goꞌón bexa diꞌizh ten Jesús nsea yunyakna Jesús bexa. ");
INSERT INTO zpt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ná leꞌa Jesús sian biaj ntoꞌo nab, ndaꞌyadiꞌizhno xa Dios sa naꞌan men. ");
INSERT INTO zpt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Leꞌa ngol dub wizh leꞌa Jesús mluugal be men len dub niꞌi. Leꞌa sa wa no pla be mech ten ley ndebe no stapla bexa fariseo, bexa utoꞌo be gezh ten Galilea no be gezh ten Judea no Jerusalén. No uzheꞌeb msaꞌa Dios juers ndoꞌ Jesús yunyakna xa be men. ");
INSERT INTO zpt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Cha ulayaꞌno pla bexa dub xabgiꞌi gizh lá yoo gan isea, nchoꞌob xa ndoꞌ dub yaloꞌon. Leꞌa bexa wa nlad goꞌo xa gizh wa gast len niꞌi sa nsoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ná leꞌa bexa wa lá yoꞌo gan yate len niꞌi wa tant kwaꞌad men nde sa wa. Cha ndi ukea bexa gek niꞌi, cha mxaꞌal bexa‑yá. Cha mlaꞌko bexa yaloꞌon nax xa gizh wa ndoꞌ na sa nsoꞌ Jesús lat be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Leꞌa Jesús cha mnaꞌla leꞌa bexa ngeꞌ ladna leꞌa Jesús sun gan yunyakna xa gizh wa, cha ndab xa ndoꞌ xa gizh wa: —Mgiꞌi, leꞌa ke ten lu myuꞌula. ");
INSERT INTO zpt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Weꞌe leꞌa be mech ten ley no bexa fariseo mbinbeꞌe: “¿Tonxá xa ndee zhaga? Leꞌa ta ndab xa uzheꞌeb dub ta lá nsak ladna Dios. ¡Ndon Diostsa suꞌu utsuꞌu be ke ten be men!” ");
INSERT INTO zpt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ná leꞌa Jesús cha mgenna xteꞌe ndanbeꞌe bexa wa, cha ndab Jesús: —¿Xtaꞌan lbaꞌa ndanbeꞌe bega len ladoꞌo bega? ");
INSERT INTO zpt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Xtaꞌan mas lid bid gáp naꞌ, leꞌa ke ten xa ndee myuꞌula, nati gáp naꞌ gaste xa, cha isea xa? ");
INSERT INTO zpt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Leꞌa nat iniꞌí bega leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, no syoꞌo gan utsuꞌu ke ten be men. Weꞌe cha ndab Jesús ndoꞌ xa gizh wa: —Gáp naꞌ ndoꞌ lu goste, cha udob yaloꞌon ten lu, cha byaꞌ ta lid lu. ");
INSERT INTO zpt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Leꞌa xa wa cha uxax ngwaste ndoꞌ gaꞌal be men wa, cha udob xa yaloꞌon ngot xa ndoꞌ na wa. Leꞌa idub nes nseaꞌ xa nsaꞌa xa xno ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Leꞌa itea be men wa uzhebpa ngwanseana, no ndab bexa leꞌa Dios uzheꞌeb dub Dios siꞌil. No mzheb bexa, ndab bexa ndoꞌ be ltsaꞌa bexa: —¡Nat uniꞌí beuna dub taꞌa uzhebpa ndanseana beuna! ");
INSERT INTO zpt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsoꞌo wa leꞌa Jesús utoꞌo sa wa. Leꞌa sa nchaꞌtid xa uniꞌí xa dub xabgiꞌi nsaleaꞌ Leví nsobyun tiꞌin, nsen xa med nkix be men ndoꞌ gobier Roma. Cha ndab Jesús ndoꞌ xa: —¡Utsea! ¡Usankea tsoꞌo naꞌ! ");
INSERT INTO zpt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leꞌa Leví cha ngwasoꞌ, cha mlaꞌa xa tiꞌin ndun xa wa, cha usankea xa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Cha ulo Leví dub gast siꞌil ten Jesús ta lid na. Leꞌa sa wa no kwaꞌad bexa ndun ltsaꞌa tiꞌin mbin Leví wa ngwaꞌbe, no kwaꞌad bexa xaꞌaga. Cha junt utebe bexa ndoꞌ mes. ");
INSERT INTO zpt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ná leꞌa be mech ten ley no bexa fariseo cha xela uníꞌi ndoꞌ be xmen Jesús, ndab bexa: —¿Xtaꞌan ndawno bega bexa nsen med baꞌ no iteata bexa ugap baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa bexa naꞌanpa gizh lá nkiꞌin doctor, ndi leꞌa bexa gizh nkiꞌinka xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Leꞌa naꞌ ndee naꞌanpa ndalteꞌezh bexa ndanbeꞌe leꞌa naꞌanpa ndap ke. Leꞌa naꞌ ndi ndalteꞌezh bexa ngondoꞌ leꞌa ndapka ke, ndontsa yach bexa wats Dios. ");
INSERT INTO zpt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Weꞌe leꞌa ncho bexa ndab ndoꞌ Jesús: —Leꞌa be xmen Juan ncho sian wizh lá ndaw bexa ndontsa mas gudiꞌizhno bexa Dios. No liga ndun be xmen bexa fariseo. Ná leꞌa be xmen go zha, ¿xtaꞌan lid no bexa li ndun? Sbeꞌen ndeyaw bexa no ndo bexa itea wizh. ");
INSERT INTO zpt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Leꞌa Jesús cha ukaꞌab ndab: —¿Nsak bega zha leꞌa dub sa nchilyaꞌa men leꞌa bexa nde sa wa lá nsabndoꞌ gaw zha bi ncho xabgiꞌi mchilyaꞌa wa? ");
INSERT INTO zpt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Parea gal dub wizh leꞌa be men goꞌo xabgiꞌi mchilyaꞌa wa. Weꞌe leꞌa bexa nde sa wa lá gaw dub tiemp. ");
INSERT INTO zpt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","No cha msaktabeꞌe Jesús dub taꞌa mluu xa ndab xa: —Naꞌan ton nxen dub bleꞌa lad kub, cha ko xa ramient ta wa las dub lad gox. Tal leꞌa xa li gun leꞌa lad kub wa syaꞌad, cha mas stsaw‑a lad gox wa. No leꞌa lad kub wa naꞌanpa nsakna no lad gox wa. ");
INSERT INTO zpt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","No naꞌan ton ngo vin kub len dub bols gid gox. Tal leꞌa xa li gun, leꞌa vin kub stsaw bols gox wa. Leꞌa vin wa cha ibid stsiꞌi, no sazhaꞌa bols gox wa. ");
INSERT INTO zpt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Leꞌa vin kub wa nsabndoꞌ yoo len dub bols gid kubga, ndontsa ni dub‑a lá gazhaꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","No tal ton goo vin ncho polta, cha yá lá kaꞌabta xa goo xa vin kub. Leꞌa xa ndab leꞌa vin ncho polta wa mas wen. ");
INSERT INTO zpt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Leꞌa dub wizh neꞌe be men, leꞌa Jesús nchaꞌtid sa nax dub bleꞌa yo ncho trig. Leꞌa be xmen Jesús cha uxeꞌe pla be bid ten trig, cha uloꞌo bexa xab‑a, cha udaw bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Leꞌa ncho bexa fariseo cha ndab: —¿Xtaꞌan lbaꞌa ndun bega zha, ta lá nsabndoꞌ gun beuna wizh neꞌe beuna? ");
INSERT INTO zpt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Leꞌa Jesús ukaꞌab ndab: —¿Ni lá ndoꞌol bega sa ndab diꞌizh ten Dios ta mbin David dub biaj, zha na uzhebpa ndanna xa no bexa ndeseano xa zha? ");
INSERT INTO zpt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Leꞌa David uyoꞌo len niꞌilad ten Dios, cha usen xa be pan leꞌay, cha udaw xa‑yá. No msaꞌa xa‑yá ndoꞌ bexa ndeno xa. Ná leꞌa pan wa naꞌanpa nsabndoꞌ gaw dub men naꞌanpa nak uleꞌay. ");
INSERT INTO zpt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","No ndab Jesús: —Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, noga nibeꞌe wizh neꞌe be men. ");
INSERT INTO zpt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ngol stub wizh neꞌe be men, leꞌa Jesús cha uyoꞌo len niꞌi sa nzhealbe bexa judio, cha mluu xa be men. Leꞌa sa wa nsob dub xabgiꞌi ubidya dub yaꞌa na, ná lad gaꞌal. ");
INSERT INTO zpt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Leꞌa bexa fariseo no be mech ten ley cha ndeulaꞌach naga syunyakna Jesús xa gizh wa wizh neꞌe bexa, ndontsa litsa usake bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ná leꞌa Jesús mgenna ta ndanbeꞌe bexa, cha ndab xa ndoꞌ xa gizh yaꞌa na wa: —Gosoꞌ, cha usoꞌ tlaw ndee. Leꞌa xa wa cha usoꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Leꞌa Jesús cha ndab ndoꞌ be men wa: —Leꞌa naꞌ inabdiꞌizh dub taꞌa ndoꞌ bego. ¿Leꞌa wizh neꞌe beuna nsabndoꞌ gun beuna ta wen, nati gun beuna ta ugap? ¿Gakno beuna dub men, nati ulaꞌa beuna gat xa? ");
INSERT INTO zpt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Cha mwiꞌi Jesús ndoꞌ itea be men ndebe idub gangeak, cha ndab xa ndoꞌ xa gizh yaꞌa na wa: —Bkea yaꞌa lu. Leꞌa xa wa cha mkea yaꞌa na, cha uxax myakna‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Weꞌe leꞌa bexa nde sa wa uzheꞌeb ngoklobe, ndab bexa ndoꞌ be ltsaꞌa bexa ná xteꞌe gunno bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ngol tsoꞌo wa leꞌa Jesús ukea dub bet sa nchaꞌyadiꞌizhno xa Dios idub teꞌal. ");
INSERT INTO zpt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngol gor na ngot xeꞌa, cha utezh Jesús itea be men ndeseano xa. Cha mti xa dub tibtop bexa utuꞌub xa gun bexa tiꞌin ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Leꞌa bexa wa lndeꞌe nsaleaꞌ: Simón xa msaleaꞌ Jesús Pedr, no Ndres wit Simón, no Jacob no Juan no Julip no Bartol ");
INSERT INTO zpt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","no Mateo no Tomás no Jacob xin Alfeo, no Simón xa partid Zelote, ");
INSERT INTO zpt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","no Judas wit Jacob no Judas Iscariot, xa na leꞌa myun cuent Jesús tsoꞌo wa. ");
INSERT INTO zpt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cha mlayoꞌo Jesús no be xmen xa bet wa ngol dub sa lat. Leꞌa sa wa ndebe kwaꞌad be men, bexa utoꞌo gezh Jerusalén no idub distrit Judea no toꞌo nitsdoꞌo sa nde gezh Tiro nsea gezh Sidón. Leꞌa bexa wa nseabeyoꞌón ná xtaꞌan gudiꞌizh Jesús, nsea yunyakna Jesús bexa nsén gealgizh. ");
INSERT INTO zpt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","No myunyakna xa be men kweaꞌ nsak, ncho mbi bxin len ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Leꞌa itea be men gizh wa nlad ugal las Jesús, geal leꞌa las Jesús ntoꞌo juers nyunyakna bexa. ");
INSERT INTO zpt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Leꞌa Jesús cha mwiꞌi ndoꞌ be xmen na, ndab xa: —Uzheꞌeb wen yoo ladna bego na uban nak, leꞌa Dios nibeꞌe ladoꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’No uzheꞌeb wen yoo ladna bego na nkwaꞌan gun lak nlad Dios, leꞌa Dios saꞌa ta nlad bega wa. ’No uzheꞌeb wen yoo ladna bego na ndoꞌon, leꞌa gal gor wen yoo bega uxiꞌid bega. ");
INSERT INTO zpt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’No uzheꞌeb wen yoo ladna bego na nxee ladna be men ndoꞌ na, no lá nlad bexa uchealtsaꞌa bexa bega, no xela níꞌi bexa ndoꞌ bega. Li ugap gunno bexa bega ta na nak bega xmen naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Uzhebpa bten ladna bega be zha li wa, leꞌa Dios uzhebpa usaꞌa be ta wen ndoꞌ bega gibeꞌa. Leꞌa bexa na li ugap ndanno bega wa, leꞌa be usan gox polta ten bexa wa likaga ugap mbinno bexa mbidiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Parea ¡proꞌob bego xa rik, leꞌa bega wen ndencho nattsa! ");
INSERT INTO zpt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡No proꞌob bego bexa ndap itea be taꞌa nlad na, leꞌa bega galka gor yá lá gapta be ta wa! ’¡No proꞌob bego na nxiꞌid, leꞌa gal gor leꞌa bega uban yoo ladna no goꞌon bega! ");
INSERT INTO zpt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡No proꞌob bego na utsin nak be men ndoꞌ na, leꞌa be usan gox polta ten be men wa lika utsin ngok ndoꞌ bexa na nkwiꞌin ndab leꞌa ndadiꞌizh sakndoꞌ Dios! ");
INSERT INTO zpt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Parea leꞌa naꞌ gáp ndoꞌ bego na nlad goꞌón, bkweaꞌ ladna bega bexa na ndakloo ndoꞌ bega, no utsin gok bega ndoꞌ bexa nxee ladna ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","No utsin uníꞌi bega ndoꞌ bexa nisi bega. No unab bega ndoꞌ Dios gakno Dios bexa xela níꞌi ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Leꞌa tal ton kichyaꞌa dub lad ndoꞌ bega, blaꞌa bega kichyaꞌa xa no stubga lad. No tal ton ulat dub xab bega, blaꞌa bega goꞌo xa gast no stub‑a. ");
INSERT INTO zpt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","No tal ton inab dub taꞌa ndoꞌ bega, bsaꞌa bega‑yá. No tal ton goꞌo dub taꞌa ten bega, lá inab bega‑yá ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Utsin gunno bega be men lak nlad bega utsin gunno be men bega. ");
INSERT INTO zpt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tal leꞌa bega nkweaꞌ ladna beꞌen bexa nkweaꞌtsa ladna bega, ¿xteꞌe ni bega utsin ndun bega zha? Leꞌa be men ugap no lika ndun. ");
INSERT INTO zpt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No tal leꞌa bega utsin nak ndoꞌ bexa na utsin nak ndoꞌ bega, ¿xteꞌe ni bega utsin nak bega zha? Leꞌa bexa ugap no likaga ndun. ");
INSERT INTO zpt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No tal leꞌa bega ngodiꞌin dub taꞌa ndoꞌ bexa na uniꞌí bega skixka‑yá, ¿xteꞌe ni bega utsin ndun bega zha? Leꞌa bexa ugap no li ngodiꞌin be taꞌa ndoꞌ stub xa, cha nkenkeaꞌ bexa leꞌa xa wa skixka ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bkweaꞌ ladna bega bexa ndakloo ndoꞌ bega, no utsin gok bega. No leꞌa gor na ngodiꞌin bega dub ta nkiꞌin stubga men, lá ikenkeaꞌ bega kix xa‑yá. Weꞌe leꞌa Dios uzheꞌeb usaꞌa ta wen ndoꞌ bega, no isaleaꞌ bega xin Dios siꞌil. Leꞌa Dios uzheꞌeb dub xa wen ndoꞌ itea be men, gast ndoꞌ bexa lá nsaꞌa xno ndoꞌ Dios no ndoꞌ bexa ugap nak. ");
INSERT INTO zpt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bkweaꞌ ladna bega be men, lakta nkweaꞌ ladna Dios Xus beuna be men. ");
INSERT INTO zpt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Lá gab bega leꞌa be men lid leꞌa ndun, ndontsa naꞌanpa gab Dios leꞌa bega lid leꞌa ndun. No naꞌanpa gab bega leꞌa bexa ndap ke, ndontsa naꞌanpa gab Dios leꞌa bego ndap ke. Bingeꞌ ladna bega ndoꞌ be men, ndontsa no Dios sungeꞌ ladna ndoꞌ bego. ");
INSERT INTO zpt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bsaꞌa bega ta nkiꞌin be men, cha no Dios usaꞌa sian taꞌa ikaꞌa bega, lak ndun dub men nsaꞌa sian taꞌa. Ntiꞌix xa‑yá, cha nkadko xa‑yá, no nkwiꞌin xa‑yá ndontsa sian‑a yoo gast iteꞌach‑a. Leꞌa lak ndakno bega be men, no liga gakno Dios bega. ");
INSERT INTO zpt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Weꞌe msaktabeꞌe Jesús dub taꞌa mluu xa, ndab xa: —¿Syoꞌo gan goꞌo dub xa lá naꞌ stubga xa lá naꞌ? ¿Lid itop bexa slaꞌyoꞌo len dub geꞌed zha? ");
INSERT INTO zpt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Leꞌa xin utsid dub mech naꞌanpa ndi mas ndák ndoꞌ mech. Tal leꞌa xa wenka ntsid, leꞌa xa laktsa ndák mech wa ndák. ");
INSERT INTO zpt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Xtaꞌan nwiꞌi bega gix tuzh ncho ndoꞌ ltsaꞌa bega zha, ná ni lá naꞌ bega leꞌa ndoꞌ bega ntsaw dub bleꞌa ya siꞌil? ");
INSERT INTO zpt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Xteꞌema yoo gan gab bega ndoꞌ ltsaꞌa bega: “Bsaꞌa ndoꞌ lu ko naꞌ gix tuzh ncho ndoꞌ lu”, ná bega ni lá naꞌ ti leꞌa ndoꞌ bega ntsaw dub bleꞌa ya siꞌil? Leꞌa bega ndab ugap nak stubga men, parea leꞌa bega ndi mas ugap nak. Ned udob bega ya siꞌil ntsaw ndoꞌ bega, weꞌeta sun bega gan koꞌo bega gix tuzh ncho ndoꞌ stub xa. ");
INSERT INTO zpt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Leꞌa dub ya nsaꞌa ngus wen naꞌanpa usaꞌa ngus lá isuꞌu gaw men. No liga dub ya nsaꞌa ngus lá ndaw be men naꞌanpa usaꞌa ngus wen. ");
INSERT INTO zpt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Leꞌa be ngus ten dub ya nluu xá ya na‑yá. No naꞌanpa usaꞌa yagich ngus laꞌaw, no ni lá usaꞌa‑yá uv. ");
INSERT INTO zpt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","No liga leꞌa be men wen ndadiꞌizh ta wen, lak ta wen ncho ladoꞌo xa. No leꞌa bexa ugap wa ndadiꞌizh ta ugap, lak ta ugap ncho ladoꞌo xa. Leꞌa ta na ncho ladoꞌo bexa wa, ta weꞌetsa ndadiꞌizh bexa. ");
INSERT INTO zpt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Xtaꞌan níꞌi bega ndoꞌ naꞌ: “Señor, Señor”, ná lá ndun bega ta ndáp naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Leꞌa tal ton ibii wats naꞌ, cha goꞌón xa be ta ndáp naꞌ, cha liga gun xa, leꞌa naꞌ gáp xteꞌe nak xa wa: ");
INSERT INTO zpt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","leꞌa xa nak cuentta dub xabgiꞌi gundeꞌe lid na, wat udan xa sa kwe xan‑a. Cha mtexan xa‑yá ndoꞌ geꞌdaꞌa. Weꞌe leꞌa gor na ulen nits kwaꞌal, leꞌa nits wa cha ukeꞌa niꞌi wa. Parea leꞌa nits wa ni lá ngun gan ukwiꞌinsob niꞌi wa, geal leꞌa xan‑a nsob ndoꞌ geꞌdaꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ná leꞌa tal ton goꞌón ta ndáp naꞌ, ná lá uxobgek xa ndoꞌ‑yá, leꞌa xa wa cuent dub xa mtexan lid na ndoꞌ yotsa. Leꞌa gor na ulen nits kwaꞌal ukeꞌa niꞌi wa, cha ulate idub niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Leꞌa gor na mtaꞌuluu Jesús be men wa, cha nchaꞌa xa gezh Capernaum. ");
INSERT INTO zpt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Leꞌa sa wa ncho dub soldad Roma, xa nibeꞌe dub gayoꞌo soldad. Leꞌa xa wa uzhebpa nkweaꞌ ladna dub xa ndun tiꞌin ndoꞌ na, parea leꞌa xa na ndun tiꞌin wa uzhebpa kweaꞌ nsak gast ngi sat xa. ");
INSERT INTO zpt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Leꞌa gor na mbiꞌín soldad wa leꞌa Jesús nkesea Capernaum, cha mtuꞌub xa pla bexa gox nsak ten bexa judio, yaꞌinab bexa ndoꞌ Jesús giꞌid Jesús yunyakna xa xa gizh wa. ");
INSERT INTO zpt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Leꞌa gor na ulayaꞌ bexa wa wats Jesús, cha uzhebpa unab bexa ndoꞌ Jesús, ndab bexa: —Leꞌa go nsabndoꞌ gakno soldad wa, ");
INSERT INTO zpt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","leꞌa xa nkweaꞌ ladna beuna xa Israel, no ngokno xa ngokndeꞌe niꞌi sa nzhealbe beuna gezh ndee. ");
INSERT INTO zpt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Leꞌa Jesús cha nchaꞌano bexa wa. Ná leꞌa gor na yá nchaꞌbe gax bexa ta lid soldad wa, leꞌa xa mtuꞌub pla bexa nchaꞌyab ndoꞌ Jesús: —Señor, naꞌantapa yuꞌno ladna go naꞌ, leꞌa naꞌ naꞌanpa isayaꞌ yate go len lid naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ta weꞌe naꞌanpa naꞌ ngalyáp ndoꞌ go giꞌid ga. Nat gudtsa go yakna xa wa, leꞌa xa syakkana. ");
INSERT INTO zpt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Leꞌa naꞌ ndee nxobgek ndoꞌ xa mas nibeꞌe ndoꞌ naꞌ. No ncho be soldad nibeꞌe naꞌ ndoꞌ na. Leꞌa gor na ndáp naꞌ ndoꞌ dub xa yaꞌ xa, leꞌa xa cha ndaꞌkaga. No gor na ndáp naꞌ giꞌid stub xa, leꞌa xa cha ndiꞌidkaga. No gor na nibeꞌe naꞌ ndoꞌ xa ndun tiꞌin ndoꞌ naꞌ, leꞌa xa wa cha ndunkaga ta li ndáp naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Leꞌa gor na mbiꞌín Jesús ta wa, cha ngwanseana xa. Cha mgeak Jesús mwiꞌi xa ndoꞌ be men nchankea tsoꞌo xa, ndab xa ndoꞌ bexa wa: —Leꞌa naꞌ gáp ndoꞌ bego, naꞌanpa izheal naꞌ ni dub xa Israel lndeꞌeta ngeꞌ ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Leꞌa gor na mlanseaꞌ bexa na mtuꞌub soldad wa ta lid soldad, leꞌa xa gizh wa myaklana. ");
INSERT INTO zpt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsoꞌo wa leꞌa Jesús no be xmen xa no kwaꞌadta be men utoꞌo nchaꞌbe gezh nsaleaꞌ Naín. ");
INSERT INTO zpt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Leꞌa gor na nchaꞌbe bexa gax sa nyote be men len gezh wa, cha uniꞌí bexa kwaꞌad be men gezh wa nchaꞌukaꞌach xinbgiꞌi dub xagots ngut xabgiꞌi ten na. Leꞌa xa wa dubkama xinbgiꞌi na ngop. ");
INSERT INTO zpt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Leꞌa gor uniꞌí Jesús xagots wa, leꞌa Jesús cha mlats ladna xa, cha ndab Jesús ndoꞌ xa: —Yá lá goꞌonta lu. ");
INSERT INTO zpt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Leꞌa Jesús cha ubii, cha mgal xa ta nchoꞌob xa ngut wa ndoꞌ na. Leꞌa be men nchaꞌano xa ngut wa cha ngwaꞌibe. Cha ndab Jesús: —Myoꞌ, leꞌa naꞌ gáp ndoꞌ lu, goste. ");
INSERT INTO zpt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Leꞌa myoꞌ wa cha ngwasob, cha uníꞌi. Leꞌa Jesús cha myun cuent myoꞌ wa ndoꞌ xnaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Leꞌa itea be men cha mzheb, no msaꞌa bexa xno ndoꞌ Dios, ndab bexa: —¡Dub profet nsak ten Dios ulen lat beuna! No ndab bexa: —¡Leꞌa Dios mbiꞌid yakno be xmen na! ");
INSERT INTO zpt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Leꞌa ta li mbin Jesús wa mgen idub distrit Judea, no iteanak be gezh nde idub gangeak sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Leꞌa be xmen Juan xa na ulaleaꞌ be men wa cha ndab ndoꞌ Juan itea be ta li mbin Jesús wa. Leꞌa Juan cha utezh top bexa, ");
INSERT INTO zpt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","cha mtuꞌub xa bexa wa ndoꞌ Jesús, ngwaꞌ inabdiꞌizh bexa naga leꞌa Jesús nak xa na li ndab Dios ilen wa, nati kweas bexa ilen stubga xa. ");
INSERT INTO zpt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Leꞌa bexa wa cha ulayaꞌ wats Jesús, cha unabdiꞌizh bexa, ndab bexa ndoꞌ Jesús: —Leꞌa Juan xa ulaleaꞌ be men wa mtuꞌub besa inabdiꞌizh besa ndoꞌ ga naga go xa ndab Dios ilen wa, nati kweas besa ilen stubga xa. ");
INSERT INTO zpt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bi leꞌa gor wa leꞌa Jesús myunyakna kwaꞌadta bexa gizh, no ulantuꞌub xa be mbi bxin ncho len ladoꞌo be men, no myunyakna xa ngusndoꞌ bexa lá naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Cha ndab Jesús ndoꞌ itop be xmen Juan wa: —Byaꞌbe bega, cha gud bega ndoꞌ Juan be ta uniꞌí bega no be ta ndoꞌón bega: leꞌa bexa lá yoo gan iwiꞌibe, nat leꞌa bexa wa naꞌla; leꞌa bexa na lá yoo gan isea, nat leꞌa bexa wa nseala; leꞌa bexa nsén gealgizh lepra, nat leꞌa bexa wa myaklana; leꞌa bexa ngwaꞌad, nat leꞌa bexa wa ndoꞌónla; leꞌa bexa ngut, nat leꞌa bexa wa nbanla; no leꞌa bexa uban nak ndoꞌón diꞌizh wen ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Uzhebpa wen yoo ladna tal ton igondoꞌ ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Leꞌa gor na nseaꞌbe bexa na mtuꞌub Juan wa, leꞌa Jesús cha usaxan mbidiꞌizh ndoꞌ be men cuent ten Juan, ndab xa: —Leꞌa gor na ngwaꞌbe bega geꞌe sa uxee ncho be men, ¿xtaꞌan ngwaꞌiwiꞌi bega zha? ¿Dub yalod nkwiꞌin mbi zha? ");
INSERT INTO zpt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nati, ¿xtaꞌan ngwaꞌiwiꞌi bega zha? ¿Dub xabgiꞌi ndak dub lad uyap nsak zha? Leꞌa bego uniꞌíka leꞌa bexa ndak lad uyap wa, no ndap bexa itea be ta nlad bexa, leꞌa bexa wa ncho ta lid bexa nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Xtaꞌan ngwaꞌiwiꞌi bega zha? ¿Ngwaꞌiwiꞌi bega dub xa ndadiꞌizh sakndoꞌ Dios zha? Leꞌa naꞌ gáp ndoꞌ bega leꞌa Juan ta ugeaka ndadiꞌizh sakndoꞌ Dios, parea leꞌa xa wa mas nsak ndoꞌ iteata bexa li ndun wa. ");
INSERT INTO zpt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Leꞌa diꞌizh ten Dios nkeaniꞌi cuent ten Juan, ndab‑a: Bwiꞌi, leꞌa naꞌ utuꞌub dub xa yaꞌ ned ndoꞌ lu, uxaꞌal xa nes isea lu. ");
INSERT INTO zpt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No gáp naꞌ ndoꞌ bego, leꞌa lat itea be men ngol ndoꞌ gizhliyo, naꞌan stub profet mas nsak ndoꞌ Juan wa. Ná leꞌa tal ton uxee nsak lat bexa nibeꞌe Dios, leꞌa cuent ten Dios leꞌa xa wa mas nsak ndoꞌ Juan. ");
INSERT INTO zpt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Leꞌa itea be men no gast bexa nsen med nkix be men ndoꞌ gobier, leꞌa gor na mbiꞌín bexa ta mbidiꞌizh Juan, leꞌa bexa mgondoꞌ leꞌa Dios ndon leꞌa wen, cha ulaleaꞌ Juan bexa. ");
INSERT INTO zpt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ná leꞌa bexa fariseo no be mech ten ley, mxelad bexa ta na nlad Dios gun bexa, no lá nlad bexa koleaꞌ Juan bexa. ");
INSERT INTO zpt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","No ndab Jesús: —¿Xteꞌema nak be men ncho tiemp nat? ¿Xtaꞌanma dub ta li nak? ");
INSERT INTO zpt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Leꞌa bexa wa nak cuent be meꞌed nde ndoꞌ xgeꞌe, ugeꞌ ndab be meꞌed ndoꞌ ltsaꞌa med: Mbiꞌil besa bzhee, ná leꞌa bega lá ngolndatsbe. No mbiltoꞌoga besa cant uban nsea, ná leꞌa bega lá ngoꞌonga.” ");
INSERT INTO zpt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Li ndáp naꞌ geal leꞌa zha ulen Juan xa ulaleaꞌ be men wa, ncho wizh lá ngaw xa, no lá ndo xa vin. Cha ndab bega leꞌa xa ncho mbi bxin len ladoꞌo na, ta weꞌe li ndun xa. ");
INSERT INTO zpt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ná leꞌa nat ndalga naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. Leꞌa naꞌ ndee ndaw, no ndoꞌo naꞌ, ná leꞌa bega ndab leꞌa naꞌ uzhebpa ndaw, no uzhebpa ndoꞌo naꞌ vin. Ndab bego leꞌa naꞌ nchealtsaꞌa bexa ugap nak no bexa nsen med nkix be men ndoꞌ gobier Roma. ");
INSERT INTO zpt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ná leꞌa bexa ndák lak nsaꞌa Dios, leꞌa be ta wen ndun bexa wa nluu leꞌa bexa ndákka. ");
INSERT INTO zpt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Leꞌa dub xa fariseo cha unab ndoꞌ Jesús yaꞌdawno Jesús xa ta lid xa. Weꞌe leꞌa Jesús cha uyoꞌo len niꞌi wa, cha usob xa ndoꞌ mes. ");
INSERT INTO zpt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Leꞌa gor na mbiꞌín dub xagots ndun be ta ugap leꞌa Jesús nsob ndoꞌ mes ta lid xa fariseo, cha ulenno xa dub bot tuzh nakchaꞌaw geꞌ alabastro, ncho ta uxeꞌe len‑a. ");
INSERT INTO zpt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Cha usob xa lad tsoꞌo Jesús sa na nde xoꞌo xa. Cha uzheꞌeb ndoꞌon xa, gast nsalaꞌ nitsndoꞌ xa tsoꞌo xoꞌo Jesús. Leꞌa gichgek xa cha mtsambiꞌi xa tsoꞌo xoꞌo Jesús. Cha mchealtoꞌo xa tsoꞌo xoꞌo Jesús. Cha mtob xa ta uxeꞌe wa tsoꞌo xoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Leꞌa xa fariseo na li mbin invit ndoꞌ Jesús wa, gor na uniꞌí xa ta mbin xagots wa, cha mbinbeꞌe xa: “Tal leꞌa xa ndee dub profetka, leꞌa xa sniꞌíka leꞌa xagots lbaꞌa ngal xoꞌo xa baꞌ uzheꞌeb dub xa ndun ta ugap.” ");
INSERT INTO zpt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Weꞌe leꞌa Jesús cha ndab ndoꞌ xa fariseo: —Simón, leꞌa naꞌ nlad gáp dub taꞌa ndoꞌ lu. Leꞌa xa wa cha ukaꞌab ndab: —Gud go‑yá, Mech. ");
INSERT INTO zpt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Cha ndab Jesús: —Uyoꞌo top xabgiꞌi nsaꞌab med ndoꞌ dub xa ngodiꞌin med nbeꞌe. Leꞌa dub xabgiꞌi wa nsaꞌab dub gaꞌay gayoꞌo med denario. Leꞌa stub xa wa nsaꞌab dub tol gayoꞌo med wa. ");
INSERT INTO zpt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Leꞌa itop bexa wa lá ngun gan ikix be med wa, ta weꞌe leꞌa xa uladiꞌin med wa cha mbingeꞌ ladna ndoꞌ itop bexa wa. Nat gud ndoꞌ naꞌ, ¿ndoꞌ itop xa nsaꞌab med wa, ton mas nkea ladna xa na li uladiꞌin med wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Leꞌa Simón cha ukaꞌab ndab: —Leꞌa naꞌ ni xa na nsaꞌab mas sian med wa. Leꞌa Jesús cha ndab: —Leꞌaka ndab lu. ");
INSERT INTO zpt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Cha mwiꞌi Jesús ndoꞌ xagots wa, cha ndab Jesús ndoꞌ Simón: —¿Naꞌ lu xagots ndee? Leꞌa gor uyoꞌo naꞌ len lid lu, leꞌa lu ni lá usaꞌa nits yat xoꞌo naꞌ. Ná leꞌa xagots ndee msat xoꞌo naꞌ nsea nitsndoꞌ xa, no mtsambiꞌi xa xoꞌo naꞌ gichgek xa. ");
INSERT INTO zpt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Leꞌa lu ni lá uchealtoꞌo beꞌal ndoꞌ naꞌ, ná leꞌa xagots ndee bi xteꞌe uyoꞌo naꞌ len lid lu nunk xa lá ibeas uchealtoꞌo xoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","No ni lá utob lu aceit gek naꞌ, ná leꞌa xagots ndee mtob ta uxeꞌe baꞌ tsoꞌo xoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Leꞌa naꞌ gáp ndoꞌ lu, leꞌa xagots ndee uzheꞌeb nkweaꞌ ladna naꞌ, ta nluu leꞌa be ke sian ndap xa myuꞌula. Leꞌa xa tuzh ke ten na mtsuꞌu Dios, leꞌa xa wa ndidotsa ndankea Dios. ");
INSERT INTO zpt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Leꞌa Jesús cha ndab ndoꞌ xagots wa: —Leꞌa be ke ten lu myuꞌula. ");
INSERT INTO zpt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Leꞌa bexa na no nde ndoꞌ mes nsob Jesús wa ndabbe ndoꞌ be ltsaꞌa na: —¿Tonxá xa ndee zhaga ndab xa leꞌa xa mtsuꞌu ke ten xagots baꞌ? ");
INSERT INTO zpt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Leꞌa Jesús cha ndab ndoꞌ xagots wa: —Leꞌa ta na ngeꞌ ladna lu naꞌ, ta weꞌe myuꞌu be ke ten lu. Nat byaꞌ, cha bten ladna lu. ");
INSERT INTO zpt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsoꞌo wa leꞌa Jesús ukeseano isatibtop be xmen na sian be gezh ubiꞌi no be gezh byux. Ukesea uluu Jesús be men, ndadiꞌizh xa diꞌizh wen ten Dios ná xteꞌe gak bexa dub xa leꞌa Dios nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","No stapla be xagots ukeseano bexa, bexa myunyakna Jesús no ulantuꞌub xa be mbi bxin len ladoꞌo bexa. Leꞌa dub xa wa Marí xa gezh Magdala, xa na utoꞌo dub gaꞌad be mbi bxin len ladoꞌo na. ");
INSERT INTO zpt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Leꞌa stub xa wa Juana, xagots ten Chuza, xa na nchansu be tiꞌin ten Herodes. Leꞌa stub xa wa Susan. Leꞌa bexa wa, no kwaꞌadta be xagots msaꞌa be taꞌa nkiꞌin Jesús no be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Leꞌa kwaꞌad be men utoꞌo isandoꞌ be gezh ulen wats Jesús, cha msaktabeꞌe Jesús dub taꞌa mluu xa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Leꞌa dub xa ndun tiꞌin geꞌe utoꞌo nchaꞌutob xa bid ten trig ndoꞌ yo. Leꞌa gor na mteꞌach xa‑yá, ncho‑yá ulate toꞌo nes. Leꞌa be ná wa cha usoꞌ be men tsoꞌo na, cha ulen be migin cha udaw‑a. ");
INSERT INTO zpt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","No ncho‑yá ulate ndoꞌ yo geꞌ. Leꞌa gor na ulen ta wa, cha ubid‑a, geal leꞌa sa wa naꞌanpa kwazh. ");
INSERT INTO zpt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","No ncho‑yá ulate lat be gix nsoꞌ gich. Leꞌa gor na ulen trig nsea gix wa, leꞌa gix wa cha ulo xleaꞌ‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","No ncho‑yá ulate sa utaꞌa yo, cha msaꞌa‑yá dub gayoꞌoga bid. Weꞌe ugeꞌ ndab Jesús: —¡Bego na ndap nchaꞌ na, blaꞌach bego ta ndáp naꞌ ndee! ");
INSERT INTO zpt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Leꞌa be xmen Jesús cha unabdiꞌizh ndoꞌ xa, ndab bexa: —¿Xtaꞌan gab ta msaktabeꞌe go wa? ");
INSERT INTO zpt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Leꞌa Jesús cha ukaꞌab ndab ndoꞌ bexa wa: —Leꞌa Dios nsaꞌa ta nyakbeꞌena bega be ta ugaꞌach cuent ten xteꞌe nibeꞌe Dios. Ná leꞌa ndoꞌ bexa xaꞌaga sbeꞌen nsaktabeꞌe naꞌ be taꞌa gor ndadiꞌizh naꞌ. Tal iwiꞌi bexa leꞌa bexa lá inaꞌ. No tal goꞌón bexa ta ndáp naꞌ, leꞌa bexa lá yakbeꞌena‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Leꞌa ta msaktabeꞌe naꞌ wa lndeꞌe nak: Leꞌa bid ten trig wa cuent diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Leꞌa toꞌo nes sa ulate bid ten trig wa nak cuent be men ndoꞌón diꞌizh ten Dios, parea leꞌa maxuꞌu cha nlen ngoꞌo‑yá len ladoꞌo bexa, cha lá gungea ladna bexa‑yá, no lá usaꞌa Dios gealnaban ten bexa. ");
INSERT INTO zpt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Leꞌa yo geꞌ sa ulate bid wa nak cuent be men nten ladna ndoꞌón diꞌizh ten Dios, ná leꞌa bexa wa cuent trig lá ndap sian loꞌ na. Ndangea ladna bexa diꞌizh ten Dios dub ndeꞌep, ná leꞌa gor na juert ncho xa geal ndangea ladna xa diꞌizh wa, cha nlaꞌa xa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Leꞌa yo sa len gix nsoꞌ gich wa nak cuent be men ndoꞌón diꞌizh ten Dios. Ná leꞌa bexa nyuꞌ ladna, no ngeꞌ ladna bexa be ta siantsa ndap bexa, no nkwaꞌan bexa ta nladtsa bexa. Leꞌa bexa wa cuent dub trig lá nsaꞌa taꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Parea leꞌa sa utaꞌa yo wa nak cuent be men wen ladoꞌo na ndoꞌón diꞌizh ten Dios, no ndun bexa lak ndab‑a. Nxik bexa ndun bexa ta wen, leꞌa bexa nak cuent be trig nsaꞌa sian bid. ");
INSERT INTO zpt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Naꞌan ton kich xeꞌa, cha usob xa‑yá len dub gets, natal xan loꞌon. Leꞌa xa ndi usob xeꞌa dub sa gaꞌap, ndontsa usu‑yá xeꞌa ndoꞌ bexa nyoꞌo len niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Leꞌa itea be ta xgaꞌach, leꞌa gal dub wizh leꞌa ta wa igenka. No iteanak be ta ncho ngachyoꞌo, leꞌa gal dub gor leꞌa ta wa iluuka ndoꞌ xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Blaꞌach bego ta gáp naꞌ ndee, leꞌa ndoꞌ bexa nyakbeꞌena leꞌa Dios gun mas yakbeꞌena bexa. Ná leꞌa bexa na lá nyakbeꞌena, leꞌa Dios slat ta na nsak bexa nyakbeꞌena bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Weꞌe leꞌa xnaꞌa Jesús no be wit xa ulayaꞌ sa nsob xa. Parea lá yoꞌo gan ibii bexa wats xa, geal leꞌa sa wa uzhebpa kwaꞌad be men ndebe. ");
INSERT INTO zpt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Leꞌa dub men cha ndab ndoꞌ Jesús: —Leꞌa xnaꞌa ga no be wit ga ndebe tsoꞌo juer ndee, nlad bexa iniꞌí bexa ga. ");
INSERT INTO zpt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa bexa na ndoꞌón diꞌizh ten Dios no ndun xa lak ndab‑a, leꞌa bexa wa nak xnaꞌa naꞌ no wit naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ngok stub wizh leꞌa Jesús ukea ndoꞌ dub barco nsea be xmen na. Cha ndab Jesús ndoꞌ bexa: —Itakea beuna stub toꞌo nits. Cha nchaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ndalen li nchaꞌbe bexa ndoꞌ nits wa, leꞌa Jesús cha ngwadgats. Leꞌa ndoꞌ nits wa cha ulen dub mbi siꞌil, gast ngi slaꞌyoꞌo barco wa len nits. Cha uzhebpa rages nchaꞌbe bexa. ");
INSERT INTO zpt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Cha mkwaꞌan bexa Jesús, ndab bexa: —¡Mech! ¡Mech! ¡Leꞌa beuna ngi sat! Cha uban Jesús, cha uteyo xa mbi siꞌil nsea be golp ten nits wa. Cha uleas mbi no xe ute nits. ");
INSERT INTO zpt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cha ndab Jesús ndoꞌ be xmen na: —¿Maxá ta ngeꞌ ladna bega naꞌ wa zhaga? Cha mzheb bexa, no ngwanseana bexa, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Tonxá xa ndee zhaga, gast mbi nsea nits nxobgek ndoꞌ diꞌizh ten xa? ");
INSERT INTO zpt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Cha ulayaꞌ bexa stub toꞌo nits, lad ndoꞌ distrit Galilea sa nibeꞌe gezh Gadara. ");
INSERT INTO zpt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Leꞌa gor na ulaꞌ Jesús ndoꞌ barco wa, cha ulen dub xa gezh wa wats Jesús, dub xa kwenla ncho mbi bxin len ladoꞌo na. Leꞌa xa wa ni lá ndak xab na, no ni lá nyoꞌo xa ta lid xa, ndi sbeꞌen len be geꞌloꞌo ngaꞌach be men ngut ncho xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Leꞌa gor uniꞌí xa wa Jesús, cha ugeꞌ utezhat xa, cha msaxib xa ndoꞌ Jesús, cha ugeꞌ ndab mbi bxin wa: —¿Xtaꞌan ngi naꞌ nsea ugal lu zha, Jesús Xin Dios siꞌil? Leꞌa naꞌ naꞌab ndoꞌ lu lá utsaksi lu naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Li ndab ta wa geal leꞌa Jesús unibeꞌela ndoꞌ mbi bxin wa itoꞌo ladoꞌo xa wa. Leꞌa mbi bxin wa uzheꞌeb pol‑lata nibeꞌe xabgiꞌi wa. Leꞌa be men sian biaj mxi yaꞌa xa no xoꞌo xa nsea caden, ná xa nkixka ta wa. Cha ndun mbi bxin wa gan nxoꞌon xa geꞌe sa naꞌan men. ");
INSERT INTO zpt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Leꞌa Jesús cha unabdiꞌizh ndoꞌ mbi bxin wa, ndab xa: —¿Xteꞌe nsaleaꞌ lu? Leꞌa ta wa cha ukaꞌab ndab: —Naꞌ nsaleaꞌ Uzheꞌeb Kwaꞌad Xa. Li ndab ta wa geal leꞌa be mbi bxin wa kwaꞌadpa uyoꞌo len ladoꞌo xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Leꞌa be mbi bxin wa cha unab ndoꞌ Jesús lá utuꞌub Jesús be ta wa gast geꞌed uzheꞌeb lá ndap xan na. ");
INSERT INTO zpt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ndi unab be mbi bxin wa ndoꞌ Jesús ulaꞌa Jesús yoo beya len be kuch kwaꞌad ndeseayaw sa wa. Leꞌa Jesús cha msaꞌa diꞌizh li gun be ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Leꞌa be mbi bxin wa cha utoꞌo ladoꞌo xa wa, cha uyoꞌo beya len be kuch wa. Leꞌa bema cha karrel nchaꞌbe uxoꞌon gek dub weꞌa toꞌo nits. Cha ubix bema gast len nits ulaꞌyoꞌo bema, cha ngut bema. ");
INSERT INTO zpt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Leꞌa bexa nkeno be kuch wa, gor na uniꞌí bexa ta wa, cha nseaꞌbe uxoꞌon bexa. Leꞌa nes nseaꞌbe bexa mbidiꞌizh bexa ta uyoꞌo wa ndoꞌ be men gezh no ndoꞌ be men ndesea geꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Leꞌa be men wa cha utoꞌobe nchaꞌwiꞌi ná xtaꞌan ta uyoꞌo wa. Leꞌa gor ulayaꞌ bexa wats Jesús, uniꞌí bexa xabgiꞌi na utoꞌo be mbi bxin len ladoꞌo na wa nsobma wats xoꞌo Jesús. Leꞌa xa wa nakla xab na no yá naꞌanlatapa tont nak xa. Leꞌa be men wa cha mzheb. ");
INSERT INTO zpt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Leꞌa bexa na uniꞌí xteꞌe myakna xa wa cha mbidiꞌizh ta wa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Weꞌe leꞌa itea be men ncho sa nibeꞌe Gadara unab ndoꞌ Jesús ikaꞌan Jesús sa wa, leꞌa bexa uzhebpa nzheb. Leꞌa Jesús cha ukea ndoꞌ barco, cha ndiꞌizh yaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Leꞌa xa na utoꞌo be mbi bxin len ladoꞌo na wa cha unab ndoꞌ Jesús no xa yaꞌno Jesús. Parea leꞌa Jesús ndi ndab: ");
INSERT INTO zpt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Nat byaꞌ ta lid lu. Cha bidiꞌizh xteꞌe wen mbinno Dios lu. Leꞌa xa wa cha nseaꞌ, usaxan ndadiꞌizh xa ndoꞌ itea be men gezh wa xteꞌe myunyakna Jesús xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Leꞌa gor na mlanseaꞌ Jesús stub toꞌo nits, leꞌa be men uzhebpa mten ladnabe, geal leꞌa bexa itea ndenkeaꞌ ilen Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Weꞌe ulen dub xabgiꞌi nsaleaꞌ Jairo, xa nchansu niꞌi sa nzhealbe bexa judio gezh wa. Leꞌa xa wa cha usaxib ndoꞌ Jesús, cha unab xa ndoꞌ Jesús yaꞌ Jesús ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Leꞌa xa wa ndap dubtsa xingots na ncho tibtop liꞌin, parea leꞌa meꞌed wa yamer gat. Leꞌa gor na nchaꞌbe bexa nes leꞌa be men kwaꞌad ngidko Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ná leꞌa lat be men wa nchaꞌa dub xagots kweaꞌ nsak, nleꞌa xa ten idub dub tibtopla liꞌin. Leꞌa xa wa sianla biaj ngwaꞌ ndoꞌ be doctor gast mteꞌa xa itea be taꞌa ndap xa. Ná ni dub be doctor lá ngun gan yakna xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Leꞌa xa wa ubii ndi tsoꞌo Jesús, cha mgal xa ndats xab Jesús. Cha bi leꞌa gor wa leꞌa ten wa cha uleaslenla las xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Weꞌe leꞌa Jesús cha ndab: —¿Ton xa mgal xab naꞌ? Leꞌa itea be men wa ndab naꞌanpa ugal xab Jesús. Leꞌa Pedr no be ltsaꞌa xa ndab: —Mech, leꞌa be men baꞌ leꞌa ngidko go, ¿ná xtaꞌan ndab ga ton mgal xab go zha? ");
INSERT INTO zpt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Leꞌa Jesús cha ndab: —Dub menka mgal xab naꞌ, leꞌa naꞌ mgenna utoꞌo dub tuzh juers ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Leꞌa gor na uniꞌí xagots wa leꞌa Jesús mgenna ta mbin xa, cha nxis xa tant nzheb xa. Cha ubii xa msaxib xa ndoꞌ Jesús. Cha ndab xa ndoꞌ gaꞌal itea be men ná xtaꞌan mgal xa xab Jesús, no xteꞌe uxax myakna xa. ");
INSERT INTO zpt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Leꞌa Jesús cha ndab ndoꞌ xa: —Xagots, leꞌa ta na ngeꞌ ladna lu naꞌ, ta weꞌe mbin myakna lu. Nat byaꞌ, cha bten ladna lu. ");
INSERT INTO zpt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndalen li nsoꞌyadiꞌizh Jesús, ulen dub xa utoꞌo ta lid Jairo, ndab xa ndoꞌ Jairo: —Lá goꞌo ga mech baꞌ, leꞌa xin ga ngutla. ");
INSERT INTO zpt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Leꞌa gor na mbiꞌín Jesús ta wa, cha ndab xa ndoꞌ Jairo: —Lá izheb lu. Bingeatsa ladna lu naꞌ, leꞌa xin lu sbanka. ");
INSERT INTO zpt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Leꞌa gor na ulayaꞌ bexa ta lid Jairo, leꞌa Jesús cha uyoꞌo len niꞌi wa nsea Pedr no Jacob no Juan, nsea xus meꞌed nsea xnaꞌa meꞌed. Cha ni dubta men lá ulaꞌa Jesús yoꞌo len niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Leꞌa be men kwaꞌad wa ndoꞌon, no nbezhat bexa geal ngut meꞌed wa. Ná leꞌa Jesús cha ndab: —Yá lá goꞌonta bega, leꞌa meꞌed baꞌ naꞌanpa ngut, leꞌa meꞌed ga naxyats. ");
INSERT INTO zpt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Leꞌa be men wa ndi mxiꞌidno Jesús, geal leꞌa bexa uniꞌí leꞌa meꞌed wa ngutka. ");
INSERT INTO zpt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Leꞌa Jesús cha usen yaꞌa meꞌed, cha ugeꞌ ndab Jesús: —¡Meꞌed gots, goste! ");
INSERT INTO zpt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Weꞌe leꞌa gealnaban ten meꞌed wa cha myoꞌogal len ladoꞌo meꞌed, cha uxax ngwaste meꞌed. Leꞌa Jesús cha ndab ndoꞌ be usan ten meꞌed wa: —Bsaꞌa bega ta gaw med. ");
INSERT INTO zpt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Leꞌa be usan ten meꞌed wa uzhebpa ndanseanabe, ná leꞌa Jesús cha unibeꞌe naꞌan ton ndoꞌ ná gab bexa ta ngok wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Leꞌa tsoꞌo wa leꞌa Jesús mchealte isatibtop be xmen na. Cha msaꞌa xa juers ndoꞌ bexa kontuꞌub bexa be mbi bxin, no yunyakna bexa be men gizh. ");
INSERT INTO zpt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cha mtuꞌub xa bexa yaꞌuluu bexa xteꞌe nibeꞌe Dios be men, no yunyakna bexa be men gizh. ");
INSERT INTO zpt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","No ndab Jesús ndoꞌ bexa: —Ni dub taꞌa guntiꞌin bega nes lá goꞌo bega, ni bordón no ni bols no ni pan no ni med. No ni lá goꞌo bega top nes xab bega. ");
INSERT INTO zpt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tal pa niꞌi na usaꞌa bexa yoo bega dub gezh, sa weꞌetsa yoo bega gast wizh ikaꞌan bega gezh wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","No tal ncho gezh lá ulaꞌa bexa yoo bega, bkaꞌan bega gezh wa. Cha blate bega gast yakol ngwaꞌal xoꞌo bega, ta uluu leꞌa Dios ndakloo ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Leꞌa isatibtop bexa wa cha utoꞌo nchaꞌbeyadiꞌizh diꞌizh wen ten Dios itea be gezh nde gax sa wa, no myunyakna bexa be men gizh. ");
INSERT INTO zpt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Leꞌa Herodes xa nibeꞌe distrit Galilea mbiꞌín itea be ta ndun Jesús. Ná leꞌa xa ni lá iniꞌí ton xa wa, geal leꞌa ncho be men ndab leꞌa Jesús wa Juan mbangal ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","No ncho bexa ndab leꞌa xa wa profet Elí mlengal. No nchoga bexa ndab leꞌa xa wa tonla dub profet uyoꞌo xapta mbangal. ");
INSERT INTO zpt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ta weꞌe mbinbeꞌe Herodes, ndab xa: —Leꞌa naꞌ unibeꞌe myabtoꞌog gen Juan. ¿Cha tonxá xa ndee ndon naꞌ ndun sian be ta ndee zhaga? Ta weꞌe uzhebpa nlad Herodes iniꞌí Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Leꞌa ngol gor na mlaꞌnchaꞌ isatibtop be xmen Jesús, leꞌa bexa cha mbidiꞌizh itea be ta mbin bexa. Leꞌa Jesús cha mbiꞌi bexa dub sa naꞌan men, gax gezh Betsaida. ");
INSERT INTO zpt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ná leꞌa gor na uniꞌí be men pa nchaꞌa Jesús, cha no bexa usankea tsoꞌo Jesús. Leꞌa xa cha utezh bexa wa sa nsob xa. Cha mbidiꞌizh xa xteꞌe nibeꞌe Dios be men, no myunyakna xa be men gizh. ");
INSERT INTO zpt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Leꞌa ngol gor na mas uzhela, leꞌa isatibtop be xmen Jesús ubii wats xa, ndab bexa: —Gud go ndoꞌ be men baꞌ yaꞌbe bexa be ranch no be gezh nde gax baꞌ, ukwaꞌan bexa sa gadgats bexa no ta gaw bexa, leꞌa sa ndee dub sa naꞌanpa ncho men. ");
INSERT INTO zpt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Leꞌa Jesús cha ndab: —Bsaꞌa bega ta gaw bexa. Leꞌa bexa wa cha ukaꞌab ndab: —Leꞌa besa ndap sgaꞌaytsa pan nsea stoptsa mbeal. Ná leꞌa besa lá yoo gan yaꞌisiꞌi ta gaw itea be men ndee. ");
INSERT INTO zpt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Leꞌa lat itea be men wa ncho pa dub gaꞌay mil xabgiꞌi. Weꞌe leꞌa Jesús cha ndab ndoꞌ be xmen na: —Gud bega isob itol gayoꞌo gaꞌga bexa. ");
INSERT INTO zpt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cha li mte be xmen Jesús itea be men kwaꞌad wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Leꞌa Jesús cha usen isagaꞌay pan nsea itop mbeal wa, cha mwiꞌi xa gibeꞌa msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa be pan no be mbeal wa sian bleꞌa, cha msaꞌa xa‑yá ndoꞌ be xmen xa, mtseꞌa bexa‑yá ndoꞌ be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Leꞌa itea be men wa udaw ta wa gast plo mzhea bexa. Leꞌa be xmen Jesús cha mteleꞌe stibtop zhum byux ta myaꞌan sobr wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Leꞌa dub wizh leꞌa Jesús ngwaꞌyadiꞌizhno Dios dub sa naꞌan men, nabtsa be xmen xa mbiꞌi xa. Leꞌa Jesús cha unabdiꞌizh ndoꞌ bexa wa, ndab xa: —¿Xteꞌe ndab be men zha ton nak naꞌ? ");
INSERT INTO zpt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Leꞌa bexa wa cha ukaꞌab ndab: —Leꞌa ncho be men ndab leꞌa go Juan xa ulaleaꞌ be men. No ncho bexa ndab leꞌa go Elí. No nchoga bexa ndab leꞌa go stub profet uyoꞌo polta mbangal ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Leꞌa Jesús cha ndab: —¿Bego zha xteꞌe gab bega ton nak naꞌ? Weꞌe leꞌa Pedr ndab: —Leꞌa go nak Cristo, xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Leꞌa Jesús unibeꞌe ndab ndoꞌ bexa: —Naꞌan ton ndoꞌ ná gudiꞌizh bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","No ndab Jesús: —Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, nsabndoꞌka sian gealkweaꞌ iní. Leꞌa bexa gox nsak no be uleꞌay nibeꞌe no be mech ten ley uxelad naꞌ, cha gat naꞌ. Cha gal wizh yon leꞌa naꞌ ibangal. ");
INSERT INTO zpt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","No ndab Jesús ndoꞌ bexa: —Tal ton nlad isankea tsoꞌo naꞌ, nsabndoꞌ ulaꞌa xa itea be ta nlad xa, cha goꞌo xa cruz ten xa itea wizh, cha isankea xa tsoꞌo naꞌ guniꞌi xtaꞌan gunno be men xa. ");
INSERT INTO zpt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Leꞌa tal ton ukwaꞌan xteꞌe wen yoo xa, leꞌa xa wa ndi gun perdid gealnaban ten na ndoꞌ Dios. Ná leꞌa tal ton gat ke ten naꞌ, leꞌa xa wa gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tal leꞌa dub men ndap itea be ta ncho ndoꞌ gizhliyo ndee, cha gat xa, leꞌa iteanak be ta wa ta naꞌan xtiꞌin. ");
INSERT INTO zpt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Leꞌa tal ton idono ladna naꞌ no diꞌizh ten naꞌ, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, no idono ladna xa wa, gal wizh ilenno naꞌ xeꞌa siꞌil ten Dios Tad no be angel ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Leꞌa naꞌ gáp ndoꞌ bega leꞌa ncho bexa nde ndee naꞌanpa cha gat gast iniꞌíka xa gal tiemp inibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Leꞌa ngol pa stub sman tsoꞌo na li mbidiꞌizh Jesús ta wa, cha mbiꞌi xa Pedr no Juan no Jacob, ukea bexa dub bet sa ndaꞌyadiꞌizhno Jesús Dios. ");
INSERT INTO zpt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Leꞌa gor na li nsoꞌyadiꞌizhno xa Dios, leꞌa xa cha mtixndoꞌ ndoꞌ gaꞌal bexa wa. Leꞌa xab xa cha mnaꞌ mbe, ndon nlaꞌbealꞌ‑a. ");
INSERT INTO zpt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Zha leꞌa sa wa cha mlundoꞌ top xabgiꞌi ndeyadiꞌizhno Jesús, leꞌa ta wa Moisés no Elí. ");
INSERT INTO zpt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Leꞌa bexa wa nde tlaw dub xeꞌa uzheꞌeb chul, ndeyadiꞌizhno bexa Jesús ná xteꞌe gat Jesús gezh Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Leꞌa Pedr no itop ltsaꞌa xa uzhebpa nyoxkaꞌal na, ná leꞌa bexa mxik lá ngadgats. Cha uniꞌí bexa xteꞌeta nlaꞌbealꞌ wats Jesús, no uniꞌí bexa top xabgiꞌi wa nde wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ngol gor na yá nseaꞌbe sa sit Moisés nsea Elí wats Jesús, leꞌa Pedr cha ndab ndoꞌ Jesús: —Mech, uzhebpa wen ndebe beuna sa ndee. Gundeꞌe besa chon ramad: dub‑a na ten go, leꞌa stub‑a na ten Moisés, leꞌa stub‑a na ten Elí. Ná leꞌa Pedr ni lá iniꞌí xtaꞌan ndab. ");
INSERT INTO zpt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bi li nsoꞌyab Pedr ta wa, zha leꞌa dub xkaw ulaꞌla sa nde bexa wa, cha mzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Leꞌa lat xkaw wa mgen ti Dios ndab: —Leꞌa ta ndee Xiꞌín naꞌ, xa na mti naꞌ. Bsakyoꞌón bega ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Leꞌa gor na uleas ti Dios wa, leꞌa Jesús nabla nsoꞌ. Leꞌa bexa wa lá ngudiꞌizh ta li uniꞌí bexa wa dub ndeꞌep ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Leꞌa ngol stubtsa wizh gor na nchaꞌlayoꞌo bexa bet wa, leꞌa kwaꞌad be men utoꞌo, nchaꞌbe ucheꞌalndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Leꞌa dub xabgiꞌi nsea lat be men wa ugeꞌ ndab: —Mech, leꞌa naꞌ naꞌab ndoꞌ go iwiꞌi go ndoꞌ xmeꞌed naꞌ, leꞌa meꞌed ga dubkama ndap naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Leꞌa gor na nsen dub mbi bxin med, cha nbezhat med, no uzheꞌeb nteꞌal med, no nlen bchiꞌin toꞌo med. Uzheꞌeb xela ndanno ta wa med, no kwenpa leꞌa zha nlaꞌa ta wa med. ");
INSERT INTO zpt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Leꞌa naꞌ unaꞌabla ndoꞌ be xmen go kontuꞌub bexa mbi bxin wa, parea leꞌa bexa lá ngun gan. ");
INSERT INTO zpt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Leꞌa Jesús cha ukaꞌab ndab: —¡Uzhebpa ngud nak bego ncho nat, no ndidotsa ngeꞌ ladna bega Dios! ¿Ploxá tiemp yoꞌo naꞌ lat bega zhaga? ¿Sta ploxá tiemp uxik naꞌ ndoꞌ bega zhaga? Cha ndab Jesús ndoꞌ xabgiꞌi wa: —Utseano xmeꞌed lu baꞌ sa ndee. ");
INSERT INTO zpt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Leꞌa gor na nchaꞌbii gax meꞌed wa, leꞌa mbi bxin wa cha udingegal meꞌed ndoꞌ yo, no uzhebpa ngot bixte meꞌed. Leꞌa Jesús cha uteyo mbi bxin wa, cha myunyakna xa meꞌed wa. Cha myun Jesús cuent meꞌed wa ndoꞌ xus med. ");
INSERT INTO zpt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Leꞌa itea be men wa ndanseanabe gor uniꞌí bexa xteꞌe juert nak Dios. Ndalen li ndeyanseana be men ndoꞌ ta mbin Jesús wa, leꞌa xa cha ndab ndoꞌ be xmen na: ");
INSERT INTO zpt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Uzhebpa blaꞌach bega ta gáp naꞌ ndee. Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yak cuent ndoꞌ yaꞌa be men. ");
INSERT INTO zpt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Parea leꞌa be xmen Jesús ni lá yakbeꞌena ta li ndab xa wa, geal leꞌa Dios biseata ulaꞌa yakbeꞌena bexa‑yá. Ná leꞌa bexa nzhebta inabdiꞌizh ndoꞌ Jesús xteꞌe gab ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Weꞌe leꞌa be xmen Jesús cha ndeyadiꞌizhbe ná ton mas nsak lat bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Leꞌa Jesús mgenna xtaꞌan ndanbeꞌe bexa, cha usen xa dub meꞌed, cha msoꞌ xa meꞌed wats xa. ");
INSERT INTO zpt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Cha ndab xa ndoꞌ bexa: —Leꞌa tal ton dub xmen naꞌ utsin gak xa ndoꞌ dub meꞌed, leꞌa xa wa cuentkata ndoꞌ naꞌ utsin nak. Leꞌa xa na utsin nak ndoꞌ naꞌ wa, leꞌa xa wa utsinkaga nak ndoꞌ xa na mtuꞌub naꞌ. Leꞌa xa na uxee nsak lat bega wa, leꞌa xa wa ndon leꞌa xa nsak ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Leꞌa Juan cha ndab ndoꞌ Jesús: —Mech, leꞌa besa uniꞌí dub men ndantiꞌin leaꞌ go ngontuꞌub xa be mbi bxin. Leꞌa besa cha mka guntiꞌinta xa leaꞌ ga, geal leꞌa xa naꞌanpa no nkeseano beuna. ");
INSERT INTO zpt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Leꞌa Jesús cha ndab: —Lá uka bega gun xa ta wa, leꞌa tal ton naꞌanpa ndakloo ndoꞌ beuna, leꞌa xa wa dubtsa nak no beuna. ");
INSERT INTO zpt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Leꞌa zha na yamer ngol zha yaꞌ Jesús gibeꞌa stub biaj, leꞌa xa dubtsa ulo ladna yaꞌ Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cha mtuꞌub xa pla xmen xa nchaꞌbe nedlabe. Leꞌa bexa wa cha ulayaꞌ dub gezh ten distrit Samaria, mkwaꞌan bexa sa yoo Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ná leꞌa bexa gezh wa lá usaꞌa sa yoo xa, leꞌa bexa uniꞌí leꞌa Jesús nchaꞌa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Leꞌa Jacob no Juan top xmen Jesús mbiꞌín ta wa, cha ndab bexa ndoꞌ Jesús: —Señor, ¿nlad ga inab besa ndoꞌ Dios ulaꞌ bealꞌ gibeꞌa utsoꞌol‑a be men baꞌ lak mbin Elí zha? ");
INSERT INTO zpt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Leꞌa Jesús mgeaksoꞌ mwiꞌi ndoꞌ bexa. Cha uteyo Jesús bexa, ndab xa: —Bego ni lá iniꞌí ton ngo gek bega li ndab bega. ");
INSERT INTO zpt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, naꞌanpa ndalyut be men, leꞌa naꞌ ndi ndalusa gealnaban ten bexa. Cha nchaꞌbe bexa stubga gezh. ");
INSERT INTO zpt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Leꞌa gor na li nchaꞌbe bexa nes, leꞌa dub men ndab ndoꞌ Jesús: —Señor, leꞌa naꞌ no isankea tsoꞌo go guniꞌi pa yaꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Leꞌa Jesús cha ndab ndoꞌ xa wa: —Leꞌa be mbeas ndap geꞌed nyoꞌo na, no leꞌa be migin ndap xuꞌun ten na, parea leꞌa Xa Myak Men Ndoꞌ Gizhliyo lá ndap sa uneꞌe xa. ");
INSERT INTO zpt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Cha ndab Jesús ndoꞌ stub xa: —Usankea tsoꞌo naꞌ. Leꞌa xa wa cha ndab: —Señor, blaꞌa ga ned yaꞌukaꞌach naꞌ xus naꞌ. Weꞌeta isankea naꞌ tsoꞌo ga. ");
INSERT INTO zpt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Leꞌa Jesús cha ndab: —Blaꞌa leꞌa bexa lá ndap gealnaban ndoꞌ Dios ukaꞌach ltsaꞌa ngut na. Ná leꞌa lu ndi waꞌyab ndoꞌ be men xteꞌe inibeꞌe Dios bexa. ");
INSERT INTO zpt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Leꞌa stub xa cha ndabgal ndoꞌ Jesús: —Señor, leꞌa naꞌ no isankea tsoꞌo ga, parea blaꞌa ga ned nseayáp naꞌ‑yá ndoꞌ bexa ta lid naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Leꞌa Jesús cha ndab: —Tal ton nlad isankea tsoꞌo naꞌ, ná leꞌa xa ndi ned stub ta xaꞌaga gun, leꞌa xa wa lá isuꞌu yoo lat be men nibeꞌe Dios. Leꞌa xa wa nak cuent dub xa ndun tiꞌin, nsén xa yaꞌa yarad, cha nwiꞌi xa ndi tsoꞌo. ");
INSERT INTO zpt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsoꞌo wa leꞌa Jesús mti stub chon gaꞌal ncho tiꞌi be men, mtuꞌub xa bexa wa top gaꞌga bexa, yaꞌbe nedla bexa itea be gezh yaꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ndab Jesús ndoꞌ bexa wa: —Ncho kwaꞌad be men gol goꞌón diꞌizh ten Dios, nak bexa cuent sianpa be taꞌa iganleꞌe, ná leꞌa bexa ndun tiꞌin wa platsa. Ta weꞌe unab bega ndoꞌ Dios Xwan tiꞌin, utuꞌubta xa bexa gudiꞌizh diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Waꞌbe bega nat, leꞌa naꞌ ntuꞌub bega yaꞌbe bega cuentta be borreg nde lat be mbee. ");
INSERT INTO zpt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lá goꞌo bega bols ncho med, no ni stub bols ten bega, no ni stub nes ndab bega. No naꞌanpa gaisoꞌ bega nes inidiꞌizh bega ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Leꞌa gor na yoo bega len dub niꞌi, cha gab bega ndoꞌ men wa: “Leꞌa Dios gun wen yoo ladna bega.” ");
INSERT INTO zpt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tal leꞌa xa ncho sa wa utsin ikaꞌab ndoꞌ bega, weꞌe leꞌa Dios gun wen yoo ladna xa wa. Ná tal leꞌa xa naꞌanpa utsin ikaꞌab, leꞌa xa naꞌanpa wen yoo ladna. ");
INSERT INTO zpt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Leꞌa sa na utsin ikaꞌab bexa ndoꞌ bega, sa weꞌetsa yoo bega. Lá ido ladna bega gaw bega no goo bega ta usaꞌa xa, leꞌa dub xa ndun tiꞌin nsabndoꞌ yax ten na. No naꞌanpa ucheꞌa bega sa yoo bega. ");
INSERT INTO zpt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Leꞌa gor na ilayaꞌ bega dub gezh sa utsin nak men ndoꞌ bega, gaw bega ta nsaꞌa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","No byunyakna bega bexa gizh ncho gezh wa, cha gud bega ndoꞌ bexa leꞌa tiemp inibeꞌe Dios ladoꞌo be men yá gax nak. ");
INSERT INTO zpt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ná tal ncho gezh naꞌanpa utsin nak bexa ndoꞌ bega, bkaꞌan bega sa wa, cha gud bega ndoꞌ bexa wa: ");
INSERT INTO zpt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Gast yakol ngwaꞌal xoꞌo besa gezh ndee ulate besa, ta nluu leꞌa Dios utsaksi bega. Parea nlad besa iniꞌí bega ta ndee: leꞌa tiemp inibeꞌe Dios ladoꞌo be men yá gaxla nak.” ");
INSERT INTO zpt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Leꞌa naꞌ gáp leꞌa gal wizh gab Dios ná ton ndap ke, leꞌa bexa gezh wa mas gealkweaꞌ iniꞌí ndoꞌ bexa uyoꞌo gezh Sodoma. ");
INSERT INTO zpt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Proꞌob bego xa gezh Corazín no bego gezh Betsaida! Leꞌa tal be uyon mbin naꞌ lat bego wa ndi ngun naꞌ gezh Tiro no Sidón, polta ngokla bexa lad nagats, no usobla bexa ndoꞌ diꞌ, ta uluu leꞌa bexa mlaꞌala be ta ugap nak bexa. ");
INSERT INTO zpt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ta weꞌe leꞌa gal zha na gab Dios ná ton ndap ke, leꞌa bego xa gezh Corazín no bego gezh Betsaida mas uzheꞌeb iniꞌí gealkweaꞌ ndoꞌ bexa Tiro no Sidón wa. ");
INSERT INTO zpt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","No bego xa gezh Capernaum, ¿ndanbeꞌe bega zha gibeꞌa yaꞌ bega? Leꞌa Dios ndi utsaꞌab bega infierno. ");
INSERT INTO zpt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cha ndab Jesús ndoꞌ be xmen na: —Leꞌa tal ton isakyoꞌón be ta ndab bega wa, leꞌa xa wa isakyoꞌón diꞌizh ten naꞌ. Ná leꞌa tal ton uxelad bega, leꞌa xa wa no naꞌ ndee nxelad. Leꞌa xa na uxelad naꞌ wa, leꞌa xa wa no nxelad Dios xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Leꞌa gor na mlaꞌnchaꞌ isachon gaꞌal ncho tiꞌi bexa wa, leꞌa bexa uzhebpa mten ladna ndab ndoꞌ Jesús: —Señor, gast be mbi bxin nxobgek ndoꞌ besa gor ndantiꞌin besa leaꞌ go. ");
INSERT INTO zpt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Leꞌa Jesús cha ndab: —Leꞌa naꞌ uní leꞌa maxuꞌu utoꞌo gaꞌap baꞌ ulayat ndoꞌ yo cuent bealꞌ usiꞌi. ");
INSERT INTO zpt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Leꞌa naꞌ nsa juers ndoꞌ bego isoꞌ bega tsoꞌo mbeꞌal no nix, no mas gap bega juers ndoꞌ maxuꞌu. Ni dub taꞌa wa lá gun gan xteꞌe gunno bega. ");
INSERT INTO zpt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Parea lá iten ladna bega xteꞌe nxobgek be mbi bxin ndoꞌ bega, ndi bten ladna bega leꞌa leaꞌ bega nkeala gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Weꞌe leꞌa Espíritu ten Dios cha mbin mas nten ladna Jesús, cha ndab Jesús ndoꞌ Dios: —Nsa naꞌ xno ndoꞌ go, Xus naꞌ, go Xa Nibeꞌe gibeꞌa no gizhliyo, leꞌa go lá ulaꞌa leꞌa bexa ndák wa no bexa ntsid wa yakbeꞌena be ta ndee. Ndi mluu ga‑yá ndoꞌ bexa naꞌanpa ndák, bexa nak cuent be meꞌed. Li ngok‑a Xus naꞌ, geal leꞌa go li nlad gak‑a. ");
INSERT INTO zpt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Cha ndab Jesús ndoꞌ be men nde sa wa: —Leꞌa Dios Xus naꞌ msaꞌa itea be taꞌa ndoꞌ naꞌ. No naꞌan ton nchandoꞌ naꞌ, nabtsa Xus naꞌ nchandoꞌ naꞌ. No naꞌan ton nchandoꞌ Dios Xus naꞌ, nabtsa naꞌ xa nak Xin xa nchandoꞌ xa, no bexa nlad naꞌ uluꞌu naꞌ ná ton nak Dios ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Cha mwiꞌi Jesús ndoꞌ be xmen na, cha ndab xa ndoꞌ nabtsa bexa wa: —Dios ndun wen nyo ladna be men na no uniꞌí ltsaꞌa ta uniꞌí bega nat. ");
INSERT INTO zpt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Leꞌa naꞌ gáp leꞌa kwaꞌad bexa mbidiꞌizh sakndoꞌ Dios no bexa nibeꞌe polta, nlad bexa iniꞌí bexa ltsaꞌa ta uniꞌí bega nat, ná leꞌa bexa lá iniꞌí ta wa. No nlad bexa goꞌón bexa ltsaꞌa ta ndoꞌón bega nat, ná leꞌa bexa lá ngoꞌón ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Weꞌe leꞌa dub mech ten ley mbin preb Jesús, ndab xa: —Mech, ¿xteꞌe gun naꞌ ndontsa gap naꞌ gealnaban ndoꞌ Dios, ta nunk lá idub? ");
INSERT INTO zpt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Leꞌa Jesús cha ukaꞌab ndab: —¿Xteꞌe nkeaniꞌi ley ten Dios? ¿Xteꞌe nyakbeꞌena lu ta wa? ");
INSERT INTO zpt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Leꞌa mech ten ley wa cha ndab: —Leꞌa ley wa ndab: “Wankea Dios Xa Nibeꞌe idub ncho ladna ladoꞌo lu, no idub gealnaban ten lu, no idub juers ten lu, no idub lak ndanbeꞌe lu.” No ndab‑a: “Bkweaꞌ ladna lu be ltsaꞌa lu lakkata lu.” ");
INSERT INTO zpt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Leꞌa Jesús cha ndab: —Leꞌaka ukaꞌab lu. Nat bin be ta wa, leꞌa lu sapka gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ná leꞌa mech wa nlad wen yaꞌan ndoꞌ be men, ta weꞌe unabdiꞌizhgal xa ndoꞌ Jesús, ndab xa: —¿Ton nak ltsaꞌa naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa dub xabgiꞌi utoꞌo Jerusalén nchaꞌa xa Jericó. Leꞌa nes nchaꞌa xa wa, mlat be waꞌan itea be ta noꞌo xa no gast xab xa. No udin bexa xa, cha mlaugix bexa xa cuent dub xa ngut. ");
INSERT INTO zpt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngol gor leꞌa sa wa nseatid dub uleꞌay ten bexa judio. Leꞌa xa wa cha uniꞌí nax men wa, cha gandidtsa utid xa. ");
INSERT INTO zpt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tsoꞌo wa nseatid dub xa levita sa wa. Leꞌa gor uniꞌí xa xa nax wa, cha gandidgal utid xa. ");
INSERT INTO zpt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Leꞌa tsoꞌo wa nseatidga dub xa gezh Samaria. Leꞌa gor uniꞌí xa men wa, cha mlats ladna xa xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Cha ubii xa wats xa wa, cha mbin ramed xa xa aceit no vin. No mtixko xa lad be sa gizh wa. Cha mxoꞌob xa xa wa tsoꞌo man ten xa. Cha mbiꞌi xa xa dub niꞌi sa nteꞌe bexa cuart, cha mlaꞌach xa xa sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ngot xeꞌa wa gor na yá nseaꞌ xa Samaria wa, leꞌa xa cha uloꞌo top med nsak, cha msaꞌa xa‑yá ukaꞌa xwan niꞌi wa. Cha ndab xa ndoꞌ xa wa: “Blaꞌach ga xa ndee. Leꞌa itea be ta gun gast ga wa, leꞌa naꞌ skixka ta wa wizh yach naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cha ndab Jesús ndoꞌ mech ten ley wa: —¿Xteꞌe nsak lu zha? Ndoꞌ yon bexa wa, ¿ton nak ltsaꞌa na xa na ulawaꞌan wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Leꞌa mech ten ley wa cha ukaꞌab ndab: —Xa na mlats ladna xa wa. Leꞌa Jesús cha ndab: —Nat byaꞌ, cha no lu li bin. ");
INSERT INTO zpt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Leꞌa nes nchaꞌa Jesús Jerusalén, cha ulayaꞌ xa dub gezh tuzh. Weꞌe leꞌa dub xagots nsaleaꞌ Mart utezh xa ta lid na. ");
INSERT INTO zpt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Leꞌa xa wa ndap dub beal na nsaleaꞌ Marí. Leꞌa gor na nsob Jesús len niꞌi, leꞌa Marí wa nsob ulaꞌach xtaꞌan ndadiꞌizh Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Leꞌa Mart ndi nyuꞌno ladna sian be tiꞌin ten na. Cha ubii xa wats Jesús, ndab xa: —Señor, ¿lá naꞌ go zha leꞌa beal naꞌ nlaꞌa nab naꞌ ndun itea be tiꞌin ndee? Gud go ndoꞌ xa no gakno naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Leꞌa Jesús cha ukaꞌab ndab: —Mart, Mart, uzhebpa nyuꞌno ladna lu sian be taꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ncho dub taꞌa ndon leꞌa nsak. Leꞌa Marí ndee mti ta nsak wa, no ni lá gáp naꞌ ndoꞌ xa lá ulaꞌachta xa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Leꞌa dub wizh leꞌa Jesús ngwaꞌyadiꞌizhno Dios. Leꞌa gor na mtayadiꞌizh xa leꞌa dub xmen xa cha ndab ndoꞌ xa: —Señor, bluu ga besa xteꞌe gudiꞌizhno besa Dios, lak mluu Juan be xmen na. ");
INSERT INTO zpt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa gor na gudiꞌizhno bega Dios, lndeꞌe gab bega: Go Dios Xus besa, go nsob gibeꞌa, yankea be men go. No uxax ilen tiemp inibeꞌe go be men nde ndoꞌ gizhliyo. Gak ta nlad go ndoꞌ gizhliyo, lak ndak‑a gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nab besa usaꞌa go ta gaw besa wizh nat, lak nkiꞌin besa‑yá itea wizh. ");
INSERT INTO zpt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bingeꞌ ladna go be ke ten besa, lak ndangeꞌ ladna besa ndoꞌ be men ugap ndanno besa. Lá ulaꞌa go gailaꞌ besa ndoꞌ ta ugap, ndi uloꞌo ga besa ndoꞌ itea be ta ugap. ");
INSERT INTO zpt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","No ndab Jesús ndoꞌ bexa: —Tal leꞌa bega yaꞌ ta lid dub amig ten bega utol teꞌal, cha gab bega: “Amig, bsaꞌa chontsa pan ika naꞌ, ");
INSERT INTO zpt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","leꞌa stub amig ten naꞌ ulansea ta lid naꞌ, leꞌa naꞌ lá ndap ta gaw xa wa.” ");
INSERT INTO zpt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Leꞌa xa wa cha gab: “Lá gunta lu ruid. Leꞌa toꞌo lid naꞌ nsoꞌnyawla. No be xmeꞌed naꞌ ndeyatsla wats naꞌ. Leꞌa naꞌ lá yoo gan gaste usa ta nlad lu wa.” ");
INSERT INTO zpt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Parea leꞌa naꞌ gáp ndoꞌ bega leꞌa xa wa gasteka, usaꞌa xa itea be ta nkiꞌin bega ndontsa yá lá gunta bega ruid, naꞌanpa ta na amigtsa ten xa bega. ");
INSERT INTO zpt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Leꞌa naꞌ gáp ndoꞌ bega unab bega ta nkiꞌin bega ndoꞌ Dios, leꞌa Dios saꞌaka‑yá. Bkwaꞌan bega Dios, leꞌa bega szhealka xa. Utezh bega Dios, leꞌa Dios saknoka bega. ");
INSERT INTO zpt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Leꞌa itea bexa na nab ta nkiꞌin na, leꞌa Dios nsaꞌaka‑yá. Leꞌa itea bexa na nkwaꞌan Dios, leꞌa bexa nzhealka xa. Leꞌa itea bexa na nbezh Dios, leꞌa Dios ndaknoka xa. ");
INSERT INTO zpt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Leꞌa bego na ndap meꞌed, tal leꞌa dub xmeꞌed bega inab dub pan, ¿cha saꞌa bega ndi dub geꞌ ndoꞌ meꞌed zha? No tal leꞌa xmeꞌed bega inab dub mbeal, ¿cha saꞌa bega ndi dub mbeꞌal ndoꞌ meꞌed zha? ");
INSERT INTO zpt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","No tal leꞌa xmeꞌed bega inab dub nguꞌu, ¿cha saꞌa bega ndi dub nix zha? ");
INSERT INTO zpt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Leꞌa bego bexa ugap, ná sbeꞌen be ta wen nsaꞌa bega ndoꞌ be xin bega, ¿matagal Dios Xus beuna nsob gibeꞌa usaꞌa Espíritu ten na ndoꞌ bexa inab‑a? ");
INSERT INTO zpt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Leꞌa dub wizh leꞌa Jesús ulantuꞌub dub mbi bxin mbin mud dub xabgiꞌi. Leꞌa gor na utoꞌo mbi bxin wa, leꞌa xa mud wa usaxan ndadiꞌizhla. Leꞌa be men ngwanseanabe. ");
INSERT INTO zpt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ná leꞌa ncho be men ndab: —Leꞌa Jesús ngontuꞌub be mbi bxin juers ten Beelzebú, maxuꞌu nibeꞌe be mbi bxin. ");
INSERT INTO zpt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","No ncho xa mbin preb Jesús ndab bexa gun Jesús dub ta uluu ton nak xa. ");
INSERT INTO zpt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Parea leꞌa Jesús mgenna xteꞌe ndanbeꞌe bexa wa, cha ndab Jesús: —Tal leꞌa be xmen dub xa nibeꞌe iteltsaꞌabe, cha bi leꞌakaga bexa kuyo, weꞌe leꞌa bexa wa naꞌantapa gak juertbe. No tal leꞌa be men ncho len dub niꞌi liga leꞌakaga kuyobe, leꞌa juers ten bexa idub. ");
INSERT INTO zpt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Leꞌa bego ndab leꞌa naꞌ ngontuꞌub be bxin juers ten Beelzebú. Parea tal leꞌa maxuꞌu kuyono leꞌaka be mbi bxin ten na, weꞌe leꞌa maxuꞌu wa no be mbi bxin wa iteltsaꞌabe, cha idub juers ten maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ndab bega leꞌa naꞌ ndee ngontuꞌub be mbi bxin juers ten Beelzebú. ¿Ná ton nsaꞌa juers ngontuꞌub be xmen bega be mbi bxin wa zha? Leꞌa naꞌ gáp leꞌa ta na ndun be xmen bega wa leꞌa nluu leꞌa bega naꞌanpa utsin ndun. ");
INSERT INTO zpt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ná leꞌa naꞌ ndee ngontuꞌub be mbi bxin juers ten Espíritu ten Dios, ta na nluu leꞌa Dios yá ngol tiemp inibeꞌe be men ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Leꞌa tal leꞌa dub xabgiꞌi juert noꞌo spad nlaꞌach xa ta lid xa, leꞌa itea taꞌa nlaꞌach xa segurka ndebe. ");
INSERT INTO zpt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Parea tal leꞌa stubga xa mas juert ilen ta lid xa wa, cha gun xa gan ndoꞌ xa wa, leꞌa xa wa slat spad na ngeꞌ ladna xa wa. Cha slat xa be ta ndap xa ned wa no stseꞌa xa‑yá ndoꞌ be ltsaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Leꞌa tal ton lá nsak ladna ta ndun naꞌ, leꞌa xa wa ndi ndakloo ndoꞌ naꞌ. No liga leꞌa tal ton bexa naꞌanpa ndakno naꞌ nyakjunt be men ndoꞌ Dios, leꞌa xa wa ndi ndun nsasit be men wats Dios. ");
INSERT INTO zpt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Leꞌa gor na ntoꞌo dub mbi bxin len ladoꞌo dub men, leꞌa mbi bxin wa cha nchaꞌa sa naꞌan men nchaꞌkwaꞌan ná pa yoo na. Ná leꞌa gor na lá izheal pa yoo mbi bxin wa, cha ndab ta wa: “Nsea naꞌ leꞌaka ta lid naꞌ sa utoꞌo naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Leꞌa gor na mtanseaꞌ mbi bxin wa leꞌa ladoꞌo men wa cuent dub niꞌi ndon umbiꞌi nak no chul nsaxkwaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Weꞌe leꞌa mbi bxin wa cha nchaꞌgiꞌi stub sgaꞌad be mbi bxin mas ugap nak. Leꞌa itea be mbi bxin wa cha yoo ladoꞌo men wa. Cha mas juert yoo xa wa ndoꞌ lak zha ned wa. ");
INSERT INTO zpt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Leꞌa gor na li nsoꞌyadiꞌizh Jesús ta wa, leꞌa dub xagots nsoꞌ lat be men wa ugeꞌ ndab ndoꞌ Jesús: —¡Uzhebpa wen yoo ladna xa ngop go, no mbingaꞌal xa go! ");
INSERT INTO zpt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ná leꞌa Jesús cha ndi ndab: —Mas uzheꞌeb wen yoo ladna bexa ndoꞌón diꞌizh ten Dios, no ndun bexa lak ndab‑a. ");
INSERT INTO zpt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Leꞌa be men wa mas kwaꞌad nsayakjunt wats Jesús, cha ndab Jesús ndoꞌ bexa: —Leꞌa be men ncho nat uzhebpa be men ugap. Nab bega gun naꞌ dub ta uluu ton nak naꞌ, parea leꞌa naꞌ lá gun ta nab bega wa. Ndi iniꞌítsa bega leꞌa naꞌ itiꞌid ltsaꞌa ta utid Jonás. ");
INSERT INTO zpt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Leꞌa ta utid Jonás wa mluu leꞌa Dios leꞌaka mtuꞌub Jonás gezh Nínive. No liga leꞌa ta itiꞌid naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, uluu ndoꞌ be men ncho nat leꞌa naꞌ Dioska mtuꞌub. ");
INSERT INTO zpt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","’Leꞌa gal wizh na gab Dios ná ton ndap ke, leꞌa xagots unibeꞌe be men lad sur isoꞌ, gab xa leꞌa bego ndapka ke. Leꞌa xagots wa uzhebpa sit utoꞌo ndontsa mbidyoꞌón xa ta mbidiꞌizh Salomón, be ta uzheꞌeb ngók xa. Leꞌa sa ndee nsoꞌ dub xa mas nsak ndoꞌ Salomón wa, ná leꞌa bego lá nsakyoꞌón ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Leꞌa bexa Nínive no kwe ndoꞌ Dios wizh na gab Dios ná ton ndap ke, gab bexa leꞌa be men ncho nat ndee ugap nak. Leꞌa bexa Nínive mlaꞌa be ta ugap nak bexa gor na mbiꞌín bexa ta mbidiꞌizh Jonás. Ná leꞌa nat leꞌa dub xa mas nsak ndoꞌ Jonás nsoꞌ sa ndee. ");
INSERT INTO zpt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Leꞌa naꞌan ton kich dub xeꞌa, cha usob xa‑yá dub sa xgaꞌach. No ni len dub caj lá usob xa‑yá. Ndi gaꞌap usob xa‑yá, ndontsa leꞌa be men nyote len niꞌi wa inaꞌ xeꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Leꞌa ngusndoꞌ dub men leꞌa nak xeꞌa ten xa. Tal leꞌa ngusndoꞌ bega ta wen, leꞌa bega nkesea ndoꞌ xeꞌa. Ná tal leꞌa ngusndoꞌ bega naꞌanpa ta wen, leꞌa bega ndi nkesea sa ukaw. ");
INSERT INTO zpt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Blaꞌach bega leꞌa len ladoꞌo bega nchoka xeꞌa ten Dios, naꞌanpa sa ukaw gak‑a. ");
INSERT INTO zpt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tal leꞌa len ladoꞌo bega idubka ncho xeꞌa ten Dios, leꞌa bega ni dub tuzh naꞌanpa ncho sa ukaw. Weꞌe leꞌa bega iniꞌí itea be taꞌa, cuent gor na nsu xeꞌa sa nsoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Leꞌa gor na mtayadiꞌizh Jesús ndoꞌ be men, leꞌa dub xa fariseo cha unab ndoꞌ Jesús yaꞌdaw Jesús ta lid xa. Cha uyoꞌo Jesús, cha usob xa ndoꞌ mes. ");
INSERT INTO zpt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parea leꞌa Jesús naꞌanpa unaꞌa lak nibeꞌe costumbr ten bexa fariseo. Leꞌa gor na uniꞌí xa fariseo ta wa, cha ngwanseana xa. ");
INSERT INTO zpt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Leꞌa Jesús cha ndab: —Leꞌa bego xa fariseo uzhebpa nyuꞌ ladna yat tsoꞌo vas nsea plat, parea leꞌa len ladoꞌo bega uzhebpa ugap nak, no uzhebpa nsaꞌab ladna bega be taꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Bego xa lá nsakyoꞌón! ¿Lá iniꞌí bega zha leꞌa Dios xa na mbindeꞌe idub las men, leꞌa xa wa leꞌaka nsaꞌa gealnaban ten be men? ");
INSERT INTO zpt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bsaꞌa bega be ta gakno bexa uban nak, weꞌe umbiꞌi gak bega ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Proꞌob bego xa fariseo! Leꞌaka nak nsaꞌa bega dub gen byonxtil lat dub tiꞌi gen‑a uxen bega, no liga ndanno bega rud no iteata be ta xgeꞌa ndas bega. Parea naꞌanpa utsin nak bega ndoꞌ be men, no ni lá ndankea bega Dios. Be ta wen ndee nsabndoꞌ gun bega, no usaꞌaka bega be ta wa lakka ndun bega nat. ");
INSERT INTO zpt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Proꞌob bego xa fariseo! Leꞌa bega nti be sa mas nsak isob bega len be niꞌi sa nzhealbe beuna xa judio. No nlad bega utsin inidiꞌizh be men ndoꞌ bega be ndoꞌ xgeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Proꞌob bego mech ten ley no bexa fariseo! Leꞌa bega nluu cuentta xa wen, ná bega xa ugap. Leꞌa bego nak cuent dub baꞌa ni lá nluu. Leꞌa be men nsea tsoꞌo‑yá, parea ni lá iniꞌí bexa xtaꞌan‑a. ");
INSERT INTO zpt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Leꞌa dub mech ten ley ukaꞌab ndab ndoꞌ Jesús: —Mech, leꞌa go no ndoꞌ besa kweaꞌ uníꞌi. ");
INSERT INTO zpt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Leꞌa Jesús cha ndab: —¡Proꞌob bego mech ten ley! Leꞌa be ta sian nluu bega wa cuent dub yoꞌo kweꞌa ni lá uxik be men goꞌo‑yá. Ná leꞌa bega ni dub ngutsyaꞌa na lá ndakno bexa goꞌo bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Proꞌob bego! Leꞌa be usan gox polta ten bega mbit bexa ndadiꞌizh sakndoꞌ Dios. Ná nat leꞌa bega ndi ndandeꞌe ta chul nsob sa mgaꞌach bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Leꞌa ta wa nluu leꞌa bega dubtsaka nak no be usan gox polta ten bega. Leꞌa bexa wa mbit bexa mbidiꞌizh sakndoꞌ Dios, ná nat leꞌa bega nsaxkwaꞌaga baꞌa ten bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ta weꞌe lndeꞌe ndab Dios: “Leꞌa naꞌ utuꞌubkata bexa ndadiꞌizh sakndoꞌ naꞌ, no bexa ndadiꞌizh diꞌizh ten naꞌ. Leꞌa ncho bexa utuꞌub naꞌ wa leꞌa be men gut xa, no ncho bexa leꞌa be men ugap gunno xa.” ");
INSERT INTO zpt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ta weꞌe leꞌa bego ncho tiemp nat gap ke ten itea bexa ugap li ndut bexa mbidiꞌizh sakndoꞌ Dios wa gast idub zha utexanta gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Leꞌa ta wa gast zha ngut Abel no gast zha ngut Zacarías, mbit be men xa wa wats altar dub lad wats niꞌi ten Dios. Leꞌa naꞌ gáp ndoꞌ bega leꞌa Dios utsaksi be men ncho nat ke ten iteanak be ta mbin bexa polta wa. ");
INSERT INTO zpt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Proꞌob bego mech ten ley! Leꞌa bega nka igondoꞌ be men Dios. Leꞌa bega lá nchandoꞌ Dios, no ni lá nlaꞌa bega igondoꞌ bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Leꞌa gor na mtayadiꞌizh Jesús, leꞌa be mech ten ley no bexa fariseo uzhebpa ndakloobe ndoꞌ Jesús. Cha usaxan bexa unabdiꞌizh bexa sian ta ugan, ");
INSERT INTO zpt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nlad bexa gab Jesús dub ta lid leꞌa nak, ndontsa ke weꞌe usake bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Leꞌa gor wa leꞌa sian mil be men ulayaꞌ wats Jesús, gast nsoꞌ bexa tsoꞌo xoꞌo ltsaꞌa bexa tant dub kwaꞌad bexa. Leꞌa Jesús cha ndab ndoꞌ be xmen na: —Uzhebpa gop bega cuent nsea levadur ten bexa fariseo, leꞌa bexa nluꞌu cuentta xa wen, ná leꞌa bexa ugap nak. ");
INSERT INTO zpt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Leꞌa itea be ta ugaꞌach, leꞌa gal gor leꞌa be ta wa uluꞌukabe. No itea be ta ngachyoꞌo, leꞌa gal gor leꞌa be men iniꞌíka ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ta weꞌe leꞌa itea ta ndadiꞌizh bega dub sa ukaw, leꞌa ta wa sgenka ndoꞌ xeꞌa. No itea ta xgaꞌach ndadiꞌizh bega len niꞌi, leꞌa ta wa gast idub gezh sgenka. ");
INSERT INTO zpt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Leꞌa naꞌ gáp ndoꞌ bego nak amig ten naꞌ, lá izheb bega ndoꞌ bexa ndut men, leꞌa bexa wa ta weꞌetsa sun gan gun. ");
INSERT INTO zpt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ndi gáp naꞌ ndoꞌ bega ná ton ndoꞌ ná nsabndoꞌ izheb bega: bzheb bega ndoꞌ Dios, xa na sun gan gut be men, cha utsaꞌab xa gealnaban ten bexa infierno. Leꞌa naꞌ gáp ndoꞌ bego, ndoꞌ xa weꞌe bzheb bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Leꞌa dub gaꞌay migin nzheꞌa top med byux, ná leꞌa cuent ten Dios leꞌa kadga dub migin wa nsak. ");
INSERT INTO zpt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lá izheb bega leꞌa bega mas nsak ndoꞌ be migin. Leꞌa Dios uzhebpa nlaꞌach bega gast uniꞌí xa plo gichgek bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","No ndab Jesús ndoꞌ be xmen na: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa tal ton gab ndoꞌ be men leꞌa xa xmen naꞌ, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, noga gáp ndoꞌ be angel ten Dios leꞌa xa xmenka naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Parea leꞌa tal ton gab ndoꞌ be men leꞌa xa naꞌanpa xmen naꞌ, leꞌa naꞌ noga gáp ndoꞌ be angel ten Dios leꞌa xa wa naꞌanpa xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Leꞌa tal ton inisi naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, leꞌa Dios sungeꞌka ladna ta wa. Ná leꞌa tal ton inisi Espíritu ten Dios, leꞌa Dios lá gungeꞌ ladna ke wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Leꞌa bega yak cuent ndoꞌ bexa nibeꞌe ten bexa judio no ndoꞌ be juez no ndoꞌ bexa naktiꞌin. Parea lá yuꞌ ladna bega xteꞌe ikaꞌab bega, no xteꞌe utsakndoꞌ bega, ");
INSERT INTO zpt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","leꞌa Espíritu ten Dios leꞌa uluu xteꞌe gab bega gor wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Leꞌa lat be men kwaꞌad wa utoꞌo dub xa ndab ndoꞌ Jesús: —Mech, gud go ndoꞌ wit naꞌ ite besa be taꞌa msaꞌa xus besa. ");
INSERT INTO zpt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ná leꞌa Jesús cha ukaꞌab ndab ndoꞌ xa wa: —Naꞌan ton msoꞌ naꞌ gak naꞌ juez ite naꞌ be taꞌa ten bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Cha ndab Jesús ndoꞌ be men wa: —Blaꞌach bega naꞌanpa isaꞌab ladna bega gap bega sian taꞌa, leꞌa be ta sian ndap dub men lá isuꞌu gun wen yoo xa. ");
INSERT INTO zpt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","No msaktabeꞌe Jesús dub taꞌa mluu xa ndab xa: —Uyoꞌo dub xabgiꞌi rik uzhebpa ngok taꞌa ndoꞌ yo ten xa. ");
INSERT INTO zpt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Cha mbinbeꞌe xa wa: “¿Xteꞌe gun naꞌ nat? ¿Pa kochaꞌaw naꞌ be ta sian ndee?” ");
INSERT INTO zpt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tsoꞌo wa mbinbeꞌe xa: “Naꞌ uníla xteꞌe gunno naꞌ‑yá. Naꞌ ulate be sa nyochaꞌaw be taꞌa ten naꞌ. Cha gunde naꞌ stapla be sa mas ubiꞌi, sa yoo be ta sian ndee no iteata be taꞌa ndap naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Cha gáp naꞌ ndoꞌ naꞌ leꞌa naꞌ ndap sianpa be ta gaw na sian liꞌin. Cha une naꞌ, no gaw naꞌ, no goꞌo naꞌ, no iten lad naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","’Ná leꞌa Dios ndab: “Mgiꞌi, ngud nak lu. Leꞌa teꞌal nat leꞌa lu gat. ¿Cha ton yaꞌanno be ta sian ulochaꞌaw lu baꞌ zha?” ");
INSERT INTO zpt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nsea ndab Jesús ndoꞌ be men: —Li nak be men na nlad gap sian taꞌa ndoꞌ gizhliyo, parea leꞌa ndoꞌ Dios leꞌa xa uban nak. ");
INSERT INTO zpt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Weꞌe leꞌa Jesús cha ndab ndoꞌ be xmen na: —Ta weꞌe leꞌa naꞌ gáp ndoꞌ bega lá yuꞌ ladna bega xtaꞌan gaw bega ndontsa iban bega. No ni lad gak bega lá yuꞌ ladna bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Leꞌa gealnaban ten bega mas nsak ndoꞌ be ta gaw bega, no leꞌa bega mas nsak ndoꞌ be xab bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Binbeꞌe bega lak nak be migin, ni lá ndas ma bid, no ni lá nteleꞌe ma ta gaw ma, no ni lá ndap ma dub sa nyochaꞌaw ta gaw ma, ná leꞌa Dios ngawka ma. ¿Lá iniꞌí bega zha leꞌa bega uzhebpa mas nsak ndoꞌ be migin? ");
INSERT INTO zpt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","No ni dub bega tal leꞌa xa uzhebpa yuꞌ ladna, lá gun xa gan gaꞌal xa ni stol metr. ");
INSERT INTO zpt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tal leꞌa bega ni ta tuzh wa lá yoo gan gun, ¿xtaꞌan ngi nyuꞌ ladna bega iteata be taꞌa zhaga? ");
INSERT INTO zpt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Bwiꞌi bega ndoꞌ be géꞌe no xteꞌe ndiꞌibyaꞌal‑a, parea ni lá ndun‑a tiꞌin, no ni lá ndandeꞌe‑yá lad. Ná leꞌa naꞌ gáp ndoꞌ bega leꞌa lat itea be lad uzhebpa wen ngok Salomón naꞌan dub lad chul lakta dub géꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Leꞌa Dios lita chul ndanno be géꞌe ndiꞌib be geꞌe, ná ta gal geꞌatsa yabtoꞌog‑a cha yolꞌ‑a. Parea leꞌa bega uzhebpa mas nsak ndoꞌ dub géꞌe, ta weꞌe leꞌa Dios saknokaga bega maska ndidotsa ngeꞌ ladna bega Dios. ");
INSERT INTO zpt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ta weꞌe lá gunbeꞌe bega xtaꞌan gaw bega no xtaꞌan goo bega. Ni lá yuꞌta ladna bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Leꞌa be men lá nchandoꞌ Dios wa itea be ta ndee nkwaꞌan xa, ná leꞌa Dios Xus beuna uniꞌíka xtaꞌan nkiꞌin bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ndi bkwaꞌan bega xteꞌe gak bega dub men leꞌa Dios nibeꞌe, weꞌe leꞌa Dios saꞌaka iteanak be ta nkiꞌin bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Lá izheb bego nak cuent be borreg ten naꞌ, leꞌa Dios Xus bega usaꞌa sa nibeꞌe xa yoo bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bdoꞌo bega be ta ten bega, cha btseꞌa bega med wa ndoꞌ bexa uban nak. Tal leꞌa bega li gun, leꞌa bega li kochaꞌaw sian taꞌa gibeꞌa. Leꞌa ta wa cuent dub bols lá gak gox, dub sa na ni waꞌan lá yoo gan yate, no ni mbes lá gaw‑a. ");
INSERT INTO zpt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tal leꞌa bega li gun ta wen wa, weꞌe leꞌa bega mas ukwaꞌan ta nsak ladna Dios. ");
INSERT INTO zpt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’List ute bega, no isengiꞌla xeꞌa ten bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gok bega cuent dub mos nkenkeaꞌ gor ilen xa nibeꞌe ten xa, mtoꞌo xa sa mchilyaꞌa men. Leꞌa gor ilaꞌnchaꞌ xa wa cha kwezh xa mos, leꞌa mos wa listla nsoꞌuxaꞌal sa yoo xa. ");
INSERT INTO zpt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Uzhebpa wen yoo ladna be mos ndenaꞌbe gor ilaꞌnchaꞌ xa nibeꞌe ten na. Leꞌa naꞌ gáp ndoꞌ bega leꞌa xa nibeꞌe wa cha gab ndoꞌ mos isob xa ndoꞌ mes, cha usaꞌa xa ta gaw mos wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Guniꞌi xá gor ilen xa, tal ilen xa utol teꞌal natal ilen xa gor nsayat xeꞌa, tal leꞌa be mos wa listka nde, leꞌa bexa wa wen yoo. ");
INSERT INTO zpt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’Parea leꞌa naꞌ nlad yakbeꞌena bega ta ndee: leꞌa tal leꞌa dub xwan niꞌi uniꞌí xá gor giꞌid dub waꞌan ta lid xa, leꞌa xa isob ulaꞌach ndontsa naꞌanpa yoo waꞌan len lid xa kowaꞌan be taꞌa ten xa. ");
INSERT INTO zpt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ta weꞌe no bega list ute, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilengal dub gor ni lá ndanbeꞌe bega ti ilen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Leꞌa Pedr cha unabdiꞌizh ndoꞌ Jesús ndab: —Señor, ta msaktabeꞌe go wa, ¿ndab ga ta wa ndoꞌtsa besa zha, nate no ndoꞌ itea be men? ");
INSERT INTO zpt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Leꞌa Jesús cha ndab: —¿Ton bega nak cuent dub mos ndák ndun lak ndab dub xwan niꞌi? Leꞌa xwan niꞌi wa uchaꞌan mos wa inibeꞌe xa stapla bexa ndun tiꞌin ten xa wa, no usaꞌa mos ta gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Leꞌa gor na ilaꞌnchaꞌ xwan niꞌi wa uzhebpa wen yoo ladna mos ndun lak ndab xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Leꞌa naꞌ gáp ndoꞌ bega leꞌa xwan niꞌi wa usoꞌ mos wen wa, inibeꞌe xa itea be ta ndap xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ná tal leꞌa mos wa dub xa ugap, gunbeꞌe xa gab xa leꞌa xa nibeꞌe ten xa nleꞌata ilen. Cha ndi isaxan xa kin xa iteata be mos wa, be xabgiꞌi no be xagots. No gaw xa no goo xa no gun xa gealgu. ");
INSERT INTO zpt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Weꞌe leꞌa xwan niꞌi wa cha ilaꞌnchaꞌ dub wizh no dub gor ni lá ndanbeꞌe mos ti ilen xa. Cha uzhebpa utsaksi xa mos wa lak ntsaksi xa itea be mos lá nxobgek. ");
INSERT INTO zpt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tal leꞌa dub mos uniꞌíka xtaꞌan nlad xa nibeꞌe ten na, ná ni lid list ngun xa, no ni lá ngun xa ta nlad xa nibeꞌe ten xa, leꞌa xa wa uzhebpa gealkweaꞌ iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ná tal leꞌa dub mos ni lá nchandoꞌ xteꞌe nak ta nlad xa nibeꞌe ten na, cha ndun xa ta na nsabndoꞌ utsaksi bexa xa, leꞌa xa wa mas uxee gealkweaꞌ iniꞌí. Leꞌa itea bexa na mas sian taꞌa msaꞌa Dios ndák xa, leꞌa bexa wa liga sian tiꞌin nsabndoꞌ gun ndoꞌ Dios. No leꞌa bexa na mas sian taꞌa nsaꞌa Dios ulaꞌach bexa, leꞌa bexa wa liga nsabndoꞌ mas uxobgek ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Leꞌa naꞌ ndal utsengiꞌ ndoꞌ gizhliyo ndee. Leꞌa naꞌ nlad malay‑a nsayolꞌla. ");
INSERT INTO zpt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Leꞌa naꞌ ned nsabndoꞌ itiꞌid ndoꞌ dub gealkweaꞌ siꞌil, no uzheꞌeb kweaꞌ ncho lad naꞌ gast itiꞌid naꞌ ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lá gunbeꞌe bega leꞌa naꞌ ndee ndal ndontsa uzheꞌeb wen kwe be men ndoꞌ gizhliyo. Leꞌa naꞌ ndi ndal leꞌa be men iteltsaꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Leꞌa nat idubta ndoꞌ ndee, tal leꞌa dub niꞌi ncho gaꞌay men leꞌa chon xa wa gakloo ndoꞌ stop xa, no stop xa wa gakloga ndoꞌ yon xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ncho be xabgiꞌi gakloo ndoꞌ be xinbgiꞌi na; no leꞌa be xin xa gakloga ndoꞌ xa. Leꞌa ncho be xagots gakloo ndoꞌ be xingots na; no leꞌa be xingots xa gakloga ndoꞌ xnaꞌa na. Leꞌa be xagots no gakloo ndoꞌ xinxix na; no leꞌa xinxix xa gakloga ndoꞌ leꞌaka xnazhaꞌap xa. ");
INSERT INTO zpt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Cha ndab Jesús ndoꞌ be men kwaꞌad wa: —Leꞌa gor na naꞌ bega nlen xkaw lad ndaꞌas wizh, cha ndab bega leꞌa gi ilaꞌ, cha lika ndak‑a. ");
INSERT INTO zpt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No zha na nlen mbi lad sur, cha ndab bega leꞌa wizh wa uzhebpa utii gak, cha likaga ndak‑a. ");
INSERT INTO zpt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Leꞌa bega nluu cuentta xa wen, ná bega xa ugap! Nyakbeꞌena bega xteꞌe nak ta naꞌ bega gibeꞌa baꞌ no be ta gizhliyo ndee, ná ni lá nyakbeꞌena bega ta ndun Dios tiemp nat. ");
INSERT INTO zpt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Bwiꞌi bega naga leꞌa nak ta ndun bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Leꞌa tal ton nlad usake bega, waꞌyadiꞌizhno bega xa gor biseata isoꞌ xa ndoꞌ juez. Leꞌa tal xa usake bega ndoꞌ juez, leꞌa juez cha yun cuent bega ndoꞌ xa nlaꞌach litgiꞌib, cha ukeꞌa litgiꞌib xa bega. ");
INSERT INTO zpt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Leꞌa naꞌ gáp leꞌa bega lá itoꞌo sa wa gast kixka bega iteanak ta nsaꞌab bega wa. ");
INSERT INTO zpt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Leꞌa gor wa leꞌa be men cha ndab ndoꞌ Jesús, xteꞌe mbit be soldad ten Pilat pla bexa Galilea, gor na nsaꞌa bexa man xnab ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Leꞌa Jesús cha ndab: —¿Nsak bega zha leꞌa ta na li ngwasea bexa Galilea wa li ngok geal leꞌa bexa mas ndap ke ndoꞌ iteata be men Galilea zha? ");
INSERT INTO zpt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Leꞌa naꞌ gáp leꞌa ta wa naꞌanpa li nak. Leꞌa tal bega lá ulaꞌa be ta ugap nak bega, leꞌa itea bega no sat. ");
INSERT INTO zpt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Nati nsak bega zha leꞌa isatiꞌin bchon be men na li ngut gor ulayat torre Siloé tsoꞌo bexa wa mas ndap ke ndoꞌ itea bexa ndencho Jerusalén wa? ");
INSERT INTO zpt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Leꞌa naꞌ gáp leꞌa ta wa naꞌanpa li nak. Tal leꞌa bega lá ulaꞌa be ta ugap nak bega, leꞌa bega itea sat. ");
INSERT INTO zpt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Cha msaktabeꞌe Jesús dub taꞌa mluu xa, ndab xa: —Leꞌa dub xabgiꞌi ndap dub ya nsaꞌa ngus laꞌaw. Leꞌa ya wa nsob ndoꞌ yo sa ncho ya uv ten xa wa. Cha ngol gor ngwaꞌkwaꞌan xa ngus ndoꞌ ya laꞌaw wa, ná lá izheal xa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Cha ndab xa ndoꞌ mos ten xa, xa nlaꞌach be ya wa: “Unaꞌ, leꞌa chonla liꞌin nchasea ndalkwan naꞌ ngus ndoꞌ ya ndee, ná lá nzheal naꞌ‑yá. Nat ulobtoꞌog‑a, ndontsa ndi gaktiꞌin sa nsob‑a.” ");
INSERT INTO zpt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Leꞌa xa na nlaꞌach ya wa cha ukaꞌab ndab ndoꞌ xa wa: “Señor, blaꞌa ga‑yá liꞌin ndeetsa. Leꞌa naꞌ uxach xan‑a no koꞌo naꞌ kweal‑a. ");
INSERT INTO zpt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tal leꞌa‑yá saꞌa ngus, lbaꞌatsa nsob‑a. Ná tal lá usaꞌa‑yá ngus, weꞌe yabtoꞌog‑a.” ");
INSERT INTO zpt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Leꞌa dub wizh neꞌe bexa judio, leꞌa Jesús nluu bexa len dub niꞌi sa nzhealbe bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Leꞌa sa wa ulen dub xagots tsoꞌotek dub tiꞌin bchonla liꞌin, ni lá yoo gan isoꞌgaꞌal xa. Leꞌa ta wa ta mbinno dub mbi bxin xa. ");
INSERT INTO zpt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Leꞌa gor uniꞌí Jesús xagots wa, cha utezh Jesús xa, cha ndab xa ndoꞌ xagots wa: —Xagots, leꞌa lu myaklana. ");
INSERT INTO zpt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cha mxoꞌob Jesús be yaꞌa na tsoꞌo xa. Leꞌa xa wa cha usoꞌgaꞌal, cha msaꞌa xa xno ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Parea leꞌa xa nchansu niꞌi wa cha ngokloo ke na myunyakna Jesús xa wa dub wizh neꞌe bexa judio, ndab xa ndoꞌ be men: —Xoꞌop wizh nsabndoꞌ gun beuna tiꞌin. Leꞌa len be wizh wa syoꞌo gan giꞌid bega yakna bega, naꞌanpa be wizh neꞌe beuna ndee. ");
INSERT INTO zpt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Leꞌa Jesús cha ndab: —Leꞌa bego lá ndun lak ndab bega wa. ¿Lak bego lá nxaꞌak bega xgon bega no xburr bega, ndaꞌugo bega ma nits wizh neꞌe beuna zha? ");
INSERT INTO zpt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Leꞌa maxuꞌu dub tiꞌin bchonla liꞌin li mbinno xagots ndee, dub xa ras Abraham. ¿Lid nsabndoꞌ yakna xa wizh neꞌe beuna zha? ");
INSERT INTO zpt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Leꞌa gor na li ndab Jesús, leꞌa itea bexa na ndakloo ndoꞌ Jesús wa cha mdo ladnabe. Ná leꞌa be men kwaꞌad wa uzhebpa mten ladna no be ta wen ndun Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Leꞌa Jesús cha ndab: —¿Xtaꞌan dub taꞌa nak lak nibeꞌe Dios be men? ¿Xteꞌema gudiꞌizh naꞌ‑yá? ");
INSERT INTO zpt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Leꞌa ta wa nak cuent ta ngwasea dub bid ten mostas, ta ngos dub xabgiꞌi ndoꞌ dub bleꞌa yo ten na. Cha ngoꞌol‑a gast ngok‑a dub ya siꞌil, gast be migin mbindeꞌe xuꞌun ten na ndoꞌ xos‑a. ");
INSERT INTO zpt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","No ndab Jesús: —¿Xtaꞌan stub taꞌa nak lak nibeꞌe Dios? ");
INSERT INTO zpt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Leꞌa ta wa nak lak nyak levadur. Leꞌa dub xagots mgoch dub tuzh‑a dub top gaꞌal kil arin. Ngol tsoꞌo wa leꞌa idub koꞌob arin wa usabich. ");
INSERT INTO zpt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Leꞌa nes nchaꞌa Jesús Jerusalén, leꞌa xa nluu be men ncho be gezh ubiꞌi no be gezh byux. ");
INSERT INTO zpt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Weꞌe leꞌa dub men unabdiꞌizh ndoꞌ Jesús ndab: —Señor, ¿ndidotsa bexa gap gealnaban nunk lá idub zha? Leꞌa Jesús cha ukaꞌab ndab ndoꞌ be men: ");
INSERT INTO zpt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Bin bega juers yate bega toꞌo puert uyaꞌa. Leꞌa naꞌ gáp ndoꞌ bega leꞌa kwaꞌadpa bexa nlad yate sa wa, ná leꞌa bexa lá gun gan. ");
INSERT INTO zpt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Leꞌa gor na yá mtsawla xwan niꞌi toꞌo puert wa, leꞌa bega yaꞌanbe tsoꞌo juer utsiꞌid toꞌo niꞌi wa, gab bega: “Señor, bxaꞌal ga toꞌo niꞌi yoo besa.” Parea leꞌa xwan niꞌi wa ndi ikaꞌab gab: “Naꞌ ni lá nchandoꞌ bega.” ");
INSERT INTO zpt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Weꞌe leꞌa bega isaxan gab: “Leꞌa besa udawno ga, no nguno besa ga. No mbidiꞌizh ga ndoꞌ besa be ndoꞌ xgeꞌe ten besa.” ");
INSERT INTO zpt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Leꞌa xa wa cha ikaꞌab gab: “Leꞌa naꞌ lá nchandoꞌ bega. Nat bxoꞌon bega wats naꞌ, bego xa ndun ta ugap.” ");
INSERT INTO zpt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Weꞌe leꞌa bego iniꞌí leꞌa Abraham no Isaac no Jacob no itea be profet wa nde wats Dios sa nibeꞌe Dios, ná leꞌa bega ndi dub lad tsoꞌo juer yaꞌanbe. Cha uzhebpa goꞌon bega no gaw bega ndeay bega, tant dub gealkweaꞌ siꞌil iniꞌí bega. ");
INSERT INTO zpt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","’Leꞌa uzhebpa kwaꞌad be men ilen itea lad ndoꞌ gizhliyo, kwe bexa ndoꞌ mes sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Leꞌa ncho bexa naꞌanpa nsak nat wa, gal gor leꞌa bexa yak bexa nsak. No liga ncho bexa nsak nat wa, gal gor leꞌa bexa wa yak bexa naꞌanpa nsak. ");
INSERT INTO zpt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bi leꞌa wizh wa ulayaꞌ pla bexa fariseo ndab ndoꞌ Jesús: —Bkaꞌan sa ndee leꞌa Herodes ndab gut lu. ");
INSERT INTO zpt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Leꞌa Jesús cha ukaꞌab ndab: —Byaꞌ bega cha gud bega ndoꞌ mbeas wa, leꞌa naꞌ bi ngontuꞌub be mbi bxin len ladoꞌo be men, no nyunyakna naꞌ be men gizh. Parea yamer usandoꞌ naꞌ tiꞌin ten naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Leꞌa nat guniꞌi xtaꞌan yoo leꞌa naꞌ nda Jerusalén sa na nsabndoꞌka gaa naꞌ. Leꞌa dub xa ndadiꞌizh sakndoꞌ Dios naꞌanpa nsabndoꞌ gat dub lad sa nde Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Leꞌa bego ndencho Jerusalén, leꞌa bega ndut bexa ndadiꞌizh sakndoꞌ Dios, no nlaꞌgeꞌ bega bexa na ntuꞌub Dios ndoꞌ bega. Sian biaj nlad naꞌ yunjunt naꞌ bega, lak nyunjunt dub ngidtsan be ngid ben ten ma len xkwag ma, ná leꞌa bega nunk lá kaꞌab. ");
INSERT INTO zpt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Blaꞌach bega, leꞌa nat leꞌa Dios ulaꞌalad bega. No gáp naꞌ ndoꞌ bega leꞌa bega yá naꞌantapa iniꞌí naꞌ gast gal wizh gab bega: “Dios uzhebpa nlaꞌach xa baꞌ, xa na mtuꞌub Dios Xa Nibeꞌe.” ");
INSERT INTO zpt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Leꞌa dub wizh neꞌe bexa judio leꞌa dub xa nibeꞌe ten bexa fariseo mbiꞌi Jesús, nchaꞌdaw bexa ta lid xa. Leꞌa sa wa leꞌa bexa fariseo nlaꞌach ná xteꞌe gun Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ná leꞌa lad ndoꞌ Jesús nsob dub xa uzhebpa ncho giꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Leꞌa Jesús cha ndab ndoꞌ be mech ten ley no ndoꞌ bexa fariseo: —¿Nsabndoꞌ yunyakna beuna dub xa gizh wizh neꞌe beuna zha nate naꞌan? ");
INSERT INTO zpt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ná leꞌa bexa ni lá ikaꞌabbe. Leꞌa Jesús cha mgal las xa gizh wa, cha myunyakna Jesús xa, cha ndab xa yaꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cha ndab Jesús ndoꞌ bexa nde sa wa: —Tal leꞌa bega ndap dub burr natal dub ngon, cha ilaꞌyoꞌo ma len dub so wizh neꞌe beuna, ¿lid cha uxax yaꞌloꞌo bega ma bi leꞌaka wizh wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Leꞌa bexa wa ni lá yoꞌota gan xteꞌe ngabbe. ");
INSERT INTO zpt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Leꞌa Jesús nsoꞌwiꞌi ndoꞌ bexa na ulo xa fariseo kombid ndoꞌ na wa, ná xteꞌe mti bexa sa mas nsak isob bexa. Cha mtenxeꞌa Jesús bexa xteꞌe nsabndoꞌ gun bexa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Leꞌa gor na ko dub men kombid ndoꞌ bega dub sa uchilyaꞌa xa, lá isob bega sa mas nsak. Leꞌa gal gor na ilen stub xa mas nsak ndoꞌ bega, ");
INSERT INTO zpt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","cha gab xwan niꞌi wa usaꞌa bega sa wa isob xa mas nsak wa. Weꞌe leꞌa bega uzhebpa ido ladna yatsob bega gast tsoꞌo li. ");
INSERT INTO zpt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Leꞌa naꞌ gáp ndi usob bega mas sitxá, ndontsa gor na ilen xwan niꞌi wa, leꞌa xa ndi gab: “Amig, utsea isob lu mas gax ndee.” Weꞌe leꞌa be men iniꞌí leꞌa bega xa nsak. ");
INSERT INTO zpt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Leꞌa tal ton gunbeꞌe leꞌa mas nsak, leꞌa gal gor leꞌa xa ido ladna. No liga leꞌa tal ton yak tuzh ndoꞌ be men, leꞌa gal gor leꞌa be men iniꞌí leꞌa xa wa nsakka. ");
INSERT INTO zpt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","No ndab Jesús ndoꞌ xa na ulo kombid wa: —Leꞌa gor na gun lu dub gast, lá ko lu kombid ndoꞌ be amig ten lu, ni ndoꞌ be wit lu, ni ndoꞌ be ltsaꞌa lu, ni ndoꞌ bexa rik ncho gax sa ncho lu. Ná nchaꞌa xa gal gor no ko kombid ndoꞌ lu, cha litsa myoꞌsoꞌ ta mbin lu wa. ");
INSERT INTO zpt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Leꞌa gor na gun lu dub gast, utezh bexa prob no bexa moch no bexa coj no bexa lá naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Li ndontsa wen yoo ladna lu, leꞌa bexa wa lá gun gan kix ta wa. Ná leꞌa Dios kixka ta wa gal wizh na ibangal bexa na ndun lak nlad Dios. ");
INSERT INTO zpt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Weꞌe leꞌa dub xa na nsobno Jesús ndoꞌ mes wa gor na mbiꞌín xa ta wa, cha ndab xa ndoꞌ Jesús: —¡Uzhebpa wen yoo ladna xa na no gaw sa nibeꞌe Dios! ");
INSERT INTO zpt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Weꞌe leꞌa Jesús cha ndab ndoꞌ xa wa: —Uyoꞌo dub xabgiꞌi ulo dub gast siꞌil ugaw xcheꞌe xa kwaꞌadpa be men. ");
INSERT INTO zpt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Leꞌa ngol gor na yaꞌgaw bexa, leꞌa xa wa cha mtuꞌub dub mos ten xa, yaꞌyab xa ndoꞌ bexa wa gidbe bexa leꞌa itea taꞌa listla nak. ");
INSERT INTO zpt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Parea leꞌa itea bexa wa cha ndab leꞌa bexa lá yoo gan yaꞌ. Leꞌa xa ned wa ndab: “Bingeꞌ ladna go, leꞌa naꞌ tiꞌi usiꞌi dub bleꞌa yo, ta weꞌe lá yoo gan isea naꞌ, leꞌa naꞌ tiꞌi gawiꞌi yo wa.” ");
INSERT INTO zpt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Leꞌa xa itop wa cha ndab: “Bingeꞌ ladna go, leꞌa naꞌ tiꞌi usiꞌi gaꞌay nes ngon, ta weꞌe lá yoo gan isea naꞌ, leꞌa naꞌ tiꞌi gayun preb ma.” ");
INSERT INTO zpt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Leꞌa stub xa cha ndab: “Leꞌa naꞌ tiꞌi mchilyaꞌa, ta weꞌe lá yoo gan isea naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Leꞌa mos wa cha myach myaꞌyab xa ta wa ndoꞌ xa nibeꞌe xa. Weꞌe leꞌa xa wa cha ngokloo, cha ndab xa ndoꞌ mos wa: “Uxax waꞌ ndoꞌ xgeꞌe baꞌ no be nes ten gezh ndee. Cha biꞌi bexa prob sa ndee no bexa moch no bexa coj no bexa lá naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Leꞌa mos wa cha nchaꞌ ndab xa ndoꞌ xwan niꞌi wa: “Señor, leꞌa naꞌ mbín ta ndab go wa, parea leꞌa ta lid ga ndee siꞌilta nsaꞌab.” ");
INSERT INTO zpt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Leꞌa xa nibeꞌe wa cha ndabgal ndoꞌ mos: “Waꞌ be nes ubiꞌi no be nes byux, cha bin juers giꞌid bexa sa ndee, ndontsa izheaka ta lid naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Leꞌa bexa ned uloꞌo naꞌ kombid ndoꞌ na wa ni dub xa lá gawno naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Leꞌa tsoꞌo wa uzhebpa kwaꞌad be men nchaꞌano Jesús. Leꞌa Jesús cha mgeaksoꞌ mwiꞌi ndoꞌ bexa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tal ton nlad isankea tsoꞌo naꞌ, leꞌa xa wa nsabndoꞌ mas yankea naꞌ ndoꞌ xus xa no xnaꞌa xa no xagots ten xa no be xin xa no wit xa no bsan xa. No mas yankea xa naꞌ ndoꞌ leꞌaka leꞌa xa. Tal leꞌa xa lid li gun, leꞌa xa lá yoo gan gak xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Leꞌa tal ton lá goꞌo cruz ten na cha isankea xa tsoꞌo naꞌ, leꞌa xa wa lá yoo gan gak xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’¿Nati ton bega nlad gundeꞌe dub niꞌi siꞌil, lid ned ngoꞌo bega cuent naga ndap bega dub lak med itatsoꞌ yandoꞌ niꞌi wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tal leꞌa bega utexan niꞌi wa, cha lá gun bega gan yandoꞌ‑yá, leꞌa itea be men na iniꞌí‑yá uxiꞌidno bega. ");
INSERT INTO zpt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","No gab bexa: “Leꞌa xabgiꞌi ndee msobxan niꞌi, parea lá ngun xa gan yandoꞌ‑yá.” ");
INSERT INTO zpt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","¿No xá rey na kuyono stubga rey, lid ned ngoꞌo xa cuent naga sun dub tiꞌi mil xmen xa gan kuyono dub gaꞌal mil xmen stubga rey wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tal leꞌa xa uniꞌí leꞌa xa lá gun gan, leꞌa gor na bi sitta nseabe bexa, leꞌa xa utuꞌub dub xmen na yaꞌinabdiꞌizh ndoꞌ stub rey wa ná plo taꞌa usaꞌa xa ndontsa lá kuyo bexa. ");
INSERT INTO zpt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","No liga bego na lá ulaꞌa itea be taꞌa ndap na, leꞌa bega lá yoo gan gak xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Leꞌa sed wa ta wen, parea tal leꞌa‑yá itoꞌo utix ten na, ¿xteꞌema yak utix‑a stub biaj zha? ");
INSERT INTO zpt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Weꞌe leꞌa sed wa yá lá isuꞌuta, no ni kweal lá isuꞌu‑yá gak‑a, ndi yabitsa‑yá. Bego na ndap nchaꞌ na, blaꞌach bego ta ndáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Leꞌa kwaꞌad bexa nsen med nkix be men ndoꞌ gobier no kwaꞌadta bexa ugap ulen wats Jesús, goꞌón bexa ta ndadiꞌizh Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Leꞌa bexa fariseo no be mech ten ley cha unisi Jesús, ndab bexa: —Leꞌa xa baꞌ nchealtsaꞌa bexa ugap, no ndawno xa bexa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Cha msaktabeꞌe Jesús dub taꞌa mluu xa ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Tal leꞌa dub bego ndap dub gayoꞌo borreg, cha ulaꞌ dub ma, ¿lá ulaꞌa bega isadap gaꞌal ncho tiꞌin bdap ma wa geꞌe wa zha, cha ndi yaꞌkwaꞌan bega ma na li ulaꞌ wa, gast plo izhealka bega ma? ");
INSERT INTO zpt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Leꞌa gor na mzheal bega ma, leꞌa bega iten ladna uxoꞌob bega ma tsoꞌo xik bega yoꞌo bega ma. ");
INSERT INTO zpt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Leꞌa gal gor na ilanseaꞌ bega, cha uchealte bega be amig ten bega no bexa ncho gax wa. Cha gab bega: “Bten ladna bega lakta nten lad naꞌ, leꞌa naꞌ mzheal‑la borreg ten naꞌ, ma ulaꞌ wa.” ");
INSERT INTO zpt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Leꞌa naꞌ gáp ndoꞌ bego leꞌa Dios no be angel li mas nten ladna gor na nyach dub xa ugap wats Dios, ndoꞌ isadap gaꞌal ncho tiꞌin bdap bexa wen, bexa lá ikiꞌinta yach bexa wats Dios. ");
INSERT INTO zpt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Tal leꞌa dub xagots ndap dub tiꞌi med nsak, cha mlaꞌ xa dub‑a, ¿naꞌanpa cha ukegiꞌ xa dub xeꞌa ged zha, cha ndon ku uloꞌob xa len lid xa, gast plo izhealka xa‑yá? ");
INSERT INTO zpt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Leꞌa gor na yá mzheal xa‑yá, cha gab xa ndoꞌ be amig ten xa no ndoꞌ bexa ncho gax wa: “Bten ladna bega lakta nten lad naꞌ, leꞌa naꞌ mzheal‑la med ulaꞌ wa.” ");
INSERT INTO zpt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Leꞌa naꞌ gáp ndoꞌ bego li nten ladna be angel ten Dios gor na nyach dub men ugap wats Dios. ");
INSERT INTO zpt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","No ndab Jesús: —Uyoꞌo dub xabgiꞌi ndap top xinbgiꞌi na. ");
INSERT INTO zpt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Leꞌa xa tuzh wa cha ndab ndoꞌ xus na: “Bsaꞌa ga be ta na ndal naꞌ.” Leꞌa xus xa cha mtseꞌa be ta ten na ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ngol stapla wizh leꞌa xa tuzh wa cha mdoꞌo itea be ta li ukaꞌa xa wa, cha nchaꞌa xa stubga nacion sit. Leꞌa sa wa mbin gast xa med ten xa wa ndoꞌ be taꞌa ni lid nsabndoꞌ gun xa. ");
INSERT INTO zpt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Leꞌa tsoꞌo na mteꞌa xa med wa, leꞌa sa wa uyoꞌo dub win siꞌil. Leꞌa xa wa no lá ndapla ta gaw na. ");
INSERT INTO zpt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Cha mkwaꞌan xa tiꞌin gun xa ndoꞌ dub men ncho sa wa. Leꞌa xa wa mtuꞌub xa yaꞌkeno xa be kuch. ");
INSERT INTO zpt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Leꞌa ta na lita ndanna xa wa, gast nlad xa gaw xa gix ndaw kuch wa. Ná leꞌa xwan kuch wa lá usaꞌa ta gaw xa. ");
INSERT INTO zpt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Cha mbinbeꞌe xa: “Plota mos ndap xus naꞌ ta lid na no sian be ta ndaw xa ndap xa. Ná naꞌ gast ngi sat tant ndanna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nat leꞌa naꞌ nsea ta lid xus naꞌ, gáp naꞌ ndoꞌ xa: Leꞌa naꞌ mbin dub ta ugap ndoꞌ Dios no ndoꞌ go. ");
INSERT INTO zpt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yá lá nsabndoꞌ gab go leꞌa naꞌ xin ga. Leꞌa naꞌ ndi gak masa dub mos ten ga.” ");
INSERT INTO zpt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Weꞌe cha utoꞌo xa, nseaꞌ xa ta lid xus xa. ’Leꞌa gor na bi sitta nseaꞌ xa, leꞌa xus xa uniꞌíla xa, cha uzheꞌeb mlats ladna xus xa xa. Weꞌe utoꞌo xus xa karrel, cha udiꞌid xa xin xa. ");
INSERT INTO zpt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Leꞌa xin xa cha ndab: “Leꞌa naꞌ mbin ta ugap ndoꞌ Dios no ndoꞌ go. Yá lá nsabndoꞌta gab go leꞌa naꞌ xin ga.” ");
INSERT INTO zpt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Parea leꞌa xus xa ndi unibeꞌe ndoꞌ be mos ndab xa: “Utseano bega dub lad ndon leꞌa wen gak xa, no dub ganil yoo yaꞌa xa, no dub nes gelgid ukeꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","No waꞌyoꞌo bega dub bser, ma ndon leꞌa ugeladna. Cha bit bega ma, leꞌa beuna ko dub gast siꞌil. ");
INSERT INTO zpt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Leꞌa xiꞌín naꞌ ndee cuent dub xa ngutla, ná leꞌa xa mbangal. Leꞌa xa ndee dub xa ulaꞌ, ná nat mzhealgal naꞌ xa.” Cha usaxan ulo bexa gast wa. ");
INSERT INTO zpt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Leꞌa gor wa leꞌa xin ned xa wa ndi geꞌe nkesea. Ngol gor na nsalanseaꞌ xa gax ta niꞌi, leꞌa xa mbiꞌínla ruid ten be musk no ruid ten bexa ndeyalndatsbe. ");
INSERT INTO zpt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Leꞌa xa cha utezh dub mos, cha unabdiꞌizh xa ndoꞌ xa wa ná xtaꞌan ncho. ");
INSERT INTO zpt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Leꞌa mos wa cha ndab: “Leꞌa wit ga mlaꞌnchaꞌ. Leꞌa xus bega mbit bser ndaꞌal wa, geal leꞌa wit ga ndon wen mtanchaꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Cha ngokloo xa wa, lá nlad xa yoo xa len niꞌi. Leꞌa xus xa cha utoꞌo unab ndoꞌ xa yoo xa len niꞌi. ");
INSERT INTO zpt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Leꞌa xa cha ukaꞌab ndab ndoꞌ xus xa: “Unaꞌ go plota liꞌin nxobgek naꞌ ndoꞌ ga, ndun naꞌ tiꞌin ten ga. Ná nunk go lá usaꞌa masa dub chiv koꞌo naꞌ dub gast no be amig ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ná nat mlaꞌnchaꞌ xin ga uloꞌo ga gast, mbit ga bser ndaꞌal wa, ná leꞌa xa wa ndi mbin gast be med ten ga lat be xagots ugap.” ");
INSERT INTO zpt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Leꞌa xus xa cha ukaꞌab ndab: “Leꞌa lu nunkka lá nlaꞌa naꞌ. Leꞌa itea be ta ten naꞌ leꞌa ta wa ta tenka lu. ");
INSERT INTO zpt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Leꞌa beuna nsabndoꞌka ko dub gast no iten ladna beuna, leꞌa wit lu ndee cuent xa yá ngutla, ná nat mbangal xa. Leꞌa xa cuent xa ulaꞌ, ná nat mzheꞌalgal min xa.” ");
INSERT INTO zpt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","No ndab Jesús ndoꞌ be xmen na: —Uyoꞌo dub xabgiꞌi rik, ndap xa dub mos nchansu be tiꞌin ten xa. Ngol dub wizh leꞌa be men msake xa ndoꞌ xa rik wa, ndab bexa leꞌa xa ndun gast med ndoꞌ dub ta ni lid nsabndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Weꞌe leꞌa xa rik wa cha utezh xa wa, ndab xa: “¿Xteꞌe nak ta na ndon naꞌ ndun lu? Uloꞌo cuent ten be tiꞌin ndun lu wa, leꞌa lu lá gakta xa yansu be tiꞌin ten naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Leꞌa mos wa cha mbinbeꞌe: “¿Xteꞌe gun naꞌ nat? Leꞌa xa ten tiꞌin ndee yá lá usaꞌata tiꞌin ndee gun naꞌ. Leꞌa naꞌ lá isuꞌu gun tiꞌin geꞌe. No ido lad naꞌ inaꞌab naꞌ med ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nat leꞌa naꞌ uníla xteꞌe gun naꞌ ndontsa gor na ulat xa tiꞌin ndun naꞌ ndee, leꞌa be men utsin gak ndoꞌ naꞌ ta lid bexa.” ");
INSERT INTO zpt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Leꞌa mos wa cha utezh kadga dub xa na nsaꞌab ndoꞌ xa rik wa. Cha ndab xa ndoꞌ xa ned wa: “¿Plo taꞌa nsaꞌab go ndoꞌ xa nibeꞌe naꞌ?” ");
INSERT INTO zpt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Leꞌa xa wa cha ndab: “Dub dap mil litr aceit nsaꞌab naꞌ.” Leꞌa mos wa cha ndab: “Leꞌa git ndee gab plo taꞌa nsaꞌab go. Uxax bkeꞌa ga top mil litr.” ");
INSERT INTO zpt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cha ndab mos wa ndoꞌ stubga xa: “Go zha, ¿plo taꞌa nsaꞌab ga?” Leꞌa xa wa cha ndab: “Dub gayoꞌo ngoch trig nsaꞌab naꞌ.” Leꞌa mos wa cha ndab: “Leꞌa git ndee gab ná plo taꞌa nsaꞌab ga. Bkeꞌa ga dub dap gaꞌal ngoch‑a.” ");
INSERT INTO zpt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Leꞌa xwan tiꞌin wa cha mgondoꞌ leꞌa mos wa list mbin. Leꞌa be men lá nchandoꞌ Dios mas listbe cuent ten be ta ncho ndoꞌ gizhliyo, ndoꞌ be men nchandoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Leꞌa naꞌ gáp ndoꞌ bega, bintiꞌin bega med gizhliyo ndee ndontsa li gun bega gan amig. Leꞌa gal zha na itea med ten bega ndoꞌ gizhliyo ndee, gap bega dub sa yoo bega, sa nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Leꞌa xa na utsin nyansu dub tuzh taꞌa, leꞌa xa wa liga utsin syansu be ta sian. Leꞌa xa na ni dub tuzh taꞌa naꞌanpa utsin nyansu, leꞌa xa wa liga naꞌanpa utsin yansu be ta sian. ");
INSERT INTO zpt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","No liga leꞌa bego na naꞌanpa utsin nyansu be ta ncho ndoꞌ gizhliyo ndee, leꞌa Dios naꞌanpa usaꞌa taꞌa ta ugeaka nsak yansu bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tal leꞌa bega naꞌanpa utsin nyansu be ta naꞌanpa ta ten bega, leꞌa Dios naꞌanpa usaꞌa be ta na ndiꞌizh ikaꞌa bega wa. ");
INSERT INTO zpt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Naꞌan ton yoo gan gun tiꞌin ndoꞌ top xa nibeꞌe ten na. Leꞌa gal gor leꞌa xa dubtsa xa ikea ladna, leꞌa ndoꞌ stub xa wa ixee ladna xa. No uxobgek xa ndoꞌ dubtsa xa, leꞌa ndoꞌ stub xa wa lá uxobgek xa. No liga tal leꞌa bega nkwaꞌan sian med, leꞌa bega lá isuꞌu gun tiꞌin ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Leꞌa bexa fariseo mbiꞌín ta li ndab Jesús wa, cha mxiꞌidno bexa Jesús, leꞌa bexa li nkwaꞌan sian med. ");
INSERT INTO zpt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Leꞌa Jesús cha ndab ndoꞌ bexa wa: —Leꞌa bega wen ndun ndoꞌ gaꞌal be men, ná leꞌa Dios nchandoꞌ ladoꞌo bega. Leꞌa be ta ni be men uzheꞌeb nsak, leꞌa cuent ten Dios leꞌa ta wa naꞌan xtiꞌin. ");
INSERT INTO zpt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Zha na biseata ilanseaꞌ Juan xa na ulaleaꞌ be men, leꞌa be ley mkeꞌa Moisés no ta na mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios ndab xteꞌe gun be men. Ná leꞌa tsoꞌo wa ulen diꞌizh wen ten Dios, ta na ndab xteꞌe inibeꞌe Dios be men. Nat leꞌa kwaꞌad be men ndun juers gak bexa dub men leꞌa Dios nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Parea leꞌa naꞌ gáp leꞌa gibeꞌa no gizhliyo snitndoꞌ, ná leꞌa ni dub tuzh ley ten Dios naꞌanpa initndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Leꞌa tal ton dub xabgiꞌi ulaꞌa xagots ten na, cha ikaꞌa xa stubga xagots, leꞌa xabgiꞌi wa ndapka ke ndoꞌ Dios. No liga tal stub xabgiꞌi ikaꞌaga xagots wa, leꞌa xa wa no ndap ke ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Uyoꞌo dub xabgiꞌi rik, ngok xa sbeꞌen lad uzheꞌeb uyap, ta konch ugats no ta nagud. Nsea itea wizh ngo xa dub gast uzhebpa wen ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","No uyoꞌo dub xabgiꞌi prob nsaleaꞌ Lázaro uzhebpa gizh idub gid las xa. Leꞌa xa nsob tsoꞌo juer toꞌo lid xa rik wa. ");
INSERT INTO zpt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Leꞌa xa prob wa nsaꞌab ladna gaw masa be taꞌa nlate toꞌo mes ten xa rik wa. No gast be mbek nlen ndawleꞌe las xa prob wa. ");
INSERT INTO zpt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ná ngol dub wizh leꞌa xa prob wa cha ngut. Leꞌa be angel ten Dios cha mbiꞌi xa, usob xa wats Abraham gibeꞌa. Tsoꞌo wa leꞌa xa rik wa no ngut, cha mgaꞌach xa. ");
INSERT INTO zpt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Ná leꞌa gor na uzhebpa kweaꞌ naxncho xa rik wa infierno, leꞌa xa mwiꞌi gaꞌap, sit mnaꞌ xa Abraham no Lázaro nsob wats xa. ");
INSERT INTO zpt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Weꞌe leꞌa xa rik wa cha ugeꞌ ndab: “Xus naꞌ Abraham, blats ladna go naꞌ. Btuꞌub ga Lázaro ugazh xa masa dub ngutsyaꞌa xa, cha gidlo xa‑yá toꞌo naꞌ ndontsa igalad naꞌ, leꞌa naꞌ uzhebpa kweaꞌ nchoꞌo ndoꞌ bealꞌ sa ndee.” ");
INSERT INTO zpt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Leꞌa Abraham cha ndab: “Xiꞌín naꞌ, btseꞌa ladna lu leꞌa lu uzhebpa wen uyoꞌo ndoꞌ gizhliyo, ná leꞌa Lázaro ndee uzhebpa kweaꞌ uyoꞌo. Nat leꞌa Lázaro ndi wen ncho sa ndee, leꞌa lu kweaꞌ ncho sa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","No stubga taꞌa gáp naꞌ: leꞌa sa nde besa ndee nsea sa nde bego baꞌ ncho dub bseꞌa uxenpa tlaw‑a. Ta weꞌe leꞌa besa nde sa ndee lá yoo gan yaꞌ sa baꞌ. No ni bego nde sa baꞌ lá yoo gan giꞌid sa ndee.” ");
INSERT INTO zpt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Leꞌa xa rik wa cha ndab: “Naꞌab naꞌ ndoꞌ go xus naꞌ Abraham, utuꞌub ga Lázaro ta lid xus naꞌ, ");
INSERT INTO zpt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sa na ncho sgaꞌay be wit naꞌ, yaꞌyab xa lá gun bexa lak mbin naꞌ, ndontsa naꞌanpa no bexa wa iniꞌí gealkweaꞌ ndee.” ");
INSERT INTO zpt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Leꞌa Abraham cha ndab: “Leꞌa bexa wa ndenoka ta mkeꞌa Moisés no ta mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios. ¡Nsabndoꞌ gun bexa lak ndab ta wa!” ");
INSERT INTO zpt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Leꞌa xa rik wa cha ukaꞌab ndab: “Xus naꞌ Abraham, leꞌa bexa wa ndenoka ta wa, parea tal leꞌa dub xa ngutla cha ibangal xa, weꞌe gudiꞌizh xa‑yá ndoꞌ bexa wa, leꞌa bexa slaꞌaka be ta ugap nak bexa.” ");
INSERT INTO zpt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ná leꞌa Abraham cha ndab: “Leꞌa tal leꞌa bexa lá gun lak ndab ta mkeꞌa Moisés no ta mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios, leꞌa bexa wa ni likaga lá gungea ladna ta gudiꞌizh dub xa ibangal ndoꞌ gealgut.” ");
INSERT INTO zpt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Leꞌa Jesús cha ndab ndoꞌ be xmen na: —Idub tiemp ncho ta ntsabgix be men ndoꞌ ta ugap, parea uzhebpa proꞌob dub xa ntsabgix stubga men. ");
INSERT INTO zpt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Leꞌa tal ton utsabgix dub xa ndangea ladna naꞌ ndoꞌ ta ugap, leꞌa xa wa mas gealkweaꞌ siꞌil iniꞌí ndoꞌ dub xa ikea dub geꞌ siꞌil gen na, cha utsaꞌab be men xa len nitsdoꞌo. ");
INSERT INTO zpt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’¡Blaꞌach bega xteꞌe nak bega! Tal leꞌa dub ltsaꞌa bega ugap gunno bega, bidiꞌizhno bega xa ndontsa lá gunta xa ta wa. Tal leꞌa xa igondoꞌka ta li mbin xa wa, bingeꞌ ladna bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ná tal leꞌa xa dub gaꞌad biaj ugap gunno bega dub wizhtsa, cha dub gaꞌadga biaj gab xa gungeꞌ ladna bega ta li mbin xa wa, leꞌa bega nsabndoꞌka gungeꞌ ladna ndoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Leꞌa isatibtop be xmen Jesús cha ndab ndoꞌ xa: —Gokno ga besa ndontsa mas igeꞌ ladna besa Dios. ");
INSERT INTO zpt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Leꞌa Jesús cha ukaꞌab ndab: —Tal leꞌa bega ndidotsa ngeꞌ ladna Dios lak tuzh dub bid ten ya mostas, leꞌa bega sun gan gab ndoꞌ dub ya sicómoro baꞌ igiꞌib‑a sa nsob‑a, cha yaꞌtsob‑a len nitsdoꞌo. Weꞌe leꞌa ya baꞌ sunka lak ndab bega wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tal leꞌa bega ndap dub xa ndun tiꞌin ndoꞌ bega, dub xa ngaꞌan ngon no nkeno xa be xman bega, leꞌa gor na mlaꞌnchaꞌ xa ngwaꞌ xa geꞌe, ni dub bega lá ndab ndoꞌ xa: “Uyoꞌo, cha usob ndoꞌ mes.” ");
INSERT INTO zpt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Leꞌa bega ndi gab: “Bindeꞌe ta gaw xcheꞌe naꞌ, cha utseano‑yá. Cha list usoꞌ usaꞌa lu ta ikiꞌin naꞌ. Gast itayaw naꞌ weꞌeta gaw lu.” ");
INSERT INTO zpt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","No lá nsaꞌa bega xno ndoꞌ xa ndun tiꞌin ten bega wa geal mbintsa xa ta ndab bega. ");
INSERT INTO zpt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","No liga gok bega gor na yá mbin bega itea be ta unibeꞌe Dios, gudtsa bega ndoꞌ Dios: “Leꞌa besa naktsa dub xa ndun tiꞌin ndoꞌ ga, mbintsa besa lak unibeꞌe ga gun besa.” ");
INSERT INTO zpt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Leꞌa nes nchaꞌa Jesús gezh Jerusalén, nchaꞌtid xa sa nzheꞌal distrit Samaria nsea distrit Galilea. ");
INSERT INTO zpt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Leꞌa gor na ulayaꞌ xa toꞌo dub gezh, cha utoꞌo dub tiꞌi xabgiꞌi nsaꞌgea las na, nsén gealgizh lepra xa. Cha sittsa ngwaꞌibe bexa, ");
INSERT INTO zpt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ugeꞌ ndab bexa: —¡Jesús! ¡Mech! ¡Blats ladna go besa! ");
INSERT INTO zpt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Leꞌa gor uniꞌí Jesús bexa, cha ndab xa: —Waꞌ bego ndoꞌ be uleꞌay iwiꞌi xa bega. Ndalen nsoꞌ bexa nes, cha myakna bexa. ");
INSERT INTO zpt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Leꞌa gor na uniꞌí dub xa wa leꞌa xa myaklana, cha myach xa, ugeꞌ msaꞌa xa xno ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Cha msaxib xa ndoꞌ Jesús gast ndoꞌ yo ngol xtuzh xa, msaꞌa xa xno ndoꞌ Jesús. Leꞌa xa wa dub xa Samaria. ");
INSERT INTO zpt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Leꞌa Jesús cha ndab ndoꞌ be xmen na: —¿Ná lid dub tiꞌi bexa ta myakna wa zha? ¿Ma stub sgeꞌa bexa wa nat? ");
INSERT INTO zpt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Nabtsa dub xa naꞌanpa xa Israel ndee myach mlen msaꞌa xno ndoꞌ Dios? ");
INSERT INTO zpt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Leꞌa Jesús cha ndab ndoꞌ xa wa: —¡Gosoꞌ, cha byaꞌ! Leꞌa ta na mgeꞌ ladna lu naꞌ wa mbin myakna lu. ");
INSERT INTO zpt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Leꞌa bexa fariseo unabdiꞌizh ndoꞌ Jesús ná pol gal zha inibeꞌe Dios ndoꞌ gizhliyo. Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa zha inibeꞌe Dios naꞌanpa dub ta iniꞌí be men. ");
INSERT INTO zpt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lá yoo gan gab be men: “Unaꞌ go, leꞌa sa ndee sa nibeꞌe Dios”, no lá gab xa: “Leꞌa sa baꞌ sa nibeꞌe Dios.” Leꞌa naꞌ gáp leꞌa Dios nibeꞌela len ladoꞌo be men. ");
INSERT INTO zpt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Cha ndab Jesús ndoꞌ be xmen na: —Leꞌa gal zha leꞌa bega nlad iniꞌí naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, masa dub wizhtsa, parea leꞌa bega lá iniꞌí naꞌ zha wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Leꞌa ncho be men gab zha wa: “Leꞌa xa wa nsoꞌ sa ndee”, natal gab xa: “Leꞌa xa wa nsoꞌ sa baꞌ.” Parea lá yaꞌ bega ni lá isankea bega tsoꞌo xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Leꞌa lak nlaꞌ bealꞌ usiꞌi nsu‑yá xeꞌa itea lad gibeꞌa, no liga gak‑a zha ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Parea ned sian gealkweaꞌ nsabndoꞌ iní naꞌ, no be men ncho tiemp nat uxelad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Leꞌa lak ngok‑a tiemp uyoꞌo Noé, liga gak‑a gal zha ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Leꞌa tiemp na uyoꞌo Noé wa leꞌa be men ndeyaw, no ndo bexa, no ndeuchilyaꞌa bexa gast wizh uyoꞌo Noé len barco siꞌil mbindeꞌe Noé. Weꞌe ulen gilog mbit itea be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","No liga ngok‑a zha uyoꞌo Lot wa, ndeyaw bexa no ndo bexa no nsiꞌi bexa taꞌa no nadoꞌo bexa taꞌa no ndas bexa taꞌa no ndeyundeꞌe bexa lid bexa. ");
INSERT INTO zpt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ná leꞌa gor na utoꞌo Lot len gezh Sodoma wa, leꞌa Dios cha mtsoꞌol sa wa, cha ngut itea be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","’No liga gak‑a zha ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Leꞌa gal wizh weꞌe leꞌa be men ndiꞌib gek lid na wa nsabndoꞌ uxoꞌonbe, ni lá igen koꞌo xa be taꞌa len lid xa. Leꞌa bexa ndeyun tiꞌin geꞌe ni lá igen ilanseaꞌ ta lid na. ");
INSERT INTO zpt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Btseꞌa ladna bega lak ngwasea xagots ten Lot. ");
INSERT INTO zpt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Leꞌa tal ton ukwaꞌan xteꞌe wen yoo xa ndoꞌ gizhliyo ndee, leꞌa xa wa ndi gat. Ná leꞌa tal ton ndi ukwaꞌan gun ta nlad Dios, leꞌa xa wa sbanka. ");
INSERT INTO zpt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Leꞌa naꞌ gáp ndoꞌ bego, leꞌa teꞌal weꞌe leꞌa top xa ndeyats ndoꞌ dub loꞌon, cha yoꞌo Dios dubtsa xa, leꞌa stub xa wa yaꞌan. ");
INSERT INTO zpt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","No liga leꞌa top xagots junt ndeyajw, cha yoꞌo Dios dubtsa xa, leꞌa stub xa wa yaꞌan. ");
INSERT INTO zpt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","No liga leꞌa top xabgiꞌi junt ndeyun tiꞌin geꞌe, cha yoꞌo Dios dubtsa xa, leꞌa stub xa wa yaꞌan. ");
INSERT INTO zpt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Weꞌe leꞌa be xmen Jesús cha unabdiꞌizh, ndab bexa: —Señor, ¿pa yoo ta wa zha? Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa lak sa nyakjunt be bech nluu leꞌa sa wa nax dub man ngut, no liga leꞌa zha ilengal naꞌ leꞌa itea be men iniꞌí‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","No msaktabeꞌe Jesús dub ta mluu xa ndoꞌ be xmen xa, ndontsa mas uxik bexa gudiꞌizhno bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ndab xa: —Leꞌa dub gezh uyoꞌo dub juez ni lá ndap mod ndoꞌ Dios no ni ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Leꞌa gezh wa nchoga dub xagots ngut xabgiꞌi ten na. Leꞌa xagots wa cha ngwaꞌusake dub xa nyono xa ndoꞌ juez wa, gun juez regl ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Leꞌa kwenla leꞌa juez lá kaꞌab gun ta nlad xagots wa, parea ngol gor mbinbeꞌe juez, ndab xa: “Naꞌ ni ndoꞌ Dioska lá ndap mod no ni ndoꞌ be men, ");
INSERT INTO zpt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","parea leꞌa naꞌ neꞌe ladna tant ndiꞌid xagots ndee ndoꞌ naꞌ. Nat gun naꞌ ta nlad xa, ndontsa yá lá giꞌidta xa, leꞌa naꞌ ngi saklola ndoꞌ xa.” ");
INSERT INTO zpt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Leꞌa Jesús cha ndab: —Blaꞌach bego xteꞌe ndab juez wa, ná xa dub xa ugap nak. ");
INSERT INTO zpt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nsak bega zha leꞌa Dios lá gakno bexa mti Dios, bexa na teꞌal tezhea nab ndoꞌ Dios gakno Dios xa? ¿Nsak bega zha kwenpa ti ikaꞌab Dios ndoꞌ bexa wa? ");
INSERT INTO zpt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Leꞌa naꞌ gáp ndoꞌ bega leꞌa Dios uxax sakno bega. Ná leꞌa gor na ilengal naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ¿bi szheal naꞌ men ngeꞌ ladna Dios ndoꞌ gizhliyo zha wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Leꞌa wats Jesús nde pla bexa ndanbeꞌe leꞌa mas ndun be ta wen ndoꞌ lak ndun be ltsaꞌa bexa. Leꞌa Jesús cha mbidiꞌizh ndoꞌ bexa wa, msaktabeꞌe xa dub taꞌa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Leꞌa top xabgiꞌi utoꞌo nchaꞌyadiꞌizhno Dios tale ten niꞌi ten Dios. Leꞌa dub xa wa xa fariseo, leꞌa stub xa wa xa nsen med nkix be men ndoꞌ gobier. ");
INSERT INTO zpt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Leꞌa xa fariseo wa cha usoꞌ ndab ndoꞌ Dios: “Dios, leꞌa naꞌ nsa xno ndoꞌ go, geal leꞌa naꞌ lá ndun lak ndun be men xaꞌaga, bexa na ndun gealwaꞌan no bexa ugap ndanno be men no bexa na ngal stub xa naꞌanpa xagots ten xa. No ni lá nak naꞌ lak nak xa nsen med baꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Leꞌa naꞌ lá ndaw top wizh kad dub len sman, no nsa naꞌ diezmo ten itea be tiꞌin ndun naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Ná leꞌa xa nsen med wa sittsa nsoꞌ. Ni lá nwiꞌi xa gaꞌap, ndi msagolp xa ladoꞌo xa tant kweaꞌ ncho ladna xa, cha ndab xa: “Dios, blats ladna go naꞌ, leꞌa naꞌ sian ta ugap ndun.” ");
INSERT INTO zpt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Leꞌa naꞌ gáp ndoꞌ bega leꞌa xa nsen med wa wen myaꞌan ndoꞌ Dios gor na mlanseaꞌ xa ta lid xa. Ná leꞌa xa fariseo wa naꞌanpa wen myaꞌan ndoꞌ Dios. Leꞌa tal ton gab leꞌa nsak, leꞌa cuent ten Dios leꞌa xa wa naꞌanpa nsak. Ná leꞌa tal ton yak tuzh, leꞌa cuent ten Dios leꞌa xa wa nsakka. ");
INSERT INTO zpt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","No ulenno be men be meꞌed ten na wats Jesús, ndontsa uxoꞌob Jesús yaꞌa na gek be meꞌed, inab xa ulaꞌach Dios be meꞌed wa. Leꞌa gor uniꞌí be xmen Jesús li nseabeno be men meꞌed wa, cha uteyo bexa be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ná leꞌa Jesús cha utezh be xmen na, cha ndab xa: —Blaꞌa bego giꞌid be meꞌed baꞌ wats naꞌ. Lá uka bego giꞌid be meꞌed, leꞌa sa nibeꞌe Dios yate bexa yak lak nak be meꞌed ndee. ");
INSERT INTO zpt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Leꞌa naꞌ gáp ndoꞌ bega, leꞌa tal ton lá ulaꞌa inibeꞌe Dios xa lak dub meꞌed, leꞌa xa wa nunk lá yate sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Weꞌe leꞌa dub xa nibeꞌe ten bexa judio cha unabdiꞌizh ndoꞌ Jesús ndab xa: —Mech wen, ¿xtaꞌan gun naꞌ ndontsa no naꞌ gap gealnaban ndoꞌ Dios, ta nunk lá idub? ");
INSERT INTO zpt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Leꞌa Jesús cha ukaꞌab ndab: —¿Xtaꞌan ngi wen ndab lu ndoꞌ naꞌ zha? Naꞌan ton wen ndoꞌ gizhliyo, ndon nabtsa Dios wen nak. ");
INSERT INTO zpt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Leꞌa lu yá uniꞌíka ta ndab ley ten Dios: “Lá ugal lu xa ten stubga men. Lá gut lu men. Lá gun lu gealwaꞌan. Lá gun lu gealkwiꞌin. Wankea xus lu nsea xnaꞌa lu.” ");
INSERT INTO zpt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Leꞌa xabgiꞌi wa cha ukaꞌab ndab: —Iteanak be ta wa ndunka naꞌ idub zha tuzhta naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Leꞌa gor na mbiꞌín Jesús ta wa, cha ndab Jesús ndoꞌ xa: —Stub taꞌa ndun jwalt gun lu: bdoꞌo itea be taꞌa ten lu, cha btseꞌa med wa ndoꞌ bexa uban nak. Weꞌe gap lu sian taꞌa ndoꞌ Dios. Cha utsea cha usankea tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Leꞌa gor na mbiꞌín xabgiꞌi wa ta wa, leꞌa xa uzhebpa uban myoꞌo ladna, geal leꞌa xa dub xa rikpa. ");
INSERT INTO zpt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Leꞌa gor na uniꞌí Jesús leꞌa xa uzhebpa uban myoꞌo ladna, cha ndab Jesús: —Uzhebpa ugan yate dub xa rik sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ndi mas lid bid itid dub came geꞌed xan dub yagux, ndoꞌ yak dub xa rik xa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Leꞌa bexa na mbiꞌín ta wa cha unabdiꞌizh bexa ndab bexa ndoꞌ Jesús: —¿Tonxá sun gan yate sa nibeꞌe Dios zhaga? ");
INSERT INTO zpt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Leꞌa Jesús cha ndab: —Leꞌa cuent ten nabtsa be men leꞌa‑yá lá yoo gan. Ná leꞌa cuent ten Dios leꞌa‑yá syoꞌoka gan. ");
INSERT INTO zpt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Weꞌe leꞌa Pedr cha ndab ndoꞌ Jesús: —Unaꞌ go, leꞌa besa mlaꞌa itea be taꞌa ndap besa, cha ndi usankea besa tsoꞌo ga. ");
INSERT INTO zpt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp ndoꞌ bega, leꞌa tal ton ulaꞌa inibeꞌe Dios xa, ta weꞌe nlaꞌa xa lid xa no xus xa no wit xa no xagots ten xa no xmeꞌed xa, ");
INSERT INTO zpt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","leꞌa xa wa mas sian be taꞌa ikaꞌa tiemp nat. No leꞌa tiemp tiꞌi ilen leꞌa xa wa gap gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Cha utezh Jesús isatibtop be xmen na, ndab xa: —Blaꞌach bego, leꞌa beuna nchaꞌbe Jerusalén, sa yoo itea be ta mkeꞌa bexa polta sakndoꞌ Dios cuent ten naꞌ ndee, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Leꞌa naꞌ yak cuent ndoꞌ yaꞌa bexa naꞌanpa xa judio. Leꞌa bexa wa usalad gunno naꞌ, no xela iníꞌi bexa ndoꞌ naꞌ, no uchukko bexa ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","No uzhebpa kin bexa naꞌ, weꞌe gut bexa naꞌ. Parea gal wizh yon leꞌa naꞌ ibangal ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ná leꞌa be xmen Jesús ni lá iniꞌí bexa xtaꞌan mbidiꞌizh Jesús, geal leꞌa ta wa dub ta lá yoo gan yakbeꞌena bexa. ");
INSERT INTO zpt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Leꞌa gor na yá nchaꞌlayaꞌ gax Jesús gezh Jericó, leꞌa toꞌo nes wa nsob dub xabgiꞌi lá naꞌ, nab xa med ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Leꞌa gor na mbiꞌín xa nchaꞌtid be men, cha unabdiꞌizh xa ndoꞌ bexa wa ná xtaꞌan ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Leꞌa bexa wa cha ndab: —Leꞌa sa ndee nseatid Jesús xa Nazaret. ");
INSERT INTO zpt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Weꞌe cha ugeꞌ ndab xa: —¡Jesús, xin David! ¡Blats ladna go naꞌ! ");
INSERT INTO zpt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Leꞌa bexa na nseabe ned wa cha uteyo xa wa ndab bexa: —Lá kwezhta lu xa baꞌ. Parea leꞌa xa ndi mas ugeꞌ ndab: —¡Xin David! ¡Blats ladna go naꞌ! ");
INSERT INTO zpt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Weꞌe leꞌa Jesús cha ngwaꞌisoꞌ, cha unibeꞌe xa yaꞌyoꞌo bexa xa lá naꞌ wa. Leꞌa gor na ulansea xa, cha unabdiꞌizh Jesús ndoꞌ xa ndab xa: ");
INSERT INTO zpt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Xtaꞌan nlad lu gunno naꞌ lu? Leꞌa xa cha ndab: —Señor, leꞌa naꞌ nlad inaꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Leꞌa Jesús cha ndab: —Nat myakna lu lak mgeꞌ ladna lu naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bi leꞌa gor wa leꞌa xa cha mnaꞌla, cha no xa usankea tsoꞌo Jesús, ndab xa leꞌa Dios uzheꞌeb dub Dios juert. No itea be men na uniꞌí ta wa noga li ndab. ");
INSERT INTO zpt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Leꞌa gor ulayaꞌ Jesús gezh Jericó, leꞌa xa nseatid len gezh wa. ");
INSERT INTO zpt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Leꞌa sa wa ncho dub xa rik nsaleaꞌ Zaqueo. Leꞌa xa wa xa nibeꞌe ten bexa nsen med, ta nkix be men ndoꞌ gobier Roma. ");
INSERT INTO zpt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Leꞌa xa nlad iniꞌí Jesús, parea leꞌa xa lá naꞌ Jesús tant kwaꞌad men nde sa wa, leꞌa xa wa dub xa uxuꞌubma. ");
INSERT INTO zpt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Cha uxax mned xa ndoꞌ be men wa, cha ukea xa ndoꞌ dub ya sicómoro sa itid Jesús ndontsa iniꞌí xa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Leꞌa gor ulayaꞌ Jesús sa wa, cha mwiꞌi xa gaꞌap ndoꞌ ya wa, cha ndab xa ndoꞌ xa wa: —Zaqueo, uxax ulaꞌ sa baꞌ, leꞌa teꞌal ndee leꞌa naꞌ nsabndoꞌ yoꞌo ta lid lu. ");
INSERT INTO zpt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Leꞌa Zaqueo cha uxax ulaꞌ, nten ladna xa mbiꞌi xa Jesús ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Leꞌa gor uniꞌí be men ta wa, itea bexa ndenisi Jesús, ndab bexa leꞌa Jesús uyote len lid dub xa ugap. ");
INSERT INTO zpt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngol gor leꞌa Zaqueo cha usoꞌ ndab ndoꞌ Jesús: —Bwiꞌi go Señor, leꞌa naꞌ usa itol be taꞌa ndap naꞌ ndoꞌ bexa uban nak. No tal ncho xa mbin waꞌan naꞌ med ten na, leꞌa naꞌ yun cuent med wa gast dap biaj. ");
INSERT INTO zpt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Leꞌa Jesús cha ndab ndoꞌ Zaqueo: —Nat leꞌa Dios mtsuꞌu ke ten lu no ke ten bexa ltsaꞌa lu, geal leꞌa lu ngeꞌ ladna Dios lak mgeꞌ ladna Abraham Dios. ");
INSERT INTO zpt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ndalkwan bexa sit nak wats Dios, ndontsa ko naꞌ bexa ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Leꞌa bexa na ndeyoꞌón ta ndadiꞌizh Jesús wa ndanbeꞌe leꞌa tiemp inibeꞌe Dios ndoꞌ gizhliyo yamer ilen. Ta weꞌe leꞌa Jesús cha msaktabeꞌe stub taꞌa, geal leꞌa xa nsoꞌla gax sa nde Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ndab Jesús: —Uyoꞌo dub xabgiꞌi nsak. Leꞌa xa wa list nsoꞌ yaꞌ stubga nacion sit. Leꞌa sa wa leꞌa dub xa mas nibeꞌe usaꞌa permis gak xa rey leꞌaka lazh xa, leꞌa tsoꞌo wa cha yach xa. ");
INSERT INTO zpt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Leꞌa gor na biseata itoꞌo xa nsak wa, cha utezh xa dub tiꞌi xmos xa, cha msaꞌa xa dub gaꞌga med nsakpa gunno bexa tiꞌin ndalen li naꞌan xa. ");
INSERT INTO zpt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Parea leꞌa be men lazh xa wa nxee ladna ndoꞌ xa, cha mtuꞌub bexa dub men gab ndoꞌ xa mas nibeꞌe wa leꞌa bexa lazh xa nsak wa lá nlad leꞌa xa wa gak rey. ");
INSERT INTO zpt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Ná leꞌa xa mas nibeꞌe wa ulaxoꞌobka xa wa gak xa wa rey. Leꞌa gor na mlanseaꞌ xa lazh xa, cha utezh xa be xmos xa, bexa na li msaꞌa xa dub tiꞌi med nsak ndoꞌ na wa, ndontsa iniꞌí xa na xtiꞌin mbinno bexa ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Leꞌa mos ned wa ulen cha ndab: “Señor, leꞌa med li msaꞌa go wa myak dub tiꞌi‑yá.” ");
INSERT INTO zpt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Leꞌa rey wa cha ndab: “Uzhebpa wen lu mos. Leꞌa ta na li wen mbin lu tiꞌin nsea dub tuzh med ndee wa, ta weꞌe leꞌa nat leꞌa lu inibeꞌe dub tiꞌi gezh.” ");
INSERT INTO zpt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","No liga ulen xa itop wa, cha ndab xa: “Señor, leꞌa dub med li msaꞌa ga wa myak dub gaꞌay‑a.” ");
INSERT INTO zpt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Leꞌa rey wa cha ndab: “Leꞌa lu no inibeꞌe dub gaꞌay gezh.” ");
INSERT INTO zpt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Cha ulenga xa yon wa ndab: “Señor, ndee med ten go. Leꞌa naꞌ ndee ulochaꞌaw med ndee ndoꞌ dub bleꞌa lad. ");
INSERT INTO zpt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Leꞌa naꞌ nzheb ndoꞌ go, geal leꞌa naꞌ uní leꞌa go uzhebpa dub xa nibeꞌe. Nsen ga be taꞌa ni lid ta ten ga, no nteleꞌe ga be taꞌa ni lid go ngas.” ");
INSERT INTO zpt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Leꞌa rey wa cha ndab: “Leꞌa lu dub mos uzheꞌeb ugap. Leꞌa be diꞌizh ndab lu wa nluu leꞌa lu ugap ndun. Tal leꞌa lu uniꞌí leꞌa naꞌ ndee dub xa uzhebpa nibeꞌe, no nsen naꞌ be taꞌa ni lid ta ten naꞌ, no nteleꞌe naꞌ be taꞌa ni lid naꞌ ngas, ");
INSERT INTO zpt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿xtaꞌan lá ngaꞌulaꞌa lu med baꞌ banco, ndontsa nat nseal naꞌ isen naꞌ be xin med wa?” ");
INSERT INTO zpt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Cha ndab xa ndoꞌ bexa nde sa wa: “Blat bega med nsén xa baꞌ, cha bsaꞌa bega‑yá ndoꞌ xa nsén dub tiꞌi med baꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ná leꞌa bexa cha ndab: “Señor, leꞌa xa baꞌ yá ndapla dub tiꞌi‑yá.” ");
INSERT INTO zpt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Leꞌa rey cha ndab: “Leꞌa naꞌ gáp leꞌa tal ton utsin gun, leꞌa bexa mas sian taꞌa ikaꞌa. Ná leꞌa tal ton naꞌanpa utsin gun, leꞌa bexa slat be ta ndido ndap xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ná leꞌa bexa na li ndakloo ndoꞌ naꞌ wa, bexa na lá nlad gak naꞌ rey ten bexa, utseano bega bexa sa ndee. Cha ulobtoꞌog bega gen bexa.” ");
INSERT INTO zpt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Leꞌa gor na mtayadiꞌizh Jesús ta wa, cha nchaꞌata xa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Leꞌa gor na yá nsalayaꞌ gax bexa gezh Betfagé no gezh Betania, no gax Bet Olivo, cha mtuꞌub Jesús top be xmen na, ");
INSERT INTO zpt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ndab xa ndoꞌ bexa wa: —Waꞌ bega len gezh nde mas ndoꞌ ndee. Leꞌa gor na yate bega toꞌo gezh baꞌ, leꞌa sa baꞌ iniꞌí bega nsoꞌ nchii dub burr tuzh, dub ma ni dub men gol sob tsoꞌo ma. Cha uxaꞌak bega ma, goꞌo bega ma sa ndee. ");
INSERT INTO zpt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Leꞌa tal ton gab ndoꞌ bega ná xtaꞌan ngi burr baꞌ nxaꞌak bega, cha gud bega leꞌa Xa Nibeꞌe wa guntiꞌin ma. ");
INSERT INTO zpt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Weꞌe leꞌa be xmen Jesús wa cha nchaꞌbe. Cha mzheal bexa burr wa lakka ndab Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Leꞌa gor na ndeuxaꞌak bexa ma, leꞌa be xwan ma cha ndab: —¿Xtaꞌan nxaꞌak bega burr baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Leꞌa bexa cha ukaꞌab ndab: —Leꞌa Xa Nibeꞌe wa guntiꞌin ma. ");
INSERT INTO zpt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Cha mbiꞌi bexa ma wats Jesús. Cha mxoꞌob bexa dubga xab bexa tsoꞌo ma. Cha usob Jesús tsoꞌo ma. ");
INSERT INTO zpt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Leꞌa be men cha mte be lad nbix bexa ndoꞌ nes sa isea ma wa. ");
INSERT INTO zpt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Leꞌa gor na nchaꞌbelaꞌyoꞌo bexa Bet Olivo, leꞌa bexa kwaꞌad na nseabenkea tsoꞌo Jesús wa mten ladnabe, ugeꞌ ndab bexa leꞌa Dios uzheꞌeb dub Dios siꞌil, geal leꞌa bexa uniꞌí be uyon mbin Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ugeꞌ ndab bexa: —¡Dios uzhebpa nlaꞌach xa nibeꞌe baꞌ, xa na mtuꞌub Dios Xa Nibeꞌe! ¡Uzhebpa wen yoo be men ndoꞌ Dios gibeꞌa! ¡Siꞌil nak Dios nsob gaꞌap! ");
INSERT INTO zpt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Leꞌa lat be men wa no pla bexa fariseo nseabe, cha ndab bexa ndoꞌ Jesús: —Mech, uteyo ga be xmen ga baꞌ naꞌantapa li gab bexa. ");
INSERT INTO zpt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp leꞌa tal bexa ndee naꞌanpa iníꞌibe, leꞌa be geꞌ baꞌ leꞌa isaxan iníꞌi. ");
INSERT INTO zpt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Leꞌa gor na ulayaꞌ bexa sa nluxeꞌa Jerusalén, leꞌa Jesús cha mwiꞌi ndoꞌ gezh wa, cha mbiꞌin xa, ");
INSERT INTO zpt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ndab xa: —Gezh Jerusalén, uzhebpa nlad naꞌ yakbeꞌena lu ta ncho wizh nat, leꞌa ta wa leꞌa sun gan wen yoo lu. Parea leꞌa nat leꞌa lu lá yoo gan yakbeꞌena‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gal dub wizh ilen be men ukendoꞌ lu, gundeꞌe bexa dub muro idub gangeak wats lu, no idub gangeak kwe bexa ukendoꞌ bexa lu. ");
INSERT INTO zpt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cha ulate bexa lu Jerusalén, no bexa ncho sa baꞌ gatbe. Ni stub geꞌ ten lu lá kwiꞌibta tsoꞌo ltsaꞌa na, ke na lá igondoꞌ lu leꞌa Dios mbiꞌid ndoꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Leꞌa Jesús cha nchaꞌa tale ten niꞌi ten Dios, cha usaxan ngontuꞌub xa bexa na nadoꞌotiꞌix be taꞌa sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ndab Jesús: —Leꞌa diꞌizh ten Dios nkeaniꞌi ndab Dios: “Leꞌa lid naꞌ nak dub sa ndadiꞌizhno be men naꞌ.” ¡Ná leꞌa bego ndi ndanno‑yá cuent dub geꞌloꞌo ten waꞌan! ");
INSERT INTO zpt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Leꞌa Jesús itea wizh nluu be men wats niꞌi ten Dios, parea leꞌa be uleꞌay nibeꞌe, no be mech ten ley, no bexa nsak ten gezh wa nkwaꞌan ná xteꞌe gut bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Parea leꞌa bexa ni lá izheal xteꞌe gut bexa xa, geal leꞌa itea be men uzhebpa nlaꞌach ta nluu Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ngol stub wizh leꞌa Jesús nluugal be men tale ten niꞌi ten Dios, ndadiꞌizh xa diꞌizh wen ten Dios. Weꞌe leꞌa be mech ten ley, no be uleꞌay nibeꞌe, no bexa gox nsak ulen wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Cha ndab bexa ndoꞌ Jesús: —¿Ton ulaxoꞌob lu gun lu ta wa zha? ¿Nati ton mtuꞌub lu gun lu ta ndee? ");
INSERT INTO zpt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ no inabdiꞌizh dub taꞌa ndoꞌ bego, ikaꞌab bega‑yá: ");
INSERT INTO zpt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ton mtuꞌub Juan ulaleaꞌ Juan be men zha? ¿Dios nate dub men? ");
INSERT INTO zpt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Leꞌa bexa cha ndabbe ndoꞌ ltsaꞌa na: —Tal leꞌa beuna gab leꞌa Dios leꞌaka mtuꞌub Juan, leꞌa Jesús inabdiꞌizh ná xtaꞌan lá ngungea ladna beuna xa. ");
INSERT INTO zpt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ná tal gab beuna leꞌa Juan dub men mtuꞌub, leꞌa be men ndee ulaꞌgeꞌ beuna gast gat beuna, leꞌa bexa itea mbingea ladna leꞌa Juan dub xa mbidiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ta weꞌe cha ukaꞌab bexa ndab bexa ndoꞌ Jesús: —Leꞌa besa lá iniꞌí ton mtuꞌub Juan. ");
INSERT INTO zpt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Leꞌa Jesús cha noga ndab: —Naꞌ noga lá gáp ton ulaxoꞌob naꞌ gun naꞌ be ta ndee. ");
INSERT INTO zpt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cha mbidiꞌizh Jesús dub taꞌa msaktabeꞌe xa, ndab xa ndoꞌ be men: —Uyoꞌo dub xabgiꞌi ngos sian ya uv ndoꞌ dub bleꞌa yo siꞌil. Cha mkwaꞌan xa pla be men ulaꞌach sa wa, cha gal zha ite bexa uv usaꞌa ya wa. Leꞌa xa ten yo wa cha ukaꞌan kwenpa. ");
INSERT INTO zpt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Leꞌa zha na yá ngol tiemp ten uv, cha mtuꞌub xa dub xmos xa yaꞌ ndoꞌ be men nlaꞌach sa wa, yaꞌyoꞌo xa be ta na ndal xwan yo wa. Ná leꞌa be men wa ndi udin mos wa. Cha naꞌan xtaꞌan usaꞌa men wa yoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Leꞌa xwan yo wa cha mtuꞌubgal stub mos. Ná leꞌa bexa ndi uzheꞌeb udingal xa wa, cha naꞌan xtaꞌan usaꞌagal bexa yoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Leꞌa xwan yo wa mtuꞌubgal stub mos. Leꞌa be men wa cha ndi mtsawiꞌi xa, no ulantuꞌub bexa xa. ");
INSERT INTO zpt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Weꞌe leꞌa xwan yo wa cha mbinbeꞌe ndab xa: “¿Xteꞌe gun naꞌ nat? Leꞌa naꞌ utuꞌub xiꞌín naꞌ, xa na nkweaꞌ lad naꞌ. Leꞌa be men wa sapka mod ndoꞌ xa wa.” ");
INSERT INTO zpt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ná leꞌa gor na uniꞌí bexa xa, cha ndi ndab bexa ndoꞌ be ltsaꞌa xa: “Leꞌa xa baꞌ leꞌa yaꞌanno yo ndee. Nchaꞌyut beuna xa, cha yaꞌanno beuna‑yá.” ");
INSERT INTO zpt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cha uloꞌo bexa xa dub lad toꞌo yo wa, cha mbit bexa xa. Cha unabdiꞌizh Jesús ndab xa: —¿Xteꞌe nsak bega zha? ¿Xteꞌe gunno xwan yo wa bexa? ");
INSERT INTO zpt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Leꞌa xa wa ilen gut bexa wa, cha usaꞌa xa yo wa ndoꞌ be men xaꞌaga ulaꞌach‑a. Leꞌa gor na mbiꞌín be men ta wa, cha ndab bexa: —¡Dios nunk lá ulaꞌa yoo ta wa! ");
INSERT INTO zpt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Leꞌa Jesús cha mwiꞌi ndoꞌ bexa, cha ndab xa: —¿Lá iniꞌí bega xteꞌe nkeaniꞌi diꞌizh ten Dios zha? Ndab‑a: Leꞌa geꞌ na mxelad bexa ndandeꞌe niꞌi, leꞌa ta wa nat nak geꞌ ndon leꞌa nsak nbexan niꞌi. ");
INSERT INTO zpt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Leꞌa itea bexa na ilayat tsoꞌo geꞌ wa, leꞌa bexa wa syuꞌbe. Leꞌa bexa ilaꞌ geꞌ wa tsoꞌo na, leꞌa bexa wa sachkeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bi leꞌa gor wa leꞌa be uleꞌay nibeꞌe no be mech ten ley nlad isen Jesús, geal leꞌa bexa myakbeꞌena leꞌa Jesús li ndab cuent ten bexa. Ná leꞌa bexa nzhebga ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cha mtuꞌub bexa wa pla be men cuentta bexa wen nak yaꞌyun preb Jesús, ndontsa gap bexa dub ta usake bexa Jesús ndoꞌ xa na ndon leꞌa nibeꞌe sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Leꞌa bexa wa cha ndab ndoꞌ Jesús: —Mech, leꞌa besa uniꞌí leꞌa go ndadiꞌizh gealngea. No ni lá nlaꞌach go ta ndab be men, no ni tal xteꞌe nak be men. Leꞌa go ndi wen nluu lak nlad Dios gak be men. ");
INSERT INTO zpt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nat gud go, ¿nsabndoꞌ kix beuna med nab César xa nibeꞌe Roma, nate naꞌanpa kix beuna ta wa? ");
INSERT INTO zpt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ná leꞌa Jesús mgenlana ta ugap ndanbeꞌe bexa, cha ndab Jesús: —¿Xtaꞌan ndun bega preb naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Bsaꞌa bega dub med iwiꞌi naꞌ‑yá. ¿Ton gek ná no leaꞌ ná nkea las med ndee zha? Leꞌa bexa wa cha ukaꞌab ndab: —Gek César no leaꞌ César. ");
INSERT INTO zpt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Cha ndab Jesús: —Bsaꞌa bego be ta ten César ndoꞌ César. Leꞌa ndoꞌ Dios bsaꞌa bego be ta ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Leꞌa bexa wa ni lá ngun gan ngab Jesús dub ta lid leꞌa nak ndoꞌ gaꞌal be men wa. Ndi ngwanseana bexa xteꞌe ukaꞌab Jesús, cha yá naꞌanta xteꞌe ngab bexa. ");
INSERT INTO zpt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Weꞌe leꞌa pla bexa saduceo cha ulen wats Jesús. Leꞌa itea bexa saduceo ndangea ladna leꞌa bexa ngut wa yá lá ibantabe. Cha unabdiꞌizh bexa ndoꞌ Jesús, ");
INSERT INTO zpt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ndab bexa: —Mech, leꞌa ley mkeꞌa Moisés ndab leꞌa tal ton dub xabgiꞌi gat, ná lá ngap xa xin xa, leꞌa wit xa wa nsabndoꞌ uchilyaꞌano xagots ten xa ngut wa, ndontsa tal gap bexa dub meꞌed leꞌa meꞌed wa gak cuent xin xa ngut wa. ");
INSERT INTO zpt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Uyoꞌo dub gaꞌad wit xa. Leꞌa xa ned wa mchilyaꞌano dub xagots, cha tsoꞌo wa ngut xa, ni lá ngap xagots wa xin xa. ");
INSERT INTO zpt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Weꞌe cha mchilyaꞌano wit itop xa wa xagots wa. Leꞌa xabgiꞌi wa cha nogal ngut ni lá ngapgal bexa xin xa. ");
INSERT INTO zpt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Leꞌa wit yon bexa wa litsagal ngwasea. Li ngwasea isagaꞌad wit bexa wa, ná ni dub xa lá ngap xin na. ");
INSERT INTO zpt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsoꞌo wa leꞌa xagots wa cha noga ngut. ");
INSERT INTO zpt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Leꞌa zha na iban bexa ngut wa, leꞌa lat bexa wa ¿ton gak xabgiꞌi ten xagots wa zha, xa na li mchilyaꞌano isagaꞌad xabgiꞌi wa? ");
INSERT INTO zpt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa be men nde ndoꞌ gizhliyo ndee nchilyaꞌano ltsaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Parea gal zha na gab Dios ná ton iban ndoꞌ gealgut, leꞌa bexa wa naꞌantapa uchilyaꞌano be ltsaꞌa na zha wa. ");
INSERT INTO zpt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","No ni lá gatta bexa, leꞌa bexa ndi gak cuent be angel ten Dios. No gak bexa xin Dios ta na ubangal bexa. ");
INSERT INTO zpt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Parea leꞌa cuent ten ta na iban bexa ngut wa, leꞌa Moisés leꞌa mluu leꞌa bexa ngut wa ibankabe, zha na mkeꞌa xa leꞌa dub yagich nsayolꞌ. Leꞌa sa wa ndab‑a leꞌa Dios nak Dios ndankea Abraham, no Isaac, no Jacob. ");
INSERT INTO zpt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Leꞌa Dios naꞌanpa Dios ten bexa ngut, leꞌa xa ndi Dios ten bexa nban. Ta weꞌe uniꞌí beuna leꞌa bexa wa nbanka. Leꞌa cuent ten Dios leꞌa itea bexa ngutla bi nbankabe. ");
INSERT INTO zpt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Leꞌa ncho be mech ten ley cha ndab ndoꞌ Jesús: —Mech, leꞌaka nak ta ndab go. ");
INSERT INTO zpt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Weꞌe leꞌa be men wa ni lá ngunta rages inabdiꞌizh bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Weꞌe cha ndab Jesús ndoꞌ bexa wa: —¿Xtaꞌan ndab be men leꞌa zha ilen Cristo leꞌa xa wa nak xin David? ");
INSERT INTO zpt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ná leꞌa David wa leꞌaka mkeꞌa libr ten Salmos, ndab‑a: Leꞌa Dios Xa Nibeꞌe ndab ndoꞌ Xa Nibeꞌe naꞌ: “Usob wats naꞌ lad gaꞌal ndee, ");
INSERT INTO zpt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gast gal gor ute naꞌ bexa ndaklono lu xan ndats lu.” ");
INSERT INTO zpt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Leꞌa David ndab leꞌa Cristo nak Xa Nibeꞌe ten xa. ¿Ná xteꞌe yoo gan gak Cristo wa xin David zha? ");
INSERT INTO zpt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Leꞌa gor na ndeulaꞌach itea be men wa, leꞌa Jesús cha ndab ndoꞌ be xmen na: ");
INSERT INTO zpt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Blaꞌach bego lá gak bega lak nak be mech ten ley, leꞌa bexa ndal ladna ndesea nak lad koꞌol. No nlad bexa utsin inidiꞌizh be men ndoꞌ bexa be ndoꞌ xgeꞌe. No nti bexa be sa mas nsak isob bexa len be niꞌi sa nzhealbe beuna xa judio. No liga ndun bexa sa ndaꞌdaw bexa sa nyoꞌo dub gast. ");
INSERT INTO zpt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nsea nlat bexa itea ta ndap be xagots ngut xabgiꞌi ten na. No kwenpa ndadiꞌizhno bexa Dios ndontsa gab men leꞌa xa ndankeaka Dios. Leꞌa naꞌ gáp leꞌa bexa li ndun wa mas uzheꞌeb gealkweaꞌ iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Leꞌa Jesús cha mwiꞌi ná xteꞌe nsaꞌa be men rik wa med gon gax wats niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Leꞌa dub xagots prob ngut xabgiꞌi ten na no msaꞌa top med byux uxee nsak. ");
INSERT INTO zpt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp leꞌa xagots prob ndee msaꞌa mas sian med ndoꞌ iteanak bexa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Leꞌa bexa msaꞌa sbeꞌen ta myaꞌan sobrtsa, parea leꞌa xagots ndee msaꞌa iteanak med isiꞌi xa be ta nkiꞌin xa. ");
INSERT INTO zpt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Leꞌa ncho bexa ndadiꞌizh ndoꞌ Jesús cuent ten be geꞌ chul nakchaꞌaw niꞌi ten Dios, no be ta chul msaꞌa be men usaxkwaꞌa sa wa. Leꞌa Jesús cha ndab ndoꞌ bexa wa: ");
INSERT INTO zpt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Leꞌa gal dub wizh leꞌa itea be ta lbaꞌa naꞌ bego baꞌ ilate, gast ni stub geꞌ baꞌ lá kwiꞌibta tsoꞌo ltsaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Leꞌa bexa wa cha unabdiꞌizh ndoꞌ Jesús ndab bexa: —Mech, ¿pol gak ta wa zha? ¿Xteꞌe iniꞌí besa zha yamer gak‑a zha? ");
INSERT INTO zpt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Leꞌa Jesús cha ukaꞌab ndab: —Blaꞌach bego naꞌan ton ukedino bega. Leꞌa kwaꞌad be men ilen gab leꞌa xa nak Cristo xa na mtuꞌub Dios. No gab bexa leꞌa tiemp wa yá nsoꞌ gax. Parea lá isankea bega tsoꞌo bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Leꞌa gor na goꞌón bega ncho guerr no ncho be men ndakloo ndoꞌ bexa nibeꞌe bexa, lá yuꞌ ladna bega. Leꞌa ta wa ga nedka nsabndoꞌ li gak, ná leꞌa zha wa biseata gal be wizh lult. ");
INSERT INTO zpt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","No ndab Jesús: —No gal zha wa kuyo be nacion no stubga nacion. Leꞌa be xmen dub xa nibeꞌe kuyono be xmen stubga xa nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","No gak be xoꞌo ubiꞌi. No ncho be sa uzhebpa yoo win no gealgizh ugiꞌi. Leꞌa gibeꞌa iluu be ta yanseana be men no izheb bexa. ");
INSERT INTO zpt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ná leꞌa gor na biseata yoo itea be ta ndee, leꞌa be men isen bega, no isankea bexa tsoꞌo bega, no goꞌo bexa bega len be niꞌi sa nzhealbe bexa judio, sa usake bexa bega. No goꞌo bexa bega litgiꞌib, no usake bexa bega ndoꞌ bexa naktiꞌin ubiꞌi ke na nak bega xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Weꞌe sak gudiꞌizh bega diꞌizh ten naꞌ ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ná lá gunbeꞌe bega xteꞌe utsakndoꞌ bega ikaꞌab bega ndoꞌ bexa wa, ");
INSERT INTO zpt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","leꞌa naꞌ usa be diꞌizh ikaꞌab bega, ta na ni dub bexa nyono bega lá gun gan ikaꞌab. Ni lá yoo gan gab bexa leꞌa ta ndab bega wa naꞌanpa utsin nak. ");
INSERT INTO zpt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Leꞌa ncho xus bega no wit bega no ltsaꞌa bega no amig ten bega leꞌaka yun cuent bega. No gast gut bexa ncho bega. ");
INSERT INTO zpt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Leꞌa itea be men ixeeno ladna bega ke na nak bega xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ná leꞌa naꞌ gáp ni dub gichgek bega lá gak perdid. ");
INSERT INTO zpt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Leꞌa tal bega uxik ndoꞌ be gealkweaꞌ wa, leꞌa bega gal usoꞌ gealnaban nsaꞌa Dios. ");
INSERT INTO zpt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Leꞌa gor inaꞌ bega leꞌa kwaꞌad be soldad nde gangeak Jerusalén ndee, weꞌe iniꞌíla bega leꞌa tiemp initndoꞌ Jerusalén yá ngol. ");
INSERT INTO zpt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Leꞌa bexa ndencho Judea nsabndoꞌ uxoꞌonbe yaꞌbe bexa be geꞌe ubiꞌi. Leꞌa bexa ndencho Jerusalén uxoꞌon gezh ndee. Leꞌa bexa ndesea geꞌe yá lá ilenta xa sa ndee. ");
INSERT INTO zpt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Leꞌa zha wa uzhebpa iniꞌí bexa gealkweaꞌ, no gakka itea be ta nkeaniꞌi diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Leꞌa be xagots nsoꞌno meꞌed no be xagots ndap medoꞌo uzhebpa kweaꞌ itid. Leꞌa be men uzhebpa gealkweaꞌ siꞌil iniꞌí zha wa, no uzhebpa juert yoo bexa ncho sa ndee. ");
INSERT INTO zpt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Leꞌa kwaꞌad bexa Israel gat ndoꞌ spad, no sit goꞌo be men kwaꞌad bexa wa stub nacion xaꞌaga. Leꞌa bexa naꞌanpa xa Israel gunno Jerusalén ndee lakta nlad bexa, gast gal wizh idub tiemp ulaꞌa Dios li gun bexa ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Leꞌa wizh no mbeꞌe no be mbeal xaꞌaga inaꞌ ndoꞌ lak naꞌ‑yá nat. Leꞌa be men ncho ndoꞌ gizhliyo uzhebpa izheb, no ni lá iniꞌí bexa xteꞌe gun bexa tant uzheꞌeb nbezh nitsdoꞌo no be golp ten nits. ");
INSERT INTO zpt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Leꞌa be men gast itid teꞌal ladna tant izheb bexa iniꞌí bexa be ta yoo ndoꞌ gizhliyo, no gast idub gibeꞌa iwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Weꞌe leꞌa be men iniꞌí leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ilennogal juers ten Dios lat xkaw nsea dub xeꞌa siꞌil. ");
INSERT INTO zpt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Leꞌa gor na isaxan yoo be ta ndee lá izheb bega, ndi bten ladna bega leꞌa naꞌ yamer ilen. ");
INSERT INTO zpt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","No ndab Jesús: —Bwiꞌi bega lak nak be ya laꞌaw no itea be ya. ");
INSERT INTO zpt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Leꞌa zha na li nxich be ya wa, leꞌa bega uniꞌíka leꞌa tiemp bigi yá gal. ");
INSERT INTO zpt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","No liga zha na naꞌ bega ncho be ta ndee wa, weꞌe iniꞌí bega leꞌa tiemp inibeꞌe Dios ndoꞌ gizhliyo yamer ilen. ");
INSERT INTO zpt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Leꞌa naꞌ gáp ndoꞌ bego leꞌa itea be ta ndee itidka zha na biseata gat be men ncho tiemp ndee wa. ");
INSERT INTO zpt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Leꞌa gibeꞌa nsea gizhliyo initndoꞌ, parea leꞌa be ta ndáp naꞌ ndee naꞌanpa initndoꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Blaꞌach bega leꞌaka bega naꞌanpa gaw bega uzheꞌeb, no naꞌanpa gun bega gealgu, no ni lá yuꞌ ladna bega be ta ndoꞌ gizhliyo ndee. Ndi list ute bega, leꞌa wizh weꞌe uxax ilen tsoꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Leꞌa wizh wa ilenka cuent dub tramp tsoꞌo be men ncho idub ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ta weꞌe list ute bega, bidiꞌizhno tseꞌe bega Dios, ndontsa uxik bega ndoꞌ itea be ta uzheꞌeb yoo ndoꞌ gizhliyo ndee, no gun bega gan kwe bega ndoꞌ naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Itea be wizh leꞌa Jesús nluu be men tale ten niꞌi ten Dios. Leꞌa gor teꞌal leꞌa xa ndaꞌ Bet Olivo. ");
INSERT INTO zpt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Leꞌa iteanak be men Jerusalén wa itea tempran ndaꞌyoꞌón bexa ta ndadiꞌizh Jesús tale ten niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Leꞌa zha na nsayal gax ujest Pascua, zha ndaw bexa judio pan lá nyoꞌo levadur, ");
INSERT INTO zpt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","leꞌa be uleꞌay nibeꞌe wa no be mech ten ley nkwaꞌan bexa na xteꞌe gut bexa Jesús dub mod lá iniꞌí be men‑a, geal leꞌa bexa nzheb ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Leꞌa maxuꞌu cha uyoꞌo len ladoꞌo Judas Iscariot, dub xa nak dub isatibtop be xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cha ngwaꞌyadiꞌizhno xa be uleꞌay nibeꞌe, no bexa nibeꞌe ten bexa nlaꞌach niꞌi ten Dios, ná xteꞌe yun xa cuent Jesús ndoꞌ yaꞌa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Leꞌa bexa wa cha mten ladnabe, ndab bexa leꞌa bexa usaꞌa med ikaꞌa Judas. ");
INSERT INTO zpt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Leꞌa Judas cha uni lak ndab bexa wa, cha usaxan nkwaꞌan xa xteꞌe yun xa cuent Jesús, dub mod na lá iniꞌí be men ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Leꞌa ngol wizh ndaw bexa judio pan lá nyoꞌo levadur, wizh ndut bexa dub borreg ndaw bexa cuent ten ujest Pascua, ");
INSERT INTO zpt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","leꞌa Jesús cha mtuꞌub Pedr no Juan, ndab xa: —Waꞌyundeꞌe bega ta gaw beuna ujest Pascua. ");
INSERT INTO zpt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Leꞌa bexa wa cha unabdiꞌizh ndoꞌ Jesús, ndab bexa: —¿Pa nlad go gundeꞌe besa ta wa zha? ");
INSERT INTO zpt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Leꞌa Jesús cha ndab: —Waꞌ bega gezh Jerusalén baꞌ, leꞌa toꞌo gezh wa izheꞌal bega dub xabgiꞌi noꞌo dub te ncho nits. Cha isankea bega tsoꞌo xa gast len niꞌi sa ilanseaꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cha gud bega ndoꞌ xwan niꞌi wa: “Leꞌa mech nabdiꞌizh ná ma len cuart gawno mech be xmen xa ta ten ujest Pascua.” ");
INSERT INTO zpt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Leꞌa xa wa cha uluu dub cuart siꞌil ndoꞌ bega, ta nde gek niꞌi wa. Leꞌa sa wa listla nde be ta guntiꞌin bega. Cha bindeꞌe bega be ta gaw xcheꞌe beuna sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Weꞌe leꞌa Pedr no Juan cha nchaꞌbe, cha mzhealka bexa men wa, no be ta ndab Jesús wa. Cha mbindeꞌe bexa ta gaw bexa ujest Pascua. ");
INSERT INTO zpt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Leꞌa ngol gor gaw xcheꞌe bexa, cha usob Jesús ndoꞌ mes no be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Cha ndab Jesús: —Uzhebpa nten lad naꞌ gawnogal naꞌ bega cuent ten ujest Pascua nattsa biseata gat naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Li ndáp naꞌ ta wa geal leꞌa naꞌ yá naꞌantapa gaw cuent ten ujest ndee, gast gal tiemp inibeꞌe Dios ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Cha usen Jesús dub vas ncho vin ten uv, cha msaꞌa xa xno ndoꞌ Dios, cha ndab xa: —Itea bego gu ta ndee. ");
INSERT INTO zpt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Leꞌa naꞌ gáp ndoꞌ bega leꞌa naꞌ yá lá goꞌota vin ten uv gast gal zha ilen tiemp inibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cha liga usen xa pan, cha msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa‑yá, msaꞌa xa‑yá ndoꞌ bexa wa, ndab xa: —Leꞌa pan ndee beꞌal las naꞌ, ta usa naꞌ por bego. Nat isaxan bega gun bega ta ndee, ndontsa lá yalad bega leꞌa naꞌ ngut sakndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Leꞌa gor na mtayaw xcheꞌe bexa, cha usengal Jesús dub vas ncho vin, ndab xa: —Leꞌa ta ndee ten ten naꞌ usa naꞌ por bego. Leꞌa ta ndee nluu leꞌa nat leꞌa Dios mbinno be men dub trat kub, ná xteꞌe wen yaꞌan bexa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ná leꞌa nat leꞌa xa na yun cuent naꞌ no nsob ndoꞌ mes ndee. ");
INSERT INTO zpt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, itiꞌidka lak nsabndoꞌ‑yá, parea proꞌob xabgiꞌi na yun cuent naꞌ ndoꞌ yaꞌa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Cha usaxan be xmen Jesús unabdiꞌizh ndoꞌ be ltsaꞌa na, ndab bexa: —¿Tonma beuna nde ndee yun cuent xa? ");
INSERT INTO zpt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Leꞌa be xmen Jesús cha usaxan ndeyotoꞌo lat be ltsaꞌa na ná ton mas nsak. ");
INSERT INTO zpt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ná leꞌa Jesús cha ndab: —Leꞌa bexa nibeꞌe be nacion naꞌanpa ulaꞌa gun be men dub ta naꞌanpa nibeꞌe bexa. Leꞌa bexa wa leꞌatsa ndab leꞌa bexa uzhebpa be ta wen ndun. ");
INSERT INTO zpt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Parea leꞌa bego ndee naꞌanpa nsabndoꞌ li gak. Leꞌa bexa mas nsak wa nsabndoꞌ ndi gak cuent dub xa ndon leꞌa tuzh. Leꞌa dub xa nibeꞌe wa nsabndoꞌ gun tiꞌin ndoꞌ iteata bega. ");
INSERT INTO zpt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ton mas nsak? ¿Xa nsob ndoꞌ mes, nate xa ndun tiꞌin ndoꞌ xa wa? Leꞌa xa nsob ndoꞌ mes wa, leꞌa xa mas nsak. Parea leꞌa naꞌ ndee nkeseano bega cuent dub xa ndun tiꞌin ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Leꞌa bego leꞌakama nak bexa mxik ndoꞌ itea be ta ugan utiꞌid naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ta weꞌe leꞌa naꞌ usa juers ndoꞌ bega ndontsa inibeꞌe bega, lak nsaꞌa Xus naꞌ ta nibeꞌe naꞌ, ");
INSERT INTO zpt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ndontsa gaw bega no goo bega ndoꞌ mes ten naꞌ sa inibeꞌe naꞌ. No kadga dub bega isob sa inibeꞌe bega ndoꞌ isatibtop xkwaꞌa bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","No ndab Jesús ndoꞌ Simón Pedr: —Simón, Simón, leꞌa maxuꞌu unab bega ndoꞌ Dios gunno maxuꞌu bega lak ngoꞌo bexa xab trig. ");
INSERT INTO zpt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Parea leꞌa naꞌ naꞌab ndoꞌ Dios gakno lu, lá ulaꞌa lu ta ngeꞌ ladna lu naꞌ. Leꞌa gor na yach lu stub biaj igeꞌ ladna lu naꞌ, gokno be ltsaꞌa lu dubtsa kwe bexa igeꞌka ladna bexa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Leꞌa Simón cha ndab: —Señor, leꞌa naꞌ saano go gast litgiꞌib, no tal go gat leꞌa naꞌ no gat. ");
INSERT INTO zpt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Leꞌa Jesús cha ndab ndoꞌ xa: —Pedr, leꞌa naꞌ gáp ndoꞌ lu, leꞌa teꞌal nat gor biseata kwezh boy, leꞌa lu mkwiꞌinla chon biaj, ndab lu leꞌa lu lá nchandoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","No ndab Jesús ndoꞌ be xmen na: —Leꞌa zha na mtuꞌub naꞌ bego li lá ngoꞌo bega bols, no ni med, no ni stub nes ndab bega, ¿ncho xtaꞌan mbin jwalt zha wa zha? Leꞌa bexa cha ukaꞌab ndab: —Naꞌan xtaꞌan ngun jwalt zha wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cha ndab Jesús: —Leꞌa nat leꞌa bego na ndap bols no med, biꞌi bega‑yá. Leꞌa bego na lá ndap spad, bdoꞌo bega dub xab bega cha usiꞌi bega dub spad. ");
INSERT INTO zpt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Leꞌa lak nkeaniꞌi diꞌizh ten Dios cuent ten naꞌ, leꞌa ta wa gakka cumplir. Leꞌa ta wa ndab: “Leꞌa be men mbinno xa cuentta dub xa ugap.” Leꞌa itea be ta ndab diꞌizh ten Dios cuent ten naꞌ wa, leꞌa ta wa gakka cumplir. ");
INSERT INTO zpt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Leꞌa be xmen Jesús cha ndab ndoꞌ xa: —Señor, leꞌa sa ndee nde top spad. Leꞌa Jesús cha ukaꞌab ndab: —Yá lá gudiꞌizhta beuna ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cha utoꞌo Jesús nchaꞌa Bet Olivo lakka ndun xa. Leꞌa be xmen xa cha no usankea tsoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Leꞌa gor na ulayaꞌ bexa sa wa, cha ndab Jesús ndoꞌ bexa: —Unab bega ndoꞌ Dios gakno bega, ndontsa naꞌanpa utsabgix maxuꞌu bega. ");
INSERT INTO zpt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Cha nab Jesús usea stub tuzh sa, dub lak sit ntsaꞌab men dub geꞌ. Leꞌa sa wa leꞌa Jesús cha usaxib mbidiꞌizhno xa Dios, ");
INSERT INTO zpt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ndab xa: —Xus naꞌ, tal leꞌa go nlad, lá ulaꞌa go itiꞌid naꞌ ndoꞌ be gealkweaꞌ uzheꞌeb ndee. Parea lá gak‑a lak nlad naꞌ, ndi gak‑a lak nlad go. ");
INSERT INTO zpt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Weꞌe cha mlundoꞌ dub angel utoꞌo gibeꞌa msaꞌa juers ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Leꞌa ta na uzhebpa kweaꞌ ncho ladna Jesús, leꞌa xa mas uzheꞌeb mbidiꞌizhno Dios. Leꞌa nits msanits ndoꞌ xa nsalaꞌ gast ndoꞌ yo cuent byach ten. ");
INSERT INTO zpt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Leꞌa gor na mtayadiꞌizhno xa Dios, cha nseaꞌ xa sa ndebe be xmen xa. Ná leꞌa bexa ndeyatsbe tant uban ncho ladna bexa. ");
INSERT INTO zpt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Leꞌa Jesús cha ndab: —¿Xtaꞌan ndi ndeyats bega zha? Goste bega, unab bega ndoꞌ Dios, ndontsa naꞌanpa utsabgix maxuꞌu bega. ");
INSERT INTO zpt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bi li nsoꞌyab Jesús ta wa leꞌa kwaꞌad be men ulen. Leꞌa Judas xa no nak isatibtop xmen Jesús leꞌa nsea ned ndoꞌ be men wa. Cha ubii xa, cha mchealtoꞌo xa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Leꞌa Jesús cha ndab: —Judas, ¿lbaꞌa myun lu cuent naꞌ Xa Myak Men Ndoꞌ Gizhliyo zha? ");
INSERT INTO zpt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Leꞌa bexa ndeno Jesús uniꞌí ta wa, cha ndab bexa: —Señor, ¿kuyono besa bexa no be spad ndee zha? ");
INSERT INTO zpt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Leꞌa dub bexa wa cha ulobtoꞌog nchaꞌ lad gaꞌal dub xa ndun tiꞌin ndoꞌ uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Leꞌa Jesús cha ndab ndoꞌ be xmen na: —Unika‑yá. Blaꞌa bego bexa baꞌ. Leꞌa Jesús cha mgal nchaꞌ xa wa, cha myakna‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Cha ndab Jesús ndoꞌ be uleꞌay nibeꞌe, no ndoꞌ bexa nibeꞌe ten bexa nlaꞌach niꞌi ten Dios, no ndoꞌ bexa gox nsak, bexa na nseabegiꞌi Jesús, ndab xa: —¿Xtaꞌan nseano bega spad nsea garrot, nseabesen bega naꞌ cuent dub waꞌan? ");
INSERT INTO zpt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Leꞌa itea wizh mluu naꞌ be men tale ten niꞌi ten Dios lat bega, ná naꞌan xtaꞌan ngunno bega naꞌ. Parea leꞌa nat ngolka gor ten bega, gor na gun maxuꞌu ta nlad na. ");
INSERT INTO zpt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Cha usen bexa Jesús, cha mbiꞌi bexa xa ta lid uleꞌay ndon leꞌa nsak. Leꞌa Pedr sittsa nchankea tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Leꞌa tlaw le ta lid uleꞌay wa mkwaꞌa bexa giꞌ, cha ute pla bexa wats giꞌ wa. Leꞌa Pedr cha no usob wats bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Leꞌa dub xagots ndun tiꞌin sa wa uniꞌí nsob Pedr sa wa, cha ndab xa ndoꞌ bexa wa: —Leꞌa xa ndee no nkeseano Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ná leꞌa Pedr cha mkwiꞌin ndab: —Xagots, naꞌ lá nchandoꞌ ton xa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tsoꞌoma wa leꞌa stub xabgiꞌi wa uniꞌígal Pedr, cha ndab xa ndoꞌ Pedr: —Go no nak xmen Jesús. Leꞌa Pedr cha mkwiꞌingal ndab: —Mgiꞌi, leꞌa naꞌ naꞌanpa no. ");
INSERT INTO zpt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ngok pa stub gor tsoꞌo wa, leꞌa stub xa ndabgal ndoꞌ be ltsaꞌa na cuent ten Pedr: —Leꞌa xa ndee ta ugeaka no ukeseano Jesús, leꞌa xa ndee xa Galilea. ");
INSERT INTO zpt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Leꞌa Pedr cha ndab: —Mgiꞌi, leꞌa naꞌ lá iní xtaꞌan ndab lu. Bi li gor wa zha leꞌa dub boy utezhla. ");
INSERT INTO zpt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Leꞌa Jesús cha mgeak mwiꞌi ndoꞌ Pedr. Leꞌa Pedr cha mtseꞌa ladna ta ndab Jesús: “Leꞌa teꞌal nat gor na biseata kwezh boy, leꞌa lu mkwiꞌinla chon biaj ndab lu leꞌa lu lá nchandoꞌ naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Cha utoꞌo Pedr tsoꞌo juer, cha uzhebpa mbiꞌin xa. ");
INSERT INTO zpt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Leꞌa be xabgiꞌi na li ndeulaꞌach Jesús wa kweaꞌ uníꞌi ndoꞌ Jesús, no udin bexa xa. ");
INSERT INTO zpt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","No mtsaw bexa ndoꞌ Jesús, cha utichyaꞌa bexa ndoꞌ xa, ndab bexa ndoꞌ xa: —¡Gud ton utichyaꞌa ndoꞌ lu! ");
INSERT INTO zpt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","No sianta be diꞌizh ugap ndab bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Leꞌa ngot xeꞌa wa, cha mzhealbe bexa gox nsak ten bexa judio, no be uleꞌay nibeꞌe, no be mech ten ley. Cha mbiꞌi bexa Jesús dub sa nzhealbe sbeꞌen bexa nibeꞌetsa ten bexa judio. Cha ndab bexa ndoꞌ Jesús: ");
INSERT INTO zpt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Gud naga lu nak Cristo xa mti Dios. Leꞌa Jesús cha ukaꞌab ndab: —Tal leꞌa naꞌ gáp leꞌa ta wa naꞌka, leꞌa bego lá gungea ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","No tal inabdiꞌizh naꞌ ndoꞌ bega, leꞌa bega lá ikaꞌab ndoꞌ naꞌ, no ni lá ulaꞌa bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Parea leꞌa nat idub nchaꞌa ndoꞌ ndee, leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, yatsoꞌobgal wats Dios lad gaꞌal, Dios xa ndon leꞌa nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Weꞌe cha itea bexa ndab: —¿Nat zha lu nak Xin Dios? Leꞌa Jesús cha ukaꞌab ndab: —Leꞌaka bega ndab‑a. ");
INSERT INTO zpt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Weꞌe leꞌa bexa wa cha ndab ndoꞌ be ltsaꞌa na: —Yá lá nkiꞌin beuna kwaꞌadta xa usake xa. Leꞌa beuna ndoꞌón ndab xa leꞌa xa leꞌaka ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Leꞌa itea bexa wa cha mbiꞌi Jesús ndoꞌ Pilat. ");
INSERT INTO zpt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cha usaxan nsake bexa Jesús, ndab bexa: —Leꞌa xa ndee nkiꞌil be ltsaꞌa besa bexa judio, ndab xa leꞌa besa lá nsabndoꞌ kix med ndoꞌ César xa nibeꞌe Roma. No ndab xa leꞌa xa nak Cristo, dub xa nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Leꞌa Pilat cha unabdiꞌizh ndab ndoꞌ Jesús: —¿Lu nak xa nibeꞌe ten bexa judio zha? Leꞌa Jesús cha ukaꞌab ndab: —Goka ndab‑a. ");
INSERT INTO zpt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Leꞌa Pilat cha ndab ndoꞌ be uleꞌay nibeꞌe no ndoꞌ be men kwaꞌad wa: —Leꞌa naꞌ ni dub ke ten xa ndee lá ngaizheal naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ná leꞌa bexa wa ndi mas ugeꞌ ndabbe: —Leꞌa ta nluu xa baꞌ nchealuyo itea be men, ta usaxan nluu xa Galilea nsea gast Judea ndee. ");
INSERT INTO zpt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Leꞌa gor na mbiꞌín Pilat ta wa, leꞌa xa cha unabdiꞌizh naga xa Galilea Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Leꞌa gor na mbiꞌín Pilat leꞌa Jesús xa Galilea sa nibeꞌe Herodes, cha mtuꞌub Pilat Jesús ndoꞌ Herodes. Leꞌa Herodes leꞌagala be wizh wa ncho Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Leꞌa gor na uniꞌí Herodes Jesús, leꞌa Herodes uzhebpa mten ladna, geal leꞌa xa polta nlad iniꞌí Jesús. Leꞌa xa ndoꞌón ndadiꞌizh be men cuent ten Jesús, no nlad xa iniꞌí xa dub uyon ndun Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cha uzhebpa sian taꞌa unabdiꞌizh Herodes ndoꞌ Jesús, ná leꞌa Jesús ni lá ikaꞌab. ");
INSERT INTO zpt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Leꞌa be uleꞌay nibeꞌe nsea be mech ten ley uzhebpa msake Jesús ndoꞌ Herodes. ");
INSERT INTO zpt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Leꞌa Herodes no be soldad ten na cha kweaꞌ uníꞌi ndoꞌ Jesús, cha usalad mbinno bexa Jesús, mgak bexa xa dub lad uyappa, ta ndak sbeꞌen bexa nibeꞌetsa. Cha leꞌaka ndoꞌ Pilat mtuꞌub Herodes Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Leꞌa wizh wa mzhealdiꞌizh Pilat no Herodes, leꞌa mas polta leꞌa bexa nyobe. ");
INSERT INTO zpt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Leꞌa Pilat cha mchealte be uleꞌay nibeꞌe, no bexa nsak, no kwaꞌadta be men gezh wa. ");
INSERT INTO zpt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Cha ndab Pilat ndoꞌ bexa: —Leꞌa bego myun cuent mgiꞌi ndee ndoꞌ naꞌ, ndab bega leꞌa xa nchealuyo be men. Parea leꞌa bega ndewiꞌi leꞌa naꞌ unabdiꞌizh ndoꞌ xa, ná leꞌa xa lá ngun ni dub ta na lbaꞌa nsake bega xa. ");
INSERT INTO zpt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","No ni Herodes lá ngaizheal ke ten xa, ta weꞌe mtuꞌub Herodes xa leꞌaka sa ndee. Leꞌa bega uniꞌí leꞌa xa ndee ni dub ke gat xa lá ndap xa. ");
INSERT INTO zpt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nat leꞌa naꞌ utsaksitsa xa, weꞌeta ula naꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Li ndab Pilat geal leꞌa itea liꞌin zha ndal ujest wa, leꞌa Pilat ngoꞌo dub men nkea litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ná leꞌa be men ndi iteanak ugeꞌ ndabbe: —¡Gat Jesús! ¡Blaꞌa ga Barrabás! ");
INSERT INTO zpt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Leꞌa Barrabás wa nkea litgiꞌib ke na uteyono xa bexa nibeꞌe Jerusalén wa, no mbit xa dub men. ");
INSERT INTO zpt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Leꞌa Pilat nlad ulaꞌa Jesús, cha ndabgal xa ta wa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ná leꞌa be men wa ugeꞌgal ndab: —¡Ikea xa ndoꞌ cruz! ¡Ikea xa ndoꞌ cruz! ");
INSERT INTO zpt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Leꞌa Pilat cha ndabgal biaj yon: —Leꞌa xa ndee naꞌan xtaꞌan dub ta ugap ngun. Ni dub ke gat xa lá ndap xa. Leꞌa naꞌ utsaksitsa xa, weꞌeta ula naꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ná leꞌa be men wa no be uleꞌay nibeꞌe ndi mas ugeꞌ ndabbe ikea Jesús ndoꞌ cruz. Kwenpa li ndab bexa gast plo mbinka bexa gan. ");
INSERT INTO zpt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Weꞌe leꞌa Pilat ndab sunka ta ndab be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Cha mgoꞌo xa dub xa na li ndab be men itoꞌo wa, xa na li nkea litgiꞌib ke na mbit xa dub men, no uteyono xa bexa nibeꞌe wa. Cha myun Pilat cuent Jesús ndoꞌ bexa ukeꞌa bexa xa ndoꞌ cruz, lak nlad be men wa. ");
INSERT INTO zpt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Leꞌa nes nchaꞌano be soldad Jesús, mzheꞌal bexa dub xabgiꞌi ngwaꞌ geꞌe, xa nsaleaꞌ Simón xa gezh Cirene. Cha mbin bexa juers goꞌo Simón cruz ten Jesús, cha mxoꞌob bexa‑yá tsoꞌo xa, nchaꞌnkea xa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","No kwaꞌad be men usankea tsoꞌo Jesús, nsea lat bexa wa nchaꞌa kwaꞌad be xagots ugeꞌ ndoꞌonno Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Leꞌa Jesús cha mgeaksoꞌ mwiꞌi ndoꞌ be xagots wa, cha ndab xa: —Bego xagots Jerusalén, lá goꞌonno bega naꞌ, ndi biꞌinno bega leꞌaka leꞌa bega no be xin bega. ");
INSERT INTO zpt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Leꞌa gal be wizh leꞌa be men gab: “Uzhebpa wen yoo be xagots lá yoꞌo gan gap meꞌed, no bexa lá yoxinna, no bexa lá ngungaꞌal meꞌed.” ");
INSERT INTO zpt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Leꞌa be wizh weꞌe gab be men ndoꞌ be geꞌe ubiꞌi baꞌ: “Ulayat bega tsoꞌo besa”, no gab bexa ndoꞌ be bet: “Ulate bega tsoꞌo besa.” ");
INSERT INTO zpt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Leꞌa bexa lndeꞌe ndanno naꞌ, ná naꞌ ni dub ke lá ndap, mata bexa ndap ke wa mas gealkweaꞌ iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Leꞌa be soldad wa mbiꞌi no stop bexa ugap ikea ndoꞌ cruz wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Leꞌa gor na ulayaꞌ bexa sa nsaleaꞌ tit gek men, cha mkeꞌa bexa Jesús ndoꞌ cruz. Cha mkeꞌa bexa dub xa ugap wa ndoꞌ cruz wats Jesús lad gaꞌal, leꞌa stub xa wa wats lad raves. ");
INSERT INTO zpt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Leꞌa Jesús cha ndab: —Dios Xus naꞌ, bingeꞌ ladna go ndoꞌ be men ndee, leꞌa bexa ka lá iniꞌí xtaꞌan ndunbe. Cha uloꞌo be soldad dub suert ndontsa iniꞌí bexa ná tonpa ikaꞌa be xab Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Leꞌa kwaꞌad be men ndewiꞌi sa wa. Leꞌa bexa nsak ten bexa judio xela ndeníꞌi ndoꞌ Jesús, ndab bexa ndoꞌ be ltsaꞌa bexa: —Leꞌa xa baꞌ ngokno be men, nat ulat xa leꞌaka xa ndoꞌ gealgut, tal leꞌa xa ta ugeaka leꞌa nak Cristo xa na mti Dios. ");
INSERT INTO zpt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Leꞌa be soldad no xela uníꞌibe ndoꞌ Jesús. No msaꞌa bexa vin ulaꞌ goo xa. ");
INSERT INTO zpt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ndab bexa ndoꞌ Jesús: —Tal lu leꞌa nak xa nibeꞌe ten bexa judio, nat blat leꞌaka lu. ");
INSERT INTO zpt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Leꞌa gek cruz ten Jesús mkeꞌa bexa dub letr ndab‑a: “TA NDEE XA NIBEꞌE TEN BEXA JUDIO.” Leꞌa ta wa nkea diꞌizh griego, no diꞌizh latín, no diꞌizh hebreo. ");
INSERT INTO zpt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Leꞌa dub xa ugap no nkea ndoꞌ cruz no xela uníꞌi ndoꞌ Jesús, ndab xa: —Tal lu nak Cristo, ulaꞌ ndoꞌ cruz baꞌ, cha uxeꞌe besa ndoꞌ be cruz ndee. ");
INSERT INTO zpt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ná leꞌa stub xa ugap wa cha uteyo xa na li ndab wa, ndab xa: —Lbaꞌa ntsaksi bexa lu, ¿ná lá nzheb lu ndoꞌ Dios zha? ");
INSERT INTO zpt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Leꞌa wa nsabndoꞌka ndeniꞌí gealkweaꞌ ndee, leꞌa wa ndekix ta ugap mbin wa. Parea leꞌa xa ndee ni dub ta ugap lá ngun. ");
INSERT INTO zpt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Cha no ndab xa ndoꞌ Jesús: —Jesús, utseꞌa ladna go naꞌ gor na isaxan inibeꞌe ga. ");
INSERT INTO zpt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp leꞌa wizh nat leꞌa lu no yoꞌono naꞌ gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Leꞌa ngol gor gawizh cha mkaw idub ndoꞌ gizhliyo, gast gor nkea uyon uzhe. ");
INSERT INTO zpt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Leꞌa be gor wa leꞌa wizh yá lá nluꞌuta. Cha usaw lad utaꞌa ncho bseꞌa len niꞌi ten Dios, ngok top bleꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Weꞌe leꞌa Jesús ugeꞌ ndab: —Dios Xus naꞌ, ndoꞌ yaꞌa ga uchan naꞌ gealnaban ten naꞌ. Cha ngut xa. ");
INSERT INTO zpt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Leꞌa gor uniꞌí xa nibeꞌe ten be soldad ta uyoꞌo wa, cha ndab xa: —Leꞌa Dios uzhebpa dub Dios siꞌil. Ta ugeaka leꞌa xabgiꞌi ndee dub xa wenka. ");
INSERT INTO zpt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Leꞌa itea be men nde sa wa, bexa na li uniꞌí be ta uyoꞌo wa, cha nseaꞌbe bexa uzheꞌeb kweaꞌ ncho ladna bexa. ");
INSERT INTO zpt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Naꞌ leꞌa bexa na nchandoꞌ Jesús sittsa ndewiꞌibe, no liga be xagots na li usankea tsoꞌo Jesús zha utoꞌo bexa Galilea. ");
INSERT INTO zpt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uyoꞌo dub xabgiꞌi nsaleaꞌ Kosé xa gezh Arimatea ten distrit Judea. Leꞌa xa wa dub xa nsak ten bexa judio, dub xa wen nak ndoꞌ be men no ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","No nkenkeaꞌ xa zha inibeꞌe Dios ndoꞌ gizhliyo. No naꞌanpa isak ladna xa ta mbinno be ltsaꞌa xa Jesús, bexa nsak ten bexa judio. ");
INSERT INTO zpt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Weꞌe cha ngwaꞌ xa ndoꞌ Pilat unab xa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cha uxeꞌe xa Jesús ndoꞌ cruz, cha mtixko xa xa ngut wa dub bleꞌa lad nagud. Cha ulo xa xa wa len dub baꞌa cuent nak geꞌloꞌo len dub geꞌdaꞌa, dub sa ni dub men gol gaꞌach. ");
INSERT INTO zpt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Leꞌa ta wa wizh nsaxkwaꞌa bexa judio ta guntiꞌin bexa wizh neꞌe bexa. Leꞌa gor mgaꞌach Jesús dub gor uzhe yamer yatsoꞌ wizh wa. ");
INSERT INTO zpt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Leꞌa be xagots na ukeseano Jesús zha na utoꞌo bexa Galilea usankea tsoꞌo Kosé, cha uniꞌí bexa pa nde baꞌa sa mgaꞌach Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cha nseaꞌ bexa leꞌaka gezh Jerusalén, cha msaxkwaꞌa bexa be ta uxeꞌe yaꞌlo bexa las Jesús. Cha mneꞌe bexa dub wizh lak nibeꞌe ley ten bexa. ");
INSERT INTO zpt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Leꞌa ngol wizh ned ten sman gor bi ukalta naꞌ, utoꞌo be xagots wa, nchaꞌbe bexa sa nde baꞌa mgaꞌach Jesús. Mbiꞌi bexa be ta uxeꞌe li msaxkwaꞌa bexa wa, nsea stapla be xagots nchaꞌano bexa. ");
INSERT INTO zpt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Leꞌa gor ulayaꞌ bexa sa wa, uniꞌí bexa leꞌa geꞌ li nsoꞌnyaw toꞌo baꞌa wa yá naꞌanlapa nsoꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Cha uyoꞌo bexa len baꞌa, cha uniꞌí bexa leꞌa Jesús naꞌanla sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cha ngwatenaꞌ bexa, ni lá iniꞌí bexa xteꞌe gun bexa. Zha leꞌa bexa mnaꞌla top be xabgiꞌi nak lad nagud ndon nlaꞌbealꞌ ndela wats bexa. ");
INSERT INTO zpt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cha mzheb bexa, mwiꞌi bexa ndi ndoꞌ yo. Leꞌa be xabgiꞌi wa cha ndab: —¿Xtaꞌan nkwaꞌan bega dub xa nban sa ten bexa ngut? ");
INSERT INTO zpt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Leꞌa Jesús wa naꞌanla len baꞌa ndee, leꞌa xa ubanla. Btseꞌa ladna bega ta ndab xa ndoꞌ bega zha na bi ncho xa Galilea, ");
INSERT INTO zpt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ndab xa: “Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, nsabndoꞌ yak cuent ndoꞌ yaꞌa be men ugap, no ikea naꞌ ndoꞌ cruz. Parea gal wizh yon leꞌa naꞌ ibangal.” ");
INSERT INTO zpt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Weꞌe leꞌa be xagots wa cha mtseꞌa ladna be diꞌizh ndab Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cha nseaꞌbe bexa leꞌaka Jerusalén, mbidiꞌizh bexa ta uniꞌí bexa ndoꞌ isatibdub be xmen Jesús no ndoꞌ iteata bexa ukeseano Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Leꞌa be xagots na li mbidiꞌizh ta wa ndoꞌ be xmen Jesús wa, leꞌa xa wa Marí xa gezh Magdala no Juana no Marí xnaꞌa Jacob no stapla xagots. ");
INSERT INTO zpt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ná leꞌa be xmen Jesús lá ngungea ladna ta ndab be xagots wa, leꞌa bexa ndi ndab leꞌa bexa wa xa loc. ");
INSERT INTO zpt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Parea leꞌa Pedr cha utoꞌo karrel nchaꞌa toꞌo baꞌa. Leꞌa gor na mwiꞌi xa len baꞌa wa, ndon nabtsa be lad ubixyoꞌo Jesús uniꞌí xa. Cha myach Pedr, ngwanseana xa ta uyoꞌo wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Bi leꞌa wizh wa leꞌa top xabgiꞌi na no ukeseano Jesús nseaꞌbe nes nchaꞌa gezh Emaús. Leꞌa ta wa pa dub tibdub kilómetro sit wats Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Leꞌa bexa wa nseaꞌbe yadiꞌizh itea be ta na li uyoꞌo Jerusalén wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ná ndalen li nseaꞌbe yadiꞌizh bexa ta wa, leꞌa Jesús cha ulayaꞌ wats bexa, cha no xa nchaꞌano bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Parea leꞌa Dios lá ulaꞌa igondoꞌ bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Leꞌa Jesús cha ndab: —¿Xtaꞌan nseaꞌbe yadiꞌizh bega nes ndee? ¿No xtaꞌan lbaꞌa uban ncho ladna bega zha? ");
INSERT INTO zpt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Leꞌa dub xa nsaleaꞌ Cleofas cha ukaꞌab ndab: —¿Ndon gokama nak dub xa sit utoꞌo lá iniꞌí xtaꞌan uyoꞌo Jerusalén be wizh ndee zha? ");
INSERT INTO zpt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Leꞌa Jesús cha ndab: —¿Xtaꞌan uyoꞌo sa wa zha? Leꞌa bexa wa cha ndab: —Ta ngwasea Jesús xa Nazaret, xa mbidiꞌizh sakndoꞌ Dios, no sian uyon mbin xa, no uzhebpa wen mluu xa be men. Leꞌa Dios nsea itea be men msak ladna lak mbin xa. ");
INSERT INTO zpt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ná leꞌa be uleꞌay nibeꞌe no bexa nsak ten besa myun cuent Jesús gat xa. Cha mkeꞌa bexa xa ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Leꞌa besa mbinbeꞌe leꞌa xa leꞌa ulat beuna xa Israel ndoꞌ yaꞌa bexa nibeꞌe, ná nat myonla wizh ngok ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Leꞌa pla be xagots ncho lat besa ngwaꞌ sa mgaꞌach Jesús wa gor bi ukalta naꞌ, ");
INSERT INTO zpt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ná leꞌa bexa lá izheal‑la Jesús sa wa. Cha myach bexa ndab bexa leꞌa bexa uniꞌí be angel ndab leꞌa Jesús ubanla. ");
INSERT INTO zpt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Leꞌa pla be ltsaꞌa besa cha no ngwaꞌwiꞌi sa wa, cha uniꞌí bexa be taꞌa lakkata ndab be xagots wa, ná leꞌa bexa no naꞌanpa iniꞌí Jesús. ");
INSERT INTO zpt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Leꞌa Jesús cha ndab: —Uzhebpa lid leꞌa ndanbeꞌe bega. No uzhebpa chaꞌaw ndangea ladna bega be ta polta mbidiꞌizh be men sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Lá iniꞌí bega zha lid nsabndoꞌka itid Cristo itea be ta wa, weꞌeta yaꞌ xa wats Dios? ");
INSERT INTO zpt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Cha usaxan Jesús ndadiꞌizh itea be ta nkeaniꞌi diꞌizh ten Dios cuent ten Jesús. Ned mbidiꞌizh xa ta mkeꞌa Moisés, weꞌeta mbidiꞌizh xa ta mkeꞌa iteata bexa mbidiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Leꞌa gor na ulayaꞌ bexa gezh Emaús wa, leꞌa Jesús cha mbinta nchaꞌata mas sit. ");
INSERT INTO zpt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ná leꞌa bexa wa dubpa ndab ndoꞌ Jesús: —Sa ndeetsa byaꞌanno ga besa, leꞌa nat nseala teꞌal. Leꞌa Jesús cha weꞌetsa myaꞌanno bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ngol gor nde bexa ndoꞌ mes gaw bexa, leꞌa Jesús cha usen dub pan, cha msaꞌa xa xno ndoꞌ Dios. Cha uleꞌa xa‑yá, cha msaꞌa xa‑yá ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Leꞌa gor wa leꞌa bexa wa cha mgondoꞌ Jesús, ná leꞌa Jesús cha unitndoꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cha ndab dub xa wa ndoꞌ stub xa: —Ta weꞌeka uzhebpa mten ladna wa gor na li mbidiꞌizh xa xteꞌe nkeaniꞌi diꞌizh ten Dios, gor na nseaꞌbe min nes wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bi leꞌa gor wa cha myach bexa leꞌaka Jerusalén, sa ndebe isatibdub be xmen Jesús no stapla bexa ndeno bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Leꞌa bexa nde sa wa cha ndab: —Leꞌa Jesús ta ugeaka mbanla, leꞌa xa wa mlundoꞌ ndoꞌ Simón. ");
INSERT INTO zpt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Weꞌe leꞌa itop bexa wa cha no mbidiꞌizh ta ngwasea bexa nes nchaꞌa Emaús, no xteꞌe mgondoꞌ bexa Jesús gor uleꞌa xa pan. ");
INSERT INTO zpt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Leꞌa ndalen ndeyadiꞌizh bexa ta wa, zha leꞌa Jesús ulatsoꞌla tlaw bexa. Cha ndab xa: —¡Dios gun wen yoo ladna bega! ");
INSERT INTO zpt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Leꞌa bexa cha uzhebpa mzhebbe, mbinbeꞌe bexa leꞌa Jesús dub ta ntalad. ");
INSERT INTO zpt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ná leꞌa Jesús cha ndab: —¿Xtaꞌan nzheb bega? ¿No xtaꞌan lbaꞌa lá ndangea ladna bega leꞌa naꞌ Jesúska? ");
INSERT INTO zpt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bwiꞌi bega yaꞌa naꞌ no xoꞌo naꞌ, no bgal bega naꞌ. Leꞌa naꞌ leꞌaka Jesús. Leꞌa dub ta ntalad lá ndap ni tit no ni las na, lak naꞌ bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Leꞌa gor na li ndab Jesús, cha mluu xa yaꞌa xa no xoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Leꞌa bexa uzhebpa mten ladnabe no ndanseana bexa, parea bi lá ndangea ladna bexa ti leꞌa Jesús ta wa. Ta weꞌe leꞌa Jesús cha ndab: —¿Xtaꞌan ndap bega gaw naꞌ? ");
INSERT INTO zpt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Cha msaꞌa bexa dub bleꞌa mbeal mgiꞌix no dub bleꞌa mguꞌud ncho mzhin. ");
INSERT INTO zpt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Leꞌa Jesús cha usen‑a, cha udaw xa‑yá ndoꞌ gaꞌal bexa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Cha ndab Jesús: —Btseꞌa ladna bega ta na li mbidiꞌizh naꞌ ndoꞌ bega, zha na li ndesea beuna wa. Ndáp naꞌ leꞌa itea be taꞌa nkeaniꞌi cuent ten naꞌ ndoꞌ be libr mkeꞌa Moisés, no ndoꞌ be libr mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios, no ndoꞌ libr Salmos, leꞌa ta wa nsabndoꞌka li gak. ");
INSERT INTO zpt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Leꞌa Jesús cha mbidiꞌizh ndoꞌ bexa lak nkeaniꞌi diꞌizh ten Dios, ndontsa yakbeꞌena bexa‑yá, ");
INSERT INTO zpt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ndab xa: —Leꞌa diꞌizh ten Dios nkeaniꞌi leꞌa Cristo nsabndoꞌka li gat no iban xa wizh yon ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","No nsabndoꞌ gudiꞌizh be xmen naꞌ cuent ten naꞌ ndoꞌ itea be men, ndontsa ulaꞌa bexa be ta ugap nak bexa, no utsuꞌu Dios be ke ten bexa. Ndon ned Jerusalén ndee no gast idub ndoꞌ gizhliyo gudiꞌizh bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Leꞌa bego nak bexa uniꞌí be ta li utiꞌid naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Blaꞌach bego leꞌa naꞌ utuꞌubka Espíritu ten Dios, xa ndabka Xus naꞌ usaꞌa ndoꞌ bega wa. Cha lá ikaꞌan bega Jerusalén ndee, gast ikaꞌaka bega juers ilen gibeꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Weꞌe leꞌa Jesús cha mbiꞌi bexa dub lad toꞌo Jerusalén gax gezh Betania. Cha msaꞌab Jesús be yaꞌa na lad nde bexa, cha unab xa ndoꞌ Dios ulaꞌach Dios bexa. ");
INSERT INTO zpt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ndalen li nsoꞌyadiꞌizh Jesús ta wa, leꞌa xa cha nseaꞌ, mkea xa gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Leꞌa bexa wa cha msaxib, ngwankea bexa Jesús. Weꞌe cha uzhebpa mten ladna bexa, myach bexa leꞌaka Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cha itea wizh ndaꞌbe bexa tale ten niꞌi ten Dios, ndankea bexa Dios, no nsaꞌa bexa xno ndoꞌ Dios. Lika nak‑a.");
INSERT INTO zpt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Leꞌa zha ndon leꞌa ned, leꞌa xa nak Diꞌizh nchola. No nsoꞌla xa nak Diꞌizh wa wats Dios, leꞌa xa wa nak Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Leꞌa zha ndon leꞌa ned wa, leꞌa xa wa nsoꞌla wats Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Leꞌa iteanak be ta ncho leꞌa ta wa ngokndeꞌe juers ten Diꞌizh wa. Ni dub taꞌa naꞌanpa yoꞌo tal leꞌa xa wa lá ngundeꞌe‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Leꞌa xa wa leꞌa nsaꞌa gealnaban ten be men, leꞌa gealnaban wa leꞌa nak xeꞌa ten bexa. ");
INSERT INTO zpt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Leꞌa xeꞌa wa nsu sa ukaw, leꞌa sa ukaw wa lá gun gan yuꞌu xeꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uyoꞌo dub xabgiꞌi leꞌa Dios mtuꞌub, leꞌa ta wa Juan xa ulaleaꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Leꞌa xa wa mbidyadiꞌizh cuent ten xa nak xeꞌa wa, ndontsa itea be men gungea ladna xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Leꞌa Juan naꞌanpa leꞌa nak xeꞌa wa, leꞌa xa ndi mbidyadiꞌizhtsa cuent ten xa nak xeꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Leꞌa xa na ta ugeaka nak xeꞌa, xa nsu xeꞌa ten Dios ndoꞌ be men, leꞌa xa wa mbiꞌid ndoꞌ gizhliyo ndee. ");
INSERT INTO zpt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","No ukesea xa ndoꞌ gizhliyo ndee. Leꞌa juers ten xa ngokndeꞌe gizhliyo, parea leꞌa be men ncho ndoꞌ gizhliyo lá igondoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mbiꞌid xa ndoꞌ bexa Israel, parea leꞌa be ltsaꞌa xa wa lá isakyoꞌón ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ná leꞌa itea be men na msakyoꞌón ta ndab xa no mbingea ladna bexa xa, ndoꞌ bexa wa msaꞌa xa juers myak bexa xin Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Leꞌa ta na nak bexa xin Dios wa leꞌa ta wa naꞌanpa dub ta ndun be men, leꞌa ta wa ndi dub ta nsaꞌa Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Leꞌa xa nak Diꞌizh wa myak men, cha uyoꞌo xa lat besa. Sbeꞌen nkweaꞌ ladna xa be men no sbeꞌen gealngea ndadiꞌizh xa. No uniꞌí besa xteꞌe juert nak xa ta na leꞌa xa ga dubkama nak Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Leꞌa Juan wa mluu be men xteꞌe nak xa nak Diꞌizh wa, ugeꞌ ndab Juan ndoꞌ bexa: —Leꞌa cuent ten xa ndee mbidiꞌizh naꞌ, gor na ndáp naꞌ leꞌa xa na ilen tsoꞌo naꞌ wa mas nsak ndoꞌ naꞌ, geal leꞌa xa wa nedka nchola ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Leꞌa xa uzhebpa utsin nak ndoꞌ beuna, no uzhebpa ndakno xa beuna itea be wizh. ");
INSERT INTO zpt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Leꞌa juers ten Moisés leꞌa Dios msaꞌa ley ten na. Parea leꞌa juers ten Jesucristo leꞌa Dios mluu xteꞌe nkweaꞌ ladna xa beuna no xteꞌe nak gealngea ten xa. ");
INSERT INTO zpt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni dub men gol niꞌí Dios. Ná leꞌa xa na ga dubkama nak Xin Dios, xa na nsob wats Tad Dios, leꞌa xa wa mluu ndoꞌ beuna xteꞌe nak Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Leꞌa dub wizh leꞌa bexa nibeꞌe ten bexa judio mtuꞌub pla be uleꞌay no pla bexa levita, utoꞌo bexa gezh Jerusalén ngwaꞌinabdiꞌizh bexa ndoꞌ Juan xa ngoleaꞌ be men ná ton nak Juan. ");
INSERT INTO zpt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Leꞌa Juan naꞌanpa ukwiꞌin, ndi gaꞌalka ndab xa ndoꞌ bexa wa: —Leꞌa naꞌ naꞌanpa leꞌa nak Cristo. ");
INSERT INTO zpt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Leꞌa bexa wa cha unabdiꞌizhgal ndab bexa: —¿Tonxá lu zhaga? ¿Nak lu profet Elí zha? Leꞌa Juan cha ndab leꞌa xa naꞌanpa leꞌa ta wa. Weꞌe unabdiꞌizhgal bexa, ndab bexa: —¿Nati lu profet ndiꞌizh ga ilenka wa? Leꞌa Juan cha ndabgal leꞌa xa naꞌanpa leꞌa ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Leꞌa bexa wa cha ndabgal: —¿Ton nak lu zha? Leꞌa besa juerska gab‑a ndoꞌ bexa na mtuꞌub besa. Nat gud ton nak lu. ");
INSERT INTO zpt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Leꞌa Juan cha ukaꞌab ndab: —Leꞌa naꞌ ndee leꞌa nak xa na nkeseyadiꞌizh geꞌe sa bid, ugeꞌ ndáp naꞌ: “Bkeasoꞌ bega nes ilen Xa Nibeꞌe.” Leꞌa ta wa ta ndab Isaías tiemp polta. ");
INSERT INTO zpt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Leꞌa bexa mtuꞌub bexa fariseo wa ");
INSERT INTO zpt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","cha unabdiꞌizhgal ndab bexa: —¿Xtaꞌan ngoleaꞌ lu be men, tal lu lid leꞌa nak Cristo, ni Elí, ni profet ndiꞌizh ga ilenka wa? ");
INSERT INTO zpt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Leꞌa Juan cha ukaꞌab ndab: —Leꞌa naꞌ nits‑tsa ngoleaꞌ be men, ná leꞌa lat bego ncho dub xa leꞌa bego bi lá nchandoꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Leꞌa xa wa nedla ncho ndoꞌ naꞌ ndee, parea leꞌa xa ilen ndi tsoꞌo naꞌ. Leꞌa naꞌ ni lá isaya kote ndab xa wa, leꞌa xa wa mas nsak ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Leꞌa be ta ndee uyoꞌo gezh Betábara, stub toꞌo yowbeꞌe Jordán, sa na ulaleaꞌ Juan be men. ");
INSERT INTO zpt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ngol stubtsa wizh leꞌa Juan uniꞌí leꞌa Jesús nsalayaꞌ gax wats Juan. Cha ndab Juan ndoꞌ be men: —Bwiꞌi bego, leꞌa xa baꞌ leꞌa xa nak cuent Borreg Ben ten Dios, xa ntsuꞌu be ke ten be men. ");
INSERT INTO zpt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Leꞌa cuent ten xa baꞌ li mbidiꞌizh naꞌ gor na ndáp naꞌ leꞌa tsoꞌo naꞌ ilen dub xa mas nsak ndoꞌ naꞌ, geal leꞌa xa nedla ncho ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Leꞌa zha weꞌe leꞌa naꞌ ndee bi lá nchandoꞌ xa, ná leꞌa naꞌ ngwal ulaleaꞌ be men nsea nits, ndontsa li igondoꞌ bexa Israel wa xa. ");
INSERT INTO zpt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","No ndab Juan: —Leꞌa naꞌ uní leꞌa Espíritu ten Dios utoꞌo gibeꞌa cuent dub palom nchaꞌlaꞌ sa nsoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Leꞌa zha wa leꞌa naꞌ bi lá nchandoꞌ xa baꞌ, parea leꞌa Dios xa mtuꞌub naꞌ koleaꞌ naꞌ be men nsea nits, leꞌa xa wa ndablaka ndoꞌ naꞌ leꞌa gek xa na iní naꞌ ilaꞌ Espíritu ten Dios, leꞌa xa wa koleaꞌ men nsea Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Leꞌa naꞌ uní ta wa ta weꞌe ndáp naꞌ ndoꞌ bego leꞌa xa baꞌ nakka Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ngol stubtsa wizh leꞌa Juan nsoꞌgal sa wa nsea stop xmen xa. ");
INSERT INTO zpt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Leꞌa gor uniꞌí Juan nsatid Jesús sa wa, cha ndab Juan ndoꞌ bexa: —Bwiꞌi bego, leꞌa xa baꞌ xa nak cuent Borreg Ben ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Leꞌa gor na mbiꞌín itop be xmen Juan ta wa, cha usankea bexa tsoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Leꞌa Jesús cha mgeaksoꞌ mwiꞌi xteꞌe nchankea bexa tsoꞌo na, cha ndab xa: —¿Xtaꞌan nkwaꞌan bega zha? Leꞌa bexa wa cha ukaꞌab ndab bexa: —Rabí, ¿pa ncho go zha? —leꞌa rabí wa dub diꞌizh gab mech. ");
INSERT INTO zpt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Leꞌa Jesús cha ndab: —Waꞌa beuna, iniꞌí bega pa‑yá. Leꞌa bexa wa cha nchaꞌbe, uniꞌí bexa pa ncho Jesús. Leꞌa ta wa pa gor nkea udap gor uzhe. Cha uyoꞌono bexa Jesús sa wa idub uzhe wa. ");
INSERT INTO zpt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Leꞌa itop bexa na li mbiꞌín ta ndab Juan wa cha usankea tsoꞌo Jesús, leꞌa dub xa wa nsaleaꞌ Ndres, wit Simón Pedr. ");
INSERT INTO zpt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Weꞌe leꞌa Ndres wa ned ngwaꞌkwaꞌan wit na Simón, cha ndab xa: —Leꞌa besa mzheꞌal xa nak Mesías —leꞌa Mesías wa dub diꞌizh hebreo, gab‑a Cristo, xa mti Dios. ");
INSERT INTO zpt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Leꞌa Ndres cha mbiꞌi Simón wats Jesús. Leꞌa Jesús cha mwiꞌi ndoꞌ Simón, cha ndab Jesús: —Leꞌa lu Simón, xin Jonás. Leꞌa nat leꞌa lu isaleaꞌ Cefas —leꞌa diꞌizh griego leꞌa ta wa Pedr, dub diꞌizh gab geꞌdaꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ngol stubtsa wizh leꞌa Jesús nlad yaꞌ distrit Galilea. Cha mzheꞌal xa dub xabgiꞌi nsaleaꞌ Julip, cha ndab xa: —Usankea tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Leꞌa lazh Julip wa gezh Betsaida, lazh Ndres no Pedr. ");
INSERT INTO zpt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Leꞌa Julip cha ngwaꞌkwaꞌan dub xabgiꞌi nsaleaꞌ Natanael, ndab xa: —Leꞌa besa mzheꞌal xa na mkeꞌa Moisés no be profet cuent ten na. Leꞌa xa wa Jesús xa gezh Nazaret, xin Kosé. ");
INSERT INTO zpt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Leꞌa Natanael wa cha ndab: —¿Cha syoꞌo gan itoꞌo dub xa wen Nazaret zha? Leꞌa Julip cha ukaꞌab ndab: —Nchaꞌa wa igondoꞌ lu xa. ");
INSERT INTO zpt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Leꞌa gor na uniꞌí Jesús nchaꞌlayaꞌ gax Natanael wats Jesús, cha ndab Jesús cuent ten Natanael: —Leꞌa xa baꞌ ta ugeakapa nak dub xa Israel, dub xa naꞌanpa nkwiꞌinno be men. ");
INSERT INTO zpt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Leꞌa Natanael cha ndab: —¿Xteꞌe nchandoꞌ ga naꞌ? Leꞌa Jesús cha ndab: —Naꞌ uníla lu gor na nsob lu xan ya laꞌaw, gor biseata kwezh Julip lu. ");
INSERT INTO zpt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Weꞌe leꞌa Natanael cha ndab: —Mech, nat uní naꞌ leꞌa go nak Xin Dios, no nak ga Xa Nibeꞌe ten Israel. ");
INSERT INTO zpt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Leꞌa Jesús cha ndab: —Ta na ndáp naꞌ leꞌa naꞌ uní lu xan ya laꞌaw wa, ¿ta weꞌe ndangea ladna lu leꞌa naꞌ nak Xin Dios zha? Leꞌa lu iniꞌí be ta mas siꞌil ndoꞌ ta uniꞌí lu nat wa. ");
INSERT INTO zpt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","No ndab Jesús ndoꞌ bexa nde sa wa: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa bego iniꞌí leꞌa gibeꞌa yaꞌal, leꞌa be angel ten Dios ikea no ilaꞌ wats naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ngol schon wizh leꞌa gezh Caná ten distrit Galilea uchilyaꞌa dub men. Leꞌa Marí xnaꞌa Jesús no nsoꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","No uyoꞌo kombid ndoꞌ Jesús nsea be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngol gor leꞌa vin ubid, leꞌa xnaꞌa Jesús cha ndab ndoꞌ Jesús: —Leꞌa bexa yá lá ndapta vin. ");
INSERT INTO zpt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Leꞌa Jesús cha ukaꞌab ndab: —Naa, ¿xtaꞌan ngi li ndab go zha? Leꞌa naꞌ biseata gal wizh ulu naꞌ ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Parea leꞌa xnaꞌa Jesús cha ndab ndoꞌ bexa ndun tiꞌin sa wa: —Bin bega lak gab xa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Leꞌa sa wa ndebe dub xoꞌop gets ubiꞌi nakchaꞌaw sbeꞌen geꞌ ta nyoꞌo nits len na. Leꞌa nits nyoꞌo len ta wa ta naꞌa bexa, ndontsa umbiꞌi gak bexa ndoꞌ Dios lak nibeꞌe costumbr ten bexa judio. Leꞌa len kadga dub gets wa nyoꞌo pa dub gayoꞌo litr nits. ");
INSERT INTO zpt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Leꞌa Jesús cha ndab ndoꞌ bexa ndun tiꞌin wa: —Bchea bega be gets ndee yoo nits‑a. Leꞌa bexa cha mchea be ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Weꞌe leꞌa Jesús cha ndabgal ndoꞌ bexa: —Nat uloꞌo bega dub tuzh‑a, cha biꞌi bega‑yá ndoꞌ xa nchansu gast baꞌ. Cha mbiꞌi bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Leꞌa bexa wa uniꞌí pa utoꞌo‑yá, parea leꞌa xa nchansu gast wa gor na mbin xa preb nits myak vin wa, leꞌa xa lá iniꞌí pa utoꞌo‑yá. Cha utezh xa xabgiꞌi mchilyaꞌa wa, ");
INSERT INTO zpt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","cha ndab xa: —Leꞌa itea ndoꞌ be gast leꞌa be men ned vin wen nsaꞌa. Weꞌe leꞌa gor na yá ngula be men kwaꞌal‑a, weꞌe cha nsaꞌa xa vin mas ndidotsa wen. Parea leꞌa go gast gor nat nsaꞌa vin ndon leꞌa wen. ");
INSERT INTO zpt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Leꞌa ta na li mbin Jesús gezh Caná ten Galilea wa, leꞌa ta wa uyon ned mbin Jesús. Leꞌa ta wa mluu ta juert nak Jesús, ta weꞌe leꞌa be xmen xa mgeꞌ ladna xa. ");
INSERT INTO zpt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsoꞌo wa cha mlayoꞌo Jesús gezh Capernaum, no xnaꞌa Jesús no be wit xa no be xmen xa. Cha uyoꞌo bexa gezh wa pla wizh. ");
INSERT INTO zpt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Leꞌa ngol zha yá nsayal gax ujest Pascua, ta ndun bexa judio, leꞌa Jesús no utoꞌo nchaꞌa gezh Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Leꞌa ngol sa wa cha uniꞌí Jesús leꞌa tale ten niꞌi ten Dios ndeudoꞌo bexa ngon, no borreg, no palom. No ndebe be men ntil med. ");
INSERT INTO zpt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Cha usen Jesús dub doꞌo, mbintiꞌin xa‑yá ulantuꞌub xa be borreg no be ngon no bexa na li ndiꞌibudoꞌo bema wats niꞌi ten Dios wa. Cha mtixte xa be mes ten bexa ntil med, mteꞌachso xa be med ten bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Cha ndab xa ndoꞌ bexa ndiꞌibudoꞌo palom wa: —¡Ulate bega be ta baꞌ sa ndee! ¡Lá gunno bega lid Xus naꞌ cuent dub ndoꞌ xgeꞌe! ");
INSERT INTO zpt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Leꞌa gor weꞌe leꞌa be xmen Jesús cha mtseꞌa ladna lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Uzhebpa ulach naꞌ lid go Dios.” ");
INSERT INTO zpt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Leꞌa bexa nibeꞌe ten bexa judio cha ndabbe ndoꞌ Jesús: —¿Xtaꞌan ngi lbaꞌa ndun lu? ¿Xtaꞌan dub taꞌa gun lu uluu leꞌa Dios nlad mbin lu ta baꞌ? ");
INSERT INTO zpt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Leꞌa Jesús cha ukaꞌab ndab: —Blate bega niꞌi ten Dios ndee, leꞌa naꞌ wizh yontsa ixiste‑yá stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Leꞌa bexa cha ndabbe: —Leꞌa niꞌi ten Dios ndee ngokndeꞌe dub top gaꞌal ncho xoꞌop liꞌin. ¿Ná ndab lu zha chontsa wizh ixistegal lu‑yá? ");
INSERT INTO zpt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ná leꞌa Jesús ndab ta wa cuent ten leꞌaka xa. ");
INSERT INTO zpt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ta weꞌe leꞌa zha na mas tsoꞌo wa mban Jesús ndoꞌ gealgut, leꞌa be xmen xa cha mtseꞌa ladna ta li ndab xa wa. Cha mas mbingea ladna bexa lak nkeaniꞌi diꞌizh ten Dios cuent ten Jesús, no ta li ndab Jesús cuent ten leꞌaka xa. ");
INSERT INTO zpt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Leꞌa zha li ncho Jesús Jerusalén ujest Pascua wa, leꞌa kwaꞌad men mbingea ladna Jesús ta na uniꞌí bexa be uyon mbin Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ná leꞌa Jesús lá ngungea ladna ta wa, leꞌa Jesús nchandoꞌ xteꞌe ndanbeꞌe bexa. ");
INSERT INTO zpt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","No lá nkiꞌin ton gab ndoꞌ Jesús xteꞌe nak be men, leꞌa Jesús nchandoꞌla ladoꞌo be men. ");
INSERT INTO zpt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uyoꞌo dub xa fariseo nsaleaꞌ Nicodemo, xa no nak dub xa nsak ten bexa judio. ");
INSERT INTO zpt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Leꞌa dub gor teꞌal ulayaꞌ xa wats Jesús, cha ndab xa: —Mech, leꞌa besa uniꞌí leꞌa go Dioska mtuꞌub, ndontsa uluu ga be men. Leꞌa naꞌan ton gun gan gun be uyon ndun ga, tal leꞌa Dios naꞌanpa isoꞌ wats xa. ");
INSERT INTO zpt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp ndoꞌ lu leꞌa tal ton lá gal stub biaj, leꞌa xa lá yoo gan iniꞌí sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Leꞌa Nicodemo cha ndab: —¿Xteꞌe yoo gan gal dub xa goxla stub biaj zha? Lá yoo gan yoꞌo xa len xnaꞌa xa, cha galgal xa stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp ndoꞌ lu leꞌa tal ton lá gal nsea nits no Espíritu ten Dios, lá yoo gan yate xa sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Leꞌa bexa na ndal lak ndal be men, leꞌa xa wa mentsa nak. Ná leꞌa bexa na ndal stub biaj lak nsaꞌa Espíritu ten Dios leꞌa xa wa xa ten Espíritu wa. ");
INSERT INTO zpt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Lá yanseana lu ta ndáp naꞌ leꞌa be men nsabndoꞌka gal stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Leꞌa mbi ndaꞌ guniꞌi pa nlad na no ndoꞌón lu nbezh‑a, parea leꞌa lu ni lá iniꞌí pa nsea‑yá no pa nchaꞌa‑yá. No liga nak gealnaban nsaꞌa Espíritu ten Dios ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Leꞌa Nicodemo cha ndab: —¿Xteꞌe nak ta ndee zha? ");
INSERT INTO zpt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Leꞌa Jesús cha ndab: —Lu nak mech ten bexa Israel, ¿ná lá yakbeꞌena lu ta ndee zha? ");
INSERT INTO zpt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Leꞌa naꞌ gáp leꞌa besa ndadiꞌizh ta nchandoꞌ besa no ta uniꞌí besa. Parea leꞌa bega lá ndangea ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ná tal leꞌa bega lá ndangea ladna gor ndadiꞌizh naꞌ cuent ten be ta ncho ndoꞌ gizhliyo ndee, ¿xteꞌema gungea ladna bega‑yá gor gudiꞌizh naꞌ cuent ten be ta ncho gibeꞌa baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Naꞌan ton gol gaꞌ gibeꞌa, nabtsa naꞌ ulen gibeꞌa leꞌa naꞌ nak Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","No lak uxits Moisés dub uzhib giꞌib geꞌe sa bid wa, no liga ixits be men naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ");
INSERT INTO zpt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ndontsa tal ton gungea ladna naꞌ lá gak perdid, ndi gap bexa gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Leꞌa Dios uzheꞌeb nkweaꞌ ladna be men, ta weꞌe msaꞌa xa dubkama Xin xa, ndontsa tal ton gungea ladna xa lá gak perdid ndoꞌ Dios, ndi gap xa gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Leꞌa Dios mtuꞌub Xin na ndoꞌ gizhliyo naꞌanpa nsea utsaksi xa be men, leꞌa xa ndi nsealoꞌo be men ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Leꞌa bexa na ndangea ladna Xin Dios, leꞌa Dios naꞌanpa gab leꞌa bexa wa ndap ke. Parea leꞌa bexa na lá ndangea ladna xa wa, leꞌa Dios ndabla leꞌa bexa wa ndapka ke, geal leꞌa bexa lá ngungea ladna xa nabkama nak Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Leꞌa bexa wa ndap ke ndoꞌ Dios geal leꞌa zha ulen xa nak xeꞌa ten Dios ndoꞌ gizhliyo ndee, leꞌa bexa lá nlad xeꞌa wa, ndi sa ukaw nlad bexa leꞌa bexa sbeꞌen be ta ugap ndun. ");
INSERT INTO zpt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Leꞌa tal ton gun be ta ugap, leꞌa xa wa nxeeno ladna xeꞌa, no lá ibii xa ndoꞌ xeꞌa, ndontsa lá uluꞌu‑yá be ta ugap ndun xa. ");
INSERT INTO zpt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Parea tal ton gun lak nak gealngea ten Dios, leꞌa xa wa nbii ndoꞌ xeꞌa, ndontsa uluu xeꞌa wa leꞌa xa ndunka lak nlad Dios. ");
INSERT INTO zpt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsoꞌo wa leꞌa Jesús cha nchaꞌano be xmen na distrit Judea, cha uyoꞌo bexa dub ndeꞌep sa wa, no ngoleaꞌ Jesús be men. ");
INSERT INTO zpt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Leꞌa Juan noga ngoleaꞌ be men sa nsaleaꞌ Enón gax sa nde gezh Salim, geal leꞌa sa wa kwaꞌal nits ncho. Leꞌa be men nchaꞌbe wats Juan, cha ulaleaꞌ xa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Leꞌa ta wa zha biseata ikea Juan litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Weꞌe leꞌa be xmen Juan no stapla bexa judio usaxan ndeyotoꞌo cuent ten xteꞌe nsambiꞌi bexa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Leꞌa be xmen Juan cha ulayaꞌ wats Juan, cha ndab bexa: —Mech, leꞌa xa na li ulen wats go stub toꞌo yowbeꞌe Jordán, xa na li mbidiꞌizh ga cuent ten na, leꞌa xa wa no ngoleaꞌ be men no itea be men nchaꞌbe wats xa. ");
INSERT INTO zpt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Leꞌa Juan cha ndab: —Naꞌan xtaꞌan yoo gan gun dub men tal leꞌa Dios naꞌanpa usaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Leꞌa bego uniꞌí leꞌa naꞌ ndáp leꞌa naꞌ naꞌanpa leꞌa nak Cristo, leꞌa naꞌ ndee ndi nak xa nedtsa mtuꞌub Dios ndoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Leꞌa sa nchilyaꞌa dub men leꞌa xagots nak xa tenka xabgiꞌi nchilyaꞌa wa. Leꞌa amig ten xabgiꞌi nchilyaꞌa wa nsoꞌ wats xa no uzhebpa nten ladna xa gor na ndoꞌón xa ti xabgiꞌi wa. No liga leꞌa naꞌ uzhebpa nten ladna nat ta na ndon naꞌ ta ndun Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nsabndoꞌka leꞌa xa wa nsayak mas dub xa nsak, ná leꞌa naꞌ ndee ndi nsayak dub xa uxee nsak. ");
INSERT INTO zpt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Leꞌa Jesús xa ulen gibeꞌa, no mas nsak xa ndoꞌ itea be men. Leꞌa bexa ncho ndoꞌ gizhliyo ndee mentsa nak, no ndadiꞌizh bexa ta ncho ndoꞌ gizhliyo. Ta weꞌe leꞌa xa na ulen gibeꞌa wa mas nsak ndoꞌ itea be men. ");
INSERT INTO zpt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Leꞌa ta uniꞌí xa no ta mbiꞌín xa, ta weꞌe ndadiꞌizh xa, parea leꞌa be men lá ndangea ladna ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ná leꞌa tal ton ndangea ladna ta ndadiꞌizh Jesús, leꞌa ta wa nluu leꞌa xa ngondoꞌ leꞌa Dios sbeꞌen gealngea ndadiꞌizh. ");
INSERT INTO zpt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Leꞌa Dios leꞌa mtuꞌub Jesús ndadiꞌizh xa diꞌizh ten Dios, no uzhebpa nsaꞌa Dios Espíritu ten na ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Leꞌa Tad Dios nkweaꞌ ladna Xin na, no msaꞌa Dios itea be taꞌa inibeꞌe xa. ");
INSERT INTO zpt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Leꞌa tal ton gungea ladna Xin Dios, leꞌa xa wa gap gealnaban nunk lá idub. Parea leꞌa tal ton lá nlad gungea ladna Xin Dios, leꞌa xa wa naꞌanpa gap gealnaban wa, leꞌa Dios ndi utsaksi xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Leꞌa Jesús uniꞌí leꞌa bexa fariseo mbiꞌínbe leꞌa Jesús mas kwaꞌad men ndap, no mas kwaꞌad bexa ngoleaꞌ Jesús ndoꞌ Juan. ");
INSERT INTO zpt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Parea leꞌa Jesús naꞌanpa leꞌa igoleaꞌ be men, ndi be xmen xa ulaleaꞌ be men.) ");
INSERT INTO zpt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Cha utoꞌo Jesús distrit Judea nseaꞌ xa leꞌakagal Galilea. ");
INSERT INTO zpt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Leꞌa nes nseaꞌ xa wa nsabndoꞌ itid xa distrit Samaria. ");
INSERT INTO zpt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Weꞌe ulayaꞌ xa toꞌo dub gezh ten Samaria nsaleaꞌ Sicar, gax sa nax yo msaꞌa Jacob xa uyoꞌo polta ndoꞌ xin xa Kosé. ");
INSERT INTO zpt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Leꞌa sa wa nsob so nsaleaꞌ so ten Jacob. Leꞌa Jesús mzhanna tant dub usea xa, cha uyatsob xa toꞌo so wa pa gor gawizh. ");
INSERT INTO zpt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Weꞌe cha ulen dub xagots xa Samaria nsealoꞌo nits. Leꞌa Jesús cha ndab ndoꞌ xa wa: —Bsaꞌa nits goꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Leꞌa gor weꞌe leꞌa be xmen Jesús nchaꞌbela gezh Sicar nchaꞌisiꞌi bexa ta gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Leꞌa xagots Samaria wa cha ukaꞌab ndab ndoꞌ Jesús: —¿Xteꞌe nab ga nits goo ga ndoꞌ naꞌ zha? Leꞌa go xa judio, ná leꞌa naꞌ ndee xagots Samaria. Li ndab xa geal leꞌa bexa judio naꞌanpa wen nak nsea bexa Samaria. ");
INSERT INTO zpt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa lu lá iniꞌí xtaꞌan nsaꞌa Dios ndoꞌ be men, ni lá iniꞌí lu ton nak naꞌ naꞌab naꞌ nits ndoꞌ lu. Tal lu uniꞌí ta wa, leꞌa lu cha inab nits ndoꞌ naꞌ, leꞌa naꞌ cha usa nits nsaꞌa gealnaban. ");
INSERT INTO zpt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Leꞌa xagots wa cha ndab: —Señor, leꞌa go ni lá ndap xtaꞌan koꞌo ga nits, ná leꞌa len so ndee wat. ¿Pa yaꞌloꞌo ga nits nsaꞌa gealnaban wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Leꞌa Jacob usan gox polta ten beuna msaꞌa so ndee ndoꞌ beuna. Leꞌa so ndee ngu xa nits no be xin xa no be xman xa. ¿Nat ndab go leꞌa go mas nsak ndoꞌ xa wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Leꞌa Jesús ukaꞌab ndab: —Leꞌa tal ton ndo nits ndee gal gor leꞌa xa gakgal ladna stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Parea leꞌa tal ton goo nits usa naꞌ ndee wa, leꞌa xa wa naꞌantapa gak ladna. Leꞌa nits usa naꞌ wa yak cuent dub sa nsoblen nits, ta nsaꞌa gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Leꞌa xagots wa cha ndab: —Señor, bsaꞌa ga nits wa goꞌo naꞌ, ndontsa yá lá gakta lad naꞌ, no ni lá gal lota naꞌ nits sa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ná leꞌa Jesús cha ndab: —Byaꞌyoꞌo cheꞌal lu. ");
INSERT INTO zpt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Leꞌa xagots wa ukaꞌab ndab: —Leꞌa naꞌ lá ndap cheꞌal naꞌ. Leꞌa Jesús cha ndab: —Leꞌaka ndab lu lá ndap lu cheꞌal lu. ");
INSERT INTO zpt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Leꞌa lu ngop dub gaꞌay cheꞌal la, parea leꞌa xa nchono lu nat ndee wa naꞌanpa cheꞌal la. Ta ugeaka ta ndab lu wa. ");
INSERT INTO zpt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Weꞌe leꞌa xagots wa cha ndab: —Señor, nsak naꞌ leꞌa go dub xa ndadiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Leꞌa be usan gox ten besa ngwankea Dios geꞌe siꞌil ndee, ná leꞌa bego bexa judio ndi ndab gezh Jerusalén nsabndoꞌ yankea be men Dios. ");
INSERT INTO zpt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Leꞌa Jesús cha ndab: —Xagots, bingea ladna ta gáp naꞌ leꞌa gal dub wizh yankea bega Dios Xus beuna ni geꞌe ndee no ni Jerusalén wa. ");
INSERT INTO zpt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nat leꞌa bego xa Samaria ndankea Dios, parea leꞌa bego lá iniꞌíka xteꞌe nak xa. Leꞌa besa xa judio nchandoꞌka Dios xa na ndankea besa, leꞌa lat bexa judio itoꞌo xa koꞌo be men ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","No yoo dub wizh, leꞌa ta wa nat, leꞌa be men na ta ugeaka yankea Tad Dios wa yankea bexa xa idub ncho ladna bexa lak nak gealngea ten Dios. Leꞌa Dios nkwaꞌan be men na li yankea bexa xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Leꞌa Dios nak espíritu, ta weꞌe leꞌa be men nsabndoꞌ yankea Dios idub ncho ladna bexa lak nak gealngea ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Leꞌa xagots wa cha ndab: —Leꞌa naꞌ uní leꞌa ndoꞌ gizhliyo ilen Mesías, xa noga nsaleaꞌ Cristo. Leꞌa zha ilen xa wa cha gudiꞌizh xa itea be taꞌa ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Leꞌa Jesús cha ndab: —Leꞌa ta wa naꞌ, xa nsoꞌyadiꞌizhno lu. ");
INSERT INTO zpt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Leꞌa gor wa leꞌa be xmen Jesús mlaꞌnchaꞌ wats xa, cha ngwanseana bexa geal leꞌa xa nsoꞌyadiꞌizhno dub xagots. Parea ni dub bexa lá inabdiꞌizh ndoꞌ xa ná xtaꞌan nabdiꞌizh xagots wa, no xtaꞌan ndadiꞌizh Jesús ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Weꞌe leꞌa xagots wa cha mlausoꞌ te ten na, cha nseaꞌ xa len gezh wa, ndab xa ndoꞌ be men: ");
INSERT INTO zpt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Utseawiꞌi bega dub xa ndab itea be taꞌa mbin naꞌ. ¿Naꞌanpa leꞌa xa wa nak Cristo zha? ");
INSERT INTO zpt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Weꞌe leꞌa bexa wa cha utoꞌo nchaꞌbe sa nsob Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ndalen wa leꞌa be xmen Jesús ndab ndoꞌ xa: —Mech, udaw ga. ");
INSERT INTO zpt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ná leꞌa Jesús cha ndab: —Leꞌa naꞌ ndapka ta ndaw naꞌ, dub ta lá nchandoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Weꞌe leꞌa bexa wa cha ndabbe ndoꞌ be ltsaꞌa na: —¿Ncho ton men mbiꞌid ulaꞌa ta gaw xa baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Leꞌa Jesús cha ndab: —Leꞌa naꞌ ndun lak nlad Dios xa mtuꞌub naꞌ, no nsandoꞌ naꞌ tiꞌin msaꞌa xa gun naꞌ. Leꞌa be ta wa cuent ta ndaw naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ndab bega ndun jwalt sdap mbeꞌe gal zha na ibeleꞌe be taꞌa ndoꞌ yo. Parea leꞌa naꞌ gáp: Bwiꞌi bego nat, leꞌa be men nseabe baꞌ nak cuentta dub taꞌa myazh yá ngugal‑a ibeleꞌe‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Leꞌa bexa nteleꞌe be taꞌa wa nyax ten na. Leꞌa be ta nteleꞌe bexa wa leꞌa ta wa be men gap gealnaban kub, ta nunk lá idub. Weꞌe leꞌa bexa nteleꞌe wa no bexa ndas diꞌizh ten Dios wa junt iten ladnabe. ");
INSERT INTO zpt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Leꞌa ta ndee nak lak ndab be men, ndab bexa leꞌa dub xa ndas‑a, cha stubga xa nteleꞌe‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Leꞌa naꞌ ntuꞌub bego uteleꞌe bega be men ndoꞌ Dios, bexa gol gudiꞌizh bega ndoꞌ na. Leꞌa be men xaꞌaga ned mbin tiꞌin lat bexa wa, ná nat leꞌa bego usandoꞌ tiꞌin usaxan bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Leꞌa ta na li mbidiꞌizh xagots wa leꞌa Jesús ndab iteanak be ta mbin xa wa, ta weꞌe leꞌa kwaꞌad bexa Samaria ncho gezh wa mbingea ladna leꞌa Jesús nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Weꞌe leꞌa gor ulayaꞌ bexa wats Jesús, cha unab bexa ndoꞌ Jesús weꞌetsa yoo xa gezh wa. Leꞌa Jesús cha uyoꞌo sa wa top wizh. ");
INSERT INTO zpt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","No mas kwaꞌad bexa wa mbingea ladna Jesús, gor na mbiꞌín bexa ta ndadiꞌizh Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ndab bexa ndoꞌ xagots wa: —Nat ndangea ladna besa Jesús naꞌanpa nabtsa ta ndab lu wa. Leꞌa besa no mbiꞌín ta ndadiꞌizh xa, ta weꞌe uniꞌí besa leꞌa xa baꞌ ta ugeaka leꞌa nak Cristo, xa ngoꞌo be men ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Leꞌa zha na ngok stop wizh wa leꞌa Jesús cha utoꞌo sa wa nseaꞌ xa Galilea. ");
INSERT INTO zpt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Leꞌa Jesús leꞌaka ndab leꞌa guniꞌi ton dub profet leꞌa bexa lazh xa wa lá ndap mod ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Leꞌa Galilea ncho bexa ngwaꞌbela ujest Pascua gezh Jerusalén, sa uniꞌí bexa itea be ta mbin Jesús sa wa. Ta weꞌe leꞌa gor mlaꞌnchaꞌ Jesús distrit Galilea, leꞌa bexa wa utsin ngok ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Cha nchaꞌagal Jesús gezh Caná ten Galilea, sa myunno xa nits vin. Leꞌa gezh Capernaum ncho dub xa nsak ten xa nibeꞌe sa wa. Leꞌa xin xa wa kweaꞌ nsak. ");
INSERT INTO zpt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Leꞌa gor na mbiꞌín xa nsak wa leꞌa Jesús utoꞌo Judea mlaꞌnchaꞌgal xa Galilea, cha ulen xa wats Jesús, ndab xa yaꞌ Jesús yunyakna Jesús xin xa, leꞌa xin xa yamer gat. ");
INSERT INTO zpt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Leꞌa Jesús cha ukaꞌab ndab: —Tal leꞌa bega lá iniꞌí be uyon ndun naꞌ, leꞌa bega naꞌanpa gungea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ná leꞌa xa nsak wa cha ndab: —Señor, uxax nchaꞌ una ndontsa naꞌanpa gat xiꞌín naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Weꞌe leꞌa Jesús cha ndab: —Nat byaꞌ ta lid lu leꞌa xin lu myaklana. Leꞌa xa nsak wa cha mbingea ladna ta ndab Jesús, cha nseaꞌ xa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Leꞌa gor mtanseaꞌ xa ta lid xa, leꞌa bexa ndun tiꞌin ten xa utoꞌolabe, ndab ndoꞌ xa leꞌa xin xa myaklana. ");
INSERT INTO zpt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Leꞌa xa cha unabdiꞌizh ndoꞌ bexa ná xá gor usaxan nseayoꞌo wen ladna meꞌed wa. Leꞌa bexa cha ndab: —Naꞌag, gor nkea udub gor uzhe mtoꞌo xlea meꞌed. ");
INSERT INTO zpt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Leꞌa xus meꞌed wa cha mtseꞌa ladna pa gor weꞌeka ndab Jesús leꞌa xin xa myaklana. Ta weꞌe cha mbingea ladna xa Jesús no iteata bexa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Leꞌa ta wa biaj itop utoꞌo Jesús Judea nseaꞌ xa Galilea, cha mbin xa dub uyon sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsoꞌo wa nchogal stub ujest ten bexa judio, ta weꞌe leꞌa Jesús cha mkeagal Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Leꞌa sa nyote dub nes len gezh wa, leꞌa sa wa nsaleaꞌ Puert Ten Be Borreg. Leꞌa gax sa wa nde dub tank nits siꞌil, sa nsaleaꞌ Betesda diꞌizh hebreo. No ndebe dub gaꞌay ramad sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","No ndebe kwaꞌad bexa gizh sa wa: bexa lá naꞌ, no bexa coj, no bexa lá yoo gan isoꞌ. Ndenkeaꞌ bexa zha na iwiꞌin nits wa, ");
INSERT INTO zpt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","geal leꞌa ncho gor ndaꞌukwiꞌin dub angel ten Dios nits wa. Leꞌa xa na ndon ned ilaꞌyoꞌo len nits wa gor na nwiꞌin‑a, leꞌa xa wa cha nyakna guniꞌi xá gealgizh ná nsén xa. ");
INSERT INTO zpt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Leꞌa sa wa nax dub xabgiꞌi. Leꞌa xa wa gizh dub galntiꞌi bchonla liꞌin. ");
INSERT INTO zpt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Leꞌa gor na uniꞌí Jesús nax xa sa wa, weꞌe mgenna Jesús leꞌa xa uzhebpa kwenla li gizh, cha unabdiꞌizh Jesús ndoꞌ xa ndab xa: —¿Nlad lu yakna lu zha? ");
INSERT INTO zpt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Leꞌa xa gizh wa cha ukaꞌab ndab: —Señor, nladka naꞌ, parea leꞌa naꞌ lá ndap ton ulaꞌko naꞌ len nits baꞌ gor nwiꞌin‑a. Leꞌa gor nlad naꞌ ilaꞌyoꞌo naꞌ, leꞌa ncho xa nedla nlaꞌyoꞌo ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Leꞌa Jesús cha ndab: —¡Goste! Udob da ten lu baꞌ, cha usea. ");
INSERT INTO zpt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Zha leꞌa xabgiꞌi wa cha myakna. Cha udob xa da ten xa, cha usaxan nsea xa. Ná leꞌa ta wa wizh neꞌe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ta weꞌe leꞌa bexa nibeꞌe ten bexa judio cha ndab ndoꞌ xa na li myakna wa: —Leꞌa nat wizh neꞌe beuna, ta weꞌe leꞌa lu lá nsabndoꞌ yoꞌo da ten lu baꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Leꞌa xa wa cha ukaꞌab ndab: —Leꞌa xa na myunyakna naꞌ leꞌaka ndab ndoꞌ naꞌ koꞌob naꞌ da ten naꞌ, cha isea naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Leꞌa bexa wa cha unabdiꞌizh ndab bexa: —¿Ton xa ndab ndoꞌ lu kob lu da ten lu baꞌ, cha isea lu zha? ");
INSERT INTO zpt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ná leꞌa xa na li myakna wa ni lá iniꞌí ton xa wa, geal leꞌa Jesús cha mkaꞌan lat be men nde sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsoꞌo wa leꞌa Jesús cha mzheal xa wa tale ten niꞌi ten Dios, cha ndab Jesús ndoꞌ xa: —Unaꞌ, nat leꞌa lu yá myakna, yá lá gunta lu be ta ugap, ndontsa naꞌanpa yasea lu stub ta mas kweaꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Leꞌa xabgiꞌi wa cha utoꞌo ngwaꞌyab ndoꞌ bexa nibeꞌe ten bexa judio, leꞌa xa na li myunyakna xa wa leꞌa ta wa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Weꞌe leꞌa bexa wa cha ngokloo ndoꞌ Jesús, nlad bexa gut bexa Jesús, geal li mbin Jesús wizh neꞌe bexa. ");
INSERT INTO zpt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Parea leꞌa Jesús cha ndab ndoꞌ bexa wa: —Leꞌa Dios Xus naꞌ itea wizh ndun tiꞌin ndakno be men. Leꞌa naꞌ no nsabndoꞌ li gun. ");
INSERT INTO zpt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Leꞌa bexa wa nsak leꞌa ta li mbin Jesús wa dub ta lá nsabndoꞌ gun be men wizh neꞌe bexa. No ndab Jesús leꞌa Dios nak Xus xa, leꞌa ta wa gab leꞌa xa dubtsa nak no Dios. Ta weꞌe mas nlad bexa gut bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa naꞌ xa nak Xin Dios lá yoo gan gun ni dub taꞌa leꞌatsa naꞌ nlad. Leꞌa naꞌ ndi naꞌ xteꞌe ndun Dios Xus naꞌ cha litsa ndun naꞌ. Leꞌa itea ta ndun Xus naꞌ, leꞌa naꞌ nokaga li ndun. ");
INSERT INTO zpt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Leꞌa Dios Xus naꞌ nkweaꞌ ladna naꞌ, no nluu xa itea be ta ndun xa ndoꞌ naꞌ. No ncho be taꞌa mas siꞌil tiꞌi uluu xa ndoꞌ naꞌ, be ta yanseana bega. ");
INSERT INTO zpt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Leꞌa lak nxiste Dios be men ngutla cha nsaꞌa xa gealnaban ndoꞌ bexa, no liga leꞌa naꞌ xa nak Xin Dios usaꞌa gealnaban ndoꞌ bexa nlad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Leꞌa Xus naꞌ naꞌanpa leꞌa gab ná ton ndap ke, leꞌa xa ndi msaꞌa ta wa gun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Leꞌa xa li mbin ndontsa itea be men yankea naꞌ lak ndankea be men Dios Xus naꞌ. Leꞌa tal ton lá ndankea naꞌ xa nak Xin Dios, leꞌa xa wa noga lá ndankea Dios Xus naꞌ, xa mtuꞌub naꞌ ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Leꞌa naꞌ gáp ndoꞌ bego, leꞌa tal ton isakyoꞌón ta ndáp naꞌ, no igeꞌ ladna xa Dios xa mtuꞌub naꞌ, leꞌa xa wa ndapla gealnaban nunk lá idub. Naꞌanpa utsaksi Dios xa, leꞌa xa ngok cuent dub xa ngutla, ná nat leꞌa xa ndap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Leꞌa naꞌ gáp ndoꞌ bego leꞌa yoo dub gor leꞌa ta wa nat, leꞌa bexa na lá ndap gealnaban ndoꞌ Dios goꞌón ta gáp naꞌ, cha gap bexa gealnaban. ");
INSERT INTO zpt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Leꞌa lak nsaꞌa Xus naꞌ gealnaban ndoꞌ be men, no liga msaꞌa xa juers ndoꞌ naꞌ, ndontsa no naꞌ usa gealnaban ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","No msaꞌa xa diꞌizh gáp naꞌ ná ton ndap ke, geal leꞌa naꞌ nak Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Lá yanseana bega ta ndáp naꞌ wa, leꞌa gal gor leꞌa itea bexa ngut goꞌón ti naꞌ, ");
INSERT INTO zpt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","cha itoꞌo bexa len baꞌa. Leꞌa bexa na mbin be ta wen nak ndoꞌ Dios, leꞌa bexa wa yaste gap bexa gealnaban. Ná leꞌa bexa na mbin be ta ugap, leꞌa bexa wa yaste cha utsaksi Dios bexa. ");
INSERT INTO zpt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Leꞌa naꞌ lá yoo gan gun ni dub taꞌa leꞌatsa naꞌ nlad. Leꞌa zha na gáp naꞌ ná ton ndap ke, leꞌa ta wa gun naꞌ lakka ndab Xus naꞌ. Ta weꞌe leꞌa ta gáp naꞌ wa leꞌaka nak, geal leꞌa naꞌ lá ndun laktsa nlad naꞌ, ndi ndun naꞌ lak nlad Xus naꞌ, xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tal leꞌa naꞌ gudiꞌizh cuent tentsa naꞌ, leꞌa ta gudiꞌizh naꞌ wa naꞌanpa nsak. ");
INSERT INTO zpt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Parea leꞌa Xus naꞌ ndab ton nak naꞌ, no uní naꞌ leꞌa ta ndab xa wa ta nsakka. ");
INSERT INTO zpt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Leꞌa bego mtuꞌub pla be men ndoꞌ Juan xa uloleaꞌ be men. Leꞌa Juan cha ta ugeaka ndab ná ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ná leꞌa naꞌ ni lá nkiꞌin men gab ton nak naꞌ. Nseꞌat naꞌ Juan wa ndontsa gungea ladna bega ta ndab xa, cha koꞌo Dios bega ndoꞌ be ke ten bega. ");
INSERT INTO zpt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Leꞌa Juan wa nak cuent dub xeꞌa aceit nsayolꞌ nsu‑yá xeꞌa ndoꞌ bego. Dub ndeꞌeptsa mten ladna bega mbiꞌín bega ta mbidiꞌizh xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","’Parea ncho stub taꞌa nluu ton nak naꞌ, dub ta mas nsak ndoꞌ ta ndab Juan. Leꞌa ta wa tiꞌin msaꞌa Dios gun naꞌ. Leꞌa be ta ndun naꞌ wa nluu ton nak naꞌ, no nluu‑yá leꞌa Dios Xus naꞌ leꞌaka mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","No Xus naꞌ xa mtuꞌub naꞌ ndab ton nak naꞌ, parea leꞌa bega nunk gol goꞌón ti xa, no ni gol niꞌíndoꞌ bega xa. ");
INSERT INTO zpt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","No ni naꞌanpa ndangea ladna bega diꞌizh ten Xus naꞌ, geal leꞌa bega lá ndangea ladna naꞌ, xa mtuꞌub xa. ");
INSERT INTO zpt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Leꞌa bego uzhebpa ntsid ta nkeaniꞌi diꞌizh ten Dios, ndanbeꞌe bega leꞌa ta weꞌe gap bega gealnaban nunk lá idub. Leꞌa leꞌaka diꞌizh ten Dios wa nkeaniꞌi cuent ten naꞌ, ");
INSERT INTO zpt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","parea leꞌa bega lá kaꞌab ibii wats naꞌ ndontsa gap bega gealnaban wa. ");
INSERT INTO zpt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Leꞌa naꞌ lá nkwaꞌan ta gab be men leꞌa naꞌ xa wen. ");
INSERT INTO zpt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","No uní naꞌ xteꞌe nak bega, leꞌa bega naꞌanpa ta ugea ndankea Dios. ");
INSERT INTO zpt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Leꞌa Xus naꞌ leꞌa mtuꞌub naꞌ ndal naꞌ, ná leꞌa bego naꞌanpa nsakyoꞌón ta ndáp naꞌ. Parea tal ilen stubga xa naꞌanpa Dios utuꞌub, leꞌa bega isakyoꞌón ta gab xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xteꞌe gungea ladna bega naꞌ, tal leꞌa bega nkwaꞌan ta gab be men leꞌa bega xa wen, ná bega ni lá nkwaꞌan ta gab Dios leꞌa bega xa wen? ");
INSERT INTO zpt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lá gunbeꞌe bega leꞌa naꞌ leꞌa usake bega ndoꞌ Xus naꞌ. Leꞌa bega ngeꞌ ladna ta mkeꞌa Moisés, parea leꞌa ta wa leꞌa nluu leꞌa bega ndap ke. ");
INSERT INTO zpt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tal leꞌa bega ta ugeaka ndangea ladna ta mkeꞌa Moisés, leꞌa bega no naꞌ gungea ladna, geal leꞌa Moisés mkeꞌa cuent ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ná tal leꞌa bega lá ndangea ladna ta mkeꞌa Moisés wa, ¿xteꞌema gungea ladna bega ta ndadiꞌizh naꞌ ndee zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngol tsoꞌo wa leꞌa Jesús nsea be xmen na ukea ndoꞌ dub barco, cha utakea bexa stub toꞌo lagun Galilea, no nsaleaꞌ sa wa Tiberias ");
INSERT INTO zpt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Leꞌa kwaꞌad be men usankea tsoꞌo Jesús, geal leꞌa bexa uniꞌí be uyon mbin Jesús myunyakna xa be men gizh. ");
INSERT INTO zpt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Weꞌe leꞌa Jesús cha ukea dub bet, cha usob xa no be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Leꞌa zha wa nsayal gax ujest Pascua, dub ujest ten bexa judio. ");
INSERT INTO zpt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Leꞌa Jesús cha uniꞌí leꞌa be men kwaꞌad no nseabe wats xa. Cha ndab Jesús ndoꞌ Julip: —¿Pa isiꞌi beuna ta gaw itea be men baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Leꞌa Jesús li ndab ndontsa iniꞌí xa ná xteꞌe gab Julip, leꞌa Jesús uniꞌíla xtaꞌan gun Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Leꞌa Julip cha ndab: —Top gayoꞌo med denario lá gal isiꞌi beuna dub tuzhga pan gaw bexa kwaꞌad baꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Leꞌa stub xmen Jesús, xa nsaleaꞌ Ndres wit Simón Pedr, cha ndab ndoꞌ Jesús: ");
INSERT INTO zpt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Leꞌa sa ndee nsoꞌ dub meꞌed bgiꞌi nsoꞌno gaꞌay pan cebad no top mbeal. Parea ¿xtiꞌin dub litsa taꞌa wa ndoꞌ dub lbaꞌata men kwaꞌad baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Weꞌe leꞌa Jesús cha ndab ndoꞌ be xmen na: —Gud bego ndoꞌ be men baꞌ isob bexa. Leꞌa sa wa nchopa gixgi, cha ute be men ndoꞌ‑yá. Leꞌa lat itea bexa wa ncho pa gaꞌay mil xabgiꞌi. ");
INSERT INTO zpt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Leꞌa Jesús cha usen be pan wa, cha msaꞌa xa xno ndoꞌ Dios. Cha msaꞌa xa‑yá ndoꞌ be xmen xa utseꞌa bexa‑yá ndoꞌ be men ndebe sa wa. No liga mbinno xa be mbeal wa. Leꞌa be men cha udaw‑a gast plo nlad bexa. ");
INSERT INTO zpt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Leꞌa gor na yá mzhea bexa, cha ndab Jesús ndoꞌ be xmen na: —Bteleꞌe bega be ná myaꞌan sobr baꞌ, ndontsa naꞌanpa gazhaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Leꞌa bexa wa cha mteleꞌe dub tibtop zhum byux be ná myaꞌan sobr ndoꞌ gaꞌay pan cebad wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Leꞌa gor na uniꞌí be men uyon li mbin Jesús wa, leꞌa bexa cha ndabbe: —Leꞌa xa ndee ta ugeaka leꞌa nak profet na li ndiꞌizh ga giꞌidka ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Leꞌa Jesús cha mgenna leꞌa be men wa nlad goꞌo Jesús, gunno bexa Jesús dub rey. Ta weꞌe cha mkaꞌan Jesús sa wa, cha nabtsa xa ukeagal bet wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Leꞌa ngol gor uzhe leꞌa be xmen Jesús cha mlayoꞌo toꞌo nits wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Cha ukea bexa ndoꞌ barco, cha nchaꞌbe bexa lad gezh Capernaum. Leꞌa ta wa teꞌal‑la, ná leꞌa Jesús bi naꞌan ilaꞌnchaꞌ wats bexa. ");
INSERT INTO zpt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Leꞌa mbi cha usaxan uzhebpa ulen ndoꞌ nits wa, cha uzhebpa nwiꞌinla nits wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Leꞌa gor na yá nchabeseala bexa pa dub gaꞌay natal xoꞌop kilómetro ndoꞌ nits wa, weꞌe uniꞌí bexa Jesús nsea gax wats barco, nchaꞌseandats xa ndoꞌ nits. Cha mzheb bexa. ");
INSERT INTO zpt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Parea leꞌa Jesús cha ndab ndoꞌ bexa: —¡Lá izheb bego! ¡Leꞌa ta ndee naꞌ! ");
INSERT INTO zpt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Cha mten ladna bexa ukea Jesús ndoꞌ barco. Zha leꞌa barco wa cha ulayaꞌ ndoꞌ yo toꞌo nits, sa na ndiꞌizh nchaꞌbeka bexa. ");
INSERT INTO zpt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Leꞌa ngol stubtsa wizh leꞌa be men ndebe toꞌo nits sa utoꞌo be xmen Jesús wa mtseꞌa ladna leꞌa be xmen Jesús ukea ndoꞌ stubkama barco nde sa wa, ná leꞌa Jesús naꞌanpa no nchaꞌano bexa. ");
INSERT INTO zpt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Weꞌe leꞌa stapla barco utoꞌo gezh Tiberias cha mlanseaꞌ sa ndebe be men wa. Leꞌa sa wa gax sa na msaꞌa Jesús xno ndoꞌ Dios cuent ten pan na li udaw bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Leꞌa gor na uniꞌí be men leꞌa Jesús no be xmen xa naꞌanpa nde sa wa, weꞌe cha ukea bexa ndoꞌ be barco wa, nchaꞌkwaꞌan bexa Jesús gezh Capernaum. ");
INSERT INTO zpt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Leꞌa gor na mzheal bexa Jesús sa wa cha ndab bexa ndoꞌ Jesús: —Mech, ¿xá gor ulansea ga sa ndee zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa naꞌ gáp leꞌa bego nseabekwaꞌan naꞌ ta na mzheatsa bega udaw bega pan wa, naꞌanpa ta na nyakbeꞌena bega be uyon ndun naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lá ukwaꞌan bega ta gaw bega be ta nitndoꞌ. Ndi bkwaꞌan bega ta naꞌanpa initndoꞌ, ta usaꞌa gealnaban nunk lá idub. Leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, usa ta wa ndoꞌ bega, lak msaꞌa Tad Dios gun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Weꞌe leꞌa bexa cha unabdiꞌizh ndoꞌ Jesús, ndab bexa: —¿Xtaꞌan ta nlad Dios gun besa zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ta ndee ta nlad Dios: gungea ladna bega naꞌ, xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Weꞌe cha ndabgal bexa ndoꞌ Jesús: —Tal leꞌa go nlad gungea ladna besa ga, ¿xtaꞌan dub ta gun ga nat ndontsa gungea ladna besa ga? ");
INSERT INTO zpt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Leꞌa be usan gox polta ten beuna udaw maná utoꞌo gibeꞌa geꞌe sa bid wa, lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Leꞌa Moisés msaꞌa pan utoꞌo gibeꞌa udaw bexa.” ");
INSERT INTO zpt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa Moisés naꞌanpa leꞌa usaꞌa pan utoꞌo gibeꞌa wa. Leꞌa Xus naꞌ leꞌa nsaꞌa ta na ta ugeaka leꞌa nak pan ntoꞌo gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Leꞌa pan na nsaꞌa Dios wa, leꞌa ta wa ta utoꞌo gibeꞌa, ta nsaꞌa gealnaban ndoꞌ be men nde ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Leꞌa bexa cha ndab: —Señor, sbeꞌen pan weꞌe bsaꞌa go gaw besa. ");
INSERT INTO zpt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Leꞌa Jesús cha ndab: —Leꞌa naꞌ nak pan nsaꞌa gealnaban. Leꞌa tal ton giꞌid wats naꞌ leꞌa xa wa naꞌantapa ganna. No tal ton gungea ladna naꞌ, leꞌa xa wa naꞌantapa gak ladna. ");
INSERT INTO zpt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Parea lak ndápka naꞌ ndoꞌ bega, leꞌa bega uniꞌíka be ta ndun naꞌ, ná lá ndangea ladna bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Leꞌa itea bexa na nsaꞌa Xus naꞌ ndoꞌ naꞌ, bexa weꞌe ndiꞌid wats naꞌ no nunk naꞌ lá uxelad bexa. ");
INSERT INTO zpt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Leꞌa naꞌ ndee utoꞌo gibeꞌa, naꞌanpa ndal naꞌ gun naꞌ be ta nladtsa naꞌ. Leꞌa naꞌ ndi ndal ndontsa gun naꞌ be ta nlad Dios xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Leꞌa Xus naꞌ xa mtuꞌub naꞌ wa lá nlad gak perdid ni dub bexa nsaꞌa xa ndoꞌ naꞌ. Leꞌa xa ndi nlad ixiste naꞌ itea bexa wa ndoꞌ gealgut gal wizh lult. ");
INSERT INTO zpt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Leꞌa Dios nlad leꞌa itea bexa na ngondoꞌ leꞌa naꞌ nak Xin Dios no ndangea ladna bexa naꞌ, leꞌa bexa wa cha gap gealnaban nunk lá idub. No ixiste naꞌ bexa wa ndoꞌ gealgut gal wizh lult. ");
INSERT INTO zpt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Weꞌe leꞌa ncho bexa judio cha usaxan nisi Jesús geal ndab Jesús leꞌa Jesús leꞌa nak pan utoꞌo gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ndab bexa ndoꞌ ltsaꞌa bexa: —¿Naꞌanpa xa baꞌ Jesús xin Kosé wa zha? Leꞌa beuna nchandoꞌ xus xa no xnaꞌa xa. ¿Ná xteꞌema gab xa zha leꞌa xa xa ulen gibeꞌa? ");
INSERT INTO zpt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Leꞌa Jesús cha ndab ndoꞌ bexa: —Blaꞌa bega ta lbaꞌa nisi bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Naꞌan ton yoo gan giꞌid wats naꞌ, tal leꞌa Xus naꞌ xa mtuꞌub naꞌ lid leꞌa goꞌo xa wats naꞌ. Leꞌa naꞌ ixiste bexa wa ndoꞌ gealgut gal wizh lult. ");
INSERT INTO zpt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lak mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios: “Leꞌa Dios uluu itea be men.” Ta weꞌe leꞌa tal ton goꞌón ta ndab Xus naꞌ, cha gun xa ta wa, leꞌa xa wa giꞌid wats naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Parea naꞌan ton gol niꞌí Dios Xus naꞌ. Leꞌa dubtsa xa uniꞌíla xa, leꞌa ta wa naꞌ xa utoꞌoka wats Dios. ");
INSERT INTO zpt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Leꞌa naꞌ gáp ndoꞌ bego leꞌa tal ton gungea ladna naꞌ, leꞌa xa wa gap gealnaban ta nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Leꞌa naꞌ leꞌa nak pan nsaꞌa gealnaban. ");
INSERT INTO zpt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Leꞌa zha uyoꞌo be usan gox polta ten bega geꞌe sa bid, leꞌa bexa udaw maná, parea tsoꞌo wa leꞌa bexa wa ngutkabe. ");
INSERT INTO zpt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ná leꞌa pan nlenka gibeꞌa, leꞌa tal ton gaw pan wa leꞌa xa wa lá gat. ");
INSERT INTO zpt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Leꞌa naꞌ ndee leꞌa nak pan nban ulen gibeꞌa. Leꞌa tal ton gaw pan ndee, leꞌa xa wa gap gealnaban nunk lá idub. Leꞌa pan usa naꞌ wa beꞌal las naꞌ, ta usa naꞌ ndontsa gap be men gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Leꞌa bexa judio wa cha ndakloo, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Xteꞌe ndab xa usaꞌa xa beꞌal las xa gaw beuna zhaga? ");
INSERT INTO zpt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa tal leꞌa bega lá gaw beꞌal las naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, no lá goo bega ten ten naꞌ, leꞌa bega lá gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Leꞌa tal ton gaw beꞌal las naꞌ no goo xa ten ten naꞌ, leꞌa xa wa ndapla gealnaban ta nunk lá idub. No ixiste naꞌ xa wa ndoꞌ gealgut gal wizh lult. ");
INSERT INTO zpt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Leꞌa beꞌal las naꞌ nak ta nsabndoꞌ gaw men, no ten ten naꞌ nak ta nsabndoꞌ goo men. ");
INSERT INTO zpt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Leꞌa tal ton gaw beꞌal las naꞌ no goo xa ten ten naꞌ, leꞌa xa wa dubtsa nak no naꞌ idub tiemp. ");
INSERT INTO zpt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Leꞌa Xus naꞌ xa nban leꞌa mtuꞌub naꞌ, no nban naꞌ juers ten xa. No liga leꞌa tal ton gaw beꞌal las naꞌ, leꞌa xa wa ibanga juers ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Leꞌa pan utoꞌoka gibeꞌa naꞌanpa ltsaꞌa maná udaw be usan gox polta ten bega, leꞌa bexa ngutkabe. Parea leꞌa tal ton gaw pan ndee nban idub tiemp. ");
INSERT INTO zpt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Leꞌa be ta ndee mbidiꞌizh Jesús len niꞌi sa nzhealbe bexa judio gezh Capernaum. ");
INSERT INTO zpt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Leꞌa bexa na ndangea ladna Jesús wa gor na mbiꞌín bexa ta li ndab Jesús, leꞌa kwaꞌad bexa cha ndab ndoꞌ be ltsaꞌa na: —Uzhebpa dub ta ugan ndadiꞌizh xa baꞌ. ¿Tonma gun gan isakyoꞌón‑a? ");
INSERT INTO zpt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Leꞌa Jesús mgenna leꞌa bexa wa nisi ta ndab xa, cha ndab Jesús ndoꞌ bexa: —¿Lá nsak ladna bega ta ndáp naꞌ wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xteꞌema gunbeꞌe bega tal leꞌa bega iniꞌí leꞌa naꞌ, Xa Myak Men Ndoꞌ Gizhliyo, ikea gaꞌap, nsea naꞌ leꞌaka sa utoꞌo naꞌ? ");
INSERT INTO zpt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Leꞌa Espíritu leꞌa nsaꞌa gealnaban kub, leꞌa leꞌatsa be men lá gun gan gap gealnaban wa. Leꞌa diꞌizh ndáp naꞌ wa diꞌizh ten Espíritu ten Dios xa nsaꞌa gealnaban ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Parea leꞌa ncho bego bi lá ndangea ladna ta wa. Li ndab Jesús geal leꞌa xa zha nedkata uniꞌí ton bexa na naꞌanpa gungea ladna xa, no ton xa na yun cuent xa. ");
INSERT INTO zpt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Cha no ndab Jesús: —Ta weꞌe lakka ndáp naꞌ ndoꞌ bego, leꞌa naꞌan ton yoo gan giꞌid wats naꞌ, tal leꞌa Xus naꞌ lid ned usaꞌa gun xa ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tsoꞌo wa leꞌa kwaꞌad bexa na ndangea ladna Jesús cha mlaꞌa xa, lá ikeseanota bexa xa. ");
INSERT INTO zpt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Leꞌa Jesús cha unabdiꞌizh ndoꞌ isatibtop be xmen na, ndab xa: —¿No bego nlad ulaꞌa naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Leꞌa Simón Pedr cha ukaꞌab ndab: —Señor, ¿tonta ndoꞌ ná yaꞌbe besa zha? Leꞌa go nabtsa ndadiꞌizh diꞌizh nsaꞌa gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Leꞌa besa ndangeaka ladna go no uniꞌí besa leꞌa go nak Cristo, Xinka Dios nban. ");
INSERT INTO zpt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Leꞌa Jesús cha ndab: —Leꞌa naꞌ leꞌa mti isatibtop bega, parea leꞌa dub bega xmen maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Leꞌa Jesús li ndab cuent ten Judas Iscariot, xin dub xa nsaleaꞌ Simón. Leꞌa Judas no dub isatibtop xmen Jesús, parea tsoꞌo wa leꞌa xa leꞌa yun cuent Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngol tsoꞌo wa leꞌa Jesús cha nkesea idub Galilea. Leꞌa xa lá nlad yaꞌ Judea, geal leꞌa sa wa leꞌa bexa nibeꞌe ten bexa judio nlad gut xa. ");
INSERT INTO zpt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ná leꞌa zha wa nsayal gax dub ujest ten bexa judio, zha nyoꞌo bexa sbeꞌen len ramad dub sman. ");
INSERT INTO zpt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ta weꞌe leꞌa be wit Jesús cha ndab ndoꞌ xa: —Ikaꞌan beuna sa ndee, waꞌbe beuna Judea, ndontsa no bexa na ndangea ladna lu sa wa iniꞌí be uyon ndun lu. ");
INSERT INTO zpt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Leꞌa tal ton nlad igondoꞌ be men xa, leꞌa xa wa naꞌanpa xgaꞌach ndun be taꞌa. Ta weꞌe tal gun lu be uyon, bin be ta wa sa iniꞌí itea be men‑a. ");
INSERT INTO zpt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Li ndab bexa wa geal leꞌa bexa ni lá ndangea ladna leꞌa Jesús nak Cristo. ");
INSERT INTO zpt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Leꞌa Jesús cha ndab ndoꞌ bexa: —Leꞌa zha nsabndoꞌ gaa naꞌ Judea biseata gal, parea leꞌa bega sak yaꞌbe guniꞌi pol. ");
INSERT INTO zpt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Leꞌa be men gizhliyo naꞌanpa ndap xtaꞌan ixeeno ladna bega. Parea leꞌa ndoꞌ naꞌ ndee leꞌa bexa nxee ladna, geal leꞌa naꞌ ndadiꞌizh leꞌa be ta ndun bexa ta ugap. ");
INSERT INTO zpt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Waꞌbe bega ujest Jerusalén. Leꞌa naꞌ naꞌanpa gaa nat, leꞌa wizh na gaa naꞌ biseata gal. ");
INSERT INTO zpt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tsoꞌo na li ndab Jesús ndoꞌ bexa wa, cha myaꞌan xa Galilea. ");
INSERT INTO zpt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ná leꞌa tsoꞌo na li nchaꞌbe be wit Jesús ujest wa, weꞌe cha no Jesús utoꞌo nchaꞌa sa wa. Parea leꞌa Jesús naꞌanpa ndoꞌ gaꞌal be men nchaꞌa, leꞌa xa ndi nchaꞌa dub mod lá igondoꞌ be men xa. ");
INSERT INTO zpt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Leꞌa ndoꞌ ujest wa leꞌa bexa nibeꞌe ten bexa judio nkwaꞌan Jesús, nabdiꞌizh bexa ndoꞌ be men ndab bexa: —¿Ma xabgiꞌi weꞌe zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Leꞌa be men kwaꞌad wa xgaꞌach ndadiꞌizh cuent ten Jesús. Leꞌa ncho bexa ndab leꞌa Jesús dub xa wenka; ná nchoga bexa ndab leꞌa xa nkwiꞌinno be men. ");
INSERT INTO zpt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Parea ni dub bexa naꞌanpa gaꞌal ngudiꞌizh cuent ten Jesús, geal leꞌa bexa nzheb ndoꞌ bexa nibeꞌe ten bexa judio. ");
INSERT INTO zpt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Leꞌa ngol wizh na yá nchasea itol ujest wa, leꞌa Jesús cha nchaꞌa sa nde niꞌi ten Dios, cha usaxan nluu xa be men ndebe sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Leꞌa bexa nibeꞌe ten bexa judio ndanseanabe xteꞌe ndadiꞌizh Jesús, ndab bexa ndoꞌ be ltsaꞌa xa: —¿Xteꞌe uzhebpa ngok xabgiꞌi baꞌ zha, ná xa naꞌanpa utsid? ");
INSERT INTO zpt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Leꞌa Jesús cha ndab ndoꞌ bexa wa: —Leꞌa ta nluu naꞌ ndee naꞌanpa dub ta naꞌtsa ulabeꞌe. Leꞌa‑yá ndi diꞌizh ten Dios xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tal leꞌa bega nladka gun ta nlad Dios, leꞌa bega sgondoꞌ leꞌa ta nluꞌu naꞌ diꞌizh ten Dios, naꞌanpa ndadiꞌizh naꞌ ta ndanbeꞌetsa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Leꞌa tal ton gudiꞌizh cuent ten leꞌatsa xa, leꞌa xa nkwaꞌan ná xteꞌe gap be men mod ndoꞌ xa. Parea leꞌa naꞌ ndee nkwan ná xteꞌe gap be men mod ndoꞌ xa mtuꞌub naꞌ, ta weꞌe ndadiꞌizh naꞌ sbeꞌen ta ugea, naꞌanpa nkwiꞌinno naꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Lid msaꞌa Moisés ley ten Dios ndoꞌ bega zha? Parea ni dub bega lá nxobgek ndoꞌ ley wa. ¿Cha xtaꞌan nlad bega gut bega naꞌ? ");
INSERT INTO zpt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Leꞌa be men wa cha ndabbe: —¡Mbi bxin ncho len ladoꞌo ga! ¿Ton nlad gut ga zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ dubtsa uyon mbin wizh neꞌe be men, ta weꞌe ndanseana bega. ");
INSERT INTO zpt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Leꞌa Moisés ndab yoo beꞌe be meꞌed bgiꞌi, ta na no wizh neꞌe be men ndun bega. (Parea leꞌa ta wa naꞌanpa ta ndab Moisés, leꞌa ta wa ta mbin bexa Israel mas polta ndoꞌ Moisés.) ");
INSERT INTO zpt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Leꞌa bega ngo beꞌe be meꞌed bgiꞌi no wizh neꞌe be men ndontsa uxobgek bega ndoꞌ ley mkeꞌa Moisés. Ta weꞌe, ¿xtaꞌan ndakloo bega myunyakna naꞌ dub men gizh wizh neꞌe be men zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Naꞌanpa inisi bega naꞌ ta naꞌtsa bega ta ndun naꞌ. Ndi utsin binbeꞌe bega naga utsin nak ta ndun naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Weꞌe leꞌa ncho bexa Jerusalén ndebe sa wa ndab ndoꞌ be ltsaꞌa na: —¿Naꞌanpa xa ndee xa nkwaꞌan bexa gut bexa zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bwiꞌi bego xteꞌe ndoꞌ gaꞌal be men ndadiꞌizh xa, ná leꞌa bexa wa naꞌan xteꞌe ndab ndoꞌ xa. ¿Nati no bexa nibeꞌe ten beuna wa ndangea ladna leꞌa xa ndee leꞌa nak Cristo zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ná leꞌa zha na ilen Cristo naꞌan ton iniꞌí pa ilen xa. Parea leꞌa xa ndee uniꞌí beuna pa nak lazh na. ");
INSERT INTO zpt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Leꞌa gor wa leꞌa Jesús nsoꞌyadiꞌizh ndoꞌ be men tale ten niꞌi ten Dios, cha ugeꞌ ndab xa: —Ndab bega leꞌa bega nchandoꞌ naꞌ no uniꞌí bega pa nak lazh naꞌ. Parea leꞌa naꞌ naꞌanpa ga nladtsa naꞌ ndal. Leꞌa xa na mtuꞌub naꞌ sbeꞌen gealngea ndadiꞌizh, ná leꞌa bega lá nchandoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Parea leꞌa naꞌ nchandoꞌka xa, geal leꞌa naꞌ mtoꞌo wats xa no mtuꞌub xa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Weꞌe leꞌa ncho bexa nlad isen Jesús, parea ni dub bexa naꞌan xteꞌe ngunno xa, geal leꞌa wizh ulaꞌa Dios gun bexa ta wa biseata gal. ");
INSERT INTO zpt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ná leꞌa kwaꞌad be men mbingea ladna Jesús, ndab bexa ndoꞌ be ltsaꞌa xa: —Leꞌa xa ndee ta ugeaka leꞌa nak Cristo, leꞌa xa ndun sian be uyon lak nsabndoꞌ gun Cristo gor ilen xa. ");
INSERT INTO zpt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Leꞌa gor na mbiꞌín bexa fariseo ta na li xgaꞌach ndab be men cuent ten Jesús wa, weꞌe leꞌa bexa wa no be uleꞌay nibeꞌe cha mtuꞌub pla bexa nlaꞌach niꞌi ten Dios yaꞌbesen bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Leꞌa Jesús cha ndab ndoꞌ be men: —Leꞌa naꞌ stub ndeꞌeptsa nchoꞌo lat bega, weꞌe nsea naꞌ wats xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Leꞌa bega ukwaꞌan naꞌ, parea leꞌa bega lá izheal naꞌ. No lá gun bega gan yaꞌbe sa yoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Weꞌe leꞌa bexa nibeꞌe ten bexa judio cha ndab ndoꞌ be ltsaꞌa na: —¿Pa yaꞌ xa baꞌ zha, dub sa na ni lá izheal beuna xa? ¿Nati yaꞌ xa sa sit, sa ndencho be ltsaꞌa beuna xa judio, cha gudiꞌizh xa ndoꞌ bexa naꞌanpa xa judio zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Xteꞌe gab ta ndab xa baꞌ zha leꞌa beuna ukwaꞌan xa, parea leꞌa beuna lá izheal xa, no lá gun beuna gan yaꞌbe beuna sa yoo xa? ");
INSERT INTO zpt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Leꞌa ngol wizh yandoꞌ ujest wa, wizh mas nsak ten ujest, leꞌa Jesús cha usoꞌ sa nluu xa, cha ugeꞌ ndab xa: —Leꞌa tal ncho bega ndak ladna, utsea bega wats naꞌ, cha usa naꞌ ta goo bega. ");
INSERT INTO zpt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Leꞌa tal ton gungea ladna naꞌ, leꞌa lak nkeaniꞌi diꞌizh ten Dios leꞌa xa wa gap dub gealnaban kub cuent dub yowbeꞌe uxoꞌon nits len ladoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Leꞌa ta na li ndab Jesús wa gab leꞌa Dios usaꞌa Espíritu ten na ndoꞌ bexa na ndangea ladna Jesús. Ná leꞌa Espíritu wa biseata ilen, geal leꞌa Jesús biseata ikea gibeꞌa zha wa. ");
INSERT INTO zpt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Leꞌa gor na mbiꞌín be men ta li ndab Jesús, leꞌa ncho bexa ndab ndoꞌ be ltsaꞌa na: —¡Leꞌa xa baꞌ ta ugeaka leꞌaka profet ndiꞌizh giꞌidka wa! ");
INSERT INTO zpt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","No ncho bexa ndab: —¡Leꞌa xa baꞌ leꞌaka Cristo xa mti Dios! Ná leꞌa ncho stapla bexa ndabga: —¡Leꞌa Cristo naꞌanpa ilen Galilea! ");
INSERT INTO zpt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Leꞌa diꞌizh ten Dios nkeaniꞌi leꞌa Cristo ilen lat be xin David, leꞌa xa gak xa gezh Belén lazh David. ");
INSERT INTO zpt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ta weꞌe leꞌa bexa wa usaxan ndeyotoꞌobe ke na ndab bexa ná ton nak Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Leꞌa ncho bexa wa nlad isen Jesús, parea ni dub bexa naꞌan xteꞌe ngunno Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Leꞌa bexa nlaꞌach niꞌi ten Dios wa cha mlaꞌnchaꞌ. Weꞌe leꞌa be uleꞌay nibeꞌe nsea bexa fariseo cha unabdiꞌizh ndoꞌ bexa, ndab bexa: —¿Xtaꞌan lá ngoꞌo bega Jesús zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Leꞌa bexa nlaꞌach niꞌi ten Dios wa cha ndabbe: —¡Nunk dub xabgiꞌi lá ndadiꞌizh lak ndadiꞌizh xa wa! ");
INSERT INTO zpt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Weꞌe leꞌa bexa fariseo cha ndabbe: —¿No bego ndangea ladna be gealkwiꞌin wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Lá iniꞌí bega zha leꞌa ni dub xa nibeꞌe ten beuna xa judio no ni dub xa fariseo lá ndangea ladna Jesús? ");
INSERT INTO zpt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Leꞌa Dios utsaksi be men kwaꞌad wa, bexa na ni lá nchandoꞌ ley mkeꞌa Moisés! ");
INSERT INTO zpt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ná leꞌa sa wa nsoꞌ dub xa nsaleaꞌ Nicodemo xa fariseo, xa na ngwaꞌyadiꞌizhno Jesús dub gor teꞌal. Leꞌa xa cha ndab: ");
INSERT INTO zpt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Nsak bega zha leꞌa ley ten beuna ndab leꞌa dub men ndap ke, gor biseata goꞌón beuna ta ntsakndoꞌ xa, no koxnes beuna ta ndun xa? ");
INSERT INTO zpt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Leꞌa bexa wa cha ndabbe: —¿Noga lu nak dub xa Galilea zha? Btsid diꞌizh ten Dios, weꞌe iniꞌí lu leꞌa Galilea naꞌanpa itoꞌo ni dub profet ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Cha nseaꞌbe bexa ta lid bexa. ");
INSERT INTO zpt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Leꞌa Jesús cha nchaꞌa Bet Olivo. ");
INSERT INTO zpt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Leꞌa ngol ngot xeꞌa wa mlengal Jesús tale ten niꞌi ten Dios. Cha kwaꞌad be men ulansea wats xa. Leꞌa xa cha usob, cha usaxan nluu xa be men. ");
INSERT INTO zpt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Weꞌe leꞌa pla be mech ten ley nsea bexa fariseo ulenno dub xagots ngwaꞌigaꞌano dub xabgiꞌi naꞌanpa xabgiꞌi ten xa. Cha msoꞌ bexa xagots wa tlaw be men wa. ");
INSERT INTO zpt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Cha ndab bexa ndoꞌ Jesús: —Mech, leꞌa xagots ndee ngwaꞌigaꞌano dub xabgiꞌi naꞌanpa xabgiꞌi ten xa. ");
INSERT INTO zpt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leꞌa ley mkeꞌa Moisés unibeꞌe ulaꞌgeꞌ beuna be xagots ndun lak ta mbin xa ndee wa gast gat xa. ¿Go zha, xteꞌe gab ga? ");
INSERT INTO zpt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Leꞌa bexa wa ga ndun preb Jesús ná xteꞌe gab Jesús, ndontsa gap bexa xtaꞌan usake bexa Jesús. Weꞌe leꞌa Jesús cha usob, usaxan nkeꞌa xa ndoꞌ yo no ngutsyaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ná leꞌa be mech ten ley nsea bexa fariseo dubpa nabdiꞌizh ndoꞌ Jesús. Cha ngwasoꞌ xa, ndab xa ndoꞌ bexa wa: —Tal leꞌa dub xa nsoꞌ lat bega baꞌ lá ndap ni dub ke ndoꞌ Dios, ned xa wa ulaꞌgeꞌ xagots baꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Cha usobgal Jesús, cha mkeꞌagal xa ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ná leꞌa gor na mbiꞌín bexa na li msake xagots wa ta ndab Jesús, cha mbinbeꞌe bexa leꞌa bexa noga ndap ke. Cha ndon ned bexa gox no gast bexa ben mkaꞌan sa wa. Cha myansoꞌ nab xagots wa wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Leꞌa Jesús cha ngwasoꞌgal, cha unabdiꞌizh xa ndoꞌ xagots wa, ndab xa: —¿Nat zha ma bexa li msake lu wa nat? ¿Ni dub xa wa naꞌan xtaꞌan ngunno lu zha? ");
INSERT INTO zpt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Leꞌa xagots wa cha ukaꞌab ndab: —Ni dub xa wa naꞌan xtaꞌan ngunno naꞌ, Señor. Leꞌa Jesús cha ndab: —Ni naꞌ lá gáp leꞌa lu nsabndoꞌ gat. Nat byaꞌ, yá lá gunta lu ta ugap wa. ");
INSERT INTO zpt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Leꞌa stub biaj leꞌa Jesús ndadiꞌizh ndoꞌ be men, ndab xa: —Leꞌa naꞌ ndee leꞌa nak xeꞌa ndoꞌ be men nde ndoꞌ gizhliyo. Leꞌa tal ton isankea tsoꞌo naꞌ naꞌanpa ikesea sa ukaw, leꞌa xa ndi gap xeꞌa nsaꞌa gealnaban. ");
INSERT INTO zpt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Weꞌe leꞌa bexa fariseo cha ndabbe: —Leꞌa lu ndadiꞌizh cuent ten leꞌaka lu, ta weꞌe leꞌa ta ndadiꞌizh lu baꞌ naꞌanpa nsak. ");
INSERT INTO zpt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Leꞌa Jesús cha ukaꞌab ndab: —Mas leꞌaka naꞌ ndadiꞌizh cuent ten naꞌ, leꞌa ta ndadiꞌizh naꞌ wa ta nsakka, leꞌa naꞌ uní pa ulen naꞌ no pa gaa naꞌ. Parea leꞌa bego ni lá iniꞌí pa ulen naꞌ no pa gaa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Leꞌa bego nsake naꞌ laktsa ndanbeꞌe be men, ná leꞌa naꞌ ndee naꞌanpa nsake ni dub men nat. ");
INSERT INTO zpt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Leꞌa tal usake naꞌ be men, leꞌa ta gáp naꞌ wa ta nsakka, geal leꞌa naꞌ naꞌanpa nabtsa gun ta wa, leꞌa Xus naꞌ xa mtuꞌub naꞌ no nsoꞌ wats naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lak nkeaniꞌi ley ten bega, tal top men dubtsa gab, leꞌa ta ndab bexa wa nsakka. ");
INSERT INTO zpt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Leꞌa naꞌ ndee ndáp ton nak naꞌ, no Xus naꞌ xa mtuꞌub naꞌ noga dubtsa ndab ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Leꞌa bexa wa cha ndabbe: —¿Ma xus lu zhaga? Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa bego lá nchandoꞌ naꞌ, no ni lá nchandoꞌ bega Xus naꞌ. Tal leꞌa bega nchandoꞌ naꞌ, leꞌa bega no Xus naꞌ nchandoꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Be diꞌizh ndee uníꞌi Jesús gor nluu xa be men len niꞌi ten Dios, sa ndaꞌusaꞌa be men med gon. Parea ni dub bexa lá isen Jesús, geal leꞌa wizh ulaꞌa Dios gun bexa ta wa biseata gal. ");
INSERT INTO zpt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Leꞌa Jesús cha mbidiꞌizhgal ndoꞌ bexa ndab xa: —Leꞌa naꞌ ikaꞌan sa ndee. Weꞌe leꞌa bega cha ukwaꞌan naꞌ, parea leꞌa sa na gaa naꞌ leꞌa bega lá gun gan no yaꞌ. No zha na gat bega leꞌa be ke ten bega naꞌanpa yuꞌu. ");
INSERT INTO zpt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Leꞌa bexa nibeꞌe ten bexa judio cha ndab ndoꞌ be ltsaꞌa na: —¿Nati gut xa leꞌaka leꞌa xa, ta weꞌe ndab xa leꞌa sa yaꞌ xa leꞌa beuna lá gun gan no yaꞌ sa wa? ");
INSERT INTO zpt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Leꞌa Jesús cha ndab: —Leꞌa bego xa xan ndee, parea leꞌa naꞌ xa gaꞌap baꞌ. Leꞌa bego xa ndoꞌ gizhliyo ndee, parea leꞌa naꞌ naꞌanpa xa ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ta weꞌe ndápka naꞌ leꞌa zha na gat bega, leꞌa be ke ten bega naꞌanpa yuꞌu. Tal leꞌa bega lá gungea ladna ton nak naꞌ, leꞌa be ke ten bega naꞌanpa yuꞌu gor na gat bega. ");
INSERT INTO zpt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Leꞌa bexa cha ndabbe: —¿Tonxá lu zhaga? Leꞌa Jesús cha ndab: —Leꞌa naꞌ zha nedkata ndáp ton naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ncho sianta be ta gáp naꞌ cuent ten bega no ta usake naꞌ bega, parea ndoꞌ bego bexa ncho ndoꞌ gizhliyo leꞌa naꞌ ndáptsa ta na ndadiꞌizh xa mtuꞌub naꞌ wa, leꞌa xa gealngeatsa ndadiꞌizh. ");
INSERT INTO zpt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Parea leꞌa bexa wa lá yakbeꞌena leꞌa Jesús ndadiꞌizh cuent ten Dios Xus xa. ");
INSERT INTO zpt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ta weꞌe no ndab Jesús ndoꞌ bexa: —Leꞌa gor na yá mbinno bega naꞌ ta nlad bega, weꞌe igondoꞌ bega ton nak naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. No iniꞌí bega leꞌa naꞌ naꞌanpa ndun ta nladtsa naꞌ, leꞌa naꞌ ndi ndadiꞌizh lak mluu Xus naꞌ ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Leꞌa Xus naꞌ xa mtuꞌub naꞌ no nsoꞌ wats naꞌ. Leꞌa xa naꞌanpa nlaꞌa nab naꞌ, geal ndun naꞌ sbeꞌen ta nsak ladna xa. ");
INSERT INTO zpt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Leꞌa gor na li ndab Jesús ta wa, weꞌe leꞌa kwaꞌad be men cha mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Cha ndab Jesús ndoꞌ bexa judio na li mbingea ladna xa: —Tal leꞌa bega sbeꞌen uxobgek ndoꞌ be ta ndáp naꞌ, leꞌa bega ta ugeaka gak xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Weꞌe leꞌa bega igondoꞌ gealngea ten Dios, leꞌa gealngea wa uxaꞌak bega. ");
INSERT INTO zpt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Leꞌa bexa wa cha ndabbe: —Leꞌa Abraham leꞌa nak usan gox polta ten besa. Leꞌa besa nunk lá igayoꞌota ndoꞌ stub men. ¿Ná xteꞌe li ndab lu leꞌa besa yaꞌak zha? ");
INSERT INTO zpt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa tal ton gun be ta ugap, leꞌa xa wa ndaigayoꞌo ndoꞌ ta ugap wa. ");
INSERT INTO zpt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Leꞌa dub xa nyoꞌo ndoꞌ stubga men naꞌanpa idub tiemp yoo ta lid xa nibeꞌe xa wa. Parea leꞌa xin xa nibeꞌe wa idub tiemp ncho ta lid xus na. ");
INSERT INTO zpt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","No liga tal leꞌa Xin Dios leꞌa uxaꞌak bega ndoꞌ ta ugap, leꞌa bega ta ugeaka myaꞌak. ");
INSERT INTO zpt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Leꞌa naꞌ uníka leꞌa usan gox polta ten bega Abraham, parea leꞌa bega nlad gut naꞌ, geal leꞌa bega lá nsakyoꞌón be ta ndáp naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Leꞌa naꞌ ndee ndadiꞌizh be ta nluu Xus naꞌ ndoꞌ naꞌ, parea leꞌa bego ndun lak ndab xus bega. ");
INSERT INTO zpt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Leꞌa bexa wa cha ukaꞌab ndab bexa: —Leꞌa Abraham nak xus besa. Leꞌa Jesús cha ndab: —Tal leꞌa bega nak xinka Abraham, leꞌa bega gun ltsaꞌa be ta mbin Abraham. ");
INSERT INTO zpt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Parea nat leꞌa bega ndi nlad gut naꞌ, geal ndadiꞌizh naꞌ gealngea, ta mbidiꞌizh Dios ndoꞌ naꞌ. Leꞌa Abraham nunk lá ngun ltsaꞌa ta nlad bega gun bega wa. ");
INSERT INTO zpt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Leꞌa bega ndi ndun lak ndun xus bega. Weꞌe cha ndab bexa: —Leꞌa besa naꞌanpa nak lak dub men ni lá iniꞌí ton nak xus na. Dubtsa xus besa ncho, leꞌa xa wa Dios. ");
INSERT INTO zpt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Weꞌe leꞌa Jesús cha ndab: —Tal leꞌa xus bega Dios, leꞌa bega ta ugeaka yankea naꞌ, leꞌa naꞌ wats Dios utoꞌo ndal naꞌ ndoꞌ gizhliyo ndee. Leꞌa Dios leꞌa mtuꞌub naꞌ, naꞌanpa naꞌtsa nlad ndal. ");
INSERT INTO zpt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Xtaꞌan lá nyakbeꞌena bega ta ndáp naꞌ zha? Leꞌa bega lá nsakyoꞌón diꞌizh ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Leꞌa xus bega nak maxuꞌu, no nlad bega gun bega ta nlad xa wa. Leꞌa maxuꞌu wa gast zha nedkata ndut men. No nunk lá ndadiꞌizh maxuꞌu gealngea, geal leꞌa xa naꞌanpa nchandoꞌ gealngea. Leꞌa gor na ndadiꞌizh xa gealkwiꞌin, leꞌa xa ndun lakka nak xa, leꞌa xa uzheꞌeb dub xa ukwiꞌin, no nkiꞌil xa be men ndun bexa gealkwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ná leꞌa ta na ndadiꞌizh naꞌ gealngea, ta weꞌe leꞌa bega lá ndangea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ton bega gun gan gab dub ta ugap ndun naꞌ zha? Leꞌa naꞌ ndi sbeꞌen gealngea ndadiꞌizh. Ta weꞌe ¿xtaꞌan lá ndangea ladna bega naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Leꞌa tal ton xmenka Dios leꞌa xa wa ndoꞌón ta ndab Dios. Ná leꞌa bego naꞌanpa xmen Dios, ta weꞌe lá nsakyoꞌón bega ta ndab Dios. ");
INSERT INTO zpt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Leꞌa bexa wa cha ukaꞌab ndab: —Leꞌaka nak ta ndab besa, leꞌa lu dub xa Samaria, no ncho mbi bxin len ladoꞌo lu. ");
INSERT INTO zpt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Leꞌa Jesús cha ndab: —Leꞌa naꞌ naꞌanpa ncho mbi bxin len ladoꞌo naꞌ. Leꞌa naꞌ ndee utsintsa ndadiꞌizh cuent ten Xus naꞌ, parea leꞌa bega ndi nisi naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Leꞌa naꞌ lá nkwan xteꞌe gap be men mod ndoꞌ naꞌ. Parea ncho dub xa na nlad gap be men mod ndoꞌ naꞌ, leꞌa xa wa leꞌa gab xteꞌe nak be ta ndun bega. ");
INSERT INTO zpt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Leꞌa naꞌ gáp ndoꞌ bega leꞌa tal ton uxobgek ndoꞌ diꞌizh ten naꞌ, leꞌa xa wa nunk lá gat. ");
INSERT INTO zpt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Weꞌe cha ndab bexa nibeꞌe wa: —Nat segurka uniꞌí besa leꞌa ladoꞌo lu nchoka mbi bxin. Leꞌa Abraham no be profet ngutkabe, ná lu ndab leꞌa tal ton uxobgek ndoꞌ diꞌizh ten lu leꞌa nunk lá gat. ");
INSERT INTO zpt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xteꞌe gab lu zha mas nsak lu ndoꞌ Abraham usan gox polta ten besa? Leꞌa xa wa ngutka, no liga be profet. ¿Lu zha, xteꞌe nsak lu ton nak lu? ");
INSERT INTO zpt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Leꞌa Jesús cha ukaꞌab ndab: —Tal leꞌaka naꞌ gáp leꞌa naꞌ xa nsak, leꞌa ta gáp naꞌ wa ta naꞌan xtiꞌin. Parea leꞌa Xus naꞌ, xa na ndab bega nak Dios ten bega, xa weꞌe ndab leꞌa naꞌ xa nsakka. ");
INSERT INTO zpt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Leꞌa bego lá nchandoꞌ xa wa, ná leꞌa naꞌ ndee nchandoꞌka xa. No tal gáp naꞌ leꞌa naꞌ lá nchandoꞌ xa, leꞌa naꞌ no dub xa ukwiꞌin lak ukwiꞌin bego. Parea leꞌa naꞌ ta ugeaka nchandoꞌ xa no nxobgek naꞌ itea be ta ndab xa. ");
INSERT INTO zpt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Leꞌa Abraham usan gox polta ten bega mten ladna ta na uniꞌí xa leꞌa naꞌ gal ndoꞌ gizhliyo. Leꞌa xa uniꞌíka ta wa, cha mten ladna xa. ");
INSERT INTO zpt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Weꞌe leꞌa bexa judio wa cha ndabbe: —Lu ni tol gayoꞌo liꞌin lid ncho, ¿ná xteꞌe ndab lu leꞌa lu uniꞌí Abraham? ");
INSERT INTO zpt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Leꞌa Jesús cha ndab: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa zha na bi naꞌan Abraham yoo, leꞌa naꞌ nchoꞌola. ");
INSERT INTO zpt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Weꞌe cha usen bexa geꞌ ndiꞌizh ulaꞌgeꞌ bexa Jesús, parea leꞌa Jesús cha mkachndoꞌ utoꞌo xa sa nde niꞌi ten Dios. Utid xa gandid lat bexa wa, cha nchaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ngol dub wizh nchasea Jesús leꞌa xa uniꞌí dub xabgiꞌi zha ngolta xa lá naꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Leꞌa be xmen Jesús cha unabdiꞌizh ndab bexa ndoꞌ Jesús: —Mech, ¿xtaꞌan lbaꞌa lá naꞌ xa baꞌ idub zha ngolta xa zha? ¿Ke ten be usan ten xa‑yá, nati ke tenka xa‑yá? ");
INSERT INTO zpt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Leꞌa Jesús cha ndab: —Leꞌa xa lbaꞌa nak naꞌanpa ke ten xa no ni ke ten be usan ten xa. Parea leꞌa ta lbaꞌa nak xa baꞌ leꞌa be men iniꞌí juers ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nattsa bi tezhea leꞌa naꞌ nsabndoꞌ gun tiꞌin ndab Dios, xa mtuꞌub naꞌ. Leꞌa teꞌal sken ilen, gor na naꞌanta ton gun tiꞌin. ");
INSERT INTO zpt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Leꞌa nat bi nsoꞌ naꞌ ndoꞌ gizhliyo ndee, leꞌa naꞌ nak xeꞌa ten Dios ndoꞌ be men nde ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Leꞌa tsoꞌo na li ndab Jesús, cha mchuk xa ndoꞌ yo, cha mbindeꞌe xa dub tuzh yalan. Cha udaꞌab xa‑yá ngusndoꞌ xa lá naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Cha ndab Jesús: —Waꞌdaꞌab ngusndoꞌ lu nits tank sa nsaleaꞌ Siloé —leꞌa ta wa dub diꞌizh gab: xa mtuꞌub. Weꞌe leꞌa xa wa cha nchaꞌdaꞌab ndoꞌ na sa wa. Leꞌa gor nseaꞌ xa ta lid xa leꞌa xa naꞌla. ");
INSERT INTO zpt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Leꞌa bexa ncho gax ta lid xa, no iteata bexa na uniꞌí leꞌa xa wa ngok dub xa lá naꞌ, leꞌa bexa wa cha ndab ndoꞌ be ltsaꞌa na: —¿Naꞌanpa leꞌa xa baꞌ xa nsobnab med wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Leꞌa ncho bexa wa ndab: —Leꞌa xa baꞌ leꞌaka ta wa. Ná ncho bexa ndab: —Naꞌan, leꞌa xa baꞌ migabtsa xa wa. Parea leꞌaka xa wa cha ndab: —Leꞌa naꞌ ndee leꞌaka ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Leꞌa bexa wa cha unabdiꞌizh ndoꞌ xa ndab bexa: —¿Xteꞌe uyoꞌo gan naꞌla go nat zhaga? ");
INSERT INTO zpt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Leꞌa xa cha ukaꞌab ndab: —Leꞌa xa nsaleaꞌ Jesús wa mbindeꞌe yalan, cha udaꞌab xa‑yá ngusndoꞌ naꞌ, cha ndab xa gadaꞌab naꞌ ndoꞌ naꞌ nits Siloé. Ta weꞌe ngwaa naꞌ, no udaꞌab naꞌ ndoꞌ naꞌ, cha mnaꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Leꞌa bexa wa cha unabdiꞌizh ndab bexa: —¿Ma xa wa nat? Leꞌa xa wa cha ukaꞌab ndab xa: —Leꞌa naꞌ lá iní. ");
INSERT INTO zpt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Weꞌe leꞌa bexa wa cha mbiꞌi xa na li myakna wa ndoꞌ bexa fariseo. ");
INSERT INTO zpt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Leꞌa ta wa wizh neꞌe bexa judio, zha na li mbindeꞌe Jesús yalan, cha myunyakna Jesús ngusndoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Weꞌe leꞌa bexa fariseo no unabdiꞌizh ndoꞌ xa wa ná xteꞌe myakna ngusndoꞌ xa. Leꞌa xa cha ukaꞌab ndab: —Leꞌa xa wa udaꞌab yalan ngusndoꞌ naꞌ, cha udaꞌab naꞌ ndoꞌ naꞌ, cha mnaꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Weꞌe leꞌa ncho bexa fariseo cha ndabbe: —Leꞌa xabgiꞌi weꞌe naꞌanpa nak dub xa mtuꞌub Dios, leꞌa xa ndun ta lá nsabndoꞌ wizh neꞌe beuna. Ná nchoga bexa ndab: —Dub men ugap lá yoo gan gun be uyon ndun xa wa. Ta weꞌe naꞌanpa dubtsa ngudiꞌizh bexa ná ton nak Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Cha unabdiꞌizhgal bexa ndoꞌ xa myakna wa, ndab bexa: —¿Xteꞌe nsak lu? ¿Ton nak xa li myunyakna ngusndoꞌ lu baꞌ zha? Leꞌa xa wa cha ukaꞌab ndab xa: —Nsak naꞌ leꞌa xa wa dub profet ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Parea leꞌa bexa nibeꞌe ten bexa judio lá ndangea ladna ti ngok xa wa dub xa lá naꞌ, no uyoꞌo gan mnaꞌ xa. Ta weꞌe mtuꞌub bexa dub men ngwaꞌtezh be usan ten xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Leꞌa gor na ulen bexa wa, leꞌa bexa nibeꞌe wa cha unabdiꞌizh ndoꞌ bexa, ndab bexa: —¿Xin bega xa ndee, xa ndab bego lá naꞌ zha ngolkata xa wa zha? ¿Xteꞌexá mnaꞌ xa nat zhaga? ");
INSERT INTO zpt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Leꞌa be usan ten xa wa cha ukaꞌab ndab bexa: —Uniꞌíka besa leꞌa ta baꞌ xinka besa, noga lá naꞌka xa zha ngolta xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Parea leꞌa besa lá iniꞌí xteꞌe mnaꞌ xa nat, no ni lá iniꞌí besa ton myunyakna xa. Unabdiꞌizh bega ndoꞌ leꞌaka xa, leꞌa xa yá goxla, leꞌa xa sabka‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Li ndab bexa geal leꞌa bexa nzheb ndoꞌ bexa nibeꞌe, leꞌa bexa nibeꞌe wa yá mbidiꞌizh leꞌa guniꞌi ton gab leꞌa Jesús nak Cristo, leꞌa bexa wa kontuꞌub xa len niꞌi sa nzhealbe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ta weꞌe ndab be usan ten xa wa leꞌa xa yá goxla, inabdiꞌizh bexa nibeꞌe wa leꞌaka ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Weꞌe leꞌa bexa nibeꞌe wa cha utezhgal xabgiꞌi li myakna wa, cha ndab bexa: —Leꞌa Dios nsobwiꞌi gaꞌal gud ná xteꞌe nak xabgiꞌi wa, leꞌa besa uniꞌí leꞌa xa wa dub xa ndap ke. ");
INSERT INTO zpt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Leꞌa xa wa cha ndab: —Leꞌa naꞌ lá iní tal leꞌa xa wa xa ndap ke natal naꞌan. Parea dub ta uní naꞌ: leꞌa naꞌ ngok dub xa lá naꞌ, ná nat leꞌa naꞌ naꞌla. ");
INSERT INTO zpt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Cha ndabgal bexa: —¿Xteꞌe mbinno xa lu zha? ¿Xtaꞌan mbin xa ndontsa lbaꞌa naꞌ lu zha? ");
INSERT INTO zpt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Leꞌa xa cha ukaꞌab ndab xa: —Leꞌa naꞌ yá ndáp‑a ndoꞌ bego, ná leꞌa bega lá kaꞌab isakyoꞌón‑a. ¿Nat xtaꞌan nlad bega gáp naꞌ‑yá stub biaj? ¿Nati no bega nlad gak xmen xa wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Cha xela uníꞌi bexa ndoꞌ xa, ndab bexa: —Lu nak xmen xa wa, parea leꞌa besa nak xmen Moisés. ");
INSERT INTO zpt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Leꞌa besa uniꞌíka leꞌa Dios mbidiꞌizhno Moisés, parea leꞌa xa weꞌe leꞌa besa ni lá iniꞌí pa utoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Leꞌa xabgiꞌi wa cha ukaꞌab ndab xa: —¡Leꞌa ta ndab bega wa uzhebpa ndanseana naꞌ! Leꞌa xa wa leꞌa myunyakna ngusndoꞌ naꞌ, parea leꞌa bega lá iniꞌí pa utoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Leꞌa beuna uniꞌíka leꞌa Dios naꞌanpa goꞌón ta inab dub xa ndap ke. Parea leꞌa tal ton yankea Dios no uxobgek xa ndoꞌ Dios, leꞌa Dios soꞌónka ta inab xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunk beuna gol goꞌón yoo dub men yunyakna ngusndoꞌ dub xa lá naꞌ zha ngolta xa. ");
INSERT INTO zpt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tal leꞌa xa wa naꞌanpa nak dub xa mtuꞌub Dios, leꞌa xa lá yoo gan gun ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Leꞌa bexa cha ukaꞌab ndab bexa: —¡Leꞌa zha ngolkata lu leꞌa lu yá ndapka ke, ná lu nlad leꞌa uluu besa! Cha ulantuꞌub bexa xa sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Leꞌa Jesús mbiꞌín ta li ulantuꞌub bexa xa wa. Leꞌa ngol gor mzheal Jesús xa, cha ndab Jesús: —¿Ndangea ladna lu Xin Dios zha? ");
INSERT INTO zpt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Leꞌa xa wa cha ukaꞌab ndab xa: —Señor, gud go ná ton xa wa, ndontsa gungea lad naꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Leꞌa Jesús cha ndab: —Leꞌa lu yá uniꞌíka xa, leꞌa xa wa naꞌ, xa ndadiꞌizhno lu nat. ");
INSERT INTO zpt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Leꞌa xa wa cha ndab: —Ndangea lad naꞌ go, Señor. Cha usaxib xa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Leꞌa Jesús cha ndab: —Leꞌa naꞌ ndal ndoꞌ gizhliyo iní naꞌ ná xteꞌe nak be men. Li ndontsa leꞌa bexa lá naꞌ wa inaꞌbe, no bexa na nsak leꞌa xa naꞌka leꞌa bexa wa yaꞌan cuent dub xa lá naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Leꞌa gor na mbiꞌín pla bexa fariseo nde sa wa ta li ndab Jesús, cha ndab bexa ndoꞌ Jesús: —¿Ndab lu zha leꞌa besa ndee naꞌanpa naꞌ? ");
INSERT INTO zpt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Leꞌa Jesús cha ndab: —Tal leꞌa bega lá naꞌ, leꞌa bega naꞌanpa ndap ke ndoꞌ Dios. Parea leꞌa bega ndab leꞌa bega naꞌka, ta weꞌe leꞌa bega ndapka ke ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Leꞌa naꞌ gáp ndoꞌ bego leꞌa dub sa ndenchonyaw be borreg, tal leꞌa dub xa naꞌanpa nyoꞌo toꞌo puert sa wa cha ndi nyoꞌo xa stub lad, leꞌa xa wa dub waꞌan, dub xa nlat juers be man. ");
INSERT INTO zpt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Parea leꞌa dub xa na nyoꞌo toꞌo puert wa, leꞌa xa wa leꞌa xa nlaꞌach be borreg wa. ");
INSERT INTO zpt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Leꞌa xa na nlaꞌach toꞌo puert sa wa cha nxaꞌal‑a, cha nyoꞌo xa nlaꞌach be borreg wa. Leꞌa xa cha nbezhleaꞌ kadga dub ma ten xa. Leꞌa bema cha ndoꞌón ti xa, cha nchaꞌatoꞌono bema xa. ");
INSERT INTO zpt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Leꞌa gor na yá utatela be borreg ten xa, leꞌa xa nlaꞌach ma cha nsaned ndoꞌ ma. Leꞌa be borreg wa nchandoꞌ ti xa, cha nsankea bema tsoꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Parea leꞌa bema naꞌanpa isankea tsoꞌo dub xa lá nchandoꞌ ma, ndi uxoꞌon bema ndoꞌ xa, geal leꞌa bema lá nchandoꞌ ti xa. ");
INSERT INTO zpt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Leꞌa Jesús mbidiꞌizh ta ndee ndoꞌ be men, parea leꞌa bexa lá nyakbeꞌena xteꞌe gab ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Cha no ndab Jesús ndoꞌ bexa wa: —Leꞌa naꞌ gáp ndoꞌ bego leꞌa naꞌ leꞌa nak cuent puert sa nyote be borreg. ");
INSERT INTO zpt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Leꞌa itea bexa na ned ulen ndoꞌ naꞌ, bexa na mluu dub diꞌizh naꞌanpa ta ugea, leꞌa bexa wa cuent dub waꞌan, dub xa nlat juers be man. Parea leꞌa bexa nak cuent be xborreg naꞌ lá isakyoꞌón ta ndab bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Leꞌa naꞌ leꞌa nak cuent puert wa, geal leꞌa tal ton ndangea ladna naꞌ, leꞌa xa wa ndapka gealnaban ndoꞌ Dios. Leꞌa bexa wa nak cuent be borreg nyoꞌo ntoꞌo toꞌo puert no nzheal ma gixgi ndaw ma. ");
INSERT INTO zpt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Leꞌa dub waꞌan nsealawaꞌantsa be borreg, no nseayut xa ma, nlad xa initndoꞌ ma. Parea leꞌa naꞌ ndee ndi ndal ndontsa leꞌa bexa nak cuent be xborreg naꞌ gap gealnaban ndoꞌ Dios, no uzhebpa wen yoo bexa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Leꞌa naꞌ leꞌa nak xa utsin nlaꞌach be xmen naꞌ lak utsin nlaꞌach dub men be xborreg xa, no nsaꞌa xa leꞌaka leꞌa xa sakndoꞌ bema. ");
INSERT INTO zpt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Parea leꞌa dub xa nyaxtsa ten na ndontsa ulaꞌach xa bema, leꞌa xa naꞌanpa leꞌa ten ma. Ta weꞌe leꞌa gor na iniꞌí xa nsea dub mbee cha ulaꞌa xa bema ndi uxoꞌon xa. Weꞌe leꞌa mbee wa cha ukendoꞌ bema cha iteꞌachso bema itea lad. ");
INSERT INTO zpt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Leꞌa xa wa uxoꞌon geal leꞌa xa medtsa nlad, naꞌanpa nyuꞌno ladna xa bema. ");
INSERT INTO zpt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Leꞌa naꞌ nak cuent dub xa utsin nlaꞌach be borreg ten na. Nchandoꞌ naꞌ bexa nak be borreg ten naꞌ, no liga leꞌa bexa nchandoꞌga naꞌ, ");
INSERT INTO zpt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","lak nchandoꞌ Xus naꞌ naꞌ, no liga nchandoꞌ naꞌ Xus naꞌ. No nsa naꞌ leꞌaka naꞌ sakndoꞌ be men nak be borreg ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","No ncho stub xkwaꞌa be xmen naꞌ, bexa lá nchandoꞌ bega. Leꞌa bexa wa cuent stub xkwaꞌa borreg ncho stubga corral. Leꞌa naꞌ yunjuntka bexa wa no bexa ndee, no uxobgek bexa ndoꞌ naꞌ. Weꞌe yoo dubtsa xkwaꞌa be xmen naꞌ, no nab naꞌ gak xa nlaꞌach iteanak bexa. ");
INSERT INTO zpt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Leꞌa Xus naꞌ nkweaꞌ ladna naꞌ, geal leꞌa naꞌ nsa gealnaban ten naꞌ gat naꞌ ndontsa iban naꞌ stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Naꞌan ton gut naꞌ, ndi naꞌka usa naꞌ gat naꞌ. Leꞌa naꞌ ndap juers usa naꞌ gealnaban ten naꞌ, no ndap naꞌ juers iban naꞌ stub biaj. Leꞌa ta wa ta unibeꞌe Xus naꞌ gun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Leꞌa gor na mbiꞌín bexa judio be ta li ndab Jesús, cha stub biaj usaxan uteyotoꞌo bexa no be ltsaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ncho kwaꞌad bexa ndab: —¿Xtaꞌan nlaꞌach bego ta ndab xa baꞌ zha? Leꞌa xa ncho mbi bxin len ladoꞌo na no nsak xa gizh tont. ");
INSERT INTO zpt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ná leꞌa ncho bexa wa ndabgabe: —Leꞌa xa baꞌ naꞌanpa ndadiꞌizh lak ndadiꞌizh dub men ncho mbi bxin len ladoꞌo na. No lá gun dub mbi bxin gan inaꞌ dub xa lá naꞌ lak mbin xa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngol zha kwal zha na ngo bexa judio dub ujest ten niꞌi ten Dios nde Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Leꞌa dub wizh wa, leꞌa Jesús nkesea sa nsaleaꞌ Corredor Salomón ten niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Weꞌe leꞌa ncho bexa judio cha myaklo wats Jesús, ndab bexa: —¿Gast polxá iniꞌí besa ton nak go zhaga? Tal go leꞌa nak Cristo, gud ga‑yá ndoꞌ gaꞌal besa. ");
INSERT INTO zpt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ yá ndápka ndoꞌ bega ton nak naꞌ, ná leꞌa bego lá ngungea ladna‑yá. No leꞌa be uyon na ndun naꞌ nsea juers ten Dios Xus naꞌ, leꞌa ta wa nluukaga ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ná leꞌa bego lá ndangea ladna‑yá geal leꞌa bega naꞌanpa nak be borreg ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Leꞌa bexa nak be borreg ten naꞌ, leꞌa bexa wa ndoꞌón ti naꞌ, no nchandoꞌ naꞌ bexa, no nsankea bexa tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","No nsa naꞌ gealnaban nunk lá idub ndoꞌ bexa. Leꞌa bexa idub tiemp yoo wats Dios, no naꞌan ton koꞌo bexa ndoꞌ yaꞌa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Leꞌa Xus naꞌ, xa msaꞌa bexa ndoꞌ naꞌ, leꞌa xa wa ndon leꞌa nibeꞌe ndoꞌ itea be taꞌa, ta weꞌe naꞌan ton gun gan koꞌo bexa ndoꞌ yaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Leꞌa naꞌ no Xus naꞌ leꞌa besa dubtsa nak. ");
INSERT INTO zpt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Weꞌe leꞌa bexa wa usengal be geꞌ ndiꞌizh gut bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ná leꞌa Jesús cha ndab ndoꞌ bexa: —Sian be ta wen ndun naꞌ ndoꞌ gaꞌal bega lak msaꞌa Xus naꞌ gun naꞌ. ¿Ke ten xtaꞌanma dub ta li mbin naꞌ wa ulaꞌgeꞌ bega naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Leꞌa bexa wa cha ukaꞌab ndabbe: —Leꞌa besa naꞌanpa ulaꞌgeꞌ lu ke ten dub ta wen ndun lu. Leꞌa besa ndi ulaꞌgeꞌ lu ke ten ta na kweaꞌ uníꞌi lu ndoꞌ Dios. Leꞌa lu men gizhliyotsa, ná ndab lu leꞌa lu Dios. ");
INSERT INTO zpt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ley ndeno bega nkeaniꞌi leꞌa Dios ndab ndoꞌ be men: “Ndáp naꞌ leꞌa bega nak be dios.” ");
INSERT INTO zpt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Leꞌa beuna uniꞌíka leꞌa itea be ta ndab diꞌizh ten Dios ta ugeaka. Ta weꞌe tal leꞌa Dios li ndab ndoꞌ bexa wa leꞌa bexa no nak dios, ");
INSERT INTO zpt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿xteꞌe ndab bega leꞌa naꞌ kweaꞌ uníꞌi ndoꞌ Dios gor na ndáp naꞌ leꞌa naꞌ Xin Dios? Leꞌa Dios mti naꞌ no mtuꞌub xa naꞌ ndoꞌ gizhliyo ndee. ");
INSERT INTO zpt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tal leꞌa naꞌ naꞌanpa ndun be taꞌa lak ndun Xus naꞌ, leꞌa bega lá nsabndoꞌ gungea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Leꞌa bega naꞌanpa ndangea ladna ta ndáp naꞌ, parea nsabndoꞌ gungea ladna bega ta ndun naꞌ. Weꞌe igondoꞌ bega Xus naꞌ, no gungea ladna bega leꞌa naꞌ no Xus naꞌ dubtsa nak besa. ");
INSERT INTO zpt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Weꞌe stubgal biaj nlad bexa isen bexa Jesús, ná leꞌa Jesús cha utid tlaw bexa, naꞌanpa isen bexa xa. ");
INSERT INTO zpt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Cha nchaꞌagal xa stub toꞌo yowbeꞌe Jordán, sa mas polta ulaleaꞌ Juan be men. Cha weꞌetsa uyoꞌo Jesús dub ndeꞌep. ");
INSERT INTO zpt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Leꞌa kwaꞌad men nseabegal wats xa, ndab bexa ndoꞌ be ltsaꞌa xa: —Leꞌa Juan ta ugeaka ni dub uyon lá ngun, parea leꞌa itea ta ndab Juan cuent ten xa ndee, leꞌa ta wa ta ugeaka. ");
INSERT INTO zpt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Weꞌe leꞌa kwaꞌad bexa nde sa wa mbingea ladna leꞌa Jesús nak Cristo. ");
INSERT INTO zpt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Uyoꞌo dub xabgiꞌi nsaleaꞌ Lázaro usen gealgizh. Leꞌa xa wa xa gezh Betania, sa no nak lazh Marí no Mart itop bsan Lázaro. ");
INSERT INTO zpt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Leꞌa Marí bsan Lázaro wa xa ulo ta uxeꞌe xoꞌo Jesús tsoꞌo wa, cha mkwiꞌid xa xoꞌo Jesús nsea gichgek xa.) ");
INSERT INTO zpt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngol gor leꞌa itop bsan Lázaro wa mtuꞌub dub men ndoꞌ Jesús, ndab xa: —Señor, leꞌa Lázaro amig ten ga usen gealgizh. ");
INSERT INTO zpt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Leꞌa gor na mbiꞌín Jesús ta wa, cha ndab xa: —Leꞌa gealgizh wa naꞌanpa gut xa. Leꞌa ta wa ndi ndontsa iniꞌí be men juers ten Dios no juers ten Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Leꞌa Jesús nkea ladna Mart no Marí beal xa no Lázaro. ");
INSERT INTO zpt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Parea leꞌa gor na mbiꞌín Jesús leꞌa Lázaro usen gizh, leꞌa Jesús cha uyoꞌokata sa wa stop wizh. ");
INSERT INTO zpt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Weꞌe cha ndab xa ndoꞌ be xmen xa: —Nchaꞌbe beuna stub biaj distrit Judea. ");
INSERT INTO zpt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Leꞌa be xmen Jesús cha ndabbe: —Mech, ti plama wizh leꞌa bexa judio ncho sa wa nlad gut ga, ná nat, ¿xtaꞌan li nlad go yaꞌgal ga sa wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Leꞌa Jesús cha ukaꞌab ndab: —Ncho dub tibtop gor tezhea kad dub wizh. Leꞌa tal ton ikesea gor tezhea naꞌanpa ikateꞌeb, geal leꞌa xa naꞌ bea ndoꞌ gizhliyo ndee. ");
INSERT INTO zpt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Parea tal ton ikesea gor teꞌal, leꞌa xa skateꞌeb leꞌa gor wa naꞌan bea. ");
INSERT INTO zpt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cha no ndab Jesús: —Leꞌa Lázaro amig ten beuna ngwadgats, ná leꞌa naꞌ ndaukwan xa. ");
INSERT INTO zpt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Weꞌe leꞌa be xmen Jesús cha ndabbe: —Señor, tal leꞌa xa naxyats, leꞌa xa syakkana. ");
INSERT INTO zpt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Leꞌa ta li ndab Jesús wa gab leꞌa Lázaro ngutla, ná leꞌa be xmen Jesús ndanbeꞌe leꞌa xa naxyats‑tsa. ");
INSERT INTO zpt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Weꞌe leꞌa Jesús cha gaꞌal ndab ndoꞌ bexa: —Leꞌa Lázaro ngut. ");
INSERT INTO zpt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Leꞌa naꞌ nten ladna naꞌanpa ncho beuna sa wa gor ngut xa. Li ndontsa mas igeꞌ ladna bega naꞌ. Nat nchaꞌinaꞌ beuna xa. ");
INSERT INTO zpt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Leꞌa Tomás, xa no nsaleaꞌ Dídimo, cha ndab ndoꞌ be ltsaꞌa na: —Nchaꞌbe beuna sa wa, ndontsa no beuna gatno Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Leꞌa wizh na ulayaꞌ Jesús toꞌo gezh Betania wa, mbiꞌín xa leꞌa Lázaro mdapla wizh mgaꞌach. ");
INSERT INTO zpt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Leꞌa Betania nde pa chontsa kilómetro gax Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta weꞌe leꞌa kwaꞌad bexa judio ncho Jerusalén wa ngwaꞌinaꞌ Mart no Marí, mluꞌuzh be men wa itop bexa ta na ngut bsan bexa. ");
INSERT INTO zpt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Leꞌa gor na mbiꞌín Mart leꞌa Jesús nsalayaꞌ gaxla, cha utoꞌo xa, ngwaꞌucheꞌalndoꞌ xa Jesús. Ná leꞌa Marí myaꞌan ta niꞌi. ");
INSERT INTO zpt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Leꞌa Mart cha ndab ndoꞌ Jesús: —Señor, tal leꞌa go ncho sa ndee, leꞌa bsan naꞌ naꞌanpa ngat. ");
INSERT INTO zpt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Parea leꞌa naꞌ uní leꞌa guniꞌi xtaꞌan inab go ndoꞌ Dios nat, leꞌa Dios saꞌaka‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Leꞌa Jesús cha ndab ndoꞌ Mart: —Leꞌa bsan lu sbanka. ");
INSERT INTO zpt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Leꞌa Mart cha ndab: —Leꞌa naꞌ uní leꞌa xa sbanka gal wizh lult, zha iban itea be men ngut. ");
INSERT INTO zpt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Leꞌa Jesús cha ndab: —Leꞌa naꞌ nak xa nxiste be men ndoꞌ gealgut, no nak naꞌ xa nsaꞌa gealnaban. Leꞌa tal ton gungea ladna naꞌ, maska ngut xa leꞌa xa sbanka. ");
INSERT INTO zpt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Leꞌa itea bexa nban tal gungea ladna bexa naꞌ, leꞌa bexa wa naꞌanpa gat idub tiemp. ¿Ndangea ladna lu ta ndáp naꞌ ndee zha? ");
INSERT INTO zpt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Leꞌa Mart cha ndab: —Ndungeaka lad naꞌ‑yá, Señor. No ndangea lad naꞌ leꞌa go nak Cristo Xin Dios, xa na ndiꞌizh ga giꞌidka ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tsoꞌo na li ndab Mart, weꞌe cha nseaꞌ xa ta lid xa, xagaꞌtsa ndab xa ndoꞌ Marí beal xa: —Leꞌa mech nseala no nbezh xa lu. ");
INSERT INTO zpt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Leꞌa gor na mbiꞌín Marí ta wa, cha uxax utoꞌo xa, nchaꞌinaꞌ xa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Leꞌa Jesús biseata yate len gezh wa, ndi bi nsoꞌ xa sa mzheꞌal Mart xa. ");
INSERT INTO zpt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Weꞌe leꞌa bexa ndeuluꞌuzh Marí bexa nde ta lid xa, leꞌa gor uniꞌí bexa leꞌa Marí uxax utoꞌo nchaꞌa, cha usankea bexa tsoꞌo Marí, ndab bexa leꞌa Marí nchaꞌyoꞌon toꞌo baꞌa ten Lázaro. ");
INSERT INTO zpt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Leꞌa gor na ulayaꞌ Marí wats Jesús no uniꞌí xa Jesús, cha msaxib xa ndoꞌ Jesús, ndab xa: —Señor, tal leꞌa go ncho sa ndee, leꞌa bsan naꞌ naꞌanpa ngat. ");
INSERT INTO zpt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Leꞌa gor na uniꞌí Jesús xteꞌe ndoꞌon Marí, no bexa na li ulanseano Marí wa, leꞌa xa uzhebpa uban myoꞌo ladna no kweaꞌ myoꞌo ladna xa. ");
INSERT INTO zpt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Cha ndab xa: —¿Pa mkaꞌach bega xa wa zha? Leꞌa bexa wa cha ukaꞌab ndab: —Señor, nchaꞌbe beuna, iniꞌí ga pa‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Leꞌa Jesús cha mbiꞌin. ");
INSERT INTO zpt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Weꞌe leꞌa bexa nde sa wa cha ndab ndoꞌ ltsaꞌa na: —Bwiꞌi bego ná xteꞌeta nkweaꞌ ladna xa Lázaro. ");
INSERT INTO zpt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ná leꞌa ncho bexa cha ndabbe: —Leꞌa xa ndee myunyakna dub xa lá naꞌ, ¿xtaꞌan naꞌanpa li ngun xa baꞌ gan lá ngat Lázaro zhaga? ");
INSERT INTO zpt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Leꞌa Jesús uzhebpa kweaꞌ myoꞌo ladna gor ulayaꞌ xa toꞌo baꞌa wa. Leꞌa ta wa dub geꞌloꞌo nsoꞌntsaw dub geꞌ siꞌil toꞌo‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Cha ndab Jesús: —Udob bega geꞌ baꞌ. Leꞌa Mart bsan xa ngut wa cha ndab: —Señor, leꞌa nat leꞌa xa baꞌ ugap nlaꞌala, leꞌa xa mdapla wizh mgaꞌach. ");
INSERT INTO zpt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Leꞌa Jesús cha ndab ndoꞌ Mart: —¿Cha lid ndápka naꞌ ndoꞌ lu zha, tal leꞌa lu gungea ladna naꞌ, leꞌa lu iniꞌíka juers ten Dios? ");
INSERT INTO zpt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Weꞌe leꞌa be men cha udob geꞌ toꞌo baꞌa wa. Leꞌa Jesús cha mwiꞌi gaꞌap, cha ndab xa: —Xus naꞌ, nsa naꞌ xno ndoꞌ go leꞌa go ndoꞌón ta unaꞌab naꞌ ndoꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Leꞌa naꞌ uníka leꞌa go ndoꞌónka itea be taꞌa ndáp naꞌ, parea nat li ndáp naꞌ ndontsa gungea ladna be men ndee leꞌa go leꞌaka mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tsoꞌo na li ndab Jesús, cha ugeꞌ ndab xa: —¡Lázaro, utoꞌo sa baꞌ! ");
INSERT INTO zpt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Leꞌa xa na li ngut wa cha utoꞌo sa wa, bi lima nbixyoꞌo lad yaꞌa xa no xoꞌo xa. No ndoꞌ xa bi li nbixyoꞌo dub bleꞌa lad. Leꞌa Jesús cha ndab ndoꞌ be men: —Bxaꞌak bega be lad baꞌ, cha blaꞌa bega iseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Weꞌe leꞌa bexa judio na li nseano Marí wa uniꞌí ta mbin Jesús, cha kwaꞌad bexa mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Parea leꞌa ncho bexa wa cha ndi ngwaꞌyab ndoꞌ bexa fariseo xtaꞌan mbin Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Weꞌe leꞌa be uleꞌay nibeꞌe no bexa fariseo cha mchealte itea bexa nibeꞌe ten bexa judio. Cha ndab bexa: —¿Xteꞌe gun beuna zha? Leꞌa Jesús wa sian uyon ndun. ");
INSERT INTO zpt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tal leꞌa beuna ulaꞌa li gunta xa ta wa, leꞌa itea be men sangea ladna xa. Weꞌe leꞌa bexa Roma siꞌid ulate niꞌi ten Dios ten beuna no lá ulaꞌata bexa inibeꞌe beuna sa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Leꞌa dub bexa wa xa nsaleaꞌ Caifás, xa nak uleꞌay ndon leꞌa nsak zha wa. Leꞌa xa cha ndab ndoꞌ bexa nibeꞌe wa: —Leꞌa bego naꞌan xtaꞌan iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","No ni lá nyakbeꞌena bega ndi mas wen gat dubtsa men sakndoꞌ beuna xa Israel, ndontsa naꞌanpa initndoꞌ itea beuna. ");
INSERT INTO zpt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Leꞌa ta li ndab Caifás wa naꞌanpa ndanbeꞌe leꞌatsa xa. Leꞌa ta na nak xa uleꞌay ndon leꞌa nsak zha wa, ta weꞌe mbintiꞌin Dios xa, ndab xa leꞌa Jesús gat sakndoꞌ bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Parea leꞌa ta ndab xa wa naꞌanpa nabtsa gab leꞌa Jesús gat sakndoꞌ bexa Israel. Leꞌa ta wa no gab leꞌa Jesús gat ndontsa yunjunt xa itea bexa nak xin Dios, bexa ncho idub nax ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Leꞌa wizh wa leꞌa bexa nibeꞌe ten bexa judio dubtsa mbidiꞌizh gut bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ta weꞌe leꞌa zha wa leꞌa Jesús naꞌantapa gaꞌal ikesea Judea. Leꞌa xa ndi mkaꞌan sa wa nchaꞌa xa gezh Efraín gax geꞌe sa bid. Cha uyoꞌo xa sa wa no be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Leꞌa zha wa nsayal gax ujest Pascua ten bexa judio. Ta weꞌe kwaꞌad be men judio ukea nchaꞌbe gezh Jerusalén, ndontsa gun bexa ta isambiꞌi bexa ndoꞌ Dios zha biseata gal ujest wa. ");
INSERT INTO zpt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Leꞌa be men wa nkwaꞌan Jesús, no nabdiꞌizh bexa ndoꞌ be ltsaꞌa bexa nde sa nde niꞌi ten Dios: —¿Xteꞌe nsak bega zha? ¿Siꞌid Jesús ujest ndee nati naꞌan? ");
INSERT INTO zpt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Leꞌa be uleꞌay nibeꞌe no bexa fariseo unibeꞌela ndoꞌ be men tal ncho ton iniꞌí pa nsoꞌ Jesús, cha gab xa‑yá ndoꞌ bexa wa ndontsa isen bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sxoꞌop wizh nsob gal ujest Pascua wa, leꞌa Jesús utoꞌo nchaꞌagal Betania, ta lid Lázaro xa mxiste Jesús ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Leꞌa sa wa mbindeꞌe bexa dub ta gawno bexa Jesús. Leꞌa Mart nkego ta gaw bexa. Leꞌa Lázaro nsob ndoꞌ mes no Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Weꞌe leꞌa Marí usen tol litr sbeꞌen nardo ta uxeꞌe, dub ta uzhebpa uyap nsak. Cha mtob xa‑yá tsoꞌo xoꞌo Jesús, cha mkwiꞌid xa xoꞌo Jesús no gichgek xa. Leꞌa len niꞌi wa gast idub lita uxeꞌe mlaꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Leꞌa dub xmen Jesús no nsob sa wa xa na leꞌa yun cuent Jesús, xa na nsaleaꞌ Judas Iscariot xin Simón. Leꞌa xa wa cha ndab: ");
INSERT INTO zpt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Xtaꞌan lid ndi udoꞌo xa ta uxeꞌe baꞌ zha, cha utseꞌa xa med wa ndoꞌ be men uban nak? Leꞌa ta baꞌ nsak pa chon gayoꞌo denario. ");
INSERT INTO zpt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Parea leꞌa Judas naꞌanpa nyuꞌno ladna bexa uban nak. Ndi li ndab xa geal leꞌa xa nlaꞌach med ten be xmen Jesús, no ncho zha ngowaꞌanga xa med noꞌo xa. ");
INSERT INTO zpt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Weꞌe leꞌa Jesús cha ndab ndoꞌ Judas: —Blaꞌa xagots baꞌ, leꞌa xa ulochaꞌaw ta baꞌ gast gal zha na igaꞌach naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Leꞌa bexa uban nak wa guniꞌi polga nchoka lat bega, parea leꞌa naꞌ ndee naꞌanpa kwenta nchoꞌono bega. ");
INSERT INTO zpt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Leꞌa kwaꞌadpa bexa judio mbiꞌín leꞌa Jesús nchogal gezh Betania, cha nchaꞌbe bexa sa wa. Leꞌa bexa naꞌanpa nabtsa Jesús nchaꞌbewiꞌi, leꞌa bexa nlad iniꞌí no Lázaro xa mbangal ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Weꞌe leꞌa be uleꞌay nibeꞌe wa dubtsa mbidiꞌizh gut no Lázaro, ");
INSERT INTO zpt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","geal mbangal Lázaro leꞌa kwaꞌad bexa judio nsaulaꞌa be uleꞌay nibeꞌe wa, cha ndi Jesús ndangea ladna bexa. ");
INSERT INTO zpt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ngol stub wizh wa leꞌa uzhebpa kwaꞌad be men ndencho ujest Pascua gezh Jerusalén. Leꞌa zha mbiꞌín bexa leꞌa Jesús no nchaꞌa Jerusalén, ");
INSERT INTO zpt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","cha ulobtoꞌog bexa be xos ya gin, cha utoꞌo bexa nchaꞌikanes bexa Jesús. No ugeꞌ ndab bexa: —¡Siꞌil nak xa baꞌ! ¡Dios uzhebpa nlaꞌach xa baꞌ, xa na mtuꞌub Dios Xa Nibeꞌe! ¡Leꞌa xa baꞌ leꞌa nibeꞌe beuna xa Israel! ");
INSERT INTO zpt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Leꞌa Jesús mzheal dub burr tuzh, cha usob xa tsoꞌo ma. Leꞌa ta wa lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: ");
INSERT INTO zpt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Lá izheb bego, men gezh Sion. Bwiꞌi bego, leꞌa xa leꞌa nibeꞌe bega nsea nsob tsoꞌo dub burr tuzh. ");
INSERT INTO zpt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Leꞌa zha wa leꞌa be xmen Jesús lá yakbeꞌena be ta li mbin Jesús wa. Parea tsoꞌo na mbangal Jesús cha nseaꞌ xa gibeꞌa, leꞌa bexa mtseꞌa ladna lak nkeaniꞌi diꞌizh ten Dios cuent ten Jesús, cha uniꞌí bexa leꞌa Jesús lika mbin. ");
INSERT INTO zpt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Leꞌa zha na utezh Jesús Lázaro len baꞌa, cha mxiste Jesús xa ndoꞌ gealgut, leꞌa bexa nde sa wa cha mbidiꞌizh ta uniꞌí bexa wa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ta weꞌe li ngwaꞌikanes be men Jesús, geal leꞌa bexa mbiꞌín ta na li mbin Jesús uyon wa. ");
INSERT INTO zpt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Parea leꞌa bexa fariseo ndab ndoꞌ be ltsaꞌa na: —Bwiꞌi bega, leꞌa ta na ndun beuna naꞌan xtiꞌin. Leꞌa be men ndi itea nchaꞌbe wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Leꞌa lat bexa na li nchaꞌbe yankea Dios gezh Jerusalén ujest Pascua wa, ncho pla bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Leꞌa bexa wa cha ulen wats Julip xa gezh Betsaida ten Galilea, ndab bexa: —Señor, leꞌa besa nlad iniꞌí Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Leꞌa Julip cha ngwaꞌyab‑a ndoꞌ Ndres, weꞌe itop bexa ngwaꞌyab‑a ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Leꞌa Jesús cha ukaꞌab ndab: —Yá ngol gor iniꞌí be men ta juert nak naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Leꞌa naꞌ gáp ndoꞌ bego tal leꞌa dub bid ten trig lá igaꞌach len yo cuent dub ta ngut, leꞌa idub tiemp leꞌa‑yá bidtsa gak. Ná tal leꞌa‑yá igaꞌach, leꞌa‑yá sianpa bid usaꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Leꞌa tal ton ukwaꞌan xteꞌe wen yoo xa, leꞌa xa wa ndi gun perdid gealnaban ten na ndoꞌ Dios. Parea leꞌa tal ton ndi ukwaꞌan gun ta nlad Dios, leꞌa xa wa ndi gap gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Leꞌa tal ton nlad gun tiꞌin ndoꞌ naꞌ nsabndoꞌ isankea xa tsoꞌo naꞌ. Weꞌe leꞌa sa yoꞌo naꞌ leꞌa xa no yoo. Leꞌa tal ton gun tiꞌin ndoꞌ naꞌ, leꞌa Xus naꞌ gab leꞌa xa wa wenka ndun. ");
INSERT INTO zpt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","No ndab Jesús: —Nat uzheꞌeb kweaꞌ ncho lad naꞌ, no ni lá iní naꞌ xteꞌe gáp naꞌ ndoꞌ Xus naꞌ. Ndanbeꞌe naꞌ gáp naꞌ ndoꞌ xa koꞌo xa naꞌ ndoꞌ gealkweaꞌ ndee, parea leꞌa naꞌ tiꞌin weꞌe ndal ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Leꞌa naꞌ ndi gáp: “Xus naꞌ, bin ga ta na uluu xteꞌe siꞌil nak go.” Leꞌa gor weꞌe cha mgen ti Dios ulen gibeꞌa, ndab xa ndoꞌ Jesús: —Leꞌa naꞌ mlula xteꞌe siꞌil nak naꞌ, no ulu naꞌ‑yá stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Leꞌa lat bexa kwaꞌad wa ncho bexa ndab leꞌa ta mbiꞌín bexa wa usiꞌi. No ncho bexa ndab leꞌa‑yá dub angel uníꞌi ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Leꞌa Jesús cha ndab ndoꞌ be men: —Leꞌa ta mgen wa naꞌanpa ulen por na goꞌón naꞌ‑yá, leꞌa‑yá ndi ulen ndontsa goꞌón bega‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Leꞌa nat leꞌa Dios gab ná ton ndap ke ndoꞌ gizhliyo. No nat kontuꞌub Dios maxuꞌu, xa nibeꞌe ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Leꞌa gor na ixits bexa naꞌ gaꞌap ndoꞌ yo, leꞌa naꞌ gun leꞌa be men ilen wats naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Leꞌa ta na li mbidiꞌizh Jesús wa gab leꞌa xa gat ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Leꞌa be men wa cha ndab: —Leꞌa besa mbiꞌín leꞌa ley ten Dios nkeaniꞌi leꞌa xa nak Cristo idub tiemp ncho. ¿Ná xteꞌe ndab ga zha leꞌa be men ixits Xa Myak Men Ndoꞌ Gizhliyo gaꞌap ndoꞌ yo? ¿Ton nak Xa Myak Men Ndoꞌ Gizhliyo wa zhaga? ");
INSERT INTO zpt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa nat leꞌa xa nak xeꞌa naꞌanpa kwenta ncho lat bega. Ta weꞌe usea bega nattsa bi ncho xeꞌa, ndontsa leꞌa sa ukaw naꞌanpa gun gan ndoꞌ bega. Leꞌa tal ton nsea sa ukaw, leꞌa xa wa ni lá iniꞌí pa nchaꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Leꞌa nat bi ncho xa nak xeꞌa wa, bingea ladna bega xa, ndontsa isea bega ndoꞌ xeꞌa. Leꞌa tsoꞌo na li ndab Jesús, cha nchaꞌukachndoꞌ xa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sian be uyon mbin Jesús ndoꞌ gaꞌal be men, ná leꞌa bexa lá ngungea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Li ngok ta wa lak mbidiꞌizh Isaías sakndoꞌ Dios, ndab xa: Señor Dios, ¿tonma ndangea ladna ta ndadiꞌizh besa zha? ¿No ton ndoꞌ ná mluu ga xteꞌe juert nak go zha? ");
INSERT INTO zpt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ta weꞌe leꞌa be men lá ngungea ladna Jesús, no lak ndab Isaías: ");
INSERT INTO zpt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Leꞌa Dios mtsaw ngusndoꞌ bexa, no mbin ngud Dios ladoꞌo bexa, ndontsa lá inaꞌ bexa, no ni lá yakbeꞌena bexa. Cha naꞌanpa ilen bexa wats Dios, utsuꞌu Dios be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Li ndab Isaías polta zha na uniꞌí xa xteꞌe siꞌil gak Cristo, cha mbidiꞌizh xa cuent ten Cristo. ");
INSERT INTO zpt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mas lika ná ncho kwaꞌad bexa mbingea ladna Jesús, no gast ncho bexa nibeꞌe ten bexa judio. Parea naꞌanpa gaꞌal ngudiꞌizh bexa‑yá, geal leꞌa bexa nzheb leꞌa bexa fariseo kontuꞌub bexa len niꞌi sa nzhealbe bexa judio wa. ");
INSERT INTO zpt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Leꞌa bexa wa lá nkwaꞌan xteꞌe wen yaꞌan bexa ndoꞌ Dios, ndi mas nkwaꞌan bexa xteꞌe wen yaꞌan bexa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Leꞌa Jesús cha ugeꞌ ndab: —Leꞌa tal ton gungea ladna naꞌ, leꞌa xa wa naꞌanpa nabtsa naꞌ ndangea ladna. Leꞌa xa wa no xa mtuꞌub naꞌ ndangea ladna. ");
INSERT INTO zpt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","No liga tal ton iniꞌí naꞌ, leꞌa xa wa no iniꞌí xa mtuꞌub naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Leꞌa naꞌ nak xeꞌa ulen ndoꞌ gizhliyo, ndontsa tal ton gungea ladna naꞌ, leꞌa xa wa naꞌantapa yoo sa ukaw. ");
INSERT INTO zpt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","’Leꞌa tal ton goꞌón diꞌizh ndáp naꞌ, ná lá uxobgek xa ndoꞌ‑yá, leꞌa naꞌ ndee naꞌanpa nak xa usake xa. Leꞌa naꞌ naꞌanpa ndal ndoꞌ gizhliyo usake naꞌ be men, leꞌa naꞌ ndi ndal ko naꞌ be men ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Leꞌa tal ton uxelad naꞌ no lá gungea ladna xa be diꞌizh ndáp naꞌ, leꞌa diꞌizh wa leꞌaka usake xa gal wizh lult. ");
INSERT INTO zpt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Leꞌa naꞌ ndee naꞌanpa ndadiꞌizh ta nladtsa naꞌ, leꞌa Xus naꞌ xa mtuꞌub naꞌ unibeꞌe xtaꞌan gudiꞌizh naꞌ no xtaꞌan uluꞌu naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Leꞌa naꞌ uní leꞌa diꞌizh unibeꞌe Xus naꞌ gáp naꞌ, leꞌa diꞌizh wa ta nsaꞌa gealnaban nunk lá idub. Ta weꞌe li ndadiꞌizh naꞌ lakka ndab Xus naꞌ ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Leꞌa zha na nsayal gax ujest Pascua, leꞌa Jesús uniꞌíla yamer gal gor ikaꞌan xa ndoꞌ gizhliyo, cha yaꞌ xa wats Xus xa. Lak nkweaꞌ ladna Jesús bexa nak xmen xa ndoꞌ gizhliyo ndee, bi li nkweaꞌ ladna xa bexa no gast gor ikaꞌan xa. ");
INSERT INTO zpt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Leꞌa ngol gor na nsobyaw xcheꞌe Jesús no be xmen xa, leꞌa maxuꞌu uyoꞌola gek Judas Iscariot xin Simón yun cuent Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Leꞌa Jesús uniꞌíka leꞌa Dios Xus xa msaꞌa itea be taꞌa leꞌa xa inibeꞌe. No uniꞌí xa leꞌa xa watska Dios utoꞌo, no sa weꞌekaga yaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Weꞌe ngwasoꞌ xa ndoꞌ mes sa ndeyaw bexa wa, cha ulate xa lad nbix xa. Cha mxi xa dub bleꞌa lad koꞌol len xa. ");
INSERT INTO zpt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Cha ulo xa nits len dub cheꞌa. Cha usaxan xa nsat xa xoꞌo be xmen xa, no nkwiꞌid xa xoꞌo bexa wa no lad wa. ");
INSERT INTO zpt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Leꞌa gor na ngol xa wats Simón Pedr, leꞌa Pedr cha ndab: —Señor, ¿go baꞌ usat xoꞌo naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ta lndeꞌe ndun naꞌ, leꞌa lu lá yakbeꞌena‑yá nat. Parea gal zha yakbeꞌena lu‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Leꞌa Pedr cha ndab: —¡Leꞌa naꞌ nunk lá usa xoꞌo naꞌ usat ga! Leꞌa Jesús cha ndab: —Tal leꞌa naꞌ lá usat xoꞌo lu, leꞌa lu yá lá gakta xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Leꞌa Simón Pedr cha ndab: —¡Señor, naꞌanpa nabtsa xoꞌo naꞌ usat ga, ndi no yaꞌa naꞌ no gek naꞌ usat ga! ");
INSERT INTO zpt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa xa na tiꞌi ngos nsabndoꞌ nabtsa xoꞌo na yat, leꞌa xa wa yá umbiꞌi nak. Leꞌa bego yá umbiꞌika nak ndoꞌ Dios, parea naꞌanpa itea bega. ");
INSERT INTO zpt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Leꞌa Jesús yá uniꞌíla ton yun cuent xa, ta weꞌe ndab xa leꞌa dub bexa naꞌanpa umbiꞌi nak. ");
INSERT INTO zpt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Leꞌa gor na mtaꞌusat Jesús xoꞌo bexa wa, cha ngokgal xa lad nbix xa. Cha usobgal xa ndoꞌ mes, ndab xa: —¿Nyakbeꞌena bega xtaꞌan lbaꞌa mbinno naꞌ bega zha? ");
INSERT INTO zpt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Leꞌa bega níꞌi ndoꞌ naꞌ Mech no Señor. Leꞌaka nak ta li níꞌi bega wa, geal leꞌa naꞌ lika nak. ");
INSERT INTO zpt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Leꞌa naꞌ nak Señor ten bega no Mech ten bega, parea nat msat naꞌ xoꞌo bega. No liga leꞌa bego nsabndoꞌ usat xoꞌo ltsaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Leꞌa naꞌ mluu xteꞌe nsabndoꞌ gun bega, ndontsa li gun bego lak mbinno naꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Leꞌa naꞌ gáp ndoꞌ bego leꞌa dub mos naꞌanpa mas nsak ndoꞌ xa nibeꞌe xa wa. No liga tal leꞌa dub xa mtuꞌub stubga men, leꞌa xa nchaꞌa wa naꞌanpa mas nsak ndoꞌ xa mtuꞌub xa. ");
INSERT INTO zpt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nat tal leꞌa bega nyakbeꞌena be ta ndee, no lika ndun bega, leꞌa Dios gun wen yoo ladna bega. ");
INSERT INTO zpt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Leꞌa ta ndáp naꞌ ndee naꞌanpa ndáp naꞌ cuent ten itea bega. Leꞌa naꞌ mti bega no nchandoꞌ naꞌ bega, parea nsabndoꞌ gak cumplir lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Leꞌa xa na ndawno naꞌ, leꞌa xa wa leꞌaka ngokloo ndoꞌ naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nat ndáp naꞌ ta wa ndoꞌ bego gor na biseata gak‑a, ndontsa gor na gak‑a leꞌa bega gungea ladna ton nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Leꞌa naꞌ gáp ndoꞌ bega leꞌa tal ton utsin gak ndoꞌ dub xa mtuꞌub naꞌ, leꞌa xa wa cuentkata ndoꞌ naꞌ li utsin nak. No liga tal ton utsin nak ndoꞌ naꞌ, leꞌa xa wa utsinga nak ndoꞌ Dios xa na mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tsoꞌo na li ndab Jesús ta wa, cha uzheꞌeb kweaꞌ myoꞌo ladna xa. Cha gaꞌal ndab xa ndoꞌ be xmen xa: —Leꞌa naꞌ gáp ndoꞌ bega leꞌa dub bega yun cuent naꞌ ndoꞌ bexa nlad gut naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Leꞌa be xmen xa ni lá iniꞌí ton gun ta na li ndab Jesús wa, ta weꞌe usaxan nwiꞌi bexa ndoꞌ be ltsaꞌa bexa. ");
INSERT INTO zpt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Leꞌa dub xmen Jesús, xa na leꞌa Jesús uzheꞌeb nkweaꞌ ladna, nsob wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Leꞌa Simón Pedr cha mbin sein ndoꞌ xa wa, ndontsa inabdiꞌizh xa ndoꞌ Jesús ná ton xa li gun wa. ");
INSERT INTO zpt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Leꞌa xa wa cha mas ubisob wats Jesús, cha unabdiꞌizh xa ndab xa: —Señor, ¿ton li yun cuent go zha? ");
INSERT INTO zpt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Leꞌa Jesús cha ukaꞌab ndab ndoꞌ xa wa: —Leꞌa naꞌ ugazh dub bleꞌa pan ndee. Leꞌa xa na usa naꞌ‑yá ndoꞌ na, leꞌa ta wa xa weꞌe. Leꞌa Jesús cha mgazh dub bleꞌa pan, cha msaꞌa xa‑yá ndoꞌ Judas Iscariot xin Simón. ");
INSERT INTO zpt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Leꞌa gor na li udaw Judas pan wa, leꞌa maxuꞌu cha uyote len ladoꞌo xa. Leꞌa Jesús cha ndab ndoꞌ Judas: —Leꞌa ta na li gun lu wa, uxaxtsa bin ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Parea ni dub bexa na li nde ndoꞌ mes wa lá yakbeꞌena xtaꞌan ngi li ndab Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Leꞌa Judas wa xa nlaꞌach med ndantiꞌin bexa wa. Ta weꞌe ncho bexa ndanbeꞌe leꞌa Jesús nlad yaꞌisiꞌi Judas ta guntiꞌin bexa ndoꞌ ujest. No nchoga bexa ndanbeꞌe leꞌa Jesús nlad usaꞌa Judas med ndoꞌ bexa uban nak. ");
INSERT INTO zpt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tsoꞌo na li udaw Judas dub bleꞌa pan wa, leꞌa Judas cha utoꞌo nchaꞌa. Leꞌa ta wa gor teꞌal‑la. ");
INSERT INTO zpt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Weꞌe leꞌa gor yá ukaꞌanla Judas, leꞌa Jesús cha ndab: —Leꞌa nat leꞌa be men iniꞌí xteꞌe siꞌil nak naꞌ, Xa Myak Men Ndoꞌ Gizhliyo. No ta ndun naꞌ wa uluu xteꞌe siꞌil nak Dios. ");
INSERT INTO zpt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Leꞌa ta na nluu naꞌ ndoꞌ be men xteꞌe siꞌil nak Dios, leꞌa ta ndun Dios noga uluu xteꞌe siꞌil nak naꞌ. Leꞌa ta na gun xa wa yamer gak. ");
INSERT INTO zpt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bego nak cuent xiꞌín naꞌ, yá naꞌantapa kwen nchoꞌo naꞌ lat bega. Leꞌa naꞌ gáp ndoꞌ bega lak ndápla naꞌ ndoꞌ bexa judio nibeꞌe wa: leꞌa bego ukwaꞌan naꞌ, ná leꞌa bega lá gun gan no yaꞌ sa gaa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Leꞌa naꞌ nibeꞌe dub ta kub ndoꞌ bega: Bkweaꞌ ladna bega be ltsaꞌa bega. Lak nkweaꞌ lad naꞌ bego, no liga bkweaꞌ ladna bega be ltsaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tal leꞌa bega li ikweaꞌ ladna be ltsaꞌa na, leꞌa be men igondoꞌ leꞌa bega xmenka naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Leꞌa Simón Pedr cha unabdiꞌizh ndoꞌ Jesús, ndab xa: —Señor, ¿pa yaꞌ ga zha? Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa sa na yaa naꞌ, leꞌa lu lá yoo gan yaꞌno naꞌ nat. Parea gal zha leꞌa lu noka yaꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Leꞌa Pedr cha ndab: —Señor, ¿xtaꞌan lá yoo gan gaano naꞌ go nat zhaga? Leꞌa naꞌ usa leꞌaka leꞌa naꞌ gat sakndoꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Leꞌa Jesús cha ukaꞌab ndab: —¿Snika lu gat lu sakndoꞌ naꞌ zha? Leꞌa naꞌ gáp ndoꞌ lu leꞌa teꞌal ndee gor na biseata kwezh boy leꞌa lu mkwiꞌinla chon biaj ndab lu leꞌa lu lá nchandoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Lá yuꞌta ladna bega, ndi bgeꞌ ladna bega Dios no bgeꞌ ladna bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Leꞌa ta lid Xus naꞌ ncho sian sa yoo bega. Leꞌa naꞌ naꞌanpa li gáp ndoꞌ bega tal leꞌa‑yá naꞌanpa li nak. Nat leꞌa naꞌ nsea usaxkwaꞌa sa yoo bega. ");
INSERT INTO zpt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Leꞌa zha na nsea naꞌ cha usaxkwaꞌa naꞌ be sa yoo bega, weꞌe leꞌa naꞌ leꞌaka ilen yoꞌo bega, ndontsa no bega yoo sa yoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Leꞌa bego uniꞌíka pa nsea naꞌ no nchandoꞌka bega nes nchaꞌa sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Leꞌa Tomás cha ndab: —Señor, leꞌa besa lá iniꞌí pa yaꞌ go. ¿Ta weꞌe xteꞌe ndab go leꞌa besa nchandoꞌ nes nchaꞌa sa wa zha? ");
INSERT INTO zpt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ nak nes no nak naꞌ gealngea no nak naꞌ gealnaban. Naꞌan ton ilayaꞌ wats Xus naꞌ, tal leꞌa xa naꞌanpa ndangea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tal leꞌa bego nchandoꞌ naꞌ, leꞌa bega sgondoꞌka no Xus naꞌ. Leꞌa nat idub ndoꞌ ndee leꞌa bega yá nchandoꞌ Xus naꞌ, no mnaꞌla bega xa. ");
INSERT INTO zpt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Leꞌa Julip cha ndab: —Señor, blaꞌa ga inaꞌ besa Xus ga, ta weꞌetsa nlad besa. ");
INSERT INTO zpt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Leꞌa Jesús cha ukaꞌab ndab: —Julip, ¿kwen nkeseano naꞌ bega, ná lá nchandoꞌ lu naꞌ zha? Leꞌa tal ton nchandoꞌ naꞌ, leꞌa xa wa no Xus naꞌ nchandoꞌ. ¿Xtaꞌan li ndab lu ula naꞌ inaꞌ bega Xus naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Lá ndangea ladna lu zha leꞌa naꞌ nsea Xus naꞌ dubtsa nak besa? Leꞌa ta ndadiꞌizh naꞌ naꞌanpa leꞌatsa naꞌ ndadiꞌizh. Leꞌa Xus naꞌ xa nsoꞌ wats naꞌ nsaꞌa ta li ndun naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bingea ladna bega ta ndáp naꞌ leꞌa naꞌ nsea Xus naꞌ dubtsa nak besa. Nati bingea ladna bega naꞌ ke ten be ta ndun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","’Leꞌa naꞌ gáp ndoꞌ bega leꞌa tal ton gungea ladna naꞌ, leꞌa xa wa sun ltsaꞌa be ta ndun naꞌ, no gast be ta mas siꞌil sun xa, leꞌa naꞌ nsea wats Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","No itea be ta inab bega ndoꞌ Xus naꞌ ta na nak bega xmen naꞌ, leꞌa ta wa sunka naꞌ ndontsa iniꞌí be men xteꞌe siꞌil nak Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Guniꞌi xtaꞌan inab bega ta na nak bega xmen naꞌ, leꞌa naꞌ sunka ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Leꞌa tal bega ndankeaka naꞌ, leꞌa bega uxobgek ndoꞌ be ta nibeꞌe naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Leꞌa naꞌ inaꞌab ndoꞌ Xus naꞌ, cha utuꞌub xa stub xa gakno bega no yoono xa bega idub tiemp. ");
INSERT INTO zpt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Leꞌa ta wa Espíritu ten Dios xa na nluu gealngea. Leꞌa be men gizhliyo lá yoo gan yoo wats Espíritu wa, geal leꞌa bexa naꞌanpa naꞌ xa no ni lá nchandoꞌ bexa xa. Parea leꞌa bega nchandoꞌka Espíritu wa, geal leꞌa xa nsoꞌ wats bega no ikeseano xa bega idub tiemp. ");
INSERT INTO zpt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Leꞌa naꞌ naꞌanpa ula yaꞌan bega cuent be meꞌed usaꞌab, leꞌa naꞌ ndi ilenkata. ");
INSERT INTO zpt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yamer gal zha leꞌa be men gizhliyo ndee yá naꞌantapa iniꞌí naꞌ, parea leꞌa bega sniꞌíꞌkagal naꞌ. Leꞌa naꞌ sbanka, ta weꞌe no bega ibankaga. ");
INSERT INTO zpt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Leꞌa gal wizh iban naꞌ leꞌa bega iniꞌí leꞌa naꞌ nsea Xus naꞌ dubtsa nak besa, no leꞌa bega nsea naꞌ dubtsa nak beuna. ");
INSERT INTO zpt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tal ton goꞌón be ta inibeꞌe naꞌ, no uxobgek xa ndoꞌ be ta wa, leꞌa xa wa ta ugeaka ndankea naꞌ. Leꞌa tal ton yankea naꞌ, leꞌa Xus naꞌ no naꞌ ikweaꞌ ladna xa, no ulundoꞌ naꞌ ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Weꞌe leꞌa Judas xa naꞌanpa nsaleaꞌ Iscariot cha ndab ndoꞌ Jesús: —Señor, ¿xtaꞌan li ndoꞌtsa besa ulundoꞌ ga zha, naꞌanpa ulundoꞌ ga ndoꞌ iteata be men zha? ");
INSERT INTO zpt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa tal ton yankeaka naꞌ, leꞌa xa wa sxobgek ndoꞌ ta ndáp naꞌ. Leꞌa Xus naꞌ cha ikweaꞌ ladna xa. Leꞌa naꞌ no Xus naꞌ ilen wats xa, cha yoono besa xa. ");
INSERT INTO zpt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ná leꞌa tal ton naꞌanpa yankea naꞌ, leꞌa xa wa lá uxobgek ndoꞌ ta ndáp naꞌ. Leꞌa be ta ndáp naꞌ ndoꞌ bega, leꞌa ta wa naꞌanpa ta naꞌtsa ndáp. Leꞌa ta wa ndi ta ndab Xus naꞌ xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Leꞌa be ta ndee ndáp naꞌ ndoꞌ bega nat bi nsoꞌno naꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Parea leꞌa Dios utuꞌub Espíritu ten na ndoꞌ bega, gakno xa bega no yoono xa bega sakndoꞌ naꞌ. Leꞌa xa wa uluu itea taꞌa ndoꞌ bega, no gun xa utseꞌa ladna bega itea be ta ndáp naꞌ ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Leꞌa zha na uchan naꞌ bega, leꞌa naꞌ gun utsin yoo ladna bega. Leꞌa ta na li gun naꞌ wa naꞌanpa lak ta ndun be men nde ndoꞌ gizhliyo ndee. Ta weꞌe lá yuꞌ ladna bega no lá izheb bega. ");
INSERT INTO zpt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Leꞌa bega yá mbiꞌínka ta ndáp naꞌ, leꞌa naꞌ nsea, no ilenkagal naꞌ wats bega. Leꞌa tal bega ta ugeaka ndankea naꞌ, leꞌa bega iten ladna geal ndáp naꞌ leꞌa naꞌ nsea wats Xus naꞌ, geal leꞌa Xus naꞌ mas nsak ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nattsa ndáp naꞌ ta ndee ndoꞌ bega zha biseata gak‑a ndontsa gal gor gak‑a leꞌa bega mas gungea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Leꞌa naꞌ naꞌanpa kwenta gudiꞌizhno bega, leꞌa maxuꞌu xa nibeꞌe ndoꞌ gizhliyo ndee nseala. Leꞌa xa wa naꞌanpa nibeꞌe naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Parea li nsabndoꞌ gak‑a, ndontsa iniꞌí be men nde ndoꞌ gizhliyo ndee leꞌa naꞌ ndankeaka Xus naꞌ no nxobgek naꞌ ndoꞌ ta nibeꞌe xa. ’Nat gosoꞌ bega, nchaꞌbe beuna. ");
INSERT INTO zpt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Leꞌa naꞌ ndee leꞌa xa nak cuent dub ya uv. Leꞌa Xus naꞌ nak xa na nlaꞌach‑a. ");
INSERT INTO zpt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Leꞌa tal ncho xos ya lá usaꞌa uv, leꞌa xa kabtoꞌog‑a. Parea tal leꞌa‑yá nsaꞌaka uv, leꞌa xa ndi utsambiꞌi‑yá ndontsa mas usaꞌa‑yá uv. ");
INSERT INTO zpt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Leꞌa diꞌizh ndadiꞌizh naꞌ ndoꞌ bega leꞌa mbin msambiꞌi ladoꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dubtsa gok bega no naꞌ, lak nak naꞌ dubtsa no bega. Leꞌa lak dub xos ya naꞌanpa nsob las ya wa lá yoo gan usaꞌa ngus, no liga leꞌa bega lá yoo gan gun lak nlad Dios, tal leꞌa bega naꞌanpa dubtsa gak beuna. ");
INSERT INTO zpt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Leꞌa naꞌ cuent ya uv. Leꞌa bega cuent be xos‑a. Tal leꞌa bega dubtsa nak no naꞌ, leꞌa naꞌ noga dubtsa nak no bega. Weꞌe leꞌa bega sun sianpa be taꞌa nlad Dios. Parea tal leꞌa ncho bega naꞌanpa dubtsa nak no naꞌ, leꞌa bega wa lá isuꞌu gun lak nlad Dios. ");
INSERT INTO zpt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Leꞌa tal ton naꞌanpa dubtsa nak no naꞌ, leꞌa xa wa cuent dub xos ya yabi dub lad, cha ibid‑a. Weꞌe ibeleꞌe‑yá, cha yolꞌ‑a ndoꞌ giꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Leꞌa tal leꞌa bega dubtsa nak no naꞌ, no gunka bega lak mluu naꞌ bega, unab bega guniꞌitsa xtaꞌan nlad bega ndoꞌ Dios, leꞌa Dios saꞌaka‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tal leꞌa bega gun lak nlad Dios, leꞌa ta wa uluu leꞌa bega xmenka naꞌ, weꞌe iniꞌí be men xteꞌe siꞌil nak Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Leꞌa lak nkweaꞌ ladna Xus naꞌ naꞌ, no liga leꞌa naꞌ nkweaꞌ ladna bega. Lá yalad bega leꞌa naꞌ nkweaꞌ ladna bega. ");
INSERT INTO zpt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tal leꞌa bega gun be ta nibeꞌe naꞌ, weꞌe iniꞌí bega leꞌa naꞌ nkweaꞌka ladna bega. Lak ndun naꞌ itea be taꞌa nibeꞌe Xus naꞌ ta weꞌe uní naꞌ leꞌa xa nkweaꞌka ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Leꞌa ta wa ndáp naꞌ ndoꞌ bega ndontsa uzheꞌeb iten ladna bega lak nten lad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","’Nat ta ndee nibeꞌe naꞌ ndoꞌ bega: bkweaꞌ ladna bega be ltsaꞌa bega, lakta nkweaꞌ lad naꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Leꞌa ta na ndon leꞌa mas nluu leꞌa dub men nkweaꞌ ladna stub xa, leꞌa ta wa usaꞌa xa xa gat xa sakndoꞌ be amig ten xa. ");
INSERT INTO zpt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nat leꞌa bego nak be amig ten naꞌ, tal leꞌa bega gun ta nibeꞌe naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Leꞌa naꞌ yá lá gápta leꞌa bega nak bexa ndun tiꞌin ndoꞌ naꞌ, leꞌa dub xa ndun tiꞌin ndoꞌ stub xa lá iniꞌí xtiꞌin ndun xa nibeꞌe xa. Nat ndi gáp naꞌ leꞌa bega be amig ten naꞌ, geal leꞌa naꞌ mbidiꞌizh ndoꞌ bega itea be ta ndab Xus naꞌ ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Leꞌa bega naꞌanpa leꞌa mti naꞌ, leꞌa naꞌ ndi leꞌa mti bega. No ntuꞌub naꞌ bega gun bega ta nlad Dios, ta naꞌanpa initndoꞌ. Weꞌe leꞌa itea ta inab bega ndoꞌ Dios Xus naꞌ ta na nak bega xmen naꞌ, leꞌa xa saꞌaka‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nat nibeꞌe naꞌ ta ndee ndoꞌ bega: bkweaꞌ ladna bega be ltsaꞌa bega. ");
INSERT INTO zpt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tal leꞌa be men gizhliyo ixeeno ladna bega, btseꞌa ladna bega leꞌa bexa wa nedla ndoꞌ naꞌ ndee li nxee ladna, weꞌeta ndoꞌ bego. ");
INSERT INTO zpt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tal leꞌa bega nak lak nak be men gizhliyo ndee, leꞌa be men wa utsin sak ndoꞌ bega lak utsin nak bexa ndoꞌ be ltsaꞌa xa. Parea leꞌa bega naꞌanpa nak men gizhliyo, leꞌa naꞌ mti bega utoꞌo bega lat bexa wa. Ta weꞌe nxeeno ladna bexa bega. ");
INSERT INTO zpt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Btseꞌa ladna bega ta ndáp naꞌ ndee: Leꞌa dub xa ndun tiꞌin naꞌanpa mas nsak ndoꞌ xa nibeꞌe xa wa. Lak ncho bexa li xela ndanno naꞌ, no liga xela gunno bexa bega. No lak ncho bexa nxobgek ndoꞌ diꞌizh ndáp naꞌ, no liga uxobgekga bexa ndoꞌ ta gab bega. ");
INSERT INTO zpt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Leꞌa bexa wa li gunno bega ke na nak bega xmen naꞌ, geal leꞌa bexa lá nchandoꞌ xa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Leꞌa tal naꞌ lá ngal ndoꞌ gizhliyo ndee no ni lá ngudiꞌizh naꞌ ndoꞌ bexa, leꞌa ta ugap ndun bexa wa naꞌanpa dub ke ndoꞌ Dios. Parea nat leꞌa bexa lá yoo gan gabbe leꞌa bexa lá iniꞌí ti ta ugap ndun bexa. ");
INSERT INTO zpt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Leꞌa tal ton ixee ladna ndoꞌ naꞌ, leꞌa xa wa no ndoꞌ Xus naꞌ nxee ladna. ");
INSERT INTO zpt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Leꞌa naꞌ mbin be uyon ndoꞌ gaꞌal bexa, ta ni dub men lá gun gan gun. Tal leꞌa bexa naꞌanpa iniꞌí be ta wa, leꞌa bexa naꞌanpa ndap ke ndoꞌ Dios. Parea nat li uniꞌí bexa ta ndun naꞌ wa, ná leꞌa bexa nxee ladna ndoꞌ naꞌ no ndoꞌ Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Leꞌa ta wa nak lak nkeaniꞌi ndoꞌ ley ten bexa, ndab‑a: “Leꞌa naꞌ naꞌan xtaꞌan ngunno bexa, ná leꞌa bexa mxeeno ladna naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Leꞌa gal gor na utuꞌub naꞌ xa gakno bega, leꞌa xa wa itoꞌo wats Xus naꞌ, cha gudiꞌizh xa ndoꞌ bega cuent ten naꞌ. Leꞌa xa wa Espíritu ten Dios, xa ndadiꞌizh sbeꞌen gealngea. ");
INSERT INTO zpt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Leꞌa bega cha gudiꞌizh ndoꞌ be men cuent ten naꞌ, geal leꞌa bega leꞌa ukeseano naꞌ zha nedkata usaxan naꞌ mluu naꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ndáp naꞌ ta ndee ndoꞌ bego ndontsa lá ulaꞌa bega ta ndangea ladna bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Leꞌa be men kontuꞌub bega len be niꞌi sa nzhealbe bexa judio. No gal zha gut bexa bega, gunbeꞌe bexa leꞌa ta wa ta nsak ladna Dios. ");
INSERT INTO zpt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Li gun bexa geal leꞌa bexa lá nchandoꞌ Xus naꞌ no ni naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Leꞌa naꞌ ndáp be ta ndee ndoꞌ bega nat, ndontsa gal gor wa utseꞌa ladna bega leꞌa naꞌ yá mbidiꞌizhka‑yá ndoꞌ bega. ’Leꞌa naꞌ naꞌanpa ngáp ta ndee ndoꞌ bega zha nedta, geal leꞌa naꞌ bi leꞌa ukeseano bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Parea nat leꞌa naꞌ nsea ndoꞌ Xa mtuꞌub naꞌ, ná ni dub bega lá nabdiꞌizh pa yaa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ndi uzheꞌeb uban ncho ladna bega, geal ta na ndáp naꞌ be ta ndee. ");
INSERT INTO zpt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Parea leꞌa naꞌ gáp mas wen yoo bega tal leꞌa naꞌ yaa. Leꞌa tal naꞌ lá yaa leꞌa Espíritu ten Dios xa gakno bega wa naꞌanpa ilen wats bega. Ná leꞌa tsoꞌo na yaa naꞌ leꞌa naꞌ cha utuꞌub xa wats bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Leꞌa zha ilen xa leꞌa xa gab ná ton ndap ke, no ton naꞌanpa ndap ke, no ton utsaksi Dios. ");
INSERT INTO zpt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Leꞌa bexa ndap ke wa, leꞌa ta wa be men lá ndangea ladna naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Leꞌa xa naꞌanpa ndap ke wa, leꞌa ta wa naꞌ, leꞌa naꞌ nsea wats Xus naꞌ no yá lá iniꞌíta bega naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Leꞌa xa utsaksi Dios wa, leꞌa ta wa maxuꞌu xa nibeꞌe ndoꞌ gizhliyo ndee, leꞌa Dios yá mbinbeꞌela leꞌa xa li gunno xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Uzhebpa sianta be taꞌa nlad naꞌ gáp naꞌ ndoꞌ bega, parea leꞌa bega lá uxik yakbeꞌena‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ná leꞌa zha na ilen Espíritu ten Dios xa na nluu gealngea, leꞌa xa wa gun yakbeꞌena bega idub gealngea ten Dios. Leꞌa xa wa naꞌanpa gudiꞌizh ta nitsa xa, leꞌa xa ndi gudiꞌizh be ta goꞌón xa. No gudiꞌizh xa be ta tiꞌi yoo. ");
INSERT INTO zpt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","No uluu xa xteꞌe siꞌil nak naꞌ, geal leꞌa xa gudiꞌizh cuent ten naꞌ ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Leꞌa itea be ta ndap Xus naꞌ leꞌa ta wa ta ten naꞌ. Ta weꞌe ndáp naꞌ leꞌa cuent ten naꞌ leꞌa Espíritu wa gudiꞌizh ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Yamer gal zha leꞌa bega yá lá iniꞌíta naꞌ. Parea gal stapla wizh leꞌa bega iniꞌígal naꞌ, geal leꞌa naꞌ yaa wats Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Weꞌe leꞌa ncho be xmen Jesús cha ndab ndoꞌ be ltsaꞌa na: —¿Xtaꞌan gab ta lbaꞌa ndab xa ndee zha? Ndab xa yamer gal zha leꞌa beuna lá iniꞌíta xa, ná gal stapla wizh leꞌa beuna iniꞌígal xa, geal leꞌa xa yaꞌ wats Xus xa. ");
INSERT INTO zpt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Xtaꞌan gab “yamer gal zha” wa zha? Lá nyakbeꞌena beuna xtaꞌan ndab xa. ");
INSERT INTO zpt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ná leꞌa Jesús mgenna leꞌa bexa nlad inabdiꞌizh, cha ndab Jesús: —Leꞌa bega nabdiꞌizh ndoꞌ ltsaꞌa bega cuent ten ta ndáp naꞌ, leꞌa yamer gal zha leꞌa bega lá iniꞌíta naꞌ, parea gal stapla wizh leꞌa bega iniꞌígal naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Leꞌa naꞌ gáp ndoꞌ bego leꞌa bega goꞌon no uban yoo ladna bega, parea leꞌa be men gizhliyo iten ladnabe. Mas li uban ncho ladna bega, parea leꞌa ta wa yak ndi ta iten ladna bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Leꞌa ta wa cuent dub xagots gap meꞌed uzhebpa gealkweaꞌ niꞌí xa geal leꞌa gor gap xa meꞌed wa ngol‑la. Parea gor na ngol‑la medoꞌo leꞌa xa yalad be gealkweaꞌ wa tant nten ladna xa leꞌa ndoꞌ gizhliyo ulanseagal stub meꞌed. ");
INSERT INTO zpt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","No liga nat leꞌa bega uban ncho ladna, parea leꞌa naꞌ inígal bega. Leꞌa gor wa leꞌa bega uzhebpa iten ladna, gast naꞌan ton gun gan uban yoo ladna bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Leꞌa gal wizh wa leꞌa bega yá lá inabdiꞌizhta ndoꞌ naꞌ. Leꞌa naꞌ gáp ndoꞌ bega leꞌa iteanak ta inab bega nak xmenka naꞌ ndoꞌ Xus naꞌ, leꞌa xa saꞌaka‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Gast nat naꞌan xtaꞌan nab bega ndoꞌ Xus naꞌ ta na nak bega xmen naꞌ. Parea unab bega‑yá, leꞌa Xus naꞌ saꞌaka‑yá ndontsa itenka ladna bega. ");
INSERT INTO zpt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Leꞌa be taꞌa ndadiꞌizh naꞌ wa sbeꞌen ta nsaktabeꞌe naꞌ. Parea gal gor na yá naꞌantapa li gudiꞌizh naꞌ, leꞌa naꞌ ndi gaꞌal gudiꞌizh ndoꞌ bega cuent ten Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Leꞌa gal zha weꞌe leꞌa naꞌ naꞌantapa leꞌa inaꞌab ndoꞌ Xus naꞌ sakndoꞌ bega. Leꞌa bega ndi inab ta nkiꞌin bega ndoꞌ Xus naꞌ ta na nak bega xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Leꞌa Xus naꞌ leꞌa nkweaꞌ ladna bega, geal leꞌa bega ndankea naꞌ no ndangea ladna bega leꞌa naꞌ watska Dios utoꞌo. ");
INSERT INTO zpt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Leꞌa naꞌ wats Xus naꞌ utoꞌo, ndal naꞌ ndoꞌ gizhliyo ndee. Nat leꞌa naꞌ ikaꞌan ndoꞌ gizhliyo ndee, cha nsea naꞌ wats Xus naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Leꞌa be xmen Jesús cha ndab: —Nat leꞌa go uzhebpa uyaꞌal ndadiꞌizh. Yá naꞌantapa nsaktabeꞌe ga be ta ndadiꞌizh ga. ");
INSERT INTO zpt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nat uniꞌí besa leꞌa go uniꞌí iteanak be taꞌa, naꞌanpa nkiꞌin inabdiꞌizh besa ndoꞌ ga. Ta weꞌe ndangea ladna besa leꞌa go watska Dios utoꞌo. ");
INSERT INTO zpt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Leꞌa Jesús cha ukaꞌab ndab: —¿Nat zha yá ndangeaka ladna bega naꞌ? ");
INSERT INTO zpt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Blaꞌach bega leꞌa gal dub gor leꞌa bega iteꞌachso itea lad, ulaꞌa bega nab naꞌ. Parea leꞌa naꞌ naꞌanpa nab yansoꞌ, leꞌa Xus naꞌ nokaga nsoꞌ wats naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Leꞌa be ta ndee mbidiꞌizh naꞌ ndontsa wen yoo ladna bega ta na nak bega xmen naꞌ. Leꞌa ndoꞌ gizhliyo ndee sianpa gealkweaꞌ iniꞌí bega. Parea lá yuꞌ ladna bega, leꞌa naꞌ mbinla gan ndoꞌ itea be ta ncho ndoꞌ gizhliyo ndee. ");
INSERT INTO zpt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Leꞌa tsoꞌo na li mbidiꞌizh Jesús, cha mwiꞌi xa gibeꞌa, ndab xa: —Xus naꞌ, leꞌa nat yá ngol gor uluu ga ndoꞌ be men xteꞌe siꞌil nak naꞌ, ndontsa no naꞌ uluuga xteꞌe siꞌil nak go. ");
INSERT INTO zpt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Leꞌa go msaꞌa ta nibeꞌe naꞌ ndoꞌ itea be men, ndontsa usa naꞌ gealnaban nunk lá idub ndoꞌ bexa na msaꞌa go ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Leꞌa bexa wa ndap gealnaban nunk lá idub, geal leꞌa bexa nchandoꞌ ga, xa ndon leꞌakama nak Dios; no nchandoꞌ bexa naꞌ Jesucristo, xa na mtuꞌub ga. ");
INSERT INTO zpt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Leꞌa naꞌ mluu xteꞌe siꞌil nak go ndoꞌ be men nde ndoꞌ gizhliyo ndee, no msandoꞌ naꞌ tiꞌin msaꞌa go gun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Xus naꞌ, leꞌa zha biseata yoo gizhliyo ndee, leꞌa naꞌ nak xa ndon leꞌa juert lak nak go. Nat blaꞌa ga likagal yak naꞌ wats ga stub biaj. ");
INSERT INTO zpt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Leꞌa go mti bexa ndee ndoꞌ gizhliyo, no msaꞌa ga bexa ndoꞌ naꞌ. Cha mluu naꞌ xteꞌe nak go ndoꞌ bexa. Leꞌa bexa ndee nakla be xmen ga, cha msaꞌa ga bexa ndoꞌ naꞌ. No nxobgek bexa ndoꞌ diꞌizh ten ga. ");
INSERT INTO zpt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nat uniꞌí bexa leꞌa itea be taꞌa ndák naꞌ leꞌa ta wa ta msaꞌaka go. ");
INSERT INTO zpt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Leꞌa be ta ndab ga ndoꞌ naꞌ wa leꞌa ta wa cha mbidiꞌizh naꞌ ndoꞌ bexa, cha mbingea ladna bexa‑yá. No nat uniꞌíka bexa leꞌa naꞌ watska go utoꞌo, no ndangea ladna bexa leꞌa go leꞌa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Leꞌa nat leꞌa naꞌ naꞌab gakno ga bexa ndee. Naꞌanpa naꞌab naꞌ gakno ga be men gizhliyo, leꞌa naꞌ ndi naꞌab gakno ga bexa msaꞌaka go ndoꞌ naꞌ, geal leꞌa bexa wa xmenka go. ");
INSERT INTO zpt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Leꞌa itea be xmen naꞌ, leꞌa bexa wa xmenka go. No liga leꞌa itea be xmen ga, leꞌa bexa wa xmenkaga naꞌ. Li nluu bexa xteꞌe siꞌil nak naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Leꞌa naꞌ yá naꞌantapa yoo ndoꞌ gizhliyo ndee. Leꞌa bexa ndee bi yookata ndoꞌ gizhliyo, ná leꞌa naꞌ ndee ndi ilen wats go. Xus naꞌ, leꞌa go dubkama nak Dios, nat leꞌa juers ten ga blaꞌach ga bexa na msaꞌa ga ndoꞌ naꞌ, ndontsa dubtsa gak bexa lak dubtsa nak unaꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Leꞌa zha na nkeseano naꞌ bexa ndoꞌ gizhliyo ndee, leꞌa naꞌ nlach bexa nsea juers ten leaꞌ go. Leꞌa itea bexa na msaꞌa ga ndoꞌ naꞌ mlach naꞌ. Ni dub bexa lá isabgix, ndi nabtsa Judas usabgix, ndontsa gak cumplir lak nkeaniꞌi diꞌizh ten ga. ");
INSERT INTO zpt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Parea nat leꞌa naꞌ nseal wats go. Ta ndee ndáp naꞌ nat bi nsoꞌ naꞌ ndoꞌ gizhliyo ndee, ndontsa iten ladna bexa ndee lak nten lad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Leꞌa naꞌ mbidiꞌizh be diꞌizh ten ga ndoꞌ bexa ndee, parea leꞌa be men gizhliyo nxeeno ladna bexa, geal leꞌa bexa ndee yá naꞌantapa bexa gizhliyo, lak leꞌa naꞌ naꞌanpa xa gizhliyo ndee. ");
INSERT INTO zpt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Leꞌa naꞌ naꞌanpa naꞌab koꞌo ga bexa ndee ndoꞌ gizhliyo, ndi naꞌab naꞌ ulaꞌach ga bexa ndoꞌ maxuꞌu. ");
INSERT INTO zpt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Leꞌa lak naꞌanpa ndun naꞌ lak ndun be men gizhliyo ndee, no liga leꞌa bexa ndee naꞌanpa ndun lak ndun bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Btsambiꞌi ga ladoꞌo bexa juers ten diꞌizh ten ga, leꞌa diꞌizh wa gealngeaka. ");
INSERT INTO zpt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Leꞌa lak mtuꞌub ga naꞌ ndoꞌ gizhliyo ndee, no liga ntuꞌub naꞌ bexa ndee ndoꞌ be men gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Leꞌa ke ten bexa ndee ndun naꞌ sbeꞌen ta nlad go, ndontsa no bexa gun sbeꞌen ta nladtsa go wa, ta na nchandoꞌ bexa gealngea wa. ");
INSERT INTO zpt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Leꞌa naꞌ naꞌanpa naꞌab gakno ga nabtsa bexa ndee, no naꞌab naꞌ gakno ga bexa tiꞌi gungea ladna naꞌ gor na goꞌón bexa ta gudiꞌizh bexa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gokno ga bexa wa ndontsa dubtsa gak iteanak bexa, lak dubtsa nak naꞌ nsea go Xus naꞌ. No dubtsa gak bexa nsea beuna, ndontsa gungea ladna be men gizhliyo leꞌa go leꞌaka mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Lak msaꞌa ga juers ndoꞌ naꞌ, no liga msa naꞌ juers ndoꞌ bexa, ndontsa dubtsa gak bexa, lak leꞌa go no naꞌ dubtsa nak. ");
INSERT INTO zpt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Leꞌa naꞌ nsea bexa ndee dubtsa nak, no go nsea naꞌ dubtsa nak, ndontsa itea beuna dubtsa gak. Ta weꞌe iniꞌí be men leꞌa go leꞌaka mtuꞌub naꞌ, no iniꞌí bexa leꞌa go nkweaꞌ ladna bexa ndee lak nkweaꞌ ladna go naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xus naꞌ, leꞌa naꞌ nlad leꞌa sa yoo naꞌ itea bexa na msaꞌa ga ndoꞌ naꞌ wa yoo wats naꞌ, ndontsa iniꞌí bexa juers msaꞌa go ndoꞌ naꞌ, geal leꞌa go nkweaꞌ ladna naꞌ gast zha biseata gakndeꞌe gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xus naꞌ xa ndon leꞌa wen, leꞌa be men gizhliyo naꞌanpa nchandoꞌ ga, parea leꞌa naꞌ nchandoꞌ ga no uniꞌíka bexa ndee leꞌa go leꞌa mtuꞌub naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Leꞌa naꞌ mluu ndoꞌ bexa ndee xteꞌe nak go, no uluuta naꞌ ta wa ndoꞌ bexa, ndontsa ikweaꞌ ladna bexa be ltsaꞌa bexa lak nkweaꞌ ladna go naꞌ, no dubtsa gak naꞌ nsea bexa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Leꞌa gor na li mtayadiꞌizhno Jesús Dios, cha utoꞌo xa nchaꞌano xa be xmen xa stub toꞌo yoꞌow nsaleaꞌ Cedrón, sa nde dub lenya. Cha uyote bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Leꞌa Judas xa na yun cuent Jesús no nchandoꞌ sa wa, geal leꞌa Jesús sianla biaj mbiꞌi be xmen na sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ngol gor leꞌa Judas nchaꞌanola pla be soldad no stapla bexa nlaꞌach niꞌi ten Dios, bexa na mtuꞌub be uleꞌay nibeꞌe nsea bexa fariseo. Leꞌa bexa wa noꞌo be xeꞌa aceit no xeꞌa ged no spad. ");
INSERT INTO zpt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ná leꞌa Jesús yá uniꞌíka xtaꞌan yasea xa, ta weꞌe utoꞌo xa ndab xa ndoꞌ bexa wa: —¿Ton nkwaꞌan bega? ");
INSERT INTO zpt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Leꞌa bexa wa cha ukaꞌab ndab: —Leꞌa besa nkwaꞌan Jesús xa gezh Nazaret. Leꞌa Jesús cha ndab: —Leꞌa ta wa naꞌ. Leꞌa Judas xa na nseayun cuent Jesús no nsoꞌ lat bexa wa. ");
INSERT INTO zpt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Leꞌa gor na li ndab Jesús: “Leꞌa ta wa naꞌ”, leꞌa bexa wa cha msatatsoꞌobe, cha ulayat bexa ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Leꞌa Jesús cha unabdiꞌizhgal ndab: —¿Ton nkwaꞌan bega? Leꞌa bexa cha ndabgal: —Nkwaꞌan besa Jesús xa Nazaret. ");
INSERT INTO zpt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Leꞌa Jesús cha ndab: —Leꞌa naꞌ ndápka leꞌa ta wa naꞌ. Leꞌa tal bega naꞌ ndee nkwaꞌan, blaꞌa bega yaꞌ bexa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Li ndab Jesús ndontsa itid‑a lak ndab leꞌaka Jesús ndoꞌ Xus xa, leꞌa bexa na msaꞌa Dios ndoꞌ Jesús, ni dub bexa lá isabgix. ");
INSERT INTO zpt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Weꞌe leꞌa Simón Pedr cha uloꞌo spad ten na, cha ulobtoꞌog xa nchaꞌ xa nsaleaꞌ Malco, ta lad gaꞌal. Leꞌa Malco wa dub xa ndun tiꞌin ndoꞌ uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Leꞌa Jesús cha ndab ndoꞌ Pedr: —Ulochaꞌaw spad ten lu. ¿Lá iniꞌí lu zha leꞌa naꞌ nsabndoꞌ itiꞌid be gealkweaꞌ ndab Xus naꞌ itiꞌid naꞌ wa? ");
INSERT INTO zpt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Weꞌe leꞌa be soldad no xa nibeꞌe ten bexa wa no bexa nlaꞌach niꞌi ten Dios cha usen bexa Jesús no mxi bexa yaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Cha mbiꞌi bexa Jesús ndon ned ndoꞌ xa nsaleaꞌ Anás, xuszhaꞌap Caifás, xa nak uleꞌay ndon leꞌa nsak tiemp weꞌe. ");
INSERT INTO zpt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Leꞌa Caifás wa xa na ndabka ndoꞌ bexa judio mas wen gat dubtsa men sakndoꞌ itea bexa. ");
INSERT INTO zpt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Leꞌa Simón Pedr cha usankea tsoꞌo Jesús. Leꞌa stub xmen Jesús nchaꞌano Pedr nchandoꞌ xa nak uleꞌay ndon leꞌa nsak, cha uyoꞌono xa Jesús tale ten niꞌi ten uleꞌay wa. ");
INSERT INTO zpt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Parea leꞌa Pedr myansoꞌ tsoꞌo juer toꞌo puert wa. Weꞌe leꞌa stub xmen Jesús xa na nchandoꞌ uleꞌay wa, cha utoꞌo mbidiꞌizhno xagots nlaꞌach toꞌo puert wa, ndontsa no Pedr uyote. ");
INSERT INTO zpt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Leꞌa xa nlaꞌach toꞌo puert wa cha ndab ndoꞌ Pedr: —¿Lid no ga dub xmen xabgiꞌi baꞌ zha? Leꞌa Pedr cha ndab: —Leꞌa naꞌ naꞌanpa no xa wa. ");
INSERT INTO zpt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Leꞌa zha wa kwal, ta weꞌe leꞌa bexa ndun tiꞌin ndoꞌ uleꞌay wa no bexa nlaꞌach niꞌi ten Dios mkwaꞌa giꞌ, cha ndeubizh bexa. Leꞌa lat bexa wa no Pedr nsoꞌubizh. ");
INSERT INTO zpt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Leꞌa Anás xa ngok uleꞌay ndon leꞌa nsak wa cha unabdiꞌizh ndoꞌ Jesús ná ton be xmen Jesús, no xtaꞌan mluu Jesús be men. ");
INSERT INTO zpt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa ta mluu naꞌ wa mbidiꞌizh naꞌ ndoꞌ gaꞌal be men len be niꞌi sa ndaꞌutsid bexa wa no tale ten niꞌi ten Dios, sa nzhealbe iteanak bexa judio. Naꞌanpa xgaꞌach nluu naꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ta weꞌe xtaꞌan nabdiꞌizh ga ndoꞌ naꞌ xtaꞌan mluu naꞌ? Ndi nsabndoꞌ inabdiꞌizh ga ndoꞌ bexa mbiꞌín ta mluu naꞌ wa ná xtaꞌan mbidiꞌizh naꞌ ndoꞌ bexa. Leꞌa bexa uniꞌíka‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Leꞌa gor na li ndab Jesús, leꞌa dub men nsoꞌ sa wa cha utichyaꞌa ndoꞌ Jesús, leꞌa xa dub xa nlaꞌach niꞌi ten Dios. Cha ndab xa ndoꞌ Jesús: —¡Naꞌanpa li nsabndoꞌ ikaꞌab lu ndoꞌ uleꞌay ndon leꞌa nsak baꞌ! ");
INSERT INTO zpt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Leꞌa Jesús cha ndab: —Tal leꞌa naꞌ ugap ndáp, gud ga ná xtaꞌan lid leꞌa ndáp naꞌ. Ná tal naꞌ leꞌakaga ndáp, ¿xtaꞌan ngi utichyaꞌa ga ndoꞌ naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Weꞌe litsa nchii Jesús leꞌa Anás mtuꞌub xa ndoꞌ Caifás, xa nak uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ndalen li nsoꞌubizhnota Pedr bexa wa, leꞌa dub xa cha unabdiꞌizh ndoꞌ Pedr ndab: —¿Lid no go xmen xabgiꞌi baꞌ zha? Leꞌa Pedr cha ndabgal: —Leꞌa naꞌ naꞌanpa xmen xa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Leꞌa sa wa no dub xa ndun tiꞌin ndoꞌ uleꞌay ndon leꞌa nsak wa nsoꞌ, dub ltsaꞌa xa na ulobtoꞌog Pedr nchaꞌ na wa. Cha ndab xa ndoꞌ Pedr: —¿Naꞌanpa go ta uní naꞌ lenya wa no xabgiꞌi baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Leꞌa Pedr cha ndabgal stub biaj: —Leꞌa naꞌ naꞌanpa leꞌa ta wa. Leꞌa gor wa leꞌa dub boy cha utezh. ");
INSERT INTO zpt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Leꞌa gor yá nsayatla xeꞌa, cha utoꞌono bexa Jesús ta lid Caifás, mbiꞌi bexa Jesús ta lid Pilat, sa nsaleaꞌ pretorio. Parea leꞌa bexa nibeꞌe ten bexa judio naꞌanpa yatebe len niꞌi wa, leꞌa tal leꞌa bexa yate sa wa leꞌa bexa gak bzhiꞌik ndoꞌ Dios, cha lá yoo gan gaw bexa ta ten ujest Pascua. ");
INSERT INTO zpt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ta weꞌe leꞌa Pilat ndi utoꞌo gast sa ndebe bexa, cha ndab xa ndoꞌ bexa wa: —¿Xtaꞌan nsake bega xa ndee zha? ");
INSERT INTO zpt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Leꞌa bexa wa cha ukaꞌab ndab: —¡Tal leꞌa xa baꞌ naꞌanpa xa ugap, leꞌa besa naꞌanpa yun cuent xa ndoꞌ ga! ");
INSERT INTO zpt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Weꞌe leꞌa Pilat cha ndab: —Biꞌi bega xa. Cha binno bega xa lak nibeꞌe ley ten bega. Leꞌa bexa wa cha ndabbe ndoꞌ Pilat: —Leꞌa bega xa Roma naꞌanpa ulaꞌa gut besa dub men. ");
INSERT INTO zpt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Li ngok cumplir ta mbidiꞌizh Jesús xteꞌe gat Jesús ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Weꞌe leꞌa Pilat cha myoꞌogal len lid na, cha utezh xa Jesús, cha ndab xa: —¿Lu nak xa nibeꞌe ten bexa judio zha? ");
INSERT INTO zpt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Leꞌa Jesús cha ukaꞌab ndab: —¿Gotsa mbinbeꞌe ta wa zha? ¿Nati stub men mbidiꞌizh‑a ndoꞌ ga? ");
INSERT INTO zpt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Leꞌa Pilat cha ndab: —Leꞌa naꞌ ndee naꞌanpa xa judio. Leꞌa be ltsaꞌa lu xa judio no be uleꞌay nibeꞌe wa myun cuent lu ndoꞌ naꞌ. ¿Xtaꞌan mbin lu zha? ");
INSERT INTO zpt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa naꞌ naꞌanpa nibeꞌe lak nibeꞌe bexa ndoꞌ gizhliyo ndee. Leꞌa tal naꞌ li nibeꞌe, leꞌa be xmen naꞌ leꞌa kuyobe ndontsa naꞌanpa yak cuent naꞌ ndoꞌ yaꞌa bexa judio. Parea leꞌa naꞌ naꞌanpa li nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Leꞌa Pilat cha ndab: —¿Nat zha xa nibeꞌeka lu? Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa go ndab leꞌa naꞌ nak xa nibeꞌe wa. Leꞌa naꞌ ngol, no ndal naꞌ ndoꞌ gizhliyo ndee ndontsa gudiꞌizh naꞌ gealngea ndoꞌ be men. Leꞌa tal ton nkwaꞌan gealngea, leꞌa xa wa isakyoꞌón ta ndáp naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Leꞌa Pilat cha ndab: —¿Xtaꞌan gealngea wa zha? Tsoꞌo na li ndab Pilat, cha utoꞌogal xa sa ndebe be men wa, cha ndab xa: —Leꞌa naꞌ lá ngaizheal ni dub ke ten xa ndee. ");
INSERT INTO zpt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Leꞌa lak nak costumbr ten bega itea liꞌin zha ndal ujest Pascua leꞌa naꞌ ngo dub men litgiꞌib dub xa inab bega. ¿Nat nlad bega ula naꞌ xa nak xa nibeꞌe ten bega xa judio zha? ");
INSERT INTO zpt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Weꞌe leꞌa iteagal bexa ugeꞌ ndab: —¡Naꞌanpa ulaꞌa ga xa baꞌ! ¡Bgoꞌo ga ndi Barrabás! Leꞌa Barrabás wa dub waꞌan. ");
INSERT INTO zpt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Weꞌe leꞌa Pilat cha unibeꞌe goꞌo be soldad Jesús len niꞌi wa, cha kin bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","No mbindeꞌe be soldad dub ta rued xos yagich usob gek Jesús cuent coron. No mgak bexa Jesús dub lad koꞌol, ta konch ugats. ");
INSERT INTO zpt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Cha usalad mbinno be soldad Jesús, ugeꞌ ndab bexa: —¡Siꞌil nak xa nibeꞌe ten bexa judio! No utichyaꞌa bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Weꞌe leꞌa Pilat cha utoꞌogal stub biaj, cha ndab xa ndoꞌ be men wa: —Bwiꞌi bega, leꞌa naꞌ ko xa sa ndee, ndontsa yakbeꞌena bega leꞌa naꞌ ni dub ke ten xa lá ngaizheal. ");
INSERT INTO zpt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Leꞌa Jesús cha utoꞌo, nsob coron yagich wa gek xa, no lad konch ugats wa nak xa. Leꞌa Pilat cha ndab ndoꞌ be men: —Nat bwiꞌi bega xa. ");
INSERT INTO zpt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Leꞌa gor na uniꞌí be uleꞌay nibeꞌe no bexa nlaꞌach niꞌi ten Dios wa Jesús, cha ugeꞌ ndab bexa: —¡Ikea xa ndoꞌ cruz! ¡Ikea xa ndoꞌ cruz! Leꞌa Pilat cha ndab: —Biꞌi bega xa, cha bkeꞌa bega xa ndoꞌ cruz, leꞌa naꞌ ni dub ke ten xa lá ngaizheal. ");
INSERT INTO zpt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Leꞌa bexa wa cha ndabbe: —Leꞌa ley ten besa ndab nsabndoꞌ gatka xa, leꞌa xa nkwiꞌin ndab xa leꞌa xa nak Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Leꞌa gor na mbiꞌín Pilat ta wa, leꞌa Pilat mas mzheb. ");
INSERT INTO zpt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Cha myoꞌogal xa len lid xa, ndab xa ndoꞌ Jesús: —¿Pa utoꞌo lu zha? Parea leꞌa Jesús naꞌanpa ikaꞌab. ");
INSERT INTO zpt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Leꞌa Pilat cha ndab: —¿Naꞌanpa ikaꞌab lu ndoꞌ naꞌ ndee zha? ¿Lá iniꞌí lu zha leꞌa naꞌ sak inibeꞌe ikea lu ndoꞌ cruz, no sak ndi ula naꞌ lu? ");
INSERT INTO zpt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa tal Dios lá usaꞌa diꞌizh li gun ga, leꞌa go naꞌan xtaꞌan gun gan gunno naꞌ. Ta weꞌe leꞌa xa na myun cuent naꞌ ndoꞌ ga mas uzheꞌeb ndap ke ndoꞌ lak ndap go. ");
INSERT INTO zpt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Leꞌa gor weꞌe leꞌa Pilat nlad ulaꞌa Jesús, parea leꞌa bexa judio ugeꞌ ndab ndoꞌ Pilat: —Leꞌa tal go ulaꞌa xa baꞌ, leꞌa go naꞌanpa nak amig ten César xa nibeꞌe. Leꞌa tal ton gab leꞌa nak xa nibeꞌe, leꞌa xa wa xela níꞌi ndoꞌ César. ");
INSERT INTO zpt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Weꞌe leꞌa gor na mbiꞌín Pilat ta wa, cha mbiꞌi xa Jesús sa nsaleaꞌ Tale Geꞌ. Leꞌa sa wa nsaleaꞌ Gabata diꞌizh hebreo. Cha usob Pilat sa nibeꞌe xa sa wa, gab xa ná xteꞌe gunno xa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Leꞌa ta wa gawizh dub wizh lak geꞌatsa gal ujest Pascua. Cha ndab Pilat ndoꞌ be men kwaꞌad wa: —¡Bwiꞌi bega leꞌa xa ndee xa nibeꞌe ten bega! ");
INSERT INTO zpt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ná leꞌa bexa wa ugeꞌ ndabbe: —¡Gat xa! ¡Gat xa! ¡Ikea xa ndoꞌ cruz! Leꞌa Pilat cha ndab: —¿Ukeꞌa naꞌ xa nibeꞌe ten bega ndoꞌ cruz zha? Leꞌa be uleꞌay nibeꞌe cha ndabbe: —¡Nab César nak xa nibeꞌe ten besa! ");
INSERT INTO zpt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Weꞌe leꞌa Pilat cha ndab ikea Jesús ndoꞌ cruz lak nlad bexa. Cha usen be soldad Jesús, cha mbiꞌi bexa xa. ");
INSERT INTO zpt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Leꞌa Jesús cha nchaꞌano cruz ten na gast sa nsaleaꞌ Gólgota. Leꞌa ta wa dub diꞌizh hebreo gab‑a tit gek men. ");
INSERT INTO zpt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Cha mkeꞌa bexa Jesús ndoꞌ cruz. No stop men mkeꞌa bexa ndoꞌ cruz dub lad gaꞌga wats Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","No mkeꞌa Pilat dub letr ta ikea gek cruz ten Jesús. Leꞌa ta wa ndab: “JESÚS XA NAZARET, XA NIBEꞌE TEN BEXA JUDIO.” ");
INSERT INTO zpt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Leꞌa ta wa nkeaniꞌi diꞌizh hebreo no diꞌizh griego no diꞌizh latín. Kwaꞌad bexa judio uniꞌí xteꞌe ndab letr wa, geal leꞌa sa nkea Jesús ndoꞌ cruz wa gax nde Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ná leꞌa be uleꞌay nibeꞌe ten bexa judio ngwaꞌyab ndoꞌ Pilat: —Lá nsabndoꞌ gab ta wa “Xa nibeꞌe ten bexa judio.” Ndi nsabndoꞌ gab‑a “Xa na ndab leꞌa nak xa nibeꞌe ten bexa judio.” ");
INSERT INTO zpt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ná leꞌa Pilat cha ukaꞌab ndab: —Lak nkea‑yá, litsa yaꞌan‑a. ");
INSERT INTO zpt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Leꞌa tsoꞌo na mkeꞌa dap be soldad Jesús ndoꞌ cruz, cha ukaꞌa kadga dub bexa wa dub xab Jesús. Cha usen bexa lad koꞌol ndak Jesús, leꞌa ná wa naꞌanpa ngeꞌal. ");
INSERT INTO zpt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Cha ndab bexa ndoꞌ be ltsaꞌa xa: —Naꞌanpa itsaw beuna ta ndee, ndi koꞌo beuna dub suert ndontsa iniꞌí beuna ná ton ikaꞌa‑yá. Li ngok‑a lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: Mtseꞌa bexa be xab naꞌ, no uloꞌo bexa suert ná ton ikaꞌa‑yá. ");
INSERT INTO zpt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Leꞌa wats cruz ten Jesús wa nsoꞌ xnaꞌa Jesús no beal xa, no Marí xagots ten Cleofas, no Marí xa gezh Magdala. ");
INSERT INTO zpt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Leꞌa gor na uniꞌí Jesús xnaꞌa na junt nsoꞌ wats dub xmen Jesús, xa na leꞌa Jesús uzheꞌeb nkweaꞌ ladna, cha ndab Jesús ndoꞌ xnaꞌa na: —Naa, leꞌa xa baꞌ ulaꞌach ga cuent dub xin ga nat. ");
INSERT INTO zpt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cha no ndab Jesús ndoꞌ xmen xa wa: —Nat ulaꞌach lu xa baꞌ cuent xnaꞌa lu. Leꞌa idub ndoꞌ wa leꞌa xmen Jesús wa cha mlaꞌach xnaꞌa Jesús ta lidka na. ");
INSERT INTO zpt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngol tsoꞌo wa leꞌa Jesús uniꞌíka leꞌa xa mbinla itea be ta nlad Dios gun xa. Cha ndab xa: —Leꞌa naꞌ ndak ladna. Leꞌa xa li ndab ndontsa gak‑a lak nkeaniꞌi diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Leꞌa sa wa nsoꞌ dub vas ncho vin ulaꞌ len‑a. Cha mgazh bexa dub bleꞌa lad xiꞌil len‑a. Cha msob xa ta wa gek dub xos ya hisopo, cha uxits bexa ta wa toꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Leꞌa gor na ngu Jesús ta wa, cha ndab xa: —Nat leꞌa itea be tiꞌin ndal naꞌ ngokla cumplir. Cha ubixkea gen xa, cha myun xa cuent gealnaban ten xa ndoꞌ Dios, cha ngut xa. ");
INSERT INTO zpt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Leꞌa ta wa wizh lak geꞌatsa gal ujest Pascua, ta weꞌe leꞌa bexa judio lá nlad litsa nkea be men wa ndoꞌ be cruz gal wizh uneꞌe bexa wa, leꞌa wizh wa uzhebpa dub wizh nsak. Ta weꞌe unab bexa ndoꞌ Pilat inibeꞌe Pilat kiꞌich be soldad xoꞌo bexa li nkea ndoꞌ cruz, ndontsa mas uxax gat bexa, cha igeꞌe bexa ndoꞌ cruz wizh wa. ");
INSERT INTO zpt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Leꞌa be soldad wa cha ulenbe, cha utiꞌich bexa xoꞌo dub xa wa. Cha liga mbinno bexa stubga xa nkea ndoꞌ cruz wa. ");
INSERT INTO zpt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ná leꞌa gor ngol bexa sa nkea Jesús, leꞌa bexa mnaꞌla leꞌa Jesús ngutla. Cha naꞌanpa igiꞌich bexa xoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Parea leꞌa dub soldad wa cha utib dub lanza wats len Jesús. Zha leꞌa sa wa ulen ten no nits. ");
INSERT INTO zpt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Leꞌa naꞌ ndee uní ta wa no sbeꞌen gealngea ndadiꞌizh naꞌ. Ta weꞌe nkeꞌa naꞌ‑yá, ndontsa no bega gungea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Leꞌa be ta wa li uyoꞌo lak nkeaniꞌi diꞌizh ten Dios, ndab‑a: “Ni dub tit las xa lá ngach.” ");
INSERT INTO zpt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","No lak nkeaniꞌiga diꞌizh ten Dios: “Leꞌa be men iwiꞌi ndoꞌ xa na utib bexa lanza las na wa.” ");
INSERT INTO zpt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Uyoꞌo dub xabgiꞌi nsaleaꞌ Kosé xa gezh Arimatea, dub xa xgaꞌachtsa ndangea ladna Jesús, geal leꞌa xa nzheb ndoꞌ bexa nibeꞌe ten bexa judio. Leꞌa tsoꞌo na ngut Jesús leꞌa Kosé wa ngwaꞌinab Jesús xa ngut wa ndoꞌ Pilat. Leꞌa Pilat cha ndab goꞌo Kosé Jesús, cha ngwaꞌ Kosé cha mbiꞌi xa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","No Nicodemo xa ngwaꞌinaꞌ Jesús dub gor teꞌal noꞌo xa pa dub galntiꞌi kil ta uxeꞌe, noch‑a mirra nsea áloe. ");
INSERT INTO zpt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Cha uxeꞌe bexa Jesús ndoꞌ cruz, cha mtixko bexa xa wa be lad lino no be ta uxeꞌe wa, lak nkaꞌach bexa judio be ltsaꞌa na. ");
INSERT INTO zpt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Leꞌa sa li ukea Jesús ndoꞌ cruz wa nde gax dub lenya, sa nde dub baꞌa cuent geꞌloꞌo. Leꞌa ta wa dub sa ni dub men gol gaꞌach. ");
INSERT INTO zpt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Leꞌa gor wa yamer gal wizh ten ujest Pascua ten bexa judio, ta weꞌe baꞌa weꞌetsa mkaꞌach bexa Jesús, leꞌa ta wa gax nsob sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Leꞌa ngol wizh ned ten sman, uzhebpa tempran ndon bi ukaw naꞌ, leꞌa Marí xa Magdala nchaꞌa sa nsob baꞌa mgaꞌach Jesús. Leꞌa gor ulayaꞌ xa uniꞌíla xa leꞌa geꞌ nsoꞌntsaw toꞌo baꞌa wa myoꞌobla. ");
INSERT INTO zpt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Weꞌe cha utoꞌo xa karrel, ngwaꞌyab xa‑yá ndoꞌ Simón Pedr no ndoꞌ stub xmen Jesús, xa na leꞌa Jesús uzheꞌeb nkweaꞌ ladna. Ndab Marí ndoꞌ bexa wa: —Leꞌa men mbiwaꞌan Jesús len baꞌa wa. Leꞌa besa lá iniꞌí pa ngwaꞌulaꞌa bexa xa. ");
INSERT INTO zpt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Leꞌa Pedr no stub xmen Jesús wa cha utoꞌo nchaꞌbe sa nsob baꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Leꞌa bexa wa karrel nchaꞌbe, parea leꞌa stub xa wa mas karrel nchaꞌa ndoꞌ Pedr, cha ned xa ulayaꞌ toꞌo baꞌa. ");
INSERT INTO zpt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cha mwiꞌiko xa len baꞌa, uniꞌí xa be lad lino myuꞌudyoꞌo Jesús, parea lá yoꞌo xa len wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Weꞌe cha ulen Simón Pedr, cha uyoꞌo xa len baꞌa wa, cha uniꞌí xa be lad wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","No uniꞌí xa leꞌa lad ubixyoꞌo gek Jesús myuꞌudla, naꞌanpa junt nde‑yá no be lad ubixyoꞌo idub Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Weꞌe leꞌa stub xmen Jesús, xa na li ned ulayaꞌ wa, cha no uyoꞌo. Uniꞌí xa be taꞌa wa, cha mbingea ladna xa leꞌa Jesús mbanka. ");
INSERT INTO zpt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Leꞌa gor weꞌe leꞌa bexa bi lá nyakbeꞌena lak nkeaniꞌi diꞌizh ten Dios, leꞌa Cristo nsabndoꞌka iban ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Leꞌa itop bexa wa cha nseaꞌbe ta niꞌi ndencho bexa. ");
INSERT INTO zpt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Leꞌa Marí xa Magdala cha myansoꞌ wats baꞌa wa ndoꞌon xa, cha mwiꞌiko xa len baꞌa wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Cha uniꞌí xa top angel ten Dios nak be lad nagud. Dub xa nsob sa ngot gek Jesús, leꞌa stub xa nsob sa ute yaꞌaxoꞌo Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Leꞌa be angel wa cha unabdiꞌizh ndoꞌ Marí ndab bexa: —Xagots, ¿xtaꞌan ndoꞌon lu zha? Leꞌa Marí cha ndab: —Leꞌa be men mbiwaꞌan Señor Jesús. Leꞌa naꞌ lá iní pa ngwaꞌulaꞌa bexa xa. ");
INSERT INTO zpt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tsoꞌo na li ndab Marí, cha mgeaksoꞌ xa mwiꞌi xa stub lad. Cha uniꞌí xa Jesús nsoꞌ sa wa, ná leꞌa xa lá igondoꞌ ti leꞌa Jesús ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Leꞌa Jesús cha ndab: —Xagots, ¿xtaꞌan ndoꞌon lu zha? ¿Ton nkwaꞌan lu zha? Leꞌa Marí mbinbeꞌe leꞌa ta wa xa nlaꞌach lenya wa, cha ndab Marí: —Señor, tal ga leꞌa mbiꞌi xa, gud go ná pa ngwaꞌulaꞌa ga xa, ndontsa gayoo naꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Leꞌa Jesús cha ndab: —¡Marí! Leꞌa xa cha mgeaksoꞌ mwiꞌi ndoꞌ Jesús, cha ndab xa: —¡Raboni! —leꞌa ta wa dub diꞌizh hebreo gab‑a Mech. ");
INSERT INTO zpt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Leꞌa Jesús cha ndab: —Lá ugal lu naꞌ, leꞌa naꞌ biseata ikea wats Xus naꞌ. Ndi byaꞌyab ndoꞌ be xmen naꞌ leꞌa naꞌ yaa wats Xus naꞌ xa nak Dios ten naꞌ. Leꞌa ta wa leꞌakaga Xus bega no Dios ten bega. ");
INSERT INTO zpt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Leꞌa Marí cha nseaꞌyab ndoꞌ be xmen Jesús leꞌa xa uniꞌí Jesús, no mbidiꞌizh xa ta ndab Jesús ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Leꞌa ngol gor na ulaꞌ teꞌal bi leꞌa wizh ned ten sman wa, leꞌa be xmen Jesús mzhealbe len dub niꞌi. Leꞌa toꞌo niꞌi wa nsoꞌnyaw, geal leꞌa bexa nzheb ndoꞌ bexa judio nibeꞌe. Weꞌe leꞌa Jesús cha mlundoꞌ nsoꞌ tlaw bexa, cha ndab xa: —¡Dios gun wen yoo ladna bega! ");
INSERT INTO zpt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tsoꞌo na li ndab Jesús, cha mluu xa be yaꞌa xa no wats len xa. Cha uzhebpa mten ladna bexa gor uniꞌí bexa leꞌa ta wa Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Leꞌa Jesús cha ndabgal: —Dios gun wen yoo ladna bega. Leꞌa lak mtuꞌub Xus naꞌ naꞌ, no liga utuꞌub naꞌ bega gun bega tiꞌin ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cha mlabi xa sa nde bexa, cha ndab xa: —Ulaꞌa bega yoo Espíritu ten Dios len ladoꞌo bega. ");
INSERT INTO zpt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tal leꞌa bega gungeꞌ ladna ke ten dub men, leꞌa Dios noga sungeꞌ ladna ta wa. No liga tal leꞌa bega lá gungeꞌ ladna ke ten dub men, leꞌa Dios noga naꞌanpa gungeꞌ ladna ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Leꞌa Tomás xa no nsaleaꞌ Dídimo nak dub tibtop xmen Jesús, parea leꞌa xa naꞌanpa no nsoꞌno bexa wa gor na mlundoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Leꞌa gor na ulen Tomás leꞌa be xmen Jesús cha ndab ndoꞌ Tomás: —Leꞌa besa uniꞌí Jesús. Leꞌa Tomás cha ndab: —Gast ned iní naꞌ be sa ngwaꞌas clav yaꞌa xa no ukikoꞌo naꞌ ngutsyaꞌa naꞌ sa wa, no ukikoꞌo naꞌ yaꞌa naꞌ wats len xa, lá ndangea lad naꞌ leꞌa xa mban. ");
INSERT INTO zpt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ngol sxoꞌon wizh leꞌa bexa ndebegal len niꞌi wa no Tomás. Leꞌa toꞌo niꞌi wa nsoꞌnyaw, parea leꞌa Jesús cha uyatsoꞌ tlaw bexa, cha ndab xa: —Dios gun wen yoo ladna bega. ");
INSERT INTO zpt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Cha ndab Jesús ndoꞌ Tomás: —Bwiꞌi ndoꞌ yaꞌa naꞌ, no ulo ngutsyaꞌa lu sa ndee. No ulo yaꞌa la wats len naꞌ ndee. Yá naꞌantapa gunbeꞌe lu leꞌa naꞌ ngut, ndi bingea ladna leꞌa naꞌ mbangal. ");
INSERT INTO zpt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Weꞌe leꞌa Tomás cha ukaꞌab ndab: —¡Go nak xa nibeꞌe naꞌ, no Dios ten naꞌ! ");
INSERT INTO zpt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Cha ndab Jesús: —Tomás, geal uniꞌí lu naꞌ, ta weꞌe mbingea ladna lu leꞌa naꞌ mbankagal. Uzhebpa wen yoo ladna bexa gungea ladna naꞌ, maska lá iniꞌí bexa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","No sianta be uyon mbin Jesús ndoꞌ gaꞌal be xmen xa, ta na naꞌanpa ikea ndoꞌ libr ndee. ");
INSERT INTO zpt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Parea leꞌa be taꞌa nkea sa ndee, nkea‑yá ndontsa gungea ladna bega leꞌa Jesús leꞌa nak Cristo, Xin Dios. Tal leꞌa bega li gungea ladna ta wa, leꞌa bega gap gealnaban ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngol tsoꞌo wa leꞌa Jesús mlundoꞌgal ndoꞌ be xmen na toꞌo lagun Tiberias. Leꞌa xa lndeꞌe mlundoꞌ: ");
INSERT INTO zpt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Leꞌa dub wizh leꞌa pla be xmen Jesús junt ndebe. Leꞌa ta wa Simón Pedr, no Tomás xa nsaleaꞌ Dídimo, no Natanael xa gezh Caná ten Galilea, no itop be xin Zebedeo, nsea stop be xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Leꞌa Simón Pedr cha ndab ndoꞌ bexa wa: —Leꞌa naꞌ ndasen mbeal. Leꞌa bexa cha ndab: —Leꞌa besa no isea. Cha nchaꞌbe bexa, cha ukea bexa ndoꞌ dub barco. Parea leꞌa idub teꞌal wa ni dub mbeal lá isen bexa. ");
INSERT INTO zpt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Leꞌa ngol gor na yá nsayat xeꞌa, leꞌa be xmen Jesús wa uniꞌí Jesús nsoꞌ toꞌo nits wa, parea leꞌa bexa lá iniꞌí ti leꞌa Jesús ta wa. ");
INSERT INTO zpt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Leꞌa Jesús cha ndab ndoꞌ bexa: —Bego usa byux, ¿lid usen bega mbeal zha? Leꞌa bexa cha ukaꞌab ndab: —Leꞌa besa ni dub mbeal lá isen. ");
INSERT INTO zpt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Cha ndab Jesús: —Btsaꞌab bega red baꞌ wats lad gaꞌal barco baꞌ, cha isen bega mbeal. Weꞌe leꞌa bexa cha li mbin, cha uzheꞌeb sian mbeal usen red wa, gast lá uxik bexa koꞌo bexa red len nits wa. ");
INSERT INTO zpt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Leꞌa dub xmen Jesús, xa na leꞌa Jesús uzheꞌeb nkweaꞌ ladna, cha ndab ndoꞌ Pedr: —¡Leꞌa ta baꞌ Jesús! Leꞌa gor na mbiꞌín Simón Pedr leꞌa ta wa Jesús, cha ngok xa xab xa, ta nbix xa, ta na ulate xa gor usen xa mbeal. Cha nchaꞌa xa len nits, nchaꞌa xa sa nsoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Leꞌa stapla be xmen Jesús wa cha myoꞌo barco wa toꞌo nits. Litsa ngobxazh bexa red na lita sian mbeal ncho len na wa. Leꞌa ta wa pa dub gayoꞌotsa metr sit ndoꞌ nits wa. ");
INSERT INTO zpt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Leꞌa gor na yá ulaꞌ bexa ndoꞌ barco toꞌo nits wa, leꞌa bexa uniꞌí leꞌa dub mbeal nchoꞌob ndoꞌ bkuꞌu, no dub pan nchoꞌob sa wa. ");
INSERT INTO zpt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Leꞌa Jesús cha ndab ndoꞌ bexa: —Utseano bega stapla be mbeal usen bega baꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Leꞌa Simón Pedr cha ukea ndoꞌ barco, cha udobxazh xa red gast ndoꞌ yo bid. Leꞌa len red wa ncho dub gayoꞌo itol ncho chon mbeal, bema ubiꞌi, parea ni lá isaw‑a mas lita sian mbeal ncho len‑a. ");
INSERT INTO zpt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Leꞌa Jesús cha ndab: —Utseadaw bega. Leꞌa ni dub bexa lá inabdiꞌizh ndoꞌ xa ná ton xa, leꞌa bexa uniꞌí leꞌa‑yá Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Weꞌe leꞌa Jesús cha usen pan wa, cha mtseꞌa xa‑yá ndoꞌ bexa. No liga mtseꞌa xa mbeal wa. ");
INSERT INTO zpt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Leꞌa ta ndee biaj yon mlundoꞌ Jesús ndoꞌ be xmen na, tsoꞌo na li mban xa ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Leꞌa gor na mtayaw bexa, leꞌa Jesús cha unabdiꞌizh ndoꞌ Simón Pedr, ndab xa: —Simón xin Jonás, ¿ndankea lu naꞌ mas ndoꞌ lak ndankea bexa ndee naꞌ zha? Leꞌa Pedr cha ukaꞌab ndab: —Señor, go uniꞌíka leꞌa naꞌ ndankeaka go. Leꞌa Jesús cha ndab: —Blaꞌach be borreg ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Cha ndabgal Jesús biaj itop: —Simón xin Jonás, ¿ndankeaka lu naꞌ zha? Leꞌa Pedr cha ndabgal: —Señor, go uniꞌíka leꞌa naꞌ ndankeaka go. Cha ndab Jesús: —Blaꞌach be borreg ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Cha ndabgal Jesús biaj yon: —Simón xin Jonás, ¿ndankeaka lu naꞌ zha? Leꞌa Pedr cha uban myoꞌo ladna geal biaj yon li unabdiꞌizh Jesús naga ndankeaka Pedr Jesús. Cha ndab Pedr: —Señor, leꞌa go uniꞌí itea taꞌa. Uniꞌíka go leꞌa naꞌ ndankeaka go. Cha ndab Jesús: —Blaꞌach be borreg ten naꞌ zhaga. ");
INSERT INTO zpt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Leꞌa naꞌ gáp leꞌa zha ben lu, leꞌa lu ndak xab na no nchaꞌa lu tal pa nlad lu. Parea leꞌa zha gak gox lu, leꞌa lu ndi utiꞌil be yaꞌa lu no xaꞌaga men ugak xab la. Cha goꞌo xa lu sa na lá nlad lu yaꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Leꞌa ta li ndab Jesús wa gab ná xteꞌe mod na gat Pedr, ta uluu xteꞌe juert nak Dios. Cha ndab Jesús ndoꞌ Pedr: —Usankea tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Leꞌa Pedr cha mgeaksoꞌ mwiꞌi, leꞌa stub xmen Jesús nchankea tsoꞌo Pedr no tsoꞌo Jesús. Leꞌa ta wa xa na leꞌa Jesús uzheꞌeb nkweaꞌ ladna, xa na li nsob wats Jesús zha na lult udaw xcheꞌe bexa, gor unabdiꞌizh xa ndoꞌ Jesús ná ton yun cuent Jesús. ");
INSERT INTO zpt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Leꞌa gor uniꞌí Pedr xa wa, cha unabdiꞌizh Pedr ndoꞌ Jesús, ndab xa: —Señor, ¿leꞌa xa baꞌ zha xtaꞌan itid? ");
INSERT INTO zpt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Leꞌa Jesús cha ndab: —Tal leꞌa naꞌ nlad leꞌa xa baꞌ lbaꞌatsa nban gast zha ilengal naꞌ, naꞌanpa yuꞌ ladna lu ta wa. Lu usankeatsa tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Leꞌa ta na li ndab Jesús, leꞌa ta wa mgen lat be xmen Jesús leꞌa xmen Jesús wa lá gat. Parea leꞌa Jesús naꞌanpa ngab leꞌa xa wa lá gat. Leꞌa Jesús ndi ndab: “Tal leꞌa naꞌ nlad leꞌa xa baꞌ lbaꞌatsa nban gast zha ilengal naꞌ, naꞌanpa yuꞌ ladna lu ta wa.” ");
INSERT INTO zpt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Leꞌa xmen Jesús wa xa ndadiꞌizh be ta ndee ndoꞌ be men, no mkeꞌa xa‑yá ndoꞌ git. Leꞌa besa uniꞌíka leꞌa ta ndadiꞌizh xa ta ugeaka. ");
INSERT INTO zpt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","No uzhebpa sianta be taꞌa mbin Jesús. Leꞌa naꞌ nsak tal leꞌa be men ukeꞌa itea be ta wa, leꞌa idub ndoꞌ gizhliyo lá ugal yoo be libr wa.");
INSERT INTO zpt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Leꞌa go Teófilo, leꞌa git ned mkeꞌa naꞌ ndoꞌ go wa, mkeꞌa naꞌ cuent ten itea be ta mbin Jesús no be ta mluu xa, ");
INSERT INTO zpt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","gast wizh mkea xa gibeꞌa. Leꞌa wizh wa mbidiꞌizh xa ndoꞌ bexa na mti xa, ndab xa xteꞌe nsabndoꞌ gun bexa, lak msaꞌa Espíritu ten Dios gab xa‑yá ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tsoꞌo na ngut Jesús, dub top gaꞌal wizh mlundoꞌ xa ndoꞌ bexa wa sian biaj, ndontsa uniꞌíka bexa leꞌa xa mbanka ndoꞌ gealgut. No mbidiꞌizh xa ndoꞌ bexa wa ná xteꞌe nibeꞌe Dios be men. ");
INSERT INTO zpt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Leꞌa dub wizh wa gor na nsoꞌno xa bexa wa, ndab xa ndoꞌ bexa: —Lá ikaꞌan bega gezh Jerusalén ndee. Ndi kweas bega gast usaꞌa Tad Dios ta ndab xa usaꞌa xa, lakka mbidiꞌizh naꞌ gun xa. ");
INSERT INTO zpt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Leꞌa Juan ulaleaꞌ be men no nits, parea yamer gal dub wizh leꞌa bega italeaꞌ nsea Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Weꞌe leꞌa bexa nde wats Jesús cha unabdiꞌizh, ndab bexa: —Señor, ¿nat zha gun ga gan leꞌa beuna xa Israel inibeꞌegal nacion ten beuna ndee? ");
INSERT INTO zpt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Leꞌa Jesús cha ukaꞌab ndab: —Leꞌa bego lá nsabndoꞌ iniꞌí pol yoo ta wa ni xá wizh na‑yá, ta na gun Dios zha nlad xa. ");
INSERT INTO zpt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ná leꞌa Dios usaꞌa Espíritu ten na ndoꞌ bega, cha gap bega juers gudiꞌizh bega ndoꞌ be men itea be ta mbin naꞌ. Li gudiꞌizh bega ndoꞌ be men Jerusalén ndee no idub Judea ndee no Samaria no gast idub ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tsoꞌo na li ndab Jesús ta wa, cha mkea xa gibeꞌa, myoꞌo xa lat xkaw ndalen ndewiꞌi bexa wa. Cha lá iniꞌíta bexa xa. ");
INSERT INTO zpt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Leꞌa gor na bi li ndewiꞌi bexa gibeꞌa sa nseaꞌ Jesús wa, weꞌe leꞌa top xabgiꞌi nak lad nagud cha mlundoꞌ sa wa, ");
INSERT INTO zpt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ndab bexa: —Bego xa Galilea, ¿xtaꞌan lbaꞌata ndewiꞌi bego gibeꞌa baꞌ zha? Leꞌa Jesús xa mtoꞌo lat bego nseaꞌ gibeꞌa baꞌ wa, leꞌa xa baꞌ leꞌaka ilen stub biaj lakka uniꞌí bega nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Weꞌe leꞌa bexa cha mkaꞌan Bet Olivo wa, cha myach bexa Jerusalén. Leꞌa bet wa nde pa dub kilómetro gax wats Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Gor ulayaꞌ bexa Jerusalén, cha ukea bexa cuart nde gaꞌap gek niꞌi sa ndencho bexa. Leꞌa ta wa Pedr no Jacob no Juan no Ndres no Julip no Tomás no Bartol no Mateo no Jacob xin Alfeo no Simón xa partid Zelote no Judas wit Jacob. ");
INSERT INTO zpt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Leꞌa bexa wa nsea pla be xagots nsea Marí xnaꞌa Jesús nsea be wit Jesús, sian biaj nzhealbe bexa ndadiꞌizhno bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Leꞌa dub wizh leꞌa dub gayoꞌo ncho gaꞌal bexa ndangea ladna Jesús wa nzhealbe. Weꞌe leꞌa Pedr cha ngwasoꞌ lat bexa, cha ndab xa: ");
INSERT INTO zpt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Bego nak beuna xmen Jesús, juerska ngok cumplir ta ndab diꞌizh ten Dios, ta uníꞌi David sakndoꞌ Espíritu ten Dios cuent ten Judas, xa usaned ndoꞌ be men usen Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Leꞌa Judas wa no uyoꞌo cuent be ltsaꞌa besa no mbin xa ltsaꞌa tiꞌin ndun besa. ");
INSERT INTO zpt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Leꞌa med na ukaꞌa Judas myun xa cuent Jesús wa usiꞌi bexa dub bleꞌa yo. Leꞌa sa wa cha msobgek Judas gast ngoch len xa. ");
INSERT INTO zpt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Leꞌa be men ncho Jerusalén, gor na mbiꞌín bexa ta wa, cha msaleaꞌ bexa yo wa Acéldama diꞌizh ten bexa, dub diꞌizh gab Yo Ten.) ");
INSERT INTO zpt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Cha no ndab Pedr: —Leꞌa libr ten Salmos nkeaniꞌi ndab‑a: Yaꞌan nab lid xa, yá naꞌanta ton yoo len‑a. No ndab‑a: Stub xa gun tiꞌin ndun xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nat leꞌa beuna nsabndoꞌ uti dub xabgiꞌi lat bexa na ukeseano besa idub ukeseano Jesús besa, ");
INSERT INTO zpt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","gast zha ulaleaꞌ Juan Jesús no gast zha nseaꞌ Jesús gibeꞌa. Leꞌa xa wa no yate lat besa, ndontsa no xa gudiꞌizh ndoꞌ be men leꞌa Jesús mbanka ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Weꞌe cha mluu bexa top xabgiꞌi, dub xa nsaleaꞌ Kosé Barsabás no nsaleaꞌ xa Justo, no stub xa nsaleaꞌ Matí. ");
INSERT INTO zpt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Cha mbidiꞌizhno bexa Dios ndab bexa: —Tad Dios, leꞌa go nchandoꞌ ladoꞌo itea be men. Nat bluu go ndoꞌ besa ná ton ndoꞌ itop bexa ndee mti ga. ");
INSERT INTO zpt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Leꞌa xa wa yak dub xa gun tiꞌin ten go lak ndun besa ndee, gak xa dub apostol ten ga. Leꞌa ta wa ta mlaꞌa Judas ke na mbin xa ta ugap wa, cha nchaꞌa Judas sa nsabndoꞌ yaꞌ xa castig wa. ");
INSERT INTO zpt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Cha uloꞌo bexa suert, weꞌe leꞌa Matí leꞌa ngol uyote xa lat stibdub bexa nak apostol wa. ");
INSERT INTO zpt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ngol wizh Pentecostés dub ujest ten bexa judio, leꞌa itea be xmen Jesús mzhealbe len dub niꞌi. ");
INSERT INTO zpt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ngol gor mbiꞌín bexa dub ruid ulen gibeꞌa cuent dub mbi siꞌil, cha uyoꞌo‑yá idub len niꞌi sa ndebe bexa. ");
INSERT INTO zpt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Weꞌe cha mlundoꞌ ta cuent bealꞌ, ulaꞌ‑yá gek kadga dub bexa. ");
INSERT INTO zpt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Cha uyoꞌo Espíritu ten Dios len ladoꞌo bexa. Cha usaxan bexa ndadiꞌizh bexa stubga diꞌizh, laktsa msaꞌa Espíritu ten Dios níꞌi bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Leꞌa zha wa leꞌa Jerusalén ndencho kwaꞌad bexa judio ndankea Dios, bexa ulen itea lad ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Leꞌa gor na mgen ruid siꞌil wa, cha mzhealbe kwaꞌadpa bexa sa wa. Ni lá iniꞌí bexa xteꞌe gun bexa gor na ndoꞌón bexa leꞌa bexa nde len niꞌi wa ndadiꞌizh be diꞌizh ten kadga dub be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ngwatenaꞌ bexa no ngwanseana bexa, ndab bexa ndoꞌ ltsaꞌa xa: —Bwiꞌi bego, ¿naꞌanpa bexa Galilea itea bexa lndeꞌe ndadiꞌizh ndee zha? ");
INSERT INTO zpt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tixa ndoꞌón beuna ndadiꞌizh bexa diꞌizh ten kadga dub beuna zhaga? ");
INSERT INTO zpt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Leꞌa sa ndee nde men utoꞌo Partia no Media no Elam no Mesopotamia no Judea no Capadocia no Ponto no Asia ");
INSERT INTO zpt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","no Frigia no Panfilia no Egipto no be gezh nde mas sitxá ndoꞌ Cirene ten Africa. No ncho bexa Roma sa ndee, ncho xa wa bexa judio no ncho bexa wa tiꞌi mbingea ladna Dios ten beuna xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","No ncho bexa utoꞌo Creta nsea Arabia. Ná leꞌa itea beuna ndoꞌón ndadiꞌizh bexa baꞌ be ta siꞌil ndun Dios kadga diꞌizh ten dubga beuna. ");
INSERT INTO zpt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Weꞌe leꞌa bexa wa lá iniꞌí xteꞌe gun bexa tant ndanseana bexa, cha unabdiꞌizh bexa ndoꞌ be ltsaꞌa xa, ndab bexa: —¿Xtaꞌanxága ta ndee zhaga? ");
INSERT INTO zpt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ná ncho bexa ndun usalad ndab: —Bexa baꞌ ga tant nsudna. ");
INSERT INTO zpt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Weꞌe leꞌa Pedr cha usoꞌ, no stibdub bexa wa. Cha ugeꞌ ndab xa: —Bego nak beuna xa judio no iteata bego na ndencho Jerusalén ndee, biꞌín bega ta ndee, blaꞌach bega xtaꞌan gáp naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Leꞌa besa ndee naꞌanpa nsudna lak ndanbeꞌe bega, leꞌa nat pen gor nkea ugeꞌa tempran. ");
INSERT INTO zpt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ná leꞌa ta ndee nak lak ta ndab Joel polta sakndoꞌ Dios, ");
INSERT INTO zpt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ndab Dios: Leꞌa gal be wizh lult leꞌa naꞌ uzhebpa usa Espíritu ten naꞌ ndoꞌ itea be men. Leꞌa be xinbgiꞌi bega no be xingots bega gudiꞌizh sakndoꞌ naꞌ. Leꞌa bexa ben ncho lat bega iniꞌí be ta ulu naꞌ. Leꞌa bexa gox ucheꞌa ladna be ta usa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gal be wizh wa leꞌa naꞌ uzhebpa usa Espíritu ten naꞌ ndoꞌ be xabgiꞌi no ndoꞌ be xagots, bexa ndun tiꞌin ten naꞌ, cha gudiꞌizh bexa sakndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Leꞌa naꞌ ulu sian be taꞌa yanseana be men, be ta gibeꞌa no be ta ndoꞌ gizhliyo; iniꞌí bexa ten, no bealꞌ, no xkaw zhen. ");
INSERT INTO zpt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Leꞌa wizh lá usuta xeꞌa; leꞌa mbeꞌe inaꞌ cuent ten. Leꞌa tsoꞌo wa gal wizh uzhebpa wen ten Dios Xa Nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Leꞌa tal ton ukwaꞌan Dios Xa Nibeꞌe, leꞌa xa wa gap gealnaban. ");
INSERT INTO zpt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Cha no ndab Pedr: —Blaꞌach bego men Israel ta gáp naꞌ ndee. Leꞌa bego uniꞌíka leꞌa Jesús xa gezh Nazaret juers ten Dios mbin sian be uyon no sian be ta ngwanseana be men. Leꞌa ta wa mluꞌu leꞌa Dios leꞌaka mtuꞌub xa. ");
INSERT INTO zpt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","No myak cuent xa ndoꞌ yaꞌa bego lakka uniꞌí Dios tiemp polta. Leꞌa bego usen xa, cha myun bega cuent xa ndoꞌ yaꞌa be men ugap, cha mbit bexa wa xa ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ná leꞌa Dios mxiste xa, mban xa ndoꞌ gealgut, leꞌa gealgut lá ngun gan ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Leꞌa polta leꞌa David ndab cuent ten Jesús: Leꞌa naꞌ idub tiemp mnaꞌ Dios Xa Nibeꞌe wa wats naꞌ. Naꞌan xtaꞌan gasea naꞌ, leꞌa xa wa nsoꞌ wats naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ta weꞌe uzheꞌeb nten ladna ladoꞌo naꞌ no nten lad naꞌ ndadiꞌizh naꞌ. No uníka naꞌ leꞌa Dios ulaꞌach naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Leꞌa go lá ulaꞌa naꞌ yan naꞌ lat bexa ngut. No ni lá ulaꞌa ga gazhaꞌa las naꞌ, leꞌa naꞌ nak xa mti go. ");
INSERT INTO zpt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mluu ga nes ten ga ndoꞌ naꞌ, sa ncho gealnaban. No uzheꞌeb nten lad naꞌ geal isoꞌ naꞌ wats ga. ");
INSERT INTO zpt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Bego nak beuna xa Israel, leꞌa beuna uniꞌí leꞌa David uyoꞌo polta wa ngut no mgaꞌach. No leꞌa baꞌa ten xa bi nde sa ndee nat. ");
INSERT INTO zpt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Leꞌa xa wa dub xa ndadiꞌizh sakndoꞌ Dios, no uniꞌíka xa leꞌa Dios ndab ndoꞌ xa leꞌa xa nak Cristo wa ta ugeaka ilen lat be xin David, cha inibeꞌe xa lak unibeꞌe David. ");
INSERT INTO zpt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Leꞌa gor biseata yoo‑yá, leꞌa David ndab leꞌa Cristo iban ndoꞌ gealgut. Ndab xa leꞌa Dios lá ulaꞌa Cristo yaꞌan lat bexa ngut no ni lá ulaꞌa Dios gazhaꞌa las Cristo. ");
INSERT INTO zpt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Leꞌa itea besa ndee uniꞌíndoꞌ leꞌa Dios mxiste Jesús ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Leꞌa Dios cha myoꞌo Jesús gibeꞌa sa usob xa wats Dios lad gaꞌal. Leꞌa Tad Dios cha msaꞌa juers ndoꞌ Jesús msaꞌa xa Espíritu ten Dios ndoꞌ besa ndee, lakka ndab Jesús gun xa. Leꞌa Espíritu wa leꞌa ndun ta naꞌ bega no ta ndoꞌón bega wizh nat. ");
INSERT INTO zpt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Leꞌa David naꞌanpa leꞌa ikea gibeꞌa, parea leꞌa David ndab: Leꞌa Dios Xa Nibeꞌe ndab ndoꞌ Xa Nibeꞌe ten naꞌ: “Usob wats naꞌ lad gaꞌal ndee, ");
INSERT INTO zpt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","gast gal gor ute naꞌ bexa ndaklono lu xan ndats lu.” ");
INSERT INTO zpt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Nat blaꞌach itea bego xa Israel ta ugeakapa gáp naꞌ: leꞌa Jesús xa li mkeꞌa bega ndoꞌ cruz wa, leꞌa xa wa leꞌaka Dios msoꞌ nak Cristo Xa Nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Leꞌa gor na mbiꞌín be men ta wa, cha kweaꞌ myoꞌo ladna bexa, cha unabdiꞌizh bexa ndoꞌ Pedr nsea ndoꞌ be ltsaꞌa xa, ndab bexa: —Bego nak beuna xa Israel, ¿xteꞌe nsabndoꞌ gun besa nat? ");
INSERT INTO zpt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Leꞌa Pedr cha ukaꞌab ndab: —Blaꞌa bego be ta ugap nak bego no italeaꞌ kadga dub bega gak bega xmen Jesucristo, ndontsa utsuꞌu Dios be ke ten bega no usaꞌa xa Espíritu ten xa ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Li gunno Dios bexa na nbezh Dios gak bexa xmen xa: leꞌa ta wa bego, no be xin bega, no itea bexa sit ndencho. ");
INSERT INTO zpt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","No sianta be diꞌizh mbidiꞌizh Pedr, no mtenxeꞌa xa bexa wa, ndab xa: —¡Lá gakta bega lak nak be men ugap ncho nat, ndontsa naꞌanpa utsaksi Dios bega! ");
INSERT INTO zpt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Weꞌe leꞌa ncho bexa mbingea ladna ta li mbidiꞌizh Pedr wa, cha utaleaꞌ bexa. Leꞌa wizh wa pa schon mil men uyote lat bexa nak xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Leꞌa bexa wa ntsid lak nluu be apostol wa, no uzhebpa wen nak bexa ndoꞌ be ltsaꞌa bexa. No nzhealbe bexa ndaw bexa, nsea ndadiꞌizhno bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Leꞌa itea be men ndanseana gor uniꞌí bexa be uyon ndun be apostol, be ta msaꞌa Dios gun bexa. ");
INSERT INTO zpt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Leꞌa iteanak bexa na mbingea ladna Jesús wa dubtsa nak. No itea be taꞌa ndap bexa wa, leꞌa ta wa iteanakka bexa ten. ");
INSERT INTO zpt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ncho bexa mdoꞌo be yo ten na no be taꞌa ndap bexa, cha ntseꞌa bexa med wa ndoꞌ be ltsaꞌa xa bi lak nkiꞌin bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iteanak wizh nzhealbe bexa tale ten niꞌi ten Dios, no be ta lid bexa junt ndaw bexa, nten ladna bexa no utsin nak bexa. ");
INSERT INTO zpt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","No nsaꞌa tseꞌe bexa xno ndoꞌ Dios, no leꞌa itea be men nsak ladna lak nak bexa. Leꞌa Dios leꞌa ndun kad wizh mas nsayak kwaꞌad bexa wa, ngoꞌo Dios bexa ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Leꞌa dub wizh leꞌa Pedr nsea Juan nchaꞌa sa nde niꞌi ten Dios pa gor nkea uyon uzhe, gor na ndaꞌyadiꞌizhno be men Dios. ");
INSERT INTO zpt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Leꞌa sa wa nsob dub xabgiꞌi lá yoo gan isea zha ngolta xa. Itea wizh ndaꞌulaꞌa be ltsaꞌa xa xa dub sa nyote be men len tale ten niꞌi ten Dios, sa nsaleaꞌ Puert Chul, ndontsa inab xa med ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Leꞌa gor na uniꞌí xa Pedr no Juan nchaꞌyote sa wa, cha unab xa dub med ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Weꞌe leꞌa Pedr no Juan mwiꞌi ndoꞌ xa, cha ndab Pedr: —Bwiꞌi ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Leꞌa xa wa list usob, ndanbeꞌe xa gol ncho xtaꞌan usaꞌa bexa wa ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ná leꞌa Pedr cha ndab: —Leꞌa naꞌ lá nsén med plata ni med oro, parea leꞌa ta ndap naꞌ usa naꞌ ndoꞌ lu. Leꞌa juers ten leaꞌ Jesucristo xa Nazaret, leꞌa naꞌ gáp ndoꞌ lu gosoꞌ, cha usea. ");
INSERT INTO zpt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Weꞌe leꞌa Pedr cha usen yaꞌa xa lad gaꞌal, cha uxisoꞌ Pedr xa. Bi leꞌa gor wa leꞌa be xoꞌo xa no be gendats xa cha mgeasoꞌbe. ");
INSERT INTO zpt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Leꞌa xabgiꞌi wa cha uxax ngwasoꞌ gaꞌal, cha utsinla nsea xa. Cha no xa uyoꞌono bexa wa tale ten niꞌi ten Dios, nkesea xa no ndasagaꞌal xa, ndab xa leꞌa Dios uzheꞌeb dub Dios juert. ");
INSERT INTO zpt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Leꞌa itea be men uniꞌí nsea xa, no nsaꞌa xa xno ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Weꞌe mgondoꞌ bexa leꞌa xa wa leꞌa xa li usob nab med toꞌo Puert Chul ten niꞌi ten Dios, cha uzheꞌeb ngwanseana bexa ta na li myakna xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Leꞌa xa li myakna wa lá nlaꞌapa Pedr no Juan. Weꞌe leꞌa itea be men na ndanseana cha utoꞌo karrel gast sa nsoꞌ Pedr no Juan sa nsaleaꞌ Corredor Salomón. ");
INSERT INTO zpt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Leꞌa gor uniꞌí Pedr ta wa, cha ndab xa ndoꞌ be men: —Bego xa Israel, ¿xtaꞌan ndanseana bega ta ndee zha? ¿No xtaꞌan nwiꞌi bega ndoꞌ besa ndanbeꞌe bega juers ten besa myakna xa ndee zha? ");
INSERT INTO zpt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Leꞌa Dios ten Abraham no Isaac no Jacob, xa na leꞌa nak Dios ten iteata be usan gox polta ten beuna, leꞌa xa wa leꞌa mbin mas gaꞌap ngobsoꞌ xin xa Jesús. Leꞌa Jesús wa xa na li myun bega cuent ndoꞌ yaꞌa bexa naktiꞌin, cha gor na ndiꞌizh ulaꞌa Pilat xa leꞌa bega lá kaꞌab. ");
INSERT INTO zpt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Leꞌa Jesús nak xa na mti Dios no sbeꞌen be ta nlad Dios ndun xa. Parea leꞌa bega mxee ladna xa, cha ndi unab bega ulaꞌa Pilat dub xa ndut men. ");
INSERT INTO zpt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Leꞌa bego mbit xa nsaꞌa gealnaban ndoꞌ be men, ná leꞌa Dios mxiste xa ndoꞌ gealgut lak uniꞌí besa‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Leꞌa xabgiꞌi ndee ngeꞌ ladna juers ten leaꞌ Jesús wa, ta weꞌe myakna xa. Leꞌa ta na ngeꞌ ladna xa Jesús leꞌa mbin gan dubtsa neꞌeka myakna xa ndoꞌ gaꞌal itea bego. ");
INSERT INTO zpt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Bego nak beuna xa Israel, leꞌa bego no bexa nibeꞌe ten bega mbit Jesús, parea leꞌa naꞌ uní leꞌa bega ni lá iniꞌí ton xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ná leꞌa Dios li mlaꞌa mbin bega lak ndab bexa mbidiꞌizh sakndoꞌ Dios tiemp polta, ndab bexa leꞌa Cristo nsabndoꞌ iniꞌí sian gealkweaꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nat blaꞌa bega be ta ugap nak bega, cha byach bega wats Dios, ndontsa utsuꞌu xa be ke ten bega. Weꞌe yoo xa wats bega gakno xa bega, ");
INSERT INTO zpt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","no utuꞌubgal xa Jesucristo ndoꞌ bega lak ndabka Dios. ");
INSERT INTO zpt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nat leꞌa Jesús nsabndoꞌka ncho gibeꞌa, gast gal gor na utechaꞌaw Dios itea be taꞌa ndoꞌ gizhliyo, lakka mbidiꞌizh bexa sakndoꞌ Dios tiemp polta. ");
INSERT INTO zpt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lak ndab Moisés ndoꞌ be usan gox polta ten beuna: “Leꞌa Dios Xa Nibeꞌe ten beuna uti dub xa gudiꞌizh diꞌizh ten xa lat be ltsaꞌa bega, lak mti xa naꞌ. Blaꞌach bego itea ta gab xa wa ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Leꞌa tal ton lá ulaꞌach ta gab xa wa, leꞌa bexa wa yá naꞌantapa gak xmen Dios.” ");
INSERT INTO zpt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Leꞌa Samuel no iteata bexa mbidiꞌizh sakndoꞌ Dios tsoꞌo wa, mbidiꞌizh bexa cuent ten be ta ncho be wizh nat ndee wa. ");
INSERT INTO zpt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Leꞌa ta ndab bexa polta usaꞌa Dios wa, leꞌa ta wa nsaꞌa Dios ndoꞌ bega nat. No usaꞌa Dios ndoꞌ bega lak ndab Dios gor na mbin Dios dub trat no be usan gox polta ten beuna, ndab Dios ndoꞌ Abraham: “Leꞌa naꞌ guntiꞌin dub xa ras ten lu, ndontsa wen yoo be men itea be nacion nde ndoꞌ gizhliyo.” ");
INSERT INTO zpt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Leꞌa gor na mxiste Dios xin na ndoꞌ gealgut, leꞌa Dios mtuꞌub xa ned lak ndoꞌ beuna xa Israel, ndontsa gakno xa beuna no ulaꞌa beuna be ta ugap nak beuna. ");
INSERT INTO zpt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ndalen li ndeníꞌi Pedr no Juan ndoꞌ be men wa, weꞌe ulen pla be uleꞌay no dub xa nibeꞌe ten bexa nlaꞌach niꞌi ten Dios no pla bexa saduceo. ");
INSERT INTO zpt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Leꞌa bexa wa ndakloo, geal leꞌa Pedr no Juan nluu be men wa leꞌa be men ngut wa iban ndoꞌ gealgut lak mban Jesús ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Cha usen bexa wa Pedr no Juan, cha mkeꞌa bexa xa wa litgiꞌib gast stub wizh, leꞌa gor wa yá uzhe. ");
INSERT INTO zpt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ná leꞌa kwaꞌadpa be men na mbiꞌín diꞌizh ndab Pedr wa mbingea ladna‑yá. Leꞌa lat itea bexa wa ngok pa dub gaꞌay mil xabgiꞌi. ");
INSERT INTO zpt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ngol stubtsa wizh leꞌa bexa nibeꞌe ten bexa judio no bexa gox nsak no be mech ten ley mzhealbe Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","No nsoꞌ Anás uleꞌay ndon leꞌa nsak no Caifás no stub Juan no Alejandro no iteata be xabgiꞌi ltsaꞌa uleꞌay ndon leꞌa nsak. ");
INSERT INTO zpt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Cha mte bexa Pedr no Juan tlaw bexa, cha unabdiꞌizh bexa ndab bexa: —¿Ton msaꞌa juers nati ton mtuꞌub bego gun bega ta wa zha? ");
INSERT INTO zpt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Weꞌe leꞌa Pedr noꞌo juers ten Espíritu ten Dios len ladoꞌo na ukaꞌab ndab: —Bego xa nibeꞌe, bego xa gox nsak ten beuna xa Israel: ");
INSERT INTO zpt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","leꞌa bega nabdiꞌizh ná xtaꞌan utsin mbinno besa dub xabgiꞌi gizh no xteꞌe li myakna xa. ");
INSERT INTO zpt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nat gab besa ndoꞌ itea bego no ndoꞌ iteata be men Israel leꞌa Jesucristo xa gezh Nazaret myunyakna xabgiꞌi nsoꞌ ndoꞌ bega ndee. Leꞌa Jesús wa xa na li mkeꞌa bega ndoꞌ cruz, cha mxiste Dios xa ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Leꞌa xa wa xa na li mxelad bega cuent dub geꞌ nxelad bexa ndandeꞌe niꞌi, ná nat leꞌa geꞌ wa ndon leꞌa nak skin niꞌi. ");
INSERT INTO zpt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Leꞌa ndon nab Jesús sun gan koꞌo be men ndoꞌ be ke ten bexa. Leꞌa idub ndoꞌ gizhliyo naꞌanta ton ntuꞌub Dios koꞌo beuna ndoꞌ be ke ten beuna. ");
INSERT INTO zpt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Leꞌa bexa nibeꞌe wa ngwanseana gor uniꞌí bexa leꞌa Pedr no Juan ni lá nzheb ndadiꞌizh, maska ndidotsa mtsid bexa. Weꞌe mgondoꞌ bexa leꞌa Pedr no Juan xa ukeseano Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Leꞌa xa li myakna wa no nsoꞌ sa wa, ta weꞌe naꞌanta xteꞌe ngab bexa ndoꞌ Pedr no ndoꞌ Juan. ");
INSERT INTO zpt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Cha unibeꞌe bexa itate bexa sa wa, cha myanbeyadiꞌizh nab bexa nibeꞌe wa, ");
INSERT INTO zpt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ndab bexa: —¿Xteꞌe gunno beuna be xabgiꞌi baꞌ? Leꞌa itea be men ndencho Jerusalén ndee uniꞌí leꞌa ta mbin bexa wa dub uyon. Leꞌa beuna lá yoo gan gab leꞌa‑yá gealkwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Parea ndontsa lá igenta mas ta ndee, gabtsa beuna ndoꞌ bexa leꞌa beuna utsaksi bexa tal leꞌa bexa gudiꞌizhta cuent ten Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Weꞌe utezhgal bexa Pedr no Juan, cha li unibeꞌe bexa ndoꞌ bexa wa yá naꞌantapa gudiꞌizh bexa ndoꞌ be men cuent ten Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ná leꞌa bexa wa ukaꞌab ndab: —¿Nsak bega zha leꞌa besa nsabndoꞌ uxobgek ndoꞌ bego, cha naꞌanpa uxobgek besa ndoꞌ Dios? ");
INSERT INTO zpt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Leꞌa besa lá yoo gan ulaꞌa lá gudiꞌizhta besa ta uniꞌí besa no ta mbiꞌín besa. ");
INSERT INTO zpt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Weꞌe leꞌa bexa nibeꞌe wa cha ndab ndoꞌ Pedr no ndoꞌ Juan: —Leꞌa besa utsaksi bega tal leꞌa bega gudiꞌizhta diꞌizh ten Jesús. Cha mlaꞌa bexa Pedr no Juan. Leꞌa bexa wa lá izheal xteꞌe utsaksi xa bexa wa, geal leꞌa itea be men ndab leꞌa Dios uzheꞌeb dub Dios wen, ta na li myakna xa gizh wa. ");
INSERT INTO zpt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Leꞌa xabgiꞌi na li myakna juers ten Dios wa ncho masla top gaꞌal liꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Leꞌa gor na mkaꞌan Pedr no Juan sa wa, cha nseaꞌ bexa lat ltsaꞌa bexa, cha mbidiꞌizh bexa itea be ta ndab be uleꞌay nibeꞌe no bexa gox nsak. ");
INSERT INTO zpt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Leꞌa gor na li mbiꞌín bexa ta wa, leꞌa bexa cha junt mbidiꞌizhno Dios, ndab bexa: —Go Dios Xa Nibeꞌe, go leꞌa nak Dios mbindeꞌe gibeꞌa no gizhliyo no nitsdoꞌo no iteata be ta ncho. ");
INSERT INTO zpt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Leꞌa go msaꞌa ta mbidiꞌizh David sakndoꞌ ga, ndab David: ¿Xtaꞌan lbaꞌata ngiꞌi be men baꞌ zha? ¿No xtaꞌan ndanbeꞌe bexa be ta naꞌan xtiꞌin? ");
INSERT INTO zpt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Leꞌa bexa nibeꞌe ndoꞌ gizhliyo mzhealbe, no bexa naktiꞌin myakjunt, ndakloo bexa ndoꞌ Dios Xa Nibeꞌe no ndoꞌ xa nak Cristo. ");
INSERT INTO zpt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ugeaka leꞌa Herodes no Poncio Pilat no bexa Israel nsea bexa naꞌanpa xa Israel li mzhealbe len gezh ndee, ngokloo bexa ndoꞌ Jesús xin go, xa wen mtuꞌub go. ");
INSERT INTO zpt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Cha mbin bexa lakka ta ndab go gak‑a wa. ");
INSERT INTO zpt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nat bwiꞌi go, Dios Xa Nibeꞌe, xteꞌe ugap níꞌi bexa ndoꞌ besa. Bsaꞌa ga juers ndontsa lá izheb besa gudiꞌizh besa diꞌizh ten ga. ");
INSERT INTO zpt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","No bsaꞌa ga juers yunyakna besa be men gizh, no gun besa sian be uyon juers ten leaꞌ Jesús xin ga, ta uluu leꞌa go leꞌa mtuꞌub besa. ");
INSERT INTO zpt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Leꞌa gor na mtayadiꞌizh bexa ndoꞌ Dios, leꞌa sa ndebe bexa cha mwiꞌin. Weꞌe leꞌa itea bexa wa mas uyoꞌo juers ten Espíritu ten Dios ladoꞌo na. Cha ni lá izhebta bexa ndadiꞌizh bexa diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Leꞌa itea bexa na mbingea ladna Jesús wa dubtsa ncho ladna bexa, no dubtsa ndanbeꞌe bexa. No ni naꞌan ton ndab leꞌa be ta ndap bexa ta tentsa bexa, leꞌa ta ndap bexa wa ndi itea bexa ten. ");
INSERT INTO zpt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Leꞌa be apostol ni lá nzheb ndadiꞌizh leꞌa Jesús Xa Nibeꞌe wa mbanka ndoꞌ gealgut. No uzhebpa ngokno Dios itea be xmen Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Leꞌa lat bexa wa lá yoꞌo ni dub bexa ngun jwalt ta nkiꞌin na, geal leꞌa bexa na ndap yo no niꞌi, ncho xa mdoꞌo ta wa cha nseano bexa med wa, ");
INSERT INTO zpt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","cha myun bexa cuent ta wa ndoꞌ be apostol. Leꞌa be apostol cha ntseꞌa med wa bi lak nkiꞌin bexa‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Leꞌa dub bexa wa dub xa levita nsaleaꞌ Kosé, xa isla Chipre. No msaleaꞌ be apostol xa Bernabé (leꞌa ta wa dub diꞌizh gab: xa nluꞌuzh men). ");
INSERT INTO zpt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Leꞌa xa wa mdoꞌo dub bleꞌa yo ndap na, cha myun xa cuent med wa ndoꞌ be apostol. ");
INSERT INTO zpt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uyoꞌo dub xa nsaleaꞌ Ananías no Safira xagots ten xa. Leꞌa bexa wa mdoꞌo dub bleꞌa yo. ");
INSERT INTO zpt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ná leꞌa xa wa myaꞌanno stub tuzh med wa, cha myun xa cuent iteata med wa ndoꞌ be apostol. Leꞌa xagots ten xa wa noka uniꞌí ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Weꞌe leꞌa Pedr cha ndab ndoꞌ Ananías: —Ananías, ¿xteꞌe uyoꞌo maxuꞌu ladoꞌo lu myaꞌanno lu stub tuzh med ta na li mdoꞌo lu yo wa zha? ¿Xtaꞌan li nkwiꞌinno lu Espíritu ten Dios zha? ");
INSERT INTO zpt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ná lid lu ten yo wa zha? Gor na mdoꞌo lu‑yá, ¿lid xmedka lu ta wa zha? ¿Xteꞌe ni lu lbaꞌa mbin lu? Leꞌa lu naꞌanpa ndoꞌ dub men mbin gealkwiꞌin, leꞌa lu ndi ndoꞌ Dios li mbin. ");
INSERT INTO zpt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Leꞌa gor na mbiꞌín Ananías ta li ndab Pedr, cha ulayat xa cha ngut xa. Leꞌa itea bexa na mbiꞌín ta wa cha uzheꞌeb mzhebbe. ");
INSERT INTO zpt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Cha ulen pla be xabgiꞌi ben mtixko Ananías lad, cha mbiꞌi bexa wa xa, cha mkaꞌach bexa xa. ");
INSERT INTO zpt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsoꞌo wa pa schon gor ulenga xagots ten Ananías wa, ni lá iniꞌí xa xtaꞌan ngwasea xabgiꞌi ten xa. ");
INSERT INTO zpt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Weꞌe leꞌa Pedr cha ndab ndoꞌ xa: —Gud naga lika ngok yo mdoꞌo bega wa zha. Leꞌa xagots wa mkwiꞌin ndab: —Leꞌa ta wa lika ngok. ");
INSERT INTO zpt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Leꞌa Pedr cha ndab: —¿Xtaꞌanxá dubtsa mbidiꞌizh bega ukwiꞌinno bega Espíritu ten Dios zhaga? Ndoꞌón lu leꞌa bexa na mkaꞌach xabgiꞌi ten lu wa nchabela. Nat leꞌa bexa nogal lu li ukaꞌach. ");
INSERT INTO zpt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bi leꞌa gor wa leꞌa xagots wa noga ulayat sa nsoꞌ Pedr, cha ngut xa. Leꞌa gor uyoꞌo be xabgiꞌi wa len niꞌi, leꞌa xagots wa noga ngutla. Cha mbiꞌigal bexa xa, cha mkaꞌach bexa xa wats xabgiꞌi ten xa. ");
INSERT INTO zpt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Weꞌe leꞌa itea be xmen Jesús no iteata be men na mbiꞌín ta wa cha uzhebpa mzheb. ");
INSERT INTO zpt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Leꞌa be wizh wa leꞌa be apostol ndun sian be uyon ten Dios, be ta ndanseana be men. No itea wizh nzhealbe be xmen Jesús dub lad wats niꞌi ten Dios, sa nsaleaꞌ Corredor Salomón. ");
INSERT INTO zpt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Leꞌa be men ndab leꞌa bexa wa xa wenka nak, parea ni dub bexa naꞌanpa nak xmen Jesús lá uchealtsaꞌa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Leꞌa bexa na ndangea ladna Jesucristo wa uzhebpa ngok kwaꞌadbe, lak be xabgiꞌi no liga be xagots. ");
INSERT INTO zpt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Leꞌa be men ulote be men gizh ndiꞌib ndoꞌ yaloꞌon no ndoꞌ da toꞌo nes sa itid Pedr. Mbinbeꞌe bexa tal masa xiꞌíntsa Pedr igiꞌin las bexa gizh wa, cha yakna bexa. ");
INSERT INTO zpt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","No kwaꞌadpa be men be gezh nde gax wa ulenno be men gizh gast Jerusalén, no bexa nsak gizhtont ncho be mbi bxin len ladoꞌo na. Leꞌa itea bexa wa cha myaknabe. ");
INSERT INTO zpt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Weꞌe leꞌa uleꞌay ndon leꞌa nsak no itea be xmen xa, bexa saduceo, uzheꞌeb ngoklobe. ");
INSERT INTO zpt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Cha usen bexa wa be apostol, cha mkeꞌa bexa bexa litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ná leꞌa dub angel ten Dios ulen gor teꞌal, mxaꞌal be puert ten litgiꞌib, cha uloꞌo xa bexa wa. Cha ndab angel: ");
INSERT INTO zpt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Waꞌbe bega wats niꞌi ten Dios, cha bidiꞌizh bega be diꞌizh nsaꞌa gealnaban ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Leꞌa ngot xeꞌa tempran leꞌa bexa nchaꞌbe wats niꞌi ten Dios. Cha usaxan bexa nluu bexa be men. Ngol gor leꞌa uleꞌay ndon leꞌa nsak no be xmen xa no bexa gox nsak ten bexa Israel mzhealbe. Cha unibeꞌe bexa ndoꞌ bexa nlaꞌach sa wa yaꞌyoꞌo bexa wa bexa len litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ná leꞌa gor na ulayaꞌ bexa sa wa, cha uniꞌí bexa leꞌa bexa wa naꞌanla sa wa. Cha myach bexa ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Leꞌa gor ulayaꞌ besa leꞌa toꞌo litgiꞌib wa nsoꞌnyawka no bexa ndeulaꞌach wa ndeka. Parea leꞌa gor na mxaꞌal besa puert wa, leꞌa len wa naꞌanla ton ndencho. ");
INSERT INTO zpt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Leꞌa gor na mbiꞌín bexa ta wa, leꞌa uleꞌay ndon leꞌa nsak no xa nibeꞌe ten bexa nlaꞌach niꞌi ten Dios no be uleꞌay nibeꞌe cha ndab ndoꞌ ltsaꞌa na: —¿Pa gast yandoꞌ ta ndee zha? ");
INSERT INTO zpt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Weꞌe ulen stub xa ndab: —Blaꞌach bego, leꞌa bexa na li mkeꞌa bega litgiꞌib wa ndeuluugal be men dub lad wats niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Weꞌe leꞌa bexa nlaꞌach sa wa nsea xa nibeꞌe ten bexa wa ngwaꞌgiꞌigal be apostol, parea naꞌan xteꞌe ngunno bexa wa bexa, geal leꞌa bexa nzheb ndoꞌ be men nchaꞌa be men ulaꞌgeꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Leꞌa gor na mlenno bexa wa bexa, cha mte bexa xa ndoꞌ be men nsak wa. Weꞌe leꞌa uleꞌay ndon leꞌa nsak cha ndab: ");
INSERT INTO zpt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Lá iniꞌí bega leꞌa besa yá ndabla lá uluuta bega cuent ten Jesús ndoꞌ be men zha? ¡Ná nat leꞌa idub gezh Jerusalén ndee ngen be ta nluu bega wa! No nlad bega ukeake bega besa ta li ngut Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Leꞌa Pedr no be ltsaꞌa xa cha ukaꞌab ndab: —Leꞌa besa nsabndoꞌ uxobgek ned ndoꞌ Dios, naꞌanpa ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Leꞌa Dios xa na ngwankea be usan gox polta ten beuna wa, leꞌa xa wa mxiste Jesús ndoꞌ gealgut, xa na li mbit bego ukea ndoꞌ cruz wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Leꞌa Dios msaꞌa sa nsob Jesús wats Dios lad gaꞌal, no myunno xa Jesús dub xa nibeꞌe no xa nsaꞌa gealnaban, ndontsa ulaꞌa be men Israel be ta ugap nak bexa, cha yuꞌu be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Leꞌa ta wa ta ndadiꞌizh besa ndoꞌ be men, lak ndakno Espíritu ten Dios besa. Leꞌa Dios nsaꞌa Espíritu ten na ndoꞌ bexa nxobgek ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Leꞌa gor na mbiꞌín bexa ta wa, cha uzhebpa ngokloo bexa, gast nlad bexa gut bexa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ná leꞌa lat bexa wa nsob dub xa nsaleaꞌ Gamaliel xa fariseo, dub mech ten ley. Leꞌa be men uzhebpa ndap mod ndoꞌ xa wa. Cha usoꞌ xa ndab xa itoꞌo be apostol dub xlaꞌal. ");
INSERT INTO zpt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Weꞌe ndab xa ndoꞌ bexa nibeꞌe wa: —Bego xa Israel, gop bega cuent nsea ta gunno bega be xabgiꞌi baꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ntseꞌa ladna bega zha uyoꞌo dub xa nsaleaꞌ Teudas, ndab xa leꞌa xa uzhebpa dub xa nsak. Pa dub dap gayoꞌo xabgiꞌi usankea tsoꞌo xa. Ná leꞌa gor na mbit be men xa, leꞌa itea be xmen xa cha mteꞌachso. Cha litsa unitndoꞌ ta ndun bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsoꞌo wa ligal uyoꞌo stub xa nsaleaꞌ Judas xa Galilea. Leꞌaga kwaꞌadpa be men usankea tsoꞌo xa be wizh ten censo. Parea gor na mbit be men xa, leꞌa be xmen xa itea mteꞌachsogal. ");
INSERT INTO zpt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Leꞌa nat leꞌa naꞌ gáp ndoꞌ bego, blaꞌa bega no naꞌan xteꞌe gunno bega bexa baꞌ. Leꞌa tal ta ndun bexa baꞌ ta tentsa men, leꞌa‑yá sbeas yoꞌoka. ");
INSERT INTO zpt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ná tal leꞌa‑yá ta nlad Dios, leꞌa bego lá gun gan initndoꞌ‑yá. Blaꞌach bego naꞌanpa kuyono bego Dios. ");
INSERT INTO zpt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Weꞌe leꞌa bexa nibeꞌe wa dubtsa nak nsea ta ndab xa wa. Cha utezh bexa be apostol wa, cha udin bexa bexa wa. Cha ndab bexa nibeꞌe wa: —Yá lá gudiꞌizhta bega cuent ten Jesús wa. Cha mlaꞌa bexa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Leꞌa gor na mkaꞌan bexa sa wa uzhebpa mten ladna bexa, geal leꞌa Dios mlaꞌa utid bexa gealkweaꞌ geal nak bexa xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Weꞌe leꞌa iteanak wizh leꞌa bexa nluu be men dub lad wats niꞌi ten Dios no ta lid be men, ndab bexa leꞌa Jesús nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Leꞌa be wizh wa leꞌa be xmen Jesús nsayak kwaꞌad. Parea leꞌa lat bexa wa leꞌa bexa níꞌi diꞌizh griego usaxan ndakloo ndoꞌ bexa níꞌi diꞌizh hebreo, ndab bexa: —Leꞌa be xagots ngut xabgiꞌi ten na ncho lat besa ndee, ncho zha lá ndal bexa sian ta gaw bexa, gor na ntseꞌa bega ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Weꞌe leꞌa isatibtop be apostol wa mchealte iteanak be xmen Jesús, cha ndab bexa: —Lá nsabndoꞌ ulaꞌa besa lá gudiꞌizh besa diꞌizh ten Dios, cha ndi utseꞌa besa ta ndaw bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ta weꞌe bti bega gaꞌad xabgiꞌi ndák lat bega, bexa wen nak no uzheꞌeb ncho juers ten Espíritu ten Dios ladoꞌo xa. Leꞌa bexa wa leꞌa gun tiꞌin ndee. ");
INSERT INTO zpt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Leꞌa besa ndee li syoꞌo gan gudiꞌizhnota Dios no uluuta besa be men diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Leꞌa itea bexa wa ngol ladna ta ndab be apostol wa, cha mti bexa Xteb dub xa uzheꞌeb ngeꞌ ladna Dios no uzheꞌeb ndap xa juers ten Espíritu ten Dios. Nsea mti bexa Julip no Prócoro no Nicanor no Timón no Parmenas no Nicolás xa Antioquía. Leꞌa Nic wa naꞌanpa xa judio, parea ndankea xa Dios lak ndun bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Weꞌe cha mte bexa isagaꞌad bexa wa ndoꞌ be apostol. Cha mxoꞌob be apostol yaꞌa na gek bexa wa, unab bexa ndoꞌ Dios gakno Dios isagaꞌad bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Weꞌe leꞌa diꞌizh ten Jesús uzhebpa mteꞌachso. Leꞌa gezh Jerusalén uzhebpa nsayak kwaꞌad be xmen Jesús, no gast kwaꞌadpa be uleꞌay mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Leꞌa Dios uzhebpa ndakno Xteb, no nsaꞌa xa juers ndoꞌ xa, ndun Xteb sian be uyon ten Dios, be ta ndanseana be men. ");
INSERT INTO zpt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Leꞌa ncho dub sa nsaleaꞌ Be Men Myaꞌak, dub niꞌi sa nzhealbe bexa judio. Leꞌa pla bexa ten sa wa usaxan nyotoꞌono Xteb. Leꞌa xa wa bexa gezh Cirene nsea gezh Alejandría no Cilicia nsea Asia. ");
INSERT INTO zpt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ná lá ngun bexa gan ndoꞌ Xteb, leꞌa Xteb uzhebpa ndák, lak nsaꞌa Espíritu ten Dios ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Weꞌe msaꞌa bexa med ukaꞌa stapla be men ndontsa gun bexa gealkwiꞌin, ndab bexa leꞌa bexa mbiꞌín leꞌa Xteb nisi Moisés no Dios. ");
INSERT INTO zpt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Weꞌe uzheꞌeb ngokloo be men no bexa gox nsak no be mech ten ley. Cha usen bexa Xteb, cha mbiꞌi bexa xa sa nzhealbe bexa nibeꞌe wa. ");
INSERT INTO zpt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Cha ulenno bexa be men gun gealkwiꞌin, ndab be men wa: —Leꞌa xabgiꞌi ndee ni lá nlaꞌa ta li nisi xa niꞌi ten Dios ndee no ley ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Leꞌa besa mbiꞌín ndab xa leꞌa Jesús xa Nazaret wa ulate niꞌi ten Dios, no ucheꞌa xa be costumbr ndeno beuna, ta mchaꞌan Moisés. ");
INSERT INTO zpt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Weꞌe leꞌa be men nibeꞌe wa no itea bexa nde sa wa, mwiꞌi bexa ndoꞌ Xteb. Cha uniꞌí bexa leꞌa ndoꞌ Xteb nluu cuent ndoꞌ angel ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Leꞌa uleꞌay ndon leꞌa nsak cha unabdiꞌizh ndoꞌ Xteb, ndab xa: —¿Ta ugeaka ta lbaꞌa ndab be men baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Leꞌa Xteb ukaꞌab ndab: —Bego bexa ltsaꞌa naꞌ, no bego xa nsak baꞌ, blaꞌach bego ta gáp naꞌ ndee. Leꞌa Dios siꞌil ten beuna mlundoꞌ ndoꞌ Abraham usan gox ten beuna, zha na bi ncho xa Mesopotamia, zha biseata yaꞌyoꞌo xa gezh Harán. ");
INSERT INTO zpt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ndab Dios ndoꞌ Abraham: “Blaꞌa lazh lu baꞌ no be ltsaꞌa lu, cha ndi waꞌ ndoꞌ yo sa uluu naꞌ ndoꞌ lu.” ");
INSERT INTO zpt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Weꞌe leꞌa Abraham utoꞌo sa wa, sa no nsaleaꞌ Caldea, cha nchaꞌa xa uyoꞌo xa Harán. Tsoꞌo wa ngut xus Abraham, cha mbiꞌi Dios Abraham ndoꞌ yo ndee, sa ndencho beuna nat. ");
INSERT INTO zpt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ná leꞌa Dios lá usaꞌa ni dub bleꞌa yo ikaꞌa Abraham, ni dub tuzh sa isoꞌ Abraham. Ndi ndab Dios leꞌa Dios usaꞌaka yo ndee ndoꞌ be xin xa, ná leꞌa zha wa leꞌa Abraham ni dub xin na bi lá ndap. ");
INSERT INTO zpt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ndab Dios ndoꞌ Abraham: “Leꞌa be xin lu yaꞌyoo dub sa naꞌanpa lazh bexa. Leꞌa bexa wa lajuers gun tiꞌin ten be men sa wa, no ugap gunno bexa wa be xin lu dub dap gayoꞌo liꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ná leꞌa naꞌ utsaksi bexa na li ugap gunno be xin la wa. Cha tsoꞌo wa leꞌa bexa itoꞌo sa wa, cha yankea bexa naꞌ sa ndee.” ");
INSERT INTO zpt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Leꞌa Dios cha mbinno Abraham dub trat, ndab Dios xteꞌe yoo beꞌe be meꞌed bgiꞌi, ta uluu leꞌa bexa nxobgekka ndoꞌ trat wa. Ta weꞌe zha ngop Abraham Isaac, cha ulo Abraham beꞌe Isaac wizh xoꞌon ngol Isaac. Cha liga mbinno Isaac xin na Jacob. Leꞌa Jacob liga ulo beꞌe isatibtop be xin na, be usan gox polta ten beuna. ");
INSERT INTO zpt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Leꞌa be xin Jacob wa nxeeno ladnabe leꞌaka dub wit bexa nsaleaꞌ Kosé. Cha mdoꞌo bexa Kosé ndoꞌ be men ngwaꞌudoꞌo xa Egipto. Ná leꞌa Dios lá nlaꞌa Kosé. ");
INSERT INTO zpt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Leꞌa Dios ngokno xa ndoꞌ itea be ta juert utid xa. No mbin Dios uzhebpa ndák Kosé no msayaꞌ xa ndoꞌ faraón xa nibeꞌe Egipto. Leꞌa faraón cha ulaxoꞌob Kosé, leꞌa xa leꞌa unibeꞌe idub Egipto no nchansu xa ta lid faraón. ");
INSERT INTO zpt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tsoꞌo wa uyoꞌo win Egipto no Canaán ndee. Cha uzhebpa kweaꞌ uyoꞌo be men. Leꞌa be usan gox polta ten beuna lá ndapta ta gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Leꞌa gor na mbiꞌín Jacob leꞌa Egipto ncho trig gaw bexa, cha mtuꞌub xa be xin xa, be usan gox polta ten beuna. Leꞌa ta wa biaj ned ngwaꞌbe bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Leꞌa biaj itop ngwaꞌbe bexa Egipto, leꞌa Kosé ndab ndoꞌ bexa leꞌa bexa wit na. Weꞌe uniꞌí faraón ta xan ná Kosé. ");
INSERT INTO zpt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Cha ndab Kosé ndoꞌ be wit na yaꞌyoꞌo bexa Jacob xus bexa, no itea be ltsaꞌa xa. Leꞌa itea bexa wa pa chon gaꞌal ncho tiꞌin bexa. ");
INSERT INTO zpt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Li nak nchaꞌa Jacob Egipto, sa ngut xa no be usan gox polta ten beuna. ");
INSERT INTO zpt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Leꞌa bexa wa mgaꞌach gezh Siquem ten Canaán ndee, len baꞌa sa usiꞌi Abraham ndoꞌ be xin Hamor xa Siquem. ");
INSERT INTO zpt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ná leꞌa zha ndencho bexa wa Egipto leꞌa bexa uzheꞌeb ngok kwaꞌad. Leꞌa zha na nsaso gax zha gun Dios ta ndab Dios ndoꞌ Abraham, ");
INSERT INTO zpt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","zha weꞌe uyoꞌo stub xa nibeꞌe Egipto, dub xa lá igondoꞌ Kosé. ");
INSERT INTO zpt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Leꞌa xa wa mkwiꞌinno bexa Israel no uzheꞌeb mtsaksi xa be usan gox polta ten beuna. No unibeꞌe xa ulaꞌa be xagots Israel gat be meꞌed bgiꞌi tiꞌi ngol, ndontsa naꞌanpa gak kwaꞌad bexa. ");
INSERT INTO zpt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Leꞌa tiemp weꞌe ngol Moisés. Leꞌa Dios uzheꞌeb nsak ladna lak nak meꞌed wa. Leꞌa be usan ten meꞌed mlaꞌach meꞌed chon mbeꞌe ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tsoꞌo wa mlaꞌa bexa meꞌed, parea leꞌa xingots faraón mzheꞌal meꞌed. Cha mlaꞌach xa meꞌed, cha ngoꞌol meꞌed cuentkata dub xin xa. ");
INSERT INTO zpt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Weꞌe mtsid Moisés itea be ta ndák bexa Egipto. Cha myak xa dub xa ndák itea ta ndadiꞌizh xa no ta ndun xa. ");
INSERT INTO zpt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Leꞌa zha ncho Moisés dub top gaꞌal liꞌin, weꞌe mbinbeꞌe xa yaꞌinaꞌ xa bexa Israel, bexa ltsaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ná leꞌa gor na uniꞌí xa leꞌa dub xa Egipto nibeꞌe ndoꞌ be men wa nkegin dub xa Israel, leꞌa Moisés utoꞌo ngwaꞌulat xa wa. Cha mbit Moisés xa Egipto wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Leꞌa Moisés mbinbeꞌe leꞌa bexa Israel, bexa ltsaꞌa xa, yakbeꞌena leꞌa Dios guntiꞌin Moisés igote bexa sa wa, ná leꞌa bexa lá yakbeꞌena ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ngol stubtsa wizh leꞌa Moisés uniꞌí top xa Israel ndeyobe, cha nlad Moisés xe kwe bexa, ndab xa: “Leꞌa bego wit na, ¿xtaꞌan ngi ndeyo bega zha?” ");
INSERT INTO zpt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Weꞌe leꞌa xa li nkegin ltsaꞌa na wa cha msiꞌi xa Moisés, ndab xa: “¿Ton ulaxoꞌob lu gak lu xa nibeꞌe no juez ten besa zha? ");
INSERT INTO zpt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Nati nlad lu gut lu naꞌ lak mbit lu xa Egipto naꞌag wa zha?” ");
INSERT INTO zpt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Leꞌa gor na mbiꞌín Moisés ta wa, cha mxoꞌon xa, nchaꞌa xa dub sa sit nsaleaꞌ Madián. Leꞌa sa wa kwen uyoꞌo Moisés, cha ngop Moisés top xin na. ");
INSERT INTO zpt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ngol zha nchola Moisés sa wa top gaꞌal liꞌin, leꞌa dub angel ten Dios mlundoꞌ ndoꞌ Moisés lat bealꞌ sa nsayolꞌ dub yagich. Leꞌa sa wa geꞌe sa bid gax sa nsob geꞌe Sinaí. ");
INSERT INTO zpt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Leꞌa gor na uniꞌí Moisés ta wa cha ngwanseana xa, cha nchaꞌwiꞌi xa mas gax. Cha mbiꞌín xa ti Dios Xa Nibeꞌe ndab: ");
INSERT INTO zpt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Leꞌa naꞌ nak Dios ndankea Abraham no Isaac no Jacob, be usan gox polta ten lu.” Leꞌa Moisés usaxan nxis tant nzheb, ni lá ndun xa rages iwiꞌi xa ndoꞌ ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Leꞌa Dios cha ndab ndoꞌ xa: “Ulate ndab lu, leꞌa sa nsoꞌ lu baꞌ dub sa umbiꞌi ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Leꞌa naꞌ uní xteꞌeta kweaꞌ ncho be xmen naꞌ ndencho Egipto, no ndón naꞌ xteꞌeta nbixti bexa. Ta weꞌe ndal naꞌ ndontsa ko naꞌ bexa ndoꞌ yaꞌa bexa Egipto. Utsea nat, leꞌa naꞌ utuꞌub lu Egipto.” ");
INSERT INTO zpt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Leꞌa bexa Israel wa mxeladla Moisés, ndab bexa: “¿Ton ulaxoꞌob lu gak lu xa nibeꞌe no juez ten besa zha?” Ná leꞌa Dios mtuꞌubka xa cuent dub xa nibeꞌe, kote xa bexa sa wa, lak ndab angel li mlundoꞌ lat yagich wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","’Weꞌe leꞌa Moisés leꞌa uloꞌo be usan gox polta ten beuna Egipto. Mbin xa sian ta ngwanseana be men zha uyoꞌo bexa Egipto, no zha utakea bexa tlaw Nitsdoꞌo Nane, no zha ukesea bexa geꞌe sa bid dub top gaꞌal liꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Leꞌa Moisés leꞌaka ndab ndoꞌ bexa Israel: “Leꞌa Dios Xa Nibeꞌe ten beuna uti dub xa gudiꞌizh sakndoꞌ xa lat be ltsaꞌa bego lak mti xa naꞌ. Blaꞌach bego be ta gab xa wa.” ");
INSERT INTO zpt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Leꞌa Moisés leꞌakaga xa uyoꞌo lat be usan gox polta ten beuna zha ukesea bexa geꞌe sa bid. Leꞌa geꞌe Sinaí leꞌa dub angel uníꞌi ndoꞌ Moisés, msaꞌa angel be diꞌizh nsaꞌa gealnaban, ndontsa utid xa diꞌizh wa ndoꞌ beuna. ");
INSERT INTO zpt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ná leꞌa be usan gox polta ten beuna naꞌanpa uxobgek ndoꞌ Moisés, leꞌa bexa ndi mxelad xa no nlad bexa yach bexa leꞌaka Egipto. ");
INSERT INTO zpt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ndab bexa ndoꞌ Aarón: “Bindeꞌe ga be dios isaned ndoꞌ beuna, leꞌa beuna lá iniꞌí tal xtaꞌan ngwasea Moisés, xa na li uloꞌo beuna Egipto wa.” ");
INSERT INTO zpt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Weꞌe cha mbindeꞌe bexa dub ta cuent nak bser. Cha msaꞌa bexa man xnab ndoꞌ bser wa. No ulo bexa dub ujest ten bser, ta li mbindeꞌe leꞌaka bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Weꞌe leꞌa Dios mlaꞌa bexa, yankea bexa be taꞌa ndiꞌib gibeꞌa, lak nkeaniꞌi ndoꞌ libr ten be profet, ndab Dios: Bego xa Israel, naꞌanpa ngut bega ni dub man ndoꞌ naꞌ, ndoꞌ idub top gaꞌal liꞌin utesea bega geꞌe sa bid wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ndi mbiꞌi bega lid Moloc no mbeal ten Renfán, ta mbindeꞌe bega yankea bega. Nat leꞌa naꞌ ulaꞌa leꞌa be men goꞌo bega mas galbaꞌa gezh Babilonia. ");
INSERT INTO zpt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Leꞌa zha na utesea be usan gox polta ten beuna geꞌe sa bid wa, ndeno bexa niꞌilad ten Dios, ta mluu leꞌa Dios nkeseanoka bexa. Leꞌa ta wa ngokndeꞌe lak unibeꞌe Dios no lak mluu Dios‑a ndoꞌ Moisés. ");
INSERT INTO zpt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Cha myun bexa cuent niꞌilad wa ndoꞌ be xin xa. Weꞌe leꞌa zha uyoꞌo Josué, leꞌa bexa cha ulenno ta wa gast ndoꞌ yo ndee, zha na ulantuꞌub Dios be men naꞌanpa xa Israel sa ndee. Leꞌa bexa wa ndeno niꞌilad wa gast ngol zha na uyoꞌo David. ");
INSERT INTO zpt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Leꞌa Dios uzhebpa nsak ladna lak nak David. Cha unab David permis ndoꞌ Dios gundeꞌe David dub niꞌi ten Dios, sa yankea bexa Israel xa. ");
INSERT INTO zpt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ná leꞌa Salomón xin David leꞌa mbindeꞌe niꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Parea leꞌa Dios naꞌanpa nyoꞌo len niꞌi ndandeꞌe be men, lak ndab dub xa ndadiꞌizh sakno Dios tiemp polta: ");
INSERT INTO zpt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Leꞌa gibeꞌa nak sa nsoꞌob naꞌ, leꞌa ndoꞌ gizhliyo nak sa nsoꞌ xoꞌo naꞌ. ¿Xteꞌe nak niꞌi gundeꞌe be men guntiꞌin naꞌ zha? ¿Nati xteꞌe gak dub sa une naꞌ? ");
INSERT INTO zpt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Leꞌa naꞌ ndee leꞌa mbinde iteanak be ta ncho. ");
INSERT INTO zpt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Weꞌe no ndab Xteb: —¡Uzhebpa ngud nak ladoꞌo bego! Leꞌa bego ndap nchaꞌ na, ná lá nsakyoꞌón bega. Leꞌa bego nak lak ngok be usan gox polta ten bega, leꞌa bega sbeꞌen lá nlad uxobgek ndoꞌ Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Leꞌa be usan gox polta ten bega xela mbinno itea bexa mbidiꞌizh sakndoꞌ Dios. Leꞌa bexa wa mbit bexa mbidiꞌizh xteꞌe ilen Cristo, xa ndun sbeꞌen be ta wen. Leꞌa xa wa yá mbiꞌidla, ná leꞌa bego xela mbinno xa, cha mbit bega xa. ");
INSERT INTO zpt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Leꞌa bego ndenoka ley ten Dios ta msaꞌa be angel, ná lá nxobgek bega ndoꞌ ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Leꞌa gor na mbiꞌín bexa ta li ndab Xteb wa, cha uzheꞌeb ngokloo bexa, gast ndaw bexa ndeay bexa. ");
INSERT INTO zpt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ná leꞌa Xteb uzheꞌeb ncho juers ten Espíritu ten Dios ladoꞌo na, mwiꞌi xa gibeꞌa cha uniꞌí xa xeꞌa chul ten Dios. No uniꞌí xa Jesús nsob lad gaꞌal wats Dios. ");
INSERT INTO zpt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Cha ndab Xteb: —¡Bwiꞌi bego! Leꞌa gibeꞌa baꞌ nsaꞌnyaꞌal. Leꞌa Xin Dios, Xa Myak Men Ndoꞌ Gizhliyo nsob wats Dios lad gaꞌal. ");
INSERT INTO zpt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Weꞌe leꞌa bexa mtsaw nchaꞌ na yaꞌa bexa, no nbezhat bexa. Cha uxax usen bexa Xteb. ");
INSERT INTO zpt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Cha mbiꞌi bexa Xteb dub lad toꞌo gezh, cha mlaꞌgeꞌ bexa Xteb. Leꞌa bexa na mbin ta wa mchaꞌan xab koꞌol na sa nsoꞌ dub xabgiꞌi ben nsaleaꞌ Saulo. ");
INSERT INTO zpt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ndalen nlaꞌgeꞌ bexa Xteb, leꞌa Xteb cha ndab ndoꞌ Dios: —Jesús Xa Nibeꞌe, bsen ga gealnaban ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Cha msaxib xa, cha ugeꞌ ndab xa: —Tad, lá gun ten ga ta ugap ndun bexa ndee. Leꞌa gor na mtayab xa ta wa, cha ngut xa. ");
INSERT INTO zpt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Leꞌa Saulo wa mbinbeꞌe gol ndi wen mbit bexa Xteb. Leꞌa wizh weꞌe leꞌa be men usaxan uzhebpa xela ndanno be xmen Jesús gezh Jerusalén. Leꞌa bexa wa cha mteꞌachso idub Judea no Samaria, ná leꞌa be apostol naꞌanpa uxoꞌon Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Leꞌa pla be men utsin nak mkaꞌach Xteb wa, no uzheꞌeb ndoꞌonno bexa wa Xteb. ");
INSERT INTO zpt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Weꞌe leꞌa Saulo usaxan ndaꞌwiꞌi ta lid kadga dub be xmen Jesús. Cha udobxazh xa bexa, guniꞌi tal xabgiꞌi natal xagots, cha mkeꞌa xa bexa litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Leꞌa bexa li utoꞌo Jerusalén wa mbidiꞌizh diꞌizh wen ten Dios itea sa ndesea bexa. ");
INSERT INTO zpt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Leꞌa Julip nchaꞌa gezh Samaria, cha usaxan ndadiꞌizh xa ndoꞌ be men leꞌa Jesús nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Leꞌa gor na mbiꞌín be men ta ndadiꞌizh Julip, no uniꞌí bexa be uyon ten Dios mbin Julip, cha uzhebpa mlaꞌach bexa xtaꞌan ndadiꞌizh Julip. ");
INSERT INTO zpt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Leꞌa Julip myunyakna kwaꞌad bexa nsak gizhtont ncho mbi bxin len ladoꞌo na. Leꞌa gor na ntoꞌo be mbi bxin wa, leꞌa mbi bxin ugeꞌ nbezhat. Nsea myakna kwaꞌad bexa lá yoo gan isea, no kwaꞌadga bexa coj. ");
INSERT INTO zpt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Cha uzhebpa mten ladna itea be men gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Leꞌa gezh wa ncho dub xabgiꞌi nsaleaꞌ Simón, dub xa ndun ta bruj. Leꞌa xa wa nkwiꞌinno kwaꞌad be men Samaria, ndab xa leꞌa xa uzheꞌeb dub xa nsak. ");
INSERT INTO zpt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Leꞌa itea bexa ben no bexa gox wa nlaꞌach xtaꞌan ndadiꞌizh Simón, ndab bexa leꞌa Simón wa uzhebpa ndap juers ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Uzhebpa nlaꞌach bexa ta ndab xa, geal leꞌa xa kwen mkwiꞌinno be men no ta bruj ndun xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ná leꞌa gor na mbingea ladna bexa diꞌizh wen ten Dios, ta mbidiꞌizh Julip ná xteꞌe nibeꞌe Dios be men no ton nak Jesucristo, weꞌe cha utaleaꞌ bexa, be xabgiꞌi no be xagots. ");
INSERT INTO zpt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Weꞌe no Simón mbingea ladna Jesús cha utaleaꞌ xa. Cha no xa usaxan nkeseano Julip, ndanseana xa be uyon ndun Julip. ");
INSERT INTO zpt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Leꞌa gor na mbiꞌín be apostol ndencho Jerusalén wa leꞌa bexa Samaria no mbingea ladna diꞌizh ten Dios, cha mtuꞌub bexa Pedr no Juan sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Leꞌa gor ulayaꞌ bexa wa Samaria, cha unab bexa ndoꞌ Dios yoo Espíritu ten Dios len ladoꞌo bexa na li ndangea ladna Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Leꞌa zha wa leꞌa Espíritu ten Dios bi naꞌan yoo len ladoꞌo bexa wa, nabtsa utaleaꞌ bexa ta na ndangea ladna bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Weꞌe leꞌa Pedr no Juan mxoꞌob yaꞌa na gek bexa, cha uyoꞌo Espíritu ten Dios len ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Leꞌa gor na uniꞌí Simón leꞌa Espíritu ten Dios ulen gor na nxoꞌob Pedr no Juan yaꞌa na gek be men, cha msaꞌab xa med ndoꞌ bexa wa, ");
INSERT INTO zpt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ndab xa ndoꞌ bexa: —No ndoꞌ naꞌ bsaꞌa bega juers baꞌ, ndontsa guniꞌi ton uxoꞌob naꞌ yaꞌa naꞌ gek na, cha yoo Espíritu ten Dios len ladoꞌo xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Leꞌa Pedr ukaꞌab ndab: —¡Leꞌa xmed lu junt initndoꞌ no lu! ¿Xteꞌe ndanbeꞌe lu zha leꞌa ta nsaꞌa Dios dub ta isiꞌi lu zha? ");
INSERT INTO zpt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Naꞌanpa no lu gun tiꞌin ndun besa ndee, leꞌa len ladoꞌo lu naꞌanpa gaꞌal nak ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Blaꞌa be ta ugap nak lu, cha unab ndoꞌ Dios naga sungeꞌ ladna Dios be ta ugap ndanbeꞌe lu baꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Leꞌa naꞌ uní leꞌa ladoꞌo lu uzhebpa ugap nak, leꞌa ta ugap wa leꞌa nibeꞌe lu. ");
INSERT INTO zpt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Cha ukaꞌab Simón ndab: —Unab bega ndoꞌ Dios, ndontsa lá itiꞌid naꞌ ta li ndab bega wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Weꞌe leꞌa Pedr no Juan mbidiꞌizh diꞌizh ten Dios ndoꞌ be men gezh wa, mbidiꞌizh bexa ton nak Jesús. Cha utoꞌo bexa nseaꞌbe bexa Jerusalén. Leꞌa nes wa mbidiꞌizh bexa diꞌizh wen ten Dios ndoꞌ be men sian be gezh ten Samaria wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ngol dub wizh leꞌa dub angel ten Dios ndab ndoꞌ Julip: —Utoꞌo sa ndee, cha waꞌ lad sur nes nchaꞌa Gaza, nes ntid geꞌe sa bid. ");
INSERT INTO zpt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Weꞌe leꞌa Julip ngwasoꞌ, cha nchaꞌa xa. Leꞌa nes wa uniꞌí Julip dub xa nacion Etiopía. Leꞌa xa wa dub xabgiꞌi nsak nchansu be ta uyap ten Candace, xagots nibeꞌe Etiopía. Leꞌa xabgiꞌi wa ngwaꞌ Jerusalén ndontsa yankea xa Dios sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nes nseaꞌ xa lazh xa wa nsob xa ndoꞌ carret ten xa, ndoꞌol xa libr mkeꞌa profet Isaías. ");
INSERT INTO zpt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Leꞌa Espíritu ten Dios ndab ndoꞌ Julip: —Waꞌ, cha ubii wats carret baꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Leꞌa gor ulayaꞌ Julip sa wa, leꞌa Julip mbiꞌín leꞌa xa Etiopía wa nsobyoꞌol libr mkeꞌa Isaías. Cha unabdiꞌizh Julip ndoꞌ xa: —¿Nyakbeꞌena go ta nsobyoꞌol go baꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Leꞌa xa ukaꞌab ndab: —¿Xteꞌe yakbeꞌena naꞌ‑yá, ná na naꞌan ton gudiꞌizh‑a ndoꞌ naꞌ? Cha ndab xa ikea Julip ndoꞌ carret wa, cha isob xa wats xa. ");
INSERT INTO zpt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Leꞌa ta nsobyoꞌol xa wa lndeꞌe ndab: Mbiꞌi bexa xa cuent dub borreg nchaꞌa sa gat na. No cuent dub borreg ni lá nbezhat sa nchizh xa gich las ma, li naꞌan xteꞌe ngab xa. ");
INSERT INTO zpt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xela mbinno be men xa, ná naꞌan ton isoꞌ wats xa. Naꞌan ton gudiꞌizh cuent ten be xin xa, leꞌa xa naꞌanpa kwen uyoꞌo ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Weꞌe leꞌa xa Etiopía wa unabdiꞌizh ndoꞌ Julip ndab: —Gud ga, ¿ná ton ten cuent ndab profet ndee? ¿Ta ten leꞌaka xa, nate ta ten stubga xa? ");
INSERT INTO zpt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Weꞌe leꞌa Julip cha usaxan ndadiꞌizh xteꞌe nak sa li nsobyoꞌol xa wa, cha no diꞌizh wen ten Jesús mbidiꞌizh xa. ");
INSERT INTO zpt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ndalen li nchaꞌbesea bexa wa, ngol bexa dub sa ncho nits. Leꞌa xa Etiopía ndab: —Sa ndee ncho nits. ¿Lid syoꞌo gan italeaꞌ naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Leꞌa Julip ukaꞌab ndab: —Tal leꞌa go ndangea ladna Jesús idub ncho ladna ga leꞌa‑yá syoꞌoka gan. Leꞌa xabgiꞌi wa ndab: —Naꞌ ndangeaka ladna leꞌa Jesucristo wa Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Weꞌe cha unibeꞌe xa yaꞌibe carret wa. Cha ulaꞌyoꞌo itop bexa len nits. Cha ulaleaꞌ Julip xa. ");
INSERT INTO zpt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Leꞌa gor na utoꞌo bexa len nits, leꞌa Espíritu ten Dios cha mbiꞌi Julip. Leꞌa xa Etiopía wa yá lá iniꞌíta Julip, parea uzhebpa nten ladna xa mbin xa sig nes nseaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Zha leꞌaka Julip nsoꞌla gast gezh Azoto. Cha nchaꞌyadiꞌizh xa diꞌizh wen ten Jesús ndoꞌ be men itea be gezh nchaꞌtid xa, gast ulayaꞌ xa Cesarea. ");
INSERT INTO zpt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Leꞌa xa nsaleaꞌ Saulo wa bi nkwaꞌankata mod xteꞌe gut xa be xmen Jesús. Cha nchaꞌa xa ndoꞌ uleꞌay ndon leꞌa nsak, ");
INSERT INTO zpt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","unab xa dub git goꞌo xa ndoꞌ bexa gezh Damasco, bexa nchansu be niꞌi sa nzhealbe bexa judio. Weꞌe isen xa be xmen Jesús, cha goꞌo xa bexa wa gast litgiꞌib nde Jerusalén, guniꞌi tal xabgiꞌi natal xagots. ");
INSERT INTO zpt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ná gor na yá gax gezh Damasco wa nchaꞌa Saulo, zha leꞌa dub xeꞌa siꞌil utoꞌo gibeꞌa msula idub gangeak wats Saulo. ");
INSERT INTO zpt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Leꞌa xa cha ulayat ndoꞌ yo, cha mbiꞌín xa ti dub men ndab: —Saulo, Saulo, ¿xtaꞌan lbaꞌata ugap ndanno lu naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Leꞌa Saulo unabdiꞌizh ndab: —¿Ton go zha, Señor? Leꞌa xa wa cha ndab: —Leꞌa naꞌ nak Jesús, xa na li ndaklono lu baꞌ. Leꞌa lu ntsaksi leꞌaka leꞌa lu cuent dub ngon nkeꞌa patad ndoꞌ bar ncheb xa ma. ");
INSERT INTO zpt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Leꞌa Saulo nxis tant nzheb, cha ndab xa: —¿Señor, xtaꞌan nlad ga gun naꞌ zhaga? Leꞌa Jesús cha ndab: —Goste, cha waꞌ len gezh baꞌ, cha gab bexa ná xtaꞌan nsabndoꞌ gun lu. ");
INSERT INTO zpt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Leꞌa bexa nchaꞌano Saulo wa uzhebpa ngwatenaꞌ, ta na mbiꞌín bexa ti men wa, ná bexa naꞌan ton iniꞌí. ");
INSERT INTO zpt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Leꞌa Saulo cha ngwaste, parea leꞌa gor na ndiꞌizh iwiꞌi xa, leꞌa xa yá lá naꞌta. Leꞌa bexa nchaꞌano Saulo cha usenla yaꞌa Saulo, mbiꞌi bexa wa xa Damasco. ");
INSERT INTO zpt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Leꞌa sa wa uyoꞌo xa chon wizh ni lá yoo gan iwiꞌi xa, no ni lá ngaw xa, ni nits lá ngo xa. ");
INSERT INTO zpt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Leꞌa Damasco wa ncho dub xmen Jesús nsaleaꞌ Ananías. Leꞌa xa cuent dub ta mcheꞌatsa ladna mbiꞌín xa ti Jesús ndab: —¡Ananías! Leꞌa xa ukaꞌab ndab: —Ndee naꞌ, Señor. ");
INSERT INTO zpt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Leꞌa Jesús cha ndab ndoꞌ xa: —Gosoꞌ, cha waꞌ Nes Gaꞌal, ilayaꞌ lu ta lid Judas. Cha unabdiꞌizh ná ma dub xa nsaleaꞌ Saulo xa gezh Tarso, leꞌa xa wa nsobníꞌi ndoꞌ naꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Leꞌa Saulo cuent dub ta mcheꞌa ladna uniꞌí leꞌa dub xabgiꞌi nsaleaꞌ Ananías ilen uxoꞌob yaꞌa na gek Saulo ndontsa inaꞌ Saulo. ");
INSERT INTO zpt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Leꞌa Ananías cha ukaꞌab ndab: —Tad, leꞌa kwaꞌad be men ndadiꞌizh cuent ten xabgiꞌi wa, plota ta ugap ndanno xa be xmen go Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ná nat leꞌa xa ulansea sa ndee no permis ten be uleꞌay nibeꞌe, ndontsa goꞌo xa itea bexa na ngeꞌ ladna go. ");
INSERT INTO zpt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ná leꞌa Jesús ndab: —¡Waꞌ! Leꞌa naꞌ mti xa wa gun tiꞌin ten naꞌ. Gudiꞌizh xa diꞌizh ten naꞌ ndoꞌ be men naꞌanpa xa Israel no ndoꞌ bexa nibeꞌe ten bexa wa, nsea ndoꞌ bexa Israel. ");
INSERT INTO zpt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Leꞌa naꞌ uluu ndoꞌ xa xteꞌe kweaꞌ itid xa ta na gun xa tiꞌin ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Leꞌa Ananías cha nchaꞌa sa wa, cha mxoꞌob xa yaꞌa xa gek Saulo, ndab xa: —Saulo, go nak xmen Jesucristo, leꞌa Jesús xa na li mlundoꞌ ndoꞌ go nes nsea ga wa, leꞌa xa wa mtuꞌub naꞌ sa ndee, ndontsa inaꞌgal go, no yoo Espíritu ten Dios len ladoꞌo ga. ");
INSERT INTO zpt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bi leꞌa gor wa ulate be ta ntsaw ngusndoꞌ Saulo, cha mnaꞌgal xa. Weꞌe ngwasoꞌ xa, cha utaleaꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tsoꞌo wa udaw xa, cha myoꞌo juers xa. Leꞌa xa wa cha uyoꞌo sa wa stapla wizh wats be xmen Jesús ndencho Damasco wa. ");
INSERT INTO zpt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Weꞌe usaxan Saulo ndadiꞌizh ndoꞌ be men len be niꞌi sa nzhealbe bexa judio, ndab xa leꞌa Jesús nak Xin Dios. ");
INSERT INTO zpt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Itea bexa na mbiꞌín ta wa cha ngwanseana, ndab bexa: —¿Lid leꞌa xa ndee xa li nlad gut bexa na ndangea ladna Jesús gezh Jerusalén wa zha? ¿No xa leꞌakaga ulen gezh ndee nseasen xa bexa wa, cha yak cuent bexa ndoꞌ yaꞌa be uleꞌay nibeꞌe zha? ");
INSERT INTO zpt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ná leꞌa Saulo kad wizh mas juert ndadiꞌizh diꞌizh ten Dios, mluu xa leꞌa Jesús nak Cristo, xa mtuꞌub Dios. Leꞌa bexa judio ndencho Damasco uzheꞌeb ngwanseana gor na mbiꞌín bexa ta mbidiꞌizh Saulo wa. ");
INSERT INTO zpt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ngok kwenlapa leꞌa ncho bexa judio dubtsa mbidiꞌizh gut Saulo. ");
INSERT INTO zpt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Teꞌal tezhea nlaꞌach bexa be toꞌo puert ten gezh wa, ndontsa gut bexa Saulo gor itoꞌo Saulo, ná leꞌa Saulo mbiꞌín ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Weꞌe leꞌa ngol gor ulaꞌ teꞌal leꞌa be xmen Saulo cha ulo Saulo len dub zhum, cha mlaꞌ bexa xa toꞌo muro nchonyaw gezh wa, cha mxoꞌon xa. ");
INSERT INTO zpt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Leꞌa gor ulayaꞌ Saulo Jerusalén, nlad xa uchealtsaꞌa xa be xmen Jesús. Ná leꞌa itea bexa wa nzheb ndoꞌ Saulo, lá ndangea ladna bexa ti no Saulo nak xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Weꞌe leꞌa Bernabé ngokno Saulo, mbiꞌi xa Saulo ndoꞌ be apostol. Cha mbidiꞌizh xa xteꞌe uniꞌí Saulo Jesús nes nchaꞌa Damasco, no xteꞌe ndab Jesús ndoꞌ Saulo. No mbidiꞌizh Bernabé xteꞌe lá izheb Saulo mbidiꞌizh Saulo diꞌizh ten Jesús ndoꞌ be men Damasco wa. ");
INSERT INTO zpt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Cha li myaꞌan Saulo wats bexa, ukeseano Saulo bexa wa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","No ndadiꞌizh Saulo diꞌizh ten Jesús ndoꞌ gaꞌal be men. Mbidiꞌizhno xa bexa judio, bexa ndadiꞌizh diꞌizh griego, no uteyotoꞌono xa bexa. Ná leꞌa bexa wa nlad gut Saulo. ");
INSERT INTO zpt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Leꞌa gor na mbiꞌín be xmen Jesús ta wa, cha mbiꞌi bexa Saulo gezh Cesarea. Ngol sa wa cha mtuꞌub bexa Saulo gezh Tarso. ");
INSERT INTO zpt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Weꞌe leꞌa itea be xmen Jesús ncho Judea no Galilea no Samaria naꞌantapa kweaꞌ ndenchobe. No mas ngeꞌ ladna bexa Dios, no ndun bexa sbeꞌen ta nsak ladna Dios, no mas nsayak kwaꞌad bexa lak nsaꞌa Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Leꞌa Pedr nkesea inaꞌ itea be xmen Jesús, cha ngol dub wizh ngwaꞌinaꞌ xa no bexa ncho gezh Lida. ");
INSERT INTO zpt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Cha mzheꞌal xa dub xabgiꞌi nsaleaꞌ Eneas. Leꞌa xa wa dub xoꞌonla liꞌin lá yoo gan isea, sbeꞌen ndoꞌ loꞌon nax xa. ");
INSERT INTO zpt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Leꞌa Pedr cha ndab ndoꞌ xa: —Eneas, Jesucristo myunyakna lu. Nat goste, cha bsaxkwaꞌa loꞌon ten lu. Cha bi leꞌa gor wa leꞌa Eneas ngwaste. ");
INSERT INTO zpt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Leꞌa itea be men ncho gezh Lida no gezh Sarón wa uniꞌí xteꞌe myakna xa gizh wa, cha no bexa mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Leꞌa gezh Jope uyoꞌo dub xagots nsaleaꞌ Tabita, xa no nak xmen Jesús. Leꞌa diꞌizh griego leꞌa xa nsaleaꞌ Dorcas. Leꞌa xa wa ndun sian be ta wen no ndakno xa bexa uban nak. ");
INSERT INTO zpt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Leꞌa dub wizh leꞌa Dorcas ulen gizh, cha ngut xa. Leꞌa be xagots cha mgas xa ngut wa, cha uxoꞌob xa wa len dub cuart nde gaꞌap. ");
INSERT INTO zpt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Leꞌa Jope nde gax gezh Lida. Ta weꞌe leꞌa gor na mbiꞌín be xmen Jesús ndencho gezh Jope leꞌa Pedr nkesea Lida, cha mtuꞌub bexa top xabgiꞌi yaꞌyab ndoꞌ Pedr uxax giꞌid xa Jope. ");
INSERT INTO zpt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Leꞌa Pedr cha utoꞌo nchaꞌano bexa wa. Leꞌa gor na ulayaꞌ bexa ta niꞌi wa, cha mbiꞌi bexa Pedr len cuart gaꞌap, sa nax xa ngut wa. Leꞌa kwaꞌad be xagots nab ngut xabgiꞌi ten na myaklo wats Pedr, ndoꞌonno bexa xa ngut wa. Nluu bexa be lad mbindeꞌe xa zha na nban xa ndoꞌ Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Weꞌe leꞌa Pedr ndab itate itea bexa ndencho len cuart wa. Cha msaxib Pedr, ndadiꞌizhno Pedr Dios. Cha mwiꞌi xa ndoꞌ xa ngut wa, cha ndab xa: —Tabita, ¡goste! Leꞌa xagots wa cha mwiꞌi, cha uniꞌí xa Pedr, cha ngwasob xa. ");
INSERT INTO zpt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Leꞌa Pedr cha usen yaꞌa xa uxisoꞌ xa. Cha utezh Pedr be xagots no iteata be xmen Jesús wa. Cha myun Pedr cuent xa nbanla xa. ");
INSERT INTO zpt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Leꞌa ta li ngok wa mgen idub gezh Jope, cha kwaꞌadta bexa mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Leꞌa Pedr cha ngwaꞌyoꞌo dub ndeꞌep Jope, ta lid dub xa nsaleaꞌ Simón, xa nkuꞌud gid man. ");
INSERT INTO zpt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Leꞌa gezh Cesarea uyoꞌo dub xabgiꞌi nsaleaꞌ Cornel, dub soldad nibeꞌe dub gayoꞌo be soldad, bexa ten partid nsaleaꞌ Italiano. ");
INSERT INTO zpt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Leꞌa xa wa no itea bexa ncho ta lid xa ndankea Dios, no nxobgek bexa ndoꞌ Dios. No ndakno xa be men, bexa uban nak; no ndadiꞌizhno tseꞌe xa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Leꞌa dub wizh pa gor nkea uyon gor uzhe, cuent dub ta mcheꞌa ladna xa uniꞌí xa dub angel ten Dios ulayaꞌ sa nsob xa. Cha ndab angel: —¡Cornel! ");
INSERT INTO zpt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Leꞌa Cornel cha mwiꞌi ndoꞌ angel wa, no uzhebpa mzheb xa unabdiꞌizh xa: —¿Xtaꞌan nlad go? Leꞌa angel wa ndab: —Leꞌa Dios ndoꞌón ta ndab lu ndoꞌ xa, no naꞌ xa ta ndakno lu be men uban nak. ");
INSERT INTO zpt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nat btuꞌub pla be men yaꞌbe gezh Jope yaꞌtezh bexa xa nsaleaꞌ Simón, xa no nsaleaꞌga Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Leꞌa xa wa ncho ta lid stubga xa nsaleaꞌ Simón, xa nkuꞌud gid man, xa ncho gax toꞌo nitsdoꞌo wa. Leꞌa Pedr wa gab ná xtaꞌan nsabndoꞌ gun lu. ");
INSERT INTO zpt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Leꞌa gor na unitndoꞌ angel ndoꞌ Cornel, leꞌa Cornel cha utezh top mos ten na nsea dub soldad ndankea Dios, dub xa ndun tiꞌin ndoꞌ Cornel. ");
INSERT INTO zpt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cha mbidiꞌizh xa itea be ta uniꞌí xa wa, cha mtuꞌub xa bexa wa Jope. ");
INSERT INTO zpt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ngol stubtsa wizh gor nsalayaꞌ gax bexa wa Jope, pa gor gawizh leꞌa Pedr ukea gek niꞌi, nchaꞌyadiꞌizhno xa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ngol gor uzhebpa ndanna xa, nlad xa gaw xa. Ná leꞌa ndalen ndeyundeꞌe bexa ta gaw xa, weꞌe uniꞌí xa cuent dub ta mcheꞌa ladna xa. ");
INSERT INTO zpt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Uniꞌí xa leꞌa gibeꞌa myaꞌal, cha dub ta cuent dub bleꞌa lad siꞌil nchii idap skin‑a nchaꞌlaꞌ ndoꞌ yo. ");
INSERT INTO zpt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Leꞌa ndoꞌ lad wa ndiꞌib isandoꞌ be man ndap dap xoꞌo na nsea be wach no be man duꞌub. ");
INSERT INTO zpt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Cha mbiꞌín xa ti Dios ndab: —Pedr, gosoꞌ. Bit dub man cha udaw ma. ");
INSERT INTO zpt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ná leꞌa Pedr ukaꞌab ndab: —Naꞌan, Señor. Naꞌ nunk gol gaw dub ta bzhiꞌik, dub ta lá nsabndoꞌ gaw be men judio. ");
INSERT INTO zpt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ná leꞌa ti Dios wa ulengal ndab: —Leꞌa be ta ndáp naꞌ leꞌa‑yá ta umbiꞌi, lá gab lu ndoꞌ‑yá ta bzhiꞌik. ");
INSERT INTO zpt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chon biaj li uníꞌi Dios ndoꞌ Pedr. Weꞌe leꞌa lad wa cha mkea leꞌakagal gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Leꞌa Pedr cha uzheꞌeb ndanbeꞌe ná xtaꞌan gab ta li uniꞌí xa wa. Ndalen wa ulayaꞌ be men li mtuꞌub Cornel nchaꞌkwaꞌan Pedr ta lid Simón wa. ");
INSERT INTO zpt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cha unabdiꞌizh bexa naga lid sa weꞌe nbeas Simón, xa no nsaleaꞌ Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ndalen li nsobyunbeꞌe Pedr ta li uniꞌí xa wa, leꞌa Espíritu ten Dios ndab: —Unaꞌ, leꞌa chon xabgiꞌi nseakwaꞌan lu. ");
INSERT INTO zpt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gosoꞌ, cha ulaꞌ, cha waꞌno bexa wa. Lá gunbeꞌe lu ti ton xa wa, leꞌa bexa wa naꞌ mtuꞌub. ");
INSERT INTO zpt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Cha ulaꞌ Pedr sa nde bexa mtuꞌub Cornel wa, cha ndab xa ndoꞌ bexa: —Leꞌa naꞌ ndee Pedr, xa li nkwaꞌan bega wa. ¿Xtaꞌan gunno bego naꞌ? ");
INSERT INTO zpt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Leꞌa bexa ukaꞌab ndab: —Leꞌa dub soldad nibeꞌe nsaleaꞌ Cornel mtuꞌub besa. Leꞌa xa wa dub xa wen nak no nxobgek xa ndoꞌ Dios no utsin nak xa ndoꞌ bexa judio. Leꞌa dub angel ten Dios ndab ndoꞌ Cornel kwezh xa go, giꞌid go ta lid xa, ndontsa goꞌón xa xtaꞌan gab ga. ");
INSERT INTO zpt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Weꞌe leꞌa Pedr cha ndab ndoꞌ bexa yoo bexa len niꞌi. Cha sa weꞌe ngot bexa teꞌal wa. Ngot xeꞌa cha nchaꞌano bexa wa Pedr no stapla be xmen Jesús ncho Jope wa. ");
INSERT INTO zpt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ngol stubtsa wizh leꞌa bexa ulayaꞌ Cesarea. Leꞌa Cornel utezhla be ltsaꞌa xa nsea be amig ten xa. Leꞌa bexa wa ndenkeaꞌ ná xá gor ilayaꞌ Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Leꞌa gor ulayaꞌ xa wa, leꞌa Cornel utoꞌo usaxib ndoꞌ Pedr, ngwankea xa Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ná leꞌa Pedr cha uxisoꞌ xa ndab xa: —Gosoꞌ ga. Leꞌa naꞌ ndee dub men cuentkaga go. ");
INSERT INTO zpt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ndalen ndeyadiꞌizh bexa cha li uyoꞌo bexa len niꞌi wa. Cha uniꞌí Pedr ndebe kwaꞌad be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Cha ndab Pedr ndoꞌ bexa: —Leꞌa bego uniꞌíka leꞌa ley ten besa judio nibeꞌe lá uchealtsaꞌa besa dub xa naꞌanpa xa judio, no ni lá yoo besa len lid dub xa wa. Ná leꞌa Dios mluu ndoꞌ naꞌ leꞌa naꞌ lá nsabndoꞌ gáp leꞌa dub men xa bzhiꞌik. ");
INSERT INTO zpt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ta weꞌe gor utezh bega naꞌ, cha uxax ndal naꞌ ni naꞌan xteꞌe ngáp naꞌ. Nat nabdiꞌizh naꞌ ndoꞌ bega, ¿xtaꞌan utezh bega naꞌ? ");
INSERT INTO zpt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Weꞌe leꞌa Cornel ukaꞌab ndab: —Leꞌa nchaꞌala mdap wizh, pa gor nkea uyon uzhe gol gaw naꞌ, ndi nsobyadiꞌizh naꞌ ndoꞌ Dios sa ndee. Cha mlundoꞌ dub xabgiꞌi ndoꞌ naꞌ, nak xa dub lad ndon nlaꞌbealꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Cha ndab xa ndoꞌ naꞌ: “Cornel, leꞌa Dios ndoꞌón ta ndab lu ndoꞌ xa no naꞌ xa ta ndakno lu be men uban nak. ");
INSERT INTO zpt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nat btuꞌub ton yaꞌ gezh Jope yaꞌtezh xa Simón xa noga nsaleaꞌ Pedr. Leꞌa xa wa ncho ta lid stubga xa nsaleaꞌ Simón xa nkuꞌud gid, ncho gax toꞌo nitsdoꞌo. Leꞌa gor ilanseaꞌ Pedr ta lid lu, gudiꞌizh xa ndoꞌ lu.” ");
INSERT INTO zpt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Weꞌe leꞌa naꞌ uxax mtuꞌub bexa mbidkwaꞌan go. Nat nten ladna besa cha nseaka go. Nat leꞌa besa nde sa ndee ndoꞌ Dios, ndontsa goꞌón besa itea ta unibeꞌe Dios gab go ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Weꞌe leꞌa Pedr usaxan ndadiꞌizhla ndab: —Nat myakbeꞌena naꞌ leꞌa Dios lá nti ni dub men. ");
INSERT INTO zpt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Guniꞌi pa nacion leꞌa Dios nsak ladna lak nak bexa nxobgek ndoꞌ Dios no ndun bexa ta wen. ");
INSERT INTO zpt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Leꞌa Dios uníꞌi ndoꞌ besa xa Israel, mbidiꞌizh xa diꞌizh wen ná xteꞌe wen yaꞌan be men ndoꞌ xa juers ten ta mbin Jesucristo, Xa Nibeꞌe itea be men. ");
INSERT INTO zpt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Leꞌa bego uniꞌíka xteꞌe nak ta uyoꞌo idub Judea, ta usaxan distrit Galilea, tsoꞌo na mbidiꞌizh Juan leꞌa be men nsabndoꞌ italeaꞌbe. ");
INSERT INTO zpt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Uniꞌí bega xteꞌe msaꞌa Dios juers no Espíritu ten na ndoꞌ Jesús xa gezh Nazaret. Weꞌe leꞌa Jesús ukeseayun be ta wen no myunyakna xa itea bexa ntsaksi maxuꞌu, geal leꞌa Dios ndakno xa. ");
INSERT INTO zpt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","’Leꞌa besa no uniꞌí itea ta mbin Jesús idub Judea no gast gezh Jerusalén, sa na mbit be men xa, mkeꞌa be men xa ndoꞌ cruz. ");
INSERT INTO zpt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ná leꞌa Dios ngol wizh yon mxiste Jesús ndoꞌ gealgut. Cha mbin Dios mlundoꞌ Jesús ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Leꞌa Jesús wa naꞌanpa ulundoꞌ ndoꞌ itea be men, nabtsa ndoꞌ besa xa na mtila Dios mlundoꞌ xa. Leꞌa tsoꞌo na uban xa wa, leꞌa besa udawno xa no nguno besa xa. ");
INSERT INTO zpt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Leꞌa Dios cha unibeꞌe gudiꞌizh besa ndoꞌ be men, gab besa leꞌa Dios leꞌa ulaxoꞌob Jesús gab Jesús ná ton ndap ke, bexa nban no bexa ngut. ");
INSERT INTO zpt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Leꞌa itea be profet yá mbidiꞌizhka cuent ten Jesús, ndab bexa leꞌa tal ton igeꞌ ladna xa, leꞌa Dios stsuꞌu be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ndalen li nsoꞌyadiꞌizh Pedr ta wa, leꞌa Espíritu ten Dios cha uyoꞌo len ladoꞌo itea bexa li ndeyoꞌón ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Leꞌa bexa judio na li ulenno Pedr wa ngwanseanabe ta na li msaꞌa Dios Espíritu ten na no ndoꞌ bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ndoꞌón bexa leꞌa bexa nde sa wa usaxan ndadiꞌizh isandoꞌ diꞌizh, ndab bexa leꞌa Dios uzheꞌeb dub xa juert nak. ");
INSERT INTO zpt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Weꞌe leꞌa Pedr cha ndab ndoꞌ bexa judio wa: —Leꞌa bexa ndee usen Espíritu ten Dios lakkaga beuna ndee, ta weꞌe lá nsabndoꞌ uka beuna italeaꞌ bexa len nits. ");
INSERT INTO zpt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Cha ndab Pedr italeaꞌ bexa ta na nak bexa xmen Jesucristo. Weꞌe leꞌa bexa wa cha unab ndoꞌ Pedr yoo Pedr sa wa stapla wizh. ");
INSERT INTO zpt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Leꞌa be apostol nsea iteata be xmen Jesús ndencho Judea mbiꞌín leꞌa bexa naꞌanpa xa judio no mbingea ladna diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ná leꞌa zha na nseaꞌ Pedr Jerusalén, leꞌa ncho bexa judio cha uteyo Pedr, ");
INSERT INTO zpt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ndab bexa: —¿Xtaꞌan uyoꞌo lu len lid bexa naꞌanpa xa judio, no udawno lu bexa? ");
INSERT INTO zpt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Leꞌa Pedr cha mbidiꞌizh be ta utid wa, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Leꞌa dub wizh zha na uyoꞌo naꞌ gezh Jope, ndalen nsobyadiꞌizhno naꞌ Dios, cuent ta mcheꞌa lad naꞌ uní naꞌ dub ta cuent dub bleꞌa lad siꞌil nchii idap skin‑a. Leꞌa ta wa utoꞌo gibeꞌa nchaꞌlaꞌ‑yá sa nsoꞌob naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cha mwiꞌi naꞌ ná xtaꞌan ta ndiꞌib ndoꞌ‑yá, cha uní naꞌ be man ndap dap xoꞌo na, no be man gix, no be wach no be man duꞌub. ");
INSERT INTO zpt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Weꞌe mbín naꞌ ti Dios ndab: “Pedr, gosoꞌ. Bit be man ndee, cha udaw ma.” ");
INSERT INTO zpt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Leꞌa naꞌ ndáp: “Naꞌan, Señor. Naꞌ nunk gol gaw dub ta bzhiꞌik, dub ta lá nsabndoꞌ gaw be men.” ");
INSERT INTO zpt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Weꞌe leꞌa ti Dios ta ntoꞌo gibeꞌa baꞌ wa cha ndabgal: “Leꞌa be ta ndáp naꞌ leꞌa‑yá ta umbiꞌi, lá gab lu ndoꞌ‑yá ta bzhiꞌik.” ");
INSERT INTO zpt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Leꞌa ti Dios chon biaj li ndab ndoꞌ naꞌ. Weꞌe cha mkeagal lad wa gibeꞌa. ");
INSERT INTO zpt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","’Bi leꞌa gor wa leꞌa chon xabgiꞌi utoꞌo gezh Cesarea ulansea niꞌi sa nchoꞌo naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Leꞌa Espíritu ten Dios cha ndab ndoꞌ naꞌ gaano naꞌ bexa wa. Cha mbi naꞌ isaxoꞌop bexa no nak xmen Jesús, bexa nde ndee. Cha uyoꞌo besa len lid men wa. ");
INSERT INTO zpt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Leꞌa xa wa mbidiꞌizh leꞌa ta lid xa wa uniꞌí xa dub angel ten Dios nsoꞌma sa wa, cha ndab angel ndoꞌ xa: “Btuꞌub bexa yaꞌtezh dub xa ncho Jope nsaleaꞌ Simón, xa no nsaleaꞌga Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Leꞌa xa wa gab ná xteꞌe gap lu gealnaban no itea bexa ta lid lu.” ");
INSERT INTO zpt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Weꞌe leꞌa gor na usaxan mbidiꞌizh naꞌ ndoꞌ bexa wa, leꞌa Espíritu ten Dios uyoꞌo len ladoꞌo bexa lak uyoꞌo Espíritu ten Dios wa len ladoꞌo beuna zha ned wa. ");
INSERT INTO zpt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Cha mtseꞌa lad naꞌ ta ndab Jesús ndoꞌ beuna: “Ugeaka leꞌa Juan ulaleaꞌ be men len nits, parea leꞌa bega italeaꞌ nsea Espíritu ten Dios.” ");
INSERT INTO zpt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nat leꞌa Dios no ndoꞌ bexa wa msaꞌa ta na msaꞌa xa ndoꞌ beuna ndangea ladna Jesucristo wa. Leꞌa naꞌ naꞌanpa uka ta ndun Dios. ");
INSERT INTO zpt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Leꞌa gor na mbiꞌín bexa ta li ndab Pedr wa, cha xe ute bexa. Cha ndab bexa leꞌa Dios uzheꞌeb dub xa juert nak. No ndab bexa: —Nat uniꞌí beuna leꞌa noka be men naꞌanpa xa judio, tal leꞌa bexa ulaꞌa be ta ugap nak bexa, leꞌa Dios usaꞌaka gealnaban ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Leꞌa tsoꞌo na ngut Xteb, leꞌa be men uzheꞌeb usaxan xela ndanno bexa nak xmen Jesús. Leꞌa ncho bexa wa ngwaꞌuxoꞌon gast distrit Fenicia, nsea isla Chipre, nsea gezh Antioquía. Leꞌa be sa wa mbidiꞌizh bexa diꞌizh ten Jesús ndoꞌ nabtsa bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ná ncho pla bexa utoꞌo Chipre no Cirene, nchaꞌa bexa wa Antioquía, cha usaxan bexa ndadiꞌizh bexa diꞌizh wen ten Jesús wa ndoꞌ bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Leꞌa Dios uzheꞌeb ngokno bexa, cha uzheꞌeb kwaꞌad be men mbingea ladna diꞌizh wa, cha mgeꞌ ladna bexa Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Leꞌa gor na mbiꞌín be xmen Jesús ndencho Jerusalén ta wa, cha mtuꞌub bexa Bernabé gezh Antioquía. ");
INSERT INTO zpt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Gor ulayaꞌ xa sa wa, weꞌe uniꞌí xa xteꞌe wen ndanno Dios bexa wa, cha uzheꞌeb mten ladna xa. Cha mtenxeꞌa xa bexa wa, ndab xa ndoꞌ bexa wa gaꞌaltsa kwe bexa, lá ulaꞌa bexa ta ngeꞌ ladna bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Leꞌa Bernabé wa uzheꞌeb dub xa wen, no ncho juers ten Espíritu ten Dios ladoꞌo xa, no ngeꞌ ladna xa Jesús idub ncho ladna xa. Weꞌe leꞌa uzheꞌeb kwaꞌad men gezh wa mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsoꞌo wa leꞌa Bernabé cha nchaꞌa gezh Tarso nchaꞌkwaꞌan xa Saulo. Leꞌa gor mzheal xa Saulo, cha mbiꞌi xa Saulo Antioquía. ");
INSERT INTO zpt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Cha uyoꞌo bexa pa dub liꞌin lat be xmen Jesús sa wa. No mluu bexa kwaꞌadpa be men wa. Leꞌa Antioquía wa sa na ndon leꞌa ned msaleaꞌ be men bexa na ndangea ladna Jesús wa “xmen Cristo.” ");
INSERT INTO zpt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Leꞌa zha wa ncho pla bexa ndadiꞌizh sakndoꞌ Dios utoꞌo Jerusalén nchaꞌbe Antioquía wa. ");
INSERT INTO zpt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Leꞌa dub xa wa nsaleaꞌ Ágabo. Leꞌa Espíritu ten Dios ndab ndoꞌ xa, gab xa leꞌa idub ndoꞌ gizhliyo yoo dub win siꞌil. Leꞌa win weꞌe uyoꞌo tiemp unibeꞌe Claudio idub sa nibeꞌe Roma. ");
INSERT INTO zpt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ta weꞌe leꞌa be xmen Jesús ndencho Antioquía wa mbidiꞌizh utuꞌub med ndoꞌ be xmen Jesús ndencho Judea, msaꞌa bexa bi lak sian‑a ndap bexa. ");
INSERT INTO zpt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Leꞌa Bernabé no Saulo cha mbiꞌi med wa ndoꞌ bexa nchansu be xmen Jesús ndencho Judea. ");
INSERT INTO zpt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Leꞌa be wizh wa leꞌa Herodes xa nibeꞌe Judea usaxan ntsaksi be xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Unibeꞌe Herodes gat Jacob wit Juan ndoꞌ spad. ");
INSERT INTO zpt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Weꞌe uniꞌí xa leꞌa bexa judio uzheꞌeb msak ladna ta wa, cha unibeꞌegal xa ikea Pedr litgiꞌib. Leꞌa ta wa ngok len ujest Pascua ten bexa judio, zha ndaw bexa pan naꞌan levadur. ");
INSERT INTO zpt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Leꞌa gor usen bexa Pedr, cha mkeꞌa bexa Pedr litgiꞌib. Leꞌa sa wa nlaꞌach dap xkwaꞌa soldad, dap gaꞌga xa kad dub xkwaꞌa bexa wa. Leꞌa Herodes ndanbeꞌe kotsoꞌ Pedr ndoꞌ be men itidtsa ujest Pascua wa. ");
INSERT INTO zpt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ndalen li nkea Pedr litgiꞌib, leꞌa be xmen Jesús uzhebpa unab ndoꞌ Dios gakno Dios Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Leꞌa ngol teꞌal na li gat xeꞌa igoꞌo Herodes Pedr, isoꞌ Pedro ndoꞌ be men wa, leꞌa Pedr naxnchii top caden, naxyats xa tlaw top soldad. Leꞌa stapla bexa wa ndeulaꞌach toꞌo litgiꞌib wa. ");
INSERT INTO zpt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Leꞌa sa wa mlundoꞌ dub angel ten Dios, msu xeꞌa idub len cuart wa. Leꞌa angel wa mkwaꞌan Pedr, utichyaꞌa xa las Pedr, cha ndab xa: —Uxax goste. Bi leꞌa gor wa leꞌa caden nchii yaꞌa Pedr wa yoꞌo ulate. ");
INSERT INTO zpt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Leꞌa angel wa cha ndabgal: —Bte cha len lu no bkeꞌa ndab lu. Cha liga mbin Pedr. Leꞌa angel wa ndabgal: —Ubixyoꞌo lad nbix lu baꞌ, cha usankea tsoꞌo naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Leꞌa Pedr cha usankea tsoꞌo angel, ni lá iniꞌí xa naga ta ugeaka ta li ndun angel wa, ndi nsak xa leꞌa‑yá dub ta ncheꞌa ladna xa. ");
INSERT INTO zpt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ná gor utid Pedr itop sa li ndeulaꞌach soldad wa, cha ulayaꞌ xa sa nak puert giꞌib wa, sa ntoꞌo be men nkea litgiꞌib wa, leꞌa puert wa yoꞌo myaꞌal. Cha utoꞌo angel wa no Pedr. Leꞌa gor na usea bexa dub tuzh sa, leꞌa angel wa cha mlaꞌa nab Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Leꞌa gor mteꞌach wen xkaꞌal Pedr, weꞌe mbinbeꞌe Pedr: —Nat ndon ndeꞌe uní naꞌ leꞌa Dios mtuꞌubka angel wa, no mlat Dios naꞌ ndoꞌ yaꞌa Herodes no ndoꞌ ta na ndiꞌizh gunno bexa judio naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Leꞌa gor na li mbinbeꞌe Pedr wa, cha nchaꞌa xa ta lid Marí, xnaꞌa xa nsaleaꞌ Juan xa no nsaleaꞌ Marc. Leꞌa sa wa kwaꞌad be men nzhealbe, ndeyadiꞌizhno bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Leꞌa gor ulayaꞌ Pedr toꞌo niꞌi wa, cha utezh Pedr bexa. Leꞌa dub xagots ben nsaleaꞌ Rode utoꞌo nchaꞌwiꞌi ná ton ta li nbezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ná gor mgondoꞌ xagots wa leꞌa ta wa ti Pedr, tant nten ladna xa ni lá igen uxaꞌal xa toꞌo niꞌi wa, ndi karrel myaꞌyab xa leꞌa Pedr nsoꞌ toꞌo niꞌi. ");
INSERT INTO zpt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ná leꞌa bexa wa ndab: —Lu ga usak ta wa. Ná leꞌa xagots wa ndab leꞌa ta wa ta ugeaka. Leꞌa bexa wa cha ndab: —Leꞌa ta wa naꞌanpa Pedr, leꞌa ta wa dub angel. ");
INSERT INTO zpt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ndalen wa leꞌa Pedr bi nsoꞌbezhka toꞌo niꞌi wa. Leꞌa gor na mxaꞌal bexa toꞌo niꞌi wa no uniꞌí bexa leꞌa‑yá Pedrka, weꞌe cha uzheꞌeb ngwanseana bexa. ");
INSERT INTO zpt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Leꞌa Pedr cha uxits yaꞌa na ndontsa xe kwe bexa. Cha mbidiꞌizh Pedr ndoꞌ bexa xteꞌe mgoꞌo Dios xa litgiꞌib. Cha ndab xa: —Waꞌyadiꞌizh bega ta ndee ndoꞌ Jacob nsea ndoꞌ iteata be xmen Jesús. Cha ukaꞌan xa sa wa, cha nchaꞌa xa stubga gezh. ");
INSERT INTO zpt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ngot xeꞌa cha uzheꞌeb ndeseyoch be soldad len litgiꞌib, leꞌa bexa lá iniꞌí pa nchaꞌa Pedr. ");
INSERT INTO zpt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Leꞌa Herodes unibeꞌe ukwaꞌan bexa Pedr, ná Pedr yá lá ngaꞌigaꞌata. Cha uzheꞌeb unabdiꞌizh Herodes ndoꞌ bexa nlaꞌach litgiꞌib wa ná xteꞌe mxoꞌon Pedr, cha unibeꞌe xa gat bexa wa. Tsoꞌo wa leꞌa Herodes cha mkaꞌan Judea, nchaꞌa xa yoo xa gezh Cesarea. ");
INSERT INTO zpt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Leꞌa Herodes uzheꞌeb ndakloo ndoꞌ be men ndencho gezh Tiro no Sidón. Parea leꞌa be men itop gezh wa nsiꞌi ta gaw na ndoꞌ Herodes. Ta weꞌe leꞌa bexa wa mkwaꞌan xteꞌe lá gaklonota Herodes bexa. Cha mbidiꞌizhno bexa Blasto dub xmen Herodes, gab Blasto ndoꞌ Herodes leꞌa bexa nlad gudiꞌizhno Herodes. ");
INSERT INTO zpt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Leꞌa Herodes cha msabeꞌe dub wizh gudiꞌizhno xa bexa. Zha ngol wizh wa leꞌa Herodes ngok lad uyap ten na. Cha usob xa sa ndun xa regl be taꞌa. Cha mbidiꞌizh xa ndoꞌ be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Leꞌa bexa wa usaxan ugeꞌ ndab: —¡Leꞌa xa na li ndadiꞌizh wa naꞌanpa dub men, leꞌa xa ndi leꞌa dub dios! ");
INSERT INTO zpt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bi leꞌa gor wa leꞌa dub angel ten Dios mbin usen gizh Herodes, geal leꞌa Herodes naꞌanpa ngab leꞌa bexa wa ndi Diostsa yankea. Weꞌe udaw mgeas Herodes, cha ngut xa. ");
INSERT INTO zpt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Weꞌe leꞌa diꞌizh ten Dios uzheꞌeb nsateꞌachso itea lad no kwaꞌad men nsayungea ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Leꞌa gor na unitsa tiꞌin ngwaꞌ Bernabé no Saulo gezh Jerusalén wa, cha myach bexa nseabe bexa leꞌaka Antioquía. Mbiꞌi bexa no Juan, xa noga nsaleaꞌ Marc. ");
INSERT INTO zpt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Leꞌa lat be xmen Jesús ndencho Antioquía wa ncho bexa ndadiꞌizh sakndoꞌ Dios no bexa nluu diꞌizh ten Dios. Leꞌa bexa wa Bernabé, no Simón xa nsaleaꞌga Nagats, nsea Lucio xa gezh Cirene, nsea Manaén xa junt ngoꞌolno Herodes Antipas, nsea Saulo. ");
INSERT INTO zpt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ngol dub wizh ndalen nzhealbe be xmen Jesús sa wa, nsaꞌa bexa xno ndoꞌ Dios no lá ngaw bexa dub tiemp, leꞌa Espíritu ten Dios ndab ndoꞌ bexa: —Ulaxoꞌob bega Bernabé no Saulo, leꞌa naꞌ mti bexa gun bexa tiꞌin ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Weꞌe leꞌa gor na mtayadiꞌizhno bexa Dios no utidla zha lá ngaw bexa, cha mxoꞌob bexa yaꞌa bexa gek Bernabé no Saulo. Cha mtuꞌub bexa itop xa wa gun bexa tiꞌin ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Leꞌa Espíritu ten Dios ulogek Bernabé no Saulo yaꞌ bexa gezh Seleucia. Leꞌa sa wa cha uyoꞌo bexa len dub barco siꞌil nchaꞌa isla Chipre. ");
INSERT INTO zpt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Gor na ulayaꞌ bexa gezh Salamina ten Chipre, cha usaxan ndadiꞌizh bexa diꞌizh ten Dios len be niꞌi sa nzhealbe bexa judio. Leꞌa Juan no ndakno bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Weꞌe utid bexa idub isla wa, cha ulayaꞌ bexa gezh Pafos. Leꞌa sa wa mzheꞌal bexa dub xa judio nsaleaꞌ Barjesús, dub xa bruj. Leꞌa xa wa ndab ndadiꞌizh sakndoꞌ Dios, ná leꞌa ta wa gealkwiꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Leꞌa Barjesús wa dub amig ten Sergio Paulo, xa nibeꞌe idub Chipre, dub xa ndákpa. Leꞌa Sergio Paulo wa unab giꞌid Bernabé no Saulo, leꞌa xa nlad goꞌón diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ná leꞌa Barjesús xa noga nsaleaꞌ Elimas wa ndakloo ndoꞌ bexa, leꞌa xa lá nlad gungea ladna Sergio Paulo diꞌizh ten Cristo. ");
INSERT INTO zpt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Weꞌe leꞌa Saulo xa nsaleaꞌga Pabl wa uzheꞌeb ncho juers ten Espíritu ten Dios ladoꞌo na, mwiꞌila ndon gaꞌal ndoꞌ xa bruj wa, ");
INSERT INTO zpt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","cha ndab xa: —¡Lu xin maxuꞌu! Lu xa ukwiꞌin, no ugap nak lu. Sbeꞌentsa nka lu ndoꞌ be ta wen ten Dios. ¿Xtaꞌan lá nlaꞌa lu gungea ladna be men diꞌizh ten Jesús zha? ");
INSERT INTO zpt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nat leꞌa Dios utsaksi lu, yak lu dub xa lá naꞌ, lá yoota gan inaꞌ lu xeꞌa wizh dub tiemp. Bi leꞌa gor wa leꞌa Elimas naꞌanpa inaꞌ, cha nkwaꞌan xa ton isen yaꞌa xa uluu nes ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Leꞌa gor uniꞌí xa nibeꞌe Chipre ta wa, cha uzheꞌeb ngwanseana xa ndoꞌ diꞌizh ten Jesús, cha no xa mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Leꞌa Pabl no be ltsaꞌa xa cha utoꞌo Pafos, nchaꞌbe bexa len dub barco siꞌil nchaꞌa gezh Perge ten región Panfilia. Ná leꞌa Pafos wa leꞌa Juan cha mlaꞌa bexa, nseaꞌ xa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Leꞌa Pabl no Bernabé cha utoꞌo Perge, nchaꞌa bexa gezh Antioquía ten región Pisidia. Ngol dub wizh neꞌe be men cha ngwaꞌ bexa len niꞌi sa nzhealbe bexa judio gezh wa, cha usob bexa. ");
INSERT INTO zpt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Gor mtayoꞌol dub xa dub tuzh ta mkeꞌa Moisés no be profet, leꞌa bexa nchansu sa wa cha ndab ndoꞌ dub men gab ndoꞌ Pabl no ndoꞌ Bernabé: —Bego nak beuna xmen Dios, tal leꞌa bego nlad gudiꞌizh ndoꞌ besa dub taꞌa gakno besa, gud bego‑yá nat. ");
INSERT INTO zpt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Weꞌe leꞌa Pabl cha usoꞌ, cha uxits yaꞌa na, ndontsa xe kwe be men, cha ndab xa: —Blaꞌach bego xa Israel, no iteata bego ndankea Dios. ");
INSERT INTO zpt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Leꞌa Dios ten beuna xa Israel mti be usan gox polta ten beuna wa no mbin Dios myak kwaꞌad bexa wa zha utencho bexa Egipto, cha juers ten Dios uloꞌo Dios bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","No mxik Dios ndoꞌ bexa dub top gaꞌal liꞌin uyoꞌo bexa geꞌe sa bid. ");
INSERT INTO zpt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","No juers ten Dios leꞌa bexa mbin gan ndoꞌ gaꞌad ras be men kwaꞌadpa ndencho ndoꞌ yo Canaán. Cha msaꞌa Dios yo siꞌil wa ndoꞌ bexa Israel wa. ");
INSERT INTO zpt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tsoꞌo wa pa dap gayoꞌo itol liꞌin, leꞌa Dios msaꞌa be juez nchansu bexa Israel, gast tiemp ten profet Samuel. ");
INSERT INTO zpt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Leꞌa zha wa unab be men dub rey inibeꞌe bexa. Weꞌe leꞌa Dios msoꞌ Saúl xin Cis xa ras Benjamín, gak xa xa nibeꞌe top gaꞌal liꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsoꞌo wa leꞌa Dios ulatsoꞌ Saúl, cha msoꞌ Dios David gak xa xa nibeꞌe. Leꞌa Dios ndab: “Leꞌa David xin Isaí dub xa nsak lad naꞌ lak nak xa, leꞌa xa wa gun itea ta nlad naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","No ndab Dios ndoꞌ David, leꞌa dub xa ras David wa gak xa na usaꞌa gealnaban ndoꞌ be men Israel. Leꞌa xa wa leꞌa Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Leꞌa zha na biseata ilen Jesús wa, leꞌa Juan ndadiꞌizhla diꞌizh ten Dios ndoꞌ be men Israel, ndab xa ulaꞌa bexa be ta ugap nak bexa no italeaꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ngol zha yamer usandoꞌ Juan tiꞌin wa, leꞌa xa ndab: “Leꞌa naꞌ ndee naꞌanpa leꞌa xa ndanbeꞌe bega wa. Tsoꞌo naꞌ ndee ilen stub xa mas nsak ndoꞌ naꞌ, gast ni lá isaya naꞌ kote naꞌ ndab xa wa.” ");
INSERT INTO zpt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Blaꞌach bego nak beuna xa ras Abraham, no iteata bego ndankea Dios. Leꞌa ta na ndáp naꞌ ndee itea ndoꞌ beuna nsaꞌa gealnaban. ");
INSERT INTO zpt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Leꞌa be men ncho Jerusalén no bexa nibeꞌe ten bexa wa lá yakbeꞌena bexa ton nak Jesús. Ni lá yakbeꞌena bexa be ta mbidiꞌizh be profet, ta junt ndoꞌol bexa itea be wizh neꞌe beuna wa. Ta weꞌe ndab bexa gat Jesús, lak mkeꞌa be profet polta wa gun bexa. ");
INSERT INTO zpt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Leꞌa bexa ni lá izheal ni dub ke nsabndoꞌ gat Jesús, ná leꞌa bexa unab ndoꞌ Pilat inibeꞌe xa gat Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Weꞌe cha tsoꞌo na li ngwasea Jesús lak nkeaniꞌi diꞌizh ten Dios, cha uxeꞌe bexa xa ndoꞌ cruz, cha mkaꞌach bexa xa. ");
INSERT INTO zpt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ná leꞌa Dios mxiste xa wa mban xa ndoꞌ gealgut. ");
INSERT INTO zpt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Leꞌa Jesús cha sian biaj mlundoꞌ ndoꞌ be xmen xa, bexa utoꞌono xa Galilea nchaꞌa xa Jerusalén. Nat leꞌa bexa wa leꞌa ndadiꞌizh ná ton nak Jesús ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Nat leꞌa besa ndee ndadiꞌizh ndoꞌ bega be diꞌizh wen ná xteꞌe wen gunno Dios be men, lak ndab Dios ndoꞌ be usan gox polta ten beuna. ");
INSERT INTO zpt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nat ndoꞌ beuna nak xin bexa wa, leꞌa ta ndab Dios wa ngok cumplir gor na mxiste xa Jesús ndoꞌ gealgut, lak nkeaniꞌi ndoꞌ Salmo itop, ndab Dios ndoꞌ Jesús: “Leꞌa lu nak Xiꞌín naꞌ, leꞌa nat leꞌa naꞌ nak Xus lu.” ");
INSERT INTO zpt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Leꞌa Dios leꞌa mxiste Jesús mban Jesús ndontsa lá gazhaꞌa beꞌal las xa, lakka nkeaniꞌi diꞌizh ten Dios, ndab Dios: “Usa naꞌ ta wen ndoꞌ bega, ta na ndáp naꞌ ndoꞌ David wa.” ");
INSERT INTO zpt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","No stub Salmo nkeaniꞌi ndab David: “Leꞌa go Dios lá ulaꞌa gazhaꞌa beꞌal las xa umbiꞌi ten ga.” ");
INSERT INTO zpt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Leꞌa David mxobgekka ndoꞌ Dios, parea ngut xa, cha mgaꞌach xa baꞌa sa mgaꞌach be usan gox ten xa, cha ngwazhaꞌa beꞌal las xa. ");
INSERT INTO zpt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ná leꞌa Dios mxiste Jesús mban xa, leꞌa beꞌal las Jesús naꞌanpa ngazhaꞌa. ");
INSERT INTO zpt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","’Bego nak beuna xmen Dios, blaꞌach bega leꞌa besa ndab ndoꞌ bega leꞌa Dios utsuꞌu be ke ten bega juers ten ta mbin Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Leꞌa naꞌan ton wen yaꞌan ndoꞌ Dios ta na nxobgektsa xa ndoꞌ ley mkeꞌa Moisés. Ná leꞌa tal ton igeꞌ ladna Jesús, leꞌa xa wa wen yaꞌan ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Blaꞌach bega naꞌanpa ilen ta li mkeꞌa be profet polta wa tsoꞌo bega, zha ndab Dios: ");
INSERT INTO zpt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Bwiꞌi bego na ndun usaladno naꞌ, leꞌa bega yanseana no gat; geal leꞌa tiemp ten bega leꞌa naꞌ gun dub ta uzheꞌeb, dub ta lá gungea ladna bega, tal leꞌa dub men gudiꞌizh‑a ndoꞌ bega. ");
INSERT INTO zpt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Weꞌe leꞌa gor na nchatoꞌo Pabl no Bernabé len niꞌi wa, leꞌa be men unab ndoꞌ itop bexa gudiꞌizhta bexa ta wa stub sman. ");
INSERT INTO zpt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Leꞌa gor na nseaꞌbe bexa, leꞌa kwaꞌad be men usankea tsoꞌo Pabl no Bernabé. Leꞌa ta wa bexa judio no bexa naꞌanpa xa judio, bexa no ndankea Dios lak ndun bexa judio. Leꞌa Pabl no Bernabé cha mtenxeꞌa bexa wa, ndab bexa lá ulaꞌa bexa ta ngeꞌ ladna bexa Dios, xa na nkweaꞌ ladna bexa. ");
INSERT INTO zpt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ngol stub wizh neꞌe bexa, yamer iteanak be men gezh wa mzhealbe goꞌón diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ná leꞌa ncho pla bexa judio gor uniꞌí bexa leꞌa be men kwaꞌad mzhealbe sa wa, cha ngokloo bexa. Cha usaxan bexa ndab bexa leꞌa ta ndab Pabl wa naꞌanpa leꞌa nak, no xela uníꞌi bexa ndoꞌ Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Weꞌe leꞌa Pabl no Bernabé ni lá izheb bexa ndab bexa: —Besa nsabndoꞌ gudiꞌizh diꞌizh ten Dios, ned lak ndoꞌ bega xa judio. Ná nat leꞌa bega lá nsakyoꞌón‑a, ta nluu leꞌa bega naꞌanpa gap gealnaban ta nunk lá idub. Ta weꞌe leꞌa besa nchabeyadiꞌizh‑a ndi ndoꞌ bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Leꞌa Dios unibeꞌe li gun besa, ndab xa: Naꞌ msoꞌ lu cuent xeꞌa ten bexa naꞌanpa xa Israel, ndontsa gudiꞌizh lu idub ndoꞌ gizhliyo xteꞌe gap bexa gealnaban. ");
INSERT INTO zpt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Leꞌa bexa naꞌanpa xa judio cha uzhebpa mten ladna bexa, ndab bexa leꞌa diꞌizh ten Jesús ta uzhebpa ta wenka. Weꞌe leꞌa kwaꞌad bexa wa mbingea ladna Jesús, bexa na mti Dios gap bexa gealnaban nunk lá idub. ");
INSERT INTO zpt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Cha li mteꞌachso diꞌizh ten Jesús idub gax gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ná leꞌa bexa judio ngwaꞌyadiꞌizhno bexa naktiꞌin no pla be xagots nsak. Cha no bexa wa ngokloo ndoꞌ Pabl no ndoꞌ Bernabé, cha ulantuꞌub bexa Pabl no Bernabé gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Leꞌa Pabl no Bernabé cha mlate yakol ngwaꞌal xoꞌo na, ta mluu leꞌa Dios utsaksi be men gezh wa. Cha nchaꞌa bexa gezh Iconio. ");
INSERT INTO zpt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Parea leꞌa be xmen Jesús ndencho Antioquía wa uzheꞌeb nten ladna, no uzheꞌeb ncho juers ten Espíritu ten Dios ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Leꞌa gezh Iconio leꞌa Pabl no Bernabé uyote len niꞌi sa nzhealbe bexa judio, cha mbidiꞌizh bexa diꞌizh ten Dios ndoꞌ be men. Weꞌe leꞌa kwaꞌad bexa judio no kwaꞌad bexa naꞌanpa xa judio mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ná leꞌa bexa judio, bexa naꞌanpa ngungea ladna Jesús, mbin gan ngokloo kwaꞌad bexa naꞌanpa xa judio ndoꞌ be xmen Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ná leꞌa Pabl no Bernabé kwen ngwaꞌyoꞌo gezh wa. Ngeꞌ ladna bexa Diostsa, ni lá nzheb bexa ndadiꞌizh bexa diꞌizh ten Dios. Leꞌa Dios msaꞌa juers ten na gun bexa be uyon ta yanseana be men, ndontsa gungea ladna be men leꞌa ta ndadiꞌizh bexa diꞌizh tenka Dios. ");
INSERT INTO zpt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ná leꞌa be men gezh wa myak top partid. Dub partid bexa nsoꞌ wats bexa judio wa. Leꞌa stub partid bexa nsoꞌ wats Pabl no Bernabé. ");
INSERT INTO zpt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Weꞌe leꞌa pla bexa judio no bexa naꞌanpa xa judio no bexa naktiꞌin wa dubtsa mbidiꞌizh xela gunno bexa Pabl no Bernabé, cha gut bexa xa sbeꞌen ulaꞌgeꞌtsa bexa xa. ");
INSERT INTO zpt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ná gor na mbiꞌín Pabl no Bernabé ta wa, cha mxoꞌon bexa, nchaꞌa bexa gezh Listra no gezh Derbe no be gezh gax, be gezh ten sa nsaleaꞌ Licaonia. ");
INSERT INTO zpt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Leꞌa sa wa mbidiꞌizh bexa diꞌizh wen ten Jesús ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Leꞌa Listra ncho dub xabgiꞌi lá yoo gan isea zha ngolta xa. ");
INSERT INTO zpt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Leꞌa dub wizh nsobyoꞌón xa ta ndadiꞌizh Pabl, ná gor uniꞌí Pabl xa wa, cha mgenna Pabl leꞌa xa wa ndangea ladna leꞌa Dios syunyakna xa. ");
INSERT INTO zpt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Cha ugeꞌ ndab Pabl ndoꞌ xa: —¡Gosoꞌ! Bkeasoꞌ be xoꞌo lu baꞌ. Leꞌa xabgiꞌi wa cha ngwasoꞌ gast ngwasoꞌ gaꞌal xa, cha usaxan nseala xa. ");
INSERT INTO zpt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Leꞌa gor uniꞌí be men ta li mbin Pabl wa, cha usaxan ugeꞌ ndadiꞌizh bexa diꞌizh ten bexa Licaonia, ndab bexa: —¡Leꞌa bexa ndee be dios myak cuent nak men ulansea lat beuna! ");
INSERT INTO zpt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Cha ndab bexa leꞌa Bernabé nak dios nsaleaꞌ Júpiter. No ndab bexa leꞌa Pabl nak Mercurio stub dios ten bexa, geal leꞌa be men ndab leꞌa Pabl ndadiꞌizh lakga ndadiꞌizh Mercurio wa. ");
INSERT INTO zpt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Leꞌa latbadoꞌo ndankea bexa dios Júpiter wa nde gax toꞌo gezh wa. Leꞌa uleꞌay ten sa wa cha utoꞌo, nchaꞌano pla be ngon no sian be géꞌe. Leꞌa xa no be men kwaꞌad wa ndiꞌizh usaꞌa be ta wa cuent dub xnab ndoꞌ Bernabé no ndoꞌ Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ná gor na mbiꞌín Bernabé no Pabl ta wa, cha utsaw bexa lad nak bexa, tant lá nlad bexa ta wa. Cha ngwasyoꞌo bexa lat be men wa, cha ugeꞌ ndab bexa: ");
INSERT INTO zpt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Blaꞌach bego! ¿Xtaꞌan ngi lbaꞌa gun bega zha? Besa ndee men lakka bego baꞌ. Leꞌa besa ga nseabe yadiꞌizh ulaꞌa bega be ta naꞌan xtiꞌin baꞌ. Ndi bgeꞌ ladna bega Dios nban, xa mbindeꞌe gibeꞌa no gizhliyo no nitsdoꞌo nsea iteata be taꞌa ncho nat. ");
INSERT INTO zpt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Leꞌa tiemp polta leꞌa Dios mlaꞌa be men kad bexa usen nes nlad na. ");
INSERT INTO zpt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ná leꞌa Dios idub tiemp nluu leꞌa xa nchoka, ndun xa be ta wen. Nlaꞌ xa gi, no ndun gaꞌal xa be taꞌa, ndontsa gap beuna ta gaw beuna no iten ladna beuna. ");
INSERT INTO zpt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Parea maska li ndab Pabl no Bernabé ta wa, ná uzhebpa juert mbin bexa gan lá usaꞌa be men xnab ndoꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Weꞌe ulayaꞌ pla bexa judio sa wa, bexa lá ndangea ladna Jesús utoꞌo gezh Antioquía nsea gezh Iconio. Leꞌa bexa wa mbin gan ngokloo be men Listra wa ndoꞌ Pabl. Cha mlaꞌgeꞌ bexa Pabl, gast ni bexa mbit bexa Pabl. Cha udobxazhtsa bexa Pabl dub lad toꞌo gezh wa, cha mchangix bexa Pabl sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ná leꞌa be xmen Jesús myaklo wats Pabl. Leꞌa Pabl cha ngwaste, cha nseaꞌgal xa len gezh wa. Ngot xeꞌa leꞌa Pabl no Bernabé nchaꞌa ndi gezh Derbe. ");
INSERT INTO zpt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mbidiꞌizh bexa diꞌizh wen ten Jesús ndoꞌ be men Derbe wa, cha mbingea ladna kwaꞌad be men Jesús. Cha nseaꞌ bexa leꞌaka gezh Listra no Iconio no Antioquía ten Pisidia. ");
INSERT INTO zpt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ndab bexa ndoꞌ be xmen Jesús ndencho be gezh wa: —Gaꞌaltsa ute bega, lá ulaꞌa bega ta ngeꞌ ladna bega Dios. Leꞌa beuna itidka ndoꞌ sian gealkweaꞌ, weꞌeta yate beuna sa nibeꞌe Dios. ");
INSERT INTO zpt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","No ulaxoꞌob bexa pla bexa yansu be xmen Jesús be gezh wa. Weꞌe leꞌa bexa wa lá ngaw dub tiemp, no unab bexa gakno Dios bexa nchansu be men wa. Leꞌa Pabl nsea Bernabé cha mlaꞌa bexa wa ndoꞌ yaꞌa Dios, xa na li ndangea ladna bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Cha utoꞌo bexa Pisidia, nchaꞌa bexa Panfilia. ");
INSERT INTO zpt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mbidiꞌizh bexa diꞌizh ten Jesús ndoꞌ be men gezh Perge, cha nchaꞌbega bexa gezh Atalía. ");
INSERT INTO zpt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Leꞌa sa wa usen bexa dub barco siꞌil nchaꞌa gezh Antioquía ten Siria. Leꞌa Antioquía wa sa na li myun be men cuent bexa ndoꞌ yaꞌa Dios, gun bexa tiꞌin ten Dios, ta na li msandoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Leꞌa gor mlanseaꞌ bexa Antioquía, cha mchealte bexa be xmen Jesús. Cha mbidiꞌizh bexa xteꞌe mbintiꞌin Dios bexa sa ngwaꞌkesea bexa wa, no xteꞌe nlaꞌa Dios leꞌa bexa naꞌanpa xa judio no ndangea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Leꞌa Pabl no Bernabé kwen ngwaꞌyoꞌono be xmen Jesús gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Weꞌe leꞌa pla men utoꞌo Judea ulayaꞌ Antioquía wa, cha usaxan nluu xa be xmen Jesús sa wa, ndab bexa ndoꞌ bexa naꞌanpa xa judio, leꞌa tal leꞌa be xabgiꞌi lá yoo beꞌe lak ndab ley ten Moisés, leꞌa Dios naꞌanpa koꞌo bexa ndoꞌ be ke ten bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Leꞌa Pabl no Bernabé uzheꞌeb uteyotoꞌono bexa li nluꞌu ta wa. Ta weꞌe leꞌa be xmen Jesús ndencho sa wa cha mbidiꞌizh yaꞌ Pabl no Bernabé no stapla bexa gast Jerusalén, ndontsa gudiꞌizhno bexa be apostol no bexa nchansu be xmen Jesús sa wa, ná xteꞌe nak ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Leꞌa be xmen Jesús ncho gezh Antioquía cha mtuꞌub bexa wa. Leꞌa nes wa nchaꞌtid bexa sa nsaleaꞌ Fenicia no Samaria, cha mbidiꞌizh bexa ndoꞌ be xmen Jesús sa wa, ná xteꞌe no bexa naꞌanpa xa judio mbingea ladna Jesús. Cha uzheꞌeb mten ladna bexa na mbiꞌín ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Gor ulayaꞌ bexa Jerusalén, leꞌa be apostol nsea bexa nchansu no iteata be xmen Jesús wa utsin mbinno bexa. Leꞌa Pabl no be ltsaꞌa xa cha usaxan ndadiꞌizh xteꞌeta ndakno Dios bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ná leꞌa pla bexa fariseo na ndangea ladna Jesús ngwasoꞌ ndab: —Leꞌa bexa naꞌanpa xa judio nsabndoꞌka yoo beꞌe be xabgiꞌi wa, no yankeaka bexa ley ten Dios, ta mkeꞌa Moisés. ");
INSERT INTO zpt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Leꞌa be apostol no bexa nchansu be xmen Jesús wa cha mzhealbe, mbidiꞌizh bexa ná xteꞌe nsabndoꞌ gun bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ngol gor tant dub stub bexa ndeyadiꞌizhbe, leꞌa Pedr cha ngwasoꞌ ndab: —Bego nak beuna xmen Jesús, leꞌa bego uniꞌíka leꞌa mas polta leꞌa Dios mti naꞌ gayadiꞌizh naꞌ diꞌizh wen ten Jesús ndoꞌ bexa naꞌanpa xa judio, ndontsa no bexa gungea ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Leꞌa Dios, xa nchandoꞌ ladoꞌo beuna, msaꞌa Espíritu ten na ndoꞌ bexa wa lak msaꞌa xa‑yá ndoꞌ beuna, ta nluu leꞌa Dios no bexa wa nkweaꞌ ladna. ");
INSERT INTO zpt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Leꞌa Dios parej mbinno bexa wa no beuna, mtsambiꞌi xa ladoꞌo bexa, geal leꞌa bexa ndangea ladna Jesús ");
INSERT INTO zpt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ná nat, ¿xtaꞌan nlad bega gun bega dub ta lá nsak ladna Dios zha? ¿Xtaꞌan nlad bega yankea bexa be ley ni be usan gox ten beuna ni leꞌa beuna lá ngun gan ngankea‑yá? ");
INSERT INTO zpt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Leꞌa beuna ndi uniꞌíka leꞌa ta na nkweaꞌ ladna Jesús beuna, ta weꞌe uloꞌo Dios beuna ndoꞌ be ke ten beuna no liga bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Weꞌe leꞌa itea be men wa ndon xe ute. Cha mlaꞌach bexa ta ndadiꞌizh Bernabé no Pabl xteꞌe mbintiꞌin Dios bexa, mbin bexa sian be uyon ten Dios lat be men naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Leꞌa gor na mtayadiꞌizh Bernabé no Pabl, leꞌa Jacob ukaꞌab ndab: —Bego nak beuna xmen Jesús, blaꞌach bego ta gáp naꞌ ndee. ");
INSERT INTO zpt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Leꞌa Simón Pedr baꞌ mbidiꞌizh xteꞌe utsin mbinno Dios bexa naꞌanpa xa judio lak gor ned, ndontsa no bexa gak xmen Dios. ");
INSERT INTO zpt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Leꞌa ta wa nak lak ta mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios tiemp polta, ndab Dios: ");
INSERT INTO zpt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Leꞌa gal dub wizh leꞌa naꞌ ilengal, cha usoꞌ naꞌ dub xa inibeꞌe lak unibeꞌe David. Leꞌa ta unibeꞌe David wa cuent dub niꞌi gox ulate, ná leꞌa naꞌ ixiste‑yá, yunchaꞌaw naꞌ‑yá lakka ngok‑a zha ned wa, ");
INSERT INTO zpt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ndontsa iteata be men syoꞌo gan ukwaꞌan naꞌ, bexa na mti naꞌ gak bexa xmen naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Leꞌa naꞌ nak Dios Xa Nibeꞌe ndáp ta ndee ndoꞌ be men tiemp polkata. ");
INSERT INTO zpt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Weꞌe no ndab Jacob: —Ta weꞌe nsak naꞌ naꞌanpa kich ladna beuna bexa naꞌanpa bexa judio, bexa nlad gak xmen Dios. ");
INSERT INTO zpt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ndi utuꞌubtsa beuna dub git gab‑a naꞌantapa gaw bexa be xnab nsaꞌa be men ndoꞌ be dios gizhliyo, no naꞌanpa ugal bexa dub xa naꞌanpa xa ten xa, no lá gaw bexa be man lá utsiꞌi ten no ni ten lá gaw bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Leꞌa bexa nsabndoꞌ li gun, leꞌa gast tiemp polta leꞌa kadga dub gezh nchoka men ndoꞌol ley mkeꞌa Moisés. Kadga wizh neꞌe bexa ndoꞌolga bexa ta wa len be niꞌi sa nzhealbe beuna bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Weꞌe leꞌa be apostol, no bexa nchansu be xmen Jesús, no iteata be xmen Jesús wa cha mbidiꞌizh utuꞌub bexa pla be xabgiꞌi yaꞌno Pabl no Bernabé gezh Antioquía. Mti bexa Judas xa no nsaleaꞌ Barsabás, no Silas, top xabgiꞌi nsak lat bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Lndeꞌe ndab git goꞌo bexa Antioquía wa: “Leꞌa besa nak be apostol no besa nchansu be xmen Jesús no iteata be xmen Jesús sa ndee, ntuꞌub besa git ndee ndoꞌ bego naꞌanpa xa judio no nak xmen Jesús wa, bego ncho Antioquía no Siria no Cilicia. ");
INSERT INTO zpt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Leꞌa besa mbiꞌín leꞌa ncho be men utoꞌo lat besa, nluu bexa dub taꞌa ngochgek bega. Nibeꞌe bexa yoo beꞌe bega xabgiꞌi no yankea bega ley mkeꞌa Moisés. Ná leꞌa besa naꞌanpa leꞌa utuꞌub bexa uluu bexa ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nat mbidiꞌizh besa ulaxoꞌob besa pla xabgiꞌi ncho lat besa ndee. Leꞌa bexa wa giꞌidno Pabl no Bernabé be ltsaꞌa beuna, ");
INSERT INTO zpt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bexa ndun tiꞌin ten Jesucristo guniꞌi xteꞌe gunno be men bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ta weꞌe utuꞌub besa Judas no Silas, leꞌa bexa wa giꞌid yadiꞌizh masta xteꞌe nak ta mkeꞌa besa ndoꞌ git ndee. ");
INSERT INTO zpt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Leꞌa Espíritu ten Dios mluu ndoꞌ besa lá gabta besa ni stub taꞌa mas gun bega, guntsa bega ta nsabndoꞌ ndee: ");
INSERT INTO zpt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lá gaw bega beꞌal ten man nsaꞌa bexa xnab ndoꞌ dios gizhliyo, no lá gaw bega ten no beꞌal ten be man lá utsiꞌi ten, no lá ugal bega stubga xa naꞌanpa xa ten bega. Tal leꞌa bega uxobgek ndoꞌ be ta ndee, leꞌa bega wen nak ndoꞌ Dios. Nzheal beuna stub wizh.” ");
INSERT INTO zpt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Weꞌe leꞌa idap bexa na li mtuꞌub bexa wa nchaꞌbe Antioquía. Leꞌa gor ulayaꞌ bexa sa wa, cha mchealte bexa itea be xmen Jesús. Cha msaꞌa bexa git wa ndoꞌ bexa Antioquía wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Leꞌa be xmen Jesús wa cha mbiꞌil ta nkeaniꞌi ndoꞌ git wa, cha uzheꞌeb mten ladna bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Leꞌa Judas no Silas nak xa ndadiꞌizh sakndoꞌ Dios, ta weꞌe kwen mbidiꞌizh bexa, mluꞌuzh bexa no mtenxeꞌa bexa be men Antioquía. ");
INSERT INTO zpt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Leꞌa bexa wa dub ndeꞌep utencho sa wa. Weꞌe leꞌa gor na mkaꞌan bexa sa wa, leꞌa bexa gezh wa ndab leꞌa Dios gakno bexa nes nseaꞌ bexa. Cha nseaꞌbe bexa leꞌaka Jerusalén ndoꞌ bexa mtuꞌub bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ná leꞌa Silas ndi myaꞌan Antioquía. ");
INSERT INTO zpt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Leꞌa Pabl no Bernabé no myaꞌan Antioquía no stapla bexa wa, nluu bexa diꞌizh ten Jesús no ndadiꞌizh bexa diꞌizh wen ten Jesús ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tsoꞌoma wa leꞌa Pabl ndab ndoꞌ Bernabé: —Leꞌa beuna yaꞌinaꞌ be xmen Jesús ndencho itea be gezh sa na li ngwaꞌyadiꞌizh beuna diꞌizh ten Dios wa, ná xteꞌe nde bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Leꞌa Bernabé nlad goꞌo bexa no Juan, xa noga nsaleaꞌ Marc. ");
INSERT INTO zpt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ná leꞌa Pabl nsak lá utsin nak goꞌo bexa xa, leꞌa xa wa mkaꞌan wats bexa Panfilia, cha naꞌantapa no xa ngakno bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Leꞌa Pabl no Bernabé uteyotoꞌo, cha mteltsaꞌa bexa. Leꞌa Bernabé cha mbiꞌi Marc, cha uyoꞌo bexa len dub barco siꞌil nchaꞌa isla Chipre. ");
INSERT INTO zpt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Leꞌa Pabl mtiga ndi Silas, cha nchaꞌbe bexa. Leꞌa bexa ndencho sa wa mlaꞌa bexa wa ndoꞌ yaꞌa Dios ulaꞌach bexa. ");
INSERT INTO zpt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Weꞌe utid Pabl no Silas sa nsaleaꞌ Siria no Cilicia, mtenxeꞌa bexa be xmen Jesús kadga sa nzhealbe bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tsoꞌo wa leꞌa Pabl utid gezh Derbe, cha ulayaꞌ xa gezh Listra, sa ncho Timoteo xa no nak xmen Jesús. Leꞌa xnaꞌa xa wa xa judio noga ndangea ladna Jesús. Leꞌa xus Timoteo wa xa griego. ");
INSERT INTO zpt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Leꞌa be xmen Jesús ndencho Listra no Iconio ndab leꞌa Timoteo dub xa wenka. ");
INSERT INTO zpt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Leꞌa Pabl nlad goꞌo Timoteo, ta weꞌe ulo Pabl beꞌe Timoteo lak ndun bexa judio. Li mbin xa ndontsa naꞌanpa gakloo bexa judio, leꞌa itea bexa judio ndencho sa yaꞌ bexa wa uniꞌí leꞌa xus Timoteo xa griego. ");
INSERT INTO zpt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Weꞌe leꞌa Pabl no be ltsaꞌa xa nchaꞌtid sian be gezh, ndadiꞌizh bexa ndoꞌ be xmen Jesús xtaꞌan unibeꞌe be apostol no bexa nchansu be xmen Jesús ndencho Jerusalén wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Weꞌe leꞌa be men wa mas mgeꞌ ladna Jesús, no kad wizh mas nsayak kwaꞌad bexa. ");
INSERT INTO zpt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Leꞌa Espíritu ten Dios lá ulaꞌa gudiꞌizh bexa diꞌizh ten Jesús ndoꞌ be men región Asia. Cha ndi nchaꞌtid bexa sa nsaleaꞌ Frigia no Galacia. ");
INSERT INTO zpt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Leꞌa gor ulayaꞌ bexa wa Misia, mbinbeꞌe bexa nchaꞌbe bexa Bitinia. Ná leꞌa Espíritu ten Dios lá ulaꞌa ngaꞌbe bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Cha utid bexa Misia gast ulayaꞌ bexa gezh Troas. ");
INSERT INTO zpt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Weꞌe leꞌa gor teꞌal leꞌa Pabl cuent ta mcheꞌa ladna xa uniꞌí xa dub xabgiꞌi región Macedonia nsoꞌ ndoꞌ Pabl ndab xa giꞌid yakno Pabl bexa Macedonia wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ngol tsoꞌo wa cha mbin list besa yaꞌbe besa Macedonia. Uniꞌí besa leꞌa Dios nlad yaꞌyadiꞌizh besa diꞌizh wen ten Jesús ndoꞌ be men sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Leꞌa Troas wa cha uyoꞌo besa len dub barco siꞌil nchaꞌa isla Samotracia. Leꞌa stubtsa wizh ulayaꞌ besa gezh Neápolis. ");
INSERT INTO zpt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Cha nchaꞌbe besa gezh Filipos, dub gezh nsak nde región Macedonia, no leꞌa‑yá dub gezh leꞌa Roma nibeꞌe. Cha uyoꞌo besa sa wa pla wizh. ");
INSERT INTO zpt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Leꞌa ngol dub wizh neꞌe be men, cha utoꞌo besa len gezh wa ngwaꞌ besa toꞌo yowbeꞌe, sa ndaꞌyadiꞌizhno be men Dios. Cha usob besa mbidiꞌizh besa ndoꞌ be xagots mzhealbe sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Leꞌa dub bexa wa nsaleaꞌ Lidia, dub xa ndankea Dios. Leꞌa xa dub xa gezh Tiatira, no nsiꞌi utiꞌix xa lad konch ta uyap nsak. Leꞌa gor wa leꞌa Dios mxaꞌal ladoꞌo xa, ndontsa mas ulaꞌach xa ta ndadiꞌizh Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Leꞌa xagots wa cha utaleaꞌ, no be ltsaꞌa xa. Weꞌe cha ndab xa ndoꞌ besa: —Tal leꞌa bega nsak leꞌa naꞌ noka ndangea ladna Jesús, waꞌa beuna yaꞌan bega ta lid naꞌ. Cha ngwaꞌyoꞌo besa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Stub wizh gor nchaꞌbe besa sa li ndadiꞌizhno be men Dios wa, mzheꞌal besa dub xagots ben ncho mbi bxin len ladoꞌo na. Leꞌa mbi bxin wa nsaꞌa juers ngenna xagots wa be ta ugaꞌach, ndun xa gan sian med nkaꞌa be xwan xa. ");
INSERT INTO zpt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Leꞌa xagots wa cha usaxan usankea tsoꞌo Pabl no besa, ugeꞌ ndab xa: —¡Leꞌa bexa ndee bexa ndun tiꞌin ten Dios nsob gibeꞌa! ¡Ndadiꞌizh bexa ndoꞌ bega xteꞌe nak nes ncho gealnaban! ");
INSERT INTO zpt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Sian wizh li mbinno xa besa, gast ngol dub wizh leꞌa Pabl ngwaꞌineꞌe ladna ta wa. Cha mgeaksoꞌ Pabl ndab ndoꞌ mbi bxin wa: —Leꞌa juers ten leaꞌ Jesucristo leꞌa naꞌ nibeꞌe ndoꞌ lu, utoꞌo len ladoꞌo xagots baꞌ. Leꞌa mbi bxin wa cha bi leꞌa gor wa utoꞌo len ladoꞌo xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Leꞌa be xwan xagots wa cha uniꞌí leꞌa bexa yá naꞌanta xteꞌe gun gan med, cha usen bexa Pabl no Silas mbiꞌi bexa ndoꞌ bexa naktiꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Cha ndab bexa ndoꞌ bexa naktiꞌin wa: —Leꞌa bexa judio ndee nchealuyo be men gezh ndee. ");
INSERT INTO zpt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nluu bexa be costumbr xaꞌaga, ta lá nsabndoꞌ yankea beuna, leꞌa beuna ndee be men nibeꞌe Roma. ");
INSERT INTO zpt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Weꞌe cha kwaꞌad be men ngoklopa ndoꞌ Pabl no ndoꞌ Silas. Leꞌa be men naktiꞌin wa cha unibeꞌe itate xab bexa, nsea kin be soldad bexa no bar. ");
INSERT INTO zpt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tsoꞌo na li uzheꞌeb udin be soldad wa Pabl no Silas, cha mkeꞌa soldad bexa litgiꞌib. Cha unibeꞌe bexa ndoꞌ xa nlaꞌach litgiꞌib wa uzheꞌeb ulaꞌach xa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Leꞌa gor na mbiꞌín xa li nlaꞌach litgiꞌib ta wa, cha mkiko xa Pabl no Silas dub cuart nde mas xanxá sa wa. Cha mkiko xa yaꞌaxoꞌo bexa wa lat top bleꞌa ya, dub sa ni lá yoo gan itoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ná ngol utol teꞌal leꞌa Pabl no Silas ndadiꞌizhno Dios, no ndaltoꞌo bexa ndoꞌ Dios. Leꞌa itea bexa nkea litgiꞌib wa no ndeyoꞌón ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Zha leꞌa dub xoꞌo siꞌilpa usaxan nsayakla mkwiꞌin idub sa nde litgiꞌib wa. Bi leꞌa gor wa cha myaꞌal iteanak be puert ten litgiꞌib, no myaꞌak caden nchii itea bexa nkea sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Leꞌa xa nlaꞌach sa wa cha uban, cha mnaꞌla xa leꞌa be puert wa nsoꞌnyaꞌalbe. Cha uloꞌo xa spad ten xa ndiꞌizh gut xa leꞌaka leꞌa xa, leꞌa xa ndanbeꞌe leꞌa bexa nkea litgiꞌib wa itea mxoꞌonbe. ");
INSERT INTO zpt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ná leꞌa Pabl cha ugeꞌ ndab: —Naꞌanpa lbaꞌa gun ga, leꞌa besa iteaka ndencho sa ndee. ");
INSERT INTO zpt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Weꞌe leꞌa xa nlaꞌach sa wa unab dub xeꞌa isu sa wa, cha uxax nchaꞌa xa uyoꞌo xa len wa. Cha msaxib xa ndoꞌ Pabl no ndoꞌ Silas, nxis xa tant nzheb xa. ");
INSERT INTO zpt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Cha uloꞌo xa bexa wa, cha ndab xa: —¿Xteꞌe gun naꞌ ndontsa gap naꞌ gealnaban ndoꞌ Dios zha? ");
INSERT INTO zpt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Leꞌa bexa wa ukaꞌab ndab: —Bgeꞌ ladna ga Jesucristo, weꞌe gap ga gealnaban, no bexa ncho ta lid ga. ");
INSERT INTO zpt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Cha mbidiꞌizh bexa diꞌizh ten Jesús ndoꞌ xa wa no ndoꞌ itea bexa ncho ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bi leꞌa gor teꞌal wa leꞌa xa nlaꞌach litgiꞌib cha mbin ramed las Pabl no Silas. Cha utaleaꞌ xa no itea bexa ta lid xa. ");
INSERT INTO zpt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Cha myoꞌo xa Pabl no Silas ta lid xa, cha msaꞌa xa ta gaw bexa. Cha uzheꞌeb mten ladna xa no itea bexa ta lid xa geal mbingea ladna bexa Dios. ");
INSERT INTO zpt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Leꞌa gor ngot xeꞌa wa leꞌa bexa naktiꞌin unibeꞌe ndoꞌ soldad yaꞌyab ndoꞌ xa nlaꞌach litgiꞌib wa koꞌo xa Pabl no Silas. ");
INSERT INTO zpt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Leꞌa xa nlaꞌach sa wa cha ndab ndoꞌ Pabl: —Leꞌa bexa naktiꞌin wa unibeꞌe itoꞌo bega. Nat syoꞌo gan yaꞌbe bega. ");
INSERT INTO zpt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ná leꞌa Pabl ndab ndoꞌ be soldad wa: —Leꞌa besa xa Roma, ná udin bexa besa ndoꞌ gaꞌal be men, ni lá ngab bexa xá ke na‑yá. Cha mkiko bexa besa litgiꞌib ndee. Ná nat nlad bexa xgaꞌach yaꞌbe besa. Gud bega ndoꞌ bexa wa leꞌaka gidloꞌo besa. ");
INSERT INTO zpt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Leꞌa bexa cha ngwaꞌyab ta wa ndoꞌ bexa naktiꞌin. Leꞌa bexa wa cha mzheb gor na mbiꞌín bexa leꞌa Pabl no Silas bexa Roma. ");
INSERT INTO zpt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Cha ngwaꞌinab bexa naktiꞌin gungeꞌ ladna bexa be ta li utid wa. Cha uloꞌo bexa Pabl no Silas, cha unab bexa ikaꞌan bexa gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Weꞌe leꞌa gor na mtoꞌo Pabl no Silas litgiꞌib, cha nchaꞌa bexa ta lid Lidia. Weꞌe mluꞌuzh bexa be xmen Jesús sa wa, cha mkaꞌan bexa gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Weꞌe cha utid Pabl no Silas gezh Anfípolis no gezh Apolonia. Cha ulayaꞌ bexa gezh Tesalónica, sa nde dub niꞌi sa nzhealbe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Leꞌa Pabl cha nchaꞌa sa wa wizh neꞌe bexa, lakka ndun xa itea be gezh sa ndaꞌ xa. Weꞌe chon sman mbidiꞌizh Pabl ndoꞌ bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ndab xa leꞌa lak nkeaniꞌi diꞌizh ten Dios, leꞌa Cristo lika nsabndoꞌ kweaꞌ itid no gat xa, no yaste xa ndoꞌ gealgut. No ndab Pabl: —Leꞌa Jesús xa lndeꞌe ndadiꞌizh naꞌ ndoꞌ bega, leꞌa xa wa leꞌa nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Leꞌa ncho bexa wa mbingea ladna ta wa, cha dubtsa myak bexa nsea Pabl no Silas. No kwaꞌad bexa naꞌanpa xa judio ndankea Dios cha no mbingea ladna Jesús, no kwaꞌad be xagots nsak. ");
INSERT INTO zpt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ná leꞌa bexa judio na naꞌanpa ngungea ladna Jesús wa cha ngokloo geal kwaꞌadpa bexa judio no mbingea ladna. Leꞌa bexa wa cha mchealte pla be xabgiꞌi ugap. Weꞌe leꞌa bexa judio wa no bexa ugap wa mbin gan ngokloo kwaꞌadpa bexa gezh wa, gast uzheꞌeb dub uyo uyoꞌo sa wa. Cha uyoꞌo juers bexa len lid dub xa nsaleaꞌ Jasón, nkwaꞌan bexa Pabl no Silas, ndontsa yak cuent bexa ndoꞌ bexa naktiꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Parea lá ngaizheal bexa Pabl no Silas, cha mbiꞌi juers bexa Jasón no stapla be xmen Jesús. Cha myun bexa cuent bexa ndoꞌ bexa naktiꞌin, ugeꞌ ndab bexa: —Leꞌa bexa ngo uyo idub ndoꞌ gizhliyo wa nat nseabega sa ndee. ");
INSERT INTO zpt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Leꞌa Jasón ndee nsaꞌa ta lid na uyoꞌo bexa. Ná leꞌa itea bexa wa lá nxobgek ndoꞌ César xa nibeꞌe Roma, ndab bexa ncho stubga xa mas nibeꞌe nsaleaꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Weꞌe leꞌa bexa naktiꞌin no be men gezh wa uzhebpa ngokloo bexa, gor na mbiꞌín bexa ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ná leꞌa Jasón no be ltsaꞌa xa cha utixtsa dub mult ndoꞌ bexa naktiꞌin, cha myaꞌak bexa. ");
INSERT INTO zpt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Leꞌa gor uyoꞌo teꞌal leꞌa be xmen Jesús wa cha uxax mtuꞌub Pabl no Silas gezh Berea. Cha uyote bexa len niꞌi sa nzhealbe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Leꞌa bexa ncho Berea wa mas utsin nak ndoꞌ lak nak bexa Tesalónica, leꞌa bexa Berea uzhebpa nlaꞌach xtaꞌan ndadiꞌizh Pabl no Silas. No itea wizh ntsid bexa ta nkeaniꞌi diꞌizh ten Dios, ndontsa iniꞌí bexa naga ta ugeaka ta ndadiꞌizh itop bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ta weꞌe leꞌa kwaꞌad bexa judio wa no mbingea ladna Jesús. No kwaꞌad bexa naꞌanpa xa judio, be xagots no be xabgiꞌi, mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ná leꞌa gor na mbiꞌín bexa judio ndencho Tesalónica, leꞌa Pabl ndadiꞌizhgal diꞌizh ten Jesús gezh Berea wa, cha utoꞌo pla bexa nchaꞌbe bexa sa wa. Cha mbin bexa gan ngokloo kwaꞌadpa be men Berea ndoꞌ Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ná leꞌa be xmen Jesús uxax mbiꞌi Pabl lad toꞌo nitsdoꞌo. Leꞌa Silas no Timoteo myanyoꞌo Berea. ");
INSERT INTO zpt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Leꞌa pla bexa cha mbiꞌi Pabl gast gezh Atenas. Cha ndab Pabl ndoꞌ bexa wa: —Leꞌa gor na yach bega gezh Berea, cha gud bega ndoꞌ Silas no ndoꞌ Timoteo uxax giꞌid bexa gezh Atenas ndee. ");
INSERT INTO zpt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ndalen li nchonkea Pabl ilen Silas no Timoteo gezh Atenas wa, leꞌa Pabl kweaꞌ ncho ladna uniꞌí xa xteꞌeta uzheꞌeb ndankea be men be dios gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Weꞌe leꞌa len niꞌi sa nzhealbe bexa judio, mbidiꞌizhno Pabl bexa judio no bexa naꞌanpa xa judio, bexa ndankea Dios. No ndoꞌ bexa nzheꞌal Pabl ndoꞌ xgeꞌe wa itea wizh ndadiꞌizh Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","No mbidiꞌizhno Pabl pla bexa epicúreo no bexa estoico, leꞌa ta wa top partid men ncho Atenas wa. Ncho bexa wa ndab: —¿Xteꞌe nak ta ndadiꞌizh xa ndee zha? Leꞌa ncho bexa ukaꞌab ndab: —Nsak naꞌ cuent ten be dios xaꞌaga ndadiꞌizh xa. Leꞌa bexa li ndab geal leꞌa Pabl ndadiꞌizh diꞌizh wen ten Jesús ná xteꞌe mban Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Leꞌa bexa wa cha mbiꞌi Pabl sa nsaleaꞌ Areópago, dub sa nzhealbe be men gezh wa. Cha ndab bexa ndoꞌ Pabl: —Gud go ndoꞌ besa xtaꞌan ta ndadiꞌizh go wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Leꞌa go ndadiꞌizh dub ta nunk besa gol goꞌón. Nat nlad besa goꞌón besa ná xtaꞌan ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Leꞌa bexa Atenas no bexa xaꞌaga ndencho gezh wa, ndal ladna bexa ndadiꞌizh bexa no ndoꞌón bexa sbeꞌen be ta tiꞌi ulensea. ");
INSERT INTO zpt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Weꞌe leꞌa Pabl cha ngwasoꞌ lat bexa ten Areópago wa, cha ndab xa: —Bego xa Atenas, uní naꞌ leꞌa bega uzhebpa ndankea be dios ten bega. ");
INSERT INTO zpt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Leꞌa sa ndaltiꞌid naꞌ len gezh ndee, uní naꞌ be sa ndankea bega be dios wa. No mzheal naꞌ dub sa nkea dub letr ndab‑a: “Dub dios naꞌan ton nchandoꞌ.” Leꞌa Dios wa xa na li ndankea bega maska naꞌanpa nchandoꞌ bega xa, leꞌa naꞌ cuent ten Dios weꞌe ndadiꞌizh. ");
INSERT INTO zpt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Leꞌa Dios weꞌe mbindeꞌe gizhliyo no itea be ta nde ndoꞌ gizhliyo, no nak xa Xwan gibeꞌa no gizhliyo. Leꞌa xa wa lá nyoꞌo len be latbadoꞌo ndandeꞌe men, ");
INSERT INTO zpt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ni lá nkiꞌin gakno be men xa. Leꞌa xa leꞌa nsaꞌa gealnaban ten iteanak be men, no nsaꞌa xa iteanak be taꞌa nkiꞌin be men. ");
INSERT INTO zpt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Leꞌa Dios mbindeꞌe dubtsa xabgiꞌi, cha weꞌe ulen itea ndoꞌ be men ndoꞌ idub nax gizhliyo. No ndab xa polga ilen itea ndoꞌ be men wa no pa yoo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Li ndontsa ukwaꞌan be men Dios no izheal bexa Dios, leꞌa Dios naꞌanpa sit nsoꞌ wats kadga dub beuna. ");
INSERT INTO zpt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Leꞌa juers ten Dios leꞌa beuna nban no nsea beuna no ncho beuna. Leꞌa lat bega no ncho bexa ndab: “Leꞌa beuna nak be xin Dios.” ");
INSERT INTO zpt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tal leꞌa beuna nak xin Dios, lá nsabndoꞌ gunbeꞌe beuna leꞌa Dios nak cuent be dios nakchaꞌaw oro no plata no geꞌ, be ta ndanchaꞌaw be men laktsa ndanbeꞌe bexa. ");
INSERT INTO zpt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Leꞌa Dios pol‑lata mbingeꞌ ladna ndoꞌ be men, leꞌa bexa lá iniꞌí xteꞌe nsabndoꞌ gun bexa. Ná nat leꞌa Dios nibeꞌe ndoꞌ itea be men nde ndoꞌ gizhliyo ulaꞌa bexa be ta ugap nak bexa. ");
INSERT INTO zpt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Leꞌa Dios ulo dub wizh leꞌa dub xa mti Dios gab gaꞌal ndoꞌ itea be men ná xtaꞌan mbin bexa. Leꞌa Dios leꞌa mxiste xa wa ndoꞌ gealgut, ndontsa iniꞌí itea be men leꞌa Dios leꞌaka mti xa. ");
INSERT INTO zpt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Leꞌa gor na mbiꞌín bexa ta na mban dub xa ndoꞌ gealgut, weꞌe ncho bexa wa mxiꞌidno Pabl. Ná ncho bexa ndab ndoꞌ Pabl: —Stub wizh goꞌónta besa ta ndab go wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Weꞌe leꞌa Pabl cha mkaꞌan lat bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ná leꞌa ncho bexa wa mbingea ladna ta mbidiꞌizh Pabl, cha dubtsa myakno bexa Pabl. Leꞌa lat bexa wa ncho dub xa nsaleaꞌ Dionisio, dub xa ten Areópago wa. No dub xagots nsaleaꞌ Dámaris no stapla bexa mbingea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tsoꞌo wa leꞌa Pabl cha utoꞌo Atenas nchaꞌa xa gezh Corinto. ");
INSERT INTO zpt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Leꞌa sa wa mzheꞌal xa dub xabgiꞌi judio nsaleaꞌ Aquila, dub xa Ponto. Leꞌa xa wa tiꞌi mlaꞌnchaꞌ mtoꞌo Italia no xagots ten xa Priscila. Nchaꞌbe bexa Corinto geal leꞌa Claudio, xa nibeꞌe Roma, ulantuꞌub iteanak bexa judio gezh Roma. Leꞌa Pabl cha ngwaꞌinaꞌ bexa wa, ");
INSERT INTO zpt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","cha ngwaꞌyoꞌo Pabl wats bexa ndontsa junt gun bexa tiꞌin, leꞌa bexa no ndandeꞌe niꞌilad, ltsaꞌa tiꞌin ndun Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Leꞌa itea be wizh neꞌe be men, leꞌa Pabl ndadiꞌizh len niꞌi sa nzhealbe bexa judio. Nlad xa leꞌa bexa judio nsea bexa naꞌanpa bexa judio no gungea ladna Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Cha mtoꞌo Silas no Timoteo región Macedonia wa, nchaꞌa bexa Corinto. Leꞌa Pabl sbeꞌen ndadiꞌizh diꞌizh ten Jesús, ndab xa ndoꞌ bexa judio leꞌa Jesús leꞌaka nak Cristo xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ná leꞌa bexa judio ndi usaxan ndakloo, no kweaꞌ uníꞌi bexa ndoꞌ Pabl. Leꞌa Pabl cha utib xab na, ta nluu leꞌa Dios lá nsak ladna lak nak bexa wa, cha ndab xa ndoꞌ bexa wa: —Tal Dios utsaksi bega, leꞌa ta wa naꞌanpa ke ten naꞌ, leꞌa ta wa ke tenka bega. Leꞌa nat leꞌa naꞌ ndaꞌuluu ndi bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Cha mkaꞌan Pabl niꞌi wa, nchaꞌa xa ta lid dub xa nsaleaꞌ Justo, dub xa ndankeapa Dios. Leꞌa xa wa ncho gax wats sa nde niꞌi sa nzhealbe bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Leꞌa dub xa nsaleaꞌ Crispo xa nchansu sa wa no mbingea ladna Jesús no itea be ltsaꞌa xa. No kwaꞌadta bexa Corinto gor na mbiꞌín bexa ta mbidiꞌizh Pabl wa, cha mbingea ladna bexa‑yá, no cha utaleaꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ngol dub teꞌal leꞌa Pabl cuent ta mcheꞌa ladna uniꞌí leꞌa Jesús ndab ndoꞌ xa: —Lá izheb lu gudiꞌizh lu diꞌizh ten naꞌ, ");
INSERT INTO zpt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","leꞌa naꞌ noka nsoꞌ wats lu, ta weꞌe naꞌan ton gun gan ugap gunno lu. Leꞌa gezh ndee kwaꞌadpa be xmen naꞌ ncho. ");
INSERT INTO zpt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Leꞌa Pabl cha ngwaꞌyoꞌo Corinto wa dub liꞌin ncho xoꞌop mbeꞌe, nluu xa be men diꞌizh ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Parea ngol zha nibeꞌe dub xa nsaleaꞌ Galión idub Acaya wa, weꞌe leꞌa pla bexa judio cha mzhealbe, cha mbiꞌi bexa Pabl ndoꞌ Galión. ");
INSERT INTO zpt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Cha ndab bexa ndoꞌ Galión: —Leꞌa xa ndee nkesea uluu be men yankea bexa Dios ndi stubga mod, dub ta naꞌanpa nibeꞌe ley ten besa. ");
INSERT INTO zpt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Leꞌa gor na ndiꞌizh utsakndoꞌ Pabl, leꞌa Galión ndab ndoꞌ bexa judio: —Bego xa judio, tal leꞌa xa baꞌ ndun dub ta ugap, no tal xa ndun dub taꞌa lá nibeꞌe ley ten Roma, leꞌa naꞌ slachka ta gab bego. ");
INSERT INTO zpt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Parea leꞌa bego ndeyo cuent ten be diꞌizhtsa, no xteꞌe leaꞌ be men, no ta nibeꞌe ley ten bega xa judio. Ta weꞌe begoka bin regl ta ndee, leꞌa naꞌ lá yate ndoꞌ cuent ndee. ");
INSERT INTO zpt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Leꞌa Galión cha unibeꞌe itate bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Leꞌa be men naꞌanpa xa judio cha usen xa nsaleaꞌ Sóstenes, xa nchansu niꞌi sa nzhealbe bexa judio wa. Cha udin bexa xa wa ndoꞌ gaꞌal Galión. Ná leꞌa Galión naꞌanta xteꞌe ngunno bexa. ");
INSERT INTO zpt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Leꞌa Pabl sianta wizh ngwaꞌyoꞌo gezh wa. Cha mlaꞌa xa be xmen Jesús sa wa, nchaꞌa xa gezh Cencrea. Cha mchizh Pabl gek na, ta nluu leꞌa xa mbinka dub ta ndab xa ndoꞌ Dios gun xa. Cha uyoꞌo xa len dub barco siꞌil no Aquila nsea Priscila, cha nchaꞌbe bexa región Siria. ");
INSERT INTO zpt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Leꞌa tol nes wa leꞌa bexa ulayaꞌ gezh Éfeso, cha mteltsaꞌa Pabl no bexa wa. Cha nchaꞌyadiꞌizh Pabl ndoꞌ bexa judio len niꞌi sa nzhealbe bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Leꞌa bexa wa unab ndoꞌ Pabl yoo Pabl sa wa stapla wizh, ná leꞌa Pabl lá kaꞌab. ");
INSERT INTO zpt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Cha mkaꞌan Pabl sa wa, ndab xa ndoꞌ bexa wa: —Leꞌa naꞌ nsabndoꞌka Jerusalén itiꞌid ujest nsea ndee. Tal leꞌa Dios nlad leꞌa naꞌ syachka gal inaꞌ naꞌ bega stub biaj. Cha uyoꞌo xa len dub barco siꞌil mkaꞌan xa Éfeso. ");
INSERT INTO zpt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Leꞌa gor ulayaꞌ barco wa gezh Cesarea, cha nchaꞌa Pabl Jerusalén ndontsa inidiꞌizh xa ndoꞌ be xmen Jesús sa wa. Weꞌe cha nchaꞌa xa gezh Antioquía ten Siria. ");
INSERT INTO zpt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Leꞌa xa cha uyoꞌo dub ndeꞌep sa wa, cha nchaꞌagal xa Galacia no Frigia, ndadiꞌizhno xa be xmen Jesús, ndontsa gaꞌal kwe bexa ndoꞌ Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Leꞌa Éfeso ulayaꞌ dub xa judio nsaleaꞌ Apolos, dub xa gezh Alejandría. Leꞌa xa wa uzhebpa dub xa ndák ndadiꞌizh. No uzhebpa nchandoꞌ xa diꞌizh polta ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Leꞌa xa wa mtsid nes ten Jesús, no idub ncho ladna xa ndadiꞌizh xa ta wa ndoꞌ be men. Ta ugeaka ta nluu xa wa, parea nluu xa laktsa mbidiꞌizh Juan cuent ten Jesús zha ulaleaꞌ Juan be men. ");
INSERT INTO zpt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Leꞌa gezh Éfeso wa leꞌa Apolos usaxan ndadiꞌizh ndoꞌ be men len niꞌi sa nzhealbe bexa judio. Ná leꞌa gor na mbiꞌín Priscila no Aquila xteꞌe ndadiꞌizh xa wa, cha mbiꞌi bexa xa ta lid bexa. Cha mas wen mluu bexa ndoꞌ xa xteꞌe nak nes ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Weꞌe leꞌa Apolos nlad yaꞌ región Acaya, cha ndab be xmen Jesús gezh Éfeso wa leꞌa ta wa ta wenka. No mkeꞌa bexa dub git mbiꞌi Apolos ndoꞌ be xmen Jesús ndencho Acaya wa, ndontsa utsin gak bexa ndoꞌ Apolos. Leꞌa gor na ulayaꞌ xa Acaya, leꞌa ta ndadiꞌizh xa wa uzheꞌeb ngokno bexa na ndangea ladna Jesús wa. ");
INSERT INTO zpt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ndab Apolos ndoꞌ bexa judio leꞌa ta ndanbeꞌe bexa wa naꞌanpa leꞌa nak, dub mod na lá gun bexa gan ikaꞌab bexa. Leꞌa xa mbidiꞌizh lak nkeaniꞌi diꞌizh ten Dios, nluu xa leꞌa Jesús leꞌaka nak Cristo, xa mtuꞌub Dios. ");
INSERT INTO zpt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Leꞌa zha li ncho Apolos Corinto wa, leꞌa Pabl utid sa ndiꞌib be geꞌe ubiꞌi, cha ulayaꞌ xa gezh Éfeso. Leꞌa sa wa cha mzheꞌal xa pla be xmen Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Cha unabdiꞌizh xa ndoꞌ bexa ndab xa: —¿Uyoꞌo Espíritu ten Dios len ladoꞌo bega, gor na mbingea ladna bega Jesús zha? Leꞌa bexa wa ukaꞌab ndab: —Ni lá ndoꞌón besa ti ncho Espíritu ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Leꞌa Pabl cha ndab: —¿Xteꞌe utaleaꞌ bega zhaga? Leꞌa bexa ukaꞌab ndab: —Utaleaꞌ besa lak ulaleaꞌ Juan be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Leꞌa Pabl cha ndab: —Leꞌa Juan ulaleaꞌ bexa na mlaꞌa be ta ugap nak bexa, no ndab Juan gungea ladna bexa xa na nsea tsoꞌo Juan wa. Leꞌa ta wa Jesús xa nak Cristo. ");
INSERT INTO zpt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Leꞌa gor na mbiꞌín bexa ta wa, cha stub biaj utaleaꞌ bexa len nits, ta nluu leꞌa bexa xmenka Jesucristo. ");
INSERT INTO zpt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Cha mxoꞌob Pabl yaꞌa na gek bexa, cha no bexa uyoꞌo Espíritu ten Dios len ladoꞌo na. Cha usaxan bexa ndadiꞌizh bexa stubga diꞌizh, no ndadiꞌizh bexa sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Leꞌa bexa wa pa dub tibtop xabgiꞌi. ");
INSERT INTO zpt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Leꞌa pa chon mbeꞌe be wizh sabd leꞌa Pabl ndaꞌuluu be men len niꞌi sa nzhealbe bexa judio. Ni lá nzheb Pabl ndadiꞌizhno bexa wa ná xteꞌe nibeꞌe Dios be men, ndontsa no bexa gungea ladna ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ná leꞌa ncho bexa wa myak ngud ladoꞌo na, ni lá kaꞌab bexa gungea ladna bexa ta ndadiꞌizh Pabl. Ndi kweaꞌ uníꞌi bexa ndoꞌ gaꞌal be men cuent ten Nes ten Cristo. Ta weꞌe leꞌa Pabl cha mteltsaꞌa bexa wa, mbiꞌi xa bexa tiꞌi mbingea ladna Jesús dub niꞌi scuel ten dub mech nsaleaꞌ Tirano. Cha itea wizh mluu Pabl bexa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pa stop liꞌin li mbin Pabl gast itea bexa Asia wa mbiꞌín diꞌizh ten Jesús, bexa judio no bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Leꞌa Dios leꞌa msaꞌa juers mbin Pabl be uyon uzheꞌeb ndanseana be men, ");
INSERT INTO zpt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","gast ncho bexa mbiꞌi bay ten Pabl no dub xab Pabl ndoꞌ bexa gizh no ndoꞌ bexa ncho mbi bxin len ladoꞌo na. Cha myakna bexa gizh wa no utoꞌo mbi bxin len ladoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ná leꞌa ncho bexa judio ndesea gezh Éfeso no nlad kontuꞌub be mbi bxin ncho len ladoꞌo be men. Leꞌa bexa wa no mbintiꞌin leaꞌ Jesús, ndab bexa ndoꞌ be mbi bxin wa: —Leꞌa juers ten leaꞌ Jesús na ndadiꞌizh Pabl wa, nibeꞌe naꞌ utoꞌo len ladoꞌo xa baꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Leꞌa ta wa ta ndun dub gaꞌad xin dub xa judio nsaleaꞌ Esceva, dub uleꞌay nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ná ngol gor leꞌa dub mbi bxin wa ukaꞌab ndab ndoꞌ bexa wa: —Naꞌ nchandoꞌ Jesús wa, no uní naꞌ ton nak Pabl. ¿Ná leꞌa bego zha, ton nak bego? ");
INSERT INTO zpt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Leꞌa xabgiꞌi na ncho mbi bxin len ladoꞌo na cha usaxan udin bexa wa. Leꞌa xabgiꞌi wa ndi mbin gan ndoꞌ bexa, no mtsawiꞌi xa bexa. Leꞌa bexa naꞌantapa nak be xab na mxoꞌon bexa ta lid xabgiꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Leꞌa itea bexa Éfeso wa, bexa judio no bexa naꞌanpa xa judio, leꞌa gor na mbiꞌín bexa ta wa, cha mzheb bexa, ndab bexa leꞌa leaꞌ Jesús uzhebpa ta juert nak. ");
INSERT INTO zpt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","No kwaꞌad bexa na tiꞌi mbingea ladna Jesús cha mbidiꞌizh ndoꞌ be xmen Jesús be ta ugap ngok bexa. ");
INSERT INTO zpt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Leꞌa kwaꞌad bexa wa bexa mbin ta bruj. Leꞌa bexa wa mbiꞌi be libr ten na, cha mtsoꞌol bexa‑yá ndoꞌ gaꞌal itea be men. Leꞌa be libr wa nsak pa dub tol gayoꞌo mil med plata. ");
INSERT INTO zpt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Li mluu Dios juers ten na, cha mas mteꞌachso diꞌizh ten Jesús, no mas kwaꞌad be men mbingea ladna ton nak Jesús. ");
INSERT INTO zpt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tsoꞌo wa leꞌa Pabl ulo ladna itid be gezh nde Macedonia no Acaya, cha ilayaꞌ xa gast Jerusalén. No mbinbeꞌe xa gor na itoꞌo xa Jerusalén wa, leꞌa xa nsabndoꞌ yaꞌ Roma. ");
INSERT INTO zpt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Cha mtuꞌub Pabl Timoteo no Erast, top bexa na ndakno xa, yaꞌ bexa Macedonia. Leꞌa Pabl cha myaꞌan steꞌep Asia wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Leꞌa zha weꞌe uzheꞌeb ngokloo be men Éfeso wa ke ten Nes ten Cristo. ");
INSERT INTO zpt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uyoꞌo dub xabgiꞌi nsaleaꞌ Demetrio, xa ndandeꞌe be ta plata, be ta byux cuent latbadoꞌo ten Diana dios ten bexa. Leꞌa Demetrio wa sian med ndun gan no bexa ndunno xa tiꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Leꞌa xa wa mchealte bexa, cha ndab xa: —Leꞌa bego uniꞌíka leꞌa beuna tiꞌin ndeema sian med nzheal beuna. ");
INSERT INTO zpt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ná leꞌa bega naꞌka no ndoꞌónka bega, leꞌa xa nsaleaꞌ Pabl ndadiꞌizh leꞌa be dios ndandeꞌe men, leꞌa ta wa naꞌanpa nak dios. Leꞌa kwaꞌad men ndangea ladna ta li ndab Pabl, bexa gezh Éfeso ndee no gast idub región Asia ndee. ");
INSERT INTO zpt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Leꞌa be men rages lá isiꞌita ta ndandeꞌe beuna ndee, no rages lá yankeata bexa latbadoꞌo ten dios siꞌil Diana. No gab bexa yá lá nsakta dios Diana, xa ndankea itea bexa Asia no idub ndoꞌ gizhliyo. ");
INSERT INTO zpt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Leꞌa gor na mbiꞌín bexa ta wa, uzheꞌeb ngokloo bexa, cha usaxan ugeꞌ ndab bexa: —¡Siꞌil nak dios Diana ten beuna xa Éfeso! ");
INSERT INTO zpt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Weꞌe uzhebpa mxaꞌach be men idub len gezh wa. Cha usen bexa top xabgiꞌi Macedonia, bexa ndeseano Pabl. Leꞌa dub xa wa nsaleaꞌ Gayo, leꞌa stub xa wa nsaleaꞌ Aristarco. Cha mbiꞌi be men wa itop bexa gast sa nzhealbe be men gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Leꞌa Pabl cha nlad itoꞌo yaꞌyadiꞌizh ndoꞌ be men, ná leꞌa be xmen Jesús lá ulaꞌa. ");
INSERT INTO zpt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","No ncho bexa naktiꞌin Asia wa nakga amig ten Pabl. Leꞌa bexa wa mtuꞌub dub men ngwaꞌyab ndoꞌ Pabl lá yaꞌ Pabl lat be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Leꞌa be men wa uzhebpa níꞌibe ndoꞌ junt wa, ná leꞌa kwaꞌad bexa ni lá iniꞌí xtaꞌan li mzhealbe bexa sa wa. Ncho men ndab dub taꞌa, no ncho xa ndi stubga taꞌa xaꞌaga ndab. ");
INSERT INTO zpt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Leꞌa lat bexa wa nsoꞌ dub xa nsaleaꞌ Alejandro. Leꞌa bexa judio cha msiꞌi xa ndoꞌ be men, ndontsa gab xa leꞌa bexa judio naꞌanpa no ndap ke. Leꞌa xa wa cha uxits yaꞌa na ndontsa xe kwe be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ná leꞌa gor na uniꞌí be men leꞌa Alejandro xa judio, weꞌe pa dub top gor ugeꞌ ndab bexa: —¡Siꞌil nak dios Diana ten beuna xa Éfeso! ");
INSERT INTO zpt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Weꞌe leꞌa secretar ten gezh wa leꞌa mbin xe ute be men, cha ndab xa: —Bego bexa Éfeso, itea be men ncho ndoꞌ gizhliyo uniꞌí leꞌa beuna gezh ndee nsabndoꞌka nlaꞌach latbadoꞌo ten dios siꞌil Diana, no uniꞌí bexa leꞌa geꞌ ten Diana ta ndankea beuna wa ulen gibeꞌa utoꞌo‑yá wats dios Júpiter. ");
INSERT INTO zpt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Leꞌa ta ndee iteaka men uniꞌí leꞌa‑yá ta ugeaka. Ta weꞌe xe ute bega no binbeꞌe bega xtaꞌan ndun bega. ");
INSERT INTO zpt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Leꞌa be xabgiꞌi na mbiꞌi bega ndee naꞌan xtaꞌan ndab ndoꞌ latbadoꞌo ten Diana ni lid nisi bexa dios ten beuna wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Leꞌa tal Demetrio no bexa ltsaꞌa xa ndi nlad usake dub men, ndoꞌ be juez no ndoꞌ bexa naktiꞌin nsabndoꞌ usake bexa xa, leꞌa bexa wa tiꞌin weꞌe ncho. ");
INSERT INTO zpt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ná tal leꞌa bega nlad inab stub taꞌa, sak gudiꞌizh bega‑yá ndoꞌ dub junt ko bexa naktiꞌin wa. ");
INSERT INTO zpt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Rages usake bexa beuna ke ten ta uyoꞌo nat ndee, gab bexa leꞌa beuna ndi ndakloo ndoꞌ bexa naktiꞌin. Ná leꞌa beuna lá yoo gan gab xtaꞌan ndun lndeꞌeta mxaꞌach be men ndee. ");
INSERT INTO zpt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tsoꞌo na li ndab xa ta wa, cha ndab xa yaꞌbe be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Leꞌa tsoꞌo na uleas ta li ndeyo bexa wa, leꞌa Pabl utezh be xmen Jesús ncho sa wa, cha mtenxeꞌa xa bexa dubtsa kwe bexa ndoꞌ Dios. Cha udiꞌid Pabl bexa, ndab Pabl: —Nzheal beuna stub wizh. Cha nchaꞌa Pabl Macedonia. ");
INSERT INTO zpt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Leꞌa be gezh nde Macedonia wa, sian taꞌa mbidiꞌizh Pabl ndoꞌ be xmen Jesús, mtenxeꞌa xa bexa wa. Cha nchaꞌa Pabl región Grecia. ");
INSERT INTO zpt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Leꞌa sa wa uyoꞌo xa chon mbeꞌe, cha ngol gor na ndiꞌizh yoo xa len dub barco siꞌil nchaꞌa Siria, weꞌe mbiꞌínla xa leꞌa ncho bexa judio ndadiꞌizh gut xa. Ta weꞌe lá nga xa len barco wa, ndi myach xa useandats xa, mtidgal xa Macedonia. ");
INSERT INTO zpt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Cha pla xabgiꞌi nchaꞌano xa gast Asia. Leꞌa ta wa Sópater xa gezh Berea, no Aristarco nsea Segundo top bexa Tesalónica, no Gayo xa gezh Derbe, no Timoteo, no Tíquico nsea Trófimo top bexa Asia. ");
INSERT INTO zpt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Leꞌa bexa wa cha mnedbe ndoꞌ besa, cha ndenkeaꞌla bexa besa gezh Troas ten Asia. ");
INSERT INTO zpt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tsoꞌo na utidtsa be wizh ujest ndaw bexa judio pan lá ndoch levadur, cha mtoꞌo besa gezh Filipos len barco. Leꞌa ngol sgaꞌay wizh leꞌa besa ulayaꞌ Troas, sa ndela bexa mned ndoꞌ besa. Leꞌa sa wa uyoꞌo besa dub gaꞌad wizh. ");
INSERT INTO zpt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ngol wizh ned ten sman, mzhealbe besa nak xmen Jesús junt gaw xcheꞌe besa. Leꞌa Pabl ndiꞌizh ikaꞌanka sa wa gat xeꞌa wa, ta weꞌe usaxan xa nluu xa besa, cha kwen mbidiꞌizh xa gast utol teꞌal. ");
INSERT INTO zpt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Leꞌa cuart nde gaꞌap wa sa na mzhealbe besa sian xeꞌa aceit ndiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Leꞌa dub xa ben nsaleaꞌ Eutico nsob toꞌo ventan piso yon wa. Ndalen li kwen mbidiꞌizh Pabl, leꞌa Eutico uzhebpa nyoꞌo xkaꞌal na, cha ngwadgats xa. Cha ubixte xa ulayat xa gast ndoꞌ yo. Cha uxax ngwaꞌixiste bexa xa, ná leꞌa xa ngutla. ");
INSERT INTO zpt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Weꞌe leꞌa Pabl ulaꞌ, cha mxoꞌob xa yaꞌa xa tsoꞌo Eutico, cha udiꞌid xa xa wa. Cha ndab xa ndoꞌ bexa nde sa wa: —Lá izheb bega, leꞌa xa ndee nbanka. ");
INSERT INTO zpt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Leꞌa Pabl cha mkeagal leꞌaka sa wa. Cha uleꞌa xa pan, cha udawno xa besa. Weꞌe mbidiꞌizhgal xa gast ngot xeꞌa, cha nchaꞌa xa. ");
INSERT INTO zpt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Leꞌa Eutico wa nban myoꞌo bexa, uzhebpa mten ladna bexa. ");
INSERT INTO zpt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Leꞌa Pabl nlad yaꞌndats gast gezh Asón, cha sa weꞌe yoꞌo xa len barco. Ta weꞌe leꞌa besa cha uyoꞌo len dub barco siꞌil nchaꞌa Asón, cha uyonkeaꞌ besa mlen Pabl sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Weꞌe mzheꞌal besa Pabl Asón wa, cha uyoꞌo besa len barco wa no Pabl, nchaꞌbe besa gezh Mitilene. ");
INSERT INTO zpt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ngol stubtsa wizh utoꞌo besa sa wa, utid besa gax isla Quío, cha ulayaꞌ besa isla Samos stubga wizh. Cha utoꞌo besa Samos, cha ulayaꞌ besa gezh Trogilio, cha uyoꞌo besa dub teꞌal sa wa. Ngol stubga wizh ulayaꞌ besa gezh Mileto. ");
INSERT INTO zpt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Leꞌa Pabl ngen ladna yaꞌ Jerusalén, ndontsa naga syoꞌo gan no xa ncho sa wa gal ujest Pentecostés. Ta weꞌe lá nga besa gezh Éfeso, leꞌa Pabl lá nlad kwen yaꞌyoꞌo Asia wa. ");
INSERT INTO zpt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Leꞌa zha ndencho besa Mileto wa, leꞌa Pabl ndi mtuꞌub dub xa yaꞌ gezh Éfeso, ndab xa ndoꞌ bexa nchansu be xmen Jesús sa wa giꞌid bexa Mileto. ");
INSERT INTO zpt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Leꞌa gor na ulansea bexa wa, leꞌa Pabl cha ndab ndoꞌ bexa: —Bego uniꞌíka xteꞌe mbin naꞌ idub zha uyoꞌo naꞌ lat bega, gast zha ndon ned ngwal naꞌ Asia no gast nat. ");
INSERT INTO zpt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Idub tiemp ndun naꞌ tiꞌin ten Dios, ni lá yoo naꞌ lat bega cuent dub xa nsak. No sian biaj utoꞌo nitsndoꞌ naꞌ tant sian gealkweaꞌ utiꞌid naꞌ, ta mbinno bexa judio naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Parea leꞌa naꞌ naꞌanpa ula ndi mbidiꞌizhka naꞌ ndoꞌ bega ta nkiꞌin bega, no mluu naꞌ bega sa na nzhealbe bega no kadga ta lid bega. ");
INSERT INTO zpt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mbidiꞌizh naꞌ ndoꞌ bexa judio no ndoꞌ bexa naꞌanpa xa judio, ulaꞌa bexa be ta ugap nak bexa, cha yach bexa wats Dios, cha gungea ladna bexa Jesús Xa Nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nat leꞌa naꞌ nda Jerusalén lak nibeꞌe Espíritu ten Dios, parea leꞌa naꞌ ni lá iní xtaꞌan itiꞌid naꞌ sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ta na unítsa naꞌ leꞌa itea gezh na nda naꞌ leꞌa Espíritu ten Dios ndab ndoꞌ naꞌ leꞌa be men ukeꞌa naꞌ litgiꞌib no sian gealkweaꞌ itiꞌid naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Parea naꞌanpa nlach naꞌ ta wa, leꞌa guniꞌi xtaꞌan gunno bexa naꞌ, leꞌa naꞌ nten ladna usandoꞌ naꞌ tiꞌin msaꞌa Jesús gun naꞌ, ta na ndadiꞌizh naꞌ diꞌizh wen ten Dios ná xteꞌe uzheꞌeb utsin ndanno Dios be men. ");
INSERT INTO zpt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Yá mbidiꞌizh naꞌ ndoꞌ bega xteꞌe nibeꞌe Dios be men, parea nat leꞌa naꞌ uní leꞌa ni dub bega yá naꞌantapa iniꞌí naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","No gáp naꞌ nat leꞌa tal ton dub bega xa Éfeso lá ndangea ladna Jesús, naꞌanpa ke ten naꞌ ta wa, ");
INSERT INTO zpt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","leꞌa naꞌ mbidiꞌizh ndoꞌ bega itea be ta nlad Dios iniꞌí bega. ");
INSERT INTO zpt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nat ndee list bin bega no blaꞌach bega itea be xmen Jesús gezh Éfeso wa, lak mti Espíritu ten Dios bega gun bega, leꞌa Jesús usiꞌi bexa wa ten ten xa. ");
INSERT INTO zpt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Leꞌa naꞌ uní leꞌa tsoꞌo na ikan naꞌ sa ndee, weꞌe ilen pla be men lat bega, bexa nlad gungea ladna bega stub diꞌizh xaꞌaga. Leꞌa bexa wa nak cuent dub mbee ugiꞌi nlad gut be borreg. ");
INSERT INTO zpt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","No leꞌaka lat bega itoꞌo be xabgiꞌi gudiꞌizh ta lid leꞌa nak, ndontsa isankea be xmen Jesús tsoꞌo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ta weꞌe list ute bega, no lá yalad bega xteꞌe mtenxeꞌa naꞌ bega idub chon liꞌin teꞌal tezhea, no nyuꞌno lad naꞌ kadga dub bega. ");
INSERT INTO zpt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Nat ndoꞌ yaꞌa Dios ula naꞌ bega, ulaꞌach Dios bega lak ndab diꞌizh ten xa. Leꞌa diꞌizh wa gun gan mas igeꞌ ladna bega Dios, no ikaꞌa bega ta wen nsaꞌa Dios ndoꞌ itea be xmen xa. ");
INSERT INTO zpt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","No nunk lá isaꞌab lad naꞌ ndoꞌ med ten bega no ni xab bega. ");
INSERT INTO zpt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Leꞌa bego uniꞌíka xteꞌeta ndi mbin naꞌ tiꞌin, ndontsa isiꞌi naꞌ be ta nkiꞌin naꞌ no be ta nkiꞌin bexa ukeseano naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Li mluu naꞌ ndoꞌ bega xteꞌe nsabndoꞌ gun bega tiꞌin, ndontsa gakno beuna bexa uban nak. Btseꞌa ladna bega ta ndab Jesús: “Mas iten ladna xa nsaꞌa taꞌa, ndoꞌ lak iten ladna xa nkaꞌa taꞌa.” ");
INSERT INTO zpt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Leꞌa gor na mtayadiꞌizh Pabl ta wa, cha msaxib xa no itea bexa, cha unab xa ulaꞌach Dios bexa. ");
INSERT INTO zpt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Weꞌe cha uzhebpa mbiꞌin itea bexa. Cha udiꞌid bexa gen Pabl, cha udaw bexa chit ndoꞌ Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Uzhebpa uban myoꞌo ladna bexa, geal leꞌa Pabl ndab yá naꞌantapa iniꞌí bexa Pabl. Cha nchaꞌano bexa Pabl gast sa nde barco. ");
INSERT INTO zpt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Leꞌa gor na mlaꞌa besa bexa Éfeso wa, cha nchaꞌa besa isla Cos len barco wa. Ngot xeꞌa cha utoꞌo besa sa wa, cha nchaꞌa besa isla Rodas, cha ulayaꞌ besa gezh Pátara. ");
INSERT INTO zpt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Leꞌa Pátara wa mzheal besa stub barco nchaꞌa Fenicia. Cha uyoꞌo besa len ta wa, cha nchaꞌa besa. ");
INSERT INTO zpt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ngol gor nchaꞌtid barco wa gax isla Chipre leꞌa ta wa nde lad raves. Cha ulayaꞌ besa gast gezh Tiro ten Siria. Leꞌa barco wa sian taꞌa uxeꞌe bexa ndoꞌ na gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Leꞌa sa wa mzheal besa pla be xmen Jesús, cha uyoꞌo besa lat bexa wa dub gaꞌad wizh. Leꞌa Espíritu ten Dios ndabla ndoꞌ bexa wa xtaꞌan yasea Pabl Jerusalén, ta weꞌe ndab bexa ndoꞌ Pabl lá yaꞌ xa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Leꞌa zha ngwaꞌa gaꞌad wizh wa cha utoꞌo besa sa wa. Leꞌa be xabgiꞌi wa no be xagots ten xa no be xmeꞌed xa gast toꞌo nitsdoꞌo ngwaꞌno besa. Cha msaxib itea besa ndoꞌ yux, mbidiꞌizh besa ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Cha udiꞌid besa bexa, cha uyoꞌo besa len barco wa. Leꞌa bexa wa cha nseaꞌbe ta lid na. ");
INSERT INTO zpt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Weꞌe utoꞌo besa Tiro, cha ulayaꞌ besa gezh Tolemaida. Leꞌa sa wa ngwaꞌinidiꞌizh besa ndoꞌ be xmen Jesús, no uyoꞌo besa dub wizh lat bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ngot xeꞌa wa cha nchaꞌa besa gezh Cesarea len barco wa. Leꞌa sa wa cha ngwaꞌ besa ta lid Julip, cha weꞌetsa uyoꞌo besa. Leꞌa Julip wa dub xa no ndadiꞌizh diꞌizh wen ten Dios ndoꞌ be men, no nak xa dub gaꞌad bexa na mti be apostol Jerusalén wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Leꞌa xa wa ndap dap xingots na, bexa nab. Leꞌa bexa wa ndadiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Leꞌa zha na nchola besa Cesarea pla wizh, cha ulansea dub xabgiꞌi nsaleaꞌ Ágabo, xa utoꞌo Judea, dub xa noga ndadiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Leꞌa gor ulen xa wats besa, cha uloꞌo xa sinch nde len Pabl, cha mxi xa‑yá yaꞌaxoꞌoka xa no yaꞌa xa, cha ndab xa: —Leꞌa Espíritu ten Dios ndab leꞌa bexa judio bexa ndencho Jerusalén lndeꞌe gunno xa ten sinch ndee. Cha yun bexa cuent xa ndoꞌ yaꞌa bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Leꞌa gor na mbiꞌín besa ta wa, leꞌa besa no bexa Cesarea cha uyoꞌo rueg ndab ndoꞌ Pabl lá yaꞌ Pabl Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ná leꞌa Pabl ukaꞌab ndab: —¿Xtaꞌan lbaꞌa ndoꞌonno bega naꞌ zha, ta ndun uban nyoo lad naꞌ? Tal leꞌa Jesús nlad, leꞌa naꞌ gaaka Jerusalén, guniꞌi tal be men uxi naꞌ natal gut bexa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Leꞌa besa lá ngun gan lá yaꞌ Pabl Jerusalén. Ta weꞌe mlaꞌa besa, ndab besa: —Gakka‑yá lak nlad Dios Xa Nibeꞌe. ");
INSERT INTO zpt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ngol tsoꞌo wa, cha msaxkwaꞌa besa be ta goꞌo besa, cha nchaꞌbe besa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Leꞌa pla bexa Cesarea, bexa no nak xmen Jesús, no ngwaꞌno besa Jerusalén. Leꞌa lat bexa wa ncho dub xa nsaleaꞌ Mnasón xa isla Chipre, dub xa pol‑lata mbingea ladna Jesús. Leꞌa xa wa msaꞌa ta lid na uyoꞌo besa Jerusalén wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Leꞌa gor ulayaꞌ besa Jerusalén, leꞌa be xmen Jesús ncho sa wa uzhebpa mten ladnabe. ");
INSERT INTO zpt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Leꞌa ngol stubtsa wizh, leꞌa Pabl no iteata besa ngwaꞌinaꞌ Jacob. Leꞌa sa wa ndebe itea bexa nchansu be xmen Jesús Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Leꞌa Pabl unidiꞌizh ndoꞌ bexa, cha usaxan Pabl ndon xkwaꞌa mbidiꞌizh xa xteꞌe mbintiꞌin Dios Pabl lat bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Leꞌa gor na mbiꞌín bexa ta li ndab Pabl wa, cha ndab bexa leꞌa Dios uzheꞌeb dub Dios siꞌil. Cha ndab bexa ndoꞌ Pabl: —Pabl, leꞌa go uniꞌíka leꞌa sian mil men judio ndangea ladna Jesús. Leꞌa itea bexa wa ndab nsabndoꞌka yankea bexa ley mkeꞌa Moisés. ");
INSERT INTO zpt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Parea mbiꞌín bexa leꞌa go nluu bexa judio ndencho lat bexa naꞌanpa bexa judio, ndab go lá yankeata bexa ley mkeꞌa Moisés wa. Ndab bexa leꞌa go nluu yá lá kota bexa beꞌe be meꞌed bgiꞌi, no yá lá yankeata bexa be costumbr ten beuna bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Nat zha xteꞌe gun beuna ndontsa iniꞌí bexa leꞌa go naꞌanpa li uluu ta wa? Leꞌa bexa soꞌónka leꞌa go nseaꞌla, cha syakjuntka kwaꞌadpa bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nat bin go ta gab besa ndee: Leꞌa lat besa ndee ncho dap xabgiꞌi nsabndoꞌ gun cumplir dub ta ndabla bexa ndoꞌ Dios gun bexa. ");
INSERT INTO zpt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nat waꞌno ga bexa ta niꞌi ten Dios, cha bin bega ta utsambiꞌi len ladoꞌo bega ndoꞌ Dios. No utix bega be xnab usaꞌa bexa ndontsa uchizh bexa gek bexa, ta na nluu leꞌa bexa mbinka ta ndab bexa ndoꞌ Dios. Weꞌe leꞌa itea be men iniꞌí leꞌa ta mbidiꞌizh be men cuent ten go wa naꞌanpa ta ugea. Ndi iniꞌí bexa leꞌa go ndankeaka ley wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","’Leꞌa bexa naꞌanpa xa judio ndangea ladna Jesús wa, mtuꞌub besa git ndoꞌ bexa, ndab git wa leꞌa bexa naꞌanpa juerska gun itea be costumbr ten beuna xa judio. Nabtsa be ta ndee unibeꞌe besa gun bexa: lá gaw bexa beꞌal ta nsaꞌa be men xnab ndoꞌ be dios gizhliyo, no lá gaw bexa ten no beꞌal ten be man lá utsiꞌi ten, no lá ugal bexa dub xa naꞌanpa xa ten bexa. ");
INSERT INTO zpt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Weꞌe leꞌa Pabl cha mbiꞌi dap xabgiꞌi wa, cha mbin bexa ta imbiꞌi bexa ndoꞌ Dios. Leꞌa ngol stubtsa wizh leꞌa Pabl cha ngwaꞌ wats niꞌi ten Dios, nchaꞌyab xa ndoꞌ uleꞌay ná xá wizh na idub ta imbiꞌi bexa wa. Leꞌa gal wizh weꞌe, leꞌa idap bexa wa usaꞌa xnab dubga man ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ná leꞌa wizh na yá gal dub gaꞌad wizh wa, leꞌa pla bexa judio bexa utoꞌo Asia uniꞌíla Pabl wats niꞌi ten Dios. Leꞌa bexa wa mbin gan ngokloo be men kwaꞌad ndoꞌ Pabl, cha usen bexa wa Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ugeꞌ ndab bexa: —¡Bego xa Israel, gokno bega besa! Leꞌa xabgiꞌi ndee leꞌa xa itea lad nkesea uluu be men, ndab xa leꞌa nacion Israel no ley ten Dios no niꞌi ten Dios ndee naꞌanpa nsak. Ná nat leꞌa xa uyoꞌono pla be men naꞌanpa xa judio len niꞌi ten Dios ndee, mbin bzhiꞌik xa sa umbiꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Li ndab bexa, geal leꞌa bexa uniꞌí Pabl len gezh Jerusalén, nkeseano xa dub xa naꞌanpa xa judio, dub xa Éfeso nsaleaꞌ Trófimo. Ta weꞌe mbinbeꞌe bexa leꞌa Pabl mbiꞌi xa wa len niꞌi ten Dios. ");
INSERT INTO zpt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Weꞌe leꞌa idub gezh men wa ngoklobe, cha uxax ulen kwaꞌad bexa, cha usen bexa Pabl. Cha udobxazh bexa Pabl tsoꞌo niꞌi wa, cha uxax mtsaw bexa toꞌo puert ten sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ngol gor na ndiꞌizh gut bexa Pabl, leꞌa xa nibeꞌe ten be soldad wa mbiꞌín leꞌa bexa Jerusalén wa uzheꞌeb ndeseaxaꞌach. ");
INSERT INTO zpt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Leꞌa soldad nibeꞌe wa cha mbiꞌi pla be soldad, cha karrel nchaꞌbe bexa gast sa ndebe be men wa. Leꞌa gor na uniꞌí be men wa soldad nibeꞌe no stapla be soldad wa, cha yá lá iginta bexa Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Weꞌe leꞌa xa nibeꞌe ten be soldad cha usen Pabl, cha unibeꞌe xa uxii be soldad wa Pabl no top caden. Cha unabdiꞌizh xa ndoꞌ be men ná ton xa wa no xtaꞌan mbin xa. ");
INSERT INTO zpt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ná leꞌa ncho bexa wa ndab dub taꞌa, no ncho bexa ndab stubga taꞌa. Uzhebpa ruid mbin bexa, gast lá yakbeꞌena soldad ta wa. Cha unibeꞌe xa goꞌo be soldad wa Pabl sa nde niꞌi ndebe soldad wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Leꞌa gor na ulayaꞌ bexa ndoꞌ scaler ten niꞌi wa, leꞌa be soldad wa gaꞌap mbiꞌi Pabl tant uzheꞌeb ndakloo be men wa. ");
INSERT INTO zpt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Leꞌa be men nseabe tsoꞌo be soldad wa uzheꞌeb ugeꞌ ndab bexa: —¡Gat xa baꞌ! ¡Gat xa baꞌ! ");
INSERT INTO zpt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Leꞌa gor na yá nsayoꞌono be soldad Pabl len niꞌi wa, leꞌa Pabl cha ndab ndoꞌ soldad nibeꞌe wa: —¿Syoꞌo gan gáp naꞌ dub taꞌa ndoꞌ ga? Leꞌa xa wa cha ukaꞌab ndab: —¿Ndadiꞌizh lu diꞌizh griego zha? ");
INSERT INTO zpt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Naꞌanpa lu xa Egipto xa li uteyono bexa nibeꞌe wa zha, xa na ngwaꞌa geꞌe no dub dap mil xa ndut men? ");
INSERT INTO zpt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Leꞌa Pabl cha ukaꞌab ndab: —Leꞌa naꞌ ndee dub xa judio, ngol naꞌ gezh Tarso, dub gezh nsak ten región Cilicia. Naꞌab naꞌ ulaꞌa ga gudiꞌizh naꞌ ndoꞌ be men baꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Leꞌa soldad wa cha ndab: —Leꞌa lu syoꞌoka gan li gun. Leꞌa Pabl cha usoꞌ ndoꞌ scaler wa, cha uxits xa yaꞌa xa ndoꞌ be men. Cha xe ute bexa, cha uníꞌi Pabl diꞌizh hebreo, ndab xa: ");
INSERT INTO zpt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Bego bexa ltsaꞌa naꞌ no bego xa gox, blaꞌach bega dub diꞌizh utsakndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Leꞌa gor na mbiꞌín bexa leꞌa Pabl uníꞌi diꞌizh hebreo, cha mas xe ute bexa. Cha ndab Pabl ndoꞌ bexa: ");
INSERT INTO zpt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Leꞌa naꞌ ndee xa judio. Ngol naꞌ Tarso gezh ten Cilicia, parea Jerusalén ndee ngoꞌol naꞌ. Leꞌa xa nsaleaꞌ Gamaliel ngok mech ten naꞌ, mluu xa naꞌ lakta nak ley msaꞌa Dios ndoꞌ be usan gox polta ten beuna. Uzhebpa nlad naꞌ uxobgek naꞌ ndoꞌ Dios, lak nlad iteanak bego uxobgek bega ndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","No xela mbinno naꞌ be xmen Jesús, mkwan naꞌ xteꞌe gat bexa wa. Usen naꞌ bexa guniꞌi tal xabgiꞌi natal xagots, cha ukeꞌa bexa litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Leꞌa uleꞌay ndon leꞌa nsak no bexa gox nsak gezh ndee uniꞌíka leꞌa bexa leꞌa msaꞌa git mbi naꞌ, ndiꞌizh usa naꞌ‑yá ndoꞌ bexa judio ncho gezh Damasco, ndontsa isen naꞌ be xmen Jesús sa wa, cha goo naꞌ bexa gast Jerusalén ndee, cha utsaksi bexa naktiꞌin bexa. ");
INSERT INTO zpt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Ná leꞌa nes nda naꞌ gax gezh Damasco pa gor gawizh, weꞌe leꞌa dub xeꞌa siꞌil ulen gibeꞌa uzheꞌeb uxax msula idub gangeak wats naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Leꞌa naꞌ cha ulayat ndoꞌ yo, cha mbín naꞌ dub ti men ndab ndoꞌ naꞌ: “Saulo, Saulo, ¿xtaꞌan lbaꞌata ndaklono lu naꞌ zha?” ");
INSERT INTO zpt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Weꞌe leꞌa naꞌ cha unabdiꞌizh, ndáp naꞌ: “¿Ton go zha, Señor?” Leꞌa ti men wa cha ukaꞌab ndab: “Leꞌa naꞌ Jesús xa Nazaret, xa na lbaꞌa ndaklono lu baꞌ.” ");
INSERT INTO zpt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Leꞌa bexa na ndano naꞌ wa no uniꞌí xeꞌa wa cha mzheb bexa, ná lá ngoꞌón bexa ta ndab ti men wa. ");
INSERT INTO zpt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Leꞌa naꞌ cha ndáp: “¿Xtaꞌan nsabndoꞌ gun naꞌ, Señor?” Leꞌa xa wa cha ndab ndoꞌ naꞌ: “Goste, cha waꞌ len gezh Damasco. Leꞌa sa baꞌ gab bexa xtaꞌan nsabndoꞌ gun lu.” ");
INSERT INTO zpt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ná leꞌa ke ten xeꞌa utoꞌo gibeꞌa wa leꞌa naꞌ lá yoota gan iwiꞌi. Weꞌe leꞌa bexa ndano naꞌ wa usen yaꞌa naꞌ, mbiꞌi bexa naꞌ Damasco. ");
INSERT INTO zpt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Leꞌa gezh wa ncho dub xabgiꞌi nsaleaꞌ Ananías, dub xa uzheꞌeb gaꞌal nsoꞌ ndoꞌ Dios lak nibeꞌe ley. Leꞌa itea bexa judio ndencho gezh wa ndab leꞌa xa wa uzheꞌeb xa wen. ");
INSERT INTO zpt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Leꞌa xa wa cha mbiꞌid inaꞌ naꞌ, ndab xa ndoꞌ naꞌ: “Saulo, go no nak xmen Jesucristo, nat yakna ngusndoꞌ ga.” Cha bi leꞌa gor wa, leꞌa naꞌ mnaꞌla, cha mwiꞌi naꞌ ndoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Leꞌa xa cha ndab ndoꞌ naꞌ: “Leꞌa Dios ngwankea be usan gox ten beuna wa mti ga ndontsa igondoꞌ ga ta na nlad Dios gun ga, no iniꞌí ga Jesús xa ndon leꞌa wen wa, no goꞌón ga ti xa. ");
INSERT INTO zpt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Leꞌa go gak dub xa gudiꞌizh cuent ten xa ndoꞌ itea be men, gudiꞌizh ga be ta uniꞌí ga no be ta mbiꞌín ga wa. ");
INSERT INTO zpt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nat yá lá kweasta ga. Goste ga, cha utaleaꞌ ga. No igeꞌ ladna ga Dios ndontsa yuꞌu be ke ten ga.” ");
INSERT INTO zpt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Leꞌa gor na mlansea naꞌ Jerusalén, cha ngwaꞌyadiꞌizhno naꞌ Dios wats niꞌi ten Dios. Leꞌa sa wa uní naꞌ cuent dub ta mcheꞌa lad naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ndab Dios ndoꞌ naꞌ: “Uxax lu, utoꞌo Jerusalén ndee, leꞌa bexa ndee lá gungea ladna ta gudiꞌizh lu cuent ten naꞌ.” ");
INSERT INTO zpt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Leꞌa naꞌ ukab ndáp naꞌ: “Señor, leꞌa be men uniꞌí leꞌa naꞌ ngwaa itea be niꞌi sa nzhealbe beuna xa judio. Cha mbi naꞌ bexa ndangea ladna go litgiꞌib no udin naꞌ bexa. ");
INSERT INTO zpt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","No zha mbit bexa Xteb, xa mbidiꞌizh diꞌizh ten go wa, leꞌa naꞌ no nsoꞌ sa wa. Mbinbe naꞌ ndi wen mbit bexa Xteb, no mlach naꞌ be lad nbix bexa wa.” ");
INSERT INTO zpt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ná leꞌa Dios ndab ndoꞌ naꞌ: “Waꞌ, leꞌa naꞌ utuꞌub lu sit lat bexa naꞌanpa xa judio.” ");
INSERT INTO zpt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Leꞌa be men wa nsakyoꞌónka ta ndab Pabl, parea leꞌa gor na ndab Pabl leꞌa xa yaꞌ lat bexa naꞌanpa xa judio, cha ngokloo bexa, usaxan bexa ugeꞌ ndab bexa: —¡Gat xa baꞌ! ¡Leꞌa xa lá nsabndoꞌ ibanta! ");
INSERT INTO zpt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Leꞌa bexa uzheꞌeb ndebezhat, no ngobi bexa xab bexa, no ngo bexa yo gaꞌap tant ndakloo bexa. ");
INSERT INTO zpt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ta weꞌe leꞌa soldad nibeꞌe wa cha ndab ndoꞌ be soldad wa: —Biꞌi bega Pabl len niꞌi, cha udin bega xa, ndontsa gab xa ná xtaꞌan lita ndakloo be men ndoꞌ xa. ");
INSERT INTO zpt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ná gor na mxi bexa Pabl, leꞌa sa wa no nsoꞌ dub soldad nibeꞌe dub gayoꞌo soldad. Leꞌa Pabl cha ndab ndoꞌ xa: —¿Nibeꞌe ley kin bega dub xa Roma zha, gor na biseata iniꞌí bega ti ndap xa ke zha? ");
INSERT INTO zpt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Leꞌa gor na mbiꞌín xa ta wa, leꞌa xa cha ngwaꞌyab‑a ndoꞌ soldad mas nibeꞌe wa, ndab xa: —¿Xteꞌe gun go zha? Leꞌa xabgiꞌi baꞌ xa Roma. ");
INSERT INTO zpt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Weꞌe leꞌa soldad nibeꞌe wa cha ulen wats Pabl, cha unabdiꞌizh xa ndab xa: —¿Ta ugeaka xa Roma lu zha? Leꞌa Pabl cha ndab: —Naꞌ xa Romaka. ");
INSERT INTO zpt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Leꞌa xa nibeꞌe wa cha ndab: —Leꞌa naꞌ sian med utix ndontsa uyoꞌo gan nak naꞌ xa Roma. Leꞌa Pabl ukaꞌab ndab: —Leꞌa naꞌ ndee zha ngolta naꞌ nakla naꞌ xa Roma. ");
INSERT INTO zpt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Weꞌe leꞌa be soldad na ndiꞌizh igin Pabl wa cha mlaꞌa xa. No xa mas nibeꞌe ten be soldad wa mzheb ta na li mxi xa Pabl, leꞌa Pabl dub xa Roma. ");
INSERT INTO zpt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ngol stubtsa wizh, leꞌa xa nibeꞌe ten be soldad wa nlad iniꞌí ná xá ke na nsake bexa judio Pabl. Cha mxaꞌak xa caden nchii Pabl wa. Cha unibeꞌe xa izhealbe be uleꞌay nibeꞌe no iteata bexa judio nsak. Cha uloꞌo xa Pabl, mbiꞌi xa Pabl ndoꞌ bexa judio nibeꞌe wa. ");
INSERT INTO zpt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Weꞌe leꞌa Pabl ndon gaꞌal nwiꞌi ndoꞌ bexa wa, ndab Pabl: —Bego nak beuna xa Israel, leꞌa naꞌ gast len ladoꞌo naꞌ uní naꞌ leꞌa naꞌ leꞌaka nsoꞌ ndoꞌ Dios gast wizh nat. ");
INSERT INTO zpt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Leꞌa Ananías xa nak uleꞌay ndon leꞌa nsak cha unibeꞌe ndoꞌ bexa nde gax wats Pabl kichyaꞌa toꞌo Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Weꞌe leꞌa Pabl cha ndab ndoꞌ Ananías: —¡Dios utsaksi ga, leꞌa ga cuenttsa dub xa wen nluu! Nsob ga sa baꞌ gab ga naga leꞌa nak ta mbin naꞌ lak nibeꞌe ley, ná unibeꞌe ga ndi utichyaꞌa bexa toꞌo naꞌ, dub ta naꞌanpa nibeꞌe ley wa. ");
INSERT INTO zpt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Leꞌa bexa nde wats Pabl cha ndab ndoꞌ Pabl: —¿Ndoꞌ uleꞌay ndon leꞌa nsak ten Dios lbaꞌa kweaꞌ níꞌi lu zha? ");
INSERT INTO zpt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Leꞌa Pabl cha ukaꞌab ndab: —Bego nak beuna xa Israel, leꞌa naꞌ lá iní ti uleꞌay ndon leꞌa nsak xa baꞌ. Leꞌa diꞌizh ten Dios nkeaniꞌi ndab‑a naꞌanpa kweaꞌ iníꞌi beuna ndoꞌ dub xa naktiꞌin. ");
INSERT INTO zpt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Weꞌe leꞌa Pabl cha mnaꞌ leꞌa pla bexa wa bexa partid saduceo, ná leꞌa stapla bexa wa bexa partid fariseo. Weꞌe cha ugeꞌ ndab Pabl: —Bego nak beuna xa Israel, leꞌa naꞌ xa fariseo xin bexa fariseo. Nsoꞌ naꞌ ndoꞌ bega nat geal ta na ndangea lad naꞌ leꞌa Dios ixiste bexa ngutla. ");
INSERT INTO zpt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Leꞌa gor na li ndab Pabl, leꞌa bexa fariseo wa no bexa saduceo usaxan nyotoꞌobe. Cha myak top partid bexa wa, ");
INSERT INTO zpt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","geal leꞌa bexa saduceo ndangea ladna leꞌa bexa ngutla yá naꞌantapa ibanbe. No ndangea ladna bexa naꞌanpa ncho angel ni xbi men. Parea leꞌa bexa fariseo ndangea ladna leꞌa bexa ngutla wa ibanka, no ncho angel no ncho xbi men. ");
INSERT INTO zpt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Weꞌe leꞌa itea bexa wa nbezhat níꞌibe. Leꞌa pla be mech ten ley bexa fariseo ngwasoꞌ ndab: —Leꞌa xabgiꞌi ndee naꞌan xtaꞌan dub ta ugap ngun. Tal dub xbi men natal dub angel uníꞌi ndoꞌ xa, leꞌa beuna lá nsabndoꞌ uka ta ndun Dios. ");
INSERT INTO zpt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ná leꞌa ta na tant dub uteyotoꞌo bexa wa, leꞌa soldad nibeꞌe wa nzheb nchaꞌa bexa usu Pabl. Ta weꞌe unibeꞌe xa yate be soldad sa wa koꞌo bexa Pabl, cha goꞌo bexa xa leꞌaka len niꞌi ten be soldad wa. ");
INSERT INTO zpt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ngol teꞌal wa leꞌa Jesús mlundoꞌ ndoꞌ Pabl, ndab xa: —Pabl, lá yuꞌta ladna lu. Lak mbidiꞌizh lu diꞌizh ten naꞌ Jerusalén ndee, li nsabndoꞌ gudiꞌizh lu‑yá gezh Roma. ");
INSERT INTO zpt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Leꞌa ngot xeꞌa wa leꞌa ncho bexa judio dubtsa mbidiꞌizh, ndab bexa ndoꞌ be ltsaꞌa xa: —Nsobwiꞌi Dios leꞌa beuna ni lá gaw, no ni nits lá goo beuna, gastka gor gut beuna Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Leꞌa bexa na li mbidiꞌizh gut Pabl wa masla dub top gaꞌal. ");
INSERT INTO zpt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Cha ngwaꞌbe bexa ndoꞌ be uleꞌay nibeꞌe no ndoꞌ bexa gox nsak, ndab bexa: —Leꞌa besa mbidiꞌizh ndoꞌ Dios lá gaw besa gastka gor gut besa Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nat leꞌa bego no iteata bexa judio nsak, gud bego ndoꞌ xa nibeꞌe ten soldad wa leꞌa bega mas koxnes cuent ten Pabl. Unab bega ndoꞌ xa wa ilenno Pabl sa nzhealbe bega wa geꞌa. Leꞌa besa cha gut Pabl nes nchaꞌa xa sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ná leꞌa dub xmeꞌed bsan Pabl mbiꞌín xteꞌe mbidiꞌizh bexa wa. Cha ngwaꞌ meꞌed sa ndebe be soldad wa, ngwaꞌyab meꞌed ta wa ndoꞌ Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Leꞌa Pabl cha utezh dub soldad nibeꞌe dub gayoꞌo soldad, cha ndab xa ndoꞌ xa wa: —Biꞌi ga meꞌed ndee ndoꞌ xa nibeꞌe ga wa, leꞌa meꞌed ndee ndap dub taꞌa gab meꞌed ndoꞌ xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Leꞌa soldad wa cha mbiꞌi meꞌed ndoꞌ xa nibeꞌe wa, ndab xa: —Leꞌa Pabl xa nkea litgiꞌib utezh naꞌ, unab xa goo naꞌ meꞌed ndee ndoꞌ go. Leꞌa meꞌed ndap dub taꞌa gab meꞌed ndoꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Leꞌa xa nibeꞌe wa cha usen yaꞌa meꞌed wa, cha mbiꞌi xa meꞌed dub lad, cha ndab xa: —¿Xtaꞌan gab lu ndoꞌ naꞌ zha? ");
INSERT INTO zpt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Leꞌa meꞌed cha ndab: —Leꞌa bexa judio mbidiꞌizhbe inab ndoꞌ go goꞌo ga Pabl geꞌa sa nzhealbe bexa. Gab bexa ndoꞌ go leꞌa bexa mas nlad koxnes cuent ten Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Parea lá gungea ladna go ta wa, leꞌa masla top gaꞌal bexa wa xgaꞌach nde nes. Leꞌa bexa wa ndab Dios nsobwiꞌi leꞌa bexa lá gaw, no lá goo nits gastka gor gut bexa Pabl. Nat leꞌa bexa list ndebe ná xteꞌetsa gab go. ");
INSERT INTO zpt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Weꞌe leꞌa xa nibeꞌe wa ndab ndoꞌ meꞌed: —Nat byaꞌ. Naꞌan ton ndoꞌ ná gudiꞌizh lu ti ndab lu ta wa ndoꞌ naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Leꞌa xa nibeꞌe be soldad cha utezh top soldad nibeꞌe dub gayoꞌoga be soldad. Cha unibeꞌe xa ndoꞌ itop bexa wa: —Bin list bega top gayoꞌo soldad xa isea ndats na, no chon gaꞌal ncho tiꞌi bexa isob tsoꞌo way, no top gayoꞌo xa goꞌo be lanza. Leꞌa gal gor nkea ugeꞌa gor teꞌal, cha yaꞌbe bego gezh Cesarea. ");
INSERT INTO zpt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","No bsaxkwaꞌa bega dub way isob Pabl tsoꞌo na. No blaꞌach bega Pabl, biꞌi bega xa gast Cesarea ndoꞌ Félix xa nibeꞌe, ndontsa naꞌan xtaꞌan yasea xa. ");
INSERT INTO zpt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Cha no dub git msaꞌa xa ndoꞌ itop be soldad wa. Leꞌa ta wa lndeꞌe ndab: ");
INSERT INTO zpt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Naꞌ Claudio Lisias nidiꞌizh naꞌ ndoꞌ go, Félix, xa nibeꞌe idub sa ndee. ");
INSERT INTO zpt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Leꞌa bexa judio usen Pabl ndiꞌizh gut bexa xa. Ná leꞌa gor na mbín naꞌ leꞌa xa xa Roma, cha ngwaa ulat naꞌ xa no be soldad. ");
INSERT INTO zpt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Leꞌa naꞌ nlad iní naꞌ xá ke na nsake bexa wa xa, ta weꞌe mbí naꞌ xa ndoꞌ bexa nibeꞌe ten bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Cha uní naꞌ leꞌa‑yá ke tentsa ta nibeꞌe ley ten bexa judio wa. Leꞌa Pabl ni dub ke ta nibeꞌe gat xa ni ta nibeꞌe ikea xa litgiꞌib lá ndap xa. ");
INSERT INTO zpt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ná leꞌa naꞌ mbín leꞌa bexa judio mbidiꞌizhlabe xteꞌe gut bexa xa, ta weꞌe mtuꞌub naꞌ xa ndoꞌ go. No ndáp naꞌ ndoꞌ bexa nsake xa, yaꞌyab bexa ndoꞌ go ná xtaꞌan mbin xa.” ");
INSERT INTO zpt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Leꞌa be soldad wa cha mbin lak ndab xa nibeꞌe wa, ngol gor teꞌal wa mbiꞌi bexa Pabl gast gezh Antípatris. ");
INSERT INTO zpt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Leꞌa gor ngot xeꞌa wa, leꞌa be soldad nchaꞌbe ndats na wa myachbe leꞌaka Jerusalén sa ndebe bexa wa. Leꞌa bexa ndiꞌib tsoꞌo way wa nchaꞌano Pabl gezh Cesarea. ");
INSERT INTO zpt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Leꞌa gor na ulayaꞌ bexa Cesarea, cha msaꞌa bexa git wa ndoꞌ Félix, no myun bexa cuent Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Weꞌe cha mbiꞌil Félix git wa, cha unabdiꞌizh xa ndoꞌ Pabl ná pa nak lazh Pabl. Ndab Pabl leꞌa xa xa Cilicia. Leꞌa gor na mbiꞌín Félix ta wa, ");
INSERT INTO zpt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","cha ndab xa ndoꞌ Pabl: —Leꞌa naꞌ sonka ta gab lu gor ilen bexa nsake lu wa. Cha ndab xa ndoꞌ be soldad ukeꞌa bexa Pabl len litgiꞌib, sa ngok lid Herodes xa unibeꞌe mas polta wa. ");
INSERT INTO zpt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Leꞌa ngol sgaꞌay wizh ulayaꞌ Ananías uleꞌay ndon leꞌa nsak, no pla bexa gox nsak ten bexa judio, no dub xa nsaleaꞌ Tértulo dub xa ntsid ley. Leꞌa itea bexa ndee wa ulayaꞌ ndoꞌ Félix, usake bexa Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Leꞌa gor ulenno be soldad Pabl, leꞌa Tértulo usaxan ndadiꞌizh ndoꞌ Félix, nsake xa Pabl ndab xa: —Félix, uzhebpa wen nibeꞌe go sa ndee, ta weꞌe wen ndebe besa no leꞌaka nak itea be taꞌa. ");
INSERT INTO zpt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Idub tiemp no itea lad nsaꞌa besa xno ndoꞌ go Félix idub ncho ladna besa. ");
INSERT INTO zpt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Leꞌa naꞌ lá nlad koo tiemp ten ga, parea leꞌa nat inaꞌab naꞌ goꞌón ga ta gudiꞌizh besa dub xlaꞌaltsa. ");
INSERT INTO zpt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Leꞌa besa ngwaꞌizheal leꞌa Pabl ndee uzhebpa ugap ndun, leꞌa xa nchealuyo bexa judio idub ndoꞌ gizhliyo. No leꞌa xa nak dub xa nsak ten partid ten bexa nsaleaꞌ nazareno. ");
INSERT INTO zpt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","No ndiꞌizh gun bzhiꞌik xa niꞌi ten Dios, ta weꞌe usen besa xa, nlad besa gunno besa xa lak nibeꞌe ley ten besa. ");
INSERT INTO zpt_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ná leꞌa Lisias xa nibeꞌe be soldad wa cha ulen lat besa, cha lajuers mlat xa Pabl ndoꞌ besa. ");
INSERT INTO zpt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Cha ndab xa usake besa Pabl ndoꞌ go sa ndee. Nat tal inabdiꞌizh go ndoꞌ xa, iniꞌí go leꞌa itea ta nsake besa xa ta ugeaka. ");
INSERT INTO zpt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Leꞌa bexa judio wa dubtsa ndab leꞌa ta wa ta ugeaka. ");
INSERT INTO zpt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ná leꞌa Félix cha mbin sein ndoꞌ Pabl iníꞌi Pabl. Leꞌa Pabl cha ndab: —Leꞌa naꞌ uní leꞌa go kwenla nak juez ten idub sa ndee, ta weꞌe nten lad naꞌ utsakndoꞌ naꞌ ndoꞌ ga. ");
INSERT INTO zpt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tal leꞌa go koxnes‑a, leꞌa go szheal leꞌa pa msa tibtop wizh ngwaa naꞌ Jerusalén ngwankea naꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Leꞌa bexa baꞌ naꞌanpa iniꞌí masa ton dub men uteyotoꞌo besa. No ni lá ngun naꞌ dub ta gun leꞌa be men gaklono naꞌ, ni tale ten niꞌi ten Dios, no ni len be niꞌi sa nzhealbe bexa judio, no ni len gezh wa. ");
INSERT INTO zpt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","No ni dub taꞌa li nsake bexa baꞌ naꞌ, lá gun bexa gan uluu leꞌa‑yá ta ugea. ");
INSERT INTO zpt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ta ugeaka leꞌa naꞌ ndankea Dios xa na ngwankea be usan gox polta ten besa, no ndankea naꞌ nes ten Jesús. Leꞌa bexa ndee ndab leꞌa ta wa naꞌanpa leꞌa nak, parea leꞌa naꞌ nxobgek ndoꞌ itea be diꞌizh ten Dios, ta mkeꞌa Moisés nsea bexa mbidiꞌizh sakndoꞌ Dios. ");
INSERT INTO zpt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","No ndangea lad naꞌ lak ndangea ladna bexa ndee, leꞌa Dios ixiste bexa ngutla, tal bexa wen natal bexa ugap. ");
INSERT INTO zpt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ta weꞌe uzhebpa ndun naꞌ juers utsin gak naꞌ ndoꞌ Dios no ndoꞌ be men. ");
INSERT INTO zpt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Leꞌa naꞌ sian liꞌin ngwaꞌukesea be gezh sit, ná nat nsea naꞌ Jerusalén ndontsa usa naꞌ med ndoꞌ bexa uban nak no usa naꞌ man xnab ndoꞌ Dios sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ná ndalen ndun naꞌ be ta wa, gor na mbinla naꞌ ta msambiꞌi naꞌ ndoꞌ Dios, weꞌe leꞌa pla bexa judio bexa Asia uniꞌíla naꞌ wats niꞌi ten Dios wa. Leꞌa wats naꞌ wa ni lid kwaꞌad men ndebe, no ni naꞌanpa ndakloo be men. ");
INSERT INTO zpt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Leꞌa bexa wa nsabndoꞌ gidyab‑a ndoꞌ ga, tal bexa ndap ta nsake bexa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ná tal gab bexa ndee tal leꞌa bexa ngwaꞌizheal leꞌa naꞌ ndun ta lid leꞌa nak, gor na usoꞌ naꞌ ndoꞌ bexa wa. ");
INSERT INTO zpt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nabtsa syoꞌo gan usake bexa naꞌ ta na ugeꞌ uníꞌi naꞌ ndoꞌ bexa wa, ndáp naꞌ leꞌa naꞌ nsoꞌ ndoꞌ bexa wa geal ta na ndangea lad naꞌ leꞌa Dios ixiste bexa ngutla. ");
INSERT INTO zpt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Leꞌa Félix yá uniꞌíla cuent ten nes ten Jesús, ta weꞌe gor na mbiꞌín xa ta wa, cha ndab xa: —Uni ta ndee. Ilentsa Lisias, weꞌe gun naꞌ regl cuent ten bega. ");
INSERT INTO zpt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Cha unibeꞌe Félix ndoꞌ soldad nibeꞌe wa ikeanyaw Pabl, parea ulaꞌa xa ikesea Pabl len niꞌi wa, no ulaꞌa xa tal be ltsaꞌa xa yaꞌinaꞌ xa no gakno bexa xa. ");
INSERT INTO zpt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Leꞌa ngol stapla wizh wa leꞌa Félix no Drusila, xa judio xagots ten xa, ulayaꞌgal sa wa. Leꞌa Félix cha unibeꞌe goꞌo be soldad Pabl sa nsob Félix. Weꞌe cha mbiꞌín bexa ta mbidiꞌizh Pabl ná xteꞌe ndangea ladna men Jesucristo. ");
INSERT INTO zpt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ná leꞌa gor na mbidiꞌizh Pabl xteꞌe nlad Dios gun be men, no xteꞌe lá nsabndoꞌ gun be men sbeꞌen ta nladtsa na, no xteꞌe yoo dub wizh leꞌa Dios leꞌa gab ná ton ndap ke, weꞌe leꞌa Félix cha mzheb, cha ndab xa ndoꞌ Pabl: —Nat byaꞌ. Leꞌa wizh na ulat naꞌ wa, leꞌa naꞌ sbeꞌezhkagal lu. ");
INSERT INTO zpt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tsoꞌo wa nlad Félix leꞌa Pabl usaꞌa med ndontsa ulaꞌa xa Pabl, ta weꞌe sian biaj utezh xa Pabl gudiꞌizhno xa Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ngok top liꞌin leꞌa Félix mtoꞌo sa wa. Cha uyatsob dub xa nsaleaꞌ Porcio Festo. Ná leꞌa Félix nlad wen yaꞌan ndoꞌ bexa judio wa, ta weꞌe lá igoꞌo xa Pabl sa nkeanyaw Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ngok chon wizh nak Festo xa nibeꞌe sa wa, cha utoꞌo xa Cesarea nchaꞌa xa Jerusalén. ");
INSERT INTO zpt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Leꞌa sa wa leꞌa be uleꞌay nibeꞌe no bexa judio mas nsak wa msake Pabl ndoꞌ Festo. No unab bexa ndoꞌ Festo, ");
INSERT INTO zpt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ndab bexa gun Festo lak nlad bexa, inibeꞌe xa giꞌid Pabl Jerusalén. Ná leꞌa bexa nlad gut Pabl nes wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Leꞌa Festo ukaꞌab ndab ndoꞌ bexa: —Leꞌa naꞌ stapla wizh ndee yach Cesarea, sa na nkeanyaw Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Leꞌa bexa nibeꞌe ten bego baꞌ syoꞌo gan no isea sa wa. Cha sa weꞌe usake bexa Pabl, tal ncho xtaꞌan ta ugap mbin xa. ");
INSERT INTO zpt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Leꞌa Festo uyoꞌo Jerusalén pa sxoꞌon nate stiꞌi wizh, cha myach xa leꞌaka Cesarea. Leꞌa ngol stubtsa wizh leꞌa xa usob sa ndun xa tiꞌin, cha unibeꞌe xa giꞌidno bexa Pabl sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Leꞌa gor uyoꞌo Pabl sa wa leꞌa bexa judio na utoꞌo Jerusalén wa myaklo wats Pabl. Cha msake bexa Pabl sian be taꞌa uzhebpa ugap. Ná leꞌa bexa lá ngun gan uluu leꞌa ta wa ta ugeaka. ");
INSERT INTO zpt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Weꞌe leꞌa Pabl cha mtsakndoꞌ, ndab xa: —Naꞌ naꞌan xtaꞌan dub ta ugap ngun, dub ta lá nibeꞌe ley ten besa xa judio. Ni ndoꞌ niꞌi ten Dios ni ndoꞌ César xa nibeꞌe Roma naꞌan xtaꞌan ngun naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ná leꞌa Festo nlad wen yaꞌan ndoꞌ bexa judio, ta weꞌe cha unabdiꞌizh xa ndoꞌ Pabl, ndab xa: —¿Nlad lu yaꞌ lu Jerusalén, ndontsa sa weꞌe gun naꞌ regl cuent ten lu zha? ");
INSERT INTO zpt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Leꞌa Pabl cha ukaꞌab ndab: —Nat nsoꞌ naꞌ ndoꞌ go, xa ndun tiꞌin ten César, sa na nsabndoꞌ gak regl cuent ten naꞌ. Leꞌa go uniꞌíka leꞌa naꞌ naꞌan xtaꞌan dub ta ugap ngunno bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ná tal naꞌ mbin dub ta nsabndoꞌ gat naꞌ, naꞌ naꞌanpa gáp lá gut bega naꞌ. Ná leꞌa be ta ndab bexa baꞌ naꞌanpa ta ugea, ta weꞌe naꞌan ton nsabndoꞌ yun cuent naꞌ ndoꞌ yaꞌa bexa baꞌ. Nat naꞌab naꞌ ndoꞌ ga leꞌa César gun regl cuent ten naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Weꞌe leꞌa Festo cha mbidiꞌizhno be xmen na, ná xteꞌe nsabndoꞌ gun xa. Cha ndab xa ndoꞌ Pabl: —Leꞌa lu unab leꞌa César gun regl cuent ten lu, ta weꞌe ndoꞌ César yaꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ngok stapla wizh leꞌa rey Agripa xa nibeꞌe wa no bsan xa Berenice ulayaꞌ Cesarea, ngwaꞌinaꞌ Festo. ");
INSERT INTO zpt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Leꞌa zha na nchola bexa sa wa sian wizh, leꞌa Festo cha mbidiꞌizh cuent ten Pabl ndoꞌ Agripa, ndab xa: —Leꞌa sa ndee naxncho dub xabgiꞌi mchaꞌanko Félix litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Leꞌa zha ngwaa naꞌ Jerusalén leꞌa be uleꞌay nibeꞌe no bexa gox nsak ten bexa judio unab ndoꞌ naꞌ inibeꞌe naꞌ gat xa wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Leꞌa naꞌ cha ukab leꞌa ley ten Roma nibeꞌe leꞌa dub xa ndap ke nsabndoꞌ isoꞌ ndoꞌ bexa nsake xa wa, ndontsa utsakndoꞌ xa. Leꞌa ley naꞌanpa nibeꞌe gat dub men tal lid ned gun bexa ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Weꞌe leꞌa wizh na ulen bexa sa ndee, cha uxax bi leꞌa ngottsa xeꞌa wa cha usoꞌob naꞌ sa ndun naꞌ tiꞌin, cha unibeꞌe naꞌ giꞌid xabgiꞌi wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ná leꞌa ngol gor na ndebe bexa nsake xa wa, leꞌa bexa naꞌanpa usake xa lak ndanbeꞌe naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Leꞌa bexa ndi nsake xa cuent tentsa lak ndankea bexa Dios, no cuent ten dub xa ngut usaleaꞌ Jesús, ná leꞌa Pabl ndab leꞌa xa wa nban. ");
INSERT INTO zpt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Leꞌa naꞌ lá iní xteꞌe koxnes naꞌ ta wa, cha unabdiꞌizh naꞌ ndoꞌ Pabl naga nlad Pabl yaꞌ Jerusalén, ndontsa sa weꞌe itatsoꞌ xteꞌe nak be ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ná leꞌa Pabl ndi unab yaꞌ ndoꞌ César Augusto. Ta weꞌe unibeꞌe naꞌ litsa nkeanyaw xa gast gal zha utuꞌub naꞌ xa ndoꞌ César. ");
INSERT INTO zpt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Weꞌe leꞌa Agripa cha ndab ndoꞌ Festo: —Naꞌ no nlad gon xtaꞌan ndadiꞌizh xa wa. Leꞌa Festo cha ukaꞌab ndab: —Geꞌa goꞌón lu ta gab xa. ");
INSERT INTO zpt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ngok stubtsa wizh, leꞌa Agripa no Berenice ulayaꞌ sa wa, nak bexa be lad uyap nsak. Cha uyoꞌo bexa len dub cuart siꞌil no bexa nibeꞌe ten soldad no bexa nsak ncho Cesarea wa. Weꞌe leꞌa Festo cha unibeꞌe giꞌid Pabl. ");
INSERT INTO zpt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Cha ndab Festo ndoꞌ bexa nde sa wa: —Go rey Agripa nsea bego mzhealbe beuna sa ndee, leꞌa ta ndee Pabl. Leꞌa xa ndee xa na kwaꞌad bexa judio nsake ndoꞌ naꞌ gezh Jerusalén no Cesarea ndee, ndab bexa leꞌa xa nsabndoꞌ gat. ");
INSERT INTO zpt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ná leꞌa naꞌ ndee nsak leꞌa xa naꞌan xtaꞌan dub ta nsabndoꞌ gat xa ngun xa. Parea leꞌa xa baꞌ leꞌaka unab gun César Augusto regl cuent ten xa, ta weꞌe mbinbe naꞌ utuꞌub naꞌ xa ndoꞌ César. ");
INSERT INTO zpt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ná leꞌa naꞌ lá ndap xtaꞌan ukeꞌa naꞌ ndoꞌ git utuꞌubno naꞌ xa ndoꞌ César wa. Ta weꞌe ulatsoꞌ naꞌ xa ndoꞌ go rey Agripa no ndoꞌ iteata bego, ndontsa gor na itayadiꞌizh beuna cuent ten xa baꞌ, leꞌa naꞌ yá ndap ta ukeꞌa naꞌ ndoꞌ git wa. ");
INSERT INTO zpt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nsak naꞌ naꞌanpa leꞌa nak utuꞌub naꞌ dub xa nkea litgiꞌib ndoꞌ César ni lá gáp naꞌ xá ke na nsake bexa xa. ");
INSERT INTO zpt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Weꞌe leꞌa Agripa cha ndab ndoꞌ Pabl: —Sak utsakndoꞌ lu nat. Leꞌa Pabl uxits yaꞌa na, cha lndeꞌe ndab xa: ");
INSERT INTO zpt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Rey Agripa, naꞌ nten ladna gudiꞌizh naꞌ ndoꞌ go, ndontsa utsakndoꞌ naꞌ ndoꞌ itea be ta na li nsake bexa judio wa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Leꞌa go nchandoꞌ itea be costumbr ten besa xa judio wa nsea be ta ndadiꞌizh besa wa. Ta weꞌe naꞌab naꞌ ndoꞌ ga ulaꞌach ga xtaꞌan gudiꞌizh naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Leꞌa itea bexa judio uniꞌí xteꞌe uyoꞌo naꞌ lat bexa lazh naꞌ no Jerusalén idub tuzhta naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Leꞌa bexa uniꞌí, no syoꞌo gan gab bexa leꞌa naꞌ ndee no ngok xa fariseo, bexa na mas ndankea ley ten Dios ndoꞌ iteata bexa judio. ");
INSERT INTO zpt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Leꞌa naꞌ ndangea ladna leꞌa Dios sunka ta ndab xa ndoꞌ be usan gox polta ten besa, ixiste Dios bexa ngutla. Ke weꞌe nat nsoꞌ naꞌ ndoꞌ go. ");
INSERT INTO zpt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","No liga leꞌa itea bexa isatibtop xkwaꞌa bexa Israel wa ndangea ladna ta wa, bexa ndankea Dios teꞌal tezhea. Rey Agripa, ke weꞌe nsake bexa judio wa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Xtaꞌan lá ndangea ladna bega leꞌa Dios nxiste bexa ngutla zha? ");
INSERT INTO zpt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Leꞌa naꞌ polta no mbinbeꞌe leꞌa naꞌ nsabndoꞌ utsaksi be xmen Jesús xa Nazaret wa. ");
INSERT INTO zpt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Leꞌa ta wa ta mbin naꞌ Jerusalén wa. Nsea permis ten be uleꞌay nibeꞌe mkikoꞌo naꞌ kwaꞌad be xmen Jesús wa litgiꞌib. Nsea gor na mbit be men bexa wa, leꞌa naꞌ no nsak ladna ta wa. ");
INSERT INTO zpt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ukesea naꞌ itea be niꞌi sa nzhealbe bexa judio, cha mtsaksi naꞌ be xmen Jesús sa wa, ndontsa ulaꞌa bexa ta ndangea ladna bexa Jesús. Tant dub ngokloo naꞌ ndoꞌ bexa wa, leꞌa naꞌ ukesankea tsoꞌo bexa gast be gezh sit. ");
INSERT INTO zpt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Tiꞌin weꞌe ngwalo naꞌ permis ten be uleꞌay nibeꞌe, cha mtuꞌub bexa naꞌ gezh Damasco. ");
INSERT INTO zpt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Rey Agripa, leꞌa nes nda naꞌ pa gawizh uní naꞌ dub xeꞌa utoꞌo gibeꞌa, mas uzheꞌeb nsu ndoꞌ xeꞌa wizh. Leꞌa ta wa msu gangeak wats naꞌ no wats bexa ndano naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Cha iteanak besa ulayat ndoꞌ yo. Cha mbín naꞌ dub ti men uníꞌi diꞌizh hebreo, ndab xa: “Saulo, Saulo, ¿xtaꞌan lbaꞌata ugap ndanno lu naꞌ zha? Lu ntsaksi leꞌaka leꞌa lu cuent dub ngon nkeꞌa patad ndoꞌ bar ncheb xa ma.” ");
INSERT INTO zpt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Leꞌa naꞌ cha ndáp: “¿Ná ton go zha, Señor?” Leꞌa xa wa cha ndab: “Leꞌa naꞌ Jesús, xa na lbaꞌa ndaklono lu baꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nat goste, leꞌa naꞌ mlundoꞌ ndoꞌ lu ndontsa gun lu tiꞌin ten naꞌ, gudiꞌizh lu be ta uniꞌí lu nat ndee no be ta tiꞌi ulu naꞌ ndoꞌ lu. ");
INSERT INTO zpt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Leꞌa naꞌ utuꞌub lu ndoꞌ bexa judio no ndoꞌ bexa naꞌanpa xa judio. Leꞌa naꞌ lá ula ni dub bexa wa naꞌanpa ugap gunno lu. ");
INSERT INTO zpt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ndi gudiꞌizh lu diꞌizh ten naꞌ ndoꞌ bexa, ndontsa yaꞌal ndoꞌ bexa no itoꞌo bexa sa ukaw, cha ilen bexa ndoꞌ xeꞌa. Li ndontsa ulaꞌa bexa wa nes ten maxuꞌu, cha ndi isen bexa nes ten Dios. Leꞌa bexa igeꞌ ladna naꞌ, cha yuꞌu be ke ten bexa, no gak bexa be xmen Dios.” ");
INSERT INTO zpt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Ta weꞌe, rey Agripa, leꞌa naꞌ mbinka ta li uníꞌi Dios ndoꞌ naꞌ wa. ");
INSERT INTO zpt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ned lak mbidiꞌizh naꞌ ndoꞌ bexa ndencho Damasco wa. Ndáp naꞌ ndoꞌ bexa wa ulaꞌa bexa be ta ugap nak bexa, cha ndi yach bexa wats Dios, no gun bexa ta wen, ta uluu leꞌa bexa mlaꞌaka be ta ugap nak bexa. Tsoꞌo wa mbidiꞌizhga naꞌ ndoꞌ bexa Jerusalén, no ndoꞌ bexa ndencho idub Judea, no ndoꞌ bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ke weꞌetsa usen bexa judio naꞌ tale ten niꞌi ten Dios, cha ndiꞌizh gut bexa naꞌ. ");
INSERT INTO zpt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ná leꞌa Dios ndakno naꞌ, ta weꞌe nsoꞌ naꞌ gast gor nat, ndadiꞌizh naꞌ diꞌizh ten Dios ndoꞌ bexa nsak no ndoꞌ bexa naꞌanpa nsak. Leꞌa naꞌ ndadiꞌizh laktsa mkeꞌa be profet no Moisés, polta ndab bexa xteꞌe nak ta yoo. ");
INSERT INTO zpt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ndab bexa leꞌa xa utuꞌub Dios wa nsabndoꞌ iniꞌí sian gealkweaꞌ no gat xa. Weꞌe leꞌa xa ndon ned iban ndoꞌ gealgut, ndontsa uluu xa xeꞌa ten Dios ndoꞌ bexa judio no ndoꞌ bexa naꞌanpa xa judio. ");
INSERT INTO zpt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Leꞌa gor na li ndab Pabl, leꞌa Festo cha ugeꞌ ndab: —¡Leꞌa lu xa tont, Pabl! Tant mtsid lu gast myak tont lu. ");
INSERT INTO zpt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ná leꞌa Pabl ukaꞌab ndab ndoꞌ Festo: —Naꞌ naꞌanpa xa tont, Festo. Leꞌa ta na ndadiꞌizh naꞌ ndee wa ta ugeaka no leꞌaka nak‑a. ");
INSERT INTO zpt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Leꞌa rey Agripa baꞌ nchandoꞌ itea be ta ndee, ta weꞌe lá nyuꞌ lad naꞌ li ndadiꞌizh naꞌ ndoꞌ xa. Naꞌ uní leꞌa xa noka uniꞌí be ta ndáp naꞌ wa, leꞌa‑yá naꞌanpa ngak dub sa xgaꞌach. ");
INSERT INTO zpt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Cha ndab Pabl ndoꞌ Agripa: —Go rey Agripa, ¿ndangea ladna ga ta mkeꞌa bexa mbidiꞌizh sakndoꞌ Dios wa zha? Naꞌ uní leꞌa go ndangeaka ladna‑yá. ");
INSERT INTO zpt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Leꞌa rey Agripa cha ukaꞌab ndab ndoꞌ Pabl: —¿Nsak lu zha leꞌa tuzhtsa tiemp gun lu gan no naꞌ gak xmen Cristo? ");
INSERT INTO zpt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Leꞌa Pabl ndab: —Tal tuzhtsa tiemp natal kwen‑a, leꞌa naꞌ naꞌab ndoꞌ Dios leꞌa go no itea bexa ndeyoꞌón ta ndáp naꞌ ndee nat wa, gak bega xmen Cristo, lakka nak naꞌ ndee. Parea lá nlad naꞌ leꞌa bega no yaa caden ndee. ");
INSERT INTO zpt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Leꞌa gor na mtayadiꞌizh Pabl ta wa, cha usoꞌ rey Agripa no Festo nsea Berenice no itea bexa nde sa wa. ");
INSERT INTO zpt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Cha utate bexa dub lad mbidiꞌizh bexa, ndab bexa ndoꞌ ltsaꞌa xa: —Leꞌa xa baꞌ naꞌan xtaꞌan ngun dub ta nsabndoꞌ gat xa, ni lá nsabndoꞌ ikea xa litgiꞌib. ");
INSERT INTO zpt_vpl VALUES ("AC26_32","074_26_32","ACT","26","