﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpqNT_vpl;
CREATE TABLE zpqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpqNT_vpl WRITE;
INSERT INTO zpqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nga nyoj la beṉe' gosac x̱ozxtao' Jesucriston' chzolaon len da' x̱ozxta'ocho Abraham. Ḻe Jesúsen' goque' xi'iṉ diaža c̱he da' David, na' da' Davin' goque' xi'iṉ diaža c̱he da' Abrahanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahanṉa' goque' x̱a Isaac, na' Isaaquen' goque' x̱a Jacob, na' Jacoben' goque' x̱a Judá len yezica'chle beṉe' biše' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judán' na' Tamar gosaque' x̱axṉa' Fares na' Zara. Na' Faresen' goque' x̱a Esrom, na' Esronṉa' goque' x̱a Aram. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Na' Aranṉa' goque' x̱a Aminadab, na' Aminadaben' goque' x̱a Naasón, na' Naasónṉa' goque' x̱a Salmón. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónṉa' na' Rahab gosaque' x̱axṉa' Booz. Na' Boozen' na' Rut gosaque' x̱axṉa' Obed. Na' Obeden' goque' x̱a Isaí. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na' Isaín' goque' x̱a rey David, na' rey Davin' goque' x̱a Salomón. Na' xṉa' Salomónṉa' goque' xo'ol da' Urías cate' za' yeca'a rey Davin' ḻe' par gaque' xo'ole'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na' Salomónṉa' goque' x̱a Roboam, na' Roboanṉa' goque' x̱a Abías, na' Abíasen' goque' x̱a Asa. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na' Asan' goque' x̱a Josafat, na' Josafaten' goque' x̱a Joram, na' Joranṉa' goque' x̱a Uzías. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasen' goque' x̱a Jotam, na' Jotanṉa' goque' x̱a Acaz, na' Acazen' goque' x̱a Ezequías. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na' Ezequíasen' goque' x̱a Manasés, na' Manasésen' goque' x̱a Amón, na' Amónṉa' goque' x̱a Josías. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasen' goque' x̱a Jeconías len yezica'chle biše' ca' gosenita' ca tiemp caten' beṉe' Babilonia ca' gosezene' beṉe' Israel ca' na' gosec̱he'x̱ox̱je' ḻegaque' Babilonian'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Gwde goc ca', golje Salatiel xi'iṉ Jeconíasen'. Na' Salatielen' goque' x̱a Zorobabel. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na' Zorobabelen' goque' x̱a Abiud, na' Abiuden' goque' x̱a Eliaquim. Na' Eliaquinṉa' goque' x̱a Azor. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na' Azoren' goque' x̱a Sadoc, na' Sadoquen' goque' x̱a Aquim. Aquinṉa' goque' x̱a Eliud. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na' Eliuden' goque' x̱a Eleazar, na' Eleazaren' goque' x̱a Matán. Na' Matánṉa' goque' x̱a Jacob. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nach Jacoben' goque' x̱a José ben' goc beṉe' c̱he María. Na' Marían' goque' xṉa' Jesús ben' nzi' Cristo, zeje diža' ben' gwlej Diosen' cont yedeṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na' gwzolaon tiemp c̱he da' Abraham bžinte tiemp c̱he da' David gosac žta' diaža c̱hen', na' ca tiemp c̱he da' David bžinte ca tiemp caten' gosezene' beṉe' Israel ca' gosec̱he'x̱ox̱je' ḻegaque' Babilonia, ḻecze gosac yežta' diaža c̱hen', na' ca tiempen' bžinten ca žan' golje Criston' ben' gwlej Diosen' cont yedeṉabi'e, gosac yežta' diaža c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na' quingan' goc cate' golje Jesucriston'. Ba naquen gwšagna' Marían' len José, na' za' ca'a Josén' ḻe' par gaque' xo'ole' cate' gocbe'ede' ba noa' Marían' bdao'. Goc ca' dan' ben Spiritw c̱he Diosen' cont bchendao' bdao'na' ḻo' ḻe'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na' Joséna' ben' ba naquen si'e Marían' par gaque' xo'ole', goque' to beṉe' ben da' güen lao Diosen'. Na' bene' xbab cuejyic̱hje' Marían' šižize cont nono gacbe'e na' cont bi gwsi'e ḻe' zto'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Šlac chone' xbab gone' ca' gwtase' na' to angl beṉe' gwseḻa' X̱ancho Diosen' blo'elagüe' ḻe' ḻo bišgal. Na' gože' ḻe': ―José, le' goljo' ḻo diaža c̱he da' rey David. Bitw žebo' si'o Marían' par gaque' xo'olo'. Spiritw c̱he Diosen' benen cont no'e bdao'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na' sane' to bi' byo dao' na' gwsi'o labe' Jesús, ḻe ḻen' yeque'e xtoḻa' beṉe' gualaž c̱he' ca' beṉe' yesejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Goc yogo' da' ca' cont goc can' gwna Diosen' dan' bzoj to ben' be'e xtižen' cani', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","To no'ol güego' no'ole ṉe' napši'ichgua cuine' güe'e to bi' byo dao' na' sane'be'. Na' si' labe' Emanuel. Na' Emanuel zeje diža': Diosen' zoacze' len chio'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na' cate' beban Josén' beyož gwṉede' yelen', bene' can' gož angl c̱he X̱ancho Diosen' ḻe', jax̱i'e Marían' liže' par goque' xo'ole'. ");
INSERT INTO zpqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Perw bi gwzoalene' ḻe' ca xo'ole' san gwzoacze' ḻe' respetw bžinte ža gwxane' to bi' byo dao', xi'iṉe' nechw. Na' gwxi' labe' Jesús. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ca tiempen' cate' gwnabia' rey Herodes, golje Jesúsen' Belén, to yež gan' mbane distritw Judea. Na' besežin to c̱hope magos Jerusalén, za'aque' to nación zito' dan' chi' do ga chla' gwbiž. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na' goseṉabde' beṉe' ḻo ciudan' gose'ene': ―¿Gaṉ rey c̱he beṉe' Israel, ben' ba golje? Ṉezeto' ba golje', ḻe ba ble'eto' beljw c̱hen' cate' blan' lažto' dan' zoa gan' chla' gwbiž. Na' za'to' gonxento'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cate' gwṉeze rey Herodesen' can' gosenen', gocchgüe' tole, na' ḻecze ca' yogo'ḻoḻ beṉe' ḻo ciuda Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nach reyna' btobe' yogo'ḻoḻ bx̱oz gwnabia' c̱he chio' beṉe' Israel na' ḻecze yogo' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen'. Na' gwṉabde' ḻegaque' gan' naquen galje Criston' ben' gwlej Diosen' cont yedeṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nach gose' beṉe' ca' Herodesen': ―Galje' Belén, gan' mbane distritw Judea, ḻe can' ža dan' bzoj to beṉe' be' xtiža' Diosen' cani'. Quinga žan: ");
INSERT INTO zpqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ca nac yež Belén gan' že' diaža c̱he da' Judá, nacczen yež da' zaca'chgua lao yež gwnabia' ca' zjachi' Judean'. Ḻe to beṉe' Belén gaque' beṉe' gwnabia', na' ḻe' güia ṉe'e nación Israel c̱hian'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nach Herodesen' goxe' magos ca' bagaše'ze cont ja'aque' lagüen' na' gwnabde' ḻegaque' batyaṉen' besele'ede' bla' beljon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nach gwseḻe' ḻegaque' Belénṉa', gože' ḻegaque': ―Ḻe šja'ac na' ḻe šjaydiljw bidao'na' tcho'a. Na' cate' yeželelebe' ḻe yeda yedyedix̱jue'ele neda' cont ḻecze ša'a šjenxena'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Beyož bosozenag magos ca' can' gož reyna' ḻegaque', nach gosa'aque'. Na' beljon' dan' besele'ede' do gan' chla' gwbižen' cate' biṉa' yesa'ac lažgaquen', zejen ḻe'e yaban' žialaon laogaque' bžinten yo'o gan' zoa bidao'na', na' gwlezen. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na' magos ca' besyebede' juisyw cate' besele'ede' beljon' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nach cate' besežine' yo'o gan' zoa bidaon', goso'e ḻo' yo'ona' na' besele'ede' bidao'na' len xṉa'be' Marían'. Nach bosozoa xibgaque' gosonxene'be'. Na' gosesaljo caj c̱hegaquen' gosebeje' oro, yal na' to nechw da' chḻa' zix̱ da' nzi' mirra na' gosoen' c̱hebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na' šlac ṉe' nita' magos ca' Belénṉa', Diosen' gwdix̱jue'ede' ḻegaque' ḻo bišgal bich yesyedie' gan' zoa rey Herodesen'. Da'nan' besyeque'e yeto nez yoble jaya'ac laže'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na' cate' ba besyeya'ac magos ca', to angl c̱he X̱ancho Diosen' blo'elagüe' Josén' ḻo bišgal, na' gože'ne': ―Gwyas, gwc̱he' bidaon' na' xṉa'ben' ḻe šja'ac nación Egipto na' soale na'ze, na' cate'ch ṉia' le'e, cana' guaque yeza'le, ḻe Herodesen' ba nžie' bia' yeyiljue' bidao'na' cont gote'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nach ṉe' ze bx̱in gwyas Josén', gwc̱he'e bida'ona' len xṉa'ben' zja'aque' Egipton'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nach gosenite' Egipto na'ze šlac bžin ža got Herodesen'. Na' dan' gosone' ca' goc can' gwna Diosen' dan' bzoj to beṉe' be' xtiže'na' cani', gwne': “C̱hix̱jue'eda' Xi'iṉan' yeze'e Egipton'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na' rey Herodesen', cate' gocbe'ede' gosonḻe magos ca' ḻe' dan' bich besyedie' gan' zoe'na', ḻeca bže'e. Na' bsaque' con can' gwyejni'ide' cate' gwṉabde' ḻegaque' batcan' bla' beljon', na' gwseḻe' soldadw c̱he' ca' par jasete' yogo'ḻoḻ bi' byo che'eṉ dao' zelao bi' c̱hop ize, bi' ca' gosalje Belénṉa' na' yezica'chle yež ca' zjanyec̱hj zjambi'i Belénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na' lagüe dan' gosote' bi' byo dao' ca', goc can' bzoj da' Jeremías ben' be' xtiža' Diosen' cani', žan: ");
INSERT INTO zpqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nente ši'i beṉe' Ramá, chesebežchgüe' nita'chgüe' yeḻa' güine'. No'ole ca' zjanaque' xi'iṉ diaža c̱he da' Raquel chesyeyaše' chesyegüine'de' c̱he xi'iṉda'ogaque' ca', na' bitw chesaclaže' no yeyoexenḻaže' ḻegaque', ḻe ba gosatben'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cate' got Herodesen', Josén' ṉe' zoe' Egipton'. Nach to angl c̱he X̱ancho Diosen' blo'elagüe' Josén' ḻo bišgal, na' gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Gwyas, bec̱he' bidaon' len xṉa'be'na' na' ḻe šjaya'ac Israel. Ba gosat beṉe' ca' besyeyiljw bidao'na' cont yesote'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nach gwyas Josén' bec̱he'e bidaon' len xṉa'ben' jaya'ac lažgaque' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Perw Josén', cate' bende' Arquelao bezoe' chnabi'e latje c̱he da' x̱e' Herodesen', bžebe' yeyeje' gan' mbane distritw Judean'. Na' Diosen' gwdix̱jue'ede' ḻe' ḻo bišgalen' bi cheyaḻa' šjaya'aque' distritw Judean', san šjaya'aque' gan' mbane distritw Galilean'. ");
INSERT INTO zpqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Da'nan' besyežine' ciuda Nazaret na' jasenite'. Na' dan' jasenite' Nazareten' goc can' bosozoj da' beṉe' goso'e xtiža' Diosen' cani', gosene': “Yososi'e Jesúsen' beṉe' Nazaret.” ");
INSERT INTO zpqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na' gwde zan iz, Juan ben' bzoa beṉe' nis gwyeje' latje daš gan' mbane distritw Judean'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Na' gwdix̱jue'ede' beṉe', gože' ḻegaque': ―Ḻe yetiṉje xtoḻa'le ca', ḻe ba bžin ža cate' Diosen' ben' zoa yaban' ṉabi'e yic̱hjlaždao' beṉe' yosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","C̱he Juanṉa' bzoj da' Isaíasen' caten' bzoje' Xtiža' Diosen' cani', gwne': Bena' chṉe' zižje latje dašen', že': “Ḻe gonšagüe' yic̱hjlažda'olen' cont soale lez gwzenagle c̱he X̱anchon' cate' yide'. Ḻe cuejyic̱hj da' malen' chonḻe cont yic̱hjlažda'olen' gaquen ca to nez da' ba gosonšagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na' Juanṉa', xaḻane' goquen de yiša' xa camello. Na' da' bc̱hej ḻsinen' goquen de yid, na' gwdagüe' biše'zo len šina' beser yix̱e'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Beṉe' že' ciuda Jerusalénṉa' na' beṉe' že' yogo' yež ca' gan' mbane distritw Judean', na' ḻecze beṉe' že' yež ca' nyec̱hj mbi'i yegw Jordánṉa' gosa'aque' ja'aque' gan' zoa Juanṉa' cont bosozenague' xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na' cate' gosex̱oadoḻe' bi da' xiṉj zjanone', Juanṉa' bzoe' ḻegaque' nis ḻo yegw Jordánṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na' ḻecze ja'ac zan beṉe' Israel beṉe' ca' zjanzi' fariseo na' beṉe' ca' zjanzi' saduseo. Ja'aque' cont bzoa Juanṉa' ḻegaque' nis. Nach Juanṉa' cate' ble'ede' ḻegaque' gože'ne': ―¡Ḻe'e nacchguale beṉe' zgot na' beṉe' gwxiye'! ¿Chaquele guac yelale lao castigw dan' seḻa' Diosen' caten' gone' yeḻa' justis c̱he beṉac̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Še da' ḻi ba betiṉjele xtoḻa'len', cheyaḻa' gonḻe da' nac güen cont yesacbe'e beṉe' ba boša' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na' bitw gonḻe xbab gaquele Diosen' bitw gone' le'e castigw c̱he xtoḻa'len' lagüe dan' nacle xi'iṉ diaža c̱he da' Abrahanṉa'. Bitw ṉacho ḻeca chyažje Diosen' le'e. Guac gone' cont yej quinga yesyeyaquen xi'iṉ diaža c̱he da' Abrahanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ca nac le'e, še bi chonḻe can' chazlaže' Diosen', zaca'leble ca to yag frut da' bibi chbia. Na' yogo'te yag frut da' bibi chbia, c̱hog x̱an yaga' ḻen na' gwzeyen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neda' da' ḻi chzoa' le'e nis ṉec̱he ba betiṉje xtoḻa'le, perw coža'na' za' yid ben' gon cont soa Spiritw c̱he Diosen' ḻo' yic̱hjlažda'olen' ṉabian' le'e. Na' beṉe' ca' bi yeson can' chazlaže' Diosen', seḻe' ḻegaque' ḻo yi' gabiḻen'. Na' ben' za' za' coža'na' zaca'che' ca neda' na' da' nacchgüe' beṉe' zaca', bi zaca' gona' xmandadoe' ḻec̱hja' no xele'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Benan' gone' len beṉac̱hen' can' choncho cate' chdecho trigon' ḻo' rner. Chotobcho trigon' chgo'ošagüe'chon na' chzeycho yix beben'. Na' beṉe' bi chesejnilaže' Diosen', seḻe' ḻegaque' ḻo yi' gabiḻen' dan' cbi cheyol chenit. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na' gwza' Jesúsen' gan' mbane Galilea na' gwyeje' gan' zoa Juanṉa' cho'a yegw Jordánṉa' cont Juanṉa' bzoe' ḻe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na' Juanṉa' ben cho'alagüe' gague goclaže' gwzoe' Jesúsen' nis, gože'ne': ―Chyažjda' gwzo' neda' nisen' na' le' zedeṉabo' gwzoa' le' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nach Jesúsen' gože' Juanṉa': ―Bzoa neda' nisen'. Cheyaḻa' goncho ca' cont gac yogo'ḻoḻ dan' non Diosen' mandadw gac. Nach gwc̱heb Juanṉa' bzoe'ne' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na' cate' beyož gwzoa Jesúsen' nisen', bechoje' ḻo' nisen', na' ḻa' byaljwte yaban' gan' zoa Diosen'. Na' ble'ede' Spiritw c̱he Diosen' betjen ca to ngolbex na' bžinen gwzoan len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na' gosende' gwṉe Dios ben' zoa yaban', gwne': ―Bengan' Xi'iṉa' beṉe' chacda' na' chebe chezaquelaže'chgüeda' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na' Spiritw c̱he Diosen' benen cont gwyej Jesúsen' latje dašen' gan' Satanás dan' chnabia' da' x̱igüe' ca' goclažen' co'oyeḻan' ḻe' cont gone' da' mal. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na' bitwbi gwdagw Jesúsen' lao c̱hoa ža c̱hoa yel, na' cate' gwde da' c̱hoa žana' gwdone'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na' Satanásen' gwbigan' gan' zoa Jesúsen', gožen ḻe': ―Še le' naco' dogualje Xi'iṉ Diosen', gož yej quinga yesyeyaquen yetextil. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nach gož Jesúsen' ḻen: ―Nyojcze Xtiža' Diosen' žan: “Gague yeḻa' guagw na'zen' chyažje chio' beṉac̱h cont gac bancho, san ḻecze chyažjecho yogo'ḻoḻ diža' dan' ža Diosen'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nach gwc̱he' Satanásen' ḻe' ciuda Jerusalén dan' nac ciuda c̱he Dios. Na' bcuen ḻe' yic̱hjo' yodao' blao gan' nac ḻa'zelagüe sibe, ");
INSERT INTO zpqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na' gožen ḻe': ―Še len' naco' dogualje Xi'iṉ Diosen', nga boslažo' cuino', ḻe nyojczen ḻe'e Xtiža' Diosen', žan: Seḻa' Diosen' beṉe' ca' zjanac angl c̱he' yesaclene' le', na' yesox̱e' le' cont bi c̱hego' no yej. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na' gož Jesúsen' gwxiye'na': ―Ḻecze can' nyojen Xtiža' Diosen', žan: “Bitw goncho X̱ancho Diosen' prueba še lede' can' že'na'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Da' yoble gwxiye'na' gozc̱he'en ḻe' to ḻo ya'a da' nacchgua sibe, na' blo'en ḻe' yogo' nación dan' zjachi' doxen yežlion' len yeḻa' zaca' yeḻa' xdan c̱hegaquen. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nach gožen ḻe': ―Yogo' da' quinga chle'edo' nga gonan' ḻo nao' še gwzoa xibo' lagua' nga gonxeno' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nach gož Jesúsen' ḻen: ―Beyej ca'ale Satanás. Nyojczen ḻe'e Xtiža' Diosen' žan: “Cheyaḻa' šejnilaže'cho X̱ancho Diosen' na' toze ḻe' gonxencho.” ");
INSERT INTO zpqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na' becuase Satanásen' cuite'na' beyejen ga yoble nach besežin to c̱hope angl c̱he Diosen' jasaclene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na' Jesúsen' beze'e distritw Judean' na' beyeje' distritw Galilea cate' bende' ba de Juanṉa' ḻižya. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na' gwze'e yež Nazareten' jasoe' ciuda Capernaum dan' chi' cho'a nisdaon' do gan' zjachi' distritw dan' zjanzi' Zabulón na' Neftalí. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na' dan' jayzoe' ciudan' goc can' gwna da' Isaías ben' be' xtiža' Diosen' cani' caten' bzoje' dan' ža: ");
INSERT INTO zpqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ca nac distritw Galilea gan' že' zan beṉe' cbi zjanaque' beṉe' Israel, gan' nita' distritw Zabulón na' distritw Neftalí dan' zjambane yešḻa'ale nisdaon' na' yegw Jordán, ");
INSERT INTO zpqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nc̱hoḻ yic̱hjlaždao' beṉe' ca' že' na'. Perw Diosen' gwseḻe' to beṉe' gwlo'o to be'ni' xen ḻo' yic̱hjlažda'ogaquen'. Gosaque' ca beṉe' guat len yic̱hjlažda'ogüen' ḻe gosone' da' malen', perw bena' gwseḻa' Diosen' ba bocobe' yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cana' gwzolao Jesúsen' gwdix̱jue'ede' gwne': ―Ḻe yetiṉje xtoḻa'len', ḻe ba bžin ža cate' Diosen' ben' zoa yaban' ṉabi'e yic̱hjlaždao' beṉe' yosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na' zej Jesúsen' cho'a nisdao' c̱he Galilea cate' ble'ede' c̱hope beṉe' gwxen beḻ, Simón Pedro na' beṉe' biše' Andrés, na' zjanite' chosozaḻe' yix̱jw dan' chesezende' beḻen' ḻo' nisa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nach gože' ḻegaque': ―Ḻe šo'o len neda'. Nacle beṉe' gwxen beḻ, na' chbejle beḻ ḻo' nis, perw ṉa'a gona' cont gaxle beṉe' yesyechoje' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na' ḻa' gosebejyic̱hjte' yix̱jw c̱hen' nach ja'aclene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na' Jesúsen' gwze'e yelate' na' ble'ede' Jacobon' xi'iṉ Zebedeo na' len beṉe' biše' Juan, zjayo'e to ḻo' barcw ḻen x̱agaque', chesyeyonšagüe' yix̱jw c̱hegaquen'. Na' ḻecze gox Jesúsen' ḻegaque' šja'aclene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na' ḻa' gosontie' barcon' ḻo na' x̱agaque' Zebedeon' na' ja'aclene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na' Jesúsen' gwyeje' yogo' yež ca' zjachi' gan' mbane Galilea, bsed blo'ede' beṉe' ca' zjaže' to to yodao' c̱he chio' beṉe' Israel. Na' gwdix̱jue'ede' diža' güen can' ṉabia' Diosen' yic̱hjlaždao' beṉe' yosozenag c̱he'. Na' Jesúsen' beyone' beṉe' ca' chese'e bite'teze yižgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na' doxen nación Siria gwxoa diža' yogo' da' güen da' ben Jesúsen'. Nach beṉe' Siria ca' jasesane' yogo' beṉe' chesacšene lagüe'na', beṉe' chese'e zan yižgüe', beṉe' chesey chesela, beṉe' zjayo'o zjanyaz da' x̱igüe' yic̱hjlažda'ogaque' len beṉe' chesaz šon na' beṉe' natsi' cuerp c̱hegaquen'. Na' beyone' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na' zan beṉe' gosao' ḻe', beṉe' za'ac distritw Galilea na' distritw Decápolis, na' beṉe' za'ac ciuda Jerusalén, na' beṉe' za'ac yezica'chle yež da' zjachi' distritw Judea, na' beṉe' za'ac yešḻa'a yegw Jordán. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na' Jesúsen' cate' ble'ede' beṉe' zan zjanžag, na' gwloe' gwchi'e to ḻo ya'a. Na' beṉe' ca' zjanaque' ḻe' txen gosebigue' gan' chi'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nach gwzolao bsed blo'ede' ḻegaque', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Mbalaz zoa le'e chacbe'ele chyažjele gaclen Diosen' le'e, ḻe ba chzenagle c̱he Diosen' cont chnabi'e yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Mbalaz soa le'e chacyaše'laže'le, ḻe Diosen' yeyoe'xenḻaže' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Mbalaz zoa le'e chzex̱jwlaže'le len Diosen' na' len beṉac̱hen', ḻe gon Diosen' cont gac ḻo na'le doxen yežlion' can' gwne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Mbalaz zoa le'e chzelaže'chguale gacle beṉe' güen len Diosen', ḻe ba cheyon Diosen' le'e beṉe' güen lagüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Mbalaz zoa le'e cheyaše'le beṉe' yoble, ḻe ḻecze ca' Diosen' yeyaše' yeži'ilaže'de' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Mbalaz zoa le'e ba nacle beṉe' laždao' xilaže', ḻe šjayzoale txen len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Mbalaz zoa le'e chego'ole yeḻa' chxenḻaže' c̱he beṉe' chesediḻe, ḻe Diosen' ṉe' nacle xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Mbalaz zoa le'e chosoc̱hi chososaca' beṉe' le'e lagüe dan' chonḻe dan' nac güen lao Diosen', ḻe chzenagle c̱he Diosen' cont chnabi'e yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Na' mbalaz soale še dan' chejnilaže'le neda' chesezi'diža' beṉe' le'e na' chososaca'zi'e le'e na' chosox̱ie' diža' güenḻaže' c̱hele. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ḻe yebechgüe na' ḻe soa mbalaz, ḻe Diosen' gone' cont gacchgua da' güen c̱hele cate' yežinḻe gan' zoe'na'. Can' chesonde' le'e, ca'czen' goson da' x̱ozxta'ocho len da' beṉe' ca' goso'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Le'e nacle ca zede', ḻe zede' chaclenen cont bi cuiayi' no yid bela', na' le'e chonḻe cont beṉac̱hen' cbi chesonteque' da' mal. Perw še zeden' bich bi zxi' naquen, ¿nacxe goncho cont yeyaquen zxi' da' yoble? Na' bich bi zacan', ḻete c̱ho'oṉchon na' gwlej gwšošj beṉe' ḻen. Na' le'e še cbich gonḻe can' chazlaže' Diosen', nacle ca zede' dan' bich bi zxi' naquen. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Na' le'e nacle ca be'ni' dan' chaclenḻe beṉe' cont cheseṉezde' nac chaclaže' Diosen' yesone'. Na' dan' chonḻe can', nacle ca to ciuda da' chi' to ḻo ya'a, ḻe yogo'ze beṉe' chesele'eden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Notno gwguaḻa' to yi' na' gwdosen' to caj, san chde'en ḻe'e ze'e cont chseṉin' len yogo' beṉe' že' ḻo' yo'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na' ca nac le'e, cheyaḻa' soateze soale gonḻe da' güenṉa' cont yesele'e beṉe' na' yesonxene' X̱acho Dios ben' zoa yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Bitw gaquele še neda' za'a zedeyena' cont ley dan' bzoj da' Moisésen' na' dan' bosozoj yezica'chle beṉe' ca' goso'e xtiža' Diosen' cani' bich yesonen žin. Za'a cont gac can' ža yogo'ḻoḻ Xtiža' Diosen' dan' bosozoj beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da' ḻi žia' le'e, te c̱he yežlio nga len da' ca' chle'echo ḻe'e yaban', perw ṉe to letr dao' ṉe to punt dao' dan' nyoj ḻe'e leyna' bi gac yexin, san gac yogo'ḻoḻ dan' nžia bia' Diosen' gac. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Da'nan' note'tezle še bi gonḻe can' žanṉa', la'czḻa' še naquen ḻa'zelagüe to da' dao', na' še ḻecze gwlo'ele beṉe' yoble bi yosozenague' c̱hen, Dios ben' zoa yaba chnabi'e ṉe' bi nacle beṉe' blao len ḻe'. Na' note'tezle še gonḻe can' žanṉa', na' še ḻecze gwlo'ele beṉe' yoble yesone' ca', Diosen' ben' zoa yaba chnabi'e ṉe' nacle beṉe' blao len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chnia' le'e, beṉe' fariseo ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés bitw zjanac yic̱hjlažda'ogaquen' güen lao Diosen'. Na' še yic̱hjlažda'olen' bi gacchen güen lao Diosen' clel ca c̱he beṉe' ca', bitw yežinḻe yaban' gan' zoa Diosen' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na' ḻecze bsed blo'e Jesúsen' ḻegaque' gože'ne': ―Ba ṉezele can' bzejni'i Moisésen' beṉe' ca' gosenita' cani', gwne': “Nono gotle. Na' še no got ḻjež beṉac̱he', justis ca' yesec̱hoglagüe' c̱he' cheyaḻa' gate'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na' neda' žia' le'e, note'tezle še chža'a ḻjež beṉac̱hle, zacan' yesec̱hoglagüe' gata' castigw c̱hele. Na' note'tezle še chzi'diža' ḻježle, zacan' yesoṉ beṉe' blao ca' chesenabia' nación Israel c̱hechon' castigw c̱hele. Na' note'tezle še chado'diža' ḻježle, zaca'czen' yeseḻa' Diosen' le'e ḻo yi' gabiḻ. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Cheyaḻa' soacho binḻo len ḻjež beṉac̱hcho. Na' ḻa'czḻa' cate' ba zoale ḻo' yodao' cont gwnežjwle bi dan' gwnežjwle gonxenḻe Diosen', še šjasa'laže'le ba benḻe da' mal contr to beṉe' ḻježle, ");
INSERT INTO zpqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na'ze cheyaḻa' gwcua'aṉle šlož dan' nox̱e'len' na' šjenḻe cont yezoale binḻo len beṉe' ḻježlen'. Yeyoža' guaque šjasanḻe dan' ba gwlejle cont gonxenḻe Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Cate' to beṉe' gagüe' xya c̱hele na' c̱he'e le'e lao justis, šlac ngo'ole nezen' ḻe yeyiljwlaže' nac gonḻe cont yezoale binḻo len ḻe' cont bi c̱he'e le'e lao justisen'. Še bitw gonḻe ca', cate' žinḻe lao justisen', nach gone' le'e ḻo na' beṉe' ca' yososeyjue' le'e ḻižya. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Da' ḻi žia' le'e, bitw yebeje' le'e še biṉa' c̱hixjwle doxen dan' chaḻa'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ba ṉezele ley dan' bzoj da' Moisésen' žan: “Bitw gata'lenḻe no'ole bi nac no'ol c̱hele o beṉe' byo bi nac beṉe' c̱hele.” ");
INSERT INTO zpqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na' neda' žia' le'e, note'tezle še chṉa'le to no'ole na' chzelaže'lene', ba naple doḻa'. Ḻe tozecze ca malen' ba chonḻe ḻo' lažda'olen' len dan' chon beṉe' chzoa xtoe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Na' še yejlaolen' chonen cont gonḻe da' xiṉj, cheyaḻa' cuejyic̱hjle da' malen' chonḻe. Yejṉi'a cuiayi' yejlaolen' clel ca cuiayi'le ḻo yi' gabiḻen' ṉec̱he ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na' še na'le chonen cont gonḻe da' xiṉj, cheyaḻa' cuejyic̱hjle da' malen' chonḻe. Yejṉi'a cuiayi' na'le clel ca cuiayi'le ḻo yi' gabiḻ ṉec̱he ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ḻecze ṉezele ley dan' bzoj da' Moisésen' žan: “Note'teze beṉe' yele'e len no'ol c̱he', cheyaḻa' c̱has to yiš ga güen' diža' ḻe besyele'ena'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na' neda' žia' le'e note'teze beṉe' chele'e len no'ol c̱he', ḻen ṉeztede' no'ole c̱hen' bitw naque' to no'ole chzoa xtoe', chone' cont gaque' ca to no'ole beṉe' chzoa xto. Na' note'teze yošagna'lene' to no'ole beṉe' bela'a len beṉe' c̱he', ḻecze tozcze ca da' xiṉj gone' len dan' chon beṉe' chata'lene' no'ol c̱he beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Na' ḻecze ba ṉezele can' bzejni'i da' Moisésen' da' x̱ozxta'ocho ca': “Cate' gwzoale testigw X̱ancho Diosen', cheyaḻa' gonḻe con can' ba gwnalen'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Perw neda' žia' le'e gwbat ṉale quinga c̱he bite'teze: “Yabana' zoan testigw c̱hia' cho'a diža' ḻi”. Bi ṉale ca' ḻe yaba nan' zoa Diosen' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na' ṉeca ṉale: “Yežlion' zoan testigw c̱hia' cho'a diža' ḻi”, ḻe yežlion' den xṉi'a Dios. Ṉeca ṉale: “Ciuda Jerusalénṉa' zoan testigw c̱hia' cho'a diža' ḻi”, ḻe naquen ciuda c̱he Dios ben' naque' ḻa'zelagüe beṉe' chnabia'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na' ṉeca ṉale: “Yic̱hja' zoan testigw c̱hia' cho'a diža' ḻi”, ḻe bitw gac gonḻe cont yiša' yic̱hjlen' yesyeyaquen da' šiš o yesyeyaquen da' gasj. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Še žale guaquen, gacczen; še žale bi gac, bi gacczen. Ḻe bichle diža' da' ṉale cont yesejḻe'e c̱hele, zan' c̱he Satanás dan' chnabia' da' x̱igüe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ṉezele ley dan' bzoj da' Moisésen' žan: “Še to beṉe' gone' zi' yejlaolen', guac gonḻe zi' yejlagüen', na' še to beṉe' x̱ope' to ḻayle, guac x̱ople to ḻayen'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Perw neda' žia' le'e, bitw gwžonḻe gwsaca'zi' beṉe' le'e. Še to beṉe' cape' šḻa'a x̱aga'le, ḻe güe' dan' yešḻa'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Še to beṉe' chagüe' xya na' che'nde' que'e xcamisle, ḻe güe' latje que'e len xadoṉ c̱helen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na' še to beṉe' blao gone' byen šejlenḻene' gua'le yoa' c̱hen' do gašj hor, ḻe šejlene' ḻe guan' c̱hop ca'te'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na' še bi dan' chṉabe beṉe' le'e, ḻe güen'. Na' ḻe cuej še bi da' chṉabe' cuejlene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Na' ḻecze ba ṉezele ley c̱helen' žan: “Cheyaḻa' gaquele beṉe' migw c̱hele na' gue'ele beṉe' chgue'ede' le'e.” ");
INSERT INTO zpqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Perw neda' žia' le'e, cheyaḻa' gaquele beṉe' chgue'ede' le'e, na' cheyaḻa' ṉabele Diosen' gac güen c̱he beṉe' chesezi'diže' le'e. Ḻe gon binḻo len beṉe' chesegue'ede' le'e, na' ḻe yoḻ güiž Diosen' cont gac güen c̱he beṉe' ca' chososacazi'e le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Še gonḻe ca', gwlo'ele nacle xi'iṉ Diosen' ben' zoa yaban'. Ḻen' chone' chla' gwbižen' cont chseṉin' c̱he beṉe' zjanaque' beṉe' güen lente c̱he beṉe' zjanaque' beṉe' mal. Na' ḻecze chone' yejw par beṉe' zjanaque' beṉe' güen len beṉe' zjanaque' beṉe' mal. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Še chaquele šinze beṉe' chacde' le'e na' bi chaquele beṉe' yoble ¿bixc̱hen' chbezle goṉ Diosen' da' güen c̱hele? Con can' cheson beṉe' güec̱hixjw ca' chonḻe, beṉe' ca' žale zjanaque' beṉe' xi'achgua. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na' še con chguaple tiox beṉe' biše' ḻježle ca'ze ¿chaquele güenṉa' chonḻe da' chonḻe ca'? Bitw chonḻe güen, ḻe ca'czen' cheson beṉe' ca' bi zjanombi'e Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cheyaḻa' gacle beṉe' šagüe' beṉe' güen len note'teze beṉe' con can' nac X̱acho Diosen' ben' zoa yaban' beṉe' šagüe' beṉe' güen. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Cate' gonḻe to da' güen, bitw gonḻen cont yesele'e beṉe' can' chonḻen' na' yesonxene' le'e, ḻe še chonḻe ca', X̱acho Dios ben' zoa yaba bitw gone' ga gac güen c̱hele. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Da'nan' cate' gwnežjwle to beṉe' da' chyažjde', bitw gwnežjwlen par yeseṉeze beṉe' ca dan' chonḻen'. Beṉe' gwxiye' ca' chosonežjue' bi da' chosonežjue' do ḻo' yodao' na' do chanez par yeseṉeze beṉe' na' yeseṉe' güen c̱hegaque'. Da' ḻi žia' le'e, ba gosacxencze' lagüe da' chesone' ca', perw Diosen' bitw gone' ga gac güen c̱hegaque' še ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","San le'e, še bi da' gwnežjwle to beṉe', ḻe gwnežjon šižize. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gonḻen ga cbi yesacbe'e beṉe' na' cbi yesonxene' le'e, nach X̱acho Diosen' ben' chle'ede' yogo' dan' choncho gone' ga gac güen c̱hele ga yesele'e yogo' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Cate' yoḻ güižle Diosen', bitw gonḻe can' cheson beṉe' gwxiye' ca'. Ḻegaque' chesyebede' chesezeche' chosoḻ güiže'ne' ḻo' yodao' c̱hegaque', na' do squin chanez. Chesone' ca' cont yesele'e beṉe' can' chesone'na'. Da' ḻi žia' le'e, ba gosacxenczen' lagüe da' chesone' ca', perw Diosen' bitw gone' ga gac güen c̱hegaque' še ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na' cate' yoḻ güižle Diosen', ḻe yeyo'o ḻo' yo'o c̱hele na' gwseyjwle puerten' na' güe'le diža' len Diosen' ben' cbi chle'echo ḻa'czḻa' zoe' len chio'. Na' X̱acho Diosen' ben' chle'ede' yogo' dan' chonḻe gone' ga gac güen c̱hele. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Na' cate' yoḻ güižle Diosen' bi güe'le diža' zan can' cheson beṉe' ca' bi zjanombia' Diosen'. Ḻegaque' chesacde' lagüe' dan' cheso'e diža' zan Diosen' gwzenague' c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bitw gonḻe can' chesone'na'. Ca nac X̱acho Diosen', cate' za' ṉabelenen' ba ṉezczede' bi dan' chyažjele. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Quinga yoḻ güižlene': X̱ato' beṉe' zoa yaba, chṉabto' yogo'ḻoḻ beṉe' yesonxene' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Zelaže'to' ṉabi'o yic̱hjlaždao' yogo' neto' beṉac̱h. Gacšca can' chazlažo' yežlio nga can' chac yabana'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ca nac dan' che'ej chagwto' tža tža, beṉšcan ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na' bezi'xenšca c̱heto', ḻe lencze neto' chezi'xento' c̱he ḻjež beṉac̱hto' bite'teze da' chesonde' neto'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na' bitw go'o latje soa da' gwžigan' neto' gonto' da' mal, san bcuas bcue'ejšca neto' len da' mala'. Le'na' chnabi'o na' napo' yeḻa' guac na' naco' beṉe' zaca' juisyw toḻi tocaṉe. Ca'czen' gacšca. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Na' še chezi'xenḻe c̱he ḻjež beṉac̱hlen' bite'teze da' chesonde' le'e, ḻecze X̱acho Diosen' ben' zoa yaban' yezi'xene' xtoḻa'len'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Perw na' še le'e bi chezi'xenḻe c̱he ḻjež beṉac̱hle, ḻecze ca' X̱acho Diosen' bitw yezi'xene' c̱helen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Cate' le'e gonḻe gwbas cont gonxenḻe Diosen', bitw gon cho'alaolen' ca c̱he beṉe' chegüine'chgüe', can' cheson beṉe' gwxiye' ca'. Ḻegaque' chesone' ca' contze chesele'e beṉe' ḻe chesone' gwbas na' yesonxene' ḻegaque'. Da' ḻi žia' le'e, ba gosacxencze' lagüe da' chesone' ca', perw Diosen' bitw gone' ga gac güen c̱hegaque' še ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","San le'e cate' gonḻe gwbas, ḻe gwpa'a yic̱hjle na' ḻe c̱hib cho'alaole. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ḻe gon ca' cont bi yesacbe'e beṉe' chonḻe gwbas, san gacbe'e toz X̱acho Dios ben' zoa len chio' ḻa'czḻa' bi chle'echone'. Na' X̱acho Diosen' ben' chle'e yogo' da' choncho gone' cont gacxenḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Bitw co'ošagüe'le da' zc̱ha'o da' zjanac da' zaca' da' zjade yežlio nga, ḻe yesebiayin'. Baḻ da' zjade yežlio nga chesaljen be dao' chesagwban', na' yebaḻen chesezen xc̱he'en, na' ḻecze chaš beṉe' gwban na' yeseque'en. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","San ḻe gaque Diosen' cont goṉe' da' šagüe' da' güen c̱hele da' bi te c̱hen cate' yežinḻe yaban' gan' zoe'na', da' bi šo'ba', na' ṉeca sen xc̱he'en, na' ṉeca gac šo' beṉe' gwban yeseque'en. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ḻe gan' de dan' chaquelen' na' zoa yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Žia yejlaole cont chle'ele. Še bitw bi chaquen, chle'eczele binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Perw še yejlaolen' bi naquen binḻo, bitw chle'ele. Ca'czen' naquen len yic̱hjlažda'olen'. Da' ḻicze ḻeca nc̱hoḻ yic̱hjlažda'ole še bi chzenagle c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Notno gac gon žin len c̱hope x̱ane' to ši'ize, ḻe še gone' ca', gue'ede' to x̱an žinṉa' na' gacde' yetoe'; o gone' žin c̱he toe' do yic̱hj do laže' na' c̱he ben' yeto gonen' to chža'alaže'ze. Ḻecze ca' le'e bitw gac gonḻe xšin Diosen' do yic̱hj do laže'le na' gonte xšinḻe cont gacle beṉe' gwṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Da'nan' žia' le'e, bi gacžejlaže'le bi da' ye'ej gagwle šlac mbanḻe, na' ḻecze ca' bi gacžejlaže'le c̱he xaḻana'le. Zaca'ch yeḻa' mban c̱helen' ca yeḻa' guagw. Ḻecze ca' cuerp c̱helen', zaca'chen ca xaḻana'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ḻe gon xbab ca nac be ca' zjažia x̱il ben' chesaš ḻo be', bitw chesazba', bitw cheselapba', ṉeca zoa da'a xoa' c̱hegacba', perw na' X̱acho Diosen' ben' zoa yaba chguagwcze'ba'. ¡Nacchle zaca' le'e ca be ca' zjažia x̱ilen'! ");
INSERT INTO zpqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na' ṉe tole bi gac yostoṉ cuinḻe gašje metr še con cue' yic̱hjle toṉle. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Na' ¿bixc̱hen' chbec yic̱hjle xaḻana'le? Ḻe gon xbab ca nac yej ca' da' zjaze yix̱e' chesecha'oczen'. Bibi žin chesonen, ṉeca chesaḻjen do. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na' žia' le'e, da' rey Salomón gocue' lache' güen juisyw, perw bitw bežinḻaže' xaḻane'na' ca yeḻa' xdan c̱he yej ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diosen' none' xdan da' ca' ze yix̱en' ḻa'czḻa' to c̱hop žaze nitan' na' chosozeyen'. Nacchxe gon Diosen' len le'e gwleccze yic̱hje' goṉe' yogo' da' chyažjele, le'e late' lasze chejḻe'le c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Da'nan' bitw cuec yic̱hjle c̱he bi dan' chyažjele, ṉale': “¿Bin' ye'ej gagwcho na' bin' gacwcho?” ");
INSERT INTO zpqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Beṉe' ca' bi chesonxene' Diosen' con chesoe'laže' bi da' gata' yese'ej yesagüe' na' c̱he xaḻana'gaque'. Perw X̱acho Diosen' ben' zoa yaban' ṉezczede' bi da' ca' chyažjele. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cheyaḻa' güe'laže'le gwzenagle c̱he Diosen' cont ṉabi'e yic̱hjlažda'olen' na' cont gacle beṉe' güen len ḻe', ḻenṉa' naquen da' žialaoch, na' yogo' da' ca' chyažjele, goṉcze Diosen' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bitw cuec yic̱hjle c̱he bi dan' gac gwx̱e güižj, ḻe decze da' cuec yic̱hjcho tža tža. Da'nan' to to ža con cuec yic̱hjcho c̱he dan' chac ca hora'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Bitw gonḻe xbab zaca'le ṉale beṉe' zjanape' doḻa'. Še ṉale c̱he beṉe' zjanape' doḻa', ca'cze Diosen' ṉe' le'e naple doḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Can' chosbaga'le beṉe' žale zjanape' doḻa', ḻecze can' yosbaga' Diosen' le'e ṉe' naple doḻa'. Con can' chonḻe len beṉe', ḻecze can' gon Diosen' len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bixc̱hen' chṉa'le beb dao' dan' yo'o ḻo' yejlao beṉe' ḻježle na' bi chacbe'ele naquech beb xen dan' yo'o ḻo' yejlaolen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na' še le'e yo'o to da' xench ḻo' yejlaolen' ¿nacxec̱hen' che'le beṉe' ḻježlen': “Beṉ yebeja' beb dao' dan' yo'o ḻo' yejlaguon'”? ");
INSERT INTO zpqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Beṉe' güex̱oayag! Zgua'tec ḻe yebej beb xen dan' yo'o ḻo' yejlaolen', nach le'ele binḻo cont yebejle dan' yo'o ḻo' yejlao beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Perw bitw güe'tezle xtiža' Diosen' len beṉe' ca' cheson yic̱hjlaogüe' cbi chesaclaže' yosozenaguen', ḻe xož yesonde' le'e znia ca cheson baḻ beco' še bi chazlaže'ba' bi da' chosonežjue'ba'. Na' še güe'tezle xtiža' Diosen' len beṉe' ca' cheson yic̱hjlaogüe', xož yosolej yosošošje' diža' dan' güe'lenḻene'. Ca' cheson coš len da' cbi chesaclaže'ba' yesagwba'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Še žan bi da' chyažecho, chṉabchon. Še žan to da' chaclaže'cho želecho, chyiljwchon. Še žan chaclaže'cho saljw beṉe' puert c̱he' na' ṉecho cho'a puerta' cont saljue'. Na' ca'cze cheyaḻa' ye'le Diosen' cate' bi da' chyažjele, o bi da' chaclaže'le gone'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Na' note'tezle še bi da' chṉabelene', goṉczen'. Na' še bi dan' che'nele ṉezele, gwzejni'iczden' le'e. Na' še žan chaclaže'le gac to da' gac, yoḻ güižle Diosen' can' chon to beṉe' chṉie' cho'a puert, nach Diosen' gone' cont gacczen. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Na' le'e x̱a bidao', še xi'iṉle ṉabebe' le'e yetextil ¿gwnežjwlebe' to yej? ");
INSERT INTO zpqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Na' še ṉabbe' yid beḻ gagwbe', ¿gwnežjwlebe' to be x̱igüe'? ");
INSERT INTO zpqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ḻa' nacle beṉe' mal, ṉezele chnežjo xi'iṉle to da' güen. Nacchxe güen gon X̱acho Diosen' ben' zoa yaban' len beṉe' chṉab lagüe'na' bi dan' chyažjde'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Na' con yogo' da' güen da' chaclaže'le yeson beṉac̱hen' len le'e, ḻecze ca' cheyaḻa' gonḻe len ḻegaque', ḻe can' zejen da' nyoj ḻe'e ley dan' bzoj da' Moisésen' na' dan' bosozoj da' beṉe' ca' goso'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Lao yeḻa' mban c̱hecho c̱hope nez de, to nez güen na' to nez mal. Nez malen' zaca'leben ca to nez yo to nez laga' dan' chaquele ḻeca mba naquen cont talen, na' beṉe' zan cheseque'en. Perw cheyaḻa' gonḻe byen šo'le nez güenṉa' ḻa'czḻa' chaquele naquen ca to nez las, to nez zdebe, ḻe nez malen' chežinen gabiḻ gan' saca'zi'le toḻi tocaṉe. Na' nez güenṉa' chežinen yaba ga banḻe toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Cheyaḻa' gwsaca'le cont bi šejḻe'le xtiža' beṉe' ca' chesonḻaže' chesene' xtiža' Diosen' cheseyix̱jue'ede'. Xdanchgua cheso'e dižan', ḻe chesaclaže' gonḻe xbab zjanaque' beṉe' güen. Perw zjanaque' beṉe' laždao' xi'a na' chesaclaže' yosožiaye'e le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Con can' nac da' chbia to to yaguen' ṉezecho bi yaga'. Ca nac yag yeše' bitw chbian uvas na' ṉeca yag ḻay chbian yixgüigw. Ca'czen' cheyaḻa' gacbe'ele beṉe' ca' yeseziye'e le'e cate' le'ele dan' chesone'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yag dan' nac yag güen, frut güencze chbian, na' yag da' bi nac güen, ḻecze frut da' bi nac güen chbian. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bitw ṉacho to yag frut güen chbian frut da' bi nac güen, na' ṉeca ṉacho dan' bi nac güen chbian da' nac güen. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na' yogo'te yag frut da' bibi chbia, c̱hog x̱an yaga' ḻen na' gwzeyen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na' can' nac dan' cheson to to beṉe', ṉezecho še zjanaque' beṉe' güen o beṉe' mal. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Beṉe' zan chese'e neda': “Naco' X̱ana'”, perw gague yogüe' yesyežine' yaban' gan' zoa Diosen' chnabi'e. Beṉe' ca' cheson can' chazlaže' X̱a' Diosen' ben' zoa yaban', ḻegaczen' yesyežine' yaban' gan' zoe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cate' žin ža yosodie' cuent lao Diosen', beṉe' zan yesi'e neda': “X̱ana', goclen neto' ṉa'a, ḻe ba gwdix̱jue'eto' xtižo'na'. Na' ḻecze ca' bza' bzetjto' lao' bebejto' da' x̱igüe' ca' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. Na' ḻecze bza' bzetjto' lao'na' bento' da' zan yeḻa' guac.” ");
INSERT INTO zpqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Perw na' yapa' ḻegaque': “Bitw nombi'a le'e. Ḻe šjaya'ac ca'ale le'e beṉe' güen da' xiṉj.” ");
INSERT INTO zpqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Beṉe' chzenag xtiža'na' na' chone' can' žia'na' zaca'lebde' ca to beṉe' sina' beṉe' ben liže' na' gwdix̱jue' lenen len yej gual. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na' goc yejw zil juisyw na' betj yegw gwyec̱hjen liže'na' na' gwyec̱hj be' bdono'. Perw bitw gosezoen yosochix̱en ḻen dan' gwdix̱jue' lenen de yej. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na' beṉe' chzenag xtiža'na' perw bitw chone' can' žia'na', zaca'lebde' ca to beṉe' tont beṉe' bzoa ližen' ḻo yox. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na' goc yejw zil juisywna' na' betj yegon' gwyec̱hjen liže'na' na' gwyec̱hj be bdono'. Nach ližen' bebix̱en gwžiayin'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na' cate' beyož be' Jesúsen' diža' ca', beṉe' ca' že' na' besyebande' can' bsed blo'eden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ḻe can' bzejni'ide' nacbia' ṉezde' cayaṉen' nac xbab c̱he Diosen', gague bzejni'ide' can' chosozejni'i beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisésen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Beṉe' zan zesyenagüe' Jesúsen' cate' beyetje' ya'ana'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nach to beṉe' che'ede' yižgüe' dan' nzi' lepra gwbigue' lao Jesúsen' na' bzoa xibe' lagüe'na' gože'ne': ―X̱ana', še chaclažo' guac yeca'o yižgüe' dan' che'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nach Jesúsen' bḻi ne'e na' gwx̱oen' yic̱hje' na' gože' ḻe': ―Chaclaža' yeyacdo'. Beyaque. Nach ḻa' beyactie' ca nac yižgüe' dan' che'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nach Jesúsen' gože' ḻe': ―Notno yo'o can' ba beyona' le'. Con gwyej jaṉa' bx̱oza' cont le'ede' bac̱h beyacdo'. Na' bnežjw da' cheyaḻa' gwnežjo' dan' non Moisésen' mandadw cont yeyaco' xilaže' len ley c̱he Diosen'. Ben ca' cont yogo' beṉe' yeseṉezde' ba beyacdo'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na' cate' bežin Jesúsen' Capernaum to x̱an soldadw beṉe' Roma ḻa' bšagte' ḻe'. Na' gota'yoede' Jesúsen', ");
INSERT INTO zpqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","gože'ne': ―X̱ana', xmosan' die' ližan' chacšenchgüede'. Natsi' cuerp c̱hen' na' chžaglaochgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nach Jesúsen' gože' x̱an soldadoa': ―Sa'lena' le' na' yeyona'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Perw na' x̱an soldadoa' gože'ne': ―X̱ana', bitw naca' beṉe' zaque' par sa'o liža'na'. Ngateze ben mandadw yeyac xmosan' na' yeyaccze'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Neda' zoa beṉe' chnabi'e neda', perw ḻecze nita' soldadw c̱hia' na' chnabia'gaca'ne'. Cate' chapa' toe': “Gwyej”, na' cheje', na' cate' chapa' yetoe': “Da”, na' chide', na' cate' chapa' xmosa': “Da' nga gono'”, na' chonen'. Nan' ṉezda' con ṉao' yeyac xmosan' na' yeyaccze'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na' Jesúsen' cate' bende' xtiža' x̱an soldadoa' bebande' na' gože' beṉe' ca' zjanagüe' ḻe'na': ―Da' ḻicze žia' le'e, ṉe toze beṉe' Israel biṉa' šejnilaže'chgüe' neda' ca benga bi naque' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Žia' le'e, beṉe' zan za'ac doxen yežlion' šjasyenite' txen len da' x̱ozxta'ocho Abraham, Isaac na' Jacob yaban' gan' zoa Diosen' chnabi'e na' yesebi'e cho'a mes yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na' ca nac beṉe' nación Israelen' ben' gwlej Diosen' cont yesenite' len ḻe', choj beṉe' zan bitw yesejnilaže' neda'. Da'nan' seḻe' ḻegaque' ḻo' yi' gabiḻ gan' nac c̱hoḻ na' yesebežyaše' na' yesagwxejte ḻaye' dan' yesežaglaochgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Beyož gwna Jesúsen' ca' nach gože' x̱an soldadoa': ―Guac yeyejo'. Yeyaque xmoso'na', con can' chejḻi'o gac c̱he'. Na' xmos x̱an soldadoa' ḻa' beyactede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na' gwyej Jesúsen' liž Pedroa', na' ble'ede' taobi'iṉ c̱he Pedroa' die' yo'e da' ḻa. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesúsen' bex̱ue' ne'e na' ḻa' bechojtie' da' ḻan'. Nach ḻa' gwyaste no'olen' bsiṉi'e da' gose'ej gosagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na' cate' ba gwx̱in, besežin beṉe' gan' zoa Jesúsen' zjanc̱hi'e beṉe' zan zjayo'o zjanyaz da' x̱igüe' yic̱hjlažda'ogaquen'. Jesúsen' con bene' mandadw na' besyechoj da' x̱igüe' ca'. Ḻecze beyone' yogo' beṉe' ca' chesacšene. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bene' ca' cont goc can' ža Xtiža' Diosen' dan' bzoj da' Isaías c̱he' cani', žan: “Ḻe'na' yeque'e yeḻa' chžaglao c̱hecho na' yeque'e yogo' yižgüe' c̱hechon'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gwde na' ble'e Jesúsen' ba besežin beṉe' zan zjanyec̱hjde' ḻe', nach bene' mandadw len beṉe' ca' zjanaque' ḻe' txen cont yeseḻague' yešḻa'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na' bchoj to beṉe' chsed chlo'ede' dan' bzoj da' Moisésen' nach gwbigue' lao Jesúsen' na' gože'ne': ―Maestrw, sa'lena' le' gate'tez šejo'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nach gož Jesúsen' ḻe': ―Nita' xišna' beza' na' ḻecz chesyežin xišna' be dao' ca' zjazoa x̱il, be chaš ḻe'e yaba, perw bibi xišna' neda' de ga yezi'laža', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na' bchoj yeto ben' naque' Jesúsen' txen na' gože'ne': ―X̱ana', sa'lena' le' perw za' got x̱a'. Beṉšca latje zgua'tec šjaycuaša'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesúsen' gože'ne': ―Yo'o len neda'. Beṉe' ca' zjanac yic̱hjlažda'ogüe' ca c̱he beṉe' guat, ḻegaque' guaccze yosocuaše' yezica'chle beṉe' guat. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Beyož be' Jesúsen' diža' ca', gwyo'e ḻo' barcon' len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na' šlac zej barcon' ḻo nisen' gwzolao gwyec̱hj to be' bdono' na' nisdaon' ḻeze chas chatan' na' gwzolao cheyož nis ḻo' barcon', perw ba chtas Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nach bosyosbane' ḻe' gosi'ene': ―¡X̱anto'! ¡Bosla chio'! ¡Bach chbiayi'cho! ");
INSERT INTO zpqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nach Jesúsen' gože' ḻegaque': ―¿Bixc̱hen' chžebtecle ca'? ¿Nacxec̱hen' bi chejḻe'le c̱hia'? Na' gwyase' na' gwdiḻe' be' bdonon' len nisdaon', na' ḻa' gosebe'žiten. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na' beṉe' ca' zjanaque' Jesúsen' txen besyebande' can' bene'na', nach gose' ḻježgaque': ―¿Noxe benga? lente be' bdono' na' len nisdaon' chosozenaguen c̱he da' že'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na' besežine' yešḻa'a nisdaon' gan' chi' laž beṉe' Gadara ca'. Na' cate' bechoj Jesúsen' ḻo' barcoa' bosošag c̱hope beṉe' ḻe', beṉe' zjayo'o zjanyaz da' x̱igüe' yic̱hjlažda'ogaque'. Beṉe' quinga ba nite' capsantw na' gosacchgüe' beṉe' znia juisyw len beṉe' chesyežague' na' gague no chac ta tnez. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na' bososye'e gose'e Jesúsen': ―¿Bixc̱hen' chgoša' chlaže' c̱hio' len neto', Jesús? Naco' dogualje Xi'iṉ Dios. ¿Zao' gwsaco' neto' ṉa'a cate' biṉa' žin ža si'to' castigw? ");
INSERT INTO zpqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na' gaḻa'ze chesaš zan coš chesagwba'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nach da' x̱igüe' ca' gosata'yoen Jesúsen' gose'en ḻe': ―Še yebejo' neto' yic̱hjlaždao' beṉe' quinga, gwseḻa' neto' gan' nita' coš ca' na' beṉ latje šjayo'oto' yic̱hjlažda'oban'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nach gož Jesúsen' ḻegaquen: ―Ḻe šjayo'o. Nach besyechojen yic̱hjlaždao' beṉe' ca' na' jaseyo'on yic̱hjlaždao' coš ca'. Na' besyeyetjses coš ca' ḻe'e ya'a gan' nita'ban', na' jaselažo'ba' ḻo' nisdaon' ga gosatba' gose'ejba' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na' beṉe' ca' chosoyoe' cošen' besele'ede' dan' ba goquen na' bosyoxoṉje' jasyeyeže' beṉe' lagüe' yež yogo' can' ba goquen' na' can' ba besyeyac beṉe' ca' goso'o gosaz da' x̱igüen' yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nach yogo' beṉe' ca' že' yeža' jasešague' Jesúsen' na' cate' besele'ede'ne' gosata'yoede' ḻe' yeze'e lažgaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nach Jesúsen' beyo'e ḻo' barcon' len beṉe' ca' zjanaque' ḻe' txen besyeḻague' yešḻa'a nisdaon' par besyežine' Capernaum gan' ba gwzoacze' sša. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na' besežin x̱oṉj beṉe' zjanḻene' to beṉe' xiṉj beṉe' bi chda šḻa'a ṉi'a ne'e, zjanx̱oe' ḻe' to ḻo cam dao'. Cate' gocbe'e Jesúsen' ḻe gosejnilaže'ne' nach gože' beṉe' güe'na': ―Bebe xi'iṉa'. Ba bezi'xena' xtoḻon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na' baḻ beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisésen' gosende' dan' gož Jesúsen' beṉe' güe'na' na' gosone' xbab ḻo' yic̱hjlažda'ogaquen' gosene': “Benga chṉie' diža' bya' c̱he Dios chne' ca', ḻe chon cuine' ca Dios.” ");
INSERT INTO zpqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesúsen' gocbe'ede' ca nac da' cheseza'laže', na' gože' ḻegaque': ―¿Bixc̱hen' chza'laže'le ca' ḻo' yic̱hjlažda'olen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Še yapa'ne': “Ba bezi'xena' xtoḻo'na',” bi ṉezele še napa' yeḻa' gwnabia' cont yezi'xena' xtoḻen'. San še yapa'ne': “Gwyas na' gwda”, na' nacbia' še napa' yeḻa' guac gac can' gwnian'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Perw neda' naca' beṉe' gwseḻa' Dios golja' beṉac̱h gwlo'eda' le'e ṉa'a zoa' yežlio nga napa' yeḻa' gwnabia' cont yezi'xena' xtoḻa' beṉac̱hen'. Nach gože' beṉe' xiṉja': ―Beyas, beyoa' xcamon' na' beyej ližo'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na' beyas bena', beze'e zjayde' liže'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na' beṉe' ca' besele'ede' can' goquen' besežebchgüe'. Na' gosonxene' Diosen' dan' be'e yeḻa' guac c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na' Jesúsen' gwdie' latje gan' chi' Mateo chc̱hixjue' impuesto. Na' cate' ble'ede' ḻe' na' gože'ne': ―Da len neda'. Na' gwzoža' Mateon' gwyejlene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ca' goquen' ba chi' Jesúsen' liž Mateon' ba che'ej chagüe' txen len zan beṉe' güec̱hixjw na' len yebaḻe beṉe' güen da' xiṉj na' len beṉe' ca' zjanaque' txen len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na' beṉe' fariseo ca' cate' besele'ede' chi' Jesúsen' txen len beṉe' ca', gose'e beṉe' ca' zjanaque' ḻe' txen: ―¿Nacxec̱hen' ben' chsed chlo'ede' le'e che'ej chagwlene' txen beṉe' güec̱hixjw na' yebaḻe beṉe' güen da' xiṉj? ");
INSERT INTO zpqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na' cate' Jesúsen' bende' xtiža'gaquen' na' gože' ḻegaque': ―Beṉe' cbi chesacšene bitw cheseyažjde' beṉe' güen rmed. Beṉe' chesacšende', ḻegaquen' cheseyažjde' beṉe' güen rmed. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ḻe šjased bi zeje Xtiža' Diosen' dan' nyojen žan: “Chaclaža' yeyaše' yeži'ilaže'le beṉe', gague con gotle beyix̱e' gonxenḻe neda'.” Gague beṉe' ba zjanaque' beṉe' güen len Diosen' zedeṉeyoeda' cont yesyetiṉjde' xtoḻen', san beṉe' güen da' xiṉjen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nach beṉe' ca' chesone' txen len Juan ben' bzoe' beṉe' nis gosebigue' lao Jesúsen' na' gose'ene': ―Neto' na' len beṉe' fariseo ca' chonchguato' gwbas, perw beṉe' ca' zjanaque' le' txen bi chesone' gwbas. ¿Bixc̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nach gož Jesúsen' ḻegaque': ―¿Guac yesezoa beṉe' yeḻa' güine' beṉe' chesaxe' to ga chac yeḻa' güešagna' šlac ben' bšagnan' zoalene' ḻegaque'? Še zoa ben' bšagnan' bi gac yesegüine'de'. Perw žin ža cate' bich soe' len ḻegaque', cana'ch yesone' gwbas. Na' ca'cze naquen len neda' na' len beṉe' ca' zjanaque' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Nono zoa beṉe' chc̱hine' lache' cobe cont yoda' xe' da' de'ex̱o', ḻe lache' coben' yeben' cate' c̱hiben' na' c̱hezan' lache'ex̱on', na' gan' nchezan' gacchen da' xen. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na' ḻecze ṉeca zoa beṉe' chgue'e vino cobe ḻo' bzod yide'ex̱o', ḻe vino coben' chšon' yide'ex̱on' na' ḻalje vino na' yesebiayi' chopen. San chesegue'e vino coben' ḻo' yid cobe cont bitw cuiayi' vinon' len yiden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na' ṉe' choe'te Jesúsen' dižan', bžin to beṉe' gwnabia' bzoa xibe' lao Jesúsen' na' gože'ne': ―Za' gotte to xi'iṉa' no'ole. Yo'ošca x̱oa taco' yic̱hjbe' cont yebambe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na' gwzoža' Jesúsen' na' gwc̱he'e beṉe' ca' zjanaque' ḻe' txen ja'aclene' beṉe' gwnabian'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na' šlac zja'aque' liž beṉe' gwnabian' zej to no'ole nagüe' ḻegaque', beṉe' ba goc šižiṉw iz chzoe' gwbao', na' bene' byen gwbigue' cože' Jesúsen' gwdane' lox xen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ḻe bene' xbab ḻo' yic̱hjlažda'ogüen', gwne': “Con še ba gwdana' xen' nach yeyacda'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na' gwyec̱hj Jesúsen' ble'ede' no'olen', gože'ne': ―Bendiplažo' xi'iṉa'. Ba beyacdo' dan' chejnilažo' neda'. Na' ḻa' beyactede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cate' bžin Jesúsen' liž beṉe' gwnabian' na' ble'ede' beṉe' zan zjaže' chesone' sšag chesebežchgüe' na' ba nita' beṉe' chosocuež bžejo par yosocuaše'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na' gože' ḻegaque': ―Ḻe yechoj ngale. Bi' no'ole daon' biṉa' gatbe', san chtasben'. Na' beṉe' ca' bosoxiže' gosonḻe' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na' beyož bešaše' yogo'ḻoḻ beṉe' ca', nach gwyo'o Jesúsen', bex̱ue' taca' bi' no'ol guaten', na' beyasbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na' ca nac yeḻa' guac dan' ben Jesúsen', gwxoa diža' c̱hen yogo' yež dan' zjachi' do na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cate' beza' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen, ja'aclen c̱hope beṉe' lc̱hoḻ ḻegaque' na' gosene' zižje: ―Le' naco' xi'iṉ diaža c̱he da' rey David, beyaše'laže'šca neto'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na' cate' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen besežine' yo'o gan' zjanite' na' besyeyo'e, na' ḻecze goso'o beṉe' lc̱hoḻ ca'. Nach Jesúsen' gože' ḻegaque': ―¿Chejḻe'le guac gona' cont yele'ele? Nach gose'ene': ―Chejḻe'to' X̱anto'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nach Jesúsen' gwdane' yejlaogaquen', na' gože' ḻegaque': ―Yele'ele, ḻe chejnilaže'le neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nach besyeyac yejlaogaquen' besyele'ede'. Na' Jesúsen' gože' ḻegaque' bicze yeso'e diža' can' goc besyeyac yejlaogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na' besyeya'aque' na' gate'tez ja'aque' doxen distritw Galilean' goso'e diža' ca nac dan' ben Jesúsen' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na' cate' besyeya'ac beṉe' ca', ḻa' besežinte beṉe' yoble zjanc̱hi'e to beṉe' bi goc ṉie', na' yo'o yaz da' x̱igüen' yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesúsen' bebeje' da' x̱igüen' na' ḻa' beṉete bena'. Na' beṉe' zan besele'ede' can' goquen' besyebanchgüede', na' gosene': ―Chio' beṉe' Israel, da' nechon' za' ble'echo yeḻa' guac dan' nac ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Perw na' beṉe' fariseo ca' gosene': ―Satanás dan' nac x̱an da' x̱igüe' ca' chaclenen ḻe' cont chebeje' da' x̱igüen' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen ja'aque' to to yež na' to to ciuda da' zjachi' do na' bzejni'ide' beṉe' Israel ḻo' yodao' c̱hegaque' ca', gwdix̱jue'ede' diža' güen can' ṉabia' Diosen' yic̱hjlaždao' beṉe' yosozenag c̱he'. Na' Jesúsen' beyone' beṉe' ca' chese'e bite'teze yižgüe' na' bite'teze da' chesac c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na' ble'ede' ba besežag beṉe' zan na' beyaše' beži'ilaže'de' ḻegaque', ḻe gocbe'ede' chesacžejlaže' nac yesone' na' gague no zoa yesaclen ḻegaque' len yogo' dan' chesežaglaogüe'. Nite' ca nita' no xila' be nono de gwyoe ḻegacba'. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nach gože' beṉe' ca' zjanaque' ḻe' txen: ―Chyažje beṉe' zan yeseyix̱jue'ede' xtiža' Diosen', perw to c̱hopga beṉe' nita' yeseyix̱jue'eden'. Na' beṉe' yosozenague' c̱he Diosen' zjazaca'lebe' ca to coseš xen da' chyažjen yedoben. ");
INSERT INTO zpqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Da'nan' ḻe ṉabe X̱ancho Diosen' seḻa'che' beṉe' yesaclene' chio' yotobcho coseš c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesúsen' botobe' beṉe' šižiṉw ca' zjanaque' ḻe' txen na' bnežjue' ḻegaque' yeḻa' gwnabia' cont besyebeje' da' x̱igüe' ḻo' yic̱hjlaždao' beṉe', na' cont besyeyone' beṉe' bite'teze yižgüe' da' chese'ede' na' bite'teze da' chesac c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Quinga zjale beṉe' šižiṉw ca': Simón ben' ḻecze le' Pedro ben' goque' beṉe' blao, na' Andrés beṉe' biše' Pedroa', na' xi'iṉ Zebedeon' Jacobo len Juan, ");
INSERT INTO zpqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na' Felipe, na' Bartolomé, na' Tomás, na' Mateo ben' goc beṉe' güec̱hixjw, na' Jacobo xi'iṉ Alfeo, na' Lebeo ben' ḻecze le' Tadeo, ");
INSERT INTO zpqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na' Simón ben' ben txen len partidw cananista, na' Judas Iscariote ben' bdie' Jesúsen' ḻo na' ben' besegue'ede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na' Jesúsen' gwseḻe' beṉe' šižiṉw ca' jasedix̱jue'ede' xtiža' Diosen', gože' ḻegaque': ―Bitw šejle laž beṉe' cbi zjanaque' beṉe' Israel, na' ṉeca šejle yež ca' zjachi' distritw Samaria. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ḻe šja'ac gan' že' beṉe' Israel beṉe' ba zjambiayi' dan' bitw ṉa' yesombi'e Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ḻe šja'ac ḻe šjatix̱jue'ede' ba bžin ža Diosen' ben' zoa yaban' ṉabi'e yic̱hjlaždao' beṉe' yosozenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ḻe yeyon beṉe' chesacšene, ḻe yeyon beṉe' ca' chese'e yižgüe' dan' nzi' lepra, ḻe yosban no beṉe' ba gosat, na' ḻe yebej da' x̱igüe' ca' zjayo'o zjanyaz ḻo' yic̱hjlaždao' beṉe'. Diosen' bibi bc̱hixjue' le'e da' ba beṉe' le'e yeḻa' guac c̱hen' cont gonḻe da' quinga, da'nan' ḻe gaclen beṉe' na' bibi gwc̱hixjwlene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Bitw gua'le mechw de oro, de plata o de cobre šlac co'ole nez. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na' ṉeca gua'le bzod, o yeto xcamisle, ṉeca gua'le yel, na' ṉeca gox̱e'le xis da' gwc̱hiše'le. Ca nac le'e chonḻe xšinan' zaca'le par goṉ beṉe' da' ye'ej da' gagwle gan' seḻa' le'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Na' gate'tez ciuda o yež ga žinḻe, ḻe ṉab še zoa to beṉe' güen beṉe' yebede' gwlebe' le'e ližen'. Na' še gwlebe' le'e, na'teze soale. Cate'ch žin ža šejle ga yoble, cana'ch yeza'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na' cate' žinḻe liže'na', ḻe gwguape' tiox, na' ḻe ṉablaže' soa cueze' binḻo len yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na' še nita' beṉe' chesaclaže' yesezoa yesebeze' binḻo len yic̱hjlažda'ogaquen', na' gac can' gwṉablaže'le par yesezoa yesebeze' binḻo. Perw še nono zoa beṉe' chesaclaže' yesezoa yesebeze' binḻo len yic̱hjlažda'ogaque', bi gac dan' ba gwṉablaže'len'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na' še zoa ga bi yosolebe' le'e ṉeca yosozenague' c̱hele, cate' yeza'le na', ḻe cuibe ṉi'alen' yo bište cont nacbia' bi checa'ale c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Da' mal xen goson beṉe' ciuda Sodoma na' beṉe' ciuda Gomorra cani', perw da' ḻi žia' le'e, cate' žin ža gac juisyw beṉe' ca' bi bosolebe' le'e ližen' yesaḻe'chde' clel ca beṉe' Sodoman' na' beṉe' Gomorran'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Neda' seḻa' le'e šjatix̱jue'ele xtižan' len beṉe' ca' chesegue'ede' le'e. Zaca'leble ca xila' dao' ben' chja'ac gan' že' beco'yo. Da'nan' cheyaḻa' gacle beṉe' yo'ochgua xbab na' beṉe' xenḻaže' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ḻe gwsaca' len beṉe' ca' chesegue'ede' le'e. Nita' beṉe' yesone' le'e ḻo na' beṉe' gwnabia' ca' cont yesot yeseyine' le'e ḻo' yodao' c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nach ḻecze dan' chejnilaže'le neda' nita' beṉe' yesec̱he'ex̱ox̱je' le'e do lao rey, do lao nochle beṉe' gwnabia'. Na' can' güe'lenḻe ḻegaque' xtižan', ḻecze can' güe'lenḻe xtižan' len beṉe' bi zjanaque' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Perw cate' yesezene' le'e na' yesec̱he'e le'e lao beṉe' ca', bi cuec yic̱hjle nac yoži'ile xtiža'gaquen' o nacle ṉale. Ḻo hor na'teze Diosen' gwzejni'ide' le'e bin' cheyaḻa' ṉale. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ḻe gague le'eczen' ṉele, san Spiritw c̱he X̱acho Diosen' gonen ga ṉale bin' cheyaḻa' ṉale. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Cana' baḻ beṉac̱h yesec̱hje' yesone' beṉe' biše' golje' ḻo na' beṉe' yesote' ḻegaque', na' nita' beṉe' yesone' xi'iṉgaque' ḻo na' beṉe' yesot ḻegacbe', na' nita' beṉe' yesone' x̱axṉe'e ḻo na' beṉe' yesote' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yogo'ze beṉe' yesegue'ede' le'e dan' chejnilaže'le neda', perw note'tez le'e gwyo gwc̱hejlaže'le cont bi cuejyic̱hjle dan' chejnilaže'le neda' žinten gatle, nach šjayzoale len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Še beṉe' že' to yež yosyolague' le'e, ḻe yeza'teze na' yeyejle ga yoble. Biṉa' yeyož šjatix̱jue'ele xtižan' yogo' yež gan' že' beṉe' Israel ca' cate' yida' da' yoble, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ca nac cate' to beṉe' chsede' len to maestrw, bitw ṉacho naque' beṉe' blaoch ca maestroa'. Na' to mos bitw naque' blaoch ca x̱anen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Con cheyaḻa' c̱hazlaže' ben' chseda' še yežinḻaže' gaque' ca maestrw c̱he' na' cheyaḻa' c̱hazlaže' mosen' še yežinḻaže' gaque' ca x̱anen'. Neda' naca' X̱anḻe, na' beṉe' chesegue'ede' neda' chesene' chona' txen len Beelzebú dan' nac x̱an yogo' da' x̱igüe', na' naquechxe yesene' c̱he le'e nacle neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Bitw žeble beṉe' bite'teze da' yesonde' le'e, ḻe bitwbi de da' ngaše' da' ṉacho cbi gwlo'elaon, ṉeca de da' nono ṉa' ṉeze da' ṉacho cbi yeseṉezden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Da' zan dan' chsed chlo'eda' le'e dan' bi chsed chlo'eda' yezica'chle beṉe'. Na' le'e ḻe gwsed ḻe gwlo'en yogo'ḻoḻ beṉe', na' ḻe gon cont beṉe' zan yesejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bitw cheyaḻa' žeble beṉe' ca' yesot le'e. Ḻegaque' bitw gac bi yesonde' yic̱hjlažda'olen'. Cheyaḻa' žeble Diosen', ḻe ḻen' nape' yeḻa' gwnabia' cont gwžiaye'e cuerp c̱helen' len yic̱hjlažda'olen' ḻo yi' gabiḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ṉezecho byiṉe dao' ca' bitw bi zjazaca'tecba', perw bitw ṉacho toba' gat sin cbi güe' X̱acho Diosen' latje. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na' ca nac chio', chaquechgüe Diosen' chio' na' ṉeztede' baḻ yiša' yic̱hj to tocho žia. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Da'nan', bitw žeble, ḻe zaca'chle clel ca zan byiṉ dao' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Na' note'teze beṉe' še cho'e diža' len beṉac̱hen' che'ene' chejḻe'e c̱hia', ḻecze ca' neda' gua' diža' len X̱a' ben' zoa yaban' yapa'ne' bena' naque' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na' note'teze beṉe' še cho'e diža' len beṉac̱hen' che'ene' bitw chejḻe'e c̱hia', ḻecze ca' neda' gua' diža' len X̱a' ben' zoa yaban' yapa'ne' bena' bi naque' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Bitw gonḻe xbab beṉe' že' yežlio nga yesezoa yesebeze' binḻo len ḻježgaque' ṉa'a ba bida'. Bitw yesezoa yesebeze' binḻo san yesediḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lagüe dan' ba bida' yesediḻ beṉe' byo len x̱e' na' no'olen' len xṉe'e, na' yesediḻ xo'oliž no'ole len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Beṉe' ḻo' yo'oze yesegue'e ḻježe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Note'tez beṉe' še chaquechde' x̱e' o xṉe'e clel ca chacde' neda', bitw zaque' gone' txen len neda'. Ḻecze ca' še chaquechde' xi'iṉe' clel ca neda' bitw zaque' gone' txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na' note'teze' še bi chzenague' c̱hia' lagüe' dan' chacde' yosoc̱hi yososaca' beṉe' ḻe', bitw zaque' cont gaque' neda' txen še ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Note'teze beṉe' chacde' gone' cont bi c̱hi saque' o cont nono yesot ḻe', benan' cuiayi'. Na' note'teze beṉe' chzanḻaže' cuine' saca'zi'e o gate' ṉe c̱hia' neda, ba de yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Note'teze beṉe' chosolebe' le'e chosolebe' neda', ḻecze chosolebe' Dios ben' gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Na' note'teze beṉe' yebede' gwlebe' beṉe' cheso'e xtiža' Diosen', mbalaz soe' cate' yežine' yaban' ḻecze ca mbalaz soa ben' cheso'e xtiža' Diosen'. Na' mbalaz gac c̱he beṉe' ca' cheson can' chazlaže' Diosen' caten' yesyežine' yaban'. Na' note'teze beṉe' yebede' gwlebe' ḻegaque' da' chesone' can' chazlaže' Diosen', ḻecze mbalaz soe' caten' yežine' yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Note'teze beṉe' gwnežjue' ḻa' to xiga'ze nis ye'ej beṉe' chejnilaže' neda', ḻa' gwnežjuen' beṉe' bi naque' beṉe' blao, da' ḻicze gona' cont soe' mbalaz caten' yežine' yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cate' beyož ben Jesúsen' mandadw can' yeson beṉe' šižiṉw ca' gwleje' cont gosaque' ḻe' txen, beze'e latjen'. Na' gwyeje' yež ca' zjachi' do na' jased jalo'ede' xtiža' Diosen' len beṉe' ca' že'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juanṉa' ben' bzoe' beṉe' nis, cana' ba die' ḻižya. Na' bende' diža' c̱he yogo' dan' chon Criston' ben' gwseḻa' Diosen' cont yedeṉabi'e. Nach Juanṉa' gwseḻe' c̱hope beṉe' zjanaque' txen len ḻe' gan' zoa Jesúsen', ");
INSERT INTO zpqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","jaseže'ne': ―¿Len' naco' ben' chbezto' seḻa' Diosen', še cheyaḻa' cuezchto' yid beṉe' yoble? ");
INSERT INTO zpqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nach Jesúsen' gože' ḻegaque': ―Ḻe šjaya'ac na' ḻe šjayež Juanṉa' doxen da' ca' ba ble'ele na' da' ca' ba benele. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ba ble'ele chona' cont chesyele'e no beṉe' lc̱hoḻ, na' chesyeda no beṉe' zjanxiṉj ṉi'e. Na' ḻecze beṉe' gose'e yižgüe' dan' nzi' lepra besyeyacde', na' chesyeyene no beṉe' cuež. Ba ble'ele bosbana' no beṉe' guat, na' ba benele choa' diža' güen c̱hia' len beṉe' yaše' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mbalaz zoa beṉe' chejḻe'e c̱hia' na' bi chdebde'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na' cate' besyeya'ac beṉe' ca' zjanaque' txen len Juanṉa', nach Jesúsen' be'lene' beṉe' ca' zjandoben' xtiža' Juanṉa', gože' ḻegaque': ―¿Nacxe nac ben' jale'ele latje dašen'? ¿Chaque' quil ca'ale? Bi naque' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Nac naque' caten' jale'elne'? ¿Nyaze' lache' šagüe'? ¿še bitw? ḻe beṉe' zjanyaz lache' šagüe' nite' yo'o güenchgua ca no liž beṉe' gwnabia'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Noxen' jale'ele? ¿to ben' choe' xtiža' Diosen'? Da' ḻi cho'e xtiža' Dios, perw žia' le'e, zaca'che' ca note'teze beṉe' choe' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","C̱he benga nyojen ḻe'e Xtiža' Diosen', žan: Neda' Dios seḻa' to beṉe' cuialagüe' laguo' güe'e xtižon' cont cate' šejo' ba zjanita' beṉe' yosozenague' c̱hio'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Da' ḻi žia' le'e notoch no beṉac̱h ṉa' soa beṉe' naquech beṉe' blao ca Juanṉa' ben' bzoe' beṉe' nis. Perw na' note'tez beṉe' chzenague' c̱he Diosen' cont ṉabia' Diosen' yic̱hjlažda'ogüen', ḻa'czḻa' naque' beṉe' ḻa'zelagüe beṉe' bibi zaca', ba chejni'ichde' c̱hia' clel ca Juanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Gwzolaon caten' Juanṉa' gwdix̱jue'ede' xtiža' Diosen' na' bzoe' beṉe' nis na' chžinten ṉa'a, beṉe' zan chesone' ga zelao chesezaquede' cont ṉabia' Diosen' yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na' ḻecz gwzolaon cani'te bžinten cate' bla' Juanṉa' gwdix̱jue'ede' xtiža' Diosen', ley dan' bzoj da' Moisés na' dan' bosozoj yezica'chle beṉe' goso'e xtiža' Diosen' bzejni'in chio' c̱he yeḻa' gwnabia' c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na' Xtiža' Diosen' dan' nyojen žan yid yeto beṉe' yedeyene' can' ben Elías ben' be' xtiža' Diosen' cani'. C̱he Juanṉa' žan ca', con še šejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Le'e žia nagle da' chene, ḻe gwzenag xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿No gwsaca'lebda' le'e zoale ṉa'a? Gwsaca'lebda' le'e ca bidao' dan' bicze bi chlebele. Nacle ca bidaon' nita' gan' chac ya'a chese' ḻježbe': ");
INSERT INTO zpqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ba bcuežto' bžejo, ṉeca bya'ale, na' ba biḻyaše'to', ṉeca gwchežle.” ");
INSERT INTO zpqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan ben' bzoe' beṉe' nis bide' laole nga, bitw güe'ej gwdagwšagüe' can' chese'ej chesagw beṉe' yoble, nach gwnale c̱he': “Yo'o yaz da' x̱igüen' yic̱hjlažda'ogüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na' neda', Diosen' gwseḻe' neda' golja' beṉac̱h, na' chle'ele che'ej chagua' can' chese'ej chesagw beṉe' yoble, na' žale c̱hia' naca' beṉe' ḻia na' beṉe' borrašw. Na' ḻecze žale c̱hia' naca' xmigw beṉe' güec̱hixjw ca' na' xmigw yezica'chle beṉe' güen da' xiṉj. Perw nacbia' yeḻa' sina' c̱he Diosen' dan' napto' naquen da' güen, ḻe ba ble'eczele can' chon neto' napton'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nach Jesúsen' be'e xtiža' beṉe' ca' že' yež ca' gan' bene' da' zan da' zaca' yesyebande', na' gwdiḻe' ḻegaque' dan' bitw besyetiṉjde' xtoḻa'gaquen'. Nach gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Nyaše'chguaze gac c̱he le'e beṉe' Corazín! ¡Nyaše'chguaze gac c̱he le'e beṉe' Betsaida! Beṉe' ca' nita' Tiro na' Sidón ba besyetiṉjde' xtoḻa'gaque' šaca' blo'egacda'ne' yeḻa' guac c̱hia' ca dan' ba blo'eda' le'e. Na' bosoše'e ca gosone' šaca' bena' ca', chesazḻje' to lache' gasj da' naquen zeše' na' chosože'eḻja cuine' no de cont yesacbe'e beṉe' ba boša' yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Žia' le'e, saca'zi'chle clel ca beṉe' že' Tiro na' Sidón cate' žin ža gac juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na' le'e nita'le Capernaum chonḻe xbab šeca Diosen' gone' gacxenchguale cate' yežinḻe yaba gan' zoe'na'. Bi gone' ca', san seḻe' le'e ḻo yi' gabiḻ. Šeca' bena' da' zaca' yesyebane beṉe' ca' gwnita' Sodoman' can' ba bena' laole nga, zesyetiṉjde' xtoḻa'gaquen', na' ṉe' chi' ciudan' šeca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Žia' le'e, gaḻe'chle clel ca beṉe' Sodoman' cate' žin ža gac juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nach Jesúsen' boḻ güiže' Diosen', gwne': ―X̱a', le' naco' X̱an yežlio nga na' X̱an yaba, chnabi'o doxen. Na' choṉa' yeḻa' chox̱clen c̱hio' ba bzejni'ido' baḻ beṉe' diža' güen c̱hio' quinga. Bzejni'ido' beṉe' ca' gosacbe'e cheseyažjde' no gwsed gwlo'e ḻegaque'. Na' bitw bzejni'ido' beṉe' ca' cheson xbab zjanaque' beṉe' sina' na' beṉe' zjanejni'i. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Beno' ca' X̱a', ḻe can' gwnalažo'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na' gože' beṉe' ca' že'na': ―X̱an' ba bene' ḻo na' gona' cont chombia' beṉe' ḻe'. Ḻe' nombia'yaṉe' neda', na' neda' nombia'yaṉa' ḻe'. Na' beṉe' ca' ba gwleja' ba zjanombi'e X̱an'. Na' noch no zjanita' beṉe' zjanombi'e X̱an', ṉe neda' ca zjanombi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Le'e chjax̱aque'laže'le na' chacyaše'laže'le da' chaquele nac gonḻe cont soale binḻo len Diosen', chata'yoeda' le'e, ḻe šejnilaže' neda'. Neda' gona' ga soale mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ḻe gwzenag c̱hia' na' gwzejni'ichda' le'e. Neda' naca' beṉe' xenḻaže' na' beṉe' šagüe' na' gona' ca soale mbalaz ḻo' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Dan' žia' cheyaḻa' gonḻe bitw naquen zed, na' can' chsed chlo'eda' bitw naquen zdebe. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ca tiempen' gozac to ža c̱he Diosa' cate' Jesúsen' gwdie' len beṉe' ca' zjanaque' ḻe' txen gan' nyaž trigw. Nach beṉe' ca' gosedone', na' goseḻec̱hje' dao c̱he trigon' cont gosagüe' xsenṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na' besele'e beṉe' fariseon' can' gosone', na' gosi'e Jesúsen': ―Gwṉašc ¿bixc̱hen' beṉe' ca' zjanaque' le' txen chesone' žin da' bi de ḻsens goncho ža c̱he Dios? ");
INSERT INTO zpqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na' Jesúsen' gože' ḻegaque': ―¿Biṉa' gwlable can' ben da' rey Davin' to ža cate' ḻe' na' beṉe' ḻježe' ca' gosedone'? ");
INSERT INTO zpqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gwyo'o Davin' ga nac liž Dios na' gwdagüe' yetextil da' nac c̱he Dios da' bi chac gagw beṉe' bi nac bx̱oz, na' ḻecze bnežjue' c̱he beṉe' zja'ac len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na' ¿biṉa' gwlable ḻe'e ley dan' bzoj da' Moisés gan' žan bx̱oz ca' chesoncze' mandadw c̱he yodao' blaon' yogo' ža c̱he Diosen'? Na' bitw ṉacho zjanape' doḻa' dan' chesone' žin ža c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Žia' le'e, neda' zoa' nga zaca'cha' clel ca yodao' blaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xtiža' Diosen' dan' nyojen žan: “Chaclaža' yeyaše' yeži'ilaže'le beṉe', gague con gotle beyix̱e' par gonxenḻe neda'.” Šaca' chejni'ile bi zejenṉa' žan ca', biḻja ṉale beṉe' quinga zjanape' doḻa', ḻe bibi da' mal chesone'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Žia' le'e, naquen' ḻo na' ṉia' bi da' nac güen goncho cate' nac ža c̱he Diosen', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na' cate' Jesúsen' beze'e latjen', na' gwyo'e to ḻo' yodao' c̱he c̱hio' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na' ḻo' yodaon' zoa to beṉe' nx̱o'oṉ šḻa'a taque', nach beṉe' fariseo ca' gose'e Jesúsen': ―¿De ḻsens yeyoncho beṉe' xiṉj ža c̱he Diosen'? Gose'ene' ca' cont de da' yosode'ede' yesagüe' xya. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nach Jesúsen' gože' ḻegaque': ―Še nita' xila' dao' c̱hele na' lažo' toba' to ḻo' yechw zitjw ža c̱he Diosen' cate' bi de ḻsens goncho žin, ¿cbi ḻa' yebejteleba' ḻo' yechon' ḻo žana'? ");
INSERT INTO zpqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Da'na'na' žia' le'e de ḻsens gaclencho beṉe' ža c̱he Diosen'. Ḻe zaca'ch to beṉe' clel ca to xila' dao'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nach Jesúsen' gože' ben' nx̱o'oṉ taque'na': ―Bḻi naon'. Na' bḻien' na' taquen' beyaquen binḻo can' nac dan' yešḻa'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nach beṉe' fariseo ca' besyežaše' yodaon' na' bosoxi'e nacle yesone' yesote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gocbe'e Jesúsen' can' bosoxi'a beṉe' fariseo ca' na' gwze'e gwyeje' ga yoble. Beṉe' zan ja'aclene' ḻe', nach beyone' yogo' beṉe' ca' chesacšene. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na' bene' mandadw nono yesoe'lene' diža' non' beyon ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bene' ca' cont goc can' ža Xtiža' Diosen' dan' bzoj da' Isaíasen', žan: ");
INSERT INTO zpqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Bengan' naque' xmosa', ben' gwleja' cont gone' can' chazlaža'. Chacchgüeda' ḻe', na' chbeda' c̱he'. Na' neda' seḻa' Spiritw c̱hian' soateze soan len ḻe'. Na' c̱hix̱jue'ede' yogo'ḻoḻ beṉe' can' chazlaža' yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bitw gacyože' len beṉe', ṉeca yosye'e, na' ṉeca ṉie' zižjo ḻo nez cont yesene beṉe' bin' že'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bi gwzoe' ca'ale beṉe' chesejnilaže' ḻe' late' lasze. Soe' gaclene' ḻegaque'. Nach žin ža gone' cont gac con da' zej to ḻicha ḻo yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na' beṉe' že' yogo' naciónṉa' yesebeze' gaclene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na' zoa to beṉe' lc̱hoḻ na' ṉeca goc ṉie', na' yo'o nyaz da' x̱igüe' yic̱hjlažda'ogüe' na' jasesane'ne' lao Jesúsen'. Na' Jesúsen' bebeje' da' x̱igüen' yo'o nyaz yic̱hjlaždao' ben' na' ḻa' bele'etede' na' gocte beṉie'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na' yogo' beṉe' ca' besele'ede' can' goca' besyebanchgüede'. Nach gose'e ḻježe': ―¿Nac benga ben' chbezcho yide' lao diaža c̱he da' rey David? ");
INSERT INTO zpqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Perw cate' beṉe' fariseo ca' gosende' diža' quinga gosene': ―Bitwbi yeḻa' guac nap benga. Ḻe Beelzebú dan' nac x̱an da' x̱igüe' ca' chaclenen ḻe' cont chebeje' da' x̱igüe' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gocbe'e Jesúsen' can' goson beṉe' fariseo ca' xbaben', nach gože' ḻegaque': ―Note'teze gobiern še choje' c̱hop šoṉ cuen na' yeyoža' yesediḻe' ḻegacze', cuiayi' gobierna'. Na' ḻecze še beṉe' že' bite'teze yež yesaque' c̱hople na' yesediḻe' ḻegacze', ḻecze bi sibia' yež c̱hegaquen' še ca'. Na' še beṉe' ḻo' bite'teze yo'o yesechoje' c̱hople na' yesediḻe' ḻegacze', gague sša yesenite' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ḻecze ca' še Satanásen' yebejen yeto da' x̱igüe' yo'o nyaz yic̱hjlaždao' beṉe', cuiayi' yeḻa' chnabia' c̱hen, ḻe chdiḻlen cuinen še ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Le'e žale Beelzebún' chaclenen neda' cont chebeja' da' x̱igüe' ca'. Šaca' naquen can' žalen', ḻecze zejen Beelzebú dan' chnabia' da' x̱igüen' chaclenen beṉe' ḻježle chesyebeje' da' x̱igüe' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. Na' beṉe' ḻježle ca'ze chosolo'e clelen' chṉele. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Spiritw c̱he Diosen' choṉen neda' yeḻa' guac cont chebeja' da' x̱igüe' ca', na' da' chona' ca' chlo'en ba bžin ža ṉabia' Diosen' yic̱hjlaždao' beṉe' yosozenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Nac gac šo' beṉe' gwban liž to beṉe' gual na' que'e bi da' de c̱he' še bi zgua'tec gwc̱heje' beṉe' guala'? Ḻete gone' ca' nach gac que'e bi da' de c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Beṉe' bi chone' neda' txen, chone' contr neda'. Na' beṉe' bi chaclene' cont yosozenag beṉe' yoble c̱hia', zeje diža' chone' par bi yosozenague' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Da'nan' žia' le'e, yogo' da' xiṉj da' chon beṉac̱h, na' yogo' diža' bya' dan' cheseṉe' c̱he Diosen', Diosen' yezi'xene' c̱hen, perw note'teze beṉe' chṉe' yeḻa' ya' c̱he Spiritw c̱he Diosen', gwbat yezi'xen Diosen' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na' note'teze beṉe' še ṉe' yeḻa' ya' c̱hia' neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h, Diosen' yezi'xene' c̱he', perw note'teze beṉe' še ṉe' yeḻa' ya' c̱he Spiritw c̱he Diosen', gwbat yezi'xen Diosen' c̱he' ṉa'a na' bate'teze. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ca nac yag frut ca', yag dan' nac yag güen, frut güencze chbian, na' yag da' bi nac yag güen, ḻecze frut da' bi nac güen chbian. Con can' nac da' chbia to to yaguen' ṉezecho bi yaga'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Na' ca'czen' nac len le'e nacchguale beṉe' zgot na' beṉe' gwxiye'. Bitw gac güe'le diža' šagüe' dan' nacle beṉe' laždao' xi'a. Ḻe yogo'te diža' da' chchoj cho'achon', ḻo' yic̱hjlažda'ocho nan' za'aquen. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","To beṉe' laždao' xilaže' cho'e diža' šagüe', ḻe can' nac ḻo' yic̱hjlažda'ogüe' nan' cho'e dižan'. Na' to beṉe' laždao' xi'a cho'e diža' xi'a, ḻe can' ža ḻo' yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na' žia' le'e, cate' žin ža gon Diosen' yesežaglao yogo' beṉe' cheson da' xiṉj toḻi tocaṉe, cana' yogo'ḻoḻ beṉe' yosodie' cuent c̱he yogo' diža' dan' ba goso'e da' bitwbi zjazacan'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na' con ca diža' dan' choe'le, Diosen' c̱hoglagüen' c̱hele še naple doḻa' o še bi naple doḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nach baḻ beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés, na' beṉe' fariseo ca' gose'e Jesúsen': ―Maestrw, chaclaže'to' gono' to yeḻa' guac da' le'eto' cont ṉezeto' še da' ḻicze Diosa' gwseḻe' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nach Jesúsen' gože' ḻegaque': ―Le'e zoale ṉa'a nacchguale beṉe' laždao' xi'a na' ba gwlejyic̱hjle Diosen'. Na' chṉable gona' yeto yeḻa' guac da' le'ele cont ṉezele še Diosa' gwseḻe' neda', perw bi gona' can' chṉablena', ḻe ba ble'ele da' ca' chona'. Dan' gon Diosen' len neda' cont ṉezele ḻe'na' gwseḻe' neda' naquen ca da' bene' len da' Jonás ben' be' xtižen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cate' za' šej Jonásen' Nínive, Diosen' bene' cont to beḻ xen be yo'o ḻo' nisdaon' gwdebba' ḻe' na' šoṉe ža šoṉe yel gwyo'e ḻo' ḻe'eban'. Na' ca nac neda', gata' na' gaša', na' yeyoža' šo'a ḻo' ba šoṉe ža šoṉe yel. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na' cate' žin ža gon Diosen' cont yogo' beṉe' cheson da' mal yesežaglagüe' toḻi tocaṉe, žana' beṉe' Nínive beṉe' ba gosat yedesecuiše' le'e mbanḻe ṉa'a lao Diosen', ḻe ḻegaque' besyetiṉjde' xtoḻen' cate' da' Jonásen' gwdix̱jue'ede' xtiža' Diosen' len ḻegaque'. Na' neda' zoa' nga naccha' beṉe' blao clel ca da' Jonásen', na' bitw chzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na' ḻecze žana' cate' gon Diosen' cont yogo' beṉe' cheson da' mal yesežaglaogüe' toḻi tocaṉe, da' no'olen' gwnabia' beṉe' Seba ca' yedecuiše' le'e mbanḻe ṉa'a. Ḻe ḻe'na' gwze'e Seba gan' nac zito'chgua na' bide' nga cont bzenague' diža' sina' dan' be' da' rey Salomón. Na' neda' zoa' nga naccha' beṉe' blao clel ca da' rey Solomónṉa', na' bitw chzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Na' še to da' x̱igüe' da' yo'o nyaz ḻo' yic̱hjlaždao' beṉe' yechojen, nach lažen nile nale yeyiljon ga soan mbalaz. Na' še bibi latje želen, nach ṉan: ");
INSERT INTO zpqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Da' yoble šjayo'a ḻo' yic̱hjlaždao' ben' gan' ba gwyo'a.” Nach yeyejen da' yoble gan' zoa ben'. Cate' le'en bac̱h beyacde', na' ba zoache' binḻo, na' gague no yo'o nyazech yic̱hjlažda'ogüe' da' gwžon yeyo'on da' yoble, ");
INSERT INTO zpqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","nach šjaytoben yegaže da' x̱igüe' da' zjanaquech mal ca ḻen, na' txen yeso'on ḻo' yic̱hjlažda'ogüen'. Na' še ba gosonen ca', na' gaquech mal c̱he bena' clel ca goc c̱he' cana'. Can' goc c̱he bena', ḻecze ca' gac c̱he le'e mbanḻe ṉa'a dan' nactecle beṉe' laždao' mal. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ṉe' choe'te Jesúsen' diža' len beṉe' quinga, cate' bžin xṉe'e len biše' ca'. Gosaclaže' yeso'e yesoe'lene' ḻe' diža' na' beṉe' zan nita' lagüe' na'ate. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Beṉe' ca' že' na', toe' gože' Jesúsen': ―Xṉa'o len beṉe' bišo' ca' zjanite' chyo'o na' chesaclaže' yesoe'lene' le' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nach Jesúsen' gože' ḻe': ―¿Ṉezele no nac xṉa'a na' no zjanac biše' ḻježa'? ");
INSERT INTO zpqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nach bḻi ne'e blo'e beṉe' ca' zjanaque' ḻe' txen na' gože' bena': ―Beṉe' quinga zjanaque' xṉa'a na' zjanaque' biše' ḻježa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ḻe note'teze beṉe' chone' da' chnalaže' X̱a' Diosen' ben' zoa yaban', bena' nac beṉe' biša', beṉe' zana', ḻecze naque' xṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na' ḻo žana' gwza' Jesúsen' yo'o gan' zoen' jac̱hi'e cho'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nach catec beṉe' zan juisyw besedobe' gan' chi'en' na' benten byen gwyo'e gwchi'e to ḻo' barcw. Na' yogo' beṉe' ca' besedoben' gosenite' cho'a nisdaon' ga nac yo biž. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nach da' zan da' bsed blo'e Jesúsen' ḻegaque' len jempl da' bi'e. Na' be'e to jempl, gwne': ―To beṉe' güen žin jeze' trigw, ");
INSERT INTO zpqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","na' šlac zej chose' trigon' late' biṉ c̱he trigw dan' chazen' jasechazen chanez, nach be ca' žia x̱il be chaš ḻe'e yaba gosagwban'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yelaten' jasechazen ga nac ḻo yej ga bibi yotec zoa, na' da' nga byob blan' ḻe bi jasechazen ga nac sitjw. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Perw na' cate' bla' gwbiža' na' bzeyen ḻen na' gosebižen, ḻe gague zjayo'otec loenṉa' sitjw. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yelaten' jasechazen ga nac ḻo yag yeše', na' yag yešen' gosecha'on na' bosoḻoḻen ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Perw na' yelaten' jasechazen ga nac yo šagüe' na' beselan'. Na' baḻen' gosebian to gayoa güeje to ton, na' yebaḻen gosebian gayon güeje, na' yebaḻen šichoa güeje. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Le'e žia nagle da' chene, ḻe gwzenag xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nach beṉe' ca' zjanaque' Jesúsen' txen gosebigue' lagüen', na' gose'ene': ―¿Bixc̱hen' chsed chlo'edo' beṉe' quinga len jempl? ");
INSERT INTO zpqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na' gož Jesúsen' ḻegaque': ―Nono ṉa' ṉeze can' nac yeḻa' gwnabia' c̱he Diosen', na' ba chone' cont le'e chejnilaže'lene' ṉezelen. Perw bi chon Diosen' ca' len beṉe' bi chesaclaže' yesejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Note'teze beṉe' chosozenague' xtiža' Diosen', gwzejni'ich Diosen' ḻegaque' cont šanch dan' yesejni'ide'. Perw na' note'teze beṉe' bi chosozenague', da' daon' ba zjaṉezde', yeca'a Diosen' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Da'nan' chsed chlo'eda' beṉe' quinga len jemplen', ḻe chesele'ede' dan' chona' perw bitw chesacbe'ede' bi zejen, na' chesende' xtižan' perw bitw chesejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Len beṉe' quinga ba chac can' bzoj da' Isaías, žan: Da' ḻi yenele, perw bitw šejni'ile bi zeje dan' yenelen'. Na' da' ḻi le'ele, perw bi gacbe'ele bi zejen dan' le'elen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nacle beṉe' güedenag na' bac̱h natcze yic̱hjlažda'olen'. Bi chazlaže'le gwzenagle dan' chenele na' dan' chle'ele; con nacle beṉe' güedenag. Šaca' bi nacle beṉe' güedenag, šejni'ile bi zejen dan' chenele na' dan' chle'ele. Nach yetiṉjele xtoḻa'le cont yeca'an na' yocoba' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Perw le'e nacle neda' txen, ḻeca mbalaz zoale dan' chle'ele da' ca' chona' na' chacbe'ele bi zejen, na' chzenagle xtižan' na' chejni'ilen. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Da' ḻi žia' le'e, zan da' beṉe' ca' gosoe' xtiža' Diosen' cani' na' zan da' beṉe' ca' yezica'chle beṉe' bosozenag c̱he Diosen' cani', gosaclaže'chgüe' yesele'ede' dan' chle'ele ṉa'a, perw bitw goḻa' yesele'eden'. Na' gosaclaže'chgüe' yesende' dan' chenele ṉa'a, perw bitw goḻa' yesenden'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Na' ḻe gwzenag, quinga zejen jempl c̱he ben' goz trigon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ca dan' byažen zejen xtiža' Dios da' chzejni'i c̱he yeḻa' gwnabia' c̱he'. Na' biṉ dan' beselažo' chanezen', zejen beṉe' ca' chesende' xtiža' Diosen' perw bi chesejni'iden'. Na' ca cheyoža' chžin gwxiyen' chebejen xtiža' Diosen' ḻo' yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na' biṉ dan' beselažo' ga nac ḻo yej na' bi ben loen, zjanaquen ca beṉe' ḻa' chesyebetede' xtiža' Diosen' cate' chesenden', ");
INSERT INTO zpqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","perw zjanaque' ca da' bibi loe chontec, šložga chesejḻe'e c̱he xtiža' Diosen', na' cate' chac bi da' mal c̱hegaquen' o cate' chesegue'e beṉe' ḻegaque' dan' chosozenague' xtiža' Diosen', ḻa' chesebejyic̱hjte' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na' biṉ dan' beselažon' ga nac ḻo yag yeše', zejen ca beṉe' ca' ba zjanende' xtiža' Diosen', perw šlac zjambane' chesyelaḻ chesyežejde' na' da' chesaclaže' yeseṉi'e chziye'en ḻegaque'. Yogo' da' qui bi choen' latje yega'aṉ xtiža' Diosen' ḻo' yic̱hjlažda'ogüen', na' da'nan' bi chesejnilaže' ḻe' ca cheyaḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na' biṉ dan' beselažo' ḻo yo šagüe' zejen ca beṉe' chesende' xtiža' Diosen' na' chesejni'iden' na' chosozenaguen'. Baḻen gosebian to gayoa güeje, na' yebaḻen gosebian gayon güeje, na' yebaḻen šichoa güeje. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na' gozoe'len Jesúsen' beṉe' ca' yeto jempl, goze'e ḻegaque': ―Yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' zaca'leben ca dan' goquen' cate' to beṉe' jeze' trigw ḻo yežlio c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na' do šeže'le gwyej to beṉe' chgue'e ḻe' šlac chesetas beṉe' ca' yezica'chle na' jeze' xsa yix̱e' gan' ba naz x̱an yežlion' trigon', nach beze'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na' to ši'ize trigon' len yix̱e' ca' beselan', na' trigon' gwzolao chbian. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na' beṉe' güen žin c̱he x̱an yežlion', cate' gosacbe'ede' nach jaya'aque' gan' zoa x̱angaque' jasyeyeže'ne': “Beṉe', ¿gague biṉ trigon' goz yežlio c̱hion'? ¿Bixc̱hen' nc̱hix̱en len yix̱e'?” ");
INSERT INTO zpqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nach x̱angaquen' gože' ḻegaque': “To beṉe' chgue'e neda' jen ca'.” Nach xmosen' gose'ene': “¿Che'ndo' ḻažo'to' yix̱en'?” ");
INSERT INTO zpqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na' gože' ḻegaque': “Bitw ḻažo'len. Ḻe xož ḻažo'le lente trigon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jaseyenṉa'. Guac yesecha'on txen. Na' cate' ba goḻe' yotoble cosešen', cana' gona' mandadw zgua'tec ḻažo'le yix̱en' na' gonḻen manoj cont yeseyen. Nach šjaytoble trigon' co'ošagüe'len.” ");
INSERT INTO zpqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nach gozo'e yeto jempl, gozne': ―Šanch beṉe' yosozenag c̱he Diosen' cont ṉabi'e yic̱hjlažda'ogaque'. Da'nan' yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' zaca'leben ca to biṉ c̱he xomdas dan' goz to beṉe' yežlio c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Biṉ c̱he xomdasen' chnabia' nac da' dao' len biṉ ca' chazcho. Perw na' cate' chlan' chcha'ochen ca bichle yix̱e' cuan na' chaquen ca to yag cha'o, nach byiṉ dao' ca' chjasen ližda'ogacba' ḻo xozenṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nach gozoe' Jesúsen' yeto jempl, gozne': ―Yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' zaca'leben ca levadura dan' gwlec no'olen' len to rob yezj cont gwcha'o doxenen. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yogo' da' quinga bsed blo'e Jesúsen' beṉe' ca' besežag gan' zoe'na'. Bsed blo'ede' ḻegaque' be'e jempl, bitwbi bzejni'ide' ḻegaque' sin ca be'e jempl. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bene' ca' cont goc can' bzoj da' beṉe' be' xtiža' Diosen' cani', žan: Gwsed gwlo'egacda'ne' len jempl, na' yapegaca'ne' dan' nono ṉa' ṉeze da' ba ngaše' cate' gwxete yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nach beyož bsed blo'e Jesúsen' beṉe' ca' zjaže' na', beze'e txen len beṉe' ca' zjanaque' ḻe' txen jaya'aque' yo'o gan' nite'na'. Na' cate' ba besyeyo'e ḻo' yo'on' beṉe' ca' zjanaque' ḻe' txen gosebigue' cuite'na' gose'ene': ―Bzejni'išque neto' bi zejen jempl c̱he trigon' na' yix̱en'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nach Jesúsen' gože' ḻegaque': ―Quinga zejen: Diosen' gwseḻe' neda' golja' beṉac̱h na' zaca'lebda' ca ben' goze' biṉ c̱he trigon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na' doxen yežlio nga zaca'leben ca pedas yežlio gan' goze' trigon'. Na' beṉe' ca' chosozenague' c̱he Diosen' cont ṉabi'e yic̱hjlažda'ogaque' zaca'lebde' ca biṉ c̱he trigon'. Na' beṉe' ca' chosozenague' c̱he Satanás dan' chnabia' da' x̱igüe' ca' zjazaca'lebde' ca xsa yix̱en'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Satanásen' zaca'leben ca beṉe' chxi'a ben' goze' xsa yix̱en'. Na' žan' gac juisyw zaca'leben ca žan' yosyotobe' trigon'. Na' angl ca' zaca'lebegaque' ca beṉe' ca' yosyotobe' cosešen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na' can' šey yix̱en' yosyotoben', can' gac c̱he beṉe' ca' chosozenag c̱he Satanásen' cate' žin ža gac juisyon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Diosen' gwseḻe' neda' golja' beṉac̱h na' cate' žin ža, neda' seḻa' angl c̱hia' ca' cont yosyotobe' yogo' beṉe' ca' chesego'oyeḻe' beṉe' yoble yesone' da' mal na' ḻecze yosyotobe' yezica'chle beṉe' cheson da' mal. Na' angl ca' yesyebeje' ḻegaque' cont bich yesenite' txen len beṉe' ca' chosozenague' c̱he Diosen' cont ṉabi'e yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nach yesyeseḻe' ḻegaque' ḻo yi' gabiḻ gan' yeseye' toḻi tocaṉe. Na' yesebežyaše' yesagwxejte ḻaye' tantw yesežaglaochgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cana'ch X̱acho Diosen' gone' cont beṉe' ca' cheson da' güen ṉite' len ḻe', ḻe zjanaque' xi'iṉe' na' yesaque' ca be'ni' c̱he gwbižen' cate' yesežine' yaban' gan' zoa Diosen' chnabi'e. Le'e žia nagle da' chene, ḻe gwzenag xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' naquen ca to mechw xen dan' ngaše' ḻo' yo. To beṉe' bželde' mechw xen da' ngaše' to ḻo' yežlio. Nach bocuašen' da' yoble ḻecze na'ze na' chebechgüede' beze'e jayete' yogo'ḻoḻ bi da' de c̱he' cont gwxi'e yežlion' gan' ngaše' mechua'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Na' yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban', ḻecze zaca'leben ca da' nga goc. Zoa to comerciant beṉe' cha'o perla dan' zjanacchgua xdan. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na' bželde' to perla da' ḻeca zacan'. Na' beyote' yogo'ḻoḻ bi da' de c̱he' na' gwxi'e perlan'. Ca'czen' zaca'lebe beṉe' ca' chesacbe'e zaca'chguan yosozenague' c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Na' yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' zaca'leben ca da' nga goc. Gwnita' baḻ beṉe' gwxen beḻ na' bosozaḻe' yix̱jw beḻ c̱hegaquen' ḻo' nisdaon' na' gwxenen zan cuen beḻ. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nach cate' ba gwža' ḻo' yix̱jon', besyebejen' yo biž, na' gosebie' be ca' zjanac güen par yesagüe' na' gosegüe'eba' ḻo' žome. Na' be ca' bi zjanac güen, gosecho'oṉe'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ca'czen gac c̱he yogo' beṉe' cate' žin ža te c̱he yežlion'. Angl ca' yesebeje' beṉe' mal ca' ladjo beṉe' ca' zjanaque' beṉe' güen lao Diosen' ");
INSERT INTO zpqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na' yosozaḻe' ḻegaque' ḻo yi' gabiḻ gan' yesebežyaše' na' yesagwxejte ḻaye' dan' ḻeca yesežaglagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nach Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―¿Zyejni'ile yogo' da' ca' ba blo'eda' le'e? Nach gose'ene': ―Zyejni'iton'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nach gož Jesúsen' ḻegaque': ―Note'tezle še chac chsed chlo'ele Xtiža' Diosen' dan' byoj cani', še ḻecze chzenagle can' chsed chlo'eda' c̱he yeḻa' gwnabia' c̱he Diosen', nachen' zaca'leble ca to x̱an yo'o beṉe' nape' yogo'ḻoḻ da' zaca' dan' chyažj chc̱hinde', baḻen zjanaquen da' cobe na' baḻen zjanquen da' gole. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nach cate' beyož be' Jesúsen' jempl ca', beze'e latjen' len beṉe' ca' zjanaque' ḻe' txen ");
INSERT INTO zpqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","jaya'aque' laže'. Na' jaysed jaylo'ede' beṉe' gualaž c̱he' ca' ḻo' yodao' c̱hegaquen'. Na' ḻeca besyebande' len xtižen' na' gose' ḻježe': ―¿Ga jasede' yeḻa' sina'? na' ¿nacxec̱hen' chac chone' yeḻa' guac ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nombia'chone', ḻe naque' xi'iṉ ben' chonšagüe' yag. Na' xṉe'ena' lie' María, na' Jacobo, José, Simón na' Judas zjanaque' beṉe' biše'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na' ḻecze beṉe' zane' ca' nite' lažcho nga. ¿Nacxe chaquen' cho'e diža' ca' na' chacte' chone' yeḻa' guac? ");
INSERT INTO zpqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na' dan' gosone' xbab nac Jesúsen' con to beṉe' gualaž c̱hegaque', bi gosaclaže' yesejḻe'e c̱he'. Na' gož Jesúsen' ḻegaque': ―Yogo'ze beṉe' chonḻa'aṉe' beṉe' choe' xtiža' Diosen', perw beṉe' gualaž c̱he' na' beṉe' ḻo' yo'o c̱he' bi chesonḻa'aṉe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na' to c̱hopze yeḻa' guac ben Jesúsen' Nazareten' dan' bitw gosejḻe'e c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na' ca tiempen' Herodes ben' naque' gobernador c̱he distritw Galilean', bende' diža' ca nac yogo'ḻoḻ dan' chon Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nach gože' xmose' ca': ―Bengan' da' Juanṉa', ben' bzoa beṉe' nis. Ba bebane' ladjo beṉe' guat ca', da'nan' chaque' chone' yeḻa' guac. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodesen' gwne' ca' dan' bene' mandadw gosote' da' Juanṉa'. Quingan' goc: Herodesen' beque'e Herodías ca xo'ole' ḻa'czḻa' Herodías naque' xo'ole beṉe' biše' Felipe. Na' Juanṉa' gože' Herodesen': ―Bi cheyaḻa' soalen no'ol c̱he beṉe' bišon'. Na' dan' gož Juanṉa' Herodesen' ca', da'nan' Herodesen' bene' mandadw gosezene' Juanṉa' na' bosoc̱heje' ṉi'a ne'e len gden ḻo' ḻižya gan' gosegüe'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodesen' goclaže' gote' Juanṉa', perw bitwbi bende' ḻe', ḻe gwṉezde' beṉe' zan chesejḻe'e Juanṉa' cho'e xtiža' Diosen', na' bžebe' bi yeson beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Perw na' cate' gosone' ḻṉin' ža la Herodesen', bi' no'ol c̱he Herodías bya'abe' lao beṉe' ca' ja'ac ḻṉin'. Na' ḻeca bebe Herodesen' can' bya'a no'ol güegon', ");
INSERT INTO zpqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","na' bzoe' Diosen' testigw c̱he' gwnežjue'be' bite'teze ṉabebe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na' gwlo'oyeḻa' xṉa'ben' ḻebe' cont gožbe' Herodesen': ―Beṉ neda' to ḻo platw yic̱hj Juan ben' chzoa beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ṉe late'ze bi gwyazlaže' rey Herodesen' gone' can' gož no'ol güegon' ḻe', perw bac̱hle bzoe' Diosen' testigw c̱he' lao beṉe' ca' jasa'ac ḻṉin' gwnežjue'be' bite'teze ṉabebe' ḻe', da'nan' benšaze' mandadw gac can' gwṉabebe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ca' goquen' bene' mandadw jasec̱hogue' yen Juanṉa' ḻo' ḻižya gan' yo'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na' bosožie' yic̱hjen' to ḻo platw cont bosoṉežjuen' no'ol güegon' na' ḻebe' bnežjwben' xṉa'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nach beṉe' ca' zjanaque' txen len da' Juanṉa' jasyexi'e cuerp c̱hen' na' jasecuašen'. Gwde na' ja'aque' gan' zoa Jesúsen' jaseže'ne' can' ba goquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na' cate' bene Jesúsen' can' goc c̱he da' Juanṉa', beze'e latjen' len beṉe' ca' zjanaque' ḻe' txen na' besyeyo'e to ḻo' barcw par ja'aque' to latje daš na' nono nochle ja'aclen ḻegaque'. Perw beṉe' ca' že' yež ca' zjachi' cho'a nisdaon' cate' gosende' ba zjada Jesúsen', na' gosa'ac lažgaque' ja'aque' yo biž jasešague' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na' cate' bžin Jesúsen' cho'a nisdaon', ble'ede' nita' beṉe' zan na' beyaše' beži'ilaže'de' ḻegaque'. Na' beyone' yogo' beṉe' ca' chesacšene. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na' cate' ba chxoa gwbiž gosebiga' beṉe' ca' zjanaque' ḻe' txen lagüen', na' gose'ene': ―Zoacho to latje ga bibi de, na' ba nac bagwže' par gagwcho xgüe. Bze beṉe' quinga diža' cont šjaya'aque' yež dao' ca' dan' zjachi' gaḻa'ze šjasediljue' da' yese'ej yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nach Jesúsen' gože' ḻegaque': ―Bitw cheyaḻa' šjaya'aque', san le'e güe'elne' da' yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nach gose'ene': ―C̱hopga beḻ ya'a c̱hechon' de na' gayo'ga yetextil dao'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nach Jesúsen' gože' ḻegaque': ―Ḻe šjax̱in' ni. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nach ben Jesúsen' mandadw gosebe' beṉe' zan ca' ḻo yixyen'. Na' gwxi'e yetextil ca' gayo' na' beḻ ya'a ca' c̱hope, na' gwṉe'e yabale be'e yeḻa' chox̱clen c̱he Diosen', na' bzoxjen' be'en beṉe' ca' zjanaque' ḻe' txen cont goseyisen' len to to beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na' yogüe' gosagüen' na' goseljde'. Na' bososše'e šižiṉw žome len yetextil bixjw len late' güeje beḻ dan' bega'aṉna'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na' beṉe' ca' gosagw da' ca' zjanaque' ca do gayo' mil beṉe' byo, bi cuent no'ol ca' len bidao'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gwde na' Jesúsen' bene' byen besyeyo'o beṉe' ca' zjanaque' ḻe' txen ḻo' barcon' cont gosebialagüe' besyeḻague' yešḻa'ale nisdaon' šlac bega'aṉ ḻe' beseḻe' beṉe' ca' ližgaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Na' beyož beseḻe' beṉe' ca' ližgaque', gwloe' to ḻo ya'a jaḻ güiže' Diosen' toze'. Na' cate' goḻ, toz Jesúsen' zoe' ḻo ya'an. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na' ca nac barcon' gan' zesyeyo'o beṉe' ca' zjanaque' Jesúsen' txen, ba zejen do gachoḻ nisdaon' nžiga'ses nisen' ḻen dan' chas chata' nisdaon', ḻe ben' chec̱hjen clele. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na' do šbal beyetj Jesúsen' ya'ana' na' gwze'e ḻo nisdaon' na' ba zejgaḻe' gan' zja'aquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nach cate' besele'ede' ḻe' zeje' ḻo nisdaon' ḻeca besežebe', na' bososye'e gosene': ―¡Še da' chda chelen' chle'echo! ");
INSERT INTO zpqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na' ḻa' boḻ güižte Jesúsen' ḻegaque', gože'ne': ―Ḻe gonc̱hac̱h laže'le. Neda'na'. Bitw žeble. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nach Pedroa' gože'ne': ―X̱anto', še da' ḻi le'na', ben mandadw sa'a ḻo nisdaon' yida' gan' zon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nach gož Jesúsen' ḻe': ―Da, Pedro. Na' ḻa' bchojte Pedroa' ḻo' barcon' gwzolao gwze'e ḻo nisdaon' zeje' gan' zoa Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Perw na' cate' gocbe'ede' chec̱hjchgua ben', bžebe' na' gwzolao chebe' ḻo' nisen'. Nach bosye'e, gože' Jesúsen': ―X̱ana', bosla neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na' ḻa' bḻite na' Jesúsen' bex̱ue'ne', na' gože'ne': ―¿Bixc̱hen' chac c̱hopdo'? Gwyejḻe'ch c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nach cate' beyo'o Jesúsen' len Pedroa' ḻo' barcon', ḻa' gwlezte be'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na' beṉe' ca' že' ḻo' barcon' bosozoa xibe' lao Jesúsen' gosonxene'ne', gose'ene': ―Da' ḻicze len' naco' doguale Xi'iṉ Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na' goseḻague' nisdaon' na' besežine' yežlio gan' nzi' Genesaret. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na' cate' beṉe' Genesareten' besyeyombi'e Jesúsen', goseyise' diža' yogo' yež ca' dan' zjachi' gaḻa'ze cont goseṉezde' ba bžin Jesúsen' lažgaque'. Na' beṉe' ca' že' yež ca' gosec̱he'e yogo' beṉe' chesacšene lao Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na' goseṉeyoede' Jesúsen' gwnežjue' latje yesox̱e' ḻa'ch late'ze xṉi'a xen'. Na' yogo' beṉe' gosox̱en' besyeyaquede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na' baḻ beṉe' fariseo ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' gosa'aque' Jerusalénṉa' na' besežine' gan' zoa Jesúsen', na' gose'ene': ");
INSERT INTO zpqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Bixc̱hen' beṉe' ca' zjanaque' le' txen bitw zjana'ogüe' da' cheson beṉe' gol ca'? ¿Bixc̱hen' cbi chosyone'e zan ṉi'a cate' za' yesagüe'? ");
INSERT INTO zpqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nach Jesúsen' gože' ḻegaque': ―Na' le'e ¿bixc̱hen' chbejyic̱hjle cbi chonḻe can' ža Diosen' cheyaḻa' goncho san chonxen costumbr c̱helen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosen' none' mandadw can' goncho, gwne': “Ḻe gap bala'aṉ x̱axṉa'le”, na' “Note'teze' še chṉešaše' len x̱axṉe'e cheyaḻa' gate'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Perw le'e žale guaque ye' to beṉe' x̱axṉe'e: “Bibi de goṉa' gaclena' le'e, ḻe yogo' da' de c̱hia' ba bnežjuan' ḻo na' Dios.” ");
INSERT INTO zpqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na' žale bich bi cheyaḻa' gwnežjue' x̱axṉe'en še ca'. Na' dan' žale ca', chzoale ca'ale dan' ža Diosen' na' con na'ole costumbr gole c̱he da' x̱ozxta'ole ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Le'e nacle beṉe' gwxiye'. Chonḻe cayaṉen' bzoj da' Isaíasen' c̱hele, gan' žan: ");
INSERT INTO zpqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Beṉe' qui chesonxene' neda' len diža' cho'a, perw bi chesonxene' neda' len lažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bibi zejen dan' chesonxene' neda', ḻe dan' chososed chosolo'eden' naquen da' chnalaže' beṉac̱hze. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nach Jesúsen' bozoḻ güiže' beṉe' ca' zjanžaguen' cont gosebigue' lagüen' na' gože' ḻegaque': ―Ḻe gwzenag da' nga ṉia' le'e na' ḻe šejni'i. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bitw ṉacho dan' che'ej chagw beṉac̱hen' chonen cont lažda'ogüen' bi naquen xilaže' len Diosen'. Perw diža' mal dan' chchoj cho'e, ḻenṉa' chonen cont lažda'ogüen' bi naquen xilaže'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nach gosebiga' beṉe' ca' zjanaque' Jesúsen' txen lagüen' gose'ene': ―¿Bi gocbe'edo' beṉe' fariseo ca' beseže'e cate' gosende' xtižo'na'? ");
INSERT INTO zpqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na' gož Jesúsen' ḻegaque': ―Gwžin ža cate' X̱a' Diosen' ben' zoa yaban' gwžiaye'e yogo'ḻoḻ beṉe' bi chosozenag c̱he'. Gwžiaye'e ḻegaque' can' choncho cate' chlažo'cho yix̱e' ca' chesela'ac ḻo yel. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jaseye beṉe' fariseo ca'. Zjanaque' ca to beṉe' lc̱hoḻ beṉe' che'nde' cue'e nez yeto beṉe' lc̱hoḻ. Ṉezecho to beṉe' lc̱hoḻ bitw gac cue'e nez yeto beṉe' lc̱hoḻ, ḻe txen šjasebix̱e' to ḻo' yechw. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nach Pedroa' gože' Jesúsen': ―Bzejni'išque neto' bi zejen can' gwnaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nach gož Jesúsen' ḻegaque': ―¿Lencze le'e bitw chejni'ile da' quinga ba gwnia'? ");
INSERT INTO zpqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Bi ṉezele yogo' dan' che'ej chagw beṉac̱hen' cho'on ḻo' ḻi'e na' chžin hor cheden? ");
INSERT INTO zpqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Perw yogo' diža' dan' chesoe' beṉac̱hen' chesechojen ḻo' yic̱hjlažda'ogüen'. Na' še choe' beṉe' diža' mal, ḻen chonen cont bi nac lažda'ogüen' xilaže' len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ḻe ḻo' yic̱hjlaždao' beṉac̱hen' nan' chchoj yogo' xbab mal cate' žan yesone' da' mal quinga: yesote' beṉe', yesata'lene' no'ol bi nac xo'olgaque' o beṉe' byo bi nac beṉe' c̱hegaque', na' yesone' gwban, yeso'e diža' güenḻaže' c̱he ḻježgaque', na' yeseṉeye'e c̱he beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Xbab mal ca' chesonen cont bi nac laždao' beṉe' xilaže' len Diosen', gague dan' bi chone'e zan ṉi'a cate' za' gagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Beza' Jesúsen' latjen' len beṉe' ca' zjanaque' ḻe' txen jaya'aque' distritw Galilea gaḻa'ze gan' mbane ciuda Tiro na' ciuda Sidón. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na' to no'ole zoa do na', ben' bi naque' beṉe' Israel, gwze'e laže' cont bžine' gan' zoa Jesúsen' na' jašague'ne'. Na' gwṉe' zižje, gože'ne': ―X̱ana', le' naco' xi'iṉ diaža c̱he da' rey David. Beyaše'šque neto'. To bi' no'ol c̱hia' yo'o nyaz da' x̱igüe' yic̱hjlažda'obe' na' ḻeca chžaglaobe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Perw Jesúsen' bitw boži'e xtiža' no'olen'. Nach beṉe' ca' zjanaque' Jesúsen' txen gosebigue' cuite'na' na' gosata'yoede' ḻe' gose'ene': ―Boži'išca no'olen', ḻe con nagüe' chio' choḻ güiže' le' zižje cont gacleno'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nach gož Jesúsen' ḻegaque': ―Diosen' gwseḻe' neda' cont chaclena' beṉe' Israel gualaž c̱hecho na'ze, ḻe ḻegaque' zjazaca'lebe' ca xila' dao' be zjanacžeje. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nach no'olen' gwbigue' bzoa xibe' lao Jesúsen', na' gože'ne': ―X̱ana', goclenšca neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nach gož Jesúsen' ḻe': ―Bitw naquen güen yeca'acho yeḻa' guagw c̱he xi'iṉcho na' gwnežjwchon gagw beco' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nach gože'ne': ―Leczdo' X̱ana'. Perw beco' ca' guac yesagwba' bḻa'a dao' da' cheselažo' ḻo yo. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nach Jesúsen' gože'ne': ―No'ole, ḻeca chejnilažo' neda'. Guaclencza' le' can' chaclažon'. Na' ḻa' beyacte xi'iṉ no'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Beza' Jesúsen' latjen' len beṉe' ca' zjanaque' ḻe' txen goso'e nezen' dan' chde gaḻa'ze cho'a nisdao' Galilean'. Nach gosepe' to ḻo ya'a jasechi'e ḻo ya'ana'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na' besežin beṉe' zan ḻo ya'a gan' zoa Jesúsen' len beṉe' ca' zjanaque' ḻe' txen. Zjanc̱he'e no beṉe' nxiṉj ṉi'e, beṉe' lc̱hoḻ, beṉe' bi chac ṉie', beṉe' bi zoa ṉi'a na'gaque', na' len beṉe' chese'e gwde gwdele yižgüe', na' bosonite' ḻegaque' xṉi'a Jesúsen'. Na' Jesúsen' beyone' yogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na' ḻeca besyebane beṉe' ca' cate' besele'ede' can' besyeṉe beṉe' ca' bi gosac yeseṉe, na' besyeyac beṉe' bi zjazoa ṉi'a na'gaque', na' besyeda beṉe' nxiṉj ṉi'e, na' besele'e beṉe' lc̱hoḻ ca'. Nach gosonxene' Diosen' ben' chonxen chio' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gwde na' Jesúsen' goxe' beṉe' ca' zjanaque' ḻe' txen na' gože' ḻegaque': ―Cheyaše'da' beṉe' qui, ḻe ba goc šoṉe ža zjanite' nga len neda', na' bibi de da' yesagüe'. Na' bi chaclaža' yosa'ane' sin cbi yesagüe' cont bi yesec̱hoḻde' chanez. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nach ḻegaque' gose'ene': ―Gan' zoacho nga naquen to latje daš ga bibi de. ¿Gaxe želecho da' yesagw yogo' beṉe' quinga? ");
INSERT INTO zpqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nach gož Jesúsen' ḻegaque': ―¿Gaca' yetextilen' de c̱hele? Nach gose'ene': ―Gažga yetextil dao' zjade na' to c̱hopga beḻ ya'a dao'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nach Jesúsen' bene' mandadw yesebe' beṉe' zan ca' ḻo yon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na' gwxi'e yetextil ca' gaže na' len beḻ ya'a dao' ca', nach be'e yeḻa' chox̱clen c̱he Diosen', nach bzoxjen' bnežjuen' beṉe' ca' zjanaque' ḻe' txen na' ḻegaque' bosonežjue' c̱he yogo' beṉe' nita' na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na' yogüe' gosagüe' goseljde'. Gwdena' bososše'e yegaže žome len late' güeje yeḻa' guagw dan' bega'aṉna'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na' beṉe' ca' gosagw yetextilen' len beḻen' nac tap mil beṉe' byo, na' bi cuent no'ole ca' len bidao' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nach beyož beseḻa' Jesúsen' beṉe' ca' ližgaque', na' beyo'e to ḻo' barcw len beṉe' ca' zjanaque' ḻe' txen na' ja'aque' distritw gan' nzi' Magdala. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na' goquen' baḻ beṉe' fariseo ca' na' beṉe' saduceo ca' gosebigue' gan' zoa Jesúsen', na' cont yesagüe' xya c̱he' goseṉabe' gone' to yeḻa' guac da' yesele'ede' ḻe'e yaban' cont yeseṉezde' še da' ḻicze Diosa' gwseḻe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nach Jesúsen' gože' ḻegaque': ―Cate' chle'ele chexṉa ḻe'e yaban' šeže'le nach žale: “Yeža'a gwx̱e dan' chexṉa ḻe'e yaban'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na' cate' chle'ele zete bejw xṉa ḻe'e yaban' do cheni' nach žale: “Guac yejw zag, ḻe ze bejw xṉa ḻe'e yaban'.” Nacle beṉe' gwxiye', ḻe ṉezele še guac yejw zag o še guac zeye' caten' chle'ele can' nac ḻe'e yaban', perw bi chacbe'ele bi zejen da' ca' chon Diosen' tiemp nga zoacho ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Le'e zoale ṉa'a nacchguale beṉe' laždao' xi'a na' ba gwlejyic̱hjle Diosen'. Da'nan' chṉable gona' yeto yeḻa' guac da' le'ele cont ṉezele še Diosen' gwseḻe' neda'. Perw bitw gona' can' chṉablen', ḻe ba ble'ele da' chona'. Dan' gon Diosen' len neda' cont ṉezele ḻe'na' gwseḻe' neda' naquen ca dan' bene' len da' Jonás ben' be' xtiža' Diosen' cani'. Nach beyož gwna Jesúsen' ca', beze'e len beṉe' ca' zjanaque' ḻe' txen gan' nita' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na' cate' besežine' yešḻa'a nisdao' Galilean', beṉe' ca' zjanaque' Jesúsen' txen gosacbe'ede' gosanḻaže' yetextil da' yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nach Jesúsen' gože' ḻegaque': ―Ḻe gon xbab, ḻe gwsaca' len levadura c̱he beṉe' fariseo ca' na' c̱he beṉe' saduceo ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nach gose' ḻježgaque': ―Gwne' ca' ḻe gague bi yetextilen' noa'chon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na' Jesúsen' gocbe'ede' xbab dan' gosone', na' gože' ḻegaque': ―¿Bixc̱hen' chacžejlaže'le da' bibi yetextil de? ¿Bi chejḻe'le napa' yeḻa' guac par gwguagua' le'e? ");
INSERT INTO zpqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Biṉa' šejni'ile? na' ¿ba gonḻaže'le can' bguagua' gayo' mil beṉe' byo len gayo'ze yetextil dao'? na' ḻecze ¿bitw zalaže'le do yebaḻ žome pedas yetextil botoble dan' becho'oṉen? ");
INSERT INTO zpqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na' ¿c̱hixe tap mil beṉe' byo ca' bguagua' len gažze yetextil dao'? ¿Zalaže'le yebaḻ žome pedas yetextil can' botoble dan' becho'oṉen? ");
INSERT INTO zpqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bixc̱hen' con benḻe xbab c̱he yetextilen' cate' gwnia' le'e gwsaca'le len levadura c̱he beṉe' fariseo ca' na' c̱he beṉe' saduceo ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nach beṉe' ca' zjanaque' Jesúsen' txen gosacbe'ede' gague be'e diža' c̱he levadura dan' chosoc̱hine' par chcha'o yetextilen' san be'e dižan' ca' cont bi yosozenague' c̱he dan' chososed chosolo'e beṉe' fariseo ca' na' beṉe' saduceo ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nach Jesúsen' len beṉe' ca' zjanaque' ḻe' txen besežine' gaḻa'ze to ciuda dan' nzi' Cesarea de Filipo. Nach Jesúsen' gože' beṉe' ca' gosa'aclene' ḻe': ―Diosen' gwseḻe' neda' golja' beṉac̱h. Perw ¿bi chesena beṉe'? ¿non' naca' neda'? ¿Bi chesene'? ");
INSERT INTO zpqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na' gose'ene': ―Baḻe' chesene' naco' da' Juan ben' bzoa beṉe' nis. Na' yebaḻe' chesene' naco' Elías ben' be' xtiža' Diosen' cani'. Na' yebaḻe' chesene' naco' da' Jeremías o yeto beṉe' be' xtiža' Diosen' cani'te. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nach gože' ḻegaque': ―¿C̱hixe le'e? ¿No žale naca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nach Simón Pedroa' gože'ne': ―Len' naco' Cristo ben' gwlej Diosen' cont ṉabi'o, na' naco' dogualje Xi'iṉ Dios, Dios ben' zoa toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nach Jesúsen' gože'ne': ―Simón xi'iṉ Jonás, mbalaz zo' dan' gwnao' ca'. Notno beṉac̱h bzejni'i le' ṉao' ca'. Toz X̱a' Dios ben' zoa yaba, ḻen' ba bzejni'iden' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na' neda' žia', len' lio' Pedro na' zeje dižan' yej. Na' ca to beṉe' güen yo'o chbeje' yej gual cont gonen žin cate' cueque' len yo'on, ca'cze chbeja' le' gono' xšina', gaco' beṉe' nechw yotobo' beṉe' yesonxene' neda'. Na' bitwbi gac yeson da' x̱igüe' ca' yosolej yosošošjen beṉe' ca' yesonxene' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na' gona' ḻo nao' zgua'tec le' go'o xtižan' len beṉe' zan cont yosozenague' c̱he Dios ben' zoa yaban' na' ṉabi'e yic̱hjlažda'ogaque'. Na' ḻecze naquen ḻo nao' yo'o beṉe' ca' yesonxene' neda' bica' da' ca' nac güen yesone' na' bica' da' ca' cbi nac güen yesone'. Na' Diosen' gwzejni'ide' le' naquen' ye'gaco'ne' cont yežaguen len dan' ža Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nach Jesúsen' gože' ḻegaque' nono yese'e še naque' Cristo ben' gwlej Diosen' cont ṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na' žana' Jesúsen' gwzolagüe' bzejni'ide' beṉe' ca' zjanaque' ḻe' txen cheyaḻa' šeje' Jerusalénṉa'. Na' gože' ḻegaque' beṉe' gole blao ca' chesenabi'e nación c̱hechon', na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisés yosoc̱hi yososaque' ḻe' na' yesote' ḻe'. Perw yeyoṉ ža yebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nach Pedroa' gwc̱he'e Jesúsen' gan' nac lchojiže na' gwzolagüe' be'lene' ḻe' diža' gwdiḻe' ḻe', gože'ne': ―X̱ana', Diosen' gaclene' le'. Bitw gac c̱hio' ca dan' žo' nga. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Perw Jesúsen' gwyec̱hje' gwṉe'e Pedroa' gože'ne': ―¡Gwcuas ca'ale Satanás! Chgo'oyeḻo' neda' bi gona' can' nžia bia' Diosen' gona'. Bi nsa'o xbab c̱he Dios, san nsa'o xbab c̱he beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gwde na' Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Note'teze beṉe' še chaclaže' gaque' neda' txen, cheyaḻa' cuejyic̱hj cuine' ḻa'czḻa' žaglagüe' na' con gone' can' ṉia' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Note'teze beṉe' chacde' gone' cont bi žaglagüe' o cont nono yesot ḻe', benan' cuiayi'. Na' note'teze beṉe' chzanḻaže' cuine' žaglagüe' o gate' ṉe c̱hia' neda', ba de yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Bixe zejenṉa' to beṉe' ṉabi'e doxen yežlion' na' cuiaye'e bi gata' yeḻa' mban c̱he' toḻi tocaṉe? Ḻe bi zoa nacle gon beṉac̱hen' c̱hixjue' cont gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Diosen' gwseḻe' neda' golja' beṉac̱h na' cate' yida' yežlio nga da' yoble nsa'a yeḻa' zaca' juisyw c̱he X̱a' Diosen' na' nc̱hi'a angl c̱hia' ca', cana'ch gona' cont to to beṉac̱hen' ṉite' mbalaz o yesezaca'zi'e ṉec̱he da' goson to toe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na' da' ḻi žia' le'e, baḻle nita'le nga ṉa'a biṉa' gatle cate' žin ža le'ele neda' yida' gwlo'a yeḻa' gwnabia' c̱hian', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gwde x̱op ža Jesúsen' gwc̱hi'e Pedroa' len Jacobo na' Juan beṉe' biše' Jacobo na' ja'aque' to ḻo ya'a sibe. Na' nono nochle ja'aclen ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na' lao ḻegaque' bža' ca goc Jesúsen', cho'alagüen' goctiten ca gwbiž, na' xaḻanen' beyaquen šiš xila' ca be'ni'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na' concze besele'ede' da' Moisésen' len da' Elíasen' na' chosošalje' len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nach Pedroa' gože' Jesúsen': ―¡X̱anto', ḻeca güenṉa' zoacho nga! Še chaclažo', gonto' šoṉe ranšw, to c̱hio', na' to c̱he Moisés, na' yeto c̱he Elías. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ṉe' choe'te Pedron' dižan' ca' cate' to bejw da' chactiten gwyec̱hjen ḻegaque' na' ladjo bejon' gosende' gwna Diosen': ―Benga Xi'iṉa' ben' chacda'. Chbe chezaquelaže'chgüeda' c̱he'. Ḻe gwzenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na' cate' beṉe' ca' nc̱he'e Jesúsen' gosende' diža' ca' besežebchgüe', con gosaze' cosc̱ho'ale ḻo yon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nach gwbiga' Jesúsen' gwx̱oa ṉe'e yic̱hjgaquen' na' gože'ne': ―Ḻe yeyas. Bitw žeble. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na' cate' besyec̱his lagüen', noch no besele'ede' san toze Jesúsen' zie'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na' gwde na' šlac chesyeyetje' ḻo ya'an Jesúsen' gože' ḻegaque': ―Nono ye'le can' nac dan' ba ble'ele nga. Cate'ch ba bebana' ladjo beṉe' guat ca', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h, cana'ch güe'le diža' c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nach beṉe' ca' zja'aclen Jesúsen' gose'ene': ―Beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' chososedde' neto' chesene' zgua'tec da' Elías ben' gwzoa cani' cheyaḻa' yide' da' yoble cate' za' yedeṉabia' ben' seḻa' Diosen'. ¿Bixc̱hen' chesene' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nach Jesúsen' gože' ḻegaque': ―Da' ḻicze zgua'tec yid da' Elíasen' na' yeyonšagüe' yogo'ḻoḻ. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Perw žia' le'e, Elías ba bide' na' bi gosacbe'e beṉe' še nac ḻe'. Na' gosonde' ḻe' con ca gosaclaže'. Na' ca'czen' yosoc̱hi yososaque' neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nach beṉe' ca' zja'aque' len Jesúsen' gosacbe'ede' cho'e diža' c̱he da' Juan ben' bzoe' beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na' cate' besežine' gan' zjanžag beṉe' zan, to beṉe' bšague' Jesúsen' na' bzoa xibe' lagüe'na' gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―X̱ana', beyaše'laže'šca xi'iṉa' nga. Chazbe' šon na' ḻeca chžaglaobe' len ḻen. Na' zan ṉi'a ba jac̱hazbe' ḻo yi' na' ḻecze zan ṉi'a ba blažo'be' ḻo nis. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ba bedesana'be' lao beṉe' ca' zjanaque' le' txen, perw bitw gosaque' yesyeyone'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nach Jesúsen' gože' beṉe' ca' že'na': ―¡Le'e beṉe' bi chejnilaže', chonchguale clele! ¿Batca' zelao ṉa'lagua' le'e? Bedesan bidaon' ni. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nach Jesúsen' bene' mandadw yechoj da' x̱igüen' yo'o nyazen yic̱hjlaždao' bidaon' na' ḻa' bechojten. Na' ḻa' beyaquetebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na' gwde goc ca', beṉe' ca' zjanaque' Jesúsen' txen gosebigue' lagüen' cate' zoe' toze', na' gose'ene': ―¿Bixc̱hen' bi goc neto' yebejto' da' x̱igüen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesúsen' gože' ḻegaque': ―Bitw goc yebejlen dan' bitw gwyejḻe'le Diosen' gone' yechojen. Xsa xomdasen' naquen da' dao' riz. Na' da' ḻi žia' le'e, ḻa'czḻa' dan' chejnilaže'le Diosen' naquen ca to xsa xomdas lagüe dan' bi chejnilaže'teclene', še šejnilaže'lne', guaque ye'le ya'a nga: “Gwcuas nga, na' jayzoa na'ate”, na' gac can' ṉalen'. Bitw bi de dan' bi gac gonḻe con še chejḻe'le Diosen' gone' gaquen. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Na' cont yebejle da' x̱igüe' ca' dan' zjanac ca dan' bebeja' yic̱hjlaždao' bidao'na', cheyaḻa' gwyo gwc̱hejle gonḻe gwbas na' zoatezle yoḻ güižle Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na' šlac zjayda Jesúsen' len beṉe' ca' zjanaque' ḻe' txen do gan' mbane distritw Galilea, Jesúsen' gože' ḻegaque': ―Diosen' gwseḻe' neda' golja' beṉac̱h, na' yosodie' neda' ḻo na' beṉe' chesegue'ede'nda', ");
INSERT INTO zpqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na' yesote'nda'. Perw na' yeyoṉ ža yosban Diosen' neda' ladjo beṉe' guat ca'. Nach beṉe' ca' zjanaque' Jesúsen' txen cate' gosende' xtiže'na' gosacyaše'chgüede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na' cate' besyežine' Capernaum, beṉe' ca' chosoc̱hixjue' c̱he gastw c̱he yodao' blao c̱he chio' beṉe' Israel ja'aque' lao Pedroa'. Na' gose'ene': ―¿Bi chyixjw maestrw c̱helen' da' cheyaḻa' c̱hixjue' c̱he yodaon'? ");
INSERT INTO zpqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nach gož Pedroa' ḻegaque': ―Chyixjuen'. Gwde gwna Pedroa' ca' gwyo'e ḻo' yo'ona'. Nach Jesúsen' ḻa' gožtie' ḻe': ―¿Bi xbab chono', Simón? Ca nac beṉe' gwnabia' ca' nita' yežlio nga, ¿non' chacdo' chosoc̱hixjue'? ¿beṉe' gualaž c̱he' o še beṉe' zito'? ");
INSERT INTO zpqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nach Pedroa' gože'ne': ―Chosoc̱hixjue' beṉe' zito'. Nach Jesúsen' gože' ḻe': ―Beṉe' zjanaque' biše' ḻježe' bitwbi cheseyixjue'. Na' chio' naccho xi'iṉ Dios ben' zoa yaba chnabi'e, bitw cheyaḻa' c̱hixjwcho c̱he yodaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Perw cont nono yeson xbab chgue'echo yodao' blaon', na' c̱hixjwcho. Gwyej cho'a nisdaon', na' bzaḻa' yix̱jw c̱hion' na' beḻ nechw be seno', ḻo cho'aba'na' želdo' to mechw. Na' yeyox̱on' šjadixjo' c̱hechon'. Guaqueczen par šjadixjo' c̱he c̱hopcho. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nachen' beṉe' ca' zjanaque' Jesúsen' txen gosebigue' cuite'na', na' gose'ene': ―¿No neto' gacchto' blao cate' Diosen' ben' zoa yaban' gone' cont ṉabi'o? ");
INSERT INTO zpqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na' Jesúsen' goxe' to bidao' na' bzeche'be' gachoḻ ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na' gože'ne': ―Da' ḻi žia' le'e, note'tezle še bi gwša' xbab c̱helen' cont gwzenagle c̱he Diosen' ca chon to bidao' cate' chzenagbe' c̱he x̱axṉa'be', gwbat ṉabia' Diosen' ben' zoa yaban' yic̱hjlažda'ole. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na' note'teze beṉe' še yeyaque' ca bidao' nga na' gwzex̱jwlaže' lao Diosen', nach gaque' beṉe' blao len neda' cate' Diosen' ben' zoa yaba gone' cont solao ṉabi'a. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Note'teze beṉe' chone' güen len to bidao' ca bi' nga ṉec̱he da' chejnilaže' neda', choncze' güen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Note'teze beṉe' chon cont lažo' to beṉe' za' gwzolagüe' chejnilaže' neda' gone' da' xiṉj, yejṉi'acle yosoc̱heje' yene' to yiše xen na' yosozaḻe'ne' ḻo' nisdaon' clel ca da' gone' cont lažo' beṉe' yoble gone' da' xiṉjen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nyaše'chguaze gac c̱he beṉac̱hen' da' zjade da' zan yežlio nga da' chesonen cont yesone' da' xiṉj. Bia'cze gata' dan' yeson cont lažo' beṉe' yesone' da' xiṉj, perw nyaše'chguaze gac c̱he beṉe' chon cont lažo' beṉe' yoble gone' da' xiṉjen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Na' da' ḻi žia' le'e, še ṉi'a na'len' chonen cont gonḻe da' xiṉj, cheyaḻa' cuejyic̱hjle da' malen' chonḻe. Yejṉi'a bibi ṉi'a na'len' soa clel ca gonḻe da' xiṉjen' len ḻen. Na' yejṉi'a šjayzoale len Diosen' toḻi tocaṉe bi zoa šḻa'a taca'len' o nchog šḻa'a ṉi'alen' clel ca yeyejle ḻo yi' gabiḻ nya' cuerp c̱helen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na' še yejlaolen' chonen cont gonḻe da' xiṉjen', cheyaḻa' cuejyic̱hjle da' malen' chonḻe. Yejṉi'a bibi yejlaolen' cuia clel ca gonḻe da' xiṉjen' len ḻen. Na' yejṉi'a šjayzoale len Diosen' toḻi tocaṉe zoa šḻa'aze yejlaole clel ca yežinḻe ḻo yi' gabiḻ žia chop ḻa'a yejlaolen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Bi gonḻe note'teze beṉe' chejnilaže' neda' ca beṉe' bibi zaca'tec, ḻa'czḻa' bitec zaque' len beṉac̱h. Žia' le'e, angl ca' chesape' ḻegaque' ḻecze nite' lao X̱a' Diosen' yaban' gan' zoe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na' ca naca' neda', Diosen' gwseḻe' neda' golja' beṉac̱h cont gwnežjua' yeḻa' mban toḻi tocaṉe c̱he beṉe' ba zjambiayi'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Bixe chonḻe xbab? Še nita' to gayoa xila' c̱hele na' yex̱jw toba' ¿bi yocua'aṉle be ca' yetaplalj togaḻj do ḻo ya'a na'ze na' šjaydiljwle ben' bex̱jua'? ");
INSERT INTO zpqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na' da' ḻi žia' le'e, cate' yeželeleba' yebechle dan' beželban' clel ca can' chebele c̱he be ca' taplalj togaḻj ben' bi gosacžeje. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ca'czen' naquen len beṉe' ca' chesejnilaže' neda' beṉe' ca' bitec bi zjazaque' len beṉac̱hen'. X̱acho Diosen' ben' zoa yaban' bitw che'nde' cuiayi' ṉe toe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Še to beṉe' ḻježle gone' mal contr to le'e, šejle šje'elenḻene' diža' chopzle can' nac dan' chonen' cont yetiṉjden'. Na' še gwzenague' diža' dan' šje'elenḻenen', yezoe' binḻo len Diosen' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Perw še bi gwzenague' diža' dan' šje'elenḻenen', güench c̱he'ele yeto o yec̱hope beṉe' ḻježle cont yesaque' testigw ba gota'yoele ben' yoša' xbab c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na' še bitwcze gwzenague' c̱hele, ḻe güe' diža' can' chonen' lao yogo'le gan' chdop chžagle chonxenḻe Diosen'. Na' še ṉeca gwzenagcze' c̱he yogo'le, cbich gonḻne' cuent len le'e chdop chžagle chonxenḻe Diosen'. Perw ḻe gon cuent naque' txen len beṉe' ca' bi chesejnilaže' Diosen', ca no beṉe' güec̱hixjw beṉe' chesonchgüa da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Da' ḻi žia' le'e, naquen ḻo na'le ye'le beṉe' ca' yesonxene' neda' bica' da' nac güen yesone' na' bica' da' ca' bi nac güen yesone'. Na' Diosen' gwzejni'ide' le'e naquen' ye'gaclene' cont yežaguen len dan' ža Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Na' da' yoble žia' le'e, še c̱hople nita'le yežlio nga gwxi'ale bin' ṉabele Diosen', X̱a' Diosen' ben' zoa yaban' goncze' dan' ṉabelenen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na' gan' nžag c̱hope šoṉle chonxenḻe neda', zoacza' txen len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nach Pedroa' gwbigue' gože' Jesúsen': ―X̱ana', še beṉe' ḻježa' chone' da' mal contr neda', ¿baḻ ṉi'a cheyaḻa' yezi'xena' c̱he'? ¿zelao do gaž ṉi'a? ");
INSERT INTO zpqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nach Jesúsen' gože'ne': ―Žia' le', gague cheyaḻa' yezi'xen c̱he ḻježle zelao do gaž ṉi'a, san yogo'te ṉi'a cheyaḻa' yezi'xen c̱he ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Na' yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' zaca'leben ca da' nga goc. Zoa to beṉe' gwnabia' ben' chesaḻa' xmose' ca' xmechue'. Na' goclaže' yebeje' cuent len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na' cate' gwzolagüe' bezi'e cuent c̱he to toe', da' nechw bžin to xmose' ben' chaḻa' zan millón. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na' mosen' bitwbi xmechue' gota' par yonežjuen'. Da'nan' beṉe' gwnabian' bene' mandadw ta'ogaque' len xo'ole', len xi'iṉe' ca' na' len doxen da' zjade c̱he' cont yeyaxjw dan' chaḻe' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nach mosen' bzoa xibe' lao beṉe' gwnabian' gota'yoede' ḻe' gože'ne': “X̱ana', gwdapešca yeḻa' chxenḻaže' len neda', na' yeyoṉa' doxen dan' chaḻa' c̱hion'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nach beṉe' gwnabian' beyaše'de' ḻe' na' bezi'xene' c̱he doxen dan' chaḻe' na' bsane' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Perw na' cate' bechoj mosen' liž x̱anen', ḻa' bežagtie' yeto mos ḻježe' beṉe' chaḻa' late' xmechue'. Nach ḻa' gwṉizte' yene' gože'ne': “Yeyoṉo' dan' chaḻo' c̱hian' ṉetec ṉa'a.” ");
INSERT INTO zpqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nach mos ḻježen' ḻa' bzoate' xibe' lagüen', gože'ne': “Gwdapešca yeḻa' chxenḻaže' c̱hia' na' yeyoṉa' doxen dan' chaḻa' c̱hion'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Perw na' mos nechon' bitw bzenague' c̱he mos ḻježen'. Ḻa' gwyejte' jene' mandadw goseyix̱jue'ne' ḻižya na' bi yechoje' še biṉa' yonežjue' dan' chaḻe' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na' mos ca' yezica'chle cate' besele'ede' can' ben' mos nechon', ḻeca gosacde' zi'. Na' ja'aque' lao beṉe' gwnabian' jaseže'ne' yogo'ḻoḻ can' goca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nach beṉe' gwnabian' goxe' mos nechua' da' yoble lagüe'na', gože'ne': “Le' naco' to beṉe' xi'achgua. Neda' bezi'xena' c̱hio' doxen dan' chaḻo' c̱hian' dan' gota'yoedo' neda' yezi'xena' c̱hion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Bixc̱hen' bi beyaše'do' mos ḻježo' ben' chaḻe' c̱hion' can' beyaše'da' le'?” ");
INSERT INTO zpqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na' bža'achgua beṉe' gwnabian' na' bdie' ḻe' ḻo na' beṉe' goseyix̱jue'ne' ḻižya ga žaglaogüe', na' bi yechoje' še biṉa' yeyixjue' doxen dan' chaḻe' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nach Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Can' gon X̱a' Diosen' ben' zoa yaban' len note'tezle še bi chezi'xenḻe c̱he ḻježle do yic̱hj do laže'le bite'teze dan' chesonde' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na' Jesúsen' cate' beyož gwne' da' ca' beze'e distritw Galilean' na' gwḻague' yegw Jordánṉa' beyeje' gan' mbane distritw Judean'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na' beṉe' zan ja'aclen ḻe', na' beyone' beṉe' ca' chesacšene. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na' baḻ beṉe' fariseo ja'aque' gan' zoe'na', ḻe gosaclaže' yesebeje'ne' diža' da' yosoc̱hine' cont gosožie'ne' xya c̱hoḻ, nach gose'ene': ―¿Guac to beṉe' nšagna' yele'e len xo'ole' še bite'teze dan' chone' cbi cholaže' beṉe' c̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nach gože' ḻegaque': ―¿Biṉa' gwlable can' nyoj Xtiža' Diosen'? Žan cate' gwxe yežlion' Diosen' bene' beṉe' nechw ca' to beṉe' byo na' to no'ole. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na' gwna Diosen': “Da'nan' beṉe' byon' gwsane' x̱axṉe'e cont soalene' no'ole c̱hen' na' chope' yesaque' ca toz beṉe'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na' ca' bich yesac c̱hope' san toze'. Da'nan' bi cheyaḻa' yesyele'e, ḻe Diosen' ba bcode' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nach gose'ene': ―Še naquen ca' ¿bixc̱hen' ben da' Moisésen' mandadw cate' to beṉe' yele'e len no'ol c̱hen' cheyaḻa' c̱has to yiš da' gwnežjue' no'ol c̱hen' ga güen' diža' besyele'ena'? ");
INSERT INTO zpqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesúsen' gože' ḻegaque': ―Da' Moisésen' be'e latje yela'ale len no'ol c̱hele lagüe dan' nacle beṉe' güedenag len Diosen'. Perw cate' Diosen' bene' beṉe' nechw ca' bitw ṉacho goclaže' yesyele'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Žia' le'e, note'teze beṉe' chele'e len no'ol c̱he' na' cheque'e no'ole yoble, ḻen ṉeztede' no'ol c̱hen' bitw naque' to no'ole chzoa xtoe', toz ca da' xiṉjen' chone' ca nac dan' chon ben' chata'lene' no'ol c̱he beṉe' yoble. Na' note'teze beṉe' yošagna'lene' to no'ole beṉe' bela'a len beṉe' c̱he', ḻecze tozcze ca da' xiṉj gone' ca nac da' chon beṉe' chata'lene' no'ol c̱he beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nach beṉe' ca' zjanaque' Jesúsen' txen gose'ene': ―Še can' naquen c̱he beṉe' byo na' no'ole, güench nono gwšagna'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesúsen' gože' ḻegaque': ―Gague yogo' beṉe' yesejni'ide' da' nga, šinze beṉe' ca' ba bzejni'i Diosen' ḻegaque' bi zejen. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nita' beṉe' bi žan yosošagne'e dan' gosalje' bi zjanya' cuerp c̱he', na' ḻecze nita' beṉe' bi chosošagne'e lagüe dan' gosone beṉe' ḻegaque' cont bi zjanya' cuerp c̱hegaque'. Na' ḻecze ca' nita' beṉe' cbi chosošagne'e lagüe dan' chesazlaže'che' yesone' xšin Diosen' ben' zoa yaban' chnabi'e. Ḻe gwzenag c̱he dan' ba gwnian' še ba ben Diosen' cont chejni'ilen. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na' ja'ac beṉe' jasesane' bidao' lao Jesúsen' cont x̱oa ne'e yic̱hjgacbe' na' ṉabe' lao Diosen' gaclene' ḻegacbe'. Perw beṉe' ca' zjanaque' ḻe' txen gosediḻe' beṉe' ca' zjanc̱he'ebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nach Jesúsen' gože'ne': ―Ḻe güe' latje yesid bidao' ca' lagua' nga, na' bi gwžonḻe, ḻe beṉe' ca' zjanac ca bidao' quinga, ḻegaque' chosozenague' c̱he Diosen' ben' zoa yaba cont chnabi'e yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na' beyož gwx̱oa na' Jesúsen' yic̱hjgacbe' gwṉabe' lao Diosen' gaclene'be', nach gwyeje' ga yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na' goquen', to beṉe' güego' bžine' gan' zoa Jesúsen', na' gože'ne': ―Maestrw, le' naco' beṉe' güen. ¿Bi da' güen cheyaḻa' gona' cont gata' yeḻa' mban c̱hia' toḻi tocaṉe? ");
INSERT INTO zpqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nach Jesúsen' gože'ne': ―¿Bixc̱hen' žo' naca' beṉe' güen? Toz beṉe' güen zoa, na' ḻen' naque' Dios. Perw na' še chaclažo' gata' yeḻa' mban c̱hio' toḻi tocaṉe, cheyaḻa' gono' can' non Diosen' mandadw goncho. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nach gože' Jesúsen': ―¿Bica' da' ca'? Nach Jesúsen' gože' ḻe': ―Nono gotle, bi gata'lenḻe no'ol bi nac no'ol c̱hele o beṉe' byo beṉe' bi nac beṉe' c̱hele, bi cuanḻe, bitw güe'le diža' güenḻaže' c̱he beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ḻe gap bala'aṉ x̱axṉa'le, na' ḻe gaque ḻježle can' chaque cuinḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nach beṉe' güegon' gože' Jesúsen': ―Yogo'ḻoḻ da' quinga gwzolagua' chonczan' cate' ṉe' nactia' bidao'. ¿Bixe dan' chyažjech gona'? ");
INSERT INTO zpqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesúsen' gože'ne': ―Še chaclažo' gaco' cayaṉen' chazlaže' Diosen', jayete' yogo' da' de c̱hio', na' da' le'edo' c̱hen bnežjon beṉe' yaše'. Nach še gono' ca', cate' yežino' yaba gan' zoa Diosen', da' zaca'ch gata' c̱hio'. Na' še ba beyož beno' can' žia' le', nach sao' gaco' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Perw na' beṉe' güegon' cate' beyož bende' diža' can' gož Jesúsen' ḻe', beza'yaše', ḻe beṉe' gwṉi'achgua goque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gwde na' Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Da' ḻi žia' le'e, ḻeca zdebe naquen to beṉe' gwṉi'a gwzenague' c̱he Dios ben' zoa yaba cont Diosen' ṉabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Da' yoble žia' le'e, bedao'ch te to be xen be nzi' camello to ḻo' nag yeše' clel ca to beṉe' gwṉi'a gwzenague' c̱he Dios cont Diosen' ṉabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na' beṉe' ca' zjanaque' Jesúsen' txen ḻeca besyebande' cate' gosende' xtižen', nach gosene': ―¿Noxen' šjayzoa len Diosen' še ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesúsen' gwṉe'e ḻegaque', nach gože'ne': ―Bibi de da' gac yeson beṉac̱hen' cont šjasyenite' len Diosen', perw bi zoa da' ṉacho da' bi gac gon Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nach Pedroa' gože' Jesúsen': ―Neto' ba gwlejyic̱hjto' yogo' da' de c̱heto' cont nacto' le' txen. ¿Bi da' güen gata' c̱heto' dan' ba gwlejyic̱hjto' da' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesúsen' gože' ḻegaque': ―Da' ḻi žia' le'e, Diosen' gwseḻe' neda' golja' beṉac̱h na' cate' yocobe' yežlion', neda' cui'a ṉabi'a güen juisyw can' chnabia' Dios ben' zoa yaba. Na' le'e šižiṉwle cue'le cuita'na' ṉabia'le šižiṉw cuen beṉe' ca' zjanaque' xi'iṉ diaža c̱he da' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na' note'teze beṉe' ba gwlejyic̱hje' liže', biše', zane', x̱axṉe'e, xo'ole', xi'iṉe' o yežlio c̱he', dan' chzenague' c̱hia', Diosen' gwnežjue' ḻe' da' zaca'ch da' xench ca yogo' da' ca'. Na' ḻecze gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Perw zan beṉe' zjanaque' beṉe' žialao ṉa'a, gwžin ža cate' yesaque' beṉe' bzebe. Na' beṉe' zjanaque' beṉe' bzebe ṉa'a, gwžin ža cate' yesaque' beṉe' žialao. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nach Jesúsen' gože' ḻegaque': ―Yeḻa' gwnabia' c̱he Diosen' ben' zoa yaban' zaca'leben ca da' nga goc. To beṉe' nape' to yežlio gan' že'chgua yag uvas. Na' gwze'e ližen' to zil do cheni' gwyeje' gan' chac ya'a jatiljue' beṉe' güen žin cont yesone' žin yežlio c̱hen' žana'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na' gosexenḻaže' beṉe' güen žin ca' to denario c̱hixue' to toe' con ca chac mosen' tža žin. Nach gwseḻe' ḻegaque' gan' jasene' žinṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na' do cheda ga gozeje' gan' chac ya'an, na' ble'ede' nita'ch beṉe' bibi žin de yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na' gože' ḻegaque': “Lencze le'e ḻe šja'ac gan' že' yag uvas c̱hian' ḻe šjen žin na' c̱hixjwcza' le'e ca cheyaḻa'.” Nach ja'ac beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na' da' yoble gwyeje' do guagwbiž na' do cheda šoṉe. Bezle'ede' nita'ch beṉe' bibi žin chesone' nach gwseḻe' ḻegaque' cont yesone' žin gan' že' yag uvas c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na' ca do cheda gayo' šeže'le gozeje' da' yoble ble'eczde' nita'ch beṉe' bibi žin chesone'. Na' gože' ḻegaque': “¿Bixc̱hen' bi gwyejle žin?” ");
INSERT INTO zpqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nach gose'ene': “Notno gwṉe neto' šjento' xšine'.” Nach goze'e ḻegaque': “Lencze le'e ḻe šja'ac ḻe šjen žin gan' že' yag uvas c̱hian'. Na' c̱hixjwcza' le'e ca cheyaḻa'.” Nach ja'ac beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Na' cate' bžin hor bosa' x̱an yag uvasen' beṉe' güen žin ca', nach gože' mos blao c̱hen': “Beyax beṉe' güen žin ca' cont c̱hixjo'ne', solao c̱hixjo' beṉe' ca' besela'ac bzebe, na' yeyožle len beṉe' ca' besela'ac da' nechw.” ");
INSERT INTO zpqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nach mos blaon' zgua'tec gwdixjue' beṉe' ca' gosezolagüe' gosone' žin cheda gayo' šeže'le tgüeje denario to toe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na' cate' gwdixjue' beṉe' ca' gosezolagüe' gosone' žin šezildao', gosacde' c̱hixjoche' ḻegaque' da' zc̱ha'och dan' gosezolagüe' gosone' žin šezildao'. Perw tozcze can' gwdixjue' yogo'ḻoḻte'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na' cate' beyož gosezi' laxjw beṉe' ca' gosezolao žinṉa' šezildao', gosadoe' diža' x̱an žinṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Gose'ene': “Do ža bžaglaochguato' ḻo da' zeye' bento' žin c̱hion'. Na' tozcze can' gwdixjo' neto' len beṉe' ca' besela' bzebe, len to hor güejgan' gosone' žin.” ");
INSERT INTO zpqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Perw na' x̱an žinṉa' gože' toe': “Migw c̱hia', bitwbi da' mal chona' len le'. ¿Gague gwxenḻažo' to denario c̱hixjua' to tole? ");
INSERT INTO zpqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Laxjon' ba gwxi'o, guac yeyejo'. Chaclaža' gwnežjua' beṉe' ca' to denario güeje con can' beṉa' le'e ḻa'czḻa' besela'aque' bzebe. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Bixc̱hen' chxi'o neda' ṉec̱he dan' naca' beṉe' šagüe'? Naquen ḻo na' gona' con ca chaclaža' len da' de c̱hia'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nach Jesúsen' gože' beṉe' ca' bosozenag jemplen': ―Can' naquen, nita' beṉe' zjanaque' beṉe' bzebe ṉa'a, perw ḻecze gwžin ža cate' ḻegaque' yesaque' beṉe' žialao. Na' nita' beṉe' zjanaque' beṉe' žialao ṉa'a, perw gwžin ža yesaque' beṉe' bzebe. Diosen' chaxe' yogo'ḻoḻ beṉe' cont yesejḻe'e c̱he', perw baḻ guen' chosozenague' c̱he', na' ḻegacze' chbeje' cont chesaque' xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesúsen' len yezan beṉe' zja'aque' Jerusalénṉa'. Na' šlac zjangüe'e nezen' gwlejiže' beṉe' šižiṉw ca' gwleje' cont zjanaque' txen len ḻe' na' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ṉa'a ba zejcho Jerusalénṉa' gan' yesone' neda' ḻo na' bx̱oz gwnabia' ca' na' ḻo na' beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisés, na' yesec̱hoglagüen' c̱hia' yesote' neda', neda' naca' ben' gwseḻa' Dios golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na' yesone'nda' ḻo na' beṉe' bi zjanaque' beṉe' Israel cont yesonḻe' c̱hia', na' yesot yeseyine' neda', na' yesote'nda' yosode'e neda' ḻe'e yag cruz, perw yeyoṉ ža yebana' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na' ja'ac xi'iṉ Zebedeo, Jacobo len Juan, na' len xṉa'gaque' lao Jesúsen'. Na' xṉa'gaquen' bzoa xibe' lao Jesúsen' gože'ne': ―Chṉabda' le' to goclen. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nach Jesúsen' gože'ne': ―¿Bi goclen chaclažo' gona'? Nach xṉa'gaquen' gože'ne': ―Chaclaža' gono' cont xi'iṉa' quinga yesebi'e šḻa'a güeje cuito'na' cate' žin ža ṉabi'o. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesúsen' gože' Jacobo na' Juanṉa': ―Le'e cabi ṉezele bi dan' chṉable. ¿Gwc̱hejlaže'le tele yeḻa' zi' yeḻa' ya' ca dan' tia' neda' na' gac c̱hele can' gac c̱hia'? Nach bosyoži'e xtižen' gose'ene': ―Gwc̱hejlaže'to'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nach Jesúsen' gože' ḻegaque': ―Da' ḻicze tele yeḻa' zi' yeḻa' ya' ca dan' tia' neda' na' gac c̱hele can' gac c̱hian', perw bi naquen ḻo na' ṉia' non' cue' cuitan' cate' žin ža ṉabi'a, san yesebe' beṉe' ba mbej X̱a' Diosen' gaquen c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nach cate' yeši beṉe' ca' zjanaque' ḻe' txen gosende' can' gosena beṉe' ca' c̱hope, beseloque' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nach Jesúsen' goxe' yogüe' cont gosebigue' lagüen' na' gože' ḻegaque': ―Ṉezeczele beṉe' gwnabia' c̱he to to nación na' beṉe' blao ca' chesone' byen chosozenag beṉe' c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Perw bi naquen ca' len le'e. San note'tezle chaclaže'le gacle beṉe' blao, cheyaḻa' gwzex̱jwlaže'le gaclen beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na' še note'tezle chaclaže'le gacle beṉe' žialao, cheyaḻa' gon cuinḻe ca xmos beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ca'cze naquen len neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Gague za'a cont yesaclen beṉe' neda' san za'a cont gaclena' beṉe', na' chzanḻaže' cuina' yesote' neda' ṉec̱he xtoḻa' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nach cate' besyeya'aque' ciuda Jericó, beṉe' zan zjasenagüe' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na' c̱hope beṉe' lc̱hoḻ zjachi' chanez gan' zjayda Jesúsen'. Na' cate' gosacbe'ede' Jesúsen' zej gan' zjachi'ena' nach chososya'adie' gose'e ḻe': ―X̱anto', len' naco' xi'iṉ diaža c̱he da' rey Davin'. Beyaše'laže'šca neto'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nach beṉe' ca' chesyede gan' zjachi'ena' gosediḻe' ḻegaque' cont yesenite' šize. Perw na' goseṉe' zižjech gose'ene': ―¡X̱anto', len' naco' xi'iṉ diaža c̱he da' rey Davin', beyaše'laže'šca neto'! ");
INSERT INTO zpqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesúsen' gwleze' gan' nite'na', nach goxe' ḻegaque' gosebigue' lagüen'. Nach gože'ne': ―¿Bin' chaclaže'le gonda' le'e? ");
INSERT INTO zpqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nach gose'ene': ―X̱anto', chaclaže'to' yele'eto'. ");
INSERT INTO zpqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesúsen' beyaše'laže'de' ḻegaque' na' gwdane' yejlaogaquen', nach ḻa' besyele'etede', na' gosa'ogüe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na' cate' ba zoa yesežine' Jerusalénṉa' besežine' gan' chi' yež Betfagé, gan' zoa ya'a dan' nzi' Ya'a Olivos. Na' Jesúsen' gwseḻe' mandadw c̱hope beṉe' ca' zjanaque' ḻe' txen, ");
INSERT INTO zpqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","gožgaque'ne': ―Ḻe šja'ac yež dan' chi' gaḻa'ze, na' cate' žinḻen' na' yeželele to burr be no'ole da'ba' yag na' nc̱he'te to xi'iṉda'oba'. Ḻe sežgacba' na' ḻe c̱he'gacba' nga. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na' še bi ye' beṉe' le'e na' ye'lne': “X̱anto'na' chyažjde' ḻegacba'.” Na' ḻa' yedyesantecze'ba' len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Goc yogo' da' qui cont goc can' bzoj to ben' bzoj Xtiža' Diosen' cani', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gož beṉe' ca' nita' Jerusalénṉa': “Ḻe ṉa'šc, ba za' rey c̱helen', žie' cože' to burr dao', xi'iṉ beyix̱e' be choa' yoa'. Ze'e ca to beṉe' bi naque' beṉe' blao. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na' ja'ac beṉe' ca' yež dao' dan' gož Jesúsen' ḻegaque' ca', na' gosone' can' ben Jesúsen' mandadw. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Na' besyec̱he'e burroa' len xi'iṉba' lao Jesúsen' na' gosex̱oa no xagaque' cože'ban' na' gwžia Jesúsen' be daon' cont gwyeje' Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na' beṉe' zan gosonxene' Jesúsen' goseyix̱jw no xagaque' ḻo nez cont blej burron' ḻen na' yebaḻe' gosec̱hogue' xoze' yag na' goseyix̱juen' ḻo neza'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na' beṉe' zjažialao na' ḻecze beṉe' za'ac cože' bososye'e gosene': ―¡Ḻeca beṉe' zaca' benga nac xi'iṉ diaža c̱he da' rey David! ¡Mbalaz ben' za' nga gwseḻa' X̱ancho Diosen' ḻe' cont ṉabi'e! ¡Ḻeca beṉe' zaca' ben' zoa yaban'! ");
INSERT INTO zpqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na' cate' bžin Jesúsen' Jerusalénṉa' yogo' beṉe' ca' že' ciudan' besyebande', na' gosene': ―¿No benga bla' nga? ");
INSERT INTO zpqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na' beṉe' ca' nžag Jesúsen' bosyoži'e xtiža'gaque' gosene': ―Bengan' Jesús beṉe' za' yež Nazaret gan' mbane distritw Galilea na' cho'e xtiža' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na' Jesúsen' gwyo'e chyo'o yodao' blaon' na' bešaše' yogo' beṉe' ca' chesote' na' beṉe' chesa'o na'. Nach bchix̱e' xmes beṉe' ca' chosoša' mechw, na' yag ga chesebe' beṉe' ca' chesote' ngolbex. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na' gože' ḻegaque': ―Nyojcze Xtiža' Diosen' žan: “Yesene' ližan' naquen to latje gan' yesoḻ güiž beṉe' neda'”, perw le'e chonḻen ca to latje ga že' beṉe' gwban. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na' beṉe' lc̱hoḻ ca' na' len beṉe' ca' nxiṉj ṉi'e gosebigue' lao Jesúsen' šlac zoe' chyo'o yodaon'. Nach beyone' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Perw na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' ḻeca beseže'e cate' besele'ede' yeḻa' guac ca' dan' ben Jesúsen'. Na' ḻecze beseže'e cate' gosende' can' bososya'a bi' bixjw ca' chyo'o yodao' blaon', gosenabe': “Ḻeca beṉe' zaca' benga nac xi'iṉ diaža c̱he da' rey David.” ");
INSERT INTO zpqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nach gose'e Jesúsen': ―¿Zendo' bin' gosena bidao' ca'? Jesúsen' boži'en gože' ḻegaque': ―Zenda'. ¿Biṉa' gwlable can' nyoj Xtiža' Diosen'?, žan: Ba beno' cont bi' bixjw ca' na' len bi' ṉe' chesaže' chesonxembe' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na' bechoje' gan' nita' beṉe' ca' na' beze'e ciudan'. Na' že'na' jayga'aṉe' Betania. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na' zil beteyo besyeya'aque' Betanian' jaseya'aque' Jerusalénṉa' da' yoble. Na' šlac zjangüe'e nezen' gwdon Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na' ble'ede' to yag yix̱güigw zoan cho'a nezen' na' jaṉe'e še žia yaguen' yix̱güigw. Perw bibi bželde', con xḻaguen' na'ze žia. Nach gožen': ―Bich bi yix̱güigon' cuio'. Na' ḻa' gwbižte yaguen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nach beṉe' ca' zjanaque' ḻe' txen besyebande' cate' besele'ede' can' goquen', nach gose'ene': ―¿Nac goquen' ḻa' gwbižte yaguen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na' Jesúsen' gože' ḻegaque': ―Da' ḻi žia' le'e, še chejnilaže'le Diosen' na' bitw gacžejlaže'le, guaque gonḻe can' ba benan' cont gwbiž yaguen'. Na' ḻecze ca' guac ye'le ya'a nga: “Gwcuase nga na' jasoa ḻo' nisdaon'”, na' gac can' ṉalen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na' še chejnilaže'le Diosen', bite'teze dan' ṉabelene' cate' yoḻ güižlene', goṉczen' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nach Jesúsen' gozeje' yodao' blaon' da' yoble. Na' šlac chsed chlo'ede' beṉe' ca' že' na', bx̱oz gwnabia' ca' na' beṉe' gole blao ca' chesenabi'e nación c̱hechon' gosebigue' cuit Jesúsen'. Nach goseṉabde' ḻe': ―¿Bi yeḻa' gwnabia' napo' chono' da' qui? ¿No beṉ yeḻa' gwnabian' cont chono' da' qui? ");
INSERT INTO zpqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nach Jesúsen' boži'e xtiža'gaquen', gwne': ―Ḻecze de to da' ṉabda' le'e. Še yoži'ile xtižan' nach ṉi'a le'e bi yeḻa' gwnabia' chonḻendan'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ḻe našc neda': ¿non' gwseḻa' da' Juanṉa' bzoe' beṉe' nis? ¿Dios nan' gwseḻe'ne', še beṉac̱hen'? Nach ḻegacze' gose' ḻježe': ―Še ye'chone' Dios gwseḻa' ḻe', na' ye'e chio': “¿Bixc̱hen' ca gwyejḻe'le c̱he'?” ");
INSERT INTO zpqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na' bi gac ye'chone' beṉac̱h gwseḻa' ḻe', ḻe yogo'te beṉe' že' nga chesejḻe'e Diosen' gwseḻe' da' Juanṉa' be'e xtiže'na', na' xož bi yesonde' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nach gose'e Jesúsen': ―Bi ṉezeto'. Nach gože' ḻegaque': ―Ḻecze neda' bi yapa' le'e bi yeḻa' gwnabian' chonḻenda' da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na' Jesúsen' gože' ḻegaque': ―Ḻe gon xbab bi zeje jempl nga: Gwzoa to beṉe' gwnita' c̱hope xi'iṉe'. Na' gože' tobe': “Xi'iṉa', chaclaža' šejo' güen žin ṉa'aža gan' že' yag uvas c̱hia' ca'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nach xi'iṉen' gožbe' ḻe': “Bitw ša'a.” Perw gwdele beyombe' xbab nach gwyejbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nach gozeje' gan' zoa xi'iṉen' yeto, na' ježe'be' can' gože' bi' biše'ben'. Na' ḻa' gožte bin' ḻe': “Guaccze, na' ša'a.” Perw bitw gwyejbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gwnašc neda', ¿no bi' ca' c̱hope ben can' gwnalaže' x̱abe'? Nach gose'ene': ―Bi' nechoa'. Nach Jesúsen' gože' ḻegaque': ―Ca'cze naquen. Na' da' ḻi žia' le'e, beṉe' güec̱hixjw ca' na' no'ole ca' chja'aclen note'teze beṉe' byo yobech yosozenague' c̱he Diosen' cont ṉabi'e yic̱hjlažda'ogaque' clel ca le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ca nac Juanṉa' ben' bzoe' beṉe' nis, bide' laolen' na' gwdix̱jue'ede' le'e naquen' cheyaḻa' gonḻe cont yebe Diosen' le'e. Perw bitw gwyejḻe'le c̱he'. Na' beṉe' güec̱hixjw ca' na' no'ole zḻe' ca' gosejḻe'e c̱he'. Na' cate' gocbe'ele beṉe' ca' ba gosejḻe'e c̱he', bitw betiṉjele xtoḻa'le ca' cont šejḻe'le c̱he dan' bsede da' Juanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Ḻe gwzenag yeto jempl nga. Gwzoa to beṉe' na' goze' to cue' xen yag uvas ḻo yežlio c̱he' na' gwlo'en le'ej. Na' na'teze bene' to ga yesesie' uvasen' cont choj x̱isen'. Na' ḻecze bene' to da' sibe ca to campanaryw ga yesecua' beṉe' yosogüia yeseṉe'e yag ca'. ’Na' bcua'aṉe' yežlion' ḻo na' beṉe' yesonši'e yag uvasen' na' gwze'e gwyeje' zito'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cate' bžin ža yosyotobe' cosešen', gwseḻe' to c̱hope xmose' gan' že' beṉe' ca' nac ḻo na'gaque' yag uvasen' cont šjasyexi'e to tlacw cosešen' dan' cheyaḻa' si'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Perw na' beṉe' ca' nac ḻo na'gaque' yag uvasen' gosezene' mos c̱he' ca'. Goseyine' toe', na' yetoe' bosožie'ne' yej, nach yetoe' gosote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nach gosseḻa' x̱an yag uvasen' mos zanch clel ca beṉe' ca' gwseḻe' da' nechw, perw ḻecze can' gosonde' beṉe' nechw ca', ḻecze ca' gosonde' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Nach gwdena' x̱an yežlion' gwseḻe' cuincze xi'iṉen', gocde' yesezi'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Perw na' beṉe' ca' nac ḻo na'gaque' yag uvasen' cate' besele'ede' xi'iṉe'na', nach gose' ḻježe': “Bengan' yega'aṉlene' yežlio nga cate' gat x̱en'. Ḻe šo'o gotchone' cont yega'aṉlenchon.” ");
INSERT INTO zpqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nach gosezene'ne', besyebeje'ne' gan' že' yag ca' na' gosote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Beyož be' Jesúsen' jempl nga, gozne': ―¿Nacxe chaquele gon x̱an yežlion' len beṉe' ca' bocua'aṉlene' yag uvas c̱hen' cate' yežin cuine'? ");
INSERT INTO zpqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nach bosyoži'e xtižen' gosene': ―Šeje' šjetoe' beṉe' mal ca', na' yodie' yežlion' ḻo na' beṉe' yoble beṉe' yeson güen yosyonežjue'ne' to tlacw cosešen' cate' žin ža yosyotoben'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesúsen' gože' ḻegaque': ―Ca'czen'. ¿Biṉa' gwlable ga nyoj Xtiža' Diosen', žan quinga?: Yej dan' bi gosaclaže' beṉe' güen yo'o ca' yosoc̱hine', ḻen ba naquen yej squin. Da' nga ben X̱ancho Diosen', na' naquen to da' yežejecho. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Da'nan' žia' le'e, da' bi chzenagle c̱he Diosen', cuejyic̱hje' le'e na' cueje' beṉe' yoble beṉe' yosozenag c̱he' cont ṉabi'e yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na' ca nac yejen', note'teze beṉe' lažo' ḻo yeja' na' cue'žošje', na' note'teze beṉe' chiže' yeja' cate' lažon' na' gwšošjen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na' bx̱oz gwnabia' ca' na' beṉe' fariseo ca', cate' gosende' jempl ca' dan' be' Jesúsen', gosacbe'ede' be'e diža' c̱he ḻegaque' dan' bi chesejnilaže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nach gosaclaže' yesezene' ḻe', perw besežebe' bi yesone beṉe' ca' nžague' ḻegaque', ḻe yogüe' gosejḻe'e gwseḻa' Diosen' Jesúsen' cont cho'e xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na' da' yoble bsed blo'e Jesúsen' beṉe' ca' len jempl, gozne': ");
INSERT INTO zpqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Yeḻa' gwnabia' c̱he Diosen' zaca'leben ca da' nga goc. Gwzoa to beṉe' gwnabia' na' bene' gastw cate' bšagna' xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na' cate' bžin hor solao ḻṉin' gwseḻe' xmose' ca' cont jasexi'e beṉe' ca' ba boḻ güiže' šja'ac ḻṉina', perw notno goclaže' šja'ac ḻṉi c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nach gože' yeto x̱oṉj xmose' ca': “Ḻe šjež beṉe' ca' ba boḻ güižan' ye'lne' ba bsiṉi'a dan' gagwchona'. Ba betua' be dao' be chesaṉe' na' ba bsiṉi'a dan' gagwcho ḻo ḻṉin'. Na' ye'lne' yeside' gagwcho dan' ba bsiṉi'an'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Perw beṉe' ca' ba gosata'yoede' cont šja'aque', bitw gosone' cuent dan' gose' mos ca' ḻegaque'. Toe' gwyeje' jaṉe'e yežlio c̱he', na' yetoe' gwyeje' jene' negosyw. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na' yebaḻe' goseṉize' mos ca' gwseḻa' beṉe' gwnabian' na' gosonde' ḻegaque' zi' na' gosote' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na' ḻeca bža'a beṉe' gwnabian'. Na' gwseḻe' soldadw c̱he' ca' jasete' beṉe' ca' gosot xmosen' na' bosozeye' lažgaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nach beṉe' gwnabian' gože' xmosen': “Ba bsiṉi'a dan' gagwcho ḻo ḻṉin', perw beṉe' ca' ba boḻ güiža' nacbia' bitw zjazaque' yeside'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ḻe šja'ac ḻe šjata yogo' nez na' ye'le yogo' beṉe' yežagle yeside' ḻṉin'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na' mos ca' ja'aque' yogo' nez na' jasetobe' con yogo' beṉe' besežague', no beṉe' naque' beṉe' güen na' no beṉe' naque' beṉe' mal, cont beža' yo'o gan' chac ḻṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Perw cate' gwyo'o beṉe' gwnabian' jaṉe'e beṉe' ca' že'na' na' ble'ede' to beṉe' bi nyaze' lache' da' bnežjue' yesaze' ḻo ḻṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nach gože' ḻe': “Migw c̱hia', ¿nac goquen' gwyo'o nga bitw nyazo' lache' dan' beṉa' c̱hazo'?” Nach bena' bitw beželde' bi ye'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nach beṉe' gwnabian' bene' mandadw yosoc̱hej xmose' ca' ṉi'a na' bena' cont yesyebeje'ne' na' yesebeque'ne' gan' nac c̱hoḻ, ga cuežyaše' na' gan' gagwxejte ḻaye' tantw žaglagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Can' naquen, Diosen' chaxe' yogo' beṉe' cont yesejḻe'e c̱he', perw baḻ guen' chosozenague' c̱he' na' ḻegacze' chbeje' cont yesaque' xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nach beṉe' fariseo ca' besežague' na' bosoxi'e naclen' yesone' cont yesebeje' Jesúsen' diža' da' yosode'ede' cont yesagüe' xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na' beṉe' fariseo ca' goseseḻe' baḻ beṉe' zjanaque' txen len ḻegaque' na' yebaḻ beṉe' chesone' txen len Herodesen' cont jaseže' Jesúsen': ―Maestrw, ṉezeto' zoatezo' cho'o diža' ḻi. Na' ṉezeto' diža' ḻi cho'o chsed chlo'edo' beṉe' can' chazlaže' Diosen' goncho. Na' bi chono' cuent bi ža beṉe', ḻe toz can' chono' len note'teze beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Da'nan' zedeṉabeto' le' cont ṉao' neto' can' chacdo' cheyaḻa' gonto'. ¿Naquen binḻo no c̱hixjw da' cheyaḻa' c̱hixjwcho lao ben' nac ḻa'zelagüe beṉe' gwnabia' ben' chi' Roma, še bi? ");
INSERT INTO zpqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesúsen' gocbe'ede' yeḻa' xi'a c̱hegaquen', nach gože' ḻegaque': ―¡Nacle beṉe' gwxiye'! ¿Bixc̱hen' chaclaže'le yoslažo'le neda' len xtižan'? ");
INSERT INTO zpqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ḻe gwlo'e neda' to mechw dan' chyixjwle c̱he gobiernen'. Nach goso'ene' to mechw dan' nzi' denario. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nach Jesúsen' gože' ḻegaque': ―¿No lao dan' da' ḻe'e mechw nga? na' ¿no la da' nyoj ḻe'en ni? ");
INSERT INTO zpqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nach gose'ene': ―C̱he César ben' nac ḻa'zelagüe beṉe' gwnabia' ben' chi' ciuda Roman'. Nach Jesúsen' gože' ḻegaque': ―Ḻe gwnežjo beṉe' gwnabian' da' nac c̱he beṉe' gwnabia', na' ḻe gwnežjo Dios da' nac c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nach cate' gosende' xtiža' Jesúsen' besyebande'. Nach besyeya'aque' gan' zoe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na' ḻo ža na'teze besežin baḻ beṉe' saduceo gan' zoa Jesúsen'. Beṉe' ca' chesene' beṉe' guaten' bi yesyebane'. Nach goseṉabde' ḻe', gose'ene': ");
INSERT INTO zpqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestrw, da' Moisésen' gwne': “Še to beṉe' byo nšagne'e na' gate' sin nono xi'iṉe' zoa, beṉe' biše' ben' ba goten' cheyaḻa' yošagna'lene' no'ol güezeba' cont yesenita' xi'iṉ diaža c̱he da' bišen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na' len neto' gosenita' beṉe' gosac gaž biše'. Na' beṉe' nechua' bšagne'e, na' gote' nono xi'iṉe' gwnita'. Na' beṉe' gwchopen' bošagna'lene' no'ol güezeba'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na' ḻecze gote' nono xi'iṉe' gwnita'. Ḻecze ca' goc len beṉe' gwyoṉa', bžinten beṉe' gaža' yogo'ḻoḻe' gosac c̱he' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na' gwde gosat yogo'ḻoḻ beṉe' ca', nach got len no'ola'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na' cate' yesyebane' ladjo beṉe' guat ca', ¿nox beṉe' ca' soalene' no'ola' ca xo'ole'?, ḻe yoguen' bosyošagna'lene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na' gož Jesúsen' ḻegaque': ―Clelen' chonḻe xbab dan' žale ca', ḻe bi ṉezele can' ža Xtiža' Dios dan' nyojen, ṉeca nombia'le yeḻa' guac c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Caten' yesyeban beṉe' guat ca', bich yosošagne'e, ṉeca yosonežjo xi'iṉe' no'ol gwšagne'e, ḻe yesaque' ca angl beṉe' zjazoa yaba. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na' ca nac dan' yesyeban beṉe' guat ca', ¿biṉa' gwlable da' nga can' nyoj Xtiža' Diosen'? žan: ");
INSERT INTO zpqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Neda' naca' Dios ben' chonxen Abraham, ben' chonxen Isaac na' ben' chonxen Jacob”. Beṉe' guat ca' bi chesonxene' Diosen', san beṉe' zjamban. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na' beṉe' ca' zjanžaguen' besyebande' cate' gosende' diža' dan' bsed blo'ede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na' cate' gosene beṉe' fariseo ca' can' bzoaži Jesúsen' beṉe' saduceo ca', nach besedobe' jasa'aque' lagüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na' to ben' nsedchgüe' ley dan' bzoj da' Moisés ḻecze goclaže' cueje' Jesúsen' diža' da' gwc̱hine' contr ḻe', gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestrw, ḻo ley c̱he Diosen', ¿non' nacch da' žialao da' zjanyojen da' ža Diosen' cheyaḻa' goncho? ");
INSERT INTO zpqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nach gož Jesúsen' ḻe': ―“Cheyaḻa' gaquecho X̱ancho Diosen' con ca zelao chejni'icho do yic̱hj do laže'cho.” ");
INSERT INTO zpqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ḻenṉa' naquen da' žialaoch na' da' blaoch lagüe da' ca' ža Diosen' cheyaḻa' goncho. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na' da' gwchopen' zejgaḻan' ca', žan: “Cheyaḻa' gaque ḻježcho ca chaque cuincho.” ");
INSERT INTO zpqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","C̱hope da' ca' ža Diosen' cheyaḻa' goncho chzejni'in chio' can' zeje doxen dan' bzoj da' Moisésen' na' dan' bosozoj beṉe' ca' goso'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na' šlac ṉe' zjanžag beṉe' fariseo ca', ");
INSERT INTO zpqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesúsen' gože' ḻegaque': ―¿Bixe xbab chonḻe c̱he Criston' ben' gwlej Diosen' cont yedeṉabi'e? ¿No xi'iṉ diaža c̱he naque'? Na' gose'ene': ―Xi'iṉ diaža c̱he da' rey Davin'. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nach Jesúsen' gože' ḻegaque': ―Še ca' naquen, ¿bixc̱hen' cate' da' David bzoje' can' blo'e Spiritw c̱he Diosen' ḻe', gwne' Criston' naque' X̱ane'? Quinga bzoje': ");
INSERT INTO zpqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","X̱ancho Dios gože' X̱anan': “Gwche'edo' cuita' nga ṉabia'cho txen, na' gona' cont yogo' no chesegue'e le' yosozex̱jw yic̱hje' yosozenague' c̱hio'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Nacxe gac ṉacho Criston' xi'iṉ diaža c̱he da' rey David? ḻe cuin Davin' gože' ḻe': “X̱ana'”. ");
INSERT INTO zpqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na' notoch no goc yosyoži'e xtižen'. Na' gwzolao žana' notoch no besyeyaxje bi yeseṉabde' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nach Jesúsen' gwzolao be'e diža' len beṉe' ca' zjanaque' ḻe' txen na' len beṉe' ca' zjanžague' gan' zoe'na', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Beṉe' ca' chososed chosolo'e ley na' beṉe' fariseo ca' ba zjanḻane' xḻatje da' Moisésen' cont chosozejni'ide' beṉe' ley c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Na' da'nan' cheyaḻa' gwzenagle c̱hegaque' cate' chosozende' le'e can' ža leyna', na' cheyaḻa' gonḻe can' chosozejni'ide' le'e. Perw bitw gonḻe can' cheson ḻegaque', ḻe ḻegaque' bitw chesone' dan' chesene' cheyaḻa' gac. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ḻegaque' chosozanche' dan' ža leyna'. Chesonen' ca to yoa' da' nono soe gua' na' chesaclaže' gua' beṉe' yoble ḻen na' bitw chesaclaže' yeso'en ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ca nac beṉe' ca', yogo' dan' chesonen', chesonen' ga yesele'e beṉe' can' chesonen' contze yesonxene' ḻegaque'. Chio' beṉe' Israel nc̱hejcho caj dao' de yid do na'cho na' do loxgacho na' ḻo' caj dao'na' chgo'ošagüe'cho to pedas yiš gan' nyoj late' güeje Xtiža' Diosen'. Perw ca nac beṉe' ca' chososed chosolo'e ley c̱he Diosen' na' beṉe' fariseo ca', zjanonche' caj dao' c̱hegaque' da' xench ca yezica'chle beṉe'. Na' ḻecze chesone' lox xagaque' da' toṉech clel ca c̱he beṉe' yezica'chle. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chesyebede' chesebi'e gan' chesebe' beṉe' blao cate' chja'aque' gan' chac no ḻṉi na' cate' chja'aque' yodao' c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chesyebede' chesap beṉe' ḻegaque' bala'aṉ cate' chesyežague' lagüe ya'a. Na' chesyebede' yese' beṉe' ḻegaque' maestrw. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Perw žia' le'e, bi gonḻe byen ye' beṉe' le'e maestrw, ḻe toz neda' Cristo naca' Maestrw c̱hele. Na' yogo' le'e chejnilaže'le neda' nac biše' ḻježle tole yetole. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na' ḻecze bitw gonxenḻe note'teze beṉe' blao ye'lne': “X̱ato'”. Toze Diosen' ben' zoa yaba naque' X̱acho. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na' bitw güe'le latje ye' beṉe' le'e: “X̱ana'”, ḻe toz neda' Cristo naca' X̱anḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Še no le'e nacle beṉe' blaoch, cheyaḻa' gwzex̱jw yic̱hjle gaclen ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ḻe note'teze beṉe' chonxen cuine', Diosen' gone' cont si'e zto' lagüen'. Na' note'teze beṉe' chzex̱jwlaže' lagüen', Diosen' gone' cont gacxene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley dan' bzoj da' Moisésen' na' le'e beṉe' fariseo! Chziye'le beṉe' cont bi yosozenague' c̱he Diosen', ḻe bi chaclaže'le ṉabia' Diosen' yic̱hjlažda'ogaque', na' ḻecze le'e bi chzenagle c̱he Diosen' cont ṉabi'e yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley dan' bzoj da' Moisésen' na' le'e beṉe' fariseo! Chziye'le no no'ole güezebe cont checa'ale yo'o c̱hegaque'. Na' cate' choḻ güižle Diosen', sša choe'le diža' cont yesaque beṉe' ḻeca chonxenḻne'. Gacchle castigw clel ca yezica'chle beṉe' güen da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley dan' bzoj da' Moisésen' na' le'e beṉe' fariseo! ¡Nacle beṉe' gwxiye'! Chejtez chejle chjatiljwle beṉe' zito' beṉe' yeson txen len dan' chsed chlo'elen'. Na' cate' chželelene' chzejni'ilne' cont yesaque' beṉe' xi'ach clel ca le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Nyaše'chguaze gac c̱he le'e! ¡Nacle ca beṉe' lc̱hoḻ beṉe' chesacde' guac yesegüe'e nez beṉe' yoble! Žale note'teze beṉe' še ṉe': “Yodao' blaon' zoan testigw c̱hia' gona' can' ba gwnia'”, bitwbi zejen dan' chnen'. Perw še že': “Oro dan' de ḻo' yodaon' zoan testigw c̱hia' gona' can' ba gwnia'”, nach cheyaḻa' gone' can' gwnen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Le'e nacle ca to beṉe' lc̱hoḻ na' bitw chejni'ile! Oron' bitec bi zacan'. Yodao'na' gan' yo'o oron' ḻenṉa' zaca'chen, ḻe dan' yo'o oron' ḻo'enṉan', da'nan' oron' naquen c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na' ḻecze žale še to beṉe' že': “Mes gan' chosozeye' beyix̱e' ca' chesonxene' Diosen', zoan testigw c̱hia' gona' can' ba gwnia'”, bitwbi zejen xtižen'. Perw na' še že': “Dan' xoa ḻo mes ḻo' yodaon' zoan testigw c̱hia' gona' can' ba gwnia'”, nachen' cheyaḻa' gone' can' gwnen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Le'e nacle ca beṉe' lc̱hoḻ na' bitw chejni'ile! Dan' chosozeye' chesonxene' Diosen' bitec bi zacan'. Mes gan' chesex̱oe' dan' chosonežjue' Diosen', ḻenṉa' zaca'chen, ḻe naquen c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Še beṉe' že': “Mes dan' zoa ḻo' yodaon' zoan testigw c̱hia' gona' can' ba gwnia'”, lencze dan' xoa ḻo mesen' zoan testigw c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na' še beṉe' že': “Yodaon' zoan testigw c̱hia' gona' can' ba gwnia'”, ḻecze zejen Diosen' naque' testigw c̱he', ḻe yodaon' naquen c̱he Dios na' nan' zoe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na' še beṉe' že': “Yaban' zoan testigw c̱hia' gona' can' ba gwnian'”, zejen Diosen' naque' testigw c̱he', ḻe nan' zoa Diosen' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley dan' bzoj da' Moisés na' le'e beṉe' fariseo! ¡Nacle beṉe' gwxiye'! Ḻa'czḻa' chnežjwle Diosen' to part lao ši part c̱he yix̱egüej, c̱he oreg, c̱he comin, na' c̱he bichle cuan c̱hele, bibi zejen dan' bitw chzenagle c̱he da' ca' zjanac da' žialaoch dan' ža leyna'. Leyna' žan cheyaḻa' gonḻe da' nac güen lao Diosen', na' cheyaḻa' yeyaše'laže' ḻjež beṉac̱hle na' cheyaḻa' gonḻe can' ba gwlo'o cho'ale gonḻe. Da' ca' zjanaquen da' zejechen gonḻe, perw ḻecze bitw cheyaḻa' cuejyic̱hjle bi gwnežjwle da' ca' chnežjwle Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Nacle ca to beṉe' lc̱hoḻ beṉe' chesacde' guac yesegüe'e nez beṉe' yoble! Zaca'lebele ca to beṉe' chebej yogo' beb dao' riz da' nc̱hix̱e da' che'eje' perw bitw chacbe'ede' še yo'o to da' xen juisyw da' zaca' yebeje'. Ḻe chi' yic̱hjle c̱he da' ca' bitec bi zaca' da' ža ley c̱hechon' cheyaḻa' goncho, na' bi chonḻe da' ca' zjazaca'chguan. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley dan' bzoj da' Moisés na' le'e beṉe' fariseo! ¡Nacle beṉe' gwxiye'! Zaca'leble ca ye'eṉ dan' chc̱hin beṉe' na' chyibe' cožen' perw bi chyibe' ḻo'en. Chonḻe cont chesaque beṉe' nacle beṉe' güen, perw ḻeca chzelaže'le bi da' de c̱he beṉe' na' chbechgüele chca'alen. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Le'e beṉe' fariseo, nc̱hoḻ yic̱hjlažda'olen'! Ḻe yetiṉje xtoḻa'le cont da' ḻicze gacle beṉe' güen can' chaclaže'le yeson beṉe' xbab nacle. Nach gacle ca to ye'eṉ dan' nyibe' cožen' na' ḻo'en. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley dan' bzoj da' Moisés na' le'e beṉe' fariseo! ¡Nacle beṉe' gwxiye'! Zaca'leble ca to ba dan' zjanone' xdanchgua lagüen perw ḻo'en že' žit c̱he beṉe' guat na' chi'chgua da' zban. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chonḻe cont chesaque beṉe' nacle beṉe' güen, perw len yic̱hjlažda'olen' nacle beṉe' gwxiye' na' beṉe' malchgua. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele ley da' bzoj da' Moisés na' le'e beṉe' fariseo! ¡Nacle beṉe' gwxiye'! Chonšagüe'le cho'a ba c̱he da' beṉe' goso'e xtiža' Diosen' cani', na' chonšagüe'le cho'a ba c̱he yezica'chle beṉe' goson da' güen. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na' žale: “Šaca' chio' ba zoacho ca tiemp c̱he da' x̱ozxta'ocho ca', bitw bencho txen len ḻegaque' cate' gosote' beṉe' ca' goso'e xtiža' Diosen' cani'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Perw na' yogo'ḻoḻte dan' chonḻe chlo'en tozcze can' nacle len da' x̱ozxta'ole ca' beṉe' gosot da' beṉe' ca' goso'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ḻe gwza'laošaze ḻe gon bica'ch da' zgot dan' bitw goḻa' yeson da' x̱ozxta'ole ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Le'e nacchguale beṉe' zgot na' beṉe' gwxiye'. Bitw gac yelale lao castigw dan' goṉ Diosen' le'e, ḻe seḻe' le'e ḻo yi' gabiḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na' da' gona', neda' seḻa' no beṉe' yeso'e xtiža'na' len le'e na' no beṉe' sina' na' nochle beṉe' yososedde' le'e xtižan'. Na' gotle baḻe' gwda'gaclene' to ḻe'e yag cruz, na' yebaḻe' c̱hinḻe do ḻo' yodao' c̱helen', na' yebaḻe' gwlaglene' gate'teze yež šja'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na' dan' gonḻe ca' gaple doḻa' c̱he yeḻa' got c̱he yogo' beṉe' ca' goson da' güen, ben' gosot da' x̱ozxta'ole ca' gwzolaozen len da' Abel ben' naque' beṉe' güen lao Diosen' na' beyožen len da' Zacarías xi'iṉ da' Berequías. Zacaríasen' gosote'ne' do gan' zoa yodao' blaon' na' do gan' ze mes gan' chosozeye' beyix̱e' chesonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na' da' ḻi žia' le'e, le'e mbanḻe ṉa'a si'le castigw c̱he yeḻa' got c̱he yogo' beṉe' ca' gosot da' x̱ozxta'ole ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Le'e beṉe' Jerusalén, chotle beṉe' ca' chseḻa' Diosen' cont chesoe'lene' le'e xtižen' chc̱heḻlene' yej. Zan ṉi'a ba goclaža' yotoba' le'e ca to jed xcaca' ben' nc̱he' xi'iṉ na' chyežba' ḻegacba', perw bitw goclaže'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na' ṉa'a ba gwlejyic̱hj Diosen' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na' žia' le'e, bich le'ele neda' ṉa'a, perw cate'ch žin ža le'ele neda' yeto nach ṉale: “Mbalaz ben' za' nga nseḻa' X̱ancho Diosen' ḻe' ṉabi'e”. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na' ba cheza' Jesúsen' yodao' blaon' šeje' ga yoble cate' beṉe' ca' zjanaque' ḻe' txen gosebigue' gan' zoe'na' na' gosezolagüe' goso'e diža' catec xdan nac yodaon' na' ḻecze ca' yo'o ca' zjanyec̱hjen. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nach Jesúsen' boži'e xtiža'gaque' gwne': ―Ca nac yogo' da' quinga chle'ele, da' ḻi žia' le'e, ṉe to yej da' zjancua' nga ca yega'aṉ zjancua' cože' ḻježen. Yogon' yosyoc̱hiṉje'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na' ja'aque' Ya'a Olivos. Na' cate' Jesúsen' ba chi'e ḻo ya'an, beṉe' ca' zjanaque' ḻe' txen gosebigue' lagüen' gose'ene' šižize: ―Che'neto' ṉao' neto' batcan' gac da' ca'. Na' ¿nac gac ṉezeto' cate' ba zoa bagwze yido' na' ba zoa yeyož yežlion'? ");
INSERT INTO zpqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nach Jesúsen' boži'e xtiža'gaquen' gwne': ―Ḻe gwsaca' cont notno siye' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ḻe zan beṉe' yesaš yežlio nga beṉe' yesaclaže' yosoḻane' xḻatja' nga. Na' yesene': “Nedan' Cristo ben' gwlej Diosen' cont ṉabi'e.” Na' yeseziye'e beṉe' zan. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na' yenele chac gwdiḻe nile nale, na' yenele guac gwdiḻe, perw bi žeble, ḻe can' cheyaḻa' gac. Perw gague ḻenṉa' ṉacho ba bžin ža yeyož yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ḻe yesediḻ to yež len yeto yež yoble na' to nación len yeto nación yoble. Na' cue' yižgüe', na' gata' gwbin na' zan cuen ga x̱o'chgua ḻo yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Perw na' yogo' da' qui gac cate' za' solao gata' yeḻa' zi'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Nach beṉe' ca' že' yogo' nación yesegue'ede' le'e dan' chejnilaže'le neda' na' yesone' le'e ḻo na' beṉe' ca' chesegue'e le'e na' yososaca'zi'e le'e nach yesote' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cana' beṉe' zan beṉe' ba chesejnilaže' neda' yesebejyic̱hje' bich yesejnilaže' neda'. Na' ḻegacteze' yesec̱hje' yeson ḻježgaque' ḻo na' beṉe' da' chesegue'ede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na' beṉe' zan yesonḻaže' yesene' xtiža' Diosen' cheseyix̱jue'ede' na' yeseziye'e beṉe' zan. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na' lagüe dan' šanch beṉe' ca' yeson da' malen', beṉe' zan juisyw beṉe' ba chesejnilaže' neda' bich yesacde' ḻježe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Perw na' note'tezle gwyo gwc̱hejlaže'le cont bi cuejyic̱hjle dan' chejnilaže'le neda' žinten gatle, nach šjayzoale len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na' šja'ac beṉe' doxen ḻo yežlion' yeseyix̱jue'ede' diža' güen cont yeseṉeze beṉac̱hen' cheyaḻa' yosozenague' c̱he Diosen' nach ṉabi'e yic̱hjlažda'ogaque'. Na' cate' beṉe' že' yogo' nación ba zjaṉezde' da'na', cana'ch yeyož yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","’Da' Daniel ben' gwdix̱jue'ede' xtiža' Dios cani' bzoje' c̱he da' zbanchgua da' gwx̱iṉjen latje gan' chonxencho Diosen'. Na' cate' le'e le'ele ba zoa dan' gan' zoa yodao' blao, cana' beṉe' yesenita' distritw Judea cheyaḻa' yosoxoṉje' šja'aque' do ya'adao'. (Beṉe' gwlaben' cheyaḻa' šejni'iden'.) ");
INSERT INTO zpqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na' beṉe' chda do yic̱hjo'o c̱he ližen', bi yeyetje' yotobe' xšinḻaze' že' ližen', con yoxoṉje'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na' beṉe' chda yix̱e' bi yeyej liže' šjayxi'e xaḻane'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Nyaše'chguaze zjanac no'ol ca' zjanoa' xi'iṉ na' no'ol ca' ṉe' chosoguaže' bidao' ḻo ža ca'! ");
INSERT INTO zpqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Na' ḻe ṉab lao Dios bi yažjen gwxoṉjle cate' chac zag o ḻo ža c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ḻe yesaquen ža da' ḻeca yesaḻe' beṉe'. Cate' gwxete yežlion' na' ža ṉa'aža nono ṉa' gaḻe' ca', ṉeca žinḻažen' yesaḻe'de' ca' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na' šaca' X̱ancho Diosen' bi yozaše' žan' yesac ca', notno yela, perw yozašen' ṉec̱he chacde' beṉe' ca' chesejnilaže' ḻe', beṉe' ba gwleje' zjanaque' xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Cana' še no ye' le'e: “Ḻe ṉa'šc, nga zoa Criston' ben' gwlej Diosen' cont ṉabi'e”, o “Ḻe ṉa'šc, na' zoe'”, ṉe ca'cze bi šejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yesaš beṉe' gwxiye' beṉe' yesaclaže' yosoḻane' xḻatja' nga, na' yeson cuine' ca beṉe' chesoe' xtiža' Dios. Na' yesone' yeḻa' guac da' yesele'e beṉe' na' bichle da' zaca' yesyebande' cont yeseziye'e ḻegaque'. Na' len beṉe' ca' ba gwlej Diosen' zjanaque' xi'iṉe' yesaclaže' beṉe' gwxiye' ca' yeseziye'e šaca' gac yeseziye'e ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ba ṉezele can' gac, ḻe ba gwdix̱jue'eda' le'e yogo' can' gac. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Na' še yese'e le'e: “Zoa Criston' latje dašen'”, bitw gwzenagle c̱hegaque', bitw šejle. Na' še yese'e le'e: “Zoa Criston' ḻo' yo'ona'”, bitw šejḻe'le c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Can' chac cate' chep yes chseṉin' doxen ḻe'e yaban' zejzenez, ḻecze can' gac cate' žin ža yida' da' yoble, Diosen' gwseḻe' neda' golja' beṉac̱h. Yida' zejzenez na' yogo'ḻoḻ beṉe' yesele'ede' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nga chonen c̱he ben' že': “Gan' de be guat nan' chesežag šod ca'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Na' cate' ḻa' yeyožte saca'zi' beṉac̱hen', gwbižen' yeyaquen c̱hoḻ, na' bion' bich gwseṉin'. Nach beljw ca' yeselažon' ḻe'e yaban', na' yogo' da' chle'echo ḻe'e yaban' yesaquen ca chac yežlion' cate' chxo'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na' cana'ch beṉe' že' yežlion' yesele'ede' neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h za'a ladjo bejon' len yeḻa' guac xen na' yeḻa' beṉe' zaca' juisyw c̱hia'. Na' beṉe' že' yogo' nación c̱he yežlion' yesebežyaše', beṉe' bi gosejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na' caten' yida', to trompeta' cuežen zižje, na' seḻa' angl c̱hia' ca' doxen yežlion' yosyotobe' beṉe' ca' ba gwleja' cont zjanaque' neda' txen gate'teze nite' doxen ḻo yežlio ga zelao nac zito'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ḻe gwzenag c̱he jempl nga c̱he yag yix̱güigw: Cate' ba chzolao chebešjw yaguen' na' chelan' ḻaga' che'eṉ dao', chacbe'ele bac̱h zoa yela' tiemp yejon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na' ḻecze cate' le'ele ba chac da' mal ca' ba gwnian', cana'ch ṉezele ba za' juisyw, ba zoa gaḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Da' ḻi žia' le'e, biṉa' yenit diaža c̱he le'e nita'le ṉa'a cate' ba goc yogo'ḻoḻ da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ḻe'e yaba na' yežlion' yesede c̱hen, perw ca nac xtižan', gague da' te cbi gac can' žanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Perw nono ṉeze bi ža bi horen' gac ca', ṉe angl ca' nita' yaba, ṉeca neda' naca' Xi'iṉ Diosen' bi ṉezda'. Toz X̱a' Dios ṉeze. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Diosen' gwseḻe' neda' golja' beṉac̱h, na' can' goc tiemp c̱he da' Noé, ḻecze can' gac caten' neda' yida' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Beṉe' ca' gosenita' tiemp c̱he da' Noén' gosenite' chese'ej chesagüe' na' chosošagne'e na' chosošague' na' no xi'iṉgaque'. Ṉe' chesonte' ca' caten' bžin ža gwyo'o Noén' ḻo' barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bitw gosacbe'ede' bin' gac. Cate'ch goc yejw sio' juisyw na' bia' nisen' yogo'ḻoḻe' cana'ch gosacbe'ede'. Ḻecz can' gac, con cate'ch yida' da' yoble cana'chen' yesacbe'e beṉe' bin' gac. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Quingan' gac caten' yida' da' yoble: C̱hope beṉe' nite' do yix̱e', toe' yezi' yeca'a, na' yetoe' yocua'aṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na' c̱hope no'ole ṉite' chesote', toe' yezi' yeca'a na' yetoe' yocua'aṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Da'nan' ḻe soa ḻe cueze, ḻe bi ṉezele bi ža bi horen' yida' da' yoble, neda' naca' X̱anḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ḻe gon xbab c̱he da' nga, šaca' ṉeze x̱an yo'on' do bi hor ḻo yelen' žin beṉe' gwbanṉa' ližen', ṉa'ze' cont bitw güe'e latje šo' ben' ližen' cuane' xšinḻazen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Da'nan' ḻe soa ḻe cueze batcan' yida' da' yoble, ḻe cate' bi chonḻe xbab yida', cana' yida', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Note'tezle še zoale lez bate'teze, zaca'leble ca to mos beṉe' naque' beṉe' sina' na' beṉe' chon da' cheyaḻa' gone'. Na' še to beṉe' mos chonchgüe' güen, nach x̱anen' cue'e ḻo ne'e ližen' cate' se'e cont mosen' gwnežjue' da' yesagw yogo' mos ca' cate' ba goḻe' yesagüe' tža tža. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Še to beṉe' mosen' chonteze' can' gož x̱anen' ḻe', mbalaz soe' cate' yežin x̱anen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da' ḻi žia le'e, x̱anen' cue' ḻo na' mosen' yogo'ḻoḻ da' de c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Perw še mosen' naque' beṉe' zgot na' gone' xbab ṉe': “Ba gwže x̱anan'”. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nach solagüe' tiḻe' mos ca' yezica'chle na' ye'ej gagwx̱ate' len no beṉe' borrašw, ");
INSERT INTO zpqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nach x̱ane'na' yežine' to ža senyale' ḻe' to hor bi nacbe'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na' dan' bi chon mosen' ca cheyaḻa' gone', x̱ane'na' c̱hinchgüe' ḻe' ca gatte'. Gac c̱he' can' chac c̱he note'teze beṉe' gwxiye', chjaya'aque' gabiḻen' gan' chesebežyaše' na' chesagwxejte ḻaye' dan' ḻeca chesežaglagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nach Jesúsen' goze'e beṉe' ca' zjanaque' ḻe' txen: ―Cheyaḻa' soale lez batcan' yedeṉabi'a, can' gwnita' no'ole chesejni'i no'ol ca' za' gua'a diža' c̱hen'. Goc to yeḻa' güešagna', na' nita' ši no'ol güego' zjanaque' migw c̱he beṉe' ca' chosošagnan'. Na' zjanxobe' lintern c̱hegaque' ja'aque' jaseleze' yesyechoj beṉe' ca' liž no'olen' par šja'aque' liž beṉe' byon' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na' gayo' no'ol ca' gosaque' beṉe' chejni'i na' yegayoe' bibi xbab gosone'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Cate' no'ol ca' bibi xbab goson gosa'ac liže', zjanxobe' lintern c̱hegaquen', perw bitw gosox̱e' botey gan' yože set dan' yosoc̱hine' cate' yebiž dan' yože ḻo' lintern c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na' no'ol ca' chesejni'i, zjanxobe' lintern c̱hegaque' lente botey seten' dan' yosoc̱hine' cate' yebiž dan' yože ḻo' lintern c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na' beṉe' güešagna' ca' gosežede' na' no'ole ca' gosebeze' ḻegaque' gosetase' šlac chesebeze'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na' do chel, to beṉe' gwṉe' zižje, gože' ḻegaque': “Ba chesyechoj beṉe' güešagnan'. Ḻe šo'o šjašagchone'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na' cate' gože' ḻegaque' ca', yogo' no'ol ca' gosezeche' na' gosec̱hogue' mešw dan' gwyey c̱he linterna' na' bosyoguaḻen' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na' no'ol ca' bibi xbab cheson gose'e no'ol ca' yegayo': “¿Bi gonḻe late' dan' yože botey c̱helen' neto'? ḻe ba chebiž c̱heton'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nach no'ol ca' gose'e ḻegaque': “Bitw gac goṉto' late' c̱hele, ḻe dan' de c̱heton' bitw gaquen par yogo'cho. San ḻe šja'ac ḻe šjax̱i' c̱helen' ga choten'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nach no'ol ca' bi goson xbab ja'aque' jasex̱i'e seta'. Na' šlac zja'aque' besyežin beṉe' ca' chosošagna' liž beṉe' byon'. Na' no'ol ca' gosaque' beṉe' chejni'i, goso'e txen len beṉe' ca' chosošagnan' ḻo' yo'o gan' chesone' ḻṉin'. Nach mos ca' bososeyjue' puerten'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na' cate' besyežin no'ol ca' bi goson xbab, goseṉe' cho'a puerten', gose'e ben' zoa ḻo' yo'on: “Beṉe', gwsaljwšca puerta' cont šo'to'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Perw na' gože' ḻegaque': “Da' ḻi žia' le'e, bitw saljua' šo'le ḻe bitw nombi'a le'e.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nach gož Jesúsen' beṉe' ca' zjanaque' ḻe' txen: ―Ca'czen' cheyaḻa' soale lez batcan' yedeṉabi'a, ḻe bitw ṉezele bi ža bi hor yida' yežlio nga da' yoble, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Na' dan' yida' yežlio nga da' yoble yedeṉabi'a zaca'leben ca da' nga goc. To beṉe' gwyeje' nación zito'. Na' za' se'e goxe' mos c̱he' ca' na' gwlo'e ḻo na'gaque' xmechue' cont gosone' delgens. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Toe' bocua'aṉlene' gayo' mil. Na' yetoe' bocua'aṉlene' c̱hop mil. Na' yetoe' bocua'aṉlene' to mil. Bnežjuen' ḻegaque' con ca ble'ede' da' chac yeson to toe'. Beyož bene' ca' na' gwze'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na' ben' bocua'aṉlene' gayo' mil ḻa' gwzolaote chone' delgens len mechon' na' bene' gan ḻecze gayo' mil. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ḻecze ca' ben ben' bocua'aṉlene' c̱hope mil, na' bene' gan yec̱hope mil. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na' ben' bnežjue' to mil gwyeje' jacuaše' xmechw x̱anen' to ḻo' yechw da' gwc̱he'eṉe' ḻo' yo. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Goc šsa gwza' x̱an mos ca' cate' bežine', nach bene' mandadw ja'ac xmose' ca' lagüen' cont bosyodie' cuent. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mosen' ben' bocua'aṉlene' gayo' mil bžine' lagüen' na' gože'ne': “X̱ana', ni de da' gayo' mil dan' beṉo' neda'. Na' ba bena' gan yegayo' mil.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na' x̱ane'na' gože'ne': “Ba beno' da' güen. Naco' mos güen na' ba beno' ca cheyaḻa' gono'. Na' dan' beno' can' cheyaḻa' gonon' len da' daon' bocua'aṉlena' len', da'nan' gona' ḻo nao' da' xench. Gwyo'o cont so' mbalaz len neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nach cate' bžin ben' bocua'aṉlene' c̱hope mil, bena' gože'ne': “X̱ana', ni de da' c̱hope mil dan' bocua'aṉleno' neda', na' ba bena' gan yec̱hope mil.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nach gož x̱anen' ḻe': “Ba beno' da' güen. Naco' mos güen na' ba beno' ca cheyaḻa' gono'. Na' dan' beno' can' cheyaḻa' gonon' len da' daon' bocua'aṉlena' le', da'nan' gona' ḻo nao' da' xench. Gwyo'o cont so' mbalaz len neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nach cate' bezžin ben' bocua'aṉlene' to mil, nach gože' x̱ane'na': “Nga de xmecho' dan' bocua'aṉleno' neda'. Ṉezda' naco' to beṉe' znia. Chelapo' da' gosaz beṉe' yoble, na' chotobo' coseš ga goson beṉe' yoble žin. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Da'nan' gwya'a jac̱he'ena' to yechw na' bcuaša' xmechon', ḻe bžeba' še gwṉitan'. Na' ṉa'a bezi'šcan'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nach x̱anen' gože' ḻe': “¡Naco' mos mal, na' naco' xagüed! Ṉezdo' chelapa' ga gosaz beṉe' yoble, na' chotoba' coseš ga goson beṉe' yoble žin. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na' lagüe da' ṉezdo' chona' ca' ¿bixc̱hen' bi gwlejo' xmechuan' beṉe' yoble cont yezi'an len yic̱hjen ṉa'a ba bela'a?” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nach gože' xmose' ca' yezica'chle: “Yeca'ale mechon' dan' bocua'aṉlena' benga na' gwnežjwlen ben' ba nox̱e' ši mil. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Can' naquen, note'teze beṉe' chon güen len dan' chnežjo x̱anen' ḻe', x̱anen' gwnežjochcze' c̱he', cont gata' da' zc̱ha'och c̱he'. Perw na' note'teze beṉe' bi chgone' žin dan' chnežjo x̱anen' ḻe', yeca'a x̱anen' da' daon' nox̱e'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na' ca nac mos xagüed nga, ḻe yebeje' ḻe c̱he'ex̱ox̱je' gan' nac c̱hoḻ na' cuežyaše' na' gagwxejte ḻaye' dan' ḻeca žaglagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Diosen' gwseḻe' neda' golja' beṉac̱h, na' cate' yida' da' yoble nsa'a yeḻa' zaca' juisyw c̱hia' na' nc̱hi'a yogo' angl c̱hia' ca', cana'ch cui'a ṉabi'a güen juisyw can' chnabia' Dios ben' zoa yaba. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na' yapa' yogo' beṉe' c̱he yogo' nación ca' yeside' laguan'. Na' cate' ba nita' yogüe' na' ḻa'ane' can' chon to beṉe' güeye xila' cate' chebeje' partle xila' ca' na' partle šib ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na' beṉe' ca' zjanac beṉe' güen lao Diosen' dan' ba gosejnilaže' neda', gwnita' ḻegaque' cuitan' šḻa'a ḻicha. Perw beṉe' mal ca', gwnita' ḻegaque' cuitan' šḻa'a robes. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na' neda' naca' rey yapa' beṉe' ca' nita' šḻa'a ḻichan': “Ba ben X̱a' Diosen' cont le'e soale mbalaz. Ḻe da nga cont gona' ṉabia'le txen len neda' can' ba nžia bia' Diosen' cate' gwxete yežlio. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gona' cont ṉabia'cho txen, ḻe cate' gwdona' le'e beṉle dan' gwdagua'. Na' cate' gwbiḻda' nis, le'e beṉle da' güe'eja'. Na' cate' goca' ca beṉe' zito' le'e bleble neda' ližlen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na' cate' bi gota' da' c̱haza', le'e beṉle da' gwyaza'. Na' cate' gocšenda', le'e bedetiple laža'. Na' cate' gota' ḻižya, le'e bedeṉa'le neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na' beṉe' güen ca' yese'e neda': “X̱anto', ¿baten' ble'eto' le' gwdono' na' beṉto' da' gwdago'? Na' ¿baten' gwbiḻdo' na' beṉto' da' güe'ejo'? ");
INSERT INTO zpqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na' ¿baten' goco' ca beṉe' zito' na' blebto' le'? Na' ¿baten' ble'eto' le' bi de da' c̱hazo' na' beṉto' da' gwyazo'? ");
INSERT INTO zpqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na' ¿baten' gocšendo' o goto' ḻižya na' bedeṉa'to' le'?” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na' neda' naca' rey yape'gaca'ne': “Da' ḻi žia' le'e, beṉe' ca' chesejnilaže' neda' zjanaque' ca biša' na' ca zana'. Na' yogo' ṉi'a cate' beyaše'laže'le ḻegaque', ḻa'czḻa' bitec bi zjazaque' len beṉac̱hen', lencze nedan' beyaše'laže'le.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Nach beṉe' ca' nita' šḻa'a robesle, beṉe' mal ca', yape'gaca'ne': “Ḻe cuas ca'ale. Ba žia bia' c̱hele cuiayi'le yeḻa' güen da' mal c̱helen'. Ḻe šja'ac ḻo yi' gabiḻ dan' bi cheyol, yi' dan' bxen Diosen' cont saca'zi' Satanás toḻi tocaṉe len da' x̱igüe' ca' cheson xšinen. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ḻe šja'ac ḻo yi' gabiḻen', ḻe cate' gwdona' bitw beṉle dan' gagua'. Cate' gwbiḻda' bitw beṉle da' ye'eja'. ");
INSERT INTO zpqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cate' goca' ca beṉe' zito' bitw bleble neda' ližle. Cate' bi gota' da' c̱haza' bitw beṉle da' c̱haza'. Cate' gocšenda' na' cate' gota' ḻižya, bitw bedeṉa'le neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nach ḻegaque' ḻecze yosyoži'e xtižan' yesene': “X̱anto', ¿baten' bi beyaše'to' le' cate' gwdono' o gwbiḻdo', o goco' beṉe' zito', o bi gota' da' c̱hazo', o gocšendo', o goto' ḻižyan'?” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na' yeyož yese'e neda' ca' nach yape'gaca'ne': “Lagüe' dan' bi beyaše'laže'le beṉe' ca' chesejnilaže' neda', ḻa'cze bibi zjazaque' len beṉac̱hen', da'nan' lencze nedan' bi beyaše'laže'le.” ");
INSERT INTO zpqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nach beṉe' mal ca' yesezaca'zi'e toḻi tocaṉe. Perw beṉe' ca' chesone' güen lao Diosen' yesezoe' mbalaz toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cate' beyož be' Jesúsen' diža' ca', gože' beṉe' ca' gwleje' cont zjanaque' txen len ḻe': ");
INSERT INTO zpqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ba ṉezele yec̱hope žazen' gaḻa' ḻṉi pascw c̱hechon'. Na' cana' gaca' ḻo na' beṉe' ca' chesegue'ede' neda' na' yesote' neda' yosode'e neda' to ḻe'e yag cruz, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nach bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' na' beṉe' gole blao ca' chesenabi'e nación Israel c̱hechon' besedobe' chyo'o liž bx̱oz blao ben' le Caifás. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na' cheseyiljwlaže' naclen' yesone' yeseziye'e Jesúsen' cont yesezene'ne' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na' gosene': ―Bi senchone' ḻo ḻṉin' cont ca yesebec beṉe' žaš. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nach goquen' Jesúsen' len beṉe' ca' gwleje' cont zjanaque' txen len ḻe' nite' Betania liž Simón ben' güe'e yižgüe' da' nzi' lepra. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na' šlac chi' Jesúsen' cho'a mesen', bžin to no'ole nox̱e' to de yejese ga chož set da' chḻa' zix̱ da' ḻeca chzaca' la'ay. Na' no'olen' bzoac̱hoc̱hje' seten' yic̱hj Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na' beṉe' ca' zjanaque' txen len Jesúsen' cate' besele'ede' can' ben no'olen' beseže'e na' gosene': ―¿Bixc̱hen' con benditjde' set zix̱ nga? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ša no bete' ḻen, yesoṉen mechw xen na' yosonežjuen' gaclenen beṉe' yaše'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesúsen' gocbe'ede' bin' gosene' nach gože' ḻegaque': ―¿Bixc̱hen' chṉele c̱he no'olen'? Dan' bene' len neda' nga naquen güen. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ḻe beṉe' yaše' ca' bate'teze nita'cze' len le'e, san nedan' bich soa' yesša len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dan' bguazje'nda' set zix̱en' bene' dan' cheyaḻa' yesone' len neda' cate' gaša'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Da' ḻi žia' le'e, doxen yežlio gate'teze šjasedix̱jue'e beṉe' diža' güen dan' chzejni'in c̱hia', decze de yesene' can' ben no'ol nga, cont šjasyeze'ede'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Gwde da' quinga, Judas Iscariote ben' goque' txen len beṉe' šižiṉw ca' ben' gwlej Jesúsen' cont zjanaque' txen len ḻe', gwyeje' jaṉe'e bx̱oz gwnabia' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na' ježe' ḻegaque': ―¿Gaca'te' goṉle neda' cont gwdia' Jesúsen' ḻo na'le? Nach bosoxi'a beṉe' ca' yosonežjue'ne' šichoa mechw plata na' bosonežjue'nen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nach cana' Judasen' gwzolagüe' gwdiljwlaže' nac gone' gwdie' Jesúsen' ḻo na'gaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na' bžin ža chaḻa' ḻṉi caten' chesagüe' yetextil dan' bibi levadura yo'o, na' ža nechw c̱he ḻṉin' beṉe' ca' zjanaque' Jesúsen' txen ja'aque' gan' zoe' na' gose'ene': ―¿Gan' che'ndo' šjasiṉi'ato' cont gagwcho xše' c̱he pascon'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nach Jesúsen' gože' ḻegaque': ―Le'e šja'ac ciudan' gan' zoa to beṉe' byo ben' nombia'cho na' ye'lne': “Maestron' že' ba zoa žin ža gac da' cheyaḻa' gac c̱he', na' ližo' nga che'nde' gagwlento'ne' xše' ḻṉi pascon'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nach beṉe' ca' gosone' can' gož Jesúsen' ḻegaque', jasesiṉi'e xše' že' ḻṉina'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na' cate' beyož gwxoa gwbiž, Jesúsen' len beṉe' šižiṉw ca' gwleje' cont zjanaque' ḻe' txen gosebi'e cho'a mesen' gosagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na' šlac chesagüen' gož Jesúsen' ḻegaque': ―Da' ḻi žia' le'e, to le'e gwdele neda' ḻo na' beṉe' ca' chesegue'e neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nach ḻegaque' besyeyaše'laže'de', nach gosezolagüe' tgüeje tgüeje' goseṉabde' ḻe' gose'ene': ―X̱ana', ¿nedan' gona' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nach gože' ḻegaque': ―To ben' chagw len neda' txen toz ḻo' ye'eṉ, ḻe' gwdie' neda' ḻo na' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na' gac c̱hia' can' nyoj ḻe'e Xtiža' Diosen', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h, perw nyaše'chguaze nac ben' gwdie' neda' ḻo na' beṉe' ca'. Yejṉi'acle ša bi golje'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nach Judasen' ben' za' gwdie' Jesúsen' ḻo na' beṉe' ca' gože'ne': ―Maestrw, ¿nedan' gwdia' le' ḻo na' beṉe' ca'? Jesúsen' gože'ne': ―Ḻe len'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na' šlac chesagüen', Jesúsen' gwxi'e to yetextilen' na' beyož be'e yeḻa' chox̱clen c̱he Dios, bzoxjen' na' bnežjuen' beṉe' ca' zjanaque' ḻe' txen, gože' ḻegaque': ―Ḻe gagon'. Ḻenṉa' cuerp c̱hian'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nach bex̱ue' to vas gan' yože nis uvasen', na' beyož be'e yeḻa' chox̱clen c̱he Dios boznežjuen' ḻegaque', goze'ene': ―Yogo'le, ḻe ye'ej late' güeje dan' yože ḻo' vas nga. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Da' nga xc̱hena' na' chzanḻažan' ḻaljen ṉec̱he xtoḻa' yogo'ḻoḻ beṉac̱h. Na' ḻaljen cont solao gac da' cob dan' gwna Diosen' gone' gaclene' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chnia' le'e, bich ye'eja' nis uvas ṉa'a. Cate'ch žin ža ba zoacho txen gan' zoa X̱a' Diosen' chnabi'e, cana' ye'ejan' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na' beyož gosonxene' Diosen' len to da' gosoḻe', nach gosa'aque' ja'aque' Ya'a Olivos. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na' šlac zjangüe'e nezen' Jesúsen' gože' ḻegaque': ―Ṉa'aže' yogo'le cuejyic̱hjle neda' ṉec̱he dan' gac c̱hian'. Ḻe nyojczen ḻe'e Xtiža' Diosen' žan: “Gota' beṉe' güeye' xilan' na' xila' ca' yesaslasba'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Perw na' cate' yosban Diosen' neda' ladjo beṉe' guat ca', yobch yeya'a Galilea ca le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nach Pedroa' gože' Jesúsen': ―Ḻa' yogo' beṉe' quinga yesebejyic̱hje' le', neda' gwbat gona' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesúsen' gože' ḻe': ―Da' ḻi žia' le', biṉa' cuež jean' ṉa'aže' cate' gac šoṉ ṉi'a bi chc̱hebo' še nombi'o neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nach Pedroa' gwne': ―Ḻa'czḻa' še chonen byen guatlencza' le', gwbat ṉia' bi nombi'a le'. Na' ḻecze ca' yogo' beṉe' šižiṉw ca' zjanaque' Jesúsen' txen gosene' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nach besežine' latje gan' nzi' Getsemaní, na' Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ngaze ḻe cue' šlac ša'a na'le šjaḻ güiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na' gwc̱he'e Pedroa' len c̱hop xi'iṉ Zebedeo, Jacobon' len Juanṉa'. Na' Jesúsen' gwzolao gocyaše'chgüede', na' benchgüe' xbab. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nach gože' ḻegaque': ―Ḻo' yic̱hjlažda'oguan' chacyaše'chgüeda', chacda' con gatcza' catequen' chžaglagua'. Nga ḻe yega'aṉ bi tasle, ḻe ṉa' txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nach Jesúsen' gwžialagüe' yelate' na' jac̱haze' ḻo yon' cosc̱ho'ale nach boḻ güiže' Diosen', gwne': ―X̱a', še guac ten ca'ale, benšca cont bi saca'zi'a na' bi yesote'nda' can' ba zoa gaca'. Perw bi chṉaba' gac da' ṉia' neda', san gac can' ṉao' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nach beyeje' gan' nita' beṉe' ca' šoṉe na' ble'ede' zjanite' chesetase'. Na' gože' Pedroa': ―¿Ṉe šlož dao' ca goc cuejle bišgal len neda'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bi tasle na' ḻe yoḻ güiž Dios cont bi gon gwxiyen' le'e gan'. Ṉezda' che'nele ṉa'zle len neda' perw bi chzoele. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na' gosze'e gan' nite' na' da' yoble jaḻ güiže' Diosen', gwne': ―X̱a', še gac ten ca'ale, benšca cont bi saca'zi'a na' bi yesote'nda', perw gac con can' che'ndo' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na' bezyeje' gan' niten' na' da' yoble ble'ede' chesetase' ḻe ba chesežode' yejlagüen' bišgal. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na' gwze'e da' yoble gan' nite'na' jaḻ güiže' Diosen' da' gwyoṉe ṉi'a, na' goznacze' da' yoble can' ba gwnen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na' bezžine' gan' nita' beṉe' ca' šoṉe nach gože' ḻegaque': ―Ṉa'ach guaque tasle na' yezi'laže'le. Ba gole gwde to beṉe' neda' ḻo na' beṉe' güen da' xiṉj ca', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ḻe c̱has. Ḻe yeyo'o. Ba za' ben' gon neda' ḻo na'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ṉe' choe'te Jesúsen' dižan' ca' cate' bžin Judas ben' goque' txen len beṉe' šižiṉw ca' gwlej Jesúsen' cont zjanaque' ḻe' txen. Na' zan beṉe' zja'ac len ḻe' zjanox̱e' no yag, no spada, beṉe' goseseḻa' bx̱oz gwnabia' ca' na' beṉe' gole blao ca' chesenabi'e nación Israel c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na' Judas ben' bdie' ḻe' ḻo na' beṉe' ca', gože' ḻegaque' nac yeseṉezde' non' yesezene', gwne': ―Ben' gwnopa' x̱ague', ḻe'na' Jesús. Ḻe sene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nach ḻa' gwbiga'te' cuit Jesúsen', gože'ne': ―Patiox, Maestrw. Na' bnope'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesúsen' gože'ne': ―Migw c̱hia', ¿bixc̱hen' zao' nga? Nach ḻa' gosebiga'te beṉe' ca' gosezene' Jesúsen' na' gosec̱he'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na' to ben' nac txen len Jesúsen' gwleje' spada c̱hen' na' gwdinen' mos c̱he bx̱oz blaon' gwc̱hogte' šḻa'a naguen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nach Jesúsen' gože'ne': ―Bego'o spada c̱hion' ḻo' liženṉa', ḻe yogo' beṉe' chesote' beṉe' len spada, ḻecze ḻen chesatlene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Bi ṉezdo' guac ṉabda' X̱an' cont ḻa' seḻa'te' angl zan juisyw beṉe' yesaclene' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Perw še gona' ca' ¿nacxe gac dan' cheyaḻa' gac dan' nyoj Xtiža' Diosen' žan quinga gaquen'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nach Jesúsen' gože' beṉe' ca' zjasezen ḻe': ―¿Bixc̱hen' nonḻe neda' ca to beṉe' gwban za'acle zedex̱i'le neda' len spada len yag? Yogo' ža gwchi'a chyo'o yodao' blaon' bsed blo'eda' beṉe' že'na' na' bi gwzenḻe neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Perw chac da' qui cont chac can' ža Xtiža' Diosen' dan' bosozoj da' beṉe' goso'e xtižen' cani'. Nach yogo' beṉe' ca' zjanaque' Jesúsen' txen bosoxoṉje' gosebejyic̱hje'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na' beṉe' ca' gosezen Jesúsen' gosec̱he'ene' lao Caifás ben' nac bx̱oz blao, gan' ba zjanžag beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' na' len beṉe' gole blao ca' chesenabi'e nación c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nach Pedroa' na'ogüe' Jesúsen' zito' zito'le bžinte' liž bx̱oz blaon', na' gwyo'e chyo'ona' gwchi'e len beṉe' ca' chesape' yodao' blaon', ḻe goclaže' le'ede' naquen' zelao gac c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nach yogo' bx̱oz gwnabia' ca' na' yezica'chle beṉe' gole blao ca' chesenabi'e nación c̱hechon' cheseyiljwlaže' bi diža' güenḻaže' yeso'e c̱he Jesúsen' cont yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Perw goc sša bitw besyeželde' bi diža' güenḻaže' yosode'ede' ḻe' cont gosožie'ne' xya ḻa'czḻa' beṉe' zan gosenite' gosene' diža' güenḻažen' contr ḻe'. Gwde na' besechoj yec̱hope beṉe' na' bediḻen can' gosenen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Quinga gosene': ―Benga gwne': “Neda' guac yoc̱hiṉja' yodao' blao gan' chonxencho Diosen', na' šoṉe žaze yeyonan'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nach gwzoža' bx̱oz blaon' gože' Jesúsen': ―¿Bibi de bi ṉao' ca nac da' nga chosocuiš beṉe' quinga le'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bitwbi gwna Jesúsen'. Nach gož bx̱oz blaon' ḻe': ―Chnia' le' gwna neto' še ḻe len' Cristo ben' nac dogualje Xi'iṉ Diosen', ben' gwleje' cont yedeṉabi'e. Na' Diosen' ben' zoa toḻi tocaṉe cue'e da' baḻi še ledo' can' žon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsen' gože'ne': ―Ḻe can' žale nan' naca'. Diosen' gwseḻe' neda' golja' beṉac̱h. Na' chnia' le'e, gwžin ža le'ele neda' chi'a cuit Diosen' ben' nape ḻa'zelagüe yeḻa' guac xen, na' ṉabi'a txen len ḻe', na' le'ele yetja' yaban' to ḻo' bejw. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Cate' bene bx̱oz blaon' xtiža' Jesúsen', gwšo' gwc̱heza'te xen', ḻe par ḻe' da' mal juisyon' gwna Jesúsen' cui'e cuit Diosen' ṉabi'e. Nach gwne': ―Ba benecho ṉa'a ba gwṉe' c̱he Diosen' dan' gwne' ca'. Noch no chyažje no gagw xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nac žale c̱he'? Nach beṉe' ca' bosyoži'en gose'ene': ―Cheyaḻa' gate' dan' chon cuine' ca Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nach bosoži'e x̱ene' cho'alao Jesúsen', na' gosebaže'ne', na' baḻe' gosegape' x̱ague'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nach gose'ene': ―Še len' naco' Criston', gwṉeya'ašc, gwna neto', ¿non' chgapa' le'? ");
INSERT INTO zpqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na' šlac chac da' quinga, chi' Pedroa' chyo'ona', cate' bžin to no'ole güen žin c̱he Caifásen', gože'ne': ―Lencze le' naco' txen len Jesús beṉe' Galilean'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na' lao yogo' beṉe' ca' že' na', Pedroa' bitw gwc̱hebe' še naque' txen len Jesúsen', na' gože' no'olen': ―Bi ṉezda' bi dižan' cho'o. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Gwde beyož gože' no'olen' ca' beyeje' cho'a puert na'le, na' bezle'e yeto no'ole güen žinṉa' ḻe', na' goze'e beṉe' ca' že'na': ―Ḻecze len benga naque' txen len Jesús beṉe' Nazareten'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Da' yoble bitw gwc̱hebe' še naque' txen len Jesúsen', nach gwne': ―Na' zoa Diosen' cue'e da' baḻi bitw nombi'a bena' žo' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na' goccze šlož, gosebiga' beṉe' ca' že'na' goseze'e Pedroa': ―Da' ḻicze, naco' txen len ḻegaque', ḻe nacbia' chṉio' can' cheseṉe beṉe' Galilea ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nach Pedroa' c̱hop šoṉe ṉi'a gwne': ―Diosen' goṉe' ga saca'zi'a še chonḻaža' dan' žia' bi nombi'a bena'. Na' ḻa' gwchežte to jea. ");
INSERT INTO zpqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nach jayze'e Pedroa' can' gož Jesúsen' ḻe': “Biṉa' cuež jean' cate' gac šoṉe ṉi'a bi chc̱hebo' še nombi'o neda'.” Nach beze'e ḻeca gwchežyaše'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na' cate' gwyeni', yogo' bx̱oz gwnabia' ca' na' beṉe' gole blao ca' chesenabia' nación c̱hechon' besyedobe' na' gosec̱hoglagüen' yesote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nach bosoc̱heje'ne' na' gosec̱he'ene' jasesane'ne' ḻo na' gobernador Poncio Pilato. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na' Judasen' ben' bdie' Jesúsen' ḻo na' beṉe' ca', cate' gocbe'ede' ba gosec̱hoglagüen' yesote' Jesúsen', betiṉjde' dan' bdie' ḻe' ḻo na' bx̱oz gwnabia' ca' na' beṉe' gole blao ca'. Nach gwyeje' laogaquen' par bonežjue' ḻegaque' šichoa mechw platan'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nach gože' ḻegaque': ―Malen' bena' bdia' ḻo na'len' to beṉe' bi nape' doḻa'. Na' gose'ene': ―Bitwbi doḻa' nap neto' dan' beno' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nach Judasen' bozaḻe' mechw ca' ḻo' yodao' blaon', nach beze'e na' jaylo'o do yene' beyot cuine'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Beyož beza' Judasen', bx̱oz gwnabia' ca' bosyotobe' mechon'. Na' gose' ḻježe': ―Bitw gac co'ochon ḻo' caj gan' yo'o mechw c̱he yodaon', ḻe naquen mechw dan' gwdixjwcho cont yega'a yeḻa' mban c̱he to beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na' bosoxi'e yesezi'e len mechon' to yežlio dan' de c̱he to beṉe' güen yeso'. Na' gosezi'en par to capsantw ga yosocuaše' beṉe' zito'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Na' yežlion' ṉe' nzin' Yežlio Chen ža ṉa'aža, ḻe gosezi'en len mechw dan' goseyixjue' cont gosote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Can' goc cont goc can' bzoj da' Jeremías ben' be' xtiža' Diosen' cani', gan' žan: “Besyezi'e šichoa mechw platan', dan' gosena beṉe' Israel zaca' bena'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na' gosezi'e yežlio c̱he to beṉe' güen yeso', can' gwna X̱ancho Diosen' neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na' gosec̱he'e Jesúsen' lao gobernadoren' na' šlac zeche' lagüen', gobernadoren' gože'ne': ―¿Len' naco' rey c̱he beṉe' Israel? Nach Jesúsen' boži'e xtižen', gwne': ―Can' gwnao'na', can' naquen. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na' cate' bx̱oz gwnabia' ca' na' beṉe' gole blao ca' chesenabia' nación c̱hechon' bosocuiše' Jesúsen', bitw bi gwne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nach Pilaton' gože'ne': ―¿Bi chendo' catec da' zan xya nga chesagüe' c̱hio'? ");
INSERT INTO zpqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Perw Jesúsen' ṉe to xtiže'na' bitw boži'e, na' bebanechgüe gobernadoren'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na' gota' costumbr, gobernadoren' gwsane' to beṉe' de ḻižya cate' chaḻa' ḻṉi pascw c̱hecho, con beṉe' yeseṉab beṉe' gualaž c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na' ḻižya na' de to beṉe' chzechgua c̱he' naque' beṉe' güen da' xiṉj, na' le' Barrabás. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nach Pilaton' gože' beṉe' ca' zjanžaguen': ―¿Noe' beṉe' quinga chaclaže'le gwsana'? ¿Gwsana' Barrabás še Jesús nga ben' chesene' naque' Cristo ben' gwlej Diosen' cont yedeṉabi'e? ");
INSERT INTO zpqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gocbe'e Pilaton' dan' chesacxi'a bx̱oz gwnabia' ca' Jesúsen', da'nan' bosodie' ḻe' ḻo ne'en. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ca' chi' Pilaton' gan' chone' yeḻa' justisen', cate' bžin to rson da' gwseḻa' no'ol c̱hen', gože'ne': “Bitw bi gondo' bena', ḻe bibi doḻa' nape'. Nže'e gwṉeda'ne' yel na' bžaglaochgua' ṉec̱he dan' chac c̱he bena'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na' bx̱oz gwnabia' ca' na' beṉe' gole blao ca' chesenabi'e nación c̱hechon' gosego'oyeḻe' beṉe' ca' že'na' cont yeseṉabe' gwsane' Barrabásen' na' yeseṉabe' yesote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nach gobernadoren' gože' ḻegaque' da' yoble: ―¿No beṉe' quinga c̱hope chaclaže'le gwsana'? Nach gose'ene': ―Barrabásna'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaton' gože' ḻegaque': ―¿Bixe gona' len Jesús nga ben' chesene' naque' Cristo ben' gwlej Diosen' cont yedeṉabi'e? Na' yogüe' gose'ene': ―¡Bde'e ḻe'e yag cruz! ");
INSERT INTO zpqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nach gož gobernadoren' ḻegaque': ―¿Bixe da' xiṉj nonen'? Na' ḻegaque' da' yoble bososya'achgüe' gose'ene': ―¡Bde'e ḻe'e yag cruz! ");
INSERT INTO zpqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gocbe'e Pilaton' bicze bi gac gone'. Ba chyaḻa'ch chesone' žaš juisyw. Nach gwseḻe' to beṉe' jax̱i'e nis cont bone'e lao beṉe' ca' že'na' na' gože' ḻegaque': ―Bibi da' xiṉj non benga. Bitw naquen xbaga' dan' gotlene', xbaga' le'e naquen še ba betwlene'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nach yogo' beṉe' ca' gose'ene': ―Xbaga' neto' na' xbaga' xi'iṉto' naquen c̱he yeḻa' got c̱he benga. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nach bsan Pilaton' Barrabásen' can' goseṉaben'. Perw na' bene' mandadw gosot goseyin soldadw c̱he' ca' Jesúsen', nach bene' ḻe' ḻo na'gaque' cont yosode'ene' ḻe'e yag cruzen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nach soldadw c̱he gobernadoren' gosec̱he'e Jesúsen' ḻo' yo'o c̱he gobernadoren', nach bosyotobe' yogo' soldadw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na' goseyiṉe' xaḻana' Jesúsen' na' bosoguacue'ne' to lache' xṉa ca dan' chesaz rey ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na' gosone' to corona de xis yeše' bosozoen' yic̱hjen', na' ne'e ḻicha bosogox̱e'ne' to xis. Na' bosozoa xibe' lagüen' par gosonḻe' c̱he', nach gose'ene': ―¡Viva rey c̱he beṉe' Israel! ");
INSERT INTO zpqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nach bosoži'ene' xene', na' besyeque'e xis dan' nox̱en' na' bosozeten' yic̱hje'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na' beyož gosonḻe' c̱he', besyeque'e lache' xṉan' dan' bosoguacue'nen' na' bosyoguacue'ne' xacze'. Nach gosec̱he'ene' cont jasede'ene' ḻe'e yag cruzen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nach besechoje' ciudan' na' besyežague' to beṉe' Cirene le Simón na' gosone' byen bosogüe'ene' yag cruz c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na' besežine' to latje gan' nzi' Gólgota, zeje diža' latje c̱he žit yic̱hj beṉe' guat. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na' bosonežjue' Jesúsen' vino da' nc̱hix̱e to da' zḻa' par ye'ejen', perw ḻe' con bṉix̱en', bitw güe'ejen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na' cate' beyož bosode'ene' ḻe'e yag cruzen', soldadw ca' gosone' rifa cate' besyeḻe'e xaḻane' cont gota'bia' noe' yechelen'. Na' dan' gosone' ca' goc can' bzoj da' ben' be' xtiža' Diosen' cani', gwne': “Yesyeḻe'e xaḻanan' na' yesezi' c̱he c̱he', yesonen' rifa.” ");
INSERT INTO zpqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nach gosebi'e gosape'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na' yic̱hj yag cruzen' gan' de'ena' bosozoje' dan' bcuiš ḻe', na' žan: “Benga Jesús rey c̱he beṉe' Israel ca'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na' ḻecze cana' bosode'e c̱hope beṉe' gwban ḻe'e yec̱hope yag cruz. Toe' gwda' cuit Jesúsen' ḻicha na' yetoe' cuite' robes. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na' beṉe' ca' gosede gan' da' Jesúsen' goson yic̱hjlagüe' dan' ḻeca besegue'ede' ḻe', na' gosezi'diže' ḻe', ");
INSERT INTO zpqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gose'ene': ―Len' gwnao' yoc̱hiṉjo' yodao' blaon' na' šoṉe žaze yeyonon', bosla cuino'. Še len' naco' doguale Xi'iṉ Diosen', beyetj ḻe'e yag cruzen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na' len bx̱oz gwnabia' ca' na' len beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' na' len beṉe' fariseo ca', na' len beṉe' gole blao ca' chesenabi'e nación c̱hechon', yogüe' gosezi'diže'ne' na' gosene': ");
INSERT INTO zpqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―¡Yezica'chle beṉe' bosle' na' bi chac yosla cuine'! Še naque' rey c̱he chio' beṉe' Israel, yeḻetj cuine' ḻe'e yag cruzen' ṉa'a na' šejḻe'cho c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ḻe' chejnilaže' Diosen', ḻe gwne': “Dogualje Xi'iṉ Dios neda'.” ¡Na' le'echo yosla Diosen' ḻe' ṉa'a še chacde' ḻe'! ");
INSERT INTO zpqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na' beṉe' gwban ca' zjada' ḻe'e yag cruzen' chop ḻa'a cuiten', ḻecze gosezi'diže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na' do guagwbiž doxen yežlion' goc c̱hoḻ bžinte cheda šoṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na' do cheda šoṉe Jesúsen' bosye'e zižje gwne': ―Elí, Elí, ¿lama sabactani? (Zeje diža': Dios c̱hia', Dios c̱hia', ¿bixc̱hen' ba gwlejyic̱hjo' neda'?) ");
INSERT INTO zpqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na' baḻ beṉe' ca' zjanita' na' gosende' na' gosene': ―Ḻe gwzenag, benga choḻ güiže' da' Elías ben' be' xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nach ḻa' bchojte to beṉe' gwyejsese' jax̱i'e to esponja na' bzažeden' vino zic̱hj na' bzoen' to lao xis toṉe nach jažiguen' cho'a Jesúsen' cont xopen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na' yebaḻe' gose'e bena': ―Cuezcho, yešc še güide Elíasen' yosle'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nach da' yoble Jesúsen' bosye'e zižje na' gote'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na' ca hora' lache' da' ze ḻo' yodao' blaon' bcheza' gachoḻen gwza'te yic̱hjen bžinte che'eḻe. Na' gwxo'chgua gosoxjte yej ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na' ḻecze beseyaljo ba c̱he beṉe' ba gosat. Na' zan da' beṉe' ca' gosejnilaže' Diosen' besyebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nach caten' ba beban Jesúsen' ladjo beṉe' guat ca', besyechoje' ḻo' ba c̱hegaquen' na' jaya'aque' jaselo'elagüe' ciuda Jerusalén. Na' zan beṉe' besele'ede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na' ca nac x̱an soldadw ca' na' beṉe' ca' nc̱he'e, beṉe' nita' chesape' Jesúsen', cate' besele'ede' can' gwxo' na' bichle da' ca' goc, besežebchgüe', na' gosene': ―Da' ḻi ḻe benga goc dogualje Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na' ḻecze nita' zan no'ole ladjo beṉe' ca' na' goseze' zito' cheseṉe'e can' chaquen'. No'ol ca' gosa'ogüe' Jesúsen' cate' beze'e distritw Galilean' par chesaclene' ḻe' len bi da' chyažjde'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na' len no'ol ca' María beṉe' Magdala, na' ḻecze María ben' nac xṉa' Jacobo na' José, na' ḻecze ca' xṉa' Jacobo na' Juan, xi'iṉ Zebedeo. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na' gwzoa to beṉe' gwṉi'a beṉe' ciuda Arimatea le' José na' ba gwzolao chzenague' c̱he Jesúsen'. Na' cate' ba chxoa gwbiž ");
INSERT INTO zpqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josén' gwyeje' lao Pilaton' jayṉabe' cuerp c̱he Jesúsen'. Na' Pilaton' bene' mandadw bosyonežjue'ne' cuerp c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nach Josén' bego'o ḻo ne'e cuerp c̱he Jesúsen' na' blaže'ne' to lache' xen da' nyach. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na' gwlo'e cuerp c̱hen' to ḻo' bloj cobe c̱he' da' gwc̱he'ene' ḻe'e yej. Na' bḻoḻe' to yej xen cho'a blojen' cont bseyjon ḻen. Nach beze'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na' María beṉe' yež Magdalan' na' yeto María yoble jasechi'e cho'a blojen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na' beteyo, gwde žan' caten' chososiṉi'e par ža c̱he Diosen', besedobe bx̱oz gwnabia' ca' na' beṉe' fariseo ca' na' ja'aque' gan' zoa Pilaton'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na' gose'ene': ―Beṉe', ba jaysalaže'to' can' gwna da' beṉe' gwxiyen' cate' ṉe' mbane', gwne': “Yeyoṉ ža yebana' ladjo beṉe' guat ca'.” ");
INSERT INTO zpqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Da'nan' gwseḻa'šca beṉe' šjasedape' cho'a blojen' gan' jasecuaše'nen' cont bi šja'ac beṉe' ca' gosaque' Jesúsen' txen šeže'le šjasyeleje' cuerp c̱hen' na' yese'e beṉe' ḻe bebane' ladjo beṉe' guat ca'. Ḻe še yesaque beṉe' ba bebane' ladjo beṉe' guat ca', gonchen malech clel ca len diža' dan' gwdise' gwne' Diosen' gwseḻe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nach Pilaton' gože' beṉe' ca': ―Goṉa' le'e soldadw ca'. Ḻe c̱he'e cont yesape' ga zelao yesezoede'. ");
INSERT INTO zpqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nach ja'aque' len soldadw ca' na' bosoc̱hiše' sey ḻe'e yej dan' da' cho'a blojen', na' bosonite' soldadw ca' gosapen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na' cate' beyec̱hj ža c̱he Dios, baḻ dmigw María beṉe' Magdala len María ben' yeto ja'aque' jaseṉe'e gan' bosocuaše' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na' ḻeca gwxo', ḻe angl c̱he X̱anchon' betje' yaban', na' bžine' gwque'e yej dan' nseyjw cho'a blojen', na' gwchi'e ḻo yeja'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na' anglen' ḻeca chactit cho'alagüen' cacze ga chep yes na' xaḻanen' naquen šiš xila' juisyw ca nac beye'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na' cate' besele'e beṉe' gop ca' ḻe', ḻeca gosexize' besežebe' na' gosebix̱e' gosatte' šlat. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Perw na' anglen' gože' no'ol ca': ―Bitw žeble. Neda' ṉezda' Jesúsen' ben' bosode'e ḻe'e yag cruz nan' cheyiljwle. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nono de nga. Ba bebane' ladjo beṉe' guat ca', can' gwnacze'. Na' ḻe da, ḻe ṉa' latje nga gan' gosegüe'e cuerp c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bedao' ḻe šjaya'ac ḻe šjaydix̱jue'e beṉe' ca' zjanaque' Jesúsen' txen ye'gaclene' ba bebane' ladjo beṉe' guat ca'. Na' ye'gaclene' gwyobech Jesúsen' yežine' Galilean' clel ca ḻegaque', na' Galilean' na' yesele'ede'ne'. Can' gwna Diosen' zedetix̱jue'eda' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nach no'ol ca' ḻa' besyeya'actie' cho'a blojen' do chesežebze' perw ḻeca chesyebede', zjaya'acsese' zjasyedix̱jue'ede' beṉe' ca' zjanaque' Jesúsen' txen can' goca'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na' šlac zjaya'aque' besyežague' Jesúsen' chanez. Nach bguape' ḻegaque' tiox. Na' no'ol ca' gosebigue' gan' zoa Jesúsen' bosozoa xibe' lagüen', na' goseyeḻe' ṉi'e tantw besyebede', na' gosonxene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesúsen' gože' ḻegaque': ―Bitw žeble. Ḻe šjaydix̱jue'e beṉe' ḻježcho ca', cheyaḻa' šjaya'aque' Galilean' cont yesele'ede' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na' šlac zjaya'ac no'ol ca' ciudan', baḻ soldadw ca' beṉe' ca' gosape' gan' bosocuaše' Jesúsen' jaya'aque' ciudan' jasyedix̱jue'ede' bx̱oz gwnabia' ca' doxen can' ba goquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nach besedobe bx̱oz gwnabia' ca' len beṉe' gole blao ca' chesenabia' nación c̱hechon' na' bosoxi'e nac yesone' ca nac dan' gose' soldadw ca' ḻegaque'. Na' bosonežjue' soldadw ca' da' zc̱ha'o mechw. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Gose'e ḻegaque': ―Še no ṉabe le'e bin' goquen', na' ye'gaclene' šeže'le šlac chtasle beṉe' ca' gosaque' ḻe' txen besyebeje' cuerp c̱hen' ḻo' blojen' na' besyeyo'en ga yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na' še gobernadoren' yende' diža' quinga, neto' šjašaḻjlento'ne' cont bi že'e le'e na' cont bi gote' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na' soldadw ca' gosezi'e mechon' dan' bosonežjue' ḻegaquen', nach gosone' con can' gose'e ḻegaque'. Na' ža ṉa'aža yogo' can' gosena soldadw ca' ṉe' chesene' doxen gan' nita' beṉe' Israel gualaž c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nach beṉe' ca' zjanaque' Jesúsen' txen, beṉe' ca' šnej, jaya'aque' Galilean' cont jasyešague' Jesúsen' to ḻo ya'a gan' gože' ḻegaque' yesyežague'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na' cate' besele'ede' Jesúsen' gosonxene'ne'. Perw bia'cze to c̱hope' gosacžejlaže' še ḻe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nach gwbiga' Jesúsen' gan' nite'na' na' gože' ḻegaque': ―Ba ben Diosen' ḻo na' doxen yeḻa' chnabian' dan' de yaban' na' yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Da'nan' ḻe šja'ac ḻe šjased ḻe šjalo'e beṉe' ca' že' yogo'ḻoḻ nación cont yesejnilaže' neda'. Na' ḻe gwzoe' nis cont yosolo'e ḻe chesejnilaže' X̱acho Diosen', na' chesejnilaže' neda' naca' dogualje Xi'iṉe', na' lencze Spiritw c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na' gwsed gwlo'elne' cont yesone' yogo'ḻoḻ dan' ba bena' mandadw gonḻe. Neda' zoacza' len le'e yogo' ža, na' ca'cze ṉe' soa' len le'e cate'ch te c̱he yežlion'. Da' na'zen' chzoja' ṉa'a.");
INSERT INTO zpqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Qui goc cate' gwxe xtiža' Jesucristo ben' nac dogualje Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Da' Isaías ben' be' xtiža' Diosen' cani' bzoje' da' nga, žan: Chseḻa' to beṉe' cuialagüe' laoguon' güe'e xtižon', cont ba zjanita' beṉe' yosozenague' c̱hio' cate' šejo'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Beṉa' chṉe' zižje latje dašen' že': “Ḻe gonšagüe' yic̱hjlažda'olen' cont gwzenagle c̱he X̱anchon' cate' yide'; ḻe cuejyic̱hj da' malen' chonḻe cont yic̱hjlažda'olen' gaquen ca to nez da' ba gosonšagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ca' goquen', Juan ben' chzoa beṉe' nis bžine' latje dašen' na' gože' beṉe' ca' besežag na' cheyaḻa' yesyetiṉjde' xtoḻa'gaque' na' yesezoe' nis cont ṉitlao xtoḻa'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zan beṉe' za'ac do distritw Judea na' ciuda Jerusalén bosozenague' c̱he diža' dan' chyix̱jue'ede'. Na' cate' gosex̱oadoḻe' bi da' xiṉj zjanone', Juanṉa' bzoe' ḻegaque' nis ḻo' yegw Jordán. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xaḻana' Juanṉa' goquen de yiša' xa camello na' da' bc̱hej ḻsine' goquen de yid, na' gwdagüe' biše'zo len šina' beser yix̱e'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na' gwdix̱jue'ede' beṉe' xtiža' Diosen', gwne': ―Coža' na' za' za' to beṉe' zaca'che' ca neda', na' da' nacchgüe' beṉe' zaca', bi zaca' gona' xmandadoe' ḻec̱hja' no xele'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neda' ba bzoa' le'e nis, perw ben' za' zan' gone' cont soa Spiritw c̱he Diosen' ḻo' yic̱hjlažda'olen' ṉabian' xbab c̱hele. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ca tiempa' Jesúsen' gwze'e lagüe yež Nazaret da' chi' ga mbane distritw Galilea, na' Juanṉa' bzoe' ḻe' nis ḻo' yegw Jordán. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na' šlac chechoj Jesúsen' ḻo' nisen', Jesúsen' ble'ede' byaljw yaban' gan' zoa Diosen', na' Spiritw c̱he Diosen' betjen jasoan len ḻe', na' ca hora' Spiriton' naquen ca nac ngolbex. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na' gosende' gwṉe Dios ben' zoa yaba gwne': ―Len' naco' Xi'iṉa' beṉe' chacchgüeda', na' chebe chezaque'laže'chgüeda' c̱hio'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nach Spiritw c̱he Diosen' benen cont ḻa' gwyejte Jesúsen' latje daš. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na' gwzoe' latje dašen' c̱hoa ža ladjo be znia ca'. Na' Satanás dan' chnabia' da' xigüe' ca' goclažen' co'oyeḻan' ḻe' cont gone' da' mal. Nach beyoža' jasaclen angl c̱he Diosen' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Beyož gosegüe'e Juanṉa' ḻižya, Jesúsen' beze'e beyeje' Galilea gan' jatix̱jue'ede' diža' güen, gwne' Diosen' ṉabi'e yic̱hjlaždao' beṉe' ca' yosozenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesúsen' gwne': ―Ba bžin ža cate' Diosen' ṉabi'e yic̱hjlaždao' beṉe' yosozenagüe' c̱he'. Ḻe yetiṉje xtoḻa'len' na' ḻe šejḻe' diža' güen c̱he Diosen' da' chyix̱jue'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesúsen' chde' do cho'a nisdao' c̱he Galilean' cate' ble'ede' c̱hope beṉe' gwxen beḻ, Simón na' beṉe' biše' Andrés. Na' zjanite' chosozaḻe' yix̱jw dan' chesezende' beḻen' ḻo' nisa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na' gož Jesúsen' ḻegaque': ―Ḻe šo'o len neda'. Nacle beṉe' gwxen beḻ na' chbejle beḻen' ḻo' nisen', perw ṉa'a gona' cont gaxle beṉe' yesyechoje' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nach ḻa' bosocua'aṉte yix̱jw c̱hen' na' jasa'aclene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na' Jesúsen' gwze'e yelate' na' ble'ede' Jacobon' xi'iṉ Zebedeo na' len beṉe' biše' Juan, zjayo'e ḻo' barcw chesyeyonšagüe' yix̱jw c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na' Jesúsen' ḻecze goxe' ḻegaque' šja'aclene' ḻe' na' bosocua'aṉe' Zebedeon' ben' nac x̱agaque ḻo' barcon' len beṉe' ca' chesaclen ḻe', nach ja'aque' len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Besežine' yež da' nzi' Capernaum, na' ža c̱he Dios Jesúsen' gwyo'e ḻo' yodao' da' zoa na' na' gwzolagüe' bsed blo'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Beṉe' ca' že' na' besyebande' can' bsed blo'ede', ḻe can' bzejni'iden' nacbia' ṉezde' cayaṉen' nac xbab c̱he Diosen', gague bzejni'ide' can' chosozejni'i ben' chosolo'e ley dan' bzoj da' Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na' ḻo' yodaon' zoa to beṉe' yo'o nyaze' da' x̱igüen', na' bosye'e gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Bixc̱hen' chgoša' chlaže' c̱hio' len neto', Jesús beṉe' Nazaret? ¿Zedežiayo'o neto'? Neda' nombi'a le' na' ṉezda' naco' beṉe' laždao' xilaže' juisyw beṉe' gwseḻa' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nach Jesúsen' gože' da' x̱igüen': ―¡Sšago', bechoj ḻo' yic̱hjlaždao' benga! ");
INSERT INTO zpqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na' da' x̱igüen' benen cont gwc̱hoḻe bena', nach chosya'adiachguan bechojen ḻo' yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yogo' beṉe' ca' že' na' besyebande' na' gose' ḻježe': ―¿Bixen' chac? ¿Bixe da' coben' chlo'e benga? ¡Nacbia' nape' yeḻa' chnabia' na' yeḻa' guac, ḻe da' x̱igüe' ca' chesonen da' že'! ");
INSERT INTO zpqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na' ca nac dan' ben Jesúsen' bedao'nez gos gwlalje dižan' doxen lagüe yež ca' gan' mbane Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cate' besyechoje' ḻo' yodaon', Jesúsen' len Jacobo na' len Juan ja'aque' liž Simón na' Andrés. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na' taobi'iṉ c̱he Simónṉa' die' che'ede' xḻa; na' gose'e Jesúsen': ―Benga die' che'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nach jabiga' Jesúsen' na' bex̱ue' taquen' gwḻise'ne'. Na' ḻa' beyactede', nach bsiṉi'e da' gose'ej gosagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cate' ba gwxoa gwbižen' na' ba gwx̱in, jasesane' lao Jesúsen' zan beṉe' chese'ede' na' beṉe' zjayo'o zjanyaze' da' x̱igüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na' do yež beṉe' besedop besežague' cho'a yo'o gan' zoa Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na' Jesúsen' beyone' beṉe' chese'ede' gwde gwdele yižgüe' na' bebeje' zan da' x̱igüe' da' zjayo'o zjanyaz beṉe', perw bitw bi'e latje bi yesenan, ḻe ḻegaquen zjaṉezen non' nac ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Šbaḻ cate' ṉe' nac c̱hoḻjesúsen' gwyase' na' gwze'e gwyeje' ga nono nḻa' na' boḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón na' beṉe' ḻježe' ca' ja'aque' jasyediljue'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na' cate' besyeželde'ne' gose'ene': ―Yogo'ze beṉe' chesyeyiljue' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Perw Jesúsen' gože'ne': ―Ḻe šo'o ga yoble ga nac gaḻa'ze cont ḻecze šjatix̱jue'eda' xtiža' Diosen' na', ḻe da'nan' ba gwza'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Can' goc, Jesúsen' gwde' doxen gan' mbane Galilea gwdix̱jue'ede' xtiža' Diosen' to to yodao' c̱he neto' beṉe' Israel, na' bebeje' da' x̱igüe' da' yo'o nyaz beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To beṉe' che'ede' yižgüe' dan' nzi' lepra jabigue' gan' zoa Jesúsen' na' bzoa xibe' gože'ne': ―Še chaclažo', guac yeca'o yižgüe' dan' che'edan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na' Jesúsen' beži'ilaže'de' ḻe' na' bex̱ue'ne' gwne': ―Chaclaža' yeyacdo'. Beyaque. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cate' gwne' ca' ḻa' bega'ate yižgüen' na' beyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nach Jesúsen' beseḻe'ne' liže', bene' mandadw, gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Notno yo'o can' ba beyona' le', con gwyej jaṉa' bx̱oza' cont le'ede' bac̱h beyacdo', na' bnežjw da' cheyaḻa' gwnežjo' dan' non Moisésen' mandadw cont yeyaco' xilaže' len ley c̱he Diosen'. Ben ca' cont yogo' beṉe' yeseṉezde' ba beyacdo'. ");
INSERT INTO zpqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Perw ben' bi bchejde', yogo'ze beṉe' gože' can' goca'. Da'nan' Jesúsa' bich goc šeje' con ca nḻa'ze gate'teze yež, san con gwde' do yix̱e', na' bia'cze beṉe' za'ac yogo'ze yež jaseṉe'e ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gwde to c̱hop ža, Jesúsen' beyeje' da' yoble yež dan' nzi' Capernaum, na' beṉe' Capernaum ca' goseṉezde' bežine' to yo'o ga ba gwzoacze'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na' bedao'nez besežag beṉe' zan, ṉecach gosezaque' yesenite' ḻo' yo'ona' ṉe cho'a yo'on, nach Jesúsen' gwdix̱jue'ede' xtiža' Diosen' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nach besežin x̱oṉj beṉe' cont jasesane' lao Jesúsen' to beṉe' xiṉj beṉe' bi chda šḻa'a ṉi'a ne'e; tap beṉe' zjano'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Perw bi chac yesežine' gan' zoa Jesúsen' catec chyi. Nach goseque'e tej dan' ncua' yic̱hj yo'on na' beseḻetje' ḻe' na'le to ḻo cam̱ dao'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na' cate' Jesúsen' gocbe'ede' can' chesejnilaže'nen', gože' beṉe' güe'na': ―Xi'iṉa', ba bezi'xena' xtoḻon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Baḻ beṉe' chososed chosolo'e ley dan' bzoj da' Moisésen' zjachi'e na', na' gosone' xbab: ");
INSERT INTO zpqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Bixc̱hen' chna benga ca'? ḻe chon cuine' ca Dios. Nono zoa beṉe' gac yezi'xene' xtoḻa' beṉac̱h. Toz Diosen' gac yezi'xenen'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Perw Jesúsen' chacbe'eczede' can' nac xbab c̱hegaquen', na' gože' ḻegaque': ―¿Bixc̱hen' chza'laže'le ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Še yapa'ne': “Ba bezi'xena' xtoḻo'na'”, bi ṉezele še napa' yeḻa' gwnabia' cont yezi'xena' xtoḻe'na', san še yapa'ne': “Gwyas, beyoa' xcamon'”, na' nacbia' še napa' yeḻa' guac gac can' gwnian'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Perw neda' naca' ben' gwseḻa' Dios golja' beṉac̱h, gwlo'eda' le'e ṉa'a zoa' yežlio nga napa' yeḻa' gwnabia' cont yezi'xena' xtoḻa' beṉac̱h. Nach gože' beṉe' xiṉja': ");
INSERT INTO zpqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Chapa' le', beyas, beyoa' xcamon' na' beyej ližo'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ḻa' beyaste beṉe' xiṉja' cheseṉa'te beṉe' ca' nita'na' na' beyoa' xcamen'. Da'nan' yogo' beṉe' ca' besyebande' na' goso'e yeḻa' chox̱clen c̱he Diosen', gosene': ―Biṉa' le'echo yeḻa' guac dan' nac ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Da' yoble gwyej Jesúsen' cho'a nisdao' na' beṉe' zan besedobe' gan' zeje' na' bsed blo'ede' ḻegaque' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na' Jesúsen' gwdie' latje gan' chi' Leví xi'iṉ Alfeo chc̱hixjue' impuesto, na' cate' ble'ede' ḻe' na' gože'ne': ―Da len neda'. Nach gwzoža' Levín' na' gwyejlene'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na' gwdena' goquen' chi' Jesúsen' liž Levín' na' güe'ej gwdagwlene'ne' txen len zan beṉe' güec̱hixjw na' len yebaḻ beṉe' güen da' xiṉj, na' len beṉe' ca' zjanaque' Jesúsen' txen, ḻe zan beṉe' zja'ac zjanao' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Perw na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés na' beṉe' fariseo ca' cate' besele'ede' che'ej chagüe' txen len beṉe' ca', gose'e beṉe' ca' zjanaque' Jesúsen' txen: ―¿Nacxec̱hen' ben' chsed chlo'e le'e che'ej chagwlene' txen beṉe' güec̱hixjw na' yebaḻ beṉe' güen da' xiṉj ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cate' Jesúsen' bende' can' gosene' na' gože' ḻegaque': ―Beṉe' bi chesacšene bi cheseyažjde' beṉe' güen rmed. Beṉe' chesacšende', ḻegaquen' cheseyažjde' beṉe' güen rmed. Gague beṉe' ba zjanaque' beṉe' güen len Diosen' zedeṉeyoeda' cont yesyetiṉjde' xtoḻen', san beṉe' güen da' xiṉj. Ḻegaquen' zjazaca'lebe' ca beṉe' cheseyažje beṉe' güen rmed. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","To ža cate' beṉe' ca' zjanaque' txen len Juanṉa' na' beṉe' zjanaque' txen len beṉe' fariseo ca' gosezoe' gwbas, baḻ beṉe' jasa'aque' jaseṉabde' Jesúsen': ―Beṉe' ca' zjanaque' txen len Juanṉa' na' beṉe' ca' zjanaque' txen len beṉe' fariseo ca' chesone' gwbas, na' beṉe' ca' zjanaque' txen len le' bi chesone' gwbas. ¿Bixc̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na' Jesúsen' gože' ḻegaque': ―¿Guaque yesezoa gwbas beṉe' chaxe' to ga chac yeḻa' güešagna' šlac ben' bšagnan' zoalene' ḻegaque'? Še zoa ben' bšagnan', bi gac yesone' gwbas. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Perw žin ža cate' bich zoe' len ḻegaque', cana'ch yesone' gwbas. Na' ca'czen' naquen len neda' na' len beṉe' ca' zjanaque' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Nono zoa beṉe' yode'e to lache'ex̱o' na' yezoen' to lache' cobe, ḻe lache' coben' yeben' cate' c̱hiben' na' šon' lache' golen', na' gan' žoṉ'na' gacchen da' xen. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ṉeca zoa beṉe' chgue'e vino cobe ḻo' bzod yide'ex̱o', ḻe vino coben' chšon' yide'ex̱on' na' chbiayi' vinon' len yida'. San chesegue'e vino coben' ḻo' yid cobe cont bibi gaquen. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","To ža c̱he Dios Jesúsen' gwdie' to ga nyaž trigw, na' beṉe' ca' zjanaque' ḻe' txen gosezolagüe' chesaḻje' dao c̱he trigon' šlac gosedie' gan' nyaženṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nach beṉe' fariseon' gose'e ḻe': ―Gwṉa'šc ¿bixc̱hen' cheson beṉe' ca' zjanaque' le' txen žin da' bi cheyaḻa' yesone' ža c̱he Dios? ");
INSERT INTO zpqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na' Jesúsen' gože' ḻegaque': ―¿Biṉa' gwlable can' ben da' rey David to ža cate' ḻe' na' beṉe' ḻježe' ca' gosedone'? ");
INSERT INTO zpqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Gwyo'o Davin' ga nac liž Dios cate' da' Abiatar goque' bx̱oz blao, na' gwdagüe' yetextil da' nac c̱he Dios da' bi chac gagw beṉe' bi nac bx̱oz, na' ḻecze bnežjue' c̱he beṉe' zja'ac len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ḻecze gož Jesúsen' ḻegaque': ―Diosen' gwleje' to ža cate' bi yeson beṉac̱hen' žin cont gaclenen beṉac̱h, gague gwleje' beṉac̱hen' cont yesonxene' ža c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Da'nan' naquen ḻo na' ṉia' bi da' nac güen goncho lente cate' nac ža c̱he Dios, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yeto ža c̱he Dios Jesúsen' gwyo'e da' yoble to ḻo' yodao' c̱he neto' beṉe' Israel na' ca hora' ba chi' to beṉe' nx̱o'oṉ šḻa'a taque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na' beṉe' ca' že' ḻo' yodao'na' chosogüia cheseṉe'e Jesúsen' še yeyone' bena' žan' nac ža c̱he Dios cont de da' yosode'ede' yesagüe' xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nach Jesúsen' gože' ben' nx̱o'oṉ taquen': ―Gwzoža' na' gwzecha nga. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nach gwṉabde' beṉe' ca' yezica'chle: ―¿Bi da' cheyaḻa' goncho ža c̱he Dios? ¿Goncho da' güen, še goncho da' mal? ¿Cheyaḻa' yoslacho beṉe', še cheyaḻa' gotchone'? Perw na' ḻegaque' gosenite' šižize. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nach Jesúsen' gwṉe'e ḻegaque', bže'e can' gosone' xbab, na' ḻecze gocyaše'laže'de' dan' bi gosejḻe'e c̱he', nach gože' ben': ―Bḻi naon'. Na' bḻien', na' taquen' beyaquen binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nach besyežaš beṉe' fariseo ca' na' gosezolagüe' chosoxi'e len beṉe' ca' zjada' Herodes naquen' yesone' yesote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nach Jesúsen' gwyeje' cho'a nisdaon' len beṉe' ca' zjanaque' ḻe' txen, na' zan beṉe' Galilea ja'ac len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Na' zan beṉe' za'aque' Judea, na' Jerusalén, na' Idumea, na' yešḻa'a yegw Jordán, na' gan' mbane Tiro na' Sidón goside' bedeseṉe'e ḻe' cate' goseṉezde' yeḻa' guac da' chonen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Da'nan' Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen yeseyiljue' to barcw dao' gan' cuie' cont bi yosoc̱hi beṉe' ca' zjanžaga' ḻe', ");
INSERT INTO zpqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ḻe beṉe' zan ba beyone', na' beṉe' ca' ṉe' chese'ede' chosožiga' ḻježe' nac gac yesox̱e'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na' beṉe' ca' zjayo'o zjanyaz da' x̱igüen' cate' chesele'ede' Jesúsen' chosozoa xibe' lagüen' na' da' x̱igüe' ca' chososya'an chese'en ḻe': ―Len' naco' dogualje Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Perw Jesúsen' gwdiḻe' ḻegaquen na' bene' mandadw bi yesenan no nac ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Beyoža' Jesúsen' gwloe' to ḻo ya'a na' goxe' baḻ beṉe' goclaže' šja'aclene' ḻe', nach gosa'aque' ja'aque' gan' zoen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nach gwleje' šižiṉw beṉe' yesenita' len ḻe', cont seḻe' ḻegaque' šjasedix̱jue'ede' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na' bnežjue' ḻegaque' yeḻa' guac cont yesyeyone' beṉe' güe' na' yeḻa' gwnabia' cont yesyebeje' da' x̱igüe' da' yo'o nyaz beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Šižiṉw beṉe' quin' gosac: Simón ben' ḻecze gože'ne' Pedro; ");
INSERT INTO zpqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo len beṉe' biše' Juan beṉe' ca' zjanac xi'iṉ Zebedeo, na' bsi'e ḻegaque' Boanerges, zeje diža' beṉe' zjanac ca yi' gwzio' cate' chašjw chtinen; ");
INSERT INTO zpqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nach Andrés, na' Felipe, na' Bartolomé, na' Mateo, na' Tomás, na' Jacobo xi'iṉ Alfeo, na' Tadeo, na' Simón ben' gwde'e beṉe' ca' zjanzi' cananista, ");
INSERT INTO zpqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na' Judas Iscariote ben' gwdechle bdie' Jesúsen' ḻo na' beṉe' ca' chesegue'ede' ḻe'. Beyoža' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen goso'e ḻo' yo'o gan' zoe' ca hora', ");
INSERT INTO zpqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","na' da' yoble besežagchgua beṉe', ṉeca goc yese'ej yesagw Jesúsen' len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na' cate' goseṉeze biše' ḻjež Jesúsen', ja'aque' cont yesyec̱he'ene', ḻe gosene' chactonte'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nach beṉe' ca' bososed bosolo'ede' ley dan' bzoj da' Moisés gosa'aque' Jerusalén na' ja'aque' distritw Galilea gan' chsed chlo'e Jesúsen' na' gose'e beṉe' ca' že'na': ―Benga yo'o nyaze' Beelzebú dan' chnabia' da' x̱igüe' ca', na' Beelzebún' chaclenen ḻe' cont chebeje' da' x̱igüe' zjayo'o zjanyaz beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nach Jesúsen' goxe' beṉe' ca' na' bsed blo'ede'ne' gwne': ―¿Nac gon Satanás dan' chnabia' da' x̱igüe' ca' yebejen ḻecze da' x̱igüe'? ");
INSERT INTO zpqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Še to gobierṉ choje' c̱hop šoṉ cuenḻe na' yeyoža' yesediḻe ḻegacze', gobierṉna' bi sibi'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na' še beṉe' že' toz yo'o yesechoje' c̱hople na' yesediḻe ḻegacze', gague sša yesenite' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na' še Satanásen' len da' x̱igüe' c̱hen yesechojen c̱hople na' yesediḻen, ḻecze bi sibian', san na' yeyož yedon. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nono gac šo'e ḻo' yo'o c̱he to beṉe' gual na' que'e bi da' de c̱he' še cbi zgua'tec gwc̱heje' beṉe' gual na', ḻete gone' ca' nach gac que'e bi da' de c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Da' ḻi žia' le'e, yogo' da' xiṉj da' chon beṉac̱h na' yogo' diža' bya' da' yeseṉe', Diosen' yezi'xene' c̱hen še yesyetiṉjde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Perw note'teze beṉe' ṉe' yeḻa' ya' c̱he Spiritw c̱he Dios, gwbat yezi'xen Diosen' c̱he', san de doḻa' c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gwne' ca' dan' gosene' c̱he' yo'o nyaze' da' x̱igüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na' bžin xṉa' Jesúsen' len beṉe' biše', na' gosenite' chyo'ole gosaxe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na' beṉe' ca' zjanita' cuit Jesúsen' gose'ene': ―Xṉa'o len beṉe' bišo' ca' zjanite' chyo'o na' chesyeyiljue' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nach Jesúsen' gože' ḻegaque': ―¿Ṉezele non' nac xṉa'a na' no zjanac biše' ḻježa'? ");
INSERT INTO zpqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nach gwṉe'e beṉe' ca' zjachi' cuite'na', na' gwne': ―Beṉe' quin' zjanac xṉa'a na' zjanaque' biše' ḻježa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ḻe note'teze beṉe' chone' da' chna'laže' Dios, bena' nac beṉe' biša', beṉe' zana', ḻecze naque' xṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeto ža yoble gwzolao Jesúsen' chsed chlo'ede' cho'a nisdaon', na' besežagchgua beṉe' zan juisyw gan' chi'ena'. Na' da' besežagchgua beṉe' zan, benten byen gwyo'o Jesúsen' to ḻo' barcw dao' da' chda' ḻo nisdaon' cho'a yo bižen' na' gwchi'e ḻo'enṉa', na' yogo' beṉe' ca' gosenite' cho'a nisdaon' ga nac yo biž. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nach da' zan da' bsed blo'ede' ḻegaque' len jempl da' bi'e. Na' bzejni'ide' ḻegaque', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ḻe gwzenag da' nga: To beṉe' güen žin jeze' trigw. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na' šlac zeje' chose' trigon', late' biṉ c̱he trigw dan' chazen' jasechazen chanez nach be ca' žia x̱il be chaš ḻe'e yaba gosagwban'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yelaten' jasechazen ga nac ḻo yej, ga bibi yotec zoa, na' da' nga byob blan' ḻe bi jasechazen ga nac sitjw. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Perw cate' bla' gwbiža' na' bzeyen ḻen na' gwbižen, ḻe gague yo'otec loenṉa' sitjon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yelaten' jasechazen ga nac ḻo yag yeše', na' yag yešen' gosecha'on na' bosoḻoḻen' ḻen, na' bibi gosebian. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Perw na' yelaten' jasechazen ga nac yo šagüe'. Da' nga beselan' na' gosecha'on na' ḻeca güen gosebian, baḻen gosebian do šichoa güeje to ton, baḻen gayon, na' yebaḻen do to gayoa. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na' gože' ḻegaque': ―Le'e žia nagle da' chene, ḻe gwzenag xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Gwdena' cate' ba besyeya'ac beṉe' zan ca', beṉe' ca' zjanita' gaḻa'ze len ḻe' na' len beṉe' šižiṉw ca' zjanaque' ḻe' txen, goseṉabde' ḻe' bi zejen jempl dan' bi'en. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na' gože' ḻegaque': ―Nono ṉa' ṉeze can' nac yeḻa' gwnabia' c̱he Diosen', perw ba chone' cont le'e chejnilaže'lene' ṉezelen. Na' beṉe' bi chesaclaže' yesejnilaže' Diosen', choe'lengaca'ne' xtižen' len jempl. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chona' ca' cont yesele'ede' can' chonan' na' bitw yesacbe'ede' bi zejen, na' cont yesende' xtižan' na' bi yesejni'iden', na' ṉeca yesyetiṉjde', ṉeca yezi'xen Diosen' xtoḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nach gože' ḻegaque': ―¿Bi chejni'ile jempl nga? ¿Nacxe gac šejni'ile jempl yoble da' güe'lena' le'e? ");
INSERT INTO zpqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ben' ben goza' naque' ca ben' choe' xtiža' Diosa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na' baḻ beṉe' zjanaque' ca biṉ dan' beselažo' chanez, ḻe chosozenague' cate' chas chlalje xtiža' Diosen', na' ca cheyoža' ḻa' chžinte Satanásen' dan' chnabia' da' x̱igüe' ca' na' chebejen xtiža' Diosen' dan' ba yo'o yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yebaḻ beṉe' zjanaque' ca biṉ dan' beselažo' ga nac ḻo yej na' bi ben loen. Ḻegaque' chesyebede' chosozenague' xtiža' Diosen', ");
INSERT INTO zpqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","perw šložga chesezibi'e, na' cate' chesac bi da' mal c̱hegaque' o bichle chesone beṉe' ḻegaque' ṉec̱he da' chosozenague' xtiža' Diozen', ḻa' chesebejyic̱hjten'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na' yebaḻe' zjanaque' ca biṉ dan' besego'oṉen ga nac ḻo yag yeše'. Chosozenague' xtiža' Diosen', ");
INSERT INTO zpqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","na' šlac zjambane' chesyelaḻ chesyežejde', na' da' chesaclaže' yeseṉi'e chziye'en ḻegaque' na' chesezelaže' yogo'ze da' de yesata' c̱he'. Yogo' da' qui bi choen' latje yega'aṉ xtiža' Diosen' ḻo' yic̱hjlažda'ogüen' na' da'nan' bi chesejnilaže' ḻe' ca cheyaḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Perw na' nita' baḻ beṉe' chosozenague' xtiža' Diosa' na' chesejnilaže' ḻe' do yic̱hj do laže', beṉe' qui zjazaca'lebde' ca biṉ dan' beselažo' ḻo yo šagüe'. Baḻe' zjanaque' ca biṉ dan' gosebian šichoa güeje to ton, na' yebaḻe' ca da' ca' bexoen' gayon, o ca no da' ca' bexoen' to gayoa güeje to ton. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ḻecze gože' ḻegaque': ―Cate' chguaḻa'cho to yi' ¿gwdosa'chon to caj o gwzoachon xan cam? Bi choncho ca', san chguaḻa'cho yin' na' chzoachon sibe cont gwseṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na' da' ngaše' c̱hia' neda' ṉa'a, ḻenṉa' gwlo'elaon, na' da' nono ṉa' ṉeze c̱hia', žin ža yeseṉezden'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Le'e žia nagle da' chene, ḻe gwzenag xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ḻecze gože' ḻegaque': ―Ḻe gwzenag da' quingan' da' chzejni'ida' le'e. Ḻe con can' chonḻe len ḻen, can' gon Diosen' len le'e. Na' gonchcze' cont soachle mbalaz da' chzenagle c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ḻe še chzenagle xtižen' gwzejni'ichde' le'e, perw na' še bi chzenaglen, da' daon' ba ṉezele yeyanḻaže'len. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ḻecze gwna Jesúsen': ―Yeḻa' gwnabia' c̱he Diosen' zaca'leben ca dan' chac cate' to beṉe' chaze' bite'teze biṉ ḻo yo. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chjaytase' na' chebane' cheyase', chde ža yel, na' chla' dan' gozen' na' chcha'on, perw ḻe' bi ṉezde' naquen' chac. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ḻe to gualazze yežlio nan' chonen ḻen, zgua'tec chla' ḻbe'edagüen', nach chlan' dao, na' cheyoža' chbian da' cheyaḻa' cuian. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na' cate' ba goḻ dan' chbianṉa' na' chja'aque' chjasyexi'en, ḻe ba bžin cho'a gwlap. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nach ḻecze gwna Jesúsen': ―Gonchcho xbab bi ca da' zaca'lebe yeḻa' gwnabia' c̱he Diosen' na' güe'cha' jempl cont ṉezele šanch beṉe' yosozenag c̱he' cont ṉabi'e yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naquen ca to biṉ c̱he xomdas da' chyaž ḻo yo. Ḻen chnabia' nac da' dao' len biṉ ca' chazcho ḻo yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Perw cate' bac̱h nyažen, chcha'on na' chaquen da' xench lao yix̱e' cuan ca', na' da' xenchgua chac xol c̱he xozenṉa', na' lente byiṉ dao' ca' chesyezi'laže'ba' ḻo xozenṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Can' blo'e Jesúsen' xtiža' Diosen' yogo' ṉi'a, bi'e zan jempl ca c̱he ben' goza' na' c̱he biṉ ca', con ga zelao goc gosejni'ide'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bitwbi bzejni'ide' ḻegaque' sin ca be'e jempl, nach cate' bich nita' beṉe' zan ca', bzejni'ide' beṉe' ca' zjanaque' ḻe' txen bi zejen yogo' da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ḻeze ḻo žana' cate' gwx̱in, Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻe šo'o ḻaga'cho yešḻa'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nach bosyocua'aṉe' yezica'chle beṉe' ca' že' gan' ba bsed blo'ede' na' gosa'aque' ḻo' barcw daon' gan' ba yo'ocze Jesúsen'. Na' yebaḻ beṉe' ḻecze ja'aclene' ḻegaque' len yeto c̱hop barcw dao'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na' gwzolao gwyec̱hjchgua to be' bdono' na' nisdaon' ḻeze chas chatan', na' gwzolao cheyož nis ḻo' barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsen' ba chtase' xante barcon' to ḻo xcogue' caten' goc ca'. Na' bosyosbane' ḻe' gose'ene': ―¡Maestro! ¿Bibi de chza'lažon' še ba gwdebe nisdaon' chio'? ");
INSERT INTO zpqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nach gwyas Jesúsen' na' gwdiḻe' be' bdonon' na' gože' nisdaon': ―¡Šižize! ¡Šižize! Na' bebe'ži be' bdonon' na' beyata'ži nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nach Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―¿Bixc̱hen' chžebtecle? ¿Nacxec̱hen' bi chejḻe'le c̱hia'? ");
INSERT INTO zpqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ḻegaque' besežebchgüe' na' gose' ḻježe': ―¿Noxe benga? lente be' bdono' na' len nisdaon' chosozenaguen c̱he da' že'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Besežine' šḻa'a nisdaon' gan' mbane Gadara, ");
INSERT INTO zpqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","na' cate' bechoj Jesúsen' ḻo' barcon' to beṉe' yo'o nyaz da' x̱igüen' bchoje' ḻo' capsantw na' jašague' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bena' ba zoacze' capsantw na'le na' nono chzoe gox̱e' ḻe', ṉe len gden ca gosezoede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Da' zan ṉi'a bosoc̱heje' ṉi'a ne'e gden, perw bia'cze gwc̱hoguen', con bzoxj btinen', na' nono gwzoe ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yogo' ža yogo' yel gwde' bosya'adie' do ḻo ya'a na' do ladjo ba ca' na' tža tža chone' zi' cuine' len yej. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na' cate' ble'ede' Jesúsen' zito' gwyejsese' jazoa xibe' lagüen', ");
INSERT INTO zpqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na' da' x̱igüen' benen cont bosya'adie' gože' ḻe': ―¿Bixc̱hen' chgoša' chlaže' c̱hio' len neda', Jesús? Naco' dogualje Xi'iṉ Dios beṉe' nape ḻa'zelagüe yeḻa' chnabia' xen. Ṉec̱he Dios chṉeyoeda' le' bi gwsaco' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Da' x̱igüen' benen cont gwna ben' ca' dan' gož Jesúsen' ḻen: ―Da' x̱igüe', bsan benga. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na' gwṉabe Jesúsen' ḻen: ―¿Bi lio'? Na' boži'in xtižen': ―Legión lia', ḻe nac zanto'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na' goseṉeyoen Jesúsa' bi yeseḻen' zito' cate' yesyežašen' yic̱hjlaždao' ben'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na' gaḻa'ze ḻo ya'ana' chesaš zan coš chesagwba'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nach da' x̱igüen' goseṉeyoen ḻe': ―Gwseḻa' neto' gan' nita' coš ca' na' beṉ latje šjayo'oto' ḻo' yic̱hjlažda'oban'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nach Jesúsen' bnežjue' latje, na' besyechoj da' x̱igüen' ḻo' yic̱hjlaždao' bena' na' jasyeyo'on yic̱hjlaždao' coš ca'. Nac ca do c̱hop mil cošen'. Na' besyeyetjses coš ca' ḻe'e ya'a gan' nita'ban' na' jaselažo'ba' ḻo' nisdao' ga gosatba' gose'ejba' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nach beṉe' ca' chosoyoe' cošen' bosyoxoṉje' jasyeyeže' beṉe' lagüe yež len beṉe' chaš yix̱e' can' goca'. Na' ja'ac beṉe' jaseṉe'e bixen' goc. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cate' besežine' gan' zoa Jesúsen' besele'ede' ben' ba gwyo'o gwyaz da' x̱igüen', na' ṉa'a ba chi'e nyaz xaḻane' na' ba bezoa yic̱hjlažda'ogüen' binḻo. Na' besežebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na' beṉe' ca' besele'ede' can' goquen' goso'e diža' c̱he dan' goc len ben' gwyo'o gwyaz da' x̱igüen', ḻez ca' dan' goc len coš ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nach gosezolagüe' gosata'yoede' Jesúsen' yeze'e lažgaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na' cate' beyo'o Jesúsen' ḻo' barcon' ben' ba gwyo'o gwyaz da' x̱igüen' gota'yoede' Jesúsen' šejlene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Perw Jesúsen' bi be'e latje, san gože' ḻe': ―Beyej ližo' na' jayež beṉe' ḻo' yo'o c̱hio' na' no beṉe' migw c̱hio' yogo' da' güen da' ba ben X̱ancho Diosen' len le' na' catec ba beyaše' beži'ilaže'de' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na' beza' ben' na' gwzolagüe' cho'e diža' yež ca' gan' mbane distritw Decápolis yogo' can' ben Jesúsen' len ḻe', na' yogo' beṉe' gosene xtižen' besyebande'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cate' bežin Jesúsen' cho'a nisdaon' zeze'e ḻo' barcw daon' dan' zeza' šḻa'a nisdaon', beṉe' zan ja'aque' gan' bežinen', na' Jesúsen' bega'aṉe' cho'a nisdao' na'ze. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nach bžin to ben' nac beṉe' gwnabia' c̱he yodao' c̱he yežna', lie' Jairo. Cate' ble'ede' Jesúsen' bzoa xibe' lagüen' ");
INSERT INTO zpqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na' gota'yoechgüede'ne' gože'ne': ―Xi'iṉa' no'ole ba chatbe'. Benšca goclen yo'o x̱oa taco' yic̱hjbe' cont yeyaquebe' na' bi gatbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nach Jesúsen' gwyejlene' ḻe'. Na' beṉe' zan ja'acch, na' bosoc̱hichgüe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ladjo beṉe' ca' len to no'ol che'ede', ba goc šižiṉw iz chzoe' gwbao'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ba bžaglaochgüe' jen cuine' rmed len zan beṉe' güen rmed ca', na' ba benditje' yogo' xmechue' da' de, perw bitwbi gwx̱i'czen, san chyaḻa'len. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cate' bende' cheso'e xtiža' Jesúsen', no'olna' gwdie' ladjo beṉe' ca' na' bžine' cože'le Jesúsen' na' gwdane' xen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ḻe bene' xbab, gwne': “Con še ba gwdana' xen' nach yeyactecza'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na' da' ḻi cate' gwdane' xen' ḻa' gwlezte gwbao' dan' zoen', na' no'olen' gocbe'ede' ba bega'a yižgüe' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na' Jesúsen' ḻa' gocbe'etede' to beṉe' ba beyacde' len yeḻa' guac c̱hen', nach gwyec̱hje' gwṉe'e beṉe' ca' nita' cože'le, na' gwṉabde' ḻegaque': ―¿Non' gwdan xan'? ");
INSERT INTO zpqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nach beṉe' ca' zjanaque' Jesúsen' txen gose'ene': ―Ba ble'eczedo' ca chosoc̱hie' le', ¿bixc̱hen' chṉabo' non' gwdan xaon'? ");
INSERT INTO zpqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Perw Jesúsen' chṉe'e nile na'le cont le'ede' non' gwdan xen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nach no'olen' ṉezde' can' ba goc c̱he' na' do chaž chžebe' gwyeje' jazoa xibe' lagüen' na' gože'ne' yogo' da' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na' Jesúsen' gože'ne': ―Xi'iṉa', ba beyacdo' dan' chejnilažo' neda'. Beyej binḻo, na' bich bi gacdo' len yižgüe' c̱hion'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ṉe' choe'te Jesúsen' dižan' ca' cate' besežin beṉe' gosa'ac liž x̱an yodaon', na' gosi'e x̱a bi' no'ol daon': ―Ba got bi' c̱hion', ¿bixc̱hen' choncho' zed Maestro nga? ");
INSERT INTO zpqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Perw Jesúsen' bi bene' cuent dan' chesena beṉe' ca', na' gože' x̱an yodaon': ―Bitw žebo', con gwyejḻe' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na' bi bi'e latje šja'aclen beṉe' zan ḻe' gan' xoa bi' no'olen', san Pedro, Jacobo na' Juan beṉe' biše' Jacobo, beṉe' ca'ze ja'aclen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na' cate' besežine' liž x̱an yodaon', ble'ede' ba chi' žaš chesosye'e chesebeže'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nach gwyo'e na' gože' ḻegaque': ―¿Bixc̱hen' mbecle žaš chbežle? Bi no'ol daon' biṉa' gatbe', san chtasben'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Perw bosoxiže' gosonḻe' c̱he'. Nach Jesúsen' bešaše' yogo'ḻoḻe', na' gwc̱he'e x̱axṉa'be' na' beṉe' ca' zja'aclen ḻe' na'ze na' goso'e len ḻe' gan' de bi' no'ol daon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na' bex̱ue' taca'ben' na' gože'be': ―Talita, cumi ―zeje diža': Bi' no'ole, chapa' le' beban na' beyas. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nach bi' no'ol daon' ḻa' beyastebe' na' goc beza'be', ḻe šižiṉw izegueben'. Na' beṉe' ca' besele'e ḻeca besyežejde' can' goca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Perw Jesúsen' gože' ḻegaque' nono yese'e ca', na' gože' ḻegaque' yeso'e bi' no'ol daon' da' gagwbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na' beza' Jesúsen' na' bežine' laže', na' beṉe' ca' zjanaque' ḻe' txen ja'aclene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na' cate' bžin ža c̱he Dios, Jesúsen' gwzolagüe' bsed blo'ede' ḻo' yodaon'. Na' beṉe' zan beṉe' gosende' xtižen' besyebande' na' gosene': ―¿Nacxe chaquen' cho'e diža' ca'? ¿Bi yeḻa' sinan' ṉezde'? na' ¿nacxec̱hen' chac chone' yeḻa' guac ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Benga chonšagüe' yag na' naque' xi'iṉ María. Nombia'chwne' na' beṉe' biše' Jacobo, José, Judas na' Simón, na' ḻecze beṉe' zane' ca' nite' lažcho nga. Na' da' zjanombi'ene' nan' bi gosaclaže' yesejḻe'e c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nach Jesúsen' gože' ḻegaque': ―Yogo'ze beṉe' chesonxene' beṉe' choe' xtiža' Diosen', perw beṉe' gualaž c̱he', beṉe' biše' ḻježe' na' beṉe' ḻo' yo'o c̱he' bi chosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na' ṉe to yeḻa' guac ca goc gone' na', ḻete gwx̱oa taquen' yic̱hj to c̱hop beṉe' güe' na' beyone' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na' bebande' dan' bi gosejḻe' beṉe' c̱he'. Na' gwdechle gwda Jesúsen' bsed blo'ede' to to yež dao' ca' nita' gaḻa'ze. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na' goxe' beṉe' šižiṉw ca' na' gwseḻe' c̱hop güeje' to to yež, na' bnežjue'ne' yeḻa' gwnabia' cont goc besyebeje' da' x̱igüe' ḻo' yic̱hjlaždao' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na' cate' za' yesa'aque' gože' ḻegaque' bibi yesox̱e' chanez, ṉe bzod, ṉe yetextil, ṉe mechw, con yesox̱e' to xis da' yosoc̱hiše'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Na' yosoleje' yel perw bi yesoe' yeto xcamise'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na' ḻecze gože' ḻegaque': ―Cate' žinḻe to liž beṉe', na'ze yega'aṉle šlac zoale lagüe yeža', cate'ch yeza'le yeža' cana'ch yeza'le latja'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na' še zoa ga bi yosolebe' le'e ṉeca yosozenague' c̱hele, cate' yeza'le na' ḻe cuibe ṉi'alen' yo bište cont nacbia' malen' chesone' bi chosozenague' xtiža' Diosen'. Da' ḻi žia' le'e cate' žin ža gac juisyw beṉe' ca' bi yosolebe' le'e yesacche' castigw clel ca beṉe' Sodoma na' beṉe' Gomorra. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nach gosa'aque', na' goseyix̱jue'ede' cheyaḻa' yesyetiṉje xtoḻa' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ḻeze besyebeje' da' x̱igüe' da' yo'o nyaz beṉe', na' zan beṉe' güe' goseyebe'ne' set na' besyeyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na' ca nac rey Herodes, gwṉezde' can' chesone', ḻe yogo'ze beṉe' gosende' can' ben Jesúsen'. Na' Herodesen' gwne': ―Juan ben' bzoe' beṉe' nisen' ba beban ladjo beṉe' guat ca'. Da'nan' chaque' chone' yeḻa' guac. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yebaḻe beṉe' gosene': ―Naque' ben' be' xtiža' Diosen' cani', ben' le Elías. Na' yebaḻe' gosene': ―Naque' con to beṉe' choe' xtiža' Dios ca beṉe' ca' gosoe' xtiža' Diosen' cani'te. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cate' Herodesen' bende' dižan' nac ca' na' gwne': ―Bengan' Juan ben' gwc̱hogbi'an gosec̱hogue' yene', na' ṉa'a ba bebane' ladjo beṉe' guaten'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ḻe Herodesen' beque'e Herodías na' gwzoalene' ḻe' goque' xo'ole' ḻa'czḻa' Herodíasna' naque' xo'ole Felipe biše'na'. Na' Juanṉa' gože' Herodesen': ―Bi cheyaḻa' soalen no'ol c̱he beṉe' bišon'. Da'nan' Herodesen' gwc̱hogbi'en gosezene' Juanṉa' na' bosoc̱heje'ne' len gden ḻo' yo'o ḻižya gan' gosegüe'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Can' goc Herodíasna' bgue'ede' Juanṉa' na' goclaže' gote'ne', perw bi goc. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ḻe Herodesen' gwṉezde' Juanṉa' naque' to beṉe' chon da' zej to ḻicha na' to beṉe' yo'o ḻo na' Dios, nachen' Herodesen' bžebe' Juanṉa' na' bi be'e latje bi gone Herodíasen' ḻe'. Na' ḻa'czḻa' bi gwyejni'iteque Herodesen' dan' bšalj Juanṉa', con bebede' bzenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Perw Herodíasen' beyiljwlaže' nac bene' cate' ben Herodesen' ḻṉi goḻa' ža le', bsiṉi'e xše' da' gwdagüe' len beṉe' gwnabia' c̱he' ca' na' no x̱an soldadw ca' na' nochle beṉe' blao že' distritw Galilean'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bi' no'ol c̱he Herodíasen' gwyo'obe' bya'abe' gan' gosagüe' xšen' na' beca'a Herodesen' can' bya'aben', ḻez ca' ben' gosagw len ḻe' xšen'. Na' reyna' gože' bi' no'ola': ―Gwṉabe neda' con da' žan c̱hio' na' goṉan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na' ḻecze gože'be': ―Diosen' naque' testigw c̱hia' goṉa' le' con da' ṉabdo'nda', ḻa' gašjo yež ca' gan' mbanda' chnabi'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na' bechojbe' na' gožbe' xṉa'ben': ―¿Bi ṉabda'ne'? Na' ḻe' gože'be': ―Gwṉab yic̱hj Juan ben' chzoe' beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na' ḻa' beyo'otebe' gan' chi' reyna' na' gožbe'ne': ―Che'nda' ṉetecṉa'a goṉo' neda' to ḻo' platw yic̱hj Juan ben' chzoa beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na' ṉe late'ze bi gwyazlaže' reyna' gone' can' gož no'ol güegon' ḻe', perw bac̱hle gwne' lao beṉe' ca' jasa'ac ḻṉin' Diosen' naque' testigw c̱he' gwnežjue'be' bite'teze ṉabebe' ḻe', da'nan' bi bžone' gac dan' gwṉabebe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nach ḻa' gwseḻa'te reyna' to soldadw na' gože'ne' šjax̱i'e yic̱hj Juanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Na' gwyej soldadon' ḻo' yo'o ḻižyan' na' jac̱hogue' yen Juanṉa', na' bžie' yic̱hje' to ḻo platw jasanen' bnežjuen' bi' no'ola', na' bi' nga bnežjwben' xṉa'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cate' goseṉeze beṉe' ca' zjanaque' txen len Juanṉa', jasexi'e cuerp c̱hen' cont bosocuaše'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Beyoža' postlw ca' besyežague' len Jesúsen' na' gose'ene' bica' da' ba gosone' na' da' ba bosolo'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na' Jesúsen' gože'ne': ―Ḻe da, ḻe šo'o ga nac lchojiže' yezi'laže'cho late'. Gwne' ca' ḻe chep chetj chac beṉe', ṉeca chac latje yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nach Jesúsen' len postlw c̱he' ca' gosa'aque' ja'aque' ḻegacze' to ḻo' barcw, ja'aque' ga nac lchojiže'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Perw zan beṉe' besele'ede' gosa'aque' na' besyeyombi'e Jesúsen', na' zan yež beṉe' ca' bosoxoṉjsese' na' byobch besežine' ca Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na' cate' Jesúsen' bchoje' ḻo' barcon' ble'ede' ba besežag beṉe' zan na' beyaše' beži'ilaže'de' ḻegaque', ḻe nite' ca nita' no xila' be nono de gwyoeba'. Nach gwzolaogüe' bsed blo'ede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cate' ba zoa x̱in, beṉe' ca' zjanaque' ḻe' txen gose'ene': ―Ba zoa x̱in, na' latj gan' zoacho nga naquen latj daš. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Na' beseḻa' beṉe' quinga cont šja'aque' ga že' beṉe' do ranšw na' do yež dao' ca' dan' nyec̱hj mbi'i šjasexi'e da' yesagüe', ḻe bibi de yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na' Jesúsen' gože'ne': ―Le'e ḻe güe'e da' yesagüe'. Na' ḻegaque' gose'ene': ―Bi de laxjwto' c̱he c̱hop gayoa ža žin cont šjax̱i'to' da' güe'to' ḻegaque' yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesúsen' gože'ne': ―¿Gaca' yetextilen' de c̱hele? Ḻe šja'ac ḻe šjaṉa'. Cate' goseṉezde' na' gose'ene': ―De gayo' yetextil na' yec̱hop beḻ ya'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nach gože' beṉe' ca' yesebi'e to x̱oṉj güeje' ḻo yixyen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na' gosebe' to gayoa güeje' na' yebaḻe' šiyon güeje'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nach Jesúsen' gwxi'e yetextil ca' gayo' na' beḻ ya'an c̱hope, na' gwṉe'e ḻe'e yaba bi'e yeḻa' chox̱clen c̱he Dios na' bzoxje' yetextilen' bi'en beṉe' ca' zjanaque' ḻe' txen cont goseyisen' len beṉe' ca'. Ḻeze gwdise' beḻ ya'a ca' c̱hop lao yogo'ḻoḻ beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na' yogüe' gosagüen' na' goseljde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Beyoža' bososše'e yešižiṉw žome yetextil bixjw na' len late' güeje beḻ da' bega'aṉ. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na' beṉe' ca' gosagw yetextilen' gosaque' gayo' mil beṉe' byo, bi cuent no'ol ca' len bidao'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gwdena' Jesúsen' bene' byen besyeyo'o beṉe' ca' zjanaque' ḻe' txen ḻo' barcon' cont yesyeḻaga'zegue' nisdaon' na' yesežine' Betsaida, šlac ḻe' za' cheseḻe' beṉe' ca' žena' ližgaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na' cate' beyož bzede' beṉe' ca' diža', gwyeje' ḻo ya'an boḻ güiže' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na' ca nac barcon', cate' goc c̱hoḻ ba zejen gachoḻ nisdaon', na' toze Jesúsen' ṉe' zie' ga nac yo biž. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na' ble'ede' bi chac yosyose'en binḻo, ḻe ben' chec̱hjen clele na' bi choen' latje sa' barcon'. Na' šbaḻ beyetj Jesúsen' ya'ana' na' gwze'e ḻo nisen' ba zej gaḻe' gan' zja'aquen', na' ba zoa teze' gan' zjaya'aquen' ");
INSERT INTO zpqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","cate' besele'ede' ḻe' chze'e ḻo nisen'. Na' gosacde' še da' chda chelen'. Na' bososye'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ḻe yogüe' besele'ede'ne' na' besežebe'. Perw ḻe' ḻa' boḻ güižte' ḻegaque', gože'ne': ―Ḻe gonc̱hac̱h laže'le; nedan', bitw žeble. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nach gwyo'e ḻo' barcw gan' zjaya'ac beṉe' ca', nach gwche'ži ben'. Na' ḻegaque' ḻeca besyebande' na' besyežejde', ");
INSERT INTO zpqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ḻe bi gosejni'ide' dan' bene' yeḻa' guac len yetextil ca', na' biṉa' yesejnilaže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na' goseḻague' nisdaon' na' besežine' yežlio gan' nzi' Genesaret, na' bosoc̱heje' barcon' cho'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na' cate' beyož besyechoje' ḻo' barcon' beṉe' ca' ḻa' besyeyombia'te' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na' ja'acsese' doxen gan' mbane Genesaret, na' do ḻo cam dao' zjanx̱oe' beṉe' güe' ca' jasesane'ne' gan' zjaṉezde' zoa Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na' gate'teze gwyej Jesúsen', do yix̱e', do yež, con goseyix̱jue' beṉe' güe' ca' do chanez na' goseṉeyoede' Jesúsen' gwnežjue' latje yesox̱e' ḻa'ch late'ze x̱ni'a xen', na' yogo' beṉe' gosox̱en' besyeyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nach beṉe' fariseo ca' na' len beṉe' ca' bososed bosolo'e dan' bzoj da' Moisés gosa'aque' Jerusalénṉa' na' ja'aque' gan' zoa Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na' besele'ede' baḻ beṉe' ca' zjanaque' Jesúsen' txen con gosagüe' ṉeca bosyone'e zan ṉi'a can' chesacde' cheyaḻa' yesone', na' da'nan' gosezi'diže' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ḻe beṉe' fariseo ca' na' yogo' beṉe' Israel gualaž c̱heto' ca' chesonxene' costumbr ca' da' bosyocua'aṉlen da' x̱ozxta'oto' ca' neto' bi yesagüe' še biṉa' yosyone'e zan ṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na' cate' yesyežine' lagüe ya'a, bi yesagüe' še biṉa' yosyone'e, na' da' zanch costumbr da' zjana'ogüe', ca no yeseyibe' xiga' ga chese'eje' nis, no yeso' xguague, no yeso' ya na' no xcame'.) ");
INSERT INTO zpqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nach beṉe' fariseo ca' na' beṉe' ca' bososed bosolo'ede' dan' bzoj da' Moisésen' goseṉabde' ḻe': ―¿Bixc̱hen' bi cheson beṉe' ca' zjanaque' le' txen can' goson beṉe' gol ca'? san con chesagüe' sin cbi chosyone'e zan ṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesúsen' gože' ḻegaque': ―Chonḻe cayaṉen' bzoj da' Isaíasen' c̱he le'e nacle beṉe' gwxiye' gan' bzoje', žan': Beṉe' qui chesonxene' neda' len diža' cho'a, perw bi chesonxene' neda' len lažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bibi zejen dan' chesonxene' neda', ḻe dan' chososed chosolo'eden' naquen da' chnalaže' beṉac̱hze. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bi chonḻe ca chnalaže' Dios, san na'ole can' ža beṉac̱hen' cheyaḻa' gonḻe, chyible no yeso' xguague, no xiga' ga che'ejle nis, na' da' zanch da' chonḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Qui gožch Jesúsen' ḻegaque': ―Chbejyic̱hjle da' non Diosen' mandadw gonḻe cont na'ole costumbr c̱he beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Da' Moisésen' gwne': “Ḻe gap bala'aṉ x̱axṉa'le”, na' “Note'teze' še chžia chnite' x̱axṉe'e, cheyaḻa' gate'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Perw le'e žale to beṉe' guac ye'e x̱axṉe'e: “Bibi de goṉa' gaclena' le'e, ḻe yogo' da' de c̱hia' naquen Corbán” (zeje diža', ba bnežjuen' ḻo na' Dios). ");
INSERT INTO zpqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na' žale cate' to beṉe' že' ba naquen ḻo na' Diosen' nach bich cheyaḻa' gaclen x̱axṉe'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dan' žale ca' chzoale ca'ale dan' ža Diosen' na' con chonxenḻe costumbr gole c̱he da' x̱ozxta'ole ca'. Na' da' zanch dan' nac ca' chonḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Da' yoble gox Jesúsen' beṉe' ca', na' gože' ḻegaque': ―Yogo'le ḻe gwzenag c̱hia', na' ḻe šejni'i. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bite'teze da' ye'ej gagw beṉac̱hen', bi ṉacho ḻen chonen cont lažda'ogüe' bi naquen xilaže' len Diosen'. Dan' chchoj ḻo' lažda'ogüen', ḻenṉa' chonen cont lažda'ogüe' bi naquen xilaže' len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Le'e žia nagle da' chene, ḻe gwzenag xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Cate' bsan Jesúsen' bich bšaljlene' beṉe' ca' na' beyo'e ḻo' yo'o, nach beṉe' ca' zjanaque' ḻe' txen goseṉabde' ḻe' bi zejen dan' gože' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na' Jesúsen' gože' ḻegaque': ―¿Ḻecze len le'e bi chejni'ile? ¿Bi chejni'ile gague da' ye'ej gagw beṉac̱hen' chonen cont lažda'ogüe' bi naquen xilaže' len Diosen'? ");
INSERT INTO zpqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ḻe da' che'ej chagw beṉac̱hen' gague cho'on ḻo' lažda'ogüen', san ḻo' ḻi'en cho'on, na' chžin hor cheden. Na' da' gwne' ca' zeje diža' bite'teze yeḻa' guagw nacczen xilaže'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na' ḻecze gwne': ―Xbab da' yo'o ḻo' yic̱hjlaždao' beṉac̱hen', ḻenṉa' chonen cont lažda'ogaque' bi zjanaquen xilaže' len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ḻe ḻo' yic̱hjlaždao' beṉac̱hen' chchoj xbab mal ca da' žan yesone' da' quinga: yesata'lene' no'ole bi nac xo'olgaque' o beṉe' byo bi nac beṉe' c̱hegaque', gwzoa xtogaque', yesote' beṉe', ");
INSERT INTO zpqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yesone' gwban, yesezelaže' gata' c̱hegaque' da' de c̱he beṉe' yoble, yesone' da' mal, yeseziye'e beṉe', yesone' bichle da' nac da' yeḻa' zto', yesacxi'ede' beṉe', yeseṉeye'e c̱he beṉe', yesaque' beṉe' ya'laže', yesone' xbab da' bi zaca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yogo' da' mal qui chesechojen ḻo' laždao' beṉac̱h na' chonen cont bi nac lažda'ogaque' xilaže' len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na' beza' Jesúsen' na' gwyeje' distritw gan' mbane ciuda Tiro na' ciuda Sidón. Na' gwyo'e to ḻo' yo'o na' goclaže' nono ṉeze, perw bi goc gone' cont bi goseṉezde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cate ḻa' gwṉezete xṉa' to bi' no'ole bi' yo'o nyazbe' da' x̱igüen', na' gwyeje' na' bzoa xibe' xṉi'a Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","No'olen' goque' beṉe' zito', no'ole Sirofenicia. Gwyeje' gwṉabde' Jesúsen' yebeje' da' x̱igüe' yo'o nyaz bi' no'ol c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na' Jesúsen' gože'ne': ―Yogo'ze beṉe' zgua'tec chnežjue' da' chagw xi'iṉe'. Bi naquen güen yeque'e yeḻa' guagw c̱he xi'iṉe' na' gwnežjuen' yesagw beco' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na' no'olen' gože'ne': ―Leczedo' can' gwnaon' X̱ana', perw ḻecze guaque gagw beco' be chi' xan mes bla'a da' chlažo' ḻo yo. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nach Jesúsen' gože'ne': ―Nacczen can' gwnaon', guac yeyejo', ba bechoj da' x̱igüen' yo'o nyaz bi' no'ol c̱hion'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cate' bežin ližen' ble'ede' de bi' no'ol daon' to ḻo cam, na' ba bechoj da' x̱igüen' yo'o nyazbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesúsen' bezse'e gan' mbane Tiro na' gwdie' gan' nzi' Sidón na' yež ca' gan' mbane Decápolis, na' bežine' cho'a nisdao' c̱he Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na' jasesane' to beṉe' byo beṉe' cuež na' bi goc ṉie', na' goseṉabe' x̱oa na' Jesúsen' yic̱hje'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nach Jesúsen' gwc̱he'ene' late' lchojiže' ga nono beṉe' nita', na' bde xbene' ḻo' nague' na' bži'en x̱ene' na' gwdane' ḻožen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nach gwṉe'e ḻe'e yaba, bebande', na' gwne': ―¡Efata! ―zeje diža': ¡Byaljo! ");
INSERT INTO zpqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nach nag bena' besyeyaljon na' goc bende', na' ḻecze beyac ḻožen' na' goc gwṉie' binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na' Jesúsen' gože' beṉe' ca' nono yese'e ca', perw ḻa'czḻa' gože' ḻegaque' ca', nachle goso'e diža' can' goca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na' ḻeca besyebande', na' gosene': ―Yogon' chone' binḻo; chacte chone' cont chesyeyene beṉe' cuež ca' na' beṉe' ca' bi chac yeseṉe' chesyeṉie'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ca tiempa' besežagchgua beṉe' zan na' bibi de yesagüe'. Nach Jesúsen' goxe' beṉe' ca' gwleje' cont zjanaque' txen len ḻe' na' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Cheyaše'da' beṉe' qui, ḻe ba goc šoṉe ža zjanite' nga len neda' na' bibi de yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Še yeseḻa'ne' ližgaque' na' biṉa' yesagüe', chanez yesego'oṉe' yesec̱hoḻde', ḻe baḻe' za'aque' zito'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nach beṉe' ca' zjanaque' ḻe' txen gose'ene': ―¿Nacxe goncho güe'chone' da' yesagüe' latje nga ga nono beṉe' nita'? ");
INSERT INTO zpqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na' Jesúsen' gwṉabde' ḻegaque': ―¿Gaca' yetextilen' de c̱hele? Na' ḻegaque' gose'ene': ―Gažen. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nach bene' mandadw yesebe' yogo'ḻoḻ ben' nitan' ḻo yo, na' gwxi'e da' gaž yetextil ca' na' be'e yeḻa' chox̱clen c̱he Dios, nach bzoxjen' bnežjuen' beṉe' ca' zjanaque' ḻe' txen na' ḻegaque' goseyisen' c̱he yogo'ḻoḻ beṉe' nita' na'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ḻeze zjano'e to c̱hop beḻ ya'a, na' Jesúsen' be'e yeḻa' chox̱clen c̱he Diosen' c̱he beḻ ya'a ca' na' ḻeze goseyisen' c̱he yogo'ḻoḻ beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na' yogüe' gosagüe' na' goseljde'. Gwdena' bososše'e yegaže žome len late' güeje yeḻa' guagw da' bega'aṉ. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Beṉe' ca' gosagon' zjanaque' ca do tap mil beṉe'. Cate' ba besyedagüe', Jesúsen' gože' ḻegaque': ―“Nayežagcho”, ");
INSERT INTO zpqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na' gwyo'e ḻo' barcon' len beṉe' ca' zjanaque' ḻe' txen na' gwyeje' do gan' mbane yež da' nzi' Dalmanuta. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na' beṉe' fariseo ca' gosezolagüe' chesediḻdiže' len Jesúsen'. Na' da' gosaclaže' yesagüe' xya c̱he' nach goseṉabde'ne' gone' to yeḻa' guac da' yesele'ede' ḻe'e yaba cont yeseṉezde' še da' ḻicze Diosa' gwseḻe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesúsen' bebanchgüede' na' gwne': ―Ba ble'ele chona' yeḻa' guac. ¿Bixc̱hen' chṉable to yeḻa' guac da' le'ele cont ṉezele še Diosen' gwseḻe' neda'? Da' ḻi žia' le'e, bitwbi gona' da' le'ele. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nach bcua'aṉe' ḻegaque' na' beyo'e ḻo' barcon' beze'e beyeje' yešḻa'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Beṉe' ca' zjanaque' Jesúsen' txen gosanḻaže' yeso'e da' yesagüe', na' totec yetextil zjano'e ḻo' barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na' Jesúsen' gože' ḻegaque': ―Ḻe gon xbab, ḻe gwsaca' len levadura c̱he beṉe' fariseo ca' na' len levadura c̱he Herodes. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nach goseṉabe ḻježe' bixc̱hen' gwne' ca', na' gose' ḻježe': ―Gwne' ca' ḻe gague bi yetextil c̱hecho den'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesúsen' gocbe'ede' xbab dan' chesone' na' gože'ne': ―¿Bixc̱hen' chacžejlaže'le da' bibi yetextil de? ¿Biṉa' šejni'ile, ṉeca chacbe'ele? ¿Nac c̱hac̱h lažda'olen' bi chejḻe'le? ");
INSERT INTO zpqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Bi chle'ele len yejlaole, ṉeca chenele len nagle? ¿Bi chjayze'ele? ");
INSERT INTO zpqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gwdisa' gayo' yetextil na' goquen c̱he gayo' mil beṉe', na' ¿bi chjayze'ele yebaḻe žome goc da' becho'oṉen da' botoble? Na' ḻegaque' gosene': ―Šižiṉw žome becho'oṉen da' botobto'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―¿C̱hixe caten' gwdisa' gaže yetextilen' lao tap mil beṉe'? ¿Yebaḻe žome gwža'te dan' botoblen'? Na' gosene': ―Gaže žomen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nach gože' ḻegaque': ―¿Biṉa' šejni'iczele ṉa'a cho'a diža' c̱he dan' chososed chosolo'e beṉe' fariseo ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gwdechle besežine' Betsaida na' jasesane' to beṉe' lc̱hoḻ lao Jesúsen', na' gosata'yoede' ḻe' yeyone' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na' bex̱ue' taca' beṉe' lc̱hoḻa' na' gwleje'ne' yež. Nach gwdebe' x̱ene' yejlagüen' na' gwx̱oa taquen' yic̱hje' na' gwṉabde'ne' še chle'ede' late'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Beṉe' lc̱hoḻa' gwṉe'e na' gwne': ―Chle'eda' beṉe', na' chle'eda'ne' ca yag, perw chesa'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nach Jesúsen' bex̱oa taque' yejlagüen' da' yoble, na' gwṉa'yaṉe' ben' na' beyaque', bele'etede' yogo' binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nach Jesúsen' beseḻe' ḻe' liže', gože'ne': ―Bi yeyo'o lagüe yežen', ṉeca no yo'o da' nga. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Gwdena' gwyej Jesúsen' len beṉe' ca' zjanaque' ḻe' txen yež dao' ca' zjachi' do ga mbane ciuda da' nzi' Cesarea de Filipo. Na' chanez gwṉabde' beṉe' ca' zja'aclen ḻe': ―¿Bi chesena beṉe'? ¿Non' naca' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ḻegaque' gose'ene': ―Baḻe' chesene' naco' Juan ben' bzoa beṉe' nis, yebaḻe' chesene' naco' Elías, na' yebaḻe' chesene' naco' yeto beṉe' be' xtiža' Dios cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na' gwṉabde' ḻegaque': ―¿C̱hixe le'e? ¿no žale naca'? Pedron' gože' ḻe': ―Len' naco' Cristo ben' gwlej Diosen' cont ṉabi'o. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nach Jesúsen' gože' ḻegaque' nono yese'e ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na' gwzolao Jesúsen' bzejni'ide' ḻegaque' can' gac c̱hen', gože'ne': ―Da' zan da' saca'zi'a neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Na' beṉe' blao ca' chesenabia' nación c̱hechon' na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés bi yesele'ede' neda' güen da' bi chesejḻe'e c̱hia', na' yesote' neda', perw gacch šoṉe ža yebana' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Da' nga gwnen' zaca'laon. Na' Pedron' gwc̱he'e Jesúsen' ga nac lchojiže' na' gwzolagüe' chdiḻe' ḻe' dan' gwne' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Perw Jesúsen' gwyec̱hje' na' gwṉe'e beṉe' ca' zjanaque' ḻe' txen, na' gwdiḻe' Pedron', gože'ne': ―¡Gwcuase ca'ale Satanás! Bi nsa'o xbab c̱he Diosen' san nsa'o xbab c̱he beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nach Jesúsen' goxe' beṉe' ca' zjanaque' ḻe' txen na' yezica'chle beṉe' na' gože'ne': ―Note'teze beṉe' še chaclaže' gaque' neda' txen, cheyaḻa' chojyic̱hj cuine', ḻa'czḻa' saca'zi'e, na' gone' can' ṉia' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Note'teze beṉe' chacde' gone' cont bi saca'zi'e o cont nono yesot ḻe', benan' cuiayi', na' note'teze beṉe' chzanḻaže' cuine' saca'zi'e o gate' ṉe c̱hia' neda' o ṉec̱he xtiža' Diosen', ba de yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Bixe zejenṉa' to beṉe' ṉabi'e doxen yežlion' na' cuiaye'e bi gata' yeḻa' mban c̱he' toḻi tocaṉe? ");
INSERT INTO zpqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ḻe bi zoa nacle gon beṉac̱hen' c̱hixjue' cont gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Beṉe' ca' že' ṉa'a bi chesejnilaže' Diosen' na' chesonchgüe' da' xiṉj. Na' note'teze beṉe' še cheto'ede' par ye'e ḻježe' chejnilaže' neda', na' še cheto'ede' par gwzenague' xtižan', ḻecze ca' neda' yeto'eda' c̱he' par ṉia' naque' neda' txen, neda' naca' ben' gwseḻa' Dios golja' beṉac̱h. Yeto'eda' c̱he' cate' yida' da' yoble nsa'a yeḻa' zaca' juisyw c̱he X̱a' Diosen' na' nc̱hia' beṉe' ca' zjanac angl c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ḻecze gož Jesúsen' ḻegaque': ―Da' ḻi žia' le'e, baḻle nita'le nga ṉa'a biṉa' gatle cate' žin ža le'ele Diosen' gwlo'e yeḻa' guac xen c̱hen' can' chnabi'en'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gwde x̱op ža, Jesúsen' gwc̱he'e Pedro, Jacobo na' Juan na' ja'aque' to ḻo ya'a sibe, na' nono nochle ja'ac len ḻegaque'. Na' nite' besele'ede' bža' ca goc Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Xaḻane' goquen da' šiš xila', gocten ca da' chactite; ḻa' c̱hibcho lache' yežlio nga bi yechojen gaquen šiš xila' catequen' goc xaḻanen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na' concze besele'ede' da' Elías na' da' Moisés chosošalje' len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nach Pedron' gože' Jesúsen': ―Maestro, ¡ḻeca güenṉa' zoacho nga! Gonto' šoṉe ranšw, to c̱hio', to c̱he Moisés, na' yeto c̱he Elías. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ḻe beṉe' ca' zja'aclen Jesúsen' besežebchgüe', na' Pedroa' bi chacbe'ede' bin' že'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nach gwche' to bejw gan' niten' gwyec̱hjen ḻegaque', na' ḻo' bejon' gosende' gwna Diosen': ―Bengan' Xi'iṉa' beṉe' chacda'; ḻe gwzenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na' cate' goseṉe'e cue'ej cuiten' notno besele'ede', san toze Jesúsen' zie'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na' šlac chesyeyetje' ḻo ya'an, Jesúsen' gože' ḻegaque' notno yesi'e ca nac dan' besele'eden'. Gože'ne': ―Cate'ch ba bebana' ladjo beṉe' guat ca', nedan' naca' ben' gwseḻa' Dios golja' beṉac̱h, cana' güe'le diža' c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Da'nan' gosezoe' šize, nono gose'e ca', perw na' goseṉabe ḻježe' bi zejen dan' gwne' yebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nach gose'e Jesúsen': ―Beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés chososedde' neto' chesene' zgua'tec da' Elías ben' gwzoa cani' cheyaḻa' yide' da' yoble cate' za' yedeṉabia' ben' seḻa' Diosen'. ¿Bixc̱hen' chesene' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na' boži'e xtižen': ―Da' ḻiczen' zgua'tec Elíasna' yide' na' yeyo'e xṉeze yogo'ḻoḻ da' de yežlio nga. ¿Ṉezele bin' ža gan' nyoj Xtiža' Diosen' c̱hia' neda' naca' ben' gwseḻa' Dios golja' beṉac̱h? Žan saca'zi'a na' beṉe' zan bi yesejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na' žia' le'e, Elías ba bide' na' gosonde' ḻe' con ca gosaclaže', can' nyoj ḻe'e Xtiža' Diosen' žan can' cheyaḻa' gac c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gwdena' besyežine' gan' nita' yezica'chle beṉe' ca' zjanaque' Jesúsen' txen, na' besele'ede' beṉe' zan zjanita' zjanyec̱hjde' ḻegaque', na' len beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisés chesediḻdiže' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na' cate' beṉe' ca' besele'ede' Jesúsen', yogüe' besyežejde' na' ja'acsese' bosoguape' ḻe' tiox. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nach gwṉabde' ḻegaque': ―¿Bin' chdiḻdiža'le len beṉe' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na' to beṉe' nc̱hix̱e beṉe' ca' boži'e xtižen', gwne': ―Maestro, zedesana' bi' c̱hia' nga, yo'o nyazbe' da' x̱igüe' na' benen cont bi chac ṉebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gate'teze chdabe' chzenen ḻebe' na' chcho'oṉen ḻebe' ḻo yo, na' chbia bžina' cho'abe' na' chagwxej ḻaybe'. Na' ca' zej chedo fuerz c̱hebe'. Na' ba gwṉaba' lao beṉe' qui zjanaque' le' txen yesyebeje' da' x̱igüe' yo'o nyazbe', perw bitw gosaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na' Jesúsen' gože' beṉe' ca' že'na': ―¡Le'e beṉe' bi chejnilaže'! ¿Šna chyažjen soalena' le'e cont šejnilaže'le? ¿Batca' zelao ṉa'lagua' le'e? Ḻe yedesambe' nga. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na' jasesane'be', na' cate' da' x̱igüen' ble'en Jesúsen', benen gwyazbe' šon, na' gwbix̱be' ḻo yo, chbix̱ chtoḻbe' na' chbia bžina' cho'abe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nach Jesúsen' gwṉabde' x̱aben': ―¿Baḻ iz ba goc chacbe' ca'? Na' x̱aben' gwne': ―Cate' nacbe' bida'ote gwzolao chacbe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na' zan ṉi'a da' x̱igüen' chzaḻan' ḻebe' ḻo yi' na' ḻo nis cont goten ḻebe'. Da'nan' še guac yeyono'be', beyaše'šque neto' na' beyombe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesúsen' gože'ne': ―Cheyaḻa' šejnilažo' neda', ḻe yogo' da' chzelaže' beṉe' chesejnilaže' neda' chaquen. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nach x̱aben' gwne' zižje: ―¡Chejnilaža' le', goclen neda' šejnilaže'cha'! ");
INSERT INTO zpqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na' cate' Jesúsen' ble'ede' chesežagchgua beṉe', gwdiḻe' da' x̱igüen' gožen': ―Da' x̱igüe', le' chono' cont bi' nga bi chenebe' na' bi chac ṉebe', neda' žia' yechojo'. Bsan bi' nga, na' bich yeyo'o yic̱hjlažda'oben'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na' da' x̱igüen' benen ga bosya'abe' na' benen ga gwyazbe' ca yeto šon, nach bechojen. Na' bin' bega'aṉbe' ca bi' guat, na' zan beṉe' gosene' gotben'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Perw Jesúsen' bex̱ue' taca'ben' cont beyasbe', nach gwzechabe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nach cate' Jesúsen' gwyo'e to ḻo' yo'o, beṉe' ca' zjanaque' ḻe' txen gosebeje' ḻe' ca to lchojiže' na' goseṉabde' ḻe': ―¿Bixc̱hen' bi goc neto' yebejto' da' x̱igüen'? ");
INSERT INTO zpqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na' gože'ne': ―Cont yechoj da' x̱igüen' nac ca' cheyaḻa' gonḻe gwbas na' soatezle yoḻ güižle Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Cate' besyeya'aque' na', besyedie' distritw Galilea. Na' Jesúsen' goclaže' nono yeseṉeze, ");
INSERT INTO zpqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ḻe chzejni'ide' beṉe' ca' zjanaque' ḻe' txen, che'e ḻegaque': ―Nedan' naca' ben' gwseḻa' Dios golja' beṉac̱h, yosodie' neda' ḻo na' beṉe' yesote'nda', perw yeyoṉ ža yebana' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Perw bi gosejni'ide' bin' gože' ḻegaque', na' besežebe' yeseṉabde'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na' besežine' ciuda da' nzi' Capernaum, na' cate' besežine' yo'o gan' zoa Jesúsen' gwṉabde' ḻegaque': ―¿Bixc̱hen' chdiḻdiža'le chanez? ");
INSERT INTO zpqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Perw con gosenite' šižize, ḻe chanezan' gosediḻdiže' gosene' noen' nac beṉe' blaoch. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nach Jesúsen' gwchi'e na' goxe' beṉe' šižiṉw ca' zjanaque' ḻe' txen, na' gože' ḻegaque': ―Še no le'e chaclaže'le gacle beṉe' žialao, cheyaḻa' gonḻe xbab bibi zaca'tecle, na' cheyaḻa' gon cuinḻe ca xmos yogo' beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nach bex̱ue' to bidao' na' bzeche'be' gachoḻ ḻegaque', na' gwḻene'be' na' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Note'teze beṉe' chone' güen len to bidao' ca bi' nga ṉec̱he da' chejnilaže' neda', choncze' güen len neda'; na' noteze' chon güen len neda', choncze' güen len Dios ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nach Juanṉa' gože'ne': ―Maestro, bežagto' to beṉe' cho'e lao' na' chebeje' da' x̱igüe' da' yo'o nyaz beṉe', na' bžonto' gone' ca', ḻe bi chone' chio' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na' Jesúsen' gwne': ―Bi gwžonḻe gone' ca', ḻe gague zoa to beṉe' gone' yeḻa' guac cho'e lan', yeyoža' ṉe' yeḻa' ya' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ḻe beṉe' bi chone' chio' contr, txencza' chone' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chnia' le'e to da' zejen, note'teze beṉe' goṉe' le'e ḻa' to xiga'ze nis da' ye'ejle ṉec̱he chejnilaže' neda' na' ṉec̱he ṉezde' le'e nacle txen len neda', Diosen' gone' cont soacze' mbalaz da' ba goclene' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Note'teze beṉe' chon cont lažo' to beṉe' za' gwzolagüe' chejnilaže' neda' gone' da' xiṉj, yejṉi'acle yosoc̱heje' yene' to yiše xen na' yosozaḻe'ne' ḻo' nisdaon' clel ca da' gone' cont lažo' beṉe' yoble gone' da' xiṉjen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na' še yeṉa'len' chonen cont gonḻe da' xiṉj, cheyaḻa' cuejyic̱hjle da' malen' chonḻe. Yejṉi'a bibi na'le zoa clel ca gonḻe da' xiṉjen' len ḻen. Na' yejṉi'a šjayzoale len Diosen' toḻi tocaṉe bi zoa šḻa'a taca'le clel ca yeyejle ḻo yi' gabiḻ dan' bi cheyol chenit nya' cuerp c̱helen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Na' gabiḻen' ṉeca chesat bzogan', ṉeca cheyol yin'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na' še ṉi'alen' chonen ga gonḻe da' xiṉj, ḻecze cheyaḻa' cuejyic̱hjle da' malen' chonḻe. Yejṉi'a bibi ṉi'alen' zoa clel ca gonḻe da' xiṉjen' len ḻen. Na' yejṉi'a šjayzoale len Diosen' toḻi tocaṉe bi zoa šḻa'a ṉi'alen', clel ca yeyejle ḻo' yi' gabiḻ dan' bi' cheyol chenit nya' cuerp c̱helen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na' gabiḻen' bzoga' ca' bi chesatba', ṉeca cheyol yin'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na' še yejlaolen' chonen cont gonḻe da' xiṉj, cheyaḻa' cuejyic̱hle da' malen' chonḻen'. Yejṉi'a bibi yejlaolen' žia clel ca gonḻe da' xiṉjen' len ḻen. Na' yejṉi'a šjayzoale len Diosen' toḻi tocaṉe zoa šḻa'aze yejlaole clel ca yežinḻe ḻo yi' gabiḻen' žia chop ḻa'a yejlaolen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ca nac gabiḻen', bi chesat bzogan', ṉeca cheyol yin'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ḻe dan' chyi chzaca'le yežlio nga chzejni'in le'e cont bi yeyejle ḻo yi' gabiḻ. Na' da' chyi chzaca'le zaca'leben ca zede' da' cheyaḻa' c̱hix̱e' yezj yogo' ṉi'a cate' chjasesane' yezj lao Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na' zeden' naquen güen, perw še bich bi zxi' naquen, ¿nacxe goncho cont yeyaquen zxi' da' yoble? Na' le'e cheyaḻa' gwyo gwc̱hejlaže'le dan' chyi chzaca'le na' cheyaḻa' soale binḻo tole yetole, na' še soale ca', zaca'leble ca to yeḻa' guagw da' yo'o zede'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesúsen' beze'e Capernaum na' gwyejche' gan' mbane distritw Judean' na' yešḻa'a yegw Jordánṉa'. Na' da' yoble besežag beṉe' zan gan' zoen' na' ḻecze da' yoble bsed blo'ede' ḻegaque' con can' choncze'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nach baḻ beṉe' fariseo ca' ja'aque' gan' zoa Jesúsen' gosaclaže' yesebeje'ne' diža' da' yosoc̱hine' cont yosožie'ne' xya c̱hoḻ, na' goseṉabde'ne' še guac to beṉe' yele'e len no'ol c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na' Jesúsen' boži'e xtižen', gwne': ―Ca nac dan' bzoj da' Moisésen', ¿nac bene' mandadw gonḻe? ");
INSERT INTO zpqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ḻegaque' gosene': ―Moisésen' gwne' cate' to beṉe' yele'e len no'ol c̱hen' cheyaḻa' c̱has to yiš da' gwnežjue' no'ol c̱he' ga güe'en diža' besyele'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nach Jesúsen' gože' ḻegaque': ―Moisésen' gwne' gac gonḻe ca' lagüe dan' nacle beṉe' güedenag len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Perw cate' gwxe yežlion', cate' bx̱e Diosen' yogo' da' de, bi goquen ca'. Ḻe nyojen žan: “Bene' ḻegaque', to beṉe' byo na' to no'ole.” ");
INSERT INTO zpqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Da'nan' beṉe' byon' gwsane' x̱axṉe'e cont soalene' no'ol c̱hen', ");
INSERT INTO zpqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na' chope' yesaque' ca toz beṉe'.” Na' ca' bich yesac c̱hope' san toze'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Da'nan' bi cheyaḻa' yesyele'e, ḻe Diosen' ba bcode' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cate' besyežine' yo'o, beṉe' ca' zjanaque' ḻe' txen da' yoble goseṉabde'ne' bi zejen dan' ba gwne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na' Jesúsen' gože' ḻegaque': ―Note'teze beṉe' chele'e len no'ol c̱he' na' cheque'e no'ol yoble, chone' da' xiṉj, ḻe toz ca naquen šaca' gata'lene' no'ol c̱he beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na' še no'olen' chsane' beṉe' c̱hen' na' cheque'e beṉe' yoble, ḻecze toz can' nac da' xiṉj da' chonen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nach jasesane' bi' bixjw lao Jesúsen' cont x̱oa ne'e yic̱hjgacbe', perw beṉe' ca' zjanaque' ḻe' txen gosediḻe' beṉe' ca' zjanc̱he'ebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na' cate' ble'e Jesúsen' can' gosonen' na' bže'e ḻegaque' na' gože'ne': ―Ḻe güe' latje yesid bidao' ca' lagua' nga na' bi gwžonḻe, ḻe beṉe' ca' zjanac ca bidao' quinga, ḻegaque' chosozenague' c̱he Diosen' cont chnabi'e yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da' ḻi žia' le'e, note'teze beṉe' cheyaḻa' yosozenague' c̱he Diosen' ca cheson bidao' cate' chosozenagbe' c̱he x̱axṉa'be', ḻe beṉe' bi yosozenague' ca', gwbat ṉabia' Diosen' yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nach gwḻene' to to bidao' ca' na' gwṉabde' Diosen' gac güen c̱hebe', gwx̱oa taquen' yic̱hjbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cate' Jesúsen' gwze'e ngüe'e nez, chxoṉjses to beṉe' jazoa xibe' lagüen' na' gwṉabde'ne': ―Maestro, le' naco' beṉe' güen. ¿Bi cheyaḻa' gona' cont gata' yeḻa' mban c̱hia' toḻi tocaṉe'? ");
INSERT INTO zpqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsen' gože'ne': ―¿Bixc̱hen' žo' naca' beṉe' güen? Toze beṉe' güen zoa, na' ḻen' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Le' ṉezdo' da' none' mandadw goncho: “Bi gata'lenḻe no'ol bi nac no'ol c̱hele o beṉe' byo beṉe' bi nac beṉe' c̱hele; nono gotle; bi cuanḻe; bi güe'le diža' güenḻaže' c̱he beṉe' ḻježle; bi siye'le beṉe'; ḻe gap bala'aṉ x̱axṉa'le.” ");
INSERT INTO zpqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na' boži'e xtižen': ―Maestro, yogo' da' quinga chzenaga', gwzolagua' chonczan' cate' ṉe' nactia' bidao'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesúsen' gwṉe'e beṉe' güegon' na' chacde' ḻe', na' gože'ne': ―Zoa to da' ṉe' chyažjen gono': šjayeto' yogo' da' de c̱hio' na' da' le'edo' c̱hen bnežjon beṉe' yaše'. Nach še gono' ca', cate' yežino' yaba gan' zoa Diosen' da' zaca'ch gata' c̱hio'. Na' še ba beyož beno' can' žia' le', nach yo'o gaco' neda' txen ḻa' saca'zi'o. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na' cate' bene ben' dan' gwna Jesúsen', gocde' ḻeca zdebe naquen gone' can' gože'ne', na' beza'yaše', ḻe beṉe' gwṉi'achgua goque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nach Jesúsen' gwṉe'e do cue'ej cuite' na' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻeca zdeb naquen to beṉe' gwṉi'a gwzenague' c̱he Diosen' cont Diosen' ṉabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na' beṉe' ca' zjanaque' ḻe' txen besyebande' can' gwnen', perw Jesúsen' goze'e ḻegaque': ―Xi'iṉa', beṉe' chesacde' zaca'chgua yeḻa' gwṉi'a c̱hegaquen', ḻeca zdebe naquen yosozenague' c̱he Diosen' cont ṉabi'e yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bedao'ch te to be xen be nzi' camello to ḻo' nag yeše' clel ca to beṉe' gwṉi'a gwzenague' c̱he Dios cont Diosen' ṉabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cate' gosende' dan' gwne', ḻeca besyebande' na' gose' ḻježe': ―¿Noxen' šjayzoa len Diosen' še ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesúsen' gwṉe'e ḻegaque' na' gože'ne': ―Bibi de da' gac yeson beṉac̱hen' cont šjasyenite' len Diosen', perw Diosen' guac gonen'; ḻe bi zoa da' ṉacho da' bi gac gon Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nach Pedron' gože'ne': ―Neto' ba gwlejyic̱hjto' yogo' da' de c̱heto' cont nacto' le' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesúsen' boži'e xtižen': ―Da' ḻi žia' le', note'teze beṉe' ba gwlejyic̱hje' liže', beṉe' biše', zane', x̱e', xṉe'e, no'ol c̱he', xi'iṉe', o yežlio c̱he' ṉe c̱hia' neda' na' ṉec̱he chzenague' xtižan', ");
INSERT INTO zpqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yežlio nga yonežjo Diosen' ḻe' to gayoa ca'te'le, yo'o, biše', zane', xṉe'e, xi'iṉe' na' yežlio, ḻa'czḻa' yesebe'na'ogüe' ḻe'. Na' cate' yežine' yaban' gata' yeḻa' mban' c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Perw zan beṉe' zjanaque' beṉe' žialao ṉa'a, gwžin ža cate' yesaque' beṉe' bzebe; na' beṉe' zjanaque' beṉe' bzebe ṉa'a, gwžin ža cate' yesaque' beṉe' žialao. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zjangüe'e nez zja'aque' bso dan' zoa gaḻa'ze Jerusalénṉa' na' Jesúsen' žialagüe' lao beṉe' ca' zjanaque' ḻe' txen. Ḻegaque' chesyebande' na' do chesežebze' zjana'ogüe' ḻe'. Nach da' yoble Jesúsen' goxe' beṉe' šižiṉw ca' ca'ale ga nac lchojiže' na' gože' ḻegaque' can' gac c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gože'ne': ―Ṉa'a ba zejcho Jerusalén gan' yesone' neda' ḻo na' bx̱oz gwnabia' ca' na' ḻo na' beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisés, na' yesec̱hoglagüen' c̱hia' yesote' neda' na' yesone'nda' ḻo na' beṉe' bi zjanaque' beṉe' Israel, nedan' naca' ben' gwseḻa' Dios golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yesezi'diže' neda', yesot yeseyine' neda', gosoži'enda' xene', na' yesote' neda', perw yeyoṉ ža yebana' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nach Jacobo len Juan, beṉe' ca' zjanac xi'iṉ Zebedeo, gosebigue' cuit Jesúsen' na' gose'ene': ―Maestro, chaclaže'to' gono' to goclen da' ṉabto'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na' gwṉabe Jesúsen' ḻegaque': ―¿Bi che'nele gona'? ");
INSERT INTO zpqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na' gose'ene': ―Ben cont cue'to' šḻa'a güeje cuito'na' cate' solao ṉabi'o. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nach Jesúsen' gože'ne': ―Le'e cabi ṉezele bi dan' chṉable. ¿Gwc̱hejlaže'le tele yeḻa' zi' yeḻa ya' ca dan' tia' neda' na' gac c̱hele can' gac c̱hia'? ");
INSERT INTO zpqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ḻegaque' gose'ene': ―Gwc̱hejlaže'to'. Na' Jesúsen' gože' ḻegaque': ―Da' ḻicze tele yeḻa' zi' yeḻa' ya' ca dan' tia' neda' na' gac c̱hele can' gac c̱hian'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Perw bi naquen ḻo na' ṉia' non' cue' cuitan' cate' žin ža ṉabi'a, san yesebe' beṉe' ba mbej Diosen' gaquen c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cate' yeši beṉe' ca' zjanaque' ḻe' txen gosende' xtiža'gaquen', beseloque' Jacobon' na' Juanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Perw Jesúsen' goxe' yogüe' cont gosebigue' laogüen' na' gože' ḻegaque': ―Ṉezeczele beṉe' zjambeje' cont chesenabi'e to to nación na' beṉe' blao ca' chesone' byen chosozenag beṉe' c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Perw bi naquen ca' len le'e. San note'tezle chaclaže'le gacle beṉe' blao, cheyaḻa' gwzex̱jwlaže'le gaclenḻe beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na' note'tezle chaclaže'le gacle beṉe' žialao, cheyaḻa' gon cuinḻe ca xmos yogo' beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ḻe lencze neda', gwseḻa' Diosen' neda' golja' beṉac̱h, gague za'a cont yesaclen beṉe' neda', san za'a cont gaclena' beṉe', na' gwnežjw cuina' yesote' neda' ṉec̱he xtoḻa' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nach besežine' Jericó. Na' cate' Jesúsen' ba beze'e ciudan' len beṉe' ca' zjanaque' ḻe' txen na' len yezanch beṉe', do cho'a ciudan' chi' to beṉe' lc̱hoḻ chanez chṉabe' yosonežjo beṉe' ḻe' con gaca' da' chesezande'. Bena' le' Bartimeo na' naque' xi'iṉ to beṉe' le' Timeo. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na' beṉe' lc̱hoḻa' cate' gocbe'ede' gwde Jesús beṉe' Nazaret gan' chi'ena', gwzolagüe' gwṉe' zižje gwne': ―¡Jesús, xi'iṉ diaža c̱he da' rey David, beyaše'laže'šca neda'! ");
INSERT INTO zpqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Beṉe' zan gosediḻe' ḻe' cont bich yosye'e, perw bosya'adiache' gwne': ―¡Xi'iṉ diaža c̱he da' rey David, beyaše'laže'šca neda'! ");
INSERT INTO zpqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nach Jesúsen' gwleze' na' gwne': ―Ḻe gaxe'. Nach gosaxe' beṉe' lc̱hoḻa' na' gose'ene': ―Benc̱hac̱hlažo', gwzoža', ḻe chaxe' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nach gwcho'oṉe' lache' da' nx̱oa cože' na' bxite' jabigue' lao Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nach Jesúsen' gwṉabde' ḻe': ―¿Bi chaclažo' gonda' le'? Beṉe' lc̱hoḻa' boži'e xtižen': ―Maestro, che'nda' yele'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nach Jesúsen' gože'ne': ―Guac yeyejo'. Dan' chejnilažo' neda' ba beyac yejlaguon'. Na' ḻa' bele'ete beṉe' lc̱hoḻa', na' gwda'ogüe' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cate' ba zoa yesežine' Jerusalén, besežine' gan' zjachi' yež dan' zjanzi' Betfagé na' Betania na' gan' zoa ya'a da' nzi' Ya'a Olivos. Na' Jesúsen' gwseḻe' c̱hop beṉe' ca' zjanaque' ḻe' txen mandadw, ");
INSERT INTO zpqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","gožgaque'ne': ―Ḻe šja'ac yež dan' chi' gaḻa'ze, na' cate' žinḻen' na' yeželele to burr dao' da'ba' yag be nono ṉa' cuia. Ḻe sežba' na' ḻe c̱he'ba' nga. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na' še no chṉab bic̱hen' chonḻe ca', ḻe ye'e: “X̱anto' chyažjde'ba'”, na' ḻa' gwzantecze'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nach gosa'aque', na' besele'ede' burron' da'ba' yag to cho'a yo'o cuit ga xoa to nez, na' goseseže'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na' baḻ beṉe' ca' nita' na' gose'ene': ―¿Bixen' chonḻe? ¿Bixc̱hen' chsežle burron'? ");
INSERT INTO zpqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nach bosyoži'e xtižen' can' gož Jesúsen' ḻegaque', na' goso'e latje goseseže'ba' cont gosec̱he'eba'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nach gosec̱he'e burron' lao Jesúsen' na' gosex̱oa xagaque' cože'ban' na' gwžia Jesúsen' ḻeba'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na' beṉe' zan gosonxene' Jesúsen' goseyix̱jw no xagaque' ḻo nez cont blej burron' ḻen na' yebaḻe' gosec̱hogue' xoze' yag na' goseyix̱juen' ḻo neza'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Beṉe' zjažialao na' ḻecze beṉe' za'ac cože' gosezolagüe' bososye'e, gosene': ―¡Ḻeca zaca'chgua benga! ¡Mbalaz ben' za' nga nseḻa' X̱ancho Diosen' ḻe' cont ṉabi'e! ");
INSERT INTO zpqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Mbalaz yeḻa' gwnabia' c̱he' da' nse'e, ḻe' ṉabi'e ca da' x̱ozxta'ocho David! ¡Ḻeca zaca'chgua Dios ben' zoa yaban'! ");
INSERT INTO zpqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Can' goc, Jesúsen' gwyo'e Jerusalén, na' ḻecze gwyo'e chyo'o c̱he yodao' blaon'. Na' beyož gwṉe'e yogo'ḻoḻ da' de na', beyeje' Betania len beṉe' šižiṉw ca' ba gwleje' cont zjanaque' ḻe' txen, ḻe ba zoa gaḻ. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Beyec̱hj ža cate' besyeya'aque' Betania, Jesúsen' gwdone'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na' zito' ble'ede' to yag yix̱güigw da' žia ḻaga', na' jaṉe'e še žia yaguen' yix̱güigw, na' bibi bželde', san ḻaga'ze ca' da' žian, ḻe gague canan' chesebia yix̱güigon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nach Jesúsen' boḻ güiže' yag yix̱güigon', gožen': ―Noch no gagw da' chbio' le'. Na' beṉe' ca' zjanaque' ḻe' txen gosende' can' gwnen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gwdena' besežine' Jerusalén. Na' cate' gwyo'o Jesúsen' chyo'o yodao' blaon', gwzolagüe' bešaše' beṉe' ca' chesote' na' beṉe' chesa'o na'. Na' bchix̱e' xmes beṉe' ca' chosoša' mechw na' yag ga chesebe' beṉe' ca' chesote' ngolbex. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na' bi be'e latje yesex̱oa xṉez beṉe' zjanoa' yoa' chyo'o yodaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na' bsed blo'ede' beṉe' ca' že' na', gože'ne': ―Nyojcze Xtiža' Diosen' žan: “Yesene' ližan' naquen latje gan' šja'ac beṉe' yogo' nación yosoḻ güiže'nda'”, perw le'e ba benḻen ca to latje ga že' beṉe' gwban. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés gosende' can' gwnen', na' goseyiljwlaže' nacle yesone' yesote'ne'. Ba chesežebe' Jesúsen', ḻe yogo' beṉe' besyežejde' can' bsed blo'eden'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Perw na' cate' goḻ, Jesúsen beze'e ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Beyec̱hj ža šezil, gosedie' na' besele'ede' yag yix̱güigon' ba gwbižen lente loen. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nach Pedron' jayze'ede' na' gože' Jesúsen': ―Maestro, gwṉa' yag yix̱güigw dan' gwnao' gacxi'an, ba gwbižen. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsen' boži'e xtižen': ―Ḻe šejnilaže' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Da' ḻi žia' le'e, note'teze beṉe' ye'e ya'a nga: “Gwcuase nga na' jayzoa ḻo' nisdao'”, še bi chacžejlaže' ḻo' yic̱hjlažda'ogüe', san chejnilaže' Diosen', guacczen. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Da'nan' žia' le'e, yogo'te da' ṉable cate' choḻ güižle Dios, ḻe šejḻe' guaqueczen, na' ḻe gacczen. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na' cate' choḻ güižle Dios, še zoa da' chac c̱hele len beṉe' yoble, ḻe yezi'xen c̱he', cont ḻecze ca' X̱acho Dios ben' zoa yaba yezi'xene' c̱he xtoḻa'le. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Perw še le'e bi yezi'xenḻe c̱he beṉe', X̱acho Dios beṉe' zoa yaba bi yezi'xene' c̱he xtoḻa'le. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nach ja'aque' Jerusalén da' yoble, na' šlac chda Jesúsen' chyo'o yodao' blaon' jasebiga' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés na' len beṉe' gole blao' ca' chesenabi'e naciónṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na' goseṉabde' ḻe': ―¿Bi yeḻa' gwnabia' napo' chono' da' qui? ¿No beṉ yeḻa' gwnabian' cont chonon'? ");
INSERT INTO zpqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsen' boži'e xtižen', gwne': ―Ḻeze de to da' ṉabda' le'e na' še yoži'ile xtižan', nach ṉia' le'e bi yeḻa' gwnabia' chonḻendan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿No gwseḻa' da' Juanṉa' bzoe' beṉe' nis? ¿Dios nan' gwseḻe'ne' še beṉac̱hen'? Ḻe yoži'i xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nach ḻegacze' gose' ḻježe': ―Še ye'chone' Dios gwseḻe' ḻe', na' ye'e chio': “¿Bixc̱hen' ca gwyejḻe'le c̱he'?” ");
INSERT INTO zpqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bi gac ye'chone' beṉac̱h gwseḻa' ḻe'. Gosene' ca' da' besežebe', ḻe yogo'te beṉe' že' na' gosejḻe'e Diosen' gwseḻe' da' Juanṉa' be'e xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nach gose'e Jesúsen': ―Bi ṉezeto'. Nach Jesúsen' gože' ḻegaque': ―Ḻecze neda' bi yapa' le'e bi yeḻa' gwnabian' chonḻenda' da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nach Jesúsen' gwzolagüe' choe'lene' ḻegaque' diža' chzoe' jempl, na' gože' ḻegaque': ―Gwzoa to beṉe' goze' to cue' xen yag uvas na' gwlo'en le'ej. Na' bene' to ga yesesie' uvasen' cont choj x̱isen', na' bene' yeto da' sibe ca to campanario ga yesecua' beṉe' yosogüia yeseṉe'e yag ca'. ’Nach bcua'aṉe' yežlion' ḻo na' beṉe' yesonši'e yag uvasen', na' gwze'e gwyeje' zito'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na' cate' bžin ža yosyotobe' cosešen', gwseḻe' to xmose' lao beṉe' ca' nac ḻo na'gaque' yag uvasen' cont yosonežjue'ne' to tlacw coseš dan' yesyezi'en. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Perw na' beṉe' ca gosezene' mosen' gosot goseyine'ne', na' to ga'alze' bosyose'ene' bibi goso'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nach x̱an yežlion' da' yoble gwseḻe' yeto xmose'; perw benga bosožie'ne' yej, gosone' güe' yic̱hje' na' gosonde' ḻe' zgot. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nach x̱an yežlion' gwseḻa'che' yetoe', na' benga gosottecze'ne'. Gwdena' gwseḻa'che' beṉe' zan, na' baḻe' gosot goseyine' ḻe' na' yebaḻe' gosottecze'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ṉe' zoa yeto beṉe' biṉa' seḻe', bena' xi'iṉe' beṉe' chacchgüede', na' bzebte gwseḻe' ḻe', ḻe bene' xbab: “Yesezi'e xtižen'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Perw beṉe' ca' gose' ḻježe': “Bengan' yega'aṉlene' yežlio nga cate' gat x̱en'. Ḻe da gotchone' cont yega'aṉlenchon.” ");
INSERT INTO zpqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na' gosezene'ne', gosote'ne', na' besyebeje' cuerp c̱hen' gan' že' yag ca', bosozaḻen' ga yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nach Jesúsen' gwṉabe': ―¿Bi chaquele? ¿Nacxe gon x̱an yežlion' len beṉe' ca' bocua'aṉlene' yag uvas c̱hen'? Šeje' šjetoe' ḻegaque', na' yodie' yežlion' ḻo na' beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Biṉa' gwlable ga nyoj Xtiža' Diosen'? žan quinga: Yej dan' bi gosaclaže' beṉe' güen yo'o ca' yosoc̱hine', ḻen ba naquen yej squin. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Da' nga ben X̱ancho Dios, na' naquen to da' yežejecho. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nach gosaclaže' yesezene' Jesúsen', ḻe gosacbe'ede' be'e jemplna' ṉec̱he dan' bi chesejnilaže' ḻe'. Perw besežebe' še bi yesone beṉe' ca' nžaguen' ḻegaque', da'nan' bosocua'aṉe'ne' na' besyeya'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gwdena' goseseḻe' baḻ beṉe' fariseo na' baḻ beṉe' ca' goseda' Herodes cont yesebeje' Jesúsen' diža' da' yosode'ede' cont yesagüe' xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Beṉe' ca' ja'aque' na' gose'ene': ―Maestro, ṉezeto' zoatezo' cho'o diža' ḻi na' bi chono' cuent bi ža beṉe', ḻe toze can' chono' len note'teze beṉe'. Na' ṉezeto' diža' ḻi cho'o chsed chlo'edo' beṉe' can' chazlaže' Diosen' goncho. Da'nan' zedeṉabeto' le' ¿naquen binḻo no c̱hixjo da' cheyaḻa' c̱hixjo c̱he ben' nac ḻa'zelagüe beṉe' gwnabia' ben' chi' Roma? ¿Gwdixjwton', še bi c̱hixjwton'? ");
INSERT INTO zpqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesúsen' gocbe'ede' gague do lažen' chese'ene' ca', san chesaclaže' yesonḻede' ḻe' len xtiža'gaquen', nach gože'ne': ―¿Bixc̱hen' chaclaže'le yoslažo'le neda' len xtižan'? Ḻe goṉ neda' to mechw cont ṉa'an. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na' goso'enen', na' cate' ble'eden' na' Jesúsen' gwṉabde' ḻegaque': ―¿No lao dan' da' ḻe'e mechw nga? na' ¿no la dan' nyoj ḻe'en ni? Nach bosoyoži'en gose'ene': ―C̱he César ben' nac ḻa'zelagüe beṉe' gwnabian' ben' chi' ciuda Roman'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nach Jesúsen' gože'ne': ―Ḻe gwnežjo beṉe' gwnabian' da' nac c̱he beṉe' gwnabia', na' ḻe gwnežjo Dios da' nac c̱he Dios. Na' besyebande' can' boži'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nach besežin baḻ beṉe' saduceos gan' zoa Jesúsen'. Beṉe' ca' chesene' beṉe' guaten' bich yesyebane'. Nach goseṉabde' ḻe', gose'ene': ");
INSERT INTO zpqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, da' Moisésen' bzoje' can' cheyaḻa' goncho, gwne' še to beṉe' byo gate' na' chzeb no'ol c̱hen' perw na' nono bi' güezeb chga'aṉ, na' beṉe' biše' ben' ba got cheyaḻa' yošagna'lene' no'ol güezeba' cont yesenita' xi'iṉ diaža c̱he da' bišen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gosenita' beṉe' gosac gaž biše'. Na' beṉe' nechua' bšagne'e, na' gote' nono xi'iṉe' gwnita'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na' beṉe' gwchopa' bošagna'lene' no'ol güezeba', na' ḻecze gote' nono xi'iṉe' gwnita'. Ḻecze ca' goc len beṉe' gwyoṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na' ca' goc gosedaš beṉe' gaža' bosošagna'lene' no'ola', na' ṉe toe' ca gosezoa xi'iṉe' len ḻe'. Gwde gosat yogo'ḻoḻ beṉe' ca', ca beyožen got len no'ola'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gož neto', cate' yesyebane' ladjo beṉe' guat ca' ¿nox beṉe' ca' soalene' no'ola' ca xo'ole'? ḻe yogo' beṉe' gaža' bosošagna'lene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nach Jesúsen' boži'e xtižen', gwne': ―Clelen' chonḻe xbab dan' žale ca', ḻe bi ṉezele can' ža Xtiža' Dios da' nyojen, ṉeca nombia'le yeḻa' guac c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cate' yesyeban beṉe' guat ca' bich yosošagna' beṉe', ṉeca yosonežjo xi'iṉe' no'ol gwšagne'e, ḻe yesaque' ca angl beṉe' zjazoa yaba. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na' ca nac dan' yesyeban beṉe' guat ca', ¿biṉa' gwlable gan' bzoj da' Moisés, can' gož Diosen' ḻe' caten' boḻ güiže'ne' to ḻo yag yeše' dao' da' chey? Gože'ne': “Neda' naca' Dios ben' chonxen Abraham, ben' chonxen Isaac, na' ben' chonxen Jacob.” ");
INSERT INTO zpqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Beṉe' guat ca' bi chesonxene' Diosen', san beṉe' zjamban. Na' ca nac le'e, ḻeca clelen' chonḻe xbab. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ḻeze bžin to beṉe' bsed blo'ede' ley dan' bzoj da' Moisés, beṉe' bende' caten' chesežeše' len Jesúsen', na' ṉezde' boži'icze Jesúsen' xtiža'gaquen' binḻo. Na' bena' gwṉabde'ne': ―¿Non' nacch da' žialao da' zjanyojen da' ža Diosen' cheyaḻa' goncho? ");
INSERT INTO zpqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesúsen' boži'e xtižen' gože'ne': ―Da' nga nacch da' žialao lao yogo'ḻoḻen, žan: “Ḻe gwzenag beṉe' Israel gualaž c̱hia', toze X̱ancho Dios naque' beṉe' zaca' gonxencho. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Da'nan' cheyaḻa' gaquecho X̱ancho Diosen' con ca zelao chejni'icho, do yic̱hj do laže'cho, do fuerz valor c̱hecho.” Ḻenṉa' naquen da' žialao lagüe da' ca' ža Diosen' cheyaḻa' goncho. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na' da' gwchopen' zejgaḻan' ca', gan' žan': “Cheyaḻa' gaque ḻježcho ca chaque cuincho.” Bich bi de da' že' cheyaḻa' goncho da' zaca'ch ca da' qui. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nach ben' chsed chlo'e dan' bzoj da' Moisésen' gwne': ―Ca'yaṉen' naquen, Maestro. Da' ḻicze can' gwnaon'. Toze X̱ancho Dios zaque' gonxenchone', na' noch no zoa beṉe' zaca'ch ca ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na' še gaquecho Dios, con ca zelao chejni'icho, do yic̱hj do laže'cho, do fuerz valor c̱hecho, na' gaque ḻježcho ca chaque cuincho, ḻenṉa' zaca'chen ca yogo' da' choncho chotcho no beyix̱e' na' chzeychoba' chonxencho Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nach cate' gocbe'e Jesúsen' boži'icze' xtižen' to ḻicha, gože'ne': ―Gague da' xen chyažjen cont ṉabdo' Diosen' ṉabi'e yic̱hjlažda'oguon'. Na' ṉe yetoe' bich beseyaxjde' bichle yeseṉabde' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesúsen' bsed blo'ede' chyo'o yodaon', gwne': ―¿Nacxec̱hen' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés chesene' Criston' ben' gwlej Diosen' cont yedeṉabi'e naque xi'iṉ diaža c̱he da' rey David? ");
INSERT INTO zpqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cuin Daviden' gwne' can' blo'e Spiritw c̱he Diosen' ḻe': X̱ancho Dios gože' X̱anan': “Gwche'edo' cuita' nga ṉabi'acho txen, na' gona' cont yogo' no chesegue'e le' yosozex̱jw yic̱hje' yosozenague' c̱hio'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nacxe gac ṉacho Criston' naque' xi'iṉ diaža c̱he da' David? ḻe cuin Davin' gože' ḻe': “X̱ana'”. Na' zjanyanchgua beṉe' ca' chosozenag xtižen', na' besyebede' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesúsen' caten' chsed chlo'ede' ḻegaque' gwne': ―Ḻe gwsaca' cont bi gonḻe can' cheson beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés, ḻe chesyebede' chesaše' zjanyaze' lache' toṉ, na' chesyebede' chesap beṉe' ḻegaque' bala'aṉ cate' chesyežague' lagüe ya'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chesyebede' chesebi'e gan' chesebe' beṉe' blao cate' chja'aque' yodao' na' cate' chac ḻṉi. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ḻegaque' cheseque'e yo'o c̱he no'ol güezeb ca', na' cate' chosoḻ güiže' Dios, sša cheso'e diža' cont yesaque beṉe' ḻeca chesonxene' Diosen'. Beṉe' can' yesacche' castigw clel ca yezica'chle beṉe' güen da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na' šlac zoa Jesúsen' chyo'o yodaon', gwchi'e gaḻa'ze gan' xoa caj gan' chesegüe'e mechw c̱he yodaon', na' chṉe'e can' chesego'o beṉe' mechw. Na' zan beṉe' gwṉi'a ca' chesegüe'e da' zc̱ha'o mechw. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ca' chac, cate' bžin to no'ol güezebe beṉe' yaše', gwlo'e c̱hop mechw dao' da' bibi zaca'tec. ");
INSERT INTO zpqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nach Jesúsen' goxe' beṉe' ca' zjanaque' ḻe' txen na' gože'ne': ―Da' ḻi žia' le'e, no'ol güezebe yaše' nga ba gwlo'oche' mechw da' zaca'ch len Diosen' clel ca yogo' beṉe' ca' chesego'o mechw ḻo' cajen', ");
INSERT INTO zpqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ḻe yogo' ḻegaque' chesegüe'e da' checho'oṉen ḻo yeḻa' gwṉi'a c̱hegaquen', perw no'ol nga, ḻo yeḻa' yaše' yeḻa' zi' c̱he' gwlo'e yogo' da' de c̱he' da' chacbanḻende'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cate' cheza' Jesúsen' yodao' blaon' to beṉe' ca' zjanaque' ḻe' txen gože'ne': ―¡Maestro, gwṉa'šc catec xdan zjanac yej qui na' yo'o qui! ");
INSERT INTO zpqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na' Jesúsen' boži'e xtižen', gože'ne': ―Ca nac yo'o xen qui chle'echo, žin ža cate' ṉe to yej da' zjancua' nga ca yega'aṉ zjancua' cože' ḻježen. Yogon' yosyoc̱hiṉje'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nach ja'aque' Ya'a Olivos gan' nḻa' yodao' blaon'. Na' cate' ba chi' Jesúsen' ḻo ya'an len Pedro na' Jacobo, na' Juan na' Andrés, beṉe' ca' zjanaque' ḻe' txen, ḻegaque' gose'ene' šižize: ");
INSERT INTO zpqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Che'neto' ṉao' neto' batcan' gac da' ca'. ¿Nac gac ṉezeto' cate' ba zoa gac yogo' da' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesúsen' boži'e xtižen', gwne': ―Ḻe gwsaca' cont nono siye' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ḻe beṉe' zan yesaš yežlio nga yesaclaže' yosoḻane' xlatja' nga, yesene': “Nedan' naca' Cristo ben' gwlej Diosen' cont ṉabi'e.” Na' yeseziye'e beṉe' zan. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Na' cate' yenele chac gwdiḻe nile nale, o yenele guac gwdiḻe, bi žeble, ḻe can' cheyaḻa' gac. Perw gague ḻenṉa' ṉacho ba bžin ža yeyož yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ḻe yesediḻ to yež len yeto yež yoble na' to nación len yeto nación yoble, na' zan cuen ga x̱o'chgua ḻo yežlion', na' gata' gwbin na' yesebec beṉe' žaš. Na' da' qui gac cate' za' solao gata' yeḻa' zi'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Na' ḻe gwsaca' can' gonḻe, ḻe yesoṉe' le'e ḻo na' beṉe' gwnabia' ca' cont yesot yeseyine' le'e ḻo' yodao' c̱hegaquen', na' dan' chejnilaže'le neda' nita' beṉe' yesec̱he'ex̱ox̱je' le'e no lao rey no lao nochle beṉe' gwnabia', na' can' güe'lenḻe ḻegaque' xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ḻe za' te c̱he yežlion', xtiža' Diosen' cheyaḻa' gas ḻaḻjen doxen yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na' cate' yesezene' le'e na' yesec̱he'e le'e lao beṉe' gwnabia' ca', bi cuec yic̱hjle nac yoži'ile xtiža'gaquen', ṉeca gonḻen xbab. San ḻe ṉa con da' ye' Diosen' le'e ṉale ḻo hor na'teze, ḻe gague le'eczen' ṉele, san Spiritw c̱he Diosen' goṉen ga ṉale bin' cheyaḻa' ṉale. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cana' baḻ beṉac̱h yesec̱hje' yesone' beṉe' biše' golje' ḻo na' beṉe' yesot ḻegaque', na' nita' beṉe' yesone' xi'iṉgaque' ḻo na' beṉe' yesot ḻegacbe', na' nita' beṉe' yesone x̱axṉe'e ḻo na' beṉe' yesot ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yogo'ze beṉe' yesegue'ede' le'e dan' chejnilaže'le neda', perw note'tez le'e gwyo gwc̱hejlaže'le cont bi cuejyic̱hjle dan' chejnilaže'le neda' žin žate gatle, nach šjayzoale len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Da' Daniel ben' gwdix̱jue'ede' xtiza' Dios bzoje' c̱he da' zbanchgua da' gwx̱iṉjen latje gan' chonxencho Diosen'. Na' cate' le'e le'ele ba zoa dan' gan' bi cheyaḻa' soan, cana' beṉe' yesenita' distritw Judea cheyaḻa' yosoxoṉje' šja'aque' do ya'adao'. (Beṉe' gwlaben' cheyaḻa' šejni'iden'.) ");
INSERT INTO zpqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na' beṉe' chda do yic̱hjo' c̱he liže' žana', bi yeyetje' yotobe' xšinḻaze' ca' že' ližen', con yoxoṉje'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na' beṉe' chda yix̱e' bi yeyej liže' šjayxi' xaḻane'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Nyaše'chguaze zjanac no'ol ca' zjanoa' xi'iṉ, na' no'ol ca' ṉe' chosoguaže' bidao' ḻo ža ca'! ");
INSERT INTO zpqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ḻe ṉab lao Dios bi yažjen gwxoṉjle caten' chac zag, ");
INSERT INTO zpqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ḻe yesaquen ža da' ḻeca yesaḻe' beṉe'. Cate' bx̱ete Diosen' yežlio na' ža ṉa'aža nono ṉa' gaḻe' ca', ṉeca žinḻažen' yesaḻe'de' ca' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na' šaca' X̱ancho Diosen' bi yozaše' žan' yesac ca', notno yela, perw yozašen' ṉec̱he chacde' beṉe' ca' chesejnilaže' ḻe', beṉe' ba gwleje' zjanaque' xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Cana' še no ye' le'e: “Ḻe ṉa'šc, nga zoa Cristo ben' gwlej Diosen' cont ṉabi'e”, o “Ḻe ṉa'šc, na' zoe'”, bi šejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ḻe yesaš beṉe' gwxiye' beṉe' yesaclaže' yosoḻane' xlatja' nga, na' yeson cuine' ca beṉe' chesoe' xtiža' Dios. Na' yesone' yeḻa' guac da' yesele'e beṉe' na' bichle da' zaca' yesyebande' cont yeseziye'e ḻegaque', na' len beṉe' ca' ba gwlej Diosen' zjanaque' xi'iṉe' yesaclaže' beṉe' gwxiye' ca' yeseziye'e šaca' gac yeseziye'e ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Perw ca nac le'e, ḻe gwzenag, ḻe ba gwdix̱jue'eda' le'e yogo' can' gac. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Perw ca nac ža ca' cate' yeyož gaḻe'le can' gwnia', gwbižen' yeyaquen c̱hoḻ na' bion' bich gwseṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na' beljw ca' yeselažon' ḻe'e yaban', na' yogo' da' chle'echo ḻe'e yaban' yesaquen ca chac yežlion' cate' chxo'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nach beṉe' že' yežlion' yesele'ede' neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h za'a ladjo bejon' len yeḻa' guac xen na' yeḻa' beṉe' zaca' juisyw c̱hian'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nach seḻa' angl c̱hian' yosyotobe' yogo' beṉe' ca' ba gwleja' cont zjanaque' neda' txen gate'teze nite' doxen ḻo yežlion', ga zelao nac zito'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ḻe gwzenag c̱he jempl nga c̱he yag yix̱güigon': Cate' ba chzolao chebešjw yaguen' na' chelan' ḻaga' che'eṉ dao', ṉezele ba za' lagüe ba. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na' ḻecze cate' le'ele ba chac da' mal ca' ba gwnia', cana'ch ṉezele ba za' juisyw, ba zoa gaḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Da' ḻi žia' le'e, biṉa' yenit diaža c̱he le'e nita'le ṉa'a cate' yeyož gac yogo'ḻoḻ da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ḻe'e yaban' na' yežlion' yesede c̱hen, perw ca nac xtižan', gague da' te cbi gac can' žanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Perw nono ṉeze bi ža bi horen' gac ca', ṉe angl ca' nita' yaba, ṉeca neda' naca' Xi'iṉ Diosen' bi ṉezda'. Toze X̱a' Dios ṉeze. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Da'nan', ḻe soa ḻe cueze, ḻe güia ḻe ṉa', na' ḻe soateze yoḻ güižle Dios, ḻe nono ṉeze batcan' žin ža. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Naquen ca nac c̱he to beṉe' šeje' zito', na' cate' za' se'e choṉ liž xḻatje' ḻo na' beṉe' güen žin c̱he', cho'e žin da' yeson to toe', na' chzoe' beṉe' chape' cho'a yo'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ḻe soa ḻe cueze ca beṉe' chesape' liže'na', ḻe bi zjaṉezde' batcan' yela' x̱an yo'on, še cate' ba zoa gaḻ, še chel, še cate' chbež jea, še cate' ba gwyeni'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ḻe xož yele'e zejzenez na' yedoḻe'de' ḻegaque' chesetase'. ");
INSERT INTO zpqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Da' nga žia' le'e ḻeze žiczan' par yogo'ḻoḻ beṉe'. Ḻe soa ḻe cuez batcan' žin ža. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yec̱hop ža za' gaḻa' pascw na' ḻṉi dan' chesone' caten' chesagüe' yetextil dan' bibi levadura yo'on. Na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés cheseyiljwlaže' nac yesone' yeseziye'e Jesúsen' cont yesezene'ne' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Perw gosene': ―Bi senchone' ḻo ḻṉin' cont ca yesebec beṉe' žaš. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na' goquen' Jesúsen' zoe' Betania liž Simón ben' güe'e yižgüe' da' nzi' lepra. Na' šlac chi' Jesúsen' cho'a mes, bžin to no'ole nox̱e' to de yejese ga chož set da' chḻa' zix̱, naquen dogualje da' bchoj ḻo yag yej da' nzi' nardo, na' zaca'chguan la'ay. Na' bzoxje' gan' yož seta' na' bzoac̱hoc̱hje' seta' yic̱hj Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na' baḻ beṉe' ca' zjanita' na' beseže'e, na' gose' ḻježe': ―¿Bixc̱hen' benditjde' set zix̱ nga? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ša no bete' ḻen güesoṉen ca no laxjw mos da' gone' gan tgüiz, na' gwṉežjuen' gaclenen beṉe' yaše'. Na' beseloque' no'ola'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Perw Jesúsen' gwne': ―Jayen'. ¿Bixc̱hen' chṉele c̱he no'olen'? Dan' bene' len neda' nga naquen güen. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ḻe beṉe' yaše' ca' bate'teze nita'cze' len le'e, na' guaque gonḻe len ḻegaque' da' güen cate' žan c̱hele, san neda' bich soacza' yesša len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","No'ole nga bene' da' zelao gwzaque'de'. Ba bguazje' neda' set zix̱ can' cheyaḻa' yesone' len neda' cate' gaša'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da' ḻi žia' le'e, doxen yežlio gate'teze šjasedix̱jue'e beṉe' diža' güen dan' chzejni'in c̱hia', decze de šjasyeze'ede' can' ben no'ol nga. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nach Judas Iscariote, ben' goque' txen len beṉe' ca' šižiṉw ben' gwlej Jesúsen' cont zjanaque' ḻe' txen, gwyeje' jaṉe'e bx̱oz gwnabia' ca' cont yosoxi'e nac gone' gwdie' Jesúsen' ḻo na'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cate' gosende' xtiža' Judasen', besyebede' na' gose'ene' yeso'ene' mechw. Nach Judasen' gwzolagüe' gwdiljwlaže' nac gone' gwdie' Jesúsen' ḻo na'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na' bžin ža chaḻa' ḻṉi caten' neto' beṉe' Israel chagwto' yetextil dan' bibi levadura yo'o. Naquen ža nechw c̱he ḻṉi pascw cate' chotto' xila' dao', cont šjayza'laže'to' can' bosla Diosen' da' x̱ozxta'oto' ca' ḻo na' beṉe' Egipto ca'. Na' beṉe' ca' zjanaque' Jesúsen' txen goseṉabde' ḻe': ―¿Ga che'ndo' šjasiṉi'ato' cont gagwcho xše' c̱he pascon'? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nach gwseḻe' c̱hop beṉe' ca' na' gože'ne': ―Ḻe šja'ac ciudan', na' yežagle to beṉe' byo no'e to che'e nis. Ḻe šejlene', ");
INSERT INTO zpqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na' gan' yežinen', ḻe ye' x̱an yo'on: “Maestrona' že': Goṉšco' to yo'o gan' gagwto' xše' ža ḻṉi nga len beṉe' ca' zjanaque' neda' txen.” ");
INSERT INTO zpqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nach gwlo'ede' le'e to cuart xen dan' zoa yic̱hjen na'ale gan' de yogo' da' chyažjecho. Na' ḻe gwsiṉi'a cont gagwcho na'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na' gosa'ac beṉe' ca' c̱hope, na' besežine' ciudan', na' yogo' can' gož Jesúsen' ḻegaque' goc, na' bososiṉi'e xše' že' ḻṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cate' beyož gwxoa gwbiž, bžin Jesúsen' len beṉe' šižiṉw ca' gwleje' cont zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na' gosebi'e gosagüe' xše'. Na' šlac chesagüen', Jesúsen' gože' ḻegaque': ―Da' ḻi' žia' le'e, to le'e chagwle len neda' txen, gwdele neda' ḻo' na' beṉe' ca' chesegue'e neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nach ḻegaque' besyeyaše'laže'de' na' gosezolagüe' tgüeje tgüeje' goseṉabde' ḻe' gosene': ―¿Nedan' gona' ca'? Na' yetoe' ḻeze gwne': ―¿Nedan' gona' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na' Jesúsen' gože'ne': ―Ladjo le'e beṉe' šižiṉw, to beṉe' chagw len neda' txen toze ḻo' ye'eṉ gon ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na' gac c̱hia' can' nyoj ḻe'e Xtiža' Diosen', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Perw ¡nyaše'chguaze nac ben' gwdie' neda' ḻo na' beṉe' ca'! Yejṉi'acle ša bi goljen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na' šlac chesagüe', Jesúsen' gwxi'e to yetextilen', na' beyož be'e yeḻa' chox̱clen c̱he Dios, bzoxjen', na' bnežjuen' ḻegaque', gwne': ―Ḻe gagon'. Ḻenṉa' cuerp c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nach bex̱ue' to vas gan' yože nis uvasen' na' beyož be'e yeḻa' chox̱clen c̱he Dios, be'en ḻegaque', na' yogüe' gose'eje' late' güej dan' yože ḻo' vasen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na' gože' ḻegaque': ―Da' ngan' xc̱hena' na' chzanḻažan' ḻaljen ṉec̱he yogo'ḻoḻ beṉac̱h. Na' ḻaljen cont solao gac da' coben' da' gwna Diosen' gone' gaclene' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Da' ḻi žia' le'e, bich ye'eja' x̱is uvas ṉa'a. Cate'ch žin ža ba zoacho txen gan' chnabia' Diosen', canan' ye'ejan' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Beyož gosoḻe' gosonxene' Diosen' nach gosa'aque' ja'aque' Ya'a Olivos. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nach Jesúsen' gože'ne': ―Ṉa'aže' yogo'le cuejyic̱hjle neda' ṉec̱he dan' gac c̱hian'. Ḻe nyojczen ḻe'e Xtiža' Diosen', žan: “Gota' beṉe' güeyoe xilan' na' xila' ca' yesasḻasba'.” ");
INSERT INTO zpqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Perw cate' yosban Diosen' neda' ladjo beṉe' guat ca', yobch yeya'a Galilea ca le'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nach Pedron' gože'ne': ―Ḻa' yogo' beṉe' quinga yesebejyic̱hje' le', neda' bi gona' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Perw Jesúsen' gože'ne': ―Da' ḻi žia le', biṉa' cuež jean' c̱hop ṉi'a ṉa'aže' cate' gac šoṉ ṉi'a bi chc̱hebo' še nombi'o neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Perw Pedroa' do laže' gwne': ―Ḻa'czḻa' še chonen byen guatlencza' le', gwbat ṉia' bi nombia' le'. Na' ḻecze ca' gosena' yogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nach besežine' latje gan' nzi' Getsemaní, na' Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen, gože'ne': ―Ngaze ḻe cue'edo' šlac neda' šjeḻ güiža' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na' gwc̱he'e Pedro, Jacobo na' Juan, na' gwzolaon da' juisyw da' gocde' ḻo' yic̱hjlažda'ogüen' na' benchgüe' xbab. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na' gože' ḻegaque': ―Ḻo' yic̱hjlažda'ogua' nga chacyaše'chgüeda', chacda' gatcza' catequen' chžaglagua'. Nga ḻe yega'aṉ na' ḻe soa ḻe ṉa' txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nach Jesúsen' gwžialagüe' yelate' na' jac̱haze' cosc̱ho'ale ḻo yon' gwṉabde' Dios še guac ten ca'ale bi gac can' ba zoa gac c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Gože' Diosen': ―X̱a', bibi de da' ṉacho da' bi chac gono'. Benšca cont bi saca'zi'a na' bi yesote'nda', perw bi chṉaba' gac da' žia' neda', san gac da' ṉao' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nach beyeje' gan' nita' beṉe' ca' šoṉe, na' ble'ede' zjanite' chesetase'. Na' gože' Pedron': ―Simón ¿chtason'? ¿Ṉe šlož da'oze ca goc cuejo' bišgal len neda'? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bi tasle, san ḻe yoḻ güiž Dios cont bi gon gwxiyen' le'e gan. Da' ḻi ḻo' yic̱hjlažda'olen' chṉa'laže'le gonḻe da' nac binḻo, perw cuerp c̱helen' bi chzoeczen. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nach gwyeje' da' yoble na' boḻ güiže' Dios na' da' yoble gože'ne' dan' ba gožcze'ne' tṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nach bezyeje' gan' niten', na' da' yoble ble'ede' chesetase', ḻe yejlagüen' chesexa' chesežoden' bišgal. Na' bi besyežellaže' nac yosyoži'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na' da' gwyoṉe ṉi'a gwyeje' na' bezžine' gan' nita' beṉe' ca' šoṉe na' gože' ḻegaque': ―¿Ṉe' chtasle? ¿Ṉe' chezi'laže'le? Ba goc. Ba goḻe' gon to beṉe' neda' ḻo na' beṉe' güen da' xiṉj ca', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ḻe c̱has, ḻe yeyo'o. Ba za' ben' gon neda' ḻo na'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesúsen' ṉe' choe'te' dižan' ca' cate' bžin Judas, na' zan beṉe' zja'aque' len ḻe' zjanox̱e' no yag, no spada, beṉe' goseseḻa' bx̱oz gwnabia' ca' na' beṉe' gole blao ca' chesenabia' nación Israel c̱heton'. (Judasen' goque' to beṉe' šižiṉw ca' gwlej Jesúsen' cont zjanaque' ḻe' txen.) ");
INSERT INTO zpqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na' Judasen' ba gože' ḻegaque' nac yeseṉezde' non' yesezene', gwne': ―Ben' gwnopa' x̱ague', ḻe'na'; ḻe sene' na' ḻe c̱he'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na' cate' bžin Judasen' na' jabigue' gan' zoa Jesúsen' na' gože'ne': ―Maestro, Maestro. Na' bnope'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nach gosezene' Jesúsen' cont yesec̱he'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Perw to ben' zecha cuit Jesúsen' gwlej spada c̱hen' na' gwdinen' mos c̱he bx̱oz blaon' gwc̱hogte' šḻa'a naguen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nach Jesúsen' gože' beṉe' ca': ―¿Nonḻe neda' ca to beṉe' gwban za'acle zedex̱i'le neda' len spada na' len yag? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yogo' žaze gwzoa' len le'e bsed blo'eda' beṉe' chyo'o yodao' blaon', na' bi gwzenḻe neda'. Perw chac da' qui cont chac can' nyoj Xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nach yogo' beṉe' ca' zjanaque' Jesúsen' txen bosoxoṉje' gosebejyic̱hje'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na' to bi' güego' na'obe' Jesúsen', na' nx̱oa cože'be' toze sábana. Na' beṉe' ca' ba gosezene' Jesúsen' ḻecze goseṉize'be'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Perw gwlejyic̱hjbe' sábanan' na' boxoṉjbe' ga'alyidbe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nach gosec̱he'e Jesúsen' lao bx̱oz blaon', na' besežag yogo' beṉe' ca' zjanac bx̱oz gwnabia', na' beṉe' gole blao ca' chesenabi'e nación c̱heton' na' beṉe' ca' bososed bosolo'ede' dan' bzoj da' Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na' Pedron' na'ogüe' Jesúsen' zito' zito'le bžintie' liž bx̱oz blaon' na' gwyo'e chyo'ona' gwchi'e txen len beṉe' ca' chesape' yodao' blaon' boše'e cuine' cho'a yi'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na' ca nac bx̱oz blaon' na' yogo' beṉe' ca' chesenabia' nación c̱heton', besyeyiljwlaže' bi da' yesagüe' xya c̱he Jesúsen' cont yesote'ne', perw bi besyeželden'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na' zan beṉe' gosone' diža' güenḻaže' c̱he Jesúsen', perw bi gosene' toz ca yesene'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Baḻe' gosezože'e na' bososbague'ne' xya c̱hoḻ, gosene': ");
INSERT INTO zpqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Neto' beneto' gwne': “Neda' yoc̱hiṉja' yodao' nga da' ben beṉac̱h, na' šoṉe žaze yeyona' yeto yodao' da' bi gon beṉac̱h.” ");
INSERT INTO zpqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Perw ṉe ca' ca gosene' toz ca yesene'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nach bx̱oz blaon' gwzože'e ladjo yogo'ḻoḻe' na' gwṉabde' Jesúsen': ―¿Bi choži'o xtižen'? ¿Bi dan' chosožie' le' xya? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Perw Jesúsen' bitw bi gwne', bitw boži'e xtižen'. Na' bx̱oz blaon' da' yoble gwṉabde' ḻe', gwne': ―¿Naco' le' Cristo ben' gwlej Diosen' cont ṉabi'e, na' Xi'iṉ Dios ben' chonxencho? ");
INSERT INTO zpqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesúsen' gože'ne': ―Ḻe can' naca'. Na' le'ele neda' cate' ba chi'a šḻa'a ḻicha c̱he Dios ben' nac ḻa'zelagüe beṉe' gwnabia', neda' naca' ben' gwseḻe' golja' beṉac̱h. Na' le'ele yetja' ladjo bejw dan' ze ḻe'e yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nach bx̱oz blaon' gwc̱heza' xaḻane' cont nacbia' bi beque'e can' gwna Jesúsen', na' gwne': ―Noch no chyažje beṉe' co' da' baḻi. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ḻe'e ba benele chṉe' c̱he Dios dan' že' ca', chon cuine' ca Dios. ¿Nacxe ža le'e? Na' yogüe' gosene' nape' doḻa' na' cheyaḻa' gate'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nach baḻe' gosezolagüe' chosoži'ene' xene' na' bososeyjue' lagüen' len to lache' na' gosot goseyine' ḻe', na' gosonḻe' c̱he' gose'ene': ―¡Gwnašc non' chot le'! Na' beṉe' ca' chesape' yodao' blaon' gosot goseyine' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedron' chi'e chyo'o che'eḻele, cate' bžin to no'ole güen žin c̱he bx̱oz blaon'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na' cate' no'olen' ble'ede' ḻe' chi'e choše'e cuine' cho'a yin', gwṉe'e ḻe' na' gože'ne': ―Lencze le' naco' txen len Jesús beṉe' Nazaret. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Perw Pedron' bi gwc̱hebe', gwne': ―Bi nombi'ane', ṉeca ṉezda' bin' žo'. Na' beyej Pedron' jayzie' cho'a puert na'le. Nach gwchež to jea. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na' no'ol güen žinṉa' gwṉe'e ḻe' da' yoble na' gože' beṉe' ca' nita' na': ―Benga naque' ḻegaque' txen. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Perw ḻe' da' yoble bi gwc̱hebe' še naque' txen len Jesúsen'. Na' gocze štit da' yoble beṉe' ca' nita' na' gose'e Pedron': ―Da' ḻicze, le' naco' txen len ḻegaque', ḻe naco' beṉe' Galilea, nacbia' chṉio' can' cheseṉe beṉe' Galilea ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nach Pedron' c̱hop šoṉe ṉi'a gwne': ―Diosen' goṉe' neda' castigw še chonḻaža' žia' bi nombi'a bena'. ");
INSERT INTO zpqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na' cate ḻa' gwchežte jean' da' gwchope. Nach jayze'e Pedron' can' gož Jesúsen' ḻe': “Biṉa' cuež jean' c̱hop ṉi'a cate' gac šoṉ ṉi'a bi c̱hebo' še nombi'o neda'.” Na' cate' jayze'ede' can' gož Jesúsen' ḻe', na' gwcheže'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ca gwyeni', bx̱oz gwnabia' ca' besežague' len beṉe' gole blao ca' chesenabi'e nación c̱heton' na' len beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés na' len yezica'chle beṉe' gwnabia' ca'. Na' bosoc̱heje' Jesúsen' na' gosec̱he'ene' jasesane'ne' ḻo na' Pilato ben' nac gobernador. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaton' gwṉabde'ne', gože'ne': ―¿Len' naco' rey c̱he beṉe' Israel? Jesúsen' boži'e xtižen', gwne': ―Can' gwnao'na', can' naquen. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na' bx̱oz gwnabia' ca' da' zan da' bosocuiše'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nach Pilaton' da' yoble gwṉabde'ne', gože'ne': ―¿Bi choži'o xtiža'gaquen'? ḻe da' zan da' chosocuiše' le'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Perw Jesúsen' bitw bi gwne'. Na' Pilaton' bebande' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na' gota' costumbr, Pilaton' gwsane' to beṉe' de ḻižya caten' chaḻa' ḻṉi pascw c̱he neto' beṉe' Israel, con to beṉe' yeseṉab beṉe' gualaž c̱heton'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","To beṉe' lie' Barrabás na' len yex̱oṉj bene' gosot beṉe' cate' besyedabague' gobierṉna' zjayo'e ḻo' ḻižya len nochle beṉe' güen da' mal. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nach besežag beṉe' na' goseṉabde' Pilaton' gwsane' to beṉe' con can' nac costumbr c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na' Pilaton' boži'e xtiža'gaquen' gwne': ―¿Chaclaže'le gwsana' rey c̱he le'e nacle beṉe' Israel? ");
INSERT INTO zpqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gwne' ca' ḻe gocbe'ede' dan' chesacxi'a bx̱oz gwnabi'a ca' Jesúsen', da'nan' bosodie' ḻe' ḻo ne'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Perw bx̱oz gwnabia' ca' bosota bosoṉe' beṉe' ca' že' na' cont goseṉabe' gwsane' Barrabás ben' de ḻižyan'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nach Pilaton' gwṉabde' ḻegaque': ―¿Bixe gona' len ben' žale nac rey c̱he le'e nacle beṉe' Israel? ");
INSERT INTO zpqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ḻegaque' bososya'adie' bosyoži'e xtižen': ―¡Bde'e ḻe'e yag cruz! ");
INSERT INTO zpqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaton' gože' ḻegaque': ―¿Bixe da' xiṉj nonen'? Nach ḻegaque' da' yoble bososya'achgüe' gosene': ―¡Bde'e ḻe'e yag cruz! ");
INSERT INTO zpqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nach Pilaton', cont bega'aṉe' güen len beṉe' ca', bsane' Barrabásen' can' goseṉabe'. Na' bene' mandadw gosot goseyin soldadw c̱he' ca' Jesúsen', nach beṉe' ḻe' ḻo na'gaque' cont yosode'ene' ḻe'e yag cruz. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nach soldadw ca' gosec̱he'ene' yeto latje dan' zoa chyo'o c̱he liž beṉe' gwnabian', na' bosotobe' yogo' soldadw ca', zjanac zane'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gosec̱hize' Jesúsen' to lache' moradw, na' gosone' to corona de xis yeše' bosozoen' yic̱hjen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na' gosezolagüe' chesonḻe' c̱he', chesosye'e: ―¡Viva, rey c̱he beṉe' Israel! ");
INSERT INTO zpqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na' bosozete' yic̱hjen' xis, bosoži'ene' xene', na' bosozoa xibe' gosone' ca beṉe' chesonxen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Beyož gosonḻe' c̱he', besyeyiṉe' lache' moradon' na' bosyoguacue'ne' xacze'. Nach gosec̱he'ene' cont jasede'ene' ḻe'e yag cruz. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na' šlac zjanc̱he'ene' gan' yesote'ne' besyežague' to beṉe' yež Cirene le' Simón, x̱a Alejandro na' Rufo, za' zeze'e yix̱e', na' bosogüe'ene' yag cruz c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gosec̱he'e Jesúsen' latje ga nzi' Gólgota, zeje dižan' Latje c̱he Žit Yic̱hj Beṉe' Guat. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na' goso'ene' vino da' nc̱hix̱e to nechw da' nzi' mirra, perw Jesúsen' bi goclaže' ye'ejen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nach bosode'ene' ḻe'e yag cruzen'. Na' soldadw ca' gosone' rifa cate' besyeḻe'e xaḻana' Jesúsen' cont bla' bi besyecheḻ to toe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cheda ga šezille caten' bosode'ene' ḻe'e yag cruz. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na' yic̱hj yag cruzen' bosozoe' dan' bosozoje' choen' diža' bixc̱hen' gosote'ne'. Qui nyojen, žan: “Rey c̱he Beṉe' Israel.” ");
INSERT INTO zpqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Txen len Jesúsen' ḻecze bosode'e ḻe'e yag cruz yec̱hope beṉe' gwban, toe' šḻa'a ḻicha, na' yetoe' šḻa'a robes. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na' da' gosone' ca', goc ca nyoj Xtiža' Diosen', žan: “Gosone'ne' ca beṉe' güen da' xiṉj.” ");
INSERT INTO zpqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na' beṉe' gosede gaḻa'ze gosezi'diže'ne', con chosota yic̱hje' gosene': ―Le' gwnao' yoc̱hiṉjo' yodaon' na' šoṉe žaze yeyontion'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bosla cuino' na' beyetj ḻe'e yag cruza'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ḻecze ca' bx̱oz gwnabia' ca' na' beṉe' ca' bososed bosolo'e dan' bzoj da' Moisés gosezi'diže'ne', na' gose' ḻježe': ―Bosle' beṉe' yoble, perw bi chac yosla cuine'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Le'echone' yeyetje' ṉa'a ḻe'e yag cruzen', nach šejḻe'cho naque' Cristo ben' gwlej Diosen' cont ṉabi'e chio' beṉe' Israel. Na' lente beṉe' ca' bosoda'lene' ḻe' ḻe'e yag cruz ca' gosezi'diže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cate' bžin guagwbiž, doxen yežlion' goc c̱hoḻ, bžinte cheda šoṉe. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na' ca hora' Jesúsen' gwṉe' zižje gwne': ―Eloi, Eloi ¿lama sabactani? ―zeje diža': Dios c̱hia', Dios c̱hia', ¿bixc̱hen' ba gwlejyic̱hjo' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na' baḻ beṉe' ca' zjanita' na' gosende' na' gosene': ―Ḻe gwzenag, choḻ güiže' da' Elías, ben' be' xtiža' Dios cani'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nach to beṉe' ca' gwyejsese' na' bzažede' to esponja vino zic̱hj na' bzoen' to lao xis toṉe nach jažiguen' cho'a Jesúsen' cont xopen', na' gwne': ―Cuezcho, yešque güid Elíasen' yeḻetje' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nach Jesúsen' bosye'e zižje, na' gote'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na' lache' da' ze ḻo' yodao' blaon' bcheza' gachoḻen, gwza'te yic̱hjen bžinte che'eḻe. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na' x̱an soldadw ca' zie' lao Jesúsen', na' cate' bende' can' bosye'en na' ble'ede' can' goten', gwne': ―Da' ḻi ḻe bengan' goc dogualje Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ḻecze baḻ no'ole zjanite' zito'le cheseṉe'e. Na' len ḻegaque' zjanita' María no'ole Magdala, na' Salomé, na' María xṉa' Jacobo beṉe' naše'te, na' ḻecze goque' xṉa' José. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","No'ol qui gosa'ogüe' Jesúsen' na' gosaclene' ḻe' cate' chsed chlo'ede' beṉe' ca' že' distritw Galilea. Na' yezanch no'ol zjanita' na', beṉe' ja'aclene' ḻe' txen Jerusalén. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Žana' goquen žan' bososiṉi'e par ža c̱he Dios cate' bi de ḻsens yesone' žin. Na' cate' ba chxoa gwbiž, ");
INSERT INTO zpqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","to beṉe' le' José, beṉe' ciuda Arimatea, beyaxjde' gwyeje' lao Pilaton' na' jayṉabe' cuerp c̱he Jesúsen'. José goque' to beṉe' zaque' lao beṉe' ca' gosenabi'e nación Israel c̱heton', na' ba zoe' chbeze' batcan' solao ṉabia' ben' seḻa' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaton' bebande' dan' ba gote', na' goxe' x̱an soldadw ca' cont gwṉabde' ḻe' še da' ḻi ba gote'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na' cate' x̱an soldadw ca' gože' ḻe' ḻe can' ba goc, Pilaton' bnežjue' latje beyoa' Josén' cuerp c̱he' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nach Josén' gwzi'e to lache' xen, beḻetje' cuerp c̱he Jesúsen' na' bolažen' ḻen. Na' ḻa' jaseḻo'ote' ḻe' to ḻo' bloj da' nc̱he'eṉe' ḻe'e yej xen, na' bḻoḻe' to yej cho'a blojen' cont bseyjon ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na' María no'ole Magdalan' len María xṉa' Josén' besele'ede' gan' bosocuaše'nen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cate' gwde ža c̱he Diosen', María no'ole Magdalan', María xṉa' Jacobo, na' Salomé gosezi'e da' chḻa' zix̱ cont šjaselo'en cuerp c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na' šezildao' ža dmigw besežine' cho'a ban', cate' za' chla' gwbiž. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na' za' yesežine' gose' ḻježe': ―¿Noxe ca'a yej xen dan' da' cho'a blojen'? ");
INSERT INTO zpqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Perw cate' besežine' na' goseṉe'e, besele'ede' yej xen dan' da' cho'a blojen' ba bga'an. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nach goso'e ḻo' blojen', na' besele'ede' chi' to beṉe' xcuide' šḻa'a ḻicha, nyaze' to lache' toṉ da' šiš. Na' besežebe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na' bena' gože'ne': ―Bitw žeble. Cheyiljwle Jesús beṉe' Nazaret ben' bosode'e ḻe'e yag cruz. Perw ba bebane'; notoch no nḻa' nga. Ḻe ṉa' gan' gosex̱oe'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ḻe šjaya'ac na' ḻe ye' beṉe' ca' gosaque' ḻe' txen, na' len Pedron', gwyobech Jesúsen' yežine' Galilea clel ca ḻegaque'. Na' Galilean' na' yesele'ede'ne' can' gwnacze'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nach no'ol ca' chosyoxoṉjsese' besyeya'aque' cho'a blojen', ḻe chesexiztite' besežebe'. Na' notno gose'e ca', ḻe besexožde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Beyož beban Jesúsen' ladjo beṉe' guat ca' šezildao' ža dmigw, Jesúsen' blo'elagüe' da' nechw len María no'ole Magdalan', ben' bebeje' gaž da' x̱igüe' yo'o nyaze'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na' María nga jatix̱jue'ede' beṉe' ca' ba gosenita' len ḻe'. Zjanita'yaše' na' chesebeže' cate' bžine'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na' cate' gosende' be'e diža' mban Jesúsen' na' gosende' be'e dižan' can' ba ble'ede'ne', bi gosejḻe'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Beyož goc ca', c̱hop beṉe' ca' gosaque' Jesúsen' txen zjangüe'e nez yix̱e' cate' Jesúsen' blo'elagüe' ḻegaque', na' nža'le besele'ede'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ḻecze ḻegaque' ja'aque' jasedix̱jue'ede' beṉe' yezica'chle, perw ṉeca gosejḻe'e c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Gwdena' beṉe' šnej ca' gwlej Jesúsen' cont zjanaque' ḻe' txen zjachi'e cho'a mes chesagüe' cate' blo'elagüe' len ḻegaque'. Na' gwdiḻe' ḻegaque' da' bi chesejnilaže' ḻe' do yic̱hj do laže' na' zjanaque' laždao' c̱hac̱h, ḻe bi gosejḻe'e c̱he beṉe' ca' besele'ede'ne' ba bebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na' gože' ḻegaque': ―Ḻe šja'ac doxen yežlio, na' ḻe šjatix̱jue'e diža' güen c̱hia' len yogo'ḻoḻ beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Beṉe' ca' yesejnilaže' neda' na' yesezoe' nis, gata' yeḻa' mban c̱hegaque' toḻi tocaṉe. Perw beṉe' bi chesejnilaže' neda', yesebiaye'e. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na' beṉe' ca' chesejnilaže' neda', yesyega'aṉlene' da' qui: Yeso'e la' na' yesyebeje' da' x̱igüe' yo'o nyaz beṉe'; yeseṉie' diža' cobe da' bi zjansede'; ");
INSERT INTO zpqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","na' še yesox̱e' no beḻ znia, o še yese'eje' da' nac venen, bibi yesacde'; na' ḻecze yesex̱oa taque' yic̱hj beṉe' chese'e na' yesyeyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Beyož bšaljlene' ḻegaque', X̱ancho Jesúsen' begüe' yaba, na' gwchi'e cuit Diosen' šḻa'a ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na' beṉe' ca' zjanaque' ḻe' txen besežaše' na' jasedix̱jue'ede' diža' güen c̱he' doxen. Na' cuin X̱ancho Jesúsen' goclene' ḻegaque' gosone' yeḻa' guac cont gosejḻe' beṉe' ḻe nac da' ḻi dižan' goso'en. Da' na'zen' chzoja'.");
INSERT INTO zpqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Teófilo, naco' beṉe' zaca' na' chzoja' le' diža' quinga cont ṉezdo' da' ḻi ca nac da' ba bosozejni'ide' le' c̱he da' ca' ba gosac. Beṉe' zan bac̱h bosozoje' c̱he Jesúsen', goso'e diža' c̱he da' ca' bene', con can' bosozejni'i beṉe' ca' neto', beṉe' ca' besele'ede' can' gwzolaon cate' goljte Jesúsen'. Na' beṉe' ca' gosende' na' besele'ede' can' goquen' bososed bosolo'ede' beṉe' yoble diža' güen c̱he'. Na' neda' cate' beyož gwṉabyoža' can' goquen' na' gwyazlaža' gwzojan' tcho'a cont ṉezdo', Teófilo. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ca tiemp caten' gwnabia' rey Herodes distritw gana' nzi' Judea, na' gwzoa to bx̱oz c̱he beṉe' Israel ca' beṉe' le Zacarías. Bene' žin len to x̱oṉj bx̱oz beṉe' zjale Abías. Na' no'ol c̱he Zacarías le Elisabet, na' naque' diaža c̱he da' bx̱oz Aarón. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na' Zacarías len Elisabeten' zja'accze' to ḻicha len Diosen' na' gosonyaṉe' yogo'ḻoḻ da' non X̱ancho Diosen' mandadw da'na' nyoj ḻe'e ley c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na' nono xi'iṉgaque' nita' ṉec̱he Elisabeten' naque' no'ol güiž. Na' chopte' ba zjanaque' beṉe' gole. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na' goquen' beyaḻa' Zacaríasen' len beṉe' ḻježe' ca' beṉe' ca' zjanaque' bx̱oz cont yesone' da'na' besyeyaḻe' yesone' yesonxene' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na' bx̱oz ca' yogo' ṉi'a chesone' rifa cont chata'bia' noe' choj gwzeye' yal ḻo' yodao' blao c̱hegaque' gan' chesonxene' X̱ancho Diosen'. Na' bchoj Zacaríasen' caten' gosone' rifan' bzeye' yala' ḻo' yodao'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na' šlac bzeye' yala' gosenita' yogo'ḻoḻ beṉe' zan ca' chyo'ole bosoḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na' to angl beṉe' gwseḻa' X̱ancho Dios blo'elagüe' Zacaríasen', na' gwzecha angla' cuit mesa' ḻichale gan' chosozeye' yala'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Na' cate' ble'e Zacaríasen' anglen', benit bec̱hoḻ ḻo' yic̱hjlažda'ogüe' na' bžebchgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Perw anglen' gože' ḻe': ―Bitw žebo' Zacarías. Diosa' ba bzenague' c̱he dan' gwṉabdo'ne', na' no'ol c̱hio' Elisabeten' sane' to xi'iṉo', na' gwsi'obe' Juan. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na' so' mbalaz na' yebedo' na' ḻecze beṉe' zan yesyebede' še ba goljbe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gacbe' to beṉe' blao lao Diosen'. Bitw ye'ejbe' vino ṉe bichle da' chzože beṉe'. Na' cate' za' galjtebe' ba yo'o Spiritw c̱he Diosa' ḻo' yic̱hjlažda'obe' ṉabi'an ḻebe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na' gombe' cont zan beṉe' Israel ca' yosoša' yic̱hjlažda'ogüe' na' yesonxene' X̱ancho Diosen' can' cheyaḻa' yesonxene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na' cuialaobe' lao X̱anchon', na' soa Spiritw c̱he Diosen' len ḻebe' can' gwzoan len da' Elíasen', na' ḻecz ca' yeḻa' guac c̱he Diosen'. Na' beṉe' ca' bi nita' binḻo len xi'iṉe' ca', gombe' ga yesenite' binḻo len ḻegacbe', na' beṉe' güedenag ca' gombe' yosozenague' c̱he Diosen'. Gombe' cont yesenita' beṉe' yesonxene' X̱anchon' cate' yide'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nach Zacaríasen' gože' anglen': ―¿Nac gac ṉezda' da' nga? Neda' naca' beṉe' gole na' ḻecz ca' no'ol c̱hian' ba naque' beṉe' gole. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nach anglen' gože' ḻe': ―Neda' naca' angl Gabriel beṉe' za' yaba. Zoa' len Diosen' na' chonxena'ne', na' gwseḻe' neda' zedetix̱jue'eda' le' diža' güen qui. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Le' bi gac ṉio' ṉa'a, ḻe bi chejḻi'o xtiža' nga. Cate' žin ža gac da' nga, cana' gac yeṉio' da' yoble. Na' da' ḻi gwžin ža gac can' gwnia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na' beṉe' ca' že' chyo'ole chesebeze' Zacaríasen' besyebande' da' gwžede' ḻo' yodao' blaona'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na' cate' bechoj Zacaríasen', bene' señw len ne'e da' bi goc ṉie'. Nach gosacbe'e beṉe' ca' ble'ebande' ḻo' yodao'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na' cate' beyož bdelaze' dan' bene' žin ḻo' yodao'na', beyej liže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gwde na' no'ol c̱he' Elisabeten' gwchendao' bidaon' ḻo' ḻe'e. Na' gayo' bio' gwzoaze'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na' gwne': ―Güenchguan' ba ben X̱ancho Diosen' len neda'. Ba bžin ža beži'ilaže'de' neda', cont bich yeson beṉac̱ha' xbab bibi zaca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Goc x̱op bio' noa' Elisabeten' bidaon', Diosen' beseḻe' anglen' ben' le Gabriel, gwyeje' to yež da'na' nzi' Nazaret gan' mbane distritw Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gwseḻe' ḻe' gan' zoa to no'ol güego' le' María. Na' Marían' napši'ichgua cuine'. Na' to beṉe' le' José bac̱h naquen gwšagna'lene' ḻe' cont gaque' xo'ole'. Na' Joséna' naque' diaža c̱he rey David ben' gwzoa cani'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na' bžin to angl beṉe' za' yaban' gwyo'e gan' zoa María na' gože'ne': ―Patiox. X̱ancho Diosen' nži'ide' le' na' zoe' len le'. Na' gone' cont so' mbalazch ca yogo'ḻoḻ no'ole yezica'chle. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cate' ble'e Marían' anglen', bebanchgüede' ca nac dižan' dan' gože' ḻe'. Na' bene' xbab bi zejen dan' gwne' caten' bguape'ne' tiox. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na' anglen' gože'ne': ―Bitw žebo' María, Diosen' nži'ide' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ṉa'a gua' xi'iṉo' to bi' byo dao', na' sano'be', na' go'o labe' Jesús. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Na' Jesúsen' gaque' to beṉe' blao na' beṉac̱hen' yososi'ene' Xi'iṉ Dios, Dios ben' naque' ḻa'zelagüe beṉe' blao. Na' X̱ancho Diosen' gone' cont ṉabi'e nación Israel c̱hele ca gwnabia' da' x̱ozxta'ogüe' rey David. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na' ḻe' ṉabi'e nación Israelen' toḻi tocaṉe, na' gwbat te yeḻa' gwnabia' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nach gož Marían' angla': ―¿Nacxe gac sana' bdaon'? Bitw nžaga' beṉe' byo. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nach gož angla' ḻe': ―Spiritw c̱he Diosen' yiden gana' zo'na', na' yeḻa' guac c̱he Diosa' soan len le', Dios ben' naque' ḻa'zelagüe beṉe' blao. Da'nan' bidaon' za' galje gacbe' laždao' xilaže' na' yososi'ebe' Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na' beṉe' xṉa'o Elisabeten' ḻecze bac̱h gwchendao' bidao' ḻo' ḻe'e ḻa'czḻa' ba naque' beṉe' gole. Ba goc x̱op bio' no'e to bi' byo dao', ḻen gosene' naque' no'ole güiž. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bibi de da' ṉacho da' cbi gac gon Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nach gož Marían' anglen': ―Ni zoa' naca' xmos X̱ana' Diosen'. Gacšca c̱hia' con can' ba gwnao'. Nach beza' anglen' gan' zoa Marían'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gwde na' ḻa' gwyejte Marían' to yež da' žia to ḻo ya'a gan' mbane distritw Judean', ");
INSERT INTO zpqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","na' bžine' liž Zacaríasen'. Na' gwyo'e bguape' Elisabeten' tiox. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na' cate' Elisabeten' bende' choḻ güiž Marían' ḻe', nach gocbe'ede' chxite' chžia bidaon' ḻo' ḻe'e. Na' Spiritw c̱he Diosen' gwnabian' yic̱hjlaždao' Elisabeten' ");
INSERT INTO zpqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na' gwṉe' zižje da' bebechgüede', gože' Marían': ―Zo' mbalazch ca yogo'ḻoḻ no'ole yezica'chle. Na' ḻecze bidaon' no'ona' soabe' mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Chebanda' le' naco' xṉa' X̱ana' zedeṉa'o neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Con cate' benda' chguapo' neda' tiox, bidao' c̱hian' ḻecze bebebe', bxite' bžiabe' ḻo' ḻian'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Zo' mbalaz da' gwyejḻi'o gac can' gwna xtiža' Diosen' dan' gož anglen' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nach Marían' gwne': Chonxena' X̱ancho Diosen' do yic̱hj do laža'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na' do yic̱hj do laža' chebechgüeda' Dios ben' bebeje' neda' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ba beyaše'de' neda' naca' xmose' ḻa'czḻa' bibi zaca'. Na' ṉa'a beṉe' yesenita' toḻi tocaṉe yesene' neda' zoa' mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios ben' chac chon da' nono gac gon ba bene' da' güen juisyw len neda'. Toz ḻen' naque' beṉe' laždao' xilaže' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Na' note'teze beṉe' chesape' ḻe' bala'aṉ do yic̱hj do laže', Diosen' cheži'ilaže'de' ḻegaque'. Cheži'ilaže'de' beṉe' že' ṉa'a na' yeži'ilaže'de' xi'iṉ diaža c̱hegaque' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bac̱h blo'e Diosen' beṉac̱hen' yeḻa' guac c̱he'. Na' ba bolague' beṉe' ya'laže' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ba bene' cont beṉe' gwnabia' ca' bich yesenabi'e. Na' beṉe' bi naque' beṉe' blao, Diosen' ba bnežjue' latje yesaque' beṉe' blao. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na' beṉe' chesedon, Diosen' ba bnežjue' ḻegaque' da' zan da' güen. Na' beṉe' gwṉi'a ca', ba bose'e ḻegaque', bibi bonežjue' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nach ba goclene' chio' beṉe' Israel naccho ca xmose'. Ba blo'ede' bitw ganḻaže' chio', san ba cheyaše' cheži'ilaže'de' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ba bene' can' gože' da' Abraham len yezica'chle da' x̱ozxta'ocho. Na' soacze' yeyaše' yeži'ilaže'de' xi'iṉ diaža c̱he da' Abrahanṉa' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na' cate' ba goc šoṉe bio' zoa Marían' len Elisabeten', nach Marían' beyej liže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na' cate' bžin ža san Elisabeten', gwzane' bi' byo dao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na' cate' goseṉeze beṉe' gualiž c̱hegaquen' na' diaža c̱hegaquen' X̱ancho Diosen' ba beyaše' beži'ilaže'de' Elisabeten', nach besyebechgüede' len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na' goc x̱ono' ža goljbe' na' jasezoe'be' señw dan' že' circuncisión can' gosone' len yogo' bi' byo dao' bi' gosaljbe' ḻo diaža c̱he da' Abraham. Na' gosaclaže' si' labe' Zacarías can' le x̱aben', ");
INSERT INTO zpqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","perw xṉa'be' gwne': ―Bi gac. Cheyaḻa' si'be' Juan. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na' ḻegaque' gose'ene': ―Notno diaža c̱hele nita' beṉe' zjale ca', ṉeca x̱ozxta'ole. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na' gosone' señw goseṉabde' x̱aben' nac che'nde' si' labe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nach bene' señw gwṉabe' to yagla' dao' da' bzoje': “Si' labe' Juan.” Na' yogüe' besyebande'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Beyož bzoje' da'na', ḻa' gocte beṉie', nach ḻa' gwzolaote be'e diža' benxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na' besyebane beṉe' gualiž c̱hegaquen'. Na' xtiža'gaquen' gos gwlaljen doxen yež ca' zjachi' ḻo ya'ana' gan' mbane distritw Judean'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na' yogo'ḻoḻ beṉe' gosende' dižan' gosone' xbab ḻo' yic̱hjlažda'ogüe' c̱he da' ca', na' gosene': ―¿Bixe gon bdao'na'? Gosene' ca' ḻe goseṉezde' zoacze X̱ancho Diosen' len ḻebe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nach gwnabia' Spiritw c̱he Diosen' yic̱hjlaždao' Zacaríasen', nach be'e xtiža' Diosen', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Chonxena' X̱ancho Dios ben' chonxen chio' beṉe' Israel. Cheyaše' cheži'ilaže'de' chio' naccho nación c̱he' na' ba chseḻe' beṉe' yebej chio' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Na' bena' bac̱h za' cont yebej chio' ḻo da' malen', naque' beṉe' gwnabia' gual, na' naque' xi'iṉ diaža c̱he da' rey David ben' goc xmos Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chac can' gwna Diosen' len cho'a da' beṉe' ca' gwseḻe' cani', beṉe' gosac ḻo ne'e goso'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ba za' ben' gwne' yosle' chio' ḻo na' yogo' beṉe' chesegue'e chio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chac can' gože' da' x̱ozxta'ocho ca' yeyaše' yeži'ilaže'de' ḻegaque'. Bi chanḻaže', san chone' yogo' da' ba gwne' gone' gaclene' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Diosen' chone' can' gwlo'e da' baḻi lao da' x̱ozxta'ocho da' Abraham gože'ne' gaccze can' gwnen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Gwne' yosle' chio' ḻo na' beṉe' chesegue'ede' chio'. Nach gac lažda'ochon' xilaže' lao ḻe' na' gonxenchone' sin cbi žebcho, na' šejcho ḻicha gonxenchone' šlac de yeḻa' mban c̱hecho. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nach Zacaríasen' gože' bdao' c̱hen': Bdao' c̱hia', beṉac̱h yesene' c̱hio' naco' beṉe' choe' xtiža' Dios, Dios ben' naque' ḻa'zelagüe beṉe' blao. Yesene' ca' da' cuialaguo' lao X̱anchon' na' go'o xtižen' cont ṉita' beṉe' yosozenague' c̱he' cate' yide'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gwsed gwlo'edo' neto' can' chaclaže' Diosa' yebeje' chio' naccho nación c̱he' ḻo da' mala' na' yezi'xene' xtoḻa'chon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diosen' cheyaše' cheži'ilaže'de' chio', ḻe ḻen' gwlo'e be'ni' c̱he' ḻo' laždao' chio' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Cue'e be'ni' c̱he' ḻo' yic̱hjlaždao' chio' naccho ca beṉe' chaš ga nac c̱hoḻ, chio' chžebcho gatcho. Na' gwzejni'ide' chio' beṉac̱h naquen' soa cuezcho yežlio nga. Can' be' Zacaríasen' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na' Juanṉa' zej chcha'obe' zejte chac yic̱hjlažda'oben' can' chazlaže' Diosen'. Na' jasoe' latje daš. Na'ate zoe' cate' gwzolagüe' gwdix̱jue'ede' xtiža' Diosen' len beṉe' Israel ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na' ḻecz šlac gwnabia' rey César Augusto, bene' mandadw gwyas to censo cont ṉezde' baḻ beṉe' že' to to yež da' zjachi' doxen yežlio gan' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na' ḻecz cana' Cirenio naque' gobernador gan' nzi' Siria. Na' naquen da' nechw bc̱heḻe' baḻ beṉe' že' to to yež. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na' yogo'ḻoḻ beṉe' jaya'aque' lažgaque' jasyede cuent cuine' cont bosoc̱heḻe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na' José naque' diaža c̱he da' rey David. Da'nan' beze'e Nazaret gan' mbane distritw Galilea, beyeje' yež Belén dan' nac laž da' rey David. Na' chi' yež Belén gan' mbane distritw Judea. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Beyeje' jayde cuine' cuent na' zenc̱he'e no'ol c̱he' Marían' perw biṉa' yeseca'a ḻježe'. Na' Marían' ba no'e bdao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na' šlac nite' Belén bžin ža sane'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na' gwxane' bi' nechw, to bi' byo dao', na' btobe'be' lache' na' gwlo'ebe' ga chesagw beyix̱e', da' bich bi latje yo'o mesónṉa' par ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na' že'na' yix̱e' c̱he yež Belén na'ate že' beṉe' güeyoe xila' chesape' xila' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na' to angl beṉe' gwseḻa' X̱ancho Diosen' bžine' gan' nita' beṉe' güeyoe xila' ca', na' be'ni' c̱he X̱ancho Diosa' gwyec̱hjen bseṉin' gan' nite'na'. Na' besežebchgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na' gož angla' ḻegaque': ―Bitw žeble. Ṉa'a chix̱jue'eda' le'e to diža' güen da' yesebechgüe yogo'ḻoḻ beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ṉa'aža ḻo yež c̱he rey David ba golje bena' gac yebeje' beṉac̱hen' ḻo da' mal. Naque' Cristo, na' zeje diža' naque' ben' gwseḻa' Dios cont ṉabi'e, na' ḻecze naque' X̱ancho. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cont yeželele bdao'na', quinga naquen: bdao'na' ba ntobe'be' lache' na' debe' gan' chesagw beyix̱e' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Beyož gwna angla' ca' ḻa' besežinte beṉe' zan angl gan' zoa angl nechua', za'aque' gan' zoa Diosen'. Na' chesonxene' Diosen' chesene': ");
INSERT INTO zpqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Chonxencho Diosa' ben' zoa yaba, na' ḻo yežlio yesezoa yesebez beṉac̱hen' binḻo, con bena' cheson can' chazlaže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na' cate' besyeya'ac angl ca' zjaya'aque' yaba, na' beṉe' güeyoe xila' ca' gose' ḻježe': ―Yeyejcho Belén šjayṉa'cho dan' ba goc can' nac dan' gwseḻa' X̱anchon' angl quinga bedesedix̱jue'ede' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na' beseya'acses beṉe' güeyoe xila' ca' jaya'aque' Belén. Na' besyeželde' Marían' len Josén' na' len bdao'na'. Na' bdao'na' debe' gan' chesagw beyix̱e' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Beyož besele'ede' can' ba goquen, na' goso'e diža' c̱he bdao'na' len beṉe' ca' yezica'chle ca nac dan' gož anglen' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na' yogo'ḻoḻ beṉe' ca' gosende' diža' dan' gosoe' beṉe' güeyoe xila' ca' besyebande'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na' ḻecze Marían' gwlo'o yic̱hje' yogo'ḻoḻ diža' dan' gosoe' beṉe' güeyoe xila' ca' na' bene' xbab ḻo' yic̱hjlažda'ogüe' bi zejen. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nach besyeya'ac beṉe' güeyoe xila' ca' chesonxene' Diosen'. Na' cheso'e diža' nacchgua Diosen' beṉe' güen da' ba goc yogo'ḻoḻ da' ba gosende' na' besele'ede' dan' gož anglen' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cate' goc x̱ono' ža golje bdao'na' jasezoe'be' señw da'na' nzi' circuncisión, na' bososi'e labe' Jesús, can' ben anglen' mandadw cate' za' gua' Marían' ḻebe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na' cate' gwde ba beyac Marían' xilaže' len bdao'na' con can' bzoj da' Moisésen', nach ja'aque' ciuda Jerusalén goseḻene'be' jasesane'be' lao X̱ancho Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gosone' can' nyoj ley c̱he' dan' ža: “Yogo' bi' byo dao' bi' nechw cheyaḻa' gacbe' ḻo na' Dios.” ");
INSERT INTO zpqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nach gosonxene' Diosen', gosone' can' ža ley c̱he X̱ancho Dios dan' žan: “Cheyaḻa' gotle c̱hop ngolbex o c̱hope plomxtil.” ");
INSERT INTO zpqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na' Jerusalénṉa' gwzoa to beṉe' le' Simeón. Benan' gwyejcze' bene' da' güen lao Diosen' na' benxene' ḻe', na' gwleze' batcan' yid Cristo ben' seḻa' X̱ancho Diosen' cont yebeje' beṉe' Israel ca' ḻo da' mal. Na' Spiritw c̱he Diosen' gwyo'on ḻo' yic̱hjlaždao' Simeón, ");
INSERT INTO zpqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","na' bzejni'in ḻe' bi gate' še biṉa' le'ede' Criston'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na' Spiriton' benen cont gwyeje' yodao' blaona', na' zoe' yodao'na' cate' besežin x̱axṉa' Jesúsen' zjano'ebe' cont yesone' len ḻebe' can' non ley c̱hegaquen' mandadw. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nach Simeónṉa' gwḻene'be' nach benxene' Diosen', gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","X̱ana' Dios, bac̱h goc can' gwnaon'. Beṉ latje yeyeda' binḻo gana' zo'na', neda' naca' xmoso'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ba ble'eda' bena' zedyelej neto' ḻo da' mal. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Naque' beṉe' gwnalažo' gwseḻo' ṉec̱he yogo'ḻoḻ beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na' cue'e be'ni' c̱he' ḻo' yic̱hjlaždao' beṉe' cbi zjanaque' beṉe' Israel. Na' gaque' ḻa'zelagüe beṉe' zaca' len neto' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nach x̱aben' len xṉa'ben' besyebande' ca diža' c̱hebe' dan' be' Simeónṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na' Simeónṉa' gwṉabde' Diosen' cont gac güen c̱hegaque'. Na' gože' Marían': ―Beṉe' Israel ca' yesejnilaže' xi'iṉo' nga yesenite' mbalaz, na' beṉe' Israel ca' cbi yesejnilaže'ne' bi yesenite' mbalaz. Zedelo'ede' beṉac̱hen' can' chaclaže' Diosen' goncho, perw zane' bi yesejḻe'e c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nach Diosen' gwlo'e non' chzenag c̱he' na' non' cbi chzenag. Na' cacze chac ga chaz cwšiyw gac ḻo' yic̱hjlažda'oguon' catequen' žaglaguo' len da' gac c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na' ḻecze yodao' blaona' gwzoa to no'ole le Ana, na' cho'e xtiža' Diosen'. Naque' xi'iṉ da' ben' le' Fanuel na' naque' diaža c̱he da' Aser. Bšagne'e cate' naque' no'ol güego', perw na' gaž izga gwzoalene' beṉe' c̱he' na' gote', na' bga'aṉe' güezebe. Na' Anan' ba naque' to beṉe' gole, ");
INSERT INTO zpqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","taplalj tap izde'. Bicze chechoje' yodao' blaona'. Ḻeca chonxene' X̱ancho Diosen' do ža do yel, gwzoatie' tgüeje bene' gwbas na' con gwzoachgüe' boḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na' goquen' gwbiga' Anan' gan' zoa Josén' len Marían' ḻo' yodao'na' na' be'e yeḻa' chox̱clen c̱he Diosen' bac̱h gwseḻe' Jesúsen'. Na' be'e diža' c̱he Jesúsen' len yogo' beṉe' ca' že' Jerusalén ben' chesebeze' batca' seḻa' Diosen' ben' yebeje' ḻegaque' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nach Josén' len Marían' cate' beyož gosone' yogo'ḻoḻ dan' non ley c̱he X̱ancho Diosen' mandadw yesone', jaya'ac lažgaque' Nazaret gan' mbane distritw Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na' Jesúsen' zej chcha'ogüe' na' zej chc̱hac̱hlaže'. Na' ca zej chcha'ogüe' na' zej chejni'ichde', na' Diosen' nži'ilaže'de'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Na' x̱axṉe'e ca' yogüiz chja'aque' ḻṉi da' chaḻa' Jerusalén chjaseze'ede' can' goc cate' Diosen' betue' bi' nechw c̱he yogo' beṉe' Egipto na' bosle' beṉe' Israel. Šižiṉw ize Jesúsen' cate' gosec̱he' x̱axṉe'en ḻe' ja'aque' ḻṉin' Jerusalén. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na' cate' gwde ḻṉina' besyeya'aque', perw Jesúsen' bega'aṉe' ciuda Jerusalén. Na' xṉe'ena' len Joséna' bi gosacbe'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Con gosacde' ba zjayde' txen len beṉe' ca' nžaggaque'. Na' tža nez ba gosa'aque' cate' gwzolao chesyeyiljue'ne' ladjo diaža c̱hegaque' na' no beṉe' xmigüe', ");
INSERT INTO zpqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","perw bitw besyeželde' ḻe'. Nach besyebi'e jaya'aque' Jerusalénṉa' da' yoble cont šjasyediljue' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na' beyoṉ žach besyeželde' Jesúsen' chašil yodao' blaona', chi'e gachoḻ beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisés. Jesúsen' chzenague' xtiža'gaquen' na' zanen chṉabde' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na' yogo'ḻoḻ beṉe' ca' chosozenague' xtiža' Diosen' da' cho'e chesyebande' can' chejni'ide' na' can' choži'e xtiža' beṉe' ca' zjansed dan' bzoj da' Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na' cate' besele'e x̱axṉe'en ḻe', besyebande', na' xṉe'en gože' ḻe': ―Xi'iṉdagua', ¿bixc̱hen' chondo' neto' ca'? X̱ao' nga na' neda' ba gwdato' beyiljwto' le', na' da' juisyw ba ble'eto'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesúsen' gože' ḻegaque': ―¿Bic̱hen' beyiljwle neda'? ¿Bi ṉezele liž X̱a' ngan' cheyaḻa' soa'? ");
INSERT INTO zpqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Perw x̱axṉe'e bitw gosejni'ide' bi zejen dan' gože' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na' beyeje' yež Nazaret len x̱axṉe'e bzenague' c̱hegaque'. Na' gwlec yic̱hj xṉe'ena' yogo'ḻoḻ dan' goca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na' ca' chac zej chejni'iche Jesúsen' na' zej gwcha'oche', na' Diosen' len beṉac̱ha' zej chesazlaže'che' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cate' ḻo iz šino' dan' chnabia' César Tiberio doxen ga mbane nación Roma, izna' goc Poncio Pilato gobernador c̱he distritw Judea, na' goc Herodes gobernador c̱he distritw Galilea. Na' beṉe' biše' Herodesen', ben' le Felipe, goque' gobernador c̱he distritw Itorea na' c̱he distritw Traconite. Na' goc Lisanias gobernador c̱he distritw Abilinia. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nach ḻecze izna' Anás na' Caifás gosacche' bx̱oz blao c̱he beṉe' Israel. Izna' Juan ben' naque' xi'iṉ Zacarías gwzoe' to latje daš. Nach Diosen' be'lene' Juanṉa' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na' Juanṉa' gwyeje' yogo'ḻoḻ yež dan' nita' gaḻa'ze yegw Jordán, jatix̱jue'ede' yogo'ḻoḻ beṉe' cheyaḻa' yesyetiṉjde' xtoḻa'gaque' na' yesezoe' nis cont ṉitlao xtoḻa'gaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juanṉa' bene' dan' bzoj da' Isaías ben' be' xtiža' Diosen' cani'te, gana' žan: Bena' chṉe' zižje latje dašen', že': “Ḻe gonšagüe' yic̱hjlažda'olen' cont soale gwzenagle c̱he X̱anchon' cate' yide', ḻe cuejyic̱hj da' malen' chonḻe cont yic̱hjlažda'olen' gaquen ca to nez da' ba gosonšagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gwžin ža cate' yogo' ya'a yegw ca' yesyeyaquen laše', na' no nez da' nacchgua bxoca' yesyeyaquen ḻicha, na' no nez da' nžaš nche'eṉe yesyeyaquen ba'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na' yogo'ḻoḻ beṉe' yesacbe'ede' can' chaclaže' Diosen' yebeje' beṉac̱hen' ḻo da' mal.” ");
INSERT INTO zpqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na' beṉe' zan ja'aque' gan' gwzoa Juanṉa' cont gwzoe'ne' nis. Na' Juanṉa' gože' ḻegaque': ―Le'e nacchguale beṉe' zgot na' beṉe' gwxiye'. ¿Chaquele guac yelale lao castigw dan' seḻa' Diosen' caten' gone' yeḻa' justis c̱he beṉac̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Še da' ḻi ba betiṉjele xtoḻa'le, cheyaḻa' gonḻe da' nac güen cont yesacbe'e beṉe' ba boša' yic̱hjlažda'olen'. Na' bitw gonḻe xbab gaquele Diosen' bitw gone' le'e castigw c̱he xtoḻa'len' lagüe da' nacle xi'iṉ diaža c̱he da' Abrahanṉa'. Bitw ṉacho ḻeca chyažje Diosen' le'e. Guac gone' cont yej quinga yesyeyaquen xi'iṉ diaža c̱he da' Abrahanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ca nac le'e, še bi chonḻe can' chazlaže' Diosen', zaca'leble ca to yag frut da' bibi chbia. Na' yogo'te yag frut da' bibi chbia, c̱hog x̱an yaga' ḻen na' gwzeyen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nach beṉe' ca' chosozenag xtiže'na' goseṉabde' Juanṉa', gose'ene': ―¿Bica' da' cheyaḻa' gonto'? ");
INSERT INTO zpqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na' gože' ḻegaque': ―Ben' nape' c̱hope camis cheyaḻa' gwnežjue' ton c̱he beṉe' bi de c̱he'. Na' ḻecze ca' c̱he ben' de da' gagüe', cheyaḻa' gwnežjue' c̱he ben' bi de gagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na' cate' to c̱hope beṉe' güec̱hixjw ca' jasebigue' cont gwzoa Juanṉa' ḻegaque' nis, na' gose'ene': ―Maestrw, ¿bica' da' cheyaḻa' gonto'? ");
INSERT INTO zpqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na' gože' ḻegaque': ―Bitw gwc̱hixjwchle ca da' cheyaḻa' yeseyixjue'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na' to c̱hope beṉe' ca' zjanac soldadw ḻecze goseṉabde' ḻe', gose'ene': ―¿C̱hix neto'? ¿Bica'ch da' cheyaḻa' gonto'? Na' Juanṉa' gože' ḻegaque': ―Bitw ca'ale da' de c̱he beṉe', na' ṉeca gonḻaže'le len da' yosbague'le beṉe' cont ca'ale xmechwgaque'. Ḻe gon banez len laxjwle. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na' beṉe' ca' gosezoe' lez yid Cristo ben' naquen seḻa' Diosen' yedeṉabi'e, na' gosacde' še Juanṉa' naque' Cristo. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na' Juanṉa' gocbe'ede' xbab c̱hegaquen' na' gože' yogo'ḻoḻe': ―Neda' da' ḻi chzoa' le'e nis, perw za' yid bena' gon cont soa Spiritw c̱he Diosen' ḻo' yic̱hjlažda'olen' ṉabian' le'e. Na' Spiriton' naquen ca yi', na' gwxi gwloan yic̱hjlažda'ole. Bena' za' za' zaca'che' ca neda', na' da' nacchgüe' beṉe zaca' bitw zaca' gona' xmandadoe' ḻec̱hja' no xele'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Benan' gone' len beṉac̱hen' can' choncho cate' chdecho trigon' ḻo' rner. Chtobcho trigon' chgo'ošagüe'chon na' chzeycho yix beben'. Na' beṉe' chesejnilaže' Diosen', yotobe' ḻegaque' cont šjasyenite' txen len ḻe', na' beṉe' bi chesejnilaže' ḻe', seḻe' ḻegaque' ḻo yi' gabiḻen' dan' cbi cheyol chenit. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Da' zanch da' gwna Juanṉa' gwdix̱jue'ede' ḻegaque' diža' güen, na' gwṉeyoede' ḻegaque' yesejḻe'en. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nach Juanṉa' gwdiḻe' gobernador Herodes ca nac da' mal da' bene' beque'e Herodías ca xo'ole', ḻe Herodíasna' naque' xo'ole Felipe beṉe' biše' Herodesen'. Na' Juanṉa' ḻecze be'e diža' yogo'ḻoḻ da' mal dan' ba ben Herodes. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na' Herodesen', gualaz da' gwzenague' c̱he Juanṉa', benche' yeto da' mal, gwlo'e Juanṉa' ḻižya. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nach šlac chzoa Juanṉa' beṉe' nis, beṉe' zan ja'ac cont bzoe' ḻegaque' nis. Na' len Jesúsen' gwzoe' nis. Na' ḻo hora' Jesúsen' boḻ güiže' Diosen' na' ḻa' byaljwte yaba gan' zoa Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na' betj Spiritw c̱he Diosen' bžinen gwzoan len ḻe', na' ca hora' Spiriton' naquen ca to ngolbex. Na' gosende' gwṉe Dios ben' zoa yaban', gwne': ―Le' naco' Xi'iṉa' beṉe' chacchgüeda', na' chebe chezaquelaže'chgüeda' c̱hio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na' ca do šichoa ize Jesúsen' cate' gwzolao bene' yogo'ḻoḻ da' zedeyene'. Na' beṉe' ca' gwnita' na' gosone' xbab še naque' xi'iṉ Joséna'. Josén' naque' xi'iṉ Elí, ");
INSERT INTO zpqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na' Elí naque' xi'iṉ Matat, na' Matata' naque' xi'iṉ Leví, na' Levína' naque' xi'iṉ Melqui, na' Melquin' naque' xi'iṉ Jana, na' Janan' naque' xi'iṉ yeto ben' le' José. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Na' Joséna' naque' xi'iṉ Matatías, na' Matatíasen' naque' xi'iṉ Amós, na' Amósen' naque' xi'iṉ Nahum, na' Nahunṉa' naque' xi'iṉ Esli. Na' Eslin' naque' xi'iṉ Nagai, ");
INSERT INTO zpqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na' Nagain' naque' xi'iṉ Maat, na' Maata' naque' xi'iṉ Matatías, na' Matatíasen' naque' xi'iṉ Semei, na' Semein' naque' xi'iṉ José, na' Josén' naque' xi'iṉ Judá. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Na' Judán' naque' xi'iṉ Joana, na' Joanan' naque' xi'iṉ Resa, na' Resan' naque' xi'iṉ Zorobabel, na' Zorobabelen' naque' xi'iṉ Salatiel, na' Salatielen' naque' xi'iṉ Neri, ");
INSERT INTO zpqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na' Nerin' naque' xi'iṉ Melqui, na' Melquin' naque' xi'iṉ Adi, na' Adin' naque' xi'iṉ Cosam, na' Cosanṉa' naque' xi'iṉ Elmodam, na' Elmodanṉa' naque' xi'iṉ Er. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Na' Era' naque' xi'iṉ Josué, na' Josuén' naque' xi'iṉ Eliezer, na' Eliezeren' naque' xi'iṉ Jorim, na' Jorinṉa' naque' xi'iṉ Matat. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Na' Mataten' naque' xi'iṉ Leví, na' Levín' naque' xi'iṉ Simeón, na' Simeóna' naque' xi'iṉ Judá, na' Judán' naque' xi'iṉ José, na' Josén' naque' xi'iṉ Jonán, na' Jonánṉa' naque' xi'iṉ Eliaquim. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Na' Eliaquinṉa' naque' xi'iṉ Melea, na' Melean' naque' xi'iṉ Mainán, na' Mainánṉa' naque' xi'iṉ Matata, na' Matatan' naque' xi'iṉ Natán. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Na' Natánṉa' naque' xi'iṉ David, na' Davida' naque' xi'iṉ Isaí, na' Isaín' naque' xi'iṉ Obed, na' Obeda' naque' xi'iṉ Booz, na' Boozen' naque' xi'iṉ Salmón, na' Salmónṉa' naque' xi'iṉ Naasón. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na' Naasónṉa' naque' xi'iṉ Aminadab, na' Aminadaba' naque' xi'iṉ Aram, na' Aranṉa' naque' xi'iṉ Esrom, na' Esronṉa' naque' xi'iṉ Fares. Na' Faresen' naque' xi'iṉ Judá, ");
INSERT INTO zpqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na' Judán' naque' xi'iṉ Jacob, na' Jacoben' naque' xi'iṉ Isaac, na' Isaaquen' naque' xi'iṉ Abraham, na' Abrahanṉa' naque' xi'iṉ Taré, na' Tarén' naque' xi'iṉ Nacor. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na' Nacoren' naque' xi'iṉ Serug, na' Seruga' naque' xi'iṉ Ragau, na' Ragaun' naque' xi'iṉ Peleg, na' Peleguen' naque' xi'iṉ Heber. Na' Heberen' naque' xi'iṉ Sala, ");
INSERT INTO zpqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na' Salan' naque' xi'iṉ Cainán, na' Cainánṉa' naque' xi'iṉ Arfaxad, na' Arfaxaden' naque' xi'iṉ Sem, na' Senṉa' naque' xi'iṉ Noé, na' Noén' naque' xi'iṉ Lamec. ");
INSERT INTO zpqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Na' Lamequen' naque' xi'iṉ Matusalén, na' Matusalénṉa' naque' xi'iṉ Enoc, na' Enoca' naque' xi'iṉ Jared, na' Jareden' naque' xi'iṉ Mahalaleel. Na' Mahalaleela' naque' xi'iṉ Cainán, ");
INSERT INTO zpqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na' Cainánṉa' naque' xi'iṉ Enós, na' Enósen' naque' xi'iṉ Set, na' Seta' naque' xi'iṉ Adán, na' Adánṉa' naque' xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na' Spiritw c̱he Diosen' gwnabian' yic̱hjlaždao' Jesúsen'. Na' Jesúsen' beze'e cho'a yegw Jordán, na' Spiritua' benen cont gwyeje' latje daš. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","C̱hoa ža gwzoe' latje dašen' na' lao c̱hoa žan' bicze bi gwdagüe'. Na' cate' gwde c̱hoa žan' gwdone'. Na' Satanás dan' chnabia' da' x̱igüe' ca' goclažen' co'oyeḻan' ḻe' cont gone' da' mal. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nach gož Satanásen' ḻe': ―Še le' naco' Xi'iṉ Dios, gož yej nga yeyaquen yetextil. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na' gož Jesúsen' ḻen: ―Nyojcze Xtiža' Diosa' žan: “Gague yeḻa' guagw na'zen' chyažje chio' beṉac̱h cont gac bancho, san ḻecze chyažjecho yogo'ḻoḻ diža' dan' ža Diosen'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na' gwc̱he' Satanásen' ḻe' to ḻo ya'a sibe na' bedao'nez blo'en ḻe' yogo'ḻoḻ nación da' zjachi' yežlio. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nach gožen ḻe': ―Doxen yeḻa' gwnabia' da' de yežlio nga naquen ḻo na' cont gwnežjuan' con no che'nda'. Še le' gwzoa xibo' gonxeno' neda', nach goṉa' le' yeḻa' gwnabia' c̱he nación ca' zjachi' yežlio nga na' len yeḻa' zaca' yeḻa' xdan c̱he nación ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nach Jesúsen' gože' Satanásen': ―Becuas ca'ale Satanás. Nyojcze Xtiža' Diosen' žan: “Cheyaḻa' šejnilaže'cho X̱ancho Diosen' na' toz ḻe' gonxencho.” ");
INSERT INTO zpqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nach Satanásen' gozc̱he'en ḻe' ciuda Jerusalén. Na' bcuen ḻe' yic̱hjo' yodao' blao gan' nac ḻa'zelagüe sibe, na' gožen ḻe': ―Še len' naco' dogualje Xi'iṉ Dios, nga boslažo' cuino', ");
INSERT INTO zpqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ḻe nyojcze Xtiža' Diosen', žan: Seḻa' Diosen' beṉe' ca' zjanac angl c̱he' yesaclene' le' na' yesape' le', ");
INSERT INTO zpqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","yesox̱e' le' cont bi c̱hego' no yej. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nach Jesúsen' gožen': ―Ḻecz ca' nyoj Xtiža' Diosen' žan: “Bitw goncho X̱ancho Diosen' prueba še lede' can' žen'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Beyož gota'bia' bi gwzoe Satanásen' co'oyeḻan' Jesúsen' gone' da' mal, nach becuasen šlož len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nach Jesúsen' beyeje' distritw Galilea, na' yeḻa' guac c̱he Spiritw c̱he Diosen' gwzoan len ḻe'. Na' yogo'ḻoḻ beṉe' že' yež ca' zjachi' doxen Galilea goseṉezde' c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na' Jesúsen' bsed blo'ede' ḻegaque' ḻo' yodao' c̱hegaquen', na' yogo'ḻoḻ beṉe' ca' gosonxene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na' bežin Jesúsen' yež Nazaret gan' gwcha'ogüe', na' gwyo'e yodao' ža c̱he Dios can' ba yolagüe' chone', na' gwzechede' cont gwlabe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na' ben' yo'o ḻo ne'e yodao'na' bnežjue'ne' yiš da' ndobe gan' nyoj dan' bzoj da' Isaías ben' be' Xtiža' Diosen' cani'te. Na' Jesúsen' bzaše' yišen' na' beželde' ga nyojen žan: ");
INSERT INTO zpqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Zoa Spiritw c̱he Diosa' len neda', na' Diosen' gwleje' neda' zedeya' diža' güen len beṉe' yaše'. Na' gwseḻe' neda' zedeyena' cont yesyeyaclaže' beṉe' ca' chesacyaše'de'. Na' za'a cont gwsana' beṉe' ca' zjade ḻižya. Na' zedeyena' cont yesyele'e beṉe' lc̱hoḻ. Na' beṉe' chyi chzaca', zedeyena' cont noch no yosoc̱hi yososaque' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na' zedetix̱jue'eda' ba bžin ža gaclen Diosen' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesúsen' botobe' yišen' na' bonežjuen' ben' yo'o ḻo ne'e yodaon' na' gwchi'e. Na' yogo' beṉe' ca' nita' yodaon' ḻa' goseṉa'tie' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nach gwzolao be'e diža' gwne': ―Ža ṉa'aža ba chac can' ža Xtiža' Diosen' dan' ba benele nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na' yogo' beṉe' ca' gosende' diža' dan' be'e besyebande' catec mba nac xtiža' Jesúsen'. Na' goseṉie' güen c̱he' na' gose' ḻježe': ―¿Gague benga xi'iṉ Josén'? ");
INSERT INTO zpqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nach gož Jesúsen' ḻegaque': ―Ye'ḻjale neda' can' ža diža' dan' de: “Beṉe' güen rmed le', beyon cuino'.” Na' ḻecze ye'ḻjale neda': “Dan' chesene' beno' yež Capernaum da' bebane beṉe', ḻecz can' cheyaḻa' gono' lažcho nga.” ");
INSERT INTO zpqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nach goze'e ḻegaque': ―Da' ḻi chnia' le'e, beṉe' gualaž c̱he note'teze beṉe' choe' xtiža' Diosen' bitw chesezi'e c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ca tiemp c̱he da' Elías ben' be' xtiža' Diosen' cani', bibi yejw goc šoṉ iz yo gašje na' goc gwbin juisyw c̱hegaque' doxen gan' zelao mbane Israel. Naquen da' ḻi gwnita' zan no'ol güezebe yež ca' gan' mbane Israel ca tiempa', ");
INSERT INTO zpqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","perw Diosen' bi gwseḻe' Elíasen' cont gaclene' ṉe to beṉe' güezeb ca'. Gwseḻe' ḻe' yeto yež yoble gan' nzi' Sarepta gan' mbane ciuda Sidón cont goclene' to no'ol güezebe. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na' ḻecz ca' tiemp c̱he da' Eliseo ben' be' xtiža' Diosen' cani', gwnita' zan beṉe' Israel beṉe' gosacšene len yižgüe' da' nzi' lepra. Ṉe to ḻegaque' bi beyon Eliseon'. Toz beṉe' zito' beṉe' Siria, ben' le' Naamán, beyon Eliseon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na' yogo' beṉe' ca' že' yodao'na' cate' gosende' dan' gwna Jesúsen' beseža'achgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na' ḻa' besyezoža'te' na' besyebeje' Jesúsen' yežen', na' gosec̱he'ene' to ḻo ya'a da' zoa gaḻa'ze, gosaclaže' yososlažoe'ne' ḻo ya'a na'ate, ");
INSERT INTO zpqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","perw bibi goc yesonde' ḻe'. Con beza' Jesúsen' bedie' gachoḻ gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na' jasoe' yež Capernaum gan' mbane Galilean', na' ža c̱he Dios bsed blo'ede' beṉe' ca' že' ḻo' yodao'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na' beṉe' ca' besyebande' ca nac dan' bsed blo'eden', ḻe bzejni'ide' cacze to beṉe' ṉezde' cayaṉen' nac xbab c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ḻo' yodao'na' gwzoa to beṉe' yo'o nyaze' da' x̱igüen'. Na' bosye'e gwne': ");
INSERT INTO zpqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿Bixc̱hen' chgoša' chlaže' c̱hio' len neto', Jesús beṉe' Nazaret? ¿Zedežiayo'o neto'? Neda' nombi'a le' na' ṉezda' naco' beṉe' laždao' xilaže' juisyw ben' gwseḻa' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nach Jesúsen' gwdiḻe' da' x̱igüen' na' gožen': ―¡Sšago'! Bechoj yic̱hjlaždao' benga. Na' bchix̱ da' x̱igüen' bena' gachoḻ beṉe' ca' že'na' nach bechojen. Perw bitw benen ḻe' zi'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na' ḻeca besyebane yogo' beṉe' ca', nach gose' ḻježe': ―¿Bixen' chac? ¿Bixe da' coben' chlo'e benga? Nacbia' nape' yeḻa' chnabia' na' yeḻa' guac, ḻe chone' mandadw na' ḻa' chechojte da' x̱igüe' da' yo'o nyaz beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na' ca nac dan' ben Jesúsen' gos gwlalje dižan' doxen lagüe yež ca' zjachi' do na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na' cate' beze'e yodao'na', na' gwyeje' liž Simón. Na' taobi'iṉ c̱he Simónṉa' chacšende', yo'e da' ḻa. Na' bosoḻ güiže' Jesúsen' cont yeyone' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na' Jesúsen' gwzeche' cuite' gan' die', na' bcheque' gwdiḻe' da' ḻan' cont bechojen. Nach taobi'iṉ c̱he Simónṉa' ḻa' gwyastie' na' bsiṉi'e da' gose'ej gosagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na' cate' ba chxoa gwbižen' gosec̱he'e con yogo' beṉe' chese'e yižgüe' jasesane' ḻegaque' lao Jesúsna'. Na' Jesúsen' gwx̱oa ne'e yic̱hj to toe' na' beyone' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na' ḻecz ca' bebej Jesúsen' da' x̱igüe' da' yo'o yic̱hjlaždao' beṉe' zan. Na' besyechojen goseṉen zižje, gosenan: ―Le' naco' Xi'iṉ Dios. Na' Jesúsen' gwdiḻe' ḻegaquen na' bitw be'e latje bi yesenan, ḻe goseṉezen naque' Cristo ben' gwlej Diosen' cont yedeṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na' beteyo cate' gwye'ni', beze'e na' beyeje' to latje ga nono nḻa'. Na' beṉe' ca' besyeyiljue'ne' na' ja'aque' gan' zoen'. Na' gosaclaže' yosozague' Jesúsen' cont bi yeze'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na' Jesúsen' gože' ḻegaque': ―Ḻecz ca' beṉe' ca' nita' yež yoble cheyaḻa' šjalo'eda'ne' cont yosozenague' c̱he Diosen' na' ṉabi'e yic̱hjlažda'ogaque'. Diosen' gwseḻe' neda' cont šjatix̱jue'eda' ḻegaque' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ca' goquen', Jesúsen' gwde' to to yež c̱he distritw Galilea na' bsed blo'ede' beṉe' ca' ḻo' yodao' c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na' šlac zecha Jesúsen' cho'a nisdao' da'na' nzi' Genesaret, besežag beṉe' zan na' bosoc̱hite' Jesúsen' da' gosaclaže' yosozenague' xtiža' Diosen' dan' bi'e cho'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na' Jesúsen' ble'ede' c̱hope barcw dao' cho'a nisdaon'. Na' beṉe' gwxen beḻ ca' ba besyežaše' ḻo' barcon' ba chesyeyibe' yix̱jw beḻ c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na' Jesúsen' gwyo'e ḻo' barcw c̱he Simónṉa' na' gwṉabde' ḻe' bosožigue' barcon' yelate' ḻo' nisen'. Na' Jesúsen' gwchi'e ḻo' barcon' blo'ede' beṉe' ca' že'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cate' beyož bi'e dižan' na' gože' Simónṉa': ―Ḻe gwžiga'ch barcon' yelate' gan' nac sitjw, na' ḻe gwzaḻa' yix̱jw c̱helen' na' senḻe beḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nach Simónṉa' gože' Jesúsen': ―Maestrw, ba bento' žin do yel na' ṉe to nono bdoḻa'. Perw le' ba gwnao' yezolaoto', na' gwzala'to' yix̱jw ca' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na' beyož bosozaḻa' yix̱jw c̱hegaquen' zjanyicoco'ten beḻen', yeleze ca yesyecheza'ten. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na' beṉe' ca' zjanita' ḻo' barcw c̱he Simónṉa' gosone' señw gosaxe' beṉe' ḻježen' že' yeto ḻo' barcw yoble cont yesaclene' ḻegaque' yesyebeje' yix̱jon'. Yelez ca gwdebe nisen' chopte barcw ca' dan' gosegüe'e beḻ zan ḻo'enṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nach Simónṉa', ben' ḻecz le' Pedro, cate' ble'ede' da'na' goquen' na' bzoa xibe' lao Jesúsen' gože' ḻe': ―X̱ana', neda' naca' to beṉe' mal, bibi zaca' par so' nga len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gwne' ca' ḻe ḻe' txen len beṉe' ḻježe' ca' že' ḻo' barcon' besyebanchgüede' da' gosezene' beḻ zanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ḻecz ca' besyebane xi'iṉ ben' le Zebedeo, zjanac c̱hop biše'tie', Jacobo len Juan. Beṉe' ca' chesone' žin len Simónṉa'. Nach Jesúsen' gože' Simónṉa': ―Bitw žebo'. Le' naco' beṉe' gwxen beḻ, na' chebejo' beḻen' ḻo' nisen'; perw ṉa'a gona' cont gaxle beṉe' yesyechoje' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na' cate' besyežinḻene' barcon' yo biž, nach gosebejyic̱hje' barcon' len yogo' xšinḻaže' ca' na' ja'aclene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na' šlac Jesúsen' zoe' to yež na' bžin to beṉe' che'ede' to yižgüe' dan' nzi' lepra. Na' bena' cate' ble'ede' Jesúsen', bzoa xibe' lagüe' na' boḻ güiže'ne' gože'ne': ―X̱ana', še chaclažo', guac yeca'o yižgüe' dan' che'eda' nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nach Jesúsen' bḻi ne'e na' gwx̱oen' yic̱hje' na' gože' ḻe': ―Chaclaža' yeyacdo'. Beyaque. Nach ḻa' bega'ate yižgüe' dan' che'eden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nach Jesúsen' bene' mandadw gože' ḻe' notno ye'e can' ba beyone' ḻe'. Na' gože' ḻe': ―Con gwyej jaṉa' bx̱oza' cont le'ede' bac̱h beyacdo'. Na' bnežjo da' cheyaḻa' gwnežjo' dan' non Moisésen' mandadw cont yeyaco' xilaže' len ley c̱he Diosen'. Ben ca' cont yogo' beṉe' yeseṉezde' ba beyacdo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na' tža tža gos gwlalje diža' ca nac yeḻa' guac dan' ben Jesúsen'. Na' besedob beṉe' zan cont bosozenague' xtiža' Jesúsen' na' cont beyone' ḻegaque' len bite'teze yižgüe' da' chese'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nach Jesúsen' bchoje' to ši'i güeje jaḻ güiže' Diosen' to latje daš. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nach to ža zoa Jesúsen' to yo'o gan' chsed chlo'ede' beṉe'. Na' gaḻa'ze zjanita' zan beṉe' Israel beṉe' zjanzi' fariseo. Na' ḻecze zjachi' yeto cuen beṉe' ca' chososed chosolo'ede' dan' bzoj da' Moisés. Beṉe' ca' že'na' za'aque' yogo'ḻoḻ yež ca' gan' mbane distritw Galilea len distritw Judea, na' ḻecze baḻe' za'aque' ciuda Jerusalén. Na' bosozenague' diža' da' be' Jesúsen'. Na' yeḻa' guac c̱he X̱ancho Diosen' zoan len Jesúsa' na' beyone' beṉe' güe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na' besežin x̱oṉj beṉe' zjanḻene' to beṉe' xiṉj, beṉe' bi chda šḻa'a ṉi'a ne'e, zjanx̱oe' ḻe' to ḻo cam dao'. Na' gosaclaže' yesedie' šjasesane' ḻe' lao Jesúsa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na' da' že'chgua beṉe' zan bi goc latje yesedie' šjasesane' beṉe' güen' lao Jesúsen'. Nach beṉe' ca' gosepe' yic̱hjo'ole gosesaljue' goseque'e tej na' beseḻetje'ne' len xcame'na' gachoḻ beṉe' ca' že' ḻo' yo'ona' cont bžine' lao Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Cate' gocbe'e Jesúsen' gosejnilaže' ḻe' na' gože' beṉe' güe'na': ―Xi'iṉa', ba bezi'xena' xtoḻon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na' beṉe' ca' chososed chosolo'e dan' bzoj Moisésa' na' beṉe' fariseo ca' gosene': ―¿Non' chaque benga naque' chṉe' ca'? Chon cuine' ca Dios. Ḻe nono zoa beṉe' gac yezi'xene' xtoḻa' beṉac̱hen'. Toz Diosen' gac yezi'xenen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesúsen' gocbe'ede' ca nac da' cheseza'laže' na' gože' ḻegaque': ―¿Bic̱hena' chza'laže'le ca' ḻo' yic̱hjlažda'ole? ");
INSERT INTO zpqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Še yapa'ne': “Ba bezi'xena' xtoḻo'na'”, bi ṉezele še napa' yeḻa' gwnabia' cont yezi'xena' xtoḻe'na'. San še yapa'ne': “Gwyas na' gwda”, na' nacbia' še napa' yeḻa' guac gac can' gwnian'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ṉa'ach gona' cont gacbe'ele napa' yeḻa' gwnabia' cont yezi'xena' xtoḻa' beṉac̱h, neda' naca' bena' gwseḻa' Diosen' golja' beṉac̱h. Nach gože' beṉe' xiṉja': ―Chapa' le' beyas, beyoa' xcamon', na' beyej ližo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nach ḻa' beyaste beṉe' xiṉja', cheseṉa'te beṉe' ca' nita'na'. Nach beyoa' xcamen' na' beze'e zjayda liže' chonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na' yogo'ḻoḻ beṉe' ca' že'na' besyebande' yeḻa' guac c̱he Jesúsen' dan' bene'na'. Nach gosonxene' Diosen', na' do chesežebe' gose' ḻježe': ―Da' yebanecho da' ca' ba ble'echo ṉa'aža. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gwdena' beza' Jesúsen' na' ble'ede' to beṉe' güec̱hixjw beṉe' le' Leví, chi'e latje gan' chc̱hixjue'. Na' Jesúsen' gože' ḻe': ―Da len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nach gwzoža' Levín' gwlejyic̱hje' yogo' xšinḻaze' na' gwyejlene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nach Levína' bene' to ḻṉi xen ližen' par Jesúsen', na' ja'ac beṉe' zan beṉe' güec̱hixjw ca' na' beṉe' yezica'chle na' gosebe'lene' ḻe' cho'a mesen' gosagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na' beṉe' ca' chososed chosolo'ede' dan' bzoj Moisésen' na' len beṉe' fariseo ca' gosacyožlene' beṉe' ca' zjanaque' Jesúsen' txen, gose'e ḻegaque': ―¿Nacxec̱hen' che'ej chagwle txen len beṉe' güec̱hixjw na' yebaḻe beṉe' güen da' xiṉj ca'? ");
INSERT INTO zpqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesúsen' gože' ḻegaque': ―Beṉe' cbi chesacšene bitw cheseyažjde' beṉe' güen rmed. Beṉe' ca' chesacšene, ḻegaquen' cheseyažjde' beṉe' güen rmed. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Gague beṉe' ba zjanaque' beṉe' güen len Diosen' zedeṉeyoeda' cont yesyetiṉjde' xtoḻen', san beṉe' güen da' xiṉj. Ḻegaque' zjanaque' ca beṉe' cheseyažjde' beṉe' güen rmed. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nach baḻ beṉe' gose'e ḻe': ―Beṉe' ca' zjanaque' txen len Juan na' beṉe' zjanaque' txen len beṉe' fariseo ca' chesonchgüe' gwbas chosoḻ güiže' Diosen'. Perw na' beṉe' ca' zjanaque' le' txen chese'ej chesagüe'. ¿Bixc̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nach gož Jesúsen' ḻegaque': ―¿Guac yesezoa gwbas beṉe' chaxe' to ga chac yeḻa' güešagna' šlac ben' bšagnan' zoalene' ḻegaque'? Bi gac. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Perw žin ža cate' bich soe' len ḻegaque', cana'ch yesone' gwbas. Na' ca'cze naquen len neda' na' len beṉe' ca' zjanaque' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na' Jesúsen' be'e jempl nga bzejni'ide' ḻegaque': ―Notno zoa beṉe' c̱heza' xe' da' cobe na' yode'en de'ex̱o'. Še gone' ca' gwžiaye'e xe' da' coben' na' xe' de'ex̱on' bitw gac leben len lache' coben'. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na' ṉeca zoa beṉe' chgue'e vino cobe ḻo' bzod yide'ex̱o', ḻe vino coben' chšon' yide'ex̱on' na' ḻalje vino na' yesebiayi' chopen. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cheyaḻa' yesegue'e vino coben' ḻo' yid cobe cont bibi gaquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na' ca nac beṉe' bac̱h yolagüe' che'eje' vino golen', bitw ye'nde' ye'eje' vino coben', san že': “Vino golen' nacchen güen.” ");
INSERT INTO zpqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na' to ža nac ža c̱he Dios, Jesúsen' gwdie' gan' nyaž trigw len beṉe' ca' zjanaque' ḻe' txen. Nach beṉe' ca' zjanaque' ḻe' txen goseḻec̱hje' trigon' na' gosexoben' gosagüen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na' besele'e baḻ beṉe' fariseon' can' gosone' na' gose'e ḻegaque': ―¿Bic̱hen' chonḻe da' bi de ḻsens goncho ža c̱he Dios? ");
INSERT INTO zpqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na' Jesúsen' gože' ḻegaque': ―¿Biṉa' gwlable can' ben da' rey David to ža cate' ḻe' na' beṉe' ḻježe' ca' gosedone'? ");
INSERT INTO zpqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gwyo'o Davin' liž Dios na' jax̱i'e yetextil da' nac c̱he Dios da' bi chac gagw beṉe' bi nac bx̱oz, na' gwdagüen', na' ḻecze bnežjue' c̱he beṉe' zja'ac len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na' ḻecz ca' gwna Jesúsen': ―Naquen ḻo na' ṉia' bi da' nac güen goncho cate' nac ža c̱he Dios, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na' yeto ža c̱he Dios gozeje' ḻo' yodaon' na' bsed blo'ede' beṉe' ca' že'na'. Na' ladjo beṉe' ca' zjaže'na' yo'o to beṉe' nx̱o'oṉ taque' ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés na' beṉe' fariseo ca' chosogüia cheseṉe'e Jesúsen' še yeyone' bena' ža c̱he Dios cont de da' yosode'ede' yesagüe' xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na' gocbe'e Jesúsen' can' chesone' xbaben', na' gože' ben' nx̱o'oṉ taque': ―Gwzoža' na' gwzecha nga gachoḻ. Nach bena' bžine' gwzeche' lagüen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na' Jesúsen' gože' beṉe' ca' že'na': ―¿Bi da' cheyaḻa' goncho ža c̱he Dios? ¿Goncho da' güen, še goncho da' mal? ¿Cheyaḻa' yoslacho beṉe', še gwžiayi'chone'? ");
INSERT INTO zpqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesúsen' gwṉe'e yogo'te ben' že'na', nach gože' ben' nx̱o'oṉ taque': ―Bḻi naon'. Nach bḻien' na' taquen' beyaquen binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na' beṉe' ca' chososed chosolo'e leyna' na' len beṉe' fariseon' ḻeca beseže'e na' gwzolao bosoxi'e nacle yesone' len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na' to ža gwyej Jesúsen' to ḻo ya'a jeḻ güiže' Diosen'. Na' do yel be'lene' Diosen' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na' cate' gwye'ni', goxe' beṉe' ca' zjanaque' ḻe' txen, nach gwleje' šižiṉue' na' bsi'e ḻegaque' postlw. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Beṉe' qui gwleje': Simón ben' bsi'e Pedro, na' beṉe' biše' Andrés, na' Jacobo, na' Juan, na' Felipe, na' Bartolomé, ");
INSERT INTO zpqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na' Mateo, na' Tomás, na' Jacobo xi'iṉ Alfeo, na' Simón ben nac cananista, ");
INSERT INTO zpqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na' Judas beṉe' biše' Jacobo, nach Judas Iscariote ben' bdie' Jesúsen' ḻo na' beṉe' chesegue'ede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na' beyetje' ḻo ya'an len ḻegaque' na' gwzeche' ga nac to laše' len beṉe' ca' zjanaque' ḻe' txen. Na' ḻecze nita' beṉe' zan beṉe' za'ac doxen Judean', do ciuda Jerusalénṉa' na' do gan' mbane yež ca' zjanzi' Tiro na' Sidón. Na' Tiro len Sidón zjachin' cho'a nisdao'. Na' len beṉe' ca' nita' chosozenague' xtiža' Jesúsen' zjanc̱hix̱e baḻ beṉe' chese'e yižgüe'. Na' Jesúsen' beyone' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na' beṉe' ca' zjayo'o zjanyaz da' x̱igüen' yic̱hjlažda'ogaque', Jesúsen' bebejen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na' yogo' beṉe' goseyiljue' nacle yesone' cont yeselapa' na'gaquen' ḻe', ḻe goseṉezde' nape' yeḻa' guac cont yega'a yižgüe' c̱hegaquen' še yesecheḻe'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na' Jesúsen' gwḻis lagüe' gwṉe'e beṉe' ca' zjanaque' ḻe' txen na' gože' ḻegaque': ―Mbalaz zoa le'e beṉe' yaše', le'e chzenagle c̱he Diosen' cont chnabi'e yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Mbalaz zoa le'e chdonḻe ṉa'a, gwžin ža cate' bich tonḻe. ’Na' mbalaz zoa le'e chbežle ṉa'a, gwžin ža cate' gwxižle. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Na' mbalaz soale še dan' chejnilaže'le neda' chesegue'e beṉe' le'e, na' chesyebeje' le'e ḻo' yodao' c̱hegaque', na' cheseṉeye'e c̱hele, na' chesene' nacle beṉe' mal. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ḻe yebechgüe cate' chac da' quinga, na' ḻe soa mbalaz, ḻe Diosen' gone' cont gacchgua da' güen c̱hele cate' yežinḻe gan' zoe'na'. Can' chesonde' le'e, ca'czen' goson da' x̱ozxta'ogaque' len da' beṉe' ca' goso'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Na' nyaše'chguaze nac le'e beṉe' gwṉi'a. Chac güen c̱hele ṉa'a, perw gague toḻi tocaṉen' gac c̱hele ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nyaše'chguaze nac le'e dechgua da' chagwle ṉa'a. Gwžin ža cate' bich bi gata' c̱hele. ’Nyaše'chguaze nac le'e chxižle ṉa'a. Gwžin ža cate' yegüine'le na' cuežyaše'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nyaše'chguaze nac le'e chesonxen yogo'ḻoḻ beṉe' le'e. Ca'czen' goson da' x̱ozxta'ogaque', gosonxene' beṉe' ca' goseziye'e gosene' cheso'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Le'e chzenagle c̱hia', cheyaḻa' gaquele beṉe' chesegue'ede' le'e. Cheyaḻa' gonḻe da' güen len beṉe' ca' chesegue'ede' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ḻe ṉab cont beṉe' chesegue'ede' le'e ṉite' mbalaz. Ḻe soa ḻe ṉabe Diosen' gaclene' beṉe' chososaca'zi' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Še to beṉe' c̱haze' šḻa'a x̱aga'le, ḻe güe' dan' yešḻa'a. Še to beṉe' que'e xadoṉ c̱hele, ḻe güe' latje ḻec̱hje' len xcamisle. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Note'teze beṉe' bi dan' ṉabde' le'e, ḻe gwnežjon. Še to beṉe' que'e bite'teze da' de c̱hele, bitw yeṉablen. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Con yogo' da' güen da' chaclaže'le yeson beṉac̱hen' len le'e, ḻecze ca' cheyaḻa' gonḻe len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Še chaquele šinze beṉe' chacde' le'e na' bi chaquele beṉe' yoble, ¿bixc̱hen' chaquele chebe Diosen' can' chonḻe? Ca'cze cheson beṉe' güen da' mal ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ḻecze še chonḻe da' güen len beṉe' ca' cheson da' güen len le'e na' bi chonḻe güen len beṉe' yoble, ¿bixc̱hen' chaquele chebe Diosen' can' chonḻe? Ca'cze cheson beṉe' güen da' mal ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Še chbejle bi da' chbejle len beṉe' chaquele yesyeyoṉen' le'e, ¿bixc̱hen' chaquele chebe Diosen' can' chonḻe? Ca'cze cheson beṉe' güen da' mal ca', chesebeje' bi dan' chesebej ḻježgaque', na' nite' lez yosyonežjuen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Perw na' le'e, ḻe soa ḻe gaque beṉe' chesegue'ede' le'e, na' ḻe soa ḻe gon da' güen. Na' ḻe soa ḻe cuej bi dan' cuejle, perw bitw soale lez yesyeyoṉen'. Še gonḻe ca dan' ba gwnia' le'e, gwlo'ele nacle xi'iṉ Dios ben' nac ḻa'zelagüe beṉe' blao, na' Diosen' güebi'icze' güen len le'e. Ḻe'na' naque' beṉe' šagüe' len beṉe' ca' bi cheso'e yeḻa' chox̱clen c̱he' na' len yezica'chle beṉe' güen da' mal ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na' ca X̱acho Diosen' ben' zoa yaba cheyaše' cheži'ilaže'de' yogo' beṉac̱hen', ca'cze cheyaḻa' yeyaše' yeži'ilaže'le ḻjež beṉac̱hlen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Bitw gonḻe xbab zaca'le ṉale beṉe' zjanape' doḻa'. Še ṉale c̱he beṉe' zjanape' doḻa', ca'cze Diosen' ṉe' le'e naple doḻa'. Na' bibi yosbaga'le beṉe' cont Diosen' bibi yosbague'de' le'e. Ḻe soa ḻe yezi'xen c̱he beṉe' cont Diosen' yezi'xene' c̱hele. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ḻe soa ḻe gwnežjo bi da' gwnežjwle beṉe' na' Diosen' güeyoṉcze' c̱hele. Baḻ beṉe' ḻeca naḻa' chosochix̱e' bi dan' chesote', chosoc̱hiše' lao yagarm c̱hegaquen' na' chesebiben' na' chosozoaya'aten'. Ca'czen' cheyaḻa' gonḻe gwnežjwle bi dan' cheseyažje beṉe' na' ḻecz ca' gon Diosen' len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nach Jesúsen' be'lene' beṉe' že'na' to jempl, gwne': ―¿Guaque to beṉe' lc̱hoḻ cue'e nez yeto beṉe' lc̱hoḻ? Bi gac. Ḻe ṉezecho chopte' šjasebix̱e' to ḻo' yechw. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ca nac cate' to beṉe' chsede' len to maestrw, bi ṉacho naque' beṉe' blaoch ca maestroa'. Na' ḻa'czḻa' še ben' chseda' gwda' yic̱hje' yogo'ḻoḻ dan' blo'e maestron' ḻe', bitw naque' beṉe' sina'ch ca maestroa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bixc̱hen' chṉa'le beb dao' dan' yo'o ḻo' yejlao beṉe' ḻježle, na' bi chacbe'ele naquech beb xen dan' yo'o ḻo' yejlaolen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na' še le'e yo'o to da' xen ḻo' yejlaolen' ¿nacxec̱hen' che'le beṉe' ḻježlen': “Beṉ yebeja' beb dao' dan' yo'o ḻo' yejlaguon'”? ¡Beṉe' güex̱oayag! Zgua'tec ḻe yebej beb xen dan' yo'o ḻo' yejlaolen', nach le'ele binḻo cont yebejle dan' yo'o ḻo' yejlao beṉe' ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Bitw ṉacho to yag frut güen chbian frut da' bi nac güen, na' ṉeca ṉacho dan' bi nac güen chbian da' nac güen. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Con can' nac da' chbia to to yaguen' ṉezecho bi yaga'. Yag yeše' bitw chbian da'na' nzi' yix̱güigw. Ḻecz ca' yag bisga'a bi chbian uvas. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","To beṉe' laždao' ži'ilaže' chone' da' güen, ḻe ca ža ḻo' yic̱hjlažda'ogüe' nan' chone'. Na' ben' chon da' mal, chone' ca' lagüe dan' chzenague' c̱he laždao' xi'a c̱he'na'. Na' yogo'te diža' dan' chchoj cho'achon', ḻo' yic̱hjlažda'ocho nan' za'aquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Bic̱hen' che'le neda': “X̱ana'”, na' bi chonle can' nona' mandadw? ");
INSERT INTO zpqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ṉa'a ṉia' nac zaca'lebe beṉe' nao' neda' na' chzenague' xtiža' na' chone' can' nona' mandadw. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naque' ca to beṉe' ben yo'o na' gwc̱he'eṉe' sitjw gwleque' lene yo'on da' nac da' gual. Cate' betjchgua yegw gwyec̱hjen liže'na', na' bitw bebix̱en cuiayin', ḻe gwzoac̱hac̱hchguan. ");
INSERT INTO zpqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na' yogo' beṉe' chende' xtiža'na' na' bi chone' can' žia'na' naque' ca yeto beṉe' ben yo'o, con benen' ḻo yo na'ze na' bibi lenen gwleque'. Na' cate' betjchgua yegw gwyec̱hjen liže'na', na' bebix̱en gwžiayi'te yo'on. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na' cate' beyož be' Jesúsen' diža' len beṉe' ca', beyeje' yež Capernaum. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na' zoa to x̱an soldadw beṉe' bitw naque' beṉe' Israel. Na' zoa to xmose' chacšenchgüede', na' yelez ba de' par gate'. Na' x̱an soldadon' chacchgüede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na' cate' x̱an soldadon' bende' diža' c̱he Jesúsen', gwseḻe' baḻ beṉe' gole blao c̱he beṉe' Israel cont jaseṉabde' Jesúsen' šeje' liže' yeyone' xmose'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nach cate' besežine' gan' zoa Jesúsen', goseṉabde' ḻe' gaclene' x̱an soldadon'. Na' gose'e Jesúsen': ―X̱an soldadon' naque' to beṉe' zaque' gacleno', ");
INSERT INTO zpqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ḻe chacde' chio' beṉe' Israel, na' ḻe' bene' yodao' c̱heto' nga len xmechue'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nach gwyej Jesúsen' len ḻegaque', perw za' yesežine' liže'na' cate' gwseḻa' x̱an soldadon' baḻ beṉe' migw c̱he' lao Jesúsen' na' gose'ene': ―X̱an soldadon' že' bitw gwša'a yic̱hjo' yido' liže'na', ḻe ṉezde' bitw zaque' cont šo' liže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Da'nan' bitw beyaxjde' yide' ṉabde' le' gacleno'ne'. Con che'nde' gonšco' mandadw yeyaque xmose'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","X̱an soldadon' že' zoa beṉe' chnabia' ḻe' perw ḻecze nita' soldadw c̱he' na' chnabi'e ḻegaque'. Na' cate' che'e toe': “Gwyej”, na' cheje', na' cate' che'e yetoe': “Da”, na' chide', na' cate' che'e xmosen': “Da' nga gono'”, na' chonen'. Na' ṉezde' con ṉao' yeyac xmose'na' na' yeyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na' Jesúsen' cate' bende' diža' dan' gose' beṉe' migw c̱he x̱an soldadon' ḻe', bebande' na' beyec̱hje' gože' beṉe' zan ca' zjanao' ḻe': ―Žia' le'e ṉe toze beṉe' Israel biṉa' šejnilaže' neda' ca chejnilaže' benga bi naque' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nach jaya'ac beṉe' ca' gwseḻa' x̱an soldadon'. Cate' besyežine' liže'na' ba beyaque xmosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesúsen' gwyeje' to yež dan' nzi' Naín len beṉe' ca' zjanaque' ḻe' txen na' zan beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ba zja'aque' gaḻa'ze par yesežine' cho'a puert c̱he yežna' cate' besele'ede' chesechoj x̱oṉj beṉe' cho'a puerten' zjanḻene' to beṉe' guat. Na' ben' goten' naque' beṉe' tliša', na' xṉe'en naque' no'ole güezebe. Na' beṉe' zan beṉe' ḻo yeža' zja'aclene' xṉa' beṉe' guaten'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na' cate' ble'e X̱anchon' no'olen', beyaše'de' ḻe' na' gože'ne': ―Bitw cuežo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nach gwyeje' jax̱oa ne'en ḻo yagla' gan' xoa beṉe' guata'. Nach beṉe' ca' zjanḻen ḻe' gosebeze'. Na' gože' beṉe' guata': ―Beṉe' güego', neda' žia', beyas. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nach beṉe' guaten' gwchi'e na' gwzolagüe' beṉie'. Na' Jesúsen' beyoṉe' ḻe' ḻo na' xṉe'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na' yogo'ḻoḻ beṉe' ca' besežebe' dan' beban beṉe' guata' nach gosonxene' Diosen' gosene': ―Ba bla' to beṉe' blao ga zoacho, beṉe' choe' xtiža' Diosen', na' Diosen' ba gwseḻe'ne' cont gaclene' chio' naccho nación c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ca nac dan' ben Jesúsen' gos gwlalj diža' c̱hen' doxen Judea na' yogo'ḻoḻ yež ca' dan' zjanita' gaḻa'ze. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nach beṉe' ca' zjanaque' txen len Juanṉa' jaseye'lene' ḻe' diža' yogo'ḻoḻ ca nac dan' chon Jesúsen'. Nach gox Juanṉa' c̱hope beṉe' ca' ");
INSERT INTO zpqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nach gože' ḻegaque': ―Ḻe šja'ac gan' zoa Jesúsen' na' ye'lne': “¿Len' naco' ben' chbezto' seḻa' Diosen' o še cheyaḻa' cuezchto' yid beṉe' yoble?” ");
INSERT INTO zpqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nach beṉe' ca' chope cate' besežine' gan' zoa Jesúsen' gose'ene': ―Juan ben' chzoa beṉe' nis gwseḻe' neto' laguo' nga ṉabeto' le' še len' naco' ben' chbezto' seḻa' Diosen' o še cuezchto' yid beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Šlacte ṉe' nita' chope beṉe' ca', Jesúsen' beyone' beṉe' zan beṉe' ca' chesacšene na' beṉe' chese'ede' yižgüe' gual. Ḻecze bebeje' da' x̱igüe' da' zjayo'o zjanyaz yic̱hjlaždao' beṉe' zan. Na' bene' cont besyele'e zan beṉe' lc̱hoḻ. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nach Jesúsen' boži'e xtiža' beṉe' ca' gwseḻa' Juanṉa' lagüe'na', gože' ḻegaque': ―Ḻe šjaya'ac na' ḻe šjayež Juanṉa' doxen da' ca' ba ble'ele na' da' ca' ba benele. Ba ble'ele chona' cont chesyele'e no beṉe' lc̱hoḻ, na' chesyeda no beṉe' zjanxiṉj ṉi'e. Na' ḻecze beṉe' gose'e yižgüe' dan' nzi' lepra besyeyacde', na' chesyeyene no beṉe' cuež. Ba ble'ele bosbana' no beṉe' guat, na' ba benele choa' diža' güen len beṉe' yaše' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mbalaz zoa beṉe' chejḻe'e c̱hia' na' bi chdebde'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na' cate' besyeya'ac beṉe' ca' gwseḻa' Juanṉa', nach Jesúsen' be'lene' beṉe' ca' zjandoben' xtiža' Juanṉa', gože' ḻegaque': ―¿Nacxe nac ben' jale'ele latje dašen'? ¿Šayic̱hj šayen chaque'? Bi naque' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Nac naque' caten' jale'elne'? ¿Nyaze' lache' šagüe'? ¿še bitw? ḻe beṉe' ca' zjanyaz lache' šagüe' na' chesenite' chese'ej chesagwšagüe' na' chesone' legr, bena' nita' yo'o güenchgua, ca no liž beṉe' gwnabia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Noxen' jale'ele? ¿Naque' to beṉe' choe' xtiža' Diosen'? Da' ḻi naque' to beṉe' choe' xtiža' Dios, perw chnia' le'e, zaca'che' ca note'teze beṉe' choe' xtiža' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","C̱he benga nyojen ḻe'e Xtiža' Diosen' žan: Neda' Dios seḻa' to beṉe' cuialagüe' laguo' güe'e xtižon' cont cate' yido' ba nita' beṉe' yesonxene' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chnia' le'e, notech no beṉac̱h ṉa' soa beṉe' naquech beṉe' blaoch ca Juanṉa'. Perw na' note'teze beṉe' gwzenague' c̱he Diosen' cont Diosen' ṉabi'e yic̱hjlažda'ogüe', ḻa'czḻa' bi naque' beṉe' blao, gwžin ža cate' šejni'ichde' c̱hia' clel ca Juanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ba bzoa Juanṉa' beṉe' zan nis na' len baḻ beṉe' güec̱hixjw. Na' yogo' beṉe' ca' gosacbe'ede' Diosen' zejcze' to ḻicha dan' gwseḻe' Juanṉa' jatix̱jue'ede' ḻegaque' yesyetiṉjde' xtoḻa'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Perw na' beṉe' fariseo ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés, goson yic̱hjlaogaquen' cbi besyetiṉjde' xtoḻa'gaquen' can' goclaže' Diosen'. Bi gosaclaže' gwzoa Juanṉa' ḻegaque' nis. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nach Jesúsen' gože' ḻegaque': ―¿No gwsaca'lebda' le'e zoale ṉa'a? ¿No chon can' chonḻen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nacle ca bidao' ṉec̱he bicze bi de chlebele. Can' zjanac bidao' ca', cate' nita'be' gan' chac ya'a chese' ḻježbe': “Ba bcuežto' bžejo, ṉeca bya'ale, na' ba biḻyaše'to', ṉeca gwchežle.” ");
INSERT INTO zpqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan ben' chzoa beṉe' nis bide' laole nga, bitw güe'ej gwdagwšagüe' can' chese'ej chesagw beṉe' yoble, na' ṉeca güe'eje' vino, nach gwnale c̱he': “Yo'o nyaz da' x̱igüen' yic̱hjlažda'ogüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na' neda', chle'ele che'ej chagua' can' chese'ej chesagw beṉe' yoble, na' žale c̱hia' naca' beṉe' lia na' beṉe' borrašw, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Na' ḻecze žale naca' migw c̱he beṉe' güec̱hixjw ca' na' migw c̱he nochle beṉe' güen da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Perw na' beṉe' chosozenag c̱he Diosen' zjanape' to yeḻa' sina' na' chesone' cont nacbia' Diosa' naque' ḻa'zelagüe' beṉe' sina'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","To beṉe' fariseo goxe' Jesúsen' šeje' liže' cont yesagüe'. Na' bžin Jesúsen' liž bena' na' gwchi'e cho'a mesen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na' to no'ole ḻo ciudan', no'ole zḻe', gwṉezde' bžin Jesúsen' liž bena'. Na' Jesúsen' len beṉe' ca' yezica'chle ba nite' cho'a mesen' cont yesagüe', cate' bžin no'olen'. Na' no'olen' nox̱e' to da' nac de yejese da' yože set da' ḻa'zelaoze chḻa' zix̱. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na' jabigue' gaḻa'ze xṉi'a Jesúsen' na' gwcheže' na' nis xc̱hež c̱hen' bžonen ṉi'a Jesúsen' gwbisen. Na' bxie' ṉi'ena' len yiša' yic̱hje' na' bnopen' na' gwdeben' set zix̱en'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na' ben' goxe' Jesúsen' ližen', cate' ble'ede' can' chon no'ola' na' gocde': “Šaca' benga naque' to beṉe' choe' xtiža' Dios, guacbe'ede' no'olen' chgan ṉi'ena' naque' no'ole zḻe'”. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nach Jesúsen' gože'ne': ―Simón, de to da' che'nda' yapa' le'. Nach Simónṉa' gože' Jesúsen': ―Gwnan Maestrw. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesúsen' gože'ne': ―Gwzoa to beṉe' na' nita' c̱hope beṉe' chesaḻe' xmechue'. Toe' chaḻe' gayo' gayoa mechw da' nzi' denario, na' ben' yeto chaḻe' šiyon mechw ḻecze denario. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na' chopte beṉe' ca' ṉe toe' ca de c̱hegaque' cont yesyeyixjue' xyan'. Na' ben' gwlej mechon' gwlejyic̱hje' dan' chesaḻe' c̱hen'. Gwnašc neda', ¿noe' beṉe' ca' chope' gosacchde' c̱he'? ");
INSERT INTO zpqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nach Simónṉa' gože'ne': ―Šeca ben' goc xya c̱hen' da' xench na' gwlejyic̱hjen'. Jesúsen' gože'ne': ―Da' ḻi can' ba gwnao'na' naquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nach Jesúsen' gwyec̱hje' gwṉe'e no'ola' na' gože' Simónṉa': ―¿Chle'edo' no'ole nga? Neda' ba gwyo'a ližo' nga na' bi beṉo' nis c̱hib ṉi'a, perw no'ole nga ba gwdibe' ṉi'an' len nis xc̱hež c̱hen' bxien' len yiša' yic̱hje'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bi bnopo' neda', perw na' no'ole nga cate' bla'atia' gwzolagüe' chnope' ṉi'a nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bi gwdebo' set yic̱hja', perw no'ole nga ba gwdebe' set zix̱ ṉi'a nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na' žia' le', xtoḻe'na' gosaquen da' zan, perw ba bezi'xena' c̱he'. Da'nan' chacchgüede' neda'. Beṉe' bi žinḻaže' xtoḻen' ca xtoḻa' no'ole nga, cate' yezi'xena' c̱he' bitw gactecde' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nach gože' no'olen': ―Ba bezi'xena' xtoḻo'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nach beṉe' ca' chesagw len Jesúsen' txen ḻo mesen' gwzolao chese' ḻježe': ―¿Nox benga chacde' ḻe'na' chezi'xene' xtoḻa' beṉac̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nach gož Jesúsen' no'ola': ―Dan' chejnilažo' neda' da'nan' ba de yeḻa' mban c̱hio' toḻi tocaṉe. Beyej to šagüe' to güen. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na' gwdechle gwyej Jesúsa' zan ciuda na' zan yež jatix̱jue'ede' diža' güen, gwne' Diosen' ṉabi'e yic̱hjlaždao' beṉe' yosozenague' c̱he'. Na' zja'aclen beṉe' šižiṉw ca' ḻe', beṉe' ca' zjanzi' postlw. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nach to x̱oṉj no'ole ḻecze zja'aclene' Jesúsen' beṉe' ca' ba beyone'. Baḻe' ba bebeje' da' x̱igüe' da' zjayo'o zjanyaz ḻo' yic̱hjlažda'ogaque' na' yebaḻe' ba beyone'ne' cate' gosacšende'. Na' toe' lie' María beṉe' Magdala, bebej Jesúsen' gaže da' x̱igüe' gwyo'o gwyaz yic̱hjlažda'ogüe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nach ḻecze len ben' le Juana, xo'ole ben' le Chuza, na' Chuzan', gwyo'o ḻo ne'e liž rey Herodes na' yežlio c̱he' ca'. Na' ḻecze len ben' le Susana gwyejlene' Jesúsen', na' yezan beṉe' yezica'chle. Na' no'ol ca' bosoc̱hine' bite'teze da' gota' c̱hegaque' cont bosonežjue' dan' byažje Jesúsen' len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na' beṉe' zan besežag gan' zoa Jesúsen' beṉe' za'ac to to yež ca'. Na' be'e to jempl, gwne': ");
INSERT INTO zpqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―To beṉe' güen žin jeze' trigw na' šlac zeje' chose' trigon' late' biṉ jasechazen do cho'a nezen', na' bosolej bosošošj beṉe' ḻen, na' be žia x̱il be chaš ḻe'e yaba gosagwban'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yelaten' jasechazen ga nac ḻo yej, na' cate' beselan' na' gosebižen, ḻe gague bi gopa' den'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yelaten' jasechazen ga nac ḻo yag yeše', na' gosecha'on txen, na' bosoḻoḻe' yag yeše' ca' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Perw na' yelaten' jasechazen ga nac yo šagüe' na' beselan', na' baḻen gosebian to gayoa güeje. Na' beyož be'e diža' quinga gwṉe' zižje gože' ḻegaque': ―Le'e žia nagle da' chene, ḻe gwzenag xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nach beṉe' ca' zjanaque' Jesúsen' txen goseṉabde' ḻe' bi zejen jempl da' ba bi'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na' gož Jesúsen' ḻegaque': ―Nono ṉa' neze can' nac yeḻa' gwnabia' c̱he Diosen'. Perw ba chone' cont le'e chejnilaže'lene' ṉezelen. Perw beṉe' bi chesaclaže' yesejnilaže'ne', chzejni'igacda'ne' len jempl. Chona' ca' cont yesele'ede' can' chonan' na' bitw yesacbe'ede' bi zejen, na' cont yesende' xtižan' na' bi yesejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Na' ca nac jempl nga zejen quinga: Ca dan' byažen zejen xtiža' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na' biṉ dan' besego'oṉen chanezen', zejen beṉe' ca' chesende' xtiža' Diosen', perw na' chžin Satanás dan' chnabia' da' x̱igüe' ca' chebejen xtiža' Diosen' ḻo' yic̱hjlažda'ogaque' cont bi yesejnilaže' ḻe' na' bi gata' yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na' biṉ dan' besego'oṉ ga nac ḻo yej zjanaquen ca beṉe' chesyebede' xtiža' Diosen', perw zjanaque' ca to da' bibi loe chon, šložga chesejḻe'e c̱he xtiža' Diosen', na' cate' chac bi da' mal c̱hegaque' ḻa' chesebejyic̱hjte' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na' biṉ dan' besego'oṉen ga nac ḻo yag yeše', zejen ca beṉe' ca' ba gosende' xtiža' Diosen', perw šlac zjambane' chesyelaḻ chesyežejde' na' chese'nde' yeseṉi'e, na' chesede' chesonteze' con da' žazen c̱hegaque'. Na' da' qui bi choen' latje yega'aṉ xtiža' Diosen' ḻo' yic̱hjlažda'ogaque' na' da'nan' bi chesejnilaže' ḻe' ca cheyaḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na' da' ca' besego'oṉen ḻo yo šagüen', zejen ca beṉe' cate' chesende' xtiža' Diosen' chesezi'en chesonen' c̱hegaque', na' chesejnilaže' ḻe' do yic̱hj do laže', na' chesechejde' bite'tez dan' chac c̱hegaque' cont chesone' can' che'ne Diosa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na' Jesúsen' gwne': ―Notno gwguaḻa' to yi' na' gwdosen' to yeso', na' ṉeca gwcuaše' yin' xan xcame'. San chde'en ḻe'e ze'e cont gwseṉin' len yogo'ḻoḻ beṉe' yeso'o ḻo' yo'o. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ḻe yogo'ḻoḻ da' ngaše' c̱hia' neda', ḻenṉa' gwlo'elaon, na' yogo'ḻoḻ da' nono ṉa' ṉeze c̱hia', žin ža yeseṉezden' na' yesejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ḻe gwzenag da' quinga da' chzejni'ida' le'e, ḻe note'teze beṉe' chzenague' xtiža' Diosen' gwzejni'ich Diosen' ḻe', perw na' note'teze beṉe' bi chzenague', da' daon' chacde' ba ṉezde', yeca'a Diosen' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na' xṉa' Jesúsen' len beṉe' biše' ca' besežine' gan' zoa Jesúsen', gosaclaže' yeso'e, perw catec beṉe' zan že' gague goc latje yesežine' lagüe' na'ate. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na' to ben' ze na' gože' Jesúsen': ―Xṉa'o len beṉe' bišo' ca' zjanite' chyo'o na' chesaclaže' yedeseṉe'e le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na' Jesúsen' gože' ḻegaque': ―Beṉe' ca' chosozenag xtiža' Diosen' na' chesezi'e cho'alao xtižen', beṉe' can' zjanaque' xṉa'a na' biša'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na' goc to ža Jesúsen' gwyo'e to ḻo barcw len beṉe' ca' zjanaque' ḻe' txen. Na' gože' ḻegaque': ―Ḻaga'cho yešḻa'ale nisdaon'. Nach bosose'e barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Šlac zejen ḻo nisen' gwtas Jesúsen'. Nach gwzolao gwyec̱hj to be' bdono' ḻo nisdaon', na' gwzolao cheyož nis ḻo' barcon'. Na' besexožde' yesebiaye'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nach bosyosbane' Jesúsen' gose'e ḻe': ―¡Maestrw! ¡Maestrw! Bac̱h chbiayi'cho. Nach gwyase' na' gwdiḻe' be' bdono' len nisdaon', na' ḻa' gosebe'žiten. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na' gože' ḻegaque': ―¿Nacxec̱hen' bi chejḻe'le c̱hia'? Nach ḻegaque' besežebe' len besyebande'. Nach gose' ḻježe': ―¿Noxe benga? lente be' bdono' na' len nisdaon' chosozenaguen c̱he da' že'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na' besežine' laž beṉe' Gadara ca', to yež da' chi' šḻa'a distritw Galilean', ḻaga'cho nisdao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na' cate' bechoj Jesúsen' ḻo' barcoa', to beṉe' ḻo yežna' jašague' ḻe'. Ba gwža yo'o nyaz da' x̱igüen' yic̱hjlaždao' bena'. Na' ba chde' con gague bi xe' chazche', na' bich zoe' liže', con ba zoe' do capsantwle. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Na' beṉe' gualaž c̱he' ca' bosoc̱heje' ṉi'a ne'e len gden na' gosape' ḻe'. Na' da' x̱igüe' ca' gosonen cont bzoxj btine' gdenṉa' zan ṉi'a. Na' gosonen cont gwyeje' ga nono beṉe' zjanḻa'. Na' bena' cate' ble'ede' Jesúsen' na' bzoa xibe' lagüen'. Na' bosye'e zižje gwne': ―¿Bixc̱hen' chgoša' chlaže' c̱hio' len neda', Jesús? Le' naco' dogualje Xi'iṉ Dios ben' nape' ḻa'zelagüe' yeḻa' gwnabia' xen. Chṉeyoeda' le' bi gwsaco' neda'. Gwne' ca' dan' ben Jesúsen' mandadw yechoj da' x̱igüen' yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nach Jesúsen' gože' da' x̱igüen' yo'o nyaz yic̱hjlaždao' bena': ―¿Bi lio'? Nach da' x̱igüen' gwnan: ―Legión lia'. Gwnan ca' ḻe zjanaquen da' zan zjayo'on yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nach da' x̱igüe' ca' gosata'yoen Jesúsa' bi yeseḻen' ḻo yi' gabiḻ. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na' to ya'a da' zoa gaḻa'ze chesaš zan coš chesagwba'. Nach da' x̱igüe' ca' gosata'yoen Jesúsen' gwnežjue' latje šjaseyo'on yic̱hjlaždao' coš ca'. Na' Jesúsen' bnežjue' latje. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nach besyechojen yic̱hjlaždao' bena' na' jaseyo'on yic̱hjlaždao' coš ca'. Na' besyeyetjses coš ca' ḻe'e ya'a gan' nita'ba' na' jaselažo'ba' ḻo' nisdao' ga gosatba' gose'ejba' nis. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na' beṉe' ca' chosoyoe' cošen' besele'ede' dan' ba goquen' bosyoxoṉje' jasyeyeže' beṉe' lagüe yež len beṉe' chaš yix̱e', gose'e ḻegaque' can' ba goquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nach ja'ac beṉe' jaseṉe'e bixen' goc. Na' cate' besežine' gan' zoa Jesúsen' besele'ede' bena' ba gwyo'o gwyaz da' x̱igüen', ṉa'a ba chi'e gaḻa'ze cuit Jesúsen' nyaz xaḻane', na' ba bezoa yic̱hjlažda'ogüe' binḻo. Na' besežebe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na' beṉe' ca' besele'ede' can' goquen' goso'e diža' c̱he dan' goc c̱he bena' gwyo'o gwyaz yic̱hjlažda'ogüe' da' x̱igüen' na' can' ba beyaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nach yogo'ḻoḻ beṉe' ca' že' gan' mbane yež Gadaran' jaseta'yoede' Jesúsen' yeze'e lažgaquen', ḻe besežebchgüe'. Nach Jesúsen' beyo'e ḻo' barcon' cont yeze'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na' bena' beyaque cate' Jesúsen' bebeje' da' x̱igüe' ca' goso'o gosazen yic̱hjlažda'ogüe', gota'yoede' ḻe' gwnežjue' latje šejlene'ne'. Perw Jesúsen' bi be'e latje, san gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Beyej ližo' na' jayež beṉe' ḻo' yo'o c̱hio' yogo' da' güen da' ba ben Diosen' len le'. Nach beza' ben' na' gwzolagüe' cho'e diža' doxen yežen' yogo' can' ba ben Jesúsen' len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na' cate' Jesúsen' beḻague' nisdaon', beṉe' zan ba nita' chesebeze' ḻe'. Chesyebechgüede' da' bežine' na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na' bžin to beṉe' le' Jairo, ben' nac to beṉe' gwnabia' c̱he yodao' c̱he yežna'. Na' bzoa xibe' lao Jesúsen' gota'yoede' ḻe' šejlene' ḻe' liže', ");
INSERT INTO zpqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ḻe ba zoa gat bi' no'ol c̱he'. Nacbe' bi' tliša', na' šižiṉw izguebe'. Na' šlac zej Jesúsen' len ḻe', beṉe' zan gosebiadi'e ḻe' na' bosoc̱hichgüe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na' len to no'ole ba goc šižiṉw iz chzoe' gwbao' na' ba benditje doxen xmechue' len beṉe' güen rmed ca'. Na' notno goc gon ḻe' rmed. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na' gwbiga' no'olen' cože' Jesúsen' na' gwdane' lox xen', nach ḻa' gwlezte gwbao' dan' zoen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na' gwna Jesúsen': ―¿Non' gwdan neda'? Na' ṉe toe' ca gosec̱hebe' še ba gosegane' ḻe'. Nach Pedron' len beṉe' ca' zja'aclen Jesúsen' gose'e ḻe': ―Maestrw, beṉe' zan beṉe' za'ac nga chosoc̱hie' le' na' chosožigue' le' nile na'le. ¿Bixc̱hen' chṉabo' no gwdan xaon'? ");
INSERT INTO zpqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nach Jesúsen' gože' ḻegaque': ―To beṉe' ba gwdane' neda'. Chacbe'eda' ba beyacde' len yeḻa' guac c̱hia'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nach no'olen' cate' gocbe'ede' cbi bgaše' dan' benen', nach gwbigue' lao Jesúsen' do chaž chžebe' na' bzoa xibe' lagüe'na', be'e diža' lao yogo' beṉe' ca' že'na' bixc̱hen' gwdane' ḻe' na' can' goc ḻa' beyactede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nach gož Jesúsa' no'ola': ―Xi'iṉa', ba beyacdo' dan' chejnilažo' neda'. Beyej binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ṉe' choe'te Jesúsa' dižan' ca' cate' bžin to beṉe' gwza' liž Jairo ježe' ḻe': ―Ba got bi' no'ol dao' c̱hion'. Bich gondo' Maestroa' zed. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Perw cate' bene Jesúsen', na' gože' Jairo: ―Bitw žebo', con gwyejnilaže' neda' na' yeyaquebe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na' cate' besežine' liž Jairona', Jesúsen' bi be'e latje yeso'o zan beṉe' ca' zja'aclen ḻe', san Pedro, len Juan, len Jacobo, na' len x̱axṉa' bi' guat na'ze goso'o. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na' ba chi'chgua žaš na' yogo' beṉe' ca' že'na' chesebežchgüe'. Na' Jesúsen' gože' ḻegaque': ―Bitw cuežle. Biṉa' gatbe', san chtasbe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na' bosoxiže' gosonḻe' c̱he' da' zjaṉezde' ba gotbe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Perw Jesúsen' bex̱ue' taca' bi' no'ol guaten' na' boḻ güiže'be' gože'be': ―No'ol dao', beyas. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nach bebambe', ḻa' beyastebe'. Na' Jesúsen' bene' mandadw yeso'ebe' da' gagwbe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na' x̱axṉa'be' besyebanchgüede'. Perw Jesúsen' bene' mandadw bi yeso'e diža' can' goca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesúsen' botobe' beṉe' šižiṉw ca' gwleje' cont zjanaque' ḻe' txen na' bnežjue' ḻegaque' yeḻa' gwnabia' na' yeḻa' guac cont goc besyebeje' da' x̱igüe' ḻo' yic̱hjlaždao' beṉe', na' ḻecze ca' besyeyone' beṉe' ca' chesacšene. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na' ḻecze bene' mandadw šjasedix̱jue'ede' Diosa' ṉabi'e yic̱hjlaždao' beṉe' yosozenag c̱he'. Na' bene' mandadw yesyeyone' no beṉe' güe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na' gože' ḻegaque': ―Bibi gox̱e'le tnez. Bitw gox̱e'le xis da' gwc̱hiše'le, ṉeca gua'le bzod, ṉe yet, ṉe mechw, na' bitw gua'le yeto xcamisle. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Cate' žinḻe to liž beṉe', na'ze yega'aṉle šlac zoale lagüe yeža'; cate'ch yeza'le yeža', cana'ch yeza'le latja'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na' še zoa ga bi yosolebe' le'e, cate' yeza'le na', ḻe cuibe ṉi'alen' yo bište cont nacbia' malen' chesone' bi chosozenague' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nach beṉe' šižiṉw ca' ja'aque' to to yež, na' gate'teze ja'aque' jasedix̱jue'ede' diža' güen c̱he Jesúsen' na' besyeyone' no beṉe' güe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na' gobernador Herodes goque' tole bende' yogo'ḻoḻ da' güen da' chon Jesúsen'. Gocžejlaže', ḻe baḻ beṉe' gose'e ḻe' ba beban da' Juan ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na' yebaḻe' gosene' šeca da' Elías ben' be' xtiža' Diosen' cani' ba bela' yežlio nga da' yoble. Yebaḻe' chesene' yeto beṉe' be' xtiža' Diosen' cani'te ba bebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na' Herodesen' gwne': ―Neda' bena' mandadw gosec̱hogue' yen Juanṉa', perw ¿noxen' chon da' güen ca dan' chesoe' beṉe' diža'? Na' gwdiljwlaže' nacle gone' cont le'ede' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na' cate' besyežin postlw ca' gan' zoa Jesúsen' nach gose'e ḻe' can' ba gosonen'. Na' gwc̱hi'e ḻegacze' na' ja'aque' to latje gan' mbane yež Betsaida. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cate' gosacbe'e beṉe' ca' nita' gan' zoa Jesúsen' ba gosa'aque' len beṉe' ca' zjanaque' ḻe' txen, nach zja'aque' zjana'ogüe' ḻegaque'. Jesúsen' blebe' ḻegaque' na' bsed blo'ede' ḻegaque' Diosen' ṉabi'e yic̱hjlaždao' beṉe' yosozenag c̱he', na' beyone' beṉe' ca' chesacšene. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cate' gwzolao gwxoa gwbižen', nach beṉe' šižiṉw ca' zjanaque' Jesúsen' txen gose'ene': ―Beseḻa' beṉe' quinga cont šjaya'aque' ga že' beṉe' do ranšw na' do yež ca' dan' nyec̱hj mbi'i cont yeseyiljue' ga yesetase' na' yeseyiljue' da' yese'ej yesagüe', ḻe ca nac latje gan' zoacho nga, naquen to latje daš. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Perw na' gož Jesúsen' ḻegaque': ―Le'e ḻe güe'e da' yesagüe'. Na' gose'e ḻe': ―Gayo'ga yetextil na' yec̱hopga beḻ ya'a de c̱hecho, lete še si'chon cont gaquen yesagw yogo'ḻoḻ beṉe' quinga. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gosene' ca' ḻe že' ca gayo' mil beṉe' byo, bi cuent no'ol ca' len bidao'. Nach Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻe gon mandadw yesebe' šiyon güej beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nach gosone' mandadw gosebe' yogo' beṉe' ca', ");
INSERT INTO zpqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","na' Jesúsen' gwxi'e gayo' yetextilen' na' c̱hope beḻ ya'ana', na' gwṉe'e yabale, be'e yeḻa' chox̱clen c̱he Diosen' na' bzoxjen' na' be'en beṉe' šižiṉw ca' cont goso'e c̱he to to beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na' gosagüen' ca goseḻjde'. Nach bososše'e šižiṉw žome len yetextil bixjw na' len late' güeje beḻ da' bega'aṉ. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na' gozac yeto, beṉe' ca' zjanaque' Jesúsen' txen zjanite' len ḻe' lchojiže, na' Jesúsen' choḻ güiže' Diosen'. Nach gože' ḻegaque': ―¿Bi chesena beṉe'? ¿Non' naca' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na' gose'e ḻe': ―Baḻe' chesene' naco' da' Juan ben' bzoe' beṉe' nis. Na' yebaḻe' chesene' naco' Elías ben' be' xtiža' Diosen' cani'. Na' yebaḻe' chesene' naco' yeto beṉe' be' xtiža' Diosen' cani' ben' ba beban ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nach gože' ḻegaque': ―¿C̱hixe le'e? ¿No žale naca'? Na' gož Pedron' ḻe': ―Len' naco' Cristo ben' gwlej Diosen' cont yedeṉabi'o. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nach Jesúsen' gože' ḻegaque' nono yese'e naque' ben' gwlej Diosen' cont yedeṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na' gože' ḻegaque': ―Da' zan da' saca'zi'a, neda' naca' ben' gwseḻa' Dios golja' beṉac̱h. Na' beṉe' gole blao ca' chesenabia' nación c̱hechon' na' bx̱oz gwnabia' ca', na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés, bi yesele'ede' neda' güen dan' bi gosejḻe'e c̱hia', na' yesote'nda', perw yeyoṉ ža yebana' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nach gože' yogo' beṉe' ca' zjanaque' ḻe' txen: ―Note'tez beṉe' še chaclaže' gaque' neda' txen, cheyaḻa' cuejyic̱hj cuine' yogo' ža, ḻa'czḻa' saca'zi'e, na' gone' can' ṉia' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Note'tez beṉe' chacde' gone' cont bi saca'zi'e o cont nono yesot ḻe', benan' cuiayi'. Na' note'teze beṉe' chzanḻaže' cuine' saca'zi'e o gate' ṉe c̱hia' neda', ba de yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Bixe zejenṉa' to beṉe' ṉabi'e doxen yežlion' še cuiaye'e na' bi gata' yeḻa' mban c̱he' toḻi tocaṉe? ");
INSERT INTO zpqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na' note'tez beṉe' še cheto'ede' par ye'e ḻježe' chejnilaže' neda' na' še cheto'ede' par gwzenague' xtižan', ḻecze ca' neda' yeto'eda' c̱he' par ṉia' naque' neda' txen, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Yeto'eda' c̱he' cate' yida' da' yoble nsa'a yeḻa' zaca' juisyw c̱hia' na' yeḻa' zaca' juisyw c̱he X̱a' Diosen' na' c̱he ben' zjanac angl c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Da' ḻi žia' le'e, baḻle nita'le nga ṉa'a biṉa' gatle cate' žin ža le'ele gwlo'e Diosen' yeḻa' gwnabia' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nag goc to xman gwna Jesúsen' ca', gwyeje' to ḻo ya'a jeḻ güiže' Diosen' na' gwc̱he'e Pedro len Juan len Jacobo. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na' šlac choḻ güiže' Diosen' goc cho'alagüen' ca da' bža'. Na' xaḻanen' beyaquen šiš xila' na' goctiten. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na' ḻo hora' besežin c̱hop beṉe' gan' zoa Jesúsen', toe' da' Moisés na' yetoe' da' Elías bosošaljlene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Goso'e diža' gosene' ba zoa gat Jesúsa' Jerusalén. Na' be'ni' c̱he Diosen' gwyec̱hjen bseṉin' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na' Pedron' len beṉe' ca' yec̱hope ḻeca gosac ša tase' perw bi gosetase' na' besele'ede' Jesúsen' chactit cho'alagüen' na' zeche' choe'lene' da' Moisésen' len da' Elíasen' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na' cate' ba cheza' da' Moisésen' len da' Elíasen', Pedroa' gože' Jesúsen': ―¡Maestrw, ḻeca güenṉa' zoacho nga! Gonto' šoṉe ranšw, to c̱hio', to c̱he Moisés, na' yeto c̱he Elías. Con gwne' ca' sin ca bene' xbab. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ṉe' choe'te Pedron' diža' cate' to bejw gwyec̱hjen ḻegaque' na' besežebe' lagüe dan' goc ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na' ḻo' bejon' gosende' gwṉe Diosen', gwne': ―Benga Xi'iṉa' ben chacda'. Ḻe gwzenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na' cate' beyož gwna Diosen' ca', besele'ede' yetoze Jesúsen'. Na' ca' beyoža' bibi diža' gosoe'lene' beṉe' ca' yezica'chle can' nac dan' ba gosende' na' dan' ba besele'ede'. Con gosenita'teze' šižize. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na' beteyo cate' ba besyeyetje' ya'ana' beṉe' zan jasešague' ḻegaque' gan' nite'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na' toe' gwṉe' zižje, gože' Jesúsen': ―Maestrw, chata'yoeda' le' gaclenšco' xi'iṉa' nga. Nacbe' xi'iṉa' tliša'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chṉiz da' x̱igüen' ḻebe' na' ḻa' chgosya'aten ḻebe', chonen cont chazbe' šon na' cont chžia bžina' cho'abe' na' chonen ḻebe' zi', na' caṉe chsanen ḻebe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba gota'yoeda' beṉe' ca' zjanaque' le' txen cont yesyebeje' da' x̱igüen' yo'o nyazbe', perw bitw gosezaque'de'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nach Jesúsen' gože' beṉe' ca' že' na': ―¡Le'e beṉe' bi chejnilaže', chonchguale clele! ¿Šna chyažjen soalena' le'e cont šejnilaže'le? ¿Batca' zelao ṉa'lagua' le'e? Nach gože' x̱a bidao'na': ―Beṉ bidao' c̱hion' nile. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na' šlac zjasane'be' lao Jesúsen', da' x̱igüen' benen cont gwyazbe' šon, na' bchix̱ btoḻen ḻebe' ḻo yo. Na' Jesúsen' gwdiḻe' da' x̱igüen' cont bechojen ḻo' yic̱hjlažda'obe'. Nach beyaquebe'. Gwdena' beyoṉe'be' ḻo na' x̱abe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na' yogo' ben' že'na' besyebande' cate' besele'ede' yeḻa' guac c̱he Diosen'. Na' besyebande' c̱he yogo'ḻoḻ dan' chon Jesúsen', na' šlac nite' ca', Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ");
INSERT INTO zpqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ḻe gon cont diža' nga šo'on yic̱hjlažda'ole, na' bi ganḻaže'len. Neda' gaca' ḻo na' ben' chesegue'enda', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Perw ḻegaque' bitw gosejni'ide' diža' dan' be' Jesúsen', ḻe naquen ca to da' ngaše' len ḻegaque'. Na' besežebe' yeseṉabde'ne' bi zejen dan' gože' ḻegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na' beṉe' ca' zjanaque' Jesúsen' txen gosacyože' noe' nacch blao. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesúsen' gocbe'ede' xbab dan' chesonen', na' bex̱ue' to bidao' na' bzeche'be' cuite'na' ");
INSERT INTO zpqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na' gože' ḻegaque': ―Note'teze beṉe' chone' güen len to bidao' ca bi' nga ṉec̱he da' chejnilaže' neda', choncze' güen len neda'. Na' note'teze chon güen len neda' choncze' güen len Dios ben' gwseḻa' neda'. Na' note'tez le'e cate' chonḻe xbab c̱he cuinḻe bibi zaca'tecle, canan' ba nacle beṉe' blao. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nach Juanṉa' gože'ne': ―Maestrw, bežagto' to beṉe' cho'e lao' na' chebeje' da' x̱igüe' da' yo'o nyaz beṉe'. Na' bžonto' gone' ca', ḻe bi chone' chio' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nach Jesúsen' gože'ne': ―Bitw gwžonḻe gone' ca', ḻe še to beṉe' bi chone' contr chio', txenczen' chone' len chio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na' lagüe' ba zoa bagwze yezi' yeca'a Diosen' ḻe', bec̱hoglaže' šeje' Jerusalén. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na' gwseḻe' to c̱hope beṉe' gosebialao lagüe'na'. Na' ja'aque' to yež gan' mbane distritw Samaria cont šjasesiṉi'e gan' soa Jesúsen' len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Perw beṉe' Samaria ca' bi bosolebe' Jesúsen' len beṉe' ca' nžague', ḻe gosacbe'ede' zja'aque' Jerusalén. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na' c̱hope beṉe' ca' zjanaque' Jesúsen' txen, Jacobon' len Juanṉa', cate' besele'ede' can' goson beṉe' Samaria ca', nach goseṉabde' Jesúsen': ―Maestrw, ¿che'ndo' gonto' can' ben da' Elías ben' be' xtiža' Diosen' cani', ṉabeto' Diosen' seḻe' yi' gwzeyen beṉe' qui? ");
INSERT INTO zpqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nach Jesúsen' gwyec̱hje' gwdiḻe' ḻegaque' gwne': ―Le'e bitw ṉezele non' chnabia' yic̱hjlažda'ole. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Neda' bitw za'a cont gwžiaya'a beṉac̱h, san za'a cont gwnežjua'ne' yeḻa' mban toḻi tocaṉe, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Nach ja'aque' yež yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Šlac zja'aque' na', to beṉe' gože' ḻe': ―Sa'lena' le' gate'teze šejo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nach gož Jesúsen' ḻe': ―Nita' xišna' beza' na' ḻecz chesyežin xišna' be dao' ca' zjazoa x̱il be chaš ḻe'e yaba, perw bibi xišna' neda' de ga yezi'laža', neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nach Jesúsen' gože' yeto beṉe': ―Yo'o len neda'. Perw bena' gože' ḻe': ―X̱ana', za' got x̱a'. Beṉšca latje zgua'tec šjaycuaša'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na' gož Jesúsen' ḻe': ―Beṉe' ca' zjanac yic̱hjlažda'ogüe' ca c̱he beṉe' guat, ḻegaque' guaccze yosocuaše' yezica'chle beṉe' guat. Perw le', jatix̱jue'e beṉe' Diosa' ṉabi'e yic̱hjlaždao' beṉe' yosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nach ḻecze yetoe' gože' Jesúsen': ―Sa'lena' le' X̱ana', perw zgua'tec šjayzenda' x̱axṉa'a len diaža c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesúsen' gože' ḻe': ―Beṉe' ba gwzolao nagüe' neda', še bi ze'e do yic̱hj do laže', o še yo'o yic̱hje' da' ba gwdele, bi zaque' gone' xšin Diosen'. Naque' ca to beṉe' chṉe'e coscože'le šlac chgua'aṉe' go'ṉ. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na' gwdechle X̱ancho Jesúsen' gwleje' yegayonši beṉe' na' bene' mandadw yesebialagüe' šja'ac c̱hope güeje' to to yež ga za' šej ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na' cate' za' yesa'aque' gože' ḻegaque': ―Chyažje beṉe' zan yeseyix̱jue'ede' xtiža' Diosen', perw to c̱hopga beṉe' nita' yeseyix̱jue'eden'. Na' beṉe' yosozenag c̱he Diosen' zjazaca'lebe' ca to coseš xen da' chyažje yedobe. Da'nan' ḻe ṉabe X̱ancho Diosen' seḻa'che' beṉe' yesaclene' chio' yotobcho coseš c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ḻe šja'ac, ḻe neda' chseḻa' le'e šjatix̱jue'ele xtižen' len beṉe' ca' chesegue'ede' le'e. Zaca'leble ca xila' dao' ben' chja'ac gan' že' beco'yo. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bitw gua'le bzod, ṉe mechw, ṉe yel, na' bi šele guaple beṉe' tiox beṉe' yežagle chanez. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Note'tez liž šo'le zgua'tec ṉale: “Chṉablaže'šca' soa cuezle binḻo len xbab dan' yo'o ḻo' yic̱hjlažda'ole, le'e nita'le nga.” ");
INSERT INTO zpqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na' še zoa to beṉe' chaclaže' soa cueze' binḻo len yic̱hjlažda'ogüe'na', nach gac can' gwṉablaže'le cont soa cueze' binḻo; perw še nono zoa beṉe' chaclaže' soa cueze' binḻo len yic̱hjlažda'ogüe', bi gac dan' ba gwṉablaže'len'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na' ḻo' yo'o na'teze yega'aṉle. Bitw tale to to yo'o. Ḻe ye'ej ḻe gagw bite'teze da' chesone' ye'ej gagwle. Ca to beṉe' güen žin cheyaḻa' si' laxjue', ḻecz ca' le'e zaca'le yesoṉe' da' ye'ej gagwle. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na' cate' žinḻe to yež ga chesonxene' le'e, ḻe ye'ej ḻe gagwteze da' yesoṉe' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ḻe yeyon beṉe' güe' beṉe' nita' yež gan' žinḻe, na' ḻe' ye'e: “Ba bžin ža gwzenagle c̱he Diosen' cont ṉabi'e yic̱hjlažda'ole.” ");
INSERT INTO zpqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Perw na' cate' žinḻe to yež ga bi yosolebe' le'e, ḻe šja'ac la cay na' ḻe ye'e: ");
INSERT INTO zpqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bište c̱he lažle nga da' žia ṉi'ato', cuibton' cont gwlo'eto' le'e malen' chonḻe bi chzenagle xtiža' Diosen' dan' choe'to'. Perw chyix̱jue'eto' le'e Diosen' chazlaže' gwzenagle c̱he' cont ṉabi'e yic̱hjlažda'olen'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Da' mal xen goson beṉe' ciuda Sodoma cani', perw žia' le'e, žan' gac juisyw beṉe' ca' bi bosolebe' le'e ližen', yesaḻe'chde' clel ca beṉe' Sodoman'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nach gozna Jesúsen': ―¡Nyaše'chguaze gac c̱he le'e beṉe' Corazín! ¡Nyaše'chguaze gac c̱he le'e beṉe' Betsaida! Beṉe' ca' nita' Tiro na' Sidón ba' besyetiṉjde' xtoḻa'gaque' šaca' blo'egacda'ne' yeḻa' guac c̱hia' ca da' ba blo'eda' le'e. Na' bosoše'e ca gosone' šaca' bena' ca', chesazḻje' to lache' gasj da' naquen zeše' na' chosože'eḻja cuine' no de cont yesacbe'e beṉe' ba boša' yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Saca'zi'chle clel ca beṉe' že' Tiro na' Sidón cate' žin ža gac juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Le'e nita'le yež Capernaum chonḻe xbab šeca Diosen' goṉchgüe' le'e yeḻa' bala'aṉ. Bi goṉe' le'e yeḻa' bala'aṉ san goṉe' le'e castigw toḻi tocaṉe dan' bi chejḻe'le c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nach Jesúsen' goze'e beṉe' gayonši ca': ―Beṉe' gwzenag xtiža'len' ḻecze gwzenague' xtiža'na', na' beṉe' goncze yic̱hjlagüe' bi gwzenague' xtiža'len', ḻecze bi gwzenague' c̱hia' neda'. Na' beṉe' goncze yic̱hjlagüe' bi gwzenague' xtiža'na', ḻecze bi gwzenague' xtiža' Diosen' ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Beṉe' gayonši ca' cate' beyož jasedix̱jue'ede' xtiža' Jesúsen', besyežine' gan' zoen' na' besyebechgüede'. Nach gose'e Jesúsen': ―X̱anto', chebechgüeto' can' goquen', ḻe da' x̱igüe' ca' chosozenaguen c̱heto' cate' chonto' mandadw yesyechojen ḻo' yic̱hjlaždao' beṉe' choe'to' lao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na' gože' ḻegaque': ―Ble'eda' bedao'nez gwnit yeḻa' gwnabia' c̱he Satanásen' dan' chnabia' da' x̱igüe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ba beṉa' le'e yeḻa' guac cont gwlej gwšošjle no beḻ znia na' no bex̱joni' na' cont soele Satanásen' bi gonen le'e gan. Na' bibi de da' gonen le'e zi'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Perw bi yebele ṉec̱he da' x̱igüen' chosozenaguen c̱hele, san ḻe yebe da' ba bzoj Diosen' lale ḻe'e libr gan' nyoj la yogo'ḻoḻ xi'iṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Za' beyožte gwna Jesúsen' ca' nach ben Spiritw c̱he Diosen' cont bebechgüede' na' boḻ güiže' Diosen', gwne': ―X̱a', le' chnabi'o beṉe' ca' že' yaba na' yežlion'. Na' choṉa' yeḻa' chox̱clen c̱hio' ba bzejni'ido' baḻ beṉe'. Ba bzejni'ido' beṉe' ca' gosacbe'ede' cheseyažjde' no gwsed gwlo'e ḻegaque'. Na' bitw bzejni'ido' beṉe' ca' cheson xbab zjanaque' beṉe' sina' na' beṉe' zjanejni'i. Beno' ca' X̱a', ḻe can' gwyazlažo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nach gože' beṉe' ca' že'na': ―X̱an' ba bene' ḻo na' chona' cont chombia' beṉe' ḻe'. Ḻe' nombia'yaṉe' neda', na' neda' nombia'yaṉa' ḻe'. Na' beṉe' ca' ba gwleja' ba zjanombi'e X̱an'. Na' nono nochle zjanombia' X̱a' ṉe neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na' gwyec̱hj Jesúsen' gwṉe'e beṉe' ca' zjanaque' ḻe' txen na' gože' ḻegaque': ―Mbachgua zoale chle'ele neda' na' chle'etele da' ca' chona'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na' chnia' le'e zan beṉe' ca' goso'e xtiža' Diosen' cani' len beṉe' zan rey gosaclaže' yesele'ede' dan' chle'ele ṉa'a, perw bitw goḻa' yesele'eden', na' gosaclaže' yesende' dan' chenelen', perw bitw goḻa' yesenden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na' gwzoža' to beṉe' nsedchgüe' ley dan' bzoj da' Moisés, goclaže' cueje' Jesúsen' diža' da' gwc̱hine' contr ḻe' na' gože'ne': ―Maestrw, ¿bi da' cheyaḻa' gona' cont gata' yeḻa' mban c̱hia' toḻi tocaṉe? ");
INSERT INTO zpqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na' gož Jesúsen' ḻe': ―¿Bi nyoj ḻe'e leyna'? ¿Nac žan? ");
INSERT INTO zpqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na' ben' chejni'ichgüe' leyna' boži'e xtiža' Jesúsen', gože' ḻe': ―Ley c̱he Diosa' žan: “Cheyaḻa' gaquecho X̱ancho Diosen' con ca zelao chejni'icho, do yic̱hj do laže'cho, do fuers valor c̱hecho, na' gaque ḻježcho ca chaque cuincho.” ");
INSERT INTO zpqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nach gož Jesúsen' ḻe': ―Da' ḻicze can' ba gwnao'na'. Can' cheyaḻa' gono' cont bano' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na' bena' goclaže' gwlo'ede' choncze' can' ža leyna', na' gože' Jesúsen': ―¿Non' nac beṉe' ḻježa' ben' cheyaḻa' gacda'? ");
INSERT INTO zpqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na' Jesúsen' gože' ḻe': ―To beṉe' beza' Jerusalén par yežine' yež Jericó, jasyexen beṉe' gwban ḻe'. Na' goseyiṉe' xaḻane' na' gosot goseyine' ḻe'. Nach besyeya'aque' bosocua'aṉe' ḻe' cacze to beṉe' guat. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na' to bx̱oz c̱he beṉe' Israel ca' gwdie' ḻo neza', na' cate' ble'ede' bena' dena', nach gwcuase' to šḻa'ale neza' na' con gwdeze'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ḻecz ca' ben to diaža c̱he da' beṉe' Leví ca'. (Xi'iṉ diaža c̱he da' Leví yo'o ḻo na'gaque' chesoṉe' mandadw ḻo' yodao' blao.) Bena' zeje' tnez na' cate' ble'ede' ben' dena', na' gwcuase' to šḻa'ale neza' na' con gwdeze'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nach to beṉe' Samaria ngüe'e neza' nḻague' xpurrue' na' bžine' gan' de bena', perw na' ḻe' cate' ble'ede' ben' beyaše'laže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na' gwbigue' gan' de' na' bene' ḻe' rmed, bšone' set len vino lao güe' c̱he'na' na' bc̱hejen' lache'. Na' božie' ḻe' cože' xpurrue' na' bec̱he'e ḻe' ga zoa to mesón ga gwṉe'e ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na' beteyo cate' beza' beṉe' Samaria, gwleje' mechw da' zaca' ca c̱hop ža žin na' bnežjuen' x̱an mesónṉa' ca laxjue', na' gože' ḻe': “Gwṉa' benga na' še žan bichle da' gono' gastw na' c̱hixjuan' cate' zeza'a.” ");
INSERT INTO zpqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Beyož be' Jesúsen' diža' can' goc c̱he ben' jasyexen beṉe' gwban ca', nach gože' bena' chsed chlo'e leyna': ―¿Nac chono' xbab? ¿No beṉe' ca' šoṉe gocde'ne' ca beṉe' ḻježe'? ");
INSERT INTO zpqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nach bena' chsed chlo'e leyna' gože' Jesúsen': ―Bena' beyaše' beži'ilaže'de' bena' jasyexen gwban ca'. Nach gož Jesúsen' ḻe': ―Ḻecze ca' cheyaḻa' gono' le', yeyaše' yeži'ilaže'do' yogo'ḻoḻ beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na' gosego'oche' nez na' besyežine' to yež ga zoa to no'ole lie' Marta, na' Jesúsen' gwyeje' liže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na' zoa to bile' le María. Na' Marían' gwchi'e cuit Jesúsen' bzenague' xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Perw na' Martan' belaḻchgüede' bsiṉi'e da' yesagüe'. Na' gwyeje' lao Jesúsen' na' gože' ḻe': ―X̱ana', ¿bi chacdo' median can' bcua'aṉ beṉe' bilan' neda' toza' len mandadua'? Benšca mandadw gaclene' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","X̱ancho Jesúsen' gože' ḻe': ―Marta, chi'chgua yic̱hjo' mandadua' na' chacžejlažo' dan' nyanchguan. ");
INSERT INTO zpqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","María nga ba gwleje' da' naquech da' güen. Chi'e chzenague' c̱hia', na' notno gwžon gone' ca', ḻe ḻen da' nacch da' žialao da' cheyaḻa' gonḻe. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na' gwzoa Jesúsa' to latje choḻ güiže' Diosen'. Cate' beyož boḻ güiže'ne' to beṉe' ca' zjanaque' ḻe' txen gože' ḻe': ―X̱anto', bzejni'i neto' nac cheyaḻa' yoḻ güižto' Diosen', can' bzejni'i da' Juanṉa' beṉe' ca' gosaque' txen ḻen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na' Jesúsen' gože' ḻegaque': ―Cate' yoḻ güižle Diosen', quinga ṉale: X̱ato' beṉe' zoa yaba, chṉabto' yogo'ḻoḻ beṉe' yesonxene' le'. Zelaže'to' ṉabi'o yic̱hjlaždao' yogo' neto' beṉac̱h. Gacšca can' chazlažo' yežlio nga can' chac yabana'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ca nac dan' che'ej chagwto' tža tža, beṉšca c̱heto' ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na' bezi'xenšca c̱heto', ḻe lencze neto' chezi'xento' c̱he ḻjež beṉac̱hto' bite'tez da' chesonde' neto'. Na' bitw go'o latje soa da' gwžigan' neto' gonto' da' mal, san bcuase bcue'ejšca neto' len da' mala'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nach gož Jesúsen' ḻegaque': ―Ḻe gon xbab še šejle liž beṉe' migw c̱hele do chel na' ye'lne': “Migw c̱hia', beṉšca neda' šoṉe yetextil. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ba bla' to beṉe' migw c̱hia' beṉe' za' zito', na' bibi de c̱hia' da' gua'ane' gagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na' c̱hixe še migw c̱helen' yo'e ḻo' yo'ote yoži'e xtiža'len': “Bitw gondo' neda' zed, ḻe ba nyeyjw cho'a yo'o na' ba deto' chtasto' len bi' c̱heto' ca'. Bi gac c̱hasa' goṉa' dan' chyažjdo'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chnia' le'e, ḻa'czḻa' naque' migw c̱hele, bitw ye'nde' c̱hase' goṉe' dan' chyažjele, perw še gata'yoelne' sša na' c̱hasšaze' goṉe' bite'tez da' chyažjele. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na' chnia' le'e, še žan bi da' chyažjecho, chṉabchon. Še žan to da' chaclaže'cho želecho, chyiljwchon. Še žan chaclaže'cho saljw beṉe' cho'a yo'o c̱he', na' ṉecho cho'a yo'on cont saljue'. Na' ca'cze cheyaḻa' ye'le Diosen' cate' bi da' chyažjele o bi da' chaclaže'le gone'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na' note'tezle še bi da' ṉabelene', goṉczen'. Na' še bi dan' che'nele gwzejni'ide' le'e, gwzejni'iczden'. Na' note'tezle še žan chaclaže'le gac to da' gac, yoḻ güižle Diosen' can' chon to beṉe' chṉie' cho'a yo'o, nach Diosen' gone' cont gacczen. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Na' le'e nacle x̱a bidao', še xi'iṉle ṉabebe' le'e yetextil, ¿gwnežjwlebe' to yej? Na' še ṉabebe' le'e yid beḻ gagwbe' ¿gwnežjwlebe' to be x̱igüe'? ");
INSERT INTO zpqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na' še ṉabebe' le'e to žit gagwbe' ¿gwnežjwlebe' to bex̱joni'? Cabi gonḻe ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ḻa' nacle beṉe' mal, ṉezczele gwnežjo xi'iṉle to da' güen. Nacchxe güen gon X̱acho Diosen' ben' zoa yaba gwnežjue' Spiritw c̱hen' soan ḻo' yic̱hjlaždao' beṉe' chṉab ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gwzoa to beṉe' gwyo'o gwyaz da' x̱igüe' yic̱hjlažda'ogüe' na' benen cont bi goc ṉie'. Na' Jesúsen' bebeje' da' x̱igüe' ḻo' yic̱hjlažda'ogüe'na'. Na' cate' bechoj da' x̱igüen', na' goc beṉie'. Na' beṉe' ca' že'na' besyebanchgüede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Perw baḻe' gosene': ―Beelzebú dan' chnabia' da' x̱igüe' ca' chaclenen ḻe' cont chebeje' da' x̱igüe' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na' yebaḻe' cont gosagüe' xya c̱he' goseṉabde'ne' gone' to yeḻa' guac da' yesele'ede' ḻe'e yaban' cont yeseṉezde' še da' ḻicze Diosa' gwseḻe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Perw Jesúsen' gocbe'ede' xbab dan' gosone', na' gože' ḻegaque': ―Ša to gobiern choje' c̱hop šoṉ cuen na' yeyoža' yesediḻe' ḻegacze', gobiernṉa' bi sibi'e. Na' še beṉe' to ḻo' yo'o yesechoje' c̱hople na' yesediḻe' ḻegacze', gague sša yesenite' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na' še Satanásen' dan' chnabia' da' x̱igüen' len da' x̱igüe' c̱hen ca' yesechojen c̱hople na' yesediḻen, ḻecze bi sibian', san na' yeyož yedon. Le'e chnale Beelzebún' dan' chnabia' da' x̱igüe' ca' chaclenen neda' cont chebeja' da' x̱igüe' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Šaca' naquen can' žalen', ḻecze zejen dan' chnabia' da' x̱igüe' ca' chaclenen beṉe' ḻježle ca' chesyebeje' da' x̱igüe' zjayo'o zjanyaz yic̱hjlaždao' beṉe'. Beṉe' ḻježle ca' yese'e le'e clelen' žale. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Neda' chebeja' da' x̱igüe' len yeḻa' guac c̱he Dios, na' dan' chona' ca' chlo'en ba bžin ža Diosen' ṉabi'e yic̱hjlaždao' beṉe' yosozenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Satanásen' naquen ca to beṉe' gual, na' neda' naccha' beṉe' gualch. Na' ṉezele cate' to beṉe' gual chape' ližen' len spada, bibi gac c̱he da' de c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Perw cate' žin to beṉe' gualch ca ḻe' na' tiḻlene' ḻe', nach ben' nac beṉe' gualch gon gan. Na' que'e spada c̱he ben' da'na' zoe' lez gaclen ḻe' na' ca'atie' bichle da' de c̱he' na' c̱hisen' len beṉe' migw c̱he' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Beṉe' bi chone' neda' txen, chone' contr neda'. Na' beṉe' bi chaclene' cont yosozenag beṉe' yoble c̱hia', zeje diža' chone' par bi yosozenague' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Na' še to da' x̱igüe' da' gwyo'o gwyaz ḻo' yic̱hjlaždao' beṉe' yechojen, nach lažen nile na'le yeyiljon ga soan mbalaz. Na' še bibi latje želen, nach ṉan: “Da' yoblecze šjayo'a ḻo' yic̱hjlaždao' ben' gan' ba gwyo'a.” ");
INSERT INTO zpqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nach yeyejen da' yoble gan' zoa ben'. Cate' le'en bac̱h cheyone' güen, na' ba zoache' binḻo, ");
INSERT INTO zpqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","nach šjaytoben yegaže da' x̱igüe' ca' da' zjanacch malech ca ḻen, na' txen yeso'on ḻo' yic̱hjlažda'ogüe'na'. Na' še bac̱h goc ca', gacch mal c̱he bena' clel ca dan' ba goc c̱he' da' nechw. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Šlac be' Jesúsen' diža' quinga, gwzoa to no'ole gachoḻ beṉe' ca' že' gan' bsed blo'ede', na' no'ola' gwṉe' zižje, gože'ne': ―Mbalaz zoa no'ola' gwxan le' na' bguaže' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Perw na' Jesúsen' gože'ne': ―Nacchxe mbalaz nita' beṉe' ca' chosozenag xtiža' Diosen' na' chesone' can' žanna'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na' beṉe' zan gosebigue' gosec̱hjde' Jesúsen', nach Jesúsen' gwne': ―Le'e zoale ṉa'a nacchguale beṉe' laždao' xi'a. Chṉable gona' yeto yeḻa' guac da' le'ele cont ṉezele še Diosa' gwseḻe' neda', perw bi gona' ca dan' chṉablena', le ba ble'ele da' ca' chona'. Lete gac c̱hia' can' goc c̱he da' Jonás ben' be' xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na' ca dan' goc c̱he Jonásen' blo'en beṉe' Níneve ca' Diosen' gwseḻe' ḻe', ca'cze dan' gac c̱hia' gwlo'en le'e zoale ṉa'a Diosen' gwseḻe' neda' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cate' žin ža gon Diosen' castigw c̱he yogo'ḻoḻ beṉe' cheson da' mal, da' no'olen' gwnabi'e beṉe' Seba ca' yedecuiše' le'e mbanḻe ṉa'a. Ḻe' gwze'e gan' nac zito'chgua na' bide' nga cont bedezenague' diža' sina' dan' be' da' rey Salomón len ḻe', na' neda' zoa' nga naccha' beṉe' blaoch ca da' Salomón na' bitw chzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na' cate' žin ža gon Diosen' castigw c̱he yogo'ḻoḻ beṉe' cheson da' mal, ḻecze žana' yesyeban beṉe' Nínive ca' na' yosocuiše' le'e nita'le ža ṉa'aža. Ḻe ḻegaque' besyetiṉjde' xtoḻa'gaque' cate' da' Jonásen' gwdix̱jue'ede'ne' can' gwna Diosen'. Na' neda' zoa' nga naccha' beṉe' blaoch ca da' Jonása' na' bi chzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Notno gwguaḻa' to yi' na' gwdosen' caj, na' ṉeca gwcuašen' ga yoble ga nono le'e ḻen, san chde'en ḻe'e ze'e cont gwseṉin' len yogo'ḻoḻ beṉe' yeso'o ḻo' yo'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Žia yejlaocho cont le'echo. Con še bibi chaquen chle'eczecho binḻo. Perw še nc̱hoḻcho, bi chle'echo. Ca'czen' naquen len yic̱hjlažda'ochon'. Še naccho beṉe' laždao' güen, yo'o be'ni' c̱he Diosen' ḻo' yic̱hjlažda'ochon'. Perw še naccho beṉe' mal, c̱hoḻ nac yic̱hjlažda'ochon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Da'nan' ḻe gon cont gacle beṉe' laždao' güen, na' šo' be'ni' c̱he Diosen' yic̱hjlažda'ole. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Še nyeni' yic̱hjlažda'olen' na' bibi da' mal yo'on, gwseṉi'czen xṉezle can' chseṉi' to yi' ga nac c̱hoḻ. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cate' beyož be' Jesúsen' diža' quinga, to beṉe' fariseo gwc̱he'e ḻe' liže' cont yesagüe'. Na' gwyo'o Jesúsen' liž beṉe' fariseon' na' gwchi'e cho'a mesen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na' beṉe' fariseon' bebande' ble'ede' bitw bona' Jesúsen' cate' za' gagüe' can' cheson ḻegaque' chesacde' chebe Diosen' ḻegaque' dan' chesone' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na' X̱ancho Jesúsen' gože' ḻe': ―Le'e beṉe' fariseo nacle ca xiga' ye'eṉ da' chc̱hin beṉe' na' chyibe' cožen' binḻo perw bi chyibe' do ḻo'en. Chonḻe cont chesaque beṉe' nacle beṉe' güen, perw chebele chca'ale bi da' de c̱he beṉe' na' nacle beṉe' mal juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bicze bi chejni'ile. Chi' yic̱hjle gacle xilaže' len cuerp c̱helen'. Ḻecz ca' cheyaḻa' cue' yic̱hjle gacle xilaže' len yic̱hjlažda'ole, ḻe Diosen' ben' bene' cuerp c̱hechon' ḻecze bene' yic̱hjlažda'ochon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ḻe yeyaše' beṉe' na' ḻe gwnežjo bi da' cheseyažjde'. Še gonḻe ca', nacbia' nacle beṉe' laždao' xilaže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Nyaše'chguaze gac c̱he le'e beṉe' fariseo! Ḻa'czḻa' chnežjwle Diosen' to part lao ši part c̱he yix̱e'güej, c̱he yej Santa María, na' c̱he bichle cuan c̱hele, bibi zejen dan' bi chonḻe bichle da' nac da' güen, na' da' bi chaquele Diosen'. Da' nac da' žialao gonḻe, gonḻe da' nac güen na' gaquele Diosen'. Perw bi cuejyic̱hjle gwnežjwle da' ca' chnežjwle Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Nyaše'chguaze gac c̱he le'e beṉe' fariseo! Chzelaže'le cue'le ḻo' yodao' txen len beṉe' blao ca', na' cate' chejle do gan' chac ya'a chaclaže'le yesonxen beṉe' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Nyaše'chguaze gac c̱he le'e chsed chlo'ele da' bzoj da' Moisés na' len le'e beṉe' fariseo! Chonḻe cont nacbia' gan' xoa ba c̱he beṉe' guaten', ḻe ley c̱hechon' žan zjanaquen zban na' bi cheyaḻa' gwlejchon. Perw le'e nacle ca ba da' bi zjanacbia'. Chosozenag beṉe' c̱hele na' bi chesacbe'ede' nacle beṉe' laždao' zban. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","To beṉe' chsed chlo'e ley boži'e xtiža' Jesúsen', gože'ne': ―Maestrw, lagüe da' žo' da' quinga, chaqueton' zi'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na' gož Jesúsen' ḻegaque': ―Ḻecze ca' le'e chsed chlo'ele ley da' bzoj da' Moisés, ¡nyaše'chguaze gac c̱hele! Da' žale da' zan da' cheyaḻa' yeson beṉe', chonḻe leyna' ca to yoa' da' nocze no do'e, to yoa' da' chaclaže'le yesoa' beṉe' yoble, perw le'e ṉe late'ze bi chaclaže'le gua'len. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","’¡Nyaše'chguaze gac c̱he le'e chonšagüe'le cho'a ba c̱he da' beṉe' ca' gosoe' xtiža' Diosen' cani'! Chacle toze len da' x̱ozxta'ole ca' ben' gosote' ḻegaque'. Na' dan' chonḻe ca', zejen chazlaže'le dan' gosote' ḻegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Da'nan' Diosen' lao yeḻa' sina' c̱he' gwne' seḻe' beṉe' yesoe'lene' le'e xtižen' na' seḻe' postlw c̱he' ca' len le'e. Na' gwne' gotle baḻe' na' gwc̱hi gwsaca'le yebaḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na' da' ḻi ba chonḻe can' gwnen'. Da'nan' si'le castigw c̱he yeḻa' got c̱he yogo' beṉe' ca' gosoe' xtižen' gwzolaon caten' gwxete yežlion' chžinten ža ṉa'aža. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Zan beṉe' gosot beṉe' yoble ḻegaque' gwzolaozen len da' Abel ben' beyot da' biše' Caín ḻe', na' beyožen len da' Zacarías ben' gosote' ladjo yodao' blaona' na' ladjo mes de yej dan' zoa chyo'o yodao' gan' chesote' beyix̱e' cont chesonxene' Diosen'. Na' le'e mbanḻe ṉa'a si'le castigw c̱he yeḻa' got c̱he yogo' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Nyaše'chguaze nac le'e chsed chlo'ele ley c̱he Diosen'! Bitw chzejni'ile beṉe' leyna' to ḻicha can' naquen, ṉeca chzenagle c̱hen. Na' beṉe' chesaclaže' yosozenaguen', ṉeca choe'le latje yosozenaguen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na' cate' beyož be' Jesúsen' diža' quinga, nach beṉe' fariseo ca' na' beṉe' ca' chososed chosolo'e ley gosacyožchgüe' len ḻe'. Na' gosaclaže' yesebeje' ḻe' diža' ");
INSERT INTO zpqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ḻe gosaclaže' choj dižan' cho'e da' yosode'ede' yesagüe' xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na' goc zan mil beṉe' besežague' gan' zoa Jesúsen', catec beṉe' zan besežag bosolej bosošošjte ṉi'a ḻježe'. Na' Jesúsen' zgua'tec gwzolagüe' be'e diža' len beṉe' ca' zjanaque' ḻe' txen, gože' ḻegaque': ―Ḻe gwsaca' len levadura c̱he beṉe' fariseo ca'. Dan' cheseziye'e beṉe' cont yesacde' zjanaque' beṉe' güen zaca'leben ca levadura dan' chc̱hix̱ede' yetextil. Bitw gonḻe can' chesonen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ḻe bitwbi de da' ngaše' da' ṉacho cbi gwlo'elaon, ṉeca de da' nono ṉa' ṉeze da' ṉacho cbi yeseṉezden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Da'nan' bite'teze da' gwnale bagaše'ze, beṉe' zan yesenden'. Na' dan' ba gwnale šižize ḻo' yo'o c̱helen', yogo'ze beṉe' yeseṉezden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Beṉe' migw c̱hia', chyix̱jue'eda' le'e bitw žeble beṉe' ca' yesot le'e, ḻe cate' ba gotle bich bi gac yesonde' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","San zoa ben' cheyaḻa' žeble, cheyaḻa' žeble Diosen', ḻe cate' bac̱h beque'e yeḻa' mban c̱hele, ḻecze nape' yeḻa' chnabia' cont yeseḻe' le'e gabiḻ. Da' yoble chnia' le'e, cheyaḻa' žeble Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ṉezecho byiṉ dao' ca' bibi zjazaca'tecba', perw na' Diosen' ṉe toba' bi chanḻaže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na' ca nac chio', da' ḻeca chaque Diosen' chio' ṉeztede' baḻ yiša' yic̱hj to tocho žia. Da'nan' bitw žeble, ḻe zaca'ch le'e clel ca yogo' byiṉ dao' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Na' chnia' le'e, note'tez beṉe' še cho'e diža' len beṉac̱hen' che'ene' chejḻe'e c̱hia', ḻecze ca' neda' gua'a diža' len angl c̱he Diosen' beṉe' že' yaba yapegaca'ne' bena' naque' neda' txen, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na' note'teze beṉe' še cho'e diža' len beṉac̱hen' che'ene' bitw chejḻe'e c̱hia', ḻecze ca' neda' gua'a diža' len angl c̱he Diosen' beṉe' že' yaba yapegaca'ne' bena' bitw naque neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Na' note'teze beṉe' še ṉe' yeḻa' ya' c̱hia' neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h, Diosen' yezi'xene' c̱he' še yetiṉjde'. Perw note'teze beṉe' še ṉe' yeḻa' ya' c̱he Spiritw c̱he Diosen', gwbat yezi'xen Diosen' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Na' cate' yesec̱he'ex̱ox̱je' le'e lao beṉe' gwnabia' c̱he yodaon' o lao justis o še lao nochle beṉe' gwnabia', bi cuec yic̱hjle nac yoži'ile xtiža'gaquen' o še nacle ṉale. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ḻo hor na'teze gwzejni'i Spiritw c̱he Diosen' le'e bin' cheyaḻa' ṉalen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","To beṉe' bchoje' ladjo beṉe' zan juisyw ben' zjanžag na', na' gože' Jesúsen': ―Maestrw, gonšco' mandadw cont beṉe' bišan' goṉe' neda' bien c̱he da' x̱axṉa'to' da' cheyaḻa' si'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Na' Jesúsen' gože' ḻe': ―Bitw naca' neda' juez c̱hele. Bi cheyaḻa' gua' neda' laze da' de c̱hele. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nach gože' yogo'ḻoḻ beṉe' ca' že'na': ―Ḻe gwsaca' cont bi selaže'le bi da' gata' c̱hele yežlio nga, ḻa' de bi de c̱hecho o ḻa' bibi de c̱hecho bi da' chyažj chc̱hinecho, gague da' can' nac yeḻa' mban c̱hecho. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na' be'lene' ḻegaque' to jempl, gwne': ―To beṉe' gwṉi'a gocchgua coseš c̱he', ");
INSERT INTO zpqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","na' bene' xbab ḻo' yic̱hjlažda'ogüe' gwne': “¿Nacxe gona'? Bich bi latje de ga gwže'šagua' coseš c̱hian'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nach gozne': “Quinga gona', yoc̱hiṉja' yo'o gan' že' coseš c̱hia' quinga na' gona' yo'o xench. Na' gwže'šagua' cosešen' na' bichle da' de c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na' lagüe ba de da' yažjda' da' zan iz, bich gona' žin. Ye'ej gagwteza' con da' chaclaža' na' gona' legr.” ");
INSERT INTO zpqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Perw Diosen' gože' bena': “Chono' xbab da' bibi zaca'. Ṉa'aže' bžin hor gato', na' ¿nola ḻo na' gac yogo' da' de c̱hio'?” ");
INSERT INTO zpqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Can' gac c̱he note'tez beṉe' še con chbec yic̱hje' tlaoze da' de c̱he' šlac mbane' na' bi chone' da' chazlaže' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na' gož Jesúsen' beṉe' ca' zjanaque' ḻe' txen: ―Da'nan' žia' le'e, bi gacžejlaže'le bi da' gagwle šlac mbanḻe, na' ḻecz ca' bi gacžejlaže'le c̱he xaḻana'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Zaca'ch yeḻa' mban c̱helen' ca yeḻa' guagw. Ḻecze ca' cuerp c̱helen', zaca'chen ca xaḻana'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ḻe gon xbab c̱he bec̱hj ca', bitw chesazba', bitw chesyelapba', ṉeca zoa da'a xoa' c̱hegacba', ṉeca zoa ga ncua' no goš c̱hegacba' ga že' da' yesagwba', perw na' Diosen' chguagwcze'ba'. ¡Nacchle zaca' le'e ca be ca' zjažia x̱il! ");
INSERT INTO zpqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na' ṉe tole bi gac yostoṉ cuinḻe gašje metr še con cue' yic̱hjle toṉle. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ṉezele bitw gac yostoṉ cuinḻe, na' ṉeca naquen da' zaca'. Da'nan' bi gacžejlaže'le c̱he bica'chle da' chyažjele. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ḻe gon xbab ca nac yej ca' da' zjaze yix̱e'. Chesecha'oczen, bibi žin chesonen, ṉeca chesaḻjen do. Na' chnia' le'e, da' rey Salomón gocue' lache' güen juisyw, perw bitw bžinḻaže' xaḻane'na' ca yeḻa' xdan c̱he yej ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diosen' none' xdan da' ca' ze yix̱en' ḻa'czḻa' to c̱hop žaze nitan' na' chosozeyen'. ¡Nacchxe gon Diosen' len le'e gwleccze yic̱hje' goṉe' yogo' da' chyažjele, le'e late' lasze chejḻe'le c̱he'! ");
INSERT INTO zpqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Da'nan' bitw güe'laže'le cont gata' da' ye'ej da' gagwle. Bitw gacžejlaže'le c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Beṉe' ca' bi chesonxene' Diosen' con chesoe'laže' c̱he bi da' gata' yese'ej yesagüe' na' c̱he xaḻana'gaque'. Perw X̱acho Diosen' ṉezczede' bi da' ca' chyažjele. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Cheyaḻa' güe'laže'le gwzenagle c̱he Diosen' cont ṉabi'e yic̱hjlažda'olen', na' yogo' da' ca' chyažjele, goṉcze Diosen' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Bitw žeble ḻa'czḻa' nac to c̱hople. Diosen' chbede' chnabi'e yic̱hjlaždao' le'e chzenagle c̱he' na' chaclene' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ḻe yeyote' da' de c̱hele cont gata' da' gwnežjwle beṉe' ca' cheseyažje. Še gonḻe ca', Diosen' goṉe' le'e da' zaca'ch na' da' cbi te c̱hen cate' yežinḻe yaba gan' zoe'na'. Na' bitw gac šo' beṉe' gwban que'en, na' ṉeca gac šo' be dao' gwžiayi' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gan' de dan' chaquele nan' zoa yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Ḻe soa ḻe cueze batcan' yida' yeto. Ḻe soa can' nita' beṉe' chesape' liž x̱angaquen' šlac zeje' to yeḻa' güešagna'. Zjanyaz xaḻana'gaque' na' chaḻa' yi'. Nach cate' yežine' na' ṉie' cho'a yo'on, na' ḻa' yesesaljwte' cont yeyo'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mba gac c̱he beṉe' ca' chesebeze' batcan' yežin x̱angaquen'. Še nite' chesebeze' ḻe' caten' yežinen', nach gwsiṉi'e da' yesagüe' na' cuine' gwnežjue' ḻegaque' dan' yese'ej yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mba gac c̱hegaque' še chesebeze' batcan' yežine' ḻa'czḻa' yežine' do chel o do šbal. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ḻe gon xbab c̱he da' nga. Šaca' ṉeze x̱an yo'on baten' žin beṉe' gwban liže'na', ḻe gwṉa'ze' cont bi güe'e latje šo' bena' liže'na' cuane' xšinḻazen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ḻe soa ḻe cueze batcan' yida' da' yoble, ḻe cate' bi chonḻe xbab yida', canan' yida', neda' naca' bena' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedroa' gože' Jesúsen': ―X̱anto', ¿cho'o jempl nga par neto'ze o še par yogo'ḻoḻ beṉac̱h? ");
INSERT INTO zpqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nach gož X̱anchon' Pedroa': ―Naquen par note'tez beṉe' še chone' can' chon mos blao ben' chejni'i, ben' chon can' cheyaḻa' gone'. Ben' chon ca', co' x̱ane' ḻo ne'e ližen' cont ṉe'e mos ca' yezica'chle. Na' gone' da' yesagw to toe' cate' žin hor yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Še to beṉe' mos chonteze' can' ben x̱anen' mandadw gone', mba soe' cate' yežin x̱anen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da' ḻi chnia' le'e, x̱anen' cue'e ḻo na' mosen' yogo'ḻoḻ da' de c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Perw na' še mosen' gone' xbab na' ṉe': “Ba gwže x̱anan'”, na' solagüe' got c̱hine' mosa' yezica'chle na' ye'ej gagwx̱ate' na' sožde', ");
INSERT INTO zpqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nach x̱ane'na' yežine' to ža senyaḻe' ḻe' cate' bi gacbe'ede'. Na' da' bi chon mosen' can' cheyaḻa' gone', x̱ane'na' got c̱hinchgüe' ḻe' na' gone' cont si'e castigw txen len yezica'chle beṉe' bi cheson can' cheyaḻa' yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Na' mos ben' nac beṉe' güedenag, ḻa'czḻa' ba ṉezde' can' che'ne x̱anen' gone', bi chone' ca'. Bi zoe' chbeze' batcan' yežin x̱anen', na' da'nan' x̱anen' got c̱hinchgüe'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Na' beṉe' bi ṉezde' bin' non x̱anen' mandadw gone' na' da'nan' chone' da' zaca' c̱hine' ḻe', na' x̱anen' bi c̱hinteque' ḻe' zi'. Note'teze beṉe' zjanye'chgua xbab, chesego'o beṉe' ḻo na'gaque' da' zan da' yesone', na' chonen byen yesone' yogo' da' ca' zjayo'o ḻo na'gaque' yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nach gwna Jesúsen': ―Dan' zedeyena' yežlio nga naquen ca to yi' da' cuec beṉe'. Na' yebeda' šaca' ba chi' yi'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Za'a cont saca'zi'a na' gata'. Na' chžaglagua' šlac chbeza' žin ža yeyož gaquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Chonḻe xbab beṉe' že' yežlio yesezoa yesebeze' binḻo len ḻježgaque' ṉa'a dan' ba bidan'? Chnia' le'e, bi yesezoa yesebeze' binḻo len ḻježgaque' ṉa'a ba bida', san yesediḻe' na' yosošaše'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Quinga solao gac ṉa'a, še žan nita' gayo' beṉe' to ḻo' yo'o, yesediḻ ḻegacze', c̱hope' contr šoṉe' na' šoṉe' contr c̱hope'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yesediḻ beṉe' byo len xi'iṉe' na' xi'iṉe' len ḻe'. Na' yesediḻ no'olen' len xi'iṉe' no'ole, na' xi'iṉe' no'olen' len ḻe'. Na' yesediḻ no'olen' len xo'oliže' na' xo'oliže' len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nach ḻecze gož Jesúsen' beṉe' ca' nita' na': ―Cate' chle'ele chi' bejw gan' chxoa gwbiža' na' žale: “Gac yejw”, na' chac ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na' cate' chec̱hj be' da' za' ži'le na' žale: “Guac zeye'”, na' chac zeye'. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Beṉe' gwxiye' le'e. Cate' chle'ele nac chac ḻe'e yaban' na' ḻo yežlion' ṉezele še gac yejw o še gac zeye'. ¿Bixc̱hen' bi chacbe'ele bi zejen da' ca' chon Diosen' tiemp nga zoacho ṉa'a? ");
INSERT INTO zpqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Bixc̱hen' bi chonḻe xbab cont ṉezele can' cheyaḻa' gonḻe? ");
INSERT INTO zpqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Cate' to beṉe' gonḻe xya c̱he' na' c̱he'e le'e lao justis, šlac ngo'ole nezen' ḻe yeyiljwlaže' nac gonḻe yezoale binḻo len ḻe' cont bi c̱he'e le'e lao justisen'. Še bitw gonḻe ca', cate' žinḻe lao justisen' nach gone' le'e ḻo na' beṉe' ca' yososeyjue' le'e ḻižya. ");
INSERT INTO zpqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chnia' le'e bitw yebeje' le'e še biṉa' c̱hixjwle doxen da' chaḻa'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na' len beṉe' ca' že'na' gwnita' baḻ beṉe' gosoe'lene' Jesúsen' diža', gose'ene' Pilaton' gwseḻe' soldadw c̱he' ca' jasetue' to x̱oṉj beṉe' Galilea ca' na' bc̱hix̱de' xc̱hengaquen' len c̱he beyix̱e' ca' ba gosote' cont yesonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nach boži'i Jesúsen' xtiža'gaquen' gože' ḻegaque': ―¿Chonḻe xbaba' gosac c̱hegaque' ca' lagüe dan' gosonche' da' malech clel ca beṉe' Galilea ca' yezica'chle? ");
INSERT INTO zpqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chnia' le'e, bi naquen ca'. Še bitw yetiṉjele xtoḻa'le ca', ḻecze gwžin ža cate' cuiayi'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ṉezele c̱he beṉe' šino'šoṉe ca', šlac zjanite' yež Siloé gwbix̱e to campanaryw na' gwdenen ḻegaque' na' gosate'. ¿Ḻecze chonḻe xbab goc ca' dan' zjanacche' beṉe' mal clel ca beṉe' ca' zjaže' Jerusalén? ");
INSERT INTO zpqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chnia' le'e, gague can'. Še le'e bi yetiṉjele xtoḻa'le, ḻecze gwžin ža cate' cuiayi'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na' be'lene' ḻegaque' jempl nga, bzejni'ide'ne' cheyaḻa' yesyetiṉjde' xtoḻa'gaque', na' gože' ḻegaque': ―To beṉe' zoa to yag yix̱güigw c̱he' gan' že' yag uvas c̱he' ca'. Na' gwyeje' ḻo' yaguen' jaṉe'e še de toga yix̱güigw gagüe', perw bitw bi bželde'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na' gože' ben' chape' yag c̱he' ca': “Ba chac šoṉ iz chedeṉa'a yag nga še chbian yix̱güigw, perw bitw bi chbian. Gwc̱hoguen, lažjw con zoan nḻanen, na' ṉeca bi chbiazen.” ");
INSERT INTO zpqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na' gož ben' ḻe': “X̱ana', jayenṉa', za' zoašazen yetgüiz, c̱he'eṉa' xanenṉa' na' cuecan' yo beb. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na' še cuian yix̱güigw do yetgüiz, bitec da' güen, perw še bicze bi cuian, nach c̱hogchon.” ");
INSERT INTO zpqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na' to ža c̱he Dios bsed blo'e Jesúsen' beṉe' že' to ḻo' yodao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na' zoa to no'ole beṉe' ba goc šino'šoṉe iz yo'o nyaz da' x̱igüen' yic̱hjlažda'ogüe'na'. Na' ben da' x̱igüen' cont bdobe cuerp c̱he'na', na' gague gocch se' to ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na' cate' ble'e Jesúsen' ḻe', goxe'ne' na' gože'ne': ―No'ole, ṉa'a yeyacdo' yižgüe' c̱hio' nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na' gwx̱oa ne'e cuerp c̱he no'ola', na' ḻa' bezete' to ḻicha. Na' no'ola' benxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Perw na' beṉe' gwnabia' c̱he yodao'na' bloque' da' beyon Jesúsen' no'ole güen' ža c̱he Dios. Na' gože' beṉe' ca' nita' ḻo' yodaon': ―De x̱op ža cont gonḻe žin. Ḻe da ḻo ža ca' cont yeyone' yižgüe' c̱helen' perw bitw yidle ža c̱he Dios cont yeyacle. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nach X̱ancho Jesúsen' gože'ne': ―Beṉe' gwxiye' le' len beṉe' ḻježo'. ¿Gague ḻo ža c̱he Dios bia'cze chsežle go'ṉ c̱hele o burr c̱hele ga zjada'ba' chjasanḻba' güe'ej nis? ");
INSERT INTO zpqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","No'ole nga naque' xi'iṉ diaža c̱he da' Abraham, na' Satanásen' dan' chnabia' da' x̱igüe' ca' benen cont ba bdobe cuerp c̱hen' šino'šoṉe iz. Da'nan' nacczen ḻicha ba beyona'ne' ža c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cate' gwne' ca', beṉe' ca' chesegue'e ḻe' gosacde' zto', perw yogo'ḻoḻ beṉe' ca' yezica'chle nita'na' besyebanchgüede' len yogo' dan' ben Jesúsen', ḻe ḻeca güen zjanac dan' benen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nach gwna Jesúsen': ―Ṉa'a gwlo'eda' le'e cont ṉezele šanch beṉe' yosozenag c̱he Diosen' cont ṉabi'e yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Da'nan' yeḻa' gwnabia' c̱he Diosen' naquen ca biṉ c̱he xomdas. To beṉe' gozen' na' cate' blan' gwcha'on goquen yag cha'o na' be ca' zjazoa x̱il goson ližgacba' ḻo xoze' yaga'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nach da' yoble gozne': ―Ṉa'a ṉia' le'e yelate' nac nac yeḻa' gwnabia' c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Naquen ca levadura dan' gwlec no'olen' len to rob yezj cont gwcha'o doxenen. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na' gwda Jesúsen' bsed blo'ede' beṉe' ca' že' ciuda ca' na' yež ca' gan' bedie' cont bežine' Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na' to beṉe' gože' Jesúsen': ―X̱anto', ¿con to c̱hopze beṉe' šjasyenite' len Diosen'? Nach Jesúsen' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Chnia' le'e, beṉe' zan chese'nde' yeseṉite' binḻo len Diosen', perw gwžin ža cate' bich gac yesone' cont yeseṉite' binḻo len ḻe'. Da' nac žialao gonḻe, c̱hiljwlaže'le nac gonḻe cont soale binḻo len Diosen' ");
INSERT INTO zpqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","cont bi gone' len le'e ca ben to x̱an yo'o cate' bžin hor gwseyjuen'. Gwzože'e bseyjue', na' gwdechle besežin beṉe' bososiže' ḻe'e puert c̱he'na' na' bich gwsaljue' cont yeso'e. Na' gose'ene': “Gwsaljwšca cont šo'to'.” Na' gože' ḻegaque': “Bitw nombi'a le'e, ṉeca ṉezda' ga za'acle.” ");
INSERT INTO zpqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Can' gac c̱he baḻle. Nach solaole ye'lne': “Güe'ej gwdagwto' len le' na' bsed blo'edo' neto' la cay lažto'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Perw na' da' yoble ye'e le'e: “Bitw ṉezda' ga beṉe' le'e. Ḻe šjaya'ac yogo' le'e beṉe' güen da' mal.” Can' ye'e le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na' le'ele Abraham na' Isaac na' Jacob na' yogo'ḻoḻ beṉe' ca' gosoe' xtiža' Diosen' cani' nite' yaba gan' zoa Diosen' chnabi'e. Na' le'e bitw gac šo'lena'. Nach cuežyaše'le na' gagwxejte ḻayle dan' ḻeca žaglaole cate' gacbe'ele bich gac šo'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Beṉe' zan beṉe' za'ac doxen yežlio yesyežine' yaba gan' zoa Diosen' chnabi'e na' yesebi'e cho'a mes yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nita' beṉe' zjanaque' beṉe' bzebe ṉa'a perw gwžin ža cate' yesaque' beṉe' žialao. Na' nita' beṉe' zjanaque' beṉe' žialao ṉa'a, perw gwžin ža cate' yesaque' beṉe' bzebe. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ḻo ža na'teze baḻ beṉe' fariseo ca' besežine' gan' zoa Jesúsen' gose'ene': ―Cheyaḻa' yoxoṉjo' nga gan' chnabia' rey Herodes, ḻe chaclaže' gote' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesúsen' gože' ḻegaque': ―Herodesen' naque' ca to beza' yeḻa' gwxiye' c̱hen'. Ḻe šja'ac na' ye'lne' yeto c̱hope žazen' soa' yebejcha' da' x̱igüe' ca' zjayo'o zjanyaz yic̱hjlaždao' beṉe' na' yeyoncha' beṉe' chesacšene. Ba zoa yeyož gona' dan' cheyaḻa' gonan'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Perw ca nac dan' chona' ṉa'a gonchczan' gwx̱e güižj. Gague ngan' chesote' beṉe' ca' chesoe' xtiža' Diosen', san Jerusalén chesote' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Le'e beṉe' Jerusalén, chotle beṉe' ca' chesoe' xtiža' Diosen' na' ca nac nochle beṉe' ca' chseḻa' Diosen' len le'e, chc̱heḻlene' yej. Zan ṉi'a goclaža' yotoba' le'e ca to jed xcaca' be nc̱he' xi'iṉ na' chyežba' ḻegacba', perw bitw goclaže'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na' ṉa'a ba gwlejyic̱hj Diosen' le'e. Na' chnia' le'e, bich le'ele neda' ṉa'a. Cate'ch žin žana' ṉale: “Mbalaz ben' za' nga nseḻa' X̱ancho Diosen' ḻe' cont ṉabi'e”, cana'ch le'ele neda' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na' to ža c̱he Dios Jesúsen' gwyeje' jatagüe' liž to beṉe' fariseo ben' nac beṉe' blao. Na' yezica'chle beṉe' fariseo ca' chosogüia cheseṉe'e bixen' goncze' cont gata' da' yosode'ede' yesagüe' xya c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na' lagüe'na' zecha to beṉe' chacšene, de cuerp c̱hen' yi. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na' gož Jesúsen' beṉe' fariseo ca' na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés: ―¿De ḻsens len ley c̱hechon' yeyoncho to beṉe' güe' ža c̱he Dios o še bitw bi ḻsens de? ");
INSERT INTO zpqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Perw notno boži'i xtiže'na'. Nach Jesúsen' bex̱ue' na' bena' na' beyone' ḻe', na' gože'ne': ―Guac yeyejo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nach gož Jesúsen' beṉe' ca' že' liž beṉe' fariseon': ―Le'e še zoa to burr o to go'ṉ c̱hele na' lažo'ba' to ḻo' yechw sitjw, ¿cabi ḻa' yebejteleba' ḻa'šaze nac ža c̱he Dios? ");
INSERT INTO zpqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na' nono goc yoži'i xtiža' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na' ble'e Jesúsen' can' cheson beṉe' ca' gosaxe' liž beṉe' fariseon', gosebeje' gan' zjachi' beṉe' blao ca' cont gosebi'ena'. Na' Jesúsen' be'e to jempl, gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Cate' to beṉe' gaxe' le'e gan' chac güešagna', bitw cue'le gan' cheyaḻa' cue' beṉe' blao ca', ḻe še cue'le na', guacte yid beṉe' nacch beṉe' blao ");
INSERT INTO zpqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na' x̱an yo'ona' ye'e le'e: “Ḻe soža' cont cue' benga.” Nach do chaquele zto' soža'le cue'le ga yoble len beṉe' ca' bitec bi zjazaca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Na' cate' gan' gaxe' le'e cue'le len beṉe' bitec bi zjazaca', na' cate' yid x̱an yo'ona' na' ye'e to tole: “Beṉe' migw c̱hia', da cui'o len beṉe' blao ca'.” Nach gacxenḻe lao beṉe' ca' zjachi' len le'e cho'a mesen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ḻe note'teze beṉe' chonxen cuine', Diosen' gone' cont si'e zto' lagüen'. Na' note'teze beṉe' chzex̱jwlaže' lagüen', Diosen' gone' cont gacxene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na' ḻecze gož Jesúsen' ben' goxe' ḻe' ližen': ―Cate' gono' to ḻṉi na' gaxo' beṉe' yesagüe' len le', bitw gaxo' beṉe' biše' ḻježo', beṉe' migw c̱hio' o beṉe' zjanaque' beṉe' gwṉi'a. Ḻegaque' ḻecze yesaxe' le' ližgaquen', na' yesyegüe'e gwzon lagüe dan' ba goxgaco'ne' ližo'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cate' gono' to lṉi gox beṉe' yaše' na' beṉe' nchog no ṉi'a na'gaque', beṉe' nxiṉj ṉi'e, na' beṉe' lc̱hoḻ. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Še gaxo' ḻegaque', Diosen' gone' so' mbalaz, ḻe beṉe' ca' bi gac yesyegüe'e gwzon c̱hio'. So' mbalaz cate' Diosen' yosbane' le' ladjo beṉe' guat ca' txen len yezica'chle ben' ja'ac to ḻicha cate' gosebane'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na' to beṉe' chi' cho'a mesen' txen len Jesúsen' bende' xtiže'na' na' gože'ne': ―Mbalaz soacho gagwcho ḻo ḻṉi da' gac caten' ba chnabia' ben' seḻa' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nach Jesúsen' gwne': ―To beṉe' bene' to ḻṉi xen, na' goxe' beṉe' zan šja'ac ližen' cont yesagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na' cate' bžin hor yesagüe', na' x̱an yo'ona' gwseḻe' xmosen' cont šjatobe' ḻegaque' yesagüe'. Na' cate' jaṉe'e to toe', gože' ḻegaque': “Ḻe šo'o, ba bsiṉi'e dan' gagwchon'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na' yogo'ḻoḻe' gose'e ben' bi zjazoe' latje šja'aque' gan' chone' ḻṉin'. Beṉe' nechon' gwne': “Za' gwxia' to yežlio, na' cheyaḻa' šjaṉa'an. Na' ye'šco' x̱anon' bitw gac yida'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na' yetoe' gwne': “Za' gwxia' gayo' cue' go'ṉ na' ṉa'a šjengaca'ba' prueba. Ye'šco' x̱anon' si'xene' c̱hia', bitw gac yida'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na' yetoe' gože'ne': “Za' bšagna'. Da'nan' bitw gac yida'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na' mosen' beyeje' na' jayeže' x̱anen' can' gose' beṉe' ca' ḻe'. Nach x̱an yo'ona' ben' chon ḻṉin' bže'e. Nach gože' xmosen': “Gwyej jata to to cay na' to to nez ḻo ciudan', na' gwtobo' beṉe' yaše' na' beṉe' nchog ṉi'a na'gaque' na' beṉe' nxiṉj ṉi'e, na' beṉe' lc̱hoḻ cont yeside' yesagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Gwde bene' ca' nach gože' ḻe': “X̱ana', ba jatoba' beṉe' ca' ba gwnaon', na' ṉe' dechcze latje par beṉe' yoble.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nach x̱ane'na' gože' ḻe': “Bchoj ḻo' ciudan' na' gono' byen yesid ben' nita' chanez. Na' šjax̱i'o beṉe' ca' zjaže' yix̱e'. Gono' byen yeside' liža' nga yesagüe' cont yežan' bich bi latje šo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na' ca nac beṉe' ca' goxa' da' nechw, bich gua' latje yesagw ḻegaque' dan' ba bsiṉi'ana'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na' beṉe' zan juisyw zjana'ogüe' Jesúsen', na' gwyec̱hje' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Note'teze beṉe' še chaclaže' šejnilaže' neda' na' gwzenague' c̱hia', še bi gacchde' neda' clel ca x̱axṉe'e, no'ol c̱he', xi'iṉe', biše', zane', na' lente cuine', bi gac gone' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na' note'teze beṉe' bi chzanḻaže' cuine' saca'zi'e o gate' ṉe c̱hia' neda', ḻecze bitw gac gone' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Še tole che'nele gonḻe to campanaryw, zgua'tec cue'le na' gonḻe xbab gwsaca'le ca do gaca' da' chyažjele cont gonḻen, še gaque xmechwle cont yeyož campanaryon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Še bi gwchix̱ gwtoḻe xbab c̱helna' gaca'te' dan' chyažjele, cate' ba gwlecle lenenṉa' na' gacbe'ele bich bi mechw de cont yeyožen, na' yogo' beṉe' yesele'ede' lenenṉa' yesezi'diže' le'e, ");
INSERT INTO zpqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yesene': “Benga gwzolao chone' to campanaryw perw bitw beyož xšinen'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na' še to rey chone' xbab tiḻe' len yeto rey, ḻecze zgua'tec gwsaque' še gwzoede' len ši mil soldadw c̱he' gone' gan yeto rey beṉe' nc̱he' gaḻje mil soldadw. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na' še chacbe'ede' bi gone' gan, šlac ṉe' zoa ben' yeto, zito', seḻe' ben' šjasedie' xtižen' lao rey ben' yeto yeseṉabe' yesyenite' binḻo. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ca' naquen len le'e, note'tezle še bi cuejyic̱hjle yogo'ḻoḻ bi da' de c̱hele, bitw gac gonḻe neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Zeden' naquen güen, perw na' še bich naquen zxi', ¿nacxe goncho cont yeyaquen zxi' da' yoble? ");
INSERT INTO zpqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bibi zacan', ṉeca gaclenen yežlio, ṉeca gaquen par beb, lete c̱ho'oṉchon. Le'e žia nagle da' chene, ḻe gwzenag xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na' beṉe' güec̱hixjw ca' na' yebaḻe beṉe' güen da' xiṉj, yogüe' gosebigue' gan' zoa Jesúsen' cont gosende' xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na' beṉe' fariseo ca' na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés gosezi'diže' ḻe', gosene': ―Benga chlebe' beṉe' güen da' xiṉj ca' na' chagwlene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nach Jesúsen' be'e to jempl, gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Še nita' to gayoa xila' c̱hele na' gacžeje toba', ¿bi yocua'aṉle be ca' taplaḻj togaḻj gan' že'ba' latje daša' na' šjaydiljwle ben' ba gocžejena' cont yeželba'? ");
INSERT INTO zpqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na' cate' yeželban' yebechgüele na' yex̱oalba' ya'axic̱hjle yeyoa'lba'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na' cate' yežin ližle, gwtoble beṉe' migw c̱hele na' beṉe' gualiž c̱hele na' ye'lne': “Ḻe yebe len neda'. Ba bežel xila' c̱hia' ben' gocžeje.” ");
INSERT INTO zpqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chnia' le'e, gwbeche Diosen' txen len angl c̱he' ca' cate' to beṉe' chon da' mal yetiṉjde' xtoḻe' clel ca yesyebede' c̱he tapḻaḻj togaḻj beṉe' zjanaque' beṉe' güen beṉe' bitw de xtoḻa'gaque' da' yesyetiṉjde'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Na' le'e no'ole še de ši mechw plata c̱hele na' še ṉit ton, ḻa' gwguaḻa'tele to yi' na' gwḻoale ḻo' yo'o c̱hele na' yeyiljwyožlen cont yeželen. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na' cate' yeželenṉa', na' yotoble no'ole migw c̱hele ca' na' beṉe' gualiž c̱hele na' ye'le ḻegaque': “Ḻe yebe len neda', ḻe ba beželda' mechw c̱hia' dan' gwnit.” ");
INSERT INTO zpqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chnia' le'e ḻecze chesyebe chesyezaque' angl c̱he Diosen' beṉe' zoa yaba cate' to beṉe' chon da' xiṉj chetiṉjde' xtoḻe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na' ḻecze gože' ḻegaque': ―Gwzoa to beṉe' na' gwnita' c̱hop xi'iṉe' beṉe' byo. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na' bžin ža beṉe' xcuiden' gože' x̱en': “X̱a', beṉ neda' dan' cheyaḻa' sia' da' de c̱hio'.” Nach x̱en' bnežjue' dan' cheyaḻa' si'en. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Goc to c̱hop ža nach beṉe' xcuiden' btobe' yogo'ḻoḻ bi da' de c̱he' na' gwze'e gwyeje' nación zito' na' zlez da' bi zaca' jene'. Na' benditjde' xmechue'na' zejlene' da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na' cate' beya xmechuen', goc to gwbin juisyw doxen naciónṉa', na' bich bi gota' xmechue' cont si'e da' ye'ej gagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Da'nan' gwyeje' gan' zoa to beṉe' naciónṉa' gwṉabe' žin, na' bena' gwseḻe' ḻe' yix̱e' ga že' be zan xcoše' na' jayoe'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na' catec gwdone' goclaže' gagüe' dan' chosonežjue' chesagw coš ca', perw ṉe ḻen ca bosonežjue' ḻe' gagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na' beyone' to xbab šagüe', gwne': “Nita' mos zan c̱he x̱an' na' dechgua da' chesagüe', na' neda' gatda' yeḻa' chdon. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yeza' nga na' yeya'a gan' zoa x̱a' na' yapa'ne' bena' da' mal lao Diosen' na' lao ḻe', ");
INSERT INTO zpqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","na' bich zaca' gone' neda' cuent ca xi'iṉe', con še goṉe' latje gaca' ca to xmose'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nach beze'e beyeje' gan' zoa x̱en'. Na' zito'le za' yežine' cate' ble'e x̱en' ḻe' na' beyaše'de' ḻe' na' gwza'sese' jašague'ne'. Na' gwdeḻe'ne' bnope'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nach gož xi'iṉe'na' ḻe': “X̱a', ba bena' da' mal lao Diosen' na' laguo' le'. Bich zaca' gono' neda' cuent ca xi'iṉo'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Na' x̱e'na' gože' xmose' ca': “Ḻe šjaḻej tgot lache' šagüe', ḻe guacwben', na' ḻe šjax̱i' to niy na' ḻe co'on xbembe', na' ḻe šjax̱i' šcue' yel na' gwdelen ṉi'abe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na' ḻe šjax̱i' go'ṉ dao' ben' chaṉe' na' ḻe gotba' cont gagwchoba', ḻe goncho ḻṉi. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Xi'iṉa' nga ba bena'be' cuent ca to bi' guat, perw ṉe' zoabe' mbambe' ṉa'a. Gwlejyic̱hjbe' chio', perw ṉa'a ba bela'be'.” Na' gosezolaogüe' chesone' ḻṉi. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Na' xi'iṉe' beṉe' nechon' zeje' yix̱e' cate' bežin xi'iṉen' yeto ben' benditje xmechuen', na' cate' zeza' ben' gwyej yix̱en', ba zoa yežine' liž x̱en' cate' bende' chosocueže' na' chosoye'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na' goxe' to mosen' na' gwṉabde' ḻe' bixc̱hen' chesone' ḻṉi. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na' mosen' gože'ne': “Bi' bišo'na' ba bela' na' x̱aon' ba betue' go'ṉ daon' ben' chaṉe'chgua da' bela'be' to šagüe' to güen.” ");
INSERT INTO zpqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nach xi'iṉe' nechua' bže'e na' bi goclaže' yeyo'e liž x̱en'. Na' bchoj x̱en' na' gota'yoede' ḻe' yeyo'e yo'o. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Perw xi'iṉe' beṉe' nechua' gože' x̱en': “Zan iz ba chac zoa' nga chonteza' žin con can' žo' le', na' biṉa' gaca' beṉe' güedenag. Na' ṉe to šib dao' caṉa' goṉo' neda' cont gota'ba' gona' ḻṉi len beṉe' migw c̱hia' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na' ṉa'a ba bela' xi'iṉo' nga benditjbe' yogo'ḻoḻ da' bnežjo'be' gwdalembe' no'ole zḻe', na' beto' par ḻebe' go'ṉ dao' ben' chaṉe'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na' x̱e'na' gože'ne': “Xi'iṉdagua', le' zoatezo' len neda', na' yogo'ḻoḻ da' de naquen c̱hio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Perw cheyaḻa' goncho ḻṉi nga ṉa'a da' chbechgüecho ba bela' bi' bišon', ḻe ba bena'be' cuent ca to bi' guat, perw ṉa'a zoabe' mbambe'; gwlejyic̱hjbe' chio', perw ba bela'be'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nach gož Jesúsen' beṉe' ca' zjanaque' ḻe' txen: ―Gwzoa to beṉe' gwṉi'a na' gwzoa to mos blao c̱he' ben' gwyo'o ḻo ne'e yogo'ḻoḻ da' de c̱he'. Na' beṉe' gwṉi'ana' bende' rson xmose' blaon' ba benditjde' bi da' de c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na' x̱anen' goxe' ḻe' na' gože'ne': “Ba benda' diža' can' chonon'. Cheyaḻa' yodio' cuent yogo'ḻoḻ da' ba benditjedo' c̱hia'. Bich gac gono' xšinan' ṉa'a.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nach mosen' bene' xbaben': “¿Bixe gona' ṉa'a? X̱anan' ba cholague' neda'. Bich gac gona' xšinen', na' ṉeca gac goncha' žin gual, na' gacda' zto' še ṉaba' carida. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ṉezda' bi gona' cont ṉita' beṉe' yeseṉe'e neda' cate' bich chona' žin c̱he x̱anan'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nach goxe' yogo'ḻoḻ beṉe' ca' chesaḻa' xmechw x̱ane'na' tgüej tgüeje' na' gože' beṉe' nechw: “¿Gaca' chaḻo' c̱he x̱ana'?” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na' bena' gože'ne': “Chaḻa' c̱he tap mil litrw set.” Nach gož mos blaona' ḻe': “Bedao'nez gwche'edo' na' bzoj ḻo cuenten' bzoan chaḻo' c̱he c̱hop mil litrwze seten'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gwde na' gože' beṉe' gwchopen': “¿Gacan' chaḻo' c̱he x̱anan'?” Nach bena' gože'ne': “C̱haḻa' c̱he to mil rob trigw.” Nach mosen' gože' bena': “Gwche'edo' na' bzoj ḻo cuent c̱hio'na' bzoan chaḻo' c̱he x̱ono' gayoa robze trigon'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na' x̱an mos gwxiyen' gocbe'ede' xmosen' ḻeca nye'e xbab da' beyiljwlaže' nacle gone' soe' binḻo len ḻježe' beṉe' ca' chesaḻa' c̱he x̱anen'. Ḻe beṉe' ca' zjachi' yic̱hje' to zleze dan' chac ḻo yežlion' chesonchgüe' xbab nacle yesone' len dan' zjade c̱hegaque', perw zan beṉe' ba zjayo'o be'ni' c̱he Diosen' ḻo' yic̱hjlažda'ogaque' bitw chesone' xbab naclen' yosoc̱hine' dan' de c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Na' chnia' le'e, dan' de c̱hele yežlio nga da' te c̱hen', perw ḻe gwc̱hinen cont ṉita' migw c̱hele. Na' cate' ba beya bi dan' de c̱hele yežlio nga, nach ṉita' beṉe' yosolebe' le'e cate' yežinḻe yaba gan' soale toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Še to beṉe' chone' can' cheyaḻa' gone' len da' bibi zaca'tec, ḻecz ca' gone' len da' zaca'chgua. Na' beṉe' bi chone' can' cheyaḻa' gone' len da' bibi zaca'tec, ḻecz bitw gone' can' cheyaḻa' gone' len da' zaca'chgua. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Še le'e bi chonḻe can' cheyaḻa' gonḻe len dan' de c̱hele yežlio nga da' te c̱hen', bitw goṉ Diosen' le'e da' zaca'ch da' bi te c̱he. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dan' de c̱hele yežlio nga, c̱he Diosen' gague c̱helen'. Na' še bitw chonḻe can' cheyaḻa' gonḻe len da' nac c̱he', bitw goṉe' le'e da' zaca'ch da' bi te c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nono mos gac gone' žin len c̱hop x̱ane' to ši'ize, ḻe še gone' ca', gue'ede' to x̱an žinṉa' na' gacde' yetoe'; o gone' žin c̱he toe' do yic̱hj do laže' na' c̱he ben' yeto gonen' do chža'alaže'ze'. Ḻecze ca' le'e, bitw gac gonḻe xšin Diosen' do yic̱hj do laže'le na' gonte xšinḻe cont gacle beṉe' gwṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na' ḻecze nita' beṉe' fariseo ca' chesende' xtiža' Jesúsen', na' gosezi'diže' ḻe', ḻe gosaclaže' yesaque' beṉe' gwṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na' gož Jesúsen' ḻegaque': ―Le'e chonḻe cont beṉac̱hen' chesacde' chdaczle ḻicha, perw Diosen' ṉeze nle'ede' yic̱hjlažda'ole, na' Diosen' chgue'ede' baḻ da' chesaque beṉac̱hen' zjanaquen da' žialao xen. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na' gozna' Jesúsen': ―Gwzolaon cani'te bžinten cate' bla' Juanṉa' bedetix̱jue'ede' xtiža' Diosen', ley dan' bzoj da' Moisés len dan' bosozoj yezica'chle beṉe' gosoe' xtiža' Diosen' bzejni'in chio' c̱he Diosen'. Na' ṉa'a gwzolaon len Juanṉa', ṉe' nita'cze beṉe' cheseyix̱jue'ede' Diosen' ṉabi'e yic̱hjlaždao' beṉe' yosozenague' c̱he'. Na' beṉe' zan cheseyiljue' nacle yesone' cont ṉabia' Diosen' yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ḻa'czḻa' še yežlion' len da' ca' zjažia ḻe'e yaban' yesede c̱hegaquen, ca nac Xtiža' Diosen' dan' nyojen, ṉe late' daon' cbi te c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Note'teze beṉe' chele'e len no'ol c̱he' na' cheque'e no'ole yoble chone' da' xiṉj, tozcze ca naquen šaca' gata'lene' no'ol c̱he beṉe' yoble. Na' note'teze beṉe' yošagna'lene' to no'ole beṉe' bela'a len beṉe' c̱he', ḻecze tozcze ca da' xiṉj gone' len dan' chon beṉe' chata'lene' no'ol c̱he beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nach gozna' Jesúsen': ―Gwzoa to beṉe' gwṉi'a na' xdanchgua goc xaḻane'na', na' ḻeca gwdagwšagüe' yogo' ža. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na' to beṉe' yaše' le' Lázaro, yogo' ža jasedix̱jue' ḻe' cho'a puert zaguan c̱he beṉe' gwṉi'ana' cont gwṉabe' yosonežjue'ne' con gaca' da' chesezande'. Na' Lázaron' ḻeca gwžia yežo' doxen cuerp c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Na' catec gwdone' goclaže' gagüe' bla'a dao' yeḻa' guagw da' beselažo' cho'a mes c̱he beṉe' gwṉi'an'. Na' beco' ca' ja'acba' jaseḻe'eba' yežo' dan' gwžia cuerp c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na' got beṉe' proben' nach angl beṉe' že' gan' zoa Diosen' besyezi' besyeque'e ḻe' yaban' gan' zoe' ṉa'a len da' x̱ozxta'ocho Abraham. Na' ḻecze got beṉe' gwṉi'ana' na' bosocuaše'ne' ");
INSERT INTO zpqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","na' beyeje' ḻo yi' gabiḻ. Na' šlac chžaglagüe' na' gwḻis lagüen' na' ble'ede' zito'le nita' da' Abraham len Lázaron' yabana'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nach beṉe' gwṉi'an' gwṉe' zižje gwne': “X̱a' Abraham, beyaše'laže'šca neda' na' gwseḻa' Lázaron' cont yosbise' ḻoža' nga len late' nis da' gwlapa' xbene'na', ḻe ḻeca chžaglagua' ḻo yi' nga.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Perw na' Abrahanṉa' gože' ḻe': “X̱i'iṉa', bosa'laže' cate' gwbano' yežlio zleze da' šagüe' da' güen gota' c̱hio', na' Lázaro nga to zleze da' mal goc c̱he'. Na' ba zoe' mbalaz nga ṉa'a na' le' chžaglaguo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bi gac gona' can' chaclažon', ḻe Diosen' bac̱h nze' to bdiṉj xen ga nono gac te, cont nono gac sa' nga šeje' gan' zon', ṉeca nono gac sa' gan' zon' na' yide' nga.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nach beṉe' gwṉi'ana' gože' Abrahanṉa': “Beṉe' gol dao', chata'yoeda' le' gwseḻa'šca Lázaron' liž x̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nita' gayo' beṉe' biša' na' che'nda' šjatix̱jue'ede' ḻegaque' nac yesone' cont Diosen' bi yeseḻe' ḻegaque' latje nga gan' yesežaglagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Na' Abrahanṉa' gože' ḻe': “Decze dan' bzoj da' Moisésen' na' dan' bosozoj yezica'chle beṉe' ca' goso'e xtiža' Diosen' cani'. Cheyaḻa' yosozenague' c̱he da' ca' zjanyojen.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na' gože' Abrahanṉa': “Bitw, beṉe' gol dao'. Še to beṉe' yebane' ladjo beṉe' guat na' güe'lene' ḻegaque' diža', nach yesyetiṉjde' xtoḻa'gaquen'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nach gož Abrahanṉa' ḻe': “Še bitw chosozenague' c̱he dan' bzoj da' Moisésen' na' dan' bosozoj yezica'chle beṉe' ca' goso'e xtiža' Diosen', ḻa'czḻa' še yeban to beṉe' ladjo beṉe' guat ca', bi yesejḻe'cze' c̱he Diosen'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na' gož Jesúsen' beṉe' ca' zjanaque' ḻe' txen: ―Decze da' gonen cont lažo' beṉe' yesone' da' xiṉj, perw nyaše'chguaze gac c̱he beṉe' chone' cont beṉe' yoble yesone' da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yejṉi'a šaca' yosoc̱heje' yene' to yiše na' šjasezaḻe' ḻe' ḻo' nisdao' clel ca soe' gone' cont to beṉe' za' gwzolagüe' chejnilaže' neda' lažoe' gone' da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Da'nan' ḻe gwsaca' cont bi gonḻe ga lažo' beṉe' gone' da' xiṉj. ’Na' še to beṉe' ḻježle gonde' le'e mal, ḻe tiḻe' na' še gwše'e xbab na' ṉe' bich gone' ca', ḻe yezi'xen c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ḻa'czḻa' gaž ṉi'a lao tža gone' da' mal contr beṉe' ḻježen', še gaž ṉi'ate ṉe': “Ba betiṉjda' c̱he dan' benan', bezi'xen c̱hia'”, na' cheyaḻa' yezi'xene' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na' gose' postlw ca' X̱ancho Jesúsen': ―Gaclenšco' neto' cont šejḻe'chto' c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nach gož X̱anchon' ḻegaque': ―Xsa yag xomdas naquen da' dao' riz, na' ḻa'czḻa' dan' chejnilaže'le Diosen' naquen ca to xsa xomdas lagüe dan' bi chejnilaže'teclne', še šejnilaže'lne', guaque ye'le yag nga: “Gwcuase nga na' jayzoa ḻo' nisdaon'”, na' guaccze can' nalna'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Le'e še mos c̱helen' chgua'aṉe' go'ṉ, o še chyoe' xila', cate' chele'e güeyeban' bitw che'lne': “Beyo'o ngale, gwche'edo' gaguo' xše'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","San che'lne': “Bsiṉi'a da' ye'ej gagua' na' goṉon'. Te yedaguan' nach gago'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na' bitw cho'elne' yeḻa' chox̱clen cate' ba bene' dan' gožlene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na' ḻecz ca' le'e, cate' ba benḻe yogo'ḻoḻ dan' ža Diosen' gonḻe, cheyaḻa' ṉale: “Bitw zaca'to' no goṉ yeḻa' chox̱clen c̱heto' ca dan' ba bento', ḻe bento' con da' cheyaḻa'cze gonton'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na' zej Jesúsen' Jerusalénṉa' len beṉe' ca' zjanaque' ḻe' txen na' gwdie' gan' ndiḻ distritw Samaria len distritw Galilean'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na' besežine' to cho'a yež dao' na' besechoj ši beṉe' chese'e yižgüe' da' nzi' lepra jasešague' Jesúsen'. Na' gosezie' zito' ");
INSERT INTO zpqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na' goseṉe' zižje gosene': ―Maestrw Jesús, beyaše'laže' neto'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na' Jesúsen' cate' ble'ede' ḻegaque' na' gože'ne': ―Ḻe šjaya'ac lao bx̱oz ca' cont yeseṉe'e le'e še ba beyacle. Na' goquen' ḻo neza' besyeyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nach toe' cate' gocbe'ede' bac̱h beyaque', na' bebi'e na' gwṉie' zižje benxene' Diosen', ");
INSERT INTO zpqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","na' bzoa xibe' lao Jesúsen' bi'e ḻe' yeḻa' chox̱clen. Ben' ben ca' naque' to beṉe' Samaria. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nach gwna Jesúsen': ―Beyona' ši beṉe'. ¿Gaṉxe beṉe' ca' yega? ");
INSERT INTO zpqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Toz beṉe' zito' nga bebi'e chonxene' Diosen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nach gož Jesúsen' bena': ―Bezoža' beyej to šagüe' to güen. Ba beyacdo' da' chejnilažo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na' beṉe' fariseo ca' goseṉabde' ḻe' batxen' yid ben' seḻa' Diosen' ṉabi'e nación Israelen'. Nach boži'i Jesúsen' xtiža'gaquen' gwne': ―Ca nac yeḻa' gwnabia' c̱he Diosen', bi naquen da' le'echo. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nono cheyaḻa' güe' diža' ṉe': “Gwṉa' nga chnabi'e”, o “Gwṉa' na' chnabi'e.” Ḻe ba zoe' len le'e ṉa'a chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nach gože' beṉe' ca' zjanaque' ḻe' txen: ―Gwžin ža cate' ṉale: “Šaca' ṉa'a ba chnabia' ben' gwseḻa' Diosen'”, perw bitw gac can' ṉablaže'len'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yesenita' beṉe' yesi'e le'e: “Gwṉa'šc nga zoa ben' gwseḻa' Diosen'”, o “Gwṉa'šc na' zoa ben' gwseḻa' Diosen'.” Perw bitw ga'ole ben' yesi'e le'e ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Can' chac cate' chep yes, chseṉin' doxen ḻe'e yaban' zejzenez, ḻecze can' gac cate' žin ža yida' da' yoble, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Yida' zejzenez na' yogo'ḻoḻ beṉe' yesele'ede' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Zgua'tec de da' zan da' cheyaḻa' saca'zi'a na' beṉe' ca' že' ṉa'a bitw yesejḻe'e c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ḻecz ca' goc ca tiemp c̱he da' Noé, ḻecze ca' gac cate' ba zoa žin ža yida' da' yoble, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Beṉe' gwnita' ca tiemp c̱he da' Noén' gosaše' gose'ej gosagüe' goso'elaže' bosošagne'e na' bosošague' na' no xi'iṉ c̱he' cate' bžin ža gwyo'o Noén' ḻo' barcon'. Nach goc to yejwsio' juisyw. Na' gosebiayi' yogo' beṉe' ca' bi goso'o ḻo' barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ḻecz ca' goc ca tiemp c̱he da' Lot, beṉe' Sodoman' gose'ej gosagüe' gosote' bi da' de c̱hegaque', na' gosezi'e bi da' beseyažjde', na' gosaz gosa'aṉe', na' goson liže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Perw na' žan' beza' Loten' Sodoman', Diosen' bene' cont byiṉj yi' na' azufre yaba na' gosebiayi' yogo'ḻoḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Can' gac cate' yida' da' yoble, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h, na' yogo'ḻoḻ beṉe' yesele'ede' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Na' ža caten' yida' še chda to beṉe' do yic̱hjo'o c̱he liže', na' xšinḻaze' žen' ḻo' yo'o c̱he', bi yeyetje' cont yotoben', con yoxoṉje'. Na' ḻecze ca' beṉe' chda do yix̱e', bitw gacde' yeyej liže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ḻe šjayza'laže' can' goc c̱he no'ol c̱he Loten'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Note'tez beṉe' chacde' gone' cont cbi saca'zie' o cont nono yesot ḻe', bena' cuiayi'. Na' note'tez beṉe' chzanḻaže' cuine' saca'zie' o gate' ṉe c̱hia' neda', ba de yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Chnia' le'e, quinga gac caten' yida' da' yoble. C̱hope beṉe' zjadie' chesetase' toz cam. Toe' yeca'a Diosen' na' yetoe' yega'aṉ. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na' c̱hop no'ole nite' txen chesote', toe' yeca'a Diosen' na' yetoe' yega'aṉ. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Na' c̱hope beṉe' nite' do yix̱e', toe' yeca'a Diosen' na' ḻecze yega'aṉ yetoe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cate' gosende' diža' nga gose'e ḻe': ―¿Gan' gac da' qui, X̱anto'? Nach Jesúsen' gože' ḻegaque': ―Nga chonen c̱he ben' že': “Gan' de be guat nan' chesežag šod ca'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na' be'len Jesúsen' ḻegaque' to jempl bsed blo'ede' ḻegaque' cheyaḻa' ṉita'teze' yesonc̱hac̱hlaže' yosoḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Na' gože' ḻegaque': ―Gwche' to ciuda ga gwzoa to juez na' juezen' bi gwdape' Diosen' bala'aṉ na' ṉeca gwche'yic̱hje' še chesazlaže' beṉac̱hen' can' chonen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na' ciudan' gwzoa to no'ol güezeb, na' goxjze cheje' lao juezen' na' che'e ḻe': “Ben yeḻa' justis c̱hia' len beṉe' chgue'ede' neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ba goc sša bi chzenague' c̱he', perw gwdechle bene' xbab, gwne': “Bitw chapa' Diosen' bala'aṉ na' ṉeca chi'yic̱hja' še chesazlaže' beṉac̱hen' can' chonan'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Perw na' no'ol güezeb nga chone' neda' zed, na' ṉa'a gaclena'ne' cont bich yide' yostoe' yeḻa' chxenḻaže' c̱hia'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nach gož X̱anchon' ḻegaque': ―Ḻe goṉ xbab c̱he dan' gwna juezen' ben' bi zej to ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nacchxe gon Diosen' gwzenagche' c̱he beṉe' ca' ba gwleje' cont zjanaque' xi'iṉe', beṉe' ca' chosoḻ güiže' ḻe' do ža do yel. ¿Gwleze' sša cont yosle' ḻegaque' ḻo na' beṉe' ca' chesegue'ede' ḻegaque'? ");
INSERT INTO zpqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Chnia' le'e, Diosen' bedao'nez yosle' ḻegaque' ḻo na' beṉe' ca'. Perw cate' neda' yida' yežlio nga yeto, neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h, ¿ṉe' nita'ch beṉe' chesejnilaže' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gwnita' baḻ beṉe' gosacde' zjanaque' beṉe' güen lao Diosen' ṉec̱he da' chesone'. Beṉe' ca' chesacde' beṉe' ca' yezica'chle bibi zjazaque' len Diosen'. Na' Jesúsen' bi'e jempl nga da' bcuišen beṉe' ca', gwne': ");
INSERT INTO zpqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―C̱hope beṉe' ja'ac yodao' blao jaseḻ güiže' Diosen', toe' beṉe' fariseo na' yetoe' beṉe' güec̱hixjw. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Beṉe' fariseon' gwzeze' boḻ güiže' Diosen' na' con chonxen cuine', gwne': “Dios, neda' chona' yeḻa' chox̱clen c̱hio' bitw chona' cana' cheson yezica'chle beṉe'. Bitw chca'a bi da' de c̱he beṉe' yoble, na' bitw chona' bichle da' mal. Bitw chata'lena' no'ol bi nac no'ol c̱hia', na' ṉeca naca' beṉe' mal can' nac beṉe' güec̱hixjw ni. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","C̱hope ṉi'a to xman chona' gwbas, na' yogo'ḻoḻ da' chona' gan, chbecan' ši cuen na' chnežjua' to cuen c̱he yodao'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na' beṉe' güec̱hixjon' gwzeteze' zito'le, ṉeca cheyaxjde' ḻis lagüe' yabale. Nach chbaže' lc̱ho'e gwne': “Dios, beyaše'laže' neda' naca' beṉe' güen da' xiṉj.” Da'na'z da' gwna beṉe' güec̱hixjon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na' chnia' le'e, Diosen' bezi'xene' c̱he beṉe' güec̱hixjon' na' beyej liže' bibi xtoḻe' gota'. Perw bi goc ca' len beṉe' fariseon'. Ḻe note'tez beṉe' chonxen cuine', Diosa' gone' cont si'e zto', na' note'tez beṉe' chzex̱jwlaže' lagüen', Diosen' gone' cont gacxene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na' jasesane' bidao' lao Jesúsen' cont x̱oa ne'e yic̱hjgacbe'. Na' cate' beṉe' ca' zjanaque' ḻe' txen besele'ede' can' chesonen', gosediḻe' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Perw na' Jesúsen' goxe' beṉe' ca' cont yeside' len bidao' c̱hegaquen', na' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻe güe' latje yesid bidao' ca' lagua' nga, bi gwžoṉle, ḻe beṉe' ca' zjanac ca bidao' quinga, ḻegaque' chosozenague' c̱he Diosen' cont chnabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na' da' ḻi žia' le'e, note'teze beṉe' bi yosozenague' c̱he Diosen' ca cheson bidao' quinga cate' chosozenagbe' c̱he x̱axṉa'be', gwbat ṉabia' Diosen' yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","To beṉe' gwnabia' gože' Jesúsen': ―Maestrw, le' naco' beṉe' güen. ¿Bi cheyaḻa' gona' cont gata' yeḻa' mban c̱hia' toḻi tocaṉe? ");
INSERT INTO zpqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nach Jesúsen' gože'ne': ―¿Bixc̱hen' žo' naca' beṉe' güen? Toz beṉe' güen zoa, na' ḻen' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Le' ṉezdo' da' none' mandadw goncho: “Bi gata'lenḻe no'ol bi nac no'ol c̱hele o beṉe' byo beṉe' bi nac beṉe' c̱hele. Nono gotle. Bi cuanḻe. Bi güe'le diža' güenḻaže' c̱he beṉe' ḻježle. Ḻe gap bala'aṉ x̱axṉa'le.” ");
INSERT INTO zpqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na' gož ben' ḻe': ―Yogo'ḻoḻ da' quinga gwzolagua' chonczan' cate' ṉe' nactia' bidao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nach cate' bene Jesúsen' xtižen' na' gože'ne': ―Zoa to da' ṉe' chyažjen gono', jayete' yogo' da' de c̱hio', na' mechw dan' le'edo' c̱hen, bnežjon beṉe' yaše'. Yeyoža' šejnilažo' neda' na' yo'o gaco' neda' txen. Nach še gono' ca', cate' yežino' yaba gan' zoa Diosen' da' zaca'ch gata' c̱hio'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Perw na' bena' cate' beyož bende' diža' dan' gož Jesúsen' ḻe', gocyaše'chgüede', ḻe beṉe' gwṉi'achgua goque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na' Jesúsen' gwṉe'e beṉe' gwṉi'ana' na' gože'ne': ―Ḻeca zdebe naquen to beṉe' gwṉi'a gwzenague' c̱he Diosen' cont Diosen' ṉabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bedao'ch te to be xen be nzi' camello to ḻo' nag yeše' clel ca to beṉe' gwṉi'a gwzenague' c̱he Diosen' cont Diosen' ṉabi'e yic̱hjlažda'ogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na' beṉe' ca' bosozenague' xtiže'na' gose'ene': ―¿Noxen' šjayzoa len Diosen' še ca'? ");
INSERT INTO zpqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na' Jesúsen' gože' ḻegaque': ―Da' bi gac gon beṉac̱hen', bitw ṉacho bi gac gon Diosen' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nach Pedroa' gože' ḻe': ―Neto' ba gwlejyic̱hjto' yogo' da' de c̱heto' cont nacto' le' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na' gož Jesúsen' ḻegaque': ―Da' ḻi žia' le'e, note'teze beṉe' ba gwlejyic̱hje' liže', x̱axṉe'e, biše', xo'ole' o xi'iṉe' ṉec̱he chzenague' c̱he Diosen' cont Diosen' chnabi'e yic̱hjlažda'ogüe', ");
INSERT INTO zpqNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yežlio nga yonežjo Diosen' ḻe' da' nac da' zaca'ch, na' cate' yežine' yaban' gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na' gwlejiže Jesúsen' beṉe' šižiṉw ca' gwleje' cont zjanaque' txen len ḻe' na' gože' ḻegaque': ―Ṉa'a ba zejcho Jerusalénṉa' gan' gac yogo'ḻoḻ dan' nyoj c̱hia' dan' bosozoj da' beṉe' ca' gosoe' xtiža' Diosen' cani', neda' naca' bena' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gaca' ḻo na' beṉe' ca' bi zjanac beṉe' Israel, na' yesezi'diže' neda', na' yeseṉe' yeḻa' ya' c̱hia', nach yosoži'e xene' cho'alagua'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yesot yeseyine' neda' na' yesote' neda', perw yeyoṉ ža yebana' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Perw beṉe' ca' zjanaque' Jesúsen' txen bi gosejni'ide' dan' gože' ḻegaque', ḻe zjanc̱hoḻ yic̱hjlažda'ogüen', da'nan' bi gosejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nach cate' ba zoa yežin Jesúsen' Jericó, to beṉe' lc̱hoḻ chi'e chanezen' chṉabe' yosonežjo beṉe' ḻe' con gaca' da' chesezande'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na' bende' chesede beṉe' zan gan' chi'ena', na' gwṉabe' bin' chac. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na' gose'ene': ―Jesús beṉe' Nazaret chdie' laguo' nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na' bosya'adie' gwne': ―Jesús, xi'iṉ diaža c̱he da' rey David, beyaše'laže'šca neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nach beṉe' ca' zjažialao lao Jesúsen' gosediḻe' beṉe' lc̱hoḻen', gose'e ḻe' cheyaḻa' soe' šize, perw nachle bosya'adiache', gwne': ―Xi'iṉ diaža c̱he da' rey David, beyaše'laže'šca neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesúsen' gwleze', nach bene' mandadw šjasexi'e beṉe' lc̱hoḻen' lagüe'na'. Na' cate' gwbiga' beṉe' lc̱hoḻen' lao Jesúsen', nach gože'ne': ");
INSERT INTO zpqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Bi chaclažo' gonda' le'? Na' beṉe' lc̱hoḻen' gože'ne': ―X̱ana', benšca cont yele'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesúsen' gože'ne': ―Bele'e. Dan' chejnilažo' neda' bac̱h beyac yejlagon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na' ḻa' bele'ete beṉe' lc̱hoḻa' na' gwda'ogüe' Jesúsen' benxene' Diosen'. Na' ḻecze ca' yogo' beṉe' ca' besele'ede' can' goquen' gosonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nach Jesúsen' gwyo'e yež Jericó na' gwdeze' yešḻa'a ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na' zoa to beṉe' le' Zaqueo. Naque' beṉe' gwnabia' c̱he beṉe' güec̱hixjw ca', na' naque' beṉe' gwṉi'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Gwdiljwlaže' naclen' gone' le'ede' Jesúsen', perw bitw goc, ḻe gwnita' beṉe' zan len Jesúsen' na' Zaqueon' goque' to beṉe' bc̱hecw dao'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Da'nan' gwza'sese' gwdie' lao beṉe' ca' cont gwyepe' to ḻo yag da' zoa gaḻa'ze gan' te Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Perw na' cate' bžin Jesúsen' xan yaguen', gwṉe'e ḻo yaguen' na' gože'ne': ―Zaqueo, bedao'nez beyetj. Cheyaḻa' yega'aṉa' ližo' ṉa'aže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nach Zaqueon' beyetjsese' chebede'. Nach bec̱he'e Jesúsen' liže'na' na' benxene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Perw na' beṉe' ca' zjanžague' len Jesúsen' cate' besele'ede' can' goquen', yogüe' goseṉie' c̱he Jesúsen' gosene': ―Ba zeje' zjazoe' to liž beṉe' güen da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nach Zaqueon' gwzeche' na' gože' X̱anchon': ―X̱ana', gašje dan' de c̱hia' gwnežjuan' beṉe' yaše'. Na' dan' ba gwca'a c̱he beṉe', gwziya'a ḻegaque' cont goseyixjwche' da' zc̱ha'och ca dan' cheyaḻa' yeseyixjue', yonežjwgaca'ne' tap ca'te'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na' Jesúsen' gože'ne': ―Ṉa'aža ba beṉ Diosen' yeḻa' mban c̱hio' toḻi tocaṉe len c̱he beṉe' ḻo' yo'o c̱hio'. Na' da' ḻi ba naco' xi'iṉ diaža c̱he da' Abraham lagüe dan' ba chejnilažo' Diosen' can' ben da' x̱ozxta'ocho Abraham. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ca nac neda', gwseḻa' Diosen' neda' golja' beṉac̱h cont zedyediljua' note'tez beṉe' ba mbiayi', na' gwnežjua' ḻegaque' yeḻa' mban toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na' šlac ṉe' zjanžag beṉe' chosozenague' diža' dan' choe' Jesúsen', be'lene' ḻegaque' to jempl, ḻe ba nite' gaḻa'ze Jerusalénṉa' na' gosacde' ḻa' solaote ṉabi'e nación Israelen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nach gwne': ―To beṉe' blao gwyeje' to yež zito' jene' dan' cheyaḻa' gone' cont jax̱i' ḻo ne'e ṉabi'e yež c̱he', ḻe gosebeje'ne' ṉabi'e yež c̱hen' cate' yežine'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na' cate' za' se'e, gwleje' ši mos c̱he' na' bnežjue' to toe' mechw xen. Nach gože' ḻegaque': “Mechw nga gonele negosyw šlac bi zoa'”. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Perw beṉe' gualaž c̱hen' besegue'ede' ḻe', nach cate' beyož gwze'e, goseseḻe' beṉe' lao x̱ane'na' ben' gwnabia'che' lao yogüe', jaseže'ne': “Bitw chaclaže'to' ṉabia' benga neto'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Perw ḻa'czḻa' bi gosaclaže' beṉe' gualaž c̱hen', bia'cze gwxi' ḻo ne'e ṉabi'e. Nach cate' bežin lažen' da' yoble, bene' mandadw šja'ac xmose' beṉe' ši ca' lagüe'na', beṉe' ca' bocua'aṉlene' xmechuen'. Goclaže' ṉezde' gaca' gosone' gan len mechw dan' bocua'aṉlene' to toe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Beṉe' nechw bžine' lagüen' na' gože'ne': “X̱ana', xmecho' dan' bocua'aṉleno' neda' benen gan ši ca'te'le ca dan' bocua'aṉon'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nach x̱anen' gože'ne': “Ba beno' da' güen. Naco' mos güen. Beno' can' cheyaḻa' gono' len da' daon' bocua'aṉlena' le', da'nan' gona' cont ṉabi'o ši ciuda.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na' beṉe' gwchopen' bžine' lao x̱anen' na' gože'ne': “X̱ana', xmecho' dan' bocua'aṉleno' neda' benen gan gayo' ca'te'le ca dan' bocua'aṉon'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nach gože' ḻe': “Le' ṉabi'o gayo' ciuda.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nach bžin yetoe' lao x̱ane'na' na' gože'ne': “X̱ana', nga de xmecho' dan' bocua'aṉleno' neda'. Ba blažec̱hac̱han' bay nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bžeba' le' dan' naco' to beṉe' znia. Chono' gan da' bi beno' žin na' chelapo' dan' gosaz beṉe' yoble.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nach gož x̱anen' ḻe': “Dan' ba gwnao' ca' chlo'en napo' doḻa'. Naco' mos mal. Chacdo' naca' to beṉe' znia, na' ṉezdo' chona' gan da' bi bena' žin na' chelapa' dan' gosaz beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na' še ṉezdo' chona' ca', ¿bic̱hen' bi gwlejo' xmechuan' beṉe' yoble cont yezian' len yic̱hjen ṉa'a ba bela'a?” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nach gože' beṉe' ca' zjaze cuite'na': “Yeca'ale xmechuan' dan' bocua'aṉlena'ne' na' gwnežjwlen ben' ba nox̱e' ši ca'te' ca dan' bocua'aṉlena'ne'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nach gose'e ḻe': “X̱anto', ba nox̱e'cze' ši ca'te' ca dan' bocua'aṉleno'ne'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nach gož beṉe' gwnabian' ḻegaque': “Chnia' le'e, ben' chon güen len dan' chnežjua'ne', gwnežjua'ne' da' zc̱ha'och, perw na' bena' bi chgone' žin dan' chnežjua'ne', yeca'a da' daon' nox̱e'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na' ca nac beṉe' ca' chesegue'ede' neda', beṉe' ca' bi chesaclaže' ṉabia'gaca'ne', ḻe šjax̱i'e na' gotlene' lagua' nga.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na' cate' beyož be' Jesúsen' jempl nga nach gwze'e zeje' ciuda Jerusalén. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na' cate' ba zoa yesežine' yež ca' da' zjanzi' Betfagé na' Betania do gan' zoa ya'a da' nzi' Ya'a Olivos, na' gwseḻe' c̱hop beṉe' ca' mandadw ben' zjanaque' ḻe' txen, ");
INSERT INTO zpqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","gože' ḻegaque': ―Ḻe šja'ac yež dan' chi' gaḻa'ze, na' cate' žinḻen' na' yeželele to burr dao' da'ba' yag, be nono ṉa' cuia. Ḻe sežba' na' ḻe c̱he'ba' nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Še no ṉab bixc̱hen' chsežleba', na' ye'lne': “X̱anto' chyažjde'ba'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nach beṉe' ca' gwseḻa' Jesúsen' gosa'aque' na' besele'ede'ba' da'ba' gan' gož Jesúsen' ḻegaque' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nach šlac cheseseže'ba', x̱amba' ca' gose'e ḻegaque': ―¿Bixc̱hen' chsežle burr daon'? ");
INSERT INTO zpqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nach beṉe' ca' gwseḻa' Jesúsen' gose'e ḻegaque': ―X̱anton' chyažjde'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nach gosec̱he'eba' lao Jesúsen' na' gosex̱oa xagaque' cože'ban' nach bosožie' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na' šlac zeje' ngüe'e nez beṉe' ca' zjanžag gosonxene'ne', na' goseyix̱jw no xagaque' ḻo nez cont blej burron' ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nach ba zja'aque' gaḻa'ze Jerusalénṉa' na' besežine' gan' yesyeyetje' Ya'a Olivos. Na' beṉe' ca' zja'aclene' ḻe' gwzolao gosonxene' Diosen', zižje cheso'e diža' c̱he yogo'ḻoḻ yeḻa' guac da' ba besele'ede' da' ben Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nach gosene': ―¡Mbalaz rey c̱hechon' ben' ba za' nga gwseḻa' X̱ancho Diosen' ḻe' cont ṉabi'e! Cheyaḻa' gonxencho Diosen' txen len beṉe' ca' nita' gan' zoe'na', ḻe ba bene' cont beṉac̱hen' gac yesyenite' binḻo len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na' len beṉe' zan ca' zja'aclene' Jesúsen' zja'ac baḻ beṉe' fariseo. Nach to c̱hope' gose'e Jesúsen': ―Maestrw, ben mandadw len beṉe' ca' za'ac len le' txen cont yesenite' šize. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nach boži'i Jesúsen' xtiža'gaquen', gwne': ―Chnia' le'e, šaca' beṉe' quinga ṉite' šize, yej quinga yesosya'an yesonxenen neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cate' bžine' gaḻa'ze Jerusalénṉa', gwṉe'e ciudan', na' bene' xbab c̱he beṉe' ḻo' ciudan' na' gwchežyaše', ");
INSERT INTO zpqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na' gwne': ―Šaca' ḻa'c̱h ṉa'aža šejni'ile nac gonḻe cont soale binḻo len Diosen', perw ṉa'a ṉe' ngašen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gwžin ža cate' beṉe' ca' chesegue'ede' le'e yesone' to yež de yej da' šec̱hjen ciudan' cont nono gac yoxoṉj. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na' yesote' le'e len xi'iṉle ca'. Na' yosyoc̱hiṉje' ciudan' na' yesoslase' yej ca'. Ca' gac lagüe da' bi chejḻe'le Diosen' ba gwseḻe' neda' laole nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesúsen' gwyo'e chyo'o yodao' blaona' na' gwzolagüe' bešaše' beṉe' ca' chesote' na' beṉe' chesa'o na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na' gože' ḻegaque': ―Nyojcze Xtiža' Diosen' žan: “Ližan' naquen to latje gan' yesoḻ güiž beṉe' neda'”, perw le'e ba benḻen ca to latje ga že' beṉe' gwban. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na' bsed blo'ede' beṉe' ca' že' yodao' blaona' yogo' ža. Na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisésen' na' nochle beṉe' blao c̱he beṉe' Israel ca', goseyiljwlaže' nacle yesone' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Perw bi besyeželde' nacle yesone' ḻe' ṉec̱he yogo' beṉe' besyebechgüede' xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","To ža šlac chsed chlo'e Jesúsen' beṉe' ca' chyo'o yodao' blaona' na' chyix̱jue'ede' diža' güen c̱he Diosen', besežin bx̱oz gwnabia' ca' na' len beṉe' gol ca' chesenabi'e naciónṉa' na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Na' gose'e ḻe': ―Gwnašc neto' bi yeḻa' gwnabia' napo' chono' da' qui, na' no beṉ yeḻa' gwnabian' cont chonon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na' boži'e xtiža'gaquen', gwne': ―Ḻecze de to da' ṉabda' le'e. Ḻe našc neda' ");
INSERT INTO zpqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿non' gwseḻa' da' Juanṉa' bzoe' beṉe' nis? ¿Dios nan' gwseḻe'ne', še beṉac̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na' ḻegacze' gose' ḻježe': ―¿Bi ṉacho? Še ye'chone' Dios gwseḻa' ḻe', na' ye'e chio': “¿Bixc̱hen' ca gwyejḻe'le c̱he'?” ");
INSERT INTO zpqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na' bi gac ye'chone' beṉac̱h gwseḻa' ḻe', ḻe yogo'te beṉe' že' nga chesejḻe'e Diosen' gwseḻe' da' Juanṉa' be'e xtiže'na', na' yosožie' chio' yej še ye'chone' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na' gose'e Jesúsen': ―Bi ṉezeto' non' gwseḻa' da' Juan. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nach Jesúsen' gože' ḻegaque': ―Ḻecz ca' neda' bi yapa' le'e bi yeḻa' gwnabian' chonḻenda' da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na' be'e jempl nga bzejni'ide' beṉe' ca' chosozenag c̱he', gwne': ―To beṉe' goze' to cue' xen yag uvas na' bocua'aṉen' ḻo na' beṉe' ca' yesonen' žin na' gwze'e gwyeje' zito' na' jasoe' sša. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cate' bžin ža yosyotobe' cosešen', nach gwseḻa' to xmose' lao beṉe' ca' nac ḻo na'gaque' yag uvasen' cont yosyonežjue'ne' to tlacw coseš dan' yesyezi'en. Na' beṉe' ca' nac ḻo na'gaque' yag uvasen' goseyine' mosen' na' to ga'alze bosyose'ene' bibi goso'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nach x̱an yežlion' gwseḻe' yeto mosen', na' ḻecze gosot goseyine' ḻe' na' gosonde' ḻe' zgot, na' to ga'alze bosyose'ene' bibi goso'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na' x̱an yežlion' gwseḻa'che' mos gwyoṉe, na' ḻecze gosotlate'ne' gosone'ne' güe', na' besyebeje'ne' gan' že' yag uvas ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Na' x̱an yežlion' gwne': “¿Nacxe gona'?” Nach beyone' xbab gwne': “Seḻa' xi'iṉa' ben' chacchgüeda', ḻe šeca güesezi'e xtiža' ḻe'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Perw beṉe' ca' nac ḻo na'gaque' yag uvasen' cate' besele'ede' xi'iṉe'na', gose' ḻježe': “Benga yega'aṉlene' yežlio nga cate' gat x̱e'. Ḻe da gotchone' cont yega'aṉlenchon.” ");
INSERT INTO zpqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nach besyebeje' ḻe' gan' že' yag ca' na' gosote'ne'. Nach Jesúsen' gwṉabde' beṉe' ca' zjanžaguen': ―¿Nacxe gon x̱an yežlion' len beṉe' ca' bocua'aṉlene' yežlio c̱hen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Šeje' šjetue' ḻegaque' na' yodie' yežlion' ḻo na' beṉe' yoble. Na' beṉe' ca' že'na' cate' gosende' diža' quinga dan' be' Jesúsen' gosene': ―¡Catec da' mal juisyw dan' goc! ");
INSERT INTO zpqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na' Jesúsen' gwṉa'chgüe' ḻegaque' na' gwne': ―¿Bixe zejen da' nga nyojen ḻe'e Xtiža' Diosen'? žan: Yej dan' bi gosaclaže' güen yo'o ca' yosoc̱hine', ḻen ba naquen yej squin. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na' ca nac yejna', note'tez beṉe' lažo' ḻo yeja' na' cue'žošje', na' note'tez beṉe' chiže' yeja' cate' lažon' na' gwšošjen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na' beṉe' ca' chososed chosolo'e dan' bzoj da' Moisés na' bx̱oz gwnabia' ca' ḻa' besyeyiljwlaže'te nacle yesone' yesezene' Jesúsen', ḻe gosacbe'ede' Jesúsen' be'e jemplna' ṉec̱he dan' bi chesejnilaže' ḻe'. Perw bibi gosone', ḻe besežebe' bi yeson beṉe' ca' že'na' beṉe' chesejḻe'e c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Da'nan' goseseḻe' beṉe' yosogüia yeseṉe'e Jesúsen' cont yesebeje'ne' diža' da' yosode'ede' cont yesagüe' xya c̱he' lao gobernador ben' chnabia'. Gosacde' gone' xbab do laže'gaque' chosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nach gose'e ḻe': ―Maestrw, ṉezeto' diža' da' cho'o na' da' chsed chlo'edo' beṉe' zejen to ḻicha. Ṉezeto' toz can' chono' len note'tez beṉe'. Na' ṉezeto' diža' ḻi cho'o chsed chlo'edo' beṉe' can' chazlaže' Diosen' goncho. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na' da'nan' zedeṉabeto' le' ¿naquen binḻo no c̱hixjo da' cheyaḻa' c̱hixjwcho c̱he ben' nac ḻa'zelagüe beṉe' gwnabia' ben' chi' Roma, še bi? ");
INSERT INTO zpqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na' gocbe'e Jesúsen' gague do lažen' chese'ene' ca', san chesaclaže' yesagüe' xya c̱he xtižen'. Na' gože' ḻegaque': ―¿Bixc̱hen' chaclaže'le yoslažo'le neda' len xtižan'? ");
INSERT INTO zpqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ḻe gwlo'e neda' to mechw. ¿No lao dan' da' ḻe'e mechw nga? na' ¿no la' dan' nyoj ḻe'en ni? Nach gose'ene': ―C̱he César ben' nac ḻa'zelagüe beṉe' gwnabia' ben' chi' ciuda Roma. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nach gože' ḻegaque': ―Ḻe gwnežjo beṉe' gwnabian' da' nac c̱he beṉe' gwnabia', na' ḻe gwnežjo Dios dan' nac c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na' bi gosezaque'de' yososlažoe' ḻe' len xtižen' lao beṉe' ca' že'na'. Na' besyebande' can' boži'e xtiža'gaquen', na' bich bi gose'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na' ḻecze besežin baḻ beṉe' saduceo gan' zoa Jesúsen'. Beṉe' ca' chesene' beṉe' guaten' bi yesyebane'. Nach goseṉabde' ḻe', gose'ene': ");
INSERT INTO zpqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestrw, da' Moisésen' bzoje' can' cheyaḻa' goncho, gwne' še to beṉe' byo gate' na' chzeb no'ol c̱hen' perw na' nono bi güezeb chga'aṉ, na' beṉe' biše' ben' ba gota' cheyaḻa' yošagna'lene' no'ol güezeba' cont yeseṉita' xi'iṉ diaža c̱he da' bišen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na' gosenita' beṉe' gosac gaž biše'. Na' beṉe' nechua' bšagne'e, na' gote' nono xi'iṉe' gwnita'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na' beṉe' gwchopen' bošagna'lene' no'ol güezeba', na' ḻecze gote' nono xi'iṉe' gwnita'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na' beṉe' gwyoṉa' ḻecze bošagna'lene' no'olen', na' ḻecz ca' goc len ḻe'. Na' ca' goc gosedaš beṉe' gaža' bosošagna'lene' no'ola', na' ṉe toe' ca gosezoa xi'iṉe' len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Gwde gosat yogo'ḻoḻ beṉe' ca', nach got len no'ola'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na' cate' yesyebane' ladjo beṉe' guat ca', ¿nox beṉe' ca' soalene' no'ola' ca xo'ole'?, ḻe yogo' beṉe' gaža' bosošagna'lene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na' Jesúsen' boži'e xtiža'gaquen', gože' ḻegaque': ―Beṉe' ca' nita' ḻo yežlio nga chosošagne'e na' ḻecze chosošague' na' no xi'iṉgaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Perw na' beṉe' ca' chaque Diosen' zjazaque' cont yosbane' ḻegaque' ladjo beṉe' guat ca' cont šjasyenite' len ḻe' toḻi tocaṉe, caten' yesyežine' gan' zoa Diosen' bich yosošagne'e ṉeca yosonežjo xi'iṉe' no'ol yosošagne'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bich yesate', ḻe yesaque' ca angl ben' že' yaba, na' yesaque' xi'iṉ Dios lagüe dan' ba bosban Diosen' ḻegaque' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na' ḻecze da' Moisésen' bzoje' c̱he dan' chesyeban beṉe' guat ca'. Bzoje' can' gož Diosen' ḻe' caten' boḻ güiže'ne' to ḻo yag yeše' dao' da' chey. Na' gwne' X̱ancho Diosen' naque' Dios ben' chonxen Abraham, ben' chonxen Isaac, na' ben' chonxen Jacob. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na' beṉe' guat ca' bi chesonxene' Diosen', san beṉe' zjamban. Na' yogo' beṉe' ba gosejnilaže' Diosen', ṉe' zjambane' cont chesonxene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na' baḻ beṉe' chososed chosolo'ede' ley dan' bzoj da' Moisés gose'e Jesúsen': ―Maestrw, binḻo boži'o xtiža'gaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na' bich besyeyaxjde' bi yeseṉabde' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesúsen' gože' ḻegaque': ―¿Nacxec̱hen' chesena beṉe' Criston' ben' yedeṉabi'e naque' xi'iṉ diaža c̱he da' rey David? ");
INSERT INTO zpqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Cuin Daviden' bzoje' Xtiža' Diosen' ḻe'e libr da' nzi' Salmos, gwne': X̱ancho Dios gože' X̱anan': “Gwche'edo' cuita' nga ṉabia'cho txen, ");
INSERT INTO zpqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","na' gona' cont yogo' no chesegue'e le' yosozex̱jw yic̱hje' yosozengue' c̱hio'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Nacxe gac ṉacho Criston' naque' xi'iṉ diaža c̱he da' rey David? ḻe cuin Davin' gože' ḻe': “X̱ana'”. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Beṉe' zan zjanžag chosozenague' cate' gože' beṉe' ca' zjanaque' ḻe' txen: ");
INSERT INTO zpqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ḻe gwsaca' cont bi gonḻe can' cheson beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés. Ḻegaque' chesyebede' chesaše' zjanyaze' lache' toṉ. Na' chesyebede' chesonxen beṉe' ḻegaque' cate' chesyežague' lagüe ya'a. Chesyebede' chesebi'e gan' chesebe' beṉe' blao cate' chja'aque' yodao' na' cate' chac ḻṉi. ");
INSERT INTO zpqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na' chesyeque'e yo'o c̱he no'ole güezeb ca'. Na' cate' chosoḻ güiže' Dios, sša cheso'e diža' cont yesaque beṉe' ḻeca chesonxene' Diosen'. Beṉe' can' chesacche' castigw clel ca yezica'chle beṉe' güen da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Šlac zoa Jesúsen' chyo'o yodao', gwṉe'e na' ble'ede' beṉe' gwṉi'a ca' gosego'o xmechwgaquen' ḻo' cajen' gan' chesegüe'e mechw c̱he yodaon'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na' ḻecze ble'ede' to no'ol güezebe beṉe' yaše' gwlo'e c̱hop centav dao' c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nach Jesúsen' gwne': ―Da' ḻi žia' le'e, no'ol güezebe yaše' nga ba gwlo'oche' mechw da' zaca'ch clel ca yogo' beṉe' ca' yezica'chle. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ḻe yogo' ḻegaque' chesegüe'e da' checho'oṉen ḻo yeḻa' gwṉi'a c̱hegaquen', perw no'ol nga, ḻo yeḻa' yaše' yeḻa' zi' c̱he' gwlo'e yogo' da' de c̱he', yogo' da' chacbande'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na' baḻ beṉe' ca' chesejnilaže' c̱he dan' chsed chlo'e Jesúsen' goso'e diža' catec xdan nac yodao' blaona' dan' gosonen' de yej xdan da' zaque' na' yo'on bi da' bosonežjo beṉe'. Nach Jesúsen' gwne': ");
INSERT INTO zpqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ca nac da' quinga chle'ele ngan', žin ža cate' ṉe to yej dan' zjancua' nga ca yega'aṉ zjancua' cože' ḻježen. Yogon' yosyoc̱hiṉje'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na' goseṉabde' Jesúsen' gose'ene': ―Maestrw, ¿do bat gac dan' žo' nga? na' ¿nac gac ṉezeto' cate' ba zoa gac yogo' da' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na' gwne': ―Ḻe gwsaca' cont nono siye' le'e. Ḻe beṉe' zan yesaš yežlio nga beṉe' yesaclaže' yosoḻane' xḻatja' nga, yesene': “Nedan' Criston' ben' gwlej Diosen' cont ṉabi'a”, na': “Ba za' gac juisyw.” Perw le'e bitw gwzenagle xtiža'gaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na' cate' yenele chac gwdiḻe nile na'le o yenele chi' žaš contr beṉe' ca' chesenabia', bi žeble, ḻe zgua'tec da' quinga cheyaḻa' gac. Perw gague ḻenṉa' ṉacho ṉa'tec ṉa'a yeyož yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nach gože' ḻegaque': ―Na' yesediḻe to yež len yeto yež yoble na' to nación len yeto nación yoble, ");
INSERT INTO zpqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","na' zan cuen ga x̱o'chgua na' zan latje ḻo yežlion' ga gata' gwbin na' cue' yižgüe', na' yesac yeḻa' guac da' yesele'e beṉe' ḻe'e yaban' da' zaca' yesyebande', na' yesežebchgua beṉac̱hen' ṉec̱he dan' chac. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Perw za' gac yogo' da' quinga cate' yesezene' le'e na' yosoc̱hi yososaque' le'e na' yesone' le'e ḻo na' beṉe' gwnabia' c̱he yodao' c̱helen', na' yeseyix̱jue' le'e ḻižya. Na' yesec̱he'x̱ox̱je' le'e do lao rey na' do lao nochle beṉe' gwnabia' dan' chejnilaže'le neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na' cate' gac da' quinga güe'le xtiža'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na' ḻe gon xbab zoacza' chaclena' le'e, nach cate' gacle ḻo na' beṉe' ca' bi cuec yic̱hjle nacle yoži'ile xtiža'gaquen', ");
INSERT INTO zpqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ḻe neda' goṉa' le'e xbab len yeḻa' sina' c̱hian' cont yoži'ile xtiža'gaque' sin cbi bi gac yesene'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na' baḻle x̱axṉa'le na' beṉe' biše'le na' biše' ḻježle na' beṉe' migw c̱hele yesec̱hje' yesone' le'e ḻo na' beṉe' chesegue'e le'e. Na' yesote' baḻle. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na' yogo'ze beṉe' yesegue'ede' le'e dan' chejnilaže'le neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Perw chape Diosen' le'e na' bitw güe'e latje cuiayi'le, ");
INSERT INTO zpqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","na' goṉe' yeḻa' mban c̱hele toḻi tocaṉe še soale gwyo gwc̱hejle yogo'ḻoḻ dan' yesonde' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Na' cate' le'ele ba besela'ac soldadw zan cue'ej cuit Jerusalénṉa' ben' yesediḻlen le'e, canan' ṉezele ba zoa cuiayi' ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cana' beṉe' yesenita' Jerusalén cheyaḻa' yosoxoṉje'. Na' beṉe' že' yezica'chle yež ga mbane Judea cheyaḻa' šja'aque' do ya'adao'. Na' beṉe' yesenita' yix̱e', bi cheyaḻa' yesone' xbab yesyeyo'e ḻo' ciuda. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cana' gwnežjo Diosen' castigw c̱he xtoḻa' beṉe' ca' že' Judean', cont gac can' nyojen ḻe'e Xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Nyaše' zjanac no'ol ca' zjanoa' xi'iṉ na' no'ol ca' ṉe' chosoguaže' bidao' ḻo ža ca'! Ḻeca yesesaca'zi' beṉe' ca' že' doxen Judean', ḻe Diosen' ža'achgüe' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Soldadw ca' yesote' baḻe' ḻo gwdiḻe na' yebaḻe' yesec̱he'x̱ox̱je' nación ca' dan' zjachi' doxen yežlion'. Na' beṉe' ca' bi zjanaque' beṉe' Israel yosyoc̱hiṉje' yo'o ca' dan' že' Jerusalénṉa' na' yosolej yosošošjen'. Perw ba bžia' Diosen' bia' žin ža cate' beṉe' ca' bi zjanaque' beṉe' Israel bich yesenabi'e nación Israel. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ca nac gwbiž, bio' na' beljw ca', gac da' yebanecho len ḻegaquen. Na' beṉe' že' yežlion' yesaque' tole na' yesacžejlaže' catec sšag gon nisdaon' chas chata' gaquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na' beṉe' že' yežlio nga yesatte' šlat yesežebchgüe' dan' gaquen, ḻe yogo' da' chle'echo ḻe'e yaban' yesaquen ca chac yežlion' cate' chxo'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na' cana'ch beṉe' že' yežlion' yesele'ede' neda' naca' ben' gwseḻa' Dios golja beṉac̱h, za'a to ḻo' bejw len yeḻa' guac xen na' yeḻa' beṉe' zaca' juisyw c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na' cate' solao gac da' quinga, ḻe gonc̱hac̱h laže'le na' ḻe yebe. Ba zoa žin ža yida' da' yoble yebeja' le'e ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na' Jesúsen' be'lene' ḻegaque' to jempl, na' gože' ḻegaque': ―Ḻe ṉa'šc can' chon yag yix̱güigw na' bite'teze yag yoble, ");
INSERT INTO zpqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","cate' chle'ele ba chebian ḻaga' che'eṉ dao' nach ṉezele bac̱h zoa yela' tiemp ba. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ca'czen' cate' le'ele ba chac da' mal ca' ba gwnia', cana'ch ṉezele ba zoa gwlo'e Diosen' yeḻa' gwnabia' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Da' ḻi žia' le'e, biṉa' yenit diaža' c̱he le'e nita'le ṉa'a cate' yeyož gac yogo'ḻoḻ da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ḻe'e yaba na' yežlion' yesede c̱hen, perw ca nac xtižan', gague da' te cbi gac can' žanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Na' ḻe gon xbab cont bi gacle beṉe' lia na' beṉe' borrašw na' cont bi soale yelaḻ yežejele. Beṉe' ca' yesac beṉe' lia na' borrašw na' beṉe' ca' yesyelaḻ yesyežejde' bi yesebeze' batcan' gac yogo' da' quinga. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Na' toz can' gac c̱he beṉe' že' doxen yežlion', yesac yogo' da' quinga cate' nono chon xbab. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Perw yogo' ža ḻe soa ḻe cuez batcan' gac da' quinga na' ḻe yoḻ güiž Diosen' cont bibi gac c̱hele na' gac yedyesoale len neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yogo' ža gwzoa Jesúsen' bsed blo'ede' beṉe' yodao' blao, na' yogo' že' beyeje' ḻo ya'a da' nzi' Ya'a Olivos. ");
INSERT INTO zpqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na' yogo' zil besežin beṉe' zan bosozenague' c̱he' šlac bsed blo'ede' ḻegaque' chyo'o yodao' blao. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na' ba zoa gaḻa' ḻṉi pascw caten' chesagüe' yetextil da' bibi levadura yo'on. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisésen' beseyiljue' nacle yesone' na' bi da' yosode'ede' cont yesezene' Jesúsen' na' yesote'ne', ḻe besežebe' še cate' bi yesone yezica'chle beṉe' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nach Satanásen' dan' chnabia' da' x̱igüe' ca' gwyo'o gwyazen ḻo' yic̱hjlaždao' Judas Iscarioten' ben' goque' txen len beṉe' šižiṉw ca' zjanaque' Jesúsen' txen, ");
INSERT INTO zpqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","na' gwyeje' jaṉe'e bx̱oz gwnabia' ca' na' beṉe' gwnabia' c̱he beṉe' ca' chesape' yodao'na' cont bosoxi'e nacle gone' gwdie' Jesúsen' ḻo na'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na' ḻeca besyebede' na' gose'e ḻe' yosonežjue'ne' mechw. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na' Judasen' gwxenḻaže' len ḻegaque', na' gwzolagüe' gwdiljwlaže' nacle gone' gwdie' Jesúsen' ḻo na'gaquen' cate' bi že' beṉe' zan. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na' bžin ža gaḻa' ḻṉi caten' chesagüe' yetextil dan' bibi levadura yo'o. Naquen ža cate' chesote' xila' dao' cont šjasyeza'laže' can' bosla Diosen' da' x̱ozxta'ogaquen' ḻo na' beṉe' Egipto ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na' Jesúsen' gwleje' Pedroa' len Juanṉa' na' gože' ḻegaque': ―Ḻe šja'ac na' ḻe šjasiṉi'a dan' gagwcho ḻo ḻṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na' gose'ene': ―¿Ga che'ndo' šjasiṉi'ato'? ");
INSERT INTO zpqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nach gože' ḻegaque': ―Ḻe šja'ac na' cate' ba gwyo'ole ciudan' na' yežagle to beṉe' byo no'e to che'e nis. Na' šejlenḻne' na' gan' yežinen' ");
INSERT INTO zpqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ḻe ye' x̱an yo'on': “Maestron' že': Gonšco' to yo'o ga gagua' xše' že' ḻṉi nga len beṉe' ca' zjanaque' neda' txen.” ");
INSERT INTO zpqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nach gwlo'ede' le'e to cuart xen dan' zoa yic̱hjen na'ale gan' de yogo' da' chyažjecho. Na' ḻe gwsiṉi'a cont gagwcho na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na' gosa'aque' na' yogo' can' gož Jesúsen' ḻegaque' goc. Nach bososiṉi'e xše' že' ḻṉina'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na' cate' bac̱h gwchi'e cho'a mesen' len postlw c̱he' ca', ");
INSERT INTO zpqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","na' gože' ḻegaque': ―Ḻeca gwzelaža' gagua' yeḻa' guagw c̱he ḻṉi nga len le'e ṉa'a za' saca'zi'a na' gata'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chnia' le'e, ṉa'a zelao gaguan'. Cate'ch ba blo'e Diosen' yeḻa' gwnabia' c̱he'na', cana'ch gaguan' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na' gwxi'e vas gan' yože nis uvasen', na' beyož be'e yeḻa' chox̱clen c̱he Dios, nach gwne': ―Ḻe sin', na' ḻe ye'ej yogo'le late' güeje dan' yože ḻo' vas nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chnia' le'e ṉa'a zelao che'eja' vino c̱he uvasen'. Cate' ba blo'e Diosen' yeḻa' gwnabia' c̱he'na', cana'ch ye'ejan' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nach gwxi'e yetextilen' na' be'e yeḻa' chox̱clen c̱he Diosen' na' bzoxjen' na' bnežjuen' ḻegaque'. Na' gože' ḻegaque': ―Da' nga cuerp c̱hia' chzanḻaža' ṉec̱he le'e. Quinga gonḻe cont šjayze'ele bi zejen len le'e dan' yesote' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na' ḻecze bex̱ue' vasen' cate' ba beyož gosagüe' xšen' na' gože' ḻegaque': ―Dan' yože ḻo' vas nga zejen da' cobe dan' gwna Diosen' gone' gaclene' le'e. Na' solao gone' can' gwne', ḻe yesote' neda' na' gwlalj xc̱henan' ṉec̱he le'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Na' da' ḻi ben' gwdie' neda' ḻo na' beṉe' ca' chesegue'e neda' nga chagwlene' neda' txen. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na' gac c̱hia' can' nžia bia' gac, neda' naca' bena' gwseḻa' Diosen' golja' beṉac̱h, perw nyaše'chguaze nac ben' gwdie' neda' ḻo na' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nach gosezolagüe' goseṉabe ḻježgaque' noen' gon da' malen' nac ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na' ḻecze gosezolagüe' gosacyože' noe' nacch blao. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na' Jesúsen' gože' ḻegaque': ―Nita' beṉe' gwnabia' c̱he to to nación ca' na' chesone' byen chosozenag beṉe' c̱hegaque', na' beṉe' gwnabia' ca' chesaclaže' yesoe' beṉe' diža' c̱hegaque' zjanaque' beṉe' güenchgua. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Perw le'e gague can' cheyaḻa' gonḻe. Še no le'e nacchle beṉe' blao, cheyaḻa' gwzex̱jwlaže'le len beṉe' ḻježle na' gonḻe ca beṉe' xcuide' ben' bibi ṉa' ṉeze. Na' še no le'e chnabia'le, cheyaḻa' soale gaclen ḻježle. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ḻe gon xbab noe' nacch beṉe' blao, še bena' chi' cho'a mesen' o še xmosen' ben' chon mandadw c̱he'. Nacbia'cze ben' chi' cho'a mesen' naccze' beṉe' blaoch. Perw neda', zoa' cont gaclena' le'e ḻa'cze naca' X̱anḻe. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Le'e biṉa' cuejyic̱hjle neda' ḻa'czḻa' beṉe' zan ba chesegue'ede' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na' ca nac X̱an' ba none' c̱hia' cont ṉabi'a txen len ḻe', ḻecze neda' ba nona' c̱hele cont ṉabia'le txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na' gona' cont ye'ej gagwle txen len neda' cate' yela'le gan' ṉabi'a, na' cue'le cuita'na' ṉabia'le šižiṉw cuen beṉe' ca' zjanaque' xi'iṉ diaža c̱he da' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nach Jesúsen' gwne': ―Simón, ben xbab c̱hio', Satanásen' dan' chnabia' da' x̱igüe' ca' ba gwṉaben gaco' ḻo ne'en cont gonen cuejyic̱hjo' bich šejnilažo' neda'. Na' dan' gonen len le' naquen ca dan' chon beṉe' caten' chdie' trigon' ḻo' rner. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Perw na' neda' ba gwṉaba' gaclen Diosen' le' cont bi cuejyic̱hjo' dan' chejnilažo' neda'. Na' cate' ba betiṉjdo' xtoḻo'na', gono' c̱hac̱h laže' beṉe' ḻježo' quinga. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nach Pedroa' gože'ne': ―Ba bec̱hoglaža' sa'alena' le', gague ḻižya na'ze, san gatlencza' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na' Jesúsen' gože'ne': ―Pedro, žia' le', biṉa' cuež jean' ṉa'aže' cate' gac šoṉ ṉi'a bi chc̱hebo' še nombi'o neda'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na' gože' beṉe' ca' zjanaque' ḻe' txen: ―¿Byažjele bi da' byažjele cate' gwseḻa' le'e jatix̱jue'ele xtiža'na'? Gwseḻa' le'e sin cbi bia'le mechw, ṉe bzod, na' ṉeca bia'le xelle. Na' gose'ene': ―Bitw bi byažjeto'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na' gože' ḻegaque': ―Perw ṉa'a še naple mechw, cheyaḻa' gua'len, na' ḻecze ca' gua'le bzod. Na' še bitw bi spada c̱hele de, ḻe gote' xadoṉ c̱helen' cont si'le to spada. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chnia' le'e gonḻe ca', ḻe gac c̱hia' can' nyojczen ḻe'e Xtiža' Diosen' žan: “Gosone'ne' ca beṉe' güen da' xiṉj.” Na' cheyaḻa' gac yogo'ḻoḻ dan' nyojen. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nach gose'ene': ―X̱anto', gwṉa'šc nga noa'to' c̱hope spada. Na' gože' ḻegaque': ―Güesaqueczen. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nach gwze'e gwyeje' Ya'a Olivos can' ba yolagüe' chone', na' beṉe' ca' zjanaque' ḻe' txen zjana'ogüe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nach cate' besyežine' latjen' na' gože' ḻegaque': ―Ḻe yoḻ güiž Dios cont bi gon gwxiyen' le'e gan. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na' gwle'e len ḻegaque' zito' ca gan' zelao žin to yej da' gwzaḻa'cho, na' bzoa xibe' na' boḻ güiže' Dios, ");
INSERT INTO zpqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","gwne': ―X̱a', benšca cont bi saca'zi'a na' bi yesote'nda' še ca' chazlažo', perw bi chṉaba' gac da' žia' neda', san gac can' ṉao' le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na' to angl beṉe' za' yaba blo'elagüe' ḻe' na' be'e ḻe' fuerz valor. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na' šlac chžaglaochgüe' len yic̱hjlažda'ogüe'na' gwzolao chžaglaoche' choḻ güiže' Diosen' beyacḻoḻjte' yes. Na' nis yes c̱he'na' beyaquen ca tlaba' güeje chen dan' zjanaquen c̱heḻsoṉ, besyeyiṉjten ḻo yo. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na' bezeche', na' beyeje' gan' nita' beṉe' ca' zjanaque' ḻe' txen, ble'ede' zjanite' chesetase' dan' ḻeca gosacyaše'chgüede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na' gože' ḻegaque': ―¿Bixc̱hen' chtasle? Ḻe c̱has, ḻe yoḻ güiž Dios cont bi gon gwxiyen' le'e gan. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ṉe' choe'te Jesúsen' diža' cate' besežin beṉe' zan gaḻa'ze gan' zoen'. Na' ben' le' Judas, ben' goque' txen len beṉe' šižiṉw ca' gwlej Jesúsen' cont zjanaque' ḻe' txen, žialagüe' laogaque'. Na' gwbigue' gan' zoa Jesúsen' na' bnope' x̱ague', perw gague do lažen' bene' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Na' Jesúsen' gože' ḻe': ―Judas, ¿chnopo' neda' cont gwdio'nda' ḻo na' beṉe' quinga? neda' naca' bena' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na' cate' beṉe' ca' zjanaque' Jesúsen' txen besele'ede' can' gac c̱he'na' nach gose'ene': ―X̱anto', ¿gwyinto' beṉe' quinga spada c̱heton'? ");
INSERT INTO zpqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na' toe' gwdinen' mos c̱he bx̱oz blaon', gwc̱hogtechgüe' nague' ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Perw Jesúsen' gože'ne': ―Bich gonḻe ca'. Nach gwdane' nag mosen' na' beyone' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesúsen' gože' bx̱oz gwnabia' ca' na' beṉe' ca' chesenabi'e beṉe' ca' chesape' yodao', na' beṉe' gole blao ca' chesenabia' nación Israelen' ben' zja'ac zjasexi'e ḻe', gože'ne': ―¿Bixc̱hen' nonḻe neda' ca to beṉe' gwban za'acle zedex̱i'le neda' len spada na' len yag? ");
INSERT INTO zpqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yogo' žaze gwzoa' len le'e chyo'o yodao' blaon' na' bitw gwzenḻe neda'. Perw na' ba bžin ža gonele neda' con can' chaclaže'le, na' ba bžin ža gac can' chaclaže' Satanásen' dan' chnabia' beṉe' ca' chesaš ḻo c̱hoḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nach gosox̱e' Jesúsen' na' gosec̱he'ene' liž ben' naque' bx̱oz blao c̱he nación Israelen'. Nach Pedroa' na'ogüe' Jesúsen' zito' zito'le. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na' bosoxene' yi' chyo'o c̱he bx̱oz blaona' na' gosebi'e cho'a yi'na'. Na' gwche' Pedroa' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na' to no'ole güen žin ble'ede' chi'e cho'a yi'na' na' gwṉe'e ḻe' na' gwne': ―Ḻecze len benga naque' txen len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Perw Pedroa' bitw gwc̱hebe' še nombi'e Jesúsen'. Gože'ne': ―No'ole, bitw nombi'ane'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na' gocze šlož, yeto beṉe' ble'ede' Pedroa' gože'ne': ―Lenczo' naco' txen len beṉe' ca'. Na' Pedroa' gože'ne': ―Bitw lena' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Gwde to hor yetoe' gwne': ―Da' ḻicze nac benga txen len Jesúsen', ḻe naque' beṉe' Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na' Pedroa' gože'ne': ―Beṉe', bi ṉezda' bi dižan' cho'o. Na' ṉe' choe'te Pedroa' dižan' ca', gwchež to jea. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na' X̱ancho Jesúsen' gwyec̱hje' gwṉe'e Pedroa' na' jayze'e Pedroa' diža' dan' gož X̱anchon' ḻe' caten' gwne': “Biṉa' cuež jean' ṉa'aže' cate' gac šoṉe ṉi'a bi c̱hebo' še nombi'o neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na' Pedroa' beze'e ḻeca gwchežyaše'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na' beṉe' ca' gosec̱he'e Jesúsen' gosezi'diže' ḻe', na' gosot goseyine' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na' bosoc̱heje' to lache' lao Jesúsen' na' goseyine' ḻe' na' gose'ene': ―Gwṉeya'ašc non' chyin le'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na' zanch diža' da' gosene' gosezi'diže' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na' cate' gwyeni', beṉe' gole blao ca' chesenabia' nación Israelen' na' bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés besežague' na' gosone' mandadw gwyej Jesúsen' laogaque' gan' chesenabi'ena', nach gose'ene': ");
INSERT INTO zpqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Gwnašc neto' še le' naco' ben' gwlej Diosen' cont ṉabi'o nación c̱hechon'. Nach gože' ḻegaque': ―Šaca' ṉia' le'e neda' naca' Criston' ben' gwlej Diosen' cont ṉabia' nación c̱hechon', bitw šejḻe'le c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na' šaca' bi ṉabda' le'e, ṉeca yoži'ile xtižan', ṉeca gwsanḻenda. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. Na' ṉa'a cui'a cuit Diosen' ṉabi'a txen len ḻe', Dios ben' chnabia' doxen. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nach yogüe' yose'ene': ―¿Len' naco' dogualje Xi'iṉ Diosen'? Na' gože' ḻegaque': ―Ḻe can' žale nan' naca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na' gosene': ―¡Noch no chyažje no gagw xya c̱he'! Chio' ba benecho ṉa'a chṉe' c̱he Diosen' dan' že' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na' yogo'ḻoḻ beṉe' ca' gosezože'e na' gosec̱he'ene' lao Pilaton' ben' nac gobernador. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na' gwzolao bosocuiše' Jesúsen' gosene': ―Ba gwc̱hoglaoto' c̱he benga cheyaḻa' gate' dan' chde' chgo'oyeḻe' nación Israelen' cont yesejḻe'e c̱he' na' ḻecze chžone' c̱hixjwto' da' cheyaḻa' c̱hixjwto' lao rey César. Na' ḻecze že' ḻen' naque' Criston' ben' gwlej Diosen' cont ṉabi'e nación c̱heton'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nach Pilaton' gwṉabde'ne' gože'ne': ―¿Len' naco' rey c̱he beṉe' Israel? Nach Jesúsen' boži'e xtižen', gwne': ―Can' gwnao'na', can' naquen. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nach Pilaton' gože' bx̱oz ca' len yogo'ḻoḻ beṉe' ca' zjanžag lagüe'na': ―Bibi nḻa'lagüe' še bi doḻa' nap benga. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Perw na' goseṉeche', gosene': ―Chde' chgo'oyeḻe' yogo' beṉe' že' distritw Judea nga yesejḻe'e dan' chsed chlo'ede'. Gwzolaogüe' bsed blo'ede' distritw Galilean' perw lencze nga bac̱h chsed chlo'ede' ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cate' bene Pilaton' can gosene', nach gwṉabe' še Jesúsen' naque' beṉe' Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na' cate' gocbe'ede' Jesúsen' ze'e Galilean' gan' chnabia' gobernador Herodes, na' gwseḻe'ne' lao Herodes, ḻe ca hora' zoa Herodes Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Cate' Herodes ble'ede' ḻe' bebede', ḻe ba goc sša che'nde' le'ede' ḻe'. Ba bende' xtiža' Jesúsen' na' zoe' lez le'ede' gone' to da' zaca' yebande'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nach da' zan da' gwṉabde' Jesúsen', perw ṉe to xtižen' ca boži'i Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bx̱oz gwnabia' ca' na' beṉe' ca' chososed chosolo'e ley dan' bzoj da' Moisés gosezeche' gaḻa'ze na' bosocuiše'ne' len zan diža'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na' Herodes len zan soldadw c̱he' ca' gosezolaogüe' gosezi'diže'ne' na' gosonḻe' c̱he'. Nach cate' beyož bosoguacue'ne' to lache' xdan juisyw, goseseḻe'ne' da' yoble lao Pilaton'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na' žana' Pilaton' len Herodes gwzolao gosaque' migw, ḻa'czḻa' cate' za' gac ca' besegue'e ḻježe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nach Pilaton' botobe' bx̱oz gwnabia' ca' na' beṉe' ca' chesenabia' nación Israelen' len yezan beṉe' yež, gan' chesone' yeḻa' justisen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nach gože' ḻegaque': ―Le'e bedesanḻe benga lagua' nga, na' gwnale chde' chgo'oyeḻe' beṉe' Israelen' yesone' contr gobiernṉa'. Neda' bac̱h gwṉabyožda'ne' lao le'e ca xyan' dan' chagwle c̱he', ṉe to da' xiṉj ca chželda' še bi dan' none'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na' ḻecz ca' Herodes bitw bi xtoḻe' bželde', na' beseḻe' ḻe' laoto' nga. Na' nacbia' bibi ben benga da' cheyaḻa' gate'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na' ṉa'a con gona' mandadw yeseyine' ḻe' na' gwsana'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Gwne' ca', ḻe yogüiz chsane' to beṉe' pres ḻo ḻṉi pascw c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na' yogo' beṉe' ca' že' bososye'e toz ca gosene': ―Chojtega benga gate' na' gwsano' Barrabásen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na' Barrabásen' goseyix̱jue'ne' ḻižya da' bx̱ie' gwdiḻe ḻo' ciudan' na' goque' to beṉe' güet beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na' da' yoble Pilaton' gwṉabde' ḻegaque' še gwsane' Jesúsen', ");
INSERT INTO zpqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","perw bososye'e zižjech gosene': ―¡Bde'e ḻe'e yag cruz! ¡Bde'e ḻe'e yag cruz! ");
INSERT INTO zpqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Da' gwyoṉ ṉi'a gož Pilaton' ḻegaque': ―¿Bixe da' xiṉj nonen'? Ṉe to da' xiṉj bi chželda' še bi none' da' zaca' gate'. Na' gona' mandadw yeseyine' ḻe' na' gwsana'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Perw gosone' byen bososye'e yelate' zižjech goseṉabe' gwde'ene' ḻe'e yag cruz. Nach Pilaton' bzenague' c̱hegaquen' ");
INSERT INTO zpqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","na' gwc̱hoglagüe' c̱he' gac can' goseṉabde' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nach bsane' Barrabás ben' zjanyix̱jue' ḻižyan', ben' goseṉabe' gwsane', ḻa'czḻa' Barrabásna' goque' ben' bx̱ie' gwdiḻe na' beṉe' güet beṉe'. Na' Pilaton' bodie' Jesúsen' ḻo na'gaque' cont yesone' len ḻe' ca chesaclaže'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na' šlac zjanc̱he'ene' gan' yesote'ne' besyežague' to beṉe' yež Cirene le' Simón, za' zeze'e yix̱e'. Na' bosogüe'ene' yag cruz c̱he Jesúsen' na' gwyeje' gwda'ogüe' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na' beṉe' zan zjana'ogüe' ḻe' na' zjalen zan no'ole. Na' no'ol ca' gwzolao bososye'e gosebeže' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na' Jesúsen' gwyec̱hje' na' gože' ḻegaque': ―No'ole Jerusalén, bitw cuežle c̱hia'. Yejṉi'a ḻe cuež c̱hele na' c̱he xi'iṉle. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Da' ḻi gwžin ža cate' yesene': “Mbalaz nita' no'ole güiž no'ole cono gwxan na' nono bguaže'.” ");
INSERT INTO zpqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cana' yeseṉablaže' yesebix̱e ya'a ca' cont c̱henen ḻegaque'. Yeseṉablaže' c̱he' bdiṉj goten ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Še yesot beṉe' neda' len bibi xtoḻa' de, ¡nacchxe yesonde' le'e nacle beṉe' güen da' xiṉj! ");
INSERT INTO zpqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na' ḻecze gosec̱he'e c̱hop beṉe' güen da' xiṉj cont bosode'e ḻegaque' ḻe'e yag cruz can' gosone' len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na' cate' besežine' latje gan' nzi' Latje c̱he Žit Yic̱hj Beṉe' Guat, bosode'e Jesúsen' ḻe'e yag cruzen'. Na' ḻecze bosode'e beṉe' mal ca' c̱hop ḻe'e yag cruzen' len ḻe', toe' gwda' cuit Jesúsen' ḻicha, na' yetoe' gwda' cuiten' robes. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na' Jesúsen' gwne': ―X̱a', bezi'xen c̱he beṉe' quinga chesegue'ede' neda'. Gague zjaṉezde' bin' chesone'. Na' gosone' rifa cate' besyeḻe'e xaḻane' cont gota'bia' noe' yecheḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na' beṉe' zan besyežejde' ḻe'. Na' beṉe' gwnabia' c̱hegaque' ca' gosonḻe' c̱he', gosene': ―Yezica'chle beṉe' bosle'. Še da' ḻi naque' Criston' ben' gwlej Diosen' yedeṉabi'e, ¿bixc̱hen' bi chosla cuine'? ");
INSERT INTO zpqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nach soldadw ca' ḻecz ca' gosonḻe' c̱he'. Gosebigue' gaḻa'ze gan' zoa yag cruzen' na' bosonežjue'ne' vino zic̱hj. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nach gosene': ―Še len' naco' rey c̱he beṉe' Israel, bosla cuino'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na' yic̱hj yag cruz c̱he'na' gwzoa to dan' nyojen, žan: “Bengan' rey c̱he beṉe' Israel.” Na' byojen diža' griego, diža' latín na' diža' hebreo. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na' to beṉe' mal ben' da' ḻe'e yag cruz cuit Jesúsen' ḻecze gwzi'diže'ne', gože'ne': ―Še le' naco' ben' gwlej Diosen' cont yedeṉabi'o nación c̱hechon', bosla cuino' na' ḻecze bosla neto'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Na' ben' yeto gwdiḻe' beṉe' ḻježen' gože'ne': ―¿Bi chžebo' Diosen'? Chio' ba da'cho ḻe'e yag cruz cont gatcho can' da' ḻe', ");
INSERT INTO zpqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","na' dan' gat chio' naquen ḻicha cont si'cho castigw c̱he xtoḻa'chon'. Perw benga, bitw bi doḻa' nape'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nach gože' Jesúsen': ―Jesús, šjayza'laže'go' neda' cate' žin ža ṉabi'o. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na' gož Jesúsen' ḻe': ―Da' ḻi chnia' le', ṉa'aža soaczo' len neda' gan' zoa Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na' cate' bžin guagwbiž goc c̱hoḻ doxen ḻo yežlion' bžinte do cheda šoṉe. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bitw bseṉi' gwbižen'. Na' ca nac lache' dan' ze ḻo' yodao' blaona', bcheza' gachoḻen. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nach Jesúsen' bosye'e zižje gwne': ―X̱a', chon cuina' ḻo nao', bezi' spiritw c̱hia'na'. Na' beyož gwne' ca' gote'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na' cate' ble'e x̱an soldadon' can' goquen', benxene' Diosen' na' gwne': ―Da' ḻicze benga goque' beṉe' gwyej to ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na' beṉe' zan beṉe' besežag besele'ede' can' goc na' yogo'ḻoḻe' besyeya'aque' chesebaže' lc̱ho'e gosacde' da' juisyw ba goc. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na' yogo' beṉe' ca' zjanombia' Jesúsen', na' len no'ol ca' zjanao' ḻe' caten' beze'e Galilean', gosezeche' zito'le besele'ede' da' ca' goquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na' zoa to beṉe' ciuda Arimatea gan' mbane Judean' na' le' José. Naque' txen len beṉe' ca' chesenabia' nación Israel, na' naque' to beṉe' güen beṉe' zej to ḻicha. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ba zoe' chbeze' batcan' solao ṉabia' ben' seḻa' Diosen'. Bitw bene' txen len beṉe' ca' gosec̱hoglagüen' yesote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bena' gwyeje' lao Pilaton' jayṉabe' cuerp c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na' beḻetje'ne' ḻe'e yag cruzen' na' btobe' ḻe' to lache' xen na' ḻa' bcuaše'te' ḻe' to ḻo' bloj da' nc̱he'eṉe' ḻe'e yej. Na' naquen to ba cobe ga nono ṉa' yosocuaše'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na' yogo' da' ca' goc ža cate' chososiṉi'e c̱he ža c̱he Dios. Na' ba bžin hor cate' cheyaḻa' yosocueze' bite'teze žin o mandadw da' chesone'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na' no'ol ca' za'aclene' Jesúsen' cate' gwze'e distritw Galilean' ja'aclene' Josén' cont besele'ede' ba c̱he Jesúsen' gan' gwxoa cuerp c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nach gosa'aque' na' gosone' to da' chḻa' zix̱ da' yeseyebe' cuerp c̱he Jesúsen'. Na' ža c̱he Diosen' gosenita'cze can' ža ley c̱hegaquen', bibi žin gosone'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Baḻ dmigw ja'ac no'ol ca' da' yoble cho'a bloj gan' bosocuaše' Jesúsen' na' gosox̱e' da' ca' ba gosone' da' chḻa' zix̱, na' yebaḻ no'ole ja'aclene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na' cate' besežine' na' besele'ede' ba bga'a yejen' dan' bosode'e cho'a blojen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na' goso'e, na' bitw besyeželde' cuerp c̱he X̱ancho Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Šlac zjanite' chesyebande' c̱he da' quinga, besele'ede' c̱hope beṉe' zjazecha cuitgaquen' zjanyaze' lache' da' chactitchgua. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na' no'ol ca' besežebe' na' bosoc̱heque' yic̱hjgaquen' goseṉe'e ḻo yole. Nach beṉe' ca' gose'e no'ol ca': ―¿Bixc̱hen' cheyiljwle to beṉe' mban nga ladjo beṉe' guat? ");
INSERT INTO zpqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Notoch no nḻa' nga. Ba bebane' ladjo beṉe' guat na' mbancze'. Ḻe šjayza'laže' can' gwne' cate' ṉe' zoale Galilean'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Gwne' ḻe' naque' ben' gwseḻa' Diosen' golje' beṉac̱h. Na' gwne' cheyaḻa' gaque' ḻo na' beṉe' mal ca' cont yesote' ḻe' yosode'ene' ḻe'e yag cruz, na' yeyoṉ ža yebane' ladjo beṉe' guat. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na' no'ol ca' jasyeze'ede' xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na' besyeya'aque' cho'a blojen' na' jasedix̱jue'ede' yogo' da' ca' len postlw ca' šnej na' len yezica'chle beṉe' ca' nita' txen len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na' no'ol ca' jasedix̱jue'ede' postlw ca' zjanaque' beṉe' quinga: María beṉe' Magdala, na' Juana, na' María xṉa' Jacobo, na' len yebaḻe no'ole. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na' postlw ca' bitw gosejḻe'e c̱he no'ol ca', gosacde' chesenazen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Perw na' Pedroa' ḻa' gwzoža'te' na' ḻa' gwza'seste' bžine' cho'a blojen' na' bcheque' na' ble'ede' lache' ca' zjachin' ḻo yo. Na' beze'e bebanchgüede' c̱he da' ca' ble'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na' ḻecze ža dmigwna' c̱hop beṉe' ca' gosaque' Jesúsen' txen ja'aque' yež dan' nzi' Emaús, do šnej mil metr zito' par Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na' ḻegacze' bosošalje' c̱he yogo' da' ca' ba goquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ṉe' chesone' xbab na' ṉe' chesoe'te' diža' c̱hen cate' Jesúsen' gwbigue' len ḻegaque' na' gwza'lene' ḻegaque' txen, ");
INSERT INTO zpqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","perw bitw gosacbe'ede' noxen' zejlen ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nach gože' ḻegaque': ―¿Bi dižan' choe'le šlac ngo'ole nezen'? ¿Bixc̱hen' chacyaše'le? ");
INSERT INTO zpqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na' toe' le' Cleofas boži'e xtižen' gože'ne': ―¿Nacxe chaquen' gwza'o Jerusalén na' biṉa' gacbe'edo' da' ca' ba goc ḻo' ciudan'? ¡Tozo' le' zo' Jerusalén na' biṉa' gacbe'edo'! ");
INSERT INTO zpqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na' Jesúsen' gože' ḻegaque': ―¿Bi goquen' žale ca'? Nach gose'ene': ―Dan' goc c̱he Jesús beṉe' Nazaret. Goque' to beṉe' gwseḻa' Dios cont be'e xtižen', na' Diosen' len beṉac̱hen' besyebede' yeḻa' guac c̱hen' dan' blo'e na' diža' dan' be'e. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Perw na' bx̱oz gwnabia' c̱hecho ca' len beṉe' ca' chesenabia' nación c̱hechon' gosone' ḻe' ḻo na' beṉe' ca' gosec̱hoglagüe' c̱he' cheyaḻa' gate', na' bosode'e ḻe' ḻe'e yag cruz. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ba goc šoṉe ža ṉa'a goc da' quinga. Na' neto' gwzoato' lez Diosen' gwseḻe' ḻe' cont yebeje' nación c̱hecho ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na' no'ol ca' zjanac txen len neto', baḻe' goso'e diža' da' chebaneto', ja'aque' cho'a ban' be'e ");
INSERT INTO zpqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","na' bitw besyeželde' cuerp c̱he'na'. Cate' besyela'aque' gosene' besele'eda'ogüede' angl beṉe' gose'e ḻegaque' ba bebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na' ḻecze to c̱hop beṉe' byo beṉe' ca' zjanaque' txen len neto' ja'aque' cho'a ban' na' besele'ede' cayaṉen' gosena no'ol ca' naquen, perw bi besele'ede' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na' gož Jesúsen' ḻegaque': ―Nyaše'chguaze le'e bi chejni'ile na' bi chejḻe'le yogo' dan' bosozoj beṉe' ca' gwseḻa' Diosen' goso'e xtižen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Chaquele bi cheyaḻa' gac dan' ba goca'? Cristo ben' gwlej Diosen' cont yedeṉabi'e, benen byen gwzaca'zi'e yogo' da' quinga ba goc, perw yeyoža' la'laon naque' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na' be'e diža' len ḻegaque' bsed blo'ede' ḻegaque' yogo' dan' nyoj c̱he'na' ḻe'e Xtiža' Diosen', gwzolaoteque' len dan' bzoj da' Moisés na' len dan' bosozoj yezica'chle beṉe' gwseḻa' Diosen' goso'e xtižen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na' besežine' gaḻa'ze yežen' gan' zja'aquen', na' Jesúsen' bene' ca chon beṉe' šejch yelate' zito'ch. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Perw beṉe' ca' gosone' byen yega'aṉe' len ḻegaque', gose'ene': ―Yega'aṉczo' len neto', ḻe ba chaḻ na' ba nac bagwže' par šejo'. Na' gwyo'e cont yega'aṉlene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na' šlac zjachi'e cho'a mesen' txen, Jesúsen' gwxi'e yetextilen' na' be'e yeḻa' chox̱clen c̱he Diosen' na' bzoxjen' bnežjuen' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cana'ch gosacbe'ede' ḻe'na'. Na' šlac ṉe' nite' ca' con beṉite'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nach gose' ḻježgaque': ―Ḻeca bebe lažda'ochon' cate' be'lene' chio' diža' chanez na' bsed blo'ede' chio' can' nyojen c̱he' ḻe'e Xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na' ḻa' besyeya'actie' jaya'aque' Jerusalénṉa' na' besyežine' gan' zjandop zjanžag postlw ca' šnej len beṉe' ca' yezica'chle. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na' beṉe' šnej ca' gose'e beṉe' ca' za' besyežin: ―Da' ḻicze ba beban X̱anchon'. Ba blo'elagüe' Simónṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nach beṉe' ca' c̱hop gose'e ḻegaque' dan' goc šlac zjangüe'e nezen', na' gose'e ḻegaque' besyeyombi'e ḻe' cate' bzoxje' yetextilen' cont yesagüen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ṉe' chesoe'te' dižan' ca', cate'cze gwzecha Jesúsen' gachoḻ. Nach gože' ḻegaque': ―Ḻe soa binḻo len xbab dan' yo'o ḻo' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Perw ḻeca besežebe' na' besyebande', gosacde' še chesele'ede' bx̱in c̱he da' beṉe' guata'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nach Jesúsen' gože' ḻegaque': ―¿Bic̱hen' chacle tole? na' ¿bic̱hen' chonḻe xbab ca' ḻo' yic̱hjlažda'olen'? ");
INSERT INTO zpqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ḻe ṉa'šc ṉi'a na' nga cont gacbe'ele nedan'. Ḻe can neda' cont gacbe'ele. Šaca' naca' beṉe' guat, bi nac žit bela' c̱hia' ca dan' chle'ele nga. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Beyož gwne' ca', blo'ede' ḻegaque' ṉi'a ne'e ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na' ḻegaque' biṉa' yeyož yesejḻe'e catec chesyebande' na' catec chesyebede'. Nach Jesúsen' gože' ḻegaque': ―¿De late' da' gagua'? ");
INSERT INTO zpqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nach bosonežjue'ne' late' yid beḻ gagüe' na' late' c̱hixe beser da' yože šina'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gwxi'en na' gwdagüen' laogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nach gože' ḻegaque': ―Ba gwnia' le'e cate' ṉe' zoalena' le'e cheyaḻa' gac yogo'ḻoḻ da' ca' bsi' Diosen' xṉeze zjanyoj c̱hia' ḻe'e ley dan' bzoj da' Moisés, na' ḻe'e dan' bosozoj beṉe' ca' goso'e xtiža' Diosen' cani', na' ḻecz ca' da' nyoj ḻe'e Salmos ca'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nach ben Jesúsen' cont gosejni'ide' da' ca' zjanyoj c̱he' ḻe'e Xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na' gože' ḻegaque': ―Benen byen goc da' quinga cont goc can' nyojen žan neda' gata' na' yebana' ladjo beṉe' guat yeyoṉ ža, neda' naca' Cristo ben' gwlej Diosen' yedeṉabia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na' le'e cheyaḻa' güe'le xtiža'na' len beṉe' že' yogo' nación. Solaotecle güe'len Jerusalén. Güe'le xtižan' ṉale cheyaḻa' yesyetiṉje beṉac̱hen' xtoḻa'gaquen' cont Diosen' yezi'xene' c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Le'e cheyaḻa' güe'le diža' c̱he da' quinga ba ble'ele dan' ba goc c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na' ḻecze seḻa' Spiritw c̱he X̱a' Diosen' yedesoan len le'e can' gwnen'. Na' ḻe yega'aṉ ḻo ciuda nga ṉa'a cuezle goṉ X̱a' Diosen' le'e yeḻa' guac da' za' yaba. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na' Jesúsen' gwc̱he'e ḻegaque' ja'aque' gan' chi' yež dan' nzi' Betania na' gwḻis ne'e gwṉabde' Diosen' gone' cont ṉite' mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na' ca beyoža' beyepe' yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na' beṉe' ca' gosaque' ḻe' txen besyega'aṉe' yešlož dao' gosonxene' Jesúsen' nach jaya'aque' Jerusalénṉa', chesyebechgüede'. ");
INSERT INTO zpqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na' gwnita'teze' ḻo' yodao' blaona' chesonxene' Diosen'. Da' na'ze chzoja' ṉa'a.");
INSERT INTO zpqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cate' gwxe yežlion' ba zoacze ben' nzi' Xtiža' Dios. Zoe' len Diosen' na' ḻecze naque' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cate' gwxe yežlion' ba zoacze' len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ḻen' bene' yogo' beṉac̱h, yogo' angl, yogo' da' ca' beyac da' mal, yogo' beyix̱e' na' bite'teze da' dech. Bibi de da' gwxe da' bi ben ben' nzi' Xtiža' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ḻe' nse'e yeḻa' mban. Na' ben' ba zjanape' yeḻa' mban toḻi tocaṉe da' noṉe', ḻegaquen' ba yo'o be'ni' ḻo' yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ben' nzi' Xtiža' Dios bide' nse'e be'ni' c̱he yic̱hjlaždao' beṉac̱hen', na' ḻa'czḻa' beṉe' zan bi gosejnilaže'ne' na' bi gwyo'o be'ni' c̱hen' ḻo' yic̱hjlažda'ogaque', bi gosezaquede' yosocue'eje' be'ni' c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gwzoa to beṉe' le Juan, na' Diosen' gwseḻe'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juanṉa' ben' bzoe' beṉe' nis bedeye'e diža' c̱he ben' nsa' be'nin', cont yogo' beṉac̱h guac yesejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gague Juanṉan' nac beṉe' nsa' be'nin', san ḻe' bedeye'e xtiža' ben' nsa' be'ni' c̱he yic̱hjlaždao' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ba bžin ža be'ni' da' nac da' dogualje ba blan' yežlio nga, na' blan' cont gwseṉin' ḻo' yic̱hjlaždao' note'teze beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ben' nzi' Xtiža' Dios zoe' yežlion' cate' gwxeten. Na' ḻa'czḻa' ḻen' bene' yežlion' ben' že' yežlion' bi gosacbe'ede' non' naque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Golje' ladjo neto' beṉe' gualaž c̱he', perw zan neto' beṉe' gualaž c̱he' bi gwyejḻe'to' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","San baḻteze chio' gwyejḻe'cho c̱he', chio' gwyejnilaže'chone', bene' cont naccho xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na' gague lagüe goljcho nita' x̱axṉa'cho zjanaque' beṉe' bela' chen ba naccho xi'iṉ Dios. Na' gague lagüe to beṉe' byo gwzoalene' to no'ole ba naccho xi'iṉ Dios, na' gague lagüe beṉe' byon' goclaže' soa xi'iṉe' ba naccho xi'iṉ Dios, san da' chejnilaže'chone', da'nan' non Diosen' chio' xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristo ben' nzi' Xtiža' Diosen' golje' goque' beṉac̱h na' gwzoe' len neto'. Na' ble'eto' naque' beṉe' zaca' juisyw, ḻe togue' naque' dogualje Xi'iṉ Dios. Ḻeca nži'ilaže'de' chio' beṉac̱h na' bedezejni'ide' chio' diža' ḻi c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanṉa' ben' bzoe' beṉe' nis be'e diža' c̱he', gwne': ―C̱he bengan' bi'a diža' cate' gwnia': “Beṉe' za' za' zaca'che' ca neda', ḻe ba zoacze ḻe' cate' biṉa' soa' neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesucriston' nži'ilaže'chgüede' yogo' chio' chejnilaže'chone' na' zoacze' chaclenchgüe' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Da' Moisésen' bzejni'ide' da' x̱ozxta'o neto' beṉe' Israel ley c̱he Diosen' na' chlo'en yogo'cho napcho doḻa', na' Jesucriston' bedelo'ede' nži'ilaže' Diosen' chio' beṉac̱h na' bedezejni'ide' chio' diža' ḻi c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nono ṉa' soa beṉe' ba ble'ede' Diosen'. Toz ben' nac dogualje Xi'iṉ Dios beṉe' tliša' ba bzejni'ide' chio' beṉac̱h can' nac yic̱hjlaždao' Diosen', ḻe chacchgüe Diosen' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Beṉe' chesenabi'e nación Israel c̱heton' beṉe' že' Jerusalén gososeḻe' to c̱hope bx̱oz na' yebaḻe beṉe' gosalje ḻo diaža c̱he da' Leví cont goseṉabde' Juanṉa' non' naque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Na' Juanṉa' bi bedi'ide', be'e diža' ḻi gože' ḻegaque': ―Gague nedan' Cristo ben' chbezcho seḻa' Diosen' yedeṉabi'e nación c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nach gose'ene': ―¿Nox naco'? ¿Naco' da' Elías ben' be' xtiža' Diosen' cani'? Na' gože' ḻegaque': ―Bi naca' ḻe'. Nach goseṉabde' ḻe': ―¿Naco' ben' naquen yide' yedeye'lene' neto' xtiža' Diosen'? Na' boži'en gwne': ―Bi naca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nach da' yoble goseṉabde' ḻe': ―¿Non' naco'? cont ye'to' beṉe' ca' goseseḻe' neto'. ¿Bi ža togo' c̱he cuino'? ");
INSERT INTO zpqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nach Juanṉa' gože' ḻegaque': ―Neda' naca' ben' chṉe zižje to latje daš, žia': “Ḻe gwža' yic̱hjlažda'olen' cont gwzenagle c̱he X̱anchon' cate' yide'”, can' gwna da' Isaías ben' be' xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Beṉe' ca' ja'ac lao Juanṉa', beṉe' fariseo ca' goseseḻe' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nach gose'ene': ―¿Bixc̱hen' chzo' beṉe' nis še bi naco' Criston' ṉeca naco' Elíasen' na' ṉeca naco' ben' chbezcho yedeye'e xtiža' Diosen? ");
INSERT INTO zpqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nach Juanṉa' gože' ḻegaque': ―Neda' chzoa' beṉe' nis, na' gachoḻ le'e ba zoa to beṉe' biṉa' gombia'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ḻen' za' gwlo'elagüe' na' zaca'che' ca neda', na' da' nacchgüe' beṉe' zaca' bitw zaca' gona xmandadoe' ḻec̱hja' no xele'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yogo' da' quinga goquen gan' nzi' Betábara dan' chi' yešḻa'a yegw Jordán gan' chzoa Juanṉa' beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na' beteyo Juanṉa' ble'ede' zej Jesúsen' gan' zoen' na' gože' ben' chosozenag c̱he': ―Ḻe ṉa' ben' za' nga, Diosen' ba gwseḻe'ne' cont yeque'e xtoḻa' beṉac̱hen'. Bena' zaca'lebe' ca xila' dao' ben' chot chio' beṉe' Israel cont Diosen' chezi'xene' xtoḻa'chon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","C̱he ḻen' bi'a diža', gwnia': “Ben' za' za' zaca'che' ca neda', na' ḻe' ba zoacze' cate' biṉa' soa' neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neda' bi gocbe'eda' non' naque' perw Diosen' bzejni'ide' neda', na' da'nan' zedezoa' beṉe' nis cont yogo' chio' beṉe' Israel gacbe'echo non' naque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juanṉa' ḻecze gwṉe': ―Ble'eda' cate' betj Spiritw c̱he Diosen' yaban' bžinen gan' zoa Jesúsen'. Bžinen ca to ngolbex na' bega'aṉen len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neda' bi gocbe'eda' še Jesús nan' naque' ben' gwseḻa' Diosen', nach Dios ben' gwseḻe' neda' chzoa' beṉe' nis gože'nda': “Le'edo' yetj Spiritw c̱hia' na' yega'aṉen len beṉe' ba mbeja'. Ḻen' naque' beṉe' gon cont soa Spiritw c̱hian' ḻo' yic̱hjlaždao' beṉe' na' ṉabian' ḻegaque'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ba ble'eda' goc can' gwne' na' cho'a diža' ḻe bengan' Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Beteyo Juan ben' bzoa beṉe' nis zeche' da' yoble len yec̱hope beṉe' zjanaque' txen len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na' cate' ble'ede' gwde Jesúsen', nach gože' beṉe' ca': ―Ḻe ṉa' ben' gwseḻa' Diosen' ben' zaca'lebe' ca xila' dao' ben' chot chio' beṉe' Israel cont Diosen' chezi'xene' xtoḻa'chon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na' cate' beṉe' ca' c̱hope, ben' zjanaque' txen len Juanṉa', gosende' can' gwnen' nach ja'aclene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nach beyec̱hj Jesúsen' na' gwṉe'e ḻegaque' zjana'ogüe'ne', na' gože' ḻegaque': ―¿Bi chaclaže'le? Na' gose'ene': ―Maestrw, ¿gan' zo'? ");
INSERT INTO zpqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nach gože' ḻegaque': ―Ḻe šo'o na' le'ele. Nach ja'aclene'ne' na' besele'ede' gan' zoen', na' besyega'aṉlene' ḻe' žana', ḻe ba nac bagwže', ca do cheda tap. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na ca nac beṉe' ca' c̱hope' bosozenag xtiža' Juanṉa' na' gosa'ogüe' Jesúsen', toe' Andrés, beṉe' biše' Simón Pedro. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na' Andrésen' za' gone' bichle da' za' gone' na' jeḻ güiže' Simón bišen' na' gože' ḻe': ―Ba bežaglaoto' ben' chesene' Mesías, ben' ba gwlezcho yide' yedeṉabi'e nación Israel c̱hechon'. ―Na' Mesías zeje diža' Cristo. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nach Andrésen' gwc̱he'e beṉe' bišen' gan' zoa Jesúsen'. Na' cate' Jesúsen' ble'ede' Simónṉa' gože'ne': ―Len' Simón xi'iṉ Jonás. Perw yososi' beṉe' le' Cefas. (Na' Cefas zeje diža' Pedro.) ");
INSERT INTO zpqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Beteyo Jesúsen' gwc̱hoglagüen' yeyeje' Galilean' na' jaṉe'e Felipen' na' gože'ne': ―Yo'o len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipen' goque' beṉe' Betsaida gan' nac laž Andrésen' len Pedron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nach Felipen' jaṉe'e Natanaelen' na' gože'ne': ―Bac̱h ble'eto' ben' bzoj da' Moisésen' xtižen' ḻe'e da' ca' gan' bzoje' ley c̱hechon', na' ḻecze xtiže'na' bosozoj beṉe' ca' goso'e xtiža' Diosen' cani'. Ḻen' Jesús beṉe' Nazaret, ben' nac xi'iṉ José. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nach Natanaelen' gože'ne': ―¿Bat benecho yesene' Nazaret na' choj beṉe' zaca'? Nach gož Felipen' ḻe': ―Yo'o cont le'edo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na' Jesúsen' ble'ede' bac̱h zej Natanaelen' gan' zoe'na' nach gwne': ―Na' za' to beṉe' Israel gualaž c̱hechon' beṉe' naque' beṉe' güen. Ṉe late'ze bi naque' beṉe' gwxiye'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelen' bende' xtiža' Jesúsen' na' gože'ne': ―¿Nac chac nombi'o neda? Na' Jesúsen' gože'ne': ―Ble'eda' le' šlac zechao' xan yag yix̱güigw cate' za' ṉe Felipen' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nach Natanaelen' gwne': ―Maestrw, len' naco' dogualje Xi'iṉ Dios. Len' naco' ben' chbezto' seḻa' Diosen' yedeṉabi'o nación Israel c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na' Jesúsen' gože'ne': ―¿Da' gwnia' ble'eda' le' xan yag yix̱güigw nan' chejḻi'o c̱hia'? Da' zaca'ch ca da' quinga za' le'edo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Da' ḻi chnia', le'ele yaban' gan' zoa Diosen' gaquen ca to da' chyaljo na' beṉe' ca' zjanac angl c̱he' chep chetj yesaque' yežlio gan' zoa' nga, ḻe neda' naca' ben' gwseḻa' Dios golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Beyoṉ ža gota' to yeḻa' güešagna' yež da' nzi' Caná gan' mbane distritw Galilea. Na' xṉa' Jesúsen' gwyeje' liž ben' gan' gota' yeḻa' güešagna'na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na' ḻecze gosaxe' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen cont ja'aque' gan' chac yeḻa' güešagnan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na' bebiž vino dan' chese'ej beṉe' ca' že'na', na' xṉa' Jesúsen' gože' ḻe': ―Bich bi vino c̱hegaque' de. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na' gož Jesúsen' ḻe': ―¿Bixc̱hen' žo' ca'? ḻe biṉa' žin hor gwlo'a non' naca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na' xṉe'ena' gože' beṉe' ca' cheson mandadon': ―Ḻe gon bite'tez da' ṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na' nita' x̱op yeso' de yej ga chož nis da' chosoc̱hin beṉe' Israel gualaž c̱heto' ca' par chesa' cheseyib cuine' can' ža ley c̱heton'. Na' to to yej ca' chožen do x̱ono' che'e o do ši che'e nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nach Jesúsen' gože' beṉe' güen mandadw ca': ―Ḻe yosša' yeso' yej ca' nis. Na' gosegue'en nis goseža'ten. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nach gože' ḻegaque': ―Ḻe gaše' laten' ṉa'a na' ḻe šjanežjon ben' yo'o ḻo ne'e ḻṉin'. Na' gosone' can' gwnen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na' ben' yo'o ḻo ne'e ḻṉin' con bṉix̱en' bi ṉezde' gan' zan', con beṉe' ca' cheson mandadw na'ze goseṉezde' nisen' beyaquen vino, ḻe ḻegaquen' gosaše' nisen'. Na' bena' bṉix̱en' na' goxe' beṉe' byo ben' bšagnan', ");
INSERT INTO zpqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na' gože'ne': ―Yogo'ze beṉe' chon ḻṉi chdie' vino güen da' chzaca' la'ay cate' chzolao ḻṉin', na' cate' ba zjane'eje' da' zil nach cho'e ḻegaque' da' corrient. San le' bzago' vino šagüen' chdion' ṉa'a ba cheyož ḻṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Da' nga ben Jesúsen' yež Caná distritw Galilea goquen yeḻa' guac nechw da' bene' cont blo'e naque' beṉe' zaca'chgua, nach beṉe' ca' gwleje' cont gosaque' ḻe' txen gosejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Gwde na' Jesúsen' gwyeje' Capernaum len xṉe'e na' len beṉe' biše' ca', na' len beṉe' ca' zjanaque' ḻe' txen, na' besyega'aṉe' na' c̱hop šoṉe ža. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na' ba zoa gaḻa' ḻṉi c̱he neto' beṉe' Israel da' nzi' pascw, nach Jesúsen' gwyeje' Jerusalén len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Cate' bžine' chyo'o yodao' blaon' beṉe' zan že' chesote' go'ṉ na' xila' na' ngolbex, na' zjachi' beṉe' chosoše'e mechw. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesúsen' ble'ede' can' chaca' na' bene' to tašjw de do na' bc̱hinen' cont bebeje' yogo' beṉe' ca' že' chyo'o yodaon', len xila' ca', len go'ṉ ca', na' besḻase' xmechw beṉe' chosoša' mechon' na' gwlo'oṉi'ane'e xmesgaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na' gože' beṉe' ca' chesote' ngolbexen': ―Ḻe yebej yogo' be qui nga. Bi gonḻe ya'a liž X̱a' nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nach beṉe' ca' zjanaque' ḻe' txen jaseza'laže' can' nyoj Xtiža' Diosen' gan' žan: “Da' chi'chgua yic̱hja' c̱he ližon' chonten ga saca'zi'chgua'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na' ben' chesenabia' nación Israel c̱heton' gose'ene': ―¿Bi yeḻa' guac gono' da' le'eto' cont šejḻe'to' zaco' bebejo' beṉe' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesúsen' boži'e xtiža'gaquen' gwne': ―Ḻe yoc̱hiṉj yodao' nga na' šoṉe žaze yeyonan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nach beṉe' gwnabia' ca' gose'ene': ―X̱opeyon iz byažjen gosone' yodao' nga, ¿chacdo' guac yeyonon' šoṉe žaze? ");
INSERT INTO zpqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Perw Jesúsen' bsaca'lebde' cuerp c̱hen' yodao' cate' gwne' ca', na' ḻegaque' gosone' xbab c̱he yodao' na'zen' gwne' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na' cate' bžin ža beyas bebane' ladjo beṉe' guat ca', beṉe' ca' zjanaque' ḻe' txen jaseza'laže' can' gwnen' na' gosejḻe'e Xtiža' Diosen' dan' nyoj c̱he' na' ḻecze gosejḻe'e xtiža' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Šlac gwzoa Jesúsen' Jerusalénṉa' ḻo ḻṉi pascon' beṉe' zan besele'ede' yeḻa' guac ca' dan' benen' na' gosejḻe'e naque' beṉe' gwseḻa' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Perw Jesúsen' bi ben cuine' ḻo na'gaque', ḻe nombi'e yic̱hjlaždao' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bi byažjde' no ye' ḻe' xbab da' yo'o ḻo' yic̱hjlaždao' beṉe' ca'. Ḻe ṉezeczede' bin' yo'o ḻo' yic̱hjlaždao' to to chio' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na' gwzoa to beṉe' fariseo beṉe' le' Nicodemo. Goque' to beṉe' gwnabia' c̱he nación Israel c̱heton'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gwyeje' lao Jesúsen' šeže'le na' gože'ne': ―Maestrw, ṉezeto' Diosen' gwseḻe' le' cont chzejni'ido' neto', ḻe nono gac gon yeḻa' guac ca' dan' chonon' še bi zoa Diosen' len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na' gož Jesúsen' ḻe': ―Da' ḻi chnia' le', še non' bi galje yeto bi gac šjayzoe' gan' zoa Diosen' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nach gož Nicodemon' ḻe': ―¿Nac gon to beṉe' galje' še' ba naque' beṉe' gole? ¿Guaquech yeyo'e ḻo' ḻe'e xṉe'en' cont galje' yeto? ");
INSERT INTO zpqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Na' Jesúsen' gozne': ―Chnia' le'e to da' zejen, še non' bi galje' len nis na' len Spiritw c̱he Diosen', bi gac šjayzoe' gan' zoa Diosen' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Beṉe' zjanaque' bela' chen chesenita' xi'iṉgaque' ḻecze bi' bela' chen. Na' Spiritw c̱he Diosen' chnežjon yeḻa' mban toḻi tocaṉe c̱he beṉe' chesejnilaže' Diosen'. Da'nan' žacho chesalje' yeto. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bi yebando' dan' gwnia' chonen byen yogo' beṉe' galje' yeto. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cate' chec̱hj be' chec̱hjen gate'teze, na' chendo' choḻyoyen perw bi ṉezdo' ga zan' na' ṉeca ṉezdo' ga šejen. Ca'czen' naquen len yogo' beṉe' chon Spiritw c̱he Diosen' cont chesalje' da' yoble. Bi chle'echo da' chon Spiriton' perw nacbia' ba bocoben yic̱hjlažda'ogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nach Nicodemon' gože'ne': ―¿Nacxe gac can' žo' nga? ");
INSERT INTO zpqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na' gož Jesúsen' ḻe': ―Le' chsed chlo'edo' beṉe' Israel gualaž c̱hechon' xtiža' Diosen', ¿bi chejni'ido' da' quinga? ");
INSERT INTO zpqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Da' ḻi neto' chyix̱jue'eto' da' ṉezeto' na' choe'to' diža' c̱he da' ba ble'eto' na' bi chejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ba bia' diža' c̱he dan' chac yežlio nga na' bi chejḻe'ele. ¿Nac gac šejḻe'le še ṉia' le'e da' chac yaban'? ");
INSERT INTO zpqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Toze neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h za'a yaba na' noch no zoa no ba beyep yaba cont ṉezde' c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na' can' goc latje daš cani' cate' gwḻis da' Moisésen' beḻ de bronce bde'eba' to ḻe'e yag, can' cheyaḻa' gac yeseḻise' neda' to ḻe'e yag, neda' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Na' gac c̱hia' ca' cont note'teze beṉe' yesejnilaže' neda' bi cuiaye'e san gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Ḻeca chaque Diosen' chio' beṉac̱h, na' gwseḻa' Xi'iṉe' beṉe' tliša' cont note'tez beṉe' chejnilaže'ne' bi cuiaye'e, san gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na' Diosen' gwseḻe' Xi'iṉen' yežlio nga gague cont gwnežjue' castigw c̱he xtoḻa' beṉac̱hen', san cont gwnežjue' yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Note'tez beṉe' chesejnilaže' Xi'iṉ Diosen' beṉe' tlišan', bi yesezi'e castigw c̱he xtoḻa'gaquen', perw beṉe' bi chesejnilaže'ne' ba nchoglaon c̱hegaque' yesezaca'zi'e toḻi tocaṉe da' bi chesejnilaže' Xi'iṉ Dios beṉe' tlišan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na' can' naquen, beṉe' bi chesejnilaže' Xi'iṉ Diosen' ba nchoglaon c̱hegaque' yesezaca'zi'e toḻi tocaṉe. Nchoglaon yesezacazi'e, ḻe ba bid Xi'iṉ Diosen' nse'e be'ni' c̱he yic̱hjlaždao' beṉac̱hen' perw na' chesyebechde' dan' nac c̱hoḻ clel ca be'ni' c̱hen', dan' chesone' da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yogo' beṉe' cheson da' mal chesegue'ede' be'ni' c̱hen' na' bi chesazlaže' yosozenague' c̱he' cont bi gwlo'elaon še chesone' da' mal. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","San note'tez beṉe' cheson can' ža diža' ḻi c̱he Diosen', chesyebede' chosozenague' c̱he Criston', ḻe chlo'en zoacze Diosen' chaclene' ḻegaque' cont chesone' can' ža diža' ḻi c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gwde na' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen ja'aque' yež dao' ca' zjachi' gan' mbane distritw Judean'. Na' šlac gosenite' na' bosozoe' beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na' Juanṉa' ḻecze bzoe' beṉe' nis yež gan' nzi' Enón da' chi' gaḻa'ze Salim, ḻe na' dechgua nis. Na' ja'ac beṉe' gan' gwzoen' cont bzoe' ḻegaque' nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Caten' biṉa' yeseyix̱jue' Juanṉa' ḻižyan' goc ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nach gwche' to žaš len beṉe' ca' zjanaque' txen len Juanṉa' na' yeto c̱hope beṉe' Israel gualaž c̱heto' c̱he dan' chesezoa beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nach ja'aque' lao Juanṉa' na' gose'ene': ―Maestrw, ben' gwzoa len le' yešḻa'a yegw Jordánṉa', ben' cho'o xtižen', bac̱h chzoe' beṉe' nis na' yogo'ze beṉe' chja'aque' gan' zoe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nach Juanṉa' gože' ḻegaque': ―Nono gacxene' še bi gon Diosen' cont yesonxen beṉe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ṉezczele can' ba gwnian', bi naca' Cristo ben' chbezcho seḻa' Diosen' yedeṉabi'e chio', san naca' ben' gwseḻa' Diosen' cont bia' xtižen' žialaole. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cate' chac to yeḻa' güešagna', toz beṉe' byo ben' chšagnan' chzi'e no'olen'. Perw še zoa beṉe' migw c̱he' len ḻe' ža'na, chebede' cate' ben' chšagnan' že' zoe' mbalaz. Can' chac len neda', chbechgüeda' beṉe' zan chosozenague' c̱he Criston'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ḻen' cheyaḻa' šejch yesonxen beṉe' ḻe' na' neda' cheyaḻa' šejch yesanḻaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ca nac Cristo ben' za' gan' zoa Diosen', ḻe' naque' beṉe' zaca'ch ca yogo'ḻoḻ beṉe'. Yezica'chle beṉac̱h zjanaque' beṉe' c̱he yežlio ngaze na' c̱he yežlio ngaze cheso'e diža'. Perw na' Cristo ben' za' gan' zoa Diosen' zaca'che' ca yogo'ḻoḻ beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ḻe' cho'e diža' c̱he da' ca' ba ble'ede' na' diža' da' ba bende' gan' zoa Diosen', na' nono chzenag xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na' note'tez beṉe' chosozenag xtiža' ben' za' gan' zoa Diosen', nacbia' bena' ṉezde' Diosen' cho'e diža' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na' bena' gwseḻa' Diosen', bena' za' gan' zoe'na', ḻen' cho'e xtiža' Diosen', ḻe Spiritw c̱he Diosen' zoan len ḻe', na' cate' Diosen' choṉe' Spiritw c̱hen' bi chyisen' late' güeje. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Diosen' chacde' Xi'iṉe' Criston' na' ba bene' ḻo ne'e yogo'ḻoḻ da' de yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na' beṉe' ca' chesejnilaže' Xi'iṉ Diosen' de yeḻa' mban c̱hegaque' toḻi tocaṉe, san beṉe' cheson güedenag len Xi'iṉ Diosen', bi gata' yeḻa' mban c̱hegaque', ḻe Diosen' gone' cont yesezaca'zi'e toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Na' goquen' beṉe' zanch chosozenague' c̱he Jesúsen' ca beṉe' chosozenag c̱he Juanṉa', na' beṉe' zanch chesezoa nis len Jesúsen' ca beṉe' chesezoa nis len Juanṉa', ḻa'czḻa' gague cuin Jesúsen' bzoe' beṉe' nis, beṉe' ca' zjanaque' ḻe' txen gosonen'. Nach cate' Jesúsen' gwṉezde' beṉe' fariseo ca' gosacbe'ede' beṉe' zanch zjana'ogüe' ḻe', nach beze'e distritw Judean' na' beyeje' distritw Galilean' len beṉe' ca' zjanaque' ḻe' txen. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na' benen byen zjaya'aque' nez da' chde Samarian'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ca' goquen' besežine' to yež da' nzi' Sicar ḻo distritw Samarian'. Yežen' chega'aṉen gaḻa'ze gan' de yežlio dan' bnežjw da' Jacob da' xi'iṉe' José. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Na' žia to bej da' nacchgua sitjw da' nzi' Bej c̱he da' Jacob. Ca do guagwbiž Jesúsen' ba chjax̱aquede' ngüe'e nezen' nach gwchi'e cho'a bejen'. Na' beṉe' ca' zjanaque' ḻe' txen ba zja'aque' lagüe yežen' zjasexi'e da' yesagüe' len ḻe', cate' bžin to no'ole Samaria cho'a bejen' cont güe'e nis. Na' Jesúsen' gože'ne': ―Beṉ late' nis ye'eja'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na' no'ole Samarian' boži'en gože'ne': ―¿Nacxec̱hen' le' naco' beṉe' Israel chṉabdo' neda' nis ye'ejo'? ḻe no'ole Samaria neda'. (Na' ca nac beṉe' Israel gualaž c̱heto' ca', bi cheseṉe ḻježe' len beṉe' Samaria ca'.) ");
INSERT INTO zpqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nach Jesúsen' gože'ne': ―Neda' ba goša' le': “Beṉ late' nis ye'eja'”, na' šaca' ṉezdo' da' chaclaže' Diosen' goṉe' le' na' šaca' chacbe'edo' non' naca' neda', ba gwṉabdon' neda' na' ba beṉa' le' nis da' choṉ yeḻa' mban toḻi tocaṉe šaca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na' no'olen' gože'ne': ―Beṉe', bi nox̱o' bi gaše'don' na' bej nga naquen sitjw. ¿Gaxe si'o nis da' choṉ yeḻa' mbanṉa' žo' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Chacdo' zaca'cho' ca da' x̱ozxta'ocho Jacob ben' bocua'aṉ len neto' bej nga gan' güe'eje' len xi'iṉe' ca' na' len beyix̱e' c̱he' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Gož Jesúsen' ḻe': ―Note'tez beṉe' ye'ej nis c̱he bej nga bia'cze biḻde' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Na' note'tez beṉe' ye'ej nisen' gwnežjua'ne' neda', gwbatech biḻden' da' yoble, ḻe dan' gwnežjua'nen' gaquen ḻo' lažda'ogüe' ca to latje ga chaldi nis cont gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na' no'olen' gože'ne': ―Beṉe', beṉ neda' nisen' žo' ca' cont bich biḻdan' na' bich yida' dex̱ian' nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesúsen' gože'ne': ―Beyej jeḻ güiž beṉe' c̱hio' na' ḻe da nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nach gože' Jesúsen': ―Notno beṉe' c̱hia' zoa. Na' Jesúsen' gože' no'olen': ―Ledo' can' gwnaon' nono beṉe' c̱hio' zoa, ");
INSERT INTO zpqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ḻe gayo' beṉe' c̱hio' ba gwnita' na' beṉe' zoaleno' ṉa'a gague naque' beṉe' c̱hio'. Da' ḻi can' ba gwnaon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na' gož no'olen' ḻe': ―Beṉe', chacbe'eda' naco' to beṉe' chac chyix̱jue'ede' bi da' ža Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Da' x̱ozxta'o neto' beṉe' Samaria gosonxene' Diosen' ḻo ya'an zoa nga, na' le'e nacle beṉe' Israel žale Jerusalénṉa' cheyaḻa' gonxenchone'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesúsen' boži'en gože'ne': ―No'ole, gwyejḻe' c̱hia', gwžin ža cate' bi gonen byen gonxenḻe Diosen' ḻo ya'a nga ṉe Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Le'e nacle beṉe' Samaria bi nombia'yaṉe'le Dios ben' chonxenḻe. Neto' beṉe' Israel nombia'to' Dios ben' chonxento', na' ladjo' neto' beṉe' Israel choj ben' yebej beṉac̱hen' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Chžin ža na' ṉa'a ba goḻe', cate' beṉe' yesonxene' X̱acho Diosen' can' cheyaḻa'cze yesonxene' ḻe', gate'tez nite', ḻo' yic̱hjlažda'ogaquen' yesonxene' beṉe' naque' dogualje Dios, ḻe X̱acho Diosen' cheyiljue' beṉe' yesonxene' ḻe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosen' bi naque' beṉe' bela' chen, naque' spiritw. Da'nan' beṉe' yesonxen ḻe', ḻo' yic̱hjlažda'ogaque' cheyaḻa' yesonxene' beṉe' nac dogualje Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nach no'olen' gože'ne': ―Ṉezda' yid ben' ba gwlej Diosen' cont yedeṉabi'e chio', ben' nzi' Mesías o Cristo, na' cate' ḻe' yide' yedezejni'ide' chio' yogo' da' quinga. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nach Jesúsen' gože' no'olen': ―Neda' choe'lena' le' diža' naca' ben' žo' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ṉe' choe'lente Jesúsen' no'olen' dižan' cate' beṉe' ca' zjanaque' ḻe' txen besyežine' cho'a bejen'. Na' besyebande' choe'lene' to no'ole diža', perw ṉe toe' bi goseṉabde'ne' bi dižan' choe'lene' no'olen' o bixc̱hen' chšaḻjlene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nach no'olen' bocua'aṉ che'e nis c̱hen' na' beyeje' ḻo yežen' jayeže' beṉe' gualaž c̱he' ca': ");
INSERT INTO zpqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ḻe šo'o ḻe ṉa' to beṉe' ba gože' neda' yogo'te da' ba bena'. ¿Še bengan' Cristo ben' chbezcho yedeṉabi'e? ");
INSERT INTO zpqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na' besežaše' yežen' ja'aque' gan' chi' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na' šlac zjayda no'olen', beṉe' ca' zjanaque' Jesúsen' txen gosata'yoede' ḻe', chese'ene': ―Maestrw, gwdagw. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na' Jesúsen' gože' ḻegaque': ―Bi ṉezele de to yeḻa' guagw c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na' gose' ḻježe': ―¿Gague ba bedesesan beṉe' da' gwdagüe'? ");
INSERT INTO zpqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na' gož Jesúsen' ḻegaque': ―Len neda' naquen ca to yeḻa' guagw chona' can' chazlaže' Dios ben' gwseḻa' neda' cont gac yogo' da' chnalaže'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Le'e žale: “Ṉe' dech yetap bio' cont yedobe cosešen'.” Na' neda' chnia', ḻe ṉa' na' le'ele to coseš da' chyažje yedob ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","De da' goncho ṉa'a cont beṉe' yosozenague' c̱he Diosen' na' gata' yeḻa' mban c̱hegaque' toḻi tocaṉe. Na' beṉe' cheseyix̱jue'ede' xtiža' Diosen' na' lente beṉe' chesone' cont yosozenag beṉe' xtižen' txen yesenite' mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Diža' nga naquen da' ḻi, žan: “Beṉe' yoble chaz na' beṉe' yoble chelap.” ");
INSERT INTO zpqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Bac̱h chseḻa' le'e šjaylaple gan' bi gozle, ḻe le'e gonḻe cont yosozenag beṉe' xtiža' Diosen' dan' ba goseyix̱jue'e beṉe' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na' ca nac beṉe' yež Sicar ga mbane Samaria, zane' gosejnilaže' Jesúsen' da' gosende' gwna no'olen': “Ba gože' neda' yogo' da' ba bena'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nachen' besežin beṉe' Sicaren' gan' chi' Jesúsen' gosata'yoede' ḻe' yega'aṉlene' ḻegaque', na' bega'aṉe' c̱hope ža. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na' beṉe' zanch gosejnilaže' Jesúsen' cate' gosende' diža' da' be' cuine'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nach gose'e no'olen': ―Bac̱h chejḻe'to' ṉa'a, gague dan' bzenagto' xtižo' na'ze, san da' ba beneto' choe' cuine' dižan', na' ṉezeto' bengan' Cristo ben' gwlej Diosen' cont yebeje' beṉac̱hen' ḻo da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na' cate' goc c̱hop ža, Jesúsen' len beṉe' ca' zjanaque' ḻe' txen gosa'aque' jaya'aque' Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ḻe cuin Jesúsen' ba gwne' note'teze beṉe' cho'e xtiža' Diosen', bi chesonḻa'aṉcze beṉe' gualaž c̱hen' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na' cate' besežine' Galilean' beṉe' gualaž c̱hegaquen' bosolebe' Jesúsen' dan' ba besele'ede' yogo' da' güen da' bene' Jerusalénṉa' ḻo ḻṉin', ḻe lencze ḻegaque' ja'aque' ḻṉina'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na' gozej Jesúsen' yetṉi'a yež Caná dan' chi' distritw Galilea gan' bene' cont nisen' beyaquen vino. Na' yež Capernaum gwzoa to beṉe' gwnabia' beṉe' chon žin c̱he rey, na' chacšenchgüe xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","X̱a bi'na' cate' bende' ba bežin Jesúsen' Galilean' zeze'e Judean', nach gwyeje' lao Jesúsen' gwṉeyoede' ḻe' šeje' šjayene' xi'iṉen', ḻe ba zoa gatbe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Na' Jesúsen' gože'ne': ―Še bi chle'ele yeḻa' guac na' bichle da' zaca' yebanele, bi chejḻe'le c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nach ben' chon žin c̱he reyen' gota'yoede' ḻe' gwne': ―Beṉe', yo'ošca šlac biṉa' gat bi' c̱hian'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na' Jesúsen' gože'ne': ―Beyej ližo', bi gat bi' c̱hion'. Nach gwyejḻe' bena' dan' gož Jesúsen' ḻe' na' beze'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ba zoa yežine' cate' jasešag xmose' ca' ḻe' na' gose'ene': ―Ba beyac bi' c̱hion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Na' gwṉabde' ḻegaque' bi hor gwzolao beša'alaže'be', na' gose'e ḻe': ―Ṉeje cheda to gwde guagwbiž bechojbe' da' ḻan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na' x̱aben' gocbe'ede' ca hor na'czen' gož Jesúsen' ḻe' bi gat bi' c̱hen'. Nach gwyejnilaže' Jesúsen', ḻe' len yogo' beṉe' že' ližen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Da' nga goc yeḻa' guac gwchop da' ben Jesúsen' šlac beze'e Judean' na' bežine' Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na' gwde to tiemp bžin ža goc yeto ḻṉi c̱he neto' beṉe' Israel Jerusalénṉa', na' Jesúsen' gwyeje'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalénṉa' gaḻa'ze cho'a puert c̱he ze'e da' nyec̱hj ciudan' dan' nzi' Puert c̱he Xila' žia to ga chož nis da' nzi' Betesda, na' ze gayo' chalšil cue'ej cuite gan' chož nisen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na' beṉe' zan beṉe' güe' zjadie' chalšil ca', no beṉe' lc̱hoḻ, no beṉe' nxiṉj ṉi'e, no beṉe' natsi' late' güeje cuerp c̱hegaquen'. Zjadie' chesebeze' batcan' ta nisen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ḻe tgüeje betj to angl na' bte' nisen', na' beṉe' nechw beṉe' cho'e ḻo' nisen' cheyož chta anglen' ḻen, cheyacde' bite'tez yižgüe' che'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na' cate' bžin Jesúsen' na' de to beṉe' ba goc šino'šoṉechoa iz chacšende'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na' Jesúsen' ble'ede' ben' na' gocbe'ede' ba chac sša de' ca', na' gože'ne': ―¿Chaclažo' yeyaco'? ");
INSERT INTO zpqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na' beṉe' güen' gože' Jesúsen': ―Beṉe', nono zoa no co' neda' ḻo' nisen' cate' chdan. Na' šlac zya'a cont šo'a, beṉe' yoble chyobde' chetje' ḻo' nisen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nach gož Jesúsen' ḻe': ―Gwyas na' botobe xta'on na' gwda. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na' ḻa' beyacte bena' na' botob xte'en na' gwzolao chde'. Perw na' goquen to ža c̱he Dios cate' bi de ḻsens gon neto' beṉe' Israel žin. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nach beṉe' gwnabia' c̱he neto' beṉe' Israel gose'e bena' beyaquen': ―Ža c̱he Dios ṉa'a. Bi de ḻsens yeyoa' xta'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na' gož ben' ḻegaque': ―Bena' beyon neda' gože'nda': “Botobe xtaon' na' gwda.” ");
INSERT INTO zpqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nach gose'ene': ―¿Non' gož le': “Botobe xtaon' na' gwda”? ");
INSERT INTO zpqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na' ben' beyaquen' bi gwṉezde' non' beyon ḻe', ḻe Jesúsen' benite' ladjo beṉe' zan ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Gwdechle Jesúsen' bediḻe' bena' beyaquen' ḻo' yodao' blaon' na' gože' ḻe': ―Bac̱h beyaco' ṉa'a, na' cheyaḻa' cuejyic̱hjo' da' malen' bich gonon', cont bi gac c̱hio' to da' malech. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nach beza' bena' jatix̱jue'ede' beṉe' gwnabia' c̱he nación Israel c̱heton' gože' ḻegaque' Jesúsna' ben' beyon ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Da'nan' beṉe' gwnabia' ca' gwzolao gosebe'na'ogüe' Jesúsen' na' cheseyiljue' nacle yesone' yesote'ne' da' chone' yeḻa' guac ca' ža c̱he Dios cate' bi de ḻsens gon neto' beṉe' Israel žin. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Na' Jesúsen' gože' ḻegaque': ―X̱an' zoacze' chelaḻde' bate'teze na' ḻecze ca' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Da'nan' goseyiljwlaže'che' nacle yesone' yesote' Jesúsen', perw gague ṉec̱he bi chone' can' ža ley gan' chguaḻan' c̱he ža c̱he Dios na'zen', san ḻecze da' gwne' Diosen' naque' X̱e', ḻe zejen toz ca zaque' len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Na' gož Jesúsen' ḻegaque': ―Chnia' le'e to da' zejen, bibi chac gona' to gualaza'. Con da' chle'eda' chon X̱an', ḻenṉa' chona', na' bite'teze da' chon X̱an', ḻenṉa' chona', ḻe neda' naca' Xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chaque X̱an' neda' na' chlo'ede' neda' yogo' dan' chone'. Na' gwlo'ede' da' zaca'ch ca da' quinga da' gona' cont yebanele. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ca X̱a' Diosen' chosbane' beṉe' ladjo beṉe' guat ca', ca'cze chona' neda' naca' Xi'iṉe', chnežjua' yeḻa' mban c̱he note'tez beṉe' chbeja' cont gata' yeḻa' mban c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na' X̱an' bi chc̱hoglagüe' c̱he ṉe to beṉe' še nape' doḻa', san ba gwlo'e ḻo na' c̱hoglagua' c̱he yogo' beṉac̱h še non' nap doḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","X̱an' chaclaže' yogo' beṉe' yesonxene' neda' ḻecze can' chesonxene' ḻe'. Na' beṉe' bi chonxen neda', ṉe X̱a' Diosen' bi chonxene', ḻe ḻe'na' gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Chnia' le'e to da' zejen, beṉe' chosozenag xtižan' na' chesejnilaže' Dios ben' gwseḻa' neda', de yeḻa' mban c̱hegaque' toḻi tocaṉe. Na' bi yesezaca'zi'e toḻi tocaṉe da' bi chesejnilaže'ne'. Bich zjanaque' ca beṉe' guat len yic̱hjlažda'ogaquen' da' bi chosozenague' c̱he Diosen', san ba bocobe' yic̱hjlažda'ogaquen' ṉec̱he ba chesejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chnia' le'e to da' zejen, gwžin ža cate' beṉe' zjanac ca beṉe' guat len yic̱hjlažda'ogaque' yesende' xtiža' neda' naca' Xi'iṉ Dios, na' beṉe' yosozenag c̱hia' gata' yeḻa' mban c̱hegaque' toḻi tocaṉe, na' bac̱h chzolao chac ca' ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","X̱a' Diosen' zoacze' toḻi tocaṉe na' chone' cont zjamban beṉac̱hen', na' ḻecze ba bene' cont neda' naca' Xi'iṉe' zoa' toḻi tocaṉe na' chona' cont zjamban beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na' ḻecze ba beṉe' neda' yeḻa' chnabia' cont ṉia' non' nap doḻa', ḻe ba gwseḻe' neda' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bi yebanele dan' chnia' nga, ḻe gwžin ža cate' yogo'ḻoḻ beṉe' guat že' ḻo' ba yesende' cate' yoḻ güiža'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na' beṉe' ca' goson da' güen šlac gosebane' yesyechoje' na' yesebane' toḻi tocaṉe. Na' beṉe' ca' goson da' mal šlac gosebane' yesyechoje' na' yesezaca'zi'e toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Bibi gac gona' to gualaza'. Chzenaga' bin' ža X̱an' cont ṉia' c̱he beṉac̱hen' noe' nap doḻa'. Na' dan' ṉia' gac c̱he to to beṉe' naquen da' cheyaḻa' gac, ḻe bi chi'yic̱hja' gac dan' chnalaža'; san chi'yic̱hja' gac can' chnalaže' X̱an' ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Šaca' toz neda' chgua'a da' baḻi non' naca', bi naquen to da' šejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Perw zoa X̱an' cho'e diža' ḻi non' naca', na' ṉezda' diža' da' cho'e c̱hia' naquen da' šejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bac̱h gwseḻa'le beṉe' lao Juanṉa' cont jaseṉabde' ḻe' nac nac c̱hia', na' Juanṉa' be'e diža' ḻi non' naca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Perw neda' bi chyažjda' diža' da' güe' ṉe to beṉac̱h c̱hia'. San chnia' da' quinga cont le'e šejḻe'le c̱hia' na' gata' yeḻa' mban c̱hele toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanṉa' goque' ca to yi' da' chseṉi'chgua dan' bzejni'ide' le'e c̱he Diosen', na' šlož daon' bebele dan' bsed blo'eden'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Na' de to da' choe' xtiža' da' zaca'ch ca diža' da' choe' Juanṉa' c̱hia': chona' yogoḻoḻ da' ba gwlo'o X̱an' ḻo na' gona', na' da' ca' chonan' choen' diža' ḻe X̱an' gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nach X̱an' ben' gwseḻa' neda' ḻecze cho'e xtižan', ḻa'czḻa' biṉa' yenele can' chnen' na' biṉa' le'ele can' naquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Xtižen' biṉa' šon' ḻo' yic̱hjlažda'olen', ḻe bi chejnilaže'le neda' naca' ben' gwseḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Chsedyaṉe'le gan' nyoj Xtiža' Diosen', ḻe chaquele gaple yeḻa' mban toḻi tocaṉe ṉec̱he chsedlen. Na' da' ca' chsedlen' zjanyojen chesoen' xtiža'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Perw bi chaclaže'le šejnilaže'le neda' cont gata' yeḻa' mban c̱hele toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Na' neda' bi chyažjda' yesena beṉac̱hen' naca' beṉe' zaca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nombi'a le'e na' ṉezda' bi chaquele Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","X̱an' ba gwseḻe' neda' chona' con da' že', perw bi chejḻe'le c̱hia'. Na' cate' za'ac beṉe' cheson con bi da' ža xbab c̱hegacze', nachle chejḻe'le c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nacxe gac šejḻe'le c̱hia'? ḻe chzelaže'le yesena beṉe' chonḻe güen, na' bi chzelaže'le gonḻe cont toz Diosen' ṉe' chonḻe güen. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bi gonḻe xbab neda' gwcuiša' le'e lao X̱an'. Da' Moisésen' chcuiše' le'e lagüen', ḻe chsedchguale dan' bzojen' chaquele cont soale binḻo len Diosen', perw bi chejḻe'le xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Šaca' chejḻe'le xtiža' da' Moisésen', c̱hia' neda'czen' chejḻe'le še ca', ḻe xtiža' nedan' bzoje'. ");
INSERT INTO zpqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na' da' bi chejḻe'le dan' bzoj da' Moisésen', ¿nacxe gonḻe šejḻe'le bi dan' žia' le'e? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gozde goc ca' Jesúsen' gwyeje' yešḻa'a nisdao' c̱he Galilea len beṉe' ca' zjanaque' ḻe' txen. Na' nisdao' na' ḻecze nzin' Nisdao' Tiberias. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na' beṉe' zan zjanao' Jesúsen' da' ba besele'ede' yeḻa' guac dan' chonen' cheyone' beṉe' güe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Na' gwloe Jesúsen' to ḻo ya'a len beṉe' ca' zjanaque' ḻe' txen na' gosebi'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na' da' yoble ba zoa gaḻa' ḻṉi c̱he neto' beṉe' Israel da' nzi' pascw. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na' cate' gwṉa' Jesúsen' ble'ede' beṉe' zan ba zjanao' ḻe' na' gože' Felipen': ―¿Gaxe si'cho da' yesagw yogo' beṉe' quinga? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Gwne' ca' yešque bi ṉa Felipen', ḻe Jesúsen' ṉezeczede' naquen' gone'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na' Felipen' gože'ne': ―C̱hop gayoa denario yetextilen' bi gaquen yesyecheḻe to toe' ṉe late' güejen. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na' yeto ben' naque' Jesúsen' txen le Andrés na' naque' beṉe' biše' Simón Pedro. Na' Andrésen' gože' Jesúsen': ");
INSERT INTO zpqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nga zoa to bi' byo dao' na' de gayo' yetextil de cebada c̱hebe' na' yec̱hope beḻ ya'a. Perw ¿bi de gon da' quinga? ḻe beṉe' zanṉa' že' nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nach Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻe ye' yogo'ḻoḻe' yesebi'e. Dechgua yixye latjen', na' gosebe' beṉe' ca' ḻo yixyena', ca do gayo' mil beṉe' byo, bi cuent no'ole len bidao'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nach gwxi' Jesúsen' yetextil ca', na' beyož be'e yeḻa' chox̱clen c̱he Diosen' bnežjuen' beṉe' ca' zjanaque' ḻe' txen cont goseyisen' len beṉe' ca' zjachi' na'. Na' ḻecz ca' bene' len beḻ ya'a ca'. Na' goso'e to toe' con ca'te'te' gosaclaže' gosagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na' beyož gosagüe' ca'te'te' goseljde', Jesúsen' gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻe yotobe da' ca' bega'aṉ late' güeje cont bibi cuiayi'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nach bosyotobe' da' bixjw ca' dan' besyega'aṉ lao gayo' yetextil ca' de cebad, na' goquen šižiṉw žome. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cate' beṉe' ca' besele'ede' yeḻa' guac dan' benen' nach gosene': ―Da' ḻi bengan' choe' xtiža' Dios na' naque' ben' ba gwlezcho seḻa' Diosen' yežḻio nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na' cate' Jesúsen' gocbe'ede' ba zoa yesec̱he'ex̱ox̱je' ḻe' cont yesone' ḻe' rey c̱hegaque', nach gozze'e gozeje' ya'adaon' toze'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cate' ba gwx̱in, beṉe' ca' zjanaque' Jesúsen' txen jaya'aque' cho'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na' besyeyo'e to ḻo' barcw zjaya'aque' ciuda Capernaum. Ba goḻ na' Jesúsen' biṉa' yežine'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na' chas chata' chac nisdaon' ḻe chec̱hjchgua be'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ba goc sša zjaya'aque' len barcon' ḻo nisdaon' cate' besele'ede' ba zjayda Jesúsen' cheze'e ḻo nisen' gaḻa'ze gan' zej barcon'. Na' besežebe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Na' gože' ḻegaque': ―Nedan', bi žeble. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nach chesyebede' besyegüe'ene' ḻo' barcon'. Na' ḻa' besyežintie' ga nac yo biž cho'a nisdaon' gan' zjaya'aquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na' beteyo beṉe' zan beṉe' ca' besyega'aṉ yešḻa'a cho'a nisdaon' gosacbe'ede' nono Jesúsen' nḻa' na' gosacbe'ede' bibi barcw yoble gota'ch san toga dan' besyeyo'o beṉe' ca' zjanaque' Jesúsen' txen, na' zjaṉezde' Jesúsen' bi beyo'e len ḻegaque' ḻo' barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nach besežin barcw da' za'ac ciuda Tiberias gaḻa'ze gan' gosagüe' yetextilen' caten' beyož be' X̱ancho Jesúsen' yeḻa' chox̱clen c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na' cate' gota'bia' nono Jesúsen' bežel gan' nite'na' nach besyeyo'e ḻo' barcw ca' ja'aque' Capernaum cont besyeyiljue' Jesúsen' do na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na' cate' beṉe' zan ca' besyeželde' Jesúsen' yešḻa'ale nisdaon' nach gose'e ḻe': ―Maestrw, ¿batca' bla'o nga? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na' Jesúsen' gože' ḻegaque': ―Chnia' le'e to da' zejen, cheyiljwle neda' ṉec̱he dan' gwdagwle ca beljele na'zen', gague ṉec̱he chejḻe'le c̱hia' lagüe ba ble'ele yeḻa' guac ca' ba benan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bi cheyaḻa' cuecyic̱hjle gata' da' ye'ej gagwle da' chbiayi', san cuecyic̱hjle gata' da' goṉ yeḻa' mban c̱hele toḻi tocaṉe. Diosen' gwseḻe' neda' golja' beṉac̱h na' neda' goṉa' to da' ye'ej gagwle cont gata' yeḻa' mban c̱hele toḻi tocaṉe. Na' X̱a' Diosen' ba blo'e naca' ben' ba gwseḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na' gose'ene': ―¿Bi cheyaḻa' gonto', cont yebe Diosen' neto'? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na' gož Jesúsen' ḻegaque': ―Da' nga gonḻe cont yebe Diosen' le'e, šejnilaže'le neda' naca' ben' gwseḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Na' gose'e Jesúsen': ―¿Bi yeḻa' guac gono' še ca' cont le'eto' na' šejnilaže'to' le'? ¿Bi gono'? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Da' x̱ozxta'ocho ca' gosagüe' yeḻa' guagw da' nzi' maná šlac gosenite' latje dašen', na' nyoj Xtiža' Diosen' c̱hegaquen', žan: “Yeḻa' guagw da' za' yaban' be'e ḻegaque' gosagüe'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Nach Jesúsen' gože' ḻegaque': ―Chnia' le'e to da' zejen, gague da' Moisésen' bnežjue' da' x̱ozxta'ocho ca' yeḻa' guagon', san X̱a' Diosen' bnežjuen' ḻegaque'. Na' bi ṉacho ḻenṉa' zan' yaba gan' zoe'na', san de to yeḻa' guagw da' ba gwseḻa' Diosen' ṉa'a da' za' yaban' na' betjen yežlion', na' chnežjon yeḻa' mban c̱he note'teze beṉe' chesagw ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nach beṉe' ca' gose'e ḻe': ―Beṉe', beṉšca neto' yeḻa' guagon' žo' ca' gagwton' yogo' ža. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nach Jesúsen' gože' ḻegaque': ―Neda' naca' yeḻa' guagw da' chnežjon beṉe' yeḻa' mban toḻi tocaṉe. Note'teze beṉe' yosozenag c̱hia' na' yesejnilaže' neda', guata' da' chyažje yic̱hjlažda'ogaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na' ba gwnicza' le'e, ḻa'czḻa' ba ble'ele neda' bi chejnilaže'le neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yogo' beṉe' chbej X̱an' cont yesaque' neda' txen, chžin ža chesejnilaže' neda'. Na' note'teze beṉe' chaclaže' šejnilaže' neda', bi gwsia'ne' ca'ale, san gaclena'ne' cont šejnilaže'nda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Neda' za'a yaba na' betja' yežlion' gague cont gona' da' žan c̱hia' san cont gona' can' chaclaže' X̱an' ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ḻen' chaclaže' bi gua'a latje cuiayi' ṉe toze beṉe' ba gwleje' cont yesaque' neda' txen. Nach cate' žin ža te c̱he yežlion' cana' yosbangaca'ne' ladjo beṉe' guat še ba gosate'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","X̱an' chaclaže' yogo'ḻoḻ beṉe' yesejni'ide' non' naca' na' yesejnilaže' neda' cont gwnežjue' ḻegaque' yeḻa' mban toḻi tocaṉe, na' neda' yosbana' ḻegaque' ladjo beṉe' guaten' še ba gosate' cate' žin ža te c̱he yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na' zan beṉe' Israel gualaž c̱heto' ḻegacze' besežeše' c̱he dan' gwna Jesúsen': “Neda' naca' yeḻa' guagw da' za' yaba.” ");
INSERT INTO zpqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Gosene': ―¿Gague bengan' Jesús xi'iṉ José? Nombia'cho x̱axṉa' benga. ¿Bi dižan' cho'e že' ze'e yaba betje' yežlio? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nach Jesúsen' gože' ḻegaque': ―Bich žešele c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nono gac yesejnilaže' neda' še X̱an' ben' gwseḻe' neda' bi gaclene' ḻegaque' yesejnilaže', na' cate' žin ža te c̱he yežlion' yosbana' ḻegaque' še ba gosate'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ḻe'e gan' bosozoj beṉe' ca' goseyix̱jue'ede' xtiža' Diosen' cani' žan: “Yogüe' Diosen' gwsed gwlo'ede' ḻegaque'.” Na' yogo' no yeseṉeze can' ža X̱an' na' yosozenague' cont yesone' can' že'na', ḻecz yesejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Bi ṉacho zoa beṉe' ba ble'ede' X̱an'. Toza' neda' ba ble'eda'ne', ḻe za'a gan' zoen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chnia' le'e to da' zejen, beṉe' chesejnilaže' neda', de yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Neda' naca' yeḻa' guagw da' chnežjon yeḻa' mban toḻi tocaṉe c̱he beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Da' x̱ozxta'ocho ca' gosagüe' yeḻa' guagw da' nzi' maná šlac gosenite' latje dašen', na' bia'cze gosat yogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Neda' cho'a diža' c̱he to yeḻa' guagw da' za' yaban' na' beṉe' chagw ḻen bi gate'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Neda' naca' yeḻa' guagw dan' za' yaban' dan' nsa' yeḻa' mban toḻi tocaṉe. Beṉe' šejnilaže' neda', bane' toḻi tocaṉe. Na' yeḻa' guagw da' chnežjua' cont gata' yeḻa' mban c̱he beṉac̱hen' naquen cuerp c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nach beṉe' Israel gualaž c̱heto' ca' ḻegacze' besežeše', goseṉe' c̱he': ―¿Nacxe gone' goṉe' cuerp c̱hen' gagwchon? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesúsen' gože' ḻegaque': ―Chnia' le'e to da' zejen, Diosen' gwseḻe' neda' golja' beṉac̱h, na' še bi chagwle cuerp c̱hian' na' še bi che'ejle xc̱henan', bi de yeḻa' mban c̱hele toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Beṉe' chesagw cuerp c̱hian' na' chese'eje' xc̱henan' de yeḻa' mban c̱hegaque' toḻi tocaṉe, na' še ba gosate', cate' te c̱he yežlion' yosbana' ḻegaque' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ḻe cuerp c̱hian' naquen dogualje yeḻa' guagw, na' xc̱henan' naquen dogualje da' ye'ejle. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Beṉe' ca' chesagw cuerp c̱hia' na' chese'eje' xc̱henan' de yeḻa' mban c̱hegaque' toḻi tocaṉe, na' zjanaque' txen len neda' na' neda' naca' txen len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","X̱a' Diosen' gwseḻe' neda' na' de yeḻa' mban c̱hia' da' naca' toze len ḻe'. Na' ca'cze gac len beṉe' yesagw cuerp c̱hian', yesenite' toḻi tocaṉe dan' zjanaque' txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cuerp c̱hian' naquen yeḻa' guagw da' za' yaba. Na' ḻen bi naquen ca da' gosagw da' x̱ozxta'ocho ca' latje dašen', ḻe beṉe' gosagw ḻen bia'cze gosate'. Na' beṉe' chesagw yeḻa' guagw dan' žia' ca', yesenite' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesúsen' bsed blo'ede' da' ca' ḻo' yodao' c̱he beṉe' Israel gualaž c̱heto' ca' da' zoa Capernaum. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na' zan beṉe' ca' zjanao' Jesúsen', cate' gosende' da'na' chzejni'ide' ḻegaque', gosene': ―Zdebechgua naquen goncho dan' chzejni'iden'. ¿Noxen' gac gon can' žen'? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gocbe'e Jesúsen' cheseṉie' c̱he' dan' bzejni'ide' ḻegaque' da' ca', na' gozne': ―¿Bi chazlaže'le can' ba gwnian'? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nacxe ṉale cate' le'ele neda' yeyepa' gan' gwzoa' cana'? neda' naca' ben' gwseḻa' Diosen' golja' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spiritw c̱hian' chnežjon beṉac̱hen' yeḻa' mban, na' cuerp c̱hian' bi gac gonen ca'. Diža' dan' bac̱h bia' len le'e zjazacan' len yic̱hjlažda'olen' cont banḻe toḻi tocaṉe še šejḻe'le c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Perw ṉe' nita' baḻle bi chejḻe'le. Jesúsen' gwne' ca' ḻe gocbe'ede' cate' gosezolao beṉe' ca' gosedalene' ḻe' noe' bi chesejḻe'e c̱he' na' noe' gwdie'ne' ḻo na' beṉe' ca' chesegue'ede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na' gozna' Jesúsen': ―Chac can' ba gwnian', nono gac šejnilaže' neda' še bi gaclen X̱a' Diosen' ḻe' cont šejnilaže'nda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Beyož bzejni'i Jesúsen' ḻegaque' da' ca', zan beṉe' ca' ba chosozenag xtižen' gosebejyic̱hje' bich bosozenaguen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nach Jesúsen' gože' šižiṉw beṉe' ca' gwleje' cont gosaque' ḻe' txen: ―¿Len le'e chaclaže'le yeyejle? ");
INSERT INTO zpqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Na' gož Simón Pedron' ḻe': ―X̱anto', noch no zaca' gwzenagto' xtižen'. Tozo' le' cho'o diža' da' chnežjon yeḻa' mban c̱he beṉe' chzenague' c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Neto' chejnilaže'to' le' na' ṉezeto' naco' Cristo ben' gwlej Diosen' cont ṉabi'o, na' naco' dogualje Xi'iṉ Dios, Dios ben' zoa toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na' Jesúsen' gože' ḻegaque': ―Ba gwleja' le'e šižiṉwle cont zoale len neda' na' ṉezda' tole chzenagle c̱he gwxiyen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gwne' ca' c̱he Judas Iscariote ben' naque' xi'iṉ to beṉe' le' Simón, ḻe gwṉezde' Judasen' ba naquen gwdie' ḻe' ḻo na' beṉe' ca' chesegue'e ḻe', na' Judasen' naque' to beṉe' šižiṉw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gwde na' Jesúsen' gwdacze' bsed blo'ede' ben' že' distritw Galilean'. Bich goclaže' šejche' Judean', ḻe beṉe' gwnabia' c̱he nación Israel c̱heton' že' na' cheseyiljue' nacle yesone' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na' ba zoa gaḻa' ḻṉi c̱he neto' beṉe' Israel da' nzi' Ḻṉi c̱he Ranšw Yix. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Na' beṉe' biše' Jesúsen' gose'ene': ―Bitw yega'aṉo' nga. San gwyej Judean' cont beṉe' ca' chosozenag c̱hio' yesele'ede' yeḻa' guac dan' chonon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Note'teze beṉe' še chaclaže' yesacbe'e beṉe' naque' to beṉe' zaca', bi gone' yeḻa' guac bagaše'ze. Še da' ḻi chono' yeḻa' guac, ben cont yesele'e yogo'ḻoḻ beṉe' can' chonon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Beṉe' biše' Jesúsen' gose'ene' ca', ḻe ṉe ḻegaque' bi gosejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nach gož Jesúsen' ḻegaque': ―Biṉa' žin ža ša'a, san le'e guac šja'acle bate'teze. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Beṉe' ca' bi zjanombi'e Diosen' bi gac yesegue'ede' le'e, san chesegue'ede' neda', ḻe chzejni'ida'ne' chesone' da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ḻe šja'ac ḻṉin'. Neda' bi sa'a ṉa'a, ḻe biṉa' žin ža c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Beyož gože' ḻegaque' ca' bega'aṉe' Galilean' yeto c̱hop ža. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nach gwde gosa'ac beṉe' biše' ca' zja'aque' ḻṉin' gwza' Jesúsen' len beṉe' ca' zjanaque' ḻe' txen zja'aque' ḻṉin', perw bi ja'aque' can' nḻa'ze san bagaše'ze. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na' beṉe' gwnabia' c̱he nación Israel c̱heton' že' Jerusalénṉa' besyeyiljue' ḻe' ḻo ḻṉin', chesene': ―¿Gaṉxe bena'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na' beṉe' ca' zjandop zjanžag ḻo ḻṉin' šižize goso'e diža' c̱he Jesúsen', na' gague toze ca gosene'. Baḻe' gosene': “Naque' beṉe' güen”, na' baḻe' gosene': “Bi naque', chonḻede' beṉe'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na' goso'e diža' šižize c̱he Jesúsen', ḻe yogo'ze beṉe' chesežebe' bi yesone beṉe' gwnabia' ca' ḻegaque' še yesacbe'ede' cheso'e diža' güen c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na' do gašje zej ḻṉin' cate' gwyej Jesúsen' gan' zoa yodao' blao c̱he neto' beṉe' Israel na' gwzolao chsed chlo'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na' besyebane beṉe' gwnabia' ca', gosene': ―¿Nacxec̱hen' da' zan ṉeze benga? ḻe gague bi nseden'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Na' Jesúsen' gože' ḻegaque': ―Dan' chsed chlo'edan' bi naquen xbab c̱hecza', san naquen xbab c̱he beṉe' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Note'tez beṉe' chesaclaže' yesone' can' chazlaže' Dios ben' gwseḻa' nedan', guacbe'ede' še dan' chsed chlo'edan' zan' c̱he Dios o še naquen da' chaljlaže'za'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cate' to beṉe' chsed chlo'ede' xbab c̱hecze', cheyiljue' nacle gone' cont gacxene'. San cate' to beṉe' chaclaže' gacxen beṉe' gwseḻa' ḻe', ṉezecho xtižen' naquen da' ḻi na' bi chziye'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Da' Moisésen' beṉe' le'e ley dan' nsedlen' perw ṉe tole bi chonḻe can' žanṉa'. ¿Bixc̱hen' cheyiljwle nacle gonḻe gotlenda'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Beṉe' ca' že'na' gose'ene': ―Yo'o da' x̱igüen', nan' choḻ chṉenošo'. ¿No chaclaže' got le'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesúsen' gože' ḻegaque': ―Toz yeḻa' guac da' bena' ža c̱he Dios cate' bi de ḻsens gon chio' beṉe' Israel žin, na' yogo'le chebanele. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Da' Moisésen' bene' mandadw soacho señw dan' že' circuncisión (ḻa'czḻa' bi gwzolao señon' len ḻe' san len da' x̱ozxta'ocho ca' beṉe' gwnita' cani'te), na' da'nan' chzoale bi' byo dao' ca' señwna' ža c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Can' naquen, ḻa'czḻa' še naquen ža c̱he Dios, chzoale no bi' byo dao' señw cate' chaquebe' x̱ono' ža cont chonḻe can' ža ley dan' bzoj Moisésen', na' ¿bixc̱hen' chža'ale neda' dan' ba beyona' to beṉe' güe' ža c̱he Diosen'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bi cheyaḻa' yosbaga'le beṉe' c̱he da' chle'ele chone', ḻe bi ṉezele še chazlaže' Diosen' can' chone', san ḻe ṉabyaṉe' cont ṉezele bi ža Diosen', nachen' gacbe'ele non' cheyaḻa' yosbaga'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nach to c̱hope beṉe' Jerusalén ca' gosene': ―¿Gague benga ben' chesyeyiljue' cont yesote'ne'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ḻe ṉa' can' cho'e dižan' lao yogo' beṉe' na' bibi chese'e ḻe'. ¿Gague ba cheson beṉe' gwnabia' c̱hecho xbab ḻe naque' Cristo ben' chbezcho yedeṉabia'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Perw ṉezecho ga beṉe' benga, na' cate' yid Criston' nono yeseṉeze ga beṉe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesúsen' chsed chlo'ede' chalšil c̱he yodao' blao cate' gosene' ca'. Nach gwṉe' zižje gože' ḻegaque': ―Chaquele nombia'le neda' na' chaquele ṉezele ga beṉe' neda'. Perw gague con za'a to gualaza'. Da' ḻi zoa beṉe' gwseḻe' neda', na' le'e bi nombia'lne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Neda' nombi'ane', ḻe za'a gan' zoen' na' ḻe' gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Na' da' gwne' ca' baḻ beṉe' gosaclaže'chgüe' yesezene' ḻe', perw nono gwzen ḻe' da' biṉa' žin ža gaque' ḻo na'gaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na' beṉe' zan gosejḻe'e Jesúsen' naque' beṉe' gwseḻa' Dios, na' gosene': ―Cate' yid Criston' ¿gonche' yeḻa' guac da' zaca'ch ca da' chon benga? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Beṉe' fariseo ca' gosende' diža' cheso'e beṉe' ca' c̱he Jesúsen'. Da'nan' bosoxi'e len beṉe' ca' zjanac bx̱oz gwnabia' c̱he nación Israel c̱heton' na' goseseḻe' beṉe' chesape' yodao' blaon' cont šjasexene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nach Jesúsen' bsed blo'echde' beṉe' ca' že'na', gwne': ―Soacha' yeto tiemp dao' len le'e nach yeya'a gan' zoa ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na' yeyiljwle neda' na' bi yeželele neda', ḻe gan' soan' bi gac yidle. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nach beṉe' gwnabia' c̱he nación Israel c̱heton' gose' ḻježe': ―¿Gan' chacde' yeyeje' ga bi yeželechone'? ¿Yeyeje' gan' zjanasḻas beṉe' gualaž c̱hecho ladjo beṉe' griego ca' na' gwsed gwlo'ede' ḻegaque'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Bi zejen dan' gwnen': “Yeyiljwle neda' na' bi yeželele neda' na' gan' soan' bi gac yidle”? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ža cate' zelao chesone' ḻṉin' naquen ža xench, na' Jesúsen' zeche' chsed chlo'ede' na' gwṉe' zižje, gwne': ―Note'tezle še ḻo' yic̱hjlažda'olen' nacle ca beṉe' chbiḻlaže', cheyaḻa' šejnilaže'le neda' na' goṉa' le'e yeḻa' mban toḻi tocaṉe, na' ḻenṉa' gaquen ḻo' yic̱hjlažda'olen' ca to nis da' gwbat cheyo'ojen cont bich gacle ca to beṉe' chbiḻlaže'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Le'e chejnilaže'le neda', gac c̱hele can' ža Xtiža' Diosen' da' nyojen, to da' güen juisyw gac ḻo' yic̱hjlažda'olen' cont gacle ca to yežlio ga chaldi nis, gan' de zan yegw da' cheseyilen ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na' dan' gwna Jesúsen' ca' be'e diža' c̱he Spiritw c̱he Diosen' da' yedesoan ḻo' yic̱hjlaždao' note'tezcho chejnilaže'chone'. Na' caten' gwne' ca' Spiriton' biṉa' yedesoan ḻo' yic̱hjlaždao' beṉe', ḻe biṉa' gac yogo' da' cheyaḻa' gac cont gacbia' Jesúsen' naque' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Beṉe' ca' chosozenag xtiža' Jesúsen' baḻe' gosene': ―Da' ḻi benga naque' ben' choe' xtiža' Diosen' ben' naquen yide'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na' yebaḻe' gosene': ―Benga Criston' ben' naquen yedeṉabia'. Perw yebaḻe' gosene': ―¿Bixe ṉacho beṉe' Galilea ba gwlej Diosen' cont yedeṉabi'e chio'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Xtiža' Diosen' da' nyojen žan Criston' ben' yedeṉabi'e choje' ḻo diaža c̱he da' rey David na' gaque' beṉe' Belén gan' nac laž da' David. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Can' goc beṉe' ca' gosaque' c̱hople ṉec̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Na' baḻe' gosaclaže' yesezene'ne', perw nono gwzen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na' beṉe' chesape' yodao' blaon' jaya'aque' gan' nita' bx̱oz gwnabia' ca' len beṉe' fariseo ca', ḻe beṉe' can' goseseḻe' ḻegaque' cont yesezene' Jesúsen'. Na' beṉe' ca' gose'e ḻegaque': ―¿Bixc̱hen' bi nc̱he'elne'? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na' beṉe' chesape' yodao' blaon' gose'ene': ―Biṉa' yeneto' beṉe' cho'e diža' güen ca dan' choe' bena'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nach beṉe' fariseon' gose'e ḻegaque': ―¿Lente le'e ba gwxiye'e? ");
INSERT INTO zpqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ṉe toz neto' nacto' beṉe' fariseo biṉa' šejḻe'to' xtižen' na' ṉeca beṉe' gwnabia' c̱hechon', ṉe toze' biṉa' šejḻe'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Perw beṉe' quinga že' nga bi zjanombi'e ley dan' bzoj da' Moisésen' na' ba zjambiaye'e, da'nan' chesejḻe'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na' Nicodemo ben' gwyej lao Ješusen' šeže'le naque' txen len beṉe' gwnabia' ca'. Na' Nicodemon' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ley c̱hechon' bi choen' latje c̱hoglaocho c̱he to beṉe' ba ben da' mal še biṉa' güe'e diža' naquen' goc na' še biṉa' ṉezecho bi dan' bene'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nach yezica'chle beṉe' gwnabia' ca' gose'e ḻe': ―¿Leno' le' ba beyaco' beṉe' Galilea? Bsed Xtiža' Diosen' da' nyojen na' ṉezdo' ṉe to beṉe' choe' xtiža' Diosen' ca ṉa' choje' Galilean'. ");
INSERT INTO zpqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nach besyeya'ac to toe' jaya'ac ližgaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na' Jesúsen' gwyeje' ya'a da' nzi' Ya'a Olivos. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na' beteyo cate' gwyeni' gwyeje' yodao' blaon' da' yoble na' yogo' beṉe' ca' že' na' gosebigue' lagüen' na' gwchi'e na' gwzolagüe' chsed chlo'ede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nach beṉe' chososed chosolo'e ley dan' bzoj da' Moisésen' na' beṉe' fariseo ca' jasesane' to no'ole beṉe' besyedoḻe'de' len xtoe'. Na' bosozeche' ḻe' gachoḻ beṉe' ca' chosozenag c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Na' gose'e Jesúsen': ―Maestrw, no'ole nga ba bedoḻe'to' delene' xtoe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na' ley c̱hechon' da' bzoj Moisésen' žan cheyaḻa' gotcho no'ol ca' cheson ca' gwc̱heḻchone' yej. Na' ¿bi žo' le'? ¿bix cheyaḻa' gonechone'? ");
INSERT INTO zpqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gose'e Jesúsen' ca' da' gosaclaže' yesebeje' ḻe' diža' da' yosoc̱hine' yesagüe' xya c̱he'. Na' Jesúsen' con bcheque' bzoje' ḻo yon' len xbene'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na' beṉe' ca' gosone' byen goseṉabchde' ḻe' bi že'. Nach Jesúsen' bebe'šagüe' na' gože' ḻegaque': ―Guaque con note'tezle bi de xtoḻa'le solaole gwc̱heḻlene' yejen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nach bcheque' da' yoble bzojche' ḻo yon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na' beṉe' ca' zjanc̱he' no'olen' cate' gosende' can' gož Jesúsen' ḻegaque', zjaṉezde' ḻecze ba zjanoncze' da' xiṉj, nach tgüeje tgüeje' besyechoje' gwzolaotequen' len beṉe' golech na' bžinten len beṉe' xcuide'ch, nach bega'aṉ yetoze no'olen' len Jesúsen' gan' že' beṉe' ca' chsed chlo'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nach Jesúsen' bebe'šagüe' da' yoble na' ble'ede' noch no beṉe' ca' zjanḻa' na' gože' no'olen': ―No'ole, ¿gaṉxe beṉe' ca' chosocuiš le'? ¿Ṉe toe' bi beṉ le' castigw? ");
INSERT INTO zpqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na' no'olen' gože'ne': ―Ṉe toe', beṉe'. Na' Jesúsen' gože'ne': ―Ṉe neda' bi goṉa' le' castigw. Beyej na' bich gono' da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesúsen' gozo'e diža' da' yoble chzejni'ide' beṉe' ca' že' na', gwne': ―Neda' nsa'a be'ni' c̱he yic̱hjlaždao' beṉac̱hen'. Beṉe' zjanaque' neda' txen bich zjanaque' ca beṉe' yic̱hjlaždao' lc̱hoḻ beṉe' cheson da' xiṉj, san ḻo' yic̱hjlažda'ogaque' naquen ca to da' yo'o be'ni'. Da'nan' ba de yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nach beṉe' fariseo ca' gose'e Jesúsen': ―Cho'o diža' c̱he cuino' naco' beṉe' zaca', na' da'nan' bi naquen to da' yesejḻe' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na' gož Jesúsen' ḻegaque': ―Ḻa'czḻa' cho'a diža' c̱he cuina', xtižan' naquen da' ḻi. Neda' ṉezda' gan' gwza'a na' gan' yeya'a, perw le'e bi ṉezele gan' za'a na' gan' yeya'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ḻe'e chosbaga'le neda' con can' chon beṉac̱hen' xbab, san neda' nono chosbaga' bi da' yosbaga'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Perw na' šaca' bi da' yosbaga' beṉe', gonan' ca cheyaḻa', ḻe bibi de da' chona' to gualaza', san chona' dan' ža X̱an' ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ley c̱hechon' dan' chsedlen' žan cheyaḻa' šejḻe'cho cate' chediḻ diža' da' chesoe' c̱hope testigw. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na' nac c̱hopto' choe'to' xtiža': neda' cho'a diža' c̱he cuina' na' X̱an' ben' gwseḻa' neda' ḻecze cho'e diža' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Na' gose'ene': ―¿Gaxe zoa x̱aon'? Na' gwna Jesúsen': ―Ṉe neda' ṉe X̱an' bi nombia'le. Šaca' nombia'le neda' ḻecze nombia'le X̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Diža' ca' bsed blo'e Jesúsen' cate' ze' gaḻa'ze gan' chesegüe'e mechw ḻo' yodao' blao c̱he neto' beṉe' Israel. Na' nono gwzen ḻe', ḻe biṉa' žin ža gaque' ḻo na' beṉe' chesegue'ede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nach Jesúsen' gože' ḻegaque': ―Neda' yeya'a, na' yeyiljwle neda' perw bi gac yeyejle gan' yeya'an, ḻe biṉa' yetiṉjele xtoḻa'len' cate' žin ža gatle. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na' da' gwne' ca' beṉe' gwnabia' c̱he nación Israel c̱heton' gosene': ―¿Yeyot cuinen' že' gan' yeyejen' bi gac šejcho? ");
INSERT INTO zpqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nach Jesúsen' gože' ḻegaque': ―Le'e nacle beṉe' c̱he yežlio nga na' chzenagle c̱he dan' chnabia' yežlion', san neda' za'a yaba na' bi chzenaga' c̱he dan' chnabia' yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Da'nan' gwnia' biṉa' yetiṉjele xtoḻa'len' cate' žin ža gatle. Ḻe še bi šejḻe'le neda' naca' doxen can' gwnian', gatle biṉa' yetiṉjele xtoḻa'len'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nach gose'e Jesúsen': ―¿Nox naco' le'? Na' gož Jesúsen' ḻegaque': ―Zan ṉi'a ba gwnia' le'e non' naca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ṉe' dech da' zan da' ṉia' cont gwzejni'ida' le'e naple doḻa'. Perw beṉe' gwseḻa' neda' ṉezde' yogo'ḻoḻ na' cho'e diža' ḻi, na' neda' choe'lena' beṉac̱hen' diža' da' ba benda' gwne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Beṉe' gwnabia' ca' bi gosejni'ide' choe'lene' ḻegaque' diža' c̱he X̱e' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nach Jesúsen' gože' ḻegaque': ―Cate' ba gwde gwḻisle neda' to ḻe'e yag, neda' naca' beṉe' gwseḻa' Diosen' golja' beṉac̱h, cana'ch gacbe'ele ḻe naca' ben' ba gwnia' le'e, na' gacbe'ele bibi chona' to gualaza', san con da' bzejni'i X̱an' neda', ḻenṉa' žia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","X̱an' ben' gwseḻe' neda' zoacze' len neda'. Na' bi chbejyic̱hje'nda', ḻe bate'teze chona' da' chazlaže'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na' šlac Jesúsen' choe'lene' beṉe' ca' dižan' nach beṉe' zan gosezolao chesejnilaže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nach Jesúsen' gože' beṉe' gualaž c̱heto' ca' bac̱h gosezolagüe' chesejnilaže'ne': ―Še soaczle gonḻe can' ba gwnian', gwlo'en da' ḻi nacle txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na' še soaczle gonḻe can' ba gwnian', nachen' šejni'ile diža' ḻi c̱hian' na' gaclenen le'e cont yechojle ḻo na' da' chnabia' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Baḻ beṉe' ca' gose'e Jesúsen': ―Neto' nacto' diaža c̱he da' Abrahanṉa' na' nono ṉa' soa beṉe' ṉabia' neto'. ¿Bixc̱hen' žo' yechojto' ḻo na' da' chnabia' neto'? ");
INSERT INTO zpqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na' gož Jesúsen' ḻegaque': ―Chnia' le'e to da' zejen, yogo' beṉe' cheson da' xiṉj zjanaque' ḻo na' da' mal da' chnabian' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Beṉe' zoa liž x̱an xšine' bi naque' xi'iṉ ben' gan' chone' žinṉa', san šlož güejze zoe' txen len ḻegaque' len bi da' chesone'. San beṉe' golje' txen len ḻe', bate'teze zoe' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Neda' naca' dogualje Xi'iṉ Dios na' guac gona' cont da' malen' bich ṉabi'an yic̱hjlažda'olen' na' yechojle ḻo ne'en na' bich gaquen ca x̱anḻe. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ṉezda' nacle diaža c̱he da' Abrahanṉa', perw bia'cze cheyiljwlaže'le nac gonḻe cont gotle neda'. Na' chonḻe ca' da' bi chzenagle xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neda' cho'a diža' c̱he da' ca' ba ble'eda' cate' zoa' cuit X̱an', na' le'e ḻecze chonḻe da' ba benele gwna x̱alen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nach beṉe' ca' gose'e Jesúsen': ―¿Bixc̱hen' žo' ca'? Neto' nacto' diaža c̱he da' Abraham. Na' gož Jesúsen' ḻegaque': ―Šaca' nacle dogualje diaža c̱he da' Abraham, gonḻe can' ben da' Abrahanṉa' šaca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ḻa'czḻa' ba bzejni'ida' le'e diža' ḻi da' benda' gwna Diosen', bia'cze cheyiljwlaže'le nac gonḻe gotle neda'. Da' Abrahanṉa' bi bene' can' chonḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Toz can' chonḻe len x̱alen'. Nach beṉe' ca' gose'e ḻe': ―Toz Diosen' naque' X̱ato' na' bi chzenagto' c̱he nochle beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesúsen' gože' ḻegaque': ―Šaca' Diosen' naque' x̱ale gaquele neda', ḻe neda' gwza'a gan' zoa Diosen'. Bi za'a nga to gualaza', Diosen' gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bixc̱hen' bi chejni'ile dan' chnia' le'e? Ṉezda' bi chejni'ile dan' bi chaclaže'le gwzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satanás dan' chnabia' da' x̱igüe' ca' naquen x̱ale, nachen' chebele chonḻe can' chnalažen'ṉa'. Ḻen ba naquen güet beṉe' cate' gwxete yežlion'. Na' bi chzenaguen c̱he diža' ḻi, ḻe diža' ḻi bi yo'on ḻo' yic̱hjlažda'ogüen. Cate' chṉen diža' güenḻaže' chṉen con can' nac cuinen, ḻe naquen güenḻaže' na' yogo' diža' güenḻažen' zan' len ḻen. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na' neda', da' cho'a diža' ḻi, bi chejḻe'le c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Bibi da' mal nona' na' da'nan' ṉe tole bi gac gwlo'ele še bi da' mal ba bena'. Neda' zoateza' cho'a diža' ḻi, ¿bixc̱hen' bi chejḻe'le c̱hia'? ");
INSERT INTO zpqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Beṉe' ca' chon Diosen' ḻegaque' cuent ca xi'iṉe' chosozenague' xtižen'. Na' le'e bi chzenagle c̱hen' da' bi nacle xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nach beṉe' gwnabia' c̱he nación Israel c̱heton' gose'e Jesúsen': ―Can' ba gwnaczto' nacbia'cze naco' txen len beṉe' Samaria ca' na' yo'o to da' x̱igüe' ḻo' yic̱hjlažda'oguon' chonen ga choḻ chṉenošo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesúsen' gože' ḻegaque': ―Bi yo'o da' x̱igüen' ḻo' yic̱hjlažda'ogua', san chonxena' X̱an' na' le'e chṉele c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bi chyiljua' no gonxen neda', perw zoa X̱an' chaclaže' beṉac̱hen' yesonxene' neda' na' X̱an' c̱hoglagüen' c̱hele naple doḻa' da' chṉele c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chnia' le'e to da' zejen, note'teze beṉe' yosozenague' xtižan', guata'cze yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nach da' yoble beṉe' gwnabia' ca' gose'e ḻe': ―Nach beyož gwṉezeto' yo'o to da' x̱igüe' ḻo' yic̱hjlažda'oguon' chonen ga choḻ chṉenošo'. Ba got da' x̱ozxta'ocho Abrahanṉa', na' len beṉe' ca' goso'e xtiža' Diosen' cani' ḻecze ba gosate', na' chṉenošo' žo' beṉe' chosozenag xtižon' gata' yeḻa' mban c̱he' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Chacdo' zaca'cho' ca da' x̱ozxta'ocho Abrahanṉa' len beṉe' ca' gosoe' xtiža' Dios beṉe' ba gosat? ¿Noxen' chacdo' naco'? ");
INSERT INTO zpqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Gož Jesúsen' ḻegaque': ―Šaca' chonxen cuina' bibi zejen, perw X̱an' ben' žale naque' Dios ben' chejnilaže'le chonxene' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Le'e bi nombia'lne', san neda' nombi'ane'. Šaca' ṉia' bi nombi'ane' gaca' beṉe' güenḻaže' can' naclena'. Perw neda' nombi'ane' na' chzenaga' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Da' Abrahanṉa' ben' žale nac x̱ozxta'ole bebechgüede' gwṉezde' le'ede' ba za'a len beṉac̱hen' na' zoe' mbalaz ba ble'eden'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na' gose' beṉe' blao c̱he nación Israel c̱heton' ḻe': ―Biṉa' gacdo' šiyon iz. Chṉenošo' žo' ba ble'edo' Abrahanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesúsen' gože' ḻegaque': ―Chnia' le'e to da' zejen, ba zoacza' neda' cate' biṉa' galje Abrahanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nach goseṉize' yej da' yosoc̱heḻe' ḻe', perw Jesúsen' bcuaše' na' beze'e yodaon'. Ṉeca gosacbe'ede' cate' bedie' ladjogaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Txen zej Jesúsen' len beṉe' ca' zjanaque' ḻe' txen cate' besele'ede' to beṉe' byo golje' nc̱hoḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na' gose'e Jesúsen': ―Maestrw, ¿non' nap doḻa' golje benga nc̱hoḻe', še ḻe' o še x̱axṉe'en? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Na' Jesúsen' gože' ḻegaque': ―Benga golje' nc̱hoḻe' gague da' nape' doḻa' na' gague da' zjanap x̱axṉe'en doḻa', san golje' ca' cont le'ele can' chon Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cheyaḻa' goncho xšin Dios ben' gwseḻa' neda' šlac ṉe' de latje. Gwžin ža bich gaḻa' gonchon. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Šlac ṉe' zoa' yežlion' chgua'a be'ni' ḻo' yic̱hjlaždao' beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Beyož gwne' ca' gwcho'oṉ x̱ene' ḻo yon' na' bene' late' gona' len x̱ene' na' gwdebe' gonan' yejlao beṉe' lc̱hoḻen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nach gože' ben': ―Gwyej jaydib yejlaguon' cho'a yel da' nzi' Yel Siloé. (Na' Siloé zeje diža' Nseḻa'.) Na' gwyeje' na' beyib yejlagüen' na' cate' beze'e zjayde' ba chle'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na' beṉe' gualiž c̱he' na' nochle beṉe' ba besele'e ḻe' yogo' ža cate' ṉe' nc̱hoḻen' gosene': ―¿Gague bengan' ba ble'echo chbe' chṉabe' carida? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na' baḻe' gosene': ―Ḻe bengan'. Na' yebaḻe' gosene': ―Bi nac ḻe' san yeto beṉe' yoblen', perw toz ca naque' len benga. Perw ben' beyaquen' gože' ḻegaque': ―Nedan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na' gose'ene': ―¿Nac goquen' gwzolao chle'edo'? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na' gože' ḻegaque': ―To beṉe' le Jesús bene' late' gona' na' gwdeben' yejlaguan' na' gože'nda': “Gwyej cho'a yel da' nzi' Yel Siloé na' jaydiben'.” Na' gwya'a na' beyiban' na' gwzolao chle'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nach gose' beṉe' ca' ḻe': ―¿Gaṉxe bena'? Na' gože' ḻegaque': ―Bi ṉezda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nach gosec̱he'e ben' goc lc̱hoḻen' gan' že' beṉe' fariseo ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nac to ža c̱he Dios caten' Jesúsen' bene' gonan' dan' gwdebe' yejlao bena' cont ble'ede' na' bi de ḻsens gon neto' beṉe' Israel žin ža c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na' beṉe' fariseo ca' ḻecze goseṉabde' ḻe' nac goquen' ba chle'ede'. Na' gože' ḻegaque': ―Gwdebe' gona' yejlaguan' na' jaydiban' na' ṉa'a ba chle'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nach baḻ beṉe' fariseo ca' gosene': ―Ṉezecho bi zoa Diosen' len bena' beyone' beṉe' lc̱hoḻen', ḻe chone' da' bi cheyaḻa' gone' ža c̱he Diosen'. Na' yebaḻe' gosene': ―¿Nac gon to beṉe' güen da' xiṉj gone' yeḻa' guac ca dan' ben benga? Na' ḻegacze' besechoje' c̱hop cuen. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Na' da' yoble gose'e ben' golje' nc̱hoḻe': ―¿Bi žo' le' c̱he ben' bene' cont chle'edo'? Na' bena' gwne': ―Naque' to beṉe' choe' xtiža' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na' beṉe' gwnabia' c̱he nación Israel c̱heton' bi gosejḻe'e golje ben' nc̱hoḻe' na' ṉa'a bac̱h chle'ede'. Nach gosaxe' x̱axṉe'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na' goseṉabde' ḻegaque', gose'ene': ―¿Xi'iṉle benga ben' žale golje' nc̱hoḻe'? ¿Nacxe goquen' chle'ede' ṉa'a? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","X̱axṉe'ena' gose'e ḻegaque': ―Ṉezeto' bengan' xi'iṉto', na' ṉezeto' golje' nc̱hoḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Perw bi ṉezeto' nac goquen' ba chle'ede' ṉa'a, na' ṉeca ṉezeto' non' ben cont ba chle'ede'. Ba zejeczede' iz, ḻe ṉabe cuine' cont güe'e diža' naquen' goc. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","X̱axṉe'en gosene' ca' da' chesežebe' beṉe' gwnabia' ca', ḻe beṉe' gwnabia' ca' ba gosec̱hoglagüen' bi yosolebe' ḻo' yodaon' note'teze beṉe' güe'e diža' chejḻe'e Jesúsen' naque' Cristo ben' chesebeze' yedeṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Da'nan' x̱axṉe'en gosene': “Ba zejeczede', ḻe ṉabe cuine'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nach da' yoble gosaxe' ben' golje' nc̱hoḻe' na' gose'ene': ―Be' diža' ḻi lao Diosen', ḻe bi naquen can' gwnao' bac̱he. Ṉezeto' ben' gwnao' beyon le' naque' beṉe' güen da' xiṉj. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na' ben' beyac yejlagüen' gwne': ―Bi ṉezda' še naque' beṉe' güen da' xiṉj o še bi naque'. Da' ṉezda', goca' beṉe' lc̱hoḻ na' ṉa'a ba chle'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na' da' yoble gose'e ḻe': ―¿Bi bende' le? ¿Nac benen' chle'edo'? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na' gože' ḻegaque': ―Ba gwnicza' le'e na' bi chzenagle. ¿Bixc̱hen' chaclaže'le yenian' da' yoble? ¿Len le'e chaclaže'le gwzenagle c̱he'? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nach gosezi'diže' ḻe', gosene': ―Le' naco' txen len ḻe', san neto' nacto' txen len da' Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ṉezeto' Diosen' be'lene' Moisésen' diža', perw benga bi ṉezeto' ga ze'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na' ben' golje' nc̱hoḻe' gože' ḻegaque': ―¡Da' zaca' yebanecho, bi ṉezele ga za' benga, na' bene' cont chle'eda'! ");
INSERT INTO zpqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ṉezecho Diosen' bi chzenague' c̱he beṉe' cheson da' xiṉj, san chzenague' c̱he note'tez beṉe' chejnilaže' ḻe', beṉe' cheson can' chnalažen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na' gwzolaoten cate' gwxe yežlion' biṉa' yenecho zoa beṉe' chac chone' cont chle'e beṉe' golje' nc̱hoḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Šaca' bengan' bi ze'e gan' zoa Diosen' bibi gac gone'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Beṉe' fariseo ca' beselocchgüe' na' gose'e ḻe': ―Len' goljtio' naco' beṉe' mal juisyw, ¿chacdo' zaco' gwseddo' neto'? Na' besyebeje' ḻe' ḻo' yodaon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesúsen' bende' diža' c̱he ben' beyac yejlagüen' can' goc c̱he' ba besyebeje'ne' ḻo' yodaon' nach jašague'ne' na' gože'ne': ―¿Chejnilažo' Xi'iṉ Diosen' ben' gwseḻen'? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na' gož ben' ḻe': ―Beṉe', gwna neda' non', cont šejnilaža'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesúsen' gože'ne': ―Nedan' ben' ba ble'eczedo' na' nedan' choe'lena' le' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nach bena' bzoa xibe' benxene' Jesúsen', gwne': ―X̱ana', chejnilaža' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nach Jesúsen' gwne': ―Za'a yežlio nga cont gata'bia' non' nap doḻa' na' non' bi nap doḻa'. Zedeyena' cont beṉe' ca' bi chesejni'i bich yesaque' ca beṉe' lc̱hoḻ, na' zedeyena' cont beṉe' ca' chesacde' chesejni'ide' yesaque' ca beṉe' lc̱hoḻ len yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nach baḻ beṉe' fariseo ca' nita' gaḻa'ze caten' gwne' ca' na' gosende' xtižen', gose'e Jesúsen': ―¿Chacdo' len neto' nacto' ca beṉe' lc̱hoḻ? ");
INSERT INTO zpqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nach Jesúsen' gože' ḻegaque': ―Šaca' nacle ca beṉe' lc̱hoḻ, bibi xtoḻa'le de, san žale chejni'ile, na' da'nan' naple doḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Chnia' le'e to da' zejen, beṉe' bi cho'o ḻo' le'ej c̱he xilan' gan' nac cho'a puerten' san chepe' ga yoble cont cho'e, benan' naque' beṉe' gwban. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ben' chsaljue' na' cho'e cho'a puerten', ḻen' güeyoe' xilan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na' ben' chap cho'a puert le'ej c̱he xilan' chsaljue' puertan' cont cho'o ben' chyoeban'. Na' xila' ca' chosozenagba' xtiža' ben' chyoeban', ḻe zjanombia'ba' ši'en cate' chaxe'ba' cho'e lagacba' cont chbeje'ba'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na' cate' ba gwleje' yogo'ba' ḻo' le'ejen', chbialagüe' laogacban', na' xila' c̱he' ca' chesa'oba' ḻe' da' zjanombia'ba' ši'en. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bi chesa'oba' beṉe' yoble, san chosyoxoṉjba' dan' bi zjanombia'ba' ši'en. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesúsen' be'e diža' c̱he beṉe' güeye' xila' ca' par bzejni'ide' beṉe' ca' že'na', perw bi gosejni'ide' bi zejen dan' gože' ḻegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nach Jesúsen' bsed blo'echde' ḻegaque' yeto, gwne': ―Chnia' le'e to da' zejen, nedan' naca' ca cho'a puert gan' cheso'o xila' ca' ḻo' le'ej c̱hegacban'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yogo' nochle beṉe' ba goside' cate' za' yida' neda', beṉe' bosozejni'ide' diža' güenḻaže', guac ṉacho zjanaque' beṉe' gwban. Perw beṉe' chesejnilaže' neda' bi chosozenague' xtiža' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Neda' naca' ca cho'a puert c̱he le'ej c̱he xila' ca'. Na' note'tez beṉe' yesejnilaže' neda', gata' yeḻa' mban c̱hegaque' toḻi tocaṉe na' soacza' gaclena' ḻegaque' bite'tez da' cheseyažjde'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Beṉe' ca' žia' beṉe' gwban chesaclaže' yesone' cont beṉe' ca' žia' zjanaque' xila' c̱hia' yesebejyic̱hje' xtižan' na' yosozenague' c̱he ḻegaque'. Na' še yosozenague' c̱he ḻegaque', yesebiaye'e. Na' neda' za'a chnežjua' yeḻa' mban toḻi tocaṉe c̱he beṉe' chesejnilaže' neda' cont ṉite' güenchgua. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Neda' binḻo chgüia chṉa'a beṉe' chesejnilaže'nda' ca chon to beṉe' güeye' xila' beṉe' chyoe' xila' c̱hen' binḻo. Na' da' nži'ida' ḻegaque', da'nan' chzane cuina' gata' ṉec̱he ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nita' beṉe' chesezi' laxjue' cont chosoyoe' xila' c̱he beṉe'. Na' beṉe' chesezi' laxjue' chesebejyic̱hje' xila' ca' cate' chesele'ede' za' beco'yo, ḻe xila' ca' bi zjanacba' be c̱hegaque'. Cheso'e latje chṉiz beco'yon' xila' ca' na' chesosḻasba' ḻegacba'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na' beṉe' bi zjanaque' x̱an xila' ca' chosoxoṉje' da' bi zjanži'ide' xilan', ḻe bi zjanac xilan' be c̱hegaque', san chosoyoeba' dan' chesezi' laxjuen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Neda' binḻo chgüia chṉa'a beṉe' ca' chesejnilaže'nda', chona' ca chon to beṉe' chyoe' xila' c̱hen' binḻo. Na' nombi'a beṉe' ca' chesejnilaže' neda' na' ḻegaque' zjanombi'e neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nombi'a ḻegaque' ca X̱an' nombi'e neda' na' neda' nombi'a X̱an'. Na' da' nži'ida' ḻegaque' chzane cuina' gata' ṉec̱he ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nita' beṉe' yoble beṉe' bi zjanaque' beṉe' Israel beṉe' yesejnilaže' neda'. Na' cheyaḻa' šjatoba' ḻegaque' cont yosozenague' c̱hia', nach yesaque' toze len yezica'chle beṉe' ba chesejnilaže' neda' na' toz neda' gwgüia ṉa'a yogo'ḻoḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Chzane' cuina' yesot beṉe' neda', na' techle yebana' da' yoble. Na' X̱an' chacchde' neda' ḻe chazlaže' da' chona' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nono checa'a yeḻa' mban c̱hian' san chzanḻaže' cuina' gata'. Guac zane cuina' yesote'nda' na' ḻecz guac yeyas yebana' ladjo beṉe' guaten', can' non X̱an' mandadw gona'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na' da' yoble beṉe' nación Israel c̱heton' besechoje' c̱hople ṉec̱he xtiža' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zane' gosene': ―Yo'o da' x̱igüen' yic̱hjlažda'ogüe', nan' choḻ chṉenoše'. ¿Bixc̱hen' chzenagle xtižen'? ");
INSERT INTO zpqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na' yebaḻe' gosene': ―Beṉe' yo'o da' x̱igüen' yic̱hjlažda'ogüen' bi gac gwšalje' ca'. ¿Guac gon da' x̱igüe' cont le'e beṉe' lc̱hoḻ? ");
INSERT INTO zpqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na' cate' bžin ža gwyo'o ḻṉi dan' chesone' chjasyeze'ede' žan' beyož besyeyone' yodao' blao c̱he Diosen', ba bžin tiemp zag Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na' Jesúsen' chde' chašil c̱he yodao' blaon' gan' nzi' Chašil c̱he Salomón. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na' beṉe' gwnabia' c̱he nación Israel c̱heton' gosec̱hje' Jesúsen' na' gose'ene': ―¿Bixc̱hen' chono' cont chacžejlaže'to' še naco' Cristo ben' chbezto' seḻa' Diosen' cont yedeṉabi'e nación c̱hechon'? Še len' Criston', gwnatega neto' zaca'lao. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Na' gož Jesúsen' ḻegaque': ―Ba gwnia' le'e na' bi chejḻe'le. Da' ca' ba bena' len yeḻa' guac c̱he X̱an' chlo'en naca' beṉe' gwseḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Perw bi chejḻe'le c̱hia' da' bi nacle txen len beṉe' chesejnilaže' neda', can' ba gwnicza' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nombi'a beṉe' chesejnilaže' neda', na' žia' ḻegaque' xila' c̱hia'. Ḻegaque' chosozenague' c̱hia' na' chesone' con can' chzejni'ida'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na' chnežjua' ḻegaque' yeḻa' mban toḻi tocaṉe na' gwbat yesebiaye'e na' nono gac yesyeca'a ḻegaque' ḻo na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","X̱an' ba gwleje' beṉe' ca' chesejnilaže' neda' cont chgüia chṉa'a ḻegaque'. Na' nono gac yesyeca'a ḻegaque' ḻo na' X̱an', ḻe nape' ḻa'zelagüe yeḻa' chnabia' xen. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Neda' na' X̱an' toz beṉe' nacto'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Beyož gwne' ca' beṉe' gwnabia' ca' goseṉize' yej cont yosoc̱heḻenen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na' gož Jesúsen' ḻegaque': ―Da' zan da' güen ba ble'ele bena' len yeḻa' guac c̱he X̱an'. ¿C̱he nonṉa' chaclaže'le gwc̱heḻle neda' yej? ");
INSERT INTO zpqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na' beṉe' gwnabia' ca' gose'e ḻe': ―Gague c̱he yeḻa' guac ca' benon' gwc̱heḻto' le' yej san da' chṉeya'o c̱he Diosen'. Con beṉac̱hze le' na' chon cuino' ca Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Na' gož Jesúsen' ḻegaque': ―Ṉezeczele can' nyoj Xtiža' Diosen' dan' nsedle gan' žan: “Neda' ba gwnia', le'e nacle ca neda' Dios.” ");
INSERT INTO zpqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na' Xtiža' Diosen' da' nyojen gague da' te c̱hen', na' ḻenṉa' žan Diosen' gwne' c̱he beṉe' ca' bosozenag xtižen' cani' gosaque' ca ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Diosen' gwleje' neda' cont gaclena' beṉac̱hen' že' yežlio nga na' ¿nacxec̱hen' ža le'e chṉeya'a c̱he Diosen' da' žia' naca' Xi'iṉe'? ");
INSERT INTO zpqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Še dan' chonan' bi chlo'en yeḻa' guac c̱he X̱a' Diosen', bi cheyaḻa' šejḻe'le c̱hia' šeca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Perw še chacbe'ele chona' da' zaca' len yeḻa' guac c̱he Diosen', cheyaḻa' šejḻe'le ḻen' gwseḻe' neda', ḻa'czḻa' bi chaclaže'le šejḻe'le xtižan'. Na' še šejḻe'le c̱he da' ca' chonan', nachen' ṉezele zoa X̱an' len neda' na' neda' zoa' len ḻe', ḻe toz beṉen' nacto'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nach da' yoble gosaclaže' yesezene' Jesúsen' perw bitw bdoḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesúsen' beyeje' jayzoe' yešḻa'a yegw Jordanṉa' latje gan' gwzoa da' Juanṉa' šlac ṉe' chzoe' beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na' beṉe' zan ja'ac gan' gwzoen' cont bosozenague' xtižen' na' gosene': ―Da' Juanṉa' ṉe to yeḻa' guac bi bene', perw yogo'ḻoḻ dan' gwne' c̱he benga naquen da' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na' beṉe' zan gosejnilaže' Jesúsen' latje na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Na' gwzoa to beṉe' gocšene beṉe' yež Betania le' Lázaro. Betania naquen laž María na' beṉe' bile' Marta, na' ḻegaque' zjanaque' beṉe' zan Lázaron'. María nan' bzoe' to set zix̱ ṉi'a X̱ancho Jesúsen' na' bosbiže' ṉi'en len yiša' yic̱hje'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na' beṉe' zan Lázaron' goseseḻe' diža' gan' zoa Jesúsen', chese'e ḻe': ―X̱anto', beṉe' xmigo' Lázaron' ba chacšende'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cate' gwṉeze Jesúsen' chacšene Lažaron', na' gwne': ―Ca nac yižgüe' c̱hen', bi che'eden' cont yeḻa' goten' gonen ḻe' gan, san che'eden' cont gacbe'ele catec beṉe' zaca' nac Diosen' na' gacbe'ele naca' beṉe' zaca'chgua, neda' naca' dogualje Xi'iṉ Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ḻa'czḻa' Jesúsen' chacde' Martan' len beṉe' bilen' na' len Lázaron', ");
INSERT INTO zpqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","cate' gwṉezde' chacšene Lázaron', bega'aṉche' yec̱hope ža gan' zoen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nach gože' beṉe' ca' zjanaque' ḻe' txen: ―Ḻe šo'o šejcho distritw Judean' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Na' gose'ene': ―Maestrw, bi ža na'zen' beṉe' gwnabia' c̱he nación c̱hechon' gosaclaže' yesote' le' yosoc̱heḻe' le' yej. ¿Da' yoble šejo' na'? ");
INSERT INTO zpqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesúsen' gože' ḻegaque': ―Lagüe žan' nsa' šižiṉw hor, na' beṉe' chda lagüe ža bi chc̱hegüe', ḻe nseṉi' gwbižen' ḻo yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Na' beṉe' chda ba goḻ chc̱hegüe', ḻe nac c̱hoḻ. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gwde gwne' ca' nach gože' ḻegaque': ―Beṉe' xmigwcho Lázaron' ba chtase' na' ša'a šjaysbana'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na' gose'ene': ―X̱anto', še ba chtase' güeyacczede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesúsen' gwne' ca' dan' gwṉezde' ba got Lázaron', na' beṉe' ca' zjanaque' Jesúsen' txen gosacde' še chtaszen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nach Jesúsen' bochix̱gaten' bi zejenṉa' gwne' ca': ―Ba got Lázaron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na' chebeda' bi gwzoa' na' šlac chacšende', cont gona' šejḻe'le c̱hia'. Ḻe šo'o šejcho gan' de'na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nach ben' le' Tomás ben' bososi'e Tomás Cuaš gože' yezica'chle beṉe' ca' zjanaque' Jesúsen' txen: ―Ḻe šo'o cont gatcho txen len Jesúsen' še yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na' ja'aque' Betanian' len Jesúsen', na' cate' besežine'na' beṉe' Betania ca' bosozende' ḻe' ba goc tap ža bosocuaše' Lázaron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanian' chin' gaḻa'ze Jerusalénṉa' ca do gašjw hor. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na' beṉe' zan beṉe' gualaž c̱hegaque' že' Jerusalénṉa' besežine' gan' zoa Martan' len Marían' cont yeso'e ḻegaque' yeḻa' chxenḻaže' da' got beṉe' zangaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nach Martan', cate' gwṉezde' Jesúsen' ba bžine' cho'a yežen', na' gwze'e jašague'ne'. Na' Marían' bega'aṉe' yo'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nach Martan' gože' Jesúsen': ―X̱ana', šaca' zo' nga caten' gocšene beṉe' zanan' biḻja gote' šaca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na' ṉezda' ḻa'czḻa' ba gote', bite'tez da' ṉabdo' Diosen' gone', gonczen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nach gož Jesúsen' ḻe': ―Güeban beṉe' zanon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nach Martan' gože'ne': ―Ṉezda' yebane' cate' yesyeban beṉe' guat ca' žan' te c̱he yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na' gož Jesúsen' ḻe': ―Neda' chac chosbana' beṉe' guat ca' ḻe nsa'a yeḻa' mban toḻi tocaṉe. Da'nan' beṉe' ca' yesejnilaže' neda', ḻa'czḻa' yesate', guata' yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na' note'tez beṉe' nite' chesejnilaže' neda', gwbat yesebiaye'e. ¿Chejḻi'o da' nga chnia' le'? ");
INSERT INTO zpqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na' gož Martan' ḻe': ―X̱ana', chejḻi'a naco' dogualje Xi'iṉ Dios. Chejḻi'a naco' Criston' ben' ba gwlezto' seḻa' Diosen' yežlion' yedeṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Beyož gwna Martan' ca' beyeje' jayeže' María bilen' šižize: ―Ba bla' Maestron' cho'a yežen' na' chṉie' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na' Marían' cate' bende' dan' gož Martan' ḻe' ḻa' gwza'te' na' gwyeje' gan' zoa Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Biṉa' žin Jesúsen' lagüe yežen' ca horen', ṉe' nga'aṉe' cho'a yežen' gan' jašag Martan' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na' beṉe' Jerusalén ca' nita' liž María, beṉe' cheso'e ḻe' yeḻa' chxenḻaže' da' got beṉe' zanen', cate' besele'ede' gwza' Marían' nach gosa'aclene' ḻe', gosacde' zeje' cho'a blojen' gan' ngaše' zjac̱heže'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na' Marían' cate' bžine' gan' zoa Jesúsen' na' ble'ede' ḻe', ḻa' bzoate xibe' lagüen', gože'ne': ―X̱ana', šaca' zo' nga caten' gocšene da' beṉe' zanan', biḻja gote' šaca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na' cate' ble'e Jesúsen' chbež Marían' na' ḻecze chesebež beṉe' Jerusalén ca' za'aclene' ḻe', da' juisyw da' goque Jesúsen' na' bžaglagüe' ḻo' yic̱hjlažda'ogüen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na' gože' ḻegaque': ―¿Ga bcuaše'lene'? Na' gose'e ḻe': ―X̱anto', yo'o na' le'edo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na' gwchež Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na' beṉe' Jerusalén ca' gosene': ―Ḻe ṉa' catequen' chacde' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na' baḻe' gosene': ―Bengan' bene' ga ble'e beṉe' lc̱hoḻen', na' šaca' gwzoe' nga caten' gocšene Lázaron', benḻje' cont bi gote'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na' da' yoble da' juisyw da' goque Jesúsen' ḻo' lažda'ogüen'. Na' gwyeje' gan' bosocuaše' ben'. Naquen to bloj na' da' to yej cho'enṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Na' Jesúsen' gože' beṉe' ca': ―Ḻe ca'a yejen'. Na' Martan' beṉe' zan da' Lázaron' gože'ne': ―X̱ana', ba chḻa' ben' zigw, ḻe bac̱h goc tap ža gote'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na' gož Jesúsen' ḻe': ―Ba gwnia' le' še šejnilažo' neda' na' le'edo' nac Diosen' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nach beṉe' ca' goseque'e yejen'. Na' Jesúsen' gwṉe'e yabale na' gwne': ―X̱a', chox̱cleno' ba bzenago' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ṉezda' yogo' ṉi'a chzenago' c̱hia', perw žia' ca' cont beṉe' ca' že' nga yesejḻe'e len' gwseḻo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Beyož boḻ güiže' Diosen', gwṉe' zižje, gwne': ―Lázaro, bechoj. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nach ḻa' bechojte Lázaron' ndobyoy ṉi'a ne'en to cint de lache' na' to bay ndobe cho'alagüen'. Na' Jesúsen' gože' ḻegaque': ―Ḻe yozaše' lachen' na' ḻe gwsane' yeyeje'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na' zan beṉe' Jerusalén ca' beṉe' ja'aclene' Marían' besele'ede' yeḻa' guac da' ben Jesúsen' na' gosejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Perw baḻ beṉe' Jerusalén ca' ja'aque' lao beṉe' fariseo ca' na' jaseže' ḻegaque' Jesúsen' bosbane' Lázaron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nach bx̱oz gwnabia' ca' c̱he neto' beṉe' Israel len beṉe' fariseo ca' bosyotobe' yogo'ḻoḻ beṉe' ca' chesenabia' nación c̱heton'. Na' bosoxi'e gosene': ―¿Nac goncho? ḻe yeḻa' guac zan chon benga. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na' še ṉacho jayenṉa', yogo'ze beṉe' yesejnilaže'ne', na' yesid beṉe' nación Roma na' yeseque'e yodao' blao c̱hechon' na' yosožiaye'e nación c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na' to beṉe' gwnabia' zoa ca horen' le' Caifás. Ḻe' naque' bx̱oz blao ḻo izen'. Na' gože' ḻegaque': ―Le'e gague bi ṉezele. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na' bi chacbe'ele napen chio' cuent toz ben' gat, clel ca cuiayi' yogo'cho lente nación c̱hecho nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gague con ca gwnalaže'ze Caifásen' gwne' ca', san da' naque' bx̱oz blao iznan', Diosen' bene' ga gwne' ca' cont gwdix̱jue'ede' gat Jesúsen' ṉec̱he nación c̱heton'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na' ca nac dan' gaten', gague gate' ṉec̱he nación c̱heto' na'zen' san gate' cont yogo' beṉe' ba gwlej Diosen' yesaque' xi'iṉe' gate'teze nación, yesaque' txen yesejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ca' goquen', žana' beṉe' gwnabia' ca' gosezolagüe' bosoxi'e nacle yesone' yesote' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na' da'nan' Jesúsen' bich gwdacze' con can' nḻa'ze gan' že' beṉe' gwnabia' c̱he nación c̱heton'. Nach gwze'e distritw Judean' na' gwc̱he'e beṉe' ca' zjanaque' ḻe' txen to yež da' nzi' Efraín da' chi' gaḻa'ze latje dašen', na' besyega'aṉe' na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na' ba zoa gaḻa' ḻṉi pascw c̱he neto' beṉe' Israel. Na' beṉe' zan beṉe' za'ac to to yež zja'aque' Jerusalénṉa' cate' za' gaḻa'le ḻṉin' cont yeson cuine' xilaže' can' ža ley c̱heton'. ");
INSERT INTO zpqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na' besyeyiljue' Jesúsen' do gan' zoa yodao' blaon' na' cate' bi besyeželde'ne' na' gose' ḻježe': ―¿Bi chaquele? ¿Güide' ḻṉi nga, še bi yide'? ");
INSERT INTO zpqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gosene' ca' ḻe bx̱oz gwnabia' c̱heto' ca' na' beṉe' fariseo ca' ba gosec̱hoguen' še note'tez beṉe' ṉezde' gan' zoa Jesúsen' cheyaḻa' gwzende' ḻegaque' cont yesezene' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na' yex̱op ža za' gaḻa' ḻṉi pascon', Jesúsen' gwc̱he'e beṉe' ca' zjanaque' ḻe' txen yež Betanian' gan' zoa Lázaron' ben' bosbane' ladjo beṉe' guaten'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na' baḻ beṉe' Betanian' bososiṉi'e to xše' da' gwdagw Jesúsen' cont gosonxene'ne'. Na' Martan' bdie' yeḻa' guagw na' Lázaron' gwche'lene' beṉe' ca' cho'a mesen' txen len Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na' Marían', de ca do tya set zix̱ c̱he' da' zaca'chgua la'ay na' naquen dogualje da' bchoj ḻo yag yej da' nzi' nardo. Na' jabigue' gaḻa'ze xṉi'a Jesúsen' na' gwlo'e set zix̱en' ṉi'ena' na' beyoža' bosbižen' len yiša' yic̱hje'. Na' doxen yo'ona' gwḻa'chguan ze set zix̱en'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na' Judas Iscariote xi'iṉ to beṉe' le' Simón, ḻe' naque' to beṉe' šižinw ca' zjanaque' Jesúsen' txen, na' ḻen' ba naquen gwdie' Jesúsen' ḻo na' beṉe' ca' chesegue'ede' ḻe'. Na' Judasen' gwne: ");
INSERT INTO zpqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Bixc̱hen' bi bete' seten' na' goṉe' mechon' cont gaclenen beṉe' yaše'? ḻe zacan' ca no laxjw mos da' gone' gan tgüiz. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasen' gwne' ca' gague da' beyaše'de' beṉe' yašen' san da' goque' beṉe' gwban. Ḻen' bex̱ue' mechw da' bosoc̱hin yogüe' na' gwlejlane' mechon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nach Jesúsen' gože'ne': ―Bibi ye'lne', ḻe ba bene' da' non gone' len neda' c̱he ža cate' gaša'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Beṉe' yaše' ca' nita'cze' len le'e bate'teze, san neda' bich soacza' yesša len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na' beṉe' zan beṉe' Israel gualaž c̱heton' goseṉezde' zoa Jesúsen' lagüe' yež Betanian' na' ja'aque', gague cont yesele'ede' Jesús na'zen' san da' gosaclaže' yesele'ede' lencze Lázaron' ben' bosbane' ladjo beṉe' guaten'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Na' bx̱oz gwnabia' c̱he nación Israel c̱heton' bosoxi'e ḻecze yesote' Lázaron', ");
INSERT INTO zpqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ḻe beṉe' zan beṉe' Israel ba chesyecuase' len ḻegaque' na' ba chesejnilaže' Jesúsen' dan' goseṉezde' bosbane' Lázaron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na' beteyo Jesúsen' len beṉe' ca' zjanaque' ḻe' txen gosa'aque' Betanian' na' ja'aque' Jerusalén. Na' beṉe' zan chesežag Jerusalénṉa' da' ba zoa gaḻa' ḻṉin', na' zane' cate' goseṉezde' žin Jesúsen' Jerusalénṉa', ");
INSERT INTO zpqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","besežaše' jaseḻeze' ḻe' zjanox̱e' no zin. Na' chesegüe'e ḻban' c̱he', chesene': ―¡Ḻeca beṉe' zaca' benga! Mbalaz ben' za' nga nseḻa' X̱ancho Diosen' ḻe' cont ṉabi'e. ¡Mbalaz beṉe' naque' Rey c̱he nación Israel c̱hechon'! ");
INSERT INTO zpqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na' bžel to burr dao' be gwžia Jesúsen', na' goc can' nyoj Xtiža' Diosen' žan: ");
INSERT INTO zpqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Le'e chonxenḻe Diosen' ciuda Jerusalénṉa', bi žeble; ḻe ṉa', ba za' Rey c̱helen' žie' to burr dao'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na' beṉe' ca' zjanaque' Jesúsen' txen gague cate gosejni'ide' chac con can' bosozoj ben' goso'e xtiža' Diosen' cani'. Beyož got Jesúsen' na' goc yogo' da' ca' gosaquen' cont bla'lagüe ḻe Jesúsen' naque' beṉe' zaca' juisyw, cana'ch jasyeza'laže' diža' ca' da' zjanyoj c̱he Jesúsen' na' gosejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Beṉe' ca' besele'e cate' Jesúsen' boḻ güiže' Lázaron' na' bosbane' ḻe' cont bechoje' ḻo' ban' gosoe'lene' beṉe' ca' že' ḻo ciudan' diža' can' goquen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na' da'nan' beṉe' zan jaseleze' Jesúsen' da' ba gosende' diža' c̱he yeḻa' guac dan' bene' bosbane' Lázaron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nach beṉe' fariseo ca' gose' ḻježe': ―Ba chle'ele bibi chac bi goncho. Yogo'ze beṉe' ba chosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na' zjalen to c̱hope beṉe' griego beṉe' ca' ja'aque' gosonxene' Diosen' ḻo ḻṉin'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na' beṉe' ca' besežine' gan' zoa Felipen' ben' nac beṉe' Betsaida ga mbane distritw Galilean', na' gose'ene': ―Si'xenšco', chaclaže'to' güe'lento' Jesúsen' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na' Felipen' gwyeje' jaṉe'e Andrésen' nach choptie' jaseže' Jesúsen' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nach Jesúsen' gože' ḻegaque': ―Ṉa'a ba bžin hor gac yogo'ḻoḻ da' cheyaḻa' gac cont la'lagüe naca' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Žia' to da' zejen, še to trigon' bi yexiṉjen cate' lažon' ḻo yon', con chega'aṉcze tozen; perw še yexiṉjen na' yelan', da' zan trigon' goṉen. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Note'tez beṉe' con chi' yic̱hje' gac güen c̱hegaque' yežlio nga, beṉe' ca' yesebiaye'e. Na' note'teze beṉe' chesene' bibi nonen še bi gac c̱hegaque' yežlio nga, šjasyezoe' len Diosen' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Na' note'tez beṉe' chesaclaže' yesone' xšinan', cheyaḻa' yesejnilaže' neda' na' yosozenague' c̱hia'. Na' gan' soa' neda' ḻecze na' yesezoa beṉe' ca' yeson xšinan'. Note'tez beṉe' yeson xšinan', X̱an' gone' cont yesacxene'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ba chžaglagua' ḻo' yic̱hjlažda'oguan'. ¿Chaquele ṉabda' X̱an' yosle' neda' ḻo da' ca' ba zoa gac c̱hia' ṉa'a? Bitw gona' ca', ḻe za'a cont gac c̱hia' yogo' da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nach boḻ güiže' Diosen', gwne': ―X̱a', ben len neda' cont yesacbe'e beṉe' naco' beṉe' zaca' juisyw. Beyož gwne' ca' na' gwṉe Dios ben' zoa yaban', gwne': ―Ba bena' len le' cont chesacbe'e beṉe' naca' beṉe' zaca' juisyw na' za' goncha' ca' yeto. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na' zan beṉe' ca' že' na' gosende' dan' gwna Diosen' na' gosene' gwzion' gwṉe. Na' yebaḻe' gosene': ―To angl gwṉe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Na' Jesúsen' gwne': ―Diosen' gwṉe' neda' zižje gague cont ṉezda' neda' chzenague' c̱hia' san cont ṉeze le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ba bžin ža Diosen' c̱hogbi'en' c̱he beṉe' ca' bi chesejḻe'e c̱hia'. Na' ba bžin ža Satanás dan' chnabia' da' x̱igüe' ca' na' dan' chnabia'te beṉe' ca' bi chosozenag c̱he Diosen' solao ṉit yeḻa' chnabia' c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na' cate' yeseḻise' neda' to ḻe'e yag, cana'ch gona' cont zan beṉe' že' doxen ḻo yežlion' yesejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Gwne' ca' cont goseṉezde' yesot beṉe' ḻe' yosode'ene' to ḻe'e yag cruz. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na' beṉe' ca' že'na' clele gosejni'ide' dan' gwnen' na' gose'e ḻe': ―Ba beneto' can' ža Xtiža' Diosen' da' nyojen, na' ṉezeto' žan Cristo ben' seḻa' Diosen' yedeṉabi'e nación c̱hechon' soe' toḻi tocaṉe. Na' le' ¿bixc̱hen' žo' naco' beṉe' gwseḻa' Dios goljo' beṉac̱h na' žo' yesote' le' to ḻe'e yag cruz še ca'? ¿Nox naco' šaca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nach Jesúsen' gože' ḻegaque': ―Yešlož da'ozen' soa' len le'e, neda' nsa' be'ni' c̱he yic̱hjlažda'olen'. Ḻe gwzenag c̱hia' šlac ṉe' de latje šo' be'ni' c̱hian' ḻo' yic̱hjlažda'olen', cont bi cuiayi'lenḻe da' mal dan' chnabia' le'e. Ben' chda gan' nac c̱hoḻ bi chacbe'ede' gan' zeje'. Can' naquen len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ḻe šejnilaže' neda' šlac ṉe' zoa' len le'e, cont šo' be'ni' c̱hian' ḻo' yic̱hjlažda'olen'. Gwde gwna Jesúsen' ca' beze'e na' bcuaše'de' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na' ḻa'czḻa' beṉe' Israel gualaž c̱heto' ca' besele'ede' ben Jesúsen' da' zan yeḻa' guac, zane' bi gosejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Goc can' bzoj da' Isaíasen' ben' be' xtiža' Diosen' cani', gwne': X̱anto', nono chejḻe' diža' dan' chyix̱jue'eton', na' nono chesacbe'e blo'o yeḻa' guac c̱hion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bi goc yesejḻe'e, ḻe goc c̱hegaque' can' ža yeto dan' bzoj da' Isaíasen', žan: ");
INSERT INTO zpqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diosen' bene' cont bi gosejni'ide' na' cont zjanaque' beṉe' güedena. Ba bene' cont chesele'ede' na' bi zjaṉezde' bi zejen, na' bi chesacbe'ede' ḻo' yic̱hjlažda'ogaque' bi zejen dan' chlo'ede' ḻegaque'. Šaca' chesejni'ide' na' chesacbe'ede' bi zejen dan' chlo'eda' ḻegaque', ba besyetiṉjde' na' ba beca'a xtoḻa'gaquen' šaca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Da' Isaíasen' gwne' ca' da' ble'ebande' nac Jesúsen' beṉe' zaca' juisyw nach be'e diža' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na' ḻa'czḻa' zanch beṉe' Israel gualaž c̱heto' ca' bi gosejnilaže' Jesúsen', bia'cze beṉe' zan na' len no beṉe' gwnabia' c̱heto' gosejnilaže'ne', perw bi goso'e diža' chesejnilaže'ne' ḻe besežebe' bich yosoleb beṉe' fariseo ca' ḻegaque' ḻo' yodaon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gosaclaže'che' yesenite' binḻo len beṉac̱hen' clel ca yesenite' binḻo len Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nach Jesúsen' gwne' zižje gože' beṉe' ca' že'na': ―Beṉe' chesejnilaže' neda' gague neda'zen' chesejnilaže' san lente X̱an' ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na' beṉe' chṉe'e neda' chle'ede' beṉe' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neda' za'a yežlio nga chgua'a be'ni' ḻo' yic̱hjlaždao' beṉe' ca' chesejnilaže' neda', cont bi yesenite' yesonche' da' malen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na' note'tez beṉe' ṉezde' can' ba gwnian' na' bi chzenague' c̱hia', gague neda' gwnežjua' castigw c̱he xtoḻen', ḻe bi za'a yežlion' cont gwnežjua' castigw c̱he xtoḻa' beṉac̱hen', san za'a cont gwnežjua' yeḻa' mban toḻi tocaṉe c̱he beṉe' yesejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Perw de da' c̱hoglaon c̱he beṉe' ca' bi chesejnilaže' neda' na' bi chosozenague' c̱he dan' ba gwnian', xtižan' dan' ba bian', ḻenṉa' c̱hoglaon c̱he beṉe' ca' zjanape' doḻa' cate' žin ža te c̱he yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gague bia' diža' to gualaza', san X̱a' ben' gwseḻa' nedan' none' mandadw bin' cheyaḻa' ṉia' na' bin' cheyaḻa' gwsed gwlo'eda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na' ṉezda' dan' none' mandadw ṉia' nsan' yeḻa' mban toḻi tocaṉe c̱he beṉe' yosozenag c̱hen. Na' da' ḻi, con can' ža X̱an', can' choe'lena' le'e diža'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na' Jesúsen' ba ṉezde' ba bžin ža yeze'e yežlion' na' yeyeje' gan' zoa X̱e' Diosen', na' gocde' yogo' beṉe' ba chejnilaže' ḻe' ḻo yežlio nga. Da'nan' za' gaḻa' ḻṉi pascon' bzejni'ide' beṉe' ca' zjanaque' ḻe' txen, ḻe chacyaṉe'czede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bac̱h gwlo'o Satanásen' xbab ḻo' yic̱hjlaždao' Judas Iscariote, ben' nac xi'iṉ to beṉe' le Simón, cont gwdie' Jesúsen' ḻo na' beṉe' ca' chesegue'ede' ḻe'. Na' ba zjanite' chesagüe' xše'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Na' Jesúsen' ṉezde' X̱en' ba bene' cont nape' ḻa'zelagüe yeḻa' chnabia', na' ṉezde' gan' zoa Diosen' gwze'e na' gan' zoe' nan' yeyeje'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Da'nan' gwzože'e cate' ba chesyedagüe' xše' na' gwlec̱hje' xe' da' nyaze' cha'le na' gwxi'e to lache' da' bc̱hej ḻsinen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nach gwxi'e nis na' gwde'en to ḻo' ša' na' gwzolagüe' gwdibe' ṉi'a beṉe' ca' zjanaque' ḻe' txen ca to mos, na' bosbiže' ṉi'agaquen' len lachen' nc̱hej ḻsinen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na' cate' ba zoa c̱hibe' ṉi'a Simón Pedro, Pedron' gože'ne': ―X̱ana', ¿le' c̱hibo' ṉi'an'? ");
INSERT INTO zpqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na' Jesúsen' gože'ne': ―Dan' chona' nga bi chejni'idon' ṉa'a, perw gwžin ža cate' šejni'idon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na' gož Pedron' ḻe': ―Gwbat gua'a latje c̱hibo' ṉi'an'. Jesúsen' gože'ne': ―Še bi c̱hiban', bich gaco' txen len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Na' Pedron' gože'ne': ―X̱ana', gague ṉi'a na'zen' c̱hibo' še ca', san doxena'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nach gož Jesúsen' ḻe': ―Beṉe' noša' nazje', ṉi'e na'zen' chyažjen c̱hibe', ḻe doxen cuerp c̱hen' naquen xilaže'. Can' nac le'e, nac lažda'olen' xilaže', ḻa'czḻa' gague yogo'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesúsen' gwṉezde' non' gwde' ḻe' ḻo na' beṉe' chesegue'ede' ḻe'. Da'nan' gwne': “Gague yogo'le nac lažda'olen' xilaže.” ");
INSERT INTO zpqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na' cate' beyož gwdibe' ṉi'a yogüe', nach beyaze' xe' dan' chaze' cha'le na' bebi'e da' yoble cho'a mesen'. Na' gože' ḻegaque': ―¿Chejni'ile bi zejen dan' ba bena' nga len le'e? ");
INSERT INTO zpqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Le'e nsi'le neda' Maestrw na' X̱anḻe, na' güenczen' žale, ḻe can' naca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na' neda' ḻa'czḻa' naca' X̱anḻe na' Maestrw c̱hele, ba gwdiba' ṉi'alen' ca to mos, na' can' cheyaḻa' gaclen ḻježle ca to mos. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ba gwdiba' ṉi'alen' cont blo'eda' le'e cheyaḻa' gonḻe can' ba benan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chnia' le'e to da' zejen, note'teze mos bi naque' beṉe' blaoch ca x̱ane', na' to beṉe' zej mandadw bi zaca'che' ca beṉe' gwseḻa' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Še chejni'ile da' quinga na' gonḻe can' gwnian', nach soale mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Bi žia' ca' c̱he yogo'le. Nombi'a yic̱hjlaždao' to to le'e ba gwleja' cont soale txen len neda'. Na' ṉezda' gac can' ža Xtiža' Diosen' da' nyojen žan: “Beṉe' gwdagw len neda' txen ba blej bšošje' neda'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chnia' le'e da' quinga cate' za' gac ca' cont cate' ba goc ca' soac̱hac̱hle šejḻe'le ḻe naca' ben' gwseḻa' Diosen' can' ba gwnia' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chnia' le'e to da' zejen, beṉe' ca' chosolebe' note'tez beṉe' chseḻa', neda'czen' chosolebe' še ca', na' beṉe' chosolebe' neda' ḻecze chosolebe' Dios beṉe' gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Beyož gwna Jesúsen' ca' ba gwzolao chacyaše'chgüede' ḻo' yic̱hjlažda'ogüen', na' bochix̱gaten' gwne': ―Da' ḻi chnia' le'e, to le'e gwdelenda' ḻo na' beṉe' chesegue'e neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na' beṉe' ca' zjanaque' ḻe' txen con cheseṉa' cho'alao ḻježe' chesone' xbab c̱he noen' gwne' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na' toe' chi'e cuiten' dan' chaquechgüe' Jesúsen' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nach Pedron' bene' señw len bena' cont gwṉabde' Jesúsen' no c̱hen' gwne' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nach gwbigue' bago gože' Jesúsen': ―¿Non' gon ca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Na' gož Jesúsen' ḻe': ―Bena' gwnežjua' late' yetextilen' cate' ba bḻo'ojan' ḻo' nis yeḻa' guagon', ḻe'na' gon ca'. Nach bḻo'oje' late' yetextilen' ḻo' nis yeḻa' guagon' na' bnežjuen' Judas Iscariote beṉe' nac xi'iṉ to beṉe' le' Simón. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na' beyož bnežjue' Judasen' yetextilen' ḻa' gwyo'o gwyazte Satanás dan' chnabia' da' x̱igüe' ca' ḻo' yic̱hjlaždao' Judasen'. Nach Jesúsen' gože' Judasen': ―Da' ba zoa gono' benen bedao'nez. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na' ṉe to ben' zjachi' cho'a mesen' bi gosejni'ide' bixc̱hen' gože' ḻe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Baḻe' gosacde' da' nox̱e' Judasen' bols mechon' Jesúsen' gože' ḻe' šjax̱i'e da' cheseyažjde' ḻo ḻṉin' o šjanežjue' mechw da' chyažje no beṉe' yaše'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nach cate' beyož gwdagw Judasen' pedas yetextil dan' bnežjw Jesúsen' ḻe', ḻa' bchojte'. Na' ba nac ba goḻ gual. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gwde bchoj Judasen', Jesúsen' gwne': ―Diosen' gwseḻe' neda' golja' beṉac̱h na' ṉa'a ba nḻa'laon naca' beṉe' zaca' juisyw, na' neda' ḻecze ba chlo'a Diosen' naque' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na' dan' chlo'a naque' beṉe' zaca', ḻecze ḻe' gwlo'e naca' beṉe' zaca', na' ḻa' gontien' ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xi'iṉda'ogua', yešložga soa' len le'e. Na' yeyiljwle neda', na' chnia' le'e dan' goša' beṉe' gwnabia' c̱he nación Israel c̱hechon', bi gac sa'lenḻe neda' gan' yeya'an. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na' to da' cobe chžia' bia' gonḻe, gaque ḻježle tole yetole. Can' chacda' le'e, ḻecz can' cheyaḻa' gaque ḻježle tole yetole. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na' yeseṉeze yogo'ḻoḻ beṉe' nacle neda' txen še soaczle gaque ḻježle tole yetole. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na' Simón Pedron' gože' Jesúsen': ―X̱ana', ¿gan' yeyejo'? Na' gož Jesúsen' ḻe': ―Gan' yeya'an bi gac sa'leno' neda' ṉa'a, perw techle yido' ga'oguo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Na' Pedron' gože' ḻe': ―X̱ana', ¿bixc̱hen' bi gac sa'lena' le' ṉa'a? Gwzanḻaže' cuina' gata' še chonen byen cont gaclena' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Na' gož Jesúsen' ḻe': ―¿Chacdo' gwzanḻaže' cuino' gato' cont gacleno' neda'? Da' ḻi chnia' le', cate' cuež jean' ba goc šoṉ ṉi'a bi chc̱hebo' nombi'o neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Bich gacžejlaže'le. Ḻe šejnilaže' Diosen' na' ḻecze ḻe šejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Da' zan yo'o da' že' gan' zoa X̱a' Diosen'. Ba gwnia' le'e šaca' bibi latje de c̱hele, san yeya'a šjayenšagua' yo'o c̱he to tole. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na' cate' yeyož šjayenšagua' yo'o c̱hele ca', cana'ch yida' da' yoble yec̱hi'a le'e cont yedyezoale gan' šjayzoa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ṉezele gan' yeya'an' na' ba ṉezele nac gonḻe cont yežinḻe na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na' gož Tomásen' ḻe': ―X̱anto', bi ṉezeto' gan' yeyejo'. ¿Nacxe gac ṉezeto' nac gonto' yežinto' na'? ");
INSERT INTO zpqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesúsen' gože'ne': ―Neda' naca' nezen' na' nsa'a yogo' diža' ḻi, na' toz neda' chac chnežjua' beṉe' yeḻa' mban toḻi tocaṉe. Ṉe toze beṉe' bi yežine' gan' zoa X̱an' še bi šejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Še nombia'yaṉe'le neda', lente X̱an' ba nombia'le še ca'. Na' bac̱h nombia'lne' ṉa'a na' ba ble'elne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na' gož Felipen' ḻe': ―Ben cont le'eto' X̱aon', ḻezen' chṉabeto' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesúsen' gože'ne': ―Felipe, sša xen ba gwzoa' nga len le'e na' ¿biṉa' gombi'o neda'? Note'tez beṉe' ba ble'e neda' ḻencze X̱an' ba ble'ede'. ¿Bixc̱hen' chṉabo' gona' cont le'ele X̱an'? ");
INSERT INTO zpqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Bi chejḻi'o zoa' len X̱an' na' ḻe' zoe' len neda'? Diža' da' choa' len le'e bi choan' to gualaza'. X̱a' nan' zoe' len neda' na' ḻen' chone' cont choa' dižan' chaclaže' gua' na' chona' bi da' chaclaže' gona'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ḻe šejḻe' c̱hia' zoa' len X̱an' na' ḻe' zoe' len neda'. Na' še bi chejḻe'le xtižan', ḻe šejḻe' c̱hia' dan' ba ble'ele chona' yeḻa' guac. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na' chnia' to da' zejen, beṉe' ca' chesejnilaže' neda', da' ca' chonan' ḻecze ḻegaquen yesone'. Na' da' zaca'ch ca da' ca' yesone', ḻe yeya'a gan' zoa X̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na' bite'teze da' ṉabele X̱an' lagüe da' chejnilaže'le neda' naca' Xi'iṉe', gonan', cont gwlo'a nac X̱an' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bite'tez da' ṉable gona' lagüe da' chejnilaže'le neda', neda' gonan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Še chaquele neda', gonḻe can' nona' mandadw. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na' ṉabda' X̱an' cont seḻe' Spiritw c̱hen' soan len le'e toḻi tocaṉe na' gaclenen le'e. Na' Spiritw c̱he Diosen' gwzejni'in le'e da' nac da' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Na' beṉe' bi chesejnilaže' Diosen', Spiritw c̱hen' bi gac soan len ḻegaque', ḻe bi chesele'eden' na' ṉeca chesejḻe'e še zoan. San le'e nombia'len, ḻe zoan len le'e na' gwžin ža yedesoan ḻo' yic̱hjlažda'olen' ṉabian' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Bi yocua'aṉa' le'e ca bi' güezebe. Güidcza' yeto gan' zoale nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yešlož beṉe' ca' bi chesejnilaže' Diosen' bich yesele'ede' neda', perw le'e gwle'eczele neda'. Na' da' zoa' toḻi tocaṉe, da'nan' soale toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na' cate' žin ža yedesoa Spiritw c̱he Diosen' ḻo' yic̱hjlažda'olen', cana'ch gacbe'ele neda' zoa' len X̱an' na' le'e zoale len neda' na' neda' zoa' len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Beṉe' zjaṉezde' dan' nona' mandadw yesone' na' chesonen', beṉe' ca' chesacde' neda'. Na' beṉe' ca' chesacde' neda' ḻecze chaque X̱an' ḻegaque', na' neda' ḻecze soa' gacda' ḻegaque' na' gona' cont yesombia'che' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na' Judas (perw gague Judas Iscariote) gože'ne': ―X̱anto', ¿bixc̱hen' gono' cont neto' ṉezeto' zoaczo' len neto' na' bi gono' ca' len beṉe' bi chesejnilaže' Diosen'? ");
INSERT INTO zpqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na' Jesúsen' gože'ne': ―Beṉe' chesacde' neda' chosozenague' xtižan', na' X̱an' ḻecze gacde' ḻegaque' na' neda' len x̱an' yedesoato' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Beṉe' bi chesacde' neda' bi chosozenague' xtižan'. Na' diža' dan' chnian' bi cho'an to gualaza' san cho'a diža' da' ža X̱an' ben' gwseḻa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Da' quinga ba gwnia' le'e šlac ṉe' zoa' len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na' X̱an' seḻe' Spiritw c̱hen' soan ḻo' yic̱hjlaždao' le'e chejnilaže'le neda' cont gaclenen le'e. Na' Spiriton' gwzejni'in le'e yogo' da' cheyaḻa' ṉezele na' gonen cont šjayza'laže'le yogo' dan' ba gwnia' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Na' chcua'aṉa' le'e na' chona' cont soa cuezle binḻo len xbab c̱helen'. Chaclaža' soa cuezle binḻo len xbab c̱helen' can' zoa' neda'. Nono beṉac̱h gac gone' cont soa cuezle binḻo len xbab c̱helen' can' chac chona' neda'. Bi gacžejlaže'le, ṉeca žeble. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ba benele gwnia' yeya'a gan' zoa X̱an' na' yida' da' yoble gan' zoale nga. Na' ša chaquelenda' ca cheyaḻa', nach chebele dan' yeya'a gan' zoa X̱an', ḻe X̱an' zaca'che' ca neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na' ba gwnia' le'e ṉa'a bibi ṉa' gac, cont soac̱hac̱hle šejnilaže'le neda' caten' gac ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Bich gua'a diža' zan len le'e, ḻe ba za' Satanás dan' chnabia' da' x̱igüe' ca' na' dan' chnabia'te beṉe' ca' bi chesejnilaže' neda', na' tiḻlenen neda', perw bi gonen neda' gan. ");
INSERT INTO zpqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chona' con can' non X̱an' mandadw cont ṉeze beṉac̱hen' chacda' X̱an'. Ḻe šo'o ṉa'a, ba goḻe šejcho. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Neda' zaca'leba' ca to yag da' chbia uvas. Na' X̱an' zaca'lebe' ca beṉe' chonši'i yaguen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na' le'e chejnilaže'le neda' zaca'leble ca xoze' yaguen'. Na' to to xoze' yaguen' da' bibi chbian, chc̱hoguen'. Na' to to xozen' da' chbia uvasen' chpe'en cont chbiachen da' zanch. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na' le'e ba nacle ca to xozen' da' ba mpe'e, ḻe bac̱h chzenagle xtižan' dan' ba be'lena' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ḻe soac̱hac̱h len neda' cont soac̱hac̱ha' len le'e. Can' nac xoze' yaguen' bibi chac cuian to gualazen še bi nca'an ḻe'e yaguen', can' naquen len le'e, bi gacle can' chazlaže' Diosen' še bi soac̱hac̱hle len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Neda' zaca'leba' ca to yag da' chbia uvas na' le'e zaca'leble ca xozen'. Note'tezle še soac̱hac̱hle len neda' ḻecze soac̱hac̱ha' len le'e na' gacle can' chazlaže' Diosen', ca'aczen' nac c̱he yag uvazen' dan' chbiachgua, ḻe bibi gac gonḻe to gualazle. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Beṉe' bi zoac̱hac̱he' len neda', gac c̱he' can' chac len xoze' yag da' bibi chbia, ḻe chesec̱hoguen' na' chesebižen na' chžin ža chosotoben' chesadoen' yi' cont cheseyen. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Na' le'e še zoac̱hac̱hle len neda' na' zoac̱hac̱hle chzenagle xtižan', bite'tez da' chaclaže'le ṉabele Diosen', goṉczen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chacxen X̱an' cate' zoale chonchguale dan' chazlažen', na' še chonḻe ca', yesacbe'e beṉe' da' ḻi chejnilaže'le neda' na' chzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ca X̱an' chacde' neda', ḻecz ca' neda' ba chacda' le'e. Ḻe soa ḻe gon can' žia' cont gacbe'ele chacda' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Še gonḻe can' nona' mandadw, nachen' gacbe'ele chacda' le'e, ḻe neda' chona' dan' non X̱an' mandadw na' chacbe'eda' chacde' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ba gwnia' le'e ca' cont soale mbalaz ca mbalazen' zoa' neda'. Chaclaža' soale mbalaz juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na' da' nga nona' mandadw gonḻe, gaque ḻježle tole yetole can' chacda' neda' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nono zoa beṉe' chaquech ḻježe' ca beṉe' chzanḻaže' cuine' gate' ṉec̱he beṉe' migw c̱he'. Na' can' chona' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na' le'e nacle migw c̱hia' še chonḻe con can' nona' mandadw. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na' bich žia' nacle beṉe' güen žin c̱hia', ḻe to beṉe' güen žin bi ṉezde' yogo' da' chon x̱anen', san žia' nacle migw c̱hia'. Ḻe yogo'ḻoḻ da' ba benda' gwna X̱an' ba bzejni'idan' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gague le'e gwlejle neda' naca' X̱anḻe. Neda' gwleja' le'e cont chejnilaže'le neda'. Na' chseḻa' le'e cont šjenḻe can' chazlaže' X̱an', na' gague da' te c̱he da' ca' gonḻen'. Na' yogo'ḻoḻ da' ṉabele X̱an' gone' lagüe da' chejnilaže'le neda', gonczen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Da' nga da' chona' mandadw gonḻe, gaque ḻježle tole yetole. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Še beṉe' bi chesejnilaže' Diosen' chesegue'ede' le'e, ḻe gon xbab ba chesegue'eczede' neda' cate' za' yesegue'ede' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ša nacle txen len beṉe' ca' bi chesejnilaže' Diosen', nachen' yesacde' le'e can' chesaque' beṉe' ḻježen' šaca'. Perw ba gwleja' le'e cont chzenagle c̱hia'. Da'nan' chesegue'ede' le'e da' bi nacle ḻegaque' txen. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ḻe šjasa'laže' dan' gwnia' le'e: “Note'teze mos bi naque' blaoch ca x̱anen'.” Bosoc̱hi bososaca' beṉe' neda', na' ḻecz ca' yesonde' le'e. Na' baḻze beṉe' bosozenague' xtižan', ḻecze baḻze' yosozenague' xtiža'len'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na' da' bi zjanombi'e Diosen' ben' gwseḻa' neda', da'nan' yesonde' le'e yogo' da' ca', ḻe chesegue'ede' le'e da' chzenagle c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ša neda' bi bedezejni'ida' ḻegaque', bi zjanape' doḻa' da' chesegue'ede' neda' šaca'. Perw ṉa'a bibi de da' yosode'ede' yesene' bi zjanape' doḻa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Beṉe' chgue'ede' neda' lente X̱an' chgue'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ba bena' yeḻa' guac da' nono nochle ṉa' gon, na' šaca' bi besele'eden' bi zjanape' doḻa' da' chesegue'ede' neda'. Perw ba besele'ede' da' ca' na' bia'cze chesegue'ede' neda' len X̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na' chac can' nyoj Xtiža' Diosen' dan' chososede' gan' žan: “Besegue'ede' neda' ḻa'czḻa' bibi da' mal bena'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ba gwnia' le'e seḻa' Spiritw c̱he X̱a' Diosen' gaclenen le'e. Spiriton' san' gan' zoa X̱an' na' gwzejni'in le'e diža' ḻi c̱hia' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na' ḻecz ca' le'e cheyaḻa' güe'le xtižan', ḻe ba gwzoale len neda' šlac ba gwdix̱jue'eda' xtiža' X̱a' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ba gwnia' le'e yogo' da' ca' cont bi gacžejlaže'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ḻe yesyebeje' le'e ḻo' yodao' c̱hegaque' ca', na' gwžin ža cate' note'tez beṉe' yesote' le'e yesacde' chebe Diosen' dan' chesonen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yesonde' le'e yogo' da' ca' ḻe bi zjanombi'e X̱an' ṉeca neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Žia le'e da' quinga cont cate' žin ža gac can' gwnian' nach šjaze'ele. ’Bi gwnia' le'e yogo' da' ca' gac c̱hele cate' za' gwzolao bzejni'ida' le'e xtiža' Diosen', ḻe ṉe' zoacza' chaclena' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","San ṉa'a yeya'a gan' zoa X̱an' ben' gwseḻa' neda', na' ṉe tole bi chṉabele neda' gan' yeya'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na' ba chacyaše'le dan' ba gwnia' yeya'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Perw da' ḻi napen le'e cuent yeya'a, ḻe še bi yeya'a, Spiritw c̱he X̱a' Diosen' dan' gaclenen le'e bi yedesoan ḻo' yic̱hjlažda'olen'. Na' yeya'a nach seḻan' len le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na' cate' yid Spiriton' gwzejni'in beṉac̱hen' zjanape' doḻa', na' gwzejni'in non' nac beṉe' güen len Diosen', na' gwzejni'in gata' castigw toḻi tocaṉe c̱he beṉe' bi chosozenague' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Spiriton' gwzejni'in ḻegaque' zjanape' doḻa' da' bi chesejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na' gwzejni'in ḻegaque' non' nac beṉe' güen len Diosen', ḻe yeya'a gan' zoa X̱a' Diosen' na' le'e bich le'ele neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na' gwzejni'in ḻegaque' gata' castigw c̱he xtoḻa'gaquen' toḻi tocaṉe, ḻe Satanás dan' chnabia' da' x̱igüe' ca' na' dan' chnabia'te beṉe' ca' bi chesejnilaže' Diosen' ba nchoglaon c̱hen gwnežjw Diosen' castigw c̱hen toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ṉe' dech da' zan da' ṉia' le'e, perw naquen zdebe šejni'ilen ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","San cate' yedesoa Spiritw c̱he Diosen' ḻo' lažda'olen' cont gwzejni'in le'e da' nac da' ḻi, ḻen gwsed gwlo'en le'e yogo' da' cheyaḻa' ṉezele c̱hia', ḻe Spiriton' chṉen diža' ḻi. Bi güe'en diža' to gualazen, san güe'en bite'tez diža' da' chzene X̱an' ḻen, na' c̱hix̱jue'en le'e bica' da' za' za'ac. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Spiriton' gonen cont gwlo'elaon naca' beṉe' zaca' juisyw, ḻe gwzejni'in le'e xtiža'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","X̱an' ba bene' cont ṉezda' yogo' da' ṉeze ḻe', na' da'nan' gwnia' Spiriton' c̱hix̱jue'en le'e xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Šlož bi le'ele neda', na' te yešlož na' yezle'ele neda' da' yoble, ḻe yeya'a gan' zoa X̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na' baḻe beṉe' ca' zjanaque' Jesúsen' txen gose' ḻježe': ―¿Bi zejen dan' che'e chio' te yešlož na' bich le'echone' na' techle ḻecze yešlož na' yezle'echone' da' yoble? Na' ¿bi zejen dan' že' yeyeje' gan' zoa X̱en'? ");
INSERT INTO zpqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Bi zejen dan' že' yešlož? Bi chejni'icho bin' že'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesúsen' gocbe'ede' chesaclaže' yeseṉabde'ne' bi zejen, na' gože' ḻegaque': ―¿Ba chṉabe ḻježle bi zejen dan' gwnia': “Yešlož na' bich le'ele neda' na' techle ḻecze yešlož na' yezle'ele neda' da' yoble”? ");
INSERT INTO zpqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Da' ḻi chnia' le'e ba zoa cuežle na' yegüine'le šlac beṉe' ca' bi chesejnilaže' Diosen' yesyebede'. Yeyaše'laže'le, perw šložzen' na' techle yebele. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cate' chzan no'olen' chžaglagüe' šlac chaque' bes c̱he yeḻa' sanṉa'. Na' cate' ba golje bda'ona' bich chone' xbab c̱he dan' bžaglagüen', ḻe chbede' ba golje yeto beṉac̱h yežlio nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ḻecze ca' le'e ba chacyaše'le ṉa'a, perw cate' yežagcho da' yoble soachle mbalaz na' nono gac yeca'a yeḻa' chebe c̱helen' ḻo' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Na' cate' ba bžin ža šjayzoa' da' yoble gan' zoa X̱an', cana'ch bich yažjele bi ṉable gwzejni'ida' le'e. Da' ḻi chnia' le'e, da' chejnilaže'le neda' bite'tez da' ṉabele X̱an', goṉczen' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ža ṉa'aža bibi ṉa' ṉabele X̱an' ye'lne' chṉablen da' chejnilaže'le neda'. Na' ṉa'a ḻe ṉabe X̱an' bi da' ṉabelene' ye'lne' ca', na' gone' can' ṉabelenen' cont soale mbalaz juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Da' zan ba gwnia' le'e len jempl. Gwžin ža cate' bich gwzejni'ida' le'e len jempl, san gua'a diža' da' šejni'ile cate' gwzejni'ida' le'e c̱he X̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na' cate' ba bžin žana', cana'ch ṉabele X̱an' bi da' ṉabelene' ye'lne' chṉablen da' chejnilaže'le neda'. Na' bi yažjen ṉabda' X̱an' gaclene' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ḻe cuincze X̱an' chacde' le'e dan' chaquele neda' na' chejḻe'le gwseḻe' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gan' zoa X̱a' Diosen' gwza'a na' ba bida' yežlio nga. Na' ṉa'a yeza' yežlio nga na' yeya'a gan' zoa X̱an'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nach gose'ene': ―Bac̱h cho'o diža' da' chejni'ito' na' bi cho'o jemplw. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ba chacbe'eto' nombi'o yogo' xbab c̱he beṉac̱hen'. Ba ṉezledo' bi chesaclaže' beṉe' yeseṉezde' cate' biṉa' yeseṉaben'. Da'nan' bac̱h chejḻe'to' zao' gan' zoa Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na' gož Jesúsen' ḻegaque': ―¿Ba chejḻe'le ṉa'a? ");
INSERT INTO zpqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ba bžin ža na' ṉa'a ba goḻe' gaslasle. To tole ca'a xṉez c̱he c̱hele na' gwcua'aṉle toza'. Perw bi zoa' toza', ḻe zoa X̱an' len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ba gwnia' le'e ca' cont soa cuezle binḻo len xbab c̱hele, ḻe chejnilaže'lenda'. Yežlio nga saca'zi'le, perw bi gacžejlaže'le, neda' ba bena' cont yenit yeḻa' chnabia' c̱he gwxiyen' dan' zoa ṉa'a chnabian' yežlio nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Beyož gwna Jesúsen' da' ca' nach gwṉe'e yabale na' gwne': ―X̱a', ba bžin hor gac c̱hia' dan' ba bžio' bia' gac. Ben cont nacbia' nedan' Xi'iṉo' naca' beṉe' zaca' juisyw cont neda' gona' ga gacbia' le' naco' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ba beṉo' neda' yeḻa' chnabia' lao yogo' beṉac̱h cont chnežjua' yeḻa' mban toḻi tocaṉe c̱he yogo' beṉe' ca' ba gwlejo' chesejnilaže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na' beṉe' ca' zjanape' yeḻa' mban toḻi tocaṉe zjanombi'e le', ḻe tozon' zaco' gonxento', na' ḻecze zjanombi'e neda' Jesucristw beṉe' gwseḻo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ḻo yežlion' ba bena' cont nacbia' naco' beṉe' zaca' juisyw, ḻe ba beyož bena' yogo'ḻoḻ da' gwlo'o ḻo na' gona'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na' ṉa'a X̱a', ben cont la'laon naca' beṉe' zaca' juisyw cate' yela'a gan' zon', doxen can' blo'elaon cate' gwzoa' len le' cate' za' x̱ete yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ba gwlejo' baḻ beṉac̱h chesejnilaže' neda', na' bac̱h blo'eda' ḻegaque' can' naco' na' can' chonon'. Zjanaque' xi'iṉo' na' beno' cont chesejnilaže' neda' na' chesone' can' žon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na' ba zjaṉezde' yogoḻoḻ da' chona' na' yogo' diža' da' choa' zjanaquen c̱hio' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ḻe ba be'lena' ḻegaque' diža' dan' ba bzejni'ido' neda' na' ba bosozenague' c̱hen, na' ba chesacbe'ede' da' ḻi gwza'a gan' zon', na' chesejḻe'e ḻe len' gwseḻo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Chṉaba' gacleno' ḻegaque'. Bi chṉaba' gacleno' yogo' beṉac̱h, san gacleno' beṉe' ca' gwlejo' chesejnilaže'nda' ḻe ba zjanaque' ḻo nao'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na' yogo' beṉe' chesejnilaže' neda' ḻecze chesejnilaže' le'. Na' ca'cze naquen, note'tez beṉe' zjanaque' xi'iṉo' ḻecz zjanaque' xi'iṉa', na' beṉe' ca' chesejnilaže'nda' chosolo'e naca' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Na' ṉa'a bich soa' yežlio nga, perw beṉe' quinga chesejnilaže' neda' ṉita'cze' yežlio nga, na' neda' ba zeza' gan' zo'na'. X̱a', naco' ḻa'zelagüe beṉe' laždao' xilaže', na' chṉaba' gwc̱hino' yeḻa' chnabia' c̱hio' cont gwcuas gwcuižo' da' malen' len ḻegaque' cont ṉita'cze' yesaque' toze len ḻježgaque', ca chio' naccho toze. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Šlac ba gwzoa len ḻegaque', neda' ba bc̱hina' yeḻa' chnabia' c̱hion' cont bcuas bcuiža' da' malen' len ḻegaque'. Da'nan' ṉe toe' bi gwžiayi', con toz ben' ba naquen cuiaye'e cont gac doxen can' ža Xtižo' dan' nyojen. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Na' ṉa'a ba zeza' gan' zon', na' šlac ṉe' zoa' yežlio nga cho'a diža' quinga cont beṉe' qui ṉita'chgüe' mbalaz ca mbalazen' zoa' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Neda' ba be'lena' ḻegaque' xtižon', na' beṉe' ca' bi chesejnilaže' le' chesegue'ede' ḻegaque' dan' bi chesone' txen len ḻegaque', ca' neda' bi naca' txen len beṉe' ca' bi chesejnilaže' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na' ca nac beṉe' ca' chesejnilaže' neda', bi chṉaba' yeca'o ḻegaque' ḻo' yežlio nga, san chṉaba' gacleno'ne' cont Satanás dan' chnabia' da' x̱igüe' ca' bi siye'en ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ḻegaque' bi zjanaque' txen len beṉe' bi chesejnilaže' le', ca neda' bi naca' txen len beṉe' bi chesejnilaže' le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ben cont beṉe' ca' chesejnilaže' neda' yesaclaže' yesone' con da' žo', ḻe ba zjanombi'e diža' ḻi c̱hio'. Yogo' da' ba bzejni'ido' ḻegaque' naquen da' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Len' gwseḻo' neda' yežlion' cont ba bia' xtižon', na' ḻecze ca' chseḻa' ḻegaque' yeso'e xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chzanḻaže' cuina' chona' con da' žo' le' cont yesaclaže' yesone' con can' žo' da' zjanombi'e diža' ḻi c̱hion'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Na' bi chṉaba' gacleno' ḻegacze', san ḻecze gacleno' beṉe' ca' yesejnilaže' neda' cate' yesende' diža' dan' yesoe' beṉe' quinga. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","X̱a', ben cont yogo'ḻoḻe' yesaque' toze len ḻježgaque' na' yesaque' txen len chio', ca le' naco' toze len neda' na' neda' naca' toze len le'. Ben cont yeyož yesaque' toze len chio' na' len ḻježgaque' cont beṉe' ca' bi chesejnilaže' le' yesacbe'ede' len' gwseḻo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na' yeḻa' bala'aṉ dan' noṉo' neda' ba bnežjuan' ḻegaque' cont zjanaque' toze len beṉe' ḻježe' ca chio' naccho toze. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ḻegaque' zjanaque' txen len neda' na' neda' naca' txen len le' cont yogo'cho gaccho toze. Gaccho toze cont beṉe' ca' bi chesejnilaže' le' yesacbe'ede' len' gwseḻo' neda' na' yesacbe'ede' chacdo' beṉe' ca' can' chacdo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’X̱a', chacdo' neda' cate' biṉa' x̱e yežlio nga na' nono' neda' beṉe' zaca' juisyw. Na' chaclaža' beṉe' quinga gwlejo' chesejnilaže' neda' yedyesenite' len neda' gan' yedyesoan' cont yesele'ede' naca' beṉe' zaca' juisyw. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","X̱a', naco' ḻa'zelagüe beṉe' chon da' zej to ḻicha. Na' ca nac beṉe' ca' bi chesejnilaže'nda', ḻecze bi zjanombi'e le', perw neda' nombi'a le', na' beṉe' ca' ba gwlejo' cont chesejnilaže' neda' zjaṉezde' len' gwseḻo' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na' ba bzejni'ida' ḻegaque' can' nacon' na' can' chonon', na' za' gwzejni'ichda' ḻegaque', cont yesacbe'ede' chacdo' ḻegaque' can' chacdo' neda', na' cont neda' soacza' len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Beyož gwna Jesúsen' da' ca', gwza'lene' beṉe' ca' zjanaque' ḻe' txen ja'aque' šḻa'a Yegw Cedrón gan' gota' to le'ej ga goseze zan yag olivos. Na' goso'e ḻo' le'ejen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na' Judasen' ben' ba naquen gone' Jesúsen' ḻo na' beṉe' ca' chesegue'ede' ḻe' ḻecze nombi'e latjen', ḻe zan ṉi'a Jesúsen' len beṉe' ca' zjanaque' ḻe' txen ba besedobe' na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ca' goquen' bžin Judasen' na' nc̱he'e x̱oṉj soldadw na' yex̱oṉj beṉe' chesape' yodao' blaon' beṉe' goseseḻa' bx̱oz gwnabia' ca' na' beṉe' fariseo ca' cont yesezene' Jesúsen'. Zjanxobe' no lintern na' zjanox̱e' no yi' yech na' zjanaḻe' spada. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesúsen' ba ṉezde' yogo'ḻoḻ da' za' gac c̱he', na' bchoje' jašague' ḻegaque' na' gwne': ―¿Non' cheyiljwle? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na' gose'ene': ―Cheyiljwto' Jesús beṉe' Nazaret. Na' gož Jesúsen' ḻegaque': ―Nedan'. Na' Judasen' ben' ba naquen gone' Jesúsen' ḻo na'gaquen' zelene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cate' Jesúsen' gože' ḻegaque': “Nedan”, ḻa' besyebiga'te' cosxanḻe na' jasechaze' ḻo yon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na' da' yoble Jesúsen' gože' ḻegaque': ―¿Non' cheyiljwle? Na' ḻegaque' gose'ene': ―Cheyiljwto' Jesús beṉe' Nazaret. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na' Jesúsen' gwne': ―Ba gwnia' nedan'. Na' še nedan' cheyiljwle, ḻe güe' latje šjaya'ac beṉe' quinga. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Gwne' ca' cont goc can' ba gwdix̱jue'ede' caten' gwne': “Ṉe to beṉe' ca' ba gwlej Diosen' chesejnilaže' neda' bi yesebiaye'e.” ");
INSERT INTO zpqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na' Simón Pedron' no'e to spada na' goḻjen' gwdinen' mos c̱he bx̱oz blaon' gwc̱hogtechgüe' nague' ḻicha. Na' mosen' le' Malco. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Na' Jesúsen' gože' Pedron': ―Bego'o spada c̱hion' ḻo' ližen'. ¿Chacdo' bi cheyaḻa' gac da' ba nžia bia' X̱a' Diosen' gac c̱hia'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nach soldadw ca' len x̱angaque' na' len beṉe' chesape' yodao' blao c̱he nación Israel c̱heton' gosezene' Jesúsen' na' bosoc̱heje'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na' gosec̱he'ene' da' nechw lao Anás ben' naque' xta'obi'iṉ c̱he Caifás. Na' Caifásen' goque' bx̱oz blao c̱he nación Israel c̱heton' ḻo izen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na' Caifásna' ben' gože' beṉe' gwnabia' c̱heton' napen ḻegaque' cuent toz ben' gat clel ca cuiayi' yogüe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedron' len yeto beṉe' naque' Jesúsen' txen gosa'ogüe'ne'. Na' nombia' ben' nac bx̱oz blao ben' yeto. Da'nan' goc gwyo'e len Jesúsen' chyo'o c̱he bx̱oz blaon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na' Pedron' bega'aṉe' do cho'a puerten'. Nach ben' yeto, da' nombia' bx̱oz blaon' ḻe', gwyeje' na' be'lene' diža' bi' no'olen' chap cho'a puerten' cont gwlo'obe' Pedron'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nach bi' no'olen' chape cho'a puerten' gožbe' Pedron': ―¿Gague leno' le' chzenago' dan' chsed chlo'e benga? Na' Pedron' gwne': ―Bi lena' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Beṉe' güen žin ca' na' beṉe' ca' chesape' yodao' blaon' ba gosebeque' to yi' ya'alj, ḻe chac zag, na' zjazeche' cho'a yin' cont chesyeže'ede'. Na' Pedron' ze' len ḻegaque' cho'a yin' cheže'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na' ben' nac bx̱oz blaon' gwṉabde' Jesúsen' c̱he beṉe' ca' chosozenag c̱he dan' chsed chlo'eden' na' c̱he da' ca' chzejni'iden'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Na' Jesúsen' gože'ne': ―Ba bi'a diža' doxen latje lagüe. Zan ṉi'a bsed blo'eda' ḻo' yodao' c̱hecho ca' na' chyo'o yodao' blaon' gan' chesežag yogo' beṉe' gualaž c̱hechon'. Bibi diža' gwnia' bagaše'ze. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bixc̱hen' chṉabdo' neda'? Gwṉabe beṉe' ca' gosende' dan' bsed blo'edan'. Ḻegaque' zjaṉezde' bi dižan' bia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Beyož gwna Jesúsen' ca', to ben' chape yodao' blaon' zie' na', na' gwdape' x̱aguen', gože'ne': ―¿Ca' choži'o xtiža' ben' nac bx̱oz blaon'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesúsen' gwne': ―Še bi da' mal ba gwnia', be' diža' c̱he bi da' malen' ba gwnia', na' še gwnia' güen, ¿bixc̱hen' chgapo' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nach Anásen' bdie' Jesúsen' ncheje' lao Caifásen' ben' nac bx̱oz blaon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na' Pedron' zie' cho'a yin' cont cheže'ede' na' beṉe' ca' nita'na' gose'ene': ―¿Gague lenczo' len' chzenago' dan' chsed chlo'e benga? Na' bi gwc̱hebe', gwne': ―Bi lena' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","To xmos bx̱oz blaon' naque' biše' ḻjež ben' gwc̱hog Pedron' naguen', na' ḻe' gože' Pedron': ―¿Gague ble'eda' le' len Jesúsen' ḻo' le'ej gan' ze yag olivos? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na' Pedron' da' yoble bi gwc̱hebe', na' ḻa' gwchežte to jea. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na' do cheni'las beṉe' gwnabia' ca' gosebeje' Jesúsen' gan' zoa Caifásen' na' gosec̱he'ene' gan' zoa gobernador Pilato ben' chon yeḻa' justis. Na' ḻegaque' bi goso'e len Jesúsen' yo'o gan' zoa Pilaton', ḻe can' nac costumbr c̱heton' bi chac yesagüe' xše' ḻṉi pascon' še yeso'e gan' že' beṉe' bi zjanac beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Da'nan' Pilaton' bchoje' na' gože' ḻegaque': ―¿Bi ben benga? ¿Bi xya chagwle c̱he'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na' beṉe' gwnabia' ca' gosene': ―Šaca' benga bi naque' beṉe' güen da' xiṉj bi bdeto'ne' ḻo naon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Na' gož Pilaton' ḻegaque': ―Ḻe yec̱he'e, na' ḻe gon yeḻa' justis c̱he' can' ža ley c̱helen'. Nach beṉe' gwnabia' c̱he nación Israel c̱heton' gose'ene': ―Bi de ḻsens gotto' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Da' gosone' ca' goc can' gwna Jesúsen' caten' bzejni'ide' nac yesone' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nach Pilaton' beyo'e yo'ona' na' goxe' Jesúsen' na' gože'ne': ―¿Naco' le' Rey c̱he beṉe' Israel ca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesúsen' gože'ne': ―¿Con da' goljlažon' chṉabo', še beṉe' yoble gose'e le' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaton' gože'ne': ―¿Chacdo' naca' neda' beṉe' Israel? Beṉe' Israel gualaž c̱hio' na' bx̱oz gwnabia' c̱hele ca' bosodie' le' ḻo na' nga. ¿Bi da' xiṉj benon'? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesúsen' gože'ne': ―Yeḻa' chnabia' c̱hia' nža'le naquen len yeḻa' chnabia' c̱he beṉe' chesenabi'e yežlio nga. Šaca' yeḻa' chnabia' c̱hia' naquen c̱he yežlio nga na' šaca' ṉabi'a nación ca' že' yežlio nga, beṉe' ca' chosozenag c̱hian' gosediḻe' cont bi goca' ḻo na' beṉe' gwnabia' c̱he nación Israel c̱heton' šaca'. Perw yeḻa' chnabia' c̱hian' bi naquen c̱he yežlio nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nach Pilaton' gože'ne': ―¿Na' len' naco' rey še ca'? Na' gwna Jesúsen': ―Da' ḻi can' žon', naca' rey na' ba bida' yežlio nga cont gwzejni'ida' beṉac̱hen' diža' ḻi na' yogo' beṉe' chesone' txen len diža' ḻi chosozenague' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nach gož Pilaton' le': ―¿Bi dan' diža' ḻi? Beyož gwna Pilaton' ca' na' bezchoje' yeto ši'i gan' že' beṉe' gwnabia' c̱he nación Israel c̱heton' na' gože' ḻegaque': ―Bibi nḻa'lagüe še bi da' xiṉj non benga. ");
INSERT INTO zpqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Perw na' de costumbr c̱hele gwsana' to beṉe' de ḻižya ḻo ḻṉi pascon'. ¿Chaclaže'le gwsana' benga naque' Rey c̱he le'e beṉe' Israel? ");
INSERT INTO zpqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nach bososye'e gosene': ―Bi gwsano' bena'. Barrabás na' gwsano'. Na' Barrabásen' naque' to beṉe' gwban. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nach Pilaton' bene' mandadw goseyine' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na' soldadw ca' gosone' to corona de xis yeše' na' bosozoen' yic̱hj Jesúsen' na' bosoguacue'ne' to lache' moradw ca da' chosoc̱hin no rey. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nach gosonḻe' c̱he', gosene': ―¡Viva Rey c̱he beṉe' Israel! Na' gosegapa'chgüe' x̱ague'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nach Pilaton' bchoje' da' yoble na' gože' beṉe' gualaž c̱heto' ca' že' na': ―Cueja'ne' da' yoble cont ṉezele bibi da' xiṉj chželda' še bi da' none'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na' bechoj Jesúsen' chyo'ona', na' zoa corona de xis yešen' yic̱hje' na' ṉe' nyaze' lache' moradon'. Na' Pilaton' gože' ḻegaque': ―Ḻe ṉa', nga ze ben'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na' bx̱oz gwnabia' ca' na' beṉe' chesape' yodao' blaon' cate' besele'ede' Jesúsen' na' bososye'e zan ṉi'a gosene': ―¡Bde'e ḻe'e yag cruz! ¡Bde'e ḻe'e yag cruz! Nach Pilaton' gože' ḻegaque': ―Le'e ḻe c̱he'e na' ḻe gwde'e ḻe'e yag cruzen', ḻe neda' bibi da' xiṉj cheželda' še bin' none'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na' beṉe' gwnabia' ca' c̱he nación Israel c̱heton' gose'e ḻe': ―De to ley c̱heto' da' žan cheyaḻa' gate' da' že' naque' Xi'iṉ Dios, ḻe con to beṉac̱hzen' naque'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ba chžeb Pilaton' can' ba chaquen', na' cate' bende' xtiža'gaquen' bžebche'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Na' beyo'e yo'o gan' zoe' da' yoble, nc̱he'e Jesúsen', na' gože' Jesúsen': ―¿Ga beṉe' le'? Na' Jesúsen' bi boži'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nach Pilaton' gože'ne': ―¿Bi choži'o xtižan'? ¿Bi ṉezdo' napa' yeḻa' chnabia' cont gwsana' le' na' napa' yeḻa' chnabia' cont c̱hogbi'an yosode'e le' ḻe'e yag cruz? ");
INSERT INTO zpqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesúsen' gože'ne': ―Bibi yeḻa' gwnabia' napo' šaca' Diosen' bi noṉen' le'. Da'nan' beṉe' bdie' neda' ḻo naon' napche' doḻa' ca le'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nach Pilaton' beyiljwlaže' nacle gone' gwsane' Jesúsen'. Perw beṉe' gwnabia' c̱he nación c̱heton' bososye'e gosene': ―Še gwsano' benga, contr rey c̱he nación Roman' chono' še ca', ḻe note'tez beṉe' že' naque' rey chone' contr rey César. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nach Pilaton', beyož bende' xtiža'gaquen', gwleje' Jesúsen' chyo'ona' na' ḻecze bchoj ḻe' na' gwchi'e gan' chone' yeḻa' justisen', to latje da' nzi' Gan' Nagw Yej, na' diža' hebreo nzin' Gabata. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Do guagwbiž ža cate' za' solao ḻṉi pascon' Pilaton' gože' beṉe' gwnabia' c̱heto' ca': ―Ḻe ṉa', nga zoa rey c̱helen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nach da' yoble gosezolagüe' bososye'e gosene': ―¡Cheyaḻa' gate'! ¡Bde'e ḻe'e yag cruz! Nach Pilaton' gože' ḻegaque': ―¿Rey c̱hele nga gona' mandadw yosode'e ḻe'e yag cruz? Nach bx̱oz gwnabia' ca' gose'ene': ―Gague rey c̱heto' benga. Toze César naque' rey c̱heto'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nach Pilaton' bdie' Jesúsen' ḻo na'gaque' cont te'e ḻe'e yag cruzen'. Nach gosa'aque' Jerusalénṉa' gosec̱he'e Jesúsen' cho'a ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na' Jesúsen' zeje' no'e yag cruz c̱hen' na' besežine' to latje nzi' Latje c̱he Žit Yic̱hj Beṉe' Guat, na' diža' hebreo nzin' Gólgota. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na' soldadw c̱he gobernadoren' bosode'ene' ḻe'e yag cruzen', na' ḻecze bosode'e yec̱hope beṉe' ḻe'e yec̱hope yag cruz cuiten' na' Jesúsen' gwyo'e gachoḻ beṉe' ca' c̱hope'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na' gobernador Pilaton' bene' mandadw byoj diža' da' gwda' yic̱hj yag cruz c̱he Jesúsen'. Na' bosozojen' žan: “Jesús beṉe' Nazaret, Rey c̱he beṉe' Israel”. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bosozojen' diža' hebreo, diža' griego na' diža' latín. Na' zan beṉe' Israel gualaž c̱heto' bosolaben', ḻe gan' gwda' Jesúsen' ḻe'e yag cruzen' naquen gaḻa'ze ciuda Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nach bx̱oz gwnabia' ca' na' yezica'chle beṉe' gwnabia' c̱he nación Israel c̱heton' gose'e Pilaton': ―Bi gwzojo' “Rey c̱he beṉe' Israel”, san bzoj: “Ḻe' gwne' naque' rey c̱he beṉe' Israel.” ");
INSERT INTO zpqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na' Pilaton' gwne': ―Da' bena' mandadw bosozoje', ba nyojenṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nach soldadw ca', beyož bosode'e Jesúsen' ḻe'e yag cruzen', goseque'e xaḻana' Jesúsen' na' besyeḻe'en gosebejen' tap cuenḻe na' tgüejen gosezi' to toe'. Na' ḻecze goseque'e yeto xe' da' naquen to güeḻize, na' bibi dia c̱hen de. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na' gose' ḻježe': ―Bi gwzoxjchon san gonchon rifa cont ṉezecho no yecheḻen. Na' dan' gosone' ca' goc can' nyoj Xtiža' Diosen', žan: “Besyeḻe'e xaḻanan' ḻegacze', na' gosone' rifa lache' dan' chazan'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na' do gaḻa'ze yag cruz c̱he Jesúsen' zecha Marían' ben' nac xṉa' Jesúsen' na' beṉe' bile xṉe'ena', na' María beṉe' naque' no'ol c̱he Cleofas na' María beṉe' naque' beṉe' Magdala. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na' cate' Jesúsen' ble'ede' zecha xṉe'en gaḻa'ze len to beṉe' naque' ḻe' txen, beṉe' chaquechgüe Jesúsen' ḻe', nach gože'ne': ―Bena' gaque' ca xi'iṉo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nach gože' bena': ―Bži'ilaže' xṉa' nga ca xṉao'. Na' žana' gwque'ene' bene'ne' ca beṉe' ḻo' yo'o. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gwde na' Jesúsen' ba ṉezde' bac̱h goc yogo' da' cheyaḻa' gac. Nach cont goc can' ža yelate' Xtiža' Diosen' da' nyojen gwne': ―Chbiḻda' nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na' de late' vino zic̱hj da' yože' to ḻo' xguag dao'. Na' to beṉe' bzaže'de' vino zic̱hjen' to esponja bzoen' to ḻo' xis da' že' hisopo na' gwḻisen' blapen' cho'a Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na' beyož gwxop Jesúsen' vinon' na' gwne': ―Bac̱h goc yogo'ḻoḻ da' cheyaḻa' gac. Nach bc̱heque' yic̱hjen' gote'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na' yeteyo gaquen ža c̱he Dios na' ža ḻṉi xen, da'nan' beṉe' gwnabia' c̱he nación c̱heton' jaseṉabde' Pilaton' gone' mandadw yeseyišjw soldadw c̱he' ca' ṉi'a beṉe' ca' zjada' ḻe'e yag cruzen' cont yob yesate' na' yesyeque'e ḻegaque' ḻe'e yag cruz ca', ḻe bi gosaclaže' yeseda'ch beṉe' ca' ḻe'e yag cruzen' ža c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nach soldadw ca' ja'aque' jasedišjue' chope ḻa'a ṉi'a ben' gwda' šḻa'a cuit Jesúsen'. Na' ḻecze ca' gosone' len ben' gwda' ḻe'e yag cruzen' cuiten' yešḻa'a. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na' cate' besežine' gan' da' Jesúsen', besele'ede' ba gote' na' bich goseyišjue' ṉi'e ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Perw to soldadon' godoe' lanza cuit ḻe'e Jesúsen', na' ḻa' bchojten chen len nis. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Neda' ble'eda' can' goquen' na' ṉezda' cho'a diža' ḻi. Na' cho'a diža' ḻi can' goquen' cont lencze le'e šejḻe'le. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na' goc da' ca' len Jesúsen' cont goc can' ža Xtiža' Diosen' da' nyoj c̱he', žan: “Ṉe to žit yo'e bi yeseyišjue'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na' yeto da' žan: “Yeseṉe'e ben' ba bosožie' güe'.” ");
INSERT INTO zpqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Beyož goc yogo' da' ca', José beṉe' nac beṉe' ciuda Arimatea jaṉabde' Pilaton' gwnežjue' ḻsens yeque'e cuerp c̱he Jesúsen'. Na' Pilaton' be'e ḻsens. Nach Josén' gwyeje' na' beque'e cuerp c̱he Jesúsen'. Josén' ba chejnilaže' Jesúsen' perw chejnilaže'ne' bagaše'ze da' chžebe' beṉe' gwnabia' c̱heto' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na' len Josén' ḻecze gwyej Nicodemo ben' ba gwyej gan' zoa Jesúsen' šeže'le. Na' Nicodemon' no'e to da' chḻa' zix̱ da' none' len yal dan' že' mirra, na' len to bište dan' že' aloes, ca do šoṉa roben'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nach bosyoc̱hele' cuerp c̱he Jesúsen' to lache' xen na' len dan' chḻa' zix̱en', ca' chon neto' beṉe' Israel cate' chcuaše'to' beṉe' guat. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na' gaḻa'ze latje gan' bosode'e Jesúsen' ḻe'e yag cruzen' gota' to le'ej ga goseze yag. Na' na' za' gosec̱he'ene' to bloj cont yosoc̱hinen' ca to ba, na' nono beṉe' guat ṉa' šo' ḻo'enṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ža caten' got Jesúsen' naquen ža caten' chososiṉi'e c̱he ža c̱he Diosen'. Na' da' chesacbyende' yosocuaše'ne', da'nan' jaseḻo'e Jesúsen' ḻo' bloj coba', ḻe naquen gaḻa'ze. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na' bal dmigw María beṉe' Magdalan' gwyeje' cho'a blojen' gan' bosocuaše' Jesúsen' na' ble'ede' ba bga'a yejen' dan' bosode'e cho'a blojen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nach beza'sese' beyeje' gan' zoa Simón Pedron' len yeto beṉe' naque' Jesúsen' txen, na' gože' ḻegaque': ―Ba besyebeje' X̱anchon' ḻo' blojen' na' bi ṉezeto' ga besyeyo'ene'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nach Pedron' na' ben' yeto gosa'aque' ja'aque' cho'a blojen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Choptie' goseza'sese' perw ben' yeto gwza'sesche' ca Simón Pedron' na' byobech bžine' cho'enṉa' ca ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na' bcheque' gwṉe'e ḻo'enṉa' na' ble'ede' lache' ca' zjachin' ḻo yo perw bi gwyo'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ḻa' bla'te Simón Pedron' na' ḻe' gwyo'e ḻo' blojen' na' ḻecze ble'ede' lache' ca' gan' zjachin'ṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na' bay dan' bosoguazje' yic̱hjen' bi chin' gan' chi' lache' ca', san ndoben chin' šḻa'ale. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nach lencze ben' yeto gwyo'e, ḻe biṉa' šo'e ḻa'czḻa' byobech bžine' cho'enṉa', na' ble'ede' can' naquen na' gwyejḻe'e. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ḻe biṉa' yesejni'ide' Xtiža' Diosen' da' nyojen žan cheyaḻa' yebane' ladjo beṉe' guaten'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na' besyeya'aque' jaya'aque' yo'o gan' nite'na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na' Marían' bega'aṉe' na' gwzeche' gaḻa'ze cho'a blojen' chbeže'. Na' ṉe' chbežte' ca' bcheque' gwṉe'e ḻo' blojen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na' ble'ede' c̱hope angl beṉe' zjanyaz lache' šiš zjachi'e ḻo' blojen', toe' chi' zej yic̱hjle na' yetoe' chi' zej xṉi'ale gan' gota' cuerp c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nach gose'e no'olen': ―¿Bixc̱hen' chbežo' no'ole? Na' boži'en gože' ḻegaque': ―Ba besyeyo'e X̱anan' na' bi ṉezda' gale jasesane'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Beyož gwna' Marían' ca' gwyec̱hje' ble'ede' zecha Jesúsen' cožen', perw bi gocbe'ede' še naque' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Na' gož Jesúsen' ḻe': ―¿Bixc̱hen' chbežo', no'ole? ¿Non' cheyiljo'? Marían' bene' xbab še ben' chape' yaguen' nach boḻ güiže' ḻe', gože'ne': ―Beṉe', še len' beyo'one' ga yoble, gwna neda' gale jaysano'ne' cont yeyoa'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesúsen' gože'ne': ―¡María! Na' Marían' gwyec̱hje' da' yoble na' gože'ne': ―¡Raboni! ―naquen to diža' hebreo na' zejen Maestrw. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesúsen' gože'ne': ―Bi gox̱o' neda', ḻe biṉa' yeyepa' gan' zoa X̱an'. Beyej len yezica'chle beṉe' ca' ba bosozenag xtižan' beṉe' ca' zjanaque' ca biše' zana', na' gožgaque' yeyepa' gan' zoa X̱an' ben' ḻecz naque X̱ale. Naque' Dios ben' chonxena' na' ḻecze naque' Dios ben' chonxenḻe. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nach beza' María beṉe' Magdalan' na' jaydix̱jue'ede' yezica'chle beṉe' ca' chosozenag xtiža' Jesúsen' ḻe ba ble'ede' X̱anchon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na' cate' ba goc c̱hoḻ že' dmigon', beṉe' ca' zjanaque' Jesúsen' txen zjandop zjanžague' ḻo' yo'o na' zjanseyjwtie' puert ca' da' besežebe' beṉe' gwnabia' c̱he nación Israel c̱heton'. Nach Jesúsen' ble'e na' gwze' gachoḻ ḻegaque'. Na' gože' ḻegaque': ―Ḻe soa binḻo len xbab da' yo'o ḻo' yic̱hjlažda'ole. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Beyož gwne' ca' na' blo'ede' ḻegaque' taque' ca' na' cuit ḻe'ena'. Na' besyebede' cate' besele'ede' ḻe naque' X̱anchon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Na' gozne' da' yoble: ―Ḻe soa binḻo len xbab da' yo'o ḻo' yic̱hjlažda'olen'. Can' gwseḻa' X̱an' neda' yežlio nga bia' xtižen', ḻecze ca' neda' chseḻa' le'e güe'le xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Beyož gwne' ca' blobe' ḻegaque' na' gože' ḻegaque': ―Ḻe si' Spiritw c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Beṉe' ca' yesyetiṉje xtoḻa'gaquen', naple yeḻa' chnabia' ye'lne' ba gwnitlaon, na' naple yeḻa' chnabia' cont ye'le beṉe' bi yesyetiṉje xtoḻa'gaquen' bitw ṉitlaon. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na' Tomás ben' bososi'e Tomás Cuaš lene' len beṉe' šižiṉw ca' ba gosedalene' Jesúsen', na' bi gwzoe' cate' Jesúsen' bedyelo'elagüe' ḻegaque' že' dmigon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Na' beṉe' ca' yezica'chle gose'ene': ―Ba ble'eto' X̱anchon'. Na' Tomásen' gože' ḻegaque': ―Bi šejḻi'a mbancze' še bi le'eda' yiž c̱he claven' ḻe'e taque' ca' na' gwzebe xbenan' gan' gwdebe clav ca' na' gwzebe na'an cuit ḻe'en. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gozde' to xman zjanite' ḻo' yo'on da' yoble na' zoa Tomásen' len ḻegaque'. Na' da' yoble nyeyjw puert ca', cate' bezla' Jesúsen' na' gozzeche' gachoḻ ḻegaque'. Na' gwne': ―Ḻe soa binḻo len xbab da' yo'o ḻo' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nach gože' Tomásen': ―Gwṉa' ḻo' taca' quinga na' bzeben xbenon'. Na' bzebe naon' cuit ḻi'a nga cont šejḻi'o. Na' bich gaco' beṉe' bi chejḻe', san šejḻi'o. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nach Tomásen' gože'ne': ―¡X̱ana' na' Dios c̱hia'! ");
INSERT INTO zpqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Na' Jesúsen' gože' Tomásen': ―Tomás, ba chejḻi'o da' ba ble'edo' neda'. Mbalaz beṉe' ca' ba chesejḻe'e ḻa'czḻa' biṉa' yesele'ede' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Da' zan yeḻa' guac ben Jesúsen' da' besele'e beṉe' ca' zjanaque' ḻe' txen da' bi nyojen nga. ");
INSERT INTO zpqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Perw zjanyoj da' quinga cont šejḻe'le Jesúsen' naque' Cristo ben' gwlej Diosen' cont ṉabi'e na' naque' Xi'iṉ Dios, na' cont gata' yeḻa' mban toḻi tocaṉe c̱hele da' chejnilaže'lene'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Gwdechle yeto ža yoble Jesúsen' bozlo'elagüe' beṉe' ca' zjanaque' ḻe' txen cho'a nisdao' da' nzi' Nisdao' Tiberias. Quinga goc: ");
INSERT INTO zpqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Txen nite' Simón Pedron' len Tomásen' ben' bososi'e Tomás Cuaš, na' Natanael beṉe' yež Caná gan' mbane Galilean', na' c̱hope xi'iṉ Zebedeo na' yec̱hope beṉe' ca' zjanaque' Jesúsen' txen. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na' Simón Pedron' gože' ḻegaque': ―Ša'a gwxen beḻ da' yoble. Na' gose'e ḻe': ―Ḻecze sa' neto'. Nach gosa'aque' ja'aque' cho'a nisdaon' na' goso'e to ḻo' barcw. Na' nocze no beḻ beseželde' že'na'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na' do ba zoa šeni' besele'ede' zecha Jesúsen' cho'a nisdaon', perw bi gosacbe'ede' še Jesús nan'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nach Jesúsen' gože' ḻegaque': ―Beṉe' migw c̱hia' ¿nono beḻ chdoḻe'le? Na' gose'ene': ―Nono chdoḻe'to'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nach gože' ḻegaque': ―Ḻe gwzaḻa' yix̱jw beḻ c̱helen' cuit barcon' ḻichale na' senḻba'. Nach bosozaḻa' yix̱jw beḻ c̱hegaquen', na' tantw be zan besedoḻa', bi gosezoede' yosyocuen' ḻo' barcon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nach ben' chaquechgüe Jesúsen' le', gože' Pedron': ―X̱ancho nan'. Na' cate' gože' Simón Pedron' X̱ancho nan', ḻa' beyacwte Pedroa' xaḻanen', ḻe gague bi nyaze' cha'len' chone' žinṉa', na' ḻa' bxite'te' ḻo' nisen' cont byob bežine' gan' zoa Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na' yezica'chle beṉe' ca' zja'aclene' barcw daon' zjanxobe' yix̱jw gan' že' beḻ ya'a ca'. Bi naquen zito' cho'a nisdaon', ca do yeto gayoa metrze. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na' cate' besyežine' cho'a nisdaon' besele'ede' chi' yi' ya'alj na' xoa beḻ ya'a lagüenṉa' na' len yetextil. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na' Jesúsen' gože' ḻegaque': ―Ḻe yeyox̱e' ngale to c̱hope beḻ ya'a ca' za' gwxenḻe. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Na' Simón Pedron' gwyeje' jaxi'e yix̱jw beḻen' gan' chi' barcon' na' bexoben' ga nac yo biž. Žen' to gayoa ši'iṉeyon beḻ xen, perw bi bcheza' yix̱jon' ḻa'czḻa' be zan gwže' ḻo'enṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Na' Jesúsen' gože' ḻegaque': ―Ḻe da gagwle xsil. Na' ṉe toe' bi besyeyaxjde' ye'ene': “¿No le'?”, ḻe ba gosacbe'ede' naque' X̱anchon'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesúsen' gwbigue' na' gwxi'e yetextilen' na' bnežjue' c̱he to toe' na' ḻecz ca' bene' len beḻ ya'an. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Da'na' goc da' gwyoṉ ṉi'a blo'elao Jesúsen' beṉe' ca' zjanaque' ḻe' txen gwde bebane' ladjo beṉe' guaten'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na' cate' besyedagüe', Jesúsen' gože' Simón Pedron': ―Simón xi'iṉ Jonás, ¿chaquechdo' neda' clel can' chesaque beṉe' quinga neda'? Pedron' boži'en gože'ne': ―X̱ana', ṉezdo' chacda' le'. Jesúsen' gože'ne': ―Bsed blo'e beṉe' ca' za' gwzolao chesejnilaže' neda', beṉe' ca' zjanac ca me' xila' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na' da' gwchop ṉi'a gože' ḻe': ―Simón xi'iṉ Jonás, ¿chacdo' neda'? Na' da' yoble gwna Pedron': ―X̱ana', le' ṉezdo' chacda' le'. Jesúsen' gože'ne': ―Bgüia gwṉa' beṉe' ca' chesejnilaže' neda', beṉe' ca' zjanac ca xila' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Da' gwyoṉ ṉi'a gož Jesúsen' ḻe': ―Simón xi'iṉ Jonás, ¿chacdo' neda'? Na' Pedron' gocyaše'de' dan' gož Jesúsen' ḻe' ca' da' gwyoṉ ṉi'a, na' gože' ḻe': ―X̱ana', le' ṉeze nḻe'edo' yogo'ḻoḻ. Ṉezdo' chacda' le'. Jesúsen' gože' ḻe': ―Bsed blo'e beṉe' ca' chesejnilaže' neda', beṉe' ca' zjanac ca xila' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Da' ḻi chnia' le', cate' goco' beṉe' güego', cuino' gwyaz xaḻanon' na' gwyejo' con ga žan c̱hio'. Perw cate' gaco' beṉe' gole, gwḻi naon' na' beṉe' yoble c̱hize' xaḻano' na' yec̱he'e le' ga bi chaclažo'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Gože'ne' ca' cont gwṉezde' can' gacxen Diozen' len da' gac c̱he' cate' žin ža gate'. Na' gwde gwna Jesúsen' can' gac c̱he Pedron' nach gože'ne': ―Con gwyejnilaže' neda' na' bzenag c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","22","Na' yeto beṉe' naque' Jesúsen' txen na'ogüe' ḻegaque'. Na' beyec̱hj Pedron' na' ble'ede' ḻe' na' gože' Jesúsen': ―X̱ana', ¿nac gac c̱he benga? Jesúsen' gože'ne': ―Še chaclaža' ṉe' zoacze' cate' yida' yeto ¿bin' chacžejlažo'? Con gwzoateze gwyejnilaže' neda' na' bzenag c̱hia'. Ben' gwne' ca' naque' ben' chaquechgüe Jesúsen' na' ben' gwche' cuit Jesúsen' txen cate' gosagüe' xše' žen' cate' za' gac Jesúsen' ḻo na' beṉe' ca' chesegue'ede' ḻe'. Na' cana' bena' gwṉabde'ne': “X̱ana', ¿noxen' gwdie' le' ḻo na' beṉe' ca'?” ");
INSERT INTO zpqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na' dan' gož Jesúsen' Pedron': “Še chaclaža' ṉe zoacze' cate' yida' yeto ¿bin' chacžejlažo'?”, da'nan' gwditj diža' len beṉe' ca' chsejnilaže' Criston' gosene' bi gat bena'. Perw Jesúsen' gague gože'ne' bi gate', san gože'ne': “Še chaclaža' ṉe' zoacz benga cate' yida' yeto, ¿bin' chacžejlažo'?” ");
INSERT INTO zpqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nedan' ṉezda' can' goc yogo' da' quinga na' da'nan' ba bia' diža' c̱hegaquen na' ba bzojan'. Na' ḻecze le'e ṉezczele choa' diža' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na' da' zanch da' ben Jesúsen' da' bi zjanyojen, ḻe ša zjanyoj yogon' tgüeje tgüejen, libr zan juisyw yesaquen še ca'. Da' na'ze chzoja' ṉa'a.");
INSERT INTO zpqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ca nac dan' bzoja' da' nechw, bzoja' yogo'ḻoḻ da' ben Jesúsen', na' ḻecze bzoja' yogo' dan' bsed blo'ede' cate' gwzolaote' bsed blo'ede' ");
INSERT INTO zpqNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","žinten cate' beyepe' yaba. Šlac bsed blo'ede' gwleje' postlw c̱he' ca', na' Spiritw c̱he Diosen' bzejni'in Criston', na' Criston' gože' ḻegaque' nac yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nach gwde gosot beṉe' mal ca' Jesúsen' na' gwde bebane' ladjo bene' guaten' nach jalo'elagüe' postlw c̱he' ca'. Na' da' zan da' bene' cont goseṉezde' mbanczen'. Na' gwdalene' ḻegaque' c̱hoa ža na' bzejni'ide' ḻegaque' can' chnabia' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na' šlac ṉe' zoa Jesúsen' len postlw c̱he' ca' gože' ḻegaque' cbi yesyežaše' ciuda Jerusalénṉa'. Gwne': ―Ḻe yega'aṉ ḻe cueze gac can' gwna X̱a' Diosen' gac, ca dan' bzejni'ida' le'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Da' zaque' ben Juan da' bzoe' beṉe' nis, perw yeto c̱hope ža da' zaca'ch gac c̱hele dan' yedesoa Spiritw c̱he Diosen' ḻo' yic̱hjlažda'olen' ṉabi'an le'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na' ža na'teze šlac ṉe' zjandop zjanžague' len Jesúsen' gose'ene': ―X̱anto' ¿ba bžin ža gono' cont yechoj nación Israel c̱hechon' ḻo na' beṉe' zito' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesúsen' gože' ḻegaque': ―Bitw naquen ṉezele bi ža bi hor gon X̱acho Diosen' da' ca' toze' ba bžie' bia' gone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Perw na' cate' yedesoa Spiritw c̱he'na' len le'e, gaclenen le'e len yeḻa' guac c̱henṉa' cont güe'le xtižan' ciuda Jerusalén ni, na' doxen ga mbane distritw Judean', na' distritw Samarian', na' doxen yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Beyož gwna Jesúsen' ca', cheseṉa'te beṉe' ca' chesejnilaže' ḻe', beyepe' yaba to ḻo' bejw na' bich besele'ede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na' ṉe' cheseṉa'te beṉe' ca' ḻe'e yaban' gan' besele'ede' beyepe', cate'cze gosacbe'ede' ba zjazecha c̱hope angl len ḻegaque' beṉe' zjanyaz lache' šiš. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na' beṉe' ca' c̱hope gose'e ḻegaque': ―Beṉe' Galilea, ¿bixc̱hen' chṉa'le ḻe'e yaban'? Can' ble'ele beyep Jesúsen' yaban' caten' bechoje' ladjwlen', can' le'eczele yide' da' yoble. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na' nite' ya'a dan' nzi' Ya'a Olivos na' jaya'aque' Jerusalénṉa'. Jerusalénṉa' naquen gaḻa'ze con ca'te' de ḻsens yesa'aque' ža c̱he Dios can' ža ley c̱he beṉe' Israel ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na' cate' besyežine' Jerusalénṉa' postlw ca' šnej na' beṉe' ca' zjanžague' gosegüe' gan' nite'na' ḻo' cuart zoa yic̱hjen'. Postlw ca' šnej beṉe' quinga: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo xi'iṉ Alfeo, na' Simón ben' chon txen partid dan' nzi' cananista, na' Judas ben' nac beṉe' biše' Jacobon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Na' gosenita'teze postlw ca' šnej chosoḻ güiže' Diosen' txen len beṉe' ca' zjanaque' biše' Jesúsen' na' len María xṉa' Jesúsen' na' len yezica'chle no'ol ca' zjanžag. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na' ca hora' Pedroa' zeche' ladjo to gayoa gaḻje beṉe' chesejnilaže' Jesucriston' cont be'lene' ḻegaque' dižan', na' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Beṉe' migw, Spiritw c̱he Diosen' benen cont rey David bzoje' na' be'e diža' c̱he Judasen' ben' gwc̱he' beṉe' ca' gosezen Jesúsen' gan' jasešague' ḻe'. Na' benen byen goc can' nyoj Xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasen' goque' txen len neto' na' bene' txen len neto' yogo'ḻoḻ dan' gwyo'o ḻo na'to' bento'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na' gosezi'e late' yežlio len mechw dan' gwxi' Judasen' bene' da' malen' bdie' Jesúsen' ḻo na' beṉe' ca'. Perw na' blažoe' cosyic̱hj gan' goḻadite' na' gošj ḻi'ena', doxen xjaloen' bchoj. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yogo' beṉe' že' Jerusalénṉa' goseṉezde' can' goc c̱hen' na' da'nan' bososi'e yežlion' Acéldama na' xtiža'gaque'na' zejen Yežlio Chen. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Goc can' nyoj to salmo žan: Liže'na' gaquen to yo'o daš, nono soa na'. Na' ḻecze nyojen žan: Na' te beṉe' yoble yoḻane' žin dan' bene'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Na' nga nita' beṉe' ba gosone' txen len chio' šlac gwdalen X̱ancho Jesúsen' chio'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ba gosone' txen gwzolaoten cate' da' Juan bzoe' ḻe' nis bžinten caten' beyepe' yaban', na' cheyaḻa' cuejcho toe' gone' txen len neto' postlw güe'to' diža' can' beban X̱ancho Jesúsen' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na' gosebeje' c̱hope beṉe', toe' José ben' le Barsabás, na' ḻecz le' Justo, na' ben' yeto Matías. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nach bosoḻ güiže' Diosen' gose'ene': ―X̱anto', le' nombi'o yic̱hjlaždao' yogo'ḻoḻ beṉe'. Lao beṉe' ca' c̱hope blo'ešca neto' noe' ba gwlejo' cont gaque' postlw na' gone' xšinon' txen len neto'. Ḻe ca nac Judasen', gwlejyic̱hje' dan' ngo'o ḻo ne'e gone' na' ba zjayde' gan' naquen yeyeje' yeḻa' güen da' mal c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nach gosone' rifa cont goseṉezde' non' ba gwlej Diosen' na' Matíasen' bchoje' na' gosone' ḻe' cuent len postlw ca' yešnej. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na' bžin ža ḻṉi dan' že' Pentecostés, na' postlw ca' na' yogo'ḻoḻ beṉe' ca' ba gosejnilaže' Jesúcriston' zjandop zjanžague' toze latje. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na' zejzenez goc to sšag ḻe'e yaban' ca sšag c̱he to be' bdono' gual na' nenxeje ḻo' yo'o gan' zjachi'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na' besele'ede' gaḻa'ze yic̱hj to toe' gosezoa tgüeje yi' beḻ da' chaḻa'ṉiṉ. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ca' goc jašo'o Spiritw c̱he Diosen' ḻo' yic̱hjlaždao' to toe', na' Spiriton' benen cont gosezolagüe' goso'e gwde gwdele diža' da' gosejni'i beṉe' zito' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na' ca tiempen' beṉe' zan beṉe' Israel že' Jerusalénṉa' beṉe' chesonxene' Diosen', za'aque' doxen yežlion'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Na' cate' gosende' chac sšaguen' gan' že' postlw ca', zan beṉe' Israel ca' besežague', na' ḻeca besyebande', ḻe to to postlw ca' bosozejni'ide' ḻegaque' len diža' da' chesejni'i to toe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bi gosejni'ide' bin' chac na' besyebande' gosene': ―¿Gague beṉe' distritw Galilea beṉe' quinga? ");
INSERT INTO zpqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nacxec̱hen' to tocho chenecho cheso'e diža' can' chesoe' beṉe' gualaž c̱hecho diža'? ");
INSERT INTO zpqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Baḻcho naccho beṉe' nación Partia, na' baḻcho beṉe' nación Media, na' baḻcho beṉe' nación Elam, na' baḻcho beṉe' distritw Mesopotamia. Na' yebaḻcho beṉe' distritw Judea, na' yebaḻcho beṉe' distritw Capadocia, yebaḻcho beṉe' distritw Ponto, na' yebaḻcho beṉe' distritw Asia, ");
INSERT INTO zpqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","yebaḻcho beṉe' distritw Frigia na' beṉe' distritw Panfilia, na' yebaḻcho za'cho nación Egipto, na' yebaḻcho za'cho yež ca' zjachi' Africa do te ciuda Cirene. Na' chio' naccho cuent len beṉe' nación Roma, baḻcho goljcho naccho beṉe' Israel na' yebaḻcho ben cuincho txen len beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na' baḻcho naccho beṉe' yež ca' zjachi' Creta na' beṉe' distritw Arabia. Na' gate'tez beṉe' naccho, yogo'cho chenecho chesoe' beṉe' distritw Galilea quinga xtiža'chon' da' chaccho, cheso'e diža' c̱he da' zan da' ba ben Diosen' da' zaca' yebanecho. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na' yogo' beṉe' ca' besedobe' chosozenague' besyebande' na' gosacžejlaže' bin' chac, na' zane' gosene': ―¿Bi zejen dan' chaquen'? ");
INSERT INTO zpqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na' yebaḻe' goseṉeye'e gosene': ―¡Beṉe' quinga chesezožde'! ");
INSERT INTO zpqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na' Pedroa' gwzeche' lao ben' zjandop zjanžague' txen len postlw ca' yešnej na' be'e diža' zižje gwne': ―Le'e beṉe' Judea na' note'tezechle zoale ciuda Jerusalén ni, che'nda' gwzenagle c̱hia' na' gonḻe xbab c̱he da' za' ṉi'a le'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Beṉe' ḻježa' quinga bitw chesezožde' can' chaquele, ḻe ṉe' nac tempran. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ba chac can' bzoj da' Joel ben' be' xtiža' Diosen' cani' bzoje' dan' gwna Diosen', žan: ");
INSERT INTO zpqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cate' ba zoa žin ža cont yeyož yežlion', neda' Dios gona' cont Spiritw c̱hian' yedesoan len beṉe' že' doxen yežlion'. Na' gona' cont xi'iṉle ca' yeso'e xtiža'na', na' beṉe' byo xcuide' ca' yesele'edagüede' bi da' gona', na' güe'lena' beṉe' byo gol ca' diža' ḻo bišgal c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na' yogo' beṉe' ca' chesejnilaže' neda', beṉe' byo na' no'ole, yedesoa Spiritw c̱hian' len ḻegaque' cont yeso'e xtižan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gona' cont yesele'e beṉac̱hen' da' zaca' yesyebande' ḻe'e yaban' na' lagüe yežlion', na' gona' yeḻa' guac c̱hia'na' len chen, len yi' na' len žen da' nac ca bejw. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bich gwseṉi' gwbižen', na' bio'na' yeyaquen xṉa ca chen cate' za' žin ža yida' da' yoble gwnežjua' castigw c̱he yogo' beṉe' cbi chesejnilaže'nda', neda' naca' X̱anḻe. Žana' gaquen to ža žialao xen. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nach note'tez beṉe' yeseṉabe' gaclena' ḻegaque', neda' naca' X̱anḻe yebeja' ḻegaque' ḻo da' malen'. Can' gwna Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Na' le'e beṉe' Israel gualaž c̱hia', ḻe gwzenag c̱hia'. Jesúsen' ben' nac beṉe' yež Nazaret, Diosen' blo'ede' naque' beṉe' zaque'. Diosen' bene' cont Jesúsen' bene' yeḻa' guac na' bichle da' zaca' yebanecho can' ṉezeczelen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ḻo yeḻa' ṉeze c̱he Diosen' bin' za' gac, bi'e latje gwzenḻe Jesúsen' na' bdelene' ḻo na' beṉe' mal ca' gosote'ne' bosode'ene' ḻe'e yag cruzen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Perw na' Diosen' bec̱his bosbane'ne' ladjo beṉe' guat ca', ḻe bi gwzoe yeḻa' goten' ṉabian' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Quinga bzoj da' rey David xtiža' Jesúsen' cani'te, žan: Ṉezda' X̱ana' Diosen' zoe' len neda' do ža do yel, na' zoe' chaclene' neda' cont bi chžeba'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Da'na'na' zoa' mbalaz na' choa' diža' ḻeca chebeda'. Na' ḻecze chebeda' ṉezda' yec̱his yosbane' neda' ladjo beṉe' guat ca' cate' ba gota'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dios c̱hia', ṉezda' bi yocua'aṉo' neda' gan' že' beṉe' guat ca', ṉeca go'o latje gožo' cuerp c̱hia'na', neda' naca' xi'iṉo' na' nac lažda'oguan' xilaže'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ba blo'edo' neda' can' soa cueza' mbalaz. na' mbalaz soa' dan' soaleno' neda'. Beyož gwna Pedroa' ca' nach gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","―Beṉe' Israel, ṉezecho da' x̱ozxta'ocho rey David gote' na' bosocuaše' ḻe'. Na' nombia'cho ba gan' bosocuaše' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na' da' rey Davin' be'e diža' can' bzejni'i Diosen' ḻe' na' gwṉezde' gwlo'o Diosen' da' baḻi gague da' te bi gac can' gwne'. Gwṉezde' gon Diosen' cont Criston' galje' ḻo diaža c̱he' na' ṉabi'e nación Israelen' can' gwnabia' ḻe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Diosen' bene' cont da' rey Davin' gwṉezde' can' gaquen' na' da'nan' be'e diža' c̱he Criston' ben' ba gwseḻa' Diosen' cont ṉabi'e. Gwne' Criston' yebane' na' bi yega'aṉe' gan' že' beṉe' guat ca' na' ṉeca gožo' cuerp c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na' Diosen' bec̱his bosbane' Jesúsen' ladjo beṉe' guat ca', na' yogo' neto' choe'to' diža' ṉezeto' beyas bebane'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na' Diosen' len yeḻa' guac c̱he'na' bene' cont beyep Jesúsen' gan' zoe'na' na' chnabi'e txen len ḻe'. Na' Diosen' bnežjue'ne' Spiritw c̱he'na' can' gwne'. Na' Jesúsen' ba bene' yeḻa' guac nga da' ba benele na' da' ba ble'ele. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Gague da' rey Davin' beyep yaban', san da' David bzoje' c̱he Jesúsen' gwne': X̱ancho Diosen' gože' X̱anan': “Gwche'edo' cuita' nga ṉabia'cho txen, ");
INSERT INTO zpqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","na' gona' cont yogo' no chesegue'e le' yosozex̱jw yic̱hje' yosozenague' c̱hio'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Da'nan' yogo' chio' beṉe' Israel cheyaḻa' ṉezecho Jesúsen' ben' betwle bda'lne' ḻe'e yag cruz, Diosen' gwleje'ne' cont naque' X̱anchon' na' naque' Cristo, zeje diža' naque' ben' gwseḻa' Diosen' ṉabi'e nación c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na' cate' beṉe' ca' zjanžaguen' gosende' xtiža' Pedroa', da' juisyw da' gosacde' ḻo' lažda'ogaquen', nach gose'e Pedroa' na' len yezica'chle postlw ca': ―Beṉe' gualaž, ¿bin' cheyaḻa' gonto'? ");
INSERT INTO zpqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nach Pedroa' gože' ḻegaque': ―To tole cheyaḻa' yetiṉjele xtoḻa'le ca' na' soale nis dan' ba chejnilaže'le Jesucriston', na' Diosen' yezi'xene' c̱hele na' goṉe' le'e Spiritw c̱he'na' soan ḻo' yic̱hjlažda'olen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","X̱ancho Diosen' goṉe' note'tezle Spiritw c̱he'na' can' ba gwne', le'e na' xi'iṉle ca' na' note'tez beṉe' zito', ḻe chnežjuen' yogo' beṉe' chbeje' cont yesaque' ḻo ne'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nach Pedroa' be'lene' ḻegaque' diža' zan, na' gwṉeyoede' ḻegaque' gwne': ―Ḻe yechoj ladjo beṉe' mal quinga beṉe' cbi zjanombia' Dios. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ca' goquen' beṉe' ca' gosejḻe'e diža' dan' be' Pedroa' gosezoe' nis. Na' ḻo žana' šoṉ mil beṉe' gosejnilaže' Jesúsen' na' gosaque' txen len yezica'chle beṉe' chesejnilaže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yogüe' gosenita'teze' bosozenague' dan' bososed bosolo'e postlw ca' ḻegaque'. Na' gosaque' toze len yezica'chle beṉe' gosejnilaže' Jesúsen' na' gose'ej gosagüe' txen na' gosenite' bosoḻ güiže' Diosen' txen. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na' yogo'ze beṉe' besyebande' can' goson postlw ca' da' zan da' güen da' zaca' yebanecho len yeḻa' guac c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na' beṉe' ba chesejnilaže' Jesúsen' gosaque' toze na' gosone' toze yogo'ḻoḻ da' zjade c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na' gosote' yežlio na' bichle da' zjadede' na' mechw dan' besele'ede' c̱hen goseyisen' lao yogo'ḻoḻe' con da' beseyažje to toe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na' tža tža besedop besežague' yodao' blaona' na' ḻecze do laže' gose'ej gosagüe' txen liž to togaque' na' gosenite' mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Gosenita'teze' gosonxene' Diosen'. Na' gosazlaže' beṉe' yezica'chle can' gosone'na'. Na' tža tža X̱ancho Diosen' bene' cont gosanch beṉe' ca' gosejnilaže' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na' to ža Pedroa' na' Juan ja'aque' yodao' blaona' do cheda šoṉe, hor cate' beṉe' Israel ca' chosoḻ güiže' Diosen' yogo' ža. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na' gwzoa to beṉe' nxiṉj ṉi'e ca goljte' na' yogo' ža gosebec beṉe' ḻe' cho'a puert c̱he yodao'na', puert dan' nzi' Puert Xdan, cont gwṉabe' mechw lao beṉe' ca' chja'ac yodao'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nach cate' bžin Pedroa' len Juan yodao'na' na' ben' nxiṉj ṉi'ena' boḻ güiže' ḻegaque' yosonežjue'ne' mechw. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nach Pedroa' len Juanṉa' gosebeze' na' goseṉa'chgüe' ḻe' na' Pedroa' gože'ne': ―Gwṉa' neto'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na' bena' bene' xbab yosonežjue'ne' mechw. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Perw Pedroa' gože'ne': ―Bibi mechw c̱hia' de da' goṉa' le', perw zoa to da' gona' gaclena' le': len yeḻa' guac c̱he Jesucriston' beṉe' naque' beṉe' yež Nazaret, chona' mandadw gwzoža' na' gwda. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na' Pedroa' bex̱oe' ne'e ḻicha na' bsože'ene', na' gocte gwzeche' na' ṉi'ena' ḻa' besyeyacten da' gual na' ḻecz ca' bec̱hj ṉi'e ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na' cate' gocbe'ede' ba besyeyac ṉi'en', bxite' yeḻa' chbe c̱he'. Na' gwyo'e chašil c̱he yodao'na' len ḻegaque' chxite' na' cho'e yeḻa' chox̱clen c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na' beṉe' ca' že' chašilen' besele'ede' can' chde' chxite' cho'e yeḻa' chox̱clen c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Na' besyeyombi'e ḻe' naque' ben' chbe' chṉab mechw yogo' ža cho'a puert c̱he yodao'na', puert dan' nzi' Puert Xdan, na' ḻeca besyebande' da' ba beyac ṉi'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na' gosenite' chašil da' nzi' Chašil c̱he da' Salomón dan' ze gan' zoa' yodao'na'. Na' ben' beyac ṉi'ena' bi bsane' Pedroa' len Juanṉa'. Nach yogo' beṉe' že' yodaon' besežagsese' chašila' cont jaseṉe'e ben' beyaquen', ḻe besyebanchgüede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na' cate' Pedroa' ble'ede' ba zjanžag beṉe' zan gan' nite'na' nach be'lene' ḻegaque' diža', gože' ḻegaque': ―Le'e beṉe' gualaž c̱hia' beṉe' Israel, ¿bixc̱hen' chebanele? ¿Chaquele len yeḻa' guac c̱heton' bento' cont beyac benga? ¿Še chaquele beyaque' dan' chonchguato' can' chazlaže' Diosen'? Bi naquen ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios ben' gosonxen da' x̱ozxta'ocho Abraham, Isaac na' Jacob, blo'e nac Xi'iṉe' Jesúsen' beṉe' zaca' juisyw. Perw le'e bdele Jesúsen' ḻo na' justis ca' cont gosote'ne' na' bžonḻe cate' Pilaton' goclaže' gwsane'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Can' benḻe len Jesúsen' ḻa'czla' naque' beṉe' laždao' xilaže' juisyw na' naque' ḻa'zelagüe beṉe' chon da' güen. Nach gwṉable bosan Pilaton' to beṉe' güetw beṉe' na' bi gwṉable yosane' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Na' ca nac Jesúsen' ben' bx̱e yeḻa' mban toḻi tocaṉe, ḻe'na' betwle, perw na' Diosen' bec̱his bosbane' ḻe' ladjo beṉe' guat ca'. Neto' ble'eto'ne' na' choe'to' diža' ba bebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na' chle'ele benga cbi goc se'e na' nombia'lne', na' ṉa'a ba beyac ṉi'ena' len yeḻa' guac c̱he Jesúsen' ben' chejnilaže'to'. Ḻe da' chejnilaže'to' Jesúsen', da'nan' besyeyacšagüe' ṉi'a benga na' ba chle'ele can' beyaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Beṉe' migw, ṉezda' le'e na' beṉe' gole blao c̱hele ca' betwle Jesúsen' lagüe bi gwyejni'ile Diosen' gwseḻe'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na' da' benḻe ca', goc can' gwna Diosen' gac, da' bene' mandadw bosozoj da' beṉe' ca' goso'e xtižen' cani', bosozoje' c̱he Criston' ben' gwlej Diosen' cont ṉabi'e. Bosozoje' c̱he' gosene' yosoc̱hi yososaca' beṉe' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Da'nan' ḻe yeyonšca xbab c̱hele na' ḻe yetiṉje xtoḻa'len' cont X̱ancho Diosen' gwṉitlagüen' na' gone' ga soale mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nach X̱ancho Diosen' seḻe' Jesúsen' yežlio nga yetṉi'a, ben' gwleje' cani'te cont naque' Cristo c̱hecho. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Perw chonen byen yega'aṉ Jesucriston' yaban' ṉa'a, na' cate' žin ža gon Diosen' cont yežlio nga yeyaquen da' cobe, cana' yide' yeto. Ca' gosena beṉe' gwleje' cani' cont goso'e xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Da' Moisésen' be'lene' da' x̱ozxta'ocho diža', gože' ḻegaque': “X̱ancho Diosen' seḻe' yeto beṉe' gualaž c̱hechon' cont güe'lene' le'e xtiže'na' can' gwseḻe' neda'. C̱he bena' gwzenagle bite'tez ṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na' Diosen' gone' yesebiayi' yogo' beṉe' ca' cbi yosozenague' c̱he bena' seḻen', na' bich yesenite' txen len beṉe' ca' chesonxene' ḻe'.” Can' gož Moisésen' da' x̱ozxta'ocho ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ḻecz ca' yogo'ḻoḻ beṉe' goso'e xtiža' Diosen' cani', gwzolaozen len da' Samuel na' yogo' beṉe' ca' gosedech, goso'e diža' c̱he da' ca' ba chac tiemp ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Le'e nacle xi'iṉ diaža c̱he da' beṉe' ca', na' dan' gož Diosen' ḻegaque' gone', na' dan' gože' yezica'chle x̱ozxta'ole ca', ḻecz naquen c̱he le'e. Gože' da' Abrahanṉa': “To beṉe' galje ḻo diaža c̱hio' gone' cont beṉe' že' doxen yežlion' ṉite' mbalaz.” ");
INSERT INTO zpqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Da'nan' cate' Diosen' bosbane' Xi'iṉe' Criston' ladjo beṉe' guat ca', zgua'tec gwseḻe'ne' lao chio' beṉe' Israel da' goclaže' gaclene' chio' cont to tocho yetiṉjecho xtoḻa'chon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ṉe' chesoe'lente Pedroa' na' Juanṉa' beṉe' ca' diža' cate' besežin baḻ bx̱oz c̱he beṉe' Israel ca', na' beṉe' gwnabia' c̱he ben' chesape' yodao' blao c̱hegaque'na' na' beṉe' saduceo ca' beṉe' cbi chesejḻe'e še yesyeban beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Beṉe' ca' cheseže'e c̱he dan' chososed chosolo'e Pedroa' len Juanṉa', ḻe chesene' ṉezecho gwžin ža cate' yesyeban beṉe' guat ca' da' beban Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Na' beṉe' blao ca' gosezene' Pedroa' len Juanṉa' na' goseyix̱jue' ḻegaque' ḻižya do yel, ḻe ba chx̱in na' bi goḻa' yesone' yeḻa' justis c̱hegaquen' ca cheyaḻa' že'na', san bosocuezen' beteyoch. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na' ca nac beṉe' ca' gosende' chesoe' Pedroa' na' Juanṉa' xtiža' Diosen', zane' gosejnilaže' Criston', na' txen len beṉe' ca' ba gosejnilaže'ne' cana', gosac do gayo' mil beṉe' byo cbi cuent no'ole. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na' beteyo beṉe' gwnabia' c̱he beṉe' Israel ca', beṉe' gole blao ca' na' beṉe' bososed bosolo'e ley dan' bzoj da' Moisés, besedop besežague' ciuda Jerusalénṉa' ");
INSERT INTO zpqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","len Anás ben' naquech bx̱oz blao, na' len Caifás, na' Juan, na' Alejandro na' nochle beṉe' zjanaque' biše' ḻjež ben' naquech bx̱oz blaon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na' gosone' mandadw jasexi'e Pedroa' na' Juanṉa' na' cate' ba zjazie' laogaquen' goseṉabde' ḻegaque': ―¿No beṉ ḻsens c̱hele cont beyonḻe beṉe' nxiṉjen'? o ¿no yeḻa' guac c̱he bc̱hinḻe beyonḻene'? ");
INSERT INTO zpqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na' Spiritw che Diosen' dan' yo'o ḻo' yic̱hjlaždao' Pedroa' benen cont gože' beṉe' ca': ―Le'e beṉe' gwnabia' na' beṉe' gole beṉe' blao c̱he nación Israel c̱hechon', ");
INSERT INTO zpqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","chṉable nac bento' da' güen beyonto' bena' nxiṉj ṉi'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Le'e na' yogo' beṉe' gualaž cheyaḻa' ṉezele Jesucriston' ben' naque' beṉe' Nazaret bene' yeḻa' guac c̱he' cont beyacšagüe' benga. Le'e betwle Jesucriston' bda'lne' to ḻe'e yag cruz, perw Diosen' bec̱his bosbane'ne' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bi gwyejḻe'le c̱he Jesucriston', da'nan' zaca'leble ca beṉe' cheson yo'o beṉe' bi chesazlaže' yej güen da' ba naquen yej squin c̱he yo'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Toze Jesucriston' guac goṉe' chio' yeḻa' mban toḻi tocaṉe, na' noch no zoa doxen ḻo yežlion' beṉe' gac goṉe' yeḻa' mban toḻi tocaṉe c̱he chio' beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Besyebane beṉe' gwnabian' can' boži'i Pedroa' na' Juanṉa' xtiža'gaquen' sin cbi besežebe', ḻe nacbia' zjanaque' beṉe' yix̱e' na' bi zjansedteque'. Nach gosacbe'ede' ḻegaquen' ba gosedalene' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na' dan' zecha ben' beyaque ṉi'ena' txen len Pedroa' na' Juanṉa', bi besyežele beṉe' gwnabian' bi yeseṉe' c̱hegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nach beṉe' gwnabian' besyebeje' postlw ca' chyo'ole šlac bosoxi'e ḻegacze' nacle yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na' beṉe' gwnabian' gose' ḻježgaque': ―¿Bi goncho len beṉe' quinga? Yogo' beṉe' že' ciuda Jerusalén ni zjaṉezde' gosone' to yeḻa' guac xen na' bi gac ye'cho beṉe' bi gosone' yeḻa' guaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ḻetechoze goncho cont cbi gaslas diža' dan' cheso'ena'. Da'nan' cheyaḻa' ye'cho ḻegaque' gata' castigw c̱hegaque' še yesoe'che' xtiža' Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nach gosaxe' Pedroa' na' Juanṉa' da' yoble na' gose'e ḻegaque' bich yeso'e diža' c̱he Jesúsen' na' noch no yososed yosolo'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nach Pedroa' na' Juanṉa' bosyoži'e xtižen' gose'e ḻegaque': ―Ḻe gon xbab c̱he da' nga, ¿chaquele chaclaže' Diosen' gwzenagto' c̱hele o še chaclaže' gwzenagto' c̱he ḻe'? ");
INSERT INTO zpqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bi gac cuezto' bich güe'to' diža' c̱he da' ba ble'eto' na' ba beneto'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Na' da' zan da' gose' beṉe' gwnabia' ca' ḻegaque' cont yosošebe'ne'. Perw na' bi beseželde' nacle yesone' ḻegaque' castigw, ḻe beṉe' zan chesonxene' Diosen' dan' beyac bena' len yeḻa' guac c̱he Diosen'. Ba gwdie' c̱hoa iz na' ca goljte' bi goc se'e. Nach bososane' Pedroa' na' Juanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na' Pedroa' len Juanṉa' cate' bososan beṉe' gwnabian' ḻegaque' jaya'aque' gan' nita' yezica'chle beṉe' chesejnilaže' Criston' na' gosoe'lene' ḻegaque' diža' yogo'ḻoḻ can' gose' bx̱oz gwnabia' ca' na' beṉe' gole blao ca' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na' cate' gosende' dan' gose' Pedroa' len Juanṉa' ḻegaque', toze can' gosone' xbab na' bosoḻ güiže' Diosen', gosene': ―X̱anto' Dios, len' beno' yaban' na' yežlion' na' nisdaon'. Len' beno' beṉac̱h na' be ca' chesaš na' bica'chle da' zjade, na' len' chnabi'o doxen. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na' le' beno' cont da' rey David bzoje' diža' quinga dan' gož Spiritw c̱hion' ḻe', žan: Beṉe' ca' cbi zjanaque' beṉe' Israel chesase' contr le', X̱anto' Dios, perw bicze gac can' chesone' xbaben'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Beṉe' gwnabia' c̱he nación ca' na' c̱he yež ca' txen zjanaque' chesone' contr le' X̱anto' Dios, na' contr Xi'iṉo' Criston' ben' gwseḻo' cont ṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Na' X̱anto' Dios, naquen da' ḻi rey Herodes na' Poncio Pilato na' beṉe' cbi zjanaque' beṉe' Israel gosaque' txen len beṉe' Israel ca' ḻo ciuda nga. Na' yogüe' gosone' txen cont gosote' Xi'iṉo' Jesúsen' ben' nac beṉe' laždao' xilaže' juisyw, ben' gwlejo' cont ṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gosone' can' gwc̱hogbi'o gac dan' bžio' bia' cani'te. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na' ṉa'a X̱anto', gwṉa can' cheson beṉe' gwnabia' ca', ḻe chesaclaže' yosošebe' neto' beṉe' güen žin c̱hio'. Na' goclen neto' cont bi žebto' güe'to' xtižo'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na' cate' güe'to' xtižo'na' blo'ešca yeḻa' guac c̱he Xi'iṉo' Jesúsen' beṉe' laždao' xilaže' juisyon' cont gac yeḻa' guac, na' yesyeyac no beṉe' chesacšene na' gac bichle da' yesyebane beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na' cate' beyož bosoḻ güiže' Diosen', Diosen' bene' gwxo' gan' zjandop zjanžague'na' na' Spiritw c̱he'na' gwzoachguan len ḻegaque', nach goso'e xtiža' Diosen' sin cbi besežebe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na' yogo' beṉe' ca' gosejnilaže' Criston' toz ca gosac yic̱hjlažda'ogaque'. Na' yogo' bi da' zjade c̱hegaque' gosonen' toze, na' nono gwna: “C̱hia' da' nga”, o “C̱hia' da' na'”, ḻe naquen c̱he yogo'ḻoḻ gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na' postlw ca' len yeḻa' guac xen c̱he Diosen' bosozejni'ide' beṉe' Jesúsen' bebane' ladjo beṉe' guat ca'. Na' Diosen' goclenchgüe' ḻegaque' len bi dan' gosone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na' bibi goc falt bi da' beseyažje beṉe' gosejnilaže' Criston', ḻe beṉe' zjanape' no yežlio o no yo'o gosoten'. Na' mechw dan' besele'ede' c̱he to ton ");
INSERT INTO zpqNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bosonežjuen' postlw ca', na' postlw ca' goseyisen' len beṉe' beseyažjden'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Can' ben to beṉe' Chipre beṉe' le José. Naque' xi'iṉ diaža c̱he da' Levin' na' postlw ca' bososi'ene' Bernabé, zeje diža' ben' cheyonxenḻaže' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Joséna' bete' to yežlio c̱he' na' mechw dan' ble'ede' c̱hen bnežjuen' postlw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na' zoa to beṉe' le Ananías na' no'ol c̱he'na' Safira, na' gosote' to yežlio c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Perw na' ḻegacze' bosoxi'e yosonežjue' late'ze mechw dan' besele'ede' c̱hen na' yese'e postlw ca' doxenenṉa'. Nach gwyej Ananíasen' na' bnežjue' postlw ca' mechon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nach Pedroa' gože'ne': ―Ananías, ¿bixc̱hen' bzenago' c̱he Satanás dan' chnabia' da' x̱igüe' ca' na' chacdo' x̱oayago' Spiritw c̱he Diosen'? Chi'o neto' choṉo' doxen mechon' dan' ble'edo' c̱he yežlion', ḻen ba gwlo'ošagüe'le laten' par cuinḻe. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","C̱hio' yežlion' cate' biṉa' goton', na' c̱hio' mechon' dan' ble'edo' cate' beton' na' zaco' cont beno' da' chaclažo' len ḻen. ¿Bixc̱hen' benḻe da' malen' nac ca'? Gague contr neton' ba benḻe benḻaže'le, san contr Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nach Ananíasen' cate' bende' xtiža' Pedroa' to gwbix̱ze' na' gote'. Na' yogo' beṉe' ca' gosende' diža' can' goquen' besežebchgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na' besežin to c̱hope beṉe' xcuide' gan' gwbix̱ da' Ananíasen' na' bosyoc̱heḻe' cuerp c̱hen' to lache' na' besyeyo'ene' ga bosocuaše'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na' gwde do šoṉ hor gote' cate' bžin no'ol c̱he'na' na' gwyo'e ḻo' yo'on sin cbi ṉezde' bin' ba goc c̱he beṉe' c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na' Pedroa' gože'ne': ―¿To ca'te' ble'ele c̱he yežlion'? Na' Safiran' gože'ne': ―To ca'te'ten'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nach Pedroa' gože' no'olen': ―¿Bixc̱hen' goco' toze len beṉe' c̱hion' chaquele gonḻe Diosen' prueba še lede' can' že' bi cheyaḻa' x̱oayagcho? Cho'a puert nga zjazecha beṉe' ba bosocuaše' beṉe' c̱hio'na' na' ṉa'a yeso'e le'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na' ḻa' gwbix̱te Safiran' lao Pedroa' na' gote'. Na' cate' goso'o beṉe' xcuide' ca' ḻo' yo'ona' besele'ede' ba gote' nach goso'ene' jasecuaše'ne' cuit da' beṉe' c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na' yogo' beṉe' chesejnilaže' Criston' besežebe' can' goquen' na' ḻecze besežeb yezica'chle beṉe' gosende' diža' can' goquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na' postlw ca' gosone' da' zan yeḻa' guac na' bichle da' besele'e beṉe' da' zaca' yesyebande'. Na' beṉe' ca' chesejnilaže' X̱ancho Jesucriston' chesedop chesežague' txen chašil c̱he yodao' blaona' gan' nzi' Chašil c̱he da' Salomón. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na' yezica'chle beṉe' ca' že' Jerusalénṉa' gosapchgüe' ḻegaque' bala'aṉ, ḻa'czḻa' besežebe' yesaque' txen len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Perw na' zane' gosejnilaže' X̱anchon' na' gosaque' txen, zan beṉe' byo na' no'ole. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na' cate' no beṉe' gosacšende' goseyix̱jue' ḻegaque' tnez do ḻo cam do ḻo yagla', gosebeze' te Pedroa' cont yesecheḻe' bx̱in c̱he' na' yesyeyacde' še bi yižgüen' chese'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na' beṉe' ca' že' yež da' zjachi' gaḻa'ze ciuda Jerusalénṉa' ja'aque' zjanc̱he'e beṉe' chesacšene na' beṉe' zjayo'o zjanyaz da' x̱igüe'. Na' yogo'ḻoḻe' besyeyacde'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nach ben' nacch bx̱oz blao na' yezica'chle beṉe' saduceo beṉe' cbi chesejḻe' yesyeban beṉe' guat, besegue'ede' postlw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na' gosezene'ne' na' goseyix̱jue' ḻegaque' ḻižya. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na' to angl beṉe' za' gan' zoa X̱ancho Diosen' bžine' ḻižyan' šeže'le na' gwsaljue' puert ca' na' bebeje' ḻegaque'. Na' gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Ḻe šja'ac yodao' blaona' na' ḻe güe' diža' len ben' chesežagna' naquen' yesone' cont gata' yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nach dan' gosende' can' gož anglen' ḻegaque', ja'aque' yodao' blaona' cate' gwyeni' na' bososed bosolo'ede' ben' zjanžag na'. Na' ben' nac bx̱oz blao len beṉe' gole blao ca' chesenabia' nación Israelen' besedobe' cont bosoxi'e, nach gosone' mandadw šjasexi'e postlw ca' gan' zjade' ḻižyan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na' cate' ben' chesap yodaon' besežine' ḻižyan' gague no postlw ca' zjanḻa' na' jaya'aque' lao beṉe' gwnabia' ca' jasyedix̱jue'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Gose'e beṉe' ca': ―Nyeyjwc̱hac̱h ḻižyan' na' ḻecze na' nita' soldadw ca' cho'a puerta' chesapen' perw cate' gwsaljwto' puerten' gague no postlw ca' že' ḻo' ḻižyan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na' ben' nacch bx̱oz blao na' beṉe' gwnabia' c̱he ben' chesap yodaon' na' bx̱oz gole blao ca' cate' gosende' rsonṉa' besyebande', gosene': ―¿Nac gac da' nga ṉa'a? ");
INSERT INTO zpqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na' šlac chesacžejlaže', bžin to beṉe' gože' ḻegaque': ―Beṉe' ca' gwdix̱jwle ḻižyan' zjaze' chašil c̱he yodao' blaona' chososed chosolo'ede' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nach beṉe' gwnabia' c̱he ben' chesap yodaon' len beṉe' gop ca' jasa'aque' jasexi'e postlw ca' diža' šagüe'. Bi gosone' znia len ḻegaque' da' besežebe' beṉe' chosozenag xtiža' postlw ca' še yosožie' ḻegaque' yej. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na' cate' besežin postlw ca' lao beṉe' gwnabia' ben' nita' chosoxi'a, nach ben' nacch bx̱oz blao gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ba bento' mandadw bi güe'le diža' c̱he Jesúsen' na' bich gwsed gwlo'ele beṉe' xtižen', na' ba gwdisle xtiže'na' doxen ciuda Jerusalénṉa'. Na' ba chosbague'le neto' žale betwto'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nach Pedroa' na' postlw ca' gose'e ḻegaque': ―Nacchen da' žialao xen gwzenagto' c̱he Diosen' clel ca c̱he beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Le'e betwle Jesúsen' bda'lne' to ḻe'e yag cruz, perw Dios ben' chonxencho na' ben' gosonxen da' x̱ozxta'ocho ca' bec̱his bosbane'ne' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na' ṉa'a Diosen' ba bnežjue'ne' yeḻa' bala'aṉ xen na' yeḻa' gwnabia' xen cont chnabi'e na' chnežjue' yeḻa' mban toḻi tocaṉe c̱he beṉe' chesejnilaže'ne'. Na' ḻe'na' chazlaže' gaclene' yogo' chio' beṉe' Israel yetiṉjecho xtoḻa'chon' nach yezi'xene' c̱hechon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Neto' ṉezeto' can' ben Diosen' len Jesúsen' na' choe'to' diža' c̱hen, na' ḻecze Spiritw c̱he Diosen' choen' diža' c̱he Jesúsen' ḻo' yic̱hjlažda'oton', ḻe Diosen' ba gwseḻe' Spiritw c̱hen' zoan ḻo' yic̱hjlaždao' beṉe' chosozenag c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na' beseža'achgua beṉe' gwnabia' ca' cate' gosende' can' gož Pedroa' ḻegaque' na' gosaclaže' yesote' postlw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Perw gwzoa to beṉe' fariseo len ḻegaque' beṉe' le Gamaliel. Chsed chlo'ede' beṉe' ley dan' bzoj da' Moisésen' na' gosapchgua beṉe' ḻe' bala'aṉ. Na' Gamalielen' gwzeche' na' bene' mandadw yesechoj postlw ca' chyo'ole šlac güe'lene' beṉe' ca' že'na' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Na' gože' beṉe' ca' že'na': ―Beṉe' gualaž, cheyaḻa' goncho xbab nac goncho len beṉe' quinga cont goncho da' nac güen. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ḻe yosa'laže' can' goc cate' bchoj ben' le Teudas gwne' naque' beṉe' zaque'. Na' do tap gayoa beṉe' bosozenag c̱he' na' gosaque' ḻe' txen. Perw na' bžin ža gosot beṉe' ḻe' na' besyeyasḻas ben' gosaque' ḻe' txen, gague bi gocch yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na' gwdechle ca tiempen' bosoc̱heḻe' baḻ beṉe' že' to to yež, bchoj to beṉe' distritw Galilea ben' le Judas na' beṉe' zan gosaque'ne' txen. Na' ḻecze bžin ža gosote'ne' na' beṉe' ca' gosaque' ḻe' txen ḻecze besyeyasḻase'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na' da'nan' žia' le'e can' chacda' cheyaḻa' goncho, jaseye beṉe' quinga, bibi gonecho ḻegaque'. Ḻe še chososed chosolo'ede' xbab c̱hegacze', yeniten. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na' še dan' chososed chosolo'ede' naquen c̱he Dios, bibi gac goncho cont cbi gaslasen. Cheyaḻa' gwsaca'cho cont bi tiḻlencho Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na' gosazlaže' beṉe' gwnabia' ca' can' gož Gamalielen' ḻegaque'. Nach gosaxe' postlw ca' na' goseyine' ḻegaque' na' gosone' mandadw bich yososed yosolo'ede' c̱he Jesúsen' bate'tezechle. Nach bososane' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na' ca nac postlw ca', cate' besyechoje' gan' gota' yeḻa' güexian', chesyebede', ḻe Diosen' be'e latje bosoc̱hi bososaca' beṉe' ḻegaque' ṉec̱he dan' chososed chosolo'ede' c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na' yogo' ža bososed bosolo'ech postlw ca' c̱he Jesucriston' do liž beṉe' na' cate' chja'aque' yodao' blaona'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na' ca tiempen' zej chanch beṉe' ca' chesejnilaže' Jesucriston' na' beṉe' ca' cheso'e diža' griego gwzolao chesežeše', chesene' no'ol güezeb ca' nc̱hix̱e ḻegaque' bi chesezi'e lebe len no'ole güezeb ca' cheso'e diža' hebreo cate' cheseyise' dan' chese'ej chesagw to togaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nach postlw ca' šižiṉw bosyotobe' yezica'chle beṉe' ca' chesejnilaže' Jesucriston' na' gose'e ḻegaque': ―Bi naquen güen neto' gwsanto' bich gwsed gwlo'eto' beṉe' xtiža' Diosen' cont c̱histo' dan' yese'ej yesagw beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Da'nan' beṉe' migw, ḻe cuej gaže beṉe' ḻježle, beṉe' zoachgua Spiritw c̱he Diosen' len ḻegaque', beṉe' zjanac beṉe' sina' na' beṉe' cheson da' güen, na' ḻe gon ḻo na'gaque' yeseyise' dan' yese'ej yesagw beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na' neto' soateze soato' yoḻ güižto' Diosen' na' gwsed gwlo'eto' beṉe' xtižen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na' gosazlaže' yogo' beṉe' ca' na' gosone' can' gose' postlw ca' ḻegaque', na' gosebeje' to beṉe' le Esteban beṉe' chejnilaže'chgua Diosen' na' zoachgua Spiritw c̱he Diosen' len ḻe'. Na' ḻecze gosebeje' Felipe, na' Prócoro, na' Nicanor, na' Timón, na' Parmenas, na' Nicolás beṉe' ciuda Antioquía ben' bene' txen len beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na' bosozoe' ḻegaque' lao postlw ca' na' postlw ca' bosoḻ güiže' Diosen' c̱hegaque' na' gosex̱oa na'gaquen' yic̱hj beṉe' ca' cont gosezi' ḻo ne'e žin dan' yesonen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na' beṉe' zanch gosende' xtiža' X̱ancho Jesucriston', na' zan beṉe' Jerusalénṉa' gosejnilaže'ne' na' ḻecze zan bx̱oz ca' bosozenague' na' gosejḻe'e xtiže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na' Estebanṉa' gwzoachgua yeḻa' guac c̱he Diosen' len ḻe' na' Diosen' goclenchgüe' ḻe'. Da'nan' bene' yeḻa' guac na' bichle da' zaca' yesyebane beṉe' lao beṉe' ca' že' na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na' zoa to yodao' dan' chesene' Yodao' c̱he Beṉe' ca' Bich Zjanaque' Esclavos. Beṉe' ca' chesedop chesežag yodao'na' za'aque' ciuda Cirene na' ciuda Alejandría na' distritw Cilicia na' distritw Asia. Na' baḻ beṉe' ca' gwzolao gosacyože' len Estebanṉa', ");
INSERT INTO zpqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","perw na' bi besyeželde' nac yosyoži'e xtižen', ḻe Spiritw c̱he Diosen' bnežjon ḻe' yeḻa' sina' na' bzejni'in ḻe' bin' gwne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nach gosego'oyeḻe' to c̱hop beṉe' cont goso'e diža' güenḻaže' c̱he', gosene' Estebanṉa' gwṉeye'e c̱he da' Moisésen' ben' bzoj ley c̱he beṉe' Israel ca'. Na' ḻecze gosene' Estebanṉa' gwṉe' diža' ya' c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na' beṉe' ca' gosacyože' c̱he Estebanṉa' bosota bosoṉe' beṉe' ḻo ciuda na' beṉe' gole blao c̱he beṉe' Israel ca' na' beṉe' ca' chososed chosolo'ede' ley dan' bzoj da' Moisésen' cont gosaque' toze. Na' ja'acsese' gan' zoa Estebanṉa' na' gosezene'ne' na' gosec̱he'ene' gan' že' beṉe' ca' chesenabia' nación Israelen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na' goseyiljue' beṉe' goso'e diža' güenḻaže' beṉe' gosene' c̱he': ―Benga bicze šize zoe' chṉe' diža' bya' c̱he yodao' blao c̱he Diosen' nga na' ley dan' bzoj da' Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ba beneto' že' Jesús ben' naque' beṉe' yež Nazaret yoc̱hiṉje' yodao' blaona' na' yoše'e costumbr c̱hecho dan' ben da' Moisés mandadw na'ocho. ");
INSERT INTO zpqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na' yogo' beṉe' ca' zjachi' gan' chesone' yeḻa' justisen' goseṉe'e cho'alao Estebanṉa' na' besele'ede' chactiten ca cho'alao angl. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nach ben' nacch bx̱oz blaona' gože' Estebanṉa': ―¿Naquen can' chesena beṉe' quinga? ");
INSERT INTO zpqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na' Estebanṉa' gože' ḻegaque': ―Le'e beṉe' gole na' note'teze beṉe' gualaž, ḻe gwzenag c̱hia' len to c̱hop da' ṉia' le'e. Diosen' ben' nac ḻa'zelagüe beṉe' zaca' blo'elagüe' da' x̱ozxta'ocho Abraham cate' gwzoe' distritw Mesopotamia cate' za' šjasoe' ciuda Harán. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na' Diosen' gože'ne': “Bchoj lažo' na' gwlejyic̱hj beṉe' biše' ḻježo' na' gwyej jasoa latje gan' gwlo'eda' le'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Beyož gož Diosen' Abrahanṉa' ca', nach Abrahanṉa' bchoje' gan' že' beṉe' Caldea ca' na' jasoe' Harán. Na' bžin ža got da' x̱e'na' na' gwdechle Diosen' gwc̱he'e da' Abrahanṉa' gan' zoacho nga. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Diosen' bi bnežjue' da' Abrahanṉa' yežlio gaquen c̱he', ṉe late' da'ozen', san gwne' gaquen c̱he xi'iṉ diaža c̱he' cate' ba gote', ḻa'czḻa' nono xi'iṉe' ṉa' soa cate' gož Diosen' ḻe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nach Diosen' gwne' šjasenite' laž beṉe' zito' tap gayoa iz ga yesaque' esclavos na' yesežaglaochgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nach Diosen' ḻecze gože'ne': “Neda' gwnežjua' castigw c̱he nación gan' yesone' xi'iṉ diaža c̱hio' ca' esclavos na' gona' cont yesyechoje' naciónṉa' na' yeside' yesonxene' neda' nga.” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nach Diosen' gože' Abrahanṉa' gone' güen len xi'iṉ diaža c̱he'na'. Na' bene' mandadw soa Abrahanṉa' to señw dan' že' circuncisión, ḻe' na' len beṉe' byo ca' zjanaque' diaža c̱he', cont gacbia' ḻe chesejḻe'e c̱he dan' gwna Diosen'. Da'na'na' cate' goḻje xi'iṉe' Isaaquen' bzoe'be' señw to xmanzebe', na' ḻecze can' ben da' Isaaquen' cate' gol je xi'iṉe' Jacob. Na' ca'cze ben da' Jacoben' len da' xi'iṉe' ca' šižiṉw, beṉe' ca' gosac šižiṉw diaža c̱he beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Na' xi'iṉ da' Jacoben' ben' le José, beṉe' biše' ca' gosacxi'ede' ḻe' na' gosote'ne' gosezi' beṉe' nación Egipto ḻe'. Perw Diosen' gwzoe' len Josén'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Na' goclene'ne' len yogo'ḻoḻ da' bžaglagüe'. Na' Diosen' bene' cont da' faraón ben' chnabia' Egipton' bebede' Josén' na' gocbe'ede' naque' beṉe' sina'. Na' da'nan' faraónṉa' gwleje' ḻe' cont goque' gobernador c̱he nación Egipton' na' bene' ḻo ne'e ližen' na' yežlio c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Na' goc gwbin doxen Egipton' na' ḻecze can' goc gan' nzi' distritw Canaán na' da' x̱ozxta'ocho ca' bi beseželde' da' yesagüe' na' besežaglaochgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Perw na' bžin ža da' Jacoben' bende' diža' de trigw Egipton' na' gwseḻe' da' x̱ozxta'ocho ca' jasexi'en da' nechw. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na' bechop ṉi'a ja'aque' cate' ben Josén' ga besyeyombia' beṉe' biše' ca' ḻe', nach gwṉeze faraónṉa' can' nac diaža c̱he Josén'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na' Josén' bene' mandadw šjasexi'e x̱agaque' Jacoben' na' yogo'ḻoḻ biše' ḻježe' ca', zjanaque' ca do gayonšino' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Can' goc gwyej Jacoben' jasoe' Egipton' na' Egiptona' gote', na' ḻecz na' gosat xi'iṉe' ca' beṉe' ca' gosac x̱ozxta'ocho. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na' gwdechle besyeyo'e žit benat c̱hegaquen' na' jasecuaše'ne' to ḻo' bloj ba da' gosone' yež gan' nzi' Siquem. Da' Abrahanṉa' gwxi'e ban' cani'te c̱he xi'iṉ da' Hamor gwdixjuen' mechw. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Na' cate' ba zoa žin tiemp gwnežjo Diosen' ḻegaque' yežlio can' gože' Abrahanṉa', ba zej chan beṉe' Israel ca' že' laž beṉe' Egipto ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na' ca' chac beža' rey c̱he Egipton' na' rey coben' bi gwṉezde' can' goclen Josén' nación c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na' rey nga gwdiljwlaže' bi da' mal bene' len da' x̱ozxta'ocho beṉe' Israel ca' na' bene' mandadw šjasecho'oṉ xi'iṉgaque'na' cont yesatbe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na' ca tiempen' golje da' Moisésen' na' bebe Diosen' ḻebe', na' x̱axṉa'be' bososc̱ha'ogüe'be' šoṉe bio'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Perw na' bžin ža jasecho'oṉšaze'be' na' xi'iṉ faraónṉa' to no'ole beželde'be' na' beyo'ebe' liže' bosc̱ha'ogüe'be' ca xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ca' goquen' bsed da' Moisésen' tcho'a yeḻa' sina' c̱he beṉe' Egipto ca' na' bene' da' zaca' na' be'e diža' da' zaca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Na' c̱hoa ize da' Moisésen' cate' gwnan šjaṉe'e beṉe' Israel gualaž c̱he' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na' jale'ede' to beṉe' Egipto chc̱hi chsaque' to beṉe' Israelen'. Nach da' Moisésen' betue' beṉe' Egipton', boži'e da' malen' bende' beṉe' gualaž c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Bene' xbab gocde' yesacbe'e beṉe' gualaž c̱he' chaclen Diosen' ḻe' cont yosle' ḻegaque' ḻo na' beṉe' Egipto ca', perw bi gosacbe'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na' beteyo gosediḻ c̱hopze beṉe' Israel. Na' bžin da' Moisésen' gocde' gone' cont yesenite' binḻo, na' gože' ḻegaque': “¿Bixc̱hen' chdiḻlen ḻježle le'e nacle beṉe' gualažze?” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nach ben' nap doḻa'na' bžigue' da' Moisésen' ca'ale gože'ne': “¿No gwna le' gaco' beṉe' gwnabia' cont gono' yeḻa' justis c̱heto'na'? ");
INSERT INTO zpqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ḻez chaclažo' goto' neda' can' beto' beṉe' Egipton' ṉeje?” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na' cate' bene da' Moisésen' can' gož bena' ḻe' nach bxoṉje' jasoe' nación gan' nzi' Madián ḻa'czḻa' naque' beṉe' zito' len beṉe' ca'. Na' bšagne'e na' gwnita' c̱hope xi'iṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Na' goc c̱hoa iz zoe' na', cate' to angl beṉe' gwseḻa' Dios blo'elagüe' ḻe' latje dašen' gaḻa'ze Ya'a Sinaí, yo'o anglen' to ḻo' yi' beḻ chdoḻjen to ḻo' yag xis yeše'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Na' cate' ble'e da' Moisésen' can' chaquen' bebande' nach gwbigue' yelate' cont ble'ešagüe'de' na' bende' choḻ güiž X̱ancho Diosen' ḻe', che'ene': ");
INSERT INTO zpqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Neda' naca' Dios ben' chonxen Abraham, ben' chonxen Isaac, na' ben' chonxen Jacob.” Nach da' Moisésen' gwxize' catec bžebe', gague cheyaxjde' ṉe'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na' gož X̱anchon' ḻe': “Gwḻec̱hj xelo'na' cont gapo' neda' bala'aṉ, ḻe latje gan' zechao'na' naquen c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Neda' ba ble'eda' yeḻa' yaše' yeḻa' zi' da' chde nación c̱hia' Israelen' beṉe' že' Egipton' na' ba benda' ca chesonyaše'. Da'na'na' gaclena' ḻegaque'. Beda ṉa'a cont seḻa' le' Egipton'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Diosen' gože'ne' ca' ḻa'czḻa' beṉe' Israel ca' cbi gosezi'e c̱he', gose'e Moisésen': “¿No gwna le' gaco' beṉe' gwnabia' cont gono' yeḻa' justis c̱heto'?” Diosen' gwseḻe' da' Moisésen' cont gwnabi'e da' x̱ozxta'ocho ca' na' cont bebeje' ḻegaque' ḻo na' beṉe' Egipto ca', na' angl c̱he Diosen' ben' ble'e da' Moisésen' ḻo' yi' beḻ gwzoe' goclene'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na' da' Moisésen' bebeje' ḻegaque' Egipton' gan' bene' zan yeḻa' guac na' bichle da' zaca' yebane beṉe', na' ḻecz ca' bene' cate' besežine' Nisdao' Xṉan' na' šlac gosenite' latje dašen' c̱hoa iz. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na' da' Moisésnan' gože' da' x̱ozxta'ocho ca': “X̱ancho Diosen' seḻe' yeto beṉe' gualaž c̱hechon' cont güe'lene' le'e xtiže'na' can' gwseḻe' neda'. C̱he benan' gwzenagle.” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Da' Moisésen' gwzoe' len da' x̱ozxta'ocho ca' latje dašen', na' ḻo Ya'a Sinaín' to angl beṉe' gwseḻa' Diosen' gože' ḻe' diža' da' zjansa' yeḻa' mban, na' bzoje' dižan' par chio'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Perw na' da' x̱ozxta'ocho ca' zan las bi bosozenague' c̱he da' Moisésen', bosozoe'ne' to šḻa'ale. Gosaclaže' šjaya'aque' Egipton'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na' šlac zej da' Moisésen' ḻo Ya'a Sinaí, gose'e beṉe' biše' Aarónṉa': “Ben da' le'echo da' šejnilaže'cho na' da' cuialao laocho tnez. Ḻe ca nac Moisésen' ben' bebej chio' Egipton', nono ṉeze bin' ba goc c̱he'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nach gosone' to me' go'ṉ dao' de oro na' gosote' no beyix̱e' gosonxene' me' daon', na' gosone' ḻṉi c̱he bena' gosone' len ṉi'a na'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Da'nan' Diosen' gwlejyic̱hje' nación Israelen' na' be'e latje gosejnilaže' gwbiž, bio', na' beḻjw. Na' da' nga nyojen len dan' bosozoj da' beṉe' ca' goso'e xtiža' Diosen' cani', žan: Le'e beṉe' Israel, gague nedan' benxenḻe caten' betwle beyix̱e' latje dašen' lao c̱hoa iz. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Benḻe no da' benxenḻe, na' bia'le yodao' da' chacte chedobe gan' benxenḻe dan' nzi' Moloc, na' bia'le beljon' benxenḻe dan' nzi' Renfán. Na' dan' ba gwlejyic̱hjle neda', da'nan' cueja' le'e gan' zoalen' na' seḻa' le'e nación zito' do gan' nzi' Babilonia. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Na' šlac chesaše' latje dašen', da' x̱ozxta'ocho ca' gosone' to yodao' da' chacte chedobe gan' že' yej ta'a gan' nyoj ley c̱hegaque'na'. Na' gosonen' con can' gož Diosen' da' Moisésen' na' con can' blo'ede' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nach cate' da' Josué gwc̱he'e ḻegaque' gan' ben Diosen' cont goseque'e yežlio c̱he beṉe' zito' ca', ḻecze goso'e yodao' da' chacte chedobe. Na' ṉe' bosoc̱hine' yodaon' bžinten tiemp c̱he da' rey David. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na' Diosen' bebede' da' rey Davin', na' da' Davin' goclaže' gone' to yodao' c̱he Diosen', Dios ben' ḻecze benxen da' Jacoben' cani'te. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Perw na' da' xi'iṉe' Salomón benen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Na' Diosen' ben' chnabia' doxen, bi ṉacho zoe' ḻo' yo'o da' chon beṉac̱hen', san chac can' gwna Diosen' dan' bzoj to beṉe' be' xtiže'na' cani', žan: ");
INSERT INTO zpqNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Neda' zoa' yaba chnabia', na' guac gona' con bi chazlaža' ḻo yežlion'. Na' ¿chaquele gonḻe to liža'na'? Neda' bi chyažjda' yo'o ga yezi'laža'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Neda' bena' yogo'te da' zjade. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Dan' bi chzenagle, dan' bi chejḻe'le ḻo' lažda'olen' nacchguale beṉe' güedenag can' gosac da' x̱ozxta'ocho ca'. Bicze chzenagle c̱he Spiritw c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Da' x̱ozxta'ocho ca' ḻecze bosoc̱hi bososaque' beṉe' ca' goso'e xtiža' Diosen' cani', na' gosote' ḻegaque' caten' goso'e diža' can' seḻa' Diosen' Xi'iṉe' ben' nac beṉe' güen juisyw. Na' cate' bide', le'e bdelne' ḻo na' beṉe' ca' gosote'ne' na' le'e naple doḻa' dan' gosote'nen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ḻa'czḻa' nombia'le ley dan' bosonežjw angl ca' da' Moisésen', bi chzenagle c̱hen. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na' cate' Esteban' gože' ḻegaque' ca', beselocchgüe' gosagwxejte ḻaye'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Perw na' Esteban' gwzoachgua Spiritw c̱he Diosen' len ḻe', bcos lagüen' gwṉe'e yabale na' ble'ede' chac to be'ni' gual gan' zoa Diosen' na' ble'ede' zecha Jesúsen' cuit Diosen' chnabi'e txen len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nach Estebanṉa' gwne': ―Ḻe ṉa'šc nḻa'xeje yaban' na' nḻa' Jesúsen' ben' golje' beṉac̱h zeche' cuit Diosen' chnabi'e txen len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nach beṉe' ca' zjanžaguen' ḻeca beseloque' na' bososya'adie' na' bososeyjw naggaque'na' na' to ši'ize ja'acsese' gan' ze Estebanṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nach gosebeje' Estebanṉa' cho'a yež na' bosožie'ne' yej. Na' beṉe' ca' bosožie' ḻe' yejen' bosonežjue' xagaque' da' zjandobe' to beṉe' xcuide' beṉe' le Saulo cont gapen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na' šlac chosožie' Estebanṉa' yej, Esteban' boḻ güiže' Diosen', gwne': ―X̱ana' Jesús, bezi' neda' yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nach bzoa xibe' ḻo yon' na' gwṉe' zižje, gwne': ―X̱ana' bi gono' cuent xtoḻa' beṉe' quinga dan' chesote' neda'. Na' beyož gwne' ca', gote'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Na' ca nac Saulon', gwyazlaže' dan' gosote' da' Estebanṉa'. Na' beṉe' ca' chesejnilaže' Jesucriston' ciuda Jerusalénṉa' jasecuaše' da' Estebanṉa', na' gosebežchgüe' c̱he'. Na' gwde gosote' da' Estebanṉa' gosezolagüe' bosoc̱hi bososaque' beṉe' ca' chesedop chesežag chesonxene' Jesucriston' Jerusalénṉa', na' yogo' beṉe' ca' chesonxen Jesucriston' besyeyasḻase', ja'aque' yež ca' zjachi' do distritw Judean', do distritw Samaria, perw gague len postlw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na' Saulon' gwzolagüe' cheje' liž to to beṉe' ca' chesonxen Jesucriston' chjax̱obe' no beṉe' byo na' no no'ole cont chc̱he'e ḻegaque' ḻižya. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na' beṉe' ca' chesonxen Jesucriston' ben' besyeyasḻase' ja'aque' doxen, jasedix̱jue'ede' xtiža' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na' ben' le Felipe bžine' ciuda Samarian' na' be'e diža' c̱he Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na' cate' gosende' xtižen' na' besele'ede' yeḻa' guac dan' bene' len ḻegaque', beṉe' zan besedobe' bosozenague' c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bebeje' da' x̱igüe' ca' zjayo'o zjanyaz yic̱hjlaždao' beṉe' zan, na' cate' besyechojen chososya'adian. Na' zan beṉe' natzi' late' güeje cuerp c̱hegaque'na' beyone' ḻegaque', ḻecze beyone' no beṉe' nxiṉj ṉi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na' besyebechgüe beṉe' ca' že' ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na' ḻo ciudan' zoa to beṉe' guaža' beṉe' le Simón. Da' zan da' bene' da' besyebane beṉe' Samarian' gwziye'e ḻegaque' gože'ne' naque' beṉe' zaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na' šlac bene' da' ca', yogo' beṉe' ḻo ciudan' bosozenague' c̱he' tcho'a, no beṉe' gole ca' lente no bi' xcuide' ca', gosene' c̱he': ―Ḻe bengan' nse'e yeḻa' guac xen c̱he Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Zan iz bosozenague' c̱he', ḻe gwziye'e ḻegaque' len yeḻa' guaža' c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Perw cate' Felipen' gwdix̱jue'ede' diža' güen c̱he Jesucriston' len ḻegaque' na' bzejni'ide' ḻegaque' c̱he yeḻa' chnabia' c̱he Diosen', zane' gosejḻe'e c̱he' na' gosezoe' nis, beṉe' byo na' no'ole. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na' lencze Simón gwyejḻe'e c̱he' na' gwzoe' nis na' gwzolaogüe' gwdalene' Felipen', na' bebande' ca nac yeḻa' guac ca' dan' chon Felipen' na' yezica'chle da' zaca' yebanecho. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na' postlw ca' nite' ciuda Jerusalénṉa' gosende' beṉe' ca' že' ciuda Samaria ba chosozenague' xtiža' Diosen', nach goseseḻe' Pedroa' len Juanṉa' Samarian'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Na' cate' besežine'na' bosoḻ güiže' Diosen' goseṉabde'ne' soa Spiritw c̱hen' ḻo' yic̱hjlaždao' beṉe' Samaria ca', ḻe ca hora' biṉa' soan ḻo' lažda'ogaque' ḻa'czḻa' ba gosezoe' nisen' dan' chesejnilaže' X̱ancho Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nach gosex̱oa na' postlw ca' yic̱hjgaque' cont gwzoa Spiriton' ḻo' yic̱hjlažda'ogaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na' ble'e Simón can' cheson postlw ca' chesex̱oa ne'e yic̱hj beṉe' cont chzoa Spiriton' len ḻegaque', na' bšabde' ḻegaque' mechw. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Gože' ḻegaque': ―Ḻe gon cont neda' gac x̱oa na'a yic̱hj note'teze beṉe' na' soa Spiriton' len ḻegaque' can' chon le'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nach Pedroa' gože'ne': ―Cuiayo'o len xmechon' dan' chono' xbab guac si'o len mechw da' choṉ Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bi zaco' gono' da' nga chonto', ḻe yic̱hjlažda'oguo' naquen mal lao Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Da' cheyaḻa' gono', betiṉje da' malen' chono' na' gwṉab goclen lao Diosen' cont yezi'xene' c̱hio' ca nac xbaben' yo'o ḻo' yic̱hjlažda'oguon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nacbia' da' mal dan' yo'o ḻo' yic̱hjlažda'oguon' chnabi'an le' na' ngo'on le' nez malen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nach Simónṉa' boži'e xtižen' gože' ḻe': ―Ḻe ṉab goclen lao X̱anchon' cont ṉe to da' mal dan' bac̱h gwnao' nga bi gac c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na' Pedroa' len Juanṉa' cate' beyož goseyix̱jue'ede' xtiža' Diosen' ḻo ciuda Samarian' na' beyož goso'e diža' can' ba goclen X̱ancho Jesucriston' ḻegaque', nach jaya'aque' Jerusalénṉa'. Na' šlac zjaya'aque'na' goseyix̱jue'ede' xtiža' X̱ancho Jesucriston' len beṉe' ca' že' yezica'chle yež ca' gan' mbane distritw Samaria. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nach X̱ancho Diosen' gwseḻe' to angl beṉe' gože' Felipe: ―Gwyej gan' xoa nez dan' chetj Jerusalénṉa' na' chden latje dašen' chžinen yež dan' nzi' Gaza. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nach Felipe gwlo'e nezen', na' šlac zeje' ble'ede' to beṉe' nación Etiopía zeyo'e to ḻo' carret zeze'e gwyeje' Jerusalénṉa' jenxene' Diosen'. Ḻe' naque' to beṉe' blao na' ba none' ḻe' capar cont gone' xšin no'ole gwnabia' c̱he beṉe' Etiopía ca', šo'o ḻo ne'e mechw c̱he'. Na' no'ole gwnabian' le' Candace. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Na' ben' yo'o ḻo' carreten' chlabe' libr dan' bzoj da' Isaíasen' ben' be' xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nach Spiritw c̱he Diosen' gožen Felipen': ―Jayxen carreten' na' gwyejlene' txen. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nach gwza'ses Felipen' cont jayxene' carreten' na' cate' bžine' gaḻa'ze bende' chlab ben' libr dan' bzoj da' Isaíasen'. Nach gože'ne': ―¿Chejni'ido' dan' chlabo'na'? ");
INSERT INTO zpqNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na' beṉe' Etiopían' boži'e xtižen' gože' Felipen': ―¿Nacxe gac šejni'ida' da' ngan', ḻe gague no nḻa' no gwzejni'ide' nedan'? Nach gota'yoede' Felipen' cont gwyo'e ḻo' carreten' gwche'lene'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na' gan' chlabe'na' nyojen žan: Ca to xila' be nxob beṉe' cont gote'ba', na' ca to xila' dao' be bi chosya'a cate' chšibe'ba', can' bene', bibi gwṉe' caten' gosezi' gosebague'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na' gosone' ḻe' ca to beṉe' bibi zaca'. Na' bi gosone' yeḻa' justis c̱he' ca cheyaḻa' gaquen. Na' nono diaža c̱he' nita', ḻe goseque'e yeḻa' mban c̱he' ḻo yežlio nga. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nach beṉe' Etiopían' gože' Felipen': ―Benšca goclen gwna neda' no c̱hen' ža ben' bzoj Xtiža' Diosen' ca', ¿c̱he cuinen' že' ca' o še c̱he beṉe' yoble? ");
INSERT INTO zpqNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nach Felipen' gwzolagüe' bzejni'ide' bi zejen dan' chlab beṉe' Etiopían', gože' ḻe' diža' güen c̱he Jesúsen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na' ca' chac, besežine' ga žia nis, nach bena' gože' Felipen': ―Nga žia nis, ¿cbi gac soa' nisen' ṉa'a? ");
INSERT INTO zpqNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nach Felipen' gože'ne': ―Še chejnilažo' Jesucriston' do yic̱hj do lažo', guac so' nisen'. Nach gwne': ―Chejḻi'a Jesucriston' naque' xi'iṉ Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nach bene' mandadw bcueze' carreten' na' betj Felipen' len beṉe' Etiopían' jasežo'e ḻo' nisen' cont Felipen' bzoe'ne' nis. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na' cate' besyechoje' ḻo' nisen', Spiritw c̱he Diosen' ḻa' bec̱he'eten Felipen' ga yoble, na' bich ble'e beṉe' Etiopían' ḻe'. Na' mbalaz beza' ben' beyo'e ḻo' carreten'. ");
INSERT INTO zpqNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nach Felipen' bžine' yež dan' nzi' Azoto na' gwzolagüe' gwdix̱jue'ede' diža' güen c̱he Jesucriston' to to yež da' zjachi' gaḻa'ze ga gwdie' bžinte' Cesarean'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na' Saulon' con chdacze' cho'e diža' can' chaclaže' gote' beṉe' chesejnilaže' X̱ancho Jesucriston' na' chdacze' cheyiljwlaže' nacle gone' gote' ḻegaque'. Na' da'nan' Saulon' gwyeje' lao bx̱oz blao c̱he beṉe' Israelen', ");
INSERT INTO zpqNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na' gwṉabde'ne' gwzoje' to yiš da' gox̱e' yosolab beṉe' že' to to yodao' nita' ciuda Damasco cont yeseṉezde' nape' yeḻa' gwnabia' sene' beṉe' ca' ba chesejnilaže' Jesucriston' na' gwc̱heje' ḻegaque' cont c̱he'e ḻegaque' ciuda Jerusalénṉa' ḻa'czḻa' beṉe' byo o ḻa' no'ole. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Cate' beyož bnežjue'ne' yišen' gwlo'e nez, na' ba zoa žine' ciuda Damascon' cate' zejzenez to be'ni' da' za' yaban' gwyec̱hjen ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na' gwbix̱e' ḻo yon'. Na' bende' che' to beṉe' ḻe': ―Saulo, ¿bixc̱hen' chc̱hi chsaco' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na' Saulon' boži'e xtižen' gože' ḻe': ―¿No le' beṉe'? Nach bena' gože'ne': ―Nedan' Jesús ben' chc̱hi chsaco'. Na' dan' chgue'edo' neda', chone zi' cuino' can' chac c̱he to go'ṉ be chlibe ḻo ya dan' zoa ḻo carroš c̱heba'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na' do chaž chžebze' gože' ḻe': ―X̱ana' Jesús, ¿bin' chaclažo' gona'? Nach X̱anchon' gože'ne': ―Beyas na' gwyej ciuda Damascon' na' zoa to beṉe' ye'e le' da' cheyaḻa' gono'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na' beṉe' ca' zja'aclen Saulon' benit bec̱hoḻ gosac ḻo' yic̱hjlažda'ogaque'na' catec besežebe' dan' goquen', ḻe gosende' ši'i beṉe' perw nono besele'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nach beyas Saulon', perw cate' bex̱a' lagüen' con bich ble'ede'. Nach beṉe' ca' nžague'na' gosox̱e' ne'e gosec̱he'ene' Damascon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na' šoṉe ža gwzoe' sin cbi ble'ede' na' bi güe'ej gwdagüe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na' zoa to beṉe' chejnilaže' X̱ancho Jesucriston' Damascon' beṉe' le Ananías, na' Ananíasen' ble'edagüede' X̱anchon'. Na' X̱anchon' gože'ne': ―Ananías. Na' boži'e xtižen' gwne': ―Nga zoa', X̱ana'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nach X̱anchon' gože'ne': ―Gwzoža' na' gwyej liž Judas dan' zoa cay dan' chesene' Nez Ḻicha, na' ṉabo' to beṉe' le Saulo, to beṉe' ciuda Tarso. Ba choḻ güiže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na' ba bena' cont ble'edagüede' le' gwyo'o gan' zoe'na' na' gwx̱oa nao' yejlagüe'na' cont yele'ede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nach Anaíasen' boži'e xtižen' gože' ḻe': ―X̱ana', ba benda' beṉe' zan cheso'e xtiža' bena', ca nac da' mal juisyw ba bene' Jerusalén len beṉe' ca' ba gwlejo' cont zjanaque' ḻo nao'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na' chesene' ze'e nga nox̱e' yiš c̱he bx̱oz gwnabia' ca' cont sene' yogo'ḻoḻ neto' chejnilaže'to' le'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nach X̱ancho Jesucriston' gože' Ananíasen': ―Gwyej, ḻe ba gwleja' Saulon' cont šjazejni'ide' xtiža' len beṉe' cbi zjanac beṉe' Israel na' len rey c̱hegaque' ca', na' lente le'e nacle beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na' gwlo'eda'ne' ca nac da' yaše' da' zi' da' gac c̱he' dan' gwzenague' c̱hia'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nach Ananíasen' gwyeje' gan' zoa Saulon' na' gwyo'e ḻo' yo'ona' na' gwx̱oa ne'e yejlao Saulon', gože'ne': ―Beṉe' migw Saulo, X̱ancho Jesúsen' ben' blo'elagüe' le' tnez gan' za'ona' ba gwseḻe' neda' zedeṉa'a le' cont yele'edo' na' soa Spiritw c̱he Diosen' len le'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nach ḻa' besyeyiṉjte da' ca' že' ḻo yejlagüen', zjanaquen ca yid bdi'ej, na' ḻa' bele'etede'. Nach gwzože'e cont gwyeje' gan' gwzoe' nisen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ca beyoža' gwdagüe' na' beyaclaže'. Na' bega'aṉe' Damascon' yeto c̱hop ža len beṉe' ca' chesejnilaže' X̱anchon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na' ḻa' gwzolaote gwyeje' to to yodao' be'e diža' c̱he Jesúsen', gwne' ḻen' naque' Xi'iṉ Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na' yogo' beṉe' ca' chesende' xtiže' dan' cho'ena' besyebande' na' chese' ḻježe': ―¿Gague bengan' chda choṉit choḻane' beṉe' ca' chesejnilaže' Jesúsen' ciuda Jerusalénṉa'? na' ¿gague da' na'czen' bide' nga ṉa'a cont gwc̱heje' beṉe' ca' na' šjasane' ḻegaque' lao bx̱oz gwnabia' ca'? ");
INSERT INTO zpqNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na' Saulon' tža tža Diosen' goclene'ne' cont be'e diža' c̱he Jesúsen' tcho'a, gwne' Jesúsen' naque' ben' gwseḻa' Diosen' cont ṉabi'e. Na' beṉe' Israel ca' že' Damascon' bi beseželde' bin' yeseṉe', ḻe gosacbe'ede' dan' che'e ḻegaque' naquen da' ḻi. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na' cate' ba goc sša choe'len Saulon' beṉe' Damasco ca' xtiža' Jesucriston' nach bosoxi'a beṉe' Israel ca' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Na' gosenite' chesape' to to cho'a puert c̱he ze'ena' dan' nyec̱hj ciudan' cont yesezene' Saulon' yesote'ne' bate'teze choje', perw na' Saulon' gocbe'ede' ba zjachi'na'ogüe'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na' beṉe' ca' chesejnilaže' Jesucriston' besyeletje'ne' ḻe'e ze'e dan' nyec̱hj ciudan' šeže'le besyegüe'ene' to ḻo' žome cont goc bechoje' ḻo ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nach beze'e beyeje' Jerusalén. Na' cate' bežin Saulon' ciuda Jerusalénṉa' goclaže' gone' txen beṉe' ca' chesejnilaže' Jesucriston', perw yogo'ḻoḻe' besežebe' ḻe', bi gosejḻe'e še da' ḻi ba chejnilaže' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nach Bernabé gwc̱he'e Saulon' ja'aque' gan' že' postlw ca' na' be'lene' ḻegaque' diža' can' goc ble'e Saulon' X̱ancho Jesúsen' šlac ngüe'e nez zeje' Damascon' na' can' goc X̱anchon' be'lene' Saulon' diža'. Na' ḻecze gož Bernabén' ḻegaque' Saulon' ba be'e xtiža' Jesúsen' Damascon' sin cbi bžebe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nach postlw ca' gosejḻe'e can' goc c̱he Saulon', na' gwzolao gwdalen Saulon' beṉe' ca' chesejnilaže' Jesucriston' Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na' sin cbi bi chaž chžebe' gwzolagüe' chzejni'ide' beṉe' Israel ca' diža' c̱he X̱ancho Jesúsen', con beṉe' chesac diža' griego. Bene' byen bzejni'ide' ḻegaque' xtiža' Diosen', perw na' ḻegaque' gosaclaže' yesote'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na' cate' beṉe' ca' chesejnilaže' Jesucriston' Jerusalénṉa' gosacbe'ede' ba zjachi'na'ogüe' yesote'ne', nach gosec̱he'ene' ja'aque' ciuda Cesarea na' besyeseḻe'ne' ciuda Tarso. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na' beṉe' ca' chesedop chesežague' chesonxene' Jesucriston' doxen distritw Judean', distritw Galilean' na' distritw Samarian' gosenite' binḻo, noch no bosoc̱hi bososaca' ḻegaque', na' gosenita'c̱hac̱he' gosejnilaže' X̱ancho Jesúsen' na' bosozenague' c̱he' do yic̱hj do laže'gaque'. Na' Spiritw c̱he Diosen' benen cont gosacc̱hac̱h laže'gaque' na' benen cont gwyane'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ca nac Pedroa' cheje' to to yež gan' že' beṉe' ca' ba gwlej Diosen' cont zjanaque' ḻo ne'e chjaṉe'e ḻegaque'. Na' to ža gwyeje' jaṉe'e beṉe' ca' že' yež dan' nzi' Lida. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na' yež Lidan' jati'e to beṉe' le' Eneas. Ba chac x̱ono' iz de' che'ede', natzi' late' cuerp c̱he'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nach gož Pedroa' ḻe': ―Eneas, Jesucriston' cheyone' le'. Gwyas na' btob xcamo'na'. Nach ḻa' gwyaste bena'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na' yogo'ḻoḻ beṉe' že' Lidan' na' beṉe' že' yež dan' nzi' Sarón besele'ede' bena' ba beyacde' na' gosebejyic̱hje' costumbr c̱hegaque' cont gosejnilaže' X̱ancho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na' ca tiemp na', to ciuda dan' nzi' Jope zoa to no'ole le' Tabita, na' diža' griego le' Dorcas. Na' chejnilaže' Jesucriston' na' zoe' chone' da' güen na' chaclene' no beṉe' yaše' beṉe' chyažj chc̱hine'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Perw na' gocšene Dorcasen' na' gottechgüe', na' bosoguazje'ne' na' gosex̱oe'ne' to ḻo' cuart da' zoa yic̱hj yo'o cha'te. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na' gaḻa'ze chega'aṉ yež Lidan' len Jopen', na' beṉe' ca' chesonxen Jesucriston' Jopen' goseṉezde' Pedroa' zoe' Lidan'. Nach goseseḻe' c̱hope beṉe' jasata'yoede' Pedroa' gose'ene': ―Benšca goclen yo'o len neto' ṉetec ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na' Pedroa' ḻa' gwza'te' gwyeje' len beṉe' ca'. Na' cate' besežine' Jopen', gosec̱he'ene' ḻo' yo'o gan' xoa beṉe' guaten', na' ḻa' gosebiga'te yogo' no'ol güezebe lagüe'na' chesebeže' chosolo'ede' ḻe' lache' dan' ben da' Dorcasen' šlac gwbane', no vestidw na' no camis. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nach Pedroa' bešaše' yogo'ḻoḻ beṉe' ca' chyo'ole na' bzoa xibe' boḻ güiže' Diosen'. Na' beyec̱hje' chṉe'e cuerp c̱he no'olen', na' gože'ne': ―Tabita, gwyas. Nach ḻa' bex̱a'te yejlao da' Dorcasen' gwṉe'e Pedroa' na' ḻa' bebe'te'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nach Pedroa' bex̱ue' ne'ena' bsože'e ḻe', nach goxe' no'ole güezeb ca' na' yezica'chle beṉe' ca' zjanaque' ḻo na' Diosen' na' blo'ede' ḻegaque' ba beban Dorcasen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na' yogo'ḻoḻ beṉe' Jopen' gosende' can' goquen', na' beṉe' zanch gosejnilaže' X̱ancho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na' Pedroa' bega'aṉe' Jopen' zan ža, gwzoe' liž to beṉe' le Simón, beṉe' chonšagüe' yid. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na' ciuda Cesareana' zoa to beṉe' le Cornelio, naque' x̱an to gayoa soldadw, na' bosozoa la soldadw c̱he' ca' Beṉe' Italia. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ḻa'czḻa' Cornelion' cbi naque' beṉe' Israel, benxene' Diosen', na' ḻecze ca' goson beṉe' ḻo' yo'o c̱he', chesezoe' chesape' Diosen' bala'aṉ. Na' Cornelion' chaclenteze' beṉe' Israel beṉe' chyažj chc̱hine', na' zoateze' choḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na' goc c̱he', to ža do cheda šoṉe ble'edagüede' to angl beṉe' gwseḻa' Diosen' gwyo'e gan' zoe'na', na' anglen' gože'ne': ―Cornelio. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nach Cornelion' chṉa'chgüe' lao anglen' na' do chžebe' gože'ne': ―¿Bixen' X̱ana'? Nach gož anglen' ḻe': ―Diosen' ṉezde' can' zo' choḻ güižo'ne' na' chnežjo' dan' cheseyažje beṉe' yaše', na' Diosen' chaclaže' gaclene' le'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Da' nga gono' ṉa'a, gwseḻa' beṉe' šjasexi'e to beṉe' zoa ciuda Jopen' beṉe' le Simón na' ḻecze le' Pedro. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zoe' liž to beṉe' chonšagüe' yid. Bena' ḻecze le' Simón, na' liž ben' zoan cho'a nisdao'. Na' Simón Pedroa' ye'e le' bin' cheyaḻa' gono'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cate' beza' anglen' Cornelion' goxe' c̱hope mos c̱he' na' to soldadw beṉe' chaclen ḻe', na' soldadoa' ḻecze chonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na' Cornelion' bzejni'ide' ḻegaque' yogo'ḻoḻte can' goquen' nach gwseḻe' ḻegaque' Jopen'. Na' gosegüe'e nez zja'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na' beteyo gaḻa'ze ba zja'aque' za' yesežine' ciuda Jopen' cate' Pedroa' gwloe' yic̱hjo'o c̱he yo'o gan' zoe'na' ca do guagwbiž cont jeḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Na' šlac choe'lene' Diosen' diža' gwdonchgüe', con goclaže' gagüe' cate. Na' šlac chac dan' gagüe'na', ble'edagüede' ḻe'e yaban' chetj to lache' xen na' nchej tap squinen na' chetjen gan' zoe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na' ḻo'enṉa' zjaže' yogo' cuen beyix̱e' že' yežlion', be žia tap ṉi'a na', na' be chososa' ḻe'eban' ḻo yo, na' len be žia x̱il be chaš ḻe'e yaba. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nach bende' gož Diosen' ḻe': ―Gwyas Pedro na' betw be ca' gwdagw. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nach Pedroa' gože'ne': ―Bi gagua' ḻegacba' X̱ana'. Ṉe tṉi'a biṉa' gagua' be zban zjanac ca', ḻe cbi de ḻsens len ley c̱heto'na' gagwto' ben' zjanac ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nach Diosen' gože' ḻe' da' gwchope: ―Ben' bac̱h gwnia' gago' bi ṉao' be zban zjanacba'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Da' gwyoṉ ṉi'a gož Diosen' ḻe' ca' nach ḻa' begüete lachen' ḻe'e yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Šlac chacžejlaže' Pedroa' bi zejen dan' ble'edagüeden', besežin beṉe' ca' gwseḻa' Cornelion' cho'a puert liž Simón ben' chonšagüe' yiden', ḻe ba goseṉabe' gan' zoa liže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nach zižje goseṉabe' še ḻe na' zoa to beṉe' ḻecze le Simón Pedro. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na' Pedroa' ṉe' chone' xbab c̱he dan' ble'edagüede', cate' gož Spiritw c̱he Diosen' ḻe': ―Simón, šoṉe beṉe' chesyeyiljue' le'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gwzoža' na' beyetj cont šejleno' ḻegaque', na' bi gacžejlažo' ḻa'czḻa' bi zjanaque' beṉe' Israel, ḻe neda' gwseḻa' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nach Pedroa' beyetje' jašague' beṉe' ca' gwseḻa' Cornelion', nach gože' ḻegaque': ―Nga zoa', nedan' Simón Pedro. ¿Bic̱hen' cheyiljwle neda'? ");
INSERT INTO zpqNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nach gose' beṉe' ca' ḻe': ―To x̱an soldadw beṉe' le Cornelio gwseḻe' neto'. Ḻe' zejcze' chone' da' güen na' chonxene' Diosen' na' yogo'ḻoḻ beṉe' Israel ca' cheso'e xtiže' ca beṉe' šagüe' naque'. To angl c̱he Diosen' gože' ḻe' yedeṉabe' šejo' liže'na' cont gwzenague' c̱hio' še bin' yo'one'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nach gwlo'o Pedroa' ḻegaque' yo'o na' besyega'aṉlene' ḻe' tže'. Nach beteyo Pedroa' gwyase' gwyejlene' ḻegaque' na' gwc̱he'e to c̱hope beṉe' Jopen' beṉe' chesejnilaže' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na' beteyo cate' besežine' ciuda Cesarean', Cornelion' bac̱h ntobe' biše' ḻježe' len xmigüe' ba zjažie' liže'na' chesebeze' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na' cate' bžin Pedroa' liž Cornelion' ḻa' bchojte Cornelion' bšague'ne' na' bzoa xibe' lagüe'na' benxene'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Na' Pedroa' bsože'e ḻe', gože'ne': ―Bezoža'. Ḻecze beṉac̱h neda'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na' ṉe' choe'lente' ḻe' dižan' ca' cate' gwyo'o Pedroa' ḻo' yo'on na' ble'ede' beṉe' zan ba že' ḻo yo'ona'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nach gože' ḻegaque': ―Ṉezeczele ley c̱he neto' beṉe' Israel žan bi cheyaḻa' šo'to' liž beṉe' bi zjanaque' beṉe' Israel, na' žan bi cheyaḻa' gonto' txen len le'e bi nacle beṉe' Israel. Perw bac̱h bzejni'i Diosen' neda' ṉe to beṉe' cbi cheyaḻa' gona' xbab c̱he' naque' beṉe' zban par šo'a liže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Da'nan' cate' beṉe' quinga bedesexi'e neda', bi gocžejlaža' še nacle gona', san ba bida' do yic̱hj do laža', na' ṉa'a chaclaža' ṉezda' ¿bixc̱hen' gwṉio' neda'? ");
INSERT INTO zpqNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nach Cornelion' gože'ne': ―Ṉa'a chac tap ža do cheda šoṉe zoa' sin cbibi nagua', na' choḻ güiža' Diosen' liža' nga, cate'cze ble'eda' to beṉe' byo lagua'na' nyaze' to lache' da' chgo'oten be'ni'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nach gože' neda': “Cornelio, ca nac da' gwṉabdo' Diosen', bac̱h bzenague' c̱hen, na' ṉezde' chnežjo' da' chyažj da' chc̱hine' beṉe' yaše'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na' ṉa'a gwseḻa' to c̱hope beṉe' šjasexi'e to beṉe' zoa ciuda Jopen' beṉe' le Simón Pedro. Zoe' liž to beṉe' ḻecze le Simón, to beṉe' chonšagüe' yid. Liž ben' chonšagüe' yiden' zoan gaḻa'ze cho'a nisdao'. Na' cate' la' Pedroa' ližo' nga nach güe'lene' le' diža'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nach ḻa' gwseḻa'tia' beṉe' ca' bedesexi'e le', na' chox̱clenteco' bac̱h bido'. Na' ṉezcze Diosen' yogo'to' nita'to' nga gwzenagto' yogo'ḻoḻte dan' ba ben Diosen' mandadw ṉao'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nach Pedroa' gwzolagüe' be'e dižan' gwne': ―Da' ḻi bac̱h ṉezda' nono nḻa' beṉe' ṉacho nzoa Diosen' ḻe' to šḻa'aze. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gate'teze beṉe' nación con beṉe' chesonxen Diosen' do yic̱hj do laže' na' chesone' da' güen, Diosen' chbede' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosen' gwdix̱jue'ede' neto' beṉe' Israel guac soato' binḻo len ḻe' še šejnilaže'to' Xi'iṉe' Jesucriston' beṉe' naque' X̱an yogo'ḻoḻ beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ṉezele dan' ba goc doxen distritw Judean' dan' gwzolao distritw Galilean' gwde gwdix̱jue'e da' Juanṉa' xtiža' Diosen' na' bzoe' beṉe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ṉezele Diosen' gwleje' Jesúsen' ben' naque' beṉe' yež Nazaret cont chaclene' chio' beṉac̱h, na' be'ene' Spiritw c̱he'na' na' yeḻa' chnabia'. Na' gwda Jesúsen' bene' da' güen na' beyone' yogo'ḻoḻ beṉe' ca' chsaca'zi' Satanás dan' chnabia' da' x̱igüe' ca', ḻe Diosen' zoe' len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Neto' ṉezeto' na' choe'to' diža' c̱he yogo' da' güen da' ben Jesúsen' na' dan' bsed blo'ede' distritw Judean' na' ciuda Jerusalénṉa'. Na' choe'to' diža' can' gosote'ne' bosode'ene' to ḻe'e yag cruz. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Perw na' Diosen' bec̱his bosbane'ne' ladjo beṉe' guat ca' beyoṉ ža na' ben Diosen' cont Jesúsen' blo'elagüe' neto'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Gague yogo'ḻoḻ beṉe' besele'ede' Jesúsen' caten' bebane' ladjo beṉe' guat ca', perw Diosen' gwleje' neto' cont choe'to' xtiže'na' na' bene' cont ble'eto'ne'. Na' neto' güe'ej gwdagwlento'ne' txen gwde bebane' ladjo beṉe' guat ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesúsen' bene' mandadw c̱hix̱jue'eto' beṉac̱hen' Diosen' bzoe' ḻe' gone' yeḻa' justisen' len yogo' beṉe' zjamban na' len yogo' beṉe' ba gosat. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na' da' ca' bosozoj yogo' beṉe' goso'e xtiža' Diosen' cani'te zjanyojen chesenan note'tez beṉe' yesejnilaže' Jesucriston', Diosen' yezi'xene' xtoḻa'gaque'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ṉe' cho'ete Pedroa' diža'na' cate' Spiritw c̱he Diosen' gwyo'on ḻo' yic̱hjlaždao' yogo' beṉe' ca' chosozenag diža' dan' cho'ena'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na' beṉe' Israel ben' chesejnilaže' Jesucriston', beṉe' ca' zja'ac len Pedroa' liž Cornelion', besyebande' dan' gwyo'o Spiritw c̱he Diosen' ḻo' yic̱hjlaždao' beṉe' ca' cbi zjanaque' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gosacbe'ede' gwyo'o Spiritw c̱he Diosen' ḻo' yic̱hjlaždao' beṉe' ca' že' liž Cornelion', ḻe gosende' gosonxen beṉe' ca' Diosen' goso'e diža' da' bi gosejni'ide' na' ḻecze gosonxene' Diosen' len xtiža'gaque'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nach Pedroa' gože' beṉe' Israel ca' nžaguen': ―Bibi de da' gwžon yesezoa beṉe' quinga nisen', ḻe nacbia' ba zoa Spiritw c̱he Diosen' len ḻegaque' can' zoan len chio'. ");
INSERT INTO zpqNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nach Pedroa' bene' mandadw gosezoe' nis da' chesejnilaže' Jesucriston'. Na' gosata'yoede' ḻe' cont bega'aṉe' yeto c̱hop ža. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na' postlw ca' na' yezica'chle beṉe' ca' že' distritw Judean' ben' chesejnilaže' Jesucriston' gosende' xtiža' beṉe' ca' bi zjanaque' beṉe' Israel ḻecze ba chosozenague' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nach Pedroa' beze'e gwyejche' ciuda Jerusalénṉa' gan' nita' beṉe' Israel ben' chesejnilaže' Jesucriston' na' ḻegaque' goseṉelagüe' c̱he', ");
INSERT INTO zpqNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","gose'ene': ―¿Bixc̱hen' ba gwyejo' gan' že' beṉe' cbi zjanaque' beṉe' Israel na' jatagwleno' ḻegaque'? Malen' ba beno'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nach Pedroa' gwzolagüe' be'lene' ḻegaque' diža' tcho'a yogo' dan' goc c̱he', gože' ḻegaque': ");
INSERT INTO zpqNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Šlac zoa' ciuda Jopen' choḻ güiža' Diosen', ble'edagüeda' ca to lache' xen nchej dapte squin ca' chetjen ḻe'e yaban' zan' gan' zoa'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na' gwṉa'yaṉa' na' ble'eda' ḻo'enṉa' že' beyix̱e' ca' chaš yežlion' be žia tap ṉi'a na', na' ble'eda' be chososa' ḻe'eban' ḻo yo, na' be žia x̱il be chaš ḻe'e yaba, na' baḻ be ca' zjanacba' be znia. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na' benda' gož Diosen' neda': “Gwyas Pedro, na' betw be ca' gwdagw.” ");
INSERT INTO zpqNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nach boži'an gwnia': “X̱ana', bi gagua' ḻegacba'. Ṉe tṉi'aze biṉa' gagua' be zban zjanac ca', ḻe bi de ḻsens len ley c̱heto'na' gagwto' ben' zjanac ca'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na' da' gwchop ṉi'a Diosen' gwne': “Be bac̱h gwnia' gago' bi ṉao' zjanacba' be zban.” ");
INSERT INTO zpqNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Šoṉ ṉi'a gože' neda' ca' nach begüe lachen' ḻe'e yaban'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Za' beyož ble'edagüeda' da'na' cate' besela'ac šoṉe beṉe' byo gan' zoa'na' beṉe' za'ac ciuda Cesarean' chesyeyiljue'nda'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na' Spiritw c̱he Diosen' bzejni'in neda' cheyaḻa' ša'alena' ḻegaque' sin cbi gacžejlaža', na' gwc̱hi'a beṉe' ḻježcho quinga x̱op, gwyejto' Cesarean' bžinto' liž ben' le Cornelio na' gwyo'oto' ližen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nach Cornelion' be'lene' neto' diža' can' blo'elao to angl ḻe' liže'na' na' anglen' gože'ne': “Gwseḻa' beṉe' šja'ac ciuda Jopen' šjasexi'e to beṉe' le Simón Pedro. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Bena' ye'e le' len beṉe' ḻo' yo'o c̱hio' nac gonḻe cont gata' yeḻa' mban c̱hele toḻi tocaṉe.” ");
INSERT INTO zpqNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nach cate' gwzolagua' bia' dižan' len beṉe' ca' že' liž Cornelion', Spiritw c̱he Diosen' gwyo'on ḻo' yic̱hjlažda'ogaque'na' can' gwyo'on ḻo' lažda'ochon' cana'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nach jaysa'laža' xtiža' X̱ancho Jesucriston' can' gwne': “Da' zaque' ben Juan da' bzoe' beṉe' nis, perw da' zaca'che' gac c̱hele cate' yedesoa Spiritw c̱he Diosen' ḻo' yic̱hjlažda'olen' ṉabi'an le'e.” ");
INSERT INTO zpqNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na' ba ben Diosen' cont zoa Spiritw c̱he'na' ḻo' yic̱hjlažda'ogaquen' dan' gosejnilaže' X̱ancho Jesucriston' can' ba bene' len chio' chejnilaže'chone', na' ¿nox naca' neda' gwžona' gon Diosen' dan' chaclaže' gone'? ");
INSERT INTO zpqNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na' ca beyož bosozenague' xtiža' Pedroa' bich bi goseṉe' c̱he Pedroa' dan' gwyeje' liž Cornelion', san goso'e yeḻa' chox̱clen c̱he Diosen', gosene': ―Ṉa'a ba ṉezecho ḻecze len beṉe' ca' bi zjanaque' beṉe' Israel chazlaže' Diosen' yesyetiṉjde' xtoḻa'gaque'na' cont gwnežjue' yeḻa' mban c̱hegaque' toḻi tocaṉ. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na' gwde gosot beṉe' Israel ca' Estebanṉa', gosezolagüe' bosoc̱hi bososaca'chgüe' yezica'chle beṉe' ca' chesejnilaže' Jesucriston', nach beṉe' ca' chesejnilaže'ne' gosasḻase'. Baḻe' ja'aque' do distritw Fenicia, na' yež ca' zjachi' to ḻo yežlio da' žia ḻo' nisdaon' gan' nzi' Chipre na' do ciuda Antioquía ga mbane distritw Siria. Na' gan' zja'aquen' bososed bosolo'ede' con beṉe' zjanac beṉe' Israel xtiža' Jesúsen', bi bososed bosolo'eden' beṉe' cbi zjanaque' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Perw na' to c̱hope beṉe' Chipre na' beṉe' ciuda Cirene ḻecze bosoxoṉje' ja'aque' ciuda Antioquían', na' gosezolagüe' goseyix̱jue'ede' diža' güen c̱he X̱ancho Jesucriston' len beṉe' ca' cbi zjanaque' beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na' X̱anchon' goclene' ḻegaque' len yeḻa' guac c̱he'na' na' beṉe' zan gosebejyic̱hje' da' ca' chesejnilaže' na' gosejnilaže' X̱anchon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na' cate' beṉe' ca' chesejnilaže' Jesucriston' ciuda Jerusalénṉa' gosende' can' ba chac ciuda Antioquían', nach bosose'e Bernabén' cont gwyeje' Antioquían'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na' cate' bžin Bernabén' Antioquían', ble'ede' da' ḻi ba goclenchgua Diosen' beṉe' ca', na' bebechgüede'. Nach gwṉeyoede' ḻegaque' ṉita'c̱hac̱he' yosozenague' c̱he X̱anchon' do yic̱hj do laže'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabén' naque' to beṉe' güen, na' chejnilaže'chgüe' Jesucriston' na' Spiritw c̱he Diosen' zoachguan len ḻe'. Na' zanch beṉe' Antioquían' gosejnilaže' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Gwde na' Bernabén' gwze'e zeje' ciuda Tarson' jaydiljue' Saulon', nach cate' beželde' ḻe', gwc̱he'ene' Antioquían'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na' gosenite' Antioquían' tgüiz gosone' txen len beṉe' Antioquía ca' chesedop chesežag chesonxene' Jesucriston' na' bososed bosolo'ede' beṉe' zan. Na' Antioquía na'tequen' gwzolao bososi'e beṉe' ca' chesejnilaže' Jesucriston' beṉe' cristian da' chosozenague' c̱he Criston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Šlac nita' Bernabén' na' Saulon' ḻo ciuda Antioquían', besežin baḻ beṉe' Jerusalén ben' chosozende' beṉe' bi dan' ba gož Diosen' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na' cate' beṉe' ca' besežinṉa', toe' beṉe' le Agabo gwzeche' lao beṉe' ca' zjandop zjanžag chesonxen Jesucriston' be'e diža' can' ba bzejni'i Spiritw c̱he Diosen' ḻe', gwne' doxen yežlion' gata' to gwbin juisyw. Na' cate' bžin ža gwnabia' ben' le Claudio doxen gan' mbane nación Roman', cana' goc gwbinṉa' can' gwna Agabon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nach beṉe' ca' chesedop chesežag chesonxene' Jesucriston' Antioquían' bosoxi'e yosotobe' mechw cont yeseseḻen' yesaclene' beṉe' ḻježgaquen' chesonxen Jesucriston' gan' mbane distritw Judean'. Na' bosoxi'e to toe' yosonežjue' gaca'te' da' gac yosonežjue'. ");
INSERT INTO zpqNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na' gosone' can' bosoxi'ena' nach goseseḻe' Saulon' len Bernabén' distritw Judean' jasenežjue' mechon' beṉe' ca' chosogüia cheseṉe'e beṉe' chesejnilaže' Jesucriston' ciuda Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na' ca tiempa' rey Herodes bc̱hi bsaque' baḻ beṉe' ca' chesonxene' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nach bene' mandadw gosote' Jacobo beṉe' biše' Juanṉa' len spada. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na' gocbe'e rey Herodesen' chesyebe beṉe' Israel ca' dan' bene' mandadw gosote' Jacobon', nach bene' mandadw gosezene' Pedroa' cate' goḻa' ḻṉi cate' chesagüe' yetextil dan' bibi levadura nc̱hix̱en. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nach Herodesen' gwdix̱jue'ene' ḻižya na' gwseḻe' šino'to soldadw beṉe' gosape' ḻižyan', tap güeje' do ža do yel. Herodesen' bene' xbab cueje'ne' ḻižyan' te ḻṉin' cont gone' yeḻa' justis c̱he' lao beṉe' že' ḻo ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Soldadw ca' gosapchgüe' Pedroa' šlac de' ḻižyan', perw na' ca nac beṉe' ca' chesejnilaže' Jesucriston', goseṉabchgüede' Diosen' gaclene' Pedroa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na' to že' ca gwx̱eze ngüia Herodesen' cueje' Pedroa' ḻižyan' cont gone' yeḻa' justis c̱he', Pedroa' de' chtase' ladjo c̱hope soldadw na' ncheje' c̱hope gden, na' ḻecze nita'te soldadw beṉe' chesape' cho'a puert ḻižyan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Cate'cze zejzenez to angl beṉe' gwseḻa' X̱ancho Diosen' bžine' ḻo' ḻižyan' gan' de Pedroa' na' gwyeni'chgua ḻo' ḻižyan'. Anglen' bte' cuit ḻe'e Pedroa' bosbane'ne', gože'ne': ―Ṉetec ṉa'a gwyas. Na' ḻa' besyeyežte gdenṉa' zjanchej na' Pedroa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nach gož anglen' ḻe': ―Bego'o xpanto' na' bolej xelon'. Nach ben Pedroa' ca'. Nach gož anglen' ḻe': ―Becheḻe xadoṉ c̱hio' na' beyo'o len neda'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nach bechoj Pedroa' zena'ogüe'ne' perw bi gocbe'ede' še da' ḻi anglen' chon ca' len ḻe', con gocde' še chle'edagüede'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Beyož besyedie' c̱hop cuen gan' nita' soldadw ca' chesape' ḻižyan', besyežine' gan' zoa puert zaguanṉa' dan' nac de ya gan' chesechoje' cont chja'aque' la cay, con to gualazze puerten' byaljon cont besyechoje', na' cate' ba gosa'aque' late' nach anglen' bocua'aṉe' Pedroa' toze'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Cana'ch gocbe'e Pedroa' da' ḻi ba bechoje' ḻižyan', nach gwne': ―Ba cheyacbe'eda' da' ḻicze X̱ana' Diosen' ba gwseḻe' angl c̱he'na' na' bosle' neda' ḻo na' Herodesen' na' bosle' neda' ḻo yogo' da' ca' chesaque beṉe' Israel gualaž c̱hia' ca' yesonde' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na' ṉe' chonte Pedroa' xbaben' ca', gwze'e gwyeje' liž María xṉa' Juan ben' ḻecze le Marcos. Na' liž Marían' zjandop zjanžag beṉe' zan chosoḻ güiže' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nach bsiže' cho'a puert zaguanṉa' na' ḻa' bchojte to bi' no'ole le Rode jaṉa'be' non'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na' cate' bžimbe' cho'a puerten' beyombia'be' ši'i Pedroa', na' tantw bebebe' bi gwsaljwbe' puerten' san beyejsesbe' gan' že' beṉe' ca' jayežbe' ḻegaque' ba bla' Pedroa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nach gose'ebe': ―¿Gague chactonto'na'? Perw ḻebe' ṉezczebe' ḻe'na'. Nach ḻegaque' gose'ebe' naquen bx̱in c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Perw Pedroa' ṉe' chsižcze' cho'a puerten'. Nach ja'aque' gosesaljue'. Cate'cze besele'ede' ḻe'na' besyebande'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nach Pedroa' bene' señw len ne'e cont gosenite' šize bosozenague' be'e diža' can' goc bebej X̱ancho Diosen' ḻe' ḻižyan'. Nach ḻecze gože' ḻegaque' cheyaḻa' yosozende' Jacobon' na' yezica'chle beṉe' ḻježgaque' can' ba goquen'. Nach beze'e zjayde' ga yoble. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nach cate' gwyeni', yeḻa' güeban juisyw gwnita' soldadw ca' na' goso'e diža', gosene': ―¿Bixen' goc len Pedroa'? ");
INSERT INTO zpqNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nach rey Herodesen' bene' mandadw jasyediljue' Pedroa' na' gwṉabde' soldadw gop ca' nac goquen' bele'. Perw soldadw ca' bibi rson bosonežjue'. Nach bene' mandadw gosote' soldadw ca'. Nach gwza' Herodesen' distritw Judean' jazoe' ciuda Cesarea. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ca horan' Herodesen' chža'achgüe' beṉe' ciuda Tiro na' beṉe' ciuda Sidón ca'. Perw na' beṉe' ca' beseyažjde' yesezi'e da' yese'ej yesagüe' gan' chnabia' rey Herodesen'. Da'na'na' bosocode' ḻjež beṉe' Tiro na' beṉe' Sidón ca' cont jasenežjue' mechw c̱he ben' nac ḻo ne'e gan' mbane Herodes, ben' le' Blasto. Gosone' ca' cont Blaston' gwṉe' c̱hegaque' lao reyen', ḻe gosaclaže' gwzenag reyen' c̱hegaque' cate' šja'aque' lagüe'na' šjaseṉabe' yesenite' binḻo len ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nach rey Herodesen' bžie' bia' to ža gwtobe' ḻegaque' cont güe'e diža' laogaque'na'. Na' cate' bžin žan', reyen' gwyaz xaḻane' dan' nac xdan dan' chaze' cate' chone' yeḻa' justis, nach gwchi'e xišne'e gan' chnabi'e na' be'e diža' lao beṉe' ca' že' žana'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nach beṉe' ca' bososye'e, gosene': ―Diosen' choe' diža', gague beṉac̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na' ḻo hora' gwseḻa' X̱ancho Diosen' to angl ben' ben cont gocšene reyen' gwže'e bzoga' ḻo' ḻe'e na' gote'. Goc c̱he' ca' dan' be'e latje gosonxen beṉe' ḻe' gualaz da' yesonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Perw ca nac xtiža' X̱ancho Jesucriston' gos gwlaḻjchguan. ");
INSERT INTO zpqNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na' Bernabén' len Saulon' beyož gosone' yogo' da' cheyaḻa' yesone' ciuda Jerusalénṉa', nach besyeya'aque' jaya'aque' ciuda Antioquían'. Na' gosec̱he'e to beṉe' le Juan na' ḻecze lie' Marcos. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na' len beṉe' ca' chesedop chesežag chesonxene' Jesucriston' ciuda Antioquían' zjanc̱hix̱e beṉe' cheseyix̱jue'ede' beṉe' yoble bi da' che' Diosen' ḻegaque', na' zjalen beṉe' chososed chosolo'ede' xtiža' Diosen'. Na' ḻegaque' zjalie' Bernabé, na' Simón ben' zjansi'e beṉe' gasj, na' Lucio beṉe' ciuda Cirene, na' Saulo, na' Manaén. Na' Manaénṉa' bgole' txen len rey Herodes ben' gwnabia' distritw Galilea. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na' to ža beṉe' ca' chesejnilaže' Jesucriston' gosone' gwbas zjandop zjanžague' chesonxene'ne' cate'cze gož Spiritw c̱he Diosen' ḻegaque': ―Ḻe cuej Bernabén' len Saulon' cont yesone' xšina' con gate'teze seḻa' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nach beṉe' ca' bosoḻ güižche' Diosen' sin cbi zjane'ej zjanagüe', nach gosex̱oa na'gaque' yic̱hj Saulon' len yic̱hj Bernabén', gosone' ca' cont gosegüe'e xšin Diosen' ḻo na'gaque'. Gwdena' bosose'e ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nach Spiritw c̱he Diosen' gwseḻan' Bernabén' len Saulon' yež gan' nzi' Seleucia. Na' Seleuciana' goso'e ḻo' barcon' cont besežine' Chipre. Na' Chipren' naquen to yežlio dao' dan' chi' ḻo' nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Besežine' yež dan' nzi' Salamina gan' mbane Chipren' na' gosezolagüe' goseyix̱jue'ede' xtiža' Diosen' ḻo' yodao' c̱he beṉe' Israel ca'. Na' zjanc̱he'e Juan ben' ḻecze le Marcos cont chaclene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Na' ca' gosaše' gosedie' doxen Chipren' besežine' yež gan' nzi' Pafos. Na' Pafosna' besežague' to beṉe' guaža' le Barjesús. Naque' beṉe' Israel na' chx̱oayague' že' chzende' bi dan' che' Diosen' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesúsen' naque' xmigw gobernador ben' le Sergio Paulo. Sergio Paulon' naque' to beṉe' chejni'ichgüe'. Na' ḻe' goxe' Bernabén' na' Saulon', ḻe goclaže' yosozende' ḻe' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Na' Barjesúsen' ḻecze bososi'ene' Elimas, diža' griego zejen beṉe' guaža'. Ḻe' goclaže' bi šejḻe' Sergio Paulo xtiža' Diosen' dan' choe' Bernabén' na' Saulon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na' Spiritw c̱he Diosen' zoachguan len Saulon' ben' ḻecze le Pablo, nach bcos lagüen' gwṉa'chgüe' Elimasen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nach gože'ne': ―Naco' xi'iṉ Satanás dan' chnabia' da' x̱igüe' ca', yeḻa' güex̱oayag c̱hio' na' yeḻa' beṉe' mal c̱hio'. Bi chazlažo' bite'teze da' güen. ¿Bic̱hen' cbi chbezo' chžono' yosozenag beṉe' diža' ḻi c̱he X̱anto' Diosen'? ");
INSERT INTO zpqNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Da'nan' X̱anto' Diosen' goṉe' castigw c̱hio' na' c̱hoḻo' to tiemp, bi gac le'edo' gwbiža'. Nach ḻa' gwc̱hoḻtie', gwde ca to bejw ḻo yejlagüe'na', nach gwzolagüe' chgan chtobe' cheyiljue' no gox̱e' ne'e cont cue' nez. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gobernadoren' ble'ede' can' goquen' na' gwyejḻe'e xtiža' X̱ancho Jesucriston', na' bebanchgüede' can' ža dižan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nach Pablon' len beṉe' ca' nžague'na' gosa'aque' yež Pafosen', goso'e ḻo' barcon' cont besežine' yež gan' nzi' Perge gan' mbane distritw Panfilia. Na' Juan ben' ḻecze chese'e Marcos gwlejyic̱hje' ḻegaque' beyeje' Jerusalénṉa'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na' Pablon' len Bernabén' gosa'aque' yež Perge na' besežine' ciuda Antioquían' gan' mbane distritw Pisidia. Na' cate' bžin ža c̱he Dios nach ja'aque' yodao' c̱he beṉe' Israel ca' dan' zoa na' na' jasechi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na' ca beyož blab to beṉe' libr gan' nyoj ley c̱he Diosen' len dan' bosozoj beṉe' ca' goso'e xtiža' Diosen' cani', beṉe' ca' chesenabia' ḻo yodao'na' goseseḻe' to beṉe' gan' chi' Pablon' len Bernabén' na' gože' ḻegaque': ―Beṉe' migw, še de bi diža' da' chaclaže'le güe'le ṉeyoele beṉe' quinga, guac ṉalen ṉa'a. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nach Pablon' gwzechede' bene' señw len ne'ena' cont yosozenag beṉe' ca' zjachi'na', na' gože' ḻegaque': ―Ḻe gwzenag le'e beṉe' Israel na' nochle chonxenḻe Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios ben' chonxen chio' beṉe' Israel gwleje' da' x̱ozxta'ocho ca' na' goclene' ḻegaque' cont yesaque' to yež xen šlac gosenite' nación Egipto gan' gosaque' beṉe' zito'. Nach Diosen' bebeje' ḻegaque' Egipton' len yeḻa' guac c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na' Diosen' gwdape' yeḻa' chxenḻaže' c̱hoa iz len da' x̱ozxta'ocho ca' šlac gosaše' latje dašen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Diosen' boṉite' gaž yež da' zjachi' gan' nzi' Canaán cont bnežjue' da' x̱ozxta'ocho ca' yežlio c̱hegaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nach gwde na' Diosen' gwleje' tgüeje tgüeje juez cont gosenabi'e nación Israelen' lao tap gayoa yogašje iz bžinte tiemp c̱he da' Samuel ben' be'e xtiža' Diosen' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nach tiemp c̱he da' Samuelen' da' x̱ozxta'ocho ca' goseṉabde' Diosen' goṉe' to rey beṉe' ṉabi'e ḻegaque'. Na' Diosen' bnežjue' ḻegaque' rey Saúl na' gwnabi'e ḻegaque' c̱hoa iz. Saúl nan' goque' xi'iṉ ben' le' Cis, na' goque' diaža c̱he da' ben' le Benjamín ben' gwzoa cani'te. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nach bžin ža Diosen' beque'e yeḻa' gwnabia' c̱he Saúlen' na' bzoe' ben' le David cont gwnabi'e. Na' gwne' c̱he rey Davin': “Chbeda' David xi'iṉ Isaí nga, ḻe chaclaže' chone' can' chazlažan' na' chzenague' bite'tez da' chapa'ne'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nach ṉa'a Diosen' ba gwseḻe' yeto beṉe' golje' ḻo diaža c̱he da' rey Davin', ben' le Jesús. Ba gwseḻe' ḻe' cont goṉe' chio' beṉe' Israel yeḻa' mban toḻi tocaṉe can' gwne' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na' cate' biṉa' solao Jesúsen' gwsed gwlo'ede' beṉe', da' Juanṉa' gwdix̱jue'ede' len yogo' beṉe' Israel gualaž c̱hechon' cheyaḻa' yesyetiṉjde' xtoḻa'gaque' na' yesezoe' nis. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na' cate' beyož ben Juanṉa' dan' yo'o ḻo ne'e gone', nach gože' beṉe' ca' chosozenag c̱he': “¿Chonḻe xbab naca' neda' ben' chbezle seḻa' Diosen'? Bi naca' bena'. Za' yid bena', na' da' nacchgüe' beṉe' zaca', bi zaca' gona' mandadw c̱he' ḻec̱hja' no xele'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Beṉe' migw, chio' naccho xi'iṉ diaža c̱he da' x̱ozxta'ocho Abraham, na' nochle le'e chonxenḻe Diosen' txen len neto' beṉe' Israel, xtiža' Diosen' dan' žan goṉe' chio' yeḻa' mban toḻi tocaṉe naquen par chio'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Beṉe' ciuda Jerusalén ca' len beṉe' gwnabia' c̱hegaque' ca' bi gosejḻi'e gwseḻa' Diosen' Jesúsen', na' bi gosejni'ide' da' ca' zjanyoj c̱he' ḻe'e libr dan' bosozoj beṉe' ca' goso'e xtiža' Diosen' cani' ḻa'czḻa' chosolaben' ḻo' yodaon' yogo' ža c̱he Dios. Na' dan' bi gosejni'ide', da'nan' gosec̱hoglagüen' yesote' Jesúsen', nach goc can' nyoj c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Na' ḻa'czḻa' goseṉezde' bibi da' mal non Jesúsen' cont yesote' ḻe', goseṉabde' Pilaton' gone' mandadw yesot soldadw c̱he' ca' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na' goc c̱he Jesúsen' yogo' dan' nyoj c̱he' ḻe'e Xtiža' Dios dan' bosozoj beṉe' ca' gosenita' cani'. Na' beyož gote'na' nach besežin beṉe' besyeḻetje' cuerp c̱he'na' ḻe'e yag cruzen' na' bosocuaše'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Na' gwdena' Diosen' bec̱his bosbane' ḻe' ladjo beṉe' guata'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Na' beṉe' ca' zjanaque' Jesúsen' txen cate' gwze'e distritw Galilea cont gwyeje' ciuda Jerusalén, ḻegaque' besele'ede' Jesúsen' yezan ža gwde bebane' ladjo beṉe' guata', na' ḻegaque' cheso'e diža' c̱hen' len yezica'chle beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Na' lencze neto' chyix̱jue'eto' le'e diža' güen cont ṉezele ba chac da' güen dan' gož Diosen' da' x̱ozxta'ocho ca' cani'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ba benen' len chio' naccho xi'iṉ diaža c̱he da' beṉe' ca', dan' bosbane' Jesúsen' ladjo beṉe' guaten'. Na' goc can' nyojen c̱he' ḻe'e libr dan' nzi' Salmos, na' salmo gwchopen' žan: “Le' naco' xi'iṉa'; ṉa'aža ba blo'a zoaczo'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na' Diosen' ḻecze bene' cont nyojen ga yoble c̱he' dan' bosbane' ḻe' ladjo beṉe' guaten' na' gwbat gožo' cuerp chen', žan: “Gona' güen len le' doḻoḻ can' goša' rey Davin'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na' nyoj yeto salmo žan: “Bi go'o latje gožo' cuerp c̱hian' neda' naca' ben' chacchgüedo' na' ben' chon xšinon'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ṉezecho da' rey Davin' gwnabi'e beṉe' Israel ca' gwnita' ca tiemp c̱hen' can' gwnalaže' Diosen' na' beyožen' gote' na' bgaše' len yezica'chle da' x̱ozxta'ocho ca' na' ḻecze gožo' cuerp c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Perw na' Diosen' bosbane' Jesúsen' ben' nyoj Xtižen' žan ca', na' bi gožo' cuerp c̱hen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Na' cheyaḻa' ṉezele beṉe' migw, Jesúsen' ben' choa' diža' c̱he', chezi'xene' xtoḻa' note'tez beṉe' chejnilaže'ne'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Bi beyaccho beṉe' güen len Diosen' da' bi benyaṉe'cho can' ža ley dan' bzoj da' Moisésen', perw note'tezcho chejnilaže'cho Jesúsen', ḻen' ba cheyone' chio' beṉe' güen. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ḻe gwsaca' cont bi gac c̱hele can' bosozoj beṉe' ca' goso'e xtiža' Diosen' cani', žan: ");
INSERT INTO zpqNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Cheyaḻa' gonḻe xbab, le'e chṉelaole c̱hia', na' cheyaḻa' yebanele, ḻe gwžin ža cuiayi'le. Neda' Dios gona' to da' yebanele šlac mbanḻe, to da' bi šejḻe'le ḻa'czḻa' še no c̱hix̱jue'e le'e can' gaca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Beyož bzejni'i Pablon' beṉe' ca' že'na' nach besyechoje' ḻo' yodaon'. Nach beṉe' ca' ba goson cuine' beṉe' Israel gosata'yoede' Pablon' len Bernabén' yeside' ža c̱he Dios xmanṉa' yeto cont yosozejni'ide' ḻegaque' yelate' c̱he da' ca' ba bosozejni'ide'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nach beṉe' zan beṉe' Israel len zan beṉe' ca' ba goson cuingaque' beṉe' Israel zja'aclene' Pablon' len Bernabén'. Nach Pablon' na' Bernabén' goseṉeyoede' ḻegaque' cont ṉita'che' yesejnilaže'che' Diosen' ben' chaclen ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na' cate' bežag xmanṉa' ža c̱he Dios yogo'ḻoḻcze beṉe' ḻo ciudan' besežag cont bosozenague' xtiža' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na' gwnita' beṉe' Israel beṉe' bi gosejḻe' c̱he Jesúsen', na' cate' besele'ede' ba nac beṉe' zan chosozenague' c̱he Pablon' na' gosacxi'ede' ḻe' na' goseṉelagüe' c̱he' na' gosezi'diže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Perw na' Pablon' len Bernabén' bi besežebe' san gose'e beṉe' ca' že'na': ―Ba bento' can' gwnalaže' Diosen' na' zgua'tec bzejni'ito' le'e nacle beṉe' Israel gualaž c̱heto'. Na' ṉa'a dan' bi chaclaže'le gwzenagle, chonḻe cont bi goṉ Diosen' le'e yeḻa' mban toḻi tocaṉe. Da'nan' ṉa'a gwzejni'ito' beṉe' ca' bi zjanac beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gonto' ca' ṉec̱he X̱anto' Diosen' bac̱h bene' mandadw gonton', ḻe nyojen žan: Bac̱h nzoa' le'e cont co'ole be'ni' c̱hian' ḻo' yic̱hjlaždao' beṉe' ca' bi zjanac beṉe' Israel, cont beṉe' ca' že' doxen yežlion' yesacbe'ede' guac ṉitlao xtoḻa'gaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na' beṉe' ca' bi zjanac beṉe' Israel chesebede' beyož gosende' can' gwna Pablon', na' gosene' güenchgua nac xtiža' Diosen'. Na' yogo' beṉe' ca' ba gwlej Diosen' cont gata' yeḻa' mban c̱hegaque' toḻi tocaṉe, ḻegaque' gosejḻe'e xtiža' Diosen' dan' be' Pablon' len Bernabén'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Can' goc beṉe' ca' že' doxen distritwna' gosende' xtiža' X̱ancho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Perw baḻ beṉe' Israelen' goso'e diža' len no'ol blao ca' gosonxen Diosen' na' len beṉe' gwnabia' blao ca' ḻo ciudan', na' bosoše'e xbab c̱hegaquen' cont gwzolao gosone' contr Pablon' len Bernabén' na' bich goso'e latje yesenite' doxen distriton'. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nach Pablon' len Bernabén' cate' besyeya'aque' ciuda Antioquían' gosebibe ṉi'agaque' cont bežib yo bište dan' žianṉa'. Gosone' ca' cont bosolo'ede' beṉe' ca' chesyebej ḻegaque' malen' chesone' chosolague' ḻegaque'. Nach jaya'aque' yež Iconio. ");
INSERT INTO zpqNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na' mbalazchgua gwnita' beṉe' ca' chesonxen Jesucriston' ciuda Antioquían', na' Spiritw c̱he Diosen' gwzoachguan len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na' goquen' Pablon' len Bernabén' besežine' yež Iconion' na' ja'aque' yodao' c̱he beṉe' Israel. Na' cate' goso'e xtiža' Jesucriston', beṉe' zan beṉe' Israel ca' na' len zan beṉe' cbi zjanac beṉe' Israel gosejḻe'e c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Perw na' gwnita' beṉe' Israel ca' beṉe' bi gosejḻe'e c̱he Jesucriston', na' ḻegaque' goseṉelagüe' c̱he beṉe' ca' chesejnilaže' Jesucriston' na' gosone' cont beṉe' ca' bi zjanac beṉe' Israel gosezolagüe' besegue'ede' Pablon' len Bernabén'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Perw na' Pablon' len Bernabén' besyega'aṉe' sša Iconion' cheso'e xtiža' X̱ancho Jesucriston' sin cbi besežebe'. Na' X̱anchon' blo'e ḻe diža' ḻin' cheso'e chesene' Diosen' chacde' beṉac̱hen', ḻe be'e ḻegaque' yeḻa' guac cont gosone' da' zaca' yebanecho cont gosaclene' beṉe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na' beṉe' ca' že' ḻo yežen' gosaque' c̱hople, baḻe' gosede'e beṉe' Israel ca' ben' bi gosejnilaže' Jesucriston' na' yebaḻe' gosede'e Pablon' len Bernabén'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nach beṉe' Israel ca' gosone' yeḻa' güexi'a len beṉe' ca' cbi zjanac beṉe' Israel na' len justis c̱hegaque' cont yesone' contr Pablon' len Bernabén' na' yosoc̱hele' ḻegaque' yej. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Perw cate' gwṉeze Pablon' len Bernabén' dan' chesaclaže' yesone' len ḻegaque', bosyoxoṉje' jaya'aque' yež Listra na' yež Derbe na' yezica'chle yež ca' zjachi' distritw dan' nzi' Licaonia. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na' ḻecz goseyix̱jue'ede' xtiža' X̱ancho Jesucriston' len beṉe' ca' že' na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na' yež Listran' besežague' to beṉe' golje' nxiṉj ṉi'e ca', cate' gocte' bidao' bi goc se'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Con chi'teze' chzenague' choe' Pablon' dižan'. Nach Pablon' gwṉe'e ḻe' na' gocbe'ede' bena' chejḻe'e Diosen' nape' yeḻa' guac cont yeyone' ṉi'en'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nach Pablon' boḻ güiže'ne' gože' ḻe' zižje: ―Gwzoža'. Na' ḻa' gwzoža'te' na' gwzolao chde'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Na' že' beṉe' zan cheseṉe'e can' goquen' na' ḻegaque' bososye'e goseṉe' diža' Licaonia: ―X̱ancho beṉe' ca' chejnilaže'cho ba gosetje' nga chesone' yeḻa' guac, na' chle'etecho ḻegaque' ca beṉac̱h. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Gosene' Bernabén' naque' x̱angaque' ben' zjansi'e Júpiter, na' Pablon' naque' x̱angaque' ben' zjansi'e Mercurio. Gosene' ca' ḻe Pablon' choe'che' dižan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na' yodao' gan' chesonxene' x̱angaque' Júpiteren' zoan cho'a yež. Na' bx̱oz c̱he Júpiteren' jax̱i'e go'ṉ be ba zjanone' xdan zjanžie' ḻegacba' corona yej. Nach bx̱oza' gwc̱he'e beṉe' zan cho'a yežen' gan' zoa puert c̱he ze'e dan' nyec̱hj yežen' na' goclaže' yesote' go'ṉen' yesonxene' postlw ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na' Pablon' len Bernabén' cate' gosacbe'ede' can' yeson beṉe' ca', gosec̱heza' xagaque' dan' bi gosaclaže' yesonxen beṉe' ca' ḻegaque'. Nach gosedie' gachoḻ beṉe' ca' gose'e ḻegaque' zižje: ");
INSERT INTO zpqNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Beṉe', ¿bixchen' chonḻe ca'? Ḻecz beṉac̱h neto'. Za'to' cont chyix̱jue'eto' le'e cheyaḻa' gwša' yic̱hjlažda'olen' na' cuejyic̱hjle costumbr quinga dan' bibi zaca' na' gonxenḻe Dios ben' zoa toḻi tocaṉe. Ḻe' bene' yaban', yežlion', nisdaon', beṉac̱h, be ca' chesaš na' bite'tezechle da' chle'echo ḻe'e yaban', ḻo yežlion' na' ḻo' nis. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Cani' Diosen' bi bžone' gon beṉac̱hen' bite'tez da' mal da' žan yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Perw zoacze' chone' da' güen len yogo' beṉac̱h cont yeseṉezde' zoe' naque' Dios. Chone' cont chac yejw cont chac dan' chazcho na' chata' da' che'ej chagwcho cont zoacho mbalaz. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Na' ḻa'czḻa' Pablon' len Bernabén' gosene' yogo' da' ca', caṉe gosezoede' bosožone' yesot beṉe' Listra ca' go'ṉna' yesonxene' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nach besežin baḻ beṉe' Israel beṉe' nita' yež Iconio na' ciuda Antioquía dan' chi' distritw Pisidian', na' beṉe' ca' gosego'oyeḻe' beṉe' Listra ca' cont gosaque'ne' txen bosoc̱hele' Pablon' yej. Na' cate' gosone' xbab bac̱h gote' nach gosexobe' ḻe' cho'a yeža' na' bosyocua'aṉe' ḻe' na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Perw na' beṉe' ca' chesonxene' Jesucriston' besedobe' gan' de Pablon', nach Pablon' beyase' beyeje' ḻo ciudan' da' yoble. Nach beteyo beza' Pablon' len Bernabén' jaya'aque' yež Derben'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nach cate' besežine' Derben' bosozende' beṉe' ca' že' na' diža' güen c̱he Jesucriston', na' beṉe' zan gosone' txen len ḻegaque' gosejḻe'e c̱he Jesucriston'. Na' gwdena' gosa'aque' ja'aque' da' yoble Listran' na' Iconion' na' Antioquían'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Na' to to yež gan' ja'aque' gosone' c̱hac̱h laže' beṉe' ca' chesonxene' Jesucriston' na' gose'e ḻegaque' yesenite' yesonxene' ḻe' do yic̱hj do laže', na' gose'e ḻegaque' da' zan da' gac da' saca'zi'cho šlac chbezcho yeyejcho yaban' gan' zoa Diosen' chnabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na' to to yež ga besyedie' gosebeje' beṉe' yosogüia yeseṉe'e yezica'chle beṉe' ca' chesonxene' Jesucriston'. Na' Pablon' len Bernabén', cate' za' yesa'aque' to to yež, gosone' gwbas na' bosoḻ güiže' Diosen' goseṉabe' gaclen X̱ancho Jesucriston' beṉe' ca' ba chesejnilaže' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Cate' gosa'aque'na' Pablon' len Bernabén' besyedie' distritw Pisidia na' besežine' distritw Panfilian'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Na' goseyix̱jue'ede' xtiža' Jesucriston' yež Perge na' beyožen' jaya'aque' yež Atalia. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nach Atalian' besyeyo'e ḻo' barcw jaya'aque' ciuda Antioquían' gan' mbane distritw Sirian'. Ḻe beṉe' Antioquíanan' goseseḻe' Pablon' na' Bernabén' cana'te na' goseṉabde' Diosen' šejlene' ḻegaque' na' gaclene' ḻegaque' cont yosozejni'ide' beṉe' xtiže'na'. Na' ṉa'a besyežine' ba beyož gosone' dan' gosego'o beṉe' ca' ḻo na'gaque' yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Na' bosyotobe' beṉe' ca' chesonxene' Jesucriston' na' gose'ene' yogo'ḻoḻ can' ben Diosen' len ḻegaque' šlac zja'aque', can' goclene' ḻegaque' cont zan beṉe' bi zjanac beṉe' Israel ba gwzolao chesejnilaže' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na' besyega'aṉe' Antioquían' sša len beṉe' ca' chesonxene' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Na' šlac Pablon' len Bernabén' ṉe' nite' ciuda Antioquían' besežin to c̱hope beṉe' za'ac distritw Judean' na' gosezolagüe' bosozejni'ide' beṉe' ca' chesonxen Jesucriston' na'. Gose'ene' yogo'ḻoḻ beṉe' byo cheyaḻa' yesezoe' señw dan' že' circuncisión can' ža ley dan' bzoj da' Moisésen' cont gata' yeḻa' mban c̱hegaque' toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Na' Pablon' len Bernabén' gosacyože' len beṉe' ca' za'ac distritw Judea dan' chosozejni'ide' ca'. Nach beṉe' ca' chesonxene' Jesucriston' Antioquían' gosec̱hoglagüen' šja'ac to c̱hope' Jerusalén len Pablon' na' Bernabén'. Šja'aque' šjaseṉe'e postlw ca' že'na' na' len beṉe' ca' chosogüia cheseṉe'e ḻježgaquen' cont yesone' yeḻa' güexi'a len ḻegaque' c̱he dan' chosozejni'i beṉe' ca' za'ac distritw Judean'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nach beṉe' ca' chesedop chesežag chesonxene' Jesucriston' Antioquían' goseseḻe' ḻegaque' Jerusalénṉa'. Na' beṉe' ca' zja'aquen' gosedie' distritw Fenicia na' distritw Samaria. Na' yež ca' gan' že' beṉe' chesonxene' Jesucriston', beṉe' ca' zja'aquen' gose'e ḻegaque' zan beṉe' bi zjanac beṉe' Israel ba gosebejyic̱hje' da' ca' gosejnilaže' do cana' cont chesejnilaže' Diosen'. Nach beṉe' ca' že' distritw Fenicia na' distritw Samaria besyebechgüede' gosende' dižan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Na' cate' Pablon' len Bernabén' besežine' Jerusalénṉa', beṉe' ca' chesedop chesežag chesonxene' Jesucriston', na' postlw ca' na' len beṉe' ca' chosogüia cheseṉa' ḻježgaquen' besežague' bosoguape' ḻegaque' tiox. Nach Pablon' len Bernabén' gose'e ḻegaque' yogo'ḻoḻ can' ba goclen Diosen' ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nach nita' to c̱hope beṉe' Fariseo beṉe' ba chesonxene' X̱ancho Jesucriston', na' tgüeje tgüeje' gosezie' gosene': ―Note'tez beṉe' byo gonxene' Jesucriston' cheyaḻa' soe' señw dan' nzi' circuncisión na' cheyaḻa' gone' can' ža ley dan' bzoj da' Moisésen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nach besedobe postlw ca' len beṉe' ca' chosogüia cheseṉa' ḻježgaque', na' bosoxi'e še naquen can' chesena beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba chac sša cheso'e dižan' cate' gwzoža' Pedron' gože' ḻegaque': ―Beṉe' migw, ṉezele ba goc zan iz Diosen' gwleje' neda' jatix̱jue'eda' diža' güen c̱he Jesucriston' len beṉe' ca' bi zjanac beṉe' Israel cont gosejḻe'e c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na' Diosen' nombi'e yic̱hjlaždao' yogo'ḻoḻ beṉe', na' cont ṉezecho chacde' beṉe' ca' bi zjanac beṉe' Israel can' chacde' chio' naccho beṉe' Israel, nacha' gwseḻe' Spiritw c̱hen' gwyo'on ḻo' yic̱hjlaždao' beṉe' ca' can' ba gwyo'on ḻo' yic̱hjlažda'ochon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Toz ca chon Diosen' len chio' na' len ḻegaque', note'tezcho ba beya' beyibe' lažda'ochon' dan' chejḻe'cho c̱he Jesúcriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ba chonḻe contr Diosen' dan' chaquele gwc̱hile beṉe' ca' bi zjanac beṉe' Israel cont yesa'ogüe' costumbr c̱he chio' beṉe' Israel. Ṉezele catec zdebe zjanaquen, ṉe chio' ṉe x̱ozxta'ocho ca' bi goc yesone' yogo' can' ža diža' gol c̱heto' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bi cheyaḻa' goncho ca', ḻe ṉezecho note'tez naccho, X̱ancho Jesúsen' choṉe' yeḻa' mban c̱hecho toḻi tocaṉe dan' chacde' chio', gague ṉec̱he dan' choncho can' ža ley c̱he Moisés. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Beyož gwna Pedroa' ca' nach bich bi gosena beṉe' ca', san yogüe' gosenite' šize bosozenague' xtiža' Pablon' len Bernabén'. Goso'e diža' can' bnežjo Diosen' ḻegaque' yeḻa' guac cont gosone' da' zaca' yebanecho gan' že' beṉe' ca' bi zjanac beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Na' beyož goso'e dižan' nach postlw Jacobo be'e dižan', gwne': ―Beṉe' migw, ḻe gwzenag diža' nga gua'a. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro nga ba bzejni'ide' chio' can' ben Diosen' da' nechw len beṉe' bi zjanac beṉe' Israel cont blo'e chacde' ḻegaque', ba gwleje' baḻe' cont zjanaque' ḻo ne'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na' dan' goc ca' chotiḻen da' ca' bosozoj beṉe' goso'e xtiža' Diosen' cani', ḻe nyojen žan: ");
INSERT INTO zpqNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Tena' yida' da' yoble na' gona' cont ṉabia' xi'iṉ diaža c̱he da' rey David, ḻa'czḻa' ṉa'a nono xi'iṉ diaža c̱he' chnabia', na' gona' cont soa toe' da' yoble ṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Gona' ca' cont yogo' beṉe' bi zjanac beṉe' Israel guac yeseyiljue' nac yesone' yesenite' binḻo len neda'. Note'tez beṉe' nación guac yosoḻ güiže' neda'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Can' gwna X̱ancho Diosen' cani'te, bene' cont goseṉeze beṉe' can' gaquen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Na' lagüe nyoj Xtižen' žan ca', chacda' neda' bi cheyaḻa' gonecho zed beṉe' ca' bi zjanac beṉe' Israel beṉe' ba chesebejyic̱hje' costumbr gole c̱hegaque' na' chesonxene' Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Con gwzojcho ye'gacchone' bi yesone' txen len bi dan' cheson beṉe' dan' chesene' naquen c̱he ḻ gua'a ḻsaca' dan' chesonxene', ṉeca yesata'lene' no no'ol cbi nac no'ol c̱hegaque' o beṉe' byo cbi nac beṉe' c̱hegaque', ṉeca yesagüe' be chesote' chosošoque' do ḻba'ba', ṉeca yesagüe' chen c̱he beyix̱e'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ṉabcho bi yesone' da' ca', ḻe cani'te nita' beṉe' to to yež chosozejni'ide' ley c̱hechon' dan' bzoj da' Moisésen' dan' žan bi goncho da' ca', na' chosolabe' leyna' yogo' ža c̱he Dios. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nach postlw ca' len beṉe' chosogüia cheseṉe'e yezica'chle beṉe' chesonxene' Jesucriston', na' len beṉe' chesedop chesežag, gosazlaže' can' gwna Jacobon', na' bosoxi'e choj c̱hope beṉe' ḻježe' šja'aque' ciuda Antioquían' txen len Pablon' na' Bernabén'. Na' gosebeje' Judas ben' ḻecze gože'ne' Barsabás, na' Silas, ben' zjanac beṉe' blao len ḻegaque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na' bosozoje' to cart da' gosox̱e' beṉe' ca' žan: “Neto' postlw, len beṉe' chosogüia cheseṉe'e yezica'chle beṉe' chesonxene' Jesucriston', na' len yogo' beṉe' chesedop chesežag len neto', chguapto' le'e tiox le'e zoale Antioquían' na' distritw Siria na' distritw Cilicia. Bi nacle beṉe' Israel perw ba nac ḻježcho chonxencho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ba ṉezeto' to c̱hope beṉe' besechoj nga ja'aque' gan' zoalen' gosone' šejlaže'le len dan' bosozejni'ide', na' chacle tole dan' chesene' cheyaḻa' soale señw dan' že' circuncisión na' cheyaḻa' gonḻe yogo' bichle dan' ža ley dan' bzoj da' Moisésen'. Bi ṉezeto' gosa'aque' na' gague mandadw c̱he neto' gose'e le'e ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Da'nan' gwzoato' txen bento' yeḻa' güexi'a gwlejto' c̱hope beṉe' quinga chseḻa'to' gan' zoalen', txen len postlw Pablon' na' len Bernabén', beṉe' ca' chaquechgüeto'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ṉezeto' Pablon' len Bernabén' zan las ba ša' yesate' dan' cheso'e xtiža' X̱ancho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na' chseḻa'to' Judasen' len Silasen' cont yosozejni'ide' le'e diža' cho'a yogo' dan' bzojto' ḻe'e cart nga. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Chazlaže'to' can' bzejni'i Spiritw c̱he Diosen' neto', na' da'nan' bi gonto' mandadw bichle da' zdebe gonḻe san da' quinga chaqueto' chonen byen cbi gonḻen. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bi gagwle yeḻa' guagw dan' ba bosožie' ḻo ḻ gua'a ḻsacan' chesonxenen', na' bi gagwle be ca' chesote' chosošoque' do ḻba'ba', bi gagwle chen c̱he beyix̱e', na' bi gata'lenḻe no'ol cbi nac no'ol c̱hele o beṉe' byo ben' cbi nac beṉe' c̱hele. Na' še gwzenagle c̱he da' quinga ba gwnato' bi gonḻe, güenṉa' chonḻe še ca'. Da' na'ze chzojto' ḻe'e cart nga. Diosen' gaclenšque' le'e.” ");
INSERT INTO zpqNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Can' goquen' beṉe' ca' chesonxene' Jesucriston' Jerusalénṉa' goseseḻe' beṉe' ca' c̱hope len Pablon' na' len Bernabén' gosa'aque' zja'aque' ciuda Antioquían'. Na' cate' besežine' Antioquían' bosotobe' beṉe' ca' chesonxene' Jesucriston' na' bosonežjue' ḻegaque' carten' goseseḻa' beṉe' Jerusalén ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na' cate' beṉe' Antioquía ca' bosolaben' besyebede' ca consejon' nyoj ḻe'e carta'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Na' Judasen' len Silasen' ḻecze gosaque' bosozende' beṉe' bin' ba gwna Diosen'. Nach gosoe'lene' beṉe' Antioquía ca' diža' zan gosone' c̱hac̱h laže'gaque' na' gosaclene' ḻegaque' cont gosonxenche' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Gosenite' Antioquían' zan ža, nach cate' bžin ža šjaya'aque', beṉe' Antioquía ca' gose'e ḻegaque': “Nayežagcho”, na' ḻecze gose'e ḻegaque' yesyežine' Jerusalénṉa' to šagüe' to güen. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Na' Silasen' bec̱hoglaže' yega'aṉe' Antioquían'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na' Pablon' len Bernabén' gosenita'cze' Antioquían' na' txen len yezan beṉe' bosozejni'ide' beṉe' xtiža' X̱ancho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nach cate' ba goc sša nite' Antioquían', Pablon' gože' Bernabén': ―Šejcho da' yoble yogo' yež ca' gan' ba jatix̱jue'echo xtiža' X̱ancho Jesucriston' šjaṉa'cho nac cheson beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nach Bernabén' goclaže' šja'aque' na' yesec̱he'e Juan ben' ḻecz le Marcos. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Perw Pablon' gwne' bi gonen güen yesec̱he'ene' dan' gwlejyic̱hj Marcosen' ḻegaque' cate' besežine' distritw Panfilian' na' bi benḻene' ḻegaque' xšin Diosen'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Cate' gota'bia' ṉe toe' bi goclaže' gac can' ža ben' yeto, nach besyele'e. Bernabén' gwze'e gwc̱he'e Marcosen' na' goso'e ḻo' barcw ja'aque' Chipren'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Na' Pablon' gwleje' Silasen' cont c̱he'e ḻe'. Na' beṉe' ca' chesonxene' Jesucriston' Antioquían' bosoḻ güiže' X̱ancho Diosen' goseṉabe' gaclene' ḻegaque' gate'tez šja'aque'. Nach Pablon' len Silasen' gosa'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na' ja'aque' to to yež ca' zjachi' distritw Sirian' na' len distritw Cilician' gosone' c̱hac̱h laže' beṉe' ca' chesedop chesežag chesonxene' Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Na' Pablon' len Silasen' besyežine' yež Derben' nach gwdena' besyežine' yež Listran'. Na' Listran' zoa to beṉe' chonxene' Jesucriston' le' Timoteo. Xṉa' Timoteon' naque' beṉe' Israel na' chonxene' Jesucriston', na' x̱en' naque' beṉe' griego. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Na' beṉe' ca' chesonxene' Jesucriston' yež Listran' len yež Iconion' cheso'e diža' c̱he Timoteon' chesene' zoacze' chone' da' güen. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Da'nan' Pablon' gwṉabe' šejlen Timoteon' ḻegaque', nach gwc̱hi'ene' gan' bosozoe' ḻe' señw dan' že' circuncisión. Bene' ca' ḻe yogo' beṉe' že' na' goseṉezde' x̱a Timoteon' bi naque' beṉe' Israel na' Timoteon' biṉa' soe' señon', na' ḻecze Pablon' goclaže' yega'aṉe' güen len beṉe' Israel ca'. Cate' beyož bzoe'ne' señua' na' gosa'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na' to to yež ga besežine' bosozende' beṉe' ca' chesonxene' Jesucriston' can' nac yeḻa' güexi'a c̱he postlw ca' len beṉe' chosogüia cheseṉe'e ḻježgaque' Jerusalénṉa' c̱he da' ca' cheyaḻa' yesone'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Na' beṉe' ca' chesedop chesežag chesonxene' Jesucriston' gosenita'c̱hac̱he' gosejnilaže'ne' na' gwyanche' tža tža. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nach Spiritw c̱he Diosen' bi ben' latje šjasedix̱jue'e Pablon' len Silasen' len Timoteon' xtiža' Diosen' yež ca' zjachi' distritw gan' nzi' Asia. Da'nan' gosedie' yež ca' zjachi' distritw ca' gan' nzi' Frigia na' Galacia. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Besežinte' gaḻa'ze distritw gana' nzi' Misia na' gosone' xbab yeso'e distritw da' nzi' Bitinia, perw ḻez na' bi be' Spiritw c̱he Jesúsen' latje šja'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nach gosedie' gaḻa'ze distritw Misian' na' besežine' ciuda dan' nzi' Troas dan' chi' cho'a nisdaon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nach že'na' Pablon' ble'edagüede' zecha to beṉe' distritw Macedonia lagüe', che'e ḻe': “Yo'o Macedonia cont gacleno' neto'.” ");
INSERT INTO zpqNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Neda' Lucas gwzoa' len ḻegaque' na' da' ble'edagüe Pablon' beṉe' Macedonian', nach gwṉezeto' chaclaže' Diosen' šjazeneto' beṉe' Macedonia ca' diža' güen c̱he X̱ancho Jesucriston'. Nach bsiṉi'a c̱heto' cont gwza'to' gwyejto' distritw Macedonian'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Na' cate' gwza'to' ciuda da' nzi' Troas dan' chi' cho'a nisdao' gwyo'oto' to ḻo' barcw zejto' ḻicha gan' chi' to yežlio ḻo' nisen' dan' nzi' Samotracia, nach beteyo bžinto' yežen' dan' nzi' Neápolis. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nach gwza'to' Neápolis bžinto' ciudan' nzi' Filipos gan' mbane distritw Macedonia na' bega'aṉto' to c̱hop ža. Filipos naquen ciuda blaoch c̱he distriton' gan' že' beṉe' Roma. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na' cate' bžin ža c̱he Dios bchojto' ciudan' na' gwyejto' cho'a yegw gan' chaqueto' chjaseḻ güiže' Diosen', nach gwche'to' na' be'lento' no'ol ca' ba zjandoben' diža' güen c̱he Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Toe' le Lidia naque' beṉe' Tiatira na' chote' lache' güen da' nac color moradw, na' chonxene' Diosen' do yic̱hj do laže'. X̱ancho Diosen' bene' cont bzenague' c̱he dan' bzejni'i Pablon' ḻe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nach ḻe' len beṉe' ḻo' yo'o c̱he' gosezoe' nis. Gwdena' gota'yoede' neto' gwne': ―Še chejḻe'le da' ḻi ba chonxena' X̱ancho Jesucriston', ḻe šo'o soale ližan'. Nach gwyejto' jasoato' ližen', ḻe bene' byen. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na' to ža zejto' gan' chosoḻ güiže' Diosen' cate' bežagto' to no'ol güego' no'ole esclava. Yo'o nyaz da' x̱igüen' yic̱hjlažda'oben' chonen cont chac chṉeya'abe', na' gan xen chombe' par x̱ambe' ca' chṉeya'abe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Na' ḻebe' na'obe' neto' len Pablon' gate'tez zejto', na' chosya'abe' žabe': ―Beṉe' quinga chesone' xšin Diosen' ben' chnabi'e doxen, na' cheseyix̱jue'ede' le'e can' gata' yeḻa' mban c̱hele toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ba chac zan ža chombe' ca' cate' goque Pablon' zed, na' gwyec̱hje' gože' da' x̱igüen' yo'o ḻo' yic̱hjlažda'oben': ―Len yeḻa' chnabia' c̱he Jesucriston' chnia' le' bechoj ḻo' yic̱hjlaždao' bi'nga. Na' ḻa' bechojte da' x̱igüen' ḻo' yic̱hjlažda'oben'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Na' gwdena' cate' gosacbe'e x̱ambe' ca' ba bechoj da' x̱igüen' ḻo' yic̱hjlažda'oben' na' bich bi gan yesone' len ḻebe', nach gosezene' Pablon' len Silasen' na' jasesane' ḻegaque' lagüe ya'a gan' že' beṉe' ca' chesenabia' ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na' cate' besežine' gan' že' justis ca', gose'e ḻegaque': ―Beṉe' Israel quinga chesaše' chesebeque' da' zed ḻo' ciuda nga. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Na' chosolo'ede' costumbr da' bi de ḻsens gao' chio' naccho beṉe' Roma. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nach beṉe' ca' ḻo ciudan' gosase' contr Pablon' len Silasen', na' beṉe' gwnabia' ca' gosone' mandadw goseḻec̱hje' xagaque' cont goseyine' ḻegaque' xis. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Beyož goseyinchgüe' ḻegaque' nach bosoži'e ḻegaque' ḻižya, chese'e ben' chape' ḻižyan' gwṉa'yaṉe' ḻegaque' cont bi yesyechoje'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Beyož gose'e ḻe' ca', nach bži'e ḻegaque' ḻo' cuart ḻižyan' dan' zoa ḻa'zelaoze gan' nac biže'te na' bc̱hide' ṉi'agaquen' len yag dan' nzi' cepo. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ca' gosenita' Pablon' len Silasen' ca do chel, chosoḻ güiže' Diosen' na' chesoḻe' no himno chesonxene' Diosen', na' yezica'chle beṉe' ca' zjade ḻižyan' chosozenague'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nach zejzenez ḻeca gwxo' na' bsesechguan len yo'o ḻižyana'. Na' to ši'ize yogo' puert c̱he ḻižyana' beseyaljon na' besyeyež yogo' gden ca' dan' zjanchej ṉi'a na' beṉe' ca' že' ḻo' ḻižyan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bosbanen ben' chape' ḻižyan' na' cate' ble'ede' ba zjanyaljo puert ca', ḻa' goḻjte spada c̱hen' cont yeyot cuine', ḻe bene' xbab ba bosyoxoṉj yogo' beṉe' ca' zjade ḻižyan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nach Pablon' gože'ne' zižje: ―Bibi gone cuino'. Nga zoacze yogo'to'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nach ben' chap ḻižyan' gwṉabe' to yi', na' gwyo'osese' zjaṉe'e gan' de Pablon' len Silasen'. Do chxizze' bzoa xibe' lao beṉe' ca', ḻe chžebchgüe'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na' ḻa' bebejte' ḻegaque' ḻo cuart gan' zjayo'en', che'e ḻegaque': ―¿Bi cheyaḻa' gona' cont gata' yeḻa' mban c̱hia' toḻi tocaṉe? ");
INSERT INTO zpqNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nach gose'e ḻe': ―Gwyejnilaže' X̱ancho Jesucriston', le' na' beṉe' ḻo' yo'o c̱hio', na' gata' yeḻa' mban c̱hele toḻi tocaṉe. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nach ben' chape' ḻižyan' gwc̱he'e ḻegaque' ližen' na' gosoe'lene' ḻe' len beṉe' ḻo' yo'o c̱hen' xtiža' X̱ancho Jesucriston'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nach ca hora' ben' chap ḻižyan' gwdibe' ḻo güe' c̱he Pablon' na' c̱he Silasen', na' gwdena' jasoe' nis len beṉe' ḻo' yo'o c̱he' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nach ben' chape' ḻižyan' bec̱he'e Pablon' len Silasen' liže' bgüe'ej bguagüe' ḻegaque'. Mbalaz zoe' ba chejnilaže' Diosen' txen len beṉe' ḻo' yo'o c̱he'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Cate' ba gwyeni' beṉe' gwnabia' ca' goseseḻe' x̱a'ag jaseže' ben' chap ḻižyan' yosane' beṉe' ca' šjaya'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nach ḻe' gože' Pablon': ―Beṉe' gwnabia' ca' bac̱h goseseḻe' rson yosana' le'e. Guac yeyejle to šagüe' to güen. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nach Pablon' gože' x̱a'ag ca': ―Ba goseyine' neto' latje lagüe ya'a sin cbi gosone' yeḻa' justis c̱heto' še bi nonto' na' gosegüe'e neto' ḻižya, ḻen nacto' beṉe' nación Roma. ¿Na' chesone' xbab yososane' neto' šižize? Bi gac, san yesid cuine' yesyebeje' neto'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nach x̱a'ag ca' jasyeyeže' beṉe' gwnabia' ca' can' gož Pablon' ḻegaque'. Na' beṉe' ca' besežebe' cate' goseṉezde' Pablon' len Silasen' zjanaque' beṉe' nación Roma. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nach beṉe' gwnabia' ca' ja'aque' gan' zjade Pablon' len Silasen' na' gosata'yoede' ḻegaque' yesyezi'xene' can' ba goquen', na' diža' šagüe' gose'e ḻegaque' yesyechoje' yesyeya'aque' ḻo ciudan'. ");
INSERT INTO zpqNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nach bechoj Pablon' len Silasen' ḻižyan' na' ja'aque' liž Lidian' da' yoble, na' da' yoble gosone' c̱hac̱h laže' beṉe' ca' chesonxene' Jesucriston' na' beyožen' besyeya'aque'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Cate' Pablon' na' Silasen' gosa'aque' ciuda Filipos nach ja'aque' yež da' nzi' Anfípolis na' len yež da' nzi' Apolonia na' besyežine' to ciuda da' nzi' Tesalónica gan' zoa to yodao' c̱he beṉe' Israel. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Na' Pablon' ca costumbr c̱he' gwyeje' yodao' ža c̱he Dios. Na' ca' goc, šoṉe ža c̱he Dios be'lene' ḻegaque' diža'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bzejni'ide' ḻegaque' gože'ne' beṉe' ca' goso'e xtiža' Diosen' cani' bosozoje' xtiža' Criston'. Gosene' ben' seḻa' Dios yedeṉabi'e, cheyaḻa' yosoc̱hi yososaca' beṉe' ḻe' na' yesote'ne' na' techle yeyas yebane' ladjo beṉe' guat ca'. Gože' beṉe' Tesalónican': ―Jesúsen' ben' choa' diža' c̱he', ḻe'na' Criston' ben' gwseḻa' Dios cont ṉabi'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nach baḻ beṉe' Israel gosejḻe'e xtiža' Pablon' len Silasen' na' gosaque' txen len ḻegaque', na' ḻecze zan beṉe' griego beṉe' chesonxen Diosen' na' zan no'ole blao ḻecze gosejḻe'e. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Perw gwnita'ch beṉe' Israel beṉe' bi chesejḻe'e xtiža' Diosen'. Ḻegaque' gosacxi'ede' Pablon' len Silasen' na' bosyotobe' x̱oṉj beṉe' mal beṉe' chesaš lagüe ya'a na' gosaque' txen gosone' cont gwche' žaš doxen ciudan'. Nach beṉe' že' ḻo ciudan' ja'aque' liž ben' le' Jasón chesacde' yesyebeje' Pablon' len Silasen' liže'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Cate' besežine' liž Jasónṉa', noch no beṉe' ca' nita'. Nach cate' bi besyeželde' Pablon' len Silasen', na' gosox̱e' Jasónṉa' len yebaḻ beṉe' chesonxene' Jesuscriston' na' gosec̱he'e ḻegaque' lao beṉe' ca' chesenabia' ciudan', na' bososye'e gosene': ―Beṉe' ca' nita' liž benga chesaše' chesebeque' da' zed doxen, na' ṉa'a ba besele'e gan' zoacho nga. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón ni ba blebe' ḻegaque' ližen', na' bi chesone' can' ža ley c̱he César ben' nac ḻa'zelagüe beṉe' gwnabia' c̱hechon' chi' ciuda Roman', na' chesene' zoa yeto rey beṉe' le Jesús beṉe' ṉabi'e chio'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Na' cate' gosende' diža'na', beṉe' ḻo ciuda ca' len beṉe' gwnabia' c̱hegaque' ca' gosebecche' žaš. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nach Jasónṉa' len beṉe' ḻježe' ca' bosožie' mechw cont beṉe' gwnabia' ca' bososane' ḻegaque', con še bich yesyežin Pablon' na' Silasen' ḻo ciudan', chesene'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nach že'na' beṉe' ca' chesonxene' Jesucriston' lagüe ciuda Tesalónican' bosyose'e Pablon' na' Silasen' cont ja'aque' yež gan' že' Berea. Na' cate' besyežine' nach ja'aque' ḻo' yodao' c̱he beṉe' Israel ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na' beṉe' Israel ca' že' Berean' zjanacche' beṉe' šagüe' clel ca beṉe' Israel ca' že' Tesalónican' na' besyebede' bosozenague' xtiža' Jesucriston' dan' bosozejni'i Pablon' len Silasen' ḻegaque'. Na' tža tža besyeyiljue' gan' nyoj da' ca' bosozejni'i beṉe' ca', cont yeseṉezde' še ḻe can' žan. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na' zane' gosejḻe'e xtiža' X̱ancho Jesucriston' na' ḻecze zan beṉe' griego ca' na' zan no'ole blao. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nach beṉe' Israel ca' že' Tesalónican' beṉe' ca' cbi chesejḻe' c̱he Jesucriston', gosende' diža' ba zoa Pablon' len Silasen' Berean' chosozejni'ide' xtiža' Diosen'. Nach gosa'aque' ja'aque' Berean' na' gosone' cont beṉe' Berea ca' ḻecz gosone' contr Pablon'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Perw na' beṉe' Berea ca' chesejnilaže' Jesucriston' ḻa' bososa'te' Pablon' gwyeje' cho'a nisdao'. Na' ca nac Silasen' len Timoteon', ḻegaque' besyega'aṉe' Berean'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na' to c̱hop beṉe' Berean' ja'aque' jasesane' Pablon' ciuda dan' nzi' Atenas. Na' cate' besyeya'aque' jaya'aque' Berean' Pablon' gwseḻe' rson len ḻegaque' cont Silasen' len Timoteon' ḻecz šja'aque' cate gan' zoe'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Na' Pablon' šlac zoe' ciuda Atenasen' chbeze' žin Silasen' len Timoteon', gocchgüe' tole ḻo' yic̱hjlažda'ogüe' da' ble'ede' da' zan ḻ gua'a ḻsaca' da' chesejnilaže' beṉe' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Da'nan' bzejni'ide' beṉe' Israel ca' ḻo' yodao' c̱hegaque'na' len yezica'chle beṉe' ca' chesonxene' Diosen'. Na' yogo' ža gwyeje' ga chac ya'a je'e xtiža' Diosen' len beṉe' ca' že'na'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nach beṉe' ca' že'na' gwzolao chesoe'lene' ḻe' diža'. Baḻe' chesejḻe'e dan' bzejni'i to beṉe' le' Epicuro, na' yebaḻe' chesejḻe'e dan' bosozoj beṉe' ca' chesene' estoico. Na' baḻe' gosene': ―¿Bin' chon ža benga? Na' yebaḻe' gosene': ―Chacḻjede' gwzejni'ide' chio' c̱he no beṉe' cobe beṉe' šejnilaže'cho. Gosene' ca' ḻe Pablon' ba bzejni'ide' ḻegaque' xtiža' Jesúsen' na' ba be'e diža' Jesúsen' bebane' ladjo beṉe' guat. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nach gosec̱he'e Pablon' to latje dan' nzi' Areópago gan' chesedobe beṉe' blao c̱hegaque' cate' chosoxi'e bi da' chesone'. Nach gose'e Pablon': ―Che'neto' gwzejni'ido' neto' bi da' coben' dan' chsed chlo'edo'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Biṉa' yeneto' diža' can' nac dan' cho'o nga na' chaclaže'to' ṉezeto' bi zejen yogo' da' ca'. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ca nac beṉe' Atenas ca', de costumbr c̱hegaque' yogo' ža con chesaše' cheso'e diža' o chosozenague' c̱he bi da' cobe da' de, na' ḻecz ca' cheson no beṉe' zito' že' Atenas. ");
INSERT INTO zpqNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nach Pablon' gwzeche' gachoḻ ḻegaque' gan' chesone' yeḻa' güexi'a na' gože' ḻegaque': ―Le'e beṉe' Atenas, chacbe'eda' ḻeca chejnilaže'le zan ḻ gua'a ḻsaca'. ");
INSERT INTO zp